/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000021690ULL, 0x0000000000021210ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001f690ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001f800ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000001f840ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000001f880ULL,
0x0000000000000100ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001f980ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001f69000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x007c3c0400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9308288080900828ULL, 0x2880809408288080ULL, 0x8098082880809608ULL, 0x082880809a082880ULL,
0x8080a0082880809bULL, 0xa308288080a20828ULL, 0x288080b008288080ULL, 0x80b308288080b208ULL,
0x08288080dc082880ULL, 0x8082801628808084ULL, 0x0000000000031028ULL, 0x2880808492000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001f69000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0x9408288080930828ULL, 0x2880809608288080ULL, 0x809a082880809808ULL, 0x082880809b082880ULL,
0x8080a208288080a0ULL, 0xb008288080a30828ULL, 0x288080b208288080ULL, 0x80dc08288080b308ULL,
0x1628808088082880ULL, 0x0000031028808280ULL, 0x8892000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000013000000000ULL, 0x0001f80000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9308288080900828ULL,
0x2880809408288080ULL, 0x8098082880809608ULL, 0x082880809a082880ULL, 0x8080a0082880809bULL,
0xa308288080a20828ULL, 0x288080b008288080ULL, 0x80b308288080b208ULL, 0x16288080dc082880ULL,
0x0000031028808280ULL, 0xdc92000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x000001e800000000ULL, 0x0001f84000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9308288080900828ULL, 0x2880809408288080ULL,
0x8098082880809608ULL, 0x082880809a082880ULL, 0x8080a0082880809bULL, 0xa308288080a20828ULL,
0x288080b208288080ULL, 0x80dc08288080b308ULL, 0x16288080b0082880ULL, 0x0000031028808280ULL,
0xb092000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x000002a000000000ULL,
0x0001f88000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL,
0x00081204000000f4ULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x0001ddd00001db90ULL, 0x0001df500001dde0ULL,
0x0001df700001df60ULL, 0xffffffff01c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500006affffffffULL, 0x0500006a0500006aULL,
0xffffffff0500006aULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01c82804ffffffffULL, 0x000000f0000000d0ULL,
0x00001870000017f0ULL, 0x0000194000001910ULL, 0x00001d5000001d20ULL, 0x00001e3000001dc0ULL,
0x0000442000004400ULL, 0x000044e000004480ULL, 0x00006ae000006a60ULL, 0x00006cb000006b90ULL,
0x00006f9000006f70ULL, 0x0000705000006ff0ULL, 0x00009400000093e0ULL, 0x000094c000009460ULL,
0x0000ba400000b9c0ULL, 0x0000bc100000baf0ULL, 0x0000bef00000bed0ULL, 0x0000bfb00000bf50ULL,
0x0000e3500000e330ULL, 0x0000e4100000e3b0ULL, 0x0001099000010910ULL, 0x00010b6000010a40ULL,
0x00010e4000010e20ULL, 0x00010f0000010ea0ULL, 0x000132d0000132b0ULL, 0x0001339000013330ULL,
0x0001537000015360ULL, 0x0001761000015af0ULL, 0x00017df000017760ULL, 0x0001866000017e20ULL,
0x0001d8200001d7f0ULL, 0x0001d8400001d830ULL, 0x0001d8800001d860ULL, 0x0001d8b00001d8a0ULL,
0x0001dfa00001df40ULL, 0x0001dfc00001dfb0ULL, 0x0001e7200001e6d0ULL, 0x0001e7e00001e780ULL,
0x0001e8b00001e840ULL, 0x0001e9800001e910ULL, 0x0001ea200001e9d0ULL, 0x0001eae00001ea80ULL,
0x0001eba00001eb30ULL, 0x0001ec700001ec00ULL, 0x0001ed100001ecc0ULL, 0x0001edd00001ed70ULL,
0x0001ee900001ee20ULL, 0x0001ef600001eef0ULL, 0x0001f0000001efb0ULL, 0x0001f0c00001f060ULL,
0x0001f1800001f110ULL, 0x0001f2500001f1e0ULL, 0x0001f3100001f2b0ULL, 0x0001f3b00001f360ULL,
0x0001f4500001f400ULL, 0x0001f4f00001f4a0ULL, 0x0001f5c00001f550ULL, 0x0001f6600001f610ULL,
0x000001e007003904ULL, 0x00010600000000ffULL, 0x00000240003f0100ULL, 0x000106080000000dULL,
0x000002f0003f0120ULL, 0x000106880000000dULL, 0x00000390003f0120ULL, 0x000106a80000000dULL,
0x000003d0003f0120ULL, 0x000106b8000000ffULL, 0x000004f0003f0100ULL, 0x00010600000000ffULL,
0x00000690003f0107ULL, 0x0001068c00000027ULL, 0x00000740003f0102ULL, 0x0001068800000027ULL,
0x00000c70003f0101ULL, 0x000106a8000000ffULL, 0x00000cf0003f0107ULL, 0x000106a8000000ffULL,
0x00000d50003f0101ULL, 0x000106b8000000ffULL, 0x00000ec0003f0101ULL, 0x000106bc000000ffULL,
0x00000f10003f0105ULL, 0x000106bc000000ffULL, 0x00000f90003f0105ULL, 0x000106bc000000ffULL,
0x00001560003f0105ULL, 0x000106b0000000ffULL, 0x000015e0003f0107ULL, 0x000106b0000000ffULL,
0x000015f0003f0101ULL, 0x000106ac000000ffULL, 0x00001660003f0105ULL, 0x0001060800000027ULL,
0x00001680003f0101ULL, 0x0001060c00000027ULL, 0x00001710003f0105ULL, 0x0001060c00000027ULL,
0x00001c00003f0105ULL, 0x000106ac000000ffULL, 0x00001c80003f0105ULL, 0x000106ac000000ffULL,
0x00003d20003f0105ULL, 0x000106b8000000ffULL, 0x00003d30003f0101ULL, 0x000106bc000000ffULL,
0x00003d80003f0105ULL, 0x000106bc000000ffULL, 0x00003e00003f0105ULL, 0x000106bc000000ffULL,
0x00004200003f0105ULL, 0x000106a8000000ffULL, 0x00004280003f0107ULL, 0x000106a8000000ffULL,
0x00004290003f0101ULL, 0x000106b4000000ffULL, 0x000042f0003f0105ULL, 0x000106b4000000ffULL,
0x00004370003f0105ULL, 0x000106b4000000ffULL, 0x000062e0003f0105ULL, 0x000106b8000000ffULL,
0x00006350003f0101ULL, 0x00010688000000ffULL, 0x00006380003f0101ULL, 0x000106bc000000ffULL,
0x000063d0003f0105ULL, 0x000106bc000000ffULL, 0x00006450003f0105ULL, 0x000106bc000000ffULL,
0x00006820003f0105ULL, 0x000106b0000000ffULL, 0x000068a0003f0107ULL, 0x000106b0000000ffULL,
0x000068b0003f0101ULL, 0x000106ac000000ffULL, 0x00006920003f0105ULL, 0x0001062800000027ULL,
0x00006940003f0101ULL, 0x0001062c00000027ULL, 0x000069d0003f0105ULL, 0x0001062c00000027ULL,
0x00006e60003f0105ULL, 0x000106ac000000ffULL, 0x00006ee0003f0105ULL, 0x000106ac000000ffULL,
0x00008df0003f0105ULL, 0x000106b8000000ffULL, 0x00008e00003f0101ULL, 0x000106bc000000ffULL,
0x00008e50003f0105ULL, 0x000106bc000000ffULL, 0x00008ed0003f0105ULL, 0x000106bc000000ffULL,
0x000091e0003f0105ULL, 0x000106a8000000ffULL, 0x00009260003f0107ULL, 0x000106a8000000ffULL,
0x00009270003f0101ULL, 0x000106b4000000ffULL, 0x000092d0003f0105ULL, 0x000106b4000000ffULL,
0x00009350003f0105ULL, 0x000106b4000000ffULL, 0x0000b240003f0105ULL, 0x000106b8000000ffULL,
0x0000b2b0003f0101ULL, 0x00010690000000ffULL, 0x0000b2e0003f0101ULL, 0x000106bc000000ffULL,
0x0000b330003f0105ULL, 0x000106bc000000ffULL, 0x0000b3b0003f0105ULL, 0x000106bc000000ffULL,
0x0000b780003f0105ULL, 0x000106b0000000ffULL, 0x0000b800003f0107ULL, 0x000106b0000000ffULL,
0x0000b810003f0101ULL, 0x000106ac000000ffULL, 0x0000b880003f0105ULL, 0x0001064800000027ULL,
0x0000b8a0003f0101ULL, 0x0001064c00000027ULL, 0x0000b930003f0105ULL, 0x0001064c00000027ULL,
0x0000bdc0003f0105ULL, 0x000106ac000000ffULL, 0x0000be40003f0105ULL, 0x000106ac000000ffULL,
0x0000dd40003f0105ULL, 0x000106b8000000ffULL, 0x0000dd50003f0101ULL, 0x000106bc000000ffULL,
0x0000dda0003f0105ULL, 0x000106bc000000ffULL, 0x0000de20003f0105ULL, 0x000106bc000000ffULL,
0x0000e130003f0105ULL, 0x000106a8000000ffULL, 0x0000e1b0003f0107ULL, 0x000106a8000000ffULL,
0x0000e1c0003f0101ULL, 0x000106b4000000ffULL, 0x0000e220003f0105ULL, 0x000106b4000000ffULL,
0x0000e2a0003f0105ULL, 0x000106b4000000ffULL, 0x00010190003f0105ULL, 0x000106b8000000ffULL,
0x00010200003f0101ULL, 0x00010698000000ffULL, 0x00010230003f0101ULL, 0x000106bc000000ffULL,
0x00010280003f0105ULL, 0x000106bc000000ffULL, 0x00010300003f0105ULL, 0x000106bc000000ffULL,
0x000106d0003f0105ULL, 0x000106b0000000ffULL, 0x00010750003f0107ULL, 0x000106b0000000ffULL,
0x00010760003f0101ULL, 0x000106ac000000ffULL, 0x000107d0003f0105ULL, 0x0001066800000027ULL,
0x000107f0003f0101ULL, 0x0001066c00000027ULL, 0x00010880003f0105ULL, 0x0001066c00000027ULL,
0x00010d10003f0105ULL, 0x000106ac000000ffULL, 0x00010d90003f0105ULL, 0x000106ac000000ffULL,
0x00012c90003f0105ULL, 0x000106b8000000ffULL, 0x00012ca0003f0101ULL, 0x000106bc000000ffULL,
0x00012cf0003f0105ULL, 0x000106bc000000ffULL, 0x00012d70003f0105ULL, 0x000106bc000000ffULL,
0x000130b0003f0105ULL, 0x000106a8000000ffULL, 0x00013130003f0107ULL, 0x000106a8000000ffULL,
0x00013140003f0101ULL, 0x000106b4000000ffULL, 0x000131a0003f0105ULL, 0x000106b4000000ffULL,
0x00013220003f0105ULL, 0x000106b4000000ffULL, 0x00015110003f0105ULL, 0x000106b8000000ffULL,
0x00015170003f0101ULL, 0x000106a0000000ffULL, 0x000189a0003f0101ULL, 0x00010600000000ffULL,
0x000197a0003f0101ULL, 0x00010604000000ffULL, 0x00019840003f0105ULL, 0x00010604000000ffULL,
0x00019b60003f0105ULL, 0x00010600000000ffULL, 0x00019b70003f0101ULL, 0x00010604000000ffULL,
0x00019c00003f0105ULL, 0x00010604000000ffULL, 0x0001cc50003f0105ULL, 0x000000000000003dULL,
0x0001cc90003f0101ULL, 0x000000040000003dULL, 0x0001d0f0003f0105ULL, 0x000000040000003dULL,
0x0001e530003f0105ULL, 0x000000000000003fULL, 0x0001e590003f0101ULL, 0x000000080000003fULL,
0x0001e5f0003f0101ULL, 0x000000100000003fULL, 0x0001e660003f0101ULL, 0x000000180000003fULL,
0x00053803003f0101ULL, 0x000188b000101c04ULL, 0x00019d1000019c60ULL, 0x000004010001e6a0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL,
0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000344ULL, 0x0000001200000002ULL, 0x000000000000028cULL,
0x0000001200000002ULL, 0x00000000000001d4ULL, 0x0000001200000002ULL, 0x000000000000011cULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000031eULL,
0x0000001200000002ULL, 0x0000000000000266ULL, 0x0000001200000002ULL, 0x00000000000001aeULL,
0x0000001200000002ULL, 0x00000000000000f3ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000027919ULL, 0x000ea20000002300ULL, 0x0000000304057899ULL, 0x000fe4000800063fULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x0000000000057919ULL, 0x000f280000000000ULL, 0x00000000005b7919ULL, 0x000f680000002600ULL,
0x00000000003e7919ULL, 0x000f220000002700ULL, 0x00000005ff2e7819ULL, 0x002fc6000001160dULL,
0x00000000002d7919ULL, 0x000e680000000000ULL, 0x00001fff020f7589ULL, 0x0045e200000e0000ULL,
0x0000000102007824ULL, 0x008fc600078e0203ULL, 0x00001fff2e2e7589ULL, 0x000ee200000e0000ULL,
0x00000080000d7824ULL, 0x000fe400078e020dULL, 0x0000001200007300ULL, 0x000f2600000e0000ULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x0000000f0d00780cULL, 0x040fe40003f44070ULL,
0x0000007f0d00780cULL, 0x040fe20003f84070ULL, 0x0000001200127309ULL, 0x000f620000000000ULL,
0x000000030d00780cULL, 0x000fe20003f64070ULL, 0x000000102d0c7824ULL, 0x002fe200078e00ffULL,
0x000000050000720cULL, 0x010fca0003f02070ULL, 0x3fffff80ff029424ULL, 0x004fe400078e00ffULL,
0x000000040f007824ULL, 0x008fe400078e022eULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x0000000200007824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL,
0x01060002ff009388ULL, 0x0003e20000000a00ULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x0000000800097817ULL, 0x040fe20007800000ULL, 0xff317217ff0ac424ULL, 0x000fe200078e00ffULL,
0x00000001000e7810ULL, 0x000fe20007ffe0ffULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x010608040d00a388ULL, 0x0005e20000008a00ULL, 0x000000010d00780cULL, 0x000fe20003f44070ULL,
0x0000000109087824ULL, 0x100fe200078e0a00ULL, 0x000000070e107812ULL, 0x000fe200078ec0ffULL,
0x000000085b097824ULL, 0x020fe200078e00ffULL, 0x0000000700027812ULL, 0x002fe200078ec0ffULL,
0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL, 0x0104000a0d00c388ULL, 0x0003e20000004800ULL,
0x000000053e097c24ULL, 0x000fe2000f8e0209ULL, 0x0000001f02037812ULL, 0x100fe200078e782dULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x010688060d00b388ULL, 0x0007e20000008a00ULL,
0x000000ff0800720cULL, 0x040fe20003f63070ULL, 0x0000000109027824ULL, 0x040fe200078e0200ULL,
0x000000010800780cULL, 0x000fe20003f83070ULL, 0x0000000109047824ULL, 0x004fe200078e020eULL,
0x0000001f10117812ULL, 0x000fe200078e782dULL, 0x3fffff00ff08a424ULL, 0x000fc400078e00ffULL,
0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0a9424ULL, 0x002fe400078e00ffULL,
0x00000200ff057424ULL, 0x000fe200078e00ffULL, 0x0106a8080d00a388ULL, 0x0003e20000008a00ULL,
0x0000002000007824ULL, 0x000fe200078e0203ULL, 0x000001f00c077812ULL, 0x008fe200078ec0ffULL,
0x00005c0002027625ULL, 0x080fe200078e0005ULL, 0x0106b80aff009388ULL, 0x0005e60000000a00ULL,
0x00005c0004047625ULL, 0x000fe200078e0005ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000702067210ULL, 0x000fc40007fbe0ffULL, 0x000000200e0e7824ULL, 0x000fe200078e0211ULL,
0x0000000704047210ULL, 0x000fe20007f5e0ffULL, 0x0000001000117824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400028e0603ULL, 0x000000ffff057224ULL, 0x000fe400010e0605ULL,
0x000000100e137824ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fc400078e0a12ULL,
0x00000004ff097424ULL, 0x002fc800078e00ffULL, 0x000062003e027625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0005e8000d901c46ULL,
0x0000000004137faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01060400ffff038cULL, 0x0005e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006022c7981ULL, 0x000ee2000c1e1900ULL,
0x00000000000579c3ULL, 0x000e620000002500ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x00000005ff2b7e24ULL, 0x002fe2000f8e00ffULL, 0x0000003f2c2a7810ULL, 0x008fc40007ffe0ffULL,
0x000000ff2c297810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff2a7819ULL, 0x000fe4000001162aULL,
0x00000008ff297819ULL, 0x000fca0000011629ULL, 0x000182c000008947ULL, 0x000fea0003800000ULL,
0x000000042b287824ULL, 0x000fe400078e00ffULL, 0x000000082e277824ULL, 0x000fe400078e00ffULL,
0x00000003ff047424ULL, 0x004fe200078e00ffULL, 0x0000002a2800720cULL, 0x000fe20003f06070ULL,
0xffffffffff267424ULL, 0x000fd800078e00ffULL, 0x0000640028038a10ULL, 0x000fe20007ffe0ffULL,
0x000000023e008824ULL, 0x000fc800078e00ffULL, 0x0000640000038a24ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c0427ff738cULL, 0x0003e20000000000ULL,
0x0000600003028625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000602268981ULL, 0x0004e2000c1e1900ULL, 0x00000004ff047819ULL, 0x002fe2000001162dULL,
0x000001002b057824ULL, 0x040fe200078e00ffULL, 0x000000012b007810ULL, 0x000fe20007ffe0ffULL,
0x0106880027ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000204077810ULL, 0x040fe20007ffe0ffULL,
0xff317217ff257424ULL, 0x000fe200078e00ffULL, 0x00000004040a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000000290000720cULL, 0x000fe20003f06070ULL,
0x0000000127067824ULL, 0x040fe200078e0207ULL, 0x000000052c007217ULL, 0x000fe20007800000ULL,
0x00000001270b7824ULL, 0x000fe200078e020aULL, 0x00000006040d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000706087812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x000000070b027812ULL, 0x004fe200078ec0ffULL,
0x0000000127057824ULL, 0x000fe200078e020dULL, 0x0000000f08037812ULL, 0x100fe200078e782dULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000f02027812ULL, 0x000fe200078e782dULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000705107812ULL, 0x000fe200078ec0ffULL,
0x0000001006097824ULL, 0x000fe200078e0203ULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x0000000127067824ULL, 0x000fe200078e0204ULL, 0x0000000f10107812ULL, 0x000fe200078e782dULL,
0x000000100b0e7824ULL, 0x000fe200078e0202ULL, 0x0000000027027217ULL, 0x000fe20007800000ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000706087812ULL, 0x000fe200078ec0ffULL,
0x0000001005107824ULL, 0x000fe200078e0210ULL, 0x000000f00c117812ULL, 0x000fe200078ec0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a27ULL, 0x0000000f08037812ULL, 0x000fe200078e782dULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x000000020700720cULL, 0x080fe20003f46070ULL,
0x0000001006057824ULL, 0x000fe200078e0203ULL, 0x000000020400720cULL, 0x080fe20003f26070ULL,
0x000000405b037824ULL, 0x000fe200078e0206ULL, 0x000000020a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff457224ULL, 0x000fc600078e00ffULL, 0x0000000203077810ULL, 0x040fe40007ffe0ffULL,
0x00000004030b7810ULL, 0x000fe20007ffe0ffULL, 0x0000580026007a24ULL, 0x008fc800078e02ffULL,
0x0000004000007824ULL, 0x000fca00078e00ffULL, 0x0000000300137210ULL, 0x040fe40007f7e0ffULL,
0x0000000700077210ULL, 0x000fe40007f9e0ffULL, 0x0000000603037810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff067224ULL, 0x000fe200018e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078640ffULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x00005e00070a7a11ULL, 0x000fe400078840ffULL,
0x00005f0013137a11ULL, 0x000fc400018f4406ULL, 0x0000000b000b7210ULL, 0x040fe40007f7e0ffULL,
0x0000000300007210ULL, 0x000fe40007fbe0ffULL, 0x00005f00070f7a11ULL, 0x000fe200020f4404ULL,
0x000000ffff047224ULL, 0x000fe200018e06ffULL, 0x00005e000b067a11ULL, 0x000fe200078840ffULL,
0x000000ffff037224ULL, 0x000fe200028e06ffULL, 0x00005e0000087a11ULL, 0x000fe400078a40ffULL,
0x000000020d00720cULL, 0x000fc40003f66070ULL, 0x00005f000b077a11ULL, 0x000fe400020f4404ULL,
0x0000001211027210ULL, 0x000fe40007f9e0ffULL, 0x00005f0000007a11ULL, 0x000fe400028f4403ULL,
0x000000110a047210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff037224ULL, 0x000fe200020e0613ULL,
0x0000c000050b7811ULL, 0x000fe400078e20ffULL, 0x0000001106067210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200028e060fULL, 0x0000001108087210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e2000c901c46ULL,
0x0000c000090d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200020e0607ULL,
0x0000c0000e0f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200028e0600ULL,
0x0000c00010117811ULL, 0x000fe200078e20ffULL, 0x00000000040d7faeULL, 0x0003e8000d101c46ULL,
0x00000000060f7faeULL, 0x0003e2000c101c46ULL, 0x000000292b00720cULL, 0x000fc60003f06070ULL,
0x0000000008117faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff027f8cULL, 0x002e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff047f8cULL, 0x000ea2000c80043fULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x000143d000000947ULL, 0x000fea0003800000ULL,
0x000000042e587824ULL, 0x000fe400078e00ffULL, 0x000000023e3e7824ULL, 0x000fc400078e00ffULL,
0x00006400ff237624ULL, 0x000fe200078e00ffULL, 0x0000000258597810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x002fe400078e0003ULL, 0x000000ffff317224ULL, 0x004fe400078e0005ULL,
0x000064003e237624ULL, 0x000fe400078e0223ULL, 0xff317217ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc400078e00ffULL, 0x000001002b037824ULL, 0x000fca00078e00ffULL,
0x0000002c0300720cULL, 0x000fda0003f06070ULL, 0x000142d000000947ULL, 0x002fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000328027812ULL, 0x000fe200078ec0ffULL,
0x00000300ff007624ULL, 0x000fe400078e00ffULL, 0x0000580026047a24ULL, 0x000fe200078e02ffULL,
0x000000030200780cULL, 0x000fe20003f05270ULL, 0xfffffffd05007424ULL, 0x000fe200078e0200ULL,
0x00000004ff067819ULL, 0x000fe2000001162dULL, 0xffffffffff267424ULL, 0x000fc600078e00ffULL,
0x0000000100037807ULL, 0x000fca0004000000ULL, 0x0000000128287824ULL, 0x000fca00078e0203ULL,
0x0000002a2800720cULL, 0x000fe20003f06070ULL, 0x0000000127617824ULL, 0x000fe200078e0206ULL,
0x000000205b1c7811ULL, 0x000fe200078e30ffULL, 0x00000040040b7824ULL, 0x000fc600078e00ffULL,
0x0000000761087812ULL, 0x040fe200078ec0ffULL, 0x0000000161227824ULL, 0x000fcc00078e021cULL,
0x0000000128028824ULL, 0x000fc800078e0223ULL, 0x0000600002028625ULL, 0x000fe200078e0005ULL,
0x0000000f08087812ULL, 0x000fe400078e782dULL, 0x0000000406207810ULL, 0x000fe40007ffe0ffULL,
0x0000000602268981ULL, 0x000362000c1e1900ULL, 0x000000012b007810ULL, 0x000fe20007ffe0ffULL,
0x0000001061617824ULL, 0x000fe200078e0208ULL, 0x000000202b057811ULL, 0x000fe200078e40ffULL,
0x00000001271d7824ULL, 0x000fe200078e0220ULL, 0x000000290000720cULL, 0x000fe20003f06070ULL,
0x000000102d167824ULL, 0x000fe200078e00ffULL, 0x00000006061f7810ULL, 0x000fc40007ffe0ffULL,
0x000000052c007217ULL, 0x000fe40007800000ULL, 0x000000220b037210ULL, 0x002fe20007f3e0ffULL,
0x0000000127077824ULL, 0x000fe200078e021fULL, 0x0000000206217810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x000000f0161b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e0003087a11ULL, 0x000fe200078240ffULL,
0x0000000127057824ULL, 0x000fe200078e0221ULL, 0x00000007070a7812ULL, 0x000fc400078ec0ffULL,
0x00005f0003037a11ULL, 0x000fe200008f4402ULL, 0x00000001051e7824ULL, 0x000fe200078e021cULL,
0x000000071d027812ULL, 0x000fe400078ec0ffULL, 0x0000002000007807ULL, 0x000fe40000000000ULL,
0x0000000f02027812ULL, 0x100fe400078e782dULL, 0x0000000705047812ULL, 0x000fe400078ec0ffULL,
0x0000000f0a0a7812ULL, 0x100fe200078e782dULL, 0x000000101d5f7824ULL, 0x000fe200078e0202ULL,
0x0000000027007217ULL, 0x000fe20007800000ULL, 0x000000011d1d7824ULL, 0x100fe200078e021cULL,
0x0000000f04047812ULL, 0x000fe200078e782dULL, 0x00000001071c7824ULL, 0x000fe200078e021cULL,
0x0000001e0b097210ULL, 0x000fe20007f5e0ffULL, 0x00000010075e7824ULL, 0x000fe200078e020aULL,
0x0000001d0b077210ULL, 0x000fe20007f7e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000e000611a7811ULL, 0x000fe200078e20ffULL, 0x0000001005607824ULL, 0x000fe200078e0204ULL,
0x0000e0005f187811ULL, 0x000fe200078e20ffULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x00005e00090a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff027224ULL, 0x000fe200018e06ffULL,
0x000000000600720cULL, 0x000fc40003f26070ULL, 0x00005e0007067a11ULL, 0x000fe400078640ffULL,
0x00005f0009097a11ULL, 0x000fe400010f4404ULL, 0x0000001c0b047210ULL, 0x000fe40007f9e0ffULL,
0x00005f0007077a11ULL, 0x000fe400018f4402ULL, 0x0000001b08027210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe200020e06ffULL, 0x00005e0004087a11ULL, 0x000fc400078a40ffULL,
0x000000002000720cULL, 0x080fe20003f66070ULL, 0x000000ffff037224ULL, 0x000fe200010e0603ULL,
0x000000002100720cULL, 0x080fe40003f46070ULL, 0x000000001f00720cULL, 0x000fe40003f86070ULL,
0x00005f0004007a11ULL, 0x000fe200028f4405ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000021a7faeULL, 0x0003e2000c901c46ULL, 0x0000001b0a047210ULL, 0x080fe40007fbe0ffULL,
0x0000001b06067210ULL, 0x000fc40007f3e0ffULL, 0x0000e00060197811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200028e0609ULL, 0x0000001b08087210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0000e0005e177811ULL, 0x000fe400078e20ffULL,
0x0000000004197faeULL, 0x0003e2000d101c46ULL, 0x000000ffff097224ULL, 0x000fc600028e0600ULL,
0x0000000006187faeULL, 0x0003e8000d901c46ULL, 0x0000000008177faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff027f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff077984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080027047f8cULL, 0x000fe2000c80043fULL, 0x8000000007ff7812ULL, 0x004fc6000784485aULL,
0x01060c0027097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007824805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000060000735dULL, 0x008fe20003800000ULL, 0x01060c0027077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fc40007824805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff007819ULL, 0x000fe2000001162dULL, 0xffffffffff647424ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fe400078ec0ffULL, 0x0000000c00057812ULL, 0x000fca00078ec0ffULL,
0x0000000116167824ULL, 0x000fca00078e0205ULL, 0x0100000016007984ULL, 0x000ea80000000800ULL,
0x0102000016047984ULL, 0x0007220000000800ULL, 0x000000250000720bULL, 0x004fe20003f3d000ULL,
0x0001cec27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000057806ULL, 0x008fc800008e0100ULL,
0x0000ffff05077812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ffdb7424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff2e00720cULL, 0x000fe40003f65270ULL, 0x000000250000720bULL, 0x000fe20003f34000ULL,
0x0001ce927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000057806ULL, 0x000fe400008e0100ULL,
0x0000000025097209ULL, 0x000fe40007810000ULL, 0x0000ffff05087812ULL, 0x000fe400078e3cffULL,
0x00000002ff6c7819ULL, 0x000fe2000001162dULL, 0x010400091600b388ULL, 0x0005e20000000800ULL,
0x8000000925067221ULL, 0x000fe20000010000ULL, 0x0000000807ff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL, 0x0000000600637308ULL, 0x0004e20000000800ULL,
0x0001ce427f007947ULL, 0x000fea000b800000ULL, 0x00001f6c63057589ULL, 0x0086a400000e0000ULL,
0x000000086c6c7810ULL, 0x00afe20007ffe0ffULL, 0x0001ce727f007947ULL, 0x000fea000b800000ULL,
0x00001f6c63627589ULL, 0x0002e400000e0000ULL, 0x8000000900001221ULL, 0x100fe20000010000ULL,
0x0000006324247220ULL, 0x000fe20000410000ULL, 0x000000623b3b7220ULL, 0x08cfe20000410000ULL,
0x000000623a3a7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00001820ULL, 0x000fe20000410000ULL,
0x0000006237377220ULL, 0x080fe20000410000ULL, 0x0000006236367220ULL, 0x080fe20000410000ULL,
0x0000006243437220ULL, 0x080fe20000410000ULL, 0x0000000000151308ULL, 0x000ea20000000800ULL,
0x0000006242427220ULL, 0x080fe20000410000ULL, 0x0000006247477220ULL, 0x080fe20000410000ULL,
0x0000006246467220ULL, 0x080fe20000410000ULL, 0x000000624b4b7220ULL, 0x080fe20000410000ULL,
0x000000624a4a7220ULL, 0x080fe20000410000ULL, 0x000000624f4f7220ULL, 0x080fe20000410000ULL,
0x000000624e4e7220ULL, 0x080fe20000410000ULL, 0x0000006253537220ULL, 0x080fe20000410000ULL,
0x0000006252527220ULL, 0x080fe20000410000ULL, 0x0000006257577220ULL, 0x080fe20000410000ULL,
0x0000006256567220ULL, 0x000fe20000410000ULL, 0x00000001ffdb7807ULL, 0x000fe20000800000ULL,
0x0000000539397220ULL, 0x080fe20000410000ULL, 0x0000000538387220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x0000000534347220ULL, 0x080fe20000410000ULL,
0x0000000541417220ULL, 0x080fe20000410000ULL, 0x0000000540407220ULL, 0x080fe20000410000ULL,
0x0000000545457220ULL, 0x080fe20000410000ULL, 0x0000000544447220ULL, 0x080fe20000410000ULL,
0x0000000549497220ULL, 0x080fe20000410000ULL, 0x0000000548487220ULL, 0x080fe20000410000ULL,
0x000000054d4d7220ULL, 0x080fe20000410000ULL, 0x000000054c4c7220ULL, 0x080fe20000410000ULL,
0x0000000551517220ULL, 0x080fe20000410000ULL, 0x0000000550507220ULL, 0x080fe20000410000ULL,
0x0000000555557220ULL, 0x080fe20000410000ULL, 0x0000000554547220ULL, 0x000fe20000410000ULL,
0x000000ffff257224ULL, 0x000fe200078e0009ULL, 0x0000001504041220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002404247221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fc4000782485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000040000735dULL, 0x008fe20003800000ULL,
0x0106ac00ff057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fe4000782485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff00723eULL, 0x000fe400000010ffULL,
0x00000004ff897819ULL, 0x000fc4000001162dULL, 0x00000002ff047819ULL, 0x000fe4000001162dULL,
0x0000541000637816ULL, 0x002fe20000000000ULL, 0x0001cae27f007947ULL, 0x000fea000b800000ULL,
0x00001f0463757589ULL, 0x0002a400000e0000ULL, 0x00000008042f7810ULL, 0x000fe20007ffe0ffULL,
0x0001cb227f007947ULL, 0x000fea000b800000ULL, 0x00001f2f63747589ULL, 0x00072400000e0000ULL,
0x0000001004667810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0066ULL, 0x00001dd0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0001da7000007944ULL, 0x03cfea0003c00000ULL, 0x0000001804657810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0065ULL,
0x00001e40005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0001da0000007944ULL, 0x03cfea0003c00000ULL,
0x000000082d007812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000582d047211ULL, 0x002fe400078fe0ffULL, 0x0000000700057812ULL, 0x140fe400078ec82dULL,
0x0000000700007812ULL, 0x000fe400078ef82dULL, 0x00000004053d7212ULL, 0x000fe400078e3cffULL,
0x000000592d047211ULL, 0x000fc600078fe0ffULL, 0x00000010003f7824ULL, 0x000fe200078e023dULL,
0x0000000405117212ULL, 0x000fc800078e3cffULL, 0x0000c0003f147811ULL, 0x000fe200078e20ffULL,
0x00000010003e7824ULL, 0x040fe200078e0211ULL, 0x0000010000007811ULL, 0x000fc600078e20ffULL,
0x000000001408783bULL, 0x000e620000004200ULL, 0x0000c0003e137811ULL, 0x000fe200078e20ffULL,
0x00000001113c7824ULL, 0x100fe400078e0200ULL, 0x000000013d3d7824ULL, 0x000fe400078e0200ULL,
0x00000000130c783bULL, 0x000ee20000004200ULL, 0x0000c0003c117811ULL, 0x000fe400078e20ffULL,
0x0000c0003d127811ULL, 0x000fc600078e20ffULL, 0x000000001130783bULL, 0x000f280000004200ULL,
0x000000001204783bULL, 0x000ea20000004200ULL, 0x0000010008df7824ULL, 0x042fe200078e00ffULL,
0x0000000800e07306ULL, 0x000fe20000009400ULL, 0x0001000008e57824ULL, 0x000fe200078e00ffULL,
0x00000018ffe37819ULL, 0x000fe20000011408ULL, 0x0000010009e27824ULL, 0x040fe200078e00ffULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x0001000009d87824ULL, 0x000fe200078e00ffULL,
0x00000018ffe57819ULL, 0x000fe200000114e5ULL, 0x000001000abd7824ULL, 0x040fe200078e00ffULL,
0x0000000800e17306ULL, 0x000e620000005400ULL, 0x00000018ffe27819ULL, 0x000fe200000114e2ULL,
0x000100000abc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffba7819ULL, 0x000fe20000011409ULL,
0x000001000ecf7824ULL, 0x048fe200078e00ffULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x000100000eca7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x00000008008a7306ULL, 0x000ee2000000d400ULL, 0x00000018ffb77819ULL, 0x000fe2000001140aULL,
0x000001000cc37824ULL, 0x040fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe2000001140eULL,
0x000100000cc97824ULL, 0x000fe200078e00ffULL, 0x00000018ff007819ULL, 0x010fe20000011432ULL,
0x000001000bbe7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbc7819ULL, 0x000fe200000114bcULL,
0x000000df00ed7306ULL, 0x000fe20000209400ULL, 0x000000e1e000720bULL, 0x002fe20003fbd000ULL,
0x000001000dc27824ULL, 0x000fe200078e00ffULL, 0x00000018ffb07819ULL, 0x000fe2000001140cULL,
0x000100000bc47824ULL, 0x000fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe2000001140bULL,
0x000100000dd47824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011433ULL,
0x000000df00087306ULL, 0x0003220000205400ULL, 0x00000018ffbe7819ULL, 0x000fe200000114beULL,
0x000001000fcb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x0001000004f07824ULL, 0x004fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010005ea7824ULL, 0x000fe200078e00ffULL, 0x000000018a8a5812ULL, 0x008fe200078efcffULL,
0x000000e500ef7306ULL, 0x000fe20000209400ULL, 0x000000df00df7245ULL, 0x002fe2000020d400ULL,
0x0000010007e17824ULL, 0x000fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0000010006e07824ULL, 0x000fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fc400000114c4ULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x000000e500ee7306ULL, 0x000e620000205400ULL,
0x00000008ed00720bULL, 0x010fe20003f5d000ULL, 0x0001000033087824ULL, 0x000fe200078e00ffULL,
0x00000018ffd47819ULL, 0x000fe400000114d4ULL, 0x00000018ffca7819ULL, 0x000fe400000114caULL,
0x00000018ffaf7819ULL, 0x000fe2000001140dULL, 0x000000e300ec7306ULL, 0x000fe20000209400ULL,
0x00000018ffcb7819ULL, 0x000fc400000114cbULL, 0x00000018ff9b7819ULL, 0x000fe40000011404ULL,
0x00000018ff957819ULL, 0x000fe40000011405ULL, 0x00000001dfdf2812ULL, 0x000fe200078efcffULL,
0x000000e300eb7306ULL, 0x000ea20000205400ULL, 0x000000eeef00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff5c7819ULL, 0x000fe40000011407ULL, 0x00000018ff947819ULL, 0x000fc4000001140fULL,
0x00000018ff677819ULL, 0x000fe20000011406ULL, 0x000000e200e87306ULL, 0x000fe20000209400ULL,
0x00000018ffe07819ULL, 0x000fe400000114e0ULL, 0x00000018ffea7819ULL, 0x000fe400000114eaULL,
0x00000018ffe17819ULL, 0x000fe400000114e1ULL, 0x00000018ff7a7819ULL, 0x000fe20000011430ULL,
0x000000e200e97306ULL, 0x000e620000205400ULL, 0x000000ebec00720bULL, 0x004fc40003f7d000ULL,
0x00000018ff767819ULL, 0x000fe40000011431ULL, 0x0000008adf8a723eULL, 0x000fc600000010ffULL,
0x000000ba00bb7306ULL, 0x000ff00000209400ULL, 0x000000ba00687306ULL, 0x000fe20000205400ULL,
0x000000e9e800720bULL, 0x002fce0003f5d000ULL, 0x000000d800e67306ULL, 0x000ff00000209400ULL,
0x000000d800e77306ULL, 0x0002b00000205400ULL, 0x0000000a00a77306ULL, 0x000fe20000009400ULL,
0x000000d800d87245ULL, 0x002fce000020d400ULL, 0x0000000a00ac7306ULL, 0x000fe20000005400ULL,
0x000000e7e600720bULL, 0x004fce0003fbd000ULL, 0x0000000a00857306ULL, 0x0003ec000000d400ULL,
0x00000001d8d85812ULL, 0x000fe400078efcffULL, 0x0000000e00b37306ULL, 0x000fe20000009400ULL,
0x00010000320a7824ULL, 0x002fce00078e00ffULL, 0x0000000e00aa7306ULL, 0x000ff00000005400ULL,
0x0000000e007b7306ULL, 0x0003f0000000d400ULL, 0x0000003200877306ULL, 0x000fe20000009400ULL,
0x00000100320e7824ULL, 0x002fce00078e00ffULL, 0x0000003200867306ULL, 0x000ff00000005400ULL,
0x0000003200627306ULL, 0x0003f0000000d400ULL, 0x000000bd00d97306ULL, 0x000fe20000209400ULL,
0x000000e500327245ULL, 0x002fc8000020d400ULL, 0x0000000132326812ULL, 0x000fe400078efcffULL,
0x00000068bb00720bULL, 0x000fe20003fdd000ULL, 0x000000bd00da7306ULL, 0x000e620000205400ULL,
0x000000e200bb7245ULL, 0x000fe4000020d400ULL, 0x000000072d687812ULL, 0x000fe400078ec0ffULL,
0x00000001bbbb2812ULL, 0x000fe400078efcffULL, 0x0000000868687812ULL, 0x000fe200078ef82dULL,
0x0000000900f17306ULL, 0x000fe60000009400ULL, 0x0000000789897812ULL, 0x000fca00078e7868ULL,
0x0000000900e47306ULL, 0x000ea20000005400ULL, 0x000000dad900720bULL, 0x002fce0003f5d000ULL,
0x0000000b00a87306ULL, 0x000ff00000009400ULL, 0x0000000b00a57306ULL, 0x000e620000005400ULL,
0x000000e4f100720bULL, 0x004fe20003f9d000ULL, 0x0001000005e47824ULL, 0x000fca00078e00ffULL,
0x00000018ffe47819ULL, 0x000fe200000114e4ULL, 0x000000bc00c87306ULL, 0x000ff00000209400ULL,
0x000000bc00d17306ULL, 0x0004e20000205400ULL, 0x000000a5a800720bULL, 0x002fc40003fbd000ULL,
0x000000bd00a87245ULL, 0x000fe4000020d400ULL, 0x000000be00a57245ULL, 0x000fe4000020d400ULL,
0x00000001a8a82812ULL, 0x000fe200078efcffULL, 0x0000000c00b67306ULL, 0x000fe20000009400ULL,
0x000000bc00bc7245ULL, 0x004fce000020d400ULL, 0x0000000c00ab7306ULL, 0x000ff00000005400ULL,
0x0000000c007f7306ULL, 0x0003f0000000d400ULL, 0x0000003300837306ULL, 0x000fe20000009400ULL,
0x00000100330c7824ULL, 0x002fce00078e00ffULL, 0x0000003300827306ULL, 0x000ff00000005400ULL,
0x00000033005d7306ULL, 0x0003f0000000d400ULL, 0x000000b400b87306ULL, 0x000fe20000209400ULL,
0x000000e300337245ULL, 0x002fc4000020d400ULL, 0x00000018ffe37819ULL, 0x000fe400000114f0ULL,
0x0000000133333812ULL, 0x000fe400078efcffULL, 0x000000aca700720bULL, 0x000fe20003f7d000ULL,
0x000000b400b97306ULL, 0x000e620000205400ULL, 0x000000ba00a77245ULL, 0x000fe4000020d400ULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x00000001a7a76812ULL, 0x000fc400078efcffULL,
0x000000d1c800720bULL, 0x008fe20003fdd000ULL, 0x000000b700a07306ULL, 0x000fe20000209400ULL,
0x000000d8a733723eULL, 0x000fc600000010ffULL, 0x0000000185853812ULL, 0x000fc800078efcffULL,
0x000000b700ad7306ULL, 0x0004e20000205400ULL, 0x000000b9b800720bULL, 0x002fc60003f7d000ULL,
0x00000001bcbc6812ULL, 0x000fe400078efcffULL, 0x000000abb600720bULL, 0x000fe40003fdd000ULL,
0x0000000900887306ULL, 0x000322000000d400ULL, 0x000000b400ab7245ULL, 0x000fe4000020d400ULL,
0x000000b700b77245ULL, 0x004fc6000020d400ULL, 0x00000001abab3812ULL, 0x000fe400078efcffULL,
0x0000000b00847306ULL, 0x0004a2000000d400ULL, 0x000000ada000720bULL, 0x008fe40003f5d000ULL,
0x000000c300a07245ULL, 0x000fe4000020d400ULL, 0x00009910db097816ULL, 0x002fe200000000ffULL,
0x0000010004db7824ULL, 0x000fe200078e00ffULL, 0x000000017f7f6812ULL, 0x000fe200078efcffULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x0000000188884812ULL, 0x010fe200078efcffULL,
0x00010000060b7824ULL, 0x004fe200078e00ffULL, 0x000000aab300720bULL, 0x000fc40003fdd000ULL,
0x00000018ffdb7819ULL, 0x000fe400000114dbULL, 0x00000001b7b72812ULL, 0x000fe200078efcffULL,
0x000000be00d27306ULL, 0x000e620000205400ULL, 0x0000000184845812ULL, 0x000fe400078efcffULL,
0x000000ff0900720cULL, 0x000fe20003f25270ULL, 0x0001000007097824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fc6000001140bULL, 0x000000c300c57306ULL, 0x000fe20000209400ULL,
0x000000017b7b6812ULL, 0x000fe400078efcffULL, 0x00000018ff097819ULL, 0x000fca0000011409ULL,
0x000000c300c07306ULL, 0x000ea20000205400ULL, 0x000000d2bf00720bULL, 0x002fce0003f9d000ULL,
0x000000c900cd7306ULL, 0x000fec0000209400ULL, 0x00000001a5a54812ULL, 0x000fe400078efcffULL,
0x000000c900d07306ULL, 0x0002e20000205400ULL, 0x000000c0c500720bULL, 0x004fce0003fbd000ULL,
0x000000c200c17306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fca000020d400ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x000000c200cc7306ULL, 0x000e620000205400ULL,
0x000000d0cd00720bULL, 0x008fe40003f7d000ULL, 0x0000007fa0a0723eULL, 0x000fca00000010ffULL,
0x000000b000b27306ULL, 0x000fec0000209400ULL, 0x00000001c9c93812ULL, 0x000fe400078efcffULL,
0x000000b000a17306ULL, 0x0004e20000205400ULL, 0x000000ccc100720bULL, 0x002fce0003f5d000ULL,
0x000000c400c67306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x004fce000020d400ULL,
0x000000c400c77306ULL, 0x0002a20000205400ULL, 0x000000a1b200720bULL, 0x008fe40003fbd000ULL,
0x000000c200a17245ULL, 0x000fc8000020d400ULL, 0x00000001a1a12812ULL, 0x000fe200078efcffULL,
0x000000cf00d57306ULL, 0x000fe20000209400ULL, 0x000000c400c47245ULL, 0x002fca000020d400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x000000cf00ce7306ULL, 0x000e620000205400ULL,
0x000000c7c600720bULL, 0x004fce0003f9d000ULL, 0x000000d400d67306ULL, 0x000fec0000209400ULL,
0x00000001c4c44812ULL, 0x000fe400078efcffULL, 0x000000d400d77306ULL, 0x0004e20000205400ULL,
0x000000ced500720bULL, 0x002fe40003f7d000ULL, 0x000000c4abab723eULL, 0x000fca00000010ffULL,
0x0000000d00b57306ULL, 0x000fe20000009400ULL, 0x000000d400d47245ULL, 0x004fce000020d400ULL,
0x0000000d00a27306ULL, 0x000e620000005400ULL, 0x000000d7d600720bULL, 0x008fce0003f5d000ULL,
0x0000000f00a37306ULL, 0x000fec0000009400ULL, 0x00000001d4d42812ULL, 0x000fe400078efcffULL,
0x0000000f00a67306ULL, 0x000ea20000005400ULL, 0x000000a2b500720bULL, 0x002fe40003f9d000ULL,
0x000000cf00a27245ULL, 0x000fc8000020d400ULL, 0x00000001a2a23812ULL, 0x000fe200078efcffULL,
0x0000000d007c7306ULL, 0x0002e6000000d400ULL, 0x0000007ba2a2723eULL, 0x000fca00000010ffULL,
0x000000ca00dd7306ULL, 0x000fe20000209400ULL, 0x000100000f0d7824ULL, 0x002fe200078e00ffULL,
0x000000a6a300720bULL, 0x004fc80003fbd000ULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x000000ca00de7306ULL, 0x0002a20000205400ULL, 0x000000017c7c4812ULL, 0x008fc800078efcffULL,
0x0000007ca1a1723eULL, 0x000fe400000010ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001140aULL,
0x0000009c00107306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x002fce000020d400ULL,
0x0000009c009d7306ULL, 0x000e620000205400ULL, 0x000000dedd00720bULL, 0x004fce0003f7d000ULL,
0x000000cb00d37306ULL, 0x000fec0000209400ULL, 0x00000001caca3812ULL, 0x000fe400078efcffULL,
0x000000cb00dc7306ULL, 0x000ea20000205400ULL, 0x0000009d1000720bULL, 0x002fe20003fdd000ULL,
0x0000000868107824ULL, 0x000fe200078e0289ULL, 0x0000009c00897245ULL, 0x000fca000020d400ULL,
0x0000000f00797306ULL, 0x0002ec000000d400ULL, 0x0000000189896812ULL, 0x000fe400078efcffULL,
0x0000000400a97306ULL, 0x000fe20000009400ULL, 0x000000dcd300720bULL, 0x004fe20003f5d000ULL,
0x00000100310f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe2000001140fULL,
0x0000000400ae7306ULL, 0x000fe20000005400ULL, 0x0000000179795812ULL, 0x008fe400078efcffULL,
0x00000007210f7812ULL, 0x000fca00078e7868ULL, 0x0000000400787306ULL, 0x000fe2000000d400ULL,
0x00000008680f7824ULL, 0x000fce00078e020fULL, 0x00000005008c7306ULL, 0x000ff00000009400ULL,
0x0000000500917306ULL, 0x000ff00000005400ULL, 0x0000000500777306ULL, 0x000ff0000000d400ULL,
0x0000000d00047306ULL, 0x000ff00000209400ULL, 0x0000000d00057306ULL, 0x0002b00000205400ULL,
0x000000af00b17306ULL, 0x000fe20000209400ULL, 0x0000000d000d7245ULL, 0x002fce000020d400ULL,
0x000000af00a47306ULL, 0x0002e20000205400ULL, 0x000000050400720bULL, 0x004fe40003fbd000ULL,
0x0000a00010047811ULL, 0x000fca00078e20ffULL, 0x0000000700987306ULL, 0x000fe20000009400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x000000010d0d5812ULL, 0x000fe400078efcffULL,
0x00000007008b7306ULL, 0x000e620000005400ULL, 0x000000a4b100720bULL, 0x008fe40003f9d000ULL,
0x000000cb00a47245ULL, 0x000fe4000020d400ULL, 0x000000918c00720bULL, 0x000fe40003fbd000ULL,
0x00000001a4a42812ULL, 0x000fe200078efcffULL, 0x0000000700727306ULL, 0x000ea2000000d400ULL,
0x0000009b008c7245ULL, 0x000fca000020d400ULL, 0x00000001afaf4812ULL, 0x000fe400078efcffULL,
0x000000db00077306ULL, 0x000fe20000209400ULL, 0x000000aea900720bULL, 0x000fe40003f9d000ULL,
0x0000000177775812ULL, 0x000fe400078efcffULL, 0x0000008b9800720bULL, 0x002fe40003fbd000ULL,
0x00000088bb8b723eULL, 0x000fe200000010ffULL, 0x000000db00e87306ULL, 0x0002e20000205400ULL,
0x000000c9b0ae723eULL, 0x000fc400000010ffULL, 0x000000d4afaf723eULL, 0x000fc600000010ffULL,
0x0000000178784812ULL, 0x000fe400078efcffULL, 0x00000094009f7306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x002fe4000020d400ULL, 0x0000000172725812ULL, 0x004fca00078efcffULL,
0x00000094009e7306ULL, 0x0002a20000205400ULL, 0x000000e80700720bULL, 0x008fce0003f7d000ULL,
0x0000000600977306ULL, 0x000fe20000009400ULL, 0x0000009400947245ULL, 0x002fca000020d400ULL,
0x00000001dbdb3812ULL, 0x000fe400078efcffULL, 0x00000006009a7306ULL, 0x000fe20000005400ULL,
0x0000009e9f00720bULL, 0x004fe40003f5d000ULL, 0x00000078db78723eULL, 0x000fca00000010ffULL,
0x0000000600737306ULL, 0x0003ec000000d400ULL, 0x0000000194942812ULL, 0x000fe400078efcffULL,
0x0000009b00937306ULL, 0x000fe20000209400ULL, 0x0000010030067824ULL, 0x002fe200078e00ffULL,
0x0000000d940d723eULL, 0x000fc800000010ffULL, 0x00000018ff9d7819ULL, 0x000fe40000011406ULL,
0x000000000404783bULL, 0x000e620000000200ULL, 0x0000009b00927306ULL, 0x000ea20000205400ULL,
0x0000009d00887245ULL, 0x000fce000020d400ULL, 0x000000e300e27306ULL, 0x000ff00000209400ULL,
0x000000e300bf7306ULL, 0x0007220000205400ULL, 0x000000929300720bULL, 0x004fce0003f5d000ULL,
0x000000e000aa7306ULL, 0x000fe20000209400ULL, 0x000000e300e37245ULL, 0x008fca000020d400ULL,
0x000000018c8c2812ULL, 0x000fe400078efcffULL, 0x000000e000b17306ULL, 0x000ea20000205400ULL,
0x000000bfe200720bULL, 0x010fe20003fdd000ULL, 0x0000007504049231ULL, 0x002fcc00003400ffULL,
0x000000e400b67306ULL, 0x000fe20000209400ULL, 0x0000007506069231ULL, 0x000fe400003400ffULL,
0x0000007405059231ULL, 0x080fe400003400ffULL, 0x0000007407079231ULL, 0x000fe200003400ffULL,
0x00000001e3e36812ULL, 0x000fe400078efcffULL, 0x000000e400b57306ULL, 0x0002e20000205400ULL,
0x000000b1aa00720bULL, 0x004fe40003f5d000ULL, 0x000000bcb7aa723eULL, 0x000fe200000010ffULL,
0x000000320450723cULL, 0x000fe20000041850ULL, 0x000000e38c8c723eULL, 0x000fc600000010ffULL,
0x000000ea00ac7306ULL, 0x000fe20000209400ULL, 0x000000e400e47245ULL, 0x002fc6000020d400ULL,
0x0000008a0454723cULL, 0x000fe80000041854ULL, 0x000000ea00ad7306ULL, 0x0002a20000205400ULL,
0x000000b5b600720bULL, 0x008fc60003f9d000ULL, 0x000000aa0448723cULL, 0x000fe80000041848ULL,
0x0000009500997306ULL, 0x000fe20000209400ULL, 0x000000ea00ea7245ULL, 0x002fc6000020d400ULL,
0x000000a00444723cULL, 0x000fe40000041844ULL, 0x00000001e4e44812ULL, 0x000fe400078efcffULL,
0x00000095008e7306ULL, 0x0002e20000205400ULL, 0x000000adac00720bULL, 0x004fc60003f7d000ULL,
0x000000ae0440723cULL, 0x000fe80000041840ULL, 0x000000e100a37306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x002fca000020d400ULL, 0x00000001eaea3812ULL, 0x000fe400078efcffULL,
0x000000e100a67306ULL, 0x000e620000205400ULL, 0x0000008e9900720bULL, 0x008fe40003fdd000ULL,
0x000000e0008e7245ULL, 0x000fe4000020d400ULL, 0x0000009a9700720bULL, 0x000fe40003f7d000ULL,
0x000000018e8e2812ULL, 0x000fe200078efcffULL, 0x00000030008d7306ULL, 0x000fec0000009400ULL,
0x0000000195956812ULL, 0x000fc400078efcffULL, 0x0000003000907306ULL, 0x000ea20000005400ULL,
0x000000a6a300720bULL, 0x002fe40003f5d000ULL, 0x0000000173733812ULL, 0x000fe400078efcffULL,
0x00000079a4a3723eULL, 0x000fe400000010ffULL, 0x00000077ea79723eULL, 0x000fe200000010ffULL,
0x00000030006f7306ULL, 0x0002e2000000d400ULL, 0x000000738e8e723eULL, 0x000fc600000010ffULL,
0x000000a20434723cULL, 0x000fe80000041834ULL, 0x0000009c00a97306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x002fe200078e00ffULL, 0x000000908d00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff917819ULL, 0x000fe40000011430ULL, 0x0000009c00ac7306ULL, 0x0002a20000205400ULL,
0x0000a0000f307811ULL, 0x000fcc00078e20ffULL, 0x000000016f6f4812ULL, 0x008fe200078efcffULL,
0x0000003100967306ULL, 0x000fe20000009400ULL, 0x0000009c009c7245ULL, 0x002fce000020d400ULL,
0x00000031008f7306ULL, 0x000e620000005400ULL, 0x000000aca900720bULL, 0x004fce0003fbd000ULL,
0x00000031006d7306ULL, 0x0005ec000000d400ULL, 0x000000019c9c5812ULL, 0x000fe400078efcffULL,
0x0000007a00807306ULL, 0x000fe20000209400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x0000008f9600720bULL, 0x002fc40003fdd000ULL, 0x000000e1008f7245ULL, 0x000fe4000020d400ULL,
0x00000018ff8d7819ULL, 0x000fe40000011431ULL, 0x0000007a00817306ULL, 0x000e620000205400ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x00000018ff967819ULL, 0x000fe4000001140eULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x000000868700720bULL, 0x000fc40003f5d000ULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x00000085a886723eULL, 0x000fe400000010ffULL,
0x00000084a587723eULL, 0x000fe400000010ffULL, 0x00000018ff847819ULL, 0x000fe4000001140cULL,
0x000000ca890c723eULL, 0x000fe200000010ffULL, 0x0000009d009f7306ULL, 0x000ee20000205400ULL,
0x000000818000720bULL, 0x002fe20003f9d000ULL, 0x00000086044c723cULL, 0x000fe2000004184cULL,
0x0000007a007a7245ULL, 0x000fc4000020d400ULL, 0x000000016d6d6812ULL, 0x000fe400078efcffULL,
0x0000000162622812ULL, 0x000fe200078efcffULL, 0x0000009100927306ULL, 0x000fe20000209400ULL,
0x000000728f8f723eULL, 0x000fe200000010ffULL, 0x0000000c0404723cULL, 0x000fe20000041838ULL,
0x0000006d9c6d723eULL, 0x000fc600000010ffULL, 0x000000017a7a4812ULL, 0x000fe400078efcffULL,
0x0000009100937306ULL, 0x0003220000205400ULL, 0x0000009f9e00720bULL, 0x008fe40003f7d000ULL,
0x0000009600397245ULL, 0x000fe4000020d400ULL, 0x00000018ff0c7819ULL, 0x000fe40000011408ULL,
0x0000006700087245ULL, 0x000fe2000020d400ULL, 0x00000096008a7306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x002fe2000020d400ULL, 0x0000007530309231ULL, 0x004fc400003400ffULL,
0x0000007532329231ULL, 0x000fe200003400ffULL, 0x0000008d00757245ULL, 0x000fe2000020d400ULL,
0x0000007431319231ULL, 0x080fe200003400ffULL, 0x0000000188883812ULL, 0x000fe200078efcffULL,
0x0000009600857306ULL, 0x000e620000205400ULL, 0x000000939200720bULL, 0x010fe20003fbd000ULL,
0x0000007433339231ULL, 0x000fe200003400ffULL, 0x000000828300720bULL, 0x000fca0003f7d000ULL,
0x00000076007e7306ULL, 0x000fe20000209400ULL, 0x000000783054723cULL, 0x040fea0000041854ULL,
0x0000000191915812ULL, 0x000fe400078efcffULL, 0x00000076007d7306ULL, 0x0004e20000205400ULL,
0x000000858a00720bULL, 0x002fe20003f9d000ULL, 0x0000008e304c723cULL, 0x000fe2000004184cULL,
0x000000015d5d3812ULL, 0x000fc400078efcffULL, 0x000000917a7a723eULL, 0x000fc600000010ffULL,
0x0000008d00907306ULL, 0x000fe20000209400ULL, 0x0000007600767245ULL, 0x004fca000020d400ULL,
0x0000000139394812ULL, 0x000fe400078efcffULL, 0x0000008d00977306ULL, 0x0002a20000205400ULL,
0x0000007d7e00720bULL, 0x008fe40003fdd000ULL, 0x000000623962723eULL, 0x000fca00000010ffULL,
0x0000000b000e7306ULL, 0x000fe20000209400ULL, 0x000000e4958d723eULL, 0x002fca00000010ffULL,
0x0000000176766812ULL, 0x000fe400078efcffULL, 0x0000000b007b7306ULL, 0x0002e20000205400ULL,
0x000000979000720bULL, 0x004fe20003fbd000ULL, 0x0000008c3050723cULL, 0x000fec0000041850ULL,
0x0000006700717306ULL, 0x000fe20000209400ULL, 0x0000000b000b7245ULL, 0x002fca000020d400ULL,
0x0000000175755812ULL, 0x000fe400078efcffULL, 0x0000006700707306ULL, 0x000e620000205400ULL,
0x0000007b0e00720bULL, 0x008fe40003f9d000ULL, 0x00000075767b723eULL, 0x000fca00000010ffULL,
0x0000008400827306ULL, 0x000fe40000209400ULL, 0x0000007a3040723cULL, 0x000fe80000041840ULL,
0x000000010b0b4812ULL, 0x000fe400078efcffULL, 0x0000008400817306ULL, 0x0004e20000205400ULL,
0x000000707100720bULL, 0x002fce0003fdd000ULL, 0x00000009000a7306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x004fca000020d400ULL, 0x0000000108086812ULL, 0x000fe400078efcffULL,
0x00000009000d7306ULL, 0x0002a20000205400ULL, 0x000000818200720bULL, 0x008fe40003fbd000ULL,
0x0000000b0808723eULL, 0x000fe400000010ffULL, 0x00000000000b7245ULL, 0x000fc6000020d400ULL,
0x0000005c006a7306ULL, 0x000fe20000209400ULL, 0x0000000900097245ULL, 0x002fca000020d400ULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x0000005c00637306ULL, 0x0002e20000205400ULL,
0x0000000d0a00720bULL, 0x004fce0003f7d000ULL, 0x0000000000697306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x002fca000020d400ULL, 0x0000000109093812ULL, 0x000fe400078efcffULL,
0x00000000006e7306ULL, 0x000e620000205400ULL, 0x000000636a00720bULL, 0x008fe40003f9d000ULL,
0x0000005d8463723eULL, 0x000fca00000010ffULL, 0x0000005a006b7306ULL, 0x000fe40000209400ULL,
0x000000623034723cULL, 0x000fe80000041834ULL, 0x000000015c5c4812ULL, 0x000fe400078efcffULL,
0x0000005a006c7306ULL, 0x0004e20000205400ULL, 0x0000006e6900720bULL, 0x002fe40003f5d000ULL,
0x000000095c09723eULL, 0x000fca00000010ffULL, 0x0000007c007d7306ULL, 0x000fe20000209400ULL,
0x0000005a005a7245ULL, 0x004fe2000020d400ULL, 0x000000083048723cULL, 0x000fe80000041848ULL,
0x000000010b0b2812ULL, 0x000fe400078efcffULL, 0x0000007c007e7306ULL, 0x0002a20000205400ULL,
0x0000006c6b00720bULL, 0x008fe40003fbd000ULL, 0x0000006f886c723eULL, 0x000fca00000010ffULL,
0x0000000c000e7306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x002fe2000020d400ULL,
0x0000006c3044723cULL, 0x000fe80000041844ULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x0000000c003b7306ULL, 0x000e620000205400ULL, 0x0000007e7d00720bULL, 0x004fe40003fdd000ULL,
0x0000000c007d7245ULL, 0x000fd6000020d400ULL, 0x000000017c7c6812ULL, 0x000fe400078efcffULL,
0x0000003b0e00720bULL, 0x002fe40003f7d000ULL, 0x0000007c0b7c723eULL, 0x000fd600000010ffULL,
0x000000017d7d3812ULL, 0x000fc800078efcffULL, 0x0000007d5a7d723eULL, 0x000fce00000010ffULL,
0x0000007c3030723cULL, 0x000fe20000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff047f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007844805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000402b057811ULL, 0x000fe200078e40ffULL,
0x0000580026007a24ULL, 0x020fe200078e02ffULL, 0x000000272d0e7211ULL, 0x000fc400078fe0ffULL,
0x000000052c047217ULL, 0x000fe20007800000ULL, 0x0000004000097824ULL, 0x000fe200078e00ffULL,
0x000000022d387811ULL, 0x000fe200078fe0ffULL, 0x000000405b0e7824ULL, 0x000fe200078e020eULL,
0x000000042d087811ULL, 0x000fe200078fe0ffULL, 0x0000000104047824ULL, 0x000fe400078e0a05ULL,
0x0000000127007824ULL, 0x000fe200078e0238ULL, 0x0000000e09067210ULL, 0x000fe20007f5e0ffULL,
0x00000001270c7824ULL, 0x000fe200078e0208ULL, 0x0000002004047807ULL, 0x000fe20000000000ULL,
0x000000405b0d7824ULL, 0x000fe200078e0200ULL, 0x000000062d007811ULL, 0x000fe200078fe0ffULL,
0x000000ffff057224ULL, 0x000fe200010e06ffULL, 0x00005e00060a7a11ULL, 0x000fe200078440ffULL,
0x000000405b0c7824ULL, 0x000fe200078e020cULL, 0x0000000427047217ULL, 0x000fc40007800000ULL,
0x00005f0006057a11ULL, 0x000fe400010f4405ULL, 0x0000000d09397210ULL, 0x040fe20007f5e0ffULL,
0x0000000104077824ULL, 0x000fe200078e0a27ULL, 0x00000004ff067819ULL, 0x000fe4000001162dULL,
0x0000000c093b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x00005e00395c7a11ULL, 0x000fe400078440ffULL, 0x000000070600720cULL, 0x000fe20003f66070ULL,
0x0000000127067824ULL, 0x000fe200078e0200ULL, 0x00005f0039397a11ULL, 0x000fe200010f4404ULL,
0x000000ffff5a7224ULL, 0x000fe200020e06ffULL, 0x0000001b0a047210ULL, 0x000fe20007f5e0ffULL,
0x000000405b0b7824ULL, 0x000fe200078e0206ULL, 0x0000c000610a7811ULL, 0x000fc400078e20ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078840ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000000b09067210ULL, 0x000fe40007fde0ffULL, 0x000000073800720cULL, 0x000fe40003f46070ULL,
0x0000001b5c387210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040a7faeULL, 0x0003e2000d901c46ULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe400020f445aULL, 0x00005e00065c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff397224ULL, 0x000fe200028e0639ULL, 0x000000070800720cULL, 0x000fc40003f86070ULL,
0x000000070000720cULL, 0x000fe40003fa6070ULL, 0x0000001b3a3a7210ULL, 0x080fe40007fde0ffULL,
0x00005f0006007a11ULL, 0x000fe400018f4409ULL, 0x0000001b5c5c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e063bULL, 0x0000c00060097811ULL, 0x000fe400078e20ffULL,
0x0000c0005f087811ULL, 0x000fe200078e20ffULL, 0x000000ffff5d7224ULL, 0x000fe200018e0600ULL,
0x0000c0005e077811ULL, 0x000fe200078e20ffULL, 0x0000000038097faeULL, 0x0003e8000d101c46ULL,
0x000000003a087faeULL, 0x0003e8000e101c46ULL, 0x000000005c077faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff047f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fc40007844803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e0005ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007844803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007844803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x000fe4000001162dULL,
0x0000541000637816ULL, 0x000fe20000000000ULL, 0x0001a4e27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c63897589ULL, 0x0002a400000e0000ULL, 0x0001a5227f007947ULL, 0x000fea000b800000ULL,
0x00001f2f638a7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0066ULL, 0x00004490005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0001b3b000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0065ULL, 0x000044f0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0001b35000007944ULL, 0x01cfea0003c00000ULL, 0x0000e0003f067811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0003e057811ULL, 0x000fe400078e20ffULL,
0x0000e0003d047811ULL, 0x000fe200078e20ffULL, 0x00000000065c783bULL, 0x000f620000004200ULL,
0x0000e0003c037811ULL, 0x000fc600078e20ffULL, 0x000000000560783bULL, 0x00ee680000004200ULL,
0x000000000438783bULL, 0x000ea80000004200ULL, 0x00000000033c783bULL, 0x000ee20000004200ULL,
0x000001005cb97824ULL, 0x060fe200078e00ffULL, 0x0000005d00e37306ULL, 0x000fe20000009400ULL,
0x00000018ffca7819ULL, 0x000fe2000001145cULL, 0x000100005cc57824ULL, 0x000fe200078e00ffULL,
0x00000018ffda7819ULL, 0x000fe2000001145dULL, 0x000001005fd97824ULL, 0x000fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x000100005dc77824ULL, 0x000fe200078e00ffULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x0000005d00ba7306ULL, 0x000f620000005400ULL,
0x00000018ffd97819ULL, 0x000fe200000114d9ULL, 0x000100005fd77824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000001005dd27824ULL, 0x000fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fe2000001145fULL, 0x000100005ee27824ULL, 0x040fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fe200000114d7ULL, 0x000000b900be7306ULL, 0x000fe20000209400ULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x000001005ee97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x0000010060ce7824ULL, 0x042fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe2000001145eULL, 0x0000010063ac7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe97819ULL, 0x000fe200000114e9ULL, 0x000000b900ef7306ULL, 0x0003220000205400ULL,
0x000000bae300720bULL, 0x020fe20003f7d000ULL, 0x0001000063bc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x0001000060d37824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe20000011463ULL, 0x0000010038ba7824ULL, 0x004fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe20000011438ULL, 0x000000ca00027306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fe2000020d400ULL, 0x0000010061cc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fc400000114d3ULL, 0x00000018ffaa7819ULL, 0x000fe40000011460ULL,
0x00000018ff8f7819ULL, 0x000fe20000011439ULL, 0x000000ca00bb7306ULL, 0x0002a20000205400ULL,
0x000000efbe00720bULL, 0x010fe40003fbd000ULL, 0x00000018ff857819ULL, 0x000fe4000001143aULL,
0x00000018ff757819ULL, 0x008fe4000001143cULL, 0x00000018ff947819ULL, 0x000fe20000011461ULL,
0x000000c500c97306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x002fc4000020d400ULL,
0x00000018ff7f7819ULL, 0x000fe4000001143bULL, 0x00000018ff6e7819ULL, 0x000fe4000001143dULL,
0x00000001b9b95812ULL, 0x000fe200078efcffULL, 0x000000c500d87306ULL, 0x0002e20000205400ULL,
0x000000bb0200720bULL, 0x004fe40003fdd000ULL, 0x00000018ff677819ULL, 0x000fe4000001143eULL,
0x00000018ff697819ULL, 0x000fc4000001143fULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x0000005d008e7306ULL, 0x000ea2000000d400ULL, 0x000000c500c57245ULL, 0x002fe4000020d400ULL,
0x00000018ffac7819ULL, 0x000fe400000114acULL, 0x00000018ffa97819ULL, 0x000fe40000011462ULL,
0x00000001caca6812ULL, 0x000fe200078efcffULL, 0x000000d900ec7306ULL, 0x000fe20000209400ULL,
0x000000d8c900720bULL, 0x008fe20003fbd000ULL, 0x0000010039c97824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x000001003dd87824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fc400000114baULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x000000d900ed7306ULL, 0x0002e20000205400ULL, 0x000000018e8e3812ULL, 0x004fca00078efcffULL,
0x00000001c5c55812ULL, 0x000fe400078efcffULL, 0x0000005c00af7306ULL, 0x000fe20000009400ULL,
0x000000d900d97245ULL, 0x002fce000020d400ULL, 0x0000005c00ae7306ULL, 0x000e620000005400ULL,
0x000000edec00720bULL, 0x008fce0003f7d000ULL, 0x000000c700d47306ULL, 0x000fec0000209400ULL,
0x00000001d9d93812ULL, 0x000fe400078efcffULL, 0x000000c700dd7306ULL, 0x0004e20000205400ULL,
0x000000aeaf00720bULL, 0x002fce0003f5d000ULL, 0x0000005e00007306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x004fce000020d400ULL, 0x0000005e00d17306ULL, 0x000e620000005400ULL,
0x000000ddd400720bULL, 0x008fe20003fdd000ULL, 0x000100003cdd7824ULL, 0x000fca00078e00ffULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x000000da00cb7306ULL, 0x000fec0000209400ULL,
0x00000001c7c76812ULL, 0x000fe400078efcffULL, 0x000000da00d07306ULL, 0x0004e20000205400ULL,
0x000000d10000720bULL, 0x002fe20003f9d000ULL, 0x000100003bd17824ULL, 0x000fca00078e00ffULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x0000005c00907306ULL, 0x000e62000000d400ULL,
0x000000da00da7245ULL, 0x004fce000020d400ULL, 0x000000d700e77306ULL, 0x000fe20000209400ULL,
0x000000d0cb00720bULL, 0x008fe20003fbd000ULL, 0x000001003cd07824ULL, 0x000fe200078e00ffULL,
0x000000d200cb7245ULL, 0x000fc8000020d400ULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x000000d700e87306ULL, 0x0004e20000205400ULL, 0x0000000190902812ULL, 0x002fca00078efcffULL,
0x00000001dada5812ULL, 0x000fe400078efcffULL, 0x000000d200cd7306ULL, 0x000fe20000209400ULL,
0x000000d700d77245ULL, 0x004fe4000020d400ULL, 0x000000c7dac7723eULL, 0x000fca00000010ffULL,
0x000000d200ee7306ULL, 0x000e620000205400ULL, 0x000000e8e700720bULL, 0x008fce0003f7d000ULL,
0x0000005f00e57306ULL, 0x000fec0000009400ULL, 0x00000001d7d73812ULL, 0x000fe400078efcffULL,
0x0000005f00e67306ULL, 0x000ea20000005400ULL, 0x000000eecd00720bULL, 0x002fe20003f5d000ULL,
0x0001000039ee7824ULL, 0x000fcc00078e00ffULL, 0x0000005e00877306ULL, 0x0002ec000000d400ULL,
0x00000001cbcb2812ULL, 0x000fe400078efcffULL, 0x000000c200c37306ULL, 0x000fe20000209400ULL,
0x00010000625e7824ULL, 0x002fe200078e00ffULL, 0x000000e6e500720bULL, 0x004fc40003fdd000ULL,
0x000000e900e67245ULL, 0x000fe4000020d400ULL, 0x00000018ffae7819ULL, 0x000fe2000001145eULL,
0x00010000385e7824ULL, 0x000fe200078e00ffULL, 0x000000c200c67306ULL, 0x0002a20000205400ULL,
0x0000000187874812ULL, 0x008fe400078efcffULL, 0x00000018ffe57819ULL, 0x000fe400000114eeULL,
0x00000018ffd27819ULL, 0x000fe2000001145eULL, 0x000001003f5e7824ULL, 0x000fc400078e00ffULL,
0x000000e200ea7306ULL, 0x000fe20000209400ULL, 0x000000c200c27245ULL, 0x002fce000020d400ULL,
0x000000e200eb7306ULL, 0x0002e20000205400ULL, 0x000000c6c300720bULL, 0x004fce0003f9d000ULL,
0x0000006100c17306ULL, 0x000fe20000009400ULL, 0x000000e200e27245ULL, 0x002fca000020d400ULL,
0x00000001c2c24812ULL, 0x000fe400078efcffULL, 0x0000006100b47306ULL, 0x000e620000005400ULL,
0x000000ebea00720bULL, 0x008fe40003fbd000ULL, 0x000000d7c2d7723eULL, 0x000fca00000010ffULL,
0x000000e9005c7306ULL, 0x000fec0000209400ULL, 0x00000001e2e25812ULL, 0x000fe400078efcffULL,
0x000000e9005d7306ULL, 0x000ea20000205400ULL, 0x000000b4c100720bULL, 0x002fce0003f7d000ULL,
0x0000005f00867306ULL, 0x0002f0000000d400ULL, 0x000000ce00e47306ULL, 0x000fe20000209400ULL,
0x00000007205f7812ULL, 0x002fe400078e7868ULL, 0x0000005d5c00720bULL, 0x004fe20003f5d000ULL,
0x000100003e5d7824ULL, 0x000fc400078e00ffULL, 0x0000000868027824ULL, 0x000fe400078e025fULL,
0x000000ce00e17306ULL, 0x000e620000205400ULL, 0x0000000186866812ULL, 0x008fe200078efcffULL,
0x000001003e5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x000100003f5c7824ULL, 0x000fe200078e00ffULL, 0x00000086d9d9723eULL, 0x000fe400000010ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000006200b67306ULL, 0x000fe20000009400ULL,
0x00000001e6e62812ULL, 0x000fc400078efcffULL, 0x00000018ff5c7819ULL, 0x000fca000001145cULL,
0x0000006200b17306ULL, 0x000ea20000005400ULL, 0x000000e1e400720bULL, 0x002fce0003fdd000ULL,
0x0000006300957306ULL, 0x000ff00000009400ULL, 0x00000063009a7306ULL, 0x000fe20000005400ULL,
0x000000b1b600720bULL, 0x004fce0003f9d000ULL, 0x00000063007a7306ULL, 0x0003f0000000d400ULL,
0x0000003800ab7306ULL, 0x000fe20000009400ULL, 0x000000071f637812ULL, 0x002fca00078e7868ULL,
0x0000000868007824ULL, 0x000fe400078e0263ULL, 0x00000038009e7306ULL, 0x000fe20000005400ULL,
0x000100003d637824ULL, 0x000fca00078e00ffULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x0000003800797306ULL, 0x0003f0000000d400ULL, 0x0000006000c47306ULL, 0x000fe20000009400ULL,
0x000001003b387824ULL, 0x002fca00078e00ffULL, 0x00000018ffb47819ULL, 0x000fe40000011438ULL,
0x0000006000b77306ULL, 0x000e620000005400ULL, 0x0000a00000387811ULL, 0x000fce00078e20ffULL,
0x000000b000c87306ULL, 0x000ff00000209400ULL, 0x000000b000b57306ULL, 0x000ea20000205400ULL,
0x000000b7c400720bULL, 0x002fe40003fbd000ULL, 0x000000ce00b77245ULL, 0x000fc8000020d400ULL,
0x00000001b7b76812ULL, 0x000fe200078efcffULL, 0x0000006000847306ULL, 0x0002f0000000d400ULL,
0x0000003900a77306ULL, 0x000fe20000009400ULL, 0x0001000061607824ULL, 0x002fe200078e00ffULL,
0x000000b5c800720bULL, 0x004fc40003f5d000ULL, 0x000000b000b57245ULL, 0x000fe4000020d400ULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x0000003900927306ULL, 0x000fe20000005400ULL,
0x0000000184845812ULL, 0x008fe400078efcffULL, 0x000000aa00b07245ULL, 0x000fc8000020d400ULL,
0x00000001b5b52812ULL, 0x000fe200078efcffULL, 0x0000003900767306ULL, 0x0003f0000000d400ULL,
0x0000003a00917306ULL, 0x000fe20000009400ULL, 0x000001003a397824ULL, 0x002fca00078e00ffULL,
0x00000018ffc37819ULL, 0x000fe40000011439ULL, 0x0000003a009c7306ULL, 0x000ff00000005400ULL,
0x0000003a00747306ULL, 0x0003f0000000d400ULL, 0x0000003c00937306ULL, 0x000fe20000009400ULL,
0x000100003a3a7824ULL, 0x002fca00078e00ffULL, 0x00000018ffb17819ULL, 0x000fe4000001143aULL,
0x0000003c00987306ULL, 0x000ff00000005400ULL, 0x0000003c006d7306ULL, 0x0003f0000000d400ULL,
0x000000d300d57306ULL, 0x000fe20000209400ULL, 0x0000a000023c7811ULL, 0x002fce00078e20ffULL,
0x000000d300e07306ULL, 0x0002b00000205400ULL, 0x0000006100837306ULL, 0x000722000000d400ULL,
0x000000d300d37245ULL, 0x002fce000020d400ULL, 0x0000003b00a37306ULL, 0x000fe20000009400ULL,
0x0000010062617824ULL, 0x008fe200078e00ffULL, 0x000000e0d500720bULL, 0x004fc80003fdd000ULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000003b00967306ULL, 0x000fe20000005400ULL,
0x0000000183833812ULL, 0x010fcc00078efcffULL, 0x00000001d3d36812ULL, 0x000fe200078efcffULL,
0x0000003b00737306ULL, 0x0003f0000000d400ULL, 0x0000003d00a47306ULL, 0x000fe20000009400ULL,
0x000000003838783bULL, 0x002e6e0000000200ULL, 0x0000003d00997306ULL, 0x000ff00000005400ULL,
0x0000003d006c7306ULL, 0x000ff0000000d400ULL, 0x0000003e008d7306ULL, 0x000ff00000009400ULL,
0x0000003e008c7306ULL, 0x000ff00000005400ULL, 0x0000003e006a7306ULL, 0x000fe2000000d400ULL,
0x0000008938389231ULL, 0x002fc400003400ffULL, 0x000000893a3a9231ULL, 0x000fe400003400ffULL,
0x0000008a39399231ULL, 0x080fe400003400ffULL, 0x0000008a3b3b9231ULL, 0x000fe200003400ffULL,
0x0000003f007e7306ULL, 0x000ff00000009400ULL, 0x0000003f007d7306ULL, 0x000ff00000005400ULL,
0x0000003f006b7306ULL, 0x0003f0000000d400ULL, 0x0000006000de7306ULL, 0x000fe20000209400ULL,
0x000000003c3c783bULL, 0x002e6e0000000200ULL, 0x0000006000df7306ULL, 0x000eb00000205400ULL,
0x000000aa00c07306ULL, 0x000ff00000209400ULL, 0x000000aa00b37306ULL, 0x0007220000205400ULL,
0x000000dfde00720bULL, 0x004fce0003f7d000ULL, 0x000000cc00cf7306ULL, 0x000fe20000209400ULL,
0x0000006000aa7245ULL, 0x008fe4000020d400ULL, 0x00000090b960723eULL, 0x000fc600000010ffULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x000000cc00d67306ULL, 0x0004e20000205400ULL,
0x000000b3c000720bULL, 0x010fe20003fbd000ULL, 0x000000893c3c9231ULL, 0x082fe200003400ffULL,
0x0000009a9500720bULL, 0x000fe20003f7d000ULL, 0x000000893e3e9231ULL, 0x000fe200003400ffULL,
0x0000006100957245ULL, 0x000fe2000020d400ULL, 0x0000008a3d3d9231ULL, 0x080fe400003400ffULL,
0x0000006100db7306ULL, 0x000fe20000209400ULL, 0x000000cc00cc7245ULL, 0x004fe2000020d400ULL,
0x0000008a3f3f9231ULL, 0x000fc800003400ffULL, 0x00000001b0b05812ULL, 0x000fe400078efcffULL,
0x0000006100dc7306ULL, 0x0002a20000205400ULL, 0x000000d6cf00720bULL, 0x008fe40003f5d000ULL,
0x000000017a7a3812ULL, 0x000fe400078efcffULL, 0x0000009eab00720bULL, 0x000fe40003f7d000ULL,
0x000000e2b5d6723eULL, 0x000fe200000010ffULL, 0x0000006200807306ULL, 0x000ee2000000d400ULL,
0x0000008ecb61723eULL, 0x002fca00000010ffULL, 0x00000001cccc2812ULL, 0x000fe200078efcffULL,
0x000000d63c48723cULL, 0x040fe20000041848ULL, 0x0000009400bf7306ULL, 0x000fe20000209400ULL,
0x000000dcdb00720bULL, 0x004fe40003fdd000ULL, 0x0000000179793812ULL, 0x000fe400078efcffULL,
0x00000096a300720bULL, 0x000fe40003f7d000ULL, 0x000000603c54723cULL, 0x000fe20000041854ULL,
0x0000009400b87306ULL, 0x000e620000205400ULL, 0x0000000180804812ULL, 0x008fca00078efcffULL,
0x0000000195956812ULL, 0x000fe400078efcffULL, 0x000000ac00ad7306ULL, 0x000fe20000209400ULL,
0x00000084b760723eULL, 0x000fe400000010ffULL, 0x0000008500847245ULL, 0x000fe4000020d400ULL,
0x0000000173733812ULL, 0x000fe400078efcffULL, 0x00000083cc61723eULL, 0x000fe200000010ffULL,
0x000000ac00627306ULL, 0x000ea20000205400ULL, 0x000000b8bf00720bULL, 0x002fc40003f5d000ULL,
0x000000809580723eULL, 0x000fc600000010ffULL, 0x000000603c44723cULL, 0x000fe40000041844ULL,
0x000000a9009d7306ULL, 0x000ff00000209400ULL, 0x000000a900a27306ULL, 0x0002e20000205400ULL,
0x00000062ad00720bULL, 0x004fc40003fbd000ULL, 0x0000009400ad7245ULL, 0x000fe4000020d400ULL,
0x00000018ff627819ULL, 0x000fe400000114d8ULL, 0x00000001adad2812ULL, 0x000fe200078efcffULL,
0x000000d200e37306ULL, 0x000fe20000209400ULL, 0x000000a900a97245ULL, 0x002fe4000020d400ULL,
0x00000087e6d8723eULL, 0x000fe400000010ffULL, 0x000000aaadad723eULL, 0x000fc600000010ffULL,
0x000000d200ec7306ULL, 0x0002a20000205400ULL, 0x000000a29d00720bULL, 0x008fe20003fdd000ULL,
0x000000d83c4c723cULL, 0x000fe2000004184cULL, 0x000000ac009d7245ULL, 0x000fe4000020d400ULL,
0x000000d3b0ac723eULL, 0x000fe400000010ffULL, 0x000000019d9d5812ULL, 0x000fe200078efcffULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x002fc6000020d400ULL,
0x000000ac3c40723cULL, 0x000fe40000041840ULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x000000ae00b27306ULL, 0x0002e20000205400ULL, 0x000000ece300720bULL, 0x004fe40003f3d000ULL,
0x0000009c9100720bULL, 0x000fca0003fdd000ULL, 0x000000bc00bd7306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x00000001d2d21812ULL, 0x000fe400078efcffULL,
0x000000bc00be7306ULL, 0x0002a20000205400ULL, 0x000000b2af00720bULL, 0x008fe40003f5d000ULL,
0x0000000174746812ULL, 0x000fca00078efcffULL, 0x000000c300c47306ULL, 0x000fe20000209400ULL,
0x000000bc00bc7245ULL, 0x002fca000020d400ULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x000000c300c17306ULL, 0x0002e20000205400ULL, 0x000000bebd00720bULL, 0x004fe40003fbd000ULL,
0x00000092a700720bULL, 0x000fca0003f5d000ULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x000000c300c37245ULL, 0x002fca000020d400ULL, 0x00000001bcbc5812ULL, 0x000fe400078efcffULL,
0x000000ba00687306ULL, 0x0002a20000205400ULL, 0x000000c1c400720bULL, 0x008fe40003f3d000ULL,
0x0000000176762812ULL, 0x000fca00078efcffULL, 0x00000085008b7306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x00000001c3c31812ULL, 0x000fe400078efcffULL,
0x0000008500887306ULL, 0x0002e20000205400ULL, 0x00000068bb00720bULL, 0x004fe40003fbd000ULL,
0x0000008f00687245ULL, 0x000fca000020d400ULL, 0x000000a500a07306ULL, 0x000fe20000209400ULL,
0x000000d100857245ULL, 0x002fca000020d400ULL, 0x00000001baba5812ULL, 0x000fe400078efcffULL,
0x000000a5009f7306ULL, 0x0002a20000205400ULL, 0x000000888b00720bULL, 0x008fe40003fdd000ULL,
0x00000018ff887819ULL, 0x000fe4000001145eULL, 0x0000007f005e7245ULL, 0x000fe4000020d400ULL,
0x00000079baba723eULL, 0x000fe200000010ffULL, 0x000000b400b67306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x002fca000020d400ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x000000b400bf7306ULL, 0x0002e20000205400ULL, 0x0000009fa000720bULL, 0x004fce0003f9d000ULL,
0x000000a100a87306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fca000020d400ULL,
0x00000001a5a54812ULL, 0x000fe400078efcffULL, 0x000000a100977306ULL, 0x0002a20000205400ULL,
0x000000bfb600720bULL, 0x008fe40003f3d000ULL, 0x000000bca5a5723eULL, 0x000fca00000010ffULL,
0x0000008f00a67306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fca000020d400ULL,
0x00000001b4b41812ULL, 0x000fe400078efcffULL, 0x0000008f009b7306ULL, 0x000e620000205400ULL,
0x00000097a800720bULL, 0x004fce0003fbd000ULL, 0x000000d000917306ULL, 0x000fec0000209400ULL,
0x00000001a1a15812ULL, 0x000fe400078efcffULL, 0x000000d0008a7306ULL, 0x0004e20000205400ULL,
0x0000009ba600720bULL, 0x002fe40003f5d000ULL, 0x000000989300720bULL, 0x000fc40003fbd000ULL,
0x000000d2a1d2723eULL, 0x000fc600000010ffULL, 0x000000c900cd7306ULL, 0x000fe20000209400ULL,
0x000000d000d07245ULL, 0x004fca000020d400ULL, 0x0000000168682812ULL, 0x000fe400078efcffULL,
0x000000c900d47306ULL, 0x0002a20000205400ULL, 0x0000008a9100720bULL, 0x008fe40003fdd000ULL,
0x0000008c8d00720bULL, 0x000fe40003f5d000ULL, 0x000000016d6d5812ULL, 0x000fc600078efcffULL,
0x000000b100b37306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fca000020d400ULL,
0x00000001d0d06812ULL, 0x000fe400078efcffULL, 0x000000b100947306ULL, 0x0002e20000205400ULL,
0x000000d4cd00720bULL, 0x004fe40003f9d000ULL, 0x000000016a6a2812ULL, 0x000fe400078efcffULL,
0x0000006dd0d0723eULL, 0x000fc600000010ffULL, 0x0000006200927306ULL, 0x000fe20000209400ULL,
0x000000b100b17245ULL, 0x002fca000020d400ULL, 0x00000001c9c94812ULL, 0x000fe400078efcffULL,
0x0000006200977306ULL, 0x000e620000205400ULL, 0x00000094b300720bULL, 0x008fe40003f3d000ULL,
0x00000076c9bb723eULL, 0x000fca00000010ffULL, 0x000000e500e97306ULL, 0x000fe40000209400ULL,
0x000000ba3854723cULL, 0x000fe80000041854ULL, 0x00000001b1b11812ULL, 0x000fe400078efcffULL,
0x000000e500c67306ULL, 0x0004e20000205400ULL, 0x000000979200720bULL, 0x002fe40003fdd000ULL,
0x000000b18484723eULL, 0x000fca00000010ffULL, 0x0000007f00827306ULL, 0x000fe20000209400ULL,
0x000000e500e57245ULL, 0x004fce000020d400ULL, 0x0000007f00817306ULL, 0x000e620000205400ULL,
0x000000c6e900720bULL, 0x008fe40003f9d000ULL, 0x000000c5cac6723eULL, 0x000fca00000010ffULL,
0x000000d1009a7306ULL, 0x000fe40000209400ULL, 0x000000c63c50723cULL, 0x000fe80000041850ULL,
0x00000001e5e54812ULL, 0x000fe400078efcffULL, 0x000000d1009f7306ULL, 0x0004e20000205400ULL,
0x000000818200720bULL, 0x002fe40003f3d000ULL, 0x00000099a400720bULL, 0x000fc40003f9d000ULL,
0x0000007a9d81723eULL, 0x000fe400000010ffULL, 0x000000aea9a4723eULL, 0x000fe200000010ffULL,
0x000000dd00897306ULL, 0x000fe20000209400ULL, 0x0000006200d17245ULL, 0x004fe4000020d400ULL,
0x000000e568d3723eULL, 0x000fe200000010ffULL, 0x000000803c34723cULL, 0x000fe20000041834ULL,
0x00000001d1d16812ULL, 0x000fe400078efcffULL, 0x000000015e5e1812ULL, 0x000fe200078efcffULL,
0x000000dd008c7306ULL, 0x0002a20000205400ULL, 0x0000009f9a00720bULL, 0x008fc40003f7d000ULL,
0x000000016c6c4812ULL, 0x000fe200078efcffULL, 0x000000a43c30723cULL, 0x000fe60000041830ULL,
0x0000006cd1d1723eULL, 0x000fe200000010ffULL, 0x00000075007b7306ULL, 0x000fe20000209400ULL,
0x000000dd00dd7245ULL, 0x002fe4000020d400ULL, 0x00000075003e7245ULL, 0x000fe2000020d400ULL,
0x000000d23850723cULL, 0x000fe20000041850ULL, 0x00000063003f7245ULL, 0x000fc4000020d400ULL,
0x0000000185853812ULL, 0x000fe200078efcffULL, 0x00000075007c7306ULL, 0x000e620000205400ULL,
0x0000008c8900720bULL, 0x004fe40003fdd000ULL, 0x0000007d7e00720bULL, 0x000fe20003f7d000ULL,
0x000000d03844723cULL, 0x000fe20000041844ULL, 0x00000074c33c723eULL, 0x000fe400000010ffULL,
0x00000073b43d723eULL, 0x000fe200000010ffULL, 0x0000006700717306ULL, 0x000fe20000209400ULL,
0x000000855e85723eULL, 0x000fca00000010ffULL, 0x00000001dddd6812ULL, 0x000fe200078efcffULL,
0x0000003c384c723cULL, 0x000fe2000004184cULL, 0x0000006700727306ULL, 0x000ea20000205400ULL,
0x0000007c7b00720bULL, 0x002fe40003f3d000ULL, 0x000000016b6b3812ULL, 0x000fc600078efcffULL,
0x00000067003c7245ULL, 0x000fe2000020d400ULL, 0x000000843848723cULL, 0x000fe20000041848ULL,
0x0000006e00787306ULL, 0x000fe20000209400ULL, 0x0000005c003d7245ULL, 0x000fca000020d400ULL,
0x000000013e3e1812ULL, 0x000fe400078efcffULL, 0x0000006e00777306ULL, 0x0002e20000205400ULL,
0x000000727100720bULL, 0x004fe40003fdd000ULL, 0x000000dd3e3e723eULL, 0x000fca00000010ffULL,
0x0000006300877306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x002fca000020d400ULL,
0x000000013c3c6812ULL, 0x000fe400078efcffULL, 0x0000006300867306ULL, 0x000e620000205400ULL,
0x000000777800720bULL, 0x008fce0003fbd000ULL, 0x0000005f00837306ULL, 0x000fec0000209400ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x0000005f00827306ULL, 0x0004e20000205400ULL,
0x000000868700720bULL, 0x002fce0003f9d000ULL, 0x00000088007d7306ULL, 0x000fe20000209400ULL,
0x0000005f005f7245ULL, 0x004fca000020d400ULL, 0x000000013f3f4812ULL, 0x000fe400078efcffULL,
0x00000088007a7306ULL, 0x0002a20000205400ULL, 0x000000828300720bULL, 0x008fe40003f3d000ULL,
0x0000003f6e3f723eULL, 0x000fca00000010ffULL, 0x00000069006f7306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x002fe2000020d400ULL, 0x0000003e3840723cULL, 0x000fe80000041840ULL,
0x000000015f5f1812ULL, 0x000fe400078efcffULL, 0x0000006900707306ULL, 0x000e620000205400ULL,
0x0000007a7d00720bULL, 0x004fe40003fbd000ULL, 0x00000069003e7245ULL, 0x000fc4000020d400ULL,
0x0000006a5f6a723eULL, 0x000fc600000010ffULL, 0x0000005d00607306ULL, 0x000fec0000209400ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x0000005d00617306ULL, 0x0004e20000205400ULL,
0x000000706f00720bULL, 0x002fe40003f9d000ULL, 0x0000006b886b723eULL, 0x000fca00000010ffULL,
0x0000005c00627306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x004fe2000020d400ULL,
0x0000006a3834723cULL, 0x000fe80000041834ULL, 0x000000013e3e4812ULL, 0x000fe400078efcffULL,
0x0000005c00717306ULL, 0x000e620000205400ULL, 0x000000616000720bULL, 0x008fda0003f3d000ULL,
0x000000015d5d1812ULL, 0x000fe400078efcffULL, 0x000000716200720bULL, 0x002fe40003f5d000ULL,
0x0000005d3c3c723eULL, 0x000fd600000010ffULL, 0x000000013d3d2812ULL, 0x000fc800078efcffULL,
0x0000003d3e3d723eULL, 0x000fce00000010ffULL, 0x0000003c3838723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000402b337811ULL, 0x000fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000332c00720cULL, 0x000fda0003f24070ULL, 0x0000ee1000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x002e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000327305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff327984ULL, 0x000e640000000800ULL,
0x8000000032ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff317624ULL, 0x000fe200078e00ffULL, 0x0000000328327812ULL, 0x000fe200078ec0ffULL,
0x00000004ff307424ULL, 0x000fc600078e00ffULL, 0x000000033200780cULL, 0x000fe20003f25270ULL,
0xfffffffd30317424ULL, 0x000fe400078e0231ULL, 0x0000580026327a24ULL, 0x000fe400078e02ffULL,
0xffffffffff267424ULL, 0x000fe200078e00ffULL, 0x0000000131317807ULL, 0x000fca0004800000ULL,
0x0000000128287824ULL, 0x000fca00078e0231ULL, 0x0000002a2800720cULL, 0x000fe20003f26070ULL,
0x00000040323d7824ULL, 0x000fe200078e00ffULL, 0x000000602b337811ULL, 0x000fd600078e40ffULL,
0x0000000128319824ULL, 0x000fc800078e0223ULL, 0x0000600031309625ULL, 0x000fe200078e0030ULL,
0x000000332c327217ULL, 0x000fc80007800000ULL, 0x0000000630269981ULL, 0x000362000c1e1900ULL,
0x000000223d3c7210ULL, 0x040fe20007f3e0ffULL, 0x0000000132327824ULL, 0x000fe200078e0a33ULL,
0x0000001d3d5d7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x00005e003c5c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff5e7224ULL, 0x000fe200010e06ffULL,
0x0000002032327807ULL, 0x000fe40000000000ULL, 0x00005f003c3f7a11ULL, 0x000fe400008f443fULL,
0x0000001e3d337210ULL, 0x000fe40007f3e0ffULL, 0x0000003227327217ULL, 0x000fe40007800000ULL,
0x00000004ff317819ULL, 0x002fe2000001162dULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x00005e00333c7a11ULL, 0x000fe200078240ffULL, 0x00000001323e7824ULL, 0x000fe200078e0a27ULL,
0x0000001c3d3d7210ULL, 0x000fc40007f7e0ffULL, 0x00005f0033337a11ULL, 0x000fe400008f4430ULL,
0x0000001b5c307210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff627224ULL, 0x000fe200018e06ffULL,
0x00005e005d607a11ULL, 0x000fe400078440ffULL, 0x0000001b3c327210ULL, 0x000fe40007fbe0ffULL,
0x0000003e3100720cULL, 0x000fe20003f26070ULL, 0x000000ffff317224ULL, 0x000fe200020e063fULL,
0x00005f005d5e7a11ULL, 0x000fe200010f445eULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x00005e003d5c7a11ULL, 0x000fc400078440ffULL, 0x0000003e2100720cULL, 0x080fe40003f86070ULL,
0x0000003e2000720cULL, 0x080fe40003fc6070ULL, 0x0000003e1f00720cULL, 0x000fe40003fa6070ULL,
0x0000001b603c7210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000301a7faeULL, 0x0003e2000c901c46ULL, 0x00005f003d627a11ULL, 0x000fe400010f4462ULL,
0x0000001b5c3e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fc400018e065eULL,
0x0000000032197faeULL, 0x0003e4000e101c46ULL, 0x000000ffff3f7224ULL, 0x000fe400010e0662ULL,
0x000000003c187faeULL, 0x0003e8000f101c46ULL, 0x000000003e177faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff687f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff317984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280027327f8cULL, 0x000fe2000c80043fULL, 0x8000000031ff7812ULL, 0x002fc6000784485aULL,
0x01062c00273d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe40007824833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002e4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x008fe40003800000ULL, 0x01062c0027317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007824833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0100800016327984ULL, 0x000e680000000800ULL, 0x0102800016337984ULL, 0x0007220000000800ULL,
0x000000253200720bULL, 0x002fe20003f3d000ULL, 0x00017f527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x008fc800008e0100ULL, 0x0000ffff303d7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ffb57424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000012e00780cULL, 0x000fe40003f65270ULL,
0x000000253200720bULL, 0x000fe20003f34000ULL, 0x00017f227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x000fe400008e0100ULL, 0x0000003225317209ULL, 0x040fe40007810000ULL,
0x0000ffff30307812ULL, 0x000fe400078e3cffULL, 0x00000002ff6c7819ULL, 0x000fe2000001162dULL,
0x80000031253c7221ULL, 0x000fe20000010000ULL, 0x010480311600b388ULL, 0x0003e20000000800ULL,
0x000000303dff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b3c3c7820ULL, 0x000fc80000410000ULL,
0x0000003c00637308ULL, 0x000ee40000000800ULL, 0x0000006324247220ULL, 0x008fe20000410000ULL,
0x00017ec27f007947ULL, 0x000fea000b800000ULL, 0x00001f6c63627589ULL, 0x0022e400000e0000ULL,
0x0000006254547220ULL, 0x08cfe20000410000ULL, 0x0000006255557220ULL, 0x080fe20000410000ULL,
0x0000006250507220ULL, 0x080fe20000410000ULL, 0x0000006251517220ULL, 0x080fe20000410000ULL,
0x000000624c4c7220ULL, 0x080fe20000410000ULL, 0x000000624d4d7220ULL, 0x080fe20000410000ULL,
0x0000006248487220ULL, 0x080fe20000410000ULL, 0x0000006249497220ULL, 0x080fe20000410000ULL,
0x0000006244447220ULL, 0x080fe20000410000ULL, 0x0000006245457220ULL, 0x080fe20000410000ULL,
0x0000006240407220ULL, 0x080fe20000410000ULL, 0x0000006241417220ULL, 0x080fe20000410000ULL,
0x0000006234347220ULL, 0x080fe20000410000ULL, 0x0000006235357220ULL, 0x080fe20000410000ULL,
0x0000006238387220ULL, 0x080fe20000410000ULL, 0x0000006239397220ULL, 0x000fe20000410000ULL,
0x00017df27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f63627589ULL, 0x0004e400000e0000ULL,
0x0000003225257209ULL, 0x000fe20007810000ULL, 0x0000006256567220ULL, 0x08cfe20000410000ULL,
0x00000001ffb57807ULL, 0x000fe20000800000ULL, 0x0000006257577220ULL, 0x080fe20000410000ULL,
0x0000006252527220ULL, 0x080fe20000410000ULL, 0x8000002532321221ULL, 0x000fe20000010000ULL,
0x0000006253537220ULL, 0x080fe20000410000ULL, 0x000000624e4e7220ULL, 0x080fe20000410000ULL,
0x000000624f4f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b32321820ULL, 0x000fe20000410000ULL,
0x000000624a4a7220ULL, 0x080fe20000410000ULL, 0x000000624b4b7220ULL, 0x080fe20000410000ULL,
0x0000006246467220ULL, 0x080fe20000410000ULL, 0x0000003200151308ULL, 0x000ea20000000800ULL,
0x0000006247477220ULL, 0x080fe20000410000ULL, 0x0000006242427220ULL, 0x080fe20000410000ULL,
0x0000006243437220ULL, 0x080fe20000410000ULL, 0x0000006236367220ULL, 0x080fe20000410000ULL,
0x0000006237377220ULL, 0x080fe20000410000ULL, 0x000000623a3a7220ULL, 0x080fe20000410000ULL,
0x000000623b3b7220ULL, 0x000fe20000410000ULL, 0x0000003315331220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002433247221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fc4000782485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x000724000021f000ULL,
0x3fa0000030307823ULL, 0x008fe200000100ffULL, 0x000000310000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fe4000782485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff30723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x002fc4000001162dULL, 0x0000541030637816ULL, 0x000fe20000000030ULL,
0x00017b927f007947ULL, 0x000fea000b800000ULL, 0x00001f6c63737589ULL, 0x0002e400000e0000ULL,
0x00017bd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f63747589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0066ULL,
0x00007000005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0001884000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0065ULL,
0x00007060005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000187e000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001430783bULL, 0x000f220000004200ULL,
0x00009910b5b57816ULL, 0x000fc600000000ffULL, 0x00000000125c783bULL, 0x000ee80000004200ULL,
0x00000000133c783bULL, 0x000ea80000004200ULL, 0x000000001160783bULL, 0x016e620000004200ULL,
0x0000010030b67824ULL, 0x040fe200078e00ffULL, 0x0000003000be7306ULL, 0x000fe20000009400ULL,
0x0001000030d57824ULL, 0x000fe200078e00ffULL, 0x00000018ffe87819ULL, 0x000fe20000011430ULL,
0x0000010031e77824ULL, 0x040fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0001000031e37824ULL, 0x000fe200078e00ffULL, 0x00000018ffd57819ULL, 0x000fe200000114d5ULL,
0x0000010033da7824ULL, 0x040fe200078e00ffULL, 0x000000b600ca7306ULL, 0x000fe20000209400ULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x0000010032de7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd67819ULL, 0x000fe20000011431ULL, 0x0001000032d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe37819ULL, 0x000fe200000114e3ULL, 0x0001000033d17824ULL, 0x000fe200078e00ffULL,
0x00000018ffda7819ULL, 0x000fe200000114daULL, 0x000000b600cd7306ULL, 0x0005220000205400ULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x000100005dec7824ULL, 0x008fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe2000001145cULL, 0x000001003ebc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd97819ULL, 0x000fc400000114d9ULL, 0x00000018ffd17819ULL, 0x000fe200000114d1ULL,
0x0000003000bf7306ULL, 0x000ee20000005400ULL, 0x000000b600b67245ULL, 0x004fe4000020d400ULL,
0x00000018ffb17819ULL, 0x000fe40000011433ULL, 0x00000018ff847819ULL, 0x000fe4000001145fULL,
0x00000018ffb97819ULL, 0x000fe20000011432ULL, 0x000000d500d07306ULL, 0x000fe20000209400ULL,
0x000000cdca00720bULL, 0x010fc40003fdd000ULL, 0x00000018ff947819ULL, 0x000fe4000001145dULL,
0x00000018ffaa7819ULL, 0x000fe4000001143cULL, 0x00000018ffb07819ULL, 0x000fe2000001143dULL,
0x000000d500eb7306ULL, 0x000ea20000205400ULL, 0x000000bfbe00720bULL, 0x008fe20003f9d000ULL,
0x000001003fbf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe4000001143eULL,
0x00000018ffbc7819ULL, 0x000fc400000114bcULL, 0x00000001b6b66812ULL, 0x000fe200078efcffULL,
0x0000003100c37306ULL, 0x000fe20000009400ULL, 0x00000018ffbf7819ULL, 0x000fe400000114bfULL,
0x00000018ff967819ULL, 0x000fe4000001143fULL, 0x00000018ff877819ULL, 0x000fe4000001145eULL,
0x00000018ff787819ULL, 0x002fe20000011460ULL, 0x0000003100c47306ULL, 0x000e620000005400ULL,
0x000000ebd000720bULL, 0x004fe20003fbd000ULL, 0x000000ffffd07224ULL, 0x000fe200078e00b5ULL,
0x00000018ff727819ULL, 0x000fe20000011461ULL, 0x000001005cb57824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe20000011462ULL, 0x000001005deb7824ULL, 0x000fe200078e00ffULL,
0x000000ffd000720cULL, 0x000fe20003f25270ULL, 0x000000e800c77306ULL, 0x000fe20000209400ULL,
0x000001005fd07824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fc400000114b5ULL,
0x00000018ff677819ULL, 0x000fe40000011463ULL, 0x00000018ffd07819ULL, 0x000fe400000114d0ULL,
0x000000e800ea7306ULL, 0x000ea20000205400ULL, 0x000000c4c300720bULL, 0x002fce0003f7d000ULL,
0x000000e700cc7306ULL, 0x000ff00000209400ULL, 0x000000e700cf7306ULL, 0x000e620000205400ULL,
0x000000eac700720bULL, 0x004fe20003f5d000ULL, 0x000100005cea7824ULL, 0x000fcc00078e00ffULL,
0x00000030008f7306ULL, 0x0004f0000000d400ULL, 0x000000d600d47306ULL, 0x000fe20000209400ULL,
0x000000cfcc00720bULL, 0x002fe20003fdd000ULL, 0x000001003d307824ULL, 0x004fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000d600d37306ULL, 0x0003e20000205400ULL,
0x000000018f8f4812ULL, 0x008fce00078efcffULL, 0x000000e300e97306ULL, 0x000fe20000209400ULL,
0x000000d600d67245ULL, 0x002fce000020d400ULL, 0x000000e300ce7306ULL, 0x000e700000205400ULL,
0x00000031008e7306ULL, 0x0004f0000000d400ULL, 0x000000da00e17306ULL, 0x000fe20000209400ULL,
0x000000cee900720bULL, 0x002fe20003f9d000ULL, 0x000001003c317824ULL, 0x004fc400078e00ffULL,
0x000001005ee97824ULL, 0x040fe400078e00ffULL, 0x000100005ece7824ULL, 0x000fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x000000da00e67306ULL, 0x000e620000205400ULL,
0x000000018e8e3812ULL, 0x008fe400078efcffULL, 0x00000018ffe97819ULL, 0x000fe400000114e9ULL,
0x00000018ffce7819ULL, 0x000fc600000114ceULL, 0x000000de00e47306ULL, 0x000ff00000209400ULL,
0x000000de00e57306ULL, 0x000ea20000205400ULL, 0x000000e6e100720bULL, 0x002fe40003f7d000ULL,
0x00000018ffe17819ULL, 0x000fca00000114ebULL, 0x0000005c00a87306ULL, 0x000ff00000009400ULL,
0x0000005c00ad7306ULL, 0x000ff00000005400ULL, 0x0000005c007d7306ULL, 0x0003f0000000d400ULL,
0x0000003300d77306ULL, 0x000fe20000009400ULL, 0x000000d5005c7245ULL, 0x002fe2000020d400ULL,
0x000100005fd57824ULL, 0x000fc600078e00ffULL, 0x000000015c5c5812ULL, 0x000fe400078efcffULL,
0x000000d3d400720bULL, 0x000fe20003fbd000ULL, 0x0000003300d87306ULL, 0x000fe20000005400ULL,
0x000000e700d37245ULL, 0x000fe4000020d400ULL, 0x00000018ffd57819ULL, 0x000fe400000114d5ULL,
0x00000001d3d36812ULL, 0x000fe400078efcffULL, 0x000000e5e400720bULL, 0x004fe20003fdd000ULL,
0x000000d900df7306ULL, 0x000fe80000209400ULL, 0x00000001d6d65812ULL, 0x000fc800078efcffULL,
0x000000d900e07306ULL, 0x000e700000205400ULL, 0x0000003200e27306ULL, 0x000ff00000009400ULL,
0x0000003200db7306ULL, 0x000fe20000005400ULL, 0x000000e0df00720bULL, 0x002fce0003fbd000ULL,
0x000000d100dc7306ULL, 0x000ff00000209400ULL, 0x000000d100dd7306ULL, 0x0002b00000205400ULL,
0x0000003c00c17306ULL, 0x000fe20000009400ULL, 0x000000d100d17245ULL, 0x002fce000020d400ULL,
0x0000003c00c27306ULL, 0x000e700000005400ULL, 0x0000005f00997306ULL, 0x000ff00000009400ULL,
0x0000005f009c7306ULL, 0x000ff00000005400ULL, 0x0000005f00777306ULL, 0x0007f0000000d400ULL,
0x000000b100b37306ULL, 0x000fe20000209400ULL, 0x000000e3005f7245ULL, 0x008fc8000020d400ULL,
0x000000015f5f4812ULL, 0x000fe400078efcffULL, 0x000000d8d700720bULL, 0x000fe20003f9d000ULL,
0x000000b100b47306ULL, 0x000ee20000205400ULL, 0x000000da00d77245ULL, 0x000fe4000020d400ULL,
0x000000de00d87245ULL, 0x000fe4000020d400ULL, 0x00000001d7d73812ULL, 0x000fe400078efcffULL,
0x000000dddc00720bULL, 0x004fe20003f7d000ULL, 0x0000005d009d7306ULL, 0x000fe20000009400ULL,
0x00000001d8d86812ULL, 0x000fc400078efcffULL, 0x000000c2c100720bULL, 0x002fe40003fdd000ULL,
0x000000d900c17245ULL, 0x000fe4000020d400ULL, 0x0000003100c27245ULL, 0x000fe2000020d400ULL,
0x0000005d00927306ULL, 0x000fe20000005400ULL, 0x00000001c1c15812ULL, 0x000fe400078efcffULL,
0x000000b4b300720bULL, 0x008fe20003fbd000ULL, 0x0001000061b37824ULL, 0x000fe200078e00ffULL,
0x00000001d1d13812ULL, 0x000fc400078efcffULL, 0x000000b100b47245ULL, 0x000fe2000020d400ULL,
0x0000005d007c7306ULL, 0x0003e2000000d400ULL, 0x00000018ffb37819ULL, 0x000fce00000114b3ULL,
0x0000003200897306ULL, 0x0004e2000000d400ULL, 0x000000e8005d7245ULL, 0x002fe4000020d400ULL,
0x00000001b4b45812ULL, 0x000fe400078efcffULL, 0x000000015d5d2812ULL, 0x000fe400078efcffULL,
0x000000dbe200720bULL, 0x000fe20003f5d000ULL, 0x000000b900c57306ULL, 0x000fe20000209400ULL,
0x000100003c327824ULL, 0x004fe200078e00ffULL, 0x0000005c5d5c723eULL, 0x000fc400000010ffULL,
0x0000005fd65d723eULL, 0x000fe400000010ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x000000b900c67306ULL, 0x000e680000205400ULL, 0x0000000189892812ULL, 0x008fc800078efcffULL,
0x0000003000cb7306ULL, 0x000fe20000209400ULL, 0x00000089d8d6723eULL, 0x000fce00000010ffULL,
0x0000003000d27306ULL, 0x000ea20000205400ULL, 0x000000c6c500720bULL, 0x002fce0003f5d000ULL,
0x0000003d00b77306ULL, 0x000ff00000009400ULL, 0x0000003d00b87306ULL, 0x000fe20000005400ULL,
0x000000d2cb00720bULL, 0x004fe20003f7d000ULL, 0x0000010060cb7824ULL, 0x000fcc00078e00ffULL,
0x0000003d00827306ULL, 0x0003f0000000d400ULL, 0x0000003300887306ULL, 0x000ea2000000d400ULL,
0x000100003d3d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000000aa00a67306ULL, 0x000ff00000209400ULL, 0x000000aa00a57306ULL, 0x000e620000205400ULL,
0x0000000188884812ULL, 0x004fc400078efcffULL, 0x000000b8b700720bULL, 0x000fe40003f9d000ULL,
0x000000b900b87245ULL, 0x000fe2000020d400ULL, 0x0001000060b97824ULL, 0x000fe200078e00ffULL,
0x00000018ffb77819ULL, 0x000fe200000114ecULL, 0x0000003100c87306ULL, 0x000fe20000209400ULL,
0x00000001b8b82812ULL, 0x000fe400078efcffULL, 0x00000088d7d7723eULL, 0x000fe400000010ffULL,
0x000000c1b8b8723eULL, 0x000fc600000010ffULL, 0x0000003100c97306ULL, 0x000ea20000205400ULL,
0x000000a5a600720bULL, 0x002fe40003fbd000ULL, 0x0000003000a57245ULL, 0x000fe4000020d400ULL,
0x0000000182824812ULL, 0x000fe400078efcffULL, 0x00000001a5a53812ULL, 0x000fe200078efcffULL,
0x0000003d00ba7306ULL, 0x000fe20000209400ULL, 0x0000003200a67245ULL, 0x000fe4000020d400ULL,
0x00000082a5a5723eULL, 0x000fca00000010ffULL, 0x0000003d00bb7306ULL, 0x000e620000205400ULL,
0x000000c9c800720bULL, 0x004fe20003f5d000ULL, 0x0000010061c87824ULL, 0x000fca00078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000003c00857306ULL, 0x000eac000000d400ULL,
0x00000001c2c22812ULL, 0x000fe400078efcffULL, 0x0000003e00a47306ULL, 0x000fe20000009400ULL,
0x000000bbba00720bULL, 0x002fce0003f7d000ULL, 0x0000003e00a77306ULL, 0x000e620000005400ULL,
0x0000000185856812ULL, 0x004fce00078efcffULL, 0x0000003200337306ULL, 0x000ff00000209400ULL,
0x00000032003c7306ULL, 0x000ea20000205400ULL, 0x000000a7a400720bULL, 0x002fe40003fdd000ULL,
0x0000003d00a77245ULL, 0x000fc8000020d400ULL, 0x00000001a7a73812ULL, 0x000fe200078efcffULL,
0x0000003f00a97306ULL, 0x000ff00000009400ULL, 0x0000003f00ac7306ULL, 0x000e620000005400ULL,
0x0000003c3300720bULL, 0x004fc40003f5d000ULL, 0x0000a800103c7811ULL, 0x000fca00078e20ffULL,
0x000000b000b27306ULL, 0x000fec0000209400ULL, 0x00000001a6a62812ULL, 0x000fe400078efcffULL,
0x000000b000a37306ULL, 0x0004e20000205400ULL, 0x000000aca900720bULL, 0x002fe40003f7d000ULL,
0x0000009f00a97245ULL, 0x000fca000020d400ULL, 0x0000003e00817306ULL, 0x000322000000d400ULL,
0x000000b000b07245ULL, 0x004fce000020d400ULL, 0x0000009f00ae7306ULL, 0x000fe20000209400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000a3b200720bULL, 0x008fe40003f9d000ULL,
0x000000aa00a37245ULL, 0x000fe4000020d400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000009f00af7306ULL, 0x000e620000205400ULL, 0x00000001a3a35812ULL, 0x000fe400078efcffULL,
0x0000000181816812ULL, 0x010fc400078efcffULL, 0x000000a6a3a6723eULL, 0x000fe400000010ffULL,
0x00000001b0b04812ULL, 0x000fe200078efcffULL, 0x000000bf00c07306ULL, 0x000fe60000209400ULL,
0x000000a7b0a7723eULL, 0x000fca00000010ffULL, 0x000000bf00c37306ULL, 0x0004e20000205400ULL,
0x000000afae00720bULL, 0x002fce0003fdd000ULL, 0x0000003f00807306ULL, 0x000322000000d400ULL,
0x000000bf00bf7245ULL, 0x004fca000020d400ULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x000000bc00bd7306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fe200078e00ffULL,
0x000000c3c000720bULL, 0x008fc80003fbd000ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000000bc00be7306ULL, 0x0002a20000205400ULL, 0x0000000180803812ULL, 0x010fe400078efcffULL,
0x0000003f009f7245ULL, 0x000fc8000020d400ULL, 0x00000001bfbf5812ULL, 0x000fe200078efcffULL,
0x0000009600a27306ULL, 0x000fe20000209400ULL, 0x000000bc00bc7245ULL, 0x002fce000020d400ULL,
0x0000009600ab7306ULL, 0x0002e20000205400ULL, 0x000000bebd00720bULL, 0x004fe40003f5d000ULL,
0x00000080bfbd723eULL, 0x000fca00000010ffULL, 0x0000003e00c47306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x002fca000020d400ULL, 0x00000001bcbc2812ULL, 0x000fe400078efcffULL,
0x0000003e00c77306ULL, 0x000e620000205400ULL, 0x000000aba200720bULL, 0x008fe40003f7d000ULL,
0x000000ada800720bULL, 0x000fe40003f5d000ULL, 0x0000003e00a87245ULL, 0x000fe4000020d400ULL,
0x00000081bcbc723eULL, 0x000fe200000010ffULL, 0x0000009b00a17306ULL, 0x000fec0000209400ULL,
0x0000000196963812ULL, 0x000fc400078efcffULL, 0x0000009b00a07306ULL, 0x0004e20000205400ULL,
0x000000c7c400720bULL, 0x002fe40003f9d000ULL, 0x000000017d7d2812ULL, 0x000fca00078efcffULL,
0x0000003f00ca7306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x004fca000020d400ULL,
0x00000001a8a84812ULL, 0x000fe400078efcffULL, 0x0000003f00cd7306ULL, 0x0002a20000205400ULL,
0x000000a0a100720bULL, 0x008fe40003fdd000ULL, 0x000000b500a07245ULL, 0x000fe4000020d400ULL,
0x00000018ffa17819ULL, 0x000fc600000114cbULL, 0x000000e100da7306ULL, 0x000fe20000209400ULL,
0x000000003c3c783bULL, 0x002e6a0000000200ULL, 0x000000019b9b6812ULL, 0x000fe400078efcffULL,
0x000000e100c57306ULL, 0x0007220000205400ULL, 0x000000cdca00720bULL, 0x004fce0003fbd000ULL,
0x000000b500cc7306ULL, 0x000fe20000209400ULL, 0x000000e100e17245ULL, 0x008fca000020d400ULL,
0x000000019f9f5812ULL, 0x000fe400078efcffULL, 0x000000b500cf7306ULL, 0x000ea20000205400ULL,
0x000000c5da00720bULL, 0x010fe40003f7d000ULL, 0x0000009f969f723eULL, 0x000fca00000010ffULL,
0x0000005e009e7306ULL, 0x000fec0000009400ULL, 0x00000001e1e13812ULL, 0x000fe400078efcffULL,
0x0000005e00917306ULL, 0x000ee20000005400ULL, 0x000000cfcc00720bULL, 0x004fe20003f9d000ULL,
0x000000733c3c9231ULL, 0x082fe200003400ffULL, 0x000000d500cf7245ULL, 0x000fe2000020d400ULL,
0x000000733e3e9231ULL, 0x000fc400003400ffULL, 0x000000743d3d9231ULL, 0x080fe400003400ffULL,
0x0000005e00757306ULL, 0x0002a2000000d400ULL, 0x000000743f3f9231ULL, 0x000fca00003400ffULL,
0x00000001a0a04812ULL, 0x000fe400078efcffULL, 0x000000e900317306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x002fe200000114eaULL, 0x0000005c3c50723cULL, 0x040fe20000041850ULL,
0x000000919e00720bULL, 0x008fe40003f7d000ULL, 0x000000929d00720bULL, 0x000fe40003f9d000ULL,
0x000000e900927245ULL, 0x000fe2000020d400ULL, 0x0000005e00d47306ULL, 0x000fe20000209400ULL,
0x000000a1005d7245ULL, 0x000fe2000020d400ULL, 0x000000d63c4c723cULL, 0x000fe2000004184cULL,
0x0000007da0a0723eULL, 0x000fc400000010ffULL, 0x000000a8a99e723eULL, 0x000fc600000010ffULL,
0x0000005e00db7306ULL, 0x0002e20000205400ULL, 0x0000000175753812ULL, 0x004fe200078efcffULL,
0x000000a63c40723cULL, 0x000fe20000041840ULL, 0x000000017c7c4812ULL, 0x000fe400078efcffULL,
0x0000009c9900720bULL, 0x000fc60003f9d000ULL, 0x000000e900307306ULL, 0x000ea20000205400ULL,
0x0000005e005e7245ULL, 0x002fe2000020d400ULL, 0x000000bc3c34723cULL, 0x000fec0000041834ULL,
0x0000009400957306ULL, 0x000fe20000209400ULL, 0x000000dbd400720bULL, 0x008fe40003fbd000ULL,
0x0000000177774812ULL, 0x000fca00078efcffULL, 0x0000009400987306ULL, 0x0002e20000205400ULL,
0x000000303100720bULL, 0x004fe40003fdd000ULL, 0x0000008ed331723eULL, 0x000fe400000010ffULL,
0x000000d0008e7245ULL, 0x000fe4000020d400ULL, 0x000000015e5e5812ULL, 0x000fe200078efcffULL,
0x000000b700c67306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fe4000020d400ULL,
0x0000008fb630723eULL, 0x000fc400000010ffULL, 0x00000018ff8f7819ULL, 0x000fe400000114b9ULL,
0x0000000192926812ULL, 0x000fe200078efcffULL, 0x000000b700c97306ULL, 0x0002a20000205400ULL,
0x000000989500720bULL, 0x008fe20003f5d000ULL, 0x000000303c54723cULL, 0x000fe20000041854ULL,
0x000000d1b4b9723eULL, 0x000fe400000010ffULL, 0x0000005e9b5e723eULL, 0x000fc600000010ffULL,
0x000000d000a47306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fe2000020d400ULL,
0x000000b83c48723cULL, 0x000fe20000041848ULL, 0x0000a8000f307811ULL, 0x000fc600078e20ffULL,
0x0000000194942812ULL, 0x000fe400078efcffULL, 0x000000d000b17306ULL, 0x000e620000205400ULL,
0x000000c9c600720bULL, 0x004fce0003fbd000ULL, 0x00000087008c7306ULL, 0x000fec0000209400ULL,
0x00000001b7b75812ULL, 0x000fe400078efcffULL, 0x00000087008d7306ULL, 0x0004e20000205400ULL,
0x000000b1a400720bULL, 0x002fe40003fdd000ULL, 0x00000085c2a4723eULL, 0x000fca00000010ffULL,
0x0000006000907306ULL, 0x000fe20000009400ULL, 0x0000008700877245ULL, 0x004fe2000020d400ULL,
0x000000a43c44723cULL, 0x040fe80000041844ULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x0000006000937306ULL, 0x000e620000005400ULL, 0x0000008d8c00720bULL, 0x008fe20003f7d000ULL,
0x0000009e3c3c723cULL, 0x000fe20000041838ULL, 0x000000778e77723eULL, 0x000fca00000010ffULL,
0x0000006100977306ULL, 0x000fec0000009400ULL, 0x0000000187873812ULL, 0x000fe400078efcffULL,
0x00000061009a7306ULL, 0x000ea20000005400ULL, 0x000000939000720bULL, 0x002fce0003fbd000ULL,
0x000000ce00327306ULL, 0x000ff00000209400ULL, 0x000000ce00337306ULL, 0x0002e20000205400ULL,
0x0000009a9700720bULL, 0x004fce0003f5d000ULL, 0x000000a1009d7306ULL, 0x000fe20000209400ULL,
0x000000ce00ce7245ULL, 0x002fce000020d400ULL, 0x000000a100987306ULL, 0x0002a20000205400ULL,
0x000000333200720bULL, 0x008fe40003fdd000ULL, 0x000000003030783bULL, 0x000eea0000000200ULL,
0x00000084008b7306ULL, 0x000fe20000209400ULL, 0x0000007ce1a1723eULL, 0x002fca00000010ffULL,
0x00000001cece6812ULL, 0x000fe400078efcffULL, 0x00000084008a7306ULL, 0x0003220000205400ULL,
0x000000989d00720bULL, 0x004fe40003f7d000ULL, 0x000000ce87ce723eULL, 0x000fca00000010ffULL,
0x000000d500a27306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x002fca000020d400ULL,
0x000000015d5d3812ULL, 0x000fe400078efcffULL, 0x000000d500ab7306ULL, 0x000e620000205400ULL,
0x0000008a8b00720bULL, 0x010fce0003f9d000ULL, 0x00000060006e7306ULL, 0x000522000000d400ULL,
0x0000007330309231ULL, 0x088fe400003400ffULL, 0x0000007332329231ULL, 0x000fc600003400ffULL,
0x0000000184844812ULL, 0x000fe200078efcffULL, 0x0000007431319231ULL, 0x080fe200003400ffULL,
0x000000c800917306ULL, 0x000fe20000209400ULL, 0x000000aba200720bULL, 0x002fe20003fdd000ULL,
0x0000010063607824ULL, 0x004fe200078e00ffULL, 0x0000007433339231ULL, 0x000fc800003400ffULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x000000c8009a7306ULL, 0x0002a20000205400ULL,
0x000000016e6e5812ULL, 0x010fe200078efcffULL, 0x000000a03054723cULL, 0x000fe60000041854ULL,
0x0000006e5d6e723eULL, 0x000fe400000010ffULL, 0x00000001cfcf6812ULL, 0x000fe200078efcffULL,
0x0000008f00907306ULL, 0x000fe20000209400ULL, 0x000000c800c87245ULL, 0x002fc4000020d400ULL,
0x000000cf84cf723eULL, 0x000fca00000010ffULL, 0x0000008f005f7306ULL, 0x0002e20000205400ULL,
0x0000009a9100720bULL, 0x004fe20003f7d000ULL, 0x000000ce3048723cULL, 0x000fec0000041848ULL,
0x0000006200867306ULL, 0x000fe20000009400ULL, 0x0000008f008f7245ULL, 0x002fca000020d400ULL,
0x00000001c8c83812ULL, 0x000fe400078efcffULL, 0x0000006200837306ULL, 0x000e620000005400ULL,
0x0000005f9000720bULL, 0x008fe40003fbd000ULL, 0x000000b7945f723eULL, 0x000fca00000010ffULL,
0x00000063007f7306ULL, 0x000fe40000009400ULL, 0x0000005e3050723cULL, 0x000fe80000041850ULL,
0x000000018f8f5812ULL, 0x000fe400078efcffULL, 0x00000063007e7306ULL, 0x000ea20000005400ULL,
0x000000838600720bULL, 0x002fce0003fdd000ULL, 0x00000078007b7306ULL, 0x000ff00000209400ULL,
0x00000078007a7306ULL, 0x0002e20000205400ULL, 0x0000007e7f00720bULL, 0x004fce0003f9d000ULL,
0x0000007200767306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x002fce000020d400ULL,
0x0000007200797306ULL, 0x0002a20000205400ULL, 0x0000007a7b00720bULL, 0x008fce0003f7d000ULL,
0x00000061006f7306ULL, 0x000722000000d400ULL, 0x0000007200727245ULL, 0x002fca000020d400ULL,
0x0000000178783812ULL, 0x000fe400078efcffULL, 0x000000b3005c7306ULL, 0x000fe20000209400ULL,
0x0000010062617824ULL, 0x008fe200078e00ffULL, 0x000000797600720bULL, 0x004fe40003fbd000ULL,
0x000000b300797245ULL, 0x000fe4000020d400ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x000000b300897306ULL, 0x000e620000205400ULL, 0x000000016f6f2812ULL, 0x010fc400078efcffULL,
0x000000759276723eULL, 0x000fe400000010ffULL, 0x0000006fc86f723eULL, 0x000fe400000010ffULL,
0x0000000172725812ULL, 0x000fe200078efcffULL, 0x0000006100827306ULL, 0x000fe20000209400ULL,
0x0000008f7878723eULL, 0x000fe200000010ffULL, 0x00000076304c723cULL, 0x040fec000004184cULL,
0x0000006100837306ULL, 0x0004e20000205400ULL, 0x000000895c00720bULL, 0x002fe20003f5d000ULL,
0x0000006e3044723cULL, 0x000fec0000041844ULL, 0x00000060007e7306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x004fca000020d400ULL, 0x0000000179792812ULL, 0x000fe400078efcffULL,
0x00000060007d7306ULL, 0x0002a20000205400ULL, 0x000000838200720bULL, 0x008fe40003f7d000ULL,
0x000000797279723eULL, 0x000fca00000010ffULL, 0x00000062006a7306ULL, 0x000722000000d400ULL,
0x0000006000607245ULL, 0x002fe2000020d400ULL, 0x000000783040723cULL, 0x000fe80000041840ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x00000063006b7306ULL, 0x000322000000d400ULL,
0x0001000062627824ULL, 0x008fe200078e00ffULL, 0x0000007d7e00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000005a00717306ULL, 0x000fe20000209400ULL,
0x0001000063637824ULL, 0x002fe200078e00ffULL, 0x000000016a6a6812ULL, 0x010fc800078efcffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000005a00707306ULL, 0x000e620000205400ULL,
0x0000000160605812ULL, 0x000fe400078efcffULL, 0x000000016b6b4812ULL, 0x000fe400078efcffULL,
0x0000006a616a723eULL, 0x000fe400000010ffULL, 0x0000006b606b723eULL, 0x000fe200000010ffULL,
0x00000067006d7306ULL, 0x000fec0000209400ULL, 0x0000006a3034723cULL, 0x000fe40000041834ULL,
0x00000067006c7306ULL, 0x000ea20000205400ULL, 0x000000707100720bULL, 0x002fce0003f5d000ULL,
0x0000006200387306ULL, 0x000ff00000209400ULL, 0x0000006200397306ULL, 0x0002e20000205400ULL,
0x0000006c6d00720bULL, 0x004fce0003f7d000ULL, 0x00000063003a7306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x002fce000020d400ULL, 0x00000063003b7306ULL, 0x0002a20000205400ULL,
0x000000393800720bULL, 0x008fe40003fdd000ULL, 0x0000005a00397245ULL, 0x000fe4000020d400ULL,
0x0000006700387245ULL, 0x000fe4000020d400ULL, 0x0000000139392812ULL, 0x000fe400078efcffULL,
0x0000006300637245ULL, 0x002fe4000020d400ULL, 0x0000000138383812ULL, 0x000fc600078efcffULL,
0x0000000162626812ULL, 0x000fe400078efcffULL, 0x0000003b3a00720bULL, 0x004fe40003fbd000ULL,
0x000000623962723eULL, 0x000fd600000010ffULL, 0x0000000163635812ULL, 0x000fc800078efcffULL,
0x000000633863723eULL, 0x000fce00000010ffULL, 0x00000062303c723cULL, 0x000fe2000004183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff327f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000580026307a24ULL, 0x020fe200078e02ffULL, 0x000000802b317811ULL, 0x000fc600078e40ffULL,
0x0000004030327824ULL, 0x000fe200078e00ffULL, 0x000000312c307217ULL, 0x000fc80007800000ULL,
0x0000000e32337210ULL, 0x000fe20007f5e0ffULL, 0x0000000130307824ULL, 0x000fe200078e0a31ULL,
0x0000000d32397210ULL, 0x000fe40007f7e0ffULL, 0x00000004ff317819ULL, 0x000fe2000001162dULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x00005e00335a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e00395c7a11ULL, 0x000fe400078640ffULL,
0x00005f0033337a11ULL, 0x000fc400010f4438ULL, 0x0000000c32387210ULL, 0x040fe40007f5e0ffULL,
0x00005f0039397a11ULL, 0x000fe400018f443aULL, 0x0000000b32327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x0000002030307807ULL, 0x000fe40000000000ULL,
0x00005e00385e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff5d7224ULL, 0x000fe200018e06ffULL,
0x0000003027307217ULL, 0x000fc40007800000ULL, 0x00005e0032607a11ULL, 0x000fe400078640ffULL,
0x00005f00383b7a11ULL, 0x000fe200010f443bULL, 0x00000001303a7824ULL, 0x000fe200078e0a27ULL,
0x00005f00325d7a11ULL, 0x000fe400018f445dULL, 0x0000001b5a307210ULL, 0x080fe40007f7e0ffULL,
0x0000001b5c327210ULL, 0x080fe40007f9e0ffULL, 0x0000001b5e387210ULL, 0x000fc40007fbe0ffULL,
0x0000003a3100720cULL, 0x080fe20003f46070ULL, 0x000000ffff317224ULL, 0x000fe200018e0633ULL,
0x0000003a2100720cULL, 0x080fe20003f66070ULL, 0x000000ffff337224ULL, 0x000fe200020e0639ULL,
0x0000003a2000720cULL, 0x080fe20003f86070ULL, 0x000000ffff397224ULL, 0x000fe200028e063bULL,
0x0000003a1f00720cULL, 0x000fe40003fa6070ULL, 0x0000001b603a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e065dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000300a7faeULL, 0x0003e8000d101c46ULL, 0x0000000032097faeULL, 0x0003e8000d901c46ULL,
0x0000000038087faeULL, 0x0003e8000e101c46ULL, 0x000000003a077faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e0031ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff30723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x000fe4000001162dULL,
0x0000541030637816ULL, 0x000fe20000000030ULL, 0x000157f27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c63877589ULL, 0x0002a400000e0000ULL, 0x000158327f007947ULL, 0x000fea000b800000ULL,
0x00001f2f63867589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0066ULL, 0x00009470005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x000163d000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0065ULL, 0x000094d0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0001637000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000630783bULL, 0x000f680000004200ULL, 0x000000000460783bULL, 0x00efe80000004200ULL,
0x000000000538783bULL, 0x000e680000004200ULL, 0x00000000035c783bULL, 0x000ea20000004200ULL,
0x0000010030e77824ULL, 0x060fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe20000011430ULL,
0x0001000030c17824ULL, 0x000fe200078e00ffULL, 0x0000003000aa7306ULL, 0x000fe20000009400ULL,
0x0000010031e67824ULL, 0x040fe200078e00ffULL, 0x00000018ffe77819ULL, 0x000fe200000114e7ULL,
0x0001000031e27824ULL, 0x000fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000010032dd7824ULL, 0x040fe200078e00ffULL, 0x00000018ffe67819ULL, 0x000fe200000114e6ULL,
0x0000010033c87824ULL, 0x040fe200078e00ffULL, 0x000000e700ad7306ULL, 0x000fe20000209400ULL,
0x00000018ffc97819ULL, 0x000fe20000011431ULL, 0x0001000032da7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x0001000033d47824ULL, 0x000fe200078e00ffULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x000001003aa77824ULL, 0x002fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000000e700b47306ULL, 0x000e620000205400ULL,
0x00000018ffa47819ULL, 0x000fe20000011460ULL, 0x0000010038cd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffda7819ULL, 0x000fe200000114daULL, 0x000001003ba97824ULL, 0x040fe200078e00ffULL,
0x00000018ffa27819ULL, 0x000fe2000001143aULL, 0x000100003bb37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fe20000011432ULL, 0x0000003000ab7306ULL, 0x000ee20000005400ULL,
0x00000018ff7e7819ULL, 0x000fc40000011463ULL, 0x00000018ffd47819ULL, 0x000fe400000114d4ULL,
0x00000018ffbe7819ULL, 0x000fe40000011433ULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x000000c100e87306ULL, 0x000fe20000209400ULL, 0x000000b4ad00720bULL, 0x002fe40003f9d000ULL,
0x00000018ffb97819ULL, 0x000fe40000011438ULL, 0x00000018ff9f7819ULL, 0x000fc40000011439ULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x000000c100eb7306ULL, 0x000e620000205400ULL,
0x000000abaa00720bULL, 0x008fe20003fdd000ULL, 0x000100003aaa7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fe400000114a9ULL, 0x00000018ff9e7819ULL, 0x000fe4000001143bULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000c300e97306ULL, 0x000fe20000209400ULL,
0x00000018ffb37819ULL, 0x000fc400000114b3ULL, 0x00000018ff847819ULL, 0x000fe40000011462ULL,
0x00000018ff8e7819ULL, 0x000fe40000011461ULL, 0x00000018ff6d7819ULL, 0x004fe2000001145dULL,
0x000000c300b67306ULL, 0x000ea20000205400ULL, 0x000000ebe800720bULL, 0x002fe20003f5d000ULL,
0x0000010061e87824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe4000001145cULL,
0x00000018ff677819ULL, 0x000fc4000001145eULL, 0x00000018ff687819ULL, 0x000fe2000001145fULL,
0x0000003100af7306ULL, 0x000ff00000009400ULL, 0x0000003100ae7306ULL, 0x000e620000005400ULL,
0x000000b6e900720bULL, 0x004fe20003fbd000ULL, 0x0001000061e97824ULL, 0x000fe200078e00ffULL,
0x000000e700b67245ULL, 0x000fe2000020d400ULL, 0x0001000060e77824ULL, 0x000fc600078e00ffULL,
0x00000001b6b64812ULL, 0x000fe200078efcffULL, 0x000000e600ea7306ULL, 0x000ff00000209400ULL,
0x000000e600ed7306ULL, 0x000ea20000205400ULL, 0x000000aeaf00720bULL, 0x002fe20003f7d000ULL,
0x0000010060af7824ULL, 0x000fca00078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x00000030008f7306ULL, 0x0002f0000000d400ULL, 0x000000c900c77306ULL, 0x000fe20000209400ULL,
0x000000edea00720bULL, 0x004fe20003f9d000ULL, 0x0000010039307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000c900c67306ULL, 0x0003e20000205400ULL,
0x000000018f8f6812ULL, 0x008fc800078efcffULL, 0x0000008fb6b6723eULL, 0x000fe400000010ffULL,
0x0000008e008f7245ULL, 0x000fe2000020d400ULL, 0x000000e200ef7306ULL, 0x000fe20000209400ULL,
0x000000c900c97245ULL, 0x002fce000020d400ULL, 0x000000e200ec7306ULL, 0x000e700000205400ULL,
0x0000003200c47306ULL, 0x000ff00000009400ULL, 0x0000003200e17306ULL, 0x000fe20000005400ULL,
0x000000ecef00720bULL, 0x002fce0003fdd000ULL, 0x00000031008d7306ULL, 0x0002b0000000d400ULL,
0x000000dd00e37306ULL, 0x000fe20000209400ULL, 0x0001000038317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x000000dd00e47306ULL, 0x000fe20000205400ULL,
0x000000018d8d3812ULL, 0x004fce00078efcffULL, 0x000000c800d27306ULL, 0x000ff00000209400ULL,
0x000000c800e57306ULL, 0x0002b00000205400ULL, 0x0000006000937306ULL, 0x000fe20000009400ULL,
0x000000c800c87245ULL, 0x002fce000020d400ULL, 0x0000006000a07306ULL, 0x000fe20000005400ULL,
0x000000e5d200720bULL, 0x004fce0003f7d000ULL, 0x0000006000787306ULL, 0x0003ec000000d400ULL,
0x00000001c8c83812ULL, 0x000fe400078efcffULL, 0x0000003300cf7306ULL, 0x000fe20000009400ULL,
0x000000c100607245ULL, 0x002fe2000020d400ULL, 0x0001000063c17824ULL, 0x000fc600078e00ffULL,
0x0000000160602812ULL, 0x000fe400078efcffULL, 0x000000c6c700720bULL, 0x000fe20003f5d000ULL,
0x0000003300dc7306ULL, 0x000fe20000005400ULL, 0x000000e600c67245ULL, 0x000fe4000020d400ULL,
0x00000018ffc17819ULL, 0x000fe400000114c1ULL, 0x00000001c6c64812ULL, 0x000fe400078efcffULL,
0x000000e4e300720bULL, 0x000fe20003f9d000ULL, 0x000000da00df7306ULL, 0x000fe80000209400ULL,
0x00000001c9c92812ULL, 0x000fc800078efcffULL, 0x000000da00e07306ULL, 0x000e700000205400ULL,
0x0000003a00b17306ULL, 0x000ff00000009400ULL, 0x0000003a00ba7306ULL, 0x000fe20000005400ULL,
0x000000e0df00720bULL, 0x002fce0003f5d000ULL, 0x0000003a007f7306ULL, 0x0003f0000000d400ULL,
0x0000006300a67306ULL, 0x000fe20000009400ULL, 0x00000100633a7824ULL, 0x002fce00078e00ffULL,
0x0000006300957306ULL, 0x000ff00000005400ULL, 0x0000006300727306ULL, 0x0003f0000000d400ULL,
0x00000032008a7306ULL, 0x000ea2000000d400ULL, 0x000000c300637245ULL, 0x002fc4000020d400ULL,
0x00000018ffc37819ULL, 0x000fe400000114e8ULL, 0x0000000163635812ULL, 0x000fe400078efcffULL,
0x000000e1c400720bULL, 0x000fe20003fbd000ULL, 0x000000c000d67306ULL, 0x000fe20000209400ULL,
0x000000e200c47245ULL, 0x000fe4000020d400ULL, 0x000000606360723eULL, 0x000fe400000010ffULL,
0x00000001c4c46812ULL, 0x000fc400078efcffULL, 0x000000dccf00720bULL, 0x000fe20003fdd000ULL,
0x000000c000d77306ULL, 0x000e620000205400ULL, 0x000000dd00cf7245ULL, 0x000fe4000020d400ULL,
0x00000018ffdc7819ULL, 0x000fe400000114e7ULL, 0x000000018a8a5812ULL, 0x004fe400078efcffULL,
0x00000001cfcf4812ULL, 0x000fe200078efcffULL, 0x0000003800d07306ULL, 0x000fe60000009400ULL,
0x0000008acf8a723eULL, 0x000fca00000010ffULL, 0x0000003800d57306ULL, 0x000ea20000005400ULL,
0x000000d7d600720bULL, 0x002fce0003fbd000ULL, 0x000000d400db7306ULL, 0x000ff00000209400ULL,
0x000000d400de7306ULL, 0x0002e20000205400ULL, 0x000000d5d000720bULL, 0x004fe40003f9d000ULL,
0x000000da00d07245ULL, 0x000fc8000020d400ULL, 0x00000001d0d02812ULL, 0x000fe200078efcffULL,
0x0000003300857306ULL, 0x000562000000d400ULL, 0x000000d400d47245ULL, 0x002fce000020d400ULL,
0x000000be00c27306ULL, 0x000fe20000209400ULL, 0x000000dedb00720bULL, 0x008fe20003f7d000ULL,
0x0001000039337824ULL, 0x004fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x000000be00bf7306ULL, 0x000e620000205400ULL, 0x0000000185856812ULL, 0x020fca00078efcffULL,
0x00000001d4d43812ULL, 0x000fe400078efcffULL, 0x000000cd00d87306ULL, 0x000ff00000209400ULL,
0x000000cd00d97306ULL, 0x000ea20000205400ULL, 0x000000bfc200720bULL, 0x002fc40003fdd000ULL,
0x000000c000bf7245ULL, 0x000fe4000020d400ULL, 0x00000018ffc27819ULL, 0x000fe400000114e9ULL,
0x00000001bfbf5812ULL, 0x000fe200078efcffULL, 0x0000003000ce7306ULL, 0x000fe60000209400ULL,
0x000000d0bfd0723eULL, 0x000fca00000010ffULL, 0x0000003000d37306ULL, 0x000e620000205400ULL,
0x000000d9d800720bULL, 0x004fce0003f5d000ULL, 0x0000003900bd7306ULL, 0x000ff00000009400ULL,
0x0000003900b27306ULL, 0x000ea20000005400ULL, 0x000000d3ce00720bULL, 0x002fe20003fbd000ULL,
0x000100005dce7824ULL, 0x000fe200078e00ffULL, 0x000000be00d37245ULL, 0x000fc8000020d400ULL,
0x00000001d3d36812ULL, 0x000fe200078efcffULL, 0x000000b900bb7306ULL, 0x000ff00000209400ULL,
0x000000b900ac7306ULL, 0x0002e20000205400ULL, 0x000000b2bd00720bULL, 0x004fc40003f7d000ULL,
0x000000cd00b27245ULL, 0x000fc8000020d400ULL, 0x00000001b2b22812ULL, 0x000fe200078efcffULL,
0x0000003100ca7306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fce000020d400ULL,
0x0000003100d17306ULL, 0x000e620000205400ULL, 0x000000acbb00720bULL, 0x008fe40003f5d000ULL,
0x0000003000bb7245ULL, 0x000fe4000020d400ULL, 0x0000003100ac7245ULL, 0x000fe4000020d400ULL,
0x00000001bbbb5812ULL, 0x000fe200078efcffULL, 0x0000003300cb7306ULL, 0x000fe20000209400ULL,
0x0000a80002307811ULL, 0x000fca00078e20ffULL, 0x00000001b9b92812ULL, 0x000fe400078efcffULL,
0x0000003300cc7306ULL, 0x000ea20000205400ULL, 0x000000d1ca00720bULL, 0x002fe20003fdd000ULL,
0x000100005cca7824ULL, 0x000fe200078e00ffULL, 0x000000d4d3d1723eULL, 0x000fca00000010ffULL,
0x0000003800837306ULL, 0x000e6c000000d400ULL, 0x00000001acac6812ULL, 0x000fe400078efcffULL,
0x0000003900827306ULL, 0x000ee2000000d400ULL, 0x000000cccb00720bULL, 0x004fe20003fbd000ULL,
0x000001005dcc7824ULL, 0x000fcc00078e00ffULL, 0x0000009f00b77306ULL, 0x000fe20000209400ULL,
0x0000000183834812ULL, 0x002fe400078efcffULL, 0x000000bab100720bULL, 0x000fe20003f9d000ULL,
0x000001005eb17824ULL, 0x000fe200078e00ffULL, 0x00000018ffba7819ULL, 0x000fe4000001143aULL,
0x00000083b2b2723eULL, 0x000fe200000010ffULL, 0x0000009f00b07306ULL, 0x0002a20000205400ULL,
0x0000000182823812ULL, 0x008fe400078efcffULL, 0x00000018ffb17819ULL, 0x000fca00000114b1ULL,
0x000000a700387306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fe4000020d400ULL,
0x000000017f7f4812ULL, 0x000fca00078efcffULL, 0x000000a700397306ULL, 0x000e620000205400ULL,
0x000000b0b700720bULL, 0x004fe20003fdd000ULL, 0x000001005cb77824ULL, 0x000fe200078e00ffULL,
0x0000003300b07245ULL, 0x000fc8000020d400ULL, 0x00000001b0b05812ULL, 0x000fe200078efcffULL,
0x000000a900327306ULL, 0x000fec0000209400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000a900c57306ULL, 0x000ea20000205400ULL, 0x000000393800720bULL, 0x002fc40003f5d000ULL,
0x0000a80000387811ULL, 0x000fe400078e20ffULL, 0x000000b09f9f723eULL, 0x000fc600000010ffULL,
0x0000003b00bc7306ULL, 0x000ff00000009400ULL, 0x0000003b00b57306ULL, 0x000e620000005400ULL,
0x000000c53200720bULL, 0x004fe40003fbd000ULL, 0x000000003030783bULL, 0x000eaa0000000200ULL,
0x0000003b00797306ULL, 0x000770000000d400ULL, 0x000000dc00dd7306ULL, 0x000fe20000209400ULL,
0x00000100623b7824ULL, 0x008fe200078e00ffULL, 0x000000b5bc00720bULL, 0x002fc80003f7d000ULL,
0x00000018ffbd7819ULL, 0x000fe4000001143bULL, 0x000000003838783bULL, 0x000e620000000200ULL,
0x000000dc00d67306ULL, 0x0007ec0000205400ULL, 0x0000000179793812ULL, 0x020fe400078efcffULL,
0x000000a200967306ULL, 0x000fe20000209400ULL, 0x000000dc00dc7245ULL, 0x008fc4000020d400ULL,
0x000000a09300720bULL, 0x000fe40003f7d000ULL, 0x000000a200937245ULL, 0x000fc6000020d400ULL,
0x000000a2009b7306ULL, 0x000ee20000205400ULL, 0x0000008730309231ULL, 0x084fe400003400ffULL,
0x0000008732329231ULL, 0x000fe400003400ffULL, 0x0000008631319231ULL, 0x010fc600003400ffULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x0000008633339231ULL, 0x000fe200003400ffULL,
0x0000000178783812ULL, 0x000fe400078efcffULL, 0x00000095a600720bULL, 0x000fe40003f7d000ULL,
0x000000a400957245ULL, 0x000fe4000020d400ULL, 0x000000bd00cb7306ULL, 0x000ea20000205400ULL,
0x0000009b9600720bULL, 0x008fe20003fdd000ULL, 0x000000d03048723cULL, 0x000fe20000041848ULL,
0x000000a900967245ULL, 0x000fe2000020d400ULL, 0x0000008738389231ULL, 0x002fc800003400ffULL,
0x000000aa00ab7306ULL, 0x000fe20000209400ULL, 0x000000873a3a9231ULL, 0x000fe200003400ffULL,
0x0000000196965812ULL, 0x000fe200078efcffULL, 0x0000008639399231ULL, 0x080fe200003400ffULL,
0x00000018ff877819ULL, 0x000fe200000114ccULL, 0x000000863b3b9231ULL, 0x000fe200003400ffULL,
0x000000d6dd00720bULL, 0x000fe40003f3d000ULL, 0x000000aa00b47306ULL, 0x0003e20000205400ULL,
0x0000000193936812ULL, 0x000fe400078efcffULL, 0x000000c300867245ULL, 0x000fc4000020d400ULL,
0x0000000172723812ULL, 0x000fe400078efcffULL, 0x000000799663723eULL, 0x000fe200000010ffULL,
0x000000b300ad7306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fe4000020d400ULL,
0x00000001dcdc1812ULL, 0x000fe400078efcffULL, 0x000000cbbe00720bULL, 0x004fc60003f3d000ULL,
0x000000b300b87306ULL, 0x000e700000205400ULL, 0x00000062009d7306ULL, 0x000ff00000009400ULL,
0x0000006200907306ULL, 0x000ea20000005400ULL, 0x000000b8ad00720bULL, 0x002fce0003fbd000ULL,
0x0000006200737306ULL, 0x0002f0000000d400ULL, 0x0000009e00987306ULL, 0x000fe20000209400ULL,
0x0001000062627824ULL, 0x002fe200078e00ffULL, 0x000000909d00720bULL, 0x004fc40003fdd000ULL,
0x0000009e00907245ULL, 0x000fe4000020d400ULL, 0x00000018ffb57819ULL, 0x000fe40000011462ULL,
0x0000009e00a17306ULL, 0x000e620000205400ULL, 0x000000a700627245ULL, 0x000fc8000020d400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x000000b4ab00720bULL, 0x000fe20003f5d000ULL,
0x000000ba00bc7306ULL, 0x000fe20000209400ULL, 0x0000000173736812ULL, 0x008fe400078efcffULL,
0x0000007f6262723eULL, 0x000fca00000010ffULL, 0x000000ba00c57306ULL, 0x000fe20000205400ULL,
0x000000a19800720bULL, 0x002fe20003f9d000ULL, 0x000000623034723cULL, 0x000fe40000041834ULL,
0x00000001aaaa2812ULL, 0x000fc800078efcffULL, 0x0000006100947306ULL, 0x000fec0000009400ULL,
0x0000000190904812ULL, 0x000fe400078efcffULL, 0x0000006100917306ULL, 0x000e700000005400ULL,
0x0000006100757306ULL, 0x000eb0000000d400ULL, 0x000000af00ae7306ULL, 0x000fe20000209400ULL,
0x000000919400720bULL, 0x002fc40003f5d000ULL, 0x00000018ff917819ULL, 0x000fe400000114b7ULL,
0x0000008dc6b7723eULL, 0x000fc600000010ffULL, 0x000000af00617306ULL, 0x0003e80000205400ULL,
0x000000b63054723cULL, 0x000fe40000041854ULL, 0x0000000175752812ULL, 0x004fe400078efcffULL,
0x0000008400897306ULL, 0x000fe20000209400ULL, 0x000000af00af7245ULL, 0x002fce000020d400ULL,
0x0000008400887306ULL, 0x0002b00000205400ULL, 0x0000008e00a57306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x002fce000020d400ULL, 0x0000008e009c7306ULL, 0x0002e20000205400ULL,
0x000000888900720bULL, 0x004fe40003fdd000ULL, 0x000000ba00897245ULL, 0x000fca000020d400ULL,
0x000000c300c77306ULL, 0x000fe20000209400ULL, 0x000000bd008e7245ULL, 0x002fc8000020d400ULL,
0x000000018e8e1812ULL, 0x000fe400078efcffULL, 0x000000c5bc00720bULL, 0x000fe20003f3d000ULL,
0x000000c300d27306ULL, 0x000e620000205400ULL, 0x0000009ca500720bULL, 0x008fe40003f5d000ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x000000738e8e723eULL, 0x000fc600000010ffULL,
0x000000b500a77306ULL, 0x000fe80000209400ULL, 0x0000000189891812ULL, 0x000fe400078efcffULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x000000b500b47306ULL, 0x0004e20000205400ULL,
0x000000d2c700720bULL, 0x002fce0003f9d000ULL, 0x0000005d00a37306ULL, 0x000fe20000009400ULL,
0x000000b500b57245ULL, 0x004fca000020d400ULL, 0x0000000186864812ULL, 0x000fe400078efcffULL,
0x0000005d009a7306ULL, 0x000fe20000005400ULL, 0x000000b4a700720bULL, 0x008fe40003f3d000ULL,
0x000000758679723eULL, 0x000fca00000010ffULL, 0x0000005d006b7306ULL, 0x0003ec000000d400ULL,
0x00000001b5b51812ULL, 0x000fe400078efcffULL, 0x000000a400a87306ULL, 0x000fe20000209400ULL,
0x000000b3005d7245ULL, 0x002fe4000020d400ULL, 0x00000082bbb3723eULL, 0x000fc400000010ffULL,
0x000000015d5d5812ULL, 0x000fe400078efcffULL, 0x00000061ae00720bULL, 0x000fe20003fbd000ULL,
0x000000a400997306ULL, 0x000e620000205400ULL, 0x000000c4c961723eULL, 0x000fe200000010ffULL,
0x000000b23044723cULL, 0x000fe20000041844ULL, 0x0000005d905d723eULL, 0x000fe400000010ffULL,
0x000000b58484723eULL, 0x000fc600000010ffULL, 0x0000007e00817306ULL, 0x000fe40000209400ULL,
0x000000603050723cULL, 0x000fe40000041850ULL, 0x00000001afaf5812ULL, 0x000fc800078efcffULL,
0x0000007e00807306ULL, 0x0004e20000205400ULL, 0x00000099a800720bULL, 0x002fe40003fbd000ULL,
0x00000078af78723eULL, 0x000fca00000010ffULL, 0x000000c200c07306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x004fe2000020d400ULL, 0x000000783854723cULL, 0x000fe80000041854ULL,
0x0000000195955812ULL, 0x000fe400078efcffULL, 0x000000c200cd7306ULL, 0x0002a20000205400ULL,
0x000000808100720bULL, 0x008fe40003f3d000ULL, 0x000000dc95dc723eULL, 0x000fca00000010ffULL,
0x00000091009d7306ULL, 0x000fe20000209400ULL, 0x000000c200c27245ULL, 0x002fca000020d400ULL,
0x000000017e7e1812ULL, 0x000fe400078efcffULL, 0x00000091009e7306ULL, 0x0002e20000205400ULL,
0x000000cdc000720bULL, 0x004fce0003f9d000ULL, 0x0000005c00927306ULL, 0x000fe20000009400ULL,
0x0000009100917245ULL, 0x002fca000020d400ULL, 0x00000001c2c24812ULL, 0x000fe400078efcffULL,
0x0000005c00977306ULL, 0x000e620000005400ULL, 0x0000009e9d00720bULL, 0x008fe40003fdd000ULL,
0x0000009aa300720bULL, 0x000fe40003f9d000ULL, 0x000000acb99e723eULL, 0x000fe400000010ffULL,
0x000000c28fdd723eULL, 0x000fe200000010ffULL, 0x0000005e008c7306ULL, 0x000fe20000009400ULL,
0x00000072898f723eULL, 0x000fc600000010ffULL, 0x0000009e3040723cULL, 0x000fe40000041840ULL,
0x0000000191916812ULL, 0x000fe400078efcffULL, 0x0000005e008b7306ULL, 0x000ea20000005400ULL,
0x000000979200720bULL, 0x002fe40003fbd000ULL, 0x00000018ff927819ULL, 0x000fe200000114caULL,
0x000000dc3850723cULL, 0x000fe20000041850ULL, 0x000000016b6b4812ULL, 0x000fc600078efcffULL,
0x000000c100987306ULL, 0x000ff00000209400ULL, 0x000000c1009b7306ULL, 0x000e620000205400ULL,
0x0000008b8c00720bULL, 0x004fe40003f5d000ULL, 0x00000018ff8c7819ULL, 0x000fc400000114ceULL,
0x00000085c88b723eULL, 0x000fe400000010ffULL, 0x000000c100857245ULL, 0x000fe2000020d400ULL,
0x00000074007a7306ULL, 0x000fe80000209400ULL, 0x0000008a304c723cULL, 0x000fe8000004184cULL,
0x00000074007b7306ULL, 0x000ea20000205400ULL, 0x0000009b9800720bULL, 0x002fce0003f7d000ULL,
0x0000008700997306ULL, 0x000fec0000209400ULL, 0x0000000185853812ULL, 0x000fe400078efcffULL,
0x00000087009c7306ULL, 0x000e620000205400ULL, 0x0000007b7a00720bULL, 0x004fe40003f3d000ULL,
0x000000857e85723eULL, 0x000fe200000010ffULL, 0x0000008e384c723cULL, 0x040fe8000004184cULL,
0x0000005c006e7306ULL, 0x0004e8000000d400ULL, 0x000000843848723cULL, 0x000fe80000041848ULL,
0x0000005f007d7306ULL, 0x000fe20000009400ULL, 0x000001005f5c7824ULL, 0x004fe200078e00ffULL,
0x0000009c9900720bULL, 0x002fc80003fdd000ULL, 0x00000018ff807819ULL, 0x000fe4000001145cULL,
0x0000005f007c7306ULL, 0x000e620000005400ULL, 0x000000aa935c723eULL, 0x000fe400000010ffULL,
0x000000016e6e5812ULL, 0x008fe400078efcffULL, 0x0000008c00937245ULL, 0x000fe4000020d400ULL,
0x0000006e916e723eULL, 0x000fe200000010ffULL, 0x0000006d00777306ULL, 0x000fe20000209400ULL,
0x0000005c303c723cULL, 0x000fee000004183cULL, 0x0000006d00767306ULL, 0x000ea20000205400ULL,
0x0000007400317245ULL, 0x000fc4000020d400ULL, 0x0000007c7d00720bULL, 0x002fe40003f7d000ULL,
0x0000000131311812ULL, 0x000fe400078efcffULL, 0x0000006d00307245ULL, 0x000fe2000020d400ULL,
0x0000009200947306ULL, 0x000ff00000209400ULL, 0x00000092008d7306ULL, 0x0003e20000205400ULL,
0x000000767700720bULL, 0x004fce0003fbd000ULL, 0x0000008c00887306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fca000020d400ULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x0000008c00617306ULL, 0x000e700000205400ULL, 0x000000b100607306ULL, 0x000ff00000209400ULL,
0x000000b100817306ULL, 0x0004e20000205400ULL, 0x000000618800720bULL, 0x002fce0003f9d000ULL,
0x0000005e006a7306ULL, 0x000322000000d400ULL, 0x000000b100b17245ULL, 0x004fca000020d400ULL,
0x0000000193934812ULL, 0x000fe400078efcffULL, 0x0000005f00697306ULL, 0x000562000000d400ULL,
0x000100005e5e7824ULL, 0x002fe200078e00ffULL, 0x000000816000720bULL, 0x008fe40003f3d000ULL,
0x000000933093723eULL, 0x000fe400000010ffULL, 0x00000018ff627819ULL, 0x000fe4000001145eULL,
0x00000087005e7245ULL, 0x000fe2000020d400ULL, 0x000100005f5f7824ULL, 0x004fe200078e00ffULL,
0x00000080007c7306ULL, 0x000fe20000209400ULL, 0x000000016a6a2812ULL, 0x010fc400078efcffULL,
0x000000015e5e6812ULL, 0x000fe400078efcffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000008d9400720bULL, 0x000fe20003fdd000ULL, 0x00000080007b7306ULL, 0x0002a20000205400ULL,
0x00000001b1b11812ULL, 0x000fe400078efcffULL, 0x0000000169693812ULL, 0x020fe400078efcffULL,
0x0000006ab16a723eULL, 0x000fc600000010ffULL, 0x0000006700707306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fc6000020d400ULL, 0x0000000192926812ULL, 0x000fc800078efcffULL,
0x0000006700717306ULL, 0x0002e20000205400ULL, 0x0000007b7c00720bULL, 0x004fe40003fbd000ULL,
0x000000923192723eULL, 0x000fca00000010ffULL, 0x00000068006c7306ULL, 0x000fe20000209400ULL,
0x0000006700677245ULL, 0x002fe2000020d400ULL, 0x000000923840723cULL, 0x000fe80000041840ULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x00000068006f7306ULL, 0x0002a20000205400ULL,
0x000000717000720bULL, 0x008fce0003fdd000ULL, 0x0000006200637306ULL, 0x000fe20000209400ULL,
0x0000006800687245ULL, 0x002fca000020d400ULL, 0x0000000167676812ULL, 0x000fe400078efcffULL,
0x0000006200327306ULL, 0x0002e20000205400ULL, 0x0000006f6c00720bULL, 0x004fe40003f9d000ULL,
0x0000006b5e6f723eULL, 0x000fe400000010ffULL, 0x00000069806b723eULL, 0x000fc600000010ffULL,
0x0000005f00337306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fe2000020d400ULL,
0x0000006e3844723cULL, 0x040fe80000041844ULL, 0x0000000168684812ULL, 0x000fe400078efcffULL,
0x0000005f005c7306ULL, 0x000e620000205400ULL, 0x000000326300720bULL, 0x008fe20003f3d000ULL,
0x0000006a3834723cULL, 0x000fe20000041834ULL, 0x0000005f00637245ULL, 0x000fd6000020d400ULL,
0x0000000162621812ULL, 0x000fe400078efcffULL, 0x0000005c3300720bULL, 0x002fe40003f5d000ULL,
0x000000626762723eULL, 0x000fd600000010ffULL, 0x0000000163632812ULL, 0x000fc800078efcffULL,
0x000000636863723eULL, 0x000fce00000010ffULL, 0x000000623838723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000802b337811ULL, 0x000fe200078e40ffULL, 0x01069000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000332c00720cULL, 0x000fda0003f24070ULL, 0x00009eb000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x002e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000327305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff327984ULL, 0x000e640000000800ULL,
0x8000000032ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff307424ULL, 0x000fe200078e00ffULL, 0x0000000328327812ULL, 0x000fe200078ec0ffULL,
0x00000300ff317624ULL, 0x000fc600078e00ffULL, 0x000000033200780cULL, 0x000fe20003f25270ULL,
0xfffffffd30317424ULL, 0x000fe400078e0231ULL, 0x0000580026327a24ULL, 0x000fe400078e02ffULL,
0xffffffffff267424ULL, 0x000fe200078e00ffULL, 0x0000000131317807ULL, 0x000fca0004800000ULL,
0x0000000128287824ULL, 0x000fca00078e0231ULL, 0x0000002a2800720cULL, 0x000fe20003f26070ULL,
0x00000040323d7824ULL, 0x000fe200078e00ffULL, 0x000000a02b337811ULL, 0x000fd600078e40ffULL,
0x0000000128319824ULL, 0x000fc800078e0223ULL, 0x0000600031309625ULL, 0x000fe200078e0030ULL,
0x000000332c327217ULL, 0x000fc80007800000ULL, 0x0000000630269981ULL, 0x000362000c1e1900ULL,
0x000000223d3c7210ULL, 0x040fe20007f3e0ffULL, 0x0000000132327824ULL, 0x000fe200078e0a33ULL,
0x0000001d3d5d7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x00005e003c5c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff5e7224ULL, 0x000fe200010e06ffULL,
0x0000002032327807ULL, 0x000fe40000000000ULL, 0x00005f003c3f7a11ULL, 0x000fe400008f443fULL,
0x0000001e3d337210ULL, 0x000fe40007f3e0ffULL, 0x0000003227327217ULL, 0x000fe40007800000ULL,
0x00000004ff317819ULL, 0x002fe2000001162dULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x00005e00333c7a11ULL, 0x000fe200078240ffULL, 0x00000001323e7824ULL, 0x000fe200078e0a27ULL,
0x0000001c3d3d7210ULL, 0x000fc40007f7e0ffULL, 0x00005f0033337a11ULL, 0x000fe400008f4430ULL,
0x0000001b5c307210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff627224ULL, 0x000fe200018e06ffULL,
0x00005e005d607a11ULL, 0x000fe400078440ffULL, 0x0000001b3c327210ULL, 0x000fe40007fbe0ffULL,
0x0000003e3100720cULL, 0x000fe20003f26070ULL, 0x000000ffff317224ULL, 0x000fe200020e063fULL,
0x00005f005d5e7a11ULL, 0x000fe200010f445eULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x00005e003d5c7a11ULL, 0x000fc400078440ffULL, 0x0000003e2100720cULL, 0x080fe40003f86070ULL,
0x0000003e2000720cULL, 0x080fe40003fc6070ULL, 0x0000003e1f00720cULL, 0x000fe40003fa6070ULL,
0x0000001b603c7210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000301a7faeULL, 0x0003e2000c901c46ULL, 0x00005f003d627a11ULL, 0x000fe400010f4462ULL,
0x0000001b5c3e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fc400018e065eULL,
0x0000000032197faeULL, 0x0003e4000e101c46ULL, 0x000000ffff3f7224ULL, 0x000fe400010e0662ULL,
0x000000003c187faeULL, 0x0003e8000f101c46ULL, 0x000000003e177faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff687f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff317984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106480027327f8cULL, 0x000fe2000c80043fULL, 0x8000000031ff7812ULL, 0x002fc6000784485aULL,
0x01064c00273d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe40007824833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002e4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x008fe40003800000ULL, 0x01064c0027317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007824833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101000016327984ULL, 0x000e680000000800ULL, 0x0103000016337984ULL, 0x0007220000000800ULL,
0x000000253200720bULL, 0x002fe20003f3d000ULL, 0x000132e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x008fc800008e0100ULL, 0x0000ffff303d7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ffcd7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000022e00780cULL, 0x000fe40003f65270ULL,
0x000000253200720bULL, 0x000fe20003f34000ULL, 0x000132b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x000fe400008e0100ULL, 0x0000003225317209ULL, 0x040fe40007810000ULL,
0x0000ffff30307812ULL, 0x000fe400078e3cffULL, 0x00000002ff6c7819ULL, 0x000fe2000001162dULL,
0x80000031253c7221ULL, 0x000fe20000010000ULL, 0x010500311600b388ULL, 0x0003e20000000800ULL,
0x000000303dff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b3c3c7820ULL, 0x000fc80000410000ULL,
0x0000003c00637308ULL, 0x000ee40000000800ULL, 0x0000006324247220ULL, 0x008fe20000410000ULL,
0x000132527f007947ULL, 0x000fea000b800000ULL, 0x00001f6c63627589ULL, 0x0022e400000e0000ULL,
0x0000006254547220ULL, 0x08cfe20000410000ULL, 0x0000006255557220ULL, 0x080fe20000410000ULL,
0x0000006250507220ULL, 0x080fe20000410000ULL, 0x0000006251517220ULL, 0x080fe20000410000ULL,
0x000000624c4c7220ULL, 0x080fe20000410000ULL, 0x000000624d4d7220ULL, 0x080fe20000410000ULL,
0x0000006248487220ULL, 0x080fe20000410000ULL, 0x0000006249497220ULL, 0x080fe20000410000ULL,
0x0000006244447220ULL, 0x080fe20000410000ULL, 0x0000006245457220ULL, 0x080fe20000410000ULL,
0x0000006240407220ULL, 0x080fe20000410000ULL, 0x0000006241417220ULL, 0x080fe20000410000ULL,
0x0000006234347220ULL, 0x080fe20000410000ULL, 0x0000006235357220ULL, 0x080fe20000410000ULL,
0x0000006238387220ULL, 0x080fe20000410000ULL, 0x0000006239397220ULL, 0x000fe20000410000ULL,
0x000131827f007947ULL, 0x000fea000b800000ULL, 0x00001f2f63627589ULL, 0x0004e400000e0000ULL,
0x0000003225257209ULL, 0x000fe20007810000ULL, 0x0000006256567220ULL, 0x08cfe20000410000ULL,
0x00000001ffcd7807ULL, 0x000fe20000800000ULL, 0x0000006257577220ULL, 0x080fe20000410000ULL,
0x0000006252527220ULL, 0x080fe20000410000ULL, 0x8000002532321221ULL, 0x000fe20000010000ULL,
0x0000006253537220ULL, 0x080fe20000410000ULL, 0x000000624e4e7220ULL, 0x080fe20000410000ULL,
0x000000624f4f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b32321820ULL, 0x000fe20000410000ULL,
0x000000624a4a7220ULL, 0x080fe20000410000ULL, 0x000000624b4b7220ULL, 0x080fe20000410000ULL,
0x0000006246467220ULL, 0x080fe20000410000ULL, 0x0000003200151308ULL, 0x000ea20000000800ULL,
0x0000006247477220ULL, 0x080fe20000410000ULL, 0x0000006242427220ULL, 0x080fe20000410000ULL,
0x0000006243437220ULL, 0x080fe20000410000ULL, 0x0000006236367220ULL, 0x080fe20000410000ULL,
0x0000006237377220ULL, 0x080fe20000410000ULL, 0x000000623a3a7220ULL, 0x080fe20000410000ULL,
0x000000623b3b7220ULL, 0x000fe20000410000ULL, 0x0000003315331220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002433247221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fc4000782485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x000724000021f000ULL,
0x3fa0000030307823ULL, 0x008fe200000100ffULL, 0x000000310000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fe4000782485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff30723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x002fc4000001162dULL, 0x0000541030637816ULL, 0x000fe20000000030ULL,
0x00012f227f007947ULL, 0x000fea000b800000ULL, 0x00001f6c63737589ULL, 0x0002e400000e0000ULL,
0x00012f627f007947ULL, 0x000fea000b800000ULL, 0x00001f2f63747589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0066ULL,
0x0000bf60005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000138e000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0065ULL,
0x0000bfc0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0001388000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001430783bULL, 0x000f280000004200ULL,
0x00000000133c783bULL, 0x000ee80000004200ULL, 0x00000000125c783bULL, 0x000ea80000004200ULL,
0x000000001160783bULL, 0x016e620000004200ULL, 0x0000010030ce7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe97819ULL, 0x000fe20000011430ULL, 0x0001000030d57824ULL, 0x000fe200078e00ffULL,
0x0000003000be7306ULL, 0x000fe20000009400ULL, 0x0000010031e77824ULL, 0x040fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x0001000031e47824ULL, 0x000fe200078e00ffULL,
0x00000018ffd57819ULL, 0x000fe200000114d5ULL, 0x0000010033da7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x0000010032de7824ULL, 0x040fe200078e00ffULL,
0x000000ce00ca7306ULL, 0x000fe20000209400ULL, 0x00000018ffd97819ULL, 0x000fe20000011431ULL,
0x0001000032d87824ULL, 0x000fe200078e00ffULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x0001000033d27824ULL, 0x000fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x000100003db97824ULL, 0x008fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fe20000011432ULL,
0x000000ce00cf7306ULL, 0x000ea20000205400ULL, 0x00000018ffaa7819ULL, 0x000fe2000001143cULL,
0x000001003ebc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fc400000114deULL,
0x00000018ff967819ULL, 0x000fe4000001143fULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x0000003000bf7306ULL, 0x000ee20000005400ULL, 0x00000018ffd27819ULL, 0x000fe400000114d2ULL,
0x00000018ff847819ULL, 0x000fe4000001145fULL, 0x00000018ffb17819ULL, 0x000fe40000011433ULL,
0x00000018ff877819ULL, 0x000fe2000001145eULL, 0x000000d500ec7306ULL, 0x000fe20000209400ULL,
0x000000cfca00720bULL, 0x004fc40003fdd000ULL, 0x00000018ffb07819ULL, 0x000fe4000001143dULL,
0x00000018ff9b7819ULL, 0x000fe4000001145cULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000000d500ed7306ULL, 0x000ea20000205400ULL, 0x000000bfbe00720bULL, 0x008fe20003f9d000ULL,
0x000001003fbf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe4000001143eULL,
0x00000018ffbc7819ULL, 0x000fc400000114bcULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x000000e900c77306ULL, 0x000fe20000209400ULL, 0x00000018ff947819ULL, 0x000fe4000001145dULL,
0x00000018ff787819ULL, 0x002fe40000011460ULL, 0x00000018ff727819ULL, 0x000fe40000011461ULL,
0x00000018ff5a7819ULL, 0x000fe20000011462ULL, 0x000000e900ee7306ULL, 0x000e620000205400ULL,
0x000000edec00720bULL, 0x004fe20003fbd000ULL, 0x000001005dec7824ULL, 0x040fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011463ULL, 0x000100005ded7824ULL, 0x000fc800078e00ffULL,
0x0000003100c37306ULL, 0x000ff00000009400ULL, 0x0000003100c47306ULL, 0x000ea20000005400ULL,
0x000000eec700720bULL, 0x002fe20003f5d000ULL, 0x000100003fc77824ULL, 0x000fca00078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000000e700d07306ULL, 0x000ff00000209400ULL,
0x000000e700d17306ULL, 0x000fe20000205400ULL, 0x000000c4c300720bULL, 0x004fce0003f7d000ULL,
0x00000030008f7306ULL, 0x0002b0000000d400ULL, 0x000000d900e37306ULL, 0x000fe20000209400ULL,
0x000001003d307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x000000d900d47306ULL, 0x0003e20000205400ULL, 0x000000018f8f4812ULL, 0x004fce00078efcffULL,
0x000000e400eb7306ULL, 0x000fe20000209400ULL, 0x000000d900d97245ULL, 0x002fce000020d400ULL,
0x000000e400ea7306ULL, 0x000e700000205400ULL, 0x00000031008e7306ULL, 0x0004f0000000d400ULL,
0x0000003200e27306ULL, 0x000fe20000009400ULL, 0x000001003c317824ULL, 0x004fe200078e00ffULL,
0x000000eaeb00720bULL, 0x002fe20003f9d000ULL, 0x000001005eea7824ULL, 0x000fc400078e00ffULL,
0x000100005ceb7824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003200db7306ULL, 0x000fe20000005400ULL, 0x000000018e8e3812ULL, 0x008fe400078efcffULL,
0x00000018ffea7819ULL, 0x000fca00000114eaULL, 0x0000003200897306ULL, 0x0003f0000000d400ULL,
0x0000003c00c17306ULL, 0x000fe20000009400ULL, 0x000100003c327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003c00c27306ULL, 0x000ff00000005400ULL,
0x0000003c00857306ULL, 0x0003f0000000d400ULL, 0x0000003f00a97306ULL, 0x000fe20000009400ULL,
0x000000ce003c7245ULL, 0x002fc8000020d400ULL, 0x000000013c3c6812ULL, 0x000fe400078efcffULL,
0x000000d1d000720bULL, 0x000fe20003fdd000ULL, 0x0000003f00ac7306ULL, 0x000fe20000005400ULL,
0x000001005fd17824ULL, 0x000fe200078e00ffULL, 0x0000008f3c3c723eULL, 0x000fe200000010ffULL,
0x000100005ed07824ULL, 0x000fc600078e00ffULL, 0x00000018ffd17819ULL, 0x000fe400000114d1ULL,
0x0000003f00807306ULL, 0x0003e2000000d400ULL, 0x00000018ffd07819ULL, 0x000fce00000114d0ULL,
0x000000da00e17306ULL, 0x000fe20000209400ULL, 0x00009910cd3f7816ULL, 0x002fc800000000ffULL,
0x000000ff3f00720cULL, 0x000fe40003f25270ULL, 0x000000d5003f7245ULL, 0x000fe2000020d400ULL,
0x000000da00e87306ULL, 0x000e620000205400ULL, 0x000100005fd57824ULL, 0x000fe400078e00ffULL,
0x000000013f3f5812ULL, 0x000fe400078efcffULL, 0x000000d4e300720bULL, 0x000fe40003fbd000ULL,
0x00000018ffd57819ULL, 0x000fe200000114d5ULL, 0x000000de00e57306ULL, 0x000ff00000209400ULL,
0x000000de00e67306ULL, 0x000fe20000205400ULL, 0x000000e8e100720bULL, 0x002fc40003f7d000ULL,
0x00000001d9d95812ULL, 0x000fe400078efcffULL, 0x00000018ffe17819ULL, 0x000fc600000114ecULL,
0x0000003300d67306ULL, 0x000ff00000009400ULL, 0x0000003300d77306ULL, 0x000ff00000005400ULL,
0x000000d800df7306ULL, 0x000ff00000209400ULL, 0x000000d800e07306ULL, 0x000e700000205400ULL,
0x0000005f00997306ULL, 0x000ff00000009400ULL, 0x0000005f009c7306ULL, 0x000fe20000005400ULL,
0x000000e0df00720bULL, 0x002fce0003fbd000ULL, 0x0000005f00777306ULL, 0x0003f0000000d400ULL,
0x000000d200dc7306ULL, 0x000fe20000209400ULL, 0x000000e7005f7245ULL, 0x002fc8000020d400ULL,
0x000000015f5f6812ULL, 0x000fe400078efcffULL, 0x000000e6e500720bULL, 0x000fe20003fdd000ULL,
0x000000d200dd7306ULL, 0x0002b00000205400ULL, 0x0000005e009e7306ULL, 0x000fe20000009400ULL,
0x000000d200d27245ULL, 0x002fce000020d400ULL, 0x0000005e00917306ULL, 0x000ff00000005400ULL,
0x0000005e00757306ULL, 0x0003f0000000d400ULL, 0x0000003d00b57306ULL, 0x000fe20000009400ULL,
0x000000e4005e7245ULL, 0x002fc8000020d400ULL, 0x000000015e5e4812ULL, 0x000fe400078efcffULL,
0x000000d7d600720bULL, 0x000fe20003f9d000ULL, 0x0000003d00b67306ULL, 0x000fe20000005400ULL,
0x000000da00d77245ULL, 0x000fe4000020d400ULL, 0x000000de00d67245ULL, 0x000fe4000020d400ULL,
0x00000001d7d73812ULL, 0x000fe400078efcffULL, 0x000000dddc00720bULL, 0x004fe20003f7d000ULL,
0x0000003d00827306ULL, 0x0003e2000000d400ULL, 0x00000001d6d66812ULL, 0x000fc400078efcffULL,
0x000000c2c100720bULL, 0x000fe20003fdd000ULL, 0x0001000060c27824ULL, 0x000fe200078e00ffULL,
0x000000d800c17245ULL, 0x000fc6000020d400ULL, 0x000000b100b37306ULL, 0x000fe20000209400ULL,
0x000001005c3d7824ULL, 0x002fe200078e00ffULL, 0x00000001c1c15812ULL, 0x000fe400078efcffULL,
0x00000001d2d23812ULL, 0x000fe400078efcffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000000b100b47306ULL, 0x000e620000205400ULL, 0x0000000185856812ULL, 0x000fe400078efcffULL,
0x00000018ffc27819ULL, 0x000fca00000114c2ULL, 0x0000005c00a87306ULL, 0x000ff00000009400ULL,
0x0000005c00ad7306ULL, 0x000fe20000005400ULL, 0x000000b4b300720bULL, 0x002fe20003fbd000ULL,
0x0001000061b37824ULL, 0x000fe200078e00ffULL, 0x0000003100b47245ULL, 0x000fc8000020d400ULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000005c007d7306ULL, 0x0003f0000000d400ULL,
0x000000b700c57306ULL, 0x000fe20000209400ULL, 0x000000e9005c7245ULL, 0x002fc8000020d400ULL,
0x000000015c5c2812ULL, 0x000fe400078efcffULL, 0x000000dbe200720bULL, 0x000fe20003f5d000ULL,
0x000000b700c67306ULL, 0x000e620000205400ULL, 0x0000003f5c5c723eULL, 0x000fce00000010ffULL,
0x0000003300887306ULL, 0x000ea8000000d400ULL, 0x0000000189892812ULL, 0x000fc800078efcffULL,
0x0000003000cc7306ULL, 0x000fe20000209400ULL, 0x000000c6c500720bULL, 0x002fe40003f5d000ULL,
0x00000089d6d6723eULL, 0x000fca00000010ffULL, 0x0000003000d37306ULL, 0x000e620000205400ULL,
0x0000000188884812ULL, 0x004fe400078efcffULL, 0x000000b6b500720bULL, 0x000fe40003f9d000ULL,
0x000000b700b67245ULL, 0x000fe4000020d400ULL, 0x000000b100b77245ULL, 0x000fe2000020d400ULL,
0x000000aa00a67306ULL, 0x000fe20000209400ULL, 0x00000001b6b62812ULL, 0x000fe400078efcffULL,
0x00000001b7b75812ULL, 0x000fc400078efcffULL, 0x00000018ffb57819ULL, 0x000fe400000114edULL,
0x00000088d7d7723eULL, 0x000fe200000010ffULL, 0x000000aa00a57306ULL, 0x000ea20000205400ULL,
0x000000d3cc00720bULL, 0x002fe20003f7d000ULL, 0x0000010060cc7824ULL, 0x000fe200078e00ffULL,
0x0000000182824812ULL, 0x000fe400078efcffULL, 0x000000c1b6b6723eULL, 0x000fe400000010ffULL,
0x000000d2b7b7723eULL, 0x000fe200000010ffULL, 0x0000003100c87306ULL, 0x000ff00000209400ULL,
0x0000003100cb7306ULL, 0x000e620000205400ULL, 0x000000a5a600720bULL, 0x004fc40003fbd000ULL,
0x0000003000a57245ULL, 0x000fe4000020d400ULL, 0x0000003200a67245ULL, 0x000fe4000020d400ULL,
0x00000001a5a53812ULL, 0x000fe200078efcffULL, 0x000000b900ba7306ULL, 0x000fe20000209400ULL,
0x0000b00010307811ULL, 0x000fe400078e20ffULL, 0x00000082a5a5723eULL, 0x000fca00000010ffULL,
0x000000b900bb7306ULL, 0x0004e20000205400ULL, 0x000000cbc800720bULL, 0x002fe20003f5d000ULL,
0x0000010061c87824ULL, 0x000fca00078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x0000003e00a47306ULL, 0x000fe20000009400ULL, 0x000000b900b97245ULL, 0x004fca000020d400ULL,
0x00000001b4b42812ULL, 0x000fe400078efcffULL, 0x0000003e00a77306ULL, 0x000e620000005400ULL,
0x000000bbba00720bULL, 0x008fce0003f7d000ULL, 0x0000003200337306ULL, 0x000fec0000209400ULL,
0x00000001b9b93812ULL, 0x000fe400078efcffULL, 0x0000003200b87306ULL, 0x000ea20000205400ULL,
0x000000a7a400720bULL, 0x002fe40003fdd000ULL, 0x000000aca900720bULL, 0x000fca0003f7d000ULL,
0x000000b000b27306ULL, 0x000ff00000209400ULL, 0x000000b000a37306ULL, 0x0002e20000205400ULL,
0x000000b83300720bULL, 0x004fe40003f5d000ULL, 0x0000000180803812ULL, 0x000fe200078efcffULL,
0x000000003030783bULL, 0x000ea80000000200ULL, 0x0000003e00817306ULL, 0x0008e2000000d400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x00000001a6a62812ULL, 0x000fe400078efcffULL,
0x0000009f00ae7306ULL, 0x000fe20000209400ULL, 0x000100003e3e7824ULL, 0x010fe200078e00ffULL,
0x000000a3b200720bULL, 0x008fe40003f9d000ULL, 0x000000aa00a37245ULL, 0x000fe4000020d400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000009f00af7306ULL, 0x0002e20000205400ULL,
0x00000001a3a35812ULL, 0x000fc400078efcffULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x000000a6a3a6723eULL, 0x000fe400000010ffULL, 0x00000001b0b04812ULL, 0x000fe200078efcffULL,
0x000000bf00c07306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fce000020d400ULL,
0x000000bf00c37306ULL, 0x0003220000205400ULL, 0x000000afae00720bULL, 0x008fe20003fdd000ULL,
0x0000007330309231ULL, 0x084fe400003400ffULL, 0x0000007332329231ULL, 0x000fc800003400ffULL,
0x000000bc00bd7306ULL, 0x000fe20000209400ULL, 0x000000bf00bf7245ULL, 0x002fe2000020d400ULL,
0x0000007431319231ULL, 0x080fe400003400ffULL, 0x0000007433339231ULL, 0x000fe400003400ffULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x000000bc00be7306ULL, 0x0002a20000205400ULL,
0x000000c3c000720bULL, 0x010fe40003fbd000ULL, 0x000000b300c37245ULL, 0x000fe2000020d400ULL,
0x000000d6304c723cULL, 0x000fe8000004184cULL, 0x0000009600a27306ULL, 0x000fe20000209400ULL,
0x000000bc00bc7245ULL, 0x002fc6000020d400ULL, 0x000000b63048723cULL, 0x000fe40000041848ULL,
0x00000001bfbf5812ULL, 0x000fe400078efcffULL, 0x0000009600ab7306ULL, 0x0002e20000205400ULL,
0x000000bebd00720bULL, 0x004fe40003f5d000ULL, 0x00000080bfbd723eULL, 0x000fca00000010ffULL,
0x0000003e00c47306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fca000020d400ULL,
0x00000001bcbc2812ULL, 0x000fe400078efcffULL, 0x0000003e00c97306ULL, 0x000e620000205400ULL,
0x000000aba200720bULL, 0x008fe40003f7d000ULL, 0x000000ada800720bULL, 0x000fe40003f5d000ULL,
0x0000003e00a87245ULL, 0x000fe4000020d400ULL, 0x00000081bcbc723eULL, 0x000fe200000010ffULL,
0x0000009b00a17306ULL, 0x000fec0000209400ULL, 0x0000000196963812ULL, 0x000fe200078efcffULL,
0x000000bc3034723cULL, 0x000fe20000041834ULL, 0x0000009b00a07306ULL, 0x0004e20000205400ULL,
0x000000c9c400720bULL, 0x002fc40003f9d000ULL, 0x000000017d7d2812ULL, 0x000fca00078efcffULL,
0x000000c700ca7306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x004fca000020d400ULL,
0x00000001a8a84812ULL, 0x000fe400078efcffULL, 0x000000c700cf7306ULL, 0x0002a20000205400ULL,
0x000000a0a100720bULL, 0x008fe40003fdd000ULL, 0x0000003d00a07245ULL, 0x000fe4000020d400ULL,
0x00000018ffa17819ULL, 0x000fe400000114ccULL, 0x000000a89fa8723eULL, 0x000fe200000010ffULL,
0x000000e100da7306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x002fca000020d400ULL,
0x000000019b9b6812ULL, 0x000fe400078efcffULL, 0x000000e100c57306ULL, 0x0002e20000205400ULL,
0x000000cfca00720bULL, 0x004fce0003fbd000ULL, 0x0000003d00cd7306ULL, 0x000fe20000209400ULL,
0x000000e100e17245ULL, 0x002fca000020d400ULL, 0x00000001c7c75812ULL, 0x000fe400078efcffULL,
0x0000003d00ce7306ULL, 0x0002a20000205400ULL, 0x000000c5da00720bULL, 0x008fce0003f7d000ULL,
0x0000005d009d7306ULL, 0x000fe20000009400ULL, 0x0000008e5f3d723eULL, 0x002fe400000010ffULL,
0x000000d1008e7245ULL, 0x000fc6000020d400ULL, 0x00000001e1e13812ULL, 0x000fe400078efcffULL,
0x0000005d00927306ULL, 0x000e620000005400ULL, 0x000000cecd00720bULL, 0x004fe20003f9d000ULL,
0x0000003c3054723cULL, 0x000fe20000041854ULL, 0x000000919e00720bULL, 0x000fca0003f7d000ULL,
0x0000005d007c7306ULL, 0x0004e2000000d400ULL, 0x0000b0000f3c7811ULL, 0x000fca00078e20ffULL,
0x00000001a0a04812ULL, 0x000fe200078efcffULL, 0x000000003c3c783bULL, 0x000f220000000200ULL,
0x000000ea00b17306ULL, 0x000fe20000209400ULL, 0x00000018ff5d7819ULL, 0x004fe400000114ebULL,
0x000000929d00720bULL, 0x002fe40003f9d000ULL, 0x0000005d00927245ULL, 0x000fe4000020d400ULL,
0x0000000175753812ULL, 0x000fe200078efcffULL, 0x0000005d00d47306ULL, 0x000fe20000209400ULL,
0x0000007da0a0723eULL, 0x000fce00000010ffULL, 0x0000005d00db7306ULL, 0x0002a20000205400ULL,
0x000000017c7c4812ULL, 0x008fe400078efcffULL, 0x0000009c9900720bULL, 0x000fca0003f9d000ULL,
0x000000ea00b87306ULL, 0x0007220000205400ULL, 0x0000005ed95d723eULL, 0x002fce00000010ffULL,
0x0000009400957306ULL, 0x000fe20000209400ULL, 0x000000dbd400720bULL, 0x004fe20003fbd000ULL,
0x0000005c3050723cULL, 0x000fe20000041850ULL, 0x000000ea00ea7245ULL, 0x008fe4000020d400ULL,
0x0000000177774812ULL, 0x000fe200078efcffULL, 0x000000733c3c9231ULL, 0x090fe400003400ffULL,
0x0000009400987306ULL, 0x0002a20000205400ULL, 0x000000b8b100720bULL, 0x000fe20003fdd000ULL,
0x000000733e3e9231ULL, 0x000fe200003400ffULL, 0x000000a1005d7245ULL, 0x000fe2000020d400ULL,
0x000000743d3d9231ULL, 0x000fc400003400ffULL, 0x0000000192925812ULL, 0x000fe200078efcffULL,
0x000000743f3f9231ULL, 0x000fe200003400ffULL, 0x000000b500c67306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fe4000020d400ULL, 0x000000929b92723eULL, 0x000fc600000010ffULL,
0x00000001eaea6812ULL, 0x000fe400078efcffULL, 0x000000b500cb7306ULL, 0x0002e20000205400ULL,
0x000000989500720bULL, 0x004fce0003f5d000ULL, 0x000000d100b27306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x002fca000020d400ULL, 0x0000000194942812ULL, 0x000fe400078efcffULL,
0x000000d100bb7306ULL, 0x0002a20000205400ULL, 0x000000cbc600720bULL, 0x008fce0003fbd000ULL,
0x00000087008c7306ULL, 0x000fe20000209400ULL, 0x000000d500d17245ULL, 0x002fca000020d400ULL,
0x00000001b5b55812ULL, 0x000fe400078efcffULL, 0x00000087008d7306ULL, 0x0002e20000205400ULL,
0x000000bbb200720bULL, 0x004fce0003fdd000ULL, 0x0000006000907306ULL, 0x000fe20000009400ULL,
0x0000008700877245ULL, 0x002fca000020d400ULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x0000006000937306ULL, 0x000e620000005400ULL, 0x0000008d8c00720bULL, 0x008fe40003f7d000ULL,
0x000000778e77723eULL, 0x000fca00000010ffULL, 0x000000d000a47306ULL, 0x000fec0000209400ULL,
0x0000000187873812ULL, 0x000fe400078efcffULL, 0x000000d000a77306ULL, 0x0004e20000205400ULL,
0x000000939000720bULL, 0x002fe40003fbd000ULL, 0x000000b59493723eULL, 0x000fca00000010ffULL,
0x000000a1009d7306ULL, 0x000fe20000209400ULL, 0x000000d000d07245ULL, 0x004fe2000020d400ULL,
0x000000923c50723cULL, 0x000fec0000041850ULL, 0x000000a100987306ULL, 0x0002a20000205400ULL,
0x000000a7a400720bULL, 0x008fe40003fdd000ULL, 0x00000085b4a4723eULL, 0x000fc400000010ffULL,
0x000000b9b0a7723eULL, 0x000fc600000010ffULL, 0x0000006100977306ULL, 0x000fe20000009400ULL,
0x0000007ce1a1723eULL, 0x002fe200000010ffULL, 0x000000a43044723cULL, 0x040fe80000041844ULL,
0x00000001d0d06812ULL, 0x000fe400078efcffULL, 0x00000061009a7306ULL, 0x000e620000005400ULL,
0x000000989d00720bULL, 0x004fe20003f7d000ULL, 0x000000a63040723cULL, 0x000fe20000041840ULL,
0x000000d087d0723eULL, 0x000fca00000010ffULL, 0x00000084008b7306ULL, 0x000fe40000209400ULL,
0x000000a03c54723cULL, 0x000fe80000041854ULL, 0x000000015d5d3812ULL, 0x000fe400078efcffULL,
0x00000084008a7306ULL, 0x0004e20000205400ULL, 0x0000009a9700720bULL, 0x002fce0003f5d000ULL,
0x000000d500a27306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x004fce000020d400ULL,
0x000000d500a97306ULL, 0x000e620000205400ULL, 0x0000008a8b00720bULL, 0x008fce0003f9d000ULL,
0x00000060006e7306ULL, 0x0004ec000000d400ULL, 0x0000000184844812ULL, 0x000fe400078efcffULL,
0x000000c800917306ULL, 0x000fe20000209400ULL, 0x000000a9a200720bULL, 0x002fe20003fdd000ULL,
0x0000010063607824ULL, 0x004fe200078e00ffULL, 0x000000c796a9723eULL, 0x000fc800000010ffULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x000000c800907306ULL, 0x0002a20000205400ULL,
0x000000016e6e5812ULL, 0x008fe200078efcffULL, 0x000000a83030723cULL, 0x000fe60000041838ULL,
0x0000006e5d6e723eULL, 0x000fe400000010ffULL, 0x00000001d1d16812ULL, 0x000fe200078efcffULL,
0x000000c2005f7306ULL, 0x000fe20000209400ULL, 0x000000c800c87245ULL, 0x002fc4000020d400ULL,
0x0000007800397245ULL, 0x000fe4000020d400ULL, 0x000000d184d1723eULL, 0x000fc600000010ffULL,
0x000000c2005e7306ULL, 0x0002e20000205400ULL, 0x000000909100720bULL, 0x004fc60003f7d000ULL,
0x000000d03c48723cULL, 0x000fe80000041848ULL, 0x00000061006f7306ULL, 0x000522000000d400ULL,
0x000000c200c27245ULL, 0x002fca000020d400ULL, 0x00000001c8c83812ULL, 0x000fe400078efcffULL,
0x0000006200867306ULL, 0x000fe20000009400ULL, 0x0000005e5f00720bULL, 0x008fe20003fbd000ULL,
0x0000010062617824ULL, 0x004fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000006200837306ULL, 0x000e620000005400ULL, 0x000000016f6f2812ULL, 0x010fc800078efcffULL,
0x0000006fc86f723eULL, 0x000fe400000010ffULL, 0x00000001c2c25812ULL, 0x000fe200078efcffULL,
0x00000063007f7306ULL, 0x000fe80000009400ULL, 0x0000006e3c44723cULL, 0x000fe80000041844ULL,
0x00000063007e7306ULL, 0x000ea20000005400ULL, 0x000000838600720bULL, 0x002fce0003fdd000ULL,
0x000000b3005c7306ULL, 0x000ff00000209400ULL, 0x000000b300897306ULL, 0x000e620000205400ULL,
0x0000007e7f00720bULL, 0x004fce0003f9d000ULL, 0x00000078007b7306ULL, 0x000ff00000209400ULL,
0x00000078007a7306ULL, 0x000ea20000205400ULL, 0x000000895c00720bULL, 0x002fce0003f5d000ULL,
0x0000007200767306ULL, 0x000fec0000209400ULL, 0x00000001c3c32812ULL, 0x000fe400078efcffULL,
0x0000007200797306ULL, 0x0002e20000205400ULL, 0x0000007a7b00720bULL, 0x004fce0003f7d000ULL,
0x0000005a00717306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x002fca000020d400ULL,
0x0000000139393812ULL, 0x000fe400078efcffULL, 0x0000005a00707306ULL, 0x000e620000205400ULL,
0x000000797600720bULL, 0x008fe40003fbd000ULL, 0x000000c239c2723eULL, 0x000fe400000010ffULL,
0x0000005a00397245ULL, 0x000fe4000020d400ULL, 0x00000075ea76723eULL, 0x000fe200000010ffULL,
0x0000006100827306ULL, 0x000fec0000209400ULL, 0x0000000172725812ULL, 0x000fe200078efcffULL,
0x000000763c4c723cULL, 0x000fe2000004184cULL, 0x0000006100837306ULL, 0x0004e20000205400ULL,
0x000000707100720bULL, 0x002fc40003f5d000ULL, 0x000000c372c3723eULL, 0x000fca00000010ffULL,
0x00000060007e7306ULL, 0x000fe20000209400ULL, 0x0000006100617245ULL, 0x004fe2000020d400ULL,
0x000000c23c40723cULL, 0x000fe80000041840ULL, 0x0000000139392812ULL, 0x000fe400078efcffULL,
0x00000060005f7306ULL, 0x0002a20000205400ULL, 0x000000838200720bULL, 0x008fce0003f7d000ULL,
0x00000062006a7306ULL, 0x000722000000d400ULL, 0x0000006000607245ULL, 0x002fca000020d400ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x00000063006b7306ULL, 0x000322000000d400ULL,
0x0001000062627824ULL, 0x008fe200078e00ffULL, 0x0000005f7e00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000067006d7306ULL, 0x000fe20000209400ULL,
0x0001000063637824ULL, 0x002fe200078e00ffULL, 0x000000016a6a6812ULL, 0x010fc800078efcffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x00000067006c7306ULL, 0x000e620000205400ULL,
0x0000000160605812ULL, 0x000fe400078efcffULL, 0x000000016b6b4812ULL, 0x000fe400078efcffULL,
0x0000006a616a723eULL, 0x000fe400000010ffULL, 0x0000006b606b723eULL, 0x000fe200000010ffULL,
0x0000006200387306ULL, 0x000fec0000209400ULL, 0x0000006a3c34723cULL, 0x000fe40000041834ULL,
0x00000062003b7306ULL, 0x0004e20000205400ULL, 0x0000006c6d00720bULL, 0x002fce0003f7d000ULL,
0x00000063003a7306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x004fce000020d400ULL,
0x0000006300717306ULL, 0x0002a20000205400ULL, 0x0000003b3800720bULL, 0x008fe40003fdd000ULL,
0x0000006700387245ULL, 0x000fc8000020d400ULL, 0x0000000138383812ULL, 0x000fe400078efcffULL,
0x0000006300637245ULL, 0x002fca000020d400ULL, 0x0000000162626812ULL, 0x000fe400078efcffULL,
0x000000713a00720bULL, 0x004fe40003fbd000ULL, 0x000000623962723eULL, 0x000fd600000010ffULL,
0x0000000163635812ULL, 0x000fc800078efcffULL, 0x000000633863723eULL, 0x000fce00000010ffULL,
0x000000623c3c723cULL, 0x000fe20000041830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff327f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844833ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580026307a24ULL, 0x020fe200078e02ffULL,
0x000000c02b317811ULL, 0x000fc600078e40ffULL, 0x0000004030327824ULL, 0x000fe200078e00ffULL,
0x000000312c307217ULL, 0x000fc80007800000ULL, 0x0000000e32337210ULL, 0x000fe20007f5e0ffULL,
0x0000000130307824ULL, 0x000fe200078e0a31ULL, 0x0000000d32397210ULL, 0x000fe40007f7e0ffULL,
0x00000004ff317819ULL, 0x000fe2000001162dULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x00005e00335a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005e00395c7a11ULL, 0x000fe400078640ffULL, 0x00005f0033337a11ULL, 0x000fc400010f4438ULL,
0x0000000c32387210ULL, 0x040fe40007f5e0ffULL, 0x00005f0039397a11ULL, 0x000fe400018f443aULL,
0x0000000b32327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200010e06ffULL,
0x0000002030307807ULL, 0x000fe40000000000ULL, 0x00005e00385e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff5d7224ULL, 0x000fe200018e06ffULL, 0x0000003027307217ULL, 0x000fc40007800000ULL,
0x00005e0032607a11ULL, 0x000fe400078640ffULL, 0x00005f00383b7a11ULL, 0x000fe200010f443bULL,
0x00000001303a7824ULL, 0x000fe200078e0a27ULL, 0x00005f00325d7a11ULL, 0x000fe400018f445dULL,
0x0000001b5a307210ULL, 0x080fe40007f7e0ffULL, 0x0000001b5c327210ULL, 0x080fe40007f9e0ffULL,
0x0000001b5e387210ULL, 0x000fc40007fbe0ffULL, 0x0000003a3100720cULL, 0x080fe20003f46070ULL,
0x000000ffff317224ULL, 0x000fe200018e0633ULL, 0x0000003a2100720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200020e0639ULL, 0x0000003a2000720cULL, 0x080fe20003f86070ULL,
0x000000ffff397224ULL, 0x000fe200028e063bULL, 0x0000003a1f00720cULL, 0x000fe40003fa6070ULL,
0x0000001b603a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e065dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000300a7faeULL, 0x0003e8000d101c46ULL,
0x0000000032097faeULL, 0x0003e8000d901c46ULL, 0x0000000038087faeULL, 0x0003e8000e101c46ULL,
0x000000003a077faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5a7224ULL, 0x000fe200078e0031ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff30723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x000fe4000001162dULL, 0x0000541030637816ULL, 0x000fe20000000030ULL,
0x00010b927f007947ULL, 0x000fea000b800000ULL, 0x00001f6c63877589ULL, 0x0002a400000e0000ULL,
0x00010bd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f63867589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0066ULL,
0x0000e3c0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0001148000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0065ULL,
0x0000e420005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0001142000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000630783bULL, 0x000f680000004200ULL,
0x000000000460783bULL, 0x00efe80000004200ULL, 0x000000000538783bULL, 0x000e680000004200ULL,
0x00000000035c783bULL, 0x000ea20000004200ULL, 0x0000010030e77824ULL, 0x060fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe20000011430ULL, 0x0001000030c17824ULL, 0x000fe200078e00ffULL,
0x0000003000aa7306ULL, 0x000fe20000009400ULL, 0x0000010031e67824ULL, 0x040fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x0001000031e27824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fe200000114c1ULL, 0x0000010032dd7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe67819ULL, 0x000fe200000114e6ULL, 0x0000010033c87824ULL, 0x040fe200078e00ffULL,
0x000000e700ad7306ULL, 0x000fe20000209400ULL, 0x00000018ffc97819ULL, 0x000fe20000011431ULL,
0x0001000032da7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe27819ULL, 0x000fe200000114e2ULL,
0x0001000033d47824ULL, 0x000fe200078e00ffULL, 0x00000018ffdd7819ULL, 0x000fe200000114ddULL,
0x000001003aa77824ULL, 0x002fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x000000e700b47306ULL, 0x000e620000205400ULL, 0x00000018ffa47819ULL, 0x000fe20000011460ULL,
0x0000010038cd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x000001003ba97824ULL, 0x040fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe2000001143aULL,
0x000100003bb37824ULL, 0x000fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe20000011432ULL,
0x0000003000ab7306ULL, 0x000ee20000005400ULL, 0x00000018ff7e7819ULL, 0x000fc40000011463ULL,
0x00000018ffd47819ULL, 0x000fe400000114d4ULL, 0x00000018ffbe7819ULL, 0x000fe40000011433ULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x000000c100e87306ULL, 0x000fe20000209400ULL,
0x000000b4ad00720bULL, 0x002fe40003f9d000ULL, 0x00000018ffb97819ULL, 0x000fe40000011438ULL,
0x00000018ff9f7819ULL, 0x000fc40000011439ULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x000000c100eb7306ULL, 0x000e620000205400ULL, 0x000000abaa00720bULL, 0x008fe20003fdd000ULL,
0x000100003aaa7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe400000114a9ULL,
0x00000018ff9e7819ULL, 0x000fe4000001143bULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x000000c300e97306ULL, 0x000fe20000209400ULL, 0x00000018ffb37819ULL, 0x000fc400000114b3ULL,
0x00000018ff847819ULL, 0x000fe40000011462ULL, 0x00000018ff8e7819ULL, 0x000fe40000011461ULL,
0x00000018ff6d7819ULL, 0x004fe2000001145dULL, 0x000000c300b67306ULL, 0x000ea20000205400ULL,
0x000000ebe800720bULL, 0x002fe20003f5d000ULL, 0x0000010061e87824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe4000001145cULL, 0x00000018ff677819ULL, 0x000fc4000001145eULL,
0x00000018ff687819ULL, 0x000fe2000001145fULL, 0x0000003100af7306ULL, 0x000ff00000009400ULL,
0x0000003100ae7306ULL, 0x000e620000005400ULL, 0x000000b6e900720bULL, 0x004fe20003fbd000ULL,
0x0001000061e97824ULL, 0x000fe200078e00ffULL, 0x000000e700b67245ULL, 0x000fe2000020d400ULL,
0x0001000060e77824ULL, 0x000fc600078e00ffULL, 0x00000001b6b64812ULL, 0x000fe200078efcffULL,
0x000000e600ea7306ULL, 0x000ff00000209400ULL, 0x000000e600ed7306ULL, 0x000ea20000205400ULL,
0x000000aeaf00720bULL, 0x002fe20003f7d000ULL, 0x0000010060af7824ULL, 0x000fca00078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x00000030008f7306ULL, 0x0002f0000000d400ULL,
0x000000c900c77306ULL, 0x000fe20000209400ULL, 0x000000edea00720bULL, 0x004fe20003f9d000ULL,
0x0000010039307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000c900c67306ULL, 0x0003e20000205400ULL, 0x000000018f8f6812ULL, 0x008fc800078efcffULL,
0x0000008fb6b6723eULL, 0x000fe400000010ffULL, 0x0000008e008f7245ULL, 0x000fe2000020d400ULL,
0x000000e200ef7306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fce000020d400ULL,
0x000000e200ec7306ULL, 0x000e700000205400ULL, 0x0000003200c47306ULL, 0x000ff00000009400ULL,
0x0000003200e17306ULL, 0x000fe20000005400ULL, 0x000000ecef00720bULL, 0x002fce0003fdd000ULL,
0x00000031008d7306ULL, 0x0002b0000000d400ULL, 0x000000dd00e37306ULL, 0x000fe20000209400ULL,
0x0001000038317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x000000dd00e47306ULL, 0x000fe20000205400ULL, 0x000000018d8d3812ULL, 0x004fce00078efcffULL,
0x000000c800d27306ULL, 0x000ff00000209400ULL, 0x000000c800e57306ULL, 0x0002b00000205400ULL,
0x0000006000937306ULL, 0x000fe20000009400ULL, 0x000000c800c87245ULL, 0x002fce000020d400ULL,
0x0000006000a07306ULL, 0x000fe20000005400ULL, 0x000000e5d200720bULL, 0x004fce0003f7d000ULL,
0x0000006000787306ULL, 0x0003ec000000d400ULL, 0x00000001c8c83812ULL, 0x000fe400078efcffULL,
0x0000003300cf7306ULL, 0x000fe20000009400ULL, 0x000000c100607245ULL, 0x002fe2000020d400ULL,
0x0001000063c17824ULL, 0x000fc600078e00ffULL, 0x0000000160602812ULL, 0x000fe400078efcffULL,
0x000000c6c700720bULL, 0x000fe20003f5d000ULL, 0x0000003300dc7306ULL, 0x000fe20000005400ULL,
0x000000e600c67245ULL, 0x000fe4000020d400ULL, 0x00000018ffc17819ULL, 0x000fe400000114c1ULL,
0x00000001c6c64812ULL, 0x000fe400078efcffULL, 0x000000e4e300720bULL, 0x000fe20003f9d000ULL,
0x000000da00df7306ULL, 0x000fe80000209400ULL, 0x00000001c9c92812ULL, 0x000fc800078efcffULL,
0x000000da00e07306ULL, 0x000e700000205400ULL, 0x0000003a00b17306ULL, 0x000ff00000009400ULL,
0x0000003a00ba7306ULL, 0x000fe20000005400ULL, 0x000000e0df00720bULL, 0x002fce0003f5d000ULL,
0x0000003a007f7306ULL, 0x0003f0000000d400ULL, 0x0000006300a67306ULL, 0x000fe20000009400ULL,
0x00000100633a7824ULL, 0x002fce00078e00ffULL, 0x0000006300957306ULL, 0x000ff00000005400ULL,
0x0000006300727306ULL, 0x0003f0000000d400ULL, 0x00000032008a7306ULL, 0x000ea2000000d400ULL,
0x000000c300637245ULL, 0x002fc4000020d400ULL, 0x00000018ffc37819ULL, 0x000fe400000114e8ULL,
0x0000000163635812ULL, 0x000fe400078efcffULL, 0x000000e1c400720bULL, 0x000fe20003fbd000ULL,
0x000000c000d67306ULL, 0x000fe20000209400ULL, 0x000000e200c47245ULL, 0x000fe4000020d400ULL,
0x000000606360723eULL, 0x000fe400000010ffULL, 0x00000001c4c46812ULL, 0x000fc400078efcffULL,
0x000000dccf00720bULL, 0x000fe20003fdd000ULL, 0x000000c000d77306ULL, 0x000e620000205400ULL,
0x000000dd00cf7245ULL, 0x000fe4000020d400ULL, 0x00000018ffdc7819ULL, 0x000fe400000114e7ULL,
0x000000018a8a5812ULL, 0x004fe400078efcffULL, 0x00000001cfcf4812ULL, 0x000fe200078efcffULL,
0x0000003800d07306ULL, 0x000fe60000009400ULL, 0x0000008acf8a723eULL, 0x000fca00000010ffULL,
0x0000003800d57306ULL, 0x000ea20000005400ULL, 0x000000d7d600720bULL, 0x002fce0003fbd000ULL,
0x000000d400db7306ULL, 0x000ff00000209400ULL, 0x000000d400de7306ULL, 0x0002e20000205400ULL,
0x000000d5d000720bULL, 0x004fe40003f9d000ULL, 0x000000da00d07245ULL, 0x000fc8000020d400ULL,
0x00000001d0d02812ULL, 0x000fe200078efcffULL, 0x0000003300857306ULL, 0x000562000000d400ULL,
0x000000d400d47245ULL, 0x002fce000020d400ULL, 0x000000be00c27306ULL, 0x000fe20000209400ULL,
0x000000dedb00720bULL, 0x008fe20003f7d000ULL, 0x0001000039337824ULL, 0x004fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x000000be00bf7306ULL, 0x000e620000205400ULL,
0x0000000185856812ULL, 0x020fca00078efcffULL, 0x00000001d4d43812ULL, 0x000fe400078efcffULL,
0x000000cd00d87306ULL, 0x000ff00000209400ULL, 0x000000cd00d97306ULL, 0x000ea20000205400ULL,
0x000000bfc200720bULL, 0x002fc40003fdd000ULL, 0x000000c000bf7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc27819ULL, 0x000fe400000114e9ULL, 0x00000001bfbf5812ULL, 0x000fe200078efcffULL,
0x0000003000ce7306ULL, 0x000fe60000209400ULL, 0x000000d0bfd0723eULL, 0x000fca00000010ffULL,
0x0000003000d37306ULL, 0x000e620000205400ULL, 0x000000d9d800720bULL, 0x004fce0003f5d000ULL,
0x0000003900bd7306ULL, 0x000ff00000009400ULL, 0x0000003900b27306ULL, 0x000ea20000005400ULL,
0x000000d3ce00720bULL, 0x002fe20003fbd000ULL, 0x000100005dce7824ULL, 0x000fe200078e00ffULL,
0x000000be00d37245ULL, 0x000fc8000020d400ULL, 0x00000001d3d36812ULL, 0x000fe200078efcffULL,
0x000000b900bb7306ULL, 0x000ff00000209400ULL, 0x000000b900ac7306ULL, 0x0002e20000205400ULL,
0x000000b2bd00720bULL, 0x004fc40003f7d000ULL, 0x000000cd00b27245ULL, 0x000fc8000020d400ULL,
0x00000001b2b22812ULL, 0x000fe200078efcffULL, 0x0000003100ca7306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fce000020d400ULL, 0x0000003100d17306ULL, 0x000e620000205400ULL,
0x000000acbb00720bULL, 0x008fe40003f5d000ULL, 0x0000003000bb7245ULL, 0x000fe4000020d400ULL,
0x0000003100ac7245ULL, 0x000fe4000020d400ULL, 0x00000001bbbb5812ULL, 0x000fe200078efcffULL,
0x0000003300cb7306ULL, 0x000fe20000209400ULL, 0x0000b00002307811ULL, 0x000fca00078e20ffULL,
0x00000001b9b92812ULL, 0x000fe400078efcffULL, 0x0000003300cc7306ULL, 0x000ea20000205400ULL,
0x000000d1ca00720bULL, 0x002fe20003fdd000ULL, 0x000100005cca7824ULL, 0x000fe200078e00ffULL,
0x000000d4d3d1723eULL, 0x000fca00000010ffULL, 0x0000003800837306ULL, 0x000e6c000000d400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x0000003900827306ULL, 0x000ee2000000d400ULL,
0x000000cccb00720bULL, 0x004fe20003fbd000ULL, 0x000001005dcc7824ULL, 0x000fcc00078e00ffULL,
0x0000009f00b77306ULL, 0x000fe20000209400ULL, 0x0000000183834812ULL, 0x002fe400078efcffULL,
0x000000bab100720bULL, 0x000fe20003f9d000ULL, 0x000001005eb17824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe4000001143aULL, 0x00000083b2b2723eULL, 0x000fe200000010ffULL,
0x0000009f00b07306ULL, 0x0002a20000205400ULL, 0x0000000182823812ULL, 0x008fe400078efcffULL,
0x00000018ffb17819ULL, 0x000fca00000114b1ULL, 0x000000a700387306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fe4000020d400ULL, 0x000000017f7f4812ULL, 0x000fca00078efcffULL,
0x000000a700397306ULL, 0x000e620000205400ULL, 0x000000b0b700720bULL, 0x004fe20003fdd000ULL,
0x000001005cb77824ULL, 0x000fe200078e00ffULL, 0x0000003300b07245ULL, 0x000fc8000020d400ULL,
0x00000001b0b05812ULL, 0x000fe200078efcffULL, 0x000000a900327306ULL, 0x000fec0000209400ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x000000a900c57306ULL, 0x000ea20000205400ULL,
0x000000393800720bULL, 0x002fc40003f5d000ULL, 0x0000b00000387811ULL, 0x000fe400078e20ffULL,
0x000000b09f9f723eULL, 0x000fc600000010ffULL, 0x0000003b00bc7306ULL, 0x000ff00000009400ULL,
0x0000003b00b57306ULL, 0x000e620000005400ULL, 0x000000c53200720bULL, 0x004fe40003fbd000ULL,
0x000000003030783bULL, 0x000eaa0000000200ULL, 0x0000003b00797306ULL, 0x000770000000d400ULL,
0x000000dc00dd7306ULL, 0x000fe20000209400ULL, 0x00000100623b7824ULL, 0x008fe200078e00ffULL,
0x000000b5bc00720bULL, 0x002fc80003f7d000ULL, 0x00000018ffbd7819ULL, 0x000fe4000001143bULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x000000dc00d67306ULL, 0x0007ec0000205400ULL,
0x0000000179793812ULL, 0x020fe400078efcffULL, 0x000000a200967306ULL, 0x000fe20000209400ULL,
0x000000dc00dc7245ULL, 0x008fc4000020d400ULL, 0x000000a09300720bULL, 0x000fe40003f7d000ULL,
0x000000a200937245ULL, 0x000fc6000020d400ULL, 0x000000a2009b7306ULL, 0x000ee20000205400ULL,
0x0000008730309231ULL, 0x084fe400003400ffULL, 0x0000008732329231ULL, 0x000fe400003400ffULL,
0x0000008631319231ULL, 0x010fc600003400ffULL, 0x000000bd00be7306ULL, 0x000fe20000209400ULL,
0x0000008633339231ULL, 0x000fe200003400ffULL, 0x0000000178783812ULL, 0x000fe400078efcffULL,
0x00000095a600720bULL, 0x000fe40003f7d000ULL, 0x000000a400957245ULL, 0x000fe4000020d400ULL,
0x000000bd00cb7306ULL, 0x000ea20000205400ULL, 0x0000009b9600720bULL, 0x008fe20003fdd000ULL,
0x000000d03048723cULL, 0x000fe20000041848ULL, 0x000000a900967245ULL, 0x000fe2000020d400ULL,
0x0000008738389231ULL, 0x002fc800003400ffULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000000873a3a9231ULL, 0x000fe200003400ffULL, 0x0000000196965812ULL, 0x000fe200078efcffULL,
0x0000008639399231ULL, 0x080fe200003400ffULL, 0x00000018ff877819ULL, 0x000fe200000114ccULL,
0x000000863b3b9231ULL, 0x000fe200003400ffULL, 0x000000d6dd00720bULL, 0x000fe40003f3d000ULL,
0x000000aa00b47306ULL, 0x0003e20000205400ULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x000000c300867245ULL, 0x000fc4000020d400ULL, 0x0000000172723812ULL, 0x000fe400078efcffULL,
0x000000799663723eULL, 0x000fe200000010ffULL, 0x000000b300ad7306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fe4000020d400ULL, 0x00000001dcdc1812ULL, 0x000fe400078efcffULL,
0x000000cbbe00720bULL, 0x004fc60003f3d000ULL, 0x000000b300b87306ULL, 0x000e700000205400ULL,
0x00000062009d7306ULL, 0x000ff00000009400ULL, 0x0000006200907306ULL, 0x000ea20000005400ULL,
0x000000b8ad00720bULL, 0x002fce0003fbd000ULL, 0x0000006200737306ULL, 0x0002f0000000d400ULL,
0x0000009e00987306ULL, 0x000fe20000209400ULL, 0x0001000062627824ULL, 0x002fe200078e00ffULL,
0x000000909d00720bULL, 0x004fc40003fdd000ULL, 0x0000009e00907245ULL, 0x000fe4000020d400ULL,
0x00000018ffb57819ULL, 0x000fe40000011462ULL, 0x0000009e00a17306ULL, 0x000e620000205400ULL,
0x000000a700627245ULL, 0x000fc8000020d400ULL, 0x0000000162622812ULL, 0x000fe400078efcffULL,
0x000000b4ab00720bULL, 0x000fe20003f5d000ULL, 0x000000ba00bc7306ULL, 0x000fe20000209400ULL,
0x0000000173736812ULL, 0x008fe400078efcffULL, 0x0000007f6262723eULL, 0x000fca00000010ffULL,
0x000000ba00c57306ULL, 0x000fe20000205400ULL, 0x000000a19800720bULL, 0x002fe20003f9d000ULL,
0x000000623034723cULL, 0x000fe40000041834ULL, 0x00000001aaaa2812ULL, 0x000fc800078efcffULL,
0x0000006100947306ULL, 0x000fec0000009400ULL, 0x0000000190904812ULL, 0x000fe400078efcffULL,
0x0000006100917306ULL, 0x000e700000005400ULL, 0x0000006100757306ULL, 0x000eb0000000d400ULL,
0x000000af00ae7306ULL, 0x000fe20000209400ULL, 0x000000919400720bULL, 0x002fc40003f5d000ULL,
0x00000018ff917819ULL, 0x000fe400000114b7ULL, 0x0000008dc6b7723eULL, 0x000fc600000010ffULL,
0x000000af00617306ULL, 0x0003e80000205400ULL, 0x000000b63054723cULL, 0x000fe40000041854ULL,
0x0000000175752812ULL, 0x004fe400078efcffULL, 0x0000008400897306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fce000020d400ULL, 0x0000008400887306ULL, 0x0002b00000205400ULL,
0x0000008e00a57306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x002fce000020d400ULL,
0x0000008e009c7306ULL, 0x0002e20000205400ULL, 0x000000888900720bULL, 0x004fe40003fdd000ULL,
0x000000ba00897245ULL, 0x000fca000020d400ULL, 0x000000c300c77306ULL, 0x000fe20000209400ULL,
0x000000bd008e7245ULL, 0x002fc8000020d400ULL, 0x000000018e8e1812ULL, 0x000fe400078efcffULL,
0x000000c5bc00720bULL, 0x000fe20003f3d000ULL, 0x000000c300d27306ULL, 0x000e620000205400ULL,
0x0000009ca500720bULL, 0x008fe40003f5d000ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x000000738e8e723eULL, 0x000fc600000010ffULL, 0x000000b500a77306ULL, 0x000fe80000209400ULL,
0x0000000189891812ULL, 0x000fe400078efcffULL, 0x000000018f8f2812ULL, 0x000fe400078efcffULL,
0x000000b500b47306ULL, 0x0004e20000205400ULL, 0x000000d2c700720bULL, 0x002fce0003f9d000ULL,
0x0000005d00a37306ULL, 0x000fe20000009400ULL, 0x000000b500b57245ULL, 0x004fca000020d400ULL,
0x0000000186864812ULL, 0x000fe400078efcffULL, 0x0000005d009a7306ULL, 0x000fe20000005400ULL,
0x000000b4a700720bULL, 0x008fe40003f3d000ULL, 0x000000758679723eULL, 0x000fca00000010ffULL,
0x0000005d006b7306ULL, 0x0003ec000000d400ULL, 0x00000001b5b51812ULL, 0x000fe400078efcffULL,
0x000000a400a87306ULL, 0x000fe20000209400ULL, 0x000000b3005d7245ULL, 0x002fe4000020d400ULL,
0x00000082bbb3723eULL, 0x000fc400000010ffULL, 0x000000015d5d5812ULL, 0x000fe400078efcffULL,
0x00000061ae00720bULL, 0x000fe20003fbd000ULL, 0x000000a400997306ULL, 0x000e620000205400ULL,
0x000000c4c961723eULL, 0x000fe200000010ffULL, 0x000000b23044723cULL, 0x000fe20000041844ULL,
0x0000005d905d723eULL, 0x000fe400000010ffULL, 0x000000b58484723eULL, 0x000fc600000010ffULL,
0x0000007e00817306ULL, 0x000fe40000209400ULL, 0x000000603050723cULL, 0x000fe40000041850ULL,
0x00000001afaf5812ULL, 0x000fc800078efcffULL, 0x0000007e00807306ULL, 0x0004e20000205400ULL,
0x00000099a800720bULL, 0x002fe40003fbd000ULL, 0x00000078af78723eULL, 0x000fca00000010ffULL,
0x000000c200c07306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x004fe2000020d400ULL,
0x000000783854723cULL, 0x000fe80000041854ULL, 0x0000000195955812ULL, 0x000fe400078efcffULL,
0x000000c200cd7306ULL, 0x0002a20000205400ULL, 0x000000808100720bULL, 0x008fe40003f3d000ULL,
0x000000dc95dc723eULL, 0x000fca00000010ffULL, 0x00000091009d7306ULL, 0x000fe20000209400ULL,
0x000000c200c27245ULL, 0x002fca000020d400ULL, 0x000000017e7e1812ULL, 0x000fe400078efcffULL,
0x00000091009e7306ULL, 0x0002e20000205400ULL, 0x000000cdc000720bULL, 0x004fce0003f9d000ULL,
0x0000005c00927306ULL, 0x000fe20000009400ULL, 0x0000009100917245ULL, 0x002fca000020d400ULL,
0x00000001c2c24812ULL, 0x000fe400078efcffULL, 0x0000005c00977306ULL, 0x000e620000005400ULL,
0x0000009e9d00720bULL, 0x008fe40003fdd000ULL, 0x0000009aa300720bULL, 0x000fe40003f9d000ULL,
0x000000acb99e723eULL, 0x000fe400000010ffULL, 0x000000c28fdd723eULL, 0x000fe200000010ffULL,
0x0000005e008c7306ULL, 0x000fe20000009400ULL, 0x00000072898f723eULL, 0x000fc600000010ffULL,
0x0000009e3040723cULL, 0x000fe40000041840ULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x0000005e008b7306ULL, 0x000ea20000005400ULL, 0x000000979200720bULL, 0x002fe40003fbd000ULL,
0x00000018ff927819ULL, 0x000fe200000114caULL, 0x000000dc3850723cULL, 0x000fe20000041850ULL,
0x000000016b6b4812ULL, 0x000fc600078efcffULL, 0x000000c100987306ULL, 0x000ff00000209400ULL,
0x000000c1009b7306ULL, 0x000e620000205400ULL, 0x0000008b8c00720bULL, 0x004fe40003f5d000ULL,
0x00000018ff8c7819ULL, 0x000fc400000114ceULL, 0x00000085c88b723eULL, 0x000fe400000010ffULL,
0x000000c100857245ULL, 0x000fe2000020d400ULL, 0x00000074007a7306ULL, 0x000fe80000209400ULL,
0x0000008a304c723cULL, 0x000fe8000004184cULL, 0x00000074007b7306ULL, 0x000ea20000205400ULL,
0x0000009b9800720bULL, 0x002fce0003f7d000ULL, 0x0000008700997306ULL, 0x000fec0000209400ULL,
0x0000000185853812ULL, 0x000fe400078efcffULL, 0x00000087009c7306ULL, 0x000e620000205400ULL,
0x0000007b7a00720bULL, 0x004fe40003f3d000ULL, 0x000000857e85723eULL, 0x000fe200000010ffULL,
0x0000008e384c723cULL, 0x040fe8000004184cULL, 0x0000005c006e7306ULL, 0x0004e8000000d400ULL,
0x000000843848723cULL, 0x000fe80000041848ULL, 0x0000005f007d7306ULL, 0x000fe20000009400ULL,
0x000001005f5c7824ULL, 0x004fe200078e00ffULL, 0x0000009c9900720bULL, 0x002fc80003fdd000ULL,
0x00000018ff807819ULL, 0x000fe4000001145cULL, 0x0000005f007c7306ULL, 0x000e620000005400ULL,
0x000000aa935c723eULL, 0x000fe400000010ffULL, 0x000000016e6e5812ULL, 0x008fe400078efcffULL,
0x0000008c00937245ULL, 0x000fe4000020d400ULL, 0x0000006e916e723eULL, 0x000fe200000010ffULL,
0x0000006d00777306ULL, 0x000fe20000209400ULL, 0x0000005c303c723cULL, 0x000fee000004183cULL,
0x0000006d00767306ULL, 0x000ea20000205400ULL, 0x0000007400317245ULL, 0x000fc4000020d400ULL,
0x0000007c7d00720bULL, 0x002fe40003f7d000ULL, 0x0000000131311812ULL, 0x000fe400078efcffULL,
0x0000006d00307245ULL, 0x000fe2000020d400ULL, 0x0000009200947306ULL, 0x000ff00000209400ULL,
0x00000092008d7306ULL, 0x0003e20000205400ULL, 0x000000767700720bULL, 0x004fce0003fbd000ULL,
0x0000008c00887306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x002fca000020d400ULL,
0x0000000130305812ULL, 0x000fe400078efcffULL, 0x0000008c00617306ULL, 0x000e700000205400ULL,
0x000000b100607306ULL, 0x000ff00000209400ULL, 0x000000b100817306ULL, 0x0004e20000205400ULL,
0x000000618800720bULL, 0x002fce0003f9d000ULL, 0x0000005e006a7306ULL, 0x000322000000d400ULL,
0x000000b100b17245ULL, 0x004fca000020d400ULL, 0x0000000193934812ULL, 0x000fe400078efcffULL,
0x0000005f00697306ULL, 0x000562000000d400ULL, 0x000100005e5e7824ULL, 0x002fe200078e00ffULL,
0x000000816000720bULL, 0x008fe40003f3d000ULL, 0x000000933093723eULL, 0x000fe400000010ffULL,
0x00000018ff627819ULL, 0x000fe4000001145eULL, 0x00000087005e7245ULL, 0x000fe2000020d400ULL,
0x000100005f5f7824ULL, 0x004fe200078e00ffULL, 0x00000080007c7306ULL, 0x000fe20000209400ULL,
0x000000016a6a2812ULL, 0x010fc400078efcffULL, 0x000000015e5e6812ULL, 0x000fe400078efcffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000008d9400720bULL, 0x000fe20003fdd000ULL,
0x00000080007b7306ULL, 0x0002a20000205400ULL, 0x00000001b1b11812ULL, 0x000fe400078efcffULL,
0x0000000169693812ULL, 0x020fe400078efcffULL, 0x0000006ab16a723eULL, 0x000fc600000010ffULL,
0x0000006700707306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fc6000020d400ULL,
0x0000000192926812ULL, 0x000fc800078efcffULL, 0x0000006700717306ULL, 0x0002e20000205400ULL,
0x0000007b7c00720bULL, 0x004fe40003fbd000ULL, 0x000000923192723eULL, 0x000fca00000010ffULL,
0x00000068006c7306ULL, 0x000fe20000209400ULL, 0x0000006700677245ULL, 0x002fe2000020d400ULL,
0x000000923840723cULL, 0x000fe80000041840ULL, 0x0000000180805812ULL, 0x000fe400078efcffULL,
0x00000068006f7306ULL, 0x0002a20000205400ULL, 0x000000717000720bULL, 0x008fce0003fdd000ULL,
0x0000006200637306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x002fca000020d400ULL,
0x0000000167676812ULL, 0x000fe400078efcffULL, 0x0000006200327306ULL, 0x0002e20000205400ULL,
0x0000006f6c00720bULL, 0x004fe40003f9d000ULL, 0x0000006b5e6f723eULL, 0x000fe400000010ffULL,
0x00000069806b723eULL, 0x000fc600000010ffULL, 0x0000005f00337306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x002fe2000020d400ULL, 0x0000006e3844723cULL, 0x040fe80000041844ULL,
0x0000000168684812ULL, 0x000fe400078efcffULL, 0x0000005f005c7306ULL, 0x000e620000205400ULL,
0x000000326300720bULL, 0x008fe20003f3d000ULL, 0x0000006a3834723cULL, 0x000fe20000041834ULL,
0x0000005f00637245ULL, 0x000fd6000020d400ULL, 0x0000000162621812ULL, 0x000fe400078efcffULL,
0x0000005c3300720bULL, 0x002fe40003f5d000ULL, 0x000000626762723eULL, 0x000fd600000010ffULL,
0x0000000163632812ULL, 0x000fc800078efcffULL, 0x000000636863723eULL, 0x000fce00000010ffULL,
0x000000623838723cULL, 0x000fe2000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff307f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c02b337811ULL, 0x000fe200078e40ffULL,
0x01069800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000332c00720cULL, 0x000fda0003f24070ULL,
0x00004f6000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x002e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000327305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000320000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff327984ULL, 0x000e640000000800ULL, 0x8000000032ff7812ULL, 0x002fc40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff307424ULL, 0x000fe200078e00ffULL,
0x0000000328327812ULL, 0x000fe200078ec0ffULL, 0x00000300ff317624ULL, 0x000fe400078e00ffULL,
0x00005800263c7a24ULL, 0x000fe200078e02ffULL, 0x000000033200780cULL, 0x000fe20003f25270ULL,
0xfffffffd30317424ULL, 0x000fe200078e0231ULL, 0x000000e02b337811ULL, 0x000fe200078e40ffULL,
0xffffffffff267424ULL, 0x000fc600078e00ffULL, 0x0000000131317807ULL, 0x000fca0004800000ULL,
0x0000000128287824ULL, 0x000fca00078e0231ULL, 0x0000002a2800720cULL, 0x000fe40003f26070ULL,
0x000000332c327217ULL, 0x000fe20007800000ULL, 0x000000403c3d7824ULL, 0x000fc800078e00ffULL,
0x0000000132327824ULL, 0x000fe200078e0a33ULL, 0x000000223d227210ULL, 0x000fca0007f5e0ffULL,
0x0000000128319824ULL, 0x000fe200078e0223ULL, 0x0000002032327807ULL, 0x000fc60000000000ULL,
0x0000600031309625ULL, 0x000fe200078e0030ULL, 0x0000001e3d1e7210ULL, 0x040fe40007f7e0ffULL,
0x0000001d3d3c7210ULL, 0x000fe40007f9e0ffULL, 0x0000003227327217ULL, 0x000fe20007800000ULL,
0x0000000630269981ULL, 0x000362000c1e1900ULL, 0x0000001c3d3f7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x00005e00221c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e06ffULL, 0x00000004ff1d7819ULL, 0x000fe2000001162dULL,
0x0000000132327824ULL, 0x000fe200078e0a27ULL, 0x00005e003c3e7a11ULL, 0x000fc400078640ffULL,
0x0000001b1c1c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff317224ULL, 0x002fe200010e06ffULL,
0x00005e001e307a11ULL, 0x000fe400078440ffULL, 0x00005f003c3d7a11ULL, 0x000fe400018f443dULL,
0x00005f0022317a11ULL, 0x000fe400000f4431ULL, 0x00005f001e337a11ULL, 0x000fe200010f4433ULL,
0x000000ffff1e7224ULL, 0x000fe200008e06ffULL, 0x000000321d00720cULL, 0x000fe20003f06070ULL,
0x000000ffff1d7224ULL, 0x000fe200020e0631ULL, 0x00005e003f3c7a11ULL, 0x000fc400078240ffULL,
0x000000322100720cULL, 0x080fe40003f66070ULL, 0x000000322000720cULL, 0x080fe40003fa6070ULL,
0x000000321f00720cULL, 0x000fe40003f86070ULL, 0x0000001b30307210ULL, 0x080fe40007f5e0ffULL,
0x0000001b3e327210ULL, 0x080fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c1a7faeULL, 0x0003e2000c101c46ULL, 0x00005f003f1e7a11ULL, 0x000fe200008f441eULL,
0x000000ffff317224ULL, 0x000fe200010e0633ULL, 0x0000001b3c3c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff337224ULL, 0x000fc600030e063dULL, 0x0000000030197faeULL, 0x0003e2000d901c46ULL,
0x000000ffff3d7224ULL, 0x000fc600008e061eULL, 0x0000000032187faeULL, 0x0003e8000e901c46ULL,
0x000000003c177faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff187f8cULL, 0x002e68000c80043fULL,
0x0106ac00ff177984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01066800271c7f8cULL, 0x000fe2000c80043fULL,
0x8000000017ff7812ULL, 0x004fc6000780485aULL, 0x01066c0027317984ULL, 0x000ea40000000800ULL,
0x8000000031ff7812ULL, 0x004fe4000782481dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff177424ULL, 0x000fc800078e00ffULL, 0x00000017001a7305ULL, 0x0004e4000021f000ULL,
0x3fa0000017177823ULL, 0x004fe200000100ffULL, 0x0000001a0000735dULL, 0x008fe20003800000ULL,
0x01066c0027317984ULL, 0x000ea40000000800ULL, 0x8000000031ff7812ULL, 0x004fc4000782481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01018000161a7984ULL, 0x000ea80000000800ULL,
0x0103800016177984ULL, 0x0007220000000800ULL, 0x000000251a00720bULL, 0x004fe20003f3d000ULL,
0x0000e6827f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x008fc800008e0100ULL,
0x0000ffff1c1e7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ffdb7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000032e00780cULL, 0x000fe40003f45270ULL, 0x000000251a00720bULL, 0x000fe20003f34000ULL,
0x0000e6527f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x000fe400008e0100ULL,
0x0000001a25317209ULL, 0x000fe40007810000ULL, 0x00000002ff6c7819ULL, 0x000fc6000001162dULL,
0x80000031251d7221ULL, 0x000fe20000010000ULL, 0x010580311600a388ULL, 0x0005e20000000800ULL,
0x0000ffff1c257812ULL, 0x000fe400078e3cffULL, 0x3fb8aa3b1d1d7820ULL, 0x000fe40000410000ULL,
0x000000251eff7212ULL, 0x000fe4000782c0ffULL, 0x0000001d00637308ULL, 0x000ee40000000800ULL,
0x0000006324247220ULL, 0x008fe20000410000ULL, 0x0000e5f27f007947ULL, 0x000fec000b800000ULL,
0x00001f6c63627589ULL, 0x0044e400000e0000ULL, 0x0000006254547220ULL, 0x08cfe20000410000ULL,
0x0000006255557220ULL, 0x080fe20000410000ULL, 0x0000006250507220ULL, 0x080fe20000410000ULL,
0x0000006251517220ULL, 0x080fe20000410000ULL, 0x000000624c4c7220ULL, 0x080fe20000410000ULL,
0x000000624d4d7220ULL, 0x080fe20000410000ULL, 0x0000006248487220ULL, 0x080fe20000410000ULL,
0x0000006249497220ULL, 0x080fe20000410000ULL, 0x0000006244447220ULL, 0x080fe20000410000ULL,
0x0000006245457220ULL, 0x080fe20000410000ULL, 0x0000006240407220ULL, 0x080fe20000410000ULL,
0x0000006241417220ULL, 0x080fe20000410000ULL, 0x0000006234347220ULL, 0x080fe20000410000ULL,
0x0000006235357220ULL, 0x080fe20000410000ULL, 0x0000006238387220ULL, 0x080fe20000410000ULL,
0x0000006239397220ULL, 0x000fe20000410000ULL, 0x0000e5227f007947ULL, 0x000fea000b800000ULL,
0x00001f2f63627589ULL, 0x0004e400000e0000ULL, 0x800000311a1a1221ULL, 0x100fe20000010000ULL,
0x00000001ffdb7807ULL, 0x000fe20000800000ULL, 0x0000006256567220ULL, 0x08cfe20000410000ULL,
0x0000006257577220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b1a1a1820ULL, 0x000fe20000410000ULL,
0x0000006252527220ULL, 0x080fe20000410000ULL, 0x0000006253537220ULL, 0x080fe20000410000ULL,
0x000000624e4e7220ULL, 0x080fe20000410000ULL, 0x0000001a00151308ULL, 0x000ea20000000800ULL,
0x000000624f4f7220ULL, 0x080fe20000410000ULL, 0x000000624a4a7220ULL, 0x080fe20000410000ULL,
0x000000624b4b7220ULL, 0x080fe20000410000ULL, 0x0000006246467220ULL, 0x080fe20000410000ULL,
0x0000006247477220ULL, 0x080fe20000410000ULL, 0x0000006242427220ULL, 0x080fe20000410000ULL,
0x0000006243437220ULL, 0x080fe20000410000ULL, 0x0000006236367220ULL, 0x080fe20000410000ULL,
0x0000006237377220ULL, 0x080fe20000410000ULL, 0x000000623a3a7220ULL, 0x080fe20000410000ULL,
0x000000623b3b7220ULL, 0x000fe20000410000ULL, 0x000000ffff257224ULL, 0x000fe200078e0031ULL,
0x0000001715171220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002417247221ULL, 0x010fe20000010000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106ac00ff177984ULL, 0x000ea40000000800ULL,
0x8000000017ff7812ULL, 0x004fc4000780485aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff167424ULL, 0x000fc800078e00ffULL,
0x0000001600177305ULL, 0x0004e4000021f000ULL, 0x3fa0000016167823ULL, 0x004fe200000100ffULL,
0x000000170000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff177984ULL, 0x000ea40000000800ULL,
0x8000000017ff7812ULL, 0x004fe4000780485aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff16723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x002fc4000001162dULL,
0x0000541016637816ULL, 0x000fe20000000016ULL, 0x0000e2c27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c63697589ULL, 0x0002a400000e0000ULL, 0x0000e3027f007947ULL, 0x000fea000b800000ULL,
0x00001f2f631e7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0066ULL, 0x00010eb0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0000e99000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0065ULL, 0x00010f10005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0000e93000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001430783bULL, 0x000e620000004200ULL, 0x0000b80010107811ULL, 0x000fc400078e20ffULL,
0x00009910dbdd7816ULL, 0x000fe200000000ffULL, 0x00000000133c783bULL, 0x000ee20000004200ULL,
0x0000b8000f0f7811ULL, 0x000fe400078e20ffULL, 0x000000ffdd00720cULL, 0x000fe20003f05270ULL,
0x00000000125c783bULL, 0x000f280000004200ULL, 0x000000001160783bULL, 0x00ee620000004200ULL,
0x0000010030d67824ULL, 0x040fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe20000011430ULL,
0x0000010031b67824ULL, 0x040fe200078e00ffULL, 0x0000003100d57306ULL, 0x000fe20000009400ULL,
0x00000018ff9b7819ULL, 0x000fe20000011431ULL, 0x0001000031b77824ULL, 0x000fe200078e00ffULL,
0x00000018ffd67819ULL, 0x000fe200000114d6ULL, 0x0001000030c97824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x000001003cbe7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011432ULL, 0x000000d600e67306ULL, 0x000fe20000209400ULL,
0x0001000033bb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x000001003dc17824ULL, 0x040fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe200000114beULL,
0x000100003dcd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe2000001143cULL,
0x000001003ed07824ULL, 0x000fe200078e00ffULL, 0x000000d600e77306ULL, 0x0004e20000205400ULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x000001005ede7824ULL, 0x010fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe20000011433ULL, 0x000001005ce07824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe2000001143dULL, 0x000100005edf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fe200000114c1ULL, 0x000000b500c87306ULL, 0x000fe20000209400ULL,
0x000000d600d67245ULL, 0x004fe2000020d400ULL, 0x000001003fd37824ULL, 0x040fe200078e00ffULL,
0x00000018ffb77819ULL, 0x000fe200000114b7ULL, 0x000100005ce97824ULL, 0x000fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe200000114d0ULL, 0x000100003fdc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x000000b500c77306ULL, 0x000ea20000205400ULL,
0x000000e7e600720bULL, 0x008fe20003f9d000ULL, 0x000100005fe17824ULL, 0x000fe200078e00ffULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x000001005dea7824ULL, 0x040fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001145eULL, 0x000100005de47824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe2000001145dULL, 0x000000b600ca7306ULL, 0x000fe20000209400ULL,
0x00000018ff897819ULL, 0x000fc4000001143fULL, 0x00000018ffaa7819ULL, 0x000fe4000001143eULL,
0x00000018ffd37819ULL, 0x000fe400000114d3ULL, 0x00000001d6d64812ULL, 0x000fe200078efcffULL,
0x000000b600d77306ULL, 0x000ee20000205400ULL, 0x000000c7c800720bULL, 0x004fe40003f5d000ULL,
0x00000018ffdf7819ULL, 0x000fe400000114dfULL, 0x00000018ffdb7819ULL, 0x000fc400000114dcULL,
0x00000018ffe17819ULL, 0x000fe200000114e1ULL, 0x0000003100d87306ULL, 0x000ea20000005400ULL,
0x00000018ff927819ULL, 0x000fe4000001145cULL, 0x00000018ff767819ULL, 0x000fe4000001145fULL,
0x00000018ffe47819ULL, 0x000fe400000114e4ULL, 0x00000018ff6c7819ULL, 0x002fe20000011460ULL,
0x0000003100807306ULL, 0x000322000000d400ULL, 0x000000d7ca00720bULL, 0x008fc40003f7d000ULL,
0x000000b600d77245ULL, 0x000fe4000020d400ULL, 0x00000018ff1d7819ULL, 0x000fe40000011461ULL,
0x00000018ff147819ULL, 0x000fe20000011462ULL, 0x0000003200c37306ULL, 0x000fe20000009400ULL,
0x0000010032317824ULL, 0x002fe200078e00ffULL, 0x000000d8d500720bULL, 0x004fe40003fbd000ULL,
0x00000018ff167819ULL, 0x000fe40000011463ULL, 0x00000018ff317819ULL, 0x000fc40000011431ULL,
0x0000003200c47306ULL, 0x000e620000005400ULL, 0x00000001d7d73812ULL, 0x000fcc00078efcffULL,
0x0000000180805812ULL, 0x010fe200078efcffULL, 0x0000003000e27306ULL, 0x000fe60000009400ULL,
0x00000080d7d7723eULL, 0x000fca00000010ffULL, 0x0000003000e37306ULL, 0x000ea20000005400ULL,
0x000000c4c300720bULL, 0x002fe40003f9d000ULL, 0x000000b500c47245ULL, 0x000fc8000020d400ULL,
0x00000001c4c42812ULL, 0x000fe200078efcffULL, 0x00000030007f7306ULL, 0x0002f0000000d400ULL,
0x0000003300b07306ULL, 0x000fe20000009400ULL, 0x0000010033307824ULL, 0x002fe200078e00ffULL,
0x000000e3e200720bULL, 0x004fe20003f3d000ULL, 0x0000010061e27824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003300af7306ULL, 0x000e620000005400ULL,
0x00000018ffe27819ULL, 0x000fcc00000114e2ULL, 0x000000017f7f1812ULL, 0x008fe200078efcffULL,
0x0000003100b87306ULL, 0x000fe60000209400ULL, 0x0000007fd6d6723eULL, 0x000fca00000010ffULL,
0x0000003100b97306ULL, 0x000ea20000205400ULL, 0x000000afb000720bULL, 0x002fe40003f5d000ULL,
0x0000009b00b07245ULL, 0x000fca000020d400ULL, 0x0000003000b37306ULL, 0x000ff00000209400ULL,
0x0000003000ba7306ULL, 0x000e620000205400ULL, 0x000000b9b800720bULL, 0x004fce0003f7d000ULL,
0x00000033007b7306ULL, 0x000eb0000000d400ULL, 0x000000be00bf7306ULL, 0x000fe20000209400ULL,
0x000000bab300720bULL, 0x002fce0003fbd000ULL, 0x000000be00c07306ULL, 0x0002e20000205400ULL,
0x000000017b7b2812ULL, 0x004fce00078efcffULL, 0x0000009d009f7306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x002fce000020d400ULL, 0x0000009d00a07306ULL, 0x000fe20000205400ULL,
0x000000c0bf00720bULL, 0x008fce0003f5d000ULL, 0x0000003c00127306ULL, 0x000fec0000009400ULL,
0x00000001bebe2812ULL, 0x000fe400078efcffULL, 0x0000003c00117306ULL, 0x000ff00000005400ULL,
0x0000003c00777306ULL, 0x0003f0000000d400ULL, 0x000000c900e87306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000000c900e57306ULL, 0x0002b00000205400ULL, 0x000000bb00bc7306ULL, 0x000fe20000209400ULL,
0x000000c900c97245ULL, 0x002fce000020d400ULL, 0x000000bb00bd7306ULL, 0x0003e20000205400ULL,
0x000000e5e800720bULL, 0x004fe40003fdd000ULL, 0x00000018ffe57819ULL, 0x000fca00000114eaULL,
0x0000009b00b27306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x002fca000020d400ULL,
0x00000001c9c96812ULL, 0x000fe400078efcffULL, 0x0000009b00b17306ULL, 0x0002b00000205400ULL,
0x0000003d00137306ULL, 0x000fe20000009400ULL, 0x00000031009b7245ULL, 0x002fc8000020d400ULL,
0x000000019b9b3812ULL, 0x000fe400078efcffULL, 0x000000a09f00720bULL, 0x000fe20003f7d000ULL,
0x0000003d00967306ULL, 0x000fe20000005400ULL, 0x0000003000a07245ULL, 0x000fe4000020d400ULL,
0x000000b1b200720bULL, 0x004fe40003fdd000ULL, 0x00000001a0a05812ULL, 0x000fe400078efcffULL,
0x000000bdbc00720bULL, 0x000fe20003fbd000ULL, 0x0000003d00757306ULL, 0x000fe2000000d400ULL,
0x00000018ffb17819ULL, 0x000fce00000114e9ULL, 0x0000003c00c67306ULL, 0x000fe20000209400ULL,
0x00000001b0b06812ULL, 0x000fc600078efcffULL, 0x00000001bbbb5812ULL, 0x000fc800078efcffULL,
0x0000003c003d7306ULL, 0x000e700000205400ULL, 0x00000032007c7306ULL, 0x0004f0000000d400ULL,
0x000000a100a27306ULL, 0x000fe20000209400ULL, 0x0001000032327824ULL, 0x004fe200078e00ffULL,
0x0000003dc600720bULL, 0x002fc80003f5d000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x000000a100a37306ULL, 0x000e620000205400ULL, 0x000000017c7c4812ULL, 0x008fe400078efcffULL,
0x00000032009f7245ULL, 0x000fe4000020d400ULL, 0x0000007c9b7c723eULL, 0x000fc600000010ffULL,
0x0000003e00937306ULL, 0x000ff00000009400ULL, 0x0000003e00987306ULL, 0x000ea20000005400ULL,
0x000000a3a200720bULL, 0x002fe40003f9d000ULL, 0x0000009d00a27245ULL, 0x000fc8000020d400ULL,
0x00000001a2a23812ULL, 0x000fe200078efcffULL, 0x000000c100c27306ULL, 0x000ff00000209400ULL,
0x000000c100c57306ULL, 0x000e620000205400ULL, 0x000000989300720bULL, 0x004fc40003fbd000ULL,
0x0000003c00937245ULL, 0x000fe4000020d400ULL, 0x000000c100987245ULL, 0x000fe4000020d400ULL,
0x0000000193932812ULL, 0x000fe200078efcffULL, 0x000000b700cb7306ULL, 0x000ff00000209400ULL,
0x000000b700cc7306ULL, 0x0004e20000205400ULL, 0x000000c5c200720bULL, 0x002fce0003f7d000ULL,
0x000000d000d17306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x004fca000020d400ULL,
0x0000000198983812ULL, 0x000fe400078efcffULL, 0x000000d000d27306ULL, 0x0002a20000205400ULL,
0x000000cccb00720bULL, 0x008fce0003f3d000ULL, 0x0000003200b47306ULL, 0x000fe20000209400ULL,
0x000000d000d07245ULL, 0x002fca000020d400ULL, 0x00000001b7b71812ULL, 0x000fe400078efcffULL,
0x0000003200337306ULL, 0x000e620000205400ULL, 0x000000d2d100720bULL, 0x004fe40003f5d000ULL,
0x000000111200720bULL, 0x000fca0003f3d000ULL, 0x000000cd00ce7306ULL, 0x000fec0000209400ULL,
0x00000001d0d02812ULL, 0x000fe400078efcffULL, 0x000000cd00cf7306ULL, 0x0004e20000205400ULL,
0x00000033b400720bULL, 0x002fe40003fdd000ULL, 0x0000000177771812ULL, 0x000fc800078efcffULL,
0x00000077bebe723eULL, 0x000fe200000010ffULL, 0x0000005d00997306ULL, 0x000fe20000009400ULL,
0x000000cd00cd7245ULL, 0x004fca000020d400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x0000005d009e7306ULL, 0x000e620000005400ULL, 0x000000cfce00720bULL, 0x008fe40003f7d000ULL,
0x000000961300720bULL, 0x000fe40003fdd000ULL, 0x000000a100967245ULL, 0x000fe2000020d400ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x0000009fa2a2723eULL, 0x000fe200000010ffULL,
0x0000005c00977306ULL, 0x000fe20000009400ULL, 0x0000000196964812ULL, 0x000fc800078efcffULL,
0x000000bb96a3723eULL, 0x000fe400000010ffULL, 0x00000001cdcd3812ULL, 0x000fe200078efcffULL,
0x0000005c009c7306ULL, 0x000ee20000005400ULL, 0x0000009e9900720bULL, 0x002fe40003f5d000ULL,
0x0000000175756812ULL, 0x000fc800078efcffULL, 0x0000007598bf723eULL, 0x000fe200000010ffULL,
0x0000003f00957306ULL, 0x000ff00000009400ULL, 0x0000003f009a7306ULL, 0x000e620000005400ULL,
0x0000009c9700720bULL, 0x008fc40003f7d000ULL, 0x00000089009c7245ULL, 0x000fca000020d400ULL,
0x000000a400a57306ULL, 0x000fe20000209400ULL, 0x0000006910108231ULL, 0x004fce00003400ffULL,
0x000000a400a67306ULL, 0x0004e20000205400ULL, 0x0000009a9500720bULL, 0x002fe20003f3d000ULL,
0x0000006912128231ULL, 0x000fe200003400ffULL, 0x000000a7009a7245ULL, 0x000fe2000020d400ULL,
0x0000001e11118231ULL, 0x080fe400003400ffULL, 0x0000001e13138231ULL, 0x000fe400003400ffULL,
0x0000005d006d7306ULL, 0x000322000000d400ULL, 0x000000a400a47245ULL, 0x004fc8000020d400ULL,
0x000000d61054723cULL, 0x000fe60000041854ULL, 0x000000de00327306ULL, 0x000fe20000209400ULL,
0x000000a6a500720bULL, 0x008fe20003f9d000ULL, 0x00000100625d7824ULL, 0x002fc600078e00ffULL,
0x000000a21048723cULL, 0x000fe60000041848ULL, 0x000000de00337306ULL, 0x000e620000205400ULL,
0x000000016d6d2812ULL, 0x010fc800078efcffULL, 0x000000be1044723cULL, 0x000fe20000041844ULL,
0x00000001a4a44812ULL, 0x000fe400078efcffULL, 0x0000005e008b7306ULL, 0x000fe40000009400ULL,
0x00000093a4a4723eULL, 0x000fcc00000010ffULL, 0x0000005e008c7306ULL, 0x000fe20000005400ULL,
0x000000333200720bULL, 0x002fce0003f5d000ULL, 0x0000005e00687306ULL, 0x0003f0000000d400ULL,
0x0000005c006e7306ULL, 0x0004e2000000d400ULL, 0x00000018ff5e7819ULL, 0x002fe200000114e0ULL,
0x000001005fe07824ULL, 0x000fca00078e00ffULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x00000100635c7824ULL, 0x004fe400078e00ffULL,
0x000000e0007f7245ULL, 0x000fca000020d400ULL, 0x000000a700a97306ULL, 0x000e620000205400ULL,
0x000000016e6e3812ULL, 0x008fce00078efcffULL, 0x00000082008a7306ULL, 0x000ff00000209400ULL,
0x0000008200877306ULL, 0x000ea20000205400ULL, 0x000000a9a800720bULL, 0x002fce0003fdd000ULL,
0x0000003f00747306ULL, 0x000e6c000000d400ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000008900ad7306ULL, 0x000fe20000209400ULL, 0x000000878a00720bULL, 0x004fe40003f7d000ULL,
0x000000de00877245ULL, 0x000fc4000020d400ULL, 0x000000cd9aa5723eULL, 0x000fe400000010ffULL,
0x0000000187872812ULL, 0x000fe200078efcffULL, 0x0000008900ae7306ULL, 0x0004e20000205400ULL,
0x0000000174741812ULL, 0x002fc600078efcffULL, 0x000000a41040723cULL, 0x000fe80000041840ULL,
0x0000003e00717306ULL, 0x000322000000d400ULL, 0x0000005e00897245ULL, 0x004fce000020d400ULL,
0x000000e0009d7306ULL, 0x000fe20000209400ULL, 0x000100003e3e7824ULL, 0x002fe200078e00ffULL,
0x000000aead00720bULL, 0x008fc80003f3d000ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x000000e000a67306ULL, 0x000e620000205400ULL, 0x0000000171715812ULL, 0x010fe400078efcffULL,
0x0000003e00957245ULL, 0x000fc8000020d400ULL, 0x000000019c9c1812ULL, 0x000fe200078efcffULL,
0x0000003e00da7306ULL, 0x000ff00000209400ULL, 0x0000003e003f7306ULL, 0x000ea20000205400ULL,
0x000000a69d00720bULL, 0x002fce0003f5d000ULL, 0x000000d300d47306ULL, 0x000fec0000209400ULL,
0x000000017f7f2812ULL, 0x000fe400078efcffULL, 0x000000d300d97306ULL, 0x0002e20000205400ULL,
0x0000003fda00720bULL, 0x004fce0003fdd000ULL, 0x000000b100af7306ULL, 0x000fe20000209400ULL,
0x000000d300d37245ULL, 0x002fca000020d400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x000000b100b27306ULL, 0x0002a20000205400ULL, 0x000000d9d400720bULL, 0x008fce0003f9d000ULL,
0x000000df003c7306ULL, 0x000fe20000209400ULL, 0x000000b100b17245ULL, 0x002fca000020d400ULL,
0x00000001d3d34812ULL, 0x000fe400078efcffULL, 0x000000df003d7306ULL, 0x0002e20000205400ULL,
0x000000b2af00720bULL, 0x004fce0003f3d000ULL, 0x0000005e00e37306ULL, 0x000fe20000209400ULL,
0x000000df00df7245ULL, 0x002fca000020d400ULL, 0x00000001b1b11812ULL, 0x000fe400078efcffULL,
0x0000005e00e67306ULL, 0x0002a20000205400ULL, 0x0000003d3c00720bULL, 0x008fce0003f5d000ULL,
0x000000aa00ab7306ULL, 0x000fe20000209400ULL, 0x000000e5005e7245ULL, 0x002fca000020d400ULL,
0x00000001dfdf2812ULL, 0x000fe400078efcffULL, 0x000000aa00ac7306ULL, 0x0002e20000205400ULL,
0x000000e6e300720bULL, 0x004fce0003fdd000ULL, 0x000000db00dc7306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fca000020d400ULL, 0x0000000189896812ULL, 0x000fe400078efcffULL,
0x000000db00dd7306ULL, 0x0002a20000205400ULL, 0x000000acab00720bULL, 0x008fe40003fbd000ULL,
0x0000006e896e723eULL, 0x000fca00000010ffULL, 0x0000005f00867306ULL, 0x000fe20000009400ULL,
0x000000db00db7245ULL, 0x002fca000020d400ULL, 0x00000001aaaa5812ULL, 0x000fe400078efcffULL,
0x0000005f008f7306ULL, 0x000e620000005400ULL, 0x000000dddc00720bULL, 0x004fce0003f9d000ULL,
0x000000e1003e7306ULL, 0x000fec0000209400ULL, 0x00000001dbdb4812ULL, 0x000fe400078efcffULL,
0x000000e1003f7306ULL, 0x0004e20000205400ULL, 0x0000008f8600720bULL, 0x002fe40003f3d000ULL,
0x0000008c8b00720bULL, 0x000fca0003f9d000ULL, 0x0000009200947306ULL, 0x000fe20000209400ULL,
0x000000e100e17245ULL, 0x004fce000020d400ULL, 0x00000092008d7306ULL, 0x0002a20000205400ULL,
0x0000003f3e00720bULL, 0x008fe40003f5d000ULL, 0x000000000f3c783bULL, 0x0007220000000200ULL,
0x0000000168684812ULL, 0x000fc800078efcffULL, 0x0000005f006a7306ULL, 0x0004e2000000d400ULL,
0x0000009200927245ULL, 0x002fca000020d400ULL, 0x00000001e1e12812ULL, 0x000fe400078efcffULL,
0x000000e500c77306ULL, 0x000fe20000209400ULL, 0x00000100605f7824ULL, 0x004fe200078e00ffULL,
0x0000008d9400720bULL, 0x000fc80003fdd000ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x000000e500c87306ULL, 0x000e620000205400ULL, 0x000000016a6a1812ULL, 0x008fe400078efcffULL,
0x0000005f000f7245ULL, 0x000fc8000020d400ULL, 0x0000000192926812ULL, 0x000fe200078efcffULL,
0x0000007a007e7306ULL, 0x000ff00000209400ULL, 0x0000007a007d7306ULL, 0x0004e20000205400ULL,
0x000000c8c700720bULL, 0x002fe20003fbd000ULL, 0x000000693c3c8231ULL, 0x010fc400003400ffULL,
0x000000693e3e8231ULL, 0x000fe400003400ffULL, 0x0000001e3d3d8231ULL, 0x080fe400003400ffULL,
0x0000006000907306ULL, 0x000fe20000009400ULL, 0x0000007a007a7245ULL, 0x004fe2000020d400ULL,
0x0000001e3f3f8231ULL, 0x000fc800003400ffULL, 0x000000015e5e5812ULL, 0x000fe400078efcffULL,
0x0000006000857306ULL, 0x000e620000005400ULL, 0x0000007d7e00720bULL, 0x008fe40003f3d000ULL,
0x0000007ba07d723eULL, 0x000fe400000010ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001145dULL,
0x000000db9c5d723eULL, 0x000fe200000010ffULL, 0x000000e400307306ULL, 0x000fe20000209400ULL,
0x0000007b001e7245ULL, 0x000fe2000020d400ULL, 0x0000007c104c723cULL, 0x000fe8000004184cULL,
0x000000017a7a1812ULL, 0x000fc400078efcffULL, 0x000000e400317306ULL, 0x0004e20000205400ULL,
0x000000859000720bULL, 0x002fe40003fdd000ULL, 0x0000008200857245ULL, 0x000fc8000020d400ULL,
0x0000000185853812ULL, 0x000fe200078efcffULL, 0x0000007600787306ULL, 0x000fe20000209400ULL,
0x000000e400e47245ULL, 0x004fce000020d400ULL, 0x0000007600797306ULL, 0x0002a20000205400ULL,
0x000000313000720bULL, 0x008fe40003fbd000ULL, 0x000000c9c430723eULL, 0x000fe400000010ffULL,
0x000000b7b031723eULL, 0x000fc600000010ffULL, 0x0000005f008b7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fc6000020d400ULL, 0x000000301030723cULL, 0x040fe40000041850ULL,
0x00000001e4e45812ULL, 0x000fe400078efcffULL, 0x0000005f008a7306ULL, 0x000e620000205400ULL,
0x000000797800720bULL, 0x004fe40003f3d000ULL, 0x00000071d050723eULL, 0x000fe400000010ffULL,
0x00000074d351723eULL, 0x000fe400000010ffULL, 0x000000e48585723eULL, 0x000fe200000010ffULL,
0x0000006100817306ULL, 0x000fe80000009400ULL, 0x000000501050723cULL, 0x000fe40000041834ULL,
0x0000000176761812ULL, 0x000fc400078efcffULL, 0x0000006100847306ULL, 0x000ea20000005400ULL,
0x0000008a8b00720bULL, 0x002fe40003f5d000ULL, 0x000000688734723eULL, 0x000fe400000010ffULL,
0x0000006a7f35723eULL, 0x000fc600000010ffULL, 0x0000006300887306ULL, 0x000fe80000009400ULL,
0x000000343c34723cULL, 0x000fe4000004184cULL, 0x000000010f0f2812ULL, 0x000fe400078efcffULL,
0x0000006300837306ULL, 0x000e620000005400ULL, 0x000000848100720bULL, 0x004fce0003fbd000ULL,
0x0000006c00737306ULL, 0x000ff00000209400ULL, 0x0000006c00727306ULL, 0x000ea20000205400ULL,
0x000000838800720bULL, 0x002fce0003f9d000ULL, 0x00000060005a7306ULL, 0x0002f0000000d400ULL,
0x0000001d00707306ULL, 0x000fe20000209400ULL, 0x0001000060607824ULL, 0x002fe200078e00ffULL,
0x000000727300720bULL, 0x004fc40003f3d000ULL, 0x00000018ff727819ULL, 0x000fe4000001145cULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x0000001d006f7306ULL, 0x0002a20000205400ULL,
0x000000015a5a6812ULL, 0x008fe400078efcffULL, 0x00000095aa5c723eULL, 0x000fe400000010ffULL,
0x0000005a0f4c723eULL, 0x000fe400000010ffULL, 0x00000072000f7245ULL, 0x000fe2000020d400ULL,
0x000000e200827306ULL, 0x000fe20000209400ULL, 0x0000001d001d7245ULL, 0x002fce000020d400ULL,
0x000000e2008d7306ULL, 0x000e620000205400ULL, 0x0000006f7000720bULL, 0x004fe40003f5d000ULL,
0x0000006d5e6f723eULL, 0x000fe400000010ffULL, 0x0000005c105c723cULL, 0x000fe60000041838ULL,
0x00000061001c7306ULL, 0x0004e8000000d400ULL, 0x000000df7a38723eULL, 0x000fe200000010ffULL,
0x0000006e3c10723cULL, 0x000fe20000041854ULL, 0x000000011d1d2812ULL, 0x000fc400078efcffULL,
0x00000062008e7306ULL, 0x000fe20000009400ULL, 0x0001000061617824ULL, 0x004fe200078e00ffULL,
0x0000008d8200720bULL, 0x002fe40003fdd000ULL, 0x0000006c00557245ULL, 0x000fe4000020d400ULL,
0x00000018ff7e7819ULL, 0x000fe40000011461ULL, 0x0000006200917306ULL, 0x000e620000005400ULL,
0x000000e200617245ULL, 0x000fe4000020d400ULL, 0x000000011c1c5812ULL, 0x008fc400078efcffULL,
0x0000000155551812ULL, 0x000fe400078efcffULL, 0x0000000161616812ULL, 0x000fe200078efcffULL,
0x0000006000807306ULL, 0x000fe20000209400ULL, 0x000000e17639723eULL, 0x000fe400000010ffULL,
0x0000001c614d723eULL, 0x000fca00000010ffULL, 0x0000006000817306ULL, 0x0004e20000205400ULL,
0x000000918e00720bULL, 0x002fe20003f7d000ULL, 0x000000383c38723cULL, 0x040fec0000041848ULL,
0x0000007e00837306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x004fe2000020d400ULL,
0x0000004c3c44723cULL, 0x000fec0000041844ULL, 0x0000007e00847306ULL, 0x0002a20000205400ULL,
0x000000818000720bULL, 0x008fce0003fdd000ULL, 0x0000007b00777306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fca000020d400ULL, 0x0000000160606812ULL, 0x000fe400078efcffULL,
0x0000007b00787306ULL, 0x000e620000205400ULL, 0x000000848300720bULL, 0x004fe40003fbd000ULL,
0x000000b19284723eULL, 0x000fe400000010ffULL, 0x000000605560723eULL, 0x000fc600000010ffULL,
0x0000006200177306ULL, 0x0004e4000000d400ULL, 0x000000843c30723cULL, 0x000fe80000041830ULL,
0x000000017e7e5812ULL, 0x000fe400078efcffULL, 0x00000063001a7306ULL, 0x0008e2000000d400ULL,
0x0001000062627824ULL, 0x004fe200078e00ffULL, 0x000000787700720bULL, 0x002fc40003f3d000ULL,
0x0000007e1d61723eULL, 0x000fe400000010ffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000007200717306ULL, 0x000fe20000209400ULL, 0x0001000063637824ULL, 0x010fe200078e00ffULL,
0x0000000117173812ULL, 0x008fe200078efcffULL, 0x000000603c40723cULL, 0x000fe60000041840ULL,
0x00000018ff637819ULL, 0x000fc40000011463ULL, 0x0000007200747306ULL, 0x000e620000205400ULL,
0x000000011e1e1812ULL, 0x000fe400078efcffULL, 0x000000011a1a4812ULL, 0x000fe400078efcffULL,
0x000000171e1c723eULL, 0x000fc600000010ffULL, 0x0000001400647306ULL, 0x000ff00000209400ULL,
0x00000014006b7306ULL, 0x000ea20000205400ULL, 0x000000747100720bULL, 0x002fce0003f5d000ULL,
0x0000001600227306ULL, 0x000fec0000209400ULL, 0x000000010f0f2812ULL, 0x000fe400078efcffULL,
0x0000001600677306ULL, 0x0002e20000205400ULL, 0x0000006b6400720bULL, 0x004fe40003fdd000ULL,
0x0000001a0f1d723eULL, 0x000fc400000010ffULL, 0x00000014000f7245ULL, 0x000fc6000020d400ULL,
0x0000006200697306ULL, 0x000fe20000209400ULL, 0x0000001600167245ULL, 0x002fe2000020d400ULL,
0x0000001c3c50723cULL, 0x000fe80000041850ULL, 0x000000010f0f6812ULL, 0x000fe400078efcffULL,
0x0000006200707306ULL, 0x0002a20000205400ULL, 0x000000672200720bULL, 0x008fce0003fbd000ULL,
0x0000006300547306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fca000020d400ULL,
0x0000000116165812ULL, 0x000fe400078efcffULL, 0x0000006300577306ULL, 0x0002e20000205400ULL,
0x000000706900720bULL, 0x004fe40003f3d000ULL, 0x0000006300637245ULL, 0x002fd6000020d400ULL,
0x0000000162621812ULL, 0x000fe400078efcffULL, 0x000000575400720bULL, 0x008fe40003f7d000ULL,
0x000000620f62723eULL, 0x000fd600000010ffULL, 0x0000000163633812ULL, 0x000fc800078efcffULL,
0x000000631663723eULL, 0x000fce00000010ffULL, 0x000000623c3c723cULL, 0x000fe2000004185cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff167f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007824817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007824817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL,
0x0000000f00147305ULL, 0x0002a4000021f000ULL, 0x3fa000000f0f7823ULL, 0x002fe200000100ffULL,
0x000000140000735dULL, 0x004fe20003800000ULL, 0x0106bc00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007824817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000003002b0f7a10ULL, 0x000fe20007ffe0ffULL, 0x0000580026147a24ULL, 0x020fc800078e02ffULL,
0x000001000f177824ULL, 0x040fe400078e00ffULL, 0x00000040141a7824ULL, 0x000fe200078e00ffULL,
0x000000010f147810ULL, 0x000fe40007ffe0ffULL, 0x000000172c167217ULL, 0x000fe40007800000ULL,
0x0000000e1a0e7210ULL, 0x000fe40007f3e0ffULL, 0x000000291400720cULL, 0x000fe20003f46070ULL,
0x0000000116167824ULL, 0x000fe200078e0a17ULL, 0x0000000d1a0d7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x00005e000e1c7a11ULL, 0x000fc400078640ffULL,
0x0000002016167807ULL, 0x000fe40001000000ULL, 0x0000000c1a1d7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200020e06ffULL, 0x0000000b1a227210ULL, 0x000fe40007f3e0ffULL,
0x00005f000e0f7a11ULL, 0x000fe200018f440fULL, 0x000000ffff1a7224ULL, 0x000fe200028e06ffULL,
0x0000001627167217ULL, 0x000fe20007800000ULL, 0x000000ffff497224ULL, 0x000fe200008e06ffULL,
0x00005e000d0e7a11ULL, 0x000fc400078440ffULL, 0x00005e001d1e7a11ULL, 0x000fe200078640ffULL,
0x0000000116147824ULL, 0x000fe200078e0a27ULL, 0x00005f000d177a11ULL, 0x000fe400010f440cULL,
0x00000004ff0b7819ULL, 0x000fe4000001162dULL, 0x00005e0022487a11ULL, 0x000fe400078240ffULL,
0x0000001b1c0c7210ULL, 0x080fe40007f9e0ffULL, 0x0000001b0e0e7210ULL, 0x000fc40007fbe0ffULL,
0x00005f001d1a7a11ULL, 0x000fe200018f441aULL, 0x000000ffff0d7224ULL, 0x000fe200020e060fULL,
0x00005f0022497a11ULL, 0x000fe200008f4449ULL, 0x000000ffff0f7224ULL, 0x000fe200028e0617ULL,
0x000000140b00720cULL, 0x080fe40003f46070ULL, 0x0000001b1e167210ULL, 0x000fe40007f7e0ffULL,
0x000000142100720cULL, 0x080fe40003f26070ULL, 0x000000142000720cULL, 0x080fe20003f86070ULL,
0x000000ffff177224ULL, 0x000fe200018e061aULL, 0x000000141f00720cULL, 0x000fc40003fa6070ULL,
0x0000001b481a7210ULL, 0x000fc60007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0a7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff1b7224ULL, 0x000fe400018e0649ULL,
0x000000000e097faeULL, 0x0003e8000c901c46ULL, 0x0000000016087faeULL, 0x0003e8000e101c46ULL,
0x000000001a077faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff087f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007824819ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5a7224ULL, 0x000fe200078e0009ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106b400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007824819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff077424ULL, 0x000fc800078e00ffULL, 0x0000000700087305ULL, 0x0002a4000021f000ULL,
0x3fa0000007077823ULL, 0x002fe200000100ffULL, 0x000000080000735dULL, 0x004fe20003800000ULL,
0x0106b400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007824819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff07723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x000fe4000001162dULL, 0x0000541007637816ULL, 0x000fe20000000007ULL,
0x0000bf027f007947ULL, 0x000fea000b800000ULL, 0x00001f6c63697589ULL, 0x0002a400000e0000ULL,
0x0000bf427f007947ULL, 0x000fea000b800000ULL, 0x00001f2f63647589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0066ULL,
0x00013340005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0000c50000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0065ULL,
0x000133a0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0000c4a000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000608783bULL, 0x000f620000004200ULL,
0x0000b80002027811ULL, 0x000fc600078e20ffULL, 0x00000000050c783bULL, 0x000e680000004200ULL,
0x000000000418783bULL, 0x000ee80000004200ULL, 0x00000000031c783bULL, 0x000f220000004200ULL,
0x0000010008927824ULL, 0x020fe200078e00ffULL, 0x0000000800a77306ULL, 0x000fe20000009400ULL,
0x00000018ffba7819ULL, 0x000fe20000011408ULL, 0x000001000ba87824ULL, 0x040fe200078e00ffULL,
0x00000018ffa27819ULL, 0x000fe20000011409ULL, 0x000001000aad7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe20000011492ULL, 0x000100000ba97824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x0000000800aa7306ULL, 0x000f620000005400ULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x000100000aac7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fe200000114a9ULL, 0x000100000cab7824ULL, 0x002fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe2000001140aULL, 0x000001000e937824ULL, 0x040fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x0000000800737306ULL, 0x0002a2000000d400ULL,
0x00000018ff8d7819ULL, 0x000fe2000001140bULL, 0x000100000d987824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x000001000f927824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe2000001140dULL, 0x000100000e997824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011493ULL, 0x000000b200b57306ULL, 0x000fe20000209400ULL,
0x0001000008087824ULL, 0x002fe200078e00ffULL, 0x000000aaa700720bULL, 0x020fe20003f9d000ULL,
0x0001000018d27824ULL, 0x008fe200078e00ffULL, 0x00000018ff047819ULL, 0x000fe2000001140cULL,
0x000001001bd57824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe20000011408ULL,
0x0000010009087824ULL, 0x000fe200078e00ffULL, 0x000000b200b67306ULL, 0x0002e20000205400ULL,
0x00000018ff987819ULL, 0x000fe20000011498ULL, 0x000001001ad47824ULL, 0x040fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe20000011492ULL, 0x000100001ab77824ULL, 0x000fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fe20000011408ULL, 0x000001000d087824ULL, 0x000fe200078e00ffULL,
0x0000000173734812ULL, 0x004fe200078efcffULL, 0x0000000900c07306ULL, 0x000fe20000009400ULL,
0x000000b200b27245ULL, 0x002fe2000020d400ULL, 0x0001000019d37824ULL, 0x000fe200078e00ffULL,
0x00000018ff087819ULL, 0x000fc40000011408ULL, 0x00000018ff997819ULL, 0x000fe40000011499ULL,
0x00000018ff6c7819ULL, 0x000fe20000011419ULL, 0x0000000900c17306ULL, 0x000e620000005400ULL,
0x000000b6b500720bULL, 0x008fe40003fdd000ULL, 0x000000bb00b67245ULL, 0x000fe4000020d400ULL,
0x00000018ff867819ULL, 0x000fe4000001140eULL, 0x00000018ffd57819ULL, 0x000fe200000114d5ULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x00000018ff837819ULL, 0x000fc4000001140fULL,
0x00000018ff717819ULL, 0x000fe40000011418ULL, 0x00000018ffd47819ULL, 0x000fe400000114d4ULL,
0x00000001b2b26812ULL, 0x000fe200078efcffULL, 0x000000bb00bd7306ULL, 0x0004e20000205400ULL,
0x000000c1c000720bULL, 0x002fe40003f7d000ULL, 0x00000018ffb77819ULL, 0x000fe400000114b7ULL,
0x00000018ff5f7819ULL, 0x000fc4000001141aULL, 0x00000018ff5c7819ULL, 0x000fe2000001141bULL,
0x000000ba00be7306ULL, 0x000fe20000209400ULL, 0x000000ba00bb7245ULL, 0x004fe4000020d400ULL,
0x00000018ffd37819ULL, 0x000fe400000114d3ULL, 0x00000073b2b2723eULL, 0x000fe400000010ffULL,
0x00000018ff497819ULL, 0x010fe2000001141cULL, 0x000000ba00bf7306ULL, 0x0002a20000205400ULL,
0x000000bdbc00720bULL, 0x008fc40003f3d000ULL, 0x00000018ff217819ULL, 0x000fe4000001141dULL,
0x00000018ff037819ULL, 0x000fe4000001141fULL, 0x00000018ff147819ULL, 0x000fe2000001141eULL,
0x000000c200c37306ULL, 0x000fe20000209400ULL, 0x00000018ffba7819ULL, 0x002fca00000114d2ULL,
0x00000001b6b61812ULL, 0x000fe400078efcffULL, 0x000000c200c47306ULL, 0x000e620000205400ULL,
0x000000bfbe00720bULL, 0x004fce0003f5d000ULL, 0x0000000900727306ULL, 0x0004ec000000d400ULL,
0x00000001bbbb2812ULL, 0x000fe400078efcffULL, 0x000000a200a67306ULL, 0x000fe20000209400ULL,
0x0001000009097824ULL, 0x004fe200078e00ffULL, 0x000000c4c300720bULL, 0x002fc80003fdd000ULL,
0x00000018ffc57819ULL, 0x000fe20000011409ULL, 0x000001000c097824ULL, 0x000fe200078e00ffULL,
0x000000a200a57306ULL, 0x000e620000205400ULL, 0x0000000172723812ULL, 0x008fc600078efcffULL,
0x00000018ff097819ULL, 0x000fc80000011409ULL, 0x000000a800ce7306ULL, 0x000ff00000209400ULL,
0x000000a800cf7306ULL, 0x0004e20000205400ULL, 0x000000a5a600720bULL, 0x002fe40003f3d000ULL,
0x000000c200a57245ULL, 0x000fc8000020d400ULL, 0x00000001a5a56812ULL, 0x000fe200078efcffULL,
0x0000000b00a37306ULL, 0x000fe20000009400ULL, 0x000000a800a87245ULL, 0x004fce000020d400ULL,
0x0000000b00a47306ULL, 0x000e620000005400ULL, 0x000000cfce00720bULL, 0x008fce0003f7d000ULL,
0x000000ad00ca7306ULL, 0x000fec0000209400ULL, 0x00000001a8a83812ULL, 0x000fe400078efcffULL,
0x000000ad00cb7306ULL, 0x0004e20000205400ULL, 0x000000a4a300720bULL, 0x002fe40003f5d000ULL,
0x000000a200a47245ULL, 0x000fc4000020d400ULL, 0x000000c500a37245ULL, 0x000fe4000020d400ULL,
0x00000001a4a41812ULL, 0x000fe200078efcffULL, 0x0000000a00c87306ULL, 0x000fe20000009400ULL,
0x000000ad00ad7245ULL, 0x004fe4000020d400ULL, 0x000000b6bba2723eULL, 0x000fca00000010ffULL,
0x0000000a00c97306ULL, 0x000e620000005400ULL, 0x000000cbca00720bULL, 0x008fce0003fdd000ULL,
0x000000a900d07306ULL, 0x000fec0000209400ULL, 0x00000001adad6812ULL, 0x000fe400078efcffULL,
0x000000a900d17306ULL, 0x0004e20000205400ULL, 0x000000c9c800720bULL, 0x002fce0003fbd000ULL,
0x0000000b00677306ULL, 0x000e62000000d400ULL, 0x000000a900a97245ULL, 0x004fce000020d400ULL,
0x0000009100977306ULL, 0x000fe20000209400ULL, 0x000000d1d000720bULL, 0x008fce0003f7d000ULL,
0x0000009100947306ULL, 0x0004e20000205400ULL, 0x0000000167672812ULL, 0x002fca00078efcffULL,
0x00000001a9a93812ULL, 0x000fe400078efcffULL, 0x0000000900b97306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x004fce000020d400ULL, 0x0000000900b87306ULL, 0x000e620000205400ULL,
0x000000949700720bULL, 0x008fce0003fdd000ULL, 0x000000ac00cc7306ULL, 0x000fec0000209400ULL,
0x0000000191916812ULL, 0x000fe400078efcffULL, 0x000000ac00cd7306ULL, 0x0004e20000205400ULL,
0x000000b8b900720bULL, 0x002fce0003f5d000ULL, 0x0000000a006a7306ULL, 0x000e62000000d400ULL,
0x000000ac00ac7245ULL, 0x004fce000020d400ULL, 0x0000000e008e7306ULL, 0x000fe20000009400ULL,
0x000000cdcc00720bULL, 0x008fce0003f3d000ULL, 0x0000000e008b7306ULL, 0x000ea20000005400ULL,
0x000000016a6a5812ULL, 0x002fc800078efcffULL, 0x0000006aad6a723eULL, 0x000fe400000010ffULL,
0x00000001acac1812ULL, 0x000fe200078efcffULL, 0x0000008d00957306ULL, 0x000fe60000209400ULL,
0x000000ac91ac723eULL, 0x000fca00000010ffULL, 0x0000008d00967306ULL, 0x000e620000205400ULL,
0x0000008b8e00720bULL, 0x004fe40003f7d000ULL, 0x00000009008b7245ULL, 0x000fe4000020d400ULL,
0x00000008008e7245ULL, 0x000fe4000020d400ULL, 0x000000018b8b2812ULL, 0x000fe200078efcffULL,
0x000000c500c67306ULL, 0x000ff00000209400ULL, 0x000000c500c77306ULL, 0x000ea20000205400ULL,
0x000000969500720bULL, 0x002fce0003fbd000ULL, 0x0000000800af7306ULL, 0x000ff00000209400ULL,
0x0000000800b07306ULL, 0x000e620000205400ULL, 0x000000c7c600720bULL, 0x004fce0003f9d000ULL,
0x000000ab00ae7306ULL, 0x000fec0000209400ULL, 0x00000001a3a34812ULL, 0x000fe400078efcffULL,
0x000000ab00b37306ULL, 0x0004e20000205400ULL, 0x000000b0af00720bULL, 0x002fe40003fdd000ULL,
0x000000a3a4a3723eULL, 0x000fca00000010ffULL, 0x0000000d00907306ULL, 0x000fe20000009400ULL,
0x000000ab00ab7245ULL, 0x004fca000020d400ULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x0000000d008f7306ULL, 0x000e620000005400ULL, 0x000000b3ae00720bULL, 0x008fe40003f5d000ULL,
0x00000072a5b3723eULL, 0x000fca00000010ffULL, 0x0000000f00067306ULL, 0x000fec0000009400ULL,
0x00000001abab2812ULL, 0x000fe400078efcffULL, 0x0000000f00057306ULL, 0x000ea20000005400ULL,
0x0000008f9000720bULL, 0x002fe40003f3d000ULL, 0x0000008d00907245ULL, 0x000fc8000020d400ULL,
0x0000000190905812ULL, 0x000fe200078efcffULL, 0x0000000c00a17306ULL, 0x000fe60000009400ULL,
0x000000a990ad723eULL, 0x000fca00000010ffULL, 0x0000000c009e7306ULL, 0x000e620000005400ULL,
0x000000050600720bULL, 0x004fe40003fbd000ULL, 0x0000b80000057811ULL, 0x000fe400078e20ffULL,
0x0000000400007245ULL, 0x000fc6000020d400ULL, 0x00000074008a7306ULL, 0x000ff00000209400ULL,
0x0000007400077306ULL, 0x000ea20000205400ULL, 0x0000009ea100720bULL, 0x002fce0003f9d000ULL,
0x00000093000b7306ULL, 0x000ff00000209400ULL, 0x00000093000a7306ULL, 0x0002e20000205400ULL,
0x000000078a00720bULL, 0x004fce0003fdd000ULL, 0x0000000c00627306ULL, 0x000522000000d400ULL,
0x0000009300937245ULL, 0x002fce000020d400ULL, 0x00000004008c7306ULL, 0x000fe20000209400ULL,
0x0000000a0b00720bULL, 0x008fe20003f5d000ULL, 0x00000100190c7824ULL, 0x004fe200078e00ffULL,
0x000000000208783bULL, 0x0002a80000000200ULL, 0x00000018ffaa7819ULL, 0x000fe2000001140cULL,
0x0000000400897306ULL, 0x0007620000205400ULL, 0x0000000162624812ULL, 0x010fe200078efcffULL,
0x000001001f0c7824ULL, 0x000fe200078e00ffULL, 0x0000008300027245ULL, 0x002fc4000020d400ULL,
0x000000628b62723eULL, 0x000fe400000010ffULL, 0x0000000193932812ULL, 0x000fe200078efcffULL,
0x0000000f00577306ULL, 0x000e62000000d400ULL, 0x000000000504783bULL, 0x008eee0000000200ULL,
0x0000001900887306ULL, 0x000fe20000009400ULL, 0x000000898c00720bULL, 0x020fc40003f9d000ULL,
0x0000007400897245ULL, 0x000fc8000020d400ULL, 0x0000000189896812ULL, 0x000fe200078efcffULL,
0x00000019007f7306ULL, 0x000f220000005400ULL, 0x0000000157575812ULL, 0x002fca00078efcffULL,
0x0000000100004812ULL, 0x000fe400078efcffULL, 0x0000000d00657306ULL, 0x000362000000d400ULL,
0x0000006908088231ULL, 0x084fe400003400ffULL, 0x000000690a0a8231ULL, 0x000fe400003400ffULL,
0x0000006409098231ULL, 0x000fc600003400ffULL, 0x0000009800b17306ULL, 0x000fe20000209400ULL,
0x0000007f8800720bULL, 0x010fe20003fbd000ULL, 0x000000640b0b8231ULL, 0x000fe200003400ffULL,
0x000001001e0d7824ULL, 0x002fca00078e00ffULL, 0x0000009800b47306ULL, 0x0002a20000205400ULL,
0x0000000165651812ULL, 0x020fe200078efcffULL, 0x0000006904048231ULL, 0x088fe200003400ffULL,
0x000000b20810723cULL, 0x040fe20000041810ULL, 0x0000006906068231ULL, 0x000fe400003400ffULL,
0x0000006405058231ULL, 0x080fe400003400ffULL, 0x00000092009a7306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fe2000020d400ULL, 0x0000006407078231ULL, 0x000fe200003400ffULL,
0x000000a20830723cULL, 0x000fea0000041830ULL, 0x00000092009d7306ULL, 0x0002e20000205400ULL,
0x000000b4b100720bULL, 0x004fc40003f3d000ULL, 0x000000ac0838723cULL, 0x000fea0000041838ULL,
0x00000099009b7306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x002fca000020d400ULL,
0x0000000198981812ULL, 0x000fe400078efcffULL, 0x00000099009c7306ULL, 0x0002a20000205400ULL,
0x0000009d9a00720bULL, 0x008fce0003f9d000ULL, 0x0000000e005e7306ULL, 0x000722000000d400ULL,
0x0000009900997245ULL, 0x002fca000020d400ULL, 0x0000000192924812ULL, 0x000fe400078efcffULL,
0x00000019004e7306ULL, 0x000362000000d400ULL, 0x000100000f0e7824ULL, 0x008fe200078e00ffULL,
0x0000009c9b00720bULL, 0x004fe20003fdd000ULL, 0x00000100180f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x0000006c00817306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x000001001c197824ULL, 0x002fe200078e00ffULL,
0x000000015e5e3812ULL, 0x010fc800078efcffULL, 0x0000000199996812ULL, 0x000fe200078efcffULL,
0x0000006c007c7306ULL, 0x0002a20000205400ULL, 0x000000014e4e5812ULL, 0x020fce00078efcffULL,
0x0000001800757306ULL, 0x000fe20000009400ULL, 0x0000006c006c7245ULL, 0x002fce000020d400ULL,
0x00000018007a7306ULL, 0x000e620000005400ULL, 0x0000007c8100720bULL, 0x004fce0003fbd000ULL,
0x0000000e009f7306ULL, 0x000fec0000209400ULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x0000000e00a07306ULL, 0x000ea20000205400ULL, 0x0000007a7500720bULL, 0x002fce0003f3d000ULL,
0x00000086007d7306ULL, 0x000ff00000209400ULL, 0x0000008600827306ULL, 0x0002e20000205400ULL,
0x000000a09f00720bULL, 0x004fce0003f9d000ULL, 0x0000001a00857306ULL, 0x000fe20000009400ULL,
0x0000008600867245ULL, 0x002fce000020d400ULL, 0x0000001a00787306ULL, 0x000e620000005400ULL,
0x000000827d00720bULL, 0x008fce0003f5d000ULL, 0x000000ba00a67306ULL, 0x000fec0000209400ULL,
0x0000000186862812ULL, 0x000fe400078efcffULL, 0x000000ba00bd7306ULL, 0x0004e20000205400ULL,
0x000000788500720bULL, 0x002fe40003fdd000ULL, 0x00000018ff787819ULL, 0x000fc40000011419ULL,
0x000000aa00197245ULL, 0x000fe4000020d400ULL, 0x000000998686723eULL, 0x000fe200000010ffULL,
0x000000d5008c7306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x004fce000020d400ULL,
0x000000d5008d7306ULL, 0x0002a20000205400ULL, 0x000000bda600720bULL, 0x008fce0003f1d000ULL,
0x0000008300877306ULL, 0x000fe20000209400ULL, 0x000000d500d57245ULL, 0x002fca000020d400ULL,
0x00000001baba0812ULL, 0x000fe400078efcffULL, 0x00000083007e7306ULL, 0x000e620000205400ULL,
0x0000008d8c00720bULL, 0x004fce0003fbd000ULL, 0x00000018004f7306ULL, 0x000eac000000d400ULL,
0x00000001d5d55812ULL, 0x000fe400078efcffULL, 0x0000007100777306ULL, 0x000fe20000209400ULL,
0x0000007e8700720bULL, 0x002fe40003f7d000ULL, 0x0000000e00877245ULL, 0x000fc4000020d400ULL,
0x000000ab000e723eULL, 0x000fe400000010ffULL, 0x0000000187874812ULL, 0x000fe200078efcffULL,
0x0000007100767306ULL, 0x0002e20000205400ULL, 0x000000014f4f1812ULL, 0x004fe400078efcffULL,
0x0000005f00007245ULL, 0x000fc6000020d400ULL, 0x0000000102023812ULL, 0x000fe400078efcffULL,
0x0000000f00187306ULL, 0x000fe20000209400ULL, 0x0000007100717245ULL, 0x002fe4000020d400ULL,
0x000000870287723eULL, 0x000fca00000010ffULL, 0x0000000f00a77306ULL, 0x000e620000205400ULL,
0x000000767700720bULL, 0x008fe20003f3d000ULL, 0x00000086083c723cULL, 0x000fec000004183cULL,
0x0000001a004d7306ULL, 0x0004ec000000d400ULL, 0x0000000171711812ULL, 0x000fc400078efcffULL,
0x0000001b00807306ULL, 0x000fe20000009400ULL, 0x000000a71800720bULL, 0x002fe20003f9d000ULL,
0x000001001d1a7824ULL, 0x004fe200078e00ffULL, 0x0000000f00187245ULL, 0x000fe4000020d400ULL,
0x00000098890f723eULL, 0x000fe400000010ffULL, 0x00000018ff647819ULL, 0x000fe2000001141aULL,
0x0000001b00797306ULL, 0x000e620000005400ULL, 0x000000014d4d6812ULL, 0x008fc600078efcffULL,
0x0000000e0840723cULL, 0x000fe40000041840ULL, 0x0000000118184812ULL, 0x000fe400078efcffULL,
0x000000d4008f7306ULL, 0x000fe40000209400ULL, 0x0000004f1818723eULL, 0x000fcc00000010ffULL,
0x000000d400947306ULL, 0x0004e20000205400ULL, 0x000000798000720bULL, 0x002fce0003f5d000ULL,
0x000000b7008a7306ULL, 0x000fe20000209400ULL, 0x000000d400d47245ULL, 0x004fce000020d400ULL,
0x000000b700757306ULL, 0x0002a20000205400ULL, 0x000000948f00720bULL, 0x008fce0003f1d000ULL,
0x0000005f00667306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fca000020d400ULL,
0x00000001d4d40812ULL, 0x000fe400078efcffULL, 0x0000005f00637306ULL, 0x0002e20000205400ULL,
0x000000758a00720bULL, 0x004fce0003fdd000ULL, 0x0000001b00487306ULL, 0x000522000000d400ULL,
0x00000018ff5f7819ULL, 0x002fe4000001140cULL, 0x0000005e930c723eULL, 0x000fc600000010ffULL,
0x00000001b7b76812ULL, 0x000fe400078efcffULL, 0x000000aa00b57306ULL, 0x000fe20000209400ULL,
0x000100001b1b7824ULL, 0x004fe200078e00ffULL, 0x000000636600720bULL, 0x008fe40003fbd000ULL,
0x00000018ff667819ULL, 0x000fe4000001140dULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x000000aa00bc7306ULL, 0x000e620000205400ULL, 0x0000000148482812ULL, 0x010fc400078efcffULL,
0x000000658e63723eULL, 0x000fe400000010ffULL, 0x00000057920d723eULL, 0x000fe400000010ffULL,
0x0000000100005812ULL, 0x000fe200078efcffULL, 0x0000001c00847306ULL, 0x000fe40000009400ULL,
0x000000620844723cULL, 0x040fec0000041844ULL, 0x0000001c007b7306ULL, 0x000ea20000005400ULL,
0x000000bcb500720bULL, 0x002fe20003f7d000ULL, 0x0000000c080c723cULL, 0x000fec0000041850ULL,
0x0000001d006e7306ULL, 0x000fe20000009400ULL, 0x000000ba7150723eULL, 0x000fca00000010ffULL,
0x0000000119193812ULL, 0x000fe400078efcffULL, 0x0000001d006d7306ULL, 0x000e620000005400ULL,
0x0000007b8400720bULL, 0x004fe40003f9d000ULL, 0x0000004e1919723eULL, 0x000fca00000010ffULL,
0x0000001f006b7306ULL, 0x000ff00000009400ULL, 0x0000001f00687306ULL, 0x000ea20000005400ULL,
0x0000006d6e00720bULL, 0x002fce0003f3d000ULL, 0x0000005c00607306ULL, 0x000ff00000209400ULL,
0x0000005c00617306ULL, 0x0002e20000205400ULL, 0x000000686b00720bULL, 0x004fe40003f1d000ULL,
0x00000067a86b723eULL, 0x000fca00000010ffULL, 0x0000001b00747306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x002fe2000020d400ULL, 0x0000006a0834723cULL, 0x000fec0000041834ULL,
0x0000001b007d7306ULL, 0x0002a20000205400ULL, 0x000000616000720bULL, 0x008fe40003f5d000ULL,
0x0000006400097245ULL, 0x000fc4000020d400ULL, 0x00000049000b7245ULL, 0x000fc6000020d400ULL,
0x0000001c00227306ULL, 0x000722000000d400ULL, 0x0000001b001b7245ULL, 0x002fca000020d400ULL,
0x000000015c5c2812ULL, 0x000fe400078efcffULL, 0x0000007800797306ULL, 0x000fe20000209400ULL,
0x000100001c1c7824ULL, 0x008fe200078e00ffULL, 0x0000007d7400720bULL, 0x004fc80003fdd000ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000078007a7306ULL, 0x000e620000205400ULL,
0x0000000122224812ULL, 0x010fcc00078efcffULL, 0x000000011b1b6812ULL, 0x000fe200078efcffULL,
0x000000d3009e7306ULL, 0x000ff00000209400ULL, 0x000000d300957306ULL, 0x0004e20000205400ULL,
0x0000007a7900720bULL, 0x002fce0003fbd000ULL, 0x0000001d00207306ULL, 0x000322000000d400ULL,
0x000000d300d37245ULL, 0x004fce000020d400ULL, 0x0000001c001a7306ULL, 0x000fe20000209400ULL,
0x000100001d1d7824ULL, 0x002fe200078e00ffULL, 0x000000959e00720bULL, 0x008fc80003f7d000ULL,
0x00000018ff6d7819ULL, 0x000fe4000001141dULL, 0x0000001c00697306ULL, 0x0002a20000205400ULL,
0x00000078001d7245ULL, 0x000fe4000020d400ULL, 0x0000000120201812ULL, 0x010fe400078efcffULL,
0x000000011d1d5812ULL, 0x000fe400078efcffULL, 0x00000001d3d33812ULL, 0x000fe200078efcffULL,
0x0000004900567306ULL, 0x000fe20000209400ULL, 0x0000001c001c7245ULL, 0x002fc4000020d400ULL,
0x000000221d08723eULL, 0x000fe400000010ffULL, 0x000000d36c51723eULL, 0x000fc600000010ffULL,
0x00000049005d7306ULL, 0x000e620000205400ULL, 0x000000691a00720bULL, 0x004fc60003f9d000ULL,
0x000000500450723cULL, 0x000fe80000041830ULL, 0x0000002100547306ULL, 0x000fec0000209400ULL,
0x000000011c1c4812ULL, 0x000fc400078efcffULL, 0x0000002100557306ULL, 0x000ea20000205400ULL,
0x0000005d5600720bULL, 0x002fce0003fdd000ULL, 0x00000064007b7306ULL, 0x000fec0000209400ULL,
0x000000010b0b6812ULL, 0x000fe400078efcffULL, 0x0000006400767306ULL, 0x000e620000205400ULL,
0x000000555400720bULL, 0x004fe40003f5d000ULL, 0x000000180454723cULL, 0x000fe20000041810ULL,
0x0000001c0b1c723eULL, 0x000fc800000010ffULL, 0x0000001e006f7306ULL, 0x000ff00000009400ULL,
0x0000001e00707306ULL, 0x000ea20000005400ULL, 0x000000767b00720bULL, 0x002fce0003fbd000ULL,
0x0000006d00687306ULL, 0x000fec0000209400ULL, 0x0000000109095812ULL, 0x000fe400078efcffULL,
0x0000006d00677306ULL, 0x0002e20000205400ULL, 0x000000706f00720bULL, 0x004fe40003f7d000ULL,
0x000000200909723eULL, 0x000fca00000010ffULL, 0x0000001e00177306ULL, 0x000522000000d400ULL,
0x0000006d006d7245ULL, 0x002fe2000020d400ULL, 0x000000080444723cULL, 0x000fec0000041844ULL,
0x0000001f00167306ULL, 0x000362000000d400ULL, 0x000100001e1e7824ULL, 0x004fe200078e00ffULL,
0x000000676800720bULL, 0x008fc40003f3d000ULL, 0x0000001400097245ULL, 0x000fe4000020d400ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000003002f7306ULL, 0x000fe20000209400ULL,
0x000100001f1f7824ULL, 0x002fe200078e00ffULL, 0x0000000117173812ULL, 0x010fc800078efcffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000003004a7306ULL, 0x000e620000205400ULL,
0x000000016d6d1812ULL, 0x000fe400078efcffULL, 0x0000000116160812ULL, 0x020fca00078efcffULL,
0x00000014004c7306ULL, 0x000ff00000209400ULL, 0x00000014004b7306ULL, 0x000ea20000205400ULL,
0x0000004a2f00720bULL, 0x002fe40003f9d000ULL, 0x000000b7004a723eULL, 0x000fc400000010ffULL,
0x0000002100007245ULL, 0x000fc6000020d400ULL, 0x0000006600657306ULL, 0x000fe20000209400ULL,
0x0000000100002812ULL, 0x000fc800078efcffULL, 0x0000006d001d723eULL, 0x000fe400000010ffULL,
0x0000000300007245ULL, 0x000fe2000020d400ULL, 0x0000006600607306ULL, 0x0002e20000205400ULL,
0x0000004b4c00720bULL, 0x004fe40003fbd000ULL, 0x0000004dd44c723eULL, 0x000fe200000010ffULL,
0x0000001c0440723cULL, 0x000fe20000041840ULL, 0x00000048d54d723eULL, 0x000fe400000010ffULL,
0x0000000100004812ULL, 0x000fe200078efcffULL, 0x0000005f005e7306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x002fc4000020d400ULL, 0x0000001b5c4b723eULL, 0x000fe200000010ffULL,
0x0000004c044c723cULL, 0x040fe40000041834ULL, 0x0000000109095812ULL, 0x000fe400078efcffULL,
0x0000005f00617306ULL, 0x000e620000205400ULL, 0x000000606500720bULL, 0x008fe40003fdd000ULL,
0x0000005f00357245ULL, 0x000fe2000020d400ULL, 0x0000004a0448723cULL, 0x000fe80000041838ULL,
0x0000001e00027306ULL, 0x000fec0000209400ULL, 0x0000000166666812ULL, 0x000fc400078efcffULL,
0x0000001e005d7306ULL, 0x0004e20000205400ULL, 0x000000615e00720bULL, 0x002fe40003f3d000ULL,
0x000000176634723eULL, 0x000fca00000010ffULL, 0x0000001f000a7306ULL, 0x000fe20000209400ULL,
0x0000001e001e7245ULL, 0x004fca000020d400ULL, 0x0000000135351812ULL, 0x000fe400078efcffULL,
0x0000001f00117306ULL, 0x0002a20000205400ULL, 0x0000005d0200720bULL, 0x008fe40003f5d000ULL,
0x000000163535723eULL, 0x000fe400000010ffULL, 0x0000001f001f7245ULL, 0x002fca000020d400ULL,
0x000000340434723cULL, 0x000fe8000004180cULL, 0x000000011e1e2812ULL, 0x000fe400078efcffULL,
0x000000110a00720bULL, 0x004fe40003f7d000ULL, 0x0000001e091e723eULL, 0x000fd600000010ffULL,
0x000000011f1f3812ULL, 0x000fc800078efcffULL, 0x0000001f001f723eULL, 0x000fce00000010ffULL,
0x0000001e0438723cULL, 0x000fe2000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff027f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff317224ULL, 0x002fc600078e0003ULL, 0x000003002b2b7a10ULL, 0x000fc80007ffe0ffULL,
0x000000292b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffebcc000007947ULL, 0x000fea000383ffffULL, 0x00000000000e7919ULL, 0x000ee40000002500ULL,
0x000000290e00720cULL, 0x008fda0003f06070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff337224ULL, 0x000fe200078e0024ULL,
0x0001528000047802ULL, 0x004fe40000000f00ULL, 0x0000a41000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002400037308ULL, 0x002e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000024ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ee8000c1e9900ULL,
0x0000000000057919ULL, 0x004ea40000000000ULL, 0x00000002ff077819ULL, 0x004fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x008fca0000410000ULL,
0x00001f0700047589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000005404547220ULL, 0x044fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000004c044c7220ULL, 0x040fe20000410000ULL, 0x0000004d044d7220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004004407220ULL, 0x040fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x000fe20000410000ULL,
0x0000005605567220ULL, 0x048fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000004e054e7220ULL, 0x040fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000004a054a7220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000004605467220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x00000300ff127624ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x000000011200780cULL, 0x000fe40003f05270ULL,
0x0000000203007812ULL, 0x002fe400078ec0ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011603ULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000200047811ULL, 0x004fc400078ff8ffULL,
0x0000000400067811ULL, 0x040fe400078ff8ffULL, 0x00000006000a7811ULL, 0x000fe400078ff8ffULL,
0x0000000803177811ULL, 0x000fe400078ff0ffULL, 0x0000000702007812ULL, 0x100fe400078e780fULL,
0x0000000706087812ULL, 0x040fe400078e780fULL, 0x0000000706067812ULL, 0x100fe200078e7817ULL,
0x000000080f077824ULL, 0x000fe200078e0200ULL, 0x0000000702027812ULL, 0x000fe200078e7817ULL,
0x000008002e007824ULL, 0x000fe200078e00ffULL, 0x0000000704057812ULL, 0x100fe200078e780fULL,
0x0000000817157824ULL, 0x040fe200078e0206ULL, 0x000000070a0c7812ULL, 0x000fe200078e780fULL,
0x0000000817117824ULL, 0x000fe200078e0202ULL, 0x0000000704047812ULL, 0x100fe200078e7817ULL,
0x0000000803067824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7812ULL, 0x000fe200078e7817ULL,
0x000000080f097824ULL, 0x040fe200078e0205ULL, 0x0000a00000027810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0b7824ULL, 0x000fe200078e0208ULL, 0x0000000806067812ULL, 0x000fe200078ec0ffULL,
0x0000000817137824ULL, 0x000fe200078e0204ULL, 0x000000545504723eULL, 0x000fe200000010ffULL,
0x000000080f0f7824ULL, 0x000fe200078e020cULL, 0x000000505105723eULL, 0x000fe200000010ffULL,
0x0000000817177824ULL, 0x000fe200078e020aULL, 0x000000565708723eULL, 0x000fe200000010ffULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x0000541004187816ULL, 0x140fe20000000005ULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0x0000763204197816ULL, 0x000fe20000000005ULL,
0x000000100b0d7824ULL, 0x100fe200078e0202ULL, 0x000000444504723eULL, 0x000fe200000010ffULL,
0x0000001011117824ULL, 0x100fe200078e0202ULL, 0x000000404105723eULL, 0x000fe200000010ffULL,
0x0000001013137824ULL, 0x000fc400078e0202ULL, 0x000000100f0f7824ULL, 0x100fe400078e0202ULL,
0x0000001015157824ULL, 0x100fe400078e0202ULL, 0x0000001017177824ULL, 0x000fe400078e0202ULL,
0x00000001070a7824ULL, 0x000fe200078e0206ULL, 0x000000484907723eULL, 0x000fe200000010ffULL,
0x00000001060b7824ULL, 0x040fe200078e0209ULL, 0x000000525309723eULL, 0x000fe200000010ffULL,
0x00000001060d7824ULL, 0x040fe200078e020dULL, 0x000000180a007388ULL, 0x0003e20000000a00ULL,
0x0000000106117824ULL, 0x000fc400078e0211ULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x00000001060f7824ULL, 0x040fe400078e020fULL, 0x0000000106157824ULL, 0x040fe400078e0215ULL,
0x0000000106177824ULL, 0x000fe200078e0217ULL, 0x0000004c4d06723eULL, 0x000fe400000010ffULL,
0x00005410040a7816ULL, 0x002fe40000000005ULL, 0x0000541006187816ULL, 0x000fc40000000007ULL,
0x0000763206197816ULL, 0x000fe40000000007ULL, 0x000000343506723eULL, 0x000fe400000010ffULL,
0x000000383907723eULL, 0x000fe200000010ffULL, 0x000000180b007388ULL, 0x0003e40000000a00ULL,
0x00007632040b7816ULL, 0x002fe40000000005ULL, 0x0000004e4f04723eULL, 0x000fe400000010ffULL,
0x0000004a4b05723eULL, 0x000fe200000010ffULL, 0x0000000a0d007388ULL, 0x0003e40000000a00ULL,
0x00005410060a7816ULL, 0x002fc40000000007ULL, 0x00007632060b7816ULL, 0x000fe40000000007ULL,
0x000000464706723eULL, 0x000fe400000010ffULL, 0x000000424307723eULL, 0x000fe200000010ffULL,
0x0000000a0f007388ULL, 0x0003e40000000a00ULL, 0x00005410080a7816ULL, 0x142fe40000000009ULL,
0x00007632080b7816ULL, 0x000fe40000000009ULL, 0x000000363708723eULL, 0x000fc400000010ffULL,
0x0000003a3b09723eULL, 0x000fe200000010ffULL, 0x0000000a11007388ULL, 0x0003e40000000a00ULL,
0x00005410040a7816ULL, 0x142fe40000000005ULL, 0x00007632040b7816ULL, 0x000fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x0000000a13007388ULL, 0x0003e20000000a00ULL, 0x0000541008067816ULL, 0x000fc40000000009ULL,
0x0000763208077816ULL, 0x000fe20000000009ULL, 0x0000000415007388ULL, 0x0003e80000000a00ULL,
0x0000000617007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002b6000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x000ea20000002700ULL,
0x0000001003097824ULL, 0x040fe200078e0200ULL, 0x000000ff2e00720cULL, 0x000fe20003f05270ULL,
0x0000580012047a24ULL, 0x002fe200078e02ffULL, 0x0000000000057919ULL, 0x000ea20000002600ULL,
0x00001000ff077424ULL, 0x000fe200078e00ffULL, 0x00000020030f7810ULL, 0x040fe20007ffe0ffULL,
0x0000660004087a24ULL, 0x000fe200078e02ffULL, 0x00a0000009147984ULL, 0x0002e20000000c00ULL,
0x000000ff0300720cULL, 0x000fc60000725670ULL, 0x00a2000009187984ULL, 0x0003220000000c00ULL,
0x0000580010107a24ULL, 0x004fe200078e0205ULL, 0x00000fff08057811ULL, 0x000fc600078e40ffULL,
0x0000030010047a24ULL, 0x000fc800078e02ffULL, 0x00000001040a7824ULL, 0x000fca00078e020eULL,
0x0000000a05067211ULL, 0x000fca00078fa0ffULL, 0x00006c0006067625ULL, 0x000fcc00078e0007ULL,
0x000004002e067825ULL, 0x000fcc00078e0006ULL, 0x000000100f0e7825ULL, 0x000fc800078e0006ULL,
0x00000010030c7825ULL, 0x000fe200078e0006ULL, 0x01ffffff08077812ULL, 0x000fe200078ec0ffULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x01afe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff067424ULL, 0x000fe400078e00ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0207ULL, 0x0000007008117812ULL, 0x000fe400078ec0ffULL,
0x0000000c09137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a087625ULL, 0x000fc800078e0006ULL,
0x00006c000b0a7625ULL, 0x000fe200078e0006ULL, 0x0000000813087210ULL, 0x000fc80007b5e011ULL,
0x0000000a130a7210ULL, 0x000fe40007d9e011ULL, 0x00000009ff097210ULL, 0x000fe400017e64ffULL,
0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL, 0x0000002508007986ULL, 0x0003e8000c101906ULL,
0x000000240a007986ULL, 0x0003e4000c101906ULL, 0x000000140c007986ULL, 0x01a3e2000c101d06ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x000000180e007986ULL, 0x0003e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0xffffffff120b7810ULL, 0x000fc60007ffe0ffULL,
0x00006a0010087625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL,
0x0000000b0800720cULL, 0x004fe20003f25270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff067807ULL, 0x000fca0000800000ULL, 0x00000006ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x004ea40000000000ULL, 0x000000ff0600720cULL, 0x004fda0003f25270ULL,
0x000027a000009947ULL, 0x000fea0003800000ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff087819ULL, 0x000fe20000011603ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001040a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff177424ULL, 0x002fe200078e00ffULL,
0x0000000c080c7812ULL, 0x000fe400078ec0ffULL, 0x0000007006197812ULL, 0x000fe200078ec0ffULL,
0x00006c0004087625ULL, 0x000fc800078e0017ULL, 0x00006c000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x0000000a0c0a7210ULL, 0x000fe40007b5e019ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x0000000608067981ULL, 0x000368000c1e1900ULL, 0x000000060a0d7981ULL, 0x000362000c1e1900ULL,
0x000000021200780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000204087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000304087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000362000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000404087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608137981ULL, 0x000362000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000504087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608157981ULL, 0x000362000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081200780cULL, 0x002fe40003f06070ULL, 0x0000000604087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fe40007a3e019ULL,
0x00000007040a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000a0a0625ULL, 0x000fe400078e0017ULL, 0x0000000608177981ULL, 0x000366000c1e1900ULL,
0x0000000a0c0a0210ULL, 0x000fc80007c7e019ULL, 0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL,
0x000000060a0b0981ULL, 0x000366000c1e1900ULL, 0x0000000712087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc80000011608ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x020fe400078e0006ULL, 0x00000008190c7824ULL, 0x040fe200078e00ffULL,
0x0000000119197810ULL, 0x000fc80007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x0000000a1900720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080c097810ULL, 0x040fe40007ffe0ffULL, 0x000000010c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001b06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e1b7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e01bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081b7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090c097810ULL, 0x042fe40007ffe0ffULL,
0x000000020c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000d06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000030c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000f06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000040c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001106067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e117812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000050c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001306067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e137812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000060c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001506067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e157812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608157981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000070c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001706067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e177812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e017ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608177981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0c097810ULL, 0x002fe40007ffe0ffULL,
0x0000000b06067209ULL, 0x000fe40007810000ULL, 0x0000030009007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000080c087210ULL, 0x000fc80007a3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080b7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003087824ULL, 0x006fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011603ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000108097824ULL, 0x000fca00078e0209ULL,
0x0000000609007388ULL, 0x0203e40000000800ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000405087211ULL, 0x000fe200078fa0ffULL,
0x00001000ff097424ULL, 0x002fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011603ULL,
0x000004002e3d7824ULL, 0x000fe200078e00ffULL, 0x00000016ff3f7819ULL, 0x000fe2000001162eULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000020030d7810ULL, 0x040fe20007ffe0ffULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x0000003d08087210ULL, 0x000fe20007f3e0ffULL,
0x00000001040e8824ULL, 0x000fe200078e0207ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200008e063fULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x000010002e207824ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00006c000e0e8625ULL, 0x000fe200078e000fULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000102e158824ULL, 0x000fc400078e0203ULL, 0x00006c0004108625ULL, 0x000fc600078e0011ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x0000000106177824ULL, 0x000fe400078e020bULL,
0x000000102e198824ULL, 0x000fe400078e0203ULL, 0x0000001003137824ULL, 0x040fe400078e0220ULL,
0x00000010030a7825ULL, 0x100fe200078e0008ULL, 0x0000418019198811ULL, 0x000fe200078e20ffULL,
0x0000000017177984ULL, 0x000e640000000800ULL, 0x000000100d0c7825ULL, 0x000fc400078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0005e2000b901c46ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000010030e8825ULL, 0x040fe400078e000eULL,
0x003800000c137faeULL, 0x0007e4000b901c46ULL, 0x0000001003108825ULL, 0x000fe400078e0010ULL,
0x000000000e158faeULL, 0x0009e4000b901c46ULL, 0x000000ffff067224ULL, 0x000fc400078e00ffULL,
0x0000000010198faeULL, 0x000be2000b901c46ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x004fe2000001ff00ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff2f7224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x010fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x020fe2000001ff00ULL,
0x00000d0000009947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fca00078e00ffULL, 0x0000000134357810ULL, 0x000fc80007ffe0ffULL,
0x0000030035007a0cULL, 0x000fda0003f06070ULL, 0x0000023000000947ULL, 0x000fea0003800000ULL,
0x0000000104367824ULL, 0x000fe200078e0235ULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x00001000ff197424ULL, 0x000fe200078e00ffULL, 0x00000001351f7812ULL, 0x040fe200078ec0ffULL,
0x00000800351a7824ULL, 0x000fe200078e00ffULL, 0x0000003605187211ULL, 0x000fe400078fa0ffULL,
0x00000020033b7810ULL, 0x000fe40007ffe0ffULL, 0x000008001a1d7812ULL, 0x000fe200078ec0ffULL,
0x00006c0018187625ULL, 0x000fc800078e0019ULL, 0x00000001071b9824ULL, 0x000fe200078e0236ULL,
0x0000003d18187210ULL, 0x000fe20007f1e0ffULL, 0x00000080ff1c9424ULL, 0x000fe400078e00ffULL,
0x000000022e1e9824ULL, 0x140fe400078e021fULL, 0x000000022e389824ULL, 0x000fe400078e021fULL,
0x00006c001b1a9625ULL, 0x000fc800078e001cULL, 0x00000080ff1f9424ULL, 0x000fe400078e00ffULL,
0x00000001201c7824ULL, 0x000fe400078e021dULL, 0x0000000119197824ULL, 0x000fe400000e063fULL,
0x000000081e399824ULL, 0x000fe400078e0203ULL, 0x00006c00361e9625ULL, 0x000fc600078e001fULL,
0x0000458039399811ULL, 0x000fe200078e20ffULL, 0x0000001003377824ULL, 0x040fe400078e021cULL,
0x0000000838389824ULL, 0x000fe400078e0203ULL, 0x00000010031c9825ULL, 0x000fc800078e001aULL,
0x000000103b1a7825ULL, 0x000fe200078e0018ULL, 0x00004180383b9811ULL, 0x000fc600078e20ffULL,
0x0000001003187825ULL, 0x000fc800078e0018ULL, 0x00000010031e9825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000018377faeULL, 0x0005e8000b901c46ULL,
0x003800001a377faeULL, 0x0005e8000b901c46ULL, 0x000000001c399faeULL, 0x0005e8000b901c46ULL,
0x000000001e3b9faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0034ULL, 0x00000001ff1c7819ULL, 0x100fe20000011603ULL,
0x00000010031a7824ULL, 0x000fe200078e00ffULL, 0x00000002ff377819ULL, 0x000fe20000011603ULL,
0x000000801b187824ULL, 0x000fe200078e00ffULL, 0x0000000c1c1c7812ULL, 0x000fc400078ec0ffULL,
0x000000701a1a7812ULL, 0x000fe200078ec0ffULL, 0x00000008371f7824ULL, 0x040fe200078e00ffULL,
0x0000008018197812ULL, 0x000fe200078ec0ffULL, 0x00000008371d7824ULL, 0x040fe200078e00ffULL,
0x00000007373e7812ULL, 0x000fe400078ec0ffULL, 0x00000037ff3c7212ULL, 0x000fe200078e33ffULL,
0x000001002e197824ULL, 0x000fe200078e0219ULL, 0xfffffff81d187812ULL, 0x000fe400078ee23eULL,
0xfffffff81f3c7812ULL, 0x000fc400078ee23cULL, 0x000000191c1a7210ULL, 0x000fe20007ffe01aULL,
0x0000000837197824ULL, 0x040fe200078e00ffULL, 0x0000000837397810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180001a3a7984ULL, 0x000ea20000000800ULL,
0x00000001191c7812ULL, 0x100fe200078ef63eULL, 0x00000008391d7824ULL, 0x000fe200078e00ffULL,
0x00000002191e7812ULL, 0x140fe200078ef63eULL, 0x004580001a4c7984ULL, 0x0004e20000000800ULL,
0x0000000319347812ULL, 0x100fe200078ef63eULL, 0x0000000839407824ULL, 0x000fe200078e00ffULL,
0x0000000419367812ULL, 0x140fe400078ef63eULL, 0x0000000519387812ULL, 0x000fe400078ef63eULL,
0x00000039ff4a7212ULL, 0x000fc800078e33ffULL, 0xfffffff81d4a7812ULL, 0x000fe400078ee24aULL,
0x00000007391d7812ULL, 0x000fe200078ec0ffULL, 0x0000003a171a7221ULL, 0x006fe20000010100ULL,
0x00000006193a7812ULL, 0x000fe200078ef63eULL, 0x000008001b197824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b1a1f7820ULL, 0x000fe20000410000ULL, 0x00000004031a7824ULL, 0x000fe400078e00ffULL,
0x0000080019197812ULL, 0x000fe200078ec0ffULL, 0x00000008393e7824ULL, 0x000fc400078e00ffULL,
0x0000000c1a1b7812ULL, 0x000fe200078ec0ffULL, 0x0000001f001f7308ULL, 0x000ee20000000800ULL,
0x0000018020197810ULL, 0x000fe40007ffe019ULL, 0xfffffff8401a7812ULL, 0x100fe400078ee21dULL,
0x000000013e407812ULL, 0x000fe200078ef61dULL, 0x0000001018187824ULL, 0x000fe200078e0219ULL,
0x000000023e427812ULL, 0x000fe200078ef61dULL, 0x000000103c3c7824ULL, 0x000fe200078e0219ULL,
0x000000033e447812ULL, 0x000fe200078ef61dULL, 0x0000000118187824ULL, 0x000fe200078e021bULL,
0x000000043e467812ULL, 0x140fe200078ef61dULL, 0x000000011b3c7824ULL, 0x000fe200078e023cULL,
0x000000053e487812ULL, 0x000fe200078ef61dULL, 0x000000101c1c7824ULL, 0x000fe200078e0219ULL,
0x000000063e3e7812ULL, 0x000fe200078ef61dULL, 0x0000000018187984ULL, 0x000e620000000800ULL,
0x000000101e1e7824ULL, 0x000fe200078e0219ULL, 0x0000004c1f4c7220ULL, 0x008fe20000410000ULL,
0x000000011b1c7824ULL, 0x040fe200078e021cULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x000000011b1e7824ULL, 0x000fe200078e021eULL, 0x000000334c337221ULL, 0x000fe20000010000ULL,
0x0000001034347824ULL, 0x100fe200078e0219ULL, 0x00001f374c1d7589ULL, 0x000ea200000e0000ULL,
0x0000001036367824ULL, 0x000fc400078e0219ULL, 0x000000011b347824ULL, 0x040fe200078e0234ULL,
0x000000001c1c7984ULL, 0x000ee20000000800ULL, 0x000000011b367824ULL, 0x040fe400078e0236ULL,
0x0000001038387824ULL, 0x100fe200078e0219ULL, 0x000000001e1e7984ULL, 0x000f220000000800ULL,
0x000000103a3a7824ULL, 0x000fe400078e0219ULL, 0x000000011b387824ULL, 0x040fe200078e0238ULL,
0x0000000034347984ULL, 0x000f620000000800ULL, 0x000000011b3a7824ULL, 0x000fc400078e023aULL,
0x000000101a1a7824ULL, 0x100fe200078e0219ULL, 0x0000000036367984ULL, 0x000f620000000800ULL,
0x0000001040407824ULL, 0x100fe400078e0219ULL, 0x0000001042427824ULL, 0x100fe200078e0219ULL,
0x0000000038387984ULL, 0x000f620000000800ULL, 0x0000001044447824ULL, 0x100fe400078e0219ULL,
0x0000001046467824ULL, 0x100fe200078e0219ULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x0000001048487824ULL, 0x000fc400078e0219ULL, 0x000000103e3e7824ULL, 0x100fe200078e0219ULL,
0x00001f394c4c7589ULL, 0x000fe200000e0000ULL, 0x000000104a4a7824ULL, 0x000fe400078e0219ULL,
0x000000011b1a7824ULL, 0x040fe200078e021aULL, 0x00005410ff197816ULL, 0x002fe20000000018ULL,
0x000000011b407824ULL, 0x040fe200078e0240ULL, 0x00007610ff187816ULL, 0x000fe20000000018ULL,
0x000000011b427824ULL, 0x000fe400078e0242ULL, 0x0000001d19327223ULL, 0x084fe20000010032ULL,
0x00005410ff197816ULL, 0x100fe2000000003cULL, 0x000000001a1a7984ULL, 0x000e620000000800ULL,
0x0000001d18317223ULL, 0x080fe20000010031ULL, 0x00007610ff187816ULL, 0x000fe2000000003cULL,
0x000000011b447824ULL, 0x000fe200078e0244ULL, 0x0000001d19227223ULL, 0x080fe20000010022ULL,
0x00005410ff197816ULL, 0x108fe2000000001cULL, 0x0000000040407984ULL, 0x000ea20000000800ULL,
0x0000001d18217223ULL, 0x080fe20000010021ULL, 0x00007610ff187816ULL, 0x000fe2000000001cULL,
0x000000011b467824ULL, 0x000fe200078e0246ULL, 0x0000001d19307223ULL, 0x080fe20000010030ULL,
0x00007610ff197816ULL, 0x110fe2000000001eULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x0000001d182f7223ULL, 0x080fe2000001002fULL, 0x00005410ff187816ULL, 0x000fe2000000001eULL,
0x000000011b487824ULL, 0x000fe200078e0248ULL, 0x0000001d192c7223ULL, 0x080fe2000001002cULL,
0x00007610ff197816ULL, 0x120fe20000000034ULL, 0x0000000044447984ULL, 0x000f220000000800ULL,
0x0000001d182d7223ULL, 0x080fe2000001002dULL, 0x00005410ff187816ULL, 0x000fe20000000034ULL,
0x000000011b3e7824ULL, 0x000fe200078e023eULL, 0x0000001d192a7223ULL, 0x080fe2000001002aULL,
0x00007610ff197816ULL, 0x100fe20000000036ULL, 0x0000000046467984ULL, 0x000f620000000800ULL,
0x0000001d182b7223ULL, 0x080fe2000001002bULL, 0x00005410ff187816ULL, 0x000fe20000000036ULL,
0x000000011b4a7824ULL, 0x000fe200078e024aULL, 0x0000001d19287223ULL, 0x080fe20000010028ULL,
0x00005410ff197816ULL, 0x100fe20000000038ULL, 0x0000000048487984ULL, 0x000f620000000800ULL,
0x0000001d18297223ULL, 0x080fe20000010029ULL, 0x00007610ff187816ULL, 0x000fe20000000038ULL,
0x000000ffff347224ULL, 0x000fe200078e0035ULL, 0x0000001d19267223ULL, 0x080fe20000010026ULL,
0x00005410ff197816ULL, 0x100fe2000000003aULL, 0x000000003e3e7984ULL, 0x000f620000000800ULL,
0x0000001d18257223ULL, 0x000fe20000010025ULL, 0x00007610ff187816ULL, 0x000fc4000000003aULL,
0x0000001d19247223ULL, 0x080fe20000010024ULL, 0x00005410ff197816ULL, 0x102fe2000000001aULL,
0x000000004a4a7984ULL, 0x000e620000000800ULL, 0x0000001d18237223ULL, 0x000fe20000010023ULL,
0x00007610ff187816ULL, 0x000fe4000000001aULL, 0x0000004c19167223ULL, 0x080fe20000010016ULL,
0x00005410ff197816ULL, 0x104fe40000000040ULL, 0x0000004c18157223ULL, 0x000fe20000010015ULL,
0x00007610ff187816ULL, 0x000fc40000000040ULL, 0x0000004c19147223ULL, 0x080fe20000010014ULL,
0x00005410ff197816ULL, 0x108fe40000000042ULL, 0x0000004c18137223ULL, 0x080fe20000010013ULL,
0x00007610ff187816ULL, 0x000fe40000000042ULL, 0x0000004c19127223ULL, 0x080fe20000010012ULL,
0x00005410ff197816ULL, 0x110fe40000000044ULL, 0x0000004c18117223ULL, 0x000fe20000010011ULL,
0x00007610ff187816ULL, 0x000fc40000000044ULL, 0x0000004c19107223ULL, 0x080fe20000010010ULL,
0x00005410ff197816ULL, 0x120fe40000000046ULL, 0x0000004c180f7223ULL, 0x080fe2000001000fULL,
0x00007610ff187816ULL, 0x000fe40000000046ULL, 0x0000004c190e7223ULL, 0x080fe2000001000eULL,
0x00005410ff197816ULL, 0x100fe40000000048ULL, 0x0000030034007a0cULL, 0x000fe20003f06070ULL,
0x0000004c180d7223ULL, 0x080fe2000001000dULL, 0x00007610ff187816ULL, 0x000fe20000000048ULL,
0x0000004c190c7223ULL, 0x000fe2000001000cULL, 0x00005410ff197816ULL, 0x000fc6000000003eULL,
0x0000004c180b7223ULL, 0x080fe2000001000bULL, 0x00007610ff187816ULL, 0x000fe2000000003eULL,
0x0000004c190a7223ULL, 0x000fe2000001000aULL, 0x00005410ff197816ULL, 0x002fc6000000004aULL,
0x0000004c18097223ULL, 0x080fe40000010009ULL, 0x0000004c19087223ULL, 0x000fe20000010008ULL,
0x00007610ff197816ULL, 0x000fca000000004aULL, 0x0000004c19067223ULL, 0x000fe20000010006ULL,
0xfffff32000008947ULL, 0x000fea000383ffffULL, 0x0180000033037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00017d3000047802ULL, 0x000fe40000000f00ULL,
0x0000796000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003300047308ULL, 0x000ea40000001000ULL,
0xbf80000004037423ULL, 0x004fc80000000033ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008033b7811ULL, 0x004fe400078ff0ffULL, 0x00000002ff337819ULL, 0x002fe40000011603ULL,
0x0000003bff3d7212ULL, 0x000fe200078e33ffULL, 0x00001f3b04077589ULL, 0x000e6200000e0000ULL,
0x000000083b187824ULL, 0x000fc400078e00ffULL, 0x00000008333f7824ULL, 0x000fe200078e00ffULL,
0x00001f3304057589ULL, 0x0004e400000e0000ULL, 0xfffffff8183d7812ULL, 0x000fca00078ee23dULL,
0x000000103d3d7824ULL, 0x000fe200078e0202ULL, 0x00000033ff047212ULL, 0x004fc800078e33ffULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee204ULL, 0x0000000733047812ULL, 0x000fe200078ec0ffULL,
0x0000001607167220ULL, 0x042fe20000410000ULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x0000001407147220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001107117220ULL, 0x040fe20000410000ULL,
0x0000001007107220ULL, 0x040fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000000e070e7220ULL, 0x040fe20000410000ULL, 0x0000000d070d7220ULL, 0x040fe20000410000ULL,
0x0000000c070c7220ULL, 0x040fe20000410000ULL, 0x0000000b070b7220ULL, 0x040fe20000410000ULL,
0x0000000a070a7220ULL, 0x040fe20000410000ULL, 0x0000000907097220ULL, 0x040fe20000410000ULL,
0x0000000807087220ULL, 0x040fe20000410000ULL, 0x0000000607077220ULL, 0x000fe20000410000ULL,
0x0000000833067824ULL, 0x000fe200078e00ffULL, 0x0000000e0d0d723eULL, 0x000fe200000010ffULL,
0x0000002905297220ULL, 0x008fe20000410000ULL, 0x0000000c0b0b723eULL, 0x000fe200000010ffULL,
0x0000002805287220ULL, 0x000fe20000410000ULL, 0x0000000a0909723eULL, 0x000fe200000010ffULL,
0x0000003205327220ULL, 0x000fe20000410000ULL, 0x000000080707723eULL, 0x000fe200000010ffULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0xfffffff806177812ULL, 0x000fe200078ee233ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000000104067812ULL, 0x040fe200078e3cffULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000000204087812ULL, 0x040fe200078e3cffULL,
0x0000002d052d7220ULL, 0x040fe20000410000ULL, 0x00000003040a7812ULL, 0x040fe200078e3cffULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x00000004040c7812ULL, 0x040fe200078e3cffULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x00000005040e7812ULL, 0x040fe200078e3cffULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000000604047812ULL, 0x000fe200078e3cffULL,
0x0000002605267220ULL, 0x000fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000002505257220ULL, 0x000fe20000410000ULL, 0x000000073b127812ULL, 0x000fe200078ec0ffULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000002105057220ULL, 0x000fe20000410000ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000000833197824ULL, 0x000fe200078e0206ULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x00000008331b7824ULL, 0x040fe200078e0208ULL, 0x0000000212067812ULL, 0x040fe200078e3cffULL,
0x00000008331d7824ULL, 0x040fe200078e020aULL, 0x0000000312087812ULL, 0x040fe200078e3cffULL,
0x00000008331f7824ULL, 0x040fe200078e020cULL, 0x00000004120a7812ULL, 0x040fe200078e3cffULL,
0x0000000833297824ULL, 0x000fe200078e0204ULL, 0x0000000112047812ULL, 0x040fe200078e3cffULL,
0x000000083b147824ULL, 0x000fe200078e00ffULL, 0x00000005120c7812ULL, 0x040fe200078e3cffULL,
0x0000000833217824ULL, 0x000fe200078e020eULL, 0x00000006120e7812ULL, 0x000fe200078e3cffULL,
0x0000000403107824ULL, 0x000fe200078e00ffULL, 0x0000002d2c2c723eULL, 0x000fe200000010ffULL,
0x000000083b2d7824ULL, 0x040fe200078e0204ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x000000083b337824ULL, 0x000fe200078e0206ULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x000000083b357824ULL, 0x040fe200078e0208ULL, 0xfffffff8142b7812ULL, 0x000fe200078ee23bULL,
0x000000083b377824ULL, 0x040fe200078e020aULL, 0x0000000c10167812ULL, 0x000fe200078ec0ffULL,
0x000000083b397824ULL, 0x000fe200078e020cULL, 0x000000323131723eULL, 0x000fe200000010ffULL,
0x000000083b3b7824ULL, 0x000fe200078e020eULL, 0x000000302f2f723eULL, 0x000fe200000010ffULL,
0x0000001017177824ULL, 0x100fe200078e0202ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x0000001019197824ULL, 0x100fe200078e0202ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x000000220505723eULL, 0x000fe200000010ffULL,
0x000000101d1d7824ULL, 0x000fc400078e0202ULL, 0x000000103f067824ULL, 0x100fe400078e0202ULL,
0x000000102b2b7824ULL, 0x100fe400078e0202ULL, 0x0000000116047824ULL, 0x000fe400078e0217ULL,
0x000000101f1f7824ULL, 0x100fe400078e0202ULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x0000003104007388ULL, 0x0003e20000000800ULL, 0x0000001029297824ULL, 0x000fc400078e0202ULL,
0x000000102d2d7824ULL, 0x100fe400078e0202ULL, 0x0000001033337824ULL, 0x100fe400078e0202ULL,
0x0000001035357824ULL, 0x100fe400078e0202ULL, 0x0000001037377824ULL, 0x100fe400078e0202ULL,
0x0000001039397824ULL, 0x100fe400078e0202ULL, 0x000000103b3b7824ULL, 0x000fc400078e0202ULL,
0x0000000116027824ULL, 0x040fe400078e0219ULL, 0x00000001161b7824ULL, 0x040fe400078e021bULL,
0x00000001161d7824ULL, 0x040fe200078e021dULL, 0x0000002f02007388ULL, 0x0005e20000000800ULL,
0x00000001160a7824ULL, 0x040fe400078e0206ULL, 0x00000001161f7824ULL, 0x040fe200078e021fULL,
0x0000002c1b007388ULL, 0x0005e20000000800ULL, 0x0000000116067824ULL, 0x000fc400078e0221ULL,
0x0000000116087824ULL, 0x040fe200078e0229ULL, 0x0000002a1d007388ULL, 0x0005e20000000800ULL,
0x00000001160c7824ULL, 0x040fe400078e022bULL, 0x00000001160e7824ULL, 0x040fe200078e022dULL,
0x000000281f007388ULL, 0x0005e20000000800ULL, 0x0000000116047824ULL, 0x042fe400078e0233ULL,
0x0000000116107824ULL, 0x040fe200078e0235ULL, 0x0000002506007388ULL, 0x0005e20000000800ULL,
0x0000000116127824ULL, 0x000fc400078e0237ULL, 0x0000000116187824ULL, 0x040fe200078e023dULL,
0x0000002308007388ULL, 0x0005e20000000800ULL, 0x0000000116147824ULL, 0x040fe400078e0239ULL,
0x0000000116167824ULL, 0x000fe200078e023bULL, 0x000000050a007388ULL, 0x0005e80000000800ULL,
0x000000150c007388ULL, 0x0005e80000000800ULL, 0x000000130e007388ULL, 0x0005e80000000800ULL,
0x0000001104007388ULL, 0x0005e80000000800ULL, 0x0000000f10007388ULL, 0x0005e80000000800ULL,
0x0000000d12007388ULL, 0x0005e80000000800ULL, 0x0000000b14007388ULL, 0x0005e80000000800ULL,
0x0000000916007388ULL, 0x0005e80000000800ULL, 0x0000000718007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000002003117810ULL, 0x004fe20007ffe0ffULL,
0x0000000000107919ULL, 0x000ea20000002600ULL, 0x00000003ff027819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff067819ULL, 0x002fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000702047812ULL, 0x000fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000706077812ULL, 0x000fc400078e4811ULL,
0x0ffffff804057812ULL, 0x000fe400078ef803ULL, 0x0ffffff807077812ULL, 0x000fe400078ef811ULL,
0x0000000703127812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x100fe400078e0200ULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x0000000711007812ULL, 0x000fe400078ec0ffULL,
0x00a0000005087984ULL, 0x000e680000000c00ULL, 0x00a00000070c7984ULL, 0x0009620000000c00ULL,
0x0000000810137824ULL, 0x004fc400078e00ffULL, 0x0000000810157824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe4000f8e023fULL, 0xfffffff813027812ULL, 0x000fe400078ee202ULL,
0xfffffff815067812ULL, 0x000fe400078ee206ULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL, 0x1ffffff812077812ULL, 0x010fe200078ef827ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0010027a11ULL, 0x000fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a0006047a11ULL, 0x000fc400078248ffULL,
0x00005b0010037a11ULL, 0x000fe400000f4c03ULL, 0x00005b0006057a11ULL, 0x000fe400008f4c05ULL,
0x1ffffff800277812ULL, 0x000fe200078ef827ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001027047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000000c04007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000042b037824ULL, 0x000fe400078e022eULL, 0xffffffffff027424ULL, 0x000fc600078e00ffULL,
0x0000002a0300720cULL, 0x000fda0003f06070ULL, 0x000000023e068824ULL, 0x004fc800078e00ffULL,
0x0000640006068a24ULL, 0x000fc800078e0203ULL, 0x0000600006068625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x0000000606028981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x01060000ff047f8cULL, 0x000e68000c80043fULL, 0x00000006082f7981ULL, 0x000762000c1e9900ULL,
0x000000012b007810ULL, 0x000fe20007ffe0ffULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000402e287824ULL, 0x000fe400078e00ffULL, 0x000000290000720cULL, 0x000fe20003f06070ULL,
0x000000405b3c7824ULL, 0x000fc400078e00ffULL, 0x0000000402157c24ULL, 0x004fd4000f8e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x000001002b077824ULL, 0x00afe200078e0228ULL,
0x00000002ff197819ULL, 0x100fe4000001162dULL, 0x00000003ff0e7819ULL, 0x000fe4000001162dULL,
0x000000072c007217ULL, 0x000fe20007800000ULL, 0x000000405b5b7824ULL, 0x000fe200078e0219ULL,
0x000000030e0e7812ULL, 0x000fe400078e482dULL, 0x000000300c1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a07ULL, 0x000000105b077810ULL, 0x000fc40007ffe0ffULL,
0x000000085b067810ULL, 0x000fe40007ffe0ffULL, 0x0000000715077210ULL, 0x040fe40007f5e0ffULL,
0x0000000615137210ULL, 0x040fe40007f3e0ffULL, 0x0000005b15127210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x00005e00070b7a11ULL, 0x000fe200078440ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e0013117a11ULL, 0x000fe200078240ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005f00070f7a11ULL, 0x000fc400010f4406ULL,
0x00005e00120a7a11ULL, 0x040fe400078040ffULL, 0x000000185b067810ULL, 0x000fe40007ffe0ffULL,
0x000000001900720cULL, 0x000fe40003f66070ULL, 0x00005f0013137a11ULL, 0x000fe400008f4408ULL,
0x00005f0012127a11ULL, 0x000fe400000f4409ULL, 0x00000006150d7210ULL, 0x000fc40007f3e0ffULL,
0x000020002e107811ULL, 0x000fe400078e68ffULL, 0x0ffffffc0e2d7812ULL, 0x000fe400078ef82dULL,
0x000000205b077810ULL, 0x000fe40007ffe0ffULL, 0x0000000a1b067210ULL, 0x000fe20007f1e0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0210ULL, 0x0000000715167210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x000000285b087810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0612ULL, 0x000000305b097810ULL, 0x000fc40007ffe0ffULL,
0x000000385b5b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000815147210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000062d7faeULL, 0x0003e2000d901c46ULL,
0x0000001b11087210ULL, 0x000fe40007f7e0ffULL, 0x0000000915127210ULL, 0x040fe40007f1e0ffULL,
0x0000005b155b7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200018e0613ULL,
0x0000000819157810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00005e000d0c7a11ULL, 0x000fc400078840ffULL, 0x000000001500720cULL, 0x040fe20003f66070ULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0x00005f000d0d7a11ULL, 0x000fe400020f440aULL,
0x0000001b0b0a7210ULL, 0x000fe40007f9e0ffULL, 0x0000001019117810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc15077812ULL, 0x002fe200078ee20eULL, 0x000000ffff0b7224ULL, 0x000fe200020e060fULL,
0x00005e0016067a11ULL, 0x040fe200078440ffULL, 0x00000004110f7824ULL, 0x000fe200078e00ffULL,
0x0000001819177810ULL, 0x000fe20007ffe0ffULL, 0x0000001007077824ULL, 0x000fe200078e0210ULL,
0x00005f0016167a11ULL, 0x000fc400010f4413ULL, 0x0000001b0c0c7210ULL, 0x000fe40007fbe0ffULL,
0x000000001100720cULL, 0x080fe20003f86070ULL, 0x0000000417117824ULL, 0x000fe200078e00ffULL,
0x0000002019137810ULL, 0x000fe20007ffe0ffULL, 0x0000000008077faeULL, 0x0003e2000d901c46ULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee20eULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0x0000002819157810ULL, 0x000fe40007ffe0ffULL, 0x000000001700720cULL, 0x000fe20003fa6070ULL,
0x000000100f0f7824ULL, 0x000fe200078e0210ULL, 0xfffffffc11117812ULL, 0x000fc400078ee20eULL,
0x0000003019177810ULL, 0x000fe40007ffe0ffULL, 0x000000000a0f7faeULL, 0x0005e2000e101c46ULL,
0x0000000413077824ULL, 0x002fe200078e00ffULL, 0x0000003819197810ULL, 0x000fe20007ffe0ffULL,
0x0000000415097824ULL, 0x000fe200078e00ffULL, 0x000000001300720cULL, 0x000fe20003f46070ULL,
0x0000001011117824ULL, 0x000fe200078e0210ULL, 0xfffffffc07077812ULL, 0x100fe400078ee20eULL,
0xfffffffc09097812ULL, 0x000fc400078ee20eULL, 0x000000000c117faeULL, 0x0003e2000e901c46ULL,
0x000000001500720cULL, 0x080fe20003f66070ULL, 0x00000004170b7824ULL, 0x044fe200078e00ffULL,
0x000000001700720cULL, 0x080fe20003f86070ULL, 0x00000010070f7824ULL, 0x000fe200078e0210ULL,
0x000000001900720cULL, 0x000fe20003fa6070ULL, 0x000000ffff077224ULL, 0x000fe200030e06ffULL,
0x00005e0014087a11ULL, 0x000fe200078c40ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0xfffffffc0b0b7812ULL, 0x000fe400078ee20eULL, 0x0000001b08087210ULL, 0x080fe20007f3e0ffULL,
0x0000001009117824ULL, 0x102fe200078e0210ULL, 0x00005f0014097a11ULL, 0x000fe200030f4407ULL,
0x000000100b137824ULL, 0x000fe200078e0210ULL, 0x0000001b06067210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e00120a7a11ULL, 0x000fe200078040ffULL,
0x00000004190d7824ULL, 0x000fc400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200030e0616ULL,
0x00005e005b0c7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x00005f00120b7a11ULL, 0x000fe400000f440bULL, 0xfffffffc0d0d7812ULL, 0x000fe200078ee20eULL,
0x00000000060f7faeULL, 0x0003e2000d101c46ULL, 0x0000001b0a0a7210ULL, 0x080fe40007f1e0ffULL,
0x00005f005b007a11ULL, 0x000fe200030f4400ULL, 0x000000100d157824ULL, 0x000fe200078e0210ULL,
0x0000001b0c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000008117faeULL, 0x0003e6000d901c46ULL, 0x000000ffff0d7224ULL, 0x000fe200008e0600ULL,
0x000000000a137faeULL, 0x0003e8000e101c46ULL, 0x000000000c157faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000003c2d007211ULL, 0x04afe400078ff0ffULL,
0x000000082d177811ULL, 0x000fc400078ff0ffULL, 0x0000000015007210ULL, 0x000fe40007f1e0ffULL,
0x000000182d097811ULL, 0x040fe400078ff0ffULL, 0x000000202d0b7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00005e0000167a11ULL, 0x000fe200078040ffULL,
0x000000013c087824ULL, 0x040fe200078e0209ULL, 0x000000282d0d7811ULL, 0x000fe200078ff0ffULL,
0x000000013c0a7824ULL, 0x000fe200078e020bULL, 0x00005f0000207a11ULL, 0x000fe200000f4407ULL,
0x0000000117007824ULL, 0x000fe200078e023cULL, 0x000000102d077811ULL, 0x040fe200078ff0ffULL,
0x000000013c0e7824ULL, 0x040fe200078e020dULL, 0x000000302d0f7811ULL, 0x000fe200078ff0ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0x000000382d117811ULL, 0x000fe200078ff0ffULL,
0x000000013c067824ULL, 0x040fe200078e0207ULL, 0x00000003ff147819ULL, 0x000fe2000001162dULL,
0x000000013c107824ULL, 0x040fe200078e020fULL, 0x00000000151e7210ULL, 0x040fe20007fde0ffULL,
0x000000013c127824ULL, 0x000fe200078e0211ULL, 0x0000000615137210ULL, 0x000fe20007fbe0ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x00000008151a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x0000000a15187210ULL, 0x000fe20007f3e0ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000e150e7210ULL, 0x000fe20007f5e0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x0000001015107210ULL, 0x000fe20007f7e0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x0000001215127210ULL, 0x000fe20007f9e0ffULL,
0x000000040d157824ULL, 0x000fe200078e00ffULL, 0x0000000314147812ULL, 0x000fe200078e482dULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x000020002e237811ULL, 0x000fc400078e68ffULL,
0xfffffffc07067812ULL, 0x100fe400078ee214ULL, 0xfffffffc09077812ULL, 0x100fe400078ee214ULL,
0xfffffffc15097812ULL, 0x100fe200078ee214ULL, 0x0000001006197824ULL, 0x100fe200078e0223ULL,
0x00005e001e1c7a11ULL, 0x040fe200078c40ffULL, 0x00000010071b7824ULL, 0x100fe200078e0223ULL,
0xfffffffc17007812ULL, 0x100fe200078ee214ULL, 0x00000010091f7824ULL, 0x000fe200078e0223ULL,
0xfffffffc0f0a7812ULL, 0x100fe200078ee214ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005f001e1e7a11ULL, 0x000fe200030f440dULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e00180f7a11ULL, 0x000fe200078240ffULL, 0x0000001000177824ULL, 0x000fe200078e0223ULL,
0x0ffffffc142d7812ULL, 0x000fe200078ef82dULL, 0x000000100a217824ULL, 0x100fe200078e0223ULL,
0xfffffffc0b087812ULL, 0x100fe200078ee214ULL, 0x000000ffff007224ULL, 0x000fe200028e06ffULL,
0x00005e001a0d7a11ULL, 0x000fe200078040ffULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0xfffffffc110b7812ULL, 0x000fe200078ee214ULL, 0x000000102d2d7824ULL, 0x100fe200078e0223ULL,
0x000000300c227812ULL, 0x000fe200078ec0ffULL, 0x00000010081d7824ULL, 0x100fe200078e0223ULL,
0x00005e00130a7a11ULL, 0x000fe200078a40ffULL, 0x000000100b237824ULL, 0x000fe200078e0223ULL,
0x00005f0018187a11ULL, 0x000fe200008f4407ULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x00005f001a1a7a11ULL, 0x000fe200000f4409ULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00005e0012147a11ULL, 0x000fc400078640ffULL, 0x0000001622067210ULL, 0x000fe40007f1e0ffULL,
0x00005f00130b7a11ULL, 0x000fe400028f4400ULL, 0x00005e000e117a11ULL, 0x000fe400078240ffULL,
0x00005e0010137a11ULL, 0x000fe400078440ffULL, 0x00005f0012007a11ULL, 0x000fe200018f4407ULL,
0x000000ffff077224ULL, 0x000fe200000e0620ULL, 0x00005f000e167a11ULL, 0x000fc400008f4409ULL,
0x0000001c22087210ULL, 0x000fe40007f1e0ffULL, 0x00005f0010157a11ULL, 0x000fe200010f4415ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000062d7faeULL, 0x0003e2000b901c46ULL,
0x0000000a220a7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e061eULL,
0x0000000d220c7210ULL, 0x040fe40007f5e0ffULL, 0x0000000f220e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000001122107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061aULL, 0x0000001322127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0618ULL, 0x0000001422147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0616ULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400028e0615ULL, 0x000000ffff157224ULL, 0x000fe200000e0600ULL,
0x000000000a197faeULL, 0x0003e8000b901c46ULL, 0x000000000c1b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e4000b901c46ULL,
0x01060400ff077984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000007ff7812ULL, 0x002fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x01060400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x000000202e007824ULL, 0x002fc800078e0205ULL, 0x0000002000067824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000001e006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105097812ULL, 0x040fe400078efcffULL,
0x0000000705077812ULL, 0x100fe400078e7800ULL, 0x0000000709097812ULL, 0x100fe400078e7800ULL,
0x00000010050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x040fe200078e0207ULL,
0x0000001105057810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x000000070b0b7812ULL, 0x000fc400078e7800ULL, 0x0000000007107984ULL, 0x000e62000000cc00ULL,
0x0000000705057812ULL, 0x000fe400078e7800ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x00000000090c7984ULL, 0x000ea4000000cc00ULL, 0x0000000106057824ULL, 0x000fe400078e0205ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fe200078e0013ULL,
0x0000001407007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fca00078e000fULL, 0x0000001809007388ULL, 0x000fe8000000cc00ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x000000000b107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c0b007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff047f8cULL, 0x002fe8000c80043fULL, 0x01060400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x01060400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000292b00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000002d7919ULL, 0x000e620000000000ULL,
0x3d8000002f2f7820ULL, 0x020fe20000410000ULL, 0x000064003e3e7a24ULL, 0x000fe200078e02ffULL,
0x000106882e3d7811ULL, 0x040fe200078e18ffULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0xffffffff29407810ULL, 0x000fe40007ffe0ffULL, 0x000106082e3f7811ULL, 0x000fe400078e28ffULL,
0x000001002b437824ULL, 0x000fe200078e0228ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000432c00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff457224ULL, 0x000fe200078e0041ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x0000000100247810ULL, 0x000fe20007ffe0ffULL, 0x00000d7000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e0000ULL, 0x0000000145417812ULL, 0x000fe200078e0cffULL,
0x00000004023b7c24ULL, 0x020fe2000f8e02ffULL, 0x00000002ff267819ULL, 0x100fe20000011624ULL,
0x000000ffff007224ULL, 0x000fe200078e0024ULL, 0x000000042400780cULL, 0x000fc40003f06070ULL,
0x0000000324507812ULL, 0x000fe200078ec0ffULL, 0x0000030026257a24ULL, 0x000fca00078e022bULL,
0x0000000125267810ULL, 0x000fc80007ffe0ffULL, 0x000000292600720cULL, 0x000fda0003f26070ULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff377819ULL, 0x002fe2000001162dULL,
0x0000010025257824ULL, 0x000fe400078e0228ULL, 0x000000022e447824ULL, 0x000fe200078e0241ULL,
0x0000000837477810ULL, 0x040fe20007ffe0ffULL, 0x0000000137247824ULL, 0x140fe200078e023cULL,
0x00000010374d7810ULL, 0x000fe40007ffe0ffULL, 0x000000252c327217ULL, 0x000fe20007800000ULL,
0x0000000147267824ULL, 0x100fe200078e023cULL, 0x000000243b357210ULL, 0x000fe20007f3e0ffULL,
0x000000014d277824ULL, 0x100fe200078e023cULL, 0x00000018374f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000132427824ULL, 0x000fe200078e0a25ULL, 0x000000263b337210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x000000273b317210ULL, 0x000fe20007f7e0ffULL,
0x000000014f327824ULL, 0x000fe200078e023cULL, 0x0000002037517810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x00005e0033267a11ULL, 0x000fe200078440ffULL,
0x000000ffff347224ULL, 0x000fe200018e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078640ffULL,
0x00000004474b7824ULL, 0x000fe200078e00ffULL, 0x0000002837537810ULL, 0x000fc40007ffe0ffULL,
0x00005e0035247a11ULL, 0x000fe400078240ffULL, 0x0000003037557810ULL, 0x040fe40007ffe0ffULL,
0x0000003837577810ULL, 0x000fe40007ffe0ffULL, 0x00005f0033277a11ULL, 0x000fe200010f4436ULL,
0x000000013c337824ULL, 0x040fe200078e0251ULL, 0x00005f0031317a11ULL, 0x000fe200018f4434ULL,
0x000000013c347824ULL, 0x040fe200078e0253ULL, 0x00005f0035257a11ULL, 0x000fe200008f4438ULL,
0x000000013c357824ULL, 0x040fe200078e0255ULL, 0x000000323b3a7210ULL, 0x000fe20007f3e0ffULL,
0x000000013c367824ULL, 0x000fe200078e0257ULL, 0x000000423700720cULL, 0x000fc40003f46070ULL,
0x000000333b387210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff337224ULL, 0x000fe200008e06ffULL,
0x000000343b377210ULL, 0x040fe40007fde0ffULL, 0x00000003ff347819ULL, 0x100fe4000001162dULL,
0x00005e003a327a11ULL, 0x000fe200078240ffULL, 0x000000ffff4a7224ULL, 0x000fe200030e06ffULL,
0x000000353b397210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff357224ULL, 0x000fe200028e06ffULL,
0x000000363b3b7210ULL, 0x000fe20007f7e0ffULL, 0x0000000450367824ULL, 0x000fe200078e00ffULL,
0x00000003344e7812ULL, 0x000fe200078e482dULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x00005f003a337a11ULL, 0x000fe200008f4433ULL, 0x000000ffff467224ULL, 0x000fe200018e06ffULL,
0x000000424700720cULL, 0x000fc40003f26070ULL, 0x0000200044447811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4e497812ULL, 0x100fe400078ef82dULL, 0xfffffffc36477812ULL, 0x000fe400078ee22dULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e0244ULL,
0x00005e0038347a11ULL, 0x000fe200078a40ffULL, 0x0000001047247825ULL, 0x000fe200078e0024ULL,
0x00005e003b3a7a11ULL, 0x000fc400078640ffULL, 0x00005f0038357a11ULL, 0x000fe200028f4435ULL,
0x000000104b4b7824ULL, 0x000fe200078e0244ULL, 0x00005e0039387a11ULL, 0x000fe200078840ffULL,
0x0000001047267825ULL, 0x000fe200078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024497faeULL, 0x0003e2000d101c46ULL, 0x00005e0037367a11ULL, 0x000fe400078a40ffULL,
0x00005f003b3b7a11ULL, 0x000fe200018f4446ULL, 0x00000000264b7faeULL, 0x0005e2000c901c46ULL,
0x000000424d00720cULL, 0x0c0fe20003f26070ULL, 0x000000044d4d7824ULL, 0x000fe200078e00ffULL,
0x000000424f00720cULL, 0x040fe20003f46070ULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0x00005f0039397a11ULL, 0x000fc400020f4448ULL, 0x000000425100720cULL, 0x0c0fe20003f66070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x00005f0037377a11ULL, 0x000fe200028f444aULL,
0x0000001047247825ULL, 0x002fe200078e0030ULL, 0x000000425300720cULL, 0x080fe40003f86070ULL,
0x000000425500720cULL, 0x080fe20003fa6070ULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0x000000425700720cULL, 0x000fe20003fc6070ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0xfffffffc4d497812ULL, 0x100fe200078ee24eULL, 0x0000000457577824ULL, 0x000fe200078e00ffULL,
0xfffffffc4f4b7812ULL, 0x004fe200078ee24eULL, 0x0000001047267825ULL, 0x000fe200078e0032ULL,
0xfffffffc514d7812ULL, 0x000fc400078ee24eULL, 0xfffffffc534f7812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e0244ULL, 0xfffffffc55517812ULL, 0x000fe200078ee24eULL,
0x000000104b4b7824ULL, 0x000fe200078e0244ULL, 0xfffffffc57537812ULL, 0x000fe200078ee24eULL,
0x000000104d4d7824ULL, 0x000fe200078e0244ULL, 0x0000000024497faeULL, 0x0003e2000c901c46ULL,
0x0000001047307825ULL, 0x000fc600078e0034ULL, 0x00000000264b7faeULL, 0x0003e2000d101c46ULL,
0x000000104f4f7824ULL, 0x000fe400078e0244ULL, 0x0000001047327825ULL, 0x000fe200078e0036ULL,
0x00000000304d7faeULL, 0x0003e6000d901c46ULL, 0x0000001051517824ULL, 0x000fe200078e0244ULL,
0x00000000324f7faeULL, 0x0003e2000e101c46ULL, 0x0000001047347825ULL, 0x000fc800078e0038ULL,
0x0000001053537824ULL, 0x000fe200078e0244ULL, 0x0000000034517faeULL, 0x0003e2000e901c46ULL,
0x0000001047367825ULL, 0x000fca00078e003aULL, 0x0000000036537faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x000000082d477811ULL, 0x042fe200078ff0ffULL,
0x00000004504e7824ULL, 0x000fe200078e00ffULL, 0x0000003c2d247211ULL, 0x040fe400078ff0ffULL,
0x000000102d497811ULL, 0x000fe200078ff0ffULL, 0x0000000147267824ULL, 0x040fe200078e023cULL,
0x0000003b24257210ULL, 0x080fe20007f3e0ffULL, 0x0000000447477824ULL, 0x000fe200078e00ffULL,
0x000000182d4b7811ULL, 0x000fe200078ff0ffULL, 0x000000013c347824ULL, 0x000fe200078e0249ULL,
0x0000003b26277210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078240ffULL, 0x000000013c367824ULL, 0x040fe200078e024bULL,
0x000000202d4d7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078440ffULL, 0x0000000449497824ULL, 0x000fe200078e00ffULL,
0x000000282d4f7811ULL, 0x040fe200078ff0ffULL, 0x000000013c387824ULL, 0x040fe200078e024dULL,
0x000000302d517811ULL, 0x000fe200078ff0ffULL, 0x000000044b4b7824ULL, 0x000fe200078e00ffULL,
0x000000382d557811ULL, 0x000fe200078ff0ffULL, 0x000000013c3a7824ULL, 0x040fe200078e024fULL,
0x00005f0025257a11ULL, 0x000fe200008f4432ULL, 0x000000013c427824ULL, 0x000fe200078e0251ULL,
0x00005f0027277a11ULL, 0x000fe200010f4430ULL, 0x000000022e307824ULL, 0x000fe200078e0241ULL,
0x00000003ff327819ULL, 0x000fe2000001162dULL, 0x000000013c447824ULL, 0x000fe200078e0255ULL,
0x0000003b34317210ULL, 0x080fe20007fde0ffULL, 0x000000044d4d7824ULL, 0x000fe200078e00ffULL,
0x0000000332347812ULL, 0x000fe200078e482dULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0x0000003b36337210ULL, 0x080fe20007fbe0ffULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x0000200030537811ULL, 0x000fe200078e60ffULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0x0000003b38357210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff327224ULL, 0x000fe200030e06ffULL,
0x00005e0031307a11ULL, 0x000fc400078c40ffULL, 0x0000003b3a377210ULL, 0x080fe40007f3e0ffULL,
0x0000003b42397210ULL, 0x080fe40007f5e0ffULL, 0x0000003b443b7210ULL, 0x000fe40007f7e0ffULL,
0xfffffffc47387812ULL, 0x100fe400078ee234ULL, 0xfffffffc493a7812ULL, 0x100fe400078ee234ULL,
0xfffffffc4b427812ULL, 0x100fe200078ee234ULL, 0x0000001038477824ULL, 0x100fe200078e0253ULL,
0xfffffffc4d447812ULL, 0x100fe200078ee234ULL, 0x000000103a497824ULL, 0x100fe200078e0253ULL,
0xfffffffc4f467812ULL, 0x100fe200078ee234ULL, 0x00000010424b7824ULL, 0x100fe200078e0253ULL,
0xfffffffc51487812ULL, 0x100fe200078ee234ULL, 0x00000010444d7824ULL, 0x000fe200078e0253ULL,
0x0ffffffc34367812ULL, 0x000fe200078ef82dULL, 0x00000010464f7824ULL, 0x100fe200078e0253ULL,
0xfffffffc554a7812ULL, 0x000fe200078ee234ULL, 0x000000ffff347224ULL, 0x000fe200028e06ffULL,
0x00005f0031317a11ULL, 0x000fe200030f4432ULL, 0x0000001048517824ULL, 0x000fe200078e0253ULL,
0x00005e0033327a11ULL, 0x040fe200078a40ffULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0xfffffffc4e557812ULL, 0x000fe200078ee22dULL, 0x0000001036577824ULL, 0x000fe200078e0253ULL,
0x00005f0033337a11ULL, 0x000fe200028f4434ULL, 0x000000ffff467224ULL, 0x000fe200008e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078840ffULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078240ffULL, 0x000000ffff427224ULL, 0x000fe200018e06ffULL,
0x00005e0039387a11ULL, 0x000fe200078440ffULL, 0x0000001055247825ULL, 0x000fe200078e0024ULL,
0x00005e003b3a7a11ULL, 0x000fc400078640ffULL, 0x00005f0035357a11ULL, 0x000fe200020f4448ULL,
0x0000001055267825ULL, 0x000fe200078e0026ULL, 0x00005f0037377a11ULL, 0x000fe200008f4446ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024577faeULL, 0x0003e2000b901c46ULL,
0x00005f0039397a11ULL, 0x000fe200010f4444ULL, 0x0000001055307825ULL, 0x000fe200078e0030ULL,
0x00005f003b3b7a11ULL, 0x000fe200018f4442ULL, 0x0000000026477faeULL, 0x0003e4000b901c46ULL,
0x0000001055327825ULL, 0x040fe400078e0032ULL, 0x0000000030497faeULL, 0x0003e4000b901c46ULL,
0x0000001055347825ULL, 0x000fc400078e0034ULL, 0x00000000324b7faeULL, 0x0003e4000b901c46ULL,
0x0000001055367825ULL, 0x040fe400078e0036ULL, 0x00000000344d7faeULL, 0x0003e4000b901c46ULL,
0x0000001055387825ULL, 0x000fe400078e0038ULL, 0x00000000364f7faeULL, 0x0003e4000b901c46ULL,
0x000000104a537824ULL, 0x000fc400078e0253ULL, 0x00000010553a7825ULL, 0x000fe200078e003aULL,
0x0000000038517faeULL, 0x0003e8000b901c46ULL, 0x000000003a537faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000035000780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x00000004ff257424ULL, 0x002fe400078e00ffULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x0000030025037a24ULL, 0x000fca00078e0203ULL, 0x0000002a0300720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x000000023e247824ULL, 0x000fc800078e0203ULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x0000000624027981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000084c487824ULL, 0x000fe400078e00ffULL, 0x000000ffff477224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff82d247812ULL, 0x000fe200078ec0ffULL,
0x000000022e307824ULL, 0x000fe200078e0245ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000147337810ULL, 0x000fe40007ffe0ffULL, 0x0000000724247812ULL, 0x000fe400078ef82dULL,
0x0000200030307811ULL, 0x000fc400078e60ffULL, 0x00000001ff257819ULL, 0x000fe40000011624ULL,
0x000000072dd07812ULL, 0x000fe400078ec0ffULL, 0x0000000325267812ULL, 0x000fe400078ec0ffULL,
0x00000008d0cf7812ULL, 0x000fe400078ef82dULL, 0x0000004726257212ULL, 0x040fe400078e3cffULL,
0x0000003326277212ULL, 0x000fc600078e3cffULL, 0x0000000424257824ULL, 0x040fe400078e0225ULL,
0x0000000424277824ULL, 0x000fe200078e0227ULL, 0x000000202d247810ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x100fe400078e0230ULL, 0x0000001027277824ULL, 0x000fe200078e0230ULL,
0xfffffff824247812ULL, 0x000fe400078ec0ffULL, 0x000000002538783bULL, 0x0002a40000000200ULL,
0x0000000724317812ULL, 0x000fc400078ef82dULL, 0x000000002734783bULL, 0x000ee40000000200ULL,
0x00000001ff247819ULL, 0x000fc80000011631ULL, 0x0000000324327812ULL, 0x000fc800078ec0ffULL,
0x0000004732247212ULL, 0x040fe400078e3cffULL, 0x0000003332327212ULL, 0x000fe400078e3cffULL,
0x0000000247477810ULL, 0x000fe20007ffe0ffULL, 0x0000000431257824ULL, 0x042fe400078e0224ULL,
0x0000000431317824ULL, 0x000fe400078e0232ULL, 0x0000001025257824ULL, 0x100fe400078e0230ULL,
0x0000001031317824ULL, 0x000fc800078e0230ULL, 0x000000002524783bULL, 0x000e680000000200ULL,
0x000000003130783bULL, 0x000f220000000200ULL, 0x0000003800747306ULL, 0x004fe20000009400ULL,
0x00000018ffab7819ULL, 0x000fe20000011438ULL, 0x0001000038607824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011439ULL, 0x000001003aaf7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001143aULL, 0x000100003bae7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe20000011460ULL, 0x0000003800b37306ULL, 0x000ea20000005400ULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x000001003baa7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe2000001143bULL, 0x00010000347b7824ULL, 0x048fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x00010000357e7824ULL, 0x040fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x00000038005f7306ULL, 0x000722000000d400ULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000010034807824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000010035817824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011434ULL, 0x0001000036757824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000000b200b47306ULL, 0x000fe20000209400ULL,
0x0000010038387824ULL, 0x008fe200078e00ffULL, 0x000000b37400720bULL, 0x004fe20003f9d000ULL,
0x00000100366d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011436ULL,
0x0001000024c87824ULL, 0x002fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fe20000011438ULL,
0x0001000039387824ULL, 0x000fe200078e00ffULL, 0x000000b200b57306ULL, 0x000e620000205400ULL,
0x00000018ff9c7819ULL, 0x000fc40000011424ULL, 0x00000018ffc87819ULL, 0x000fe400000114c8ULL,
0x00000018ffbb7819ULL, 0x000fe20000011438ULL, 0x000100003a387824ULL, 0x000fe200078e00ffULL,
0x000000015f5f4812ULL, 0x010fe200078efcffULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x00000018ff997819ULL, 0x000fe40000011425ULL, 0x00000018ffc17819ULL, 0x000fe40000011438ULL,
0x00000018ff967819ULL, 0x000fc40000011426ULL, 0x00000018ff877819ULL, 0x000fe20000011427ULL,
0x000000b600b87306ULL, 0x000ea20000205400ULL, 0x000000b5b400720bULL, 0x002fe20003f5d000ULL,
0x0000010027b57824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff647819ULL, 0x000fe40000011435ULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x0000003900a77306ULL, 0x000fe20000009400ULL, 0x00000018ff507819ULL, 0x000fc40000011437ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff6d7819ULL, 0x000fc6000001146dULL,
0x0000003900a47306ULL, 0x000e620000005400ULL, 0x000000b8b700720bULL, 0x004fce0003f7d000ULL,
0x00000039005e7306ULL, 0x0004f0000000d400ULL, 0x000000ab00b97306ULL, 0x000fe20000209400ULL,
0x0000010039397824ULL, 0x004fe200078e00ffULL, 0x000000a4a700720bULL, 0x002fc40003f3d000ULL,
0x000000b600a77245ULL, 0x000fe4000020d400ULL, 0x00000018ffbe7819ULL, 0x000fe40000011439ULL,
0x000000ab00ba7306ULL, 0x000e620000205400ULL, 0x000000b200a47245ULL, 0x000fe4000020d400ULL,
0x00000001a7a73812ULL, 0x000fe400078efcffULL, 0x00000001a4a42812ULL, 0x000fe400078efcffULL,
0x000000015e5e1812ULL, 0x008fe200078efcffULL, 0x000000bb00bc7306ULL, 0x000ff00000209400ULL,
0x000000bb00bd7306ULL, 0x000ea20000205400ULL, 0x000000bab900720bULL, 0x002fce0003fdd000ULL,
0x000000be00bf7306ULL, 0x000ff00000209400ULL, 0x000000be00c07306ULL, 0x000e620000205400ULL,
0x000000bdbc00720bULL, 0x004fce0003fbd000ULL, 0x0000003a00a57306ULL, 0x000ff00000009400ULL,
0x0000003a00a67306ULL, 0x000ea20000005400ULL, 0x000000c0bf00720bULL, 0x002fce0003f7d000ULL,
0x000000a300ad7306ULL, 0x000ff00000209400ULL, 0x000000a300ac7306ULL, 0x000e620000205400ULL,
0x000000a6a500720bULL, 0x004fe40003f5d000ULL, 0x000000ab00a67245ULL, 0x000fc4000020d400ULL,
0x000000bb00a57245ULL, 0x000fe4000020d400ULL, 0x00000001a6a66812ULL, 0x000fe200078efcffULL,
0x0000003b00a17306ULL, 0x000fe20000009400ULL, 0x00000001a5a55812ULL, 0x000fc800078efcffULL,
0x0000005ea55e723eULL, 0x000fc600000010ffULL, 0x0000003b00a27306ULL, 0x000ea20000005400ULL,
0x000000acad00720bULL, 0x002fe20003f9d000ULL, 0x0001000026ac7824ULL, 0x000fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x00000034009d7306ULL, 0x000ff00000009400ULL,
0x0000003400a07306ULL, 0x000e620000005400ULL, 0x000000a2a100720bULL, 0x004fc40003fdd000ULL,
0x000000be00a17245ULL, 0x000fe4000020d400ULL, 0x0000009300a27245ULL, 0x000fe4000020d400ULL,
0x00000001a1a13812ULL, 0x000fe200078efcffULL, 0x000000c100c27306ULL, 0x000ff00000209400ULL,
0x000000c100c37306ULL, 0x000ea20000205400ULL, 0x000000a09d00720bULL, 0x002fe20003f3d000ULL,
0x00000100269d7824ULL, 0x000fe200078e00ffULL, 0x000000a300a07245ULL, 0x000fe2000020d400ULL,
0x0001000027a37824ULL, 0x000fc600078e00ffULL, 0x00000001a0a04812ULL, 0x000fe200078efcffULL,
0x000000af00c47306ULL, 0x000fe20000209400ULL, 0x00000018ffa37819ULL, 0x000fce00000114a3ULL,
0x000000af00c57306ULL, 0x000e620000205400ULL, 0x000000c3c200720bULL, 0x004fce0003fbd000ULL,
0x00000093009f7306ULL, 0x000ff00000209400ULL, 0x00000093009e7306ULL, 0x000ea20000205400ULL,
0x000000c5c400720bULL, 0x002fce0003f7d000ULL, 0x00000024008d7306ULL, 0x000ff00000009400ULL,
0x0000002400947306ULL, 0x000fe20000005400ULL, 0x0000009e9f00720bULL, 0x004fe40003f9d000ULL,
0x000000c1009e7245ULL, 0x000fc4000020d400ULL, 0x00000018ff9f7819ULL, 0x000fe4000001149dULL,
0x000000af009d7245ULL, 0x000fe2000020d400ULL, 0x0000002400567306ULL, 0x0003e2000000d400ULL,
0x000000019e9e5812ULL, 0x000fe400078efcffULL, 0x000000019d9d3812ULL, 0x000fe400078efcffULL,
0x0000008800af7245ULL, 0x000fe4000020d400ULL, 0x00000001a2a24812ULL, 0x000fe200078efcffULL,
0x0000003a005b7306ULL, 0x0004e2000000d400ULL, 0x0000010024247824ULL, 0x002fca00078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x0000008800957306ULL, 0x000fe20000209400ULL, 0x00000100373a7824ULL, 0x004fc600078e00ffULL,
0x00000018ffce7819ULL, 0x000fe40000011424ULL, 0x000000482d247211ULL, 0x000fe400078fe0ffULL,
0x0000008800927306ULL, 0x000e620000205400ULL, 0x000000015b5b2812ULL, 0x008fe400078efcffULL,
0x0000000224747810ULL, 0x040fe40007ffe0ffULL, 0x0000000724247812ULL, 0x100fe400078e78cfULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x000000ae00c67306ULL, 0x000fe20000209400ULL,
0x0000000774747812ULL, 0x000fe200078e78cfULL, 0x00000020cf247824ULL, 0x000fe200078e0224ULL,
0x0000000448487810ULL, 0x000fc60007ffe0ffULL, 0x0000001024247824ULL, 0x000fe400078e00ffULL,
0x000000ae00c77306ULL, 0x0004e20000205400ULL, 0x000000929500720bULL, 0x002fe20003f5d000ULL,
0x00000020cf747824ULL, 0x000fcc00078e0274ULL, 0x000000aa00b17306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x004fca000020d400ULL, 0x00000001afaf2812ULL, 0x000fe400078efcffULL,
0x000000aa00b07306ULL, 0x0002a20000205400ULL, 0x000000c7c600720bULL, 0x008fce0003fbd000ULL,
0x000000c800c97306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fca000020d400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x000000c800ca7306ULL, 0x000e620000205400ULL,
0x000000b0b100720bULL, 0x004fe40003f7d000ULL, 0x000000948d00720bULL, 0x000fe40003fbd000ULL,
0x000000c8008d7245ULL, 0x000fc6000020d400ULL, 0x0000003b00577306ULL, 0x0004ec000000d400ULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x0000009c00a97306ULL, 0x000fe20000209400ULL,
0x000000cac900720bULL, 0x002fe20003f9d000ULL, 0x00010000373b7824ULL, 0x004fe200078e00ffULL,
0x0000000156565812ULL, 0x000fc400078efcffULL, 0x000000aaafaf723eULL, 0x000fe400000010ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000009c00a87306ULL, 0x0002a20000205400ULL,
0x0000000157576812ULL, 0x008fc800078efcffULL, 0x00000057aeae723eULL, 0x000fe400000010ffULL,
0x000000018d8d4812ULL, 0x000fe200078efcffULL, 0x000000ce00b37306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fe4000020d400ULL, 0x000000568d56723eULL, 0x000fca00000010ffULL,
0x000000ce00b47306ULL, 0x000e620000205400ULL, 0x000000a8a900720bULL, 0x004fce0003fdd000ULL,
0x000000cb00cc7306ULL, 0x000fec0000209400ULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x000000cb00cd7306ULL, 0x0004e20000205400ULL, 0x000000b4b300720bULL, 0x002fce0003f5d000ULL,
0x00000025008e7306ULL, 0x000fe20000009400ULL, 0x000000cb00cb7245ULL, 0x004fce000020d400ULL,
0x0000002500897306ULL, 0x000e620000005400ULL, 0x000000cdcc00720bULL, 0x008fce0003f7d000ULL,
0x00000099009a7306ULL, 0x000fec0000209400ULL, 0x00000001cbcb3812ULL, 0x000fe400078efcffULL,
0x00000099009b7306ULL, 0x0004e20000205400ULL, 0x000000898e00720bULL, 0x002fe40003f9d000ULL,
0x000000ce008e7245ULL, 0x000fc4000020d400ULL, 0x000000cb9c57723eULL, 0x000fe400000010ffULL,
0x000000018e8e2812ULL, 0x000fe200078efcffULL, 0x0000002600857306ULL, 0x000fe20000009400ULL,
0x0000009900997245ULL, 0x004fce000020d400ULL, 0x0000002600867306ULL, 0x000e620000005400ULL,
0x0000009b9a00720bULL, 0x008fce0003fdd000ULL, 0x00000026004f7306ULL, 0x000eac000000d400ULL,
0x0000000199996812ULL, 0x000fe400078efcffULL, 0x000000ac00ad7306ULL, 0x000fe20000209400ULL,
0x000000868500720bULL, 0x002fe40003f7d000ULL, 0x00000018ff857819ULL, 0x000fca0000011432ULL,
0x000000ac00267306ULL, 0x000e6c0000205400ULL, 0x000000014f4f3812ULL, 0x004fe400078efcffULL,
0x0000002500557306ULL, 0x0004f0000000d400ULL, 0x0000002700797306ULL, 0x000fe20000009400ULL,
0x0000010025257824ULL, 0x004fe200078e00ffULL, 0x00000026ad00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000027007a7306ULL, 0x000fe20000005400ULL,
0x0000000155554812ULL, 0x008fe400078efcffULL, 0x0000002500887245ULL, 0x000fe4000020d400ULL,
0x000000558e8e723eULL, 0x000fc600000010ffULL, 0x00000027004e7306ULL, 0x000ff0000000d400ULL,
0x0000009f00277306ULL, 0x000ff00000209400ULL, 0x0000009f00927306ULL, 0x000e700000205400ULL,
0x000000a300937306ULL, 0x000ff00000209400ULL, 0x000000a300947306ULL, 0x0004e20000205400ULL,
0x000000922700720bULL, 0x002fc40003f9d000ULL, 0x000000ac00927245ULL, 0x000fc8000020d400ULL,
0x0000000192922812ULL, 0x000fe200078efcffULL, 0x0000002500b27306ULL, 0x000fe20000209400ULL,
0x0000007a7900720bULL, 0x000fe40003f5d000ULL, 0x000000a300a37245ULL, 0x004fe4000020d400ULL,
0x0000009f007a7245ULL, 0x000fe4000020d400ULL, 0x0000004f9292723eULL, 0x000fe200000010ffULL,
0x0000002500ab7306ULL, 0x000e620000205400ULL, 0x000000949300720bULL, 0x008fc40003fdd000ULL,
0x000000017a7a4812ULL, 0x000fe400078efcffULL, 0x0000009600937245ULL, 0x000fe4000020d400ULL,
0x000000014e4e2812ULL, 0x000fe200078efcffULL, 0x000000b500897306ULL, 0x000fec0000209400ULL,
0x00000001a3a36812ULL, 0x000fc400078efcffULL, 0x000000b500267306ULL, 0x0004e20000205400ULL,
0x000000abb200720bULL, 0x002fe40003fbd000ULL, 0x0000004ea34e723eULL, 0x000fca00000010ffULL,
0x0000008700907306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x004fca000020d400ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x0000008700917306ULL, 0x000e620000205400ULL,
0x000000268900720bULL, 0x008fe20003f7d000ULL, 0x0001000030897824ULL, 0x000fe200078e00ffULL,
0x000000002424783bULL, 0x000ea80000000200ULL, 0x00000018ff897819ULL, 0x000fe20000011489ULL,
0x0000007b008c7306ULL, 0x000fec0000209400ULL, 0x00000001b5b53812ULL, 0x000fc400078efcffULL,
0x0000007b008f7306ULL, 0x000ee20000205400ULL, 0x000000919000720bULL, 0x002fce0003fdd000ULL,
0x00000034004d7306ULL, 0x000330000000d400ULL, 0x0000009600987306ULL, 0x000fe20000209400ULL,
0x0000008f8c00720bULL, 0x008fe40003f5d000ULL, 0x00000018ff347819ULL, 0x002fc40000011430ULL,
0x00000088998f723eULL, 0x000fc600000010ffULL, 0x0000009600977306ULL, 0x000e620000205400ULL,
0x000000014d4d1812ULL, 0x010fe200078efcffULL, 0x000000ae2414723cULL, 0x044fec0000041814ULL,
0x0000007e007f7306ULL, 0x000fe40000209400ULL, 0x000000562410723cULL, 0x040fec0000041810ULL,
0x0000007e00827306ULL, 0x000ea20000205400ULL, 0x000000979800720bULL, 0x002fe20003fbd000ULL,
0x0000008e240c723cULL, 0x000fec000004180cULL, 0x0000003500737306ULL, 0x000fec0000009400ULL,
0x0000000193935812ULL, 0x000fc400078efcffULL, 0x0000003500767306ULL, 0x000e620000005400ULL,
0x000000827f00720bULL, 0x004fe20003f3d000ULL, 0x00000100317f7824ULL, 0x000fe200078e00ffULL,
0x0000007a9393723eULL, 0x000fe200000010ffULL, 0x0000010032827824ULL, 0x000fc600078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x00000080008b7306ULL, 0x000fe20000209400ULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x000000922408723cULL, 0x000fec0000041808ULL,
0x00000080008a7306ULL, 0x000ea20000205400ULL, 0x000000767300720bULL, 0x002fc40003f9d000ULL,
0x0000008700767245ULL, 0x000fe4000020d400ULL, 0x00000018ff737819ULL, 0x000fe40000011433ULL,
0x0000000176766812ULL, 0x000fe200078efcffULL, 0x0000003700627306ULL, 0x000fe60000009400ULL,
0x000000b5764f723eULL, 0x000fca00000010ffULL, 0x0000003700637306ULL, 0x000e620000005400ULL,
0x0000008a8b00720bULL, 0x004fe20003f7d000ULL, 0x0000004e2404723cULL, 0x000fe20000041804ULL,
0x0000007b008a7245ULL, 0x000fe4000020d400ULL, 0x00000080008b7245ULL, 0x000fe2000020d400ULL,
0x0001000032807824ULL, 0x000fe200078e00ffULL, 0x000000018a8a2812ULL, 0x000fe200078efcffULL,
0x0000006600677306ULL, 0x000fe60000209400ULL, 0x00000018ff807819ULL, 0x000fc40000011480ULL,
0x0000004d8a8a723eULL, 0x000fe400000010ffULL, 0x000000018b8b3812ULL, 0x000fe200078efcffULL,
0x00000066006a7306ULL, 0x0004e20000205400ULL, 0x000000636200720bULL, 0x002fe20003fdd000ULL,
0x0001000031627824ULL, 0x000fe200078e00ffULL, 0x0000007e00637245ULL, 0x000fc8000020d400ULL,
0x0000000163631812ULL, 0x000fe200078efcffULL, 0x0000003600727306ULL, 0x000fe20000009400ULL,
0x0000006600667245ULL, 0x004fce000020d400ULL, 0x0000003600717306ULL, 0x000e620000005400ULL,
0x0000006a6700720bULL, 0x008fce0003f5d000ULL, 0x0000005a006c7306ULL, 0x000fec0000209400ULL,
0x0000000166662812ULL, 0x000fe400078efcffULL, 0x0000005a00697306ULL, 0x0004e20000205400ULL,
0x000000717200720bULL, 0x002fe40003fbd000ULL, 0x0000008b668b723eULL, 0x000fca00000010ffULL,
0x0000008100837306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x004fce000020d400ULL,
0x0000008100847306ULL, 0x0002a20000205400ULL, 0x000000696c00720bULL, 0x008fce0003f3d000ULL,
0x0000006400687306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x000000015a5a1812ULL, 0x000fe400078efcffULL, 0x0000006400657306ULL, 0x0002e20000205400ULL,
0x000000848300720bULL, 0x004fe20003f7d000ULL, 0x0001000033837824ULL, 0x040fe400078e00ffULL,
0x0000010033847824ULL, 0x000fc600078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x00000036004b7306ULL, 0x000ea2000000d400ULL, 0x0000006400647245ULL, 0x002fe4000020d400ULL,
0x00000018ff847819ULL, 0x000fc60000011484ULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x0000003b006f7306ULL, 0x000fe20000209400ULL, 0x000000656800720bULL, 0x008fe40003f5d000ULL,
0x00000018ff687819ULL, 0x000fe40000011462ULL, 0x0000007500627245ULL, 0x000fc6000020d400ULL,
0x0000003b00707306ULL, 0x0002e20000205400ULL, 0x000000014b4b5812ULL, 0x004fca00078efcffULL,
0x0000000164642812ULL, 0x000fe400078efcffULL, 0x0000003a00607306ULL, 0x000fe20000209400ULL,
0x0000003b003b7245ULL, 0x002fe4000020d400ULL, 0x00000081644d723eULL, 0x000fca00000010ffULL,
0x0000003a00617306ULL, 0x0002a20000205400ULL, 0x000000706f00720bULL, 0x008fce0003fbd000ULL,
0x00000030005d7306ULL, 0x000fe20000009400ULL, 0x0000003a003a7245ULL, 0x002fca000020d400ULL,
0x000000013b3b5812ULL, 0x000fe400078efcffULL, 0x00000030005c7306ULL, 0x000fe20000005400ULL,
0x000000616000720bULL, 0x004fce0003f3d000ULL, 0x00000030004a7306ULL, 0x0003ec000000d400ULL,
0x000000013a3a1812ULL, 0x000fe400078efcffULL, 0x00000035004c7306ULL, 0x0004e2000000d400ULL,
0x0000010030307824ULL, 0x002fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011430ULL,
0x00000050006b7306ULL, 0x000fe20000209400ULL, 0x00000018ff357819ULL, 0x004fe40000011431ULL,
0x0000005fa430723eULL, 0x000fe400000010ffULL, 0x000000a1a05f723eULL, 0x000fc600000010ffULL,
0x00000050006e7306ULL, 0x000e620000205400ULL, 0x000000014c4c4812ULL, 0x008fc600078efcffULL,
0x0000005e241c723cULL, 0x000fe2000004181cULL, 0x0000004c634c723eULL, 0x000fc600000010ffULL,
0x00000075007c7306ULL, 0x000ff00000209400ULL, 0x00000075007d7306ULL, 0x000ea20000205400ULL,
0x0000006e6b00720bULL, 0x002fce0003f9d000ULL, 0x0000003100597306ULL, 0x000ff00000009400ULL,
0x0000003100587306ULL, 0x000fe20000005400ULL, 0x0000007d7c00720bULL, 0x004fce0003f7d000ULL,
0x0000003100497306ULL, 0x0003ec000000d400ULL, 0x0000000162623812ULL, 0x000fe400078efcffULL,
0x0000006d00777306ULL, 0x000fe20000209400ULL, 0x000000a7a631723eULL, 0x002fe400000010ffULL,
0x0000005c5d00720bULL, 0x000fc40003f7d000ULL, 0x0000004b6262723eULL, 0x000fc600000010ffULL,
0x0000006d00787306ULL, 0x0002a20000205400ULL, 0x000000302420723cULL, 0x000fee0000041820ULL,
0x0000003200527306ULL, 0x000fe20000009400ULL, 0x0000005b9e30723eULL, 0x000fe400000010ffULL,
0x0000009da231723eULL, 0x000fc400000010ffULL, 0x0000006d006d7245ULL, 0x002fe4000020d400ULL,
0x000000014a4a3812ULL, 0x000fe200078efcffULL, 0x0000003200517306ULL, 0x000e620000005400ULL,
0x000000787700720bULL, 0x004fe20003f5d000ULL, 0x000000302418723cULL, 0x000fec0000041818ULL,
0x00000089007b7306ULL, 0x000fe20000209400ULL, 0x0000001074307824ULL, 0x000fe200078e00ffULL,
0x0000003500267245ULL, 0x000fc4000020d400ULL, 0x0000008000277245ULL, 0x000fe4000020d400ULL,
0x000000016d6d2812ULL, 0x000fe400078efcffULL, 0x00000089006a7306ULL, 0x0004e20000205400ULL,
0x000000515200720bULL, 0x002fe40003fbd000ULL, 0x0000005000517245ULL, 0x000fe4000020d400ULL,
0x000000585900720bULL, 0x000fe40003f5d000ULL, 0x0000000151514812ULL, 0x000fe200078efcffULL,
0x00000067007e7306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x004fc4000020d400ULL,
0x0000003a5125723eULL, 0x000fe400000010ffULL, 0x0000006d5a63723eULL, 0x000fc600000010ffULL,
0x0000006700657306ULL, 0x0002a20000205400ULL, 0x0000006a7b00720bULL, 0x008fe40003f3d000ULL,
0x0000000149492812ULL, 0x000fca00078efcffULL, 0x0000003400387306ULL, 0x000fe20000209400ULL,
0x0000006700677245ULL, 0x002fca000020d400ULL, 0x0000000189891812ULL, 0x000fe400078efcffULL,
0x0000003400397306ULL, 0x0002e20000205400ULL, 0x000000657e00720bULL, 0x004fe40003f9d000ULL,
0x0000004a894a723eULL, 0x000fca00000010ffULL, 0x0000003700427306ULL, 0x000ea2000000d400ULL,
0x0000003400347245ULL, 0x002fca000020d400ULL, 0x0000000167674812ULL, 0x000fe400078efcffULL,
0x0000003200447306ULL, 0x000e62000000d400ULL, 0x000000393800720bULL, 0x008fce0003f3d000ULL,
0x0000003300547306ULL, 0x000fe20000009400ULL, 0x0000000142426812ULL, 0x004fc800078efcffULL,
0x000000423b24723eULL, 0x000fe400000010ffULL, 0x0000000134341812ULL, 0x000fe200078efcffULL,
0x0000003300537306ULL, 0x000ea20000005400ULL, 0x0000000144445812ULL, 0x002fe400078efcffULL,
0x00000067344b723eULL, 0x000fe400000010ffULL, 0x0000008500347245ULL, 0x000fc6000020d400ULL,
0x0000003300467306ULL, 0x0002f0000000d400ULL, 0x0000003500367306ULL, 0x000fe20000209400ULL,
0x000000003030783bULL, 0x002e620000000200ULL, 0x000000535400720bULL, 0x004fcc0003fdd000ULL,
0x0000003500377306ULL, 0x000eae0000205400ULL, 0x0000000146466812ULL, 0x008fe200078efcffULL,
0x0000006800697306ULL, 0x000ff00000209400ULL, 0x00000068006c7306ULL, 0x0007220000205400ULL,
0x000000373600720bULL, 0x004fce0003f9d000ULL, 0x0000007f005b7306ULL, 0x000fe20000209400ULL,
0x0000006800687245ULL, 0x008fca000020d400ULL, 0x0000000126264812ULL, 0x000fe400078efcffULL,
0x0000007f00587306ULL, 0x000ea20000205400ULL, 0x0000006c6900720bULL, 0x010fe20003f7d000ULL,
0x000000243014723cULL, 0x002fe20000041814ULL, 0x0000007f00697245ULL, 0x000fca000020d400ULL,
0x0000008000597306ULL, 0x000fe20000209400ULL, 0x0000008200257245ULL, 0x000fe2000020d400ULL,
0x0000008a3020723cULL, 0x040fe80000041820ULL, 0x0000000168683812ULL, 0x000fe400078efcffULL,
0x0000008000527306ULL, 0x000e620000205400ULL, 0x000000585b00720bULL, 0x004fe20003f3d000ULL,
0x0000004c301c723cULL, 0x000fe2000004181cULL, 0x000000496868723eULL, 0x000fca00000010ffULL,
0x0000008500867306ULL, 0x000fe40000209400ULL, 0x000000623018723cULL, 0x040fe80000041818ULL,
0x0000000169691812ULL, 0x000fe400078efcffULL, 0x0000008500797306ULL, 0x000ea20000205400ULL,
0x000000525900720bULL, 0x002fe20003f5d000ULL, 0x0000004a3010723cULL, 0x000fe20000041810ULL,
0x000000692669723eULL, 0x000fca00000010ffULL, 0x0000008200507306ULL, 0x000fe40000209400ULL,
0x00000068300c723cULL, 0x000fe8000004180cULL, 0x0000000127272812ULL, 0x000fe400078efcffULL,
0x0000008200537306ULL, 0x000e620000205400ULL, 0x000000798600720bULL, 0x004fe40003f7d000ULL,
0x000000442724723eULL, 0x000fc400000010ffULL, 0x0000008400277245ULL, 0x000fc6000020d400ULL,
0x0000007300717306ULL, 0x000fec0000209400ULL, 0x0000000134343812ULL, 0x000fe400078efcffULL,
0x0000007300727306ULL, 0x000ea20000205400ULL, 0x000000535000720bULL, 0x002fce0003f9d000ULL,
0x0000008300387306ULL, 0x000fec0000209400ULL, 0x0000000125254812ULL, 0x000fe400078efcffULL,
0x0000008300377306ULL, 0x0002e20000205400ULL, 0x000000727100720bULL, 0x004fe40003f3d000ULL,
0x000000253425723eULL, 0x000fc400000010ffULL, 0x0000007300347245ULL, 0x000fc6000020d400ULL,
0x0000008400367306ULL, 0x000fe20000209400ULL, 0x0000008300837245ULL, 0x002fe2000020d400ULL,
0x000000243008723cULL, 0x000fe80000041808ULL, 0x0000000134341812ULL, 0x000fe400078efcffULL,
0x0000008400397306ULL, 0x000e620000205400ULL, 0x000000373800720bULL, 0x008fe40003f5d000ULL,
0x000000044700780cULL, 0x000fd60003f25270ULL, 0x0000000183832812ULL, 0x000fe400078efcffULL,
0x000000393600720bULL, 0x002fe40003fbd000ULL, 0x000000468326723eULL, 0x000fd600000010ffULL,
0x0000000127275812ULL, 0x000fc800078efcffULL, 0x000000273427723eULL, 0x000fce00000010ffULL,
0x000000263004723cULL, 0x000fe20000041804ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff457224ULL, 0x000fe200078e0041ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd25000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003d247f8cULL, 0x000fe2000c80043fULL,
0x0000001d2f1d7220ULL, 0x040fe20000410000ULL, 0x0000001a2f267220ULL, 0x040fe20000410000ULL,
0x000000152f157220ULL, 0x040fe20000410000ULL, 0x000004003d277984ULL, 0x000e620000000800ULL,
0x0000001e2f1e7220ULL, 0x040fe20000410000ULL, 0x0000000d2f1a7220ULL, 0x040fe20000410000ULL,
0x000000202f207220ULL, 0x040fe20000410000ULL, 0x000000212f217220ULL, 0x040fe20000410000ULL,
0x000000222f227220ULL, 0x040fe20000410000ULL, 0x0000001f2f1f7220ULL, 0x040fe20000410000ULL,
0x000000142f147220ULL, 0x040fe20000410000ULL, 0x000000162f317220ULL, 0x040fe20000410000ULL,
0x000000172f327220ULL, 0x040fe20000410000ULL, 0x000000232f237220ULL, 0x040fe20000410000ULL,
0x000000182f187220ULL, 0x040fe20000410000ULL, 0x000000192f197220ULL, 0x040fe20000410000ULL,
0x0000001b2f307220ULL, 0x040fe20000410000ULL, 0x000000112f167220ULL, 0x040fe20000410000ULL,
0x0000000c2f177220ULL, 0x040fe20000410000ULL, 0x0000001c2f1c7220ULL, 0x040fe20000410000ULL,
0x000000102f007220ULL, 0x040fe20000410000ULL, 0x000000122f337220ULL, 0x040fe20000410000ULL,
0x000000132f347220ULL, 0x040fe20000410000ULL, 0x0000000e2f357220ULL, 0x040fe20000410000ULL,
0x0000000f2f367220ULL, 0x040fe20000410000ULL, 0x000000082f087220ULL, 0x040fe20000410000ULL,
0x000000092f097220ULL, 0x040fe20000410000ULL, 0x0000000a2f377220ULL, 0x040fe20000410000ULL,
0x0000000b2f387220ULL, 0x040fe20000410000ULL, 0x000000042f047220ULL, 0x040fe20000410000ULL,
0x000000052f057220ULL, 0x040fe20000410000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e001dULL,
0x000000062f067220ULL, 0x040fe20000410000ULL, 0x000000ffff117224ULL, 0x000fe200078e0015ULL,
0x000000072f077220ULL, 0x000fe20000410000ULL, 0x000000ffff157224ULL, 0x000fc400078e001aULL,
0x000000ffff1d7224ULL, 0x000fe400078e001eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff107224ULL, 0x000fe200078e0014ULL,
0x8000000027ff7812ULL, 0x002fe20007804825ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0022ULL,
0x000000ffff1e7224ULL, 0x000fc400078e001fULL, 0x000000ffff0e7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0019ULL, 0x000000ffff137224ULL, 0x000fe400078e0016ULL,
0x000000ffff147224ULL, 0x000fe400078e0017ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0023ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0026ULL, 0x000000ffff207224ULL, 0x000fe400078e0030ULL,
0x000000ffff217224ULL, 0x000fe400078e0031ULL, 0x000000ffff227224ULL, 0x000fe400078e0032ULL,
0x000000ffff0c7224ULL, 0x000fe400078e001cULL, 0x000000ffff127224ULL, 0x000fe400078e0000ULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff237224ULL, 0x000fe400078e0033ULL, 0x000000ffff267224ULL, 0x000fe400078e0034ULL,
0x000000ffff277224ULL, 0x000fc400078e0035ULL, 0x000000ffff307224ULL, 0x000fe400078e0036ULL,
0x000000ffff317224ULL, 0x000fe400078e0037ULL, 0x000000ffff327224ULL, 0x000fe200078e0038ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff337224ULL, 0x000fe400078e0006ULL, 0x000000ffff347224ULL, 0x000fe200078e0007ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004003d057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000042d1c7824ULL, 0x000fe200078e00ffULL, 0x000000402b00720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x000000802e007824ULL, 0x000fca00078e0205ULL,
0x0104000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000022d087824ULL, 0x000fe400078e00ffULL, 0x000000012c437824ULL, 0x000fc600078e0a43ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108247812ULL, 0x040fe400078efcffULL,
0x0000000808367812ULL, 0x000fe400078efcffULL, 0x000000432400720cULL, 0x080fe40003f26070ULL,
0x0000001008247812ULL, 0x000fe400078efcffULL, 0x000000433600720cULL, 0x080fe40003f06070ULL,
0x000000432400720cULL, 0x000fc40003fc6070ULL, 0x0000001108367812ULL, 0x040fe400078efcffULL,
0x0000001808247812ULL, 0x040fe400078efcffULL, 0x000000430800720cULL, 0x080fe40003f46070ULL,
0x000000433600720cULL, 0x080fe40003fa6070ULL, 0x000000432400720cULL, 0x000fe40003f66070ULL,
0x0000000908387812ULL, 0x000fc400078efcffULL, 0x0000001908367812ULL, 0x040fe400078efcffULL,
0x0000002008247812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000433800720cULL, 0x080fe40003f86070ULL,
0x000000433600720cULL, 0x080fe40003f46070ULL, 0x000000432400720cULL, 0x000fe40003f26070ULL,
0x0000002108367812ULL, 0x040fe400078efcffULL, 0x0000002808247812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000433600720cULL, 0x080fe40003f06070ULL, 0x000000432400720cULL, 0x000fe40003f86070ULL,
0x0000002908367812ULL, 0x000fc400078efcffULL, 0x0000003008247812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000433600720cULL, 0x000fc40003fc6070ULL, 0x000000432400720cULL, 0x000fe40003fa6070ULL,
0x0000003108367812ULL, 0x040fe400078efcffULL, 0x0000003808247812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000433600720cULL, 0x080fe40003f66070ULL,
0x000000432400720cULL, 0x000fc40003f46070ULL, 0x000000430800720cULL, 0x000fe40003f26070ULL,
0xff7fffff26267808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff27277808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff30307808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff31317808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff32327808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff33337808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff34347808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff397424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000002605047209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x0000002704057209ULL, 0x000fc40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x0000003005047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000003104057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000003205047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000003304057209ULL, 0x000fe40007810000ULL,
0x0000001908357209ULL, 0x000fe40007810000ULL, 0x0000003405377209ULL, 0x000fe20007810000ULL,
0x00001a927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0035047f89ULL, 0x0004e400000e0000ULL,
0x0000000435357209ULL, 0x00cfe20007810000ULL, 0x00001ac27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0037047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007247f89ULL, 0x000f2200000e0000ULL, 0x0000000437087209ULL, 0x004fc60007810000ULL,
0x0c201f0035047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000002407247209ULL, 0x010fc60007810000ULL,
0x0c201f0009367f89ULL, 0x002e6800000e0000ULL, 0x0c201f0024257f89ULL, 0x00092200000e0000ULL,
0x0000000435047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000003609067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fc40000000000ULL, 0x00000005ff367e24ULL, 0x002fe2000f8e00ffULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3f8000003636783eULL, 0x000fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x000000ffff377224ULL, 0x000fe200078e0036ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b34197823ULL, 0x000fe20000010819ULL, 0x0000000000087886ULL, 0x000fc400038e0100ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000010ffULL, 0x0000001d000b7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ee20000000800ULL, 0x0000001a1b09723eULL, 0x002fce00000010ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x008fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x000000360838723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000360c38723cULL, 0x000fee0000041838ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe200000010ffULL, 0x0000000fff157424ULL, 0x000fe200078e00ffULL,
0xfffffffc2d147812ULL, 0x000fc800078ec0ffULL, 0x00000014156a7219ULL, 0x000fe200000006ffULL,
0x0000002700277308ULL, 0x000fe60000000800ULL, 0x000000006a1b73a1ULL, 0x000ee200000e8000ULL,
0x000000006a0573c4ULL, 0x000f280000004000ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x000000232611723eULL, 0x002fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000273013723eULL, 0x004fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000086aff7c12ULL, 0x008fe2000f80401bULL, 0x000000361038723cULL, 0x000fec0000041838ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000010ffULL,
0x0000002425077209ULL, 0x010fca0007810000ULL, 0x0000003300337308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000313215723eULL, 0x002fe400000010ffULL,
0x000000331a17723eULL, 0x004fce00000010ffULL, 0x000000361438723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000015d205008947ULL, 0x000fde000b800000ULL,
0x001c1fff38187589ULL, 0x0002a400000e0000ULL, 0x000000006a1973a1ULL, 0x000ee200000e8000ULL,
0x000000006a0573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x000000086aff7c12ULL, 0x008fda000f804019ULL, 0x000015e205008947ULL, 0x010fea000b800000ULL,
0x001c1fff3a197589ULL, 0x00072800000e0000ULL, 0x001c1fff011a7589ULL, 0x00066800000e0000ULL,
0x001c1fff1b1b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x000fe4000001162dULL,
0x0000000c1c3b7812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x000000032dff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d367824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4c7824ULL, 0x000fe200078e00ffULL, 0x000000021f247812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f267812ULL, 0x000fc400078ef61eULL,
0x000000041f307812ULL, 0x140fe400078ef61eULL, 0x000000051f327812ULL, 0x140fe400078ef61eULL,
0x000000061f347812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x0000a0002e1d7811ULL, 0x000fe400078e58ffULL,
0xfffffff823387812ULL, 0x102fe400078ee21eULL, 0x000000011f3a7812ULL, 0x148fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x0000001024207824ULL, 0x100fe200078e021dULL, 0x000000021f427812ULL, 0x140fe200078ef61eULL,
0x0000001030247824ULL, 0x100fe200078e021dULL, 0x000000031f447812ULL, 0x140fe200078ef61eULL,
0x0000001034307824ULL, 0x100fe200078e021dULL, 0x000000041f467812ULL, 0x140fe200078ef61eULL,
0x000000103a347824ULL, 0x100fe200078e021dULL, 0x000000051f487812ULL, 0x140fe200078ef61eULL,
0x0000001042357824ULL, 0x100fe200078e021dULL, 0x000000061f4a7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001026227824ULL, 0x100fe400078e021dULL,
0x0000001032267824ULL, 0x100fe400078e021dULL, 0x000000013b1f7824ULL, 0x000fe400078e021cULL,
0x0000001036327824ULL, 0x100fe400078e021dULL, 0x00000010381c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x0000001044367824ULL, 0x000fc400078e021dULL,
0x0000001046377824ULL, 0x100fe400078e021dULL, 0x0000001048387824ULL, 0x100fe400078e021dULL,
0x000000104a397824ULL, 0x100fe400078e021dULL, 0x000000104c3a7824ULL, 0x000fe400078e021dULL,
0x000000013b1d7824ULL, 0x040fe400078e021eULL, 0x000000013b217824ULL, 0x000fc400078e0220ULL,
0x000000013b237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x000000013b257824ULL, 0x040fe400078e0224ULL, 0x000000013b277824ULL, 0x040fe200078e0226ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x000000013b317824ULL, 0x040fe400078e0230ULL,
0x000000013b337824ULL, 0x040fe200078e0232ULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x000000013b1c7824ULL, 0x000fc400078e021cULL, 0x000000013b347824ULL, 0x040fe200078e0234ULL,
0x0000001025007388ULL, 0x0007e20000000800ULL, 0x000000013b1e7824ULL, 0x040fe400078e0235ULL,
0x000000013b367824ULL, 0x040fe200078e0236ULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x000000013b087824ULL, 0x042fe400078e0237ULL, 0x000000013b387824ULL, 0x040fe200078e0238ULL,
0x0000001431007388ULL, 0x0007e20000000800ULL, 0x000000013b207824ULL, 0x000fc400078e0239ULL,
0x000000013b3a7824ULL, 0x000fe200078e023aULL, 0x0000001633007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b34007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f36007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x0000001338007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x000000173a007388ULL, 0x0007e80000000800ULL,
0x0100000400008388ULL, 0x0007e80000000c00ULL, 0x0102001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008003fff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010003fff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000003002b2b7a10ULL, 0x000fe20007ffe0ffULL,
0x000018003fff7f8cULL, 0x0003e6000c80043fULL, 0x000000292b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb64000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff317807ULL, 0x008fe40004800000ULL,
0x0001e6e000307802ULL, 0x000fe40000000f00ULL, 0x000011a000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e003cULL, 0xfffe310000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x000fe40004800000ULL, 0x0001e73000307802ULL, 0x000fe40000000f00ULL,
0x0000115000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff057224ULL, 0x000fe200078e003cULL,
0xfffe313000007947ULL, 0x000fea000383ffffULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001e790005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x000010b000007944ULL, 0x03efea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0062ULL,
0xfffe317000007947ULL, 0x000fea000383ffffULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001e7f0005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000105000007944ULL, 0x034fea0003c00000ULL, 0xfffe315000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0004ULL, 0x0001e850005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000ff000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff757224ULL, 0x004fe200078e0062ULL,
0xfffe34c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001e8c0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000f8000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff747224ULL, 0x004fe200078e0062ULL, 0xfffe348000007947ULL, 0x000fea000383ffffULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001e920005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000f2000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff897224ULL, 0x004fe200078e0062ULL, 0xfffe5ad000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001e990005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000eb000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff8a7224ULL, 0x004fe200078e0062ULL,
0xfffe5a8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x008fe40004800000ULL,
0x0001e9e000307802ULL, 0x000fe40000000f00ULL, 0x00000ea000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e003cULL, 0xfffe807000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x000fe40004800000ULL, 0x0001ea3000307802ULL, 0x000fe40000000f00ULL,
0x00000e5000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e003cULL,
0xfffe80a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff677424ULL, 0x002fe200078e00ffULL,
0x0001ea90005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000db000007944ULL, 0x034fea0003c00000ULL, 0xfffe810000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001eaf0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000d5000007944ULL, 0x030fea0003c00000ULL, 0xfffe81c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001eb40005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000d0000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff737224ULL, 0x004fe200078e0062ULL, 0xfffe842000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001ebb0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000c9000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff747224ULL, 0x004fe200078e0062ULL,
0xfffe83d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001ec10005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000c3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff877224ULL, 0x004fe200078e0062ULL,
0xfffea7c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001ec80005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000bc000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff867224ULL, 0x004fe200078e0062ULL, 0xfffea77000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x008fe40004800000ULL, 0x0001ecd000307802ULL, 0x000fe40000000f00ULL,
0x00000bb000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e003cULL,
0xfffecce000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x000fe40004800000ULL,
0x0001ed2000307802ULL, 0x000fe40000000f00ULL, 0x00000b6000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e003cULL, 0xfffecd1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff677424ULL, 0x002fe200078e00ffULL, 0x0001ed80005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000ac000007944ULL, 0x034fea0003c00000ULL,
0xfffecd7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001ede0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000a6000007944ULL, 0x030fea0003c00000ULL,
0xfffece3000007947ULL, 0x000fea000383ffffULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001ee30005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000a1000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff737224ULL, 0x004fe200078e0062ULL,
0xfffed09000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001eea0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000009a000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff747224ULL, 0x004fe200078e0062ULL, 0xfffed04000007947ULL, 0x000fea000383ffffULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001ef00005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000094000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff877224ULL, 0x004fe200078e0062ULL, 0xfffef42000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001ef70005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x000008d000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff867224ULL, 0x004fe200078e0062ULL,
0xfffef3d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x008fe40004800000ULL,
0x0001efc000307802ULL, 0x000fe40000000f00ULL, 0x000008c000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e003cULL, 0xffff194000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x000fe40004800000ULL, 0x0001f01000307802ULL, 0x000fe40000000f00ULL,
0x0000087000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e003cULL,
0xffff197000007947ULL, 0x000fea000383ffffULL, 0x0000001fff677424ULL, 0x004fe200078e00ffULL,
0x0001f070005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x000007d000007944ULL, 0x032fea0003c00000ULL, 0xffff19d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001f0d0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0000077000007944ULL, 0x030fea0003c00000ULL, 0xffff1a9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001f120005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0000072000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff697224ULL, 0x004fe200078e0062ULL, 0xffff1cf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001f190005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x000006b000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff1e7224ULL, 0x004fe200078e0062ULL,
0xffff1ca000007947ULL, 0x000fea000383ffffULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001f1f0005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000065000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff697224ULL, 0x004fe200078e0062ULL,
0xffff40b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001f260005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000005e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff647224ULL, 0x004fe200078e0062ULL, 0xffff406000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e0035ULL, 0x0001f2c000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x000fe400078e00ffULL, 0x0000054000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0025ULL, 0xffffe52000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e0037ULL, 0x0001f32000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x002fe400078e00ffULL, 0x000004e000007944ULL, 0x020fea0003c00000ULL,
0x0000002537387209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x0001f37000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x002fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0007ULL, 0x0001f3c000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x002fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000002507247209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0035ULL,
0x0001f41000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x002fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000002535047209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0038ULL, 0x0001f46000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x002fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000002538057209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x0001f4b000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x002fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0024ULL, 0x0001f50000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x002fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0xffffe3e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x000fe200078e0038ULL,
0x0001f560005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff6c7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff677424ULL, 0x000fe400078e00ffULL, 0x000002e000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0062ULL, 0xffffe9d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff637224ULL, 0x002fe200078e003aULL, 0x0001f5d0005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff6c7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff677424ULL, 0x000fe400078e00ffULL,
0x0000027000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e00ffULL,
0x0001f620005c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff677424ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x004fe400078e0062ULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e00ffULL, 0x0001f670005c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff677424ULL, 0x000fc400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e0062ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0062ULL,
0xffffe94000007947ULL, 0x000fea000383ffffULL, 0x0180000033037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003300038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff187807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000318ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff33ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000033057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000318ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003300037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe080004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003a00007348ULL, 0x000fe80003800000ULL,
0x0c00003625257389ULL, 0x0002a200000e0039ULL, 0xfffe07c008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff5d7424ULL, 0x000fe200078e00ffULL, 0x0000006a00007348ULL, 0x000fe80003800000ULL,
0x0000006c63627389ULL, 0x0002a200000e0067ULL, 0xfffe07805c007950ULL, 0x000fea0003c3ffffULL,
0x000000013100780cULL, 0x000fe20003f25070ULL, 0x0000006400007348ULL, 0x000fd80003800000ULL,
0x0000000000317806ULL, 0x000fc800048e0100ULL, 0x00000064313c7212ULL, 0x000fe200078ec0ffULL,
0x00000000ff317424ULL, 0x000fc800078e00ffULL, 0xfffe072030007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000358ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000938ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001558ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001578ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001588ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015a8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001638ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001640ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001650ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x000000000001f980ULL, 0xf400001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021200ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000021210ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021210ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000021690ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001638ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001fbc8ULL, 0x000000000001fbc8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000021200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000021690ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_86_cubin_len = 137072;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
