/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000021690ULL, 0x0000000000021210ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001f790ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001f900ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000001f940ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000001f980ULL,
0x0000000000000100ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001fa80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001f79000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x007c7c0400288080ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x95082880808e0828ULL, 0x2880809608288080ULL, 0x80b008288080a508ULL, 0x162880809a082880ULL,
0x0000031028808280ULL, 0x9a92000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001f79000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808e0828808081ULL, 0x9608288080950828ULL, 0x2880809a08288080ULL,
0x80b008288080a508ULL, 0x162880808c082880ULL, 0x0000031028808280ULL, 0x8c92000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL, 0x0001f90000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x95082880808e0828ULL, 0x2880809608288080ULL, 0x80a5082880809a08ULL, 0x16288080b0082880ULL,
0x0000031028808280ULL, 0xb092000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000019000000000ULL, 0x0001f94000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x95082880808e0828ULL, 0x2880809608288080ULL,
0x80a5082880809a08ULL, 0x16288080b0082880ULL, 0x0000031028808280ULL, 0xb092000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000022000000000ULL, 0x0001f98000000000ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL, 0x00081204000000feULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000020001c3104ULL, 0x0001dd600001d8d0ULL, 0x0001dee00001dd70ULL, 0x0001df000001def0ULL,
0xffffffff01c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000033ffffffffULL, 0x0500003305000033ULL, 0xffffffff05000033ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01c82804ffffffffULL, 0x000000f0000000e0ULL, 0x00001870000017f0ULL,
0x0000194000001910ULL, 0x00001d5000001d20ULL, 0x00001e3000001dc0ULL, 0x0000442000004400ULL,
0x000044e000004480ULL, 0x00006ae000006a60ULL, 0x00006cb000006b90ULL, 0x00006f9000006f70ULL,
0x0000705000006ff0ULL, 0x00009400000093e0ULL, 0x000094c000009460ULL, 0x0000ba400000b9c0ULL,
0x0000bc100000baf0ULL, 0x0000bef00000bed0ULL, 0x0000bfb00000bf50ULL, 0x0000e3600000e340ULL,
0x0000e4200000e3c0ULL, 0x000109a000010920ULL, 0x00010b7000010a50ULL, 0x00010e5000010e30ULL,
0x00010f1000010eb0ULL, 0x000132e0000132c0ULL, 0x000133a000013340ULL, 0x0001538000015370ULL,
0x0001766000015b00ULL, 0x00017e00000178e0ULL, 0x0001867000017e30ULL, 0x0001d7b00001d780ULL,
0x0001d7d00001d7c0ULL, 0x0001d8100001d7f0ULL, 0x0001d8400001d830ULL, 0x0001df300001ded0ULL,
0x0001df500001df40ULL, 0x0001e6d00001e670ULL, 0x0001e7900001e730ULL, 0x0001e8600001e7f0ULL,
0x0001e9300001e8c0ULL, 0x0001e9e00001e990ULL, 0x0001eab00001ea40ULL, 0x0001eb700001eb00ULL,
0x0001ec400001ebd0ULL, 0x0001ecf00001eca0ULL, 0x0001edc00001ed50ULL, 0x0001ee800001ee10ULL,
0x0001ef500001eee0ULL, 0x0001f0100001efb0ULL, 0x0001f0d00001f070ULL, 0x0001f1900001f120ULL,
0x0001f2600001f1f0ULL, 0x0001f3600001f2e0ULL, 0x0001f4400001f3d0ULL, 0x0001f5200001f4b0ULL,
0x0001f6000001f590ULL, 0x0001f6d00001f660ULL, 0x0001f7700001f720ULL, 0x000001d007003904ULL,
0x00010600000000ffULL, 0x00000200003f0100ULL, 0x0001060800000003ULL, 0x000002c0003f0120ULL,
0x0001068800000003ULL, 0x00000390003f0120ULL, 0x000106a800000003ULL, 0x000003c0003f0120ULL,
0x000106b8000000ffULL, 0x00000500003f0100ULL, 0x00010600000000ffULL, 0x000006a0003f0107ULL,
0x0001068c00000008ULL, 0x00000750003f0102ULL, 0x0001068800000008ULL, 0x00000c80003f0101ULL,
0x000106a8000000ffULL, 0x00000d00003f0107ULL, 0x000106a8000000ffULL, 0x00000d60003f0101ULL,
0x000106b8000000ffULL, 0x00000ed0003f0101ULL, 0x000106bc000000ffULL, 0x00000f20003f0105ULL,
0x000106bc000000ffULL, 0x00000fa0003f0105ULL, 0x000106bc000000ffULL, 0x00001570003f0105ULL,
0x000106b0000000ffULL, 0x000015f0003f0107ULL, 0x000106b0000000ffULL, 0x00001600003f0101ULL,
0x000106ac000000ffULL, 0x00001670003f0105ULL, 0x0001060800000008ULL, 0x00001690003f0101ULL,
0x0001060c00000008ULL, 0x00001720003f0105ULL, 0x0001060c00000008ULL, 0x00001c00003f0105ULL,
0x000106ac000000ffULL, 0x00001c80003f0105ULL, 0x000106ac000000ffULL, 0x00003d20003f0105ULL,
0x000106b8000000ffULL, 0x00003d30003f0101ULL, 0x000106bc000000ffULL, 0x00003d80003f0105ULL,
0x000106bc000000ffULL, 0x00003e00003f0105ULL, 0x000106bc000000ffULL, 0x00004200003f0105ULL,
0x000106a8000000ffULL, 0x00004280003f0107ULL, 0x000106a8000000ffULL, 0x00004290003f0101ULL,
0x000106b4000000ffULL, 0x000042f0003f0105ULL, 0x000106b4000000ffULL, 0x00004370003f0105ULL,
0x000106b4000000ffULL, 0x000062e0003f0105ULL, 0x000106b8000000ffULL, 0x00006350003f0101ULL,
0x00010688000000ffULL, 0x00006380003f0101ULL, 0x000106bc000000ffULL, 0x000063d0003f0105ULL,
0x000106bc000000ffULL, 0x00006450003f0105ULL, 0x000106bc000000ffULL, 0x00006820003f0105ULL,
0x000106b0000000ffULL, 0x000068a0003f0107ULL, 0x000106b0000000ffULL, 0x000068b0003f0101ULL,
0x000106ac000000ffULL, 0x00006920003f0105ULL, 0x0001062800000008ULL, 0x00006940003f0101ULL,
0x0001062c00000008ULL, 0x000069d0003f0105ULL, 0x0001062c00000008ULL, 0x00006e60003f0105ULL,
0x000106ac000000ffULL, 0x00006ee0003f0105ULL, 0x000106ac000000ffULL, 0x00008df0003f0105ULL,
0x000106b8000000ffULL, 0x00008e00003f0101ULL, 0x000106bc000000ffULL, 0x00008e50003f0105ULL,
0x000106bc000000ffULL, 0x00008ed0003f0105ULL, 0x000106bc000000ffULL, 0x000091e0003f0105ULL,
0x000106a8000000ffULL, 0x00009260003f0107ULL, 0x000106a8000000ffULL, 0x00009270003f0101ULL,
0x000106b4000000ffULL, 0x000092d0003f0105ULL, 0x000106b4000000ffULL, 0x00009350003f0105ULL,
0x000106b4000000ffULL, 0x0000b240003f0105ULL, 0x000106b8000000ffULL, 0x0000b2b0003f0101ULL,
0x00010690000000ffULL, 0x0000b2e0003f0101ULL, 0x000106bc000000ffULL, 0x0000b330003f0105ULL,
0x000106bc000000ffULL, 0x0000b3b0003f0105ULL, 0x000106bc000000ffULL, 0x0000b780003f0105ULL,
0x000106b0000000ffULL, 0x0000b800003f0107ULL, 0x000106b0000000ffULL, 0x0000b810003f0101ULL,
0x000106ac000000ffULL, 0x0000b880003f0105ULL, 0x0001064800000008ULL, 0x0000b8a0003f0101ULL,
0x0001064c00000008ULL, 0x0000b930003f0105ULL, 0x0001064c00000008ULL, 0x0000bdc0003f0105ULL,
0x000106ac000000ffULL, 0x0000be40003f0105ULL, 0x000106ac000000ffULL, 0x0000dd50003f0105ULL,
0x000106b8000000ffULL, 0x0000dd60003f0101ULL, 0x000106bc000000ffULL, 0x0000ddb0003f0105ULL,
0x000106bc000000ffULL, 0x0000de30003f0105ULL, 0x000106bc000000ffULL, 0x0000e140003f0105ULL,
0x000106a8000000ffULL, 0x0000e1c0003f0107ULL, 0x000106a8000000ffULL, 0x0000e1d0003f0101ULL,
0x000106b4000000ffULL, 0x0000e230003f0105ULL, 0x000106b4000000ffULL, 0x0000e2b0003f0105ULL,
0x000106b4000000ffULL, 0x000101a0003f0105ULL, 0x000106b8000000ffULL, 0x00010210003f0101ULL,
0x00010698000000ffULL, 0x00010240003f0101ULL, 0x000106bc000000ffULL, 0x00010290003f0105ULL,
0x000106bc000000ffULL, 0x00010310003f0105ULL, 0x000106bc000000ffULL, 0x000106e0003f0105ULL,
0x000106b0000000ffULL, 0x00010760003f0107ULL, 0x000106b0000000ffULL, 0x00010770003f0101ULL,
0x000106ac000000ffULL, 0x000107e0003f0105ULL, 0x0001066800000008ULL, 0x00010800003f0101ULL,
0x0001066c00000008ULL, 0x00010890003f0105ULL, 0x0001066c00000008ULL, 0x00010d20003f0105ULL,
0x000106ac000000ffULL, 0x00010da0003f0105ULL, 0x000106ac000000ffULL, 0x00012ca0003f0105ULL,
0x000106b8000000ffULL, 0x00012cb0003f0101ULL, 0x000106bc000000ffULL, 0x00012d00003f0105ULL,
0x000106bc000000ffULL, 0x00012d80003f0105ULL, 0x000106bc000000ffULL, 0x000130c0003f0105ULL,
0x000106a8000000ffULL, 0x00013140003f0107ULL, 0x000106a8000000ffULL, 0x00013150003f0101ULL,
0x000106b4000000ffULL, 0x000131b0003f0105ULL, 0x000106b4000000ffULL, 0x00013230003f0105ULL,
0x000106b4000000ffULL, 0x00015120003f0105ULL, 0x000106b8000000ffULL, 0x00015180003f0101ULL,
0x000106a0000000ffULL, 0x000189b0003f0101ULL, 0x00010600000000ffULL, 0x000197b0003f0101ULL,
0x00010604000000ffULL, 0x00019850003f0105ULL, 0x00010604000000ffULL, 0x00019b70003f0105ULL,
0x00010600000000ffULL, 0x00019b80003f0101ULL, 0x00010604000000ffULL, 0x00019c10003f0105ULL,
0x00010604000000ffULL, 0x0001cc60003f0105ULL, 0x000000000000003cULL, 0x0001cc90003f0101ULL,
0x000000040000003cULL, 0x0001d0a0003f0105ULL, 0x000000040000003cULL, 0x0001e4c0003f0105ULL,
0x000000000000003eULL, 0x0001e520003f0101ULL, 0x000000080000003eULL, 0x0001e580003f0101ULL,
0x000000100000003eULL, 0x0001e5f0003f0101ULL, 0x000000180000003eULL, 0x00053803003f0101ULL,
0x000188c000101c04ULL, 0x00019d2000019c70ULL, 0x000004010001e630ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000029cULL, 0x0000001200000002ULL, 0x000000000000020cULL, 0x0000001200000002ULL,
0x000000000000017cULL, 0x0000001200000002ULL, 0x00000000000000ecULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000276ULL, 0x0000001200000002ULL,
0x00000000000001e6ULL, 0x0000001200000002ULL, 0x0000000000000156ULL, 0x0000001200000002ULL,
0x00000000000000c6ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000047919ULL, 0x000ea20000002300ULL, 0x0000001300067300ULL, 0x000ee200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000037919ULL, 0x000f220000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x0000001300137309ULL, 0x000f660000000000ULL, 0x0000000000f97919ULL, 0x000f680000002600ULL,
0x00000000000c7919ULL, 0x000f620000002700ULL, 0x00000005ff007819ULL, 0x002fc60000011605ULL,
0x00001fff040d7589ULL, 0x0043e800000e0000ULL, 0x00001fff00007589ULL, 0x000ea200000e0000ULL,
0x0000000104027824ULL, 0x010fe200078e0203ULL, 0x000000070600720cULL, 0x008fc60003f02070ULL,
0x0000008002037824ULL, 0x000fe400078e0205ULL, 0x0000000000027919ULL, 0x000ee60000000000ULL,
0x000000ff0300720cULL, 0x040fe40003f25270ULL, 0x0000000f0300780cULL, 0x040fe40003f44070ULL,
0x0000007f0300780cULL, 0x040fe40003f84070ULL, 0x000000030300780cULL, 0x000fce0003f64070ULL,
0x3fffff80ff049424ULL, 0x002fe400078e00ffULL, 0x000000040d087824ULL, 0x004fe400078e0200ULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff06a424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0x00000002080a7824ULL, 0x000fc400078e00ffULL, 0xff317217ff10c424ULL, 0x000fe200078e00ffULL,
0x010608060300a388ULL, 0x0005e20000008a00ULL, 0x000000010300780cULL, 0x000fe20003f44070ULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x000000080a0b7817ULL, 0x040fe20007800000ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x000000010a127810ULL, 0x040fe20007ffe0ffULL,
0x010400100300c388ULL, 0x000fe20000004800ULL, 0x000000070a057812ULL, 0x002fe200078ec0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0a0aULL, 0x00000007120f7812ULL, 0x000fe200078ec0ffULL,
0x00000008f90b7824ULL, 0x020fe200078e00ffULL, 0x0000001f05057812ULL, 0x108fe200078e7802ULL,
0x010688080300b388ULL, 0x0003e20000008a00ULL, 0x000000ff0e00720cULL, 0x000fe20003f63070ULL,
0x000000050c0b7c24ULL, 0x000fe2000f8e020bULL, 0x000000010e00780cULL, 0x000fe20003f83070ULL,
0x000000200a0e7824ULL, 0x000fe200078e0205ULL, 0x0000001f0f0f7812ULL, 0x000fe200078e7802ULL,
0x000000010b047824ULL, 0x000fc400078e020aULL, 0x000000010b067824ULL, 0x004fe400078e0212ULL,
0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL, 0x3fffff00ff08a424ULL, 0x002fe400078e00ffULL,
0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe400078e00ffULL,
0x00000200ff077424ULL, 0x000fe200078e00ffULL, 0x0106a8080300a388ULL, 0x0003e20000008a00ULL,
0x0000001002107824ULL, 0x000fc400078e00ffULL, 0x00005c0004047625ULL, 0x080fe200078e0007ULL,
0x0106b80aff009388ULL, 0x0005e40000000a00ULL, 0x000001f010117812ULL, 0x000fe200078ec0ffULL,
0x00005c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000001104047210ULL, 0x080fe20007fbe0ffULL, 0x0000002012127824ULL, 0x000fe200078e020fULL,
0x0000001106067210ULL, 0x000fe20007f5e0ffULL, 0x000000100e0f7824ULL, 0x000fc400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fe400078e0a13ULL, 0x000000ffff057224ULL, 0x000fe400028e0605ULL,
0x000000ffff077224ULL, 0x000fe400010e0607ULL, 0x0000001012117824ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x002fe400078e000eULL, 0x00000004ff137424ULL, 0x000fc800078e00ffULL,
0x000062000c087625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0005e8000d901c46ULL, 0x0000000006117faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01060403ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000608037981ULL, 0x004ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000e620000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000005ff047e24ULL, 0x002fe2000f8e00ffULL,
0x0000003f03057810ULL, 0x004fc40007ffe0ffULL, 0x000000ff03067810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff057819ULL, 0x000fe40000011605ULL, 0x00000008ff067819ULL, 0x000fca0000011606ULL,
0x000182c000008947ULL, 0x000fea0003800000ULL, 0x0000000404077824ULL, 0x000fe400078e00ffULL,
0x0000000800087824ULL, 0x000fe400078e00ffULL, 0x00000003ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000050700720cULL, 0x000fda0003f06070ULL, 0x00006400070a8a10ULL, 0x000fe20007ffe0ffULL,
0x000000020c098824ULL, 0x000fc800078e00ffULL, 0x00006400090a8a24ULL, 0x000fe400078e020aULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0d08ff738cULL, 0x0003e20000000000ULL, 0x000060000a0a8625ULL, 0x000fe200078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a098981ULL, 0x0004e2000c1e1900ULL,
0x00000004ff0f7819ULL, 0x000fe20000011602ULL, 0x00000100040e7824ULL, 0x040fe200078e00ffULL,
0x00000001040d7810ULL, 0x002fe20007ffe0ffULL, 0x0106880008ff7f8cULL, 0x0003e2000c80043fULL,
0x000000020f127810ULL, 0x040fe20007ffe0ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000040f147810ULL, 0x000fe20007ffe0ffULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x0000000108117824ULL, 0x040fe200078e0212ULL,
0x0000000e030d7217ULL, 0x000fe20007800000ULL, 0x0000000108157824ULL, 0x040fe200078e0214ULL,
0x000000060f177810ULL, 0x000fe20007ffe0ffULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000711137812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a0eULL,
0x00000007150b7812ULL, 0x004fe200078ec0ffULL, 0x0000000108187824ULL, 0x040fe200078e0217ULL,
0x0000000f130a7812ULL, 0x000fe200078e7802ULL, 0x00000001080e7824ULL, 0x000fe200078e020fULL,
0x000000200d0d7807ULL, 0x000fe20000000000ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000001011137824ULL, 0x000fe200078e020aULL,
0x0000000f0b0a7812ULL, 0x000fe200078e7802ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000718117812ULL, 0x000fe200078ec0ffULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x000000070e0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001015167824ULL, 0x000fe200078e020aULL,
0x0000000f11117812ULL, 0x100fe200078e7802ULL, 0x000000ffff517224ULL, 0x000fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fc400078e7802ULL, 0x0000000d080d7217ULL, 0x000fe20007800000ULL,
0x0000001018187824ULL, 0x000fe400078e0211ULL, 0x000000100e117824ULL, 0x000fe400078e020bULL,
0x000000010d0d7824ULL, 0x000fe400078e0a08ULL, 0x00000040f90b7824ULL, 0x000fc600078e020eULL,
0x0000000d0f00720cULL, 0x080fe40003f26070ULL, 0x000000020b0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000040b157810ULL, 0x000fe40007ffe0ffULL, 0x0000000d1200720cULL, 0x080fe40003f46070ULL,
0x0000000d1400720cULL, 0x000fe20003f06070ULL, 0x00005800090a7a24ULL, 0x008fc800078e02ffULL,
0x000000400a0a7824ULL, 0x000fca00078e00ffULL, 0x0000000b0a1c7210ULL, 0x040fe40007f7e0ffULL,
0x0000000f0a197210ULL, 0x000fe40007f9e0ffULL, 0x000000060b0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x00005e001c1a7a11ULL, 0x040fe200078640ffULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x00005e00190f7a11ULL, 0x000fe400078840ffULL,
0x00005f001c1c7a11ULL, 0x000fc400018f441bULL, 0x000000150a157210ULL, 0x040fe40007f7e0ffULL,
0x0000000b0a0a7210ULL, 0x000fe40007fbe0ffULL, 0x00005f0019197a11ULL, 0x000fe200020f440eULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x00005e0015127a11ULL, 0x000fe200078840ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e06ffULL, 0x000000f0101b7812ULL, 0x000fe400078ec0ffULL,
0x00005e000a147a11ULL, 0x000fc400078a40ffULL, 0x00005f0015157a11ULL, 0x000fe400020f440eULL,
0x0000001a1b0e7210ULL, 0x000fe40007f9e0ffULL, 0x00005f000a0a7a11ULL, 0x000fe400028f440bULL,
0x0000001b0f107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e061cULL,
0x0000000d1700720cULL, 0x000fe40003f66070ULL, 0x0000c000110b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff117224ULL, 0x000fe200028e0619ULL, 0x0000001b12127210ULL, 0x000fc40007f9e0ffULL,
0x0000001b14147210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0005e2000c901c46ULL, 0x0000c000130d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff137224ULL, 0x000fe200020e0615ULL, 0x0000c00016177811ULL, 0x000fe200078e20ffULL,
0x000000ffff157224ULL, 0x000fe200028e060aULL, 0x0000c00018197811ULL, 0x000fe200078e20ffULL,
0x00000000100d7faeULL, 0x0003e2000d101c46ULL, 0xff317217ff0a7424ULL, 0x000fc600078e00ffULL,
0x0000000012177faeULL, 0x0003e2000c101c46ULL, 0x000000060400720cULL, 0x000fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x004fe400078e00ffULL, 0x0000000014197faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff2e7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff0e7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff507224ULL, 0x000fe200078e00ffULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x000143d000000947ULL, 0x000fea0003800000ULL, 0x000000020c0d7824ULL, 0x002fe400078e00ffULL,
0x0000000400f77824ULL, 0x000fc400078e00ffULL, 0x00006400ff0c7624ULL, 0x000fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x004fe200078e002fULL, 0x00000002f7f87810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff317224ULL, 0x008fe400078e000fULL, 0x000064000d0c7624ULL, 0x000fe400078e020cULL,
0xff317217ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3f7224ULL, 0x000fc400078e00ffULL,
0x00000100040e7824ULL, 0x000fca00078e00ffULL, 0x000000030e00720cULL, 0x000fda0003f06070ULL,
0x000142d000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d000e7305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x0000000e0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000003070e7812ULL, 0x000fe200078ec0ffULL, 0x00000300ff0d7624ULL, 0x000fe400078e00ffULL,
0x0000580009137a24ULL, 0x000fe200078e02ffULL, 0x000000030e00780cULL, 0x000fe20003f05270ULL,
0xfffffffd0f0d7424ULL, 0x000fe200078e020dULL, 0x00000004ff177819ULL, 0x000fe20000011602ULL,
0xffffffffff097424ULL, 0x000fc600078e00ffULL, 0x000000010d0e7807ULL, 0x000fca0004000000ULL,
0x0000000107077824ULL, 0x000fca00078e020eULL, 0x000000050700720cULL, 0x000fe20003f06070ULL,
0x00000001084d7824ULL, 0x000fe200078e0217ULL, 0x00000001040d7810ULL, 0x000fe40007ffe0ffULL,
0x00000020f9127811ULL, 0x000fd200078e30ffULL, 0x00000001070e8824ULL, 0x000fc800078e020cULL,
0x000060000e0e8625ULL, 0x000fe200078e000fULL, 0x0000002004107811ULL, 0x000fe400078e40ffULL,
0x000000074d1b7812ULL, 0x000fe400078ec0ffULL, 0x000000060e098981ULL, 0x000362000c1e1900ULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x0000004013157824ULL, 0x000fe200078e00ffULL,
0x0000000217f57810ULL, 0x000fe20007ffe0ffULL, 0x000000014d0d7824ULL, 0x000fe200078e0212ULL,
0x0000001003117217ULL, 0x000fe20007800000ULL, 0x0000001002227824ULL, 0x000fc400078e00ffULL,
0x0000000108137824ULL, 0x040fe200078e02f5ULL, 0x0000000f1b0e7812ULL, 0x002fe200078e7802ULL,
0x0000000111117824ULL, 0x000fe200078e0a10ULL, 0x0000000d151b7210ULL, 0x000fe40007f3e0ffULL,
0x00000006170f7810ULL, 0x000fe20007ffe0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e020eULL,
0x00000007131d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078240ffULL, 0x0000000108237824ULL, 0x000fe200078e020fULL,
0x0000000f1d4c7812ULL, 0x000fc400078e7802ULL, 0x00005f001b1b7a11ULL, 0x000fe200008f4410ULL,
0x0000000113107824ULL, 0x000fe200078e0212ULL, 0x00000004170e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010134c7824ULL, 0x000fe200078e024cULL, 0x0000002011117807ULL, 0x000fe40000000000ULL,
0x00000007231d7812ULL, 0x000fe200078ec0ffULL, 0x00000001081f7824ULL, 0x040fe200078e020eULL,
0x0000001108137217ULL, 0x000fe40007800000ULL, 0x0000000f1d467812ULL, 0x000fe200078e7802ULL,
0x000000011f117824ULL, 0x000fe200078e0212ULL, 0x00000010151d7210ULL, 0x000fe20007f5e0ffULL,
0x0000000113167824ULL, 0x000fe200078e0a08ULL, 0x000000071f217812ULL, 0x000fe200078ec0ffULL,
0x0000000123127824ULL, 0x000fe200078e0212ULL, 0x000000f022137812ULL, 0x000fe200078ec0ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078440ffULL,
0x0000001023467824ULL, 0x000fe200078e0246ULL, 0x0000000f21147812ULL, 0x000fc400078e7802ULL,
0x000000161700720cULL, 0x000fe40003f26070ULL, 0x0000001115177210ULL, 0x000fe20007f7e0ffULL,
0x000000101f477824ULL, 0x000fe200078e0214ULL, 0x00005f001d1d7a11ULL, 0x000fe400010f4418ULL,
0x0000001215187210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x00005e00171e7a11ULL, 0x000fe400078640ffULL, 0x000000131a1a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x00005e0018207a11ULL, 0x000fc400078a40ffULL,
0x00005f0017177a11ULL, 0x000fe200018f4414ULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x0000e0004d147811ULL, 0x000fe400078e20ffULL, 0x00005f0018187a11ULL, 0x000fe400028f4415ULL,
0x000000131c1c7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a147faeULL, 0x0003e2000c901c46ULL, 0x00000016f500720cULL, 0x080fe40003f46070ULL,
0x000000160e00720cULL, 0x080fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x000000160f00720cULL, 0x000fc40003f86070ULL, 0x000000131e1e7210ULL, 0x080fe40007f3e0ffULL,
0x0000001320207210ULL, 0x000fe40007fbe0ffULL, 0x0000e0004c157811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e0617ULL, 0x0000e00047167811ULL, 0x000fe200078e20ffULL,
0x000000ffff217224ULL, 0x000fe200028e0618ULL, 0x0000e00046177811ULL, 0x000fe200078e20ffULL,
0x000000001c157faeULL, 0x0003e8000d101c46ULL, 0x000000001e167faeULL, 0x0003e8000d901c46ULL,
0x0000000020177faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff287f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff1d7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060800081a7f8cULL, 0x000fe2000c80043fULL,
0x800000001dff7812ULL, 0x002fc6000784482eULL, 0x01060c00081f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000782481bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x00000018001c7305ULL, 0x0002e4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x0000001c0000735dULL, 0x008fe20003800000ULL,
0x01060c00081d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000782481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff1a7819ULL, 0x000fe40000011602ULL,
0x0000007022187812ULL, 0x000fe400078ec0ffULL, 0x0000000c1a1b7812ULL, 0x000fca00078ec0ffULL,
0x0000000118187824ULL, 0x000fca00078e021bULL, 0x01000000181b7984ULL, 0x000e680000000800ULL,
0x01020000181a7984ULL, 0x0007220000000800ULL, 0x0000000a1b00720bULL, 0x002fe20003f3d000ULL,
0x0001ce527f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x008fc800008e0100ULL,
0x0000ffff1c1d7812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f65270ULL, 0x0000000a1b00720bULL, 0x000fe20003f34000ULL,
0x0001ce327f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x000fe400008e0100ULL,
0x0000001b0a1f7209ULL, 0x000fe40007810000ULL, 0x0000ffff1c1c7812ULL, 0x000fe400078e3cffULL,
0x00000002ff587819ULL, 0x000fe20000011602ULL, 0x0104001f1800b388ULL, 0x0003e20000000800ULL,
0x8000001f0a0a7221ULL, 0x000fe20000010000ULL, 0x0000001c1dff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00327308ULL, 0x0002e20000000800ULL,
0x0001cdf27f007947ULL, 0x000fea000b800000ULL, 0x00001f58320a7589ULL, 0x00a2e400000e0000ULL,
0x0000000858587810ULL, 0x002fe20007ffe0ffULL, 0x0001ce227f007947ULL, 0x000fea000b800000ULL,
0x00001f58322f7589ULL, 0x00032400000e0000ULL, 0x8000001f1b1b1221ULL, 0x000fe20000010000ULL,
0x00000001ff707807ULL, 0x000fe20000800000ULL, 0x0000000a3d3d7220ULL, 0x088fe40000410000ULL,
0x3fb8aa3b1b1b1820ULL, 0x000fe40000410000ULL, 0x0000000a3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001b00191308ULL, 0x000ee20000000800ULL, 0x0000000a41417220ULL, 0x000fc40000410000ULL,
0x0000000a40407220ULL, 0x080fe40000410000ULL, 0x0000000a49497220ULL, 0x080fe40000410000ULL,
0x0000000a48487220ULL, 0x080fe40000410000ULL, 0x0000000a51517220ULL, 0x080fe40000410000ULL,
0x0000000a50507220ULL, 0x080fe40000410000ULL, 0x0000000a55557220ULL, 0x000fc40000410000ULL,
0x0000000a54547220ULL, 0x080fe40000410000ULL, 0x0000000a35357220ULL, 0x080fe40000410000ULL,
0x0000000a34347220ULL, 0x080fe40000410000ULL, 0x0000000a61617220ULL, 0x080fe40000410000ULL,
0x0000000a60607220ULL, 0x080fe40000410000ULL, 0x0000000a5d5d7220ULL, 0x000fc40000410000ULL,
0x0000000a5c5c7220ULL, 0x000fe40000410000ULL, 0x000000320b0b7220ULL, 0x000fe40000410000ULL,
0x0000002f3f3f7220ULL, 0x094fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x080fe40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f42427220ULL, 0x000fc40000410000ULL,
0x0000002f4b4b7220ULL, 0x080fe40000410000ULL, 0x0000002f4a4a7220ULL, 0x080fe40000410000ULL,
0x0000002f53537220ULL, 0x080fe40000410000ULL, 0x0000002f52527220ULL, 0x080fe40000410000ULL,
0x0000002f57577220ULL, 0x080fe40000410000ULL, 0x0000002f56567220ULL, 0x000fc40000410000ULL,
0x0000002f37377220ULL, 0x080fe40000410000ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f63637220ULL, 0x080fe40000410000ULL, 0x0000002f62627220ULL, 0x080fe40000410000ULL,
0x0000002f5f5f7220ULL, 0x080fe40000410000ULL, 0x0000002f5e5e7220ULL, 0x000fc40000410000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e001fULL, 0x000000191a1a1220ULL, 0x008fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000b1a0b7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff1b7984ULL, 0x000ee40000000800ULL, 0x800000001bff7812ULL, 0x008fe4000782482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1a7424ULL, 0x000fc800078e00ffULL, 0x0000001a001b7305ULL, 0x000724000021f000ULL,
0x3fa000001a1a7823ULL, 0x008fe200000100ffULL, 0x0000001b0000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff1b7984ULL, 0x000ee40000000800ULL, 0x800000001bff7812ULL, 0x008fc4000782482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fe400000010ffULL,
0x00000004ff1e7819ULL, 0x100fe40000011602ULL, 0x00000002ff1b7819ULL, 0x000fe40000011602ULL,
0x000054101a327816ULL, 0x002fe2000000001aULL, 0x0001ca927f007947ULL, 0x000fea000b800000ULL,
0x00001f1b326d7589ULL, 0x0002e400000e0000ULL, 0x000000081bf67810ULL, 0x000fe20007ffe0ffULL,
0x0001cad27f007947ULL, 0x000fea000b800000ULL, 0x00001ff6326c7589ULL, 0x00086400000e0000ULL,
0x000000101bfb7810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00fbULL, 0x00001dd000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0001db7000007944ULL, 0x03cfea0003c00000ULL, 0x000000181bfa7810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff587224ULL, 0x002fe200078e00faULL,
0x00001e4000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0001db0000007944ULL, 0x03cfea0003c00000ULL,
0x00000008021b7812ULL, 0x042fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000f7021a7211ULL, 0x000fe400078fe0ffULL, 0x000000071b1d7812ULL, 0x140fe400078ec802ULL,
0x000000071b1c7812ULL, 0x000fc400078ef802ULL, 0x0000001a1d1f7212ULL, 0x040fe400078e3cffULL,
0x000000f802207211ULL, 0x000fe400078fe0ffULL, 0x000001001c267811ULL, 0x040fe200078e20ffULL,
0x000000101c457824ULL, 0x000fe200078e021fULL, 0x000000201d1d7212ULL, 0x000fc600078e3cffULL,
0x000000011f2a7824ULL, 0x100fe200078e0226ULL, 0x0000c000451a7811ULL, 0x000fe200078e20ffULL,
0x000000101c447824ULL, 0x000fe400078e021dULL, 0x000000011d2b7824ULL, 0x000fe200078e0226ULL,
0x0000c0002a1c7811ULL, 0x000fe200078e20ffULL, 0x000000001a30783bULL, 0x010e620000004200ULL,
0x0000c000441b7811ULL, 0x000fe400078e20ffULL, 0x0000c0002b1d7811ULL, 0x000fe200078e20ffULL,
0x000000001c2c783bULL, 0x004fe80000004200ULL, 0x000000001b20783bULL, 0x000ea20000004200ULL,
0x00000018ff247819ULL, 0x002fe20000011430ULL, 0x0000003100ee7306ULL, 0x000fe20000009400ULL,
0x00000018ff257819ULL, 0x000fc40000011431ULL, 0x00000018ff3a7819ULL, 0x000fe40000011432ULL,
0x00000018ff3b7819ULL, 0x000fe40000011433ULL, 0x00000018ff4f7819ULL, 0x004fe20000011423ULL,
0x00000024009b7306ULL, 0x000fe20000209400ULL, 0x00000018ff727819ULL, 0x000fe4000001142fULL,
0x00000018ff4e7819ULL, 0x000fca0000011420ULL, 0x0000002400ec7306ULL, 0x000e700000205400ULL,
0x0000002400a27306ULL, 0x000eb0000020d400ULL, 0x00000025007f7306ULL, 0x000fe20000209400ULL,
0x000000ec9b00720bULL, 0x002fce0003f7d000ULL, 0x0000002500807306ULL, 0x000fec0000205400ULL,
0x00000001a2a23812ULL, 0x004fe400078efcffULL, 0x00000025001f7306ULL, 0x0003f0000020d400ULL,
0x0000003a00cf7306ULL, 0x000fe20000209400ULL, 0x000000001d24783bULL, 0x002e6e0000004200ULL,
0x0000003a00d67306ULL, 0x000ff00000205400ULL, 0x0000003a00387306ULL, 0x0005f0000020d400ULL,
0x0000004f00af7306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x004fce0000011421ULL,
0x0000003a009d7306ULL, 0x000ff00000209400ULL, 0x0000003a00bc7306ULL, 0x000fe20000205400ULL,
0x00000018ff717819ULL, 0x002fe40000011426ULL, 0x00000018ff587819ULL, 0x000fc40000011424ULL,
0x00000018ff657819ULL, 0x000fe40000011425ULL, 0x00000018ff767819ULL, 0x000fe20000011427ULL,
0x0000003a00897306ULL, 0x0003f0000020d400ULL, 0x0000004f00a87306ULL, 0x000fe20000205400ULL,
0x00000018ff3a7819ULL, 0x002fce000001142dULL, 0x0000003a00b17306ULL, 0x000ff00000209400ULL,
0x0000003a00b27306ULL, 0x000ff00000205400ULL, 0x0000003a006a7306ULL, 0x0003f0000020d400ULL,
0x0000004f00787306ULL, 0x000fe2000020d400ULL, 0x00000100303a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000007100687306ULL, 0x000ff00000209400ULL,
0x0000003a00747306ULL, 0x000ff00000209400ULL, 0x0000003a00f17306ULL, 0x000e700000205400ULL,
0x0000003a00b37306ULL, 0x000530000020d400ULL, 0x0000007100697306ULL, 0x000fe20000205400ULL,
0x00000100323a7824ULL, 0x004fe200078e00ffULL, 0x000000f17400720bULL, 0x002fcc0003f5d000ULL,
0x00000071004f7306ULL, 0x0003ee000020d400ULL, 0x00000001b3b32812ULL, 0x010fe200078efcffULL,
0x0000003100ed7306ULL, 0x000ea20000005400ULL, 0x0000010031717824ULL, 0x002fe200078e00ffULL,
0x000000807f00720bULL, 0x000fc80003f5d000ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000003b00d17306ULL, 0x000fee0000209400ULL, 0x000000011f1f2812ULL, 0x000fe200078efcffULL,
0x0000003b00927306ULL, 0x000e620000205400ULL, 0x000000edee00720bULL, 0x004fce0003fdd000ULL,
0x0000003b00937306ULL, 0x000530000020d400ULL, 0x0000005800837306ULL, 0x000fe20000209400ULL,
0x00000018ff3b7819ULL, 0x004fe40000011422ULL, 0x00000092d100720bULL, 0x002fca0003f5d000ULL,
0x0000005800847306ULL, 0x000ff00000205400ULL, 0x00000058005b7306ULL, 0x000fe2000020d400ULL,
0x0000000193932812ULL, 0x010fce00078efcffULL, 0x0000007200667306ULL, 0x000ff00000209400ULL,
0x0000007200677306ULL, 0x000ff00000205400ULL, 0x0000007200587306ULL, 0x0003f0000020d400ULL,
0x0000003000a07306ULL, 0x000fe20000009400ULL, 0x00000018ff727819ULL, 0x002fe2000001143aULL,
0x00000100333a7824ULL, 0x000fcc00078e00ffULL, 0x0000003000a17306ULL, 0x000e700000005400ULL,
0x0000003000a67306ULL, 0x000530000000d400ULL, 0x0000003b00b07306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x004fe200078e00ffULL, 0x000000a1a000720bULL, 0x002fcc0003f3d000ULL,
0x0000003b00a97306ULL, 0x000fee0000205400ULL, 0x00000001a6a61812ULL, 0x010fe200078efcffULL,
0x0000003b007a7306ULL, 0x0003f0000020d400ULL, 0x0000007100e77306ULL, 0x000fe20000209400ULL,
0x00000018ff3b7819ULL, 0x002fce000001142eULL, 0x0000007100e87306ULL, 0x000e700000205400ULL,
0x0000007100b47306ULL, 0x000530000020d400ULL, 0x0000003b006b7306ULL, 0x000fe20000209400ULL,
0x00000018ff717819ULL, 0x004fc4000001143aULL, 0x000000e8e700720bULL, 0x002fca0003f3d000ULL,
0x0000003b006e7306ULL, 0x000ff00000205400ULL, 0x0000003b00597306ULL, 0x0003e2000020d400ULL,
0x00000001b4b41812ULL, 0x010fce00078efcffULL, 0x0000003100a37306ULL, 0x000522000000d400ULL,
0x00000018ff3b7819ULL, 0x002fce0000011430ULL, 0x0000007100dd7306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x004fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000007100e27306ULL, 0x000e620000205400ULL, 0x00000001a3a36812ULL, 0x010fce00078efcffULL,
0x0000003b00307306ULL, 0x000ff00000209400ULL, 0x0000003b00ef7306ULL, 0x000ea20000205400ULL,
0x000000e2dd00720bULL, 0x002fce0003fdd000ULL, 0x0000007200967306ULL, 0x000ff00000209400ULL,
0x0000007200e57306ULL, 0x000e620000205400ULL, 0x000000ef3000720bULL, 0x004fce0003f9d000ULL,
0x00000072009f7306ULL, 0x0005f0000020d400ULL, 0x00000071003a7306ULL, 0x0008e2000020d400ULL,
0x0000010020727824ULL, 0x004fe200078e00ffULL, 0x000000e59600720bULL, 0x002fc80003f7d000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000003b00a57306ULL, 0x000e62000020d400ULL,
0x0000010021717824ULL, 0x010fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000007200e37306ULL, 0x000fe20000209400ULL, 0x000000013a3a6812ULL, 0x008fe400078efcffULL,
0x000000019f9f3812ULL, 0x000fca00078efcffULL, 0x0000007200e67306ULL, 0x000ea20000205400ULL,
0x00000001a5a54812ULL, 0x002fce00078efcffULL, 0x0000003100e97306ULL, 0x000ff00000209400ULL,
0x0000003100ea7306ULL, 0x000e620000205400ULL, 0x000000e6e300720bULL, 0x004fce0003fdd000ULL,
0x00000032009c7306ULL, 0x000ff00000009400ULL, 0x0000003200eb7306ULL, 0x000ea20000005400ULL,
0x000000eae900720bULL, 0x002fce0003f9d000ULL, 0x00000032009e7306ULL, 0x0002f0000000d400ULL,
0x0000002000957306ULL, 0x000fe20000009400ULL, 0x0001000032327824ULL, 0x002fe200078e00ffULL,
0x000000eb9c00720bULL, 0x004fcc0003fbd000ULL, 0x0000002000ce7306ULL, 0x000fee0000005400ULL,
0x000000019e9e5812ULL, 0x008fe200078efcffULL, 0x0000002000917306ULL, 0x0003f0000000d400ULL,
0x0000003100a47306ULL, 0x0004e2000020d400ULL, 0x0001000020207824ULL, 0x002fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002100c67306ULL, 0x000fe20000009400ULL,
0x00000018ff317819ULL, 0x004fce0000011432ULL, 0x0000002100c37306ULL, 0x000fe20000005400ULL,
0x00000001a4a44812ULL, 0x008fe400078efcffULL, 0x000000d6cf00720bULL, 0x000fca0003f9d000ULL,
0x00000021008c7306ULL, 0x0003f0000000d400ULL, 0x0000003300977306ULL, 0x000fe20000009400ULL,
0x0001000021217824ULL, 0x002fe200078e00ffULL, 0x0000000138384812ULL, 0x000fcc00078efcffULL,
0x0000003300da7306ULL, 0x000e700000005400ULL, 0x0000003300397306ULL, 0x0004f0000000d400ULL,
0x0000003100327306ULL, 0x000fe20000209400ULL, 0x0001000033337824ULL, 0x004fe200078e00ffULL,
0x000000da9700720bULL, 0x002fc80003f3d000ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003100df7306ULL, 0x000e6e0000205400ULL, 0x0000000139391812ULL, 0x008fe200078efcffULL,
0x0000007200947306ULL, 0x000eb0000020d400ULL, 0x0000002000d97306ULL, 0x000fe20000209400ULL,
0x000000df3200720bULL, 0x002fce0003f7d000ULL, 0x0000002000de7306ULL, 0x000e620000205400ULL,
0x0000000194946812ULL, 0x004fce00078efcffULL, 0x00000031003b7306ULL, 0x0004f0000020d400ULL,
0x0000003300e17306ULL, 0x000fe20000209400ULL, 0x00000018ff317819ULL, 0x004fe20000011421ULL,
0x0000010022217824ULL, 0x000fe200078e00ffULL, 0x000000ded900720bULL, 0x002fca0003fdd000ULL,
0x0000003300e47306ULL, 0x000e620000205400ULL, 0x000000013b3b3812ULL, 0x008fe400078efcffULL,
0x000000ce9500720bULL, 0x000fca0003f7d000ULL, 0x0000003300987306ULL, 0x0004f0000020d400ULL,
0x0000002200ba7306ULL, 0x000fe20000009400ULL, 0x00000018ff337819ULL, 0x004fe20000011421ULL,
0x0000010023217824ULL, 0x000fe200078e00ffULL, 0x000000e4e100720bULL, 0x002fc40003fbd000ULL,
0x0000000191913812ULL, 0x000fc600078efcffULL, 0x0000002200b77306ULL, 0x000e700000005400ULL,
0x0000002200817306ULL, 0x0005e2000000d400ULL, 0x0000000198985812ULL, 0x008fe400078efcffULL,
0x000000c3c600720bULL, 0x000fca0003fbd000ULL, 0x0000002000907306ULL, 0x000ee2000020d400ULL,
0x0001000022227824ULL, 0x004fce00078e00ffULL, 0x0000003300d37306ULL, 0x000fe20000209400ULL,
0x000000018c8c5812ULL, 0x000fe400078efcffULL, 0x000000b7ba00720bULL, 0x002fca0003fbd000ULL,
0x0000003300d87306ULL, 0x000e620000205400ULL, 0x0000000190906812ULL, 0x008fce00078efcffULL,
0x0000003100db7306ULL, 0x000fe20000209400ULL, 0x0000000181815812ULL, 0x000fce00078efcffULL,
0x0000003100e07306ULL, 0x000ea20000205400ULL, 0x000000d8d300720bULL, 0x002fce0003fdd000ULL,
0x00000031008e7306ULL, 0x0002f0000020d400ULL, 0x0000007100d77306ULL, 0x000fe20000209400ULL,
0x00000018ff317819ULL, 0x002fe40000011422ULL, 0x000000e0db00720bULL, 0x004fca0003f7d000ULL,
0x0000007100dc7306ULL, 0x000e700000205400ULL, 0x0000003100227306ULL, 0x000fe20000209400ULL,
0x000000018e8e3812ULL, 0x008fce00078efcffULL, 0x0000003100d57306ULL, 0x000fe20000205400ULL,
0x000000dcd700720bULL, 0x002fce0003f9d000ULL, 0x0000003100857306ULL, 0x0003f0000020d400ULL,
0x0000002d00ac7306ULL, 0x000fe20000009400ULL, 0x000001002d317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000002d00ad7306ULL, 0x000ff00000005400ULL,
0x0000002d00757306ULL, 0x0003f0000000d400ULL, 0x0000004e00c87306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000004e00c17306ULL, 0x000e700000205400ULL, 0x00000033008a7306ULL, 0x0004f0000020d400ULL,
0x0000002300777306ULL, 0x000fe20000009400ULL, 0x000001002c337824ULL, 0x004fe200078e00ffULL,
0x000000c1c800720bULL, 0x002fc80003f5d000ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000002300b87306ULL, 0x000e620000005400ULL, 0x000000018a8a6812ULL, 0x008fe400078efcffULL,
0x000000a9b000720bULL, 0x000fe20003fdd000ULL, 0x000100002fb07824ULL, 0x000fe200078e00ffULL,
0x000000818a8a723eULL, 0x000fc600000010ffULL, 0x0000002300827306ULL, 0x0004e2000000d400ULL,
0x00000018ffb07819ULL, 0x000fce00000114b0ULL, 0x00000071008f7306ULL, 0x0008e2000020d400ULL,
0x0001000023237824ULL, 0x004fe200078e00ffULL, 0x000000b87700720bULL, 0x002fe40003f7d000ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000004e008b7306ULL, 0x0002a2000020d400ULL, 0x00000018ff717819ULL, 0x010fcc0000011421ULL,
0x0000000182823812ULL, 0x008fe200078efcffULL, 0x0000002d00c97306ULL, 0x000fe20000209400ULL,
0x00000018ff4e7819ULL, 0x002fe4000001142cULL, 0x000000018f8f4812ULL, 0x000fe400078efcffULL,
0x000000bc9d00720bULL, 0x000fc60003f9d000ULL, 0x0000002d00d07306ULL, 0x000fe20000205400ULL,
0x000000018b8b2812ULL, 0x004fce00078efcffULL, 0x0000002d00797306ULL, 0x0003e4000020d400ULL,
0x0000000189894812ULL, 0x000fe400078efcffULL, 0x000000d52200720bULL, 0x000fc80003f9d000ULL,
0x0000002c00ae7306ULL, 0x000fe20000009400ULL, 0x00009910702d7816ULL, 0x002fc800000000ffULL,
0x000000ff2d00720cULL, 0x000fe40003f25270ULL, 0x00000007022d7812ULL, 0x000fe200078ec0ffULL,
0x0000002c00ab7306ULL, 0x000e620000005400ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x000000082d2d7812ULL, 0x000fc800078ef802ULL, 0x000000071e1e7812ULL, 0x000fe200078e782dULL,
0x0000002c00737306ULL, 0x0004e8000000d400ULL, 0x000000082d1e7824ULL, 0x000fc800078e021eULL,
0x0000007100207306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x004fe200078e00ffULL,
0x000000abae00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000007100217306ULL, 0x000e6e0000205400ULL, 0x0000000173734812ULL, 0x008fe200078efcffULL,
0x0000002300b97306ULL, 0x000ff00000209400ULL, 0x0000002300be7306ULL, 0x000ea20000205400ULL,
0x000000212000720bULL, 0x002fc40003f5d000ULL, 0x0000a0001e207811ULL, 0x000fca00078e20ffULL,
0x0000002300877306ULL, 0x0002f0000020d400ULL, 0x0000002c00c57306ULL, 0x000fe20000209400ULL,
0x000001002e237824ULL, 0x002fe200078e00ffULL, 0x000000beb900720bULL, 0x004fc80003fbd000ULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x0000002c00ca7306ULL, 0x000e6e0000205400ULL,
0x0000000187875812ULL, 0x008fe200078efcffULL, 0x0000004e00a77306ULL, 0x000ff00000209400ULL,
0x0000004e00aa7306ULL, 0x000ea20000205400ULL, 0x000000cac500720bULL, 0x002fce0003fdd000ULL,
0x0000004e006f7306ULL, 0x000e70000020d400ULL, 0x00000065007d7306ULL, 0x000fe20000209400ULL,
0x000000aaa700720bULL, 0x004fe20003fbd000ULL, 0x0001000027a77824ULL, 0x000fca00078e00ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x00000065007c7306ULL, 0x000fec0000205400ULL,
0x000000016f6f5812ULL, 0x002fe400078efcffULL, 0x00000065005a7306ULL, 0x000ff0000020d400ULL,
0x0000007600647306ULL, 0x000ff00000209400ULL, 0x0000007600657306ULL, 0x000ff00000205400ULL,
0x00000076004e7306ULL, 0x000ff0000020d400ULL, 0x0000002300bd7306ULL, 0x000ff00000209400ULL,
0x0000002300c27306ULL, 0x000ff00000205400ULL, 0x0000002300767306ULL, 0x0003f0000020d400ULL,
0x0000003300bb7306ULL, 0x000fe20000209400ULL, 0x0000010025237824ULL, 0x002fca00078e00ffULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x0000003300c07306ULL, 0x000e700000205400ULL,
0x0000002c007e7306ULL, 0x0004f0000020d400ULL, 0x0000002300967306ULL, 0x000fe20000209400ULL,
0x000000c0bb00720bULL, 0x002fe20003f7d000ULL, 0x000001002f2c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002300977306ULL, 0x000fe20000205400ULL,
0x000000017e7e6812ULL, 0x008fe400078efcffULL, 0x000000d0c900720bULL, 0x000fca0003fdd000ULL,
0x0000002300327306ULL, 0x0003f0000020d400ULL, 0x00000071008d7306ULL, 0x000ea2000020d400ULL,
0x000000002020783bULL, 0x002e620000000200ULL, 0x0000000179796812ULL, 0x000fc400078efcffULL,
0x000000c2bd00720bULL, 0x000fc80003fdd000ULL, 0x0000003300867306ULL, 0x000ef0000020d400ULL,
0x0000003100c77306ULL, 0x000fe20000209400ULL, 0x000000018d8d2812ULL, 0x004fe400078efcffULL,
0x000000a8af00720bULL, 0x000fe20003f5d000ULL, 0x000100002eaf7824ULL, 0x000fe200078e00ffULL,
0x0000000176766812ULL, 0x000fe200078efcffULL, 0x0001000026a87824ULL, 0x000fc400078e00ffULL,
0x0000003100cc7306ULL, 0x000ea20000205400ULL, 0x0000000186863812ULL, 0x008fe400078efcffULL,
0x000000adac00720bULL, 0x000fe40003f7d000ULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x0000003100887306ULL, 0x000722000020d400ULL,
0x0000000178782812ULL, 0x000fe400078efcffULL, 0x000000738686723eULL, 0x000fca00000010ffULL,
0x0000002400bf7306ULL, 0x000fe20000009400ULL, 0x0000010024317824ULL, 0x008fe200078e00ffULL,
0x000000ccc700720bULL, 0x004fe20003f5d000ULL, 0x0000006d20209231ULL, 0x082fe200003400ffULL,
0x0000000175753812ULL, 0x000fe200078efcffULL, 0x0000006d22229231ULL, 0x000fe200003400ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000006c21219231ULL, 0x080fe200003400ffULL,
0x0000002400c47306ULL, 0x000e620000005400ULL, 0x0000006c23239231ULL, 0x000fcc00003400ffULL,
0x0000000188882812ULL, 0x010fe200078efcffULL, 0x0000002400747306ULL, 0x0004e2000000d400ULL,
0x000000b2b100720bULL, 0x000fce0003f5d000ULL, 0x0000003100997306ULL, 0x000fe20000209400ULL,
0x0001000024247824ULL, 0x004fe200078e00ffULL, 0x000000c4bf00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000031009a7306ULL, 0x000fe20000205400ULL,
0x000000016a6a2812ULL, 0x000fc800078efcffULL, 0x000000796a79723eULL, 0x000fe400000010ffULL,
0x0000000174743812ULL, 0x008fe200078efcffULL, 0x0000003100717306ULL, 0x000ff0000020d400ULL,
0x0000002e00cb7306ULL, 0x000ff00000009400ULL, 0x0000002e00d27306ULL, 0x000e700000005400ULL,
0x0000002f00cd7306ULL, 0x000ff00000009400ULL, 0x0000002f00d47306ULL, 0x000ea20000005400ULL,
0x000000d2cb00720bULL, 0x002fce0003f9d000ULL, 0x0000002500a07306ULL, 0x000ff00000009400ULL,
0x0000002500a17306ULL, 0x000e620000005400ULL, 0x000000d4cd00720bULL, 0x004fce0003fbd000ULL,
0x0000002500317306ULL, 0x0004f0000000d400ULL, 0x0000002400927306ULL, 0x000fe20000209400ULL,
0x0001000025257824ULL, 0x004fe200078e00ffULL, 0x000000a1a000720bULL, 0x002fc80003fdd000ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000002400957306ULL, 0x000e6e0000205400ULL,
0x0000000131316812ULL, 0x008fe200078efcffULL, 0x0000002400707306ULL, 0x0004f0000020d400ULL,
0x00000025009d7306ULL, 0x000fe20000209400ULL, 0x0000010026247824ULL, 0x004fe200078e00ffULL,
0x000000959200720bULL, 0x002fc80003f7d000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002500ba7306ULL, 0x000e6e0000205400ULL, 0x0000000170703812ULL, 0x008fe200078efcffULL,
0x0000002500777306ULL, 0x0004f0000020d400ULL, 0x0000002e007b7306ULL, 0x000f22000000d400ULL,
0x0000010027257824ULL, 0x004fe200078e00ffULL, 0x000000ba9d00720bULL, 0x002fc80003fdd000ULL,
0x00000018ffab7819ULL, 0x000fe40000011425ULL, 0x0000002f00727306ULL, 0x000e62000000d400ULL,
0x000000a3b425723eULL, 0x000fcc00000010ffULL, 0x0000000177776812ULL, 0x008fe200078efcffULL,
0x00000024002e7306ULL, 0x000fe20000209400ULL, 0x000000017b7b4812ULL, 0x010fe400078efcffULL,
0x0000009a9900720bULL, 0x000fca0003f9d000ULL, 0x0000002400a97306ULL, 0x000ea20000205400ULL,
0x0000000172725812ULL, 0x002fe400078efcffULL, 0x000000979600720bULL, 0x000fca0003fbd000ULL,
0x00000024002f7306ULL, 0x0002e2000020d400ULL, 0x0000000171714812ULL, 0x000fe400078efcffULL,
0x000000848300720bULL, 0x000fe40003f9d000ULL, 0x000000747174723eULL, 0x000fc600000010ffULL,
0x0000002c00b57306ULL, 0x000fe20000209400ULL, 0x000000a6b324723eULL, 0x002fe400000010ffULL,
0x0000000132325812ULL, 0x000fe400078efcffULL, 0x000000a92e00720bULL, 0x004fe40003f7d000ULL,
0x0000007c7d00720bULL, 0x000fe20003fbd000ULL, 0x0000002c00b67306ULL, 0x000e620000205400ULL,
0x00000024205c723cULL, 0x000fe2000004185cULL, 0x000000015b5b4812ULL, 0x000fc800078efcffULL,
0x000000705b70723eULL, 0x000fe400000010ffULL, 0x00000007f5247812ULL, 0x000fe200078e782dULL,
0x0000002c00337306ULL, 0x000ea2000020d400ULL, 0x000000393a25723eULL, 0x000fe400000010ffULL,
0x000000012f2f3812ULL, 0x008fe400078efcffULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x000000b6b500720bULL, 0x002fe20003f5d000ULL, 0x00000026009b7306ULL, 0x000fe20000009400ULL,
0x0000006e6b00720bULL, 0x000fc40003fbd000ULL, 0x000000775a71723eULL, 0x000fca00000010ffULL,
0x00000026009c7306ULL, 0x000e680000005400ULL, 0x0000000133332812ULL, 0x004fe400078efcffULL,
0x0000000159595812ULL, 0x000fe400078efcffULL, 0x0000002600307306ULL, 0x0004f0000000d400ULL,
0x00000027007f7306ULL, 0x000fe20000009400ULL, 0x000000a5a226723eULL, 0x004fc400000010ffULL,
0x0000009c9b00720bULL, 0x002fca0003f5d000ULL, 0x0000002700807306ULL, 0x000e700000005400ULL,
0x00000027002c7306ULL, 0x000522000000d400ULL, 0x0000000130302812ULL, 0x008fe400078efcffULL,
0x000000696800720bULL, 0x000fc40003f5d000ULL, 0x000000302f30723eULL, 0x000fc600000010ffULL,
0x000000ab00aa7306ULL, 0x000fe20000209400ULL, 0x000000a41f27723eULL, 0x004fe200000010ffULL,
0x000000082d1f7824ULL, 0x000fe200078e0224ULL, 0x0000009e9f24723eULL, 0x000fe400000010ffULL,
0x000000807f00720bULL, 0x002fe40003f9d000ULL, 0x0000a0001f397811ULL, 0x000fe200078e20ffULL,
0x000000ab00ad7306ULL, 0x000e620000205400ULL, 0x000000262060723cULL, 0x000fe20000041860ULL,
0x000000014f4f2812ULL, 0x000fcc00078efcffULL, 0x0000003b3826723eULL, 0x000fe200000010ffULL,
0x000000242034723cULL, 0x040fe20000041834ULL, 0x000000989327723eULL, 0x000fe200000010ffULL,
0x000000ab00a37306ULL, 0x000ea2000020d400ULL, 0x000000003938783bULL, 0x000ee20000000200ULL,
0x000000012c2c4812ULL, 0x010fe400078efcffULL, 0x000000656400720bULL, 0x000fe40003f9d000ULL,
0x000000919424723eULL, 0x000fe200000010ffULL, 0x000000262054723cULL, 0x000fe20000041854ULL,
0x0000008c8f25723eULL, 0x000fe200000010ffULL, 0x000000af00a27306ULL, 0x000fe20000209400ULL,
0x000000adaa00720bULL, 0x002fc80003fdd000ULL, 0x000000908b26723eULL, 0x000fe200000010ffULL,
0x000000242050723cULL, 0x040fe20000041850ULL, 0x0000008e8927723eULL, 0x000fe200000010ffULL,
0x000000af009f7306ULL, 0x000e620000205400ULL, 0x000000828d8b723eULL, 0x000fe400000010ffULL,
0x000000014e4e4812ULL, 0x000fe400078efcffULL, 0x000000857a24723eULL, 0x000fe200000010ffULL,
0x000000262048723cULL, 0x000fe20000041848ULL, 0x000000877825723eULL, 0x000fe200000010ffULL,
0x000000b0008c7306ULL, 0x000fe20000209400ULL, 0x00000001a3a36812ULL, 0x004fc400078efcffULL,
0x000000758887723eULL, 0x000fe400000010ffULL, 0x000000313275723eULL, 0x000fe200000010ffULL,
0x0000008a2040723cULL, 0x000fe20000041840ULL, 0x0000007e6f78723eULL, 0x000fe200000010ffULL,
0x000000b000817306ULL, 0x000ea20000205400ULL, 0x0000009fa200720bULL, 0x002fe40003f7d000ULL,
0x0000002ca331723eULL, 0x000fc600000010ffULL, 0x000000242020723cULL, 0x000fe4000004183cULL,
0x000000af00987306ULL, 0x000e62000020d400ULL, 0x0000006d38389231ULL, 0x088fe400003400ffULL,
0x0000006d3a3a9231ULL, 0x000fe400003400ffULL, 0x000000723325723eULL, 0x000fe200000010ffULL,
0x0000006c39399231ULL, 0x080fe200003400ffULL, 0x0000007b7624723eULL, 0x000fe200000010ffULL,
0x000000b000997306ULL, 0x000ee2000020d400ULL, 0x000000818c00720bULL, 0x004fe20003fdd000ULL,
0x0000006c3b3b9231ULL, 0x000fcc00003400ffULL, 0x000000a800267306ULL, 0x000fe20000209400ULL,
0x0000000198983812ULL, 0x002fe200078efcffULL, 0x00000086385c723cULL, 0x000fe2000004185cULL,
0x000000676600720bULL, 0x000fe40003f7d000ULL, 0x000000985998723eULL, 0x000fc600000010ffULL,
0x000000a800277306ULL, 0x000e620000205400ULL, 0x0000000199996812ULL, 0x008fe200078efcffULL,
0x000000783860723cULL, 0x040fec0000041860ULL, 0x000000a7002e7306ULL, 0x000fe20000209400ULL,
0x0000000158583812ULL, 0x000fe200078efcffULL, 0x000000243834723cULL, 0x000fe60000041834ULL,
0x000000995899723eULL, 0x000fc600000010ffULL, 0x000000a700337306ULL, 0x000ea20000205400ULL,
0x000000272600720bULL, 0x002fe20003fbd000ULL, 0x000000743850723cULL, 0x040fec0000041850ULL,
0x000000a800a87306ULL, 0x000e64000020d400ULL, 0x000000703848723cULL, 0x040fec0000041848ULL,
0x000000a700a97306ULL, 0x000ee2000020d400ULL, 0x000000332e00720bULL, 0x004fe20003fdd000ULL,
0x000000303840723cULL, 0x000fe20000041840ULL, 0x00000001a8a85812ULL, 0x002fce00078efcffULL,
0x000000983854723cULL, 0x000fe20000041854ULL, 0x000000a84fa8723eULL, 0x000fc600000010ffULL,
0x00000001a9a96812ULL, 0x008fc800078efcffULL, 0x000000a94ea9723eULL, 0x000fce00000010ffULL,
0x000000a83838723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff207f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007844821ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fc40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff227424ULL, 0x000fc800078e00ffULL, 0x0000002200237305ULL, 0x0002a4000021f000ULL,
0x3fa0000022227823ULL, 0x002fe200000100ffULL, 0x000000230000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580009217a24ULL, 0x020fe200078e02ffULL,
0x0000000802207211ULL, 0x000fc400078fe0ffULL, 0x0000004004247811ULL, 0x000fe200078e40ffULL,
0x00000040213c7824ULL, 0x000fe200078e00ffULL, 0x0000000202317811ULL, 0x040fe200078fe0ffULL,
0x00000040f9207824ULL, 0x000fe200078e0220ULL, 0x0000002403217217ULL, 0x000fe40007800000ULL,
0x00000004022f7811ULL, 0x000fe200078fe0ffULL, 0x0000000108227824ULL, 0x000fe200078e0231ULL,
0x000000203c277210ULL, 0x000fe20007f5e0ffULL, 0x0000000121217824ULL, 0x000fe200078e0a24ULL,
0x00000004ff337819ULL, 0x000fc40000011602ULL, 0x0000000602257811ULL, 0x000fe200078fe0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x0000002021237807ULL, 0x000fe20000000000ULL,
0x00000040f9217824ULL, 0x000fe200078e0222ULL, 0x00005e0027267a11ULL, 0x040fe200078440ffULL,
0x0000000108227824ULL, 0x040fe200078e022fULL, 0x0000002308237217ULL, 0x000fe40007800000ULL,
0x00005f0027277a11ULL, 0x000fe200010f4424ULL, 0x00000040f9227824ULL, 0x000fe200078e0222ULL,
0x000000213c3d7210ULL, 0x000fe20007f5e0ffULL, 0x00000001232c7824ULL, 0x000fc800078e0a08ULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005e003d327a11ULL, 0x000fe400078440ffULL,
0x0000002c3300720cULL, 0x000fe40003f66070ULL, 0x00005f003d3d7a11ULL, 0x000fe200010f4424ULL,
0x0000000108247824ULL, 0x000fe200078e0225ULL, 0x000000223c337210ULL, 0x000fe40007f9e0ffULL,
0x0000001326267210ULL, 0x000fe20007f5e0ffULL, 0x00000040f9237824ULL, 0x000fe200078e0224ULL,
0x0000c0004d247811ULL, 0x000fe200078e20ffULL, 0x000000ffff2e7224ULL, 0x000fe200020e06ffULL,
0x00005e0033307a11ULL, 0x000fe200078840ffULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x0000002c3100720cULL, 0x000fc40003f46070ULL, 0x000000233c317210ULL, 0x000fe40007fde0ffULL,
0x00005f0033337a11ULL, 0x000fe200020f442eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026247faeULL, 0x0003e2000d901c46ULL, 0x00000013322e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3c7224ULL, 0x000fe200030e06ffULL, 0x0000002c2f00720cULL, 0x080fe40003f86070ULL,
0x00005e0031327a11ULL, 0x000fe200078640ffULL, 0x000000ffff2f7224ULL, 0x000fe200028e063dULL,
0x0000002c2500720cULL, 0x000fc40003fa6070ULL, 0x0000001330307210ULL, 0x080fe40007fde0ffULL,
0x00005f00312c7a11ULL, 0x000fe400018f443cULL, 0x0000001332327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200030e0633ULL, 0x0000c0004c257811ULL, 0x000fe400078e20ffULL,
0x0000c00047267811ULL, 0x002fe200078e20ffULL, 0x000000ffff337224ULL, 0x000fe200018e062cULL,
0x0000c00046277811ULL, 0x000fe200078e20ffULL, 0x000000002e257faeULL, 0x0003e8000d101c46ULL,
0x0000000030267faeULL, 0x0003e8000e101c46ULL, 0x0000000032277faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff2e7f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844829ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e002fULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff2f7984ULL, 0x000e640000000800ULL,
0x800000002fff7812ULL, 0x002fe40007844829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff2c7424ULL, 0x000fc800078e00ffULL,
0x0000002c002f7305ULL, 0x0002a4000021f000ULL, 0x3fa000002c2c7823ULL, 0x002fe200000100ffULL,
0x0000002f0000735dULL, 0x004fe40003800000ULL, 0x0106b400ff2f7984ULL, 0x000e640000000800ULL,
0x800000002fff7812ULL, 0x002fc40007844829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000019ff28723eULL, 0x000fe400000010ffULL, 0x00000002ff587819ULL, 0x000fe40000011602ULL,
0x0000541028327816ULL, 0x000fe20000000028ULL, 0x0001a4927f007947ULL, 0x000fea000b800000ULL,
0x00001f5832747589ULL, 0x0002a400000e0000ULL, 0x0001a4d27f007947ULL, 0x000fea000b800000ULL,
0x00001ff632b67589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00fbULL, 0x0000449000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0001b4b000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00faULL, 0x000044f000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0001b45000007944ULL, 0x01cfea0003c00000ULL, 0x0000e00045287811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e00044297811ULL, 0x000fe400078e20ffULL,
0x0000e0002a2a7811ULL, 0x000fe200078e20ffULL, 0x00000000284c783bULL, 0x002e620000004200ULL,
0x0000e0002b2b7811ULL, 0x000fc600078e20ffULL, 0x000000002930783bULL, 0x008ee80000004200ULL,
0x000000002a3c783bULL, 0x000f620000004200ULL, 0x00000018ff2c7819ULL, 0x002fe2000001144cULL,
0x000001004c6c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe2000001144eULL,
0x0000004c00b87306ULL, 0x000fe20000009400ULL, 0x00000018ff457819ULL, 0x000fe4000001144fULL,
0x00000018ff597819ULL, 0x008fc40000011432ULL, 0x00000018ff2f7819ULL, 0x004fe4000001144dULL,
0x00000018ff717819ULL, 0x000fe2000001146cULL, 0x0000002c00ad7306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x000fe40000011430ULL, 0x00000018ff5a7819ULL, 0x020fca000001143dULL,
0x0000002c00f07306ULL, 0x000e700000205400ULL, 0x0000002c00b97306ULL, 0x000eb0000020d400ULL,
0x0000004400de7306ULL, 0x000fe20000209400ULL, 0x000000f0ad00720bULL, 0x002fce0003f7d000ULL,
0x0000004400df7306ULL, 0x000fec0000205400ULL, 0x00000001b9b93812ULL, 0x004fe400078efcffULL,
0x0000004400a67306ULL, 0x000ff0000020d400ULL, 0x0000004500727306ULL, 0x000ff00000209400ULL,
0x00000045002c7306ULL, 0x000ff00000205400ULL, 0x0000004500a07306ULL, 0x0003f0000020d400ULL,
0x0000005900c67306ULL, 0x000fe20000209400ULL, 0x000000002b44783bULL, 0x002e6e0000004200ULL,
0x0000005900a17306ULL, 0x000ff00000205400ULL, 0x00000059007d7306ULL, 0x0005f0000020d400ULL,
0x0000002f00887306ULL, 0x000fe20000209400ULL, 0x00000018ff597819ULL, 0x004fce000001143eULL,
0x0000005900927306ULL, 0x000ff00000209400ULL, 0x0000005900937306ULL, 0x000fe20000205400ULL,
0x00000018ff757819ULL, 0x002fe40000011445ULL, 0x00000018ff767819ULL, 0x000fc40000011446ULL,
0x00000018ff7a7819ULL, 0x000fc60000011447ULL, 0x0000005900687306ULL, 0x000ff0000020d400ULL,
0x00000075006a7306ULL, 0x000ff00000209400ULL, 0x00000075006b7306ULL, 0x000ff00000205400ULL,
0x0000007500597306ULL, 0x0003f0000020d400ULL, 0x0000002f00897306ULL, 0x000ea20000205400ULL,
0x000001004d757824ULL, 0x002fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x0000007100777306ULL, 0x000ff00000209400ULL, 0x0000007100d27306ULL, 0x000e620000205400ULL,
0x000000898800720bULL, 0x004fce0003f7d000ULL, 0x0000007100c07306ULL, 0x0004f0000020d400ULL,
0x0000004c00b77306ULL, 0x000f620000005400ULL, 0x000001004e717824ULL, 0x004fe200078e00ffULL,
0x000000d27700720bULL, 0x002fcc0003f9d000ULL, 0x0000004c00be7306ULL, 0x0002ae000000d400ULL,
0x00000001c0c04812ULL, 0x008fe200078efcffULL, 0x0000004e00ee7306ULL, 0x000fe20000009400ULL,
0x000100004c4c7824ULL, 0x002fe200078e00ffULL, 0x000000b7b800720bULL, 0x020fc80003fdd000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000004e008f7306ULL, 0x000e6e0000005400ULL,
0x00000001bebe6812ULL, 0x004fe200078efcffULL, 0x0000004e00ae7306ULL, 0x0004f0000000d400ULL,
0x0000004d00ef7306ULL, 0x000fe20000009400ULL, 0x000100004e4e7824ULL, 0x004fe200078e00ffULL,
0x0000008fee00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004d008e7306ULL, 0x000e6e0000005400ULL, 0x00000001aeae6812ULL, 0x008fe200078efcffULL,
0x0000004d00bd7306ULL, 0x0004f0000000d400ULL, 0x0000007500f17306ULL, 0x000fe20000209400ULL,
0x000100004d4d7824ULL, 0x004fe200078e00ffULL, 0x0000008eef00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000007500f27306ULL, 0x000e6e0000205400ULL,
0x00000001bdbd4812ULL, 0x008fe200078efcffULL, 0x00000058008d7306ULL, 0x000ff00000209400ULL,
0x0000005800da7306ULL, 0x000fe20000205400ULL, 0x000000f2f100720bULL, 0x002fce0003f5d000ULL,
0x0000005800917306ULL, 0x0003f0000020d400ULL, 0x0000002f00b17306ULL, 0x0004e2000020d400ULL,
0x00000018ff587819ULL, 0x002fce0000011433ULL, 0x0000004c006c7306ULL, 0x000fe20000209400ULL,
0x00000018ff2f7819ULL, 0x004fce0000011431ULL, 0x0000004c00ac7306ULL, 0x000e620000205400ULL,
0x00000001b1b13812ULL, 0x008fce00078efcffULL, 0x0000004e00e97306ULL, 0x000ff00000209400ULL,
0x0000004e00ea7306ULL, 0x000ea20000205400ULL, 0x000000ac6c00720bULL, 0x002fce0003fbd000ULL,
0x0000005800737306ULL, 0x000ff00000209400ULL, 0x0000005800c77306ULL, 0x000fe20000205400ULL,
0x000000eae900720bULL, 0x004fce0003f7d000ULL, 0x0000005800787306ULL, 0x0003f0000020d400ULL,
0x0000004d00ec7306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x002fce000001143fULL,
0x0000004d00ed7306ULL, 0x000ff00000205400ULL, 0x0000004d00b37306ULL, 0x0003f0000020d400ULL,
0x0000007500bf7306ULL, 0x000ea2000020d400ULL, 0x00000100304d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000005800847306ULL, 0x000ff00000209400ULL,
0x0000005800857306ULL, 0x000fe20000205400ULL, 0x00000001bfbf2812ULL, 0x004fc400078efcffULL,
0x000000edec00720bULL, 0x000fca0003f5d000ULL, 0x00000058005b7306ULL, 0x000ff0000020d400ULL,
0x0000007600677306ULL, 0x000fe20000209400ULL, 0x00000001b3b32812ULL, 0x000fce00078efcffULL,
0x0000007600667306ULL, 0x000ff00000205400ULL, 0x0000007600587306ULL, 0x0003f0000020d400ULL,
0x0000004c00bc7306ULL, 0x000ea2000020d400ULL, 0x00000018ff767819ULL, 0x002fe20000011471ULL,
0x000001004f717824ULL, 0x000fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011471ULL,
0x0000004e00a97306ULL, 0x000e70000020d400ULL, 0x0000004f009f7306ULL, 0x000fe20000009400ULL,
0x00000001bcbc5812ULL, 0x004fce00078efcffULL, 0x0000004f00eb7306ULL, 0x000ea20000005400ULL,
0x00000001a9a93812ULL, 0x002fce00078efcffULL, 0x00000076004c7306ULL, 0x000ff00000209400ULL,
0x00000076009e7306ULL, 0x000e620000205400ULL, 0x000000eb9f00720bULL, 0x004fce0003fbd000ULL,
0x0000004d00e57306ULL, 0x000ff00000209400ULL, 0x0000004d00e67306ULL, 0x000ea20000205400ULL,
0x0000009e4c00720bULL, 0x002fce0003f9d000ULL, 0x0000004f00a77306ULL, 0x0002f0000000d400ULL,
0x0000003000957306ULL, 0x000fe20000009400ULL, 0x000100004f4f7824ULL, 0x002fe200078e00ffULL,
0x000000e6e500720bULL, 0x004fc80003f7d000ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000003000dd7306ULL, 0x000e620000005400ULL, 0x00000001a7a75812ULL, 0x008fe400078efcffULL,
0x0000002c7200720bULL, 0x000fe40003fbd000ULL, 0x000000070e2c7812ULL, 0x000fc600078e782dULL,
0x00000030009d7306ULL, 0x0004e4000000d400ULL, 0x000000082d2c7824ULL, 0x000fcc00078e022cULL,
0x0000007500717306ULL, 0x000fe20000209400ULL, 0x0001000030307824ULL, 0x004fe200078e00ffULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x000000da8d00720bULL, 0x000fe40003fbd000ULL,
0x00000018ff4e7819ULL, 0x000fe40000011430ULL, 0x0000007500947306ULL, 0x000ea20000205400ULL,
0x000000dd9500720bULL, 0x002fce0003fdd000ULL, 0x0000007600b27306ULL, 0x000362000020d400ULL,
0x0000000191915812ULL, 0x000fca00078efcffULL, 0x000000019d9d6812ULL, 0x008fe400078efcffULL,
0x0000004f00e77306ULL, 0x000fe20000209400ULL, 0x000000947100720bULL, 0x004fe20003f5d000ULL,
0x0000010033767824ULL, 0x002fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000004f00e87306ULL, 0x000fe20000205400ULL, 0x00000001b2b24812ULL, 0x020fe400078efcffULL,
0x000000dfde00720bULL, 0x000fca0003f9d000ULL, 0x0000004f00a37306ULL, 0x000ff0000020d400ULL,
0x0000004d00a27306ULL, 0x000e62000020d400ULL, 0x00000001a6a64812ULL, 0x000fce00078efcffULL,
0x0000004e00307306ULL, 0x000ff00000209400ULL, 0x0000004e004f7306ULL, 0x000ea20000205400ULL,
0x00000001a2a23812ULL, 0x002fce00078efcffULL, 0x0000007500a87306ULL, 0x0002f0000020d400ULL,
0x0000003100dc7306ULL, 0x000fe20000009400ULL, 0x0000010031757824ULL, 0x002fe200078e00ffULL,
0x0000004f3000720bULL, 0x004fc40003f7d000ULL, 0x0000a0002c307811ULL, 0x000fe400078e20ffULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000031008c7306ULL, 0x000e620000005400ULL,
0x00000001a8a82812ULL, 0x008fe400078efcffULL, 0x000000e8e700720bULL, 0x000fca0003f5d000ULL,
0x0000003100977306ULL, 0x0005f0000000d400ULL, 0x0000004e009b7306ULL, 0x000762000020d400ULL,
0x0001000031317824ULL, 0x004fe200078e00ffULL, 0x00000001a3a32812ULL, 0x000fc400078efcffULL,
0x0000008cdc00720bULL, 0x002fe40003f5d000ULL, 0x00000018ff4d7819ULL, 0x000fe20000011431ULL,
0x0000010032317824ULL, 0x000fe200078e00ffULL, 0x0000003200c87306ULL, 0x000fe20000009400ULL,
0x000001003d4e7824ULL, 0x008fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000003200867306ULL, 0x000e620000005400ULL, 0x000000019b9b3812ULL, 0x020fe400078efcffULL,
0x0000000197972812ULL, 0x000fca00078efcffULL, 0x0000007500e37306ULL, 0x000ff00000209400ULL,
0x0000007500e47306ULL, 0x000ea20000205400ULL, 0x00000086c800720bULL, 0x002fce0003f7d000ULL,
0x0000003200837306ULL, 0x0002f0000000d400ULL, 0x0000003300997306ULL, 0x000fe20000009400ULL,
0x0001000032327824ULL, 0x002fe200078e00ffULL, 0x000000e4e300720bULL, 0x004fc80003f9d000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003300987306ULL, 0x000fe20000005400ULL,
0x0000000183833812ULL, 0x008fce00078efcffULL, 0x00000033007e7306ULL, 0x0003f0000000d400ULL,
0x0000002f00d97306ULL, 0x000fe20000209400ULL, 0x0001000033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000002f00db7306ULL, 0x000e700000205400ULL,
0x0000002f00877306ULL, 0x0004f0000020d400ULL, 0x0000004d00e17306ULL, 0x000fe20000209400ULL,
0x00000018ff2f7819ULL, 0x004fc4000001143cULL, 0x000000dbd900720bULL, 0x002fca0003fdd000ULL,
0x0000004d00e27306ULL, 0x000ff00000205400ULL, 0x0000004d00967306ULL, 0x0003e2000020d400ULL,
0x0000000187876812ULL, 0x008fe400078efcffULL, 0x000000a1c600720bULL, 0x000fe20003fdd000ULL,
0x0000010046c67824ULL, 0x000fc400078e00ffULL, 0x0001000046a17824ULL, 0x000fe400078e00ffULL,
0x0000003c009a7306ULL, 0x000fe20000009400ULL, 0x000001003c4d7824ULL, 0x002fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe400000114c6ULL, 0x00000018ffa17819ULL, 0x000fe400000114a1ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000003c00c27306ULL, 0x000fe20000005400ULL,
0x000000017d7d6812ULL, 0x000fce00078efcffULL, 0x0000003c00797306ULL, 0x0003f0000000d400ULL,
0x00000075009c7306ULL, 0x0004e2000020d400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000007600d37306ULL, 0x000fe20000209400ULL,
0x00000018ff757819ULL, 0x004fce0000011431ULL, 0x0000007600d47306ULL, 0x000e620000205400ULL,
0x000000019c9c4812ULL, 0x008fe400078efcffULL, 0x000000e2e100720bULL, 0x000fca0003f9d000ULL,
0x0000003200d57306ULL, 0x000ff00000209400ULL, 0x0000003200d67306ULL, 0x000ea20000205400ULL,
0x000000d4d300720bULL, 0x002fe40003fbd000ULL, 0x0000000196964812ULL, 0x000fc400078efcffULL,
0x000000989900720bULL, 0x000fe20003f9d000ULL, 0x0001000047987824ULL, 0x000fe400078e00ffULL,
0x0000003300d77306ULL, 0x000fe60000209400ULL, 0x00000018ff987819ULL, 0x000fca0000011498ULL,
0x0000003300d87306ULL, 0x000fe20000205400ULL, 0x000000d6d500720bULL, 0x004fe40003f7d000ULL,
0x000000017e7e4812ULL, 0x000fe400078efcffULL, 0x000000c29a00720bULL, 0x000fc60003f9d000ULL,
0x0000003300817306ULL, 0x0003f0000020d400ULL, 0x00000032008b7306ULL, 0x0004e2000020d400ULL,
0x000001003f337824ULL, 0x002fe200078e00ffULL, 0x0000000179794812ULL, 0x000fcc00078efcffULL,
0x0000003c00c97306ULL, 0x000fe20000209400ULL, 0x000001003e327824ULL, 0x004fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003c00ca7306ULL, 0x000e620000205400ULL,
0x000000018b8b3812ULL, 0x008fce00078efcffULL, 0x0000003c00807306ULL, 0x0004f0000020d400ULL,
0x0000007500317306ULL, 0x000fe20000209400ULL, 0x00000018ff3c7819ULL, 0x004fe20000011433ULL,
0x000100003e337824ULL, 0x000fe200078e00ffULL, 0x000000cac900720bULL, 0x002fc80003f9d000ULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000007500e07306ULL, 0x000e700000205400ULL,
0x0000003200b47306ULL, 0x000fe20000209400ULL, 0x0000000180804812ULL, 0x008fce00078efcffULL,
0x0000003200b57306ULL, 0x000fe20000205400ULL, 0x000000e03100720bULL, 0x002fce0003f5d000ULL,
0x00000032007b7306ULL, 0x0003f0000020d400ULL, 0x00000076008a7306ULL, 0x000ea2000020d400ULL,
0x0000010044327824ULL, 0x002fce00078e00ffULL, 0x0000003d00c17306ULL, 0x000ff00000009400ULL,
0x0000003d00c37306ULL, 0x000e620000005400ULL, 0x000000018a8a5812ULL, 0x004fe400078efcffULL,
0x000000d8d700720bULL, 0x000fca0003fbd000ULL, 0x0000003300a47306ULL, 0x000ff00000209400ULL,
0x0000003300a57306ULL, 0x000fe20000205400ULL, 0x000000c3c100720bULL, 0x002fe40003f7d000ULL,
0x0000000181815812ULL, 0x000fca00078efcffULL, 0x0000003300767306ULL, 0x0003f0000020d400ULL,
0x0000007500907306ULL, 0x000ea2000020d400ULL, 0x00000018ff337819ULL, 0x002fe40000011432ULL,
0x000000070f327812ULL, 0x000fca00078e782dULL, 0x0000003300947306ULL, 0x000fe20000209400ULL,
0x000000082d2d7824ULL, 0x000fce00078e0232ULL, 0x0000003300957306ULL, 0x000fe20000205400ULL,
0x0000000190902812ULL, 0x004fe400078efcffULL, 0x000000c77300720bULL, 0x000fe20003f5d000ULL,
0x0000010047c77824ULL, 0x000fc800078e00ffULL, 0x0000003300727306ULL, 0x0003e2000020d400ULL,
0x00000018ffc77819ULL, 0x000fce00000114c7ULL, 0x0000003d006d7306ULL, 0x0004e2000000d400ULL,
0x000000003030783bULL, 0x002e620000000200ULL, 0x0000000178782812ULL, 0x000fcc00078efcffULL,
0x0000005a00af7306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000005a00b07306ULL, 0x000ea20000205400ULL,
0x000000016d6d3812ULL, 0x008fce00078efcffULL, 0x0000004d00cb7306ULL, 0x000ff00000209400ULL,
0x0000004d00cc7306ULL, 0x000ee20000205400ULL, 0x000000b0af00720bULL, 0x004fce0003f7d000ULL,
0x0000003c00aa7306ULL, 0x000fe20000209400ULL, 0x0000007430309231ULL, 0x082fe400003400ffULL,
0x0000007432329231ULL, 0x000fe400003400ffULL, 0x000000b631319231ULL, 0x090fe400003400ffULL,
0x000000b633339231ULL, 0x000fe200003400ffULL, 0x0000003c00ab7306ULL, 0x000fe20000205400ULL,
0x000000cccb00720bULL, 0x008fce0003fbd000ULL, 0x0000003c00757306ULL, 0x0003f0000020d400ULL,
0x0000003f00d17306ULL, 0x000fe20000009400ULL, 0x00000100453c7824ULL, 0x002fca00078e00ffULL,
0x00000018ffdd7819ULL, 0x000fe4000001143cULL, 0x0000003f00d27306ULL, 0x000fe20000005400ULL,
0x0000a0002d3c7811ULL, 0x000fce00078e20ffULL, 0x0000003f00777306ULL, 0x0003f0000000d400ULL,
0x0000002f00ba7306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000002f00bb7306ULL, 0x000ff00000205400ULL,
0x0000002f006e7306ULL, 0x0003f0000020d400ULL, 0x0000005a00697306ULL, 0x000ea2000020d400ULL,
0x00000018ff2f7819ULL, 0x002fce0000011444ULL, 0x0000002f006f7306ULL, 0x000ff00000209400ULL,
0x0000002f00707306ULL, 0x000fe20000205400ULL, 0x0000000169693812ULL, 0x004fe400078efcffULL,
0x000000abaa00720bULL, 0x000fca0003f7d000ULL, 0x0000002f005a7306ULL, 0x000ff0000020d400ULL,
0x0000004d00827306ULL, 0x000e62000020d400ULL, 0x0000000175753812ULL, 0x000fe400078efcffULL,
0x000000858400720bULL, 0x000fca0003f7d000ULL, 0x0000004e00cd7306ULL, 0x000ff00000209400ULL,
0x0000004e00ce7306ULL, 0x000ea20000205400ULL, 0x0000000182825812ULL, 0x002fe400078efcffULL,
0x000000bbba00720bULL, 0x000fc40003fbd000ULL, 0x000000015b5b3812ULL, 0x000fc600078efcffULL,
0x0000007a00647306ULL, 0x000ff00000209400ULL, 0x0000007a00657306ULL, 0x000fe20000205400ULL,
0x000000cecd00720bULL, 0x004fe40003f5d000ULL, 0x000000016e6e5812ULL, 0x000fc400078efcffULL,
0x000000b5b400720bULL, 0x000fe40003fbd000ULL, 0x000000806e6e723eULL, 0x000fe200000010ffULL,
0x0000007a002f7306ULL, 0x000ff0000020d400ULL, 0x0000003e00cf7306ULL, 0x000fe40000009400ULL,
0x000000017b7b5812ULL, 0x000fc400078efcffULL, 0x000000a5a400720bULL, 0x000fc80003fbd000ULL,
0x0000003e00d07306ULL, 0x000e700000005400ULL, 0x0000003d00c47306ULL, 0x000fe20000209400ULL,
0x0000000176765812ULL, 0x000fce00078efcffULL, 0x0000003d00c57306ULL, 0x000fe20000205400ULL,
0x000000d0cf00720bULL, 0x002fce0003fdd000ULL, 0x0000003d007a7306ULL, 0x000ff0000020d400ULL,
0x0000003e007c7306ULL, 0x000e70000000d400ULL, 0x0000003f009e7306ULL, 0x000ff00000209400ULL,
0x0000003f009f7306ULL, 0x000fe20000205400ULL, 0x000000017c7c6812ULL, 0x002fc400078efcffULL,
0x000000939200720bULL, 0x000fe40003fdd000ULL, 0x0000007c7b7c723eULL, 0x000fc600000010ffULL,
0x0000003f00717306ULL, 0x0003f0000020d400ULL, 0x0000004e007f7306ULL, 0x000ea2000020d400ULL,
0x000000003c3c783bULL, 0x002e620000000200ULL, 0x0000000168686812ULL, 0x000fc400078efcffULL,
0x000000959400720bULL, 0x000fe40003fdd000ULL, 0x000000766868723eULL, 0x000fe400000010ffULL,
0x0000004400b77306ULL, 0x000ff00000009400ULL, 0x0000004400b87306ULL, 0x000ee20000005400ULL,
0x000000017f7f2812ULL, 0x004fc400078efcffULL, 0x000000c5c400720bULL, 0x000fe40003f5d000ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000706f00720bULL, 0x000fe20003fdd000ULL,
0x00000044006c7306ULL, 0x000522000000d400ULL, 0x0000006d7f7f723eULL, 0x000fce00000010ffULL,
0x0000004500ac7306ULL, 0x000fe20000009400ULL, 0x0001000044447824ULL, 0x004fe200078e00ffULL,
0x000000b8b700720bULL, 0x008fe40003f9d000ULL, 0x000000017a7a2812ULL, 0x000fe400078efcffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004500ad7306ULL, 0x000ea20000005400ULL,
0x000000743c3c9231ULL, 0x082fe200003400ffULL, 0x000000015a5a6812ULL, 0x000fe200078efcffULL,
0x000000743e3e9231ULL, 0x000fe200003400ffULL, 0x000000666700720bULL, 0x000fe20003fdd000ULL,
0x000000b63d3d9231ULL, 0x080fe200003400ffULL, 0x0000007a696f723eULL, 0x000fe200000010ffULL,
0x000000b63f3f9231ULL, 0x000fe200003400ffULL, 0x00000045004e7306ULL, 0x0002e2000000d400ULL,
0x000000d2d100720bULL, 0x000fc40003f3d000ULL, 0x000000016c6c4812ULL, 0x010fc800078efcffULL,
0x0000006c726c723eULL, 0x000fe200000010ffULL, 0x00000046008e7306ULL, 0x000fe20000009400ULL,
0x0001000045457824ULL, 0x002fe200078e00ffULL, 0x000000adac00720bULL, 0x004fe40003f5d000ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x00000018ffc27819ULL, 0x000fe40000011445ULL,
0x00000046008f7306ULL, 0x000e620000005400ULL, 0x000000b3b145723eULL, 0x000fc400000010ffULL,
0x0000000177771812ULL, 0x000fe400078efcffULL, 0x0000009f9e00720bULL, 0x000fe40003f3d000ULL,
0x000000014e4e2812ULL, 0x008fe200078efcffULL, 0x00000046004d7306ULL, 0x0004e2000000d400ULL,
0x0000006b6a00720bULL, 0x000fce0003f5d000ULL, 0x0000004700887306ULL, 0x000fe20000009400ULL,
0x000000bec046723eULL, 0x004fe400000010ffULL, 0x0000008f8e00720bULL, 0x002fe40003fbd000ULL,
0x0000000171711812ULL, 0x000fe400078efcffULL, 0x0000000159592812ULL, 0x000fe200078efcffULL,
0x0000004700897306ULL, 0x000e620000005400ULL, 0x000000715b69723eULL, 0x000fce00000010ffULL,
0x00000047004c7306ULL, 0x000522000000d400ULL, 0x000000014d4d5812ULL, 0x008fce00078efcffULL,
0x0000004400867306ULL, 0x000fe20000209400ULL, 0x000000bdbf47723eULL, 0x004fe400000010ffULL,
0x000000898800720bULL, 0x002fca0003f3d000ULL, 0x0000004400997306ULL, 0x000e620000205400ULL,
0x00000046305c723cULL, 0x000fee000004185cULL, 0x0000004400737306ULL, 0x0004e2000020d400ULL,
0x000000aeb246723eULL, 0x000fe400000010ffULL, 0x000000a7a847723eULL, 0x000fc400000010ffULL,
0x000000014c4c1812ULL, 0x010fc600078efcffULL, 0x000000dd008c7306ULL, 0x000fe20000209400ULL,
0x000000bcb944723eULL, 0x004fe200000010ffULL, 0x000000463034723cULL, 0x000fe20000041834ULL,
0x000000998600720bULL, 0x002fca0003f9d000ULL, 0x000000dd008d7306ULL, 0x000e620000205400ULL,
0x0000009da246723eULL, 0x000fe200000010ffULL, 0x000000443060723cULL, 0x000fe20000041860ULL,
0x000000979c47723eULL, 0x000fca00000010ffULL, 0x000000dd004f7306ULL, 0x000ea2000020d400ULL,
0x000000a9a644723eULL, 0x000fe200000010ffULL, 0x000000463050723cULL, 0x000fe20000041850ULL,
0x000000a3a045723eULL, 0x000fe400000010ffULL, 0x0000000173734812ULL, 0x008fc600078efcffULL,
0x000000c2009a7306ULL, 0x000fe20000209400ULL, 0x0000008d8c00720bULL, 0x002fe20003f7d000ULL,
0x000000443054723cULL, 0x000fe20000041854ULL, 0x000000839046723eULL, 0x000fe400000010ffULL,
0x0000007e8a47723eULL, 0x000fe400000010ffULL, 0x00000079827e723eULL, 0x000fe200000010ffULL,
0x000000c200c17306ULL, 0x000e620000205400ULL, 0x0000009b9144723eULL, 0x000fe200000010ffULL,
0x0000006e3c60723cULL, 0x000fe20000041860ULL, 0x000000968745723eULL, 0x000fc400000010ffULL,
0x000000735a5a723eULL, 0x000fe400000010ffULL, 0x000000014f4f3812ULL, 0x004fe200078efcffULL,
0x000000c600b17306ULL, 0x000fe40000209400ULL, 0x000000443048723cULL, 0x000fe20000041848ULL,
0x0000004e4f6d723eULL, 0x000fca00000010ffULL, 0x000000c600a87306ULL, 0x000ea20000205400ULL,
0x0000008b7d44723eULL, 0x000fe200000010ffULL, 0x000000463040723cULL, 0x040fe20000041840ULL,
0x000000817845723eULL, 0x000fe400000010ffULL, 0x000000c19a00720bULL, 0x002fe40003f7d000ULL,
0x00000077757d723eULL, 0x000fe200000010ffULL, 0x000000c200747306ULL, 0x000e64000020d400ULL,
0x000000443030723cULL, 0x000fec0000041838ULL, 0x000000c600a07306ULL, 0x000ee2000020d400ULL,
0x000000a8b100720bULL, 0x004fe20003f9d000ULL, 0x0000007e3c5c723cULL, 0x040fec000004185cULL,
0x000000c700977306ULL, 0x000fe20000209400ULL, 0x0000000174743812ULL, 0x002fe200078efcffULL,
0x0000007c3c34723cULL, 0x000fe20000041834ULL, 0x000000656400720bULL, 0x000fc40003f7d000ULL,
0x00000074595b723eULL, 0x000fc600000010ffULL, 0x000000c700847306ULL, 0x000e620000205400ULL,
0x00000001a0a04812ULL, 0x008fe200078efcffULL, 0x000000683c54723cULL, 0x000fe60000041854ULL,
0x0000004da0a0723eULL, 0x000fc600000010ffULL, 0x000000a100467306ULL, 0x000fe20000209400ULL,
0x000000012f2f3812ULL, 0x000fe200078efcffULL, 0x0000006c3c50723cULL, 0x040fec0000041850ULL,
0x000000a100397306ULL, 0x000ea20000205400ULL, 0x000000849700720bULL, 0x002fe20003f5d000ULL,
0x0000005a3c48723cULL, 0x000fec0000041848ULL, 0x0000009800387306ULL, 0x000ff00000209400ULL,
0x0000009800457306ULL, 0x000e620000205400ULL, 0x000000394600720bULL, 0x004fce0003f9d000ULL,
0x000000c700837306ULL, 0x000eb0000020d400ULL, 0x000000a1003b7306ULL, 0x000722000020d400ULL,
0x000000453800720bULL, 0x002fce0003fbd000ULL, 0x0000009800987306ULL, 0x000e62000020d400ULL,
0x0000000183832812ULL, 0x004fc800078efcffULL, 0x0000004c83a1723eULL, 0x008fe400000010ffULL,
0x000000013b3b4812ULL, 0x010fc800078efcffULL, 0x0000003b5858723eULL, 0x000fe200000010ffULL,
0x000000a03c40723cULL, 0x000fe20000041840ULL, 0x0000000198985812ULL, 0x002fc800078efcffULL,
0x000000982f59723eULL, 0x000fce00000010ffULL, 0x000000583c3c723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004004307811ULL, 0x002fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000300300720cULL, 0x000fda0003f24070ULL, 0x0000ee2000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL,
0x0000002f00307305ULL, 0x0002a4000021f000ULL, 0x3fa000002f2f7823ULL, 0x002fe200000100ffULL,
0x000000300000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff2f7624ULL, 0x000fe200078e00ffULL, 0x0000000307317812ULL, 0x000fe200078ec0ffULL,
0x00000004ff307424ULL, 0x000fc600078e00ffULL, 0x000000033100780cULL, 0x000fe20003f25270ULL,
0xfffffffd302f7424ULL, 0x000fca00078e022fULL, 0x000000012f327807ULL, 0x000fe20004800000ULL,
0x00005800092f7a24ULL, 0x000fe400078e02ffULL, 0xffffffffff097424ULL, 0x000fe400078e00ffULL,
0x0000000107077824ULL, 0x000fca00078e0232ULL, 0x000000050700720cULL, 0x000fe20003f26070ULL,
0x000000402f337824ULL, 0x000fe200078e00ffULL, 0x0000006004327811ULL, 0x000fd600078e40ffULL,
0x0000000107319824ULL, 0x000fc800078e020cULL, 0x0000600031309625ULL, 0x000fe200078e0030ULL,
0x00000032032f7217ULL, 0x000fc80007800000ULL, 0x0000000630099981ULL, 0x000362000c1e1900ULL,
0x0000000d33387210ULL, 0x000fe20007f3e0ffULL, 0x000000012f2f7824ULL, 0x000fc800078e0a32ULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e0038447a11ULL, 0x040fe400078240ffULL,
0x000000202f2f7807ULL, 0x000fe40000000000ULL, 0x0000001133307210ULL, 0x042fe40007f5e0ffULL,
0x00005f0038397a11ULL, 0x000fe400008f4439ULL, 0x0000001033327210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff457224ULL, 0x000fe200010e06ffULL, 0x0000002f082f7217ULL, 0x000fc40007800000ULL,
0x00005e0030467a11ULL, 0x000fe200078440ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e06ffULL,
0x00005e0032387a11ULL, 0x000fe200078240ffULL, 0x000000012f3a7824ULL, 0x000fe200078e0a08ULL,
0x00005f0030457a11ULL, 0x000fe400010f4445ULL, 0x00000004ff317819ULL, 0x000fe40000011602ULL,
0x00000012332f7210ULL, 0x000fe40007f7e0ffULL, 0x0000001344307210ULL, 0x000fc40007f9e0ffULL,
0x00005f00323b7a11ULL, 0x000fe200008f443bULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x0000001338327210ULL, 0x000fe40007fbe0ffULL, 0x0000003a3100720cULL, 0x080fe20003f26070ULL,
0x000000ffff317224ULL, 0x000fe200020e0639ULL, 0x00005e002f447a11ULL, 0x000fe200078440ffULL,
0x000000ffff337224ULL, 0x000fe200028e063bULL, 0x0000003af500720cULL, 0x080fe40003f86070ULL,
0x0000003a0e00720cULL, 0x000fc40003fc6070ULL, 0x0000003a0f00720cULL, 0x000fe40003fa6070ULL,
0x0000001346387210ULL, 0x080fe40007f7e0ffULL, 0x00005f002f4c7a11ULL, 0x000fe200010f444cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030147faeULL, 0x0003e2000c901c46ULL,
0x00000013443a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff397224ULL, 0x000fe400018e0645ULL,
0x0000000032157faeULL, 0x0003e4000e101c46ULL, 0x000000ffff3b7224ULL, 0x000fc400010e064cULL,
0x0000000038167faeULL, 0x0003e8000f101c46ULL, 0x000000003a177faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff747f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff2f7984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280008307f8cULL, 0x002fe2000c80043fULL, 0x800000002fff7812ULL, 0x008fc6000784482eULL,
0x01062c0008337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL,
0x0000002f00327305ULL, 0x0002e4000021f000ULL, 0x3fa000002f2f7823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x008fe20003800000ULL, 0x01062c0008337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0100800018397984ULL, 0x000e680000000800ULL, 0x0102800018387984ULL, 0x0007220000000800ULL,
0x0000000a3900720bULL, 0x002fe20003f3d000ULL, 0x00017f027f007947ULL, 0x000fd8000b800000ULL,
0x00000000002f7806ULL, 0x008fc800008e0100ULL, 0x0000ffff2f327812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ffc07424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000010000780cULL, 0x000fe40003f65270ULL,
0x0000000a3900720bULL, 0x000fe20003f34000ULL, 0x00017ed27f007947ULL, 0x000fd8000b800000ULL,
0x00000000002f7806ULL, 0x000fe400008e0100ULL, 0x000000390a317209ULL, 0x040fe40007810000ULL,
0x0000ffff2f2f7812ULL, 0x000fe400078e3cffULL, 0x00000002ff587819ULL, 0x000fe20000011602ULL,
0x800000310a307221ULL, 0x000fe20000010000ULL, 0x010480311800b388ULL, 0x0003e20000000800ULL,
0x0000002f32ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x00000030003a7308ULL, 0x000ee40000000800ULL, 0x0000003a0b0b7220ULL, 0x008fe20000410000ULL,
0x00017e727f007947ULL, 0x000fea000b800000ULL, 0x00001f583a2f7589ULL, 0x0022e400000e0000ULL,
0x0000002f5c5c7220ULL, 0x08cfe40000410000ULL, 0x0000002f5d5d7220ULL, 0x080fe40000410000ULL,
0x0000002f60607220ULL, 0x080fe40000410000ULL, 0x0000002f61617220ULL, 0x080fe40000410000ULL,
0x0000002f34347220ULL, 0x000fc40000410000ULL, 0x0000002f35357220ULL, 0x080fe40000410000ULL,
0x0000002f54547220ULL, 0x080fe40000410000ULL, 0x0000002f55557220ULL, 0x080fe40000410000ULL,
0x0000002f50507220ULL, 0x080fe40000410000ULL, 0x0000002f51517220ULL, 0x080fe40000410000ULL,
0x0000002f48487220ULL, 0x000fc40000410000ULL, 0x0000002f49497220ULL, 0x080fe40000410000ULL,
0x0000002f40407220ULL, 0x080fe40000410000ULL, 0x0000002f41417220ULL, 0x080fe40000410000ULL,
0x0000002f3c3c7220ULL, 0x080fe40000410000ULL, 0x0000002f3d3d7220ULL, 0x000fe20000410000ULL,
0x00017db27f007947ULL, 0x000fea000b800000ULL, 0x00001ff63a2f7589ULL, 0x0004e400000e0000ULL,
0x000000390a0a7209ULL, 0x000fe20007810000ULL, 0x0000002f5e5e7220ULL, 0x08cfe20000410000ULL,
0x00000001ffc07807ULL, 0x000fe20000800000ULL, 0x0000002f5f5f7220ULL, 0x000fc40000410000ULL,
0x8000000a39391221ULL, 0x000fe40000010000ULL, 0x0000002f62627220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b39391820ULL, 0x000fe40000410000ULL, 0x0000002f63637220ULL, 0x080fe40000410000ULL,
0x0000003900191308ULL, 0x000ea20000000800ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f37377220ULL, 0x000fc40000410000ULL, 0x0000002f56567220ULL, 0x080fe40000410000ULL,
0x0000002f57577220ULL, 0x080fe40000410000ULL, 0x0000002f52527220ULL, 0x080fe40000410000ULL,
0x0000002f53537220ULL, 0x080fe40000410000ULL, 0x0000002f4a4a7220ULL, 0x080fe40000410000ULL,
0x0000002f4b4b7220ULL, 0x000fc40000410000ULL, 0x0000002f42427220ULL, 0x080fe40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x080fe40000410000ULL,
0x0000002f3f3f7220ULL, 0x000fe40000410000ULL, 0x0000003819381220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000b380b7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff2f7984ULL, 0x000ee40000000800ULL, 0x800000002fff7812ULL, 0x008fc4000782482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL, 0x0000002f00307305ULL, 0x000724000021f000ULL,
0x3fa000002f2f7823ULL, 0x008fe200000100ffULL, 0x000000300000735dULL, 0x010fe20003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fe4000782482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000019ff2e723eULL, 0x000fe400000010ffULL,
0x00000002ff587819ULL, 0x002fc40000011602ULL, 0x000054102e327816ULL, 0x000fe2000000002eULL,
0x00017b627f007947ULL, 0x000fea000b800000ULL, 0x00001f5832737589ULL, 0x0002e400000e0000ULL,
0x00017ba27f007947ULL, 0x000fea000b800000ULL, 0x00001ff6326b7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff587224ULL, 0x002fe200078e00fbULL,
0x0000700000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0001894000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff587224ULL, 0x002fe200078e00faULL,
0x0000706000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000188e000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001a38783bULL, 0x000f280000004200ULL,
0x000000001b44783bULL, 0x000fe80000004200ULL, 0x000000001c58783bULL, 0x002fe80000004200ULL,
0x000000001d4c783bULL, 0x000e620000004200ULL, 0x0000010038717824ULL, 0x010fe200078e00ffULL,
0x0000003900f07306ULL, 0x000fe20000009400ULL, 0x00000018ff2f7819ULL, 0x004fc40000011439ULL,
0x00000018ff2e7819ULL, 0x000fe40000011438ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x00000018ff317819ULL, 0x000fe2000001143bULL, 0x0000003900bf7306ULL, 0x000ea20000005400ULL,
0x00000018ff307819ULL, 0x000fe4000001143aULL, 0x00000018ff727819ULL, 0x002fe4000001144dULL,
0x00000018ff787819ULL, 0x000fc4000001144eULL, 0x00000018ff647819ULL, 0x000fe2000001144cULL,
0x00000071009e7306ULL, 0x000fe20000209400ULL, 0x00000018ff7b7819ULL, 0x000fce000001144fULL,
0x0000007100f47306ULL, 0x000e620000205400ULL, 0x000000bff000720bULL, 0x004fce0003fbd000ULL,
0x0000007100ba7306ULL, 0x000530000020d400ULL, 0x0000002f008c7306ULL, 0x000fe20000209400ULL,
0x000001003a717824ULL, 0x004fe200078e00ffULL, 0x000000f49e00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000002f00ea7306ULL, 0x000fee0000205400ULL,
0x00000001baba2812ULL, 0x010fe200078efcffULL, 0x0000002f00a87306ULL, 0x0003f0000020d400ULL,
0x0000003800f17306ULL, 0x000fe20000009400ULL, 0x00000018ff2f7819ULL, 0x002fce0000011445ULL,
0x0000003800be7306ULL, 0x000e700000005400ULL, 0x0000003800ad7306ULL, 0x000530000000d400ULL,
0x0000002f00c37306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fe200078e00ffULL,
0x000000bef100720bULL, 0x002fc80003f3d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000002f00c47306ULL, 0x000fee0000205400ULL, 0x00000001adad1812ULL, 0x010fe200078efcffULL,
0x0000002f00877306ULL, 0x0003f0000020d400ULL, 0x0000003900ab7306ULL, 0x000ea2000000d400ULL,
0x00000018ff2f7819ULL, 0x002fce0000011459ULL, 0x0000007100e87306ULL, 0x000ff00000209400ULL,
0x0000007100e97306ULL, 0x000e620000205400ULL, 0x00000001abab5812ULL, 0x004fce00078efcffULL,
0x0000002f00b87306ULL, 0x000ff00000209400ULL, 0x0000002f00b07306ULL, 0x000fe20000205400ULL,
0x000000e9e800720bULL, 0x002fce0003fbd000ULL, 0x0000002f00687306ULL, 0x000ff0000020d400ULL,
0x0000003800f27306ULL, 0x000ff00000209400ULL, 0x0000003800f37306ULL, 0x000e700000205400ULL,
0x0000003800ac7306ULL, 0x000530000020d400ULL, 0x0000003b00e77306ULL, 0x000fe20000009400ULL,
0x000001003b387824ULL, 0x004fe200078e00ffULL, 0x000000f3f200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003b008d7306ULL, 0x000fee0000005400ULL,
0x00000001acac6812ULL, 0x010fe200078efcffULL, 0x0000003b00a17306ULL, 0x0003e2000000d400ULL,
0x000000ea8c00720bULL, 0x000fce0003fdd000ULL, 0x0000007200697306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000072006a7306ULL, 0x000fe20000205400ULL, 0x00000001a8a86812ULL, 0x000fce00078efcffULL,
0x00000072002f7306ULL, 0x0003f0000020d400ULL, 0x0000007100a77306ULL, 0x000ea2000020d400ULL,
0x0000010039727824ULL, 0x042fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003b00e57306ULL, 0x000fe20000209400ULL, 0x00000001a7a75812ULL, 0x004fce00078efcffULL,
0x0000007200ee7306ULL, 0x000ff00000209400ULL, 0x0000007200ef7306ULL, 0x000e700000205400ULL,
0x0000003b00e67306ULL, 0x000eb00000205400ULL, 0x0000002e006f7306ULL, 0x000fe20000209400ULL,
0x000000efee00720bULL, 0x002fce0003f9d000ULL, 0x0000002e00977306ULL, 0x000e620000205400ULL,
0x000000e6e500720bULL, 0x004fce0003fbd000ULL, 0x0000002e00a97306ULL, 0x000530000020d400ULL,
0x0000003900ec7306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x004fe40000011444ULL,
0x000000976f00720bULL, 0x002fca0003f7d000ULL, 0x0000003900ed7306ULL, 0x000e700000205400ULL,
0x0000003900aa7306ULL, 0x0004e2000020d400ULL, 0x00000001a9a93812ULL, 0x010fe400078efcffULL,
0x0000008de700720bULL, 0x000fca0003f7d000ULL, 0x00000044009a7306ULL, 0x000fe20000009400ULL,
0x0000010044397824ULL, 0x004fe200078e00ffULL, 0x000000edec00720bULL, 0x002fc80003f3d000ULL,
0x00000018ff717819ULL, 0x000fe40000011439ULL, 0x0000004400c97306ULL, 0x000fe20000005400ULL,
0x00000001a1a13812ULL, 0x000fcc00078efcffULL, 0x00000001aaaa1812ULL, 0x008fe200078efcffULL,
0x00000044008e7306ULL, 0x0003f0000000d400ULL, 0x0000003a00987306ULL, 0x000fe20000009400ULL,
0x0001000044447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000003a00eb7306ULL, 0x000e700000005400ULL, 0x0000003a00a67306ULL, 0x0004f0000000d400ULL,
0x0000007200bb7306ULL, 0x0008e2000020d400ULL, 0x000100003a3a7824ULL, 0x004fe200078e00ffULL,
0x000000eb9800720bULL, 0x002fc80003f5d000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b009c7306ULL, 0x0002a2000020d400ULL, 0x0000010047727824ULL, 0x010fcc00078e00ffULL,
0x00000001a6a62812ULL, 0x008fe200078efcffULL, 0x00000030007a7306ULL, 0x000fe20000209400ULL,
0x00000100463b7824ULL, 0x002fe200078e00ffULL, 0x00000001bbbb4812ULL, 0x000fcc00078efcffULL,
0x0000003000797306ULL, 0x000e620000205400ULL, 0x000000019c9c5812ULL, 0x004fce00078efcffULL,
0x0000004400dc7306ULL, 0x000ff00000209400ULL, 0x0000004400dd7306ULL, 0x000ea20000205400ULL,
0x000000797a00720bULL, 0x002fce0003f9d000ULL, 0x0000003800997306ULL, 0x000ff00000209400ULL,
0x0000003800e27306ULL, 0x000e620000205400ULL, 0x000000dddc00720bULL, 0x004fce0003fbd000ULL,
0x0000003800a57306ULL, 0x0004f0000020d400ULL, 0x0000003a00e37306ULL, 0x000fe20000209400ULL,
0x0000010045387824ULL, 0x004fe200078e00ffULL, 0x000000e29900720bULL, 0x002fe20003f3d000ULL,
0x000001004c997824ULL, 0x000fca00078e00ffULL, 0x0000003a00e47306ULL, 0x000e620000205400ULL,
0x00000018ffe27819ULL, 0x000fcc0000011499ULL, 0x00000001a5a51812ULL, 0x008fe200078efcffULL,
0x0000003a00a47306ULL, 0x0004e2000020d400ULL, 0x000000c99a00720bULL, 0x000fce0003f3d000ULL,
0x0000007100da7306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x004fe40000011438ULL,
0x000000e4e300720bULL, 0x002fc60003fdd000ULL, 0x000000018e8e1812ULL, 0x000fe400078efcffULL,
0x0000007100db7306ULL, 0x000e700000205400ULL, 0x00000071009b7306ULL, 0x0005e2000020d400ULL,
0x00000001a4a46812ULL, 0x008fce00078efcffULL, 0x00000030009f7306ULL, 0x000722000020d400ULL,
0x00000018ff717819ULL, 0x004fe4000001143bULL, 0x000000dbda00720bULL, 0x002fca0003f7d000ULL,
0x0000003a00387306ULL, 0x000fe20000209400ULL, 0x00000018ff307819ULL, 0x008fce0000011446ULL,
0x0000003a00397306ULL, 0x000e620000205400ULL, 0x000000019f9f4812ULL, 0x010fe400078efcffULL,
0x000000019b9b3812ULL, 0x000fc800078efcffULL, 0x0000008e9b8e723eULL, 0x000fe200000010ffULL,
0x0000003a00947306ULL, 0x000eb0000020d400ULL, 0x0000004400967306ULL, 0x000ee2000020d400ULL,
0x000000393800720bULL, 0x002fe20003f9d000ULL, 0x000001004d387824ULL, 0x000fcc00078e00ffULL,
0x00000071003a7306ULL, 0x000fec0000209400ULL, 0x0000000194944812ULL, 0x004fe400078efcffULL,
0x00000071003b7306ULL, 0x000e620000205400ULL, 0x0000000196965812ULL, 0x008fce00078efcffULL,
0x0000004500707306ULL, 0x000ff00000009400ULL, 0x0000004500c87306ULL, 0x000ea20000005400ULL,
0x0000003b3a00720bULL, 0x002fce0003fbd000ULL, 0x0000004500897306ULL, 0x0002f0000000d400ULL,
0x0000003100ca7306ULL, 0x000fe20000209400ULL, 0x0001000045457824ULL, 0x002fe200078e00ffULL,
0x000000c87000720bULL, 0x004fc80003fdd000ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003100cb7306ULL, 0x000e6e0000205400ULL, 0x0000000189896812ULL, 0x008fe200078efcffULL,
0x0000003100937306ULL, 0x0004e2000020d400ULL, 0x000000c4c300720bULL, 0x000fce0003fdd000ULL,
0x0000004700c17306ULL, 0x000fe20000009400ULL, 0x00000018ff317819ULL, 0x004fe40000011447ULL,
0x000000cbca00720bULL, 0x002fc60003f5d000ULL, 0x0000000187876812ULL, 0x000fe400078efcffULL,
0x0000004700c27306ULL, 0x000e700000005400ULL, 0x0000004700817306ULL, 0x000522000000d400ULL,
0x0000000193932812ULL, 0x008fc800078efcffULL, 0x0000009c9393723eULL, 0x000fc600000010ffULL,
0x0000003000b77306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x004fe200078e00ffULL,
0x000000c2c100720bULL, 0x002fe40003f9d000ULL, 0x00009910c0c27816ULL, 0x000fe200000000ffULL,
0x000100004cc07824ULL, 0x000fc600078e00ffULL, 0x0000003000af7306ULL, 0x000e640000205400ULL,
0x00000018ffc07819ULL, 0x000fca00000114c0ULL, 0x0000000181814812ULL, 0x010fe200078efcffULL,
0x00000030007e7306ULL, 0x0005f0000020d400ULL, 0x00000071008a7306ULL, 0x000722000020d400ULL,
0x00000018ff307819ULL, 0x004fc4000001145aULL, 0x000000afb700720bULL, 0x002fe20003fdd000ULL,
0x000000ffffaf7224ULL, 0x000fc800078e00c2ULL, 0x0000004600917306ULL, 0x000fe20000009400ULL,
0x00000018ff717819ULL, 0x008fce0000011447ULL, 0x0000004600c57306ULL, 0x000e620000005400ULL,
0x000000018a8a5812ULL, 0x010fe400078efcffULL, 0x000000017e7e6812ULL, 0x000fca00078efcffULL,
0x0000004600827306ULL, 0x0004f0000000d400ULL, 0x0000004500de7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000c59100720bULL, 0x002fcc0003f3d000ULL,
0x0000004500df7306ULL, 0x000e6e0000205400ULL, 0x0000000182821812ULL, 0x008fe200078efcffULL,
0x0000004500957306ULL, 0x000ea2000020d400ULL, 0x000000ffaf00720cULL, 0x000fe40003f25270ULL,
0x000000828a8a723eULL, 0x000fca00000010ffULL, 0x0000003000a07306ULL, 0x000fe20000209400ULL,
0x000000dfde00720bULL, 0x002fce0003f7d000ULL, 0x0000003000927306ULL, 0x000fec0000205400ULL,
0x0000000195953812ULL, 0x004fe400078efcffULL, 0x0000003000677306ULL, 0x000ff0000020d400ULL,
0x0000007100447306ULL, 0x000ff00000209400ULL, 0x0000007100457306ULL, 0x000e700000205400ULL,
0x0000007800337306ULL, 0x000ff00000209400ULL, 0x0000007800657306ULL, 0x000fe20000205400ULL,
0x000000454400720bULL, 0x002fe20003fbd000ULL, 0x000100004d447824ULL, 0x000fe200078e00ffULL,
0x000000aaa845723eULL, 0x000fca00000010ffULL, 0x0000007800307306ULL, 0x0003f0000020d400ULL,
0x0000002e00c67306ULL, 0x000fe20000209400ULL, 0x00000018ff787819ULL, 0x002fe40000011472ULL,
0x00000018ff727819ULL, 0x000fe20000011446ULL, 0x0000010058467824ULL, 0x000fc800078e00ffULL,
0x0000002e00c77306ULL, 0x000e700000205400ULL, 0x0000002e00887306ULL, 0x0004f0000020d400ULL,
0x0000005800b97306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x004fc40000011458ULL,
0x000000c7c600720bULL, 0x002fe40003f5d000ULL, 0x00000018ffc67819ULL, 0x000fe40000011438ULL,
0x0000a8001e387811ULL, 0x000fe200078e20ffULL, 0x0000005800b27306ULL, 0x000fea0000005400ULL,
0x000000003838783bULL, 0x000e660000000200ULL, 0x0000005800767306ULL, 0x0005e2000000d400ULL,
0x0000000188882812ULL, 0x008fc800078efcffULL, 0x000000968888723eULL, 0x000fc600000010ffULL,
0x0000007100857306ULL, 0x000722000020d400ULL, 0x0001000058587824ULL, 0x004fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003100b67306ULL, 0x000fe20000209400ULL,
0x000001005a717824ULL, 0x008fce00078e00ffULL, 0x0000003100b57306ULL, 0x000ea20000205400ULL,
0x0000000185855812ULL, 0x010fce00078efcffULL, 0x0000005800d07306ULL, 0x000fe20000209400ULL,
0x0000007338389231ULL, 0x082fe400003400ffULL, 0x000000733a3a9231ULL, 0x000fca00003400ffULL,
0x0000005800d17306ULL, 0x000e620000205400ULL, 0x000000b5b600720bULL, 0x004fe20003f9d000ULL,
0x000001004fb67824ULL, 0x000fe200078e00ffULL, 0x0000006b39399231ULL, 0x080fe200003400ffULL,
0x000001004eb57824ULL, 0x000fe200078e00ffULL, 0x0000006b3b3b9231ULL, 0x000fe400003400ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x00000031007f7306ULL, 0x0004e2000020d400ULL,
0x00000018ffb57819ULL, 0x000fce00000114b5ULL, 0x0000005800807306ULL, 0x0008e2000020d400ULL,
0x000000d1d000720bULL, 0x002fe40003fbd000ULL, 0x00000018ff317819ULL, 0x004fca000001145bULL,
0x0000005900b17306ULL, 0x000fe20000009400ULL, 0x00000018ff587819ULL, 0x010fe20000011471ULL,
0x000001005b717824ULL, 0x000fe200078e00ffULL, 0x000000017f7f4812ULL, 0x008fc800078efcffULL,
0x000000857f7f723eULL, 0x000fe200000010ffULL, 0x0000005900b47306ULL, 0x000e620000005400ULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x000000b0b800720bULL, 0x000fca0003fbd000ULL,
0x0000007800d87306ULL, 0x000ff00000209400ULL, 0x0000007800d97306ULL, 0x000ea20000205400ULL,
0x000000b4b100720bULL, 0x002fe40003f9d000ULL, 0x0000000168685812ULL, 0x000fca00078efcffULL,
0x00000078008b7306ULL, 0x0002f0000020d400ULL, 0x0000005900777306ULL, 0x000f22000000d400ULL,
0x00000018ff787819ULL, 0x002fe40000011446ULL, 0x000000d9d800720bULL, 0x004fca0003f5d000ULL,
0x0000007800467306ULL, 0x000ff00000209400ULL, 0x0000007800477306ULL, 0x000e620000205400ULL,
0x000000018b8b2812ULL, 0x008fe400078efcffULL, 0x0000000177774812ULL, 0x010fc400078efcffULL,
0x000000b2b900720bULL, 0x000fe40003f5d000ULL, 0x000000818b8b723eULL, 0x000fe200000010ffULL,
0x0000007800837306ULL, 0x0004ec000020d400ULL, 0x0000008a3840723cULL, 0x000fe40000041840ULL,
0x0000007200e07306ULL, 0x000fe20000209400ULL, 0x00000018ff787819ULL, 0x004fc40000011471ULL,
0x000000474600720bULL, 0x002fe40003fdd000ULL, 0x0000000176762812ULL, 0x000fe400078efcffULL,
0x000000adba46723eULL, 0x000fe200000010ffULL, 0x0000007200e17306ULL, 0x000e620000205400ULL,
0x000000abbb47723eULL, 0x000fce00000010ffULL, 0x0000005800cc7306ULL, 0x000fe20000209400ULL,
0x0000000183836812ULL, 0x008fe200078efcffULL, 0x00000046385c723cULL, 0x000fe6000004185cULL,
0x000000768376723eULL, 0x000fc600000010ffULL, 0x0000005800cd7306ULL, 0x000ea20000205400ULL,
0x000000e1e000720bULL, 0x002fce0003f7d000ULL, 0x0000007800bc7306ULL, 0x000ff00000209400ULL,
0x0000007800bd7306ULL, 0x000e620000205400ULL, 0x000000cdcc00720bULL, 0x004fce0003f9d000ULL,
0x0000007200867306ULL, 0x0004f0000020d400ULL, 0x00000058007c7306ULL, 0x0008e2000020d400ULL,
0x0000010059727824ULL, 0x044fe200078e00ffULL, 0x000000bdbc00720bULL, 0x002fe20003fbd000ULL,
0x0001000059597824ULL, 0x000fc600078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000007800717306ULL, 0x000e62000020d400ULL, 0x000100005a587824ULL, 0x010fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000000186863812ULL, 0x008fe400078efcffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000002e00b37306ULL, 0x000fe20000209400ULL,
0x000000017c7c4812ULL, 0x000fc400078efcffULL, 0x00000092a000720bULL, 0x000fe40003f9d000ULL,
0x000000a49f92723eULL, 0x000fe400000010ffULL, 0x000000867e7e723eULL, 0x000fe200000010ffULL,
0x0000002e00ae7306ULL, 0x000ea20000205400ULL, 0x0000000171715812ULL, 0x002fc600078efcffULL,
0x000000923854723cULL, 0x000fe80000041854ULL, 0x0000003100907306ULL, 0x000fe20000209400ULL,
0x0000000167674812ULL, 0x000fce00078efcffULL, 0x00000031008f7306ULL, 0x000e620000205400ULL,
0x000000aeb300720bULL, 0x004fe20003f7d000ULL, 0x000100004fae7824ULL, 0x000fe400078e00ffULL,
0x000100004eb37824ULL, 0x000fc600078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x0000007200d27306ULL, 0x000fe20000209400ULL, 0x00000018ffb37819ULL, 0x000fce00000114b3ULL,
0x0000007200d37306ULL, 0x000ea20000205400ULL, 0x0000008f9000720bULL, 0x002fe40003fbd000ULL,
0x00000089948f723eULL, 0x000fe400000010ffULL, 0x000000958789723eULL, 0x000fc600000010ffULL,
0x0000005a00d67306ULL, 0x000fe40000009400ULL, 0x0000008e3850723cULL, 0x040fec0000041850ULL,
0x0000005a00d77306ULL, 0x000e620000005400ULL, 0x000000d3d200720bULL, 0x004fe20003f5d000ULL,
0x000000883848723cULL, 0x000fec0000041848ULL, 0x0000002e006c7306ULL, 0x000eb0000020d400ULL,
0x0000003100327306ULL, 0x000ee2000020d400ULL, 0x000000d7d600720bULL, 0x002fce0003fdd000ULL,
0x0000007200847306ULL, 0x000e62000020d400ULL, 0x000000016c6c3812ULL, 0x004fc800078efcffULL,
0x000000806c6c723eULL, 0x000fc600000010ffULL, 0x0000005a007d7306ULL, 0x000ea2000000d400ULL,
0x0000000132325812ULL, 0x008fce00078efcffULL, 0x0000005900d47306ULL, 0x000fe20000209400ULL,
0x0000000184842812ULL, 0x002fc800078efcffULL, 0x000000778477723eULL, 0x000fc600000010ffULL,
0x0000005900d57306ULL, 0x000e620000205400ULL, 0x000000017d7d6812ULL, 0x004fc800078efcffULL,
0x0000007d7c7c723eULL, 0x000fc600000010ffULL, 0x0000005b00ce7306ULL, 0x000ff00000009400ULL,
0x0000005b00cf7306ULL, 0x000ea20000005400ULL, 0x000000d5d400720bULL, 0x002fce0003f7d000ULL,
0x0000005800a27306ULL, 0x000ff00000209400ULL, 0x0000005800a37306ULL, 0x000e620000205400ULL,
0x000000cfce00720bULL, 0x004fce0003f5d000ULL, 0x000000e200997306ULL, 0x000ff00000209400ULL,
0x000000e2009a7306ULL, 0x000ea20000205400ULL, 0x000000a3a200720bULL, 0x002fce0003fdd000ULL,
0x000000c600917306ULL, 0x000ff00000209400ULL, 0x000000c600c17306ULL, 0x000e620000205400ULL,
0x0000009a9900720bULL, 0x004fce0003f9d000ULL, 0x00000064006d7306ULL, 0x000ff00000209400ULL,
0x00000064006e7306ULL, 0x000fe20000205400ULL, 0x000000c19100720bULL, 0x002fce0003fbd000ULL,
0x00000064002e7306ULL, 0x000ff0000020d400ULL, 0x0000007b00667306ULL, 0x000ff00000209400ULL,
0x0000007b00647306ULL, 0x000ff00000205400ULL, 0x0000007b00317306ULL, 0x000ff0000020d400ULL,
0x00000059007b7306ULL, 0x0002b0000020d400ULL, 0x0000004f00797306ULL, 0x000fe20000009400ULL,
0x000100005b597824ULL, 0x002fca00078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000004f007a7306ULL, 0x000fe20000005400ULL, 0x000000017b7b3812ULL, 0x004fce00078efcffULL,
0x0000004f005a7306ULL, 0x0003f0000000d400ULL, 0x0000004c00be7306ULL, 0x000fe20000009400ULL,
0x00000018ff4f7819ULL, 0x002fe40000011444ULL, 0x000000aca944723eULL, 0x000fca00000010ffULL,
0x0000004c00bf7306ULL, 0x000e640000005400ULL, 0x000000443860723cULL, 0x000fec0000041860ULL,
0x0000004c006f7306ULL, 0x000ea2000000d400ULL, 0x0000a8001f447811ULL, 0x000fcc00078e20ffULL,
0x000000004444783bULL, 0x000ee20000000200ULL, 0x0000005b00727306ULL, 0x000f22000000d400ULL,
0x000000bfbe00720bULL, 0x002fce0003f7d000ULL, 0x0000005800787306ULL, 0x000e6c000020d400ULL,
0x000000016f6f3812ULL, 0x004fe400078efcffULL, 0x000000e200707306ULL, 0x000ea2000020d400ULL,
0x0000000172722812ULL, 0x010fe400078efcffULL, 0x0000006e6d00720bULL, 0x000fc40003f7d000ULL,
0x00000072717d723eULL, 0x000fe400000010ffULL, 0x0000007b686d723eULL, 0x000fe200000010ffULL,
0x000000c6004c7306ULL, 0x000f22000020d400ULL, 0x0000000178786812ULL, 0x002fc800078efcffULL,
0x000000786778723eULL, 0x000fc600000010ffULL, 0x00000059009d7306ULL, 0x000fe20000209400ULL,
0x0000000170704812ULL, 0x004fe400078efcffULL, 0x000000012e2e3812ULL, 0x000fe400078efcffULL,
0x0000007a7900720bULL, 0x000fe20003f7d000ULL, 0x0000007344449231ULL, 0x088fe400003400ffULL,
0x00000059009e7306ULL, 0x000e620000205400ULL, 0x000000014c4c5812ULL, 0x010fe200078efcffULL,
0x0000007346469231ULL, 0x000fe200003400ffULL, 0x0000006f7070723eULL, 0x000fe200000010ffULL,
0x0000006b45459231ULL, 0x000fc400003400ffULL, 0x0000006b47479231ULL, 0x000fe400003400ffULL,
0x0000004d00977306ULL, 0x000fe40000009400ULL, 0x000000015a5a3812ULL, 0x000fc600078efcffULL,
0x00000076445c723cULL, 0x000fe6000004185cULL, 0x0000004d00987306ULL, 0x000ea20000005400ULL,
0x0000009e9d00720bULL, 0x002fc80003f5d000ULL, 0x0000006c4460723cULL, 0x000fe60000041860ULL,
0x000000c000af7306ULL, 0x000ff00000209400ULL, 0x000000c000b27306ULL, 0x000e620000205400ULL,
0x000000989700720bULL, 0x004fce0003fdd000ULL, 0x0000004f00b17306ULL, 0x000ff00000209400ULL,
0x0000004f00b07306ULL, 0x000ea20000205400ULL, 0x000000b2af00720bULL, 0x002fce0003f9d000ULL,
0x0000004d00587306ULL, 0x000e70000000d400ULL, 0x00000059005b7306ULL, 0x000ee2000020d400ULL,
0x000000b0b100720bULL, 0x004fce0003fbd000ULL, 0x000000c0004d7306ULL, 0x000ea2000020d400ULL,
0x0000000158586812ULL, 0x002fe400078efcffULL, 0x0000006a6900720bULL, 0x000fe40003fdd000ULL,
0x000000584c71723eULL, 0x000fc600000010ffULL, 0x0000004f00ac7306ULL, 0x000322000020d400ULL,
0x000000015b5b2812ULL, 0x008fc600078efcffULL, 0x000000704450723cULL, 0x000fe20000041850ULL,
0x0000005b3279723eULL, 0x000fc600000010ffULL, 0x0000004e008c7306ULL, 0x000fe20000009400ULL,
0x000000a1a54f723eULL, 0x002fe400000010ffULL, 0x000000014d4d4812ULL, 0x004fe200078efcffULL,
0x000000784454723cULL, 0x000fe20000041854ULL, 0x000000012f2f6812ULL, 0x000fe400078efcffULL,
0x000000653300720bULL, 0x000fe20003fdd000ULL, 0x0000004e008d7306ULL, 0x000e620000005400ULL,
0x00000001acac5812ULL, 0x010fe400078efcffULL, 0x0000004d2e2e723eULL, 0x000fc400000010ffULL,
0x000000ac2f2f723eULL, 0x000fc600000010ffULL, 0x000000b500a87306ULL, 0x000fe80000209400ULL,
0x0000000130306812ULL, 0x000fe200078efcffULL, 0x0000002e4448723cULL, 0x000fe60000041848ULL,
0x000000b5009f7306ULL, 0x000ea20000205400ULL, 0x0000008d8c00720bULL, 0x002fce0003f5d000ULL,
0x000000b600907306ULL, 0x000ff00000209400ULL, 0x000000b600877306ULL, 0x000e620000205400ULL,
0x0000009fa800720bULL, 0x004fce0003f9d000ULL, 0x0000004e00597306ULL, 0x0004f0000000d400ULL,
0x000000b600817306ULL, 0x000f22000020d400ULL, 0x000000a6a74e723eULL, 0x004fe400000010ffULL,
0x000000879000720bULL, 0x002fca0003fbd000ULL, 0x0000004e3834723cULL, 0x000fe20000041834ULL,
0x000000b5004e7306ULL, 0x000e62000020d400ULL, 0x0000000159592812ULL, 0x008fcc00078efcffULL,
0x0000007e3838723cULL, 0x000fe2000004183cULL, 0x000000b3004f7306ULL, 0x000fe20000209400ULL,
0x0000000181815812ULL, 0x010fce00078efcffULL, 0x000000b3003c7306ULL, 0x000ea20000205400ULL,
0x000000014e4e4812ULL, 0x002fe400078efcffULL, 0x000000646600720bULL, 0x000fe40003f9d000ULL,
0x000000594e4e723eULL, 0x000fe400000010ffULL, 0x0000007c4434723cULL, 0x000fe20000041834ULL,
0x000000ae003d7306ULL, 0x000ff00000209400ULL, 0x000000ae003e7306ULL, 0x000e620000205400ULL,
0x0000003c4f00720bULL, 0x004fc40003f5d000ULL, 0x0000000131314812ULL, 0x000fe400078efcffULL,
0x0000005a814f723eULL, 0x000fc600000010ffULL, 0x000000b300b37306ULL, 0x000ea8000020d400ULL,
0x0000004e4440723cULL, 0x000fe80000041840ULL, 0x000000ae00ae7306ULL, 0x000ee2000020d400ULL,
0x0000003e3d00720bULL, 0x002fe40003fbd000ULL, 0x00000001b3b32812ULL, 0x004fc800078efcffULL,
0x000000b33030723eULL, 0x000fce00000010ffULL, 0x00000001aeae5812ULL, 0x008fc800078efcffULL,
0x000000ae3131723eULL, 0x000fce00000010ffULL, 0x000000304438723cULL, 0x000fe20000041838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff2e7f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe4000784482fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc4000784482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe4000784482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00005800092e7a24ULL, 0x020fc800078e02ffULL, 0x000000402e307824ULL, 0x000fe200078e00ffULL,
0x00000080042e7811ULL, 0x000fc800078e40ffULL, 0x0000002030317210ULL, 0x040fe40007f5e0ffULL,
0x00000021303c7210ULL, 0x000fe40007f7e0ffULL, 0x0000002e032f7217ULL, 0x000fe20007800000ULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005e00313e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005e003c447a11ULL, 0x000fe200078640ffULL,
0x000000012f2f7824ULL, 0x000fe200078e0a2eULL, 0x00005f0031337a11ULL, 0x000fc400010f4432ULL,
0x00000022302e7210ULL, 0x000fe40007f5e0ffULL, 0x00005f003c3d7a11ULL, 0x000fe400018f443dULL,
0x0000002330307210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e06ffULL,
0x000000202f2f7807ULL, 0x000fe40000000000ULL, 0x00005e002e327a11ULL, 0x000fe200078440ffULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x0000002f082f7217ULL, 0x000fc40007800000ULL,
0x00005e0030467a11ULL, 0x000fe400078640ffULL, 0x00005f002e3f7a11ULL, 0x000fe200010f443fULL,
0x000000012f3c7824ULL, 0x000fe200078e0a08ULL, 0x00005f0030457a11ULL, 0x000fe400018f4445ULL,
0x000000133e2e7210ULL, 0x080fe40007f7e0ffULL, 0x00000004ff317819ULL, 0x000fe40000011602ULL,
0x0000001344307210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200018e0633ULL,
0x0000001332327210ULL, 0x000fc40007fbe0ffULL, 0x0000003c3100720cULL, 0x080fe20003f46070ULL,
0x000000ffff317224ULL, 0x000fe200020e063dULL, 0x0000003cf500720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200028e063fULL, 0x0000003c0e00720cULL, 0x080fe40003f86070ULL,
0x0000003c0f00720cULL, 0x000fe40003fa6070ULL, 0x00000013463c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0645ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e247faeULL, 0x0003e8000d101c46ULL, 0x0000000030257faeULL, 0x0003e8000d901c46ULL,
0x0000000032267faeULL, 0x0003e8000e101c46ULL, 0x000000003c277faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff2e7f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844875ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e002fULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff2f7984ULL, 0x000e640000000800ULL,
0x800000002fff7812ULL, 0x002fe40007844875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL,
0x0000002f00307305ULL, 0x0002a4000021f000ULL, 0x3fa000002f2f7823ULL, 0x002fe200000100ffULL,
0x000000300000735dULL, 0x004fe20003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000019ff2f723eULL, 0x000fe400000010ffULL, 0x00000002ff587819ULL, 0x000fe40000011602ULL,
0x000054102f327816ULL, 0x000fe2000000002fULL, 0x000157c27f007947ULL, 0x000fea000b800000ULL,
0x00001f5832b97589ULL, 0x0002a400000e0000ULL, 0x000158027f007947ULL, 0x000fea000b800000ULL,
0x00001ff632ba7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00fbULL, 0x0000947000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x000164d000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00faULL, 0x000094d000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0001647000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000283c783bULL, 0x000f680000004200ULL, 0x000000002930783bULL, 0x00ae680000004200ULL,
0x000000002a4c783bULL, 0x000ee20000004200ULL, 0x00000018ff447819ULL, 0x020fe2000001143dULL,
0x0000003c00707306ULL, 0x000fe20000009400ULL, 0x00000018ff457819ULL, 0x000fe2000001143eULL,
0x000001003c737824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fc4000001143fULL,
0x00000018ff597819ULL, 0x002fe40000011432ULL, 0x00000018ff2f7819ULL, 0x004fe2000001143cULL,
0x0000004400957306ULL, 0x000fe20000209400ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff5a7819ULL, 0x000fe40000011433ULL, 0x00000018ff587819ULL, 0x000fe40000011431ULL,
0x00000018ff5b7819ULL, 0x008fe2000001144fULL, 0x0000004400eb7306ULL, 0x000ff00000205400ULL,
0x00000044008d7306ULL, 0x000ff0000020d400ULL, 0x0000004500977306ULL, 0x000ff00000209400ULL,
0x0000004500df7306ULL, 0x000ff00000205400ULL, 0x0000004500a57306ULL, 0x000ff0000020d400ULL,
0x0000004600987306ULL, 0x000ff00000209400ULL, 0x0000004600de7306ULL, 0x000ff00000205400ULL,
0x0000004600a07306ULL, 0x0003f0000020d400ULL, 0x0000005900c57306ULL, 0x000fe20000209400ULL,
0x000000002b44783bULL, 0x002e6e0000004200ULL, 0x0000005900c67306ULL, 0x000ff00000205400ULL,
0x00000059007b7306ULL, 0x0005f0000020d400ULL, 0x0000003c009f7306ULL, 0x000ee20000005400ULL,
0x00000018ff597819ULL, 0x004fce000001144eULL, 0x0000002f00717306ULL, 0x000ff00000209400ULL,
0x0000002f00ae7306ULL, 0x000ea20000205400ULL, 0x00000018ff747819ULL, 0x002fe40000011445ULL,
0x0000009f7000720bULL, 0x008fc40003fbd000ULL, 0x00000018ff797819ULL, 0x000fe40000011447ULL,
0x00000018ff787819ULL, 0x000fe20000011446ULL, 0x0000005900937306ULL, 0x000ff00000209400ULL,
0x0000005900947306ULL, 0x000fe20000205400ULL, 0x000000ae7100720bULL, 0x004fce0003f7d000ULL,
0x0000005900687306ULL, 0x000ff0000020d400ULL, 0x00000074006a7306ULL, 0x000ff00000209400ULL,
0x00000074006b7306ULL, 0x000ff00000205400ULL, 0x0000007400597306ULL, 0x0003f0000020d400ULL,
0x0000003d00ee7306ULL, 0x000fe20000009400ULL, 0x000001003d747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000003d00af7306ULL, 0x000ff00000005400ULL,
0x0000003d008f7306ULL, 0x0003f0000000d400ULL, 0x0000003c008e7306ULL, 0x0004e2000000d400ULL,
0x000100003d3d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000007300777306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000073009e7306ULL, 0x000e620000205400ULL,
0x000000018e8e5812ULL, 0x008fce00078efcffULL, 0x0000002f008c7306ULL, 0x0004f0000020d400ULL,
0x0000003e00ea7306ULL, 0x000fe20000009400ULL, 0x0000009e7700720bULL, 0x002fe40003f5d000ULL,
0x00000018ff2f7819ULL, 0x004fca0000011430ULL, 0x0000003e00967306ULL, 0x000e620000005400ULL,
0x000000018c8c3812ULL, 0x008fce00078efcffULL, 0x0000007400f17306ULL, 0x000ff00000209400ULL,
0x0000007400f27306ULL, 0x000ea20000205400ULL, 0x00000096ea00720bULL, 0x002fce0003f7d000ULL,
0x0000003d00ef7306ULL, 0x000ff00000209400ULL, 0x0000003d00f07306ULL, 0x000e620000205400ULL,
0x000000f2f100720bULL, 0x004fce0003f9d000ULL, 0x0000003c00b47306ULL, 0x000ff00000209400ULL,
0x0000003c00b57306ULL, 0x000ea20000205400ULL, 0x000000f0ef00720bULL, 0x002fce0003fbd000ULL,
0x0000003c00b67306ULL, 0x0002f0000020d400ULL, 0x0000003f00897306ULL, 0x000fe20000009400ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x000000b5b400720bULL, 0x004fc80003fdd000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003f008a7306ULL, 0x000fee0000005400ULL,
0x00000001b6b66812ULL, 0x008fe200078efcffULL, 0x0000003f00a67306ULL, 0x0003e2000000d400ULL,
0x000000eb9500720bULL, 0x000fc40003fdd000ULL, 0x000000b68c8c723eULL, 0x000fca00000010ffULL,
0x0000007300bc7306ULL, 0x0004e2000020d400ULL, 0x000100003f3f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003e00ab7306ULL, 0x000362000000d400ULL,
0x000001003e737824ULL, 0x004fe200078e00ffULL, 0x000000018d8d6812ULL, 0x000fc800078efcffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000007400bb7306ULL, 0x000ea2000020d400ULL,
0x00000001bcbc2812ULL, 0x008fe200078efcffULL, 0x000100003e3e7824ULL, 0x002fe200078e00ffULL,
0x000000afee00720bULL, 0x000fe40003f5d000ULL, 0x0000008ebc8e723eULL, 0x000fe400000010ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003d00b17306ULL, 0x0002e2000020d400ULL,
0x00000001abab3812ULL, 0x020fce00078efcffULL, 0x0000007300ec7306ULL, 0x000fe20000209400ULL,
0x00000001bbbb4812ULL, 0x004fe200078efcffULL, 0x00000100303d7824ULL, 0x002fe200078e00ffULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x0000008a8900720bULL, 0x000fe40003f5d000ULL,
0x0000008fbb8f723eULL, 0x000fe200000010ffULL, 0x0000007300ed7306ULL, 0x000e620000205400ULL,
0x00000001b1b15812ULL, 0x008fc800078efcffULL, 0x000000b18d8d723eULL, 0x000fc600000010ffULL,
0x0000003c00e67306ULL, 0x000fe40000209400ULL, 0x00000001a6a62812ULL, 0x000fcc00078efcffULL,
0x0000003c00e77306ULL, 0x000ea20000205400ULL, 0x000000edec00720bULL, 0x002fce0003f9d000ULL,
0x0000003f00e27306ULL, 0x000ff00000209400ULL, 0x0000003f00e37306ULL, 0x000e620000205400ULL,
0x000000e7e600720bULL, 0x004fce0003fbd000ULL, 0x0000002f008b7306ULL, 0x000ff00000209400ULL,
0x0000002f00907306ULL, 0x000fe20000205400ULL, 0x000000e3e200720bULL, 0x002fce0003f7d000ULL,
0x0000002f00927306ULL, 0x0003f0000020d400ULL, 0x0000007300b07306ULL, 0x0004e2000020d400ULL,
0x00000018ff2f7819ULL, 0x002fce000001144cULL, 0x0000002f00b87306ULL, 0x000fe20000209400ULL,
0x00000018ff737819ULL, 0x004fce000001143dULL, 0x0000002f00b77306ULL, 0x000fe20000205400ULL,
0x00000001b0b04812ULL, 0x008fe400078efcffULL, 0x000000df9700720bULL, 0x000fca0003f9d000ULL,
0x0000002f006f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00a77306ULL, 0x0004e2000020d400ULL,
0x00000018ff2f7819ULL, 0x002fe40000011444ULL, 0x00000001a5a54812ULL, 0x000fca00078efcffULL,
0x0000003f00a27306ULL, 0x000e62000020d400ULL, 0x00000100313c7824ULL, 0x004fce00078e00ffULL,
0x0000003100dc7306ULL, 0x000fe20000009400ULL, 0x00000001a7a75812ULL, 0x008fe400078efcffULL,
0x000000de9800720bULL, 0x000fca0003fbd000ULL, 0x0000003100db7306ULL, 0x000ea20000005400ULL,
0x00000001a2a23812ULL, 0x002fce00078efcffULL, 0x0000005800d97306ULL, 0x000fe20000209400ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x000000908b00720bULL, 0x000fca0003fbd000ULL,
0x0000005800da7306ULL, 0x000fe20000205400ULL, 0x000000dbdc00720bULL, 0x004fce0003f7d000ULL,
0x0000005800847306ULL, 0x0003e2000020d400ULL, 0x0000000192925812ULL, 0x000fce00078efcffULL,
0x0000005a00867306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x002fce000001144dULL,
0x0000005a00c37306ULL, 0x000ff00000205400ULL, 0x0000005a00767306ULL, 0x000ff0000020d400ULL,
0x0000005b00827306ULL, 0x000ff00000209400ULL, 0x0000005b00837306ULL, 0x000ff00000205400ULL,
0x0000005b00647306ULL, 0x000ff0000020d400ULL, 0x0000002f006d7306ULL, 0x000ff00000209400ULL,
0x0000002f006e7306ULL, 0x000ff00000205400ULL, 0x0000002f005a7306ULL, 0x000ff0000020d400ULL,
0x00000079005b7306ULL, 0x000ff00000209400ULL, 0x0000007900657306ULL, 0x000ff00000205400ULL,
0x00000079002f7306ULL, 0x0003f0000020d400ULL, 0x0000005800ac7306ULL, 0x000fe20000209400ULL,
0x0000010032797824ULL, 0x002fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000005800ad7306ULL, 0x000ff00000205400ULL, 0x0000005800697306ULL, 0x000ff0000020d400ULL,
0x0000007800677306ULL, 0x000ff00000209400ULL, 0x0000007800667306ULL, 0x000ff00000205400ULL,
0x0000007800587306ULL, 0x0003f0000020d400ULL, 0x0000007300e47306ULL, 0x000fe20000209400ULL,
0x00000018ff787819ULL, 0x002fce000001143cULL, 0x0000007300e57306ULL, 0x000e700000205400ULL,
0x0000003200c77306ULL, 0x000ff00000009400ULL, 0x0000003200c87306ULL, 0x000fe20000005400ULL,
0x000000e5e400720bULL, 0x002fce0003f5d000ULL, 0x0000003200817306ULL, 0x0003f0000000d400ULL,
0x00000031009a7306ULL, 0x0004e2000000d400ULL, 0x0001000032327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003e00e87306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x004fce00078e00ffULL, 0x0000003e00e97306ULL, 0x000e620000205400ULL,
0x000000019a9a3812ULL, 0x008fce00078efcffULL, 0x00000078003c7306ULL, 0x000ff00000209400ULL,
0x00000078003d7306ULL, 0x000ea20000205400ULL, 0x000000e9e800720bULL, 0x002fce0003fdd000ULL,
0x0000007900e07306ULL, 0x000ff00000209400ULL, 0x0000007900e17306ULL, 0x000e620000205400ULL,
0x0000003d3c00720bULL, 0x004fe40003f9d000ULL, 0x0000a8002d3c7811ULL, 0x000fca00078e20ffULL,
0x0000003000dd7306ULL, 0x000ff00000009400ULL, 0x0000003000727306ULL, 0x000fe20000005400ULL,
0x000000e1e000720bULL, 0x002fce0003f7d000ULL, 0x00000030009d7306ULL, 0x0003f0000000d400ULL,
0x00000078009c7306ULL, 0x0004e2000020d400ULL, 0x0001000030307824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011430ULL, 0x0000003300857306ULL, 0x000fe20000009400ULL,
0x0000010033787824ULL, 0x004fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000003300c47306ULL, 0x000fe20000005400ULL, 0x000000019c9c4812ULL, 0x008fce00078efcffULL,
0x00000033007c7306ULL, 0x0003f0000000d400ULL, 0x0000007300a17306ULL, 0x0004e2000020d400ULL,
0x0001000033337824ULL, 0x002fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003200cf7306ULL, 0x000fe20000209400ULL, 0x00000018ff737819ULL, 0x004fce0000011431ULL,
0x0000003200d07306ULL, 0x000fe20000205400ULL, 0x00000001a1a12812ULL, 0x008fce00078efcffULL,
0x0000003200887306ULL, 0x0003f0000020d400ULL, 0x0000003e00a87306ULL, 0x000ea2000020d400ULL,
0x000001004e327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000007400307306ULL, 0x000ff00000209400ULL, 0x00000074003e7306ULL, 0x000e620000205400ULL,
0x00000001a8a86812ULL, 0x004fc400078efcffULL, 0x00000072dd00720bULL, 0x000fca0003fdd000ULL,
0x0000007300317306ULL, 0x000ff00000209400ULL, 0x00000073003f7306ULL, 0x000ea20000205400ULL,
0x0000003e3000720bULL, 0x002fe40003f5d000ULL, 0x0000a8002c307811ULL, 0x000fc400078e20ffULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x000000dad900720bULL, 0x000fe20003fdd000ULL,
0x0000007300997306ULL, 0x0002f0000020d400ULL, 0x0000007900917306ULL, 0x000f62000020d400ULL,
0x000001004c737824ULL, 0x002fe200078e00ffULL, 0x0000003f3100720bULL, 0x004fc40003f9d000ULL,
0x0000000184846812ULL, 0x000fe200078efcffULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000003300d77306ULL, 0x000fe20000209400ULL,
0x000000c6c500720bULL, 0x000fe20003fdd000ULL, 0x0000010047c57824ULL, 0x000fca00078e00ffULL,
0x0000000199994812ULL, 0x008fe200078efcffULL, 0x0000003300d87306ULL, 0x000fe20000205400ULL,
0x0000000191913812ULL, 0x020fe400078efcffULL, 0x000000d0cf00720bULL, 0x000fe40003f7d000ULL,
0x000000c48500720bULL, 0x000fe20003f9d000ULL, 0x0000010046c47824ULL, 0x000fe200078e00ffULL,
0x000000017b7b6812ULL, 0x000fe200078efcffULL, 0x00000033007f7306ULL, 0x0005e2000020d400ULL,
0x00000018ffc57819ULL, 0x000fc400000114c5ULL, 0x00000018ffc47819ULL, 0x000fca00000114c4ULL,
0x0000007800d57306ULL, 0x000fe20000209400ULL, 0x000001004f337824ULL, 0x004fe200078e00ffULL,
0x0000000188883812ULL, 0x000fe400078efcffULL, 0x000000017c7c4812ULL, 0x000fe400078efcffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000007800d67306ULL, 0x000ea20000205400ULL,
0x000000b93c3c9231ULL, 0x082fe400003400ffULL, 0x000000b93e3e9231ULL, 0x000fca00003400ffULL,
0x0000003200b27306ULL, 0x000fe20000209400ULL, 0x000000ba3d3d9231ULL, 0x090fe400003400ffULL,
0x000000ba3f3f9231ULL, 0x000fca00003400ffULL, 0x0000003200b37306ULL, 0x000fe20000205400ULL,
0x000000d6d500720bULL, 0x004fce0003fbd000ULL, 0x0000003200797306ULL, 0x0003f0000020d400ULL,
0x0000007300cb7306ULL, 0x000fe20000209400ULL, 0x000100004e327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000007300cc7306ULL, 0x000ff00000205400ULL,
0x0000007300807306ULL, 0x000ff0000020d400ULL, 0x0000003300a97306ULL, 0x000ff00000209400ULL,
0x0000003300aa7306ULL, 0x000ff00000205400ULL, 0x0000003300737306ULL, 0x0003f0000020d400ULL,
0x00000074009b7306ULL, 0x0004e2000020d400ULL, 0x000100004f337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000007800877306ULL, 0x000e62000020d400ULL,
0x000001004d747824ULL, 0x004fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000004d00c07306ULL, 0x000fe20000009400ULL, 0x000000019b9b2812ULL, 0x008fe400078efcffULL,
0x000000c8c700720bULL, 0x000fca0003f5d000ULL, 0x0000004d00bf7306ULL, 0x000ea20000005400ULL,
0x0000000187875812ULL, 0x002fe400078efcffULL, 0x000000d8d700720bULL, 0x000fca0003fbd000ULL,
0x0000003200a37306ULL, 0x000fe20000209400ULL, 0x0000000181812812ULL, 0x000fe400078efcffULL,
0x000000c38600720bULL, 0x000fe20003f5d000ULL, 0x0001000045c37824ULL, 0x000fc800078e00ffULL,
0x0000003200a47306ULL, 0x000e620000205400ULL, 0x000000bfc000720bULL, 0x004fe40003f7d000ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x000000cccb00720bULL, 0x000fe40003fbd000ULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000003200777306ULL, 0x0004e2000020d400ULL,
0x0000000176762812ULL, 0x000fce00078efcffULL, 0x00000033009e7306ULL, 0x000fe20000209400ULL,
0x0000010044327824ULL, 0x004fe200078e00ffULL, 0x0000000180805812ULL, 0x000fe400078efcffULL,
0x000000b7b800720bULL, 0x000fe40003fbd000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000033009f7306ULL, 0x000ff00000205400ULL, 0x0000003300707306ULL, 0x0005e2000020d400ULL,
0x000000016f6f5812ULL, 0x000fc400078efcffULL, 0x000000b3b200720bULL, 0x000fca0003fbd000ULL,
0x0000003200977306ULL, 0x000fe20000209400ULL, 0x0000010045337824ULL, 0x004fca00078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe40000011433ULL, 0x0000003200987306ULL, 0x000fe20000205400ULL,
0x0000000179795812ULL, 0x000fe400078efcffULL, 0x000000a4a300720bULL, 0x002fca0003fbd000ULL,
0x0000003200727306ULL, 0x0003f0000020d400ULL, 0x0000004d006c7306ULL, 0x000522000000d400ULL,
0x000000003030783bULL, 0x002e620000000200ULL, 0x0000000177775812ULL, 0x008fcc00078efcffULL,
0x0000004c00be7306ULL, 0x000fe20000009400ULL, 0x000100004d4d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004c00bd7306ULL, 0x000ea20000005400ULL,
0x000000016c6c3812ULL, 0x010fe400078efcffULL, 0x000000adac00720bULL, 0x000fca0003f7d000ULL,
0x0000004c00757306ULL, 0x000730000000d400ULL, 0x0000007400cd7306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x008fe200078e00ffULL, 0x000000bdbe00720bULL, 0x004fc40003f9d000ULL,
0x0000000169693812ULL, 0x000fe400078efcffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000007400ce7306ULL, 0x000ea20000205400ULL, 0x000000aaa900720bULL, 0x000fe20003f7d000ULL,
0x000000b930309231ULL, 0x082fe400003400ffULL, 0x000000b932329231ULL, 0x000fe400003400ffULL,
0x000000ba31319231ULL, 0x080fe200003400ffULL, 0x0000000175754812ULL, 0x010fe200078efcffULL,
0x0000004c00c97306ULL, 0x000fe20000209400ULL, 0x000000ba33339231ULL, 0x000fca00003400ffULL,
0x0000000173733812ULL, 0x000fe400078efcffULL, 0x0000004c00ca7306ULL, 0x000e620000205400ULL,
0x000000cecd00720bULL, 0x004fe20003f5d000ULL, 0x0000008c3060723cULL, 0x040fe20000041860ULL,
0x000000838200720bULL, 0x000fe40003f7d000ULL, 0x000000819182723eULL, 0x000fe400000010ffULL,
0x0000007c8783723eULL, 0x000fe200000010ffULL, 0x0000004e00d17306ULL, 0x000fe20000009400ULL,
0x000000a8a58c723eULL, 0x000fe200000010ffULL, 0x0000008e305c723cULL, 0x000fe2000004185cULL,
0x000000a2a08d723eULL, 0x000fc400000010ffULL, 0x00000075807c723eULL, 0x000fc600000010ffULL,
0x0000004e00d27306ULL, 0x000ea20000005400ULL, 0x000000cac900720bULL, 0x002fe20003f9d000ULL,
0x0000008c3054723cULL, 0x040fe20000041854ULL, 0x000000abb08e723eULL, 0x000fe400000010ffULL,
0x000000a6a78f723eULL, 0x000fe400000010ffULL, 0x0000000164643812ULL, 0x000fe200078efcffULL,
0x00000074007d7306ULL, 0x000e62000020d400ULL, 0x0000009b928c723eULL, 0x000fe200000010ffULL,
0x000000823040723cULL, 0x000fe20000041840ULL, 0x00000099848d723eULL, 0x000fca00000010ffULL,
0x0000004d00c17306ULL, 0x000fe20000209400ULL, 0x000000d2d100720bULL, 0x004fe20003fdd000ULL,
0x0000008e3034723cULL, 0x040fec0000041834ULL, 0x0000004d00c27306ULL, 0x000ea20000205400ULL,
0x000000017d7d2812ULL, 0x002fe200078efcffULL, 0x0000008c3048723cULL, 0x000fe20000041848ULL,
0x0000009da18e723eULL, 0x000fc400000010ffULL, 0x0000009a9c8f723eULL, 0x000fe400000010ffULL,
0x0000006c7d7d723eULL, 0x000fe200000010ffULL, 0x0000004c007e7306ULL, 0x000e62000020d400ULL,
0x000000887b8c723eULL, 0x000fe400000010ffULL, 0x0000007f768d723eULL, 0x000fe200000010ffULL,
0x0000008e3050723cULL, 0x000fe80000041850ULL, 0x0000004e007a7306ULL, 0x000ee2000000d400ULL,
0x000000c2c100720bULL, 0x004fc60003f5d000ULL, 0x0000008c3038723cULL, 0x000fe80000041838ULL,
0x0000004400b47306ULL, 0x000fe20000009400ULL, 0x000000017e7e4812ULL, 0x002fc600078efcffULL,
0x0000007c3c5c723cULL, 0x000fe2000004185cULL, 0x0000007e6f7e723eULL, 0x000fc600000010ffULL,
0x0000004400b57306ULL, 0x000e620000005400ULL, 0x000000017a7a6812ULL, 0x008fe400078efcffULL,
0x000000949300720bULL, 0x000fe40003fdd000ULL, 0x0000007a797a723eULL, 0x000fc600000010ffULL,
0x0000004400717306ULL, 0x0004f0000000d400ULL, 0x0000004d00787306ULL, 0x000f22000020d400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x000000b5b400720bULL, 0x002fc40003f9d000ULL,
0x0000000168686812ULL, 0x000fe400078efcffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004500ae7306ULL, 0x000fe20000009400ULL, 0x000000989700720bULL, 0x000fe40003fdd000ULL,
0x000000776868723eULL, 0x000fc800000010ffULL, 0x0000000171714812ULL, 0x008fe200078efcffULL,
0x0000004500af7306ULL, 0x000e620000005400ULL, 0x0000000178782812ULL, 0x010fc800078efcffULL,
0x00000078697f723eULL, 0x000fe400000010ffULL, 0x0000000172726812ULL, 0x000fe200078efcffULL,
0x0000004f00d37306ULL, 0x000fe20000009400ULL, 0x0000006e6d00720bULL, 0x000fe40003fdd000ULL,
0x000000717272723eULL, 0x000fe200000010ffULL, 0x0000007e3c60723cULL, 0x000fe80000041860ULL,
0x0000004f00d47306ULL, 0x000ea20000005400ULL, 0x000000afae00720bULL, 0x002fca0003f5d000ULL,
0x000000015a5a6812ULL, 0x000fe400078efcffULL, 0x000000db008b7306ULL, 0x000fe20000209400ULL,
0x000000666700720bULL, 0x000fce0003fdd000ULL, 0x000000db00907306ULL, 0x000e620000205400ULL,
0x000000d4d300720bULL, 0x004fca0003f3d000ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000004400857306ULL, 0x000ff00000209400ULL, 0x0000004400867306ULL, 0x000ea20000205400ULL,
0x000000908b00720bULL, 0x002fce0003f7d000ULL, 0x00000045004e7306ULL, 0x000e70000000d400ULL,
0x0000004f00747306ULL, 0x000ee2000000d400ULL, 0x000000868500720bULL, 0x004fce0003f9d000ULL,
0x000000db004f7306ULL, 0x000ea2000020d400ULL, 0x000000014e4e2812ULL, 0x002fe400078efcffULL,
0x0000006b6a00720bULL, 0x000fca0003f5d000ULL, 0x0000004400457306ULL, 0x000e62000020d400ULL,
0x0000000174741812ULL, 0x008fe400078efcffULL, 0x0000009f9e00720bULL, 0x000fe40003f3d000ULL,
0x00000074737b723eULL, 0x000fc600000010ffULL, 0x0000004600957306ULL, 0x000fe20000009400ULL,
0x000000014f4f3812ULL, 0x004fe400078efcffULL, 0x0000000159592812ULL, 0x000fe200078efcffULL,
0x0000007a3c34723cULL, 0x000fe20000041834ULL, 0x0000004e4f73723eULL, 0x000fc600000010ffULL,
0x0000004600967306ULL, 0x000ea20000005400ULL, 0x0000000145454812ULL, 0x002fe400078efcffULL,
0x0000000170701812ULL, 0x000fe200078efcffULL, 0x000000723c50723cULL, 0x040fe20000041850ULL,
0x000000455a5a723eULL, 0x000fe400000010ffULL, 0x000000706469723eULL, 0x000fe200000010ffULL,
0x000000c300bd7306ULL, 0x000fec0000209400ULL, 0x000000683c54723cULL, 0x000fe40000041854ULL,
0x000000c300be7306ULL, 0x000e620000205400ULL, 0x000000969500720bULL, 0x004fce0003fbd000ULL,
0x000000c400b17306ULL, 0x000ff00000209400ULL, 0x000000c400a67306ULL, 0x000ea20000205400ULL,
0x000000bebd00720bULL, 0x002fce0003f7d000ULL, 0x00000046004d7306ULL, 0x0002f0000000d400ULL,
0x0000004700897306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fe200078e00ffULL,
0x000000a6b100720bULL, 0x004fc80003f9d000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000047008a7306ULL, 0x000e620000005400ULL, 0x000000014d4d5812ULL, 0x008fce00078efcffULL,
0x00000047004c7306ULL, 0x0004f0000000d400ULL, 0x000000c300447306ULL, 0x000f22000020d400ULL,
0x0001000047477824ULL, 0x004fe200078e00ffULL, 0x0000008a8900720bULL, 0x002fc80003f3d000ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x000000c400a07306ULL, 0x000e6e000020d400ULL,
0x000000014c4c1812ULL, 0x008fe200078efcffULL, 0x000000c5009a7306ULL, 0x000fe20000209400ULL,
0x0000000144443812ULL, 0x010fc400078efcffULL, 0x000000655b00720bULL, 0x000fe40003f7d000ULL,
0x00000044595b723eULL, 0x000fc600000010ffULL, 0x000000c5008f7306ULL, 0x000ea20000205400ULL,
0x00000001a0a04812ULL, 0x002fc600078efcffULL, 0x0000005a3c48723cULL, 0x000fe20000041848ULL,
0x0000004da0a0723eULL, 0x000fc600000010ffULL, 0x0000004600767306ULL, 0x000fe20000209400ULL,
0x000000012f2f3812ULL, 0x000fce00078efcffULL, 0x0000004600317306ULL, 0x000e620000205400ULL,
0x0000008f9a00720bULL, 0x004fce0003f5d000ULL, 0x0000004700307306ULL, 0x000ff00000209400ULL,
0x00000047006b7306ULL, 0x000ea20000205400ULL, 0x000000317600720bULL, 0x002fce0003f9d000ULL,
0x000000c500a17306ULL, 0x000e70000020d400ULL, 0x0000004600337306ULL, 0x000ee2000020d400ULL,
0x0000006b3000720bULL, 0x004fce0003fbd000ULL, 0x0000004700327306ULL, 0x000ea2000020d400ULL,
0x00000001a1a12812ULL, 0x002fc800078efcffULL, 0x0000004ca1a1723eULL, 0x000fe400000010ffULL,
0x0000000133334812ULL, 0x008fc800078efcffULL, 0x000000335858723eULL, 0x000fe200000010ffULL,
0x000000a03c40723cULL, 0x000fe20000041840ULL, 0x0000000132325812ULL, 0x004fc800078efcffULL,
0x000000322f59723eULL, 0x000fce00000010ffULL, 0x000000583c3c723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008004307811ULL, 0x002fe200078e40ffULL, 0x01069000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000300300720cULL, 0x000fda0003f24070ULL, 0x00009ec000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL,
0x0000002f00307305ULL, 0x0002a4000021f000ULL, 0x3fa000002f2f7823ULL, 0x002fe200000100ffULL,
0x000000300000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff307424ULL, 0x000fe200078e00ffULL, 0x0000000307317812ULL, 0x000fe200078ec0ffULL,
0x00000300ff2f7624ULL, 0x000fc600078e00ffULL, 0x000000033100780cULL, 0x000fe20003f25270ULL,
0xfffffffd302f7424ULL, 0x000fca00078e022fULL, 0x000000012f327807ULL, 0x000fe20004800000ULL,
0x00005800092f7a24ULL, 0x000fe400078e02ffULL, 0xffffffffff097424ULL, 0x000fe400078e00ffULL,
0x0000000107077824ULL, 0x000fca00078e0232ULL, 0x000000050700720cULL, 0x000fe20003f26070ULL,
0x000000402f337824ULL, 0x000fe200078e00ffULL, 0x000000a004327811ULL, 0x000fd600078e40ffULL,
0x0000000107319824ULL, 0x000fc800078e020cULL, 0x0000600031309625ULL, 0x000fe200078e0030ULL,
0x00000032032f7217ULL, 0x000fc80007800000ULL, 0x0000000630099981ULL, 0x000362000c1e1900ULL,
0x0000000d33387210ULL, 0x000fe20007f3e0ffULL, 0x000000012f2f7824ULL, 0x000fc800078e0a32ULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e0038447a11ULL, 0x040fe400078240ffULL,
0x000000202f2f7807ULL, 0x000fe40000000000ULL, 0x0000001133307210ULL, 0x042fe40007f5e0ffULL,
0x00005f0038397a11ULL, 0x000fe400008f4439ULL, 0x0000001033327210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff457224ULL, 0x000fe200010e06ffULL, 0x0000002f082f7217ULL, 0x000fc40007800000ULL,
0x00005e0030467a11ULL, 0x000fe200078440ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e06ffULL,
0x00005e0032387a11ULL, 0x000fe200078240ffULL, 0x000000012f3a7824ULL, 0x000fe200078e0a08ULL,
0x00005f0030457a11ULL, 0x000fe400010f4445ULL, 0x00000004ff317819ULL, 0x000fe40000011602ULL,
0x00000012332f7210ULL, 0x000fe40007f7e0ffULL, 0x0000001344307210ULL, 0x000fc40007f9e0ffULL,
0x00005f00323b7a11ULL, 0x000fe200008f443bULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x0000001338327210ULL, 0x000fe40007fbe0ffULL, 0x0000003a3100720cULL, 0x080fe20003f26070ULL,
0x000000ffff317224ULL, 0x000fe200020e0639ULL, 0x00005e002f447a11ULL, 0x000fe200078440ffULL,
0x000000ffff337224ULL, 0x000fe200028e063bULL, 0x0000003af500720cULL, 0x080fe40003f86070ULL,
0x0000003a0e00720cULL, 0x000fc40003fc6070ULL, 0x0000003a0f00720cULL, 0x000fe40003fa6070ULL,
0x0000001346387210ULL, 0x080fe40007f7e0ffULL, 0x00005f002f4c7a11ULL, 0x000fe200010f444cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030147faeULL, 0x0003e2000c901c46ULL,
0x00000013443a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff397224ULL, 0x000fe400018e0645ULL,
0x0000000032157faeULL, 0x0003e4000e101c46ULL, 0x000000ffff3b7224ULL, 0x000fc400010e064cULL,
0x0000000038167faeULL, 0x0003e8000f101c46ULL, 0x000000003a177faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff747f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff2f7984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106480008307f8cULL, 0x002fe2000c80043fULL, 0x800000002fff7812ULL, 0x008fc6000784482eULL,
0x01064c0008337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL,
0x0000002f00327305ULL, 0x0002e4000021f000ULL, 0x3fa000002f2f7823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x008fe20003800000ULL, 0x01064c0008337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101000018397984ULL, 0x000e680000000800ULL, 0x0103000018387984ULL, 0x0007220000000800ULL,
0x0000000a3900720bULL, 0x002fe20003f3d000ULL, 0x000132b27f007947ULL, 0x000fd8000b800000ULL,
0x00000000002f7806ULL, 0x008fc800008e0100ULL, 0x0000ffff2f327812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ffc07424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f65270ULL,
0x0000000a3900720bULL, 0x000fe20003f34000ULL, 0x000132827f007947ULL, 0x000fd8000b800000ULL,
0x00000000002f7806ULL, 0x000fe400008e0100ULL, 0x000000390a317209ULL, 0x040fe40007810000ULL,
0x0000ffff2f2f7812ULL, 0x000fe400078e3cffULL, 0x00000002ff587819ULL, 0x000fe20000011602ULL,
0x800000310a307221ULL, 0x000fe20000010000ULL, 0x010500311800b388ULL, 0x0003e20000000800ULL,
0x0000002f32ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x00000030003a7308ULL, 0x000ee40000000800ULL, 0x0000003a0b0b7220ULL, 0x008fe20000410000ULL,
0x000132227f007947ULL, 0x000fea000b800000ULL, 0x00001f583a2f7589ULL, 0x0022e400000e0000ULL,
0x0000002f5c5c7220ULL, 0x08cfe40000410000ULL, 0x0000002f5d5d7220ULL, 0x080fe40000410000ULL,
0x0000002f60607220ULL, 0x080fe40000410000ULL, 0x0000002f61617220ULL, 0x080fe40000410000ULL,
0x0000002f34347220ULL, 0x000fc40000410000ULL, 0x0000002f35357220ULL, 0x080fe40000410000ULL,
0x0000002f54547220ULL, 0x080fe40000410000ULL, 0x0000002f55557220ULL, 0x080fe40000410000ULL,
0x0000002f50507220ULL, 0x080fe40000410000ULL, 0x0000002f51517220ULL, 0x080fe40000410000ULL,
0x0000002f48487220ULL, 0x000fc40000410000ULL, 0x0000002f49497220ULL, 0x080fe40000410000ULL,
0x0000002f40407220ULL, 0x080fe40000410000ULL, 0x0000002f41417220ULL, 0x080fe40000410000ULL,
0x0000002f3c3c7220ULL, 0x080fe40000410000ULL, 0x0000002f3d3d7220ULL, 0x000fe20000410000ULL,
0x000131627f007947ULL, 0x000fea000b800000ULL, 0x00001ff63a2f7589ULL, 0x0004e400000e0000ULL,
0x000000390a0a7209ULL, 0x000fe20007810000ULL, 0x0000002f5e5e7220ULL, 0x08cfe20000410000ULL,
0x00000001ffc07807ULL, 0x000fe20000800000ULL, 0x0000002f5f5f7220ULL, 0x000fc40000410000ULL,
0x8000000a39391221ULL, 0x000fe40000010000ULL, 0x0000002f62627220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b39391820ULL, 0x000fe40000410000ULL, 0x0000002f63637220ULL, 0x080fe40000410000ULL,
0x0000003900191308ULL, 0x000ea20000000800ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f37377220ULL, 0x000fc40000410000ULL, 0x0000002f56567220ULL, 0x080fe40000410000ULL,
0x0000002f57577220ULL, 0x080fe40000410000ULL, 0x0000002f52527220ULL, 0x080fe40000410000ULL,
0x0000002f53537220ULL, 0x080fe40000410000ULL, 0x0000002f4a4a7220ULL, 0x080fe40000410000ULL,
0x0000002f4b4b7220ULL, 0x000fc40000410000ULL, 0x0000002f42427220ULL, 0x080fe40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x080fe40000410000ULL,
0x0000002f3f3f7220ULL, 0x000fe40000410000ULL, 0x0000003819381220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000b380b7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff2f7984ULL, 0x000ee40000000800ULL, 0x800000002fff7812ULL, 0x008fc4000782482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL, 0x0000002f00307305ULL, 0x000724000021f000ULL,
0x3fa000002f2f7823ULL, 0x008fe200000100ffULL, 0x000000300000735dULL, 0x010fe20003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fe4000782482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000019ff2e723eULL, 0x000fe400000010ffULL,
0x00000002ff587819ULL, 0x002fc40000011602ULL, 0x000054102e327816ULL, 0x000fe2000000002eULL,
0x00012f127f007947ULL, 0x000fea000b800000ULL, 0x00001f5832737589ULL, 0x0002e400000e0000ULL,
0x00012f527f007947ULL, 0x000fea000b800000ULL, 0x00001ff6326b7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff587224ULL, 0x002fe200078e00fbULL,
0x0000bf6000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000139e000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff587224ULL, 0x002fe200078e00faULL,
0x0000bfc000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0001398000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001a38783bULL, 0x000f280000004200ULL,
0x000000001b44783bULL, 0x000fe80000004200ULL, 0x000000001c58783bULL, 0x002fe80000004200ULL,
0x000000001d4c783bULL, 0x000e620000004200ULL, 0x0000010038717824ULL, 0x010fe200078e00ffULL,
0x0000003900f07306ULL, 0x000fe20000009400ULL, 0x00000018ff2f7819ULL, 0x004fc40000011439ULL,
0x00000018ff2e7819ULL, 0x000fe40000011438ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x00000018ff317819ULL, 0x000fe2000001143bULL, 0x0000003900bf7306ULL, 0x000ea20000005400ULL,
0x00000018ff307819ULL, 0x000fe4000001143aULL, 0x00000018ff727819ULL, 0x002fe4000001144dULL,
0x00000018ff787819ULL, 0x000fc4000001144eULL, 0x00000018ff647819ULL, 0x000fe2000001144cULL,
0x00000071009e7306ULL, 0x000fe20000209400ULL, 0x00000018ff7b7819ULL, 0x000fce000001144fULL,
0x0000007100f47306ULL, 0x000e620000205400ULL, 0x000000bff000720bULL, 0x004fce0003fbd000ULL,
0x0000007100ba7306ULL, 0x000530000020d400ULL, 0x0000002f008c7306ULL, 0x000fe20000209400ULL,
0x000001003a717824ULL, 0x004fe200078e00ffULL, 0x000000f49e00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000002f00ea7306ULL, 0x000fee0000205400ULL,
0x00000001baba2812ULL, 0x010fe200078efcffULL, 0x0000002f00a87306ULL, 0x0003f0000020d400ULL,
0x0000003800f17306ULL, 0x000fe20000009400ULL, 0x00000018ff2f7819ULL, 0x002fce0000011445ULL,
0x0000003800be7306ULL, 0x000e700000005400ULL, 0x0000003800ad7306ULL, 0x000530000000d400ULL,
0x0000002f00c37306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fe200078e00ffULL,
0x000000bef100720bULL, 0x002fc80003f3d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000002f00c47306ULL, 0x000fee0000205400ULL, 0x00000001adad1812ULL, 0x010fe200078efcffULL,
0x0000002f00877306ULL, 0x0003f0000020d400ULL, 0x0000003900ab7306ULL, 0x000ea2000000d400ULL,
0x00000018ff2f7819ULL, 0x002fce0000011459ULL, 0x0000007100e87306ULL, 0x000ff00000209400ULL,
0x0000007100e97306ULL, 0x000e620000205400ULL, 0x00000001abab5812ULL, 0x004fce00078efcffULL,
0x0000002f00b87306ULL, 0x000ff00000209400ULL, 0x0000002f00b07306ULL, 0x000fe20000205400ULL,
0x000000e9e800720bULL, 0x002fce0003fbd000ULL, 0x0000002f00687306ULL, 0x000ff0000020d400ULL,
0x0000003800f27306ULL, 0x000ff00000209400ULL, 0x0000003800f37306ULL, 0x000e700000205400ULL,
0x0000003800ac7306ULL, 0x000530000020d400ULL, 0x0000003b00e77306ULL, 0x000fe20000009400ULL,
0x000001003b387824ULL, 0x004fe200078e00ffULL, 0x000000f3f200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003b008d7306ULL, 0x000fee0000005400ULL,
0x00000001acac6812ULL, 0x010fe200078efcffULL, 0x0000003b00a17306ULL, 0x0003e2000000d400ULL,
0x000000ea8c00720bULL, 0x000fce0003fdd000ULL, 0x0000007200697306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000072006a7306ULL, 0x000fe20000205400ULL, 0x00000001a8a86812ULL, 0x000fce00078efcffULL,
0x00000072002f7306ULL, 0x0003f0000020d400ULL, 0x0000007100a77306ULL, 0x000ea2000020d400ULL,
0x0000010039727824ULL, 0x042fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003b00e57306ULL, 0x000fe20000209400ULL, 0x00000001a7a75812ULL, 0x004fce00078efcffULL,
0x0000007200ee7306ULL, 0x000ff00000209400ULL, 0x0000007200ef7306ULL, 0x000e700000205400ULL,
0x0000003b00e67306ULL, 0x000eb00000205400ULL, 0x0000002e006f7306ULL, 0x000fe20000209400ULL,
0x000000efee00720bULL, 0x002fce0003f9d000ULL, 0x0000002e00977306ULL, 0x000e620000205400ULL,
0x000000e6e500720bULL, 0x004fce0003fbd000ULL, 0x0000002e00a97306ULL, 0x000530000020d400ULL,
0x0000003900ec7306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x004fe40000011444ULL,
0x000000976f00720bULL, 0x002fca0003f7d000ULL, 0x0000003900ed7306ULL, 0x000e700000205400ULL,
0x0000003900aa7306ULL, 0x0004e2000020d400ULL, 0x00000001a9a93812ULL, 0x010fe400078efcffULL,
0x0000008de700720bULL, 0x000fca0003f7d000ULL, 0x00000044009a7306ULL, 0x000fe20000009400ULL,
0x0000010044397824ULL, 0x004fe200078e00ffULL, 0x000000edec00720bULL, 0x002fc80003f3d000ULL,
0x00000018ff717819ULL, 0x000fe40000011439ULL, 0x0000004400c97306ULL, 0x000fe20000005400ULL,
0x00000001a1a13812ULL, 0x000fcc00078efcffULL, 0x00000001aaaa1812ULL, 0x008fe200078efcffULL,
0x00000044008e7306ULL, 0x0003f0000000d400ULL, 0x0000003a00987306ULL, 0x000fe20000009400ULL,
0x0001000044447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000003a00eb7306ULL, 0x000e700000005400ULL, 0x0000003a00a67306ULL, 0x0004f0000000d400ULL,
0x0000007200bb7306ULL, 0x0008e2000020d400ULL, 0x000100003a3a7824ULL, 0x004fe200078e00ffULL,
0x000000eb9800720bULL, 0x002fc80003f5d000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b009c7306ULL, 0x0002a2000020d400ULL, 0x0000010047727824ULL, 0x010fcc00078e00ffULL,
0x00000001a6a62812ULL, 0x008fe200078efcffULL, 0x00000030007a7306ULL, 0x000fe20000209400ULL,
0x00000100463b7824ULL, 0x002fe200078e00ffULL, 0x00000001bbbb4812ULL, 0x000fcc00078efcffULL,
0x0000003000797306ULL, 0x000e620000205400ULL, 0x000000019c9c5812ULL, 0x004fce00078efcffULL,
0x0000004400dc7306ULL, 0x000ff00000209400ULL, 0x0000004400dd7306ULL, 0x000ea20000205400ULL,
0x000000797a00720bULL, 0x002fce0003f9d000ULL, 0x0000003800997306ULL, 0x000ff00000209400ULL,
0x0000003800e27306ULL, 0x000e620000205400ULL, 0x000000dddc00720bULL, 0x004fce0003fbd000ULL,
0x0000003800a57306ULL, 0x0004f0000020d400ULL, 0x0000003a00e37306ULL, 0x000fe20000209400ULL,
0x0000010045387824ULL, 0x004fe200078e00ffULL, 0x000000e29900720bULL, 0x002fe20003f3d000ULL,
0x000001004c997824ULL, 0x000fca00078e00ffULL, 0x0000003a00e47306ULL, 0x000e620000205400ULL,
0x00000018ffe27819ULL, 0x000fcc0000011499ULL, 0x00000001a5a51812ULL, 0x008fe200078efcffULL,
0x0000003a00a47306ULL, 0x0004e2000020d400ULL, 0x000000c99a00720bULL, 0x000fce0003f3d000ULL,
0x0000007100da7306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x004fe40000011438ULL,
0x000000e4e300720bULL, 0x002fc60003fdd000ULL, 0x000000018e8e1812ULL, 0x000fe400078efcffULL,
0x0000007100db7306ULL, 0x000e700000205400ULL, 0x00000071009b7306ULL, 0x0005e2000020d400ULL,
0x00000001a4a46812ULL, 0x008fce00078efcffULL, 0x00000030009f7306ULL, 0x000722000020d400ULL,
0x00000018ff717819ULL, 0x004fe4000001143bULL, 0x000000dbda00720bULL, 0x002fca0003f7d000ULL,
0x0000003a00387306ULL, 0x000fe20000209400ULL, 0x00000018ff307819ULL, 0x008fce0000011446ULL,
0x0000003a00397306ULL, 0x000e620000205400ULL, 0x000000019f9f4812ULL, 0x010fe400078efcffULL,
0x000000019b9b3812ULL, 0x000fc800078efcffULL, 0x0000008e9b8e723eULL, 0x000fe200000010ffULL,
0x0000003a00947306ULL, 0x000eb0000020d400ULL, 0x0000004400967306ULL, 0x000ee2000020d400ULL,
0x000000393800720bULL, 0x002fe20003f9d000ULL, 0x000001004d387824ULL, 0x000fcc00078e00ffULL,
0x00000071003a7306ULL, 0x000fec0000209400ULL, 0x0000000194944812ULL, 0x004fe400078efcffULL,
0x00000071003b7306ULL, 0x000e620000205400ULL, 0x0000000196965812ULL, 0x008fce00078efcffULL,
0x0000004500707306ULL, 0x000ff00000009400ULL, 0x0000004500c87306ULL, 0x000ea20000005400ULL,
0x0000003b3a00720bULL, 0x002fce0003fbd000ULL, 0x0000004500897306ULL, 0x0002f0000000d400ULL,
0x0000003100ca7306ULL, 0x000fe20000209400ULL, 0x0001000045457824ULL, 0x002fe200078e00ffULL,
0x000000c87000720bULL, 0x004fc80003fdd000ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000003100cb7306ULL, 0x000e6e0000205400ULL, 0x0000000189896812ULL, 0x008fe200078efcffULL,
0x0000003100937306ULL, 0x0004e2000020d400ULL, 0x000000c4c300720bULL, 0x000fce0003fdd000ULL,
0x0000004700c17306ULL, 0x000fe20000009400ULL, 0x00000018ff317819ULL, 0x004fe40000011447ULL,
0x000000cbca00720bULL, 0x002fc60003f5d000ULL, 0x0000000187876812ULL, 0x000fe400078efcffULL,
0x0000004700c27306ULL, 0x000e700000005400ULL, 0x0000004700817306ULL, 0x000522000000d400ULL,
0x0000000193932812ULL, 0x008fc800078efcffULL, 0x0000009c9393723eULL, 0x000fc600000010ffULL,
0x0000003000b77306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x004fe200078e00ffULL,
0x000000c2c100720bULL, 0x002fe40003f9d000ULL, 0x00009910c0c27816ULL, 0x000fe200000000ffULL,
0x000100004cc07824ULL, 0x000fc600078e00ffULL, 0x0000003000af7306ULL, 0x000e640000205400ULL,
0x00000018ffc07819ULL, 0x000fca00000114c0ULL, 0x0000000181814812ULL, 0x010fe200078efcffULL,
0x00000030007e7306ULL, 0x0005f0000020d400ULL, 0x00000071008a7306ULL, 0x000722000020d400ULL,
0x00000018ff307819ULL, 0x004fc4000001145aULL, 0x000000afb700720bULL, 0x002fe20003fdd000ULL,
0x000000ffffaf7224ULL, 0x000fc800078e00c2ULL, 0x0000004600917306ULL, 0x000fe20000009400ULL,
0x00000018ff717819ULL, 0x008fce0000011447ULL, 0x0000004600c57306ULL, 0x000e620000005400ULL,
0x000000018a8a5812ULL, 0x010fe400078efcffULL, 0x000000017e7e6812ULL, 0x000fca00078efcffULL,
0x0000004600827306ULL, 0x0004f0000000d400ULL, 0x0000004500de7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000c59100720bULL, 0x002fcc0003f3d000ULL,
0x0000004500df7306ULL, 0x000e6e0000205400ULL, 0x0000000182821812ULL, 0x008fe200078efcffULL,
0x0000004500957306ULL, 0x000ea2000020d400ULL, 0x000000ffaf00720cULL, 0x000fe40003f25270ULL,
0x000000828a8a723eULL, 0x000fca00000010ffULL, 0x0000003000a07306ULL, 0x000fe20000209400ULL,
0x000000dfde00720bULL, 0x002fce0003f7d000ULL, 0x0000003000927306ULL, 0x000fec0000205400ULL,
0x0000000195953812ULL, 0x004fe400078efcffULL, 0x0000003000677306ULL, 0x000ff0000020d400ULL,
0x0000007100447306ULL, 0x000ff00000209400ULL, 0x0000007100457306ULL, 0x000e700000205400ULL,
0x0000007800337306ULL, 0x000ff00000209400ULL, 0x0000007800657306ULL, 0x000fe20000205400ULL,
0x000000454400720bULL, 0x002fe20003fbd000ULL, 0x000100004d447824ULL, 0x000fe200078e00ffULL,
0x000000aaa845723eULL, 0x000fca00000010ffULL, 0x0000007800307306ULL, 0x0003f0000020d400ULL,
0x0000002e00c67306ULL, 0x000fe20000209400ULL, 0x00000018ff787819ULL, 0x002fe40000011472ULL,
0x00000018ff727819ULL, 0x000fe20000011446ULL, 0x0000010058467824ULL, 0x000fc800078e00ffULL,
0x0000002e00c77306ULL, 0x000e700000205400ULL, 0x0000002e00887306ULL, 0x0004f0000020d400ULL,
0x0000005800b97306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x004fc40000011458ULL,
0x000000c7c600720bULL, 0x002fe40003f5d000ULL, 0x00000018ffc67819ULL, 0x000fe40000011438ULL,
0x0000b0001e387811ULL, 0x000fe200078e20ffULL, 0x0000005800b27306ULL, 0x000fea0000005400ULL,
0x000000003838783bULL, 0x000e660000000200ULL, 0x0000005800767306ULL, 0x0005e2000000d400ULL,
0x0000000188882812ULL, 0x008fc800078efcffULL, 0x000000968888723eULL, 0x000fc600000010ffULL,
0x0000007100857306ULL, 0x000722000020d400ULL, 0x0001000058587824ULL, 0x004fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003100b67306ULL, 0x000fe20000209400ULL,
0x000001005a717824ULL, 0x008fce00078e00ffULL, 0x0000003100b57306ULL, 0x000ea20000205400ULL,
0x0000000185855812ULL, 0x010fce00078efcffULL, 0x0000005800d07306ULL, 0x000fe20000209400ULL,
0x0000007338389231ULL, 0x082fe400003400ffULL, 0x000000733a3a9231ULL, 0x000fca00003400ffULL,
0x0000005800d17306ULL, 0x000e620000205400ULL, 0x000000b5b600720bULL, 0x004fe20003f9d000ULL,
0x000001004fb67824ULL, 0x000fe200078e00ffULL, 0x0000006b39399231ULL, 0x080fe200003400ffULL,
0x000001004eb57824ULL, 0x000fe200078e00ffULL, 0x0000006b3b3b9231ULL, 0x000fe400003400ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x00000031007f7306ULL, 0x0004e2000020d400ULL,
0x00000018ffb57819ULL, 0x000fce00000114b5ULL, 0x0000005800807306ULL, 0x0008e2000020d400ULL,
0x000000d1d000720bULL, 0x002fe40003fbd000ULL, 0x00000018ff317819ULL, 0x004fca000001145bULL,
0x0000005900b17306ULL, 0x000fe20000009400ULL, 0x00000018ff587819ULL, 0x010fe20000011471ULL,
0x000001005b717824ULL, 0x000fe200078e00ffULL, 0x000000017f7f4812ULL, 0x008fc800078efcffULL,
0x000000857f7f723eULL, 0x000fe200000010ffULL, 0x0000005900b47306ULL, 0x000e620000005400ULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x000000b0b800720bULL, 0x000fca0003fbd000ULL,
0x0000007800d87306ULL, 0x000ff00000209400ULL, 0x0000007800d97306ULL, 0x000ea20000205400ULL,
0x000000b4b100720bULL, 0x002fe40003f9d000ULL, 0x0000000168685812ULL, 0x000fca00078efcffULL,
0x00000078008b7306ULL, 0x0002f0000020d400ULL, 0x0000005900777306ULL, 0x000f22000000d400ULL,
0x00000018ff787819ULL, 0x002fe40000011446ULL, 0x000000d9d800720bULL, 0x004fca0003f5d000ULL,
0x0000007800467306ULL, 0x000ff00000209400ULL, 0x0000007800477306ULL, 0x000e620000205400ULL,
0x000000018b8b2812ULL, 0x008fe400078efcffULL, 0x0000000177774812ULL, 0x010fc400078efcffULL,
0x000000b2b900720bULL, 0x000fe40003f5d000ULL, 0x000000818b8b723eULL, 0x000fe200000010ffULL,
0x0000007800837306ULL, 0x0004ec000020d400ULL, 0x0000008a3840723cULL, 0x000fe40000041840ULL,
0x0000007200e07306ULL, 0x000fe20000209400ULL, 0x00000018ff787819ULL, 0x004fc40000011471ULL,
0x000000474600720bULL, 0x002fe40003fdd000ULL, 0x0000000176762812ULL, 0x000fe400078efcffULL,
0x000000adba46723eULL, 0x000fe200000010ffULL, 0x0000007200e17306ULL, 0x000e620000205400ULL,
0x000000abbb47723eULL, 0x000fce00000010ffULL, 0x0000005800cc7306ULL, 0x000fe20000209400ULL,
0x0000000183836812ULL, 0x008fe200078efcffULL, 0x00000046385c723cULL, 0x000fe6000004185cULL,
0x000000768376723eULL, 0x000fc600000010ffULL, 0x0000005800cd7306ULL, 0x000ea20000205400ULL,
0x000000e1e000720bULL, 0x002fce0003f7d000ULL, 0x0000007800bc7306ULL, 0x000ff00000209400ULL,
0x0000007800bd7306ULL, 0x000e620000205400ULL, 0x000000cdcc00720bULL, 0x004fce0003f9d000ULL,
0x0000007200867306ULL, 0x0004f0000020d400ULL, 0x00000058007c7306ULL, 0x0008e2000020d400ULL,
0x0000010059727824ULL, 0x044fe200078e00ffULL, 0x000000bdbc00720bULL, 0x002fe20003fbd000ULL,
0x0001000059597824ULL, 0x000fc600078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000007800717306ULL, 0x000e62000020d400ULL, 0x000100005a587824ULL, 0x010fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000000186863812ULL, 0x008fe400078efcffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000002e00b37306ULL, 0x000fe20000209400ULL,
0x000000017c7c4812ULL, 0x000fc400078efcffULL, 0x00000092a000720bULL, 0x000fe40003f9d000ULL,
0x000000a49f92723eULL, 0x000fe400000010ffULL, 0x000000867e7e723eULL, 0x000fe200000010ffULL,
0x0000002e00ae7306ULL, 0x000ea20000205400ULL, 0x0000000171715812ULL, 0x002fc600078efcffULL,
0x000000923854723cULL, 0x000fe80000041854ULL, 0x0000003100907306ULL, 0x000fe20000209400ULL,
0x0000000167674812ULL, 0x000fce00078efcffULL, 0x00000031008f7306ULL, 0x000e620000205400ULL,
0x000000aeb300720bULL, 0x004fe20003f7d000ULL, 0x000100004fae7824ULL, 0x000fe400078e00ffULL,
0x000100004eb37824ULL, 0x000fc600078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x0000007200d27306ULL, 0x000fe20000209400ULL, 0x00000018ffb37819ULL, 0x000fce00000114b3ULL,
0x0000007200d37306ULL, 0x000ea20000205400ULL, 0x0000008f9000720bULL, 0x002fe40003fbd000ULL,
0x00000089948f723eULL, 0x000fe400000010ffULL, 0x000000958789723eULL, 0x000fc600000010ffULL,
0x0000005a00d67306ULL, 0x000fe40000009400ULL, 0x0000008e3850723cULL, 0x040fec0000041850ULL,
0x0000005a00d77306ULL, 0x000e620000005400ULL, 0x000000d3d200720bULL, 0x004fe20003f5d000ULL,
0x000000883848723cULL, 0x000fec0000041848ULL, 0x0000002e006c7306ULL, 0x000eb0000020d400ULL,
0x0000003100327306ULL, 0x000ee2000020d400ULL, 0x000000d7d600720bULL, 0x002fce0003fdd000ULL,
0x0000007200847306ULL, 0x000e62000020d400ULL, 0x000000016c6c3812ULL, 0x004fc800078efcffULL,
0x000000806c6c723eULL, 0x000fc600000010ffULL, 0x0000005a007d7306ULL, 0x000ea2000000d400ULL,
0x0000000132325812ULL, 0x008fce00078efcffULL, 0x0000005900d47306ULL, 0x000fe20000209400ULL,
0x0000000184842812ULL, 0x002fc800078efcffULL, 0x000000778477723eULL, 0x000fc600000010ffULL,
0x0000005900d57306ULL, 0x000e620000205400ULL, 0x000000017d7d6812ULL, 0x004fc800078efcffULL,
0x0000007d7c7c723eULL, 0x000fc600000010ffULL, 0x0000005b00ce7306ULL, 0x000ff00000009400ULL,
0x0000005b00cf7306ULL, 0x000ea20000005400ULL, 0x000000d5d400720bULL, 0x002fce0003f7d000ULL,
0x0000005800a27306ULL, 0x000ff00000209400ULL, 0x0000005800a37306ULL, 0x000e620000205400ULL,
0x000000cfce00720bULL, 0x004fce0003f5d000ULL, 0x000000e200997306ULL, 0x000ff00000209400ULL,
0x000000e2009a7306ULL, 0x000ea20000205400ULL, 0x000000a3a200720bULL, 0x002fce0003fdd000ULL,
0x000000c600917306ULL, 0x000ff00000209400ULL, 0x000000c600c17306ULL, 0x000e620000205400ULL,
0x0000009a9900720bULL, 0x004fce0003f9d000ULL, 0x00000064006d7306ULL, 0x000ff00000209400ULL,
0x00000064006e7306ULL, 0x000fe20000205400ULL, 0x000000c19100720bULL, 0x002fce0003fbd000ULL,
0x00000064002e7306ULL, 0x000ff0000020d400ULL, 0x0000007b00667306ULL, 0x000ff00000209400ULL,
0x0000007b00647306ULL, 0x000ff00000205400ULL, 0x0000007b00317306ULL, 0x000ff0000020d400ULL,
0x00000059007b7306ULL, 0x0002b0000020d400ULL, 0x0000004f00797306ULL, 0x000fe20000009400ULL,
0x000100005b597824ULL, 0x002fca00078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000004f007a7306ULL, 0x000fe20000005400ULL, 0x000000017b7b3812ULL, 0x004fce00078efcffULL,
0x0000004f005a7306ULL, 0x0003f0000000d400ULL, 0x0000004c00be7306ULL, 0x000fe20000009400ULL,
0x00000018ff4f7819ULL, 0x002fe40000011444ULL, 0x000000aca944723eULL, 0x000fca00000010ffULL,
0x0000004c00bf7306ULL, 0x000e640000005400ULL, 0x000000443860723cULL, 0x000fec0000041860ULL,
0x0000004c006f7306ULL, 0x000ea2000000d400ULL, 0x0000b0001f447811ULL, 0x000fcc00078e20ffULL,
0x000000004444783bULL, 0x000ee20000000200ULL, 0x0000005b00727306ULL, 0x000f22000000d400ULL,
0x000000bfbe00720bULL, 0x002fce0003f7d000ULL, 0x0000005800787306ULL, 0x000e6c000020d400ULL,
0x000000016f6f3812ULL, 0x004fe400078efcffULL, 0x000000e200707306ULL, 0x000ea2000020d400ULL,
0x0000000172722812ULL, 0x010fe400078efcffULL, 0x0000006e6d00720bULL, 0x000fc40003f7d000ULL,
0x00000072717d723eULL, 0x000fe400000010ffULL, 0x0000007b686d723eULL, 0x000fe200000010ffULL,
0x000000c6004c7306ULL, 0x000f22000020d400ULL, 0x0000000178786812ULL, 0x002fc800078efcffULL,
0x000000786778723eULL, 0x000fc600000010ffULL, 0x00000059009d7306ULL, 0x000fe20000209400ULL,
0x0000000170704812ULL, 0x004fe400078efcffULL, 0x000000012e2e3812ULL, 0x000fe400078efcffULL,
0x0000007a7900720bULL, 0x000fe20003f7d000ULL, 0x0000007344449231ULL, 0x088fe400003400ffULL,
0x00000059009e7306ULL, 0x000e620000205400ULL, 0x000000014c4c5812ULL, 0x010fe200078efcffULL,
0x0000007346469231ULL, 0x000fe200003400ffULL, 0x0000006f7070723eULL, 0x000fe200000010ffULL,
0x0000006b45459231ULL, 0x000fc400003400ffULL, 0x0000006b47479231ULL, 0x000fe400003400ffULL,
0x0000004d00977306ULL, 0x000fe40000009400ULL, 0x000000015a5a3812ULL, 0x000fc600078efcffULL,
0x00000076445c723cULL, 0x000fe6000004185cULL, 0x0000004d00987306ULL, 0x000ea20000005400ULL,
0x0000009e9d00720bULL, 0x002fc80003f5d000ULL, 0x0000006c4460723cULL, 0x000fe60000041860ULL,
0x000000c000af7306ULL, 0x000ff00000209400ULL, 0x000000c000b27306ULL, 0x000e620000205400ULL,
0x000000989700720bULL, 0x004fce0003fdd000ULL, 0x0000004f00b17306ULL, 0x000ff00000209400ULL,
0x0000004f00b07306ULL, 0x000ea20000205400ULL, 0x000000b2af00720bULL, 0x002fce0003f9d000ULL,
0x0000004d00587306ULL, 0x000e70000000d400ULL, 0x00000059005b7306ULL, 0x000ee2000020d400ULL,
0x000000b0b100720bULL, 0x004fce0003fbd000ULL, 0x000000c0004d7306ULL, 0x000ea2000020d400ULL,
0x0000000158586812ULL, 0x002fe400078efcffULL, 0x0000006a6900720bULL, 0x000fe40003fdd000ULL,
0x000000584c71723eULL, 0x000fc600000010ffULL, 0x0000004f00ac7306ULL, 0x000322000020d400ULL,
0x000000015b5b2812ULL, 0x008fc600078efcffULL, 0x000000704450723cULL, 0x000fe20000041850ULL,
0x0000005b3279723eULL, 0x000fc600000010ffULL, 0x0000004e008c7306ULL, 0x000fe20000009400ULL,
0x000000a1a54f723eULL, 0x002fe400000010ffULL, 0x000000014d4d4812ULL, 0x004fe200078efcffULL,
0x000000784454723cULL, 0x000fe20000041854ULL, 0x000000012f2f6812ULL, 0x000fe400078efcffULL,
0x000000653300720bULL, 0x000fe20003fdd000ULL, 0x0000004e008d7306ULL, 0x000e620000005400ULL,
0x00000001acac5812ULL, 0x010fe400078efcffULL, 0x0000004d2e2e723eULL, 0x000fc400000010ffULL,
0x000000ac2f2f723eULL, 0x000fc600000010ffULL, 0x000000b500a87306ULL, 0x000fe80000209400ULL,
0x0000000130306812ULL, 0x000fe200078efcffULL, 0x0000002e4448723cULL, 0x000fe60000041848ULL,
0x000000b5009f7306ULL, 0x000ea20000205400ULL, 0x0000008d8c00720bULL, 0x002fce0003f5d000ULL,
0x000000b600907306ULL, 0x000ff00000209400ULL, 0x000000b600877306ULL, 0x000e620000205400ULL,
0x0000009fa800720bULL, 0x004fce0003f9d000ULL, 0x0000004e00597306ULL, 0x0004f0000000d400ULL,
0x000000b600817306ULL, 0x000f22000020d400ULL, 0x000000a6a74e723eULL, 0x004fe400000010ffULL,
0x000000879000720bULL, 0x002fca0003fbd000ULL, 0x0000004e3834723cULL, 0x000fe20000041834ULL,
0x000000b5004e7306ULL, 0x000e62000020d400ULL, 0x0000000159592812ULL, 0x008fcc00078efcffULL,
0x0000007e3838723cULL, 0x000fe2000004183cULL, 0x000000b3004f7306ULL, 0x000fe20000209400ULL,
0x0000000181815812ULL, 0x010fce00078efcffULL, 0x000000b3003c7306ULL, 0x000ea20000205400ULL,
0x000000014e4e4812ULL, 0x002fe400078efcffULL, 0x000000646600720bULL, 0x000fe40003f9d000ULL,
0x000000594e4e723eULL, 0x000fe400000010ffULL, 0x0000007c4434723cULL, 0x000fe20000041834ULL,
0x000000ae003d7306ULL, 0x000ff00000209400ULL, 0x000000ae003e7306ULL, 0x000e620000205400ULL,
0x0000003c4f00720bULL, 0x004fc40003f5d000ULL, 0x0000000131314812ULL, 0x000fe400078efcffULL,
0x0000005a814f723eULL, 0x000fc600000010ffULL, 0x000000b300b37306ULL, 0x000ea8000020d400ULL,
0x0000004e4440723cULL, 0x000fe80000041840ULL, 0x000000ae00ae7306ULL, 0x000ee2000020d400ULL,
0x0000003e3d00720bULL, 0x002fe40003fbd000ULL, 0x00000001b3b32812ULL, 0x004fc800078efcffULL,
0x000000b33030723eULL, 0x000fce00000010ffULL, 0x00000001aeae5812ULL, 0x008fc800078efcffULL,
0x000000ae3131723eULL, 0x000fce00000010ffULL, 0x000000304438723cULL, 0x000fe20000041838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff2e7f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe4000784482fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc4000784482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe4000784482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00005800092e7a24ULL, 0x020fc800078e02ffULL, 0x000000402e307824ULL, 0x000fe200078e00ffULL,
0x000000c0042e7811ULL, 0x000fc800078e40ffULL, 0x0000002030317210ULL, 0x040fe40007f5e0ffULL,
0x00000021303c7210ULL, 0x000fe40007f7e0ffULL, 0x0000002e032f7217ULL, 0x000fe20007800000ULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005e00313e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0x00005e003c447a11ULL, 0x000fe200078640ffULL,
0x000000012f2f7824ULL, 0x000fe200078e0a2eULL, 0x00005f0031337a11ULL, 0x000fc400010f4432ULL,
0x00000022302e7210ULL, 0x000fe40007f5e0ffULL, 0x00005f003c3d7a11ULL, 0x000fe400018f443dULL,
0x0000002330307210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e06ffULL,
0x000000202f2f7807ULL, 0x000fe40000000000ULL, 0x00005e002e327a11ULL, 0x000fe200078440ffULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x0000002f082f7217ULL, 0x000fc40007800000ULL,
0x00005e0030467a11ULL, 0x000fe400078640ffULL, 0x00005f002e3f7a11ULL, 0x000fe200010f443fULL,
0x000000012f3c7824ULL, 0x000fe200078e0a08ULL, 0x00005f0030457a11ULL, 0x000fe400018f4445ULL,
0x000000133e2e7210ULL, 0x080fe40007f7e0ffULL, 0x00000004ff317819ULL, 0x000fe40000011602ULL,
0x0000001344307210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200018e0633ULL,
0x0000001332327210ULL, 0x000fc40007fbe0ffULL, 0x0000003c3100720cULL, 0x080fe20003f46070ULL,
0x000000ffff317224ULL, 0x000fe200020e063dULL, 0x0000003cf500720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200028e063fULL, 0x0000003c0e00720cULL, 0x080fe40003f86070ULL,
0x0000003c0f00720cULL, 0x000fe40003fa6070ULL, 0x00000013463c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0645ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e247faeULL, 0x0003e8000d101c46ULL, 0x0000000030257faeULL, 0x0003e8000d901c46ULL,
0x0000000032267faeULL, 0x0003e8000e101c46ULL, 0x000000003c277faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff2e7f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844875ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e002fULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff2f7984ULL, 0x000e640000000800ULL,
0x800000002fff7812ULL, 0x002fe40007844875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL,
0x0000002f00307305ULL, 0x0002a4000021f000ULL, 0x3fa000002f2f7823ULL, 0x002fe200000100ffULL,
0x000000300000735dULL, 0x004fe20003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000019ff2f723eULL, 0x000fe400000010ffULL, 0x00000002ff587819ULL, 0x000fe40000011602ULL,
0x000054102f327816ULL, 0x000fe2000000002fULL, 0x00010b727f007947ULL, 0x000fea000b800000ULL,
0x00001f5832b97589ULL, 0x0002a400000e0000ULL, 0x00010bb27f007947ULL, 0x000fea000b800000ULL,
0x00001ff632ba7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00fbULL, 0x0000e3d000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0001157000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00faULL, 0x0000e43000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0001151000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000283c783bULL, 0x000f680000004200ULL, 0x000000002930783bULL, 0x00ae680000004200ULL,
0x000000002a4c783bULL, 0x000ee20000004200ULL, 0x00000018ff447819ULL, 0x020fe2000001143dULL,
0x0000003c00707306ULL, 0x000fe20000009400ULL, 0x00000018ff457819ULL, 0x000fe2000001143eULL,
0x000001003c737824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fc4000001143fULL,
0x00000018ff597819ULL, 0x002fe40000011432ULL, 0x00000018ff2f7819ULL, 0x004fe2000001143cULL,
0x0000004400957306ULL, 0x000fe20000209400ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff5a7819ULL, 0x000fe40000011433ULL, 0x00000018ff587819ULL, 0x000fe40000011431ULL,
0x00000018ff5b7819ULL, 0x008fe2000001144fULL, 0x0000004400eb7306ULL, 0x000ff00000205400ULL,
0x00000044008d7306ULL, 0x000ff0000020d400ULL, 0x0000004500977306ULL, 0x000ff00000209400ULL,
0x0000004500df7306ULL, 0x000ff00000205400ULL, 0x0000004500a57306ULL, 0x000ff0000020d400ULL,
0x0000004600987306ULL, 0x000ff00000209400ULL, 0x0000004600de7306ULL, 0x000ff00000205400ULL,
0x0000004600a07306ULL, 0x0003f0000020d400ULL, 0x0000005900c57306ULL, 0x000fe20000209400ULL,
0x000000002b44783bULL, 0x002e6e0000004200ULL, 0x0000005900c67306ULL, 0x000ff00000205400ULL,
0x00000059007b7306ULL, 0x0005f0000020d400ULL, 0x0000003c009f7306ULL, 0x000ee20000005400ULL,
0x00000018ff597819ULL, 0x004fce000001144eULL, 0x0000002f00717306ULL, 0x000ff00000209400ULL,
0x0000002f00ae7306ULL, 0x000ea20000205400ULL, 0x00000018ff747819ULL, 0x002fe40000011445ULL,
0x0000009f7000720bULL, 0x008fc40003fbd000ULL, 0x00000018ff797819ULL, 0x000fe40000011447ULL,
0x00000018ff787819ULL, 0x000fe20000011446ULL, 0x0000005900937306ULL, 0x000ff00000209400ULL,
0x0000005900947306ULL, 0x000fe20000205400ULL, 0x000000ae7100720bULL, 0x004fce0003f7d000ULL,
0x0000005900687306ULL, 0x000ff0000020d400ULL, 0x00000074006a7306ULL, 0x000ff00000209400ULL,
0x00000074006b7306ULL, 0x000ff00000205400ULL, 0x0000007400597306ULL, 0x0003f0000020d400ULL,
0x0000003d00ee7306ULL, 0x000fe20000009400ULL, 0x000001003d747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000003d00af7306ULL, 0x000ff00000005400ULL,
0x0000003d008f7306ULL, 0x0003f0000000d400ULL, 0x0000003c008e7306ULL, 0x0004e2000000d400ULL,
0x000100003d3d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000007300777306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000073009e7306ULL, 0x000e620000205400ULL,
0x000000018e8e5812ULL, 0x008fce00078efcffULL, 0x0000002f008c7306ULL, 0x0004f0000020d400ULL,
0x0000003e00ea7306ULL, 0x000fe20000009400ULL, 0x0000009e7700720bULL, 0x002fe40003f5d000ULL,
0x00000018ff2f7819ULL, 0x004fca0000011430ULL, 0x0000003e00967306ULL, 0x000e620000005400ULL,
0x000000018c8c3812ULL, 0x008fce00078efcffULL, 0x0000007400f17306ULL, 0x000ff00000209400ULL,
0x0000007400f27306ULL, 0x000ea20000205400ULL, 0x00000096ea00720bULL, 0x002fce0003f7d000ULL,
0x0000003d00ef7306ULL, 0x000ff00000209400ULL, 0x0000003d00f07306ULL, 0x000e620000205400ULL,
0x000000f2f100720bULL, 0x004fce0003f9d000ULL, 0x0000003c00b47306ULL, 0x000ff00000209400ULL,
0x0000003c00b57306ULL, 0x000ea20000205400ULL, 0x000000f0ef00720bULL, 0x002fce0003fbd000ULL,
0x0000003c00b67306ULL, 0x0002f0000020d400ULL, 0x0000003f00897306ULL, 0x000fe20000009400ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x000000b5b400720bULL, 0x004fc80003fdd000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003f008a7306ULL, 0x000fee0000005400ULL,
0x00000001b6b66812ULL, 0x008fe200078efcffULL, 0x0000003f00a67306ULL, 0x0003e2000000d400ULL,
0x000000eb9500720bULL, 0x000fc40003fdd000ULL, 0x000000b68c8c723eULL, 0x000fca00000010ffULL,
0x0000007300bc7306ULL, 0x0004e2000020d400ULL, 0x000100003f3f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003e00ab7306ULL, 0x000362000000d400ULL,
0x000001003e737824ULL, 0x004fe200078e00ffULL, 0x000000018d8d6812ULL, 0x000fc800078efcffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000007400bb7306ULL, 0x000ea2000020d400ULL,
0x00000001bcbc2812ULL, 0x008fe200078efcffULL, 0x000100003e3e7824ULL, 0x002fe200078e00ffULL,
0x000000afee00720bULL, 0x000fe40003f5d000ULL, 0x0000008ebc8e723eULL, 0x000fe400000010ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003d00b17306ULL, 0x0002e2000020d400ULL,
0x00000001abab3812ULL, 0x020fce00078efcffULL, 0x0000007300ec7306ULL, 0x000fe20000209400ULL,
0x00000001bbbb4812ULL, 0x004fe200078efcffULL, 0x00000100303d7824ULL, 0x002fe200078e00ffULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x0000008a8900720bULL, 0x000fe40003f5d000ULL,
0x0000008fbb8f723eULL, 0x000fe200000010ffULL, 0x0000007300ed7306ULL, 0x000e620000205400ULL,
0x00000001b1b15812ULL, 0x008fc800078efcffULL, 0x000000b18d8d723eULL, 0x000fc600000010ffULL,
0x0000003c00e67306ULL, 0x000fe40000209400ULL, 0x00000001a6a62812ULL, 0x000fcc00078efcffULL,
0x0000003c00e77306ULL, 0x000ea20000205400ULL, 0x000000edec00720bULL, 0x002fce0003f9d000ULL,
0x0000003f00e27306ULL, 0x000ff00000209400ULL, 0x0000003f00e37306ULL, 0x000e620000205400ULL,
0x000000e7e600720bULL, 0x004fce0003fbd000ULL, 0x0000002f008b7306ULL, 0x000ff00000209400ULL,
0x0000002f00907306ULL, 0x000fe20000205400ULL, 0x000000e3e200720bULL, 0x002fce0003f7d000ULL,
0x0000002f00927306ULL, 0x0003f0000020d400ULL, 0x0000007300b07306ULL, 0x0004e2000020d400ULL,
0x00000018ff2f7819ULL, 0x002fce000001144cULL, 0x0000002f00b87306ULL, 0x000fe20000209400ULL,
0x00000018ff737819ULL, 0x004fce000001143dULL, 0x0000002f00b77306ULL, 0x000fe20000205400ULL,
0x00000001b0b04812ULL, 0x008fe400078efcffULL, 0x000000df9700720bULL, 0x000fca0003f9d000ULL,
0x0000002f006f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00a77306ULL, 0x0004e2000020d400ULL,
0x00000018ff2f7819ULL, 0x002fe40000011444ULL, 0x00000001a5a54812ULL, 0x000fca00078efcffULL,
0x0000003f00a27306ULL, 0x000e62000020d400ULL, 0x00000100313c7824ULL, 0x004fce00078e00ffULL,
0x0000003100dc7306ULL, 0x000fe20000009400ULL, 0x00000001a7a75812ULL, 0x008fe400078efcffULL,
0x000000de9800720bULL, 0x000fca0003fbd000ULL, 0x0000003100db7306ULL, 0x000ea20000005400ULL,
0x00000001a2a23812ULL, 0x002fce00078efcffULL, 0x0000005800d97306ULL, 0x000fe20000209400ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x000000908b00720bULL, 0x000fca0003fbd000ULL,
0x0000005800da7306ULL, 0x000fe20000205400ULL, 0x000000dbdc00720bULL, 0x004fce0003f7d000ULL,
0x0000005800847306ULL, 0x0003e2000020d400ULL, 0x0000000192925812ULL, 0x000fce00078efcffULL,
0x0000005a00867306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x002fce000001144dULL,
0x0000005a00c37306ULL, 0x000ff00000205400ULL, 0x0000005a00767306ULL, 0x000ff0000020d400ULL,
0x0000005b00827306ULL, 0x000ff00000209400ULL, 0x0000005b00837306ULL, 0x000ff00000205400ULL,
0x0000005b00647306ULL, 0x000ff0000020d400ULL, 0x0000002f006d7306ULL, 0x000ff00000209400ULL,
0x0000002f006e7306ULL, 0x000ff00000205400ULL, 0x0000002f005a7306ULL, 0x000ff0000020d400ULL,
0x00000079005b7306ULL, 0x000ff00000209400ULL, 0x0000007900657306ULL, 0x000ff00000205400ULL,
0x00000079002f7306ULL, 0x0003f0000020d400ULL, 0x0000005800ac7306ULL, 0x000fe20000209400ULL,
0x0000010032797824ULL, 0x002fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000005800ad7306ULL, 0x000ff00000205400ULL, 0x0000005800697306ULL, 0x000ff0000020d400ULL,
0x0000007800677306ULL, 0x000ff00000209400ULL, 0x0000007800667306ULL, 0x000ff00000205400ULL,
0x0000007800587306ULL, 0x0003f0000020d400ULL, 0x0000007300e47306ULL, 0x000fe20000209400ULL,
0x00000018ff787819ULL, 0x002fce000001143cULL, 0x0000007300e57306ULL, 0x000e700000205400ULL,
0x0000003200c77306ULL, 0x000ff00000009400ULL, 0x0000003200c87306ULL, 0x000fe20000005400ULL,
0x000000e5e400720bULL, 0x002fce0003f5d000ULL, 0x0000003200817306ULL, 0x0003f0000000d400ULL,
0x00000031009a7306ULL, 0x0004e2000000d400ULL, 0x0001000032327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003e00e87306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x004fce00078e00ffULL, 0x0000003e00e97306ULL, 0x000e620000205400ULL,
0x000000019a9a3812ULL, 0x008fce00078efcffULL, 0x00000078003c7306ULL, 0x000ff00000209400ULL,
0x00000078003d7306ULL, 0x000ea20000205400ULL, 0x000000e9e800720bULL, 0x002fce0003fdd000ULL,
0x0000007900e07306ULL, 0x000ff00000209400ULL, 0x0000007900e17306ULL, 0x000e620000205400ULL,
0x0000003d3c00720bULL, 0x004fe40003f9d000ULL, 0x0000b0002d3c7811ULL, 0x000fca00078e20ffULL,
0x0000003000dd7306ULL, 0x000ff00000009400ULL, 0x0000003000727306ULL, 0x000fe20000005400ULL,
0x000000e1e000720bULL, 0x002fce0003f7d000ULL, 0x00000030009d7306ULL, 0x0003f0000000d400ULL,
0x00000078009c7306ULL, 0x0004e2000020d400ULL, 0x0001000030307824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011430ULL, 0x0000003300857306ULL, 0x000fe20000009400ULL,
0x0000010033787824ULL, 0x004fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000003300c47306ULL, 0x000fe20000005400ULL, 0x000000019c9c4812ULL, 0x008fce00078efcffULL,
0x00000033007c7306ULL, 0x0003f0000000d400ULL, 0x0000007300a17306ULL, 0x0004e2000020d400ULL,
0x0001000033337824ULL, 0x002fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003200cf7306ULL, 0x000fe20000209400ULL, 0x00000018ff737819ULL, 0x004fce0000011431ULL,
0x0000003200d07306ULL, 0x000fe20000205400ULL, 0x00000001a1a12812ULL, 0x008fce00078efcffULL,
0x0000003200887306ULL, 0x0003f0000020d400ULL, 0x0000003e00a87306ULL, 0x000ea2000020d400ULL,
0x000001004e327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000007400307306ULL, 0x000ff00000209400ULL, 0x00000074003e7306ULL, 0x000e620000205400ULL,
0x00000001a8a86812ULL, 0x004fc400078efcffULL, 0x00000072dd00720bULL, 0x000fca0003fdd000ULL,
0x0000007300317306ULL, 0x000ff00000209400ULL, 0x00000073003f7306ULL, 0x000ea20000205400ULL,
0x0000003e3000720bULL, 0x002fe40003f5d000ULL, 0x0000b0002c307811ULL, 0x000fc400078e20ffULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x000000dad900720bULL, 0x000fe20003fdd000ULL,
0x0000007300997306ULL, 0x0002f0000020d400ULL, 0x0000007900917306ULL, 0x000f62000020d400ULL,
0x000001004c737824ULL, 0x002fe200078e00ffULL, 0x0000003f3100720bULL, 0x004fc40003f9d000ULL,
0x0000000184846812ULL, 0x000fe200078efcffULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000003300d77306ULL, 0x000fe20000209400ULL,
0x000000c6c500720bULL, 0x000fe20003fdd000ULL, 0x0000010047c57824ULL, 0x000fca00078e00ffULL,
0x0000000199994812ULL, 0x008fe200078efcffULL, 0x0000003300d87306ULL, 0x000fe20000205400ULL,
0x0000000191913812ULL, 0x020fe400078efcffULL, 0x000000d0cf00720bULL, 0x000fe40003f7d000ULL,
0x000000c48500720bULL, 0x000fe20003f9d000ULL, 0x0000010046c47824ULL, 0x000fe200078e00ffULL,
0x000000017b7b6812ULL, 0x000fe200078efcffULL, 0x00000033007f7306ULL, 0x0005e2000020d400ULL,
0x00000018ffc57819ULL, 0x000fc400000114c5ULL, 0x00000018ffc47819ULL, 0x000fca00000114c4ULL,
0x0000007800d57306ULL, 0x000fe20000209400ULL, 0x000001004f337824ULL, 0x004fe200078e00ffULL,
0x0000000188883812ULL, 0x000fe400078efcffULL, 0x000000017c7c4812ULL, 0x000fe400078efcffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000007800d67306ULL, 0x000ea20000205400ULL,
0x000000b93c3c9231ULL, 0x082fe400003400ffULL, 0x000000b93e3e9231ULL, 0x000fca00003400ffULL,
0x0000003200b27306ULL, 0x000fe20000209400ULL, 0x000000ba3d3d9231ULL, 0x090fe400003400ffULL,
0x000000ba3f3f9231ULL, 0x000fca00003400ffULL, 0x0000003200b37306ULL, 0x000fe20000205400ULL,
0x000000d6d500720bULL, 0x004fce0003fbd000ULL, 0x0000003200797306ULL, 0x0003f0000020d400ULL,
0x0000007300cb7306ULL, 0x000fe20000209400ULL, 0x000100004e327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000007300cc7306ULL, 0x000ff00000205400ULL,
0x0000007300807306ULL, 0x000ff0000020d400ULL, 0x0000003300a97306ULL, 0x000ff00000209400ULL,
0x0000003300aa7306ULL, 0x000ff00000205400ULL, 0x0000003300737306ULL, 0x0003f0000020d400ULL,
0x00000074009b7306ULL, 0x0004e2000020d400ULL, 0x000100004f337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000007800877306ULL, 0x000e62000020d400ULL,
0x000001004d747824ULL, 0x004fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000004d00c07306ULL, 0x000fe20000009400ULL, 0x000000019b9b2812ULL, 0x008fe400078efcffULL,
0x000000c8c700720bULL, 0x000fca0003f5d000ULL, 0x0000004d00bf7306ULL, 0x000ea20000005400ULL,
0x0000000187875812ULL, 0x002fe400078efcffULL, 0x000000d8d700720bULL, 0x000fca0003fbd000ULL,
0x0000003200a37306ULL, 0x000fe20000209400ULL, 0x0000000181812812ULL, 0x000fe400078efcffULL,
0x000000c38600720bULL, 0x000fe20003f5d000ULL, 0x0001000045c37824ULL, 0x000fc800078e00ffULL,
0x0000003200a47306ULL, 0x000e620000205400ULL, 0x000000bfc000720bULL, 0x004fe40003f7d000ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x000000cccb00720bULL, 0x000fe40003fbd000ULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000003200777306ULL, 0x0004e2000020d400ULL,
0x0000000176762812ULL, 0x000fce00078efcffULL, 0x00000033009e7306ULL, 0x000fe20000209400ULL,
0x0000010044327824ULL, 0x004fe200078e00ffULL, 0x0000000180805812ULL, 0x000fe400078efcffULL,
0x000000b7b800720bULL, 0x000fe40003fbd000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000033009f7306ULL, 0x000ff00000205400ULL, 0x0000003300707306ULL, 0x0005e2000020d400ULL,
0x000000016f6f5812ULL, 0x000fc400078efcffULL, 0x000000b3b200720bULL, 0x000fca0003fbd000ULL,
0x0000003200977306ULL, 0x000fe20000209400ULL, 0x0000010045337824ULL, 0x004fca00078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe40000011433ULL, 0x0000003200987306ULL, 0x000fe20000205400ULL,
0x0000000179795812ULL, 0x000fe400078efcffULL, 0x000000a4a300720bULL, 0x002fca0003fbd000ULL,
0x0000003200727306ULL, 0x0003f0000020d400ULL, 0x0000004d006c7306ULL, 0x000522000000d400ULL,
0x000000003030783bULL, 0x002e620000000200ULL, 0x0000000177775812ULL, 0x008fcc00078efcffULL,
0x0000004c00be7306ULL, 0x000fe20000009400ULL, 0x000100004d4d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004c00bd7306ULL, 0x000ea20000005400ULL,
0x000000016c6c3812ULL, 0x010fe400078efcffULL, 0x000000adac00720bULL, 0x000fca0003f7d000ULL,
0x0000004c00757306ULL, 0x000730000000d400ULL, 0x0000007400cd7306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x008fe200078e00ffULL, 0x000000bdbe00720bULL, 0x004fc40003f9d000ULL,
0x0000000169693812ULL, 0x000fe400078efcffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000007400ce7306ULL, 0x000ea20000205400ULL, 0x000000aaa900720bULL, 0x000fe20003f7d000ULL,
0x000000b930309231ULL, 0x082fe400003400ffULL, 0x000000b932329231ULL, 0x000fe400003400ffULL,
0x000000ba31319231ULL, 0x080fe200003400ffULL, 0x0000000175754812ULL, 0x010fe200078efcffULL,
0x0000004c00c97306ULL, 0x000fe20000209400ULL, 0x000000ba33339231ULL, 0x000fca00003400ffULL,
0x0000000173733812ULL, 0x000fe400078efcffULL, 0x0000004c00ca7306ULL, 0x000e620000205400ULL,
0x000000cecd00720bULL, 0x004fe20003f5d000ULL, 0x0000008c3060723cULL, 0x040fe20000041860ULL,
0x000000838200720bULL, 0x000fe40003f7d000ULL, 0x000000819182723eULL, 0x000fe400000010ffULL,
0x0000007c8783723eULL, 0x000fe200000010ffULL, 0x0000004e00d17306ULL, 0x000fe20000009400ULL,
0x000000a8a58c723eULL, 0x000fe200000010ffULL, 0x0000008e305c723cULL, 0x000fe2000004185cULL,
0x000000a2a08d723eULL, 0x000fc400000010ffULL, 0x00000075807c723eULL, 0x000fc600000010ffULL,
0x0000004e00d27306ULL, 0x000ea20000005400ULL, 0x000000cac900720bULL, 0x002fe20003f9d000ULL,
0x0000008c3054723cULL, 0x040fe20000041854ULL, 0x000000abb08e723eULL, 0x000fe400000010ffULL,
0x000000a6a78f723eULL, 0x000fe400000010ffULL, 0x0000000164643812ULL, 0x000fe200078efcffULL,
0x00000074007d7306ULL, 0x000e62000020d400ULL, 0x0000009b928c723eULL, 0x000fe200000010ffULL,
0x000000823040723cULL, 0x000fe20000041840ULL, 0x00000099848d723eULL, 0x000fca00000010ffULL,
0x0000004d00c17306ULL, 0x000fe20000209400ULL, 0x000000d2d100720bULL, 0x004fe20003fdd000ULL,
0x0000008e3034723cULL, 0x040fec0000041834ULL, 0x0000004d00c27306ULL, 0x000ea20000205400ULL,
0x000000017d7d2812ULL, 0x002fe200078efcffULL, 0x0000008c3048723cULL, 0x000fe20000041848ULL,
0x0000009da18e723eULL, 0x000fc400000010ffULL, 0x0000009a9c8f723eULL, 0x000fe400000010ffULL,
0x0000006c7d7d723eULL, 0x000fe200000010ffULL, 0x0000004c007e7306ULL, 0x000e62000020d400ULL,
0x000000887b8c723eULL, 0x000fe400000010ffULL, 0x0000007f768d723eULL, 0x000fe200000010ffULL,
0x0000008e3050723cULL, 0x000fe80000041850ULL, 0x0000004e007a7306ULL, 0x000ee2000000d400ULL,
0x000000c2c100720bULL, 0x004fc60003f5d000ULL, 0x0000008c3038723cULL, 0x000fe80000041838ULL,
0x0000004400b47306ULL, 0x000fe20000009400ULL, 0x000000017e7e4812ULL, 0x002fc600078efcffULL,
0x0000007c3c5c723cULL, 0x000fe2000004185cULL, 0x0000007e6f7e723eULL, 0x000fc600000010ffULL,
0x0000004400b57306ULL, 0x000e620000005400ULL, 0x000000017a7a6812ULL, 0x008fe400078efcffULL,
0x000000949300720bULL, 0x000fe40003fdd000ULL, 0x0000007a797a723eULL, 0x000fc600000010ffULL,
0x0000004400717306ULL, 0x0004f0000000d400ULL, 0x0000004d00787306ULL, 0x000f22000020d400ULL,
0x0001000044447824ULL, 0x004fe200078e00ffULL, 0x000000b5b400720bULL, 0x002fc40003f9d000ULL,
0x0000000168686812ULL, 0x000fe400078efcffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004500ae7306ULL, 0x000fe20000009400ULL, 0x000000989700720bULL, 0x000fe40003fdd000ULL,
0x000000776868723eULL, 0x000fc800000010ffULL, 0x0000000171714812ULL, 0x008fe200078efcffULL,
0x0000004500af7306ULL, 0x000e620000005400ULL, 0x0000000178782812ULL, 0x010fc800078efcffULL,
0x00000078697f723eULL, 0x000fe400000010ffULL, 0x0000000172726812ULL, 0x000fe200078efcffULL,
0x0000004f00d37306ULL, 0x000fe20000009400ULL, 0x0000006e6d00720bULL, 0x000fe40003fdd000ULL,
0x000000717272723eULL, 0x000fe200000010ffULL, 0x0000007e3c60723cULL, 0x000fe80000041860ULL,
0x0000004f00d47306ULL, 0x000ea20000005400ULL, 0x000000afae00720bULL, 0x002fca0003f5d000ULL,
0x000000015a5a6812ULL, 0x000fe400078efcffULL, 0x000000db008b7306ULL, 0x000fe20000209400ULL,
0x000000666700720bULL, 0x000fce0003fdd000ULL, 0x000000db00907306ULL, 0x000e620000205400ULL,
0x000000d4d300720bULL, 0x004fca0003f3d000ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000004400857306ULL, 0x000ff00000209400ULL, 0x0000004400867306ULL, 0x000ea20000205400ULL,
0x000000908b00720bULL, 0x002fce0003f7d000ULL, 0x00000045004e7306ULL, 0x000e70000000d400ULL,
0x0000004f00747306ULL, 0x000ee2000000d400ULL, 0x000000868500720bULL, 0x004fce0003f9d000ULL,
0x000000db004f7306ULL, 0x000ea2000020d400ULL, 0x000000014e4e2812ULL, 0x002fe400078efcffULL,
0x0000006b6a00720bULL, 0x000fca0003f5d000ULL, 0x0000004400457306ULL, 0x000e62000020d400ULL,
0x0000000174741812ULL, 0x008fe400078efcffULL, 0x0000009f9e00720bULL, 0x000fe40003f3d000ULL,
0x00000074737b723eULL, 0x000fc600000010ffULL, 0x0000004600957306ULL, 0x000fe20000009400ULL,
0x000000014f4f3812ULL, 0x004fe400078efcffULL, 0x0000000159592812ULL, 0x000fe200078efcffULL,
0x0000007a3c34723cULL, 0x000fe20000041834ULL, 0x0000004e4f73723eULL, 0x000fc600000010ffULL,
0x0000004600967306ULL, 0x000ea20000005400ULL, 0x0000000145454812ULL, 0x002fe400078efcffULL,
0x0000000170701812ULL, 0x000fe200078efcffULL, 0x000000723c50723cULL, 0x040fe20000041850ULL,
0x000000455a5a723eULL, 0x000fe400000010ffULL, 0x000000706469723eULL, 0x000fe200000010ffULL,
0x000000c300bd7306ULL, 0x000fec0000209400ULL, 0x000000683c54723cULL, 0x000fe40000041854ULL,
0x000000c300be7306ULL, 0x000e620000205400ULL, 0x000000969500720bULL, 0x004fce0003fbd000ULL,
0x000000c400b17306ULL, 0x000ff00000209400ULL, 0x000000c400a67306ULL, 0x000ea20000205400ULL,
0x000000bebd00720bULL, 0x002fce0003f7d000ULL, 0x00000046004d7306ULL, 0x0002f0000000d400ULL,
0x0000004700897306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x002fe200078e00ffULL,
0x000000a6b100720bULL, 0x004fc80003f9d000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000047008a7306ULL, 0x000e620000005400ULL, 0x000000014d4d5812ULL, 0x008fce00078efcffULL,
0x00000047004c7306ULL, 0x0004f0000000d400ULL, 0x000000c300447306ULL, 0x000f22000020d400ULL,
0x0001000047477824ULL, 0x004fe200078e00ffULL, 0x0000008a8900720bULL, 0x002fc80003f3d000ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x000000c400a07306ULL, 0x000e6e000020d400ULL,
0x000000014c4c1812ULL, 0x008fe200078efcffULL, 0x000000c5009a7306ULL, 0x000fe20000209400ULL,
0x0000000144443812ULL, 0x010fc400078efcffULL, 0x000000655b00720bULL, 0x000fe40003f7d000ULL,
0x00000044595b723eULL, 0x000fc600000010ffULL, 0x000000c5008f7306ULL, 0x000ea20000205400ULL,
0x00000001a0a04812ULL, 0x002fc600078efcffULL, 0x0000005a3c48723cULL, 0x000fe20000041848ULL,
0x0000004da0a0723eULL, 0x000fc600000010ffULL, 0x0000004600767306ULL, 0x000fe20000209400ULL,
0x000000012f2f3812ULL, 0x000fce00078efcffULL, 0x0000004600317306ULL, 0x000e620000205400ULL,
0x0000008f9a00720bULL, 0x004fce0003f5d000ULL, 0x0000004700307306ULL, 0x000ff00000209400ULL,
0x00000047006b7306ULL, 0x000ea20000205400ULL, 0x000000317600720bULL, 0x002fce0003f9d000ULL,
0x000000c500a17306ULL, 0x000e70000020d400ULL, 0x0000004600337306ULL, 0x000ee2000020d400ULL,
0x0000006b3000720bULL, 0x004fce0003fbd000ULL, 0x0000004700327306ULL, 0x000ea2000020d400ULL,
0x00000001a1a12812ULL, 0x002fc800078efcffULL, 0x0000004ca1a1723eULL, 0x000fe400000010ffULL,
0x0000000133334812ULL, 0x008fc800078efcffULL, 0x000000335858723eULL, 0x000fe200000010ffULL,
0x000000a03c40723cULL, 0x000fe20000041840ULL, 0x0000000132325812ULL, 0x004fc800078efcffULL,
0x000000322f59723eULL, 0x000fce00000010ffULL, 0x000000583c3c723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c004307811ULL, 0x002fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000300300720cULL, 0x000fda0003f24070ULL, 0x00004f6000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL,
0x0000002f00307305ULL, 0x0002a4000021f000ULL, 0x3fa000002f2f7823ULL, 0x002fe200000100ffULL,
0x000000300000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff307424ULL, 0x000fe200078e00ffULL, 0x0000000307317812ULL, 0x000fe200078ec0ffULL,
0x00000300ff2f7624ULL, 0x000fe400078e00ffULL, 0x0000580009337a24ULL, 0x000fe200078e02ffULL,
0x000000033100780cULL, 0x000fe20003f25270ULL, 0xfffffffd302f7424ULL, 0x000fe400078e022fULL,
0xffffffffff097424ULL, 0x000fc600078e00ffULL, 0x000000012f327807ULL, 0x000fca0004800000ULL,
0x0000000107077824ULL, 0x000fe200078e0232ULL, 0x000000e004327811ULL, 0x000fc800078e40ffULL,
0x000000050700720cULL, 0x000fe40003f26070ULL, 0x00000032032f7217ULL, 0x000fe20007800000ULL,
0x0000004033337824ULL, 0x000fc800078e00ffULL, 0x000000012f2f7824ULL, 0x000fe200078e0a32ULL,
0x0000000d33327210ULL, 0x000fca0007f5e0ffULL, 0x0000000107319824ULL, 0x000fe200078e020cULL,
0x000000202f2f7807ULL, 0x000fe40000000000ULL, 0x0000001033387210ULL, 0x000fe20007f7e0ffULL,
0x0000600031309625ULL, 0x000fe200078e0030ULL, 0x0000001133397210ULL, 0x040fe40007f9e0ffULL,
0x0000002f082f7217ULL, 0x000fe20007800000ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x0000000630099981ULL, 0x000362000c1e1900ULL, 0x00005e0032107a11ULL, 0x000fe200078040ffULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000001233337210ULL, 0x000fe20007f3e0ffULL,
0x000000012f127824ULL, 0x000fe200078e0a08ULL, 0x00000004ff0d7819ULL, 0x000fc40000011602ULL,
0x00005f0032117a11ULL, 0x000fe400000f4411ULL, 0x0000001310107210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x002fe200018e06ffULL, 0x00005e0038307a11ULL, 0x040fe400078440ffULL,
0x00005e0039447a11ULL, 0x040fe200078640ffULL, 0x000000ffff117224ULL, 0x000fe200020e0611ULL,
0x00005f0038317a11ULL, 0x000fe200010f4431ULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x00005f00393a7a11ULL, 0x000fc400018f443aULL, 0x000000120d00720cULL, 0x080fe40003f06070ULL,
0x00005e0033467a11ULL, 0x000fe400078240ffULL, 0x00000012f500720cULL, 0x080fe40003f66070ULL,
0x000000120e00720cULL, 0x080fe40003fa6070ULL, 0x000000120f00720cULL, 0x000fe40003f86070ULL,
0x0000001330307210ULL, 0x000fc40007f5e0ffULL, 0x0000001344327210ULL, 0x080fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010147faeULL, 0x0003e2000c101c46ULL,
0x00005f00330d7a11ULL, 0x000fe200008f4438ULL, 0x000000ffff317224ULL, 0x000fe200010e0631ULL,
0x0000001346387210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fc600030e063aULL,
0x0000000030157faeULL, 0x0003e2000d901c46ULL, 0x000000ffff397224ULL, 0x000fc600008e060dULL,
0x0000000032167faeULL, 0x0003e8000e901c46ULL, 0x0000000038177faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff107f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff0d7984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106680008147f8cULL, 0x000fe2000c80043fULL, 0x800000000dff7812ULL, 0x004fc6000780482eULL,
0x01066c0008177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fe40007824815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d00127305ULL, 0x0004e4000021f000ULL, 0x3fa000000d0d7823ULL, 0x004fe200000100ffULL,
0x000000120000735dULL, 0x008fe20003800000ULL, 0x01066c0008177984ULL, 0x000ea40000000800ULL,
0x8000000017ff7812ULL, 0x004fc40007824815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01018000180d7984ULL, 0x000ea80000000800ULL, 0x0103800018127984ULL, 0x0007220000000800ULL,
0x0000000a0d00720bULL, 0x004fe20003f3d000ULL, 0x0000e6627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800008e0100ULL, 0x0000ffff14157812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff787424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000030000780cULL, 0x000fe40003f45270ULL,
0x0000000a0d00720bULL, 0x000fe20003f34000ULL, 0x0000e6427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x0000000d0a177209ULL, 0x000fe40007810000ULL,
0x0000ffff14147812ULL, 0x000fe400078e3cffULL, 0x00000002ff587819ULL, 0x000fe20000011602ULL,
0x800000170a0a7221ULL, 0x000fe20000010000ULL, 0x010580171800a388ULL, 0x0005e20000000800ULL,
0x0000001415ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL,
0x0000000a00327308ULL, 0x000ee40000000800ULL, 0x000000320b0b7220ULL, 0x008fe20000410000ULL,
0x0000e5f27f007947ULL, 0x000fea000b800000ULL, 0x00001f58322f7589ULL, 0x0044e400000e0000ULL,
0x0000002f5c5c7220ULL, 0x08cfe40000410000ULL, 0x0000002f5d5d7220ULL, 0x080fe40000410000ULL,
0x0000002f60607220ULL, 0x080fe40000410000ULL, 0x0000002f61617220ULL, 0x080fe40000410000ULL,
0x0000002f34347220ULL, 0x000fc40000410000ULL, 0x0000002f35357220ULL, 0x080fe40000410000ULL,
0x0000002f54547220ULL, 0x080fe40000410000ULL, 0x0000002f55557220ULL, 0x080fe40000410000ULL,
0x0000002f50507220ULL, 0x080fe40000410000ULL, 0x0000002f51517220ULL, 0x080fe40000410000ULL,
0x0000002f48487220ULL, 0x000fc40000410000ULL, 0x0000002f49497220ULL, 0x080fe40000410000ULL,
0x0000002f40407220ULL, 0x080fe40000410000ULL, 0x0000002f41417220ULL, 0x080fe40000410000ULL,
0x0000002f3c3c7220ULL, 0x080fe40000410000ULL, 0x0000002f3d3d7220ULL, 0x000fe20000410000ULL,
0x0000e5227f007947ULL, 0x000fea000b800000ULL, 0x00001ff6322f7589ULL, 0x0004e400000e0000ULL,
0x800000170d0d1221ULL, 0x000fe20000010000ULL, 0x00000001ff787807ULL, 0x000fe20000800000ULL,
0x0000002f5e5e7220ULL, 0x00cfc40000410000ULL, 0x3fb8aa3b0d0d1820ULL, 0x000fe40000410000ULL,
0x0000002f5f5f7220ULL, 0x080fe40000410000ULL, 0x0000000d00191308ULL, 0x000ea20000000800ULL,
0x0000002f62627220ULL, 0x080fe40000410000ULL, 0x0000002f63637220ULL, 0x080fe40000410000ULL,
0x0000002f36367220ULL, 0x080fe40000410000ULL, 0x0000002f37377220ULL, 0x000fc40000410000ULL,
0x0000002f56567220ULL, 0x080fe40000410000ULL, 0x0000002f57577220ULL, 0x080fe40000410000ULL,
0x0000002f52527220ULL, 0x080fe40000410000ULL, 0x0000002f53537220ULL, 0x080fe40000410000ULL,
0x0000002f4a4a7220ULL, 0x080fe40000410000ULL, 0x0000002f4b4b7220ULL, 0x000fc40000410000ULL,
0x0000002f42427220ULL, 0x080fe40000410000ULL, 0x0000002f43437220ULL, 0x080fe40000410000ULL,
0x0000002f3e3e7220ULL, 0x080fe40000410000ULL, 0x0000002f3f3f7220ULL, 0x000fe40000410000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0017ULL, 0x0000001219121220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000b120b7221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fc4000780482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d00127305ULL, 0x0004e4000021f000ULL,
0x3fa000000d0d7823ULL, 0x004fe200000100ffULL, 0x000000120000735dULL, 0x008fe20003800000ULL,
0x0106ac00ff157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe4000780482eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000019ff0d723eULL, 0x000fe400000010ffULL,
0x00000002ff587819ULL, 0x002fc40000011602ULL, 0x000054100d327816ULL, 0x000fe2000000000dULL,
0x0000e2c27f007947ULL, 0x000fea000b800000ULL, 0x00001f5832597589ULL, 0x0002a400000e0000ULL,
0x0000e3027f007947ULL, 0x000fea000b800000ULL, 0x00001ff6324e7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff587224ULL, 0x002fe200078e00fbULL,
0x00010ec000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000ea8000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff587224ULL, 0x002fe200078e00faULL,
0x00010f2000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000ea2000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001a14783bULL, 0x000e620000004200ULL,
0x0000991078787816ULL, 0x000fc400000000ffULL, 0x0000b8001f1f7811ULL, 0x000fe200078e20ffULL,
0x000000001b30783bULL, 0x00ae680000004200ULL, 0x000000001c44783bULL, 0x000ee20000004200ULL,
0x00000018ff387819ULL, 0x000fe20000011417ULL, 0x00000100146f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe20000011414ULL, 0x0000001400eb7306ULL, 0x000fe20000009400ULL,
0x00000018ff127819ULL, 0x000fc40000011415ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff187819ULL, 0x000fe40000011416ULL, 0x00000018ff4c7819ULL, 0x002fe20000011433ULL,
0x00000038009c7306ULL, 0x000fe20000209400ULL, 0x00000018ff4f7819ULL, 0x008fce0000011447ULL,
0x0000003800bf7306ULL, 0x000ff00000205400ULL, 0x00000038002f7306ULL, 0x0043f0000020d400ULL,
0x0000000d00887306ULL, 0x000fe20000209400ULL, 0x000000001d38783bULL, 0x002e6e0000004200ULL,
0x0000000d008b7306ULL, 0x000eb00000205400ULL, 0x0000006f00e77306ULL, 0x000ff00000209400ULL,
0x0000006f00e87306ULL, 0x000ee20000205400ULL, 0x0000008b8800720bULL, 0x004fce0003fbd000ULL,
0x0000006f00ab7306ULL, 0x0005f0000020d400ULL, 0x0000001400867306ULL, 0x000f220000005400ULL,
0x00000100166f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff707819ULL, 0x002fc40000011439ULL,
0x000000e8e700720bULL, 0x008fe40003f7d000ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000001400a07306ULL, 0x0002a2000000d400ULL, 0x00000018ff587819ULL, 0x000fe40000011438ULL,
0x00000018ff747819ULL, 0x000fe4000001143bULL, 0x00000018ff717819ULL, 0x000fc6000001143aULL,
0x0000000d001c7306ULL, 0x0006a2000020d400ULL, 0x0001000014147824ULL, 0x002fe200078e00ffULL,
0x00000086eb00720bULL, 0x010fe40003f5d000ULL, 0x00000001abab3812ULL, 0x000fe400078efcffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000006f00d37306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x008fcc0000011430ULL, 0x00000001a0a02812ULL, 0x004fe200078efcffULL,
0x0000000d00ba7306ULL, 0x000fe20000209400ULL, 0x000000011c1c5812ULL, 0x000fce00078efcffULL,
0x0000000d00b37306ULL, 0x000ff00000205400ULL, 0x0000000d007c7306ULL, 0x0003f0000020d400ULL,
0x0000006f00d47306ULL, 0x000ea20000205400ULL, 0x00000018ff0d7819ULL, 0x002fce0000011444ULL,
0x0000001400e97306ULL, 0x000ff00000209400ULL, 0x0000001400ea7306ULL, 0x000e620000205400ULL,
0x000000d4d300720bULL, 0x004fce0003fbd000ULL, 0x00000014009f7306ULL, 0x0004f0000020d400ULL,
0x0000001700cc7306ULL, 0x000fe20000009400ULL, 0x0000010017147824ULL, 0x004fe200078e00ffULL,
0x000000eae900720bULL, 0x002fc80003f1d000ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000001700937306ULL, 0x000e6e0000005400ULL, 0x000000019f9f0812ULL, 0x008fe200078efcffULL,
0x00000017008f7306ULL, 0x0004e6000000d400ULL, 0x0000009f1c1c723eULL, 0x000fca00000010ffULL,
0x0000000d00aa7306ULL, 0x000fe20000209400ULL, 0x0001000017177824ULL, 0x004fe200078e00ffULL,
0x00000093cc00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000000d00a97306ULL, 0x000fee0000205400ULL, 0x000000018f8f3812ULL, 0x008fe200078efcffULL,
0x0000000d00697306ULL, 0x000ff0000020d400ULL, 0x0000007000677306ULL, 0x000ff00000209400ULL,
0x0000007000687306ULL, 0x000ff00000205400ULL, 0x00000070000d7306ULL, 0x0003f0000020d400ULL,
0x0000001500897306ULL, 0x000fe20000009400ULL, 0x0000010015707824ULL, 0x002fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000001500ec7306ULL, 0x000e700000005400ULL,
0x00000015009b7306ULL, 0x0004f0000000d400ULL, 0x0000006f00977306ULL, 0x000f22000020d400ULL,
0x0001000015157824ULL, 0x004fe200078e00ffULL, 0x000000ec8900720bULL, 0x002fc80003fdd000ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001700d97306ULL, 0x000fee0000209400ULL,
0x000000019b9b6812ULL, 0x008fe200078efcffULL, 0x0000001700da7306ULL, 0x000e620000205400ULL,
0x0000000197975812ULL, 0x010fce00078efcffULL, 0x0000001600cf7306ULL, 0x000ff00000009400ULL,
0x0000001600907306ULL, 0x000ea20000005400ULL, 0x000000dad900720bULL, 0x002fce0003fbd000ULL,
0x0000001600967306ULL, 0x0002f0000000d400ULL, 0x0000001500e37306ULL, 0x000fe20000209400ULL,
0x0001000016167824ULL, 0x002fe200078e00ffULL, 0x00000090cf00720bULL, 0x004fc80003f3d000ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000001500e47306ULL, 0x000e6e0000205400ULL,
0x0000000196961812ULL, 0x008fe200078efcffULL, 0x00000015009d7306ULL, 0x0004e2000020d400ULL,
0x000000bf9c00720bULL, 0x000fce0003f3d000ULL, 0x0000003000bc7306ULL, 0x000fe20000009400ULL,
0x0000010030157824ULL, 0x004fe200078e00ffULL, 0x000000e4e300720bULL, 0x002fc80003f5d000ULL,
0x00000018ff6f7819ULL, 0x000fe40000011415ULL, 0x0000003000bd7306ULL, 0x000e620000005400ULL,
0x000000012f2f1812ULL, 0x000fe400078efcffULL, 0x000000b3ba00720bULL, 0x000fc80003f3d000ULL,
0x000000019d9d2812ULL, 0x008fe200078efcffULL, 0x0000003000837306ULL, 0x0004f0000000d400ULL,
0x0000001600d77306ULL, 0x000fe20000209400ULL, 0x0001000030307824ULL, 0x004fe200078e00ffULL,
0x000000bdbc00720bULL, 0x002fc40003f7d000ULL, 0x000000017c7c1812ULL, 0x000fe400078efcffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000001600d87306ULL, 0x000e6e0000205400ULL,
0x0000000183833812ULL, 0x008fe200078efcffULL, 0x0000001600957306ULL, 0x000eb0000020d400ULL,
0x00000017008e7306ULL, 0x000ee2000020d400ULL, 0x000000d8d700720bULL, 0x002fce0003f5d000ULL,
0x0000007000e57306ULL, 0x000fec0000209400ULL, 0x0000000195952812ULL, 0x004fe400078efcffULL,
0x0000007000e67306ULL, 0x000e620000205400ULL, 0x000000018e8e5812ULL, 0x008fc800078efcffULL,
0x0000008e2f2f723eULL, 0x000fc600000010ffULL, 0x0000003000167306ULL, 0x000ff00000209400ULL,
0x0000003000177306ULL, 0x000ea20000205400ULL, 0x000000e6e500720bULL, 0x002fce0003f9d000ULL,
0x00000018008d7306ULL, 0x000ff00000209400ULL, 0x0000001800c07306ULL, 0x000e620000205400ULL,
0x000000171600720bULL, 0x004fce0003fbd000ULL, 0x0000001400d57306ULL, 0x000ff00000209400ULL,
0x0000001400d67306ULL, 0x000fe20000205400ULL, 0x000000c08d00720bULL, 0x002fce0003fdd000ULL,
0x0000001400947306ULL, 0x0003f0000020d400ULL, 0x0000007000ac7306ULL, 0x0004e2000020d400ULL,
0x0000010031147824ULL, 0x002fce00078e00ffULL, 0x0000003000877306ULL, 0x000322000020d400ULL,
0x00000018ff707819ULL, 0x004fce0000011414ULL, 0x0000003300b27306ULL, 0x000fe20000009400ULL,
0x00000001acac4812ULL, 0x008fe200078efcffULL, 0x0000010044307824ULL, 0x002fe200078e00ffULL,
0x000000d6d500720bULL, 0x000fc80003f9d000ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000003300b77306ULL, 0x000e620000005400ULL, 0x0000000187875812ULL, 0x010fc800078efcffULL,
0x000000877c7c723eULL, 0x000fc600000010ffULL, 0x00000018002e7306ULL, 0x0004e2000020d400ULL,
0x0000000194944812ULL, 0x000fce00078efcffULL, 0x0000007000147306ULL, 0x000fe20000209400ULL,
0x000000b7b200720bULL, 0x002fe40003fbd000ULL, 0x00000018ff187819ULL, 0x004fca0000011432ULL,
0x0000007000157306ULL, 0x000e620000205400ULL, 0x000000012e2e6812ULL, 0x008fc800078efcffULL,
0x000000952e2e723eULL, 0x000fc600000010ffULL, 0x0000003300727306ULL, 0x000eb0000000d400ULL,
0x0000004400a57306ULL, 0x000fe20000009400ULL, 0x000000151400720bULL, 0x002fe20003fdd000ULL,
0x0000010039147824ULL, 0x000fca00078e00ffULL, 0x00000018ffba7819ULL, 0x000fe20000011414ULL,
0x00000044001a7306ULL, 0x000e620000005400ULL, 0x0000000172725812ULL, 0x004fe400078efcffULL,
0x0000b8001e147811ULL, 0x000fca00078e20ffULL, 0x0000006f00db7306ULL, 0x000fe20000209400ULL,
0x000000001414783bULL, 0x000eae0000000200ULL, 0x0000006f00dc7306ULL, 0x000ee20000205400ULL,
0x0000001aa500720bULL, 0x002fe40003fbd000ULL, 0x000000a0ab1a723eULL, 0x000fca00000010ffULL,
0x0000001200c37306ULL, 0x000ff00000209400ULL, 0x0000001200c47306ULL, 0x000e620000205400ULL,
0x000000dcdb00720bULL, 0x008fce0003f9d000ULL, 0x0000001200987306ULL, 0x000730000020d400ULL,
0x0000003100bb7306ULL, 0x000fe20000009400ULL, 0x00000018ff127819ULL, 0x008fe40000011431ULL,
0x000000c4c300720bULL, 0x002fe20003f1d000ULL, 0x0000010038c37824ULL, 0x000fc800078e00ffULL,
0x0000003100be7306ULL, 0x000e620000005400ULL, 0x00000018ffc37819ULL, 0x000fce00000114c3ULL,
0x0000003100817306ULL, 0x0007e2000000d400ULL, 0x0000000198980812ULL, 0x010fe400078efcffULL,
0x000000ff7800720cULL, 0x000fca0003f05270ULL, 0x00000044006c7306ULL, 0x0008a2000000d400ULL,
0x0001000031317824ULL, 0x008fe200078e00ffULL, 0x000000bebb00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000006f008a7306ULL, 0x0002e2000020d400ULL,
0x0001000044447824ULL, 0x010fe200078e00ffULL, 0x0000005914148231ULL, 0x084fe400003400ffULL,
0x0000005916168231ULL, 0x000fe400003400ffULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000004e15158231ULL, 0x080fe200003400ffULL, 0x00000070008c7306ULL, 0x000522000020d400ULL,
0x00000100326f7824ULL, 0x002fe200078e00ffULL, 0x000000016c6c5812ULL, 0x000fe200078efcffULL,
0x0000004e17178231ULL, 0x000fe200003400ffULL, 0x0000000181812812ULL, 0x000fc400078efcffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000003200b97306ULL, 0x000fe20000009400ULL,
0x0000010033707824ULL, 0x044fe200078e00ffULL, 0x000000018a8a4812ULL, 0x008fe200078efcffULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x0000002e1454723cULL, 0x000fe40000041854ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000003200b87306ULL, 0x000e620000005400ULL,
0x000000018c8c6812ULL, 0x010fc400078efcffULL, 0x00000018ff337819ULL, 0x000fca0000011433ULL,
0x0000001200b47306ULL, 0x000ff00000209400ULL, 0x0000001200b17306ULL, 0x000ea20000205400ULL,
0x000000b8b900720bULL, 0x002fce0003f7d000ULL, 0x0000003100dd7306ULL, 0x000ff00000209400ULL,
0x0000003100de7306ULL, 0x000e620000205400ULL, 0x000000b1b400720bULL, 0x004fe20003fdd000ULL,
0x000001003ab47824ULL, 0x000fc400078e00ffULL, 0x0001000039b17824ULL, 0x000fc600078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000004400cb7306ULL, 0x000fe20000209400ULL,
0x00000018ffb17819ULL, 0x000fce00000114b1ULL, 0x0000004400ce7306ULL, 0x000ea20000205400ULL,
0x000000dedd00720bULL, 0x002fce0003f9d000ULL, 0x0000003200767306ULL, 0x0002f0000000d400ULL,
0x0000001800b57306ULL, 0x000fe20000209400ULL, 0x0001000032327824ULL, 0x002fe200078e00ffULL,
0x000000cecb00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000001800b67306ULL, 0x000e620000205400ULL, 0x0000000176763812ULL, 0x008fce00078efcffULL,
0x0000001800737306ULL, 0x0005f0000020d400ULL, 0x0000003100827306ULL, 0x000722000020d400ULL,
0x00000018ff187819ULL, 0x004fe40000011446ULL, 0x000000b6b500720bULL, 0x002fe20003f3d000ULL,
0x000001003bb57824ULL, 0x000fc800078e00ffULL, 0x0000001200757306ULL, 0x0002a2000020d400ULL,
0x0000010045317824ULL, 0x008fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fc800000114b5ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000004c00a87306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x002fe40000011445ULL, 0x0000000182824812ULL, 0x010fe400078efcffULL,
0x0000000173731812ULL, 0x000fc600078efcffULL, 0x0000004c00a77306ULL, 0x000e620000205400ULL,
0x0000000175756812ULL, 0x004fce00078efcffULL, 0x0000004c006e7306ULL, 0x000eb0000020d400ULL,
0x0000001800857306ULL, 0x000fe20000209400ULL, 0x000000a7a800720bULL, 0x002fce0003f7d000ULL,
0x0000001800847306ULL, 0x000fec0000205400ULL, 0x000000016e6e3812ULL, 0x004fe400078efcffULL,
0x00000018005a7306ULL, 0x000ff0000020d400ULL, 0x0000004f007d7306ULL, 0x000ff00000209400ULL,
0x0000004f007e7306ULL, 0x000ff00000205400ULL, 0x0000004f004d7306ULL, 0x000ff0000020d400ULL,
0x00000058006a7306ULL, 0x000ff00000209400ULL, 0x00000058006b7306ULL, 0x000ff00000205400ULL,
0x00000058004c7306ULL, 0x000ff0000020d400ULL, 0x00000074004f7306ULL, 0x000ff00000209400ULL,
0x0000007400587306ULL, 0x000ff00000205400ULL, 0x0000007400187306ULL, 0x000ff0000020d400ULL,
0x0000004400747306ULL, 0x000e70000020d400ULL, 0x00000012001d7306ULL, 0x000ff00000209400ULL,
0x00000012009e7306ULL, 0x000ea20000205400ULL, 0x0000000174745812ULL, 0x002fce00078efcffULL,
0x0000006f00df7306ULL, 0x000ff00000209400ULL, 0x0000006f00e07306ULL, 0x000e620000205400ULL,
0x0000009e1d00720bULL, 0x004fe40003fbd000ULL, 0x0000009d981d723eULL, 0x000fca00000010ffULL,
0x0000007000e17306ULL, 0x000fe40000209400ULL, 0x0000001c1460723cULL, 0x000fec0000041860ULL,
0x0000007000e27306ULL, 0x000ea20000205400ULL, 0x000000e0df00720bULL, 0x002fce0003f5d000ULL,
0x0000003200c17306ULL, 0x000ff00000209400ULL, 0x0000003200c27306ULL, 0x000e620000205400ULL,
0x000000e2e100720bULL, 0x004fce0003f9d000ULL, 0x0000003100c97306ULL, 0x000ff00000209400ULL,
0x0000003100ca7306ULL, 0x000fe20000205400ULL, 0x000000c2c100720bULL, 0x002fce0003fdd000ULL,
0x00000031007a7306ULL, 0x0003f0000020d400ULL, 0x0000004500a37306ULL, 0x000fe20000009400ULL,
0x0000010047317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000004500a67306ULL, 0x000e700000005400ULL, 0x00000045006d7306ULL, 0x0005f0000000d400ULL,
0x0000003200807306ULL, 0x000722000020d400ULL, 0x0001000045457824ULL, 0x004fe200078e00ffULL,
0x000000a6a300720bULL, 0x002fcc0003f3d000ULL, 0x0000004600a17306ULL, 0x000fe20000009400ULL,
0x0000010046327824ULL, 0x008fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000004600a47306ULL, 0x000fe20000005400ULL, 0x0000000180806812ULL, 0x010fe400078efcffULL,
0x000000cac900720bULL, 0x000fe40003fdd000ULL, 0x000000016d6d1812ULL, 0x000fc600078efcffULL,
0x0000004600657306ULL, 0x0003f0000000d400ULL, 0x0000003000c77306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x002fe200078e00ffULL, 0x000000017a7a6812ULL, 0x000fc800078efcffULL,
0x0000006d7a6d723eULL, 0x000fe400000010ffULL, 0x0000003000c87306ULL, 0x000ff00000205400ULL,
0x0000003000797306ULL, 0x0003f0000020d400ULL, 0x0000001200667306ULL, 0x000ea2000020d400ULL,
0x00000018ff307819ULL, 0x002fce0000011445ULL, 0x0000006f007f7306ULL, 0x000e70000020d400ULL,
0x00000070007b7306ULL, 0x000ee2000020d400ULL, 0x0000000166665812ULL, 0x004fce00078efcffULL,
0x0000004700a27306ULL, 0x000fe20000009400ULL, 0x000000017f7f2812ULL, 0x002fce00078efcffULL,
0x00000047001b7306ULL, 0x000e620000005400ULL, 0x000000017b7b4812ULL, 0x008fe400078efcffULL,
0x000000c8c700720bULL, 0x000fca0003f9d000ULL, 0x0000003300c57306ULL, 0x000ff00000209400ULL,
0x0000003300c67306ULL, 0x000ea20000205400ULL, 0x0000001ba200720bULL, 0x002fe40003f7d000ULL,
0x0000009bac1b723eULL, 0x000fc400000010ffULL, 0x0000000179794812ULL, 0x000fe400078efcffULL,
0x000000a9aa00720bULL, 0x000fe20003f9d000ULL, 0x0000003100997306ULL, 0x000fe20000209400ULL,
0x0000006c796c723eULL, 0x000fe200000010ffULL, 0x0000001a145c723cULL, 0x000fec000004185cULL,
0x00000031009a7306ULL, 0x000e620000205400ULL, 0x000000c6c500720bULL, 0x004fc40003f5d000ULL,
0x00000096971a723eULL, 0x000fe400000010ffULL, 0x0000008f941b723eULL, 0x000fe400000010ffULL,
0x0000000169694812ULL, 0x000fe200078efcffULL, 0x00000071005b7306ULL, 0x000fe60000209400ULL,
0x000000746974723eULL, 0x000fe200000010ffULL, 0x0000001a1434723cULL, 0x000fe80000041834ULL,
0x0000007100647306ULL, 0x000fe20000205400ULL, 0x0000009a9900720bULL, 0x002fc40003fbd000ULL,
0x000000838a1a723eULL, 0x000fe400000010ffULL, 0x000000818c1b723eULL, 0x000fc600000010ffULL,
0x0000007100127306ULL, 0x000fe8000020d400ULL, 0x0000001a1450723cULL, 0x000fe80000041850ULL,
0x0000003000d17306ULL, 0x000fe60000209400ULL, 0x000000767f1a723eULL, 0x000fc400000010ffULL,
0x000000727b1b723eULL, 0x000fe400000010ffULL, 0x000000807376723eULL, 0x000fe200000010ffULL,
0x0000003000d27306ULL, 0x000e680000205400ULL, 0x0000001a1440723cULL, 0x000fe80000041840ULL,
0x0000003000717306ULL, 0x0004f0000020d400ULL, 0x0000003800cd7306ULL, 0x000fe20000009400ULL,
0x00000018ff307819ULL, 0x004fc40000011446ULL, 0x000000d2d100720bULL, 0x002fca0003fdd000ULL,
0x0000004700467306ULL, 0x0002b0000000d400ULL, 0x0000003800d07306ULL, 0x000f220000005400ULL,
0x0001000047477824ULL, 0x002fe200078e00ffULL, 0x0000000171716812ULL, 0x008fc800078efcffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000003300777306ULL, 0x000e62000020d400ULL,
0x0000000146463812ULL, 0x004fce00078efcffULL, 0x0000003100457306ULL, 0x000ea2000020d400ULL,
0x000000d0cd00720bULL, 0x010fce0003f3d000ULL, 0x0000003800337306ULL, 0x000722000000d400ULL,
0x0000000177772812ULL, 0x002fe400078efcffULL, 0x000000a4a100720bULL, 0x000fe40003f5d000ULL,
0x000000776e77723eULL, 0x000fc600000010ffULL, 0x0000004700907306ULL, 0x000fe20000209400ULL,
0x0001000038387824ULL, 0x008fe200078e00ffULL, 0x0000000145455812ULL, 0x004fe400078efcffULL,
0x0000007e7d00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff1e7819ULL, 0x000fe40000011438ULL,
0x0000004700937306ULL, 0x000e620000205400ULL, 0x0000000133331812ULL, 0x010fe400078efcffULL,
0x0000000165652812ULL, 0x000fc400078efcffULL, 0x00000082757d723eULL, 0x000fe400000010ffULL,
0x000000716675723eULL, 0x000fe200000010ffULL, 0x0000001e00387306ULL, 0x000fe20000209400ULL,
0x000000014d4d5812ULL, 0x000fe400078efcffULL, 0x000000464571723eULL, 0x000fe200000010ffULL,
0x0000007c1448723cULL, 0x000fe80000041848ULL, 0x0000001e00a77306ULL, 0x000ea20000205400ULL,
0x000000939000720bULL, 0x002fc60003f7d000ULL, 0x000000761414723cULL, 0x000fe8000004183cULL,
0x0000004700447306ULL, 0x000e70000020d400ULL, 0x0000003200ad7306ULL, 0x000fe20000209400ULL,
0x000000a73800720bULL, 0x004fce0003f3d000ULL, 0x0000003200ae7306ULL, 0x000ea20000205400ULL,
0x0000000144443812ULL, 0x002fce00078efcffULL, 0x0000003000917306ULL, 0x000ff00000209400ULL,
0x0000003000927306ULL, 0x000e620000205400ULL, 0x000000aead00720bULL, 0x004fce0003fdd000ULL,
0x0000003900af7306ULL, 0x000ff00000009400ULL, 0x0000003900b07306ULL, 0x000ea20000005400ULL,
0x000000929100720bULL, 0x002fce0003f5d000ULL, 0x000000c3008d7306ULL, 0x000ff00000209400ULL,
0x000000c3009c7306ULL, 0x000e620000205400ULL, 0x000000b0af00720bULL, 0x004fce0003f9d000ULL,
0x000000ba00b37306ULL, 0x000ff00000209400ULL, 0x000000ba00b27306ULL, 0x000ea20000205400ULL,
0x0000009c8d00720bULL, 0x002fce0003f7d000ULL, 0x0000003200707306ULL, 0x000e70000020d400ULL,
0x0000003900327306ULL, 0x000ee2000000d400ULL, 0x000000b2b300720bULL, 0x004fce0003fbd000ULL,
0x0000001e00397306ULL, 0x000522000020d400ULL, 0x0000000170706812ULL, 0x002fe400078efcffULL,
0x000000848500720bULL, 0x000fe40003fdd000ULL, 0x000000657070723eULL, 0x000fc600000010ffULL,
0x000000b400967306ULL, 0x000fe20000209400ULL, 0x000000001f1c783bULL, 0x004e620000000200ULL,
0x0000000132324812ULL, 0x008fe400078efcffULL, 0x000000686700720bULL, 0x000fc80003f9d000ULL,
0x000000b4008f7306ULL, 0x000ea20000205400ULL, 0x0000000139391812ULL, 0x010fe400078efcffULL,
0x000000015a5a6812ULL, 0x000fca00078efcffULL, 0x00000030006f7306ULL, 0x000ee2000020d400ULL,
0x000000010d0d4812ULL, 0x000fce00078efcffULL, 0x000000c300787306ULL, 0x000f22000020d400ULL,
0x0000008f9600720bULL, 0x004fce0003f3d000ULL, 0x000000ba00477306ULL, 0x000ea2000020d400ULL,
0x000000016f6f2812ULL, 0x008fc800078efcffULL, 0x0000006f5a5a723eULL, 0x000fc600000010ffULL,
0x0000003a00867306ULL, 0x000fe20000009400ULL, 0x0000000178783812ULL, 0x010fe200078efcffULL,
0x000000591c1c8231ULL, 0x082fe200003400ffULL, 0x0000006b6a00720bULL, 0x000fe20003f7d000ULL,
0x000000591e1e8231ULL, 0x000fe200003400ffULL, 0x000000337846723eULL, 0x000fe200000010ffULL,
0x0000004e1d1d8231ULL, 0x080fe400003400ffULL, 0x0000003a00897306ULL, 0x000e620000005400ULL,
0x0000000147475812ULL, 0x004fe200078efcffULL, 0x0000004e1f1f8231ULL, 0x000fc600003400ffULL,
0x000000324747723eULL, 0x000fc600000010ffULL, 0x0000003a00307306ULL, 0x0004e2000000d400ULL,
0x000000014c4c3812ULL, 0x000fe200078efcffULL, 0x0000006c1c5c723cULL, 0x040fe2000004185cULL,
0x000000645b00720bULL, 0x000fe40003f7d000ULL, 0x000000444d5b723eULL, 0x000fe400000010ffULL,
0x000000394c4c723eULL, 0x000fe200000010ffULL, 0x000000b100a17306ULL, 0x000fe20000209400ULL,
0x000100003a3a7824ULL, 0x004fe200078e00ffULL, 0x000000898600720bULL, 0x002fe20003f5d000ULL,
0x000000741c60723cULL, 0x000fe60000041860ULL, 0x00000018ff3a7819ULL, 0x000fc4000001143aULL,
0x000000b100a07306ULL, 0x000e620000205400ULL, 0x0000000112123812ULL, 0x000fe400078efcffULL,
0x000000701c34723cULL, 0x040fe80000041834ULL, 0x0000000130302812ULL, 0x008fe200078efcffULL,
0x0000003b00887306ULL, 0x000fe60000009400ULL, 0x0000005a1c54723cULL, 0x000fea0000041854ULL,
0x0000003b008b7306ULL, 0x000ea20000005400ULL, 0x000000a0a100720bULL, 0x002fc40003fbd000ULL,
0x000000461c50723cULL, 0x000fea0000041850ULL, 0x0000003b00317306ULL, 0x0002f0000000d400ULL,
0x000000b400837306ULL, 0x000f22000020d400ULL, 0x000100003b3b7824ULL, 0x002fe200078e00ffULL,
0x0000008b8800720bULL, 0x004fc80003fdd000ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003a001a7306ULL, 0x000fee0000209400ULL, 0x0000000131316812ULL, 0x008fe200078efcffULL,
0x0000003a001b7306ULL, 0x000e620000205400ULL, 0x0000000183831812ULL, 0x010fc800078efcffULL,
0x000000308330723eULL, 0x000fc600000010ffULL, 0x000000b100987306ULL, 0x000eb0000020d400ULL,
0x000000b5002e7306ULL, 0x000fe20000209400ULL, 0x0000001b1a00720bULL, 0x002fce0003f3d000ULL,
0x000000b500817306ULL, 0x000e620000205400ULL, 0x0000000198985812ULL, 0x004fe400078efcffULL,
0x000000584f00720bULL, 0x000fe40003fbd000ULL, 0x000000980d4d723eULL, 0x000fc600000010ffULL,
0x0000003b00387306ULL, 0x000fe80000209400ULL, 0x0000004c1c48723cULL, 0x000fe80000041848ULL,
0x0000003b003d7306ULL, 0x000ea20000205400ULL, 0x000000812e00720bULL, 0x002fe40003f9d000ULL,
0x0000000118185812ULL, 0x000fca00078efcffULL, 0x000000b500727306ULL, 0x000e70000020d400ULL,
0x0000003a002f7306ULL, 0x000ee2000020d400ULL, 0x0000003d3800720bULL, 0x004fce0003f5d000ULL,
0x0000003b001b7306ULL, 0x000ea2000020d400ULL, 0x0000000172724812ULL, 0x002fc800078efcffULL,
0x000000317231723eULL, 0x000fe400000010ffULL, 0x000000012f2f1812ULL, 0x008fc800078efcffULL,
0x0000002f121a723eULL, 0x000fe200000010ffULL, 0x000000301c40723cULL, 0x000fe20000041840ULL,
0x000000011b1b2812ULL, 0x004fc800078efcffULL, 0x0000001b181b723eULL, 0x000fce00000010ffULL,
0x0000001a1c14723cULL, 0x000fe20000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff1a7f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000782481bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000782481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d00127305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x000000120000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe4000782481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300040d7a10ULL, 0x000fe20007ffe0ffULL,
0x0000580009187a24ULL, 0x020fc800078e02ffULL, 0x000001000d127824ULL, 0x040fe200078e00ffULL,
0x000000010d0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000004018187824ULL, 0x000fc600078e00ffULL,
0x00000012031b7217ULL, 0x000fe40007800000ULL, 0x000000060d00720cULL, 0x000fe40003f46070ULL,
0x0000002018207210ULL, 0x040fe20007f3e0ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0a12ULL,
0x0000002118217210ULL, 0x040fe40007f9e0ffULL, 0x0000002218227210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x000000201b1b7807ULL, 0x000fc40001000000ULL,
0x00005e00201a7a11ULL, 0x000fe200078640ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e06ffULL,
0x0000002318237210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x0000001b081b7217ULL, 0x000fe40007800000ULL, 0x00005e00211c7a11ULL, 0x000fe200078440ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005f0020207a11ULL, 0x000fe200018f440dULL,
0x000000011b127824ULL, 0x000fe200078e0a08ULL, 0x00005e00221e7a11ULL, 0x000fc400078640ffULL,
0x00000004ff0d7819ULL, 0x000fe40000011602ULL, 0x00005e0023307a11ULL, 0x000fe400078240ffULL,
0x000000131a1a7210ULL, 0x080fe40007f9e0ffULL, 0x00005f0021187a11ULL, 0x000fe400010f4418ULL,
0x000000131c1c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e0620ULL,
0x00005f0022227a11ULL, 0x000fc400018f441dULL, 0x00005f00232e7a11ULL, 0x000fe200008f442eULL,
0x000000ffff1d7224ULL, 0x000fe200028e0618ULL, 0x000000120d00720cULL, 0x080fe40003f46070ULL,
0x000000131e1e7210ULL, 0x000fe40007f7e0ffULL, 0x00000012f500720cULL, 0x080fe40003f26070ULL,
0x000000120e00720cULL, 0x080fe20003f86070ULL, 0x000000ffff1f7224ULL, 0x000fe200018e0622ULL,
0x000000120f00720cULL, 0x000fc40003fa6070ULL, 0x00000013300e7210ULL, 0x000fc60007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a247faeULL, 0x0003e4000d101c46ULL,
0x000000ffff0f7224ULL, 0x000fe400018e062eULL, 0x000000001c257faeULL, 0x0003e8000c901c46ULL,
0x000000001e267faeULL, 0x0003e8000e101c46ULL, 0x000000000e277faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff2e7f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fc40007824811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e002fULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007824811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d000e7305ULL, 0x0022a4000021f000ULL, 0x3fa000000d0d7823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe20003800000ULL, 0x0106b400ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007824811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000019ff0d723eULL, 0x000fe400000010ffULL, 0x00000002ff587819ULL, 0x000fe40000011602ULL,
0x000054100d327816ULL, 0x000fe2000000000dULL, 0x0000bf027f007947ULL, 0x000fea000b800000ULL,
0x00001f58321b7589ULL, 0x0022a400000e0000ULL, 0x0000bf427f007947ULL, 0x000fea000b800000ULL,
0x00001ff632f67589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00fbULL, 0x0001335000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000c5f000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff587224ULL, 0x002fe200078e00faULL, 0x000133b000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000c59000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002820783bULL, 0x000f620000004200ULL, 0x0000b8002d2d7811ULL, 0x000fc600078e20ffULL,
0x000000002924783bULL, 0x000fe80000004200ULL, 0x000000002a10783bULL, 0x000a680000004200ULL,
0x000000002b1c783bULL, 0x000ee20000004200ULL, 0x00000018ff2a7819ULL, 0x020fe20000011422ULL,
0x0000002000b67306ULL, 0x000fe20000009400ULL, 0x00000018ff287819ULL, 0x000fe20000011421ULL,
0x00000100206c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fc40000011420ULL,
0x00000018ff2f7819ULL, 0x004fe40000011423ULL, 0x00000018ff327819ULL, 0x00afe20000011413ULL,
0x0000002a00b27306ULL, 0x000fe20000209400ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff717819ULL, 0x000fe4000001141dULL, 0x00000018ff747819ULL, 0x000fe4000001141fULL,
0x00000018ff737819ULL, 0x000fe2000001141eULL, 0x0000002a00b17306ULL, 0x000ff00000205400ULL,
0x0000002a007d7306ULL, 0x0003f0000020d400ULL, 0x0000002000857306ULL, 0x000ea20000005400ULL,
0x00000018ff2a7819ULL, 0x002fce0000011426ULL, 0x0000002a00a57306ULL, 0x000ff00000209400ULL,
0x0000002a009c7306ULL, 0x000fe20000205400ULL, 0x00000085b600720bULL, 0x004fce0003f5d000ULL,
0x0000002a00667306ULL, 0x0003f0000020d400ULL, 0x0000007100457306ULL, 0x000fe20000209400ULL,
0x00000018ff2a7819ULL, 0x002fce0000011412ULL, 0x0000002a00697306ULL, 0x000ff00000209400ULL,
0x0000002a006a7306ULL, 0x000ff00000205400ULL, 0x0000002a00397306ULL, 0x000ff0000020d400ULL,
0x0000007100467306ULL, 0x000ff00000205400ULL, 0x00000071002a7306ULL, 0x0003f0000020d400ULL,
0x0000002100b57306ULL, 0x000fe20000009400ULL, 0x0000010021717824ULL, 0x002fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000002100727306ULL, 0x000e700000005400ULL,
0x00000021000f7306ULL, 0x0005f0000000d400ULL, 0x00000020000e7306ULL, 0x000762000000d400ULL,
0x0001000021217824ULL, 0x004fe200078e00ffULL, 0x00000072b500720bULL, 0x002fc80003f3d000ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000000d00b77306ULL, 0x000fe20000209400ULL,
0x0001000020207824ULL, 0x008fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002100c17306ULL, 0x000fe20000209400ULL, 0x000000010e0e2812ULL, 0x020fe400078efcffULL,
0x000000010f0f1812ULL, 0x000fca00078efcffULL, 0x0000002100be7306ULL, 0x000e700000205400ULL,
0x0000000d008c7306ULL, 0x000eb00000205400ULL, 0x00000021008e7306ULL, 0x000762000020d400ULL,
0x000000bec100720bULL, 0x002fce0003f5d000ULL, 0x0000002000ba7306ULL, 0x000fe20000209400ULL,
0x0000010024217824ULL, 0x008fe200078e00ffULL, 0x0000008cb700720bULL, 0x004fc80003f7d000ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000bd7306ULL, 0x000e620000205400ULL,
0x000000018e8e2812ULL, 0x020fe400078efcffULL, 0x000000b1b200720bULL, 0x000fca0003f5d000ULL,
0x0000002000957306ULL, 0x0005f0000020d400ULL, 0x0000000d001a7306ULL, 0x000762000020d400ULL,
0x0000010023207824ULL, 0x004fe200078e00ffULL, 0x000000017d7d2812ULL, 0x000fc400078efcffULL,
0x000000bdba00720bULL, 0x002fe40003fbd000ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002200af7306ULL, 0x000fe20000009400ULL, 0x00000018ff0d7819ULL, 0x008fce0000011424ULL,
0x0000002200a67306ULL, 0x000e620000005400ULL, 0x000000011a1a3812ULL, 0x020fe400078efcffULL,
0x0000000195955812ULL, 0x000fc800078efcffULL, 0x000000951a1a723eULL, 0x000fe200000010ffULL,
0x0000002500a87306ULL, 0x000ff00000009400ULL, 0x0000002500ab7306ULL, 0x000ea20000005400ULL,
0x000000a6af00720bULL, 0x002fce0003f7d000ULL, 0x0000002300917306ULL, 0x000ff00000009400ULL,
0x0000002300ae7306ULL, 0x000e620000005400ULL, 0x000000aba800720bULL, 0x004fe20003f5d000ULL,
0x000100001dab7824ULL, 0x000fca00078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000002300807306ULL, 0x0004f0000000d400ULL, 0x0000002100ce7306ULL, 0x000fe20000209400ULL,
0x0001000023237824ULL, 0x004fe200078e00ffULL, 0x000000ae9100720bULL, 0x002fe20003f3d000ULL,
0x000001001fae7824ULL, 0x000fc600078e00ffULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000002100d17306ULL, 0x000fe20000205400ULL, 0x00000018ffae7819ULL, 0x000fcc00000114aeULL,
0x0000000180801812ULL, 0x008fe200078efcffULL, 0x00000021007b7306ULL, 0x0003f0000020d400ULL,
0x0000002000c27306ULL, 0x000fe20000209400ULL, 0x0000010026217824ULL, 0x002fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000c57306ULL, 0x000ff00000205400ULL,
0x0000002000837306ULL, 0x0003f0000020d400ULL, 0x0000000d00ac7306ULL, 0x000fe20000209400ULL,
0x0000010025207824ULL, 0x002fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000000d00ad7306ULL, 0x000ff00000205400ULL, 0x0000000d006d7306ULL, 0x0003f0000020d400ULL,
0x0000002200867306ULL, 0x000ea2000000d400ULL, 0x00000018ff0d7819ULL, 0x002fce0000011410ULL,
0x00000025006e7306ULL, 0x000e70000000d400ULL, 0x0000002300c87306ULL, 0x000fe20000209400ULL,
0x0000000186863812ULL, 0x004fce00078efcffULL, 0x0000002300cb7306ULL, 0x000ea20000205400ULL,
0x000000016e6e2812ULL, 0x002fce00078efcffULL, 0x0000002f00b37306ULL, 0x000ff00000209400ULL,
0x0000002f00b07306ULL, 0x000fe20000205400ULL, 0x000000cbc800720bULL, 0x004fce0003f7d000ULL,
0x0000002f00757306ULL, 0x0003f0000020d400ULL, 0x0000002100cf7306ULL, 0x000fe20000209400ULL,
0x00000018ff2f7819ULL, 0x002fce0000011427ULL, 0x0000002100cc7306ULL, 0x000e700000205400ULL,
0x0000000d00877306ULL, 0x000ff00000209400ULL, 0x0000000d00887306ULL, 0x000fe20000205400ULL,
0x000000cccf00720bULL, 0x002fce0003f5d000ULL, 0x0000000d004f7306ULL, 0x0003f0000020d400ULL,
0x0000002000d37306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x002fce000001141cULL,
0x0000002000d07306ULL, 0x000ff00000205400ULL, 0x0000002000797306ULL, 0x0003f0000020d400ULL,
0x00000027009d7306ULL, 0x000fe20000009400ULL, 0x0000010027207824ULL, 0x002fce00078e00ffULL,
0x00000027009a7306ULL, 0x000ff00000005400ULL, 0x0000002700657306ULL, 0x0003f0000000d400ULL,
0x0000002f00a27306ULL, 0x000fe20000209400ULL, 0x0001000027277824ULL, 0x002fce00078e00ffULL,
0x0000002f00a37306ULL, 0x000ff00000205400ULL, 0x0000002f00597306ULL, 0x000ff0000020d400ULL,
0x0000003200647306ULL, 0x000ff00000209400ULL, 0x0000003200677306ULL, 0x000ff00000205400ULL,
0x0000003200317306ULL, 0x000ff0000020d400ULL, 0x0000000d004d7306ULL, 0x000ff00000209400ULL,
0x0000000d004e7306ULL, 0x000ff00000205400ULL, 0x0000000d002f7306ULL, 0x000ff0000020d400ULL,
0x0000007400327306ULL, 0x000ff00000209400ULL, 0x0000007400337306ULL, 0x000ff00000205400ULL,
0x00000074000d7306ULL, 0x000ff0000020d400ULL, 0x0000002100747306ULL, 0x0002b0000020d400ULL,
0x0000006c00b87306ULL, 0x000fe20000209400ULL, 0x00000018ff217819ULL, 0x002fce0000011427ULL,
0x0000006c00bb7306ULL, 0x000e620000205400ULL, 0x0000000174742812ULL, 0x004fce00078efcffULL,
0x00000023007c7306ULL, 0x0004f0000020d400ULL, 0x00000026003e7306ULL, 0x000fe20000009400ULL,
0x0000010010237824ULL, 0x004fe200078e00ffULL, 0x000000bbb800720bULL, 0x002fc80003fdd000ULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x00000026003d7306ULL, 0x000e620000005400ULL,
0x000000017c7c3812ULL, 0x008fce00078efcffULL, 0x0000006c009f7306ULL, 0x0004f0000020d400ULL,
0x0000007100bf7306ULL, 0x000fe20000209400ULL, 0x00000100226c7824ULL, 0x004fe200078e00ffULL,
0x0000003d3e00720bULL, 0x002fe20003f7d000ULL, 0x0001000022227824ULL, 0x000fc600078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000007100bc7306ULL, 0x000e620000205400ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x000000019f9f6812ULL, 0x008fc800078efcffULL,
0x0000000e9f0e723eULL, 0x000fe200000010ffULL, 0x0000002100d57306ULL, 0x000ff00000209400ULL,
0x0000002100d27306ULL, 0x000ea20000205400ULL, 0x000000bcbf00720bULL, 0x002fce0003f9d000ULL,
0x00000026006b7306ULL, 0x0002f0000000d400ULL, 0x0000002800b97306ULL, 0x000fe20000209400ULL,
0x0001000026267824ULL, 0x002fe200078e00ffULL, 0x000000d2d500720bULL, 0x004fcc0003f5d000ULL,
0x0000002800b47306ULL, 0x000e620000205400ULL, 0x000000016b6b3812ULL, 0x008fe400078efcffULL,
0x000000a3a200720bULL, 0x000fe40003f7d000ULL, 0x0000006b7474723eULL, 0x000fc600000010ffULL,
0x0000002200c47306ULL, 0x000ff00000209400ULL, 0x0000002200c77306ULL, 0x000fe20000205400ULL,
0x000000b4b900720bULL, 0x002fe40003fdd000ULL, 0x0000000159593812ULL, 0x000fca00078efcffULL,
0x0000002200847306ULL, 0x0003f0000020d400ULL, 0x00000071009e7306ULL, 0x000ea2000020d400ULL,
0x00000018ff227819ULL, 0x002fe40000011420ULL, 0x00000018ff207819ULL, 0x000fca0000011426ULL,
0x0000002100267306ULL, 0x000e70000020d400ULL, 0x0000002300d77306ULL, 0x000fe20000209400ULL,
0x000000019e9e4812ULL, 0x004fe400078efcffULL, 0x000000c5c200720bULL, 0x000fc40003f9d000ULL,
0x0000000f9e0f723eULL, 0x000fc600000010ffULL, 0x0000002300d47306ULL, 0x000ea20000205400ULL,
0x0000000126262812ULL, 0x002fce00078efcffULL, 0x0000002400a97306ULL, 0x000fe20000009400ULL,
0x0000000183834812ULL, 0x000fe400078efcffULL, 0x000000d1ce00720bULL, 0x000fca0003f9d000ULL,
0x0000002400aa7306ULL, 0x000e620000005400ULL, 0x000000d4d700720bULL, 0x004fce0003f5d000ULL,
0x0000002400787306ULL, 0x0004e2000000d400ULL, 0x000000017b7b4812ULL, 0x000fce00078efcffULL,
0x0000006c00c37306ULL, 0x000fe20000209400ULL, 0x0001000024247824ULL, 0x004fe200078e00ffULL,
0x000000aaa900720bULL, 0x002fc80003f3d000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000006c00c07306ULL, 0x000e6e0000205400ULL, 0x0000000178781812ULL, 0x008fe200078efcffULL,
0x0000006c008d7306ULL, 0x000ea6000020d400ULL, 0x000000787b78723eULL, 0x000fca00000010ffULL,
0x0000002000cd7306ULL, 0x000fe20000209400ULL, 0x000000c0c300720bULL, 0x002fce0003fbd000ULL,
0x0000002000ca7306ULL, 0x000fec0000205400ULL, 0x000000018d8d5812ULL, 0x004fe400078efcffULL,
0x0000002000717306ULL, 0x0003e2000020d400ULL, 0x000000b0b300720bULL, 0x000fe40003fbd000ULL,
0x000000868d86723eULL, 0x000fca00000010ffULL, 0x0000001000a07306ULL, 0x000fe20000009400ULL,
0x0000010012207824ULL, 0x002fca00078e00ffULL, 0x00000018ffde7819ULL, 0x000fe20000011420ULL,
0x0000010013207824ULL, 0x000fe200078e00ffULL, 0x0000001000a17306ULL, 0x000fe20000005400ULL,
0x0000000175755812ULL, 0x000fe400078efcffULL, 0x000000adac00720bULL, 0x000fe20003fbd000ULL,
0x000001001eac7824ULL, 0x040fe400078e00ffULL, 0x000100001ead7824ULL, 0x000fe400078e00ffULL,
0x00000010005a7306ULL, 0x0003e2000000d400ULL, 0x00000018ffac7819ULL, 0x000fc400000114acULL,
0x00000018ffad7819ULL, 0x000fca00000114adULL, 0x0000002200c67306ULL, 0x000fe20000209400ULL,
0x0001000010107824ULL, 0x002fe200078e00ffULL, 0x000000016d6d5812ULL, 0x000fe400078efcffULL,
0x0000009a9d00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000002200c97306ULL, 0x000ff00000205400ULL, 0x00000022006c7306ULL, 0x0003e2000020d400ULL,
0x0000000165655812ULL, 0x000fce00078efcffULL, 0x00000028008b7306ULL, 0x0004e2000020d400ULL,
0x0000010011227824ULL, 0x002fca00078e00ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000002400d67306ULL, 0x000fe20000209400ULL, 0x00000018ff287819ULL, 0x004fe20000011425ULL,
0x0001000025257824ULL, 0x000fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000002400d97306ULL, 0x000e620000205400ULL, 0x000000018b8b6812ULL, 0x008fe400078efcffULL,
0x000000c7c400720bULL, 0x000fca0003fdd000ULL, 0x00000024007a7306ULL, 0x000ff0000020d400ULL,
0x0000002300277306ULL, 0x000ea2000020d400ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x000000d0d300720bULL, 0x000fc40003fdd000ULL, 0x000000d9d600720bULL, 0x002fc60003f9d000ULL,
0x0000002200dc7306ULL, 0x000ff00000209400ULL, 0x0000002200df7306ULL, 0x000e620000205400ULL,
0x0000000127272812ULL, 0x004fe400078efcffULL, 0x0000000179796812ULL, 0x000fc400078efcffULL,
0x000000017a7a4812ULL, 0x000fe400078efcffULL, 0x000000c9c600720bULL, 0x000fe20003f9d000ULL,
0x0000001000dd7306ULL, 0x000fe20000209400ULL, 0x0000006e7979723eULL, 0x000fe400000010ffULL,
0x0000007a6d7a723eULL, 0x000fca00000010ffULL, 0x0000001000da7306ULL, 0x000ea20000205400ULL,
0x000000dfdc00720bULL, 0x002fc60003f7d000ULL, 0x000000016c6c4812ULL, 0x000fe400078efcffULL,
0x000000a1a000720bULL, 0x000fe40003f9d000ULL, 0x0000001000247306ULL, 0x0002f0000020d400ULL,
0x00000028003f7306ULL, 0x000fe20000209400ULL, 0x00000018ff107819ULL, 0x002fc40000011420ULL,
0x000000dadd00720bULL, 0x004fe40003f5d000ULL, 0x000000015a5a4812ULL, 0x000fe400078efcffULL,
0x000000888700720bULL, 0x000fe20003f9d000ULL, 0x00000028003c7306ULL, 0x000e620000205400ULL,
0x000000808387723eULL, 0x000fe400000010ffULL, 0x0000005a275a723eULL, 0x000fca00000010ffULL,
0x0000002800687306ULL, 0x000562000020d400ULL, 0x0000000124242812ULL, 0x008fc600078efcffULL,
0x000000014f4f4812ULL, 0x000fc800078efcffULL, 0x00000011009b7306ULL, 0x000fe20000009400ULL,
0x00000018ff287819ULL, 0x004fe40000011411ULL, 0x0000003c3f00720bULL, 0x002fe40003f3d000ULL,
0x000000002d3c783bULL, 0x000e620000000200ULL, 0x000000244f24723eULL, 0x000fe400000010ffULL,
0x0000001100947306ULL, 0x000eb00000005400ULL, 0x00000011004c7306ULL, 0x000722000000d400ULL,
0x0000000168681812ULL, 0x020fc400078efcffULL, 0x0000009ca500720bULL, 0x000fca0003f3d000ULL,
0x0000001000897306ULL, 0x000fe20000209400ULL, 0x0001000011117824ULL, 0x008fe200078e00ffULL,
0x000000949b00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000010008a7306ULL, 0x000fe20000205400ULL, 0x0000000166661812ULL, 0x000fcc00078efcffULL,
0x000000014c4c5812ULL, 0x010fe200078efcffULL, 0x0000001000217306ULL, 0x0005e2000020d400ULL,
0x0000001b3c3c8231ULL, 0x082fe400003400ffULL, 0x0000001b3e3e8231ULL, 0x000fca00003400ffULL,
0x0000001200997306ULL, 0x000fe20000009400ULL, 0x000001001c107824ULL, 0x004fe200078e00ffULL,
0x000000f63d3d8231ULL, 0x080fe400003400ffULL, 0x000000f63f3f8231ULL, 0x000fe400003400ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001200967306ULL, 0x000ff00000005400ULL,
0x0000001200477306ULL, 0x0003f0000000d400ULL, 0x0000001300977306ULL, 0x000fe20000009400ULL,
0x0001000012127824ULL, 0x002fca00078e00ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x0000001300987306ULL, 0x000e700000005400ULL, 0x0000001300387306ULL, 0x0004f0000000d400ULL,
0x00000028007e7306ULL, 0x000fe20000209400ULL, 0x0001000013137824ULL, 0x004fe200078e00ffULL,
0x000000989700720bULL, 0x002fc80003f3d000ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x00000028007f7306ULL, 0x000e6e0000205400ULL, 0x0000000138381812ULL, 0x008fe200078efcffULL,
0x0000002800447306ULL, 0x000ea2000020d400ULL, 0x000000676400720bULL, 0x000fc40003f3d000ULL,
0x000000265967723eULL, 0x000fca00000010ffULL, 0x00000073003a7306ULL, 0x000fe20000209400ULL,
0x0000007f7e00720bULL, 0x002fca0003fbd000ULL, 0x0000000131311812ULL, 0x000fe400078efcffULL,
0x00000073003b7306ULL, 0x000fe20000205400ULL, 0x0000004e4d00720bULL, 0x000fca0003f3d000ULL,
0x0000000144445812ULL, 0x004fe400078efcffULL, 0x0000007300287306ULL, 0x000fec000020d400ULL,
0x000000012f2f1812ULL, 0x000fe400078efcffULL, 0x0000002500d87306ULL, 0x000fe20000209400ULL,
0x000000333200720bULL, 0x000fce0003f3d000ULL, 0x0000002500db7306ULL, 0x000e6c0000205400ULL,
0x000000010d0d1812ULL, 0x000fe400078efcffULL, 0x0000002500737306ULL, 0x000eb0000020d400ULL,
0x0000002200257306ULL, 0x000ee2000020d400ULL, 0x000000dbd800720bULL, 0x002fce0003fdd000ULL,
0x0000001100a77306ULL, 0x000fec0000209400ULL, 0x0000000173736812ULL, 0x004fe400078efcffULL,
0x0000001100a47306ULL, 0x000e620000205400ULL, 0x0000000125253812ULL, 0x008fe400078efcffULL,
0x000000cacd00720bULL, 0x000fc40003fdd000ULL, 0x00000073687b723eULL, 0x000fc600000010ffULL,
0x0000001100237306ULL, 0x0004f0000020d400ULL, 0x000000de008f7306ULL, 0x000fe20000209400ULL,
0x000001001d117824ULL, 0x004fe200078e00ffULL, 0x000000a4a700720bULL, 0x002fc40003f7d000ULL,
0x0000000171716812ULL, 0x000fe400078efcffULL, 0x00000018ffaa7819ULL, 0x000fe40000011411ULL,
0x000000de00907306ULL, 0x000e620000205400ULL, 0x000000969900720bULL, 0x000fe40003fdd000ULL,
0x000000716666723eULL, 0x000fc800000010ffULL, 0x0000000123233812ULL, 0x008fe200078efcffULL,
0x0000001000a67306ULL, 0x000fe20000209400ULL, 0x0000008a8900720bULL, 0x000fca0003f7d000ULL,
0x0000000147476812ULL, 0x000fe400078efcffULL, 0x0000001000af7306ULL, 0x000fe20000205400ULL,
0x000000908f00720bULL, 0x002fe40003f5d000ULL, 0x0000006a6900720bULL, 0x000fc60003fdd000ULL,
0x0000000121213812ULL, 0x000fe400078efcffULL, 0x0000001000917306ULL, 0x0003f0000020d400ULL,
0x0000001200817306ULL, 0x000fe20000209400ULL, 0x0000b8002c107811ULL, 0x002fe200078e20ffULL,
0x000100001c2c7824ULL, 0x000fe200078e00ffULL, 0x0000000139396812ULL, 0x000fc800078efcffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000001200827306ULL, 0x000ff00000205400ULL,
0x0000001200207306ULL, 0x000ff0000020d400ULL, 0x0000001300857306ULL, 0x000ff00000209400ULL,
0x00000013008c7306ULL, 0x000e700000205400ULL, 0x0000001300727306ULL, 0x0004f0000020d400ULL,
0x000000de00227306ULL, 0x000f22000020d400ULL, 0x000000001010783bULL, 0x004ea20000000200ULL,
0x0000008c8500720bULL, 0x002fcc0003f7d000ULL, 0x0000001d00767306ULL, 0x000fee0000009400ULL,
0x0000000172723812ULL, 0x008fe200078efcffULL, 0x0000001d00777306ULL, 0x000e620000005400ULL,
0x0000000122222812ULL, 0x010fe400078efcffULL, 0x000000828100720bULL, 0x000fc40003f5d000ULL,
0x000000472222723eULL, 0x000fc600000010ffULL, 0x0000001d002b7306ULL, 0x000ef0000000d400ULL,
0x000000aa00a87306ULL, 0x000fe20000209400ULL, 0x0000000120202812ULL, 0x000fe400078efcffULL,
0x000000afa600720bULL, 0x000fc40003f5d000ULL, 0x000000777600720bULL, 0x002fe40003f9d000ULL,
0x000000203920723eULL, 0x000fe200000010ffULL, 0x000000aa00a97306ULL, 0x000e620000205400ULL,
0x0000001b10108231ULL, 0x084fe400003400ffULL, 0x0000001b12128231ULL, 0x000fe200003400ffULL,
0x0000008e8b1b723eULL, 0x000fe200000010ffULL, 0x000000f611118231ULL, 0x080fe400003400ffULL,
0x000000f613138231ULL, 0x000fe200003400ffULL, 0x0000001c00927306ULL, 0x000fe20000009400ULL,
0x0000000191912812ULL, 0x000fc400078efcffULL, 0x000000012b2b4812ULL, 0x008fe400078efcffULL,
0x0000003b3a00720bULL, 0x000fe20003f9d000ULL, 0x0000001a1060723cULL, 0x000fe40000041860ULL,
0x0000001c00937306ULL, 0x000ea20000005400ULL, 0x000000a9a800720bULL, 0x002fca0003f7d000ULL,
0x0000000e105c723cULL, 0x000fe4000004185cULL, 0x0000002c001d7306ULL, 0x000fe40000209400ULL,
0x0000000128284812ULL, 0x000fc600078efcffULL, 0x0000007c750f723eULL, 0x000fe200000010ffULL,
0x000000861034723cULL, 0x000fe20000041834ULL, 0x000000847d0e723eULL, 0x000fe200000010ffULL,
0x0000002c009a7306ULL, 0x000e620000205400ULL, 0x000000939200720bULL, 0x004fe40003f1d000ULL,
0x000000656c75723eULL, 0x000fc600000010ffULL, 0x0000000e1054723cULL, 0x040fe40000041854ULL,
0x0000001c00307306ULL, 0x000eac000000d400ULL, 0x000000781050723cULL, 0x000fe40000041850ULL,
0x0000001e006f7306ULL, 0x000fe20000009400ULL, 0x0000009a1d00720bULL, 0x002fca0003f5d000ULL,
0x0000007a1048723cULL, 0x040fe40000041848ULL, 0x0000001e00707306ULL, 0x000e620000005400ULL,
0x0000000130300812ULL, 0x004fe400078efcffULL, 0x000000464500720bULL, 0x000fe40003f1d000ULL,
0x000000309130723eULL, 0x000fe200000010ffULL, 0x000000741040723cULL, 0x040fe40000041840ULL,
0x0000001e00297306ULL, 0x000eac000000d400ULL, 0x000000661014723cULL, 0x000fe40000041814ULL,
0x000000aa001c7306ULL, 0x000ee2000020d400ULL, 0x000000706f00720bULL, 0x002fc40003fbd000ULL,
0x000000012a2a0812ULL, 0x000fca00078efcffULL, 0x0000002c001e7306ULL, 0x000e6c000020d400ULL,
0x0000000129295812ULL, 0x004fe400078efcffULL, 0x000000ab00947306ULL, 0x000fe20000209400ULL,
0x000000011c1c3812ULL, 0x008fce00078efcffULL, 0x000000ab00977306ULL, 0x000ea20000205400ULL,
0x000000011e1e2812ULL, 0x002fc800078efcffULL, 0x0000001e2f1e723eULL, 0x000fc600000010ffULL,
0x000000ac002c7306ULL, 0x000ff00000209400ULL, 0x000000ac001b7306ULL, 0x000e620000205400ULL,
0x000000979400720bULL, 0x004fce0003f7d000ULL, 0x0000001f00587306ULL, 0x000ff00000009400ULL,
0x0000001f005b7306ULL, 0x000ea20000005400ULL, 0x0000001b2c00720bULL, 0x002fce0003f5d000ULL,
0x0000001f00187306ULL, 0x0002f0000000d400ULL, 0x000000ab002d7306ULL, 0x000f22000020d400ULL,
0x000100001f1f7824ULL, 0x002fe200078e00ffULL, 0x0000005b5800720bULL, 0x004fc40003fdd000ULL,
0x0000004c255b723eULL, 0x000fe400000010ffULL, 0x00000018ff107819ULL, 0x000fe4000001141fULL,
0x000000ac001a7306ULL, 0x000e62000020d400ULL, 0x000000234425723eULL, 0x000fe400000010ffULL,
0x000000382123723eULL, 0x000fe200000010ffULL, 0x0000005a3c5c723cULL, 0x000fe2000004185cULL,
0x000000723121723eULL, 0x000fe400000010ffULL, 0x0000000118186812ULL, 0x008fe200078efcffULL,
0x000000ae006e7306ULL, 0x000fe20000209400ULL, 0x000000012d2d3812ULL, 0x010fc400078efcffULL,
0x0000002b1c31723eULL, 0x000fe200000010ffULL, 0x000000243c60723cULL, 0x000fe20000041860ULL,
0x0000002d2a1f723eULL, 0x000fc600000010ffULL, 0x000000ae00697306ULL, 0x000ea20000205400ULL,
0x000000011a1a2812ULL, 0x002fc600078efcffULL, 0x000000223c34723cULL, 0x000fe20000041834ULL,
0x000000291a1a723eULL, 0x000fc600000010ffULL, 0x000000ad000e7306ULL, 0x000fe80000209400ULL,
0x000000203c54723cULL, 0x000fe80000041854ULL, 0x000000ad000f7306ULL, 0x000e620000205400ULL,
0x000000696e00720bULL, 0x004fc60003f7d000ULL, 0x000000303c50723cULL, 0x040fe80000041850ULL,
0x0000001000117306ULL, 0x000fe80000209400ULL, 0x0000001e3c48723cULL, 0x000fe80000041848ULL,
0x0000001000127306ULL, 0x000ea20000205400ULL, 0x0000000f0e00720bULL, 0x002fce0003f1d000ULL,
0x000000ae00657306ULL, 0x000e70000020d400ULL, 0x000000ad00ad7306ULL, 0x000ee2000020d400ULL,
0x000000121100720bULL, 0x004fce0003f5d000ULL, 0x0000001000107306ULL, 0x000ea2000020d400ULL,
0x0000000165653812ULL, 0x002fc800078efcffULL, 0x00000018651b723eULL, 0x000fe400000010ffULL,
0x00000001adad0812ULL, 0x008fc800078efcffULL, 0x000000ad2828723eULL, 0x000fe200000010ffULL,
0x0000001a3c40723cULL, 0x000fe20000041840ULL, 0x0000000110102812ULL, 0x004fc800078efcffULL,
0x000000100d29723eULL, 0x000fce00000010ffULL, 0x000000283c3c723cULL, 0x000fe20000041814ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff317224ULL, 0x002fc600078e000fULL,
0x0000030004047a10ULL, 0x000fc80007ffe0ffULL, 0x000000060400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffebcc000007947ULL, 0x000fea000383ffffULL,
0x0000000000127919ULL, 0x002e640000002500ULL, 0x000000061200720cULL, 0x002fda0003f06070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000000b027810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff337224ULL, 0x000fe200078e000bULL, 0x00015290001a7802ULL, 0x000fe40000000f00ULL,
0x0000a50000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00047308ULL, 0x000e640000001000ULL,
0xbf80000004027423ULL, 0x002fc8000000000bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000077919ULL, 0x000f640000000000ULL,
0x00000002ff057819ULL, 0x020fe40000011607ULL, 0x0000000807077811ULL, 0x000fe200078ff0ffULL,
0x0000000403047220ULL, 0x010fca0000410000ULL, 0x00001f0504057589ULL, 0x000f2800000e0000ULL,
0x00001f0704077589ULL, 0x000f6200000e0000ULL, 0x0000005c055c7220ULL, 0x050fe40000410000ULL,
0x0000005d055d7220ULL, 0x040fe40000410000ULL, 0x0000006005607220ULL, 0x040fe40000410000ULL,
0x0000006105617220ULL, 0x000fc40000410000ULL, 0x0000003405347220ULL, 0x040fe40000410000ULL,
0x0000003505357220ULL, 0x040fe40000410000ULL, 0x0000005405547220ULL, 0x040fe40000410000ULL,
0x0000005505557220ULL, 0x040fe40000410000ULL, 0x0000005005507220ULL, 0x040fe40000410000ULL,
0x0000005105517220ULL, 0x000fc40000410000ULL, 0x0000004805487220ULL, 0x040fe40000410000ULL,
0x0000004905497220ULL, 0x040fe40000410000ULL, 0x0000004005407220ULL, 0x040fe40000410000ULL,
0x0000004105417220ULL, 0x040fe40000410000ULL, 0x0000003c053c7220ULL, 0x040fe40000410000ULL,
0x0000003d053d7220ULL, 0x000fc40000410000ULL, 0x0000005e075e7220ULL, 0x060fe40000410000ULL,
0x0000005f075f7220ULL, 0x040fe40000410000ULL, 0x0000006207627220ULL, 0x040fe40000410000ULL,
0x0000006307637220ULL, 0x040fe40000410000ULL, 0x0000003607367220ULL, 0x040fe40000410000ULL,
0x0000003707377220ULL, 0x000fc40000410000ULL, 0x0000005607567220ULL, 0x040fe40000410000ULL,
0x0000005707577220ULL, 0x040fe40000410000ULL, 0x0000005207527220ULL, 0x040fe40000410000ULL,
0x0000005307537220ULL, 0x040fe40000410000ULL, 0x0000004a074a7220ULL, 0x040fe40000410000ULL,
0x0000004b074b7220ULL, 0x000fc40000410000ULL, 0x0000004207427220ULL, 0x040fe40000410000ULL,
0x0000004307437220ULL, 0x040fe40000410000ULL, 0x0000003e073e7220ULL, 0x040fe40000410000ULL,
0x0000003f073f7220ULL, 0x000fe40000410000ULL, 0x0000000000037919ULL, 0x000f220000000000ULL,
0x00000300ff207624ULL, 0x000fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x000000012000780cULL, 0x000fe40003f05270ULL, 0x0000000203027812ULL, 0x010fe400078ec0ffULL,
0x00000002ff117819ULL, 0x000fe40000011603ULL, 0x00000001ff047819ULL, 0x000fe40000011602ULL,
0x0000000202057811ULL, 0x000fc400078ff8ffULL, 0x0000000402097811ULL, 0x040fe400078ff8ffULL,
0x00000006020e7811ULL, 0x008fe400078ff8ffULL, 0x0000000803197811ULL, 0x000fe400078ff0ffULL,
0x0000000704027812ULL, 0x140fe400078e7811ULL, 0x00000007090c7812ULL, 0x040fe400078e7811ULL,
0x0000000709097812ULL, 0x100fe200078e7819ULL, 0x0000000811077824ULL, 0x000fe200078e0202ULL,
0x0000000704047812ULL, 0x000fe200078e7819ULL, 0x0000080000027824ULL, 0x000fe200078e00ffULL,
0x0000000705067812ULL, 0x000fe200078e7811ULL, 0x0000000819177824ULL, 0x000fe200078e0209ULL,
0x0000000705057812ULL, 0x000fe200078e7819ULL, 0x0000000819137824ULL, 0x000fe200078e0204ULL,
0x0000a00002047810ULL, 0x000fe20007ffe0ffULL, 0x0000000803097824ULL, 0x000fe200078e00ffULL,
0x000000070e107812ULL, 0x040fe200078e7811ULL, 0x00000008110f7824ULL, 0x040fe200078e020cULL,
0x000000070e0e7812ULL, 0x000fe200078e7819ULL, 0x00000008110d7824ULL, 0x000fe200078e0206ULL,
0x00000008090c7812ULL, 0x000fe200078ec0ffULL, 0x0000000819157824ULL, 0x000fe200078e0205ULL,
0x0000005c5d05723eULL, 0x000fe200000010ffULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x000000606106723eULL, 0x000fe200000010ffULL, 0x000000100f097824ULL, 0x000fc400078e0204ULL,
0x0000000819197824ULL, 0x000fe200078e020eULL, 0x00005410051a7816ULL, 0x000fe20000000006ULL,
0x0000000811117824ULL, 0x000fe200078e0210ULL, 0x00007632051b7816ULL, 0x000fe20000000006ULL,
0x00000001070e7824ULL, 0x000fe200078e020cULL, 0x000000343507723eULL, 0x000fe200000010ffULL,
0x000000010c107824ULL, 0x040fe200078e0209ULL, 0x000000545509723eULL, 0x000fe200000010ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0204ULL, 0x0000001a0e007388ULL, 0x0007e20000000a00ULL,
0x000000505105723eULL, 0x000fe200000010ffULL, 0x0000001011117824ULL, 0x100fe200078e0204ULL,
0x000000484906723eULL, 0x000fe200000010ffULL, 0x000000010c0f7824ULL, 0x000fe200078e020dULL,
0x00000062630d723eULL, 0x000fe200000010ffULL, 0x0000001013137824ULL, 0x000fc400078e0204ULL,
0x0000001015157824ULL, 0x100fe400078e0204ULL, 0x0000001017177824ULL, 0x100fe200078e0204ULL,
0x00005410071a7816ULL, 0x108fe20000000009ULL, 0x0000001019197824ULL, 0x000fe200078e0204ULL,
0x00007632071b7816ULL, 0x000fe20000000009ULL, 0x000000010c117824ULL, 0x040fe200078e0211ULL,
0x00005410050e7816ULL, 0x000fe20000000006ULL, 0x000000010c137824ULL, 0x040fe200078e0213ULL,
0x000000404107723eULL, 0x000fe200000010ffULL, 0x0000001a0f007388ULL, 0x0007e20000000a00ULL,
0x0000003c3d09723eULL, 0x000fe200000010ffULL, 0x000000010c157824ULL, 0x000fc400078e0215ULL,
0x000000010c177824ULL, 0x040fe400078e0217ULL, 0x000000010c197824ULL, 0x000fe200078e0219ULL,
0x0000005e5f0c723eULL, 0x000fe400000010ffULL, 0x00007632050f7816ULL, 0x008fe40000000006ULL,
0x000000363705723eULL, 0x000fe400000010ffULL, 0x000000565706723eULL, 0x000fe200000010ffULL,
0x0000000e10007388ULL, 0x0007e40000000a00ULL, 0x00005410070e7816ULL, 0x008fc40000000009ULL,
0x00007632070f7816ULL, 0x000fe40000000009ULL, 0x000000525307723eULL, 0x000fe400000010ffULL,
0x0000004a4b09723eULL, 0x000fe200000010ffULL, 0x0000000e11007388ULL, 0x0007e40000000a00ULL,
0x000054100c0e7816ULL, 0x148fe4000000000dULL, 0x000076320c0f7816ULL, 0x000fe4000000000dULL,
0x00000042430c723eULL, 0x000fc400000010ffULL, 0x0000003e3f0d723eULL, 0x000fe200000010ffULL,
0x0000000e13007388ULL, 0x0007e40000000a00ULL, 0x00005410050e7816ULL, 0x148fe40000000006ULL,
0x00007632050f7816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000009ULL,
0x0000763207077816ULL, 0x000fe20000000009ULL, 0x0000000e15007388ULL, 0x0007e80000000a00ULL,
0x0000000617007388ULL, 0x0009e20000000a00ULL, 0x000054100c0e7816ULL, 0x008fc4000000000dULL,
0x000076320c0f7816ULL, 0x000fca000000000dULL, 0x0000000e19007388ULL, 0x0009e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b6000008947ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000ee20000002700ULL, 0x00000010030e7824ULL, 0x050fe200078e0202ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x0000580020057a24ULL, 0x000fe200078e02ffULL,
0x0000000000067919ULL, 0x000ee20000002600ULL, 0x00001000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000002003157810ULL, 0x000fe20007ffe0ffULL, 0x0000660005077a24ULL, 0x000fe200078e02ffULL,
0x00a000000e187984ULL, 0x0008620000000c00ULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x00a200000e1c7984ULL, 0x0008a20000000c00ULL, 0x0000580009097a24ULL, 0x008fe200078e0206ULL,
0x00000fff07067811ULL, 0x000fc600078e40ffULL, 0x0000030009057a24ULL, 0x000fc800078e02ffULL,
0x00000001050f7824ULL, 0x000fca00078e0212ULL, 0x0000000f060c7211ULL, 0x000fca00078fa0ffULL,
0x00006c000c0c7625ULL, 0x000fcc00078e000dULL, 0x00000400000c7825ULL, 0x000fcc00078e000cULL,
0x0000001015147825ULL, 0x000fc800078e000cULL, 0x0000001003127825ULL, 0x000fe200078e000cULL,
0x01ffffff070c7812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003077824ULL, 0x016fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011603ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x000000010f107824ULL, 0x000fe200078e020cULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x00006c000f0e7625ULL, 0x000fe200078e0011ULL,
0x0000000c0d0d7812ULL, 0x000fc600078ec0ffULL, 0x00006c0010107625ULL, 0x000fe200078e0011ULL,
0x0000000e0d0e7210ULL, 0x000fc80007b5e007ULL, 0x000000100d107210ULL, 0x000fe40007d9e007ULL,
0x0000000fff0f7210ULL, 0x000fe400017e64ffULL, 0x00000011ff117210ULL, 0x000fc600027ea4ffULL,
0x0000000a0e007986ULL, 0x0003e8000c101906ULL, 0x0000000b10007986ULL, 0x0003e4000c101906ULL,
0x0000001812007986ULL, 0x0163e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000001c14007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0a7424ULL, 0x000fe200078e00ffULL,
0xffffffff20077810ULL, 0x000fc60007ffe0ffULL, 0x00006a00090a7625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000070a0a79a8ULL, 0x000ea400099ee1c6ULL, 0x000000070a00720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff097807ULL, 0x000fca0000800000ULL,
0x00000009ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff077984ULL, 0x000ee40000000000ULL,
0x000000ff0700720cULL, 0x008fda0003f25270ULL, 0x000027a000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011603ULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x00000001050e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x004fe200078e00ffULL, 0x0000000c0a117812ULL, 0x000fe400078ec0ffULL,
0x00000070070d7812ULL, 0x000fe200078ec0ffULL, 0x00006c00050a7625ULL, 0x000fc800078e0009ULL,
0x00006c000e0e7625ULL, 0x000fe200078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00dULL,
0x0000000e110e7210ULL, 0x000fe40007b5e00dULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000fff0f7210ULL, 0x000fc600017e64ffULL, 0x000000060a077981ULL, 0x000568000c1e1900ULL,
0x000000060e107981ULL, 0x000562000c1e1900ULL, 0x000000022000780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002050a7810ULL, 0x004fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00dULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a127981ULL, 0x002362000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00dULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a147981ULL, 0x000362000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00dULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a167981ULL, 0x000362000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00dULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a187981ULL, 0x000362000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082000780cULL, 0x002fe40003f06070ULL,
0x00000006050a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fe40007a3e00dULL, 0x00000007050e0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000e0e0625ULL, 0x000fe400078e0009ULL,
0x000000060a1c7981ULL, 0x000366000c1e1900ULL, 0x0000000e110e0210ULL, 0x000fc80007c7e00dULL,
0x0000000fff0f0210ULL, 0x000fca0001fe84ffULL, 0x000000060e1e0981ULL, 0x000368000c1e1900ULL,
0x0000000720097810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff097819ULL, 0x000fc80000011609ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x020fe400078e0007ULL,
0x000000080e0d7824ULL, 0x040fe200078e00ffULL, 0x000000010e0e7810ULL, 0x000fc80007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000000090e00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080d0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000010d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001a07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1a7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000020d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a107981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000030d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001207077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a127981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000040d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001407077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a147981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000050d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a167981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000060d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001807077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a187981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000070d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001c07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1c7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0d0a7810ULL, 0x002fe40007ffe0ffULL, 0x0000001e07077209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff0f7819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0f0a7210ULL, 0x000fc80007a3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a1e7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003097824ULL, 0x004fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x002fc80000011603ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL,
0x00000001090a7824ULL, 0x000fca00078e020aULL, 0x000000070a007388ULL, 0x0203e40000000800ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000005060a7211ULL, 0x002fe200078fa0ffULL, 0x00001000ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x004fe20000011603ULL, 0x00000400003b7824ULL, 0x000fe200078e00ffULL,
0x00000016ff3d7819ULL, 0x000fe20000011600ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c090e7812ULL, 0x000fe200078ec0ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000020030f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0x0000003b0a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000105108824ULL, 0x000fe200078e020cULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x00000080ff128424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000010b0b7824ULL, 0x000fe200008e063dULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x0000100000227824ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00006c0010108625ULL, 0x000fe200078e0011ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000001000158824ULL, 0x000fe200078e0203ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00006c0005128625ULL, 0x000fc600078e0012ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x0000000107197824ULL, 0x000fe400078e020eULL,
0x0000001000178824ULL, 0x000fe400078e0203ULL, 0x000000100f0e7825ULL, 0x000fe400078e000aULL,
0x0000000019197984ULL, 0x000e620000000800ULL, 0x0000418017178811ULL, 0x000fe200078e20ffULL,
0x00000010030d7824ULL, 0x040fe400078e0222ULL, 0x00000010030a7825ULL, 0x000fc800078e000aULL,
0x0000001003108825ULL, 0x040fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a0d7faeULL, 0x0005e6000b901c46ULL, 0x0000001003128825ULL, 0x000fe200078e0012ULL,
0x003800000e0d7faeULL, 0x0007e6000b901c46ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000010158faeULL, 0x0009e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fc400078e00ffULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x0000000012178faeULL, 0x000be2000b901c46ULL,
0x00000000000a7805ULL, 0x004fe2000001ff00ULL, 0x000000ffff187224ULL, 0x000fe400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff0d7224ULL, 0x008fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x020fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000d0000009947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134367810ULL, 0x000fc80007ffe0ffULL, 0x0000030036007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x0000000105357824ULL, 0x000fe200078e0236ULL,
0x000000070300780cULL, 0x040fe20003f24070ULL, 0x00001000ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000000136217812ULL, 0x040fe200078ec0ffULL, 0x00000800361c7824ULL, 0x000fe200078e00ffULL,
0x00000035061a7211ULL, 0x000fe400078fa0ffULL, 0x0000002003397810ULL, 0x000fe40007ffe0ffULL,
0x000008001c1f7812ULL, 0x000fe200078ec0ffULL, 0x00006c001a1a7625ULL, 0x000fc800078e001bULL,
0x000000010c1d9824ULL, 0x000fe200078e0235ULL, 0x0000003b1a1a7210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff1e9424ULL, 0x000fe400078e00ffULL, 0x0000000200209824ULL, 0x000fe400078e0221ULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x00006c001d1c9625ULL, 0x000fc800078e001eULL,
0x00000001221e7824ULL, 0x000fe400078e021fULL, 0x00000002003a9824ULL, 0x000fe400078e0221ULL,
0x000000011b1b7824ULL, 0x000fe400000e063dULL, 0x0000000820379824ULL, 0x000fe400078e0203ULL,
0x00006c0035209625ULL, 0x000fc600078e0038ULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x0000001003357824ULL, 0x040fe400078e021eULL, 0x000000083a3a9824ULL, 0x000fe400078e0203ULL,
0x00000010031e9825ULL, 0x000fc800078e001cULL, 0x00000010391c7825ULL, 0x000fe200078e001aULL,
0x000041803a399811ULL, 0x000fc600078e20ffULL, 0x00000010031a7825ULL, 0x000fc800078e001aULL,
0x0000001003209825ULL, 0x000fe200078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800001a357faeULL, 0x0005e8000b901c46ULL, 0x003800001c357faeULL, 0x0005e8000b901c46ULL,
0x000000001e379faeULL, 0x0005e8000b901c46ULL, 0x0000000020399faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e0034ULL,
0x00000001ff1e7819ULL, 0x100fe20000011603ULL, 0x00000010031c7824ULL, 0x000fe200078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011603ULL, 0x000000801d1a7824ULL, 0x000fe200078e00ffULL,
0x0000000c1e1e7812ULL, 0x000fc400078ec0ffULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000835217824ULL, 0x040fe200078e00ffULL, 0x000000801a1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008351f7824ULL, 0x040fe200078e00ffULL, 0x0000000735407812ULL, 0x000fe400078ec0ffULL,
0x00000035ff3e7212ULL, 0x000fe200078e33ffULL, 0x00000100001b7824ULL, 0x000fe200078e021bULL,
0xfffffff81f1a7812ULL, 0x000fe400078ee240ULL, 0xfffffff8213e7812ULL, 0x000fc400078ee23eULL,
0x0000001b1e1c7210ULL, 0x000fe20007ffe01cULL, 0x00000008351b7824ULL, 0x040fe200078e00ffULL,
0x0000000835377810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001c3c7984ULL, 0x000ea20000000800ULL, 0x000000011b1e7812ULL, 0x100fe200078ef640ULL,
0x00000008371f7824ULL, 0x000fe200078e00ffULL, 0x000000021b207812ULL, 0x140fe200078ef640ULL,
0x004580001c4e7984ULL, 0x0004e20000000800ULL, 0x000000031b347812ULL, 0x100fe200078ef640ULL,
0x0000000837427824ULL, 0x000fe200078e00ffULL, 0x000000041b387812ULL, 0x140fe400078ef640ULL,
0x000000051b3a7812ULL, 0x000fe400078ef640ULL, 0x00000037ff4c7212ULL, 0x000fc800078e33ffULL,
0xfffffff81f4c7812ULL, 0x000fe400078ee24cULL, 0x00000007371f7812ULL, 0x000fe200078ec0ffULL,
0x0000003c191c7221ULL, 0x006fe20000010100ULL, 0x000000061b3c7812ULL, 0x000fe200078ef640ULL,
0x000008001d1b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b1c217820ULL, 0x000fe40000410000ULL,
0x00000004031c7824ULL, 0x000fe200078e00ffULL, 0x000008001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000837407824ULL, 0x000fc400078e00ffULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x00000180221b7810ULL, 0x000fe40007ffe01bULL, 0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8421c7812ULL, 0x000fe200078ee21fULL, 0x000000101a1a7824ULL, 0x000fe200078e021bULL,
0x0000000140427812ULL, 0x000fe200078ef61fULL, 0x000000103e3e7824ULL, 0x000fe200078e021bULL,
0x0000000240447812ULL, 0x000fe200078ef61fULL, 0x000000011a1a7824ULL, 0x000fe200078e021dULL,
0x0000000340467812ULL, 0x140fe200078ef61fULL, 0x000000011d3e7824ULL, 0x040fe200078e023eULL,
0x0000000440487812ULL, 0x000fe200078ef61fULL, 0x000000101e1e7824ULL, 0x000fe200078e021bULL,
0x00000005404a7812ULL, 0x000fe200078ef61fULL, 0x000000001a1a7984ULL, 0x000e620000000800ULL,
0x0000001020207824ULL, 0x000fe200078e021bULL, 0x0000000640407812ULL, 0x000fe200078ef61fULL,
0x000000011d1e7824ULL, 0x040fe200078e021eULL, 0x000000003e3e7984ULL, 0x000fe20000000800ULL,
0x000000011d207824ULL, 0x000fc400078e0220ULL, 0x0000001034347824ULL, 0x100fe400078e021bULL,
0x000000001e1e7984ULL, 0x000fe20000000800ULL, 0x0000004e214e7220ULL, 0x008fe40000410000ULL,
0x000000011d347824ULL, 0x040fe200078e0234ULL, 0x0000000020207984ULL, 0x000fe20000000800ULL,
0x0000001038387824ULL, 0x100fe400078e021bULL, 0x000000103a3a7824ULL, 0x000fe200078e021bULL,
0x00001f354e1f7589ULL, 0x000ea200000e0000ULL, 0x000000011d387824ULL, 0x000fc400078e0238ULL,
0x000000011d3a7824ULL, 0x040fe200078e023aULL, 0x0000000034347984ULL, 0x000ee20000000800ULL,
0x000000103c3c7824ULL, 0x100fe400078e021bULL, 0x000000101c1c7824ULL, 0x100fe200078e021bULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000011d3c7824ULL, 0x000fe400078e023cULL,
0x0000001042427824ULL, 0x100fe200078e021bULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x0000001044447824ULL, 0x000fc400078e021bULL, 0x0000001046467824ULL, 0x100fe200078e021bULL,
0x000000003c3c7984ULL, 0x000f220000000800ULL, 0x0000001048487824ULL, 0x100fe400078e021bULL,
0x000000104a4a7824ULL, 0x100fe400078e021bULL, 0x0000001040407824ULL, 0x100fe400078e021bULL,
0x000000104c4c7824ULL, 0x000fe200078e021bULL, 0x00005410ff1b7816ULL, 0x002fe2000000001aULL,
0x000000011d1c7824ULL, 0x040fe200078e021cULL, 0x00007610ff1a7816ULL, 0x000fe2000000001aULL,
0x000000011d427824ULL, 0x000fc400078e0242ULL, 0x000000011d447824ULL, 0x000fe400078e0244ULL,
0x0000001f1a317223ULL, 0x084fe20000010031ULL, 0x00007610ff1a7816ULL, 0x000fe2000000003eULL,
0x000000001c1c7984ULL, 0x000e620000000800ULL, 0x0000001f1b327223ULL, 0x080fe20000010032ULL,
0x00005410ff1b7816ULL, 0x000fe2000000003eULL, 0x000000011d467824ULL, 0x000fe200078e0246ULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x0000001f1a237223ULL, 0x080fe20000010023ULL,
0x00007610ff1a7816ULL, 0x000fe2000000001eULL, 0x0000001f1b247223ULL, 0x000fe20000010024ULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x00005410ff1b7816ULL, 0x000fe2000000001eULL,
0x000000011d487824ULL, 0x000fc400078e0248ULL, 0x0000001f1a2f7223ULL, 0x080fe2000001002fULL,
0x00007610ff1a7816ULL, 0x000fe20000000020ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x000000334e337221ULL, 0x000fe40000010000ULL, 0x0000001f1b307223ULL, 0x080fe20000010030ULL,
0x00001f374e4e7589ULL, 0x000ea200000e0000ULL, 0x0000001f1a2d7223ULL, 0x000fe2000001002dULL,
0x00007610ff1a7816ULL, 0x008fe20000000034ULL, 0x000000011d4a7824ULL, 0x040fe200078e024aULL,
0x00005410ff1b7816ULL, 0x000fe20000000020ULL, 0x0000000048487984ULL, 0x000ee20000000800ULL,
0x000000011d407824ULL, 0x000fc400078e0240ULL, 0x0000001f1a2b7223ULL, 0x080fe2000001002bULL,
0x00007610ff1a7816ULL, 0x010fe20000000038ULL, 0x0000001f1b2e7223ULL, 0x080fe2000001002eULL,
0x00005410ff1b7816ULL, 0x000fe20000000034ULL, 0x000000004a4a7984ULL, 0x000f220000000800ULL,
0x000000011d4c7824ULL, 0x000fe400078e024cULL, 0x0000001f1a297223ULL, 0x080fe20000010029ULL,
0x00007610ff1a7816ULL, 0x020fe2000000003aULL, 0x0000001f1b2c7223ULL, 0x000fe2000001002cULL,
0x00005410ff1b7816ULL, 0x000fe20000000038ULL, 0x0000000040407984ULL, 0x000f620000000800ULL,
0x000000ffff347224ULL, 0x000fc400078e0036ULL, 0x0000001f1a277223ULL, 0x080fe20000010027ULL,
0x00007610ff1a7816ULL, 0x000fe2000000003cULL, 0x0000001f1b2a7223ULL, 0x080fe2000001002aULL,
0x00005410ff1b7816ULL, 0x000fe2000000003aULL, 0x000000004c4c7984ULL, 0x000f620000000800ULL,
0x0000030034007a0cULL, 0x000fe20003f06070ULL, 0x0000001f1a257223ULL, 0x080fe20000010025ULL,
0x00007610ff1a7816ULL, 0x002fe2000000001cULL, 0x0000001f1b287223ULL, 0x000fe20000010028ULL,
0x00005410ff1b7816ULL, 0x000fc6000000003cULL, 0x0000004e1a177223ULL, 0x004fe20000010017ULL,
0x00007610ff1a7816ULL, 0x000fe20000000042ULL, 0x0000001f1b267223ULL, 0x000fe20000010026ULL,
0x00005410ff1b7816ULL, 0x000fc6000000001cULL, 0x0000004e1a157223ULL, 0x080fe20000010015ULL,
0x00007610ff1a7816ULL, 0x000fe20000000044ULL, 0x0000004e1b187223ULL, 0x000fe20000010018ULL,
0x00005410ff1b7816ULL, 0x000fc60000000042ULL, 0x0000004e1a137223ULL, 0x080fe20000010013ULL,
0x00007610ff1a7816ULL, 0x000fe20000000046ULL, 0x0000004e1b167223ULL, 0x000fe20000010016ULL,
0x00005410ff1b7816ULL, 0x000fc60000000044ULL, 0x0000004e1a117223ULL, 0x080fe20000010011ULL,
0x00007610ff1a7816ULL, 0x008fe20000000048ULL, 0x0000004e1b147223ULL, 0x000fe20000010014ULL,
0x00005410ff1b7816ULL, 0x000fc60000000046ULL, 0x0000004e1a0f7223ULL, 0x080fe2000001000fULL,
0x00007610ff1a7816ULL, 0x010fe2000000004aULL, 0x0000004e1b127223ULL, 0x000fe20000010012ULL,
0x00005410ff1b7816ULL, 0x000fc60000000048ULL, 0x0000004e1a0d7223ULL, 0x080fe2000001000dULL,
0x00005410ff1a7816ULL, 0x020fe20000000040ULL, 0x0000004e1b107223ULL, 0x000fe20000010010ULL,
0x00005410ff1b7816ULL, 0x000fc6000000004aULL, 0x0000004e1a0b7223ULL, 0x080fe2000001000bULL,
0x00005410ff1a7816ULL, 0x000fe2000000004cULL, 0x0000004e1b0e7223ULL, 0x000fe2000001000eULL,
0x00007610ff1b7816ULL, 0x000fc60000000040ULL, 0x0000004e1a097223ULL, 0x080fe20000010009ULL,
0x00007610ff1a7816ULL, 0x000fe2000000004cULL, 0x0000004e1b0a7223ULL, 0x000fc8000001000aULL,
0x0000004e1a077223ULL, 0x000fe20000010007ULL, 0xfffff32000008947ULL, 0x000fea000383ffffULL,
0x0180000033007810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000000007812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00017d40001a7802ULL, 0x000fe40000000f00ULL, 0x00007a5000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300007308ULL, 0x000ea40000001000ULL, 0xbf80000000037423ULL, 0x004fc80000000033ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008033b7811ULL, 0x004fe400078ff0ffULL,
0x00000002ff1f7819ULL, 0x000fe40000011603ULL, 0x0000003bff3d7212ULL, 0x000fe200078e33ffULL,
0x00001f3b00067589ULL, 0x000ea200000e0000ULL, 0x000000083b0c7824ULL, 0x000fc400078e00ffULL,
0x000000081f3f7824ULL, 0x000fe200078e00ffULL, 0x00001f1f00057589ULL, 0x00072200000e0000ULL,
0x000000083b1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c3d7812ULL, 0x000fe200078ee23dULL,
0x000000081f0c7824ULL, 0x000fc600078e00ffULL, 0xfffffff81a217812ULL, 0x000fe200078ee23bULL,
0x000000103d3d7824ULL, 0x000fe200078e0204ULL, 0x0000001fff007212ULL, 0x008fc600078e33ffULL,
0x0000001021217824ULL, 0x000fe200078e0204ULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee200ULL,
0x000000071f007812ULL, 0x000fe200078ec0ffULL, 0x0000001406147220ULL, 0x044fe40000410000ULL,
0x0000001306137220ULL, 0x040fe40000410000ULL, 0x0000001206127220ULL, 0x040fe40000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000001006107220ULL, 0x000fe20000410000ULL, 0x0000000500147812ULL, 0x000fe200078e3cffULL,
0x0000000f060f7220ULL, 0x040fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000000e060e7220ULL, 0x000fe20000410000ULL, 0x0000000400127812ULL, 0x000fe200078e3cffULL,
0x0000000d060d7220ULL, 0x040fe20000410000ULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x0000001806187220ULL, 0x000fe20000410000ULL, 0x0000000300107812ULL, 0x000fe200078e3cffULL,
0x0000001706177220ULL, 0x040fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fe200000010ffULL,
0x0000001606167220ULL, 0x000fe20000410000ULL, 0x00000002000e7812ULL, 0x000fe200078e3cffULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x000000181717723eULL, 0x000fe200000010ffULL,
0x0000000b060b7220ULL, 0x040fe20000410000ULL, 0x000000073b187812ULL, 0x000fe200078ec0ffULL,
0x0000000a060a7220ULL, 0x040fe20000410000ULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x0000000906097220ULL, 0x000fc40000410000ULL, 0x0000000706067220ULL, 0x000fe20000410000ULL,
0xfffffff80c077812ULL, 0x000fe200078ee21fULL, 0x000000081f197824ULL, 0x042fe200078e0210ULL,
0x00000001000c7812ULL, 0x040fe200078e3cffULL, 0x000000081f1b7824ULL, 0x040fe200078e0212ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x000000081f1d7824ULL, 0x040fe200078e0214ULL,
0x0000000b0a0a723eULL, 0x000fe200000010ffULL, 0x000000081f0b7824ULL, 0x040fe200078e020eULL,
0x000000090606723eULL, 0x000fe200000010ffULL, 0x000000081f097824ULL, 0x040fe200078e020cULL,
0x00000002180c7812ULL, 0x040fe200078e3cffULL, 0x000000081f1f7824ULL, 0x000fe200078e0200ULL,
0x0000000118007812ULL, 0x040fe200078e3cffULL, 0x0000000403167824ULL, 0x000fe200078e00ffULL,
0x00000003180e7812ULL, 0x040fe200078e3cffULL, 0x0000003205327220ULL, 0x050fe20000410000ULL,
0x0000000418107812ULL, 0x040fe200078e3cffULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000000518127812ULL, 0x040fe200078e3cffULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000000618147812ULL, 0x000fe200078e3cffULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000000c16227812ULL, 0x000fe200078ec0ffULL, 0x0000002e052e7220ULL, 0x000fe20000410000ULL,
0x000000323131723eULL, 0x000fe200000010ffULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000010ffULL, 0x0000002c052c7220ULL, 0x000fc40000410000ULL,
0x0000002b052b7220ULL, 0x000fe20000410000ULL, 0x0000002e2d2d723eULL, 0x000fe200000010ffULL,
0x0000002a052a7220ULL, 0x040fe40000410000ULL, 0x0000002905297220ULL, 0x000fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000010ffULL, 0x0000002805287220ULL, 0x040fe40000410000ULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000010ffULL,
0x0000002605267220ULL, 0x000fc40000410000ULL, 0x0000002505257220ULL, 0x000fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x0000002405247220ULL, 0x040fe40000410000ULL,
0x0000002305057220ULL, 0x000fe20000410000ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x000000083b237824ULL, 0x040fe400078e0200ULL, 0x000000083b337824ULL, 0x000fe200078e020cULL,
0x000000240505723eULL, 0x000fe200000010ffULL, 0x000000083b357824ULL, 0x000fc400078e020eULL,
0x000000083b377824ULL, 0x040fe400078e0210ULL, 0x000000083b397824ULL, 0x040fe400078e0212ULL,
0x000000083b3b7824ULL, 0x000fe400078e0214ULL, 0x0000001007077824ULL, 0x100fe400078e0204ULL,
0x000000103f0c7824ULL, 0x100fe400078e0204ULL, 0x0000001009097824ULL, 0x000fc400078e0204ULL,
0x000000100b0b7824ULL, 0x100fe400078e0204ULL, 0x0000001019197824ULL, 0x100fe400078e0204ULL,
0x0000000122007824ULL, 0x000fe400078e0207ULL, 0x000000101b1b7824ULL, 0x100fe400078e0204ULL,
0x000000101d1d7824ULL, 0x100fe200078e0204ULL, 0x0000003100007388ULL, 0x0003e20000000800ULL,
0x000000101f1f7824ULL, 0x000fc400078e0204ULL, 0x0000001023237824ULL, 0x100fe400078e0204ULL,
0x0000001033337824ULL, 0x100fe400078e0204ULL, 0x0000001035357824ULL, 0x100fe400078e0204ULL,
0x0000001037377824ULL, 0x100fe400078e0204ULL, 0x0000001039397824ULL, 0x100fe400078e0204ULL,
0x000000103b3b7824ULL, 0x000fc400078e0204ULL, 0x0000000122167824ULL, 0x040fe400078e020cULL,
0x0000000122047824ULL, 0x040fe400078e0209ULL, 0x00000001220c7824ULL, 0x040fe400078e020bULL,
0x00000001220e7824ULL, 0x040fe200078e0219ULL, 0x0000002f04007388ULL, 0x0005e20000000800ULL,
0x0000000122107824ULL, 0x040fe400078e021bULL, 0x0000000122127824ULL, 0x040fe200078e021dULL,
0x0000002d0c007388ULL, 0x0005e20000000800ULL, 0x0000000122147824ULL, 0x000fc400078e021fULL,
0x0000000122187824ULL, 0x040fe200078e0221ULL, 0x0000002b0e007388ULL, 0x0005e20000000800ULL,
0x00000001221a7824ULL, 0x040fe400078e0223ULL, 0x0000000122007824ULL, 0x042fe200078e0233ULL,
0x0000002910007388ULL, 0x0005e20000000800ULL, 0x00000001221c7824ULL, 0x040fe400078e0235ULL,
0x00000001221e7824ULL, 0x040fe200078e0237ULL, 0x0000002712007388ULL, 0x0005e20000000800ULL,
0x0000000122207824ULL, 0x000fc400078e0239ULL, 0x00000001223b7824ULL, 0x040fe200078e023bULL,
0x0000002514007388ULL, 0x0005e20000000800ULL, 0x00000001223d7824ULL, 0x000fc600078e023dULL,
0x0000000516007388ULL, 0x0005e80000000800ULL, 0x0000001718007388ULL, 0x0005e80000000800ULL,
0x000000151a007388ULL, 0x0005e80000000800ULL, 0x0000001300007388ULL, 0x0005e80000000800ULL,
0x000000111c007388ULL, 0x0005e80000000800ULL, 0x0000000f1e007388ULL, 0x0005e80000000800ULL,
0x0000000d20007388ULL, 0x0005e80000000800ULL, 0x0000000a3b007388ULL, 0x0005e80000000800ULL,
0x000000063d007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000020030a7810ULL, 0x004fe20007ffe0ffULL, 0x0000000000097919ULL, 0x000ea20000002600ULL,
0x00000003ff007819ULL, 0x100fe20000011603ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff067819ULL, 0x110fe2000001160aULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000700047812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000706077812ULL, 0x000fc400078e480aULL, 0x0ffffff804057812ULL, 0x000fe400078ef803ULL,
0x0ffffff807077812ULL, 0x000fc600078ef80aULL, 0x0000001005057824ULL, 0x100fe400078e0202ULL,
0x0000001007077824ULL, 0x000fc600078e0202ULL, 0x00a00000050c7984ULL, 0x0009680000000c00ULL,
0x00a0000007107984ULL, 0x0023620000000c00ULL, 0x00000008090b7824ULL, 0x044fe400078e00ffULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff80b007812ULL, 0x000fc400078ee200ULL, 0xfffffff809067812ULL, 0x000fe400078ee206ULL,
0x0000000400007c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL,
0x00000007030b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x010fe200008e06ffULL,
0x00005a0006047a11ULL, 0x000fc400078248ffULL, 0x000000070a097812ULL, 0x000fe400078ec0ffULL,
0x00005b0000037a11ULL, 0x000fe400000f4c03ULL, 0x1ffffff80b077812ULL, 0x102fe400078ef808ULL,
0x00005b0006057a11ULL, 0x000fe400008f4c05ULL, 0x1ffffff809097812ULL, 0x000fe200078ef808ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001009047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x020fe8000c101d06ULL, 0x0000001004007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000404387824ULL, 0x000fca00078e0200ULL,
0x000000053800720cULL, 0x000fda0003f06070ULL, 0x000000020c078824ULL, 0x000fc800078e00ffULL,
0x00006400070a8a24ULL, 0x000fe400078e0238ULL, 0xffffffffff077424ULL, 0x000fe400078e00ffULL,
0x000060000a0a8625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff0e7624ULL, 0x000fe200078e00ffULL, 0x000000060a078981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff0f7624ULL, 0x000fc600078e00ffULL, 0x01060000ff087f8cULL, 0x000e68000c80043fULL,
0x000000060e3a7981ULL, 0x000762000c1e9900ULL, 0x00000001040d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004000397824ULL, 0x000fe400078e00ffULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x00000040f93b7824ULL, 0x000fc400078e00ffULL,
0x0000000407207c24ULL, 0x004fd4000f8e02ffULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x00000100040a7824ULL, 0x00afe200078e0239ULL, 0x00000002ff1e7819ULL, 0x100fe40000011602ULL,
0x00000003ff157819ULL, 0x000fe40000011602ULL, 0x0000000a030b7217ULL, 0x000fe20007800000ULL,
0x00000040f9f97824ULL, 0x000fe200078e021eULL, 0x0000000315157812ULL, 0x000fe400078e4802ULL,
0x00000030101f7812ULL, 0x000fe200078ec0ffULL, 0x000000010b0d7824ULL, 0x000fe200078e0a0aULL,
0x00000008f90a7810ULL, 0x000fc40007ffe0ffULL, 0x00000010f90b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a200a7210ULL, 0x040fe40007f3e0ffULL, 0x000000f920187210ULL, 0x040fe40007f1e0ffULL,
0x0000000b200b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x00005e000a167a11ULL, 0x000fe200078240ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e0018127a11ULL, 0x000fe200078040ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00005f000a1b7a11ULL, 0x000fc400008f441bULL, 0x00005e000b137a11ULL, 0x000fe400078440ffULL,
0x00000018f90a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000d1e00720cULL, 0x000fe40003f66070ULL,
0x00005f0018187a11ULL, 0x000fe400000f440fULL, 0x00005f000b147a11ULL, 0x000fe400010f4414ULL,
0x0000000a20107210ULL, 0x000fc40007f3e0ffULL, 0x0000200000177811ULL, 0x000fe400078e68ffULL,
0x0ffffffc15027812ULL, 0x000fe200078ef802ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00000020f90b7810ULL, 0x000fe40007ffe0ffULL, 0x000000121f0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001002197824ULL, 0x000fe200078e0217ULL, 0x0000000b201d7210ULL, 0x000fe40007f5e0ffULL,
0x00000028f90e7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0618ULL,
0x00000030f90f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000e201a7210ULL, 0x000fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e2000d901c46ULL,
0x00005e0010127a11ULL, 0x000fe400078840ffULL, 0x0000001f160e7210ULL, 0x000fe40007f7e0ffULL,
0x00000038f9f97810ULL, 0x000fe40007ffe0ffULL, 0x000000081e1c7810ULL, 0x040fe40007ffe0ffULL,
0x000000101e167810ULL, 0x000fc40007ffe0ffULL, 0x0000000f20187210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e061bULL, 0x00005f0010027a11ULL, 0x000fe200020f4411ULL,
0x00000004160a7824ULL, 0x002fe200078e00ffULL, 0x000000f920f97210ULL, 0x000fe40007f3e0ffULL,
0x0000001f13107210ULL, 0x000fe40007f9e0ffULL, 0x000000181e207810ULL, 0x000fe40007ffe0ffULL,
0x0000000d1c00720cULL, 0x040fe20003f66070ULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0x0000001f12127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0614ULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee215ULL, 0x0000000420147824ULL, 0x000fe200078e00ffULL,
0x0000000d1600720cULL, 0x080fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200028e0602ULL,
0xfffffffc1c027812ULL, 0x000fe200078ee215ULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x0000000d2000720cULL, 0x000fe20003fa6070ULL, 0x000000100a197824ULL, 0x000fe200078e0217ULL,
0xfffffffc14147812ULL, 0x000fe200078ee215ULL, 0x00000010020b7824ULL, 0x000fe200078e0217ULL,
0x00005e001d1c7a11ULL, 0x000fc400078440ffULL, 0x000000281e0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010141b7824ULL, 0x000fe200078e0217ULL, 0x00005f001d1d7a11ULL, 0x000fe200010f4416ULL,
0x000000000e0b7faeULL, 0x0003e2000d901c46ULL, 0x000000201e027810ULL, 0x040fe40007ffe0ffULL,
0x000000301e147810ULL, 0x040fe20007ffe0ffULL, 0x0000000010197faeULL, 0x0005e2000e101c46ULL,
0x000000381e167810ULL, 0x000fe40007ffe0ffULL, 0x0000000d0a00720cULL, 0x0c0fe20003f66070ULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000d0200720cULL, 0x040fe20003f46070ULL,
0x0000000402027824ULL, 0x000fe200078e00ffULL, 0x00000000121b7faeULL, 0x0007e2000e901c46ULL,
0x00000004140e7824ULL, 0x002fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x000fc400078ee215ULL,
0xfffffffc02027812ULL, 0x100fe200078ee215ULL, 0x0000000416107824ULL, 0x004fe200078e00ffULL,
0xfffffffc0e0e7812ULL, 0x100fe200078ee215ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x0000000d1400720cULL, 0x080fe40003f86070ULL, 0xfffffffc10107812ULL, 0x000fe200078ee215ULL,
0x000000100a157824ULL, 0x100fe200078e0217ULL, 0x0000000d1600720cULL, 0x000fe20003fa6070ULL,
0x000000ffff137224ULL, 0x008fe200030e06ffULL, 0x00005e001a0f7a11ULL, 0x000fe200078c40ffULL,
0x00000010020d7824ULL, 0x000fc400078e0217ULL, 0x000000100e197824ULL, 0x000fe200078e0217ULL,
0x00005f001a137a11ULL, 0x000fe200030f4413ULL, 0x0000001010177824ULL, 0x000fe200078e0217ULL,
0x0000001f1c0a7210ULL, 0x080fe20007fde0ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x00005e0018107a11ULL, 0x040fe400078040ffULL, 0x0000001f0f0e7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e061dULL, 0x00005e00f9127a11ULL, 0x040fe400078c40ffULL,
0x00005f0018117a11ULL, 0x000fe200000f4411ULL, 0x000000ffff0f7224ULL, 0x000fe200008e0613ULL,
0x0000001f10107210ULL, 0x000fe20007f1e0ffULL, 0x000000000a0d7faeULL, 0x0003e2000d101c46ULL,
0x00005f00f9027a11ULL, 0x000fc400030f4402ULL, 0x0000001f12127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x000000000e157faeULL, 0x0003e6000d901c46ULL,
0x000000ffff137224ULL, 0x000fe200008e0602ULL, 0x0000000010197faeULL, 0x0003e8000e101c46ULL,
0x0000000012177faeULL, 0x0003e2000e901c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000003b020a7211ULL, 0x04afe400078ff0ffULL, 0x0000000802287811ULL, 0x000fc400078ff0ffULL,
0x0000000a200a7210ULL, 0x000fe40007f1e0ffULL, 0x00000010020e7811ULL, 0x040fe400078ff0ffULL,
0x0000001802127811ULL, 0x000fe200078ff0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005e000a247a11ULL, 0x000fe400078040ffULL, 0x0000002002147811ULL, 0x000fe200078ff0ffULL,
0x000000013b0d7824ULL, 0x040fe200078e0212ULL, 0x00005f000a267a11ULL, 0x000fe200000f440bULL,
0x00000001280a7824ULL, 0x000fe200078e023bULL, 0x0000002802167811ULL, 0x040fe200078ff0ffULL,
0x000000013b0b7824ULL, 0x040fe200078e020eULL, 0x0000003002187811ULL, 0x040fe200078ff0ffULL,
0x000000013b0f7824ULL, 0x040fe200078e0214ULL, 0x00000038021a7811ULL, 0x000fe200078ff0ffULL,
0x000000013b117824ULL, 0x040fe200078e0216ULL, 0x00000003ff197819ULL, 0x000fe20000011602ULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x0000000a20227210ULL, 0x040fe20007fde0ffULL,
0x000000013b137824ULL, 0x000fe200078e0218ULL, 0x0000000319197812ULL, 0x000fe200078e4802ULL,
0x000000013b157824ULL, 0x000fe200078e021aULL, 0x0000000b201e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x0000000d201c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x0000000f201b7210ULL, 0x000fe20007f3e0ffULL,
0x000000040e0a7824ULL, 0x000fe200078e00ffULL, 0x0000200000277811ULL, 0x000fe200078e68ffULL,
0x00000004140e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc120b7812ULL, 0x000fe200078ee219ULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x0000001120177210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x0000001320137210ULL, 0x000fe20007f7e0ffULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0x0000001520157210ULL, 0x000fe20007f9e0ffULL,
0x000000100b1f7824ULL, 0x000fe200078e0227ULL, 0x0ffffffc19147812ULL, 0x000fe200078ef802ULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0xfffffffc160f7812ULL, 0x000fc400078ee219ULL,
0xfffffffc28027812ULL, 0x000fe200078ee219ULL, 0x00000010142b7824ULL, 0x100fe200078e0227ULL,
0x00005e0022207a11ULL, 0x000fe200078c40ffULL, 0x000000100f237824ULL, 0x000fe200078e0227ULL,
0xfffffffc0a0a7812ULL, 0x100fe400078ee219ULL, 0xfffffffc0e0e7812ULL, 0x100fe400078ee219ULL,
0xfffffffc18117812ULL, 0x000fe200078ee219ULL, 0x000000100a1d7824ULL, 0x000fe200078e0227ULL,
0x00005f0022227a11ULL, 0x000fe200030f440dULL, 0x00000010020d7824ULL, 0x100fe200078e0227ULL,
0x00005e001c0f7a11ULL, 0x000fe200078040ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x0000003010297812ULL, 0x000fe200078ec0ffULL, 0x000000100e217824ULL, 0x100fe200078e0227ULL,
0x00005e001b147a11ULL, 0x000fe200078240ffULL, 0x0000001011257824ULL, 0x000fe200078e0227ULL,
0xfffffffc1a127812ULL, 0x000fe200078ee219ULL, 0x000000ffff197224ULL, 0x000fe200028e06ffULL,
0x00005f001c1c7a11ULL, 0x000fe200000f440bULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x00005e001e117a11ULL, 0x000fe200078a40ffULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x00000024290a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001012277824ULL, 0x000fe200078e0227ULL,
0x00005f001b1b7a11ULL, 0x000fe200008f4402ULL, 0x000000ffff027224ULL, 0x000fe200020e06ffULL,
0x00005e0013187a11ULL, 0x000fe200078440ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0626ULL,
0x00005e0017167a11ULL, 0x000fc400078240ffULL, 0x00005f001e1e7a11ULL, 0x000fe400028f4419ULL,
0x00005e00151a7a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0013197a11ULL, 0x000fe400010f440eULL,
0x00005f0017177a11ULL, 0x000fe400008f4410ULL, 0x00000020290e7210ULL, 0x040fe40007f1e0ffULL,
0x0000001129107210ULL, 0x000fc40007f3e0ffULL, 0x00005f0015027a11ULL, 0x000fe400018f4402ULL,
0x0000000f29127210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0622ULL,
0x0000001429147210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e061eULL,
0x0000001629167210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e061cULL,
0x0000001829187210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200018e061bULL,
0x0000001a291a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e0617ULL,
0x000000000e0d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc400028e0619ULL,
0x000000ffff1b7224ULL, 0x000fe200000e0602ULL, 0x00000000101d7faeULL, 0x0003e8000b901c46ULL,
0x00000000121f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e8000b901c46ULL, 0x0000000018257faeULL, 0x0003e8000b901c46ULL,
0x000000001a277faeULL, 0x0003e4000b901c46ULL, 0x01060400ff0b7984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x800000000bff7812ULL, 0x002fc60007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x00000002000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe20003800000ULL, 0x01060400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fc800078e0209ULL,
0x00000020020a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fc80000011602ULL,
0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL, 0x000001e00a0a7812ULL, 0x000fe400078ec0ffULL,
0x00000001090d7812ULL, 0x040fe400078efcffULL, 0x00000007090b7812ULL, 0x100fe400078e7802ULL,
0x000000070d0d7812ULL, 0x100fe400078e7802ULL, 0x00000010090f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x040fe200078e020bULL, 0x0000001109097810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0d7824ULL, 0x000fe200078e020dULL, 0x000000070f0f7812ULL, 0x000fc400078e7802ULL,
0x000000000b147984ULL, 0x000e62000000cc00ULL, 0x0000000709097812ULL, 0x000fe400078e7802ULL,
0x000000010a0f7824ULL, 0x040fe200078e020fULL, 0x000000000d107984ULL, 0x000ea4000000cc00ULL,
0x000000010a097824ULL, 0x000fe400078e0209ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff197224ULL, 0x000fc400078e0016ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0017ULL, 0x000000180b007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fca00078e0013ULL,
0x0000001c0d007388ULL, 0x000fe8000000cc00ULL, 0x0000000009107984ULL, 0x000e68000000cc00ULL,
0x000000000f147984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e0012ULL,
0x000000ffff227224ULL, 0x000fc400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff207224ULL, 0x004fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x000000200f007388ULL, 0x0003e8000000cc00ULL, 0x0000001009007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff087f8cULL, 0x002fe8000c80043fULL,
0x01060400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x00000002000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe20003800000ULL, 0x01060400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000060400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x3d8000003a3a7820ULL, 0x020fe20000410000ULL,
0x00010688003c7811ULL, 0x000fe200078e18ffULL, 0x000064000c3d7a24ULL, 0x000fe200078e02ffULL,
0xffffffff063f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x00010608003e7811ULL, 0x000fe400078e28ffULL, 0x0000010004407824ULL, 0x000fe200078e0239ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000400300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x03cfea0003800000ULL, 0x000000ffff437224ULL, 0x000fe200078e0041ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x0000000142287810ULL, 0x000fe20007ffe0ffULL,
0x00000d7000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e0042ULL,
0x0000000143417812ULL, 0x000fe200078e0cffULL, 0x0000000407377c24ULL, 0x020fe2000f8e02ffULL,
0x00000002ff297819ULL, 0x100fe20000011628ULL, 0x000000ffff427224ULL, 0x000fe200078e0028ULL,
0x000000042800780cULL, 0x000fc40003f06070ULL, 0x0000000328567812ULL, 0x000fe200078ec0ffULL,
0x00000300292e7a24ULL, 0x000fca00078e0204ULL, 0x000000012e297810ULL, 0x000fc80007ffe0ffULL,
0x000000062900720cULL, 0x000fda0003f26070ULL, 0x000006c000009947ULL, 0x000fea0003800000ULL,
0x00000002ff337819ULL, 0x002fe20000011602ULL, 0x000001002e2e7824ULL, 0x000fe400078e0239ULL,
0x0000000456557824ULL, 0x000fe200078e00ffULL, 0x0000000833457810ULL, 0x040fe20007ffe0ffULL,
0x0000000133287824ULL, 0x040fe200078e023bULL, 0x00000010334d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000200467824ULL, 0x000fe200078e0241ULL, 0x0000002e03297217ULL, 0x000fe20007800000ULL,
0x00000001452a7824ULL, 0x100fe200078e023bULL, 0x0000002837317210ULL, 0x000fe20007f3e0ffULL,
0x000000014d2b7824ULL, 0x100fe200078e023bULL, 0x00000018334f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129447824ULL, 0x000fe200078e0a2eULL, 0x0000002a372f7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff347224ULL, 0x000fe200008e06ffULL, 0x0000002b372d7210ULL, 0x000fe20007f7e0ffULL,
0x000000014f2e7824ULL, 0x000fe200078e023bULL, 0x00005e0031287a11ULL, 0x000fe200078240ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005e002f2a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x0000002033507810ULL, 0x000fc40007ffe0ffULL,
0x0000003033527810ULL, 0x000fe40007ffe0ffULL, 0x00005e002d2c7a11ULL, 0x000fe400078640ffULL,
0x0000002833517810ULL, 0x000fe40007ffe0ffULL, 0x00005f0031297a11ULL, 0x000fe200008f4434ULL,
0x000000013b317824ULL, 0x000fe200078e0252ULL, 0x00005f002f2b7a11ULL, 0x000fe200010f4432ULL,
0x000000013b2f7824ULL, 0x000fe200078e0250ULL, 0x0000003833537810ULL, 0x000fc40007ffe0ffULL,
0x0000002e37367210ULL, 0x000fe40007f3e0ffULL, 0x00005f002d2d7a11ULL, 0x000fe200018f4430ULL,
0x000000013b307824ULL, 0x000fe200078e0251ULL, 0x0000002f37347210ULL, 0x000fe20007fbe0ffULL,
0x000000013b327824ULL, 0x000fe200078e0253ULL, 0x0000003137357210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e06ffULL, 0x00000003ff317819ULL, 0x000fe40000011602ULL,
0x000000443300720cULL, 0x000fe20003f46070ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005e00362e7a11ULL, 0x000fc400078240ffULL, 0x0000003037337210ULL, 0x040fe40007fde0ffULL,
0x0000003237377210ULL, 0x000fe20007f7e0ffULL, 0x0000000445327824ULL, 0x000fe200078e00ffULL,
0x00000003314b7812ULL, 0x000fe200078e4802ULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x00005f00362f7a11ULL, 0x000fe200008f442fULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x000000444500720cULL, 0x000fe20003f26070ULL, 0x000000ffff4c7224ULL, 0x000fe200030e06ffULL,
0x0000200046467811ULL, 0x000fc400078e60ffULL, 0x0ffffffc4b477812ULL, 0x100fe400078ef802ULL,
0xfffffffc55457812ULL, 0x000fe400078ee202ULL, 0xfffffffc32497812ULL, 0x000fe200078ee24bULL,
0x0000001047477824ULL, 0x000fe200078e0246ULL, 0x00005e0034307a11ULL, 0x040fe200078a40ffULL,
0x0000001045287825ULL, 0x000fe200078e0028ULL, 0x00005e0037367a11ULL, 0x000fe400078640ffULL,
0x00005f0034317a11ULL, 0x000fe200028f4431ULL, 0x0000001049497824ULL, 0x000fe200078e0246ULL,
0x00005e0033327a11ULL, 0x000fe200078a40ffULL, 0x00000010452a7825ULL, 0x000fe200078e002aULL,
0x00005e0035347a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028477faeULL, 0x0003e2000d101c46ULL, 0x00005f0037377a11ULL, 0x000fe200018f4448ULL,
0x000000044f487824ULL, 0x000fe200078e00ffULL, 0x00005f0033337a11ULL, 0x000fe200028f444cULL,
0x000000002a497faeULL, 0x0005e2000c901c46ULL, 0x00005f0035357a11ULL, 0x000fc400020f444aULL,
0x000000445000720cULL, 0x0c0fe20003f66070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x000000444d00720cULL, 0x080fe40003f26070ULL, 0x000000444f00720cULL, 0x080fe20003f46070ULL,
0x0000000451287824ULL, 0x042fe200078e00ffULL, 0x000000445100720cULL, 0x080fe40003f86070ULL,
0x000000445200720cULL, 0x0c0fe20003fa6070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x000000445300720cULL, 0x000fe20003fc6070ULL, 0x000000044d447824ULL, 0x000fe200078e00ffULL,
0xfffffffc50297812ULL, 0x100fe200078ee24bULL, 0x00000004532a7824ULL, 0x004fe200078e00ffULL,
0xfffffffc48497812ULL, 0x000fc400078ee24bULL, 0xfffffffc44477812ULL, 0x100fe400078ee24bULL,
0xfffffffc284d7812ULL, 0x100fe200078ee24bULL, 0x0000001049497824ULL, 0x100fe200078e0246ULL,
0xfffffffc524f7812ULL, 0x100fe200078ee24bULL, 0x0000001047477824ULL, 0x100fe200078e0246ULL,
0xfffffffc2a517812ULL, 0x000fe200078ee24bULL, 0x00000010294b7824ULL, 0x000fe400078e0246ULL,
0x0000001045287825ULL, 0x000fc800078e002cULL, 0x00000010452a7825ULL, 0x040fe200078e002eULL,
0x0000000028477faeULL, 0x0003e6000c901c46ULL, 0x00000010452c7825ULL, 0x000fe200078e0030ULL,
0x000000002a497faeULL, 0x0003e6000d101c46ULL, 0x000000104d4d7824ULL, 0x000fe200078e0246ULL,
0x000000002c4b7faeULL, 0x0003e2000d901c46ULL, 0x00000010452e7825ULL, 0x000fc800078e0032ULL,
0x000000104f4f7824ULL, 0x000fe200078e0246ULL, 0x000000002e4d7faeULL, 0x0003e2000e101c46ULL,
0x0000001045307825ULL, 0x000fc800078e0034ULL, 0x0000001051517824ULL, 0x000fe200078e0246ULL,
0x00000000304f7faeULL, 0x0003e2000e901c46ULL, 0x0000001045327825ULL, 0x000fca00078e0036ULL,
0x0000000032517faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000003b02287211ULL, 0x002fe200078ff0ffULL, 0x0000000456537824ULL, 0x000fe200078e00ffULL,
0x0000000802307811ULL, 0x000fe400078ff0ffULL, 0x0000003728297210ULL, 0x080fe40007f3e0ffULL,
0x0000002002447811ULL, 0x000fe200078ff0ffULL, 0x00000001302a7824ULL, 0x000fe200078e023bULL,
0x0000001802347811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078240ffULL, 0x000000013b467824ULL, 0x040fe200078e0244ULL,
0x000000372a2b7210ULL, 0x000fe20007f5e0ffULL, 0x000000013b367824ULL, 0x000fe200078e0234ULL,
0x00005f0029297a11ULL, 0x000fe200008f442eULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x00000010022e7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x0000002802487811ULL, 0x000fc400078ff0ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078440ffULL,
0x000000013b327824ULL, 0x040fe200078e022eULL, 0x00000003ff457819ULL, 0x000fe20000011602ULL,
0x000000013b4a7824ULL, 0x000fe200078e0248ULL, 0x00005f002b2b7a11ULL, 0x000fe200010f442cULL,
0x00000002002c7824ULL, 0x000fe200078e0241ULL, 0x00000030024c7811ULL, 0x000fe200078ff0ffULL,
0x000000042e2e7824ULL, 0x000fe200078e00ffULL, 0x0000003802527811ULL, 0x000fe400078ff0ffULL,
0x00000037322d7210ULL, 0x080fe20007fde0ffULL, 0x0000000430327824ULL, 0x000fe200078e00ffULL,
0x0000000345457812ULL, 0x000fe200078e4802ULL, 0x000000013b507824ULL, 0x000fe200078e024cULL,
0x0000003746317210ULL, 0x080fe20007f9e0ffULL, 0x0000000448467824ULL, 0x000fe200078e00ffULL,
0x00000037362f7210ULL, 0x080fe20007fbe0ffULL, 0x0000000434367824ULL, 0x000fe200078e00ffULL,
0x000000374a337210ULL, 0x000fe20007f3e0ffULL, 0x000000044c487824ULL, 0x000fe200078e00ffULL,
0x000020002c517811ULL, 0x000fe200078e60ffULL, 0x00000004524a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2e347812ULL, 0x000fe200078ee245ULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0x0ffffffc45307812ULL, 0x000fe200078ef802ULL, 0x000000013b547824ULL, 0x000fe200078e0252ULL,
0x00005e002d2c7a11ULL, 0x000fe200078c40ffULL, 0x0000001034477824ULL, 0x000fe200078e0251ULL,
0xfffffffc32327812ULL, 0x000fe200078ee245ULL, 0x0000001030557824ULL, 0x000fe200078e0251ULL,
0xfffffffc36367812ULL, 0x100fe200078ee245ULL, 0x000000ffff307224ULL, 0x000fe200028e06ffULL,
0xfffffffc44447812ULL, 0x000fc400078ee245ULL, 0xfffffffc46467812ULL, 0x000fe200078ee245ULL,
0x0000001036497824ULL, 0x000fe200078e0251ULL, 0xfffffffc48487812ULL, 0x000fe200078ee245ULL,
0x00000010444b7824ULL, 0x000fe200078e0251ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee245ULL,
0x0000001032457824ULL, 0x100fe200078e0251ULL, 0x00005f002d2d7a11ULL, 0x000fe200030f442eULL,
0x00000010464d7824ULL, 0x100fe200078e0251ULL, 0x00005e002f2e7a11ULL, 0x040fe200078a40ffULL,
0x00000010484f7824ULL, 0x100fe200078e0251ULL, 0x0000003750357210ULL, 0x080fe20007f5e0ffULL,
0x000000104a517824ULL, 0x000fe200078e0251ULL, 0x0000003754377210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x00005f002f2f7a11ULL, 0x000fe200028f4430ULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0xfffffffc53537812ULL, 0x000fe200078ee202ULL,
0x000000ffff467224ULL, 0x000fe200010e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078840ffULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078240ffULL,
0x0000001053287825ULL, 0x000fe200078e0028ULL, 0x00005e0035347a11ULL, 0x000fc400078440ffULL,
0x00005e0037367a11ULL, 0x000fe200078640ffULL, 0x00000010532a7825ULL, 0x000fe200078e002aULL,
0x00005f0031317a11ULL, 0x000fe200020f444aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028557faeULL, 0x0003e2000b901c46ULL, 0x00005f0033337a11ULL, 0x000fe200008f4448ULL,
0x00000010532c7825ULL, 0x000fe200078e002cULL, 0x00005f0035357a11ULL, 0x000fe200010f4446ULL,
0x000000002a457faeULL, 0x0003e2000b901c46ULL, 0x00005f0037377a11ULL, 0x000fe200018f4444ULL,
0x00000010532e7825ULL, 0x040fe400078e002eULL, 0x000000002c477faeULL, 0x0003e4000b901c46ULL,
0x0000001053307825ULL, 0x000fc400078e0030ULL, 0x000000002e497faeULL, 0x0003e4000b901c46ULL,
0x0000001053327825ULL, 0x040fe400078e0032ULL, 0x00000000304b7faeULL, 0x0003e4000b901c46ULL,
0x0000001053347825ULL, 0x040fe400078e0034ULL, 0x00000000324d7faeULL, 0x0003e4000b901c46ULL,
0x0000001053367825ULL, 0x000fc400078e0036ULL, 0x00000000344f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035600780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x00000004ff297424ULL, 0x002fe400078e00ffULL,
0xffffffffff077424ULL, 0x000fe400078e00ffULL, 0x0000030029387a24ULL, 0x000fca00078e0238ULL,
0x000000053800720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x000000023d287824ULL, 0x000fc800078e0238ULL, 0x0000600028287625ULL, 0x000fca00078e0029ULL,
0x0000000628077981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000084e4b7824ULL, 0x002fe400078e00ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff802297812ULL, 0x000fe200078ec0ffULL, 0x00000002002d7824ULL, 0x000fe200078e0243ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014a467810ULL, 0x000fe40007ffe0ffULL,
0x0000000729297812ULL, 0x000fe400078ef802ULL, 0x000020002d2d7811ULL, 0x000fc400078e60ffULL,
0x00000001ff287819ULL, 0x000fc80000011629ULL, 0x00000003282b7812ULL, 0x000fc800078ec0ffULL,
0x0000004a2b287212ULL, 0x040fe400078e3cffULL, 0x000000462b2a7212ULL, 0x000fc600078e3cffULL,
0x0000000429287824ULL, 0x040fe400078e0228ULL, 0x00000004292a7824ULL, 0x000fe200078e022aULL,
0x0000002002297810ULL, 0x000fe20007ffe0ffULL, 0x0000001028287824ULL, 0x100fe400078e022dULL,
0x000000102a2a7824ULL, 0x000fe200078e022dULL, 0xfffffff829297812ULL, 0x000fe400078ec0ffULL,
0x000000002834783bULL, 0x000e640000000200ULL, 0x00000007292c7812ULL, 0x000fc400078ef802ULL,
0x000000002a30783bULL, 0x0004e20000000200ULL, 0x00000018ff287819ULL, 0x002fe20000011434ULL,
0x0001000034557824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x004fe20000011435ULL,
0x00000034009f7306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x000fe20000011436ULL,
0x0001000035587824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff447819ULL, 0x000fe40000011437ULL, 0x00000018ff457819ULL, 0x008fe20000011430ULL,
0x0000002800a17306ULL, 0x000fe20000209400ULL, 0x00000018ff487819ULL, 0x000fc40000011432ULL,
0x00000018ff477819ULL, 0x000fe40000011431ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff497819ULL, 0x000fe20000011433ULL, 0x0000002800a67306ULL, 0x000e700000205400ULL,
0x0000002800867306ULL, 0x0004f0000020d400ULL, 0x0000002a00a77306ULL, 0x000fe20000209400ULL,
0x00000001ff287819ULL, 0x004fc4000001162cULL, 0x000000a6a100720bULL, 0x002fe40003fdd000ULL,
0x0000000328297812ULL, 0x000fc600078ec0ffULL, 0x0000002a00aa7306ULL, 0x000fe20000205400ULL,
0x0000004a292b7212ULL, 0x040fe400078e3cffULL, 0x00000046292f7212ULL, 0x000fe400078e3cffULL,
0x000000024a4a7810ULL, 0x000fe20007ffe0ffULL, 0x000000042c287824ULL, 0x040fe400078e022bULL,
0x0000002a00827306ULL, 0x0003e2000020d400ULL, 0x000000042c2c7824ULL, 0x000fe200078e022fULL,
0x0000000186866812ULL, 0x008fe200078efcffULL, 0x0000001028287824ULL, 0x000fc400078e022dULL,
0x000000102c2c7824ULL, 0x000fc600078e022dULL, 0x0000003400a07306ULL, 0x000ea20000005400ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x0000003400847306ULL, 0x000730000000d400ULL,
0x00000055006f7306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x008fe200078e00ffULL,
0x000000a09f00720bULL, 0x004fc80003f5d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000005500b87306ULL, 0x000eae0000205400ULL, 0x0000000184842812ULL, 0x010fe200078efcffULL,
0x0000003500a27306ULL, 0x000ff00000009400ULL, 0x0000003500a57306ULL, 0x000ee20000005400ULL,
0x000000b86f00720bULL, 0x004fe20003f9d000ULL, 0x0001000028727824ULL, 0x002fc400078e00ffULL,
0x000100002bd37824ULL, 0x000fc600078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000003500837306ULL, 0x0002b0000000d400ULL, 0x0000002e00a97306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x002fe200078e00ffULL, 0x000000a5a200720bULL, 0x008fc80003fbd000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000002e00a87306ULL, 0x000e6e0000205400ULL,
0x0000000183835812ULL, 0x004fe200078efcffULL, 0x0000002e00807306ULL, 0x0004f0000020d400ULL,
0x0000003400b97306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x004ea20000000200ULL,
0x000000a8a900720bULL, 0x002fcc0003fbd000ULL, 0x0000003400bc7306ULL, 0x000e6e0000205400ULL,
0x0000000180805812ULL, 0x008fe200078efcffULL, 0x00000034009d7306ULL, 0x000730000020d400ULL,
0x0000003500c57306ULL, 0x000fe20000209400ULL, 0x0001000037347824ULL, 0x008fe200078e00ffULL,
0x000000bcb900720bULL, 0x002fc80003f7d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500c87306ULL, 0x000fee0000205400ULL, 0x000000019d9d3812ULL, 0x010fe200078efcffULL,
0x0000003500997306ULL, 0x0003e2000020d400ULL, 0x00000018ff747819ULL, 0x004fc4000001142dULL,
0x000000aaa700720bULL, 0x000fe40003f7d000ULL, 0x00000018ff5e7819ULL, 0x000fe4000001142cULL,
0x00000018ff797819ULL, 0x000fe2000001142fULL, 0x00000037009a7306ULL, 0x000fe20000009400ULL,
0x00000018ff357819ULL, 0x002fe40000011428ULL, 0x00000018ff787819ULL, 0x000fca000001142eULL,
0x0000003700957306ULL, 0x000e620000005400ULL, 0x0000000182823812ULL, 0x000fce00078efcffULL,
0x00000037007f7306ULL, 0x0005f0000000d400ULL, 0x00000055009b7306ULL, 0x000722000020d400ULL,
0x0000010037377824ULL, 0x004fe200078e00ffULL, 0x000000959a00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003600a47306ULL, 0x000fe20000009400ULL,
0x0001000036557824ULL, 0x008fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000003600a37306ULL, 0x000e620000005400ULL, 0x000000019b9b4812ULL, 0x010fe400078efcffULL,
0x000000c8c500720bULL, 0x000fe40003f9d000ULL, 0x000000017f7f3812ULL, 0x000fc600078efcffULL,
0x0000003600817306ULL, 0x0004f0000000d400ULL, 0x0000003500cf7306ULL, 0x000fe20000209400ULL,
0x0000010036367824ULL, 0x004fe200078e00ffULL, 0x0000000199994812ULL, 0x000fc400078efcffULL,
0x000000a3a400720bULL, 0x002fe40003f5d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003500d27306ULL, 0x000ff00000205400ULL, 0x0000003500737306ULL, 0x0003e2000020d400ULL,
0x0000000181812812ULL, 0x008fce00078efcffULL, 0x0000003000907306ULL, 0x000fe20000009400ULL,
0x0001000030357824ULL, 0x002fce00078e00ffULL, 0x00000030008d7306ULL, 0x000ff00000005400ULL,
0x0000003000537306ULL, 0x0003f0000000d400ULL, 0x0000003400cd7306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fce00078e00ffULL, 0x0000003400d07306ULL, 0x000e700000205400ULL,
0x00000034009c7306ULL, 0x0004f0000020d400ULL, 0x0000003700d17306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fc4000001142aULL, 0x000000d0cd00720bULL, 0x002fca0003f9d000ULL,
0x0000003700d47306ULL, 0x000ff00000205400ULL, 0x00000037007c7306ULL, 0x0003e2000020d400ULL,
0x000000019c9c4812ULL, 0x008fc800078efcffULL, 0x0000007f9c9c723eULL, 0x000fc600000010ffULL,
0x0000003400c67306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x002fce000001142bULL,
0x0000003400c37306ULL, 0x000ff00000205400ULL, 0x0000003400677306ULL, 0x0003f0000020d400ULL,
0x0000003600cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x002fe20000011430ULL,
0x0001000031307824ULL, 0x000fcc00078e00ffULL, 0x0000003600c97306ULL, 0x000ff00000205400ULL,
0x0000003600937306ULL, 0x0003f0000020d400ULL, 0x0000003700bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fce0000011429ULL, 0x0000003700c27306ULL, 0x000ff00000205400ULL,
0x0000003700647306ULL, 0x0003f0000020d400ULL, 0x00000032008c7306ULL, 0x000fe20000009400ULL,
0x0001000032377824ULL, 0x002fce00078e00ffULL, 0x0000003200897306ULL, 0x000ff00000005400ULL,
0x0000003200507306ULL, 0x0003f0000000d400ULL, 0x0000005500c77306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x002fce00078e00ffULL, 0x0000005500ca7306ULL, 0x000e700000205400ULL,
0x0000003600cb7306ULL, 0x000ff00000209400ULL, 0x0000003600ce7306ULL, 0x000fe20000205400ULL,
0x000000cac700720bULL, 0x002fce0003fdd000ULL, 0x00000036006b7306ULL, 0x0003f0000020d400ULL,
0x00000031008a7306ULL, 0x000fe20000009400ULL, 0x00000018ff367819ULL, 0x002fce0000011430ULL,
0x0000003100857306ULL, 0x000ff00000005400ULL, 0x0000003100517306ULL, 0x0003f0000000d400ULL,
0x0000003600ba7306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x002fce00078e00ffULL,
0x0000003600b77306ULL, 0x000ff00000205400ULL, 0x0000003600307306ULL, 0x0003f0000020d400ULL,
0x0000005800c47306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x002fe20000011432ULL,
0x0001000033327824ULL, 0x000fcc00078e00ffULL, 0x0000005800c17306ULL, 0x000e700000205400ULL,
0x0000005800967306ULL, 0x0005f0000020d400ULL, 0x00000055009e7306ULL, 0x000722000020d400ULL,
0x00000018ff587819ULL, 0x004fc40000011431ULL, 0x000000c1c400720bULL, 0x002fca0003f3d000ULL,
0x0000005800b57306ULL, 0x000fe20000209400ULL, 0x00000018ff557819ULL, 0x008fce0000011435ULL,
0x0000005800b67306ULL, 0x000fe20000205400ULL, 0x000000019e9e6812ULL, 0x010fe400078efcffULL,
0x000000d4d100720bULL, 0x000fe40003fdd000ULL, 0x0000000196961812ULL, 0x000fe400078efcffULL,
0x000000c9cc00720bULL, 0x000fe20003f3d000ULL, 0x0000005800317306ULL, 0x0003f0000020d400ULL,
0x0000007200d57306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x002fc40000011432ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000000193931812ULL, 0x000fc600078efcffULL,
0x0000007200d87306ULL, 0x000e700000205400ULL, 0x0000005500bd7306ULL, 0x000ff00000209400ULL,
0x0000005500c07306ULL, 0x000fe20000205400ULL, 0x000000d8d500720bULL, 0x002fce0003f9d000ULL,
0x0000005500607306ULL, 0x000ff0000020d400ULL, 0x0000003600977306ULL, 0x000ff00000209400ULL,
0x0000003600987306ULL, 0x000ff00000205400ULL, 0x0000003600557306ULL, 0x000ff0000020d400ULL,
0x0000005800717306ULL, 0x000ff00000209400ULL, 0x0000005800707306ULL, 0x000ff00000205400ULL,
0x0000005800327306ULL, 0x000ff0000020d400ULL, 0x0000002800b47306ULL, 0x000ff00000009400ULL,
0x0000002800b17306ULL, 0x000e700000005400ULL, 0x00000028006e7306ULL, 0x0004f0000000d400ULL,
0x0000007400367306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x000000b1b400720bULL, 0x002fc80003f3d000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000007400597306ULL, 0x000fee0000205400ULL, 0x000000016e6e1812ULL, 0x008fe200078efcffULL,
0x0000007400587306ULL, 0x0003e2000020d400ULL, 0x000000cecb00720bULL, 0x000fce0003f3d000ULL,
0x00000072007b7306ULL, 0x0004e2000020d400ULL, 0x0001000029747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000002800d77306ULL, 0x000fe20000209400ULL,
0x000100002a727824ULL, 0x004fe200078e00ffULL, 0x000000016b6b1812ULL, 0x000fcc00078efcffULL,
0x0000002800da7306ULL, 0x000e620000205400ULL, 0x000000017b7b4812ULL, 0x008fce00078efcffULL,
0x0000007400d97306ULL, 0x000ff00000209400ULL, 0x0000007400dc7306ULL, 0x000ea20000205400ULL,
0x000000dad700720bULL, 0x002fce0003fdd000ULL, 0x0000003300877306ULL, 0x000ff00000009400ULL,
0x0000003300887306ULL, 0x000fe20000005400ULL, 0x000000dcd900720bULL, 0x004fce0003f9d000ULL,
0x00000033004f7306ULL, 0x0003f0000000d400ULL, 0x0000002900b27306ULL, 0x000fe20000009400ULL,
0x0000010033337824ULL, 0x002fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011433ULL,
0x0000002900b37306ULL, 0x000e700000005400ULL, 0x0000002900687306ULL, 0x0004f0000000d400ULL,
0x0000002a00b07306ULL, 0x000fe20000009400ULL, 0x0000010029297824ULL, 0x004fe200078e00ffULL,
0x000000b3b200720bULL, 0x002fc80003fbd000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00af7306ULL, 0x000e6e0000005400ULL, 0x0000000168685812ULL, 0x008fe200078efcffULL,
0x0000002a00637306ULL, 0x0004e2000000d400ULL, 0x000000c3c600720bULL, 0x000fce0003fbd000ULL,
0x0000005e00657306ULL, 0x000fe20000209400ULL, 0x000001002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000afb000720bULL, 0x002fc80003f7d000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000005e00667306ULL, 0x000fe20000205400ULL, 0x0000000167675812ULL, 0x000fe400078efcffULL,
0x000000c0bd00720bULL, 0x000fc80003fbd000ULL, 0x0000000163633812ULL, 0x008fe200078efcffULL,
0x0000005e00337306ULL, 0x000fe2000020d400ULL, 0x0000008d9000720bULL, 0x000fce0003f7d000ULL,
0x00000079005d7306ULL, 0x000fe20000209400ULL, 0x0000000160605812ULL, 0x000fca00078efcffULL,
0x0000000153533812ULL, 0x000fe400078efcffULL, 0x00000079005e7306ULL, 0x000fe20000205400ULL,
0x000000b7ba00720bULL, 0x000fe40003f7d000ULL, 0x000000536060723eULL, 0x000fca00000010ffULL,
0x00000079005f7306ULL, 0x000fec000020d400ULL, 0x0000000130303812ULL, 0x000fe400078efcffULL,
0x00000028007a7306ULL, 0x0002b0000020d400ULL, 0x0000007400797306ULL, 0x000ee2000020d400ULL,
0x00000018ff287819ULL, 0x002fce0000011472ULL, 0x0000003400bb7306ULL, 0x000fe20000209400ULL,
0x000000017a7a6812ULL, 0x004fce00078efcffULL, 0x0000003400be7306ULL, 0x000e620000205400ULL,
0x0000000179794812ULL, 0x008fc800078efcffULL, 0x000000687968723eULL, 0x000fc600000010ffULL,
0x0000003400357306ULL, 0x0004f0000020d400ULL, 0x0000002900db7306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fe40000011437ULL, 0x000000bebb00720bULL, 0x002fca0003fbd000ULL,
0x0000002900de7306ULL, 0x000e700000205400ULL, 0x0000002a00df7306ULL, 0x000fe20000209400ULL,
0x0000000135355812ULL, 0x008fce00078efcffULL, 0x0000002a00e27306ULL, 0x000ea20000205400ULL,
0x000000dedb00720bULL, 0x002fce0003fdd000ULL, 0x0000003400ac7306ULL, 0x000ff00000209400ULL,
0x0000003400ad7306ULL, 0x000fe20000205400ULL, 0x000000e2df00720bULL, 0x004fce0003f9d000ULL,
0x0000003400377306ULL, 0x000ff0000020d400ULL, 0x0000005b006c7306ULL, 0x000ff00000209400ULL,
0x0000005b006d7306ULL, 0x000ff00000205400ULL, 0x0000005b00347306ULL, 0x000ff0000020d400ULL,
0x00000078005a7306ULL, 0x000ff00000209400ULL, 0x00000078005b7306ULL, 0x000ff00000205400ULL,
0x00000078005c7306ULL, 0x000ff0000020d400ULL, 0x0000002b00917306ULL, 0x000ff00000009400ULL,
0x0000002b00947306ULL, 0x000e700000005400ULL, 0x0000002b00567306ULL, 0x0004f0000000d400ULL,
0x0000002900787306ULL, 0x0008e2000020d400ULL, 0x000001002b2b7824ULL, 0x004fe200078e00ffULL,
0x000000949100720bULL, 0x002fc80003f3d000ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000004400ab7306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x010fcc00000114d3ULL,
0x0000000156561812ULL, 0x008fe200078efcffULL, 0x0000004400ae7306ULL, 0x000e620000205400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x000000898c00720bULL, 0x000fe20003f3d000ULL,
0x000100002f897824ULL, 0x000fc800078e00ffULL, 0x0000002a00747306ULL, 0x0004e2000020d400ULL,
0x00000018ff897819ULL, 0x000fce0000011489ULL, 0x0000002900d37306ULL, 0x000fe20000209400ULL,
0x000000aeab00720bULL, 0x002fe20003f5d000ULL, 0x000100002d2a7824ULL, 0x004fe200078e00ffULL,
0x0000000150501812ULL, 0x000fe400078efcffULL, 0x000000707100720bULL, 0x000fe40003f3d000ULL,
0x00000018ffa97819ULL, 0x000fe2000001142aULL, 0x0000002900d67306ULL, 0x000e620000205400ULL,
0x0000000174744812ULL, 0x008fe400078efcffULL, 0x000000c2bf00720bULL, 0x000fca0003f9d000ULL,
0x0000002800dd7306ULL, 0x000fe40000209400ULL, 0x0000000132321812ULL, 0x000fcc00078efcffULL,
0x0000002800e07306ULL, 0x000fe20000205400ULL, 0x000000d6d300720bULL, 0x002fe40003fdd000ULL,
0x0000000164644812ULL, 0x000fca00078efcffULL, 0x0000002800727306ULL, 0x0003f0000020d400ULL,
0x0000002b00a67306ULL, 0x000fe20000209400ULL, 0x000100002c287824ULL, 0x002fce00078e00ffULL,
0x0000002b00a57306ULL, 0x000ff00000205400ULL, 0x0000002b009f7306ULL, 0x0003f0000020d400ULL,
0x00000029006f7306ULL, 0x0004e2000020d400ULL, 0x00000007022b7812ULL, 0x002fc800078ec0ffULL,
0x000000082ba77812ULL, 0x000fc600078ef802ULL, 0x0000004400777306ULL, 0x000e62000020d400ULL,
0x00000018ff297819ULL, 0x004fe40000011428ULL, 0x0000004b02287211ULL, 0x000fe400078fe0ffULL,
0x000000044b4b7810ULL, 0x000fc60007ffe0ffULL, 0x0000002900a07306ULL, 0x000fe20000209400ULL,
0x000000016f6f6812ULL, 0x008fe400078efcffULL, 0x000000858a00720bULL, 0x000fe20003fdd000ULL,
0x000001002f8a7824ULL, 0x000fe200078e00ffULL, 0x000000566f56723eULL, 0x000fc600000010ffULL,
0x0000002900a17306ULL, 0x000fe20000205400ULL, 0x0000000177772812ULL, 0x002fe400078efcffULL,
0x000000d2cf00720bULL, 0x000fe40003f5d000ULL, 0x00000018ff8a7819ULL, 0x000fc6000001148aULL,
0x0000002900957306ULL, 0x0003e2000020d400ULL, 0x0000000151516812ULL, 0x000fe400078efcffULL,
0x000000adac00720bULL, 0x000fe40003fdd000ULL, 0x000000513030723eULL, 0x000fc600000010ffULL,
0x00000045008f7306ULL, 0x000fe20000209400ULL, 0x0000000728297812ULL, 0x042fe400078e78a7ULL,
0x0000000228287810ULL, 0x000fe40007ffe0ffULL, 0x0000000173732812ULL, 0x000fe200078efcffULL,
0x00000020a7297824ULL, 0x000fe200078e0229ULL, 0x000000e0dd00720bULL, 0x000fe20003f5d000ULL,
0x0000004500927306ULL, 0x000e620000205400ULL, 0x0000000137376812ULL, 0x000fe200078efcffULL,
0x0000001029297824ULL, 0x000fc600078e00ffULL, 0x000000503750723eULL, 0x000fc600000010ffULL,
0x0000002c00697306ULL, 0x000fe80000009400ULL, 0x0000000172722812ULL, 0x000fe400078efcffULL,
0x000000a5a600720bULL, 0x000fe40003f5d000ULL, 0x0000002c006a7306ULL, 0x000ea20000005400ULL,
0x000000928f00720bULL, 0x002fe40003f9d000ULL, 0x000000637272723eULL, 0x000fca00000010ffULL,
0x0000002c004e7306ULL, 0x0003e6000000d400ULL, 0x000000019f9f2812ULL, 0x000fe400078efcffULL,
0x000000888700720bULL, 0x000fe20003f5d000ULL, 0x000001002e887824ULL, 0x000fe400078e00ffULL,
0x00000045004c7306ULL, 0x000ee2000020d400ULL, 0x000001002c2c7824ULL, 0x002fe200078e00ffULL,
0x0000006a6900720bULL, 0x004fc40003fdd000ULL, 0x000000786b69723eULL, 0x000fe400000010ffULL,
0x00000018ffa87819ULL, 0x000fe4000001142cULL, 0x00000048007e7306ULL, 0x000fe20000209400ULL,
0x00000007282c7812ULL, 0x000fe400078e78a7ULL, 0x000000002928783bULL, 0x000e620000000200ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000020a7a77824ULL, 0x000fe200078e022cULL,
0x000000849b2c723eULL, 0x000fe200000010ffULL, 0x00000048007d7306ULL, 0x000ea20000205400ULL,
0x000000014c4c4812ULL, 0x008fc400078efcffULL, 0x000000b6b500720bULL, 0x000fe40003f9d000ULL,
0x000000014e4e6812ULL, 0x000fe400078efcffULL, 0x000000014f4f2812ULL, 0x000fe200078efcffULL,
0x0000004800447306ULL, 0x000ee2000020d400ULL, 0x000000a1a000720bULL, 0x000fce0003f5d000ULL,
0x00000047008e7306ULL, 0x000fe20000209400ULL, 0x0000007d7e00720bULL, 0x004fe40003f7d000ULL,
0x0000000131314812ULL, 0x000fc600078efcffULL, 0x0000000195952812ULL, 0x000fe400078efcffULL,
0x00000047008b7306ULL, 0x000eac0000205400ULL, 0x0000000144443812ULL, 0x008fe400078efcffULL,
0x0000004900767306ULL, 0x000fe20000209400ULL, 0x0000006d6c00720bULL, 0x000fe20003f7d000ULL,
0x000000682814723cULL, 0x002fec0000041814ULL, 0x0000004900757306ULL, 0x000e620000205400ULL,
0x0000008b8e00720bULL, 0x004fca0003fbd000ULL, 0x0000000134343812ULL, 0x000fe400078efcffULL,
0x0000002d00627306ULL, 0x000fe20000009400ULL, 0x000000666500720bULL, 0x000fce0003f7d000ULL,
0x0000002d00617306ULL, 0x000fe20000005400ULL, 0x000000757600720bULL, 0x002fe40003f9d000ULL,
0x0000006e7b76723eULL, 0x000fc600000010ffULL, 0x0000000133333812ULL, 0x000fe400078efcffULL,
0x0000002d004d7306ULL, 0x0003e2000000d400ULL, 0x000000593600720bULL, 0x000fce0003f7d000ULL,
0x0000004700467306ULL, 0x000ea2000020d400ULL, 0x000001002d2d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff857819ULL, 0x000fe4000001142dULL, 0x0000004900457306ULL, 0x000e62000020d400ULL,
0x0000009d862d723eULL, 0x000fe200000010ffULL, 0x000100002e867824ULL, 0x000fe200078e00ffULL,
0x0000007c779d723eULL, 0x000fe400000010ffULL, 0x0000007a7377723eULL, 0x000fe400000010ffULL,
0x00000018ff867819ULL, 0x000fe20000011486ULL, 0x000000a800a27306ULL, 0x000fe20000209400ULL,
0x0000002c2818723cULL, 0x000fe20000041818ULL, 0x0000000146465812ULL, 0x004fc400078efcffULL,
0x000000989700720bULL, 0x000fe40003fbd000ULL, 0x000000746773723eULL, 0x000fe400000010ffULL,
0x000000a800a37306ULL, 0x000ea20000205400ULL, 0x00000083962c723eULL, 0x000fe200000010ffULL,
0x0000009c2824723cULL, 0x040fe20000041824ULL, 0x00000099822d723eULL, 0x000fe400000010ffULL,
0x0000000145454812ULL, 0x002fe400078efcffULL, 0x0000000158583812ULL, 0x000fe200078efcffULL,
0x000000a900a47306ULL, 0x000fe20000209400ULL, 0x0000000155555812ULL, 0x000fe200078efcffULL,
0x0000002c2808723cULL, 0x000fe20000041808ULL, 0x000000616200720bULL, 0x000fc40003fbd000ULL,
0x000000554451723eULL, 0x000fe400000010ffULL, 0x0000004f3244723eULL, 0x000fe200000010ffULL,
0x000000a900917306ULL, 0x000e620000205400ULL, 0x000000a3a200720bULL, 0x004fe20003f9d000ULL,
0x00000010a72c7824ULL, 0x000fe200078e00ffULL, 0x00000076281c723cULL, 0x000fe2000004181cULL,
0x000000354c61723eULL, 0x000fe400000010ffULL, 0x000000314631723eULL, 0x000fe400000010ffULL,
0x0000002e00577306ULL, 0x000fe20000009400ULL, 0x000000014d4d5812ULL, 0x000fc400078efcffULL,
0x000000722810723cULL, 0x000fe20000041810ULL, 0x0000005b5a00720bULL, 0x000fe40003fbd000ULL,
0x000000344545723eULL, 0x000fe400000010ffULL, 0x0000002e00547306ULL, 0x000ea20000005400ULL,
0x00000091a400720bULL, 0x002fe40003fdd000ULL, 0x0000004e9532723eULL, 0x000fca00000010ffULL,
0x0000002f00497306ULL, 0x000fe20000009400ULL, 0x000000015c5c5812ULL, 0x000fce00078efcffULL,
0x0000002f00527306ULL, 0x000e620000005400ULL, 0x000000545700720bULL, 0x004fe40003f3d000ULL,
0x0000009f6457723eULL, 0x000fca00000010ffULL, 0x0000002f00487306ULL, 0x0005e4000000d400ULL,
0x00000056280c723cULL, 0x000fec000004180cULL, 0x000000a8009a7306ULL, 0x000ee2000020d400ULL,
0x00000093802f723eULL, 0x004fe400000010ffULL, 0x000000524900720bULL, 0x002fca0003f5d000ULL,
0x000000a900907306ULL, 0x000e70000020d400ULL, 0x0000008500877306ULL, 0x000fe20000209400ULL,
0x000000019a9a4812ULL, 0x008fe400078efcffULL, 0x0000000148482812ULL, 0x000fc400078efcffULL,
0x0000009a3333723eULL, 0x000fc600000010ffULL, 0x0000008500847306ULL, 0x000ea20000205400ULL,
0x0000000190906812ULL, 0x002fc800078efcffULL, 0x0000004d9090723eULL, 0x000fc600000010ffULL,
0x0000008600807306ULL, 0x000ff00000209400ULL, 0x00000086007d7306ULL, 0x000e620000205400ULL,
0x000000848700720bULL, 0x004fce0003f9d000ULL, 0x0000002e00477306ULL, 0x0004f0000000d400ULL,
0x0000008500837306ULL, 0x000f22000020d400ULL, 0x000000819e2e723eULL, 0x004fe400000010ffULL,
0x0000007d8000720bULL, 0x002fca0003fdd000ULL, 0x0000002e2820723cULL, 0x000fe20000041820ULL,
0x0000008a00287306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x0000000147471812ULL, 0x008fe400078efcffULL, 0x0000000183834812ULL, 0x010fc800078efcffULL,
0x0000008a002b7306ULL, 0x000ea20000205400ULL, 0x0000005e5d00720bULL, 0x000fe40003f9d000ULL,
0x000000835891723eULL, 0x000fca00000010ffULL, 0x00000086006e7306ULL, 0x000eec000020d400ULL,
0x000000015f5f4812ULL, 0x000fe400078efcffULL, 0x00000088006a7306ULL, 0x000fe20000209400ULL,
0x0000002b2800720bULL, 0x004fce0003f3d000ULL, 0x00000088006b7306ULL, 0x000ea20000205400ULL,
0x000000016e6e6812ULL, 0x008fc800078efcffULL, 0x000000476e6e723eULL, 0x000fc600000010ffULL,
0x0000008900547306ULL, 0x000fe20000209400ULL, 0x000000602c18723cULL, 0x042fee0000041818ULL,
0x0000008900297306ULL, 0x000e620000205400ULL, 0x0000006b6a00720bULL, 0x004fe20003f7d000ULL,
0x000000302c08723cULL, 0x040fec0000041808ULL, 0x0000008a008a7306ULL, 0x000ea4000020d400ULL,
0x000000502c20723cULL, 0x040fec0000041820ULL, 0x0000008800637306ULL, 0x000ee2000020d400ULL,
0x000000295400720bULL, 0x002fe20003fdd000ULL, 0x000000442c24723cULL, 0x040fec0000041824ULL,
0x0000008900897306ULL, 0x000e62000020d400ULL, 0x000000018a8a1812ULL, 0x004fe200078efcffULL,
0x000000322c1c723cULL, 0x000fe2000004181cULL, 0x000000044a00780cULL, 0x000fc40003f25270ULL,
0x0000008a5f49723eULL, 0x000fe400000010ffULL, 0x0000000163633812ULL, 0x008fc600078efcffULL,
0x000000902c14723cULL, 0x000fe20000041814ULL, 0x000000635c6f723eULL, 0x000fe400000010ffULL,
0x0000000189896812ULL, 0x002fca00078efcffULL, 0x0000006e2c10723cULL, 0x000fe20000041810ULL,
0x000000488948723eULL, 0x000fce00000010ffULL, 0x000000482c0c723cULL, 0x000fe2000004180cULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff437224ULL, 0x000fe200078e0041ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd25000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003c287f8cULL, 0x000fe2000c80043fULL, 0x000000203a207220ULL, 0x040fe40000410000ULL,
0x000000213a217220ULL, 0x040fe20000410000ULL, 0x000004003c2b7984ULL, 0x000e620000000800ULL,
0x000000243a247220ULL, 0x040fe40000410000ULL, 0x000000183a187220ULL, 0x040fe40000410000ULL,
0x000000193a197220ULL, 0x000fc40000410000ULL, 0x0000001a3a2a7220ULL, 0x040fe40000410000ULL,
0x0000001b3a2c7220ULL, 0x040fe40000410000ULL, 0x0000000a3a2d7220ULL, 0x040fe40000410000ULL,
0x0000000b3a2e7220ULL, 0x040fe40000410000ULL, 0x000000223a2f7220ULL, 0x040fe40000410000ULL,
0x000000253a257220ULL, 0x000fc40000410000ULL, 0x000000083a087220ULL, 0x040fe40000410000ULL,
0x000000093a097220ULL, 0x040fe40000410000ULL, 0x000000233a307220ULL, 0x040fe40000410000ULL,
0x0000001c3a1c7220ULL, 0x040fe40000410000ULL, 0x0000001d3a1d7220ULL, 0x040fe40000410000ULL,
0x0000001e3a317220ULL, 0x000fc40000410000ULL, 0x0000001f3a327220ULL, 0x040fe40000410000ULL,
0x000000143a0a7220ULL, 0x040fe40000410000ULL, 0x000000153a0b7220ULL, 0x040fe40000410000ULL,
0x000000163a337220ULL, 0x040fe40000410000ULL, 0x000000173a347220ULL, 0x040fe20000410000ULL,
0x800000002bff7812ULL, 0x002fe20007804829ULL, 0x000000123a357220ULL, 0x000fc40000410000ULL,
0x000000133a367220ULL, 0x040fe40000410000ULL, 0x0000000c3a1e7220ULL, 0x040fe40000410000ULL,
0x0000000d3a1f7220ULL, 0x040fe40000410000ULL, 0x0000000e3a0c7220ULL, 0x040fe40000410000ULL,
0x0000000f3a0d7220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fc400078e0020ULL,
0x000000ffff137224ULL, 0x000fe400078e0021ULL, 0x000000ffff147224ULL, 0x000fe400078e0024ULL,
0x000000103a1a7220ULL, 0x040fe40000410000ULL, 0x000000113a1b7220ULL, 0x000fe40000410000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0018ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0019ULL,
0x000000ffff157224ULL, 0x000fe400078e0025ULL, 0x000000ffff207224ULL, 0x000fe400078e002aULL,
0x000000ffff217224ULL, 0x000fe400078e002cULL, 0x000000ffff227224ULL, 0x000fe400078e002dULL,
0x000000ffff237224ULL, 0x000fe400078e002eULL, 0x000000ffff247224ULL, 0x000fc400078e002fULL,
0x000000263a267220ULL, 0x040fe40000410000ULL, 0x000000273a277220ULL, 0x000fe40000410000ULL,
0x000000ffff107224ULL, 0x000fe400078e0008ULL, 0x000000ffff117224ULL, 0x000fe400078e0009ULL,
0x000000ffff167224ULL, 0x000fe400078e001cULL, 0x000000ffff177224ULL, 0x000fc400078e001dULL,
0x000000ffff187224ULL, 0x000fe400078e000aULL, 0x000000ffff197224ULL, 0x000fe400078e000bULL,
0x000000ffff257224ULL, 0x000fe400078e0030ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0031ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2c7224ULL, 0x000fc400078e0033ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0034ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0035ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0036ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe400078e000cULL,
0x000000ffff317224ULL, 0x000fe200078e000dULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x000004003c097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004021d7824ULL, 0x000fe200078e00ffULL,
0x0000003f0400720cULL, 0x000fc80003f05270ULL, 0xfffffff01d097812ULL, 0x000fca00078ec0ffULL,
0x00000080001c7824ULL, 0x000fca00078e0209ULL, 0x010400001c087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002020c7824ULL, 0x000fe400078e00ffULL,
0x0000000103407824ULL, 0x000fc600078e0a40ULL, 0x000000060c0d7812ULL, 0x000fc800078ec0ffULL,
0x000000010d297812ULL, 0x040fe400078efcffULL, 0x000000080d337812ULL, 0x000fe400078efcffULL,
0x000000402900720cULL, 0x080fe40003f26070ULL, 0x000000100d297812ULL, 0x000fe400078efcffULL,
0x000000403300720cULL, 0x080fe40003f06070ULL, 0x000000402900720cULL, 0x000fc40003fc6070ULL,
0x000000110d337812ULL, 0x040fe400078efcffULL, 0x000000180d297812ULL, 0x040fe400078efcffULL,
0x000000400d00720cULL, 0x080fe40003f46070ULL, 0x000000403300720cULL, 0x080fe40003fa6070ULL,
0x000000402900720cULL, 0x000fe40003f66070ULL, 0x000000090d357812ULL, 0x000fc400078efcffULL,
0x000000190d337812ULL, 0x040fe400078efcffULL, 0x000000200d297812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x000000403500720cULL, 0x080fe40003f86070ULL, 0x000000403300720cULL, 0x080fe40003f46070ULL,
0x000000402900720cULL, 0x000fe40003f26070ULL, 0x000000210d337812ULL, 0x040fe400078efcffULL,
0x000000280d297812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x000000403300720cULL, 0x080fe40003f06070ULL,
0x000000402900720cULL, 0x000fe40003f86070ULL, 0x000000290d337812ULL, 0x000fc400078efcffULL,
0x000000300d297812ULL, 0x000fe400078efcffULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x000000403300720cULL, 0x000fc40003fc6070ULL,
0x000000402900720cULL, 0x000fe40003fa6070ULL, 0x000000310d337812ULL, 0x040fe400078efcffULL,
0x000000380d297812ULL, 0x040fe400078efcffULL, 0x000000390d0d7812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x000000403300720cULL, 0x080fe40003f66070ULL, 0x000000402900720cULL, 0x000fc40003f46070ULL,
0x000000400d00720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff30307808ULL, 0x000fc40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff31317808ULL, 0x000fe40004800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0x0000000f080d7209ULL, 0x004fe40007810000ULL,
0x0000002009087209ULL, 0x000fe40007810000ULL, 0x0000000e0d0d7209ULL, 0x000fe40007810000ULL,
0x0000002108097209ULL, 0x000fc40007810000ULL, 0x000000100d087209ULL, 0x000fe40007810000ULL,
0x00000022090c7209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x000000230c0d7209ULL, 0x000fe40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x000000240d0c7209ULL, 0x000fc40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x000000250c0d7209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x000000260d0c7209ULL, 0x000fe40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x000000270c0d7209ULL, 0x000fc40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002a0d0c7209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002b0c0d7209ULL, 0x000fe40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002c0d0c7209ULL, 0x000fc40007810000ULL, 0x0000001908097209ULL, 0x000fe40007810000ULL,
0x0000002d0c0d7209ULL, 0x000fe40007810000ULL, 0x0000001a09087209ULL, 0x000fe40007810000ULL,
0x0000002e0d0c7209ULL, 0x000fe40007810000ULL, 0x0000001b08097209ULL, 0x000fe40007810000ULL,
0x0000002f0c0d7209ULL, 0x000fc40007810000ULL, 0x0000001e09087209ULL, 0x000fe40007810000ULL,
0x000000300d0c7209ULL, 0x000fe40007810000ULL, 0x0000001f08097209ULL, 0x000fe40007810000ULL,
0x000000310c337209ULL, 0x000fe20007810000ULL, 0x00001b127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0009087f89ULL, 0x0004e400000e0000ULL, 0x0000000809347209ULL, 0x008fe20007810000ULL,
0x00001b627f007947ULL, 0x000fea000b800000ULL, 0x0c401f0033087f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x004ea800000e0000ULL, 0x0c401f000b287f89ULL, 0x000f2200000e0000ULL,
0x00000008330c7209ULL, 0x008fc60007810000ULL, 0x0c201f0034087f89ULL, 0x000ee200000e0000ULL,
0x000000090a0d7209ULL, 0x004fc60007810000ULL, 0x0c201f000c097f89ULL, 0x000ea200000e0000ULL,
0x000000280b287209ULL, 0x010fc60007810000ULL, 0x0c201f000d327f89ULL, 0x002e6800000e0000ULL,
0x0c201f0028297f89ULL, 0x00092200000e0000ULL, 0x0000000834087209ULL, 0x008fe40007810000ULL,
0x000000090c097209ULL, 0x004fe40007810000ULL, 0x000000320d0a7209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fc40000000000ULL,
0x00000005ff337e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL, 0x0000000000087886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL,
0x0000000f000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b12127823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b13137823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL, 0x0000000e000d7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b15157823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b19197823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f0b7823ULL, 0x000fe2000001080bULL, 0x0000000c0d0c723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b091f7820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b22227823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b23237823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081fULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000010110e723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b25257823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001081fULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081fULL, 0x00000022000f7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b30307823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b311f7823ULL, 0x000fe2000001081fULL,
0x0000002300327308ULL, 0x0008a20000000800ULL, 0x3f8000003322783eULL, 0x008fe200000010ffULL,
0x0000000fff337424ULL, 0x000fe200078e00ffULL, 0x00000020210d723eULL, 0x002fca00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000ffff237224ULL, 0x010fe200078e0022ULL,
0x0000000f320f723eULL, 0x004fcc00000010ffULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x000000220c34723cULL, 0x000fe200000418ffULL, 0x000000121310723eULL, 0x002fcc00000010ffULL,
0x0000001500157308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x000000141512723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000242511723eULL, 0x004fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000262713723eULL, 0x002fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000221034723cULL, 0x000fee0000041834ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x000000181916723eULL, 0x004fe400000010ffULL, 0xfffffffc02187812ULL, 0x000fc800078ec0ffULL,
0x0000001833337219ULL, 0x000fe200000006ffULL, 0x0000002c002c7308ULL, 0x000fe60000000800ULL,
0x00000000332073a1ULL, 0x000ea200000e8000ULL, 0x00000000330573c4ULL, 0x000ee80000004000ULL,
0x0000002d002d7308ULL, 0x000f220000000800ULL, 0x0000002a2b15723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000002c2d17723eULL, 0x010fce00000010ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000833ff7c12ULL, 0x004fe2000f804020ULL,
0x000000221434723cULL, 0x000fec0000041834ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x0000001a1b18723eULL, 0x002fce00000010ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x0000001e0b1a723eULL, 0x004fe400000010ffULL, 0x00000028290b7209ULL, 0x000fca0007810000ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x0000002e2f19723eULL, 0x002fe400000010ffULL, 0x000000301f1b723eULL, 0x004fce00000010ffULL,
0x000000221834723cULL, 0x000fe20000041834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000175205008947ULL, 0x008fde000b800000ULL, 0x001c1fff342c7589ULL, 0x0002a400000e0000ULL,
0x00000000331e73a1ULL, 0x000ee200000e8000ULL, 0x00000000330573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x0000000833ff7c12ULL, 0x008fda000f80401eULL,
0x0000176205008947ULL, 0x010fea000b800000ULL, 0x001c1fff362d7589ULL, 0x00072800000e0000ULL,
0x001c1fff2e2e7589ULL, 0x00066800000e0000ULL, 0x001c1fff002f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1e7819ULL, 0x000fe40000011602ULL, 0x0000000c1d437812ULL, 0x000fc400078ec0ffULL,
0x000000071e1f7812ULL, 0x040fe200078ec0ffULL, 0x000000081e247824ULL, 0x040fe200078e00ffULL,
0x0000001eff227212ULL, 0x000fe200078e33ffULL, 0x000000081e207824ULL, 0x000fe200078e00ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081e337824ULL, 0x04afe200078e00ffULL,
0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824217812ULL, 0x100fe400078ee21fULL,
0x0000000120237812ULL, 0x100fe200078ef61fULL, 0x000000081e4f7824ULL, 0x000fe200078e00ffULL,
0x0000000220257812ULL, 0x100fe200078ef61fULL, 0x000000081e247824ULL, 0x000fe200078e00ffULL,
0x0000000320277812ULL, 0x000fc400078ef61fULL, 0x0000000420297812ULL, 0x140fe400078ef61fULL,
0x00000005202b7812ULL, 0x140fe400078ef61fULL, 0x0000000620317812ULL, 0x000fe200078ef61fULL,
0x000000081e207824ULL, 0x040fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe400078ee222ULL,
0x0000001eff227212ULL, 0x000fe400078e33ffULL, 0x000000071e1f7812ULL, 0x000fc400078ec0ffULL,
0x0000a000001e7811ULL, 0x000fe400078e58ffULL, 0xfffffff824357812ULL, 0x100fe400078ee21fULL,
0x0000000120377812ULL, 0x140fe200078ef61fULL, 0x00000010211d7824ULL, 0x100fe200078e021eULL,
0x0000000220457812ULL, 0x140fe200078ef61fULL, 0x0000001029247824ULL, 0x100fe200078e021eULL,
0x0000000320477812ULL, 0x040fe200078ef61fULL, 0x00000001431d7824ULL, 0x000fe200078e021dULL,
0x0000000420497812ULL, 0x140fe200078ef61fULL, 0x000000102b267824ULL, 0x100fe200078e021eULL,
0x00000005204b7812ULL, 0x140fe200078ef61fULL, 0x0000001031287824ULL, 0x100fe200078e021eULL,
0x00000006204d7812ULL, 0x000fe200078ef61fULL, 0x00000010231f7824ULL, 0x000fe200078e021eULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee222ULL, 0x0000001025207824ULL, 0x100fe200078e021eULL,
0x0000000c1d007388ULL, 0x0003e20000000800ULL, 0x0000001027227824ULL, 0x000fc400078e021eULL,
0x00000001431f7824ULL, 0x040fe400078e021fULL, 0x0000000143217824ULL, 0x000fe400078e0220ULL,
0x00000010332a7824ULL, 0x000fe200078e021eULL, 0x0000000e1f007388ULL, 0x0007e20000000800ULL,
0x0000000143237824ULL, 0x000fe400078e0222ULL, 0x0000001035307824ULL, 0x000fe200078e021eULL,
0x0000001021007388ULL, 0x0007e20000000800ULL, 0x0000000143257824ULL, 0x000fc400078e0224ULL,
0x0000001037317824ULL, 0x000fe200078e021eULL, 0x0000001223007388ULL, 0x0007e20000000800ULL,
0x0000000143277824ULL, 0x000fe400078e0226ULL, 0x0000001045327824ULL, 0x000fe200078e021eULL,
0x0000001425007388ULL, 0x0007e20000000800ULL, 0x0000000143297824ULL, 0x000fe400078e0228ULL,
0x0000001047337824ULL, 0x000fe200078e021eULL, 0x0000001627007388ULL, 0x0007e20000000800ULL,
0x00000001432b7824ULL, 0x000fc400078e022aULL, 0x0000001049347824ULL, 0x100fe200078e021eULL,
0x0000001829007388ULL, 0x0007e20000000800ULL, 0x000000104b357824ULL, 0x100fe400078e021eULL,
0x000000104d367824ULL, 0x100fe200078e021eULL, 0x0000001a2b007388ULL, 0x0007e20000000800ULL,
0x000000104f377824ULL, 0x000fe400078e021eULL, 0x0000000143307824ULL, 0x040fe400078e0230ULL,
0x00000001431e7824ULL, 0x000fc400078e0231ULL, 0x0000000143327824ULL, 0x040fe200078e0232ULL,
0x0000000d30007388ULL, 0x0007e20000000800ULL, 0x00000001430c7824ULL, 0x042fe400078e0233ULL,
0x0000000143347824ULL, 0x040fe200078e0234ULL, 0x0000000f1e007388ULL, 0x0007e20000000800ULL,
0x0000000143207824ULL, 0x040fe400078e0235ULL, 0x0000000143367824ULL, 0x040fe200078e0236ULL,
0x0000001132007388ULL, 0x0007e20000000800ULL, 0x0000000143227824ULL, 0x000fc600078e0237ULL,
0x000000130c007388ULL, 0x0007e80000000800ULL, 0x0000001534007388ULL, 0x0007e80000000800ULL,
0x0000001720007388ULL, 0x0007e80000000800ULL, 0x0000001936007388ULL, 0x0007e80000000800ULL,
0x0000001b22007388ULL, 0x0007e80000000800ULL, 0x010000081c008388ULL, 0x0007e80000000c00ULL,
0x0102002c1c008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003eff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003eff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030004047a10ULL, 0x000fe20007ffe0ffULL, 0x000018003eff7f8cULL, 0x0003e6000c80043fULL,
0x000000060400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb6c000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff2f7807ULL, 0x008fe20004800000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0001e68000307802ULL, 0x000fe40000000f00ULL, 0x0000130000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e002fULL, 0xfffe316000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2f7807ULL, 0x000fe20004800000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0001e6e000307802ULL, 0x000fe40000000f00ULL, 0x000012a000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e002fULL, 0xfffe318000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4f7424ULL, 0x000fe200078e00ffULL, 0x0001e74000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000120000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e002fULL, 0xfffe31c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4f7424ULL, 0x000fe200078e00ffULL, 0x0001e7a000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fc400078e00ffULL, 0x000011a000007944ULL, 0x03cfea0003c00000ULL,
0xfffe31a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x000fe200078e001bULL,
0x0001e80000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000114000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6d7224ULL, 0x004fe200078e002fULL, 0xfffe351000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x002fe200078e00f6ULL, 0x0001e87000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x000010d000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff6c7224ULL, 0x004fe200078e002fULL,
0xfffe34d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff4f7424ULL, 0x000fe200078e00ffULL,
0x0001e8d000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000107000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff747224ULL, 0x004fe200078e002fULL,
0xfffe5b2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x002fe200078e00f6ULL,
0x0001e94000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000100000007944ULL, 0x004fea0003c00000ULL,
0x000000ffffb67224ULL, 0x004fe200078e002fULL, 0xfffe5ad000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2f7807ULL, 0x008fe20004800000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0001e9a000307802ULL, 0x000fe40000000f00ULL, 0x00000fe000007944ULL, 0x034fea0003c00000ULL,
0xfffe80c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2f7807ULL, 0x000fe20004800000ULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x0001e9f000307802ULL, 0x000fe40000000f00ULL,
0x00000f9000007944ULL, 0x034fea0003c00000ULL, 0xfffe80f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x002fe200078e003aULL, 0x0001ea5000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x00000ef000007944ULL, 0x034fea0003c00000ULL, 0xfffe814000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x002fe200078e003aULL, 0x0001eac000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff587224ULL, 0x000fc400078e00f6ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x00000e8000007944ULL, 0x030fea0003c00000ULL,
0xfffe81f000007947ULL, 0x000fea000383ffffULL, 0x0000001fff4f7424ULL, 0x000fe200078e00ffULL,
0x0001eb1000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x00000e3000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff737224ULL, 0x004fe200078e002fULL,
0xfffe845000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x002fe200078e00f6ULL,
0x0001eb8000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x00000dc000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e002fULL, 0xfffe840000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4f7424ULL, 0x000fe200078e00ffULL, 0x0001ebe000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fc400078e00ffULL, 0x00000d6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffffb97224ULL, 0x004fe200078e002fULL, 0xfffea7f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x002fe200078e00f6ULL, 0x0001ec5000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x00000cf000007944ULL, 0x004fea0003c00000ULL, 0x000000ffffba7224ULL, 0x004fe200078e002fULL,
0xfffea7a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2f7807ULL, 0x008fe20004800000ULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x0001ecb000307802ULL, 0x000fe40000000f00ULL,
0x00000cd000007944ULL, 0x034fea0003c00000ULL, 0xfffecd1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2f7807ULL, 0x000fe20004800000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0001ed0000307802ULL, 0x000fe40000000f00ULL, 0x00000c8000007944ULL, 0x034fea0003c00000ULL,
0xfffecd4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e003aULL,
0x0001ed6000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x00000be000007944ULL, 0x034fea0003c00000ULL,
0xfffecd9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e003aULL,
0x0001edd000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff587224ULL, 0x000fc400078e00f6ULL,
0x0000001fff4f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x00000b7000007944ULL, 0x030fea0003c00000ULL, 0xfffece4000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4f7424ULL, 0x000fe200078e00ffULL, 0x0001ee2000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x00000b2000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff737224ULL, 0x004fe200078e002fULL, 0xfffed0a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x002fe200078e00f6ULL, 0x0001ee9000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x00000ab000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff6b7224ULL, 0x004fe200078e002fULL,
0xfffed05000007947ULL, 0x000fea000383ffffULL, 0x0000001fff4f7424ULL, 0x000fe200078e00ffULL,
0x0001eef000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x00000a5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffffb97224ULL, 0x004fe200078e002fULL,
0xfffef44000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x002fe200078e00f6ULL,
0x0001ef6000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000009e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffffba7224ULL, 0x004fe200078e002fULL, 0xfffef3f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2f7807ULL, 0x008fe20004800000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0001efc000307802ULL, 0x000fe40000000f00ULL, 0x000009c000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e002fULL, 0xffff195000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2f7807ULL, 0x000fe20004800000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0001f02000307802ULL, 0x000fe40000000f00ULL, 0x0000096000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e002fULL, 0xffff197000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4f7424ULL, 0x004fe200078e00ffULL, 0x0001f08000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000008c000007944ULL, 0x032fea0003c00000ULL,
0xffff19d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x002fe200078e00f6ULL,
0x0001f0e000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x0000086000007944ULL, 0x030fea0003c00000ULL,
0xffff1a9000007947ULL, 0x000fea000383ffffULL, 0x0000001fff4f7424ULL, 0x000fe200078e00ffULL,
0x0001f13000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x0000081000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff597224ULL, 0x004fe200078e002fULL,
0xffff1cf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff587224ULL, 0x002fe200078e00f6ULL,
0x0001f1a000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff4f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fe400078e00ffULL, 0x000007a000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff4e7224ULL, 0x004fe200078e002fULL, 0xffff1ca000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4f7424ULL, 0x000fe200078e00ffULL, 0x0001f20000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff337424ULL, 0x000fc400078e00ffULL, 0x0000074000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e002fULL, 0xffff40b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff587224ULL, 0x002fe200078e00f6ULL, 0x0001f27000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff4f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fe400078e00ffULL,
0x000006d000007944ULL, 0x004fea0003c00000ULL, 0x000000fffff67224ULL, 0x004fe200078e002fULL,
0xffff406000007947ULL, 0x000fea000383ffffULL, 0x000000ffff297224ULL, 0x000fe200078e0009ULL,
0x0001f2f0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x000fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000061000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0029ULL,
0xffffe48000007947ULL, 0x000fea000383ffffULL, 0x000000ffff297224ULL, 0x000fe200078e0033ULL,
0x0001f370000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000059000007944ULL, 0x024fea0003c00000ULL, 0x0000002933367209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e000aULL, 0x0001f3e0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x000000290a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e000bULL,
0x0001f450000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x000004b000007944ULL, 0x000fea0003c00000ULL, 0x000000290b287209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0034ULL, 0x0001f4c0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000002934087209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0036ULL,
0x0001f530000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x0000002936097209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e000aULL, 0x0001f5a0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000290a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0028ULL,
0x0001f610000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x000002f000007944ULL, 0x000fea0003c00000ULL, 0xffffe26000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x000fe200078e0034ULL, 0x0001f67000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff587224ULL, 0x000fe400078e00ffULL, 0x00001c1fff4f7424ULL, 0x000fe400078e00ffULL,
0x000002d000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff2c7224ULL, 0x004fe200078e002fULL,
0xffffe85000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0036ULL,
0x0001f6e000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x00001c1fff4f7424ULL, 0x000fc400078e00ffULL, 0x0000026000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff587224ULL, 0x002fe200078e00ffULL, 0x0001f73000307802ULL, 0x000fe20000000f00ULL,
0x00001c1fff4f7424ULL, 0x000fc400078e00ffULL, 0x000000ffff2d7224ULL, 0x004fe400078e002fULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff587224ULL, 0x002fe200078e00ffULL,
0x0001f78000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff4f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x004fe400078e002fULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xffffe7d000007947ULL, 0x000fea000383ffffULL, 0x0180000033037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003300038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff33ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000033057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000306ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003300037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff1b7424ULL, 0x000fc800078e00ffULL, 0xfffe07001a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000004000007348ULL, 0x000fe80003800000ULL,
0x0c00003229297389ULL, 0x0002a200000e0035ULL, 0xfffe06c00c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003300007348ULL, 0x000fe80003800000ULL,
0x00000058322f7389ULL, 0x0002a200000e004fULL, 0xfffe068030007950ULL, 0x000fea0003c3ffffULL,
0x000000012f00780cULL, 0x000fe20003f25070ULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000003a00007348ULL, 0x000ff60003800000ULL, 0x00000000002f7806ULL, 0x000fc800048e0100ULL,
0x0000003a2f2f7212ULL, 0x000fe200078ec0ffULL, 0xfffe062030007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000002b0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000920ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000014b0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000014d0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000014e0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001500ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001590ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001598ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000015a8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001780ULL, 0x000000000001fa80ULL, 0xfe00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021200ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000021210ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021210ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000021690ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001590ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001fc70ULL, 0x000000000001fc70ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000021200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000021690ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 137072;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
