/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016cf8ULL, 0x0000000000016878ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000015590ULL, 0x0000000000000270ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000015800ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001559000000000ULL, 0x0000480400000000ULL, 0x0400288080810c00ULL, 0x0000000000005510ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080830828808081ULL, 0x8c08288080860828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808c920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL,
0x0000006800000000ULL, 0x0001559000000000ULL, 0x0000027000000000ULL, 0x0000580400000000ULL,
0x808a288080860900ULL, 0x0900000004042880ULL, 0x288080862880808cULL, 0x0000000e00082f04ULL,
0x0008120400000080ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000eULL, 0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000007c00043704ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x00801b0380005003ULL, 0x0001455000103104ULL, 0x0001457000014560ULL,
0x00f0290400014580ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffff05000000ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000023ffffffffULL, 0x0500002205000022ULL,
0x0500002305000023ULL, 0x0500001f05000023ULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL,
0x0500001f0500001fULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL, 0x000000a000f02804ULL,
0x00002000000000f0ULL, 0x0000211000002090ULL, 0x000024e000002140ULL, 0x00004ae0000025c0ULL,
0x00004bc000004b50ULL, 0x00004f0000004bf0ULL, 0x0000662000004f10ULL, 0x000072c000007250ULL,
0x0000736000007330ULL, 0x0000769000007680ULL, 0x00009a20000099b0ULL, 0x00009ac000009a90ULL,
0x00009e8000009df0ULL, 0x0000bc300000bc20ULL, 0x0000dfb00000c3a0ULL, 0x0000e5300000dfe0ULL,
0x0000e9c00000e550ULL, 0x00013e7000013e60ULL, 0x00013e9000013e80ULL, 0x00013ee000013ec0ULL,
0x00013f1000013f00ULL, 0x0001456000014540ULL, 0x000145b000014570ULL, 0x000145d0000145c0ULL,
0x00015130000150a0ULL, 0x000151f000015190ULL, 0x000152c000015260ULL, 0x0001538000015320ULL,
0x000154b000015410ULL, 0x03d0390400015550ULL, 0x000000ff00000170ULL, 0x000401000001c600ULL,
0x0000000500000250ULL, 0x003f01000001c608ULL, 0x00000005000002c0ULL, 0x003f01000001c610ULL,
0x00000004000004b0ULL, 0x003f01000001c648ULL, 0x000000ff000005c0ULL, 0x000401000001c658ULL,
0x000000ff00000990ULL, 0x000401070001c600ULL, 0x0000000600000b50ULL, 0x003f01010001c610ULL,
0x0000000500001380ULL, 0x003f01070001c648ULL, 0x00000005000013b0ULL, 0x003f01010001c658ULL,
0x0000000500001670ULL, 0x003f01060001c658ULL, 0x00000005000017d0ULL, 0x003f010a0001c658ULL,
0x000000ff00001e70ULL, 0x0008010700000000ULL, 0x0000001d00001ed0ULL, 0x003f010600000000ULL,
0x0000000500001f20ULL, 0x003f010a0001c608ULL, 0x0000001d00002390ULL, 0x003f010a00000000ULL,
0x0000000500004230ULL, 0x003f01010001c658ULL, 0x0000000500004250ULL, 0x003f01010001c610ULL,
0x0000000500004420ULL, 0x003f01060001c658ULL, 0x0000000500004680ULL, 0x003f010a0001c658ULL,
0x0000006b000049d0ULL, 0x0007010700000000ULL, 0x000000ff00004a30ULL, 0x0008010600000000ULL,
0x0000000500004a40ULL, 0x003f010a0001c618ULL, 0x0000001300004e60ULL, 0x003f010a0001c648ULL,
0x00000005000067b0ULL, 0x003f01010001c658ULL, 0x00000005000067d0ULL, 0x003f01010001c620ULL,
0x0000000500006c70ULL, 0x003f01060001c658ULL, 0x0000000500006d80ULL, 0x003f010a0001c658ULL,
0x000000ff00007170ULL, 0x0008010700000000ULL, 0x0000006b000071d0ULL, 0x0007010600000000ULL,
0x00000005000071e0ULL, 0x003f010a0001c628ULL, 0x00000013000075e0ULL, 0x003f010a0001c648ULL,
0x0000000500008f00ULL, 0x003f01010001c658ULL, 0x0000000500008f30ULL, 0x003f01010001c630ULL,
0x00000005000093b0ULL, 0x003f01060001c658ULL, 0x0000000500009580ULL, 0x003f010a0001c658ULL,
0x0000006b000098d0ULL, 0x0007010700000000ULL, 0x000000ff00009940ULL, 0x0008010600000000ULL,
0x0000000500009950ULL, 0x003f010a0001c638ULL, 0x0000005c00009d30ULL, 0x003f010a0001c648ULL,
0x000000050000b370ULL, 0x003f01010001c658ULL, 0x000000050000b3d0ULL, 0x003f01010001c640ULL,
0x0000000b00010820ULL, 0x003f010a0001c600ULL, 0x0000000b00010b30ULL, 0x003f01010001c600ULL,
0x0000000b00010b50ULL, 0x003f010a0001c600ULL, 0x0000000a00013610ULL, 0x003f010a0001c610ULL,
0x0000000a000148d0ULL, 0x003f01010001c608ULL, 0x0000000500014910ULL, 0x003f010a0001c658ULL,
0x0000000500014990ULL, 0x003f010a0001c608ULL, 0x0000001d00014a10ULL, 0x003f010a00000000ULL,
0x0000000500014a90ULL, 0x003f010a0001c658ULL, 0x0000000500014b10ULL, 0x003f010a0001c618ULL,
0x0000001300014b90ULL, 0x003f010a0001c648ULL, 0x0000000500014c10ULL, 0x003f010a0001c658ULL,
0x0000000500014c90ULL, 0x003f010a0001c628ULL, 0x0000001300014d10ULL, 0x003f010a0001c648ULL,
0x0000000500014d80ULL, 0x003f010a0001c658ULL, 0x0000000500014e00ULL, 0x003f010a0001c638ULL,
0x0000005c00014e80ULL, 0x003f010a0001c648ULL, 0x0000000b00014ee0ULL, 0x003f010a0001c600ULL,
0x0000000b00014f60ULL, 0x003f010a0001c600ULL, 0x0000000a00014fe0ULL, 0x003f010a0001c610ULL,
0x00101c0400053803ULL, 0x00010b700000ee00ULL, 0x000148f000010c10ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400581903ULL, 0x005802100000000fULL,
0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL, 0x00000000000000d4ULL,
0x0000000e00000002ULL, 0x0000000000015590ULL, 0x0000000000000044ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x00000000000000aaULL, 0x0000000e00000002ULL, 0x0000000000000000ULL,
0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000f7919ULL, 0x000eae0000002300ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000000000027919ULL, 0x000ea20000002200ULL, 0x0000000000037919ULL, 0x000f2a0000002100ULL,
0x00000300ff007b82ULL, 0x000f620000000800ULL, 0x00000000000e7919ULL, 0x000f6e0000002700ULL,
0x00000000000679c3ULL, 0x000f620000002600ULL, 0x000000010f027824ULL, 0x004fc400078e0202ULL,
0x00001fff0f0f7589ULL, 0x000ea400000e0000ULL, 0x0000008002047824ULL, 0x110fe200078e0203ULL,
0x00000005ff057819ULL, 0x000fe20000011603ULL, 0x00000004ff037e24ULL, 0x008fc6000f8e00ffULL,
0x000000ff0400720cULL, 0x040fe20003f45270ULL, 0x00001fff05027589ULL, 0x000b2200000e0000ULL,
0x000000030400780cULL, 0x000fd60003f04070ULL, 0x0000000000242947ULL, 0x022fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01c60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001a000007945ULL, 0x000fe80003800000ULL, 0x0000000000600947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7fff000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x000fe2000f8e20ffULL,
0x001fffc000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050712caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f640000000000ULL,
0x01c60804073f75b2ULL, 0x0083700008000100ULL, 0xfffffffd00e81947ULL, 0x020fea000393ffffULL,
0x0000000000007918ULL, 0x008fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001fff0000047882ULL, 0x002fe20000000000ULL, 0x7ffc000000057882ULL, 0x000fd60000000000ULL,
0x00000000050712caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f640000000000ULL,
0x01c61004073f75b2ULL, 0x0083700008000100ULL, 0xfffffffd00e81947ULL, 0x020fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000007f0400780cULL, 0x040fe20003f04070ULL,
0x00008400ff187b82ULL, 0x000f620000000800ULL, 0x000000010400780cULL, 0x000fe20003f24070ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x000000ff0f00720cULL, 0x004fca0003f65270ULL,
0x00008e00ff0c7b82ULL, 0x000f680000000a00ULL, 0x0000000000068919ULL, 0x000ea20000008800ULL,
0x0000040000058802ULL, 0x000fc80000000f00ULL, 0x0000065406058816ULL, 0x004fe20000000005ULL,
0xff317217ff068424ULL, 0x000fc800078e00ffULL, 0x0000000404058824ULL, 0x000fca00078e0205ULL,
0x01c4000605008388ULL, 0x0009e20000000800ULL, 0x0000000000381947ULL, 0x022fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404047c11ULL, 0x000fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x018fca0000000000ULL,
0x00000000040712caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01c64804073f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00008200000c7ab9ULL, 0x000fe20000000a00ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000040e0c7825ULL, 0x000fc600078e000cULL,
0x0000000000242947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x00cfe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01c65808043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x00cfec0000010000ULL,
0x0000000000e83947ULL, 0x000fea0003800000ULL, 0x0000000000177919ULL, 0x000ea20000000000ULL,
0x00008800ff0a7b82ULL, 0x000ee20000000a00ULL, 0x0000000402047824ULL, 0x010fe200078e00ffULL,
0x0000000406047899ULL, 0x002fe2000800063fULL, 0x0000001018057824ULL, 0x000fca00078e00ffULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000000405067e24ULL, 0x000fe2000f8e020eULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000417077211ULL, 0x044fe200078fd8ffULL,
0x0000001017047824ULL, 0x000fe200078e00ffULL, 0x0000065405047896ULL, 0x002fe40008000004ULL,
0x0000000707057812ULL, 0x040fe200078ec0ffULL, 0x0000000107097836ULL, 0x040fe40000000000ULL,
0x0000000207117836ULL, 0x000fe20000000000ULL, 0x0000001f05087812ULL, 0x000fe200078e7817ULL,
0x0000000106057824ULL, 0x000fe200078e0207ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000307157836ULL, 0x000fe20000000000ULL, 0x0000000711137812ULL, 0x000fc400078ec0ffULL,
0x0000001f10127812ULL, 0x000fe200078e7817ULL, 0x0000002007107824ULL, 0x000fe200078e0208ULL,
0x0000001f13147812ULL, 0x000fe200078e7817ULL, 0x0000000106077824ULL, 0x000fe200078e0209ULL,
0x000001f004137812ULL, 0x000fe200078ec0ffULL, 0x0000020005047825ULL, 0x008fe200078e000aULL,
0x0000000715167812ULL, 0x000fc600078ec0ffULL, 0x0000002009127824ULL, 0x000fe200078e0212ULL,
0x0000001304047210ULL, 0x000fe20007f1e0ffULL, 0x0000002011147824ULL, 0x000fe200078e0214ULL,
0x0000001f16167812ULL, 0x000fe200078e7817ULL, 0x0000000106097824ULL, 0x040fe400078e0211ULL,
0x0000000106117824ULL, 0x000fe400078e0215ULL, 0x0000020007067825ULL, 0x000fc800078e000aULL,
0x0000020009087825ULL, 0x000fe200078e000aULL, 0x0000001306067210ULL, 0x000fc60007f3e0ffULL,
0x00000200110a7825ULL, 0x000fe200078e000aULL, 0x0000000410117c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000001308087210ULL, 0x000fe20007f1e0ffULL,
0x0000002015167824ULL, 0x000fe200078e0216ULL, 0x000000130a0a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0000000412137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x0000000414157c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000416177c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004117faeULL, 0x0003e8000b901c4cULL,
0x0000000006137faeULL, 0x0003e8000b901c4cULL, 0x0000000008157faeULL, 0x0003e8000b901c4cULL,
0x000000000a177faeULL, 0x0003e2000b901c4cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0001c60004047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0000000c0c0c7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0f00720cULL, 0x000fe40003f05270ULL, 0x000000000c0b72caULL, 0x004fda00000e0000ULL,
0x0000003f0b047890ULL, 0x002fe4000fffe03fULL, 0x000000ff0b057890ULL, 0x000fe4000fffe03fULL,
0x000000063f047899ULL, 0x000fe40008011604ULL, 0x000000083f057899ULL, 0x000fe20008011605ULL,
0x000000e000f08947ULL, 0x000ff60003800000ULL, 0x00000004030a7824ULL, 0x000fe200078e00ffULL,
0x00000000000b7919ULL, 0x000e620000008800ULL, 0x0000040000067802ULL, 0x010fe20000000f00ULL,
0xffffffffff0c7424ULL, 0x000fe200078e00ffULL, 0x00008a00ff127b82ULL, 0x000ea20000000a00ULL,
0x000000040a007c0cULL, 0x000fda000bf06070ULL, 0x00009000ff078b82ULL, 0x000ee20000000800ULL,
0x000000020e048824ULL, 0x000fce00078e00ffULL, 0x00008c00ff088b82ULL, 0x000f220000000a00ULL,
0x000000010a058824ULL, 0x008fc800078e0207ULL, 0x0000000704078224ULL, 0x000fe200078e0205ULL,
0x000006540b057816ULL, 0x002fe20000000006ULL, 0x0000001002047824ULL, 0x000fe400078e00ffULL,
0x0000000407088825ULL, 0x010fc800078e0008ULL, 0x00000004ff077424ULL, 0x000fe400078e00ffULL,
0x0000000105067824ULL, 0x000fc800078e0204ULL, 0x01c6100706ff79a7ULL, 0x0003e2000850003fULL,
0x0000000c080c8981ULL, 0x000722000c1e1900ULL, 0x000000010a637836ULL, 0x000fca0000000000ULL,
0x0000000463007c0cULL, 0x000fda000bf06070ULL, 0x00009000ff108b82ULL, 0x000f620000000800ULL,
0x000000020e078824ULL, 0x002fce00078e00ffULL, 0x00008c00ff0a8b82ULL, 0x000e620000000a00ULL,
0x0000000163068824ULL, 0x020fc800078e0210ULL, 0x0000001007078224ULL, 0x000fe400078e0206ULL,
0x0000010003097824ULL, 0x008fe400078e00ffULL, 0x00000004070a8825ULL, 0x002fe400078e000aULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x0000000b09107c48ULL, 0x000fe2000ffe0000ULL, 0x0000000103087836ULL, 0x000fe20000000000ULL,
0x0000000606067899ULL, 0x000fc6000800063fULL, 0x0000000c0a068981ULL, 0x000762000c1e1900ULL,
0x0000000508007c0cULL, 0x000fe2000bf06070ULL, 0x0000000110107824ULL, 0x000fe200078e0a09ULL,
0x00000000050772caULL, 0x000fe200000e0000ULL, 0x0000004018097824ULL, 0x000fc600078e00ffULL,
0x00000040100b7807ULL, 0x008fc80000000000ULL, 0x0000000b040b7248ULL, 0x000fca0007fe0000ULL,
0x0001c64807077890ULL, 0x000fe2000fffe03fULL, 0x00000004ff0f7819ULL, 0x002fe20000011607ULL,
0x00000010071d7824ULL, 0x000fc800078e00ffULL, 0x00000001040d7824ULL, 0x040fe200078e020fULL,
0x000000f01d1d7812ULL, 0x000fe200078ec0ffULL, 0x000000020f157836ULL, 0x040fe40000000000ULL,
0x000000040f197836ULL, 0x000fe20000000000ULL, 0x000000070d087812ULL, 0x000fe200078ec0ffULL,
0x0000000104177824ULL, 0x040fe400078e0215ULL, 0x0000000104217824ULL, 0x000fe200078e0219ULL,
0x0000000f08087812ULL, 0x000fe200078e7807ULL, 0x000000080f1f7836ULL, 0x000fe20000000000ULL,
0x00000007170a7812ULL, 0x000fe200078ec0ffULL, 0x0000000a0f277836ULL, 0x000fc40000000000ULL,
0x000000100d1c7824ULL, 0x000fe200078e0208ULL, 0x0000000f0a167812ULL, 0x000fe200078e7807ULL,
0x000000010b087824ULL, 0x000fe400078e0a04ULL, 0x0000000104257824ULL, 0x040fe400078e021fULL,
0x0000000c0f2b7836ULL, 0x000fe20000000000ULL, 0x000000081900720cULL, 0x080fe20003f66070ULL,
0x0000000e0f2f7836ULL, 0x000fe20000000000ULL, 0x000000081500720cULL, 0x080fe20003f86070ULL,
0x0000000104297824ULL, 0x040fe200078e0227ULL, 0x000000080f00720cULL, 0x000fe20003fa6070ULL,
0x00000001042d7824ULL, 0x000fc400078e022bULL, 0x0000000104317824ULL, 0x000fe400078e022fULL,
0x00000010171e7824ULL, 0x000fc600078e0216ULL, 0x0000000731227812ULL, 0x000fc800078ec0ffULL,
0x0000000f22227812ULL, 0x000fca00078e7807ULL, 0x0000001031227824ULL, 0x000fe400078e0222ULL,
0x0000000609147e24ULL, 0x010fca000f8e020cULL, 0x0000003f140d7812ULL, 0x000fe400078ef80dULL,
0x0000003f14117812ULL, 0x000fe400078ef817ULL, 0x0000003f141b7812ULL, 0x000fe200078ef821ULL,
0x000001000d0a7825ULL, 0x104fe200078e0012ULL, 0x0000003f14157812ULL, 0x000fe400078ef829ULL,
0x0000003f14177812ULL, 0x000fe200078ef82dULL, 0x00000100110c7825ULL, 0x000fe200078e0012ULL,
0x0000001d0a187210ULL, 0x000fc60007f1e0ffULL, 0x000001001b107825ULL, 0x000fe200078e0012ULL,
0x0000001d0c1a7210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200000e060bULL,
0x0000001d100a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe400008e060dULL,
0x000000060f0d7836ULL, 0x000fe20000000000ULL, 0x0000003f140f7812ULL, 0x000fe200078ef831ULL,
0x000000ffff0b7224ULL, 0x000fe200010e0611ULL, 0x0000003f14117812ULL, 0x000fe200078ef825ULL,
0x0000000104237824ULL, 0x000fe200078e020dULL, 0x000000080d00720cULL, 0x000fe20003f46070ULL,
0x0000010017167825ULL, 0x000fc600078e0012ULL, 0x0000003f140d7812ULL, 0x000fe200078ef823ULL,
0x0000010011107825ULL, 0x000fe200078e0012ULL, 0x0000000723207812ULL, 0x000fc600078ec0ffULL,
0x000001000d0c7825ULL, 0x100fe200078e0012ULL, 0x0000001d10107210ULL, 0x000fe40007f3e0ffULL,
0x0000000f20207812ULL, 0x000fe200078e7807ULL, 0x0000010015147825ULL, 0x000fe200078e0012ULL,
0x0000001d0c0c7210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000001d16167210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000001d14147210ULL, 0x000fe20007f1e0ffULL, 0x000001000f127825ULL, 0x000fc800078e0012ULL,
0x00014000050f7836ULL, 0x000fe40000000000ULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000001d12127210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x000000081f00720cULL, 0x080fe20003f26070ULL, 0x000000101c1d7824ULL, 0x100fe200078e020fULL,
0x00000007211c7812ULL, 0x000fe200078ec0ffULL, 0x000000101e1f7824ULL, 0x000fe200078e020fULL,
0x000000072d1e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000e901c4cULL,
0x000000082700720cULL, 0x080fe20003f06070ULL, 0x0000001023207824ULL, 0x000fe200078e0220ULL,
0x000000082b00720cULL, 0x080fe20003fa6070ULL, 0x000000001a1f7faeULL, 0x0005e2000e101c4cULL,
0x000000082f00720cULL, 0x000fc40003f86070ULL, 0x0000000725087812ULL, 0x000fe400078ec0ffULL,
0x0000000f1c1c7812ULL, 0x000fe400078e7807ULL, 0x0000000f08087812ULL, 0x000fe400078e7807ULL,
0x0000000729187812ULL, 0x002fe200078ec0ffULL, 0x00000010211c7824ULL, 0x000fe200078e021cULL,
0x0000000f1e1e7812ULL, 0x000fe200078e7807ULL, 0x0000001025087824ULL, 0x000fe200078e0208ULL,
0x0000000f18187812ULL, 0x000fe200078e7807ULL, 0x000000101c197824ULL, 0x000fc400078e020fULL,
0x000000102d1e7824ULL, 0x000fe400078e021eULL, 0x0000001029187824ULL, 0x000fe200078e0218ULL,
0x000000000a197faeULL, 0x0003e2000d901c4cULL, 0x00000010201b7824ULL, 0x104fe400078e020fULL,
0x00000010081d7824ULL, 0x100fe400078e020fULL, 0x00000010181f7824ULL, 0x100fe200078e020fULL,
0x000000000c1b7faeULL, 0x0003e2000d101c4cULL, 0x000000101e217824ULL, 0x000fc400078e020fULL,
0x00000010220f7824ULL, 0x000fe200078e020fULL, 0x00000000101d7faeULL, 0x0003e2000c901c4cULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x00000000141f7faeULL, 0x0003e2000c101c4cULL, 0x0000000503007c0cULL, 0x000fc6000bf06070ULL,
0x0000000016217faeULL, 0x0003e8000e901c4cULL, 0x00000000120f7faeULL, 0x0003e2000e101c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a47ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x01c6581805ff79a7ULL, 0x0005e2000850003fULL,
0x000000ffff0b7224ULL, 0x002fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x004fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x000000a400680947ULL, 0x000fec0003800000ULL,
0x00009000ff0d7b82ULL, 0x000e620000000800ULL, 0x000000020e0a7824ULL, 0x000fe200078e00ffULL,
0x00007610ff797816ULL, 0x000fe20000000079ULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x00007610ff717816ULL, 0x000fe20000000071ULL, 0x000000ffff7a7224ULL, 0x000fe200078e00ffULL,
0x00007610ff0c7816ULL, 0x000fe2000000000cULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0x0000000d0a0a7224ULL, 0x002fce00078e020dULL, 0x00000100030e7824ULL, 0x000fca00078e00ffULL,
0x0000000b0e007c0cULL, 0x000fda000bf06070ULL, 0x000000a400240947ULL, 0x000fea0003800000ULL,
0x0000ffff790e7812ULL, 0x000fe200078ec0ffULL, 0x00008a00ff747b82ULL, 0x000e620000000a00ULL,
0x00000004ff5b7819ULL, 0x000fe20000011607ULL, 0x0000000606067e24ULL, 0x020fe2000f8e0209ULL,
0x000088800e287816ULL, 0x000fe200000000ffULL, 0x00000010072c7824ULL, 0x000fe200078e00ffULL,
0x00000003630f7812ULL, 0x000fe200078ec0ffULL, 0x000000025b577836ULL, 0x000fe20000000000ULL,
0xfffffffd005e7811ULL, 0x000fe200078e10ffULL, 0x8000000028287824ULL, 0x000fe200078e00ffULL,
0x000000030f00780cULL, 0x000fe20003f45270ULL, 0x0000000104597824ULL, 0x000fe200078e025bULL,
0x000000f02c587812ULL, 0x000fe200078ec0ffULL, 0x01c65828050075a7ULL, 0x000ea2000800007fULL,
0x0000000104557824ULL, 0x000fe200078e0257ULL, 0x000000015e1c7807ULL, 0x000fe20005000000ULL,
0x000000045b537836ULL, 0x040fe20000000000ULL, 0x0000003f06117812ULL, 0x000fe200078ef859ULL,
0x000000065b437836ULL, 0x000fe20000000000ULL, 0x0000003f06137812ULL, 0x000fe200078ef855ULL,
0x0000000104527824ULL, 0x000fc400078e0253ULL, 0x0000000104427824ULL, 0x000fe400078e0243ULL,
0x00000001030e7836ULL, 0x000fe20000000000ULL, 0x0000003f061d7812ULL, 0x000fe200078ef852ULL,
0x0000010011107825ULL, 0x102fe200078e0074ULL, 0x0000003f061f7812ULL, 0x000fe400078ef842ULL,
0x000000050e007c0cULL, 0x000fe2000bf26070ULL, 0x0000010013127825ULL, 0x000fe200078e0074ULL,
0x00000058100e7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e0063ULL,
0x00000058122a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000163637824ULL, 0x000fe400078e021cULL,
0x000001001d1c7825ULL, 0x000fc800078e0074ULL, 0x000001001f1e7825ULL, 0x000fe200078e0074ULL,
0x0000000000080947ULL, 0x004fec0003800000ULL, 0x01c65828050075a7ULL, 0x000e64000800017fULL,
0x0000013000448947ULL, 0x002fea0003800000ULL, 0x00000040036d7811ULL, 0x000fe200078e40ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e0613ULL, 0x000000581c107210ULL, 0x000fe20007f1e0ffULL,
0x0000000c5b397836ULL, 0x000fe20000000000ULL, 0x0000000b6d127c48ULL, 0x000fe2000ffe0000ULL,
0x000040007a407824ULL, 0x000fe200078e00ffULL, 0x00000007591c7812ULL, 0x000fe200078ec0ffULL,
0x0000000104387824ULL, 0x000fe200078e0239ULL, 0x0000000752327812ULL, 0x000fe200078ec0ffULL,
0x0000000112127824ULL, 0x000fe200078e0a6dULL, 0x0000400040307812ULL, 0x000fe200078e0cffULL,
0x000000ffff0f7224ULL, 0x000fe200010e0611ULL, 0x0000003f062d7812ULL, 0x000fe200078ef838ULL,
0x000000ffff117224ULL, 0x000fe200000e061dULL, 0x0000004012137807ULL, 0x000fe20000800000ULL,
0x000000085b3f7836ULL, 0x040fe20000000000ULL, 0x0000000f1c567812ULL, 0x000fe200078e7807ULL,
0x0000000a5b3d7836ULL, 0x000fe20000000000ULL, 0x0000001304137248ULL, 0x040fe20007fe0000ULL,
0x00000001043e7824ULL, 0x000fe200078e023fULL, 0x000000581e287210ULL, 0x000fe20007f5e0ffULL,
0x0000001059567824ULL, 0x000fe200078e0256ULL, 0x0000000f32517812ULL, 0x000fe200078e7807ULL,
0x00000001132e7824ULL, 0x000fe200078e0a04ULL, 0x00000007423a7812ULL, 0x000fe200078ec0ffULL,
0x000001002d127825ULL, 0x000fe200078e0074ULL, 0x00014000052d7810ULL, 0x000fc40007ffe030ULL,
0x0000002e5b00720cULL, 0x000fe20003f06070ULL, 0x000000ffff297224ULL, 0x000fe200010e061fULL,
0x0000000755307812ULL, 0x000fe200078ec0ffULL, 0x00000010562f7824ULL, 0x000fe200078e022dULL,
0x0000003f061f7812ULL, 0x000fe200078ef83eULL, 0x00000001043b7824ULL, 0x000fe200078e023dULL,
0x0000000f30307812ULL, 0x000fe200078e7807ULL, 0x0000000e5b337836ULL, 0x000fe20000000000ULL,
0x0000000f3a417812ULL, 0x000fe200078e7807ULL, 0x000001001f1e7825ULL, 0x000fe200078e0074ULL,
0x0000003f061d7812ULL, 0x000fc400078ef83bULL, 0x000000017a5c7812ULL, 0x000fe200078e0cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e2f7faeULL, 0x0003e2000c101c4cULL,
0x0000002e5700720cULL, 0x080fe20003f06070ULL, 0x0000001055547824ULL, 0x000fe200078e0230ULL,
0x000000581e1e7210ULL, 0x000fe20007f5e0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0074ULL,
0x000000005c0872caULL, 0x000fe400000e0000ULL, 0x0000005812127210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x0000002e5300720cULL, 0x080fe20003f46070ULL,
0x0000001052517824ULL, 0x000fe200078e0251ULL, 0x000000581c1c7210ULL, 0x000fe20007f7e0ffULL,
0x00000010542f7824ULL, 0x002fe200078e022dULL, 0x0000002e3300720cULL, 0x000fe20003fa6070ULL,
0x0000000104317824ULL, 0x000fc400078e0233ULL, 0x00000010515d7824ULL, 0x000fe200078e022dULL,
0x000000002a2f7faeULL, 0x0003e2000c101c4cULL, 0x0000000463007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff1d7224ULL, 0x000fe200018e061dULL, 0x0000003f060f7812ULL, 0x000fe200078ef831ULL,
0x0000001042417824ULL, 0x000fe200078e0241ULL, 0x0000002e4300720cULL, 0x080fe20003f66070ULL,
0x00000000105d7faeULL, 0x0005e2000d101c4cULL, 0x000000073e067812ULL, 0x000fe200078ec0ffULL,
0x00000010415f7824ULL, 0x000fe200078e022dULL, 0x0000002e3f00720cULL, 0x080fe20003f46070ULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x0000002e3900720cULL, 0x000fe20003f86070ULL,
0x000001000f0e7825ULL, 0x000fe200078e0074ULL, 0x0000000f062b7812ULL, 0x002fe200078e7807ULL,
0x0000000708087291ULL, 0x000fe2000f8e183fULL, 0x0000000738067812ULL, 0x000fc400078ec0ffULL,
0x000000073b2a7812ULL, 0x000fe200078ec0ffULL, 0x00008c00ff108b82ULL, 0x004e620000000a00ULL,
0x000000103e3c7824ULL, 0x000fe200078e022bULL, 0x0000000f062b7812ULL, 0x000fe200078e7807ULL,
0x00000000285f7faeULL, 0x0005e2000d901c4cULL, 0x0000000731067812ULL, 0x000fe200078ec0ffULL,
0x00000001635d8824ULL, 0x000fe200078e020aULL, 0x0000000f2a2a7812ULL, 0x000fe200078e7807ULL,
0x0000001038327824ULL, 0x000fe200078e022bULL, 0x0000002e3d00720cULL, 0x000fe40003f66070ULL,
0x0000000f06307812ULL, 0x000fe200078e7807ULL, 0x000000103b3a7824ULL, 0x000fe200078e022aULL,
0x000000580e0e7210ULL, 0x000fe20007fde0ffULL, 0x00000010322f7824ULL, 0x100fe200078e022dULL,
0x0000ffff71067812ULL, 0x000fe200078ec0ffULL, 0x000000103c297824ULL, 0x004fe200078e022dULL,
0x0000ffff0c287812ULL, 0x000fe200078ec0ffULL, 0x0000001031307824ULL, 0x000fc400078e0230ULL,
0x000000103a2b7824ULL, 0x000fe200078e022dULL, 0x000000001e297faeULL, 0x0005e2000d101c4cULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x00008880285a7816ULL, 0x000fe200000000ffULL,
0x00000010302d7824ULL, 0x000fe200078e022dULL, 0x000000001c2b7faeULL, 0x000fe2000d901c4cULL,
0x000000045d108825ULL, 0x002fc600078e0010ULL, 0x00000000122f7faeULL, 0x0003e2000e101c4cULL,
0x00008880061e7816ULL, 0x004fe200000000ffULL, 0xffffffffff067424ULL, 0x000fe400078e00ffULL,
0x000000000e2d7faeULL, 0x0005e8000e901c4cULL, 0x0000000c10068981ULL, 0x000562000c1e1900ULL,
0x000000ffff127224ULL, 0x002fe200078e001eULL, 0x0000000000007918ULL, 0x000fc40000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x000000077a1d7c11ULL, 0x000fe2000f8e18ffULL,
0x8000000012127824ULL, 0x000fe400078e00ffULL, 0x800000005a1c7824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x004fcc0000000000ULL, 0x000000121d0075a7ULL, 0x000262000800007fULL,
0x00000001ff0e7819ULL, 0x000fe40000011607ULL, 0x000000702c2c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x000000050e5d7210ULL, 0x000fe20007ffe02cULL,
0x01c6081c050075a7ULL, 0x000ea4000804017fULL, 0x00000128008ca947ULL, 0x006fea0003800000ULL,
0x01c000005d0f7984ULL, 0x000e620000000800ULL, 0x00000008072e7812ULL, 0x000fe200078ec0ffULL,
0x0000000402687824ULL, 0x000fe200078e025bULL, 0x0001400005137810ULL, 0x000fe20007ffe040ULL,
0x01c200005d6e7984ULL, 0x0004a20000000800ULL, 0x000000072e677812ULL, 0x000fe200078ec807ULL,
0x00000001ff617424ULL, 0x000fe200078e00ffULL, 0x000000072e2e7812ULL, 0x000fe400078ef807ULL,
0x0000006867687212ULL, 0x000fca00078e3cffULL, 0x000000102e6c7824ULL, 0x000fc800078e0268ULL,
0x000000106c1c7824ULL, 0x000fe200078e0213ULL, 0x000000080f00720bULL, 0x002fda0003f5d000ULL,
0x00000000000e7806ULL, 0x000fc800010e0100ULL, 0x0000ffff0e1e7812ULL, 0x000fda000784c0ffULL,
0x0000000000d4a947ULL, 0x004fea0003800000ULL, 0x000000080f00720bULL, 0x000fe40003f54000ULL,
0x0000000f08287209ULL, 0x000fe40007810000ULL, 0x00000002ff107819ULL, 0x000fc60000011607ULL,
0x80000028080e7221ULL, 0x100fe40000010000ULL, 0x0000000810117836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x000000ff0200720cULL, 0x000fe40003f45270ULL, 0x0000ffff081f7812ULL, 0x000fe200078e3cffULL,
0x0000000e000e7308ULL, 0x000e620000000800ULL, 0x000000ffff087224ULL, 0x000fc400078e0028ULL,
0x0000001f1eff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff617807ULL, 0x000fc60001800000ULL,
0x01c400285d00a388ULL, 0x000fe80000000800ULL, 0x00001f110e117589ULL, 0x002e6400000e0000ULL,
0x800000280f0f3221ULL, 0x000fe20000010000ULL, 0x0000000e0b0b7220ULL, 0x000fe20000410000ULL,
0x00001f100e107589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b0f0f3820ULL, 0x000fc80000410000ULL,
0x0000000f000d3308ULL, 0x000ee20000000800ULL, 0x0000001127277220ULL, 0x082fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x000000111b1b7220ULL, 0x080fe20000410000ULL,
0x000000111a1a7220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001147477220ULL, 0x080fe20000410000ULL,
0x0000001146467220ULL, 0x080fe20000410000ULL, 0x000000114b4b7220ULL, 0x080fe20000410000ULL,
0x000000114a4a7220ULL, 0x080fe20000410000ULL, 0x000000114f4f7220ULL, 0x080fe20000410000ULL,
0x000000114e4e7220ULL, 0x000fe20000410000ULL, 0x0000001025257220ULL, 0x084fe20000410000ULL,
0x0000001024247220ULL, 0x080fe20000410000ULL, 0x0000001015157220ULL, 0x080fe20000410000ULL,
0x0000001014147220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001045457220ULL, 0x080fe20000410000ULL,
0x0000001044447220ULL, 0x080fe20000410000ULL, 0x0000001049497220ULL, 0x080fe20000410000ULL,
0x0000001048487220ULL, 0x080fe20000410000ULL, 0x000000104d4d7220ULL, 0x080fe20000410000ULL,
0x000000104c4c7220ULL, 0x000fe20000410000ULL, 0x0000000d6e6e3220ULL, 0x008fce0000410000ULL,
0x0000000000080947ULL, 0x000fea0003800000ULL, 0x000000121d0075a7ULL, 0x000e64000800017fULL,
0x0000012400908947ULL, 0x002fea0003800000ULL, 0x000000001c1c783bULL, 0x000e620000004200ULL,
0x0000000707607812ULL, 0x000fe200078ec0ffULL, 0x0000000b6e0b7221ULL, 0x000fe20000010000ULL,
0x00000002020e7811ULL, 0x000fe400078e10ffULL, 0x0000000860607812ULL, 0x000fe400078ef807ULL,
0x00000002ff507819ULL, 0x000fe20000011607ULL, 0x000000015b0e7824ULL, 0x000fe200078e020eULL,
0x000000075b0f7812ULL, 0x000fe400078e7860ULL, 0x0000991061707816ULL, 0x000fc400000000ffULL,
0x0000000e67677212ULL, 0x000fe200078e3cffULL, 0x0000000860407824ULL, 0x000fe200078e020fULL,
0x0000000dff0e723eULL, 0x000fe400000010ffULL, 0x0000000b6d007c0cULL, 0x000fe2000bf61070ULL,
0x000000102e6a7824ULL, 0x000fe200078e0267ULL, 0x000054100e6f7816ULL, 0x000fe2000000000eULL,
0x0000001040407824ULL, 0x000fe200078e0205ULL, 0x000000ff71ff7812ULL, 0x000fe2000784c0ffULL,
0x000000106a287824ULL, 0x000fe200078e0213ULL, 0x000000ff79ff7812ULL, 0x040fe2000788c0ffULL,
0x00001f506f617589ULL, 0x000fe200000e0000ULL, 0x0000761079787816ULL, 0x000fc60000000078ULL,
0x012000004010783bULL, 0x000ea80000000200ULL, 0x000000002828783bULL, 0x000fe20000004200ULL,
0x000001001c0f7824ULL, 0x042fe200078e00ffULL, 0x000088801c647816ULL, 0x000fe200000000ffULL,
0x000001001d0e7824ULL, 0x040fe200078e00ffULL, 0x000088801d667816ULL, 0x040fe400000000ffULL,
0x00000018ff697819ULL, 0x000fe2000001140fULL, 0x00000008500f7836ULL, 0x000fe20000000000ULL,
0x00000018ff727819ULL, 0x000fe2000001140eULL, 0x000000ffff0e7224ULL, 0x000fe200078e0070ULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x000100001c707824ULL, 0x000fe200078e00ffULL,
0x00001f0f6f627589ULL, 0x0002e200000e0000ULL, 0x00000018ff2c7819ULL, 0x000fe2000001141dULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x000000ff0e00720cULL, 0x000fc40003f05270ULL,
0x00000018ff2d7819ULL, 0x000fe2000001141cULL, 0x0000006900697306ULL, 0x000f220000202400ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff657819ULL, 0x000fe4000001141fULL,
0x000088801e6f7816ULL, 0x002fe400000000ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001141eULL,
0x0000006600667306ULL, 0x000fe40000202400ULL, 0x0000006110108232ULL, 0x004fc40000200000ULL,
0x0000006112128232ULL, 0x000fe20000200000ULL, 0x00005410641c7816ULL, 0x010fc60000000069ULL,
0x0000007200737306ULL, 0x000e620000202400ULL, 0x00000018ff697819ULL, 0x000fe2000001141dULL,
0x0000006211118232ULL, 0x088fe20000200000ULL, 0x000088801f647816ULL, 0x000fe200000000ffULL,
0x0000006213138232ULL, 0x000fe20000200000ULL, 0x00000018ff5f7819ULL, 0x000fe40000011428ULL,
0x00000018ff0e7819ULL, 0x000fe20000011429ULL, 0x0000002d002d7306ULL, 0x000fe20000202400ULL,
0x00005410661d7816ULL, 0x002fce0000000073ULL, 0x0000002c002c7306ULL, 0x000fe20000202400ULL,
0x0000001c104c723cULL, 0x000fee000004184cULL, 0x0000007000707306ULL, 0x000e620000202400ULL,
0x000001001e1c7824ULL, 0x000fe400078e00ffULL, 0x000001001f1d7824ULL, 0x000fca00078e00ffULL,
0x0000006900737306ULL, 0x000ea20000202400ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001c00667306ULL, 0x0003e20000202400ULL, 0x00000018ff1e7819ULL, 0x000fce000001141eULL,
0x0000001d00697306ULL, 0x0005e20000202400ULL, 0x00005410701c7816ULL, 0x002fce000000002dULL,
0x0000006f006f7306ULL, 0x000e620000202400ULL, 0x00005410731d7816ULL, 0x004fe4000000002cULL,
0x00008880282c7816ULL, 0x000fca00000000ffULL, 0x0000001c1048723cULL, 0x000fe20000041848ULL,
0x0000001f00707306ULL, 0x0005ec0000202400ULL, 0x00000100281d7824ULL, 0x040fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x000fe200078e002cULL, 0x000054106f2c7816ULL, 0x002fe20000000066ULL,
0x00000100291f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001141dULL,
0x0000002f002f7306ULL, 0x000fe20000202400ULL, 0x00008880291d7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0001000029297824ULL, 0x000fc400078e00ffULL, 0x000040007a6f7824ULL, 0x000fe200078e0205ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000001d001d7306ULL, 0x000fe20000202400ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x000140006f6f7836ULL, 0x000fcc0000000000ULL,
0x0000001f00667306ULL, 0x000e700000202400ULL, 0x0000006500657306ULL, 0x000ea20000202400ULL,
0x000054101d1d7816ULL, 0x002fce0000000066ULL, 0x0000001e001e7306ULL, 0x000e620000202400ULL,
0x000001002e667811ULL, 0x000fe400078e20ffULL, 0x00005410701f7816ULL, 0x004fca0000000065ULL,
0x0000006400647306ULL, 0x000ea20000202400ULL, 0x000054101e1e7816ULL, 0x002fce000000002fULL,
0x0000001c001c7306ULL, 0x000fe20000202400ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142bULL,
0x0000001e1020723cULL, 0x000fe20000041820ULL, 0x00005410642d7816ULL, 0x004fca0000000069ULL,
0x0000007300737306ULL, 0x000e620000202400ULL, 0x0000000168697824ULL, 0x000fe200078e0266ULL,
0x00000018ff647819ULL, 0x000fe2000001142aULL, 0x0000000167667824ULL, 0x000fe400078e0266ULL,
0x00000010691f7824ULL, 0x000fe200078e026fULL, 0x0000002c1044723cULL, 0x000fe20000041844ULL,
0x000001002a1e7824ULL, 0x000fe200078e00ffULL, 0x0000005f005f7306ULL, 0x000fe80000202400ULL,
0x00000018ff657819ULL, 0x000fc4000001141eULL, 0x000088802a2c7816ULL, 0x000fe400000000ffULL,
0x0000002800287306ULL, 0x000ea20000202400ULL, 0x000054101c1c7816ULL, 0x002fe40000000073ULL,
0x000088802b2d7816ULL, 0x000fca00000000ffULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x0000001c1034723cULL, 0x000fe20000041834ULL, 0x000000001f1c783bULL, 0x000e620000004200ULL,
0x0000541028287816ULL, 0x004fca000000005fULL, 0x0000002900297306ULL, 0x000ea20000202400ULL,
0x000001002b5f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001145fULL,
0x000100002a5f7824ULL, 0x000fe200078e00ffULL, 0x0000002c002c7306ULL, 0x000fe80000202400ULL,
0x00000018ff727819ULL, 0x000fe4000001145fULL, 0x0000541029297816ULL, 0x004fe2000000000eULL,
0x000100002b0e7824ULL, 0x000fe200078e00ffULL, 0x0000006500657306ULL, 0x000ea80000202400ULL,
0x00000018ff707819ULL, 0x000fe2000001140eULL, 0x000000281018723cULL, 0x000fe60000041818ULL,
0x0000002d002d7306ULL, 0x000fe80000202400ULL, 0x0000000207297811ULL, 0x000fc400078fe0ffULL,
0x000054102c287816ULL, 0x004fe40000000065ULL, 0x00000073002a7306ULL, 0x000ea20000202400ULL,
0x0000000729297812ULL, 0x000fe400078e7860ULL, 0x000088801c657816ULL, 0x002fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001141cULL, 0x00000008600e7824ULL, 0x000fe400078e0229ULL,
0x0000006400647306ULL, 0x000fe40000202400ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x000054102d297816ULL, 0x004fca000000002aULL, 0x0000002f002f7306ULL, 0x000fe40000202400ULL,
0x000000281014723cULL, 0x000fec0000041814ULL, 0x00000072002b7306ULL, 0x000e700000202400ULL,
0x0000007000707306ULL, 0x000ea20000202400ULL, 0x000054102b2c7816ULL, 0x002fce0000000064ULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x00000018ff647819ULL, 0x000fe2000001141dULL,
0x012000000e28783bULL, 0x000e620000000200ULL, 0x00005410702d7816ULL, 0x004fca000000002fULL,
0x00000064002f7306ULL, 0x0005e40000202400ULL, 0x0000002c1024723cULL, 0x000fe20000041824ULL,
0x000001001d647824ULL, 0x004fcc00078e00ffULL, 0x000001001c107824ULL, 0x040fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fe200078e0065ULL, 0x000088801d657816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe20000011410ULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011464ULL,
0x0000002c002c7306ULL, 0x000fe20000202400ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000001066107824ULL, 0x000fe200078e026fULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff647819ULL, 0x000fc6000001141eULL, 0x0000002d002d7306ULL, 0x000ea20000202400ULL,
0x000000001010783bULL, 0x000ee20000004200ULL, 0x0000006128288232ULL, 0x082fe40000200000ULL,
0x000000612a2a8232ULL, 0x000fc80000200000ULL, 0x0000006500657306ULL, 0x000fe20000202400ULL,
0x0000006229298232ULL, 0x080fe40000200000ULL, 0x000000622b2b8232ULL, 0x000fe20000200000ULL,
0x000054102c2c7816ULL, 0x004fc8000000002dULL, 0x0000007000707306ULL, 0x000e700000202400ULL,
0x0000001c001c7306ULL, 0x000ea20000202400ULL, 0x00005410652d7816ULL, 0x002fe20000000070ULL,
0x000001001e657824ULL, 0x000fcc00078e00ffULL, 0x0000001d00707306ULL, 0x000e620000202400ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000002c284c723cULL, 0x000fe2000004184cULL,
0x000054101c1c7816ULL, 0x004fe4000000005fULL, 0x000088801e5f7816ULL, 0x000fc600000000ffULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x00000018ff2d7819ULL, 0x000fe4000001141fULL,
0x00000018ff2c7819ULL, 0x008fe40000011410ULL, 0x00005410701d7816ULL, 0x002fe4000000002fULL,
0x000088801f707816ULL, 0x000fe200000000ffULL, 0x0000005f002f7306ULL, 0x0003e80000202400ULL,
0x0000001c2848723cULL, 0x000fe80000041848ULL, 0x00000065001c7306ULL, 0x000ea20000202400ULL,
0x00008880115f7816ULL, 0x002fc400000000ffULL, 0x000001001f1d7824ULL, 0x040fe400078e00ffULL,
0x000100001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001141dULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x000100001e1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff1e7819ULL, 0x000fe40000011411ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000007300737306ULL, 0x000e620000202400ULL,
0x000054102f1c7816ULL, 0x004fce000000001cULL, 0x0000001d00657306ULL, 0x0002b00000202400ULL,
0x0000002d002d7306ULL, 0x000fe20000202400ULL, 0x00005410701d7816ULL, 0x002fe40000000073ULL,
0x0000888010737816ULL, 0x000fca00000000ffULL, 0x0000001c2844723cULL, 0x000fe20000041844ULL,
0x0000001f00727306ULL, 0x000e6c0000202400ULL, 0x00000100101c7824ULL, 0x040fe400078e00ffULL,
0x00000100111d7824ULL, 0x040fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001c00767306ULL, 0x0004e20000202400ULL,
0x00000018ff117819ULL, 0x000fce0000011411ULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x00005410651c7816ULL, 0x004fe40000000064ULL, 0x000002002e647811ULL, 0x000fca00078e20ffULL,
0x0000001d00707306ULL, 0x0002a20000202400ULL, 0x0000000168657824ULL, 0x100fe400078e0264ULL,
0x0000000167647824ULL, 0x000fca00078e0264ULL, 0x0000002c002c7306ULL, 0x000fe20000202400ULL,
0x00005410721d7816ULL, 0x002fe2000000002dULL, 0x0000001065727824ULL, 0x000fe200078e026fULL,
0x00000018ff2d7819ULL, 0x000fca0000011412ULL, 0x00000010001f7306ULL, 0x0007e20000202400ULL,
0x0000001c2820723cULL, 0x000fee0000041820ULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x0000541073107816ULL, 0x008fe40000000076ULL, 0x00008880121c7816ULL, 0x000fca00000000ffULL,
0x00000011002f7306ULL, 0x0004700000202400ULL, 0x0000002d002d7306ULL, 0x000fe20000202400ULL,
0x000054105f117816ULL, 0x004fe40000000070ULL, 0x000054102f1d7816ULL, 0x002fca000000001eULL,
0x000000102834723cULL, 0x000fee0000041834ULL, 0x0000010012117824ULL, 0x000fe400078e00ffULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0x000054101f1c7816ULL, 0x000fe2000000002cULL,
0x00000100132c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fc40000011411ULL,
0x0000888013117816ULL, 0x040fe200000000ffULL, 0x0000001000107306ULL, 0x000fe20000202400ULL,
0x00000018ff5f7819ULL, 0x000fe2000001142cULL, 0x00010000122c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe20000011413ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000001c281c723cULL, 0x000fe20000041818ULL, 0x000000007218783bULL, 0x000e620000004200ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002f002f7306ULL, 0x000ea20000202400ULL,
0x00000018ff137819ULL, 0x000fce0000011413ULL, 0x0000001100117306ULL, 0x000fe20000202400ULL,
0x0000541010107816ULL, 0x004fce000000002fULL, 0x0000005f00707306ULL, 0x000ea20000202400ULL,
0x00000004072f7811ULL, 0x000fce00078fe0ffULL, 0x0000001200127306ULL, 0x000fe20000202400ULL,
0x0000541011117816ULL, 0x004fce0000000070ULL, 0x0000002c002c7306ULL, 0x000ea20000202400ULL,
0x000000102814723cULL, 0x000fe20000041814ULL, 0x00000018ff727819ULL, 0x002fcc0000011418ULL,
0x0000001300137306ULL, 0x000e620000202400ULL, 0x000000072f117812ULL, 0x000fe400078e7860ULL,
0x000054102c107816ULL, 0x004fca000000002dULL, 0x00000072002f7306ULL, 0x000fe20000202400ULL,
0x00000018ff2c7819ULL, 0x000fe20000011419ULL, 0x0000000860707824ULL, 0x000fe200078e0211ULL,
0x00008880182d7816ULL, 0x000fc600000000ffULL, 0x00000010705f7824ULL, 0x000fe200078e0205ULL,
0x0000541013117816ULL, 0x002fe20000000012ULL, 0x0000002c002c7306ULL, 0x000fe20000202400ULL,
0x000088801b707816ULL, 0x000fca00000000ffULL, 0x000000102824723cULL, 0x000fe20000041824ULL,
0x012000005f10783bULL, 0x000e620000000200ULL, 0x0000007000707306ULL, 0x000fea0000202400ULL,
0x0000010018297824ULL, 0x040fe200078e00ffULL, 0x00008880192a7816ULL, 0x040fe200000000ffULL,
0x00000100192b7824ULL, 0x040fe400078e00ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000000ffff287224ULL, 0x000fe200078e002dULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x00000018ff197819ULL, 0x000fc40000011419ULL, 0x000088801a2d7816ULL, 0x000fca00000000ffULL,
0x0000001800187306ULL, 0x000eb00000202400ULL, 0x0000001900197306ULL, 0x000ee20000202400ULL,
0x0000541018187816ULL, 0x004fce000000002fULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x0000006110108232ULL, 0x082fe40000200000ULL, 0x000001001a2f7824ULL, 0x000fe400078e00ffULL,
0x0000006112128232ULL, 0x000fe40000200000ULL, 0x0000006211118232ULL, 0x080fe40000200000ULL,
0x0000006213138232ULL, 0x000fe20000200000ULL, 0x0000002900297306ULL, 0x000e620000202400ULL,
0x0000541019197816ULL, 0x008fce000000002cULL, 0x0000002b002b7306ULL, 0x000ea20000202400ULL,
0x000000181048723cULL, 0x000fe20000041848ULL, 0x0000541028287816ULL, 0x002fcc0000000029ULL,
0x0000002d002c7306ULL, 0x0003e20000202400ULL, 0x00000018ff187819ULL, 0x000fe2000001142fULL,
0x000001001b2f7824ULL, 0x000fe200078e00ffULL, 0x000054102a297816ULL, 0x004fe2000000002bULL,
0x00000010642a7824ULL, 0x000fc600078e026fULL, 0x00000018ff727819ULL, 0x000fe2000001142fULL,
0x0000001800197306ULL, 0x000ea20000202400ULL, 0x00000018ff2f7819ULL, 0x000fe2000001141aULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x002fe2000001141bULL,
0x00000028104c723cULL, 0x000fe2000004184cULL, 0x000000002a28783bULL, 0x000e660000004200ULL,
0x0000007200737306ULL, 0x000ee20000202400ULL, 0x000054102c187816ULL, 0x004fce0000000019ULL,
0x0000002f002f7306ULL, 0x000fe20000202400ULL, 0x00000018ff2c7819ULL, 0x000fe4000001141aULL,
0x0000541070197816ULL, 0x008fca0000000073ULL, 0x0000002d002d7306ULL, 0x000fe40000202400ULL,
0x000000181044723cULL, 0x000fec0000041844ULL, 0x0000002c002c7306ULL, 0x000ea20000202400ULL,
0x000100001b187824ULL, 0x000fca00078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff197819ULL, 0x002fe40000011428ULL, 0x0000001800707306ULL, 0x0004620000202400ULL,
0x00000018ff1a7819ULL, 0x000fce0000011429ULL, 0x00000019001b7306ULL, 0x0003e20000202400ULL,
0x000054102c187816ULL, 0x004fe4000000002fULL, 0x00008880282c7816ULL, 0x000fca00000000ffULL,
0x0000001a001a7306ULL, 0x000fe20000202400ULL, 0x0000541070197816ULL, 0x002fe2000000002dULL,
0x00000100282d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x000000181020723cULL, 0x000fe20000041820ULL, 0x0000002c002c7306ULL, 0x000fec0000202400ULL,
0x0000010029187824ULL, 0x040fe200078e00ffULL, 0x0000888029197816ULL, 0x040fe200000000ffULL,
0x0000002d002d7306ULL, 0x000fe20000202400ULL, 0x0001000029297824ULL, 0x000fc400078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe20000011418ULL, 0x0001000028187824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe4000001142aULL, 0x00000018ff737819ULL, 0x000fe20000011429ULL,
0x0000001900197306ULL, 0x000fe20000202400ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff297819ULL, 0x000fca000001142bULL, 0x0000002f00727306ULL, 0x000e700000202400ULL,
0x0000001800707306ULL, 0x0004e20000202400ULL, 0x0000541019197816ULL, 0x002fce0000000072ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x000054102c187816ULL, 0x004fe4000000002dULL,
0x000088802a727816ULL, 0x000fca00000000ffULL, 0x00000073002d7306ULL, 0x0002a20000202400ULL,
0x000000181034723cULL, 0x000fee0000041834ULL, 0x000001002a197824ULL, 0x000fe200078e00ffULL,
0x0000541070187816ULL, 0x008fe2000000001bULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x000003002e707811ULL, 0x000fc400078e20ffULL, 0x00000018ff737819ULL, 0x002fe40000011419ULL,
0x000054102d197816ULL, 0x004fe2000000001aULL, 0x0000000168687824ULL, 0x100fe200078e0270ULL,
0x000088802b2d7816ULL, 0x000fe200000000ffULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x0000000167677824ULL, 0x000fe400078e0270ULL, 0x00000010682c7824ULL, 0x000fe200078e026fULL,
0x000000181018723cULL, 0x000fe8000004181cULL, 0x0000007300737306ULL, 0x000fe60000202400ULL,
0x000001002b1c7824ULL, 0x000fc400078e00ffULL, 0x000000ffff1d7224ULL, 0x000fe400078e002dULL,
0x000000002c2c783bULL, 0x000e620000004200ULL, 0x00000018ff767819ULL, 0x000fe2000001141cULL,
0x000100002a1c7824ULL, 0x000fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000001d001d7306ULL, 0x000fe40000202400ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff777819ULL, 0x000fc4000001142bULL, 0x00000006072b7811ULL, 0x000fe400078fe0ffULL,
0x00000076002a7306ULL, 0x000ea40000202400ULL, 0x000000072b2b7812ULL, 0x000fca00078e7860ULL,
0x0000000860607824ULL, 0x000fe200078e022bULL, 0x0000001c001f7306ULL, 0x0007260000202400ULL,
0x0000001060607824ULL, 0x000fe200078e0205ULL, 0x000054101d1d7816ULL, 0x004fc8000000002aULL,
0x00000077001e7306ULL, 0x000ea20000202400ULL, 0x00005410721c7816ULL, 0x008fe40000000073ULL,
0x000054101f287816ULL, 0x010fca0000000028ULL, 0x0000001c1014723cULL, 0x000fe20000041814ULL,
0x000001002d2b7824ULL, 0x002fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142cULL,
0x000088802e727816ULL, 0x000fe400000000ffULL, 0x000054101e297816ULL, 0x004fe40000000029ULL,
0x01200000601c783bULL, 0x000e620000000200ULL, 0x00000018ff707819ULL, 0x000fe2000001142bULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x00000018ff2b7819ULL, 0x000fc4000001142dULL,
0x000000281024723cULL, 0x000fea0000041824ULL, 0x0000007000707306ULL, 0x000fe40000202400ULL,
0x000001002c117824ULL, 0x040fe200078e00ffULL, 0x000088802c287816ULL, 0x000fe200000000ffULL,
0x0000001067107824ULL, 0x000fe200078e026fULL, 0x000088802d6f7816ULL, 0x040fe200000000ffULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011411ULL,
0x0000002b002b7306ULL, 0x000fe40000202400ULL, 0x000000001010783bULL, 0x000ea20000004200ULL,
0x00000018ff2d7819ULL, 0x000fca000001142dULL, 0x0000002800287306ULL, 0x000ff00000202400ULL,
0x0000002900297306ULL, 0x000ee20000202400ULL, 0x000000611c1c8232ULL, 0x002fce0000200000ULL,
0x0000006f006f7306ULL, 0x000e620000202400ULL, 0x000000611e1e8232ULL, 0x000fe20000200000ULL,
0x00000018ff617819ULL, 0x000fe2000001142fULL, 0x000000621d1d8232ULL, 0x080fe40000200000ULL,
0x000000621f1f8232ULL, 0x000fe20000200000ULL, 0x00000018ff627819ULL, 0x000fe4000001142eULL,
0x0000541028287816ULL, 0x008fe20000000029ULL, 0x0000006100617306ULL, 0x000fe20000202400ULL,
0x000054106f297816ULL, 0x002fce0000000070ULL, 0x0000002d00707306ULL, 0x0003e20000202400ULL,
0x00000018ff6f7819ULL, 0x004fe20000011410ULL, 0x000000281c4c723cULL, 0x000fec000004184cULL,
0x0000006200627306ULL, 0x000fe20000202400ULL, 0x00000018ff2d7819ULL, 0x002fe20000011411ULL,
0x000100002c287824ULL, 0x000fcc00078e00ffULL, 0x0000006f002c7306ULL, 0x000fe20000202400ULL,
0x00000018ff287819ULL, 0x000fce0000011428ULL, 0x0000002800297306ULL, 0x000e700000202400ULL,
0x0000002d002d7306ULL, 0x000fe20000202400ULL, 0x0000541029287816ULL, 0x002fe2000000002aULL,
0x000001002e297824ULL, 0x000fcc00078e00ffULL, 0x00000072002a7306ULL, 0x0003e20000202400ULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011429ULL,
0x0000541070297816ULL, 0x000fe4000000002bULL, 0x000088802f2b7816ULL, 0x040fe400000000ffULL,
0x0000006f006f7306ULL, 0x000ea20000202400ULL, 0x00000018ff727819ULL, 0x002fe2000001142eULL,
0x000100002f2e7824ULL, 0x000fe200078e00ffULL, 0x000000281c48723cULL, 0x000fe80000041848ULL,
0x00000018ff2e7819ULL, 0x000fc6000001142eULL, 0x000001002f297824ULL, 0x000fe400078e00ffULL,
0x000000ffff287224ULL, 0x000fe200078e002bULL, 0x00000072002f7306ULL, 0x000fe20000202400ULL,
0x00000018ff2b7819ULL, 0x000fe40000011412ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000002800707306ULL, 0x0005f00000202400ULL, 0x0000002900297306ULL, 0x000e620000202400ULL,
0x000054102a287816ULL, 0x004fe4000000006fULL, 0x00000018ff2a7819ULL, 0x000fca0000011413ULL,
0x0000002e002e7306ULL, 0x000ea20000202400ULL, 0x0000541070297816ULL, 0x002fce0000000029ULL,
0x0000002b002b7306ULL, 0x000fe20000202400ULL, 0x0000888010707816ULL, 0x040fe200000000ffULL,
0x000000281c44723cULL, 0x000fec0000041844ULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x0000010010287824ULL, 0x040fe200078e00ffULL, 0x0000888011297816ULL, 0x000fe200000000ffULL,
0x0001000010107824ULL, 0x000fca00078e00ffULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff107819ULL, 0x000fca0000011410ULL,
0x00000028006f7306ULL, 0x0003e40000202400ULL, 0x000054102f287816ULL, 0x002fe20000000062ULL,
0x00000100112f7824ULL, 0x000fca00078e00ffULL, 0x0000002900627306ULL, 0x0005e20000202400ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fc8000001142fULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000002f00737306ULL, 0x000e620000202400ULL,
0x000054102e297816ULL, 0x004fce0000000061ULL, 0x000000281c20723cULL, 0x000fe20000041820ULL,
0x0000001000617306ULL, 0x0004ec0000202400ULL, 0x0000010012287824ULL, 0x040fe200078e00ffULL,
0x0000888012297816ULL, 0x000fe200000000ffULL, 0x0000001100727306ULL, 0x0003220000202400ULL,
0x0000010013107824ULL, 0x004fc400078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe20000011428ULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000888013287816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x0000541062117816ULL, 0x002fe20000000073ULL,
0x00000001ff627424ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x01c6586205ff79a7ULL, 0x0003e4000850003fULL,
0x00000010002f7306ULL, 0x0005e20000202400ULL, 0x01c6106205ff79a7ULL, 0x0003ee000850003fULL,
0x0000002e002e7306ULL, 0x000e620000202400ULL, 0x0000541070107816ULL, 0x004fce000000006fULL,
0x0000002800287306ULL, 0x000ea20000202400ULL, 0x000000101c34723cULL, 0x000fee0000041834ULL,
0x0000541061107816ULL, 0x008fe2000000002cULL, 0x0000001200127306ULL, 0x000ee20000202400ULL,
0x0000541072117816ULL, 0x110fe2000000002dULL, 0x000000ffff617224ULL, 0x000fe200078e007aULL,
0x00007610712d7816ULL, 0x000fe2000000002dULL, 0x000000ffff7a7224ULL, 0x000fc600078e005cULL,
0x000000016100780cULL, 0x000fe20003f05270ULL, 0x0000001300137306ULL, 0x000f220000202400ULL,
0x000000101c18723cULL, 0x000fee0000041818ULL, 0x0000541029107816ULL, 0x002fe4000000002eULL,
0x0000541028117816ULL, 0x004fc4000000002fULL, 0x00000001ff2e7807ULL, 0x000fc80002000000ULL,
0x000076102e797816ULL, 0x000fe20000000079ULL, 0x000000101c14723cULL, 0x000fee0000041814ULL,
0x0000541012107816ULL, 0x008fe4000000002bULL, 0x0000541013117816ULL, 0x010fce000000002aULL,
0x000000101c24723cULL, 0x000fee0000041824ULL, 0x00000001ff1e7807ULL, 0x000fc80001000000ULL,
0x000000711e717207ULL, 0x000fe20004000000ULL, 0x000000740094b947ULL, 0x000fd80003800000ULL,
0x800000002e2e7824ULL, 0x000fe200078e00ffULL, 0x000000036b107812ULL, 0x000fe200078ec0ffULL,
0x00000006061f7e24ULL, 0x020fe2000f8e0209ULL, 0x0000008003717811ULL, 0x000fe200078e40ffULL,
0x01c6582e050075a7ULL, 0x000e62000808007fULL, 0x000000031000780cULL, 0x000fe20003f45270ULL,
0x00004000612c7824ULL, 0x000fe200078e00ffULL, 0x0000003f1f1d7812ULL, 0x000fe400078ef855ULL,
0x0000003f1f137812ULL, 0x000fe400078ef852ULL, 0x000000015e067807ULL, 0x000fe20005000000ULL,
0x000001001d1c7825ULL, 0x000fe200078e0074ULL, 0x0000003f1f117812ULL, 0x000fc400078ef859ULL,
0x0000003f1f2b7812ULL, 0x000fe200078ef83eULL, 0x0000010013127825ULL, 0x000fe200078e0074ULL,
0x000000581c727210ULL, 0x000fe40007f7e0ffULL, 0x000040002c2c7812ULL, 0x000fe200078ec0ffULL,
0x000000016b6d7824ULL, 0x000fe200078e0206ULL, 0x0000000b71067c48ULL, 0x000fe2000ffe0000ULL,
0x0000010011107825ULL, 0x000fe200078e0074ULL, 0x00000058126e7210ULL, 0x000fe40007fbe0ffULL,
0x000000036d287812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a71ULL,
0x0000005810107210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff737224ULL, 0x000fe200018e061dULL,
0x0000003f1f1d7812ULL, 0x000fe200078ef842ULL, 0x000000ffff6f7224ULL, 0x000fe200028e0613ULL,
0x0000004006137807ULL, 0x000fe20000800000ULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x000000032800780cULL, 0x000fe20003f45270ULL, 0x000001001d1c7825ULL, 0x000fe200078e0074ULL,
0x0000001304297248ULL, 0x000fc40007fe0000ULL, 0x00014000052f7810ULL, 0x000fe20007ffe02cULL,
0x000001002b127825ULL, 0x000fe200078e0074ULL, 0x000000581c2a7210ULL, 0x000fe40007fbe0ffULL,
0x0000002d1e2d7207ULL, 0x000fe20004000000ULL, 0x0000000129067824ULL, 0x000fe200078e0a04ULL,
0x0000005812287210ULL, 0x000fe20007fde0ffULL, 0x000000ffff2b7224ULL, 0x000fe400028e061dULL,
0x00000010561d7824ULL, 0x000fe200078e022fULL, 0x000000065b00720cULL, 0x000fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200030e0613ULL, 0x0000000000084947ULL, 0x002ff60003800000ULL,
0x01c6582e050075a7ULL, 0x000e64000800017fULL, 0x0000010000f48947ULL, 0x002fea0003800000ULL,
0x000000015e2c7807ULL, 0x000fe20005000000ULL, 0x00000010546b7824ULL, 0x000fe200078e022fULL,
0x000000065700720cULL, 0x080fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000d901c4cULL, 0x0000003f1f137812ULL, 0x000fe200078ef83bULL,
0x000000016d637824ULL, 0x000fe200078e022cULL, 0x000000065300720cULL, 0x000fe40003f66070ULL,
0x0000003f1f777812ULL, 0x000fe200078ef838ULL, 0x0000010013127825ULL, 0x000fe200078e0074ULL,
0x0000000463007c0cULL, 0x000fc4000bf06070ULL, 0x0000003f1f1f7812ULL, 0x000fe400078ef831ULL,
0x000000064300720cULL, 0x000fe20003f46070ULL, 0x00000000726b7faeULL, 0x0005e2000e101c4cULL,
0x00000058121e7210ULL, 0x000fe20007f9e0ffULL, 0x00000100771c7825ULL, 0x002fc800078e0074ULL,
0x000001001f107825ULL, 0x000fe400078e0074ULL, 0x0000002c0a798210ULL, 0x000fe40007ffe06dULL,
0x0000001051777824ULL, 0x000fe200078e022fULL, 0x0000005810107210ULL, 0x000fe20007fbe0ffULL,
0x00000008616b7824ULL, 0x004fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe200020e0613ULL,
0x000000006e777faeULL, 0x0003e2000d901c4cULL, 0x00008c00ff128b82ULL, 0x000ea20000000a00ULL,
0x000000086b6b7812ULL, 0x000fe200078ec0ffULL, 0x0000001041737824ULL, 0x000fe200078e022fULL,
0x000000581c1c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x000000006b0972caULL, 0x000fe200000e0000ULL, 0x000000103a6d7824ULL, 0x000fe200078e022fULL,
0x000000063d00720cULL, 0x080fe20003f86070ULL, 0x000000ffff1d7224ULL, 0x000fe200018e061dULL,
0x000000063f00720cULL, 0x080fe20003f66070ULL, 0x000000002a737faeULL, 0x0007e2000d101c4cULL,
0x000000063900720cULL, 0x080fe20003f46070ULL, 0x000000103c6f7824ULL, 0x102fe200078e022fULL,
0x000000063300720cULL, 0x000fe20003fa6070ULL, 0x0000001032777824ULL, 0x000fe200078e022fULL,
0x0000ffff2d067812ULL, 0x000fc600078ec0ffULL, 0x0000000907097290ULL, 0x000fe2000fffe03fULL,
0x00000010302b7824ULL, 0x008fe200078e022fULL, 0x00008880062a7816ULL, 0x000fe200000000ffULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x00000000286f7faeULL, 0x0003e2000d901c4cULL,
0x0000000479128825ULL, 0x004fc600078e0012ULL, 0x000000001e6d7faeULL, 0x0005e8000e101c4cULL,
0x000000001c777faeULL, 0x0007e8000d101c4cULL, 0x00000000102b7faeULL, 0x0009e2000e901c4cULL,
0x000000ffff287224ULL, 0x002fe200078e002aULL, 0x0000000000007918ULL, 0x000fc40000000000ULL,
0x0000000c12068981ULL, 0x000962000c1e1900ULL, 0x800000005a1e7824ULL, 0x004fe400078e00ffULL,
0x80000000281c7824ULL, 0x008fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0000001cff0075a7ULL, 0x0002620008000048ULL,
0x01c6181e050075a7ULL, 0x000ea4000804017fULL, 0x000001000024a947ULL, 0x006fea0003800000ULL,
0x01c080005d117984ULL, 0x010e620000000800ULL, 0x0000000161127812ULL, 0x000fe200078e0cffULL,
0x00000001ff2b7424ULL, 0x000fe400078e00ffULL, 0x01c280005d7c7984ULL, 0x0004a40000000800ULL,
0x0000400012127824ULL, 0x000fc800078e0205ULL, 0x0001400012777836ULL, 0x000fc80000000000ULL,
0x000000106c2c7824ULL, 0x000fe200078e0277ULL, 0x000000081100720bULL, 0x002fda0003f5d000ULL,
0x0000000000107806ULL, 0x000fc800010e0100ULL, 0x0000ffff10137812ULL, 0x000fda000784c0ffULL,
0x0000000000cca947ULL, 0x004fea0003800000ULL, 0x000000081100720bULL, 0x000fe40003f54000ULL,
0x00000011081e7209ULL, 0x000fca0007810000ULL, 0x8000001e08107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x000000010200780cULL, 0x000fe40003f45270ULL, 0x0000ffff08127812ULL, 0x000fe200078e3cffULL,
0x0000001000107308ULL, 0x000e660000000800ULL, 0x0000001213ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff2b7807ULL, 0x000fc60001800000ULL, 0x01c4801e5d00a388ULL, 0x000fe80000000800ULL,
0x00001f5010087589ULL, 0x002e6400000e0000ULL, 0x8000001e11123221ULL, 0x000fe20000010000ULL,
0x000000100b0b7220ULL, 0x000fe20000410000ULL, 0x00001f0f10117589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b12123820ULL, 0x000fc80000410000ULL, 0x00000012000d3308ULL, 0x000ee20000000800ULL,
0x000000084c4c7220ULL, 0x082fe20000410000ULL, 0x000000084d4d7220ULL, 0x080fe20000410000ULL,
0x0000000848487220ULL, 0x080fe20000410000ULL, 0x0000000849497220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000845457220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x080fe20000410000ULL,
0x0000000824247220ULL, 0x080fe20000410000ULL, 0x0000000825257220ULL, 0x000fe20000410000ULL,
0x000000114e4e7220ULL, 0x084fe20000410000ULL, 0x000000114f4f7220ULL, 0x080fe20000410000ULL,
0x000000114a4a7220ULL, 0x080fe20000410000ULL, 0x000000114b4b7220ULL, 0x080fe20000410000ULL,
0x0000001146467220ULL, 0x080fe20000410000ULL, 0x0000001147477220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x080fe20000410000ULL,
0x000000111a1a7220ULL, 0x080fe20000410000ULL, 0x000000111b1b7220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x000fe20000410000ULL,
0x000000ffff087224ULL, 0x000fc400078e001eULL, 0x0000007c0d7c3220ULL, 0x008fce0000410000ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x000000085c137824ULL, 0x000fc800078e0205ULL,
0x01c6481c130075a7ULL, 0x000e64000800017fULL, 0x000000fc003c8947ULL, 0x002fea0003800000ULL,
0x000000002c1c783bULL, 0x000e620000004200ULL, 0x0000000dff6e723eULL, 0x000fe200000010ffULL,
0x0000000b7c0b7221ULL, 0x000fe20000010000ULL, 0x000099102b2b7816ULL, 0x000fe200000000ffULL,
0x012800004010783bULL, 0x000fe20000000200ULL, 0x000054106e707816ULL, 0x000fe4000000006eULL,
0x000000ff2b00720cULL, 0x000fe40003f05270ULL, 0x000000ff2dff7812ULL, 0x000fe2000784c0ffULL,
0x00001f5070797589ULL, 0x000ea800000e0000ULL, 0x00001f0f70767589ULL, 0x000ee200000e0000ULL,
0x000001001c6d7824ULL, 0x042fe200078e00ffULL, 0x000088801c2a7816ULL, 0x000fe200000000ffULL,
0x000001001d2b7824ULL, 0x040fe200078e00ffULL, 0x000088801d6e7816ULL, 0x000fc400000000ffULL,
0x0000007910108232ULL, 0x084fe20000200000ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000007912128232ULL, 0x000fe20000200000ULL, 0x00000018ff6f7819ULL, 0x000fe2000001142bULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x00000018ff297819ULL, 0x000fe2000001141cULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe2000001141dULL,
0x000100001d1d7824ULL, 0x000fe400078e00ffULL, 0x0000007611118232ULL, 0x088fe20000200000ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000006d006d7306ULL, 0x000e620000202400ULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0000007613138232ULL, 0x000fcc0000200000ULL,
0x0000006e006e7306ULL, 0x000ff00000202400ULL, 0x0000006f006f7306ULL, 0x000eb00000202400ULL,
0x0000002900297306ULL, 0x000ff00000202400ULL, 0x0000002800287306ULL, 0x000ff00000202400ULL,
0x0000001c00707306ULL, 0x0002f00000202400ULL, 0x0000001d002b7306ULL, 0x0005220000202400ULL,
0x000054102a1c7816ULL, 0x002fe2000000006dULL, 0x000000106a6d7824ULL, 0x000fe200078e0277ULL,
0x000054106e1d7816ULL, 0x004fc4000000006fULL, 0x00000018ff6f7819ULL, 0x000fe4000001141eULL,
0x00000018ff6e7819ULL, 0x000fc6000001141fULL, 0x0000001c104c723cULL, 0x000fe2000004184cULL,
0x0000006f006f7306ULL, 0x000fec0000202400ULL, 0x00005410701c7816ULL, 0x008fe20000000029ULL,
0x000001001f707824ULL, 0x000fe200078e00ffULL, 0x000054102b1d7816ULL, 0x010fe20000000028ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x000088801e287816ULL, 0x000fc400000000ffULL,
0x00000018ff707819ULL, 0x000fc60000011470ULL, 0x0000001c1048723cULL, 0x000fe60000041848ULL,
0x0000007000707306ULL, 0x000fe80000202400ULL, 0x000001001e1d7824ULL, 0x040fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x000fe400078e0028ULL, 0x000000006d28783bULL, 0x000e620000004200ULL,
0x00000018ff737819ULL, 0x000fe2000001141dULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x000088801f1d7816ULL, 0x040fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000001c001c7306ULL, 0x000fe40000202400ULL, 0x00000018ff1e7819ULL, 0x000fc4000001141eULL,
0x00000018ff727819ULL, 0x000fc8000001141fULL, 0x0000007300737306ULL, 0x000eb00000202400ULL,
0x0000001d001d7306ULL, 0x000ee20000202400ULL, 0x000054101c1c7816ULL, 0x004fce0000000073ULL,
0x0000001e001e7306ULL, 0x000ea20000202400ULL, 0x000054101d1d7816ULL, 0x008fce0000000070ULL,
0x00000072001f7306ULL, 0x0007220000202400ULL, 0x00000018ff707819ULL, 0x002fe2000001142bULL,
0x0000001c1044723cULL, 0x000fe20000041844ULL, 0x000001002b727824ULL, 0x008fca00078e00ffULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x000054101e1c7816ULL, 0x004fe2000000006fULL,
0x00000100296f7824ULL, 0x000fe200078e00ffULL, 0x000054101f1d7816ULL, 0x010fe4000000006eULL,
0x00008880296e7816ULL, 0x040fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff1f7819ULL, 0x000fe20000011428ULL, 0x0000001c1020723cULL, 0x000fe20000041820ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x00000018ff1e7819ULL, 0x000fe20000011429ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fc60000011472ULL,
0x00000100281d7824ULL, 0x040fe200078e00ffULL, 0x00008880281c7816ULL, 0x040fe200000000ffULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000001c001c7306ULL, 0x000ff00000202400ULL,
0x0000001d001d7306ULL, 0x000e700000202400ULL, 0x0000001f001f7306ULL, 0x000fe20000202400ULL,
0x000054101c1c7816ULL, 0x002fce000000001dULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x000054106e1d7816ULL, 0x000fe2000000006fULL, 0x00000010696e7824ULL, 0x000fcc00078e0277ULL,
0x0000002800287306ULL, 0x000e620000202400ULL, 0x0000001c1034723cULL, 0x000fee0000041834ULL,
0x0000002900297306ULL, 0x000ea20000202400ULL, 0x00000018ff1d7819ULL, 0x000fe4000001142aULL,
0x00005410281c7816ULL, 0x002fca000000001fULL, 0x0000001d006f7306ULL, 0x0005e20000202400ULL,
0x000088802a287816ULL, 0x000fce00000000ffULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x00005410291d7816ULL, 0x004fe4000000001eULL, 0x000088802b297816ULL, 0x040fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fc800078e00ffULL, 0x0000001c1018723cULL, 0x000fe20000041818ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x00000018ff2b7819ULL, 0x000fca000001142bULL,
0x000001002a1c7824ULL, 0x040fe400078e00ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x0000007200727306ULL, 0x000e640000202400ULL, 0x00000018ff737819ULL, 0x000fe4000001141cULL,
0x000000006e1c783bULL, 0x000ea20000004200ULL, 0x00000018ff2a7819ULL, 0x000fc6000001142aULL,
0x0000007300737306ULL, 0x000ee20000202400ULL, 0x0000541029297816ULL, 0x002fce0000000072ULL,
0x0000002a002a7306ULL, 0x000e620000202400ULL, 0x0000541028287816ULL, 0x008fce0000000073ULL,
0x0000002b002b7306ULL, 0x000ee20000202400ULL, 0x000000281014723cULL, 0x000fee0000041814ULL,
0x000054102a287816ULL, 0x002fe4000000006fULL, 0x000054102b297816ULL, 0x008fe20000000070ULL,
0x000001001d727824ULL, 0x004fe200078e00ffULL, 0x000088801c6f7816ULL, 0x000fca00000000ffULL,
0x000000281024723cULL, 0x000fe20000041824ULL, 0x000088801d707816ULL, 0x040fe200000000ffULL,
0x000100001c2a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x000100001d737824ULL, 0x000fe200078e00ffULL, 0x0000006f006f7306ULL, 0x000fe40000202400ULL,
0x000001001c107824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe4000001141cULL,
0x00000018ff287819ULL, 0x000fc4000001141dULL, 0x00000018ff2b7819ULL, 0x000fe20000011410ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x012800000e10783bULL, 0x000e620000000200ULL,
0x00000018ff2a7819ULL, 0x000fcc000001142aULL, 0x0000002b001c7306ULL, 0x0004f00000202400ULL,
0x00000072001d7306ULL, 0x000f220000202400ULL, 0x00000018ff2b7819ULL, 0x004fe40000011473ULL,
0x000054106f1c7816ULL, 0x008fca000000001cULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x00000010666f7824ULL, 0x000fe200078e0277ULL, 0x00005410701d7816ULL, 0x010fcc000000001dULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x000088801f707816ULL, 0x000fce00000000ffULL,
0x0000002a002a7306ULL, 0x000ea20000202400ULL, 0x0000007910108232ULL, 0x082fe40000200000ULL,
0x0000007912128232ULL, 0x000fe40000200000ULL, 0x0000007611118232ULL, 0x080fe40000200000ULL,
0x0000007613138232ULL, 0x000fe20000200000ULL, 0x0000002b002b7306ULL, 0x000e6c0000202400ULL,
0x0000001c104c723cULL, 0x000fe4000004184cULL, 0x0000007000707306ULL, 0x000fea0000202400ULL,
0x000054102a1c7816ULL, 0x004fc40000000029ULL, 0x000054102b1d7816ULL, 0x002fe40000000028ULL,
0x000088801e287816ULL, 0x000fca00000000ffULL, 0x0000001c1048723cULL, 0x000fee0000041848ULL,
0x000001001e1d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x000fe400078e0028ULL,
0x000001001f287824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc6000001141dULL,
0x0000001c001c7306ULL, 0x000fe20000202400ULL, 0x00000018ff727819ULL, 0x000fe40000011428ULL,
0x000000006f28783bULL, 0x000e6a0000004200ULL, 0x0000001d001d7306ULL, 0x000eb00000202400ULL,
0x0000007200737306ULL, 0x000ee20000202400ULL, 0x000054101c1c7816ULL, 0x004fc4000000001dULL,
0x00005410701d7816ULL, 0x008fe20000000073ULL, 0x000100001f707824ULL, 0x000fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011470ULL, 0x0000001c1044723cULL, 0x000fe20000041844ULL,
0x0000010028737824ULL, 0x002fc800078e00ffULL, 0x0000007200727306ULL, 0x000fe40000202400ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141eULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141fULL, 0x0000888028707816ULL, 0x000fe400000000ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000001c001c7306ULL, 0x000fe20000202400ULL,
0x00000018ff737819ULL, 0x000fc40000011473ULL, 0x00008880297a7816ULL, 0x000fca00000000ffULL,
0x0000001e001f7306ULL, 0x000e700000202400ULL, 0x0000001d001d7306ULL, 0x000ea20000202400ULL,
0x000054101f1c7816ULL, 0x002fe2000000001cULL, 0x00000100291f7824ULL, 0x000fcc00078e00ffULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00005410721d7816ULL, 0x004fca000000001dULL, 0x0000007300737306ULL, 0x000e620000202400ULL,
0x00000018ff727819ULL, 0x000fe2000001142aULL, 0x0000001c1020723cULL, 0x000fec0000041820ULL,
0x0000007a001e7306ULL, 0x000fe20000202400ULL, 0x00005410701c7816ULL, 0x002fce0000000073ULL,
0x0000001f001f7306ULL, 0x000e700000202400ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x000054101e1d7816ULL, 0x002fe2000000001fULL, 0x000001002a1e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141eULL, 0x0000001c1034723cULL, 0x000fe20000041834ULL,
0x000001002b1e7824ULL, 0x000fc800078e00ffULL, 0x0000001f001f7306ULL, 0x000fe20000202400ULL,
0x00000018ff7a7819ULL, 0x000fe4000001141eULL, 0x00000018ff1c7819ULL, 0x000fe20000011428ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe20000011429ULL,
0x0001000029297824ULL, 0x000fe400078e00ffULL, 0x0000007a001e7306ULL, 0x000fe20000202400ULL,
0x00000018ff737819ULL, 0x000fe40000011428ULL, 0x00000018ff707819ULL, 0x000fc40000011429ULL,
0x000088802a287816ULL, 0x000fe400000000ffULL, 0x000088802b297816ULL, 0x000fe200000000ffULL,
0x0000001c001c7306ULL, 0x000ff00000202400ULL, 0x0000007300737306ULL, 0x000e700000202400ULL,
0x0000001d001d7306ULL, 0x000fe20000202400ULL, 0x00005410731c7816ULL, 0x002fce000000001cULL,
0x0000007000707306ULL, 0x000e620000202400ULL, 0x000100002a737824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142bULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000002800287306ULL, 0x000ea20000202400ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00005410701d7816ULL, 0x002fca000000001dULL,
0x0000002900297306ULL, 0x000e620000202400ULL, 0x0000001065707824ULL, 0x000fe200078e0277ULL,
0x0000001c1018723cULL, 0x000fe20000041818ULL, 0x0000541028287816ULL, 0x004fca000000001fULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x0000541029297816ULL, 0x002fce000000001eULL,
0x0000007300737306ULL, 0x000e620000202400ULL, 0x00000000701c783bULL, 0x000ea20000004200ULL,
0x000000281014723cULL, 0x000fec0000041814ULL, 0x0000002b002b7306ULL, 0x000ee20000202400ULL,
0x0000541073287816ULL, 0x002fe40000000072ULL, 0x000054102b297816ULL, 0x008fce000000002aULL,
0x000000281024723cULL, 0x000fe20000041824ULL, 0x012800005f10783bULL, 0x000e6c0000000200ULL,
0x000001001c297824ULL, 0x044fe200078e00ffULL, 0x000088801c287816ULL, 0x000fe200000000ffULL,
0x000001001d2b7824ULL, 0x040fe200078e00ffULL, 0x000088801d2a7816ULL, 0x000fc400000000ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x00000018ff727819ULL, 0x000fe2000001141cULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fc8000001141dULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000002900297306ULL, 0x000eb00000202400ULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x0000007910108232ULL, 0x002fe20000200000ULL,
0x0000541028287816ULL, 0x004fcc0000000029ULL, 0x0000002b002b7306ULL, 0x000e620000202400ULL,
0x0000007912128232ULL, 0x000fe40000200000ULL, 0x0000007611118232ULL, 0x080fe40000200000ULL,
0x0000007613138232ULL, 0x000fc60000200000ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x000054102a297816ULL, 0x002fce000000002bULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000088801e2a7816ULL, 0x000fe200000000ffULL, 0x00000028104c723cULL, 0x000fec000004184cULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x000100001d287824ULL, 0x000fce00078e00ffULL,
0x0000001c001d7306ULL, 0x0002a20000202400ULL, 0x00000018ff7a7819ULL, 0x000fe20000011428ULL,
0x000001001e287824ULL, 0x000fcc00078e00ffULL, 0x0000007a007a7306ULL, 0x000ee20000202400ULL,
0x000001001f1c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe40000011428ULL,
0x000088801f287816ULL, 0x000fe400000000ffULL, 0x00000018ff297819ULL, 0x000fe4000001141cULL,
0x0000002b002b7306ULL, 0x000e620000202400ULL, 0x000054101d1c7816ULL, 0x004fe20000000072ULL,
0x0000001064727824ULL, 0x000fe200078e0277ULL, 0x000054107a1d7816ULL, 0x008fca0000000073ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x000100001f737824ULL, 0x000fe200078e00ffULL,
0x0000001c1048723cULL, 0x000fe80000041848ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000002900297306ULL, 0x000ea20000202400ULL, 0x000054102a1c7816ULL, 0x002fce000000002bULL,
0x00000073007a7306ULL, 0x000fe20000202400ULL, 0x00005410281d7816ULL, 0x004fe40000000029ULL,
0x000000007228783bULL, 0x000e6a0000004200ULL, 0x0000001c1044723cULL, 0x000fee0000041844ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141eULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc8000001141fULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000001c001c7306ULL, 0x000ff00000202400ULL, 0x0000001d001d7306ULL, 0x000eb00000202400ULL,
0x0000001e001f7306ULL, 0x0002e20000202400ULL, 0x000054107a1d7816ULL, 0x004fc4000000001dULL,
0x00008880291e7816ULL, 0x002fe400000000ffULL, 0x000054101f1c7816ULL, 0x008fe2000000001cULL,
0x00000100291f7824ULL, 0x000fc600078e00ffULL, 0x0000001e001e7306ULL, 0x000fe40000202400ULL,
0x00000018ff737819ULL, 0x000fe2000001141fULL, 0x0000001c1020723cULL, 0x000fea0000041820ULL,
0x0000007300737306ULL, 0x000fe40000202400ULL, 0x00000100281d7824ULL, 0x040fe200078e00ffULL,
0x00008880281c7816ULL, 0x000fc800000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c001c7306ULL, 0x000ff00000202400ULL, 0x0000001d001d7306ULL, 0x000e640000202400ULL,
0x000054101c1c7816ULL, 0x002fc4000000001dULL, 0x000054101e1d7816ULL, 0x000fe20000000073ULL,
0x000001002a1e7824ULL, 0x000fe400078e00ffULL, 0x0000001068737824ULL, 0x000fc800078e0277ULL,
0x0000001c1034723cULL, 0x000fee0000041834ULL, 0x00000018ff1c7819ULL, 0x000fe20000011428ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe20000011429ULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe20000011428ULL,
0x0000001c001c7306ULL, 0x000fe20000202400ULL, 0x00000018ff7a7819ULL, 0x000fe40000011429ULL,
0x00000018ff297819ULL, 0x000fe4000001141eULL, 0x000088802a287816ULL, 0x000fe400000000ffULL,
0x000088802b1e7816ULL, 0x000fe200000000ffULL, 0x0000001f001f7306ULL, 0x000e700000202400ULL,
0x0000001d001d7306ULL, 0x000fe20000202400ULL, 0x000054101f1c7816ULL, 0x002fe2000000001cULL,
0x000001002b1f7824ULL, 0x000fcc00078e00ffULL, 0x0000007a007a7306ULL, 0x000e620000202400ULL,
0x00000018ff7b7819ULL, 0x000fce000001141fULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x000054107a1d7816ULL, 0x002fce000000001dULL, 0x0000002900297306ULL, 0x000e620000202400ULL,
0x000100002b7a7824ULL, 0x000fe200078e00ffULL, 0x0000001c1018723cULL, 0x000fe80000041818ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x00005410281c7816ULL, 0x002fce0000000029ULL, 0x0000007b001f7306ULL, 0x000e620000202400ULL,
0x00000018ff287819ULL, 0x000fe2000001142aULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc8000001142bULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x000054101e1d7816ULL, 0x002fce000000001fULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x0000001c1014723cULL, 0x000fe20000041814ULL,
0x00000000731c783bULL, 0x000e6c0000004200ULL, 0x0000002a002b7306ULL, 0x000eb00000202400ULL,
0x0000007a007a7306ULL, 0x000ee20000202400ULL, 0x000054102b287816ULL, 0x004fc40000000028ULL,
0x000054107a297816ULL, 0x008fce0000000029ULL, 0x000000281010723cULL, 0x000fe20000041824ULL,
0x012800006024783bULL, 0x000eac0000000200ULL, 0x000001001c297824ULL, 0x042fe200078e00ffULL,
0x000088801c287816ULL, 0x000fe200000000ffULL, 0x000001001d2b7824ULL, 0x040fe200078e00ffULL,
0x000088801d2a7816ULL, 0x000fc400000000ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002800287306ULL, 0x000ff00000202400ULL,
0x0000002900297306ULL, 0x000e700000202400ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x0000541028287816ULL, 0x002fce0000000029ULL, 0x0000002b002b7306ULL, 0x000e620000202400ULL,
0x0000007924248232ULL, 0x084fe40000200000ULL, 0x0000007926268232ULL, 0x000fe20000200000ULL,
0x00000018ff797819ULL, 0x000fe2000001141dULL, 0x0000007625258232ULL, 0x080fe40000200000ULL,
0x0000007627278232ULL, 0x000fe20000200000ULL, 0x00000018ff767819ULL, 0x000fe2000001141cULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x0000007900797306ULL, 0x000fe20000202400ULL,
0x000000ff78ff7812ULL, 0x000fc4000780c0ffULL, 0x00000001ff787807ULL, 0x000fe40001000000ULL,
0x000054102a297816ULL, 0x002fe4000000002bULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000007600767306ULL, 0x000fe20000202400ULL, 0x000088801e2a7816ULL, 0x000fe400000000ffULL,
0x0000000b71007c0cULL, 0x000fe2000bf41070ULL, 0x00000028244c723cULL, 0x000fe4000004184cULL,
0x00000000003f7886ULL, 0x000fc40000000100ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x000000013f0e7887ULL, 0x000fe4000c000000ULL, 0x000100001d287824ULL, 0x000fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011428ULL, 0x0000001c001d7306ULL, 0x0002a20000202400ULL,
0x000001001e287824ULL, 0x000fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe40000011428ULL,
0x0000007a007a7306ULL, 0x000ee20000202400ULL, 0x000001001f1c7824ULL, 0x042fe200078e00ffULL,
0x000088801f287816ULL, 0x000fc800000000ffULL, 0x00000018ff297819ULL, 0x000fe4000001141cULL,
0x0000002b002b7306ULL, 0x000e620000202400ULL, 0x000054101d1c7816ULL, 0x004fe20000000076ULL,
0x0000001067767824ULL, 0x000fe200078e0277ULL, 0x000054107a1d7816ULL, 0x008fca0000000079ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x000100001f797824ULL, 0x000fe200078e00ffULL,
0x0000001c2448723cULL, 0x000fe80000041848ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000002900297306ULL, 0x000ea20000202400ULL, 0x000054102a1c7816ULL, 0x002fce000000002bULL,
0x00000079007a7306ULL, 0x0003e20000202400ULL, 0x00005410281d7816ULL, 0x004fe40000000029ULL,
0x000000007628783bULL, 0x000e620000004200ULL, 0x01c6586205ff79a7ULL, 0x0005e8000850003fULL,
0x0000001c2444723cULL, 0x000fe20000041844ULL, 0x01c6206205ff79a7ULL, 0x0005ec000850003fULL,
0x00000018ff1c7819ULL, 0x000fe2000001141eULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc8000001141fULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000001c001c7306ULL, 0x000ff00000202400ULL, 0x0000001d001d7306ULL, 0x000ef00000202400ULL,
0x0000001e001f7306ULL, 0x0008a20000202400ULL, 0x0000010029797824ULL, 0x002fe200078e00ffULL,
0x000054107a1d7816ULL, 0x008fc4000000001dULL, 0x00000018ff1e7819ULL, 0x010fe40000011429ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x000054101f1c7816ULL, 0x004fe4000000001cULL,
0x00000079007a7306ULL, 0x000fe20000202400ULL, 0x00000018ff1f7819ULL, 0x000fc80000011428ULL,
0x0000001c2420723cULL, 0x000fe60000041820ULL, 0x0000001f001f7306ULL, 0x000fe80000202400ULL,
0x00000100281d7824ULL, 0x040fe200078e00ffULL, 0x00008880281c7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe400078e00ffULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x00000018ff7b7819ULL, 0x000fc4000001141dULL, 0x00008880291d7816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fc60000011428ULL,
0x0000001c001c7306ULL, 0x000fe20000202400ULL, 0x00000018ff297819ULL, 0x000fce0000011429ULL,
0x0000007b007b7306ULL, 0x000e700000202400ULL, 0x0000001d001d7306ULL, 0x000ea20000202400ULL,
0x000054101c1c7816ULL, 0x002fce000000007bULL, 0x0000002800287306ULL, 0x000e620000202400ULL,
0x000054101d1d7816ULL, 0x004fce000000007aULL, 0x0000002900297306ULL, 0x000ea20000202400ULL,
0x0000001c2434723cULL, 0x000fee0000041834ULL, 0x00005410281c7816ULL, 0x002fe2000000001fULL,
0x000001002b287824ULL, 0x000fe200078e00ffULL, 0x00005410291d7816ULL, 0x004fc4000000001eULL,
0x00000018ff1e7819ULL, 0x000fe4000001142bULL, 0x00000018ff7a7819ULL, 0x000fe20000011428ULL,
0x000100002a287824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001142aULL,
0x0000001c2418723cULL, 0x000fe20000041818ULL, 0x0000001e001e7306ULL, 0x000fe40000202400ULL,
0x00000018ff287819ULL, 0x000fc80000011428ULL, 0x000001002a1d7824ULL, 0x040fe200078e00ffULL,
0x000088802a1c7816ULL, 0x000fe200000000ffULL, 0x0000001f001f7306ULL, 0x000fe60000202400ULL,
0x00000018ff797819ULL, 0x000fe4000001141dULL, 0x000088802b1d7816ULL, 0x040fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fe400078e00ffULL, 0x0000001c001c7306ULL, 0x000fe60000202400ULL,
0x00000018ff297819ULL, 0x000fca000001142bULL, 0x0000007900797306ULL, 0x000e700000202400ULL,
0x0000001d001d7306ULL, 0x000fe20000202400ULL, 0x000054101c1c7816ULL, 0x002fce0000000079ULL,
0x0000007a002a7306ULL, 0x0002a20000202400ULL, 0x0000000eff797e24ULL, 0x000fce000f8e00ffULL,
0x0000002800287306ULL, 0x000ee20000202400ULL, 0x00000001617a7812ULL, 0x002fc8000780c0ffULL,
0x0000002d78717207ULL, 0x000fe40004000000ULL, 0x000054101d1d7816ULL, 0x004fe2000000002aULL,
0x0000002900297306ULL, 0x000e6c0000202400ULL, 0x0000001c2414723cULL, 0x000fee0000041814ULL,
0x00005410281c7816ULL, 0x008fc4000000001fULL, 0x00005410291d7816ULL, 0x002fce000000001eULL,
0x0000001c2424723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000004c0088a947ULL, 0x000fde0003800000ULL, 0x000000013f0a7887ULL, 0x000fe2000c000000ULL,
0x0000000606287e24ULL, 0x020fe4000f8e0209ULL, 0x0000001056297824ULL, 0x000fe200078e0277ULL,
0x0000001f0a0f7899ULL, 0x000fe4000800063fULL, 0x0000003f281d7812ULL, 0x000fc800078ef859ULL,
0x0000000fff107e24ULL, 0x000fc8000f8e00ffULL, 0x01c65810050075a7ULL, 0x0002a4000804007fULL,
0x000000c003107811ULL, 0x002fc800078e40ffULL, 0x0000000b10117c48ULL, 0x000fca000ffe0000ULL,
0x0000000111117824ULL, 0x000fca00078e0a10ULL, 0x0000004011117807ULL, 0x000fc80000800000ULL,
0x0000001104137248ULL, 0x000fe20007fe0000ULL, 0x000001001d107825ULL, 0x000fe200078e0074ULL,
0x0000003f281d7812ULL, 0x000fc600078ef855ULL, 0x0000000113067824ULL, 0x000fe200078e0a04ULL,
0x0000005810127210ULL, 0x000fc80007f9e0ffULL, 0x000000065b00720cULL, 0x080fe20003f66070ULL,
0x000000ffff137224ULL, 0x000fe200020e0611ULL, 0x000000065700720cULL, 0x000fe20003f26070ULL,
0x000001001d107825ULL, 0x000fe200078e0074ULL, 0x0000000000102947ULL, 0x004ff60003800000ULL,
0x0000001f0a0a7899ULL, 0x000fcc000800063fULL, 0x0000000aff1c7e24ULL, 0x000fc8000f8e00ffULL,
0x01c6581c050075a7ULL, 0x000e64000804017fULL, 0x000000dc0094a947ULL, 0x002fea0003800000ULL,
0x00000058101e7210ULL, 0x000fe20007f5e0ffULL, 0x00000010542b7824ULL, 0x000fe200078e0277ULL,
0x0000003f281d7812ULL, 0x000fe200078ef852ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012297faeULL, 0x0003e2000d901c4cULL, 0x0000003f28797812ULL, 0x000fe200078ef842ULL,
0x000000ffff1f7224ULL, 0x000fe200010e0611ULL, 0x000000065300720cULL, 0x080fe20003f46070ULL,
0x000001001d107825ULL, 0x000fe200078e0074ULL, 0x000000063d00720cULL, 0x000fe40003f66070ULL,
0x000000001e2b7faeULL, 0x0005e2000c901c4cULL, 0x00000010327b7824ULL, 0x000fe200078e0277ULL,
0x00000058101c7210ULL, 0x000fc40007f3e0ffULL, 0x0000ffff71717812ULL, 0x000fe200078ec0ffULL,
0x0000001051297824ULL, 0x002fe400078e0277ULL, 0x000000ffff1d7224ULL, 0x000fe200008e0611ULL,
0x000000064300720cULL, 0x000fe20003f26070ULL, 0x0000010079107825ULL, 0x000fe200078e0074ULL,
0x0000003f28797812ULL, 0x000fe400078ef83eULL, 0x000000001c297faeULL, 0x0003e2000d101c4cULL,
0x00000010412b7824ULL, 0x004fe200078e0277ULL, 0x0000005810127210ULL, 0x000fc40007f5e0ffULL,
0x0000000363107812ULL, 0x000fc600078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0611ULL,
0x000000031000780cULL, 0x000fe20003f45270ULL, 0x0000010079107825ULL, 0x000fe200078e0074ULL,
0x0000003f28797812ULL, 0x000fe400078ef83bULL, 0x000000015e2a7807ULL, 0x000fe20005000000ULL,
0x00000000122b7faeULL, 0x0005e2000c901c4cULL, 0x00000058101e7210ULL, 0x000fe20007f3e0ffULL,
0x000000103c297824ULL, 0x002fe200078e0277ULL, 0x000000063f00720cULL, 0x000fe20003f46070ULL,
0x0000000163637824ULL, 0x000fc400078e022aULL, 0x000000ffff1f7224ULL, 0x000fe400008e0611ULL,
0x0000010079107825ULL, 0x000fe200078e0074ULL, 0x0000000463007c0cULL, 0x000fe4000bf26070ULL,
0x0000003f28137812ULL, 0x004fe200078ef838ULL, 0x000000103a797824ULL, 0x100fe200078e0277ULL,
0x00000058101c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001030777824ULL, 0x000fe400078e0277ULL,
0x000000001e297faeULL, 0x0003e2000d101c4cULL, 0x000000063900720cULL, 0x000fe20003f46070ULL,
0x000000ffff1d7224ULL, 0x000fc400020e0611ULL, 0x0000010013107825ULL, 0x000fe400078e0074ULL,
0x00008c00ff129b82ULL, 0x000ea20000000a00ULL, 0x000000001c797faeULL, 0x0007e2000d901c4cULL,
0x00000058102a7210ULL, 0x000fe20007f7e0ffULL, 0x00000001631f9824ULL, 0x002fc800078e020aULL,
0x000000ffff2b7224ULL, 0x000fe200018e0611ULL, 0x0000003f28117812ULL, 0x000fc800078ef831ULL,
0x000000002a7b7faeULL, 0x0003e2000d101c4cULL, 0x0000010011107825ULL, 0x000fe200078e0074ULL,
0x000000063300720cULL, 0x000fe40003f46070ULL, 0x00008880711c7816ULL, 0x008fe200000000ffULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x0000005810107210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe400018e0611ULL, 0x000000041f129825ULL, 0x004fc600078e0012ULL,
0x0000000010777faeULL, 0x0003e2000d101c4cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000c12069981ULL, 0x000362000c1e1900ULL, 0x800000005a1e7824ULL, 0x000fe400078e00ffULL,
0x800000001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a48ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0000001c6b0075a7ULL, 0x0004a20008020047ULL,
0x01c6281e050075a7ULL, 0x000ee4000804017fULL, 0x000000d8009ca947ULL, 0x00cfea0003800000ULL,
0x01c100005d117984ULL, 0x002e620000000800ULL, 0x000000106c1d7824ULL, 0x000fe400078e022fULL,
0x00000001ff287424ULL, 0x000fe200078e00ffULL, 0x01c300005d6c7984ULL, 0x0004a20000000800ULL,
0x000000081100720bULL, 0x002fda0003f5d000ULL, 0x0000000000107806ULL, 0x000fc800010e0100ULL,
0x0000ffff10137812ULL, 0x000fda000784c0ffULL, 0x0000000000cca947ULL, 0x004fea0003800000ULL,
0x000000081100720bULL, 0x000fe40003f54000ULL, 0x0000001108107209ULL, 0x000fca0007810000ULL,
0x8000001008127221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b12127820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400010e0100ULL, 0x000000020200780cULL, 0x000fe40003f45270ULL,
0x0000ffff081e7812ULL, 0x000fe200078e3cffULL, 0x0000001200127308ULL, 0x000e660000000800ULL,
0x0000001e13ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff287807ULL, 0x000fc60001800000ULL,
0x01c500105d00a388ULL, 0x000fe80000000800ULL, 0x00001f5012087589ULL, 0x002e6400000e0000ULL,
0x8000001011133221ULL, 0x000fe20000010000ULL, 0x000000120b0b7220ULL, 0x000fe20000410000ULL,
0x00001f0f12117589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b13133820ULL, 0x000fc80000410000ULL,
0x00000013000d3308ULL, 0x000ee20000000800ULL, 0x000000084c4c7220ULL, 0x082fe20000410000ULL,
0x000000084d4d7220ULL, 0x080fe20000410000ULL, 0x0000000848487220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x0000000844447220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x000fe20000410000ULL, 0x000000114e4e7220ULL, 0x084fe20000410000ULL,
0x000000114f4f7220ULL, 0x080fe20000410000ULL, 0x000000114a4a7220ULL, 0x080fe20000410000ULL,
0x000000114b4b7220ULL, 0x080fe20000410000ULL, 0x0000001146467220ULL, 0x080fe20000410000ULL,
0x0000001147477220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x0000001136367220ULL, 0x080fe20000410000ULL,
0x0000001137377220ULL, 0x080fe20000410000ULL, 0x000000111a1a7220ULL, 0x080fe20000410000ULL,
0x000000111b1b7220ULL, 0x080fe20000410000ULL, 0x0000001116167220ULL, 0x080fe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x0000001126267220ULL, 0x080fe20000410000ULL,
0x0000001127277220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e0010ULL,
0x0000006c0d6c3220ULL, 0x008fce0000410000ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x0000000161107812ULL, 0x000fca00078ec0ffULL, 0x0000000810137824ULL, 0x000fc800078e0205ULL,
0x01c6481c130075a7ULL, 0x000e64000802017fULL, 0x000000d400bc9947ULL, 0x002fea0003800000ULL,
0x000000001d1c783bULL, 0x000e620000004200ULL, 0x0000000dff2b723eULL, 0x000fe200000010ffULL,
0x000000013f0a7887ULL, 0x000fe20008000000ULL, 0x0000991028777816ULL, 0x000fe200000000ffULL,
0x013000004010783bULL, 0x000fe20000000200ULL, 0x000054102b797816ULL, 0x000fe2000000002bULL,
0x0000000b6c0b7221ULL, 0x000fe20000010000ULL, 0x000000ff7700720cULL, 0x000fc60003f25270ULL,
0x00001f5079717589ULL, 0x000ea800000e0000ULL, 0x00001f0f797a7589ULL, 0x000ee200000e0000ULL,
0x000001001c2a7824ULL, 0x042fe200078e00ffULL, 0x000088801c297816ULL, 0x000fe200000000ffULL,
0x000001001d777824ULL, 0x040fe200078e00ffULL, 0x000088801d2b7816ULL, 0x000fe400000000ffULL,
0x0000007110109232ULL, 0x084fe20000200000ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000007112129232ULL, 0x000fe20000200000ULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x0000007a11119232ULL, 0x088fe20000200000ULL,
0x000088801f797816ULL, 0x000fe200000000ffULL, 0x0000007a13139232ULL, 0x000fca0000200000ULL,
0x0000002a00287306ULL, 0x0002b00000202400ULL, 0x0000002b002b7306ULL, 0x000fe20000202400ULL,
0x000088801e2a7816ULL, 0x002fe400000000ffULL, 0x0000541029287816ULL, 0x004fca0000000028ULL,
0x00000077007c7306ULL, 0x0002b00000202400ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x00000018ff777819ULL, 0x002fe4000001141dULL, 0x000054102b297816ULL, 0x004fca000000007cULL,
0x0000007700777306ULL, 0x000fe20000202400ULL, 0x000001001e2b7824ULL, 0x000fe200078e00ffULL,
0x00000028104c723cULL, 0x000fe8000004184cULL, 0x00000018ff2b7819ULL, 0x000fc6000001142bULL,
0x00000018ff287819ULL, 0x000fe2000001141cULL, 0x000100001c1c7824ULL, 0x000fe400078e00ffULL,
0x0000002b002b7306ULL, 0x000fe20000202400ULL, 0x000100001d297824ULL, 0x000fe400078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc6000001141cULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002800287306ULL, 0x000ff00000202400ULL, 0x0000001c001d7306ULL, 0x000e700000202400ULL,
0x00000029007c7306ULL, 0x000ea20000202400ULL, 0x000054101d1c7816ULL, 0x002fe20000000028ULL,
0x000001001f1d7824ULL, 0x000fcc00078e00ffULL, 0x0000007900287306ULL, 0x000fe20000202400ULL,
0x00000018ff1d7819ULL, 0x000fce000001141dULL, 0x0000001d00297306ULL, 0x0004640000202400ULL,
0x000054107c1d7816ULL, 0x004fe20000000077ULL, 0x000100001e777824ULL, 0x000fca00078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x0000001c1048723cULL, 0x000fea0000041848ULL,
0x0000007700777306ULL, 0x000fe40000202400ULL, 0x00005410281d7816ULL, 0x002fe20000000029ULL,
0x000000106a287824ULL, 0x000fe200078e022fULL, 0x000054102a1c7816ULL, 0x000fc4000000002bULL,
0x00000018ff6a7819ULL, 0x000fe4000001141eULL, 0x00000018ff1e7819ULL, 0x000fe2000001141fULL,
0x000000002828783bULL, 0x000e620000004200ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000001c1044723cULL, 0x000fe20000041844ULL, 0x0000006a006a7306ULL, 0x000ea60000202400ULL,
0x00000018ff797819ULL, 0x000fca000001141fULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x00005410771c7816ULL, 0x004fce000000006aULL, 0x00000079001f7306ULL, 0x000ea40000202400ULL,
0x000054101f1d7816ULL, 0x004fe2000000001eULL, 0x00000100296a7824ULL, 0x002fcc00078e00ffULL,
0x0000001c1020723cULL, 0x000fe20000041820ULL, 0x00000018ff1f7819ULL, 0x000fe40000011428ULL,
0x00000018ff1e7819ULL, 0x000fe40000011429ULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000100281d7824ULL, 0x040fe200078e00ffULL, 0x00008880281c7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x0000001f001f7306ULL, 0x000fe40000202400ULL,
0x00000018ff777819ULL, 0x000fc4000001141dULL, 0x00008880291d7816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000001c001c7306ULL, 0x000fe40000202400ULL, 0x00000018ff297819ULL, 0x000fcc0000011429ULL,
0x0000007700777306ULL, 0x000e700000202400ULL, 0x0000001d001d7306ULL, 0x000fe20000202400ULL,
0x000054101c1c7816ULL, 0x002fce0000000077ULL, 0x0000006a006a7306ULL, 0x000e620000202400ULL,
0x00000018ff777819ULL, 0x000fce000001142aULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x000054101d1d7816ULL, 0x002fce000000006aULL, 0x0000002800287306ULL, 0x000e620000202400ULL,
0x00000018ff6a7819ULL, 0x000fe2000001142bULL, 0x0000001c1034723cULL, 0x000fec0000041834ULL,
0x0000002900297306ULL, 0x000ea20000202400ULL, 0x00005410281c7816ULL, 0x002fce000000001fULL,
0x0000007700777306ULL, 0x000fe20000202400ULL, 0x00005410291d7816ULL, 0x004fe2000000001eULL,
0x00000010691e7824ULL, 0x000fe200078e022fULL, 0x000088802b297816ULL, 0x040fe200000000ffULL,
0x000001002b697824ULL, 0x000fc800078e00ffULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x0000001c1018723cULL, 0x000fe20000041818ULL,
0x00000018ff697819ULL, 0x000fc60000011469ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x000001002a1d7824ULL, 0x040fe200078e00ffULL,
0x000088802a1c7816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe4000001141dULL, 0x00000069007c7306ULL, 0x000e620000202400ULL,
0x00000018ff2a7819ULL, 0x000fce000001142aULL, 0x0000001c001c7306ULL, 0x000fe20000202400ULL,
0x0000541029297816ULL, 0x002fce000000007cULL, 0x00000028001d7306ULL, 0x000e700000202400ULL,
0x0000002a002a7306ULL, 0x000ea20000202400ULL, 0x000054101c287816ULL, 0x002fce000000001dULL,
0x0000002b002b7306ULL, 0x000e620000202400ULL, 0x000000001e1c783bULL, 0x000ee20000004200ULL,
0x000000281014723cULL, 0x000fee0000041814ULL, 0x000054102a287816ULL, 0x004fe40000000077ULL,
0x000054102b297816ULL, 0x002fce000000006aULL, 0x000000281010723cULL, 0x000fe20000041824ULL,
0x013000000e24783bULL, 0x000e6c0000000200ULL, 0x000001001c297824ULL, 0x048fe200078e00ffULL,
0x000088801c287816ULL, 0x000fe200000000ffULL, 0x000001001d2b7824ULL, 0x040fe200078e00ffULL,
0x000088801d2a7816ULL, 0x000fe200000000ffULL, 0x000001001f697824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x000088801e777816ULL, 0x000fe400000000ffULL,
0x00000018ff697819ULL, 0x000fca0000011469ULL, 0x0000002900297306ULL, 0x000ea20000202400ULL,
0x0000007124249232ULL, 0x002fce0000200000ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x0000007126269232ULL, 0x000fe40000200000ULL, 0x0000007a25259232ULL, 0x080fe40000200000ULL,
0x0000007a27279232ULL, 0x000fe20000200000ULL, 0x0000541028287816ULL, 0x004fe40000000029ULL,
0x0000002b002b7306ULL, 0x000e700000202400ULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x000054102a297816ULL, 0x002fe2000000002bULL, 0x000001001e2a7824ULL, 0x000fcc00078e00ffULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x00000018ff6a7819ULL, 0x000fe2000001142aULL,
0x00000028244c723cULL, 0x000fe2000004184cULL, 0x000088801f2a7816ULL, 0x000fca00000000ffULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x00000018ff297819ULL, 0x000fe2000001141cULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe2000001141dULL,
0x000100001d1d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x00000018ff1d7819ULL, 0x000fce000001141dULL,
0x0000001c001c7306ULL, 0x000e700000202400ULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x000054101c1c7816ULL, 0x002fce0000000029ULL, 0x0000001d001d7306ULL, 0x000e620000202400ULL,
0x0000001066297824ULL, 0x000fe400078e022fULL, 0x000000ffff667224ULL, 0x000fcc00078e002aULL,
0x0000006600667306ULL, 0x000ea20000202400ULL, 0x000054101d1d7816ULL, 0x002fe40000000028ULL,
0x000000002928783bULL, 0x000e6a0000004200ULL, 0x0000001c2448723cULL, 0x000fee0000041848ULL,
0x00005410771c7816ULL, 0x000fe2000000006aULL, 0x000100001f6a7824ULL, 0x000fe200078e00ffULL,
0x00005410661d7816ULL, 0x004fe20000000069ULL, 0x000100001e697824ULL, 0x000fc600078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001146aULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000001c2444723cULL, 0x000fe60000041844ULL, 0x0000007c007c7306ULL, 0x000fe80000202400ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141eULL, 0x00000018ff1d7819ULL, 0x000fe4000001141fULL,
0x00000069001f7306ULL, 0x0005f00000202400ULL, 0x0000001c001c7306ULL, 0x000ee20000202400ULL,
0x00000100286a7824ULL, 0x042fe200078e00ffULL, 0x0000888028777816ULL, 0x000fc400000000ffULL,
0x0000888029697816ULL, 0x004fe400000000ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x0000001d001d7306ULL, 0x000e620000202400ULL, 0x00000018ff667819ULL, 0x000fe40000011428ULL,
0x00000018ff1e7819ULL, 0x000fe40000011429ULL, 0x000054101f1c7816ULL, 0x008fe2000000001cULL,
0x00000100291f7824ULL, 0x000fc400078e00ffULL, 0x0000007700777306ULL, 0x000fe60000202400ULL,
0x00000018ff7b7819ULL, 0x000fe2000001141fULL, 0x00010000281f7824ULL, 0x000fe200078e00ffULL,
0x000054107c1d7816ULL, 0x002fc6000000001dULL, 0x0000006a006a7306ULL, 0x000e620000202400ULL,
0x00000018ff797819ULL, 0x000fe2000001141fULL, 0x00010000291f7824ULL, 0x000fe400078e00ffULL,
0x0000001c2420723cULL, 0x000fe80000041820ULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00005410771c7816ULL, 0x002fca000000006aULL,
0x0000007b00287306ULL, 0x000e620000202400ULL, 0x000001002b6a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x00005410691d7816ULL, 0x002fce0000000028ULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x000088802a287816ULL, 0x000fe400000000ffULL, 0x00000018ff697819ULL, 0x000fe2000001142bULL,
0x0000001c2434723cULL, 0x000fe80000041834ULL, 0x0000007900297306ULL, 0x000e700000202400ULL,
0x0000001f001f7306ULL, 0x000ea20000202400ULL, 0x00005410291c7816ULL, 0x002fce0000000066ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x00000018ff667819ULL, 0x000fe4000001142aULL,
0x000054101f1d7816ULL, 0x004fca000000001eULL, 0x0000006a006a7306ULL, 0x000fe40000202400ULL,
0x0000001c2418723cULL, 0x000fec0000041818ULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x000001002a1c7824ULL, 0x040fe200078e00ffULL, 0x000088802b1d7816ULL, 0x000fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fca00078e00ffULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x00000018ff297819ULL, 0x000fe2000001141cULL, 0x00000010651c7824ULL, 0x000fe200078e022fULL,
0x00000018ff777819ULL, 0x000fe2000001142aULL, 0x000000ffff657224ULL, 0x000fe400078e001dULL,
0x000100002b2a7824ULL, 0x000fe400078e00ffULL, 0x0000002900297306ULL, 0x000e620000202400ULL,
0x000000001c1c783bULL, 0x000ea40000004200ULL, 0x00000018ff2a7819ULL, 0x000fca000001142aULL,
0x0000006500657306ULL, 0x000ee20000202400ULL, 0x0000541028287816ULL, 0x002fce0000000029ULL,
0x00000077002b7306ULL, 0x000e620000202400ULL, 0x0000541065297816ULL, 0x008fce000000006aULL,
0x0000002a002a7306ULL, 0x000ee20000202400ULL, 0x000000282414723cULL, 0x000fee0000041814ULL,
0x000054102b287816ULL, 0x002fe40000000066ULL, 0x000054102a297816ULL, 0x008fe20000000069ULL,
0x000001001c2a7824ULL, 0x044fe200078e00ffULL, 0x000088801c2b7816ULL, 0x000fe200000000ffULL,
0x000001001d697824ULL, 0x040fe200078e00ffULL, 0x000088801d667816ULL, 0x000fc600000000ffULL,
0x000000282424723cULL, 0x000fe20000041810ULL, 0x013000005f10783bULL, 0x000e620000000200ULL,
0x00000018ff657819ULL, 0x000fe2000001142aULL, 0x000100001c2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011469ULL, 0x000100001d697824ULL, 0x000fe200078e00ffULL,
0x0000002b002b7306ULL, 0x000fe20000202400ULL, 0x00000018ff297819ULL, 0x000fe4000001141cULL,
0x00000018ff287819ULL, 0x000fe4000001141dULL, 0x00000018ff697819ULL, 0x000fc40000011469ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x00000065001c7306ULL, 0x0004f00000202400ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x00000018ff657819ULL, 0x004fc4000001141eULL,
0x000054102b1c7816ULL, 0x008fca000000001cULL, 0x0000006a001d7306ULL, 0x000eb00000202400ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x0000007110109232ULL, 0x082fe40000200000ULL,
0x0000007112129232ULL, 0x000fc40000200000ULL, 0x0000007a11119232ULL, 0x000fc60000200000ULL,
0x0000006900697306ULL, 0x000e620000202400ULL, 0x0000007a13139232ULL, 0x000fe20000200000ULL,
0x00005410661d7816ULL, 0x004fe4000000001dULL, 0x00000018ff667819ULL, 0x000fc8000001141fULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x0000001c104c723cULL, 0x000fee000004184cULL,
0x0000002a002a7306ULL, 0x000ea20000202400ULL, 0x00005410691d7816ULL, 0x002fe20000000028ULL,
0x0000001064287824ULL, 0x000fc400078e022fULL, 0x000001001f647824ULL, 0x000fc800078e00ffULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x00000018ff7b7819ULL, 0x000fe20000011464ULL,
0x000100001e647824ULL, 0x000fe200078e00ffULL, 0x000054102a1c7816ULL, 0x004fca0000000029ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x00000018ff6a7819ULL, 0x000fe20000011464ULL, 0x0000001c1048723cULL, 0x000fea0000041848ULL,
0x0000006a006a7306ULL, 0x000fe40000202400ULL, 0x000001001e1d7824ULL, 0x040fe200078e00ffULL,
0x000088801e1c7816ULL, 0x000fca00000000ffULL, 0x0000007b001e7306ULL, 0x000fe20000202400ULL,
0x00000018ff797819ULL, 0x000fe4000001141dULL, 0x000088801f1d7816ULL, 0x040fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fc800078e00ffULL, 0x0000001c001c7306ULL, 0x000fe20000202400ULL,
0x00000018ff1f7819ULL, 0x000fce000001141fULL, 0x0000001d001d7306ULL, 0x000eb00000202400ULL,
0x0000007900797306ULL, 0x000ee20000202400ULL, 0x0000010028647824ULL, 0x042fe200078e00ffULL,
0x0000888028697816ULL, 0x000fc800000000ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x000054101d1d7816ULL, 0x004fe2000000001eULL, 0x00000100291e7824ULL, 0x000fe200078e00ffULL,
0x0000001f00777306ULL, 0x000e680000202400ULL, 0x00000018ff7b7819ULL, 0x000fe4000001141eULL,
0x000054101c1c7816ULL, 0x008fc40000000079ULL, 0x0000888029797816ULL, 0x000fe200000000ffULL,
0x0000007b001e7306ULL, 0x000fe80000202400ULL, 0x0000001c1044723cULL, 0x000fe80000041844ULL,
0x00000079001f7306ULL, 0x0004e60000202400ULL, 0x000054106a1c7816ULL, 0x000fc40000000065ULL,
0x00005410771d7816ULL, 0x002fe20000000066ULL, 0x000001002b777824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011429ULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x000088802b667816ULL, 0x000fe200000000ffULL,
0x0000000aff797e24ULL, 0x004fe2000f8e00ffULL, 0x0000001c1020723cULL, 0x000fe20000041820ULL,
0x00000018ff777819ULL, 0x000fe40000011477ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000006400647306ULL, 0x000e620000202400ULL, 0x00000018ff657819ULL, 0x000fc4000001142aULL,
0x000054101f1d7816ULL, 0x008fe4000000001eULL, 0x00000018ff1e7819ULL, 0x000fe20000011428ULL,
0x0001000028287824ULL, 0x000fe400078e00ffULL, 0x0000006a006a7306ULL, 0x000fe60000202400ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00005410691c7816ULL, 0x002fc60000000064ULL,
0x0000001e001e7306ULL, 0x000fe20000202400ULL, 0x000088802a697816ULL, 0x000fe400000000ffULL,
0x00000018ff647819ULL, 0x000fe2000001142bULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000001c1034723cULL, 0x000fe60000041834ULL, 0x00000028001d7306ULL, 0x000e620000202400ULL,
0x00000018ff2b7819ULL, 0x000fc6000001142bULL, 0x000001002a1c7824ULL, 0x040fe400078e00ffULL,
0x000100002a2a7824ULL, 0x000fe400078e00ffULL, 0x0000002900297306ULL, 0x000ea60000202400ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x000054101d287816ULL, 0x002fe2000000001eULL,
0x00000010681d7824ULL, 0x000fe200078e022fULL, 0x00000018ff687819ULL, 0x000fe2000001141cULL,
0x0000006900697306ULL, 0x000fe80000202400ULL, 0x000000001d1c783bULL, 0x000e620000004200ULL,
0x0000541029297816ULL, 0x004fc6000000006aULL, 0x0000006800687306ULL, 0x000ea80000202400ULL,
0x000000281018723cULL, 0x000fe80000041818ULL, 0x0000006600667306ULL, 0x000fe60000202400ULL,
0x0000541069287816ULL, 0x004fca0000000068ULL, 0x0000007700777306ULL, 0x000eb00000202400ULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x0000541066297816ULL, 0x004fce0000000077ULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x00000018ff697819ULL, 0x002fe2000001141dULL,
0x000000281014723cULL, 0x000fec0000041814ULL, 0x0000002a002a7306ULL, 0x000e700000202400ULL,
0x0000002b002b7306ULL, 0x000ea20000202400ULL, 0x000054102a287816ULL, 0x002fc40000000065ULL,
0x00000018ff657819ULL, 0x000fca000001141cULL, 0x00000065002a7306ULL, 0x000fe20000202400ULL,
0x000054102b297816ULL, 0x004fe40000000064ULL, 0x000088801c647816ULL, 0x000fca00000000ffULL,
0x000000281010723cULL, 0x000fe20000041824ULL, 0x013000006024783bULL, 0x000e6c0000000200ULL,
0x000001001c297824ULL, 0x040fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fe400078e0064ULL,
0x000001001d647824ULL, 0x040fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe20000011429ULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x000088801d297816ULL, 0x000fe200000000ffULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x00000018ff647819ULL, 0x000fc40000011464ULL,
0x00000018ff1c7819ULL, 0x000fca000001141cULL, 0x0000002b002b7306ULL, 0x000eb00000202400ULL,
0x0000006400667306ULL, 0x000fe20000202400ULL, 0x0000541028287816ULL, 0x004fe2000000002bULL,
0x000100001d2b7824ULL, 0x000fcc00078e00ffULL, 0x0000001c00657306ULL, 0x000ea20000202400ULL,
0x0000007124249232ULL, 0x082fe40000200000ULL, 0x0000007126269232ULL, 0x000fe20000200000ULL,
0x00000018ff687819ULL, 0x000fe2000001142bULL, 0x0000007a25259232ULL, 0x080fe40000200000ULL,
0x00000010672b7824ULL, 0x000fe400078e022fULL, 0x0000007a27279232ULL, 0x000fe20000200000ULL,
0x00000069001d7306ULL, 0x000fe20000202400ULL, 0x00000018ff677819ULL, 0x000fc4000001141fULL,
0x00000001617a7812ULL, 0x000fe400078e0cffULL, 0x00005410651c7816ULL, 0x004fc6000000002aULL,
0x0000006800647306ULL, 0x000e620000202400ULL, 0x000088801e657816ULL, 0x000fce00000000ffULL,
0x0000002900297306ULL, 0x000ea20000202400ULL, 0x00005410641d7816ULL, 0x002fe2000000001dULL,
0x000001001e647824ULL, 0x000fcc00078e00ffULL, 0x0000006500657306ULL, 0x000fe20000202400ULL,
0x0000001c2448723cULL, 0x000fe20000041848ULL, 0x0000541029297816ULL, 0x004fe40000000066ULL,
0x00000018ff667819ULL, 0x000fe2000001141eULL, 0x000100001e1e7824ULL, 0x000fc600078e00ffULL,
0x0000006700677306ULL, 0x000fe20000202400ULL, 0x00000018ff1c7819ULL, 0x000fe20000011464ULL,
0x000001001f647824ULL, 0x040fe200078e00ffULL, 0x00000028244c723cULL, 0x000fe2000004184cULL,
0x000000002b28783bULL, 0x000e620000004200ULL, 0x000088801f1d7816ULL, 0x040fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe20000011464ULL,
0x0000001c001c7306ULL, 0x000ea20000202400ULL, 0x00000018ff687819ULL, 0x000fe2000001141eULL,
0x01c6586205ff79a7ULL, 0x0007e2000850003fULL, 0x00000018ff1f7819ULL, 0x000fca000001141fULL,
0x0000001d001d7306ULL, 0x000fe20000202400ULL, 0x01c6306205ff79a7ULL, 0x0007e2000850003fULL,
0x00005410651c7816ULL, 0x004fcc000000001cULL, 0x0000006a006a7306ULL, 0x000eb00000202400ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x000054101d1d7816ULL, 0x004fce000000006aULL,
0x0000006800697306ULL, 0x000ea20000202400ULL, 0x00000018ff647819ULL, 0x002fe20000011428ULL,
0x0000001c2444723cULL, 0x000fe20000041844ULL, 0x00000018ff657819ULL, 0x000fca0000011429ULL,
0x0000001f006a7306ULL, 0x0003220000202400ULL, 0x00000018ff1e7819ULL, 0x000fe4000001142aULL,
0x00005410691c7816ULL, 0x004fca0000000066ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x00000100291f7824ULL, 0x002fe200078e00ffULL, 0x0000888028667816ULL, 0x000fc800000000ffULL,
0x00000018ff687819ULL, 0x000fe4000001141fULL, 0x000054106a1d7816ULL, 0x010fe20000000067ULL,
0x0000010028677824ULL, 0x040fe200078e00ffULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001142bULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000001c2420723cULL, 0x000fe20000041820ULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x00000067001d7306ULL, 0x000e680000202400ULL,
0x00008880291c7816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x0000001c00697306ULL, 0x0003e40000202400ULL, 0x00000018ff297819ULL, 0x000fcc0000011429ULL,
0x0000006800687306ULL, 0x000ea20000202400ULL, 0x00005410661c7816ULL, 0x002fce000000001dULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x00005410691d7816ULL, 0x004fce0000000068ULL,
0x0000002800677306ULL, 0x0002a20000202400ULL, 0x000088802a687816ULL, 0x040fe400000000ffULL,
0x000088802b697816ULL, 0x000fe200000000ffULL, 0x0000001c2434723cULL, 0x000fe80000041834ULL,
0x0000002900667306ULL, 0x000f260000202400ULL, 0x000001002a1c7824ULL, 0x000fc400078e00ffULL,
0x000001002b1d7824ULL, 0x000fc600078e00ffULL, 0x0000006800687306ULL, 0x000fe20000202400ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff6a7819ULL, 0x000fe2000001141dULL, 0x000100002a1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x002fe4000001142bULL, 0x0000001c00717306ULL, 0x0004620000202400ULL,
0x00000001612b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x000000012b00780cULL, 0x000fc60003f25070ULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x00005410671c7816ULL, 0x004fe40000000064ULL, 0x000000782d2d7207ULL, 0x000fc80004800000ULL,
0x000000ff2dff7812ULL, 0x000fe2000784c0ffULL, 0x0000006a002a7306ULL, 0x000eb00000202400ULL,
0x0000001d00297306ULL, 0x0009f00000202400ULL, 0x0000001e001e7306ULL, 0x000e620000202400ULL,
0x00005410661d7816ULL, 0x010fc40000000065ULL, 0x00000001ff657807ULL, 0x000fca0001000000ULL,
0x0000001f001f7306ULL, 0x000fe20000202400ULL, 0x0000001c2418723cULL, 0x000fee0000041818ULL,
0x0000002800287306ULL, 0x000f220000202400ULL, 0x00005410681c7816ULL, 0x002fe40000000071ULL,
0x00005410691d7816ULL, 0x004fc4000000002aULL, 0x0000007865717207ULL, 0x000fca0004800000ULL,
0x0000001c2414723cULL, 0x000fee0000041814ULL, 0x00005410291c7816ULL, 0x000fe4000000001eULL,
0x00005410281d7816ULL, 0x010fce000000001fULL, 0x0000001c2424723cULL, 0x000fee0000041810ULL,
0x000000c003107811ULL, 0x000fc800078e40ffULL, 0x0000000b10007c0cULL, 0x000fda000bf41070ULL,
0x0000002400a0a947ULL, 0x008fea0003800000ULL, 0x01c6582e050075a7ULL, 0x000e62000802007fULL,
0x0000000606137e24ULL, 0x020fe2000f8e0209ULL, 0x0000000363127812ULL, 0x000fe200078ec0ffULL,
0x0000000100067824ULL, 0x000fe400078e0203ULL, 0x000000103a2d7824ULL, 0x100fe200078e022fULL,
0x0000003f13117812ULL, 0x000fe200078ef859ULL, 0x0000000106107836ULL, 0x000fe20000000000ULL,
0x000000031200780cULL, 0x000fe20003f65270ULL, 0x0000010006067824ULL, 0x000fe200078e00ffULL,
0x0000003f13297812ULL, 0x000fe200078ef855ULL, 0x0000001032327824ULL, 0x000fe200078e022fULL,
0x0000000510007c0cULL, 0x000fe2000bf46070ULL, 0x0000010011107825ULL, 0x000fe200078e0074ULL,
0x0000003f132b7812ULL, 0x000fc400078ef83bULL, 0x0000003f131f7812ULL, 0x000fe200078ef852ULL,
0x000000103c677824ULL, 0x100fe200078e022fULL, 0x0000003f13777812ULL, 0x000fe200078ef842ULL,
0x0000001041417824ULL, 0x100fe200078e022fULL, 0x0000005810127210ULL, 0x000fe20007f9e0ffULL,
0x0000001051517824ULL, 0x100fe200078e022fULL, 0x0000003f13797812ULL, 0x000fe200078ef83eULL,
0x0000001054697824ULL, 0x100fe200078e022fULL, 0x0000003f13557812ULL, 0x000fe200078ef838ULL,
0x00000010303a7824ULL, 0x100fe200078e022fULL, 0x0000003f133b7812ULL, 0x000fe200078ef831ULL,
0x0000001056597824ULL, 0x000fe200078e022fULL, 0x000000015e5e7807ULL, 0x000fc40005800000ULL,
0x0000000b061d7c48ULL, 0x000fe2000ffe0000ULL, 0x0000000000081947ULL, 0x002fec0003800000ULL,
0x01c6582e050075a7ULL, 0x000e64000802017fULL, 0x000000b400f49947ULL, 0x002fea0003800000ULL,
0x000000011d1d7824ULL, 0x000fe400078e0a06ULL, 0x0000010029287825ULL, 0x000fc600078e0074ULL,
0x000000401d2f7807ULL, 0x000fe20001000000ULL, 0x0000000163637824ULL, 0x000fe200078e025eULL,
0x0000005828287210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0611ULL,
0x0000002f042f7248ULL, 0x000fe20007fe0000ULL, 0x0000010079107825ULL, 0x000fe200078e0074ULL,
0x0000000463007c0cULL, 0x000fc6000bf26070ULL, 0x000000012f067824ULL, 0x000fe200078e0a04ULL,
0x0000005810107210ULL, 0x000fe20007f9e0ffULL, 0x000001001f1e7825ULL, 0x000fc600078e0074ULL,
0x000000065700720cULL, 0x080fe20003fc6070ULL, 0x000000ffff297224ULL, 0x000fe200010e0629ULL,
0x000000065b00720cULL, 0x080fe20003f46070ULL, 0x000000ffff117224ULL, 0x000fe200020e0611ULL,
0x000000581e1e7210ULL, 0x000fe20007f7e0ffULL, 0x00000100771c7825ULL, 0x000fe200078e0074ULL,
0x000000065300720cULL, 0x080fe20003f86070ULL, 0x00008c00ff2e9b82ULL, 0x000e620000000a00ULL,
0x000000064300720cULL, 0x000fe20003fa6070ULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x000000581c1c7210ULL, 0x000fe20007f7e0ffULL, 0x000001002b2a7825ULL, 0x000fc800078e0074ULL,
0x0000010055307825ULL, 0x000fe200078e0074ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012597faeULL, 0x0005e2000d101c4cULL, 0x000000063d00720cULL, 0x000fe40003f46070ULL,
0x000000ffff1d7224ULL, 0x000fe200018e061dULL, 0x000000582a2a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000028697faeULL, 0x0007e2000f101c4cULL, 0x000001003b747825ULL, 0x000fc600078e0074ULL,
0x000000001e517faeULL, 0x0007e2000e101c4cULL, 0x0000005830307210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e062bULL, 0x000000063f00720cULL, 0x080fe20003f66070ULL,
0x000000001c417faeULL, 0x0007e2000e901c4cULL, 0x000000063900720cULL, 0x080fe20003fa6070ULL,
0x000000ffff317224ULL, 0x000fe200020e0631ULL, 0x000000063300720cULL, 0x000fe20003f86070ULL,
0x00000001633b9824ULL, 0x000fe200078e020aULL, 0x0000005874387210ULL, 0x000fe20007fde0ffULL,
0xffffffffff067424ULL, 0x000fc400078e00ffULL, 0x000000043b2e9825ULL, 0x002fc800078e002eULL,
0x000000ffff397224ULL, 0x000fe200030e0675ULL, 0x0000000010677faeULL, 0x0007e8000d901c4cULL,
0x000000002a2d7faeULL, 0x0007e8000d101c4cULL, 0x0000000030327faeULL, 0x0007e8000e901c4cULL,
0x00000000383a7faeULL, 0x0007e2000e101c4cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000c2e069981ULL, 0x000762000c1e1900ULL, 0x0000ffff71137812ULL, 0x004fe200078ec0ffULL,
0x800000005a5a7824ULL, 0x000fe400078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe40008000a49ULL,
0x8000000013137824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000013ff0075a7ULL, 0x0002620008020048ULL, 0x01c6385a050075a7ULL, 0x000ea4000804017fULL,
0x000000b4001ca947ULL, 0x006fea0003800000ULL, 0x01c180005d117984ULL, 0x008e620000000800ULL,
0x00000001ff567424ULL, 0x000fc600078e00ffULL, 0x01c380005d527984ULL, 0x0004a20000000800ULL,
0x000000081100720bULL, 0x002fda0003f5d000ULL, 0x0000000000107806ULL, 0x000fc800010e0100ULL,
0x0000ffff10127812ULL, 0x000fda000784c0ffULL, 0x0000000000cca947ULL, 0x004fea0003800000ULL,
0x000000081100720bULL, 0x000fe40003f54000ULL, 0x00000011081c7209ULL, 0x000fca0007810000ULL,
0x8000001c08107221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400010e0100ULL, 0x000000030200780cULL, 0x000fe40003f45270ULL,
0x0000ffff081d7812ULL, 0x000fe200078e3cffULL, 0x0000001000107308ULL, 0x000e660000000800ULL,
0x0000001d12ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff567807ULL, 0x000fc60001800000ULL,
0x01c5801c5d00a388ULL, 0x000fe80000000800ULL, 0x00001f5010087589ULL, 0x002e6400000e0000ULL,
0x8000001c11123221ULL, 0x000fe20000010000ULL, 0x000000100b0b7220ULL, 0x000fe20000410000ULL,
0x00001f0f10117589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b12123820ULL, 0x000fc80000410000ULL,
0x00000012000d3308ULL, 0x000ee20000000800ULL, 0x000000084c4c7220ULL, 0x082fe20000410000ULL,
0x000000084d4d7220ULL, 0x080fe20000410000ULL, 0x0000000848487220ULL, 0x080fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x0000000844447220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x000fe20000410000ULL, 0x000000114e4e7220ULL, 0x084fe20000410000ULL,
0x000000114f4f7220ULL, 0x080fe20000410000ULL, 0x000000114a4a7220ULL, 0x080fe20000410000ULL,
0x000000114b4b7220ULL, 0x080fe20000410000ULL, 0x0000001146467220ULL, 0x080fe20000410000ULL,
0x0000001147477220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x0000001136367220ULL, 0x080fe20000410000ULL,
0x0000001137377220ULL, 0x080fe20000410000ULL, 0x000000111a1a7220ULL, 0x080fe20000410000ULL,
0x000000111b1b7220ULL, 0x080fe20000410000ULL, 0x0000001116167220ULL, 0x080fe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x0000001126267220ULL, 0x080fe20000410000ULL,
0x0000001127277220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e001cULL,
0x000000520d523220ULL, 0x008fce0000410000ULL, 0x00000000000c1947ULL, 0x000fea0003800000ULL,
0x000000085c5c7824ULL, 0x000fc800078e0205ULL, 0x01c648135c0075a7ULL, 0x000e64000802017fULL,
0x000000b000449947ULL, 0x002fea0003800000ULL, 0x000000002c10783bULL, 0x000e620000004200ULL,
0x0000000dff54723eULL, 0x000fe200000010ffULL, 0x0000000b520b7221ULL, 0x000fe20000010000ULL,
0x0000991056567816ULL, 0x000fe200000000ffULL, 0x013800004040783bULL, 0x000fe60000000200ULL,
0x000000ff5600720cULL, 0x000fe20003f25270ULL, 0x000000006f28783bULL, 0x0005e80000004200ULL,
0x000000007030783bULL, 0x000fe20000004200ULL, 0x00005410546f7816ULL, 0x004fc60000000054ULL,
0x000000007238783bULL, 0x000fe80000004200ULL, 0x00001f0f6f547589ULL, 0x000ea800000e0000ULL,
0x000000006d3c783bULL, 0x000ee80000004200ULL, 0x000000006e1c783bULL, 0x000fe20000004200ULL,
0x0000010011517824ULL, 0x042fe200078e00ffULL, 0x0000888010577816ULL, 0x040fe200000000ffULL,
0x00000100102c7824ULL, 0x000fe200078e00ffULL, 0x0000888011587816ULL, 0x000fc400000000ffULL,
0x00000018ff597819ULL, 0x000fe20000011451ULL, 0x0000005441419232ULL, 0x084fe20000200000ULL,
0x00001f506f517589ULL, 0x0002a200000e0000ULL, 0x00000018ff707819ULL, 0x000fe2000001142cULL,
0x0000005700577306ULL, 0x000fe20000202400ULL, 0x00000018ff797819ULL, 0x000fe20000011410ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011411ULL,
0x0001000011117824ULL, 0x000fe400078e00ffULL, 0x0000005443439232ULL, 0x000fe20000200000ULL,
0x00000018ff677819ULL, 0x000fe20000011412ULL, 0x00000000732c783bULL, 0x000f220000004200ULL,
0x0000007000707306ULL, 0x000ea20000202400ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff507819ULL, 0x002fe4000001143aULL,
0x00000018ff537819ULL, 0x000fe20000011413ULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x000088803c6f7816ULL, 0x008fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe4000001143dULL,
0x00000018ff787819ULL, 0x000fe2000001143cULL, 0x0000005140409232ULL, 0x084fe20000200000ULL,
0x0000541057567816ULL, 0x000fe20000000070ULL, 0x0000005900597306ULL, 0x000e620000202400ULL,
0x0000005142429232ULL, 0x000fe20000200000ULL, 0x00000018ff777819ULL, 0x000fc4000001143eULL,
0x00000018ff757819ULL, 0x000fe4000001143fULL, 0x000088801c7a7816ULL, 0x000fe400000000ffULL,
0x0000007900797306ULL, 0x000fe20000202400ULL, 0x00000018ff747819ULL, 0x000fe4000001141cULL,
0x00000018ff6e7819ULL, 0x000fe4000001141dULL, 0x00000018ff6d7819ULL, 0x000fe4000001141eULL,
0x0000541058577816ULL, 0x002fe20000000059ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x00000018ff6c7819ULL, 0x000fc4000001141fULL, 0x00000018ff5e7819ULL, 0x000fe40000011429ULL,
0x00000018ff5d7819ULL, 0x000fe2000001142aULL, 0x00000056404c723cULL, 0x000fe2000004184cULL,
0x00000018ff6b7819ULL, 0x000fe20000011428ULL, 0x0000001000107306ULL, 0x000e620000202400ULL,
0x00000018ff5a7819ULL, 0x000fe40000011439ULL, 0x00000018ff5c7819ULL, 0x000fe4000001142bULL,
0x0000010012577824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fc40000011430ULL,
0x0000001100567306ULL, 0x000ea20000202400ULL, 0x00000018ff667819ULL, 0x000fe40000011432ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff647819ULL, 0x000fe40000011433ULL,
0x0000541010107816ULL, 0x002fe20000000079ULL, 0x0000005000597306ULL, 0x0003e20000202400ULL,
0x00000018ff697819ULL, 0x000fe40000011431ULL, 0x00000018ff587819ULL, 0x000fc4000001143bULL,
0x00000018ff5b7819ULL, 0x000fe40000011438ULL, 0x0000541056117816ULL, 0x004fe20000000055ULL,
0x0000005700577306ULL, 0x000fe20000202400ULL, 0x0000888012507816ULL, 0x042fe200000000ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000888013557816ULL, 0x040fe400000000ffULL,
0x00000018ff0f7819ULL, 0x010fe2000001142cULL, 0x000000104048723cULL, 0x000fe20000041848ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000005000507306ULL, 0x000e6a0000202400ULL,
0x0000010013117824ULL, 0x000fc400078e00ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000006700677306ULL, 0x000fe20000202400ULL, 0x000000ffff107224ULL, 0x000fe200078e0055ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff707819ULL, 0x000fe40000011413ULL,
0x00000018ff557819ULL, 0x000fe4000001142dULL, 0x0000001000567306ULL, 0x0003f00000202400ULL,
0x0000001100117306ULL, 0x000ea20000202400ULL, 0x0000541050107816ULL, 0x002fc40000000057ULL,
0x00000018ff507819ULL, 0x000fca000001142eULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x0000541056117816ULL, 0x004fce0000000011ULL, 0x0000001200127306ULL, 0x000e620000202400ULL,
0x000000104044723cULL, 0x000fee0000041844ULL, 0x0000007000707306ULL, 0x000ea20000202400ULL,
0x0000541012567816ULL, 0x002fce0000000067ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000000007610783bULL, 0x0002e20000004200ULL, 0x00000018ff677819ULL, 0x000fe4000001142fULL,
0x0000541070577816ULL, 0x004fe20000000053ULL, 0x000001003c537824ULL, 0x000fc600078e00ffULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088801e767816ULL, 0x002fe200000000ffULL, 0x000000564020723cULL, 0x000fe60000041820ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006800687306ULL, 0x000fe40000202400ULL,
0x00000018ff567819ULL, 0x000fe20000011453ULL, 0x000001003d537824ULL, 0x040fe200078e00ffULL,
0x000088803d577816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x0000007700777306ULL, 0x000fe20000202400ULL, 0x00000018ff707819ULL, 0x000fe40000011453ULL,
0x00000018ff3d7819ULL, 0x000fca000001143dULL, 0x0000005600567306ULL, 0x000e700000202400ULL,
0x0000003d003d7306ULL, 0x000ea20000202400ULL, 0x00000018ff537819ULL, 0x008fe40000011410ULL,
0x000054106f567816ULL, 0x002fca0000000056ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x000054103d3d7816ULL, 0x004fce0000000068ULL, 0x0000003c006f7306ULL, 0x000e620000202400ULL,
0x000001003e687824ULL, 0x000fce00078e00ffULL, 0x0000007000707306ULL, 0x000ea20000202400ULL,
0x000054106f3c7816ULL, 0x002fce0000000078ULL, 0x0000007500757306ULL, 0x000fe20000202400ULL,
0x000088803e6f7816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000003c4018723cULL, 0x000fe80000041818ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0000541057577816ULL, 0x004fe40000000070ULL,
0x00000018ff3c7819ULL, 0x000fe20000011468ULL, 0x000001003f687824ULL, 0x040fe200078e00ffULL,
0x000088803f3d7816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fc400078e00ffULL,
0x0000003e003e7306ULL, 0x000fe20000202400ULL, 0x000000564034723cULL, 0x000fe20000041834ULL,
0x00000018ff727819ULL, 0x000fe40000011468ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff687819ULL, 0x000fe40000011413ULL, 0x0000003c003c7306ULL, 0x000e620000202400ULL,
0x00000018ff577819ULL, 0x000fe40000011411ULL, 0x00000018ff567819ULL, 0x000fca0000011412ULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x000054106f3c7816ULL, 0x002fce000000003cULL,
0x0000007200727306ULL, 0x000e620000202400ULL, 0x000088801d6f7816ULL, 0x000fce00000000ffULL,
0x0000003f00707306ULL, 0x000ea20000202400ULL, 0x000054103d3d7816ULL, 0x002fce0000000072ULL,
0x0000007a007a7306ULL, 0x000fe20000202400ULL, 0x000088801f727816ULL, 0x000fe200000000ffULL,
0x0000003c4014723cULL, 0x000fec0000041814ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000001001c3c7824ULL, 0x000fe400078e00ffULL, 0x000001001d3d7824ULL, 0x000fca00078e00ffULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe4000001143dULL, 0x00005410703d7816ULL, 0x004fe40000000075ULL,
0x0000003c00797306ULL, 0x0002a20000202400ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fca000001141dULL, 0x0000007800787306ULL, 0x000ee20000202400ULL,
0x000054103e3c7816ULL, 0x002fce0000000077ULL, 0x0000003c4024723cULL, 0x000fe20000041824ULL,
0x013800000e3c783bULL, 0x0003220000000200ULL, 0x0000001c00777306ULL, 0x0005ea0000202400ULL,
0x000001001e407824ULL, 0x000fe200078e00ffULL, 0x0000888029427816ULL, 0x000fe200000000ffULL,
0x000001001f0e7824ULL, 0x042fe200078e00ffULL, 0x0000001d007b7306ULL, 0x0007e20000202400ULL,
0x000054107a1c7816ULL, 0x004fe20000000079ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x000fc4000001140eULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000006e006e7306ULL, 0x000e620000202400ULL, 0x000054106f1d7816ULL, 0x008fe40000000078ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x000088802b7a7816ULL, 0x000fe400000000ffULL,
0x0000888031787816ULL, 0x000fe200000000ffULL, 0x0000007600767306ULL, 0x000ff00000202400ULL,
0x0000004000757306ULL, 0x0005e20000202400ULL, 0x000000513c3c9232ULL, 0x010fce0000200000ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x000000513e3e9232ULL, 0x000fe20000200000ULL,
0x0000888028407816ULL, 0x004fe200000000ffULL, 0x000000543d3d9232ULL, 0x080fe40000200000ULL,
0x000000543f3f9232ULL, 0x000fc60000200000ULL, 0x0000000e00737306ULL, 0x000ea80000202400ULL,
0x0000001c3c4c723cULL, 0x000fe8000004184cULL, 0x0000001e00707306ULL, 0x0007e60000202400ULL,
0x00000100291c7824ULL, 0x000fe200078e00ffULL, 0x000054107b1d7816ULL, 0x002fe2000000006eULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x00000100281e7824ULL, 0x048fe200078e00ffULL, 0x0000001f00417306ULL, 0x0003e20000202400ULL,
0x0001000028287824ULL, 0x000fc600078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000001c006f7306ULL, 0x0007e20000202400ULL,
0x00000018ff1f7819ULL, 0x002fe20000011429ULL, 0x000001002a297824ULL, 0x000fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000001e00437306ULL, 0x0003e20000202400ULL,
0x00005410771c7816ULL, 0x008fce0000000074ULL, 0x0000001c3c48723cULL, 0x000fe20000041848ULL,
0x000088802a1e7816ULL, 0x042fe200000000ffULL, 0x0000006d006d7306ULL, 0x000fea0000202400ULL,
0x000001002b1c7824ULL, 0x040fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000e640000202400ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141cULL,
0x000100002a1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fc8000001142bULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001d002a7306ULL, 0x0005f00000202400ULL,
0x0000001c006e7306ULL, 0x0007e20000202400ULL, 0x00005410721d7816ULL, 0x004fce0000000073ULL,
0x00000040000e7306ULL, 0x000fe20000202400ULL, 0x00005410761c7816ULL, 0x008fe40000000075ULL,
0x0000888030767816ULL, 0x000fca00000000ffULL, 0x0000001c3c44723cULL, 0x000fe20000041844ULL,
0x0000004200427306ULL, 0x000eac0000202400ULL, 0x00000100311c7824ULL, 0x000fe200078e00ffULL,
0x00005410411d7816ULL, 0x002fe2000000006cULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x0001000031317824ULL, 0x000fc400078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc6000001141cULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000001c007b7306ULL, 0x0003f00000202400ULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x00005410701c7816ULL, 0x002fc4000000006dULL,
0x0000888033707816ULL, 0x000fca00000000ffULL, 0x0000001c3c20723cULL, 0x000fe20000041820ULL,
0x0000002800407306ULL, 0x0003ec0000202400ULL, 0x00000100331c7824ULL, 0x000fe200078e00ffULL,
0x00005410421d7816ULL, 0x004fe2000000006fULL, 0x0000001f001f7306ULL, 0x000ea20000202400ULL,
0x0000888039427816ULL, 0x000fe200000000ffULL, 0x0000010030287824ULL, 0x042fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0001000030307824ULL, 0x000fc400078e00ffULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000001c00777306ULL, 0x0003e20000202400ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff337819ULL, 0x000fca0000011433ULL, 0x0000001e001e7306ULL, 0x000fe20000202400ULL,
0x000054100e1c7816ULL, 0x002fe40000000043ULL, 0x00008880380e7816ULL, 0x000fca00000000ffULL,
0x0000001c3c34723cULL, 0x000fe20000041834ULL, 0x00000029007c7306ULL, 0x0003ec0000202400ULL,
0x00000100391c7824ULL, 0x000fe200078e00ffULL, 0x000054101f1d7816ULL, 0x004fe2000000005eULL,
0x0000007a007a7306ULL, 0x000ea20000202400ULL, 0x0000010032297824ULL, 0x002fc400078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0001000039397824ULL, 0x000fe400078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000001c006d7306ULL, 0x0003f00000202400ULL,
0x0000002900727306ULL, 0x0007e20000202400ULL, 0x00005410401c7816ULL, 0x002fce000000006bULL,
0x0000001c3c18723cULL, 0x000fe20000041818ULL, 0x00000018ff297819ULL, 0x008fe20000011439ULL,
0x0000005d005d7306ULL, 0x000fea0000202400ULL, 0x000001003b1c7824ULL, 0x000fe200078e00ffULL,
0x000054107a1d7816ULL, 0x004fe2000000002aULL, 0x000001002c2a7824ULL, 0x000fe200078e00ffULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x00000001617a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff1c7819ULL, 0x000fca000001141cULL, 0x0000001c00397306ULL, 0x0003f00000202400ULL,
0x0000002b00757306ULL, 0x0004e20000202400ULL, 0x000054101e1c7816ULL, 0x002fe4000000007cULL,
0x000088802c1e7816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fc800078e00ffULL,
0x0000003000797306ULL, 0x0003e20000202400ULL, 0x0000001c3c14723cULL, 0x000fe20000041814ULL,
0x000088803a2b7816ULL, 0x004fcc00000000ffULL, 0x000001002d1c7824ULL, 0x000fe200078e00ffULL,
0x00005410751d7816ULL, 0x008fe2000000005cULL, 0x000001003a307824ULL, 0x002fe200078e00ffULL,
0x00000028007d7306ULL, 0x0003e20000202400ULL, 0x000088802e757816ULL, 0x000fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff307819ULL, 0x000fc60000011430ULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x0000888032287816ULL, 0x042fe200000000ffULL, 0x0001000032327824ULL, 0x000fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000003000407306ULL, 0x000ff00000202400ULL,
0x0000001c00307306ULL, 0x0003f00000202400ULL, 0x0000007800787306ULL, 0x000fe20000202400ULL,
0x000054106e1c7816ULL, 0x002fc4000000005dULL, 0x013800005f5c783bULL, 0x000e6a0000000200ULL,
0x0000001c3c3c723cULL, 0x000fe20000041824ULL, 0x0000003200737306ULL, 0x0005ec0000202400ULL,
0x000001002e1c7824ULL, 0x000fc400078e00ffULL, 0x000001002f1d7824ULL, 0x000fe200078e00ffULL,
0x000088803b327816ULL, 0x044fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001141dULL, 0x0000003300437306ULL, 0x0005e20000202400ULL,
0x00000018ff1d7819ULL, 0x000fe2000001142eULL, 0x000100002f247824ULL, 0x000fe400078e00ffULL,
0x0000010010257824ULL, 0x000fc600078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x00000018ff337819ULL, 0x004fe4000001143bULL,
0x000088802f3b7816ULL, 0x000fca00000000ffULL, 0x0000003100747306ULL, 0x0004e20000202400ULL,
0x000000515c5c9232ULL, 0x082fe40000200000ULL, 0x000000515e5e9232ULL, 0x000fca0000200000ULL,
0x0000002800417306ULL, 0x0003e20000202400ULL, 0x000000545d5d9232ULL, 0x080fe20000200000ULL,
0x00000018ff317819ULL, 0x004fe2000001142aULL, 0x000000545f5f9232ULL, 0x000fe20000200000ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142cULL, 0x00005410746b7816ULL, 0x008fe40000000069ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x0000010038287824ULL, 0x042fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011428ULL,
0x0000001c006c7306ULL, 0x0003e20000202400ULL, 0x00000018ff287819ULL, 0x000fe40000011438ULL,
0x00000018ff387819ULL, 0x000fe4000001143aULL, 0x00000018ff3a7819ULL, 0x000fc60000011425ULL,
0x0000001d002f7306ULL, 0x0005e20000202400ULL, 0x00005410761c7816ULL, 0x002fce000000007dULL,
0x0000006a006a7306ULL, 0x000e620000202400ULL, 0x00005410781d7816ULL, 0x004fce000000007bULL,
0x0000006600667306ULL, 0x000ea20000202400ULL, 0x0000001c5c4c723cULL, 0x000fe2000004184cULL,
0x00005410796a7816ULL, 0x002fcc000000006aULL, 0x0000006400647306ULL, 0x000e620000202400ULL,
0x00008880111c7816ULL, 0x000fe200000000ffULL, 0x0000000eff797e24ULL, 0x000fe2000f8e00ffULL,
0x00005410701d7816ULL, 0x000fc60000000077ULL, 0x000000ffff697224ULL, 0x000fe200078e001cULL,
0x00005410411c7816ULL, 0x000fe20000000072ULL, 0x00000024002e7306ULL, 0x0007e20000202400ULL,
0x0000006a5c48723cULL, 0x000fec0000041848ULL, 0x0000001c5c44723cULL, 0x000fe20000041844ULL,
0x0000002b001f7306ULL, 0x0009e20000202400ULL, 0x013800006024783bULL, 0x008ee20000000200ULL,
0x00000100116a7824ULL, 0x000fe200078e00ffULL, 0x01c6586205ff79a7ULL, 0x0007e6000850003fULL,
0x00005410731c7816ULL, 0x004fc40000000066ULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x000088802d2b7816ULL, 0x050fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00005410431d7816ULL, 0x002fe20000000064ULL, 0x01c6406205ff79a7ULL, 0x0003e2000850003fULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x00000018ff2c7819ULL, 0x000fe2000001142dULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x00008880102d7816ULL, 0x040fe200000000ffULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x0000001c5c20723cULL, 0x000fe80000041820ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000004200427306ULL, 0x000ea40000202400ULL,
0x00010000111d7824ULL, 0x000fcc00078e00ffULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x0000541042117816ULL, 0x004fce000000006dULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x0000005124249232ULL, 0x088fe40000200000ULL, 0x0000005126269232ULL, 0x000fe40000200000ULL,
0x0000005425259232ULL, 0x080fe40000200000ULL, 0x0000005427279232ULL, 0x000fe20000200000ULL,
0x0000002800287306ULL, 0x000eb00000202400ULL, 0x0000002900297306ULL, 0x000ee20000202400ULL,
0x0000541028287816ULL, 0x004fce000000005bULL, 0x0000003200327306ULL, 0x000ea20000202400ULL,
0x0000541029297816ULL, 0x008fce000000005aULL, 0x00000010001c7306ULL, 0x0007e20000202400ULL,
0x000000285c18723cULL, 0x000fee0000041818ULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x000054100e107816ULL, 0x008fe4000000006fULL, 0x00000018ff0e7819ULL, 0x000fc4000001141dULL,
0x00008880121d7816ULL, 0x040fe200000000ffULL, 0x0000010012287824ULL, 0x040fe400078e00ffULL,
0x0000003800387306ULL, 0x000ee20000202400ULL, 0x000000105c34723cULL, 0x000fe20000041834ULL,
0x0000010013297824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0001000012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000003300337306ULL, 0x000f220000202400ULL, 0x000054101f107816ULL, 0x000fe40000000040ULL,
0x0000541032117816ULL, 0x004fe40000000039ULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x0000541038327816ULL, 0x008fe20000000059ULL, 0x0000001e001e7306ULL, 0x000fe40000202400ULL,
0x000000105c14723cULL, 0x000fe20000041814ULL, 0x0000541033337816ULL, 0x010fca0000000058ULL,
0x0000003100317306ULL, 0x000ea20000202400ULL, 0x0000888013117816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x000000325c3c723cULL, 0x000fe8000004183cULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000002b002b7306ULL, 0x000ee20000202400ULL,
0x000054101e1e7816ULL, 0x004fce0000000031ULL, 0x0000000f000f7306ULL, 0x000fe20000202400ULL,
0x000054102b1f7816ULL, 0x008fce0000000030ULL, 0x0000002a002a7306ULL, 0x000ea20000202400ULL,
0x0000001e244c723cULL, 0x000fee000004184cULL, 0x0000003b003b7306ULL, 0x000fe20000202400ULL,
0x000054102a2a7816ULL, 0x004fce000000000fULL, 0x0000006e006e7306ULL, 0x000eb00000202400ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000054103b6d7816ULL, 0x004fce000000006eULL,
0x0000005000507306ULL, 0x000eb00000202400ULL, 0x0000006700677306ULL, 0x000ee20000202400ULL,
0x000054102f507816ULL, 0x004fce0000000050ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x000054102e517816ULL, 0x008fce0000000067ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x000000502420723cULL, 0x000fee0000041820ULL, 0x0000002c002c7306ULL, 0x000eb00000202400ULL,
0x0000007500757306ULL, 0x000ee20000202400ULL, 0x000054102c2b7816ULL, 0x004fce0000000055ULL,
0x0000002d002d7306ULL, 0x000fe20000202400ULL, 0x0000002a2448723cULL, 0x000fe20000041848ULL,
0x00005410756c7816ULL, 0x008fcc000000006cULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x0000006c2444723cULL, 0x000fee0000041844ULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x000054102d3a7816ULL, 0x004fce000000003aULL, 0x0000006a006a7306ULL, 0x000eb00000202400ULL,
0x0000000e000e7306ULL, 0x000fe20000202400ULL, 0x00005410693b7816ULL, 0x004fce000000006aULL,
0x0000001d001d7306ULL, 0x000fe20000202400ULL, 0x0000003a2434723cULL, 0x000fee0000041834ULL,
0x0000002800107306ULL, 0x000eb00000202400ULL, 0x0000001100117306ULL, 0x000fe20000202400ULL,
0x000054101d107816ULL, 0x004fce0000000010ULL, 0x00000029001e7306ULL, 0x000eb00000202400ULL,
0x0000005600567306ULL, 0x000fe20000202400ULL, 0x0000541011117816ULL, 0x004fce000000001eULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x000000102414723cULL, 0x000fee0000041814ULL,
0x00000012000f7306ULL, 0x0004f00000202400ULL, 0x00000013001f7306ULL, 0x0008620000202400ULL,
0x000054101c127816ULL, 0x004fc40000000053ULL, 0x000054100f567816ULL, 0x008fe40000000056ULL,
0x000054100e137816ULL, 0x010fe40000000057ULL, 0x00009910710e7816ULL, 0x000fe400000000ffULL,
0x000054101f577816ULL, 0x002fc60000000068ULL, 0x000000122418723cULL, 0x000fe20000041818ULL,
0x000000ff0e00720cULL, 0x000fc80003f25270ULL, 0x00000001ff658807ULL, 0x000fe20000800000ULL,
0x000000562424723cULL, 0x000fe6000004183cULL, 0x0000761065717816ULL, 0x000fde0000000071ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000100037824ULL, 0x000fe200078e0203ULL,
0x000000ff0cff7812ULL, 0x000fc8000780c0ffULL, 0x0000000503007c0cULL, 0x000fe4000bf26070ULL,
0x00000001ff0c7807ULL, 0x000fd60000000000ULL, 0xffffff5800bc9947ULL, 0x020fea000383ffffULL,
0x0000000000097919ULL, 0x000e620000002500ULL, 0x000000ffff047224ULL, 0x000fe400078e0017ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0016ULL, 0x0000000509007c0cULL, 0x002fda000bf06070ULL,
0x0000000000dc0947ULL, 0x000fea0003800000ULL, 0x018000000b037836ULL, 0x000fe20000000000ULL,
0x000000d000007945ULL, 0x000fe80003800000ULL, 0x7f80000003037812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e000bULL, 0x0000bb50000c7802ULL, 0x000fce0000000f00ULL,
0x0000009800907944ULL, 0x020fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e000aULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000b00067308ULL, 0x020e640000001000ULL,
0xbf80000006037423ULL, 0x002fc8000000000bULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000306037223ULL, 0x000fce0000000006ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009400ff067b82ULL, 0x000ea40000000a00ULL, 0x0000000c06067981ULL, 0x004ea2000c1e9900ULL,
0x00000000000c7919ULL, 0x000ee40000000000ULL, 0x00000002ff0a7819ULL, 0x008fe4000001160cULL,
0x000000080c0c7811ULL, 0x000fe200078ff0ffULL, 0x0000000306037220ULL, 0x004fca0000410000ULL,
0x00001f0a030a7589ULL, 0x000ea800000e0000ULL, 0x00001f0c030c7589ULL, 0x000ee200000e0000ULL,
0x0000004c0a4c7220ULL, 0x044fe20000410000ULL, 0x0000004d0a4d7220ULL, 0x040fe20000410000ULL,
0x000000480a487220ULL, 0x040fe20000410000ULL, 0x000000490a497220ULL, 0x040fe20000410000ULL,
0x000000440a447220ULL, 0x040fe20000410000ULL, 0x000000450a457220ULL, 0x040fe20000410000ULL,
0x000000200a207220ULL, 0x040fe20000410000ULL, 0x000000210a217220ULL, 0x040fe20000410000ULL,
0x000000340a347220ULL, 0x040fe20000410000ULL, 0x000000350a357220ULL, 0x040fe20000410000ULL,
0x000000180a187220ULL, 0x040fe20000410000ULL, 0x000000190a197220ULL, 0x040fe20000410000ULL,
0x000000140a147220ULL, 0x040fe20000410000ULL, 0x000000150a157220ULL, 0x040fe20000410000ULL,
0x000000240a247220ULL, 0x040fe20000410000ULL, 0x000000250a257220ULL, 0x000fe20000410000ULL,
0x0000004e0c4e7220ULL, 0x048fe20000410000ULL, 0x0000004f0c4f7220ULL, 0x040fe20000410000ULL,
0x0000004a0c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b0c4b7220ULL, 0x040fe20000410000ULL,
0x000000460c467220ULL, 0x040fe20000410000ULL, 0x000000470c477220ULL, 0x040fe20000410000ULL,
0x000000220c227220ULL, 0x040fe20000410000ULL, 0x000000230c237220ULL, 0x040fe20000410000ULL,
0x000000360c367220ULL, 0x040fe20000410000ULL, 0x000000370c377220ULL, 0x040fe20000410000ULL,
0x0000001a0c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b0c1b7220ULL, 0x040fe20000410000ULL,
0x0000000d0c0d7220ULL, 0x040fe20000410000ULL, 0x000000040c047220ULL, 0x040fe20000410000ULL,
0x000000260c267220ULL, 0x040fe20000410000ULL, 0x000000270c277220ULL, 0x000fce0000410000ULL,
0x0000000000177919ULL, 0x000ea20000000000ULL, 0x000000202120723eULL, 0x000fe400000010ffULL,
0x000000343534723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000181918723eULL, 0x000fe400000010ffULL, 0x000000141514723eULL, 0x000fe400000010ffULL,
0x0000004e4f4f723eULL, 0x000fe400000010ffULL, 0x0000004a4b4a723eULL, 0x000fc400000010ffULL,
0x000000464746723eULL, 0x000fe400000010ffULL, 0x000000222323723eULL, 0x000fe400000010ffULL,
0x000000363736723eULL, 0x000fe400000010ffULL, 0x0000001a1b1b723eULL, 0x000fe400000010ffULL,
0x000000010000780cULL, 0x000fe40003f05270ULL, 0x000054104f4e7816ULL, 0x000fc4000000004aULL,
0x0000000d0404723eULL, 0x000fe400000010ffULL, 0x000000262726723eULL, 0x000fe400000010ffULL,
0x000076324f4f7816ULL, 0x000fe4000000004aULL, 0x0000541046227816ULL, 0x000fe40000000023ULL,
0x0000000217037812ULL, 0x004fe400078ec0ffULL, 0x00000002ff1d7819ULL, 0x000fc40000011617ULL,
0x00000001ff067819ULL, 0x020fe40000011603ULL, 0x00000002030a7811ULL, 0x000fe400078ff8ffULL,
0x00000008172b7811ULL, 0x000fe400078ff0ffULL, 0x00000004030e7811ULL, 0x040fe400078ff8ffULL,
0x0000000603127811ULL, 0x000fe400078ff8ffULL, 0x0000000706037812ULL, 0x000fc400078e781dULL,
0x000000070a0c7812ULL, 0x000fe400078e781dULL, 0x000000070a0a7812ULL, 0x000fe200078e782bULL,
0x000000081d077824ULL, 0x000fe200078e0203ULL, 0x000000070e107812ULL, 0x000fe200078e781dULL,
0x0000080002037824ULL, 0x000fe200078e0205ULL, 0x0000000712137812ULL, 0x000fe200078e781dULL,
0x000000082b1f7824ULL, 0x000fe200078e020aULL, 0x0000000706067812ULL, 0x000fe200078e782bULL,
0x00000008170a7824ULL, 0x000fe200078e00ffULL, 0x000000070e0e7812ULL, 0x000fe200078e782bULL,
0x0001200003167836ULL, 0x000fe20000000000ULL, 0x0000000712127812ULL, 0x000fe200078e782bULL,
0x000000081d0f7824ULL, 0x000fe200078e020cULL, 0x000000080a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001007077824ULL, 0x000fe200078e0216ULL, 0x0000004c4d05723eULL, 0x000fe200000010ffULL,
0x000000081d117824ULL, 0x040fe200078e0210ULL, 0x0000763246237816ULL, 0x000fe20000000023ULL,
0x000000081d137824ULL, 0x000fe200078e0213ULL, 0x00005410361a7816ULL, 0x000fe2000000001bULL,
0x000000082b1d7824ULL, 0x000fe200078e0206ULL, 0x000000484906723eULL, 0x000fe200000010ffULL,
0x00000001070c7824ULL, 0x000fe200078e020aULL, 0x000000444507723eULL, 0x000fe200000010ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0216ULL, 0x00005410052c7816ULL, 0x000fe20000000006ULL,
0x000000082b297824ULL, 0x000fe200078e020eULL, 0x00007632052d7816ULL, 0x000fe20000000006ULL,
0x000000082b2b7824ULL, 0x000fe200078e0212ULL, 0x0000541007067816ULL, 0x140fe20000000020ULL,
0x000000010a0f7824ULL, 0x000fe200078e020fULL, 0x0000763207077816ULL, 0x000fe20000000020ULL,
0x0000001011117824ULL, 0x100fe200078e0216ULL, 0x0000002c0c007388ULL, 0x000fe20000000a00ULL,
0x000000101d1d7824ULL, 0x100fe200078e0216ULL, 0x00007632361b7816ULL, 0x000fe2000000001bULL,
0x000000101f1f7824ULL, 0x100fe200078e0216ULL, 0x000000060f007388ULL, 0x0005e20000000a00ULL,
0x0000001013137824ULL, 0x000fc400078e0216ULL, 0x0000001029297824ULL, 0x100fe400078e0216ULL,
0x000000102b2b7824ULL, 0x000fe400078e0216ULL, 0x000000010a117824ULL, 0x040fe400078e0211ULL,
0x000000010a1d7824ULL, 0x040fe400078e021dULL, 0x000000010a1f7824ULL, 0x000fe200078e021fULL,
0x0000541034067816ULL, 0x104fe20000000018ULL, 0x000000010a137824ULL, 0x000fe200078e0213ULL,
0x0000763234077816ULL, 0x000fe20000000018ULL, 0x000000010a297824ULL, 0x000fc400078e0229ULL,
0x000000010a2b7824ULL, 0x000fe200078e022bULL, 0x00000024250a723eULL, 0x000fe200000010ffULL,
0x0000000611007388ULL, 0x0005e60000000a00ULL, 0x0000541014067816ULL, 0x144fe4000000000aULL,
0x0000763214077816ULL, 0x000fca000000000aULL, 0x0000000613007388ULL, 0x0005e80000000a00ULL,
0x0000004e1d007388ULL, 0x0007e80000000a00ULL, 0x000000221f007388ULL, 0x0007e20000000a00ULL,
0x0000541004067816ULL, 0x004fc60000000026ULL, 0x0000001a29007388ULL, 0x0007e20000000a00ULL,
0x0000763204077816ULL, 0x000fca0000000026ULL, 0x000000062b007388ULL, 0x0007e20000000a00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002400848947ULL, 0x000fea0003800000ULL,
0x00000000002f7919ULL, 0x000ea20000002700ULL, 0x00008400ff057b82ULL, 0x000ea20000000800ULL,
0x00000010170a7824ULL, 0x040fe200078e0203ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0x0000000000047919ULL, 0x000ea20000002600ULL, 0x0000002017297836ULL, 0x048fe40000000000ULL,
0x00000040172b7836ULL, 0x040fe20000000000ULL, 0x012000000a0c7984ULL, 0x0006e20000000c00ULL,
0x00009200ff067b82ULL, 0x000f220000000800ULL, 0x00000060172d7836ULL, 0x040fe20000000000ULL,
0x000000ff1700720cULL, 0x000fe20000725670ULL, 0x012200000a107984ULL, 0x0006e80000000c00ULL,
0x012400000a1c7984ULL, 0x0006e20000000c00ULL, 0x00009800ff147b82ULL, 0x000f660000000a00ULL,
0x012600000a207984ULL, 0x0006e20000000c00ULL, 0x0000000000247919ULL, 0x000ee20000008800ULL,
0x000000052f2f7224ULL, 0x004fc400078e0204ULL, 0x0000000500057224ULL, 0x000fe400078e02ffULL,
0x000000002f047224ULL, 0x000fe400078e02ffULL, 0x0000000605057224ULL, 0x010fe400078e02ffULL,
0x0000000104067824ULL, 0x000fc600078e0209ULL, 0x00001fff05077811ULL, 0x040fe400078e40ffULL,
0x01ffffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000000607197211ULL, 0x000fca00078f98ffULL,
0x0000200019187825ULL, 0x022fc800078e0014ULL, 0x00000800021a7825ULL, 0x000fe200078e0018ULL,
0x0000040000197802ULL, 0x000fc80000000f00ULL, 0x0000065424197816ULL, 0x008fe20000000019ULL,
0x0000001029287825ULL, 0x000fc800078e001aULL, 0x000000102b2a7825ULL, 0x000fc800078e001aULL,
0x000000102d2c7825ULL, 0x000fc800078e001aULL, 0x0000001017267825ULL, 0x000fe200078e001aULL,
0x0000000000380947ULL, 0x000fec0003800000ULL, 0x00009800ff247b82ULL, 0x000e620000000a00ULL,
0x0000000106097824ULL, 0x000fe200078e0205ULL, 0x00000001ff187819ULL, 0x000fe20000011617ULL,
0x00000010170a7824ULL, 0x000fc600078e00ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x00000080061a7825ULL, 0x002fc800078e0024ULL, 0x0000008009247825ULL, 0x000fe200078e0024ULL,
0x000000700a097812ULL, 0x000fc800078ec0ffULL, 0x0000001a181a7210ULL, 0x140fe40007b5e009ULL,
0x0000002418247210ULL, 0x000fe40007d9e009ULL, 0x0000001bff1b7210ULL, 0x000fe400017e64ffULL,
0x00000025ff257210ULL, 0x000fc600027ea4ffULL, 0x000000081a007986ULL, 0x0003e8000c10190cULL,
0x0000000b24007986ULL, 0x0003e4000c10190cULL, 0x0000000c26007986ULL, 0x0005e8000c101d0cULL,
0x0000001028007986ULL, 0x0005e8000c101d0cULL, 0x0000001c2a007986ULL, 0x0005e8000c101d0cULL,
0x000000202c007986ULL, 0x0005e2000c101d0cULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000004c1947ULL, 0x000fea0003800000ULL, 0x00009600ff087b82ULL, 0x002e620000000a00ULL,
0xffffffff000b7836ULL, 0x000fe40000000000ULL, 0x000000042f087825ULL, 0x002fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x0000000b080879a8ULL, 0x000ee800099ee1ccULL, 0x00000000ff00798fULL, 0x008fe20002000000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fc40000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000b0800720cULL, 0x000fc80003f25270ULL,
0x00000001ff067807ULL, 0x000fca0000800000ULL, 0x00000006ff007988ULL, 0x0003e80008000004ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000019067984ULL, 0x002e640000000000ULL, 0x000000ff0600720cULL, 0x002fda0003f25270ULL,
0x0000002000509947ULL, 0x000fea0003800000ULL, 0x0000000c00300947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x0000000000d88947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x0000001017067824ULL, 0x000fe400078e00ffULL,
0x00000001040b7836ULL, 0x000fe20000000000ULL, 0x0000000c0a0e7812ULL, 0x004fe200078ec0ffULL,
0x0000008004087825ULL, 0x000fe200078e0014ULL, 0x00000070061d7812ULL, 0x000fc600078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0014ULL, 0x000000080e0c7210ULL, 0x140fe4000791e01dULL,
0x0000000a0e0a7210ULL, 0x000fe40007b5e01dULL, 0x00000009ff0d7210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000c0c087981ULL, 0x000368000c1e1900ULL,
0x0000000c0a097981ULL, 0x000362000c1e1900ULL, 0x000000020000780cULL, 0x000fda0003f05270ULL,
0x00000000009c8947ULL, 0x002fea0003800000ULL, 0x00000002040b7836ULL, 0x000fc80000000000ULL,
0x000000800b0a7825ULL, 0x000fc600078e0014ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01dULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x0000000c0a0d7981ULL, 0x000362000c1e1900ULL,
0x000000040000780cULL, 0x000fda0003f06070ULL, 0x0000000000808947ULL, 0x002fea0003800000ULL,
0x00000003040b7836ULL, 0x000fc80000000000ULL, 0x000000800b0a7825ULL, 0x000fc600078e0014ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01dULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x0000000c0a117981ULL, 0x000362000c1e1900ULL, 0x000000040000780cULL, 0x000fda0003f05270ULL,
0x0000000000648947ULL, 0x002fea0003800000ULL, 0x00000004040b7836ULL, 0x000fc80000000000ULL,
0x000000800b0a7825ULL, 0x000fc600078e0014ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01dULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x0000000c0a137981ULL, 0x000362000c1e1900ULL,
0x000000060000780cULL, 0x000fda0003f06070ULL, 0x0000000000488947ULL, 0x002fea0003800000ULL,
0x00000005040b7836ULL, 0x000fc80000000000ULL, 0x000000800b0a7825ULL, 0x000fc600078e0014ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01dULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x0000000c0a1b7981ULL, 0x000362000c1e1900ULL, 0x000000060000780cULL, 0x000fda0003f05270ULL,
0x00000000002c8947ULL, 0x002fea0003800000ULL, 0x000000080000780cULL, 0x000fe20003f06070ULL,
0x00000006040b7836ULL, 0x000fc80000000000ULL, 0x000000800b0a7825ULL, 0x000fc600078e0014ULL,
0x0000000a0e0a7210ULL, 0x000fca0007a3e01dULL, 0x00000007040f0836ULL, 0x000fe20000000000ULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x000000800f140825ULL, 0x000fc600078e0014ULL,
0x000000140e0e0210ULL, 0x000fc80007c7e01dULL, 0x00000015ff0f0210ULL, 0x000fe40001fe84ffULL,
0x0000000c0a157981ULL, 0x000368000c1e1900ULL, 0x0000000c0e1d0981ULL, 0x000366000c1e1900ULL,
0x0000000700067836ULL, 0x000fca0000000000ULL, 0x00000003ff067819ULL, 0x000fc80000011606ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x0000000800248947ULL, 0x000fea0003800000ULL,
0x00009800ff0a7b82ULL, 0x002e620000000a00ULL, 0x000000ffff107224ULL, 0x004fe200078e0004ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1f7224ULL, 0x020fe200078e0008ULL,
0x0000003f00057c82ULL, 0x000fcc0008000000ULL, 0x0000000400007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x0000000506007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400f41947ULL, 0x022fee0003800000ULL, 0x0000000804067890ULL, 0x000fe2000fffe03fULL,
0x0000001f08087209ULL, 0x000fe20007810000ULL, 0x0000000104077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010170c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011617ULL, 0x00000008100f7836ULL, 0x000fc60000000000ULL,
0x000000700c1f7812ULL, 0x000fe200078ec0ffULL, 0x000000800f0e7825ULL, 0x002fe200078e000aULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000e120e7210ULL, 0x000fc80007b3e01fULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0e1f7981ULL, 0x000368000c1e1900ULL,
0x0000000400b42947ULL, 0x000fea0003800000ULL, 0x0000000904067890ULL, 0x000fe2000fffe03fULL,
0x0000000908087209ULL, 0x000fe20007810000ULL, 0x0000000204077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000001017097824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011617ULL, 0x00000009100f7836ULL, 0x002fc60000000000ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000e0c0e7210ULL, 0x000fc80007b3e009ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0e097981ULL, 0x000368000c1e1900ULL,
0x0000000400742947ULL, 0x000fea0003800000ULL, 0x0000000a04067890ULL, 0x000fe2000fffe03fULL,
0x0000000d08087209ULL, 0x000fe20007810000ULL, 0x0000000304077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010170c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x002fe20000011617ULL, 0x0000000a100d7836ULL, 0x000fc60000000000ULL,
0x000000700c0f7812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e000aULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0e0c7210ULL, 0x000fc80007b3e00fULL,
0x0000000dff0d7210ULL, 0x000fcc0000fe64ffULL, 0x0000000c0c0d7981ULL, 0x000366000c1e1900ULL,
0x0000000400342947ULL, 0x000fea0003800000ULL, 0x0000000b04067890ULL, 0x000fe2000fffe03fULL,
0x0000001108087209ULL, 0x000fe20007810000ULL, 0x0000000404077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010170c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011617ULL, 0x0000000b100f7836ULL, 0x000fc60000000000ULL,
0x000000700c117812ULL, 0x000fe200078ec0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000e120e7210ULL, 0x000fc80007b3e011ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0e117981ULL, 0x000368000c1e1900ULL,
0x0000000000f42947ULL, 0x000fea0003800000ULL, 0x0000000c04067890ULL, 0x000fe2000fffe03fULL,
0x0000001308087209ULL, 0x000fe20007810000ULL, 0x0000000504077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010170c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011617ULL, 0x0000000c100f7836ULL, 0x000fc60000000000ULL,
0x000000700c137812ULL, 0x000fe200078ec0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000e120e7210ULL, 0x000fc80007b3e013ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0e137981ULL, 0x000368000c1e1900ULL,
0x0000000000b42947ULL, 0x000fea0003800000ULL, 0x0000000d04067890ULL, 0x000fe2000fffe03fULL,
0x0000001b08087209ULL, 0x000fe20007810000ULL, 0x0000000604077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010170c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011617ULL, 0x0000000d100f7836ULL, 0x000fc60000000000ULL,
0x000000700c1b7812ULL, 0x000fe200078ec0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000e120e7210ULL, 0x000fc80007b3e01bULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0e1b7981ULL, 0x000368000c1e1900ULL,
0x0000000000742947ULL, 0x000fea0003800000ULL, 0x0000000e04067890ULL, 0x000fe2000fffe03fULL,
0x0000001508087209ULL, 0x000fe20007810000ULL, 0x0000000704077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010170c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011617ULL, 0x0000000e100f7836ULL, 0x000fc60000000000ULL,
0x000000700c157812ULL, 0x000fe200078ec0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000e120e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0e157981ULL, 0x000368000c1e1900ULL,
0x0000000000342947ULL, 0x000fea0003800000ULL, 0x0000000f04067890ULL, 0x000fe2000fffe03fULL,
0x0000001d08087209ULL, 0x000fca0007810000ULL, 0x0000000600007c0cULL, 0x000fda000bf23070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010170c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011617ULL, 0x0000000f100f7836ULL, 0x000fc60000000000ULL,
0x000000700c1d7812ULL, 0x000fe200078ec0ffULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000e120e7210ULL, 0x000fc80007a3e01dULL,
0x0000000fff0f7210ULL, 0x000fca0000fe44ffULL, 0x0000000c0e1d7981ULL, 0x000368000c1e1900ULL,
0x0000000804047890ULL, 0x000fe2000fffe03fULL, 0x0000000810107836ULL, 0x000fe20000000000ULL,
0xfffffff400f08947ULL, 0x000ff4000383ffffULL, 0x0000000000177919ULL, 0x000ee40000000000ULL,
0x0000001017067824ULL, 0x008fe200078e00ffULL, 0x00000001ff097819ULL, 0x020fc80000011617ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fc800078ec0ffULL,
0x0000001909097210ULL, 0x000fca0007ffe006ULL, 0x0000000809007388ULL, 0x0007e40000000800ULL,
0x00009800ff107b82ULL, 0x004ea20000000a00ULL, 0x0000000407477211ULL, 0x000fe200078f98ffULL,
0x0000080002187824ULL, 0x000fe200078e00ffULL, 0x000000071700780cULL, 0x040fe20003f04070ULL,
0x00000010171e7824ULL, 0x040fe200078e00ffULL, 0x00000015ff1a7819ULL, 0x000fe20000011602ULL,
0x00000020170b7836ULL, 0x042fe20000000000ULL, 0x00000001ff1b7819ULL, 0x000fe20000011617ULL,
0x00000040170d7836ULL, 0x040fe20000000000ULL, 0x000000701e1e7812ULL, 0x000fe200078ec0ffULL,
0x00000060170f7836ULL, 0x000fe20000000000ULL, 0x0000000c1b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104457824ULL, 0x000fe200078e0205ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00001000021c7824ULL, 0x140fe200078e0219ULL, 0x000000191b1d7210ULL, 0x000fe20007ffe01eULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000010002128824ULL, 0x140fe200078e0219ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000001017057824ULL, 0x040fe200078e021cULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000010002148824ULL, 0x000fe200078e0219ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000001017138824ULL, 0x000fe200078e0212ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000200047067825ULL, 0x004fe200078e0010ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000001017158824ULL, 0x000fe200078e0214ULL,
0x0000001806067210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000107077824ULL, 0x000fe200008e061aULL,
0x000000ff0000720cULL, 0x000fc40003f25270ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000100b0a7825ULL, 0x100fe200078e0006ULL,
0x000000001d1d7984ULL, 0x000e620000000800ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000001017087825ULL, 0x008fe200078e0006ULL,
0x00000000003c7805ULL, 0x000fc6000001ff00ULL, 0x000000100d0c7825ULL, 0x100fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008057faeULL, 0x0005e6000b901c4cULL,
0x000000100f067825ULL, 0x000fe200078e0006ULL, 0x003800000a057faeULL, 0x0005e6000b901c4cULL,
0x00000080450e8825ULL, 0x100fe200078e0010ULL, 0x005800000c057faeULL, 0x0005e6000b901c4cULL,
0x0000008004108825ULL, 0x000fe200078e0010ULL, 0x0078000006057faeULL, 0x0005e6000b901c4cULL,
0x00000010170e8825ULL, 0x000fc800078e000eULL, 0x0000001017108825ULL, 0x000fe200078e0010ULL,
0x045800000e138faeULL, 0x0005e8000b901c4cULL, 0x0418000010158faeULL, 0x0005e8000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000800b49947ULL, 0x000fea0003800000ULL,
0x00009800ff147b82ULL, 0x004ea20000000a00ULL, 0x00000003ff057819ULL, 0x100fe20000011617ULL,
0x0000000145457836ULL, 0x000fe20000000000ULL, 0xfffffff8ff067812ULL, 0x000fe200078ee217ULL,
0x0000000147477836ULL, 0x000fe20000000000ULL, 0x0000000305057812ULL, 0x000fe200078ec0ffULL,
0x00000001044b7836ULL, 0x000fe20000000000ULL, 0x00000002ff447819ULL, 0x000fe20000011617ULL,
0x0000000806087836ULL, 0x040fe20000000000ULL, 0x0000000405077812ULL, 0x000fe200078efcffULL,
0x0000000806417824ULL, 0x000fe200078e00ffULL, 0x0000000705407812ULL, 0x000fe200078e7806ULL,
0x0000000808437824ULL, 0x000fe200078e00ffULL, 0x0000000705427812ULL, 0x000fe200078e7808ULL,
0x00000001ff497424ULL, 0x000fe200078e00ffULL, 0x0000000707067812ULL, 0x000fe200078e7806ULL,
0x000000ffff3f7224ULL, 0x000fe200078e00ffULL, 0x0000000707087812ULL, 0x000fe200078e7808ULL,
0x00000100024d7824ULL, 0x000fe200078e0219ULL, 0x0000004140407212ULL, 0x000fe200078efcffULL,
0x0000000844467836ULL, 0x000fe20000000000ULL, 0x0000004342427212ULL, 0x000fc400078efcffULL,
0x0000004106417212ULL, 0x000fe400078efcffULL, 0x0000004308437212ULL, 0x004fce00078efcffULL,
0x000000004900720cULL, 0x000fda0003f06070ULL, 0x0000000000880947ULL, 0x000fea0003800000ULL,
0x0000200047047825ULL, 0x000fe200078e0014ULL, 0x000000071700780cULL, 0x000fe40003f24070ULL,
0x0000000149127812ULL, 0x000fe200078ec0ffULL, 0x0000002017077836ULL, 0x000fe20000000000ULL,
0x00000018040a7210ULL, 0x000fe20007f1e0ffULL, 0x0000080049047824ULL, 0x000fe400078e00ffULL,
0x0000004017137836ULL, 0x000fe40000000000ULL, 0x00000001050b7824ULL, 0x000fe200000e061aULL,
0x0000080004057812ULL, 0x000fe200078ec0ffULL, 0x00000060174f7836ULL, 0x000fc40000000000ULL,
0x00000100024d9824ULL, 0x000fe400078e0219ULL, 0x000000011c047824ULL, 0x000fe400078e0205ULL,
0x00000080450c9825ULL, 0x000fc800078e0014ULL, 0x000000804b089825ULL, 0x000fc800078e0014ULL,
0x0000008012109824ULL, 0x000fe400078e024dULL, 0x0000001017117824ULL, 0x040fe400078e0204ULL,
0x00000010170e7825ULL, 0x000fc800078e000aULL, 0x0000001007047825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e117faeULL, 0x0005e6000b901c4cULL,
0x0000008012129824ULL, 0x000fe200078e024dULL, 0x0038000004117faeULL, 0x0005e2000b901c4cULL,
0x0000001013067825ULL, 0x000fc800078e000aULL, 0x000000104f0a7825ULL, 0x000fe200078e000aULL,
0x0058000006117faeULL, 0x0005e6000b901c4cULL, 0x00000010170c9825ULL, 0x040fe200078e000cULL,
0x007800000a117faeULL, 0x0005e6000b901c4cULL, 0x0000001017139824ULL, 0x040fe400078e0210ULL,
0x0000001017089825ULL, 0x000fc600078e0008ULL, 0x045800000c139faeULL, 0x0005e2000b901c4cULL,
0x00000010174f9824ULL, 0x000fca00078e0212ULL, 0x04180000084f9faeULL, 0x0005e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff49047836ULL, 0x044fe20000000000ULL,
0x000000004900720cULL, 0x040fe20003f06070ULL, 0x0000000149497836ULL, 0x000fe40000000000ULL,
0x0000008004057824ULL, 0x040fe400078e00ffULL, 0x0000080004047824ULL, 0x000fe400078e00ffULL,
0x0000000145457836ULL, 0x000fe20000000000ULL, 0x0000008005057812ULL, 0x000fe200078ec0ffULL,
0x0000000147477836ULL, 0x000fc40000000000ULL, 0x000000014b4b7836ULL, 0x000fe20000000000ULL,
0x0000004d1e067210ULL, 0x000fe40007ffe005ULL, 0x0000080004057812ULL, 0x000fc600078ec0ffULL,
0x000000011b487824ULL, 0x000fe200078e0206ULL, 0x000001801c107810ULL, 0x000fe20007ffe005ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000480e7984ULL, 0x000ea20000000800ULL,
0x0000001040047824ULL, 0x100fe400078e0210ULL, 0x0000001041087824ULL, 0x100fe200078e0210ULL,
0x00458000484f7984ULL, 0x000fe20000000800ULL, 0x00000010420c7824ULL, 0x100fe400078e0210ULL,
0x0000001043107824ULL, 0x000fe200078e0210ULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000808783bULL, 0x000f220000000200ULL, 0x0000000e1d117221ULL, 0x006fc60000010100ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x3fb8aa3b114e7820ULL, 0x000fc60000410000ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x0000763204487816ULL, 0x008fe20000000048ULL,
0x00010000054a7824ULL, 0x000fe200078e00ffULL, 0x0000004e004e7308ULL, 0x000ee20000000800ULL,
0x00007632064c7816ULL, 0x000fe2000000004cULL, 0x0001000008557824ULL, 0x010fe400078e00ffULL,
0x0001000009507824ULL, 0x000fe400078e00ffULL, 0x000100000a577824ULL, 0x000fe400078e00ffULL,
0x000100000b527824ULL, 0x000fc400078e00ffULL, 0x0001000006517824ULL, 0x000fe200078e00ffULL,
0x0000763207067816ULL, 0x040fe20000000006ULL, 0x0001000007537824ULL, 0x000fe400078e00ffULL,
0x0000004f4e5d7220ULL, 0x008fe20000410000ULL, 0x00007632084e7816ULL, 0x000fe2000000004eULL,
0x00010000044f7824ULL, 0x000fe200078e00ffULL, 0x0000763209087816ULL, 0x000fe20000000008ULL,
0x0000003e5d3e7221ULL, 0x000fe20000010000ULL, 0x00001f445d5e7589ULL, 0x000ee200000e0000ULL,
0x000076320a097816ULL, 0x000fc40000000009ULL, 0x0000763205047816ULL, 0x000fe20000000004ULL,
0x00001f465d5d7589ULL, 0x000f2200000e0000ULL, 0x000076320b0a7816ULL, 0x000fe2000000000aULL,
0x0001000048057824ULL, 0x000fe400078e00ffULL, 0x0001000004077824ULL, 0x000fe400078e00ffULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x000076320c0b7816ULL, 0x042fe2000000000bULL,
0x000100000f587824ULL, 0x040fe200078e00ffULL, 0x000076320f567816ULL, 0x000fe20000000056ULL,
0x000100000c597824ULL, 0x000fe200078e00ffULL, 0x00007632100f7816ULL, 0x004fe2000000000fULL,
0x000100000b047824ULL, 0x000fe200078e00ffULL, 0x00007632115a7816ULL, 0x040fe2000000005aULL,
0x00010000115c7824ULL, 0x000fe200078e00ffULL, 0x000076320d0c7816ULL, 0x040fe2000000000cULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x000076320e547816ULL, 0x040fe20000000054ULL,
0x000100000e0e7824ULL, 0x000fc400078e00ffULL, 0x0000005e05327223ULL, 0x088fe20000010032ULL,
0x000100004c057824ULL, 0x000fe200078e00ffULL, 0x0000763212117816ULL, 0x000fe20000000011ULL,
0x0000005e072e7223ULL, 0x080fe2000001002eULL, 0x0000005d042f7223ULL, 0x010fe2000001002fULL,
0x0000005e052c7223ULL, 0x080fe2000001002cULL, 0x00007632135b7816ULL, 0x000fe2000000005bULL,
0x000100004e057824ULL, 0x000fe400078e00ffULL, 0x0000005e4f367223ULL, 0x000fe20000010036ULL,
0x000100000f047824ULL, 0x000fc400078e00ffULL, 0x0000005e4a3d7223ULL, 0x080fe2000001003dULL,
0x0001000006077824ULL, 0x000fe400078e00ffULL, 0x0000005e05287223ULL, 0x080fe20000010028ULL,
0x0000005d04277223ULL, 0x000fe20000010027ULL, 0x0001000010107824ULL, 0x000fe400078e00ffULL,
0x0000005e51387223ULL, 0x080fe20000010038ULL, 0x0001000012127824ULL, 0x000fe400078e00ffULL,
0x0000005e53347223ULL, 0x000fe20000010034ULL, 0x0001000013137824ULL, 0x000fc400078e00ffULL,
0x0000005e072a7223ULL, 0x080fe2000001002aULL, 0x0001000009097824ULL, 0x000fe400078e00ffULL,
0x0000005e55267223ULL, 0x080fe20000010026ULL, 0x000100000a0a7824ULL, 0x000fe400078e00ffULL,
0x0000005e503b7223ULL, 0x080fe2000001003bULL, 0x000100000c0c7824ULL, 0x000fe400078e00ffULL,
0x0000005e08257223ULL, 0x000fe20000010025ULL, 0x0001000054547824ULL, 0x000fc400078e00ffULL,
0x0000005e57307223ULL, 0x080fe20000010030ULL, 0x0001000056567824ULL, 0x000fe400078e00ffULL,
0x0000005e09227223ULL, 0x080fe20000010022ULL, 0x000100005a057824ULL, 0x000fe400078e00ffULL,
0x0000005e52237223ULL, 0x080fe20000010023ULL, 0x0001000011047824ULL, 0x000fe400078e00ffULL,
0x0000005e0a1f7223ULL, 0x000fe2000001001fULL, 0x000100005b067824ULL, 0x000fc400078e00ffULL,
0x0000005d593c7223ULL, 0x080fe2000001003cULL, 0x0000005d0d3a7223ULL, 0x080fe2000001003aULL,
0x0000005d0c2d7223ULL, 0x080fe2000001002dULL, 0x0000005d0e397223ULL, 0x080fe20000010039ULL,
0x0000005d542b7223ULL, 0x080fe2000001002bULL, 0x0000005d58377223ULL, 0x080fe20000010037ULL,
0x0000005d56297223ULL, 0x080fe20000010029ULL, 0x0000005d10357223ULL, 0x080fe20000010035ULL,
0x0000005d5c337223ULL, 0x080fe20000010033ULL, 0x0000005d05247223ULL, 0x080fe20000010024ULL,
0x0000005d12317223ULL, 0x080fe20000010031ULL, 0x0000005d04217223ULL, 0x080fe20000010021ULL,
0x0000005d13207223ULL, 0x080fe20000010020ULL, 0x0000005d063f7223ULL, 0x000fe2000001003fULL,
0xfffffff400ac8947ULL, 0x000fec000383ffffULL, 0x018000003e007836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe80000010000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000e480000c7802ULL, 0x004fce0000000f00ULL, 0x0000007000447944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e000aULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000003e00057308ULL, 0x004ea40000001000ULL, 0xbf80000005007423ULL, 0x004fc8000000003eULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fce0000000005ULL,
0x0000000000177919ULL, 0x000ea40000000000ULL, 0x00000002ff057819ULL, 0x104fe40000011617ULL,
0x00000008170d7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff107819ULL, 0x000fe20000011617ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff1a7812ULL, 0x000fc600078ee217ULL, 0x00001f0d000e7589ULL, 0x00072400000e0000ULL,
0x000000081a1c7836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x000000081c157824ULL, 0x000fe400078e00ffULL, 0x0000003605047220ULL, 0x044fe20000410000ULL,
0x0000003205077220ULL, 0x040fe20000410000ULL, 0x0000003d053d7220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000003805067220ULL, 0x040fe20000410000ULL,
0x0000002c05097220ULL, 0x040fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000002a050b7220ULL, 0x040fe20000410000ULL, 0x0000002605087220ULL, 0x040fe20000410000ULL,
0x00000028050d7220ULL, 0x048fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000002505007220ULL, 0x040fe20000410000ULL, 0x00000030050a7220ULL, 0x040fe20000410000ULL,
0x00000022050f7220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001f050c7220ULL, 0x000fe20000410000ULL, 0x0000000310057812ULL, 0x000fe200078ec0ffULL,
0x0000003c0e3c7220ULL, 0x050fe20000410000ULL, 0x0000002f0e2f7220ULL, 0x040fe20000410000ULL,
0x0000003a0e3a7220ULL, 0x040fe20000410000ULL, 0x0000000405137812ULL, 0x000fe200078efcffULL,
0x0000002d0e2d7220ULL, 0x040fe20000410000ULL, 0x000000390e397220ULL, 0x040fe20000410000ULL,
0x0000002b0e107220ULL, 0x040fe20000410000ULL, 0x000000370e377220ULL, 0x040fe20000410000ULL,
0x000000290e127220ULL, 0x040fe20000410000ULL, 0x000000350e357220ULL, 0x040fe20000410000ULL,
0x000000270e147220ULL, 0x040fe20000410000ULL, 0x000000330e337220ULL, 0x040fe20000410000ULL,
0x000000240e247220ULL, 0x040fe20000410000ULL, 0x000000310e317220ULL, 0x040fe20000410000ULL,
0x000000210e187220ULL, 0x040fe20000410000ULL, 0x000000200e207220ULL, 0x040fe20000410000ULL,
0x0000003f0e3f7220ULL, 0x000fe20000410000ULL, 0x000000081a0e7824ULL, 0x000fe200078e00ffULL,
0x0000000705117812ULL, 0x000fc400078e781aULL, 0x00000007051e7812ULL, 0x000fe400078e781cULL,
0x0000000713057812ULL, 0x000fe400078e781aULL, 0x0000000e11117212ULL, 0x080fe400078efcffULL,
0x00000007131c7812ULL, 0x000fe400078e781cULL, 0x0000000e05057212ULL, 0x000fe200078efcffULL,
0x00000010110e7824ULL, 0x000fe200078e0216ULL, 0x000000151e137212ULL, 0x000fc400078efcffULL,
0x000000151c157212ULL, 0x000fe200078efcffULL, 0x0000001005117824ULL, 0x100fe200078e0216ULL,
0x000000040704723eULL, 0x000fe200000010ffULL, 0x0000001013137824ULL, 0x100fe200078e0216ULL,
0x0000003d2e05723eULL, 0x000fe200000010ffULL, 0x0000001015167824ULL, 0x000fe200078e0216ULL,
0x000000060906723eULL, 0x000fe400000010ffULL, 0x000000340b07723eULL, 0x000fe400000010ffULL,
0x000000080d08723eULL, 0x000fc400000010ffULL, 0x0000003b0009723eULL, 0x000fe200000010ffULL,
0x000000040e007844ULL, 0x0005e20000000200ULL, 0x0000000a0f0a723eULL, 0x000fe400000010ffULL,
0x000000230c0b723eULL, 0x000fe400000010ffULL, 0x0000003c2f2c723eULL, 0x000fe400000010ffULL,
0x0000003a2d2d723eULL, 0x000fe200000010ffULL, 0x0000000811007844ULL, 0x0005e20000000200ULL,
0x00000039102e723eULL, 0x000fc400000010ffULL, 0x00000037122f723eULL, 0x000fe400000010ffULL,
0x00000035143c723eULL, 0x000fe400000010ffULL, 0x00000033243d723eULL, 0x000fe200000010ffULL,
0x0000002c13007844ULL, 0x0005e20000000200ULL, 0x00000031183e723eULL, 0x002fe400000010ffULL,
0x000000203f3f723eULL, 0x000fca00000010ffULL, 0x0000003c16007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000197919ULL, 0x000e620000002600ULL,
0x00000020171d7836ULL, 0x04cfe20000000000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000040171f7836ULL, 0x040fe20000000000ULL, 0x00000003ff007819ULL, 0x000fe20000011617ULL,
0x0000006017217836ULL, 0x000fe20000000000ULL, 0x00000003ff047819ULL, 0x000fe2000001161dULL,
0x0000840000057ab9ULL, 0x000fe20000000800ULL, 0x00000003ff167819ULL, 0x000fe2000001161fULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x00000003ff187819ULL, 0x000fe20000011621ULL,
0x0000860000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000718077812ULL, 0x000fc800078e4821ULL,
0x0ffffff807087812ULL, 0x000fca00078ef821ULL, 0x0000001008107824ULL, 0x000fe200078e0203ULL,
0x00000004050472a4ULL, 0x004fca000f8e023fULL, 0x0120000010107984ULL, 0x000fe20000000c00ULL,
0x0000001019057824ULL, 0x042fe400078e00ffULL, 0x0000001019157824ULL, 0x040fe400078e00ffULL,
0x00000010191b7824ULL, 0x040fe200078e00ffULL, 0xfffffff005147812ULL, 0x000fe200078ee200ULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000000700007812ULL, 0x000fe400078e4817ULL,
0xfffffff015157812ULL, 0x000fc400078ee204ULL, 0x0000000704047812ULL, 0x000fe400078e481dULL,
0x0000000716057812ULL, 0x000fe400078e481fULL, 0x0ffffff800007812ULL, 0x000fe400078ef817ULL,
0x0ffffff804047812ULL, 0x000fe400078ef81dULL, 0x0ffffff805067812ULL, 0x000fe200078ef81fULL,
0x0000001000057824ULL, 0x100fe200078e0203ULL, 0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001004097824ULL, 0x100fe200078e0203ULL, 0xfffffff01b167812ULL, 0x000fe200078ee216ULL,
0x00000010060c7824ULL, 0x000fe200078e0203ULL, 0xfffffff019187812ULL, 0x000fe200078ee218ULL,
0x0120000005047984ULL, 0x000e620000000c00ULL, 0x0000000802007824ULL, 0x000fc400078e00ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0120000009087984ULL, 0x000ea20000000c00ULL,
0x0000000614027c11ULL, 0x000fe4000f8048ffULL, 0x1ffffff800007812ULL, 0x000fe200078ec0ffULL,
0x012000000c0c7984ULL, 0x000ee20000000c00ULL, 0x0000000714037c11ULL, 0x000fe400080f4c03ULL,
0x00000007001b7812ULL, 0x000fe400078ef817ULL, 0x0000000415157c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000416177c10ULL, 0x000fe2000ff3e0ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x0000000418197c10ULL, 0x000fe4000ff5e0ffULL, 0x00000007001d7812ULL, 0x000fe200078ef81dULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x0000000615147c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x0000000617167c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x0000000619187c11ULL, 0x000fc4000f8448ffULL,
0x0000000715157c11ULL, 0x000fe400080f4c1eULL, 0x00000007001f7812ULL, 0x000fe400078ef81fULL,
0x0000000717177c11ULL, 0x000fe200088f4c1cULL, 0x000000101d147825ULL, 0x000fe200078e0014ULL,
0x0000000700217812ULL, 0x000fe400078ef821ULL, 0x0000000719197c11ULL, 0x000fe200090f4c1aULL,
0x000000101f167825ULL, 0x000fc800078e0016ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x0000000402007986ULL, 0x002fe8000c101d0cULL, 0x0000000814007986ULL, 0x004fe8000c101d0cULL,
0x0000000c16007986ULL, 0x008fe8000c101d0cULL, 0x0000001018007986ULL, 0x000fe2000c101d0cULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00009400ff087b82ULL, 0x000e620000000a00ULL,
0x03ffffff02047812ULL, 0x010fca00078ec0ffULL, 0x0000000403057824ULL, 0x000fca00078e0204ULL,
0x0000000405007c0cULL, 0x000fe2000bf06070ULL, 0x0000000c08087981ULL, 0x002358000c1e9900ULL,
0x00009000ff078b82ULL, 0x000ea20000000800ULL, 0x000000020e048824ULL, 0x000fce00078e00ffULL,
0x00008c00ff0a8b82ULL, 0x000ee20000000a00ULL, 0x0000000103067836ULL, 0x000fe40000000000ULL,
0x0000000704078224ULL, 0x004fe400078e0205ULL, 0xffffffffff047424ULL, 0x000fe400078e00ffULL,
0x00000004070a8825ULL, 0x008fca00078e000aULL, 0x0000000c0a048981ULL, 0x000362000c1e1900ULL,
0x0000000506007c0cULL, 0x000fe2000bf06070ULL, 0x0000000606067899ULL, 0x000fe2000800063fULL,
0x0000004018077824ULL, 0x000fe400078e00ffULL, 0x0000004002067824ULL, 0x000fd200078e00ffULL,
0x0000000c00448947ULL, 0x002fea0003800000ULL, 0x0000000000097919ULL, 0x000e620000000000ULL,
0x0000010003157824ULL, 0x000fe200078e0206ULL, 0x00000400000b7802ULL, 0x000fe20000000f00ULL,
0x00000006070f7e24ULL, 0x020fe2000f8e0204ULL, 0x0000000000107919ULL, 0x000ea40000008800ULL,
0x0000000b150a7c48ULL, 0x000fca000ffe0000ULL, 0x000000010a157824ULL, 0x000fe200078e0a15ULL,
0x00000003ff167819ULL, 0x002fe20000011609ULL, 0x0000001009137824ULL, 0x040fe200078e00ffULL,
0x0ffffff8090d7812ULL, 0x000fe400078ec0ffULL, 0x00000009160c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000816147836ULL, 0x000fe20000000000ULL, 0x00000654100b7816ULL, 0x004fe2000000000bULL,
0x0000000416127836ULL, 0x000fe20000000000ULL, 0x000000070d257812ULL, 0x000fe200078ef80cULL,
0x00000008142b7824ULL, 0x040fe200078e00ffULL, 0x00000009140c7212ULL, 0x080fe200078e3cffULL,
0x0000000812277824ULL, 0x040fe200078e00ffULL, 0x00000009120a7212ULL, 0x080fe200078e3cffULL,
0x0000000c16187836ULL, 0x040fe20000000000ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL,
0x0000001416247836ULL, 0x000fe20000000000ULL, 0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL,
0xfffffff827277812ULL, 0x000fe200078ee20aULL, 0x00000008182d7824ULL, 0x040fe200078e00ffULL,
0x00000009180a7212ULL, 0x080fe200078e3cffULL, 0x00000010161c7836ULL, 0x000fe20000000000ULL,
0x0000000924117212ULL, 0x0c0fe200078e3cffULL, 0x00000008241a7824ULL, 0x000fe200078e00ffULL,
0x0000003f16107812ULL, 0x000fe200078ec0ffULL, 0x000000081c2f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL, 0x0000001816267836ULL, 0x000fe20000000000ULL,
0x000000091c0a7212ULL, 0x000fe200078e3cffULL, 0x0000001c162a7836ULL, 0x000fe20000000000ULL,
0x000000151200720cULL, 0x080fe20003f86070ULL, 0x00000020162c7836ULL, 0x000fe20000000000ULL,
0xfffffff81a317812ULL, 0x000fe200078ee211ULL, 0x000000010f117824ULL, 0x000fe200078e0210ULL,
0x0000003f12127812ULL, 0x000fe200078ec0ffULL, 0x00000024162e7836ULL, 0x000fe20000000000ULL,
0x000000151400720cULL, 0x000fe20003fa6070ULL, 0x0000000826337824ULL, 0x000fe200078e00ffULL,
0x0000003f14147812ULL, 0x000fc400078ec0ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20aULL,
0x0000010011107825ULL, 0x002fe200078e000cULL, 0x00000070130a7812ULL, 0x000fe400078ec0ffULL,
0x000000151800720cULL, 0x0c0fe20003f06070ULL, 0x000000010f137824ULL, 0x040fe200078e0212ULL,
0x0000003f181a7812ULL, 0x000fe200078ec0ffULL, 0x000000010f197824ULL, 0x000fe200078e0214ULL,
0x000000151c00720cULL, 0x000fe20003f46070ULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x000000100a1e7210ULL, 0x000fc40007f3e0ffULL, 0x0000003f1c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000010019187825ULL, 0x000fe200078e000cULL, 0x000000120a207210ULL, 0x000fe40007f7e0ffULL,
0x0000003f2c287812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e0611ULL,
0x000000180a227210ULL, 0x000fe20007fde0ffULL, 0x000000010f1b7824ULL, 0x040fe200078e021cULL,
0x000000152400720cULL, 0x040fe20003f26070ULL, 0x000000010f177824ULL, 0x000fe200078e021aULL,
0x0000003f24247812ULL, 0x000fe200078ec0ffULL, 0x000000ffff217224ULL, 0x000fe200018e0613ULL,
0x0000003f26187812ULL, 0x000fe200078ec0ffULL, 0x000001001b127825ULL, 0x000fe200078e000cULL,
0x0000003f2a1c7812ULL, 0x000fc600078ec0ffULL, 0x000000ffff237224ULL, 0x000fe200030e0619ULL,
0x000000120a127210ULL, 0x000fe20007fde0ffULL, 0x000000010f197824ULL, 0x000fe400078e0224ULL,
0x0000010017107825ULL, 0x000fc800078e000cULL, 0x000000010f1b7824ULL, 0x000fe200078e0218ULL,
0x000000100a107210ULL, 0x000fe20007f7e0ffULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x000000180a187210ULL, 0x000fe20007fde0ffULL,
0x000001001b1a7825ULL, 0x000fc800078e000cULL, 0x000000ffff117224ULL, 0x000fe200018e0611ULL,
0x000000151600720cULL, 0x000fe20003f66070ULL, 0x0000400002147824ULL, 0x000fe400078e020bULL,
0x000000010f1d7824ULL, 0x000fe400078e021cULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x0000001a0a247210ULL, 0x000fe20007fde0ffULL, 0x0000200014147836ULL, 0x000fe40000000000ULL,
0x000001001d1c7825ULL, 0x000fc800078e000cULL, 0x000000010f297824ULL, 0x000fe200078e0228ULL,
0x0000000926287212ULL, 0x040fe200078e3cffULL, 0x0000001025177824ULL, 0x000fe400078e0214ULL,
0x000000ffff257224ULL, 0x000fe200030e061bULL, 0x0000001c0a1c7210ULL, 0x000fe20007fde0ffULL,
0x00000100291a7825ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e177faeULL, 0x0003e2000d901c4cULL, 0x000000152600720cULL, 0x080fe40003f66070ULL,
0x0000001027297824ULL, 0x100fe200078e0214ULL, 0xfffffff833337812ULL, 0x000fe200078ee228ULL,
0x000000ffff1d7224ULL, 0x000fe200030e061dULL, 0x0000001a0a267210ULL, 0x000fe20007fde0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0214ULL, 0x0000003f2e1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000020297faeULL, 0x000fe2000e101c4cULL, 0x000000152a00720cULL, 0x040fe20003f86070ULL,
0x000000ffff277224ULL, 0x000fe200030e061bULL, 0x000000092a177212ULL, 0x0c2fe200078e3cffULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x00000000222b7faeULL, 0x000fe2000e901c4cULL,
0x000000082c1f7824ULL, 0x040fe200078e00ffULL, 0x000000092c1e7212ULL, 0x040fe200078e3cffULL,
0x000000010f1b7824ULL, 0x000fe200078e021aULL, 0x000000152c00720cULL, 0x000fe20003fa6070ULL,
0x000000102d2d7824ULL, 0x000fe200078e0214ULL, 0xfffffff82a177812ULL, 0x000fe200078ee217ULL,
0x000001001b1a7825ULL, 0x000fe200078e000cULL, 0xfffffff81f1f7812ULL, 0x000fc400078ee21eULL,
0x00000000102d7faeULL, 0x0003e2000c101c4cULL, 0x000000102f2f7824ULL, 0x100fe200078e0214ULL,
0x0000001a0a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000001031317824ULL, 0x100fe400078e0214ULL,
0x0000001033337824ULL, 0x100fe200078e0214ULL, 0x00000000122f7faeULL, 0x0005e2000d101c4cULL,
0x0000001017177824ULL, 0x100fe400078e0214ULL, 0x000000101f1f7824ULL, 0x000fe200078e0214ULL,
0x0000000018317faeULL, 0x0007e2000c901c4cULL, 0x00000028161e7836ULL, 0x000fe20000000000ULL,
0x000000092e107212ULL, 0x042fe200078e3cffULL, 0x000000082e117824ULL, 0x000fe200078e00ffULL,
0x0000000024337faeULL, 0x000fe2000d901c4cULL, 0x0000002c16207836ULL, 0x000fc40000000000ULL,
0x0000003016227836ULL, 0x040fe20000000000ULL, 0x000000001c177faeULL, 0x0003e2000e101c4cULL,
0x0000003416287836ULL, 0x000fe20000000000ULL, 0x000000091e127212ULL, 0x004fe200078e3cffULL,
0x00000038162a7836ULL, 0x040fe20000000000ULL, 0x00000000261f7faeULL, 0x0005e2000e901c4cULL,
0x0000003c162c7836ULL, 0x000fe20000000000ULL, 0x000000151e00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff1b7224ULL, 0x000fe200030e061bULL, 0xfffffff811117812ULL, 0x000fe200078ee210ULL,
0x0000000822217824ULL, 0x000fe200078e00ffULL, 0x000000152e00720cULL, 0x080fe20003fc6070ULL,
0x0000000828187824ULL, 0x008fe200078e00ffULL, 0x000000152000720cULL, 0x000fe20003f86070ULL,
0x000000081e1d7824ULL, 0x042fe200078e00ffULL, 0x0000003f1e1e7812ULL, 0x000fc400078ec0ffULL,
0x000000152200720cULL, 0x080fe20003f66070ULL, 0x00000008201f7824ULL, 0x004fe200078e00ffULL,
0x000000152800720cULL, 0x080fe40003f46070ULL, 0x000000152a00720cULL, 0x080fe40003f26070ULL,
0x000000152c00720cULL, 0x000fe20003f06070ULL, 0x0000001011157824ULL, 0x000fe200078e0214ULL,
0x0000000920107212ULL, 0x040fe200078e3cffULL, 0x000000010f117824ULL, 0x000fe200078e021eULL,
0x0000003f20207812ULL, 0x000fc400078ec0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x0000010011107825ULL, 0x000fe200078e000cULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee212ULL,
0x000000001a157faeULL, 0x0003e2000f101c4cULL, 0x0000000922127212ULL, 0x0c0fe200078e3cffULL,
0x000000010f137824ULL, 0x000fe200078e0220ULL, 0x0000003f22227812ULL, 0x000fe200078ec0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0214ULL, 0xfffffff821217812ULL, 0x000fe200078ee212ULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x0000000928177212ULL, 0x000fc400078e3cffULL,
0x000000100a167210ULL, 0x000fe20007fde0ffULL, 0x000000010f197824ULL, 0x000fe200078e0222ULL,
0xfffffff818237812ULL, 0x000fe200078ee217ULL, 0x000000101f1f7824ULL, 0x000fe200078e0214ULL,
0x0000003f28287812ULL, 0x000fe200078ec0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0611ULL,
0x000000120a187210ULL, 0x000fe20007fde0ffULL, 0x0000010019107825ULL, 0x000fe200078e000cULL,
0x0000003f2a127812ULL, 0x000fe400078ec0ffULL, 0x0000003f2c1c7812ULL, 0x000fe200078ec0ffULL,
0x000000010f157824ULL, 0x042fe200078e0228ULL, 0x00000000161d7faeULL, 0x0003e2000e901c4cULL,
0x000000ffff197224ULL, 0x000fe200030e0613ULL, 0x000000100a1a7210ULL, 0x000fe20007fde0ffULL,
0x000000010f257824ULL, 0x000fc400078e0212ULL, 0x0000010015127825ULL, 0x000fe200078e000cULL,
0x00000000181f7faeULL, 0x0003e6000e101c4cULL, 0x000000ffff1b7224ULL, 0x000fe200030e0611ULL,
0x000000120a127210ULL, 0x000fe20007fde0ffULL, 0x0000010025107825ULL, 0x000fc800078e000cULL,
0x000000010f157824ULL, 0x000fe200078e021cULL, 0x000000092a0f7212ULL, 0x0c0fe200078e3cffULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x000000100a107210ULL, 0x000fe20007fde0ffULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x000000092c1c7212ULL, 0x040fe200078e3cffULL,
0x000000082c257824ULL, 0x000fe400078e00ffULL, 0x00000100150c7825ULL, 0x000fe200078e000cULL,
0xfffffff82a0f7812ULL, 0x000fe400078ee20fULL, 0xfffffff825257812ULL, 0x000fe200078ee21cULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x0000000c0a0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001021217824ULL, 0x000fc400078e0214ULL, 0x0000001023237824ULL, 0x100fe400078e0214ULL,
0x000000100f0f7824ULL, 0x100fe200078e0214ULL, 0x000000001a217faeULL, 0x0003e2000d901c4cULL,
0x0000001025257824ULL, 0x000fe400078e0214ULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x0000000012237faeULL, 0x0003e8000d101c4cULL, 0x00000000100f7faeULL, 0x0003e8000c901c4cULL,
0x000000000c257faeULL, 0x0003e2000c101c4cULL, 0x0000000800f47947ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000e620000000000ULL, 0x00000400000b7802ULL, 0x000fe20000000f00ULL,
0x0000000000107919ULL, 0x000ea20000008800ULL, 0x00000003ff0a7819ULL, 0x002fe40000011609ULL,
0x0ffffff8090d7812ULL, 0x000fe400078ec0ffULL, 0x000000090a0c7212ULL, 0x0c0fe200078e3cffULL,
0x000000080a187836ULL, 0x000fe20000000000ULL, 0x00000654100b7816ULL, 0x004fe2000000000bULL,
0x0000000c0a1c7836ULL, 0x000fe20000000000ULL, 0x000000070d127812ULL, 0x000fe200078ef80cULL,
0x00000008181a7824ULL, 0x040fe200078e00ffULL, 0x0000000918117212ULL, 0x080fe200078e3cffULL,
0x000000100a207836ULL, 0x000fe20000000000ULL, 0x000000091c0c7212ULL, 0x080fe200078e3cffULL,
0x000000040a147836ULL, 0x000fe20000000000ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL,
0x000000081c117824ULL, 0x000fe200078e00ffULL, 0x00000009200d7212ULL, 0x0c0fe200078e3cffULL,
0x0000000820227824ULL, 0x000fe200078e00ffULL, 0x00000009140f7212ULL, 0x080fe200078e3cffULL,
0x000000180a287836ULL, 0x040fe20000000000ULL, 0xfffffff8111e7812ULL, 0x000fe200078ee20cULL,
0x0000001c0a2c7836ULL, 0x040fe20000000000ULL, 0xfffffff822227812ULL, 0x000fe200078ee20dULL,
0x000000200a307836ULL, 0x000fe20000000000ULL, 0x0000000928107212ULL, 0x080fe200078e3cffULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x000000092c0c7212ULL, 0x080fe200078e3cffULL,
0x000000140a247836ULL, 0x000fe20000000000ULL, 0x00000009300d7212ULL, 0x080fe200078e3cffULL,
0x0000000828137824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee20fULL,
0x000000082c117824ULL, 0x000fe200078e00ffULL, 0x00000009240f7212ULL, 0x080fe200078e3cffULL,
0x0000000830327824ULL, 0x000fe200078e00ffULL, 0xfffffff8132a7812ULL, 0x000fe200078ee210ULL,
0x0000002c0a3c7836ULL, 0x040fe20000000000ULL, 0xfffffff8112e7812ULL, 0x000fe200078ee20cULL,
0x000000300a407836ULL, 0x040fe20000000000ULL, 0xfffffff832327812ULL, 0x000fe200078ee20dULL,
0x000000280a387836ULL, 0x000fe20000000000ULL, 0x000000093c0c7212ULL, 0x080fe200078e3cffULL,
0x0000000824267824ULL, 0x000fe200078e00ffULL, 0x00000009400d7212ULL, 0x080fe200078e3cffULL,
0x000000240a347836ULL, 0x000fe20000000000ULL, 0x0000000938107212ULL, 0x0c0fe200078e3cffULL,
0x0000000838137824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20fULL,
0x000000083c117824ULL, 0x000fe200078e00ffULL, 0x00000009340f7212ULL, 0x080fe200078e3cffULL,
0x0000000840427824ULL, 0x000fe200078e00ffULL, 0xfffffff8133a7812ULL, 0x000fe200078ee210ULL,
0x0000000834367824ULL, 0x000fe200078e00ffULL, 0xfffffff8113e7812ULL, 0x000fe200078ee20cULL,
0x000000380a487836ULL, 0x040fe20000000000ULL, 0xfffffff842427812ULL, 0x000fe200078ee20dULL,
0x000000340a447836ULL, 0x000fe20000000000ULL, 0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL,
0x0000000848137824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee20fULL,
0x0000000844467824ULL, 0x000fe200078e00ffULL, 0x0000000948107212ULL, 0x080fe200078e3cffULL,
0x0000400002117824ULL, 0x000fe200078e020bULL, 0x00000009440f7212ULL, 0x000fc400078e3cffULL,
0xfffffff8134a7812ULL, 0x000fe200078ee210ULL, 0x0000200011137836ULL, 0x000fe20000000000ULL,
0xfffffff846467812ULL, 0x000fe200078ee20fULL, 0x00000006070f7e24ULL, 0x020fe2000f8e0204ULL,
0x0000003f0a107812ULL, 0x040fe200078ec0ffULL, 0x0000003c0a0a7836ULL, 0x000fe20000000000ULL,
0x0000003f14147812ULL, 0x000fe200078ec0ffULL, 0x000000101a337824ULL, 0x000fe200078e0213ULL,
0x0000003f18187812ULL, 0x000fe200078ec0ffULL, 0x000000010f117824ULL, 0x040fe200078e0210ULL,
0x0000003f0a107812ULL, 0x040fe200078ec0ffULL, 0x000000010f157824ULL, 0x040fe200078e0214ULL,
0x000000090a317212ULL, 0x040fe200078e3cffULL, 0x000000080a0a7824ULL, 0x000fe200078e00ffULL,
0x0000003f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x000000010f177824ULL, 0x040fe200078e0218ULL,
0x0000003f20207812ULL, 0x000fe200078ec0ffULL, 0x000000010f4d7824ULL, 0x040fe200078e0210ULL,
0x0000003f24247812ULL, 0x000fe200078ec0ffULL, 0x000000010f197824ULL, 0x040fe200078e021cULL,
0x0000003f28287812ULL, 0x000fe200078ec0ffULL, 0x000000010f1b7824ULL, 0x040fe200078e0220ULL,
0x0000003f2c2c7812ULL, 0x000fe200078ec0ffULL, 0x000000010f1d7824ULL, 0x040fe200078e0224ULL,
0x0000003f30307812ULL, 0x000fe200078ec0ffULL, 0x000000010f1f7824ULL, 0x040fe200078e0228ULL,
0x0000003f34347812ULL, 0x000fe200078ec0ffULL, 0x000000010f217824ULL, 0x040fe200078e022cULL,
0x0000003f38387812ULL, 0x000fe200078ec0ffULL, 0x000000010f237824ULL, 0x040fe200078e0230ULL,
0x0000003f3c3c7812ULL, 0x000fe200078ec0ffULL, 0x000000010f257824ULL, 0x040fe200078e0234ULL,
0x0000003f40407812ULL, 0x000fe200078ec0ffULL, 0x000000010f277824ULL, 0x040fe200078e0238ULL,
0x0000003f44447812ULL, 0x000fe200078ec0ffULL, 0x000000010f297824ULL, 0x040fe200078e023cULL,
0x0000003f48487812ULL, 0x000fe200078ec0ffULL, 0x000000010f2b7824ULL, 0x040fe200078e0240ULL,
0xfffffff80a147812ULL, 0x000fe200078ee231ULL, 0x000000010f2d7824ULL, 0x000fc400078e0244ULL,
0x000000010f2f7824ULL, 0x000fe400078e0248ULL, 0x00000010120a7824ULL, 0x100fe400078e0213ULL,
0x00000010160f7824ULL, 0x100fe400078e0213ULL, 0x000000101e357824ULL, 0x100fe400078e0213ULL,
0x0000001022377824ULL, 0x100fe400078e0213ULL, 0x0000001026397824ULL, 0x000fc400078e0213ULL,
0x000000102a3b7824ULL, 0x100fe400078e0213ULL, 0x000000102e3d7824ULL, 0x100fe400078e0213ULL,
0x00000010323f7824ULL, 0x100fe400078e0213ULL, 0x0000001036417824ULL, 0x100fe400078e0213ULL,
0x000000103a437824ULL, 0x100fe400078e0213ULL, 0x000000103e457824ULL, 0x000fc400078e0213ULL,
0x0000001042477824ULL, 0x100fe400078e0213ULL, 0x0000001046497824ULL, 0x100fe400078e0213ULL,
0x000000104a4b7824ULL, 0x100fe400078e0213ULL, 0x00000010144f7824ULL, 0x000fe400078e0213ULL,
0x0000010015127825ULL, 0x002fc800078e000cULL, 0x0000010017147825ULL, 0x000fc800078e000cULL,
0x0000010019167825ULL, 0x000fc800078e000cULL, 0x000001001b187825ULL, 0x000fc800078e000cULL,
0x0000001009107824ULL, 0x000fe400078e00ffULL, 0x000001001d1a7825ULL, 0x000fc600078e000cULL,
0x0000007010317812ULL, 0x000fe200078ec0ffULL, 0x000001001f1c7825ULL, 0x000fc800078e000cULL,
0x00000100211e7825ULL, 0x000fc800078e000cULL, 0x0000010023207825ULL, 0x000fc800078e000cULL,
0x0000010025227825ULL, 0x000fc800078e000cULL, 0x0000010027247825ULL, 0x000fc800078e000cULL,
0x0000010011107825ULL, 0x000fc800078e000cULL, 0x0000010029267825ULL, 0x000fc800078e000cULL,
0x000001002b287825ULL, 0x000fc800078e000cULL, 0x000001002d2a7825ULL, 0x000fc800078e000cULL,
0x000001002f2c7825ULL, 0x000fc800078e000cULL, 0x000001004d2e7825ULL, 0x000fe200078e000cULL,
0x00000010310c7210ULL, 0x000fe40007f1e0ffULL, 0x0000001231107210ULL, 0x000fe40007f3e0ffULL,
0x0000001431127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0611ULL,
0x0000001631147210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0613ULL,
0x0000001831167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0615ULL,
0x0000001a31187210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0617ULL,
0x0000001c311a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e0619ULL,
0x0000001e311c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff197224ULL, 0x000fe200008e061bULL,
0x00000020311e7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e061dULL,
0x0000002231207210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e061fULL,
0x0000002431227210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0a7faeULL, 0x0003e2000b901c4cULL, 0x0000002631247210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0621ULL, 0x0000002831267210ULL, 0x000fe20007f1e0ffULL,
0x00000000100f7faeULL, 0x0003e2000b901c4cULL, 0x000000ffff217224ULL, 0x000fe200008e0623ULL,
0x0000002a31287210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e0625ULL,
0x0000000012337faeULL, 0x0003e2000b901c4cULL, 0x000000ffff257224ULL, 0x000fe200018e0627ULL,
0x0000002c312a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0629ULL,
0x0000000014357faeULL, 0x0003e2000b901c4cULL, 0x0000002e312c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fc400008e062bULL, 0x0000000016377faeULL, 0x0003e2000b901c4cULL,
0x000000ffff2b7224ULL, 0x000fe400010e062dULL, 0x000000ffff2d7224ULL, 0x000fe200018e062fULL,
0x0000000018397faeULL, 0x0003e8000b901c4cULL, 0x000000001a3b7faeULL, 0x0003e8000b901c4cULL,
0x000000001c3d7faeULL, 0x0003e8000b901c4cULL, 0x000000001e3f7faeULL, 0x0003e8000b901c4cULL,
0x0000000020417faeULL, 0x0003e8000b901c4cULL, 0x0000000022437faeULL, 0x0003e8000b901c4cULL,
0x0000000024457faeULL, 0x0003e8000b901c4cULL, 0x0000000026477faeULL, 0x0003e8000b901c4cULL,
0x0000000028497faeULL, 0x0003e8000b901c4cULL, 0x000000002a4b7faeULL, 0x0003e8000b901c4cULL,
0x000000002c4f7faeULL, 0x0003e4000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01c600ff0b0075a7ULL, 0x000ea2000800017fULL, 0x000000030200780cULL, 0x000fe20003f24070ULL,
0x00000001ff1e7424ULL, 0x002fe400078e00ffULL, 0x80000000ff1c7424ULL, 0x000fe200078e00ffULL,
0x00000044009c8947ULL, 0x004ff20003800000ULL, 0x0000000000ac1947ULL, 0x000fea0003800000ULL,
0x00000020020a7824ULL, 0x000fc800078e0209ULL, 0x000000200a0f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0c7819ULL, 0x000fc8000001160aULL, 0x1ffffffe0c0d7812ULL, 0x000fe400078ec0ffULL,
0x000001e00f0f7812ULL, 0x000fe400078ec0ffULL, 0x000000010d117812ULL, 0x040fe400078efcffULL,
0x000000070d0c7812ULL, 0x000fe400078e780aULL, 0x0000000711107812ULL, 0x000fe200078e780aULL,
0x000000100d117836ULL, 0x000fe40000000000ULL, 0x000000010f0c7824ULL, 0x000fc400078e020cULL,
0x000000010f107824ULL, 0x000fe200078e0210ULL, 0x0000000711127812ULL, 0x000fe200078e780aULL,
0x000000100c0c7824ULL, 0x100fe400078e020bULL, 0x0000001010107824ULL, 0x000fe400078e020bULL,
0x000000110d0d7836ULL, 0x000fe20000000000ULL, 0x000000000c187984ULL, 0x000e620000000c00ULL,
0x000000010f127824ULL, 0x000fc600078e0212ULL, 0x0000000010147984ULL, 0x000ea20000000c00ULL,
0x000000070d0a7812ULL, 0x000fe200078e780aULL, 0x0000001012127824ULL, 0x000fc800078e020bULL,
0x000000010f0a7824ULL, 0x000fc800078e020aULL, 0x000000100a0a7824ULL, 0x000fe400078e020bULL,
0x000000ffff207224ULL, 0x002fe400078e0018ULL, 0x000000ffff217224ULL, 0x000fe400078e001aULL,
0x000000ffff227224ULL, 0x004fe400078e0014ULL, 0x000000ffff237224ULL, 0x000fe400078e0016ULL,
0x000000ffff247224ULL, 0x000fc400078e0019ULL, 0x000000ffff257224ULL, 0x000fe200078e001bULL,
0x000000200c007388ULL, 0x000fe20000000c00ULL, 0x000000ffff267224ULL, 0x000fe400078e0015ULL,
0x000000ffff277224ULL, 0x000fca00078e0017ULL, 0x0000002410007388ULL, 0x000fe80000000c00ULL,
0x000000000a147984ULL, 0x000e680000000c00ULL, 0x0000000012187984ULL, 0x000ea20000000c00ULL,
0x000000ffff2b7224ULL, 0x002fe400078e0016ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0014ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff287224ULL, 0x004fe400078e0018ULL,
0x000000ffff297224ULL, 0x000fe400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x0000002812007388ULL, 0x0003e80000000c00ULL,
0x000000140a007388ULL, 0x0003e40000000c00ULL, 0x01c6001e0bff79a7ULL, 0x0005e2000850003fULL,
0x0000000503007c0cULL, 0x000fe2000bf26070ULL, 0x01c6001c0b0075a7ULL, 0x000ee4000800017fULL,
0x0000004000f48947ULL, 0x00cff40003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000900000087ab9ULL, 0x000fe20000000800ULL, 0x3d80000008087820ULL, 0x000fe20000410000ULL,
0x00000010020a7824ULL, 0x002fe200078e020bULL, 0x00007610ff0d7816ULL, 0x000fe2000000000dULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0xffffffff05077890ULL, 0x000fe2000fffe03fULL,
0x000000080e0e7c24ULL, 0x000fd6000f8e02ffULL, 0x00000100030f7824ULL, 0x000fca00078e0206ULL,
0x0000000b0f007c0cULL, 0x000fda000bf01070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fce000001ff00ULL,
0x000000013c127836ULL, 0x000fe40000000000ULL, 0x000000ffff427224ULL, 0x000fe400078e003cULL,
0x000000ffff3c7224ULL, 0x100fe200078e0012ULL, 0x00000001ff0c7819ULL, 0x000fe40000011612ULL,
0x000000021200780cULL, 0x040fe40003f06070ULL, 0x0000000112117812ULL, 0x000fe200078ec0ffULL,
0x000000000c4d7224ULL, 0x000fc800078e0203ULL, 0x000000014d0c7836ULL, 0x000fca0000000000ULL,
0x000000050c007c0cULL, 0x000fe4000bf26070ULL, 0x00000001100c7812ULL, 0x000fd600078e0cffULL,
0x0000000800f89947ULL, 0x020fea0003800000ULL, 0x00000003ff447819ULL, 0x000fe20000011609ULL,
0x000001004d4d7824ULL, 0x000fe400078e0206ULL, 0x0000000607477e24ULL, 0x000fe4000f8e0204ULL,
0x00000004441e7836ULL, 0x040fe20000000000ULL, 0x0000000b4d127c48ULL, 0x000fe2000ffe0000ULL,
0x00000010445c7836ULL, 0x000fe40000000000ULL, 0x000000081e147824ULL, 0x040fe200078e00ffULL,
0x000000091e177212ULL, 0x080fe200078e3cffULL, 0x0000002044567836ULL, 0x000fe20000000000ULL,
0x000000095c597212ULL, 0x080fe200078e3cffULL, 0x00000008443e7836ULL, 0x000fe20000000000ULL,
0xfffffff814177812ULL, 0x000fe200078ee217ULL, 0x000000085c147824ULL, 0x000fe200078e00ffULL,
0x0000000956517212ULL, 0x080fe200078e3cffULL, 0x0000000c44407836ULL, 0x000fe20000000000ULL,
0x000000093e1f7212ULL, 0x080fe200078e3cffULL, 0x0000002c444a7836ULL, 0x000fe20000000000ULL,
0xfffffff814597812ULL, 0x000fe200078ee259ULL, 0x0000000856147824ULL, 0x000fe200078e00ffULL,
0x00000009403f7212ULL, 0x080fe200078e3cffULL, 0x000000083e167824ULL, 0x000fe200078e00ffULL,
0x000000094a4b7212ULL, 0x000fe200078e3cffULL, 0x00000001124d7824ULL, 0x000fe200078e0a4dULL,
0xfffffff814517812ULL, 0x000fe200078ee251ULL, 0x0000001444547836ULL, 0x000fe20000000000ULL,
0xfffffff8161f7812ULL, 0x000fe200078ee21fULL, 0x0000000840127824ULL, 0x000fe200078e00ffULL,
0x0000004d1e00720cULL, 0x000fe20003f46070ULL, 0x000000084a147824ULL, 0x000fe200078e00ffULL,
0x0000000954577212ULL, 0x080fe200078e3cffULL, 0x0000001c445a7836ULL, 0x000fe20000000000ULL,
0xfffffff8123f7812ULL, 0x000fe200078ee23fULL, 0x0000000854167824ULL, 0x000fe200078e00ffULL,
0xfffffff8144b7812ULL, 0x000fe200078ee24bULL, 0x0000001844527836ULL, 0x000fe20000000000ULL,
0x000000095a537212ULL, 0x080fe200078e3cffULL, 0x0000002444587836ULL, 0x000fe20000000000ULL,
0x00008a00ff147b82ULL, 0x000e620000000a00ULL, 0x000000085a127824ULL, 0x000fe200078e00ffULL,
0xfffffff816577812ULL, 0x000fe200078ee257ULL, 0x00000028444e7836ULL, 0x000fe20000000000ULL,
0x0000000952557212ULL, 0x0c0fe200078e3cffULL, 0x00000008521c7824ULL, 0x000fe200078e00ffULL,
0x00000009584f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000858167824ULL, 0x000fe200078e00ffULL,
0xfffffff812537812ULL, 0x000fe200078ee253ULL, 0x0000003044127836ULL, 0x000fe20000000000ULL,
0x000000094e4c7212ULL, 0x080fe200078e3cffULL, 0x0000003444487836ULL, 0x000fe20000000000ULL,
0xfffffff81c557812ULL, 0x000fe200078ee255ULL, 0x000000084e137824ULL, 0x000fe200078e00ffULL,
0xfffffff8164f7812ULL, 0x000fe200078ee24fULL, 0x0000003844467836ULL, 0x000fe20000000000ULL,
0x0000000912497212ULL, 0x0c0fe200078e3cffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0x0000000948457212ULL, 0x0c0fe200078e3cffULL, 0x00000008481c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8134c7812ULL, 0x000fe200078ee24cULL, 0x0000000846507824ULL, 0x040fe200078e00ffULL,
0x0000000946437212ULL, 0x000fe200078e3cffULL, 0x0000400002137824ULL, 0x000fe200078e020bULL,
0xfffffff816497812ULL, 0x000fe200078ee249ULL, 0x00000008115e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c457812ULL, 0x000fc400078ee245ULL, 0xfffffff850437812ULL, 0x000fe200078ee243ULL,
0x000020000c507824ULL, 0x000fe200078e0213ULL, 0x00000009441c7212ULL, 0x040fe400078e3cffULL,
0x0000003f44167812ULL, 0x000fe200078ec0ffULL, 0x0000200050507836ULL, 0x000fe20000000000ULL,
0x0000003f1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000004d3e00720cULL, 0x0c0fe20003f66070ULL,
0x00000001471d7824ULL, 0x040fe200078e0216ULL, 0x0000003f3e3e7812ULL, 0x000fe200078ec0ffULL,
0x0000000147417824ULL, 0x000fe200078e021eULL, 0x0000004d4000720cULL, 0x0c0fe20003f86070ULL,
0x000000103f617824ULL, 0x000fe200078e0250ULL, 0x0000003f40407812ULL, 0x000fe200078ec0ffULL,
0x0000000147637824ULL, 0x000fe200078e023eULL, 0x0000004d5c00720cULL, 0x000fe20003fa6070ULL,
0x00000100413e7825ULL, 0x002fe200078e0014ULL, 0x000000071c1c7812ULL, 0x000fc400078ec0ffULL,
0x0000003f5c5c7812ULL, 0x000fe200078ec0ffULL, 0x0000000147657824ULL, 0x000fe200078e0240ULL,
0x0000004d4400720cULL, 0x000fe20003f26070ULL, 0x000000101f5f7824ULL, 0x000fe200078e0250ULL,
0x0ffffff81c5b7812ULL, 0x000fe200078ef809ULL, 0x0000000147677824ULL, 0x000fe200078e025cULL,
0xfffffff85e3d7812ULL, 0x000fe200078ee209ULL, 0x000001001d1c7825ULL, 0x000fc800078e0014ULL,
0x0000010063407825ULL, 0x000fc800078e0014ULL, 0x00000010175d7824ULL, 0x000fe400078e0250ULL,
0x00000100651e7825ULL, 0x000fc800078e0014ULL, 0x0000010067167825ULL, 0x000fc800078e0014ULL,
0x000000105b5b7824ULL, 0x000fe400078e0250ULL, 0x000000103d1c7825ULL, 0x000fc800078e001cULL,
0x000000103d3e7825ULL, 0x040fe200078e003eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c5b7faeULL, 0x000fe2000c901c4cULL, 0x0000004d5400720cULL, 0x0c0fe40003f26070ULL,
0x000000103d407825ULL, 0x040fe200078e0040ULL, 0x000000003e5d7faeULL, 0x000fe2000d101c4cULL,
0x0000003f54547812ULL, 0x000fe400078ec0ffULL, 0x000000103d1e7825ULL, 0x000fe200078e001eULL,
0x00000000405f7faeULL, 0x0003e2000d901c4cULL, 0x0000004d5200720cULL, 0x000fc40003f46070ULL,
0x0000001059597824ULL, 0x000fe200078e0250ULL, 0x000000001e617faeULL, 0x0005e2000e101c4cULL,
0x000000103d167825ULL, 0x000fe200078e0016ULL, 0x0000003f52527812ULL, 0x000fe400078ec0ffULL,
0x0000004d5a00720cULL, 0x0c0fe20003f66070ULL, 0x0000001057577824ULL, 0x000fe200078e0250ULL,
0x0000000016597faeULL, 0x0007e2000e901c4cULL, 0x0000003f5a5a7812ULL, 0x000fe200078ec0ffULL,
0x0000000147417824ULL, 0x002fe200078e0252ULL, 0x0000004d5600720cULL, 0x0c0fe20003f86070ULL,
0x0000001055557824ULL, 0x000fe200078e0250ULL, 0x0000003f56567812ULL, 0x000fe200078ec0ffULL,
0x00000001471f7824ULL, 0x044fe200078e0254ULL, 0x0000004d5800720cULL, 0x040fe20003fa6070ULL,
0x00000001473f7824ULL, 0x040fe200078e025aULL, 0x0000003f58587812ULL, 0x000fe200078ec0ffULL,
0x00000001471d7824ULL, 0x000fc400078e0256ULL, 0x000001001f1e7825ULL, 0x000fc800078e0014ULL,
0x0000000147177824ULL, 0x008fe400078e0258ULL, 0x0000010041407825ULL, 0x000fc800078e0014ULL,
0x000001003f3e7825ULL, 0x000fc800078e0014ULL, 0x000001001d1c7825ULL, 0x000fc800078e0014ULL,
0x0000010017167825ULL, 0x000fc800078e0014ULL, 0x000000103d1e7825ULL, 0x000fc800078e001eULL,
0x000000103d407825ULL, 0x000fe200078e0040ULL, 0x000000001e577faeULL, 0x0003e2000c901c4cULL,
0x0000004d4e00720cULL, 0x080fe40003f26070ULL, 0x0000001053537824ULL, 0x000fe200078e0250ULL,
0x0000000040557faeULL, 0x000fe2000d101c4cULL, 0x000000103d3e7825ULL, 0x000fe200078e003eULL,
0x0000004d4a00720cULL, 0x080fe40003f46070ULL, 0x0000003f4e4e7812ULL, 0x000fe200078ec0ffULL,
0x0000001051517824ULL, 0x000fe200078e0250ULL, 0x000000003e537faeULL, 0x000fe2000d901c4cULL,
0x000000103d1c7825ULL, 0x000fe200078e001cULL, 0x0000004d1200720cULL, 0x000fc40003f66070ULL,
0x0000003f4a4a7812ULL, 0x000fe200078ec0ffULL, 0x000000104f4f7824ULL, 0x000fe200078e0250ULL,
0x000000001c517faeULL, 0x0005e2000e101c4cULL, 0x000000103d167825ULL, 0x000fe200078e0016ULL,
0x0000004d4800720cULL, 0x080fe40003f86070ULL, 0x0000003f12127812ULL, 0x000fe200078ec0ffULL,
0x0000003c44527836ULL, 0x000fe20000000000ULL, 0x00000000164f7faeULL, 0x0007e2000e901c4cULL,
0x0000004d4600720cULL, 0x000fe20003fa6070ULL, 0x000000104b4b7824ULL, 0x000fe200078e0250ULL,
0x0000003f48487812ULL, 0x000fe200078ec0ffULL, 0x00000001471f7824ULL, 0x042fe200078e0212ULL,
0x0000003f46467812ULL, 0x000fe200078ec0ffULL, 0x00000001471d7824ULL, 0x044fe200078e024aULL,
0x00000009521c7212ULL, 0x040fe200078e3cffULL, 0x00000001473f7824ULL, 0x040fe200078e0248ULL,
0x0000004d5200720cULL, 0x040fe20003fc6070ULL, 0x0000000147417824ULL, 0x000fe200078e0246ULL,
0x0000003f52167812ULL, 0x048fe200078ec0ffULL, 0x00000008524f7824ULL, 0x000fc400078e00ffULL,
0x0000000147177824ULL, 0x040fe400078e024eULL, 0x0000000147477824ULL, 0x000fe200078e0216ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee21cULL, 0x0000010017167825ULL, 0x000fc800078e0014ULL,
0x000001001d1c7825ULL, 0x000fc800078e0014ULL, 0x000001001f1e7825ULL, 0x000fc800078e0014ULL,
0x000001003f3e7825ULL, 0x000fc800078e0014ULL, 0x0000010041407825ULL, 0x000fc800078e0014ULL,
0x0000010047467825ULL, 0x000fc800078e0014ULL, 0x000000104c4d7824ULL, 0x000fe400078e0250ULL,
0x000000103d147825ULL, 0x000fc800078e0016ULL, 0x000000103d167825ULL, 0x000fe200078e001cULL,
0x00000000144d7faeULL, 0x0003e6000c901c4cULL, 0x0000001049497824ULL, 0x000fe200078e0250ULL,
0x00000000164b7faeULL, 0x0003e2000d101c4cULL, 0x000000103d1c7825ULL, 0x000fc800078e001eULL,
0x0000001045457824ULL, 0x000fe200078e0250ULL, 0x000000001c497faeULL, 0x0003e2000d901c4cULL,
0x000000103d1e7825ULL, 0x000fc800078e003eULL, 0x0000001043437824ULL, 0x000fe200078e0250ULL,
0x000000001e457faeULL, 0x0003e2000e101c4cULL, 0x000000103d3e7825ULL, 0x000fc800078e0040ULL,
0x000000104f4f7824ULL, 0x000fe200078e0250ULL, 0x000000003e437faeULL, 0x0003e2000e901c4cULL,
0x000000103d407825ULL, 0x000fca00078e0046ULL, 0x00000000404f7faeULL, 0x0003e2000f101c4cULL,
0x0000000800a87947ULL, 0x000fea0003800000ULL, 0x00000003ff447819ULL, 0x000fe20000011609ULL,
0x00008a00ff607b82ULL, 0x000e620000000a00ULL, 0x00000006076d7e24ULL, 0x000fc6000f8e0204ULL,
0x0000000444407836ULL, 0x040fe40000000000ULL, 0x0000000c44487836ULL, 0x000fe40000000000ULL,
0x0000000840127824ULL, 0x040fe200078e00ffULL, 0x0000000940677212ULL, 0x080fe200078e3cffULL,
0x0000000844467836ULL, 0x000fe20000000000ULL, 0x0000000948637212ULL, 0x080fe200078e3cffULL,
0x0000001c44507836ULL, 0x000fe20000000000ULL, 0xfffffff812677812ULL, 0x000fe200078ee267ULL,
0x0000000848127824ULL, 0x000fe200078e00ffULL, 0x0000000946657212ULL, 0x0c0fe200078e3cffULL,
0x0000000846147824ULL, 0x000fe200078e00ffULL, 0x00000009501f7212ULL, 0x080fe200078e3cffULL,
0x00000018444e7836ULL, 0x040fe20000000000ULL, 0xfffffff812637812ULL, 0x000fe200078ee263ULL,
0x00000010444a7836ULL, 0x000fe20000000000ULL, 0xfffffff814657812ULL, 0x000fe200078ee265ULL,
0x0000000850127824ULL, 0x000fe200078e00ffULL, 0x000000094e3d7212ULL, 0x080fe200078e3cffULL,
0x0000002c44587836ULL, 0x000fe20000000000ULL, 0x000000094a457212ULL, 0x080fe200078e3cffULL,
0x000000084e1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8121f7812ULL, 0x000fe200078ee21fULL,
0x000000084a147824ULL, 0x000fe200078e00ffULL, 0x0000000958177212ULL, 0x080fe200078e3cffULL,
0x0000002044527836ULL, 0x040fe20000000000ULL, 0xfffffff81c3d7812ULL, 0x000fe200078ee23dULL,
0x0000002844567836ULL, 0x040fe20000000000ULL, 0xfffffff814457812ULL, 0x000fe200078ee245ULL,
0x00000014444c7836ULL, 0x000fe20000000000ULL, 0x00000009521e7212ULL, 0x080fe200078e3cffULL,
0x0000002444547836ULL, 0x000fe20000000000ULL, 0x00000009561c7212ULL, 0x080fe200078e3cffULL,
0x0000000858127824ULL, 0x000fe200078e00ffULL, 0x000000094c437212ULL, 0x080fe200078e3cffULL,
0x0000000852137824ULL, 0x000fe200078e00ffULL, 0x00000009541d7212ULL, 0x080fe200078e3cffULL,
0x0000000856157824ULL, 0x000fe200078e00ffULL, 0xfffffff812177812ULL, 0x000fe200078ee217ULL,
0x000000084c167824ULL, 0x000fe200078e00ffULL, 0x0000003f44127812ULL, 0x040fe200078ec0ffULL,
0x00000034445c7836ULL, 0x000fe20000000000ULL, 0xfffffff8131e7812ULL, 0x000fe200078ee21eULL,
0x0000000854147824ULL, 0x000fe200078e00ffULL, 0xfffffff8151c7812ULL, 0x000fe200078ee21cULL,
0x00000030445a7836ULL, 0x040fe20000000000ULL, 0xfffffff816437812ULL, 0x000fe200078ee243ULL,
0x00000038445e7836ULL, 0x000fe20000000000ULL, 0x000000095c157212ULL, 0x0c0fe200078e3cffULL,
0x000000085c3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8141d7812ULL, 0x000fe200078ee21dULL,
0x0000003c44627836ULL, 0x000fe20000000000ULL, 0x000000095a167212ULL, 0x0c0fe200078e3cffULL,
0x000000085a137824ULL, 0x000fe200078e00ffULL, 0x000000095e147212ULL, 0x040fe200078e3cffULL,
0x000000085e3f7824ULL, 0x000fe200078e00ffULL, 0x0000003f40407812ULL, 0x000fe200078ec0ffULL,
0x000000016d5f7824ULL, 0x040fe200078e0212ULL, 0x0000003f46467812ULL, 0x000fe200078ec0ffULL,
0x00000008626f7824ULL, 0x000fe200078e00ffULL, 0x0000003f48487812ULL, 0x000fe200078ec0ffULL,
0x000000016d5d7824ULL, 0x000fe200078e0240ULL, 0x0000003f4a4a7812ULL, 0x000fc400078ec0ffULL,
0x0000003f4c4c7812ULL, 0x000fe200078ec0ffULL, 0x000000016d5b7824ULL, 0x040fe200078e0248ULL,
0x0000003f4e4e7812ULL, 0x000fe200078ec0ffULL, 0x000000016d597824ULL, 0x040fe200078e024aULL,
0x0000003f50507812ULL, 0x000fe200078ec0ffULL, 0x000000016d577824ULL, 0x040fe200078e024cULL,
0x0000003f52527812ULL, 0x000fe200078ec0ffULL, 0x000000016d557824ULL, 0x040fe200078e024eULL,
0x0000003f54547812ULL, 0x000fe200078ec0ffULL, 0x000000016d537824ULL, 0x040fe200078e0250ULL,
0x0000003f56567812ULL, 0x000fe200078ec0ffULL, 0x000000016d517824ULL, 0x040fe200078e0252ULL,
0x0000003f58587812ULL, 0x000fe200078ec0ffULL, 0x000000016d4f7824ULL, 0x040fe200078e0254ULL,
0x0000003f5a5a7812ULL, 0x000fe200078ec0ffULL, 0x000000016d4d7824ULL, 0x040fe200078e0256ULL,
0x0000003f5c5c7812ULL, 0x000fe200078ec0ffULL, 0x000000016d4b7824ULL, 0x040fe200078e0258ULL,
0x0000003f5e5e7812ULL, 0x000fe200078ec0ffULL, 0x000000016d497824ULL, 0x040fe200078e025aULL,
0xfffffff83e157812ULL, 0x000fe200078ee215ULL, 0x000000016d477824ULL, 0x040fe200078e025cULL,
0x0000003f62127812ULL, 0x000fe200078ec0ffULL, 0x000000016d417824ULL, 0x000fe200078e025eULL,
0xfffffff813167812ULL, 0x000fe200078ee216ULL, 0x0000400002137824ULL, 0x000fe200078e020bULL,
0x00000009443e7212ULL, 0x000fe200078e3cffULL, 0x000001005f5e7825ULL, 0x002fe200078e0060ULL,
0xfffffff83f147812ULL, 0x000fc400078ee214ULL, 0x000000073e3e7812ULL, 0x000fe200078ec0ffULL,
0x000000016d3f7824ULL, 0x040fe200078e0246ULL, 0x0000000962407212ULL, 0x000fe200078e3cffULL,
0x000000016d6d7824ULL, 0x000fe200078e0212ULL, 0x0ffffff83e3e7812ULL, 0x000fe200078ef809ULL,
0x000020000c127824ULL, 0x000fe200078e0213ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee240ULL,
0x0000000811467824ULL, 0x000fe400078e00ffULL, 0x0000200012127836ULL, 0x000fe40000000000ULL,
0x000001005d5c7825ULL, 0x000fe200078e0060ULL, 0xfffffff846697812ULL, 0x000fc600078ee209ULL,
0x000000103e6b7824ULL, 0x000fe400078e0212ULL, 0x000001003f3e7825ULL, 0x000fc800078e0060ULL,
0x000001005b5a7825ULL, 0x000fc800078e0060ULL, 0x0000010059587825ULL, 0x000fc800078e0060ULL,
0x0000010057567825ULL, 0x000fc800078e0060ULL, 0x00000010695e7825ULL, 0x000fc800078e005eULL,
0x0000010055547825ULL, 0x000fe200078e0060ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005e6b7faeULL, 0x0003e6000b901c4cULL, 0x0000001067677824ULL, 0x000fe400078e0212ULL,
0x0000010053527825ULL, 0x000fc800078e0060ULL, 0x00000010695c7825ULL, 0x000fc800078e005cULL,
0x0000001065657824ULL, 0x000fe200078e0212ULL, 0x000000005c677faeULL, 0x0003e2000b901c4cULL,
0x0000010051507825ULL, 0x000fc800078e0060ULL, 0x00000010693e7825ULL, 0x000fc800078e003eULL,
0x0000001063637824ULL, 0x000fe200078e0212ULL, 0x000000003e657faeULL, 0x0003e2000b901c4cULL,
0x000001004f4e7825ULL, 0x000fc800078e0060ULL, 0x00000010695a7825ULL, 0x000fc800078e005aULL,
0x0000001045457824ULL, 0x000fe200078e0212ULL, 0x000000005a637faeULL, 0x0003e2000b901c4cULL,
0x000001004d4c7825ULL, 0x000fc800078e0060ULL, 0x0000001069587825ULL, 0x000fc800078e0058ULL,
0x0000001043437824ULL, 0x000fe200078e0212ULL, 0x0000000058457faeULL, 0x0003e2000b901c4cULL,
0x000001004b4a7825ULL, 0x000fc800078e0060ULL, 0x0000001069567825ULL, 0x000fc800078e0056ULL,
0x000000103d3d7824ULL, 0x000fe200078e0212ULL, 0x0000000056437faeULL, 0x0003e2000b901c4cULL,
0x0000010049487825ULL, 0x000fc800078e0060ULL, 0x0000001069547825ULL, 0x000fc800078e0054ULL,
0x000000101f1f7824ULL, 0x000fe200078e0212ULL, 0x00000000543d7faeULL, 0x0003e2000b901c4cULL,
0x0000010047467825ULL, 0x000fc800078e0060ULL, 0x0000001069527825ULL, 0x000fc800078e0052ULL,
0x000000101e1e7824ULL, 0x000fe200078e0212ULL, 0x00000000521f7faeULL, 0x0003e2000b901c4cULL,
0x0000010041407825ULL, 0x000fc800078e0060ULL, 0x0000001069507825ULL, 0x000fc800078e0050ULL,
0x000000101d1d7824ULL, 0x000fe200078e0212ULL, 0x00000000501e7faeULL, 0x0003e2000b901c4cULL,
0x000001006d607825ULL, 0x000fc800078e0060ULL, 0x00000010694e7825ULL, 0x000fc800078e004eULL,
0x000000101c1c7824ULL, 0x000fe200078e0212ULL, 0x000000004e1d7faeULL, 0x0003e2000b901c4cULL,
0x00000010694c7825ULL, 0x000fc800078e004cULL, 0x0000001017177824ULL, 0x000fe200078e0212ULL,
0x000000004c1c7faeULL, 0x0003e2000b901c4cULL, 0x00000010694a7825ULL, 0x000fc800078e004aULL,
0x0000001016167824ULL, 0x000fe200078e0212ULL, 0x000000004a177faeULL, 0x0003e2000b901c4cULL,
0x0000001069487825ULL, 0x000fc800078e0048ULL, 0x0000001015157824ULL, 0x000fe200078e0212ULL,
0x0000000048167faeULL, 0x0003e2000b901c4cULL, 0x0000001069467825ULL, 0x000fc800078e0046ULL,
0x0000001014147824ULL, 0x000fe200078e0212ULL, 0x0000000046157faeULL, 0x0003e2000b901c4cULL,
0x0000001069407825ULL, 0x000fc800078e0040ULL, 0x000000106f127824ULL, 0x000fe200078e0212ULL,
0x0000000040147faeULL, 0x0003e2000b901c4cULL, 0x0000001069607825ULL, 0x000fca00078e0060ULL,
0x0000000060127faeULL, 0x0003e4000b901c4cULL, 0x000000ff1100720cULL, 0x000fda0003f25270ULL,
0x0000000000209947ULL, 0x000fea0003800000ULL, 0x0000000400057824ULL, 0x000fe400078e0205ULL,
0xffffffffff047424ULL, 0x000fc600078e00ffULL, 0x0000000405007c0cULL, 0x000fda000bf26070ULL,
0x0000000000101947ULL, 0x000fea0003800000ULL, 0x00008c00ff147b82ULL, 0x002e620000000a00ULL,
0x000000020e117824ULL, 0x000fc800078e0205ULL, 0x0000000411147825ULL, 0x002fca00078e0014ULL,
0x0000000c14047981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002009467836ULL, 0x042fe20000000000ULL, 0xfffffff809407812ULL, 0x040fe200078ec0ffULL,
0x00002000103f7824ULL, 0x000fe200078e0213ULL, 0x0000000709487812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ec0ffULL,
0x000020003f3f7836ULL, 0x000fe20000000000ULL, 0x0000000740407812ULL, 0x000fe400078ef809ULL,
0x00000008483e7812ULL, 0x000fc400078ef809ULL, 0x0000000746467812ULL, 0x000fe200078ef809ULL,
0x000080400000791aULL, 0x000fcc0000000000ULL, 0x000000073d117812ULL, 0x000fe200078e7840ULL,
0x000000013d437836ULL, 0x000fe20000000000ULL, 0x000000073d157812ULL, 0x000fe200078e7846ULL,
0x00000008427c7824ULL, 0x000fe400078e023dULL, 0x0000000840107824ULL, 0x000fe400078e0211ULL,
0x0000000846147824ULL, 0x000fe400078e0215ULL, 0x0000001010107824ULL, 0x100fe400078e023fULL,
0x0000001014147824ULL, 0x000fc400078e023fULL, 0x000000027c7c7824ULL, 0x000fe400078e00ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x000000023d3d7836ULL, 0x000fc60000000000ULL,
0x000000001414783bULL, 0x000ea40000000200ULL, 0x000000083d00780cULL, 0x000fe40003f25270ULL,
0x00000018ff617819ULL, 0x002fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x00008880115e7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x00008880105d7816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000006100617306ULL, 0x000fe20000202400ULL,
0x00000018ff557819ULL, 0x000fc40000011412ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000888012547816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000001100787306ULL, 0x0003e20000202400ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff677819ULL, 0x004fe40000011414ULL, 0x00008880146b7816ULL, 0x000fc400000000ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011413ULL, 0x0000001000607306ULL, 0x0005e20000202400ULL,
0x0001000013117824ULL, 0x042fe200078e00ffULL, 0x00008880136f7816ULL, 0x040fe200000000ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe40000011415ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000001c007a7306ULL, 0x000fe20000202400ULL,
0x0001000012107824ULL, 0x044fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x0000888015697816ULL, 0x000fc400000000ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001100747306ULL, 0x0003e20000202400ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x00000018ff597819ULL, 0x000fe40000011416ULL,
0x00000018ff417819ULL, 0x000fe40000011417ULL, 0x0000888016657816ULL, 0x000fe200000000ffULL,
0x0000001200767306ULL, 0x0005e20000202400ULL, 0x0000000743117812ULL, 0x002fc400078e7840ULL,
0x0000000743437812ULL, 0x000fe400078e7846ULL, 0x00008880175f7816ULL, 0x000fc600000000ffULL,
0x0000001d00737306ULL, 0x0003e20000202400ULL, 0x0000000840127824ULL, 0x004fe400078e0211ULL,
0x0001000015117824ULL, 0x040fe400078e00ffULL, 0x0000001012127824ULL, 0x000fe400078e023fULL,
0x0000010015157824ULL, 0x000fe200078e00ffULL, 0x0000001000717306ULL, 0x0005e20000202400ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x00000000121c783bULL, 0x002e640000000200ULL,
0x00000018ff157819ULL, 0x000fc80000011415ULL, 0x0000001300727306ULL, 0x000fe20000202400ULL,
0x0001000014107824ULL, 0x044fe400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x00000015006a7306ULL, 0x000ff00000202400ULL, 0x00000014006e7306ULL, 0x0005f00000202400ULL,
0x0000001000707306ULL, 0x0007e20000202400ULL, 0x0000000846147824ULL, 0x004fc800078e0243ULL,
0x0000001014137824ULL, 0x000fe400078e023fULL, 0x0001000017147824ULL, 0x000fe200078e00ffULL,
0x00000011006c7306ULL, 0x000fe20000202400ULL, 0x000100001d157824ULL, 0x002fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe2000001141cULL, 0x0001000016107824ULL, 0x048fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000010016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011415ULL, 0x0000010017177824ULL, 0x000fe200078e00ffULL,
0x0000001400647306ULL, 0x0003e20000202400ULL, 0x0000007c09157211ULL, 0x000fe200078fe0ffULL,
0x000000027c7c7836ULL, 0x000fe20000000000ULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x0000000715157812ULL, 0x000fe400078e783eULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000001600667306ULL, 0x000fe20000202400ULL, 0x000100001c147824ULL, 0x042fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011410ULL, 0x000000001310783bULL, 0x000e620000000200ULL,
0x000088801c477816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001700627306ULL, 0x000fe20000202400ULL,
0x00000018ff4e7819ULL, 0x000fc4000001141dULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x000088801d4f7816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001141fULL, 0x0000001400507306ULL, 0x0005e20000202400ULL,
0x000088801f577816ULL, 0x000fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff4d7819ULL, 0x000fc4000001141eULL, 0x000088801e537816ULL, 0x000fe200000000ffULL,
0x0000005b005b7306ULL, 0x000ee20000202400ULL, 0x000000203e147824ULL, 0x004fe400078e0215ULL,
0x000100001e157824ULL, 0x000fe400078e00ffULL, 0x0000001014147824ULL, 0x000fe400078e020bULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011415ULL,
0x0000005d005d7306ULL, 0x000ea40000202400ULL, 0x000000001414783bULL, 0x000f220000000200ULL,
0x00000018ff1e7819ULL, 0x000fca000001141eULL, 0x0000001c00527306ULL, 0x0005e20000202400ULL,
0x00000018ff4b7819ULL, 0x002fe40000011410ULL, 0x00000018ff4a7819ULL, 0x000fe40000011411ULL,
0x00000018ff497819ULL, 0x000fc60000011412ULL, 0x0000001d00517306ULL, 0x0007e20000202400ULL,
0x000100001f1c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011413ULL,
0x000001001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x00005410601d7816ULL, 0x008fe4000000005bULL,
0x00000018ff1f7819ULL, 0x000fca000001141fULL, 0x0000001c005c7306ULL, 0x0005f00000202400ULL,
0x0000005500557306ULL, 0x000ee20000202400ULL, 0x000054105d1c7816ULL, 0x004fe4000000007aULL,
0x00008880105d7816ULL, 0x000fca00000000ffULL, 0x0000001c1438723cULL, 0x010fe20000041838ULL,
0x0000005400547306ULL, 0x000eac0000202400ULL, 0x00010000101d7824ULL, 0x000fe200078e00ffULL,
0x000054105e1c7816ULL, 0x002fe20000000073ULL, 0x0000001f005b7306ULL, 0x0003e20000202400ULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x0000541076557816ULL, 0x008fc40000000055ULL,
0x00000018ff607819ULL, 0x000fe4000001141dULL, 0x0000007c091d7211ULL, 0x000fe400078fe0ffULL,
0x0000006d006d7306ULL, 0x000ee20000202400ULL, 0x0000541054547816ULL, 0x004fe40000000071ULL,
0x000000071d1f7812ULL, 0x002fe400078e783eULL, 0x00005410781d7816ULL, 0x000fe40000000061ULL,
0x0000888011737816ULL, 0x000fe200000000ffULL, 0x0000006f006f7306ULL, 0x000e620000202400ULL,
0x000000541430723cULL, 0x000fe60000041830ULL, 0x000000ffff617224ULL, 0x000fc600078e0073ULL,
0x0000001c1434723cULL, 0x000fe20000041834ULL, 0x0000001e00587306ULL, 0x0005e20000202400ULL,
0x0000010011557824ULL, 0x000fca00078e00ffULL, 0x00010000111c7824ULL, 0x000fe200078e00ffULL,
0x0000541072117816ULL, 0x008fe2000000006dULL, 0x0000006b006b7306ULL, 0x000ee20000202400ULL,
0x00000018ff1e7819ULL, 0x004fe20000011410ULL, 0x000000203e107824ULL, 0x000fe200078e021fULL,
0x00000018ff717819ULL, 0x000fe2000001141cULL, 0x00010000126d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000001010107824ULL, 0x000fe400078e020bULL,
0x0000001e005e7306ULL, 0x0005e20000202400ULL, 0x00000018ff6d7819ULL, 0x000fce000001146dULL,
0x0000006700677306ULL, 0x000f220000202400ULL, 0x00000000101c783bULL, 0x0042ae0000000200ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x000054106f107816ULL, 0x002fce0000000074ULL,
0x0000006900697306ULL, 0x000e620000202400ULL, 0x00000010142c723cULL, 0x000fee000004182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005900597306ULL, 0x000fe20000202400ULL,
0x000054106b107816ULL, 0x008fc60000000070ULL, 0x000000ffff6b7224ULL, 0x000fe200078e0011ULL,
0x000054106e117816ULL, 0x010fc60000000067ULL, 0x0000006500657306ULL, 0x000fe80000202400ULL,
0x000000101428723cULL, 0x000fe80000041828ULL, 0x0000006800687306ULL, 0x000ee60000202400ULL,
0x0000541069107816ULL, 0x002fc4000000006cULL, 0x000054106a117816ULL, 0x000fc60000000063ULL,
0x0000004100417306ULL, 0x000fe80000202400ULL, 0x000000101424723cULL, 0x000fe80000041824ULL,
0x0000005f005f7306ULL, 0x000e660000202400ULL, 0x0000010012117824ULL, 0x000fe200078e00ffULL,
0x0000541065107816ULL, 0x008fc80000000068ULL, 0x00000018ff637819ULL, 0x000fe20000011411ULL,
0x0000004300437306ULL, 0x000fe20000202400ULL, 0x0000541066117816ULL, 0x000fe40000000059ULL,
0x0000888013597816ULL, 0x000fca00000000ffULL, 0x0000004700477306ULL, 0x000ee20000202400ULL,
0x000000101420723cULL, 0x000fee0000041820ULL, 0x000054105f107816ULL, 0x002fe20000000064ULL,
0x0000004d004d7306ULL, 0x000e620000202400ULL, 0x0000541062117816ULL, 0x000fe20000000041ULL,
0x000000ffff417224ULL, 0x000fcc00078e0059ULL, 0x000000101418723cULL, 0x000fe20000041818ULL,
0x0000005300537306ULL, 0x000fec0000202400ULL, 0x0001000013117824ULL, 0x000fe200078e00ffULL,
0x0000541047107816ULL, 0x008fe20000000050ULL, 0x0000005a005a7306ULL, 0x000ee60000202400ULL,
0x00000018ff157819ULL, 0x000fc40000011411ULL, 0x0000541052117816ULL, 0x000fc60000000043ULL,
0x0000004b004b7306ULL, 0x000fe80000202400ULL, 0x000000101c38723cULL, 0x004fe80000041838ULL,
0x0000005d005d7306ULL, 0x000fe60000202400ULL, 0x0000010013107824ULL, 0x000fe200078e00ffULL,
0x0000541058117816ULL, 0x002fc8000000004dULL, 0x0000006000607306ULL, 0x000e620000202400ULL,
0x00000018ff167819ULL, 0x000fe40000011410ULL, 0x0000541053107816ULL, 0x008fca000000005aULL,
0x0000004e004e7306ULL, 0x000ea40000202400ULL, 0x000000101c30723cULL, 0x000fec0000041830ULL,
0x0000004c004c7306ULL, 0x000ee20000202400ULL, 0x000054105d107816ULL, 0x002fe40000000060ULL,
0x000054105e117816ULL, 0x000fc4000000004bULL, 0x0000541051517816ULL, 0x004fc6000000004eULL,
0x0000004a004a7306ULL, 0x000fe40000202400ULL, 0x000000101c28723cULL, 0x000fe20000041828ULL,
0x000054105b5b7816ULL, 0x008fca000000004cULL, 0x0000004900497306ULL, 0x000ff00000202400ULL,
0x0000004500457306ULL, 0x000ff00000202400ULL, 0x0000004f004f7306ULL, 0x000ff00000202400ULL,
0x0000005600567306ULL, 0x000e700000202400ULL, 0x0000005700577306ULL, 0x000ea20000202400ULL,
0x000054104f507816ULL, 0x002fce0000000056ULL, 0x0000006100617306ULL, 0x000fe20000202400ULL,
0x000000501c34723cULL, 0x000fe20000041834ULL, 0x00005410575a7816ULL, 0x004fcc000000005cULL,
0x0000007100547306ULL, 0x000e620000202400ULL, 0x0000005a1c2c723cULL, 0x000fee000004182cULL,
0x0000005500557306ULL, 0x000ea20000202400ULL, 0x0000541061547816ULL, 0x002fce0000000054ULL,
0x0000006b00677306ULL, 0x000fe20000202400ULL, 0x0000541055557816ULL, 0x004fce000000004aULL,
0x0000006d00127306ULL, 0x000e620000202400ULL, 0x000000541c24723cULL, 0x000fee0000041824ULL,
0x0000006300667306ULL, 0x000ea20000202400ULL, 0x0000541067107816ULL, 0x002fce0000000012ULL,
0x0000004100147306ULL, 0x000fe20000202400ULL, 0x0000541066117816ULL, 0x004fce0000000049ULL,
0x0000001500137306ULL, 0x000e620000202400ULL, 0x000000101c20723cULL, 0x000fee0000041820ULL,
0x0000001600167306ULL, 0x000ea20000202400ULL, 0x0000541014147816ULL, 0x002fe40000000013ULL,
0x0000541016157816ULL, 0x004fce0000000045ULL, 0x000000141c18723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c1947ULL, 0x000fde000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0xffffffd800008947ULL, 0x000fec000383ffffULL,
0x0000ffff0d107812ULL, 0x000fe200078ec0ffULL, 0x0000000820167220ULL, 0x080fe20000410000ULL,
0x0000008002207824ULL, 0x000fe400078e020bULL, 0x0000000824147220ULL, 0x080fe20000410000ULL,
0x0000888010137816ULL, 0x000fe200000000ffULL, 0x0000000409107824ULL, 0x000fe400078e00ffULL,
0x0000000821177220ULL, 0x080fe20000410000ULL, 0x0000000838157220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x8000000013137824ULL, 0x000fe200078e00ffULL,
0xfffffff010117812ULL, 0x000fe200078ec0ffULL, 0x000000083a3a7220ULL, 0x080fe20000410000ULL,
0x000000083b3b7220ULL, 0x080fe20000410000ULL, 0x01c610130a0075a7ULL, 0x000e62000800017fULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000836367220ULL, 0x080fe20000410000ULL, 0x0000000837377220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000832327220ULL, 0x080fe20000410000ULL, 0x0000000833337220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x000000082e2e7220ULL, 0x080fe20000410000ULL, 0x000000082f2f7220ULL, 0x080fe20000410000ULL,
0x0000000828287220ULL, 0x080fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000082a2a7220ULL, 0x080fe20000410000ULL, 0x000000082b2b7220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000826267220ULL, 0x080fe20000410000ULL,
0x0000000827277220ULL, 0x080fe20000410000ULL, 0x0000000822227220ULL, 0x080fe20000410000ULL,
0x0000000823237220ULL, 0x000fe20000410000ULL, 0x0000000120207824ULL, 0x000fc400078e0211ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x000000081a247220ULL, 0x080fe20000410000ULL, 0x000000081b217220ULL, 0x000fe20000410000ULL,
0x0000001400fc8947ULL, 0x002fec0003800000ULL, 0x01c4000020107984ULL, 0x0002a20000000c00ULL,
0x0000000703007c0cULL, 0x000fda000bf05270ULL, 0x0000000400080947ULL, 0x002fea0003800000ULL,
0x00000002091a7824ULL, 0x000fe200078e00ffULL, 0x0000000b0f0f7c10ULL, 0x000fc8000fffe1ffULL,
0x000000061a1a7812ULL, 0x000fc800078ec0ffULL, 0x000000011a1c7812ULL, 0x040fe400078efcffULL,
0x000000081a1e7812ULL, 0x000fe400078efcffULL, 0x0000000f1c00720cULL, 0x080fe40003f26070ULL,
0x000000101a1c7812ULL, 0x000fe400078efcffULL, 0x0000000f1e00720cULL, 0x080fe40003f06070ULL,
0x0000000f1c00720cULL, 0x000fc40003fc6070ULL, 0x000000111a1e7812ULL, 0x040fe400078efcffULL,
0x000000181a1c7812ULL, 0x040fe400078efcffULL, 0x0000000f1a00720cULL, 0x080fe40003f46070ULL,
0x0000000f1e00720cULL, 0x080fe40003fa6070ULL, 0x0000000f1c00720cULL, 0x000fe40003f66070ULL,
0x000000091a387812ULL, 0x000fc400078efcffULL, 0x000000191a1e7812ULL, 0x040fe400078efcffULL,
0x000000201a1c7812ULL, 0x000fe400078efcffULL, 0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL,
0xff7fffff39397808ULL, 0x000fc40004800000ULL, 0x0000000f3800720cULL, 0x080fe40003f86070ULL,
0x0000000f1e00720cULL, 0x080fe40003f46070ULL, 0x0000000f1c00720cULL, 0x000fe40003f26070ULL,
0x000000211a1e7812ULL, 0x040fe400078efcffULL, 0x000000281a1c7812ULL, 0x000fe400078efcffULL,
0xff7fffff36367808ULL, 0x000fc40004000000ULL, 0xff7fffff34347808ULL, 0x000fe40004000000ULL,
0xff7fffff37377808ULL, 0x000fe40006000000ULL, 0xff7fffff35357808ULL, 0x000fe40006000000ULL,
0x0000000f1e00720cULL, 0x080fe40003f06070ULL, 0x0000000f1c00720cULL, 0x000fe40003f86070ULL,
0x000000291a1e7812ULL, 0x000fc400078efcffULL, 0x000000301a1c7812ULL, 0x000fe400078efcffULL,
0xff7fffff32327808ULL, 0x000fe40007000000ULL, 0xff7fffff30307808ULL, 0x000fe40007000000ULL,
0xff7fffff33337808ULL, 0x000fe40006800000ULL, 0xff7fffff31317808ULL, 0x000fe40006800000ULL,
0x0000000f1e00720cULL, 0x000fc40003fc6070ULL, 0x0000000f1c00720cULL, 0x000fe40003fa6070ULL,
0x000000311a1e7812ULL, 0x040fe400078efcffULL, 0x000000381a1c7812ULL, 0x040fe400078efcffULL,
0x000000391a1a7812ULL, 0x000fe400078efcffULL, 0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL,
0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff28287808ULL, 0x000fe40004800000ULL, 0x0000000f1e00720cULL, 0x080fe40003f66070ULL,
0x0000000f1c00720cULL, 0x000fc40003f46070ULL, 0x0000000f1a00720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff29297808ULL, 0x000fe40004000000ULL,
0xff7fffff26267808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff27277808ULL, 0x000fc40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40007000000ULL,
0xff7fffff22227808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff23237808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff24247808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fce0004800000ULL,
0x0000001510107209ULL, 0x004fe20007810000ULL, 0xffffffff00087882ULL, 0x000fe20000000000ULL,
0x0000003a111a7209ULL, 0x000fe40007810000ULL, 0x00000039100f7209ULL, 0x000fe40007810000ULL,
0x0000003b1a117209ULL, 0x000fe40007810000ULL, 0x000000340f107209ULL, 0x000fe40007810000ULL,
0x00000036111a7209ULL, 0x000fc40007810000ULL, 0x00000035100f7209ULL, 0x000fe40007810000ULL,
0x000000371a117209ULL, 0x000fe40007810000ULL, 0x000000300f107209ULL, 0x000fe40007810000ULL,
0x00000032111a7209ULL, 0x000fe40007810000ULL, 0x00000031100f7209ULL, 0x000fe40007810000ULL,
0x000000331a117209ULL, 0x000fc40007810000ULL, 0x0000002c0f107209ULL, 0x000fe40007810000ULL,
0x0000002e111a7209ULL, 0x000fe40007810000ULL, 0x0000002d100f7209ULL, 0x000fe40007810000ULL,
0x0000002f1a117209ULL, 0x000fe40007810000ULL, 0x000000280f107209ULL, 0x000fe40007810000ULL,
0x0000002a111a7209ULL, 0x000fc40007810000ULL, 0x00000029100f7209ULL, 0x000fe40007810000ULL,
0x0000002b1a117209ULL, 0x000fe40007810000ULL, 0x000000140f107209ULL, 0x000fe40007810000ULL,
0x00000026111a7209ULL, 0x000fe40007810000ULL, 0x00000025100f7209ULL, 0x000fe40007810000ULL,
0x000000271a117209ULL, 0x000fc40007810000ULL, 0x000000160f107209ULL, 0x000fe40007810000ULL,
0x00000022111a7209ULL, 0x000fe40007810000ULL, 0x00000017100f7209ULL, 0x000fe40007810000ULL,
0x000000231a117209ULL, 0x000fe40007810000ULL, 0x000000ff0dff7812ULL, 0x000fe4000780c0ffULL,
0x000000180f107209ULL, 0x000fc40007810000ULL, 0x00000024111a7209ULL, 0x000fe40007810000ULL,
0x00000001ff0d7807ULL, 0x000fe40000000000ULL, 0x0000001910107209ULL, 0x000fe40007810000ULL,
0x000000211a1a7209ULL, 0x000fe20007810000ULL, 0x0000001208787947ULL, 0x000fec000b800000ULL,
0x0c401f00100f7f89ULL, 0x000e6800000e0000ULL, 0x0c401f001a117f89ULL, 0x000ea800000e0000ULL,
0x0c401f00121d7f89ULL, 0x000ee800000e0000ULL, 0x0c401f00131e7f89ULL, 0x000f2200000e0000ULL,
0x0000000f101b7209ULL, 0x002fc40007810000ULL, 0x000000111a1c7209ULL, 0x004fc60007810000ULL,
0x0c201f001b3c7f89ULL, 0x000e6200000e0000ULL, 0x0000001d121d7209ULL, 0x008fc60007810000ULL,
0x0c201f001c117f89ULL, 0x000ea200000e0000ULL, 0x0000001e130f7209ULL, 0x010fc60007810000ULL,
0x0c201f001d3e7f89ULL, 0x000ee800000e0000ULL, 0x0c201f000f387f89ULL, 0x00092200000e0000ULL,
0x0000003c1b107209ULL, 0x002fe40007810000ULL, 0x000000111c117209ULL, 0x004fe40007810000ULL,
0x0000003e1d127209ULL, 0x008fce0007810000ULL, 0x3fb8aa3b101a7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b11417820ULL, 0x000fe20000410000ULL, 0x3f80000000087882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b39397823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010841ULL,
0x0000001500157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001081aULL,
0x00000039001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b25257823ULL, 0x000fe2000001081aULL,
0x0000001700407308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b21217823ULL, 0x000fe20000010841ULL,
0x00000018003f7308ULL, 0x000ff00000000800ULL, 0x0000003400347308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000ff00000000800ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003b003b7308ULL, 0x000ff00000000800ULL, 0x0000003600177308ULL, 0x000ff00000000800ULL,
0x0000003700187308ULL, 0x000e700000000800ULL, 0x0000002c00137308ULL, 0x0005e20000000800ULL,
0x000000171817723eULL, 0x002fce00000010ffULL, 0x0000001400397308ULL, 0x0003e20000000800ULL,
0x00000008ff2c7e24ULL, 0x004fca000f8e00ffULL, 0x3f8000002c2c783eULL, 0x000fe400000010ffULL,
0x0000002d003c7308ULL, 0x0004e20000000800ULL, 0x000000151c14723eULL, 0x002fe400000010ffULL,
0x0000003a3b15723eULL, 0x000fca00000010ffULL, 0x00000016003d7308ULL, 0x0002620000000800ULL,
0x000000ffff2d7224ULL, 0x004fe200078e002cULL, 0x000000133c1a723eULL, 0x008fcc00000010ffULL,
0x0000001900427308ULL, 0x000fe20000000800ULL, 0x000000343516723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b24137823ULL, 0x000fe20000010841ULL, 0x0000003d4024723eULL, 0x010fe200000010ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000002c141c723cULL, 0x000fe200000418ffULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000e700000000800ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x000000303118723eULL, 0x002fce00000010ffULL,
0x0000003300197308ULL, 0x000e700000000800ULL, 0x0000002e001b7308ULL, 0x000fe20000000800ULL,
0x000000321919723eULL, 0x002fce00000010ffULL, 0x0000002f00347308ULL, 0x000e700000000800ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000001b341b723eULL, 0x002fce00000010ffULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x0000002c181c723cULL, 0x000fee000004181cULL,
0x00000025003e7308ULL, 0x000ea20000000800ULL, 0x000000282928723eULL, 0x002fce00000010ffULL,
0x0000002a00257308ULL, 0x0005f00000000800ULL, 0x0000002b00367308ULL, 0x000e620000000800ULL,
0x000000393e2a723eULL, 0x004fce00000010ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000253629723eULL, 0x002fce00000010ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x00000026272b723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000003f4226723eULL, 0x000fe200000010ffULL,
0x0000002c281c723cULL, 0x000fec000004181cULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x000000222325723eULL, 0x002fce00000010ffULL, 0x00000021002e7308ULL, 0x000e640000000800ULL,
0x000000132e27723eULL, 0x002fe400000010ffULL, 0xfffffffc09137812ULL, 0x000fcc00078ec0ffULL,
0x0000002c242c723cULL, 0x000fee000004181cULL, 0x0000000fff1c7424ULL, 0x000fca00078e00ffULL,
0x000000131c237219ULL, 0x000fe400000006ffULL, 0x000000380f137209ULL, 0x000fd20007810000ULL,
0x001c1fff2c1c7589ULL, 0x00026200000e0000ULL, 0x0000000000227806ULL, 0x000fe200038e0100ULL,
0x00000000231e73a1ULL, 0x000eb000000e8000ULL, 0x00000000230873c4ULL, 0x000ee20000004000ULL,
0x0000000000097886ULL, 0x000fc400038e0100ULL, 0x0000000923ff7c12ULL, 0x004fda000f80401eULL,
0x0000000e08848947ULL, 0x00afea000b800000ULL, 0x001c1fff2e1d7589ULL, 0x0002a800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x000ee800000e0000ULL, 0x001c1fff001f7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff487812ULL, 0x000fe200078ee248ULL, 0x0000080002237824ULL, 0x002fe200078e020bULL,
0x00000003442c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0014ULL,
0x0000000309ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000848217836ULL, 0x000fe20000000000ULL,
0x000000042c2e7812ULL, 0x000fe200078efcffULL, 0x00000008480f7824ULL, 0x000fe200078e00ffULL,
0x000000072c227812ULL, 0x000fe200078e7848ULL, 0x0001200023237836ULL, 0x000fe20000000000ULL,
0x000000072e487812ULL, 0x000fe200078e7848ULL, 0x000000ffff317224ULL, 0x000fe200078e0016ULL,
0x000000072c2c7812ULL, 0x000fe200078e7821ULL, 0x000000ffff327224ULL, 0x000fe200078e0018ULL,
0x000000072e2e7812ULL, 0x000fe200078e7821ULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x0000000f22227212ULL, 0x080fe200078efcffULL, 0x000000ffff337224ULL, 0x000fe200078e001aULL,
0x0000000f48487212ULL, 0x000fe200078efcffULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x000000212c2c7212ULL, 0x080fe200078efcffULL, 0x0000001022227824ULL, 0x100fe200078e0223ULL,
0x000000212e2e7212ULL, 0x000fe200078efcffULL, 0x0000001048487824ULL, 0x000fc400078e0223ULL,
0x000000ffff347224ULL, 0x000fe200078e0028ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000003022007844ULL, 0x0003e20000000200ULL, 0x000000ffff357224ULL, 0x000fe400078e002aULL,
0x000000ffff367224ULL, 0x000fe400078e0024ULL, 0x000000ffff377224ULL, 0x000fc400078e0026ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000102c2c7824ULL, 0x000fe200078e0223ULL,
0x0000003448007844ULL, 0x0003e20000000200ULL, 0x000000ffff167224ULL, 0x000fe400078e0019ULL,
0x000000ffff177224ULL, 0x000fe400078e001bULL, 0x000000102e2e7824ULL, 0x000fe400078e0223ULL,
0x000000ffff187224ULL, 0x000fe200078e0029ULL, 0x000000142c007844ULL, 0x0003e20000000200ULL,
0x000000ffff197224ULL, 0x000fc400078e002bULL, 0x000000ffff1a7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0027ULL, 0x0000000100037824ULL, 0x000fe400078e0203ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x000000182e007844ULL, 0x0003e80000000200ULL,
0x01c0001020008388ULL, 0x0003e80000000c00ULL, 0x01c2001c20008388ULL, 0x01c3e20000000c00ULL,
0x0000000503007c0cULL, 0x000fe2000bf06070ULL, 0x01c6080f0aff79a7ULL, 0x0003d8000850003fULL,
0xffffffc000c08947ULL, 0x022fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff297224ULL, 0x000fce00078e0028ULL, 0x01c65829050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c65829050085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xfffffecc00a07947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x100fe400078e001cULL,
0x000000ffff0f7224ULL, 0x000fce00078e001cULL, 0x01c6080f050075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x01c6080f0500a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xfffffed400547947ULL, 0x020fea000383ffffULL, 0x000000ffff0e7224ULL, 0x100fe400078e0012ULL,
0x000000ffff0f7224ULL, 0x000fce00078e0012ULL, 0x0000000f1d0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0000000f1d0085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xfffffed800507947ULL, 0x020fea000383ffffULL, 0x000000ffff127224ULL, 0x100fe400078e002eULL,
0x000000ffff137224ULL, 0x000fce00078e002eULL, 0x01c65813050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c65813050085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xfffffef800ec7947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x110fe400078e001eULL,
0x000000ffff117224ULL, 0x000fce00078e001eULL, 0x01c61811050075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x01c618110500a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xfffffefc00bc7947ULL, 0x020fea000383ffffULL, 0x000000ffff107224ULL, 0x100fe400078e001cULL,
0x000000ffff117224ULL, 0x000fce00078e001cULL, 0x01c64811130075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c64811130085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff0000a47947ULL, 0x020fea000383ffffULL, 0x0000000aff1c7e24ULL, 0x000fe4000f8e00ffULL,
0x0000000aff1d7e24ULL, 0x000fce000f8e00ffULL, 0x01c6581d050075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x01c6581d0500a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff20004c7947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x102fe400078e001eULL,
0x000000ffff117224ULL, 0x000fce00078e001eULL, 0x01c62811050075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x01c628110500a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff2400447947ULL, 0x020fea000383ffffULL, 0x000000ffff107224ULL, 0x100fe400078e001cULL,
0x000000ffff117224ULL, 0x000fce00078e001cULL, 0x01c64811130075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x01c64811130095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff2800247947ULL, 0x020fea000383ffffULL, 0x000000ffff2f7224ULL, 0x000fce00078e002eULL,
0x01c6582f050075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c6582f050095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff4400f07947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x108fe400078e005aULL, 0x000000ffff117224ULL, 0x000fce00078e005aULL,
0x01c63811050075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01c638110500a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff4800c47947ULL, 0x020fea000383ffffULL,
0x000000ffff107224ULL, 0x100fe400078e0013ULL, 0x000000ffff117224ULL, 0x000fce00078e0013ULL,
0x01c648115c0075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c648115c0095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff4c009c7947ULL, 0x020fea000383ffffULL,
0x01c600ff0b0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c600ff0b0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffb8004c7947ULL, 0x000fea000383ffffULL,
0x80000000ff0c7424ULL, 0x000fe400078e00ffULL, 0x80000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x01c6000d0b0075a7ULL, 0x0004a2000800017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c6000d0b0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e48947ULL, 0x002fea000383ffffULL, 0xffffffb800ec7947ULL, 0x002fea000383ffffULL,
0x000000ffff107224ULL, 0x100fe400078e0013ULL, 0x000000ffff117224ULL, 0x000fce00078e0013ULL,
0x01c610110a0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c610110a0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffe400e47947ULL, 0x020fea000383ffffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe400078e0010ULL,
0x00000002ff3d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fce00078e00ffULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0006e40000000042ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff407224ULL, 0x002fe400078e001aULL,
0x00000002ff3d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x004fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003d40387389ULL, 0x0002640000000042ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000f101b7209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003d40387389ULL, 0x0002640000000042ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000111a1c7209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e0013ULL, 0x000000ffff1d7224ULL, 0x000fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003d40387389ULL, 0x0002640000000042ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001d121d7209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e001bULL, 0x00000001ff3d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0002640000000042ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001e130f7209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e001cULL,
0x000000ffff3c7224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0002640000000042ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000003c1b107209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e001dULL,
0x000000ffff117224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0002640000000042ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000111c117209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e000fULL,
0x000000ffff3e7224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0002640000000042ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000003e1d127209ULL, 0x000fe20007810000ULL, 0xffffffe800e47947ULL, 0x020fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e1f7389ULL, 0x0006e40000000022ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1d7224ULL, 0x004fe400078e001fULL,
0x000000ffff2e7224ULL, 0x002fe400078e001eULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e1f7389ULL, 0x0006e40000000022ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x004fe400078e001fULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e1f7389ULL, 0x0006e40000000022ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff000147947ULL, 0x026fea000383ffffULL, 0x018000003e067836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000006077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000003e00068308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff067807ULL, 0x004fc80004000000ULL, 0x0000000607ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff3eff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff067807ULL, 0x000fc80000000000ULL, 0x0000000607ff7212ULL, 0x000fe4000780c0ffULL,
0x800000003e077812ULL, 0x000fd600078ec0ffULL, 0x0080000007060812ULL, 0x000fe200078efcffULL,
0x000000ffff068224ULL, 0x000fe200078e0007ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000003e00067308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x00cfe400078e0006ULL, 0x000000ffff067224ULL, 0x000fe400078e000cULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffffea806387950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x0000000000000100ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000638ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000680ULL, 0x00000000000006a8ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d28ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d48ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d48ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d78ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000dc0ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000015800ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016600ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000016610ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016610ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000016610ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000016cf8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016cf8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000dc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000015800ULL, 0x0000000000015800ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000016600ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016610ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_90_cubin_len = 93768;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
