/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001f490ULL, 0x000000000001f010ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000001d9e0ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x000000000001db50ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000001db90ULL, 0x00000000000000f0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000001dc80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001d9e000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0075d40400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001d9e000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080980828808081ULL, 0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001db5000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9e08288080980828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809e920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x0001db9000000000ULL,
0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000f2ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0001cbc000183104ULL, 0x0001ce100001ce00ULL, 0x0001cf900001cf80ULL,
0x010829040001cfa0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001d0500001dULL, 0x0500001d0500001dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000c001082804ULL, 0x00001740000000f0ULL,
0x00001860000017e0ULL, 0x00002e5000001880ULL, 0x00004eb000003030ULL, 0x0000657000004ef0ULL,
0x00006660000065f0ULL, 0x00007ca000006690ULL, 0x00009bc000007cf0ULL, 0x0000b0f000009bf0ULL,
0x0000b1e00000b170ULL, 0x0000c6900000b210ULL, 0x0000e7400000c6b0ULL, 0x0000fc500000e770ULL,
0x0000fd600000fce0ULL, 0x000113800000fd90ULL, 0x00012e30000113f0ULL, 0x000143b000012ef0ULL,
0x00014b40000143c0ULL, 0x00016ac0000168d0ULL, 0x00016fe000016fa0ULL, 0x0001c82000017810ULL,
0x0001c8600001c850ULL, 0x0001c8900001c870ULL, 0x0001c8d00001c8b0ULL, 0x0001cf700001c8e0ULL,
0x0001cfe00001cfd0ULL, 0x0001d6100001cff0ULL, 0x0001d6c00001d670ULL, 0x0001d7600001d710ULL,
0x0001d8000001d7b0ULL, 0x0001d8b00001d850ULL, 0x0001d9700001d920ULL, 0x05e039040001d9c0ULL,
0x000000ff00000170ULL, 0x003f010000010600ULL, 0x0000000f000001a0ULL, 0x003f013000010608ULL,
0x0000000f000001d0ULL, 0x003f013000010610ULL, 0x0000000f00000230ULL, 0x003f012000010648ULL,
0x000000ff00000240ULL, 0x003f010000010658ULL, 0x000000ff000005a0ULL, 0x003f010700010600ULL,
0x0000000000000770ULL, 0x003f010200000004ULL, 0x0000000000000880ULL, 0x003f010100000000ULL,
0x000000ff00000ce0ULL, 0x003f010700010648ULL, 0x000000ff00000d60ULL, 0x003f010100010658ULL,
0x000000ff00000ed0ULL, 0x003f01060001065cULL, 0x000000ff00000f30ULL, 0x003f01060001065cULL,
0x000000ff00000fb0ULL, 0x003f01060001065cULL, 0x000000ff000014f0ULL, 0x003f010700010650ULL,
0x000000ff00001560ULL, 0x003f01060001064cULL, 0x000000ff00001580ULL, 0x003f01060001060cULL,
0x000000ff00001680ULL, 0x003f01060001060cULL, 0x000000ff00001ae0ULL, 0x003f01060001064cULL,
0x000000ff00001b80ULL, 0x003f01060001064cULL, 0x000000ff00003b00ULL, 0x003f010100010658ULL,
0x000000ff00003b10ULL, 0x003f01060001065cULL, 0x000000ff00003b50ULL, 0x003f01060001065cULL,
0x000000ff00003bd0ULL, 0x003f01060001065cULL, 0x000000ff00003e90ULL, 0x003f010700010648ULL,
0x000000ff00003f00ULL, 0x003f010600010654ULL, 0x000000ff00003f70ULL, 0x003f010600010654ULL,
0x000000ff00004010ULL, 0x003f010600010654ULL, 0x000000ff00005e60ULL, 0x003f010100010658ULL,
0x000000ff00005ed0ULL, 0x003f010100010610ULL, 0x000000ff00005f20ULL, 0x003f01060001065cULL,
0x000000ff00005f60ULL, 0x003f01060001065cULL, 0x000000ff00005fe0ULL, 0x003f01060001065cULL,
0x000000ff00006380ULL, 0x003f010700010650ULL, 0x000000ff000063f0ULL, 0x003f01060001064cULL,
0x000000ff00006410ULL, 0x003f01060001061cULL, 0x000000ff000064f0ULL, 0x003f01060001061cULL,
0x000000ff00006900ULL, 0x003f01060001064cULL, 0x000000ff000069a0ULL, 0x003f01060001064cULL,
0x000000ff000087b0ULL, 0x003f010100010658ULL, 0x000000ff000087c0ULL, 0x003f01060001065cULL,
0x000000ff00008800ULL, 0x003f01060001065cULL, 0x000000ff00008880ULL, 0x003f01060001065cULL,
0x000000ff00008b00ULL, 0x003f010700010648ULL, 0x000000ff00008b70ULL, 0x003f010600010654ULL,
0x000000ff00008bc0ULL, 0x003f010600010654ULL, 0x000000ff00008c50ULL, 0x003f010600010654ULL,
0x000000ff0000aa20ULL, 0x003f010100010658ULL, 0x000000ff0000aa90ULL, 0x003f010100010620ULL,
0x000000ff0000aae0ULL, 0x003f01060001065cULL, 0x000000ff0000ab20ULL, 0x003f01060001065cULL,
0x000000ff0000aba0ULL, 0x003f01060001065cULL, 0x000000ff0000af00ULL, 0x003f010700010650ULL,
0x000000ff0000af70ULL, 0x003f01060001064cULL, 0x000000ff0000af90ULL, 0x003f01060001062cULL,
0x000000ff0000b070ULL, 0x003f01060001062cULL, 0x000000ff0000b480ULL, 0x003f01060001064cULL,
0x000000ff0000b520ULL, 0x003f01060001064cULL, 0x000000ff0000d330ULL, 0x003f010100010658ULL,
0x000000ff0000d340ULL, 0x003f01060001065cULL, 0x000000ff0000d380ULL, 0x003f01060001065cULL,
0x000000ff0000d400ULL, 0x003f01060001065cULL, 0x000000ff0000d680ULL, 0x003f010700010648ULL,
0x000000ff0000d6f0ULL, 0x003f010600010654ULL, 0x000000ff0000d740ULL, 0x003f010600010654ULL,
0x000000ff0000d7d0ULL, 0x003f010600010654ULL, 0x000000ff0000f5a0ULL, 0x003f010100010658ULL,
0x000000ff0000f610ULL, 0x003f010100010630ULL, 0x000000ff0000f660ULL, 0x003f01060001065cULL,
0x000000ff0000f6a0ULL, 0x003f01060001065cULL, 0x000000ff0000f720ULL, 0x003f01060001065cULL,
0x000000ff0000fa80ULL, 0x003f010700010650ULL, 0x000000ff0000faf0ULL, 0x003f01060001064cULL,
0x000000ff0000fb10ULL, 0x003f01060001063cULL, 0x000000ff0000fbd0ULL, 0x003f01060001063cULL,
0x000000ff0000ffe0ULL, 0x003f01060001064cULL, 0x000000ff00010080ULL, 0x003f01060001064cULL,
0x000000ff00011e80ULL, 0x003f010100010658ULL, 0x000000ff00011e90ULL, 0x003f01060001065cULL,
0x000000ff00011ed0ULL, 0x003f01060001065cULL, 0x000000ff00011f50ULL, 0x003f01060001065cULL,
0x000000ff00012200ULL, 0x003f010700010648ULL, 0x000000ff00012270ULL, 0x003f010600010654ULL,
0x000000ff000122c0ULL, 0x003f010600010654ULL, 0x000000ff00012350ULL, 0x003f010600010654ULL,
0x000000ff00014140ULL, 0x003f010100010658ULL, 0x000000ff000141a0ULL, 0x003f010100010640ULL,
0x000000ff00018990ULL, 0x003f010600010604ULL, 0x000000ff00018a20ULL, 0x003f010600010604ULL,
0x000000ff00018d50ULL, 0x003f010100010600ULL, 0x000000ff00018d60ULL, 0x003f010600010604ULL,
0x000000ff00018de0ULL, 0x003f010600010604ULL, 0x0000003d0001bc30ULL, 0x003f010600010614ULL,
0x0000003d0001c100ULL, 0x003f010600010614ULL, 0x0000003d0001d570ULL, 0x003f010100010608ULL,
0x00101c0400053803ULL, 0x00018e3000017c70ULL, 0x0001d5d000018f00ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000001c4ULL, 0x0000001100000002ULL, 0x0000000000000144ULL,
0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL,
0x0000001100000002ULL, 0x000000000000019aULL, 0x0000001100000002ULL, 0x000000000000011dULL,
0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff177424ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ea20000002600ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x00005800ff2a7624ULL, 0x000fc600078e00ffULL, 0x0000000000097919ULL, 0x000ee80000002100ULL,
0x00000000003e7919ULL, 0x000f220000002700ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x108fe200078e0209ULL, 0x00000005ff5a7819ULL, 0x000fe20000011609ULL,
0x00001fff08007589ULL, 0x00086600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe20003f04070ULL, 0x00001fff5a5a7589ULL, 0x000ee200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe20003f24070ULL, 0x000062003e087625ULL, 0x010fe200078e0017ULL,
0x000000010f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01060002ff00b388ULL, 0x0009e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x010608040f008388ULL, 0x0009e2000000ca00ULL, 0xff317217ff0e9424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff0aa424ULL, 0x000fe200078e00ffULL, 0x010610060f008388ULL, 0x0009e2000000ca00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff0ba424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0cb424ULL, 0x000fe200078e00ffULL, 0x0104000e0f009388ULL, 0x0009e20000004800ULL,
0x7fffff80ff0db424ULL, 0x000fc600078e00ffULL, 0x0106480a0f00a388ULL, 0x0009e80000008a00ULL,
0x0106580cff00b388ULL, 0x0009e80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003a000000947ULL, 0x004fea0003800000ULL, 0x00000000000f7919ULL, 0x018e620000000000ULL,
0x000000045a027824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x000000102a037824ULL, 0x000fc400078e00ffULL, 0x00000200ff157424ULL, 0x000fc600078e00ffULL,
0x0000000503047e24ULL, 0x000fe2000f8e023eULL, 0x000000020f057211ULL, 0x042fe200078fd8ffULL,
0x000000100f027824ULL, 0x000fc600078e00ffULL, 0x0000000705037812ULL, 0x040fe400078ec0ffULL,
0x000001f002137812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x000fe200078e0205ULL,
0x00000002050d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03067812ULL, 0x000fe200078e780fULL,
0x00005c0002027625ULL, 0x000fe200078e0015ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0000000305117810ULL, 0x040fe20007ffe0ffULL, 0x00000020050c7824ULL, 0x000fe200078e0206ULL,
0x000000070d0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x040fe200078e0207ULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x0000000104127824ULL, 0x000fe200078e0211ULL,
0x00000007110b7812ULL, 0x000fc400078ec0ffULL, 0x0000001f0a107812ULL, 0x100fe400078e780fULL,
0x00000013020a7210ULL, 0x000fe40007f1e0ffULL, 0x0000001f06067812ULL, 0x100fe200078e780fULL,
0x000000200d107824ULL, 0x000fe200078e0210ULL, 0x0000001f0b147812ULL, 0x000fe200078e780fULL,
0x00000001040f7824ULL, 0x000fe400078e020dULL, 0x000000ffff0b7224ULL, 0x000fe400000e0603ULL,
0x00005c0005027625ULL, 0x000fc800078e0015ULL, 0x00000020070e7824ULL, 0x000fe200078e0206ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x00005c000f047625ULL, 0x000fc800078e0015ULL,
0x00005c0012067625ULL, 0x000fe200078e0015ULL, 0x0000001304047210ULL, 0x000fc60007f3e0ffULL,
0x0000002011147824ULL, 0x000fe200078e0214ULL, 0x0000001306067210ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001010117824ULL, 0x000fe200078e00ffULL, 0x00000000020f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400010e0607ULL, 0x0000001014137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000608597981ULL, 0x018ea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000005ff5b7e24ULL, 0x008fe2000f8e00ffULL, 0x0000003f59587810ULL, 0x004fc40007ffe0ffULL,
0x000000ff592e7810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff587819ULL, 0x000fe40000011658ULL,
0x00000008ff2e7819ULL, 0x000fca000001162eULL, 0x000175e000008947ULL, 0x000fea0003800000ULL,
0x000000045b2f7824ULL, 0x000fe200078e00ffULL, 0x000106105a007811ULL, 0x000fe200078e20ffULL,
0x00000003ff057424ULL, 0x002fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe200078e00ffULL,
0x000000582f00720cULL, 0x000fda0003f06070ULL, 0x000064002f038a10ULL, 0x000fe20007ffe0ffULL,
0x000000023e028824ULL, 0x000fc800078e00ffULL, 0x0000640002028a24ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040500ff738cULL, 0x0003e20000000000ULL,
0x0000600002028625ULL, 0x000fe200078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006022d8981ULL, 0x0004e2000c1e1900ULL, 0x000001005b047824ULL, 0x040fe200078e00ffULL,
0x000000015b057810ULL, 0x002fe20007ffe0ffULL, 0x000000085a2c7824ULL, 0x000fe200078e00ffULL,
0x00000000002b7919ULL, 0x000e620000000000ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000000459077217ULL, 0x000fe20007800000ULL, 0x000000402a2a7824ULL, 0x000fe200078e00ffULL,
0x0000002e0500720cULL, 0x000fe20003f06070ULL, 0x00000100ff127424ULL, 0x000fe200078e00ffULL,
0x0000000000ff7f8cULL, 0x0009e2000c80043fULL, 0x0000000107077824ULL, 0x000fe200078e0a04ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0xff317217ff297424ULL, 0x000fe200078e00ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000002007077807ULL, 0x000fe20000000000ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000002c07077217ULL, 0x000fe20007800000ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x000000ffff457224ULL, 0x000fc400078e00ffULL,
0x0000000107077824ULL, 0x000fe200078e0a2cULL, 0x00000004ff047819ULL, 0x002fe2000001162bULL,
0x000000102b0b7824ULL, 0x000fc600078e00ffULL, 0x0000000204057810ULL, 0x000fe20007ffe0ffULL,
0x000000012c037824ULL, 0x004fe200078e0204ULL, 0x0000000404067810ULL, 0x040fe40007ffe0ffULL,
0x0000000604087810ULL, 0x000fe40007ffe0ffULL, 0x000000070500720cULL, 0x080fe20003f46070ULL,
0x000000012c057824ULL, 0x000fe200078e0205ULL, 0x000000070400720cULL, 0x080fe20003f66070ULL,
0x000000012c097824ULL, 0x000fe200078e0208ULL, 0x000000070600720cULL, 0x000fc40003f26070ULL,
0x000000070800720cULL, 0x000fe20003f06070ULL, 0x000000012c077824ULL, 0x000fe200078e0206ULL,
0x0000000703027812ULL, 0x000fe400078ec0ffULL, 0x0000000705067812ULL, 0x000fe400078ec0ffULL,
0x0000000f02027812ULL, 0x100fe400078e782bULL, 0x0000000707087812ULL, 0x000fe400078ec0ffULL,
0x00000007090c7812ULL, 0x000fe200078ec0ffULL, 0x00000010030a7824ULL, 0x000fe200078e0202ULL,
0x0000000f06067812ULL, 0x000fc400078e782bULL, 0x0000000f08087812ULL, 0x100fe400078e782bULL,
0x0000000f0c107812ULL, 0x000fe200078e782bULL, 0x00000010050c7824ULL, 0x000fe200078e0206ULL,
0x000000f00b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010070e7824ULL, 0x000fe400078e0208ULL,
0x0000001009107824ULL, 0x000fe200078e0210ULL, 0x0000c0000c0d7811ULL, 0x000fe400078e20ffULL,
0x0000c0000e0f7811ULL, 0x000fc400078e20ffULL, 0x0000c00010117811ULL, 0x000fe200078e20ffULL,
0x000000042d047e24ULL, 0x008fca000f8e022aULL, 0x0000003f04037812ULL, 0x040fe400078ef803ULL,
0x0000003f04057812ULL, 0x040fe400078ef805ULL, 0x0000003f04077812ULL, 0x040fe200078ef807ULL,
0x00005e0003027625ULL, 0x000fe200078e0012ULL, 0x0000003f04087812ULL, 0x000fc600078ef809ULL,
0x00005e0005047625ULL, 0x000fe200078e0012ULL, 0x0000000b02027210ULL, 0x000fc60007fbe0ffULL,
0x00005e0007067625ULL, 0x000fe200078e0012ULL, 0x0000000b04047210ULL, 0x000fc60007f9e0ffULL,
0x00005e0008087625ULL, 0x000fc800078e0012ULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x0000000b06067210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000000b08087210ULL, 0x000fe40007fde0ffULL, 0x0000c0000a0b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff077224ULL, 0x000fe400028e0607ULL, 0x000000ffff097224ULL, 0x000fe400030e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0009e8000d901c46ULL,
0x00000000040d7faeULL, 0x0009e8000d101c46ULL, 0x00000000060f7faeULL, 0x0009e2000c901c46ULL,
0x0000002e5b00720cULL, 0x000fc60003f26070ULL, 0x0000000008117faeULL, 0x0009e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0001342000001947ULL, 0x000fea0003800000ULL, 0x000000045a277824ULL, 0x000fe200078e00ffULL,
0x00007610ff697816ULL, 0x000fe20000000069ULL, 0x000000023e037824ULL, 0x010fe200078e00ffULL,
0x00007610ff257816ULL, 0x000fe20000000025ULL, 0x00006400ff267624ULL, 0x000fe200078e00ffULL,
0x0000000227247810ULL, 0x000fe20007ffe0ffULL, 0xff317217ff297424ULL, 0x000fc400078e00ffULL,
0x0000640003267624ULL, 0x000fe400078e0226ULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x000001005b007824ULL, 0x000fca00078e00ffULL, 0x000000590000720cULL, 0x000fda0003f06070ULL,
0x0001330000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000ffff677224ULL, 0x000fe200078e002fULL, 0x0000761069237816ULL, 0x000fe20000000023ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x01065c00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000300ff007624ULL, 0x000fe200078e00ffULL,
0x000000032f027812ULL, 0x000fe200078ec0ffULL, 0x000000042d047e24ULL, 0x000fe2000f8e022aULL,
0x00000004ff0d7819ULL, 0x000fe2000001162bULL, 0xffffffffff2d7424ULL, 0x000fe200078e00ffULL,
0x000000030200780cULL, 0x000fe40003f05270ULL, 0xfffffffd00007811ULL, 0x000fc800078e10ffULL,
0x0000000100007807ULL, 0x000fca0004000000ULL, 0x000000012f2f7824ULL, 0x000fca00078e0200ULL,
0x000000582f00720cULL, 0x000fe40003f06070ULL, 0x000000205b007811ULL, 0x000fe400078e40ffULL,
0x000000020d207810ULL, 0x040fe40007ffe0ffULL, 0x000000040d1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000012c227824ULL, 0x000fe200078e020dULL, 0x0000000059077217ULL, 0x000fca0007800000ULL,
0x000000012f028824ULL, 0x000fe400078e0226ULL, 0x00000004ff038424ULL, 0x000fe200078e00ffULL,
0x000000015b057810ULL, 0x000fe20007ffe0ffULL, 0x000000012c1c7824ULL, 0x000fe400078e0220ULL,
0x0000600002028625ULL, 0x000fc800078e0003ULL, 0x000000012c1b7824ULL, 0x000fe200078e021fULL,
0x00000006022d8981ULL, 0x000362000c1e1900ULL, 0x0000000107077824ULL, 0x000fe200078e0a00ULL,
0x0000002004007810ULL, 0x000fe20007ffe0ffULL, 0x000000102b117824ULL, 0x000fe200078e00ffULL,
0x0000003f221e7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff0f7424ULL, 0x000fe200078e00ffULL,
0x000000060d1d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002e0500720cULL, 0x000fe40003f06070ULL,
0x0000003f1c197812ULL, 0x000fe200078ec0ffULL, 0x000000011e027824ULL, 0x102fe200078e0200ULL,
0x0000003f1b187812ULL, 0x000fe200078ec0ffULL, 0x000000012c1a7824ULL, 0x000fe200078e021dULL,
0x0000002007077807ULL, 0x000fe20000000000ULL, 0x0000000119047824ULL, 0x100fe200078e0200ULL,
0x000000f011217812ULL, 0x000fe200078ec0ffULL, 0x0000000118067824ULL, 0x000fe200078e0200ULL,
0x000000072c0b7217ULL, 0x000fe20007800000ULL, 0x00005e0002027625ULL, 0x000fe200078e000fULL,
0x0000003f1a177812ULL, 0x000fc400078ec0ffULL, 0x00000007220a7812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e000fULL, 0x0000002102087210ULL, 0x000fe40007f3e0ffULL,
0x0000000f0a617812ULL, 0x000fe200078e782bULL, 0x00005e0006067625ULL, 0x000fe200078e000fULL,
0x0000002104047210ULL, 0x080fe40007f5e0ffULL, 0x000000071b0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000117027824ULL, 0x000fe200078e0200ULL, 0x0000002106067210ULL, 0x000fe20007f7e0ffULL,
0x000000010b007824ULL, 0x000fe200078e0a2cULL, 0x000000071a0c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0603ULL, 0x0000000f0a0a7812ULL, 0x000fe200078e782bULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x000000000d00720cULL, 0x080fe20003f26070ULL,
0x000000ffff077224ULL, 0x000fe200018e0607ULL, 0x000000002000720cULL, 0x080fe20003f46070ULL,
0x00005e0002027625ULL, 0x000fe200078e000fULL, 0x000000001f00720cULL, 0x000fc40003f66070ULL,
0x000000001d00720cULL, 0x000fe20003f86070ULL, 0x0000001022617824ULL, 0x000fe200078e0261ULL,
0x000000071c007812ULL, 0x000fe200078ec0ffULL, 0x000000101b5e7824ULL, 0x000fe200078e020aULL,
0x0000000f0c0b7812ULL, 0x100fe400078e782bULL, 0x0000000f005f7812ULL, 0x000fe400078e782bULL,
0x0000002102027210ULL, 0x000fe20007fbe0ffULL, 0x000000101a5c7824ULL, 0x000fe200078e020bULL,
0x0000e00061167811ULL, 0x000fe200078e20ffULL, 0x000000101c5f7824ULL, 0x000fe200078e025fULL,
0x0000e0005e147811ULL, 0x000fe200078e20ffULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x0000e0005c137811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008167faeULL, 0x0003e2000c901c46ULL, 0x0000e0005f157811ULL, 0x000fca00078e20ffULL,
0x0000000004157faeULL, 0x0003e8000d101c46ULL, 0x0000000006147faeULL, 0x0003e8000d901c46ULL,
0x0000000002137faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff037984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff057984ULL, 0x000ea20000000800ULL, 0x0000ffff69007812ULL, 0x000fc400078ec0ffULL,
0x0000ffff25027812ULL, 0x000fe400078ec0ffULL, 0x0000888000077816ULL, 0x000fe400000000ffULL,
0x0000888002127816ULL, 0x000fc600000000ffULL, 0x8000000007007824ULL, 0x000fe400078e00ffULL,
0x8000000012027824ULL, 0x000fc600078e00ffULL, 0x8000000003ff7812ULL, 0x002fe40007824800ULL,
0x8000000005ff7812ULL, 0x004fe20007844802ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000012037824ULL, 0x000fe400078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01060c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007844803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff007819ULL, 0x000fe2000001162bULL, 0x00000001ffb17424ULL, 0x000fe200078e00ffULL,
0x0000007011117812ULL, 0x000fe400078ec0ffULL, 0x0000000c00007812ULL, 0x000fca00078ec0ffULL,
0x0000000111117824ULL, 0x000fca00078e0200ULL, 0x0100000011007984ULL, 0x000e680000000800ULL,
0x0102000011037984ULL, 0x0004e20000000800ULL, 0x000000290000720bULL, 0x002fda0003f5d000ULL,
0x0000000000027806ULL, 0x000fc800010e0100ULL, 0x0000ffff02087812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x000000290000720bULL, 0x00cfe40003f54000ULL,
0x00000000290a7209ULL, 0x000fe40007810000ULL, 0x00000002ff057819ULL, 0x000fc6000001162bULL,
0x8000000a29027221ULL, 0x100fe20000010000ULL, 0x0000000805067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe400078e000aULL, 0x3fb8aa3b02047820ULL, 0x000fe40000410000ULL,
0x0000000000027806ULL, 0x000fe400010e0100ULL, 0x00000004000b7308ULL, 0x000e620000000800ULL,
0x000000ff5a00720cULL, 0x000fe40003f45270ULL, 0x0000ffff02097812ULL, 0x000fc800078e3cffULL,
0x0000000908ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ffb17807ULL, 0x000fc60001800000ULL,
0x0104000a1100a388ULL, 0x000fe20000000800ULL, 0x0000000b28287220ULL, 0x002fc60000410000ULL,
0x00001f060b067589ULL, 0x000e6400000e0000ULL, 0x8000000a00003221ULL, 0x000fe40000010000ULL,
0x00001f050b057589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b00003820ULL, 0x000fc80000410000ULL,
0x0000000000103308ULL, 0x000ee20000000800ULL, 0x000000063b3b7220ULL, 0x082fe20000410000ULL,
0x000000063a3a7220ULL, 0x080fe20000410000ULL, 0x0000000637377220ULL, 0x080fe20000410000ULL,
0x0000000636367220ULL, 0x080fe20000410000ULL, 0x0000000643437220ULL, 0x080fe20000410000ULL,
0x0000000642427220ULL, 0x080fe20000410000ULL, 0x0000000647477220ULL, 0x080fe20000410000ULL,
0x0000000646467220ULL, 0x080fe20000410000ULL, 0x000000064b4b7220ULL, 0x080fe20000410000ULL,
0x000000064a4a7220ULL, 0x080fe20000410000ULL, 0x000000064f4f7220ULL, 0x080fe20000410000ULL,
0x000000064e4e7220ULL, 0x080fe20000410000ULL, 0x0000000653537220ULL, 0x080fe20000410000ULL,
0x0000000652527220ULL, 0x080fe20000410000ULL, 0x0000000657577220ULL, 0x080fe20000410000ULL,
0x0000000656567220ULL, 0x000fe20000410000ULL, 0x0000000539397220ULL, 0x084fe20000410000ULL,
0x0000000538387220ULL, 0x080fe20000410000ULL, 0x0000000535357220ULL, 0x080fe20000410000ULL,
0x0000000534347220ULL, 0x080fe20000410000ULL, 0x0000000541417220ULL, 0x080fe20000410000ULL,
0x0000000540407220ULL, 0x080fe20000410000ULL, 0x0000000545457220ULL, 0x080fe20000410000ULL,
0x0000000544447220ULL, 0x080fe20000410000ULL, 0x0000000549497220ULL, 0x080fe20000410000ULL,
0x0000000548487220ULL, 0x080fe20000410000ULL, 0x000000054d4d7220ULL, 0x080fe20000410000ULL,
0x000000054c4c7220ULL, 0x080fe20000410000ULL, 0x0000000551517220ULL, 0x080fe20000410000ULL,
0x0000000550507220ULL, 0x080fe20000410000ULL, 0x0000000555557220ULL, 0x080fe20000410000ULL,
0x0000000554547220ULL, 0x000fe20000410000ULL, 0x0000001003033220ULL, 0x008fc80000410000ULL,
0x0000002803287221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff007984ULL, 0x000e620000000800ULL, 0x8000000007037824ULL, 0x000fca00078e00ffULL,
0x8000000000ff7812ULL, 0x002fe20007824803ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000007077824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01064c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007824807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000082b007812ULL, 0x040fe400078ec0ffULL, 0x000000272b027211ULL, 0x000fe400078fe0ffULL,
0x0000000700037812ULL, 0x140fe400078ec82bULL, 0x0000000700007812ULL, 0x000fe400078ef82bULL,
0x0000000203057212ULL, 0x000fe400078e3cffULL, 0x000000242b027211ULL, 0x000fc600078fe0ffULL,
0x00000010005d7824ULL, 0x000fe200078e0205ULL, 0x0000000203077212ULL, 0x000fc800078e3cffULL,
0x0000c0005d0f7811ULL, 0x000fe200078e20ffULL, 0x0000001000037824ULL, 0x040fe200078e0207ULL,
0x0000010000007811ULL, 0x000fc600078e20ffULL, 0x000000000f30783bULL, 0x000e620000004200ULL,
0x0000c000030e7811ULL, 0x000fe200078e20ffULL, 0x0000000105027824ULL, 0x100fe400078e0200ULL,
0x0000000107607824ULL, 0x000fe400078e0200ULL, 0x000000000e08783bULL, 0x000ea20000004200ULL,
0x0000c000020d7811ULL, 0x000fe400078e20ffULL, 0x0000c000600c7811ULL, 0x000fc600078e20ffULL,
0x000000000d3c783bULL, 0x000ee80000004200ULL, 0x000000000c04783bULL, 0x000f220000004200ULL,
0x0000010030e47824ULL, 0x042fe200078e00ffULL, 0x0000003000be7306ULL, 0x000fe20000009400ULL,
0x0001000030e67824ULL, 0x000fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe20000011430ULL,
0x0000010031de7824ULL, 0x040fe200078e00ffULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x0001000031e27824ULL, 0x000fe200078e00ffULL, 0x00000018ffe67819ULL, 0x000fe200000114e6ULL,
0x0000010032d07824ULL, 0x040fe200078e00ffULL, 0x000000e400c87306ULL, 0x000fe20000209400ULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x0000010033c97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x0001000032ca7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe200000114d0ULL, 0x0000010009b47824ULL, 0x044fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe20000011431ULL, 0x000000e400cf7306ULL, 0x000e620000205400ULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0001000009af7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe20000011432ULL, 0x0001000033c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0000010008ba7824ULL, 0x040fe200078e00ffULL,
0x00000018ffa27819ULL, 0x000fe20000011409ULL, 0x0000003000bf7306ULL, 0x000ea20000005400ULL,
0x00000018ffad7819ULL, 0x000fe20000011433ULL, 0x0001000008b57824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000001003ceb7824ULL, 0x008fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x000001003dd97824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000003000897306ULL, 0x000ee2000000d400ULL,
0x000000cfc800720bULL, 0x002fe20003fbd000ULL, 0x000001003ecf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x000001003fc87824ULL, 0x000fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fc40000011408ULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x000000e600307306ULL, 0x000fe20000209400ULL, 0x000000bfbe00720bULL, 0x004fe40003f7d000ULL,
0x00000018ff997819ULL, 0x000fe4000001140aULL, 0x00000018ff987819ULL, 0x000fe4000001140bULL,
0x00000018ff927819ULL, 0x000fe2000001143cULL, 0x000000e600d57306ULL, 0x000e620000205400ULL,
0x00000018ff7b7819ULL, 0x010fc40000011404ULL, 0x00000018ff767819ULL, 0x000fe40000011405ULL,
0x00000018ff007819ULL, 0x000fe40000011406ULL, 0x0000000189893812ULL, 0x008fe200078efcffULL,
0x0000003100e37306ULL, 0x000fe20000009400ULL, 0x00000018ffd97819ULL, 0x000fe400000114d9ULL,
0x00000018ff937819ULL, 0x000fe4000001143dULL, 0x00000018ffcf7819ULL, 0x000fc400000114cfULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000003100e07306ULL, 0x000ea20000005400ULL,
0x000000d53000720bULL, 0x002fe20003f5d000ULL, 0x000100003dd57824ULL, 0x000fe200078e00ffULL,
0x000000e400307245ULL, 0x000fe4000020d400ULL, 0x00000018ff627819ULL, 0x000fe40000011407ULL,
0x0000000130305812ULL, 0x000fe200078efcffULL, 0x000000db00e57306ULL, 0x000fe20000209400ULL,
0x00000018ffd57819ULL, 0x000fc400000114d5ULL, 0x000000893030723eULL, 0x000fe400000010ffULL,
0x000000c800897245ULL, 0x000fe4000020d400ULL, 0x00000018ff687819ULL, 0x000fe2000001143eULL,
0x000000db00d27306ULL, 0x000e620000205400ULL, 0x000000e0e300720bULL, 0x004fe40003f9d000ULL,
0x00000018ff637819ULL, 0x000fca000001143fULL, 0x000000de00e77306ULL, 0x000ff00000209400ULL,
0x000000de00ea7306ULL, 0x000ea20000205400ULL, 0x000000d2e500720bULL, 0x002fce0003fdd000ULL,
0x000000e200e97306ULL, 0x000ff00000209400ULL, 0x000000e200e87306ULL, 0x000e620000205400ULL,
0x000000eae700720bULL, 0x004fce0003fbd000ULL, 0x0000003200d77306ULL, 0x000ff00000009400ULL,
0x0000003200d87306ULL, 0x000fe20000005400ULL, 0x000000e8e900720bULL, 0x002fce0003f7d000ULL,
0x0000003100887306ULL, 0x0002b0000000d400ULL, 0x000000d000da7306ULL, 0x000fe20000209400ULL,
0x000001000a317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x000000d000df7306ULL, 0x0002e20000205400ULL, 0x0000000188884812ULL, 0x004fce00078efcffULL,
0x0000003300d67306ULL, 0x000fe20000009400ULL, 0x000000d000d07245ULL, 0x002fce000020d400ULL,
0x0000003300dd7306ULL, 0x000fe20000005400ULL, 0x000000dfda00720bULL, 0x008fe20003f9d000ULL,
0x0000010004df7824ULL, 0x000fe400078e00ffULL, 0x0001000005da7824ULL, 0x000fc600078e00ffULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x000000cb00d47306ULL, 0x000fe20000209400ULL,
0x00000018ffda7819ULL, 0x000fca00000114daULL, 0x00000001d0d04812ULL, 0x000fe400078efcffULL,
0x000000cb00d37306ULL, 0x000e700000205400ULL, 0x0000003200857306ULL, 0x0004f0000000d400ULL,
0x000000c900dc7306ULL, 0x000fe20000209400ULL, 0x000000e600327245ULL, 0x004fc8000020d400ULL,
0x0000000132322812ULL, 0x000fe400078efcffULL, 0x000000d8d700720bULL, 0x000fe20003f5d000ULL,
0x000000c900e17306ULL, 0x0005220000205400ULL, 0x000000de00d77245ULL, 0x000fe4000020d400ULL,
0x00000018ffd87819ULL, 0x000fe400000114ebULL, 0x00000001d7d75812ULL, 0x000fe400078efcffULL,
0x000000d3d400720bULL, 0x002fe20003fbd000ULL, 0x0000000900ab7306ULL, 0x000fe20000009400ULL,
0x000000c900c97245ULL, 0x004fe2000020d400ULL, 0x0001000004d47824ULL, 0x000fc400078e00ffULL,
0x0000000185852812ULL, 0x008fe200078efcffULL, 0x0000010006d37824ULL, 0x000fe400078e00ffULL,
0x00000018ffd47819ULL, 0x000fe200000114d4ULL, 0x0000000900ac7306ULL, 0x000fe40000005400ULL,
0x00000018ffd37819ULL, 0x000fcc00000114d3ULL, 0x00000009007c7306ULL, 0x0003f0000000d400ULL,
0x000000ca00cc7306ULL, 0x000fe20000209400ULL, 0x000000db00097245ULL, 0x002fc8000020d400ULL,
0x0000000109096812ULL, 0x000fe400078efcffULL, 0x000000ddd600720bULL, 0x000fe20003fdd000ULL,
0x000000ca00d17306ULL, 0x0002a20000205400ULL, 0x000000e200d67245ULL, 0x000fe4000020d400ULL,
0x000000cb00dd7245ULL, 0x000fe4000020d400ULL, 0x00000001d6d63812ULL, 0x000fe400078efcffULL,
0x000000e1dc00720bULL, 0x010fe20003f7d000ULL, 0x000000b000c07306ULL, 0x000fe20000209400ULL,
0x00000001dddd5812ULL, 0x000fc400078efcffULL, 0x000000ca00ca7245ULL, 0x002fe4000020d400ULL,
0x000000c300cb7245ULL, 0x000fe4000020d400ULL, 0x000000320932723eULL, 0x000fe200000010ffULL,
0x000000b000c17306ULL, 0x000e620000205400ULL, 0x000000d1cc00720bULL, 0x004fc60003f9d000ULL,
0x00000001c9c93812ULL, 0x000fc800078efcffULL, 0x0000003300847306ULL, 0x0004ec000000d400ULL,
0x00000001caca4812ULL, 0x000fe400078efcffULL, 0x000000ad00b27306ULL, 0x000fe20000209400ULL,
0x000000c1c000720bULL, 0x002fe20003fbd000ULL, 0x000001000b337824ULL, 0x004fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x000000ad00b37306ULL, 0x000e620000205400ULL,
0x0000000184846812ULL, 0x008fce00078efcffULL, 0x000000c300cd7306ULL, 0x000ff00000209400ULL,
0x000000c300ce7306ULL, 0x000ea20000205400ULL, 0x000000b3b200720bULL, 0x002fe40003fdd000ULL,
0x000000b000b37245ULL, 0x000fc4000020d400ULL, 0x000000ad00b07245ULL, 0x000fe4000020d400ULL,
0x00000001b3b35812ULL, 0x000fe200078efcffULL, 0x000000ba00c57306ULL, 0x000fe60000209400ULL,
0x000000cab3ca723eULL, 0x000fc600000010ffULL, 0x00000001b0b06812ULL, 0x000fe400078efcffULL,
0x000000ba00c67306ULL, 0x0002e20000205400ULL, 0x000000cecd00720bULL, 0x004fce0003f7d000ULL,
0x000000b400c27306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x002fca000020d400ULL,
0x00000001cbcb3812ULL, 0x000fe400078efcffULL, 0x000000b400c77306ULL, 0x000e620000205400ULL,
0x000000c6c500720bULL, 0x008fe40003f9d000ULL, 0x000000acab00720bULL, 0x000fe40003f7d000ULL,
0x000000b400ab7245ULL, 0x000fe4000020d400ULL, 0x000000cbb0cb723eULL, 0x000fe200000010ffULL,
0x0000000800b97306ULL, 0x000fec0000009400ULL, 0x00000001baba4812ULL, 0x000fc400078efcffULL,
0x0000000800b87306ULL, 0x000ea20000005400ULL, 0x000000c7c200720bULL, 0x002fe40003fbd000ULL,
0x000000017c7c3812ULL, 0x000fca00078efcffULL, 0x000000b500bb7306ULL, 0x000fec0000209400ULL,
0x00000001abab5812ULL, 0x000fe400078efcffULL, 0x000000b500c47306ULL, 0x0002e20000205400ULL,
0x000000b8b900720bULL, 0x004fe40003f5d000ULL, 0x0000007cabab723eULL, 0x000fca00000010ffULL,
0x000000a600a97306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fce000020d400ULL,
0x000000a600a87306ULL, 0x0002a20000205400ULL, 0x000000c4bb00720bULL, 0x008fce0003fdd000ULL,
0x000000af00bc7306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x002fca000020d400ULL,
0x00000001b5b56812ULL, 0x000fe400078efcffULL, 0x000000af00bd7306ULL, 0x0002e20000205400ULL,
0x000000a8a900720bULL, 0x004fce0003f9d000ULL, 0x00000008007f7306ULL, 0x000522000000d400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x00000001a6a64812ULL, 0x000fe400078efcffULL,
0x0000000a00a47306ULL, 0x000fe20000009400ULL, 0x00009910b1087816ULL, 0x004fe400000000ffULL,
0x000000bdbc00720bULL, 0x008fe40003fbd000ULL, 0x000000ff0800720cULL, 0x000fe20003f25270ULL,
0x000100000b087824ULL, 0x000fe200078e00ffULL, 0x000000b5a6a6723eULL, 0x000fe200000010ffULL,
0x0000000a00a57306ULL, 0x000e620000005400ULL, 0x000000017f7f2812ULL, 0x010fc400078efcffULL,
0x00000018ffbf7819ULL, 0x000fe20000011408ULL, 0x0001000007087824ULL, 0x000fc800078e00ffULL,
0x000000a200a77306ULL, 0x000fe20000209400ULL, 0x00000001afaf5812ULL, 0x000fce00078efcffULL,
0x000000a200aa7306ULL, 0x0004e20000205400ULL, 0x000000a5a400720bULL, 0x002fce0003fdd000ULL,
0x0000003100b67306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x004fce000020d400ULL,
0x0000003100b77306ULL, 0x000e620000205400ULL, 0x000000aaa700720bULL, 0x008fe40003f5d000ULL,
0x00000002ffaa7819ULL, 0x000fca000001162bULL, 0x0000000a007a7306ULL, 0x0004ec000000d400ULL,
0x00000001a2a22812ULL, 0x000fe400078efcffULL, 0x0000003300ae7306ULL, 0x000fe20000209400ULL,
0x000100000a0a7824ULL, 0x004fe200078e00ffULL, 0x000000b7b600720bULL, 0x002fc80003f7d000ULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x0000003300b17306ULL, 0x000e620000205400ULL,
0x000000017a7a6812ULL, 0x008fce00078efcffULL, 0x0000000b00a07306ULL, 0x000ff00000009400ULL,
0x0000000b00a37306ULL, 0x000ea20000005400ULL, 0x000000b1ae00720bULL, 0x002fce0003f9d000ULL,
0x0000000b00797306ULL, 0x000e70000000d400ULL, 0x0000003c009e7306ULL, 0x000fe20000009400ULL,
0x000000a3a000720bULL, 0x004fe40003fbd000ULL, 0x0000003100a37245ULL, 0x000fc4000020d400ULL,
0x00000010ff31723eULL, 0x000fe400000010ffULL, 0x00000001a3a33812ULL, 0x000fe200078efcffULL,
0x0000003c00a17306ULL, 0x000ea20000005400ULL, 0x0000541031317816ULL, 0x000fe40000000031ULL,
0x0000007aa37a723eULL, 0x000fc600000010ffULL, 0x0000000179795812ULL, 0x002fe400078efcffULL,
0x00000099009f7306ULL, 0x000ff00000209400ULL, 0x0000009900647306ULL, 0x0002e20000205400ULL,
0x000000a19e00720bULL, 0x004fc40003f5d000ULL, 0x00000033009e7245ULL, 0x000fc8000020d400ULL,
0x000000019e9e4812ULL, 0x000fe200078efcffULL, 0x0000000a000b7306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fce000020d400ULL, 0x0000000a00be7306ULL, 0x000e620000205400ULL,
0x000000649f00720bULL, 0x008fe40003fdd000ULL, 0x000000072b647812ULL, 0x000fc800078ec0ffULL,
0x0000000864647812ULL, 0x000fe200078ef82bULL, 0x00000098009d7306ULL, 0x000fe60000209400ULL,
0x0000000720097812ULL, 0x000fc600078e7864ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x00000098009c7306ULL, 0x0004e20000205400ULL, 0x000000be0b00720bULL, 0x002fe20003f7d000ULL,
0x0000000864097824ULL, 0x000fe200078e0209ULL, 0x00000004ff0b7819ULL, 0x000fc8000001162bULL,
0x000000070b0b7812ULL, 0x000fe200078e7864ULL, 0x000000bf00d27306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x004fc6000020d400ULL, 0x00000008640b7824ULL, 0x000fc800078e020bULL,
0x000000bf00db7306ULL, 0x0002a20000205400ULL, 0x0000009c9d00720bULL, 0x008fe40003f9d000ULL,
0x0000000a009c7245ULL, 0x000fe4000020d400ULL, 0x00000008aa0a7810ULL, 0x000fe40007ffe0ffULL,
0x000000019c9c3812ULL, 0x000fe200078efcffULL, 0x0000003c00787306ULL, 0x000722000000d400ULL,
0x000000bf00bf7245ULL, 0x002fe4000020d400ULL, 0x0000009c999c723eULL, 0x000fc600000010ffULL,
0x0000000198984812ULL, 0x000fe400078efcffULL, 0x0000003d009a7306ULL, 0x000fe20000009400ULL,
0x000100003c3c7824ULL, 0x008fe200078e00ffULL, 0x000000dbd200720bULL, 0x004fc80003fbd000ULL,
0x00000018ffdc7819ULL, 0x000fe2000001143cULL, 0x00010000063c7824ULL, 0x000fe200078e00ffULL,
0x0000003d009b7306ULL, 0x000e620000005400ULL, 0x0000000178782812ULL, 0x010fc600078efcffULL,
0x00000018ff3c7819ULL, 0x000fc6000001143cULL, 0x00000001bfbf5812ULL, 0x000fe200078efcffULL,
0x000000d800de7306ULL, 0x000ff00000209400ULL, 0x000000d800e17306ULL, 0x000ea20000205400ULL,
0x0000009b9a00720bULL, 0x002fc40003fdd000ULL, 0x000000d8009b7245ULL, 0x000fca000020d400ULL,
0x00000004008e7306ULL, 0x000ff00000009400ULL, 0x00000004008f7306ULL, 0x000fe20000005400ULL,
0x000000e1de00720bULL, 0x004fce0003f7d000ULL, 0x0000000400717306ULL, 0x0003ec000000d400ULL,
0x000000019b9b3812ULL, 0x000fe400078efcffULL, 0x0000009200977306ULL, 0x000fe20000209400ULL,
0x0000010005047824ULL, 0x002fe200078e00ffULL, 0x000000789b78723eULL, 0x000fc800000010ffULL,
0x00000018ff9f7819ULL, 0x000fe40000011404ULL, 0x0000009200967306ULL, 0x000e700000205400ULL,
0x0000000500907306ULL, 0x000ff00000009400ULL, 0x0000000500917306ULL, 0x000fe20000005400ULL,
0x000000969700720bULL, 0x002fc40003f9d000ULL, 0x00001faa31977589ULL, 0x0003ea00000e0000ULL,
0x0000000500707306ULL, 0x000fe2000000d400ULL, 0x0000007fbaaa723eULL, 0x002fce00000010ffULL,
0x0000000600877306ULL, 0x000ff00000009400ULL, 0x0000000600867306ULL, 0x000ff00000005400ULL,
0x0000000600667306ULL, 0x000ff0000000d400ULL, 0x000000dc00057306ULL, 0x000ff00000209400ULL,
0x000000dc00067306ULL, 0x0002b00000205400ULL, 0x000000d900b87306ULL, 0x000fe20000209400ULL,
0x000000dc00dc7245ULL, 0x002fce000020d400ULL, 0x000000d900b97306ULL, 0x000e620000205400ULL,
0x000000060500720bULL, 0x004fe40003fbd000ULL, 0x0000a0000b057811ULL, 0x000fca00078e20ffULL,
0x0000003d00777306ULL, 0x0004ec000000d400ULL, 0x00000001dcdc5812ULL, 0x000fe400078efcffULL,
0x0000003f008c7306ULL, 0x000fe20000009400ULL, 0x000000b9b800720bULL, 0x002fe20003f5d000ULL,
0x00000100073d7824ULL, 0x004fcc00078e00ffULL, 0x0000003f008d7306ULL, 0x000e620000005400ULL,
0x0000000177776812ULL, 0x008fce00078efcffULL, 0x0000009300957306ULL, 0x000ff00000209400ULL,
0x0000009300947306ULL, 0x0004e20000205400ULL, 0x0000008d8c00720bULL, 0x002fe40003fdd000ULL,
0x000000cf008c7245ULL, 0x000fca000020d400ULL, 0x000000cf00a47306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x004fce000020d400ULL, 0x000000cf00a57306ULL, 0x000e620000205400ULL,
0x000000949500720bULL, 0x008fe40003f7d000ULL, 0x0000009200957245ULL, 0x000fe4000020d400ULL,
0x000000d900947245ULL, 0x000fe2000020d400ULL, 0x00001f0a31927589ULL, 0x0005e200000e0000ULL,
0x0000000195954812ULL, 0x000fe200078efcffULL, 0x000000d500ac7306ULL, 0x000fe20000209400ULL,
0x0000000194942812ULL, 0x000fca00078efcffULL, 0x0000000193933812ULL, 0x000fe400078efcffULL,
0x000000d500a77306ULL, 0x000ee20000205400ULL, 0x000000a5a400720bULL, 0x002fe40003f9d000ULL,
0x00000088d731723eULL, 0x004fe400000010ffULL, 0x000000919000720bULL, 0x000fc60003f7d000ULL,
0x0000003e008a7306ULL, 0x000fec0000009400ULL, 0x000000018c8c4812ULL, 0x000fe400078efcffULL,
0x0000003e008b7306ULL, 0x000e620000005400ULL, 0x000000a7ac00720bULL, 0x008fe40003fbd000ULL,
0x0000000170703812ULL, 0x000fc400078efcffULL, 0x000000afa2a7723eULL, 0x000fc600000010ffULL,
0x0000003f00747306ULL, 0x0004f0000000d400ULL, 0x0000009f00a17306ULL, 0x000fe20000209400ULL,
0x0000008b8a00720bULL, 0x002fe20003f5d000ULL, 0x000100003f3f7824ULL, 0x004fe200078e00ffULL,
0x000000d5008a7245ULL, 0x000fc4000020d400ULL, 0x000000da00d57245ULL, 0x000fe4000020d400ULL,
0x000000018a8a5812ULL, 0x000fe200078efcffULL, 0x0000009f00a87306ULL, 0x000e620000205400ULL,
0x0000000174746812ULL, 0x008fe400078efcffULL, 0x0000008f8e00720bULL, 0x000fe40003fbd000ULL,
0x0000009f008f7245ULL, 0x000fe4000020d400ULL, 0x000000df008e7245ULL, 0x000fe2000020d400ULL,
0x000000c800337306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x000fc4000001143fULL,
0x0000008a9393723eULL, 0x000fca00000010ffULL, 0x000000c800a07306ULL, 0x000ea20000205400ULL,
0x000000a8a100720bULL, 0x002fe40003fdd000ULL, 0x0000000171715812ULL, 0x000fca00078efcffULL,
0x0000000700837306ULL, 0x000fec0000009400ULL, 0x000000018f8f6812ULL, 0x000fe400078efcffULL,
0x0000000700827306ULL, 0x000fe20000005400ULL, 0x000000a03300720bULL, 0x004fe40003f9d000ULL,
0x000000d6dd33723eULL, 0x000fc400000010ffULL, 0x000000708f8f723eULL, 0x000fc600000010ffULL,
0x0000000700657306ULL, 0x0003ec000000d400ULL, 0x0000000189894812ULL, 0x000fe400078efcffULL,
0x0000003e00757306ULL, 0x0004e2000000d400ULL, 0x000000000504783bULL, 0x002e620000000200ULL,
0x000000868700720bULL, 0x000fc40003f9d000ULL, 0x00000085d086723eULL, 0x000fe400000010ffULL,
0x00000084c987723eULL, 0x000fe400000010ffULL, 0x000000df009d7306ULL, 0x000fe20000209400ULL,
0x00000018ff847819ULL, 0x000fe2000001143dULL, 0x000100003e3e7824ULL, 0x004fe200078e00ffULL,
0x000000748989723eULL, 0x000fc800000010ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000000df009a7306ULL, 0x000ea20000205400ULL, 0x0000000175752812ULL, 0x008fe400078efcffULL,
0x0000000166664812ULL, 0x000fca00078efcffULL, 0x000000d400967306ULL, 0x000ff00000209400ULL,
0x000000d4008b7306ULL, 0x0007220000205400ULL, 0x0000009a9d00720bULL, 0x004fe40003f5d000ULL,
0x000000bf989d723eULL, 0x000fca00000010ffULL, 0x0000007b00807306ULL, 0x000fe20000209400ULL,
0x000000d400d47245ULL, 0x008fe2000020d400ULL, 0x0000009704049231ULL, 0x082fe400003400ffULL,
0x0000009706069231ULL, 0x000fe400003400ffULL, 0x000000018e8e2812ULL, 0x000fe200078efcffULL,
0x0000009205059231ULL, 0x080fe200003400ffULL, 0x0000007b00817306ULL, 0x000e620000205400ULL,
0x0000008b9600720bULL, 0x010fe20003fdd000ULL, 0x0000009207079231ULL, 0x000fe200003400ffULL,
0x000000828300720bULL, 0x000fc40003f5d000ULL, 0x000000718e8e723eULL, 0x000fc600000010ffULL,
0x000000da008d7306ULL, 0x000fe20000209400ULL, 0x000000300454723cULL, 0x040fea0000041854ULL,
0x00000001d4d46812ULL, 0x000fe400078efcffULL, 0x000000da00887306ULL, 0x000ea20000205400ULL,
0x000000818000720bULL, 0x002fe20003fbd000ULL, 0x000000320450723cULL, 0x000fe20000041850ULL,
0x0000a00009307811ULL, 0x000fc400078e20ffULL, 0x0000000165652812ULL, 0x000fc600078efcffULL,
0x00000076007e7306ULL, 0x000fe20000209400ULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x00000086044c723cULL, 0x040fec000004184cULL, 0x00000076007d7306ULL, 0x0007220000205400ULL,
0x000000888d00720bULL, 0x004fe20003fdd000ULL, 0x000000ca0448723cULL, 0x000fe20000041848ULL,
0x000000758c88723eULL, 0x000fca00000010ffULL, 0x000000d300907306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x008fe2000020d400ULL, 0x000000aa0444723cULL, 0x040fe80000041844ULL,
0x00000001d5d56812ULL, 0x000fe400078efcffULL, 0x000000d300857306ULL, 0x0004e20000205400ULL,
0x0000007d7e00720bULL, 0x010fe20003f7d000ULL, 0x000000a60440723cULL, 0x000fe20000041840ULL,
0x0000007b007d7245ULL, 0x000fc4000020d400ULL, 0x000000799e7b723eULL, 0x000fe400000010ffULL,
0x000000017d7d5812ULL, 0x000fe200078efcffULL, 0x0000008400827306ULL, 0x000fe20000209400ULL,
0x000000d300d37245ULL, 0x004fe4000020d400ULL, 0x000000779479723eULL, 0x000fe200000010ffULL,
0x0000007a0434723cULL, 0x040fe20000041834ULL, 0x000000d47dd4723eULL, 0x000fe400000010ffULL,
0x0000000176763812ULL, 0x000fe200078efcffULL, 0x0000008400817306ULL, 0x0005220000205400ULL,
0x000000859000720bULL, 0x008fe20003fbd000ULL, 0x0000009231319231ULL, 0x082fe200003400ffULL,
0x000000d576d5723eULL, 0x000fe200000010ffULL, 0x0000009c0404723cULL, 0x000fe20000041838ULL,
0x0000009233339231ULL, 0x000fe200003400ffULL, 0x000000dc9592723eULL, 0x000fe200000010ffULL,
0x0000009730309231ULL, 0x080fe200003400ffULL, 0x0000003e003d7306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x004fe2000020d400ULL, 0x0000009732329231ULL, 0x000fc800003400ffULL,
0x00000001d3d35812ULL, 0x000fe400078efcffULL, 0x0000003e007c7306ULL, 0x0002a20000205400ULL,
0x000000818200720bULL, 0x010fe20003fdd000ULL, 0x000000783054723cULL, 0x000fe20000041854ULL,
0x00000066d33a723eULL, 0x000fca00000010ffULL, 0x00000000006c7306ULL, 0x000fe20000209400ULL,
0x0000003e003e7245ULL, 0x002fe2000020d400ULL, 0x000000923050723cULL, 0x040fe80000041850ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x00000000006f7306ULL, 0x000e620000205400ULL,
0x0000007c3d00720bULL, 0x004fe20003fbd000ULL, 0x00000088304c723cULL, 0x000fe2000004184cULL,
0x00000018ff3d7819ULL, 0x000fc40000011408ULL, 0x0000006300087245ULL, 0x000fe4000020d400ULL,
0x00000065843b723eULL, 0x000fe200000010ffULL, 0x00000062006d7306ULL, 0x000fe40000209400ULL,
0x0000008e3044723cULL, 0x040fe80000041844ULL, 0x000000013e3e5812ULL, 0x000fe400078efcffULL,
0x00000062006e7306ULL, 0x0004e20000205400ULL, 0x0000006f6c00720bULL, 0x002fe20003f9d000ULL,
0x000000d43040723cULL, 0x040fec0000041840ULL, 0x0000006800737306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fe2000020d400ULL, 0x0000003a3034723cULL, 0x000fec0000041834ULL,
0x0000006800727306ULL, 0x000e620000205400ULL, 0x0000006e6d00720bULL, 0x008fce0003fdd000ULL,
0x0000003f00387306ULL, 0x000fec0000209400ULL, 0x0000000162626812ULL, 0x000fe400078efcffULL,
0x0000003f00397306ULL, 0x0004e20000205400ULL, 0x000000727300720bULL, 0x002fce0003f7d000ULL,
0x00000063006a7306ULL, 0x000fe20000209400ULL, 0x0000003f003f7245ULL, 0x004fce000020d400ULL,
0x00000063006b7306ULL, 0x000e620000205400ULL, 0x000000393800720bULL, 0x008fe40003f5d000ULL,
0x0000006800397245ULL, 0x000fc8000020d400ULL, 0x0000000139393812ULL, 0x000fe200078efcffULL,
0x0000003c007e7306ULL, 0x000fe60000209400ULL, 0x0000003e393e723eULL, 0x000fe400000010ffULL,
0x0000000000397245ULL, 0x000fe4000020d400ULL, 0x000000013f3f2812ULL, 0x000fe200078efcffULL,
0x0000003c00777306ULL, 0x0004e20000205400ULL, 0x0000006b6a00720bULL, 0x002fc40003fbd000ULL,
0x0000000139394812ULL, 0x000fca00078efcffULL, 0x0000003d006c7306ULL, 0x000fe20000209400ULL,
0x0000003c003c7245ULL, 0x004fca000020d400ULL, 0x0000000108085812ULL, 0x000fe400078efcffULL,
0x0000003d006d7306ULL, 0x0002a20000205400ULL, 0x000000777e00720bULL, 0x008fe40003f7d000ULL,
0x0000003f083f723eULL, 0x000fe400000010ffULL, 0x0000003d003d7245ULL, 0x002fca000020d400ULL,
0x0000003e3048723cULL, 0x000fe80000041848ULL, 0x000000013c3c3812ULL, 0x000fe400078efcffULL,
0x0000006d6c00720bULL, 0x004fe40003f5d000ULL, 0x0000003c393c723eULL, 0x000fd600000010ffULL,
0x000000013d3d2812ULL, 0x000fc800078efcffULL, 0x0000003d623d723eULL, 0x000fce00000010ffULL,
0x0000003c3030723cULL, 0x000fe20000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01065c00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000405b007811ULL, 0x000fe200078e40ffULL,
0x000000042d3b7e24ULL, 0x020fe2000f8e022aULL, 0x00000004ff397819ULL, 0x000fe2000001162bULL,
0x00000100ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000000059057217ULL, 0x000fc40007800000ULL,
0x0000003f3b047812ULL, 0x040fe400078ef822ULL, 0x0000003f3b067812ULL, 0x000fe200078ef81cULL,
0x0000000105057824ULL, 0x000fe200078e0a00ULL, 0x0000003f3b3c7812ULL, 0x040fe400078ef81bULL,
0x0000003f3b3e7812ULL, 0x000fe400078ef81aULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x00005e003c3c7625ULL, 0x000fe200078e003fULL, 0x0000c00061087811ULL, 0x000fc400078e20ffULL,
0x000000052c077217ULL, 0x000fe20007800000ULL, 0x00005e0004047625ULL, 0x000fe200078e003fULL,
0x000000213c3c7210ULL, 0x000fc60007fbe0ffULL, 0x0000000107007824ULL, 0x000fe200078e0a2cULL,
0x0000002104387210ULL, 0x000fe20007f7e0ffULL, 0x00005e0006067625ULL, 0x000fc600078e003fULL,
0x000000003900720cULL, 0x080fe20003f46070ULL, 0x000000ffff397224ULL, 0x000fe200018e0605ULL,
0x00000021063a7210ULL, 0x000fe20007f9e0ffULL, 0x00005e003e3e7625ULL, 0x000fe200078e003fULL,
0x000000002000720cULL, 0x080fe40003f66070ULL, 0x0000c0005e067811ULL, 0x000fe200078e20ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e0607ULL, 0x000000001f00720cULL, 0x080fe20003f86070ULL,
0x000000ffff3d7224ULL, 0x000fe200028e063dULL, 0x000000001d00720cULL, 0x000fc40003fa6070ULL,
0x000000213e3e7210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038087faeULL, 0x0003e2000d101c46ULL, 0x0000c0005f077811ULL, 0x000fe400078e20ffULL,
0x0000c0005c057811ULL, 0x000fe200078e20ffULL, 0x000000ffff3f7224ULL, 0x000fe400030e063fULL,
0x000000003a077faeULL, 0x0003e8000d901c46ULL, 0x000000003c067faeULL, 0x0003e8000e101c46ULL,
0x000000003e057faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff397984ULL, 0x002e620000000800ULL, 0x0000ffff69007812ULL, 0x000fc800078ec0ffULL,
0x0000888000047816ULL, 0x000fca00000000ffULL, 0x8000000004007824ULL, 0x000fca00078e00ffULL,
0x8000000039ff7812ULL, 0x002fe20007844800ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x01065400ff397984ULL, 0x000e620000000800ULL,
0x8000000004007824ULL, 0x000fca00078e00ffULL, 0x8000000039ff7812ULL, 0x002fe20007844800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000004047824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000387305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000380000735dULL, 0x004fe20003800000ULL, 0x01065400ff397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007844804ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000e0005d047811ULL, 0x000fe400078e20ffULL,
0x0000e00003037811ULL, 0x000fc400078e20ffULL, 0x0000e00002027811ULL, 0x000fe200078e20ffULL,
0x000000000438783bULL, 0x000e620000004200ULL, 0x0000e00060007811ULL, 0x000fc600078e20ffULL,
0x00000000033c783bULL, 0x000ea80000004200ULL, 0x00000000025c783bULL, 0x000ee80000004200ULL,
0x000000000060783bULL, 0x000f220000004200ULL, 0x0000010038c37824ULL, 0x042fe200078e00ffULL,
0x0000003800c17306ULL, 0x000fe20000009400ULL, 0x0001000038cf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe20000011439ULL, 0x0000010039db7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0001000039e87824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x000001003ae27824ULL, 0x000fe200078e00ffULL,
0x000000c300ea7306ULL, 0x000fe20000209400ULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x000001003ea77824ULL, 0x044fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe20000011438ULL,
0x000100003eaa7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe87819ULL, 0x000fe200000114e8ULL,
0x000100003bc97824ULL, 0x000fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe2000001143eULL,
0x000000c300ed7306ULL, 0x0002a20000205400ULL, 0x00000018ffe27819ULL, 0x000fe200000114e2ULL,
0x000001003fa87824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x008fe2000001145eULL,
0x000001003cc87824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe2000001143fULL,
0x000100003dd67824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000003800c07306ULL, 0x000ee20000005400ULL, 0x000000c300c37245ULL, 0x002fc4000020d400ULL,
0x00000018ffad7819ULL, 0x000fe4000001143aULL, 0x00000018ff7f7819ULL, 0x000fe4000001145fULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000000cf00c67306ULL, 0x000fe20000209400ULL,
0x000000edea00720bULL, 0x004fe20003f5d000ULL, 0x000100005cea7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbb7819ULL, 0x000fe4000001143bULL, 0x00000018ffae7819ULL, 0x000fc4000001143cULL,
0x00000018ffd67819ULL, 0x000fe200000114d6ULL, 0x000000cf00e97306ULL, 0x000e620000205400ULL,
0x000000c0c100720bULL, 0x008fe20003f9d000ULL, 0x000100003fc17824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe4000001143dULL, 0x000000071ded7812ULL, 0x000fe400078e7864ULL,
0x00000001c3c32812ULL, 0x000fe200078efcffULL, 0x00000038008e7306ULL, 0x0004e2000000d400ULL,
0x00000018ffa77819ULL, 0x000fc400000114a7ULL, 0x00000018ffaa7819ULL, 0x000fe400000114aaULL,
0x00000018ffa87819ULL, 0x000fe400000114a8ULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000003900c27306ULL, 0x000fe20000009400ULL, 0x000000e9c600720bULL, 0x002fe20003f5d000ULL,
0x000100003a387824ULL, 0x004fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe2000001145cULL,
0x000100005de97824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fc4000001145dULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000003900c57306ULL, 0x000e620000005400ULL,
0x000000018e8e4812ULL, 0x008fe400078efcffULL, 0x00000018ff757819ULL, 0x010fe40000011460ULL,
0x00000018ffe97819ULL, 0x000fe400000114e9ULL, 0x00000018ff6e7819ULL, 0x000fe20000011461ULL,
0x000000c700c47306ULL, 0x000fe20000209400ULL, 0x00000018ff667819ULL, 0x000fc40000011462ULL,
0x0000008ec38e723eULL, 0x000fe400000010ffULL, 0x00000018ff687819ULL, 0x000fc60000011463ULL,
0x000000c700dd7306ULL, 0x0004e20000205400ULL, 0x000000c5c200720bULL, 0x002fce0003f7d000ULL,
0x000000db00ce7306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x004fce000020d400ULL,
0x000000db00eb7306ULL, 0x0002a20000205400ULL, 0x000000ddc400720bULL, 0x008fe20003fdd000ULL,
0x000100005edd7824ULL, 0x000fca00078e00ffULL, 0x00000018ffdd7819ULL, 0x000fe200000114ddULL,
0x00000039008c7306ULL, 0x000722000000d400ULL, 0x000000db00db7245ULL, 0x002fca000020d400ULL,
0x00000001c7c76812ULL, 0x000fe400078efcffULL, 0x000000cd00657306ULL, 0x000fe20000209400ULL,
0x000001003b397824ULL, 0x008fe200078e00ffULL, 0x000000ebce00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000000cd00cc7306ULL, 0x000e620000205400ULL,
0x000000018c8c3812ULL, 0x010fcc00078efcffULL, 0x00000001dbdb4812ULL, 0x000fe200078efcffULL,
0x000000e800d07306ULL, 0x000ff00000209400ULL, 0x000000e800d57306ULL, 0x000fe20000205400ULL,
0x000000cc6500720bULL, 0x002fe20003fbd000ULL, 0x000100005fcc7824ULL, 0x000fca00078e00ffULL,
0x00000018ffcc7819ULL, 0x000fe200000114ccULL, 0x0000003e00b77306ULL, 0x000ff00000009400ULL,
0x0000003e00ac7306ULL, 0x000ff00000005400ULL, 0x0000003e00807306ULL, 0x0003f0000000d400ULL,
0x0000003a00e57306ULL, 0x000fe20000009400ULL, 0x000001005c3e7824ULL, 0x002fca00078e00ffULL,
0x00000018ffc47819ULL, 0x000fe2000001143eULL, 0x000001005e3e7824ULL, 0x000fe200078e00ffULL,
0x0000003a00d27306ULL, 0x000e700000005400ULL, 0x0000003900e47306ULL, 0x000ff00000209400ULL,
0x0000003900e77306ULL, 0x000ea20000205400ULL, 0x000000d2e500720bULL, 0x002fc40003f9d000ULL,
0x000000e800d27245ULL, 0x000fca000020d400ULL, 0x0000005e00937306ULL, 0x000ff00000009400ULL,
0x0000005e00947306ULL, 0x000fe20000005400ULL, 0x000000e7e400720bULL, 0x004fce0003f7d000ULL,
0x0000005e00747306ULL, 0x0003f0000000d400ULL, 0x000000e200e07306ULL, 0x000fe20000209400ULL,
0x000000cf005e7245ULL, 0x002fc8000020d400ULL, 0x000000015e5e2812ULL, 0x000fe400078efcffULL,
0x000000d5d000720bULL, 0x000fe20003f5d000ULL, 0x000000e200e17306ULL, 0x0003e20000205400ULL,
0x0001000060d57824ULL, 0x000fca00078e00ffULL, 0x00000018ffd57819ULL, 0x000fe400000114d5ULL,
0x0000003800e37306ULL, 0x000fe20000209400ULL, 0x000000e200e27245ULL, 0x002fc6000020d400ULL,
0x00000001d2d22812ULL, 0x000fc800078efcffULL, 0x0000003800e67306ULL, 0x000e700000205400ULL,
0x0000003f00bd7306ULL, 0x000ff00000009400ULL, 0x0000003f00b07306ULL, 0x000fe20000005400ULL,
0x000000e6e300720bULL, 0x002fce0003fdd000ULL, 0x0000003f007a7306ULL, 0x0003f0000000d400ULL,
0x0000003b00b87306ULL, 0x000fe20000009400ULL, 0x000000071f3f7812ULL, 0x002fca00078e7864ULL,
0x0000000864657824ULL, 0x040fe400078e023fULL, 0x0000003b00af7306ULL, 0x000e620000005400ULL,
0x000001005f3f7824ULL, 0x000fe400078e00ffULL, 0x0000000864647824ULL, 0x000fca00078e02edULL,
0x0000003a00877306ULL, 0x000eb0000000d400ULL, 0x0000003c00b37306ULL, 0x000fe20000009400ULL,
0x000000afb800720bULL, 0x002fe40003f5d000ULL, 0x0000003900af7245ULL, 0x000fc4000020d400ULL,
0x000000bb00b87245ULL, 0x000fe4000020d400ULL, 0x00000001afaf3812ULL, 0x000fe200078efcffULL,
0x0000003c00ba7306ULL, 0x000e620000005400ULL, 0x0000000187874812ULL, 0x004fce00078efcffULL,
0x0000005f00957306ULL, 0x000ff00000009400ULL, 0x0000005f00967306ULL, 0x000fe20000005400ULL,
0x000000bab300720bULL, 0x002fe40003f9d000ULL, 0x0000003800b37245ULL, 0x000fc4000020d400ULL,
0x0000a00064387811ULL, 0x000fe400078e20ffULL, 0x00000001b3b36812ULL, 0x000fe200078efcffULL,
0x0000005f00737306ULL, 0x0003f0000000d400ULL, 0x000000c900de7306ULL, 0x000fe20000209400ULL,
0x000000cd005f7245ULL, 0x002fe2000020d400ULL, 0x0000010060cd7824ULL, 0x000fc600078e00ffULL,
0x000000015f5f5812ULL, 0x000fe400078efcffULL, 0x000000e1e000720bULL, 0x000fe20003fbd000ULL,
0x000000c900df7306ULL, 0x0002a20000205400ULL, 0x00000018ffe07819ULL, 0x000fe400000114eaULL,
0x00000018ffcd7819ULL, 0x000fe400000114cdULL, 0x0000005e5f5e723eULL, 0x000fe400000010ffULL,
0x000000d2c75f723eULL, 0x000fe200000010ffULL, 0x000000ad00bf7306ULL, 0x000fe20000209400ULL,
0x000000c900c97245ULL, 0x002fc6000020d400ULL, 0x00000001e2e25812ULL, 0x000fc800078efcffULL,
0x000000ad00be7306ULL, 0x000e620000205400ULL, 0x000000dfde00720bULL, 0x004fce0003f7d000ULL,
0x000000c800ca7306ULL, 0x000fec0000209400ULL, 0x00000001c9c93812ULL, 0x000fe400078efcffULL,
0x000000c800cb7306ULL, 0x000ea20000205400ULL, 0x000000bebf00720bULL, 0x002fce0003fbd000ULL,
0x0000003b00867306ULL, 0x0002f0000000d400ULL, 0x0000003c00847306ULL, 0x000962000000d400ULL,
0x000001003d3b7824ULL, 0x002fe200078e00ffULL, 0x000000cbca00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x000000bb00b57306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x010fe200078e00ffULL, 0x0000000186862812ULL, 0x008fc800078efcffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000000bb00b47306ULL, 0x000e620000205400ULL,
0x0000000184844812ULL, 0x020fe400078efcffULL, 0x000000acb700720bULL, 0x000fe40003f9d000ULL,
0x0000003c00ac7245ULL, 0x000fe4000020d400ULL, 0x00000018ffb77819ULL, 0x000fe2000001143fULL,
0x0000003d00bc7306ULL, 0x000fe20000009400ULL, 0x00000086afaf723eULL, 0x000fce00000010ffULL,
0x0000003d00ab7306ULL, 0x000ea20000005400ULL, 0x000000b4b500720bULL, 0x002fe40003f5d000ULL,
0x000000ad00b47245ULL, 0x000fe4000020d400ULL, 0x00000018ffb57819ULL, 0x000fe4000001143eULL,
0x00000001b4b45812ULL, 0x000fe200078efcffULL, 0x0000003b003a7306ULL, 0x000fe20000209400ULL,
0x000000ae00ad7245ULL, 0x000fe4000020d400ULL, 0x0000000180804812ULL, 0x000fc400078efcffULL,
0x000000b3b4b4723eULL, 0x000fe400000010ffULL, 0x00000001b8b82812ULL, 0x000fe200078efcffULL,
0x0000003b00d37306ULL, 0x000e620000205400ULL, 0x000000abbc00720bULL, 0x004fe40003f7d000ULL,
0x000000c800ab7245ULL, 0x000fc8000020d400ULL, 0x00000001abab6812ULL, 0x000fe200078efcffULL,
0x0000003c00d17306ULL, 0x000ff00000209400ULL, 0x0000003c00dc7306ULL, 0x0004e20000205400ULL,
0x000000d33a00720bULL, 0x002fce0003fbd000ULL, 0x000000ae00b27306ULL, 0x000fe20000209400ULL,
0x0000a000653c7811ULL, 0x004fce00078e20ffULL, 0x000000ae00b97306ULL, 0x000e620000205400ULL,
0x000000dcd100720bULL, 0x008fce0003fdd000ULL, 0x0000003d00837306ULL, 0x000eac000000d400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000d600da7306ULL, 0x000fe20000209400ULL,
0x000000b9b200720bULL, 0x002fe40003f5d000ULL, 0x0000003b00b27245ULL, 0x000fc4000020d400ULL,
0x000000003838783bULL, 0x000fe20000000200ULL, 0x00000002ffb97819ULL, 0x000fe4000001162bULL,
0x000000d6003d7306ULL, 0x0002e20000205400ULL, 0x00000001b2b25812ULL, 0x000fe400078efcffULL,
0x0000000183833812ULL, 0x004fe400078efcffULL, 0x000000b0bd00720bULL, 0x000fe40003f7d000ULL,
0x00000001adad2812ULL, 0x000fe200078efcffULL, 0x0000009b00b17306ULL, 0x000fe20000209400ULL,
0x000000d600d67245ULL, 0x002fc4000020d400ULL, 0x000000acadac723eULL, 0x000fca00000010ffULL,
0x0000009b00b67306ULL, 0x000e620000205400ULL, 0x0000003dda00720bULL, 0x008fe40003fbd000ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x000000017a7a3812ULL, 0x000fc800078efcffULL,
0x0000009c009d7306ULL, 0x000fec0000209400ULL, 0x00000001d6d65812ULL, 0x000fe400078efcffULL,
0x0000009c009e7306ULL, 0x000ea20000205400ULL, 0x000000b6b100720bULL, 0x002fe40003fdd000ULL,
0x00000010ffb6723eULL, 0x000fc400000010ffULL, 0x0000009b00b17245ULL, 0x000fe4000020d400ULL,
0x00005410b6b67816ULL, 0x000fe200000000b6ULL, 0x000000a700d77306ULL, 0x000fe20000209400ULL,
0x000000a8009b7245ULL, 0x000fc6000020d400ULL, 0x00001fb9b6b97589ULL, 0x000e6400000e0000ULL,
0x00000001b1b16812ULL, 0x000fe400078efcffULL, 0x0000009e9d00720bULL, 0x004fe20003fdd000ULL,
0x000000a700d87306ULL, 0x0004e20000205400ULL, 0x00001f0ab69e7589ULL, 0x000f2200000e0000ULL,
0x0000009c009d7245ULL, 0x000fe4000020d400ULL, 0x000000d6b1ad723eULL, 0x000fc800000010ffULL,
0x000000e000e57306ULL, 0x000fe20000209400ULL, 0x000000a700a77245ULL, 0x004fc6000020d400ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x000000949300720bULL, 0x000fe40003fdd000ULL,
0x000000e000e47306ULL, 0x0005620000205400ULL, 0x000000d8d700720bULL, 0x008fe20003f5d000ULL,
0x000000b93c3c9231ULL, 0x082fe200003400ffULL, 0x000000a200937245ULL, 0x000fe2000020d400ULL,
0x000000b93e3e9231ULL, 0x080fe400003400ffULL, 0x000000b938389231ULL, 0x000fc400003400ffULL,
0x000000aa00a97306ULL, 0x000fe20000209400ULL, 0x000000b93a3a9231ULL, 0x000fe200003400ffULL,
0x000000e000e07245ULL, 0x004fe2000020d400ULL, 0x0000009e3d3d9231ULL, 0x090fe200003400ffULL,
0x0000000174746812ULL, 0x000fe200078efcffULL, 0x0000009e3f3f9231ULL, 0x080fe200003400ffULL,
0x00000001a7a72812ULL, 0x000fe200078efcffULL, 0x0000009e39399231ULL, 0x080fe200003400ffULL,
0x000000aa00c07306ULL, 0x0002a20000205400ULL, 0x0000009e3b3b9231ULL, 0x000fe200003400ffULL,
0x000000e4e500720bULL, 0x020fc40003f3d000ULL, 0x0000005e3c50723cULL, 0x000fe20000041850ULL,
0x00000080a780723eULL, 0x000fc600000010ffULL, 0x000000a800d47306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fe4000020d400ULL, 0x00000084ab5e723eULL, 0x000fe200000010ffULL,
0x000000ac3c40723cULL, 0x000fe20000041840ULL, 0x0000008500847245ULL, 0x000fe4000020d400ULL,
0x00000001e0e01812ULL, 0x000fe200078efcffULL, 0x000000a800d97306ULL, 0x000e620000205400ULL,
0x000000c0a900720bULL, 0x004fe40003f5d000ULL, 0x00000083b25f723eULL, 0x000fca00000010ffULL,
0x000000b500bb7306ULL, 0x000fe40000209400ULL, 0x0000005e3c44723cULL, 0x000fe80000041844ULL,
0x00000001aaaa2812ULL, 0x000fe400078efcffULL, 0x000000b500bc7306ULL, 0x000ea20000205400ULL,
0x000000d9d400720bULL, 0x002fe40003fbd000ULL, 0x000000cd005e7245ULL, 0x000fc4000020d400ULL,
0x000000aa9daa723eULL, 0x000fc600000010ffULL, 0x0000005c008f7306ULL, 0x000fec0000009400ULL,
0x000000019b9b5812ULL, 0x000fe400078efcffULL, 0x0000005c00907306ULL, 0x000e620000005400ULL,
0x000000bcbb00720bULL, 0x004fce0003f3d000ULL, 0x0000005d00917306ULL, 0x000ff00000009400ULL,
0x0000005d00927306ULL, 0x000ea20000005400ULL, 0x000000908f00720bULL, 0x002fe40003f7d000ULL,
0x0000009f00907245ULL, 0x000fc4000020d400ULL, 0x0000008cdb8f723eULL, 0x000fc600000010ffULL,
0x0000008500897306ULL, 0x000fe80000209400ULL, 0x0000008e3c54723cULL, 0x000fe80000041854ULL,
0x0000008500887306ULL, 0x0002e20000205400ULL, 0x000000929100720bULL, 0x004fe40003f5d000ULL,
0x0000008d00927245ULL, 0x000fca000020d400ULL, 0x000000c100c27306ULL, 0x000fe20000209400ULL,
0x000000cc00857245ULL, 0x002fce000020d400ULL, 0x000000c100c57306ULL, 0x0002a20000205400ULL,
0x000000888900720bULL, 0x008fe40003fdd000ULL, 0x000000b700887245ULL, 0x000fca000020d400ULL,
0x0000009f00a07306ULL, 0x000fe20000209400ULL, 0x000000c100c17245ULL, 0x002fca000020d400ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x0000009f00a17306ULL, 0x000e620000205400ULL,
0x000000c5c200720bULL, 0x004fce0003fbd000ULL, 0x000000b700ae7306ULL, 0x000fec0000209400ULL,
0x00000001c1c15812ULL, 0x000fe400078efcffULL, 0x000000b700bd7306ULL, 0x000fe20000205400ULL,
0x000000a1a000720bULL, 0x002fce0003f9d000ULL, 0x0000005c00797306ULL, 0x0002ac000000d400ULL,
0x0000000190904812ULL, 0x000fe400078efcffULL, 0x0000005d00767306ULL, 0x000722000000d400ULL,
0x000001005d5c7824ULL, 0x002fe200078e00ffULL, 0x000000c190ab723eULL, 0x000fc800000010ffULL,
0x00000018ffce7819ULL, 0x000fe2000001145cULL, 0x00000100635c7824ULL, 0x000fe200078e00ffULL,
0x0000008d00a57306ULL, 0x000fe20000209400ULL, 0x0000000179793812ULL, 0x004fe200078efcffULL,
0x00000100625d7824ULL, 0x008fe200078e00ffULL, 0x000000969500720bULL, 0x000fe20003f7d000ULL,
0x000000aa3c30723cULL, 0x000fe20000041830ULL, 0x000000ce00917245ULL, 0x000fe4000020d400ULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000008d00a67306ULL, 0x0002a20000205400ULL,
0x0000000176762812ULL, 0x010fc400078efcffULL, 0x00000018ff897819ULL, 0x000fe4000001145cULL,
0x0000007f005c7245ULL, 0x000fc6000020d400ULL, 0x000000c400c67306ULL, 0x000fe20000209400ULL,
0x000000b5008d7245ULL, 0x002fe4000020d400ULL, 0x0000000173733812ULL, 0x000fe400078efcffULL,
0x000000018d8d1812ULL, 0x000fe400078efcffULL, 0x000000bdae00720bULL, 0x000fe20003f3d000ULL,
0x000000c400cf7306ULL, 0x0002e20000205400ULL, 0x000000a6a500720bULL, 0x004fe40003f5d000ULL,
0x00000087e2ae723eULL, 0x000fc400000010ffULL, 0x000000c9b8b5723eULL, 0x000fc600000010ffULL,
0x000000cd009c7306ULL, 0x000fe20000209400ULL, 0x000000c400c47245ULL, 0x002fe2000020d400ULL,
0x000000ae3c4c723cULL, 0x040fe4000004184cULL, 0x0000000188881812ULL, 0x000fe400078efcffULL,
0x0000000192922812ULL, 0x000fe400078efcffULL, 0x000000cd009f7306ULL, 0x000e620000205400ULL,
0x000000cfc600720bULL, 0x008fe20003fbd000ULL, 0x000000b43c48723cULL, 0x000fec0000041848ULL,
0x000000ce00d07306ULL, 0x000fec0000209400ULL, 0x00000001c4c45812ULL, 0x000fc400078efcffULL,
0x000000ce00e17306ULL, 0x000ea20000205400ULL, 0x0000009f9c00720bULL, 0x002fe40003fdd000ULL,
0x00000079c490723eULL, 0x000fca00000010ffULL, 0x000000dd00b07306ULL, 0x000fec0000209400ULL,
0x000000015e5e6812ULL, 0x000fe400078efcffULL, 0x000000dd00a97306ULL, 0x0002e20000205400ULL,
0x000000e1d000720bULL, 0x004fce0003f9d000ULL, 0x0000006000977306ULL, 0x000fe20000009400ULL,
0x000000dd00dd7245ULL, 0x002fca000020d400ULL, 0x0000000191914812ULL, 0x000fe400078efcffULL,
0x0000006000987306ULL, 0x000fe20000005400ULL, 0x000000a9b000720bULL, 0x008fe40003f3d000ULL,
0x000000769191723eULL, 0x000fca00000010ffULL, 0x00000060006f7306ULL, 0x0003e4000000d400ULL,
0x000000903854723cULL, 0x000fe80000041854ULL, 0x00000001dddd1812ULL, 0x000fe400078efcffULL,
0x00000062008b7306ULL, 0x000fe20000009400ULL, 0x0000010061607824ULL, 0x002fe200078e00ffULL,
0x000000dd8484723eULL, 0x000fc800000010ffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x00000062008a7306ULL, 0x000e640000005400ULL, 0x00000060005f7245ULL, 0x000fcc000020d400ULL,
0x000000a200a37306ULL, 0x000ff00000209400ULL, 0x000000a200a47306ULL, 0x000ea20000205400ULL,
0x0000008a8b00720bULL, 0x002fce0003f5d000ULL, 0x0000006000957306ULL, 0x000ff00000209400ULL,
0x0000006000967306ULL, 0x000e620000205400ULL, 0x000000a4a300720bULL, 0x004fce0003fbd000ULL,
0x000000e900ba7306ULL, 0x000fec0000209400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x000000e900bf7306ULL, 0x0004e20000205400ULL, 0x000000969500720bULL, 0x002fe40003fdd000ULL,
0x000000989700720bULL, 0x000fc40003fbd000ULL, 0x000000e093e0723eULL, 0x000fc600000010ffULL,
0x0000007f00827306ULL, 0x000fe20000209400ULL, 0x000000e900e97245ULL, 0x004fca000020d400ULL,
0x000000015f5f6812ULL, 0x000fe400078efcffULL, 0x0000007f00817306ULL, 0x000e620000205400ULL,
0x000000bfba00720bULL, 0x008fe40003f9d000ULL, 0x000000016f6f5812ULL, 0x000fc800078efcffULL,
0x0000006f5e5e723eULL, 0x000fe200000010ffULL, 0x000000cc00a07306ULL, 0x000fec0000209400ULL,
0x00000001e9e94812ULL, 0x000fe400078efcffULL, 0x000000cc00a17306ULL, 0x000ea20000205400ULL,
0x000000818200720bULL, 0x002fc40003f3d000ULL, 0x0000007a9b81723eULL, 0x000fe400000010ffULL,
0x000000e992e1723eULL, 0x000fc600000010ffULL, 0x000000d500947306ULL, 0x000fe40000209400ULL,
0x000000803c34723cULL, 0x000fe80000041834ULL, 0x000000015c5c1812ULL, 0x000fe400078efcffULL,
0x000000d5008b7306ULL, 0x0002e20000205400ULL, 0x000000a1a000720bULL, 0x004fe20003f7d000ULL,
0x000000e03850723cULL, 0x000fe20000041850ULL, 0x00000075003e7245ULL, 0x000fc4000020d400ULL,
0x00000073883d723eULL, 0x000fe400000010ffULL, 0x000000748d3c723eULL, 0x000fe200000010ffULL,
0x0000006100997306ULL, 0x000fe20000009400ULL, 0x000000d500d57245ULL, 0x002fca000020d400ULL,
0x0000000185853812ULL, 0x000fe200078efcffULL, 0x0000003c384c723cULL, 0x000fe2000004184cULL,
0x00000061009a7306ULL, 0x000e620000005400ULL, 0x0000008b9400720bULL, 0x008fe40003fdd000ULL,
0x000000855c85723eULL, 0x000fc600000010ffULL, 0x0000005d003c7245ULL, 0x000fe4000020d400ULL,
0x00000075007b7306ULL, 0x000fe20000209400ULL, 0x00000089003d7245ULL, 0x000fe2000020d400ULL,
0x000000843848723cULL, 0x000fe80000041848ULL, 0x00000001d5d56812ULL, 0x000fe400078efcffULL,
0x00000075007c7306ULL, 0x000ea20000205400ULL, 0x0000009a9900720bULL, 0x002fce0003f9d000ULL,
0x00000061006c7306ULL, 0x0002f0000000d400ULL, 0x00000063007e7306ULL, 0x000fe20000009400ULL,
0x0001000061617824ULL, 0x002fe200078e00ffULL, 0x0000007c7b00720bULL, 0x004fc80003f3d000ULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x00000063007d7306ULL, 0x000e620000005400ULL,
0x000000016c6c4812ULL, 0x008fe400078efcffULL, 0x00000061003f7245ULL, 0x000fe4000020d400ULL,
0x0000006c5f5f723eULL, 0x000fe400000010ffULL, 0x000000013e3e1812ULL, 0x000fe200078efcffULL,
0x0000006e00787306ULL, 0x000fe60000209400ULL, 0x000000d53e3e723eULL, 0x000fe200000010ffULL,
0x0000005e3844723cULL, 0x000fe80000041844ULL, 0x0000006e00777306ULL, 0x0004e20000205400ULL,
0x0000007d7e00720bULL, 0x002fce0003f7d000ULL, 0x0000006600717306ULL, 0x000fe20000209400ULL,
0x0000006e006e7245ULL, 0x004fce000020d400ULL, 0x0000006600727306ULL, 0x000e620000205400ULL,
0x000000777800720bULL, 0x008fce0003fbd000ULL, 0x0000006100877306ULL, 0x000fec0000209400ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x0000006100867306ULL, 0x000ea20000205400ULL,
0x000000727100720bULL, 0x002fce0003fdd000ULL, 0x0000005d00837306ULL, 0x000ff00000209400ULL,
0x0000005d00827306ULL, 0x000e620000205400ULL, 0x000000868700720bULL, 0x004fce0003f9d000ULL,
0x00000062006b7306ULL, 0x0004ec000000d400ULL, 0x000000013f3f4812ULL, 0x000fe400078efcffULL,
0x00000063006a7306ULL, 0x000962000000d400ULL, 0x0001000062627824ULL, 0x004fe200078e00ffULL,
0x000000828300720bULL, 0x002fc40003f3d000ULL, 0x0000003f6e3f723eULL, 0x000fe400000010ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000089007d7306ULL, 0x000fe20000209400ULL,
0x0001000063637824ULL, 0x010fe200078e00ffULL, 0x000000016b6b2812ULL, 0x008fe200078efcffULL,
0x0000003e3840723cULL, 0x000fe60000041840ULL, 0x00000018ff637819ULL, 0x000fc40000011463ULL,
0x00000089007a7306ULL, 0x000e620000205400ULL, 0x000000013c3c1812ULL, 0x000fe400078efcffULL,
0x00000066003f7245ULL, 0x000fe4000020d400ULL, 0x000000016a6a3812ULL, 0x020fe400078efcffULL,
0x000000013f3f6812ULL, 0x000fe200078efcffULL, 0x00000068006d7306ULL, 0x000fe20000209400ULL,
0x0000006b3c3c723eULL, 0x000fce00000010ffULL, 0x0000006800707306ULL, 0x0004e20000205400ULL,
0x0000007a7d00720bULL, 0x002fce0003fbd000ULL, 0x0000006200607306ULL, 0x000fe20000209400ULL,
0x0000006800687245ULL, 0x004fca000020d400ULL, 0x000000013d3d5812ULL, 0x000fe400078efcffULL,
0x0000006200777306ULL, 0x0002a20000205400ULL, 0x000000706d00720bULL, 0x008fe40003f9d000ULL,
0x0000006a3d3d723eULL, 0x000fca00000010ffULL, 0x0000006300737306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x002fe2000020d400ULL, 0x0000003c3834723cULL, 0x000fe80000041834ULL,
0x0000000168684812ULL, 0x000fe400078efcffULL, 0x0000006300727306ULL, 0x0002e20000205400ULL,
0x000000776000720bULL, 0x004fe40003f3d000ULL, 0x0000006300637245ULL, 0x002fd6000020d400ULL,
0x0000000162621812ULL, 0x000fe400078efcffULL, 0x000000727300720bULL, 0x008fe40003f5d000ULL,
0x000000623f62723eULL, 0x000fd600000010ffULL, 0x0000000163632812ULL, 0x000fc800078efcffULL,
0x000000636863723eULL, 0x000fce00000010ffULL, 0x000000623838723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000405b307811ULL, 0x000fe200078e40ffULL, 0x01061000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff69ff7812ULL, 0x000fe4000782c0ffULL, 0x000000305900720cULL, 0x000fe40003f44070ULL,
0x00000001ff697807ULL, 0x000fd60000800000ULL, 0x0000e2b00000a947ULL, 0x000fea0003800000ULL,
0x01065c00ff2f7984ULL, 0x000e640000000800ULL, 0x800000002fff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff2f7984ULL, 0x000e640000000800ULL, 0x800000002fff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL, 0x0000002f00307305ULL, 0x0002a4000021f000ULL,
0x3fa000002f2f7823ULL, 0x002fe200000100ffULL, 0x000000300000735dULL, 0x004fe40003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000004ff317424ULL, 0x000fe200078e00ffULL, 0x0000000367307812ULL, 0x000fe200078ec0ffULL,
0x00000300ff327624ULL, 0x000fe400078e00ffULL, 0x000000042d3c7e24ULL, 0x000fe2000f8e022aULL,
0x000000033000780cULL, 0x000fe20003f25270ULL, 0xfffffffd312f7424ULL, 0x000fe200078e0232ULL,
0xfffffffd32687811ULL, 0x000fe200078e10ffULL, 0xffffffffff2d7424ULL, 0x000fc600078e00ffULL,
0x000000012f307807ULL, 0x000fca0004800000ULL, 0x0000000167677824ULL, 0x000fca00078e0230ULL,
0x00000003672f7812ULL, 0x000fc800078ec0ffULL, 0x000000032f00780cULL, 0x000fc80003f25270ULL,
0x0000000168687807ULL, 0x000fca0004800000ULL, 0x00000001672f7824ULL, 0x000fca00078e0268ULL,
0x000000582f00720cULL, 0x000fe40003f26070ULL, 0x000000605b327811ULL, 0x000fc800078e40ffULL,
0x0000003259337217ULL, 0x000fe40007800000ULL, 0x000000203c3e7810ULL, 0x000fc60007ffe0ffULL,
0x0000000133337824ULL, 0x000fe400078e0a32ULL, 0x0000006826309210ULL, 0x000fe20007ffe067ULL,
0x00000100ff5f7424ULL, 0x000fe400078e00ffULL, 0x000000011e327824ULL, 0x000fe400078e023eULL,
0x0000600030309625ULL, 0x000fe200078e0031ULL, 0x00000020333d7807ULL, 0x000fc60000000000ULL,
0x00000001193c7824ULL, 0x100fe200078e023eULL, 0x00000006302d9981ULL, 0x000362000c1e1900ULL,
0x00000001185c7824ULL, 0x000fe200078e023eULL, 0x00000004ff5d7819ULL, 0x000fe2000001162bULL,
0x00005e0032327625ULL, 0x000fc800078e005fULL, 0x0000000117607824ULL, 0x000fe400078e023eULL,
0x00005e005c3e7625ULL, 0x000fe200078e005fULL, 0x0000003d2c317217ULL, 0x002fe40007800000ULL,
0x0000002132307210ULL, 0x000fe20007f3e0ffULL, 0x00005e003c3c7625ULL, 0x000fc800078e005fULL,
0x00000001315e7824ULL, 0x000fe200078e0a2cULL, 0x000000213c327210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200008e0633ULL, 0x000000213e3c7210ULL, 0x000fe40007f9e0ffULL,
0x0000005e5d00720cULL, 0x080fe20003f46070ULL, 0x00005e00605c7625ULL, 0x000fe200078e005fULL,
0x0000005e2000720cULL, 0x000fc60003f26070ULL, 0x000000ffff337224ULL, 0x000fe200018e063dULL,
0x0000005e1f00720cULL, 0x080fe20003f66070ULL, 0x000000ffff3d7224ULL, 0x000fe200020e063fULL,
0x0000005e1d00720cULL, 0x000fe40003f86070ULL, 0x000000215c3e7210ULL, 0x000fc60007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030167faeULL, 0x0003e4000d101c46ULL,
0x000000ffff3f7224ULL, 0x000fe400028e065dULL, 0x0000000032157faeULL, 0x0003e8000c901c46ULL,
0x000000003c147faeULL, 0x0003e8000d901c46ULL, 0x000000003e137faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff317984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01061c00ff327984ULL, 0x000ea20000000800ULL,
0x000000ff23ff7812ULL, 0x000fe2000782c0ffULL, 0x8000000012337824ULL, 0x000fc600078e00ffULL,
0x00000001ff667807ULL, 0x000fca0000800000ULL, 0x8000000066307824ULL, 0x000fca00078e00ffULL,
0x8000000031ff7812ULL, 0x002fe40007824830ULL, 0x8000000032ff7812ULL, 0x004fe20007844833ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fe400078e00ffULL, 0x8000000012327824ULL, 0x000fe400078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01061c00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844832ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0100800011307984ULL, 0x000e620000000800ULL,
0x00000001ff8d7424ULL, 0x000fc600078e00ffULL, 0x0102800011317984ULL, 0x0004e20000000800ULL,
0x000000293000720bULL, 0x002fda0003f5d000ULL, 0x0000000000327806ULL, 0x000fc800010e0100ULL,
0x0000ffff323c7812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x000000293000720bULL, 0x00cfe40003f54000ULL, 0x0000003029327209ULL, 0x000fe40007810000ULL,
0x00000002ff3e7819ULL, 0x000fc6000001162bULL, 0x8000003229337221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b33337820ULL, 0x000fe40000410000ULL, 0x0000000000297806ULL, 0x000fe400010e0100ULL,
0x000000015a00780cULL, 0x000fe40003f45270ULL, 0x0000ffff293d7812ULL, 0x000fe200078e3cffULL,
0x0000003300337308ULL, 0x000e660000000800ULL, 0x0000003d3cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff8d7807ULL, 0x000fc60001800000ULL, 0x010480321100a388ULL, 0x000fe80000000800ULL,
0x00001f3e33297589ULL, 0x002e6400000e0000ULL, 0x80000032303c3221ULL, 0x000fe20000010000ULL,
0x0000003328287220ULL, 0x000fe20000410000ULL, 0x00001f0a33307589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b3c3c3820ULL, 0x000fc80000410000ULL, 0x0000003c00103308ULL, 0x000ee20000000800ULL,
0x0000002954547220ULL, 0x082fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x000000294c4c7220ULL, 0x080fe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x000fe20000410000ULL,
0x0000003056567220ULL, 0x084fe20000410000ULL, 0x0000003057577220ULL, 0x080fe20000410000ULL,
0x0000003052527220ULL, 0x080fe20000410000ULL, 0x0000003053537220ULL, 0x080fe20000410000ULL,
0x000000304e4e7220ULL, 0x080fe20000410000ULL, 0x000000304f4f7220ULL, 0x080fe20000410000ULL,
0x000000304a4a7220ULL, 0x080fe20000410000ULL, 0x000000304b4b7220ULL, 0x080fe20000410000ULL,
0x0000003046467220ULL, 0x080fe20000410000ULL, 0x0000003047477220ULL, 0x080fe20000410000ULL,
0x0000003042427220ULL, 0x080fe20000410000ULL, 0x0000003043437220ULL, 0x080fe20000410000ULL,
0x0000003036367220ULL, 0x080fe20000410000ULL, 0x0000003037377220ULL, 0x080fe20000410000ULL,
0x000000303a3a7220ULL, 0x080fe20000410000ULL, 0x000000303b3b7220ULL, 0x000fe20000410000ULL,
0x000000ffff297224ULL, 0x000fe200078e0032ULL, 0x0000003110313220ULL, 0x008fc80000410000ULL,
0x0000002831287221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff307984ULL, 0x000e620000000800ULL, 0x8000000066317824ULL, 0x000fca00078e00ffULL,
0x8000000030ff7812ULL, 0x002fe20007824831ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fe400078e00ffULL,
0x8000000066327824ULL, 0x000fe400078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01064c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000000f30783bULL, 0x000e680000004200ULL, 0x000000000d5c783bULL, 0x000fe80000004200ULL,
0x000000000e3c783bULL, 0x000ea80000004200ULL, 0x000000000c60783bULL, 0x000ee20000004200ULL,
0x0000010030e07824ULL, 0x042fe200078e00ffULL, 0x0000003000d07306ULL, 0x000fe20000009400ULL,
0x00000018ffe17819ULL, 0x000fe20000011430ULL, 0x0000010031e77824ULL, 0x040fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe20000011431ULL, 0x0001000030e87824ULL, 0x000fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x0000010032c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x0000003000d17306ULL, 0x000e620000005400ULL,
0x00000018ffe87819ULL, 0x000fe200000114e8ULL, 0x0001000031d37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000001003dbf7824ULL, 0x044fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe2000001145fULL, 0x000100003dcb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011432ULL, 0x000000e000d87306ULL, 0x000fe20000209400ULL,
0x00000018ffa97819ULL, 0x000fe20000011433ULL, 0x000001003ece7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe2000001143cULL, 0x000100003fe27824ULL, 0x040fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x000001003fd27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe2000001143dULL, 0x000000e000d97306ULL, 0x000ea20000205400ULL,
0x000000d1d000720bULL, 0x002fc40003fbd000ULL, 0x00000018ffbf7819ULL, 0x000fe400000114bfULL,
0x00000018ff867819ULL, 0x000fe4000001145eULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x000000e100df7306ULL, 0x000fe20000209400ULL, 0x00000018ff987819ULL, 0x000fe4000001143fULL,
0x00000018ffce7819ULL, 0x000fe400000114ceULL, 0x00000018ffad7819ULL, 0x000fc4000001143eULL,
0x00000018ff927819ULL, 0x000fe2000001145cULL, 0x000000e100dc7306ULL, 0x000e620000205400ULL,
0x000000d9d800720bULL, 0x004fe40003f7d000ULL, 0x00000018ffd87819ULL, 0x000fe200000114e2ULL,
0x000100005de27824ULL, 0x000fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fe400000114d2ULL,
0x00000018ff937819ULL, 0x000fe2000001145dULL, 0x0000003200c27306ULL, 0x000fe20000009400ULL,
0x00000018ffe27819ULL, 0x000fc400000114e2ULL, 0x00000018ff787819ULL, 0x008fe40000011460ULL,
0x00000018ff717819ULL, 0x000fe40000011461ULL, 0x00000018ff697819ULL, 0x000fe20000011462ULL,
0x0000003200dd7306ULL, 0x000ea20000005400ULL, 0x000000dcdf00720bULL, 0x002fe20003f5d000ULL,
0x000100005edf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fc80000011463ULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x0000003000957306ULL, 0x0002f0000000d400ULL,
0x000000e700e37306ULL, 0x000fe20000209400ULL, 0x0000010033307824ULL, 0x002fe200078e00ffULL,
0x000000ddc200720bULL, 0x004fe20003f3d000ULL, 0x000001005edd7824ULL, 0x000fe200078e00ffULL,
0x000000e000c27245ULL, 0x000fe2000020d400ULL, 0x000100005fe07824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fc40000011430ULL, 0x000000e700ea7306ULL, 0x0002a20000205400ULL,
0x0000000195955812ULL, 0x008fe400078efcffULL, 0x00000001c2c23812ULL, 0x000fe400078efcffULL,
0x00000018ffdd7819ULL, 0x000fe400000114ddULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x000000e800de7306ULL, 0x000fe20000209400ULL, 0x000000e700e77245ULL, 0x002fce000020d400ULL,
0x000000e800eb7306ULL, 0x000e620000205400ULL, 0x000000eae300720bULL, 0x004fce0003fbd000ULL,
0x0000003100d67306ULL, 0x000fec0000009400ULL, 0x00000001e7e75812ULL, 0x000fe400078efcffULL,
0x0000003100d57306ULL, 0x000ea20000005400ULL, 0x000000ebde00720bULL, 0x002fe20003f7d000ULL,
0x000001005fde7824ULL, 0x000fc400078e00ffULL, 0x000001005deb7824ULL, 0x000fc600078e00ffULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x000000c300e47306ULL, 0x000ff00000209400ULL,
0x000000c300e57306ULL, 0x0003e20000205400ULL, 0x000000d5d600720bULL, 0x004fce0003fdd000ULL,
0x000000bc00db7306ULL, 0x000fe20000209400ULL, 0x000000c300c37245ULL, 0x002fce000020d400ULL,
0x000000bc00da7306ULL, 0x0002b00000205400ULL, 0x00000031008e7306ULL, 0x000722000000d400ULL,
0x000000bc00bc7245ULL, 0x002fce000020d400ULL, 0x0000003300c17306ULL, 0x000fe20000009400ULL,
0x0001000032317824ULL, 0x008fe200078e00ffULL, 0x000000dadb00720bULL, 0x004fe20003f9d000ULL,
0x000001005cdb7824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003300c47306ULL, 0x000e620000005400ULL, 0x000000018e8e6812ULL, 0x010fe400078efcffULL,
0x00000018ffdb7819ULL, 0x000fc800000114dbULL, 0x00000001bcbc4812ULL, 0x000fe200078efcffULL,
0x0000003000d47306ULL, 0x000ff00000209400ULL, 0x0000003000d77306ULL, 0x000ea20000205400ULL,
0x000000c4c100720bULL, 0x002fc40003fbd000ULL, 0x00000018ffc17819ULL, 0x000fca00000114ebULL,
0x0000005f00917306ULL, 0x000ff00000009400ULL, 0x0000005f00907306ULL, 0x000fe20000005400ULL,
0x000000d7d400720bULL, 0x004fce0003fdd000ULL, 0x0000005f00767306ULL, 0x0003f0000000d400ULL,
0x0000003200887306ULL, 0x0004e2000000d400ULL, 0x000000e1005f7245ULL, 0x002fc8000020d400ULL,
0x000000015f5f2812ULL, 0x000fe400078efcffULL, 0x000000e5e400720bULL, 0x000fe20003f5d000ULL,
0x0000003100c57306ULL, 0x000fe20000209400ULL, 0x0001000033327824ULL, 0x004fe400078e00ffULL,
0x0000010060e47824ULL, 0x000fe400078e00ffULL, 0x0000010061e57824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003100ca7306ULL, 0x000e620000205400ULL,
0x0000000188881812ULL, 0x008fc400078efcffULL, 0x00000018ffe47819ULL, 0x000fe400000114e4ULL,
0x00000001c3c32812ULL, 0x000fe400078efcffULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x000000a300bb7306ULL, 0x000fe20000209400ULL, 0x00000088c388723eULL, 0x000fce00000010ffULL,
0x000000a300b87306ULL, 0x0004e20000205400ULL, 0x000000cac500720bULL, 0x002fce0003f5d000ULL,
0x0000003300877306ULL, 0x000322000000d400ULL, 0x000000a300a37245ULL, 0x004fce000020d400ULL,
0x000000a9009f7306ULL, 0x000fe20000209400ULL, 0x000001003c337824ULL, 0x002fe200078e00ffULL,
0x000000b8bb00720bULL, 0x008fe40003f9d000ULL, 0x0000003000b87245ULL, 0x000fe4000020d400ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x000000a9009a7306ULL, 0x000e620000205400ULL,
0x0000000187875812ULL, 0x010fe400078efcffULL, 0x00000001b8b86812ULL, 0x000fc800078efcffULL,
0x00000001a3a34812ULL, 0x000fe200078efcffULL, 0x0000003d00b77306ULL, 0x000ff00000009400ULL,
0x0000003d00b67306ULL, 0x000ea20000005400ULL, 0x0000009a9f00720bULL, 0x002fc40003fbd000ULL,
0x00000032009a7245ULL, 0x000fca000020d400ULL, 0x0000003200c67306ULL, 0x000ff00000209400ULL,
0x0000003200c77306ULL, 0x000e620000205400ULL, 0x000000b6b700720bULL, 0x004fe40003f3d000ULL,
0x0000003100b67245ULL, 0x000fc4000020d400ULL, 0x000000a900b77245ULL, 0x000fe4000020d400ULL,
0x00000001b6b62812ULL, 0x000fe200078efcffULL, 0x0000003c00b97306ULL, 0x000fe20000009400ULL,
0x00000001b7b75812ULL, 0x000fe400078efcffULL, 0x000000b6a3b6723eULL, 0x000fca00000010ffULL,
0x0000003c00ba7306ULL, 0x000fe20000005400ULL, 0x000000c7c600720bULL, 0x002fce0003fdd000ULL,
0x0000003c00857306ULL, 0x0003ec000000d400ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000003300bd7306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x002fe200078e00ffULL,
0x0000009ab7b7723eULL, 0x000fc800000010ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003300be7306ULL, 0x000e700000205400ULL, 0x0000003d00827306ULL, 0x000eb0000000d400ULL,
0x000000d300e67306ULL, 0x000fe20000209400ULL, 0x000000bebd00720bULL, 0x002fce0003f5d000ULL,
0x000000d300e97306ULL, 0x0003e20000205400ULL, 0x0000000182821812ULL, 0x004fce00078efcffULL,
0x0000003c00c87306ULL, 0x000fe20000209400ULL, 0x000000d300d37245ULL, 0x002fce000020d400ULL,
0x0000003c003d7306ULL, 0x000e700000205400ULL, 0x0000003e00a17306ULL, 0x000ff00000009400ULL,
0x0000003e00a67306ULL, 0x000ea20000005400ULL, 0x0000003dc800720bULL, 0x002fce0003fbd000ULL,
0x000000b400a07306ULL, 0x000ff00000209400ULL, 0x000000b4009b7306ULL, 0x0002e20000205400ULL,
0x000000a6a100720bULL, 0x004fe40003fdd000ULL, 0x0000003300a67245ULL, 0x000fc4000020d400ULL,
0x0000009800a17245ULL, 0x000fe4000020d400ULL, 0x00000001a6a62812ULL, 0x000fe200078efcffULL,
0x000000bf00c07306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fce000020d400ULL,
0x000000bf00c97306ULL, 0x0002a20000205400ULL, 0x0000009ba000720bULL, 0x008fe40003f5d000ULL,
0x0000003c009b7245ULL, 0x000fe4000020d400ULL, 0x0000a8000b3c7811ULL, 0x000fe400078e20ffULL,
0x000000019b9b5812ULL, 0x000fe200078efcffULL, 0x0000005e009c7306ULL, 0x000fe20000009400ULL,
0x000000bf00bf7245ULL, 0x002fe4000020d400ULL, 0x000000d100a07245ULL, 0x000fc6000020d400ULL,
0x00000001b4b42812ULL, 0x000fe400078efcffULL, 0x0000005e00ab7306ULL, 0x000fe20000005400ULL,
0x000000c9c000720bULL, 0x004fe40003f9d000ULL, 0x0000009bb4b4723eULL, 0x000fca00000010ffULL,
0x0000005e00757306ULL, 0x0003ec000000d400ULL, 0x00000001bfbf4812ULL, 0x000fe400078efcffULL,
0x0000003f00b57306ULL, 0x000fe20000009400ULL, 0x000000e8005e7245ULL, 0x002fc8000020d400ULL,
0x000000015e5e3812ULL, 0x000fe400078efcffULL, 0x000000e9e600720bULL, 0x000fe20003f7d000ULL,
0x0000003f00a27306ULL, 0x000e620000005400ULL, 0x0000005e5f5e723eULL, 0x000fce00000010ffULL,
0x000000cb00cc7306ULL, 0x000fe80000209400ULL, 0x00000001d3d33812ULL, 0x000fe400078efcffULL,
0x000000bab900720bULL, 0x000fe40003f7d000ULL, 0x000000cb00cd7306ULL, 0x000ea20000205400ULL,
0x000000a2b500720bULL, 0x002fe40003fbd000ULL, 0x000000cb00b57245ULL, 0x000fc4000020d400ULL,
0x000000d3bc5f723eULL, 0x000fc600000010ffULL, 0x0000003f007f7306ULL, 0x000e66000000d400ULL,
0x0000000185853812ULL, 0x000fc800078efcffULL, 0x00000085a6a6723eULL, 0x000fe200000010ffULL,
0x000000b2009d7306ULL, 0x000fe20000209400ULL, 0x000000cdcc00720bULL, 0x004fce0003f9d000ULL,
0x000000b200a47306ULL, 0x0004e20000205400ULL, 0x000000017f7f5812ULL, 0x002fca00078efcffULL,
0x00000001b5b54812ULL, 0x000fe400078efcffULL, 0x0000009800af7306ULL, 0x000fe20000209400ULL,
0x000000b200b27245ULL, 0x004fce000020d400ULL, 0x00000098009e7306ULL, 0x000e620000205400ULL,
0x000000a49d00720bULL, 0x008fe40003f7d000ULL, 0x000000ce009d7245ULL, 0x000fca000020d400ULL,
0x000000ce00cf7306ULL, 0x000fec0000209400ULL, 0x00000001b2b23812ULL, 0x000fe400078efcffULL,
0x000000ce00d07306ULL, 0x000ea20000205400ULL, 0x0000009eaf00720bULL, 0x002fe40003fbd000ULL,
0x000000ad009e7245ULL, 0x000fc4000020d400ULL, 0x000000b5b2b5723eULL, 0x000fc600000010ffULL,
0x0000003e00807306ULL, 0x0002ec000000d400ULL, 0x00000001a1a15812ULL, 0x000fe400078efcffULL,
0x0000005c00b07306ULL, 0x000fe20000009400ULL, 0x000100003e3e7824ULL, 0x002fe200078e00ffULL,
0x000000d0cf00720bULL, 0x004fc80003f3d000ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000005c00a77306ULL, 0x000e620000005400ULL, 0x0000000180806812ULL, 0x008fe400078efcffULL,
0x0000003e009f7245ULL, 0x000fc8000020d400ULL, 0x000000019d9d1812ULL, 0x000fe200078efcffULL,
0x000000d800d97306ULL, 0x000ff00000209400ULL, 0x000000d800da7306ULL, 0x0004e20000205400ULL,
0x000000a7b000720bULL, 0x002fce0003f9d000ULL, 0x0000005c007c7306ULL, 0x000322000000d400ULL,
0x000000d800d87245ULL, 0x004fce000020d400ULL, 0x0000009200a87306ULL, 0x000fe20000209400ULL,
0x000100005c5c7824ULL, 0x002fe200078e00ffULL, 0x000000dad900720bULL, 0x008fc80003fdd000ULL,
0x00000018ffe17819ULL, 0x000fe2000001145cULL, 0x00000100635c7824ULL, 0x000fe200078e00ffULL,
0x0000009200997306ULL, 0x0002a20000205400ULL, 0x000000017c7c4812ULL, 0x010fcc00078efcffULL,
0x00000001d8d86812ULL, 0x000fe200078efcffULL, 0x0000003e00d67306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fce000020d400ULL, 0x0000003e003f7306ULL, 0x000e620000205400ULL,
0x00000099a800720bULL, 0x004fce0003fbd000ULL, 0x000000ad00b37306ULL, 0x000fec0000209400ULL,
0x0000000192925812ULL, 0x000fe400078efcffULL, 0x000000ad00aa7306ULL, 0x000ea20000205400ULL,
0x0000003fd600720bULL, 0x002fe40003f7d000ULL, 0x000000003c3c783bULL, 0x000fea0000000200ULL,
0x000000e100e67306ULL, 0x000fec0000209400ULL, 0x000000019f9f3812ULL, 0x000fc400078efcffULL,
0x000000e100e97306ULL, 0x0002e20000205400ULL, 0x000000aab300720bULL, 0x004fce0003f3d000ULL,
0x000000c100c47306ULL, 0x000fe20000209400ULL, 0x000000e100e17245ULL, 0x002fca000020d400ULL,
0x000000019e9e1812ULL, 0x000fe400078efcffULL, 0x000000c100b97306ULL, 0x000e620000205400ULL,
0x000000e9e600720bULL, 0x008fe40003fdd000ULL, 0x000000ab9c00720bULL, 0x000fe40003f3d000ULL,
0x000000c1009c7245ULL, 0x000fe4000020d400ULL, 0x0000009f9e9e723eULL, 0x000fe200000010ffULL,
0x000000db00dc7306ULL, 0x000fe20000209400ULL, 0x000000d8a19f723eULL, 0x000fca00000010ffULL,
0x00000001e1e16812ULL, 0x000fe400078efcffULL, 0x000000db00e37306ULL, 0x0004e20000205400ULL,
0x000000b9c400720bULL, 0x002fe40003f9d000ULL, 0x0000000175751812ULL, 0x000fe400078efcffULL,
0x000000e19292723eULL, 0x000fc600000010ffULL, 0x000000dd00327306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x004fca000020d400ULL, 0x000000019c9c4812ULL, 0x000fe400078efcffULL,
0x000000dd00337306ULL, 0x000e620000205400ULL, 0x000000e3dc00720bULL, 0x008fe40003f7d000ULL,
0x000000909100720bULL, 0x000fe40003f9d000ULL, 0x000000dd00907245ULL, 0x000fc6000020d400ULL,
0x000000d100d27306ULL, 0x000fec0000209400ULL, 0x00000001dbdb3812ULL, 0x000fe400078efcffULL,
0x000000d100d57306ULL, 0x000ea20000205400ULL, 0x000000333200720bULL, 0x002fe40003fbd000ULL,
0x000099108d337816ULL, 0x000fc400000000ffULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x0000007cdb7c723eULL, 0x000fe200000010ffULL, 0x000000e200307306ULL, 0x000fec0000209400ULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x000000e200317306ULL, 0x0002e20000205400ULL,
0x000000d5d200720bULL, 0x004fce0003f5d000ULL, 0x0000009300ac7306ULL, 0x000fe20000209400ULL,
0x000000e200e27245ULL, 0x002fca000020d400ULL, 0x00000001a0a02812ULL, 0x000fe400078efcffULL,
0x0000009300a57306ULL, 0x0002a20000205400ULL, 0x000000313000720bULL, 0x008fe40003fdd000ULL,
0x00000010ff30723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe4000001162bULL,
0x0000541030327816ULL, 0x000fe20000000030ULL, 0x000000de00a47306ULL, 0x000fe20000209400ULL,
0x000000ffff307224ULL, 0x000fe200078e0033ULL, 0x0000009300937245ULL, 0x002fc4000020d400ULL,
0x00001f31328d7589ULL, 0x0002e200000e0000ULL, 0x0000007fa07f723eULL, 0x000fe400000010ffULL,
0x00000001e2e26812ULL, 0x000fe200078efcffULL, 0x000000de00a97306ULL, 0x000f220000205400ULL,
0x000000a5ac00720bULL, 0x004fe20003f7d000ULL, 0x00001f0a32987589ULL, 0x000ea200000e0000ULL,
0x0000008ee731723eULL, 0x002fca00000010ffULL, 0x0000005d00ae7306ULL, 0x000fec0000009400ULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x0000005d00b17306ULL, 0x000e620000005400ULL,
0x000000a9a400720bULL, 0x010fe40003fbd000ULL, 0x000000e29393723eULL, 0x000fca00000010ffULL,
0x00000086008c7306ULL, 0x000ff00000209400ULL, 0x00000086008b7306ULL, 0x0008a20000205400ULL,
0x000000b1ae00720bULL, 0x002fce0003f5d000ULL, 0x00000060008f7306ULL, 0x000fe20000009400ULL,
0x0000008600867245ULL, 0x010fce000020d400ULL, 0x0000006000947306ULL, 0x000e620000005400ULL,
0x0000008b8c00720bULL, 0x004fce0003f3d000ULL, 0x0000005d007b7306ULL, 0x00052c000000d400ULL,
0x0000000186861812ULL, 0x000fe400078efcffULL, 0x000000df00a27306ULL, 0x000fe20000209400ULL,
0x000000948f00720bULL, 0x002fe20003fdd000ULL, 0x00000100625d7824ULL, 0x004fe200078e00ffULL,
0x000000de008f7245ULL, 0x000fc8000020d400ULL, 0x000000018f8f5812ULL, 0x000fe200078efcffULL,
0x000000df00a77306ULL, 0x0002a20000205400ULL, 0x000000017b7b2812ULL, 0x010fe400078efcffULL,
0x000000ff3000720cULL, 0x000fe40003f45270ULL, 0x00000095c230723eULL, 0x000fe400000010ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x000000e400a57306ULL, 0x000fe20000209400ULL,
0x000000df00df7245ULL, 0x002fc4000020d400ULL, 0x000000768f8f723eULL, 0x000fca00000010ffULL,
0x000000e400a87306ULL, 0x0003220000205400ULL, 0x000000a7a200720bULL, 0x004fe20003fbd000ULL,
0x0000008d3c3ca231ULL, 0x088fe200003400ffULL, 0x00000082bfa7723eULL, 0x000fe200000010ffULL,
0x0000008d3e3ea231ULL, 0x000fe400003400ffULL, 0x000000983d3da231ULL, 0x080fe400003400ffULL,
0x00000060006f7306ULL, 0x0004e2000000d400ULL, 0x000000e400e47245ULL, 0x002fe2000020d400ULL,
0x000000983f3fa231ULL, 0x000fc800003400ffULL, 0x00000001dfdf5812ULL, 0x000fe400078efcffULL,
0x00000083008a7306ULL, 0x000fe20000209400ULL, 0x0001000060607824ULL, 0x004fe200078e00ffULL,
0x000000a8a500720bULL, 0x010fe20003f3d000ULL, 0x0000005e3c50723cULL, 0x000fe20000041850ULL,
0x000000df8686723eULL, 0x000fe400000010ffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000008300897306ULL, 0x0002a20000205400ULL, 0x000000016f6f6812ULL, 0x008fc400078efcffULL,
0x00000083005e7245ULL, 0x000fe2000020d400ULL, 0x000000303c54723cULL, 0x040fe60000041854ULL,
0x00000001e4e41812ULL, 0x000fe200078efcffULL, 0x000000e000aa7306ULL, 0x000fe20000209400ULL,
0x00000018ff837819ULL, 0x002fe4000001145cULL, 0x0000a80009307811ULL, 0x000fe200078e20ffULL,
0x000000b63c48723cULL, 0x000fe20000041848ULL, 0x0000006fe4e4723eULL, 0x000fc600000010ffULL,
0x000000e000997306ULL, 0x000e620000205400ULL, 0x000000898a00720bULL, 0x004fe20003f9d000ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x00000087b889723eULL, 0x000fe200000010ffULL,
0x000000a63c44723cULL, 0x000fe20000041844ULL, 0x000000e000877245ULL, 0x000fc6000020d400ULL,
0x000000e500917306ULL, 0x000fe80000209400ULL, 0x000000883c4c723cULL, 0x000fe4000004184cULL,
0x000000015e5e4812ULL, 0x000fe400078efcffULL, 0x000000e500947306ULL, 0x0007220000205400ULL,
0x00000099aa00720bULL, 0x002fc60003fbd000ULL, 0x000000b43c40723cULL, 0x000fe80000041840ULL,
0x00000060008e7306ULL, 0x000fe20000209400ULL, 0x000000e500e57245ULL, 0x008fca000020d400ULL,
0x0000000187875812ULL, 0x000fe400078efcffULL, 0x00000060008b7306ULL, 0x0002e20000205400ULL,
0x000000949100720bULL, 0x010fe40003f3d000ULL, 0x000000875e87723eULL, 0x000fca00000010ffULL,
0x00000063007e7306ULL, 0x000fe20000009400ULL, 0x0000006000607245ULL, 0x002fe2000020d400ULL,
0x0000008d3030a231ULL, 0x084fe400003400ffULL, 0x0000008d3232a231ULL, 0x000fe400003400ffULL,
0x00000001e5e51812ULL, 0x000fe200078efcffULL, 0x000000983131a231ULL, 0x080fe200003400ffULL,
0x00000063007d7306ULL, 0x000e620000005400ULL, 0x0000008b8e00720bULL, 0x008fe20003fdd000ULL,
0x000000983333a231ULL, 0x000fe200003400ffULL, 0x00000075908e723eULL, 0x000fca00000010ffULL,
0x0000006100967306ULL, 0x000fe20000009400ULL, 0x000000923050723cULL, 0x040fea0000041850ULL,
0x0000000160606812ULL, 0x000fe400078efcffULL, 0x0000006100977306ULL, 0x000ea20000005400ULL,
0x0000007d7e00720bULL, 0x002fe20003f9d000ULL, 0x0000008e304c723cULL, 0x000fe2000004184cULL,
0x000000809d7e723eULL, 0x000fc400000010ffULL, 0x0000007b9c7d723eULL, 0x000fc600000010ffULL,
0x0000006200847306ULL, 0x000fe40000009400ULL, 0x0000007e3c34723cULL, 0x040fec0000041834ULL,
0x0000006200817306ULL, 0x000e620000005400ULL, 0x000000979600720bULL, 0x004fe20003f7d000ULL,
0x0000009e3c3c723cULL, 0x000fec0000041838ULL, 0x00000078007a7306ULL, 0x000fe20000209400ULL,
0x0000007800397245ULL, 0x000fe2000020d400ULL, 0x0000007c3054723cULL, 0x000fe20000041854ULL,
0x0000007100387245ULL, 0x000fc4000020d400ULL, 0x0000005d003a7245ULL, 0x000fc6000020d400ULL,
0x0000007800797306ULL, 0x000ea20000205400ULL, 0x000000818400720bULL, 0x002fe20003fbd000ULL,
0x000000863048723cULL, 0x000fec0000041848ULL, 0x0000007100747306ULL, 0x000ff00000209400ULL,
0x0000007100777306ULL, 0x000e620000205400ULL, 0x000000797a00720bULL, 0x004fce0003f3d000ULL,
0x0000006100707306ULL, 0x0004ec000000d400ULL, 0x0000000139391812ULL, 0x000fe400078efcffULL,
0x00000062006b7306ULL, 0x0008e2000000d400ULL, 0x0001000061617824ULL, 0x004fe200078e00ffULL,
0x000000777400720bULL, 0x002fc40003fdd000ULL, 0x000000603960723eULL, 0x000fe400000010ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000005d00827306ULL, 0x000fe20000209400ULL,
0x0001000062627824ULL, 0x010fe200078e00ffULL, 0x0000000170703812ULL, 0x008fc800078efcffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000061005f7306ULL, 0x000fe20000209400ULL,
0x0000000138386812ULL, 0x000fe400078efcffULL, 0x000000016b6b5812ULL, 0x000fe400078efcffULL,
0x00000070e5e5723eULL, 0x000fc600000010ffULL, 0x0000006100887306ULL, 0x0002a80000205400ULL,
0x000000e43044723cULL, 0x000fe80000041844ULL, 0x0000005d00817306ULL, 0x000ee20000205400ULL,
0x0000006100617245ULL, 0x002fce000020d400ULL, 0x0000008300807306ULL, 0x000fe20000209400ULL,
0x000000885f00720bULL, 0x004fce0003f7d000ULL, 0x00000083007b7306ULL, 0x000e620000205400ULL,
0x000000818200720bULL, 0x008fca0003f3d000ULL, 0x0000000161613812ULL, 0x000fe400078efcffULL,
0x00000063006c7306ULL, 0x0004e4000000d400ULL, 0x000000613861723eULL, 0x000fc800000010ffULL,
0x000000013a3a1812ULL, 0x000fe400078efcffULL, 0x00000062003b7306ULL, 0x000fe20000209400ULL,
0x0001000063637824ULL, 0x004fe200078e00ffULL, 0x0000007b8000720bULL, 0x002fe20003fdd000ULL,
0x000000603040723cULL, 0x000fe20000041840ULL, 0x0000006b3a3a723eULL, 0x000fe400000010ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x00000062005c7306ULL, 0x0002a20000205400ULL,
0x000000016c6c4812ULL, 0x008fce00078efcffULL, 0x0000006900727306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x002fce000020d400ULL, 0x0000006900737306ULL, 0x0002e20000205400ULL,
0x0000005c3b00720bULL, 0x004fe40003fbd000ULL, 0x00000083003b7245ULL, 0x000fc8000020d400ULL,
0x000000013b3b6812ULL, 0x000fe200078efcffULL, 0x0000006a006e7306ULL, 0x000fe20000209400ULL,
0x0000006900697245ULL, 0x002fe4000020d400ULL, 0x0000006c3b3b723eULL, 0x000fc600000010ffULL,
0x0000000162625812ULL, 0x000fe400078efcffULL, 0x0000006a006d7306ULL, 0x0002a20000205400ULL,
0x000000737200720bULL, 0x008fe20003f7d000ULL, 0x0000003a3034723cULL, 0x000fec0000041834ULL,
0x00000063005f7306ULL, 0x000fe20000209400ULL, 0x0000006a006a7245ULL, 0x002fca000020d400ULL,
0x0000000169693812ULL, 0x000fe400078efcffULL, 0x00000063005e7306ULL, 0x0002e20000205400ULL,
0x0000006d6e00720bULL, 0x004fe40003f3d000ULL, 0x000000626962723eULL, 0x000fe400000010ffULL,
0x0000006300637245ULL, 0x002fd2000020d400ULL, 0x000000016a6a1812ULL, 0x000fe400078efcffULL,
0x0000005e5f00720bULL, 0x008fda0003fdd000ULL, 0x0000000163636812ULL, 0x000fc800078efcffULL,
0x000000636a63723eULL, 0x000fce00000010ffULL, 0x00000062303c723cULL, 0x000fe2000004183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01065c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000805b307811ULL, 0x000fe200078e40ffULL, 0x000000042d5d7e24ULL, 0x020fe2000f8e022aULL,
0x00000004ff3b7819ULL, 0x000fe2000001162bULL, 0x00000100ff5f7424ULL, 0x000fe200078e00ffULL,
0x0000003059317217ULL, 0x000fc40007800000ULL, 0x0000003f5d327812ULL, 0x040fe400078ef81cULL,
0x0000003f5d387812ULL, 0x000fe200078ef81bULL, 0x0000000131317824ULL, 0x000fe200078e0a30ULL,
0x0000003f5d307812ULL, 0x040fe400078ef822ULL, 0x0000003f5d3a7812ULL, 0x000fe400078ef81aULL,
0x0000002031337807ULL, 0x000fe20000000000ULL, 0x00005e0030307625ULL, 0x000fc600078e005fULL,
0x000000332c397217ULL, 0x000fe20007800000ULL, 0x00005e0032327625ULL, 0x000fe200078e005fULL,
0x0000002130307210ULL, 0x000fc60007f3e0ffULL, 0x00000001395c7824ULL, 0x000fe200078e0a2cULL,
0x0000002132327210ULL, 0x000fe20007f9e0ffULL, 0x00005e0038387625ULL, 0x000fc600078e005fULL,
0x0000005c2000720cULL, 0x080fe20003f66070ULL, 0x000000ffff317224ULL, 0x000fe200008e0631ULL,
0x0000002138387210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x0000005c3b00720cULL, 0x080fe20003f26070ULL, 0x00005e003a3a7625ULL, 0x000fe200078e005fULL,
0x0000005c1f00720cULL, 0x000fc60003f86070ULL, 0x000000ffff397224ULL, 0x000fe200028e0639ULL,
0x0000005c1d00720cULL, 0x000fe40003fa6070ULL, 0x000000213a3a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030087faeULL, 0x0003e8000c901c46ULL, 0x0000000032077faeULL, 0x0003e8000d901c46ULL,
0x0000000038067faeULL, 0x0003e8000e101c46ULL, 0x000000003a057faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff307984ULL, 0x002e620000000800ULL,
0x8000000066317824ULL, 0x000fca00078e00ffULL, 0x8000000030ff7812ULL, 0x002fe20007824831ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fe400078e00ffULL, 0x8000000066327824ULL, 0x000fe400078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01065400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007824832ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000000430783bULL, 0x000e680000004200ULL,
0x000000000060783bULL, 0x000fe80000004200ULL, 0x000000000338783bULL, 0x000ea80000004200ULL,
0x00000000025c783bULL, 0x000ee20000004200ULL, 0x0000010030ca7824ULL, 0x042fe200078e00ffULL,
0x0000003000ab7306ULL, 0x000fe20000009400ULL, 0x0001000030c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe20000011430ULL, 0x0000010031c97824ULL, 0x040fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0001000031de7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000010032e47824ULL, 0x040fe200078e00ffULL,
0x000000ca00ad7306ULL, 0x000fe20000209400ULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010033e17824ULL, 0x040fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe20000011431ULL,
0x0001000032df7824ULL, 0x000fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fe200000114deULL,
0x0001000033da7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x000000ca00ae7306ULL, 0x000e620000205400ULL, 0x00000018ffe17819ULL, 0x000fe200000114e1ULL,
0x000001003aa87824ULL, 0x004fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fe20000011432ULL,
0x0001000039d17824ULL, 0x000fe200078e00ffULL, 0x00000018ffdf7819ULL, 0x000fe200000114dfULL,
0x000001003ba97824ULL, 0x040fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x0000003000aa7306ULL, 0x000ea20000005400ULL, 0x00000018ff767819ULL, 0x000fe20000011460ULL,
0x000100003baf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fc40000011433ULL,
0x00000018ffbc7819ULL, 0x000fe40000011438ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000003200ed7306ULL, 0x000fe20000009400ULL, 0x000000aead00720bULL, 0x002fe40003fdd000ULL,
0x00000018ffd17819ULL, 0x000fe400000114d1ULL, 0x00000018ff9c7819ULL, 0x000fe40000011439ULL,
0x00000018ff9d7819ULL, 0x000fe2000001143aULL, 0x0000003200b87306ULL, 0x000e620000005400ULL,
0x000000aaab00720bULL, 0x004fe20003fbd000ULL, 0x000100003aaa7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fc4000001143bULL, 0x00000018ffa37819ULL, 0x008fe4000001145cULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000c600ba7306ULL, 0x000fe20000209400ULL,
0x00000018ffa97819ULL, 0x000fe400000114a9ULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ff867819ULL, 0x000fe4000001145eULL, 0x00000018ff8e7819ULL, 0x000fe2000001145dULL,
0x000000c600bb7306ULL, 0x0004e20000205400ULL, 0x000000b8ed00720bULL, 0x002fc40003f9d000ULL,
0x000000ca00b87245ULL, 0x000fe4000020d400ULL, 0x00000018ff807819ULL, 0x000fe4000001145fULL,
0x00000001b8b86812ULL, 0x000fe200078efcffULL, 0x000000c300c77306ULL, 0x000fe20000209400ULL,
0x000000c600c67245ULL, 0x004fe4000020d400ULL, 0x00000018ff6f7819ULL, 0x000fe40000011461ULL,
0x00000018ff697819ULL, 0x000fc40000011462ULL, 0x00000018ff6a7819ULL, 0x000fe20000011463ULL,
0x000000c300d87306ULL, 0x0002a20000205400ULL, 0x000000bbba00720bULL, 0x008fce0003f3d000ULL,
0x00000030008f7306ULL, 0x000722000000d400ULL, 0x000000c300c37245ULL, 0x002fca000020d400ULL,
0x00000001c6c61812ULL, 0x000fe400078efcffULL, 0x000000c900ea7306ULL, 0x000fe20000209400ULL,
0x000000d8c700720bULL, 0x004fe20003fdd000ULL, 0x0000010039307824ULL, 0x008fe400078e00ffULL,
0x000100005cd87824ULL, 0x000fe400078e00ffULL, 0x000001005dc77824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000c900ef7306ULL, 0x000e620000205400ULL,
0x000000018f8f5812ULL, 0x010fc400078efcffULL, 0x00000018ffd87819ULL, 0x000fe400000114d8ULL,
0x00000018ffc77819ULL, 0x000fe400000114c7ULL, 0x00000001c3c36812ULL, 0x000fe200078efcffULL,
0x0000003100e97306ULL, 0x000fe60000009400ULL, 0x000000c3c6c6723eULL, 0x000fca00000010ffULL,
0x0000003100b27306ULL, 0x000ea20000005400ULL, 0x000000efea00720bULL, 0x002fce0003fbd000ULL,
0x000000cd00c87306ULL, 0x000ff00000209400ULL, 0x000000cd00c57306ULL, 0x0002e20000205400ULL,
0x000000b2e900720bULL, 0x004fe20003f7d000ULL, 0x000100005de97824ULL, 0x000fca00078e00ffULL,
0x00000018ffe97819ULL, 0x000fe200000114e9ULL, 0x000000de00cb7306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x002fce000020d400ULL, 0x000000de00cc7306ULL, 0x000e620000205400ULL,
0x000000c5c800720bULL, 0x008fe20003fdd000ULL, 0x0000010060c57824ULL, 0x000fe200078e00ffULL,
0x000000c900c87245ULL, 0x000fc8000020d400ULL, 0x00000001c8c85812ULL, 0x000fe200078efcffULL,
0x000000e400d27306ULL, 0x000fe20000209400ULL, 0x00000018ffc57819ULL, 0x000fca00000114c5ULL,
0x00000001cdcd6812ULL, 0x000fe400078efcffULL, 0x000000e400eb7306ULL, 0x000ea20000205400ULL,
0x000000cccb00720bULL, 0x002fe20003f3d000ULL, 0x0001000060cc7824ULL, 0x000fe400078e00ffULL,
0x0000010061cb7824ULL, 0x000fc600078e00ffULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x00000031008d7306ULL, 0x0002e2000000d400ULL, 0x00000018ffcb7819ULL, 0x000fce00000114cbULL,
0x000000e100e67306ULL, 0x000fe20000209400ULL, 0x000000ebd200720bULL, 0x004fe20003fbd000ULL,
0x0000010038317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x000000e100e77306ULL, 0x000e620000205400ULL, 0x000000018d8d3812ULL, 0x008fce00078efcffULL,
0x0000003300e07306ULL, 0x000ff00000009400ULL, 0x0000003300d77306ULL, 0x000fe20000005400ULL,
0x000000e7e600720bULL, 0x002fce0003f7d000ULL, 0x000000c100ce7306ULL, 0x000ff00000209400ULL,
0x000000c100cf7306ULL, 0x000ff00000205400ULL, 0x000000df00e57306ULL, 0x000ff00000209400ULL,
0x000000df00e87306ULL, 0x0002b00000205400ULL, 0x0000006000947306ULL, 0x000fe20000009400ULL,
0x000000df00df7245ULL, 0x002fce000020d400ULL, 0x0000006000957306ULL, 0x000fe20000005400ULL,
0x000000e8e500720bULL, 0x004fce0003fdd000ULL, 0x00000060006e7306ULL, 0x0003ec000000d400ULL,
0x00000001dfdf6812ULL, 0x000fe400078efcffULL, 0x000000da00e27306ULL, 0x000fe20000209400ULL,
0x000000de00607245ULL, 0x002fc8000020d400ULL, 0x0000000160601812ULL, 0x000fe400078efcffULL,
0x000000d7e000720bULL, 0x000fe20003f3d000ULL, 0x000000da00e37306ULL, 0x0002a20000205400ULL,
0x000000e400d77245ULL, 0x000fc8000020d400ULL, 0x00000001d7d75812ULL, 0x000fe400078efcffULL,
0x000000cfce00720bULL, 0x000fe20003fbd000ULL, 0x0000003300877306ULL, 0x000722000000d400ULL,
0x000000e100ce7245ULL, 0x000fe4000020d400ULL, 0x000000da00da7245ULL, 0x002fe4000020d400ULL,
0x00000001cece3812ULL, 0x000fc600078efcffULL, 0x000000c000c27306ULL, 0x000fe20000209400ULL,
0x0001000038337824ULL, 0x008fe200078e00ffULL, 0x000000e3e200720bULL, 0x004fc80003f7d000ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x000000c000b57306ULL, 0x000e620000205400ULL,
0x0000000187871812ULL, 0x010fcc00078efcffULL, 0x00000001dada3812ULL, 0x000fe200078efcffULL,
0x0000003100dc7306ULL, 0x000ff00000209400ULL, 0x0000003100d97306ULL, 0x000ea20000205400ULL,
0x000000b5c200720bULL, 0x002fc40003f3d000ULL, 0x000000c000b57245ULL, 0x000fe4000020d400ULL,
0x000000c100c27245ULL, 0x000fc6000020d400ULL, 0x0000003900bf7306ULL, 0x000fe20000009400ULL,
0x00000001c2c25812ULL, 0x000fca00078efcffULL, 0x00000001b5b51812ULL, 0x000fe400078efcffULL,
0x0000003900ac7306ULL, 0x000e620000005400ULL, 0x000000d9dc00720bULL, 0x004fe40003fdd000ULL,
0x000000dab5b5723eULL, 0x000fca00000010ffULL, 0x0000003200887306ULL, 0x000eb0000000d400ULL,
0x0000003800c47306ULL, 0x000fe20000009400ULL, 0x000000acbf00720bULL, 0x002fe40003f7d000ULL,
0x0000003100ac7245ULL, 0x000fc8000020d400ULL, 0x00000001acac6812ULL, 0x000fe200078efcffULL,
0x0000003800b77306ULL, 0x000e620000005400ULL, 0x0000000188884812ULL, 0x004fc800078efcffULL,
0x00000088d788723eULL, 0x000fc600000010ffULL, 0x000000bc00b47306ULL, 0x000ff00000209400ULL,
0x000000bc00b97306ULL, 0x000ea20000205400ULL, 0x000000b7c400720bULL, 0x002fe40003f9d000ULL,
0x0000003000b77245ULL, 0x000fca000020d400ULL, 0x0000003000327306ULL, 0x000ff00000209400ULL,
0x0000003000dd7306ULL, 0x0002e20000205400ULL, 0x000000b9b400720bULL, 0x004fce0003f3d000ULL,
0x0000003800857306ULL, 0x000ea2000000d400ULL, 0x0000a80065307811ULL, 0x002fce00078e20ffULL,
0x0000003300387306ULL, 0x000fe20000209400ULL, 0x000000dd3200720bULL, 0x008fce0003fbd000ULL,
0x0000003300d57306ULL, 0x000e620000205400ULL, 0x0000000185854812ULL, 0x004fc800078efcffULL,
0x00000085acac723eULL, 0x000fe400000010ffULL, 0x00000001b7b75812ULL, 0x000fe200078efcffULL,
0x0000003900847306ULL, 0x000eb0000000d400ULL, 0x0000003b00be7306ULL, 0x000fe20000009400ULL,
0x000000d53800720bULL, 0x002fc40003fdd000ULL, 0x0000a80064387811ULL, 0x000fca00078e20ffULL,
0x0000003b00b17306ULL, 0x000e620000005400ULL, 0x0000000184843812ULL, 0x004fce00078efcffULL,
0x0000003a00bd7306ULL, 0x000ff00000009400ULL, 0x0000003a00b07306ULL, 0x000ea20000005400ULL,
0x000000b1be00720bULL, 0x002fe40003f7d000ULL, 0x000000bc00b17245ULL, 0x000fc4000020d400ULL,
0x00000002ffbe7819ULL, 0x000fe4000001162bULL, 0x00000001b1b11812ULL, 0x000fe200078efcffULL,
0x000000a800d37306ULL, 0x000ff00000209400ULL, 0x000000a800d47306ULL, 0x0002e20000205400ULL,
0x000000b0bd00720bULL, 0x004fc40003f9d000ULL, 0x0000003300b07245ULL, 0x000fe4000020d400ULL,
0x000000003030783bULL, 0x000fe40000000200ULL, 0x00000001b0b06812ULL, 0x000fe200078efcffULL,
0x000000d100d67306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fe4000020d400ULL,
0x000000b0b1b0723eULL, 0x000fca00000010ffULL, 0x000000d100397306ULL, 0x0002a20000205400ULL,
0x000000d4d300720bULL, 0x008fce0003f3d000ULL, 0x0000009c00b37306ULL, 0x000fe20000209400ULL,
0x000000d100d17245ULL, 0x002fca000020d400ULL, 0x00000001a8a81812ULL, 0x000fe400078efcffULL,
0x0000009c00b67306ULL, 0x000e620000205400ULL, 0x00000039d600720bULL, 0x004fce0003fbd000ULL,
0x0000003a00817306ULL, 0x0004ec000000d400ULL, 0x00000001d1d15812ULL, 0x000fe400078efcffULL,
0x0000003b007b7306ULL, 0x000962000000d400ULL, 0x000001005c3a7824ULL, 0x004fe200078e00ffULL,
0x000000b6b300720bULL, 0x002fc40003fdd000ULL, 0x0000009c00b67245ULL, 0x000fe4000020d400ULL,
0x00000018ffba7819ULL, 0x000fe2000001143aULL, 0x000001005f3a7824ULL, 0x000fe200078e00ffULL,
0x000000aa00ab7306ULL, 0x000fe20000209400ULL, 0x000001005e3b7824ULL, 0x010fe200078e00ffULL,
0x0000000181814812ULL, 0x008fe400078efcffULL, 0x00000018ffb47819ULL, 0x000fe4000001143aULL,
0x00000018ffc07819ULL, 0x000fc4000001143bULL, 0x000000aa00ae7306ULL, 0x0002a20000205400ULL,
0x000000003838783bULL, 0x000fe20000000200ULL, 0x00000001b6b66812ULL, 0x000fe400078efcffULL,
0x000000a9009c7245ULL, 0x000fe4000020d400ULL, 0x000000017b7b3812ULL, 0x020fe400078efcffULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fe4000020d400ULL,
0x000000d1b6b1723eULL, 0x000fc400000010ffULL, 0x00000081a8a8723eULL, 0x000fc600000010ffULL,
0x0000009d009f7306ULL, 0x0002e20000205400ULL, 0x000000aeab00720bULL, 0x004fce0003f3d000ULL,
0x0000005c00927306ULL, 0x000fe20000009400ULL, 0x0000009d009d7245ULL, 0x002fca000020d400ULL,
0x00000001aaaa1812ULL, 0x000fe400078efcffULL, 0x0000005c009b7306ULL, 0x000e620000005400ULL,
0x0000009f9e00720bULL, 0x008fce0003fdd000ULL, 0x0000005c007a7306ULL, 0x0004ec000000d400ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x000000d800de7306ULL, 0x000fe20000209400ULL,
0x000100005e5c7824ULL, 0x004fe200078e00ffULL, 0x0000009b9200720bULL, 0x002fc40003f7d000ULL,
0x000000aa9daa723eULL, 0x000fe400000010ffULL, 0x00000018ffb37819ULL, 0x000fe4000001145cULL,
0x00000010ff5c723eULL, 0x000fe200000010ffULL, 0x000000d800e57306ULL, 0x0003e60000205400ULL,
0x000054105cab7816ULL, 0x000fc6000000005cULL, 0x000000017a7a3812ULL, 0x008fe400078efcffULL,
0x00001fbeab9f7589ULL, 0x000ea200000e0000ULL, 0x000000a000a17306ULL, 0x000fe20000209400ULL,
0x000000d800d87245ULL, 0x002fe4000020d400ULL, 0x00001f0aab5c7589ULL, 0x000e6a00000e0000ULL,
0x000000a000a27306ULL, 0x0007300000205400ULL, 0x000000a900d07306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x008fe2000020d400ULL, 0x0000009f3030a231ULL, 0x004fcc00003400ffULL,
0x000000a900db7306ULL, 0x000ea20000205400ULL, 0x0000009f3232a231ULL, 0x080fe200003400ffULL,
0x000000a2a100720bULL, 0x010fe20003f9d000ULL, 0x0000009f3838a231ULL, 0x080fe400003400ffULL,
0x0000009f3a3aa231ULL, 0x000fe400003400ffULL, 0x0000005c3131a231ULL, 0x082fe200003400ffULL,
0x000000c000bf7306ULL, 0x000fe20000209400ULL, 0x0000005c3333a231ULL, 0x080fe400003400ffULL,
0x0000005c3939a231ULL, 0x000fc400003400ffULL, 0x0000005c3b3ba231ULL, 0x000fe200003400ffULL,
0x000000e5de00720bULL, 0x000fe40003f5d000ULL, 0x000000c000dc7306ULL, 0x0002e20000205400ULL,
0x000000dbd000720bULL, 0x004fe20003fbd000ULL, 0x000000b03040723cULL, 0x000fe20000041840ULL,
0x00000001a0a04812ULL, 0x000fe400078efcffULL, 0x0000008fb85c723eULL, 0x000fc600000010ffULL,
0x000000c700c97306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fe4000020d400ULL,
0x00000001d8d82812ULL, 0x000fc600078efcffULL, 0x000000019c9c5812ULL, 0x000fe400078efcffULL,
0x000000c700d27306ULL, 0x000e620000205400ULL, 0x000000dcbf00720bULL, 0x008fe40003f5d000ULL,
0x0000007b9ca9723eULL, 0x000fca00000010ffULL, 0x000000af00ad7306ULL, 0x000fe40000209400ULL,
0x000000a83034723cULL, 0x000fe80000041834ULL, 0x00000001c0c02812ULL, 0x000fe400078efcffULL,
0x000000af00b27306ULL, 0x0004e20000205400ULL, 0x000000d2c900720bULL, 0x002fce0003f9d000ULL,
0x0000005e00907306ULL, 0x000fe20000009400ULL, 0x000000af00af7245ULL, 0x004fce000020d400ULL,
0x0000005e00977306ULL, 0x000e620000005400ULL, 0x000000b2ad00720bULL, 0x008fe40003fbd000ULL,
0x00000084b7ad723eULL, 0x000fca00000010ffULL, 0x000000b400bc7306ULL, 0x000fe40000209400ULL,
0x000000ac3044723cULL, 0x000fe80000041844ULL, 0x00000001afaf5812ULL, 0x000fe400078efcffULL,
0x000000b400bd7306ULL, 0x000ea20000205400ULL, 0x000000979000720bULL, 0x002fe40003fdd000ULL,
0x000000c700907245ULL, 0x000fc4000020d400ULL, 0x00000060cdc7723eULL, 0x000fe400000010ffULL,
0x0000000190904812ULL, 0x000fe200078efcffULL, 0x000000e900c47306ULL, 0x000fe20000209400ULL,
0x000000afa0ab723eULL, 0x000fc600000010ffULL, 0x000000c63050723cULL, 0x000fe80000041850ULL,
0x000000e900c17306ULL, 0x0002e20000205400ULL, 0x000000bdbc00720bULL, 0x004fc60003f5d000ULL,
0x000000aa303c723cULL, 0x000fe8000004183cULL, 0x0000005d009a7306ULL, 0x000fe20000009400ULL,
0x000000e900e97245ULL, 0x002fce000020d400ULL, 0x0000005d00937306ULL, 0x000e620000005400ULL,
0x000000c1c400720bULL, 0x008fe40003f9d000ULL, 0x000000b400c17245ULL, 0x000fe4000020d400ULL,
0x000000dfc2b4723eULL, 0x000fe400000010ffULL, 0x00000001c1c12812ULL, 0x000fe200078efcffULL,
0x0000005e00757306ULL, 0x0004e8000000d400ULL, 0x000000b43048723cULL, 0x000fe40000041848ULL,
0x00000001e9e94812ULL, 0x000fc400078efcffULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x000000939a00720bULL, 0x002fe20003f3d000ULL, 0x00000100635e7824ULL, 0x004fe200078e00ffULL,
0x000000ba00937245ULL, 0x000fca000020d400ULL, 0x000000ba00ca7306ULL, 0x000e620000205400ULL,
0x0000000175756812ULL, 0x008fc800078efcffULL, 0x00000075c0c0723eULL, 0x000fc600000010ffULL,
0x00000086008a7306ULL, 0x000ff00000209400ULL, 0x0000008600897306ULL, 0x0004e20000205400ULL,
0x000000cabb00720bULL, 0x002fce0003fbd000ULL, 0x000000b300b97306ULL, 0x000fe20000209400ULL,
0x0000008600867245ULL, 0x004fca000020d400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x000000b300ae7306ULL, 0x0002a20000205400ULL, 0x000000898a00720bULL, 0x008fe40003fdd000ULL,
0x00000087ce89723eULL, 0x000fe400000010ffULL, 0x0000007a937a723eULL, 0x000fc600000010ffULL,
0x0000005d00777306ULL, 0x000722000000d400ULL, 0x000000b300b37245ULL, 0x002fe2000020d400ULL,
0x00000088304c723cULL, 0x000fe8000004184cULL, 0x0000000186866812ULL, 0x000fe400078efcffULL,
0x0000005f00917306ULL, 0x000fe20000009400ULL, 0x000100005f5d7824ULL, 0x008fe200078e00ffULL,
0x000000aeb900720bULL, 0x004fc80003f5d000ULL, 0x00000018ff9e7819ULL, 0x000fe4000001145dULL,
0x0000005f00967306ULL, 0x000e620000005400ULL, 0x0000000177771812ULL, 0x010fe400078efcffULL,
0x0000008dc85d723eULL, 0x000fe400000010ffULL, 0x0000009e00877245ULL, 0x000fe4000020d400ULL,
0x00000001b3b32812ULL, 0x000fe200078efcffULL, 0x0000008e00a67306ULL, 0x000fe20000209400ULL,
0x00000077907b723eULL, 0x000fe200000010ffULL, 0x0000005c3054723cULL, 0x000fe20000041854ULL,
0x000000b38686723eULL, 0x000fca00000010ffULL, 0x0000008e00a77306ULL, 0x0004e20000205400ULL,
0x000000969100720bULL, 0x002fe40003f7d000ULL, 0x000000cb005c7245ULL, 0x000fe4000020d400ULL,
0x0000007600317245ULL, 0x000fe4000020d400ULL, 0x0000006f00307245ULL, 0x000fe2000020d400ULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x004fce000020d400ULL,
0x000000a300a57306ULL, 0x0002a20000205400ULL, 0x000000a7a600720bULL, 0x008fe20003f3d000ULL,
0x0000007a3854723cULL, 0x000fec0000041854ULL, 0x0000008000837306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x000000018e8e1812ULL, 0x000fe400078efcffULL,
0x0000008000827306ULL, 0x0002e20000205400ULL, 0x000000a5a400720bULL, 0x004fe40003fbd000ULL,
0x000000e98ed9723eULL, 0x000fca00000010ffULL, 0x000000c500977306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x00000001a3a35812ULL, 0x000fe400078efcffULL,
0x000000c5009a7306ULL, 0x0002a20000205400ULL, 0x000000828300720bULL, 0x008fe40003f5d000ULL,
0x000000959400720bULL, 0x000fe40003fbd000ULL, 0x00000018ff827819ULL, 0x000fe4000001145eULL,
0x000000d8a3d8723eULL, 0x000fe200000010ffULL, 0x0000005f00747306ULL, 0x000722000000d400ULL,
0x000000c500c57245ULL, 0x002fca000020d400ULL, 0x0000000180802812ULL, 0x000fe200078efcffULL,
0x000000d83850723cULL, 0x000fe20000041850ULL, 0x0000009e00a17306ULL, 0x000fe20000209400ULL,
0x0000009a9700720bULL, 0x004fe20003fdd000ULL, 0x00000100625f7824ULL, 0x008fe200078e00ffULL,
0x000000016e6e5812ULL, 0x000fc800078efcffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000009e00927306ULL, 0x000e620000205400ULL, 0x0000000174743812ULL, 0x010fc800078efcffULL,
0x00000074c1c1723eULL, 0x000fe400000010ffULL, 0x00000001c5c56812ULL, 0x000fe200078efcffULL,
0x0000006100987306ULL, 0x000fe60000009400ULL, 0x0000006ec56e723eULL, 0x000fe200000010ffULL,
0x000000c0384c723cULL, 0x000fe8000004184cULL, 0x0000006100997306ULL, 0x000ea20000005400ULL,
0x00000092a100720bULL, 0x002fce0003f7d000ULL, 0x00000062008c7306ULL, 0x000fec0000009400ULL,
0x0000000187873812ULL, 0x000fe400078efcffULL, 0x00000062008b7306ULL, 0x000e620000005400ULL,
0x000000999800720bULL, 0x004fe40003f9d000ULL, 0x000000878087723eULL, 0x000fca00000010ffULL,
0x00000076007c7306ULL, 0x000fe40000209400ULL, 0x000000863848723cULL, 0x000fec0000041848ULL,
0x00000076007d7306ULL, 0x000ea20000205400ULL, 0x0000008b8c00720bULL, 0x002fce0003f3d000ULL,
0x000000cb00917306ULL, 0x000ff00000209400ULL, 0x000000cb00967306ULL, 0x000e620000205400ULL,
0x0000007d7c00720bULL, 0x004fce0003f5d000ULL, 0x00000061006d7306ULL, 0x0004ec000000d400ULL,
0x0000000131312812ULL, 0x000fe400078efcffULL, 0x00000063007f7306ULL, 0x000fe20000009400ULL,
0x0001000061617824ULL, 0x004fe200078e00ffULL, 0x000000969100720bULL, 0x002fc80003fdd000ULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x00000063007e7306ULL, 0x000e620000005400ULL,
0x000000016d6d4812ULL, 0x008fe400078efcffULL, 0x0000006100cd7245ULL, 0x000fc8000020d400ULL,
0x000000015c5c6812ULL, 0x000fe200078efcffULL, 0x00000061005d7306ULL, 0x000ff00000209400ULL,
0x0000006100607306ULL, 0x000ea20000205400ULL, 0x0000007e7f00720bULL, 0x002fce0003f7d000ULL,
0x0000006f00797306ULL, 0x000ff00000209400ULL, 0x0000006f00787306ULL, 0x0002e20000205400ULL,
0x000000605d00720bULL, 0x004fce0003f9d000ULL, 0x000000cc008f7306ULL, 0x000fe20000209400ULL,
0x0000006d5c6f723eULL, 0x002fca00000010ffULL, 0x00000001cdcd4812ULL, 0x000fe400078efcffULL,
0x000000cc008c7306ULL, 0x0002a20000205400ULL, 0x000000787900720bULL, 0x008fe20003fbd000ULL,
0x0000006e3844723cULL, 0x000fec0000041844ULL, 0x0000005f00847306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fca000020d400ULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x0000005f00837306ULL, 0x0002e20000205400ULL, 0x0000008c8f00720bULL, 0x004fe40003fdd000ULL,
0x000000cd30cd723eULL, 0x000fca00000010ffULL, 0x00000062006c7306ULL, 0x000522000000d400ULL,
0x0000005f005f7245ULL, 0x002fca000020d400ULL, 0x00000001cccc6812ULL, 0x000fe400078efcffULL,
0x00000063006b7306ULL, 0x000362000000d400ULL, 0x0001000062627824ULL, 0x004fe200078e00ffULL,
0x000000838400720bULL, 0x008fe40003f5d000ULL, 0x000000cc31cc723eULL, 0x000fe400000010ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000082007e7306ULL, 0x000fe20000209400ULL,
0x0001000063637824ULL, 0x002fe200078e00ffULL, 0x000000016c6c1812ULL, 0x010fe200078efcffULL,
0x000000cc3840723cULL, 0x000fe60000041840ULL, 0x00000018ff637819ULL, 0x000fc40000011463ULL,
0x00000082007d7306ULL, 0x0002a20000205400ULL, 0x000000015f5f2812ULL, 0x000fe400078efcffULL,
0x000000016b6b3812ULL, 0x020fe400078efcffULL, 0x0000006c5f6c723eULL, 0x000fc600000010ffULL,
0x0000006900727306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x002fce000020d400ULL,
0x0000006900737306ULL, 0x0002e20000205400ULL, 0x0000007d7e00720bULL, 0x004fce0003fbd000ULL,
0x0000006a00707306ULL, 0x000fe20000209400ULL, 0x0000006900697245ULL, 0x002fca000020d400ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x0000006a00717306ULL, 0x0002a20000205400ULL,
0x000000737200720bULL, 0x008fe40003fdd000ULL, 0x0000006b826d723eULL, 0x000fca00000010ffULL,
0x00000062005e7306ULL, 0x000fe20000209400ULL, 0x0000006a006a7245ULL, 0x002fe2000020d400ULL,
0x0000006c3834723cULL, 0x000fe80000041834ULL, 0x0000000169696812ULL, 0x000fe400078efcffULL,
0x0000006200337306ULL, 0x0002e20000205400ULL, 0x000000717000720bULL, 0x004fce0003f9d000ULL,
0x0000006300327306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fca000020d400ULL,
0x000000016a6a4812ULL, 0x000fe400078efcffULL, 0x00000063005d7306ULL, 0x0002a20000205400ULL,
0x000000335e00720bULL, 0x008fe40003f5d000ULL, 0x0000006300637245ULL, 0x002fd6000020d400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x0000005d3200720bULL, 0x004fe40003f3d000ULL,
0x000000626962723eULL, 0x000fd600000010ffULL, 0x0000000163631812ULL, 0x000fc800078efcffULL,
0x000000636a63723eULL, 0x000fce00000010ffULL, 0x000000623838723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000805b307811ULL, 0x000fe200078e40ffULL, 0x01062000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff23ff7812ULL, 0x000fe4000784c0ffULL, 0x000000305900720cULL, 0x000fe40003f24070ULL,
0x00000001ff697807ULL, 0x000fd60005000000ULL, 0x000096f000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff2f7984ULL, 0x000e640000000800ULL, 0x800000002fff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff2f7984ULL, 0x000e640000000800ULL, 0x800000002fff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL, 0x0000002f00307305ULL, 0x0002a4000021f000ULL,
0x3fa000002f2f7823ULL, 0x002fe200000100ffULL, 0x000000300000735dULL, 0x004fe40003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000167677824ULL, 0x000fe400078e0268ULL, 0x00000004ff327424ULL, 0x000fe400078e00ffULL,
0x00000300ff2f7624ULL, 0x000fe200078e00ffULL, 0x0000000367307812ULL, 0x000fe200078ec0ffULL,
0x000000042d3c7e24ULL, 0x000fe4000f8e022aULL, 0xfffffffd322f7424ULL, 0x000fe200078e022fULL,
0x000000033000780cULL, 0x000fe20003f25270ULL, 0xffffffffff2d7424ULL, 0x000fc600078e00ffULL,
0x000000012f687807ULL, 0x000fca0004800000ULL, 0x00000001672f7824ULL, 0x000fe200078e0268ULL,
0x000000a05b307811ULL, 0x000fc800078e40ffULL, 0x000000582f00720cULL, 0x000fe40003f26070ULL,
0x0000003059317217ULL, 0x000fca0007800000ULL, 0x0000000131317824ULL, 0x000fe200078e0a30ULL,
0x000000203c3c7810ULL, 0x000fca0007ffe0ffULL, 0x000000012f339824ULL, 0x000fe200078e0226ULL,
0x00000020313d7807ULL, 0x000fe20000000000ULL, 0x00000100ff5d7424ULL, 0x000fe400078e00ffULL,
0x0000600033329625ULL, 0x000fe200078e0032ULL, 0x0000003d2c3d7217ULL, 0x000fc60007800000ULL,
0x000000011e307824ULL, 0x100fe200078e023cULL, 0x00000006322d9981ULL, 0x000362000c1e1900ULL,
0x00000001193e7824ULL, 0x100fe200078e023cULL, 0x00000004ff3f7819ULL, 0x000fe2000001162bULL,
0x00000001185e7824ULL, 0x000fe400078e023cULL, 0x00005e0030307625ULL, 0x000fc800078e005dULL,
0x000000013d5c7824ULL, 0x000fe200078e0a2cULL, 0x0000002130307210ULL, 0x000fe20007f3e0ffULL,
0x00005e003e327625ULL, 0x002fc600078e005dULL, 0x0000005c3f00720cULL, 0x000fe20003f46070ULL,
0x00000001173e7824ULL, 0x000fe200078e023cULL, 0x0000002132327210ULL, 0x000fe20007f7e0ffULL,
0x00005e005e3c7625ULL, 0x000fc800078e005dULL, 0x000000ffff317224ULL, 0x000fe200008e0631ULL,
0x000000213c3c7210ULL, 0x000fe20007f9e0ffULL, 0x00005e003e3e7625ULL, 0x000fe200078e005dULL,
0x0000005c2000720cULL, 0x000fc60003f26070ULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x0000005c1f00720cULL, 0x080fe20003f66070ULL, 0x000000ffff3d7224ULL, 0x000fe200020e063dULL,
0x0000005c1d00720cULL, 0x000fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030167faeULL, 0x0003e2000d101c46ULL, 0x000000213e3e7210ULL, 0x000fca0007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e063fULL, 0x0000000032157faeULL, 0x0003e8000c901c46ULL,
0x000000003c147faeULL, 0x0003e8000d901c46ULL, 0x000000003e137faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff317984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01062c00ff327984ULL, 0x000ea20000000800ULL,
0x000000ff23ff7812ULL, 0x000fe2000782c0ffULL, 0x8000000012337824ULL, 0x000fc600078e00ffULL,
0x00000001ff697807ULL, 0x000fca0004800000ULL, 0x8000000069307824ULL, 0x000fca00078e00ffULL,
0x8000000031ff7812ULL, 0x002fe40007824830ULL, 0x8000000032ff7812ULL, 0x004fe20007844833ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fe400078e00ffULL, 0x8000000012327824ULL, 0x000fe400078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01062c00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844832ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0101000011307984ULL, 0x000e620000000800ULL,
0x00000001ff8f7424ULL, 0x000fc600078e00ffULL, 0x0103000011317984ULL, 0x0004e20000000800ULL,
0x000000293000720bULL, 0x002fda0003f5d000ULL, 0x0000000000327806ULL, 0x000fc800010e0100ULL,
0x0000ffff323c7812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x000000293000720bULL, 0x00cfe40003f54000ULL, 0x0000003029327209ULL, 0x000fe40007810000ULL,
0x00000002ff3e7819ULL, 0x000fc6000001162bULL, 0x8000003229337221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b33337820ULL, 0x000fe40000410000ULL, 0x0000000000297806ULL, 0x000fe400010e0100ULL,
0x000000025a00780cULL, 0x000fe40003f45270ULL, 0x0000ffff293d7812ULL, 0x000fe200078e3cffULL,
0x0000003300337308ULL, 0x000e660000000800ULL, 0x0000003d3cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff8f7807ULL, 0x000fc60001800000ULL, 0x010500321100a388ULL, 0x000fe80000000800ULL,
0x00001f3e33297589ULL, 0x002e6400000e0000ULL, 0x80000032303c3221ULL, 0x000fe20000010000ULL,
0x0000003328287220ULL, 0x000fe20000410000ULL, 0x00001f0a33307589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b3c3c3820ULL, 0x000fc80000410000ULL, 0x0000003c00103308ULL, 0x000ee20000000800ULL,
0x0000002954547220ULL, 0x082fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x000000294c4c7220ULL, 0x080fe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x000fe20000410000ULL,
0x0000003056567220ULL, 0x084fe20000410000ULL, 0x0000003057577220ULL, 0x080fe20000410000ULL,
0x0000003052527220ULL, 0x080fe20000410000ULL, 0x0000003053537220ULL, 0x080fe20000410000ULL,
0x000000304e4e7220ULL, 0x080fe20000410000ULL, 0x000000304f4f7220ULL, 0x080fe20000410000ULL,
0x000000304a4a7220ULL, 0x080fe20000410000ULL, 0x000000304b4b7220ULL, 0x080fe20000410000ULL,
0x0000003046467220ULL, 0x080fe20000410000ULL, 0x0000003047477220ULL, 0x080fe20000410000ULL,
0x0000003042427220ULL, 0x080fe20000410000ULL, 0x0000003043437220ULL, 0x080fe20000410000ULL,
0x0000003036367220ULL, 0x080fe20000410000ULL, 0x0000003037377220ULL, 0x080fe20000410000ULL,
0x000000303a3a7220ULL, 0x080fe20000410000ULL, 0x000000303b3b7220ULL, 0x000fe20000410000ULL,
0x000000ffff297224ULL, 0x000fe200078e0032ULL, 0x0000003110313220ULL, 0x008fc80000410000ULL,
0x0000002831287221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff307984ULL, 0x000e620000000800ULL, 0x8000000069317824ULL, 0x000fca00078e00ffULL,
0x8000000030ff7812ULL, 0x002fe20007824831ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fe400078e00ffULL,
0x8000000069327824ULL, 0x000fe400078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01064c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000000f30783bULL, 0x000e620000004200ULL, 0x000099108f8f7816ULL, 0x000fc600000000ffULL,
0x000000000e3c783bULL, 0x000ea80000004200ULL, 0x000000000d5c783bULL, 0x000ee80000004200ULL,
0x000000000c60783bULL, 0x000f220000004200ULL, 0x0000010030dc7824ULL, 0x042fe200078e00ffULL,
0x00000018ffe47819ULL, 0x000fe20000011430ULL, 0x0001000030eb7824ULL, 0x000fe200078e00ffULL,
0x0000003100d27306ULL, 0x000fe20000009400ULL, 0x0000010031e77824ULL, 0x040fe200078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x0000010032cd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffeb7819ULL, 0x000fe200000114ebULL, 0x0001000031d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x000100003dc47824ULL, 0x004fe200078e00ffULL,
0x000000dc00d47306ULL, 0x000fe20000209400ULL, 0x00000018ffc07819ULL, 0x000fe20000011431ULL,
0x0000010033c27824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe2000001143dULL,
0x000001003ec87824ULL, 0x000fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x0001000032c37824ULL, 0x000fe200078e00ffULL, 0x00000018ffd97819ULL, 0x000fe200000114d9ULL,
0x000000dc00ef7306ULL, 0x000e620000205400ULL, 0x00000018ffa77819ULL, 0x000fe2000001143eULL,
0x000100003fd67824ULL, 0x000fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fc400000114c2ULL,
0x00000018ffc37819ULL, 0x000fe400000114c3ULL, 0x00000018ffb37819ULL, 0x000fe20000011433ULL,
0x000000eb00ed7306ULL, 0x000fe20000209400ULL, 0x00000018ff997819ULL, 0x000fe4000001143fULL,
0x00000018ffb07819ULL, 0x000fe4000001143cULL, 0x00000018ffb57819ULL, 0x000fe40000011432ULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000000eb00e07306ULL, 0x000ea20000205400ULL,
0x000000efd400720bULL, 0x002fc40003f5d000ULL, 0x00000018ffc47819ULL, 0x000fe400000114c4ULL,
0x00000018ff937819ULL, 0x008fe4000001145cULL, 0x00000018ffd67819ULL, 0x000fe200000114d6ULL,
0x000000e700df7306ULL, 0x000fe20000209400ULL, 0x00000018ff847819ULL, 0x000fe4000001145fULL,
0x00000018ff877819ULL, 0x000fe4000001145eULL, 0x00000018ff797819ULL, 0x010fc40000011460ULL,
0x00000018ff947819ULL, 0x000fe2000001145dULL, 0x000000e700ec7306ULL, 0x000fe20000205400ULL,
0x000000e0ed00720bULL, 0x004fe20003f9d000ULL, 0x000100005de07824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011461ULL, 0x00000018ff6a7819ULL, 0x000fe40000011462ULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x0000003100d17306ULL, 0x000e620000005400ULL,
0x00000018ff6b7819ULL, 0x000fce0000011463ULL, 0x000000e400d87306ULL, 0x000ff00000209400ULL,
0x000000e400dd7306ULL, 0x000ea20000205400ULL, 0x000000d1d200720bULL, 0x002fe20003fdd000ULL,
0x000100003ed27824ULL, 0x000fca00078e00ffULL, 0x00000018ffd27819ULL, 0x000fe200000114d2ULL,
0x0000003000ca7306ULL, 0x000ff00000009400ULL, 0x0000003000cb7306ULL, 0x000e620000005400ULL,
0x000000ddd800720bULL, 0x004fce0003f7d000ULL, 0x000000c000e27306ULL, 0x000ff00000209400ULL,
0x000000c000e17306ULL, 0x0005e20000205400ULL, 0x000000cbca00720bULL, 0x002fe20003fbd000ULL,
0x000001003fcb7824ULL, 0x000fca00078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x00000031008e7306ULL, 0x0002e2000000d400ULL, 0x000000c000c07245ULL, 0x004fce000020d400ULL,
0x0000003d00b97306ULL, 0x000fe20000009400ULL, 0x000001003d317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003d00b67306ULL, 0x000fe20000005400ULL,
0x000000018e8e6812ULL, 0x008fce00078efcffULL, 0x0000003d00837306ULL, 0x0003f0000000d400ULL,
0x000000cd00e57306ULL, 0x000fe20000209400ULL, 0x000000dc003d7245ULL, 0x002fe2000020d400ULL,
0x000001005edc7824ULL, 0x000fc600078e00ffULL, 0x000000013d3d2812ULL, 0x000fe400078efcffULL,
0x000000ecdf00720bULL, 0x000fe20003f5d000ULL, 0x000000cd00e87306ULL, 0x000e620000205400ULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x000001005dec7824ULL, 0x000fe400078e00ffULL,
0x000001005fdf7824ULL, 0x000fc800078e00ffULL, 0x000000d900e37306ULL, 0x000fe20000209400ULL,
0x00000018ffdf7819ULL, 0x000fce00000114dfULL, 0x000000d900e67306ULL, 0x0005f00000205400ULL,
0x0000003e009f7306ULL, 0x000fe20000009400ULL, 0x000000d900d97245ULL, 0x004fce000020d400ULL,
0x0000003e00a27306ULL, 0x000ff00000005400ULL, 0x0000003e00817306ULL, 0x0005f0000000d400ULL,
0x0000003000967306ULL, 0x000722000000d400ULL, 0x000000eb003e7245ULL, 0x004fc8000020d400ULL,
0x000000013e3e4812ULL, 0x000fe400078efcffULL, 0x000000e1e200720bULL, 0x000fe20003f9d000ULL,
0x0000003300e97306ULL, 0x000fe20000009400ULL, 0x000000e700e17245ULL, 0x000fe2000020d400ULL,
0x000001003c307824ULL, 0x008fc600078e00ffULL, 0x00000001e1e12812ULL, 0x000fe400078efcffULL,
0x000000e8e500720bULL, 0x002fe20003f5d000ULL, 0x0000003300ea7306ULL, 0x000e620000005400ULL,
0x0000000196965812ULL, 0x010fe200078efcffULL, 0x0000010061e57824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000001c0c04812ULL, 0x000fe400078efcffULL,
0x00000018ffe57819ULL, 0x000fe200000114e5ULL, 0x000000c200db7306ULL, 0x000ff00000209400ULL,
0x000000c200de7306ULL, 0x000ea20000205400ULL, 0x000000eae900720bULL, 0x002fce0003fbd000ULL,
0x0000003300887306ULL, 0x0002f0000000d400ULL, 0x0000003f00af7306ULL, 0x000fe20000009400ULL,
0x0001000033337824ULL, 0x002fe200078e00ffULL, 0x000000dedb00720bULL, 0x004fc40003fdd000ULL,
0x000000cd00de7245ULL, 0x000fe4000020d400ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003f00a07306ULL, 0x000fe20000005400ULL, 0x00000001dede2812ULL, 0x000fe400078efcffULL,
0x0000000188885812ULL, 0x008fe400078efcffULL, 0x00000018ffdb7819ULL, 0x000fc600000114ecULL,
0x0000003f00807306ULL, 0x0003f0000000d400ULL, 0x000000c300ce7306ULL, 0x000fe20000209400ULL,
0x000000e4003f7245ULL, 0x002fc8000020d400ULL, 0x000000013f3f3812ULL, 0x000fe400078efcffULL,
0x000000e6e300720bULL, 0x000fe20003f7d000ULL, 0x000000c300d57306ULL, 0x0002a20000205400ULL,
0x0000010060e37824ULL, 0x000fe200078e00ffULL, 0x0000003e3f3e723eULL, 0x000fc800000010ffULL,
0x00000018ffe37819ULL, 0x000fe400000114e3ULL, 0x0000003c00b87306ULL, 0x000fe20000009400ULL,
0x000000c300c37245ULL, 0x002fc6000020d400ULL, 0x00000001d9d93812ULL, 0x000fc800078efcffULL,
0x0000003c00bb7306ULL, 0x000e620000005400ULL, 0x000000d5ce00720bULL, 0x004fe40003f5d000ULL,
0x000000d9c03f723eULL, 0x000fca00000010ffULL, 0x000000b300b77306ULL, 0x000fec0000209400ULL,
0x00000001c3c32812ULL, 0x000fe400078efcffULL, 0x000000b300b47306ULL, 0x0004e20000205400ULL,
0x000000bbb800720bULL, 0x002fe40003f7d000ULL, 0x000000c200bb7245ULL, 0x000fc8000020d400ULL,
0x00000001bbbb6812ULL, 0x000fe200078efcffULL, 0x0000003300cf7306ULL, 0x000fe20000209400ULL,
0x000000b300b37245ULL, 0x004fce000020d400ULL, 0x0000003300d07306ULL, 0x000e620000205400ULL,
0x000000b4b700720bULL, 0x008fe40003fbd000ULL, 0x0000003300b47245ULL, 0x000fca000020d400ULL,
0x0000003c00867306ULL, 0x0004ec000000d400ULL, 0x00000001b3b35812ULL, 0x000fe400078efcffULL,
0x0000003000bc7306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x004fe200078e00ffULL,
0x000000d0cf00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003000bf7306ULL, 0x0002a20000205400ULL, 0x0000000186863812ULL, 0x008fcc00078efcffULL,
0x00000001b4b46812ULL, 0x000fe200078efcffULL, 0x0000003200d77306ULL, 0x000fe20000009400ULL,
0x000000a29f00720bULL, 0x000fe40003fdd000ULL, 0x00000030009f7245ULL, 0x000fe4000020d400ULL,
0x0000003100a27245ULL, 0x000fe4000020d400ULL, 0x0000b0000b307811ULL, 0x002fe200078e20ffULL,
0x0000003200da7306ULL, 0x000e620000005400ULL, 0x000000bfbc00720bULL, 0x004fca0003f5d000ULL,
0x0000000181816812ULL, 0x000fe400078efcffULL, 0x0000003c00be7306ULL, 0x000fec0000209400ULL,
0x000000019f9f2812ULL, 0x000fe400078efcffULL, 0x0000003c00c57306ULL, 0x000ea20000205400ULL,
0x000000dad700720bULL, 0x002fe20003f3d000ULL, 0x000001005cda7824ULL, 0x000fe200078e00ffULL,
0x000000869f86723eULL, 0x000fc800000010ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x000000b0009e7306ULL, 0x000ff00000209400ULL, 0x000000b0009b7306ULL, 0x0002e20000205400ULL,
0x000000c5be00720bULL, 0x004fce0003fbd000ULL, 0x000000b500ba7306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fce000020d400ULL, 0x000000b500bd7306ULL, 0x000e620000205400ULL,
0x0000009b9e00720bULL, 0x008fe40003f5d000ULL, 0x0000003c009b7245ULL, 0x000fc8000020d400ULL,
0x000000019b9b5812ULL, 0x000fe200078efcffULL, 0x0000003200897306ULL, 0x000ea2000000d400ULL,
0x000000a0af00720bULL, 0x000fca0003fbd000ULL, 0x00000001b0b02812ULL, 0x000fe400078efcffULL,
0x0000003100327306ULL, 0x000fe20000209400ULL, 0x000000bdba00720bULL, 0x002fe40003f9d000ULL,
0x0000009bb0b0723eULL, 0x000fc600000010ffULL, 0x0000000180805812ULL, 0x000fe400078efcffULL,
0x0000003100c17306ULL, 0x000e620000205400ULL, 0x0000000189891812ULL, 0x004fe400078efcffULL,
0x000000b6b900720bULL, 0x000fe40003f3d000ULL, 0x000000b500b67245ULL, 0x000fc6000020d400ULL,
0x0000009900aa7306ULL, 0x000fe20000209400ULL, 0x00000001b6b64812ULL, 0x000fce00078efcffULL,
0x00000099009d7306ULL, 0x0004e20000205400ULL, 0x000000c13200720bULL, 0x002fe40003f9d000ULL,
0x0000000183831812ULL, 0x000fe200078efcffULL, 0x000000003030783bULL, 0x000fe80000000200ULL,
0x000000c800c97306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x004fca000020d400ULL,
0x00000001a2a24812ULL, 0x000fe400078efcffULL, 0x000000c800ca7306ULL, 0x0002a20000205400ULL,
0x0000009daa00720bULL, 0x008fe40003fbd000ULL, 0x00000002ff9d7819ULL, 0x000fca000001162bULL,
0x000000ae00b17306ULL, 0x000fe20000209400ULL, 0x000000c800c87245ULL, 0x002fca000020d400ULL,
0x0000000199995812ULL, 0x000fe400078efcffULL, 0x000000ae00b27306ULL, 0x0002e20000205400ULL,
0x000000cac900720bULL, 0x004fce0003f3d000ULL, 0x000000c400c67306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x00000001c8c81812ULL, 0x000fe400078efcffULL,
0x000000c400c77306ULL, 0x000e620000205400ULL, 0x000000b2b100720bULL, 0x008fe40003f7d000ULL,
0x000000c400b17245ULL, 0x000fe4000020d400ULL, 0x00000081c8c8723eULL, 0x000fc600000010ffULL,
0x000000a700ab7306ULL, 0x000fec0000209400ULL, 0x00000001aeae3812ULL, 0x000fe400078efcffULL,
0x000000a700a67306ULL, 0x0004e20000205400ULL, 0x000000c7c600720bULL, 0x002fce0003f9d000ULL,
0x0000009300a37306ULL, 0x000fe20000209400ULL, 0x000000a700a77245ULL, 0x004fca000020d400ULL,
0x00000001b1b14812ULL, 0x000fe400078efcffULL, 0x00000093009a7306ULL, 0x0002a20000205400ULL,
0x000000a6ab00720bULL, 0x008fe40003f3d000ULL, 0x000000b1aeb1723eULL, 0x000fca00000010ffULL,
0x000000d600d77306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fca000020d400ULL,
0x00000001a7a71812ULL, 0x000fe400078efcffULL, 0x000000d600d87306ULL, 0x0002e20000205400ULL,
0x0000009aa300720bULL, 0x004fce0003fbd000ULL, 0x0000005c00ad7306ULL, 0x000fe20000009400ULL,
0x000000d600d67245ULL, 0x002fca000020d400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x0000005c00a47306ULL, 0x000e620000005400ULL, 0x000000d8d700720bULL, 0x008fce0003fdd000ULL,
0x0000005c007d7306ULL, 0x0004ec000000d400ULL, 0x00000001d6d66812ULL, 0x000fe400078efcffULL,
0x000000cb00cc7306ULL, 0x000fe20000209400ULL, 0x000100005c5c7824ULL, 0x004fe200078e00ffULL,
0x000000a4ad00720bULL, 0x002fc40003f9d000ULL, 0x000000d69999723eULL, 0x000fe400000010ffULL,
0x00000018ffe27819ULL, 0x000fe2000001145cULL, 0x00000100635c7824ULL, 0x000fe200078e00ffULL,
0x000000cb00d17306ULL, 0x0002ae0000205400ULL, 0x000000017d7d4812ULL, 0x008fe200078efcffULL,
0x0000005e009c7306ULL, 0x000fe20000009400ULL, 0x000000cb00cb7245ULL, 0x002fce000020d400ULL,
0x0000005e00a57306ULL, 0x000e620000005400ULL, 0x000000d1cc00720bULL, 0x004fce0003f5d000ULL,
0x000000e200e67306ULL, 0x000fec0000209400ULL, 0x00000001cbcb2812ULL, 0x000fe400078efcffULL,
0x000000e200e77306ULL, 0x0004e20000205400ULL, 0x000000a59c00720bULL, 0x002fe40003f3d000ULL,
0x00000080cbc9723eULL, 0x000fca00000010ffULL, 0x000000dc00b57306ULL, 0x000fe20000209400ULL,
0x000000e200e27245ULL, 0x004fce000020d400ULL, 0x000000dc00b27306ULL, 0x000e620000205400ULL,
0x000000e7e600720bULL, 0x008fce0003fdd000ULL, 0x0000005d00a97306ULL, 0x000fec0000009400ULL,
0x00000001e2e26812ULL, 0x000fe400078efcffULL, 0x0000005d00ac7306ULL, 0x000ea20000005400ULL,
0x000000b2b500720bULL, 0x002fe40003fbd000ULL, 0x000000e293e2723eULL, 0x000fca00000010ffULL,
0x0000005f00927306ULL, 0x000ff00000009400ULL, 0x0000005f00917306ULL, 0x000fe20000005400ULL,
0x000000aca900720bULL, 0x004fce0003f5d000ULL, 0x0000005f00777306ULL, 0x0003f0000000d400ULL,
0x000000db00cd7306ULL, 0x000fe20000209400ULL, 0x000100005f5f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe4000001145fULL, 0x000000db00b87306ULL, 0x0002a20000205400ULL,
0x00000010ff5f723eULL, 0x000fe400000010ffULL, 0x0000009c009f7245ULL, 0x000fe4000020d400ULL,
0x000054105fa57816ULL, 0x000fe2000000005fULL, 0x000000ffff5f7224ULL, 0x000fe200078e008fULL,
0x000000dc008f7245ULL, 0x000fe2000020d400ULL, 0x000000e000b77306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x002fe2000020d400ULL, 0x00001f9da59d7589ULL, 0x000e6200000e0000ULL,
0x000000018f8f5812ULL, 0x000fc600078efcffULL, 0x00001f0aa59a7589ULL, 0x000ee400000e0000ULL,
0x000000e000ba7306ULL, 0x0008620000205400ULL, 0x000000b8cd00720bULL, 0x004fce0003f9d000ULL,
0x000000df003c7306ULL, 0x000fe20000209400ULL, 0x000000e000e07245ULL, 0x010fca000020d400ULL,
0x00000001dbdb4812ULL, 0x000fe400078efcffULL, 0x000000df00ad7306ULL, 0x000ea20000205400ULL,
0x000000bab700720bULL, 0x002fe40003fdd000ULL, 0x000000919200720bULL, 0x000fe40003f9d000ULL,
0x0000009400917245ULL, 0x000fc6000020d400ULL, 0x0000005e00767306ULL, 0x00032c000000d400ULL,
0x00000001e0e06812ULL, 0x000fe400078efcffULL, 0x000000d200d37306ULL, 0x000fe20000209400ULL,
0x000100005e5e7824ULL, 0x002fe200078e00ffULL, 0x000000ad3c00720bULL, 0x004fc40003fbd000ULL,
0x000000963d3c723eULL, 0x000fe400000010ffULL, 0x00000018ff9e7819ULL, 0x000fe4000001145eULL,
0x000000d200d47306ULL, 0x0002a20000205400ULL, 0x0000000176761812ULL, 0x010fe400078efcffULL,
0x0000008ee13d723eULL, 0x000fe400000010ffULL, 0x000000df008e7245ULL, 0x000fe4000020d400ULL,
0x0000000177774812ULL, 0x000fe200078efcffULL, 0x0000005d007c7306ULL, 0x0008e2000000d400ULL,
0x000000d200d27245ULL, 0x002fc4000020d400ULL, 0x000000018e8e5812ULL, 0x000fe400078efcffULL,
0x000000768f76723eULL, 0x000fe400000010ffULL, 0x000000778e77723eULL, 0x000fe200000010ffULL,
0x00000087008d7306ULL, 0x000fe20000209400ULL, 0x000000d4d300720bULL, 0x004fe20003f7d000ULL,
0x00000100625d7824ULL, 0x010fcc00078e00ffULL, 0x00000087008c7306ULL, 0x000e620000205400ULL,
0x000000017c7c2812ULL, 0x008fe400078efcffULL, 0x000000ff5f00720cULL, 0x000fe40003f45270ULL,
0x00000088bb5f723eULL, 0x000fe400000010ffULL, 0x00000001d2d23812ULL, 0x000fe200078efcffULL,
0x0000006000907306ULL, 0x000fe20000009400ULL, 0x0000007cdbdb723eULL, 0x000fce00000010ffULL,
0x0000006000957306ULL, 0x000ea20000005400ULL, 0x0000008c8d00720bULL, 0x002fe20003f3d000ULL,
0x0000009d3030a231ULL, 0x080fe400003400ffULL, 0x0000009d3232a231ULL, 0x000fe400003400ffULL,
0x0000009a3131a231ULL, 0x080fe400003400ffULL, 0x0000009e005e7306ULL, 0x000fe20000209400ULL,
0x0000009a3333a231ULL, 0x000fce00003400ffULL, 0x0000009e00a97306ULL, 0x0002e20000205400ULL,
0x000000959000720bULL, 0x004fe20003fdd000ULL, 0x0000003c3054723cULL, 0x040fec0000041854ULL,
0x000000da00dd7306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x002fe2000020d400ULL,
0x0000003e3050723cULL, 0x000fe20000041850ULL, 0x0000b000093c7811ULL, 0x000fca00078e20ffULL,
0x000000da00e47306ULL, 0x0002a20000205400ULL, 0x000000a95e00720bULL, 0x008fe20003fbd000ULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0x00000089de5e723eULL, 0x000fe200000010ffULL,
0x000000b03040723cULL, 0x040fe20000041840ULL, 0x0000008700897245ULL, 0x000fe4000020d400ULL,
0x00000083a287723eULL, 0x000fe200000010ffULL, 0x000000e300a37306ULL, 0x000fe20000209400ULL,
0x0000000189891812ULL, 0x000fe400078efcffULL, 0x000000da00da7245ULL, 0x002fe2000020d400ULL,
0x0000005e304c723cULL, 0x000fe4000004184cULL, 0x000000019e9e5812ULL, 0x000fc400078efcffULL,
0x000000e300a47306ULL, 0x000e620000205400ULL, 0x000000e4dd00720bULL, 0x004fe40003f7d000ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145dULL, 0x000000863044723cULL, 0x040fe20000041844ULL,
0x000000e3005d7245ULL, 0x000fe4000020d400ULL, 0x0000009e899e723eULL, 0x000fe200000010ffULL,
0x0000006000707306ULL, 0x000528000000d400ULL, 0x000000c83034723cULL, 0x000fe40000041834ULL,
0x00000001dada3812ULL, 0x000fc400078efcffULL, 0x00000084008b7306ULL, 0x000fe20000209400ULL,
0x0001000060607824ULL, 0x004fe200078e00ffULL, 0x000000a4a300720bULL, 0x002fe40003f3d000ULL,
0x0000007ddada723eULL, 0x000fe400000010ffULL, 0x00000018ff907819ULL, 0x000fe40000011460ULL,
0x00000084008a7306ULL, 0x0002a20000205400ULL, 0x0000000170706812ULL, 0x010fe200078efcffULL,
0x0000009d3c3ca231ULL, 0x088fe200003400ffULL, 0x000000c3b660723eULL, 0x000fe200000010ffULL,
0x0000009d3e3ea231ULL, 0x000fc400003400ffULL, 0x0000009a3d3da231ULL, 0x080fe200003400ffULL,
0x000000015d5d1812ULL, 0x000fe200078efcffULL, 0x0000009400a87306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x002fe2000020d400ULL, 0x0000009a3f3fa231ULL, 0x000fe200003400ffULL,
0x000000705d70723eULL, 0x000fca00000010ffULL, 0x0000009400a17306ULL, 0x000e620000205400ULL,
0x0000008a8b00720bULL, 0x004fe20003f9d000ULL, 0x000000da3c54723cULL, 0x040fec0000041854ULL,
0x000000e500947306ULL, 0x000fe40000209400ULL, 0x000000763c4c723cULL, 0x000fe8000004184cULL,
0x0000000184844812ULL, 0x000fc400078efcffULL, 0x000000e500957306ULL, 0x000ea20000205400ULL,
0x000000a1a800720bULL, 0x002fce0003f7d000ULL, 0x0000009000927306ULL, 0x000fec0000209400ULL,
0x0000000191913812ULL, 0x000fe400078efcffULL, 0x00000090008d7306ULL, 0x0002e20000205400ULL,
0x000000959400720bULL, 0x004fe40003f3d000ULL, 0x000000e091e3723eULL, 0x000fca00000010ffULL,
0x00000063007f7306ULL, 0x000fe20000009400ULL, 0x0000009000907245ULL, 0x002fe2000020d400ULL,
0x000000e23c50723cULL, 0x000fec0000041850ULL, 0x00000063007e7306ULL, 0x000e620000005400ULL,
0x0000008d9200720bULL, 0x008fce0003fdd000ULL, 0x0000006100977306ULL, 0x000fec0000009400ULL,
0x0000000190906812ULL, 0x000fe400078efcffULL, 0x0000006100987306ULL, 0x000ea20000005400ULL,
0x0000007e7f00720bULL, 0x002fe40003f9d000ULL, 0x00000018ff7e7819ULL, 0x000fc4000001145cULL,
0x000000e5005c7245ULL, 0x000fc6000020d400ULL, 0x0000006100717306ULL, 0x0002e2000000d400ULL,
0x000000015c5c1812ULL, 0x000fce00078efcffULL, 0x00000079007b7306ULL, 0x000fe20000209400ULL,
0x0001000061617824ULL, 0x002fe200078e00ffULL, 0x000000989700720bULL, 0x004fe40003f7d000ULL,
0x000000d2a798723eULL, 0x000fe400000010ffULL, 0x00000018ff8a7819ULL, 0x000fe40000011461ULL,
0x00000079007a7306ULL, 0x0002a20000205400ULL, 0x000000b4b361723eULL, 0x000fe400000010ffULL,
0x0000008a00917245ULL, 0x000fc8000020d400ULL, 0x0000000171713812ULL, 0x008fe200078efcffULL,
0x0000007400757306ULL, 0x000fe20000209400ULL, 0x000000603048723cULL, 0x000fe20000041848ULL,
0x0000007900797245ULL, 0x002fe4000020d400ULL, 0x000000715c71723eULL, 0x000fc800000010ffULL,
0x0000007400787306ULL, 0x0002e20000205400ULL, 0x0000007a7b00720bULL, 0x004fe20003f3d000ULL,
0x000000983030723cULL, 0x000fec0000041838ULL, 0x0000009c00a07306ULL, 0x000fe20000209400ULL,
0x0000007400747245ULL, 0x002fe2000020d400ULL, 0x000000703c44723cULL, 0x000fe20000041844ULL,
0x0000005e00397245ULL, 0x000fc6000020d400ULL, 0x0000000179791812ULL, 0x000fe400078efcffULL,
0x0000009c00a17306ULL, 0x000e620000205400ULL, 0x000000787500720bULL, 0x008fe40003fdd000ULL,
0x000000907990723eULL, 0x000fca00000010ffULL, 0x0000008a00887306ULL, 0x000fec0000209400ULL,
0x0000000174746812ULL, 0x000fe400078efcffULL, 0x0000008a005f7306ULL, 0x000ea20000205400ULL,
0x000000a1a000720bULL, 0x002fce0003fbd000ULL, 0x0000006200857306ULL, 0x000fec0000009400ULL,
0x000000019f9f5812ULL, 0x000fe400078efcffULL, 0x0000006200827306ULL, 0x000e620000005400ULL,
0x0000005f8800720bULL, 0x004fe40003f7d000ULL, 0x0000009f849f723eULL, 0x000fca00000010ffULL,
0x0000005e00607306ULL, 0x000fe40000209400ULL, 0x0000009e3c48723cULL, 0x000fe80000041848ULL,
0x0000000191913812ULL, 0x000fe400078efcffULL, 0x0000005e00617306ULL, 0x000ea20000205400ULL,
0x000000828500720bULL, 0x002fe40003fbd000ULL, 0x000000917491723eULL, 0x000fca00000010ffULL,
0x0000007e007f7306ULL, 0x000fe40000209400ULL, 0x000000903c40723cULL, 0x000fec0000041840ULL,
0x0000007e007c7306ULL, 0x0002e20000205400ULL, 0x000000616000720bULL, 0x004fce0003f3d000ULL,
0x00000062006c7306ULL, 0x000522000000d400ULL, 0x0000007e007e7245ULL, 0x002fca000020d400ULL,
0x0000000139391812ULL, 0x000fe400078efcffULL, 0x00000063006d7306ULL, 0x000322000000d400ULL,
0x0001000062627824ULL, 0x004fe200078e00ffULL, 0x0000007c7f00720bULL, 0x008fc80003fdd000ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000006a00737306ULL, 0x000fe20000209400ULL,
0x0001000063637824ULL, 0x002fe200078e00ffULL, 0x000000016c6c5812ULL, 0x010fc800078efcffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000006a00727306ULL, 0x000e620000205400ULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x0000006c396c723eULL, 0x000fe400000010ffULL,
0x0000006a00397245ULL, 0x000fe4000020d400ULL, 0x000000016d6d4812ULL, 0x000fe200078efcffULL,
0x0000006b006e7306ULL, 0x000fe60000209400ULL, 0x0000006d7e6d723eULL, 0x000fca00000010ffULL,
0x0000006b006f7306ULL, 0x000ea20000205400ULL, 0x000000727300720bULL, 0x002fe20003f7d000ULL,
0x0000006c3c34723cULL, 0x000fec0000041834ULL, 0x0000006200387306ULL, 0x000fec0000209400ULL,
0x0000000139393812ULL, 0x000fc400078efcffULL, 0x00000062003b7306ULL, 0x0002e20000205400ULL,
0x0000006f6e00720bULL, 0x004fce0003f3d000ULL, 0x00000063003a7306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x002fce000020d400ULL, 0x00000063005f7306ULL, 0x0002a20000205400ULL,
0x0000003b3800720bULL, 0x008fe40003fbd000ULL, 0x0000006b00387245ULL, 0x000fc8000020d400ULL,
0x0000000138381812ULL, 0x000fe400078efcffULL, 0x0000006300637245ULL, 0x002fca000020d400ULL,
0x0000000162625812ULL, 0x000fe400078efcffULL, 0x0000005f3a00720bULL, 0x004fe40003fdd000ULL,
0x000000623962723eULL, 0x000fd600000010ffULL, 0x0000000163636812ULL, 0x000fc800078efcffULL,
0x000000633863723eULL, 0x000fce00000010ffULL, 0x000000623c3c723cULL, 0x000fe20000041830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01065c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000c05b307811ULL, 0x000fe200078e40ffULL, 0x000000042d5d7e24ULL, 0x020fe2000f8e022aULL,
0x00000004ff3b7819ULL, 0x000fe2000001162bULL, 0x00000100ff5f7424ULL, 0x000fe200078e00ffULL,
0x0000003059317217ULL, 0x000fc40007800000ULL, 0x0000003f5d327812ULL, 0x040fe400078ef81cULL,
0x0000003f5d387812ULL, 0x000fe200078ef81bULL, 0x0000000131317824ULL, 0x000fe200078e0a30ULL,
0x0000003f5d307812ULL, 0x040fe400078ef822ULL, 0x0000003f5d3a7812ULL, 0x000fe400078ef81aULL,
0x0000002031337807ULL, 0x000fe20000000000ULL, 0x00005e0030307625ULL, 0x000fc600078e005fULL,
0x000000332c397217ULL, 0x000fe20007800000ULL, 0x00005e0032327625ULL, 0x000fe200078e005fULL,
0x0000002130307210ULL, 0x000fc60007f3e0ffULL, 0x00000001395c7824ULL, 0x000fe200078e0a2cULL,
0x0000002132327210ULL, 0x000fe20007f9e0ffULL, 0x00005e0038387625ULL, 0x000fc600078e005fULL,
0x0000005c2000720cULL, 0x080fe20003f66070ULL, 0x000000ffff317224ULL, 0x000fe200008e0631ULL,
0x0000002138387210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x0000005c3b00720cULL, 0x080fe20003f26070ULL, 0x00005e003a3a7625ULL, 0x000fe200078e005fULL,
0x0000005c1f00720cULL, 0x000fc60003f86070ULL, 0x000000ffff397224ULL, 0x000fe200028e0639ULL,
0x0000005c1d00720cULL, 0x000fe40003fa6070ULL, 0x000000213a3a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030087faeULL, 0x0003e8000c901c46ULL, 0x0000000032077faeULL, 0x0003e8000d901c46ULL,
0x0000000038067faeULL, 0x0003e8000e101c46ULL, 0x000000003a057faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff307984ULL, 0x002e620000000800ULL,
0x8000000069317824ULL, 0x000fca00078e00ffULL, 0x8000000030ff7812ULL, 0x002fe20007824831ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000069327824ULL, 0x000fe400078e00ffULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01065400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007824832ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000000430783bULL, 0x000e680000004200ULL,
0x000000000060783bULL, 0x000fe80000004200ULL, 0x000000000338783bULL, 0x000ea80000004200ULL,
0x00000000025c783bULL, 0x000ee20000004200ULL, 0x0000010030ca7824ULL, 0x042fe200078e00ffULL,
0x0000003000ab7306ULL, 0x000fe20000009400ULL, 0x0001000030c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe20000011430ULL, 0x0000010031c97824ULL, 0x040fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0001000031de7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000010032e47824ULL, 0x040fe200078e00ffULL,
0x000000ca00ad7306ULL, 0x000fe20000209400ULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010033e17824ULL, 0x040fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe20000011431ULL,
0x0001000032df7824ULL, 0x000fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fe200000114deULL,
0x0001000033da7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x000000ca00ae7306ULL, 0x000e620000205400ULL, 0x00000018ffe17819ULL, 0x000fe200000114e1ULL,
0x000001003aa87824ULL, 0x004fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fe20000011432ULL,
0x0001000039d17824ULL, 0x000fe200078e00ffULL, 0x00000018ffdf7819ULL, 0x000fe200000114dfULL,
0x000001003ba97824ULL, 0x040fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x0000003000aa7306ULL, 0x000ea20000005400ULL, 0x00000018ff767819ULL, 0x000fe20000011460ULL,
0x000100003baf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fc40000011433ULL,
0x00000018ffbc7819ULL, 0x000fe40000011438ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000003200ed7306ULL, 0x000fe20000009400ULL, 0x000000aead00720bULL, 0x002fe40003fdd000ULL,
0x00000018ffd17819ULL, 0x000fe400000114d1ULL, 0x00000018ff9c7819ULL, 0x000fe40000011439ULL,
0x00000018ff9d7819ULL, 0x000fe2000001143aULL, 0x0000003200b87306ULL, 0x000e620000005400ULL,
0x000000aaab00720bULL, 0x004fe20003fbd000ULL, 0x000100003aaa7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fc4000001143bULL, 0x00000018ffa37819ULL, 0x008fe4000001145cULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000c600ba7306ULL, 0x000fe20000209400ULL,
0x00000018ffa97819ULL, 0x000fe400000114a9ULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ff867819ULL, 0x000fe4000001145eULL, 0x00000018ff8e7819ULL, 0x000fe2000001145dULL,
0x000000c600bb7306ULL, 0x0004e20000205400ULL, 0x000000b8ed00720bULL, 0x002fc40003f9d000ULL,
0x000000ca00b87245ULL, 0x000fe4000020d400ULL, 0x00000018ff807819ULL, 0x000fe4000001145fULL,
0x00000001b8b86812ULL, 0x000fe200078efcffULL, 0x000000c300c77306ULL, 0x000fe20000209400ULL,
0x000000c600c67245ULL, 0x004fe4000020d400ULL, 0x00000018ff6f7819ULL, 0x000fe40000011461ULL,
0x00000018ff697819ULL, 0x000fc40000011462ULL, 0x00000018ff6a7819ULL, 0x000fe20000011463ULL,
0x000000c300d87306ULL, 0x0002a20000205400ULL, 0x000000bbba00720bULL, 0x008fce0003f3d000ULL,
0x00000030008f7306ULL, 0x000722000000d400ULL, 0x000000c300c37245ULL, 0x002fca000020d400ULL,
0x00000001c6c61812ULL, 0x000fe400078efcffULL, 0x000000c900ea7306ULL, 0x000fe20000209400ULL,
0x000000d8c700720bULL, 0x004fe20003fdd000ULL, 0x0000010039307824ULL, 0x008fe400078e00ffULL,
0x000100005cd87824ULL, 0x000fe400078e00ffULL, 0x000001005dc77824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000c900ef7306ULL, 0x000e620000205400ULL,
0x000000018f8f5812ULL, 0x010fc400078efcffULL, 0x00000018ffd87819ULL, 0x000fe400000114d8ULL,
0x00000018ffc77819ULL, 0x000fe400000114c7ULL, 0x00000001c3c36812ULL, 0x000fe200078efcffULL,
0x0000003100e97306ULL, 0x000fe60000009400ULL, 0x000000c3c6c6723eULL, 0x000fca00000010ffULL,
0x0000003100b27306ULL, 0x000ea20000005400ULL, 0x000000efea00720bULL, 0x002fce0003fbd000ULL,
0x000000cd00c87306ULL, 0x000ff00000209400ULL, 0x000000cd00c57306ULL, 0x0002e20000205400ULL,
0x000000b2e900720bULL, 0x004fe20003f7d000ULL, 0x000100005de97824ULL, 0x000fca00078e00ffULL,
0x00000018ffe97819ULL, 0x000fe200000114e9ULL, 0x000000de00cb7306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x002fce000020d400ULL, 0x000000de00cc7306ULL, 0x000e620000205400ULL,
0x000000c5c800720bULL, 0x008fe20003fdd000ULL, 0x0000010060c57824ULL, 0x000fe200078e00ffULL,
0x000000c900c87245ULL, 0x000fc8000020d400ULL, 0x00000001c8c85812ULL, 0x000fe200078efcffULL,
0x000000e400d27306ULL, 0x000fe20000209400ULL, 0x00000018ffc57819ULL, 0x000fca00000114c5ULL,
0x00000001cdcd6812ULL, 0x000fe400078efcffULL, 0x000000e400eb7306ULL, 0x000ea20000205400ULL,
0x000000cccb00720bULL, 0x002fe20003f3d000ULL, 0x0001000060cc7824ULL, 0x000fe400078e00ffULL,
0x0000010061cb7824ULL, 0x000fc600078e00ffULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x00000031008d7306ULL, 0x0002e2000000d400ULL, 0x00000018ffcb7819ULL, 0x000fce00000114cbULL,
0x000000e100e67306ULL, 0x000fe20000209400ULL, 0x000000ebd200720bULL, 0x004fe20003fbd000ULL,
0x0000010038317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x000000e100e77306ULL, 0x000e620000205400ULL, 0x000000018d8d3812ULL, 0x008fce00078efcffULL,
0x0000003300e07306ULL, 0x000ff00000009400ULL, 0x0000003300d77306ULL, 0x000fe20000005400ULL,
0x000000e7e600720bULL, 0x002fce0003f7d000ULL, 0x000000c100ce7306ULL, 0x000ff00000209400ULL,
0x000000c100cf7306ULL, 0x000ff00000205400ULL, 0x000000df00e57306ULL, 0x000ff00000209400ULL,
0x000000df00e87306ULL, 0x0002b00000205400ULL, 0x0000006000947306ULL, 0x000fe20000009400ULL,
0x000000df00df7245ULL, 0x002fce000020d400ULL, 0x0000006000957306ULL, 0x000fe20000005400ULL,
0x000000e8e500720bULL, 0x004fce0003fdd000ULL, 0x00000060006e7306ULL, 0x0003ec000000d400ULL,
0x00000001dfdf6812ULL, 0x000fe400078efcffULL, 0x000000da00e27306ULL, 0x000fe20000209400ULL,
0x000000de00607245ULL, 0x002fc8000020d400ULL, 0x0000000160601812ULL, 0x000fe400078efcffULL,
0x000000d7e000720bULL, 0x000fe20003f3d000ULL, 0x000000da00e37306ULL, 0x0002a20000205400ULL,
0x000000e400d77245ULL, 0x000fc8000020d400ULL, 0x00000001d7d75812ULL, 0x000fe400078efcffULL,
0x000000cfce00720bULL, 0x000fe20003fbd000ULL, 0x0000003300877306ULL, 0x000722000000d400ULL,
0x000000e100ce7245ULL, 0x000fe4000020d400ULL, 0x000000da00da7245ULL, 0x002fe4000020d400ULL,
0x00000001cece3812ULL, 0x000fc600078efcffULL, 0x000000c000c27306ULL, 0x000fe20000209400ULL,
0x0001000038337824ULL, 0x008fe200078e00ffULL, 0x000000e3e200720bULL, 0x004fc80003f7d000ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x000000c000b57306ULL, 0x000e620000205400ULL,
0x0000000187871812ULL, 0x010fcc00078efcffULL, 0x00000001dada3812ULL, 0x000fe200078efcffULL,
0x0000003100dc7306ULL, 0x000ff00000209400ULL, 0x0000003100d97306ULL, 0x000ea20000205400ULL,
0x000000b5c200720bULL, 0x002fc40003f3d000ULL, 0x000000c000b57245ULL, 0x000fe4000020d400ULL,
0x000000c100c27245ULL, 0x000fc6000020d400ULL, 0x0000003900bf7306ULL, 0x000fe20000009400ULL,
0x00000001c2c25812ULL, 0x000fca00078efcffULL, 0x00000001b5b51812ULL, 0x000fe400078efcffULL,
0x0000003900ac7306ULL, 0x000e620000005400ULL, 0x000000d9dc00720bULL, 0x004fe40003fdd000ULL,
0x000000dab5b5723eULL, 0x000fca00000010ffULL, 0x0000003200887306ULL, 0x000eb0000000d400ULL,
0x0000003800c47306ULL, 0x000fe20000009400ULL, 0x000000acbf00720bULL, 0x002fe40003f7d000ULL,
0x0000003100ac7245ULL, 0x000fc8000020d400ULL, 0x00000001acac6812ULL, 0x000fe200078efcffULL,
0x0000003800b77306ULL, 0x000e620000005400ULL, 0x0000000188884812ULL, 0x004fc800078efcffULL,
0x00000088d788723eULL, 0x000fc600000010ffULL, 0x000000bc00b47306ULL, 0x000ff00000209400ULL,
0x000000bc00b97306ULL, 0x000ea20000205400ULL, 0x000000b7c400720bULL, 0x002fe40003f9d000ULL,
0x0000003000b77245ULL, 0x000fca000020d400ULL, 0x0000003000327306ULL, 0x000ff00000209400ULL,
0x0000003000dd7306ULL, 0x0002e20000205400ULL, 0x000000b9b400720bULL, 0x004fce0003f3d000ULL,
0x0000003800857306ULL, 0x000ea2000000d400ULL, 0x0000b00065307811ULL, 0x002fce00078e20ffULL,
0x0000003300387306ULL, 0x000fe20000209400ULL, 0x000000dd3200720bULL, 0x008fce0003fbd000ULL,
0x0000003300d57306ULL, 0x000e620000205400ULL, 0x0000000185854812ULL, 0x004fc800078efcffULL,
0x00000085acac723eULL, 0x000fe400000010ffULL, 0x00000001b7b75812ULL, 0x000fe200078efcffULL,
0x0000003900847306ULL, 0x000eb0000000d400ULL, 0x0000003b00be7306ULL, 0x000fe20000009400ULL,
0x000000d53800720bULL, 0x002fc40003fdd000ULL, 0x0000b00064387811ULL, 0x000fca00078e20ffULL,
0x0000003b00b17306ULL, 0x000e620000005400ULL, 0x0000000184843812ULL, 0x004fce00078efcffULL,
0x0000003a00bd7306ULL, 0x000ff00000009400ULL, 0x0000003a00b07306ULL, 0x000ea20000005400ULL,
0x000000b1be00720bULL, 0x002fe40003f7d000ULL, 0x000000bc00b17245ULL, 0x000fc4000020d400ULL,
0x00000002ffbe7819ULL, 0x000fe4000001162bULL, 0x00000001b1b11812ULL, 0x000fe200078efcffULL,
0x000000a800d37306ULL, 0x000ff00000209400ULL, 0x000000a800d47306ULL, 0x0002e20000205400ULL,
0x000000b0bd00720bULL, 0x004fc40003f9d000ULL, 0x0000003300b07245ULL, 0x000fe4000020d400ULL,
0x000000003030783bULL, 0x000fe40000000200ULL, 0x00000001b0b06812ULL, 0x000fe200078efcffULL,
0x000000d100d67306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fe4000020d400ULL,
0x000000b0b1b0723eULL, 0x000fca00000010ffULL, 0x000000d100397306ULL, 0x0002a20000205400ULL,
0x000000d4d300720bULL, 0x008fce0003f3d000ULL, 0x0000009c00b37306ULL, 0x000fe20000209400ULL,
0x000000d100d17245ULL, 0x002fca000020d400ULL, 0x00000001a8a81812ULL, 0x000fe400078efcffULL,
0x0000009c00b67306ULL, 0x000e620000205400ULL, 0x00000039d600720bULL, 0x004fce0003fbd000ULL,
0x0000003a00817306ULL, 0x0004ec000000d400ULL, 0x00000001d1d15812ULL, 0x000fe400078efcffULL,
0x0000003b007b7306ULL, 0x000962000000d400ULL, 0x000001005c3a7824ULL, 0x004fe200078e00ffULL,
0x000000b6b300720bULL, 0x002fc40003fdd000ULL, 0x0000009c00b67245ULL, 0x000fe4000020d400ULL,
0x00000018ffba7819ULL, 0x000fe2000001143aULL, 0x000001005f3a7824ULL, 0x000fe200078e00ffULL,
0x000000aa00ab7306ULL, 0x000fe20000209400ULL, 0x000001005e3b7824ULL, 0x010fe200078e00ffULL,
0x0000000181814812ULL, 0x008fe400078efcffULL, 0x00000018ffb47819ULL, 0x000fe4000001143aULL,
0x00000018ffc07819ULL, 0x000fc4000001143bULL, 0x000000aa00ae7306ULL, 0x0002a20000205400ULL,
0x000000003838783bULL, 0x000fe20000000200ULL, 0x00000001b6b66812ULL, 0x000fe400078efcffULL,
0x000000a9009c7245ULL, 0x000fe4000020d400ULL, 0x000000017b7b3812ULL, 0x020fe400078efcffULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fe4000020d400ULL,
0x000000d1b6b1723eULL, 0x000fc400000010ffULL, 0x00000081a8a8723eULL, 0x000fc600000010ffULL,
0x0000009d009f7306ULL, 0x0002e20000205400ULL, 0x000000aeab00720bULL, 0x004fce0003f3d000ULL,
0x0000005c00927306ULL, 0x000fe20000009400ULL, 0x0000009d009d7245ULL, 0x002fca000020d400ULL,
0x00000001aaaa1812ULL, 0x000fe400078efcffULL, 0x0000005c009b7306ULL, 0x000e620000005400ULL,
0x0000009f9e00720bULL, 0x008fce0003fdd000ULL, 0x0000005c007a7306ULL, 0x0004ec000000d400ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x000000d800de7306ULL, 0x000fe20000209400ULL,
0x000100005e5c7824ULL, 0x004fe200078e00ffULL, 0x0000009b9200720bULL, 0x002fc40003f7d000ULL,
0x000000aa9daa723eULL, 0x000fe400000010ffULL, 0x00000018ffb37819ULL, 0x000fe4000001145cULL,
0x00000010ff5c723eULL, 0x000fe200000010ffULL, 0x000000d800e57306ULL, 0x0003e60000205400ULL,
0x000054105cab7816ULL, 0x000fc6000000005cULL, 0x000000017a7a3812ULL, 0x008fe400078efcffULL,
0x00001fbeab9f7589ULL, 0x000ea200000e0000ULL, 0x000000a000a17306ULL, 0x000fe20000209400ULL,
0x000000d800d87245ULL, 0x002fe4000020d400ULL, 0x00001f0aab5c7589ULL, 0x000e6a00000e0000ULL,
0x000000a000a27306ULL, 0x0007300000205400ULL, 0x000000a900d07306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x008fe2000020d400ULL, 0x0000009f3030a231ULL, 0x004fcc00003400ffULL,
0x000000a900db7306ULL, 0x000ea20000205400ULL, 0x0000009f3232a231ULL, 0x080fe200003400ffULL,
0x000000a2a100720bULL, 0x010fe20003f9d000ULL, 0x0000009f3838a231ULL, 0x080fe400003400ffULL,
0x0000009f3a3aa231ULL, 0x000fe400003400ffULL, 0x0000005c3131a231ULL, 0x082fe200003400ffULL,
0x000000c000bf7306ULL, 0x000fe20000209400ULL, 0x0000005c3333a231ULL, 0x080fe400003400ffULL,
0x0000005c3939a231ULL, 0x000fc400003400ffULL, 0x0000005c3b3ba231ULL, 0x000fe200003400ffULL,
0x000000e5de00720bULL, 0x000fe40003f5d000ULL, 0x000000c000dc7306ULL, 0x0002e20000205400ULL,
0x000000dbd000720bULL, 0x004fe20003fbd000ULL, 0x000000b03040723cULL, 0x000fe20000041840ULL,
0x00000001a0a04812ULL, 0x000fe400078efcffULL, 0x0000008fb85c723eULL, 0x000fc600000010ffULL,
0x000000c700c97306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fe4000020d400ULL,
0x00000001d8d82812ULL, 0x000fc600078efcffULL, 0x000000019c9c5812ULL, 0x000fe400078efcffULL,
0x000000c700d27306ULL, 0x000e620000205400ULL, 0x000000dcbf00720bULL, 0x008fe40003f5d000ULL,
0x0000007b9ca9723eULL, 0x000fca00000010ffULL, 0x000000af00ad7306ULL, 0x000fe40000209400ULL,
0x000000a83034723cULL, 0x000fe80000041834ULL, 0x00000001c0c02812ULL, 0x000fe400078efcffULL,
0x000000af00b27306ULL, 0x0004e20000205400ULL, 0x000000d2c900720bULL, 0x002fce0003f9d000ULL,
0x0000005e00907306ULL, 0x000fe20000009400ULL, 0x000000af00af7245ULL, 0x004fce000020d400ULL,
0x0000005e00977306ULL, 0x000e620000005400ULL, 0x000000b2ad00720bULL, 0x008fe40003fbd000ULL,
0x00000084b7ad723eULL, 0x000fca00000010ffULL, 0x000000b400bc7306ULL, 0x000fe40000209400ULL,
0x000000ac3044723cULL, 0x000fe80000041844ULL, 0x00000001afaf5812ULL, 0x000fe400078efcffULL,
0x000000b400bd7306ULL, 0x000ea20000205400ULL, 0x000000979000720bULL, 0x002fe40003fdd000ULL,
0x000000c700907245ULL, 0x000fc4000020d400ULL, 0x00000060cdc7723eULL, 0x000fe400000010ffULL,
0x0000000190904812ULL, 0x000fe200078efcffULL, 0x000000e900c47306ULL, 0x000fe20000209400ULL,
0x000000afa0ab723eULL, 0x000fc600000010ffULL, 0x000000c63050723cULL, 0x000fe80000041850ULL,
0x000000e900c17306ULL, 0x0002e20000205400ULL, 0x000000bdbc00720bULL, 0x004fc60003f5d000ULL,
0x000000aa303c723cULL, 0x000fe8000004183cULL, 0x0000005d009a7306ULL, 0x000fe20000009400ULL,
0x000000e900e97245ULL, 0x002fce000020d400ULL, 0x0000005d00937306ULL, 0x000e620000005400ULL,
0x000000c1c400720bULL, 0x008fe40003f9d000ULL, 0x000000b400c17245ULL, 0x000fe4000020d400ULL,
0x000000dfc2b4723eULL, 0x000fe400000010ffULL, 0x00000001c1c12812ULL, 0x000fe200078efcffULL,
0x0000005e00757306ULL, 0x0004e8000000d400ULL, 0x000000b43048723cULL, 0x000fe40000041848ULL,
0x00000001e9e94812ULL, 0x000fc400078efcffULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x000000939a00720bULL, 0x002fe20003f3d000ULL, 0x00000100635e7824ULL, 0x004fe200078e00ffULL,
0x000000ba00937245ULL, 0x000fca000020d400ULL, 0x000000ba00ca7306ULL, 0x000e620000205400ULL,
0x0000000175756812ULL, 0x008fc800078efcffULL, 0x00000075c0c0723eULL, 0x000fc600000010ffULL,
0x00000086008a7306ULL, 0x000ff00000209400ULL, 0x0000008600897306ULL, 0x0004e20000205400ULL,
0x000000cabb00720bULL, 0x002fce0003fbd000ULL, 0x000000b300b97306ULL, 0x000fe20000209400ULL,
0x0000008600867245ULL, 0x004fca000020d400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x000000b300ae7306ULL, 0x0002a20000205400ULL, 0x000000898a00720bULL, 0x008fe40003fdd000ULL,
0x00000087ce89723eULL, 0x000fe400000010ffULL, 0x0000007a937a723eULL, 0x000fc600000010ffULL,
0x0000005d00777306ULL, 0x000722000000d400ULL, 0x000000b300b37245ULL, 0x002fe2000020d400ULL,
0x00000088304c723cULL, 0x000fe8000004184cULL, 0x0000000186866812ULL, 0x000fe400078efcffULL,
0x0000005f00917306ULL, 0x000fe20000009400ULL, 0x000100005f5d7824ULL, 0x008fe200078e00ffULL,
0x000000aeb900720bULL, 0x004fc80003f5d000ULL, 0x00000018ff9e7819ULL, 0x000fe4000001145dULL,
0x0000005f00967306ULL, 0x000e620000005400ULL, 0x0000000177771812ULL, 0x010fe400078efcffULL,
0x0000008dc85d723eULL, 0x000fe400000010ffULL, 0x0000009e00877245ULL, 0x000fe4000020d400ULL,
0x00000001b3b32812ULL, 0x000fe200078efcffULL, 0x0000008e00a67306ULL, 0x000fe20000209400ULL,
0x00000077907b723eULL, 0x000fe200000010ffULL, 0x0000005c3054723cULL, 0x000fe20000041854ULL,
0x000000b38686723eULL, 0x000fca00000010ffULL, 0x0000008e00a77306ULL, 0x0004e20000205400ULL,
0x000000969100720bULL, 0x002fe40003f7d000ULL, 0x000000cb005c7245ULL, 0x000fe4000020d400ULL,
0x0000007600317245ULL, 0x000fe4000020d400ULL, 0x0000006f00307245ULL, 0x000fe2000020d400ULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x004fce000020d400ULL,
0x000000a300a57306ULL, 0x0002a20000205400ULL, 0x000000a7a600720bULL, 0x008fe20003f3d000ULL,
0x0000007a3854723cULL, 0x000fec0000041854ULL, 0x0000008000837306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x000000018e8e1812ULL, 0x000fe400078efcffULL,
0x0000008000827306ULL, 0x0002e20000205400ULL, 0x000000a5a400720bULL, 0x004fe40003fbd000ULL,
0x000000e98ed9723eULL, 0x000fca00000010ffULL, 0x000000c500977306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x00000001a3a35812ULL, 0x000fe400078efcffULL,
0x000000c5009a7306ULL, 0x0002a20000205400ULL, 0x000000828300720bULL, 0x008fe40003f5d000ULL,
0x000000959400720bULL, 0x000fe40003fbd000ULL, 0x00000018ff827819ULL, 0x000fe4000001145eULL,
0x000000d8a3d8723eULL, 0x000fe200000010ffULL, 0x0000005f00747306ULL, 0x000722000000d400ULL,
0x000000c500c57245ULL, 0x002fca000020d400ULL, 0x0000000180802812ULL, 0x000fe200078efcffULL,
0x000000d83850723cULL, 0x000fe20000041850ULL, 0x0000009e00a17306ULL, 0x000fe20000209400ULL,
0x0000009a9700720bULL, 0x004fe20003fdd000ULL, 0x00000100625f7824ULL, 0x008fe200078e00ffULL,
0x000000016e6e5812ULL, 0x000fc800078efcffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000009e00927306ULL, 0x000e620000205400ULL, 0x0000000174743812ULL, 0x010fc800078efcffULL,
0x00000074c1c1723eULL, 0x000fe400000010ffULL, 0x00000001c5c56812ULL, 0x000fe200078efcffULL,
0x0000006100987306ULL, 0x000fe60000009400ULL, 0x0000006ec56e723eULL, 0x000fe200000010ffULL,
0x000000c0384c723cULL, 0x000fe8000004184cULL, 0x0000006100997306ULL, 0x000ea20000005400ULL,
0x00000092a100720bULL, 0x002fce0003f7d000ULL, 0x00000062008c7306ULL, 0x000fec0000009400ULL,
0x0000000187873812ULL, 0x000fe400078efcffULL, 0x00000062008b7306ULL, 0x000e620000005400ULL,
0x000000999800720bULL, 0x004fe40003f9d000ULL, 0x000000878087723eULL, 0x000fca00000010ffULL,
0x00000076007c7306ULL, 0x000fe40000209400ULL, 0x000000863848723cULL, 0x000fec0000041848ULL,
0x00000076007d7306ULL, 0x000ea20000205400ULL, 0x0000008b8c00720bULL, 0x002fce0003f3d000ULL,
0x000000cb00917306ULL, 0x000ff00000209400ULL, 0x000000cb00967306ULL, 0x000e620000205400ULL,
0x0000007d7c00720bULL, 0x004fce0003f5d000ULL, 0x00000061006d7306ULL, 0x0004ec000000d400ULL,
0x0000000131312812ULL, 0x000fe400078efcffULL, 0x00000063007f7306ULL, 0x000fe20000009400ULL,
0x0001000061617824ULL, 0x004fe200078e00ffULL, 0x000000969100720bULL, 0x002fc80003fdd000ULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x00000063007e7306ULL, 0x000e620000005400ULL,
0x000000016d6d4812ULL, 0x008fe400078efcffULL, 0x0000006100cd7245ULL, 0x000fc8000020d400ULL,
0x000000015c5c6812ULL, 0x000fe200078efcffULL, 0x00000061005d7306ULL, 0x000ff00000209400ULL,
0x0000006100607306ULL, 0x000ea20000205400ULL, 0x0000007e7f00720bULL, 0x002fce0003f7d000ULL,
0x0000006f00797306ULL, 0x000ff00000209400ULL, 0x0000006f00787306ULL, 0x0002e20000205400ULL,
0x000000605d00720bULL, 0x004fce0003f9d000ULL, 0x000000cc008f7306ULL, 0x000fe20000209400ULL,
0x0000006d5c6f723eULL, 0x002fca00000010ffULL, 0x00000001cdcd4812ULL, 0x000fe400078efcffULL,
0x000000cc008c7306ULL, 0x0002a20000205400ULL, 0x000000787900720bULL, 0x008fe20003fbd000ULL,
0x0000006e3844723cULL, 0x000fec0000041844ULL, 0x0000005f00847306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fca000020d400ULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x0000005f00837306ULL, 0x0002e20000205400ULL, 0x0000008c8f00720bULL, 0x004fe40003fdd000ULL,
0x000000cd30cd723eULL, 0x000fca00000010ffULL, 0x00000062006c7306ULL, 0x000522000000d400ULL,
0x0000005f005f7245ULL, 0x002fca000020d400ULL, 0x00000001cccc6812ULL, 0x000fe400078efcffULL,
0x00000063006b7306ULL, 0x000362000000d400ULL, 0x0001000062627824ULL, 0x004fe200078e00ffULL,
0x000000838400720bULL, 0x008fe40003f5d000ULL, 0x000000cc31cc723eULL, 0x000fe400000010ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000082007e7306ULL, 0x000fe20000209400ULL,
0x0001000063637824ULL, 0x002fe200078e00ffULL, 0x000000016c6c1812ULL, 0x010fe200078efcffULL,
0x000000cc3840723cULL, 0x000fe60000041840ULL, 0x00000018ff637819ULL, 0x000fc40000011463ULL,
0x00000082007d7306ULL, 0x0002a20000205400ULL, 0x000000015f5f2812ULL, 0x000fe400078efcffULL,
0x000000016b6b3812ULL, 0x020fe400078efcffULL, 0x0000006c5f6c723eULL, 0x000fc600000010ffULL,
0x0000006900727306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x002fce000020d400ULL,
0x0000006900737306ULL, 0x0002e20000205400ULL, 0x0000007d7e00720bULL, 0x004fce0003fbd000ULL,
0x0000006a00707306ULL, 0x000fe20000209400ULL, 0x0000006900697245ULL, 0x002fca000020d400ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x0000006a00717306ULL, 0x0002a20000205400ULL,
0x000000737200720bULL, 0x008fe40003fdd000ULL, 0x0000006b826d723eULL, 0x000fca00000010ffULL,
0x00000062005e7306ULL, 0x000fe20000209400ULL, 0x0000006a006a7245ULL, 0x002fe2000020d400ULL,
0x0000006c3834723cULL, 0x000fe80000041834ULL, 0x0000000169696812ULL, 0x000fe400078efcffULL,
0x0000006200337306ULL, 0x0002e20000205400ULL, 0x000000717000720bULL, 0x004fce0003f9d000ULL,
0x0000006300327306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fca000020d400ULL,
0x000000016a6a4812ULL, 0x000fe400078efcffULL, 0x00000063005d7306ULL, 0x0002a20000205400ULL,
0x000000335e00720bULL, 0x008fe40003f5d000ULL, 0x0000006300637245ULL, 0x002fd6000020d400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x0000005d3200720bULL, 0x004fe40003f3d000ULL,
0x000000626962723eULL, 0x000fd600000010ffULL, 0x0000000163631812ULL, 0x000fc800078efcffULL,
0x000000636a63723eULL, 0x000fce00000010ffULL, 0x000000623838723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c05b307811ULL, 0x000fe200078e40ffULL, 0x01063000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff23ff7812ULL, 0x000fe4000784c0ffULL, 0x000000305900720cULL, 0x000fe40003f24070ULL,
0x00000001ff697807ULL, 0x000fd60001000000ULL, 0x00004b7000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff2f7984ULL, 0x000e640000000800ULL, 0x800000002fff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff2f7984ULL, 0x000e640000000800ULL, 0x800000002fff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2f7424ULL, 0x000fc800078e00ffULL, 0x0000002f00307305ULL, 0x0002a4000021f000ULL,
0x3fa000002f2f7823ULL, 0x002fe200000100ffULL, 0x000000300000735dULL, 0x004fe40003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000167687824ULL, 0x000fe400078e0268ULL, 0x00000004ff327424ULL, 0x000fe400078e00ffULL,
0x00000300ff2f7624ULL, 0x000fe200078e00ffULL, 0x0000000368307812ULL, 0x000fe200078ec0ffULL,
0x000000042d3c7e24ULL, 0x000fe4000f8e022aULL, 0xfffffffd322f7424ULL, 0x000fe200078e022fULL,
0x000000033000780cULL, 0x000fe20003f25270ULL, 0xffffffffff2d7424ULL, 0x000fc600078e00ffULL,
0x000000012f2f7807ULL, 0x000fca0004800000ULL, 0x00000001682f7824ULL, 0x000fe200078e022fULL,
0x000000e05b307811ULL, 0x000fc800078e40ffULL, 0x000000582f00720cULL, 0x000fe40003f26070ULL,
0x0000003059317217ULL, 0x000fe40007800000ULL, 0x000000203c3c7810ULL, 0x000fc60007ffe0ffULL,
0x0000000131317824ULL, 0x000fe400078e0a30ULL, 0x00000100ff3f7424ULL, 0x000fc800078e00ffULL,
0x000000012f339824ULL, 0x000fe200078e0226ULL, 0x00000020313d7807ULL, 0x000fe20000000000ULL,
0x000000011e307824ULL, 0x000fe400078e023cULL, 0x0000600033329625ULL, 0x000fe200078e0032ULL,
0x0000003d2c3d7217ULL, 0x000fc60007800000ULL, 0x00000001191e7824ULL, 0x000fe200078e023cULL,
0x00000006322d9981ULL, 0x000362000c1e1900ULL, 0x00005e0030307625ULL, 0x000fe200078e003fULL,
0x00000004ff197819ULL, 0x000fc6000001162bULL, 0x00000001183e7824ULL, 0x100fe200078e023cULL,
0x0000002130307210ULL, 0x000fe20007f1e0ffULL, 0x00000001175c7824ULL, 0x000fe400078e023cULL,
0x00005e001e327625ULL, 0x002fc800078e003fULL, 0x000000013d1e7824ULL, 0x000fe200078e0a2cULL,
0x0000002132187210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff317224ULL, 0x000fe400000e0631ULL,
0x00005e003e3c7625ULL, 0x080fe200078e003fULL, 0x0000001e1900720cULL, 0x080fe40003f06070ULL,
0x0000001e2000720cULL, 0x080fe20003f26070ULL, 0x00005e005c3e7625ULL, 0x000fe200078e003fULL,
0x0000001e1d00720cULL, 0x080fe40003f66070ULL, 0x000000213c327210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0633ULL, 0x0000001e1f00720cULL, 0x000fc40003f46070ULL,
0x000000213e3c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff337224ULL, 0x000fe400020e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030167faeULL, 0x0003e4000c101c46ULL,
0x000000ffff3d7224ULL, 0x000fe400028e063fULL, 0x0000000018157faeULL, 0x0003e8000c901c46ULL,
0x0000000032147faeULL, 0x0003e8000d101c46ULL, 0x000000003c137faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff137984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01063c00ff147984ULL, 0x000ea20000000800ULL,
0x8000000066167824ULL, 0x000fc400078e00ffULL, 0x8000000012157824ULL, 0x000fc600078e00ffULL,
0x8000000013ff7812ULL, 0x002fe40007804816ULL, 0x8000000014ff7812ULL, 0x004fe20007824815ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000012147824ULL, 0x000fe400078e00ffULL, 0x3e000000ff127424ULL, 0x000fc800078e00ffULL,
0x0000001200137305ULL, 0x0002a4000021f000ULL, 0x3fa0000012127823ULL, 0x002fe200000100ffULL,
0x000000130000735dULL, 0x004fe40003800000ULL, 0x01063c00ff137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fc40007824814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0101800011127984ULL, 0x000e620000000800ULL,
0x00000001ff797424ULL, 0x000fc600078e00ffULL, 0x0103800011137984ULL, 0x0004e20000000800ULL,
0x000000291200720bULL, 0x002fda0003f3d000ULL, 0x0000000000147806ULL, 0x000fc800008e0100ULL,
0x0000ffff14167812ULL, 0x000fda000782c0ffULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x000000291200720bULL, 0x00cfe40003f34000ULL, 0x0000001229187209ULL, 0x000fe40007810000ULL,
0x00000002ff1e7819ULL, 0x000fc6000001162bULL, 0x8000001829147221ULL, 0x100fe20000010000ULL,
0x000000ffff297224ULL, 0x000fc600078e0018ULL, 0x3fb8aa3b14157820ULL, 0x000fe40000410000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x000000035a00780cULL, 0x000fe40003f25270ULL,
0x0000ffff14177812ULL, 0x000fe200078e3cffULL, 0x0000001500157308ULL, 0x000e660000000800ULL,
0x0000001716ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff797807ULL, 0x000fc60001000000ULL,
0x0105801811009388ULL, 0x000fec0000000800ULL, 0x8000001812162221ULL, 0x000fe20000010000ULL,
0x00001f1e15147589ULL, 0x002e6200000e0000ULL, 0x0000001528287220ULL, 0x000fe40000410000ULL,
0x3fb8aa3b16162820ULL, 0x000fe20000410000ULL, 0x00001f0a15127589ULL, 0x000ea600000e0000ULL,
0x0000001600102308ULL, 0x000ee40000000800ULL, 0x0000001310132220ULL, 0x008fe20000410000ULL,
0x0000001454547220ULL, 0x082fe20000410000ULL, 0x0000001455557220ULL, 0x080fe20000410000ULL,
0x0000001450507220ULL, 0x080fe20000410000ULL, 0x0000001451517220ULL, 0x080fe20000410000ULL,
0x000000144c4c7220ULL, 0x080fe20000410000ULL, 0x000000144d4d7220ULL, 0x080fe20000410000ULL,
0x0000001448487220ULL, 0x080fe20000410000ULL, 0x0000001449497220ULL, 0x080fe20000410000ULL,
0x0000001444447220ULL, 0x080fe20000410000ULL, 0x0000001445457220ULL, 0x080fe20000410000ULL,
0x0000001440407220ULL, 0x080fe20000410000ULL, 0x0000001441417220ULL, 0x080fe20000410000ULL,
0x0000001434347220ULL, 0x080fe20000410000ULL, 0x0000001435357220ULL, 0x080fe20000410000ULL,
0x0000001438387220ULL, 0x080fe20000410000ULL, 0x0000001439397220ULL, 0x000fe20000410000ULL,
0x0000001256567220ULL, 0x084fe20000410000ULL, 0x0000001257577220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001253537220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x000000124f4f7220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124b4b7220ULL, 0x080fe20000410000ULL,
0x0000001246467220ULL, 0x080fe20000410000ULL, 0x0000001247477220ULL, 0x080fe20000410000ULL,
0x0000001242427220ULL, 0x080fe20000410000ULL, 0x0000001243437220ULL, 0x080fe20000410000ULL,
0x0000001236367220ULL, 0x080fe20000410000ULL, 0x0000001237377220ULL, 0x080fe20000410000ULL,
0x000000123a3a7220ULL, 0x080fe20000410000ULL, 0x000000123b3b7220ULL, 0x000fe20000410000ULL,
0x0000002813287221ULL, 0x00cfe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x01064c00ff117984ULL, 0x000e620000000800ULL, 0x8000000066127824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x002fe20007804812ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff117424ULL, 0x000fe400078e00ffULL,
0x8000000066137824ULL, 0x000fe400078e00ffULL, 0x0000001100127305ULL, 0x0002a4000021f000ULL,
0x3fa0000011117823ULL, 0x002fe200000100ffULL, 0x000000120000735dULL, 0x004fe40003800000ULL,
0x01064c00ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fc40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000000f14783bULL, 0x000e620000004200ULL, 0x0000b8000b0b7811ULL, 0x000fe400078e20ffULL,
0x0000991079797816ULL, 0x000fe200000000ffULL, 0x000000000e30783bULL, 0x000ea20000004200ULL,
0x0000b80009097811ULL, 0x000fc600078e20ffULL, 0x000000000d3c783bULL, 0x000ee80000004200ULL,
0x000000000c5c783bULL, 0x000f220000004200ULL, 0x0000010014dd7824ULL, 0x042fe200078e00ffULL,
0x0000001400d07306ULL, 0x000fe20000009400ULL, 0x0000010015ca7824ULL, 0x040fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe20000011414ULL, 0x0001000014d87824ULL, 0x000fe200078e00ffULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x0000010016bf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0001000015c57824ULL, 0x000fe200078e00ffULL,
0x000000dd00d27306ULL, 0x000fe20000209400ULL, 0x00000018ff947819ULL, 0x000fe20000011415ULL,
0x0001000030b17824ULL, 0x004fe200078e00ffULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x0001000032c27824ULL, 0x040fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe20000011417ULL,
0x0001000033c37824ULL, 0x040fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe20000011431ULL,
0x000000dd00e57306ULL, 0x000e620000205400ULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x0000010032b97824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe20000011416ULL,
0x0000010033b67824ULL, 0x000fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x0001000017ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x000000ca00e07306ULL, 0x000fe20000209400ULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x000001003de77824ULL, 0x048fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011432ULL,
0x000100003de47824ULL, 0x000fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fe20000011433ULL,
0x000100003ce67824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x000000ca00e37306ULL, 0x0004e20000205400ULL, 0x000000e5d200720bULL, 0x002fe20003f1d000ULL,
0x0001000031b87824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011430ULL,
0x000001003ec77824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001143dULL,
0x000100003fce7824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe2000001143cULL,
0x0000001400cf7306ULL, 0x000e620000005400ULL, 0x000000ca00ca7245ULL, 0x004fc4000020d400ULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x00000018ffb87819ULL, 0x000fe400000114b8ULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000001500da7306ULL, 0x000fe20000009400ULL,
0x000000e3e000720bULL, 0x008fe40003f9d000ULL, 0x00000018ffc77819ULL, 0x000fe400000114c7ULL,
0x00000018ffb67819ULL, 0x000fc400000114b6ULL, 0x00000018ff787819ULL, 0x000fe2000001143eULL,
0x0000001500d37306ULL, 0x000ea20000005400ULL, 0x000000cfd000720bULL, 0x002fe20003fbd000ULL,
0x000001005dcf7824ULL, 0x010fe200078e00ffULL, 0x00000018ffe47819ULL, 0x000fe400000114e4ULL,
0x00000018ff747819ULL, 0x000fe4000001143fULL, 0x00000001caca4812ULL, 0x000fe200078efcffULL,
0x0000001700d47306ULL, 0x000fe20000009400ULL, 0x00000018ffce7819ULL, 0x000fc400000114ceULL,
0x00000018ff6a7819ULL, 0x000fe4000001145cULL, 0x00000018ff1e7819ULL, 0x000fe4000001145dULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x0000001700d57306ULL, 0x000e620000005400ULL,
0x000000d3da00720bULL, 0x004fe40003f3d000ULL, 0x000000dd00d37245ULL, 0x000fe4000020d400ULL,
0x00000018ff117819ULL, 0x000fc4000001145eULL, 0x00000001d3d30812ULL, 0x000fe200078efcffULL,
0x0000003000ab7306ULL, 0x000fe20000009400ULL, 0x00000018ff127819ULL, 0x000fce000001145fULL,
0x0000003000ac7306ULL, 0x000ea20000005400ULL, 0x000000d5d400720bULL, 0x002fe40003f1d000ULL,
0x000000d800d47245ULL, 0x000fe4000020d400ULL, 0x000000c500d57245ULL, 0x000fc6000020d400ULL,
0x00000014007c7306ULL, 0x0002f0000000d400ULL, 0x000000cb00d77306ULL, 0x000fe20000209400ULL,
0x0000010017147824ULL, 0x002fe200078e00ffULL, 0x000000acab00720bULL, 0x004fc40003f9d000ULL,
0x00000018ffab7819ULL, 0x000fe400000114e6ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x000000cb00d67306ULL, 0x0002a20000205400ULL, 0x000000017c7c5812ULL, 0x008fc800078efcffULL,
0x0000007cd37c723eULL, 0x000fc600000010ffULL, 0x0000009400cc7306ULL, 0x000fe20000209400ULL,
0x000000cb00cb7245ULL, 0x002fce000020d400ULL, 0x0000009400cd7306ULL, 0x0002e20000205400ULL,
0x000000d6d700720bULL, 0x004fe40003f5d000ULL, 0x00000018ffd67819ULL, 0x000fca00000114e7ULL,
0x000000d800e27306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fca000020d400ULL,
0x00000001cbcb2812ULL, 0x000fe400078efcffULL, 0x000000d800e17306ULL, 0x000e620000205400ULL,
0x000000cdcc00720bULL, 0x008fce0003fbd000ULL, 0x0000001600d97306ULL, 0x000fec0000009400ULL,
0x0000000194945812ULL, 0x000fe400078efcffULL, 0x0000001600dc7306ULL, 0x000ea20000005400ULL,
0x000000e1e200720bULL, 0x002fce0003f7d000ULL, 0x00000017000d7306ULL, 0x0002ec000000d400ULL,
0x00000001d4d43812ULL, 0x000fe400078efcffULL, 0x0000003000757306ULL, 0x000922000000d400ULL,
0x000000dcd900720bULL, 0x004fe20003fdd000ULL, 0x0000010030177824ULL, 0x002fe200078e00ffULL,
0x000000d4cbd4723eULL, 0x000fc800000010ffULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000008f008a7306ULL, 0x000fe20000209400ULL, 0x000000010d0d0812ULL, 0x008fe200078efcffULL,
0x000001003c307824ULL, 0x010fca00078e00ffULL, 0x00000018ffd07819ULL, 0x000fe20000011430ULL,
0x0000008f00977306ULL, 0x0002a20000205400ULL, 0x0000000175754812ULL, 0x000fe200078efcffULL,
0x000001005f307824ULL, 0x000fcc00078e00ffULL, 0x000000a200a37306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x002fce000020d400ULL, 0x000000a200a67306ULL, 0x000e620000205400ULL,
0x000000978a00720bULL, 0x004fce0003f1d000ULL, 0x000000bf00c97306ULL, 0x000fec0000209400ULL,
0x000000018f8f0812ULL, 0x000fe400078efcffULL, 0x000000bf00c67306ULL, 0x0004e20000205400ULL,
0x000000a6a300720bULL, 0x002fce0003f9d000ULL, 0x000000a700a97306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x004fce000020d400ULL, 0x000000a700aa7306ULL, 0x0002a20000205400ULL,
0x000000c6c900720bULL, 0x008fce0003f5d000ULL, 0x000000c500db7306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001bfbf2812ULL, 0x000fe400078efcffULL,
0x000000c500de7306ULL, 0x000e620000205400ULL, 0x000000aaa900720bULL, 0x004fce0003fbd000ULL,
0x00000016000e7306ULL, 0x000eac000000d400ULL, 0x00000001a7a75812ULL, 0x000fe400078efcffULL,
0x00000015007d7306ULL, 0x000722000000d400ULL, 0x000000dedb00720bULL, 0x002fce0003f7d000ULL,
0x00000032008e7306ULL, 0x000fe20000009400ULL, 0x0001000016157824ULL, 0x008fe200078e00ffULL,
0x000000010e0e6812ULL, 0x004fe200078efcffULL, 0x0000010031167824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000032009d7306ULL, 0x000e620000005400ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x000000017d7d1812ULL, 0x010fe400078efcffULL,
0x00000001d5d53812ULL, 0x000fe400078efcffULL, 0x00000016008a7245ULL, 0x000fe2000020d400ULL,
0x0000001400c87306ULL, 0x000fe20000209400ULL, 0x0000007dca7d723eULL, 0x000fc400000010ffULL,
0x000000d594d5723eULL, 0x000fca00000010ffULL, 0x0000001400df7306ULL, 0x000ea20000205400ULL,
0x0000009d8e00720bULL, 0x002fe40003fdd000ULL, 0x00000015008e7245ULL, 0x000fca000020d400ULL,
0x0000003200707306ULL, 0x000e70000000d400ULL, 0x0000003300a87306ULL, 0x000fe20000009400ULL,
0x000000dfc800720bULL, 0x004fce0003f3d000ULL, 0x00000033008d7306ULL, 0x000fe20000005400ULL,
0x0000000170706812ULL, 0x002fce00078efcffULL, 0x00000033006f7306ULL, 0x000ff0000000d400ULL,
0x000000b100b27306ULL, 0x000ff00000209400ULL, 0x000000b100b57306ULL, 0x0002b00000205400ULL,
0x000000c200327306ULL, 0x000fe20000209400ULL, 0x000000b100b17245ULL, 0x002fce000020d400ULL,
0x000000c200337306ULL, 0x0003e20000205400ULL, 0x000000b5b200720bULL, 0x004fce0003f1d000ULL,
0x0000001500bd7306ULL, 0x000fe20000209400ULL, 0x000000c200c27245ULL, 0x002fca000020d400ULL,
0x00000001b1b10812ULL, 0x000fe400078efcffULL, 0x0000001500c47306ULL, 0x000e700000205400ULL,
0x0000001600ad7306ULL, 0x000ff00000209400ULL, 0x0000001600b47306ULL, 0x000ea20000205400ULL,
0x000000c4bd00720bULL, 0x002fce0003f5d000ULL, 0x0000003100887306ULL, 0x000fec0000009400ULL,
0x000000018e8e2812ULL, 0x000fe400078efcffULL, 0x00000031009b7306ULL, 0x000e620000005400ULL,
0x000000b4ad00720bULL, 0x004fe40003fbd000ULL, 0x0000008ea78e723eULL, 0x000fca00000010ffULL,
0x0000003d00a07306ULL, 0x000fec0000009400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x0000003d00897306ULL, 0x000fe20000005400ULL, 0x0000009b8800720bULL, 0x002fe40003f7d000ULL,
0x0000001400887245ULL, 0x000fc8000020d400ULL, 0x0000000188881812ULL, 0x000fe200078efcffULL,
0x0000003d006b7306ULL, 0x0003f0000000d400ULL, 0x0000003c00a47306ULL, 0x000fe20000009400ULL,
0x000001003f3d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff977819ULL, 0x000fe4000001143dULL,
0x0000003c008b7306ULL, 0x000e620000005400ULL, 0x000000a2003d7245ULL, 0x000fc8000020d400ULL,
0x000000013d3d4812ULL, 0x000fe400078efcffULL, 0x000000333200720bULL, 0x000fe20003f9d000ULL,
0x0000003c006c7306ULL, 0x000eb0000000d400ULL, 0x000000c3003c7306ULL, 0x000fe20000209400ULL,
0x0000008ba400720bULL, 0x002fc40003f1d000ULL, 0x000000d0008b7245ULL, 0x000fe4000020d400ULL,
0x00000001c2c24812ULL, 0x000fc600078efcffULL, 0x000000c300d17306ULL, 0x0002ec0000205400ULL,
0x000000016c6c0812ULL, 0x004fe400078efcffULL, 0x000000ae00c07306ULL, 0x000fe20000209400ULL,
0x000000c300c37245ULL, 0x002fce000020d400ULL, 0x000000ae00b37306ULL, 0x0002a20000205400ULL,
0x000000d13c00720bULL, 0x008fce0003fdd000ULL, 0x000000d000d27306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x00000001c3c36812ULL, 0x000fe400078efcffULL,
0x000000d000d97306ULL, 0x000e620000205400ULL, 0x000000b3c000720bULL, 0x004fce0003f3d000ULL,
0x0000001700af7306ULL, 0x000fec0000209400ULL, 0x00000001aeae1812ULL, 0x000fe400078efcffULL,
0x0000001700b07306ULL, 0x0004e20000205400ULL, 0x000000d9d200720bULL, 0x002fe40003f9d000ULL,
0x0000008da800720bULL, 0x000fc40003f3d000ULL, 0x0000001700a87245ULL, 0x000fe4000020d400ULL,
0x000000ae8f8f723eULL, 0x000fe200000010ffULL, 0x000000b800bb7306ULL, 0x000fe20000209400ULL,
0x000000000b14783bULL, 0x0043ea0000000200ULL, 0x000000018b8b4812ULL, 0x000fe400078efcffULL,
0x000000b800be7306ULL, 0x0005220000205400ULL, 0x000000b0af00720bULL, 0x008fc40003f5d000ULL,
0x000000016f6f1812ULL, 0x000fe400078efcffULL, 0x000000e4000b7245ULL, 0x002fe4000020d400ULL,
0x0000006c8b6c723eULL, 0x000fe200000010ffULL, 0x000000d600d77306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x004fca000020d400ULL, 0x00000001a8a82812ULL, 0x000fe400078efcffULL,
0x000000d600c67306ULL, 0x0002a20000205400ULL, 0x000000bebb00720bULL, 0x010fe40003fbd000ULL,
0x00000075a8a8723eULL, 0x000fca00000010ffULL, 0x0000003100737306ULL, 0x000722000000d400ULL,
0x000000d600d67245ULL, 0x002fca000020d400ULL, 0x00000001b8b85812ULL, 0x000fe400078efcffULL,
0x000000b900bc7306ULL, 0x000fe20000209400ULL, 0x000000c6d700720bULL, 0x004fe20003fdd000ULL,
0x000001005e317824ULL, 0x008fe200078e00ffULL, 0x00000089a000720bULL, 0x000fe40003fbd000ULL,
0x0000009a00897245ULL, 0x000fe4000020d400ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x000000b900b77306ULL, 0x0002a20000205400ULL, 0x0000000173733812ULL, 0x010fc400078efcffULL,
0x000000b83d3d723eULL, 0x000fe400000010ffULL, 0x000000738aa9723eULL, 0x000fe400000010ffULL,
0x00000001d6d66812ULL, 0x000fe200078efcffULL, 0x0000008000847306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fe4000020d400ULL, 0x000000016b6b5812ULL, 0x000fca00078efcffULL,
0x0000008000837306ULL, 0x0002e20000205400ULL, 0x000000b7bc00720bULL, 0x004fce0003f7d000ULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x00000001b9b93812ULL, 0x000fe400078efcffULL, 0x000000ab009b7306ULL, 0x0002a20000205400ULL,
0x000000838400720bULL, 0x008fe40003f1d000ULL, 0x00000070b970723eULL, 0x000fca00000010ffULL,
0x0000009300a57306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x0000000180800812ULL, 0x000fe400078efcffULL, 0x00000093008c7306ULL, 0x000e620000205400ULL,
0x0000009bac00720bULL, 0x004fce0003f9d000ULL, 0x0000007f00857306ULL, 0x000fec0000209400ULL,
0x00000001abab4812ULL, 0x000fe400078efcffULL, 0x0000007f00867306ULL, 0x000ea20000205400ULL,
0x0000008ca500720bULL, 0x002fe40003f5d000ULL, 0x00000093008c7245ULL, 0x000fc4000020d400ULL,
0x000000ab8080723eULL, 0x000fc600000010ffULL, 0x0000009a009e7306ULL, 0x000fec0000209400ULL,
0x000000018c8c2812ULL, 0x000fe400078efcffULL, 0x0000009a00a17306ULL, 0x000e620000205400ULL,
0x000000868500720bULL, 0x004fce0003fdd000ULL, 0x0000005d007e7306ULL, 0x000ff00000009400ULL,
0x0000005d00817306ULL, 0x000ea20000005400ULL, 0x000000a19e00720bULL, 0x002fce0003f7d000ULL,
0x000000c7008d7306ULL, 0x000fec0000209400ULL, 0x0000000189893812ULL, 0x000fe400078efcffULL,
0x000000c700a67306ULL, 0x000e620000205400ULL, 0x000000817e00720bULL, 0x004fe40003f1d000ULL,
0x0000007f007e7245ULL, 0x000fc4000020d400ULL, 0x000000c289c2723eULL, 0x000fe400000010ffULL,
0x000000017e7e6812ULL, 0x000fe200078efcffULL, 0x000000b600ba7306ULL, 0x000ff00000209400ULL,
0x000000b600c17306ULL, 0x0004e20000205400ULL, 0x000000a68d00720bULL, 0x002fce0003f9d000ULL,
0x0000009700a37306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x004fce000020d400ULL,
0x0000009700a07306ULL, 0x000e620000205400ULL, 0x000000c1ba00720bULL, 0x008fce0003f5d000ULL,
0x0000003e009c7306ULL, 0x000fec0000009400ULL, 0x00000001b6b62812ULL, 0x000fe400078efcffULL,
0x0000003e00957306ULL, 0x000ea20000005400ULL, 0x000000a0a300720bULL, 0x002fce0003fdd000ULL,
0x0000003e00677306ULL, 0x0002f0000000d400ULL, 0x0000003f00987306ULL, 0x000fe20000009400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000959c00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff337819ULL, 0x000fe4000001143eULL, 0x0000003f00917306ULL, 0x000e620000005400ULL,
0x00000010ff3e723eULL, 0x000fc800000010ffULL, 0x000054103e847816ULL, 0x000fe4000000003eULL,
0x0000000167672812ULL, 0x008fe200078efcffULL, 0x0000003f00697306ULL, 0x0004e4000000d400ULL,
0x00001f0a843e7589ULL, 0x000fec00000e0000ULL, 0x000000e4009d7306ULL, 0x000fe20000209400ULL,
0x000001005c3f7824ULL, 0x004fe200078e00ffULL, 0x000000919800720bULL, 0x002fc80003f7d000ULL,
0x00000018ff837819ULL, 0x000fe4000001143fULL, 0x000000e400aa7306ULL, 0x000e620000205400ULL,
0x00000002ff3f7819ULL, 0x000fcc000001162bULL, 0x00001f3f843f7589ULL, 0x00052200000e0000ULL,
0x0000005e00877306ULL, 0x000fe20000009400ULL, 0x0000000169693812ULL, 0x008fce00078efcffULL,
0x0000005e00827306ULL, 0x000ee20000005400ULL, 0x000000c700847245ULL, 0x004fe4000020d400ULL,
0x000000aa9d00720bULL, 0x002fe40003fbd000ULL, 0x0000000184844812ULL, 0x000fc600078efcffULL,
0x00000096009f7306ULL, 0x000fe20000209400ULL, 0x000000678484723eULL, 0x000fce00000010ffULL,
0x0000009600927306ULL, 0x0002a20000205400ULL, 0x000000828700720bULL, 0x008fe40003f9d000ULL,
0x0000009700827245ULL, 0x000fe4000020d400ULL, 0x000000010b0b5812ULL, 0x000fe400078efcffULL,
0x0000000182826812ULL, 0x000fe200078efcffULL, 0x0000003300327306ULL, 0x000fe20000209400ULL,
0x000000ff7900720cULL, 0x000fe40003fa5270ULL, 0x0000009600967245ULL, 0x002fc4000020d400ULL,
0x0000000b7e81723eULL, 0x000fc600000010ffULL, 0x0000003300937306ULL, 0x000e620000205400ULL,
0x000000929f00720bULL, 0x004fca0003f3d000ULL, 0x0000003f1414d231ULL, 0x090fe400003400ffULL,
0x00000078000f7306ULL, 0x000fe20000209400ULL, 0x0000003f1616d231ULL, 0x000fe400003400ffULL,
0x0000003e1515d231ULL, 0x080fe400003400ffULL, 0x0000003e1717d231ULL, 0x000fe200003400ffULL,
0x0000000196961812ULL, 0x000fe400078efcffULL, 0x00000078000c7306ULL, 0x000ea20000205400ULL,
0x000000933200720bULL, 0x002fc40003fdd000ULL, 0x0000000ebf32723eULL, 0x000fe200000010ffULL,
0x0000007c1454723cULL, 0x000fe20000041854ULL, 0x000000c396c3723eULL, 0x000fc600000010ffULL,
0x0000005f007a7306ULL, 0x000fe80000009400ULL, 0x000000d41450723cULL, 0x000fe80000041850ULL,
0x0000005f007b7306ULL, 0x000e620000005400ULL, 0x0000000c0f00720bULL, 0x004fc60003f7d000ULL,
0x0000008e1448723cULL, 0x040fe80000041848ULL, 0x0000005c00907306ULL, 0x000fe80000009400ULL,
0x000000a81444723cULL, 0x000fe80000041844ULL, 0x0000005c00997306ULL, 0x000ea20000005400ULL,
0x0000007b7a00720bULL, 0x002fce0003f5d000ULL, 0x000000ce003c7306ULL, 0x000ff00000209400ULL,
0x000000ce00917306ULL, 0x0002e20000205400ULL, 0x000000999000720bULL, 0x004fce0003f3d000ULL,
0x0000007400767306ULL, 0x000fe20000209400ULL, 0x000000ce00ce7245ULL, 0x002fce000020d400ULL,
0x0000007400777306ULL, 0x000e700000205400ULL, 0x0000005c00627306ULL, 0x000530000000d400ULL,
0x0000005d00197306ULL, 0x0003e2000000d400ULL, 0x000100005c5c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe4000001145cULL, 0x00000033005c7245ULL, 0x000fe2000020d400ULL,
0x000100005d5d7824ULL, 0x002fe200078e00ffULL, 0x0000008300857306ULL, 0x000fe20000209400ULL,
0x0000000d8833723eULL, 0x000fe400000010ffULL, 0x000000015c5c6812ULL, 0x000fe200078efcffULL,
0x00000000090c783bULL, 0x0002a20000000200ULL, 0x00000018ff7b7819ULL, 0x000fe4000001145dULL,
0x00000078005d7245ULL, 0x000fe2000020d400ULL, 0x0000008300867306ULL, 0x0009220000205400ULL,
0x000000913c00720bULL, 0x008fe20003fdd000ULL, 0x00000032144c723cULL, 0x000fe2000004184cULL,
0x000000015d5d3812ULL, 0x000fc400078efcffULL, 0x000000777600720bULL, 0x000fe40003f7d000ULL,
0x0000007400097245ULL, 0x002fe2000020d400ULL, 0x0000006a00727306ULL, 0x000fe20000209400ULL,
0x0000000162621812ULL, 0x010fe400078efcffULL, 0x000000b18c3c723eULL, 0x000fe400000010ffULL,
0x0000008300837245ULL, 0x000fe4000020d400ULL, 0x00000001cece6812ULL, 0x000fe200078efcffULL,
0x0000006a00717306ULL, 0x0002e20000205400ULL, 0x000000868500720bULL, 0x000fe20003fdd000ULL,
0x0000003c1440723cULL, 0x000fe20000041840ULL, 0x0000000109093812ULL, 0x000fc400078efcffULL,
0x0000000119190812ULL, 0x000fe400078efcffULL, 0x0000005c5d5c723eULL, 0x000fe200000010ffULL,
0x000000cf008d7306ULL, 0x000fe20000209400ULL, 0x0000006a006a7245ULL, 0x002fe4000020d400ULL,
0x000000698285723eULL, 0x000fe400000010ffULL, 0x000000ce095d723eULL, 0x000fe400000010ffULL,
0x0000000183836812ULL, 0x000fe200078efcffULL, 0x000000cf00907306ULL, 0x000e620000205400ULL,
0x000000717200720bULL, 0x008fc40003f7d000ULL, 0x0000006fb671723eULL, 0x000fe200000010ffULL,
0x0000003f0c0cd231ULL, 0x084fe200003400ffULL, 0x00000018ff727819ULL, 0x000fe20000011430ULL,
0x0000003f0e0ed231ULL, 0x000fe200003400ffULL, 0x000000cf00307245ULL, 0x000fe2000020d400ULL,
0x0000001e006e7306ULL, 0x000fe20000209400ULL, 0x0000003e0d0dd231ULL, 0x080fe200003400ffULL,
0x000000701434723cULL, 0x000fe20000041834ULL, 0x0000003e0f0fd231ULL, 0x000fe200003400ffULL,
0x000000628362723eULL, 0x000fe400000010ffULL, 0x000000016a6a3812ULL, 0x000fc400078efcffULL,
0x0000001e006d7306ULL, 0x0004e20000205400ULL, 0x000000908d00720bULL, 0x002fe20003f3d000ULL,
0x000000c21414723cULL, 0x000fec0000041838ULL, 0x00000079007f7306ULL, 0x000fe20000209400ULL,
0x0000001e001e7245ULL, 0x004fe2000020d400ULL, 0x000000800c50723cULL, 0x000fe80000041850ULL,
0x0000000130301812ULL, 0x000fc400078efcffULL, 0x00000079007a7306ULL, 0x0002a20000205400ULL,
0x0000006d6e00720bULL, 0x008fe20003fdd000ULL, 0x000000840c4c723cULL, 0x000fe2000004184cULL,
0x0000006bd66d723eULL, 0x000fe400000010ffULL, 0x0000007b006b7245ULL, 0x000fc6000020d400ULL,
0x0000007b007c7306ULL, 0x000fe20000209400ULL, 0x0000007900797245ULL, 0x002fe2000020d400ULL,
0x0000006c0c54723cULL, 0x040fe80000041854ULL, 0x000000011e1e6812ULL, 0x000fe400078efcffULL,
0x0000007b007d7306ULL, 0x000e620000205400ULL, 0x0000007a7f00720bULL, 0x004fe20003f3d000ULL,
0x0000005c0c48723cULL, 0x000fec0000041848ULL, 0x0000003100327306ULL, 0x000fec0000209400ULL,
0x0000000179791812ULL, 0x000fc400078efcffULL, 0x0000003100337306ULL, 0x000ea20000205400ULL,
0x0000007d7c00720bULL, 0x002fe40003f1d000ULL, 0x000000796a6a723eULL, 0x000fca00000010ffULL,
0x0000005e00137306ULL, 0x0002ec000000d400ULL, 0x000000016b6b0812ULL, 0x000fe400078efcffULL,
0x0000005f00187306ULL, 0x0008e2000000d400ULL, 0x000100005e5e7824ULL, 0x002fe200078e00ffULL,
0x000000333200720bULL, 0x004fc40003f7d000ULL, 0x0000003100327245ULL, 0x000fe4000020d400ULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000001100687306ULL, 0x000fe20000209400ULL,
0x000100005f5f7824ULL, 0x010fe200078e00ffULL, 0x0000000113134812ULL, 0x008fe400078efcffULL,
0x0000007200337245ULL, 0x000fe4000020d400ULL, 0x00000018ff5f7819ULL, 0x000fc4000001145fULL,
0x0000001100637306ULL, 0x0002a20000205400ULL, 0x0000000132323812ULL, 0x000fe400078efcffULL,
0x0000000118182812ULL, 0x000fe400078efcffULL, 0x0000006b1e6b723eULL, 0x000fe400000010ffULL,
0x000000133232723eULL, 0x000fe200000010ffULL, 0x0000001200607306ULL, 0x000fe20000209400ULL,
0x0000001100117245ULL, 0x002fc6000020d400ULL, 0x0000006a0c40723cULL, 0x000fe80000041840ULL,
0x0000001200617306ULL, 0x0002e20000205400ULL, 0x000000636800720bULL, 0x004fe40003f3d000ULL,
0x000000193063723eULL, 0x000fca00000010ffULL, 0x00000072006f7306ULL, 0x000fe20000209400ULL,
0x0000001200127245ULL, 0x002fe2000020d400ULL, 0x000000620c44723cULL, 0x000fe80000041844ULL,
0x0000000111111812ULL, 0x000fe400078efcffULL, 0x00000072006e7306ULL, 0x000e620000205400ULL,
0x000000616000720bULL, 0x008fce0003f1d000ULL, 0x0000005e003c7306ULL, 0x000fec0000209400ULL,
0x0000000112120812ULL, 0x000fe400078efcffULL, 0x0000005e00397306ULL, 0x0004e20000205400ULL,
0x0000006e6f00720bULL, 0x002fce0003fdd000ULL, 0x0000005f000b7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x004fca000020d400ULL, 0x0000000133336812ULL, 0x000fe400078efcffULL,
0x0000005f00387306ULL, 0x0002a20000205400ULL, 0x000000393c00720bULL, 0x008fe40003f7d000ULL,
0x000000183333723eULL, 0x000fe400000010ffULL, 0x0000005f005f7245ULL, 0x002fca000020d400ULL,
0x000000320c34723cULL, 0x000fe80000041834ULL, 0x000000015e5e3812ULL, 0x000fe400078efcffULL,
0x000000380b00720bULL, 0x004fe40003f9d000ULL, 0x0000005e115e723eULL, 0x000fd600000010ffULL,
0x000000015f5f4812ULL, 0x000fc800078efcffULL, 0x0000005f125f723eULL, 0x000fce00000010ffULL,
0x0000005e0c14723cULL, 0x000fe20000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff097424ULL, 0x000fc800078e00ffULL,
0x00000009000b7305ULL, 0x0002a4000021f000ULL, 0x3fa0000009097823ULL, 0x002fe200000100ffULL,
0x0000000b0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000003005b097a10ULL, 0x000fe20007ffe0ffULL,
0x000000042d117e24ULL, 0x020fc4000f8e022aULL, 0x00000100ff197424ULL, 0x000fe400078e00ffULL,
0x00000100090c7824ULL, 0x040fe200078e00ffULL, 0x0000000109097810ULL, 0x000fe40007ffe0ffULL,
0x0000003f110e7812ULL, 0x000fe400078ef81cULL, 0x0000000c590b7217ULL, 0x000fe40007800000ULL,
0x0000002e0900720cULL, 0x000fe20003f06070ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0019ULL,
0x0000003f11127812ULL, 0x000fc400078ef81bULL, 0x00000004ff097819ULL, 0x000fe2000001162bULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0cULL, 0x0000003f110c7812ULL, 0x040fe200078ef822ULL,
0x00005e0012127625ULL, 0x080fe200078e0019ULL, 0x0000003f11187812ULL, 0x000fe400078ef81aULL,
0x000000200b0b7807ULL, 0x000fe20000000000ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0019ULL,
0x000000210e0e7210ULL, 0x000fe40007f5e0ffULL, 0x0000000b2c0b7217ULL, 0x000fe20007800000ULL,
0x00005e0018187625ULL, 0x000fe200078e0019ULL, 0x000000210c0c7210ULL, 0x000fc40007f1e0ffULL,
0x0000002112127210ULL, 0x080fe20007f9e0ffULL, 0x000000010b1c7824ULL, 0x000fe200078e0a2cULL,
0x0000002118187210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0d7224ULL, 0x000fe400000e060dULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000001c0900720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x0000001c2000720cULL, 0x080fe20003f06070ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000001c1f00720cULL, 0x000fc40003f46070ULL,
0x0000001c1d00720cULL, 0x000fce0003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c087faeULL, 0x0003e8000c901c46ULL, 0x000000000e077faeULL, 0x0003e8000c101c46ULL,
0x0000000012067faeULL, 0x0003e8000d101c46ULL, 0x0000000018057faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff057984ULL, 0x002e620000000800ULL,
0x8000000066067824ULL, 0x000fca00078e00ffULL, 0x8000000005ff7812ULL, 0x002fe20007804806ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01065400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804806ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000066077824ULL, 0x000fe400078e00ffULL, 0x3e000000ff057424ULL, 0x000fc800078e00ffULL,
0x0000000500067305ULL, 0x0002a4000021f000ULL, 0x3fa0000005057823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x01065400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000000404783bULL, 0x000e680000004200ULL,
0x00000000030c783bULL, 0x000ea80000004200ULL, 0x000000000218783bULL, 0x000ee80000004200ULL,
0x00000000001c783bULL, 0x000f220000004200ULL, 0x0000000400a67306ULL, 0x002fe20000009400ULL,
0x00000018ffb97819ULL, 0x000fe20000011404ULL, 0x0000010004917824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe20000011405ULL, 0x0000010007af7824ULL, 0x040fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011406ULL, 0x0001000006ae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe20000011407ULL, 0x0000000400b17306ULL, 0x000e620000005400ULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0001000007a77824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x000100000ca87824ULL, 0x004fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe2000001140cULL, 0x000001000e957824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x0000000400717306ULL, 0x000562000000d400ULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000100000da07824ULL, 0x000fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe20000011491ULL, 0x000001000f917824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001140dULL, 0x0001000018d17824ULL, 0x008fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe20000011495ULL, 0x0000000500bc7306ULL, 0x000fe20000009400ULL,
0x0001000004047824ULL, 0x004fe200078e00ffULL, 0x000000b1a600720bULL, 0x002fe20003fdd000ULL,
0x000001001bd67824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x000001001ad57824ULL, 0x040fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fe20000011404ULL,
0x0000010005047824ULL, 0x000fe200078e00ffULL, 0x0000000500bd7306ULL, 0x000e620000005400ULL,
0x00000018ff7e7819ULL, 0x000fe2000001140eULL, 0x000100001aa57824ULL, 0x000fe200078e00ffULL,
0x000000b600b17245ULL, 0x000fe2000020d400ULL, 0x0000010019d37824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe20000011404ULL, 0x0000010006047824ULL, 0x000fe200078e00ffULL,
0x0000000171716812ULL, 0x020fe200078efcffULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x000100001ba47824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe20000011404ULL, 0x000001000c047824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011419ULL, 0x0001000019d47824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe2000001140fULL, 0x000000b600b87306ULL, 0x0004e20000205400ULL,
0x000000bdbc00720bULL, 0x002fc40003f5d000ULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x00000018ffd67819ULL, 0x000fe400000114d6ULL, 0x00000018ffd57819ULL, 0x000fe200000114d5ULL,
0x0000000500737306ULL, 0x000362000000d400ULL, 0x000000b900b67245ULL, 0x004fe4000020d400ULL,
0x00000018ffa57819ULL, 0x000fe400000114a5ULL, 0x00000018ff727819ULL, 0x000fc40000011418ULL,
0x00000018ff617819ULL, 0x000fe2000001141aULL, 0x000000be00bf7306ULL, 0x000fe20000209400ULL,
0x0001000005057824ULL, 0x002fe200078e00ffULL, 0x000000b8b700720bULL, 0x008fe40003f1d000ULL,
0x00000018ffa47819ULL, 0x000fe400000114a4ULL, 0x00000018ffc17819ULL, 0x000fe40000011405ULL,
0x000000be00c07306ULL, 0x000e620000205400ULL, 0x0000000173732812ULL, 0x020fc400078efcffULL,
0x00000018ff3f7819ULL, 0x000fe4000001141bULL, 0x00000018ffd47819ULL, 0x000fe400000114d4ULL,
0x00000001b1b10812ULL, 0x000fe200078efcffULL, 0x000000b900ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff0b7819ULL, 0x010fe4000001141dULL, 0x00000018ff207819ULL, 0x000fe4000001141cULL,
0x00000018ff027819ULL, 0x000fc4000001141eULL, 0x00000018ff007819ULL, 0x000fe2000001141fULL,
0x000000b900bb7306ULL, 0x000ea20000205400ULL, 0x000000c0bf00720bULL, 0x002fce0003f3d000ULL,
0x0000009e00ac7306ULL, 0x000ff00000209400ULL, 0x0000009e00a97306ULL, 0x000e620000205400ULL,
0x000000bbba00720bULL, 0x004fce0003f7d000ULL, 0x000000c100c27306ULL, 0x000fec0000209400ULL,
0x00000001b6b63812ULL, 0x000fe400078efcffULL, 0x000000c100c37306ULL, 0x000ea20000205400ULL,
0x000000a9ac00720bULL, 0x002fe40003f1d000ULL, 0x000000be00ac7245ULL, 0x000fc4000020d400ULL,
0x00000018ffa97819ULL, 0x000fe400000114d1ULL, 0x00000001acac1812ULL, 0x000fe200078efcffULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x000000b1b6b6723eULL, 0x000fce00000010ffULL,
0x000000c600c87306ULL, 0x000e620000205400ULL, 0x000000c3c200720bULL, 0x004fce0003fdd000ULL,
0x0000000700a37306ULL, 0x000ff00000009400ULL, 0x0000000700a27306ULL, 0x000ea20000005400ULL,
0x000000c8c700720bULL, 0x002fce0003f3d000ULL, 0x0000000c00a17306ULL, 0x000ff00000009400ULL,
0x0000000c009c7306ULL, 0x000e620000005400ULL, 0x000000a2a300720bULL, 0x004fe40003f7d000ULL,
0x000000c100a27245ULL, 0x000fc4000020d400ULL, 0x0000009e00a37245ULL, 0x000fe4000020d400ULL,
0x00000001a2a26812ULL, 0x000fe200078efcffULL, 0x000000af00cb7306ULL, 0x000fe20000209400ULL,
0x00000001a3a30812ULL, 0x000fce00078efcffULL, 0x000000af00cc7306ULL, 0x0004e20000205400ULL,
0x0000009ca100720bULL, 0x002fe40003fdd000ULL, 0x000000c6009c7245ULL, 0x000fc8000020d400ULL,
0x000000019c9c1812ULL, 0x000fe200078efcffULL, 0x00000093009b7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x004fce000020d400ULL, 0x0000009300987306ULL, 0x0002a20000205400ULL,
0x000000cccb00720bULL, 0x008fce0003f5d000ULL, 0x000000ae00c97306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x00000001afaf2812ULL, 0x000fe400078efcffULL,
0x000000ae00ca7306ULL, 0x0002e20000205400ULL, 0x000000989b00720bULL, 0x004fce0003f3d000ULL,
0x0000000700687306ULL, 0x000522000000d400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x0000000193931812ULL, 0x000fe400078efcffULL, 0x0000000400cf7306ULL, 0x000fe20000209400ULL,
0x000001000d077824ULL, 0x004fe200078e00ffULL, 0x000000cac900720bULL, 0x008fc80003f1d000ULL,
0x00000018ff077819ULL, 0x000fe40000011407ULL, 0x0000000400d07306ULL, 0x000e620000205400ULL,
0x0000000168683812ULL, 0x010fcc00078efcffULL, 0x00000001aeae0812ULL, 0x000fe200078efcffULL,
0x000000a700cd7306ULL, 0x000ff00000209400ULL, 0x000000a700ce7306ULL, 0x0004e20000205400ULL,
0x000000d0cf00720bULL, 0x002fce0003f7d000ULL, 0x0000000d008f7306ULL, 0x000fe20000009400ULL,
0x000000a700a77245ULL, 0x004fce000020d400ULL, 0x0000000d00907306ULL, 0x000e620000005400ULL,
0x000000cecd00720bULL, 0x008fce0003f5d000ULL, 0x0000000700b57306ULL, 0x000fec0000209400ULL,
0x00000001a7a72812ULL, 0x000fe400078efcffULL, 0x0000000700d27306ULL, 0x000ea20000205400ULL,
0x000000908f00720bULL, 0x002fe40003f1d000ULL, 0x0000008d00907245ULL, 0x000fca000020d400ULL,
0x0000000c00627306ULL, 0x0002f0000000d400ULL, 0x0000003800887306ULL, 0x000fe20000209400ULL,
0x000000d2b500720bULL, 0x004fe20003f3d000ULL, 0x00000100180c7824ULL, 0x002fcc00078e00ffULL,
0x00000038003b7306ULL, 0x000e620000205400ULL, 0x0000000162626812ULL, 0x008fce00078efcffULL,
0x000000a800ad7306ULL, 0x000ff00000209400ULL, 0x000000a800b47306ULL, 0x0005e20000205400ULL,
0x0000003b8800720bULL, 0x002fce0003fdd000ULL, 0x0000000e00897306ULL, 0x000fe20000009400ULL,
0x000000a800a87245ULL, 0x004fce000020d400ULL, 0x0000000e008c7306ULL, 0x000e700000005400ULL,
0x0000001800877306ULL, 0x000ff00000009400ULL, 0x00000018008a7306ULL, 0x000ea20000005400ULL,
0x0000008c8900720bULL, 0x002fc40003f5d000ULL, 0x00000007008c7245ULL, 0x000fe4000020d400ULL,
0x0000008600897245ULL, 0x000fe4000020d400ULL, 0x000000018c8c1812ULL, 0x000fe200078efcffULL,
0x000000b200b07306ULL, 0x000ff00000209400ULL, 0x000000b200b37306ULL, 0x0002e20000205400ULL,
0x0000008a8700720bULL, 0x004fc40003f3d000ULL, 0x0000003800877245ULL, 0x000fe4000020d400ULL,
0x0000b80064387811ULL, 0x000fe400078e20ffULL, 0x0000000187876812ULL, 0x000fe200078efcffULL,
0x0000008d00947306ULL, 0x000fe20000209400ULL, 0x000000b200b27245ULL, 0x002fe4000020d400ULL,
0x00000010ff64723eULL, 0x000fc800000010ffULL, 0x0000541064647816ULL, 0x000fe20000000064ULL,
0x0000008d00977306ULL, 0x0003e20000205400ULL, 0x000000b3b000720bULL, 0x008fe40003f9d000ULL,
0x00000018ffb07819ULL, 0x000fe200000114d3ULL, 0x00001f0a640a7589ULL, 0x000fe800000e0000ULL,
0x0000000600c47306ULL, 0x000fe20000009400ULL, 0x00000004008d7245ULL, 0x002fc4000020d400ULL,
0x0000b80065047811ULL, 0x000fe400078e20ffULL, 0x000000018d8d3812ULL, 0x000fe400078efcffULL,
0x000000b4ad00720bULL, 0x000fe20003f7d000ULL, 0x0000000600c57306ULL, 0x000e620000005400ULL,
0x00000001b2b24812ULL, 0x000fe400078efcffULL, 0x00000002ff657819ULL, 0x000fe4000001162bULL,
0x000000628d62723eULL, 0x000fc400000010ffULL, 0x00000071b2b2723eULL, 0x000fe200000010ffULL,
0x00000006006b7306ULL, 0x000ea2000000d400ULL, 0x00001f6564657589ULL, 0x0007e600000e0000ULL,
0x00000001a8a83812ULL, 0x000fc800078efcffULL, 0x00000086003a7306ULL, 0x000fe20000209400ULL,
0x000000c5c400720bULL, 0x002fe40003f9d000ULL, 0x0000007700647245ULL, 0x008fe4000020d400ULL,
0x000000a887a8723eULL, 0x000fc600000010ffULL, 0x0000008600397306ULL, 0x000e6c0000205400ULL,
0x000000016b6b4812ULL, 0x004fe400078efcffULL, 0x0000009500067306ULL, 0x000fe20000209400ULL,
0x000000979400720bULL, 0x000fe40003f9d000ULL, 0x0000006b9c9c723eULL, 0x000fca00000010ffULL,
0x0000009500057306ULL, 0x0004e20000205400ULL, 0x000000393a00720bULL, 0x002fe40003f7d000ULL,
0x000000003838783bULL, 0x000e660000000200ULL, 0x0000000190904812ULL, 0x000fe400078efcffULL,
0x0000000d00637306ULL, 0x000962000000d400ULL, 0x0000009500957245ULL, 0x004fe4000020d400ULL,
0x000000a790a7723eULL, 0x000fc600000010ffULL, 0x0000000189893812ULL, 0x000fe400078efcffULL,
0x000000a000ab7306ULL, 0x000fe20000209400ULL, 0x000000050600720bULL, 0x008fe20003fdd000ULL,
0x000001001e0d7824ULL, 0x010fe200078e00ffULL, 0x000000000404783bULL, 0x000ea80000000200ULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x000000a000aa7306ULL, 0x0007220000205400ULL,
0x0000000163630812ULL, 0x020fc800078efcffULL, 0x000000638c63723eULL, 0x000fe400000010ffULL,
0x0000000195956812ULL, 0x000fe200078efcffULL, 0x0000000e005e7306ULL, 0x000a62000000d400ULL,
0x000000a000a07245ULL, 0x008fce000020d400ULL, 0x0000001900847306ULL, 0x000fe20000009400ULL,
0x000100000e0e7824ULL, 0x020fe200078e00ffULL, 0x000000aaab00720bULL, 0x010fe20003f1d000ULL,
0x000000653838d231ULL, 0x082fe400003400ffULL, 0x000000653a3ad231ULL, 0x000fe200003400ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0000000a3939d231ULL, 0x080fe200003400ffULL,
0x0000001900857306ULL, 0x000e620000005400ULL, 0x0000000a3b3bd231ULL, 0x000fe200003400ffULL,
0x000000015e5e2812ULL, 0x000fc800078efcffULL, 0x0000005e955e723eULL, 0x000fe400000010ffULL,
0x0000000e009a7306ULL, 0x000fe20000209400ULL, 0x00000001a0a00812ULL, 0x000fe200078efcffULL,
0x000000650404d231ULL, 0x084fe400003400ffULL, 0x000000650606d231ULL, 0x000fe200003400ffULL,
0x0000006c00657245ULL, 0x000fe2000020d400ULL, 0x0000000a0505d231ULL, 0x080fe400003400ffULL,
0x0000000e009f7306ULL, 0x0004e20000205400ULL, 0x000000858400720bULL, 0x002fe20003f1d000ULL,
0x0000000a0707d231ULL, 0x000fe200003400ffULL, 0x000000a9000a7245ULL, 0x000fca000020d400ULL,
0x0000000f008b7306ULL, 0x000fe20000009400ULL, 0x0000000e000e7245ULL, 0x004fe2000020d400ULL,
0x000000620444723cULL, 0x000fec0000041844ULL, 0x0000000f008e7306ULL, 0x000e620000005400ULL,
0x0000009f9a00720bULL, 0x008fce0003fdd000ULL, 0x0000009100927306ULL, 0x000fec0000209400ULL,
0x000000010e0e6812ULL, 0x000fe400078efcffULL, 0x0000009100997306ULL, 0x0004e20000205400ULL,
0x0000008e8b00720bULL, 0x002fce0003f9d000ULL, 0x0000001900327306ULL, 0x000e62000000d400ULL,
0x0000009100917245ULL, 0x004fce000020d400ULL, 0x0000006c007c7306ULL, 0x000fe20000209400ULL,
0x000000999200720bULL, 0x008fce0003f7d000ULL, 0x0000006c00797306ULL, 0x000ea20000205400ULL,
0x0000000132320812ULL, 0x002fca00078efcffULL, 0x0000000191913812ULL, 0x000fe400078efcffULL,
0x0000000f003e7306ULL, 0x0002f0000000d400ULL, 0x0000001a00817306ULL, 0x000fe20000009400ULL,
0x000100000f0f7824ULL, 0x002fe200078e00ffULL, 0x000000797c00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff0f7819ULL, 0x000fe4000001140fULL, 0x0000001a00767306ULL, 0x000e620000005400ULL,
0x000000013e3e4812ULL, 0x008fcc00078efcffULL, 0x0000000165650812ULL, 0x000fe200078efcffULL,
0x000000a900b77306ULL, 0x000ff00000209400ULL, 0x000000a9009e7306ULL, 0x0004e20000205400ULL,
0x000000768100720bULL, 0x002fce0003fdd000ULL, 0x0000007e00827306ULL, 0x000fe20000209400ULL,
0x000000a089a9723eULL, 0x004fce00000010ffULL, 0x0000007e00837306ULL, 0x000e620000205400ULL,
0x0000009eb700720bULL, 0x008fe20003fbd000ULL, 0x000000a80440723cULL, 0x000fe20000041840ULL,
0x000000a2a3b7723eULL, 0x000fca00000010ffULL, 0x0000007700807306ULL, 0x000fe40000209400ULL,
0x000000b60450723cULL, 0x000fe80000041850ULL, 0x000000010a0a5812ULL, 0x000fe400078efcffULL,
0x00000077007b7306ULL, 0x000ea20000205400ULL, 0x000000838200720bULL, 0x002fce0003f5d000ULL,
0x0000000f00967306ULL, 0x000ff00000209400ULL, 0x0000000f009d7306ULL, 0x0002e20000205400ULL,
0x0000007b8000720bULL, 0x004fe40003f9d000ULL, 0x0000007e007b7245ULL, 0x000fc8000020d400ULL,
0x000000017b7b2812ULL, 0x000fe200078efcffULL, 0x000000d600887306ULL, 0x000fe20000209400ULL,
0x0000000f000f7245ULL, 0x002fe4000020d400ULL, 0x0000000e7b0e723eULL, 0x000fc600000010ffULL,
0x0000000164644812ULL, 0x000fe400078efcffULL, 0x000000d6008b7306ULL, 0x0002a20000205400ULL,
0x0000009d9600720bULL, 0x008fe40003f7d000ULL, 0x00000068af9d723eULL, 0x000fca00000010ffULL,
0x0000001a00307306ULL, 0x000722000000d400ULL, 0x000000d600d67245ULL, 0x002fe2000020d400ULL,
0x0000009c044c723cULL, 0x000fe8000004184cULL, 0x000000010f0f3812ULL, 0x000fe400078efcffULL,
0x000000d5008f7306ULL, 0x000fe20000209400ULL, 0x0000008b8800720bULL, 0x004fe20003f1d000ULL,
0x000001001d1a7824ULL, 0x008fe200078e00ffULL, 0x0000000f640f723eULL, 0x000fc800000010ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001141aULL, 0x000000d5008e7306ULL, 0x0002a20000205400ULL,
0x0000000130306812ULL, 0x010fe200078efcffULL, 0x0000000e0414723cULL, 0x000fe20000041814ULL,
0x00000061001a7245ULL, 0x000fc6000020d400ULL, 0x00000001d6d60812ULL, 0x000fe400078efcffULL,
0x000000a500847306ULL, 0x000fe20000209400ULL, 0x000000d500d57245ULL, 0x002fce000020d400ULL,
0x000000a500857306ULL, 0x0002e20000205400ULL, 0x0000008e8f00720bULL, 0x004fce0003fbd000ULL,
0x00000018003d7306ULL, 0x000522000000d400ULL, 0x000000a500a57245ULL, 0x002fca000020d400ULL,
0x00000001d5d55812ULL, 0x000fe400078efcffULL, 0x0000007200757306ULL, 0x000fe20000209400ULL,
0x00000018ff187819ULL, 0x004fe2000001140cULL, 0x000001001f0c7824ULL, 0x000fe200078e00ffULL,
0x000000858400720bULL, 0x008fe40003fdd000ULL, 0x00000030d530723eULL, 0x000fc600000010ffULL,
0x0000007200747306ULL, 0x000e620000205400ULL, 0x000000013d3d1812ULL, 0x010fce00078efcffULL,
0x0000001b007f7306ULL, 0x000fe20000009400ULL, 0x00000001a5a56812ULL, 0x000fce00078efcffULL,
0x0000001b007a7306ULL, 0x000ea20000005400ULL, 0x000000747500720bULL, 0x002fce0003f3d000ULL,
0x0000001800197306ULL, 0x000ff00000209400ULL, 0x0000001800a67306ULL, 0x0002e20000205400ULL,
0x0000007a7f00720bULL, 0x004fce0003f5d000ULL, 0x000000b000b37306ULL, 0x000fe20000209400ULL,
0x0000001800187245ULL, 0x002fce000020d400ULL, 0x000000b000b87306ULL, 0x000e620000205400ULL,
0x000000a61900720bULL, 0x008fe40003f7d000ULL, 0x000000b000197245ULL, 0x000fe4000020d400ULL,
0x000000ae93a6723eULL, 0x000fc600000010ffULL, 0x0000006100667306ULL, 0x000fe80000209400ULL,
0x000000a60448723cULL, 0x000fe40000041848ULL, 0x0000000118183812ULL, 0x000fe400078efcffULL,
0x0000006100677306ULL, 0x000ea20000205400ULL, 0x000000b8b300720bULL, 0x002fe40003f9d000ULL,
0x00000073acb3723eULL, 0x000fc400000010ffULL, 0x0000003d1818723eULL, 0x000fc600000010ffULL,
0x0000001f006a7306ULL, 0x000fe40000009400ULL, 0x000000b20454723cULL, 0x000fe80000041854ULL,
0x0000000119194812ULL, 0x000fe400078efcffULL, 0x0000001f00697306ULL, 0x000e620000005400ULL,
0x000000676600720bULL, 0x004fe40003f1d000ULL, 0x000000321919723eULL, 0x000fca00000010ffULL,
0x000000a400827306ULL, 0x000fec0000209400ULL, 0x000000011a1a0812ULL, 0x000fe400078efcffULL,
0x000000a400817306ULL, 0x0004e20000205400ULL, 0x000000696a00720bULL, 0x002fe20003fbd000ULL,
0x000000183854723cULL, 0x000fe20000041854ULL, 0x000000a51a1a723eULL, 0x000fca00000010ffULL,
0x0000001b00137306ULL, 0x000322000000d400ULL, 0x000000a400a47245ULL, 0x004fce000020d400ULL,
0x0000001d006e7306ULL, 0x000fe20000009400ULL, 0x000001001c1b7824ULL, 0x002fe200078e00ffULL,
0x000000818200720bULL, 0x008fc80003fdd000ULL, 0x00000018ff767819ULL, 0x000fe4000001141bULL,
0x0000001d006d7306ULL, 0x000e620000005400ULL, 0x00000072001b7245ULL, 0x000fe4000020d400ULL,
0x0000000113132812ULL, 0x010fe400078efcffULL, 0x000000011b1b1812ULL, 0x000fe400078efcffULL,
0x00000001a4a46812ULL, 0x000fe200078efcffULL, 0x0000001d00097306ULL, 0x0004f0000000d400ULL,
0x0000001c007d7306ULL, 0x000fe20000009400ULL, 0x000100001d1d7824ULL, 0x004fe200078e00ffULL,
0x0000006d6e00720bULL, 0x002fc80003f3d000ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00787306ULL, 0x000e6e0000005400ULL, 0x0000000109091812ULL, 0x008fe200078efcffULL,
0x000000d400987306ULL, 0x000ff00000209400ULL, 0x000000d400977306ULL, 0x0004e20000205400ULL,
0x000000787d00720bULL, 0x002fce0003f7d000ULL, 0x0000003f00607306ULL, 0x000fe20000209400ULL,
0x000000d400d47245ULL, 0x004fce000020d400ULL, 0x0000003f005f7306ULL, 0x0002a20000205400ULL,
0x000000979800720bULL, 0x008fce0003f9d000ULL, 0x0000007600777306ULL, 0x000fe20000209400ULL,
0x0000003f003f7245ULL, 0x002fca000020d400ULL, 0x00000001d4d44812ULL, 0x000fe400078efcffULL,
0x00000076007a7306ULL, 0x0002e20000205400ULL, 0x0000005f6000720bULL, 0x004fe40003f5d000ULL,
0x00000018ff607819ULL, 0x000fe4000001140cULL, 0x0000003e915f723eULL, 0x000fc600000010ffULL,
0x00000020005c7306ULL, 0x000fe20000209400ULL, 0x0000007600767245ULL, 0x002fc6000020d400ULL,
0x0000005e0434723cULL, 0x000fe40000041834ULL, 0x000000013f3f2812ULL, 0x000fe400078efcffULL,
0x00000020005d7306ULL, 0x000e620000205400ULL, 0x0000007a7700720bULL, 0x008fe40003f1d000ULL,
0x0000000a1b04723eULL, 0x000fe400000010ffULL, 0x000000d46505723eULL, 0x000fe400000010ffULL,
0x000000a43f1b723eULL, 0x000fe200000010ffULL, 0x0000001c00117306ULL, 0x0004e8000000d400ULL,
0x000000043850723cULL, 0x000fe40000041850ULL, 0x0000000176760812ULL, 0x000fc400078efcffULL,
0x0000001d00697306ULL, 0x000fe20000209400ULL, 0x000100001c1c7824ULL, 0x004fe200078e00ffULL,
0x0000005d5c00720bULL, 0x002fe40003fdd000ULL, 0x0000002000057245ULL, 0x000fe2000020d400ULL,
0x0000001a3848723cULL, 0x000fe20000041848ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001d00687306ULL, 0x0002a20000205400ULL, 0x0000000111113812ULL, 0x008fe400078efcffULL,
0x0000000b00047245ULL, 0x000fc4000020d400ULL, 0x000000117676723eULL, 0x000fe400000010ffULL,
0x0000000105056812ULL, 0x000fe200078efcffULL, 0x0000001e006f7306ULL, 0x000fe20000009400ULL,
0x0000001d001d7245ULL, 0x002fce000020d400ULL, 0x0000001e00707306ULL, 0x000e620000005400ULL,
0x000000686900720bULL, 0x004fce0003f3d000ULL, 0x0000000b003c7306ULL, 0x000fec0000209400ULL,
0x000000011d1d1812ULL, 0x000fe400078efcffULL, 0x0000000b00337306ULL, 0x000ea20000205400ULL,
0x000000706f00720bULL, 0x002fce0003f9d000ULL, 0x0000007e00787306ULL, 0x000ff00000209400ULL,
0x0000007e00757306ULL, 0x0002e20000205400ULL, 0x000000333c00720bULL, 0x004fce0003f5d000ULL,
0x0000001c00717306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x002fca000020d400ULL,
0x0000000104042812ULL, 0x000fe400078efcffULL, 0x0000001c006c7306ULL, 0x0002a20000205400ULL,
0x000000757800720bULL, 0x008fe40003f1d000ULL, 0x0000001d041d723eULL, 0x000fca00000010ffULL,
0x0000001e00087306ULL, 0x000722000000d400ULL, 0x0000001c001c7245ULL, 0x002fca000020d400ULL,
0x000000017e7e0812ULL, 0x000fe400078efcffULL, 0x0000001f00037306ULL, 0x000362000000d400ULL,
0x000100001e1e7824ULL, 0x008fe200078e00ffULL, 0x0000006c7100720bULL, 0x004fe40003f7d000ULL,
0x000000097e77723eULL, 0x000fe400000010ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000006000627306ULL, 0x000fe20000209400ULL, 0x000100001f1f7824ULL, 0x002fe200078e00ffULL,
0x0000000108084812ULL, 0x010fe200078efcffULL, 0x000000763844723cULL, 0x000fe60000041844ULL,
0x00000018ff1f7819ULL, 0x000fc4000001141fULL, 0x00000060005d7306ULL, 0x0002a20000205400ULL,
0x000000011c1c3812ULL, 0x000fe400078efcffULL, 0x0000000103035812ULL, 0x020fe400078efcffULL,
0x0000001c051c723eULL, 0x000fc600000010ffULL, 0x0000000d00667306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x002fc6000020d400ULL, 0x0000001c3840723cULL, 0x000fe80000041840ULL,
0x0000000d00617306ULL, 0x0002e20000205400ULL, 0x0000005d6200720bULL, 0x004fce0003f3d000ULL,
0x0000000200317306ULL, 0x000fe20000209400ULL, 0x0000000d000d7245ULL, 0x002fca000020d400ULL,
0x0000000160601812ULL, 0x000fe400078efcffULL, 0x0000000200227306ULL, 0x000e620000205400ULL,
0x000000616600720bULL, 0x008fe40003fdd000ULL, 0x000000036009723eULL, 0x000fe400000010ffULL,
0x0000000200037245ULL, 0x000fc6000020d400ULL, 0x0000000000127306ULL, 0x000fec0000209400ULL,
0x000000010d0d6812ULL, 0x000fe400078efcffULL, 0x0000000000217306ULL, 0x0004e20000205400ULL,
0x000000223100720bULL, 0x002fe40003f1d000ULL, 0x00000013d631723eULL, 0x000fc400000010ffULL,
0x000000080d08723eULL, 0x000fc600000010ffULL, 0x0000001e000c7306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x004fe2000020d400ULL, 0x00000030384c723cULL, 0x040fe8000004184cULL,
0x0000000103030812ULL, 0x000fe400078efcffULL, 0x0000001e00077306ULL, 0x0002a20000205400ULL,
0x000000211200720bULL, 0x008fe20003f7d000ULL, 0x000000083834723cULL, 0x000fec0000041834ULL,
0x0000001f00067306ULL, 0x000fe20000209400ULL, 0x0000001e001e7245ULL, 0x002fca000020d400ULL,
0x0000000100003812ULL, 0x000fe400078efcffULL, 0x0000001f000f7306ULL, 0x0002e20000205400ULL,
0x000000070c00720bULL, 0x004fe40003f5d000ULL, 0x0000001f001f7245ULL, 0x002fd6000020d400ULL,
0x000000011e1e2812ULL, 0x000fe400078efcffULL, 0x0000000f0600720bULL, 0x008fe40003f9d000ULL,
0x0000001e031e723eULL, 0x000fd600000010ffULL, 0x000000011f1f4812ULL, 0x000fc800078efcffULL,
0x0000001f001f723eULL, 0x000fce00000010ffULL, 0x0000001e3838723cULL, 0x000fe20000041814ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01064000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff23ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff697807ULL, 0x000fe40004000000ULL, 0x000003005b5b7a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff25ff7812ULL, 0x000fe4000780c0ffULL, 0x0000002e5b00720cULL, 0x000fe40003f26070ULL,
0x00000001ff257807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xfffecc7000007947ULL, 0x000fea000383ffffULL, 0x00000000002b7919ULL, 0x000e640000002500ULL,
0x0000002e2b00720cULL, 0x002fda0003f06070ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x0180000028007810ULL, 0x010fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000142d000047802ULL, 0x000fe40000000f00ULL,
0x0000971000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002800037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000028ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000057919ULL, 0x000ee40000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x004fca0000410000ULL, 0x00001f0700047589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000005404547220ULL, 0x044fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004404447220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004004407220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003804387220ULL, 0x040fe20000410000ULL,
0x0000003904397220ULL, 0x000fe20000410000ULL, 0x0000005605567220ULL, 0x048fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000004e054e7220ULL, 0x040fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000004a054a7220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004605467220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x000fe20000410000ULL, 0x00000000000c7919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000020c007812ULL, 0x014fc400078ec0ffULL,
0x00000002ff0d7819ULL, 0x000fe4000001160cULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000200037811ULL, 0x040fe400078ff8ffULL, 0x0000000400067811ULL, 0x040fe400078ff8ffULL,
0x00000006000a7811ULL, 0x000fe400078ff8ffULL, 0x000000080c157811ULL, 0x000fc400078ff0ffULL,
0x0000000702007812ULL, 0x100fe400078e780dULL, 0x0000000703047812ULL, 0x100fe400078e780dULL,
0x0000000706087812ULL, 0x100fe200078e780dULL, 0x000000080d057824ULL, 0x040fe200078e0200ULL,
0x000000070a0b7812ULL, 0x000fe200078e780dULL, 0x000008005a007824ULL, 0x000fe200078e00ffULL,
0x0000000706067812ULL, 0x100fe200078e7815ULL, 0x000000080d077824ULL, 0x040fe200078e0204ULL,
0x0000000702027812ULL, 0x100fe200078e7815ULL, 0x000000080d097824ULL, 0x000fe200078e0208ULL,
0x0000000703037812ULL, 0x000fe200078e7815ULL, 0x000000080d0d7824ULL, 0x000fe200078e020bULL,
0x000000070a0a7812ULL, 0x000fe200078e7815ULL, 0x0000000815137824ULL, 0x000fe200078e0206ULL,
0x000000505104723eULL, 0x000fe200000010ffULL, 0x00000008150b7824ULL, 0x000fe200078e0202ULL,
0x0000a00000027810ULL, 0x000fe20007ffe0ffULL, 0x000000080c067824ULL, 0x000fe200078e00ffULL,
0x000000525308723eULL, 0x000fe200000010ffULL, 0x0000000815117824ULL, 0x000fe200078e0203ULL,
0x000000545503723eULL, 0x000fe200000010ffULL, 0x0000000815157824ULL, 0x000fe200078e020aULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x000fe200078e0202ULL,
0x0000541003167816ULL, 0x000fe20000000004ULL, 0x000000100b0f7824ULL, 0x000fe200078e0202ULL,
0x0000763203177816ULL, 0x000fe20000000004ULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x000000444503723eULL, 0x000fe200000010ffULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x000000404104723eULL, 0x000fe200000010ffULL, 0x00000010090b7824ULL, 0x000fc400078e0202ULL,
0x000000100d0d7824ULL, 0x100fe400078e0202ULL, 0x0000001013137824ULL, 0x100fe400078e0202ULL,
0x0000001015157824ULL, 0x000fe400078e0202ULL, 0x0000000105097824ULL, 0x000fe200078e0206ULL,
0x0000004c4d05723eULL, 0x000fe200000010ffULL, 0x00000001060f7824ULL, 0x040fe400078e020fULL,
0x00000001060a7824ULL, 0x040fe200078e0207ULL, 0x0000001609007388ULL, 0x0005e20000000a00ULL,
0x0000000106117824ULL, 0x040fe200078e0211ULL, 0x000000565707723eULL, 0x000fe200000010ffULL,
0x00000001060b7824ULL, 0x000fc400078e020bULL, 0x00000001060d7824ULL, 0x040fe400078e020dULL,
0x0000000106137824ULL, 0x040fe400078e0213ULL, 0x0000000106157824ULL, 0x000fe200078e0215ULL,
0x000000484906723eULL, 0x000fc800000010ffULL, 0x0000541005167816ULL, 0x144fe40000000006ULL,
0x0000763205177816ULL, 0x000fe40000000006ULL, 0x000000343505723eULL, 0x000fe400000010ffULL,
0x000000383906723eULL, 0x000fe200000010ffULL, 0x000000160a007388ULL, 0x0005e40000000a00ULL,
0x0000541003167816ULL, 0x144fe40000000004ULL, 0x0000763203177816ULL, 0x000fc40000000004ULL,
0x00005410050a7816ULL, 0x100fe40000000006ULL, 0x0000004e4f03723eULL, 0x000fe200000010ffULL,
0x000000160b007388ULL, 0x0005e20000000a00ULL, 0x0000004a4b04723eULL, 0x000fe400000010ffULL,
0x00007632050b7816ULL, 0x004fe20000000006ULL, 0x00000300ff167624ULL, 0x000fe200078e00ffULL,
0x000000464705723eULL, 0x000fe400000010ffULL, 0x000000424306723eULL, 0x000fe200000010ffULL,
0x0000000a0d007388ULL, 0x0005e20000000a00ULL, 0x000000011600780cULL, 0x000fc40003f05270ULL,
0x00005410070a7816ULL, 0x144fe40000000008ULL, 0x00007632070b7816ULL, 0x000fe40000000008ULL,
0x000000363707723eULL, 0x000fe400000010ffULL, 0x0000003a3b08723eULL, 0x000fe200000010ffULL,
0x0000000a0f007388ULL, 0x0005e40000000a00ULL, 0x00005410030a7816ULL, 0x144fe40000000004ULL,
0x00007632030b7816ULL, 0x000fc40000000004ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x0000000a11007388ULL, 0x0005e20000000a00ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000000413007388ULL, 0x0005e80000000a00ULL, 0x0000000615007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002cc000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ee20000000000ULL, 0x0000580016047a24ULL, 0x004fe200078e02ffULL,
0x000000ff5a00720cULL, 0x000fe20003f25270ULL, 0x00002000ff077424ULL, 0x000fe200078e00ffULL,
0x0000000000147919ULL, 0x000ea20000002700ULL, 0x0000660004087a24ULL, 0x000fc600078e02ffULL,
0x0000000000057919ULL, 0x000ea20000002600ULL, 0x0000001003097824ULL, 0x048fe200078e0200ULL,
0x00000020030f7810ULL, 0x040fe40007ffe0ffULL, 0x0000004003117810ULL, 0x040fe40007ffe0ffULL,
0x00a0000009187984ULL, 0x0007220000000c00ULL, 0x0000006003137810ULL, 0x000fe20007ffe0ffULL,
0x0000580014147a24ULL, 0x004fe400078e0205ULL, 0x00a20000091c7984ULL, 0x0006a20000000c00ULL,
0x00001fff08057811ULL, 0x000fe200078e40ffULL, 0x0000030014047a24ULL, 0x000fc400078e02ffULL,
0x00a4000009207984ULL, 0x0006620000000c00ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x00000001040a7824ULL, 0x000fe400078e022bULL, 0x00a6000009247984ULL, 0x0006620000000c00ULL,
0x000000ff5a00720cULL, 0x000fe40000705670ULL, 0x0000000a05067211ULL, 0x000fca00078f98ffULL,
0x00006c0006067625ULL, 0x000fcc00078e0007ULL, 0x000008005a067825ULL, 0x000fcc00078e0006ULL,
0x000000100f0e7825ULL, 0x000fc800078e0006ULL, 0x0000001011107825ULL, 0x000fc800078e0006ULL,
0x0000001013127825ULL, 0x000fc800078e0006ULL, 0x00000010030c7825ULL, 0x000fe200078e0006ULL,
0x01ffffff08077812ULL, 0x000fe200078ec0ffULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x01cea20000000000ULL, 0x00000080ff067424ULL, 0x000fe400078e00ffULL,
0x000000010a0b7824ULL, 0x000fe400078e0207ULL, 0x0000001008157824ULL, 0x004fe200078e00ffULL,
0x00000001ff177819ULL, 0x000fe20000011608ULL, 0x00006c000a087625ULL, 0x000fc600078e0006ULL,
0x0000007015157812ULL, 0x000fe200078ec0ffULL, 0x00006c000b0a7625ULL, 0x000fe200078e0006ULL,
0x0000000c17177812ULL, 0x000fc800078ec0ffULL, 0x0000000817087210ULL, 0x140fe40007b5e015ULL,
0x0000000a170a7210ULL, 0x000fe40007d9e015ULL, 0x00000009ff097210ULL, 0x000fe400017e64ffULL,
0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL, 0x0000002908007986ULL, 0x0005e8000c101906ULL,
0x000000280a007986ULL, 0x0005e4000c101906ULL, 0x000000180c007986ULL, 0x01c5e2000c101d06ULL,
0x0000014000007945ULL, 0x000fe60003800000ULL, 0x0000001c0e007986ULL, 0x0005e8000c101d06ULL,
0x0000002010007986ULL, 0x0025e8000c101d06ULL, 0x0000002412007986ULL, 0x0005e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0xffffffff160b7810ULL, 0x000fc60007ffe0ffULL,
0x00006a0014087625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000b080879a8ULL, 0x000ee400099ee1c6ULL,
0x0000000b0800720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff067807ULL, 0x000fca0000000000ULL, 0x00000006ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x002e640000000000ULL, 0x000000ff0600720cULL, 0x002fda0003f05270ULL,
0x0000285000008947ULL, 0x000fea0003800000ULL, 0x00000d1000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff087819ULL, 0x000fe20000011603ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001040a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff177424ULL, 0x000fe200078e00ffULL,
0x0000000c080c7812ULL, 0x004fe400078ec0ffULL, 0x0000007006197812ULL, 0x000fe200078ec0ffULL,
0x00006c0004087625ULL, 0x000fc800078e0017ULL, 0x00006c000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x0000000a0c0a7210ULL, 0x000fe40007b5e019ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x0000000608067981ULL, 0x000368000c1e1900ULL, 0x000000060a0d7981ULL, 0x000362000c1e1900ULL,
0x000000021600780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000204087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000041600780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000304087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000362000c1e1900ULL,
0x000000041600780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000404087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608137981ULL, 0x000362000c1e1900ULL, 0x000000061600780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000504087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608157981ULL, 0x000362000c1e1900ULL,
0x000000061600780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081600780cULL, 0x002fe40003f06070ULL, 0x0000000604087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fe40007a3e019ULL,
0x00000007040a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000a0a0625ULL, 0x000fe400078e0017ULL, 0x0000000608177981ULL, 0x000366000c1e1900ULL,
0x0000000a0c0a0210ULL, 0x000fc80007c7e019ULL, 0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL,
0x000000060a0b0981ULL, 0x000366000c1e1900ULL, 0x0000000716087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc80000011608ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x004fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x020fe400078e0006ULL, 0x00000008190c7824ULL, 0x040fe200078e00ffULL,
0x0000000119197810ULL, 0x000fc80007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x0000000a1900720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080c097810ULL, 0x040fe40007ffe0ffULL, 0x000000010c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001b06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e1b7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e01bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081b7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090c097810ULL, 0x042fe40007ffe0ffULL,
0x000000020c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000d06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000030c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000f06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000040c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001106067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e117812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000050c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001306067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e137812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000060c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001506067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e157812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608157981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000070c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001706067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e177812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e017ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608177981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0c097810ULL, 0x002fe40007ffe0ffULL,
0x0000000b06067209ULL, 0x000fe40007810000ULL, 0x0000030009007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000080c087210ULL, 0x000fc80007a3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080b7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x0000001003087824ULL, 0x00afe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011603ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000108097824ULL, 0x000fca00078e0209ULL,
0x0000000609007388ULL, 0x0203e40000000800ULL, 0x0000000405087211ULL, 0x000fe200078f98ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00002000ff097424ULL, 0x002fe200078e00ffULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x0000001003067824ULL, 0x040fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011603ULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x00000015ff197819ULL, 0x004fe2000001165aULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x000008005a187824ULL, 0x000fe200078e00ffULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x000010005a2a7824ULL, 0x000fe200078e00ffULL,
0x00000040030d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000001808087210ULL, 0x000fe20007f3e0ffULL, 0x0000000106067824ULL, 0x000fe200078e020bULL,
0x00000020030b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104108824ULL, 0x000fe200078e0207ULL,
0x00000060030f7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000109097824ULL, 0x000fe200008e0619ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff138424ULL, 0x000fe200078e00ffULL,
0x0000000006287984ULL, 0x0002a20000000800ULL, 0x00006c0010108625ULL, 0x000fe200078e0011ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000000100b0a7825ULL, 0x000fe200078e0008ULL,
0x0000000000367805ULL, 0x000fc6000001ff00ULL, 0x000000100d0c7825ULL, 0x000fc800078e0008ULL,
0x000000100f0e7825ULL, 0x000fc800078e0008ULL, 0x000000105a1d8824ULL, 0x000fe400078e0203ULL,
0x00006c0004128625ULL, 0x000fc600078e0013ULL, 0x000045801d1d8811ULL, 0x000fe200078e20ffULL,
0x0000001003157824ULL, 0x040fe400078e022aULL, 0x0000001003087825ULL, 0x000fc800078e0008ULL,
0x000000105a1f8824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008157faeULL, 0x0007e2000b901c46ULL, 0x0000001003108825ULL, 0x000fc600078e0010ULL,
0x000041801f1f8811ULL, 0x000fe200078e20ffULL, 0x0000001003128825ULL, 0x000fe200078e0012ULL,
0x003800000a157faeULL, 0x0009e6000b901c46ULL, 0x000000ffff067224ULL, 0x002fe200078e00ffULL,
0x005800000c157faeULL, 0x0003e2000b901c46ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x008fe2000001ff00ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x007800000e157faeULL, 0x0007e2000b901c46ULL, 0x000000ffff2d7224ULL, 0x000fc400078e00ffULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x00000000101d8faeULL, 0x000be2000b901c46ULL,
0x00000000000a7805ULL, 0x010fc6000001ff00ULL, 0x00000000121f8faeULL, 0x0009e2000b901c46ULL,
0x00000000000c7805ULL, 0x002fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x020fe2000001ff00ULL, 0x0000000000127805ULL, 0x010fe2000001ff00ULL,
0x00000d5000009947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x004fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fca00078e00ffULL, 0x00000001393b7810ULL, 0x000fc80007ffe0ffULL,
0x000003003b007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x00000001043a7824ULL, 0x000fe200078e023bULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x00002000ff1d7424ULL, 0x000fe200078e00ffULL, 0x000000013b217812ULL, 0x040fe200078ec0ffULL,
0x000008003b1e7824ULL, 0x000fe200078e00ffULL, 0x0000003a051c7211ULL, 0x000fe400078f98ffULL,
0x0000002003237810ULL, 0x040fe40007ffe0ffULL, 0x000008001e1f7812ULL, 0x000fe200078ec0ffULL,
0x00006c001c1c7625ULL, 0x000fe200078e001dULL, 0x0000004003277810ULL, 0x000fc40007ffe0ffULL,
0x00000060033f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012a1e7824ULL, 0x000fe200078e021fULL,
0x000000181c1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000107249824ULL, 0x000fe400078e023aULL,
0x00000080ff259424ULL, 0x000fe400078e00ffULL, 0x000000011d1d7824ULL, 0x000fe400000e0619ULL,
0x000000025a269824ULL, 0x140fe400078e0221ULL, 0x000000025a3c9824ULL, 0x000fc400078e0221ULL,
0x00000080ff419424ULL, 0x000fe400078e00ffULL, 0x00000010033d7824ULL, 0x000fe400078e021eULL,
0x0000001023207825ULL, 0x000fc800078e001cULL, 0x0000001027227825ULL, 0x000fc800078e001cULL,
0x00000010031e7825ULL, 0x000fc800078e001cULL, 0x000000103f1c7825ULL, 0x000fe200078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800001e3d7faeULL, 0x0003e6000b901c46ULL,
0x00006c0024249625ULL, 0x000fe200078e0025ULL, 0x00380000203d7faeULL, 0x0003e6000b901c46ULL,
0x00000008263f9824ULL, 0x000fe200078e0203ULL, 0x00580000223d7faeULL, 0x0003e2000b901c46ULL,
0x00006c003a269625ULL, 0x000fc600078e0041ULL, 0x000045803f3f9811ULL, 0x000fe200078e20ffULL,
0x000000083c3c9824ULL, 0x000fe200078e0203ULL, 0x007800001c3d7faeULL, 0x0003e2000b901c46ULL,
0x0000001003249825ULL, 0x000fc600078e0024ULL, 0x000041803c419811ULL, 0x000fe200078e20ffULL,
0x0000001003269825ULL, 0x000fe200078e0026ULL, 0x00000000243f9faeULL, 0x0003e8000b901c46ULL,
0x0000000026419faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000080391c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff1f7819ULL, 0x100fe20000011603ULL,
0x00000010031e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff507819ULL, 0x000fc40000011603ULL,
0x000000801c1d7812ULL, 0x000fe400078ec0ffULL, 0x000000701e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000850217824ULL, 0x000fe200078e00ffULL, 0x0000000c1f1f7812ULL, 0x000fe200078ec0ffULL,
0x000001005a1d7824ULL, 0x000fe200078e021dULL, 0x00000007503c7812ULL, 0x040fe200078ec0ffULL,
0x0000000850237824ULL, 0x040fe200078e00ffULL, 0x00000050ff3e7212ULL, 0x000fe400078e33ffULL,
0x0000001d1f1e7210ULL, 0x000fe20007ffe01eULL, 0x00000008501d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8211c7812ULL, 0x000fc400078ee23cULL, 0xfffffff8233e7812ULL, 0x000fe400078ee23eULL,
0x000000011d207812ULL, 0x000fe200078ef63cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001e1f7984ULL, 0x000e620000000800ULL, 0x000000021d227812ULL, 0x140fe400078ef63cULL,
0x000000031d247812ULL, 0x140fe200078ef63cULL, 0x004580001e4e7984ULL, 0x0004e20000000800ULL,
0x000000041d267812ULL, 0x140fe400078ef63cULL, 0x000000051d3a7812ULL, 0x140fe400078ef63cULL,
0x000000061d3c7812ULL, 0x000fe200078ef63cULL, 0x00000800391d7824ULL, 0x000fe200078e00ffULL,
0x0000000850527810ULL, 0x000fe20007ffe0ffULL, 0x00000004031e7824ULL, 0x004fc400078e00ffULL,
0x000000ffff397224ULL, 0x000fe200078e003bULL, 0x000008001d1d7812ULL, 0x000fe200078ec0ffULL,
0x0000000852217824ULL, 0x040fe200078e00ffULL, 0x00000052ff4c7212ULL, 0x000fe200078e33ffULL,
0x0000000852427824ULL, 0x000fe200078e00ffULL, 0x000001802a1d7810ULL, 0x000fe20007ffe01dULL,
0x0000000852407824ULL, 0x040fe200078e00ffULL, 0xfffffff8214c7812ULL, 0x000fe400078ee24cULL,
0x0000000752217812ULL, 0x000fe200078ec0ffULL, 0x000000101c1c7824ULL, 0x100fe200078e021dULL,
0x0000030039007a0cULL, 0x000fe20003f06070ULL, 0x000000103e3e7824ULL, 0x000fe200078e021dULL,
0x0000000240447812ULL, 0x000fe200078ef621ULL, 0x0000001020207824ULL, 0x000fe200078e021dULL,
0x0000000340467812ULL, 0x000fe200078ef621ULL, 0x0000001022227824ULL, 0x000fe200078e021dULL,
0x0000000440487812ULL, 0x000fe200078ef621ULL, 0x0000001024247824ULL, 0x000fe200078e021dULL,
0x00000005404a7812ULL, 0x000fe200078ef621ULL, 0x0000001026267824ULL, 0x000fc400078e021dULL,
0x000000103a3a7824ULL, 0x100fe400078e021dULL, 0x000000103c3c7824ULL, 0x000fe200078e021dULL,
0x0000001f281f7221ULL, 0x002fe20000010100ULL, 0x0000001044447824ULL, 0x100fe400078e021dULL,
0x0000001046467824ULL, 0x100fe200078e021dULL, 0x3fb8aa3b1f237820ULL, 0x000fe20000410000ULL,
0x0000000c1e1f7812ULL, 0x000fe200078ec0ffULL, 0x0000001048487824ULL, 0x000fe200078e021dULL,
0xfffffff8421e7812ULL, 0x000fe200078ee221ULL, 0x000000104a4a7824ULL, 0x000fe200078e021dULL,
0x0000000140427812ULL, 0x000fe200078ef621ULL, 0x000000011c1c7824ULL, 0x000fe200078e021fULL,
0x0000002300237308ULL, 0x000ee20000000800ULL, 0x000000011f3e7824ULL, 0x040fe200078e023eULL,
0x0000000640407812ULL, 0x000fe200078ef621ULL, 0x000000011f207824ULL, 0x040fe200078e0220ULL,
0x000000001c257984ULL, 0x000e620000000800ULL, 0x000000011f227824ULL, 0x000fc400078e0222ULL,
0x000000011f247824ULL, 0x040fe200078e0224ULL, 0x000000003e3e7984ULL, 0x000fe20000000800ULL,
0x000000011f267824ULL, 0x040fe400078e0226ULL, 0x000000011f3a7824ULL, 0x040fe200078e023aULL,
0x0000000020207984ULL, 0x000fe20000000800ULL, 0x000000101e1e7824ULL, 0x000fe400078e021dULL,
0x000000011f3c7824ULL, 0x000fe200078e023cULL, 0x0000004e23237220ULL, 0x008fe20000410000ULL,
0x0000000022227984ULL, 0x000fe20000000800ULL, 0x000000011f1e7824ULL, 0x000fc400078e021eULL,
0x0000001042427824ULL, 0x100fe200078e021dULL, 0x00001f5023217589ULL, 0x000ea200000e0000ULL,
0x0000001040407824ULL, 0x100fe200078e021dULL, 0x0000003823387221ULL, 0x000fe20000010000ULL,
0x000000011f427824ULL, 0x040fe200078e0242ULL, 0x0000000024247984ULL, 0x000ee20000000800ULL,
0x000000104c4c7824ULL, 0x000fe400078e021dULL, 0x000000011f447824ULL, 0x040fe200078e0244ULL,
0x0000000026267984ULL, 0x000f220000000800ULL, 0x000000011f467824ULL, 0x000fc400078e0246ULL,
0x000000011f487824ULL, 0x040fe200078e0248ULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x000000011f4a7824ULL, 0x040fe400078e024aULL, 0x000000011f407824ULL, 0x040fe200078e0240ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x000000011f4c7824ULL, 0x000fc600078e024cULL,
0x000000001e1e7984ULL, 0x000f620000000800ULL, 0x00005410ff1c7816ULL, 0x002fc60000000025ULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x00007610ff1d7816ULL, 0x000fe20000000025ULL,
0x000000211c377223ULL, 0x004fe20000010037ULL, 0x00007610ff1c7816ULL, 0x000fc6000000003eULL,
0x000000211d367223ULL, 0x080fe20000010036ULL, 0x00005410ff1d7816ULL, 0x000fe2000000003eULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x000000211c177223ULL, 0x080fe20000010017ULL,
0x00005410ff1c7816ULL, 0x000fe40000000020ULL, 0x000000211d1a7223ULL, 0x080fe2000001001aULL,
0x00007610ff1d7816ULL, 0x000fe20000000020ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x000000211c357223ULL, 0x000fe20000010035ULL, 0x00005410ff1c7816ULL, 0x000fc40000000022ULL,
0x00001f5223237589ULL, 0x000e6200000e0000ULL, 0x000000211d347223ULL, 0x080fe20000010034ULL,
0x00007610ff1d7816ULL, 0x000fe20000000022ULL, 0x000000211c337223ULL, 0x080fe20000010033ULL,
0x00005410ff1c7816ULL, 0x008fe20000000024ULL, 0x0000000048487984ULL, 0x000ea40000000800ULL,
0x000000211d327223ULL, 0x080fe20000010032ULL, 0x00007610ff1d7816ULL, 0x000fe20000000024ULL,
0x000000211c317223ULL, 0x080fe20000010031ULL, 0x00005410ff1c7816ULL, 0x010fe20000000026ULL,
0x000000004a4a7984ULL, 0x000ee40000000800ULL, 0x000000211d307223ULL, 0x080fe20000010030ULL,
0x00007610ff1d7816ULL, 0x000fe20000000026ULL, 0x000000211c2f7223ULL, 0x080fe2000001002fULL,
0x00005410ff1c7816ULL, 0x020fe2000000003aULL, 0x0000000040407984ULL, 0x000f240000000800ULL,
0x000000211d2e7223ULL, 0x080fe2000001002eULL, 0x00005410ff1d7816ULL, 0x000fe2000000001eULL,
0x000000211c2d7223ULL, 0x000fe2000001002dULL, 0x00007610ff1c7816ULL, 0x000fe2000000003aULL,
0x000000004c4c7984ULL, 0x000f640000000800ULL, 0x000000231d167223ULL, 0x002fe20000010016ULL,
0x00005410ff1d7816ULL, 0x000fe20000000042ULL, 0x000000211c2b7223ULL, 0x000fe2000001002bULL,
0x00005410ff1c7816ULL, 0x000fc6000000003cULL, 0x000000231d147223ULL, 0x000fe20000010014ULL,
0x00005410ff1d7816ULL, 0x000fe20000000044ULL, 0x000000211c297223ULL, 0x000fe20000010029ULL,
0x00007610ff1c7816ULL, 0x000fc6000000003cULL, 0x000000231d127223ULL, 0x000fe20000010012ULL,
0x00005410ff1d7816ULL, 0x000fe20000000046ULL, 0x000000211c1b7223ULL, 0x000fe2000001001bULL,
0x00007610ff1c7816ULL, 0x000fc6000000001eULL, 0x000000231d107223ULL, 0x080fe40000010010ULL,
0x000000231c157223ULL, 0x000fe20000010015ULL, 0x00007610ff1c7816ULL, 0x000fe40000000042ULL,
0x00005410ff1d7816ULL, 0x004fc60000000048ULL, 0x000000231c137223ULL, 0x080fe20000010013ULL,
0x00007610ff1c7816ULL, 0x000fe20000000044ULL, 0x000000231d0e7223ULL, 0x000fe2000001000eULL,
0x00005410ff1d7816ULL, 0x008fc6000000004aULL, 0x000000231c117223ULL, 0x080fe20000010011ULL,
0x00007610ff1c7816ULL, 0x000fe20000000046ULL, 0x000000231d0c7223ULL, 0x000fe2000001000cULL,
0x00005410ff1d7816ULL, 0x010fc60000000040ULL, 0x000000231c0f7223ULL, 0x080fe2000001000fULL,
0x00007610ff1c7816ULL, 0x000fe20000000048ULL, 0x000000231d0a7223ULL, 0x000fe2000001000aULL,
0x00005410ff1d7816ULL, 0x020fc6000000004cULL, 0x000000231c0d7223ULL, 0x080fe2000001000dULL,
0x00007610ff1c7816ULL, 0x000fe2000000004aULL, 0x000000231d087223ULL, 0x000fe20000010008ULL,
0x00007610ff1d7816ULL, 0x000fc6000000004cULL, 0x000000231c0b7223ULL, 0x080fe2000001000bULL,
0x00007610ff1c7816ULL, 0x000fe20000000040ULL, 0x000000231d067223ULL, 0x000fc80000010006ULL,
0x000000231c097223ULL, 0x000fe20000010009ULL, 0xfffff2d000008947ULL, 0x000fea000383ffffULL,
0x0180000038037810ULL, 0x004fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000003037812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e0038ULL, 0x00016ef000047802ULL, 0x000fe40000000f00ULL,
0x00006af000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003800037308ULL, 0x000e640000001000ULL, 0xbf80000003047423ULL, 0x002fc80000000038ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403037223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000001e7919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff207819ULL, 0x010fe4000001161eULL,
0x000000081e3b7811ULL, 0x040fe200078ff0ffULL, 0x000000041e1e7824ULL, 0x000fe400078e00ffULL,
0x00001f2003047589ULL, 0x00cea200000e0000ULL, 0x0000003bff397212ULL, 0x000fe200078e33ffULL,
0x000000083b227824ULL, 0x000fe200078e00ffULL, 0x0000000c1e1e7812ULL, 0x000fe200078ec0ffULL,
0x00001f3b03057589ULL, 0x00072600000e0000ULL, 0xfffffff822397812ULL, 0x000fca00078ee239ULL,
0x0000001039397824ULL, 0x000fe200078e0202ULL, 0x00000020ff037212ULL, 0x008fe200078e33ffULL,
0x0000003704377220ULL, 0x044fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002b04187220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000001b041c7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x000fe20000410000ULL,
0x0000000820047824ULL, 0x000fe200078e00ffULL, 0x0000000e050e7220ULL, 0x050fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0xfffffff8043d7812ULL, 0x000fe200078ee203ULL,
0x0000000820037824ULL, 0x040fe200078e00ffULL, 0x0000000720047812ULL, 0x000fe200078ec0ffULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001305137220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000000104077812ULL, 0x040fe200078e3cffULL,
0x0000001105117220ULL, 0x040fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000000f050f7220ULL, 0x040fe20000410000ULL, 0x0000000c050c7220ULL, 0x040fe20000410000ULL,
0x0000000b050b7220ULL, 0x040fe20000410000ULL, 0x0000000a050a7220ULL, 0x040fe20000410000ULL,
0x0000000905097220ULL, 0x040fe20000410000ULL, 0x0000000805087220ULL, 0x040fe20000410000ULL,
0x0000000204197812ULL, 0x040fe200078e3cffULL, 0x0000000605057220ULL, 0x000fe20000410000ULL,
0x00000003041b7812ULL, 0x000fe200078e3cffULL, 0x000000083b067824ULL, 0x000fe200078e00ffULL,
0x0000000e0d0d723eULL, 0x000fe200000010ffULL, 0x0000000820077824ULL, 0x040fe200078e0207ULL,
0xfffffff803037812ULL, 0x000fe200078ee220ULL, 0x0000000820197824ULL, 0x000fe200078e0219ULL,
0x00000004041d7812ULL, 0x000fe200078e3cffULL, 0x00000008201b7824ULL, 0x000fe200078e021bULL,
0x000000073b0e7812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x100fe200078e0202ULL,
0x00000005041f7812ULL, 0x000fe200078e3cffULL, 0x00000008201d7824ULL, 0x000fe200078e021dULL,
0x0000000604217812ULL, 0x000fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x00000008201f7824ULL, 0x040fe200078e021fULL,
0x0000000a0909723eULL, 0x000fe200000010ffULL, 0x0000000820217824ULL, 0x000fe200078e0221ULL,
0x000000080505723eULL, 0x000fe200000010ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0xfffffff806237812ULL, 0x000fe200078ee23bULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x000000010e047812ULL, 0x000fe200078e3cffULL, 0x000000011e037824ULL, 0x000fe200078e0203ULL,
0x000000020e067812ULL, 0x040fe200078e3cffULL, 0x000000101d1d7824ULL, 0x000fe200078e0202ULL,
0x000000030e087812ULL, 0x040fe200078e3cffULL, 0x000000083b257824ULL, 0x000fe200078e0204ULL,
0x000000040e0a7812ULL, 0x040fe200078e3cffULL, 0x000000101f1f7824ULL, 0x000fe200078e0202ULL,
0x000000050e0c7812ULL, 0x000fe200078e3cffULL, 0x000000011e077824ULL, 0x000fe200078e0207ULL,
0x000000060e0e7812ULL, 0x000fe200078e3cffULL, 0x000000083b277824ULL, 0x000fe200078e0206ULL,
0x000000373636723eULL, 0x000fe200000010ffULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x000000353434723eULL, 0x000fe200000010ffULL, 0x000000011e197824ULL, 0x000fe200078e0219ULL,
0x000000333232723eULL, 0x000fe200000010ffULL, 0x000000083b2b7824ULL, 0x040fe200078e020aULL,
0x0000002f2e2e723eULL, 0x000fe200000010ffULL, 0x000000083b2f7824ULL, 0x040fe200078e020eULL,
0x0000002d1818723eULL, 0x000fe200000010ffULL, 0x000000083b2d7824ULL, 0x040fe200078e020cULL,
0x000000291c1c723eULL, 0x000fe200000010ffULL, 0x000000083b297824ULL, 0x000fe200078e0208ULL,
0x000000313030723eULL, 0x000fe200000010ffULL, 0x000000103d047824ULL, 0x100fe200078e0202ULL,
0x0000003603007388ULL, 0x0005e20000000800ULL, 0x000000011e1b7824ULL, 0x040fe200078e021bULL,
0x0000001a1717723eULL, 0x000fe200000010ffULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x0000003407007388ULL, 0x0005e20000000800ULL, 0x000000011e1d7824ULL, 0x040fe200078e021dULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x0000001025257824ULL, 0x100fe200078e0202ULL,
0x0000003219007388ULL, 0x0005e20000000800ULL, 0x000000011e1f7824ULL, 0x040fe200078e021fULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000001027277824ULL, 0x100fe200078e0202ULL,
0x000000301b007388ULL, 0x0005e20000000800ULL, 0x000000011e217824ULL, 0x000fe200078e0221ULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x0000002e1d007388ULL, 0x0005e20000000800ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0x000000181f007388ULL, 0x0005e20000000800ULL, 0x000000102f2f7824ULL, 0x000fc400078e0202ULL,
0x000000011e047824ULL, 0x040fe200078e0204ULL, 0x0000001c21007388ULL, 0x0005e20000000800ULL,
0x000000011e027824ULL, 0x040fe400078e0223ULL, 0x000000011e067824ULL, 0x040fe200078e0225ULL,
0x0000001704007388ULL, 0x0005e20000000800ULL, 0x000000011e087824ULL, 0x040fe400078e0227ULL,
0x000000011e0a7824ULL, 0x040fe200078e0229ULL, 0x0000001502007388ULL, 0x0005e20000000800ULL,
0x000000011e0c7824ULL, 0x000fc400078e022bULL, 0x000000011e0e7824ULL, 0x040fe200078e022dULL,
0x0000001306007388ULL, 0x0005e20000000800ULL, 0x000000011e107824ULL, 0x040fe400078e022fULL,
0x000000011e127824ULL, 0x000fe200078e0239ULL, 0x0000001108007388ULL, 0x0005e80000000800ULL,
0x0000000f0a007388ULL, 0x0005e80000000800ULL, 0x0000000d0c007388ULL, 0x0005e80000000800ULL,
0x0000000b0e007388ULL, 0x0005e80000000800ULL, 0x0000000910007388ULL, 0x0005e80000000800ULL,
0x0000000512007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000147919ULL, 0x000ee20000002600ULL, 0x00000000000479c3ULL, 0x000f220000002700ULL,
0x0000580000057ab9ULL, 0x000fc40000000800ULL, 0x0000000000157919ULL, 0x004ea20000000000ULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x0000001014037824ULL, 0x008fc600078e00ffULL,
0x00000004050472a4ULL, 0x010fe2000f8e023fULL, 0x0000001014067824ULL, 0x040fe200078e00ffULL,
0x00000003ff027819ULL, 0x004fe20000011615ULL, 0x0000001014217824ULL, 0x000fe200078e00ffULL,
0x0000002015167810ULL, 0x040fe40007ffe0ffULL, 0x0000004015177810ULL, 0x040fe40007ffe0ffULL,
0x0000006015207810ULL, 0x000fe40007ffe0ffULL, 0xfffffff003047812ULL, 0x000fc400078ee202ULL,
0x00000003ff037819ULL, 0x000fe40000011616ULL, 0x00000003ff077819ULL, 0x000fe40000011617ULL,
0x00000003ff0a7819ULL, 0x000fe40000011620ULL, 0x0000000702027812ULL, 0x000fe400078e4815ULL,
0x0000000703057812ULL, 0x000fe400078e4816ULL, 0xfffffff006067812ULL, 0x000fc400078ee203ULL,
0x0000000707087812ULL, 0x000fe400078e4817ULL, 0x000000070a0b7812ULL, 0x000fe400078e4820ULL,
0x0ffffff802037812ULL, 0x000fe400078ef815ULL, 0x0ffffff805057812ULL, 0x000fe400078ef816ULL,
0x0ffffff808097812ULL, 0x000fe200078ef817ULL, 0x00000010030c7824ULL, 0x000fe200078e0200ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef820ULL, 0x0000001005057824ULL, 0x100fe200078e0200ULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001009097824ULL, 0x000fe200078e0200ULL,
0xfffffff0210a7812ULL, 0x000fe200078ee20aULL, 0x000000100b1c7824ULL, 0x000fe200078e0200ULL,
0x00a000000c0c7984ULL, 0x000ea20000000c00ULL, 0x0000001014007824ULL, 0x000fe200078e00ffULL,
0x00000007150b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00a0000005107984ULL, 0x0007220000000c00ULL, 0x00005a0004027a11ULL, 0x000fc400078048ffULL,
0xfffffff000007812ULL, 0x000fe200078ee207ULL, 0x00a0000009187984ULL, 0x000a620000000c00ULL,
0x00005b0004037a11ULL, 0x000fe400000f4c03ULL, 0x0000000717077812ULL, 0x000fe200078ec0ffULL,
0x00a000001c1c7984ULL, 0x000e620000000c00ULL, 0x0000000716057812ULL, 0x008fe400078ec0ffULL,
0x0000000400007c10ULL, 0x000fe4000ff3e0ffULL, 0x1ffffff805157812ULL, 0x000fc400078ef82cULL,
0x0000000406057c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040a0a7c10ULL, 0x000fe4000ff5e0ffULL,
0x1ffffff807177812ULL, 0x000fe200078ef82cULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x0000000720097812ULL, 0x020fe200078ec0ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x00005a0000067a11ULL, 0x000fc400078248ffULL, 0x00005a000a087a11ULL, 0x000fe400078448ffULL,
0x1ffffff80b0b7812ULL, 0x000fe400078ef82cULL, 0x00005b0005057a11ULL, 0x000fe400000f4c14ULL,
0x1ffffff809217812ULL, 0x000fe200078ef82cULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x00005b0000077a11ULL, 0x000fe400008f4c07ULL, 0x00005b000a097a11ULL, 0x000fe200010f4c23ULL,
0x0000001015047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x004fe6000c101d06ULL,
0x0000001017067825ULL, 0x000fe200078e0006ULL, 0x0000001004007986ULL, 0x010fe6000c101d06ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000001806007986ULL, 0x002fe8000c101d06ULL,
0x0000001c08007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff067624ULL, 0x002fe200078e00ffULL, 0x03ffffff5a007812ULL, 0x000fe200078ec0ffULL,
0x00006900ff077624ULL, 0x000fc400078e00ffULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x000000045b037824ULL, 0x000fe200078e0200ULL, 0x00000006062d7981ULL, 0x000368000c1e9900ULL,
0x000000580300720cULL, 0x000fe40003f06070ULL, 0x000000015b097810ULL, 0x000fd60007ffe0ffULL,
0x000000023e048824ULL, 0x000fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0203ULL,
0x0000600004048625ULL, 0x000fca00078e0017ULL, 0x0000000604028981ULL, 0x000362000c1e1900ULL,
0x0000002e0900720cULL, 0x000fe20003f06070ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000402a097824ULL, 0x000fe400078e00ffULL, 0x000000405a2c7824ULL, 0x000fd200078e00ffULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x002e620000000000ULL,
0x0000000409127e24ULL, 0x020fe2000f8e0202ULL, 0x000020005a157811ULL, 0x000fe200078e68ffULL,
0x00000100ff1a7424ULL, 0x000fe400078e00ffULL, 0x000001005b007824ULL, 0x000fca00078e022cULL,
0x0000000059097217ULL, 0x000fca0007800000ULL, 0x0000000109007824ULL, 0x000fe200078e0a00ULL,
0x00000002ff1f7819ULL, 0x102fe20000011610ULL, 0x0000001010217824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe40000011610ULL, 0x0000003f1f057812ULL, 0x040fe400078ec0ffULL,
0x000000081f0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000101f237810ULL, 0x000fe20007ffe0ffULL,
0x0000000112057824ULL, 0x000fe200078e0205ULL, 0x0000003021217812ULL, 0x000fe200078ec0ffULL,
0x000000040f147824ULL, 0x040fe200078e00ffULL, 0x0000003f0f077812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x0000003f230b7812ULL, 0x000fc400078ec0ffULL,
0x000000181f257810ULL, 0x040fe20007ffe0ffULL, 0x0000000112077824ULL, 0x000fe200078e0207ULL,
0x00000021040a7210ULL, 0x080fe20007f1e0ffULL, 0x0000000112087824ULL, 0x000fe200078e020bULL,
0x000000201f197810ULL, 0x000fe20007ffe0ffULL, 0x00005e0007067625ULL, 0x080fe200078e001aULL,
0x0000000313137812ULL, 0x000fe400078e4810ULL, 0x000000281f1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0605ULL, 0x0000003f25057812ULL, 0x000fe200078ec0ffULL,
0x00005e0008087625ULL, 0x000fe200078e001aULL, 0x00000021060c7210ULL, 0x000fc40007f1e0ffULL,
0x000000301f1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x0000002108087210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0607ULL,
0x0000003f19077812ULL, 0x000fe200078ec0ffULL, 0x00005e0005047625ULL, 0x000fe200078e001aULL,
0x000000001f00720cULL, 0x0c0fe40003f06070ULL, 0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0x00000021040e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000000f00720cULL, 0x000fe20003f26070ULL,
0x00005e0007067625ULL, 0x000fe200078e001aULL, 0x0ffffffc13047812ULL, 0x000fc400078ef810ULL,
0x000000002300720cULL, 0x080fe20003fa6070ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0605ULL,
0x0000003f1b057812ULL, 0x000fe200078ec0ffULL, 0x0000001004177824ULL, 0x000fe200078e0215ULL,
0x0000002106107210ULL, 0x000fe20007f7e0ffULL, 0x000000041d167824ULL, 0x000fe200078e00ffULL,
0xfffffffc14067812ULL, 0x000fe200078ee213ULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a177faeULL, 0x0003e2000c101c46ULL,
0x000000ffff117224ULL, 0x000fe200018e0607ULL, 0x000000002500720cULL, 0x000fe20003f86070ULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x000000001900720cULL, 0x000fc40003f66070ULL,
0x000000001b00720cULL, 0x080fe20003f46070ULL, 0x0000001006077824ULL, 0x000fe200078e0215ULL,
0x000000001f00720cULL, 0x080fe20003f06070ULL, 0x000000041b147824ULL, 0x000fe200078e00ffULL,
0xfffffffc16167812ULL, 0x000fe200078ee213ULL, 0x000000041f187824ULL, 0x000fe200078e00ffULL,
0x0000003f1d0b7812ULL, 0x042fe200078ec0ffULL, 0x000000000c077faeULL, 0x0003e2000c901c46ULL,
0x00000021040a7210ULL, 0x000fe20007fde0ffULL, 0x00000010161b7824ULL, 0x000fe200078e0215ULL,
0x000000001d00720cULL, 0x000fe20003f26070ULL, 0x0000000112047824ULL, 0x000fe200078e020bULL,
0xfffffffc14147812ULL, 0x000fe200078ee213ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0605ULL,
0xfffffffc18187812ULL, 0x000fe200078ee213ULL, 0x00005e0004047625ULL, 0x000fe200078e001aULL,
0x0000003f1f077812ULL, 0x002fc600078ec0ffULL, 0x0000000423007824ULL, 0x000fe200078e00ffULL,
0x0000002104047210ULL, 0x000fe20007fde0ffULL, 0x00000004250c7824ULL, 0x000fe400078e00ffULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0xfffffffc00007812ULL, 0x100fe200078ee213ULL,
0x0000000419127824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee213ULL,
0x00005e0007067625ULL, 0x000fc600078e001aULL, 0xfffffffc12127812ULL, 0x000fe200078ee213ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000002106067210ULL, 0x000fe20007fde0ffULL,
0x00000010000d7824ULL, 0x100fe400078e0215ULL, 0x000000100c137824ULL, 0x100fe400078e0215ULL,
0x0000001012177824ULL, 0x100fe200078e0215ULL, 0x00000000080d7faeULL, 0x0003e2000e901c46ULL,
0x0000001014197824ULL, 0x100fe400078e0215ULL, 0x0000001018157824ULL, 0x000fe200078e0215ULL,
0x000000000e137faeULL, 0x0003e2000e101c46ULL, 0x000000ffff077224ULL, 0x000fc600030e0607ULL,
0x0000000010177faeULL, 0x0003e8000d901c46ULL, 0x000000000a197faeULL, 0x0003e8000d101c46ULL,
0x00000000041b7faeULL, 0x0003e8000c901c46ULL, 0x0000000006157faeULL, 0x0003e2000c101c46ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x0000000409097e24ULL, 0x020fe2000f8e0202ULL, 0x000020005a0b7811ULL, 0x000fe200078e68ffULL,
0x00000100ff137424ULL, 0x000fe200078e00ffULL, 0x00000002ff047819ULL, 0x002fc40000011600ULL,
0x00000003ff057819ULL, 0x000fe40000011600ULL, 0x00000020040f7810ULL, 0x040fe40007ffe0ffULL,
0x0000002804117810ULL, 0x040fe40007ffe0ffULL, 0x0000003004157810ULL, 0x040fe40007ffe0ffULL,
0x0000003804177810ULL, 0x040fe40007ffe0ffULL, 0x0000003f04067812ULL, 0x000fc400078ec0ffULL,
0x0000003f0f107812ULL, 0x000fe200078ec0ffULL, 0x0000000417207824ULL, 0x000fe200078e00ffULL,
0x0000003f11147812ULL, 0x000fe400078ec0ffULL, 0x0000003f15187812ULL, 0x000fe200078ec0ffULL,
0x0000000109127824ULL, 0x000fe200078e0210ULL, 0x0000003f171c7812ULL, 0x000fe200078ec0ffULL,
0x0000000109167824ULL, 0x040fe200078e0214ULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000001091a7824ULL, 0x040fe200078e0218ULL, 0x00000010040a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001091e7824ULL, 0x040fe200078e021cULL, 0x00000018040d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109047824ULL, 0x000fe200078e0206ULL, 0x0000000305077812ULL, 0x100fe200078e4800ULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0000003f08067812ULL, 0x040fe200078ec0ffULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x0000003f0a0c7812ULL, 0x040fe200078ec0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x0000003f0d0e7812ULL, 0x040fe200078ec0ffULL,
0x000000040d107824ULL, 0x000fe200078e00ffULL, 0x0ffffffc07007812ULL, 0x000fe200078ef800ULL,
0x000000040f147824ULL, 0x000fe200078e00ffULL, 0xfffffffc08087812ULL, 0x100fe200078ee207ULL,
0x0000000411187824ULL, 0x000fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee207ULL,
0x00000004151c7824ULL, 0x000fe200078e00ffULL, 0x0000003005157812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0013ULL, 0xfffffffc10107812ULL, 0x000fc400078ee207ULL,
0xfffffffc14147812ULL, 0x100fe200078ee207ULL, 0x00000001090e7824ULL, 0x040fe200078e020eULL,
0xfffffffc18187812ULL, 0x100fe200078ee207ULL, 0x0000000109067824ULL, 0x040fe200078e0206ULL,
0xfffffffc1c1c7812ULL, 0x100fe200078ee207ULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0xfffffffc20207812ULL, 0x000fe200078ee207ULL, 0x0000001000177824ULL, 0x100fe200078e020bULL,
0x0000001504047210ULL, 0x000fe20007f1e0ffULL, 0x0000001008197824ULL, 0x100fe400078e020bULL,
0x000000100a1b7824ULL, 0x000fc400078e020bULL, 0x00000010101d7824ULL, 0x100fe400078e020bULL,
0x00000010141f7824ULL, 0x100fe400078e020bULL, 0x0000001018217824ULL, 0x100fe400078e020bULL,
0x000000101c237824ULL, 0x100fe400078e020bULL, 0x0000001020257824ULL, 0x000fe400078e020bULL,
0x00005e000e0a7625ULL, 0x000fc800078e0013ULL, 0x00005e0006067625ULL, 0x000fc800078e0013ULL,
0x00005e000c087625ULL, 0x000fe200078e0013ULL, 0x0000001506067210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000150a0a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e00120c7625ULL, 0x000fe200078e0013ULL, 0x0000001508087210ULL, 0x000fe40007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c46ULL,
0x00005e00160e7625ULL, 0x000fc800078e0013ULL, 0x00005e001a107625ULL, 0x000fc800078e0013ULL,
0x00005e001e127625ULL, 0x000fc800078e0013ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000150c0c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000150e0e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000001510107210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000001512127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000000006197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff117224ULL, 0x000fc400010e0611ULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x00000000081b7faeULL, 0x0003e8000b901c46ULL,
0x000000000a1d7faeULL, 0x0003e8000b901c46ULL, 0x000000000c1f7faeULL, 0x0003e8000b901c46ULL,
0x000000000e217faeULL, 0x0003e8000b901c46ULL, 0x0000000010237faeULL, 0x0003e8000b901c46ULL,
0x0000000012257faeULL, 0x0003e4000b901c46ULL, 0x01060400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000035a00780cULL, 0x000fda0003f04070ULL, 0x0000028000000947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x000000205a007824ULL, 0x002fc800078e0205ULL,
0x0000002000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000001e006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105097812ULL, 0x040fe400078efcffULL, 0x0000000705077812ULL, 0x100fe400078e7800ULL,
0x0000000709097812ULL, 0x100fe400078e7800ULL, 0x00000010050b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x040fe200078e0207ULL, 0x0000001105057810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0x000000070b0b7812ULL, 0x000fc400078e7800ULL,
0x0000000007107984ULL, 0x000e62000000cc00ULL, 0x0000000705057812ULL, 0x000fe400078e7800ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x00000000090c7984ULL, 0x000ea4000000cc00ULL,
0x0000000106057824ULL, 0x000fe400078e0205ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fe200078e0013ULL, 0x0000001407007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fca00078e000fULL,
0x0000001809007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x000000000b107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c0b007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01060400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000002e5b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000002f7919ULL, 0x000ea20000000000ULL, 0x00005800ff397624ULL, 0x000fe200078e00ffULL,
0x3d8000002d2d7820ULL, 0x000fe20000410000ULL, 0x000064003e3e7a24ULL, 0x000fe200078e02ffULL,
0xffffffff2e3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000105a3d7824ULL, 0x000fe200078e00ffULL,
0x00007610ff3a7816ULL, 0x000fe2000000003aULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x0000004039397824ULL, 0x000fe400078e00ffULL, 0x000001005b387824ULL, 0x000fe200078e022cULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000385900720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x028fea0003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e003bULL,
0x0000000000207805ULL, 0x002fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x0000000100247810ULL, 0x000fe20007ffe0ffULL,
0x00000bb000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e0000ULL,
0x000000013f3b7812ULL, 0x000fc400078e0cffULL, 0x00000002ff267819ULL, 0x100fe20000011624ULL,
0x000000ffff007224ULL, 0x000fe200078e0024ULL, 0x000000042400780cULL, 0x040fe40003f06070ULL,
0x0000000324487812ULL, 0x000fe200078ec0ffULL, 0x0000030026277a24ULL, 0x000fca00078e025bULL,
0x0000000127257810ULL, 0x000fc80007ffe0ffULL, 0x0000002e2500720cULL, 0x000fda0003f26070ULL,
0x000005e000009947ULL, 0x020fea0003800000ULL, 0x0000010027247824ULL, 0x000fe200078e022cULL,
0x00000002ff337819ULL, 0x004fe2000001162fULL, 0x00000004392a7e24ULL, 0x000fe4000f8e0202ULL,
0x0000000448267824ULL, 0x000fe200078e00ffULL, 0x0000002459257217ULL, 0x000fe20007800000ULL,
0x000000025a297824ULL, 0x000fe200078e023bULL, 0x0000000833277810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff327424ULL, 0x000fe200078e00ffULL, 0xfffffffc26357812ULL, 0x000fe200078ee22fULL,
0x0000000125287824ULL, 0x000fe200078e0a24ULL, 0x0000003f33257812ULL, 0x000fe200078ec0ffULL,
0x0000000427317824ULL, 0x040fe200078e00ffULL, 0x0000003f272b7812ULL, 0x000fc400078ec0ffULL,
0x00000003ff247819ULL, 0x000fe2000001162fULL, 0x000000012a257824ULL, 0x040fe200078e0225ULL,
0x000000283300720cULL, 0x000fe20003f26070ULL, 0x000000012a2b7824ULL, 0x000fe200078e022bULL,
0x0000000324307812ULL, 0x100fe200078e482fULL, 0x00005e0025247625ULL, 0x000fe200078e0032ULL,
0x000000282700720cULL, 0x000fe40003f46070ULL, 0x0000200029297811ULL, 0x000fe200078e60ffULL,
0x00005e002b267625ULL, 0x000fe200078e0032ULL, 0x0ffffffc30347812ULL, 0x000fc400078ef82fULL,
0xfffffffc31367812ULL, 0x000fe200078ee230ULL, 0x0000001035247825ULL, 0x000fe200078e0024ULL,
0x0000001033377810ULL, 0x040fe40007ffe0ffULL, 0x0000001833417810ULL, 0x040fe20007ffe0ffULL,
0x00000010342b7824ULL, 0x100fe200078e0229ULL, 0x0000002033437810ULL, 0x040fe20007ffe0ffULL,
0x0000001036317824ULL, 0x000fe200078e0229ULL, 0x0000002833457810ULL, 0x000fe20007ffe0ffULL,
0x0000001035267825ULL, 0x000fe200078e0026ULL, 0x0000003033477810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000c901c46ULL,
0x0000003833497810ULL, 0x000fc40007ffe0ffULL, 0x000000283700720cULL, 0x080fe20003f26070ULL,
0x0000000026317faeULL, 0x0005e2000d101c46ULL, 0x000000284100720cULL, 0x080fe40003f46070ULL,
0x000000284300720cULL, 0x080fe40003f66070ULL, 0x000000284500720cULL, 0x080fe40003f86070ULL,
0x000000284700720cULL, 0x080fe40003fa6070ULL, 0x0000003f37257812ULL, 0x042fe200078ec0ffULL,
0x0000000437377824ULL, 0x000fe200078e00ffULL, 0x0000003f432b7812ULL, 0x040fe200078ec0ffULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0x0000003f41277812ULL, 0x044fe200078ec0ffULL,
0x0000000441417824ULL, 0x000fe200078e00ffULL, 0x0000003f45317812ULL, 0x040fe200078ec0ffULL,
0x0000000445457824ULL, 0x000fe200078e00ffULL, 0x0000003f47337812ULL, 0x040fe200078ec0ffULL,
0x0000000447477824ULL, 0x000fe200078e00ffULL, 0x0000003f494b7812ULL, 0x040fe200078ec0ffULL,
0x000000012a257824ULL, 0x040fe200078e0225ULL, 0x000000284900720cULL, 0x040fe20003fc6070ULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0xfffffffc37247812ULL, 0x100fe200078ee230ULL,
0x000000012a277824ULL, 0x040fe200078e0227ULL, 0xfffffffc41267812ULL, 0x100fe200078ee230ULL,
0x000000012a2b7824ULL, 0x040fe200078e022bULL, 0xfffffffc43287812ULL, 0x100fe200078ee230ULL,
0x000000012a317824ULL, 0x040fe200078e0231ULL, 0xfffffffc47347812ULL, 0x000fe200078ee230ULL,
0x000000012a337824ULL, 0x000fc400078e0233ULL, 0x000000012a4b7824ULL, 0x000fe200078e024bULL,
0xfffffffc452a7812ULL, 0x100fe200078ee230ULL, 0x0000001024377824ULL, 0x100fe200078e0229ULL,
0xfffffffc49307812ULL, 0x000fe200078ee230ULL, 0x0000001026417824ULL, 0x000fe400078e0229ULL,
0x00005e0025247625ULL, 0x000fc800078e0032ULL, 0x0000001028437824ULL, 0x100fe400078e0229ULL,
0x000000102a457824ULL, 0x100fe400078e0229ULL, 0x0000001034477824ULL, 0x100fe400078e0229ULL,
0x0000001030497824ULL, 0x000fe400078e0229ULL, 0x00005e0027267625ULL, 0x000fc800078e0032ULL,
0x00005e002b287625ULL, 0x000fc800078e0032ULL, 0x00005e00312a7625ULL, 0x000fc800078e0032ULL,
0x00005e0033307625ULL, 0x000fc800078e0032ULL, 0x00005e004b327625ULL, 0x000fc800078e0032ULL,
0x0000001035247825ULL, 0x000fc800078e0024ULL, 0x0000001035267825ULL, 0x040fe200078e0026ULL,
0x0000000024377faeULL, 0x0003e6000c901c46ULL, 0x0000001035287825ULL, 0x040fe200078e0028ULL,
0x0000000026417faeULL, 0x0003e6000d101c46ULL, 0x00000010352a7825ULL, 0x040fe200078e002aULL,
0x0000000028437faeULL, 0x0003e6000d901c46ULL, 0x0000001035307825ULL, 0x040fe200078e0030ULL,
0x000000002a457faeULL, 0x0003e6000e101c46ULL, 0x0000001035327825ULL, 0x000fe200078e0032ULL,
0x0000000030477faeULL, 0x0003e8000e901c46ULL, 0x0000000032497faeULL, 0x0003e2000f101c46ULL,
0x0000052000007947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x004fe2000001162fULL,
0x0000000439257e24ULL, 0x000fc4000f8e0202ULL, 0x00000100ff377424ULL, 0x000fe200078e00ffULL,
0x0000000824277810ULL, 0x040fe40007ffe0ffULL, 0x0000001024297810ULL, 0x040fe40007ffe0ffULL,
0x00000018242b7810ULL, 0x040fe40007ffe0ffULL, 0x0000002024317810ULL, 0x040fe20007ffe0ffULL,
0x0000000429457824ULL, 0x000fe200078e00ffULL, 0x0000002824337810ULL, 0x040fe20007ffe0ffULL,
0x000000042b477824ULL, 0x000fe200078e00ffULL, 0x0000003024357810ULL, 0x040fe20007ffe0ffULL,
0x0000000431497824ULL, 0x000fe200078e00ffULL, 0x0000003824437810ULL, 0x040fe20007ffe0ffULL,
0x00000004334b7824ULL, 0x000fe200078e00ffULL, 0x0000003f24267812ULL, 0x000fe200078ec0ffULL,
0x00000004354f7824ULL, 0x000fe200078e00ffULL, 0x0000003f27247812ULL, 0x000fe200078ec0ffULL,
0x0000000443517824ULL, 0x000fe200078e00ffULL, 0x0000003f29287812ULL, 0x000fe200078ec0ffULL,
0x0000000125267824ULL, 0x000fe200078e0226ULL, 0x0000003f2b2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000125307824ULL, 0x000fe200078e0224ULL, 0x0000003f31367812ULL, 0x000fe200078ec0ffULL,
0x0000000125327824ULL, 0x000fe200078e0228ULL, 0x0000003f33427812ULL, 0x000fe200078ec0ffULL,
0x0000000125347824ULL, 0x000fe200078e022aULL, 0x0000003f35447812ULL, 0x000fe200078ec0ffULL,
0x0000000125367824ULL, 0x000fe200078e0236ULL, 0x0000003f43467812ULL, 0x000fe200078ec0ffULL,
0x0000000125427824ULL, 0x040fe200078e0242ULL, 0x00000003ff247819ULL, 0x000fe2000001162fULL,
0x0000000125447824ULL, 0x000fc400078e0244ULL, 0x0000000125467824ULL, 0x000fe400078e0246ULL,
0x0000000448287824ULL, 0x000fe400078e00ffULL, 0x000000025a257824ULL, 0x000fc600078e023bULL,
0xfffffffc28417812ULL, 0x100fe400078ee22fULL, 0x00002000252a7811ULL, 0x000fe200078e60ffULL,
0x0000000427257824ULL, 0x000fe200078e00ffULL, 0x0000000324287812ULL, 0x000fc800078e482fULL,
0x0ffffffc28277812ULL, 0x000fe400078ef82fULL, 0xfffffffc25297812ULL, 0x100fe200078ee228ULL,
0x00005e0026247625ULL, 0x080fe200078e0037ULL, 0xfffffffc452b7812ULL, 0x100fe400078ee228ULL,
0xfffffffc47317812ULL, 0x000fe200078ee228ULL, 0x0000001027437824ULL, 0x000fe200078e022aULL,
0xfffffffc49337812ULL, 0x000fe200078ee228ULL, 0x0000001029457824ULL, 0x000fe200078e022aULL,
0xfffffffc4b357812ULL, 0x100fe200078ee228ULL, 0x00005e0030267625ULL, 0x000fe200078e0037ULL,
0xfffffffc4f4f7812ULL, 0x000fc400078ee228ULL, 0xfffffffc51517812ULL, 0x000fe200078ee228ULL,
0x000000102b477824ULL, 0x100fe400078e022aULL, 0x0000001031497824ULL, 0x100fe400078e022aULL,
0x00000010334b7824ULL, 0x100fe400078e022aULL, 0x00000010354d7824ULL, 0x100fe400078e022aULL,
0x000000104f4f7824ULL, 0x100fe400078e022aULL, 0x0000001051517824ULL, 0x000fc400078e022aULL,
0x00005e0032287625ULL, 0x000fc800078e0037ULL, 0x00005e00342a7625ULL, 0x000fc800078e0037ULL,
0x00005e0036307625ULL, 0x000fc800078e0037ULL, 0x00005e0042327625ULL, 0x000fc800078e0037ULL,
0x0000001041247825ULL, 0x000fc800078e0024ULL, 0x00005e0044347625ULL, 0x080fe200078e0037ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024437faeULL, 0x0003e6000b901c46ULL,
0x00005e0046367625ULL, 0x000fc800078e0037ULL, 0x0000001041267825ULL, 0x000fc800078e0026ULL,
0x0000001041287825ULL, 0x040fe200078e0028ULL, 0x0000000026457faeULL, 0x0003e6000b901c46ULL,
0x00000010412a7825ULL, 0x040fe200078e002aULL, 0x0000000028477faeULL, 0x0003e6000b901c46ULL,
0x0000001041307825ULL, 0x040fe200078e0030ULL, 0x000000002a497faeULL, 0x0003e6000b901c46ULL,
0x0000001041327825ULL, 0x040fe200078e0032ULL, 0x00000000304b7faeULL, 0x0003e6000b901c46ULL,
0x0000001041347825ULL, 0x040fe200078e0034ULL, 0x00000000324d7faeULL, 0x0003e6000b901c46ULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0x00000000344f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000034800780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x00000004ff257424ULL, 0x002fe400078e00ffULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x0000030025037a24ULL, 0x000fca00078e0203ULL,
0x000000580300720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x000000023e247824ULL, 0x000fc800078e0203ULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x0000000624027981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000840447824ULL, 0x000fe400078e00ffULL,
0x000000ffff437224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff82f247812ULL, 0x000fe200078ec0ffULL, 0x000000025a287824ULL, 0x000fe200078e023fULL,
0x00000001432b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000724247812ULL, 0x000fe400078ef82fULL, 0x0000200028287811ULL, 0x000fc400078e60ffULL,
0x00000001ff257819ULL, 0x000fe40000011624ULL, 0x000000072fd07812ULL, 0x000fe400078ec0ffULL,
0x0000000325267812ULL, 0x000fe400078ec0ffULL, 0x00000008d0cf7812ULL, 0x000fe400078ef82fULL,
0x0000004326257212ULL, 0x040fe400078e3cffULL, 0x0000002b26277212ULL, 0x000fc600078e3cffULL,
0x0000000424257824ULL, 0x040fe400078e0225ULL, 0x0000000424277824ULL, 0x000fe200078e0227ULL,
0x000000202f247810ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x100fe400078e0228ULL,
0x0000001027277824ULL, 0x000fe200078e0228ULL, 0xfffffff824247812ULL, 0x000fe400078ec0ffULL,
0x000000002534783bULL, 0x0002a40000000200ULL, 0x0000000724297812ULL, 0x000fc400078ef82fULL,
0x000000002730783bULL, 0x000ee40000000200ULL, 0x00000001ff247819ULL, 0x000fc80000011629ULL,
0x00000003242a7812ULL, 0x000fc800078ec0ffULL, 0x000000432a247212ULL, 0x040fe400078e3cffULL,
0x0000002b2a2a7212ULL, 0x000fe400078e3cffULL, 0x0000000243437810ULL, 0x000fe20007ffe0ffULL,
0x0000000429257824ULL, 0x042fe400078e0224ULL, 0x0000000429297824ULL, 0x000fe400078e022aULL,
0x0000001025257824ULL, 0x100fe400078e0228ULL, 0x0000001029297824ULL, 0x000fc800078e0228ULL,
0x000000002524783bULL, 0x000e680000000200ULL, 0x000000002928783bULL, 0x000f220000000200ULL,
0x0000003400747306ULL, 0x004fe20000009400ULL, 0x00000018ffab7819ULL, 0x000fe20000011434ULL,
0x0001000034607824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe20000011435ULL,
0x0000010036af7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011436ULL,
0x0001000037ae7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe20000011460ULL,
0x0000003400b37306ULL, 0x000ea20000005400ULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000010037aa7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011437ULL,
0x00010000307b7824ULL, 0x048fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x00010000317e7824ULL, 0x040fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x00000034005f7306ULL, 0x000722000000d400ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000010030807824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000010031817824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011430ULL,
0x00000100326d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x000000b200b47306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x008fe200078e00ffULL,
0x000000b37400720bULL, 0x004fe20003f9d000ULL, 0x0001000032757824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011432ULL, 0x0001000024c87824ULL, 0x002fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe20000011434ULL, 0x0001000035347824ULL, 0x000fe200078e00ffULL,
0x000000b200b57306ULL, 0x000e620000205400ULL, 0x00000018ff9c7819ULL, 0x000fc40000011424ULL,
0x00000018ffc87819ULL, 0x000fe400000114c8ULL, 0x00000018ffbb7819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fe200078e00ffULL, 0x000000015f5f4812ULL, 0x010fe200078efcffULL,
0x000000b600b77306ULL, 0x000fe20000209400ULL, 0x00000018ff997819ULL, 0x000fe40000011425ULL,
0x00000018ffc17819ULL, 0x000fe40000011434ULL, 0x00000018ff967819ULL, 0x000fc40000011426ULL,
0x00000018ff877819ULL, 0x000fe20000011427ULL, 0x000000b600b87306ULL, 0x000ea20000205400ULL,
0x000000b5b400720bULL, 0x002fe20003f5d000ULL, 0x0000010027b57824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011431ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x0000003500a77306ULL, 0x000fe20000009400ULL,
0x00000018ff6d7819ULL, 0x000fc4000001146dULL, 0x00000018ff4c7819ULL, 0x000fe40000011433ULL,
0x00000018ff757819ULL, 0x000fc60000011475ULL, 0x0000003500a47306ULL, 0x000e620000005400ULL,
0x000000b8b700720bULL, 0x004fce0003f7d000ULL, 0x00000035005e7306ULL, 0x0004f0000000d400ULL,
0x000000ab00b97306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x004fe200078e00ffULL,
0x000000a4a700720bULL, 0x002fc40003f3d000ULL, 0x000000b600a77245ULL, 0x000fe4000020d400ULL,
0x00000018ffbe7819ULL, 0x000fe40000011435ULL, 0x000000ab00ba7306ULL, 0x000e620000205400ULL,
0x000000b200a47245ULL, 0x000fe4000020d400ULL, 0x00000001a7a73812ULL, 0x000fe400078efcffULL,
0x00000001a4a42812ULL, 0x000fe400078efcffULL, 0x000000015e5e1812ULL, 0x008fe200078efcffULL,
0x000000bb00bc7306ULL, 0x000ff00000209400ULL, 0x000000bb00bd7306ULL, 0x000ea20000205400ULL,
0x000000bab900720bULL, 0x002fce0003fdd000ULL, 0x000000a300ad7306ULL, 0x000ff00000209400ULL,
0x000000a300ac7306ULL, 0x000e620000205400ULL, 0x000000bdbc00720bULL, 0x004fce0003fbd000ULL,
0x000000be00bf7306ULL, 0x000ff00000209400ULL, 0x000000be00c07306ULL, 0x000ea20000205400ULL,
0x000000acad00720bULL, 0x002fe20003f9d000ULL, 0x0001000026ac7824ULL, 0x000fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x0000003600a57306ULL, 0x000ff00000009400ULL,
0x0000003600a67306ULL, 0x000e620000005400ULL, 0x000000c0bf00720bULL, 0x004fce0003f7d000ULL,
0x0000003700a17306ULL, 0x000ff00000009400ULL, 0x0000003700a27306ULL, 0x000ea20000005400ULL,
0x000000a6a500720bULL, 0x002fe40003f5d000ULL, 0x000000ab00a67245ULL, 0x000fc4000020d400ULL,
0x000000bb00a57245ULL, 0x000fe4000020d400ULL, 0x00000001a6a66812ULL, 0x000fe200078efcffULL,
0x00000030009d7306ULL, 0x000fe20000009400ULL, 0x00000001a5a55812ULL, 0x000fc800078efcffULL,
0x0000005ea55e723eULL, 0x000fc600000010ffULL, 0x0000003000a07306ULL, 0x000e620000005400ULL,
0x000000a2a100720bULL, 0x004fe40003fdd000ULL, 0x000000be00a17245ULL, 0x000fe4000020d400ULL,
0x0000009300a27245ULL, 0x000fe4000020d400ULL, 0x00000001a1a13812ULL, 0x000fe200078efcffULL,
0x000000c100c27306ULL, 0x000ff00000209400ULL, 0x000000c100c37306ULL, 0x000ea20000205400ULL,
0x000000a09d00720bULL, 0x002fe20003f3d000ULL, 0x00000100269d7824ULL, 0x000fe200078e00ffULL,
0x000000a300a07245ULL, 0x000fe2000020d400ULL, 0x0001000027a37824ULL, 0x000fc600078e00ffULL,
0x00000001a0a04812ULL, 0x000fe200078efcffULL, 0x00000093009f7306ULL, 0x000fe20000209400ULL,
0x00000018ffa37819ULL, 0x000fce00000114a3ULL, 0x00000093009e7306ULL, 0x000e620000205400ULL,
0x000000c3c200720bULL, 0x004fce0003fbd000ULL, 0x000000af00c47306ULL, 0x000ff00000209400ULL,
0x000000af00c57306ULL, 0x0004e20000205400ULL, 0x0000009e9f00720bULL, 0x002fe40003f9d000ULL,
0x000000c1009e7245ULL, 0x000fc4000020d400ULL, 0x00000018ff9f7819ULL, 0x000fe4000001149dULL,
0x000000019e9e5812ULL, 0x000fe200078efcffULL, 0x00000024008d7306ULL, 0x000fe20000009400ULL,
0x000000af009d7245ULL, 0x000fe4000020d400ULL, 0x0000008800af7245ULL, 0x004fc6000020d400ULL,
0x00000001a2a24812ULL, 0x000fe400078efcffULL, 0x0000002400947306ULL, 0x000fe20000005400ULL,
0x000000c5c400720bULL, 0x008fce0003f7d000ULL, 0x0000002400527306ULL, 0x0003ec000000d400ULL,
0x000000019d9d3812ULL, 0x000fe400078efcffULL, 0x0000003600577306ULL, 0x0004e2000000d400ULL,
0x0000010024247824ULL, 0x002fca00078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x000fe200078e00ffULL, 0x0000008800957306ULL, 0x000fe20000209400ULL,
0x0000010033367824ULL, 0x004fc600078e00ffULL, 0x00000018ffce7819ULL, 0x000fe40000011424ULL,
0x000000442f247211ULL, 0x000fe400078fe0ffULL, 0x0000008800927306ULL, 0x000e620000205400ULL,
0x0000000157572812ULL, 0x008fe400078efcffULL, 0x0000000224747810ULL, 0x040fe40007ffe0ffULL,
0x0000000724247812ULL, 0x100fe400078e78cfULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x000000ae00c67306ULL, 0x000fe20000209400ULL, 0x0000000774747812ULL, 0x000fe200078e78cfULL,
0x00000020cf247824ULL, 0x000fe200078e0224ULL, 0x0000000444447810ULL, 0x000fc60007ffe0ffULL,
0x0000001024247824ULL, 0x000fe400078e00ffULL, 0x000000ae00c77306ULL, 0x0004e20000205400ULL,
0x000000929500720bULL, 0x002fe20003f5d000ULL, 0x00000020cf747824ULL, 0x000fcc00078e0274ULL,
0x000000aa00b17306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x004fca000020d400ULL,
0x00000001afaf2812ULL, 0x000fe400078efcffULL, 0x000000aa00b07306ULL, 0x0002a20000205400ULL,
0x000000c7c600720bULL, 0x008fce0003fbd000ULL, 0x000000c800c97306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fca000020d400ULL, 0x00000001aeae5812ULL, 0x000fe400078efcffULL,
0x000000c800ca7306ULL, 0x000e620000205400ULL, 0x000000b0b100720bULL, 0x004fe40003f7d000ULL,
0x000000948d00720bULL, 0x000fe40003fbd000ULL, 0x000000c8008d7245ULL, 0x000fc6000020d400ULL,
0x0000003700537306ULL, 0x0004ec000000d400ULL, 0x00000001aaaa3812ULL, 0x000fe400078efcffULL,
0x0000009c00a97306ULL, 0x000fe20000209400ULL, 0x000000cac900720bULL, 0x002fe20003f9d000ULL,
0x0001000033377824ULL, 0x004fe200078e00ffULL, 0x0000000152525812ULL, 0x000fc400078efcffULL,
0x000000aaafaf723eULL, 0x000fe400000010ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000009c00a87306ULL, 0x0002a20000205400ULL, 0x0000000153536812ULL, 0x008fc800078efcffULL,
0x00000053aeae723eULL, 0x000fe400000010ffULL, 0x000000018d8d4812ULL, 0x000fe200078efcffULL,
0x000000ce00b37306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fe4000020d400ULL,
0x000000528d52723eULL, 0x000fca00000010ffULL, 0x000000ce00b47306ULL, 0x000e620000205400ULL,
0x000000a8a900720bULL, 0x004fce0003fdd000ULL, 0x00000025008e7306ULL, 0x000fec0000009400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x0000002500897306ULL, 0x000ea20000005400ULL,
0x000000b4b300720bULL, 0x002fce0003f5d000ULL, 0x000000cb00cc7306ULL, 0x000ff00000209400ULL,
0x000000cb00cd7306ULL, 0x0002e20000205400ULL, 0x000000898e00720bULL, 0x004fe40003f9d000ULL,
0x000000ce008e7245ULL, 0x000fc8000020d400ULL, 0x000000018e8e2812ULL, 0x000fe200078efcffULL,
0x00000099009a7306ULL, 0x000fe20000209400ULL, 0x000000cb00cb7245ULL, 0x002fce000020d400ULL,
0x00000099009b7306ULL, 0x0002a20000205400ULL, 0x000000cdcc00720bULL, 0x008fce0003f7d000ULL,
0x0000002600857306ULL, 0x000fe20000009400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x00000001cbcb3812ULL, 0x000fe400078efcffULL, 0x0000002600867306ULL, 0x000e620000005400ULL,
0x0000009b9a00720bULL, 0x004fe40003fdd000ULL, 0x000000cb9c53723eULL, 0x000fca00000010ffULL,
0x00000026004b7306ULL, 0x000eac000000d400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x000000ac00ad7306ULL, 0x000fe20000209400ULL, 0x000000868500720bULL, 0x002fe40003f7d000ULL,
0x00000018ff857819ULL, 0x000fca000001142aULL, 0x000000ac00267306ULL, 0x000e6c0000205400ULL,
0x000000014b4b3812ULL, 0x004fe400078efcffULL, 0x0000002500517306ULL, 0x0004f0000000d400ULL,
0x0000002700797306ULL, 0x000fe20000009400ULL, 0x0000010025257824ULL, 0x004fe200078e00ffULL,
0x00000026ad00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000027007a7306ULL, 0x000fe20000005400ULL, 0x0000000151514812ULL, 0x008fe400078efcffULL,
0x0000002500887245ULL, 0x000fe4000020d400ULL, 0x000000518e8e723eULL, 0x000fc600000010ffULL,
0x00000027004a7306ULL, 0x000ff0000000d400ULL, 0x0000009f00277306ULL, 0x000ff00000209400ULL,
0x0000009f00927306ULL, 0x000e700000205400ULL, 0x000000a300937306ULL, 0x000ff00000209400ULL,
0x000000a300947306ULL, 0x0004e20000205400ULL, 0x000000922700720bULL, 0x002fc40003f9d000ULL,
0x000000ac00927245ULL, 0x000fc8000020d400ULL, 0x0000000192922812ULL, 0x000fe200078efcffULL,
0x000000b500897306ULL, 0x000fe20000209400ULL, 0x0000007a7900720bULL, 0x000fe40003f5d000ULL,
0x000000a300a37245ULL, 0x004fe4000020d400ULL, 0x0000009f007a7245ULL, 0x000fe4000020d400ULL,
0x0000004b9292723eULL, 0x000fe200000010ffULL, 0x000000b500267306ULL, 0x0002a20000205400ULL,
0x000000949300720bULL, 0x008fc40003fdd000ULL, 0x000000017a7a4812ULL, 0x000fe400078efcffULL,
0x0000009600937245ULL, 0x000fe4000020d400ULL, 0x000000014a4a2812ULL, 0x000fe200078efcffULL,
0x0000002500b27306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x0000002500ab7306ULL, 0x0002e20000205400ULL,
0x000000268900720bULL, 0x004fe20003f7d000ULL, 0x0001000028897824ULL, 0x000fe200078e00ffULL,
0x0000004aa34a723eULL, 0x000fc800000010ffULL, 0x00000018ff897819ULL, 0x000fe20000011489ULL,
0x0000008700907306ULL, 0x000fe20000209400ULL, 0x000000002424783bULL, 0x002e6a0000000200ULL,
0x00000001b5b53812ULL, 0x000fe400078efcffULL, 0x0000008700917306ULL, 0x000ea20000205400ULL,
0x000000abb200720bULL, 0x008fce0003fbd000ULL, 0x0000007b008c7306ULL, 0x000fec0000209400ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x0000007b008f7306ULL, 0x000ee20000205400ULL,
0x000000919000720bULL, 0x004fce0003fdd000ULL, 0x0000003000497306ULL, 0x000530000000d400ULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000008f8c00720bULL, 0x008fe20003f5d000ULL,
0x000000ae2414723cULL, 0x002fe20000041814ULL, 0x00000018ff307819ULL, 0x004fc40000011428ULL,
0x00000088998f723eULL, 0x000fc600000010ffULL, 0x0000007e00827306ULL, 0x000e620000205400ULL,
0x0000000149491812ULL, 0x010fe200078efcffULL, 0x000000522410723cULL, 0x040fec0000041810ULL,
0x0000003100737306ULL, 0x000fe40000009400ULL, 0x0000008e240c723cULL, 0x000fec000004180cULL,
0x0000003100767306ULL, 0x000ea20000005400ULL, 0x000000827f00720bULL, 0x002fe20003f3d000ULL,
0x00000100297f7824ULL, 0x000fc400078e00ffULL, 0x000001002a827824ULL, 0x000fc600078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x00000080008b7306ULL, 0x000fe20000209400ULL,
0x00000018ff827819ULL, 0x000fce0000011482ULL, 0x00000080008a7306ULL, 0x000e620000205400ULL,
0x000000767300720bULL, 0x004fe40003f9d000ULL, 0x0000008700767245ULL, 0x000fe4000020d400ULL,
0x00000018ff737819ULL, 0x000fe4000001142bULL, 0x0000000176766812ULL, 0x000fe200078efcffULL,
0x0000009600987306ULL, 0x000fe60000209400ULL, 0x000000b5764b723eULL, 0x000fca00000010ffULL,
0x0000009600977306ULL, 0x000ea20000205400ULL, 0x0000008a8b00720bULL, 0x002fe20003f7d000ULL,
0x0000004a2404723cULL, 0x000fe20000041804ULL, 0x0000007b008a7245ULL, 0x000fe4000020d400ULL,
0x00000080008b7245ULL, 0x000fe2000020d400ULL, 0x000100002a807824ULL, 0x000fe200078e00ffULL,
0x000000018a8a2812ULL, 0x000fe200078efcffULL, 0x0000003300627306ULL, 0x000fe60000009400ULL,
0x00000018ff807819ULL, 0x000fc40000011480ULL, 0x000000498a8a723eULL, 0x000fe400000010ffULL,
0x000000018b8b3812ULL, 0x000fe200078efcffULL, 0x0000003300637306ULL, 0x000e620000005400ULL,
0x000000979800720bULL, 0x004fce0003fbd000ULL, 0x0000006600677306ULL, 0x000fec0000209400ULL,
0x0000000193935812ULL, 0x000fe400078efcffULL, 0x00000066006a7306ULL, 0x0004e20000205400ULL,
0x000000636200720bULL, 0x002fe20003fdd000ULL, 0x0001000029627824ULL, 0x000fe200078e00ffULL,
0x0000007e00637245ULL, 0x000fc4000020d400ULL, 0x0000007a9393723eULL, 0x000fe400000010ffULL,
0x0000000163631812ULL, 0x000fe200078efcffULL, 0x00000056006c7306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x004fc6000020d400ULL, 0x000000922408723cULL, 0x000fe80000041808ULL,
0x0000005600697306ULL, 0x0002a20000205400ULL, 0x0000006a6700720bULL, 0x008fce0003f5d000ULL,
0x0000003200727306ULL, 0x000fe20000009400ULL, 0x0000005600567245ULL, 0x002fca000020d400ULL,
0x0000000166662812ULL, 0x000fe400078efcffULL, 0x0000003200717306ULL, 0x000e620000005400ULL,
0x000000696c00720bULL, 0x004fe40003f3d000ULL, 0x0000008b668b723eULL, 0x000fca00000010ffULL,
0x0000006400687306ULL, 0x000fec0000209400ULL, 0x0000000156561812ULL, 0x000fe400078efcffULL,
0x0000006400657306ULL, 0x0004e20000205400ULL, 0x000000717200720bULL, 0x002fce0003fbd000ULL,
0x0000003600607306ULL, 0x000fe20000209400ULL, 0x0000006400647245ULL, 0x004fce000020d400ULL,
0x0000003600617306ULL, 0x0002a20000205400ULL, 0x000000656800720bULL, 0x008fe40003f5d000ULL,
0x00000018ff687819ULL, 0x000fe40000011462ULL, 0x0000007500627245ULL, 0x000fc6000020d400ULL,
0x0000008100837306ULL, 0x000fe20000209400ULL, 0x0000003600367245ULL, 0x002fca000020d400ULL,
0x0000000164642812ULL, 0x000fe400078efcffULL, 0x0000008100847306ULL, 0x0002e20000205400ULL,
0x000000616000720bULL, 0x004fce0003f3d000ULL, 0x0000003200477306ULL, 0x000ea2000000d400ULL,
0x0000008100817245ULL, 0x002fca000020d400ULL, 0x0000000136361812ULL, 0x000fe400078efcffULL,
0x00000037006f7306ULL, 0x000fe20000209400ULL, 0x000000848300720bULL, 0x008fe20003f7d000ULL,
0x000100002b837824ULL, 0x040fe400078e00ffULL, 0x000001002b847824ULL, 0x000fc600078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0000003700707306ULL, 0x0002e20000205400ULL,
0x0000000147475812ULL, 0x004fe400078efcffULL, 0x00000018ff847819ULL, 0x000fc60000011484ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000006d00777306ULL, 0x000fe20000209400ULL,
0x0000003700377245ULL, 0x002fe4000020d400ULL, 0x000000816449723eULL, 0x000fe400000010ffULL,
0x0000008200817245ULL, 0x000fc6000020d400ULL, 0x0000006d00787306ULL, 0x0002a20000205400ULL,
0x000000706f00720bULL, 0x008fce0003fbd000ULL, 0x0000003100487306ULL, 0x000722000000d400ULL,
0x0000006d006d7245ULL, 0x002fca000020d400ULL, 0x0000000137375812ULL, 0x000fe400078efcffULL,
0x00000028005d7306ULL, 0x000fe20000009400ULL, 0x00000018ff317819ULL, 0x008fe40000011429ULL,
0x000000787700720bULL, 0x004fca0003f5d000ULL, 0x00000028005c7306ULL, 0x000fe20000005400ULL,
0x0000000148484812ULL, 0x010fc800078efcffULL, 0x000000486348723eULL, 0x000fc600000010ffULL,
0x0000002800467306ULL, 0x0003e2000000d400ULL, 0x000000016d6d2812ULL, 0x000fc800078efcffULL,
0x0000006d5663723eULL, 0x000fc600000010ffULL, 0x0000004c006b7306ULL, 0x000fe20000209400ULL,
0x0000010028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011428ULL,
0x0000004c006e7306ULL, 0x000e620000205400ULL, 0x0000005fa428723eULL, 0x000fe400000010ffULL,
0x000000a1a05f723eULL, 0x000fca00000010ffULL, 0x00000089007b7306ULL, 0x000fe40000209400ULL,
0x0000005e241c723cULL, 0x000fec000004181cULL, 0x00000089006a7306ULL, 0x0004e20000205400ULL,
0x0000006e6b00720bULL, 0x002fce0003f9d000ULL, 0x00000075007c7306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x004fce000020d400ULL, 0x00000075007d7306ULL, 0x000e620000205400ULL,
0x0000006a7b00720bULL, 0x008fce0003f3d000ULL, 0x0000002900557306ULL, 0x000fec0000009400ULL,
0x0000000189891812ULL, 0x000fe400078efcffULL, 0x0000002900547306ULL, 0x000ea20000005400ULL,
0x0000007d7c00720bULL, 0x002fce0003f7d000ULL, 0x0000002900457306ULL, 0x0002ec000000d400ULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x0000002a004e7306ULL, 0x000fe20000009400ULL,
0x000000a7a629723eULL, 0x002fe400000010ffULL, 0x000000545500720bULL, 0x004fc40003f5d000ULL,
0x0000005c5d00720bULL, 0x000fe40003f7d000ULL, 0x000000476262723eULL, 0x000fe200000010ffULL,
0x0000002a004d7306ULL, 0x000e620000005400ULL, 0x000000282420723cULL, 0x000fee0000041820ULL,
0x00000067007e7306ULL, 0x000fe20000209400ULL, 0x000000579e28723eULL, 0x000fc400000010ffULL,
0x0000009da229723eULL, 0x000fe400000010ffULL, 0x0000000146463812ULL, 0x000fe400078efcffULL,
0x0000000145452812ULL, 0x008fe200078efcffULL, 0x0000006700657306ULL, 0x0004e20000205400ULL,
0x0000004d4e00720bULL, 0x002fe20003fbd000ULL, 0x000000282418723cULL, 0x000fe20000041818ULL,
0x0000004c004d7245ULL, 0x000fe4000020d400ULL, 0x000000468946723eULL, 0x000fc400000010ffULL,
0x000000014d4d4812ULL, 0x000fe200078efcffULL, 0x0000003000347306ULL, 0x000fe20000209400ULL,
0x0000001074287824ULL, 0x000fe200078e00ffULL, 0x0000006700677245ULL, 0x004fe4000020d400ULL,
0x0000003100267245ULL, 0x000fe4000020d400ULL, 0x000000364d25723eULL, 0x000fe400000010ffULL,
0x0000003000357306ULL, 0x0002a20000205400ULL, 0x000000657e00720bULL, 0x008fce0003f9d000ULL,
0x0000003300407306ULL, 0x000ee2000000d400ULL, 0x0000003000307245ULL, 0x002fca000020d400ULL,
0x0000000167674812ULL, 0x000fe400078efcffULL, 0x0000002a00417306ULL, 0x000e62000000d400ULL,
0x000000353400720bULL, 0x004fce0003f3d000ULL, 0x0000002b00507306ULL, 0x000fe20000009400ULL,
0x0000000140406812ULL, 0x008fc800078efcffULL, 0x000000403724723eULL, 0x000fe400000010ffULL,
0x0000000130301812ULL, 0x000fe200078efcffULL, 0x0000002b004f7306ULL, 0x000ea20000005400ULL,
0x0000000141415812ULL, 0x002fe400078efcffULL, 0x000000673047723eULL, 0x000fca00000010ffULL,
0x0000002b00427306ULL, 0x0002f0000000d400ULL, 0x0000003100327306ULL, 0x000fe20000209400ULL,
0x000000002828783bULL, 0x002e620000000200ULL, 0x0000004f5000720bULL, 0x004fcc0003fdd000ULL,
0x0000003100337306ULL, 0x000eae0000205400ULL, 0x0000000142426812ULL, 0x008fe200078efcffULL,
0x0000007f00577306ULL, 0x000ff00000209400ULL, 0x0000007f00547306ULL, 0x000ee20000205400ULL,
0x000000333200720bULL, 0x004fce0003f9d000ULL, 0x0000006800697306ULL, 0x000fec0000209400ULL,
0x0000000126264812ULL, 0x000fe400078efcffULL, 0x00000068006c7306ULL, 0x0005220000205400ULL,
0x000000545700720bULL, 0x008fe20003f3d000ULL, 0x000000242814723cULL, 0x042fec0000041814ULL,
0x0000008000557306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x004fe2000020d400ULL,
0x0000008a2820723cULL, 0x000fe20000041820ULL, 0x0000008500247245ULL, 0x000fc4000020d400ULL,
0x0000008400257245ULL, 0x000fc6000020d400ULL, 0x00000080004e7306ULL, 0x0002a20000205400ULL,
0x0000006c6900720bULL, 0x010fe20003f7d000ULL, 0x00000048281c723cULL, 0x000fe2000004181cULL,
0x0000007f00697245ULL, 0x000fc8000020d400ULL, 0x0000000169691812ULL, 0x000fe200078efcffULL,
0x0000007300717306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fe2000020d400ULL,
0x000000622818723cULL, 0x040fe20000041818ULL, 0x000000692669723eULL, 0x000fe400000010ffULL,
0x0000007300267245ULL, 0x000fe4000020d400ULL, 0x0000000168683812ULL, 0x000fe200078efcffULL,
0x0000007300727306ULL, 0x000e620000205400ULL, 0x0000004e5500720bULL, 0x004fe20003f5d000ULL,
0x000000462810723cULL, 0x000fe20000041810ULL, 0x000000456868723eULL, 0x000fca00000010ffULL,
0x0000008500867306ULL, 0x000fe40000209400ULL, 0x00000068280c723cULL, 0x000fe8000004180cULL,
0x0000000180802812ULL, 0x000fe400078efcffULL, 0x0000008500797306ULL, 0x000ea20000205400ULL,
0x000000727100720bULL, 0x002fe40003f3d000ULL, 0x000000418080723eULL, 0x000fca00000010ffULL,
0x00000082004c7306ULL, 0x000fec0000209400ULL, 0x0000000126261812ULL, 0x000fe400078efcffULL,
0x00000082004f7306ULL, 0x000e620000205400ULL, 0x000000798600720bULL, 0x004fe40003f7d000ULL,
0x000000044300780cULL, 0x000fca0003f25270ULL, 0x0000008300347306ULL, 0x000fec0000209400ULL,
0x0000000124243812ULL, 0x000fe400078efcffULL, 0x0000008300277306ULL, 0x0004e20000205400ULL,
0x0000004f4c00720bULL, 0x002fce0003f9d000ULL, 0x0000008400327306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x004fca000020d400ULL, 0x0000000181814812ULL, 0x000fe400078efcffULL,
0x0000008400337306ULL, 0x000e620000205400ULL, 0x000000273400720bULL, 0x008fe40003f5d000ULL,
0x000000812481723eULL, 0x000fce00000010ffULL, 0x000000802808723cULL, 0x000fe80000041808ULL,
0x0000000183832812ULL, 0x000fe400078efcffULL, 0x000000333200720bULL, 0x002fe40003fbd000ULL,
0x000000428324723eULL, 0x000fd600000010ffULL, 0x0000000125255812ULL, 0x000fc800078efcffULL,
0x000000252625723eULL, 0x000fce00000010ffULL, 0x000000242804723cULL, 0x000fe20000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e003bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd41000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x010614003d257984ULL, 0x000e620000000800ULL,
0x0000ffff3a007812ULL, 0x000fe200078ec0ffULL, 0x0000001d2d1d7220ULL, 0x040fe20000410000ULL,
0x0000001a2d247220ULL, 0x040fe20000410000ULL, 0x000000142d147220ULL, 0x040fe20000410000ULL,
0x0000888000337816ULL, 0x000fe200000000ffULL, 0x0000001e2d1e7220ULL, 0x040fe20000410000ULL,
0x0000001b2d267220ULL, 0x040fe20000410000ULL, 0x000000152d157220ULL, 0x040fe20000410000ULL,
0x0000000c2d1a7220ULL, 0x040fe20000410000ULL, 0x000000202d207220ULL, 0x040fe20000410000ULL,
0x000000212d217220ULL, 0x040fe20000410000ULL, 0x000000222d227220ULL, 0x040fe20000410000ULL,
0x0000001f2d1f7220ULL, 0x040fe20000410000ULL, 0x000000162d277220ULL, 0x040fe20000410000ULL,
0x000000172d287220ULL, 0x040fe20000410000ULL, 0x0000000d2d1b7220ULL, 0x000fe20000410000ULL,
0x8000000033007824ULL, 0x000fe200078e00ffULL, 0x000000232d237220ULL, 0x040fe20000410000ULL,
0x000000182d187220ULL, 0x040fe20000410000ULL, 0x000000192d197220ULL, 0x040fe20000410000ULL,
0x000000102d167220ULL, 0x040fe20000410000ULL, 0x000000112d177220ULL, 0x040fe20000410000ULL,
0x0000001c2d1c7220ULL, 0x040fe20000410000ULL, 0x000000122d297220ULL, 0x040fe20000410000ULL,
0x000000132d2a7220ULL, 0x040fe20000410000ULL, 0x0000000e2d2b7220ULL, 0x040fe20000410000ULL,
0x0000000f2d307220ULL, 0x040fe20000410000ULL, 0x000000082d087220ULL, 0x040fe20000410000ULL,
0x000000092d097220ULL, 0x040fe20000410000ULL, 0x0000000a2d317220ULL, 0x040fe20000410000ULL,
0x0000000b2d327220ULL, 0x040fe20000410000ULL, 0x000000042d047220ULL, 0x040fe20000410000ULL,
0x000000052d057220ULL, 0x040fe20000410000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e001dULL,
0x000000062d067220ULL, 0x040fe20000410000ULL, 0x000000ffff107224ULL, 0x000fe200078e0014ULL,
0x000000072d077220ULL, 0x000fe20000410000ULL, 0x000000ffff117224ULL, 0x000fc400078e0015ULL,
0x000000ffff147224ULL, 0x000fe200078e001aULL, 0x8000000025ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff157224ULL, 0x000fe400078e001bULL,
0x000000ffff1a7224ULL, 0x000fc400078e0022ULL, 0x000000ffff1e7224ULL, 0x000fe400078e001fULL,
0x000000ffff0e7224ULL, 0x000fe400078e0018ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0019ULL,
0x000000ffff127224ULL, 0x000fe400078e0016ULL, 0x000000ffff137224ULL, 0x000fe400078e0017ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0023ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0024ULL,
0x000000ffff207224ULL, 0x000fe400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e0028ULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff237224ULL, 0x000fe400078e0029ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fc400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e0030ULL,
0x000000ffff277224ULL, 0x000fe400078e0031ULL, 0x000000ffff287224ULL, 0x000fe200078e0032ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe400078e0006ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0007ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000033337824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x010614003d047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc40007804833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000042f1c7824ULL, 0x000fe200078e00ffULL,
0x0000003c5b00720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x000000805a007824ULL, 0x000fca00078e0205ULL,
0x0104000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000022f087824ULL, 0x000fe400078e00ffULL, 0x0000000159387824ULL, 0x000fc600078e0a38ULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x00000001092b7812ULL, 0x040fe400078efcffULL,
0x0000000809317812ULL, 0x000fe400078efcffULL, 0x000000382b00720cULL, 0x080fe40003f26070ULL,
0x00000010092b7812ULL, 0x000fe400078efcffULL, 0x000000383100720cULL, 0x080fe40003f06070ULL,
0x000000382b00720cULL, 0x000fc40003fc6070ULL, 0x0000001109317812ULL, 0x040fe400078efcffULL,
0x00000018092b7812ULL, 0x040fe400078efcffULL, 0x000000380900720cULL, 0x080fe40003f46070ULL,
0x000000383100720cULL, 0x080fe40003fa6070ULL, 0x000000382b00720cULL, 0x000fe40003f66070ULL,
0x0000000909337812ULL, 0x000fc400078efcffULL, 0x0000001909317812ULL, 0x040fe400078efcffULL,
0x00000020092b7812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000383300720cULL, 0x080fe40003f86070ULL,
0x000000383100720cULL, 0x080fe40003f46070ULL, 0x000000382b00720cULL, 0x000fe40003f26070ULL,
0x0000002109317812ULL, 0x040fe400078efcffULL, 0x00000028092b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000383100720cULL, 0x080fe40003f06070ULL, 0x000000382b00720cULL, 0x000fe40003f86070ULL,
0x0000002909317812ULL, 0x000fc400078efcffULL, 0x00000030092b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000383100720cULL, 0x000fc40003fc6070ULL, 0x000000382b00720cULL, 0x000fe40003fa6070ULL,
0x0000003109317812ULL, 0x040fe400078efcffULL, 0x00000038092b7812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000383100720cULL, 0x080fe40003f66070ULL,
0x000000382b00720cULL, 0x000fc40003f46070ULL, 0x000000380900720cULL, 0x000fe40003f26070ULL,
0xff7fffff24247808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff25257808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff26267808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff27277808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff28287808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff29297808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff367424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000001908317209ULL, 0x000fe40007810000ULL,
0x0000002a05337209ULL, 0x000fe20007810000ULL, 0x00000dc27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0031047f89ULL, 0x0004e400000e0000ULL, 0x0000000431317209ULL, 0x00cfe20007810000ULL,
0x00000df27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0033047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007307f89ULL, 0x000f2200000e0000ULL,
0x0000000433087209ULL, 0x004fc60007810000ULL, 0x0c201f0031047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000003007307209ULL, 0x010fc60007810000ULL, 0x0c201f0009327f89ULL, 0x002e6800000e0000ULL,
0x0c201f00302b7f89ULL, 0x00092200000e0000ULL, 0x0000000431047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000003209067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fc40000000000ULL,
0x00000005ff327e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3f8000003232783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL, 0x000000ffff337224ULL, 0x000fe200078e0032ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010819ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2a197823ULL, 0x000fe20000010819ULL,
0x0000000000087886ULL, 0x000fc400038e0100ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x0007f00000000800ULL, 0x0000001e001e7308ULL, 0x000f220000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000010ffULL, 0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x010fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x000000320834723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000320c34723cULL, 0x000fee0000041834ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe400000010ffULL, 0xfffffffc2f147812ULL, 0x000fc800078ec0ffULL,
0x000000141d1d7219ULL, 0x000fe200000006ffULL, 0x0000002500257308ULL, 0x000fe60000000800ULL,
0x000000001d1e73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0573c4ULL, 0x000f280000004000ULL,
0x0000002600267308ULL, 0x000ea20000000800ULL, 0x000000232411723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000252613723eULL, 0x004fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000081dff7c12ULL, 0x008fe2000f80401eULL,
0x000000321034723cULL, 0x000fec0000041834ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x004fe400000010ffULL, 0x000000302b077209ULL, 0x000fca0007810000ULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x00000019001a7308ULL, 0x000ea20000000800ULL,
0x000000272815723eULL, 0x002fe400000010ffULL, 0x000000291a17723eULL, 0x004fce00000010ffULL,
0x000000321434723cULL, 0x000fe20000041834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000090205008947ULL, 0x010fde000b800000ULL, 0x001c1fff34187589ULL, 0x0002a400000e0000ULL,
0x000000001d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x000000081dff7c12ULL, 0x008fda000f80401aULL,
0x0000091205008947ULL, 0x010fea000b800000ULL, 0x001c1fff36197589ULL, 0x00072800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL, 0x001c1fff001b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x00afe4000001162fULL, 0x0000000c1c377812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x000000032fff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d327824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d487824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f267812ULL, 0x000fc400078ef61eULL, 0x000000041f287812ULL, 0x140fe400078ef61eULL,
0x000000051f2a7812ULL, 0x140fe400078ef61eULL, 0x000000061f307812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x0000a0005a1d7811ULL, 0x000fe400078e58ffULL, 0xfffffff823347812ULL, 0x100fe400078ee21eULL,
0x000000011f367812ULL, 0x140fe200078ef61eULL, 0x00000010201c7824ULL, 0x000fe200078e021dULL,
0xfffffff848487812ULL, 0x000fe200078ee221ULL, 0x0000001024207824ULL, 0x100fe200078e021dULL,
0x000000021f387812ULL, 0x140fe200078ef61eULL, 0x0000001028247824ULL, 0x100fe200078e021dULL,
0x000000031f407812ULL, 0x140fe200078ef61eULL, 0x0000001030287824ULL, 0x100fe200078e021dULL,
0x000000041f427812ULL, 0x140fe200078ef61eULL, 0x0000001036307824ULL, 0x100fe200078e021dULL,
0x000000051f447812ULL, 0x140fe200078ef61eULL, 0x0000001038317824ULL, 0x100fe200078e021dULL,
0x000000061f467812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x0000001026227824ULL, 0x100fe400078e021dULL, 0x000000102a267824ULL, 0x100fe400078e021dULL,
0x00000001371f7824ULL, 0x000fe400078e021cULL, 0x00000010322a7824ULL, 0x100fe400078e021dULL,
0x00000010341c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x0000001040327824ULL, 0x000fc400078e021dULL, 0x0000001042337824ULL, 0x100fe400078e021dULL,
0x0000001044347824ULL, 0x100fe400078e021dULL, 0x0000001046357824ULL, 0x100fe400078e021dULL,
0x0000001048367824ULL, 0x000fe400078e021dULL, 0x00000001371d7824ULL, 0x040fe400078e021eULL,
0x0000000137217824ULL, 0x000fc400078e0220ULL, 0x0000000137237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000137257824ULL, 0x040fe400078e0224ULL,
0x0000000137277824ULL, 0x040fe200078e0226ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x0000000137297824ULL, 0x040fe400078e0228ULL, 0x00000001372b7824ULL, 0x040fe200078e022aULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x00000001371c7824ULL, 0x000fc400078e021cULL,
0x0000000137307824ULL, 0x040fe200078e0230ULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x00000001371e7824ULL, 0x040fe400078e0231ULL, 0x0000000137327824ULL, 0x040fe200078e0232ULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000137087824ULL, 0x042fe400078e0233ULL,
0x0000000137347824ULL, 0x040fe200078e0234ULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x0000000137207824ULL, 0x000fc400078e0235ULL, 0x0000000137367824ULL, 0x000fe200078e0236ULL,
0x000000162b007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b30007388ULL, 0x0007e80000000800ULL, 0x0000000d1e007388ULL, 0x0007e80000000800ULL,
0x0000000f32007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x0000001334007388ULL, 0x0007e80000000800ULL, 0x0000001520007388ULL, 0x0007e80000000800ULL,
0x0000001736007388ULL, 0x0007e80000000800ULL, 0x0100000400008388ULL, 0x0007e80000000c00ULL,
0x0102001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000003005b5b7a10ULL, 0x000fe20007ffe0ffULL, 0x010608003dff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff3aff7812ULL, 0x000fc4000780c0ffULL, 0x0000002e5b00720cULL, 0x000fe40003f26070ULL,
0x00000001ff3a7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffb90000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0031ULL, 0x0001d62000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fe400078e00ffULL, 0x0000053000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002bULL, 0xfffff1f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e0033ULL, 0x0001d68000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x000004d000007944ULL, 0x020fea0003c00000ULL,
0x0000002b33347209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0006ULL,
0x0001d6d000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fe400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002b06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0007ULL, 0x0001d72000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002b07307209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0031ULL,
0x0001d77000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002b31047209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0034ULL, 0x0001d7c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002b34057209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0006ULL,
0x0001d81000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0x0000002b06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0030ULL, 0x0001d86000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0xfffff0b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0034ULL,
0x0001d8c0001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fc400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000002d000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e001bULL, 0xfffff6a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x002fe200078e0036ULL, 0x0001d930001e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff217224ULL, 0x000fe400078e00ffULL, 0x00001c1fff227424ULL, 0x000fe400078e00ffULL,
0x0000026000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff217224ULL, 0x002fe200078e00ffULL,
0x0001d980001e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x004fe400078e001bULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x002fe200078e00ffULL, 0x0001d9d0001e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff227424ULL, 0x000fc400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e001bULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xfffff62000007947ULL, 0x000fea000383ffffULL,
0x0180000028037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000002800038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff187807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000318ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff28ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000028057812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000318ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002800037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe24b004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c0000322b2b7389ULL, 0x0002a200000e0035ULL,
0xfffe247008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000001d00007348ULL, 0x000fe80003800000ULL, 0x00000021201b7389ULL, 0x0002a200000e0022ULL,
0xfffe24301e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000008ecULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010f8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001108ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001128ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001198ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011a0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011b0ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001380ULL, 0x000000000001dc80ULL, 0xf200001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001f000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001f010ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001f010ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001f490ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001198ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001de68ULL, 0x000000000001de68ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001f000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001f490ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_86_cubin_len = 128368;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
