/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000020e10ULL, 0x0000000000020990ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000001f4f0ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x000000000001f680ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000001f6c0ULL, 0x0000000000000140ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000001f800ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001f4f000000000ULL, 0x0000040400000000ULL, 0x810c000000180400ULL, 0x007d180410288080ULL,
0x0000000000000000ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x80162880808b0828ULL,
0x0000000310288082ULL, 0x808b920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0001f4f000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL,
0x8087288080840900ULL, 0x0900000004042880ULL, 0x288080842880808bULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8c08288080990828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x002880808c920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL,
0x0001f68000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x99082880808c0828ULL, 0x288080a008288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080a0ULL, 0x0000001cffffffffULL, 0x0000018000000000ULL,
0x0001f6c000000000ULL, 0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000ffULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000001000000011ULL, 0x0000001100081104ULL,
0x0008120400000010ULL, 0x0000001000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000dULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0001e38000183104ULL, 0x0001e8200001e810ULL,
0x0001e9a00001e990ULL, 0x00e829040001e9b0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002205000022ULL,
0x0500002205000022ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000b000e82804ULL,
0x00001f1000000110ULL, 0x0000203000001fa0ULL, 0x00003a0000002050ULL, 0x00006ce000003a30ULL,
0x00006e0000006d60ULL, 0x0000840000006e30ULL, 0x0000b83000008420ULL, 0x0000b9600000b8b0ULL,
0x0000d0e00000b980ULL, 0x000104100000d190ULL, 0x0001053000010490ULL, 0x0001310000010560ULL,
0x000146f000013140ULL, 0x00014e8000014700ULL, 0x00016e2000016c20ULL, 0x00017320000172f0ULL,
0x0001e23000017b60ULL, 0x0001e2700001e260ULL, 0x0001e2a00001e280ULL, 0x0001e2e00001e2c0ULL,
0x0001e9800001e2f0ULL, 0x0001e9f00001e9e0ULL, 0x0001f0400001ea00ULL, 0x0001f1300001f0c0ULL,
0x0001f2100001f1a0ULL, 0x0001f2f00001f280ULL, 0x0001f3c00001f360ULL, 0x0001f4800001f430ULL,
0x03e039040001f4d0ULL, 0x000000ff00000180ULL, 0x003f01000001c600ULL, 0x0000000b000001b0ULL,
0x003f01300001c608ULL, 0x0000000b000001e0ULL, 0x003f01300001c610ULL, 0x0000000b00000240ULL,
0x003f01200001c648ULL, 0x000000ff00000250ULL, 0x003f01000001c658ULL, 0x000000ff000005b0ULL,
0x003f01070001c600ULL, 0x0000002400000780ULL, 0x003f01020001c614ULL, 0x0000002400000860ULL,
0x003f01010001c610ULL, 0x000000ff00001060ULL, 0x003f01070001c648ULL, 0x000000ff000010e0ULL,
0x003f01010001c658ULL, 0x000000ff00001270ULL, 0x003f01060001c65cULL, 0x000000ff00001330ULL,
0x003f01060001c65cULL, 0x000000ff000013c0ULL, 0x003f01060001c65cULL, 0x000000ff00001ca0ULL,
0x0005010700000000ULL, 0x0000002200001d10ULL, 0x003f010600000004ULL, 0x000000ff00001d50ULL,
0x003f01060001c60cULL, 0x000000ff00001e40ULL, 0x003f01060001c60cULL, 0x00000022000022b0ULL,
0x003f010600000004ULL, 0x0000002200002350ULL, 0x003f010600000004ULL, 0x000000ff00006160ULL,
0x003f01010001c658ULL, 0x000000ff000061d0ULL, 0x003f01010001c610ULL, 0x000000ff00006280ULL,
0x003f01060001c65cULL, 0x000000ff000062d0ULL, 0x003f01060001c65cULL, 0x000000ff00006360ULL,
0x003f01060001c65cULL, 0x0000004400006ad0ULL, 0x003f01070001c648ULL, 0x0000000c00006b50ULL,
0x003f010600000004ULL, 0x000000ff00006b70ULL, 0x003f01060001c61cULL, 0x000000ff00006c60ULL,
0x003f01060001c61cULL, 0x0000000e000070c0ULL, 0x003f010600000004ULL, 0x0000000e00007150ULL,
0x003f010600000004ULL, 0x000000ff0000ad50ULL, 0x003f01010001c658ULL, 0x000000ff0000ade0ULL,
0x003f01010001c620ULL, 0x000000ff0000ae60ULL, 0x003f01060001c65cULL, 0x000000ff0000aec0ULL,
0x003f01060001c65cULL, 0x000000ff0000af50ULL, 0x003f01060001c65cULL, 0x000000ff0000b640ULL,
0x0005010700000000ULL, 0x0000000e0000b6b0ULL, 0x003f01060001c64cULL, 0x000000ff0000b6d0ULL,
0x003f01060001c62cULL, 0x000000ff0000b7b0ULL, 0x003f01060001c62cULL, 0x0000000e0000bc10ULL,
0x003f01060001c64cULL, 0x0000000f0000bd00ULL, 0x003f010600000004ULL, 0x000000ff0000f8e0ULL,
0x003f01010001c658ULL, 0x000000ff0000f970ULL, 0x003f01010001c630ULL, 0x000000ff0000fa10ULL,
0x003f01060001c65cULL, 0x000000ff0000fa60ULL, 0x003f01060001c65cULL, 0x000000ff0000faf0ULL,
0x003f01060001c65cULL, 0x0000002800010220ULL, 0x003f01070001c648ULL, 0x0000000e000102a0ULL,
0x003f010600000004ULL, 0x000000ff000102c0ULL, 0x003f01060001c63cULL, 0x000000ff00010390ULL,
0x003f01060001c63cULL, 0x00000018000107f0ULL, 0x003f010600000004ULL, 0x0000001800010880ULL,
0x003f010600000004ULL, 0x000000ff00014400ULL, 0x003f01010001c658ULL, 0x000000ff00014460ULL,
0x003f01010001c640ULL, 0x000000ff00019900ULL, 0x003f01060001c604ULL, 0x000000ff00019990ULL,
0x003f01060001c604ULL, 0x000000ff00019cc0ULL, 0x003f01010001c600ULL, 0x000000ff00019cd0ULL,
0x003f01060001c604ULL, 0x000000ff00019d50ULL, 0x003f01060001c604ULL, 0x0000003d0001d6a0ULL,
0x003f01060001c614ULL, 0x0000003d0001db30ULL, 0x003f01060001c614ULL, 0x0000003d0001ef80ULL,
0x003f01010001c608ULL, 0x00101c0400053803ULL, 0x00019da000017fa0ULL, 0x0001efe000019e70ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ecULL, 0x0000001100000002ULL,
0x000000000000016cULL, 0x0000001100000002ULL, 0x00000000000000d4ULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001c7ULL, 0x0000001100000002ULL,
0x0000000000000142ULL, 0x0000001100000002ULL, 0x00000000000000adULL, 0x0000001100000002ULL,
0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000107919ULL, 0x000e620000002300ULL,
0x00000004ff197424ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ea20000002600ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0xfffffff001017810ULL, 0x000fe20007ffe0ffULL, 0x00005800ff177624ULL, 0x000fe400078e00ffULL,
0x0000000000097919ULL, 0x000ee80000002100ULL, 0x00000000000a7919ULL, 0x000f220000002700ULL,
0x0000000110007824ULL, 0x002fc600078e0203ULL, 0x00001fff10107589ULL, 0x000e6200000e0000ULL,
0x00000080000b7824ULL, 0x108fe200078e0209ULL, 0x00000005ff007819ULL, 0x000fe20000011609ULL,
0x000062000a087625ULL, 0x010fc600078e0019ULL, 0x000000ff0b00720cULL, 0x040fe40003f65270ULL,
0x000000030b00780cULL, 0x040fe20003f04070ULL, 0x00001fff00007589ULL, 0x000ee200000e0000ULL,
0x0000007f0b00780cULL, 0x040fe40003f24070ULL, 0x000000010b00780cULL, 0x000fce0003f44070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL,
0x01c60002ff00b388ULL, 0x0009e20000000a00ULL, 0x3fffff80ff068424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff078424ULL, 0x000fe200078e00ffULL, 0x01c608040b008388ULL, 0x0009e2000000ca00ULL,
0xff317217ff129424ULL, 0x000fc400078e00ffULL, 0x3fffff80ff0ca424ULL, 0x000fe200078e00ffULL,
0x01c610060b008388ULL, 0x0009e2000000ca00ULL, 0x000000ff1000720cULL, 0x002fe20003f05270ULL,
0x7fffff80ff0da424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0eb424ULL, 0x000fe200078e00ffULL,
0x01c400120b009388ULL, 0x0009e20000004800ULL, 0x7fffff80ff0fb424ULL, 0x000fc600078e00ffULL,
0x01c6480c0b00a388ULL, 0x0009e80000008a00ULL, 0x01c6580eff00b388ULL, 0x0009e80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003a000000947ULL, 0x004fea0003800000ULL,
0x0000000000117919ULL, 0x018e620000000000ULL, 0x0000000400027824ULL, 0x000fe200078e00ffULL,
0x0000000404057899ULL, 0x000fe2000800063fULL, 0x0000001017037824ULL, 0x000fc400078e00ffULL,
0x00000200ff187424ULL, 0x000fc600078e00ffULL, 0x0000000503047e24ULL, 0x000fe2000f8e020aULL,
0x0000000211057211ULL, 0x042fe200078fd8ffULL, 0x0000001011027824ULL, 0x000fc600078e00ffULL,
0x0000000705037812ULL, 0x040fe400078ec0ffULL, 0x000001f002157812ULL, 0x000fe200078ec0ffULL,
0x0000000104027824ULL, 0x000fe200078e0205ULL, 0x00000002050f7810ULL, 0x000fe40007ffe0ffULL,
0x0000001f03067812ULL, 0x000fe200078e7811ULL, 0x00005c0002027625ULL, 0x000fe200078e0018ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0000000305137810ULL, 0x040fe20007ffe0ffULL,
0x00000020050b7824ULL, 0x000fe200078e0206ULL, 0x000000070f0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000104057824ULL, 0x040fe200078e0207ULL, 0x0000000707067812ULL, 0x000fe200078ec0ffULL,
0x0000000104147824ULL, 0x000fe200078e0213ULL, 0x00000007130d7812ULL, 0x000fe200078ec0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x0000001f0c127812ULL, 0x000fc400078e7811ULL,
0x00000015020c7210ULL, 0x000fe40007f1e0ffULL, 0x0000001f06067812ULL, 0x100fe200078e7811ULL,
0x000000200f127824ULL, 0x000fe200078e0212ULL, 0x0000001f0d167812ULL, 0x000fe200078e7811ULL,
0x0000000104117824ULL, 0x000fe400078e020fULL, 0x000000ffff0d7224ULL, 0x000fe400000e0603ULL,
0x00005c0005027625ULL, 0x000fc600078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000b901c46ULL, 0x00000020070e7824ULL, 0x000fe200078e0206ULL,
0x0000001502027210ULL, 0x000fe20007f1e0ffULL, 0x00005c0011047625ULL, 0x000fc800078e0018ULL,
0x00005c0014067625ULL, 0x000fe200078e0018ULL, 0x0000001504047210ULL, 0x000fc60007f3e0ffULL,
0x0000002013167824ULL, 0x000fe200078e0216ULL, 0x0000001506067210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff037224ULL, 0x000fe400000e0603ULL, 0x000000100e0f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x0000001012117824ULL, 0x000fe200078e00ffULL,
0x00000000020f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fc400010e0607ULL,
0x0000001016137824ULL, 0x000fe200078e00ffULL, 0x0000000004117faeULL, 0x0003e8000b901c46ULL,
0x0000000006137faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000608027981ULL, 0x01aea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000e620000002500ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x00000005ff037e24ULL, 0x002fe2000f8e00ffULL,
0x0000003f02047810ULL, 0x004fc40007ffe0ffULL, 0x000000ff02057810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff047819ULL, 0x000fe40000011604ULL, 0x00000008ff057819ULL, 0x000fca0000011605ULL,
0x0001790000008947ULL, 0x000fea0003800000ULL, 0x00000004030d7824ULL, 0x000fe400078e00ffULL,
0x0000001000247824ULL, 0x000fe400078e00ffULL, 0x00000003ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000040d00720cULL, 0x000fe20003f06070ULL, 0xffffffffff0b7424ULL, 0x000fd800078e00ffULL,
0x000064000d078a10ULL, 0x000fe20007ffe0ffULL, 0x000000020a068824ULL, 0x000fc800078e00ffULL,
0x0000640006068a24ULL, 0x000fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6140c24ff738cULL, 0x0003e20000000000ULL, 0x0000600006088625ULL, 0x000fe200078e0019ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006080b8981ULL, 0x0004e2000c1e1900ULL,
0x000000010d067810ULL, 0x000fc60007ffe0ffULL, 0x0000000000237919ULL, 0x000f220000000000ULL,
0x000000040600720cULL, 0x040fe20003f06070ULL, 0x00000100030f7824ULL, 0x000fe200078e00ffULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004017107824ULL, 0x000fe200078e00ffULL,
0x01c6100024ff7f8cULL, 0x0003f2000c80043fULL, 0x0000640006078a10ULL, 0x000fe20007ffe0ffULL,
0x000000020a0c8824ULL, 0x002fc800078e00ffULL, 0x000064000c0c8a24ULL, 0x000fe400078e0207ULL,
0xffffffffff077424ULL, 0x000fe400078e00ffULL, 0x000060000c0c8625ULL, 0x000fe200078e0019ULL,
0x0000000103087810ULL, 0x004fe40007ffe0ffULL, 0x00000004ff187819ULL, 0x010fe40000011623ULL,
0x0000000f020e7217ULL, 0x000fe20007800000ULL, 0x000000060c078981ULL, 0x000362000c1e1900ULL,
0x000000050800720cULL, 0x000fe20003f06070ULL, 0x0000000124087824ULL, 0x000fe200078e0218ULL,
0x0000000818127810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0fULL,
0x0000000e18227810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x0000000708097812ULL, 0x000fe200078ec0ffULL, 0x00000010231f7824ULL, 0x000fe200078e00ffULL,
0x000000400e0e7807ULL, 0x000fe20000000000ULL, 0x00000001241e7824ULL, 0x040fe200078e0212ULL,
0x0000000f09097812ULL, 0x000fe200078e7823ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000000e240e7217ULL, 0x000fe20007800000ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000002180c7810ULL, 0x002fe20007ffe0ffULL, 0x00000010081a7824ULL, 0x000fe200078e0209ULL,
0x000000f01f1f7812ULL, 0x000fe200078ec0ffULL, 0x000000010e197824ULL, 0x000fe200078e0a24ULL,
0x00000004180e7810ULL, 0x000fe20007ffe0ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000190c00720cULL, 0x080fe20003f86070ULL, 0x00000001240c7824ULL, 0x000fe200078e020cULL,
0x000000190e00720cULL, 0x080fe20003f66070ULL, 0x00000001240e7824ULL, 0x000fe200078e020eULL,
0x000000191200720cULL, 0x000fe20003f26070ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000000070c0d7812ULL, 0x000fe200078ec0ffULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x000000070e0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff597224ULL, 0x000fe200078e00ffULL,
0x0000000f0d0d7812ULL, 0x000fc400078e7823ULL, 0x0000000f0f0f7812ULL, 0x000fe400078e7823ULL,
0x000000191800720cULL, 0x000fe20003fa6070ULL, 0x000000100c1b7824ULL, 0x000fe400078e020dULL,
0x000000100e1c7824ULL, 0x000fe200078e020fULL, 0x000000071e0f7812ULL, 0x000fe400078ec0ffULL,
0x000140001b1b7811ULL, 0x000fe400078e20ffULL, 0x0000000f0f157812ULL, 0x000fe200078e7823ULL,
0x00000004100b7e24ULL, 0x008fe2000f8e020bULL, 0x0000000618107810ULL, 0x000fc80007ffe0ffULL,
0x0000003f0b087812ULL, 0x000fe200078ef808ULL, 0x0000000124147824ULL, 0x000fe200078e0210ULL,
0x000000191000720cULL, 0x000fc60003f46070ULL, 0x00005e0008087625ULL, 0x000fca00078e0021ULL,
0x0000001f08107210ULL, 0x000fe40007f1e0ffULL, 0x0000003f0b087812ULL, 0x040fe400078ef80cULL,
0x00000007140c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff117224ULL, 0x000fe400000e0609ULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0x0000000f0c0d7812ULL, 0x000fe400078e7823ULL,
0x0000003f0b0c7812ULL, 0x000fc400078ef814ULL, 0x0000001f08127210ULL, 0x000fe20007f1e0ffULL,
0x00000010141d7824ULL, 0x000fe200078e020dULL, 0x0000003f0b087812ULL, 0x040fe200078ef80eULL,
0x00005e000c0c7625ULL, 0x000fe200078e0021ULL, 0x0000003f0b0e7812ULL, 0x000fe400078ef81eULL,
0x000140001d1d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff137224ULL, 0x000fe200000e0609ULL,
0x0000001f0c167210ULL, 0x000fe20007fde0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0021ULL,
0x0000000c180c7810ULL, 0x000fc60007ffe0ffULL, 0x000000101e1e7824ULL, 0x000fe200078e0215ULL,
0x0000001f08147210ULL, 0x000fe20007f1e0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0021ULL,
0x0000000a18087810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0609ULL,
0x000000190800720cULL, 0x000fe20003f06070ULL, 0x0000000124207824ULL, 0x000fe400078e0208ULL,
0x000000ffff177224ULL, 0x000fe200030e060dULL, 0x000140001a0d7811ULL, 0x000fe200078e20ffULL,
0x00000001241a7824ULL, 0x000fe200078e020cULL, 0x0000003f0b087812ULL, 0x040fe400078ef820ULL,
0x0000001f0e0e7210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100d7faeULL, 0x0003e2000e901c46ULL, 0x000000190c00720cULL, 0x000fe20003fa6070ULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0x00000007200c7812ULL, 0x000fe200078ec0ffULL,
0x00000000121b7faeULL, 0x0005e2000e101c46ULL, 0x000000192200720cULL, 0x000fe20003f86070ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x0000001f08187210ULL, 0x000fe20007fde0ffULL,
0x0000000124227824ULL, 0x000fe200078e0222ULL, 0x0000003f0b087812ULL, 0x000fc600078ef81aULL,
0x000000ffff197224ULL, 0x000fe200030e0609ULL, 0x0000003f0b0d7812ULL, 0x002fe200078ef822ULL,
0x00005e0008087625ULL, 0x080fe200078e0021ULL, 0x0000000f0c0b7812ULL, 0x000fe400078e7823ULL,
0x000000071a117812ULL, 0x000fe200078ec0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0021ULL,
0x0000000722127812ULL, 0x004fe400078ec0ffULL, 0x0000001f08107210ULL, 0x080fe20007fde0ffULL,
0x0000001020207824ULL, 0x000fe200078e020bULL, 0x0000000f110b7812ULL, 0x100fe200078e7823ULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x0000000f12137812ULL, 0x000fe200078e7823ULL,
0x000000ffff117224ULL, 0x000fe200030e0609ULL, 0x0000001f0c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000101a1a7824ULL, 0x000fe200078e020bULL, 0x000140001c097811ULL, 0x000fe200078e20ffULL,
0x0000001022227824ULL, 0x000fe200078e0213ULL, 0x000140001e0b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0001400020137811ULL, 0x000fe200078e20ffULL,
0x0000000014097faeULL, 0x0003e2000d901c46ULL, 0x000140001a1b7811ULL, 0x000fc400078e20ffULL,
0x00014000221f7811ULL, 0x000fe200078e20ffULL, 0x00000000161d7faeULL, 0x0005e8000d101c46ULL,
0x000000000e0b7faeULL, 0x0005e8000c901c46ULL, 0x0000000018137faeULL, 0x0005e2000c101c46ULL,
0x000000050300720cULL, 0x000fe20003f06070ULL, 0x000000ffff097224ULL, 0x002fc400078e00ffULL,
0x00000000101b7faeULL, 0x0005e8000e901c46ULL, 0x000000000c1f7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01c64800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff587224ULL, 0x000fe200078e00ffULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x000133d000000947ULL, 0x000fea0003800000ULL, 0x000000020a0b7824ULL, 0x004fe200078e00ffULL,
0x00000002000c7811ULL, 0x000fe200078e10ffULL, 0x00006400ff0a7624ULL, 0x000fe200078e00ffULL,
0x00007610ff0f7816ULL, 0x000fe2000000000fULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x00007610ff0d7816ULL, 0x000fe2000000000dULL, 0x000064000b0b7624ULL, 0x000fe200078e020aULL,
0x00007610ff0a7816ULL, 0x000fe2000000000aULL, 0x000000ffff0e7224ULL, 0x000fc400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe400078e00ffULL, 0x00000c0a01007387ULL, 0x0003e80000100600ULL,
0x00000100030b7824ULL, 0x004fca00078e00ffULL, 0x000000020b00720cULL, 0x000fda0003f06070ULL,
0x0001327000000947ULL, 0x002fea0003800000ULL, 0x01c65c00ff0c7984ULL, 0x000ea20000000800ULL,
0x0000ffff0f0b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe400078e0006ULL,
0x000000ffff137224ULL, 0x000fe200078e000eULL, 0x000088800b107816ULL, 0x000fca00000000ffULL,
0x80000000100b7824ULL, 0x000fca00078e00ffULL, 0x800000000cff7812ULL, 0x004fe2000780480bULL,
0x0000000000007918ULL, 0x000fec0000000000ULL, 0x000076100f0c7816ULL, 0x000fe4000000000cULL,
0x000076100de17816ULL, 0x000fc600000000e1ULL, 0x0000080c01007387ULL, 0x0005e20000100600ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01c65c00ff0c7984ULL, 0x004ea40000000800ULL,
0x800000000cff7812ULL, 0x004fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000010117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL, 0x0000000b000c7305ULL, 0x0004e4000021f000ULL,
0x3fa000000b0b7823ULL, 0x004fe200000100ffULL, 0x0000000c0000735dULL, 0x008fe40003800000ULL,
0x01c65c00ff0c7984ULL, 0x000ea40000000800ULL, 0x800000000cff7812ULL, 0x004fc40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000300ff0b7624ULL, 0x000fe200078e00ffULL, 0x0000000000107919ULL, 0x000ee20000002700ULL,
0x00000003060c7812ULL, 0x004fe200078ec0ffULL, 0x00005800ff127624ULL, 0x000fe400078e00ffULL,
0x0000000000317919ULL, 0x000ea20000000000ULL, 0x000000030c00780cULL, 0x000fe20003f05270ULL,
0x00006400ff147624ULL, 0x000fe200078e00ffULL, 0xfffffffd0b0b7811ULL, 0x000fe200078e10ffULL,
0x0000004012127824ULL, 0x000fe400078e00ffULL, 0x0000001000287824ULL, 0x000fe200078e00ffULL,
0x000000010b0b7807ULL, 0x000fe20004000000ULL, 0x00000004071d7e24ULL, 0x020fc4000f8e0212ULL,
0xffffffffff077424ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fca00078e020bULL,
0x000000040600720cULL, 0x000fe20003f06070ULL, 0x0000000210107824ULL, 0x008fe200078e00ffULL,
0x00000004ff1c7819ULL, 0x004fc60000011631ULL, 0x0000640010107624ULL, 0x000fe400078e0214ULL,
0x00000001282f7824ULL, 0x000fcc00078e021cULL, 0x0000000106108824ULL, 0x000fe400078e0210ULL,
0x00000004ff118424ULL, 0x000fe200078e00ffULL, 0x00000040030b7811ULL, 0x000fe200078e40ffULL,
0x00000100ff297424ULL, 0x000fe200078e00ffULL, 0x0000003f1d147812ULL, 0x000fe200078ef82fULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x000000021c1a7810ULL, 0x000fe40007ffe0ffULL,
0x00000001030c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001031307824ULL, 0x000fe200078e00ffULL,
0x0000000b02127217ULL, 0x000fe20007800000ULL, 0x0000000610078981ULL, 0x000562000c1e1900ULL,
0x00005e0014147625ULL, 0x000fe200078e0029ULL, 0x000000050c00720cULL, 0x000fc40003f06070ULL,
0x000000f0302e7812ULL, 0x000fe200078ec0ffULL, 0x0000000112127824ULL, 0x000fe200078e0a0bULL,
0x000000041c0c7810ULL, 0x000fe20007ffe0ffULL, 0x000040000e2b7824ULL, 0x000fe200078e00ffULL,
0x0000002e141e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000128107824ULL, 0x004fe200078e021aULL,
0x0000004012127807ULL, 0x000fe20000000000ULL, 0x0000000128117824ULL, 0x000fe200078e020cULL,
0x000000061c267810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e0615ULL,
0x0000003f1d147812ULL, 0x000fc400078ef810ULL, 0x00000012280b7217ULL, 0x040fe20007800000ULL,
0x0000000128127824ULL, 0x000fe200078e0226ULL, 0x0000003f1d167812ULL, 0x040fe200078ef811ULL,
0x00005e0014147625ULL, 0x080fe200078e0029ULL, 0x000000081c327810ULL, 0x000fe40007ffe0ffULL,
0x0000003f1d187812ULL, 0x000fe200078ef812ULL, 0x00005e0016167625ULL, 0x080fe200078e0029ULL,
0x0000002e14207210ULL, 0x080fe40007f1e0ffULL, 0x0000000c1c427810ULL, 0x040fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a28ULL, 0x0000000a1c407810ULL, 0x000fe20007ffe0ffULL,
0x0000000128147824ULL, 0x000fe200078e0232ULL, 0x0000000e1c447810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200000e0615ULL, 0x0000002e16227210ULL, 0x000fe20007f1e0ffULL,
0x00005e0018187625ULL, 0x000fe200078e0029ULL, 0x0000000b1a00720cULL, 0x000fc40003f86070ULL,
0x0000003f1d1a7812ULL, 0x000fe200078ef814ULL, 0x000000ffff237224ULL, 0x000fe200000e0617ULL,
0x0000002e18247210ULL, 0x080fe20007f1e0ffULL, 0x0000000128167824ULL, 0x000fe200078e0242ULL,
0x0000000b2600720cULL, 0x000fe20003f46070ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0029ULL,
0x0000000b1c00720cULL, 0x080fe40003fa6070ULL, 0x000000072f1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000128157824ULL, 0x000fe200078e0240ULL, 0x0000000b0c00720cULL, 0x000fe20003f66070ULL,
0x000000ffff257224ULL, 0x000fe200000e0619ULL, 0x0000002e1a267210ULL, 0x000fe20007f1e0ffULL,
0x0000000128177824ULL, 0x000fe200078e0244ULL, 0x0000003f1d1a7812ULL, 0x000fc400078ef816ULL,
0x0000003f1d187812ULL, 0x040fe200078ef815ULL, 0x000000ffff277224ULL, 0x000fe200000e061bULL,
0x0000003f1d1d7812ULL, 0x000fe200078ef817ULL, 0x00005e001a1a7625ULL, 0x080fe200078e0029ULL,
0x000040002b0c7812ULL, 0x000fe400078e0cffULL, 0x0000000f1ce77812ULL, 0x000fe200078e7831ULL,
0x00005e0018187625ULL, 0x080fe200078e0029ULL, 0x0000002e1a2c7210ULL, 0x080fe40007f3e0ffULL,
0x000140000c0c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e001d1c7625ULL, 0x000fe200078e0029ULL,
0x0000002e18287210ULL, 0x000fc40007f1e0ffULL, 0x0000000710187812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e061bULL, 0x0000000b3200720cULL, 0x000fe20003f26070ULL,
0x000000102fe77824ULL, 0x000fe200078e02e7ULL, 0x0000000f181b7812ULL, 0x000fe200078e7831ULL,
0x000000ffff297224ULL, 0x000fe200000e0619ULL, 0x0000000711187812ULL, 0x000fe200078ec0ffULL,
0x00000010e7197824ULL, 0x000fe200078e020cULL, 0x0000002e1c2e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001010e67824ULL, 0x000fe200078e021bULL, 0x0000000f181a7812ULL, 0x000fc400078e7831ULL,
0x000000010e187812ULL, 0x000fe200078e0cffULL, 0x00000010e61b7824ULL, 0x000fe200078e020cULL,
0x00000007121c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e061dULL,
0x00000000180573c2ULL, 0x000ea200000e0000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e197faeULL, 0x0007e2000e901c46ULL, 0x0000000f1c1d7812ULL, 0x000fe200078e7831ULL,
0x0000001011e57824ULL, 0x000fe200078e021aULL, 0x00000007151a7812ULL, 0x000fe200078ec0ffULL,
0x00000000201b7faeULL, 0x0009e2000e101c46ULL, 0x00000007171c7812ULL, 0x000fe200078ec0ffULL,
0x0000001012e47824ULL, 0x000fe200078e021dULL, 0x0000000f1a1a7812ULL, 0x000fe200078e7831ULL,
0x00000010e51d7824ULL, 0x000fe200078e020cULL, 0x0000000b4000720cULL, 0x000fc40003f06070ULL,
0x0000000b4200720cULL, 0x080fe20003fa6070ULL, 0x00000010151a7824ULL, 0x000fe200078e021aULL,
0x0000000714197812ULL, 0x008fe200078ec0ffULL, 0x00000000221d7faeULL, 0x0007e2000d901c46ULL,
0x0000000b4400720cULL, 0x000fe20003f86070ULL, 0x00000010e40b7824ULL, 0x000fe200078e020cULL,
0x00000007161b7812ULL, 0x010fe400078ec0ffULL, 0x0000000f19197812ULL, 0x100fe400078e7831ULL,
0x0000000f1b1b7812ULL, 0x100fe200078e7831ULL, 0x00000000240b7faeULL, 0x0009e2000d101c46ULL,
0x0000000f1c1c7812ULL, 0x000fe200078e7831ULL, 0x0000001014197824ULL, 0x000fe200078e0219ULL,
0x0001c64805057891ULL, 0x004fe2000f8e183fULL, 0x00000010161b7824ULL, 0x000fe200078e021bULL,
0x0001c6480e227811ULL, 0x008fe200078e18ffULL, 0x00000010171c7824ULL, 0x000fc400078e021cULL,
0x00000010191f7824ULL, 0x100fe400078e020cULL, 0x000000101b1d7824ULL, 0x100fe400078e020cULL,
0x000000101a0b7824ULL, 0x110fe200078e020cULL, 0x00000000261f7faeULL, 0x0005e2000c901c46ULL,
0x000000101c217824ULL, 0x000fc600078e020cULL, 0x00000000280b7faeULL, 0x0005e8000c101c46ULL,
0x000000002c1d7faeULL, 0x0005e8000e901c46ULL, 0x000000002e217faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000400221e7984ULL, 0x0007220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000c0001317983ULL, 0x004ea20000100800ULL,
0x0000ffff0d0b7812ULL, 0x000fc600078ec0ffULL, 0x01c60c00ff1f7984ULL, 0x000e620000000800ULL,
0x000088800b237816ULL, 0x000fca00000000ffULL, 0x80000000230b7824ULL, 0x000fca00078e00ffULL,
0x800000001eff7812ULL, 0x010fe4000780480bULL, 0x0000ffff310c7812ULL, 0x004fc800078ec0ffULL,
0x000088800c1d7816ULL, 0x000fca00000000ffULL, 0x800000001d0c7824ULL, 0x000fca00078e00ffULL,
0x800000001fff7812ULL, 0x002fe2000782480cULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0b7424ULL, 0x000fe400078e00ffULL,
0x800000001d1f7824ULL, 0x000fe400078e00ffULL, 0x0000000b000c7305ULL, 0x0002a4000021f000ULL,
0x3fa000000b0b7823ULL, 0x002fe200000100ffULL, 0x0000000c0000735dULL, 0x004fe40003800000ULL,
0x01c60c00ff0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fc4000782481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000207919ULL, 0x000e620000000000ULL, 0x00000070301e7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff967424ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x002fc80000011620ULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000011e1e7824ULL, 0x000fca00078e020bULL,
0x01c000001e0b7984ULL, 0x000e680000000800ULL, 0x01c200001e0c7984ULL, 0x0005220000000800ULL,
0x000000080b00720bULL, 0x002fda0003f3d000ULL, 0x00000000001f7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1f247812ULL, 0x000fda000782c0ffULL, 0x0000035000009947ULL, 0x000fea0003800000ULL,
0x000000080b00720bULL, 0x014fe40003f34000ULL, 0x0000000b08277209ULL, 0x000fe40007810000ULL,
0x00000002ff207819ULL, 0x000fc60000011620ULL, 0x80000027081f7221ULL, 0x000fe20000010000ULL,
0x0000000820217810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b1f1f7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400008e0100ULL, 0x0000001f00267308ULL, 0x000e620000000800ULL,
0x000000ff0000720cULL, 0x000fe40003f25270ULL, 0x0000ffff08257812ULL, 0x000fe200078e3cffULL,
0x000000ffff087224ULL, 0x000fc600078e0027ULL, 0x0000002524ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff967807ULL, 0x000fc60001000000ULL, 0x01c400271e009388ULL, 0x000fe20000000800ULL,
0x0000002609097220ULL, 0x002fc60000410000ULL, 0x00001f2126217589ULL, 0x000e6400000e0000ULL,
0x800000270b0b2221ULL, 0x000fe40000010000ULL, 0x00001f2026207589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b0b0b2820ULL, 0x000fc80000410000ULL, 0x0000000b000a2308ULL, 0x000f220000000800ULL,
0x000000213f3f7220ULL, 0x082fe40000410000ULL, 0x000000213e3e7220ULL, 0x080fe40000410000ULL,
0x000000213b3b7220ULL, 0x080fe40000410000ULL, 0x000000213a3a7220ULL, 0x080fe40000410000ULL,
0x0000002137377220ULL, 0x080fe40000410000ULL, 0x0000002136367220ULL, 0x000fc40000410000ULL,
0x000000215b5b7220ULL, 0x080fe40000410000ULL, 0x000000215a5a7220ULL, 0x080fe40000410000ULL,
0x000000215f5f7220ULL, 0x080fe40000410000ULL, 0x000000215e5e7220ULL, 0x080fe40000410000ULL,
0x0000002157577220ULL, 0x080fe40000410000ULL, 0x0000002156567220ULL, 0x000fc40000410000ULL,
0x0000002153537220ULL, 0x080fe40000410000ULL, 0x0000002152527220ULL, 0x080fe40000410000ULL,
0x000000214f4f7220ULL, 0x080fe40000410000ULL, 0x000000214e4e7220ULL, 0x000fe40000410000ULL,
0x000000203d3d7220ULL, 0x084fe40000410000ULL, 0x000000203c3c7220ULL, 0x000fc40000410000ULL,
0x0000002039397220ULL, 0x080fe40000410000ULL, 0x0000002038387220ULL, 0x080fe40000410000ULL,
0x0000002035357220ULL, 0x080fe40000410000ULL, 0x0000002034347220ULL, 0x080fe40000410000ULL,
0x0000002059597220ULL, 0x080fe40000410000ULL, 0x0000002058587220ULL, 0x000fc40000410000ULL,
0x000000205d5d7220ULL, 0x080fe40000410000ULL, 0x000000205c5c7220ULL, 0x080fe40000410000ULL,
0x0000002055557220ULL, 0x080fe40000410000ULL, 0x0000002054547220ULL, 0x080fe40000410000ULL,
0x0000002051517220ULL, 0x080fe40000410000ULL, 0x0000002050507220ULL, 0x000fc40000410000ULL,
0x000000204d4d7220ULL, 0x080fe40000410000ULL, 0x000000204c4c7220ULL, 0x000fe40000410000ULL,
0x0000000a0c0c2220ULL, 0x010fc80000410000ULL, 0x000000090c097221ULL, 0x014fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000400220b7984ULL, 0x000e620000000800ULL,
0x80000000230c7824ULL, 0x000fca00078e00ffULL, 0x800000000bff7812ULL, 0x002fe2000780480cULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000023237824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b000c7305ULL, 0x0002a4000021f000ULL, 0x3fa000000b0b7823ULL, 0x002fe200000100ffULL,
0x0000000c0000735dULL, 0x004fe40003800000ULL, 0x00000400220c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fc40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000db7919ULL, 0x000e620000000000ULL,
0x0000000200247811ULL, 0x000fe400078e10ffULL, 0x000140002b207810ULL, 0x000fe40007ffe0ffULL,
0x000140000e277811ULL, 0x000fe400078e70ffULL, 0x0000991096967816ULL, 0x000fe400000000ffULL,
0x00000004ff217819ULL, 0x002fe400000116dbULL, 0x00000008db0b7812ULL, 0x000fc600078ec0ffULL,
0x00000004000c7824ULL, 0x000fe200078e0221ULL, 0x000000070b1f7812ULL, 0x100fe200078ec8dbULL,
0x0000000121227824ULL, 0x008fe200078e0224ULL, 0x000000070b0b7812ULL, 0x000fe400078ef8dbULL,
0x0000000c1f0c7212ULL, 0x040fe400078e3cffULL, 0x000000221f267212ULL, 0x000fe400078e3cffULL,
0x000001000b297811ULL, 0x040fe200078e20ffULL, 0x000000100bf07824ULL, 0x040fe200078e020cULL,
0x000003000b2b7811ULL, 0x040fe200078e20ffULL, 0x000000100b1f7824ULL, 0x000fc400078e0226ULL,
0x00000010f0607824ULL, 0x100fe400078e0220ULL, 0x000000101f6c7824ULL, 0x000fe400078e0220ULL,
0x000000010c207824ULL, 0x000fe400078e0229ULL, 0x000000006060783bULL, 0x000e640000004200ULL,
0x0000001020647824ULL, 0x000fe400078e0227ULL, 0x000000006c6c783bULL, 0x000ea80000004200ULL,
0x000000006464783bULL, 0x000ee20000004200ULL, 0x00000018ff217819ULL, 0x002fe20000011460ULL,
0x0000006000b37306ULL, 0x000fe20000009400ULL, 0x00000018ff227819ULL, 0x000fc40000011461ULL,
0x00000018ff237819ULL, 0x000fe40000011462ULL, 0x00000018ff247819ULL, 0x004fe4000001146dULL,
0x00000018ff257819ULL, 0x000fe2000001146fULL, 0x0000002100ca7306ULL, 0x000fe20000209400ULL,
0x0000010065da7824ULL, 0x008fca00078e00ffULL, 0x00000018ffda7819ULL, 0x000fe400000114daULL,
0x0000002100d77306ULL, 0x000e700000205400ULL, 0x0000002100c67306ULL, 0x0004f0000020d400ULL,
0x0000002200b27306ULL, 0x000fe20000209400ULL, 0x00000018ff217819ULL, 0x004fc40000011463ULL,
0x000000d7ca00720bULL, 0x002fca0003f9d000ULL, 0x0000002200a77306ULL, 0x000ff00000205400ULL,
0x0000002200b97306ULL, 0x0003e2000020d400ULL, 0x00000001c6c64812ULL, 0x008fce00078efcffULL,
0x0000002100a07306ULL, 0x000fe20000209400ULL, 0x00000018ff227819ULL, 0x002fce000001146cULL,
0x0000002100a17306ULL, 0x000ff00000205400ULL, 0x0000002100b77306ULL, 0x0003f0000020d400ULL,
0x00000022009d7306ULL, 0x000fe20000209400ULL, 0x0000000126217824ULL, 0x002fe200078e0229ULL,
0x000002000b297811ULL, 0x000fc600078e20ffULL, 0x0000001021447824ULL, 0x000fc600078e0227ULL,
0x00000022009c7306ULL, 0x000fe60000205400ULL, 0x000000004444783bULL, 0x000e6a0000004200ULL,
0x0000002200a87306ULL, 0x0005f0000020d400ULL, 0x0000002300a67306ULL, 0x000fe20000209400ULL,
0x00000018ff227819ULL, 0x004fce0000011464ULL, 0x00000022008e7306ULL, 0x000ff00000209400ULL,
0x0000002200947306ULL, 0x000ff00000205400ULL, 0x0000002200897306ULL, 0x0005e2000020d400ULL,
0x00000018ff287819ULL, 0x002fce0000011446ULL, 0x0000002300a47306ULL, 0x000fe20000205400ULL,
0x000000010c227824ULL, 0x004fc800078e0229ULL, 0x0000001022487824ULL, 0x000fc600078e0227ULL,
0x0000002300c27306ULL, 0x0003e6000020d400ULL, 0x000000004848783bULL, 0x000eaa0000004200ULL,
0x0000002400907306ULL, 0x000fe20000209400ULL, 0x00000018ff237819ULL, 0x002fce000001146eULL,
0x00000024009b7306ULL, 0x000ff00000205400ULL, 0x0000002400a37306ULL, 0x0003f0000020d400ULL,
0x0000002300917306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x002fce0000011466ULL,
0x0000002300c57306ULL, 0x000fe20000205400ULL, 0x00000018ff0b7819ULL, 0x004fce000001144bULL,
0x0000002300ab7306ULL, 0x0003f0000020d400ULL, 0x00000024008b7306ULL, 0x000fe20000209400ULL,
0x00000018ff237819ULL, 0x002fce0000011465ULL, 0x00000024008a7306ULL, 0x000ff00000205400ULL,
0x0000002400807306ULL, 0x0003f0000020d400ULL, 0x00000023008d7306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x002fce0000011445ULL, 0x00000023008c7306ULL, 0x000ff00000205400ULL,
0x0000002300797306ULL, 0x0003f0000020d400ULL, 0x0000002400817306ULL, 0x000fe20000209400ULL,
0x00000018ff237819ULL, 0x002fce0000011444ULL, 0x0000002400837306ULL, 0x000ff00000205400ULL,
0x0000002400777306ULL, 0x0003f0000020d400ULL, 0x0000002500a97306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x002fce0000011448ULL, 0x0000002500ad7306ULL, 0x000ff00000205400ULL,
0x0000002500aa7306ULL, 0x0003f0000020d400ULL, 0x0000002300857306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x002fce0000011467ULL, 0x0000002300867306ULL, 0x000ff00000205400ULL,
0x0000002300787306ULL, 0x0003f0000020d400ULL, 0x00000024007c7306ULL, 0x000fe20000209400ULL,
0x0000000126237824ULL, 0x002fc800078e0229ULL, 0x0000001023307824ULL, 0x000fc600078e0227ULL,
0x00000024007b7306ULL, 0x000fe60000205400ULL, 0x000000003030783bULL, 0x000e6a0000004200ULL,
0x0000002400747306ULL, 0x0005f0000020d400ULL, 0x0000002500877306ULL, 0x000fe20000209400ULL,
0x000000010c247824ULL, 0x004fc800078e022bULL, 0x0000001024407824ULL, 0x000fc600078e0227ULL,
0x0000002500887306ULL, 0x000fe60000205400ULL, 0x000000004040783bULL, 0x000eaa0000004200ULL,
0x00000025007a7306ULL, 0x0007f0000020d400ULL, 0x00000028007f7306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x008fc40000011447ULL, 0x00000018ff297819ULL, 0x002fe40000011432ULL,
0x00000018ff0c7819ULL, 0x000fc60000011430ULL, 0x00000025007d7306ULL, 0x000ff00000209400ULL,
0x00000025007e7306ULL, 0x000ff00000205400ULL, 0x0000002500757306ULL, 0x0003e2000020d400ULL,
0x00000018ff937819ULL, 0x004fce0000011443ULL, 0x0000002800827306ULL, 0x000fe20000205400ULL,
0x00000018ff257819ULL, 0x002fce000001144aULL, 0x0000002500ae7306ULL, 0x000ff00000209400ULL,
0x0000002500af7306ULL, 0x000ff00000205400ULL, 0x0000002500727306ULL, 0x0003f0000020d400ULL,
0x0000002800767306ULL, 0x0005e2000020d400ULL, 0x0000000126257824ULL, 0x002fe200078e022bULL,
0x00000018ff2b7819ULL, 0x000fc60000011442ULL, 0x00000010252c7824ULL, 0x000fe200078e0227ULL,
0x00000018ff277819ULL, 0x000fe40000011440ULL, 0x0000002900e97306ULL, 0x000fe20000209400ULL,
0x00000018ff287819ULL, 0x004fe40000011449ULL, 0x000000002c2c783bULL, 0x000e6a0000004200ULL,
0x0000002900e87306ULL, 0x000ff00000205400ULL, 0x00000029006a7306ULL, 0x000ff0000020d400ULL,
0x0000002800997306ULL, 0x000ff00000209400ULL, 0x00000028009a7306ULL, 0x000ff00000205400ULL,
0x0000002800737306ULL, 0x0005e2000020d400ULL, 0x00000018ff957819ULL, 0x002fc4000001142dULL,
0x00000018ffa27819ULL, 0x000fe4000001142eULL, 0x00000018ffa57819ULL, 0x000fc6000001142fULL,
0x0000009300f47306ULL, 0x000fe20000209400ULL, 0x00000018ff287819ULL, 0x004fce0000011431ULL,
0x0000009300f37306ULL, 0x000ff00000205400ULL, 0x0000009300297306ULL, 0x0003f0000020d400ULL,
0x0000006000c07306ULL, 0x000ea20000005400ULL, 0x0000010060937824ULL, 0x002fca00078e00ffULL,
0x00000018ff937819ULL, 0x000fe40000011493ULL, 0x0000006000927306ULL, 0x0002f0000000d400ULL,
0x0000002800847306ULL, 0x000fe20000209400ULL, 0x0001000060607824ULL, 0x002fe200078e00ffULL,
0x000000c0b300720bULL, 0x004fc80003f5d000ULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000002800977306ULL, 0x000fee0000205400ULL, 0x0000000192922812ULL, 0x008fe200078efcffULL,
0x00000028006b7306ULL, 0x0003f0000020d400ULL, 0x0000000b009f7306ULL, 0x000fe20000209400ULL,
0x00000018ff287819ULL, 0x002fce0000011441ULL, 0x0000000b00c17306ULL, 0x000ff00000205400ULL,
0x0000000b00717306ULL, 0x0003f0000020d400ULL, 0x0000000c00987306ULL, 0x000fe20000209400ULL,
0x00000018ff0b7819ULL, 0x002fce0000011433ULL, 0x0000000c009e7306ULL, 0x000ff00000205400ULL,
0x0000000c00707306ULL, 0x000ff0000020d400ULL, 0x0000002800ef7306ULL, 0x000ff00000209400ULL,
0x0000002800ee7306ULL, 0x000ff00000205400ULL, 0x00000028000c7306ULL, 0x000ff0000020d400ULL,
0x0000006000d57306ULL, 0x000ff00000209400ULL, 0x0000006000d67306ULL, 0x000e700000205400ULL,
0x0000009500fa7306ULL, 0x000ff00000209400ULL, 0x0000009500f97306ULL, 0x000fe20000205400ULL,
0x000000d6d500720bULL, 0x002fce0003f7d000ULL, 0x0000009500287306ULL, 0x000ff0000020d400ULL,
0x0000009300c77306ULL, 0x000ff00000209400ULL, 0x0000009300d07306ULL, 0x000e700000205400ULL,
0x0000009300957306ULL, 0x0004f0000020d400ULL, 0x0000000b00eb7306ULL, 0x000fe20000209400ULL,
0x0000010062937824ULL, 0x004fe200078e00ffULL, 0x000000d0c700720bULL, 0x002fcc0003fdd000ULL,
0x0000000b00ea7306ULL, 0x000fee0000205400ULL, 0x0000000195956812ULL, 0x008fe200078efcffULL,
0x0000000b00697306ULL, 0x000ff0000020d400ULL, 0x0000002b00f27306ULL, 0x000ff00000209400ULL,
0x0000002b00f17306ULL, 0x000ff00000205400ULL, 0x0000002b000b7306ULL, 0x000ff0000020d400ULL,
0x000000a200f87306ULL, 0x000ff00000209400ULL, 0x000000a200f77306ULL, 0x000ff00000205400ULL,
0x000000a2002b7306ULL, 0x0003f0000020d400ULL, 0x0000006100cc7306ULL, 0x000fe20000009400ULL,
0x0000010061a27824ULL, 0x002fca00078e00ffULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x0000006100cd7306ULL, 0x000e700000005400ULL, 0x00000061008f7306ULL, 0x0004f0000000d400ULL,
0x0000006000d47306ULL, 0x0008e2000020d400ULL, 0x0001000061617824ULL, 0x004fe200078e00ffULL,
0x000000cdcc00720bULL, 0x002fc80003f3d000ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006200ce7306ULL, 0x000fe20000009400ULL, 0x00000018ff607819ULL, 0x010fe20000011493ULL,
0x0000010063937824ULL, 0x000fca00078e00ffULL, 0x000000018f8f1812ULL, 0x008fe200078efcffULL,
0x0000006000b67306ULL, 0x000fe20000209400ULL, 0x00000001d4d43812ULL, 0x000fe400078efcffULL,
0x000000a7b200720bULL, 0x000fca0003f7d000ULL, 0x0000006000bb7306ULL, 0x000e700000205400ULL,
0x0000006000bd7306ULL, 0x0004e2000020d400ULL, 0x00000001b9b93812ULL, 0x000fce00078efcffULL,
0x0000006200d17306ULL, 0x000f220000005400ULL, 0x0001000063607824ULL, 0x004fe200078e00ffULL,
0x000000bbb600720bULL, 0x002fc80003f9d000ULL, 0x00000018ffd97819ULL, 0x000fe20000011460ULL,
0x000001006c607824ULL, 0x000fe200078e00ffULL, 0x0000006300d27306ULL, 0x000fee0000009400ULL,
0x00000001bdbd4812ULL, 0x008fe200078efcffULL, 0x0000006300d87306ULL, 0x000e620000005400ULL,
0x000000d1ce00720bULL, 0x010fce0003f1d000ULL, 0x0000006100b47306ULL, 0x000ff00000209400ULL,
0x0000006100bf7306ULL, 0x000ea20000205400ULL, 0x000000d8d200720bULL, 0x002fce0003fbd000ULL,
0x0000002700ed7306ULL, 0x000ff00000209400ULL, 0x0000002700ec7306ULL, 0x000fe20000205400ULL,
0x000000bfb400720bULL, 0x004fce0003f5d000ULL, 0x0000002700267306ULL, 0x0003f0000020d400ULL,
0x000000a200c87306ULL, 0x000fe20000209400ULL, 0x00000018ff277819ULL, 0x002fce000001142cULL,
0x000000a200cb7306ULL, 0x000e700000205400ULL, 0x000000a200ba7306ULL, 0x0005f0000020d400ULL,
0x0000006100d37306ULL, 0x000722000020d400ULL, 0x00000018ffa27819ULL, 0x004fc40000011493ULL,
0x000000cbc800720bULL, 0x002fe20003fdd000ULL, 0x000001006fc87824ULL, 0x000fc800078e00ffULL,
0x0000006200c47306ULL, 0x0002a2000000d400ULL, 0x0001000062617824ULL, 0x008fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000002700fc7306ULL, 0x000fe20000209400ULL,
0x00000018ff627819ULL, 0x002fe20000011460ULL, 0x000001006d607824ULL, 0x000fe200078e00ffULL,
0x00000001d3d32812ULL, 0x010fe400078efcffULL, 0x000000a4a600720bULL, 0x000fe20003f5d000ULL,
0x000100006ea47824ULL, 0x000fe200078e00ffULL, 0x00000001baba6812ULL, 0x000fe200078efcffULL,
0x0000002700fb7306ULL, 0x000fe20000205400ULL, 0x00000001c4c40812ULL, 0x004fc400078efcffULL,
0x00000018ffa47819ULL, 0x000fca00000114a4ULL, 0x0000002700687306ULL, 0x000fe4000020d400ULL,
0x00000001c2c22812ULL, 0x000fe400078efcffULL, 0x0000009c9d00720bULL, 0x000fc80003f5d000ULL,
0x000000a500f67306ULL, 0x000ff00000209400ULL, 0x000000a500f57306ULL, 0x000fe20000205400ULL,
0x00000001a8a82812ULL, 0x000fce00078efcffULL, 0x000000a500277306ULL, 0x000ff0000020d400ULL,
0x000000a200b57306ULL, 0x000ff00000209400ULL, 0x000000a200b17306ULL, 0x000e700000205400ULL,
0x000000a200937306ULL, 0x000eb0000020d400ULL, 0x000000d900b07306ULL, 0x000fe20000209400ULL,
0x000000b1b500720bULL, 0x002fc40003f7d000ULL, 0x00000007dbb17812ULL, 0x000fc800078ec0ffULL,
0x00000008b1b17812ULL, 0x000fe200078ef8dbULL, 0x000000d900ac7306ULL, 0x000e6c0000205400ULL,
0x0000000193933812ULL, 0x004fe400078efcffULL, 0x0000006200a27306ULL, 0x000ff00000209400ULL,
0x0000006200a57306ULL, 0x000fe20000205400ULL, 0x000000acb000720bULL, 0x002fce0003f1d000ULL,
0x0000006200c97306ULL, 0x0003f0000020d400ULL, 0x0000006c00c07306ULL, 0x000fe20000009400ULL,
0x000100006c627824ULL, 0x002fce00078e00ffULL, 0x0000006c00cc7306ULL, 0x000e700000005400ULL,
0x0000006c00cd7306ULL, 0x0004f0000000d400ULL, 0x0000006d00d17306ULL, 0x000fe20000009400ULL,
0x000100006d6c7824ULL, 0x004fe200078e00ffULL, 0x000000ccc000720bULL, 0x002fc80003fdd000ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000006d00d27306ULL, 0x000e6e0000005400ULL,
0x00000001cdcd6812ULL, 0x008fe200078efcffULL, 0x0000006d00ce7306ULL, 0x0004f0000000d400ULL,
0x0000006100bc7306ULL, 0x000fe20000209400ULL, 0x000001006e6d7824ULL, 0x004fe200078e00ffULL,
0x000000d2d100720bULL, 0x002fc80003f3d000ULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x0000006100be7306ULL, 0x000e6e0000205400ULL, 0x00000001cece1812ULL, 0x008fe200078efcffULL,
0x000000d900c37306ULL, 0x0004f0000020d400ULL, 0x0000006c00d77306ULL, 0x000fe20000209400ULL,
0x000000bebc00720bULL, 0x002fc40003f9d000ULL, 0x00000018ffd97819ULL, 0x004fca0000011462ULL,
0x0000006c00d87306ULL, 0x000e620000205400ULL, 0x00000001c3c30812ULL, 0x008fe400078efcffULL,
0x000000a5a200720bULL, 0x000fca0003f1d000ULL, 0x0000006c00c77306ULL, 0x000eb0000020d400ULL,
0x0000006d00d57306ULL, 0x000fe20000209400ULL, 0x00000001c9c90812ULL, 0x000fe400078efcffULL,
0x000000d8d700720bULL, 0x002fca0003f3d000ULL, 0x0000006d00d67306ULL, 0x000e700000205400ULL,
0x0000006d00cb7306ULL, 0x000ee2000020d400ULL, 0x00000001c7c71812ULL, 0x004fce00078efcffULL,
0x0000006e006c7306ULL, 0x000fe20000009400ULL, 0x000000d6d500720bULL, 0x002fce0003f5d000ULL,
0x0000006e006d7306ULL, 0x000e6c0000005400ULL, 0x00000001cbcb2812ULL, 0x008fe400078efcffULL,
0x0000006300b87306ULL, 0x0004e2000000d400ULL, 0x000000ada900720bULL, 0x000fce0003f5d000ULL,
0x0000006100cf7306ULL, 0x000f22000020d400ULL, 0x00000018ff637819ULL, 0x004fe40000011460ULL,
0x0000006d6c00720bULL, 0x002fe20003f7d000ULL, 0x00000100646c7824ULL, 0x040fe400078e00ffULL,
0x00010000646d7824ULL, 0x000fe200078e00ffULL, 0x00000001aaaa2812ULL, 0x000fe200078efcffULL,
0x0000006300607306ULL, 0x000fe20000209400ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff6d7819ULL, 0x000fc4000001146dULL, 0x00000001b8b85812ULL, 0x008fc600078efcffULL,
0x0000006300617306ULL, 0x000e620000205400ULL, 0x00000001cfcf4812ULL, 0x010fe400078efcffULL,
0x000000a1a000720bULL, 0x000fca0003f9d000ULL, 0x000000a400d17306ULL, 0x000ff00000209400ULL,
0x000000a400d27306ULL, 0x000ea20000205400ULL, 0x000000616000720bULL, 0x002fe40003f1d000ULL,
0x00000001b7b74812ULL, 0x000fc400078efcffULL, 0x0000009b9000720bULL, 0x000fc60003f9d000ULL,
0x000000a400b07306ULL, 0x000e70000020d400ULL, 0x0000006400a47306ULL, 0x000fe40000009400ULL,
0x00000001a3a34812ULL, 0x000fc400078efcffULL, 0x000000d2d100720bULL, 0x004fc80003f9d000ULL,
0x0000006400a27306ULL, 0x000ff00000005400ULL, 0x0000006400b27306ULL, 0x0005e2000000d400ULL,
0x00000001b0b04812ULL, 0x002fce00078efcffULL, 0x0000006300b37306ULL, 0x000e62000020d400ULL,
0x00000004ff647819ULL, 0x004fc800000116dbULL, 0x0000000764647812ULL, 0x000fc600078e78b1ULL,
0x000000d900627306ULL, 0x000fe40000209400ULL, 0x00000008b1647824ULL, 0x000fca00078e0264ULL,
0x0001200064607811ULL, 0x000fe200078e20ffULL, 0x000000d900637306ULL, 0x000ea20000205400ULL,
0x00000001b3b30812ULL, 0x002fce00078efcffULL, 0x0000006f00a67306ULL, 0x000ff00000009400ULL,
0x0000006f00a77306ULL, 0x000e620000005400ULL, 0x000000636200720bULL, 0x004fe40003fdd000ULL,
0x000000006060783bULL, 0x000fea0000000200ULL, 0x0000006e00cc7306ULL, 0x0004e2000000d400ULL,
0x000000a7a600720bULL, 0x002fe20003fbd000ULL, 0x000100006f6e7824ULL, 0x004fcc00078e00ffULL,
0x0000006c00a17306ULL, 0x000fe20000209400ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000001cccc3812ULL, 0x008fca00078efcffULL, 0x0000006c00a57306ULL, 0x000e620000205400ULL,
0x000000948e00720bULL, 0x000fe20003f7d000ULL, 0x00000100498e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001148eULL, 0x0000006c00bf7306ULL, 0x0004ec000020d400ULL,
0x0000000189893812ULL, 0x000fe400078efcffULL, 0x0000006d00a77306ULL, 0x000fe20000209400ULL,
0x0000000aff6c723eULL, 0x004fc400000010ffULL, 0x000000a5a100720bULL, 0x002fca0003f9d000ULL,
0x0000006d00a07306ULL, 0x000e700000205400ULL, 0x0000006d00907306ULL, 0x0005e2000020d400ULL,
0x00000001bfbf4812ULL, 0x008fce00078efcffULL, 0x0000006f00bb7306ULL, 0x000722000000d400ULL,
0x00000002ff6d7819ULL, 0x004fe400000116dbULL, 0x000000a0a700720bULL, 0x002fca0003f9d000ULL,
0x0000006e00b57306ULL, 0x000fe20000209400ULL, 0x000000086d6f7810ULL, 0x008fce0007ffe0ffULL,
0x0000006e00b67306ULL, 0x000fe20000205400ULL, 0x00000001bbbb5812ULL, 0x010fe400078efcffULL,
0x0000000190904812ULL, 0x000fca00078efcffULL, 0x0000006e00ac7306ULL, 0x0003f0000020d400ULL,
0x000000d900ca7306ULL, 0x0004e2000020d400ULL, 0x000054106c6e7816ULL, 0x002fca000000006cULL,
0x00001f6d6e6d7589ULL, 0x000e6400000e0000ULL, 0x0000006500bc7306ULL, 0x000fe20000009400ULL,
0x00000018ffd97819ULL, 0x004fe200000114c8ULL, 0x00001f6f6e6c7589ULL, 0x00052c00000e0000ULL,
0x000000d900c87306ULL, 0x000fe20000209400ULL, 0x00000001caca6812ULL, 0x008fc400078efcffULL,
0x000000c59100720bULL, 0x000fe40003fdd000ULL, 0x00000092956e723eULL, 0x004fe200000010ffULL,
0x0000010066927824ULL, 0x000fe200078e00ffULL, 0x0000008fba6f723eULL, 0x000fe200000010ffULL,
0x000000d900d07306ULL, 0x000ea60000205400ULL, 0x00000018ff927819ULL, 0x000fca0000011492ULL,
0x000000d900b47306ULL, 0x000662000020d400ULL, 0x00000001abab6812ULL, 0x000fce00078efcffULL,
0x0000006500a67306ULL, 0x000f220000005400ULL, 0x0001000065d97824ULL, 0x008fe200078e00ffULL,
0x000000d0c800720bULL, 0x004fc80003f3d000ULL, 0x00000018ffd97819ULL, 0x000fe400000114d9ULL,
0x0000006500be7306ULL, 0x0004ee000000d400ULL, 0x00000001b4b41812ULL, 0x002fe200078efcffULL,
0x0000006600c57306ULL, 0x000fe20000005400ULL, 0x000000ffff657224ULL, 0x004fe200078e0096ULL,
0x000000b6b500720bULL, 0x000fc40003f3d000ULL, 0x000000a6bc00720bULL, 0x010fe40003fbd000ULL,
0x000000ff6500720cULL, 0x000fe40003f05270ULL, 0x0000006700c87306ULL, 0x000fee0000005400ULL,
0x00000001acac1812ULL, 0x000fe200078efcffULL, 0x000000d9009b7306ULL, 0x000fe20000209400ULL,
0x000000a2a400720bULL, 0x000fc40003f3d000ULL, 0x0000006d60608231ULL, 0x080fe200003400ffULL,
0x00000001bebe5812ULL, 0x008fe200078efcffULL, 0x0000006d62628231ULL, 0x000fe400003400ffULL,
0x0000006c61618231ULL, 0x080fe200003400ffULL, 0x000000d900967306ULL, 0x000e620000205400ULL,
0x0000006c63638231ULL, 0x000fca00003400ffULL, 0x00000001b2b21812ULL, 0x000fe400078efcffULL,
0x0000006e604c723cULL, 0x000fe2000004184cULL, 0x000000d9008f7306ULL, 0x000ea2000020d400ULL,
0x0000008c8d00720bULL, 0x000fe20003f3d000ULL, 0x000001004a8c7824ULL, 0x000fe400078e00ffULL,
0x000001004b8d7824ULL, 0x000fe400078e00ffULL, 0x00000100676e7824ULL, 0x000fe200078e00ffULL,
0x000000d3b96f723eULL, 0x000fe200000010ffULL, 0x0000009200657306ULL, 0x000fe20000209400ULL,
0x000000969b00720bULL, 0x002fc40003f7d000ULL, 0x00000018ffd77819ULL, 0x000fe4000001146eULL,
0x000000d4c66e723eULL, 0x000fe400000010ffULL, 0x0000000179791812ULL, 0x000fe200078efcffULL,
0x0000006600c67306ULL, 0x000e620000009400ULL, 0x0000008a8b00720bULL, 0x000fe20003f3d000ULL,
0x000100004b8a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000006e6050723cULL, 0x000fe20000041850ULL, 0x00000018ff8c7819ULL, 0x000fc4000001148cULL,
0x000000018f8f3812ULL, 0x004fe200078efcffULL, 0x0000009200957306ULL, 0x000ea20000205400ULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x000000c4bd6e723eULL, 0x000fe400000010ffULL,
0x000000b8936f723eULL, 0x000fe400000010ffULL, 0x0000000180801812ULL, 0x000fe200078efcffULL,
0x0000006600937306ULL, 0x0007e2000000d400ULL, 0x000000c5c600720bULL, 0x002fc60003f5d000ULL,
0x0000006e6054723cULL, 0x000fe80000041854ULL, 0x0000006700c47306ULL, 0x000e620000009400ULL,
0x000000956500720bULL, 0x004fe40003f7d000ULL, 0x00010000666e7824ULL, 0x000fe200078e00ffULL,
0x000000c3b76f723eULL, 0x000fe200000010ffULL, 0x0001000067667824ULL, 0x008fc600078e00ffULL,
0x00000018ffd07819ULL, 0x000fe2000001146eULL, 0x0000006700b87306ULL, 0x0004e2000000d400ULL,
0x000000cfc26e723eULL, 0x000fe400000010ffULL, 0x00000018ffcf7819ULL, 0x000fe40000011466ULL,
0x000000cdc966723eULL, 0x000fe400000010ffULL, 0x000000c8c400720bULL, 0x002fe20003fdd000ULL,
0x0000006e605c723cULL, 0x000fe2000004185cULL, 0x000000ceb367723eULL, 0x004fe200000010ffULL,
0x0000009200927306ULL, 0x000e62000020d400ULL, 0x0000000193932812ULL, 0x000fc400078efcffULL,
0x000000888700720bULL, 0x000fe20003f5d000ULL, 0x0000010030877824ULL, 0x000fe400078e00ffULL,
0x000000666058723cULL, 0x000fe20000041858ULL, 0x00000100446e7824ULL, 0x000fe200078e00ffULL,
0x000000d700ba7306ULL, 0x000fe20000209400ULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000001b8b86812ULL, 0x008fe400078efcffULL, 0x000000caa866723eULL, 0x000fe200000010ffULL,
0x0000010045a87824ULL, 0x000fe200078e00ffULL, 0x000000c7a367723eULL, 0x000fe200000010ffULL,
0x000000d700b97306ULL, 0x000ea20000205400ULL, 0x00000018ffcd7819ULL, 0x000fc4000001146eULL,
0x0000000192923812ULL, 0x002fe400078efcffULL, 0x00000018ffce7819ULL, 0x000fe200000114a8ULL,
0x000000666034723cULL, 0x000fe20000041834ULL, 0x000000017a7a2812ULL, 0x000fe200078efcffULL,
0x0000004600d37306ULL, 0x000fe20000009400ULL, 0x000000868500720bULL, 0x000fc80003f5d000ULL,
0x000000cccb66723eULL, 0x000fe400000010ffULL, 0x000000bbb467723eULL, 0x000fe200000010ffULL,
0x0000004600dd7306ULL, 0x000fe20000005400ULL, 0x000000b9ba00720bULL, 0x004fca0003f7d000ULL,
0x000000666038723cULL, 0x000fe20000041838ULL, 0x0000000178782812ULL, 0x000fe200078efcffULL,
0x0000004600b57306ULL, 0x000fea000000d400ULL, 0x000000b0ab66723eULL, 0x000fe200000010ffULL,
0x0001000044ab7824ULL, 0x000fe200078e00ffULL, 0x000000acaa67723eULL, 0x000fe200000010ffULL,
0x000000da009d7306ULL, 0x000fe60000209400ULL, 0x00000018ffab7819ULL, 0x000fc600000114abULL,
0x000000666060723cULL, 0x000fe4000004183cULL, 0x000000da009c7306ULL, 0x000e6a0000205400ULL,
0x00010000453c7824ULL, 0x000fe400078e00ffULL, 0x00000100463d7824ULL, 0x000fe200078e00ffULL,
0x000000cf00c37306ULL, 0x000fe20000209400ULL, 0x00000100473e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff3d7819ULL, 0x000fc8000001143dULL,
0x0000003c00d57306ULL, 0x000fe20000209400ULL, 0x0000009c9d00720bULL, 0x002fce0003f9d000ULL,
0x0000003c00d47306ULL, 0x000ff00000205400ULL, 0x0000003c00b67306ULL, 0x0003f0000020d400ULL,
0x000000cf006f7306ULL, 0x000ea20000205400ULL, 0x00010000463c7824ULL, 0x002fc400078e00ffULL,
0x0000010048467824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004700d67306ULL, 0x000fe20000009400ULL, 0x00000018ff467819ULL, 0x000fce0000011446ULL,
0x0000004700d97306ULL, 0x000e620000005400ULL, 0x0000006fc300720bULL, 0x004fce0003fdd000ULL,
0x000000cd006e7306ULL, 0x000ff00000209400ULL, 0x000000cd00c97306ULL, 0x000fe20000205400ULL,
0x000000d9d600720bULL, 0x002fce0003f3d000ULL, 0x000000cd00a37306ULL, 0x000ff0000020d400ULL,
0x000000d700917306ULL, 0x000e70000020d400ULL, 0x0000003d00cc7306ULL, 0x000ff00000209400ULL,
0x0000003d00cd7306ULL, 0x000fe20000205400ULL, 0x0000000191913812ULL, 0x002fce00078efcffULL,
0x0000003d00b47306ULL, 0x0003f0000020d400ULL, 0x000000d000bd7306ULL, 0x000fe20000209400ULL,
0x00010000473d7824ULL, 0x002fce00078e00ffULL, 0x000000d000c27306ULL, 0x000e700000205400ULL,
0x0000004700ac7306ULL, 0x000eb0000000d400ULL, 0x0000003c00667306ULL, 0x000fe20000209400ULL,
0x000000c2bd00720bULL, 0x002fce0003f7d000ULL, 0x0000003c00677306ULL, 0x000fe20000205400ULL,
0x00000001acac1812ULL, 0x004fce00078efcffULL, 0x0000003c00ad7306ULL, 0x000ff0000020d400ULL,
0x00000046003c7306ULL, 0x000ff00000209400ULL, 0x0000004600477306ULL, 0x000ff00000205400ULL,
0x0000004600a67306ULL, 0x0003f0000020d400ULL, 0x000000da00c07306ULL, 0x000ea2000020d400ULL,
0x0001000049467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x000000d000b77306ULL, 0x000e70000020d400ULL, 0x0000004400d07306ULL, 0x000fe20000009400ULL,
0x00000001c0c04812ULL, 0x004fce00078efcffULL, 0x0000004400d27306ULL, 0x000ea20000005400ULL,
0x00000001b7b73812ULL, 0x002fe400078efcffULL, 0x000000ddd300720bULL, 0x000fca0003f7d000ULL,
0x0000004400a97306ULL, 0x0002f0000000d400ULL, 0x0000004500da7306ULL, 0x000fe20000009400ULL,
0x00000018ff447819ULL, 0x002fe4000001143eULL, 0x000000d2d000720bULL, 0x004fc40003f9d000ULL,
0x00000001b5b53812ULL, 0x000fe400078efcffULL, 0x0000007e7d00720bULL, 0x000fe20003f7d000ULL,
0x0000004500db7306ULL, 0x000e700000005400ULL, 0x0000004500b07306ULL, 0x0005e2000000d400ULL,
0x00000001a9a94812ULL, 0x008fc400078efcffULL, 0x000000838100720bULL, 0x000fe40003f9d000ULL,
0x0000000175753812ULL, 0x000fe400078efcffULL, 0x0000007b7c00720bULL, 0x000fe20003f7d000ULL,
0x000000cf00b37306ULL, 0x000ee2000020d400ULL, 0x00000018ff457819ULL, 0x004fe4000001143dULL,
0x000000dbda00720bULL, 0x002fca0003fbd000ULL, 0x00000044003e7306ULL, 0x000fe20000209400ULL,
0x0000000177774812ULL, 0x000fe400078efcffULL, 0x000000827f00720bULL, 0x000fe40003f9d000ULL,
0x0000000174743812ULL, 0x000fc600078efcffULL, 0x00000044003f7306ULL, 0x000e620000205400ULL,
0x00000001b3b36812ULL, 0x008fe400078efcffULL, 0x000000c96e00720bULL, 0x000fe40003fdd000ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x000000d4d500720bULL, 0x000fe20003fbd000ULL,
0x0000004400aa7306ULL, 0x000fe2000020d400ULL, 0x0000000176764812ULL, 0x000fce00078efcffULL,
0x0000004900c57306ULL, 0x000fe20000009400ULL, 0x00000001a3a36812ULL, 0x000fc600078efcffULL,
0x00000001b6b65812ULL, 0x000fe400078efcffULL, 0x000000cdcc00720bULL, 0x000fe40003fbd000ULL,
0x0000004900c67306ULL, 0x000eb00000005400ULL, 0x0000004900a57306ULL, 0x000ee6000000d400ULL,
0x00000001b4b45812ULL, 0x000fc400078efcffULL, 0x0000003f3e00720bULL, 0x002fc60003fbd000ULL,
0x0000004500447306ULL, 0x000fe20000209400ULL, 0x000000c6c500720bULL, 0x004fce0003f5d000ULL,
0x00000045003d7306ULL, 0x000e640000205400ULL, 0x00000001aaaa5812ULL, 0x000fe400078efcffULL,
0x000000676600720bULL, 0x000fe40003fbd000ULL, 0x00000001a5a52812ULL, 0x008fe400078efcffULL,
0x0000004600497306ULL, 0x000ff00000209400ULL, 0x0000004600c47306ULL, 0x000ea20000205400ULL,
0x0000003d4400720bULL, 0x002fc40003f3d000ULL, 0x00000001adad5812ULL, 0x000fc800078efcffULL,
0x000000ad7676723eULL, 0x000fe200000010ffULL, 0x00000046009d7306ULL, 0x0002f0000020d400ULL,
0x0000004a00de7306ULL, 0x000fe20000009400ULL, 0x000100004a467824ULL, 0x002fe200078e00ffULL,
0x000000c44900720bULL, 0x004fc80003f7d000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004a00df7306ULL, 0x000e6e0000005400ULL, 0x000000019d9d3812ULL, 0x008fe200078efcffULL,
0x0000004a009c7306ULL, 0x000eb0000000d400ULL, 0x00000046004a7306ULL, 0x000fe20000209400ULL,
0x000000dfde00720bULL, 0x002fce0003fbd000ULL, 0x0000004600da7306ULL, 0x000fec0000205400ULL,
0x000000019c9c5812ULL, 0x004fe400078efcffULL, 0x0000004600967306ULL, 0x0003e2000020d400ULL,
0x000000afae00720bULL, 0x000fce0003fbd000ULL, 0x000000ce00c77306ULL, 0x000fe20000209400ULL,
0x0000010031467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x000000ce00ca7306ULL, 0x000e620000205400ULL, 0x0000000172725812ULL, 0x000fce00078efcffULL,
0x000000ab00cb7306ULL, 0x000ff00000209400ULL, 0x000000ab00d77306ULL, 0x000fe20000205400ULL,
0x000000cac700720bULL, 0x002fce0003fdd000ULL, 0x000000ab00bb7306ULL, 0x000ff0000020d400ULL,
0x0000004500ab7306ULL, 0x0002b0000020d400ULL, 0x0000008e00a17306ULL, 0x000fe20000209400ULL,
0x0001000048457824ULL, 0x002fce00078e00ffULL, 0x0000008e00a07306ULL, 0x000fe20000205400ULL,
0x00000001abab1812ULL, 0x004fe400078efcffULL, 0x000000473c00720bULL, 0x000fca0003f3d000ULL,
0x0000008e00a77306ULL, 0x000ff0000020d400ULL, 0x0000004600d27306ULL, 0x000fe20000209400ULL,
0x00000001a6a61812ULL, 0x000fce00078efcffULL, 0x0000004600d37306ULL, 0x000e700000205400ULL,
0x0000004600887306ULL, 0x0004f0000020d400ULL, 0x0000003000c37306ULL, 0x000fe20000009400ULL,
0x0001000030467824ULL, 0x004fe200078e00ffULL, 0x000000d3d200720bULL, 0x002fc80003fbd000ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000003000e27306ULL, 0x000e6e0000005400ULL,
0x0000000188885812ULL, 0x008fe200078efcffULL, 0x00000030008e7306ULL, 0x0004f0000000d400ULL,
0x000000ce00a87306ULL, 0x0008e2000020d400ULL, 0x0001000031307824ULL, 0x004fe200078e00ffULL,
0x000000e2c300720bULL, 0x002fc80003f7d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000004800d87306ULL, 0x000fe20000009400ULL, 0x00000018ffce7819ULL, 0x010fcc0000011445ULL,
0x000000018e8e3812ULL, 0x008fe200078efcffULL, 0x0000004800bc7306ULL, 0x000e620000005400ULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x000000d7cb00720bULL, 0x000fca0003fdd000ULL,
0x0000004800a47306ULL, 0x000eb0000000d400ULL, 0x000000ce00457306ULL, 0x000fe20000209400ULL,
0x00000001bbbb6812ULL, 0x000fe400078efcffULL, 0x000000bcd800720bULL, 0x002fca0003fdd000ULL,
0x000000ce00487306ULL, 0x000e700000205400ULL, 0x0000003000ca7306ULL, 0x000fe20000209400ULL,
0x00000001a4a46812ULL, 0x004fe400078efcffULL, 0x0000009a9900720bULL, 0x000fca0003fdd000ULL,
0x0000003000d67306ULL, 0x000fe20000205400ULL, 0x000000484500720bULL, 0x002fce0003f3d000ULL,
0x0000003000857306ULL, 0x0003e2000020d400ULL, 0x0000000173736812ULL, 0x000fe400078efcffULL,
0x000000da4a00720bULL, 0x000fca0003fdd000ULL, 0x0000008d00d17306ULL, 0x000fe20000209400ULL,
0x0001000032307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000008d00d07306ULL, 0x000e620000205400ULL, 0x0000000196966812ULL, 0x000fc800078efcffULL,
0x000000967272723eULL, 0x000fc600000010ffULL, 0x0000004600d97306ULL, 0x000ff00000209400ULL,
0x0000004600dd7306ULL, 0x000fe20000205400ULL, 0x000000d0d100720bULL, 0x002fe40003f5d000ULL,
0x0000000000d17919ULL, 0x000e6a0000000000ULL, 0x00000046008b7306ULL, 0x0005f0000020d400ULL,
0x000000ce00a27306ULL, 0x000ee2000020d400ULL, 0x0000010033467824ULL, 0x004fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011446ULL, 0x0000003000c57306ULL, 0x000ff00000209400ULL,
0x0000003000c67306ULL, 0x000fe20000205400ULL, 0x00000001a2a21812ULL, 0x008fc400078efcffULL,
0x000000a0a100720bULL, 0x000fe40003f3d000ULL, 0x000000a27474723eULL, 0x000fc600000010ffULL,
0x0000003000837306ULL, 0x0005f0000020d400ULL, 0x0000006f00467306ULL, 0x000fe20000209400ULL,
0x0000010041307824ULL, 0x004fe200078e00ffULL, 0x00000001a7a71812ULL, 0x000fc800078efcffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000006f00c77306ULL, 0x000ff00000205400ULL,
0x0000006f00817306ULL, 0x000ff0000020d400ULL, 0x0000003000b97306ULL, 0x000ff00000209400ULL,
0x0000003000ba7306ULL, 0x000ff00000205400ULL, 0x00000030006f7306ULL, 0x0005f0000020d400ULL,
0x0000008c00cf7306ULL, 0x000fe20000209400ULL, 0x0001000040307824ULL, 0x004fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000008c00ce7306ULL, 0x000eb00000205400ULL,
0x0000008c009b7306ULL, 0x000ef0000020d400ULL, 0x0000004b00657306ULL, 0x000fe20000009400ULL,
0x000000cecf00720bULL, 0x004fce0003f3d000ULL, 0x0000004b00e07306ULL, 0x000eac0000005400ULL,
0x000000019b9b1812ULL, 0x008fe400078efcffULL, 0x0000004b00957306ULL, 0x000ee4000000d400ULL,
0x0000009c9b9c723eULL, 0x000fcc00000010ffULL, 0x0000008a004b7306ULL, 0x000fe20000209400ULL,
0x000000e06500720bULL, 0x004fce0003f9d000ULL, 0x0000008a00db7306ULL, 0x000eac0000205400ULL,
0x0000000195954812ULL, 0x008fe400078efcffULL, 0x0000008a008c7306ULL, 0x000ef0000020d400ULL,
0x00000031006e7306ULL, 0x000fe20000009400ULL, 0x000000db4b00720bULL, 0x004fce0003f9d000ULL,
0x0000003100e37306ULL, 0x000eac0000005400ULL, 0x000000018c8c4812ULL, 0x008fe400078efcffULL,
0x00000031008a7306ULL, 0x000730000000d400ULL, 0x0000003000d87306ULL, 0x000fe20000209400ULL,
0x0000010032317824ULL, 0x008fe200078e00ffULL, 0x000000e36e00720bULL, 0x004fc80003f3d000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000d77306ULL, 0x000fee0000205400ULL,
0x000000018a8a1812ULL, 0x010fe200078efcffULL, 0x00000030007c7306ULL, 0x0005f0000020d400ULL,
0x0000008d00947306ULL, 0x000ee2000020d400ULL, 0x0000010043307824ULL, 0x004fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100c87306ULL, 0x000ff00000209400ULL,
0x0000003100c97306ULL, 0x000fe20000205400ULL, 0x0000000194942812ULL, 0x008fc400078efcffULL,
0x000000c19f00720bULL, 0x000fca0003f5d000ULL, 0x0000003100867306ULL, 0x0005f0000020d400ULL,
0x0000003000997306ULL, 0x000fe20000209400ULL, 0x0001000033317824ULL, 0x004fe200078e00ffULL,
0x0000000171712812ULL, 0x000fc400078efcffULL, 0x000000ddd900720bULL, 0x000fe40003f5d000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000030009a7306ULL, 0x000ff00000205400ULL,
0x0000003000497306ULL, 0x0005e2000020d400ULL, 0x000000018b8b2812ULL, 0x000fc400078efcffULL,
0x000000978400720bULL, 0x000fca0003f5d000ULL, 0x0000008700c27306ULL, 0x000fe20000209400ULL,
0x0001000042307824ULL, 0x004fce00078e00ffULL, 0x0000008700dc7306ULL, 0x000ea20000205400ULL,
0x000000016b6b2812ULL, 0x000fe400078efcffULL, 0x000000c74600720bULL, 0x000fca0003f5d000ULL,
0x00000087008d7306ULL, 0x000ef0000020d400ULL, 0x0000003200d47306ULL, 0x000fe20000009400ULL,
0x0000000181812812ULL, 0x000fe400078efcffULL, 0x000000dcc200720bULL, 0x004fca0003fdd000ULL,
0x0000003200d57306ULL, 0x000eb00000005400ULL, 0x0000003200877306ULL, 0x000862000000d400ULL,
0x000000018d8d6812ULL, 0x008fe400078efcffULL, 0x0000009e9800720bULL, 0x000fca0003fdd000ULL,
0x00000040003d7306ULL, 0x000fe20000009400ULL, 0x0000010040327824ULL, 0x010fe200078e00ffULL,
0x000000d5d400720bULL, 0x004fc80003f9d000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000004000447306ULL, 0x000ea20000005400ULL, 0x0000000170706812ULL, 0x000fe400078efcffULL,
0x000000d6ca00720bULL, 0x000fe40003fdd000ULL, 0x0000008b7070723eULL, 0x000fe400000010ffULL,
0x0000000187874812ULL, 0x002fe200078efcffULL, 0x00000040007f7306ULL, 0x0002e2000000d400ULL,
0x000000c6c500720bULL, 0x000fce0003f9d000ULL, 0x00000031003e7306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x002fe40000011430ULL, 0x00000002d1307811ULL, 0x000fe400078fe0ffULL,
0x000000443d00720bULL, 0x004fe40003fbd000ULL, 0x0000000730307812ULL, 0x000fe200078e78b1ULL,
0x00000031003f7306ULL, 0x000e620000205400ULL, 0x000000bec03d723eULL, 0x000fe200000010ffULL,
0x000001002dbe7824ULL, 0x000fe200078e00ffULL, 0x0000000183834812ULL, 0x000fe200078efcffULL,
0x00000008b16e7824ULL, 0x000fe200078e0230ULL, 0x000000eaeb00720bULL, 0x000fe20003f9d000ULL,
0x000100002dc07824ULL, 0x000fe200078e00ffULL, 0x0000000185856812ULL, 0x000fe200078efcffULL,
0x00000031007d7306ULL, 0x000522000020d400ULL, 0x000120006e307811ULL, 0x000fc400078e20ffULL,
0x000000c9c800720bULL, 0x000fe40003fdd000ULL, 0x00000018ffbe7819ULL, 0x000fe400000114beULL,
0x000000017f7f5812ULL, 0x008fe200078efcffULL, 0x0000003200bd7306ULL, 0x000fe20000209400ULL,
0x0001000041317824ULL, 0x004fe200078e00ffULL, 0x0000003f3e00720bULL, 0x002fe40003f5d000ULL,
0x0000000169694812ULL, 0x000fe400078efcffULL, 0x00000018ff317819ULL, 0x000fc40000011431ULL,
0x0000003200bc7306ULL, 0x000e620000205400ULL, 0x000000bab900720bULL, 0x000fe40003f9d000ULL,
0x0000000186866812ULL, 0x000fe400078efcffULL, 0x000000e8e900720bULL, 0x000fe40003fdd000ULL,
0x000000017d7d2812ULL, 0x010fe200078efcffULL, 0x00000032007e7306ULL, 0x0004e2000020d400ULL,
0x00000018ffc07819ULL, 0x000fe400000114c0ULL, 0x000000eced00720bULL, 0x000fc40003fbd000ULL,
0x000000878686723eULL, 0x000fe400000010ffULL, 0x000000016f6f4812ULL, 0x000fe200078efcffULL,
0x0000003100df7306ULL, 0x000fe20000209400ULL, 0x0000010042327824ULL, 0x004fe200078e00ffULL,
0x000000bcbd00720bULL, 0x002fe40003f5d000ULL, 0x000000016a6a6812ULL, 0x000fe400078efcffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003100de7306ULL, 0x000e620000205400ULL,
0x000000836a6a723eULL, 0x000fc400000010ffULL, 0x0000000126265812ULL, 0x000fc800078efcffULL,
0x000000017e7e2812ULL, 0x008fe200078efcffULL, 0x0000003100657306ULL, 0x0004e2000020d400ULL,
0x000000d7d800720bULL, 0x000fe40003f5d000ULL, 0x0000007f7e7e723eULL, 0x000fca00000010ffULL,
0x00000041003c7306ULL, 0x000fe20000009400ULL, 0x0001000043317824ULL, 0x004fe200078e00ffULL,
0x000000dedf00720bULL, 0x002fc80003f9d000ULL, 0x000000017c7c2812ULL, 0x000fe400078efcffULL,
0x0000004100e07306ULL, 0x000e640000005400ULL, 0x0000007c267c723eULL, 0x000fca00000010ffULL,
0x0000000165654812ULL, 0x008fe200078efcffULL, 0x00000041007b7306ULL, 0x0004e2000000d400ULL,
0x0000009a9900720bULL, 0x000fce0003f9d000ULL, 0x0000003300cc7306ULL, 0x000fe20000009400ULL,
0x00000018ff417819ULL, 0x004fe40000011431ULL, 0x000000e03c00720bULL, 0x002fe40003f3d000ULL,
0x000000b2bf3c723eULL, 0x000fe400000010ffULL, 0x0000000149494812ULL, 0x000fe200078efcffULL,
0x0000003300cd7306ULL, 0x000e700000005400ULL, 0x0000003300827306ULL, 0x000ea2000000d400ULL,
0x000000017b7b1812ULL, 0x008fc400078efcffULL, 0x000000eeef00720bULL, 0x000fe40003f3d000ULL,
0x0000007b6f7f723eULL, 0x000fc600000010ffULL, 0x0000003200a07306ULL, 0x000fe20000209400ULL,
0x000000cdcc00720bULL, 0x002fce0003f7d000ULL, 0x0000003200a17306ULL, 0x000e620000205400ULL,
0x000000010c0c1812ULL, 0x000fca00078efcffULL, 0x0000000182823812ULL, 0x004fe400078efcffULL,
0x0000003200677306ULL, 0x0004e4000020d400ULL, 0x000000828187723eULL, 0x000fcc00000010ffULL,
0x0000004000ce7306ULL, 0x000fe20000209400ULL, 0x000000003030783bULL, 0x004ea20000000200ULL,
0x000000a1a000720bULL, 0x002fcc0003f5d000ULL, 0x0000004000cb7306ULL, 0x000e6e0000205400ULL,
0x0000000167672812ULL, 0x008fe200078efcffULL, 0x00000040004b7306ULL, 0x000730000020d400ULL,
0x0000004100d07306ULL, 0x000fe20000209400ULL, 0x000001002c407824ULL, 0x008fe200078e00ffULL,
0x000000cbce00720bULL, 0x002fcc0003f5d000ULL, 0x0000004100cf7306ULL, 0x000e6e0000205400ULL,
0x000000014b4b2812ULL, 0x010fe200078efcffULL, 0x0000004100477306ULL, 0x000722000020d400ULL,
0x0000006d30308231ULL, 0x084fe400003400ffULL, 0x0000006d32328231ULL, 0x000fc400003400ffULL,
0x0000006c31318231ULL, 0x080fe400003400ffULL, 0x0000006c33338231ULL, 0x000fe200003400ffULL,
0x0000004200c37306ULL, 0x000fe20000009400ULL, 0x00000018ff417819ULL, 0x008fe40000011440ULL,
0x00000006d1407811ULL, 0x000fe400078fe0ffULL, 0x000000cfd000720bULL, 0x002fe20003f9d000ULL,
0x0000003c304c723cULL, 0x000fe2000004184cULL, 0x0000000740407812ULL, 0x000fe200078e78b1ULL,
0x0000004200c47306ULL, 0x000e6a0000005400ULL, 0x00000090893c723eULL, 0x000fc400000010ffULL,
0x0000008f793d723eULL, 0x000fe200000010ffULL, 0x0000004200667306ULL, 0x000fe4000000d400ULL,
0x0000000147474812ULL, 0x010fc800078efcffULL, 0x0000003c3050723cULL, 0x000fe40000041850ULL,
0x0000004300c17306ULL, 0x000fe20000009400ULL, 0x000000c4c300720bULL, 0x002fc80003f7d000ULL,
0x00000004d13c7811ULL, 0x000fe400078fe0ffULL, 0x000000b8913d723eULL, 0x000fe200000010ffULL,
0x0000004300c27306ULL, 0x000e620000005400ULL, 0x000000073c3c7812ULL, 0x000fe200078e78b1ULL,
0x000001002eb87824ULL, 0x000fc800078e00ffULL, 0x00000008b1b27824ULL, 0x040fe200078e023cULL,
0x00000093923c723eULL, 0x000fe200000010ffULL, 0x00000008b1b17824ULL, 0x000fe200078e0240ULL,
0x00000043004a7306ULL, 0x000ea2000000d400ULL, 0x000000b78092723eULL, 0x000fe200000010ffULL,
0x000001002fb77824ULL, 0x000fe200078e00ffULL, 0x00012000b2407811ULL, 0x000fe400078e20ffULL,
0x0000003c3054723cULL, 0x000fe20000041854ULL, 0x000000b37a93723eULL, 0x000fe200000010ffULL,
0x000100002c7a7824ULL, 0x000fe200078e00ffULL, 0x00000041008f7306ULL, 0x000fe20000209400ULL,
0x000100002eb37824ULL, 0x000fe200078e00ffULL, 0x000000c2c100720bULL, 0x002fc40003fdd000ULL,
0x00012000b13c7811ULL, 0x000fe200078e20ffULL, 0x00000092305c723cULL, 0x000fe2000004185cULL,
0x00000018ffbf7819ULL, 0x000fe4000001147aULL, 0x0000004100907306ULL, 0x000e620000205400ULL,
0x00000018ffb87819ULL, 0x000fe200000114b8ULL, 0x000000003c3c783bULL, 0x000ee20000000200ULL,
0x00000018ffb77819ULL, 0x000fe400000114b7ULL, 0x000000a9a392723eULL, 0x000fe400000010ffULL,
0x000000b0a893723eULL, 0x000fe200000010ffULL, 0x0000004100797306ULL, 0x000862000020d400ULL,
0x000000014a4a6812ULL, 0x004fc400078efcffULL, 0x000000f3f400720bULL, 0x000fe40003fdd000ULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x000000923058723cULL, 0x000fe20000041858ULL,
0x0000000166663812ULL, 0x000fe200078efcffULL, 0x0000002d009e7306ULL, 0x000fe20000009400ULL,
0x000000004040783bULL, 0x010ea20000000200ULL, 0x000000908f00720bULL, 0x002fe40003f5d000ULL,
0x000000f1f200720bULL, 0x000fe40003f7d000ULL, 0x000000b5b492723eULL, 0x000fc400000010ffULL,
0x0000002d009f7306ULL, 0x000e620000005400ULL, 0x000000acaa93723eULL, 0x000fe400000010ffULL,
0x0000000129296812ULL, 0x000fe400078efcffULL, 0x000000fbfc00720bULL, 0x000fe40003fdd000ULL,
0x0000000179792812ULL, 0x000fe200078efcffULL, 0x0000002d00457306ULL, 0x0008a2000000d400ULL,
0x000000923038723cULL, 0x000fe20000041838ULL, 0x000000666766723eULL, 0x000fc400000010ffULL,
0x0000004a4967723eULL, 0x000fe400000010ffULL, 0x000000010b0b3812ULL, 0x000fe400078efcffULL,
0x0000002f00847306ULL, 0x000fe20000009400ULL, 0x000100002f2d7824ULL, 0x010fe200078e00ffULL,
0x0000006d3c3c8231ULL, 0x088fe200003400ffULL, 0x0000009f9e00720bULL, 0x002fe20003fbd000ULL,
0x0000006d3e3e8231ULL, 0x000fe200003400ffULL, 0x0000000168686812ULL, 0x000fe200078efcffULL,
0x0000006c3d3d8231ULL, 0x080fe200003400ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000002f00897306ULL, 0x000e620000005400ULL, 0x0000006c3f3f8231ULL, 0x000fe200003400ffULL,
0x000000f5f600720bULL, 0x000fcc0003fdd000ULL, 0x0000002f00467306ULL, 0x0007e2000000d400ULL,
0x0000006d40408231ULL, 0x084fe200003400ffULL, 0x0000000145455812ULL, 0x000fe200078efcffULL,
0x0000006d42428231ULL, 0x000fe200003400ffULL, 0x000000f7f800720bULL, 0x000fe20003fbd000ULL,
0x0000006c41418231ULL, 0x080fe400003400ffULL, 0x0000006c43438231ULL, 0x000fe200003400ffULL,
0x0000002e00977306ULL, 0x000fe20000009400ULL, 0x000000b6772f723eULL, 0x008fe400000010ffULL,
0x000000ab7577723eULL, 0x000fc400000010ffULL, 0x0000009d7375723eULL, 0x000fe200000010ffULL,
0x000000864038723cULL, 0x000fe20000041838ULL, 0x0000008c7173723eULL, 0x000fe200000010ffULL,
0x0000002e00987306ULL, 0x000ea20000005400ULL, 0x000000856b71723eULL, 0x000fe400000010ffULL,
0x00000095949d723eULL, 0x000fe400000010ffULL, 0x0000007d696b723eULL, 0x000fe200000010ffULL,
0x000000763060723cULL, 0x000fe20000041860ULL, 0x000000650c7d723eULL, 0x000fe200000010ffULL,
0x0000002e00447306ULL, 0x000722000000d400ULL, 0x000000898400720bULL, 0x002fc40003f7d000ULL,
0x000000012b2b5812ULL, 0x000fe400078efcffULL, 0x0000000127276812ULL, 0x000fe200078efcffULL,
0x000000744050723cULL, 0x000fe40000041850ULL, 0x000000be00917306ULL, 0x000fe20000209400ULL,
0x000000bb782e723eULL, 0x008fe400000010ffULL, 0x000000989700720bULL, 0x004fc60003f3d000ULL,
0x0000009c4054723cULL, 0x000fe20000041854ULL, 0x0000000146463812ULL, 0x000fe200078efcffULL,
0x000000be00807306ULL, 0x000e6c0000205400ULL, 0x0000002e3034723cULL, 0x000fe40000041834ULL,
0x0000002c00ae7306ULL, 0x000fe20000009400ULL, 0x0000000144441812ULL, 0x010fc800078efcffULL,
0x000000a4a62e723eULL, 0x000fe200000010ffULL, 0x00000072405c723cULL, 0x000fe2000004185cULL,
0x000000a5a72f723eULL, 0x000fe200000010ffULL, 0x0000002c00af7306ULL, 0x000ea20000005400ULL,
0x000000809100720bULL, 0x002fca0003f9d000ULL, 0x0000002e404c723cULL, 0x040fe4000004184cULL,
0x000000bf007a7306ULL, 0x000fea0000209400ULL, 0x0000008e8d2e723eULL, 0x000fe200000010ffULL,
0x000000704034723cULL, 0x000fe20000041834ULL, 0x0000008a882f723eULL, 0x000fe200000010ffULL,
0x000000bf00a37306ULL, 0x000e620000205400ULL, 0x000000afae00720bULL, 0x004fca0003f1d000ULL,
0x0000002e4058723cULL, 0x040fe40000041858ULL, 0x0000002c00487306ULL, 0x000eaa000000d400ULL,
0x0000004b0b2e723eULL, 0x000fe200000010ffULL, 0x0000006a4060723cULL, 0x000fe20000041860ULL,
0x00000047292f723eULL, 0x000fe200000010ffULL, 0x000000be002c7306ULL, 0x000ee2000020d400ULL,
0x000000a37a00720bULL, 0x002fca0003f5d000ULL, 0x0000007e3c4c723cULL, 0x040fe4000004184cULL,
0x000000bf00787306ULL, 0x000e62000020d400ULL, 0x0000000148480812ULL, 0x004fe400078efcffULL,
0x000000f9fa00720bULL, 0x000fe40003f1d000ULL, 0x000000487948723eULL, 0x000fe200000010ffULL,
0x0000007c3c50723cULL, 0x000fe40000041850ULL, 0x000000c000a87306ULL, 0x000fe20000209400ULL,
0x000000012c2c4812ULL, 0x008fc800078efcffULL, 0x000000452c49723eULL, 0x000fe200000010ffULL,
0x000000663c54723cULL, 0x040fe40000041854ULL, 0x000000c000927306ULL, 0x000ea20000205400ULL,
0x0000000178782812ULL, 0x002fe400078efcffULL, 0x0000000128280812ULL, 0x000fe400078efcffULL,
0x000000786868723eULL, 0x000fe200000010ffULL, 0x0000002e3c5c723cULL, 0x040fe4000004185cULL,
0x000000b800317306ULL, 0x000fec0000209400ULL, 0x000000483c58723cULL, 0x000fe40000041858ULL,
0x000000b800327306ULL, 0x000e620000205400ULL, 0x00000092a800720bULL, 0x004fce0003f9d000ULL,
0x000000c000307306ULL, 0x000eb0000020d400ULL, 0x000000b800337306ULL, 0x000ee2000020d400ULL,
0x000000323100720bULL, 0x002fce0003f5d000ULL, 0x000000b7006c7306ULL, 0x000fe20000209400ULL,
0x0000000130304812ULL, 0x004fce00078efcffULL, 0x000000b7006d7306ULL, 0x000e620000205400ULL,
0x0000000133332812ULL, 0x008fc800078efcffULL, 0x000000443344723eULL, 0x000fc600000010ffULL,
0x000000b300697306ULL, 0x000ff00000209400ULL, 0x000000b300407306ULL, 0x000ea20000205400ULL,
0x0000006d6c00720bULL, 0x002fce0003f9d000ULL, 0x0000002d00267306ULL, 0x000ff00000209400ULL,
0x0000002d00417306ULL, 0x000e620000205400ULL, 0x000000406900720bULL, 0x004fe40003f1d000ULL,
0x000000302869723eULL, 0x000fca00000010ffULL, 0x000000b700717306ULL, 0x000ea4000020d400ULL,
0x000000683c34723cULL, 0x000fec0000041834ULL, 0x000000b3000c7306ULL, 0x000ee2000020d400ULL,
0x000000412600720bULL, 0x002fce0003f5d000ULL, 0x0000002d002c7306ULL, 0x000e62000020d400ULL,
0x0000000171714812ULL, 0x004fc800078efcffULL, 0x000000467145723eULL, 0x000fe400000010ffULL,
0x000000010c0c0812ULL, 0x008fc800078efcffULL, 0x0000000c2b26723eULL, 0x000fe200000010ffULL,
0x000000443c38723cULL, 0x000fe20000041838ULL, 0x000000012c2c2812ULL, 0x002fc800078efcffULL,
0x0000002c2727723eULL, 0x000fce00000010ffULL, 0x000000263c3c723cULL, 0x000fe20000041860ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff0dff7812ULL, 0x000fe2000782c0ffULL, 0x01c61000ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000040030b7811ULL, 0x000fe400078e40ffULL, 0x00000001ff467807ULL, 0x000fe40000800000ULL,
0x0000000b0200720cULL, 0x000fe40003f24070ULL, 0x000000ff0fff7812ULL, 0x000fc4000784c0ffULL,
0x000000011300780cULL, 0x000fe40003f05270ULL, 0x00000001ff267807ULL, 0x000fe40001000000ULL,
0x0000000d460d7207ULL, 0x000fe40004000000ULL, 0x000000010e0e7812ULL, 0x000fe400078e0cffULL,
0x00007610260f7816ULL, 0x000fe2000000000fULL, 0x0000e26000009947ULL, 0x000fea0003800000ULL,
0x01c65c00ff0b7984ULL, 0x000e620000000800ULL, 0x8000000026067824ULL, 0x000fca00078e00ffULL,
0x800000000bff7812ULL, 0x002fe20007824806ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01c65c00ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007824806ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fe400078e00ffULL,
0x80000000260c7824ULL, 0x000fe400078e00ffULL, 0x00000006000b7305ULL, 0x0002a4000021f000ULL,
0x3fa0000006067823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc4000782480cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000032a0b7812ULL, 0x000fe200078ec0ffULL,
0x00000300ff0c7624ULL, 0x000fe200078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002700ULL,
0x00006400ff287624ULL, 0x000fe200078e00ffULL, 0x000000030b00780cULL, 0x000fe20003f25270ULL,
0xfffffffd0d067424ULL, 0x000fe200078e020cULL, 0xfffffffd0c277811ULL, 0x000fe200078e10ffULL,
0x00005800ff0f7624ULL, 0x000fc600078e00ffULL, 0x00000001060b7807ULL, 0x000fe20004800000ULL,
0x0000000000477919ULL, 0x000ea20000000000ULL, 0x000000400f0f7824ULL, 0x000fc600078e00ffULL,
0x000000012a2a7824ULL, 0x000fe400078e020bULL, 0x00000004072b7e24ULL, 0x020fe4000f8e020fULL,
0xffffffffff077424ULL, 0x000fe200078e00ffULL, 0x000000032a067812ULL, 0x000fc800078ec0ffULL,
0x000000030600780cULL, 0x000fe20003f25270ULL, 0x000000020e0e7824ULL, 0x002fc600078e00ffULL,
0x0000000127277807ULL, 0x000fe20004800000ULL, 0x000064000e0e7624ULL, 0x000fc800078e0228ULL,
0x000000012a067824ULL, 0x000fca00078e0227ULL, 0x000000040600720cULL, 0x000fda0003f26070ULL,
0x000000270e0c9210ULL, 0x000fe40007ffe02aULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0x00000100ff437424ULL, 0x000fe400078e00ffULL, 0x000060000c0c9625ULL, 0x000fe200078e000dULL,
0x00000080030b7811ULL, 0x040fe400078e40ffULL, 0x00000001032c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001047457824ULL, 0x004fe200078e00ffULL, 0x000000060c079981ULL, 0x000562000c1e1900ULL,
0x00000004ff0f7819ULL, 0x002fe2000001160eULL, 0x00000010000e7824ULL, 0x000fc800078e00ffULL,
0x000000010e0e7824ULL, 0x000fca00078e020fULL, 0x0000003f2b0e7812ULL, 0x000fe400078ef80eULL,
0x0000000b02287217ULL, 0x000fe40007800000ULL, 0x000000052c00720cULL, 0x000fe20003f26070ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0043ULL, 0x000000f045457812ULL, 0x000fe400078ec0ffULL,
0x0000003f2b2c7812ULL, 0x040fe200078ef810ULL, 0x00000001280b7824ULL, 0x000fe200078e0a0bULL,
0x0000003f2b2e7812ULL, 0x000fc400078ef811ULL, 0x000000450e0c7210ULL, 0x004fe20007f5e0ffULL,
0x00005e002c287625ULL, 0x000fe200078e0043ULL, 0x0000003f2b0e7812ULL, 0x000fc600078ef812ULL,
0x00005e002e2c7625ULL, 0x000fc800078e0043ULL, 0x000000ffff0d7224ULL, 0x000fe400010e060fULL,
0x00005e000e2e7625ULL, 0x000fe200078e0043ULL, 0x00000045280e7210ULL, 0x000fe40007f5e0ffULL,
0x0000003f2b287812ULL, 0x000fe200078ef815ULL, 0x0000001000447824ULL, 0x000fe200078e00ffULL,
0x000000400b0b7807ULL, 0x000fe20000800000ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0629ULL,
0x0000003f2b307812ULL, 0x000fe200078ef814ULL, 0x00005e0028287625ULL, 0x000fe200078e0043ULL,
0x000000452e2e7210ULL, 0x000fc40007f5e0ffULL, 0x0000000b440b7217ULL, 0x000fe40007800000ULL,
0x00000004ff487819ULL, 0x000fe20000011647ULL, 0x00005e0030307625ULL, 0x000fe200078e0043ULL,
0x000000452c2c7210ULL, 0x000fc60007f7e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e062fULL,
0x0000004528327210ULL, 0x080fe20007f5e0ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0a44ULL,
0x0000000248287810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200018e062dULL,
0x0000004530307210ULL, 0x000fe40007f7e0ffULL, 0x0000003f2b407812ULL, 0x000fe400078ef816ULL,
0x0000000b2800720cULL, 0x000fe20003fa6070ULL, 0x0000000813287824ULL, 0x000fe200078e00ffULL,
0x0000003f2b427812ULL, 0x000fe200078ef817ULL, 0x0000400013e27824ULL, 0x000fe200078e00ffULL,
0x0000000448447810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff317224ULL, 0x000fc400018e0631ULL,
0x00005e0040407625ULL, 0x000fe200078e0043ULL, 0x0000000b4400720cULL, 0x000fe40003f66070ULL,
0x0000000828447812ULL, 0x000fe200078ec0ffULL, 0x00005e0042427625ULL, 0x000fe200078e0043ULL,
0x0000000b4800720cULL, 0x000fc60003f86070ULL, 0x000000ffff337224ULL, 0x000fe200010e0629ULL,
0x00004000e2297812ULL, 0x000fe200078ec0ffULL, 0x00000000440573c2ULL, 0x000e6200000e0000ULL,
0x0000004542427210ULL, 0x000fe40007f5e0ffULL, 0x0001400029297810ULL, 0x000fe40007ffe0ffULL,
0x00000008484a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff437224ULL, 0x000fe400010e0643ULL,
0x00000010e72b7824ULL, 0x000fe200078e0229ULL, 0x0000000b4a00720cULL, 0x000fc40003f46070ULL,
0x0000004540407210ULL, 0x000fe40007f3e0ffULL, 0x0000000a484a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010e6457824ULL, 0x100fe200078e0229ULL, 0x0000000648607810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c2b7faeULL, 0x0005e2000e101c46ULL,
0x0000000b4a00720cULL, 0x080fe20003f86070ULL, 0x00000010e5477824ULL, 0x000fe200078e0229ULL,
0x0000000c484a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff417224ULL, 0x000fe200008e0641ULL,
0x0000000b6000720cULL, 0x000fe20003f26070ULL, 0x000000000e457faeULL, 0x0007e2000e901c46ULL,
0x0000000e48487810ULL, 0x000fc40007ffe0ffULL, 0x0000000b4a00720cULL, 0x080fe20003fa6070ULL,
0x000000002c477faeULL, 0x0009e2000d901c46ULL, 0x0000000b4800720cULL, 0x000fe20003f66070ULL,
0x00000010e4497824ULL, 0x100fe200078e0229ULL, 0x0001c64805057890ULL, 0x002fe2000fffe03fULL,
0x00000010194b7824ULL, 0x100fe400078e0229ULL, 0x000000101a0b7824ULL, 0x100fe400078e0229ULL,
0x000000101b0d7824ULL, 0x104fe200078e0229ULL, 0x000000002e497faeULL, 0x0009e2000c901c46ULL,
0x000000101c0f7824ULL, 0x008fc600078e0229ULL, 0x00000000304b7faeULL, 0x0009e8000d101c46ULL,
0x00000000320b7faeULL, 0x0009e8000e101c46ULL, 0x00000000400d7faeULL, 0x0009e8000e901c46ULL,
0x00000000420f7faeULL, 0x0009e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0001c648180c7811ULL, 0x000fe200078e18ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000004000c0d7984ULL, 0x0102a20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c61c00ff0e7984ULL, 0x000ee20000000800ULL,
0x000000e1460b7207ULL, 0x000fe20004000000ULL, 0x800000001d0f7824ULL, 0x000fc600078e00ffULL,
0x0000ffff0b0c7812ULL, 0x002fc800078ec0ffULL, 0x000088800c2b7816ULL, 0x000fca00000000ffULL,
0x800000002b0c7824ULL, 0x000fca00078e00ffULL, 0x800000000dff7812ULL, 0x004fe4000780480cULL,
0x800000000eff7812ULL, 0x008fe2000782480fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fe400078e00ffULL,
0x800000001d0e7824ULL, 0x000fe400078e00ffULL, 0x0000000c000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000c0c7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe40003800000ULL,
0x01c61c00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000782480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x01c080001e0d7984ULL, 0x000e620000000800ULL, 0x00000001ffbc7424ULL, 0x000fc600078e00ffULL,
0x01c280001e0c7984ULL, 0x0004e20000000800ULL, 0x000000080d00720bULL, 0x002fda0003f3d000ULL,
0x00000000000e7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0e0f7812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000080d00720bULL, 0x00cfe20003f34000ULL,
0x00000000002e7919ULL, 0x000e620000000000ULL, 0x0000000d082d7209ULL, 0x000fca0007810000ULL,
0x8000002d080e7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400008e0100ULL, 0x000000010000780cULL, 0x000fe40003f25270ULL,
0x0000ffff082c7812ULL, 0x000fe200078e3cffULL, 0x0000000e000e7308ULL, 0x000ea60000000800ULL,
0x0000002c0fff7212ULL, 0x000fc4000784c0ffULL, 0x00000002ff2f7819ULL, 0x102fe4000001162eULL,
0x00000002ff2e7819ULL, 0x000fc6000001162eULL, 0x01c4802d1e009388ULL, 0x000fe20000000800ULL,
0x00000001ffbc7807ULL, 0x000fe40001000000ULL, 0x000000082e2e7810ULL, 0x000fe20007ffe0ffULL,
0x00001f2f0e087589ULL, 0x004e6400000e0000ULL, 0x8000002d0d0f2221ULL, 0x000fe40000010000ULL,
0x0000000e09097220ULL, 0x000fe20000410000ULL, 0x00001f2e0e0d7589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b0f0f2820ULL, 0x000fc80000410000ULL, 0x0000000f000a2308ULL, 0x000ee20000000800ULL,
0x000000084c4c7220ULL, 0x082fe40000410000ULL, 0x000000084d4d7220ULL, 0x080fe40000410000ULL,
0x0000000850507220ULL, 0x080fe40000410000ULL, 0x0000000851517220ULL, 0x080fe40000410000ULL,
0x0000000854547220ULL, 0x080fe40000410000ULL, 0x0000000855557220ULL, 0x000fc40000410000ULL,
0x000000085c5c7220ULL, 0x080fe40000410000ULL, 0x000000085d5d7220ULL, 0x080fe40000410000ULL,
0x0000000858587220ULL, 0x080fe40000410000ULL, 0x0000000859597220ULL, 0x080fe40000410000ULL,
0x0000000834347220ULL, 0x080fe40000410000ULL, 0x0000000835357220ULL, 0x000fc40000410000ULL,
0x0000000838387220ULL, 0x080fe40000410000ULL, 0x0000000839397220ULL, 0x080fe40000410000ULL,
0x000000083c3c7220ULL, 0x080fe40000410000ULL, 0x000000083d3d7220ULL, 0x000fe40000410000ULL,
0x0000000d4e4e7220ULL, 0x084fe40000410000ULL, 0x0000000d4f4f7220ULL, 0x000fc40000410000ULL,
0x0000000d52527220ULL, 0x080fe40000410000ULL, 0x0000000d53537220ULL, 0x080fe40000410000ULL,
0x0000000d56567220ULL, 0x080fe40000410000ULL, 0x0000000d57577220ULL, 0x080fe40000410000ULL,
0x0000000d5e5e7220ULL, 0x080fe40000410000ULL, 0x0000000d5f5f7220ULL, 0x000fc40000410000ULL,
0x0000000d5a5a7220ULL, 0x080fe40000410000ULL, 0x0000000d5b5b7220ULL, 0x080fe40000410000ULL,
0x0000000d36367220ULL, 0x080fe40000410000ULL, 0x0000000d37377220ULL, 0x080fe40000410000ULL,
0x0000000d3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000d3b3b7220ULL, 0x000fc40000410000ULL,
0x0000000d3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000d3f3f7220ULL, 0x000fe40000410000ULL,
0x000000ffff087224ULL, 0x000fe400078e002dULL, 0x0000000c0a0c2220ULL, 0x008fc80000410000ULL,
0x000000090c097221ULL, 0x00cfe20000010000ULL, 0x000000f000000947ULL, 0x000fea0003800000ULL,
0x0001c648180e7811ULL, 0x000fe200078e18ffULL, 0x800000002b0d7824ULL, 0x000fc800078e00ffULL,
0x000004000e0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000002b2c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x004fe40003800000ULL, 0x000004000e0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc4000780482cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000001132b7812ULL, 0x000fe200078e0cffULL,
0x0000000000de7919ULL, 0x000e660000000000ULL, 0x000140002b2b7811ULL, 0x000fca00078e70ffULL,
0x00000010f0f77824ULL, 0x100fe400078e022bULL, 0x000000101ff87824ULL, 0x100fe400078e022bULL,
0x0000001020f97824ULL, 0x100fe200078e022bULL, 0x00000000f768783bULL, 0x000ea20000004200ULL,
0x0000001021fa7824ULL, 0x100fe400078e022bULL, 0x0000001022fb7824ULL, 0x100fe200078e022bULL,
0x00000000f870783bULL, 0x000fe20000004200ULL, 0x0000001023fc7824ULL, 0x000fc400078e022bULL,
0x0000001024407824ULL, 0x100fe200078e022bULL, 0x00000000f92c783bULL, 0x000fe20000004200ULL,
0x0000001025447824ULL, 0x000fc600078e022bULL, 0x00000000fa48783bULL, 0x000fe80000004200ULL,
0x00000000fb60783bULL, 0x000fe80000004200ULL, 0x00000000fc30783bULL, 0x000fe80000004200ULL,
0x0000004001007387ULL, 0x000fe80000100800ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x0000044401007387ULL, 0x000fe80000100800ULL, 0x000000004444783bULL, 0x000f220000004200ULL,
0x00000018ff0c7819ULL, 0x004fe20000011468ULL, 0x0000006800cd7306ULL, 0x000fe20000009400ULL,
0x00000018ff0e7819ULL, 0x000fe2000001146aULL, 0x0001000069c87824ULL, 0x000fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fc4000001146bULL, 0x00000018ff0d7819ULL, 0x000fe40000011469ULL,
0x00000018ffd07819ULL, 0x000fe200000114c8ULL, 0x0000000c00a87306ULL, 0x000ff00000209400ULL,
0x0000000c00b97306ULL, 0x000eb00000205400ULL, 0x0000000c00af7306ULL, 0x0003e2000020d400ULL,
0x00000018ffa77819ULL, 0x008fc40000011443ULL, 0x00000018ff667819ULL, 0x000fca0000011441ULL,
0x0000006800a27306ULL, 0x000ee20000005400ULL, 0x00000018ff0c7819ULL, 0x002fe40000011470ULL,
0x00000018ffaa7819ULL, 0x010fe40000011444ULL, 0x00000018ffb77819ULL, 0x000fe40000011446ULL,
0x00000018ffb67819ULL, 0x000fe20000011445ULL, 0x0000000c00b07306ULL, 0x000fe20000209400ULL,
0x00000018ffbb7819ULL, 0x000fe40000011447ULL, 0x000000b9a800720bULL, 0x004fca0003f9d000ULL,
0x0000000c00c57306ULL, 0x000fe20000205400ULL, 0x000000a2cd00720bULL, 0x008fce0003fdd000ULL,
0x0000000c00bf7306ULL, 0x0003e2000020d400ULL, 0x00000001afaf4812ULL, 0x000fce00078efcffULL,
0x0000000e00b47306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x002fce000001142cULL,
0x0000000c00a97306ULL, 0x000ff00000209400ULL, 0x0000000c00a47306ULL, 0x000ff00000205400ULL,
0x0000000c00a17306ULL, 0x0003f0000020d400ULL, 0x0000000e00bd7306ULL, 0x000fe20000205400ULL,
0x00000018ff0c7819ULL, 0x002fce0000011448ULL, 0x0000000c00907306ULL, 0x000ff00000209400ULL,
0x0000000c00967306ULL, 0x000ff00000205400ULL, 0x0000000c00837306ULL, 0x0003f0000020d400ULL,
0x0000000e00ba7306ULL, 0x0005e2000020d400ULL, 0x00000018ff0c7819ULL, 0x002fce0000011460ULL,
0x0000000c00877306ULL, 0x000fe20000209400ULL, 0x00000018ff0e7819ULL, 0x004fce0000011472ULL,
0x0000000c00887306ULL, 0x000ff00000205400ULL, 0x0000000c007f7306ULL, 0x0003f0000020d400ULL,
0x0000000f00c27306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x002fce0000011430ULL,
0x0000000c008f7306ULL, 0x000ff00000209400ULL, 0x0000000c00917306ULL, 0x000ff00000205400ULL,
0x0000000c00777306ULL, 0x0003f0000020d400ULL, 0x0000000f00cb7306ULL, 0x000fe20000205400ULL,
0x00000018ff0c7819ULL, 0x002fce0000011433ULL, 0x0000000f00b87306ULL, 0x0003f0000020d400ULL,
0x0000006900c67306ULL, 0x000fe20000009400ULL, 0x00000018ff0f7819ULL, 0x002fce0000011473ULL,
0x0000006900d17306ULL, 0x000e700000005400ULL, 0x0000000c00857306ULL, 0x000ff00000209400ULL,
0x0000000c00847306ULL, 0x000fe20000205400ULL, 0x000000d1c600720bULL, 0x002fce0003f1d000ULL,
0x0000000c006d7306ULL, 0x000ff0000020d400ULL, 0x000000a700d67306ULL, 0x000ff00000209400ULL,
0x000000a700d37306ULL, 0x000ff00000205400ULL, 0x000000a7000c7306ULL, 0x0003f0000020d400ULL,
0x0000006800ae7306ULL, 0x0004e2000000d400ULL, 0x0000010068a77824ULL, 0x002fce00078e00ffULL,
0x0000000d00ac7306ULL, 0x000fe20000209400ULL, 0x0001000068687824ULL, 0x004fce00078e00ffULL,
0x0000000d00cf7306ULL, 0x000e620000205400ULL, 0x00000001aeae6812ULL, 0x008fce00078efcffULL,
0x0000000d00ad7306ULL, 0x0004f0000020d400ULL, 0x0000000e00c07306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x004fe40000011471ULL, 0x000000cfac00720bULL, 0x002fca0003fdd000ULL,
0x0000000e00c97306ULL, 0x000ff00000205400ULL, 0x0000000e00b57306ULL, 0x0003e2000020d400ULL,
0x00000001adad6812ULL, 0x008fce00078efcffULL, 0x0000000f00c37306ULL, 0x000fe20000209400ULL,
0x00000018ff0e7819ULL, 0x002fce000001142eULL, 0x0000000f00c47306ULL, 0x000ff00000205400ULL,
0x0000000f00b37306ULL, 0x0003f0000020d400ULL, 0x0000006600797306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fce000001142fULL, 0x00000066007a7306ULL, 0x000ff00000205400ULL,
0x0000006600657306ULL, 0x000ff0000020d400ULL, 0x000000aa00f47306ULL, 0x000ff00000209400ULL,
0x000000aa00f37306ULL, 0x000ff00000205400ULL, 0x000000aa00677306ULL, 0x0003f0000020d400ULL,
0x000000b700ef7306ULL, 0x000fe20000209400ULL, 0x00000018ffaa7819ULL, 0x002fce00000114a7ULL,
0x000000b700ed7306ULL, 0x000ff00000205400ULL, 0x000000b700667306ULL, 0x0003f0000020d400ULL,
0x0000000d00be7306ULL, 0x000fe20000209400ULL, 0x00000018ffb77819ULL, 0x002fe20000011468ULL,
0x0000010069687824ULL, 0x000fca00078e00ffULL, 0x00000018ffce7819ULL, 0x000fe20000011468ULL,
0x0000000d00c77306ULL, 0x000ff00000205400ULL, 0x0000000d00ca7306ULL, 0x0003f0000020d400ULL,
0x0000000e00997306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x002fce000001142dULL,
0x0000000e009c7306ULL, 0x000ff00000205400ULL, 0x0000000e00937306ULL, 0x0003f0000020d400ULL,
0x0000000f00977306ULL, 0x000fe20000209400ULL, 0x00000018ff0e7819ULL, 0x002fce000001144aULL,
0x0000000f00987306ULL, 0x000ff00000205400ULL, 0x0000000f00927306ULL, 0x0003f0000020d400ULL,
0x0000006900a77306ULL, 0x0004e2000000d400ULL, 0x00000018ff0f7819ULL, 0x002fce000001144bULL,
0x0000000d00a37306ULL, 0x000fe20000209400ULL, 0x000001006b697824ULL, 0x004fca00078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe40000011469ULL, 0x0000000d009d7306ULL, 0x000fe20000205400ULL,
0x00000001a7a70812ULL, 0x008fce00078efcffULL, 0x0000000d00a07306ULL, 0x0003f0000020d400ULL,
0x0000000e00897306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x002fce0000011449ULL,
0x0000000e008c7306ULL, 0x000ff00000205400ULL, 0x0000000e00817306ULL, 0x0003f0000020d400ULL,
0x0000000f008a7306ULL, 0x000fe20000209400ULL, 0x00000018ff0e7819ULL, 0x002fce0000011462ULL,
0x0000000f008b7306ULL, 0x000ff00000205400ULL, 0x0000000f00807306ULL, 0x0003f0000020d400ULL,
0x000000d000c87306ULL, 0x000fe20000209400ULL, 0x00000018ff0f7819ULL, 0x002fce0000011463ULL,
0x000000d000d57306ULL, 0x000e700000205400ULL, 0x000000d000d97306ULL, 0x000eb0000020d400ULL,
0x0000006a00cd7306ULL, 0x000fe20000009400ULL, 0x000000d5c800720bULL, 0x002fce0003f9d000ULL,
0x0000006a00d07306ULL, 0x000e6c0000005400ULL, 0x00000001d9d94812ULL, 0x004fe400078efcffULL,
0x0000006b00697306ULL, 0x000ff00000009400ULL, 0x0000006b00c67306ULL, 0x000ea20000005400ULL,
0x000000d0cd00720bULL, 0x002fe20003fbd000ULL, 0x000100006acd7824ULL, 0x000fcc00078e00ffULL,
0x0000000d008d7306ULL, 0x000ff00000209400ULL, 0x0000000d008e7306ULL, 0x000fe20000205400ULL,
0x000000c66900720bULL, 0x004fe20003f7d000ULL, 0x000100006b697824ULL, 0x000fcc00078e00ffULL,
0x0000000d00827306ULL, 0x0003f0000020d400ULL, 0x0000000e00a57306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x002fce0000011461ULL, 0x0000000e00a67306ULL, 0x000ff00000205400ULL,
0x0000000e007b7306ULL, 0x0003f0000020d400ULL, 0x0000000f009e7306ULL, 0x000fe20000209400ULL,
0x00000018ff0e7819ULL, 0x002fce0000011432ULL, 0x0000000f009f7306ULL, 0x000ff00000205400ULL,
0x0000000f00787306ULL, 0x0003f0000020d400ULL, 0x000000aa00c17306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fce0000011440ULL, 0x000000aa00d27306ULL, 0x000e700000205400ULL,
0x0000000d00ab7306ULL, 0x000ff00000209400ULL, 0x0000000d00867306ULL, 0x000fe20000205400ULL,
0x000000d2c100720bULL, 0x002fce0003f3d000ULL, 0x0000000d007c7306ULL, 0x0003f0000020d400ULL,
0x0000000e00947306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x002fce0000011431ULL,
0x0000000e00957306ULL, 0x000ff00000205400ULL, 0x0000000e006f7306ULL, 0x0003f0000020d400ULL,
0x0000000f007d7306ULL, 0x000fe20000209400ULL, 0x00000018ff0e7819ULL, 0x002fce0000011442ULL,
0x0000000f007e7306ULL, 0x000ff00000205400ULL, 0x0000000f006c7306ULL, 0x000ff0000020d400ULL,
0x000000b600f27306ULL, 0x000ff00000209400ULL, 0x000000b600f17306ULL, 0x000ff00000205400ULL,
0x000000b6000f7306ULL, 0x000ff0000020d400ULL, 0x000000b700d47306ULL, 0x000ff00000209400ULL,
0x000000b700e37306ULL, 0x000e700000205400ULL, 0x000000b700b67306ULL, 0x0004f0000020d400ULL,
0x0000000d009a7306ULL, 0x000fe20000209400ULL, 0x000001006ab77824ULL, 0x004fe200078e00ffULL,
0x000000e3d400720bULL, 0x002fc80003f5d000ULL, 0x00000018ffda7819ULL, 0x000fe400000114b7ULL,
0x0000000d009b7306ULL, 0x000fee0000205400ULL, 0x00000001b6b62812ULL, 0x008fe200078efcffULL,
0x0000000d00747306ULL, 0x000fe2000020d400ULL, 0x000000bdb400720bULL, 0x000fce0003f5d000ULL,
0x0000000e00757306ULL, 0x000fec0000209400ULL, 0x00000001baba2812ULL, 0x000fe400078efcffULL,
0x0000000e00767306ULL, 0x000fe20000205400ULL, 0x000000c9c000720bULL, 0x000fce0003f5d000ULL,
0x0000000e000d7306ULL, 0x000fec000020d400ULL, 0x00000001b5b52812ULL, 0x000fe400078efcffULL,
0x000000bb00d87306ULL, 0x000ff00000209400ULL, 0x000000bb00d77306ULL, 0x000ff00000205400ULL,
0x000000bb000e7306ULL, 0x000ff0000020d400ULL, 0x000000aa00db7306ULL, 0x000e70000020d400ULL,
0x000000ce00687306ULL, 0x000ff00000209400ULL, 0x000000ce00bb7306ULL, 0x000ea20000205400ULL,
0x00000001dbdb1812ULL, 0x002fce00078efcffULL, 0x000000ce00aa7306ULL, 0x000e70000020d400ULL,
0x000000dc00ce7306ULL, 0x000fe20000209400ULL, 0x000000bb6800720bULL, 0x004fe20003f3d000ULL,
0x0000010071687824ULL, 0x000fca00078e00ffULL, 0x00000018ffd47819ULL, 0x000fe20000011468ULL,
0x000000dc00df7306ULL, 0x000eac0000205400ULL, 0x00000001aaaa1812ULL, 0x002fe400078efcffULL,
0x000000da00cc7306ULL, 0x000ff00000209400ULL, 0x000000da00dd7306ULL, 0x000e620000205400ULL,
0x000000dfce00720bULL, 0x004fce0003f1d000ULL, 0x000000da00b77306ULL, 0x0005f0000020d400ULL,
0x000000dc00a27306ULL, 0x000722000020d400ULL, 0x00000018ffda7819ULL, 0x004fe400000114cdULL,
0x000000ddcc00720bULL, 0x002fca0003f3d000ULL, 0x0000006a00b97306ULL, 0x000e62000000d400ULL,
0x00000018ffdc7819ULL, 0x008fe20000011469ULL, 0x0000010070697824ULL, 0x000fca00078e00ffULL,
0x00000018ffd27819ULL, 0x000fe20000011469ULL, 0x000000da00d07306ULL, 0x000fe20000209400ULL,
0x00000001a2a20812ULL, 0x010fe400078efcffULL, 0x000000cbc200720bULL, 0x000fe40003f1d000ULL,
0x00000001b7b71812ULL, 0x000fc600078efcffULL, 0x000000da00e17306ULL, 0x000ea20000205400ULL,
0x00000001b9b95812ULL, 0x002fce00078efcffULL, 0x000000dc00c67306ULL, 0x000fe20000209400ULL,
0x00000001b8b80812ULL, 0x000fce00078efcffULL, 0x000000dc00cd7306ULL, 0x000e620000205400ULL,
0x000000e1d000720bULL, 0x004fce0003f9d000ULL, 0x000000da00d17306ULL, 0x000eb0000020d400ULL,
0x000000dc00c17306ULL, 0x000ee2000020d400ULL, 0x000000cdc600720bULL, 0x002fce0003fbd000ULL,
0x000000d200697306ULL, 0x000fe20000209400ULL, 0x00000001d1d14812ULL, 0x004fe400078efcffULL,
0x000000c7be00720bULL, 0x000fca0003f9d000ULL, 0x000000d2006a7306ULL, 0x000e620000205400ULL,
0x00000001c1c15812ULL, 0x008fce00078efcffULL, 0x0000007000b47306ULL, 0x000fe20000009400ULL,
0x00000001caca4812ULL, 0x000fe400078efcffULL, 0x000000c4c300720bULL, 0x000fca0003f9d000ULL,
0x0000007000bd7306ULL, 0x000ea20000005400ULL, 0x0000006a6900720bULL, 0x002fe20003fbd000ULL,
0x0000010072697824ULL, 0x000fca00078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe20000011469ULL,
0x0000006b00a87306ULL, 0x000e62000000d400ULL, 0x00000001b3b34812ULL, 0x000fce00078efcffULL,
0x000000d400687306ULL, 0x000fe20000209400ULL, 0x000000bdb400720bULL, 0x004fe20003fdd000ULL,
0x0001000070b47824ULL, 0x000fe400078e00ffULL, 0x0001000071bd7824ULL, 0x000fc600078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114b4ULL, 0x000000d4006b7306ULL, 0x000ea20000205400ULL,
0x00000001a8a83812ULL, 0x002fe400078efcffULL, 0x000000c5b000720bULL, 0x000fca0003f7d000ULL,
0x0000007000cf7306ULL, 0x000e70000000d400ULL, 0x00000073006a7306ULL, 0x000fe20000009400ULL,
0x0000006b6800720bULL, 0x004fe20003f1d000ULL, 0x0000010073687824ULL, 0x000fe200078e00ffULL,
0x00000001bfbf3812ULL, 0x000fc800078efcffULL, 0x00000018ffc27819ULL, 0x000fe20000011468ULL,
0x0000007300c77306ULL, 0x000ea20000005400ULL, 0x0001280064687811ULL, 0x000fe400078e20ffULL,
0x00000001cfcf6812ULL, 0x002fca00078efcffULL, 0x000000d200bb7306ULL, 0x000e70000020d400ULL,
0x0000007100cc7306ULL, 0x000fe20000009400ULL, 0x000000c76a00720bULL, 0x004fe40003fdd000ULL,
0x000000006868783bULL, 0x000fea0000000200ULL, 0x0000007100d57306ULL, 0x000ea20000005400ULL,
0x00000001bbbb5812ULL, 0x002fce00078efcffULL, 0x0000007100d07306ULL, 0x000e70000000d400ULL,
0x0000007200707306ULL, 0x000fe20000009400ULL, 0x000000d5cc00720bULL, 0x004fe40003f3d000ULL,
0x00000018ffcc7819ULL, 0x000fca00000114bdULL, 0x0000007200717306ULL, 0x000eac0000005400ULL,
0x00000001d0d01812ULL, 0x002fe400078efcffULL, 0x000000d400ac7306ULL, 0x000e62000020d400ULL,
0x000000717000720bULL, 0x004fce0003fbd000ULL, 0x000000be00d47306ULL, 0x000fe20000209400ULL,
0x00000002ff717819ULL, 0x100fe200000116deULL, 0x0001000072707824ULL, 0x000fe200078e00ffULL,
0x00000002ffde7819ULL, 0x000fc800000116deULL, 0x00000008dede7810ULL, 0x000fe20007ffe0ffULL,
0x000000be00d57306ULL, 0x000ea20000205400ULL, 0x00000018ffda7819ULL, 0x000fe40000011470ULL,
0x00000001acac0812ULL, 0x002fca00078efcffULL, 0x000000be00c57306ULL, 0x0003f0000020d400ULL,
0x0000007200c97306ULL, 0x000722000000d400ULL, 0x0000000affbe723eULL, 0x002fe400000010ffULL,
0x000000d5d400720bULL, 0x004fc40003f7d000ULL, 0x00005410bec67816ULL, 0x000fc600000000beULL,
0x000000c800b47306ULL, 0x000fe20000209400ULL, 0x00009910bc727816ULL, 0x008fe200000000ffULL,
0x00001f71c6717589ULL, 0x000e6600000e0000ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x00001fdec6707589ULL, 0x000ea200000e0000ULL, 0x000000aedb72723eULL, 0x000fe200000010ffULL,
0x000000c800dd7306ULL, 0x000ee20000205400ULL, 0x00000001c9c95812ULL, 0x010fe400078efcffULL,
0x00000001c5c53812ULL, 0x000fca00078efcffULL, 0x000000c800ce7306ULL, 0x000f30000020d400ULL,
0x0000007300c87306ULL, 0x000922000000d400ULL, 0x000000ddb400720bULL, 0x008fe20003f3d000ULL,
0x0000007168688231ULL, 0x002fc400003400ffULL, 0x000000716a6a8231ULL, 0x000fe400003400ffULL,
0x0000007069698231ULL, 0x084fe400003400ffULL, 0x000000706b6b8231ULL, 0x000fe200003400ffULL,
0x0001000073737824ULL, 0x010fe200078e00ffULL, 0x000000cc00bd7306ULL, 0x000fe80000209400ULL,
0x00000018ffdc7819ULL, 0x000fc40000011473ULL, 0x000000a7aa73723eULL, 0x000fe400000010ffULL,
0x000000cc00d27306ULL, 0x000e620000205400ULL, 0x00000001cece1812ULL, 0x000fe400078efcffULL,
0x00000001c8c86812ULL, 0x000fe400078efcffULL, 0x00000072684c723cULL, 0x000fe6000004184cULL,
0x000000cc00cd7306ULL, 0x000ea8000020d400ULL, 0x000001002c727824ULL, 0x040fe200078e00ffULL,
0x000000d9ad73723eULL, 0x000fe200000010ffULL, 0x000100002cd97824ULL, 0x000fc400078e00ffULL,
0x000000da00cb7306ULL, 0x000fe20000209400ULL, 0x000000d2bd00720bULL, 0x002fe40003f3d000ULL,
0x00000018ffd97819ULL, 0x000fca00000114d9ULL, 0x000000da00cc7306ULL, 0x000e6c0000205400ULL,
0x00000001cdcd1812ULL, 0x004fe400078efcffULL, 0x000000da00be7306ULL, 0x0004f0000020d400ULL,
0x0000002c00aa7306ULL, 0x000fe20000009400ULL, 0x00000018ffda7819ULL, 0x004fc40000011472ULL,
0x000000b6af72723eULL, 0x000fe400000010ffULL, 0x000000cccb00720bULL, 0x002fc60003f7d000ULL,
0x0000002c00b47306ULL, 0x000e640000005400ULL, 0x000000726850723cULL, 0x000fec0000041850ULL,
0x000000c200b07306ULL, 0x000fe20000209400ULL, 0x000000b9b772723eULL, 0x000fe400000010ffULL,
0x000000a8a273723eULL, 0x000fc400000010ffULL, 0x00000001bebe3812ULL, 0x008fc600078efcffULL,
0x000000c200c07306ULL, 0x000ea20000205400ULL, 0x000000b4aa00720bULL, 0x002fe20003fbd000ULL,
0x000000726854723cULL, 0x000fec0000041854ULL, 0x0000002c00a77306ULL, 0x000e62000000d400ULL,
0x000001002d727824ULL, 0x040fe200078e00ffULL, 0x000000c1b873723eULL, 0x000fe200000010ffULL,
0x000100002db87824ULL, 0x000fc600078e00ffULL, 0x00000018ffd27819ULL, 0x000fe40000011472ULL,
0x000000d1ba72723eULL, 0x000fe200000010ffULL, 0x000000c200c77306ULL, 0x000ee2000020d400ULL,
0x00000018ffd17819ULL, 0x000fe400000114b8ULL, 0x000000c0b000720bULL, 0x004fc60003f3d000ULL,
0x00000072685c723cULL, 0x000fe2000004185cULL, 0x00000001a7a75812ULL, 0x002fe200078efcffULL,
0x000000d100b87306ULL, 0x000fe20000209400ULL, 0x000000a4a900720bULL, 0x000fc80003fbd000ULL,
0x000000cfbb72723eULL, 0x000fe200000010ffULL, 0x000001002ebb7824ULL, 0x000fe200078e00ffULL,
0x000000d0ac73723eULL, 0x000fe200000010ffULL, 0x000000d100c17306ULL, 0x000e620000205400ULL,
0x00000001c7c71812ULL, 0x008fe400078efcffULL, 0x00000018ffcf7819ULL, 0x000fc600000114bbULL,
0x000000726858723cULL, 0x000fe20000041858ULL, 0x00000001a1a15812ULL, 0x000fe200078efcffULL,
0x000000dc00c27306ULL, 0x000fea0000209400ULL, 0x000000cebf72723eULL, 0x000fe400000010ffULL,
0x000000cdca73723eULL, 0x000fe200000010ffULL, 0x000000dc00c67306ULL, 0x000ea20000205400ULL,
0x000000c1b800720bULL, 0x002fca0003fbd000ULL, 0x000000726834723cULL, 0x000fe40000041834ULL,
0x000000d100ac7306ULL, 0x000e6a000020d400ULL, 0x000000c8c773723eULL, 0x000fe200000010ffULL,
0x000001002fc77824ULL, 0x000fe200078e00ffULL, 0x000000c9c572723eULL, 0x000fe200000010ffULL,
0x000000cf00bb7306ULL, 0x000fe20000209400ULL, 0x000000c6c200720bULL, 0x004fc40003f3d000ULL,
0x00000018ffc77819ULL, 0x000fc600000114c7ULL, 0x000000726838723cULL, 0x000fe40000041838ULL,
0x000000cf00c07306ULL, 0x000ea20000205400ULL, 0x00000001acac5812ULL, 0x002fce00078efcffULL,
0x000000dc00bc7306ULL, 0x000e70000020d400ULL, 0x0000002e00bf7306ULL, 0x000fe20000009400ULL,
0x000000c0bb00720bULL, 0x004fce0003fbd000ULL, 0x0000002e00c37306ULL, 0x000ea20000005400ULL,
0x00000001bcbc1812ULL, 0x002fce00078efcffULL, 0x0000002e00ce7306ULL, 0x0002f0000000d400ULL,
0x000000d900af7306ULL, 0x000fe20000209400ULL, 0x000100002e2e7824ULL, 0x002fe200078e00ffULL,
0x000000c3bf00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff727819ULL, 0x000fe4000001142eULL,
0x000000d900b67306ULL, 0x000e620000205400ULL, 0x000000beb52e723eULL, 0x000fe200000010ffULL,
0x000100002fb57824ULL, 0x000fca00078e00ffULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x000000d900a27306ULL, 0x000ea2000020d400ULL, 0x00000001cece4812ULL, 0x008fce00078efcffULL,
0x000000cf00b07306ULL, 0x000ee2000020d400ULL, 0x000000b6af00720bULL, 0x002fce0003f7d000ULL,
0x000000c700d97306ULL, 0x000fec0000209400ULL, 0x00000001a2a23812ULL, 0x004fe400078efcffULL,
0x000000c700d57306ULL, 0x000e620000205400ULL, 0x00000001b0b05812ULL, 0x008fce00078efcffULL,
0x0000002f00c47306ULL, 0x000ff00000009400ULL, 0x0000002f00c57306ULL, 0x000ea20000005400ULL,
0x000000d5d900720bULL, 0x002fce0003fbd000ULL, 0x0000002f00cf7306ULL, 0x0003f0000000d400ULL,
0x000000c700d17306ULL, 0x000ee2000020d400ULL, 0x000000bcb32f723eULL, 0x002fe400000010ffULL,
0x000000c5c400720bULL, 0x004fca0003fdd000ULL, 0x000000b500dd7306ULL, 0x000fe20000209400ULL,
0x0000002e683c723cULL, 0x000fee000004183cULL, 0x000000b500e17306ULL, 0x000e620000205400ULL,
0x00000100482e7824ULL, 0x000fe200078e00ffULL, 0x00000001d1d15812ULL, 0x008fe200078efcffULL,
0x00000100492f7824ULL, 0x000fe200078e00ffULL, 0x00000001cfcf6812ULL, 0x000fc400078efcffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002d00b77306ULL, 0x000fe20000009400ULL,
0x00000018ffbc7819ULL, 0x000fe2000001142fULL, 0x00010000482f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002d00bd7306ULL, 0x000ea20000005400ULL,
0x000000e1dd00720bULL, 0x002fce0003fbd000ULL, 0x0000002d00a87306ULL, 0x000e70000000d400ULL,
0x000000d200b97306ULL, 0x000fe20000209400ULL, 0x000000bdb700720bULL, 0x004fce0003f3d000ULL,
0x000000d200ba7306ULL, 0x000eac0000205400ULL, 0x00000001a8a81812ULL, 0x002fe400078efcffULL,
0x000000d2002d7306ULL, 0x000e62000020d400ULL, 0x0000009da300720bULL, 0x000fce0003f3d000ULL,
0x000000b500d27306ULL, 0x000ee2000020d400ULL, 0x000000bab900720bULL, 0x004fca0003f7d000ULL,
0x00000001a0a01812ULL, 0x000fe400078efcffULL, 0x0000002e006a7306ULL, 0x000fe20000209400ULL,
0x0000009c9900720bULL, 0x000fca0003f3d000ULL, 0x000000012d2d3812ULL, 0x002fe400078efcffULL,
0x0000002e00e37306ULL, 0x000e620000205400ULL, 0x00000001d2d25812ULL, 0x008fe400078efcffULL,
0x000000a82d2d723eULL, 0x000fc600000010ffULL, 0x0000000193931812ULL, 0x000fe400078efcffULL,
0x0000002e00ca7306ULL, 0x0004e2000020d400ULL, 0x000000989700720bULL, 0x000fce0003f3d000ULL,
0x000000bc00697306ULL, 0x000fe20000209400ULL, 0x000000e36a00720bULL, 0x002fe20003fbd000ULL,
0x00010000492e7824ULL, 0x004fe400078e00ffULL, 0x00010000626a7824ULL, 0x000fe400078e00ffULL,
0x0000000192921812ULL, 0x000fe400078efcffULL, 0x000000bc00e07306ULL, 0x000e620000205400ULL,
0x00000018ffb57819ULL, 0x000fe2000001142eULL, 0x000001004a2e7824ULL, 0x000fe200078e00ffULL,
0x000000969000720bULL, 0x000fc40003f3d000ULL, 0x00000018ff977819ULL, 0x000fe4000001146aULL,
0x00000001caca5812ULL, 0x008fe200078efcffULL, 0x000000bc00c77306ULL, 0x000eb0000020d400ULL,
0x000000b500de7306ULL, 0x000fe20000209400ULL, 0x000000e06900720bULL, 0x002fc40003fbd000ULL,
0x0000000183831812ULL, 0x000fe400078efcffULL, 0x0000008e8d00720bULL, 0x000fc60003f3d000ULL,
0x000000b500df7306ULL, 0x000e6c0000205400ULL, 0x00000001c7c75812ULL, 0x004fe400078efcffULL,
0x00000048006b7306ULL, 0x000fe40000009400ULL, 0x0000000182821812ULL, 0x000fc400078efcffULL,
0x0000008c8900720bULL, 0x000fc80003f3d000ULL, 0x0000004800b37306ULL, 0x000fe20000005400ULL,
0x000000dfde00720bULL, 0x002fce0003fbd000ULL, 0x0000004800cb7306ULL, 0x0003e2000000d400ULL,
0x0000000181811812ULL, 0x000fe400078efcffULL, 0x0000008b8a00720bULL, 0x000fca0003f3d000ULL,
0x0000007200737306ULL, 0x000fe20000209400ULL, 0x00000018ff487819ULL, 0x002fe2000001142eULL,
0x000001004b2e7824ULL, 0x000fca00078e00ffULL, 0x00000018ffb47819ULL, 0x000fe2000001142eULL,
0x0000007200dc7306ULL, 0x000e620000205400ULL, 0x0000000180801812ULL, 0x000fe400078efcffULL,
0x000000888700720bULL, 0x000fca0003f3d000ULL, 0x0000007200d07306ULL, 0x000eb0000020d400ULL,
0x0000004900687306ULL, 0x000fe20000009400ULL, 0x000000dc7300720bULL, 0x002fe40003f9d000ULL,
0x000000017f7f1812ULL, 0x000fca00078efcffULL, 0x0000004900727306ULL, 0x000e6c0000005400ULL,
0x00000001d0d04812ULL, 0x004fe400078efcffULL, 0x0000004900c97306ULL, 0x000eb0000000d400ULL,
0x000000b500c67306ULL, 0x000ee2000020d400ULL, 0x000000726800720bULL, 0x002fe20003f7d000ULL,
0x0001000061687824ULL, 0x000fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000004800497306ULL, 0x000fec0000209400ULL, 0x00000001c9c93812ULL, 0x004fe400078efcffULL,
0x0000004800d47306ULL, 0x000e620000205400ULL, 0x00000001c6c65812ULL, 0x008fce00078efcffULL,
0x000000da00ae7306ULL, 0x000ff00000209400ULL, 0x000000da00ad7306ULL, 0x000ea20000205400ULL,
0x000000d44900720bULL, 0x002fe20003fbd000ULL, 0x0001000030497824ULL, 0x000fcc00078e00ffULL,
0x000000da002c7306ULL, 0x000e70000020d400ULL, 0x0000002f00da7306ULL, 0x000fe20000209400ULL,
0x000000adae00720bULL, 0x004fe20003f5d000ULL, 0x000100004bae7824ULL, 0x000fca00078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x0000002f00db7306ULL, 0x000eac0000205400ULL,
0x000000012c2c2812ULL, 0x002fe400078efcffULL, 0x0000002f00c87306ULL, 0x000fe2000020d400ULL,
0x000000b36b00720bULL, 0x000fe20003f5d000ULL, 0x00000100606b7824ULL, 0x000fe200078e00ffULL,
0x000000a72c2c723eULL, 0x000fc800000010ffULL, 0x00000018ffa47819ULL, 0x000fe2000001146bULL,
0x0000004800c27306ULL, 0x0002e2000020d400ULL, 0x00010000606b7824ULL, 0x000fca00078e00ffULL,
0x00000018ffa97819ULL, 0x000fe4000001146bULL, 0x000000b4002e7306ULL, 0x000fe20000209400ULL,
0x000100004a487824ULL, 0x002fe200078e00ffULL, 0x00000001cbcb2812ULL, 0x000fe400078efcffULL,
0x000000dbda00720bULL, 0x004fe40003f5d000ULL, 0x00000018ffad7819ULL, 0x000fe40000011448ULL,
0x000000b4002f7306ULL, 0x000e620000205400ULL, 0x00000001c2c25812ULL, 0x008fce00078efcffULL,
0x000000b400bc7306ULL, 0x000ea2000020d400ULL, 0x00000001c8c82812ULL, 0x000fce00078efcffULL,
0x000000ae00cc7306ULL, 0x000fe20000209400ULL, 0x0000002f2e00720bULL, 0x002fe20003fbd000ULL,
0x00000100322e7824ULL, 0x000fe400078e00ffULL, 0x00000100332f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x000000ae00cd7306ULL, 0x000e620000205400ULL,
0x00000018ff2f7819ULL, 0x000fca000001142fULL, 0x00000001bcbc5812ULL, 0x004fe400078efcffULL,
0x000000ae00bd7306ULL, 0x000eb0000020d400ULL, 0x000000a400c47306ULL, 0x000fe20000209400ULL,
0x000000cdcc00720bULL, 0x002fce0003fbd000ULL, 0x000000a400c57306ULL, 0x000e6c0000205400ULL,
0x00000001bdbd5812ULL, 0x004fe400078efcffULL, 0x000000a400b87306ULL, 0x000eb0000020d400ULL,
0x000000a9006b7306ULL, 0x000fe20000209400ULL, 0x000000c5c400720bULL, 0x002fce0003fbd000ULL,
0x000000a900ae7306ULL, 0x000e6c0000205400ULL, 0x00000001b8b85812ULL, 0x004fe400078efcffULL,
0x0000004b00ec7306ULL, 0x000ff00000009400ULL, 0x0000004b00ee7306ULL, 0x000ea20000005400ULL,
0x000000ae6b00720bULL, 0x002fe20003fbd000ULL, 0x00000100416b7824ULL, 0x000fcc00078e00ffULL,
0x0000004b00be7306ULL, 0x000e70000000d400ULL, 0x00000060004b7306ULL, 0x000fe20000009400ULL,
0x000000eeec00720bULL, 0x004fce0003f9d000ULL, 0x0000006000e87306ULL, 0x000eac0000005400ULL,
0x00000001bebe4812ULL, 0x002fe400078efcffULL, 0x0000006000b67306ULL, 0x0002f0000000d400ULL,
0x0000004a00aa7306ULL, 0x000fe20000009400ULL, 0x0000010061607824ULL, 0x002fe200078e00ffULL,
0x000000e84b00720bULL, 0x004fc40003f7d000ULL, 0x00000018ff4b7819ULL, 0x000fe20000011449ULL,
0x0001000031497824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000004a00e97306ULL, 0x000e640000005400ULL, 0x00000018ff897819ULL, 0x000fca0000011449ULL,
0x00000001b6b63812ULL, 0x008fe200078efcffULL, 0x000000a900b37306ULL, 0x000eb0000020d400ULL,
0x0000006800ba7306ULL, 0x000fe20000209400ULL, 0x000000e9aa00720bULL, 0x002fce0003fdd000ULL,
0x0000006800bb7306ULL, 0x000e620000205400ULL, 0x00000001b3b35812ULL, 0x004fce00078efcffULL,
0x0000006100ea7306ULL, 0x000ff00000009400ULL, 0x0000006100eb7306ULL, 0x000ea20000005400ULL,
0x000000bbba00720bULL, 0x002fce0003fbd000ULL, 0x0000006100b77306ULL, 0x0002f0000000d400ULL,
0x0000006000b47306ULL, 0x000fe20000209400ULL, 0x0000010062617824ULL, 0x002fe200078e00ffULL,
0x000000ebea00720bULL, 0x004fc80003f5d000ULL, 0x00000018ff997819ULL, 0x000fe40000011461ULL,
0x0000006000b57306ULL, 0x000e6e0000205400ULL, 0x00000001b7b72812ULL, 0x008fe200078efcffULL,
0x0000006000b97306ULL, 0x0004e2000020d400ULL, 0x000000a6a500720bULL, 0x000fce0003f5d000ULL,
0x0000004a00c37306ULL, 0x000f22000000d400ULL, 0x0000010063607824ULL, 0x004fe200078e00ffULL,
0x000000b5b400720bULL, 0x002fc80003f7d000ULL, 0x00000018ff9c7819ULL, 0x000fe40000011460ULL,
0x000000ad00487306ULL, 0x000fe20000209400ULL, 0x000000017b7b2812ULL, 0x000fcc00078efcffULL,
0x00000001b9b93812ULL, 0x008fe200078efcffULL, 0x000000ad004a7306ULL, 0x000e620000205400ULL,
0x00000001c3c36812ULL, 0x010fe400078efcffULL, 0x00000086ab00720bULL, 0x000fca0003f7d000ULL,
0x000000ad00bf7306ULL, 0x000eb0000020d400ULL, 0x0000006800ad7306ULL, 0x000ee2000020d400ULL,
0x0000004a4800720bULL, 0x002fe40003fdd000ULL, 0x000000017c7c3812ULL, 0x000fc400078efcffULL,
0x0000009f9e00720bULL, 0x000fc60003f7d000ULL, 0x0000009900727306ULL, 0x000fec0000209400ULL,
0x00000001bfbf6812ULL, 0x004fe400078efcffULL, 0x0000009900737306ULL, 0x000e620000205400ULL,
0x00000001adad5812ULL, 0x008fe400078efcffULL, 0x0000000178783812ULL, 0x000fc400078efcffULL,
0x0000009b9a00720bULL, 0x000fc60003f7d000ULL, 0x0000006200607306ULL, 0x000ff00000009400ULL,
0x0000006200c07306ULL, 0x000ea20000005400ULL, 0x000000737200720bULL, 0x002fe40003fbd000ULL,
0x0000000174743812ULL, 0x000fca00078efcffULL, 0x0000009900a97306ULL, 0x000e70000020d400ULL,
0x0000006300d57306ULL, 0x000fe20000009400ULL, 0x000000c06000720bULL, 0x004fce0003f9d000ULL,
0x0000006300e97306ULL, 0x000ea20000005400ULL, 0x00000001a9a95812ULL, 0x002fce00078efcffULL,
0x0000009c00617306ULL, 0x000ff00000209400ULL, 0x0000009c00687306ULL, 0x000e620000205400ULL,
0x000000e9d500720bULL, 0x004fce0003fdd000ULL, 0x0000006200aa7306ULL, 0x0004f0000000d400ULL,
0x0000006300a47306ULL, 0x0008e2000000d400ULL, 0x0001000063627824ULL, 0x004fe200078e00ffULL,
0x000000686100720bULL, 0x002fc80003fbd000ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x00000097006a7306ULL, 0x000fe20000209400ULL, 0x0000010030637824ULL, 0x010fe200078e00ffULL,
0x00000001aaaa4812ULL, 0x008fc800078efcffULL, 0x00000018ff967819ULL, 0x000fe20000011463ULL,
0x0000010031637824ULL, 0x000fe200078e00ffULL, 0x0000009700af7306ULL, 0x000e620000205400ULL,
0x00000001a4a46812ULL, 0x000fce00078efcffULL, 0x0000003000df7306ULL, 0x000ff00000009400ULL,
0x0000003000e07306ULL, 0x000ea20000005400ULL, 0x000000af6a00720bULL, 0x002fce0003f9d000ULL,
0x0000009700a37306ULL, 0x0002f0000020d400ULL, 0x0000009c009d7306ULL, 0x000f22000020d400ULL,
0x00000018ff977819ULL, 0x002fe40000011463ULL, 0x000000e0df00720bULL, 0x004fca0003f3d000ULL,
0x0000009600697306ULL, 0x000fe20000209400ULL, 0x00000001a3a34812ULL, 0x008fce00078efcffULL,
0x0000009600c17306ULL, 0x000e620000205400ULL, 0x000000019d9d5812ULL, 0x010fce00078efcffULL,
0x0000006200dc7306ULL, 0x000ff00000209400ULL, 0x0000006200dd7306ULL, 0x000ea20000205400ULL,
0x000000c16900720bULL, 0x002fce0003fdd000ULL, 0x0000003100d97306ULL, 0x000ff00000009400ULL,
0x0000003100da7306ULL, 0x000e620000005400ULL, 0x000000dddc00720bULL, 0x004fce0003fbd000ULL,
0x00000062009c7306ULL, 0x000eb0000020d400ULL, 0x0000009700627306ULL, 0x000fe20000209400ULL,
0x000000dad900720bULL, 0x002fce0003f9d000ULL, 0x0000009700637306ULL, 0x000fe20000205400ULL,
0x000000019c9c5812ULL, 0x004fe400078efcffULL, 0x000000918f00720bULL, 0x000fca0003fbd000ULL,
0x0000009700907306ULL, 0x000ff0000020d400ULL, 0x0000003000987306ULL, 0x000e62000000d400ULL,
0x0000000177775812ULL, 0x000fce00078efcffULL, 0x0000004b00307306ULL, 0x000ff00000209400ULL,
0x0000004b00de7306ULL, 0x000ea20000205400ULL, 0x0000000198981812ULL, 0x002fce00078efcffULL,
0x0000004b00977306ULL, 0x000e70000020d400ULL, 0x0000002e00497306ULL, 0x000fe20000209400ULL,
0x000000de3000720bULL, 0x004fe20003f3d000ULL, 0x0001000042307824ULL, 0x000fca00078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe20000011430ULL, 0x0000002e004b7306ULL, 0x000fe20000205400ULL,
0x0001000043307824ULL, 0x000fca00078e00ffULL, 0x0000000197971812ULL, 0x002fe400078efcffULL,
0x0000002e008d7306ULL, 0x0003f0000020d400ULL, 0x0000003200e17306ULL, 0x000fe20000009400ULL,
0x00010000322e7824ULL, 0x002fca00078e00ffULL, 0x00000018ffc47819ULL, 0x000fe4000001142eULL,
0x0000003200e37306ULL, 0x000e700000005400ULL, 0x00000032008e7306ULL, 0x0004f0000000d400ULL,
0x0000009600997306ULL, 0x000f22000020d400ULL, 0x0001000033327824ULL, 0x004fe200078e00ffULL,
0x000000e3e100720bULL, 0x002fc80003f5d000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003100967306ULL, 0x000e6e000000d400ULL, 0x000000018e8e2812ULL, 0x008fe200078efcffULL,
0x0000003200d47306ULL, 0x000fe20000209400ULL, 0x0000000199996812ULL, 0x010fc400078efcffULL,
0x000000636200720bULL, 0x000fe40003fdd000ULL, 0x000000989998723eULL, 0x000fc600000010ffULL,
0x0000003200d57306ULL, 0x000fe20000205400ULL, 0x0000000196964812ULL, 0x002fe400078efcffULL,
0x0000004b4900720bULL, 0x000fca0003f9d000ULL, 0x0000003200887306ULL, 0x0003e2000020d400ULL,
0x0000000190906812ULL, 0x000fc800078efcffULL, 0x000000969099723eULL, 0x000fc600000010ffULL,
0x0000008900317306ULL, 0x000fe20000209400ULL, 0x00000018ff327819ULL, 0x002fe4000001146bULL,
0x000000018d8d4812ULL, 0x000fca00078efcffULL, 0x0000008900db7306ULL, 0x000e700000205400ULL,
0x00000089008c7306ULL, 0x000eb0000020d400ULL, 0x0000002f00487306ULL, 0x000fe20000209400ULL,
0x000000db3100720bULL, 0x002fce0003fdd000ULL, 0x0000002f004a7306ULL, 0x000e6c0000205400ULL,
0x000000018c8c6812ULL, 0x004fe400078efcffULL, 0x0000002f00897306ULL, 0x000eb0000020d400ULL,
0x000000c4002e7306ULL, 0x000fe20000209400ULL, 0x0000004a4800720bULL, 0x002fce0003f9d000ULL,
0x000000c4002f7306ULL, 0x000fec0000205400ULL, 0x0000000189894812ULL, 0x004fe400078efcffULL,
0x000000c4008b7306ULL, 0x000fe2000020d400ULL, 0x000000959400720bULL, 0x000fe40003f9d000ULL,
0x000000cbca94723eULL, 0x000fc400000010ffULL, 0x000000c9c795723eULL, 0x000fe200000010ffULL,
0x0000010047c77824ULL, 0x000fe400078e00ffULL, 0x0000003300607306ULL, 0x000fe60000009400ULL,
0x00000018ffc77819ULL, 0x000fc600000114c7ULL, 0x000000016f6f4812ULL, 0x000fe400078efcffULL,
0x0000003300c07306ULL, 0x000e620000005400ULL, 0x000000d5d400720bULL, 0x000fce0003f9d000ULL,
0x00000033008a7306ULL, 0x0004ec000000d400ULL, 0x0000000188884812ULL, 0x000fe400078efcffULL,
0x0000003200c47306ULL, 0x000fe20000209400ULL, 0x0000010040337824ULL, 0x004fe200078e00ffULL,
0x000000c06000720bULL, 0x002fc80003f3d000ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003200c57306ULL, 0x000e6e0000205400ULL, 0x000000018a8a1812ULL, 0x008fe200078efcffULL,
0x00000032006b7306ULL, 0x0005e2000020d400ULL, 0x0000002f2e00720bULL, 0x000fc40003f3d000ULL,
0x000000ceb02e723eULL, 0x000fe400000010ffULL, 0x000000cfd12f723eULL, 0x000fc600000010ffULL,
0x0000004000df7306ULL, 0x000fe20000009400ULL, 0x0001000040327824ULL, 0x004fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000004000e07306ULL, 0x000ea20000005400ULL,
0x000000018b8b1812ULL, 0x000fe400078efcffULL, 0x000000848500720bULL, 0x000fe20003f3d000ULL,
0x0001000044857824ULL, 0x000fc800078e00ffULL, 0x0000004000867306ULL, 0x000722000000d400ULL,
0x00000018ffc97819ULL, 0x000fce0000011485ULL, 0x0000003300cc7306ULL, 0x000fe20000209400ULL,
0x0000010042407824ULL, 0x008fe200078e00ffULL, 0x000000016d6d1812ULL, 0x000fe400078efcffULL,
0x000000c5c400720bULL, 0x002fe40003f3d000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000003300cd7306ULL, 0x000e620000205400ULL, 0x000000e0df00720bULL, 0x004fce0003fbd000ULL,
0x0000003300877306ULL, 0x0004e2000020d400ULL, 0x000000016b6b1812ULL, 0x000fca00078efcffULL,
0x0000000186865812ULL, 0x010fe400078efcffULL, 0x0000003200bb7306ULL, 0x000fe20000209400ULL,
0x0001000041337824ULL, 0x004fe200078e00ffULL, 0x000000cdcc00720bULL, 0x002fe40003f9d000ULL,
0x0000007e7d00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000003200ba7306ULL, 0x000e6e0000205400ULL, 0x0000000187874812ULL, 0x008fe200078efcffULL,
0x0000003200737306ULL, 0x0004e2000020d400ULL, 0x000000016c6c5812ULL, 0x000fc400078efcffULL,
0x000000868786723eULL, 0x000fca00000010ffULL, 0x0000004000ae7306ULL, 0x000fe20000209400ULL,
0x0000010043327824ULL, 0x004fe200078e00ffULL, 0x000000babb00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000004000af7306ULL, 0x000e6e0000205400ULL,
0x0000000173734812ULL, 0x008fe200078efcffULL, 0x00000040006a7306ULL, 0x000ea6000020d400ULL,
0x000000736c6c723eULL, 0x000fca00000010ffULL, 0x0000004200407306ULL, 0x000fe20000009400ULL,
0x000000afae00720bULL, 0x002fce0003f9d000ULL, 0x0000004200c17306ULL, 0x000e6c0000005400ULL,
0x000000016a6a4812ULL, 0x004fe400078efcffULL, 0x0000004200697306ULL, 0x0004f0000000d400ULL,
0x0000003300b47306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x004fc40000011430ULL,
0x000128006e307811ULL, 0x000fe400078e20ffULL, 0x000000c14000720bULL, 0x002fe40003f7d000ULL,
0x00012800b2407811ULL, 0x000fe200078e20ffULL, 0x0000003300b57306ULL, 0x000e700000205400ULL,
0x0000003300687306ULL, 0x000ea4000020d400ULL, 0x0000000169693812ULL, 0x008fc400078efcffULL,
0x000000767500720bULL, 0x000fe40003f7d000ULL, 0x000000696a6a723eULL, 0x000fe400000010ffULL,
0x0000003200a57306ULL, 0x000fe20000209400ULL, 0x000000b5b400720bULL, 0x002fce0003f3d000ULL,
0x0000003200a67306ULL, 0x000e620000205400ULL, 0x000000010d0d3812ULL, 0x000fca00078efcffULL,
0x0000000168681812ULL, 0x004fe400078efcffULL, 0x0000003200617306ULL, 0x0004f0000020d400ULL,
0x0000004100ab7306ULL, 0x000fe20000009400ULL, 0x000000003030783bULL, 0x004ea20000000200ULL,
0x000000a6a500720bULL, 0x002fcc0003f3d000ULL, 0x0000004100e87306ULL, 0x000e6e0000005400ULL,
0x0000000161611812ULL, 0x008fe200078efcffULL, 0x0000004100727306ULL, 0x000ef0000000d400ULL,
0x0000004300417306ULL, 0x000fe20000009400ULL, 0x000000e8ab00720bULL, 0x002fce0003fdd000ULL,
0x0000004300d97306ULL, 0x000e6c0000005400ULL, 0x0000000172726812ULL, 0x008fe400078efcffULL,
0x0000004300627306ULL, 0x000722000000d400ULL, 0x0000007130308231ULL, 0x084fe200003400ffULL,
0x0000007a7900720bULL, 0x000fe20003fdd000ULL, 0x0000007132328231ULL, 0x000fe200003400ffULL,
0x000000726b87723eULL, 0x000fe200000010ffULL, 0x0000007031318231ULL, 0x000fc400003400ffULL,
0x0000007033338231ULL, 0x000fe200003400ffULL, 0x0000008f009e7306ULL, 0x000fe20000209400ULL,
0x0000010044437824ULL, 0x008fe200078e00ffULL, 0x000000d94100720bULL, 0x002fc80003f5d000ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000002c304c723cULL, 0x000fe2000004184cULL,
0x0000008f009f7306ULL, 0x000e620000205400ULL, 0x0000000165656812ULL, 0x000fca00078efcffULL,
0x000000a2a12c723eULL, 0x000fe200000010ffULL, 0x0000002e3054723cULL, 0x040fe20000041854ULL,
0x000000aca02d723eULL, 0x000fe200000010ffULL, 0x0000008f00637306ULL, 0x000ea2000020d400ULL,
0x0000000162622812ULL, 0x010fe400078efcffULL, 0x000000d3d600720bULL, 0x000fe40003f5d000ULL,
0x00012800b12e7811ULL, 0x000fe200078e20ffULL, 0x0000002c3050723cULL, 0x000fe20000041850ULL,
0x0000009f9e00720bULL, 0x002fe20003f9d000ULL, 0x00000042009a7306ULL, 0x000fe20000209400ULL,
0x00000062616b723eULL, 0x000fc800000010ffULL, 0x00000100452c7824ULL, 0x000fe200078e00ffULL,
0x000000d2922d723eULL, 0x000fe200000010ffULL, 0x000000943058723cULL, 0x040fe20000041858ULL,
0x00000042009b7306ULL, 0x000e620000205400ULL, 0x000000c88392723eULL, 0x000fe200000010ffULL,
0x0000010046c87824ULL, 0x000fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe4000001142cULL,
0x000000d0932c723eULL, 0x000fe200000010ffULL, 0x0001000047947824ULL, 0x000fe200078e00ffULL,
0x000000c68293723eULL, 0x000fe200000010ffULL, 0x0000004200497306ULL, 0x000ee2000020d400ULL,
0x0001000045827824ULL, 0x000fe200078e00ffULL, 0x000000bd8083723eULL, 0x000fe200000010ffULL,
0x0001000046c67824ULL, 0x000fe200078e00ffULL, 0x0000002c305c723cULL, 0x000fe2000004185cULL,
0x000000002e2c783bULL, 0x000f220000000200ULL, 0x0000000163634812ULL, 0x004fc400078efcffULL,
0x0000004300917306ULL, 0x000fe20000209400ULL, 0x0000009b9a00720bULL, 0x002fe40003f3d000ULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000000923034723cULL, 0x000fe20000041834ULL,
0x00000018ffc67819ULL, 0x000fe400000114c6ULL, 0x00000018ff947819ULL, 0x000fe20000011494ULL,
0x00000043008f7306ULL, 0x000e620000205400ULL, 0x000000010c0c2812ULL, 0x000fe400078efcffULL,
0x00000018ff927819ULL, 0x000fc40000011482ULL, 0x000000bf8182723eULL, 0x000fe400000010ffULL,
0x0000000149491812ULL, 0x008fe200078efcffULL, 0x00000043004b7306ULL, 0x0004e2000020d400ULL,
0x000000f3f400720bULL, 0x000fc60003f5d000ULL, 0x00000082303c723cULL, 0x000fe8000004183cULL,
0x0000004400c07306ULL, 0x000fe20000009400ULL, 0x000000004040783bULL, 0x004ea20000000200ULL,
0x0000008f9100720bULL, 0x002fc80003f9d000ULL, 0x0000000167672812ULL, 0x000fe400078efcffULL,
0x0000004400c17306ULL, 0x000e620000005400ULL, 0x000000d7d800720bULL, 0x000fe20003f5d000ULL,
0x000000712c2c8231ULL, 0x090fe400003400ffULL, 0x000000712e2e8231ULL, 0x000fc800003400ffULL,
0x00000044004a7306ULL, 0x000fe2000000d400ULL, 0x000000702d2d8231ULL, 0x080fe200003400ffULL,
0x000000014b4b4812ULL, 0x008fe200078efcffULL, 0x000000702f2f8231ULL, 0x000fc600003400ffULL,
0x000000010e0e2812ULL, 0x000fe400078efcffULL, 0x0000004600ab7306ULL, 0x000ff00000009400ULL,
0x0000004600ac7306ULL, 0x000ef00000005400ULL, 0x0000004600487306ULL, 0x0008e2000000d400ULL,
0x0000007140408231ULL, 0x004fc400003400ffULL, 0x0000007142428231ULL, 0x000fe400003400ffULL,
0x0000007041418231ULL, 0x080fe400003400ffULL, 0x0000007043438231ULL, 0x000fe200003400ffULL,
0x0000004700a07306ULL, 0x000fe20000009400ULL, 0x000000c3c246723eULL, 0x010fe400000010ffULL,
0x000000c1c000720bULL, 0x002fe40003f1d000ULL, 0x000000acab00720bULL, 0x008fe20003fdd000ULL,
0x000000984058723cULL, 0x000fe40000041858ULL, 0x0000004700a27306ULL, 0x000e700000005400ULL,
0x0000004700447306ULL, 0x0005e2000000d400ULL, 0x000000014a4a0812ULL, 0x000fc400078efcffULL,
0x000000f1f200720bULL, 0x000fe40003f1d000ULL, 0x0000000148486812ULL, 0x000fe400078efcffULL,
0x0000004a4b4a723eULL, 0x000fe200000010ffULL, 0x000000ce00a17306ULL, 0x000fe20000209400ULL,
0x000000bebc47723eULL, 0x004fe400000010ffULL, 0x000000a2a000720bULL, 0x002fca0003f7d000ULL,
0x000000463038723cULL, 0x000fe20000041838ULL, 0x000000ce00b07306ULL, 0x000e620000205400ULL,
0x000000010f0f0812ULL, 0x000fca00078efcffULL, 0x000000b37f30723eULL, 0x000fe400000010ffULL,
0x000000ad7c31723eULL, 0x000fe200000010ffULL, 0x000000c900857306ULL, 0x000fe20000209400ULL,
0x000000b6b846723eULL, 0x000fe400000010ffULL, 0x000000b7b947723eULL, 0x000fe400000010ffULL,
0x000000aaa932723eULL, 0x000fe200000010ffULL, 0x000000304050723cULL, 0x000fe20000041850ULL,
0x000000a49d33723eULL, 0x000fe200000010ffULL, 0x000000c900957306ULL, 0x000ea20000205400ULL,
0x000000b0a100720bULL, 0x002fc40003f3d000ULL, 0x0000000144443812ULL, 0x000fe400078efcffULL,
0x000000a37b30723eULL, 0x000fe200000010ffULL, 0x00000046404c723cULL, 0x040fe2000004184cULL,
0x0000009c7831723eULL, 0x000fe200000010ffULL, 0x0000004500a77306ULL, 0x000fec0000009400ULL,
0x00000030405c723cULL, 0x000fe4000004185cULL, 0x0000004500a87306ULL, 0x000e620000005400ULL,
0x000000958500720bULL, 0x004fc80003f9d000ULL, 0x000000977730723eULL, 0x000fe200000010ffULL,
0x000000324054723cULL, 0x040fe20000041854ULL, 0x0000008c7431723eULL, 0x000fe200000010ffULL,
0x0000004500607306ULL, 0x000eaa000000d400ULL, 0x0000008e8d32723eULL, 0x000fe200000010ffULL,
0x000000304034723cULL, 0x000fe20000041834ULL, 0x0000008a8933723eULL, 0x000fe200000010ffULL,
0x000000ce00847306ULL, 0x000ee2000020d400ULL, 0x000000a8a700720bULL, 0x002fc80003fbd000ULL,
0x0000008b6f30723eULL, 0x000fe200000010ffULL, 0x000000324038723cULL, 0x000fe20000041838ULL,
0x000000886d31723eULL, 0x000fe200000010ffULL, 0x000000c900457306ULL, 0x000e62000020d400ULL,
0x00000068656d723eULL, 0x000fca00000010ffULL, 0x00000030403c723cULL, 0x000fe2000004183cULL,
0x0000000160605812ULL, 0x004fe200078efcffULL, 0x0000009200817306ULL, 0x000fe20000209400ULL,
0x0000000184841812ULL, 0x008fe400078efcffULL, 0x000000edef00720bULL, 0x000fe40003fbd000ULL,
0x000000630d30723eULL, 0x000fe200000010ffULL, 0x000000862c4c723cULL, 0x000fe2000004184cULL,
0x000000490c31723eULL, 0x000fe200000010ffULL, 0x0000009200807306ULL, 0x000ea20000205400ULL,
0x0000000145454812ULL, 0x002fc400078efcffULL, 0x00000060844b723eULL, 0x000fe400000010ffULL,
0x00000045670c723eULL, 0x000fe200000010ffULL, 0x000000302c5c723cULL, 0x000fe4000004185cULL,
0x000000c800467306ULL, 0x000fe20000209400ULL, 0x0000000166665812ULL, 0x000fca00078efcffULL,
0x0000006c2c50723cULL, 0x000fe40000041850ULL, 0x000000c800717306ULL, 0x000e620000205400ULL,
0x000000808100720bULL, 0x004fca0003f3d000ULL, 0x0000006a2c54723cULL, 0x040fe40000041854ULL,
0x0000009200707306ULL, 0x000eac000020d400ULL, 0x0000004a2c58723cULL, 0x000fe40000041858ULL,
0x000000c800477306ULL, 0x000ee2000020d400ULL, 0x000000714600720bULL, 0x002fce0003f9d000ULL,
0x000000c700787306ULL, 0x000fe20000209400ULL, 0x0000000170701812ULL, 0x004fc800078efcffULL,
0x000000700f0d723eULL, 0x000fc600000010ffULL, 0x000000c700757306ULL, 0x000e620000205400ULL,
0x0000000147474812ULL, 0x008fc600078efcffULL, 0x0000000c2c34723cULL, 0x000fe20000041834ULL,
0x000000484748723eULL, 0x000fc600000010ffULL, 0x000000c600327306ULL, 0x000ff00000209400ULL,
0x000000c600337306ULL, 0x000ea20000205400ULL, 0x000000757800720bULL, 0x002fce0003f3d000ULL,
0x0000009400407306ULL, 0x000ff00000209400ULL, 0x0000009400437306ULL, 0x000e620000205400ULL,
0x000000333200720bULL, 0x004fce0003f1d000ULL, 0x000000c700777306ULL, 0x000eb0000020d400ULL,
0x000000c600417306ULL, 0x000ee2000020d400ULL, 0x000000434000720bULL, 0x002fce0003f9d000ULL,
0x0000009400317306ULL, 0x000e62000020d400ULL, 0x0000000177771812ULL, 0x004fc800078efcffULL,
0x000000447749723eULL, 0x000fe400000010ffULL, 0x0000000141410812ULL, 0x008fc800078efcffULL,
0x000000416666723eULL, 0x000fe200000010ffULL, 0x000000482c38723cULL, 0x000fe20000041838ULL,
0x0000000131314812ULL, 0x002fc800078efcffULL, 0x000000310e67723eULL, 0x000fce00000010ffULL,
0x000000662c3c723cULL, 0x000fe2000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080001f57983ULL, 0x000ea20000100800ULL,
0x000000ff0bff7812ULL, 0x000fe4000784c0ffULL, 0x00000080030d7811ULL, 0x000fe200078e40ffULL,
0x01c62000ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000001ff0c7807ULL, 0x000fe40001000000ULL,
0x0000000d0200720cULL, 0x000fe40003f44070ULL, 0x00000001130e7812ULL, 0x000fc8000782c0ffULL,
0x0000000b0c0d7207ULL, 0x000fe40004800000ULL, 0x000000fff5ff7812ULL, 0x004fc8000780c0ffULL,
0x00000001ff0f7807ULL, 0x000fe20004000000ULL, 0x000096800000a947ULL, 0x000fea0003800000ULL,
0x01c65c00ff0f7984ULL, 0x000e620000000800ULL, 0x00000001ff0e7807ULL, 0x000fca0004000000ULL,
0x800000000e067824ULL, 0x000fca00078e00ffULL, 0x800000000fff7812ULL, 0x002fe20007824806ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007824806ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x800000000e0f7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x00000006000e7305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc4000782480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000012a277824ULL, 0x000fe200078e0227ULL,
0x00000000002d7919ULL, 0x000e620000002700ULL, 0x00005800ff2c7624ULL, 0x000fe400078e00ffULL,
0x00000300ff067624ULL, 0x000fe200078e00ffULL, 0x00000003270e7812ULL, 0x000fe200078ec0ffULL,
0x000000402c2c7824ULL, 0x000fe400078e00ffULL, 0x00006400ff2e7624ULL, 0x000fe200078e00ffULL,
0xfffffffd06067811ULL, 0x000fe200078e10ffULL, 0x0000000407437e24ULL, 0x020fe2000f8e022cULL,
0x000000030e00780cULL, 0x000fe20003f25270ULL, 0x00000000002c7919ULL, 0x000ea20000000000ULL,
0xffffffffff077424ULL, 0x000fc400078e00ffULL, 0x00000001062a7807ULL, 0x000fca0004800000ULL,
0x0000000127067824ULL, 0x000fe200078e022aULL, 0x00000000004b7919ULL, 0x000ee80000000000ULL,
0x000000040600720cULL, 0x000fe20003f26070ULL, 0x000000022d2d7824ULL, 0x002fc800078e00ffULL,
0x000064002d2d7624ULL, 0x000fd000078e022eULL, 0x00000001062e9824ULL, 0x000fe200078e022dULL,
0x00000004ff2d7819ULL, 0x004fe2000001162cULL, 0x00000010002c7824ULL, 0x000fe400078e00ffULL,
0x00000004ff2f9424ULL, 0x000fe400078e00ffULL, 0x000000012c2c7824ULL, 0x000fe200078e022dULL,
0x000000c003317811ULL, 0x040fe200078e40ffULL, 0x000060002e2e9625ULL, 0x000fe200078e002fULL,
0x00000001030e7810ULL, 0x000fe40007ffe0ffULL, 0x0000003f430f7812ULL, 0x000fe200078ef82cULL,
0x00000100ff487424ULL, 0x000fe200078e00ffULL, 0x0000003102307217ULL, 0x000fe20007800000ULL,
0x000000104b497824ULL, 0x008fe200078e00ffULL, 0x000000062e079981ULL, 0x000362000c1e1900ULL,
0x000000050e00720cULL, 0x000fe20003f26070ULL, 0x00005e000f0e7625ULL, 0x080fe200078e0048ULL,
0x0000003f43337812ULL, 0x000fe200078ef811ULL, 0x00000000180573c2ULL, 0x000ea200000e0000ULL,
0x000000f049497812ULL, 0x000fe200078ec0ffULL, 0x0000000130447824ULL, 0x000fe200078e0a31ULL,
0x0000003f432d7812ULL, 0x000fe200078ef810ULL, 0x00000010004a7824ULL, 0x000fe200078e00ffULL,
0x000000490e0e7210ULL, 0x000fe20007f5e0ffULL, 0x00005e00332e7625ULL, 0x002fe200078e0048ULL,
0x0000003f43417812ULL, 0x000fc400078ef815ULL, 0x0000003f43337812ULL, 0x000fe200078ef814ULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000004044467807ULL, 0x000fe20000800000ULL,
0x00005e002d2c7625ULL, 0x080fe200078e0048ULL, 0x000000492e2e7210ULL, 0x000fe40007f5e0ffULL,
0x0000003f43457812ULL, 0x000fe200078ef816ULL, 0x00005e0041407625ULL, 0x000fe200078e0048ULL,
0x000000464a467217ULL, 0x000fe40007800000ULL, 0x0000003f43317812ULL, 0x000fe200078ef812ULL,
0x00005e0033327625ULL, 0x000fe200078e0048ULL, 0x0000003f43477812ULL, 0x000fc400078ef817ULL,
0x000000492c2c7210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e062fULL,
0x0000004940407210ULL, 0x080fe20007f3e0ffULL, 0x00005e0045427625ULL, 0x080fe200078e0048ULL,
0x0000004932327210ULL, 0x000fe20007f5e0ffULL, 0x0001c64805057891ULL, 0x004fe2000f8e183fULL,
0x00000004ff637819ULL, 0x000fe2000001164bULL, 0x0000000146467824ULL, 0x000fe400078e0a4aULL,
0x00005e0031307625ULL, 0x000fe200078e0048ULL, 0x00000002634b7810ULL, 0x000fc40007ffe0ffULL,
0x000000466300720cULL, 0x000fe20003f86070ULL, 0x00005e0047447625ULL, 0x000fe200078e0048ULL,
0x0000000663477810ULL, 0x000fe40007ffe0ffULL, 0x000000464b00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff2d7224ULL, 0x000fe200018e062dULL, 0x0000004930307210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff417224ULL, 0x000fe200008e0641ULL, 0x0000004944447210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff337224ULL, 0x000fe200010e0633ULL, 0x0000004942427210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff317224ULL, 0x000fe200018e0631ULL, 0x0000000463497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff457224ULL, 0x000fe200008e0645ULL, 0x000000464700720cULL, 0x080fe20003f26070ULL,
0x00000010e7477824ULL, 0x000fe200078e022bULL, 0x000000464900720cULL, 0x000fe20003f66070ULL,
0x000000ffff437224ULL, 0x000fe200010e0643ULL, 0x0000000863497810ULL, 0x000fc40007ffe0ffULL,
0x0000000a634b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e477faeULL, 0x0003e2000e101c46ULL, 0x000000464900720cULL, 0x080fe20003f46070ULL,
0x00000010e6497824ULL, 0x100fe200078e022bULL, 0x000000464b00720cULL, 0x080fe20003f86070ULL,
0x00000010e54b7824ULL, 0x100fe200078e022bULL, 0x0000000c63617810ULL, 0x040fe40007ffe0ffULL,
0x0000000e63657810ULL, 0x000fe20007ffe0ffULL, 0x000000002c497faeULL, 0x0005e2000e901c46ULL,
0x000000466100720cULL, 0x000fe20003fa6070ULL, 0x00000010e4617824ULL, 0x000fc400078e022bULL,
0x000000002e4b7faeULL, 0x0007e2000d901c46ULL, 0x000000466500720cULL, 0x000fe20003f66070ULL,
0x0000001019637824ULL, 0x100fe200078e022bULL, 0x00000008280e7812ULL, 0x002fe200078ec0ffULL,
0x000000101a0f7824ULL, 0x100fe200078e022bULL, 0x0000000030617faeULL, 0x0007e2000c901c46ULL,
0x000000101b2d7824ULL, 0x004fc600078e022bULL, 0x0000000032637faeULL, 0x0007e2000d101c46ULL,
0x000000101c2b7824ULL, 0x000fc600078e022bULL, 0x00000000400f7faeULL, 0x0007e8000e101c46ULL,
0x00000000422d7faeULL, 0x0007e8000e901c46ULL, 0x00000000442b7faeULL, 0x0007e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c64c000e0e7984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c62c00ff0f7984ULL, 0x008ea20000000800ULL,
0x0000ffff0d0d7812ULL, 0x000fe200078ec0ffULL, 0x800000001d2c7824ULL, 0x000fc600078e00ffULL,
0x000088800d0d7816ULL, 0x000fca00000000ffULL, 0x800000000d0d7824ULL, 0x000fca00078e00ffULL,
0x800000000eff7812ULL, 0x002fe4000782480dULL, 0x800000000fff7812ULL, 0x004fe2000784482cULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fe400078e00ffULL, 0x800000001d0f7824ULL, 0x000fe400078e00ffULL,
0x0000000d000e7305ULL, 0x0002a4000021f000ULL, 0x3fa000000d0d7823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe40003800000ULL, 0x01c62c00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc4000784480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x01c100001e0d7984ULL, 0x000e620000000800ULL,
0x00000001ff767424ULL, 0x000fc600078e00ffULL, 0x01c300001e0e7984ULL, 0x0004e20000000800ULL,
0x000000080d00720bULL, 0x002fda0003f5d000ULL, 0x00000000000f7806ULL, 0x000fc800010e0100ULL,
0x0000ffff0f2b7812ULL, 0x000fda000784c0ffULL, 0x000003700000a947ULL, 0x000fea0003800000ULL,
0x000000080d00720bULL, 0x00cfe20003f54000ULL, 0x0000000000307919ULL, 0x000e620000000000ULL,
0x0000000d082d7209ULL, 0x000fca0007810000ULL, 0x8000002d080f7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x0000000f002c7308ULL, 0x000ea20000000800ULL, 0x000000020000780cULL, 0x000fe40003f45270ULL,
0x0000ffff082e7812ULL, 0x000fc800078e3cffULL, 0x0000002e2bff7212ULL, 0x000fe4000786c0ffULL,
0x00000002ff2f7819ULL, 0x102fe40000011630ULL, 0x00000002ff307819ULL, 0x000fc60000011630ULL,
0x01c5002d1e00a388ULL, 0x000fe20000000800ULL, 0x00000001ff767807ULL, 0x000fe20001800000ULL,
0x0000002c09097220ULL, 0x004fe20000410000ULL, 0x0000000830307810ULL, 0x000fe20007ffe0ffULL,
0x00001f2f2c087589ULL, 0x000e6400000e0000ULL, 0x8000002d0d2b3221ULL, 0x000fe40000010000ULL,
0x00001f302c0d7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b2b2b3820ULL, 0x000fc80000410000ULL,
0x0000002b000a3308ULL, 0x000ee20000000800ULL, 0x000000084c4c7220ULL, 0x082fe40000410000ULL,
0x000000084d4d7220ULL, 0x080fe40000410000ULL, 0x0000000850507220ULL, 0x080fe40000410000ULL,
0x0000000851517220ULL, 0x080fe40000410000ULL, 0x0000000854547220ULL, 0x080fe40000410000ULL,
0x0000000855557220ULL, 0x000fc40000410000ULL, 0x000000085c5c7220ULL, 0x080fe40000410000ULL,
0x000000085d5d7220ULL, 0x080fe40000410000ULL, 0x0000000858587220ULL, 0x080fe40000410000ULL,
0x0000000859597220ULL, 0x080fe40000410000ULL, 0x0000000834347220ULL, 0x080fe40000410000ULL,
0x0000000835357220ULL, 0x000fc40000410000ULL, 0x0000000838387220ULL, 0x080fe40000410000ULL,
0x0000000839397220ULL, 0x080fe40000410000ULL, 0x000000083c3c7220ULL, 0x080fe40000410000ULL,
0x000000083d3d7220ULL, 0x000fe40000410000ULL, 0x0000000d4e4e7220ULL, 0x084fe40000410000ULL,
0x0000000d4f4f7220ULL, 0x000fc40000410000ULL, 0x0000000d52527220ULL, 0x080fe40000410000ULL,
0x0000000d53537220ULL, 0x080fe40000410000ULL, 0x0000000d56567220ULL, 0x080fe40000410000ULL,
0x0000000d57577220ULL, 0x080fe40000410000ULL, 0x0000000d5e5e7220ULL, 0x080fe40000410000ULL,
0x0000000d5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000d5a5a7220ULL, 0x080fe40000410000ULL,
0x0000000d5b5b7220ULL, 0x080fe40000410000ULL, 0x0000000d36367220ULL, 0x080fe40000410000ULL,
0x0000000d37377220ULL, 0x080fe40000410000ULL, 0x0000000d3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000d3b3b7220ULL, 0x000fc40000410000ULL, 0x0000000d3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000d3f3f7220ULL, 0x000fe40000410000ULL, 0x000000ffff087224ULL, 0x000fe400078e002dULL,
0x0000000e0a0e3220ULL, 0x008fc80000410000ULL, 0x000000090e097221ULL, 0x00cfe20000010000ULL,
0x0000015000001947ULL, 0x000fea0003800000ULL, 0x00000008280e7812ULL, 0x000fe400078ec0ffULL,
0x0000000113ff7812ULL, 0x000fc8000782c0ffULL, 0x01c64c000e0e7984ULL, 0x000e620000000800ULL,
0x0000000b0c0d7207ULL, 0x000fc80004800000ULL, 0x0000ffff0d0d7812ULL, 0x000fc800078ec0ffULL,
0x000088800d0f7816ULL, 0x000fca00000000ffULL, 0x800000000f0d7824ULL, 0x000fca00078e00ffULL,
0x800000000eff7812ULL, 0x002fe2000782480dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x00000001130d7812ULL, 0x000fe200078ec0ffULL,
0x800000000f2c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0e7424ULL, 0x000fe200078e00ffULL,
0x0001c6480d0f7811ULL, 0x000fc600078e18ffULL, 0x0000000e000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe40003800000ULL,
0x000004000f0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000782482cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000001025707824ULL, 0x100fe200078e0229ULL, 0x0000000000d87919ULL, 0x000e620000000000ULL,
0x00000010f02c7824ULL, 0x100fe400078e0229ULL, 0x000000101f307824ULL, 0x100fe400078e0229ULL,
0x000000007070783bULL, 0x000ea20000004200ULL, 0x0000001020407824ULL, 0x100fe400078e0229ULL,
0x0000001021447824ULL, 0x100fe200078e0229ULL, 0x000000002c2c783bULL, 0x000ee20000004200ULL,
0x0000001022487824ULL, 0x000fc400078e0229ULL, 0x0000001023607824ULL, 0x100fe200078e0229ULL,
0x000000003030783bULL, 0x000fe20000004200ULL, 0x0000001024687824ULL, 0x000fc600078e0229ULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x000000004444783bULL, 0x000f280000004200ULL,
0x000000004848783bULL, 0x000e680000004200ULL, 0x000000006060783bULL, 0x000e680000004200ULL,
0x000000006868783bULL, 0x000e620000004200ULL, 0x00000018ffac7819ULL, 0x004fc40000011470ULL,
0x00000018ffb57819ULL, 0x000fe40000011473ULL, 0x000000ac00f67306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x008fe4000001142cULL, 0x00000018ff0e7819ULL, 0x000fe4000001142dULL,
0x00000018ff0f7819ULL, 0x000fe4000001142eULL, 0x00000018ff1f7819ULL, 0x000fe2000001142fULL,
0x000000ac00f57306ULL, 0x000fe20000205400ULL, 0x00000018ffaf7819ULL, 0x000fc40000011472ULL,
0x00000018ffae7819ULL, 0x000fe40000011471ULL, 0x00000018ff207819ULL, 0x010fe40000011446ULL,
0x00000018ff217819ULL, 0x000fe20000011447ULL, 0x000000ac00677306ULL, 0x0005e2000020d400ULL,
0x00000018ff237819ULL, 0x002fe4000001144aULL, 0x00000018ff227819ULL, 0x000fe40000011448ULL,
0x00000018ff2b7819ULL, 0x000fc4000001144bULL, 0x00000018ff247819ULL, 0x000fe20000011460ULL,
0x0000000d00b67306ULL, 0x000fe20000209400ULL, 0x000001002cac7824ULL, 0x004fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe4000001146bULL, 0x00000018ff657819ULL, 0x000fe40000011462ULL,
0x00000018ffac7819ULL, 0x000fe400000114acULL, 0x0000000d00c97306ULL, 0x000e700000205400ULL,
0x0000000d00aa7306ULL, 0x0004f0000020d400ULL, 0x0000000e00ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x004fc40000011430ULL, 0x000000c9b600720bULL, 0x002fca0003fbd000ULL,
0x0000000e00be7306ULL, 0x000ff00000205400ULL, 0x0000000e00a97306ULL, 0x0003e2000020d400ULL,
0x00000001aaaa5812ULL, 0x008fce00078efcffULL, 0x000000ac00bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff0e7819ULL, 0x002fce0000011431ULL, 0x000000ac00c77306ULL, 0x000e700000205400ULL,
0x0000000d00997306ULL, 0x000ff00000209400ULL, 0x0000000d00787306ULL, 0x000fe20000205400ULL,
0x000000c7bf00720bULL, 0x002fce0003fdd000ULL, 0x0000000d00b37306ULL, 0x0003f0000020d400ULL,
0x0000000f00a27306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x002fce0000011440ULL,
0x0000000f009c7306ULL, 0x000ff00000205400ULL, 0x0000000f00c07306ULL, 0x0003f0000020d400ULL,
0x0000002c00b47306ULL, 0x000fe20000009400ULL, 0x00000018ff0f7819ULL, 0x002fce0000011432ULL,
0x0000002c00ad7306ULL, 0x000e700000005400ULL, 0x0000002c00947306ULL, 0x0004f0000000d400ULL,
0x0000000e00957306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x004fe200078e00ffULL,
0x000000adb400720bULL, 0x002fe20003f3d000ULL, 0x000100002fb47824ULL, 0x000fc600078e00ffULL,
0x00000018ffb07819ULL, 0x000fe2000001142cULL, 0x000001002d2c7824ULL, 0x000fe200078e00ffULL,
0x0000000e00987306ULL, 0x000fee0000205400ULL, 0x0000000194941812ULL, 0x008fe200078efcffULL,
0x0000000e00a87306ULL, 0x0003e2000020d400ULL, 0x000000beba00720bULL, 0x000fce0003f3d000ULL,
0x0000000d008e7306ULL, 0x000fe20000209400ULL, 0x00000018ff0e7819ULL, 0x002fca0000011441ULL,
0x00000001a9a91812ULL, 0x000fe400078efcffULL, 0x0000000d008f7306ULL, 0x000ff00000205400ULL,
0x0000000d00897306ULL, 0x0003f0000020d400ULL, 0x0000000f00c37306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x002fce0000011444ULL, 0x0000000f00c47306ULL, 0x000ff00000205400ULL,
0x0000000f00a77306ULL, 0x0003f0000020d400ULL, 0x0000000e008c7306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fce0000011442ULL, 0x0000000e008d7306ULL, 0x000ff00000205400ULL,
0x0000000e008a7306ULL, 0x0003f0000020d400ULL, 0x00000020007d7306ULL, 0x000fe20000209400ULL,
0x00000018ff0e7819ULL, 0x002fce0000011445ULL, 0x00000020007e7306ULL, 0x000ff00000205400ULL,
0x00000020006f7306ULL, 0x0003f0000020d400ULL, 0x0000000d00817306ULL, 0x000fe20000209400ULL,
0x00000018ff207819ULL, 0x002fce0000011449ULL, 0x0000000d00827306ULL, 0x000ff00000205400ULL,
0x0000000d00757306ULL, 0x000ff0000020d400ULL, 0x0000002300977306ULL, 0x000ff00000209400ULL,
0x0000002300967306ULL, 0x000ff00000205400ULL, 0x00000023000d7306ULL, 0x0003f0000020d400ULL,
0x000000ac00c17306ULL, 0x0004e2000020d400ULL, 0x00000018ff237819ULL, 0x002fce0000011461ULL,
0x0000000f00857306ULL, 0x000fe20000209400ULL, 0x000001002eac7824ULL, 0x004fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe400000114acULL, 0x0000000f008b7306ULL, 0x000fe20000205400ULL,
0x00000001c1c16812ULL, 0x008fce00078efcffULL, 0x0000000f007b7306ULL, 0x000ff0000020d400ULL,
0x000000b000d67306ULL, 0x000ff00000209400ULL, 0x000000b000cd7306ULL, 0x000e700000205400ULL,
0x00000022007a7306ULL, 0x000ff00000209400ULL, 0x0000002200a17306ULL, 0x000fe20000205400ULL,
0x000000cdd600720bULL, 0x002fce0003fdd000ULL, 0x00000022000f7306ULL, 0x000ff0000020d400ULL,
0x0000000e007f7306ULL, 0x000ff00000209400ULL, 0x0000000e00807306ULL, 0x000ff00000205400ULL,
0x0000000e00747306ULL, 0x000ff0000020d400ULL, 0x0000002b00867306ULL, 0x000ff00000209400ULL,
0x0000002b00a37306ULL, 0x000ff00000205400ULL, 0x0000002b00227306ULL, 0x0003f0000020d400ULL,
0x00000020009a7306ULL, 0x000fe20000209400ULL, 0x00000018ff2b7819ULL, 0x002fce0000011469ULL,
0x00000020009b7306ULL, 0x000ff00000205400ULL, 0x00000020000e7306ULL, 0x000ff0000020d400ULL,
0x00000023009f7306ULL, 0x000ff00000209400ULL, 0x0000002300a07306ULL, 0x000ff00000205400ULL,
0x0000002300207306ULL, 0x0003f0000020d400ULL, 0x0000002b00ea7306ULL, 0x000fe20000209400ULL,
0x00000018ff237819ULL, 0x002fce0000011468ULL, 0x0000002b00e87306ULL, 0x000ff00000205400ULL,
0x0000002b00257306ULL, 0x000ff0000020d400ULL, 0x000000b500f07306ULL, 0x000ff00000209400ULL,
0x000000b500ef7306ULL, 0x000ff00000205400ULL, 0x000000b5002b7306ULL, 0x0003f0000020d400ULL,
0x0000001f009d7306ULL, 0x000fe20000209400ULL, 0x00000018ffb57819ULL, 0x002fce000001142cULL,
0x0000001f00a47306ULL, 0x000ff00000205400ULL, 0x0000001f00c57306ULL, 0x0003f0000020d400ULL,
0x0000002300e37306ULL, 0x000fe20000209400ULL, 0x00000018ff1f7819ULL, 0x002fce0000011433ULL,
0x0000002300e17306ULL, 0x000ff00000205400ULL, 0x0000002300297306ULL, 0x000ff0000020d400ULL,
0x0000006600ee7306ULL, 0x000ff00000209400ULL, 0x0000006600ed7306ULL, 0x000ff00000205400ULL,
0x0000006600237306ULL, 0x000ff0000020d400ULL, 0x000000af00f27306ULL, 0x000ff00000209400ULL,
0x000000af00f17306ULL, 0x000ff00000205400ULL, 0x000000af00667306ULL, 0x000ff0000020d400ULL,
0x000000b000af7306ULL, 0x0002b0000020d400ULL, 0x000000b5002c7306ULL, 0x000fe20000209400ULL,
0x000001002fb07824ULL, 0x002fca00078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe400000114b0ULL,
0x000000b500d47306ULL, 0x000e620000205400ULL, 0x00000001afaf6812ULL, 0x004fce00078efcffULL,
0x0000001f00b77306ULL, 0x000ff00000209400ULL, 0x0000001f00b97306ULL, 0x000fe20000205400ULL,
0x000000d42c00720bULL, 0x002fe20003fdd000ULL, 0x00010000312c7824ULL, 0x000fcc00078e00ffULL,
0x0000001f009e7306ULL, 0x0003f0000020d400ULL, 0x0000002e00bd7306ULL, 0x000fe20000009400ULL,
0x00000018ff1f7819ULL, 0x002fce0000011443ULL, 0x0000002e00c87306ULL, 0x000e700000005400ULL,
0x0000002d00a57306ULL, 0x000ff00000009400ULL, 0x0000002d00a67306ULL, 0x000ea20000005400ULL,
0x000000c8bd00720bULL, 0x002fce0003f7d000ULL, 0x0000002d00ab7306ULL, 0x0002f0000000d400ULL,
0x0000001f00837306ULL, 0x000fe20000209400ULL, 0x000100002d2d7824ULL, 0x002fe200078e00ffULL,
0x000000a6a500720bULL, 0x004fe20003f5d000ULL, 0x0000010031a57824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000001f00847306ULL, 0x000fe20000205400ULL,
0x00000018ffd77819ULL, 0x000fcc00000114a5ULL, 0x00000001abab2812ULL, 0x008fe200078efcffULL,
0x0000001f00777306ULL, 0x000ff0000020d400ULL, 0x0000002100797306ULL, 0x000ff00000209400ULL,
0x00000021007c7306ULL, 0x000ff00000205400ULL, 0x00000021001f7306ULL, 0x000ff0000020d400ULL,
0x0000002400907306ULL, 0x000ff00000209400ULL, 0x0000002400917306ULL, 0x000ff00000205400ULL,
0x0000002400217306ULL, 0x0003f0000020d400ULL, 0x0000006500877306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x002fce0000011463ULL, 0x0000006500887306ULL, 0x000ff00000205400ULL,
0x00000065006d7306ULL, 0x0003f0000020d400ULL, 0x000000b500d57306ULL, 0x000ea2000020d400ULL,
0x00000018ff657819ULL, 0x002fce000001146aULL, 0x000000ac00cc7306ULL, 0x000ff00000209400ULL,
0x000000ac00ce7306ULL, 0x000e620000205400ULL, 0x00000001d5d56812ULL, 0x004fce00078efcffULL,
0x0000002400937306ULL, 0x000ff00000209400ULL, 0x0000002400927306ULL, 0x000fe20000205400ULL,
0x000000cecc00720bULL, 0x002fce0003fdd000ULL, 0x00000024006c7306ULL, 0x000ff0000020d400ULL,
0x0000006500ec7306ULL, 0x000ff00000209400ULL, 0x0000006500eb7306ULL, 0x000ff00000205400ULL,
0x0000006500247306ULL, 0x000ff0000020d400ULL, 0x000000ae00f47306ULL, 0x000ff00000209400ULL,
0x000000ae00f37306ULL, 0x000ff00000205400ULL, 0x000000ae00657306ULL, 0x000ff0000020d400ULL,
0x0000002d00cf7306ULL, 0x000ff00000209400ULL, 0x0000002d00d37306ULL, 0x000e700000205400ULL,
0x0000002d00ae7306ULL, 0x000eb0000020d400ULL, 0x0000002e00c67306ULL, 0x000ee2000000d400ULL,
0x000000d3cf00720bULL, 0x002fce0003fbd000ULL, 0x0000002f002d7306ULL, 0x000fec0000009400ULL,
0x00000001aeae5812ULL, 0x004fe400078efcffULL, 0x0000002f00b07306ULL, 0x000e620000005400ULL,
0x00000001c6c63812ULL, 0x008fe400078efcffULL, 0x0000009ca200720bULL, 0x000fe20003f7d000ULL,
0x00010000329c7824ULL, 0x000fc800078e00ffULL, 0x000000ac00c27306ULL, 0x0004e2000020d400ULL,
0x00000018ff9c7819ULL, 0x000fce000001149cULL, 0x0000003100b67306ULL, 0x000fe20000009400ULL,
0x000100002eac7824ULL, 0x004fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe400000114b4ULL,
0x000000b02d00720bULL, 0x002fe20003f9d000ULL, 0x00010000302d7824ULL, 0x000fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe400000114acULL, 0x0000003100be7306ULL, 0x000e620000005400ULL,
0x00000001c2c26812ULL, 0x008fe400078efcffULL, 0x00000018ffd67819ULL, 0x000fc4000001142dULL,
0x00000001c0c03812ULL, 0x000fc600078efcffULL, 0x000000bb00b57306ULL, 0x000ff00000209400ULL,
0x000000bb00cb7306ULL, 0x000ea20000205400ULL, 0x000000beb600720bULL, 0x002fce0003fdd000ULL,
0x000000bb00b87306ULL, 0x000ff0000020d400ULL, 0x0000002f00d27306ULL, 0x0002e2000000d400ULL,
0x000000cbb500720bULL, 0x004fe20003f5d000ULL, 0x0000010033cb7824ULL, 0x000fca00078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe200000114cbULL, 0x000000ca00ac7306ULL, 0x000fe20000209400ULL,
0x00000100302f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x000000ca00ad7306ULL, 0x000e620000205400ULL, 0x00000001d2d24812ULL, 0x008fe400078efcffULL,
0x00000001b8b82812ULL, 0x000fe400078efcffULL, 0x000000a49d00720bULL, 0x000fc60003f5d000ULL,
0x0000002e00b47306ULL, 0x000ff00000209400ULL, 0x0000002e00bb7306ULL, 0x000ea20000205400ULL,
0x000000adac00720bULL, 0x002fe40003f3d000ULL, 0x00000001c5c52812ULL, 0x000fca00078efcffULL,
0x000000d700a57306ULL, 0x000ff00000209400ULL, 0x000000d700a67306ULL, 0x000e620000205400ULL,
0x000000bbb400720bULL, 0x004fce0003f9d000ULL, 0x0000003100cd7306ULL, 0x0004f0000000d400ULL,
0x000000ca00d17306ULL, 0x000f22000020d400ULL, 0x0000010032317824ULL, 0x004fe200078e00ffULL,
0x000000a6a500720bULL, 0x002fc80003f7d000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000b07306ULL, 0x000fe20000009400ULL, 0x00000001cdcd6812ULL, 0x008fce00078efcffULL,
0x0000003000bf7306ULL, 0x000e620000005400ULL, 0x00000001d1d11812ULL, 0x010fce00078efcffULL,
0x0000003000ca7306ULL, 0x0005f0000000d400ULL, 0x0000002e00d07306ULL, 0x000ee2000020d400ULL,
0x00000018ff307819ULL, 0x004fe4000001142cULL, 0x000000bfb000720bULL, 0x002fca0003fbd000ULL,
0x00000030002c7306ULL, 0x000ff00000209400ULL, 0x00000030002d7306ULL, 0x000e620000205400ULL,
0x00000001d0d04812ULL, 0x008fe400078efcffULL, 0x00000001caca5812ULL, 0x000fc400078efcffULL,
0x000000989500720bULL, 0x000fc60003fbd000ULL, 0x0000002f00bc7306ULL, 0x000ff00000209400ULL,
0x0000002f00bd7306ULL, 0x000ea20000205400ULL, 0x0000002d2c00720bULL, 0x002fe20003fdd000ULL,
0x00010000402c7824ULL, 0x000fe200078e00ffULL, 0x00000001a8a85812ULL, 0x000fca00078efcffULL,
0x0000003000ba7306ULL, 0x000e70000020d400ULL, 0x0000003100d37306ULL, 0x000fe20000209400ULL,
0x000000bdbc00720bULL, 0x004fce0003f3d000ULL, 0x0000003100d47306ULL, 0x000fe20000205400ULL,
0x00000001baba6812ULL, 0x002fe400078efcffULL, 0x000000c4c300720bULL, 0x000fca0003fdd000ULL,
0x0000003100b57306ULL, 0x000ff0000020d400ULL, 0x0000002f00c87306ULL, 0x000e62000020d400ULL,
0x00000001a7a76812ULL, 0x000fce00078efcffULL, 0x000000d700c77306ULL, 0x000eb0000020d400ULL,
0x0000003200307306ULL, 0x000fe20000009400ULL, 0x00000001c8c81812ULL, 0x002fe400078efcffULL,
0x000000789900720bULL, 0x000fc40003f3d000ULL, 0x00000002ff787819ULL, 0x100fe400000116d8ULL,
0x00000002ffd87819ULL, 0x000fe200000116d8ULL, 0x0000003200317306ULL, 0x000e620000005400ULL,
0x00000001c7c73812ULL, 0x004fe400078efcffULL, 0x00000008d8d87810ULL, 0x000fca0007ffe0ffULL,
0x000000d6002e7306ULL, 0x000fe20000209400ULL, 0x00000001b3b31812ULL, 0x000fe400078efcffULL,
0x000000d4d300720bULL, 0x000fca0003f3d000ULL, 0x000000d6002f7306ULL, 0x000ea20000205400ULL,
0x000000313000720bULL, 0x002fe40003f9d000ULL, 0x00000018ff317819ULL, 0x000fe4000001142cULL,
0x00013000642c7811ULL, 0x000fc600078e20ffULL, 0x0000003200b67306ULL, 0x0002e2000000d400ULL,
0x00000001b5b51812ULL, 0x000fe400078efcffULL, 0x000000b9b700720bULL, 0x000fe40003f3d000ULL,
0x0000002f2e00720bULL, 0x004fe20003f7d000ULL, 0x00000100402e7824ULL, 0x000fe400078e00ffULL,
0x000000cb00ce7306ULL, 0x000fe20000209400ULL, 0x0001000033327824ULL, 0x002fe400078e00ffULL,
0x00000018ff307819ULL, 0x000fc4000001142eULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x000000cb00cf7306ULL, 0x000e620000205400ULL,
0x00000001b6b64812ULL, 0x008fe400078efcffULL, 0x000000019e9e1812ULL, 0x000fca00078efcffULL,
0x000000cb00b07306ULL, 0x000eb0000020d400ULL, 0x0000003200cb7306ULL, 0x000fe20000209400ULL,
0x000000cfce00720bULL, 0x002fce0003fbd000ULL, 0x0000003200cc7306ULL, 0x000e6c0000205400ULL,
0x00000001b0b05812ULL, 0x004fe400078efcffULL, 0x0000003200ac7306ULL, 0x0005f0000020d400ULL,
0x000000d600c97306ULL, 0x000722000020d400ULL, 0x0000000aff32723eULL, 0x004fc400000010ffULL,
0x000000cccb00720bULL, 0x002fe40003fbd000ULL, 0x0000541032327816ULL, 0x000fc60000000032ULL,
0x00000033009d7306ULL, 0x000fe20000009400ULL, 0x0000010041d67824ULL, 0x008fe200078e00ffULL,
0x00001f7832787589ULL, 0x000e6800000e0000ULL, 0x00000018ffd67819ULL, 0x000fe400000114d6ULL,
0x0000003300a27306ULL, 0x000ea20000005400ULL, 0x00000001c9c93812ULL, 0x010fe400078efcffULL,
0x00000001acac5812ULL, 0x000fca00078efcffULL, 0x0000003000997306ULL, 0x000ff00000209400ULL,
0x0000003000987306ULL, 0x000ee20000205400ULL, 0x000000a29d00720bULL, 0x004fce0003f5d000ULL,
0x0000003000bf7306ULL, 0x000530000020d400ULL, 0x0000009c00bb7306ULL, 0x000fe20000209400ULL,
0x0000991076307816ULL, 0x004fe400000000ffULL, 0x00001fd832767589ULL, 0x000ea200000e0000ULL,
0x000000989900720bULL, 0x008fc40003f3d000ULL, 0x000000ff3000720cULL, 0x000fe40003f65270ULL,
0x0000009c00bc7306ULL, 0x000ee20000205400ULL, 0x00000094c130723eULL, 0x000fe200000010ffULL,
0x0001000041947824ULL, 0x000fca00078e00ffULL, 0x00000018ff947819ULL, 0x000fe20000011494ULL,
0x0000009c00ad7306ULL, 0x000ea2000020d400ULL, 0x00000001bfbf1812ULL, 0x010fe400078efcffULL,
0x000000782c2cb231ULL, 0x082fe400003400ffULL, 0x000000782e2eb231ULL, 0x000fc600003400ffULL,
0x00000031009d7306ULL, 0x000fe20000209400ULL, 0x000000bcbb00720bULL, 0x008fe20003f9d000ULL,
0x000000762d2db231ULL, 0x084fe400003400ffULL, 0x000000762f2fb231ULL, 0x000fc800003400ffULL,
0x00000031009c7306ULL, 0x000e6c0000205400ULL, 0x00000001adad4812ULL, 0x000fe400078efcffULL,
0x0000004000a67306ULL, 0x000ff00000009400ULL, 0x0000004000a57306ULL, 0x000ea20000005400ULL,
0x0000009c9d00720bULL, 0x002fce0003f9d000ULL, 0x0000004000be7306ULL, 0x000e70000000d400ULL,
0x0000003100407306ULL, 0x000722000020d400ULL, 0x000000a5a600720bULL, 0x004fce0003fbd000ULL,
0x0000003300b47306ULL, 0x000ea2000000d400ULL, 0x000000abd531723eULL, 0x008fca00000010ffULL,
0x00000001bebe5812ULL, 0x002fe400078efcffULL, 0x000000d600957306ULL, 0x000fe20000209400ULL,
0x000000302c4c723cULL, 0x000fe2000004184cULL, 0x0000000140404812ULL, 0x010fe400078efcffULL,
0x0000008f8e00720bULL, 0x000fc80003fbd000ULL, 0x000000d600337306ULL, 0x000e620000205400ULL,
0x000000afaa30723eULL, 0x000fe400000010ffULL, 0x000000aea931723eULL, 0x000fe400000010ffULL,
0x00000001b4b42812ULL, 0x004fc600078efcffULL, 0x000000d600c17306ULL, 0x000ea2000020d400ULL,
0x0000000189895812ULL, 0x000fe200078efcffULL, 0x000000302c50723cULL, 0x000fe20000041850ULL,
0x0000008d8c00720bULL, 0x000fca0003fbd000ULL, 0x0000009400327306ULL, 0x000fe20000209400ULL,
0x000000c6c230723eULL, 0x000fe400000010ffULL, 0x000000d2b831723eULL, 0x000fe200000010ffULL,
0x0000010043d27824ULL, 0x000fe200078e00ffULL, 0x000000339500720bULL, 0x002fe20003f9d000ULL,
0x0000010049337824ULL, 0x000fe400078e00ffULL, 0x0000009400ab7306ULL, 0x000e620000205400ULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x000000302c54723cULL, 0x000fe20000041854ULL,
0x000000018a8a5812ULL, 0x000fc400078efcffULL, 0x00000018ff8e7819ULL, 0x000fe20000011433ULL,
0x0001000049337824ULL, 0x000fe400078e00ffULL, 0x0000009400947306ULL, 0x000ee2000020d400ULL,
0x000000d1c030723eULL, 0x000fe200000010ffULL, 0x0001000042d17824ULL, 0x000fe200078e00ffULL,
0x000000d0c531723eULL, 0x000fe400000010ffULL, 0x00000001c1c14812ULL, 0x004fe400078efcffULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x000000d200c27306ULL, 0x000fe20000209400ULL,
0x000000ab3200720bULL, 0x002fe20003f9d000ULL, 0x000000302c5c723cULL, 0x000fe2000004185cULL,
0x00000018ff8c7819ULL, 0x000fca0000011433ULL, 0x000000d200c67306ULL, 0x000e620000205400ULL,
0x000000cac830723eULL, 0x000fe400000010ffULL, 0x000000cdc731723eULL, 0x000fc600000010ffULL,
0x0000000194944812ULL, 0x008fe400078efcffULL, 0x000000d200c07306ULL, 0x000ea4000020d400ULL,
0x000000302c58723cULL, 0x000fec0000041858ULL, 0x000000d100c57306ULL, 0x000fe20000209400ULL,
0x000000c9b330723eULL, 0x000fc400000010ffULL, 0x000000baa831723eULL, 0x000fe400000010ffULL,
0x000000c6c200720bULL, 0x002fc60003f9d000ULL, 0x000000d100c37306ULL, 0x000e640000205400ULL,
0x000000302c34723cULL, 0x000fec0000041834ULL, 0x0000004300c87306ULL, 0x000fe20000009400ULL,
0x000000b6b530723eULL, 0x000fe400000010ffULL, 0x000000b4b031723eULL, 0x000fc400000010ffULL,
0x00000001c0c04812ULL, 0x004fc600078efcffULL, 0x0000004300c77306ULL, 0x000ea20000005400ULL,
0x000000c3c500720bULL, 0x002fe20003f9d000ULL, 0x000000302c38723cULL, 0x000fec0000041838ULL,
0x0000004300c47306ULL, 0x0002e2000000d400ULL, 0x000000ada730723eULL, 0x000fe200000010ffULL,
0x0000010044a77824ULL, 0x000fe200078e00ffULL, 0x000000ac9e31723eULL, 0x000fc800000010ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x0000004100a27306ULL, 0x000fe20000009400ULL,
0x0001000043437824ULL, 0x002fe200078e00ffULL, 0x000000302c2c723cULL, 0x000fe2000004183cULL,
0x000000c7c800720bULL, 0x004fc60003f3d000ULL, 0x00000018ffb07819ULL, 0x000fe40000011443ULL,
0x0000004100a47306ULL, 0x000e620000005400ULL, 0x0000010045307824ULL, 0x000fe400078e00ffULL,
0x00000100463c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011430ULL,
0x0000004100bd7306ULL, 0x000522000000d400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000001c4c41812ULL, 0x008fe400078efcffULL, 0x000000848300720bULL, 0x000fe20003f3d000ULL,
0x0000010061837824ULL, 0x000fe400078e00ffULL, 0x0000004200a97306ULL, 0x000fe20000009400ULL,
0x0000010042417824ULL, 0x004fe200078e00ffULL, 0x000000a4a200720bULL, 0x002fc40003fdd000ULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004200aa7306ULL, 0x000e640000005400ULL, 0x0000000177771812ULL, 0x000fca00078efcffULL,
0x00000001bdbd6812ULL, 0x010fe200078efcffULL, 0x0000004200b87306ULL, 0x000eb0000000d400ULL,
0x000000d100427306ULL, 0x000ee2000020d400ULL, 0x000000aaa900720bULL, 0x002fce0003f5d000ULL,
0x000000b000437306ULL, 0x000fec0000209400ULL, 0x00000001b8b82812ULL, 0x004fe400078efcffULL,
0x000000b000cd7306ULL, 0x000e620000205400ULL, 0x0000000142424812ULL, 0x008fe400078efcffULL,
0x0000008b8500720bULL, 0x000fe20003f5d000ULL, 0x000100004a857824ULL, 0x000fc800078e00ffULL,
0x000000b000b97306ULL, 0x000ea2000020d400ULL, 0x00000018ff857819ULL, 0x000fce0000011485ULL,
0x0000003100d87306ULL, 0x000fe20000209400ULL, 0x000000cd4300720bULL, 0x002fe20003f9d000ULL,
0x0000010060437824ULL, 0x000fe200078e00ffULL, 0x000000017b7b2812ULL, 0x000fc800078efcffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000003100d77306ULL, 0x000e6c0000205400ULL,
0x00000001b9b94812ULL, 0x004fe400078efcffULL, 0x0000004400ca7306ULL, 0x000ff00000009400ULL,
0x0000004400c97306ULL, 0x000ea20000005400ULL, 0x000000d7d800720bULL, 0x002fce0003f9d000ULL,
0x0000004400a87306ULL, 0x0003f0000000d400ULL, 0x0000003100bc7306ULL, 0x000722000020d400ULL,
0x0001000044447824ULL, 0x002fe200078e00ffULL, 0x000000c9ca00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff307819ULL, 0x000fe40000011444ULL, 0x0000004500cb7306ULL, 0x000fe20000009400ULL,
0x0000010047317824ULL, 0x008fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000d37306ULL, 0x000fe20000209400ULL, 0x00000001bcbc4812ULL, 0x010fe400078efcffULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x000000828100720bULL, 0x000fc60003fbd000ULL,
0x0000003000d47306ULL, 0x000e700000205400ULL, 0x0000004500cc7306ULL, 0x000fe40000005400ULL,
0x0000000175755812ULL, 0x000fcc00078efcffULL, 0x0000004500ad7306ULL, 0x0005e2000000d400ULL,
0x000000d4d300720bULL, 0x002fce0003f9d000ULL, 0x0000003000bb7306ULL, 0x0002e2000020d400ULL,
0x0001000045457824ULL, 0x004fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000004100af7306ULL, 0x000fe20000209400ULL, 0x0001000046307824ULL, 0x002fce00078e00ffULL,
0x0000004500d17306ULL, 0x000fe20000209400ULL, 0x00000001bbbb4812ULL, 0x008fce00078efcffULL,
0x0000004500d27306ULL, 0x000e700000205400ULL, 0x0000004100ae7306ULL, 0x000eb00000205400ULL,
0x0000004500b77306ULL, 0x000722000020d400ULL, 0x000000d2d100720bULL, 0x002fce0003f9d000ULL,
0x00000031003e7306ULL, 0x000fe20000209400ULL, 0x00000018ff457819ULL, 0x008fe20000011430ULL,
0x0001000047307824ULL, 0x000fe200078e00ffULL, 0x000000aeaf00720bULL, 0x004fca0003fdd000ULL,
0x00000031003f7306ULL, 0x000e620000205400ULL, 0x00000001b7b74812ULL, 0x010fce00078efcffULL,
0x0000004100417306ULL, 0x000eb0000020d400ULL, 0x0000003c00d07306ULL, 0x000fe20000209400ULL,
0x0000003f3e00720bULL, 0x002fe20003f9d000ULL, 0x00000100633e7824ULL, 0x000fcc00078e00ffULL,
0x0000003c00447306ULL, 0x000e620000205400ULL, 0x0000000141416812ULL, 0x004fe400078efcffULL,
0x000000cccb00720bULL, 0x000fca0003fdd000ULL, 0x0000003c00b37306ULL, 0x000ff0000020d400ULL,
0x0000003100b07306ULL, 0x000ea2000020d400ULL, 0x00000001adad6812ULL, 0x000fe400078efcffULL,
0x000000807f00720bULL, 0x000fc40003fdd000ULL, 0x00000044d000720bULL, 0x002fe20003fbd000ULL,
0x0000010062447824ULL, 0x000fe400078e00ffULL, 0x00000045003c7306ULL, 0x000ff00000209400ULL,
0x00000045003d7306ULL, 0x000e620000205400ULL, 0x00000001b0b04812ULL, 0x004fc400078efcffULL,
0x0000000174746812ULL, 0x000fe400078efcffULL, 0x00000001b3b35812ULL, 0x000fc600078efcffULL,
0x0000004600d97306ULL, 0x000ff00000009400ULL, 0x0000004600da7306ULL, 0x000ea20000005400ULL,
0x0000003d3c00720bULL, 0x002fe20003f9d000ULL, 0x00010000623d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000004600b47306ULL, 0x0003f0000000d400ULL,
0x0000004500b67306ULL, 0x000ee2000020d400ULL, 0x00000018ff467819ULL, 0x002fc40000011430ULL,
0x000000dad900720bULL, 0x004fca0003f3d000ULL, 0x0000004600307306ULL, 0x000ff00000209400ULL,
0x0000004600317306ULL, 0x000e620000205400ULL, 0x00000001b6b64812ULL, 0x008fe400078efcffULL,
0x00000001b4b41812ULL, 0x000fc400078efcffULL, 0x0000007e7d00720bULL, 0x000fc60003f3d000ULL,
0x000000a700cf7306ULL, 0x000ff00000209400ULL, 0x000000a700ce7306ULL, 0x000ea20000205400ULL,
0x000000313000720bULL, 0x002fe20003f9d000ULL, 0x0000010068307824ULL, 0x000fe200078e00ffULL,
0x000000016f6f1812ULL, 0x000fe200078efcffULL, 0x0000010069317824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000004600ac7306ULL, 0x0002e2000020d400ULL,
0x00000018ff317819ULL, 0x000fce0000011431ULL, 0x0000004800dd7306ULL, 0x000fe20000009400ULL,
0x0001000048467824ULL, 0x002fe200078e00ffULL, 0x000000cecf00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff987819ULL, 0x000fe40000011446ULL, 0x0000004800de7306ULL, 0x000e620000005400ULL,
0x00000001acac4812ULL, 0x008fce00078efcffULL, 0x0000004700d57306ULL, 0x000ff00000009400ULL,
0x0000004700d67306ULL, 0x000fe20000005400ULL, 0x000000dedd00720bULL, 0x002fce0003fdd000ULL,
0x0000004700b57306ULL, 0x0003f0000000d400ULL, 0x0000004800a97306ULL, 0x000ea2000000d400ULL,
0x0000010048477824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000009800467306ULL, 0x000ff00000209400ULL, 0x0000009800487306ULL, 0x000e620000205400ULL,
0x00000001a9a96812ULL, 0x004fc400078efcffULL, 0x000000a17a00720bULL, 0x000fca0003fdd000ULL,
0x000000a700ba7306ULL, 0x000eb0000020d400ULL, 0x0000004700457306ULL, 0x000fe20000209400ULL,
0x000000484600720bULL, 0x002fe40003f9d000ULL, 0x000000010f0f6812ULL, 0x000fc400078efcffULL,
0x0000009b9a00720bULL, 0x000fc60003fdd000ULL, 0x0000004700a27306ULL, 0x000e620000205400ULL,
0x00000001baba2812ULL, 0x004fe400078efcffULL, 0x000000d6d500720bULL, 0x000fca0003f5d000ULL,
0x0000004700aa7306ULL, 0x000fe4000020d400ULL, 0x000000010e0e6812ULL, 0x000fcc00078efcffULL,
0x0000009800a57306ULL, 0x000ea2000020d400ULL, 0x00000001b5b52812ULL, 0x000fe400078efcffULL,
0x0000007c7900720bULL, 0x000fe40003f5d000ULL, 0x000000a24500720bULL, 0x002fc60003f3d000ULL,
0x0000008e00477306ULL, 0x000ff00000209400ULL, 0x0000008e00a47306ULL, 0x000e620000205400ULL,
0x00000001a5a54812ULL, 0x004fe400078efcffULL, 0x000000011f1f2812ULL, 0x000fc400078efcffULL,
0x00000001aaaa1812ULL, 0x000fc600078efcffULL, 0x0000004900c77306ULL, 0x000ff00000009400ULL,
0x0000004900c87306ULL, 0x000ea20000005400ULL, 0x000000a44700720bULL, 0x002fce0003f9d000ULL,
0x0000004900a67306ULL, 0x0002f0000000d400ULL, 0x0000008e00a77306ULL, 0x0008e2000020d400ULL,
0x000001004a497824ULL, 0x002fe200078e00ffULL, 0x000000c8c700720bULL, 0x004fc80003fbd000ULL,
0x00000018ff8d7819ULL, 0x000fe20000011449ULL, 0x000001004b497824ULL, 0x000fe200078e00ffULL,
0x0000008c00337306ULL, 0x000fe80000209400ULL, 0x00000018ff8e7819ULL, 0x010fc60000011449ULL,
0x00000001a6a65812ULL, 0x008fe200078efcffULL, 0x0000008c00327306ULL, 0x000e620000205400ULL,
0x00000001a7a74812ULL, 0x000fce00078efcffULL, 0x0000004a00ab7306ULL, 0x000ff00000009400ULL,
0x0000004a00af7306ULL, 0x000ea20000005400ULL, 0x000000323300720bULL, 0x002fe20003f9d000ULL,
0x000001006a327824ULL, 0x000fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000004b00df7306ULL, 0x000ff00000009400ULL, 0x0000004b00e07306ULL, 0x000e620000005400ULL,
0x000000afab00720bULL, 0x004fce0003f5d000ULL, 0x0000008500c57306ULL, 0x000ff00000209400ULL,
0x0000008500ca7306ULL, 0x000ea20000205400ULL, 0x000000e0df00720bULL, 0x002fce0003f3d000ULL,
0x0000008d00db7306ULL, 0x000ff00000209400ULL, 0x0000008d00dc7306ULL, 0x000e620000205400ULL,
0x000000cac500720bULL, 0x004fce0003fdd000ULL, 0x0000003000c27306ULL, 0x000ff00000209400ULL,
0x0000003000c37306ULL, 0x000fe20000205400ULL, 0x000000dcdb00720bULL, 0x002fce0003fbd000ULL,
0x00000030007d7306ULL, 0x0003f0000020d400ULL, 0x0000004a009d7306ULL, 0x0004e2000000d400ULL,
0x0001000068307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000008c009e7306ULL, 0x000e62000020d400ULL, 0x000100004b4a7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000008e00497306ULL, 0x000fe20000209400ULL,
0x000000019d9d2812ULL, 0x008fce00078efcffULL, 0x0000008e00c67306ULL, 0x000ea20000205400ULL,
0x000000019e9e4812ULL, 0x002fce00078efcffULL, 0x0000003100ae7306ULL, 0x000ff00000209400ULL,
0x0000003100af7306ULL, 0x000fe20000205400ULL, 0x000000c64900720bULL, 0x004fce0003f9d000ULL,
0x0000003100797306ULL, 0x0003f0000020d400ULL, 0x0000006900e07306ULL, 0x000fe20000009400ULL,
0x0001000069317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000006900e97306ULL, 0x000ff00000005400ULL, 0x00000069007a7306ULL, 0x000ff0000000d400ULL,
0x0000004b00987306ULL, 0x000e70000000d400ULL, 0x0000008500997306ULL, 0x000eb0000020d400ULL,
0x0000003000dd7306ULL, 0x000fe20000209400ULL, 0x0000000198981812ULL, 0x002fc400078efcffULL,
0x000000a38600720bULL, 0x000fca0003f3d000ULL, 0x0000003000ab7306ULL, 0x000fe20000205400ULL,
0x0000000199996812ULL, 0x004fce00078efcffULL, 0x0000003000697306ULL, 0x0003e2000020d400ULL,
0x0000000122221812ULL, 0x000fce00078efcffULL, 0x0000008e00957306ULL, 0x000ea2000020d400ULL,
0x000001006b307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000004a004b7306ULL, 0x000ff00000209400ULL, 0x0000004a00c97306ULL, 0x000e620000205400ULL,
0x0000000195954812ULL, 0x004fce00078efcffULL, 0x0000008d009c7306ULL, 0x000eb0000020d400ULL,
0x0000004300cd7306ULL, 0x000fe20000209400ULL, 0x000000c94b00720bULL, 0x002fce0003fdd000ULL,
0x0000004300cc7306ULL, 0x000fe20000205400ULL, 0x000000019c9c5812ULL, 0x004fe400078efcffULL,
0x000000969700720bULL, 0x000fe40003fbd000ULL, 0x0000009d9c9c723eULL, 0x000fe400000010ffULL,
0x00000098959d723eULL, 0x000fe200000010ffULL, 0x00000043008e7306ULL, 0x0003f0000020d400ULL,
0x0000006000d77306ULL, 0x000fe20000009400ULL, 0x0001000060437824ULL, 0x002fe200078e00ffULL,
0x000000010d0d5812ULL, 0x000fc400078efcffULL, 0x000000919000720bULL, 0x000fe40003fbd000ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000006000d87306ULL, 0x000e700000005400ULL,
0x00000060008f7306ULL, 0x0004e2000000d400ULL, 0x0000000121215812ULL, 0x000fce00078efcffULL,
0x0000008300cb7306ULL, 0x000fe20000209400ULL, 0x00000018ff607819ULL, 0x004fe40000011444ULL,
0x000000d8d700720bULL, 0x002fca0003f5d000ULL, 0x0000008300ce7306ULL, 0x000e700000205400ULL,
0x0000008300857306ULL, 0x000ea2000020d400ULL, 0x000000018f8f2812ULL, 0x008fce00078efcffULL,
0x0000006000447306ULL, 0x000fe20000209400ULL, 0x000000cecb00720bULL, 0x002fce0003f3d000ULL,
0x0000006000d07306ULL, 0x000fec0000205400ULL, 0x0000000185851812ULL, 0x004fe400078efcffULL,
0x0000006000837306ULL, 0x0003e2000020d400ULL, 0x000000a09f00720bULL, 0x000fce0003f3d000ULL,
0x00000030009a7306ULL, 0x000fe20000209400ULL, 0x0001000063607824ULL, 0x002fca00078e00ffULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x00000030009b7306ULL, 0x000fe20000205400ULL,
0x0000000120201812ULL, 0x000fe400078efcffULL, 0x000000e9e000720bULL, 0x000fca0003f3d000ULL,
0x0000003000497306ULL, 0x0003f0000020d400ULL, 0x0000004a008d7306ULL, 0x0004e2000020d400ULL,
0x000100006a307824ULL, 0x002fe200078e00ffULL, 0x000000017a7a1812ULL, 0x000fc400078efcffULL,
0x000000e8ea00720bULL, 0x000fe40003f3d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000006100d97306ULL, 0x000fe20000009400ULL, 0x00010000614a7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000006100da7306ULL, 0x000e620000005400ULL,
0x000000018d8d6812ULL, 0x008fe400078efcffULL, 0x000000cccd00720bULL, 0x000fe40003fdd000ULL,
0x0000000125251812ULL, 0x000fe400078efcffULL, 0x0000009b9a00720bULL, 0x000fe20003f3d000ULL,
0x00000061008b7306ULL, 0x000eb0000000d400ULL, 0x0000003100df7306ULL, 0x000fe20000209400ULL,
0x000000018e8e6812ULL, 0x000fc400078efcffULL, 0x000000dad900720bULL, 0x002fe40003f9d000ULL,
0x0000000149491812ULL, 0x000fe400078efcffULL, 0x000000edee00720bULL, 0x000fe20003f3d000ULL,
0x0000003100de7306ULL, 0x000fe20000205400ULL, 0x0000008f8e8e723eULL, 0x000fce00000010ffULL,
0x0000003100617306ULL, 0x0003e2000020d400ULL, 0x000000018b8b4812ULL, 0x004fe400078efcffULL,
0x000000d04400720bULL, 0x000fe40003f9d000ULL, 0x0000000123231812ULL, 0x000fe400078efcffULL,
0x0000008b858f723eULL, 0x000fe200000010ffULL, 0x0000004300d37306ULL, 0x000fe20000209400ULL,
0x000100006b317824ULL, 0x002fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011431ULL,
0x0000010070317824ULL, 0x000fe200078e00ffULL, 0x0000004300d47306ULL, 0x000e620000205400ULL,
0x0000000183834812ULL, 0x000fe400078efcffULL, 0x000000888700720bULL, 0x000fca0003f9d000ULL,
0x00000043008c7306ULL, 0x0004f0000020d400ULL, 0x0000006000c77306ULL, 0x000fe20000209400ULL,
0x00000018ff437819ULL, 0x004fe4000001143eULL, 0x000000d4d300720bULL, 0x002fc40003fdd000ULL,
0x000000016d6d4812ULL, 0x000fc600078efcffULL, 0x0000006000c87306ULL, 0x000ff00000205400ULL,
0x00000060007c7306ULL, 0x000fe2000020d400ULL, 0x000000018c8c6812ULL, 0x008fc800078efcffULL,
0x0000008c218c723eULL, 0x000fc600000010ffULL, 0x0000003000967306ULL, 0x000ff00000209400ULL,
0x0000003000977306ULL, 0x000ff00000205400ULL, 0x0000003000607306ULL, 0x0003f0000020d400ULL,
0x0000004a00cf7306ULL, 0x000fe20000209400ULL, 0x000130006e307811ULL, 0x002fce00078e20ffULL,
0x0000004a00d17306ULL, 0x000e700000205400ULL, 0x0000004a00847306ULL, 0x000eb0000020d400ULL,
0x00000043003e7306ULL, 0x000fe20000209400ULL, 0x000000d1cf00720bULL, 0x002fce0003f5d000ULL,
0x00000043003f7306ULL, 0x000fec0000205400ULL, 0x0000000184842812ULL, 0x004fe400078efcffULL,
0x00000043007f7306ULL, 0x000ff0000020d400ULL, 0x0000003d00437306ULL, 0x000ff00000209400ULL,
0x0000003d004a7306ULL, 0x000ff00000205400ULL, 0x0000003d00817306ULL, 0x000ff0000020d400ULL,
0x0000006200d27306ULL, 0x000ff00000009400ULL, 0x0000006200d57306ULL, 0x000e700000005400ULL,
0x0000006200827306ULL, 0x000eb0000000d400ULL, 0x00000068003d7306ULL, 0x000fe20000009400ULL,
0x000000d5d200720bULL, 0x002fce0003fdd000ULL, 0x0000006800457306ULL, 0x000e6c0000005400ULL,
0x0000000182826812ULL, 0x004fe400078efcffULL, 0x00000068007e7306ULL, 0x0004e2000000d400ULL,
0x0000003f3e00720bULL, 0x000fe40003fdd000ULL, 0x00000040893e723eULL, 0x000fc400000010ffULL,
0x000000948a3f723eULL, 0x000fe400000010ffULL, 0x00013000b2407811ULL, 0x000fe200078e20ffULL,
0x0000003200a17306ULL, 0x000fe20000209400ULL, 0x00000018ff687819ULL, 0x004fe40000011431ULL,
0x000000453d00720bULL, 0x002fe40003f5d000ULL, 0x000000bdc13d723eULL, 0x000fe400000010ffULL,
0x000000017f7f6812ULL, 0x000fe200078efcffULL, 0x0000003200a27306ULL, 0x000fe20000205400ULL,
0x000000929300720bULL, 0x000fc40003fdd000ULL, 0x000000427b92723eULL, 0x000fe400000010ffULL,
0x000000b97793723eULL, 0x000fe200000010ffULL, 0x0000010072b97824ULL, 0x000fe200078e00ffULL,
0x000000828382723eULL, 0x000fe200000010ffULL, 0x0000003200627306ULL, 0x0003e2000020d400ULL,
0x0001000073777824ULL, 0x000fe200078e00ffULL, 0x000000017e7e2812ULL, 0x008fe400078efcffULL,
0x000000abdd00720bULL, 0x000fe40003f5d000ULL, 0x000000016c6c6812ULL, 0x000fc400078efcffULL,
0x0000006300d67306ULL, 0x000fe20000009400ULL, 0x000000003030783bULL, 0x002e620000000200ULL,
0x000000c3c200720bULL, 0x000fe40003fdd000ULL, 0x00000018ffb97819ULL, 0x000fe400000114b9ULL,
0x00000018ff777819ULL, 0x000fe40000011477ULL, 0x00000063003c7306ULL, 0x000ea20000005400ULL,
0x0000000169692812ULL, 0x000fcc00078efcffULL, 0x000000017d7d6812ULL, 0x000fe200078efcffULL,
0x0000006300807306ULL, 0x000ee2000000d400ULL, 0x000000e1e300720bULL, 0x000fe40003fdd000ULL,
0x0000003cd600720bULL, 0x004fca0003fbd000ULL, 0x0000006a00c57306ULL, 0x000fe20000009400ULL,
0x000000bebf3c723eULL, 0x000fe200000010ffULL, 0x0001000071bf7824ULL, 0x000fc800078e00ffULL,
0x0000000129296812ULL, 0x000fe400078efcffULL, 0x000000a2a100720bULL, 0x000fe20003fdd000ULL,
0x0000006a00c67306ULL, 0x000ea20000005400ULL, 0x00000018ffbf7819ULL, 0x000fe400000114bfULL,
0x0000000180805812ULL, 0x008fe400078efcffULL, 0x0000004a4300720bULL, 0x000fe20003fbd000ULL,
0x000000783030b231ULL, 0x082fe400003400ffULL, 0x0000006a00637306ULL, 0x000e62000000d400ULL,
0x000000783232b231ULL, 0x000fe200003400ffULL, 0x000000807f83723eULL, 0x000fe200000010ffULL,
0x000000763131b231ULL, 0x080fe200003400ffULL, 0x0000000162626812ULL, 0x000fe200078efcffULL,
0x000000763333b231ULL, 0x000fe200003400ffULL, 0x000000979600720bULL, 0x000fc40003fdd000ULL,
0x0000004700907306ULL, 0x000fe20000209400ULL, 0x000000c6c500720bULL, 0x004fe40003f9d000ULL,
0x0000000181815812ULL, 0x000fe200078efcffULL, 0x0000003c304c723cULL, 0x000fe2000004184cULL,
0x000000c8c700720bULL, 0x000fc60003fbd000ULL, 0x0000004700917306ULL, 0x000fe60000205400ULL,
0x00000100713c7824ULL, 0x000fe200078e00ffULL, 0x000000c4c03d723eULL, 0x000fe200000010ffULL,
0x0000003e3050723cULL, 0x040fe20000041850ULL, 0x0000000163634812ULL, 0x002fe400078efcffULL,
0x00000018ffbe7819ULL, 0x000fe2000001143cULL, 0x0000004700467306ULL, 0x000fe2000020d400ULL,
0x000000b8413c723eULL, 0x000fe200000010ffULL, 0x0000010073b87824ULL, 0x000fe200078e00ffULL,
0x00013000b13e7811ULL, 0x000fe200078e20ffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x00000092305c723cULL, 0x000fe2000004185cULL, 0x000000ebec00720bULL, 0x000fc40003f9d000ULL,
0x0000007200877306ULL, 0x000fe20000009400ULL, 0x000000017c7c5812ULL, 0x000fe400078efcffULL,
0x00000018ffb87819ULL, 0x000fe200000114b8ULL, 0x0001000072927824ULL, 0x000fe200078e00ffULL,
0x0000003c3054723cULL, 0x000fe20000041854ULL, 0x000000003e3c783bULL, 0x000ea20000000200ULL,
0x0000000160606812ULL, 0x000fe200078efcffULL, 0x0000007200887306ULL, 0x000ee20000005400ULL,
0x00000018ff927819ULL, 0x000fe40000011492ULL, 0x0000000124244812ULL, 0x000fc400078efcffULL,
0x000000636262723eULL, 0x000fc600000010ffULL, 0x0000007200447306ULL, 0x000870000000d400ULL,
0x00000073006a7306ULL, 0x000fe20000009400ULL, 0x000000a8ba72723eULL, 0x010fe400000010ffULL,
0x000000888700720bULL, 0x008fca0003fdd000ULL, 0x0000007300897306ULL, 0x000fe20000005400ULL,
0x000000784040b231ULL, 0x082fe400003400ffULL, 0x000000784242b231ULL, 0x000fca00003400ffULL,
0x00000073004a7306ULL, 0x0003e2000000d400ULL, 0x000000764141b231ULL, 0x080fe200003400ffULL,
0x0000000144446812ULL, 0x000fe200078efcffULL, 0x000000764343b231ULL, 0x000fe400003400ffULL,
0x000000783c3cb231ULL, 0x004fc600003400ffULL, 0x0000007000a37306ULL, 0x000fe20000009400ULL,
0x000000adbc73723eULL, 0x002fe200000010ffULL, 0x000000783e3eb231ULL, 0x000fe200003400ffULL,
0x0000009c4054723cULL, 0x000fe20000041854ULL, 0x000000763d3db231ULL, 0x080fe200003400ffULL,
0x0000007e7d78723eULL, 0x000fe200000010ffULL, 0x000000763f3fb231ULL, 0x000fe200003400ffULL,
0x000000afae00720bULL, 0x000fe20003f7d000ULL, 0x0000007000a47306ULL, 0x000e660000005400ULL,
0x000000723058723cULL, 0x000fea0000041858ULL, 0x0000007000477306ULL, 0x0004e4000000d400ULL,
0x000000b66f72723eULL, 0x000fc400000010ffULL, 0x000000ac1f73723eULL, 0x000fe400000010ffULL,
0x0000000179793812ULL, 0x000fe400078efcffULL, 0x00000071009f7306ULL, 0x000fe20000009400ULL,
0x0001000070707824ULL, 0x004fe200078e00ffULL, 0x000000a4a300720bULL, 0x002fe20003f5d000ULL,
0x00000072302c723cULL, 0x000fe2000004182cULL, 0x000000dedf00720bULL, 0x000fe40003f7d000ULL,
0x00000018ffbd7819ULL, 0x000fc40000011470ULL, 0x0000007100a07306ULL, 0x000e620000005400ULL,
0x000000bb7570723eULL, 0x000fe400000010ffULL, 0x000000b5b075723eULL, 0x000fe200000010ffULL,
0x0000008e4058723cULL, 0x000fe20000041858ULL, 0x0000007a7979723eULL, 0x000fe400000010ffULL,
0x0000000147472812ULL, 0x008fe200078efcffULL, 0x0000007100457306ULL, 0x0004e2000000d400ULL,
0x0000000161613812ULL, 0x000fce00078efcffULL, 0x000000bd007b7306ULL, 0x000fe20000209400ULL,
0x000000b77471723eULL, 0x004fe400000010ffULL, 0x000000b4b374723eULL, 0x000fe400000010ffULL,
0x000000a09f00720bULL, 0x002fc60003f7d000ULL, 0x000000703034723cULL, 0x040fe20000041834ULL,
0x000000bd00937306ULL, 0x000e6c0000205400ULL, 0x000000a9aa70723eULL, 0x000fe200000010ffULL,
0x000000743038723cULL, 0x000fe20000041838ULL, 0x000000be008a7306ULL, 0x000fe20000209400ULL,
0x000000a6a771723eULL, 0x000fc400000010ffULL, 0x0000000145453812ULL, 0x008fe400078efcffULL,
0x000000f3f400720bULL, 0x000fe40003f7d000ULL, 0x000000a50f30723eULL, 0x000fe200000010ffULL,
0x000000be00947306ULL, 0x000ea20000205400ULL, 0x0000009e0e31723eULL, 0x000fe200000010ffULL,
0x00000070404c723cULL, 0x000fe2000004184cULL, 0x000000990d0e723eULL, 0x000fe400000010ffULL,
0x0000008d220f723eULL, 0x000fc400000010ffULL, 0x000000937b00720bULL, 0x002fe20003f5d000ULL,
0x0000006b00c97306ULL, 0x000fe20000009400ULL, 0x00000084208d723eULL, 0x000fe200000010ffULL,
0x000000304050723cULL, 0x000fe20000041850ULL, 0x0000000165653812ULL, 0x000fe400078efcffULL,
0x000000602422723eULL, 0x000fc600000010ffULL, 0x0000006b00ca7306ULL, 0x000e620000005400ULL,
0x000000948a00720bULL, 0x004fe20003f3d000ULL, 0x0000000e405c723cULL, 0x040fec000004185cULL,
0x0000006b004b7306ULL, 0x000ea2000000d400ULL, 0x000000816d0e723eULL, 0x000fe200000010ffULL,
0x0000008c4034723cULL, 0x000fe20000041834ULL, 0x0000007c6c0f723eULL, 0x000fca00000010ffULL,
0x00000068006b7306ULL, 0x000fe20000209400ULL, 0x000000cac900720bULL, 0x002fe20003fbd000ULL,
0x0000000e402c723cULL, 0x040fec000004182cULL, 0x0000006800867306ULL, 0x000e620000205400ULL,
0x00000069290e723eULL, 0x000fe200000010ffULL, 0x000000824038723cULL, 0x000fe20000041838ULL,
0x00000061250f723eULL, 0x000fc600000010ffULL, 0x000000014b4b5812ULL, 0x004fe400078efcffULL,
0x0000006800487306ULL, 0x000ea2000020d400ULL, 0x000000919000720bULL, 0x000fe20003fbd000ULL,
0x0000000e3c50723cULL, 0x000fe20000041850ULL, 0x0000004b4963723eULL, 0x000fca00000010ffULL,
0x000000bd00a87306ULL, 0x000ee2000020d400ULL, 0x000000866b00720bULL, 0x002fe20003f9d000ULL,
0x000000783c4c723cULL, 0x040fe8000004184cULL, 0x0000000146465812ULL, 0x000fe400078efcffULL,
0x000000be00687306ULL, 0x000e62000020d400ULL, 0x000000896a00720bULL, 0x000fe20003fbd000ULL,
0x000000623c54723cULL, 0x000fe20000041854ULL, 0x000000462323723eULL, 0x000fc600000010ffULL,
0x0000000148484812ULL, 0x004fe400078efcffULL, 0x000000b900337306ULL, 0x000fe20000209400ULL,
0x00000001a8a82812ULL, 0x008fe200078efcffULL, 0x000000223c5c723cULL, 0x000fe2000004185cULL,
0x000000f5f600720bULL, 0x000fe40003f9d000ULL, 0x000000474848723eULL, 0x000fe400000010ffULL,
0x000000014a4a5812ULL, 0x000fe200078efcffULL, 0x000000b900307306ULL, 0x000ea20000205400ULL,
0x0000000168681812ULL, 0x002fc800078efcffULL, 0x000000456849723eULL, 0x000fc600000010ffULL,
0x000000bf001f7306ULL, 0x000fe20000209400ULL, 0x0000000167674812ULL, 0x000fe400078efcffULL,
0x000000f1f200720bULL, 0x000fe20003f9d000ULL, 0x000000483c58723cULL, 0x000fe20000041858ULL,
0x000000a867a8723eULL, 0x000fc600000010ffULL, 0x000000bf006f7306ULL, 0x000e620000205400ULL,
0x000000303300720bULL, 0x004fce0003f5d000ULL, 0x000000b9000d7306ULL, 0x000ea2000020d400ULL,
0x0000000166664812ULL, 0x000fce00078efcffULL, 0x0000009200207306ULL, 0x000fe20000209400ULL,
0x0000006f1f00720bULL, 0x002fce0003f3d000ULL, 0x0000009200217306ULL, 0x000e620000205400ULL,
0x000000010d0d2812ULL, 0x004fc800078efcffULL, 0x000000440d44723eULL, 0x000fe400000010ffULL,
0x00000001130d7812ULL, 0x000fe200078ec0ffULL, 0x000000bf00327306ULL, 0x000eb0000020d400ULL,
0x000000b800317306ULL, 0x000fe20000209400ULL, 0x000000212000720bULL, 0x002fce0003f5d000ULL,
0x000000b800707306ULL, 0x000e620000205400ULL, 0x0000000132321812ULL, 0x004fe400078efcffULL,
0x000000eff000720bULL, 0x000fe40003f3d000ULL, 0x0000003265a9723eULL, 0x000fc600000010ffULL,
0x00000077001f7306ULL, 0x000fe80000209400ULL, 0x000000a83c34723cULL, 0x000fe80000041834ULL,
0x00000077000e7306ULL, 0x000ea20000205400ULL, 0x000000703100720bULL, 0x002fe40003f7d000ULL,
0x000000012b2b1812ULL, 0x000fc400078efcffULL, 0x000000010d00780cULL, 0x000fc60003f25070ULL,
0x000000b800717306ULL, 0x000e70000020d400ULL, 0x00000092000f7306ULL, 0x000ee2000020d400ULL,
0x0000000e1f00720bULL, 0x004fce0003fdd000ULL, 0x0000007700207306ULL, 0x000ea2000020d400ULL,
0x0000000171713812ULL, 0x002fc800078efcffULL, 0x0000004a7145723eULL, 0x000fe400000010ffULL,
0x000000010f0f2812ULL, 0x008fc800078efcffULL, 0x0000000f6666723eULL, 0x000fe200000010ffULL,
0x000000443c38723cULL, 0x000fe20000041838ULL, 0x0000000120206812ULL, 0x004fc800078efcffULL,
0x000000202b67723eULL, 0x000fce00000010ffULL, 0x000000663c3c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080001dc7983ULL, 0x000ea20000300800ULL, 0x0000000c0b0d7207ULL, 0x000fe40004800000ULL,
0x00000001130e7812ULL, 0x000fe200078e0cffULL, 0x01c63000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff0dff7812ULL, 0x000fe4000784c0ffULL, 0x000000c0030d7811ULL, 0x000fe400078e40ffULL,
0x00000001ff1f7807ULL, 0x000fc40001000000ULL, 0x0000000d0200720cULL, 0x000fe40003f44070ULL,
0x0000000c1f1f7207ULL, 0x000fc80004800000ULL, 0x000076101f0d7816ULL, 0x000fe4000000000dULL,
0x000000ffdcff7812ULL, 0x004fc8000786c0ffULL, 0x00000001ff0f7807ULL, 0x000fe20001800000ULL,
0x00004ad00000a947ULL, 0x000fea0003800000ULL, 0x01c65c00ff067984ULL, 0x000e620000000800ULL,
0x80000000260f7824ULL, 0x000fca00078e00ffULL, 0x8000000006ff7812ULL, 0x002fe2000782480fULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe4000782480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x80000000260f7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x00000006000e7305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc4000782480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000127277824ULL, 0x000fe200078e022aULL,
0x00000000001f7919ULL, 0x000e620000002700ULL, 0x00000300ff067624ULL, 0x000fe400078e00ffULL,
0x00006400ff217624ULL, 0x000fe200078e00ffULL, 0x00000003270e7812ULL, 0x000fe200078ec0ffULL,
0x00005800ff207624ULL, 0x000fe200078e00ffULL, 0xfffffffd06067811ULL, 0x000fe400078e10ffULL,
0x000000030e00780cULL, 0x000fe20003f25270ULL, 0x0000000000257919ULL, 0x000ea20000000000ULL,
0x0000004020207824ULL, 0x000fc400078e00ffULL, 0x0000000106067807ULL, 0x000fe40004800000ULL,
0x0000000407237e24ULL, 0x020fe4000f8e0220ULL, 0x0000001000207824ULL, 0x000fe400078e00ffULL,
0x0000000127067824ULL, 0x000fe200078e0206ULL, 0x00000000002b7919ULL, 0x000ee20000000000ULL,
0xffffffffff077424ULL, 0x000fc600078e00ffULL, 0x000000040600720cULL, 0x000fe20003f26070ULL,
0x000000021f1f7824ULL, 0x002fc800078e00ffULL, 0x000064001f1f7624ULL, 0x000fd000078e0221ULL,
0x00000001060e9824ULL, 0x000fe400078e021fULL, 0x00000000001f7919ULL, 0x000e620000000000ULL,
0x00000004ff0f9424ULL, 0x000fe200078e00ffULL, 0x0000003f23267812ULL, 0x040fe200078ef812ULL,
0x00000100ff277424ULL, 0x000fe400078e00ffULL, 0x000060000e0e9625ULL, 0x000fe200078e000fULL,
0x0000003f23227812ULL, 0x000fc600078ef810ULL, 0x00000010252d7824ULL, 0x004fe200078e00ffULL,
0x000000060e079981ULL, 0x000562000c1e1900ULL, 0x00000004ff217819ULL, 0x002fe4000001161fULL,
0x00000300031f7a10ULL, 0x000fc60007ffe0ffULL, 0x0000000120207824ULL, 0x000fe400078e0221ULL,
0x000001001f217824ULL, 0x000fc600078e00ffULL, 0x0000003f23207812ULL, 0x000fe400078ef820ULL,
0x0000002102127217ULL, 0x000fe40007800000ULL, 0x000000011f107810ULL, 0x000fe20007ffe0ffULL,
0x00005e00200e7625ULL, 0x004fe200078e0027ULL, 0x000000f02d2d7812ULL, 0x000fe400078ec0ffULL,
0x0000003f23247812ULL, 0x040fe200078ef811ULL, 0x0000000112127824ULL, 0x000fe200078e0a21ULL,
0x000000051000720cULL, 0x000fe20003f26070ULL, 0x0000001000297824ULL, 0x000fe200078e00ffULL,
0x0000002d0e0e7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0022107625ULL, 0x000fe200078e0027ULL,
0x0000003f232a7812ULL, 0x000fc400078ef814ULL, 0x0000003f232c7812ULL, 0x040fe200078ef815ULL,
0x00005e0024147625ULL, 0x080fe200078e0027ULL, 0x0000004012127807ULL, 0x000fe40000800000ULL,
0x0000003f232e7812ULL, 0x040fe400078ef816ULL, 0x0000003f23307812ULL, 0x000fe200078ef817ULL,
0x00005e0026167625ULL, 0x000fe200078e0027ULL, 0x0000001229127217ULL, 0x000fc60007800000ULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000002d10107210ULL, 0x000fe20007f5e0ffULL,
0x00005e002a207625ULL, 0x000fe200078e0027ULL, 0x0000002d14147210ULL, 0x080fe40007f7e0ffULL,
0x0000002d16167210ULL, 0x000fe20007f9e0ffULL, 0x00005e002c227625ULL, 0x000fe200078e0027ULL,
0x00000004ff1f7819ULL, 0x008fc6000001162bULL, 0x0000000112127824ULL, 0x000fe400078e0a29ULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x0000002d20207210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x0000002d22227210ULL, 0x000fe20007f7e0ffULL,
0x00005e002e247625ULL, 0x080fe200078e0027ULL, 0x0000000828287812ULL, 0x000fe400078ec0ffULL,
0x00004000e2e27812ULL, 0x000fe200078ec0ffULL, 0x00005e0030267625ULL, 0x000fe200078e0027ULL,
0x000000041f297810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200020e0617ULL,
0x000000121f00720cULL, 0x0c0fe20003f86070ULL, 0x000000ffff217224ULL, 0x000fe200010e0621ULL,
0x000000021f2b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000280573c2ULL, 0x000e6200000e0000ULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x0000002d26267210ULL, 0x000fe40007f5e0ffULL,
0x00014000e2e27810ULL, 0x000fe40007ffe0ffULL, 0x000000122900720cULL, 0x000fc40003f66070ULL,
0x000000122b00720cULL, 0x080fe40003fa6070ULL, 0x000000081f297810ULL, 0x040fe40007ffe0ffULL,
0x0000002d24247210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x000000061f2b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010e7e77824ULL, 0x000fe200078e02e2ULL,
0x000000122900720cULL, 0x000fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200008e0625ULL,
0x0000000a1f297810ULL, 0x000fc40007ffe0ffULL, 0x000000122b00720cULL, 0x080fe20003f26070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000ee77faeULL, 0x0005e2000e101c46ULL,
0x00000010e62b7824ULL, 0x100fe200078e02e2ULL, 0x000000122900720cULL, 0x080fe20003f86070ULL,
0x00000010e5e57824ULL, 0x000fe200078e02e2ULL, 0x0000000c1f297810ULL, 0x040fe40007ffe0ffULL,
0x0000000e1f1f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000102b7faeULL, 0x0007e2000e901c46ULL,
0x000000122900720cULL, 0x000fc60003fa6070ULL, 0x0000000014e57faeULL, 0x0007e2000d901c46ULL,
0x000000121f00720cULL, 0x000fe20003f66070ULL, 0x00000010e4297824ULL, 0x100fe200078e02e2ULL,
0x0001c64805057890ULL, 0x002fe2000fffe03fULL, 0x0000001019197824ULL, 0x100fe400078e02e2ULL,
0x000000101a0f7824ULL, 0x104fe200078e02e2ULL, 0x0000000016297faeULL, 0x0007e2000c901c46ULL,
0x000000101b1b7824ULL, 0x100fe400078e02e2ULL, 0x000000101c1f7824ULL, 0x000fe200078e02e2ULL,
0x0000000020197faeULL, 0x0007e8000d101c46ULL, 0x00000000220f7faeULL, 0x0007e8000e101c46ULL,
0x00000000241b7faeULL, 0x0007e8000e901c46ULL, 0x00000000261f7faeULL, 0x0007e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0001c648180e7811ULL, 0x000fe200078e18ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000004000e0f7984ULL, 0x0082a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c63c00ff107984ULL, 0x000ee20000000800ULL, 0x0000ffff0d147812ULL, 0x000fe200078ec0ffULL,
0x800000001d117824ULL, 0x000fc800078e00ffULL, 0x80000000140e7824ULL, 0x002fca00078e00ffULL,
0x800000000fff7812ULL, 0x004fe4000782480eULL, 0x8000000010ff7812ULL, 0x008fe20007844811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000001d107824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e000f7305ULL, 0x0002a4000021f000ULL, 0x3fa000000e0e7823ULL, 0x002fe200000100ffULL,
0x0000000f0000735dULL, 0x004fe40003800000ULL, 0x01c63c00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007844810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x01c180001e0f7984ULL, 0x000e620000000800ULL,
0x00000001ff6a7424ULL, 0x000fc600078e00ffULL, 0x01c380001e0e7984ULL, 0x0004e20000000800ULL,
0x000000080f00720bULL, 0x002fda0003f5d000ULL, 0x0000000000107806ULL, 0x000fc800010e0100ULL,
0x0000ffff10117812ULL, 0x000fda000784c0ffULL, 0x000003700000a947ULL, 0x000fea0003800000ULL,
0x000000080f00720bULL, 0x00cfe20003f54000ULL, 0x0000000000167919ULL, 0x000e620000000000ULL,
0x0000000f08157209ULL, 0x000fca0007810000ULL, 0x8000001508107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x000000030000780cULL, 0x000fe40003f45270ULL, 0x0000ffff08127812ULL, 0x000fe200078e3cffULL,
0x0000001000107308ULL, 0x000ea60000000800ULL, 0x0000001211ff7212ULL, 0x000fc4000786c0ffULL,
0x00000002ff177819ULL, 0x102fe40000011616ULL, 0x00000002ff167819ULL, 0x000fc60000011616ULL,
0x01c580151e00a388ULL, 0x000fe20000000800ULL, 0x00000001ff6a7807ULL, 0x000fe40001800000ULL,
0x0000000816167810ULL, 0x000fe20007ffe0ffULL, 0x00001f1710087589ULL, 0x004e6400000e0000ULL,
0x800000150f113221ULL, 0x000fe40000010000ULL, 0x0000001009097220ULL, 0x000fe20000410000ULL,
0x00001f16100f7589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b11113820ULL, 0x000fc80000410000ULL,
0x00000011000a3308ULL, 0x000ee20000000800ULL, 0x000000084c4c7220ULL, 0x082fe40000410000ULL,
0x000000084d4d7220ULL, 0x080fe40000410000ULL, 0x0000000850507220ULL, 0x080fe40000410000ULL,
0x0000000851517220ULL, 0x080fe40000410000ULL, 0x0000000854547220ULL, 0x080fe40000410000ULL,
0x0000000855557220ULL, 0x000fc40000410000ULL, 0x000000085c5c7220ULL, 0x080fe40000410000ULL,
0x000000085d5d7220ULL, 0x080fe40000410000ULL, 0x0000000858587220ULL, 0x080fe40000410000ULL,
0x0000000859597220ULL, 0x080fe40000410000ULL, 0x0000000834347220ULL, 0x080fe40000410000ULL,
0x0000000835357220ULL, 0x000fc40000410000ULL, 0x0000000838387220ULL, 0x080fe40000410000ULL,
0x0000000839397220ULL, 0x080fe40000410000ULL, 0x000000083c3c7220ULL, 0x080fe40000410000ULL,
0x000000083d3d7220ULL, 0x000fe40000410000ULL, 0x0000000f4e4e7220ULL, 0x084fe40000410000ULL,
0x0000000f4f4f7220ULL, 0x000fc40000410000ULL, 0x0000000f52527220ULL, 0x080fe40000410000ULL,
0x0000000f53537220ULL, 0x080fe40000410000ULL, 0x0000000f56567220ULL, 0x080fe40000410000ULL,
0x0000000f57577220ULL, 0x080fe40000410000ULL, 0x0000000f5e5e7220ULL, 0x080fe40000410000ULL,
0x0000000f5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000f5a5a7220ULL, 0x080fe40000410000ULL,
0x0000000f5b5b7220ULL, 0x080fe40000410000ULL, 0x0000000f36367220ULL, 0x080fe40000410000ULL,
0x0000000f37377220ULL, 0x080fe40000410000ULL, 0x0000000f3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000f3b3b7220ULL, 0x000fc40000410000ULL, 0x0000000f3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000f3f3f7220ULL, 0x000fe40000410000ULL, 0x000000ffff087224ULL, 0x000fe400078e0015ULL,
0x0000000e0a0e3220ULL, 0x008fc80000410000ULL, 0x000000090e097221ULL, 0x00cfe20000010000ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0001c64818187811ULL, 0x000fe200078e18ffULL,
0x80000000140f7824ULL, 0x000fc800078e00ffULL, 0x00000400180e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe4000782480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000014147824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e000f7305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x0000000f0000735dULL, 0x004fe40003800000ULL,
0x00000400180f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fc40007824814ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000001157983ULL, 0x000ea80000300800ULL, 0x0000040001127983ULL, 0x000ee20000300800ULL,
0x000099100d0d7816ULL, 0x000fc600000000ffULL, 0x00000000f760783bULL, 0x000e680000004200ULL,
0x00000000f840783bULL, 0x000f280000004200ULL, 0x00000000f92c783bULL, 0x000f280000004200ULL,
0x00000000fa28783bULL, 0x000f280000004200ULL, 0x00000000fb24783bULL, 0x0003280000004200ULL,
0x00000000fc1c783bULL, 0x000ea80000004200ULL, 0x0000000000fb7919ULL, 0x002e620000000000ULL,
0x00000018ff117819ULL, 0x000fe20000011463ULL, 0x0000006000bf7306ULL, 0x000fe20000009400ULL,
0x00000018ff0f7819ULL, 0x000fc40000011461ULL, 0x00000018ff107819ULL, 0x000fe40000011462ULL,
0x00000018ff0e7819ULL, 0x000fe40000011460ULL, 0x00000002fffa7819ULL, 0x002fe200000116fbULL,
0x00000011009f7306ULL, 0x000fe60000209400ULL, 0x00000008fafa7810ULL, 0x000fca0007ffe0ffULL,
0x0000001100a47306ULL, 0x000ff00000205400ULL, 0x0000001100d17306ULL, 0x0009f0000020d400ULL,
0x0000000f00aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff117819ULL, 0x010fce0000011443ULL,
0x00000011007a7306ULL, 0x000ff00000209400ULL, 0x0000001100797306ULL, 0x000ff00000205400ULL,
0x0000001100b97306ULL, 0x0003f0000020d400ULL, 0x0000000f00737306ULL, 0x000fe20000205400ULL,
0x00000018ff117819ULL, 0x002fce000001142fULL, 0x0000001100687306ULL, 0x000ff00000209400ULL,
0x0000001100c67306ULL, 0x000ff00000205400ULL, 0x00000011009e7306ULL, 0x0003f0000020d400ULL,
0x0000000f00df7306ULL, 0x0009e2000020d400ULL, 0x00000018ff117819ULL, 0x002fce000001142bULL,
0x0000001100207306ULL, 0x000fe20000209400ULL, 0x00000018ff0f7819ULL, 0x010fce0000011441ULL,
0x00000011008b7306ULL, 0x000ff00000205400ULL, 0x0000001100827306ULL, 0x0003f0000020d400ULL,
0x0000001000a87306ULL, 0x000fe20000209400ULL, 0x00000018ff117819ULL, 0x002fce0000011427ULL,
0x00000011006c7306ULL, 0x000ff00000209400ULL, 0x0000001100d07306ULL, 0x000ff00000205400ULL,
0x0000001100337306ULL, 0x000ff0000020d400ULL, 0x0000001000d77306ULL, 0x000ff00000205400ULL,
0x00000010006b7306ULL, 0x0003f0000020d400ULL, 0x0000000f00947306ULL, 0x000fe20000209400ULL,
0x00000018ff107819ULL, 0x002fce0000011442ULL, 0x0000000f00897306ULL, 0x000ff00000205400ULL,
0x0000000f00937306ULL, 0x0003f0000020d400ULL, 0x00000010007f7306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fce000001142dULL, 0x00000010007e7306ULL, 0x000ff00000205400ULL,
0x0000001000ba7306ULL, 0x0003f0000020d400ULL, 0x0000000f00667306ULL, 0x000fe20000209400ULL,
0x00000018ff107819ULL, 0x002fce000001142eULL, 0x0000000f00727306ULL, 0x000ff00000205400ULL,
0x0000000f00b37306ULL, 0x0003f0000020d400ULL, 0x0000001000a97306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fe20000011429ULL, 0x000000001544783bULL, 0x004e680000004200ULL,
0x000000001248783bULL, 0x0084e40000004200ULL, 0x0000001000677306ULL, 0x000fe20000205400ULL,
0x00000018ff127819ULL, 0x004fce000001141fULL, 0x0000001000a37306ULL, 0x0005f0000020d400ULL,
0x00000012009a7306ULL, 0x000fe20000209400ULL, 0x00000018ff107819ULL, 0x004fce000001142aULL,
0x00000012009b7306ULL, 0x000ff00000205400ULL, 0x0000001200117306ULL, 0x000fe2000020d400ULL,
0x00000018ff707819ULL, 0x002fe40000011447ULL, 0x00000018ff147819ULL, 0x000fc40000011446ULL,
0x00000018ff837819ULL, 0x008fc60000011449ULL, 0x0000007000dd7306ULL, 0x000fe20000209400ULL,
0x00000018ff847819ULL, 0x000fe4000001144aULL, 0x00000018ff867819ULL, 0x000fca000001144bULL,
0x0000007000dc7306ULL, 0x000ff00000205400ULL, 0x0000007000127306ULL, 0x0003f0000020d400ULL,
0x0000000f001a7306ULL, 0x000fe20000209400ULL, 0x0000010060707824ULL, 0x002fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000000f00317306ULL, 0x000ff00000205400ULL,
0x0000007000cb7306ULL, 0x000ff00000209400ULL, 0x0000007000f57306ULL, 0x000e700000205400ULL,
0x0000000f00857306ULL, 0x0005f0000020d400ULL, 0x0000006000cf7306ULL, 0x000ee20000005400ULL,
0x00000018ff0f7819ULL, 0x004fc40000011425ULL, 0x000000f5cb00720bULL, 0x002fca0003fdd000ULL,
0x0000006000a67306ULL, 0x0002b0000000d400ULL, 0x00000010001b7306ULL, 0x000fe20000209400ULL,
0x0001000060607824ULL, 0x002fe200078e00ffULL, 0x000000cfbf00720bULL, 0x008fc80003fbd000ULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x00000010008c7306ULL, 0x000fee0000205400ULL,
0x00000001a6a65812ULL, 0x004fe200078efcffULL, 0x0000001000817306ULL, 0x0003e2000020d400ULL,
0x00000073aa00720bULL, 0x000fce0003fbd000ULL, 0x0000000f00697306ULL, 0x000fe20000209400ULL,
0x00000018ff107819ULL, 0x002fca0000011426ULL, 0x00000001dfdf5812ULL, 0x000fe400078efcffULL,
0x0000000f00227306ULL, 0x000fe20000205400ULL, 0x000000d7a800720bULL, 0x000fce0003fbd000ULL,
0x0000000f00717306ULL, 0x0003ec000020d400ULL, 0x000000016b6b5812ULL, 0x000fe400078efcffULL,
0x0000001000807306ULL, 0x000fe20000209400ULL, 0x00000018ff0f7819ULL, 0x002fce000001141dULL,
0x00000010007c7306ULL, 0x000ff00000205400ULL, 0x0000001000657306ULL, 0x0003f0000020d400ULL,
0x0000000f00ab7306ULL, 0x000fe20000209400ULL, 0x00000018ff107819ULL, 0x002fce000001141eULL,
0x0000000f00b57306ULL, 0x000ff00000205400ULL, 0x0000000f00197306ULL, 0x0003f0000020d400ULL,
0x0000007000ac7306ULL, 0x0004e2000020d400ULL, 0x00000018ff0f7819ULL, 0x002fce0000011445ULL,
0x0000006000ce7306ULL, 0x000fe20000209400ULL, 0x0000010062707824ULL, 0x004fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000006000f37306ULL, 0x000e620000205400ULL,
0x00000001acac6812ULL, 0x008fce00078efcffULL, 0x0000001000a27306ULL, 0x000ff00000209400ULL,
0x0000001000a17306ULL, 0x000fe20000205400ULL, 0x000000f3ce00720bULL, 0x002fce0003fdd000ULL,
0x0000001000187306ULL, 0x000ff0000020d400ULL, 0x0000000f00d37306ULL, 0x000ff00000209400ULL,
0x0000000f00d27306ULL, 0x000ff00000205400ULL, 0x0000000f00107306ULL, 0x000ff0000020d400ULL,
0x0000008300ec7306ULL, 0x000ff00000209400ULL, 0x0000008300ea7306ULL, 0x000ff00000205400ULL,
0x00000083000f7306ULL, 0x0003f0000020d400ULL, 0x0000006000e17306ULL, 0x000ea2000020d400ULL,
0x0000010061837824ULL, 0x002fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000007000607306ULL, 0x000ff00000209400ULL, 0x0000008300b77306ULL, 0x000fe20000209400ULL,
0x00000001e1e16812ULL, 0x004fce00078efcffULL, 0x0000008300e47306ULL, 0x000e700000205400ULL,
0x0000008300e87306ULL, 0x000eb0000020d400ULL, 0x0000007000af7306ULL, 0x000ee20000205400ULL,
0x000000e4b700720bULL, 0x002fce0003fdd000ULL, 0x0000001400d97306ULL, 0x000fec0000209400ULL,
0x00000001e8e86812ULL, 0x004fe400078efcffULL, 0x0000001400d57306ULL, 0x000fe20000205400ULL,
0x000000af6000720bULL, 0x008fe20003fdd000ULL, 0x000001002f607824ULL, 0x000fcc00078e00ffULL,
0x0000001400167306ULL, 0x000ff0000020d400ULL, 0x0000008400e97306ULL, 0x000ff00000209400ULL,
0x0000008400e37306ULL, 0x000ff00000205400ULL, 0x0000008400147306ULL, 0x0003f0000020d400ULL,
0x0000007000db7306ULL, 0x0004e2000020d400ULL, 0x0000010063847824ULL, 0x002fca00078e00ffULL,
0x00000018ff847819ULL, 0x000fe40000011484ULL, 0x0000006100c57306ULL, 0x000fe20000009400ULL,
0x0000010040707824ULL, 0x004fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe40000011470ULL,
0x0000008400d87306ULL, 0x000fe20000209400ULL, 0x00000001dbdb6812ULL, 0x008fce00078efcffULL,
0x0000008400ef7306ULL, 0x000e700000205400ULL, 0x0000006100cd7306ULL, 0x000eb00000005400ULL,
0x0000006100a57306ULL, 0x000722000000d400ULL, 0x000000efd800720bULL, 0x002fce0003fdd000ULL,
0x0000006200bc7306ULL, 0x000fe20000009400ULL, 0x0001000061617824ULL, 0x008fe200078e00ffULL,
0x000000cdc500720bULL, 0x004fc80003f5d000ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006200bd7306ULL, 0x000e6e0000005400ULL, 0x00000001a5a52812ULL, 0x010fe200078efcffULL,
0x00000062007d7306ULL, 0x0004f0000000d400ULL, 0x0000006100f27306ULL, 0x000fe20000209400ULL,
0x0001000062627824ULL, 0x004fe200078e00ffULL, 0x000000bdbc00720bULL, 0x002fc80003f3d000ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000006100f47306ULL, 0x000fee0000205400ULL,
0x000000017d7d1812ULL, 0x008fe200078efcffULL, 0x0000006100e07306ULL, 0x000fe2000020d400ULL,
0x000000a49f00720bULL, 0x000fce0003f3d000ULL, 0x0000008400da7306ULL, 0x0002ac000020d400ULL,
0x00000001d1d11812ULL, 0x000fe400078efcffULL, 0x0000006200617306ULL, 0x000fe20000209400ULL,
0x0000010041847824ULL, 0x002fca00078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x0000006200c97306ULL, 0x000e620000205400ULL, 0x00000001dada6812ULL, 0x004fce00078efcffULL,
0x0000006200d67306ULL, 0x0004f0000020d400ULL, 0x0000008300957306ULL, 0x000fe20000209400ULL,
0x000000c96100720bULL, 0x002fe20003fdd000ULL, 0x0000010042627824ULL, 0x004fca00078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x00000083009c7306ULL, 0x000e6c0000205400ULL,
0x00000001d6d66812ULL, 0x008fe400078efcffULL, 0x0000000e00887306ULL, 0x000ff00000209400ULL,
0x0000000e00bb7306ULL, 0x000ea20000205400ULL, 0x0000009c9500720bULL, 0x002fe20003fdd000ULL,
0x0000010029957824ULL, 0x000fcc00078e00ffULL, 0x0000000e00ad7306ULL, 0x0003f0000020d400ULL,
0x0000008300707306ULL, 0x000ee2000020d400ULL, 0x00000018ff0e7819ULL, 0x002fe40000011440ULL,
0x000000bb8800720bULL, 0x004fca0003f9d000ULL, 0x0000000e00967306ULL, 0x000ff00000209400ULL,
0x0000000e00c47306ULL, 0x000e620000205400ULL, 0x0000000170706812ULL, 0x008fe400078efcffULL,
0x00000001adad4812ULL, 0x000fc400078efcffULL, 0x000000f4f200720bULL, 0x000fc60003f9d000ULL,
0x0000000e00927306ULL, 0x0004f0000020d400ULL, 0x0000008400c87306ULL, 0x000fe20000209400ULL,
0x00000018ff0e7819ULL, 0x004fe4000001142cULL, 0x00000001e0e04812ULL, 0x000fc400078efcffULL,
0x000000c49600720bULL, 0x002fc60003f3d000ULL, 0x0000000e00747306ULL, 0x000ff00000209400ULL,
0x0000000e00787306ULL, 0x000fe40000205400ULL, 0x0000000192921812ULL, 0x008fcc00078efcffULL,
0x0000000e00b47306ULL, 0x0003f0000020d400ULL, 0x0000008400c77306ULL, 0x000ea20000205400ULL,
0x00000018ff0e7819ULL, 0x002fce0000011428ULL, 0x0000004000a77306ULL, 0x000ff00000009400ULL,
0x0000004000e57306ULL, 0x000e620000005400ULL, 0x000000c7c800720bULL, 0x004fce0003fdd000ULL,
0x00000040006d7306ULL, 0x0004f0000000d400ULL, 0x0000000e00c07306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x004fe200078e00ffULL, 0x000000e5a700720bULL, 0x002fc80003f5d000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000000e00307306ULL, 0x000fee0000205400ULL,
0x000000016d6d2812ULL, 0x008fe200078efcffULL, 0x0000000e008f7306ULL, 0x0003e2000020d400ULL,
0x000000899400720bULL, 0x000fe20003f5d000ULL, 0x0001000029897824ULL, 0x000fcc00078e00ffULL,
0x0000008400b87306ULL, 0x000ea2000020d400ULL, 0x00000018ff0e7819ULL, 0x002fca0000011424ULL,
0x0000000193932812ULL, 0x000fe400078efcffULL, 0x0000000e00977306ULL, 0x000ff00000209400ULL,
0x0000000e008e7306ULL, 0x000fe20000205400ULL, 0x00000001b8b86812ULL, 0x004fce00078efcffULL,
0x0000000e00777306ULL, 0x0003f0000020d400ULL, 0x0000004000c27306ULL, 0x000fe20000209400ULL,
0x00000018ff0e7819ULL, 0x002fce000001141cULL, 0x0000004000cc7306ULL, 0x000e700000205400ULL,
0x0000000e00237306ULL, 0x000ff00000209400ULL, 0x0000000e006f7306ULL, 0x000fe20000205400ULL,
0x000000ccc200720bULL, 0x002fce0003fdd000ULL, 0x0000000e00217306ULL, 0x0003f0000020d400ULL,
0x0000006300b67306ULL, 0x000fe20000009400ULL, 0x00000018ff0e7819ULL, 0x002fce0000011444ULL,
0x0000000e00757306ULL, 0x000ff00000209400ULL, 0x0000000e00767306ULL, 0x000ff00000205400ULL,
0x0000000e00177306ULL, 0x0003f0000020d400ULL, 0x0000006300be7306ULL, 0x000ea20000005400ULL,
0x00000018ff0e7819ULL, 0x002fce0000011448ULL, 0x00000063007b7306ULL, 0x0002f0000000d400ULL,
0x0000000e00f97306ULL, 0x000fe20000209400ULL, 0x0001000063637824ULL, 0x002fe200078e00ffULL,
0x000000beb600720bULL, 0x004fc80003f7d000ULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x0000000e00f87306ULL, 0x000fee0000205400ULL, 0x000000017b7b3812ULL, 0x008fe200078efcffULL,
0x0000000e00157306ULL, 0x000ff0000020d400ULL, 0x0000008600e27306ULL, 0x000ff00000209400ULL,
0x0000008600de7306ULL, 0x000ff00000205400ULL, 0x00000086000e7306ULL, 0x000ff0000020d400ULL,
0x0000004000ae7306ULL, 0x0002b0000020d400ULL, 0x0000006200867306ULL, 0x000fe20000209400ULL,
0x0001000042407824ULL, 0x002fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006200877306ULL, 0x000e620000205400ULL, 0x00000001aeae6812ULL, 0x004fc800078efcffULL,
0x000000ae9292723eULL, 0x000fe200000010ffULL, 0x000001004bae7824ULL, 0x000fe400078e00ffULL,
0x0000006300ee7306ULL, 0x000fe60000209400ULL, 0x00000018ffae7819ULL, 0x000fca00000114aeULL,
0x0000006300f07306ULL, 0x000ea20000205400ULL, 0x000000878600720bULL, 0x002fe20003fdd000ULL,
0x000001002b877824ULL, 0x000fcc00078e00ffULL, 0x0000006300d47306ULL, 0x0002f0000020d400ULL,
0x0000006200907306ULL, 0x000f22000020d400ULL, 0x0000010043637824ULL, 0x002fe200078e00ffULL,
0x000000f0ee00720bULL, 0x004fc80003f7d000ULL, 0x00000018ffc37819ULL, 0x000fe40000011463ULL,
0x0000004100997306ULL, 0x000fee0000009400ULL, 0x00000001d4d43812ULL, 0x008fe200078efcffULL,
0x000000c300987306ULL, 0x000fe20000209400ULL, 0x0000000190906812ULL, 0x010fce00078efcffULL,
0x000000c3008a7306ULL, 0x000e700000205400ULL, 0x0000004100b07306ULL, 0x000eb00000005400ULL,
0x0000004100327306ULL, 0x000722000000d400ULL, 0x0000008a9800720bULL, 0x002fce0003fdd000ULL,
0x000000c300917306ULL, 0x000e62000020d400ULL, 0x0001000041417824ULL, 0x008fe200078e00ffULL,
0x000000b09900720bULL, 0x004fc80003f9d000ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004200ca7306ULL, 0x000fee0000009400ULL, 0x0000000132324812ULL, 0x010fe200078efcffULL,
0x0000004200eb7306ULL, 0x000ea20000005400ULL, 0x0000000191916812ULL, 0x002fc400078efcffULL,
0x0000007e7f00720bULL, 0x000fca0003fdd000ULL, 0x00000042008d7306ULL, 0x0002f0000000d400ULL,
0x0000004100e67306ULL, 0x000fe20000209400ULL, 0x000001002c427824ULL, 0x002fe200078e00ffULL,
0x00000001baba6812ULL, 0x000fc400078efcffULL, 0x000000ebca00720bULL, 0x004fc80003fbd000ULL,
0x0000004100ed7306ULL, 0x000e700000205400ULL, 0x0000004100a07306ULL, 0x000522000020d400ULL,
0x000000018d8d5812ULL, 0x008fc800078efcffULL, 0x0000008d9090723eULL, 0x000fe200000010ffULL,
0x00000100488d7824ULL, 0x000fe400078e00ffULL, 0x0000004000847306ULL, 0x000fe20000209400ULL,
0x0001000043417824ULL, 0x004fe200078e00ffULL, 0x000000ede600720bULL, 0x002fe40003f9d000ULL,
0x00000018ffe67819ULL, 0x000fe40000011487ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004000837306ULL, 0x000e6e0000205400ULL, 0x00000001a0a04812ULL, 0x010fe200078efcffULL,
0x0000004000c37306ULL, 0x0004e6000020d400ULL, 0x000000a09393723eULL, 0x000fe200000010ffULL,
0x000100004aa07824ULL, 0x000fc800078e00ffULL, 0x0000004100e77306ULL, 0x000fe20000209400ULL,
0x00000018ff407819ULL, 0x004fe40000011442ULL, 0x000000838400720bULL, 0x002fe40003fbd000ULL,
0x00000018ffa07819ULL, 0x000fc600000114a0ULL, 0x0000004000c57306ULL, 0x000ff00000209400ULL,
0x0000004000cb7306ULL, 0x000e620000205400ULL, 0x00000001c3c35812ULL, 0x008fce00078efcffULL,
0x0000004100f17306ULL, 0x000eb00000205400ULL, 0x0000004100bf7306ULL, 0x000722000020d400ULL,
0x000000cbc500720bULL, 0x002fce0003fdd000ULL, 0x0000004300637306ULL, 0x000fe20000009400ULL,
0x000100002c417824ULL, 0x008fe200078e00ffULL, 0x000000f1e700720bULL, 0x004fcc0003fbd000ULL,
0x00000043009d7306ULL, 0x000e6e0000005400ULL, 0x00000001bfbf5812ULL, 0x010fe200078efcffULL,
0x0000004300c17306ULL, 0x0005f0000000d400ULL, 0x0000004000bd7306ULL, 0x000ee2000020d400ULL,
0x00000018ff437819ULL, 0x004fc40000011441ULL, 0x0000009d6300720bULL, 0x002fca0003f7d000ULL,
0x0000004300417306ULL, 0x000ff00000209400ULL, 0x0000004300427306ULL, 0x000e620000205400ULL,
0x00000001bdbd6812ULL, 0x008fe400078efcffULL, 0x00000001c1c13812ULL, 0x000fc400078efcffULL,
0x000000797a00720bULL, 0x000fe40003f7d000ULL, 0x000000c19191723eULL, 0x000fe200000010ffULL,
0x0000002c00cd7306ULL, 0x000ff00000009400ULL, 0x0000002c00cf7306ULL, 0x000ea20000005400ULL,
0x000000424100720bULL, 0x002fc40003fdd000ULL, 0x00000001b9b93812ULL, 0x000fe400078efcffULL,
0x000000787400720bULL, 0x000fc60003f7d000ULL, 0x0000002c00bc7306ULL, 0x0003f0000000d400ULL,
0x0000004300b67306ULL, 0x000722000020d400ULL, 0x000001002d2c7824ULL, 0x002fe200078e00ffULL,
0x000000cfcd00720bULL, 0x004fc40003f3d000ULL, 0x00000001b4b43812ULL, 0x000fe400078efcffULL,
0x00000018ff627819ULL, 0x000fe4000001142cULL, 0x0000002d00887306ULL, 0x000fe20000009400ULL,
0x000100002d437824ULL, 0x008fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000062002c7306ULL, 0x000fe20000209400ULL, 0x00000001b6b66812ULL, 0x010fe400078efcffULL,
0x00000001bcbc1812ULL, 0x000fe400078efcffULL, 0x000000726600720bULL, 0x000fc60003f3d000ULL,
0x0000006200407306ULL, 0x000e700000205400ULL, 0x0000002d00ce7306ULL, 0x000ea40000005400ULL,
0x00000001b3b31812ULL, 0x000fc400078efcffULL, 0x00000067a900720bULL, 0x000fc80003f3d000ULL,
0x0000002d00bb7306ULL, 0x000722000000d400ULL, 0x000000402c00720bULL, 0x002fce0003fdd000ULL,
0x0000006200be7306ULL, 0x000322000020d400ULL, 0x000001002e2d7824ULL, 0x008fe200078e00ffULL,
0x000000ce8800720bULL, 0x004fe40003f9d000ULL, 0x00000001a3a31812ULL, 0x000fe400078efcffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000004300f37306ULL, 0x000fe20000209400ULL,
0x00000018ff627819ULL, 0x002fcc0000011460ULL, 0x00000001bbbb4812ULL, 0x010fe200078efcffULL,
0x0000002d00737306ULL, 0x000fe20000209400ULL, 0x00000001bebe6812ULL, 0x000fce00078efcffULL,
0x0000002d00aa7306ULL, 0x000e700000205400ULL, 0x0000002d00af7306ULL, 0x000eb0000020d400ULL,
0x0000006200e47306ULL, 0x000fe20000209400ULL, 0x000000aa7300720bULL, 0x002fce0003fdd000ULL,
0x0000006200e57306ULL, 0x000e6c0000205400ULL, 0x00000001afaf6812ULL, 0x004fe400078efcffULL,
0x0000006200a77306ULL, 0x0004e2000020d400ULL, 0x000000e5e400720bULL, 0x002fe20003fdd000ULL,
0x000100002e627824ULL, 0x004fcc00078e00ffULL, 0x0000004300f77306ULL, 0x000e620000205400ULL,
0x00000018fff27819ULL, 0x000fce0000011462ULL, 0x000000f200627306ULL, 0x000fe20000209400ULL,
0x00000001a7a76812ULL, 0x008fce00078efcffULL, 0x000000f200d77306ULL, 0x000ea20000205400ULL,
0x000000f7f300720bULL, 0x002fce0003f7d000ULL, 0x0000004300b77306ULL, 0x000e70000020d400ULL,
0x0000002e00607306ULL, 0x000fe20000009400ULL, 0x000000d76200720bULL, 0x004fce0003fdd000ULL,
0x0000002e00997306ULL, 0x000ea20000005400ULL, 0x00000001b7b73812ULL, 0x002fce00078efcffULL,
0x0000002e00b07306ULL, 0x0002f0000000d400ULL, 0x0000002f002d7306ULL, 0x000fe20000009400ULL,
0x000100002f2e7824ULL, 0x002fe200078e00ffULL, 0x000000996000720bULL, 0x004fc80003f5d000ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002f00437306ULL, 0x000e6e0000005400ULL,
0x00000001b0b02812ULL, 0x008fe200078efcffULL, 0x0000002f00a87306ULL, 0x0004e2000000d400ULL,
0x000000c66800720bULL, 0x000fce0003f5d000ULL, 0x000000f200a47306ULL, 0x0008e2000020d400ULL,
0x00000100282f7824ULL, 0x004fe200078e00ffULL, 0x000000432d00720bULL, 0x002fc80003fbd000ULL,
0x00000018ffee7819ULL, 0x000fe4000001142fULL, 0x0000002e00d87306ULL, 0x000fe20000209400ULL,
0x00000018fff27819ULL, 0x010fe40000011495ULL, 0x000000019e9e2812ULL, 0x000fe400078efcffULL,
0x00000030c000720bULL, 0x000fe20003f5d000ULL, 0x000100001cc07824ULL, 0x000fe200078e00ffULL,
0x00000001a8a85812ULL, 0x008fe200078efcffULL, 0x000000ee002f7306ULL, 0x000fe20000209400ULL,
0x00000001a4a46812ULL, 0x000fc400078efcffULL, 0x00000018ffc07819ULL, 0x000fca00000114c0ULL,
0x000000ee00617306ULL, 0x000e640000205400ULL, 0x000000018f8f2812ULL, 0x000fcc00078efcffULL,
0x000000ee009c7306ULL, 0x000eb0000020d400ULL, 0x000000f200c97306ULL, 0x000fe20000209400ULL,
0x000000612f00720bULL, 0x002fce0003fdd000ULL, 0x000000f200ca7306ULL, 0x000e6c0000205400ULL,
0x000000019c9c6812ULL, 0x004fe400078efcffULL, 0x0000002e00ef7306ULL, 0x000eb00000205400ULL,
0x0000002e009f7306ULL, 0x000722000020d400ULL, 0x000000cac900720bULL, 0x002fce0003fdd000ULL,
0x0000002900637306ULL, 0x000fe20000009400ULL, 0x00010000282e7824ULL, 0x008fe200078e00ffULL,
0x000000efd800720bULL, 0x004fc80003fbd000ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000002900c47306ULL, 0x000e6e0000005400ULL, 0x000000019f9f5812ULL, 0x010fe200078efcffULL,
0x0000002900967306ULL, 0x0004f0000000d400ULL, 0x0000002800eb7306ULL, 0x000fe20000009400ULL,
0x000001002a297824ULL, 0x004fe200078e00ffULL, 0x000000c46300720bULL, 0x002fc80003f7d000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002800f07306ULL, 0x000e6e0000005400ULL,
0x0000000196963812ULL, 0x008fe200078efcffULL, 0x000000f200957306ULL, 0x0004f0000020d400ULL,
0x00000028009d7306ULL, 0x000f22000000d400ULL, 0x000000f0eb00720bULL, 0x002fc40003f9d000ULL,
0x00000018fff27819ULL, 0x004fca0000011489ULL, 0x0000002e00287306ULL, 0x000fe20000209400ULL,
0x0000000195956812ULL, 0x008fce00078efcffULL, 0x0000002e00c77306ULL, 0x000e620000205400ULL,
0x000000019d9d4812ULL, 0x010fe400078efcffULL, 0x000000311a00720bULL, 0x000fe20003f9d000ULL,
0x000100001d1a7824ULL, 0x000fc800078e00ffULL, 0x0000002e00947306ULL, 0x000ea2000020d400ULL,
0x00000018ff1a7819ULL, 0x000fce000001141aULL, 0x00000029002e7306ULL, 0x000fe20000209400ULL,
0x000000c72800720bULL, 0x002fe40003fdd000ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x0000008c1b00720bULL, 0x000fc60003f9d000ULL, 0x0000002900c27306ULL, 0x000e6c0000205400ULL,
0x0000000194946812ULL, 0x004fe400078efcffULL, 0x0000002900867306ULL, 0x0004e4000020d400ULL,
0x0000000181814812ULL, 0x000fc400078efcffULL, 0x000000948f94723eULL, 0x000fc800000010ffULL,
0x0000002a00cd7306ULL, 0x000fe20000009400ULL, 0x000100002a297824ULL, 0x004fe200078e00ffULL,
0x000000c22e00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00cf7306ULL, 0x000e6e0000005400ULL, 0x0000000186866812ULL, 0x008fe200078efcffULL,
0x0000002a00887306ULL, 0x0004f0000000d400ULL, 0x0000002900987306ULL, 0x000fe20000209400ULL,
0x000100002b2a7824ULL, 0x004fe200078e00ffULL, 0x000000cfcd00720bULL, 0x002fc80003f3d000ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002900997306ULL, 0x000fee0000205400ULL,
0x0000000188881812ULL, 0x008fe200078efcffULL, 0x0000002900837306ULL, 0x0003e2000020d400ULL,
0x0000008b2000720bULL, 0x000fc40003f3d000ULL, 0x000000888686723eULL, 0x000fca00000010ffULL,
0x000000e600cc7306ULL, 0x000fe20000209400ULL, 0x0000010024297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x000000e600ed7306ULL, 0x000e620000205400ULL,
0x0000000182821812ULL, 0x000fce00078efcffULL, 0x000000e600877306ULL, 0x000eb0000020d400ULL,
0x0000002a00f57306ULL, 0x000fe20000209400ULL, 0x000000edcc00720bULL, 0x002fce0003fdd000ULL,
0x0000002a00f67306ULL, 0x000fec0000205400ULL, 0x0000000187876812ULL, 0x004fe400078efcffULL,
0x0000002a00847306ULL, 0x0003e2000020d400ULL, 0x000000999800720bULL, 0x000fce0003fdd000ULL,
0x0000002400e67306ULL, 0x000fe20000009400ULL, 0x00010000242a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002400e77306ULL, 0x000e620000005400ULL,
0x0000000183836812ULL, 0x000fc800078efcffULL, 0x000000838188723eULL, 0x000fc600000010ffULL,
0x00000024007e7306ULL, 0x0004f0000000d400ULL, 0x000000f200c87306ULL, 0x000fe20000209400ULL,
0x0000010025247824ULL, 0x004fe200078e00ffULL, 0x000000e7e600720bULL, 0x002fc80003f5d000ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x000000f200ee7306ULL, 0x000e6e0000205400ULL,
0x000000017e7e2812ULL, 0x008fe200078efcffULL, 0x000000f200897306ULL, 0x000eb0000020d400ULL,
0x0000002900f27306ULL, 0x000fe20000209400ULL, 0x000000eec800720bULL, 0x002fce0003f7d000ULL,
0x0000002900f47306ULL, 0x000e6c0000205400ULL, 0x0000000189893812ULL, 0x004fe400078efcffULL,
0x00000029007f7306ULL, 0x0004f0000020d400ULL, 0x0000002b00607306ULL, 0x000fe20000009400ULL,
0x0001000025297824ULL, 0x004fe200078e00ffULL, 0x000000f4f200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002b00ce7306ULL, 0x000e6e0000005400ULL,
0x000000017f7f6812ULL, 0x008fe200078efcffULL, 0x0000002400427306ULL, 0x000fe60000209400ULL,
0x0000007e7f7e723eULL, 0x000fca00000010ffULL, 0x0000002400437306ULL, 0x000ea20000205400ULL,
0x000000ce6000720bULL, 0x002fce0003fbd000ULL, 0x00000025002d7306ULL, 0x000ff00000009400ULL,
0x0000002500cb7306ULL, 0x000e620000005400ULL, 0x000000434200720bULL, 0x004fce0003f3d000ULL,
0x0000002500787306ULL, 0x0004f0000000d400ULL, 0x0000002900417306ULL, 0x000fe20000209400ULL,
0x0000010026257824ULL, 0x004fe200078e00ffULL, 0x000000cb2d00720bULL, 0x002fcc0003f7d000ULL,
0x0000002900407306ULL, 0x000fee0000205400ULL, 0x0000000178783812ULL, 0x008fe200078efcffULL,
0x0000002900747306ULL, 0x0003f0000020d400ULL, 0x00000024007a7306ULL, 0x0004e2000020d400ULL,
0x0001000026297824ULL, 0x002fce00078e00ffULL, 0x0000002600aa7306ULL, 0x000fe20000009400ULL,
0x0000010027247824ULL, 0x004fca00078e00ffULL, 0x00000018fff37819ULL, 0x000fe40000011424ULL,
0x0000002600c47306ULL, 0x000e620000005400ULL, 0x000000017a7a1812ULL, 0x008fe400078efcffULL,
0x000000404100720bULL, 0x000fe40003f3d000ULL, 0x0001380064407811ULL, 0x000fe400078e20ffULL,
0x000000787a7f723eULL, 0x000fe200000010ffULL, 0x0000002600727306ULL, 0x0004e6000000d400ULL,
0x000000004040783bULL, 0x000fea0000000200ULL, 0x0000002700637306ULL, 0x000fe20000009400ULL,
0x0001000027267824ULL, 0x004fe200078e00ffULL, 0x0000000174741812ULL, 0x000fc400078efcffULL,
0x000000c4aa00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000002700a97306ULL, 0x000e700000005400ULL, 0x0000002700677306ULL, 0x000522000000d400ULL,
0x0000000172726812ULL, 0x008fce00078efcffULL, 0x0000002b008a7306ULL, 0x000ee2000000d400ULL,
0x000001001c277824ULL, 0x004fe200078e00ffULL, 0x000000a96300720bULL, 0x002fc80003f5d000ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002a00c57306ULL, 0x000fee0000209400ULL,
0x0000000167672812ULL, 0x010fe200078efcffULL, 0x0000002a00f17306ULL, 0x000e620000205400ULL,
0x000000018a8a5812ULL, 0x008fc400078efcffULL, 0x000000f6f500720bULL, 0x000fe40003fbd000ULL,
0x0000008a8787723eULL, 0x000fc600000010ffULL, 0x0000002600e47306ULL, 0x000ff00000209400ULL,
0x0000002600e57306ULL, 0x000ea20000205400ULL, 0x000000f1c500720bULL, 0x002fe40003f9d000ULL,
0x0000000184845812ULL, 0x000fc400078efcffULL, 0x0000008e9700720bULL, 0x000fe40003fbd000ULL,
0x00000002ff977819ULL, 0x000fe200000116fbULL, 0x0000002600627306ULL, 0x000e70000020d400ULL,
0x0000002700d77306ULL, 0x000fe20000209400ULL, 0x000000e5e400720bULL, 0x004fc40003f5d000ULL,
0x0000000177775812ULL, 0x000fe400078efcffULL, 0x000000226900720bULL, 0x000fc60003fbd000ULL,
0x0000002700d87306ULL, 0x000fec0000205400ULL, 0x0000000162622812ULL, 0x002fe400078efcffULL,
0x0000002700617306ULL, 0x000fe2000020d400ULL, 0x0000006f2300720bULL, 0x000fe40003f5d000ULL,
0x0000000171715812ULL, 0x000fca00078efcffULL, 0x0000001c00267306ULL, 0x000fec0000009400ULL,
0x0000000121212812ULL, 0x000fe400078efcffULL, 0x0000001c00277306ULL, 0x000ff00000005400ULL,
0x0000001c00607306ULL, 0x0003f0000000d400ULL, 0x0000002a00797306ULL, 0x0004e2000020d400ULL,
0x000001001e1c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x000000f300247306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x004fce0000011425ULL,
0x0000001c00c77306ULL, 0x000fe20000209400ULL, 0x0000000179794812ULL, 0x008fe400078efcffULL,
0x000000272600720bULL, 0x000fe20003f9d000ULL, 0x0001000044267824ULL, 0x000fe400078e00ffULL,
0x0001000045277824ULL, 0x000fe400078e00ffULL, 0x0000001c00c87306ULL, 0x000e620000205400ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x0000001c002e7306ULL, 0x0004e2000020d400ULL,
0x0000000160604812ULL, 0x000fce00078efcffULL, 0x000000f300257306ULL, 0x000f220000205400ULL,
0x000100001e1c7824ULL, 0x004fe200078e00ffULL, 0x000000c8c700720bULL, 0x002fc80003f5d000ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000002a002b7306ULL, 0x000fee0000209400ULL,
0x000000012e2e2812ULL, 0x008fe200078efcffULL, 0x0000002a002c7306ULL, 0x000e620000205400ULL,
0x000000252400720bULL, 0x010fc40003f3d000ULL, 0x0000000aff24723eULL, 0x000fe400000010ffULL,
0x000000a5e825723eULL, 0x000fc600000010ffULL, 0x0000002a00737306ULL, 0x0004f0000020d400ULL,
0x0000001c00ee7306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x004fe40000011429ULL,
0x0000002c2b00720bULL, 0x002fc40003f7d000ULL, 0x00000018ff2b7819ULL, 0x000fc60000011427ULL,
0x0000001c00ed7306ULL, 0x000e700000205400ULL, 0x0000001c00207306ULL, 0x000522000020d400ULL,
0x0000000173733812ULL, 0x008fc800078efcffULL, 0x000000727372723eULL, 0x000fc600000010ffULL,
0x0000002a00297306ULL, 0x000fe20000209400ULL, 0x00000100451c7824ULL, 0x004fe200078e00ffULL,
0x000000edee00720bULL, 0x002fc80003f5d000ULL, 0x00000018fff27819ULL, 0x000fe4000001141cULL,
0x0000002a00eb7306ULL, 0x000e6e0000205400ULL, 0x0000000120202812ULL, 0x010fe200078efcffULL,
0x0000002a00687306ULL, 0x0004e2000020d400ULL, 0x0000009b9a00720bULL, 0x000fce0003f5d000ULL,
0x000000f300667306ULL, 0x000f22000020d400ULL, 0x000001001d2a7824ULL, 0x004fe200078e00ffULL,
0x000000eb2900720bULL, 0x002fc80003fdd000ULL, 0x00000018ffef7819ULL, 0x000fe4000001142aULL,
0x0000001d002a7306ULL, 0x000fe20000009400ULL, 0x0000000111112812ULL, 0x000fcc00078efcffULL,
0x0000000168686812ULL, 0x008fe200078efcffULL, 0x0000001d00f37306ULL, 0x000e620000005400ULL,
0x0000000166661812ULL, 0x010fe400078efcffULL, 0x0000007c8000720bULL, 0x000fe40003f3d000ULL,
0x000000676673723eULL, 0x000fc600000010ffULL, 0x0000001d00307306ULL, 0x0004f0000000d400ULL,
0x000000f2008c7306ULL, 0x000fe20000209400ULL, 0x000001001f1d7824ULL, 0x004fe200078e00ffULL,
0x0000000165651812ULL, 0x000fc400078efcffULL, 0x000000d06c00720bULL, 0x000fe40003f3d000ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x000000f2008b7306ULL, 0x000fe20000205400ULL,
0x000000f32a00720bULL, 0x002fe40003f7d000ULL, 0x000000686568723eULL, 0x000fca00000010ffULL,
0x000000f2001c7306ULL, 0x000fe2000020d400ULL, 0x0000000133331812ULL, 0x000fe400078efcffULL,
0x000000d8d700720bULL, 0x000fc60003f3d000ULL, 0x0000000130303812ULL, 0x008fe400078efcffULL,
0x0000002600f27306ULL, 0x000ff00000209400ULL, 0x0000002600f17306ULL, 0x000fe20000205400ULL,
0x0000000161611812ULL, 0x000fc800078efcffULL, 0x000000606160723eULL, 0x000fc600000010ffULL,
0x00000026002c7306ULL, 0x0003f0000020d400ULL, 0x000000c000ce7306ULL, 0x000fe20000209400ULL,
0x0000541024267816ULL, 0x002fe40000000024ULL, 0x000099106a247816ULL, 0x000fc600000000ffULL,
0x00001ffa268e7589ULL, 0x000e6200000e0000ULL, 0x000000ff2400720cULL, 0x000fe20003fa5270ULL,
0x000000c000cf7306ULL, 0x000ea20000205400ULL, 0x0000010047247824ULL, 0x000fe200078e00ffULL,
0x00001f9726977589ULL, 0x000eec00000e0000ULL, 0x000000c000317306ULL, 0x000f30000020d400ULL,
0x0000001a00c97306ULL, 0x000fe20000209400ULL, 0x000000cfce00720bULL, 0x004fe20003f9d000ULL,
0x0000008e4141d231ULL, 0x002fcc00003400ffULL, 0x0000001a00ca7306ULL, 0x000e620000205400ULL,
0x0000008e4343d231ULL, 0x000fe400003400ffULL, 0x000000974040d231ULL, 0x088fe400003400ffULL,
0x000000974242d231ULL, 0x000fe200003400ffULL, 0x0000000131314812ULL, 0x010fe400078efcffULL,
0x0000001a00287306ULL, 0x000ea2000020d400ULL, 0x000000b5ab00720bULL, 0x000fc60003f9d000ULL,
0x000000924034723cULL, 0x040fe80000041834ULL, 0x0000001d00c27306ULL, 0x000fe20000209400ULL,
0x000000cac900720bULL, 0x002fe40003f7d000ULL, 0x0000010049927824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001148dULL, 0x000100004b8d7824ULL, 0x000fe200078e00ffULL,
0x000000904038723cULL, 0x000fe20000041838ULL, 0x0000000119194812ULL, 0x000fe200078efcffULL,
0x0000001d00c07306ULL, 0x000e640000205400ULL, 0x00000018ff8d7819ULL, 0x000fc6000001148dULL,
0x000000b0af90723eULL, 0x000fe400000010ffULL, 0x0000000128283812ULL, 0x004fe200078efcffULL,
0x0000001d001a7306ULL, 0x0004e2000020d400ULL, 0x000000a8a791723eULL, 0x000fce00000010ffULL,
0x0000001e00e67306ULL, 0x000fe20000009400ULL, 0x000100001f1d7824ULL, 0x004fe200078e00ffULL,
0x000000c0c200720bULL, 0x002fcc0003f9d000ULL, 0x0000001e00e77306ULL, 0x000e6e0000005400ULL,
0x000000011a1a4812ULL, 0x008fe200078efcffULL, 0x0000001e002d7306ULL, 0x0004f0000000d400ULL,
0x0000001f00cb7306ULL, 0x000fe20000009400ULL, 0x00000018ff1e7819ULL, 0x004fc4000001141dULL,
0x000000e7e600720bULL, 0x002fca0003fdd000ULL, 0x0000001f00cc7306ULL, 0x000ff00000005400ULL,
0x0000001f001b7306ULL, 0x0003e2000000d400ULL, 0x000000012d2d6812ULL, 0x008fe400078efcffULL,
0x000000a1a200720bULL, 0x000fc40003fdd000ULL, 0x0000002d2e2e723eULL, 0x000fc600000010ffULL,
0x000000ef00c67306ULL, 0x000fe20000209400ULL, 0x00000100441f7824ULL, 0x002fca00078e00ffULL,
0x00000018fff57819ULL, 0x000fe4000001141fULL, 0x000000ef00cd7306ULL, 0x000e620000205400ULL,
0x0000000118186812ULL, 0x000fc800078efcffULL, 0x000000201818723eULL, 0x000fc600000010ffULL,
0x000000ef002f7306ULL, 0x000eb0000020d400ULL, 0x0000001e00f07306ULL, 0x000fe20000209400ULL,
0x000000cdc600720bULL, 0x002fe20003f3d000ULL, 0x0001000048cd7824ULL, 0x000fc400078e00ffULL,
0x0001000049c67824ULL, 0x000fc600078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x0000001e00ef7306ULL, 0x000e620000205400ULL, 0x00000018ffc67819ULL, 0x000fca00000114c6ULL,
0x000000012f2f1812ULL, 0x004fe400078efcffULL, 0x0000001e001d7306ULL, 0x000ea2000020d400ULL,
0x000000cccb00720bULL, 0x000fe40003f3d000ULL, 0x000000302f61723eULL, 0x000fe400000010ffULL,
0x000000312130723eULL, 0x000fe400000010ffULL, 0x000000281931723eULL, 0x000fe200000010ffULL,
0x0000004400c47306ULL, 0x000fe20000009400ULL, 0x000000eff000720bULL, 0x002fca0003f9d000ULL,
0x000000011b1b1812ULL, 0x000fe400078efcffULL, 0x0000004400c57306ULL, 0x000e640000005400ULL,
0x0000001b1a2f723eULL, 0x000fc800000010ffULL, 0x000000011d1d4812ULL, 0x004fe400078efcffULL,
0x00000044001e7306ULL, 0x0004e4000000d400ULL, 0x0000001d1119723eULL, 0x000fcc00000010ffULL,
0x0000004500a97306ULL, 0x000fe20000009400ULL, 0x0000010046447824ULL, 0x004fe200078e00ffULL,
0x000000c5c400720bULL, 0x002fc80003f7d000ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004500aa7306ULL, 0x000e6e0000005400ULL, 0x000000011e1e3812ULL, 0x008fe200078efcffULL,
0x0000004500227306ULL, 0x0004e2000000d400ULL, 0x000000f1f200720bULL, 0x000fce0003f7d000ULL,
0x000000f500987306ULL, 0x000fe20000209400ULL, 0x00000018ff457819ULL, 0x004fe40000011424ULL,
0x000000a6ac24723eULL, 0x000fe400000010ffULL, 0x000000aaa900720bULL, 0x002fe40003f3d000ULL,
0x000000012c2c3812ULL, 0x000fe200078efcffULL, 0x000000f500997306ULL, 0x000e640000205400ULL,
0x00000024404c723cULL, 0x000fec000004184cULL, 0x000000f5001f7306ULL, 0x000ea4000020d400ULL,
0x0000000122221812ULL, 0x008fc400078efcffULL, 0x000000d2d300720bULL, 0x000fc80003f3d000ULL,
0x0000002b00f57306ULL, 0x000fe20000209400ULL, 0x000000999800720bULL, 0x002fce0003f5d000ULL,
0x0000002b00f47306ULL, 0x000fe20000205400ULL, 0x0000000110101812ULL, 0x000fca00078efcffULL,
0x000000011f1f2812ULL, 0x004fe400078efcffULL, 0x0000002b00277306ULL, 0x000fe2000020d400ULL,
0x000000767500720bULL, 0x000fe40003f5d000ULL, 0x0000001e1f1e723eULL, 0x000fca00000010ffULL,
0x0000004400697306ULL, 0x000fec0000209400ULL, 0x0000000117172812ULL, 0x000fe400078efcffULL,
0x00000044006a7306ULL, 0x000e640000205400ULL, 0x0000002c172c723eULL, 0x000fcc00000010ffULL,
0x00000044002b7306ULL, 0x0004f0000020d400ULL, 0x0000004500637306ULL, 0x000fe20000209400ULL,
0x000000e1ad44723eULL, 0x004fe400000010ffULL, 0x0000006a6900720bULL, 0x002fc40003f5d000ULL,
0x000000623369723eULL, 0x000fc600000010ffULL, 0x0000004500647306ULL, 0x000e700000205400ULL,
0x0000004500267306ULL, 0x000522000020d400ULL, 0x000000012b2b2812ULL, 0x008fce00078efcffULL,
0x0000004600a67306ULL, 0x000fe20000009400ULL, 0x000000e0df45723eULL, 0x004fe400000010ffULL,
0x000000646300720bULL, 0x002fca0003f3d000ULL, 0x000000444050723cULL, 0x000fe20000041850ULL,
0x0000004600a57306ULL, 0x000e6c0000005400ULL, 0x0000007ddb44723eULL, 0x000fe400000010ffULL,
0x0000007bda45723eULL, 0x000fe200000010ffULL, 0x00000046002a7306ULL, 0x0004e2000000d400ULL,
0x0000000126261812ULL, 0x010fc400078efcffULL, 0x000000dcdd00720bULL, 0x000fc60003f3d000ULL,
0x000000444054723cULL, 0x000fe20000041854ULL, 0x000000a5a600720bULL, 0x002fe20003fdd000ULL,
0x0000004700ac7306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x004fc800078e00ffULL,
0x000000d66b44723eULL, 0x000fe400000010ffULL, 0x000000d4d145723eULL, 0x000fe200000010ffULL,
0x0000004700ad7306ULL, 0x000e620000005400ULL, 0x0000000112121812ULL, 0x000fc600078efcffULL,
0x000000012a2a6812ULL, 0x008fe400078efcffULL, 0x00000044405c723cULL, 0x000fe2000004185cULL,
0x000000d5d900720bULL, 0x000fe20003fdd000ULL, 0x0000004700257306ULL, 0x0004e2000000d400ULL,
0x0000002a2b2a723eULL, 0x000fc800000010ffULL, 0x0000006d7044723eULL, 0x000fe400000010ffULL,
0x00000032b845723eULL, 0x000fe200000010ffULL, 0x00000048007c7306ULL, 0x000fe20000009400ULL,
0x0001000047477824ULL, 0x004fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe40000011446ULL,
0x000000adac00720bULL, 0x002fe40003f9d000ULL, 0x000000444058723cULL, 0x000fe20000041858ULL,
0x00000018ffd77819ULL, 0x000fe20000011447ULL, 0x0000004800807306ULL, 0x000e620000005400ULL,
0x0000000116166812ULL, 0x000fc800078efcffULL, 0x000138006e447811ULL, 0x000fc600078e20ffULL,
0x0000004800297306ULL, 0x000522000000d400ULL, 0x0000000125254812ULL, 0x008fe400078efcffULL,
0x000000004444783bULL, 0x000ee40000000200ULL, 0x00000025262b723eULL, 0x000fc600000010ffULL,
0x00000049007b7306ULL, 0x000fe20000009400ULL, 0x000000c3ba48723eULL, 0x004fe400000010ffULL,
0x00000018ffba7819ULL, 0x000fe40000011492ULL, 0x000000b6b492723eULL, 0x000fe400000010ffULL,
0x000000807c00720bULL, 0x002fe20003f7d000ULL, 0x00000049007d7306ULL, 0x000ff00000005400ULL,
0x0000004900247306ULL, 0x0003e8000000d400ULL, 0x0000000129293812ULL, 0x010fc800078efcffULL,
0x000000b800d67306ULL, 0x000fe20000209400ULL, 0x000000bfb949723eULL, 0x002fce00000010ffULL,
0x000000b800d47306ULL, 0x000e620000205400ULL, 0x000000484040723cULL, 0x000fe2000004183cULL,
0x000000974444d231ULL, 0x088fe400003400ffULL, 0x000000974646d231ULL, 0x000fe400003400ffULL,
0x0000008e4545d231ULL, 0x080fe400003400ffULL, 0x000000b8006d7306ULL, 0x0004e2000020d400ULL,
0x0000008e4747d231ULL, 0x000fe200003400ffULL, 0x00013800b2487811ULL, 0x000fc400078e20ffULL,
0x00013800b13c7811ULL, 0x000fc800078e20ffULL, 0x0000004a006b7306ULL, 0x000fe20000009400ULL,
0x000001004ab87824ULL, 0x004fe200078e00ffULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x000000904454723cULL, 0x040fe20000041854ULL, 0x000000d4d600720bULL, 0x002fe40003f5d000ULL,
0x00000018ffb87819ULL, 0x000fe400000114b8ULL, 0x0000004a006c7306ULL, 0x000e640000005400ULL,
0x000000969591723eULL, 0x000fe200000010ffULL, 0x000000864438723cULL, 0x000fe20000041838ULL,
0x000000898595723eULL, 0x000fc400000010ffULL, 0x000000848289723eULL, 0x000fe400000010ffULL,
0x0000004a00237306ULL, 0x0008a2000000d400ULL, 0x0000009d9c90723eULL, 0x000fe400000010ffULL,
0x000000944434723cULL, 0x000fe20000041834ULL, 0x000000016d6d2812ULL, 0x008fc800078efcffULL,
0x0000004b006f7306ULL, 0x000fe20000009400ULL, 0x000000bcbd4a723eULL, 0x010fe400000010ffULL,
0x000000884440723cULL, 0x040fe20000041840ULL, 0x0000006c6b00720bULL, 0x002fe40003f5d000ULL,
0x0000006d1616723eULL, 0x000fe400000010ffULL, 0x0000004b00707306ULL, 0x000fe60000005400ULL,
0x000000904458723cULL, 0x000fea0000041858ULL, 0x0000004b00327306ULL, 0x0003e2000000d400ULL,
0x0000000123232812ULL, 0x004fe200078efcffULL, 0x000000973c3cd231ULL, 0x000fc400003400ffULL,
0x000000973e3ed231ULL, 0x000fe400003400ffULL, 0x0000008e3d3dd231ULL, 0x080fe400003400ffULL,
0x0000009300c17306ULL, 0x000fe20000209400ULL, 0x000000bbbe4b723eULL, 0x002fe200000010ffULL,
0x0000008e3f3fd231ULL, 0x000fcc00003400ffULL, 0x0000004a444c723cULL, 0x000fe2000004184cULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x0000009300b97306ULL, 0x000eb00000205400ULL,
0x0000009300ab7306ULL, 0x000730000020d400ULL, 0x000000ba00b57306ULL, 0x000fe20000209400ULL,
0x000000b7b393723eULL, 0x008fc400000010ffULL, 0x000000b9c100720bULL, 0x004fca0003fdd000ULL,
0x000000924450723cULL, 0x000fe20000041850ULL, 0x000000ba00b17306ULL, 0x000eac0000205400ULL,
0x000000a4a392723eULL, 0x000fe400000010ffULL, 0x0000009f9e93723eULL, 0x000fe200000010ffULL,
0x000000d700d17306ULL, 0x000fe20000209400ULL, 0x00000001abab6812ULL, 0x010fc400078efcffULL,
0x000000f8f900720bULL, 0x000fe20003fdd000ULL, 0x000000974848d231ULL, 0x082fe400003400ffULL,
0x00000092445c723cULL, 0x000fe2000004185cULL, 0x000000974a4ad231ULL, 0x000fe200003400ffULL,
0x000000cd009e7306ULL, 0x000fe20000209400ULL, 0x0000008e4949d231ULL, 0x080fe200003400ffULL,
0x000000b1b500720bULL, 0x004fe20003f3d000ULL, 0x0000008e4b4bd231ULL, 0x000fe200003400ffULL,
0x0000008b8c00720bULL, 0x000fe40003fbd000ULL, 0x000000797744723eULL, 0x000fc400000010ffULL,
0x000000cd00927306ULL, 0x000e620000205400ULL, 0x000000747145723eULL, 0x000fe200000010ffULL,
0x000000184840723cULL, 0x040fe20000041840ULL, 0x0000000115156812ULL, 0x000fe400078efcffULL,
0x000000e3e900720bULL, 0x000fe40003fdd000ULL, 0x00000029aba6723eULL, 0x000fe200000010ffULL,
0x000000d700d07306ULL, 0x000ea20000205400ULL, 0x000000011c1c5812ULL, 0x000fe200078efcffULL,
0x000000444850723cULL, 0x000fe20000041850ULL, 0x000000f4f500720bULL, 0x000fc40003fbd000ULL,
0x000000221c1f723eULL, 0x000fc600000010ffULL, 0x000000ba00a77306ULL, 0x000ee2000020d400ULL,
0x000000929e00720bULL, 0x002fe20003f7d000ULL, 0x0000007e484c723cULL, 0x000fe2000004184cULL,
0x0000000114146812ULL, 0x000fca00078efcffULL, 0x000000cd00857306ULL, 0x000e62000020d400ULL,
0x0000000127275812ULL, 0x000fe200078efcffULL, 0x000000724854723cULL, 0x040fe20000041854ULL,
0x0000007d7b00720bULL, 0x000fe40003fbd000ULL, 0x00000027102d723eULL, 0x000fe400000010ffULL,
0x000000d0d100720bULL, 0x004fe20003f9d000ULL, 0x000000c600817306ULL, 0x000fe20000209400ULL,
0x00000001a7a71812ULL, 0x008fe200078efcffULL, 0x00000068485c723cULL, 0x040fec000004185cULL,
0x000000c600827306ULL, 0x000ea20000205400ULL, 0x0000000124245812ULL, 0x000fe200078efcffULL,
0x000000604858723cULL, 0x000fe20000041858ULL, 0x000000eaec00720bULL, 0x000fc40003fbd000ULL,
0x0000000185853812ULL, 0x002fe400078efcffULL, 0x00000024a7a7723eULL, 0x000fe200000010ffULL,
0x000000b800477306ULL, 0x000fe40000209400ULL, 0x000000304834723cULL, 0x040fec0000041834ULL,
0x000000b800447306ULL, 0x000e620000205400ULL, 0x000000828100720bULL, 0x004fe20003f3d000ULL,
0x0000002e4838723cULL, 0x000fe20000041838ULL, 0x000000010f0f5812ULL, 0x000fca00078efcffULL,
0x000000d7006e7306ULL, 0x000ea4000020d400ULL, 0x0000001e3c4c723cULL, 0x040fec000004184cULL,
0x000000c600467306ULL, 0x000ee2000020d400ULL, 0x000000444700720bULL, 0x002fe20003f7d000ULL,
0x0000002c3c50723cULL, 0x040fec0000041850ULL, 0x000000b800627306ULL, 0x000e62000020d400ULL,
0x000000016e6e4812ULL, 0x004fe200078efcffULL, 0x0000002a3c54723cULL, 0x000fe20000041854ULL,
0x000000706f00720bULL, 0x000fc40003f9d000ULL, 0x0000006e1217723eULL, 0x000fc600000010ffULL,
0x000000ae00337306ULL, 0x000fe20000209400ULL, 0x0000000146461812ULL, 0x008fe200078efcffULL,
0x000000a63c58723cULL, 0x000fe20000041858ULL, 0x000000dee200720bULL, 0x000fca0003f3d000ULL,
0x000000ae00287306ULL, 0x000ea20000205400ULL, 0x0000000162623812ULL, 0x002fe200078efcffULL,
0x000000163c5c723cULL, 0x000fe2000004185cULL, 0x0000000132324812ULL, 0x000fe400078efcffULL,
0x000000236262723eULL, 0x000fc600000010ffULL, 0x000000a000117306ULL, 0x000fe20000209400ULL,
0x000000010e0e1812ULL, 0x000fce00078efcffULL, 0x000000a000187306ULL, 0x000e620000205400ULL,
0x000000283300720bULL, 0x004fce0003fbd000ULL, 0x0000008d00107306ULL, 0x000ff00000209400ULL,
0x0000008d001b7306ULL, 0x000ea20000205400ULL, 0x000000181100720bULL, 0x002fe40003f7d000ULL,
0x000000460f11723eULL, 0x000fca00000010ffULL, 0x000000ae00637306ULL, 0x000e70000020d400ULL,
0x000000a000197306ULL, 0x000ee2000020d400ULL, 0x0000001b1000720bULL, 0x004fe40003f5d000ULL,
0x000000851510723eULL, 0x000fca00000010ffULL, 0x0000008d008d7306ULL, 0x000ea2000020d400ULL,
0x0000000163635812ULL, 0x002fe200078efcffULL, 0x000000103c34723cULL, 0x000fe60000041834ULL,
0x000000326363723eULL, 0x000fe400000010ffULL, 0x0000000119193812ULL, 0x008fc800078efcffULL,
0x000000191414723eULL, 0x000fe200000010ffULL, 0x000000623c38723cULL, 0x000fe20000041838ULL,
0x000000018d8d2812ULL, 0x004fc800078efcffULL, 0x0000008d0e15723eULL, 0x000fe400000010ffULL,
0x00000001130e7812ULL, 0x000fca000786c0ffULL, 0x000000143c3c723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c64000ffff7f8cULL, 0x000fe2000c80043fULL, 0x0000000b0c0c7207ULL, 0x000fe20005800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000dULL, 0x00000001ff0f7807ULL, 0x000fe40004000000ULL,
0x000000ff0cff7812ULL, 0x000fe4000782c0ffULL, 0x000000ff0b00720cULL, 0x000fe40003f45270ULL,
0x00000001ff0d7807ULL, 0x000fc40000800000ULL, 0x00000001ff0db807ULL, 0x000fe40001000000ULL,
0x00000c00010b7983ULL, 0x000ea20000300800ULL, 0x0000030003037a10ULL, 0x000fc80007ffe0ffULL,
0x000000050300720cULL, 0x000fe40003f26070ULL, 0x000000ff0bff7812ULL, 0x004fc8000780c0ffULL,
0x00000001ff0b7807ULL, 0x000fca0000000000ULL, 0x00000c0b01007387ULL, 0x0005e40000100600ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xfffecce000007947ULL, 0x000fea000383ffffULL,
0x00000000000f7919ULL, 0x004ea40000002500ULL, 0x000000050f00720cULL, 0x004fda0003f06070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000009027810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0009ULL, 0x00014610000b7802ULL, 0x000fe40000000f00ULL,
0x0000aee000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000900047308ULL, 0x000ea40000001000ULL,
0xbf80000004027423ULL, 0x004fc80000000009ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000077919ULL, 0x020ee40000000000ULL,
0x00000002ff057819ULL, 0x008fe40000011607ULL, 0x0000000807077811ULL, 0x000fe200078ff0ffULL,
0x0000000403047220ULL, 0x004fca0000410000ULL, 0x00001f0504057589ULL, 0x000ea800000e0000ULL,
0x00001f0704077589ULL, 0x000ee200000e0000ULL, 0x0000004c054c7220ULL, 0x044fe40000410000ULL,
0x0000004d054d7220ULL, 0x040fe40000410000ULL, 0x0000005005507220ULL, 0x040fe40000410000ULL,
0x0000005105517220ULL, 0x000fc40000410000ULL, 0x0000005405547220ULL, 0x040fe40000410000ULL,
0x0000005505557220ULL, 0x040fe40000410000ULL, 0x0000005c055c7220ULL, 0x040fe40000410000ULL,
0x0000005d055d7220ULL, 0x040fe40000410000ULL, 0x0000005805587220ULL, 0x040fe40000410000ULL,
0x0000005905597220ULL, 0x000fc40000410000ULL, 0x0000003405347220ULL, 0x040fe40000410000ULL,
0x0000003505357220ULL, 0x040fe40000410000ULL, 0x0000003805387220ULL, 0x040fe40000410000ULL,
0x0000003905397220ULL, 0x040fe40000410000ULL, 0x0000003c053c7220ULL, 0x040fe40000410000ULL,
0x0000003d053d7220ULL, 0x000fc40000410000ULL, 0x0000004e074e7220ULL, 0x048fe40000410000ULL,
0x0000004f074f7220ULL, 0x040fe40000410000ULL, 0x0000005207527220ULL, 0x040fe40000410000ULL,
0x0000005307537220ULL, 0x040fe40000410000ULL, 0x0000005607567220ULL, 0x040fe40000410000ULL,
0x0000005707577220ULL, 0x000fc40000410000ULL, 0x0000005e075e7220ULL, 0x040fe40000410000ULL,
0x0000005f075f7220ULL, 0x040fe40000410000ULL, 0x0000005a075a7220ULL, 0x040fe40000410000ULL,
0x0000005b075b7220ULL, 0x040fe40000410000ULL, 0x0000003607367220ULL, 0x040fe40000410000ULL,
0x0000003707377220ULL, 0x000fc40000410000ULL, 0x0000003a073a7220ULL, 0x040fe40000410000ULL,
0x0000003b073b7220ULL, 0x040fe40000410000ULL, 0x0000003e073e7220ULL, 0x040fe40000410000ULL,
0x0000003f073f7220ULL, 0x000fe40000410000ULL, 0x0000000000117919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000211027812ULL, 0x004fc400078ec0ffULL,
0x00000002ff107819ULL, 0x000fe40000011611ULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x0000000202047811ULL, 0x040fe400078ff8ffULL, 0x0000000402077811ULL, 0x060fe400078ff8ffULL,
0x00000006020d7811ULL, 0x000fe400078ff8ffULL, 0x0000000811187811ULL, 0x000fc400078ff0ffULL,
0x0000000703027812ULL, 0x100fe400078e7810ULL, 0x0000000704057812ULL, 0x100fe400078e7810ULL,
0x00000007070b7812ULL, 0x000fe200078e7810ULL, 0x0000000810067824ULL, 0x000fe200078e0202ULL,
0x000000070d0e7812ULL, 0x000fe200078e7810ULL, 0x0000080000027824ULL, 0x000fe200078e00ffULL,
0x0000000707077812ULL, 0x100fe200078e7818ULL, 0x00000008100a7824ULL, 0x042fe200078e0205ULL,
0x0000000703037812ULL, 0x100fe200078e7818ULL, 0x00000008100c7824ULL, 0x000fe200078e020bULL,
0x0000000704047812ULL, 0x000fe200078e7818ULL, 0x0000000810107824ULL, 0x000fe200078e020eULL,
0x000000070d0d7812ULL, 0x000fe200078e7818ULL, 0x0000000818167824ULL, 0x040fe200078e0207ULL,
0x000000505105723eULL, 0x000fe200000010ffULL, 0x00000008180e7824ULL, 0x000fe200078e0203ULL,
0x0001200002037810ULL, 0x000fe20007ffe0ffULL, 0x0000000811077824ULL, 0x000fe200078e00ffULL,
0x00000052530b723eULL, 0x000fe200000010ffULL, 0x0000000818147824ULL, 0x040fe200078e0204ULL,
0x0000004c4d04723eULL, 0x000fe200000010ffULL, 0x0000000818187824ULL, 0x000fe200078e020dULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x00005410041a7816ULL, 0x000fe20000000005ULL, 0x000000100e127824ULL, 0x000fe200078e0203ULL,
0x00007632041b7816ULL, 0x000fe20000000005ULL, 0x000000100a0a7824ULL, 0x100fe200078e0203ULL,
0x000000585904723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x100fe200078e0203ULL,
0x000000343505723eULL, 0x000fe200000010ffULL, 0x000000100c0e7824ULL, 0x000fc400078e0203ULL,
0x0000001010107824ULL, 0x100fe400078e0203ULL, 0x0000001016167824ULL, 0x100fe400078e0203ULL,
0x0000001018187824ULL, 0x000fe400078e0203ULL, 0x00000001060c7824ULL, 0x000fe200078e0207ULL,
0x000000545506723eULL, 0x000fe200000010ffULL, 0x0000000107127824ULL, 0x040fe400078e0212ULL,
0x00000001070d7824ULL, 0x040fe200078e020aULL, 0x0000001a0c007388ULL, 0x0003e20000000a00ULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x0000004e4f0a723eULL, 0x000fe200000010ffULL,
0x00000001070e7824ULL, 0x000fc400078e020eULL, 0x0000000107107824ULL, 0x040fe400078e0210ULL,
0x0000000107167824ULL, 0x040fe400078e0216ULL, 0x0000000107187824ULL, 0x000fe200078e0218ULL,
0x0000005c5d07723eULL, 0x000fe400000010ffULL, 0x00005410040c7816ULL, 0x002fe40000000005ULL,
0x00005410061a7816ULL, 0x140fe40000000007ULL, 0x00007632061b7816ULL, 0x000fc40000000007ULL,
0x000000383906723eULL, 0x000fe400000010ffULL, 0x0000003c3d07723eULL, 0x000fe200000010ffULL,
0x0000001a0d007388ULL, 0x0003e40000000a00ULL, 0x00007632040d7816ULL, 0x002fe20000000005ULL,
0x00000300ff1a7624ULL, 0x000fe200078e00ffULL, 0x000000565704723eULL, 0x000fe400000010ffULL,
0x0000005e5f05723eULL, 0x000fe200000010ffULL, 0x0000000c0e007388ULL, 0x0003e20000000a00ULL,
0x000000011a00780cULL, 0x000fc40003f05270ULL, 0x00005410060c7816ULL, 0x142fe40000000007ULL,
0x00007632060d7816ULL, 0x000fe40000000007ULL, 0x0000005a5b06723eULL, 0x000fe400000010ffULL,
0x000000363707723eULL, 0x000fe200000010ffULL, 0x0000000c10007388ULL, 0x0003e40000000a00ULL,
0x000054100a0c7816ULL, 0x142fe4000000000bULL, 0x000076320a0d7816ULL, 0x000fc4000000000bULL,
0x0000003a3b0a723eULL, 0x000fe400000010ffULL, 0x0000003e3f0b723eULL, 0x000fe200000010ffULL,
0x0000000c12007388ULL, 0x0003e40000000a00ULL, 0x00005410040c7816ULL, 0x142fe40000000005ULL,
0x00007632040d7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000c14007388ULL, 0x0003e20000000a00ULL,
0x000054100a067816ULL, 0x000fc4000000000bULL, 0x000076320a077816ULL, 0x000fe2000000000bULL,
0x0000000416007388ULL, 0x0003e80000000a00ULL, 0x0000000618007388ULL, 0x0003e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002cd000008947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x000058001a047a24ULL, 0x000fe200078e02ffULL,
0x000000ff0000720cULL, 0x000fe20003f25270ULL, 0x00002000ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000000187919ULL, 0x000ea20000002700ULL, 0x0000660004067a24ULL, 0x000fc600078e02ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x00000010050d7824ULL, 0x042fe200078e0202ULL,
0x0000002005137810ULL, 0x040fe40007ffe0ffULL, 0x0000004005157810ULL, 0x040fe40007ffe0ffULL,
0x012000000d1c7984ULL, 0x0002e20000000c00ULL, 0x0000006005177810ULL, 0x000fe20007ffe0ffULL,
0x0000580018187a24ULL, 0x004fe400078e0207ULL, 0x012200000d207984ULL, 0x0002a20000000c00ULL,
0x00001fff06077811ULL, 0x000fe200078e40ffULL, 0x0000030018047a24ULL, 0x000fc400078e02ffULL,
0x012400000d247984ULL, 0x0003220000000c00ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x00000001040c7824ULL, 0x000fe400078e020fULL, 0x012600000d287984ULL, 0x0002620000000c00ULL,
0x000000ff0000720cULL, 0x000fe40000705670ULL, 0x0000000c070a7211ULL, 0x000fca00078f98ffULL,
0x00006c000a0a7625ULL, 0x000fcc00078e000bULL, 0x00000800000a7825ULL, 0x000fcc00078e000aULL,
0x0000001013127825ULL, 0x000fc800078e000aULL, 0x0000001015147825ULL, 0x000fc800078e000aULL,
0x0000001017167825ULL, 0x000fc800078e000aULL, 0x0000001005107825ULL, 0x000fe200078e000aULL,
0x01ffffff060b7812ULL, 0x000fe200078ec0ffULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x00cea20000000000ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x000000010c0e7824ULL, 0x040fe400078e020bULL, 0x00006c000c0c7625ULL, 0x002fc800078e000fULL,
0x00006c000e0e7625ULL, 0x000fc800078e000fULL, 0x00000010060a7824ULL, 0x004fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011606ULL, 0x000000700a197812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ec0ffULL, 0x0000000c060c7210ULL, 0x140fe40007b5e019ULL,
0x0000000e060e7210ULL, 0x000fe40007d9e019ULL, 0x0000000dff0d7210ULL, 0x000fe400017e64ffULL,
0x0000000fff0f7210ULL, 0x000fc600027ea4ffULL, 0x000000080c007986ULL, 0x0003e8000c101906ULL,
0x000000090e007986ULL, 0x0003e4000c101906ULL, 0x0000001c10007986ULL, 0x00c5e2000c101d06ULL,
0x0000014000007945ULL, 0x000fe60003800000ULL, 0x0000002012007986ULL, 0x0005e8000c101d06ULL,
0x0000002414007986ULL, 0x0105e8000c101d06ULL, 0x0000002816007986ULL, 0x0025e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0xffffffff1a0d7810ULL, 0x000fc60007ffe0ffULL,
0x00006a0018087625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d080879a8ULL, 0x000ee400099ee1c6ULL,
0x0000000d0800720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff067807ULL, 0x000fca0000000000ULL, 0x00000006ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x002e640000000000ULL, 0x000000ff0600720cULL, 0x002fda0003f05270ULL,
0x0000286000008947ULL, 0x000fea0003800000ULL, 0x00000d1000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff087819ULL, 0x000fe20000011605ULL, 0x0000001005067824ULL, 0x000fe200078e00ffULL,
0x00000001040c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff197424ULL, 0x000fe200078e00ffULL,
0x0000000c080a7812ULL, 0x000fe400078ec0ffULL, 0x00000070061b7812ULL, 0x000fe200078ec0ffULL,
0x00006c0004087625ULL, 0x000fc800078e0019ULL, 0x00006c000c0c7625ULL, 0x000fe200078e0019ULL,
0x000000080a087210ULL, 0x000fc8000791e01bULL, 0x0000000c0a0c7210ULL, 0x000fe40007b5e01bULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x0000000608067981ULL, 0x000368000c1e1900ULL, 0x000000060c0f7981ULL, 0x000362000c1e1900ULL,
0x000000021a00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000204087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0019ULL,
0x000000080a087210ULL, 0x000fc8000791e01bULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x004362000c1e1900ULL, 0x000000041a00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000304087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0019ULL, 0x000000080a087210ULL, 0x000fc8000791e01bULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608137981ULL, 0x000362000c1e1900ULL,
0x000000041a00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000404087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0019ULL,
0x000000080a087210ULL, 0x000fc8000791e01bULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608157981ULL, 0x000362000c1e1900ULL, 0x000000061a00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000504087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0019ULL, 0x000000080a087210ULL, 0x000fc8000791e01bULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608177981ULL, 0x000362000c1e1900ULL,
0x000000061a00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081a00780cULL, 0x002fe40003f06070ULL, 0x0000000604087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0019ULL, 0x000000080a087210ULL, 0x000fe40007a3e01bULL,
0x00000007040c0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e0019ULL, 0x0000000608197981ULL, 0x000366000c1e1900ULL,
0x0000000c0a0c0210ULL, 0x000fc80007c7e01bULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c1b0981ULL, 0x000368000c1e1900ULL, 0x000000071a087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc80000011608ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x024fe400078e0006ULL, 0x000000080d0c7824ULL, 0x040fe200078e00ffULL,
0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x0000000a0d00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080c097810ULL, 0x040fe40007ffe0ffULL, 0x000000010c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001d06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e1d7812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e01dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090c097810ULL, 0x042fe40007ffe0ffULL,
0x000000020c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010050e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000030c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000040c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010050e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000050c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e015ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000060c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010050e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e017ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000070c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001906067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e197812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e019ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0c097810ULL, 0x002fe40007ffe0ffULL,
0x0000001b06067209ULL, 0x000fe40007810000ULL, 0x0000030009007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff0e7819ULL, 0x000fe20000011605ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700c1b7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007a3e01bULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006081b7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x0000001005087824ULL, 0x00afe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011605ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000108097824ULL, 0x000fca00078e0209ULL,
0x0000000609007388ULL, 0x0203e40000000800ULL, 0x0000000407087211ULL, 0x000fe200078f98ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00002000ff097424ULL, 0x002fe200078e00ffULL,
0x000000070500780cULL, 0x040fe20003f04070ULL, 0x0000001005067824ULL, 0x040fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011605ULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x00000015ff437819ULL, 0x000fe20000011600ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000080000417824ULL, 0x000fe200078e00ffULL,
0x0000000c0a0d7812ULL, 0x000fe200078ec0ffULL, 0x0000100000287824ULL, 0x004fe200078e00ffULL,
0x00000040050f7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000004108087210ULL, 0x000fe20007f3e0ffULL, 0x0000000106067824ULL, 0x000fe200078e020dULL,
0x00000020050d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104128824ULL, 0x000fe200078e020bULL,
0x0000006005117810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff138424ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000109097824ULL, 0x000fe200008e0643ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff158424ULL, 0x000fe200078e00ffULL,
0x0000000006267984ULL, 0x0002a20000000800ULL, 0x00006c0012128625ULL, 0x000fe200078e0013ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x000000100d0c7825ULL, 0x000fe200078e0008ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0x000000100f0e7825ULL, 0x000fc800078e0008ULL, 0x0000001011107825ULL, 0x000fc800078e0008ULL,
0x00000010001b8824ULL, 0x000fe400078e0205ULL, 0x00006c0004148625ULL, 0x000fc600078e0015ULL,
0x000045801b1b8811ULL, 0x000fe200078e20ffULL, 0x0000001005177824ULL, 0x040fe400078e0228ULL,
0x0000001005087825ULL, 0x000fc800078e0008ULL, 0x00000010001d8824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008177faeULL, 0x0007e2000b901c46ULL,
0x0000001005128825ULL, 0x000fc600078e0012ULL, 0x000041801d1d8811ULL, 0x000fe200078e20ffULL,
0x0000001005148825ULL, 0x000fe200078e0014ULL, 0x003800000c177faeULL, 0x0009e6000b901c46ULL,
0x000000ffff067224ULL, 0x002fe200078e00ffULL, 0x005800000e177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x0000000000087805ULL, 0x008fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0078000010177faeULL, 0x0007e2000b901c46ULL,
0x000000ffff367224ULL, 0x000fc600078e00ffULL, 0x00000000121b8faeULL, 0x000be2000b901c46ULL,
0x00000000000c7805ULL, 0x010fc6000001ff00ULL, 0x00000000141d8faeULL, 0x0009e2000b901c46ULL,
0x00000000000e7805ULL, 0x002fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000107805ULL, 0x008fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x020fe2000001ff00ULL, 0x0000000000147805ULL, 0x010fe2000001ff00ULL,
0x00000d5000009947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x004fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fca00078e00ffULL, 0x0000000137397810ULL, 0x000fc80007ffe0ffULL,
0x0000030039007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x0000000104387824ULL, 0x000fe200078e0239ULL, 0x000000070500780cULL, 0x000fe20003f24070ULL,
0x00002000ff1b7424ULL, 0x000fe200078e00ffULL, 0x00000001391f7812ULL, 0x040fe200078ec0ffULL,
0x00000800391c7824ULL, 0x000fe200078e00ffULL, 0x00000038071a7211ULL, 0x000fe400078f98ffULL,
0x0000002005217810ULL, 0x040fe40007ffe0ffULL, 0x000008001c1d7812ULL, 0x000fe200078ec0ffULL,
0x00006c001a1a7625ULL, 0x000fe200078e001bULL, 0x0000004005257810ULL, 0x000fc40007ffe0ffULL,
0x00000060053d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001281c7824ULL, 0x000fe200078e021dULL,
0x000000411a1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b229824ULL, 0x000fe400078e0238ULL,
0x00000080ff239424ULL, 0x000fe400078e00ffULL, 0x000000011b1b7824ULL, 0x000fe400000e0643ULL,
0x0000000200249824ULL, 0x140fe400078e021fULL, 0x00000002003a9824ULL, 0x000fc400078e021fULL,
0x00000080ff3f9424ULL, 0x000fe400078e00ffULL, 0x00000010053b7824ULL, 0x000fe400078e021cULL,
0x00000010211e7825ULL, 0x000fc800078e001aULL, 0x0000001025207825ULL, 0x000fc800078e001aULL,
0x00000010051c7825ULL, 0x000fc800078e001aULL, 0x000000103d1a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800001c3b7faeULL, 0x0003e6000b901c46ULL,
0x00006c0022229625ULL, 0x000fe200078e0023ULL, 0x003800001e3b7faeULL, 0x0003e6000b901c46ULL,
0x00000008243d9824ULL, 0x000fe200078e0205ULL, 0x00580000203b7faeULL, 0x0003e2000b901c46ULL,
0x00006c0038249625ULL, 0x000fc600078e003fULL, 0x000045803d3d9811ULL, 0x000fe200078e20ffULL,
0x000000083a3a9824ULL, 0x000fe200078e0205ULL, 0x007800001a3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001005229825ULL, 0x000fc600078e0022ULL, 0x000041803a3f9811ULL, 0x000fe200078e20ffULL,
0x0000001005249825ULL, 0x000fe200078e0024ULL, 0x00000000223d9faeULL, 0x0003e8000b901c46ULL,
0x00000000243f9faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000080371a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff1d7819ULL, 0x100fe20000011605ULL,
0x00000010051c7824ULL, 0x000fe200078e00ffULL, 0x00000002ff4e7819ULL, 0x000fc40000011605ULL,
0x000000801a1b7812ULL, 0x000fe400078ec0ffULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x000000084e1f7824ULL, 0x000fe200078e00ffULL, 0x0000000c1d1d7812ULL, 0x000fe200078ec0ffULL,
0x00000100001b7824ULL, 0x000fe200078e021bULL, 0x000000074e3a7812ULL, 0x040fe200078ec0ffULL,
0x000000084e217824ULL, 0x040fe200078e00ffULL, 0x0000004eff3c7212ULL, 0x000fe400078e33ffULL,
0x0000001b1d1c7210ULL, 0x000fe20007ffe01cULL, 0x000000084e1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1a7812ULL, 0x000fc400078ee23aULL, 0xfffffff8213c7812ULL, 0x000fe400078ee23cULL,
0x000000011b1e7812ULL, 0x000fe200078ef63aULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001c1d7984ULL, 0x000e620000000800ULL, 0x000000021b207812ULL, 0x140fe400078ef63aULL,
0x000000031b227812ULL, 0x140fe200078ef63aULL, 0x004580001c4c7984ULL, 0x0004e20000000800ULL,
0x000000041b247812ULL, 0x140fe400078ef63aULL, 0x000000051b387812ULL, 0x140fe400078ef63aULL,
0x000000061b3a7812ULL, 0x000fe200078ef63aULL, 0x00000800371b7824ULL, 0x000fe200078e00ffULL,
0x000000084e507810ULL, 0x000fe20007ffe0ffULL, 0x00000004051c7824ULL, 0x004fc400078e00ffULL,
0x000000ffff377224ULL, 0x000fe200078e0039ULL, 0x000008001b1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008501f7824ULL, 0x040fe200078e00ffULL, 0x00000050ff4a7212ULL, 0x000fe200078e33ffULL,
0x0000000850407824ULL, 0x000fe200078e00ffULL, 0x00000180281b7810ULL, 0x000fe20007ffe01bULL,
0x00000008503e7824ULL, 0x040fe200078e00ffULL, 0xfffffff81f4a7812ULL, 0x000fe400078ee24aULL,
0x00000007501f7812ULL, 0x000fe200078ec0ffULL, 0x000000101a1a7824ULL, 0x100fe200078e021bULL,
0x0000030037007a0cULL, 0x000fe20003f06070ULL, 0x000000103c3c7824ULL, 0x000fe200078e021bULL,
0x000000023e427812ULL, 0x000fe200078ef61fULL, 0x000000101e1e7824ULL, 0x000fe200078e021bULL,
0x000000033e447812ULL, 0x000fe200078ef61fULL, 0x0000001020207824ULL, 0x000fe200078e021bULL,
0x000000043e467812ULL, 0x000fe200078ef61fULL, 0x0000001022227824ULL, 0x000fe200078e021bULL,
0x000000053e487812ULL, 0x000fe200078ef61fULL, 0x0000001024247824ULL, 0x000fc400078e021bULL,
0x0000001038387824ULL, 0x100fe400078e021bULL, 0x000000103a3a7824ULL, 0x000fe400078e021bULL,
0x0000001d261d7221ULL, 0x002fe40000010100ULL, 0x0000001042427824ULL, 0x100fe400078e021bULL,
0x3fb8aa3b1d217820ULL, 0x000fe20000410000ULL, 0x0000000c1c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000001044447824ULL, 0x000fe200078e021bULL, 0xfffffff8401c7812ULL, 0x000fe200078ee21fULL,
0x0000001046467824ULL, 0x000fe200078e021bULL, 0x000000013e407812ULL, 0x000fe200078ef61fULL,
0x000000011a1a7824ULL, 0x000fe200078e021dULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x000000011d3c7824ULL, 0x040fe200078e023cULL, 0x000000063e3e7812ULL, 0x000fe200078ef61fULL,
0x000000011d1e7824ULL, 0x040fe200078e021eULL, 0x000000001a237984ULL, 0x000e620000000800ULL,
0x000000011d207824ULL, 0x000fc400078e0220ULL, 0x000000011d227824ULL, 0x040fe200078e0222ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x000000011d247824ULL, 0x040fe400078e0224ULL,
0x000000011d387824ULL, 0x040fe200078e0238ULL, 0x000000001e1e7984ULL, 0x000fe20000000800ULL,
0x000000101c1c7824ULL, 0x000fe400078e021bULL, 0x000000011d3a7824ULL, 0x000fe200078e023aULL,
0x0000000020207984ULL, 0x000fe20000000800ULL, 0x0000004c21217220ULL, 0x008fc40000410000ULL,
0x000000011d1c7824ULL, 0x040fe200078e021cULL, 0x0000000022227984ULL, 0x000fe20000000800ULL,
0x0000001040407824ULL, 0x100fe400078e021bULL, 0x0000001048487824ULL, 0x100fe200078e021bULL,
0x00001f4e211f7589ULL, 0x000ea200000e0000ULL, 0x000000103e3e7824ULL, 0x100fe400078e021bULL,
0x000000104a4a7824ULL, 0x000fe200078e021bULL, 0x0000000024247984ULL, 0x000ee20000000800ULL,
0x000000011d407824ULL, 0x000fc400078e0240ULL, 0x000000011d427824ULL, 0x040fe200078e0242ULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000011d447824ULL, 0x040fe400078e0244ULL,
0x000000011d467824ULL, 0x000fe200078e0246ULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x0000003621367221ULL, 0x000fe40000010000ULL, 0x000000011d487824ULL, 0x040fe200078e0248ULL,
0x000000001c1c7984ULL, 0x000f220000000800ULL, 0x000000011d3e7824ULL, 0x000fc400078e023eULL,
0x000000011d4a7824ULL, 0x000fe200078e024aULL, 0x00005410ff1a7816ULL, 0x102fe20000000023ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x00007610ff1b7816ULL, 0x000fc60000000023ULL,
0x0000001f1a357223ULL, 0x084fe20000010035ULL, 0x00005410ff1a7816ULL, 0x000fe2000000003cULL,
0x0000001f1b347223ULL, 0x080fe20000010034ULL, 0x00007610ff1b7816ULL, 0x000fe2000000003cULL,
0x0000000042427984ULL, 0x000fe40000000800ULL, 0x0000001f1a197223ULL, 0x080fe20000010019ULL,
0x00005410ff1a7816ULL, 0x000fe2000000001eULL, 0x0000001f1b187223ULL, 0x080fe20000010018ULL,
0x00007610ff1b7816ULL, 0x000fe2000000001eULL, 0x0000000044447984ULL, 0x000fe40000000800ULL,
0x0000001f1a337223ULL, 0x080fe20000010033ULL, 0x00005410ff1a7816ULL, 0x000fe20000000020ULL,
0x0000001f1b327223ULL, 0x080fe20000010032ULL, 0x00007610ff1b7816ULL, 0x000fe20000000020ULL,
0x00001f5021217589ULL, 0x000e6400000e0000ULL, 0x0000001f1a317223ULL, 0x080fe20000010031ULL,
0x00005410ff1a7816ULL, 0x000fe20000000022ULL, 0x0000001f1b307223ULL, 0x080fe20000010030ULL,
0x00007610ff1b7816ULL, 0x000fe20000000022ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000001f1a2f7223ULL, 0x080fe2000001002fULL, 0x00005410ff1a7816ULL, 0x008fe20000000024ULL,
0x0000001f1b2e7223ULL, 0x080fe2000001002eULL, 0x00007610ff1b7816ULL, 0x000fe20000000024ULL,
0x0000000048487984ULL, 0x000ee40000000800ULL, 0x0000001f1a2d7223ULL, 0x080fe2000001002dULL,
0x00005410ff1a7816ULL, 0x010fe20000000038ULL, 0x0000001f1b2c7223ULL, 0x080fe2000001002cULL,
0x00007610ff1b7816ULL, 0x000fe20000000038ULL, 0x000000003e3e7984ULL, 0x000f240000000800ULL,
0x0000001f1a2b7223ULL, 0x080fe2000001002bULL, 0x00005410ff1a7816ULL, 0x020fe2000000003aULL,
0x0000001f1b2a7223ULL, 0x080fe2000001002aULL, 0x00007610ff1b7816ULL, 0x000fe2000000001cULL,
0x000000004a4a7984ULL, 0x000f640000000800ULL, 0x0000001f1a297223ULL, 0x000fe20000010029ULL,
0x00007610ff1a7816ULL, 0x000fe2000000003aULL, 0x000000211b167223ULL, 0x002fe20000010016ULL,
0x00007610ff1b7816ULL, 0x000fc60000000040ULL, 0x0000001f1a277223ULL, 0x000fe20000010027ULL,
0x00005410ff1a7816ULL, 0x000fe2000000001cULL, 0x000000211b147223ULL, 0x000fe20000010014ULL,
0x00007610ff1b7816ULL, 0x000fc60000000042ULL, 0x000000211a177223ULL, 0x080fe20000010017ULL,
0x00005410ff1a7816ULL, 0x000fe20000000040ULL, 0x000000211b127223ULL, 0x000fe20000010012ULL,
0x00007610ff1b7816ULL, 0x000fc60000000044ULL, 0x000000211a157223ULL, 0x080fe20000010015ULL,
0x00005410ff1a7816ULL, 0x000fe20000000042ULL, 0x000000211b107223ULL, 0x000fe20000010010ULL,
0x00007610ff1b7816ULL, 0x004fc60000000046ULL, 0x000000211a137223ULL, 0x080fe20000010013ULL,
0x00005410ff1a7816ULL, 0x000fe20000000044ULL, 0x000000211b0e7223ULL, 0x000fe2000001000eULL,
0x00007610ff1b7816ULL, 0x008fc60000000048ULL, 0x000000211a117223ULL, 0x080fe20000010011ULL,
0x00005410ff1a7816ULL, 0x000fe20000000046ULL, 0x000000211b0c7223ULL, 0x000fe2000001000cULL,
0x00005410ff1b7816ULL, 0x010fc6000000003eULL, 0x000000211a0f7223ULL, 0x080fe2000001000fULL,
0x00005410ff1a7816ULL, 0x000fe20000000048ULL, 0x000000211b0a7223ULL, 0x000fe2000001000aULL,
0x00005410ff1b7816ULL, 0x020fc6000000004aULL, 0x000000211a0d7223ULL, 0x080fe2000001000dULL,
0x00007610ff1a7816ULL, 0x000fe2000000003eULL, 0x000000211b087223ULL, 0x000fe20000010008ULL,
0x00007610ff1b7816ULL, 0x000fc6000000004aULL, 0x000000211a097223ULL, 0x080fe40000010009ULL,
0x000000211b067223ULL, 0x000fe20000010006ULL, 0xfffff2d000008947ULL, 0x000fea000383ffffULL,
0x0180000036047810ULL, 0x004fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000004047812ULL, 0x000fc600078ec0ffULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0036ULL, 0x00017230000b7802ULL, 0x000fe40000000f00ULL,
0x000082c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003600057308ULL, 0x000e640000001000ULL,
0xbf80000005047423ULL, 0x002fc80000000036ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008073a7811ULL, 0x002fe400078ff0ffULL, 0x00000002ff0b7819ULL, 0x000fe40000011607ULL,
0x0000003aff3c7212ULL, 0x000fe200078e33ffULL, 0x00001f3a04057589ULL, 0x000e6200000e0000ULL,
0x000000083a1d7824ULL, 0x000fc400078e00ffULL, 0x000000080b1b7824ULL, 0x000fe200078e00ffULL,
0x00001f0b041a7589ULL, 0x000ea400000e0000ULL, 0xfffffff81d3c7812ULL, 0x000fca00078ee23cULL,
0x000000103c3c7824ULL, 0x000fe400078e0203ULL, 0x0000001705177220ULL, 0x042fe40000410000ULL,
0x0000001605167220ULL, 0x040fe40000410000ULL, 0x0000001505157220ULL, 0x040fe40000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000010ffULL,
0x0000001305137220ULL, 0x000fc40000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000010ffULL, 0x0000001105117220ULL, 0x040fe40000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x000000131212723eULL, 0x000fe200000010ffULL,
0x0000000f050f7220ULL, 0x040fe20000410000ULL, 0x000000073a137812ULL, 0x000fe200078ec0ffULL,
0x0000000e050e7220ULL, 0x040fe20000410000ULL, 0x000000111010723eULL, 0x000fe200000010ffULL,
0x0000000d050d7220ULL, 0x000fe20000410000ULL, 0x0000000513117812ULL, 0x000fe200078e3cffULL,
0x0000000c050c7220ULL, 0x040fe20000410000ULL, 0x0000000f0e0e723eULL, 0x000fe200000010ffULL,
0x0000000a050a7220ULL, 0x000fe20000410000ULL, 0x00000004130f7812ULL, 0x000fe200078e3cffULL,
0x0000000905097220ULL, 0x040fe20000410000ULL, 0x0000000d0c0c723eULL, 0x000fe200000010ffULL,
0x0000000805087220ULL, 0x000fc40000410000ULL, 0x0000000605057220ULL, 0x000fe20000410000ULL,
0x0000000a0909723eULL, 0x000fe200000010ffULL, 0x000000351a357220ULL, 0x044fe40000410000ULL,
0x000000341a347220ULL, 0x040fe20000410000ULL, 0x000000080505723eULL, 0x000fe200000010ffULL,
0x000000331a337220ULL, 0x040fe20000410000ULL, 0x000000070b087812ULL, 0x000fe200078ec0ffULL,
0x000000321a327220ULL, 0x000fe20000410000ULL, 0x000000353434723eULL, 0x000fe200000010ffULL,
0x000000311a317220ULL, 0x000fe20000410000ULL, 0x00000001080a7812ULL, 0x000fe200078e3cffULL,
0x000000301a307220ULL, 0x000fe20000410000ULL, 0x00000003081c7812ULL, 0x000fe200078e3cffULL,
0x0000002f1a2f7220ULL, 0x000fe20000410000ULL, 0x00000004081e7812ULL, 0x000fe200078e3cffULL,
0x0000002e1a2e7220ULL, 0x000fe20000410000ULL, 0x0000000508207812ULL, 0x000fe200078e3cffULL,
0x0000002d1a2d7220ULL, 0x000fe20000410000ULL, 0x0000000608227812ULL, 0x000fe200078e3cffULL,
0x0000002c1a2c7220ULL, 0x000fe20000410000ULL, 0x000000333232723eULL, 0x000fe200000010ffULL,
0x0000002b1a2b7220ULL, 0x000fe20000410000ULL, 0x000000313030723eULL, 0x000fe200000010ffULL,
0x0000002a1a2a7220ULL, 0x000fe20000410000ULL, 0x0000002f2e2e723eULL, 0x000fe200000010ffULL,
0x000000291a297220ULL, 0x000fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000010ffULL,
0x000000271a047220ULL, 0x000fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x000000191a197220ULL, 0x000fc40000410000ULL, 0x000000181a187220ULL, 0x000fe20000410000ULL,
0x0000000bff1a7212ULL, 0x000fe200078e33ffULL, 0x000000080b067824ULL, 0x000fe200078e00ffULL,
0x000000290404723eULL, 0x000fe200000010ffULL, 0x000000083a0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b3e7812ULL, 0x000fe200078ee21aULL, 0x0000000407157824ULL, 0x000fe200078e00ffULL,
0x00000002081a7812ULL, 0x000fe200078e3cffULL, 0x000000080b087824ULL, 0x000fe200078e020aULL,
0xfffffff806067812ULL, 0x000fe200078ee20bULL, 0x000000083a367824ULL, 0x000fe200078e020fULL,
0x0000000113077812ULL, 0x000fe200078e3cffULL, 0x000000080b0a7824ULL, 0x000fe200078e021aULL,
0x0000000c15217812ULL, 0x000fe200078ec0ffULL, 0x000000080b1a7824ULL, 0x040fe200078e021cULL,
0x000000191818723eULL, 0x000fe200000010ffULL, 0x000000080b1c7824ULL, 0x000fc400078e021eULL,
0x000000080b1e7824ULL, 0x040fe400078e0220ULL, 0x000000080b207824ULL, 0x000fe200078e0222ULL,
0xfffffff80d227812ULL, 0x000fe200078ee23aULL, 0x000000083a247824ULL, 0x040fe200078e0207ULL,
0x00000002130b7812ULL, 0x040fe200078e3cffULL, 0x000000083a387824ULL, 0x000fe200078e0211ULL,
0x00000003130d7812ULL, 0x040fe200078e3cffULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x0000000613137812ULL, 0x000fe200078e3cffULL, 0x000000083a267824ULL, 0x000fc400078e020bULL,
0x000000083a287824ULL, 0x040fe400078e020dULL, 0x000000083a3a7824ULL, 0x000fe400078e0213ULL,
0x000000103e0b7824ULL, 0x100fe400078e0203ULL, 0x0000001008087824ULL, 0x100fe400078e0203ULL,
0x000000100a0a7824ULL, 0x100fe400078e0203ULL, 0x000000101a1a7824ULL, 0x000fc400078e0203ULL,
0x0000001022227824ULL, 0x100fe400078e0203ULL, 0x0000000121077824ULL, 0x000fe400078e0206ULL,
0x000000101c1c7824ULL, 0x100fe400078e0203ULL, 0x000000101e1e7824ULL, 0x100fe200078e0203ULL,
0x0000003407007388ULL, 0x0003e20000000800ULL, 0x0000001020207824ULL, 0x100fe400078e0203ULL,
0x0000001024247824ULL, 0x000fc400078e0203ULL, 0x0000001026267824ULL, 0x100fe400078e0203ULL,
0x0000001028287824ULL, 0x100fe400078e0203ULL, 0x0000001036367824ULL, 0x100fe400078e0203ULL,
0x0000001038387824ULL, 0x100fe400078e0203ULL, 0x000000103a3a7824ULL, 0x000fe400078e0203ULL,
0x0000000121157824ULL, 0x000fc400078e020bULL, 0x0000000121037824ULL, 0x040fe400078e0208ULL,
0x00000001210b7824ULL, 0x040fe400078e020aULL, 0x00000001210d7824ULL, 0x040fe200078e021aULL,
0x0000003203007388ULL, 0x0005e20000000800ULL, 0x00000001210f7824ULL, 0x040fe400078e021cULL,
0x0000000121117824ULL, 0x040fe200078e021eULL, 0x000000300b007388ULL, 0x0005e20000000800ULL,
0x0000000121137824ULL, 0x000fc400078e0220ULL, 0x0000000121177824ULL, 0x040fe200078e0222ULL,
0x0000002e0d007388ULL, 0x0005e20000000800ULL, 0x0000000121197824ULL, 0x040fe400078e0224ULL,
0x0000000121077824ULL, 0x042fe200078e0226ULL, 0x0000002c0f007388ULL, 0x0005e20000000800ULL,
0x00000001211b7824ULL, 0x040fe400078e0228ULL, 0x00000001211d7824ULL, 0x040fe200078e0236ULL,
0x0000002a11007388ULL, 0x0005e20000000800ULL, 0x00000001211f7824ULL, 0x000fc400078e0238ULL,
0x00000001213a7824ULL, 0x040fe200078e023aULL, 0x0000000413007388ULL, 0x0005e20000000800ULL,
0x00000001213c7824ULL, 0x000fc600078e023cULL, 0x0000001815007388ULL, 0x0005e80000000800ULL,
0x0000001617007388ULL, 0x0005e80000000800ULL, 0x0000001419007388ULL, 0x0005e80000000800ULL,
0x0000001207007388ULL, 0x0005e80000000800ULL, 0x000000101b007388ULL, 0x0005e80000000800ULL,
0x0000000e1d007388ULL, 0x0005e80000000800ULL, 0x0000000c1f007388ULL, 0x0005e80000000800ULL,
0x000000093a007388ULL, 0x0005e80000000800ULL, 0x000000053c007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000167919ULL, 0x006e620000000000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000000800007824ULL, 0x000fe200078e00ffULL, 0x0000000000147919ULL, 0x000ee20000002600ULL,
0x0000000405057899ULL, 0x000fc6000800063fULL, 0x1ffffff800007812ULL, 0x000fe400078ec0ffULL,
0x0000002016157810ULL, 0x002fe20007ffe0ffULL, 0x00000004050472a4ULL, 0x004fe2000f8e023fULL,
0x00000003ff037819ULL, 0x000fe20000011616ULL, 0x0000001014047824ULL, 0x008fe200078e00ffULL,
0x0000004016177810ULL, 0x000fe20007ffe0ffULL, 0x0000001014237824ULL, 0x000fe200078e00ffULL,
0x0000006016217810ULL, 0x000fe20007ffe0ffULL, 0x0000001014257824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc40000011615ULL, 0xfffffff004047812ULL, 0x000fe400078ee203ULL,
0x00000003ff087819ULL, 0x000fe40000011617ULL, 0x00000003ff0a7819ULL, 0x000fe40000011621ULL,
0x0000000703037812ULL, 0x000fe400078e4816ULL, 0x0000000705067812ULL, 0x000fe400078e4815ULL,
0x0000000708097812ULL, 0x000fc400078e4817ULL, 0x000000070a0b7812ULL, 0x000fe400078e4821ULL,
0x0ffffff803037812ULL, 0x000fe400078ef816ULL, 0x0ffffff806077812ULL, 0x000fe400078ef815ULL,
0x0ffffff809097812ULL, 0x000fe200078ef817ULL, 0x00000010030c7824ULL, 0x100fe200078e0202ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef821ULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001009097824ULL, 0x000fe200078e0202ULL,
0xfffffff023087812ULL, 0x000fe200078ee208ULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0x012000000c0c7984ULL, 0x000e620000000c00ULL, 0x0000001014027824ULL, 0x000fe200078e00ffULL,
0xfffffff0250a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0120000007107984ULL, 0x000ea20000000c00ULL, 0x0000000700157812ULL, 0x000fc400078ef815ULL,
0xfffffff002057812ULL, 0x000fe200078ee205ULL, 0x0120000009187984ULL, 0x0007220000000c00ULL,
0x00005a0004027a11ULL, 0x000fe400078048ffULL, 0x000000040a0a7c10ULL, 0x000fe2000ff5e0ffULL,
0x012000000b1c7984ULL, 0x000b220000000c00ULL, 0x00005b0004037a11ULL, 0x000fe400000f4c03ULL,
0x0000000405057c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff097224ULL, 0x008fe200010e06ffULL,
0x0000000408077c10ULL, 0x000fc4000ff3e0ffULL, 0x00005a000a087a11ULL, 0x000fe400078448ffULL,
0x00000007000b7812ULL, 0x060fe200078ef816ULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x00005a0007067a11ULL, 0x000fe200078248ffULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x00005b0005057a11ULL, 0x000fe400000f4c16ULL, 0x0000000700177812ULL, 0x000fc400078ef817ULL,
0x00005b0007077a11ULL, 0x000fe200008f4c14ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x0000000700217812ULL, 0x000fe400078ef821ULL, 0x00005b000a097a11ULL, 0x000fe200010f4c09ULL,
0x0000001017067825ULL, 0x000fc800078e0006ULL, 0x0000001021087825ULL, 0x000fe200078e0008ULL,
0x0000000c02007986ULL, 0x002fe8000c101d06ULL, 0x0000001004007986ULL, 0x004fe8000c101d06ULL,
0x0000001806007986ULL, 0x010fe8000c101d06ULL, 0x0000001c08007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff3c7624ULL, 0x000fe200078e00ffULL,
0x03ffffff00067812ULL, 0x000fe200078ec0ffULL, 0x00006900ff3d7624ULL, 0x000fc400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0000000403397824ULL, 0x000fe200078e0206ULL,
0x000000063c3c7981ULL, 0x000368000c1e9900ULL, 0x000000043900720cULL, 0x000fe40003f06070ULL,
0x0000000103087810ULL, 0x000fd60007ffe0ffULL, 0x000000020a068824ULL, 0x000fc800078e00ffULL,
0x0000640006068a24ULL, 0x000fc800078e0239ULL, 0x0000600006068625ULL, 0x000fca00078e0019ULL,
0x0000000606388981ULL, 0x000362000c1e1900ULL, 0x000000050800720cULL, 0x000fe20003f06070ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004017177824ULL, 0x000fe400078e00ffULL,
0x00000040003a7824ULL, 0x000fd200078e00ffULL, 0x00000cc000008947ULL, 0x000fea0003800000ULL,
0x0000000000257919ULL, 0x002e620000000000ULL, 0x0000010003077824ULL, 0x000fe200078e023aULL,
0x00002000001d7811ULL, 0x000fe200078e70ffULL, 0x00000004171c7e24ULL, 0x020fe4000f8e0238ULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x0000000702067217ULL, 0x000fca0007800000ULL,
0x00000001060b7824ULL, 0x000fe200078e0a07ULL, 0x00000003ff307819ULL, 0x002fc80000011625ULL,
0x0000000430087810ULL, 0x040fe40007ffe0ffULL, 0x00000010300e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000830067810ULL, 0x000fe20007ffe0ffULL, 0x00000008081e7824ULL, 0x000fe200078e00ffULL,
0x0000000c300c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080e247824ULL, 0x000fe200078e00ffULL,
0x0000002508097212ULL, 0x080fe200078e3cffULL, 0x0000000806207824ULL, 0x000fe200078e00ffULL,
0x000000250e0d7212ULL, 0x080fe200078e3cffULL, 0x000000080c227824ULL, 0x000fe200078e00ffULL,
0x0000002506077212ULL, 0x000fc400078e3cffULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee209ULL,
0x0000001430167810ULL, 0x000fe40007ffe0ffULL, 0x000000250c097212ULL, 0x000fe400078e3cffULL,
0xfffffff824247812ULL, 0x000fe200078ee20dULL, 0x00000010250d7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x0000000816267824ULL, 0x000fe200078e00ffULL,
0x0000003f30077812ULL, 0x000fc400078ec0ffULL, 0xfffffff822227812ULL, 0x000fe400078ee209ULL,
0x0000002516097212ULL, 0x000fe200078e3cffULL, 0x000000011c077824ULL, 0x000fe200078e0207ULL,
0x000000700d297812ULL, 0x000fe400078ec0ffULL, 0x0000003f060d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff826267812ULL, 0x000fe400078ee209ULL, 0x0000003f08097812ULL, 0x000fe200078ec0ffULL,
0x000000011c0d7824ULL, 0x000fe200078e020dULL, 0x0000000b0600720cULL, 0x000fe20003fa6070ULL,
0x00005e0007067625ULL, 0x000fe200078e0027ULL, 0x0000003f0c0f7812ULL, 0x000fc400078ec0ffULL,
0x0000000b0c00720cULL, 0x000fe20003f06070ULL, 0x000000011c097824ULL, 0x000fe200078e0209ULL,
0x0000003f0e117812ULL, 0x000fe200078ec0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0027ULL,
0x0000000629107210ULL, 0x000fe40007f3e0ffULL, 0x0000000b0800720cULL, 0x080fe20003f86070ULL,
0x000000011c067824ULL, 0x000fe200078e020fULL, 0x0000000b0e00720cULL, 0x000fe20003f46070ULL,
0x00005e0009087625ULL, 0x000fe200078e0027ULL, 0x0000000c290c7210ULL, 0x000fc40007f7e0ffULL,
0x0000001830287810ULL, 0x000fe20007ffe0ffULL, 0x000000011c0e7824ULL, 0x000fe200078e0211ULL,
0x0000001c302a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0607ULL,
0x0000000829127210ULL, 0x040fe20007f3e0ffULL, 0x00005e0006067625ULL, 0x080fe200078e0027ULL,
0x0000003f2a177812ULL, 0x000fe400078ec0ffULL, 0x0000000730187812ULL, 0x000fe200078e4825ULL,
0x000000ffff0d7224ULL, 0x000fe200018e060dULL, 0x0000000629147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0609ULL, 0x0000003f16097812ULL, 0x000fe200078ec0ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e0027ULL, 0x0000000b1600720cULL, 0x000fc40003f26070ULL,
0x00000020302c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0607ULL,
0x0000003f28077812ULL, 0x000fe200078ec0ffULL, 0x000000011c067824ULL, 0x000fe200078e0209ULL,
0x0000000e290e7210ULL, 0x000fe20007fde0ffULL, 0x0000000828217824ULL, 0x000fe200078e00ffULL,
0x0ffffff8181a7812ULL, 0x000fe200078ef825ULL, 0x000000011c087824ULL, 0x000fe200078e0207ULL,
0x0000003f2c197812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0x0000000b3000720cULL, 0x000fc40003f66070ULL, 0x00000024302e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x0000000629167210ULL, 0x000fe20007fde0ffULL,
0x00005e0008087625ULL, 0x000fc800078e0027ULL, 0x000000011c067824ULL, 0x000fe400078e0217ULL,
0x000000ffff177224ULL, 0x000fe200030e0607ULL, 0x0000000829187210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fc800078e0027ULL, 0x000000011c087824ULL, 0x000fe400078e0219ULL,
0x000000101a1f7824ULL, 0x000fe400078e021dULL, 0x000000ffff197224ULL, 0x000fe200030e0609ULL,
0x00000006291a7210ULL, 0x000fe20007fde0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0027ULL,
0x0000002528067212ULL, 0x040fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0003e2000d901c46ULL, 0x0000000b2800720cULL, 0x000fe20003f66070ULL,
0x000000ffff1b7224ULL, 0x000fe200030e0607ULL, 0x0000003f2e077812ULL, 0x000fe200078ec0ffULL,
0x000000082c237824ULL, 0x000fe200078e00ffULL, 0xfffffff821287812ULL, 0x000fe200078ee206ULL,
0x000000101e217824ULL, 0x000fe200078e021dULL, 0x0000000829087210ULL, 0x000fe20007fde0ffULL,
0x000000011c077824ULL, 0x000fe200078e0207ULL, 0x000000252c1e7212ULL, 0x000fc400078e3cffULL,
0x0000000012217faeULL, 0x0005e2000e101c46ULL, 0x00005e0007067625ULL, 0x000fe200078e0027ULL,
0x0000000b2a00720cULL, 0x040fe40003f86070ULL, 0x000000252a117212ULL, 0x002fe200078e3cffULL,
0x00000010201f7824ULL, 0x000fe200078e021dULL, 0xfffffff8231e7812ULL, 0x000fe200078ee21eULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000000629107210ULL, 0x000fe20007fde0ffULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x000000000c1f7faeULL, 0x0003e2000e901c46ULL,
0x0000000b2c00720cULL, 0x000fe20003fa6070ULL, 0x0000001022137824ULL, 0x104fe200078e021dULL,
0x0000002c30127810ULL, 0x000fe20007ffe0ffULL, 0x000000101e237824ULL, 0x000fe200078e021dULL,
0xfffffff82a067812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200030e0607ULL,
0x0000000014137faeULL, 0x0005e2000c101c46ULL, 0x0000001024077824ULL, 0x100fe200078e021dULL,
0x00000030301e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001006217824ULL, 0x100fe200078e021dULL,
0x0000003830207810ULL, 0x000fe20007ffe0ffULL, 0x00000010260d7824ULL, 0x102fe200078e021dULL,
0x00000028300c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010281f7824ULL, 0x000fe200078e021dULL,
0x000000000e077faeULL, 0x0003e2000d101c46ULL, 0x0000003c30227810ULL, 0x000fc40007ffe0ffULL,
0x000000252e067212ULL, 0x000fe200078e3cffULL, 0x000000080c147824ULL, 0x004fe200078e00ffULL,
0x00000000160d7faeULL, 0x0005e2000c901c46ULL, 0x0000000b2e00720cULL, 0x080fe40003fc6070ULL,
0x0000000b2000720cULL, 0x080fe20003f26070ULL, 0x00000000181f7faeULL, 0x0007e2000d901c46ULL,
0x0000000b1e00720cULL, 0x000fe40003f66070ULL, 0x000000250c077212ULL, 0x002fe200078e3cffULL,
0x000000001a217faeULL, 0x0003e2000e101c46ULL, 0x00000034300e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff814147812ULL, 0x000fe200078ee207ULL, 0x000000082e0d7824ULL, 0x004fe200078e00ffULL,
0x0000000008237faeULL, 0x0005e2000e901c46ULL, 0x0000003f0c077812ULL, 0x000fe200078ec0ffULL,
0x0000000822177824ULL, 0x000fe200078e00ffULL, 0x0000000b0c00720cULL, 0x080fe20003fa6070ULL,
0x000000081e187824ULL, 0x008fe200078e00ffULL, 0x0000000b1200720cULL, 0x080fe20003f86070ULL,
0x000000011c077824ULL, 0x000fe200078e0207ULL, 0x0000000b0e00720cULL, 0x0c0fe20003f46070ULL,
0x000000080e1a7824ULL, 0x002fe200078e00ffULL, 0x0000000b2200720cULL, 0x000fe20003f06070ULL,
0x00000008120b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d067812ULL, 0x000fc400078ee206ULL,
0x000000251e097212ULL, 0x084fe400078e3cffULL, 0x0000002512087212ULL, 0x000fe400078e3cffULL,
0xfffffff818187812ULL, 0x000fe400078ee209ULL, 0x0000003f12097812ULL, 0x000fe400078ec0ffULL,
0xfffffff80b167812ULL, 0x000fe200078ee208ULL, 0x00000010060b7824ULL, 0x000fe200078e021dULL,
0x0000003f1e0d7812ULL, 0x000fe200078ec0ffULL, 0x00005e0007067625ULL, 0x000fe200078e0027ULL,
0x000000250e0f7212ULL, 0x000fc400078e3cffULL, 0x00000000100b7faeULL, 0x0003e2000f101c46ULL,
0x000000011c097824ULL, 0x040fe200078e0209ULL, 0x00000006290c7210ULL, 0x000fe20007fde0ffULL,
0x000000011c067824ULL, 0x000fe200078e020dULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL,
0x00005e0009087625ULL, 0x000fc800078e0027ULL, 0x000000ffff0d7224ULL, 0x000fe400030e0607ULL,
0x00005e0006067625ULL, 0x080fe200078e0027ULL, 0x0000003f0e0b7812ULL, 0x002fe400078ec0ffULL,
0x00000008290e7210ULL, 0x040fe20007fde0ffULL, 0x000000101a197824ULL, 0x000fe200078e021dULL,
0x0000003f20117812ULL, 0x000fe200078ec0ffULL, 0x000000011c087824ULL, 0x000fe200078e020bULL,
0x0000003f220b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e0609ULL,
0x0000000629107210ULL, 0x000fe20007fde0ffULL, 0x00005e0008087625ULL, 0x000fc800078e0027ULL,
0x000000011c067824ULL, 0x000fe400078e0211ULL, 0x000000ffff117224ULL, 0x000fe200030e0607ULL,
0x0000000829127210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0x0000002522087212ULL, 0x000fc600078e3cffULL, 0x000000011c157824ULL, 0x000fe200078e020bULL,
0xfffffff8171e7812ULL, 0x000fe200078ee208ULL, 0x000000ffff137224ULL, 0x000fe200030e0609ULL,
0x0000000629067210ULL, 0x000fe20007fde0ffULL, 0x00000008201c7824ULL, 0x040fe200078e00ffULL,
0x00000025200b7212ULL, 0x000fe200078e3cffULL, 0x00005e0015087625ULL, 0x000fc600078e0027ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000000829087210ULL, 0x000fe20007fde0ffULL, 0x00000010140b7824ULL, 0x100fe400078e021dULL,
0x0000001016157824ULL, 0x100fe400078e021dULL, 0x0000001018177824ULL, 0x100fe200078e021dULL,
0x000000000c0b7faeULL, 0x0003e2000e901c46ULL, 0x000000101c1b7824ULL, 0x100fe400078e021dULL,
0x000000101e1d7824ULL, 0x000fe200078e021dULL, 0x000000000e157faeULL, 0x0003e2000e101c46ULL,
0x000000ffff097224ULL, 0x000fc600030e0609ULL, 0x0000000010177faeULL, 0x0003e8000d901c46ULL,
0x0000000012197faeULL, 0x0003e8000d101c46ULL, 0x00000000061b7faeULL, 0x0003e8000c901c46ULL,
0x00000000081d7faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000417177e24ULL, 0x020fc4000f8e0238ULL,
0x00000100ff267424ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x002fc80000011606ULL,
0x00000004070f7810ULL, 0x040fe40007ffe0ffULL, 0x00000018071b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c07137810ULL, 0x000fe20007ffe0ffULL, 0x000000080f0b7824ULL, 0x040fe200078e00ffULL,
0x000000060f087212ULL, 0x080fe200078e3cffULL, 0x000000081b1d7824ULL, 0x040fe200078e00ffULL,
0x000000061b0c7212ULL, 0x000fe200078e3cffULL, 0x00000008130d7824ULL, 0x000fe200078e00ffULL,
0x0000002807237810ULL, 0x000fc40007ffe0ffULL, 0x0000000807117810ULL, 0x040fe40007ffe0ffULL,
0x0000001407197810ULL, 0x000fe20007ffe0ffULL, 0x0000000823257824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL, 0x0000000811127824ULL, 0x000fe200078e00ffULL,
0xfffffff81d227812ULL, 0x000fe200078ee20cULL, 0x00000008191e7824ULL, 0x000fe200078e00ffULL,
0x0000000613087212ULL, 0x000fe400078e3cffULL, 0x0000001c071d7810ULL, 0x000fc40007ffe0ffULL,
0x00000006230c7212ULL, 0x080fe400078e3cffULL, 0x0000001007157810ULL, 0x040fe40007ffe0ffULL,
0x0000002407217810ULL, 0x000fe40007ffe0ffULL, 0x0000000611097212ULL, 0x080fe200078e3cffULL,
0x00000008151a7824ULL, 0x000fe200078e00ffULL, 0x00000006190b7212ULL, 0x000fe200078e3cffULL,
0x0000000821307824ULL, 0x000fe200078e00ffULL, 0xfffffff80d167812ULL, 0x000fe200078ee208ULL,
0x000000081d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff825347812ULL, 0x000fc400078ee20cULL,
0x000000061d087212ULL, 0x000fe400078e3cffULL, 0x0000002c07257810ULL, 0x040fe40007ffe0ffULL,
0xfffffff812127812ULL, 0x000fe400078ee209ULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee20bULL,
0x00000020071f7810ULL, 0x040fe40007ffe0ffULL, 0x0000003407297810ULL, 0x000fc40007ffe0ffULL,
0x0000000615097212ULL, 0x080fe200078e3cffULL, 0x000000081f2c7824ULL, 0x000fe200078e00ffULL,
0x00000006210b7212ULL, 0x080fe200078e3cffULL, 0x0000000829467824ULL, 0x000fe200078e00ffULL,
0x00000038072b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80d287812ULL, 0x000fe200078ee208ULL,
0x00000008250d7824ULL, 0x040fe200078e00ffULL, 0x0000000625087212ULL, 0x000fe200078e3cffULL,
0x000000082b2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fc400078ee209ULL,
0xfffffff830307812ULL, 0x000fe400078ee20bULL, 0x0000003007277810ULL, 0x000fe40007ffe0ffULL,
0x000000061f097212ULL, 0x080fe400078e3cffULL, 0x00000006290b7212ULL, 0x080fe200078e3cffULL,
0x0000000827427824ULL, 0x000fe200078e00ffULL, 0x000000062b0c7212ULL, 0x000fe400078e3cffULL,
0xfffffff80d3e7812ULL, 0x000fc400078ee208ULL, 0x0000003f07087812ULL, 0x000fe400078ec0ffULL,
0xfffffff82c2c7812ULL, 0x000fe400078ee209ULL, 0xfffffff846467812ULL, 0x000fe400078ee20bULL,
0x0000000627097212ULL, 0x000fe400078e3cffULL, 0xfffffff82d4a7812ULL, 0x000fe400078ee20cULL,
0x00000007070b7812ULL, 0x000fc400078e4806ULL, 0x0000003c072d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000117077824ULL, 0x000fe200078e0208ULL, 0xfffffff842427812ULL, 0x000fe200078ee209ULL,
0x0000001006097824ULL, 0x000fe200078e00ffULL, 0x0ffffff80b087812ULL, 0x000fe200078ef806ULL,
0x000000082d4c7824ULL, 0x040fe200078e00ffULL, 0x000000062d0b7212ULL, 0x000fe400078e3cffULL,
0x0000003f0f0c7812ULL, 0x000fe400078ec0ffULL, 0x0000003f2d067812ULL, 0x000fc400078ec0ffULL,
0x00002000000d7811ULL, 0x000fe200078e70ffULL, 0x00000001170f7824ULL, 0x040fe200078e020cULL,
0xfffffff84c0c7812ULL, 0x000fe200078ee20bULL, 0x00000001174d7824ULL, 0x000fe200078e0206ULL,
0x00000070090b7812ULL, 0x000fe200078ec0ffULL, 0x00005e0007067625ULL, 0x000fe200078e0026ULL,
0x0000003f11107812ULL, 0x000fe400078ec0ffULL, 0x0000003f15187812ULL, 0x000fe200078ec0ffULL,
0x00000010122d7824ULL, 0x100fe200078e020dULL, 0x0000003f29447812ULL, 0x000fe200078ec0ffULL,
0x0000001008297824ULL, 0x000fe200078e020dULL, 0x000000060b067210ULL, 0x000fe20007f1e0ffULL,
0x00005e000f087625ULL, 0x000fe200078e0026ULL, 0x0000003f13147812ULL, 0x000fc400078ec0ffULL,
0x0000003f1b207812ULL, 0x000fe200078ec0ffULL, 0x0000000117117824ULL, 0x000fe200078e0210ULL,
0x0000003f2b487812ULL, 0x000fe200078ec0ffULL, 0x0000000117157824ULL, 0x000fe200078e0218ULL,
0x0000003f191c7812ULL, 0x000fe200078ec0ffULL, 0x000000100e2b7824ULL, 0x100fe200078e020dULL,
0x0000003f1f2a7812ULL, 0x000fe200078ec0ffULL, 0x00000010162f7824ULL, 0x100fe200078e020dULL,
0x0000003f1d247812ULL, 0x000fe200078ec0ffULL, 0x000000101a317824ULL, 0x100fe200078e020dULL,
0x0000003f212e7812ULL, 0x000fe200078ec0ffULL, 0x000000101e337824ULL, 0x100fe200078e020dULL,
0x0000003f23327812ULL, 0x000fe200078ec0ffULL, 0x0000001022357824ULL, 0x100fe200078e020dULL,
0x0000003f25367812ULL, 0x000fe200078ec0ffULL, 0x0000001028377824ULL, 0x100fe200078e020dULL,
0x0000003f27407812ULL, 0x000fe200078ec0ffULL, 0x000000102c3b7824ULL, 0x000fc400078e020dULL,
0x00000010303d7824ULL, 0x100fe400078e020dULL, 0x00000010343f7824ULL, 0x100fe400078e020dULL,
0x000000103e417824ULL, 0x100fe400078e020dULL, 0x0000001042437824ULL, 0x100fe400078e020dULL,
0x0000001046477824ULL, 0x100fe400078e020dULL, 0x000000104a4b7824ULL, 0x000fc400078e020dULL,
0x000000100c4f7824ULL, 0x000fe400078e020dULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x000000080b087210ULL, 0x000fe20007f1e0ffULL, 0x00005e00110c7625ULL, 0x000fc600078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006297faeULL, 0x0003e2000b901c46ULL,
0x00005e0015107625ULL, 0x000fe200078e0026ULL, 0x0000000c0b0c7210ULL, 0x000fc60007f3e0ffULL,
0x0000000117137824ULL, 0x040fe400078e0214ULL, 0x00000001171b7824ULL, 0x040fe400078e0220ULL,
0x0000000117197824ULL, 0x000fe400078e021cULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x000000100b107210ULL, 0x000fe20007f1e0ffULL, 0x00005e00130e7625ULL, 0x000fc600078e0026ULL,
0x00000000082b7faeULL, 0x0003e2000b901c46ULL, 0x00005e001b147625ULL, 0x000fe200078e0026ULL,
0x0000000e0b0e7210ULL, 0x000fc60007f5e0ffULL, 0x00005e0019127625ULL, 0x000fc800078e0026ULL,
0x00000001171f7824ULL, 0x040fe400078e022aULL, 0x00000001171d7824ULL, 0x000fe400078e0224ULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x000000140b147210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000120b127210ULL, 0x000fe20007f3e0ffULL,
0x0000000117217824ULL, 0x040fe400078e022eULL, 0x0000000117237824ULL, 0x040fe200078e0232ULL,
0x000000000c2d7faeULL, 0x0003e2000b901c46ULL, 0x0000000117257824ULL, 0x000fc400078e0236ULL,
0x0000000117277824ULL, 0x040fe400078e0240ULL, 0x0000000117457824ULL, 0x040fe400078e0244ULL,
0x0000000117497824ULL, 0x000fe400078e0248ULL, 0x00005e001f187625ULL, 0x000fc800078e0026ULL,
0x00005e001d167625ULL, 0x000fc800078e0026ULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x000000180b187210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x000000160b167210ULL, 0x000fe20007f3e0ffULL, 0x00005e00251e7625ULL, 0x000fc800078e0026ULL,
0x00005e00211a7625ULL, 0x000fc800078e0026ULL, 0x00005e00231c7625ULL, 0x000fc800078e0026ULL,
0x000000ffff197224ULL, 0x000fe200000e0619ULL, 0x0000001e0b1e7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x0000001a0b1a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000001c0b1c7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0027207625ULL, 0x000fc600078e0026ULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0045227625ULL, 0x000fc600078e0026ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x00005e0049247625ULL, 0x000fc600078e0026ULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x00005e004d267625ULL, 0x000fc600078e0026ULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x000000200b207210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e061bULL, 0x000000220b227210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e061dULL, 0x000000240b247210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0x000000260b267210ULL, 0x000fe20007f7e0ffULL,
0x0000000016377faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc400008e0623ULL,
0x000000ffff257224ULL, 0x000fe200010e0625ULL, 0x00000000183b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff277224ULL, 0x000fc600018e0627ULL, 0x000000001a3d7faeULL, 0x0003e8000b901c46ULL,
0x000000001c3f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e417faeULL, 0x0003e8000b901c46ULL,
0x0000000020437faeULL, 0x0003e8000b901c46ULL, 0x0000000022477faeULL, 0x0003e8000b901c46ULL,
0x00000000244b7faeULL, 0x0003e8000b901c46ULL, 0x00000000264f7faeULL, 0x0003e4000b901c46ULL,
0x01c60400ff067984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000006ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x01c60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000030000780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e640000000000ULL,
0x0000002000067824ULL, 0x002fc800078e0207ULL, 0x0000002006087824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc80000011606ULL, 0x1ffffffe07077812ULL, 0x000fe400078ec0ffULL,
0x000001e008087812ULL, 0x000fe400078ec0ffULL, 0x00000001070b7812ULL, 0x040fe400078efcffULL,
0x0000000707097812ULL, 0x100fe400078e7806ULL, 0x000000070b0b7812ULL, 0x100fe400078e7806ULL,
0x0000001007157810ULL, 0x040fe20007ffe0ffULL, 0x0000000108097824ULL, 0x040fe200078e0209ULL,
0x0000001107077810ULL, 0x000fe20007ffe0ffULL, 0x00000001080b7824ULL, 0x000fe200078e020bULL,
0x0000000715157812ULL, 0x000fc400078e7806ULL, 0x0000000009107984ULL, 0x000e62000000cc00ULL,
0x0000000707077812ULL, 0x000fe400078e7806ULL, 0x0000000108157824ULL, 0x040fe200078e0215ULL,
0x000000000b0c7984ULL, 0x000ea4000000cc00ULL, 0x0000000108077824ULL, 0x000fe400078e0207ULL,
0x000000ffff187224ULL, 0x002fe400078e0010ULL, 0x000000ffff197224ULL, 0x000fc400078e0012ULL,
0x000000ffff1a7224ULL, 0x004fe400078e000cULL, 0x000000ffff1b7224ULL, 0x000fe400078e000eULL,
0x000000ffff1c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0013ULL,
0x0000001809007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1f7224ULL, 0x000fca00078e000fULL, 0x0000001c0b007388ULL, 0x000fe8000000cc00ULL,
0x00000000070c7984ULL, 0x000e68000000cc00ULL, 0x0000000015107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff237224ULL, 0x002fe400078e000eULL, 0x000000ffff227224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff207224ULL, 0x004fe400078e0010ULL,
0x000000ffff217224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002015007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01c60400ff067984ULL, 0x000ea40000000800ULL,
0x8000000006ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0022a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x01c60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000050300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003b7919ULL, 0x000ea20000000000ULL,
0x00005800ff437624ULL, 0x000fe200078e00ffULL, 0xffffffff05407810ULL, 0x000fe20007ffe0ffULL,
0x3d8000003c3c7820ULL, 0x000fe20000410000ULL, 0x00007610ff417816ULL, 0x000fe20000000041ULL,
0x000064000a3e7a24ULL, 0x000fe400078e02ffULL, 0x00000010003d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe400078e00ffULL, 0x0000004043437824ULL, 0x000fc400078e00ffULL,
0x0000010003457824ULL, 0x000fe200078e023aULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000450200720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e003fULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x002fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x0000000142077810ULL, 0x000fe20007ffe0ffULL, 0x000016f000007945ULL, 0x000fe20003800000ULL,
0x00000001473f7812ULL, 0x000fc400078e0cffULL, 0x00000001ff067819ULL, 0x000fe40000011607ULL,
0x000000020700780cULL, 0x040fe40003f06070ULL, 0x0000000107567812ULL, 0x000fe200078ec0ffULL,
0x0000030006297a24ULL, 0x000fca00078e0203ULL, 0x0000000129067810ULL, 0x000fc80007ffe0ffULL,
0x000000050600720cULL, 0x000fe20003f26070ULL, 0x000000ffff067224ULL, 0x000fe400078e0042ULL,
0x000000ffff427224ULL, 0x000fd400078e0007ULL, 0x00000bc000009947ULL, 0x020fea0003800000ULL,
0x00000003ff347819ULL, 0x004fe2000001163bULL, 0x0000010029077824ULL, 0x000fc600078e023aULL,
0x00000004342a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000702287217ULL, 0x000fe40007800000ULL,
0x0000003b2a297212ULL, 0x040fe200078e3cffULL, 0x000000082a2e7824ULL, 0x000fe200078e00ffULL,
0x00000008342c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000128077824ULL, 0x000fe200078e0a07ULL,
0x0000001034307810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82e337812ULL, 0x000fe200078ee229ULL,
0x000000082c377824ULL, 0x000fe200078e00ffULL, 0x0000000c342e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000830367824ULL, 0x000fe200078e00ffULL, 0x0000001834487810ULL, 0x000fc40007ffe0ffULL,
0x0000001434467810ULL, 0x000fe20007ffe0ffULL, 0x000000082e327824ULL, 0x000fe200078e00ffULL,
0x0000003b2c287212ULL, 0x080fe200078e3cffULL, 0x0000000848537824ULL, 0x000fe200078e00ffULL,
0x0000003b2e297212ULL, 0x080fe200078e3cffULL, 0x0000000846447824ULL, 0x000fe200078e00ffULL,
0x0000001c344a7810ULL, 0x000fe40007ffe0ffULL, 0x0000003b302b7212ULL, 0x000fe400078e3cffULL,
0x00000020344c7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff837377812ULL, 0x000fe400078ee228ULL,
0xfffffff832497812ULL, 0x000fe200078ee229ULL, 0x000000084a327824ULL, 0x000fe200078e00ffULL,
0x0000003b48287212ULL, 0x080fe400078e3cffULL, 0x0000003b462d7212ULL, 0x000fe400078e3cffULL,
0xfffffff8364d7812ULL, 0x000fe200078ee22bULL, 0x000000084c367824ULL, 0x000fe200078e00ffULL,
0x00000024344e7810ULL, 0x000fc40007ffe0ffULL, 0x0000003b4a297212ULL, 0x080fe400078e3cffULL,
0x0000003b4c2b7212ULL, 0x080fe400078e3cffULL, 0xfffffff853537812ULL, 0x000fe200078ee228ULL,
0x0000000856287824ULL, 0x000fe200078e00ffULL, 0xfffffff844517812ULL, 0x000fe200078ee22dULL,
0x000000084e447824ULL, 0x000fe200078e00ffULL, 0xfffffff832557812ULL, 0x000fe200078ee229ULL,
0x0000000200327824ULL, 0x000fe200078e023fULL, 0x0000003b4e2d7212ULL, 0x000fc400078e3cffULL,
0xfffffff836597812ULL, 0x000fe200078ee22bULL, 0x0000000443367e24ULL, 0x000fe2000f8e0238ULL,
0x0000003f34297812ULL, 0x000fe400078ec0ffULL, 0xfffffff828357812ULL, 0x000fe400078ee23bULL,
0xfffffff8445b7812ULL, 0x000fe200078ee22dULL, 0x00000100ff447424ULL, 0x000fe200078e00ffULL,
0x0000000734287812ULL, 0x000fe200078e483bULL, 0x0000000136297824ULL, 0x000fe200078e0229ULL,
0x0000002834507810ULL, 0x000fc40007ffe0ffULL, 0x000000073400720cULL, 0x040fe40003f26070ULL,
0x0000002c34527810ULL, 0x000fe20007ffe0ffULL, 0x00000008505a7824ULL, 0x000fe200078e00ffULL,
0x0ffffff8282b7812ULL, 0x000fe200078ef83bULL, 0x00005e0029287625ULL, 0x000fe200078e0044ULL,
0x0000003034547810ULL, 0x000fe40007ffe0ffULL, 0x0000200032327811ULL, 0x000fe200078e68ffULL,
0x00000008525c7824ULL, 0x000fe200078e00ffULL, 0x0000003434587810ULL, 0x000fe20007ffe0ffULL,
0x00000008545e7824ULL, 0x000fe200078e00ffULL, 0x0000003b502d7212ULL, 0x080fe200078e3cffULL,
0x000000102b2b7824ULL, 0x000fe200078e0232ULL, 0x0000003b522f7212ULL, 0x080fe200078e3cffULL,
0x0000000858607824ULL, 0x000fe200078e00ffULL, 0x0000003b54317212ULL, 0x000fe200078e3cffULL,
0x0000001035287825ULL, 0x000fe200078e0028ULL, 0xfffffff85a5d7812ULL, 0x000fc400078ee22dULL,
0x0000003b584b7212ULL, 0x000fe200078e3cffULL, 0x0000001033337824ULL, 0x100fe200078e0232ULL,
0x0000003f2a2d7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e2000c901c46ULL, 0xfffffff85c5f7812ULL, 0x000fe200078ee22fULL,
0x0000001037377824ULL, 0x100fe200078e0232ULL, 0xfffffff85e617812ULL, 0x000fe200078ee231ULL,
0x0000001049497824ULL, 0x000fe200078e0232ULL, 0x0000003f2c2f7812ULL, 0x000fe400078ec0ffULL,
0xfffffff860637812ULL, 0x000fc400078ee24bULL, 0x0000003f2e317812ULL, 0x000fe400078ec0ffULL,
0x0000003f304b7812ULL, 0x000fe200078ec0ffULL, 0x0000000136297824ULL, 0x002fe200078e022dULL,
0x000000072a00720cULL, 0x080fe20003f26070ULL, 0x00000001362b7824ULL, 0x000fe200078e022fULL,
0x000000072c00720cULL, 0x080fe20003f46070ULL, 0x00000001362d7824ULL, 0x000fe200078e0231ULL,
0x000000072e00720cULL, 0x080fe20003f66070ULL, 0x00005e0029287625ULL, 0x000fe200078e0044ULL,
0x000000073000720cULL, 0x000fc40003f86070ULL, 0x0000003f464f7812ULL, 0x000fe200078ec0ffULL,
0x00000001362f7824ULL, 0x000fe200078e024bULL, 0x000000074600720cULL, 0x000fe20003fa6070ULL,
0x00005e002b2a7625ULL, 0x080fe200078e0044ULL, 0x0000003f4c577812ULL, 0x000fe400078ec0ffULL,
0x0000003c34467810ULL, 0x000fe20007ffe0ffULL, 0x00005e002d2c7625ULL, 0x000fc600078e0044ULL,
0x000000074600720cULL, 0x000fe20003fc6070ULL, 0x00005e002f2e7625ULL, 0x000fc800078e0044ULL,
0x0000001035287825ULL, 0x000fc800078e0028ULL, 0x0000000136317824ULL, 0x000fe200078e024fULL,
0x0000003f484f7812ULL, 0x000fe200078ec0ffULL, 0x000000104d4b7824ULL, 0x100fe200078e0232ULL,
0x0000000028337faeULL, 0x0003e2000c901c46ULL, 0x00000010514d7824ULL, 0x000fe200078e0232ULL,
0x0000003f4a517812ULL, 0x000fe200078ec0ffULL, 0x00000010352a7825ULL, 0x000fe200078e002aULL,
0x000000074800720cULL, 0x000fc60003f26070ULL, 0x00000010352c7825ULL, 0x040fe200078e002cULL,
0x000000002a377faeULL, 0x0005e2000d101c46ULL, 0x000000074a00720cULL, 0x080fe40003f46070ULL,
0x00000010352e7825ULL, 0x000fe200078e002eULL, 0x0000003f4e337812ULL, 0x002fe200078ec0ffULL,
0x000000002c497faeULL, 0x0003e2000d901c46ULL, 0x000000074c00720cULL, 0x080fe20003f66070ULL,
0x00005e0031307625ULL, 0x000fe400078e0044ULL, 0x000000002e4b7faeULL, 0x0007e2000e101c46ULL,
0x000000074e00720cULL, 0x000fe20003f86070ULL, 0x0000000136297824ULL, 0x000fc400078e024fULL,
0x00000001362b7824ULL, 0x004fe400078e0251ULL, 0x0000001035307825ULL, 0x000fc800078e0030ULL,
0x00000001362d7824ULL, 0x042fe200078e0257ULL, 0x00000000304d7faeULL, 0x0003e2000e901c46ULL,
0x00000001362f7824ULL, 0x008fe400078e0233ULL, 0x00005e0029287625ULL, 0x000fc800078e0044ULL,
0x00005e002b2a7625ULL, 0x000fc800078e0044ULL, 0x00005e002d2c7625ULL, 0x000fe200078e0044ULL,
0x0000003834307810ULL, 0x002fc60007ffe0ffULL, 0x00005e002f2e7625ULL, 0x000fe200078e0044ULL,
0x000000073000720cULL, 0x040fe40003fa6070ULL, 0x0000003b30347212ULL, 0x000fe200078e3cffULL,
0x0000001053317824ULL, 0x000fe400078e0232ULL, 0x0000001035287825ULL, 0x000fc800078e0028ULL,
0x0000001055337824ULL, 0x000fe200078e0232ULL, 0x0000000028317faeULL, 0x0003e2000c901c46ULL,
0x00000010352a7825ULL, 0x000fe200078e002aULL, 0x000000075000720cULL, 0x000fc60003f26070ULL,
0x0000001059377824ULL, 0x000fe200078e0232ULL, 0x000000002a337faeULL, 0x0005e2000d101c46ULL,
0x00000010352c7825ULL, 0x000fe200078e002cULL, 0x000000075200720cULL, 0x000fc60003f46070ULL,
0x000000105b497824ULL, 0x000fe200078e0232ULL, 0x000000002c377faeULL, 0x0007e2000d901c46ULL,
0x00000010352e7825ULL, 0x000fe200078e002eULL, 0x000000075400720cULL, 0x080fe40003f66070ULL,
0x0000003f30317812ULL, 0x042fe200078ec0ffULL, 0x00000008304d7824ULL, 0x000fe200078e00ffULL,
0x000000002e497faeULL, 0x0003e2000e101c46ULL, 0x000000075800720cULL, 0x000fe20003f86070ULL,
0x00000008464f7824ULL, 0x000fe200078e00ffULL, 0x0000003f50077812ULL, 0x000fe200078ec0ffULL,
0x0000000136317824ULL, 0x000fe200078e0231ULL, 0x0000003f522b7812ULL, 0x004fe200078ec0ffULL,
0x000000105f377824ULL, 0x008fe200078e0232ULL, 0x0000003f542d7812ULL, 0x000fe200078ec0ffULL,
0x0000000136297824ULL, 0x000fe200078e0207ULL, 0x0000003b46287212ULL, 0x000fe200078e3cffULL,
0x00000001362b7824ULL, 0x000fe200078e022bULL, 0x0000003f46337812ULL, 0x000fe200078ec0ffULL,
0x00000001362d7824ULL, 0x000fe200078e022dULL, 0x0000003f582f7812ULL, 0x002fe200078ec0ffULL,
0x00005e002b2a7625ULL, 0x000fe200078e0044ULL, 0xfffffff84d4d7812ULL, 0x000fc400078ee234ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee228ULL, 0x00000001362f7824ULL, 0x000fe400078e022fULL,
0x00005e0029287625ULL, 0x000fc800078e0044ULL, 0x0000000136337824ULL, 0x000fe400078e0233ULL,
0x00005e002d2c7625ULL, 0x000fc800078e0044ULL, 0x00005e002f2e7625ULL, 0x000fc800078e0044ULL,
0x000000105d077824ULL, 0x100fe400078e0232ULL, 0x0000001061497824ULL, 0x100fe400078e0232ULL,
0x00000010634b7824ULL, 0x100fe400078e0232ULL, 0x000000104d4d7824ULL, 0x100fe400078e0232ULL,
0x000000104f4f7824ULL, 0x000fe400078e0232ULL, 0x00005e0031307625ULL, 0x000fc800078e0044ULL,
0x00005e0033327625ULL, 0x000fc800078e0044ULL, 0x0000001035287825ULL, 0x000fc800078e0028ULL,
0x00000010352a7825ULL, 0x040fe200078e002aULL, 0x0000000028077faeULL, 0x0003e6000c901c46ULL,
0x00000010352c7825ULL, 0x040fe200078e002cULL, 0x000000002a377faeULL, 0x0003e6000d101c46ULL,
0x00000010352e7825ULL, 0x040fe200078e002eULL, 0x000000002c497faeULL, 0x0003e6000d901c46ULL,
0x0000001035307825ULL, 0x040fe200078e0030ULL, 0x000000002e4b7faeULL, 0x0003e6000e101c46ULL,
0x0000001035327825ULL, 0x000fe200078e0032ULL, 0x00000000304d7faeULL, 0x0003e8000e901c46ULL,
0x00000000324f7faeULL, 0x0003e2000f101c46ULL, 0x00000a8000007947ULL, 0x000fea0003800000ULL,
0x00000003ff287819ULL, 0x004fe2000001163bULL, 0x0000000856767824ULL, 0x000fc400078e00ffULL,
0x00000100ff547424ULL, 0x000fe200078e00ffULL, 0x0000000828327810ULL, 0x040fe40007ffe0ffULL,
0x0000001028467810ULL, 0x040fe40007ffe0ffULL, 0x00000004282e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000832347824ULL, 0x040fe200078e00ffULL, 0x0000003b32297212ULL, 0x000fe200078e3cffULL,
0x0000000846487824ULL, 0x000fe200078e00ffULL, 0x00000014284a7810ULL, 0x000fe20007ffe0ffULL,
0x000000082e307824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fc400078ee229ULL,
0x00000020285a7810ULL, 0x000fe20007ffe0ffULL, 0x000000084a2d7824ULL, 0x000fe200078e00ffULL,
0x0000000c28367810ULL, 0x000fe40007ffe0ffULL, 0x0000003b46297212ULL, 0x080fe200078e3cffULL,
0x000000085a5c7824ULL, 0x000fe200078e00ffULL, 0x0000003b2e077212ULL, 0x080fe200078e3cffULL,
0x0000000836447824ULL, 0x000fe200078e00ffULL, 0x0000003b4a2a7212ULL, 0x000fe400078e3cffULL,
0xfffffff848487812ULL, 0x000fc400078ee229ULL, 0x00000024285e7810ULL, 0x040fe40007ffe0ffULL,
0x00000030286a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff830307812ULL, 0x000fe400078ee207ULL,
0x00000018284e7810ULL, 0x000fe20007ffe0ffULL, 0x000000086a6c7824ULL, 0x000fe200078e00ffULL,
0x0000001c28527810ULL, 0x000fe40007ffe0ffULL, 0x0000003b5a297212ULL, 0x080fe200078e3cffULL,
0x000000084e507824ULL, 0x000fe200078e00ffULL, 0x0000003b36077212ULL, 0x000fe200078e3cffULL,
0x0000000852587824ULL, 0x000fe200078e00ffULL, 0xfffffff82d4c7812ULL, 0x000fe200078ee22aULL,
0x000000085e2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fc400078ee229ULL,
0xfffffff844447812ULL, 0x000fe400078ee207ULL, 0x0000002828627810ULL, 0x000fe40007ffe0ffULL,
0x0000003b5e2a7212ULL, 0x080fe400078e3cffULL, 0x0000002c28667810ULL, 0x000fe20007ffe0ffULL,
0x0000000862647824ULL, 0x000fe200078e00ffULL, 0x00000034286e7810ULL, 0x000fe40007ffe0ffULL,
0x0000003b6a297212ULL, 0x080fe200078e3cffULL, 0x0000000866687824ULL, 0x000fe200078e00ffULL,
0x0000003b4e2b7212ULL, 0x000fc400078e3cffULL, 0x0000003b52077212ULL, 0x000fe400078e3cffULL,
0xfffffff82d607812ULL, 0x000fe200078ee22aULL, 0x000000086e2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff86c6c7812ULL, 0x000fe400078ee229ULL, 0xfffffff850507812ULL, 0x000fe400078ee22bULL,
0xfffffff858587812ULL, 0x000fe400078ee207ULL, 0x0000003828727810ULL, 0x000fc40007ffe0ffULL,
0x00000007282c7812ULL, 0x040fe400078e483bULL, 0x0000003f28297812ULL, 0x000fe200078ec0ffULL,
0x0000000872747824ULL, 0x000fe200078e00ffULL, 0x0000003b622b7212ULL, 0x080fe400078e3cffULL,
0x0000003b66077212ULL, 0x080fe400078e3cffULL, 0x0000003b6e2a7212ULL, 0x000fe400078e3cffULL,
0x0000003c28287810ULL, 0x000fc40007ffe0ffULL, 0xfffffff864647812ULL, 0x000fe400078ee22bULL,
0xfffffff868687812ULL, 0x000fe200078ee207ULL, 0x0000000200077824ULL, 0x000fe200078e023fULL,
0xfffffff82d707812ULL, 0x000fe200078ee22aULL, 0x00000008285d7824ULL, 0x000fe200078e00ffULL,
0x0000003b722b7212ULL, 0x080fe200078e3cffULL, 0x00000004432a7e24ULL, 0x000fe2000f8e0238ULL,
0x0000003f2e2d7812ULL, 0x000fe400078ec0ffULL, 0x0000003b282e7212ULL, 0x000fe200078e3cffULL,
0x000000012a297824ULL, 0x000fe200078e0229ULL, 0x0000003f322f7812ULL, 0x000fe200078ec0ffULL,
0x000000012a2d7824ULL, 0x000fe200078e022dULL, 0xfffffff874747812ULL, 0x000fc400078ee22bULL,
0x0000003f36317812ULL, 0x000fe200078ec0ffULL, 0x000000012a2f7824ULL, 0x000fe200078e022fULL,
0x0000003f624f7812ULL, 0x000fe400078ec0ffULL, 0x0000003f6e577812ULL, 0x000fe200078ec0ffULL,
0x000000012a317824ULL, 0x000fe200078e0231ULL, 0x0000003f72597812ULL, 0x000fe200078ec0ffULL,
0x000000012a517824ULL, 0x000fe200078e024fULL, 0x0000003f285b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0029287625ULL, 0x000fe200078e0054ULL, 0x00002000072b7811ULL, 0x000fc400078e68ffULL,
0x0ffffff82c2c7812ULL, 0x000fe200078ef83bULL, 0x000000012a6f7824ULL, 0x000fe200078e0257ULL,
0x0000003f46337812ULL, 0x000fe200078ec0ffULL, 0x000000012a737824ULL, 0x000fe200078e0259ULL,
0x0000003f4a357812ULL, 0x000fe200078ec0ffULL, 0x000000012a777824ULL, 0x000fe200078e025bULL,
0x0000003f4e377812ULL, 0x000fe200078ec0ffULL, 0x000000012a337824ULL, 0x000fe200078e0233ULL,
0x0000003f52497812ULL, 0x000fe200078ec0ffULL, 0x000000012a357824ULL, 0x000fe200078e0235ULL,
0x0000003f5a4b7812ULL, 0x000fe200078ec0ffULL, 0x000000012a377824ULL, 0x000fe200078e0237ULL,
0x0000003f5e4d7812ULL, 0x000fe200078ec0ffULL, 0x000000012a497824ULL, 0x000fe200078e0249ULL,
0x0000003f66537812ULL, 0x000fe200078ec0ffULL, 0x000000012a4b7824ULL, 0x000fe200078e024bULL,
0x0000003f6a557812ULL, 0x000fe200078ec0ffULL, 0x000000012a4d7824ULL, 0x040fe200078e024dULL,
0xfffffff85d2e7812ULL, 0x000fe200078ee22eULL, 0x000000012a537824ULL, 0x000fe200078e0253ULL,
0xfffffff876077812ULL, 0x000fe200078ee23bULL, 0x000000012a557824ULL, 0x000fc400078e0255ULL,
0x000000102c4f7824ULL, 0x100fe400078e022bULL, 0x0000001030577824ULL, 0x100fe400078e022bULL,
0x0000001034597824ULL, 0x100fe400078e022bULL, 0x00000010445b7824ULL, 0x100fe400078e022bULL,
0x00000010485d7824ULL, 0x100fe400078e022bULL, 0x000000104c5f7824ULL, 0x000fc400078e022bULL,
0x0000001050617824ULL, 0x100fe400078e022bULL, 0x0000001058637824ULL, 0x100fe400078e022bULL,
0x000000105c657824ULL, 0x100fe400078e022bULL, 0x0000001060677824ULL, 0x100fe400078e022bULL,
0x0000001064697824ULL, 0x100fe400078e022bULL, 0x00000010686b7824ULL, 0x000fc400078e022bULL,
0x000000106c6d7824ULL, 0x100fe400078e022bULL, 0x0000001070717824ULL, 0x100fe400078e022bULL,
0x0000001074757824ULL, 0x100fe400078e022bULL, 0x000000102e797824ULL, 0x000fe400078e022bULL,
0x00005e002d2a7625ULL, 0x000fc800078e0054ULL, 0x00005e002f2c7625ULL, 0x000fc800078e0054ULL,
0x00005e00312e7625ULL, 0x000fc800078e0054ULL, 0x00005e0033307625ULL, 0x000fc800078e0054ULL,
0x0000001007287825ULL, 0x000fc800078e0028ULL, 0x00005e0035327625ULL, 0x080fe200078e0054ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000284f7faeULL, 0x0003e6000b901c46ULL,
0x00005e0037347625ULL, 0x000fc800078e0054ULL, 0x00005e0049367625ULL, 0x000fc800078e0054ULL,
0x00000010072a7825ULL, 0x000fc800078e002aULL, 0x00005e004b487625ULL, 0x000fe200078e0054ULL,
0x000000002a577faeULL, 0x0005e6000b901c46ULL, 0x00000010072c7825ULL, 0x000fc800078e002cULL,
0x00005e004d4a7625ULL, 0x000fe200078e0054ULL, 0x000000002c597faeULL, 0x0005e6000b901c46ULL,
0x00000010072e7825ULL, 0x000fc800078e002eULL, 0x00005e00514c7625ULL, 0x000fe200078e0054ULL,
0x000000002e5b7faeULL, 0x0005e6000b901c46ULL, 0x0000001007307825ULL, 0x000fc800078e0030ULL,
0x00005e0053287625ULL, 0x002fe200078e0054ULL, 0x00000000305d7faeULL, 0x0005e6000b901c46ULL,
0x0000001007327825ULL, 0x000fc800078e0032ULL, 0x00005e00554e7625ULL, 0x000fe200078e0054ULL,
0x00000000325f7faeULL, 0x0005e6000b901c46ULL, 0x0000001007347825ULL, 0x000fc800078e0034ULL,
0x00005e006f507625ULL, 0x000fe200078e0054ULL, 0x0000000034617faeULL, 0x0005e6000b901c46ULL,
0x0000001007367825ULL, 0x000fc800078e0036ULL, 0x00005e0073527625ULL, 0x000fe200078e0054ULL,
0x0000000036637faeULL, 0x0005e6000b901c46ULL, 0x0000001007487825ULL, 0x000fc800078e0048ULL,
0x00005e0077547625ULL, 0x000fe200078e0054ULL, 0x0000000048657faeULL, 0x0005e6000b901c46ULL,
0x00000010074a7825ULL, 0x000fc800078e004aULL, 0x00000010074c7825ULL, 0x040fe200078e004cULL,
0x000000004a677faeULL, 0x0005e6000b901c46ULL, 0x0000001007287825ULL, 0x040fe200078e0028ULL,
0x000000004c697faeULL, 0x0005e6000b901c46ULL, 0x00000010074e7825ULL, 0x040fe200078e004eULL,
0x00000000286b7faeULL, 0x0005e6000b901c46ULL, 0x0000001007507825ULL, 0x040fe200078e0050ULL,
0x000000004e6d7faeULL, 0x0005e6000b901c46ULL, 0x0000001007527825ULL, 0x040fe200078e0052ULL,
0x0000000050717faeULL, 0x0005e6000b901c46ULL, 0x0000001007547825ULL, 0x000fe200078e0054ULL,
0x0000000052757faeULL, 0x0005e8000b901c46ULL, 0x0000000054797faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5600720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x00000004ff297424ULL, 0x006fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000030029397a24ULL, 0x000fca00078e0239ULL, 0x000000043900720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x000000023e287824ULL, 0x000fc800078e0239ULL,
0x0000600028287625ULL, 0x000fca00078e0029ULL, 0x0000000628387981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010064e7824ULL, 0x004fe400078e00ffULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff83b067812ULL, 0x040fe200078ec0ffULL,
0x00000002002d7824ULL, 0x002fe200078e0247ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000203b2b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000706077812ULL, 0x000fe400078ef83bULL,
0x000020002d2d7811ULL, 0x000fc400078e68ffULL, 0x000000074c067812ULL, 0x040fe400078e7807ULL,
0x000000014c2c7810ULL, 0x000fc60007ffe0ffULL, 0x0000000807067824ULL, 0x000fc800078e0206ULL,
0x0000001006347824ULL, 0x000fe200078e022dULL, 0x000000072c067812ULL, 0x000fca00078e7807ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x0000000807067824ULL, 0x000fc800078e0206ULL,
0x0000001006307824ULL, 0x000fcc00078e022dULL, 0x000000003030783bULL, 0x000ea20000000200ULL,
0x00000018ff287819ULL, 0x002fe20000011434ULL, 0x0001000034597824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011435ULL, 0x0000003500a27306ULL, 0x000fe20000009400ULL,
0x00000018ff2a7819ULL, 0x000fe20000011436ULL, 0x00010000355a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff447819ULL, 0x000fe40000011437ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000002800a17306ULL, 0x000fe20000209400ULL,
0x00000018ff4a7819ULL, 0x004fc40000011432ULL, 0x00000018ff497819ULL, 0x000fe40000011431ULL,
0x00000018ff467819ULL, 0x000fe40000011430ULL, 0x00000018ff4b7819ULL, 0x000fe20000011433ULL,
0x0000002800a67306ULL, 0x000e700000205400ULL, 0x0000002800887306ULL, 0x0004f0000020d400ULL,
0x0000002900ad7306ULL, 0x000fe20000209400ULL, 0xfffffff82b287812ULL, 0x004fc400078ec0ffULL,
0x000000a6a100720bULL, 0x002fe40003fdd000ULL, 0x00000007282f7812ULL, 0x000fc600078ef83bULL,
0x0000002900aa7306ULL, 0x000fe20000205400ULL, 0x000000074c287812ULL, 0x100fe400078e782fULL,
0x000000072c2c7812ULL, 0x000fe400078e782fULL, 0x000000024c4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000082f287824ULL, 0x040fe400078e0228ULL, 0x0000002900847306ULL, 0x000fe2000020d400ULL,
0x000000082f2c7824ULL, 0x000fe200078e022cULL, 0x0000000188886812ULL, 0x008fe200078efcffULL,
0x0000001028287824ULL, 0x000fc400078e022dULL, 0x000000102c2c7824ULL, 0x000fc600078e022dULL,
0x0000002a00ac7306ULL, 0x000fe60000209400ULL, 0x000000002c2c783bULL, 0x000e6a0000000200ULL,
0x0000002a00a97306ULL, 0x000ff00000205400ULL, 0x0000002a00827306ULL, 0x0005f0000020d400ULL,
0x0000005900717306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x004eae0000000200ULL,
0x0000005900b87306ULL, 0x000ef00000205400ULL, 0x0000003500a57306ULL, 0x000f220000005400ULL,
0x00000018ff767819ULL, 0x002fc4000001142dULL, 0x00000018ff607819ULL, 0x000fe4000001142cULL,
0x00000018ff7b7819ULL, 0x000fc6000001142fULL, 0x0000003500857306ULL, 0x0002a2000000d400ULL,
0x000000b87100720bULL, 0x008fe40003f9d000ULL, 0x00000018ff7a7819ULL, 0x000fca000001142eULL,
0x00000034009f7306ULL, 0x000fe20000009400ULL, 0x0000010035357824ULL, 0x002fe200078e00ffULL,
0x000000a5a200720bULL, 0x010fc80003fbd000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400a07306ULL, 0x000e620000005400ULL, 0x0001000028747824ULL, 0x004fe400078e00ffULL,
0x000100002bd37824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000003400067306ULL, 0x0004e2000000d400ULL, 0x0000000185855812ULL, 0x000fe400078efcffULL,
0x000000a9ac00720bULL, 0x000fca0003fbd000ULL, 0x0000003500c57306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x004fe200078e00ffULL, 0x000000a09f00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500c87306ULL, 0x000fe20000205400ULL,
0x0000000182825812ULL, 0x000fcc00078efcffULL, 0x0000000106062812ULL, 0x008fe200078efcffULL,
0x0000003500977306ULL, 0x0003f0000020d400ULL, 0x0000005900997306ULL, 0x0004e2000020d400ULL,
0x00000018ff357819ULL, 0x002fce0000011428ULL, 0x0000003500cf7306ULL, 0x000fe20000209400ULL,
0x0001000036597824ULL, 0x004fca00078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000003500d27306ULL, 0x000fe20000205400ULL, 0x0000000199994812ULL, 0x008fe400078efcffULL,
0x000000c8c500720bULL, 0x000fe40003f9d000ULL, 0x000000069906723eULL, 0x000fc600000010ffULL,
0x0000003500757306ULL, 0x0003f0000020d400ULL, 0x0000003400b97306ULL, 0x000fe20000209400ULL,
0x0001000030357824ULL, 0x002fe200078e00ffULL, 0x0000000197974812ULL, 0x000fc800078efcffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400bc7306ULL, 0x000e700000205400ULL,
0x00000034009b7306ULL, 0x0004f0000020d400ULL, 0x00000037009e7306ULL, 0x000fe20000009400ULL,
0x0001000037347824ULL, 0x004fe200078e00ffULL, 0x000000bcb900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000037009d7306ULL, 0x000e6e0000005400ULL,
0x000000019b9b3812ULL, 0x008fe200078efcffULL, 0x0000003700817306ULL, 0x0004e2000000d400ULL,
0x000000aaad00720bULL, 0x000fce0003f7d000ULL, 0x0000003500bd7306ULL, 0x000fe20000209400ULL,
0x0000010037377824ULL, 0x004fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003500c07306ULL, 0x000fe20000205400ULL, 0x0000000184843812ULL, 0x000fe400078efcffULL,
0x0000009d9e00720bULL, 0x002fca0003f7d000ULL, 0x0000003500627306ULL, 0x0003f0000020d400ULL,
0x00000032008b7306ULL, 0x000fe20000009400ULL, 0x0001000032357824ULL, 0x002fe200078e00ffULL,
0x0000000181813812ULL, 0x008fcc00078efcffULL, 0x00000032008e7306ULL, 0x000ff00000005400ULL,
0x0000003200527306ULL, 0x0003f0000000d400ULL, 0x0000005900c77306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x002fce00078e00ffULL, 0x0000005900ca7306ULL, 0x000e700000205400ULL,
0x0000003400cd7306ULL, 0x000ff00000209400ULL, 0x0000003400d07306ULL, 0x000ea20000205400ULL,
0x000000cac700720bULL, 0x002fce0003fdd000ULL, 0x00000034009a7306ULL, 0x0002f0000020d400ULL,
0x0000005a00c47306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x002fe4000001142aULL,
0x000000d0cd00720bULL, 0x004fca0003f9d000ULL, 0x0000005a00c17306ULL, 0x000e700000205400ULL,
0x0000005a00967306ULL, 0x000522000020d400ULL, 0x000000019a9a4812ULL, 0x008fc800078efcffULL,
0x000000819a9a723eULL, 0x000fc600000010ffULL, 0x0000003700d17306ULL, 0x000fe20000209400ULL,
0x00000018ff5a7819ULL, 0x004fe20000011432ULL, 0x0001000033327824ULL, 0x000fe200078e00ffULL,
0x000000c1c400720bULL, 0x002fc80003f3d000ULL, 0x00000018ff5b7819ULL, 0x000fe20000011432ULL,
0x0000003700d47306ULL, 0x000ff00000205400ULL, 0x00000037007e7306ULL, 0x0003e2000020d400ULL,
0x0000000196961812ULL, 0x010fce00078efcffULL, 0x0000003400c67306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x002fce000001142bULL, 0x0000003400c37306ULL, 0x000ff00000205400ULL,
0x0000003400697306ULL, 0x0003f0000020d400ULL, 0x00000031008c7306ULL, 0x000fe20000009400ULL,
0x0001000031347824ULL, 0x002fce00078e00ffULL, 0x0000003100077306ULL, 0x000ff00000005400ULL,
0x0000003100537306ULL, 0x0003f0000000d400ULL, 0x0000003700bf7306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x002fce00078e00ffULL, 0x0000003700c27306ULL, 0x000ff00000205400ULL,
0x0000003700667306ULL, 0x0003f0000020d400ULL, 0x00000059009c7306ULL, 0x0004e2000020d400ULL,
0x00000018ff377819ULL, 0x002fce0000011434ULL, 0x0000003600a47306ULL, 0x000fe20000009400ULL,
0x00000018ff597819ULL, 0x004fce0000011431ULL, 0x0000003600a37306ULL, 0x000e620000005400ULL,
0x000000019c9c6812ULL, 0x008fe400078efcffULL, 0x000000d4d100720bULL, 0x000fca0003fdd000ULL,
0x0000003600837306ULL, 0x0004f0000000d400ULL, 0x0000007400d57306ULL, 0x000fe20000209400ULL,
0x0000010036367824ULL, 0x004fe200078e00ffULL, 0x000000a3a400720bULL, 0x002fc40003f5d000ULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000007400d87306ULL, 0x000e6e0000205400ULL, 0x0000000183832812ULL, 0x008fe200078efcffULL,
0x0000003700ba7306ULL, 0x000ff00000209400ULL, 0x0000003700b77306ULL, 0x000fe20000205400ULL,
0x000000d8d500720bULL, 0x002fce0003f9d000ULL, 0x0000003700347306ULL, 0x000ff0000020d400ULL,
0x0000005900b57306ULL, 0x000ff00000209400ULL, 0x0000005900b67306ULL, 0x000ff00000205400ULL,
0x0000005900317306ULL, 0x000ff0000020d400ULL, 0x0000005a00957306ULL, 0x000ff00000209400ULL,
0x0000005a00987306ULL, 0x000ff00000205400ULL, 0x0000005a00377306ULL, 0x000ff0000020d400ULL,
0x0000005b00737306ULL, 0x000ff00000209400ULL, 0x0000005b00727306ULL, 0x000ff00000205400ULL,
0x0000005b00327306ULL, 0x000ff0000020d400ULL, 0x0000002800b47306ULL, 0x000ff00000009400ULL,
0x0000002800b17306ULL, 0x000ff00000005400ULL, 0x0000002800707306ULL, 0x0003f0000000d400ULL,
0x0000007600597306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000076005a7306ULL, 0x000ff00000205400ULL,
0x00000076005b7306ULL, 0x0003f0000020d400ULL, 0x0000003000907306ULL, 0x000fe20000009400ULL,
0x0001000029767824ULL, 0x002fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000030008d7306ULL, 0x000ff00000005400ULL, 0x0000003000557306ULL, 0x0003f0000000d400ULL,
0x0000003600cc7306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x002fce00078e00ffULL,
0x0000003600c97306ULL, 0x000e700000205400ULL, 0x0000003600937306ULL, 0x0005f0000020d400ULL,
0x00000074007d7306ULL, 0x000722000020d400ULL, 0x00000018ff367819ULL, 0x004fc40000011429ULL,
0x000000c9cc00720bULL, 0x002fca0003f3d000ULL, 0x0000003600cb7306ULL, 0x000fe20000209400ULL,
0x000100002a747824ULL, 0x008fce00078e00ffULL, 0x0000003600ce7306ULL, 0x000e620000205400ULL,
0x000000017d7d4812ULL, 0x010fe400078efcffULL, 0x0000000193931812ULL, 0x000fe400078efcffULL,
0x000000b1b400720bULL, 0x000fc60003f3d000ULL, 0x00000036006d7306ULL, 0x0004f0000020d400ULL,
0x0000002800d77306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x004fe40000011430ULL,
0x0000000170701812ULL, 0x000fc400078efcffULL, 0x000000cecb00720bULL, 0x002fc60003f3d000ULL,
0x0000002800da7306ULL, 0x000e700000205400ULL, 0x0000007600d97306ULL, 0x000fe40000209400ULL,
0x000000016d6d1812ULL, 0x008fcc00078efcffULL, 0x0000007600dc7306ULL, 0x000ea20000205400ULL,
0x000000dad700720bULL, 0x002fce0003fdd000ULL, 0x0000002900b27306ULL, 0x000ff00000009400ULL,
0x0000002900b37306ULL, 0x000e620000005400ULL, 0x000000dcd900720bULL, 0x004fce0003f9d000ULL,
0x00000029006a7306ULL, 0x0004f0000000d400ULL, 0x0000002a00b07306ULL, 0x000fe20000009400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x000000b3b200720bULL, 0x002fc80003fbd000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a00af7306ULL, 0x000e6e0000005400ULL,
0x000000016a6a5812ULL, 0x008fe200078efcffULL, 0x0000002a00657306ULL, 0x0004e2000000d400ULL,
0x000000c3c600720bULL, 0x000fce0003fbd000ULL, 0x0000003600bb7306ULL, 0x000fe20000209400ULL,
0x000001002a2a7824ULL, 0x004fe200078e00ffULL, 0x000000afb000720bULL, 0x002fc80003f7d000ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000003600be7306ULL, 0x000e620000205400ULL,
0x0000000169695812ULL, 0x000fe400078efcffULL, 0x000000c0bd00720bULL, 0x000fc80003fbd000ULL,
0x0000000165653812ULL, 0x008fe200078efcffULL, 0x0000003600307306ULL, 0x0004e2000020d400ULL,
0x0000008d9000720bULL, 0x000fe20003f7d000ULL, 0x000001002f8d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001148dULL, 0x0000003300897306ULL, 0x000fe20000009400ULL,
0x00000018ff367819ULL, 0x004fe40000011435ULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x000000bebb00720bULL, 0x002fe40003fbd000ULL, 0x0000000155553812ULL, 0x000fe200078efcffULL,
0x00000033008a7306ULL, 0x000fe20000005400ULL, 0x000000b7ba00720bULL, 0x000fc40003f7d000ULL,
0x000000556262723eULL, 0x000fca00000010ffULL, 0x0000003300517306ULL, 0x0003e4000000d400ULL,
0x0000000130305812ULL, 0x008fc800078efcffULL, 0x0000000134343812ULL, 0x000fe400078efcffULL,
0x0000004400ab7306ULL, 0x000fe20000209400ULL, 0x0000010033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011433ULL, 0x0000004400ae7306ULL, 0x000e700000205400ULL,
0x0000003600a77306ULL, 0x000ff00000209400ULL, 0x0000003600a87306ULL, 0x000fe20000205400ULL,
0x000000aeab00720bULL, 0x002fce0003f5d000ULL, 0x0000003600357306ULL, 0x000ff0000020d400ULL,
0x0000006000677306ULL, 0x000ff00000209400ULL, 0x0000006000687306ULL, 0x000ff00000205400ULL,
0x0000006000367306ULL, 0x000ff0000020d400ULL, 0x0000007b005f7306ULL, 0x000ff00000209400ULL,
0x0000007b00607306ULL, 0x000ff00000205400ULL, 0x0000007b00617306ULL, 0x000ff0000020d400ULL,
0x00000028007c7306ULL, 0x0002b0000020d400ULL, 0x00000076007b7306ULL, 0x000ee2000020d400ULL,
0x00000018ff287819ULL, 0x002fce0000011474ULL, 0x0000002900db7306ULL, 0x000fe20000209400ULL,
0x000000017c7c6812ULL, 0x004fce00078efcffULL, 0x0000002900de7306ULL, 0x000e620000205400ULL,
0x000000017b7b4812ULL, 0x008fc800078efcffULL, 0x0000006a7b6a723eULL, 0x000fc600000010ffULL,
0x0000002a00df7306ULL, 0x000ff00000209400ULL, 0x0000002a00e27306ULL, 0x000ea20000205400ULL,
0x000000dedb00720bULL, 0x002fce0003fdd000ULL, 0x0000005d006e7306ULL, 0x000ff00000209400ULL,
0x0000005d006f7306ULL, 0x000fe20000205400ULL, 0x000000e2df00720bULL, 0x004fce0003f9d000ULL,
0x0000005d00337306ULL, 0x000ff0000020d400ULL, 0x0000007a005c7306ULL, 0x000ff00000209400ULL,
0x0000007a005d7306ULL, 0x000ff00000205400ULL, 0x0000007a005e7306ULL, 0x000ff0000020d400ULL,
0x00000029007a7306ULL, 0x0002b0000020d400ULL, 0x0000002800dd7306ULL, 0x000fe20000209400ULL,
0x00000018ff297819ULL, 0x002fce00000114d3ULL, 0x0000002800e07306ULL, 0x000fe20000205400ULL,
0x000000017a7a6812ULL, 0x004fce00078efcffULL, 0x0000002800747306ULL, 0x0003f0000020d400ULL,
0x0000002a00767306ULL, 0x0004e2000020d400ULL, 0x000100002c287824ULL, 0x002fce00078e00ffULL,
0x0000002900d37306ULL, 0x000fe20000209400ULL, 0x000000073b2a7812ULL, 0x004fc800078ec0ffULL,
0x000000082aab7812ULL, 0x000fe200078ef83bULL, 0x000100002d2a7824ULL, 0x000fe400078e00ffULL,
0x0000002900d67306ULL, 0x000e620000205400ULL, 0x0000000176764812ULL, 0x008fe400078efcffULL,
0x00000018ffaa7819ULL, 0x000fe4000001142aULL, 0x000000c2bf00720bULL, 0x000fc60003f9d000ULL,
0x0000002900717306ULL, 0x0004f0000020d400ULL, 0x0000002b00917306ULL, 0x000fe20000009400ULL,
0x00000018ff297819ULL, 0x004fe40000011428ULL, 0x0000004e3b287211ULL, 0x000fc400078fe0ffULL,
0x000000d6d300720bULL, 0x002fe40003fdd000ULL, 0x0000000166664812ULL, 0x000fe200078efcffULL,
0x0000002900a07306ULL, 0x000fe20000209400ULL, 0x000000044e4e7810ULL, 0x000fce0007ffe0ffULL,
0x0000002900a17306ULL, 0x000fe40000205400ULL, 0x0000000171716812ULL, 0x008fe400078efcffULL,
0x000000078c00720bULL, 0x000fe40003fdd000ULL, 0x0000009b8807723eULL, 0x000fe400000010ffULL,
0x00000029009d7306ULL, 0x0003f0000020d400ULL, 0x0000002b00947306ULL, 0x000ea20000005400ULL,
0x0000000728297812ULL, 0x002fc400078e78abULL, 0x0000000228287810ULL, 0x000fe40007ffe0ffULL,
0x0000000153536812ULL, 0x000fe200078efcffULL, 0x00000020ab297824ULL, 0x000fe200078e0229ULL,
0x000000a8a700720bULL, 0x000fe20003fdd000ULL, 0x0000002b00587306ULL, 0x0002e4000000d400ULL,
0x0000001029297824ULL, 0x000fcc00078e00ffULL, 0x0000002c006b7306ULL, 0x000fe20000009400ULL,
0x000001002b2b7824ULL, 0x002fe200078e00ffULL, 0x000000949100720bULL, 0x004fe40003f3d000ULL,
0x0000000135356812ULL, 0x000fe400078efcffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000002c006c7306ULL, 0x000e6e0000005400ULL, 0x0000000158581812ULL, 0x008fe200078efcffULL,
0x0000002c00507306ULL, 0x0004e2000000d400ULL, 0x0000008e8b00720bULL, 0x000fe20003f3d000ULL,
0x000100002f8b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x0000004400797306ULL, 0x000f22000020d400ULL, 0x000001002c2c7824ULL, 0x004fe200078e00ffULL,
0x0000006c6b00720bULL, 0x002fe40003fdd000ULL, 0x0000007a6d6b723eULL, 0x000fe400000010ffULL,
0x00000018ffa97819ULL, 0x000fe4000001142cULL, 0x00000046008f7306ULL, 0x000fe20000209400ULL,
0x00000007282c7812ULL, 0x000fc400078e78abULL, 0x0000000152521812ULL, 0x000fe400078efcffULL,
0x000000727300720bULL, 0x000fe20003f3d000ULL, 0x00000020aba47824ULL, 0x000fe200078e022cULL,
0x0000000150506812ULL, 0x008fe200078efcffULL, 0x0000004600927306ULL, 0x000e620000205400ULL,
0x0000000179792812ULL, 0x010fe200078efcffULL, 0x000100002e2c7824ULL, 0x000fe200078e00ffULL,
0x000000d2cf00720bULL, 0x000fe40003f5d000ULL, 0x0000007e799b723eULL, 0x000fc400000010ffULL,
0x000000523552723eULL, 0x000fe200000010ffULL, 0x0000002b00a67306ULL, 0x000fe40000209400ULL,
0x0000000132321812ULL, 0x000fcc00078efcffULL, 0x0000002b00b97306ULL, 0x000ea20000205400ULL,
0x000000928f00720bULL, 0x002fe40003f9d000ULL, 0x0000000175752812ULL, 0x000fe400078efcffULL,
0x000000e0dd00720bULL, 0x000fc60003f5d000ULL, 0x0000002b009f7306ULL, 0x0003f0000020d400ULL,
0x00000046004d7306ULL, 0x000ee2000020d400ULL, 0x000000002928783bULL, 0x002e620000000200ULL,
0x0000000174742812ULL, 0x000fc400078efcffULL, 0x000000b9a600720bULL, 0x004fe40003f5d000ULL,
0x000000657474723eULL, 0x000fe400000010ffULL, 0x0000004a00807306ULL, 0x000ff00000209400ULL,
0x0000004a007f7306ULL, 0x000ea20000205400ULL, 0x000000014d4d4812ULL, 0x008fc400078efcffULL,
0x000000b6b500720bULL, 0x000fe40003f9d000ULL, 0x000000019f9f2812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003f5d000ULL, 0x0000004a00447306ULL, 0x000ee2000020d400ULL,
0x000001002e8a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001148aULL,
0x0000004900877306ULL, 0x000fe20000209400ULL, 0x0000007f8000720bULL, 0x004fe40003f7d000ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x0000000151512812ULL, 0x000fe400078efcffULL,
0x000000a1a000720bULL, 0x000fe20003f5d000ULL, 0x0000004900867306ULL, 0x000ea20000205400ULL,
0x000000062818723cULL, 0x002fe20000041818ULL, 0x000000513232723eULL, 0x000fc800000010ffULL,
0x0000000144443812ULL, 0x008fe400078efcffULL, 0x0000004b00787306ULL, 0x000fe20000209400ULL,
0x000000859606723eULL, 0x000fe200000010ffULL, 0x0000009a2824723cULL, 0x040fe20000041824ULL,
0x000000978407723eULL, 0x000fe400000010ffULL, 0x0000006f6e00720bULL, 0x000fe40003f7d000ULL,
0x00000018ff857819ULL, 0x000fe2000001142cULL, 0x0000004b00777306ULL, 0x000e620000205400ULL,
0x000000868700720bULL, 0x004fe20003fbd000ULL, 0x000000062808723cULL, 0x000fe20000041808ULL,
0x000000839c2c723eULL, 0x000fc400000010ffULL, 0x000000019d9d2812ULL, 0x000fc600078efcffULL,
0x0000004900487306ULL, 0x000ea2000020d400ULL, 0x000000707d06723eULL, 0x000fe200000010ffULL,
0x0000006a2814723cULL, 0x040fe20000041814ULL, 0x0000007c7507723eULL, 0x000fe400000010ffULL,
0x0000000133333812ULL, 0x000fe400078efcffULL, 0x000000686700720bULL, 0x000fe20003f7d000ULL,
0x0000004b00467306ULL, 0x000ee2000020d400ULL, 0x000000777800720bULL, 0x002fe20003f9d000ULL,
0x00000006281c723cULL, 0x000fe2000004181cULL, 0x000000766975723eULL, 0x000fc400000010ffULL,
0x000000509d50723eULL, 0x000fc600000010ffULL, 0x000000a9009e7306ULL, 0x000fe20000209400ULL,
0x0000000148485812ULL, 0x004fe200078efcffULL, 0x000000742810723cULL, 0x000fe20000041810ULL,
0x000000989500720bULL, 0x000fe40003fbd000ULL, 0x000000587106723eULL, 0x000fe400000010ffULL,
0x0000009f6607723eULL, 0x000fe200000010ffULL, 0x000000a900a57306ULL, 0x000e620000205400ULL,
0x0000000146464812ULL, 0x008fe400078efcffULL, 0x0000000136363812ULL, 0x000fc400078efcffULL,
0x0000005a5900720bULL, 0x000fe20003f7d000ULL, 0x00000006280c723cULL, 0x000fe2000004180cULL,
0x000000314831723eULL, 0x000fe200000010ffULL, 0x000000aa00a27306ULL, 0x000fe20000209400ULL,
0x0000000137375812ULL, 0x000fe400078efcffULL, 0x000000334633723eULL, 0x000fca00000010ffULL,
0x000000aa00917306ULL, 0x000ea20000205400ULL, 0x000000a59e00720bULL, 0x002fe40003f9d000ULL,
0x000000015b5b3812ULL, 0x000fca00078efcffULL, 0x0000002d00647306ULL, 0x000ff00000009400ULL,
0x0000002d00637306ULL, 0x000e620000005400ULL, 0x00000091a200720bULL, 0x004fce0003fdd000ULL,
0x0000002d004f7306ULL, 0x0004f0000000d400ULL, 0x0000002e00577306ULL, 0x000fe20000009400ULL,
0x000001002d2d7824ULL, 0x004fe200078e00ffULL, 0x000000636400720bULL, 0x002fc40003fbd000ULL,
0x000000304d63723eULL, 0x000fe400000010ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001142dULL,
0x0000002e00567306ULL, 0x000e620000005400ULL, 0x00000093822d723eULL, 0x000fe400000010ffULL,
0x000000533430723eULL, 0x000fe400000010ffULL, 0x000000374453723eULL, 0x000fe400000010ffULL,
0x000000014f4f5812ULL, 0x008fe200078efcffULL, 0x000000a900a37306ULL, 0x000ea2000020d400ULL,
0x0000002c2820723cULL, 0x000fe20000041820ULL, 0x0000005d5c00720bULL, 0x000fcc0003fbd000ULL,
0x000000aa00907306ULL, 0x000ee2000020d400ULL, 0x00000010a42c7824ULL, 0x000fe200078e00ffULL,
0x000000565700720bULL, 0x002fca0003f3d000ULL, 0x000000015e5e5812ULL, 0x000fe200078efcffULL,
0x0000008c00897306ULL, 0x000fe20000209400ULL, 0x00000001a3a34812ULL, 0x004fc800078efcffULL,
0x000000a33651723eULL, 0x000fc600000010ffULL, 0x0000008c00887306ULL, 0x000e620000205400ULL,
0x0000000190906812ULL, 0x008fc800078efcffULL, 0x0000004f905a723eULL, 0x000fc600000010ffULL,
0x0000008500827306ULL, 0x000ff00000209400ULL, 0x0000008500797306ULL, 0x000ea20000205400ULL,
0x000000888900720bULL, 0x002fce0003f9d000ULL, 0x0000002e00497306ULL, 0x000e70000000d400ULL,
0x0000008d00067306ULL, 0x000fe20000209400ULL, 0x000000798200720bULL, 0x004fce0003fdd000ULL,
0x0000008d00297306ULL, 0x000ea20000205400ULL, 0x0000000149491812ULL, 0x002fce00078efcffULL,
0x0000002f004b7306ULL, 0x000ff00000009400ULL, 0x0000002f00547306ULL, 0x000e620000005400ULL,
0x000000290600720bULL, 0x004fce0003f3d000ULL, 0x0000002f004a7306ULL, 0x0004f0000000d400ULL,
0x0000008c00847306ULL, 0x000f22000020d400ULL, 0x000000002c2c783bULL, 0x004ea20000000200ULL,
0x000000544b00720bULL, 0x002fcc0003f5d000ULL, 0x0000008500707306ULL, 0x000e6e000020d400ULL,
0x000000014a4a2812ULL, 0x008fe200078efcffULL, 0x0000008a006c7306ULL, 0x000fe20000209400ULL,
0x0000000184844812ULL, 0x010fe400078efcffULL, 0x000000605f00720bULL, 0x000fc40003f9d000ULL,
0x000000845b5b723eULL, 0x000fc600000010ffULL, 0x0000008a006d7306ULL, 0x000ee20000205400ULL,
0x0000000170706812ULL, 0x002fc800078efcffULL, 0x000000497070723eULL, 0x000fc600000010ffULL,
0x0000008b00567306ULL, 0x000fe20000209400ULL, 0x0000000161614812ULL, 0x000fce00078efcffULL,
0x0000008b00077306ULL, 0x000e620000205400ULL, 0x0000006d6c00720bULL, 0x008fe20003f7d000ULL,
0x000000622c18723cULL, 0x044fec0000041818ULL, 0x0000008d00287306ULL, 0x000ea4000020d400ULL,
0x000000302c08723cULL, 0x040fec0000041808ULL, 0x0000008a00577306ULL, 0x000ee2000020d400ULL,
0x000000075600720bULL, 0x002fe20003fdd000ULL, 0x000000522c20723cULL, 0x040fec0000041820ULL,
0x0000008b008b7306ULL, 0x000e62000020d400ULL, 0x0000000128281812ULL, 0x004fe200078efcffULL,
0x000000322c24723cULL, 0x000fe20000041824ULL, 0x000000084c00780cULL, 0x000fc40003f25270ULL,
0x00000028614b723eULL, 0x000fe400000010ffULL, 0x0000000157573812ULL, 0x008fc600078efcffULL,
0x000000502c1c723cULL, 0x000fe2000004181cULL, 0x000000575e71723eULL, 0x000fe400000010ffULL,
0x000000018b8b6812ULL, 0x002fca00078efcffULL, 0x0000005a2c14723cULL, 0x000fe20000041814ULL,
0x0000004a8b4a723eULL, 0x000fce00000010ffULL, 0x000000702c10723cULL, 0x040ff00000041810ULL,
0x0000004a2c0c723cULL, 0x000fe2000004180cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe16000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff477224ULL, 0x000fe200078e003fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffc91000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x01c614003d077984ULL, 0x000e620000000800ULL, 0x0000ffff41067812ULL, 0x000fe200078ec0ffULL,
0x000000203c207220ULL, 0x000fc40000410000ULL, 0x000000213c217220ULL, 0x000fe20000410000ULL,
0x0000888006347816ULL, 0x000fe200000000ffULL, 0x000000243c247220ULL, 0x040fe40000410000ULL,
0x000000253c257220ULL, 0x040fe40000410000ULL, 0x000000183c187220ULL, 0x040fe40000410000ULL,
0x000000193c197220ULL, 0x040fe40000410000ULL, 0x0000001a3c287220ULL, 0x000fc40000410000ULL,
0x0000001b3c297220ULL, 0x040fe40000410000ULL, 0x0000000a3c2a7220ULL, 0x040fe40000410000ULL,
0x0000000b3c2b7220ULL, 0x040fe40000410000ULL, 0x000000263c267220ULL, 0x040fe40000410000ULL,
0x000000273c277220ULL, 0x040fe40000410000ULL, 0x0000001c3c1c7220ULL, 0x000fc40000410000ULL,
0x0000001d3c1d7220ULL, 0x000fe40000410000ULL, 0x8000000034067824ULL, 0x000fe400078e00ffULL,
0x000000083c087220ULL, 0x040fe40000410000ULL, 0x000000093c097220ULL, 0x040fe40000410000ULL,
0x0000001e3c2c7220ULL, 0x040fe40000410000ULL, 0x0000001f3c2d7220ULL, 0x000fc40000410000ULL,
0x000000143c0a7220ULL, 0x040fe20000410000ULL, 0x8000000007ff7812ULL, 0x002fe20007804806ULL,
0x000000153c0b7220ULL, 0x040fe40000410000ULL, 0x000000163c2e7220ULL, 0x040fe40000410000ULL,
0x000000173c2f7220ULL, 0x040fe40000410000ULL, 0x000000123c307220ULL, 0x040fe40000410000ULL,
0x000000133c317220ULL, 0x000fc40000410000ULL, 0x0000000c3c0c7220ULL, 0x040fe40000410000ULL,
0x0000000d3c0d7220ULL, 0x040fe40000410000ULL, 0x0000000e3c327220ULL, 0x040fe40000410000ULL,
0x0000000f3c337220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fe400078e0020ULL,
0x000000ffff137224ULL, 0x000fc400078e0021ULL, 0x000000ffff147224ULL, 0x000fe400078e0024ULL,
0x000000ffff157224ULL, 0x000fe400078e0025ULL, 0x000000103c1a7220ULL, 0x040fe40000410000ULL,
0x000000113c1b7220ULL, 0x000fe40000410000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0019ULL, 0x000000ffff167224ULL, 0x000fe400078e001cULL,
0x000000ffff177224ULL, 0x000fe400078e001dULL, 0x000000ffff1e7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0029ULL, 0x000000ffff207224ULL, 0x000fe400078e002aULL,
0x000000ffff217224ULL, 0x000fc400078e002bULL, 0x000000ffff247224ULL, 0x000fe400078e0026ULL,
0x000000ffff257224ULL, 0x000fe400078e0027ULL, 0x000000223c227220ULL, 0x040fe40000410000ULL,
0x000000233c237220ULL, 0x000fe40000410000ULL, 0x000000ffff107224ULL, 0x000fe400078e0008ULL,
0x000000ffff117224ULL, 0x000fc400078e0009ULL, 0x000000ffff187224ULL, 0x000fe400078e000aULL,
0x000000ffff197224ULL, 0x000fe400078e000bULL, 0x000000ffff1c7224ULL, 0x000fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000dULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fc400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0031ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0033ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000034347824ULL, 0x000fe400078e00ffULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x01c614003d077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804834ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000043b077824ULL, 0x000fe200078e00ffULL, 0x000000400300720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff007097812ULL, 0x000fca00078ec0ffULL,
0x0000008000067824ULL, 0x000fca00078e0209ULL, 0x01c4000006087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000023b0c7824ULL, 0x000fe400078e00ffULL,
0x0000000102457824ULL, 0x000fc600078e0a45ULL, 0x000000060c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c2e7812ULL, 0x040fe400078efcffULL, 0x000000080c307812ULL, 0x000fe400078efcffULL,
0x000000452e00720cULL, 0x080fe40003f26070ULL, 0x000000100c2e7812ULL, 0x000fe400078efcffULL,
0x000000453000720cULL, 0x080fe40003f06070ULL, 0x000000452e00720cULL, 0x000fc40003fc6070ULL,
0x000000110c307812ULL, 0x040fe400078efcffULL, 0x000000180c2e7812ULL, 0x040fe400078efcffULL,
0x000000450c00720cULL, 0x080fe40003f46070ULL, 0x000000453000720cULL, 0x080fe40003fa6070ULL,
0x000000452e00720cULL, 0x000fe40003f66070ULL, 0x000000090c327812ULL, 0x000fc400078efcffULL,
0x000000190c307812ULL, 0x040fe400078efcffULL, 0x000000200c2e7812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x000000453200720cULL, 0x080fe40003f86070ULL, 0x000000453000720cULL, 0x080fe40003f46070ULL,
0x000000452e00720cULL, 0x000fe40003f26070ULL, 0x000000210c307812ULL, 0x040fe400078efcffULL,
0x000000280c2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff21217808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x000000453000720cULL, 0x080fe40003f06070ULL,
0x000000452e00720cULL, 0x000fe40003f86070ULL, 0x000000290c307812ULL, 0x000fc400078efcffULL,
0x000000300c2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x000000453000720cULL, 0x000fc40003fc6070ULL,
0x000000452e00720cULL, 0x000fe40003fa6070ULL, 0x000000310c307812ULL, 0x040fe400078efcffULL,
0x000000380c2e7812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff7fffff24247808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff25257808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff26267808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x000000453000720cULL, 0x080fe40003f66070ULL, 0x000000452e00720cULL, 0x000fc40003f46070ULL,
0x000000450c00720cULL, 0x000fe40003f26070ULL, 0xff7fffff27277808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff28287808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff29297808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f080d7209ULL, 0x004fe40007810000ULL, 0x0000001e09087209ULL, 0x000fe40007810000ULL,
0x0000000e0d0d7209ULL, 0x000fe40007810000ULL, 0x0000001f08097209ULL, 0x000fc40007810000ULL,
0x000000100d087209ULL, 0x000fe40007810000ULL, 0x00000020090c7209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x000000210c0d7209ULL, 0x000fe40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x000000220d0c7209ULL, 0x000fc40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x000000230c0d7209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x000000240d0c7209ULL, 0x000fe40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x000000250c0d7209ULL, 0x000fc40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x000000260d0c7209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x000000270c0d7209ULL, 0x000fe40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x000000280d0c7209ULL, 0x000fc40007810000ULL,
0x0000001908097209ULL, 0x000fe40007810000ULL, 0x000000290c0d7209ULL, 0x000fe40007810000ULL,
0x0000001a09087209ULL, 0x000fe40007810000ULL, 0x0000002a0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001b08097209ULL, 0x000fe40007810000ULL, 0x0000002b0c0d7209ULL, 0x000fc40007810000ULL,
0x0000001c09087209ULL, 0x000fe40007810000ULL, 0x0000002c0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001d08097209ULL, 0x000fe40007810000ULL, 0x0000002d0c317209ULL, 0x000fe20007810000ULL,
0x00000dc27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009087f89ULL, 0x0004e400000e0000ULL,
0x0000000809327209ULL, 0x008fe20007810000ULL, 0x00000e127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0031087f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x004ea800000e0000ULL,
0x0c401f000b2e7f89ULL, 0x000f2200000e0000ULL, 0x00000008310c7209ULL, 0x008fc60007810000ULL,
0x0c201f0032087f89ULL, 0x000ee200000e0000ULL, 0x000000090a0d7209ULL, 0x004fc60007810000ULL,
0x0c201f000c097f89ULL, 0x000ea200000e0000ULL, 0x0000002e0b2e7209ULL, 0x010fc60007810000ULL,
0x0c201f000d307f89ULL, 0x002e6800000e0000ULL, 0x0c201f002e2f7f89ULL, 0x00092200000e0000ULL,
0x0000000832087209ULL, 0x008fe40007810000ULL, 0x000000090c097209ULL, 0x004fe40007810000ULL,
0x000000300d0a7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fc40000000000ULL, 0x00000005ff317e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL,
0x0000000000087886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x0000000f000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b12127823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b13137823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL,
0x0000000e000d7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080bULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1d0b7823ULL, 0x000fe2000001080bULL,
0x0000000c0d0c723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b091d7820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081dULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b20207823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081dULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x00000010110e723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b23237823ULL, 0x000fc4000001081dULL, 0x3fb8aa3b24247823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b25257823ULL, 0x100fe4000001081dULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b28287823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001081dULL,
0x00000020000f7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x000fc4000001081dULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b2d1d7823ULL, 0x000fe2000001081dULL, 0x0000002100307308ULL, 0x0008a20000000800ULL,
0x3f8000003120783eULL, 0x008fe400000010ffULL, 0x0000001e1f0d723eULL, 0x002fca00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000ffff217224ULL, 0x010fe200078e0020ULL,
0x0000000f300f723eULL, 0x004fcc00000010ffULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x000000200c30723cULL, 0x000fe200000418ffULL, 0x000000121310723eULL, 0x002fcc00000010ffULL,
0x0000001500157308ULL, 0x000e700000000800ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x000000141512723eULL, 0x002fce00000010ffULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x000000222311723eULL, 0x004fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000242513723eULL, 0x002fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000201030723cULL, 0x000fee0000041830ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000181916723eULL, 0x004fe200000010ffULL, 0x0000000fff197424ULL, 0x000fe200078e00ffULL,
0xfffffffc3b187812ULL, 0x000fc800078ec0ffULL, 0x0000001819227219ULL, 0x000fe200000006ffULL,
0x0000002800287308ULL, 0x000fe60000000800ULL, 0x00000000221f73a1ULL, 0x000ea200000e8000ULL,
0x00000000220573c4ULL, 0x000ee80000004000ULL, 0x0000002900297308ULL, 0x000f220000000800ULL,
0x000000262715723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000282917723eULL, 0x010fce00000010ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000822ff7c12ULL, 0x004fe2000f80401fULL, 0x000000201430723cULL, 0x000fec0000041830ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000010ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x0000001c0b1a723eULL, 0x004fe400000010ffULL,
0x0000002e2f0b7209ULL, 0x000fca0007810000ULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000001d001d7308ULL, 0x000ea20000000800ULL, 0x0000002a2b19723eULL, 0x002fe400000010ffULL,
0x0000002c1d1b723eULL, 0x004fce00000010ffULL, 0x000000201830723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000a0205008947ULL, 0x008fde000b800000ULL,
0x001c1fff301c7589ULL, 0x0002a400000e0000ULL, 0x00000000221d73a1ULL, 0x000ee200000e8000ULL,
0x00000000220573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x0000000822ff7c12ULL, 0x008fda000f80401dULL, 0x00000a1205008947ULL, 0x010fea000b800000ULL,
0x001c1fff321d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff207819ULL, 0x000fe4000001163bULL,
0x0000000c07377812ULL, 0x000fc400078ec0ffULL, 0x0000000720217812ULL, 0x040fe200078ec0ffULL,
0x0000000820267824ULL, 0x040fe200078e00ffULL, 0x00000020ff247212ULL, 0x002fe200078e33ffULL,
0x0000000820227824ULL, 0x048fe200078e00ffULL, 0x000000033bff7812ULL, 0x000fe2000780c0ffULL,
0x0000000820317824ULL, 0x040fe200078e00ffULL, 0x0000000820207810ULL, 0x000fe40007ffe0ffULL,
0xfffffff826237812ULL, 0x100fe400078ee221ULL, 0x0000000122257812ULL, 0x100fe200078ef621ULL,
0x00000008204f7824ULL, 0x000fe200078e00ffULL, 0x0000000222277812ULL, 0x100fe200078ef621ULL,
0x0000000820267824ULL, 0x000fe200078e00ffULL, 0x0000000322297812ULL, 0x000fc400078ef621ULL,
0x00000004222b7812ULL, 0x140fe400078ef621ULL, 0x00000005222d7812ULL, 0x140fe400078ef621ULL,
0x00000006222f7812ULL, 0x000fe200078ef621ULL, 0x0000000820227824ULL, 0x040fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe400078ee224ULL, 0x00000020ff247212ULL, 0x000fe400078e33ffULL,
0x0000000720217812ULL, 0x000fc400078ec0ffULL, 0x0001200000207811ULL, 0x000fe400078e58ffULL,
0xfffffff826337812ULL, 0x100fe400078ee221ULL, 0x0000000122357812ULL, 0x140fe200078ef621ULL,
0x0000001023077824ULL, 0x100fe200078e0220ULL, 0x0000000222457812ULL, 0x140fe200078ef621ULL,
0x000000102b267824ULL, 0x100fe200078e0220ULL, 0x0000000322477812ULL, 0x040fe200078ef621ULL,
0x0000000137077824ULL, 0x000fe200078e0207ULL, 0x0000000422497812ULL, 0x140fe200078ef621ULL,
0x000000102d287824ULL, 0x100fe200078e0220ULL, 0x00000005224b7812ULL, 0x140fe200078ef621ULL,
0x000000102f2a7824ULL, 0x100fe200078e0220ULL, 0x00000006224d7812ULL, 0x000fe200078ef621ULL,
0x0000001025217824ULL, 0x000fe200078e0220ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee224ULL,
0x0000001027227824ULL, 0x100fe200078e0220ULL, 0x0000000c07007388ULL, 0x0003e20000000800ULL,
0x0000001029247824ULL, 0x000fc400078e0220ULL, 0x0000000137217824ULL, 0x040fe400078e0221ULL,
0x0000000137237824ULL, 0x000fe400078e0222ULL, 0x00000010312c7824ULL, 0x000fe200078e0220ULL,
0x0000000e21007388ULL, 0x0007e20000000800ULL, 0x0000000137257824ULL, 0x000fe400078e0224ULL,
0x00000010332e7824ULL, 0x000fe200078e0220ULL, 0x0000001023007388ULL, 0x0007e20000000800ULL,
0x0000000137277824ULL, 0x000fc400078e0226ULL, 0x00000010352f7824ULL, 0x000fe200078e0220ULL,
0x0000001225007388ULL, 0x0007e20000000800ULL, 0x0000000137297824ULL, 0x000fe400078e0228ULL,
0x0000001045307824ULL, 0x000fe200078e0220ULL, 0x0000001427007388ULL, 0x0007e20000000800ULL,
0x00000001372b7824ULL, 0x000fe400078e022aULL, 0x0000001047317824ULL, 0x000fe200078e0220ULL,
0x0000001629007388ULL, 0x0007e20000000800ULL, 0x00000001372d7824ULL, 0x000fc400078e022cULL,
0x0000001049327824ULL, 0x100fe200078e0220ULL, 0x000000182b007388ULL, 0x0007e20000000800ULL,
0x000000104b337824ULL, 0x100fe400078e0220ULL, 0x000000104d347824ULL, 0x100fe200078e0220ULL,
0x0000001a2d007388ULL, 0x0007e20000000800ULL, 0x000000104f357824ULL, 0x000fe400078e0220ULL,
0x00000001372e7824ULL, 0x040fe400078e022eULL, 0x0000000137207824ULL, 0x000fc400078e022fULL,
0x0000000137307824ULL, 0x040fe200078e0230ULL, 0x0000000d2e007388ULL, 0x0007e20000000800ULL,
0x00000001370c7824ULL, 0x042fe400078e0231ULL, 0x0000000137327824ULL, 0x040fe200078e0232ULL,
0x0000000f20007388ULL, 0x0007e20000000800ULL, 0x0000000137227824ULL, 0x040fe400078e0233ULL,
0x0000000137347824ULL, 0x040fe200078e0234ULL, 0x0000001130007388ULL, 0x0007e20000000800ULL,
0x0000000137247824ULL, 0x000fc600078e0235ULL, 0x000000130c007388ULL, 0x0007e80000000800ULL,
0x0000001532007388ULL, 0x0007e80000000800ULL, 0x0000001722007388ULL, 0x0007e80000000800ULL,
0x0000001934007388ULL, 0x0007e80000000800ULL, 0x0000001b24007388ULL, 0x0007e80000000800ULL,
0x01c0000806008388ULL, 0x0007e80000000c00ULL, 0x01c2001c06008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030003037a10ULL, 0x000fe20007ffe0ffULL,
0x01c608003dff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff41ff7812ULL, 0x000fc4000780c0ffULL,
0x000000050300720cULL, 0x000fe40003f26070ULL, 0x00000001ff417807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffae6000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0009ULL,
0x0001f050000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff307424ULL, 0x000fe400078e00ffULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000063000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e002fULL,
0xfffff1d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x000fe200078e0031ULL,
0x0001f0d0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff307424ULL, 0x002fe400078e00ffULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x000005b000007944ULL, 0x024fea0003c00000ULL, 0x0000002f31347209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e000aULL, 0x0001f140000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff307424ULL, 0x002fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000054000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e000bULL,
0x0001f1b0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff307424ULL, 0x002fc400078e00ffULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002f0b2e7209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0032ULL, 0x0001f220000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff307424ULL, 0x002fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000046000007944ULL, 0x000fea0003c00000ULL,
0x0000002f32087209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0034ULL,
0x0001f290000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x002fc400078e00ffULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000002f34097209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e000aULL, 0x0001f300000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff307424ULL, 0x002fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002eULL,
0x0001f370000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x002fc400078e00ffULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0xffffefb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff237224ULL, 0x000fe200078e0030ULL, 0x0001f3d000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fe400078e00ffULL, 0x00001c1fff257424ULL, 0x000fe400078e00ffULL,
0x000002f000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e001fULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff237224ULL, 0x002fe200078e0032ULL,
0x0001f44000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fe400078e00ffULL,
0x00001c1fff257424ULL, 0x000fc400078e00ffULL, 0x0000028000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff247224ULL, 0x002fe200078e00ffULL, 0x0001f49000207802ULL, 0x000fe20000000f00ULL,
0x00001c1fff257424ULL, 0x000fc400078e00ffULL, 0x000000ffff1d7224ULL, 0x004fe400078e001fULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff247224ULL, 0x002fe200078e00ffULL,
0x0001f4e000207802ULL, 0x000fe20000000f00ULL, 0x00001c1fff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e001fULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0xfffff52000007947ULL, 0x000fea000383ffffULL, 0x0180000005047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000500048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000407ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000005057812ULL, 0x002fe400078ec0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000407ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000500047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x00cfe400078e0004ULL, 0x000000ffff047224ULL, 0x000fe400078e000bULL,
0x00000000ff057424ULL, 0x002fc800078e00ffULL, 0xfffe098004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c0000302f2f7389ULL, 0x0002a200000e0033ULL, 0xfffe09400c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff217424ULL, 0x000fe200078e00ffULL, 0x0000002200007348ULL, 0x000fe80003800000ULL,
0x00000024231f7389ULL, 0x0002a200000e0025ULL, 0xfffe090020007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000200ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000798ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000810ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ebcULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ee0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f10ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f88ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f98ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x000000000001f800ULL, 0xff00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020980ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000020990ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020990ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000020e10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001fa00ULL, 0x000000000001fa00ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000020980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000020e10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_80_cubin_len = 134896;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
