/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000021c90ULL, 0x0000000000021810ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001fa40ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001fbb0ULL, 0x0000000000000050ULL, 0x000e002200000131ULL,
0x000000000001fc00ULL, 0x0000000000000050ULL, 0x000e00220000015bULL, 0x000000000001fc50ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001fd80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001fa4000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x007d280400288080ULL, 0x0000000000000000ULL, 0x00000104ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9108288080900828ULL, 0x2880809208288080ULL, 0x8095082880809408ULL, 0x0828808097082880ULL,
0x80809d082880809cULL, 0xa508288080a40828ULL, 0x288080a608288080ULL, 0x80a808288080a708ULL,
0x08288080a9082880ULL, 0x8080ab08288080aaULL, 0xad08288080ac0828ULL, 0x288080ae08288080ULL,
0x80b008288080af08ULL, 0x08288080b1082880ULL, 0x8080b808288080b6ULL, 0xbb08288080b90828ULL,
0x288080c608288080ULL, 0x80df08288080dd08ULL, 0x08288080e8082880ULL, 0x8080f408288080ebULL,
0xfb08288080f50828ULL, 0x288080fc08288080ULL, 0x8181082880818008ULL, 0x0828808182082880ULL,
0x8082801628808084ULL, 0x0000000000031028ULL, 0x2880808492000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001fa4000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x00000114ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8c08288080880828ULL,
0x2880808d08288080ULL, 0x8090082880808e08ULL, 0x0828808091082880ULL, 0x80809a0828808093ULL,
0x9d082880809c0828ULL, 0x2880809e08288080ULL, 0x80a108288080a008ULL, 0x08288080a2082880ULL,
0x8080a408288080a3ULL, 0xa608288080a50828ULL, 0x288080a708288080ULL, 0x80a908288080a808ULL,
0x08288080ab082880ULL, 0x8080b008288080acULL, 0xb608288080b10828ULL, 0x288080b808288080ULL,
0x80bb08288080b908ULL, 0x08288080c6082880ULL, 0x8080df08288080ddULL, 0xeb08288080e80828ULL,
0x288080f408288080ULL, 0x80fb08288080f508ULL, 0x08288080fc082880ULL, 0x8081810828808180ULL,
0x8908288081820828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808089920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x000001a800000000ULL, 0x0001fbb000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8088288080890900ULL, 0x0000000000002880ULL,
0x00000114ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080880828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x0828808090082880ULL, 0x8080930828808091ULL, 0x9c082880809a0828ULL,
0x2880809d08288080ULL, 0x80a0082880809e08ULL, 0x08288080a1082880ULL, 0x8080a308288080a2ULL,
0xa508288080a40828ULL, 0x288080a608288080ULL, 0x80a808288080a708ULL, 0x08288080a9082880ULL,
0x8080ab08288080aaULL, 0xb008288080ac0828ULL, 0x288080b608288080ULL, 0x80b908288080b808ULL,
0x08288080bb082880ULL, 0x8080dd08288080c6ULL, 0xe808288080df0828ULL, 0x288080eb08288080ULL,
0x80f508288080f408ULL, 0x08288080fb082880ULL, 0x80818008288080fcULL, 0x8208288081810828ULL,
0x288080b108288081ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b1ULL,
0x0000002cffffffffULL, 0x0000030000000000ULL, 0x0001fc0000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80a8288080b10900ULL, 0x0000000000002880ULL, 0x00000114ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8908288080880828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL,
0x0828808090082880ULL, 0x8080930828808091ULL, 0x9c082880809a0828ULL, 0x2880809d08288080ULL,
0x80a0082880809e08ULL, 0x08288080a1082880ULL, 0x8080a308288080a2ULL, 0xa608288080a50828ULL,
0x288080a708288080ULL, 0x80a908288080a808ULL, 0x08288080aa082880ULL, 0x8080ac08288080abULL,
0xb108288080b00828ULL, 0x288080b608288080ULL, 0x80b908288080b808ULL, 0x08288080bb082880ULL,
0x8080dd08288080c6ULL, 0xe808288080df0828ULL, 0x288080eb08288080ULL, 0x80f508288080f408ULL,
0x08288080fb082880ULL, 0x80818008288080fcULL, 0x8208288081810828ULL, 0x288080a408288081ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080a4ULL, 0x0000001cffffffffULL,
0x0000045800000000ULL, 0x0001fc5000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL,
0x0000001200082f04ULL, 0x00081204000000f0ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x0001df4000000020ULL, 0x0001e1200001e110ULL,
0x0001e2700001e260ULL, 0x01c829040001e280ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001f0500001fULL,
0x0500001f0500001fULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000e001c82804ULL,
0x00001730000000f0ULL, 0x00001850000017b0ULL, 0x00001c6000001880ULL, 0x00001d0000001c90ULL,
0x0000431000001d70ULL, 0x0000439000004330ULL, 0x000069f0000043f0ULL, 0x00006b2000006a70ULL,
0x00006f0000006c40ULL, 0x00006f8000006f20ULL, 0x000093f000006fe0ULL, 0x0000947000009410ULL,
0x0000b970000094d0ULL, 0x0000baa00000b9f0ULL, 0x0000be800000bbc0ULL, 0x0000bf000000bea0ULL,
0x0000e3500000bf60ULL, 0x0000e3d00000e370ULL, 0x000109b00000e430ULL, 0x00010ae000010a30ULL,
0x00010ec000010c00ULL, 0x00010f4000010ee0ULL, 0x000133d000010fa0ULL, 0x00013450000133f0ULL,
0x00015660000134b0ULL, 0x00015df000015670ULL, 0x00017af000017940ULL, 0x00018120000180e0ULL,
0x0001db0000018940ULL, 0x0001db400001db30ULL, 0x0001db800001db50ULL, 0x0001dbb00001dba0ULL,
0x0001e2500001dbc0ULL, 0x0001e2c00001e2b0ULL, 0x0001e9e00001e2d0ULL, 0x0001ea900001ea20ULL,
0x0001eb800001eb10ULL, 0x0001ec500001ebf0ULL, 0x0001ed100001ecc0ULL, 0x0001edc00001ed50ULL,
0x0001ee800001ee30ULL, 0x0001ef500001eef0ULL, 0x0001f0100001efc0ULL, 0x0001f0c00001f050ULL,
0x0001f1800001f130ULL, 0x0001f2500001f1f0ULL, 0x0001f3100001f2c0ULL, 0x0001f3c00001f350ULL,
0x0001f4800001f430ULL, 0x0001f5500001f4f0ULL, 0x0001f6200001f5c0ULL, 0x0001f6c00001f670ULL,
0x0001f7600001f710ULL, 0x0001f8000001f7b0ULL, 0x0001f8d00001f850ULL, 0x0001f9b00001f950ULL,
0x070039040001fa10ULL, 0x000000ff00000210ULL, 0x003f010000010600ULL, 0x0000000000000250ULL,
0x003f012000010608ULL, 0x00000000000002c0ULL, 0x003f012000010688ULL, 0x0000000000000390ULL,
0x003f0120000106a8ULL, 0x000000ff000003c0ULL, 0x003f0100000106b8ULL, 0x000000ff000004e0ULL,
0x003f010700010600ULL, 0x0000004500000690ULL, 0x003f01020001068cULL, 0x0000004500000740ULL,
0x003f010100010688ULL, 0x000000ff00000c70ULL, 0x003f0107000106a8ULL, 0x000000ff00000cf0ULL,
0x003f0101000106a8ULL, 0x000000ff00000d50ULL, 0x003f0101000106b8ULL, 0x000000ff00000eb0ULL,
0x003f0105000106bcULL, 0x000000ff00000f10ULL, 0x003f0105000106bcULL, 0x000000ff00000f90ULL,
0x003f0105000106bcULL, 0x000000ff000014a0ULL, 0x003f0107000106b0ULL, 0x000000ff00001520ULL,
0x003f0101000106b0ULL, 0x000000ff00001530ULL, 0x003f0105000106acULL, 0x00000045000015a0ULL,
0x003f010100010608ULL, 0x00000045000015c0ULL, 0x003f01050001060cULL, 0x0000004500001650ULL,
0x003f01050001060cULL, 0x000000ff00001b40ULL, 0x003f0105000106acULL, 0x000000ff00001bc0ULL,
0x003f0105000106acULL, 0x000000ff00003c60ULL, 0x003f0101000106b8ULL, 0x000000ff00003c70ULL,
0x003f0105000106bcULL, 0x000000ff00003cc0ULL, 0x003f0105000106bcULL, 0x000000ff00003d40ULL,
0x003f0105000106bcULL, 0x000000ff00004100ULL, 0x003f0107000106a8ULL, 0x000000ff00004180ULL,
0x003f0101000106a8ULL, 0x000000ff00004190ULL, 0x003f0105000106b4ULL, 0x000000ff000041f0ULL,
0x003f0105000106b4ULL, 0x000000ff00004270ULL, 0x003f0105000106b4ULL, 0x000000ff00006200ULL,
0x003f0101000106b8ULL, 0x000000ff00006270ULL, 0x003f010100010688ULL, 0x000000ff000062a0ULL,
0x003f0105000106bcULL, 0x000000ff000062f0ULL, 0x003f0105000106bcULL, 0x000000ff00006370ULL,
0x003f0105000106bcULL, 0x000000ff000067b0ULL, 0x003f0107000106b0ULL, 0x000000ff00006830ULL,
0x003f0101000106b0ULL, 0x000000ff00006840ULL, 0x003f0105000106acULL, 0x00000045000068b0ULL,
0x003f010100010628ULL, 0x00000045000068d0ULL, 0x003f01050001062cULL, 0x0000004500006960ULL,
0x003f01050001062cULL, 0x000000ff00006df0ULL, 0x003f0105000106acULL, 0x000000ff00006e70ULL,
0x003f0105000106acULL, 0x000000ff00008d70ULL, 0x003f0101000106b8ULL, 0x000000ff00008d80ULL,
0x003f0105000106bcULL, 0x000000ff00008dd0ULL, 0x003f0105000106bcULL, 0x000000ff00008e50ULL,
0x003f0105000106bcULL, 0x000000ff000091e0ULL, 0x003f0107000106a8ULL, 0x000000ff00009260ULL,
0x003f0101000106a8ULL, 0x000000ff00009270ULL, 0x003f0105000106b4ULL, 0x000000ff000092e0ULL,
0x003f0105000106b4ULL, 0x000000ff00009360ULL, 0x003f0105000106b4ULL, 0x000000ff0000b250ULL,
0x003f0101000106b8ULL, 0x000000ff0000b2c0ULL, 0x003f010100010690ULL, 0x000000ff0000b2f0ULL,
0x003f0105000106bcULL, 0x000000ff0000b340ULL, 0x003f0105000106bcULL, 0x000000ff0000b3c0ULL,
0x003f0105000106bcULL, 0x000000ff0000b730ULL, 0x003f0107000106b0ULL, 0x000000ff0000b7b0ULL,
0x003f0101000106b0ULL, 0x000000ff0000b7c0ULL, 0x003f0105000106acULL, 0x000000450000b830ULL,
0x003f010100010648ULL, 0x000000450000b850ULL, 0x003f01050001064cULL, 0x000000450000b8e0ULL,
0x003f01050001064cULL, 0x000000ff0000bd70ULL, 0x003f0105000106acULL, 0x000000ff0000bdf0ULL,
0x003f0105000106acULL, 0x000000ff0000dd00ULL, 0x003f0101000106b8ULL, 0x000000ff0000dd10ULL,
0x003f0105000106bcULL, 0x000000ff0000dd60ULL, 0x003f0105000106bcULL, 0x000000ff0000dde0ULL,
0x003f0105000106bcULL, 0x000000ff0000e150ULL, 0x003f0107000106a8ULL, 0x000000ff0000e1d0ULL,
0x003f0101000106a8ULL, 0x000000ff0000e1e0ULL, 0x003f0105000106b4ULL, 0x000000ff0000e240ULL,
0x003f0105000106b4ULL, 0x000000ff0000e2c0ULL, 0x003f0105000106b4ULL, 0x000000ff000101b0ULL,
0x003f0101000106b8ULL, 0x000000ff00010220ULL, 0x003f010100010698ULL, 0x000000ff00010250ULL,
0x003f0105000106bcULL, 0x000000ff000102a0ULL, 0x003f0105000106bcULL, 0x000000ff00010320ULL,
0x003f0105000106bcULL, 0x000000ff00010770ULL, 0x003f0107000106b0ULL, 0x000000ff000107f0ULL,
0x003f0101000106b0ULL, 0x000000ff00010800ULL, 0x003f0105000106acULL, 0x0000004500010870ULL,
0x003f010100010668ULL, 0x0000004500010890ULL, 0x003f01050001066cULL, 0x0000004500010920ULL,
0x003f01050001066cULL, 0x000000ff00010db0ULL, 0x003f0105000106acULL, 0x000000ff00010e30ULL,
0x003f0105000106acULL, 0x000000ff00012d40ULL, 0x003f0101000106b8ULL, 0x000000ff00012d50ULL,
0x003f0105000106bcULL, 0x000000ff00012da0ULL, 0x003f0105000106bcULL, 0x000000ff00012e20ULL,
0x003f0105000106bcULL, 0x000000ff000131d0ULL, 0x003f0107000106a8ULL, 0x000000ff00013250ULL,
0x003f0101000106a8ULL, 0x000000ff00013260ULL, 0x003f0105000106b4ULL, 0x000000ff000132c0ULL,
0x003f0105000106b4ULL, 0x000000ff00013340ULL, 0x003f0105000106b4ULL, 0x000000ff00015230ULL,
0x003f0101000106b8ULL, 0x000000ff00015290ULL, 0x003f0101000106a0ULL, 0x000000ff00018d10ULL,
0x003f010100010600ULL, 0x000000ff00019aa0ULL, 0x003f010500010604ULL, 0x000000ff00019b40ULL,
0x003f010500010604ULL, 0x000000ff00019e60ULL, 0x003f010100010600ULL, 0x000000ff00019e70ULL,
0x003f010500010604ULL, 0x000000ff00019f00ULL, 0x003f010500010604ULL, 0x0000003b0001cf80ULL,
0x003f010100000000ULL, 0x0000003b0001cfc0ULL, 0x003f010500000004ULL, 0x0000003b0001d400ULL,
0x003f010500000004ULL, 0x0000003d0001e840ULL, 0x003f010100000000ULL, 0x0000003d0001e8a0ULL,
0x003f010100000008ULL, 0x0000003d0001e900ULL, 0x003f010100000010ULL, 0x0000003d0001e970ULL,
0x003f010100000018ULL, 0x00101c0400053803ULL, 0x00019f6000018b90ULL, 0x0001e9b00001a010ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000058cULL, 0x0000001200000002ULL,
0x0000000000000434ULL, 0x0000001200000002ULL, 0x00000000000002dcULL, 0x0000001200000002ULL,
0x0000000000000194ULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x0000000000000567ULL, 0x0000001200000002ULL, 0x000000000000040fULL, 0x0000001200000002ULL,
0x00000000000002b2ULL, 0x0000001200000002ULL, 0x000000000000016bULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x00005800ff377624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000007919ULL, 0x000ea20000002300ULL,
0x0000000e00057300ULL, 0x000ee600000e0000ULL, 0x0000000000027919ULL, 0x000f280000002200ULL,
0x0000000000437919ULL, 0x000f620000002600ULL, 0x0000000e00107309ULL, 0x0002a60000000000ULL,
0x00000000003a7919ULL, 0x000ee80000002700ULL, 0x0000000000067919ULL, 0x000ee20000000000ULL,
0x00000005ff427819ULL, 0x002fc60000011603ULL, 0x0000000000447919ULL, 0x000e680000000000ULL,
0x00001fff000a7589ULL, 0x0049e800000e0000ULL, 0x00001fff42427589ULL, 0x000ea200000e0000ULL,
0x0000000100007824ULL, 0x010fe400078e0202ULL, 0x0000000843027824ULL, 0x020fc400078e00ffULL,
0x0000008000007824ULL, 0x000fe400078e0203ULL, 0x0000000837037824ULL, 0x000fe200078e00ffULL,
0x000000060500720cULL, 0x008fe40003f02070ULL, 0x000000ff0000720cULL, 0x040fe20003f25270ULL,
0x0000003a03087224ULL, 0x000fe200078e0202ULL, 0x0000000f0000780cULL, 0x040fe40003f44070ULL,
0x0000007f0000780cULL, 0x040fe40003f84070ULL, 0x000000030000780cULL, 0x000fe20003f64070ULL,
0x000000040a047824ULL, 0x004fcc00078e0242ULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x0000000204097824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x00000008090b7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL, 0x01060002ff009388ULL, 0x0005e20000000a00ULL,
0xff317217ff0cc424ULL, 0x000fe200078e00ffULL, 0x00000001090d7810ULL, 0x000fe20007ffe0ffULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x010608040000a388ULL, 0x0007e20000008a00ULL,
0x000000010000780cULL, 0x000fe20003f44070ULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x000000070d0e7812ULL, 0x000fe200078ec0ffULL, 0x0104000c0000c388ULL, 0x0009e20000004800ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a09ULL, 0x0000000709027812ULL, 0x004fc400078ec0ffULL,
0x010688060000b388ULL, 0x0005e20000008a00ULL, 0x0000001f0e0e7812ULL, 0x102fe400078e7844ULL,
0x0000001f02037812ULL, 0x000fe200078e7844ULL, 0x0000000108027824ULL, 0x040fe200078e0209ULL,
0x000000ff0b00720cULL, 0x040fe20003f63070ULL, 0x0000000108047824ULL, 0x008fe200078e020dULL,
0x000000010b00780cULL, 0x000fe20003f83070ULL, 0x00000020090c7824ULL, 0x010fe400078e0203ULL,
0x3fffff80ff089424ULL, 0x000fc400078e00ffULL, 0x3fffff00ff06a424ULL, 0x004fe400078e00ffULL,
0x7fffff00ff07a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff099424ULL, 0x000fe400078e00ffULL,
0x00000200ff057424ULL, 0x000fe200078e00ffULL, 0x0106a8060000a388ULL, 0x0003e20000008a00ULL,
0x00000010440b7824ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x080fe200078e0005ULL,
0x0106b808ff009388ULL, 0x0005e40000000a00ULL, 0x000001f00b0f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0004047625ULL, 0x000fe200078e0005ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000f02027210ULL, 0x080fe20007fbe0ffULL, 0x000000200d0e7824ULL, 0x000fe200078e020eULL,
0x0000000f04047210ULL, 0x000fe20007f5e0ffULL, 0x000000100c0c7824ULL, 0x000fc400078e00ffULL,
0x000000ffff037224ULL, 0x000fe400028e0603ULL, 0x000000ffff057224ULL, 0x000fe400010e0605ULL,
0x000000100e0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x002fe400078e0a10ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020c7faeULL, 0x0003e8000d901c46ULL, 0x00000000040e7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x01060400ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x000062003a027625ULL, 0x000fc600078e0006ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000602417981ULL, 0x004ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x00000004ff407e24ULL, 0x002fe2000f8e00ffULL, 0x0000007f41037810ULL, 0x044fe40007ffe0ffULL,
0x000000ff41027810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff037819ULL, 0x000fe40000011603ULL,
0x00000008ff027819ULL, 0x000fca0000011602ULL, 0x000185a000008947ULL, 0x000fea0003800000ULL,
0x00000002404c7824ULL, 0x000fe400078e00ffULL, 0x0000000842457824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x000000034c00720cULL, 0x000fe20003f06070ULL,
0xffffffffff6d7424ULL, 0x000fd800078e00ffULL, 0x000064004c048a10ULL, 0x000fe20007ffe0ffULL,
0x000000023a008824ULL, 0x000fc800078e00ffULL, 0x0000640000048a24ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c0545ff738cULL, 0x0003e40000000000ULL,
0x0000600004048625ULL, 0x002fe400078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006046d8981ULL, 0x0002a2000c1e1900ULL, 0x0000000140007810ULL, 0x000fe20007ffe0ffULL,
0xff317217ff467424ULL, 0x000fe200078e00ffULL, 0x000000f00b0b7812ULL, 0x000fe200078ec0ffULL,
0x0106880045ff7f8cULL, 0x0007e2000c80043fULL, 0x000000020000720cULL, 0x000fe20003f06070ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000004ff057819ULL, 0x002fe20000011644ULL, 0x0000010040047824ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000205087810ULL, 0x040fe20007ffe0ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000004050a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000441007217ULL, 0x000fe20007800000ULL, 0x0000000145067824ULL, 0x000fe200078e0208ULL,
0x00000006050d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001450c7824ULL, 0x000fc400078e020aULL,
0x0000000100007824ULL, 0x000fe200078e0a04ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x00000001450e7824ULL, 0x000fe200078e020dULL, 0x000000070c047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000f07077812ULL, 0x100fe400078e7844ULL,
0x0000000f04047812ULL, 0x000fe400078e7844ULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x0000001006097824ULL, 0x000fe200078e0207ULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000145067824ULL, 0x000fc400078e0205ULL, 0x000000100c0c7824ULL, 0x000fe200078e0204ULL,
0x0000000045047217ULL, 0x000fe40007800000ULL, 0x0000000706077812ULL, 0x000fe400078ec0ffULL,
0x0000000f0f0f7812ULL, 0x100fe200078e7844ULL, 0x0000000104047824ULL, 0x000fe200078e0a45ULL,
0x0000000f07077812ULL, 0x000fe400078e7844ULL, 0x0000c0000c0c7811ULL, 0x000fe200078e20ffULL,
0x000000100e0f7824ULL, 0x000fe200078e020fULL, 0x000000040500720cULL, 0x080fe20003f26070ULL,
0x0000001006077824ULL, 0x000fe200078e0207ULL, 0x000000040a00720cULL, 0x080fe20003f06070ULL,
0x0000008043067824ULL, 0x000fe200078e0206ULL, 0x000000040800720cULL, 0x000fc40003f46070ULL,
0x0000c0000f0f7811ULL, 0x000fe400078e20ffULL, 0x0000000206057810ULL, 0x040fe40007ffe0ffULL,
0x0000000406087810ULL, 0x000fe20007ffe0ffULL, 0x000058006d007a24ULL, 0x004fc800078e02ffULL,
0x0000008000007824ULL, 0x000fca00078e00ffULL, 0x0000000600137210ULL, 0x040fe40007f7e0ffULL,
0x0000000500057210ULL, 0x000fe40007f9e0ffULL, 0x0000000606067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078640ffULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x00005e0005107a11ULL, 0x000fe400078840ffULL,
0x00005f0013137a11ULL, 0x000fc400018f440aULL, 0x00000008000e7210ULL, 0x040fe40007f7e0ffULL,
0x0000000600067210ULL, 0x000fe40007fbe0ffULL, 0x00005f0005117a11ULL, 0x000fe200020f4411ULL,
0x000000ffff057224ULL, 0x000fe200018e06ffULL, 0x00005e000e087a11ULL, 0x000fe200078840ffULL,
0x000000ffff007224ULL, 0x000fe200028e06ffULL, 0x00005e00060a7a11ULL, 0x000fe400078a40ffULL,
0x000000040d00720cULL, 0x000fc40003f66070ULL, 0x00005f000e0e7a11ULL, 0x000fe400020f4405ULL,
0x00005f00060d7a11ULL, 0x000fe400028f4400ULL, 0x000000120b047210ULL, 0x000fe40007f9e0ffULL,
0x0000000b10067210ULL, 0x080fe40007fbe0ffULL, 0x0000c00007007811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200020e0613ULL, 0x0000000b08087210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff077224ULL, 0x000fe200028e0611ULL, 0x0000000b0a0a7210ULL, 0x000fc40007fbe0ffULL,
0x0000c000090b7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004007faeULL, 0x0003e2000c901c46ULL, 0x000000ffff097224ULL, 0x000fc600020e060eULL,
0x00000000060b7faeULL, 0x0005e8000d101c46ULL, 0x00000000080c7faeULL, 0x0007e2000c101c46ULL,
0x000000024000720cULL, 0x000fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x004fca00028e060dULL,
0x000000000a0f7faeULL, 0x0007e8000d901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff247f8cULL, 0x000ea2000c80043fULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x008fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000144e000000947ULL, 0x000fea0003800000ULL,
0x0000000442487824ULL, 0x000fe400078e00ffULL, 0x000000023a3a7824ULL, 0x000fc400078e00ffULL,
0x00006400ff497624ULL, 0x000fe200078e00ffULL, 0x00000002484a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x002fe400078e0031ULL, 0x000064003a497624ULL, 0x000fe400078e0249ULL,
0xff317217ff467424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe400078e00ffULL,
0x0000010040007824ULL, 0x000fca00078e00ffULL, 0x000000410000720cULL, 0x000fda0003f06070ULL,
0x000143f000000947ULL, 0x006fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x006fe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff517224ULL, 0x000fe200078e004cULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff277819ULL, 0x000fe20000011644ULL, 0x000058006d3c7a24ULL, 0x000fe200078e02ffULL,
0x0000002043257811ULL, 0x000fe200078e38ffULL, 0x0000001044637824ULL, 0x000fe200078e00ffULL,
0x0000000140007810ULL, 0x040fe20007ffe0ffULL, 0x00000001455b7824ULL, 0x000fe200078e0227ULL,
0x0000002040247811ULL, 0x000fe200078e40ffULL, 0x000000803c3c7824ULL, 0x000fe200078e00ffULL,
0x000000020000720cULL, 0x000fe20003f06070ULL, 0x000000015b267824ULL, 0x040fe200078e0225ULL,
0x000000075b287812ULL, 0x000fc400078ec0ffULL, 0x0000002441007217ULL, 0x000fe40007800000ULL,
0x00000002275c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000f28287812ULL, 0x000fe200078e7844ULL,
0x0000000100007824ULL, 0x000fe200078e0a24ULL, 0x000000263c267210ULL, 0x000fe20007f3e0ffULL,
0x0000000145247824ULL, 0x000fe200078e025cULL, 0x00000004272e7810ULL, 0x000fe20007ffe0ffULL,
0x000000105b5b7824ULL, 0x000fe200078e0228ULL, 0x00000006272f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e06ffULL, 0x00005e0026287a11ULL, 0x000fe200078240ffULL,
0x00000001452a7824ULL, 0x040fe200078e022eULL, 0x0000000724297812ULL, 0x000fe200078ec0ffULL,
0x0000000145587824ULL, 0x000fe200078e022fULL, 0x00005f00262d7a11ULL, 0x000fc400008f442dULL,
0x000000072a267812ULL, 0x000fe400078ec0ffULL, 0x0000000f29297812ULL, 0x100fe400078e7844ULL,
0x0000000f26267812ULL, 0x000fe400078e7844ULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x00000010245a7824ULL, 0x000fe200078e0229ULL, 0x0000000758297812ULL, 0x000fe200078ec0ffULL,
0x0000000124247824ULL, 0x100fe200078e0225ULL, 0x0000000045007217ULL, 0x000fe20007800000ULL,
0x000000102a597824ULL, 0x040fe200078e0226ULL, 0x0000000f29297812ULL, 0x000fe200078e7844ULL,
0x000000012a267824ULL, 0x000fe200078e0225ULL, 0x000000243c247210ULL, 0x000fe20007f3e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a45ULL, 0x000000f0634d7812ULL, 0x000fe200078ec0ffULL,
0x0000000158257824ULL, 0x000fe200078e0225ULL, 0x000000263c2a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200008e06ffULL, 0x00005e00242b7a11ULL, 0x000fe200078440ffULL,
0x0000001058587824ULL, 0x000fe200078e0229ULL, 0x000000002700720cULL, 0x000fe20003f26070ULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x00005e002a297a11ULL, 0x000fc400078a40ffULL,
0x000000253c267210ULL, 0x000fe40007fde0ffULL, 0x00005f00242c7a11ULL, 0x000fe400010f442cULL,
0x0000004d28247210ULL, 0x000fe40007f9e0ffULL, 0x00005f002a2a7a11ULL, 0x000fe200028f4427ULL,
0x000000ffff277224ULL, 0x000fe200030e06ffULL, 0x00005e0026287a11ULL, 0x000fe200078a40ffULL,
0x000000ffff257224ULL, 0x000fe200020e062dULL, 0x000000002e00720cULL, 0x000fc40003f46070ULL,
0x000000002f00720cULL, 0x080fe40003f66070ULL, 0x000000005c00720cULL, 0x000fe40003f86070ULL,
0x0000e0005b677811ULL, 0x000fe400078e20ffULL, 0x00005f0026007a11ULL, 0x000fe400028f4427ULL,
0x0000004d2b267210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024677faeULL, 0x0003e2000c901c46ULL, 0x0000e0005a667811ULL, 0x000fc400078e20ffULL,
0x0000e00059657811ULL, 0x000fe200078e20ffULL, 0x000000ffff277224ULL, 0x000fe200028e062cULL,
0x0000004d28287210ULL, 0x080fe40007fbe0ffULL, 0x0000e00058647811ULL, 0x000fe400078e20ffULL,
0x0000000026667faeULL, 0x0005e2000e101c46ULL, 0x0000004d29247210ULL, 0x002fe20007f3e0ffULL,
0x000000ffff297224ULL, 0x000fc800028e0600ULL, 0x000000ffff257224ULL, 0x000fca00008e062aULL,
0x0000000024657faeULL, 0x0005e8000d101c46ULL, 0x0000000028647faeULL, 0x0005e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff387f8cULL, 0x000e68000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080045247f8cULL, 0x004fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc60007844830ULL,
0x01060c0045267984ULL, 0x000ea40000000800ULL, 0x8000000026ff7812ULL, 0x004fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x01060c0045267984ULL, 0x000ea40000000800ULL,
0x8000000026ff7812ULL, 0x004fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff007819ULL, 0x000fe20000011644ULL, 0xffffffffff627424ULL, 0x000fe200078e00ffULL,
0x0000007063637812ULL, 0x000fe400078ec0ffULL, 0x0000000c00007812ULL, 0x000fca00078ec0ffULL,
0x0000000163637824ULL, 0x000fca00078e0200ULL, 0x0100000063267984ULL, 0x000ea80000000800ULL,
0x0102000063277984ULL, 0x0007220000000800ULL, 0x000000462600720bULL, 0x004fe20003f3d000ULL,
0x0001d2927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff00287812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff787424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff4200720cULL, 0x000fe40003f65270ULL, 0x000000462600720bULL, 0x000fe20003f34000ULL,
0x0001d2527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x00000026462c7209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fc600078e3cffULL,
0x0104002c6300b388ULL, 0x0005e20000000800ULL, 0x8000002c46247221ULL, 0x000fe20000010000ULL,
0x0000000028ff7212ULL, 0x000fc6000782c0ffULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024002d7308ULL, 0x0007240000000800ULL, 0x00000002ff247819ULL, 0x008fe20000011644ULL,
0x0001d1f27f007947ULL, 0x000fea000b800000ULL, 0x00001f242d257589ULL, 0x0144e400000e0000ULL,
0x0000000824247810ULL, 0x004fe20007ffe0ffULL, 0x0001d2427f007947ULL, 0x000fea000b800000ULL,
0x00001f242d247589ULL, 0x00052400000e0000ULL, 0x8000002c26261221ULL, 0x100fe20000010000ULL,
0x0000002d47477220ULL, 0x000fe20000410000ULL, 0x0000002423237220ULL, 0x090fe20000410000ULL,
0x0000002422227220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x00000026004b1308ULL, 0x000f220000000800ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x0000002407077220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x000fe20000410000ULL, 0x00000001ff787807ULL, 0x000fe20000800000ULL,
0x0000002521217220ULL, 0x088fe20000410000ULL, 0x0000002520207220ULL, 0x080fe20000410000ULL,
0x000000251d1d7220ULL, 0x080fe20000410000ULL, 0x000000251c1c7220ULL, 0x080fe20000410000ULL,
0x0000002519197220ULL, 0x080fe20000410000ULL, 0x0000002518187220ULL, 0x080fe20000410000ULL,
0x0000002515157220ULL, 0x080fe20000410000ULL, 0x0000002514147220ULL, 0x080fe20000410000ULL,
0x0000002509097220ULL, 0x080fe20000410000ULL, 0x0000002508087220ULL, 0x080fe20000410000ULL,
0x0000002505057220ULL, 0x080fe20000410000ULL, 0x0000002504047220ULL, 0x080fe20000410000ULL,
0x0000002511117220ULL, 0x080fe20000410000ULL, 0x0000002510107220ULL, 0x080fe20000410000ULL,
0x000000250d0d7220ULL, 0x080fe20000410000ULL, 0x000000250c0c7220ULL, 0x000fe20000410000ULL,
0x000000ffff467224ULL, 0x000fe200078e002cULL, 0x0000004b27271220ULL, 0x010fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000004727477221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc40007824830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000240000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff247984ULL, 0x000ee40000000800ULL, 0x8000000024ff7812ULL, 0x008fe40007824830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004bff00723eULL, 0x000fe400000010ffULL,
0x00000004ff5d7819ULL, 0x000fc40000011644ULL, 0x00000002ff507819ULL, 0x000fe40000011644ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0001cee27f007947ULL, 0x000fea000b800000ULL,
0x00001f5000757589ULL, 0x00072400000e0000ULL, 0x00000008504e7810ULL, 0x000fe20007ffe0ffULL,
0x0001cf227f007947ULL, 0x000fea000b800000ULL, 0x00001f4e00747589ULL, 0x0004e400000e0000ULL,
0x00000010504f7810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e004fULL, 0x00001d1000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0001def000007944ULL, 0x01efea0003c00000ULL, 0x0000001850507810ULL, 0x008fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0050ULL,
0x00001d8000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0001de8000007944ULL, 0x016fea0003c00000ULL,
0x0000000844007812ULL, 0x044fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000004844247211ULL, 0x000fe400078fe0ffULL, 0x0000000700257812ULL, 0x140fe400078ec844ULL,
0x0000000700007812ULL, 0x000fe400078ef844ULL, 0x0000002425247212ULL, 0x000fe400078e3cffULL,
0x0000004a44267211ULL, 0x000fc600078fe0ffULL, 0x0000001000577824ULL, 0x000fe200078e0224ULL,
0x0000002625547212ULL, 0x000fc800078e3cffULL, 0x0000c00057617811ULL, 0x000fe200078e20ffULL,
0x0000001000567824ULL, 0x040fe200078e0254ULL, 0x0000010000007811ULL, 0x000fc600078e20ffULL,
0x000000006130783bULL, 0x000ea20000004200ULL, 0x0000c00056607811ULL, 0x000fe200078e20ffULL,
0x0000000124557824ULL, 0x100fe400078e0200ULL, 0x0000000154547824ULL, 0x000fe400078e0200ULL,
0x000000006028783bULL, 0x000ee20000004200ULL, 0x0000c000555f7811ULL, 0x000fe400078e20ffULL,
0x0000c000545e7811ULL, 0x000fc600078e20ffULL, 0x000000005f24783bULL, 0x000f680000004200ULL,
0x000000005e2c783bULL, 0x000f220000004200ULL, 0x0000010030d77824ULL, 0x044fe200078e00ffULL,
0x0000003000807306ULL, 0x000fe20000009400ULL, 0x0000010031db7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe20000011430ULL, 0x0001000030e57824ULL, 0x000fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fe200000114d7ULL, 0x0001000031dc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x0000010032bb7824ULL, 0x000fe200078e00ffULL,
0x000000d700d57306ULL, 0x000fe20000209400ULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x0000010028bf7824ULL, 0x048fe200078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe200000114dcULL,
0x0000010029be7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0001000028c57824ULL, 0x000fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fe20000011431ULL,
0x000000d700d67306ULL, 0x0004e20000205400ULL, 0x00000018ffb67819ULL, 0x000fe20000011432ULL,
0x0000010033bc7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe20000011433ULL,
0x0001000033c07824ULL, 0x000fe200078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x0001000029cd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe200000114beULL,
0x0000003000d37306ULL, 0x000e620000005400ULL, 0x000000d700d77245ULL, 0x004fe2000020d400ULL,
0x000001002acb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x000001002bc67824ULL, 0x000fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe20000011428ULL,
0x0000010026d87824ULL, 0x020fe200078e00ffULL, 0x00000018ffbc7819ULL, 0x000fe200000114bcULL,
0x000000e000e47306ULL, 0x000fe20000209400ULL, 0x000000d6d500720bULL, 0x008fe20003f5d000ULL,
0x0000010027da7824ULL, 0x040fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x0001000027797824ULL, 0x000fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x0000010025eb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe20000011429ULL,
0x000000e000e37306ULL, 0x0004e20000205400ULL, 0x000000d38000720bULL, 0x002fe20003fbd000ULL,
0x000100002dd37824ULL, 0x010fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe200000114c0ULL,
0x0001000024ed7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x0001000025e87824ULL, 0x000fe200078e00ffULL, 0x00000001d7d72812ULL, 0x000fe200078efcffULL,
0x000000db00e97306ULL, 0x000fe20000209400ULL, 0x000000e000e07245ULL, 0x004fe2000020d400ULL,
0x000100002e807824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fc4000001142aULL,
0x00000018ff907819ULL, 0x000fe4000001142bULL, 0x00000018ff687819ULL, 0x000fe20000011426ULL,
0x000000db00ea7306ULL, 0x0002a20000205400ULL, 0x000000e3e400720bULL, 0x008fe40003f7d000ULL,
0x00000018ff3b7819ULL, 0x000fe40000011427ULL, 0x00000018ff377819ULL, 0x000fe4000001142cULL,
0x00000018ff767819ULL, 0x000fe2000001142dULL, 0x0000003000927306ULL, 0x000722000000d400ULL,
0x000000db00db7245ULL, 0x002fc4000020d400ULL, 0x00000018ff997819ULL, 0x000fe40000011424ULL,
0x00000018ffeb7819ULL, 0x000fe400000114ebULL, 0x00000001e0e03812ULL, 0x000fe200078efcffULL,
0x000000e500ec7306ULL, 0x000fe20000209400ULL, 0x000000eae900720bULL, 0x004fe40003f5d000ULL,
0x0000991078307816ULL, 0x008fe200000000ffULL, 0x0000010024787824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fc40000011425ULL, 0x000000ff3000720cULL, 0x000fe20003f25270ULL,
0x000000e500d97306ULL, 0x0002a20000205400ULL, 0x0000000192925812ULL, 0x010fe200078efcffULL,
0x0001000026307824ULL, 0x000fe200078e00ffULL, 0x00000018ffd57819ULL, 0x000fe20000011478ULL,
0x000100002f787824ULL, 0x000fe200078e00ffULL, 0x00000018ff007819ULL, 0x000fe4000001142eULL,
0x00000001dbdb2812ULL, 0x000fe200078efcffULL, 0x000000dc00e67306ULL, 0x000fe20000209400ULL,
0x000000e500e57245ULL, 0x002fc4000020d400ULL, 0x00000018ff3a7819ULL, 0x000fe4000001142fULL,
0x00000018ffd87819ULL, 0x000fe400000114d8ULL, 0x00000018ffe87819ULL, 0x000fe200000114e8ULL,
0x000000dc00e77306ULL, 0x0002e20000205400ULL, 0x000000d9ec00720bULL, 0x004fe20003fdd000ULL,
0x000001002cd97824ULL, 0x000fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fe400000114daULL,
0x00000018ffd37819ULL, 0x000fc400000114d3ULL, 0x00000018ffd97819ULL, 0x000fe200000114d9ULL,
0x0000003200a77306ULL, 0x000fe20000009400ULL, 0x000000dc00dc7245ULL, 0x002fe4000020d400ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x00000001e5e56812ULL, 0x000fe200078efcffULL, 0x0000003200ac7306ULL, 0x000e620000005400ULL,
0x000000e7e600720bULL, 0x008fc40003fbd000ULL, 0x00000018ff787819ULL, 0x000fca0000011478ULL,
0x000000bb00dd7306ULL, 0x000fec0000209400ULL, 0x00000001dcdc5812ULL, 0x000fe400078efcffULL,
0x000000bb00de7306ULL, 0x0004e20000205400ULL, 0x000000aca700720bULL, 0x002fce0003f7d000ULL,
0x0000003300a67306ULL, 0x000fe20000009400ULL, 0x000000bb00bb7245ULL, 0x004fce000020d400ULL,
0x0000003300a47306ULL, 0x000e620000005400ULL, 0x000000dedd00720bULL, 0x008fce0003f5d000ULL,
0x000000b900ba7306ULL, 0x000fec0000209400ULL, 0x00000001bbbb2812ULL, 0x000fe400078efcffULL,
0x000000b900527306ULL, 0x0004e20000205400ULL, 0x000000a4a600720bULL, 0x002fce0003fbd000ULL,
0x0000003100e27306ULL, 0x000fe20000009400ULL, 0x000000b900b97245ULL, 0x004fce000020d400ULL,
0x0000003100e17306ULL, 0x000e620000005400ULL, 0x00000052ba00720bULL, 0x008fe40003fdd000ULL,
0x0000000744527812ULL, 0x000fc800078ec0ffULL, 0x0000000852527812ULL, 0x000fe200078ef844ULL,
0x0000003100917306ULL, 0x0004e6000000d400ULL, 0x000000075d5d7812ULL, 0x100fe400078e7852ULL,
0x000000075c5c7812ULL, 0x000fe400078e7852ULL, 0x00000001b9b96812ULL, 0x000fe200078efcffULL,
0x0000003200847306ULL, 0x000f22000000d400ULL, 0x0001000032317824ULL, 0x004fe200078e00ffULL,
0x000000e1e200720bULL, 0x002fe20003f9d000ULL, 0x00000008525d7824ULL, 0x040fe200078e025dULL,
0x00000018ffe17819ULL, 0x000fe200000114edULL, 0x00000008525c7824ULL, 0x000fe200078e025cULL,
0x00000018ff317819ULL, 0x000fc40000011431ULL, 0x000000b6009f7306ULL, 0x000fee0000209400ULL,
0x0000000191914812ULL, 0x008fe200078efcffULL, 0x000000b600ab7306ULL, 0x0002a20000205400ULL,
0x0000000184843812ULL, 0x010fe400078efcffULL, 0x00000091db91723eULL, 0x000fc400000010ffULL,
0x00000084bb84723eULL, 0x000fc600000010ffULL, 0x000000b400b77306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x002fce000020d400ULL, 0x000000b400b87306ULL, 0x0002e20000205400ULL,
0x000000ab9f00720bULL, 0x004fce0003f5d000ULL, 0x0000003300837306ULL, 0x000ea2000000d400ULL,
0x000000b400b47245ULL, 0x002fca000020d400ULL, 0x00000001b6b62812ULL, 0x000fe400078efcffULL,
0x0000003100c47306ULL, 0x000fe20000209400ULL, 0x000000b8b700720bULL, 0x008fce0003f7d000ULL,
0x0000003100d27306ULL, 0x0002e20000205400ULL, 0x0000000183835812ULL, 0x004fca00078efcffULL,
0x00000001b4b43812ULL, 0x000fe400078efcffULL, 0x000000bf00c17306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fce000020d400ULL, 0x000000bf00327306ULL, 0x0002a20000205400ULL,
0x000000d2c400720bULL, 0x008fce0003fdd000ULL, 0x000000be00337306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x002fca000020d400ULL, 0x0000000131316812ULL, 0x000fe400078efcffULL,
0x000000be00c77306ULL, 0x0002e20000205400ULL, 0x00000032c100720bULL, 0x004fce0003fbd000ULL,
0x000000c500c87306ULL, 0x000fe20000209400ULL, 0x000000be00be7245ULL, 0x002fca000020d400ULL,
0x00000001bfbf5812ULL, 0x000fe400078efcffULL, 0x000000c500ca7306ULL, 0x0002a20000205400ULL,
0x000000c73300720bULL, 0x008fce0003f5d000ULL, 0x0000002800b57306ULL, 0x000fe20000009400ULL,
0x000000c500c57245ULL, 0x002fca000020d400ULL, 0x00000001bebe2812ULL, 0x000fe400078efcffULL,
0x0000002800aa7306ULL, 0x000e620000005400ULL, 0x000000cac800720bULL, 0x004fce0003f7d000ULL,
0x000000af00b27306ULL, 0x000fec0000209400ULL, 0x00000001c5c53812ULL, 0x000fe400078efcffULL,
0x000000af00a07306ULL, 0x0004e20000205400ULL, 0x000000aab500720bULL, 0x002fce0003fdd000ULL,
0x000000bc00bd7306ULL, 0x000fe20000209400ULL, 0x000000af00af7245ULL, 0x004fce000020d400ULL,
0x000000bc00df7306ULL, 0x0002a20000205400ULL, 0x000000a0b200720bULL, 0x008fce0003fbd000ULL,
0x000000cd00cf7306ULL, 0x000fe20000209400ULL, 0x000000bc00bc7245ULL, 0x002fca000020d400ULL,
0x00000001afaf5812ULL, 0x000fe400078efcffULL, 0x000000cd00d07306ULL, 0x0002e20000205400ULL,
0x000000dfbd00720bULL, 0x004fce0003f9d000ULL, 0x000000cb00ce7306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x002fca000020d400ULL, 0x00000001bcbc4812ULL, 0x000fe400078efcffULL,
0x000000cb00c97306ULL, 0x0002a20000205400ULL, 0x000000d0cf00720bULL, 0x008fce0003f5d000ULL,
0x0000002900b37306ULL, 0x000fe20000009400ULL, 0x000000cb00cb7245ULL, 0x002fca000020d400ULL,
0x00000001cdcd2812ULL, 0x000fe400078efcffULL, 0x0000002900a17306ULL, 0x000fe20000005400ULL,
0x000000c9ce00720bULL, 0x004fce0003f7d000ULL, 0x00000029007a7306ULL, 0x0003ec000000d400ULL,
0x00000001cbcb3812ULL, 0x000fe400078efcffULL, 0x00000028007d7306ULL, 0x0004e2000000d400ULL,
0x000100002a297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00b17306ULL, 0x000fe20000009400ULL, 0x000100002b287824ULL, 0x004fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002a00a97306ULL, 0x000e620000005400ULL,
0x000000017d7d6812ULL, 0x008fce00078efcffULL, 0x0000002b00a27306ULL, 0x000ff00000009400ULL,
0x0000002b00a57306ULL, 0x000ea20000005400ULL, 0x000000a9b100720bULL, 0x002fce0003fdd000ULL,
0x000000c000c27306ULL, 0x000ff00000209400ULL, 0x000000c000c37306ULL, 0x0002e20000205400ULL,
0x000000a5a200720bULL, 0x004fce0003fbd000ULL, 0x0000002a00367306ULL, 0x000ea2000000d400ULL,
0x000000c000c07245ULL, 0x002fce000020d400ULL, 0x000000c600cc7306ULL, 0x000fe20000209400ULL,
0x000000c3c200720bULL, 0x008fce0003f9d000ULL, 0x000000c6002a7306ULL, 0x0002e20000205400ULL,
0x0000000136366812ULL, 0x004fc800078efcffULL, 0x00000036cb36723eULL, 0x000fe400000010ffULL,
0x00000001c0c04812ULL, 0x000fe200078efcffULL, 0x0000002900d17306ULL, 0x000fe20000209400ULL,
0x000000c600c67245ULL, 0x002fe4000020d400ULL, 0x000000a1b300720bULL, 0x000fca0003f9d000ULL,
0x0000002900d47306ULL, 0x000e620000205400ULL, 0x0000002acc00720bULL, 0x008fce0003f5d000ULL,
0x0000002b00357306ULL, 0x000ea2000000d400ULL, 0x000000017a7a4812ULL, 0x000fca00078efcffULL,
0x00000001c6c62812ULL, 0x000fe400078efcffULL, 0x0000009a009b7306ULL, 0x000fe20000209400ULL,
0x000000d4d100720bULL, 0x002fce0003f7d000ULL, 0x0000009a009c7306ULL, 0x0002e20000205400ULL,
0x0000000135355812ULL, 0x004fce00078efcffULL, 0x00000028002b7306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fce000020d400ULL, 0x0000002800d67306ULL, 0x000e620000205400ULL,
0x0000009c9b00720bULL, 0x008fe40003fdd000ULL, 0x00000029009b7245ULL, 0x000fe4000020d400ULL,
0x00000028009c7245ULL, 0x000fe4000020d400ULL, 0x000000019b9b3812ULL, 0x000fe200078efcffULL,
0x0000002600967306ULL, 0x000fe20000009400ULL, 0x0000a0005d297811ULL, 0x000fca00078e20ffULL,
0x000000019a9a6812ULL, 0x000fe400078efcffULL, 0x0000002600977306ULL, 0x000fe20000005400ULL,
0x000000d62b00720bULL, 0x002fe40003fbd000ULL, 0x0000009b9a9a723eULL, 0x000fca00000010ffULL,
0x0000002600737306ULL, 0x0003ec000000d400ULL, 0x000000019c9c5812ULL, 0x000fe400078efcffULL,
0x0000002700957306ULL, 0x000fe20000009400ULL, 0x000100002c267824ULL, 0x002fce00078e00ffULL,
0x0000002700877306ULL, 0x000ff00000005400ULL, 0x0000002700727306ULL, 0x0003f0000000d400ULL,
0x0000002c00897306ULL, 0x000fe20000009400ULL, 0x000001002d277824ULL, 0x002fce00078e00ffULL,
0x0000002c008c7306ULL, 0x000ff00000005400ULL, 0x0000002c006f7306ULL, 0x000ff0000000d400ULL,
0x0000002d00937306ULL, 0x000ff00000009400ULL, 0x0000002d008b7306ULL, 0x000ff00000005400ULL,
0x0000002d006e7306ULL, 0x000ff0000000d400ULL, 0x00000090009e7306ULL, 0x000ff00000209400ULL,
0x00000090009d7306ULL, 0x000e700000205400ULL, 0x000000d5002c7306ULL, 0x000ff00000209400ULL,
0x000000d5002d7306ULL, 0x0004e20000205400ULL, 0x0000009d9e00720bULL, 0x002fc40003f5d000ULL,
0x00000090009d7245ULL, 0x000fe4000020d400ULL, 0x00000092d790723eULL, 0x000fc600000010ffULL,
0x0000002500887306ULL, 0x000fe20000009400ULL, 0x000000d500d57245ULL, 0x004fca000020d400ULL,
0x000000019d9d2812ULL, 0x000fe400078efcffULL, 0x00000025008d7306ULL, 0x000e620000005400ULL,
0x0000002d2c00720bULL, 0x008fe40003f7d000ULL, 0x0000009c9d9b723eULL, 0x000fca00000010ffULL,
0x000000ae00b07306ULL, 0x000fec0000209400ULL, 0x00000001d5d53812ULL, 0x000fe400078efcffULL,
0x000000ae00a37306ULL, 0x0004e20000205400ULL, 0x0000008d8800720bULL, 0x002fe40003fbd000ULL,
0x00000018ff887819ULL, 0x000fc40000011426ULL, 0x000000e5e026723eULL, 0x000fc600000010ffULL,
0x00000099008f7306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x004fce000020d400ULL,
0x00000099008e7306ULL, 0x0002a20000205400ULL, 0x000000a3b000720bULL, 0x008fe40003f9d000ULL,
0x00000018ffa37819ULL, 0x000fe40000011427ULL, 0x000000dcb927723eULL, 0x000fc600000010ffULL,
0x000000eb00a47306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x00000001aeae4812ULL, 0x000fe400078efcffULL, 0x000000eb009f7306ULL, 0x0002e20000205400ULL,
0x0000008e8f00720bULL, 0x004fce0003f5d000ULL, 0x0000002400a87306ULL, 0x000fe20000009400ULL,
0x000000eb00eb7245ULL, 0x002fca000020d400ULL, 0x0000000199992812ULL, 0x000fe400078efcffULL,
0x0000002400ad7306ULL, 0x000e620000005400ULL, 0x0000009fa400720bULL, 0x008fce0003f7d000ULL,
0x0000002400347306ULL, 0x0004ec000000d400ULL, 0x00000001ebeb3812ULL, 0x000fe400078efcffULL,
0x0000002500777306ULL, 0x000962000000d400ULL, 0x000001002f247824ULL, 0x004fe200078e00ffULL,
0x000000ada800720bULL, 0x002fc40003f9d000ULL, 0x000000979600720bULL, 0x000fc80003f7d000ULL,
0x0000002e00867306ULL, 0x000fe20000009400ULL, 0x000001002e257824ULL, 0x010fcc00078e00ffULL,
0x0000000134344812ULL, 0x008fe200078efcffULL, 0x0000002e00857306ULL, 0x000fe20000005400ULL,
0x0000000177775812ULL, 0x020fe400078efcffULL, 0x000000879500720bULL, 0x000fe40003fbd000ULL,
0x000000d800877245ULL, 0x000fe4000020d400ULL, 0x0000000173733812ULL, 0x000fe200078efcffULL,
0x0000002e003e7306ULL, 0x000fe2000000d400ULL, 0x00000034d5ea723eULL, 0x000fc400000010ffULL,
0x00000077ebeb723eULL, 0x000fca00000010ffULL, 0x0000002f00827306ULL, 0x000fe20000009400ULL,
0x0000000172725812ULL, 0x000fce00078efcffULL, 0x0000002f00817306ULL, 0x000ff00000005400ULL,
0x0000002f003d7306ULL, 0x000ff0000000d400ULL, 0x000000e1002e7306ULL, 0x000ff00000209400ULL,
0x000000e1002f7306ULL, 0x0002b00000205400ULL, 0x000000d800a07306ULL, 0x000fe20000209400ULL,
0x000000e100e17245ULL, 0x002fce000020d400ULL, 0x000000d800a17306ULL, 0x000e620000205400ULL,
0x0000002f2e00720bULL, 0x004fe40003fdd000ULL, 0x00000000292c783bULL, 0x0004ea0000000200ULL,
0x000000a300287306ULL, 0x000fec0000209400ULL, 0x00000001e1e16812ULL, 0x000fc400078efcffULL,
0x000000a300297306ULL, 0x0045220000205400ULL, 0x000000a1a000720bULL, 0x002fce0003f5d000ULL,
0x000000e800327306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x004fca000020d400ULL,
0x0000000187872812ULL, 0x000fe400078efcffULL, 0x000000e800337306ULL, 0x0002a20000205400ULL,
0x000000292800720bULL, 0x010fe40003fbd000ULL, 0x0000a0005c287811ULL, 0x000fca00078e20ffULL,
0x000000da002a7306ULL, 0x000fe20000209400ULL, 0x000000e800e87245ULL, 0x002fe2000020d400ULL,
0x000000752c2c9231ULL, 0x088fe400003400ffULL, 0x000000752e2e9231ULL, 0x000fe400003400ffULL,
0x00000001a3a35812ULL, 0x000fe200078efcffULL, 0x000000742d2d9231ULL, 0x080fe200003400ffULL,
0x000000da00a27306ULL, 0x0002e20000205400ULL, 0x000000333200720bULL, 0x004fe20003f9d000ULL,
0x000000742f2f9231ULL, 0x000fcc00003400ffULL, 0x000000d9009e7306ULL, 0x000fe20000209400ULL,
0x000000da00da7245ULL, 0x002fe2000020d400ULL, 0x000000902c0c723cULL, 0x040fe8000004180cULL,
0x00000001e8e84812ULL, 0x000fe400078efcffULL, 0x000000d9002b7306ULL, 0x0002a20000205400ULL,
0x000000a22a00720bULL, 0x008fe20003f5d000ULL, 0x000000262c10723cULL, 0x000fe20000041810ULL,
0x0000008c8900720bULL, 0x000fca0003f9d000ULL, 0x0000009400987306ULL, 0x000fe20000209400ULL,
0x000000d900d97245ULL, 0x002fe2000020d400ULL, 0x0000009a2c20723cULL, 0x000fe80000041820ULL,
0x00000001dada2812ULL, 0x000fe400078efcffULL, 0x00000094008a7306ULL, 0x0002e20000205400ULL,
0x0000002b9e00720bULL, 0x004fe40003f7d000ULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x000000858600720bULL, 0x000fc40003f5d000ULL, 0x000000016f6f4812ULL, 0x000fe400078efcffULL,
0x00000037007e7306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fe4000020d400ULL,
0x00000083bc85723eULL, 0x000fe400000010ffULL, 0x00000018ff837819ULL, 0x000fe40000011424ULL,
0x00000031b624723eULL, 0x000fe200000010ffULL, 0x00000037007f7306ULL, 0x000e620000205400ULL,
0x0000008a9800720bULL, 0x008fe20003fdd000ULL, 0x000000842c04723cULL, 0x000fe20000041804ULL,
0x000000cdae31723eULL, 0x000fc400000010ffULL, 0x00000001d9d93812ULL, 0x000fe400078efcffULL,
0x000000818200720bULL, 0x000fe20003f7d000ULL, 0x0000008800327306ULL, 0x000fe20000209400ULL,
0x000000013e3e2812ULL, 0x000fca00078efcffULL, 0x0000000194946812ULL, 0x000fe400078efcffULL,
0x0000008800337306ULL, 0x0007220000205400ULL, 0x0000008b9300720bULL, 0x000fe40003fdd000ULL,
0x00000018ff8b7819ULL, 0x000fe40000011425ULL, 0x0000007f7e00720bULL, 0x002fe40003f9d000ULL,
0x000000c0b425723eULL, 0x000fe200000010ffULL, 0x00000076007c7306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x008fe2000020d400ULL, 0x0000007528289231ULL, 0x084fe200003400ffULL,
0x000000013d3d3812ULL, 0x000fe200078efcffULL, 0x000000752a2a9231ULL, 0x000fc400003400ffULL,
0x000000016e6e6812ULL, 0x000fe200078efcffULL, 0x000000242c24723cULL, 0x000fe20000041808ULL,
0x00000076007b7306ULL, 0x0002a20000205400ULL, 0x000000333200720bULL, 0x010fe20003fbd000ULL,
0x0000007429299231ULL, 0x080fe200003400ffULL, 0x0000007dbf32723eULL, 0x000fe200000010ffULL,
0x000000742b2b9231ULL, 0x000fe200003400ffULL, 0x0000007abe33723eULL, 0x000fe400000010ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011430ULL, 0x0000008b008c7306ULL, 0x000fe20000209400ULL,
0x000000c5af30723eULL, 0x000fc400000010ffULL, 0x0000007600767245ULL, 0x002fe2000020d400ULL,
0x000000322c08723cULL, 0x040fe40000041814ULL, 0x0000000188885812ULL, 0x000fe400078efcffULL,
0x0000008b00867306ULL, 0x0002e20000205400ULL, 0x0000007b7c00720bULL, 0x004fe40003fdd000ULL,
0x00000037007c7245ULL, 0x000fe2000020d400ULL, 0x000000302c30723cULL, 0x000fe20000041818ULL,
0x00000035c637723eULL, 0x000fc400000010ffULL, 0x000000017c7c4812ULL, 0x000fe200078efcffULL,
0x000000d300897306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x002fe4000020d400ULL,
0x00000072da15723eULL, 0x000fe200000010ffULL, 0x000000362c34723cULL, 0x000fe2000004181cULL,
0x000000e19918723eULL, 0x000fe400000010ffULL, 0x0000000176766812ULL, 0x000fe200078efcffULL,
0x000000d3008a7306ULL, 0x0002a20000205400ULL, 0x000000868c00720bULL, 0x008fc40003f9d000ULL,
0x000000e89419723eULL, 0x000fe200000010ffULL, 0x000000ea281c723cULL, 0x000fe8000004180cULL,
0x0000007a007b7306ULL, 0x000fe20000209400ULL, 0x000000d300d37245ULL, 0x002fc6000020d400ULL,
0x000000182818723cULL, 0x000fe40000041810ULL, 0x000000018b8b4812ULL, 0x000fe400078efcffULL,
0x0000007a00147306ULL, 0x0002e20000205400ULL, 0x0000008a8900720bULL, 0x004fe40003fbd000ULL,
0x0000006fd910723eULL, 0x000fe400000010ffULL, 0x0000006ea311723eULL, 0x000fc600000010ffULL,
0x0000006800717306ULL, 0x000fe20000209400ULL, 0x0000007a007a7245ULL, 0x002fc6000020d400ULL,
0x000000102810723cULL, 0x040fe40000041808ULL, 0x00000001d3d35812ULL, 0x000fe400078efcffULL,
0x0000006800707306ULL, 0x0002a20000205400ULL, 0x000000147b00720bULL, 0x008fe40003f9d000ULL,
0x000000738714723eULL, 0x000fe400000010ffULL, 0x000000d3760d723eULL, 0x000fe400000010ffULL,
0x0000003e8b08723eULL, 0x000fe200000010ffULL, 0x0000008300817306ULL, 0x000fe20000209400ULL,
0x0000006800687245ULL, 0x002fe2000020d400ULL, 0x000000142814723cULL, 0x000fe80000041804ULL,
0x000000017a7a4812ULL, 0x000fc400078efcffULL, 0x00000083007e7306ULL, 0x0002e20000205400ULL,
0x000000707100720bULL, 0x004fe40003fdd000ULL, 0x0000007800057245ULL, 0x000fca000020d400ULL,
0x00000079002c7306ULL, 0x000fe20000209400ULL, 0x0000008300837245ULL, 0x002fca000020d400ULL,
0x0000000168686812ULL, 0x000fe400078efcffULL, 0x00000079000c7306ULL, 0x000e620000205400ULL,
0x0000007e8100720bULL, 0x008fe40003fbd000ULL, 0x0000007a6868723eULL, 0x000fca00000010ffULL,
0x0000000000697306ULL, 0x000fec0000209400ULL, 0x0000000183835812ULL, 0x000fe400078efcffULL,
0x00000000006c7306ULL, 0x0004e20000205400ULL, 0x0000000c2c00720bULL, 0x002fe40003f7d000ULL,
0x000000887c0c723eULL, 0x000fc400000010ffULL, 0x0000003d8309723eULL, 0x000fc600000010ffULL,
0x0000003a006a7306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x004fe2000020d400ULL,
0x0000000c280c723cULL, 0x040fec0000041830ULL, 0x0000003a006b7306ULL, 0x0002a20000205400ULL,
0x0000006c6900720bULL, 0x008fe20003f5d000ULL, 0x000000082808723cULL, 0x000fe20000041834ULL,
0x0000007900697245ULL, 0x000fc8000020d400ULL, 0x0000000169693812ULL, 0x000fe200078efcffULL,
0x0000003b00537306ULL, 0x000fe20000209400ULL, 0x0000003a003a7245ULL, 0x002fca000020d400ULL,
0x0000000100002812ULL, 0x000fe400078efcffULL, 0x0000003b003f7306ULL, 0x0002e20000205400ULL,
0x0000006b6a00720bULL, 0x004fce0003fbd000ULL, 0x00000080007d7306ULL, 0x000fe20000209400ULL,
0x0000003b003b7245ULL, 0x002fca000020d400ULL, 0x000000013a3a5812ULL, 0x000fe400078efcffULL,
0x0000008000757306ULL, 0x0002a20000205400ULL, 0x0000003f5300720bULL, 0x008fce0003f9d000ULL,
0x00000078002d7306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x000000013b3b4812ULL, 0x000fe400078efcffULL, 0x0000007800047306ULL, 0x000e620000205400ULL,
0x000000757d00720bULL, 0x004fe40003fdd000ULL, 0x000000693b69723eULL, 0x000fce00000010ffULL,
0x000000682824723cULL, 0x000fe80000041824ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x000000042d00720bULL, 0x002fe40003f7d000ULL, 0x000000800004723eULL, 0x000fd600000010ffULL,
0x0000000105053812ULL, 0x000fc800078efcffULL, 0x000000053a05723eULL, 0x000fce00000010ffULL,
0x000000042804723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff207f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007844821ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000227305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000220000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004040007811ULL, 0x000fe400078e40ffULL,
0x00000004ff2a7819ULL, 0x000fc40000011644ULL, 0x0000000041207217ULL, 0x000fe40007800000ULL,
0x0000004043227811ULL, 0x000fe400078e38ffULL, 0x000000022a2b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000120207824ULL, 0x000fe200078e0a00ULL, 0x0000004522007210ULL, 0x0c0fe40007ffe02aULL,
0x0000004522217210ULL, 0x000fe40007ffe02bULL, 0x0000002020207807ULL, 0x000fc40000000000ULL,
0x000000003c297210ULL, 0x040fe40007f5e0ffULL, 0x0000002045207217ULL, 0x000fe40007800000ULL,
0x000000213c217210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x000000042a2e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000120007824ULL, 0x000fe200078e0a45ULL,
0x00005e0029207a11ULL, 0x000fe200078440ffULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00005e0021287a11ULL, 0x000fe200078840ffULL, 0x00000001456e7824ULL, 0x000fe200078e022eULL,
0x000000002a00720cULL, 0x000fc40003f66070ULL, 0x00005f0029297a11ULL, 0x000fe200010f4423ULL,
0x000000016e237824ULL, 0x000fe200078e0222ULL, 0x0000004d20207210ULL, 0x000fe40007f5e0ffULL,
0x00005f00212c7a11ULL, 0x000fe400020f442cULL, 0x000000062a2d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200010e0629ULL, 0x0000c0005b5b7811ULL, 0x000fe400078e20ffULL,
0x000000002b00720cULL, 0x000fc40003f46070ULL, 0x000000233c2b7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000205b7faeULL, 0x0003e2000d901c46ULL,
0x0000004522227210ULL, 0x000fe40007ffe02dULL, 0x000000002e00720cULL, 0x000fe40003f66070ULL,
0x000000223c237210ULL, 0x000fe40007fde0ffULL, 0x0000c0005a5a7811ULL, 0x000fe400078e20ffULL,
0x0000c00059597811ULL, 0x000fe200078e20ffULL, 0x000000ffff297224ULL, 0x000fe200030e06ffULL,
0x0000c00058587811ULL, 0x000fe200078e20ffULL, 0x000000ffff217224ULL, 0x002fe200020e06ffULL,
0x00005e002b2a7a11ULL, 0x000fc400078840ffULL, 0x0000004d28207210ULL, 0x080fe40007fbe0ffULL,
0x00005f002b2b7a11ULL, 0x000fe400020f4421ULL, 0x00005e0023287a11ULL, 0x000fe200078840ffULL,
0x000000ffff217224ULL, 0x000fe200028e062cULL, 0x000000002d00720cULL, 0x000fe40003fa6070ULL,
0x0000004d2a227210ULL, 0x080fe40007fde0ffULL, 0x00005f0023007a11ULL, 0x000fe200020f4429ULL,
0x00000000205a7faeULL, 0x0003e2000d101c46ULL, 0x0000004d28287210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff237224ULL, 0x000fc800030e062bULL, 0x000000ffff297224ULL, 0x000fe200020e0600ULL,
0x0000000022597faeULL, 0x0003e8000d901c46ULL, 0x0000000028587faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007844839ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e0031ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007844839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000207305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000200000735dULL, 0x004fe40003800000ULL, 0x0106b400ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fc40007844839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004bff00723eULL, 0x000fe400000010ffULL, 0x00000002ff2b7819ULL, 0x000fe40000011644ULL,
0x0000000444537811ULL, 0x000fe400078fe0ffULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x0001a9127f007947ULL, 0x000fea000b800000ULL, 0x00001f2b00397589ULL, 0x0004e400000e0000ULL,
0x0001a9527f007947ULL, 0x000fea000b800000ULL, 0x00001f4e00387589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x004fe200078e004fULL,
0x000043a000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x002fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fc400078e00ffULL, 0x0001b86000007944ULL, 0x018fea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x004fe200078e0050ULL,
0x0000440000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x002fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0001b80000007944ULL, 0x018fea0003c00000ULL,
0x0000e00057577811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000e00054547811ULL, 0x000fe400078e20ffULL, 0x0000e00056567811ULL, 0x000fe200078e20ffULL,
0x000000005720783bULL, 0x002e620000004200ULL, 0x0000e00055557811ULL, 0x000fe400078e20ffULL,
0x0000000644c07811ULL, 0x000fe200078fe0ffULL, 0x000000005434783bULL, 0x000f620000004200ULL,
0x0000000753537812ULL, 0x000fc400078e7852ULL, 0x00000007c0e37812ULL, 0x000fe200078e7852ULL,
0x00000000562c783bULL, 0x000fe40000004200ULL, 0x0000000852537824ULL, 0x040fe400078e0253ULL,
0x000000005528783bULL, 0x004ea20000004200ULL, 0x0000000852527824ULL, 0x000fe400078e02e3ULL,
0x0001000020e67824ULL, 0x042fe200078e00ffULL, 0x0000002000c37306ULL, 0x000fe20000009400ULL,
0x00000018ffce7819ULL, 0x000fe20000011420ULL, 0x0000010020e57824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe20000011421ULL, 0x0001000021c97824ULL, 0x040fe200078e00ffULL,
0x00000018ffe67819ULL, 0x000fe200000114e6ULL, 0x0000010021c87824ULL, 0x000fe200078e00ffULL,
0x00000018ffe57819ULL, 0x000fe200000114e5ULL, 0x0000002000c67306ULL, 0x000e620000005400ULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0001000022cc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe20000011422ULL, 0x0001000023cf7824ULL, 0x000fe200078e00ffULL,
0x00000018ff007819ULL, 0x030fe20000011436ULL, 0x0000010028e47824ULL, 0x044fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000000e600da7306ULL, 0x000fe20000209400ULL,
0x00000018ffcc7819ULL, 0x000fe200000114ccULL, 0x0001000028ec7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fe20000011423ULL, 0x000001002cd27824ULL, 0x040fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x0000010029e37824ULL, 0x000fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe2000001142cULL, 0x000000e600a57306ULL, 0x000ea20000205400ULL,
0x000000c6c300720bULL, 0x002fe20003fdd000ULL, 0x0001000029eb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011428ULL, 0x000100002cd87824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011429ULL, 0x000001002dd57824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001142aULL, 0x000000ce00827306ULL, 0x000fe20000209400ULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x000001002fa77824ULL, 0x040fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001142bULL, 0x000100002ea97824ULL, 0x000fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x000100002fbe7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001142dULL, 0x000000ce007c7306ULL, 0x0003220000205400ULL,
0x000000a5da00720bULL, 0x004fe20003fbd000ULL, 0x0000010036a57824ULL, 0x000fe200078e00ffULL,
0x00000018ffd57819ULL, 0x000fe200000114d5ULL, 0x0000010034da7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fc400000114a7ULL, 0x00000018ffa37819ULL, 0x000fe2000001142eULL,
0x0000002100e27306ULL, 0x000fe20000009400ULL, 0x000000ce00ce7245ULL, 0x002fe4000020d400ULL,
0x00000018ffbe7819ULL, 0x000fe400000114beULL, 0x00000018ffa97819ULL, 0x000fe400000114a9ULL,
0x00000018ffc37819ULL, 0x000fe200000114e4ULL, 0x0000002100db7306ULL, 0x000e620000005400ULL,
0x0000007c8200720bULL, 0x010fe20003f9d000ULL, 0x0001000036827824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe2000001142fULL, 0x00010000377c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe37819ULL, 0x000fc400000114e3ULL, 0x00000018ff317819ULL, 0x000fe20000011437ULL,
0x00000021003a7306ULL, 0x000522000000d400ULL, 0x00000018ffeb7819ULL, 0x000fe400000114ebULL,
0x00000018ffda7819ULL, 0x000fe400000114daULL, 0x00000018ff707819ULL, 0x000fe40000011434ULL,
0x00000001cece4812ULL, 0x000fe200078efcffULL, 0x000000bd00c57306ULL, 0x000fe20000209400ULL,
0x0000010023217824ULL, 0x004fe200078e00ffULL, 0x000000dbe200720bULL, 0x002fe20003f7d000ULL,
0x000100002bdb7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe20000011435ULL,
0x0001000034e27824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x000000bd00c47306ULL, 0x0003e20000205400ULL, 0x00000018ffdb7819ULL, 0x000fe400000114dbULL,
0x00000018ffe27819ULL, 0x000fe400000114e2ULL, 0x00000018ffa57819ULL, 0x000fe400000114a5ULL,
0x000000013a3a3812ULL, 0x010fe200078efcffULL, 0x000000e500877306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x002fe4000020d400ULL, 0x00000018ff827819ULL, 0x000fc40000011482ULL,
0x00000018ff7c7819ULL, 0x000fc6000001147cULL, 0x000000e500dc7306ULL, 0x0002b00000205400ULL,
0x00000020009b7306ULL, 0x000962000000d400ULL, 0x000000e500e57245ULL, 0x002fce000020d400ULL,
0x000000c900e77306ULL, 0x000fe20000209400ULL, 0x0000010022207824ULL, 0x010fe200078e00ffULL,
0x000000dc8700720bULL, 0x004fe20003f5d000ULL, 0x0000010037877824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x000000c900e87306ULL, 0x0002a20000205400ULL,
0x000000019b9b6812ULL, 0x020fe400078efcffULL, 0x00000018ff877819ULL, 0x000fc80000011487ULL,
0x00000001e5e52812ULL, 0x000fe200078efcffULL, 0x0000002200c17306ULL, 0x000fe20000009400ULL,
0x000000c900c97245ULL, 0x002fce000020d400ULL, 0x0000002200c27306ULL, 0x000e620000005400ULL,
0x000000e8e700720bULL, 0x004fce0003fdd000ULL, 0x0000002200847306ULL, 0x000eac000000d400ULL,
0x00000001c9c96812ULL, 0x000fe400078efcffULL, 0x0000002100c77306ULL, 0x000fe20000209400ULL,
0x000000c2c100720bULL, 0x002fce0003f9d000ULL, 0x0000002100227306ULL, 0x000e6c0000205400ULL,
0x0000000184844812ULL, 0x004fe400078efcffULL, 0x00000036009a7306ULL, 0x000ff00000009400ULL,
0x0000003600997306ULL, 0x000fe20000005400ULL, 0x00000022c700720bULL, 0x002fce0003f7d000ULL,
0x0000003600337306ULL, 0x0003f0000000d400ULL, 0x0000002300ad7306ULL, 0x000fe20000009400ULL,
0x000000e600367245ULL, 0x002fe4000020d400ULL, 0x00000018ffe67819ULL, 0x000fc400000114ecULL,
0x0000000136365812ULL, 0x000fe400078efcffULL, 0x000000c4c500720bULL, 0x000fe20003fbd000ULL,
0x0000002300b47306ULL, 0x000e620000005400ULL, 0x00000036ce36723eULL, 0x000fce00000010ffULL,
0x0000002300837306ULL, 0x000ea8000000d400ULL, 0x00000001bdbd5812ULL, 0x000fc800078efcffULL,
0x000000c800e97306ULL, 0x000fe20000209400ULL, 0x000000b4ad00720bULL, 0x002fe40003fdd000ULL,
0x0000002100ad7245ULL, 0x000fe4000020d400ULL, 0x0000002000b47245ULL, 0x000fe4000020d400ULL,
0x00000001adad3812ULL, 0x000fe200078efcffULL, 0x000000c800ea7306ULL, 0x00032c0000205400ULL,
0x0000000183836812ULL, 0x004fc400078efcffULL, 0x000000cc00cd7306ULL, 0x000fe20000209400ULL,
0x000000c800c87245ULL, 0x002fce000020d400ULL, 0x000000cc00237306ULL, 0x0002a20000205400ULL,
0x000000eae900720bULL, 0x010fce0003f5d000ULL, 0x000000cf00d07306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fca000020d400ULL, 0x00000001c8c82812ULL, 0x000fe400078efcffULL,
0x000000cf00d17306ULL, 0x0003220000205400ULL, 0x00000023cd00720bULL, 0x004fce0003fbd000ULL,
0x0000002c00b27306ULL, 0x000fe20000009400ULL, 0x000000cf00cf7245ULL, 0x002fca000020d400ULL,
0x00000001cccc5812ULL, 0x000fe400078efcffULL, 0x0000002c00b97306ULL, 0x000e620000005400ULL,
0x000000d1d000720bULL, 0x010fce0003f7d000ULL, 0x0000002000ca7306ULL, 0x000fec0000209400ULL,
0x00000001cfcf3812ULL, 0x000fe400078efcffULL, 0x0000002000cb7306ULL, 0x0005220000205400ULL,
0x000000b9b200720bULL, 0x002fce0003fbd000ULL, 0x0000002d00bb7306ULL, 0x000fe20000009400ULL,
0x0000a00052207811ULL, 0x004fcc00078e20ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x0000002d00b17306ULL, 0x000ea20000005400ULL, 0x000000cbca00720bULL, 0x010fce0003f5d000ULL,
0x0000002c00807306ULL, 0x00096c000000d400ULL, 0x00000001b4b42812ULL, 0x000fe400078efcffULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x000000b1bb00720bULL, 0x004fe20003f7d000ULL,
0x000100002d2c7824ULL, 0x010fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x000000ab00b37306ULL, 0x0005220000205400ULL, 0x0000000180805812ULL, 0x020fce00078efcffULL,
0x000000a600af7306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x004fe2000020d400ULL,
0x0000003920209231ULL, 0x00afcc00003400ffULL, 0x000000a600b07306ULL, 0x000e620000205400ULL,
0x000000b3ac00720bULL, 0x010fe20003f5d000ULL, 0x0000003922229231ULL, 0x000fe400003400ffULL,
0x0000003821219231ULL, 0x080fe400003400ffULL, 0x0000003823239231ULL, 0x000fe400003400ffULL,
0x0000002800a47306ULL, 0x000fec0000009400ULL, 0x00000001abab2812ULL, 0x000fc400078efcffULL,
0x0000002800947306ULL, 0x000fe20000005400ULL, 0x000000b0af00720bULL, 0x002fe40003fbd000ULL,
0x000000ccabcc723eULL, 0x000fca00000010ffULL, 0x0000002800747306ULL, 0x0003f0000000d400ULL,
0x0000002900a27306ULL, 0x000fe20000009400ULL, 0x000001002b287824ULL, 0x002fca00078e00ffULL,
0x00000018ffb17819ULL, 0x000fe40000011428ULL, 0x0000002900887306ULL, 0x000fe20000005400ULL,
0x0000a00053287811ULL, 0x000fce00078e20ffULL, 0x0000002900717306ULL, 0x0003f0000000d400ULL,
0x0000002a003b7306ULL, 0x000fe20000009400ULL, 0x000001002a297824ULL, 0x002fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe40000011429ULL, 0x0000002a008f7306ULL, 0x000ff00000005400ULL,
0x0000002a006f7306ULL, 0x0003f0000000d400ULL, 0x000000d200d37306ULL, 0x000fe20000209400ULL,
0x000100002a2a7824ULL, 0x002fca00078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe4000001142aULL,
0x000000d200d47306ULL, 0x0002b00000205400ULL, 0x0000002b009f7306ULL, 0x000fe20000009400ULL,
0x000000d200d27245ULL, 0x002fce000020d400ULL, 0x0000002b008c7306ULL, 0x000fe20000005400ULL,
0x000000d4d300720bULL, 0x004fce0003fdd000ULL, 0x0000002b006c7306ULL, 0x0003ec000000d400ULL,
0x00000001d2d26812ULL, 0x000fe400078efcffULL, 0x000000b800b67306ULL, 0x000fe20000209400ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x000000b800bc7306ULL, 0x0004f00000205400ULL,
0x000000d800d97306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x004fce000020d400ULL,
0x000000d800e17306ULL, 0x0005220000205400ULL, 0x000000bcb600720bULL, 0x008fce0003f9d000ULL,
0x0000002d007f7306ULL, 0x000762000000d400ULL, 0x000000d800d87245ULL, 0x004fca000020d400ULL,
0x00000001b8b84812ULL, 0x000fe400078efcffULL, 0x0000002e00b77306ULL, 0x000fe20000009400ULL,
0x000001002e2d7824ULL, 0x008fe200078e00ffULL, 0x000000e1d900720bULL, 0x010fe20003fdd000ULL,
0x0000003928289231ULL, 0x082fe200003400ffULL, 0x000000cfb8cd723eULL, 0x000fe200000010ffULL,
0x000000392a2a9231ULL, 0x000fe200003400ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000003829299231ULL, 0x080fe200003400ffULL, 0x0000002e00ae7306ULL, 0x000e620000005400ULL,
0x000000017f7f3812ULL, 0x020fe200078efcffULL, 0x000000382b2b9231ULL, 0x000fe200003400ffULL,
0x0000009be538723eULL, 0x000fc400000010ffULL, 0x0000003ac839723eULL, 0x000fe400000010ffULL,
0x00000001d8d86812ULL, 0x000fe200078efcffULL, 0x0000002c00df7306ULL, 0x000fe20000209400ULL,
0x000000cc2824723cULL, 0x000fee0000041824ULL, 0x0000002c00e07306ULL, 0x0004e20000205400ULL,
0x000000aeb700720bULL, 0x002fc40003f9d000ULL, 0x000000a600ae7245ULL, 0x000fe4000020d400ULL,
0x0000002c00a67245ULL, 0x000fe4000020d400ULL, 0x00000001aeae5812ULL, 0x000fe200078efcffULL,
0x000000d500d67306ULL, 0x000fe20000209400ULL, 0x00000084b42c723eULL, 0x004fce00000010ffULL,
0x000000d500d77306ULL, 0x0002a20000205400ULL, 0x000000e0df00720bULL, 0x008fce0003f7d000ULL,
0x0000002e007b7306ULL, 0x000ee2000000d400ULL, 0x000000d500d57245ULL, 0x002fca000020d400ULL,
0x00000001a6a63812ULL, 0x000fe400078efcffULL, 0x000000a700a87306ULL, 0x000fe20000209400ULL,
0x000000d7d600720bULL, 0x004fce0003f5d000ULL, 0x000000a7002e7306ULL, 0x0002a20000205400ULL,
0x000000017b7b4812ULL, 0x008fca00078efcffULL, 0x00000001d5d52812ULL, 0x000fe400078efcffULL,
0x0000002d00dd7306ULL, 0x000fe20000209400ULL, 0x000000a700a77245ULL, 0x002fce000020d400ULL,
0x0000002d00de7306ULL, 0x000e620000205400ULL, 0x0000002ea800720bULL, 0x004fce0003fbd000ULL,
0x000000e600c47306ULL, 0x000fec0000209400ULL, 0x00000001a7a75812ULL, 0x000fe400078efcffULL,
0x000000e600c17306ULL, 0x0004e20000205400ULL, 0x000000dedd00720bULL, 0x002fce0003fdd000ULL,
0x0000002f008b7306ULL, 0x000fe20000009400ULL, 0x000000e600e67245ULL, 0x004fce000020d400ULL,
0x0000002f008e7306ULL, 0x000e620000005400ULL, 0x000000c1c400720bULL, 0x008fce0003f3d000ULL,
0x0000008a00b57306ULL, 0x000fec0000209400ULL, 0x00000001e6e61812ULL, 0x000fe400078efcffULL,
0x0000008a00ba7306ULL, 0x0004e20000205400ULL, 0x0000008e8b00720bULL, 0x002fe40003f7d000ULL,
0x0000002d008b7245ULL, 0x000fc4000020d400ULL, 0x00000083ad2d723eULL, 0x000fe400000010ffULL,
0x000000018b8b6812ULL, 0x000fe200078efcffULL, 0x000000be00bf7306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x004fce000020d400ULL, 0x000000be00c07306ULL, 0x0002a20000205400ULL,
0x000000bab500720bULL, 0x008fce0003f5d000ULL, 0x000000a300937306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x002fca000020d400ULL, 0x000000018a8a2812ULL, 0x000fe400078efcffULL,
0x000000a300977306ULL, 0x0002e20000205400ULL, 0x000000c0bf00720bULL, 0x004fce0003fbd000ULL,
0x000000ac00b27306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fca000020d400ULL,
0x00000001bebe5812ULL, 0x000fe400078efcffULL, 0x000000ac00b67306ULL, 0x0002a20000205400ULL,
0x000000979300720bULL, 0x008fce0003fdd000ULL, 0x0000002f00757306ULL, 0x000ee2000000d400ULL,
0x000000ac00ac7245ULL, 0x002fca000020d400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x000000a900aa7306ULL, 0x000fe20000209400ULL, 0x000000b6b200720bULL, 0x004fe40003f3d000ULL,
0x0000008f3b00720bULL, 0x000fe40003fdd000ULL, 0x000000382838723cULL, 0x000fe6000004181cULL,
0x000000a9002f7306ULL, 0x0002a20000205400ULL, 0x0000000175753812ULL, 0x008fc400078efcffULL,
0x00000094a400720bULL, 0x000fe40003f7d000ULL, 0x00000075a71d723eULL, 0x000fe400000010ffULL,
0x00000001acac1812ULL, 0x000fe200078efcffULL, 0x000000c300c67306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fe4000020d400ULL, 0x000000016f6f6812ULL, 0x000fe400078efcffULL,
0x0000007b8b1c723eULL, 0x000fc600000010ffULL, 0x000000c300dc7306ULL, 0x0002e20000205400ULL,
0x0000002faa00720bULL, 0x004fe40003f5d000ULL, 0x0000000174743812ULL, 0x000fe200078efcffULL,
0x0000001c281c723cULL, 0x000fe20000041808ULL, 0x0000008c9f00720bULL, 0x000fc60003f7d000ULL,
0x000000a100967306ULL, 0x000fe20000209400ULL, 0x000000c300c37245ULL, 0x002fca000020d400ULL,
0x00000001a9a92812ULL, 0x000fe400078efcffULL, 0x000000a100957306ULL, 0x0002a20000205400ULL,
0x000000dcc600720bULL, 0x008fe40003fbd000ULL, 0x00000088a200720bULL, 0x000fe40003f5d000ULL,
0x000000016c6c3812ULL, 0x000fc600078efcffULL, 0x000000b100b77306ULL, 0x000fe20000209400ULL,
0x000000a100a17245ULL, 0x002fca000020d400ULL, 0x00000001c3c35812ULL, 0x000fe400078efcffULL,
0x000000b100b57306ULL, 0x0002e20000205400ULL, 0x000000959600720bULL, 0x004fe40003f9d000ULL,
0x0000000171712812ULL, 0x000fca00078efcffULL, 0x0000003700797306ULL, 0x000fe20000009400ULL,
0x000000b100b17245ULL, 0x002fca000020d400ULL, 0x00000001a1a14812ULL, 0x000fe400078efcffULL,
0x0000003700787306ULL, 0x000fe20000005400ULL, 0x000000b5b700720bULL, 0x008fe40003f3d000ULL,
0x000000bea1a1723eULL, 0x000fca00000010ffULL, 0x0000003700327306ULL, 0x000fec000000d400ULL,
0x00000001b1b11812ULL, 0x000fe400078efcffULL, 0x0000009d00a07306ULL, 0x000ff00000209400ULL,
0x0000009d00907306ULL, 0x0002b00000205400ULL, 0x0000008100867306ULL, 0x000fe20000209400ULL,
0x0000009d009d7245ULL, 0x002fce000020d400ULL, 0x0000008100857306ULL, 0x0002e20000205400ULL,
0x00000090a000720bULL, 0x004fe40003fbd000ULL, 0x000000a9a3a0723eULL, 0x000fca00000010ffULL,
0x000000e300e47306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x000000019d9d5812ULL, 0x000fe400078efcffULL, 0x000000e300377306ULL, 0x0002a20000205400ULL,
0x000000858600720bULL, 0x008fce0003fdd000ULL, 0x000000af00b07306ULL, 0x000fe20000209400ULL,
0x000000e300e37245ULL, 0x002fca000020d400ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x000000af002e7306ULL, 0x0002e20000205400ULL, 0x00000037e400720bULL, 0x004fe40003f9d000ULL,
0x000000c9bd37723eULL, 0x000fca00000010ffULL, 0x00000098009e7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x00000001e3e34812ULL, 0x000fe400078efcffULL,
0x0000009800927306ULL, 0x0002a20000205400ULL, 0x0000002eb000720bULL, 0x008fce0003f3d000ULL,
0x0000003400897306ULL, 0x000fe20000009400ULL, 0x0000009800987245ULL, 0x002fca000020d400ULL,
0x00000001afaf1812ULL, 0x000fe400078efcffULL, 0x00000034008d7306ULL, 0x000e620000005400ULL,
0x000000929e00720bULL, 0x004fe40003f5d000ULL, 0x000000af8108723eULL, 0x000fca00000010ffULL,
0x0000007a007e7306ULL, 0x000fec0000209400ULL, 0x0000000198982812ULL, 0x000fe400078efcffULL,
0x0000007a007d7306ULL, 0x0004e20000205400ULL, 0x0000008d8900720bULL, 0x002fe40003fbd000ULL,
0x000000999a00720bULL, 0x000fca0003f5d000ULL, 0x000000eb00c27306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x004fce000020d400ULL, 0x000000eb00b37306ULL, 0x0002a20000205400ULL,
0x0000007d7e00720bULL, 0x008fe40003f3d000ULL, 0x0000000133332812ULL, 0x000fca00078efcffULL,
0x000000da008f7306ULL, 0x000fe20000209400ULL, 0x000000eb00eb7245ULL, 0x002fca000020d400ULL,
0x000000017a7a1812ULL, 0x000fe400078efcffULL, 0x000000da00937306ULL, 0x0002e20000205400ULL,
0x000000b3c200720bULL, 0x004fce0003f9d000ULL, 0x0000003400697306ULL, 0x000522000000d400ULL,
0x000000da00da7245ULL, 0x002fca000020d400ULL, 0x00000001ebeb4812ULL, 0x000fe400078efcffULL,
0x000000db002f7306ULL, 0x000fe20000209400ULL, 0x0000010035347824ULL, 0x004fe200078e00ffULL,
0x000000938f00720bULL, 0x008fc80003fdd000ULL, 0x00000018ff887819ULL, 0x000fe40000011434ULL,
0x000000db008e7306ULL, 0x0002a20000205400ULL, 0x0000000169695812ULL, 0x010fcc00078efcffULL,
0x00000001dada6812ULL, 0x000fe200078efcffULL, 0x00000035009c7306ULL, 0x000fe20000009400ULL,
0x000000db00db7245ULL, 0x002fe4000020d400ULL, 0x00000069dada723eULL, 0x000fca00000010ffULL,
0x0000003500917306ULL, 0x000e620000005400ULL, 0x0000008e2f00720bULL, 0x004fe40003f7d000ULL,
0x0000002c282c723cULL, 0x000fea0000041814ULL, 0x00000035003d7306ULL, 0x0004e4000000d400ULL,
0x00000080d214723eULL, 0x000fc400000010ffULL, 0x0000007fd515723eULL, 0x000fe400000010ffULL,
0x00000001dbdb3812ULL, 0x000fe400078efcffULL, 0x0000007000767306ULL, 0x000fe20000209400ULL,
0x0001000035357824ULL, 0x004fe200078e00ffULL, 0x000000919c00720bULL, 0x002fe20003f9d000ULL,
0x000000142814723cULL, 0x000fe20000041810ULL, 0x000000787900720bULL, 0x000fe40003f7d000ULL,
0x00000018ff8d7819ULL, 0x000fc40000011435ULL, 0x0000007000777306ULL, 0x0002a20000205400ULL,
0x000000db7a09723eULL, 0x000fe400000010ffULL, 0x000000362834723cULL, 0x000fe20000041818ULL,
0x000000e69d10723eULL, 0x000fe400000010ffULL, 0x000000eb9811723eULL, 0x000fe400000010ffULL,
0x0000008800907306ULL, 0x000fe20000209400ULL, 0x0000007000707245ULL, 0x002fe4000020d400ULL,
0x000000d8ae18723eULL, 0x000fe200000010ffULL, 0x000000082008723cULL, 0x000fe20000041824ULL,
0x000000a68a19723eULL, 0x000fc400000010ffULL, 0x000000013d3d4812ULL, 0x008fe200078efcffULL,
0x0000008800927306ULL, 0x0002e20000205400ULL, 0x000000777600720bULL, 0x004fe40003f3d000ULL,
0x0000008700257245ULL, 0x000fe2000020d400ULL, 0x000000182818723cULL, 0x000fe2000004180cULL,
0x0000000132323812ULL, 0x000fc600078efcffULL, 0x0000003f00737306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x002fe4000020d400ULL, 0x00000074c30c723eULL, 0x000fe200000010ffULL,
0x000000102010723cULL, 0x040fe20000041834ULL, 0x00000071e30d723eULL, 0x000fe400000010ffULL,
0x0000000170701812ULL, 0x000fe200078efcffULL, 0x0000003f00727306ULL, 0x0002a20000205400ULL,
0x000000929000720bULL, 0x008fe40003fdd000ULL, 0x0000008d00717245ULL, 0x000fe2000020d400ULL,
0x0000000c200c723cULL, 0x000fe80000041838ULL, 0x000000e200897306ULL, 0x000fe20000209400ULL,
0x0000003f003f7245ULL, 0x002fc6000020d400ULL, 0x000000a02828723cULL, 0x000fe40000041804ULL,
0x0000000188886812ULL, 0x000fe400078efcffULL, 0x000000e2008c7306ULL, 0x0002e20000205400ULL,
0x000000727300720bULL, 0x004fe40003fbd000ULL, 0x0000006fac04723eULL, 0x000fe400000010ffULL,
0x0000006cb105723eULL, 0x000fe400000010ffULL, 0x0000003d88db723eULL, 0x000fe200000010ffULL,
0x0000008d00847306ULL, 0x000fe20000209400ULL, 0x000000e200e27245ULL, 0x002fc6000020d400ULL,
0x000000042004723cULL, 0x000fe4000004182cULL, 0x000000013f3f5812ULL, 0x000fe400078efcffULL,
0x0000008d00837306ULL, 0x000e620000205400ULL, 0x0000008c8900720bULL, 0x008fc60003fdd000ULL,
0x000000da2014723cULL, 0x000fe80000041814ULL, 0x000000a5007f7306ULL, 0x000fec0000209400ULL,
0x00000001e2e26812ULL, 0x000fc400078efcffULL, 0x000000a5007d7306ULL, 0x0004e20000205400ULL,
0x000000838400720bULL, 0x002fe40003f9d000ULL, 0x0000007c00837245ULL, 0x000fe4000020d400ULL,
0x000000e27070723eULL, 0x000fc600000010ffULL, 0x0000008700787306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x004fca000020d400ULL, 0x0000000171714812ULL, 0x000fe400078efcffULL,
0x0000008700757306ULL, 0x000e620000205400ULL, 0x0000007d7f00720bULL, 0x008fe40003f3d000ULL,
0x000000713f71723eULL, 0x000fca00000010ffULL, 0x00000000006a7306ULL, 0x000fe40000209400ULL,
0x000000702018723cULL, 0x000fe80000041818ULL, 0x00000001a5a51812ULL, 0x000fe400078efcffULL,
0x00000000006b7306ULL, 0x0004e20000205400ULL, 0x000000757800720bULL, 0x002fe40003fbd000ULL,
0x00000033a524723eULL, 0x000fca00000010ffULL, 0x00000031003e7306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x004fca000020d400ULL, 0x0000000125255812ULL, 0x000fe400078efcffULL,
0x0000003100687306ULL, 0x0002a20000205400ULL, 0x0000006b6a00720bULL, 0x008fe40003fdd000ULL,
0x000000322525723eULL, 0x000fca00000010ffULL, 0x0000008200727306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fe2000020d400ULL, 0x00000024201c723cULL, 0x000fe8000004181cULL,
0x0000000100006812ULL, 0x000fe400078efcffULL, 0x0000008200737306ULL, 0x0002e20000205400ULL,
0x000000683e00720bULL, 0x004fce0003f9d000ULL, 0x0000007c00387306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x002fca000020d400ULL, 0x0000000131314812ULL, 0x000fe400078efcffULL,
0x0000007c00347306ULL, 0x000e620000205400ULL, 0x000000737200720bULL, 0x008fda0003f3d000ULL,
0x0000000182821812ULL, 0x000fe400078efcffULL, 0x000000343800720bULL, 0x002fe40003f5d000ULL,
0x000000820082723eULL, 0x000fd600000010ffULL, 0x0000000183832812ULL, 0x000fc800078efcffULL,
0x000000833183723eULL, 0x000fce00000010ffULL, 0x000000822020723cULL, 0x000fe20000041828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff247f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004040007811ULL, 0x000fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000004100720cULL, 0x000fda0003f24070ULL, 0x0000f00000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x006fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff6a7624ULL, 0x000fe200078e00ffULL, 0x000000014c007812ULL, 0x000fe200078ec0ffULL,
0xffffffffff6d7424ULL, 0x000fc600078e00ffULL, 0x000000010000780cULL, 0x000fe40003f25070ULL,
0xffffffff6a6a7811ULL, 0x000fc800078e08ffULL, 0x000000016a6a7807ULL, 0x000fca0004800000ULL,
0x000000014c4c7824ULL, 0x000fca00078e026aULL, 0x000000034c00720cULL, 0x000fe40003f26070ULL,
0x00000004ff317819ULL, 0x000fd60000011644ULL, 0x0000006a49249210ULL, 0x000fe20007ffe051ULL,
0x00000004ff259424ULL, 0x000fc800078e00ffULL, 0x0000600024249625ULL, 0x000fca00078e0025ULL,
0x00000006246d9981ULL, 0x000362000c1e1900ULL, 0x0000006040007811ULL, 0x000fe400078e40ffULL,
0x00000004442f7811ULL, 0x040fe400078fe0ffULL, 0x0000000231327810ULL, 0x000fe40007ffe0ffULL,
0x00000006442e7811ULL, 0x000fe400078fe0ffULL, 0x0000006043257811ULL, 0x002fe200078e38ffULL,
0x0000000145697824ULL, 0x000fe200078e0232ULL, 0x0000000041247217ULL, 0x000fc40007800000ULL,
0x0000004525267210ULL, 0x000fc60007ffe031ULL, 0x0000000124247824ULL, 0x000fe200078e0a00ULL,
0x000000263c2d7210ULL, 0x040fe40007f3e0ffULL, 0x0000002f25007210ULL, 0x140fe40007ffe045ULL,
0x0000002e25267210ULL, 0x000fe20007ffe045ULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x00005e002d297a11ULL, 0x000fe200078240ffULL, 0x0000000169257824ULL, 0x000fe200078e0225ULL,
0x000000263c267210ULL, 0x000fe40007f7e0ffULL, 0x00005f002d2d7a11ULL, 0x000fc400008f4427ULL,
0x000000003c007210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x0000002024247807ULL, 0x000fe40000000000ULL, 0x00005e0000287a11ULL, 0x000fe200078440ffULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x0000002445247217ULL, 0x000fe40007800000ULL,
0x000000253c257210ULL, 0x000fe40007f3e0ffULL, 0x00005e00262a7a11ULL, 0x000fc400078640ffULL,
0x00005f0000277a11ULL, 0x000fe200010f4427ULL, 0x0000000124007824ULL, 0x000fe200078e0a45ULL,
0x00005f00262b7a11ULL, 0x000fe200018f442bULL, 0x000000ffff2c7224ULL, 0x000fe200008e06ffULL,
0x00005e0025267a11ULL, 0x000fe400078640ffULL, 0x0000004d29247210ULL, 0x080fe40007f9e0ffULL,
0x0000004d28287210ULL, 0x000fe40007fde0ffULL, 0x000000003100720cULL, 0x000fc40003f46070ULL,
0x00005f00252c7a11ULL, 0x000fe200018f442cULL, 0x000000ffff257224ULL, 0x000fe200020e062dULL,
0x0000004d26267210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe200030e0627ULL,
0x000000003200720cULL, 0x080fe40003f26070ULL, 0x000000002f00720cULL, 0x080fe20003f66070ULL,
0x000000ffff277224ULL, 0x000fe200028e062cULL, 0x000000002e00720cULL, 0x000fe40003f86070ULL,
0x0000004d2a2a7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024677faeULL, 0x0003e8000d101c46ULL, 0x000000ffff2b7224ULL, 0x000fc400028e062bULL,
0x0000000026667faeULL, 0x0003e8000c901c46ULL, 0x0000000028657faeULL, 0x0003e8000d901c46ULL,
0x000000002a647faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff347f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106280045247f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007844830ULL, 0x01062c0045267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x01062c0045267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0100800063267984ULL, 0x000e680000000800ULL,
0x0102800063277984ULL, 0x0007220000000800ULL, 0x000000462600720bULL, 0x002fe20003f3d000ULL,
0x000183027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff00287812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ffba7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000014200780cULL, 0x000fe40003f65270ULL, 0x000000462600720bULL, 0x000fe20003f34000ULL,
0x000182c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x0000002646247209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fe400078e3cffULL,
0x00000002ff2a7819ULL, 0x000fe20000011644ULL, 0x8000002446257221ULL, 0x000fe20000010000ULL,
0x010480246300b388ULL, 0x0003e20000000800ULL, 0x0000000028ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fcc0000410000ULL, 0x0000002500257308ULL, 0x000ee40000000800ULL,
0x0000002547477220ULL, 0x008fe20000410000ULL, 0x000182527f007947ULL, 0x000fea000b800000ULL,
0x00001f2a252a7589ULL, 0x0022e400000e0000ULL, 0x0000002a0c0c7220ULL, 0x08cfe20000410000ULL,
0x0000002a0d0d7220ULL, 0x080fe20000410000ULL, 0x0000002a10107220ULL, 0x080fe20000410000ULL,
0x0000002a11117220ULL, 0x080fe20000410000ULL, 0x0000002a04047220ULL, 0x080fe20000410000ULL,
0x0000002a05057220ULL, 0x080fe20000410000ULL, 0x0000002a08087220ULL, 0x080fe20000410000ULL,
0x0000002a09097220ULL, 0x080fe20000410000ULL, 0x0000002a14147220ULL, 0x080fe20000410000ULL,
0x0000002a15157220ULL, 0x080fe20000410000ULL, 0x0000002a18187220ULL, 0x080fe20000410000ULL,
0x0000002a19197220ULL, 0x080fe20000410000ULL, 0x0000002a1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002a1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002a20207220ULL, 0x080fe20000410000ULL,
0x0000002a21217220ULL, 0x000fe20000410000ULL, 0x000181a27f007947ULL, 0x000fea000b800000ULL,
0x00001f4e252a7589ULL, 0x0004e400000e0000ULL, 0x0000002646467209ULL, 0x000fe20007810000ULL,
0x0000002a0e0e7220ULL, 0x08cfe20000410000ULL, 0x00000001ffba7807ULL, 0x000fe20000800000ULL,
0x0000002a0f0f7220ULL, 0x080fe20000410000ULL, 0x0000002a12127220ULL, 0x080fe20000410000ULL,
0x8000004626261221ULL, 0x000fe20000010000ULL, 0x0000002a13137220ULL, 0x080fe20000410000ULL,
0x0000002a06067220ULL, 0x080fe20000410000ULL, 0x0000002a07077220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL, 0x0000002a0a0a7220ULL, 0x080fe20000410000ULL,
0x0000002a0b0b7220ULL, 0x080fe20000410000ULL, 0x0000002a16167220ULL, 0x080fe20000410000ULL,
0x00000026004b1308ULL, 0x000ea20000000800ULL, 0x0000002a17177220ULL, 0x080fe20000410000ULL,
0x0000002a1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002a1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002a1e1e7220ULL, 0x080fe20000410000ULL, 0x0000002a1f1f7220ULL, 0x080fe20000410000ULL,
0x0000002a22227220ULL, 0x080fe20000410000ULL, 0x0000002a23237220ULL, 0x000fe20000410000ULL,
0x000000274b271220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000004727477221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ee40000000800ULL,
0x8000000000ff7812ULL, 0x008fc40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff247984ULL, 0x000ee40000000800ULL,
0x8000000024ff7812ULL, 0x008fe40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004bff00723eULL, 0x000fe400000010ffULL, 0x00000002ff2b7819ULL, 0x000fc40000011644ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x00017f527f007947ULL, 0x000fea000b800000ULL,
0x00001f2b00687589ULL, 0x00072400000e0000ULL, 0x00017f927f007947ULL, 0x000fea000b800000ULL,
0x00001f4e006b7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x008fe200078e004fULL, 0x00006f9000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00018c7000007944ULL, 0x036fea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x008fe200078e0050ULL, 0x00006ff000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00018c1000007944ULL, 0x036fea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000612c783bULL, 0x000e620000004200ULL, 0x00009910baea7816ULL, 0x000fc600000000ffULL,
0x000000006028783bULL, 0x00cfe20000004200ULL, 0x000000ffea00720cULL, 0x000fc60003f25270ULL,
0x000000005f24783bULL, 0x002e680000004200ULL, 0x000000005e30783bULL, 0x000ea20000004200ULL,
0x000100002ce27824ULL, 0x040fe200078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe2000001142cULL,
0x0000002d00df7306ULL, 0x000fe20000009400ULL, 0x000001002ce37824ULL, 0x000fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe2000001142dULL, 0x000001002fca7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x000100002ecb7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe37819ULL, 0x000fe200000114e3ULL, 0x000001002ddb7824ULL, 0x000fe200078e00ffULL,
0x000000e200e87306ULL, 0x000fe20000209400ULL, 0x00000018ffca7819ULL, 0x000fe200000114caULL,
0x000100002fc47824ULL, 0x000fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x000100002dd77824ULL, 0x000fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x000001002ecc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x000000e200e97306ULL, 0x000ee20000205400ULL, 0x00000018ffd77819ULL, 0x000fe200000114d7ULL,
0x0000010025ea7824ULL, 0x002fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe2000001142fULL,
0x0000010028b17824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe20000011425ULL,
0x000001002baf7824ULL, 0x040fe200078e00ffULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x0000002d00e07306ULL, 0x000e620000005400ULL, 0x00000018ffb97819ULL, 0x000fe2000001142eULL,
0x000001002aac7824ULL, 0x040fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe20000011428ULL,
0x000100002ab37824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe20000011429ULL,
0x000100002bbb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x000000dc00dd7306ULL, 0x000fe20000209400ULL, 0x000000e9e800720bULL, 0x008fe20003fbd000ULL,
0x0001000025e87824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe2000001142aULL,
0x0001000024e97824ULL, 0x000fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fc400000114afULL,
0x00000018ff8e7819ULL, 0x000fe2000001142bULL, 0x000000dc00e17306ULL, 0x0007220000205400ULL,
0x000000e0df00720bULL, 0x002fe40003f7d000ULL, 0x00000018ffac7819ULL, 0x000fe400000114acULL,
0x00000018ffb37819ULL, 0x000fe400000114b3ULL, 0x00000018ff967819ULL, 0x000fe20000011424ULL,
0x000000d000d57306ULL, 0x000fe20000209400ULL, 0x000000dc00dc7245ULL, 0x008fc4000020d400ULL,
0x00000018ffba7819ULL, 0x000fe400000114bbULL, 0x00000018ffdf7819ULL, 0x000fe400000114e9ULL,
0x00000018ffe87819ULL, 0x000fe200000114e8ULL, 0x000000d000d67306ULL, 0x0002e20000205400ULL,
0x000000e1dd00720bULL, 0x010fe40003f5d000ULL, 0x000000e200dd7245ULL, 0x000fe4000020d400ULL,
0x00000018ff807819ULL, 0x000fc40000011426ULL, 0x00000001dddd5812ULL, 0x000fe200078efcffULL,
0x000000e300c77306ULL, 0x000fe20000209400ULL, 0x000000d000d07245ULL, 0x002fe4000020d400ULL,
0x00000018ff7d7819ULL, 0x000fe40000011427ULL, 0x00000018ff727819ULL, 0x004fe40000011430ULL,
0x00000001dcdc2812ULL, 0x000fe200078efcffULL, 0x000000e300de7306ULL, 0x000e620000205400ULL,
0x000000d6d500720bULL, 0x008fc40003fbd000ULL, 0x00000018ff3f7819ULL, 0x000fe40000011431ULL,
0x00000018ff007819ULL, 0x000fe40000011432ULL, 0x00000018ff367819ULL, 0x000fe20000011433ULL,
0x0000002d00877306ULL, 0x000ea2000000d400ULL, 0x000000dddcd6723eULL, 0x000fca00000010ffULL,
0x00000001d0d05812ULL, 0x000fe400078efcffULL, 0x000000ca00d47306ULL, 0x000fe20000209400ULL,
0x000000dec700720bULL, 0x002fe20003fdd000ULL, 0x0000010026de7824ULL, 0x000fca00078e00ffULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x000000ca00da7306ULL, 0x0002e20000205400ULL,
0x0000000187873812ULL, 0x004fce00078efcffULL, 0x0000002c00bc7306ULL, 0x000fe20000009400ULL,
0x000000ca00ca7245ULL, 0x002fce000020d400ULL, 0x0000002c00c67306ULL, 0x000e620000005400ULL,
0x000000dad400720bULL, 0x008fce0003f7d000ULL, 0x000000cb00cd7306ULL, 0x000fec0000209400ULL,
0x00000001caca3812ULL, 0x000fe400078efcffULL, 0x000000cb00d17306ULL, 0x0004e20000205400ULL,
0x000000c6bc00720bULL, 0x002fe20003f9d000ULL, 0x0000010024c67824ULL, 0x000fcc00078e00ffULL,
0x000000db00e47306ULL, 0x000fe20000209400ULL, 0x000000cb00cb7245ULL, 0x004fce000020d400ULL,
0x000000db00e77306ULL, 0x0003e20000205400ULL, 0x000000d1cd00720bULL, 0x008fce0003fbd000ULL,
0x000000c400ce7306ULL, 0x000fe20000209400ULL, 0x000000db00db7245ULL, 0x002fca000020d400ULL,
0x00000001cbcb5812ULL, 0x000fe400078efcffULL, 0x000000c400cf7306ULL, 0x0002b00000205400ULL,
0x0000002c00907306ULL, 0x000722000000d400ULL, 0x000000c400c47245ULL, 0x002fce000020d400ULL,
0x0000002e00d37306ULL, 0x000fe20000009400ULL, 0x00000100292c7824ULL, 0x008fe200078e00ffULL,
0x000000cfce00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002e00d27306ULL, 0x000e620000005400ULL, 0x0000000190904812ULL, 0x010fcc00078efcffULL,
0x00000001c4c43812ULL, 0x000fe200078efcffULL, 0x000000d700e67306ULL, 0x000ff00000209400ULL,
0x000000d700e57306ULL, 0x0004e20000205400ULL, 0x000000d2d300720bULL, 0x002fce0003f5d000ULL,
0x0000002500977306ULL, 0x000fe20000009400ULL, 0x000000d700d77245ULL, 0x004fce000020d400ULL,
0x00000025008a7306ULL, 0x000fe20000005400ULL, 0x000000e5e600720bULL, 0x008fce0003f9d000ULL,
0x0000002500757306ULL, 0x0003ec000000d400ULL, 0x00000001d7d74812ULL, 0x000fe400078efcffULL,
0x000000ab00b67306ULL, 0x000fe20000209400ULL, 0x000000e300257245ULL, 0x002fe4000020d400ULL,
0x000000d7d0d7723eULL, 0x000fc400000010ffULL, 0x0000000125256812ULL, 0x000fe400078efcffULL,
0x000000e7e400720bULL, 0x000fe20003fdd000ULL, 0x000000ab00b57306ULL, 0x0002a20000205400ULL,
0x000000902590723eULL, 0x000fce00000010ffULL, 0x000000cc00d87306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fc6000020d400ULL, 0x00000001dbdb6812ULL, 0x000fc800078efcffULL,
0x000000cc00d97306ULL, 0x0002e20000205400ULL, 0x000000b5b600720bULL, 0x004fe20003fbd000ULL,
0x0001000030b67824ULL, 0x000fe400078e00ffULL, 0x0001000031b57824ULL, 0x000fc600078e00ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x0000002c00c37306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fe4000020d400ULL, 0x00000018ffb57819ULL, 0x000fc600000114b5ULL,
0x00000001abab5812ULL, 0x000fe400078efcffULL, 0x0000002c00c57306ULL, 0x000e620000205400ULL,
0x000000d9d800720bULL, 0x008fce0003fdd000ULL, 0x0000002e00827306ULL, 0x000eac000000d400ULL,
0x00000001cccc6812ULL, 0x000fe400078efcffULL, 0x0000002900b77306ULL, 0x000fe20000009400ULL,
0x000000c5c300720bULL, 0x002fce0003f7d000ULL, 0x0000002900b87306ULL, 0x000fe20000005400ULL,
0x0000000182822812ULL, 0x004fc800078efcffULL, 0x00000082cc82723eULL, 0x000fc600000010ffULL,
0x00000029007c7306ULL, 0x0003f0000000d400ULL, 0x000000b900be7306ULL, 0x000fe20000209400ULL,
0x0001000029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x000000b900c07306ULL, 0x0002b00000205400ULL, 0x0000002f00c87306ULL, 0x000fe20000009400ULL,
0x000000b900b97245ULL, 0x002fce000020d400ULL, 0x0000002f00c97306ULL, 0x000e620000005400ULL,
0x000000c0be00720bULL, 0x004fe20003f5d000ULL, 0x0000010031c07824ULL, 0x000fcc00078e00ffULL,
0x000000a300aa7306ULL, 0x000fec0000209400ULL, 0x00000001b9b92812ULL, 0x000fe400078efcffULL,
0x000000a300a97306ULL, 0x0004e20000205400ULL, 0x000000c9c800720bULL, 0x002fe40003f9d000ULL,
0x00000018ffc87819ULL, 0x000fca00000114eaULL, 0x0000002800bd7306ULL, 0x000fe20000009400ULL,
0x000000a300a37245ULL, 0x004fce000020d400ULL, 0x0000002800bf7306ULL, 0x000e620000005400ULL,
0x000000a9aa00720bULL, 0x008fe40003fbd000ULL, 0x0000002c00a97245ULL, 0x000fc8000020d400ULL,
0x00000001a9a93812ULL, 0x000fe200078efcffULL, 0x0000002f00817306ULL, 0x000eac000000d400ULL,
0x00000001a3a35812ULL, 0x000fe400078efcffULL, 0x00000029002e7306ULL, 0x000fe20000209400ULL,
0x000000bfbd00720bULL, 0x002fe20003fdd000ULL, 0x0000010030bf7824ULL, 0x000fca00078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x00000029002f7306ULL, 0x000e620000205400ULL,
0x0000000181814812ULL, 0x004fe400078efcffULL, 0x000000b8b700720bULL, 0x000fca0003f9d000ULL,
0x000000b100c17306ULL, 0x000ff00000209400ULL, 0x000000b100c27306ULL, 0x0004e20000205400ULL,
0x0000002f2e00720bULL, 0x002fe40003f7d000ULL, 0x00000029002f7245ULL, 0x000fc4000020d400ULL,
0x000000017c7c4812ULL, 0x000fc600078efcffULL, 0x00000028007f7306ULL, 0x000322000000d400ULL,
0x000000b100b17245ULL, 0x004fe4000020d400ULL, 0x0000007ca9a9723eULL, 0x000fc600000010ffULL,
0x000000012f2f3812ULL, 0x000fe400078efcffULL, 0x0000002a009d7306ULL, 0x000fe20000009400ULL,
0x0001000028287824ULL, 0x002fe200078e00ffULL, 0x000000c2c100720bULL, 0x008fc80003f5d000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002a009e7306ULL, 0x000e620000005400ULL,
0x000000017f7f6812ULL, 0x010fe400078efcffULL, 0x00000028002e7245ULL, 0x000fc8000020d400ULL,
0x00000001b1b12812ULL, 0x000fe200078efcffULL, 0x0000002b00a07306ULL, 0x000ff00000009400ULL,
0x0000002b00a47306ULL, 0x000ea20000005400ULL, 0x0000009e9d00720bULL, 0x002fce0003fdd000ULL,
0x00000028002d7306ULL, 0x000ff00000209400ULL, 0x0000002800b27306ULL, 0x0002e20000205400ULL,
0x000000a4a000720bULL, 0x004fce0003f7d000ULL, 0x000000a700a87306ULL, 0x000fe20000209400ULL,
0x0000a8005d287811ULL, 0x002fce00078e20ffULL, 0x000000a7009c7306ULL, 0x0002a20000205400ULL,
0x000000b22d00720bULL, 0x008fce0003f5d000ULL, 0x0000002a007a7306ULL, 0x000ee2000000d400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x000000012e2e2812ULL, 0x000fe400078efcffULL,
0x0000009800a57306ULL, 0x000fe20000209400ULL, 0x0000009ca800720bULL, 0x004fe40003f9d000ULL,
0x0000002ea32e723eULL, 0x000fe400000010ffULL, 0x0000007fb1a8723eULL, 0x000fc600000010ffULL,
0x0000009800a67306ULL, 0x0002a20000205400ULL, 0x000000017a7a6812ULL, 0x008fca00078efcffULL,
0x00000001a7a74812ULL, 0x000fe400078efcffULL, 0x000000af00b07306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fe4000020d400ULL, 0x0000002fa72f723eULL, 0x000fca00000010ffULL,
0x000000af002a7306ULL, 0x0002e20000205400ULL, 0x000000a6a500720bULL, 0x004fce0003fdd000ULL,
0x0000002b00797306ULL, 0x000ea2000000d400ULL, 0x000000af00af7245ULL, 0x002fca000020d400ULL,
0x0000000198986812ULL, 0x000fe400078efcffULL, 0x0000008e009b7306ULL, 0x000fe20000209400ULL,
0x0000002ab000720bULL, 0x008fce0003fbd000ULL, 0x0000008e00a17306ULL, 0x0002e20000205400ULL,
0x0000000179793812ULL, 0x004fca00078efcffULL, 0x00000001afaf5812ULL, 0x000fe400078efcffULL,
0x000000ac00ad7306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x002fe4000020d400ULL,
0x00000079af79723eULL, 0x000fca00000010ffULL, 0x000000ac00ae7306ULL, 0x0002a20000205400ULL,
0x000000a19b00720bULL, 0x008fce0003f7d000ULL, 0x000000b300b47306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fca000020d400ULL, 0x000000018e8e3812ULL, 0x000fe400078efcffULL,
0x000000b3002b7306ULL, 0x0002e20000205400ULL, 0x000000aead00720bULL, 0x004fce0003f5d000ULL,
0x00000096009a7306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x002fca000020d400ULL,
0x00000001acac2812ULL, 0x000fe400078efcffULL, 0x0000009600997306ULL, 0x0002a20000205400ULL,
0x0000002bb400720bULL, 0x008fe40003f9d000ULL, 0x000000002828783bULL, 0x000eea0000000200ULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fca000020d400ULL,
0x00000001b3b34812ULL, 0x000fe400078efcffULL, 0x000000ba00bc7306ULL, 0x0003220000205400ULL,
0x000000999a00720bULL, 0x004fce0003fdd000ULL, 0x00000024009f7306ULL, 0x000fe20000009400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x0000000196966812ULL, 0x000fe400078efcffULL,
0x0000002400a27306ULL, 0x000e620000005400ULL, 0x000000bcbb00720bULL, 0x010fce0003fbd000ULL,
0x0000002400767306ULL, 0x000522000000d400ULL, 0x0000006828289231ULL, 0x088fe400003400ffULL,
0x000000682a2a9231ULL, 0x000fc600003400ffULL, 0x00000001baba5812ULL, 0x000fe200078efcffULL,
0x0000006b29299231ULL, 0x080fe200003400ffULL, 0x000000c800c97306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x004fe200000114c6ULL, 0x0000010027c67824ULL, 0x000fe200078e00ffULL,
0x000000a29f00720bULL, 0x002fe20003f5d000ULL, 0x0000006b2b2b9231ULL, 0x000fe200003400ffULL,
0x0000002400997245ULL, 0x000fe4000020d400ULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x000000c800bd7306ULL, 0x0002a60000205400ULL, 0x0000002e2818723cULL, 0x000fea0000041818ULL,
0x0000002400c77306ULL, 0x000fe20000209400ULL, 0x000000c800c87245ULL, 0x002fc4000020d400ULL,
0x0000000176762812ULL, 0x010fe200078efcffULL, 0x000000d62810723cULL, 0x000fe80000041810ULL,
0x0000002400e07306ULL, 0x0002e20000205400ULL, 0x000000bdc900720bULL, 0x004fc60003f7d000ULL,
0x000000a82814723cULL, 0x000fe80000041814ULL, 0x000000df00d57306ULL, 0x000fe20000209400ULL,
0x0000a8005c247811ULL, 0x002fca00078e20ffULL, 0x00000001c8c83812ULL, 0x000fe400078efcffULL,
0x000000df00d27306ULL, 0x0002a20000205400ULL, 0x000000e0c700720bULL, 0x008fce0003f9d000ULL,
0x000000de00be7306ULL, 0x000fe20000209400ULL, 0x000000df00df7245ULL, 0x002fca000020d400ULL,
0x0000000199994812ULL, 0x000fe400078efcffULL, 0x000000de002c7306ULL, 0x000e620000205400ULL,
0x000000d2d500720bULL, 0x004fe40003fbd000ULL, 0x0000008a9700720bULL, 0x000fe40003f9d000ULL,
0x00000018ff8a7819ULL, 0x000fe400000114c0ULL, 0x000000769976723eULL, 0x000fe200000010ffULL,
0x0000002600957306ULL, 0x000fec0000009400ULL, 0x00000001dfdf5812ULL, 0x000fc400078efcffULL,
0x0000002600897306ULL, 0x000ea20000005400ULL, 0x0000002cbe00720bULL, 0x002fe40003fdd000ULL,
0x0000000175754812ULL, 0x000fe400078efcffULL, 0x000000cbb92c723eULL, 0x000fe400000010ffULL,
0x000000df9696723eULL, 0x000fe200000010ffULL, 0x0000008c008d7306ULL, 0x000ff00000209400ULL,
0x0000008c008f7306ULL, 0x0002e20000205400ULL, 0x000000899500720bULL, 0x004fc40003f7d000ULL,
0x000000de00897245ULL, 0x000fc8000020d400ULL, 0x0000000189896812ULL, 0x000fe200078efcffULL,
0x000000e800b77306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x002fce000020d400ULL,
0x000000e800b87306ULL, 0x0002a20000205400ULL, 0x0000008f8d00720bULL, 0x008fce0003f5d000ULL,
0x000000c6009d7306ULL, 0x000fe20000209400ULL, 0x000000e800e87245ULL, 0x002fca000020d400ULL,
0x000000018c8c2812ULL, 0x000fe400078efcffULL, 0x000000c6009e7306ULL, 0x000e620000205400ULL,
0x000000b8b700720bULL, 0x004fce0003fbd000ULL, 0x00000026006f7306ULL, 0x0004ec000000d400ULL,
0x00000001e8e85812ULL, 0x000fe400078efcffULL, 0x0000008000867306ULL, 0x000fe20000209400ULL,
0x0001000026267824ULL, 0x004fe200078e00ffULL, 0x0000009e9d00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000008000857306ULL, 0x0002a20000205400ULL,
0x000000016f6f3812ULL, 0x008fce00078efcffULL, 0x0000003100917306ULL, 0x000fe20000009400ULL,
0x0000008000807245ULL, 0x002fce000020d400ULL, 0x0000003100927306ULL, 0x000e620000005400ULL,
0x000000858600720bULL, 0x004fce0003f7d000ULL, 0x0000002700937306ULL, 0x000fec0000009400ULL,
0x0000000180803812ULL, 0x000fe400078efcffULL, 0x0000002700947306ULL, 0x000ea20000005400ULL,
0x000000929100720bULL, 0x002fe40003f5d000ULL, 0x00000087db91723eULL, 0x000fc400000010ffULL,
0x000000c600877245ULL, 0x000fc6000020d400ULL, 0x0000003000887306ULL, 0x000fe20000009400ULL,
0x0000000187876812ULL, 0x000fe200078efcffULL, 0x00000090280c723cULL, 0x000fec000004180cULL,
0x00000030008b7306ULL, 0x000e620000005400ULL, 0x000000949300720bULL, 0x004fce0003f9d000ULL,
0x00000026002d7306ULL, 0x000ff00000209400ULL, 0x00000026009c7306ULL, 0x000ea20000205400ULL,
0x0000008b8800720bULL, 0x002fce0003fbd000ULL, 0x000000bf00977306ULL, 0x000ff00000209400ULL,
0x000000bf008d7306ULL, 0x0002e20000205400ULL, 0x0000009c2d00720bULL, 0x004fe40003fdd000ULL,
0x000000c4ab2d723eULL, 0x000fca00000010ffULL, 0x0000002700707306ULL, 0x000522000000d400ULL,
0x000000bf00bf7245ULL, 0x002fe2000020d400ULL, 0x0000002c2808723cULL, 0x000fec0000041808ULL,
0x0000007d00847306ULL, 0x000fe20000209400ULL, 0x0001000027277824ULL, 0x004fe200078e00ffULL,
0x0000008d9700720bULL, 0x008fc40003f7d000ULL, 0x000000b3982c723eULL, 0x000fe400000010ffULL,
0x00000018ff9b7819ULL, 0x000fe40000011427ULL, 0x0000007d00837306ULL, 0x0002a20000205400ULL,
0x0000000170704812ULL, 0x010fe400078efcffULL, 0x000000ba8e2d723eULL, 0x000fe400000010ffULL,
0x000000e88c97723eULL, 0x000fe400000010ffULL, 0x00000001bfbf3812ULL, 0x000fe200078efcffULL,
0x0000009b009f7306ULL, 0x000fe20000209400ULL, 0x0000007d007d7245ULL, 0x002fe2000020d400ULL,
0x0000002c2820723cULL, 0x000fe20000041820ULL, 0x000000708787723eULL, 0x000fca00000010ffULL,
0x0000009b009a7306ULL, 0x000e620000205400ULL, 0x000000838400720bULL, 0x004fe40003f9d000ULL,
0x0000002600847245ULL, 0x000fe4000020d400ULL, 0x00000081ca83723eULL, 0x000fe200000010ffULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x0000000184846812ULL, 0x000fe200078efcffULL,
0x00000030003b7306ULL, 0x000722000000d400ULL, 0x0000009b00817245ULL, 0x000fe4000020d400ULL,
0x000000848080723eULL, 0x000fe200000010ffULL, 0x000000822804723cULL, 0x000fe40000041804ULL,
0x000000017d7d4812ULL, 0x000fc400078efcffULL, 0x0000008a008f7306ULL, 0x000fe20000209400ULL,
0x0000009a9f00720bULL, 0x002fe20003fdd000ULL, 0x0000010033307824ULL, 0x008fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000008a008b7306ULL, 0x0002e20000205400ULL,
0x000000013b3b5812ULL, 0x010fca00078efcffULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x000000b600887306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x002fe4000020d400ULL,
0x000000817d81723eULL, 0x000fca00000010ffULL, 0x000000b600857306ULL, 0x0003220000205400ULL,
0x0000008b8f00720bULL, 0x008fe20003f7d000ULL, 0x0000006824249231ULL, 0x004fcc00003400ffULL,
0x00000032007e7306ULL, 0x000fe20000009400ULL, 0x000000b600b67245ULL, 0x002fe2000020d400ULL,
0x0000006826269231ULL, 0x000fe400003400ffULL, 0x0000006b25259231ULL, 0x080fe400003400ffULL,
0x000000018a8a3812ULL, 0x000fe200078efcffULL, 0x0000006b27279231ULL, 0x000fe200003400ffULL,
0x00000032007b7306ULL, 0x000e620000005400ULL, 0x000000858800720bULL, 0x010fca0003fbd000ULL,
0x000000962410723cULL, 0x040fe40000041810ULL, 0x0000007200737306ULL, 0x000fec0000209400ULL,
0x00000001b6b65812ULL, 0x000fe200078efcffULL, 0x000000802408723cULL, 0x000fe20000041808ULL,
0x0000007200747306ULL, 0x0004e20000205400ULL, 0x0000007b7e00720bULL, 0x002fce0003fdd000ULL,
0x0000003f006c7306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x004fce000020d400ULL,
0x0000003f00717306ULL, 0x0002a20000205400ULL, 0x000000747300720bULL, 0x008fe40003f7d000ULL,
0x000000b500737245ULL, 0x000fca000020d400ULL, 0x0000003300787306ULL, 0x000fe20000009400ULL,
0x0000003f003f7245ULL, 0x002fca000020d400ULL, 0x0000000172723812ULL, 0x000fe400078efcffULL,
0x0000003300777306ULL, 0x000e620000005400ULL, 0x000000716c00720bULL, 0x004fe40003fbd000ULL,
0x000000b67272723eULL, 0x000fca00000010ffULL, 0x00000031003c7306ULL, 0x0004ec000000d400ULL,
0x000000013f3f5812ULL, 0x000fe400078efcffULL, 0x000000b500867306ULL, 0x000fe20000209400ULL,
0x0000010032317824ULL, 0x004fe200078e00ffULL, 0x000000777800720bULL, 0x002fc40003f9d000ULL,
0x0000007aac78723eULL, 0x000fe400000010ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x000000b500827306ULL, 0x000e620000205400ULL, 0x000000013c3c2812ULL, 0x008fe400078efcffULL,
0x00000078281c723cULL, 0x000fe2000004181cULL, 0x00000075c877723eULL, 0x000fc800000010ffULL,
0x00000031007c7306ULL, 0x000fe40000209400ULL, 0x0000003bbf28723eULL, 0x000fe200000010ffULL,
0x00000076240c723cULL, 0x000fe2000004180cULL, 0x0000003c8a29723eULL, 0x000fc800000010ffULL,
0x00000031007b7306ULL, 0x0004e20000205400ULL, 0x000000828600720bULL, 0x002fe40003f5d000ULL,
0x000000282414723cULL, 0x000fe20000041814ULL, 0x0000006f8986723eULL, 0x000fc800000010ffULL,
0x00000030002e7306ULL, 0x000fe20000209400ULL, 0x0000003100317245ULL, 0x004fe4000020d400ULL,
0x000000862404723cULL, 0x000fe60000041804ULL, 0x0000000173732812ULL, 0x000fe400078efcffULL,
0x00000030002f7306ULL, 0x0002a20000205400ULL, 0x0000007b7c00720bULL, 0x008fe40003f7d000ULL,
0x000000733f73723eULL, 0x000fca00000010ffULL, 0x0000003200377306ULL, 0x000722000000d400ULL,
0x0000003000307245ULL, 0x002fe2000020d400ULL, 0x000000722418723cULL, 0x000fe80000041818ULL,
0x0000000131313812ULL, 0x000fe400078efcffULL, 0x0000003300387306ULL, 0x000322000000d400ULL,
0x0001000032327824ULL, 0x008fe200078e00ffULL, 0x0000002f2e00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000000003e7306ULL, 0x000fe20000209400ULL,
0x0001000033337824ULL, 0x002fe200078e00ffULL, 0x0000000137376812ULL, 0x010fc800078efcffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x00000000003d7306ULL, 0x0002a20000205400ULL,
0x0000000130305812ULL, 0x000fe400078efcffULL, 0x0000000138384812ULL, 0x000fe400078efcffULL,
0x000000373128723eULL, 0x000fe400000010ffULL, 0x000000383029723eULL, 0x000fe200000010ffULL,
0x00000036003a7306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x002fca000020d400ULL,
0x00000028241c723cULL, 0x000fe4000004181cULL, 0x0000003600397306ULL, 0x0002e20000205400ULL,
0x0000003d3e00720bULL, 0x004fce0003f5d000ULL, 0x00000032002a7306ULL, 0x000fe20000209400ULL,
0x0000003600367245ULL, 0x002fca000020d400ULL, 0x0000000100002812ULL, 0x000fe400078efcffULL,
0x00000032002b7306ULL, 0x0002a20000205400ULL, 0x000000393a00720bULL, 0x008fce0003f7d000ULL,
0x00000033002c7306ULL, 0x000fe20000209400ULL, 0x0000003200327245ULL, 0x002fca000020d400ULL,
0x0000000136363812ULL, 0x000fe400078efcffULL, 0x00000033002d7306ULL, 0x0002e20000205400ULL,
0x0000002b2a00720bULL, 0x004fe40003fdd000ULL, 0x0000003300337245ULL, 0x002fd6000020d400ULL,
0x0000000132326812ULL, 0x000fe400078efcffULL, 0x0000002d2c00720bULL, 0x008fe40003fbd000ULL,
0x000000320032723eULL, 0x000fd600000010ffULL, 0x0000000133335812ULL, 0x000fc800078efcffULL,
0x000000333633723eULL, 0x000fce00000010ffULL, 0x000000322424723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff207f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844821ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000227305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000220000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe40007844821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff2d7819ULL, 0x000fe20000011644ULL, 0x000058006d6c7a24ULL, 0x020fe200078e02ffULL,
0x0000008040007811ULL, 0x000fc400078e40ffULL, 0x000000022d2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001456b7824ULL, 0x000fe200078e022dULL, 0x0000000041207217ULL, 0x000fe20007800000ULL,
0x000000806c6c7824ULL, 0x000fe400078e00ffULL, 0x00000080432e7824ULL, 0x000fe400078e026bULL,
0x0000000120207824ULL, 0x000fc600078e0a00ULL, 0x0000006c2e2c7210ULL, 0x000fe40007f5e0ffULL,
0x0000002020207807ULL, 0x000fe40000000000ULL, 0x000000042e297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0x00005e002c2a7a11ULL, 0x000fe400078440ffULL,
0x0000002045207217ULL, 0x000fe40007800000ULL, 0x000000022e237810ULL, 0x000fc40007ffe0ffULL,
0x0000006c29297210ULL, 0x080fe40007f9e0ffULL, 0x00005f002c2c7a11ULL, 0x000fe200010f4400ULL,
0x0000000120007824ULL, 0x000fe200078e0a45ULL, 0x0000006c23237210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff207224ULL, 0x000fe200020e06ffULL, 0x00005e0029287a11ULL, 0x000fe400078840ffULL,
0x00005e0023227a11ULL, 0x000fe200078640ffULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x000000002b00720cULL, 0x000fc40003f46070ULL, 0x00005f0029297a11ULL, 0x000fe400020f4420ULL,
0x000000062e2b7810ULL, 0x000fe40007ffe0ffULL, 0x0000004d2a207210ULL, 0x080fe40007fbe0ffULL,
0x00005f0023237a11ULL, 0x000fe400018f4421ULL, 0x0000006c2b2b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200028e062cULL, 0x0000004d22227210ULL, 0x000fc40007fde0ffULL,
0x0000004d28287210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x000000042d2e7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200030e0623ULL,
0x000000002d00720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x000000062d2d7810ULL, 0x000fe40007ffe0ffULL, 0x00005e002b2a7a11ULL, 0x000fe400078840ffULL,
0x000000002e00720cULL, 0x000fc40003fc6070ULL, 0x000000002d00720cULL, 0x000fe40003fa6070ULL,
0x00005f002b007a11ULL, 0x000fe400020f442cULL, 0x0000004d2a2a7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000205b7faeULL, 0x0003e8000d901c46ULL,
0x000000ffff2b7224ULL, 0x000fe200020e0600ULL, 0x00000000225a7faeULL, 0x0003e8000d101c46ULL,
0x0000000028597faeULL, 0x0003e8000f101c46ULL, 0x000000002a587faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007844835ULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe400078e0031ULL,
0x0000000145687824ULL, 0x000fe200078e022dULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007844835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000207305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000200000735dULL, 0x004fe40003800000ULL,
0x0106b400ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fc40007844835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004bff00723eULL, 0x000fe400000010ffULL,
0x00000002ff2b7819ULL, 0x002fe40000011644ULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x00015b327f007947ULL, 0x000fea000b800000ULL, 0x00001f2b00827589ULL, 0x0002a400000e0000ULL,
0x00015b727f007947ULL, 0x000fea000b800000ULL, 0x00001f4e00817589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e004fULL,
0x0000948000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0001678000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e0050ULL,
0x000094e000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0001672000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005734783bULL, 0x000f680000004200ULL,
0x000000005628783bULL, 0x006e680000004200ULL, 0x000000005520783bULL, 0x000ea80000004200ULL,
0x00000000542c783bULL, 0x000ee20000004200ULL, 0x0000003400b17306ULL, 0x020fe20000009400ULL,
0x00000018ffb47819ULL, 0x000fe20000011434ULL, 0x0001000034b97824ULL, 0x000fe200078e00ffULL,
0x00000018ffd97819ULL, 0x000fe20000011435ULL, 0x0001000035e17824ULL, 0x000fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fe20000011436ULL, 0x0001000036d47824ULL, 0x000fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000003400ac7306ULL, 0x000f620000005400ULL,
0x00000018ffe17819ULL, 0x000fe200000114e1ULL, 0x0000010037d37824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe20000011437ULL, 0x0000010029c37824ULL, 0x002fe200078e00ffULL,
0x00000018ffd47819ULL, 0x000fe200000114d4ULL, 0x0000010028c97824ULL, 0x040fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x000000b400b77306ULL, 0x000fe20000209400ULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0001000028c47824ULL, 0x000fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0000010034b57824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011429ULL, 0x0001000037cf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fe200000114c4ULL, 0x000000b400b27306ULL, 0x0003220000205400ULL,
0x000000acb100720bULL, 0x020fe20003fdd000ULL, 0x0000010035e57824ULL, 0x000fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x0000010036da7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x000100002ba87824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe20000011428ULL, 0x00000034009e7306ULL, 0x000ae2000000d400ULL,
0x000000b400b47245ULL, 0x002fe2000020d400ULL, 0x0000010020b17824ULL, 0x004fe200078e00ffULL,
0x00000018ffe57819ULL, 0x000fc400000114e5ULL, 0x00000018ff9d7819ULL, 0x000fe4000001142aULL,
0x00000018ff997819ULL, 0x000fe2000001142bULL, 0x000000b900ea7306ULL, 0x000fe20000209400ULL,
0x000000b2b700720bULL, 0x010fe20003fbd000ULL, 0x000001002b347824ULL, 0x020fe200078e00ffULL,
0x000000b900b27245ULL, 0x000fe4000020d400ULL, 0x00000018ffa07819ULL, 0x000fe40000011420ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x000000b900ec7306ULL, 0x000e620000205400ULL,
0x000000019e9e6812ULL, 0x008fc400078efcffULL, 0x00000018ffda7819ULL, 0x000fe400000114daULL,
0x00000018ff8a7819ULL, 0x000fe40000011421ULL, 0x00000001b4b45812ULL, 0x000fe200078efcffULL,
0x000000e100e87306ULL, 0x000fe20000209400ULL, 0x00000018ff807819ULL, 0x000fe40000011422ULL,
0x00000018ff7a7819ULL, 0x000fe40000011423ULL, 0x00000018ffa87819ULL, 0x000fc400000114a8ULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x000000e100e67306ULL, 0x000ea20000205400ULL,
0x000000ecea00720bULL, 0x002fe20003f5d000ULL, 0x0000010021ea7824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe4000001142cULL, 0x00000018ff3a7819ULL, 0x000fe4000001142dULL,
0x00000018ffb97819ULL, 0x000fe200000114eaULL, 0x0000003600ba7306ULL, 0x000fe20000009400ULL,
0x00000018ff317819ULL, 0x000fc4000001142eULL, 0x00000018ff007819ULL, 0x000fc6000001142fULL,
0x00000001b2b22812ULL, 0x000fe400078efcffULL, 0x0000003600dd7306ULL, 0x000e620000005400ULL,
0x000000e6e800720bULL, 0x004fe40003fdd000ULL, 0x000000b2b4b2723eULL, 0x000fca00000010ffULL,
0x0000003700d57306ULL, 0x000ff00000009400ULL, 0x0000003700d67306ULL, 0x000ea20000005400ULL,
0x000000ddba00720bULL, 0x002fe40003fbd000ULL, 0x000000e100ba7245ULL, 0x000fc8000020d400ULL,
0x00000001baba6812ULL, 0x000fe200078efcffULL, 0x000000d900df7306ULL, 0x000ff00000209400ULL,
0x000000d900e07306ULL, 0x0002e20000205400ULL, 0x000000d6d500720bULL, 0x004fce0003fdd000ULL,
0x0000003500b37306ULL, 0x000fe20000009400ULL, 0x000000d900d97245ULL, 0x002fce000020d400ULL,
0x0000003500b67306ULL, 0x000e620000005400ULL, 0x000000e0df00720bULL, 0x008fce0003f5d000ULL,
0x0000003600847306ULL, 0x0004ec000000d400ULL, 0x00000001d9d92812ULL, 0x000fe400078efcffULL,
0x000000c200c87306ULL, 0x000fe20000209400ULL, 0x000000b6b300720bULL, 0x002fe20003f7d000ULL,
0x000100002a367824ULL, 0x004fc400078e00ffULL, 0x0001000023b67824ULL, 0x000fc600078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x000000c200c77306ULL, 0x0002a20000205400ULL,
0x0000000184845812ULL, 0x008fe400078efcffULL, 0x00000018ffb67819ULL, 0x000fca00000114b6ULL,
0x0000003700837306ULL, 0x000ee2000000d400ULL, 0x000000c200c27245ULL, 0x002fce000020d400ULL,
0x000000bd00c07306ULL, 0x000fe20000209400ULL, 0x000000c7c800720bULL, 0x004fce0003fbd000ULL,
0x000000bd00c17306ULL, 0x0002a20000205400ULL, 0x0000000183836812ULL, 0x008fca00078efcffULL,
0x00000001c2c25812ULL, 0x000fe400078efcffULL, 0x000000d400db7306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x002fce000020d400ULL, 0x000000d400dc7306ULL, 0x0002e20000205400ULL,
0x000000c1c000720bULL, 0x004fce0003fdd000ULL, 0x0000003500897306ULL, 0x000522000000d400ULL,
0x000000d400d47245ULL, 0x002fca000020d400ULL, 0x00000001bdbd6812ULL, 0x000fe400078efcffULL,
0x000000d300de7306ULL, 0x000fe20000209400ULL, 0x000000dcdb00720bULL, 0x008fe20003f5d000ULL,
0x000001002a357824ULL, 0x004fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x000000d300e47306ULL, 0x0002a20000205400ULL, 0x0000000189893812ULL, 0x010fca00078efcffULL,
0x00000001d4d42812ULL, 0x000fe400078efcffULL, 0x000000c300cd7306ULL, 0x000fe20000209400ULL,
0x000000d300d37245ULL, 0x002fce000020d400ULL, 0x000000c300d27306ULL, 0x0002e20000205400ULL,
0x000000e4de00720bULL, 0x004fce0003f7d000ULL, 0x0000002900bc7306ULL, 0x000fe20000009400ULL,
0x000000c300c37245ULL, 0x002fca000020d400ULL, 0x00000001d3d33812ULL, 0x000fe400078efcffULL,
0x0000002900bb7306ULL, 0x000fe20000005400ULL, 0x000000d2cd00720bULL, 0x008fe40003fbd000ULL,
0x00000083d383723eULL, 0x000fca00000010ffULL, 0x00000029007e7306ULL, 0x0003ec000000d400ULL,
0x00000001c3c35812ULL, 0x000fe400078efcffULL, 0x000000c900d07306ULL, 0x000fe20000209400ULL,
0x0001000029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x000000c900d17306ULL, 0x0002b00000205400ULL, 0x000000c400ca7306ULL, 0x000fe20000209400ULL,
0x000000c900c97245ULL, 0x002fce000020d400ULL, 0x000000c400ce7306ULL, 0x0002e20000205400ULL,
0x000000d1d000720bULL, 0x004fce0003f5d000ULL, 0x000000b500b87306ULL, 0x000fe20000209400ULL,
0x000000c400c47245ULL, 0x002fca000020d400ULL, 0x00000001c9c92812ULL, 0x000fe400078efcffULL,
0x000000b500eb7306ULL, 0x0002a20000205400ULL, 0x000000ceca00720bULL, 0x008fce0003fdd000ULL,
0x000000cf00d77306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x00000001c4c46812ULL, 0x000fe400078efcffULL, 0x000000cf00d87306ULL, 0x0002e20000205400ULL,
0x000000ebb800720bULL, 0x004fe20003f9d000ULL, 0x0001000021eb7824ULL, 0x000fe400078e00ffULL,
0x0001000022b87824ULL, 0x000fc600078e00ffULL, 0x00000018ffc07819ULL, 0x000fe200000114ebULL,
0x0000002900cb7306ULL, 0x000fe20000209400ULL, 0x000000cf00cf7245ULL, 0x002fe4000020d400ULL,
0x00000018ffb87819ULL, 0x000fc600000114b8ULL, 0x00000001b5b54812ULL, 0x000fe400078efcffULL,
0x0000002900cc7306ULL, 0x000e620000205400ULL, 0x000000d8d700720bULL, 0x008fe40003f7d000ULL,
0x0000009eb59e723eULL, 0x000fca00000010ffULL, 0x000000ae00b07306ULL, 0x000fec0000209400ULL,
0x00000001cfcf3812ULL, 0x000fe400078efcffULL, 0x000000ae00a47306ULL, 0x0004e20000205400ULL,
0x000000cccb00720bULL, 0x002fe40003fbd000ULL, 0x000000bbbc00720bULL, 0x000fc40003f7d000ULL,
0x000000cfbdbd723eULL, 0x000fc600000010ffULL, 0x0000009b00ab7306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x004fce000020d400ULL, 0x0000009b00a67306ULL, 0x0002a20000205400ULL,
0x000000a4b000720bULL, 0x008fe40003f5d000ULL, 0x0000002900a47245ULL, 0x000fe4000020d400ULL,
0x0000a80053297811ULL, 0x000fe400078e20ffULL, 0x00000001a4a45812ULL, 0x000fe200078efcffULL,
0x000000e500e77306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fe4000020d400ULL,
0x000000017e7e3812ULL, 0x000fc600078efcffULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x000000e500e97306ULL, 0x0002e20000205400ULL, 0x000000a6ab00720bULL, 0x004fe40003fdd000ULL,
0x0000007ec3c3723eULL, 0x000fca00000010ffULL, 0x0000002800c67306ULL, 0x000fe20000009400ULL,
0x000000e500e57245ULL, 0x002fca000020d400ULL, 0x000000019b9b6812ULL, 0x000fe400078efcffULL,
0x0000002800c57306ULL, 0x000fe20000005400ULL, 0x000000e9e700720bULL, 0x008fe40003f9d000ULL,
0x000000a49b9b723eULL, 0x000fca00000010ffULL, 0x00000028007f7306ULL, 0x000fec000000d400ULL,
0x00000001e5e54812ULL, 0x000fe400078efcffULL, 0x0000002a00a77306ULL, 0x000ff00000009400ULL,
0x0000002a00ad7306ULL, 0x000ff00000005400ULL, 0x0000002a007b7306ULL, 0x000ff0000000d400ULL,
0x0000003400287306ULL, 0x000ff00000209400ULL, 0x00000034002a7306ULL, 0x0002b00000205400ULL,
0x0000002b00af7306ULL, 0x000fe20000009400ULL, 0x0000003400347245ULL, 0x002fce000020d400ULL,
0x0000002b00aa7306ULL, 0x000e620000005400ULL, 0x0000002a2800720bULL, 0x004fce0003fbd000ULL,
0x0000002b00757306ULL, 0x0004ec000000d400ULL, 0x0000000134345812ULL, 0x000fe400078efcffULL,
0x00000020008e7306ULL, 0x000fe20000009400ULL, 0x00010000202b7824ULL, 0x004fe200078e00ffULL,
0x000000aaaf00720bULL, 0x002fe20003f7d000ULL, 0x000001002caf7824ULL, 0x000fc600078e00ffULL,
0x00000018ffd57819ULL, 0x000fe4000001142bULL, 0x00000020009a7306ULL, 0x000e620000005400ULL,
0x000000002928783bULL, 0x000eac0000000200ULL, 0x0000000175753812ULL, 0x008fe200078efcffULL,
0x0000002000747306ULL, 0x000730000000d400ULL, 0x00000021008f7306ULL, 0x000fe20000009400ULL,
0x0000010023207824ULL, 0x008fe200078e00ffULL, 0x0000009a8e00720bULL, 0x002fc40003f7d000ULL,
0x000000c4ae9a723eULL, 0x000fe400000010ffULL, 0x00000018ffa67819ULL, 0x000fe40000011420ULL,
0x00000021008c7306ULL, 0x000fe20000005400ULL, 0x0000a80052207811ULL, 0x000fcc00078e20ffULL,
0x0000000174743812ULL, 0x010fe200078efcffULL, 0x0000002100717306ULL, 0x0003f0000000d400ULL,
0x000000da00e27306ULL, 0x000fe20000209400ULL, 0x0000010022217824ULL, 0x002fe200078e00ffULL,
0x0000008228289231ULL, 0x004fc400003400ffULL, 0x000000822a2a9231ULL, 0x000fe400003400ffULL,
0x00000018ffbb7819ULL, 0x000fe20000011421ULL, 0x0000008129299231ULL, 0x080fe200003400ffULL,
0x000000da00e37306ULL, 0x0002a20000205400ULL, 0x000000812b2b9231ULL, 0x000fce00003400ffULL,
0x0000002200987306ULL, 0x000fe20000009400ULL, 0x000000da00da7245ULL, 0x002fe2000020d400ULL,
0x0000009a2818723cULL, 0x000fec0000041818ULL, 0x00000022008b7306ULL, 0x000fe20000005400ULL,
0x000000e3e200720bULL, 0x004fce0003f9d000ULL, 0x00000022006f7306ULL, 0x000fec000000d400ULL,
0x00000001dada4812ULL, 0x000fe400078efcffULL, 0x0000002300a27306ULL, 0x000fe20000009400ULL,
0x000000c5c600720bULL, 0x000fe20003f9d000ULL, 0x000100002dc67824ULL, 0x000fca00078e00ffULL,
0x00000018ffc67819ULL, 0x000fe200000114c6ULL, 0x0000002300907306ULL, 0x000e6c0000005400ULL,
0x000000017f7f4812ULL, 0x000fe400078efcffULL, 0x00000023003f7306ULL, 0x0004e2000000d400ULL,
0x000000ada700720bULL, 0x000fce0003f9d000ULL, 0x000000d500d67306ULL, 0x000fe20000209400ULL,
0x000000002020783bULL, 0x004ea20000000200ULL, 0x00000090a200720bULL, 0x002fc80003f7d000ULL,
0x000000017b7b4812ULL, 0x000fe400078efcffULL, 0x000000d500c57306ULL, 0x0003ee0000205400ULL,
0x000000013f3f3812ULL, 0x008fe200078efcffULL, 0x0000003500be7306ULL, 0x000fe20000209400ULL,
0x000000d500d57245ULL, 0x002fce000020d400ULL, 0x0000003500bf7306ULL, 0x0002f00000205400ULL,
0x0000009d00917306ULL, 0x000fe20000209400ULL, 0x0000003500357245ULL, 0x002fce000020d400ULL,
0x0000009d00967306ULL, 0x0003220000205400ULL, 0x0000008220209231ULL, 0x084fe200003400ffULL,
0x000000bfbe00720bULL, 0x008fe20003f5d000ULL, 0x0000008222229231ULL, 0x000fe200003400ffULL,
0x000001002dbf7824ULL, 0x000fe200078e00ffULL, 0x0000008121219231ULL, 0x080fe200003400ffULL,
0x000100002cbe7824ULL, 0x000fe200078e00ffULL, 0x0000008123239231ULL, 0x000fe200003400ffULL,
0x000000bb00b07306ULL, 0x000fe20000209400ULL, 0x000000c5d600720bULL, 0x000fe40003f3d000ULL,
0x0000009d009d7245ULL, 0x002fc4000020d400ULL, 0x00000018ff817819ULL, 0x000fe400000114beULL,
0x0000000135352812ULL, 0x000fe200078efcffULL, 0x000000bb00a77306ULL, 0x0002a20000205400ULL,
0x000000969100720bULL, 0x010fe40003fdd000ULL, 0x00000084da82723eULL, 0x000fc600000010ffULL,
0x00000001d5d51812ULL, 0x000fe400078efcffULL, 0x0000003600377306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fe2000020d400ULL, 0x000000822804723cULL, 0x000fe80000041804ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x0000003600a97306ULL, 0x0002e20000205400ULL,
0x000000a7b000720bULL, 0x004fc40003f3d000ULL, 0x0000008b9800720bULL, 0x000fe40003fdd000ULL,
0x00000018ff8b7819ULL, 0x000fc600000114bfULL, 0x000000a800a57306ULL, 0x000fe20000209400ULL,
0x0000003600367245ULL, 0x002fca000020d400ULL, 0x00000001bbbb1812ULL, 0x000fe400078efcffULL,
0x000000a800ac7306ULL, 0x0002a20000205400ULL, 0x000000a93700720bULL, 0x008fe40003f5d000ULL,
0x00000018ff377819ULL, 0x000fe400000114afULL, 0x000000016f6f6812ULL, 0x000fc600078efcffULL,
0x0000009900937306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x0000000136362812ULL, 0x000fe400078efcffULL, 0x00000099009c7306ULL, 0x0002e20000205400ULL,
0x000000aca500720bULL, 0x004fe40003fbd000ULL, 0x0000008c8f00720bULL, 0x000fe40003f5d000ULL,
0x000000369d36723eULL, 0x000fc600000010ffULL, 0x000000a600ab7306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fca000020d400ULL, 0x00000001a8a85812ULL, 0x000fe400078efcffULL,
0x000000a600ad7306ULL, 0x0002a20000205400ULL, 0x0000009c9300720bULL, 0x008fe40003f9d000ULL,
0x0000000171712812ULL, 0x000fca00078efcffULL, 0x000000b100b37306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fca000020d400ULL, 0x0000000199994812ULL, 0x000fe400078efcffULL,
0x000000b100b77306ULL, 0x0002e20000205400ULL, 0x000000adab00720bULL, 0x004fce0003f3d000ULL,
0x0000008000867306ULL, 0x000fe20000209400ULL, 0x000000b100b17245ULL, 0x002fca000020d400ULL,
0x00000001a6a61812ULL, 0x000fe400078efcffULL, 0x0000008000857306ULL, 0x0002a20000205400ULL,
0x000000b7b300720bULL, 0x008fe40003fbd000ULL, 0x000000bad9b3723eULL, 0x000fca00000010ffULL,
0x000000b900df7306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fe2000020d400ULL,
0x000000b22810723cULL, 0x000fe80000041810ULL, 0x00000001b1b15812ULL, 0x000fe400078efcffULL,
0x000000b900dd7306ULL, 0x0002e20000205400ULL, 0x000000858600720bULL, 0x004fe40003fdd000ULL,
0x00000074b174723eULL, 0x000fca00000010ffULL, 0x000000b800aa7306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x000000b800917306ULL, 0x0002a20000205400ULL, 0x000000dddf00720bULL, 0x008fce0003f9d000ULL,
0x000000a000a37306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x002fca000020d400ULL,
0x00000001b9b94812ULL, 0x000fe400078efcffULL, 0x000000a000947306ULL, 0x0002e20000205400ULL,
0x00000091aa00720bULL, 0x004fce0003f3d000ULL, 0x0000008a00a17306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x002fca000020d400ULL, 0x00000001b8b81812ULL, 0x000fe400078efcffULL,
0x0000008a00977306ULL, 0x0002a20000205400ULL, 0x00000094a300720bULL, 0x008fe40003fbd000ULL,
0x000000b88080723eULL, 0x000fca00000010ffULL, 0x0000007a007d7306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x002fca000020d400ULL, 0x00000001a0a05812ULL, 0x000fe400078efcffULL,
0x0000007a007c7306ULL, 0x0002e20000205400ULL, 0x00000097a100720bULL, 0x004fe40003f5d000ULL,
0x000000d5a0a0723eULL, 0x000fca00000010ffULL, 0x000000c000c17306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x002fca000020d400ULL, 0x000000018a8a2812ULL, 0x000fe400078efcffULL,
0x000000c000bc7306ULL, 0x0002a20000205400ULL, 0x0000007c7d00720bULL, 0x008fce0003f3d000ULL,
0x00000037008f7306ULL, 0x000fe20000209400ULL, 0x000000c000c07245ULL, 0x002fca000020d400ULL,
0x000000017a7a1812ULL, 0x000fe400078efcffULL, 0x0000003700937306ULL, 0x000e620000205400ULL,
0x000000bcc100720bULL, 0x004fe40003f9d000ULL, 0x000000d4c2bc723eULL, 0x000fe400000010ffULL,
0x0000007fc9c2723eULL, 0x000fc600000010ffULL, 0x000000b6008e7306ULL, 0x000fe40000209400ULL,
0x000000bc2808723cULL, 0x040fe80000041808ULL, 0x00000001c0c04812ULL, 0x000fe400078efcffULL,
0x000000b6008c7306ULL, 0x0004e20000205400ULL, 0x000000938f00720bULL, 0x002fe20003fdd000ULL,
0x000000c22814723cULL, 0x000fe20000041814ULL, 0x000000c08aa1723eULL, 0x000fca00000010ffULL,
0x0000002c008d7306ULL, 0x000fe20000009400ULL, 0x000000b600b67245ULL, 0x004fe2000020d400ULL,
0x000000a02010723cULL, 0x000fec0000041810ULL, 0x0000002c00927306ULL, 0x000e620000005400ULL,
0x0000008c8e00720bULL, 0x008fce0003f7d000ULL, 0x0000002e00887306ULL, 0x000fec0000009400ULL,
0x00000001b6b63812ULL, 0x000fe400078efcffULL, 0x0000002e00877306ULL, 0x000ea20000005400ULL,
0x000000928d00720bULL, 0x002fce0003fbd000ULL, 0x0000002d009f7306ULL, 0x000ff00000009400ULL,
0x0000002d00957306ULL, 0x000e620000005400ULL, 0x000000878800720bULL, 0x004fce0003f5d000ULL,
0x0000007000767306ULL, 0x000ff00000209400ULL, 0x0000007000777306ULL, 0x0004e20000205400ULL,
0x000000959f00720bULL, 0x002fe40003f9d000ULL, 0x00000089e59f723eULL, 0x000fca00000010ffULL,
0x0000008b00907306ULL, 0x000fe20000209400ULL, 0x0000007000707245ULL, 0x004fe2000020d400ULL,
0x0000009e280c723cULL, 0x000fec000004180cULL, 0x0000008b00947306ULL, 0x0002a20000205400ULL,
0x000000777600720bULL, 0x008fce0003f3d000ULL, 0x0000002c00397306ULL, 0x000722000000d400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x0000000170701812ULL, 0x000fe400078efcffULL,
0x0000002d00387306ULL, 0x000362000000d400ULL, 0x000001002f2c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001142cULL, 0x0000002f00797306ULL, 0x000fe20000009400ULL,
0x000001002e2d7824ULL, 0x002fe200078e00ffULL, 0x0000007b352c723eULL, 0x000fe400000010ffULL,
0x0000003700357245ULL, 0x000fe4000020d400ULL, 0x00000018ff7f7819ULL, 0x000fe4000001142dULL,
0x0000002f00787306ULL, 0x000e620000005400ULL, 0x0000000135356812ULL, 0x000fc400078efcffULL,
0x000000949000720bULL, 0x004fe40003fdd000ULL, 0x00000075342d723eULL, 0x000fe400000010ffULL,
0x000000a89937723eULL, 0x000fe200000010ffULL, 0x0000003a00737306ULL, 0x000fe20000209400ULL,
0x0000000139395812ULL, 0x010fe400078efcffULL, 0x0000000138384812ULL, 0x020fe200078efcffULL,
0x0000002c281c723cULL, 0x000fe2000004181cULL, 0x00000071b975723eULL, 0x000fc600000010ffULL,
0x0000003a00727306ULL, 0x0004e20000205400ULL, 0x000000787900720bULL, 0x002fe40003f7d000ULL,
0x000000018b8b6812ULL, 0x000fe200078efcffULL, 0x000000362824723cULL, 0x000fe80000041824ULL,
0x00000081008d7306ULL, 0x000fe20000209400ULL, 0x0000003a003a7245ULL, 0x004fe4000020d400ULL,
0x00000081002a7245ULL, 0x000fe2000020d400ULL, 0x00000074200c723cULL, 0x000fe2000004180cULL,
0x000000c6002b7245ULL, 0x000fc4000020d400ULL, 0x0000006fbb28723eULL, 0x000fe200000010ffULL,
0x0000008100877306ULL, 0x0002a20000205400ULL, 0x000000727300720bULL, 0x008fe40003fbd000ULL,
0x0000003fa629723eULL, 0x000fca00000010ffULL, 0x000000c600847306ULL, 0x000fe20000209400ULL,
0x000000b67a81723eULL, 0x002fe200000010ffULL, 0x000000282004723cULL, 0x040fe80000041804ULL,
0x000000013a3a5812ULL, 0x000fe400078efcffULL, 0x000000c600857306ULL, 0x000e620000205400ULL,
0x000000878d00720bULL, 0x004fe20003fdd000ULL, 0x000000802008723cULL, 0x000fe20000041808ULL,
0x000000393528723eULL, 0x000fc400000010ffULL, 0x000000388b29723eULL, 0x000fc600000010ffULL,
0x0000007f007e7306ULL, 0x000fe80000209400ULL, 0x000000282014723cULL, 0x000fe40000041814ULL,
0x000000012a2a6812ULL, 0x000fe400078efcffULL, 0x0000007f007c7306ULL, 0x0004e20000205400ULL,
0x000000858400720bULL, 0x002fe40003f9d000ULL, 0x0000002a702a723eULL, 0x000fca00000010ffULL,
0x0000002e00327306ULL, 0x000322000000d400ULL, 0x0000007f007f7245ULL, 0x004fca000020d400ULL,
0x000000012b2b4812ULL, 0x000fe400078efcffULL, 0x0000002f00337306ULL, 0x000562000000d400ULL,
0x000100002e2e7824ULL, 0x002fe200078e00ffULL, 0x0000007c7e00720bULL, 0x008fe40003f3d000ULL,
0x0000002b3a2b723eULL, 0x000fe400000010ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000007d00787306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x004fe200078e00ffULL,
0x0000000132322812ULL, 0x010fe200078efcffULL, 0x0000002a2018723cULL, 0x000fe60000041818ULL,
0x00000018ff2f7819ULL, 0x000fc4000001142fULL, 0x0000007d00347306ULL, 0x0002a20000205400ULL,
0x000000017f7f1812ULL, 0x000fe400078efcffULL, 0x0000000133333812ULL, 0x020fe400078efcffULL,
0x000000327f32723eULL, 0x000fc600000010ffULL, 0x00000031003d7306ULL, 0x000fe20000209400ULL,
0x0000007d007d7245ULL, 0x002fce000020d400ULL, 0x00000031003e7306ULL, 0x0002e20000205400ULL,
0x000000347800720bULL, 0x004fce0003fbd000ULL, 0x00000000003b7306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fca000020d400ULL, 0x000000017d7d5812ULL, 0x000fe400078efcffULL,
0x00000000003c7306ULL, 0x0002a20000205400ULL, 0x0000003e3d00720bULL, 0x008fe40003fdd000ULL,
0x000000337d33723eULL, 0x000fca00000010ffULL, 0x0000002e002c7306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x002fe2000020d400ULL, 0x00000032201c723cULL, 0x000fe8000004181cULL,
0x0000000131316812ULL, 0x000fe400078efcffULL, 0x0000002e002d7306ULL, 0x0002e20000205400ULL,
0x0000003c3b00720bULL, 0x004fce0003f9d000ULL, 0x0000002f00367306ULL, 0x000fe20000209400ULL,
0x0000002e002e7245ULL, 0x002fca000020d400ULL, 0x0000000100004812ULL, 0x000fe400078efcffULL,
0x0000002f00377306ULL, 0x0002a20000205400ULL, 0x0000002d2c00720bULL, 0x008fe40003f3d000ULL,
0x0000002f002f7245ULL, 0x002fd6000020d400ULL, 0x000000012e2e1812ULL, 0x000fe400078efcffULL,
0x000000373600720bULL, 0x004fe40003f5d000ULL, 0x0000002e312e723eULL, 0x000fd600000010ffULL,
0x000000012f2f2812ULL, 0x000fc800078efcffULL, 0x0000002f002f723eULL, 0x000fce00000010ffULL,
0x0000002e2020723cULL, 0x000fe20000041824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008040007811ULL, 0x000fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000004100720cULL, 0x000fda0003f24070ULL,
0x00009fb000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x006fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff2f7819ULL, 0x000fe40000011644ULL,
0x0000002043277811ULL, 0x000fe400078e38ffULL, 0x000000a040247811ULL, 0x000fe400078e40ffULL,
0x0000002f27007210ULL, 0x000fe40007ffe045ULL, 0x0000002441257217ULL, 0x000fe40007800000ULL,
0x000000006c007210ULL, 0x000fc40007f3e0ffULL, 0x000000022f337810ULL, 0x000fe20007ffe0ffULL,
0x0000000125267824ULL, 0x000fe200078e0a24ULL, 0x000000062f317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005e00002d7a11ULL, 0x040fe400078240ffULL,
0x0000003327257210ULL, 0x000fe40007ffe045ULL, 0x00005f00002e7a11ULL, 0x000fe400008f442eULL,
0x000000042f327810ULL, 0x000fc40007ffe0ffULL, 0x0000003127007210ULL, 0x140fe40007ffe045ULL,
0x000000256c2c7210ULL, 0x040fe40007f3e0ffULL, 0x0000003227247210ULL, 0x000fe40007ffe045ULL,
0x000000006c2b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x0000002026267807ULL, 0x000fe40000000000ULL, 0x000000246c297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x0000002645267217ULL, 0x000fc40007800000ULL,
0x00005e002c277a11ULL, 0x040fe200078240ffULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe400078640ffULL, 0x00005f002c2c7a11ULL, 0x000fe200008f4400ULL,
0x0000000126007824ULL, 0x000fe200078e0a45ULL, 0x00005e0029287a11ULL, 0x000fe400078440ffULL,
0x00005f002b2b7a11ULL, 0x000fe400018f4424ULL, 0x0000004d2d247210ULL, 0x000fc40007f7e0ffULL,
0x0000004d27267210ULL, 0x080fe40007f9e0ffULL, 0x00005f0029297a11ULL, 0x000fe200010f4425ULL,
0x000000ffff257224ULL, 0x000fe200018e062eULL, 0x000000002f00720cULL, 0x080fe20003f46070ULL,
0x000000ffff277224ULL, 0x000fe200020e062cULL, 0x0000004d28287210ULL, 0x000fe40007fbe0ffULL,
0x000000003300720cULL, 0x080fe40003f26070ULL, 0x000000003200720cULL, 0x080fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x000000003100720cULL, 0x000fc40003f86070ULL,
0x0000004d2a2a7210ULL, 0x000fc60007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024677faeULL, 0x0003e4000d101c46ULL, 0x000000ffff2b7224ULL, 0x000fe400028e062bULL,
0x0000000026667faeULL, 0x0003e8000c901c46ULL, 0x0000000028657faeULL, 0x0003e8000d901c46ULL,
0x000000002a647faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff707f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106480045247f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007844830ULL, 0x01064c0045267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x01064c0045267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101000063267984ULL, 0x000e680000000800ULL,
0x0103000063277984ULL, 0x0007220000000800ULL, 0x000000462600720bULL, 0x002fe20003f3d000ULL,
0x000136827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff00287812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ffbe7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000024200780cULL, 0x000fe40003f65270ULL, 0x000000462600720bULL, 0x000fe20003f34000ULL,
0x000136427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x0000002646247209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fe400078e3cffULL,
0x00000002ff2a7819ULL, 0x000fe20000011644ULL, 0x8000002446257221ULL, 0x000fe20000010000ULL,
0x010500246300b388ULL, 0x0003e20000000800ULL, 0x0000000028ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fcc0000410000ULL, 0x0000002500257308ULL, 0x000ee40000000800ULL,
0x0000002547477220ULL, 0x008fe20000410000ULL, 0x000135d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a252a7589ULL, 0x0022e400000e0000ULL, 0x0000002a0c0c7220ULL, 0x08cfe20000410000ULL,
0x0000002a0d0d7220ULL, 0x080fe20000410000ULL, 0x0000002a10107220ULL, 0x080fe20000410000ULL,
0x0000002a11117220ULL, 0x080fe20000410000ULL, 0x0000002a04047220ULL, 0x080fe20000410000ULL,
0x0000002a05057220ULL, 0x080fe20000410000ULL, 0x0000002a08087220ULL, 0x080fe20000410000ULL,
0x0000002a09097220ULL, 0x080fe20000410000ULL, 0x0000002a14147220ULL, 0x080fe20000410000ULL,
0x0000002a15157220ULL, 0x080fe20000410000ULL, 0x0000002a18187220ULL, 0x080fe20000410000ULL,
0x0000002a19197220ULL, 0x080fe20000410000ULL, 0x0000002a1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002a1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002a20207220ULL, 0x080fe20000410000ULL,
0x0000002a21217220ULL, 0x000fe20000410000ULL, 0x000135227f007947ULL, 0x000fea000b800000ULL,
0x00001f4e252a7589ULL, 0x0004e400000e0000ULL, 0x0000002646467209ULL, 0x000fe20007810000ULL,
0x0000002a0e0e7220ULL, 0x08cfe20000410000ULL, 0x00000001ffbe7807ULL, 0x000fe20000800000ULL,
0x0000002a0f0f7220ULL, 0x080fe20000410000ULL, 0x0000002a12127220ULL, 0x080fe20000410000ULL,
0x8000004626261221ULL, 0x000fe20000010000ULL, 0x0000002a13137220ULL, 0x080fe20000410000ULL,
0x0000002a06067220ULL, 0x080fe20000410000ULL, 0x0000002a07077220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL, 0x0000002a0a0a7220ULL, 0x080fe20000410000ULL,
0x0000002a0b0b7220ULL, 0x080fe20000410000ULL, 0x0000002a16167220ULL, 0x080fe20000410000ULL,
0x00000026004b1308ULL, 0x000ea20000000800ULL, 0x0000002a17177220ULL, 0x080fe20000410000ULL,
0x0000002a1a1a7220ULL, 0x080fe20000410000ULL, 0x0000002a1b1b7220ULL, 0x080fe20000410000ULL,
0x0000002a1e1e7220ULL, 0x080fe20000410000ULL, 0x0000002a1f1f7220ULL, 0x080fe20000410000ULL,
0x0000002a22227220ULL, 0x080fe20000410000ULL, 0x0000002a23237220ULL, 0x000fe20000410000ULL,
0x000000274b271220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000004727477221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ee40000000800ULL,
0x8000000000ff7812ULL, 0x008fc40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff247984ULL, 0x000ee40000000800ULL,
0x8000000024ff7812ULL, 0x008fe40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004bff00723eULL, 0x000fe400000010ffULL, 0x00000002ff2b7819ULL, 0x000fc40000011644ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000132d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2b007b7589ULL, 0x00072400000e0000ULL, 0x000133127f007947ULL, 0x000fea000b800000ULL,
0x00001f4e007c7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x008fe200078e004fULL, 0x0000bf1000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00013cf000007944ULL, 0x016fea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x008fe200078e0050ULL, 0x0000bf7000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00013c9000007944ULL, 0x016fea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006130783bULL, 0x000f680000004200ULL, 0x000000005f28783bULL, 0x00cea80000004200ULL,
0x00000000602c783bULL, 0x000ee80000004200ULL, 0x000000005e24783bULL, 0x002e620000004200ULL,
0x0001000030e07824ULL, 0x060fe200078e00ffULL, 0x0000003100bf7306ULL, 0x000fe20000009400ULL,
0x0000010030c87824ULL, 0x000fe200078e00ffULL, 0x00000018ffd37819ULL, 0x000fe20000011431ULL,
0x0000010033cd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x0001000031da7824ULL, 0x040fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x0000010031de7824ULL, 0x000fe200078e00ffULL, 0x000000e000e87306ULL, 0x000fe20000209400ULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x0001000032ce7824ULL, 0x040fe200078e00ffULL,
0x00000018ffda7819ULL, 0x000fe200000114daULL, 0x0001000033c97824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x004fe20000011428ULL, 0x0000010032cf7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe20000011429ULL, 0x000000e000ea7306ULL, 0x000ea20000205400ULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x000100002db67824ULL, 0x008fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001142aULL, 0x000001002fb47824ULL, 0x000fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x000001002eb37824ULL, 0x040fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x000000c800e57306ULL, 0x000fe20000209400ULL,
0x00000018ffdf7819ULL, 0x000fe20000011430ULL, 0x000100002ebb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fc400000114cfULL, 0x00000018ffae7819ULL, 0x000fe40000011433ULL,
0x00000018ffa87819ULL, 0x000fe2000001142cULL, 0x000000c800e97306ULL, 0x000ee20000205400ULL,
0x000000eae800720bULL, 0x004fe20003fbd000ULL, 0x0000010029e87824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe400000114b6ULL, 0x00000018ffb97819ULL, 0x000fe40000011432ULL,
0x00000018ffac7819ULL, 0x000fe2000001142dULL, 0x0000003100e77306ULL, 0x000ea20000005400ULL,
0x00000018ff9b7819ULL, 0x000fc4000001142eULL, 0x00000018ff917819ULL, 0x000fe4000001142fULL,
0x00000018ffb47819ULL, 0x000fe400000114b4ULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0000003000bd7306ULL, 0x000fe20000009400ULL, 0x000000e9e500720bULL, 0x008fe20003fdd000ULL,
0x0000010028e57824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fe200000114b3ULL,
0x0001000029e97824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x002fc40000011424ULL,
0x00000018ff7a7819ULL, 0x000fe20000011425ULL, 0x0000003000eb7306ULL, 0x000e620000005400ULL,
0x000000e7bf00720bULL, 0x004fe20003f7d000ULL, 0x0001000028e77824ULL, 0x000fe200078e00ffULL,
0x00000018ff007819ULL, 0x000fe40000011426ULL, 0x00000018ff6f7819ULL, 0x000fe40000011427ULL,
0x00000018ff377819ULL, 0x000fe2000001142bULL, 0x000000d300d87306ULL, 0x000ff00000209400ULL,
0x000000d300d97306ULL, 0x0005e20000205400ULL, 0x000000ebbd00720bULL, 0x002fc40003f9d000ULL,
0x00009910beeb7816ULL, 0x000fca00000000ffULL, 0x00000031008a7306ULL, 0x0002e2000000d400ULL,
0x000000d300d37245ULL, 0x004fe2000020d400ULL, 0x000000ffffbf7224ULL, 0x000fca00078e00ebULL,
0x000000ffbf00720cULL, 0x000fe20003f25270ULL, 0x000000cd00d77306ULL, 0x000fe20000209400ULL,
0x000001002c317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x000000cd00dd7306ULL, 0x0002a20000205400ULL, 0x000000018a8a3812ULL, 0x008fce00078efcffULL,
0x0000003000937306ULL, 0x000762000000d400ULL, 0x000000cd00cd7245ULL, 0x002fce000020d400ULL,
0x0000002800a47306ULL, 0x000fe20000009400ULL, 0x000000ddd700720bULL, 0x004fe20003f7d000ULL,
0x000001002d307824ULL, 0x008fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000002800a77306ULL, 0x000fe20000005400ULL, 0x0000000193934812ULL, 0x020fca00078efcffULL,
0x00000001cdcd3812ULL, 0x000fe400078efcffULL, 0x00000028003d7306ULL, 0x0003f0000000d400ULL,
0x00000029009a7306ULL, 0x000fe20000009400ULL, 0x00000018ff287819ULL, 0x002fe200000114e5ULL,
0x000001002ae57824ULL, 0x000fca00078e00ffULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x00000029008d7306ULL, 0x000ff00000005400ULL, 0x00000029003c7306ULL, 0x0003f0000000d400ULL,
0x000000da00e17306ULL, 0x000fe20000209400ULL, 0x000000c800297245ULL, 0x002fe2000020d400ULL,
0x000100002ac87824ULL, 0x000fc600078e00ffULL, 0x0000000129296812ULL, 0x000fe400078efcffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000000da00e27306ULL, 0x0002b00000205400ULL,
0x0000002a00987306ULL, 0x000fe20000009400ULL, 0x000000da00da7245ULL, 0x002fce000020d400ULL,
0x0000002a008c7306ULL, 0x000fe20000005400ULL, 0x000000e2e100720bULL, 0x004fce0003f9d000ULL,
0x0000002a007d7306ULL, 0x0003ec000000d400ULL, 0x00000001dada4812ULL, 0x000fe400078efcffULL,
0x000000de00e47306ULL, 0x000fe20000209400ULL, 0x000000e0002a7245ULL, 0x002fe4000020d400ULL,
0x00000018ffe07819ULL, 0x000fc400000114e7ULL, 0x000000012a2a5812ULL, 0x000fe400078efcffULL,
0x000000d9d800720bULL, 0x000fe20003fbd000ULL, 0x000000de00e67306ULL, 0x0002b00000205400ULL,
0x000000ce00d07306ULL, 0x000fe20000209400ULL, 0x000000de00de7245ULL, 0x002fc6000020d400ULL,
0x00000001d3d35812ULL, 0x000fc800078efcffULL, 0x000000ce00d47306ULL, 0x0002e20000205400ULL,
0x000000e6e400720bULL, 0x004fce0003fdd000ULL, 0x000000c900d17306ULL, 0x000fe20000209400ULL,
0x000000ce00ce7245ULL, 0x002fca000020d400ULL, 0x00000001dede6812ULL, 0x000fe400078efcffULL,
0x000000c900d27306ULL, 0x0002a20000205400ULL, 0x000000d4d000720bULL, 0x008fce0003fbd000ULL,
0x000000df00c47306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fca000020d400ULL,
0x00000001cece5812ULL, 0x000fe400078efcffULL, 0x000000df00e37306ULL, 0x0002e20000205400ULL,
0x000000d2d100720bULL, 0x004fce0003f7d000ULL, 0x0000003300cb7306ULL, 0x000fe20000009400ULL,
0x000000df00df7245ULL, 0x002fca000020d400ULL, 0x00000001c9c93812ULL, 0x000fe400078efcffULL,
0x0000003300cc7306ULL, 0x000e620000005400ULL, 0x000000e3c400720bULL, 0x008fe20003f5d000ULL,
0x000001002be37824ULL, 0x000fca00078e00ffULL, 0x00000018ffe37819ULL, 0x000fe200000114e3ULL,
0x000000cf00db7306ULL, 0x000fec0000209400ULL, 0x00000001dfdf2812ULL, 0x000fe400078efcffULL,
0x000000cf00dc7306ULL, 0x0004e20000205400ULL, 0x000000cccb00720bULL, 0x002fc40003f9d000ULL,
0x00000018ffcb7819ULL, 0x000fca00000114e8ULL, 0x000000ae00b07306ULL, 0x000fe20000209400ULL,
0x000000cf00cf7245ULL, 0x004fce000020d400ULL, 0x000000ae00af7306ULL, 0x000e620000205400ULL,
0x000000dcdb00720bULL, 0x008fce0003fdd000ULL, 0x0000003000c77306ULL, 0x000fec0000209400ULL,
0x00000001cfcf6812ULL, 0x000fe400078efcffULL, 0x0000003000ca7306ULL, 0x000ea20000205400ULL,
0x000000afb000720bULL, 0x002fe20003fbd000ULL, 0x0001000026af7824ULL, 0x000fc400078e00ffULL,
0x0000010027b07824ULL, 0x000fc600078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000003200d67306ULL, 0x000fe20000009400ULL, 0x00000018ffb07819ULL, 0x000fce00000114b0ULL,
0x0000003200d57306ULL, 0x000e620000005400ULL, 0x000000cac700720bULL, 0x004fe20003f7d000ULL,
0x0000010024ca7824ULL, 0x000fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe200000114caULL,
0x0000003300847306ULL, 0x000eb0000000d400ULL, 0x0000002d00ba7306ULL, 0x000fe20000009400ULL,
0x000000d5d600720bULL, 0x002fce0003f5d000ULL, 0x0000002d00b17306ULL, 0x000e620000005400ULL,
0x0000000184844812ULL, 0x004fce00078efcffULL, 0x0000002c00c07306ULL, 0x000ff00000009400ULL,
0x0000002c00c27306ULL, 0x000ea20000005400ULL, 0x000000b1ba00720bULL, 0x002fe20003f9d000ULL,
0x0000010026b17824ULL, 0x000fe200078e00ffULL, 0x000000ae00ba7245ULL, 0x000fe2000020d400ULL,
0x0001000027ae7824ULL, 0x000fc600078e00ffULL, 0x00000001baba5812ULL, 0x000fe200078efcffULL,
0x000000a800a27306ULL, 0x000fe20000209400ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ffae7819ULL, 0x000fca00000114aeULL, 0x000000a800a17306ULL, 0x0002e20000205400ULL,
0x000000c2c000720bULL, 0x004fe40003fdd000ULL, 0x0000003100c07245ULL, 0x000fca000020d400ULL,
0x0000002d00347306ULL, 0x000ea2000000d400ULL, 0x000000a800a87245ULL, 0x002fce000020d400ULL,
0x0000003200857306ULL, 0x000e62000000d400ULL, 0x000000a1a200720bULL, 0x008fe40003fbd000ULL,
0x0000003000a17245ULL, 0x000fc8000020d400ULL, 0x00000001a1a13812ULL, 0x000fe200078efcffULL,
0x000000b600b87306ULL, 0x000fe20000209400ULL, 0x0000000134344812ULL, 0x004fca00078efcffULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x000000b6002d7306ULL, 0x0004e20000205400ULL,
0x0000000185852812ULL, 0x002fce00078efcffULL, 0x000000b900c17306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x004fce000020d400ULL, 0x000000b900c37306ULL, 0x0002a20000205400ULL,
0x0000002db800720bULL, 0x008fce0003f7d000ULL, 0x0000002c003e7306ULL, 0x000762000000d400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x00000001b6b63812ULL, 0x000fe400078efcffULL,
0x0000002e00a07306ULL, 0x000fe20000009400ULL, 0x000000c3c100720bULL, 0x004fe20003f5d000ULL,
0x000100002c2c7824ULL, 0x008fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114e9ULL,
0x0001000025c17824ULL, 0x000fc600078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000002e00a37306ULL, 0x000e620000005400ULL, 0x000000013e3e6812ULL, 0x020fe400078efcffULL,
0x00000018ffc17819ULL, 0x000fc600000114c1ULL, 0x00000001b9b92812ULL, 0x000fe400078efcffULL,
0x0000002f00a57306ULL, 0x000ff00000009400ULL, 0x0000002f00a97306ULL, 0x000ea20000005400ULL,
0x000000a3a000720bULL, 0x002fc40003fdd000ULL, 0x0000002c00a07245ULL, 0x000fca000020d400ULL,
0x0000003100c57306ULL, 0x000ff00000209400ULL, 0x0000003100c67306ULL, 0x000e620000205400ULL,
0x000000a9a500720bULL, 0x004fce0003f7d000ULL, 0x0000002e003b7306ULL, 0x000eb0000000d400ULL,
0x0000009b00aa7306ULL, 0x000fe20000209400ULL, 0x000000c6c500720bULL, 0x002fe20003f5d000ULL,
0x0001000024c57824ULL, 0x000fc400078e00ffULL, 0x0000010025c67824ULL, 0x000fc600078e00ffULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x0000009b00ab7306ULL, 0x000e620000205400ULL,
0x000000013b3b6812ULL, 0x004fe400078efcffULL, 0x00000018ffc67819ULL, 0x000fc600000114c6ULL,
0x00000001c0c02812ULL, 0x000fe400078efcffULL, 0x000000ac00ad7306ULL, 0x000fe40000209400ULL,
0x0000003ec03e723eULL, 0x000fcc00000010ffULL, 0x000000ac009f7306ULL, 0x0004e20000205400ULL,
0x000000abaa00720bULL, 0x002fce0003fdd000ULL, 0x0000002f003a7306ULL, 0x000362000000d400ULL,
0x000000ac00ac7245ULL, 0x004fce000020d400ULL, 0x00000091009e7306ULL, 0x000fe20000209400ULL,
0x000100002f2f7824ULL, 0x002fe200078e00ffULL, 0x0000009fad00720bULL, 0x008fc80003f9d000ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x0000009100a67306ULL, 0x0002a20000205400ULL,
0x000000013a3a3812ULL, 0x020fcc00078efcffULL, 0x00000001acac4812ULL, 0x000fe200078efcffULL,
0x0000002c00327306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x002fce000020d400ULL,
0x0000002c00337306ULL, 0x000e620000205400ULL, 0x000000a69e00720bULL, 0x004fe40003f7d000ULL,
0x0000009b009e7245ULL, 0x000fe4000020d400ULL, 0x0000002f009b7245ULL, 0x000fe4000020d400ULL,
0x000000019e9e6812ULL, 0x000fe200078efcffULL, 0x000000b400b57306ULL, 0x000fec0000209400ULL,
0x0000000191913812ULL, 0x000fc400078efcffULL, 0x000000b4002e7306ULL, 0x0004e20000205400ULL,
0x000000333200720bULL, 0x002fce0003f5d000ULL, 0x00000099009d7306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x004fca000020d400ULL, 0x00000001a0a02812ULL, 0x000fe400078efcffULL,
0x00000099009c7306ULL, 0x0002a20000205400ULL, 0x0000002eb500720bULL, 0x008fe40003fbd000ULL,
0x000000a0a8a0723eULL, 0x000fca00000010ffULL, 0x000000bb00bc7306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fca000020d400ULL, 0x00000001b4b45812ULL, 0x000fe400078efcffULL,
0x000000bb00bd7306ULL, 0x0002e20000205400ULL, 0x0000009c9d00720bULL, 0x004fe40003fdd000ULL,
0x00000028009c7245ULL, 0x000fca000020d400ULL, 0x000000b300b77306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fca000020d400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x000000b300b27306ULL, 0x0002a20000205400ULL, 0x000000bdbc00720bULL, 0x008fce0003f9d000ULL,
0x0000002f00be7306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x002fca000020d400ULL,
0x00000001bbbb4812ULL, 0x000fe400078efcffULL, 0x0000002f00bf7306ULL, 0x0002e20000205400ULL,
0x000000b2b700720bULL, 0x004fce0003f5d000ULL, 0x000000cb00cc7306ULL, 0x000fe20000209400ULL,
0x00000084cd2f723eULL, 0x002fe400000010ffULL, 0x0000003f00847245ULL, 0x000fc6000020d400ULL,
0x00000001b3b32812ULL, 0x000fe400078efcffULL, 0x000000cb00c27306ULL, 0x0002a20000205400ULL,
0x000000bfbe00720bULL, 0x008fe40003fbd000ULL, 0x000000a7a400720bULL, 0x000fca0003f5d000ULL,
0x000000e500317306ULL, 0x000fe20000209400ULL, 0x000000cb00cb7245ULL, 0x002fca000020d400ULL,
0x000000019b9b5812ULL, 0x000fe400078efcffULL, 0x000000e500307306ULL, 0x0002e20000205400ULL,
0x000000c2cc00720bULL, 0x004fe40003f7d000ULL, 0x000000013d3d2812ULL, 0x000fe400078efcffULL,
0x0000009b9191723eULL, 0x000fc600000010ffULL, 0x0000002800c47306ULL, 0x000fe20000209400ULL,
0x000000e500e57245ULL, 0x002fca000020d400ULL, 0x00000001cbcb3812ULL, 0x000fe400078efcffULL,
0x0000002800e47306ULL, 0x0002a20000205400ULL, 0x000000303100720bULL, 0x008fe40003fdd000ULL,
0x0000008c9800720bULL, 0x000fe40003f7d000ULL, 0x000000ceb930723eULL, 0x000fe400000010ffULL,
0x000000c9ba31723eULL, 0x000fe200000010ffULL, 0x000000e000d87306ULL, 0x000fe20000209400ULL,
0x000000932928723eULL, 0x002fc400000010ffULL, 0x0000008ade29723eULL, 0x000fe400000010ffULL,
0x000000e3008a7245ULL, 0x000fe4000020d400ULL, 0x00000001e5e56812ULL, 0x000fe200078efcffULL,
0x000000e000d57306ULL, 0x0002e20000205400ULL, 0x000000e4c400720bULL, 0x004fe40003f9d000ULL,
0x000000017d7d3812ULL, 0x000fca00078efcffULL, 0x00000024008b7306ULL, 0x000fe20000009400ULL,
0x000000e000e07245ULL, 0x002fca000020d400ULL, 0x000000019c9c4812ULL, 0x000fe400078efcffULL,
0x00000024008e7306ULL, 0x000fe20000005400ULL, 0x000000d5d800720bULL, 0x008fe40003fbd000ULL,
0x0000008d9a00720bULL, 0x000fca0003f9d000ULL, 0x0000002400767306ULL, 0x0003ec000000d400ULL,
0x00000001e0e05812ULL, 0x000fe400078efcffULL, 0x000000e300327306ULL, 0x000fe20000209400ULL,
0x0000b0005d247811ULL, 0x002fe400078e20ffULL, 0x000000013c3c4812ULL, 0x000fca00078efcffULL,
0x000000e3002e7306ULL, 0x000e700000205400ULL, 0x0000002500947306ULL, 0x000ff00000009400ULL,
0x0000002500957306ULL, 0x000fe20000005400ULL, 0x0000002e3200720bULL, 0x002fc40003fdd000ULL,
0x00000085cf2e723eULL, 0x000fca00000010ffULL, 0x0000002500777306ULL, 0x000fec000000d400ULL,
0x000000018a8a6812ULL, 0x000fe400078efcffULL, 0x0000002600357306ULL, 0x000ff00000009400ULL,
0x0000002600367306ULL, 0x000ff00000005400ULL, 0x0000002600727306ULL, 0x000ff0000000d400ULL,
0x0000002700397306ULL, 0x000ff00000009400ULL, 0x0000002700387306ULL, 0x000ff00000005400ULL,
0x0000002700737306ULL, 0x0003f0000000d400ULL, 0x0000008f00907306ULL, 0x000fe20000209400ULL,
0x000000002424783bULL, 0x002e6e0000000200ULL, 0x0000008f00927306ULL, 0x0004f00000205400ULL,
0x000000c300d07306ULL, 0x000fe20000209400ULL, 0x0000008f008f7245ULL, 0x004fce000020d400ULL,
0x000000c300c77306ULL, 0x0005620000205400ULL, 0x000000929000720bULL, 0x008fce0003f5d000ULL,
0x0000003f00897306ULL, 0x000fe20000209400ULL, 0x000000c300c37245ULL, 0x004fca000020d400ULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x0000003f00887306ULL, 0x0004e20000205400ULL,
0x000000c7d000720bULL, 0x020fe20003fbd000ULL, 0x0000007b24249231ULL, 0x092fe200003400ffULL,
0x000000959400720bULL, 0x000fe20003f5d000ULL, 0x0000007b26269231ULL, 0x000fe400003400ffULL,
0x0000007c25259231ULL, 0x080fe400003400ffULL, 0x000000c8002c7306ULL, 0x000fe20000209400ULL,
0x0000007c27279231ULL, 0x000fe200003400ffULL, 0x00000034a13f723eULL, 0x004fc400000010ffULL,
0x000000b6aca1723eULL, 0x000fe400000010ffULL, 0x00000001c3c35812ULL, 0x000fe400078efcffULL,
0x000000c8002d7306ULL, 0x0002a20000205400ULL, 0x000000888900720bULL, 0x008fe40003f7d000ULL,
0x0000008e8b00720bULL, 0x000fe40003fbd000ULL, 0x0000000177772812ULL, 0x000fc600078efcffULL,
0x0000002b00967306ULL, 0x000fe20000009400ULL, 0x000000c800c87245ULL, 0x002fca000020d400ULL,
0x0000000184843812ULL, 0x000fe400078efcffULL, 0x0000002b00977306ULL, 0x000e620000005400ULL,
0x0000002d2c00720bULL, 0x004fe40003fdd000ULL, 0x0000002adf2c723eULL, 0x000fe400000010ffULL,
0x0000000176765812ULL, 0x000fe400078efcffULL, 0x000000dad32d723eULL, 0x000fe200000010ffULL,
0x0000002b007e7306ULL, 0x0004ec000000d400ULL, 0x00000001c8c86812ULL, 0x000fe200078efcffULL,
0x0000002c2410723cULL, 0x000fe20000041810ULL, 0x000000ca008d7306ULL, 0x000fe20000209400ULL,
0x000100002b2b7824ULL, 0x004fe200078e00ffULL, 0x000000979600720bULL, 0x002fc80003f9d000ULL,
0x00000018ff337819ULL, 0x000fe2000001142bULL, 0x0000002e242c723cULL, 0x000fe20000041804ULL,
0x000000ca00907306ULL, 0x0002a40000205400ULL, 0x0000003300857245ULL, 0x000fc8000020d400ULL,
0x0000003d9c04723eULL, 0x000fe200000010ffULL, 0x000000282428723cULL, 0x000fe2000004180cULL,
0x00000033009f7306ULL, 0x000fe20000209400ULL, 0x000000017e7e4812ULL, 0x008fe400078efcffULL,
0x000000ca00ca7245ULL, 0x002fe4000020d400ULL, 0x0000003ccb05723eULL, 0x000fe400000010ffULL,
0x0000b0005c0c7811ULL, 0x000fe200078e20ffULL, 0x00000033009d7306ULL, 0x0002e20000205400ULL,
0x000000908d00720bULL, 0x004fc40003f7d000ULL, 0x000000bb9e90723eULL, 0x000fe400000010ffULL,
0x000000000c0c783bULL, 0x000ea60000000200ULL, 0x0000003700877306ULL, 0x000fe20000209400ULL,
0x000000302430723cULL, 0x002fea0000041808ULL, 0x00000001caca3812ULL, 0x000fc400078efcffULL,
0x0000003700867306ULL, 0x000e620000205400ULL, 0x0000009d9f00720bULL, 0x008fe20003fdd000ULL,
0x000000902420723cULL, 0x000fe20000041820ULL, 0x000000e09908723eULL, 0x000fe400000010ffULL,
0x000000c38f09723eULL, 0x000fc600000010ffULL, 0x000000c6008c7306ULL, 0x000fec0000209400ULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x000000c6008e7306ULL, 0x000ee20000205400ULL,
0x000000868700720bULL, 0x002fe40003f9d000ULL, 0x000000363500720bULL, 0x000fc40003fdd000ULL,
0x0000003700867245ULL, 0x000fe4000020d400ULL, 0x0000003e2434723cULL, 0x000fe20000041814ULL,
0x000000c5008b7306ULL, 0x000fe20000209400ULL, 0x0000007b0c0c9231ULL, 0x004fca00003400ffULL,
0x0000003bb33e723eULL, 0x000fe200000010ffULL, 0x0000007b0e0e9231ULL, 0x000fe200003400ffULL,
0x000000c500887306ULL, 0x0002a20000205400ULL, 0x0000008e8c00720bULL, 0x008fe20003f7d000ULL,
0x0000007c0d0d9231ULL, 0x080fe200003400ffULL, 0x0000003ab43f723eULL, 0x000fe200000010ffULL,
0x0000007c0f0f9231ULL, 0x000fe200003400ffULL, 0x0000000186864812ULL, 0x000fe400078efcffULL,
0x000000383900720bULL, 0x000fe20003f9d000ULL, 0x0000007f00837306ULL, 0x000fe20000209400ULL,
0x000000a02438723cULL, 0x000fe20000041818ULL, 0x000000c500c57245ULL, 0x002fc4000020d400ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x0000007de514723eULL, 0x000fe400000010ffULL,
0x0000007f00827306ULL, 0x0002e20000205400ULL, 0x000000888b00720bULL, 0x004fe20003fbd000ULL,
0x0000003e243c723cULL, 0x000fe2000004181cULL, 0x000000c600197245ULL, 0x000fe4000020d400ULL,
0x0000000173734812ULL, 0x000fe400078efcffULL, 0x0000000119193812ULL, 0x000fe200078efcffULL,
0x0000007a00807306ULL, 0x000fe20000209400ULL, 0x0000007f007f7245ULL, 0x002fe2000020d400ULL,
0x000000080c08723cULL, 0x000fe20000041810ULL, 0x000000c1001d7245ULL, 0x000fc4000020d400ULL,
0x000000b000257245ULL, 0x000fe4000020d400ULL, 0x00000001c5c55812ULL, 0x000fe200078efcffULL,
0x0000007a00817306ULL, 0x0002a20000205400ULL, 0x000000828300720bULL, 0x008fe40003f7d000ULL,
0x0000007e8a15723eULL, 0x000fe400000010ffULL, 0x000000858617723eULL, 0x000fe400000010ffULL,
0x000000771919723eULL, 0x000fe200000010ffULL, 0x000000c100877306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x002fe2000020d400ULL, 0x000000140c10723cULL, 0x000fe8000004182cULL,
0x000000017f7f3812ULL, 0x000fc400078efcffULL, 0x000000c100067306ULL, 0x000e620000205400ULL,
0x000000818000720bULL, 0x004fce0003fbd000ULL, 0x000000b100897306ULL, 0x000fec0000209400ULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x000000b100167306ULL, 0x0004e20000205400ULL,
0x000000068700720bULL, 0x002fe40003f5d000ULL, 0x000000040c04723cULL, 0x000fea0000041828ULL,
0x000000b000187306ULL, 0x000fe20000209400ULL, 0x000000b100b17245ULL, 0x004fc4000020d400ULL,
0x000000ae00297245ULL, 0x000fc6000020d400ULL, 0x000000011d1d2812ULL, 0x000fe400078efcffULL,
0x000000b0001c7306ULL, 0x000e620000205400ULL, 0x000000168900720bULL, 0x008fe40003f7d000ULL,
0x000000c88416723eULL, 0x000fe400000010ffULL, 0x0000001d7a1d723eULL, 0x000fc600000010ffULL,
0x0000000000797306ULL, 0x000fe40000209400ULL, 0x000000160c14723cULL, 0x000fe80000041830ULL,
0x00000001b1b13812ULL, 0x000fe400078efcffULL, 0x0000000000787306ULL, 0x0004e20000205400ULL,
0x0000001c1800720bULL, 0x002fe40003fbd000ULL, 0x00000076ca18723eULL, 0x000fc400000010ffULL,
0x000000c57f1c723eULL, 0x000fe400000010ffULL, 0x00000072b124723eULL, 0x000fe200000010ffULL,
0x0000006f00757306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x004fca000020d400ULL,
0x0000000125255812ULL, 0x000fe400078efcffULL, 0x0000006f00747306ULL, 0x0002a20000205400ULL,
0x000000787900720bULL, 0x008fe40003f5d000ULL, 0x000000732525723eULL, 0x000fca00000010ffULL,
0x000000af001a7306ULL, 0x000fe20000209400ULL, 0x0000006f006f7245ULL, 0x002fe2000020d400ULL,
0x000000240c24723cULL, 0x000fe8000004183cULL, 0x0000000100002812ULL, 0x000fe400078efcffULL,
0x000000af001b7306ULL, 0x0002e20000205400ULL, 0x000000747500720bULL, 0x004fce0003f7d000ULL,
0x000000ae001e7306ULL, 0x000fe20000209400ULL, 0x000000af00af7245ULL, 0x002fca000020d400ULL,
0x000000016f6f3812ULL, 0x000fe400078efcffULL, 0x000000ae001f7306ULL, 0x000e620000205400ULL,
0x0000001b1a00720bULL, 0x008fe40003fdd000ULL, 0x000000180c18723cULL, 0x000ff60000041834ULL,
0x00000001afaf6812ULL, 0x000fc400078efcffULL, 0x0000001f1e00720bULL, 0x002fe40003fbd000ULL,
0x000000af0028723eULL, 0x000fe200000010ffULL, 0x0000001c0c1c723cULL, 0x000ff40000041838ULL,
0x0000000129295812ULL, 0x000fc800078efcffULL, 0x000000296f29723eULL, 0x000fce00000010ffULL,
0x000000280c0c723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff207f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007844821ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000227305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000220000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004043287811ULL, 0x000fe400078e38ffULL,
0x000000c040007811ULL, 0x000fc400078e40ffULL, 0x00000004ff2f7819ULL, 0x000fe20000011644ULL,
0x00000001692c7824ULL, 0x100fe200078e0228ULL, 0x0000000041207217ULL, 0x000fe20007800000ULL,
0x000000016b2e7824ULL, 0x100fe200078e0228ULL, 0x000000022f307810ULL, 0x000fe20007ffe0ffULL,
0x00000001682b7824ULL, 0x000fe200078e0228ULL, 0x0000006c2c2c7210ULL, 0x080fe20007f7e0ffULL,
0x0000000120207824ULL, 0x000fe200078e0a00ULL, 0x0000006c2e2e7210ULL, 0x000fe20007f5e0ffULL,
0x000000016e297824ULL, 0x000fe400078e0228ULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0x00005e002c237a11ULL, 0x000fe200078640ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005e002e2d7a11ULL, 0x000fc400078440ffULL, 0x00005f002c2c7a11ULL, 0x000fe400018f4421ULL,
0x0000006c2b2b7210ULL, 0x080fe40007f7e0ffULL, 0x0000002020207807ULL, 0x000fe40000000000ULL,
0x00005f002e2e7a11ULL, 0x000fe200010f4422ULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0x0000006c29297210ULL, 0x000fe40007f5e0ffULL, 0x0000002045207217ULL, 0x000fc40007800000ULL,
0x00005e002b2a7a11ULL, 0x000fe200078640ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078440ffULL, 0x0000000120007824ULL, 0x000fe200078e0a45ULL,
0x00005f002b2b7a11ULL, 0x000fe400018f4421ULL, 0x0000004d2d207210ULL, 0x080fe40007f7e0ffULL,
0x00005f0029297a11ULL, 0x000fe400010f4422ULL, 0x0000004d23227210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200018e062eULL, 0x0000004d28287210ULL, 0x000fc40007fbe0ffULL,
0x000000042f2d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200020e062cULL,
0x000000002f00720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x000000062f2f7810ULL, 0x000fe40007ffe0ffULL, 0x000000003000720cULL, 0x080fe40003f46070ULL,
0x000000002d00720cULL, 0x080fe40003f86070ULL, 0x000000002f00720cULL, 0x000fc40003fa6070ULL,
0x0000004d2a2a7210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000205b7faeULL, 0x0003e4000d901c46ULL, 0x000000ffff2b7224ULL, 0x000fe400030e062bULL,
0x00000000225a7faeULL, 0x0003e8000d101c46ULL, 0x0000000028597faeULL, 0x0003e8000e101c46ULL,
0x000000002a587faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007844871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e0031ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007844871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000207305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000200000735dULL, 0x004fe40003800000ULL,
0x0106b400ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fc40007844871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004bff00723eULL, 0x000fe400000010ffULL,
0x00000002ff2b7819ULL, 0x002fe40000011644ULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x00010ed27f007947ULL, 0x000fea000b800000ULL, 0x00001f2b00817589ULL, 0x0002a400000e0000ULL,
0x00010f127f007947ULL, 0x000fea000b800000ULL, 0x00001f4e00807589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e004fULL,
0x0000e3e000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0001182000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e0050ULL,
0x0000e44000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x000117c000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005734783bULL, 0x000f680000004200ULL,
0x000000005628783bULL, 0x006e680000004200ULL, 0x000000005520783bULL, 0x000ea80000004200ULL,
0x00000000542c783bULL, 0x000ee20000004200ULL, 0x0000003400a77306ULL, 0x020fe20000009400ULL,
0x00000018ffa97819ULL, 0x000fe20000011434ULL, 0x0000010034b07824ULL, 0x000fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fe20000011436ULL, 0x0001000035e07824ULL, 0x040fe200078e00ffULL,
0x00000018ffbb7819ULL, 0x000fe20000011437ULL, 0x0000010035e47824ULL, 0x000fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0000003400a67306ULL, 0x000f620000005400ULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x0000010036d87824ULL, 0x000fe200078e00ffULL,
0x00000018ffe47819ULL, 0x000fe200000114e4ULL, 0x0001000034b47824ULL, 0x000fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fe20000011435ULL, 0x0000010037d17824ULL, 0x000fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x000000a900b27306ULL, 0x000fe20000209400ULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000010029c17824ULL, 0x002fe200078e00ffULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x0001000028c27824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011429ULL, 0x0001000037cd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fe200000114c1ULL, 0x000000a900a87306ULL, 0x0003220000205400ULL,
0x000000a6a700720bULL, 0x020fe20003fdd000ULL, 0x0001000036d27824ULL, 0x000fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fe200000114c2ULL, 0x0000010028c77824ULL, 0x000fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x000100002ba47824ULL, 0x000fe200078e00ffULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x00000034009d7306ULL, 0x000ae2000000d400ULL,
0x000000a900a97245ULL, 0x002fe2000020d400ULL, 0x0000010020a77824ULL, 0x004fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fc40000011428ULL, 0x00000018ff9c7819ULL, 0x000fe4000001142aULL,
0x00000018ff987819ULL, 0x000fe2000001142bULL, 0x000000b000b37306ULL, 0x000fe20000209400ULL,
0x000000a8b200720bULL, 0x010fe20003fbd000ULL, 0x000001002b347824ULL, 0x020fe200078e00ffULL,
0x000000b400a87245ULL, 0x000fe4000020d400ULL, 0x00000018ff9f7819ULL, 0x000fe40000011420ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x000000b000ea7306ULL, 0x0002a20000205400ULL,
0x000000019d9d6812ULL, 0x008fc400078efcffULL, 0x00000018ffc77819ULL, 0x000fe400000114c7ULL,
0x00000018ff897819ULL, 0x000fe40000011421ULL, 0x00000001a9a95812ULL, 0x000fe200078efcffULL,
0x000000e000e77306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fe4000020d400ULL,
0x00000018ff7f7819ULL, 0x000fe40000011422ULL, 0x00000018ff797819ULL, 0x000fc40000011423ULL,
0x00000018ffa47819ULL, 0x000fe200000114a4ULL, 0x000000e000e57306ULL, 0x0002e20000205400ULL,
0x000000eab300720bULL, 0x004fe20003f9d000ULL, 0x0001000021ea7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x0001000022b37824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001142cULL, 0x00000018ff007819ULL, 0x000fe2000001142eULL,
0x0000003600db7306ULL, 0x000fe20000009400ULL, 0x000000e000e07245ULL, 0x002fc4000020d400ULL,
0x00000018ffb37819ULL, 0x000fe400000114b3ULL, 0x00000018ff317819ULL, 0x000fe4000001142fULL,
0x00000001b0b04812ULL, 0x000fe200078efcffULL, 0x0000003600dc7306ULL, 0x000e620000005400ULL,
0x000000e5e700720bULL, 0x008fe40003fdd000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001142dULL,
0x0000009db0b0723eULL, 0x000fc600000010ffULL, 0x0000003700d37306ULL, 0x000fec0000009400ULL,
0x00000001e0e06812ULL, 0x000fe400078efcffULL, 0x0000003700d47306ULL, 0x000ea20000005400ULL,
0x000000dcdb00720bULL, 0x002fce0003fbd000ULL, 0x000000e400e67306ULL, 0x000ff00000209400ULL,
0x000000e400e87306ULL, 0x0002e20000205400ULL, 0x000000d4d300720bULL, 0x004fce0003fdd000ULL,
0x0000003500af7306ULL, 0x000fe20000009400ULL, 0x000000e400e47245ULL, 0x002fce000020d400ULL,
0x0000003500b17306ULL, 0x000e620000005400ULL, 0x000000e8e600720bULL, 0x008fce0003f9d000ULL,
0x0000003600837306ULL, 0x0004ec000000d400ULL, 0x00000001e4e44812ULL, 0x000fe400078efcffULL,
0x000000c000c67306ULL, 0x000fe20000209400ULL, 0x000000b1af00720bULL, 0x002fe20003f7d000ULL,
0x000100002a367824ULL, 0x004fc400078e00ffULL, 0x0001000023b17824ULL, 0x000fc600078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x000000c000c57306ULL, 0x0002a20000205400ULL,
0x0000000183835812ULL, 0x008fce00078efcffULL, 0x0000003700827306ULL, 0x000ee2000000d400ULL,
0x000000c000c07245ULL, 0x002fce000020d400ULL, 0x000000bb00be7306ULL, 0x000fe20000209400ULL,
0x000000c5c600720bULL, 0x004fe20003fbd000ULL, 0x000001002dc57824ULL, 0x000fcc00078e00ffULL,
0x000000bb00bf7306ULL, 0x0002a20000205400ULL, 0x0000000182826812ULL, 0x008fca00078efcffULL,
0x00000001c0c05812ULL, 0x000fe400078efcffULL, 0x000000d800e17306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fce000020d400ULL, 0x000000d800e27306ULL, 0x0002e20000205400ULL,
0x000000bfbe00720bULL, 0x004fe40003fdd000ULL, 0x00000018ffbe7819ULL, 0x000fca00000114eaULL,
0x000000b400e97306ULL, 0x000fe20000209400ULL, 0x000000d800d87245ULL, 0x002fca000020d400ULL,
0x00000001bbbb6812ULL, 0x000fe400078efcffULL, 0x000000b400eb7306ULL, 0x000e620000205400ULL,
0x000000e2e100720bULL, 0x008fce0003f9d000ULL, 0x0000003500887306ULL, 0x0004ec000000d400ULL,
0x00000001d8d84812ULL, 0x000fe400078efcffULL, 0x000000d100dd7306ULL, 0x000fe20000209400ULL,
0x000000ebe900720bULL, 0x002fe20003f5d000ULL, 0x000001002a357824ULL, 0x004fc400078e00ffULL,
0x0000010021e97824ULL, 0x000fc600078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x000000d100e37306ULL, 0x0002a20000205400ULL, 0x0000000188883812ULL, 0x008fe400078efcffULL,
0x00000018ffb47819ULL, 0x000fc600000114e9ULL, 0x00000001a8a82812ULL, 0x000fe400078efcffULL,
0x000000c100cb7306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x002fe4000020d400ULL,
0x000000a8a9a8723eULL, 0x000fca00000010ffULL, 0x000000c100d07306ULL, 0x0002e20000205400ULL,
0x000000e3dd00720bULL, 0x004fce0003f7d000ULL, 0x0000002900ba7306ULL, 0x000fe20000009400ULL,
0x000000c100c17245ULL, 0x002fca000020d400ULL, 0x00000001d1d13812ULL, 0x000fe400078efcffULL,
0x0000002900b97306ULL, 0x000fe20000005400ULL, 0x000000d0cb00720bULL, 0x008fce0003fbd000ULL,
0x00000029007d7306ULL, 0x0003ec000000d400ULL, 0x00000001c1c15812ULL, 0x000fe400078efcffULL,
0x0000002800c47306ULL, 0x000fe20000009400ULL, 0x0001000029297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002800c37306ULL, 0x000e700000005400ULL,
0x000000c200c87306ULL, 0x000ff00000209400ULL, 0x000000c200cc7306ULL, 0x0004e20000205400ULL,
0x000000c3c400720bULL, 0x002fe20003f9d000ULL, 0x000100002cc47824ULL, 0x000fcc00078e00ffULL,
0x000000d700de7306ULL, 0x000fe20000209400ULL, 0x000000c200c27245ULL, 0x004fce000020d400ULL,
0x000000d700df7306ULL, 0x0002a20000205400ULL, 0x000000ccc800720bULL, 0x008fce0003fdd000ULL,
0x000000cd00d57306ULL, 0x000fe20000209400ULL, 0x000000d700d77245ULL, 0x002fca000020d400ULL,
0x00000001c2c26812ULL, 0x000fe400078efcffULL, 0x000000cd00d67306ULL, 0x0002e20000205400ULL,
0x000000dfde00720bULL, 0x004fce0003f5d000ULL, 0x0000002900c97306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x002fca000020d400ULL, 0x00000001d7d72812ULL, 0x000fe400078efcffULL,
0x0000002900ca7306ULL, 0x000e620000205400ULL, 0x000000d6d500720bULL, 0x008fe40003f7d000ULL,
0x000000e0d7a9723eULL, 0x000fca00000010ffULL, 0x00000028007e7306ULL, 0x000eac000000d400ULL,
0x00000001cdcd3812ULL, 0x000fe400078efcffULL, 0x0000002a00b67306ULL, 0x000fe20000009400ULL,
0x000000cac900720bULL, 0x002fe40003fbd000ULL, 0x000000b9ba00720bULL, 0x000fc40003f7d000ULL,
0x000000cdbbbb723eULL, 0x000fc600000010ffULL, 0x0000002a00b57306ULL, 0x000e620000005400ULL,
0x000000017e7e4812ULL, 0x004fce00078efcffULL, 0x0000009a00aa7306ULL, 0x000fe20000209400ULL,
0x000000017d7d3812ULL, 0x000fc800078efcffULL, 0x0000007dc1c1723eULL, 0x000fc600000010ffULL,
0x0000009a00ab7306ULL, 0x000ea20000205400ULL, 0x000000b5b600720bULL, 0x002fe20003f9d000ULL,
0x000001002eb57824ULL, 0x000fca00078e00ffULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x000000d200d97306ULL, 0x000ff00000209400ULL, 0x000000d200da7306ULL, 0x0002e20000205400ULL,
0x000000abaa00720bULL, 0x004fe20003fdd000ULL, 0x000100002eaa7824ULL, 0x000fe200078e00ffULL,
0x0000002900ab7245ULL, 0x000fc4000020d400ULL, 0x0000b00053297811ULL, 0x000fe400078e20ffULL,
0x00000001abab5812ULL, 0x000fe200078efcffULL, 0x0000002a007a7306ULL, 0x000ea2000000d400ULL,
0x000000d200d27245ULL, 0x002fe4000020d400ULL, 0x00000018ffaa7819ULL, 0x000fca00000114aaULL,
0x0000003400287306ULL, 0x000fe20000209400ULL, 0x000000dad900720bULL, 0x008fce0003f5d000ULL,
0x00000034002a7306ULL, 0x0002e20000205400ULL, 0x000000017a7a4812ULL, 0x004fca00078efcffULL,
0x00000001d2d22812ULL, 0x000fe400078efcffULL, 0x0000002b00ad7306ULL, 0x000fe20000009400ULL,
0x0000003400347245ULL, 0x002fce000020d400ULL, 0x0000002b00ae7306ULL, 0x000e620000005400ULL,
0x0000002a2800720bULL, 0x008fce0003fbd000ULL, 0x0000002b00747306ULL, 0x0004ec000000d400ULL,
0x0000000134345812ULL, 0x000fe400078efcffULL, 0x00000020008d7306ULL, 0x000fe20000009400ULL,
0x00010000202b7824ULL, 0x004fe200078e00ffULL, 0x000000aead00720bULL, 0x002fe20003f7d000ULL,
0x000001002fad7824ULL, 0x000fe200078e00ffULL, 0x0000009a00ae7245ULL, 0x000fc4000020d400ULL,
0x00000018ffd37819ULL, 0x000fe4000001142bULL, 0x0000002000997306ULL, 0x000e620000005400ULL,
0x000000002928783bULL, 0x000ea20000000200ULL, 0x00000001aeae6812ULL, 0x000fe400078efcffULL,
0x00000035009a7245ULL, 0x000fe4000020d400ULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x0000002000737306ULL, 0x000962000000d400ULL, 0x0000000174743812ULL, 0x008fce00078efcffULL,
0x000000c700ce7306ULL, 0x000fe20000209400ULL, 0x0000010023207824ULL, 0x010fe200078e00ffULL,
0x000000998d00720bULL, 0x002fc80003f7d000ULL, 0x00000018ffb67819ULL, 0x000fe40000011420ULL,
0x000000c700cf7306ULL, 0x0002e20000205400ULL, 0x0000b00052207811ULL, 0x000fcc00078e20ffULL,
0x0000000173733812ULL, 0x020fe200078efcffULL, 0x00000021008e7306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x002fce000020d400ULL, 0x00000021008b7306ULL, 0x000fe20000005400ULL,
0x000000cfce00720bULL, 0x008fe20003f5d000ULL, 0x0000008128289231ULL, 0x084fe400003400ffULL,
0x000000812a2a9231ULL, 0x000fe400003400ffULL, 0x0000008029299231ULL, 0x080fe400003400ffULL,
0x0000002100707306ULL, 0x0003e2000000d400ULL, 0x000000802b2b9231ULL, 0x000fca00003400ffULL,
0x00000001c7c72812ULL, 0x000fe400078efcffULL, 0x0000002200977306ULL, 0x000fe20000009400ULL,
0x0000010022217824ULL, 0x002fe200078e00ffULL, 0x000000a82808723cULL, 0x000fe80000041808ULL,
0x00000018ffb97819ULL, 0x000fe40000011421ULL, 0x00000022008a7306ULL, 0x000ff00000005400ULL,
0x00000022006e7306ULL, 0x000ff0000000d400ULL, 0x0000002300a17306ULL, 0x000ff00000009400ULL,
0x00000023008f7306ULL, 0x000e700000005400ULL, 0x00000023003f7306ULL, 0x0004f0000000d400ULL,
0x000000ac00b77306ULL, 0x000fe20000209400ULL, 0x000000002020783bULL, 0x004ea20000000200ULL,
0x0000008fa100720bULL, 0x002fcc0003f7d000ULL, 0x000000ac00b87306ULL, 0x00032e0000205400ULL,
0x000000013f3f3812ULL, 0x008fe200078efcffULL, 0x0000003500bc7306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fce000020d400ULL, 0x0000003500bd7306ULL, 0x0002e20000205400ULL,
0x000000b8b700720bULL, 0x010fce0003f5d000ULL, 0x0000009c00907306ULL, 0x000fe20000209400ULL,
0x000100002f357824ULL, 0x002fca00078e00ffULL, 0x00000001acac2812ULL, 0x000fe400078efcffULL,
0x0000009c00957306ULL, 0x0003220000205400ULL, 0x000000bdbc00720bULL, 0x008fe20003f5d000ULL,
0x0000008120209231ULL, 0x084fe200003400ffULL, 0x000001002cbd7824ULL, 0x000fe200078e00ffULL,
0x0000008122229231ULL, 0x000fe200003400ffULL, 0x00000018ff817819ULL, 0x000fe200000114c5ULL,
0x0000008021219231ULL, 0x080fe200003400ffULL, 0x000000c2acc2723eULL, 0x000fe200000010ffULL,
0x000000d300d47306ULL, 0x000fe20000209400ULL, 0x0000008023239231ULL, 0x000fe200003400ffULL,
0x0000009c009c7245ULL, 0x002fc4000020d400ULL, 0x00000018ff807819ULL, 0x000fe400000114c4ULL,
0x000000019a9a2812ULL, 0x000fe400078efcffULL, 0x000000d300c37306ULL, 0x0002a20000205400ULL,
0x000000959000720bULL, 0x010fe40003fdd000ULL, 0x0000007a9a7a723eULL, 0x000fe400000010ffULL,
0x00000018ff357819ULL, 0x000fc60000011435ULL, 0x0000003600377306ULL, 0x000fe20000209400ULL,
0x000000d300d37245ULL, 0x002fca000020d400ULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x0000003600a57306ULL, 0x0002e20000205400ULL, 0x000000c3d400720bULL, 0x004fe40003f3d000ULL,
0x0000008a9700720bULL, 0x000fe40003fdd000ULL, 0x00000018ff8a7819ULL, 0x000fe400000114bdULL,
0x000000abaec3723eULL, 0x000fe200000010ffULL, 0x000000a400a37306ULL, 0x000fe20000209400ULL,
0x0000003600367245ULL, 0x002fc4000020d400ULL, 0x0000003500ab7245ULL, 0x000fc6000020d400ULL,
0x00000001d3d31812ULL, 0x000fe200078efcffULL, 0x000000c2281c723cULL, 0x000fe2000004181cULL,
0x000000a400a67306ULL, 0x0002a20000205400ULL, 0x000000a53700720bULL, 0x008fe40003f5d000ULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x00000018ff377819ULL, 0x000fe400000114b1ULL,
0x00000088e4b1723eULL, 0x000fe200000010ffULL, 0x000000b900b77306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fca000020d400ULL, 0x0000000136362812ULL, 0x000fe200078efcffULL,
0x000000b02804723cULL, 0x000fe20000041804ULL, 0x000000b900b87306ULL, 0x0002e20000205400ULL,
0x000000a6a300720bULL, 0x004fe40003fbd000ULL, 0x0000008b8e00720bULL, 0x000fe40003f5d000ULL,
0x000000369c36723eULL, 0x000fc600000010ffULL, 0x000000a700af7306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fca000020d400ULL, 0x00000001a4a45812ULL, 0x000fe400078efcffULL,
0x000000a700b27306ULL, 0x0002a20000205400ULL, 0x000000b8b700720bULL, 0x008fe40003f3d000ULL,
0x0000000170702812ULL, 0x000fca00078efcffULL, 0x0000007f00857306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001b9b91812ULL, 0x000fe400078efcffULL,
0x0000007f00847306ULL, 0x0002e20000205400ULL, 0x000000b2af00720bULL, 0x004fce0003fbd000ULL,
0x0000002c008c7306ULL, 0x000fe20000009400ULL, 0x0000007f007f7245ULL, 0x002fca000020d400ULL,
0x00000001a7a75812ULL, 0x000fe400078efcffULL, 0x0000002c00917306ULL, 0x000fe20000005400ULL,
0x000000848500720bULL, 0x008fce0003fdd000ULL, 0x0000002c00397306ULL, 0x000fec000000d400ULL,
0x000000017f7f6812ULL, 0x000fe400078efcffULL, 0x0000009800927306ULL, 0x000ff00000209400ULL,
0x00000098009b7306ULL, 0x0002b00000205400ULL, 0x000000b600bc7306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fce000020d400ULL, 0x000000b6002c7306ULL, 0x0002e20000205400ULL,
0x0000009b9200720bULL, 0x004fce0003f9d000ULL, 0x0000009f00a27306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x002fca000020d400ULL, 0x0000000198984812ULL, 0x000fe400078efcffULL,
0x0000009f00937306ULL, 0x0002a20000205400ULL, 0x0000002cbc00720bULL, 0x008fe40003f3d000ULL,
0x00000083d82c723eULL, 0x000fca00000010ffULL, 0x0000008900a07306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fca000020d400ULL, 0x00000001b6b61812ULL, 0x000fe400078efcffULL,
0x0000008900967306ULL, 0x0002e20000205400ULL, 0x00000093a200720bULL, 0x004fce0003fbd000ULL,
0x0000008a008e7306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fca000020d400ULL,
0x000000019f9f5812ULL, 0x000fe400078efcffULL, 0x0000008a00907306ULL, 0x0002a20000205400ULL,
0x00000096a000720bULL, 0x008fe40003f5d000ULL, 0x000000918c00720bULL, 0x000fca0003fbd000ULL,
0x0000002e00877306ULL, 0x000fe20000009400ULL, 0x0000008a008a7245ULL, 0x002fca000020d400ULL,
0x0000000189892812ULL, 0x000fe400078efcffULL, 0x0000002e00867306ULL, 0x000e620000005400ULL,
0x000000908e00720bULL, 0x004fe40003fdd000ULL, 0x0000000139395812ULL, 0x000fca00078efcffULL,
0x0000002e00337306ULL, 0x000eac000000d400ULL, 0x000000018a8a6812ULL, 0x000fe400078efcffULL,
0x0000002f00787306ULL, 0x000fe20000009400ULL, 0x000000868700720bULL, 0x002fe40003f5d000ULL,
0x000000398a8a723eULL, 0x000fca00000010ffULL, 0x0000002f00777306ULL, 0x000fec0000005400ULL,
0x0000000133332812ULL, 0x004fe400078efcffULL, 0x0000002f00327306ULL, 0x000ff0000000d400ULL,
0x000000b400de7306ULL, 0x000ff00000209400ULL, 0x000000b400db7306ULL, 0x0002b00000205400ULL,
0x000000b3002e7306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fce000020d400ULL,
0x000000b3002f7306ULL, 0x0002e20000205400ULL, 0x000000dbde00720bULL, 0x004fce0003f9d000ULL,
0x00000081008f7306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x002fca000020d400ULL,
0x00000001b4b44812ULL, 0x000fe400078efcffULL, 0x0000008100927306ULL, 0x000e620000205400ULL,
0x0000002f2e00720bULL, 0x008fce0003f3d000ULL, 0x00000079007b7306ULL, 0x000fec0000209400ULL,
0x00000001b3b31812ULL, 0x000fe400078efcffULL, 0x00000079007c7306ULL, 0x0004e20000205400ULL,
0x000000928f00720bULL, 0x002fce0003fdd000ULL, 0x000000be00bf7306ULL, 0x000fe20000209400ULL,
0x0000007900797245ULL, 0x004fce000020d400ULL, 0x000000be00ba7306ULL, 0x0002a20000205400ULL,
0x0000007c7b00720bULL, 0x008fe40003f3d000ULL, 0x00000037007c7245ULL, 0x000fe4000020d400ULL,
0x00000074347b723eULL, 0x000fc600000010ffULL, 0x00000037008d7306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x002fc6000020d400ULL, 0x0000007a2824723cULL, 0x000fe40000041824ULL,
0x0000000179791812ULL, 0x000fe400078efcffULL, 0x00000037008b7306ULL, 0x0002e20000205400ULL,
0x000000babf00720bULL, 0x004fe40003f9d000ULL, 0x000000d2c0ba723eULL, 0x000fe400000010ffULL,
0x0000007ec7c0723eULL, 0x000fc600000010ffULL, 0x00000080008c7306ULL, 0x000fe20000209400ULL,
0x000000a49837723eULL, 0x002fe200000010ffULL, 0x000000ba2814723cULL, 0x040fe80000041814ULL,
0x00000001bebe4812ULL, 0x000fe400078efcffULL, 0x0000008000867306ULL, 0x0002a20000205400ULL,
0x0000008b8d00720bULL, 0x008fe20003f7d000ULL, 0x000000c02818723cULL, 0x000fe20000041818ULL,
0x00000081008b7245ULL, 0x000fc8000020d400ULL, 0x000000018b8b6812ULL, 0x000fe200078efcffULL,
0x0000002d009e7306ULL, 0x000fe20000009400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x000000017c7c3812ULL, 0x000fe400078efcffULL, 0x0000002d00947306ULL, 0x000e620000005400ULL,
0x000000868c00720bULL, 0x004fe40003fdd000ULL, 0x000000777800720bULL, 0x000fca0003f7d000ULL,
0x0000006f00757306ULL, 0x000fec0000209400ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x0000006f00767306ULL, 0x0004e20000205400ULL, 0x000000949e00720bULL, 0x002fe40003f9d000ULL,
0x0000000132323812ULL, 0x000fca00078efcffULL, 0x0000002d00387306ULL, 0x000322000000d400ULL,
0x0000006f006f7245ULL, 0x004fce000020d400ULL, 0x00000000003d7306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x002fe200078e00ffULL, 0x000000767500720bULL, 0x008fc80003f3d000ULL,
0x00000018ff877819ULL, 0x000fe4000001142dULL, 0x00000000003e7306ULL, 0x0002a20000205400ULL,
0x00000082d12d723eULL, 0x000fe400000010ffULL, 0x0000000138384812ULL, 0x010fe400078efcffULL,
0x0000008700817245ULL, 0x000fe4000020d400ULL, 0x000000016f6f1812ULL, 0x000fe200078efcffULL,
0x0000003a00727306ULL, 0x000fe20000209400ULL, 0x0000002c282c723cULL, 0x000fe20000041810ULL,
0x0000000000007245ULL, 0x002fc4000020d400ULL, 0x000000388b8b723eULL, 0x000fe400000010ffULL,
0x000000806f80723eULL, 0x000fe400000010ffULL, 0x0000003a00717306ULL, 0x0002e20000205400ULL,
0x000000362828723cULL, 0x000fe2000004180cULL, 0x0000003e3d00720bULL, 0x004fe40003fdd000ULL,
0x00000073a710723eULL, 0x000fe400000010ffULL, 0x00000070b411723eULL, 0x000fc400000010ffULL,
0x0000008700837306ULL, 0x000fe20000209400ULL, 0x0000003a003a7245ULL, 0x002fe4000020d400ULL,
0x000000d39f12723eULL, 0x000fe400000010ffULL, 0x00000010200c723cULL, 0x000fe20000041804ULL,
0x000000be8913723eULL, 0x000fe400000010ffULL, 0x0000008700827306ULL, 0x000e620000205400ULL,
0x000000717200720bULL, 0x008fe40003fbd000ULL, 0x0000000100006812ULL, 0x000fc400078efcffULL,
0x0000006eb904723eULL, 0x000fe200000010ffULL, 0x000000122010723cULL, 0x040fe20000041808ULL,
0x0000003fb605723eULL, 0x000fe200000010ffULL, 0x000000b5007d7306ULL, 0x000fea0000209400ULL,
0x000000b37f08723eULL, 0x000fe200000010ffULL, 0x000000042004723cULL, 0x000fe2000004182cULL,
0x000000013a3a5812ULL, 0x000fe200078efcffULL, 0x000000b5007e7306ULL, 0x0004e20000205400ULL,
0x000000828300720bULL, 0x002fc40003f9d000ULL, 0x0000007c7909723eULL, 0x000fe400000010ffULL,
0x000000ad002d7245ULL, 0x000fc6000020d400ULL, 0x000000ad00777306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x004fe2000020d400ULL, 0x000000082008723cULL, 0x040fe80000041814ULL,
0x0000000181814812ULL, 0x000fe400078efcffULL, 0x000000ad00747306ULL, 0x000e620000205400ULL,
0x0000007e7d00720bULL, 0x008fe20003f3d000ULL, 0x0000008a2014723cULL, 0x000fe20000041818ULL,
0x000000813a81723eULL, 0x000fca00000010ffULL, 0x00000031003b7306ULL, 0x000fe40000209400ULL,
0x000000802018723cULL, 0x000fe8000004181cULL, 0x00000001b5b51812ULL, 0x000fe400078efcffULL,
0x00000031003c7306ULL, 0x0004e20000205400ULL, 0x000000747700720bULL, 0x002fe40003fbd000ULL,
0x00000033b52c723eULL, 0x000fca00000010ffULL, 0x000000aa00347306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x004fca000020d400ULL, 0x000000012d2d5812ULL, 0x000fe400078efcffULL,
0x000000aa00367306ULL, 0x0002a20000205400ULL, 0x0000003c3b00720bULL, 0x008fe40003f9d000ULL,
0x000000322d2d723eULL, 0x000fca00000010ffULL, 0x0000003500377306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fe2000020d400ULL, 0x0000002c201c723cULL, 0x000fe80000041824ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x00000035003d7306ULL, 0x000e620000205400ULL,
0x000000363400720bULL, 0x004fda0003f3d000ULL, 0x00000001aaaa1812ULL, 0x000fe400078efcffULL,
0x0000003d3700720bULL, 0x002fe40003f5d000ULL, 0x000000aa00aa723eULL, 0x000fd600000010ffULL,
0x00000001abab2812ULL, 0x000fc800078efcffULL, 0x000000ab31ab723eULL, 0x000fce00000010ffULL,
0x000000aa2020723cULL, 0x000fe20000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c040007811ULL, 0x000fe200078e40ffULL,
0x01069800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000004100720cULL, 0x000fda0003f24070ULL,
0x0000505000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x006fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001514c7824ULL, 0x000fe400078e026aULL,
0x00000002ff007424ULL, 0x000fe400078e00ffULL, 0x00000001ff247424ULL, 0x000fe200078e00ffULL,
0x000000014c257812ULL, 0x000fe200078ec0ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000030000007a24ULL, 0x000fe200078e0a24ULL, 0x000000012500780cULL, 0x000fc80003f25070ULL,
0x0000000100007807ULL, 0x000fca0004800000ULL, 0x000000014c4c7824ULL, 0x000fca00078e0200ULL,
0x000000034c00720cULL, 0x000fe40003f26070ULL, 0x000000e040007811ULL, 0x000fd600078e40ffULL,
0x000000014c249824ULL, 0x000fe400078e0249ULL, 0x00000004ff259424ULL, 0x000fc800078e00ffULL,
0x0000600024249625ULL, 0x000fca00078e0025ULL, 0x00000006246d9981ULL, 0x000362000c1e1900ULL,
0x00000004442f7811ULL, 0x040fe400078fe0ffULL, 0x0000000644317811ULL, 0x000fe400078fe0ffULL,
0x00000004ff327819ULL, 0x000fe40000011644ULL, 0x0000006043257811ULL, 0x002fe400078e38ffULL,
0x0000000041247217ULL, 0x000fe40007800000ULL, 0x0000002f25297210ULL, 0x000fe20007ffe045ULL,
0x00000001692c7824ULL, 0x000fe200078e0225ULL, 0x00000031252b7210ULL, 0x000fe20007ffe045ULL,
0x0000000124247824ULL, 0x000fe200078e0a00ULL, 0x0000006c29297210ULL, 0x080fe20007f7e0ffULL,
0x000000016b2e7824ULL, 0x000fe200078e0225ULL, 0x0000006c2c2c7210ULL, 0x000fc40007f5e0ffULL,
0x0000002024247807ULL, 0x000fe20000000000ULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x0000006c2e2e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005e002c277a11ULL, 0x000fe400078440ffULL, 0x0000002445247217ULL, 0x000fe20007800000ULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005e002e2d7a11ULL, 0x000fe400078240ffULL,
0x0000006c2b2b7210ULL, 0x000fc40007f9e0ffULL, 0x00005f002c2c7a11ULL, 0x000fe200010f4400ULL,
0x0000000124007824ULL, 0x000fe200078e0a45ULL, 0x0000000232247810ULL, 0x000fe40007ffe0ffULL,
0x00005f002e2e7a11ULL, 0x000fe200008f4425ULL, 0x000000ffff257224ULL, 0x000fe200020e06ffULL,
0x00005e0029287a11ULL, 0x000fe400078040ffULL, 0x00005e002b2a7a11ULL, 0x000fe400078240ffULL,
0x000000002400720cULL, 0x000fc40003f46070ULL, 0x00005f0029297a11ULL, 0x000fe400000f4426ULL,
0x0000004d2d247210ULL, 0x080fe40007f9e0ffULL, 0x000000003200720cULL, 0x080fe40003f66070ULL,
0x0000004d27267210ULL, 0x000fe40007fbe0ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4425ULL,
0x000000ffff257224ULL, 0x000fe200020e062eULL, 0x000000002f00720cULL, 0x080fe20003f26070ULL,
0x000000ffff277224ULL, 0x000fe200028e062cULL, 0x000000003100720cULL, 0x000fc40003f06070ULL,
0x0000004d28287210ULL, 0x080fe40007f9e0ffULL, 0x0000004d2a2a7210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024677faeULL, 0x0003e4000d901c46ULL,
0x000000ffff297224ULL, 0x000fe400020e0629ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x0000000026667faeULL, 0x0003e8000d101c46ULL, 0x0000000028657faeULL, 0x0003e8000c901c46ULL,
0x000000002a647faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff327f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106680045247f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007804830ULL, 0x01066c0045267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x01066c0045267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101800063267984ULL, 0x000e680000000800ULL,
0x0103800063277984ULL, 0x0007220000000800ULL, 0x000000462600720bULL, 0x002fe20003f3d000ULL,
0x0000e9427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff00287812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ffbe7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000034200780cULL, 0x000fe40003f45270ULL, 0x000000462600720bULL, 0x000fe20003f34000ULL,
0x0000e9027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x0000002646257209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fe400078e3cffULL,
0x00000002ff2a7819ULL, 0x000fe20000011644ULL, 0x8000002546247221ULL, 0x000fe20000010000ULL,
0x010580256300a388ULL, 0x0003e20000000800ULL, 0x0000000028ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b24247820ULL, 0x000fcc0000410000ULL, 0x0000002400247308ULL, 0x000ee40000000800ULL,
0x0000002447477220ULL, 0x008fe20000410000ULL, 0x0000e8927f007947ULL, 0x000fea000b800000ULL,
0x00001f2a242a7589ULL, 0x0022e400000e0000ULL, 0x0000002a0c0c7220ULL, 0x08cfe20000410000ULL,
0x0000002a0d0d7220ULL, 0x080fe20000410000ULL, 0x0000002a10107220ULL, 0x080fe20000410000ULL,
0x0000002a11117220ULL, 0x080fe20000410000ULL, 0x0000002a04047220ULL, 0x080fe20000410000ULL,
0x0000002a05057220ULL, 0x080fe20000410000ULL, 0x0000002a08087220ULL, 0x080fe20000410000ULL,
0x0000002a09097220ULL, 0x080fe20000410000ULL, 0x0000002a14147220ULL, 0x080fe20000410000ULL,
0x0000002a15157220ULL, 0x080fe20000410000ULL, 0x0000002a18187220ULL, 0x080fe20000410000ULL,
0x0000002a19197220ULL, 0x080fe20000410000ULL, 0x0000002a1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002a1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002a20207220ULL, 0x080fe20000410000ULL,
0x0000002a21217220ULL, 0x000fe20000410000ULL, 0x0000e7e27f007947ULL, 0x000fea000b800000ULL,
0x00001f4e242a7589ULL, 0x0004e400000e0000ULL, 0x8000002526261221ULL, 0x100fe20000010000ULL,
0x00000001ffbe7807ULL, 0x000fe20000800000ULL, 0x0000002a0e0e7220ULL, 0x08cfe20000410000ULL,
0x0000002a0f0f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL,
0x0000002a12127220ULL, 0x080fe20000410000ULL, 0x0000002a13137220ULL, 0x080fe20000410000ULL,
0x0000002a06067220ULL, 0x080fe20000410000ULL, 0x00000026004b1308ULL, 0x000ea20000000800ULL,
0x0000002a07077220ULL, 0x080fe20000410000ULL, 0x0000002a0a0a7220ULL, 0x080fe20000410000ULL,
0x0000002a0b0b7220ULL, 0x080fe20000410000ULL, 0x0000002a16167220ULL, 0x080fe20000410000ULL,
0x0000002a17177220ULL, 0x080fe20000410000ULL, 0x0000002a1a1a7220ULL, 0x080fe20000410000ULL,
0x0000002a1b1b7220ULL, 0x080fe20000410000ULL, 0x0000002a1e1e7220ULL, 0x080fe20000410000ULL,
0x0000002a1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002a22227220ULL, 0x080fe20000410000ULL,
0x0000002a23237220ULL, 0x000fe20000410000ULL, 0x000000ffff467224ULL, 0x000fe200078e0025ULL,
0x000000274b271220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000004727477221ULL, 0x010fe20000010000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ee40000000800ULL,
0x8000000000ff7812ULL, 0x008fc40007804830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0022e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004bff00723eULL, 0x000fe400000010ffULL, 0x00000002ff2b7819ULL, 0x000fc40000011644ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0000e5927f007947ULL, 0x000fea000b800000ULL,
0x00001f2b003b7589ULL, 0x00072400000e0000ULL, 0x0000e5d27f007947ULL, 0x000fea000b800000ULL,
0x00001f4e00367589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x008fe200078e004fULL, 0x00010f5000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000ecb000007944ULL, 0x036fea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x008fe200078e0050ULL, 0x00010fb000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000ec5000007944ULL, 0x036fea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006124783bULL, 0x002e680000004200ULL, 0x000000006060783bULL, 0x000f280000004200ULL,
0x000000005f28783bULL, 0x00cea80000004200ULL, 0x000000005e2c783bULL, 0x000ee20000004200ULL,
0x0001000024d97824ULL, 0x042fe200078e00ffULL, 0x00000018ffcc7819ULL, 0x000fe20000011424ULL,
0x0000010024d87824ULL, 0x000fe200078e00ffULL, 0x0000002500d47306ULL, 0x000fe20000009400ULL,
0x00000018ffac7819ULL, 0x000fe20000011425ULL, 0x0000010025d17824ULL, 0x040fe200078e00ffULL,
0x00000018ffd97819ULL, 0x000fe200000114d9ULL, 0x0001000025cd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x0000010026c27824ULL, 0x040fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011426ULL, 0x000000cc00d27306ULL, 0x000fe20000209400ULL,
0x0001000026aa7824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe20000011427ULL,
0x0000010027ab7824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x010fe20000011460ULL,
0x0001000060ad7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011461ULL,
0x0001000061b47824ULL, 0x000fe200078e00ffULL, 0x000000cc00d07306ULL, 0x0003220000205400ULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x0001000028e47824ULL, 0x004fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000010062b17824ULL, 0x040fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x0001000062ba7824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000d900df7306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fe2000020d400ULL, 0x0000010063b27824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011428ULL, 0x000001002ae37824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011462ULL, 0x0000010029e57824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x008fe2000001142fULL, 0x000000d900de7306ULL, 0x0002a20000205400ULL,
0x000000d0d200720bULL, 0x010fe20003f5d000ULL, 0x000001002be17824ULL, 0x000fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fe200000114c2ULL, 0x0001000029e67824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x000100002bc77824ULL, 0x000fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x000000d800e07306ULL, 0x000fe20000209400ULL,
0x000000d900d97245ULL, 0x002fc4000020d400ULL, 0x00000018ffb27819ULL, 0x000fe400000114b2ULL,
0x00000018ff817819ULL, 0x000fe40000011463ULL, 0x00000001cccc2812ULL, 0x000fe200078efcffULL,
0x000000d800e27306ULL, 0x000e620000205400ULL, 0x000000dedf00720bULL, 0x004fe40003fdd000ULL,
0x00000018ffb47819ULL, 0x000fe400000114b4ULL, 0x00000018ffba7819ULL, 0x000fc400000114baULL,
0x00000018ffe37819ULL, 0x000fe200000114e3ULL, 0x0000002500d57306ULL, 0x000ea20000005400ULL,
0x00000018ff797819ULL, 0x000fe40000011429ULL, 0x00000018ff6c7819ULL, 0x000fe4000001142bULL,
0x00000018ff517819ULL, 0x000fe4000001142cULL, 0x00000001d9d96812ULL, 0x000fe200078efcffULL,
0x0000002500777306ULL, 0x000722000000d400ULL, 0x000000e2e000720bULL, 0x002fc40003f9d000ULL,
0x00000018ff007819ULL, 0x000fe4000001142eULL, 0x00000018ffe17819ULL, 0x000fe400000114e1ULL,
0x00000018ff717819ULL, 0x000fe2000001142aULL, 0x0000002600ce7306ULL, 0x000fe20000009400ULL,
0x0001000027257824ULL, 0x008fe200078e00ffULL, 0x000000d5d400720bULL, 0x004fe40003fbd000ULL,
0x00000018ffe67819ULL, 0x000fe400000114e6ULL, 0x00000018ff257819ULL, 0x000fc40000011425ULL,
0x0000002600cf7306ULL, 0x000fe20000005400ULL, 0x00000018ffc77819ULL, 0x000fe400000114c7ULL,
0x00000018ff377819ULL, 0x000fe4000001142dULL, 0x000000d9cccc723eULL, 0x000fe400000010ffULL,
0x0000000177775812ULL, 0x010fe200078efcffULL, 0x0000002600737306ULL, 0x0003f0000000d400ULL,
0x0000002700c37306ULL, 0x000fe20000009400ULL, 0x0000010060267824ULL, 0x002fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002700bd7306ULL, 0x000e700000005400ULL,
0x0000002700727306ULL, 0x0004f0000000d400ULL, 0x0000006000a67306ULL, 0x000fe20000009400ULL,
0x0000010061277824ULL, 0x004fe200078e00ffULL, 0x000000bdc300720bULL, 0x002fc80003f5d000ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000006000a77306ULL, 0x000fee0000005400ULL,
0x0000000172722812ULL, 0x008fe200078efcffULL, 0x0000006000707306ULL, 0x0003f0000000d400ULL,
0x00000061008d7306ULL, 0x000fe20000009400ULL, 0x0001000063607824ULL, 0x002fce00078e00ffULL,
0x00000061009c7306ULL, 0x000ff00000005400ULL, 0x00000061006b7306ULL, 0x0003f0000000d400ULL,
0x0000002400c87306ULL, 0x000fe20000009400ULL, 0x00009910be617816ULL, 0x002fc400000000ffULL,
0x00000018ffbe7819ULL, 0x000fc60000011460ULL, 0x000000ffff607224ULL, 0x000fe400078e0061ULL,
0x0000002400c97306ULL, 0x000e620000005400ULL, 0x000100002e617824ULL, 0x000fe400078e00ffULL,
0x000000ff6000720cULL, 0x000fe20003f05270ULL, 0x0000010028607824ULL, 0x000fe400078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x000000ac00cb7306ULL, 0x000ff00000209400ULL,
0x000000ac00ca7306ULL, 0x0004e20000205400ULL, 0x000000c9c800720bULL, 0x002fe20003f3d000ULL,
0x000001002dc87824ULL, 0x000fca00078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x000000d100da7306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x004fce000020d400ULL,
0x000000d100db7306ULL, 0x0002a20000205400ULL, 0x000000cacb00720bULL, 0x008fe40003fdd000ULL,
0x00000018ffca7819ULL, 0x000fe400000114e4ULL, 0x000000e600cb7245ULL, 0x000fc6000020d400ULL,
0x000000ab00c67306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x002fca000020d400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000ab00d37306ULL, 0x0002e20000205400ULL,
0x000000dbda00720bULL, 0x004fce0003f7d000ULL, 0x0000002400767306ULL, 0x000ea2000000d400ULL,
0x000000ab00ab7245ULL, 0x002fca000020d400ULL, 0x00000001d1d13812ULL, 0x000fe400078efcffULL,
0x0000002600a97306ULL, 0x000fe20000209400ULL, 0x000000d3c600720bULL, 0x008fce0003fbd000ULL,
0x0000002600247306ULL, 0x000e620000205400ULL, 0x0000000176761812ULL, 0x004fca00078efcffULL,
0x00000001abab5812ULL, 0x000fe400078efcffULL, 0x00000028008b7306ULL, 0x000fe40000009400ULL,
0x00000072abc3723eULL, 0x000fcc00000010ffULL, 0x0000002800997306ULL, 0x000fe20000005400ULL,
0x00000024a900720bULL, 0x002fe40003f5d000ULL, 0x0000b8005d247811ULL, 0x000fca00078e20ffULL,
0x00000028005f7306ULL, 0x0003f0000000d400ULL, 0x00000062008c7306ULL, 0x000fe20000009400ULL,
0x00000018ff287819ULL, 0x002fe20000011460ULL, 0x000100002f607824ULL, 0x000fc600078e00ffULL,
0x00000028005d7245ULL, 0x000fe4000020d400ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x00000062009a7306ULL, 0x000ff00000005400ULL, 0x0000006200667306ULL, 0x0003f0000000d400ULL,
0x0000002f007f7306ULL, 0x000fe20000009400ULL, 0x000001002f627824ULL, 0x002fca00078e00ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000002f007b7306ULL, 0x000ff00000005400ULL,
0x0000002f00347306ULL, 0x0003f0000000d400ULL, 0x000000cd00dc7306ULL, 0x000fe20000209400ULL,
0x000000d8002f7245ULL, 0x002fc8000020d400ULL, 0x000000012f2f4812ULL, 0x000fe400078efcffULL,
0x000000cfce00720bULL, 0x000fe20003f9d000ULL, 0x000000cd00dd7306ULL, 0x0002b00000205400ULL,
0x000000aa00bc7306ULL, 0x000fe20000209400ULL, 0x000000cd00cd7245ULL, 0x002fc6000020d400ULL,
0x0000000173734812ULL, 0x000fc800078efcffULL, 0x000000aa00c57306ULL, 0x0002e20000205400ULL,
0x000000dddc00720bULL, 0x004fce0003f3d000ULL, 0x0000009000917306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fca000020d400ULL, 0x00000001cdcd1812ULL, 0x000fe400078efcffULL,
0x00000090009b7306ULL, 0x000e620000205400ULL, 0x000000c5bc00720bULL, 0x008fe40003fdd000ULL,
0x000000a7a600720bULL, 0x000fe40003f3d000ULL, 0x000000cdaccd723eULL, 0x000fc600000010ffULL,
0x000000c200d67306ULL, 0x000fec0000209400ULL, 0x00000001aaaa6812ULL, 0x000fe400078efcffULL,
0x000000c200d77306ULL, 0x0004e20000205400ULL, 0x0000009b9100720bULL, 0x002fe40003f9d000ULL,
0x0000009000917245ULL, 0x000fc4000020d400ULL, 0x0000002600907245ULL, 0x000fe4000020d400ULL,
0x0000009c8d00720bULL, 0x000fe20003fdd000ULL, 0x0000002500c07306ULL, 0x000fe20000209400ULL,
0x0000000190902812ULL, 0x000fe400078efcffULL, 0x000000c200c27245ULL, 0x004fe4000020d400ULL,
0x00000025008d7245ULL, 0x000fe4000020d400ULL, 0x0000000191914812ULL, 0x000fe200078efcffULL,
0x0000002500c17306ULL, 0x000e620000205400ULL, 0x000000d7d600720bULL, 0x008fc40003f7d000ULL,
0x0000000170701812ULL, 0x000fe400078efcffULL, 0x000000016b6b6812ULL, 0x000fc600078efcffULL,
0x000000ad00ae7306ULL, 0x000fec0000209400ULL, 0x00000001c2c23812ULL, 0x000fe400078efcffULL,
0x000000ad00b87306ULL, 0x0004e20000205400ULL, 0x000000c1c000720bULL, 0x002fe40003fbd000ULL,
0x00000073c2c2723eULL, 0x000fca00000010ffULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x000000ad00ad7245ULL, 0x004fca000020d400ULL, 0x000000018d8d5812ULL, 0x000fe400078efcffULL,
0x000000a300a57306ULL, 0x0002a20000205400ULL, 0x000000b8ae00720bULL, 0x008fe40003f5d000ULL,
0x0000009a8c00720bULL, 0x000fe40003fbd000ULL, 0x00000027008c7245ULL, 0x000fe4000020d400ULL,
0x0000008d91ab723eULL, 0x000fe200000010ffULL, 0x0000009800a17306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x00000001adad2812ULL, 0x000fe400078efcffULL,
0x0000009800a27306ULL, 0x0002e20000205400ULL, 0x000000a5a400720bULL, 0x004fe40003f7d000ULL,
0x0000000166665812ULL, 0x000fca00078efcffULL, 0x000000b100b57306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fca000020d400ULL, 0x00000001a3a33812ULL, 0x000fe400078efcffULL,
0x000000b100b07306ULL, 0x0002a20000205400ULL, 0x000000a2a100720bULL, 0x008fe40003f9d000ULL,
0x000000aaa3aa723eULL, 0x000fca00000010ffULL, 0x00000063008f7306ULL, 0x000fe20000009400ULL,
0x000000b100b17245ULL, 0x002fca000020d400ULL, 0x0000000198984812ULL, 0x000fe400078efcffULL,
0x0000006300927306ULL, 0x000e620000005400ULL, 0x000000b0b500720bULL, 0x004fe40003f5d000ULL,
0x000000ad9898723eULL, 0x000fca00000010ffULL, 0x0000002700a87306ULL, 0x000fec0000209400ULL,
0x00000001b1b12812ULL, 0x000fe400078efcffULL, 0x0000002700af7306ULL, 0x0004e20000205400ULL,
0x000000928f00720bULL, 0x002fe40003f3d000ULL, 0x00000066b166723eULL, 0x000fca00000010ffULL,
0x000000b200b37306ULL, 0x000fe20000209400ULL, 0x000000002424783bULL, 0x004e6e0000000200ULL,
0x000000b200b97306ULL, 0x0005220000205400ULL, 0x000000afa800720bULL, 0x008fce0003f7d000ULL,
0x00000029008e7306ULL, 0x000fe20000009400ULL, 0x000000b200b27245ULL, 0x004fca000020d400ULL,
0x000000018c8c3812ULL, 0x000fe400078efcffULL, 0x0000002900967306ULL, 0x000ea20000005400ULL,
0x000000b9b300720bULL, 0x010fce0003f9d000ULL, 0x0000009f00a07306ULL, 0x000fec0000209400ULL,
0x00000001b2b24812ULL, 0x000fe400078efcffULL, 0x0000009f00957306ULL, 0x0007220000205400ULL,
0x000000968e00720bULL, 0x004fe20003f5d000ULL, 0x0000003b24248231ULL, 0x002fc400003400ffULL,
0x0000003b26268231ULL, 0x000fe400003400ffULL, 0x0000003625258231ULL, 0x080fe400003400ffULL,
0x0000006300677306ULL, 0x000e62000000d400ULL, 0x0000009f009f7245ULL, 0x008fe2000020d400ULL,
0x0000003627278231ULL, 0x000fcc00003400ffULL, 0x0000008100937306ULL, 0x000fe20000209400ULL,
0x00000095a000720bULL, 0x010fe20003fdd000ULL, 0x000000cc2410723cULL, 0x000fe20000041810ULL,
0x0000008100957245ULL, 0x000fca000020d400ULL, 0x0000008100977306ULL, 0x000ea20000205400ULL,
0x0000000167671812ULL, 0x002fe200078efcffULL, 0x000000c22404723cULL, 0x040fe60000041804ULL,
0x00000067b267723eULL, 0x000fe400000010ffULL, 0x000000019f9f6812ULL, 0x000fe200078efcffULL,
0x000000b400b67306ULL, 0x000fe40000209400ULL, 0x000000aa2408723cULL, 0x040fec0000041808ULL,
0x000000b400b77306ULL, 0x0002e20000205400ULL, 0x000000979300720bULL, 0x004fe20003f3d000ULL,
0x00000066241c723cULL, 0x000fec000004181cULL, 0x000000be00bf7306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x002fca000020d400ULL, 0x0000000195951812ULL, 0x000fe400078efcffULL,
0x000000be00c47306ULL, 0x0002a20000205400ULL, 0x000000b7b600720bULL, 0x008fce0003f7d000ULL,
0x00000029005e7306ULL, 0x000722000000d400ULL, 0x000000be00be7245ULL, 0x002fca000020d400ULL,
0x00000001b4b43812ULL, 0x000fe400078efcffULL, 0x00000094009d7306ULL, 0x000fe20000209400ULL,
0x000100002c297824ULL, 0x008fe200078e00ffULL, 0x000000c4bf00720bULL, 0x004fe40003f9d000ULL,
0x000000998b00720bULL, 0x000fe40003f7d000ULL, 0x000000b49f99723eULL, 0x000fe400000010ffULL,
0x00000094009e7306ULL, 0x0002a20000205400ULL, 0x000000015e5e2812ULL, 0x010fc800078efcffULL,
0x000000982418723cULL, 0x000fe40000041818ULL, 0x00000001bebe4812ULL, 0x000fe200078efcffULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fe4000020d400ULL,
0x000000015f5f3812ULL, 0x000fe400078efcffULL, 0x000000be9595723eULL, 0x000fc600000010ffULL,
0x000000ba00637306ULL, 0x0002e20000205400ULL, 0x0000009e9d00720bULL, 0x004fce0003fbd000ULL,
0x000000e3009c7306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x002fca000020d400ULL,
0x0000000194945812ULL, 0x000fe400078efcffULL, 0x000000e3009a7306ULL, 0x0002a20000205400ULL,
0x00000063bb00720bULL, 0x008fce0003fdd000ULL, 0x000000ca00bd7306ULL, 0x000fe20000209400ULL,
0x000000e300e37245ULL, 0x002fca000020d400ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x000000ca00a67306ULL, 0x0002e20000205400ULL, 0x0000009a9c00720bULL, 0x004fe40003f5d000ULL,
0x000000ba9494723eULL, 0x000fca00000010ffULL, 0x0000002a00827306ULL, 0x000fe20000009400ULL,
0x000000ca00ca7245ULL, 0x002fe2000020d400ULL, 0x000000942420723cULL, 0x000fe80000041820ULL,
0x00000001e3e32812ULL, 0x000fe400078efcffULL, 0x0000002a00837306ULL, 0x000e620000005400ULL,
0x000000a6bd00720bULL, 0x008fce0003f3d000ULL, 0x0000002b007d7306ULL, 0x000fec0000009400ULL,
0x00000001caca1812ULL, 0x000fe400078efcffULL, 0x0000002b00857306ULL, 0x000ea20000005400ULL,
0x000000838200720bULL, 0x002fce0003f9d000ULL, 0x0000002b003f7306ULL, 0x0002f0000000d400ULL,
0x0000002c00887306ULL, 0x000fe20000009400ULL, 0x000001002c2b7824ULL, 0x002fe200078e00ffULL,
0x000000857d00720bULL, 0x004fc80003f3d000ULL, 0x00000018ff827819ULL, 0x000fe4000001142bULL,
0x0000002c007c7306ULL, 0x000fe20000005400ULL, 0x00000077d12b723eULL, 0x000fcc00000010ffULL,
0x000000013f3f1812ULL, 0x008fe200078efcffULL, 0x0000002c003a7306ULL, 0x0003f0000000d400ULL,
0x0000002e00867306ULL, 0x000fe20000009400ULL, 0x000001002e2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe4000001142cULL, 0x0000002e00877306ULL, 0x000fe20000005400ULL,
0x00000070902c723eULL, 0x000fce00000010ffULL, 0x0000002e00317306ULL, 0x0003f0000000d400ULL,
0x0000002800c97306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x002fc800000114e5ULL,
0x0000002e00637245ULL, 0x000fc6000020d400ULL, 0x0000002800e07306ULL, 0x000e700000205400ULL,
0x0000002e00d07306ULL, 0x000ff00000209400ULL, 0x0000002e00ce7306ULL, 0x000ea20000205400ULL,
0x000000e0c900720bULL, 0x002fce0003fdd000ULL, 0x000000e100927306ULL, 0x000fec0000209400ULL,
0x000000015d5d6812ULL, 0x000fe400078efcffULL, 0x000000e100a07306ULL, 0x0002e20000205400ULL,
0x000000ced000720bULL, 0x004fce0003fbd000ULL, 0x0000002a003e7306ULL, 0x000522000000d400ULL,
0x000000e100e17245ULL, 0x002fca000020d400ULL, 0x0000000163635812ULL, 0x000fe400078efcffULL,
0x00000089008a7306ULL, 0x000fe20000209400ULL, 0x000100002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000a09200720bULL, 0x008fc80003f5d000ULL, 0x00000018ff8b7819ULL, 0x000fe4000001142aULL,
0x000000762f2a723eULL, 0x000fe200000010ffULL, 0x0000008900847306ULL, 0x0002a20000205400ULL,
0x00000018ff767819ULL, 0x000fe40000011429ULL, 0x000000013e3e4812ULL, 0x010fe400078efcffULL,
0x0000007b7f00720bULL, 0x000fe20003f9d000ULL, 0x0000002a2428723cULL, 0x000fe2000004180cULL,
0x00000001e1e12812ULL, 0x000fe200078efcffULL, 0x000000e600a47306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x002fc4000020d400ULL, 0x0000003ee33e723eULL, 0x000fe400000010ffULL,
0x0000b8005c0c7811ULL, 0x000fe400078e20ffULL, 0x0000003fe13f723eULL, 0x000fe200000010ffULL,
0x000000e6009b7306ULL, 0x000e620000205400ULL, 0x000000848a00720bULL, 0x004fe40003fdd000ULL,
0x000000000c0c783bULL, 0x000ea20000000200ULL, 0x0000000134344812ULL, 0x000fc800078efcffULL,
0x0000008b008f7306ULL, 0x000fec0000209400ULL, 0x0000000189896812ULL, 0x000fe400078efcffULL,
0x0000008b008e7306ULL, 0x0007220000205400ULL, 0x0000009ba400720bULL, 0x002fe40003fbd000ULL,
0x0000007c8800720bULL, 0x000fc40003fdd000ULL, 0x000000ca89ca723eULL, 0x000fc600000010ffULL,
0x0000007100757306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x008fca000020d400ULL,
0x00000001cbcb5812ULL, 0x000fe400078efcffULL, 0x0000007100747306ULL, 0x0002e20000205400ULL,
0x0000008e8f00720bULL, 0x010fe40003f5d000ULL, 0x000000013a3a6812ULL, 0x000fca00078efcffULL,
0x0000007900807306ULL, 0x000fe20000209400ULL, 0x0000007100717245ULL, 0x002fe2000020d400ULL,
0x0000003b0c0c8231ULL, 0x084fe400003400ffULL, 0x0000003b0e0e8231ULL, 0x000fe400003400ffULL,
0x000000018b8b2812ULL, 0x000fe200078efcffULL, 0x000000360d0d8231ULL, 0x080fe200003400ffULL,
0x00000079007e7306ULL, 0x0002a20000205400ULL, 0x000000747500720bULL, 0x008fe20003f3d000ULL,
0x000000360f0f8231ULL, 0x000fe200003400ffULL, 0x000000c8003b7245ULL, 0x000fca000020d400ULL,
0x0000002d00787306ULL, 0x000fe20000009400ULL, 0x0000007900797245ULL, 0x002fe2000020d400ULL,
0x0000003e0c04723cULL, 0x000fe80000041804ULL, 0x0000000171711812ULL, 0x000fe400078efcffULL,
0x0000002d007a7306ULL, 0x000e620000005400ULL, 0x0000007e8000720bULL, 0x004fce0003f7d000ULL,
0x000000c700937306ULL, 0x000fec0000209400ULL, 0x0000000179793812ULL, 0x000fe400078efcffULL,
0x000000c700817306ULL, 0x0004e20000205400ULL, 0x0000007a7800720bULL, 0x002fe40003fbd000ULL,
0x000000878600720bULL, 0x000fc40003f7d000ULL, 0x000000cb79cb723eULL, 0x000fc600000010ffULL,
0x0000006c006e7306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x004fc6000020d400ULL,
0x000000ca0c10723cULL, 0x000fe80000041810ULL, 0x0000006c006f7306ULL, 0x0002a20000205400ULL,
0x000000819300720bULL, 0x008fe40003f5d000ULL, 0x0000000131313812ULL, 0x000fca00078efcffULL,
0x00000082002e7306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fca000020d400ULL,
0x00000001c7c72812ULL, 0x000fe400078efcffULL, 0x00000082007e7306ULL, 0x0002e20000205400ULL,
0x0000006f6e00720bULL, 0x004fce0003f3d000ULL, 0x0000005100697306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x002fca000020d400ULL, 0x000000016c6c1812ULL, 0x000fe400078efcffULL,
0x00000051006a7306ULL, 0x0002a20000205400ULL, 0x0000007e2e00720bULL, 0x008fce0003f5d000ULL,
0x000000c8007c7306ULL, 0x000fe20000209400ULL, 0x0000005100517245ULL, 0x002fca000020d400ULL,
0x0000000182822812ULL, 0x000fe400078efcffULL, 0x000000c8007a7306ULL, 0x000e620000205400ULL,
0x0000006a6900720bULL, 0x004fe40003f3d000ULL, 0x0000003a823a723eULL, 0x000fca00000010ffULL,
0x0000002d00357306ULL, 0x0004ec000000d400ULL, 0x0000000151511812ULL, 0x000fe400078efcffULL,
0x0000003700657306ULL, 0x000fe20000209400ULL, 0x000100002d2d7824ULL, 0x004fe200078e00ffULL,
0x0000007a7c00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff747819ULL, 0x000fe4000001142dULL,
0x0000003700647306ULL, 0x0002a20000205400ULL, 0x0000006b8c2d723eULL, 0x000fe400000010ffULL,
0x0000000135355812ULL, 0x008fc800078efcffULL, 0x000000013b3b6812ULL, 0x000fe200078efcffULL,
0x0000007600777306ULL, 0x000fe20000209400ULL, 0x0000002c242c723cULL, 0x000fe20000041814ULL,
0x0000003700377245ULL, 0x002fe4000020d400ULL, 0x000000353b3b723eULL, 0x000fc800000010ffULL,
0x0000007600787306ULL, 0x0002e20000205400ULL, 0x0000005f5d14723eULL, 0x000fe400000010ffULL,
0x0000005e6315723eULL, 0x000fe400000010ffULL, 0x000000646500720bULL, 0x004fe40003f5d000ULL,
0x0000008b7124723eULL, 0x000fe200000010ffULL, 0x00000074005c7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fe2000020d400ULL, 0x000000140c14723cULL, 0x000fe20000041828ULL,
0x000000c76c25723eULL, 0x000fca00000010ffULL, 0x0000007400727306ULL, 0x000e620000205400ULL,
0x000000787700720bULL, 0x008fe20003fdd000ULL, 0x000000240c08723cULL, 0x000fe20000041808ULL,
0x0000007400777245ULL, 0x000fe4000020d400ULL, 0x0000000137372812ULL, 0x000fc600078efcffULL,
0x00000073006e7306ULL, 0x000fe20000209400ULL, 0x0000006200257245ULL, 0x000fe2000020d400ULL,
0x0000003a0c2c723cULL, 0x000fe8000004182cULL, 0x0000000176766812ULL, 0x000fe400078efcffULL,
0x00000073006b7306ULL, 0x0004e20000205400ULL, 0x000000725c00720bULL, 0x002fe40003fbd000ULL,
0x000000765176723eULL, 0x000fca00000010ffULL, 0x00000000003d7306ULL, 0x000fe20000209400ULL,
0x0000007300737245ULL, 0x004fca000020d400ULL, 0x0000000177775812ULL, 0x000fe400078efcffULL,
0x00000000003c7306ULL, 0x0002a20000205400ULL, 0x0000006b6e00720bULL, 0x008fe40003f3d000ULL,
0x000000773777723eULL, 0x000fca00000010ffULL, 0x0000003000387306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x002fe2000020d400ULL, 0x000000760c18723cULL, 0x000fe80000041818ULL,
0x0000000173731812ULL, 0x000fe400078efcffULL, 0x0000003000397306ULL, 0x0002e20000205400ULL,
0x0000003c3d00720bULL, 0x004fe40003fdd000ULL, 0x000000317324723eULL, 0x000fca00000010ffULL,
0x0000006200697306ULL, 0x000fe20000209400ULL, 0x0000003000307245ULL, 0x002fca000020d400ULL,
0x0000000100006812ULL, 0x000fe400078efcffULL, 0x0000006200647306ULL, 0x000e620000205400ULL,
0x000000393800720bULL, 0x008fce0003fbd000ULL, 0x00000061005d7306ULL, 0x000fec0000209400ULL,
0x0000000130305812ULL, 0x000fe400078efcffULL, 0x0000006100267306ULL, 0x0004e20000205400ULL,
0x000000646900720bULL, 0x002fce0003f5d000ULL, 0x0000006000277306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x004fca000020d400ULL, 0x0000000125252812ULL, 0x000fe400078efcffULL,
0x0000006000287306ULL, 0x000e620000205400ULL, 0x000000265d00720bULL, 0x008fe40003f3d000ULL,
0x000000342525723eULL, 0x000fce00000010ffULL, 0x000000240c1c723cULL, 0x000fe8000004181cULL,
0x0000000161611812ULL, 0x000fe400078efcffULL, 0x000000282700720bULL, 0x002fe40003f7d000ULL,
0x0000006000277245ULL, 0x000fe4000020d400ULL, 0x000000610026723eULL, 0x000fd200000010ffULL,
0x0000000127273812ULL, 0x000fc800078efcffULL, 0x000000273027723eULL, 0x000fce00000010ffULL,
0x000000260c20723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff0c7f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000782480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc4000782480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x00000000000e7305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x0000000e0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000782480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000030040007a10ULL, 0x000fe20007ffe0ffULL,
0x000058006d0e7a24ULL, 0x020fe200078e02ffULL, 0x00000004ff307819ULL, 0x000fe20000011644ULL,
0x0000008043687824ULL, 0x000fe200078e0268ULL, 0x00000001000d7810ULL, 0x040fe20007ffe0ffULL,
0x00000100000c7824ULL, 0x000fe200078e00ffULL, 0x0000000230317810ULL, 0x000fe20007ffe0ffULL,
0x000000800e277824ULL, 0x000fe200078e00ffULL, 0xfffffffa68007810ULL, 0x000fc40007ffe0ffULL,
0x0000000c410e7217ULL, 0x000fe40007800000ULL, 0x000000020d00720cULL, 0x000fe40003f46070ULL,
0x00000000272b7210ULL, 0x000fe20007f3e0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0cULL,
0xfffffffc680c7810ULL, 0x040fe40007ffe0ffULL, 0xfffffffe68007810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x000000200e0e7807ULL, 0x000fc40001000000ULL,
0x0000000c27287210ULL, 0x040fe40007f9e0ffULL, 0x0000000027257210ULL, 0x040fe40007fbe0ffULL,
0x0000006827277210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff297224ULL, 0x000fe200020e06ffULL,
0x0000000e450e7217ULL, 0x000fe40007800000ULL, 0x00005e002b2a7a11ULL, 0x000fe200078640ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078240ffULL,
0x000000010e007824ULL, 0x000fe200078e0a45ULL, 0x00005e00280f7a11ULL, 0x000fc400078440ffULL,
0x00005f002b2b7a11ULL, 0x000fe200018f440dULL, 0x000000ffff0d7224ULL, 0x000fe200028e06ffULL,
0x00005e0025247a11ULL, 0x000fe400078640ffULL, 0x00005f0027277a11ULL, 0x000fe400008f440cULL,
0x00005f0028287a11ULL, 0x000fe400010f4429ULL, 0x0000004d2a0c7210ULL, 0x000fe40007f9e0ffULL,
0x0000000630297810ULL, 0x000fc40007ffe0ffULL, 0x000000003000720cULL, 0x0c0fe40003f46070ULL,
0x0000004d0f0e7210ULL, 0x080fe40007fbe0ffULL, 0x0000000430307810ULL, 0x000fe40007ffe0ffULL,
0x00005f0025257a11ULL, 0x000fe200018f440dULL, 0x000000ffff0d7224ULL, 0x000fe200020e062bULL,
0x0000004d24247210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e0628ULL,
0x000000003100720cULL, 0x000fc40003f26070ULL, 0x000000003000720cULL, 0x080fe20003f86070ULL,
0x000000ffff257224ULL, 0x000fe200018e0625ULL, 0x000000002900720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c5b7faeULL, 0x0003e2000d101c46ULL,
0x0000004d26267210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe400018e0627ULL,
0x000000000e5a7faeULL, 0x0003e8000c901c46ULL, 0x0000000024597faeULL, 0x0003e8000e101c46ULL,
0x0000000026587faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007824833ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e0031ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007824833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x00000000000c7305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x0000000c0000735dULL, 0x004fe40003800000ULL,
0x0106b400ff0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fc40007824833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004bff00723eULL, 0x000fe400000010ffULL,
0x00000002ff2b7819ULL, 0x000fe40000011644ULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x0000c1527f007947ULL, 0x000fea000b800000ULL, 0x00001f2b005d7589ULL, 0x0004e400000e0000ULL,
0x0000c1927f007947ULL, 0x000fea000b800000ULL, 0x00001f4e005f7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x004fe200078e004fULL,
0x0001346000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000c7a000007944ULL, 0x01afea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x004fe200078e0050ULL,
0x000134c000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000c74000007944ULL, 0x01afea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000570c783bULL, 0x002e680000004200ULL,
0x000000005624783bULL, 0x000f680000004200ULL, 0x000000005528783bULL, 0x004ea80000004200ULL,
0x000000005454783bULL, 0x000f220000004200ULL, 0x0000000c00a97306ULL, 0x002fe20000009400ULL,
0x00000018ffbb7819ULL, 0x000fe2000001140cULL, 0x000001000c927824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe2000001140dULL, 0x000001000fac7824ULL, 0x040fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001140fULL, 0x000100000fad7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe20000011492ULL, 0x0000000c00aa7306ULL, 0x000e620000005400ULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x000001000eb07824ULL, 0x040fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x000100000eaf7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x020fe20000011424ULL, 0x0001000025997824ULL, 0x000fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0000000c006f7306ULL, 0x000ae2000000d400ULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000010026937824ULL, 0x040fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe2000001140eULL, 0x0000010027927824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x00010000269a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011493ULL, 0x0000000d00bf7306ULL, 0x000fe20000009400ULL,
0x000100000c0c7824ULL, 0x020fe200078e00ffULL, 0x000000aaa900720bULL, 0x002fe20003f9d000ULL,
0x0001000027987824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011425ULL,
0x000001002bd37824ULL, 0x004fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe2000001140cULL,
0x000001000d0c7824ULL, 0x000fe200078e00ffULL, 0x0000000d00c07306ULL, 0x000e620000005400ULL,
0x00000018ff827819ULL, 0x000fe20000011426ULL, 0x00000100289b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011427ULL, 0x000001002ad27824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fe2000001140cULL, 0x00000100250c7824ULL, 0x000fe200078e00ffULL,
0x000000016f6f4812ULL, 0x008fe200078efcffULL, 0x000000bb00bd7306ULL, 0x000fe20000209400ULL,
0x00000018ff927819ULL, 0x000fe20000011492ULL, 0x0001000029d17824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x0000010054a97824ULL, 0x010fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe2000001149aULL, 0x0000010055aa7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011429ULL, 0x000000bb00be7306ULL, 0x0004e20000205400ULL,
0x000000c0bf00720bULL, 0x002fc40003f7d000ULL, 0x00000018ff987819ULL, 0x000fe40000011498ULL,
0x00000018ffd37819ULL, 0x000fe400000114d3ULL, 0x00000018ff6c7819ULL, 0x000fe20000011428ULL,
0x000000b400ab7306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x004fe4000020d400ULL,
0x00000018ff9b7819ULL, 0x000fe4000001149bULL, 0x00000018ffd27819ULL, 0x000fc400000114d2ULL,
0x00000018ff5a7819ULL, 0x000fe2000001142aULL, 0x000000b400ae7306ULL, 0x0002a20000205400ULL,
0x000000bebd00720bULL, 0x008fe40003f5d000ULL, 0x00000018ff517819ULL, 0x000fe4000001142bULL,
0x00000018ffd17819ULL, 0x000fe400000114d1ULL, 0x00000018ffa97819ULL, 0x000fe200000114a9ULL,
0x000000b800b77306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fc4000020d400ULL,
0x00000018ff397819ULL, 0x000fe40000011454ULL, 0x00000018ff357819ULL, 0x000fe40000011455ULL,
0x00000001bbbb2812ULL, 0x000fe200078efcffULL, 0x000000b800bc7306ULL, 0x0002e20000205400ULL,
0x000000aeab00720bULL, 0x004fe40003fdd000ULL, 0x00000018ffaa7819ULL, 0x000fe400000114aaULL,
0x00000018ff317819ULL, 0x000fc40000011456ULL, 0x00000018ff007819ULL, 0x000fe20000011457ULL,
0x0000000d006e7306ULL, 0x000522000000d400ULL, 0x000000b800b87245ULL, 0x002fca000020d400ULL,
0x00000001b4b46812ULL, 0x000fe400078efcffULL, 0x000000ac00cd7306ULL, 0x000fe20000209400ULL,
0x000100000d0d7824ULL, 0x004fe200078e00ffULL, 0x000000bcb700720bULL, 0x008fe40003f3d000ULL,
0x0000006fb4b4723eULL, 0x000fe400000010ffULL, 0x00000018ffc47819ULL, 0x000fe2000001140dULL,
0x00000100240d7824ULL, 0x000fe200078e00ffULL, 0x000000ac00ce7306ULL, 0x0002a20000205400ULL,
0x000000016e6e3812ULL, 0x010fc600078efcffULL, 0x00000018ff0d7819ULL, 0x000fc6000001140dULL,
0x00000001b8b81812ULL, 0x000fe200078efcffULL, 0x0000000f00a57306ULL, 0x000fe20000009400ULL,
0x000000ac00ac7245ULL, 0x002fce000020d400ULL, 0x0000000f00a67306ULL, 0x000e620000005400ULL,
0x000000cecd00720bULL, 0x004fce0003f7d000ULL, 0x000000a400a87306ULL, 0x000fec0000209400ULL,
0x00000001acac3812ULL, 0x000fe400078efcffULL, 0x000000a400a77306ULL, 0x0004e20000205400ULL,
0x000000a6a500720bULL, 0x002fe40003f5d000ULL, 0x000000a400a67245ULL, 0x000fc4000020d400ULL,
0x000000c400a57245ULL, 0x000fc6000020d400ULL, 0x000000c100c27306ULL, 0x000fe20000209400ULL,
0x000000b8bba4723eULL, 0x004fce00000010ffULL, 0x000000c100c37306ULL, 0x000e620000205400ULL,
0x000000a7a800720bULL, 0x008fe40003f3d000ULL, 0x000000c100a77245ULL, 0x000fca000020d400ULL,
0x0000000e00c77306ULL, 0x000fec0000009400ULL, 0x00000001a6a61812ULL, 0x000fe400078efcffULL,
0x0000000e00c87306ULL, 0x000ea20000005400ULL, 0x000000c3c200720bULL, 0x002fce0003fdd000ULL,
0x000000ad00cf7306ULL, 0x000fec0000209400ULL, 0x00000001a7a76812ULL, 0x000fe400078efcffULL,
0x000000ad00d07306ULL, 0x0002e20000205400ULL, 0x000000c8c700720bULL, 0x004fce0003fbd000ULL,
0x0000000f00637306ULL, 0x000ea2000000d400ULL, 0x000000ad00ad7245ULL, 0x002fce000020d400ULL,
0x000000b000c97306ULL, 0x000fe20000209400ULL, 0x000000d0cf00720bULL, 0x008fce0003f7d000ULL,
0x000000b000ca7306ULL, 0x0002e20000205400ULL, 0x0000000163632812ULL, 0x004fca00078efcffULL,
0x00000001adad3812ULL, 0x000fe400078efcffULL, 0x000000af00cb7306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fce000020d400ULL, 0x000000af00cc7306ULL, 0x0002a20000205400ULL,
0x000000cac900720bULL, 0x008fce0003fdd000ULL, 0x0000000d00ba7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x00000001b0b06812ULL, 0x000fe400078efcffULL,
0x0000000d00b97306ULL, 0x000e620000205400ULL, 0x000000cccb00720bULL, 0x004fce0003f3d000ULL,
0x0000002400a27306ULL, 0x000fec0000009400ULL, 0x00000001afaf1812ULL, 0x000fe400078efcffULL,
0x0000002400a07306ULL, 0x000fe20000005400ULL, 0x000000b9ba00720bULL, 0x002fce0003f5d000ULL,
0x00000024005e7306ULL, 0x0003f0000000d400ULL, 0x0000000e00667306ULL, 0x000ea2000000d400ULL,
0x0001000024247824ULL, 0x002fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000008e00957306ULL, 0x000ff00000209400ULL, 0x0000008e00967306ULL, 0x0002e20000205400ULL,
0x0000000166665812ULL, 0x004fc800078efcffULL, 0x00000066b066723eULL, 0x000fc600000010ffULL,
0x00000026008d7306ULL, 0x000fe20000009400ULL, 0x0000008e008e7245ULL, 0x002fce000020d400ULL,
0x00000026008c7306ULL, 0x000e620000005400ULL, 0x000000969500720bULL, 0x008fce0003fbd000ULL,
0x0000002500907306ULL, 0x000fec0000009400ULL, 0x000000018e8e5812ULL, 0x000fe400078efcffULL,
0x00000025008f7306ULL, 0x000ea20000005400ULL, 0x0000008c8d00720bULL, 0x002fe40003f7d000ULL,
0x0000000d008c7245ULL, 0x000fc8000020d400ULL, 0x000000018c8c2812ULL, 0x000fe200078efcffULL,
0x0000009100977306ULL, 0x000ff00000209400ULL, 0x0000009100947306ULL, 0x0002e20000205400ULL,
0x0000008f9000720bULL, 0x004fce0003f3d000ULL, 0x000000c400c57306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x002fce000020d400ULL, 0x000000c400c67306ULL, 0x000e620000205400ULL,
0x000000949700720bULL, 0x008fce0003fdd000ULL, 0x0000002400b17306ULL, 0x000fec0000209400ULL,
0x0000000191916812ULL, 0x000fe400078efcffULL, 0x0000002400b67306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fce0003f9d000ULL, 0x0000002700877306ULL, 0x000fec0000009400ULL,
0x00000001a5a54812ULL, 0x000fe400078efcffULL, 0x0000002700867306ULL, 0x000e620000005400ULL,
0x000000b6b100720bULL, 0x004fe40003f5d000ULL, 0x000000a0a200720bULL, 0x000fc40003f9d000ULL,
0x000000a5a6a5723eULL, 0x000fc600000010ffULL, 0x0000002500627306ULL, 0x000eb0000000d400ULL,
0x0000000c00b27306ULL, 0x000fe20000209400ULL, 0x000000868700720bULL, 0x002fe40003fbd000ULL,
0x0000000c00877245ULL, 0x000fc4000020d400ULL, 0x0000002400867245ULL, 0x000fe4000020d400ULL,
0x0000b80052247811ULL, 0x000fe200078e20ffULL, 0x0000000c00b37306ULL, 0x0002e20000205400ULL,
0x0000000162621812ULL, 0x004fe400078efcffULL, 0x0000000186862812ULL, 0x000fe400078efcffULL,
0x000000015e5e4812ULL, 0x000fe400078efcffULL, 0x0000006700527245ULL, 0x000fe2000020d400ULL,
0x0000009900257306ULL, 0x000fe20000209400ULL, 0x0000b800530c7811ULL, 0x002fc400078e20ffULL,
0x0000005e8c5e723eULL, 0x000fca00000010ffULL, 0x0000009900b57306ULL, 0x0002a20000205400ULL,
0x000000b3b200720bULL, 0x008fce0003fdd000ULL, 0x00000093000f7306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fca000020d400ULL, 0x0000000187876812ULL, 0x000fe400078efcffULL,
0x00000093000e7306ULL, 0x0002e20000205400ULL, 0x000000b52500720bULL, 0x004fe40003f3d000ULL,
0x0000006ea7b5723eULL, 0x000fca00000010ffULL, 0x0000002600597306ULL, 0x000522000000d400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x0000000199991812ULL, 0x000fe400078efcffULL,
0x0000002700507306ULL, 0x000362000000d400ULL, 0x000100002a267824ULL, 0x004fe200078e00ffULL,
0x0000000e0f00720bULL, 0x008fe40003f5d000ULL, 0x000000000c0c783bULL, 0x000ea40000000200ULL,
0x00000018ff537819ULL, 0x000fe40000011426ULL, 0x00000085008b7306ULL, 0x000fe20000209400ULL,
0x0001000028277824ULL, 0x002fe200078e00ffULL, 0x0000000159593812ULL, 0x010fc800078efcffULL,
0x00000018ffbd7819ULL, 0x000fe40000011427ULL, 0x0000008500897306ULL, 0x0002e20000205400ULL,
0x000000002424783bULL, 0x000f220000000200ULL, 0x0000000150505812ULL, 0x020fe400078efcffULL,
0x0000000193932812ULL, 0x000fc800078efcffULL, 0x00000070008a7306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x002fce000020d400ULL, 0x0000007000887306ULL, 0x0003620000205400ULL,
0x000000898b00720bULL, 0x008fce0003f9d000ULL, 0x0000002900837306ULL, 0x000fe20000009400ULL,
0x0000007000707245ULL, 0x002fe2000020d400ULL, 0x0000005d0c0c8231ULL, 0x004fc800003400ffULL,
0x0000000185854812ULL, 0x000fe200078efcffULL, 0x0000005d0e0e8231ULL, 0x000fe200003400ffULL,
0x00000029007c7306ULL, 0x000e620000005400ULL, 0x000000888a00720bULL, 0x020fe20003fdd000ULL,
0x0000005f0d0d8231ULL, 0x080fe200003400ffULL, 0x000000868586723eULL, 0x000fe200000010ffULL,
0x0000005f0f0f8231ULL, 0x000fc800003400ffULL, 0x00000092009c7306ULL, 0x000fe20000209400ULL,
0x0000005d24248231ULL, 0x090fe400003400ffULL, 0x0000005d26268231ULL, 0x000fe200003400ffULL,
0x000000b40c14723cULL, 0x040fe20000041814ULL, 0x0000005f25258231ULL, 0x080fe200003400ffULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x0000005f27278231ULL, 0x000fe200003400ffULL,
0x00000092009f7306ULL, 0x0004e20000205400ULL, 0x0000007c8300720bULL, 0x002fe40003fbd000ULL,
0x0000009800837245ULL, 0x000fe2000020d400ULL, 0x000000a40c10723cULL, 0x000fe20000041810ULL,
0x00000062875f723eULL, 0x000fc400000010ffULL, 0x000000997087723eULL, 0x000fe200000010ffULL,
0x0000009a009d7306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x004fc6000020d400ULL,
0x0000005e0c2c723cULL, 0x000fe8000004182cULL, 0x0000009a009e7306ULL, 0x0002a20000205400ULL,
0x0000009f9c00720bULL, 0x008fc60003f9d000ULL, 0x000000860c18723cULL, 0x000fe80000041818ULL,
0x00000029003e7306ULL, 0x000ee2000000d400ULL, 0x0000009a009a7245ULL, 0x002fca000020d400ULL,
0x0000000192924812ULL, 0x000fe400078efcffULL, 0x00000067007e7306ULL, 0x000fe20000209400ULL,
0x0000009e9d00720bULL, 0x004fce0003fdd000ULL, 0x0000006700787306ULL, 0x0002a20000205400ULL,
0x000000013e3e5812ULL, 0x008fca00078efcffULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000002800717306ULL, 0x000fe20000009400ULL, 0x00000063ac67723eULL, 0x002fce00000010ffULL,
0x0000002800757306ULL, 0x000e620000005400ULL, 0x000000787e00720bULL, 0x004fe20003fbd000ULL,
0x000000660c04723cULL, 0x000fec0000041804ULL, 0x0000002a00817306ULL, 0x000fec0000009400ULL,
0x0000000152525812ULL, 0x000fc400078efcffULL, 0x0000002a00747306ULL, 0x000ea20000005400ULL,
0x000000757100720bULL, 0x002fce0003f3d000ULL, 0x0000008200797306ULL, 0x000ff00000209400ULL,
0x00000082007d7306ULL, 0x0002e20000205400ULL, 0x000000748100720bULL, 0x004fce0003fdd000ULL,
0x0000009800a17306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x002fce000020d400ULL,
0x0000009800a37306ULL, 0x000e620000205400ULL, 0x0000007d7900720bULL, 0x008fce0003f5d000ULL,
0x000000bd00a87306ULL, 0x000fec0000209400ULL, 0x0000000182822812ULL, 0x000fe400078efcffULL,
0x000000bd00be7306ULL, 0x0004e20000205400ULL, 0x000000a3a100720bULL, 0x002fe40003f9d000ULL,
0x0000009a8282723eULL, 0x000fca00000010ffULL, 0x0000008000847306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x004fca000020d400ULL, 0x0000000183834812ULL, 0x000fe400078efcffULL,
0x00000080007a7306ULL, 0x0002a20000205400ULL, 0x000000bea800720bULL, 0x008fce0003f1d000ULL,
0x000000d300897306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x00000001bdbd0812ULL, 0x000fe400078efcffULL, 0x000000d3008a7306ULL, 0x0002e20000205400ULL,
0x0000007a8400720bULL, 0x004fce0003f7d000ULL, 0x00000028003f7306ULL, 0x000522000000d400ULL,
0x000000d300d37245ULL, 0x002fca000020d400ULL, 0x0000000180803812ULL, 0x000fe400078efcffULL,
0x0000002a003d7306ULL, 0x000e62000000d400ULL, 0x0000010029287824ULL, 0x004fe200078e00ffULL,
0x0000008a8900720bULL, 0x008fe20003fbd000ULL, 0x0000010056297824ULL, 0x000fe200078e00ffULL,
0x000000838083723eULL, 0x000fe400000010ffULL, 0x00000018ffae7819ULL, 0x000fe20000011428ULL,
0x0000010057287824ULL, 0x000fe200078e00ffULL, 0x0000002b007b7306ULL, 0x000fe20000009400ULL,
0x000000013f3f1812ULL, 0x010fc400078efcffULL, 0x000000820c20723cULL, 0x000fe20000041820ULL,
0x00000018ff5e7819ULL, 0x000fe40000011428ULL, 0x000000599328723eULL, 0x000fe400000010ffULL,
0x0000002b00767306ULL, 0x000ea20000005400ULL, 0x000000013d3d6812ULL, 0x002fe400078efcffULL,
0x00000001d3d35812ULL, 0x000fca00078efcffULL, 0x0000006c00737306ULL, 0x000ff00000209400ULL,
0x0000006c00727306ULL, 0x0002e20000205400ULL, 0x000000767b00720bULL, 0x004fce0003f5d000ULL,
0x0000009b002a7306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fce000020d400ULL,
0x0000009b00ab7306ULL, 0x0002a20000205400ULL, 0x000000727300720bULL, 0x008fce0003f3d000ULL,
0x000000d2008f7306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fca000020d400ULL,
0x000000016c6c1812ULL, 0x000fe400078efcffULL, 0x000000d2008d7306ULL, 0x0002e20000205400ULL,
0x000000ab2a00720bULL, 0x004fe40003f9d000ULL, 0x000000af912a723eULL, 0x000fca00000010ffULL,
0x0000005300887306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x002fca000020d400ULL,
0x000000019b9b4812ULL, 0x000fe400078efcffULL, 0x0000005300717306ULL, 0x0002a20000205400ULL,
0x0000008d8f00720bULL, 0x008fce0003f1d000ULL, 0x0000005a00617306ULL, 0x000fe20000209400ULL,
0x0000005300537245ULL, 0x002fca000020d400ULL, 0x00000001d2d20812ULL, 0x000fe400078efcffULL,
0x0000005a00607306ULL, 0x0002e20000205400ULL, 0x000000718800720bULL, 0x004fe40003fdd000ULL,
0x0000003dd2d2723eULL, 0x000fca00000010ffULL, 0x000000ae00b77306ULL, 0x000fe20000209400ULL,
0x0000005a005a7245ULL, 0x002fca000020d400ULL, 0x0000000153536812ULL, 0x000fe400078efcffULL,
0x000000ae00bc7306ULL, 0x0002a20000205400ULL, 0x000000606100720bULL, 0x008fe40003fbd000ULL,
0x00000018ff607819ULL, 0x000fe40000011429ULL, 0x000000509229723eULL, 0x000fc600000010ffULL,
0x0000002b00387306ULL, 0x000722000000d400ULL, 0x000000ae00ae7245ULL, 0x002fc6000020d400ULL,
0x000000280c1c723cULL, 0x000fe4000004181cULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x00000054007f7306ULL, 0x000fe20000009400ULL, 0x000100002b2b7824ULL, 0x008fe200078e00ffULL,
0x000000bcb700720bULL, 0x004fe40003f7d000ULL, 0x0000003f9b28723eULL, 0x000fe400000010ffULL,
0x00000018ff757819ULL, 0x000fc4000001142bULL, 0x0000005400777306ULL, 0x000e620000005400ULL,
0x0000000138382812ULL, 0x010fe400078efcffULL, 0x000000ad8e2b723eULL, 0x000fe400000010ffULL,
0x00000038d3d3723eULL, 0x000fe400000010ffULL, 0x00000001aeae3812ULL, 0x000fe200078efcffULL,
0x0000005500697306ULL, 0x000fe20000009400ULL, 0x000000535a5a723eULL, 0x000fe200000010ffULL,
0x0000002a0c08723cULL, 0x000fe20000041808ULL, 0x0000003eae29723eULL, 0x000fca00000010ffULL,
0x0000005500687306ULL, 0x000ea20000005400ULL, 0x000000777f00720bULL, 0x002fe20003f9d000ULL,
0x00000028240c723cULL, 0x000fe20000041814ULL, 0x000000bd6c2a723eULL, 0x000fca00000010ffULL,
0x0000005700657306ULL, 0x000fe40000009400ULL, 0x000000d22404723cULL, 0x000fec0000041804ULL,
0x0000005700647306ULL, 0x000e620000005400ULL, 0x000000686900720bULL, 0x004fce0003f3d000ULL,
0x00000051005b7306ULL, 0x000ff00000209400ULL, 0x00000051005c7306ULL, 0x0004e20000205400ULL,
0x000000646500720bULL, 0x002fce0003f1d000ULL, 0x0000007500797306ULL, 0x000fe20000209400ULL,
0x0000005100517245ULL, 0x004fce000020d400ULL, 0x0000007500747306ULL, 0x000e620000205400ULL,
0x0000005c5b00720bULL, 0x008fe40003f5d000ULL, 0x00000075005b7245ULL, 0x000fca000020d400ULL,
0x000000d100a07306ULL, 0x000fec0000209400ULL, 0x0000000151512812ULL, 0x000fe400078efcffULL,
0x000000d100947306ULL, 0x0004e20000205400ULL, 0x000000747900720bULL, 0x002fce0003fdd000ULL,
0x000000a900767306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x004fca000020d400ULL,
0x000000015b5b6812ULL, 0x000fe400078efcffULL, 0x000000a9005d7306ULL, 0x0002a20000205400ULL,
0x00000094a000720bULL, 0x008fe40003f7d000ULL, 0x0000005b515b723eULL, 0x000fca00000010ffULL,
0x0000005400367306ULL, 0x000722000000d400ULL, 0x000000a900a97245ULL, 0x002fe2000020d400ULL,
0x0000005a2408723cULL, 0x000fe80000041808ULL, 0x00000001d1d13812ULL, 0x000fe400078efcffULL,
0x0000005500347306ULL, 0x000362000000d400ULL, 0x0001000054547824ULL, 0x008fe200078e00ffULL,
0x0000005d7600720bULL, 0x004fc40003fbd000ULL, 0x000000d1522b723eULL, 0x000fe400000010ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000039004f7306ULL, 0x000fe20000209400ULL,
0x0001000055557824ULL, 0x002fe200078e00ffULL, 0x0000000136364812ULL, 0x010fe200078efcffULL,
0x0000002a2410723cULL, 0x000fe60000041810ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x0000003900587306ULL, 0x0002a20000205400ULL, 0x00000001a9a95812ULL, 0x000fe400078efcffULL,
0x0000000134341812ULL, 0x020fe400078efcffULL, 0x00000036a914723eULL, 0x000fc600000010ffULL,
0x00000035004d7306ULL, 0x000fe20000209400ULL, 0x0000003900397245ULL, 0x002fce000020d400ULL,
0x00000035004e7306ULL, 0x0002e20000205400ULL, 0x000000584f00720bULL, 0x004fce0003fdd000ULL,
0x00000056006a7306ULL, 0x000fe20000009400ULL, 0x0000003500357245ULL, 0x002fca000020d400ULL,
0x0000000139396812ULL, 0x000fe400078efcffULL, 0x00000056006b7306ULL, 0x000e620000005400ULL,
0x0000004e4d00720bULL, 0x008fce0003f5d000ULL, 0x000000aa00777306ULL, 0x000fec0000209400ULL,
0x0000000135352812ULL, 0x000fe400078efcffULL, 0x000000aa00727306ULL, 0x0004e20000205400ULL,
0x0000006b6a00720bULL, 0x002fce0003f7d000ULL, 0x00000054006e7306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x004fce000020d400ULL, 0x0000005400687306ULL, 0x0002a20000205400ULL,
0x000000727700720bULL, 0x008fce0003fbd000ULL, 0x0000005500647306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x002fca000020d400ULL, 0x00000001aaaa5812ULL, 0x000fe400078efcffULL,
0x0000005500637306ULL, 0x0002e20000205400ULL, 0x000000686e00720bULL, 0x004fe40003f9d000ULL,
0x00000034aa15723eULL, 0x000fca00000010ffULL, 0x0000005600337306ULL, 0x000522000000d400ULL,
0x0000005500557245ULL, 0x002fca000020d400ULL, 0x0000000154544812ULL, 0x000fe400078efcffULL,
0x0000005700327306ULL, 0x000362000000d400ULL, 0x0001000056567824ULL, 0x004fe200078e00ffULL,
0x000000636400720bULL, 0x008fe40003f3d000ULL, 0x000000543954723eULL, 0x000fe400000010ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000031003c7306ULL, 0x000fe20000209400ULL,
0x0001000057577824ULL, 0x002fe200078e00ffULL, 0x0000000133333812ULL, 0x010fc800078efcffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000031003b7306ULL, 0x0002a20000205400ULL,
0x0000000155551812ULL, 0x000fe400078efcffULL, 0x0000000132320812ULL, 0x020fe400078efcffULL,
0x000000553555723eULL, 0x000fc600000010ffULL, 0x0000000000377306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fc6000020d400ULL, 0x000000542418723cULL, 0x000fe80000041818ULL,
0x00000000003a7306ULL, 0x0002e20000205400ULL, 0x0000003b3c00720bULL, 0x004fce0003fbd000ULL,
0x0000006000617306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x002fca000020d400ULL,
0x0000000131315812ULL, 0x000fe400078efcffULL, 0x00000060005c7306ULL, 0x0002a20000205400ULL,
0x0000003a3700720bULL, 0x008fce0003f9d000ULL, 0x0000005e00597306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x002fca000020d400ULL, 0x0000000100004812ULL, 0x000fe400078efcffULL,
0x0000005e004f7306ULL, 0x000e620000205400ULL, 0x0000005c6100720bULL, 0x004fe40003fdd000ULL,
0x0000005e00617245ULL, 0x000fca000020d400ULL, 0x00000056004d7306ULL, 0x000fec0000209400ULL,
0x0000000160606812ULL, 0x000fe400078efcffULL, 0x00000056003e7306ULL, 0x0004e20000205400ULL,
0x0000004f5900720bULL, 0x002fe40003f3d000ULL, 0x000000336060723eULL, 0x000fca00000010ffULL,
0x0000005700167306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x004fca000020d400ULL,
0x0000000161611812ULL, 0x000fe400078efcffULL, 0x0000005700177306ULL, 0x0002a20000205400ULL,
0x0000003e4d00720bULL, 0x008fe40003f5d000ULL, 0x000000326161723eULL, 0x000fe400000010ffULL,
0x0000005700577245ULL, 0x002fca000020d400ULL, 0x00000060241c723cULL, 0x040fe8000004181cULL,
0x0000000156562812ULL, 0x000fe400078efcffULL, 0x000000171600720bULL, 0x004fe40003f7d000ULL,
0x000000563156723eULL, 0x000fe200000010ffULL, 0x000000142414723cULL, 0x000ff4000004182cULL,
0x0000000157573812ULL, 0x000fc800078efcffULL, 0x000000570057723eULL, 0x000fce00000010ffULL,
0x000000562420723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe4000c80043fULL,
0x0000030040407a10ULL, 0x000fc80007ffe0ffULL, 0x000000024000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffebba000007947ULL, 0x000fea000383ffffULL,
0x0000000000307919ULL, 0x002e620000002500ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0023ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0022ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0021ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0020ULL, 0x000000ffff237224ULL, 0x000fe400078e0017ULL,
0x000000ffff227224ULL, 0x000fc400078e0016ULL, 0x000000ffff217224ULL, 0x000fe400078e0015ULL,
0x000000ffff207224ULL, 0x000fe400078e0014ULL, 0x000000ffff2b7224ULL, 0x000fe400078e001fULL,
0x000000ffff2a7224ULL, 0x000fe400078e001eULL, 0x000000ffff297224ULL, 0x000fe400078e001dULL,
0x000000ffff287224ULL, 0x000fe200078e001cULL, 0x000000023000720cULL, 0x002fe20003f06070ULL,
0x000000ffff277224ULL, 0x000fc400078e001bULL, 0x000000ffff267224ULL, 0x000fe400078e001aULL,
0x000000ffff257224ULL, 0x004fe400078e0019ULL, 0x000000ffff247224ULL, 0x000fe400078e0018ULL,
0x000000ffff177224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x000fe400078e0012ULL,
0x000000ffff157224ULL, 0x000fc400078e0011ULL, 0x000000ffff147224ULL, 0x000fe400078e0010ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000bULL, 0x000000ffff1e7224ULL, 0x000fe400078e000aULL,
0x000000ffff1d7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0008ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0007ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0006ULL,
0x000000ffff197224ULL, 0x000fe400078e0005ULL, 0x000000ffff187224ULL, 0x000fe400078e0004ULL,
0x000000ffff137224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x000fe400078e000eULL,
0x000000ffff117224ULL, 0x000fc400078e000dULL, 0x000000ffff107224ULL, 0x000fe200078e000cULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x0180000047007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff317224ULL, 0x000fe200078e0047ULL, 0x0001559000047802ULL, 0x000fe40000000f00ULL,
0x0000a4b000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000004700007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000047ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000200007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006800ff027624ULL, 0x000fe400078e00ffULL,
0x00006900ff037624ULL, 0x000fca00078e00ffULL, 0x0000000602027981ULL, 0x000968000c1e9900ULL,
0x0000000000037919ULL, 0x010f240000000000ULL, 0x00000002ff047819ULL, 0x010fe40000011603ULL,
0x0000000803037811ULL, 0x000fe200078ff0ffULL, 0x0000000002007220ULL, 0x02cfca0000410000ULL,
0x00001f0400027589ULL, 0x000ea800000e0000ULL, 0x00001f0300037589ULL, 0x000ee200000e0000ULL,
0x0000001002107220ULL, 0x044fe20000410000ULL, 0x0000001102117220ULL, 0x040fe20000410000ULL,
0x0000001402147220ULL, 0x040fe20000410000ULL, 0x0000001502157220ULL, 0x040fe20000410000ULL,
0x0000001802187220ULL, 0x040fe20000410000ULL, 0x0000001902197220ULL, 0x040fe20000410000ULL,
0x0000001c021c7220ULL, 0x040fe20000410000ULL, 0x0000001d021d7220ULL, 0x040fe20000410000ULL,
0x0000002002207220ULL, 0x040fe20000410000ULL, 0x0000002102217220ULL, 0x040fe20000410000ULL,
0x0000002402247220ULL, 0x040fe20000410000ULL, 0x0000002502257220ULL, 0x040fe20000410000ULL,
0x0000002802287220ULL, 0x040fe20000410000ULL, 0x0000002902297220ULL, 0x040fe20000410000ULL,
0x0000002c022c7220ULL, 0x040fe20000410000ULL, 0x0000002d022d7220ULL, 0x000fe20000410000ULL,
0x0000001203127220ULL, 0x048fe20000410000ULL, 0x0000001303137220ULL, 0x040fe20000410000ULL,
0x0000001603167220ULL, 0x040fe20000410000ULL, 0x0000001703177220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000002a032a7220ULL, 0x040fe20000410000ULL, 0x0000002b032b7220ULL, 0x040fe20000410000ULL,
0x0000002e032e7220ULL, 0x040fe20000410000ULL, 0x0000002f032f7220ULL, 0x000fe20000410000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000200027812ULL, 0x004fc400078ec0ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011600ULL,
0x00000001ff037819ULL, 0x000fe40000011602ULL, 0x0000000202047811ULL, 0x040fe400078ff8ffULL,
0x0000000402077811ULL, 0x040fe400078ff8ffULL, 0x00000006020b7811ULL, 0x000fe400078ff8ffULL,
0x00000008000f7811ULL, 0x000fc400078ff0ffULL, 0x0000000703027812ULL, 0x100fe400078e780dULL,
0x0000000704057812ULL, 0x100fe400078e780dULL, 0x0000000707097812ULL, 0x000fe200078e780dULL,
0x000000080d067824ULL, 0x000fe200078e0202ULL, 0x0000000707077812ULL, 0x000fe200078e780fULL,
0x000000080d087824ULL, 0x000fe200078e0205ULL, 0x000000070b0c7812ULL, 0x000fe200078e780dULL,
0x0000080042027824ULL, 0x000fe200078e00ffULL, 0x0000000703037812ULL, 0x000fe200078e780fULL,
0x000000080f0e7824ULL, 0x000fe200078e0207ULL, 0x0000000704047812ULL, 0x000fe200078e780fULL,
0x000000080d0a7824ULL, 0x000fe200078e0209ULL, 0x000000070b057812ULL, 0x000fe200078e780fULL,
0x000000080d0c7824ULL, 0x000fc400078e020cULL, 0x000000080f0b7824ULL, 0x040fe200078e0203ULL,
0x0000a00002037810ULL, 0x000fe20007ffe0ffULL, 0x0000000800077824ULL, 0x000fe400078e00ffULL,
0x000000080f0d7824ULL, 0x000fe200078e0204ULL, 0x000000101104723eULL, 0x000fe200000010ffULL,
0x000000080f0f7824ULL, 0x000fe200078e0205ULL, 0x0000000807077812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x000000141505723eULL, 0x000fe200000010ffULL,
0x0000001008097824ULL, 0x000fc400078e0203ULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0x0000541004107816ULL, 0x040fe20000000005ULL, 0x000000100b0b7824ULL, 0x000fe200078e0203ULL,
0x0000763204117816ULL, 0x000fe20000000005ULL, 0x000000100d0d7824ULL, 0x100fe400078e0203ULL,
0x000000100c0c7824ULL, 0x100fe400078e0203ULL, 0x000000100e0e7824ULL, 0x100fe400078e0203ULL,
0x000000100f0f7824ULL, 0x000fc400078e0203ULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000181906723eULL, 0x000fe200000010ffULL, 0x0000000107097824ULL, 0x040fe400078e0209ULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x0000001008007388ULL, 0x0005e20000000a00ULL,
0x00000001070b7824ULL, 0x040fe400078e020bULL, 0x00000001070d7824ULL, 0x040fe400078e020dULL,
0x00000001070c7824ULL, 0x000fc400078e020cULL, 0x00000001070e7824ULL, 0x040fe400078e020eULL,
0x00000001070f7824ULL, 0x000fe200078e020fULL, 0x0000001c1d07723eULL, 0x000fe400000010ffULL,
0x000000121308723eULL, 0x004fe200000010ffULL, 0x00000300ff127624ULL, 0x000fe200078e00ffULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe40000000007ULL,
0x000000282906723eULL, 0x000fc400000010ffULL, 0x0000002c2d07723eULL, 0x000fe200000010ffULL,
0x0000000409007388ULL, 0x0005e20000000a00ULL, 0x000000011200780cULL, 0x000fe40003f05270ULL,
0x000000202104723eULL, 0x004fe400000010ffULL, 0x000000242505723eULL, 0x000fe400000010ffULL,
0x000000161709723eULL, 0x000fe400000010ffULL, 0x0000541004107816ULL, 0x000fc40000000005ULL,
0x0000763204117816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x000000100a007388ULL, 0x000fe20000000a00ULL,
0x000000222306723eULL, 0x000fe400000010ffULL, 0x000000262707723eULL, 0x000fe200000010ffULL,
0x000000040c007388ULL, 0x0005e40000000a00ULL, 0x0000541008047816ULL, 0x004fc40000000009ULL,
0x0000763208057816ULL, 0x000fe40000000009ULL, 0x0000002a2b08723eULL, 0x000fe400000010ffULL,
0x0000002e2f09723eULL, 0x000fe200000010ffULL, 0x000000040b007388ULL, 0x0005e40000000a00ULL,
0x0000001a1b04723eULL, 0x004fe400000010ffULL, 0x0000001e1f05723eULL, 0x000fc800000010ffULL,
0x00005410040a7816ULL, 0x140fe40000000005ULL, 0x00007632040b7816ULL, 0x000fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x0000000a0d007388ULL, 0x0005e20000000a00ULL, 0x0000541008067816ULL, 0x140fe40000000009ULL,
0x0000763208077816ULL, 0x000fe20000000009ULL, 0x000000040e007388ULL, 0x0005e80000000a00ULL,
0x000000060f007388ULL, 0x0005e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002b4000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x000ee20000002700ULL,
0x0000001000047824ULL, 0x004fe200078e0202ULL, 0x000000ff4200720cULL, 0x000fe20003f05270ULL,
0x00001000ff077424ULL, 0x000fe200078e00ffULL, 0x0000000000057919ULL, 0x000ee20000002600ULL,
0x00000020000e7810ULL, 0x040fe40007ffe0ffULL, 0x000000ff0000720cULL, 0x000fe20000725670ULL,
0x00a0000004147984ULL, 0x000ea80000000c00ULL, 0x00a2000004187984ULL, 0x0008640000000c00ULL,
0x0000580012047a24ULL, 0x010fc800078e02ffULL, 0x0000660004087a24ULL, 0x000fe400078e02ffULL,
0x0000580010107a24ULL, 0x008fc600078e0205ULL, 0x00000fff08057811ULL, 0x000fe200078e40ffULL,
0x0000030010047a24ULL, 0x000fc800078e02ffULL, 0x0000000104097824ULL, 0x000fca00078e0230ULL,
0x0000000905067211ULL, 0x000fca00078fa0ffULL, 0x00006c0006067625ULL, 0x000fcc00078e0007ULL,
0x0000040042067825ULL, 0x000fcc00078e0006ULL, 0x000000100e0e7825ULL, 0x000fc800078e0006ULL,
0x00000010000c7825ULL, 0x000fe200078e0006ULL, 0x01ffffff08067812ULL, 0x000fe200078ec0ffULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x006fe20000011600ULL,
0x0000001000077824ULL, 0x000fe400078e00ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000c08117812ULL, 0x000fe200078ec0ffULL, 0x00000001090a7824ULL, 0x000fe200078e0206ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x00006c0009087625ULL, 0x000fc800078e000bULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000811087210ULL, 0x000fc80007b5e007ULL,
0x0000000a110a7210ULL, 0x000fe40007d9e007ULL, 0x00000009ff097210ULL, 0x000fe400017e64ffULL,
0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL, 0x0000004608007986ULL, 0x0003e8000c101906ULL,
0x000000470a007986ULL, 0x0003e4000c101906ULL, 0x000000140c007986ULL, 0x0063e2000c101d06ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x000000180e007986ULL, 0x0003e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff087424ULL, 0x000fe200078e00ffULL, 0xffffffff12077810ULL, 0x000fc60007ffe0ffULL,
0x00006a0010087625ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000007080879a8ULL, 0x000ea400099ee1c6ULL,
0x000000070800720cULL, 0x004fe20003f25270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff077807ULL, 0x000fca0000800000ULL, 0x00000007ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff077984ULL, 0x004ea40000000000ULL, 0x000000ff0700720cULL, 0x004fda0003f25270ULL,
0x0000278000009947ULL, 0x000fea0003800000ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff087819ULL, 0x000fe20000011600ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x00000001040a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x0000000c08147812ULL, 0x002fe400078ec0ffULL, 0x0000007007137812ULL, 0x000fe200078ec0ffULL,
0x00006c0004087625ULL, 0x000fc800078e0011ULL, 0x00006c000a0a7625ULL, 0x000fe200078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x0000000a140a7210ULL, 0x000fe40007b5e013ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x0000000608077981ULL, 0x000368000c1e1900ULL, 0x000000060a0c7981ULL, 0x000362000c1e1900ULL,
0x000000021200780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000204087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080d7981ULL, 0x000362000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000304087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080e7981ULL, 0x000362000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000404087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000504087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608107981ULL, 0x000362000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081200780cULL, 0x002fe40003f06070ULL, 0x0000000604087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fe40007a3e013ULL,
0x00000007040a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000a0a0625ULL, 0x000fe400078e0011ULL, 0x0000000608117981ULL, 0x000366000c1e1900ULL,
0x0000000a140a0210ULL, 0x000fc80007c7e013ULL, 0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL,
0x000000060a0a0981ULL, 0x000368000c1e1900ULL, 0x0000000712087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0b7819ULL, 0x000fc80000011608ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff127224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x020fe400078e0007ULL, 0x0000000812147824ULL, 0x040fe200078e00ffULL,
0x0000000112127810ULL, 0x000fc80007ffe0ffULL, 0x0000030014007a0cULL, 0x000fe40003f26070ULL,
0x0000000b1200720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x0000000814087810ULL, 0x040fe40007ffe0ffULL, 0x0000000114097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001307077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000137824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x0000000914087810ULL, 0x042fe40007ffe0ffULL,
0x0000000214097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000c07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e00cULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080c7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000314097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000d7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000414097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000e07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e00eULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080e7981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000514097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000f7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000614097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001007077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010107812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e010ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608107981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000714097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001107077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f14087810ULL, 0x002fe40007ffe0ffULL,
0x0000000a07077209ULL, 0x000fe40007810000ULL, 0x0000030008007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000814087210ULL, 0x000fc80007a3e00aULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080a7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000087824ULL, 0x006fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011600ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000108087824ULL, 0x000fca00078e0209ULL,
0x0000000708007388ULL, 0x0203e40000000800ULL, 0x0000000405087211ULL, 0x002fe200078fa0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00001000ff097424ULL, 0x000fe200078e00ffULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011600ULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x00000016ff417819ULL, 0x000fe20000011642ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x0000040042407824ULL, 0x000fe200078e00ffULL,
0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000100042207824ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0000004008087210ULL, 0x000fe20007f3e0ffULL, 0x0000000107177824ULL, 0x000fe200078e020aULL,
0x00000020000a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001040c8824ULL, 0x000fe200078e0206ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000109097824ULL, 0x000fe200008e0641ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff0d8424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0e8424ULL, 0x000fe200078e00ffULL,
0x0000000017177984ULL, 0x000e620000000800ULL, 0x00006c000c0c8625ULL, 0x000fe200078e000dULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x000000100a0a7825ULL, 0x000fe200078e0008ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000001000077824ULL, 0x000fc400078e0220ULL,
0x0000001042108824ULL, 0x000fe400078e0200ULL, 0x0000001000087825ULL, 0x000fc600078e0008ULL,
0x0000458010108811ULL, 0x000fe200078e20ffULL, 0x00006c00040e8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008077faeULL, 0x0005e6000b901c46ULL,
0x0000001042118824ULL, 0x000fe200078e0200ULL, 0x003800000a077faeULL, 0x0007e2000b901c46ULL,
0x00000010000c8825ULL, 0x000fc600078e000cULL, 0x0000418011118811ULL, 0x000fe200078e20ffULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000000000c108faeULL, 0x0009e2000b901c46ULL,
0x0000001000088825ULL, 0x004fe400078e000eULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x000000ffff077224ULL, 0x008fe200078e00ffULL, 0x0000000008118faeULL, 0x0005e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000cf000009947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x002fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e00ffULL,
0x0000000132337810ULL, 0x000fc80007ffe0ffULL, 0x0000030033007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x00000001041f7824ULL, 0x000fe200078e0233ULL,
0x000000070000780cULL, 0x040fe20003f24070ULL, 0x00001000ff197424ULL, 0x000fe200078e00ffULL,
0x00000001331e7812ULL, 0x040fe200078ec0ffULL, 0x00000800331a7824ULL, 0x000fe200078e00ffULL,
0x0000001f05187211ULL, 0x000fe400078fa0ffULL, 0x0000002000367810ULL, 0x000fe40007ffe0ffULL,
0x000008001a1c7812ULL, 0x000fe200078ec0ffULL, 0x00006c0018187625ULL, 0x000fc800078e0019ULL,
0x00000001061b9824ULL, 0x000fe200078e021fULL, 0x0000004018187210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff349424ULL, 0x000fe400078e00ffULL, 0x00000002421d9824ULL, 0x140fe400078e021eULL,
0x0000000242379824ULL, 0x000fe400078e021eULL, 0x00006c001b1a9625ULL, 0x000fc800078e0034ULL,
0x00000080ff1e9424ULL, 0x000fe400078e00ffULL, 0x00000001201c7824ULL, 0x000fe400078e021cULL,
0x0000000119197824ULL, 0x000fe400000e0641ULL, 0x000000081d359824ULL, 0x000fe400078e0200ULL,
0x00006c001f1e9625ULL, 0x000fc600078e001eULL, 0x0000458035359811ULL, 0x000fe200078e20ffULL,
0x0000001000347824ULL, 0x040fe400078e021cULL, 0x0000000837379824ULL, 0x000fe400078e0200ULL,
0x00000010001c9825ULL, 0x000fc800078e001aULL, 0x00000010361a7825ULL, 0x000fe200078e0018ULL,
0x0000418037369811ULL, 0x000fc600078e20ffULL, 0x0000001000187825ULL, 0x000fc800078e0018ULL,
0x00000010001e9825ULL, 0x000fe200078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000018347faeULL, 0x0003e8000b901c46ULL, 0x003800001a347faeULL, 0x0003e8000b901c46ULL,
0x000000001c359faeULL, 0x0003e8000b901c46ULL, 0x000000001e369faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff357224ULL, 0x002fe200078e0032ULL,
0x00000001ff1a7819ULL, 0x100fe20000011600ULL, 0x0000001000197824ULL, 0x000fe200078e00ffULL,
0x00000002ff437819ULL, 0x000fe20000011600ULL, 0x0000008035187824ULL, 0x000fe200078e00ffULL,
0x0000000c1a1a7812ULL, 0x000fc400078ec0ffULL, 0x0000007019197812ULL, 0x000fe200078ec0ffULL,
0x00000008431b7824ULL, 0x040fe200078e00ffULL, 0x0000008018187812ULL, 0x000fe400078ec0ffULL,
0x00000043ff347212ULL, 0x000fe400078e33ffULL, 0x0000000743327812ULL, 0x000fe200078ec0ffULL,
0x0000010042187824ULL, 0x000fe200078e0218ULL, 0xfffffff81b347812ULL, 0x000fe400078ee234ULL,
0x0000000843447810ULL, 0x000fc40007ffe0ffULL, 0x000000181a187210ULL, 0x000fe20007ffe019ULL,
0x0000000843197824ULL, 0x000fe200078e00ffULL, 0x00000044ff3d7212ULL, 0x000fe200078e33ffULL,
0x0000000844367824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000181a7984ULL, 0x000e620000000800ULL, 0x00000001191b7812ULL, 0x140fe200078ef632ULL,
0x0000000844377824ULL, 0x000fe200078e00ffULL, 0x00000002191c7812ULL, 0x140fe200078ef632ULL,
0x00458000183f7984ULL, 0x0004e20000000800ULL, 0x00000003191d7812ULL, 0x140fe400078ef632ULL,
0x00000004191e7812ULL, 0x140fe400078ef632ULL, 0x00000005191f7812ULL, 0x000fe400078ef632ULL,
0xfffffff8363d7812ULL, 0x000fe200078ee23dULL, 0x0000000843187824ULL, 0x004fca00078e00ffULL,
0xfffffff818187812ULL, 0x100fe400078ee232ULL, 0x0000000619327812ULL, 0x000fe200078ef632ULL,
0x0000080035197824ULL, 0x000fca00078e00ffULL, 0x0000080019197812ULL, 0x000fc800078ec0ffULL,
0x0000018020197810ULL, 0x000fca0007ffe019ULL, 0x0000001018187824ULL, 0x100fe400078e0219ULL,
0x0000001034347824ULL, 0x100fe400078e0219ULL, 0x000000101b1b7824ULL, 0x100fe200078e0219ULL,
0x0000001a171a7221ULL, 0x002fe20000010100ULL, 0x000000101c1c7824ULL, 0x100fe400078e0219ULL,
0x000000101d1d7824ULL, 0x000fe200078e0219ULL, 0x3fb8aa3b1a357820ULL, 0x000fe20000410000ULL,
0x00000004001a7824ULL, 0x000fc400078e00ffULL, 0x000000101e1e7824ULL, 0x100fe200078e0219ULL,
0x00000035003e7308ULL, 0x0002e20000000800ULL, 0x000000101f1f7824ULL, 0x100fe200078e0219ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000001032327824ULL, 0x100fe400078e0219ULL,
0x000000103d3d7824ULL, 0x000fe400078e0219ULL, 0x0000000118187824ULL, 0x000fe200078e021aULL,
0x0000000744357812ULL, 0x002fe200078ec0ffULL, 0x000000011a347824ULL, 0x000fc400078e0234ULL,
0x000000011a1b7824ULL, 0x000fe200078e021bULL, 0xfffffff836367812ULL, 0x100fe200078ee235ULL,
0x000000011a1c7824ULL, 0x000fe200078e021cULL, 0x0000000137387812ULL, 0x140fe200078ef635ULL,
0x0000003f3e3e7220ULL, 0x008fe20000410000ULL, 0x0000000237397812ULL, 0x140fe200078ef635ULL,
0x00000000343f7984ULL, 0x000fe20000000800ULL, 0x00000003373a7812ULL, 0x040fe200078ef635ULL,
0x000000011a1d7824ULL, 0x040fe200078e021dULL, 0x00000004373b7812ULL, 0x140fe200078ef635ULL,
0x000000001b347984ULL, 0x000fe20000000800ULL, 0x00000005373c7812ULL, 0x140fe200078ef635ULL,
0x000000011a1e7824ULL, 0x040fe200078e021eULL, 0x0000000637357812ULL, 0x000fe200078ef635ULL,
0x00001f433e1b7589ULL, 0x000fe200000e0000ULL, 0x000000011a1f7824ULL, 0x000fe200078e021fULL,
0x000000313e317221ULL, 0x000fe20000010000ULL, 0x000000011a327824ULL, 0x000fe200078e0232ULL,
0x0000000018377984ULL, 0x000e620000000800ULL, 0x0000001036367824ULL, 0x000fc400078e0219ULL,
0x0000001038387824ULL, 0x100fe200078e0219ULL, 0x000000001c1c7984ULL, 0x000ea20000000800ULL,
0x000000011a367824ULL, 0x040fe400078e0236ULL, 0x000000011a387824ULL, 0x000fe200078e0238ULL,
0x000000001d1d7984ULL, 0x000ee20000000800ULL, 0x0000001039397824ULL, 0x100fe400078e0219ULL,
0x000000103a3a7824ULL, 0x000fe200078e0219ULL, 0x000000001e1e7984ULL, 0x000f220000000800ULL,
0x000000011a397824ULL, 0x000fc400078e0239ULL, 0x000000011a3a7824ULL, 0x000fe200078e023aULL,
0x000000001f1f7984ULL, 0x000f620000000800ULL, 0x000000103b3b7824ULL, 0x100fe400078e0219ULL,
0x000000103c3c7824ULL, 0x000fe200078e0219ULL, 0x0000000032327984ULL, 0x000ea20000000800ULL,
0x000000011a3b7824ULL, 0x040fe400078e023bULL, 0x000000011a3c7824ULL, 0x000fe200078e023cULL,
0x0000000036367984ULL, 0x000ea20000000800ULL, 0x0000001035357824ULL, 0x000fc400078e0219ULL,
0x000000011a3d7824ULL, 0x040fe200078e023dULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x000000011a357824ULL, 0x000fc600078e0235ULL, 0x00001f443e3e7589ULL, 0x000ea800000e0000ULL,
0x0000000039397984ULL, 0x000ea20000000800ULL, 0x00005410ff187816ULL, 0x002fc60000000037ULL,
0x000000003a3a7984ULL, 0x000e640000000800ULL, 0x0000001b18307223ULL, 0x080fe20000010030ULL,
0x00007610ff187816ULL, 0x000fe20000000037ULL, 0x000000003b3b7984ULL, 0x000e680000000800ULL,
0x0000001b182f7223ULL, 0x080fe2000001002fULL, 0x00005410ff187816ULL, 0x100fe2000000003fULL,
0x000000003c3c7984ULL, 0x000e680000000800ULL, 0x0000001b18227223ULL, 0x080fe20000010022ULL,
0x00007610ff187816ULL, 0x000fe2000000003fULL, 0x0000000035357984ULL, 0x000e680000000800ULL,
0x0000001b18217223ULL, 0x080fe20000010021ULL, 0x00005410ff187816ULL, 0x000fe20000000034ULL,
0x000000003d3d7984ULL, 0x000e680000000800ULL, 0x0000001b182e7223ULL, 0x000fe2000001002eULL,
0x00007610ff187816ULL, 0x000fca0000000034ULL, 0x0000001b182d7223ULL, 0x000fe2000001002dULL,
0x00005410ff187816ULL, 0x004fca000000001cULL, 0x0000001b182c7223ULL, 0x000fe2000001002cULL,
0x00007610ff187816ULL, 0x000fca000000001cULL, 0x0000001b182b7223ULL, 0x000fe2000001002bULL,
0x00005410ff187816ULL, 0x008fca000000001dULL, 0x0000001b182a7223ULL, 0x000fe2000001002aULL,
0x00007610ff187816ULL, 0x000fca000000001dULL, 0x0000001b18297223ULL, 0x000fe20000010029ULL,
0x00005410ff187816ULL, 0x010fca000000001eULL, 0x0000001b18287223ULL, 0x000fe20000010028ULL,
0x00007610ff187816ULL, 0x000fca000000001eULL, 0x0000001b18277223ULL, 0x000fe20000010027ULL,
0x00005410ff187816ULL, 0x020fca000000001fULL, 0x0000001b18267223ULL, 0x000fe20000010026ULL,
0x00007610ff187816ULL, 0x000fca000000001fULL, 0x0000001b18257223ULL, 0x000fe20000010025ULL,
0x00005410ff187816ULL, 0x000fca0000000032ULL, 0x0000001b18247223ULL, 0x000fe20000010024ULL,
0x00007610ff187816ULL, 0x000fe20000000032ULL, 0x000000ffff327224ULL, 0x000fc800078e0033ULL,
0x0000001b18237223ULL, 0x000fe20000010023ULL, 0x00005410ff187816ULL, 0x000fe40000000036ULL,
0x0000030032007a0cULL, 0x000fc60003f06070ULL, 0x0000003e18167223ULL, 0x000fe20000010016ULL,
0x00007610ff187816ULL, 0x000fca0000000036ULL, 0x0000003e18157223ULL, 0x000fe20000010015ULL,
0x00005410ff187816ULL, 0x000fca0000000038ULL, 0x0000003e18147223ULL, 0x000fe20000010014ULL,
0x00007610ff187816ULL, 0x000fca0000000038ULL, 0x0000003e18137223ULL, 0x000fe20000010013ULL,
0x00005410ff187816ULL, 0x000fca0000000039ULL, 0x0000003e18127223ULL, 0x000fe20000010012ULL,
0x00007610ff187816ULL, 0x000fca0000000039ULL, 0x0000003e18117223ULL, 0x000fe20000010011ULL,
0x00005410ff187816ULL, 0x002fca000000003aULL, 0x0000003e18107223ULL, 0x000fe20000010010ULL,
0x00007610ff187816ULL, 0x000fca000000003aULL, 0x0000003e180f7223ULL, 0x000fe2000001000fULL,
0x00005410ff187816ULL, 0x000fca000000003bULL, 0x0000003e180e7223ULL, 0x000fe2000001000eULL,
0x00007610ff187816ULL, 0x000fca000000003bULL, 0x0000003e180d7223ULL, 0x000fe2000001000dULL,
0x00005410ff187816ULL, 0x000fca000000003cULL, 0x0000003e180c7223ULL, 0x000fe2000001000cULL,
0x00007610ff187816ULL, 0x000fca000000003cULL, 0x0000003e180b7223ULL, 0x000fe2000001000bULL,
0x00005410ff187816ULL, 0x000fca0000000035ULL, 0x0000003e180a7223ULL, 0x000fe2000001000aULL,
0x00007610ff187816ULL, 0x000fca0000000035ULL, 0x0000003e18097223ULL, 0x000fe20000010009ULL,
0x00005410ff187816ULL, 0x000fca000000003dULL, 0x0000003e18087223ULL, 0x000fe20000010008ULL,
0x00007610ff187816ULL, 0x000fca000000003dULL, 0x0000003e18077223ULL, 0x000fe20000010007ULL,
0xfffff33000008947ULL, 0x000fea000383ffffULL, 0x0180000031007810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000000007812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0001801000047802ULL, 0x000fe40000000f00ULL,
0x00007a3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003100047308ULL, 0x000e640000001000ULL,
0xbf80000004317423ULL, 0x002fc80000000031ULL, 0x800000ff31317221ULL, 0x000fc80000010100ULL,
0x0000003104047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff177819ULL, 0x004fe20000011600ULL, 0x00000004001e7824ULL, 0x040fe200078e00ffULL,
0x00000008001d7811ULL, 0x000fe400078ff0ffULL, 0x00000017ff067212ULL, 0x000fe200078e33ffULL,
0x00001f1704057589ULL, 0x000ea200000e0000ULL, 0x00000008171f7824ULL, 0x000fe200078e00ffULL,
0x000000071d1b7812ULL, 0x040fe200078ec0ffULL, 0x000000081d187824ULL, 0x000fe200078e00ffULL,
0x00001f1d04047589ULL, 0x000ee200000e0000ULL, 0x0000001dff1c7212ULL, 0x000fc400078e33ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL, 0x0000000817067824ULL, 0x000fe200078e00ffULL,
0x0000000c1e1e7812ULL, 0x000fe400078ec0ffULL, 0xfffffff8181c7812ULL, 0x000fe400078ee21cULL,
0xfffffff806067812ULL, 0x000fe400078ee217ULL, 0x000000031b187812ULL, 0x040fe200078e3cffULL,
0x000000101c1c7824ULL, 0x100fe200078e0203ULL, 0x000000041b197812ULL, 0x040fe200078e3cffULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x000000051b1a7812ULL, 0x000fe200078e3cffULL,
0x000000081d187824ULL, 0x000fc400078e0218ULL, 0x000000011e067824ULL, 0x000fe200078e0206ULL,
0x0000003005307220ULL, 0x044fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x0000001604167220ULL, 0x048fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001304137220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000000f040f7220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000c040c7220ULL, 0x040fe20000410000ULL, 0x0000000b040b7220ULL, 0x040fe20000410000ULL,
0x0000000a040a7220ULL, 0x040fe20000410000ULL, 0x0000000904097220ULL, 0x040fe20000410000ULL,
0x0000000804087220ULL, 0x040fe20000410000ULL, 0x0000000704047220ULL, 0x000fe20000410000ULL,
0x0000000717077812ULL, 0x000fe200078ec0ffULL, 0x0000002c052c7220ULL, 0x000fe20000410000ULL,
0x0000000a0909723eULL, 0x000fe200000010ffULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x000000080404723eULL, 0x000fe200000010ffULL, 0x0000002a052a7220ULL, 0x000fe20000410000ULL,
0x0000000107087812ULL, 0x000fe200078e3cffULL, 0x0000002905297220ULL, 0x000fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x0000002805287220ULL, 0x000fe20000410000ULL,
0x00000002070a7812ULL, 0x000fe200078e3cffULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000000e0d0d723eULL, 0x000fe200000010ffULL, 0x0000002605267220ULL, 0x000fe20000410000ULL,
0x00000003070c7812ULL, 0x000fe200078e3cffULL, 0x0000002505257220ULL, 0x000fe20000410000ULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000002405247220ULL, 0x000fe20000410000ULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x0000002305237220ULL, 0x000fe20000410000ULL,
0x00000004070e7812ULL, 0x000fe200078e3cffULL, 0x0000002205227220ULL, 0x000fe20000410000ULL,
0x0000000507107812ULL, 0x000fe200078e3cffULL, 0x0000002105057220ULL, 0x000fe20000410000ULL,
0x0000000607127812ULL, 0x000fe200078e3cffULL, 0x0000000817077824ULL, 0x000fe200078e0208ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000000817087824ULL, 0x000fe200078e020aULL,
0x000000302f2f723eULL, 0x000fe200000010ffULL, 0x00000008170a7824ULL, 0x000fe200078e020cULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x00000008170c7824ULL, 0x000fe200078e020eULL,
0x0000002e2d2d723eULL, 0x000fe200000010ffULL, 0x000000081d147824ULL, 0x000fe200078e00ffULL,
0x0000002c2b2b723eULL, 0x000fe200000010ffULL, 0x00000008170e7824ULL, 0x000fe200078e0210ULL,
0x0000002a2929723eULL, 0x000fe200000010ffULL, 0x0000000817107824ULL, 0x000fe200078e0212ULL,
0x000000011b127812ULL, 0x000fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0203ULL,
0x000000021b177812ULL, 0x040fe200078e3cffULL, 0x0000001008087824ULL, 0x000fe200078e0203ULL,
0xfffffff814147812ULL, 0x000fe200078ee21dULL, 0x000000100a0a7824ULL, 0x100fe200078e0203ULL,
0x000000061b1b7812ULL, 0x000fe200078e3cffULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x000000081d167824ULL, 0x000fe200078e0212ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0203ULL,
0x0000002f06007388ULL, 0x0005e20000000800ULL, 0x000000011e077824ULL, 0x000fe200078e0207ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x000000081d177824ULL, 0x000fe200078e0217ULL,
0x000000220505723eULL, 0x000fe200000010ffULL, 0x0000001010107824ULL, 0x000fe200078e0203ULL,
0x0000002d07007388ULL, 0x0005e20000000800ULL, 0x000000011e087824ULL, 0x000fc400078e0208ULL,
0x000000101f127824ULL, 0x000fe400078e0203ULL, 0x000000011e0a7824ULL, 0x000fe200078e020aULL,
0x0000002b08007388ULL, 0x0005e20000000800ULL, 0x000000081d197824ULL, 0x040fe400078e0219ULL,
0x0000001014147824ULL, 0x000fe200078e0203ULL, 0x000000290a007388ULL, 0x0005e20000000800ULL,
0x000000011e0c7824ULL, 0x000fe400078e020cULL, 0x000000081d1a7824ULL, 0x000fc400078e021aULL,
0x0000001016167824ULL, 0x000fe200078e0203ULL, 0x000000270c007388ULL, 0x0005e20000000800ULL,
0x000000011e0e7824ULL, 0x040fe400078e020eULL, 0x000000081d1b7824ULL, 0x000fe400078e021bULL,
0x0000001017177824ULL, 0x100fe200078e0203ULL, 0x000000250e007388ULL, 0x0005e20000000800ULL,
0x000000011e107824ULL, 0x000fe400078e0210ULL, 0x0000001018187824ULL, 0x000fc400078e0203ULL,
0x000000011e127824ULL, 0x040fe200078e0212ULL, 0x0000002310007388ULL, 0x0005e20000000800ULL,
0x0000001019197824ULL, 0x100fe400078e0203ULL, 0x000000011e147824ULL, 0x000fe200078e0214ULL,
0x0000000512007388ULL, 0x0005e20000000800ULL, 0x000000101a1a7824ULL, 0x100fe400078e0203ULL,
0x000000011e167824ULL, 0x000fe200078e0216ULL, 0x0000001514007388ULL, 0x0005e20000000800ULL,
0x000000101b1b7824ULL, 0x000fc400078e0203ULL, 0x000000011e177824ULL, 0x040fe200078e0217ULL,
0x0000001316007388ULL, 0x0005e20000000800ULL, 0x000000011e187824ULL, 0x040fe400078e0218ULL,
0x000000011e197824ULL, 0x040fe200078e0219ULL, 0x0000001117007388ULL, 0x0005e20000000800ULL,
0x000000011e1a7824ULL, 0x040fe400078e021aULL, 0x000000011e1b7824ULL, 0x040fe200078e021bULL,
0x0000000f18007388ULL, 0x0005e20000000800ULL, 0x000000011e1c7824ULL, 0x000fc600078e021cULL,
0x0000000d19007388ULL, 0x0005e80000000800ULL, 0x0000000b1a007388ULL, 0x0005e80000000800ULL,
0x000000091b007388ULL, 0x0005e80000000800ULL, 0x000000041c007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000002000117810ULL, 0x004fe20007ffe0ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x00000003ff037819ULL, 0x100fe20000011600ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff057819ULL, 0x100fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000703047812ULL, 0x000fe200078e4800ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000705067812ULL, 0x000fc400078e4811ULL,
0x0ffffff804047812ULL, 0x000fe400078ef800ULL, 0x0ffffff806067812ULL, 0x000fe400078ef811ULL,
0x0000000700107812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x100fe400078e0202ULL,
0x0000001006067824ULL, 0x000fc600078e0202ULL, 0x00a0000004087984ULL, 0x000f280000000c00ULL,
0x00a00000060c7984ULL, 0x0023620000000c00ULL, 0x0000000807027824ULL, 0x044fe400078e00ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff802037812ULL, 0x000fc400078ee203ULL, 0xfffffff807057812ULL, 0x000fe400078ee205ULL,
0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000711067812ULL, 0x002fe200078ec0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x000fe200078048ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005a0005047a11ULL, 0x000fc400078248ffULL, 0x00005b0003037a11ULL, 0x000fe400000f4c00ULL,
0x1ffffff810007812ULL, 0x000fe400078ef845ULL, 0x00005b0005057a11ULL, 0x000fe400008f4c07ULL,
0x1ffffff806067812ULL, 0x000fe200078ef845ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x0000001006047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff347819ULL, 0x000fe20000011642ULL, 0xffffffffff357424ULL, 0x000fc800078e00ffULL,
0x0000000240347824ULL, 0x000fca00078e0234ULL, 0x000000033400720cULL, 0x000fda0003f06070ULL,
0x000000023a048824ULL, 0x000fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0234ULL,
0x0000600004048625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604358981ULL, 0x0002a2000c1e1900ULL, 0x0000000140007810ULL, 0x000fc80007ffe0ffULL,
0x000000020000720cULL, 0x000fe20003f06070ULL, 0x0000004042367824ULL, 0x000fe400078e00ffULL,
0x00006800ff047624ULL, 0x002fe400078e00ffULL, 0x00006900ff057624ULL, 0x000fe400078e00ffULL,
0x0000008043437824ULL, 0x000fe400078e00ffULL, 0x0000010040077824ULL, 0x000fe200078e0236ULL,
0x0000000604397981ULL, 0x000362000c1e9900ULL, 0x0000008037377824ULL, 0x000fc600078e00ffULL,
0x0000004043177812ULL, 0x000fe200078ef807ULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000003735187224ULL, 0x004fe200078e02ffULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fe40000011644ULL, 0x0000000741007217ULL, 0x000fe40007800000ULL,
0x0000001014197810ULL, 0x040fe20007ffe0ffULL, 0x0000000114067824ULL, 0x040fe200078e0217ULL,
0x0000000814157810ULL, 0x000fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a07ULL,
0x00000018141a7810ULL, 0x000fc40007ffe0ffULL, 0x00000006180f7210ULL, 0x000fe20007f1e0ffULL,
0x0000000115067824ULL, 0x100fe200078e0217ULL, 0x000000300b167812ULL, 0x000fe200078ec0ffULL,
0x000000011a087824ULL, 0x000fe200078e0217ULL, 0x00000003ff0c7819ULL, 0x000fe20000011644ULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00005e000f097a11ULL, 0x040fe400078040ffULL,
0x0000000818087210ULL, 0x040fe40007f5e0ffULL, 0x00005f000f0f7a11ULL, 0x000fe200000f4407ULL,
0x0000000119077824ULL, 0x000fe200078e0217ULL, 0x0000000618067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x00005e0008107a11ULL, 0x000fc400078440ffULL,
0x0000000718077210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e00060e7a11ULL, 0x000fe400078040ffULL, 0x000000030c0c7812ULL, 0x000fe200078e4844ULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00005e00070a7a11ULL, 0x040fe400078240ffULL,
0x00005f0006137a11ULL, 0x000fe400000f4413ULL, 0x00005f0007127a11ULL, 0x000fc400008f4412ULL,
0x000000001500720cULL, 0x0c0fe20003f26070ULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x0000000916067210ULL, 0x000fe40007f7e0ffULL, 0x000000001400720cULL, 0x000fe40003f06070ULL,
0x00005f0008117a11ULL, 0x000fe200010f4411ULL, 0x000000ffff077224ULL, 0x000fe200018e060fULL,
0x00002000420d7811ULL, 0x000fe400078e68ffULL, 0x0ffffffc0c447812ULL, 0x000fc400078ef844ULL,
0xfffffffc15097812ULL, 0x000fe400078ee20cULL, 0x000000160e087210ULL, 0x000fe20007f7e0ffULL,
0x0000001044447824ULL, 0x100fe200078e020dULL, 0x000000001900720cULL, 0x000fe20003f46070ULL,
0x00000010090e7824ULL, 0x000fe200078e020dULL, 0x000000160a0a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200018e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006447faeULL, 0x0003e2000c101c46ULL, 0x0000000419197824ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e0612ULL, 0x00000000080e7faeULL, 0x0005e2000c901c46ULL,
0x000000001a00720cULL, 0x000fc40003f86070ULL, 0xfffffffc190f7812ULL, 0x000fca00078ee20cULL,
0x000000100f0f7824ULL, 0x000fe200078e020dULL, 0x0000002014097810ULL, 0x004fe20007ffe0ffULL,
0x000000041a087824ULL, 0x000fc600078e00ffULL, 0x000000000a0f7faeULL, 0x0005e2000d101c46ULL,
0x000000000900720cULL, 0x000fe20003f66070ULL, 0x0000000117067824ULL, 0x002fe200078e0209ULL,
0xfffffffc08087812ULL, 0x000fc800078ee20cULL, 0x0000000618157210ULL, 0x000fe20007f1e0ffULL,
0x0000001008087824ULL, 0x000fe200078e020dULL, 0x0000001610067210ULL, 0x000fe40007fbe0ffULL,
0x00000028140a7810ULL, 0x044fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00000030140b7810ULL, 0x040fe40007ffe0ffULL, 0x00000038140f7810ULL, 0x000fe40007ffe0ffULL,
0x00005e0015147a11ULL, 0x000fe200078c40ffULL, 0x00000001170e7824ULL, 0x040fe200078e020bULL,
0x000000000a00720cULL, 0x080fe20003f46070ULL, 0x0000000117107824ULL, 0x000fe200078e020fULL,
0x00005f0015157a11ULL, 0x000fe200030f4407ULL, 0x000000ffff077224ULL, 0x000fe200028e0611ULL,
0x000000000b00720cULL, 0x000fc40003f26070ULL, 0x000000000f00720cULL, 0x000fe20003f06070ULL,
0x0000000117007824ULL, 0x000fe200078e020aULL, 0x0000000006087faeULL, 0x0003e2000e101c46ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000e18127210ULL, 0x040fe40007f9e0ffULL,
0x0000000018137210ULL, 0x040fe20007fbe0ffULL, 0x0000000409007824ULL, 0x000fe200078e00ffULL,
0x0000001018117210ULL, 0x000fc60007fde0ffULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0xfffffffc00007812ULL, 0x100fe200078ee20cULL, 0x000000040a067824ULL, 0x002fe200078e00ffULL,
0x00005e0013087a11ULL, 0x000fe200078a40ffULL, 0x000000040b077824ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee20cULL,
0x0000001000007824ULL, 0x000fe200078e020dULL, 0xfffffffc07077812ULL, 0x000fe400078ee20cULL,
0x00005f0013097a11ULL, 0x000fe200028f4409ULL, 0x00000010060e7824ULL, 0x000fe200078e020dULL,
0x0000001614067210ULL, 0x000fc40007fbe0ffULL, 0xfffffffc0f0c7812ULL, 0x000fe200078ee20cULL,
0x00000010070f7824ULL, 0x000fe200078e020dULL, 0x00005e00120a7a11ULL, 0x000fe200078840ffULL,
0x000000ffff077224ULL, 0x000fe200028e0615ULL, 0x0000001608087210ULL, 0x080fe20007fbe0ffULL,
0x000000100c107824ULL, 0x000fe200078e020dULL, 0x00005f00120b7a11ULL, 0x000fe200020f440bULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x00005e00110c7a11ULL, 0x040fe200078c40ffULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x000000160a0a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000006007faeULL, 0x0003e2000d901c46ULL, 0x00005f00110d7a11ULL, 0x000fc400030f440dULL,
0x000000160c0c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e060bULL,
0x00000000080e7faeULL, 0x0003e6000d101c46ULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0x000000000a0f7faeULL, 0x0003e8000c901c46ULL, 0x000000000c107faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000001744007211ULL, 0x042fe400078ff0ffULL,
0x0000001044067811ULL, 0x000fc400078ff0ffULL, 0x0000000018007210ULL, 0x000fe40007f1e0ffULL,
0x0000000844147811ULL, 0x040fe200078ff0ffULL, 0x0000000117077824ULL, 0x040fe200078e0206ULL,
0x0000001844087811ULL, 0x000fe200078ff0ffULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x00005e0000227a11ULL, 0x000fe200078040ffULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x00000020440a7811ULL, 0x000fe200078ff0ffULL, 0x0000000117097824ULL, 0x040fe200078e0208ULL,
0x00005f0000237a11ULL, 0x000fe200000f4423ULL, 0x0000000114007824ULL, 0x000fe200078e0217ULL,
0x00000003ff137819ULL, 0x000fe20000011644ULL, 0x00000001170c7824ULL, 0x000fe200078e020aULL,
0x00000007181f7210ULL, 0x000fe20007fbe0ffULL, 0x0000000408077824ULL, 0x000fe200078e00ffULL,
0x00000028440d7811ULL, 0x000fe200078ff0ffULL, 0x000000040a087824ULL, 0x000fe200078e00ffULL,
0x0000000018217210ULL, 0x000fe20007fde0ffULL, 0x0000000414007824ULL, 0x000fe200078e00ffULL,
0x0000000313137812ULL, 0x000fe200078e4844ULL, 0x00000001170e7824ULL, 0x000fe200078e020dULL,
0x00000030440f7811ULL, 0x000fc400078ff0ffULL, 0x0000003844117811ULL, 0x000fe400078ff0ffULL,
0x00000009181e7210ULL, 0x000fe20007f1e0ffULL, 0x000000040d097824ULL, 0x000fe200078e00ffULL,
0x0000200042197811ULL, 0x000fe200078e68ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0xfffffffc06067812ULL, 0x100fe200078ee213ULL, 0x000000040f0a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc07077812ULL, 0x000fe200078ee213ULL, 0x0000000117107824ULL, 0x040fe200078e020fULL,
0x0000000c181c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000117127824ULL, 0x000fe200078e0211ULL,
0x00005e0021207a11ULL, 0x000fe200078c40ffULL, 0x00000004110c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc08087812ULL, 0x000fe200078ee213ULL, 0x00000010060f7824ULL, 0x000fe200078e0219ULL,
0x00005f0021217a11ULL, 0x000fe200030f440dULL, 0x0000001007117824ULL, 0x000fe200078e0219ULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee213ULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e001e1d7a11ULL, 0x000fe200078040ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e001c0d7a11ULL, 0x000fe200078240ffULL, 0x0000001008167824ULL, 0x000fe200078e0219ULL,
0x000000300b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fe200028e06ffULL,
0x0000000e180e7210ULL, 0x000fc40007f5e0ffULL, 0xfffffffc09097812ULL, 0x000fe400078ee213ULL,
0x0000001018107210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e06ffULL,
0x0000001218127210ULL, 0x000fe20007f9e0ffULL, 0x000000100a187824ULL, 0x000fe200078e0219ULL,
0x00005f001e1e7a11ULL, 0x000fe200000f4407ULL, 0x0000001009177824ULL, 0x000fe200078e0219ULL,
0x00005f001c1c7a11ULL, 0x000fe200008f4406ULL, 0x000000ffff1a7224ULL, 0x000fe200018e06ffULL,
0x000000220b067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x00005e001f0a7a11ULL, 0x000fc400078a40ffULL, 0x0ffffffc13447812ULL, 0x000fe200078ef844ULL,
0x000000ffff077224ULL, 0x000fe200000e0623ULL, 0xfffffffc00007812ULL, 0x100fe400078ee213ULL,
0xfffffffc0c0c7812ULL, 0x000fe200078ee213ULL, 0x0000001044447824ULL, 0x100fe200078e0219ULL,
0x00005e000e097a11ULL, 0x000fe200078240ffULL, 0x0000001000007824ULL, 0x100fe200078e0219ULL,
0x00005e0010137a11ULL, 0x000fe200078440ffULL, 0x000000100c197824ULL, 0x000fe200078e0219ULL,
0x00005f001f1f7a11ULL, 0x000fe200028f4408ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006447faeULL, 0x0003e2000b901c46ULL, 0x000000200b087210ULL, 0x000fc40007f1e0ffULL,
0x00005e0012147a11ULL, 0x000fe400078640ffULL, 0x00005f000e1b7a11ULL, 0x000fe400008f441bULL,
0x00005f00101a7a11ULL, 0x000fe400010f441aULL, 0x0000000a0b0a7210ULL, 0x040fe40007f3e0ffULL,
0x0000001d0b0c7210ULL, 0x040fe40007f5e0ffULL, 0x000000090b107210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0621ULL, 0x00005f0012157a11ULL, 0x000fc400018f4415ULL,
0x0000000d0b0e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e061eULL,
0x000000130b127210ULL, 0x040fe20007fbe0ffULL, 0x0000000008007faeULL, 0x0003e2000b901c46ULL,
0x000000140b147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe400008e061fULL,
0x000000ffff137224ULL, 0x000fe400028e061aULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x000000000a0f7faeULL, 0x0005e8000b901c46ULL, 0x000000000c117faeULL, 0x0007e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x004fc400018e061cULL, 0x000000ffff117224ULL, 0x008fc600020e061bULL,
0x000000000e167faeULL, 0x0003e8000b901c46ULL, 0x0000000010177faeULL, 0x0003e8000b901c46ULL,
0x0000000012187faeULL, 0x0003e8000b901c46ULL, 0x0000000014197faeULL, 0x0003e4000b901c46ULL,
0x01060400ff007984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x002fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000002042007824ULL, 0x002fc800078e0200ULL, 0x0000002000057824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x000001e005057812ULL, 0x000fe400078ec0ffULL, 0x0000000104077812ULL, 0x040fe400078efcffULL,
0x0000000704067812ULL, 0x140fe400078e7800ULL, 0x0000000707077812ULL, 0x000fe400078e7800ULL,
0x0000001004107810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x040fe200078e0206ULL,
0x0000001104047810ULL, 0x000fe20007ffe0ffULL, 0x0000000105077824ULL, 0x000fe200078e0207ULL,
0x0000000710107812ULL, 0x000fc400078e7800ULL, 0x00000000060c7984ULL, 0x000e62000000cc00ULL,
0x0000000704047812ULL, 0x000fe400078e7800ULL, 0x0000000105107824ULL, 0x040fe200078e0210ULL,
0x0000000007087984ULL, 0x000ea4000000cc00ULL, 0x0000000105047824ULL, 0x000fe400078e0204ULL,
0x000000ffff147224ULL, 0x002fe400078e000cULL, 0x000000ffff157224ULL, 0x000fc400078e000eULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fe200078e000fULL,
0x0000001406007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fca00078e000bULL, 0x0000001807007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x004fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001c10007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff047f8cULL, 0x002fe8000c80043fULL, 0x01060400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000024000720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000387919ULL, 0x000e620000000000ULL,
0x3d80000039397820ULL, 0x020fe20000410000ULL, 0x000064003a3a7a24ULL, 0x000fe200078e02ffULL,
0x00010688423b7811ULL, 0x000fe200078e18ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0xffffffff023c7810ULL, 0x000fe40007ffe0ffULL, 0x00010608423d7811ULL, 0x000fe400078e28ffULL,
0x00000100403f7824ULL, 0x000fe200078e0236ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003f4100720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff457224ULL, 0x000fe200078e003eULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x0000000146247810ULL, 0x000fe20007ffe0ffULL, 0x00000d9000007945ULL, 0x000fe20003800000ULL,
0x00000001453e7812ULL, 0x000fe200078e0cffULL, 0x0000003735337224ULL, 0x020fe200078e02ffULL,
0x00000002ff007819ULL, 0x000fc40000011624ULL, 0x000000042400780cULL, 0x040fe40003f06070ULL,
0x0000000324557812ULL, 0x000fe200078ec0ffULL, 0x0000030000257a24ULL, 0x000fe400078e0240ULL,
0x000000ffff007224ULL, 0x000fe400078e0046ULL, 0x0000010025447824ULL, 0x040fe200078e0236ULL,
0x0000000125267810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff467224ULL, 0x000fc600078e0024ULL,
0x000000022600720cULL, 0x000fe40003f26070ULL, 0x0000004044257812ULL, 0x000fca00078ec0ffULL,
0x00000001432e7824ULL, 0x000fcc00078e0225ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff2f7819ULL, 0x002fe20000011638ULL, 0x0000000242487824ULL, 0x000fe200078e023eULL,
0x0000004441257217ULL, 0x000fe40007800000ULL, 0x000000102f4f7810ULL, 0x040fe20007ffe0ffULL,
0x000000012f247824ULL, 0x040fe200078e022eULL, 0x000000082f477810ULL, 0x000fe20007ffe0ffULL,
0x0000000125447824ULL, 0x000fe200078e0a44ULL, 0x000000182f507810ULL, 0x000fe20007ffe0ffULL,
0x000000014f277824ULL, 0x100fe200078e022eULL, 0x00000024332c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000147267824ULL, 0x000fe200078e022eULL, 0x000000202f517810ULL, 0x000fe20007ffe0ffULL,
0x00000004474a7824ULL, 0x000fe200078e00ffULL, 0x0000002733297210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e06ffULL, 0x00000026332b7210ULL, 0x000fc40007f5e0ffULL,
0x00005e002c247a11ULL, 0x000fe200078240ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078640ffULL, 0x000000ffff277224ULL, 0x000fe200010e06ffULL,
0x00005e002b267a11ULL, 0x000fe400078440ffULL, 0x00005f0029297a11ULL, 0x000fe200018f442aULL,
0x00000001502a7824ULL, 0x000fe200078e022eULL, 0x000000282f527810ULL, 0x040fe40007ffe0ffULL,
0x000000302f537810ULL, 0x000fc40007ffe0ffULL, 0x000000382f547810ULL, 0x000fe40007ffe0ffULL,
0x00005f002c257a11ULL, 0x000fe200008f442dULL, 0x00000001522c7824ULL, 0x100fe200078e022eULL,
0x00005f002b277a11ULL, 0x000fe200010f4427ULL, 0x00000001512b7824ULL, 0x100fe200078e022eULL,
0x0000002a33327210ULL, 0x000fe20007f3e0ffULL, 0x00000001532d7824ULL, 0x100fe200078e022eULL,
0x000000442f00720cULL, 0x000fe20003f46070ULL, 0x00000001542e7824ULL, 0x000fe200078e022eULL,
0x0000002b33307210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200008e06ffULL,
0x0000002c332f7210ULL, 0x000fc40007fde0ffULL, 0x00000003ff2c7819ULL, 0x100fe40000011638ULL,
0x00005e00322a7a11ULL, 0x000fe200078240ffULL, 0x000000ffff4d7224ULL, 0x000fe200030e06ffULL,
0x0000002d33317210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200028e06ffULL,
0x0000002e33337210ULL, 0x000fe20007f7e0ffULL, 0x00000004552e7824ULL, 0x000fe200078e00ffULL,
0x000000032c4e7812ULL, 0x000fe200078e4838ULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005f00322b7a11ULL, 0x000fe200008f442bULL, 0x000000ffff4b7224ULL, 0x000fe200018e06ffULL,
0x000000444700720cULL, 0x000fc40003f26070ULL, 0x0000200048487811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4e497812ULL, 0x100fe400078ef838ULL, 0xfffffffc2e477812ULL, 0x000fe400078ee238ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e0248ULL,
0x00005e00302c7a11ULL, 0x000fe200078a40ffULL, 0x0000001047247825ULL, 0x000fe200078e0024ULL,
0x00005e0033327a11ULL, 0x000fc400078840ffULL, 0x00005f00302d7a11ULL, 0x000fe200028f442dULL,
0x000000104a4a7824ULL, 0x000fe200078e0248ULL, 0x00005e002f2e7a11ULL, 0x000fe200078a40ffULL,
0x0000001047267825ULL, 0x000fe200078e0026ULL, 0x00005e0031307a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024497faeULL, 0x0003e2000d101c46ULL,
0x00005f002f2f7a11ULL, 0x000fe400028f444dULL, 0x00005f0031317a11ULL, 0x000fe200018f444cULL,
0x00000000264a7faeULL, 0x0005e2000c901c46ULL, 0x00005f0033337a11ULL, 0x000fe200020f444bULL,
0x00000004524b7824ULL, 0x000fe200078e00ffULL, 0x000000444f00720cULL, 0x080fe20003f26070ULL,
0x00000004534c7824ULL, 0x000fe200078e00ffULL, 0x000000445000720cULL, 0x000fc40003f46070ULL,
0x000000445100720cULL, 0x080fe20003f66070ULL, 0x0000000450497824ULL, 0x002fe200078e00ffULL,
0x000000445200720cULL, 0x080fe20003f86070ULL, 0x0000001047247825ULL, 0x000fe200078e0028ULL,
0x000000445300720cULL, 0x080fe40003fa6070ULL, 0x000000445400720cULL, 0x040fe20003fc6070ULL,
0x000000044f447824ULL, 0x000fe200078e00ffULL, 0xfffffffc49497812ULL, 0x100fe200078ee24eULL,
0x00000004514a7824ULL, 0x004fe200078e00ffULL, 0xfffffffc4b4b7812ULL, 0x100fe200078ee24eULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL,
0x0000001047267825ULL, 0x000fe200078e002aULL, 0xfffffffc4c4c7812ULL, 0x000fc400078ee24eULL,
0xfffffffc544e7812ULL, 0x000fe200078ee24eULL, 0x0000001044447824ULL, 0x100fe400078e0248ULL,
0x000000104a4a7824ULL, 0x000fe400078e0248ULL, 0x0000001047287825ULL, 0x000fe200078e002cULL,
0x0000000024447faeULL, 0x0003e6000c901c46ULL, 0x000000104b4b7824ULL, 0x000fe200078e0248ULL,
0x0000000026497faeULL, 0x0003e2000d101c46ULL, 0x00000010472a7825ULL, 0x000fc600078e002eULL,
0x00000000284a7faeULL, 0x0003e2000d901c46ULL, 0x000000104c4c7824ULL, 0x000fe400078e0248ULL,
0x00000010472c7825ULL, 0x040fe200078e0030ULL, 0x000000002a4b7faeULL, 0x0003e6000e101c46ULL,
0x000000104e487824ULL, 0x000fe200078e0248ULL, 0x000000002c4c7faeULL, 0x0003e2000e901c46ULL,
0x00000010472e7825ULL, 0x000fca00078e0032ULL, 0x000000002e487faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x00000008382a7811ULL, 0x042fe200078ff0ffULL,
0x0000000455517824ULL, 0x000fe200078e00ffULL, 0x0000002e38247211ULL, 0x040fe400078ff0ffULL,
0x00000010382b7811ULL, 0x000fe200078ff0ffULL, 0x000000012a257824ULL, 0x040fe200078e022eULL,
0x0000002433297210ULL, 0x000fe20007f3e0ffULL, 0x000000042a447824ULL, 0x000fe200078e00ffULL,
0x00000018382c7811ULL, 0x000fe200078ff0ffULL, 0x000000042b477824ULL, 0x000fe200078e00ffULL,
0x0000002533277210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0x00005e0029247a11ULL, 0x000fe200078240ffULL, 0x000000042c487824ULL, 0x000fe200078e00ffULL,
0x0000002838307811ULL, 0x000fe200078ff0ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e0027267a11ULL, 0x000fc400078440ffULL, 0x00005f0029257a11ULL, 0x000fe200008f4425ULL,
0x00000004304a7824ULL, 0x000fe200078e00ffULL, 0x00005f0027277a11ULL, 0x000fe200010f4428ULL,
0x0000000242287824ULL, 0x000fe200078e023eULL, 0x00000003ff297819ULL, 0x000fe40000011638ULL,
0x00000020382d7811ULL, 0x000fe400078ff0ffULL, 0x00002000284c7811ULL, 0x000fe200078e60ffULL,
0x000000012b287824ULL, 0x100fe200078e022eULL, 0x0000003038317811ULL, 0x000fe200078ff0ffULL,
0x00000001302b7824ULL, 0x100fe200078e022eULL, 0x0000003838327811ULL, 0x000fe200078ff0ffULL,
0x000000012d2a7824ULL, 0x000fe200078e022eULL, 0x00000003292f7812ULL, 0x000fe200078e4838ULL,
0x000000012c297824ULL, 0x100fe200078e022eULL, 0x0000002833307210ULL, 0x000fe20007f7e0ffULL,
0x000000042d497824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x100fe200078ee22fULL,
0x00000004314b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc47477812ULL, 0x100fe200078ee22fULL,
0x00000004324d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc48487812ULL, 0x100fe200078ee22fULL,
0x00000001312c7824ULL, 0x100fe200078e022eULL, 0xfffffffc49497812ULL, 0x100fe200078ee22fULL,
0x00000001322d7824ULL, 0x000fe200078e022eULL, 0x00000029332e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff297224ULL, 0x000fe200018e06ffULL, 0xfffffffc4a4a7812ULL, 0x100fe200078ee22fULL,
0x0000001044447824ULL, 0x100fe200078e024cULL, 0xfffffffc4b4b7812ULL, 0x100fe200078ee22fULL,
0x0000001047477824ULL, 0x100fe200078e024cULL, 0xfffffffc4d4d7812ULL, 0x000fe200078ee22fULL,
0x0000001048487824ULL, 0x000fe200078e024cULL, 0x0ffffffc2f327812ULL, 0x000fe200078ef838ULL,
0x0000001049497824ULL, 0x100fe200078e024cULL, 0x0000002a33507210ULL, 0x040fe20007f3e0ffULL,
0x000000104a4a7824ULL, 0x000fe200078e024cULL, 0x0000002b332f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0xfffffffc51517812ULL, 0x000fe200078ee238ULL,
0x0000001032527824ULL, 0x100fe200078e024cULL, 0x0000002c33317210ULL, 0x000fe20007f9e0ffULL,
0x000000104b4b7824ULL, 0x000fe200078e024cULL, 0x00005e002e2a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff4f7224ULL, 0x000fe200018e06ffULL, 0x00005e0030287a11ULL, 0x000fe200078c40ffULL,
0x0000001051247825ULL, 0x000fe200078e0024ULL, 0x0000002d33337210ULL, 0x000fc40007fbe0ffULL,
0x00005f002e2b7a11ULL, 0x000fe200010f442bULL, 0x000000ffff2d7224ULL, 0x000fe200008e06ffULL,
0x00005e00502c7a11ULL, 0x000fe200078240ffULL, 0x000000104d4c7824ULL, 0x000fe200078e024cULL,
0x00005f0030297a11ULL, 0x000fe200030f4429ULL, 0x000000ffff4e7224ULL, 0x000fe200020e06ffULL,
0x00005e002f2e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff4d7224ULL, 0x000fe200028e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024527faeULL, 0x0003e2000b901c46ULL, 0x00005e0033327a11ULL, 0x000fc400078840ffULL,
0x00005f00502d7a11ULL, 0x000fe400008f442dULL, 0x00005f002f2f7a11ULL, 0x000fe400010f444fULL,
0x00005f0031317a11ULL, 0x000fe400018f444eULL, 0x00005f0033337a11ULL, 0x000fe200020f444dULL,
0x0000001051247825ULL, 0x002fc800078e0026ULL, 0x0000001051267825ULL, 0x040fe200078e0028ULL,
0x0000000024447faeULL, 0x0003e6000b901c46ULL, 0x0000001051287825ULL, 0x040fe200078e002aULL,
0x0000000026477faeULL, 0x0003e6000b901c46ULL, 0x00000010512a7825ULL, 0x040fe200078e002cULL,
0x0000000028487faeULL, 0x0003e6000b901c46ULL, 0x00000010512c7825ULL, 0x040fe200078e002eULL,
0x000000002a497faeULL, 0x0003e6000b901c46ULL, 0x00000010512e7825ULL, 0x040fe200078e0030ULL,
0x000000002c4a7faeULL, 0x0003e6000b901c46ULL, 0x0000001051307825ULL, 0x000fe200078e0032ULL,
0x000000002e4b7faeULL, 0x0003e8000b901c46ULL, 0x00000000304c7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000035500780cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x00000300ff247624ULL, 0x002fe400078e00ffULL, 0xffffffffff357424ULL, 0x000fe400078e00ffULL,
0x0000000224347824ULL, 0x000fca00078e0234ULL, 0x000000033400720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000023a247824ULL, 0x000fe400078e0234ULL,
0x00000004ff257424ULL, 0x000fc800078e00ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x0000000624357981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008004b7824ULL, 0x002fe400078e00ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff838007812ULL, 0x000fe200078ec0ffULL, 0x0000000242287824ULL, 0x000fe200078e0245ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014a2b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000700007812ULL, 0x000fe400078ef838ULL, 0x0000200028287811ULL, 0x000fc400078e60ffULL,
0x00000001ff247819ULL, 0x000fe40000011600ULL, 0x0000000738d07812ULL, 0x000fe400078ec0ffULL,
0x0000000324247812ULL, 0x000fe400078ec0ffULL, 0x00000008d0d07812ULL, 0x000fe400078ef838ULL,
0x0000004a24257212ULL, 0x040fe400078e3cffULL, 0x0000002b24247212ULL, 0x000fc600078e3cffULL,
0x0000000400257824ULL, 0x040fe400078e0225ULL, 0x0000000400247824ULL, 0x000fe200078e0224ULL,
0x0000002038007810ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x100fe400078e0228ULL,
0x0000001024247824ULL, 0x000fe200078e0228ULL, 0xfffffff800007812ULL, 0x000fe400078ec0ffULL,
0x000000002530783bULL, 0x000e640000000200ULL, 0x0000000700297812ULL, 0x000fc400078ef838ULL,
0x00000000242c783bULL, 0x000ea40000000200ULL, 0x00000001ff007819ULL, 0x000fc80000011629ULL,
0x00000003002a7812ULL, 0x000fc800078ec0ffULL, 0x0000004a2a007212ULL, 0x040fe400078e3cffULL,
0x0000002b2a2a7212ULL, 0x000fe400078e3cffULL, 0x000000024a4a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000429007824ULL, 0x040fe400078e0200ULL, 0x00000004292a7824ULL, 0x000fe400078e022aULL,
0x0000001000007824ULL, 0x100fe400078e0228ULL, 0x000000102a2a7824ULL, 0x000fc600078e0228ULL,
0x000000000024783bULL, 0x000ee80000000200ULL, 0x000000002a28783bULL, 0x000f220000000200ULL,
0x0000003000757306ULL, 0x002fe20000009400ULL, 0x00000018ffac7819ULL, 0x000fe20000011430ULL,
0x0001000030617824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe20000011431ULL,
0x0000010032b07824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011432ULL,
0x0001000033af7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe20000011461ULL,
0x0000003000b47306ULL, 0x000e620000005400ULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x0000010033ab7824ULL, 0x000fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x000100002c7c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011433ULL,
0x000100002d7f7824ULL, 0x040fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000003000607306ULL, 0x000522000000d400ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x000001002c817824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x000001002d837824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001142cULL,
0x000100002e777824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x000000b500b67306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x004fe200078e00ffULL,
0x000000b47500720bULL, 0x002fe20003f9d000ULL, 0x000001002e6e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x008fe20000011424ULL, 0x0001000024c97824ULL, 0x000fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fe20000011430ULL, 0x0001000031307824ULL, 0x000fe200078e00ffULL,
0x000000b500b77306ULL, 0x000e620000205400ULL, 0x00000018ff9a7819ULL, 0x000fc40000011425ULL,
0x00000018ffc97819ULL, 0x000fe400000114c9ULL, 0x00000018ffbd7819ULL, 0x000fe20000011430ULL,
0x0001000032307824ULL, 0x000fe200078e00ffULL, 0x0000000160604812ULL, 0x010fe200078efcffULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x00000018ff977819ULL, 0x000fe40000011426ULL,
0x00000018ffc37819ULL, 0x000fe40000011430ULL, 0x00000018ff887819ULL, 0x000fc40000011427ULL,
0x00000018ff5b7819ULL, 0x000fe2000001142eULL, 0x000000b800ba7306ULL, 0x000ea20000205400ULL,
0x000000b7b600720bULL, 0x002fe20003f5d000ULL, 0x0000010025b67824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00000018ff657819ULL, 0x000fe4000001142dULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x000000bd00be7306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x000fc40000011477ULL, 0x00000018ff517819ULL, 0x000fe4000001142fULL,
0x00000018ff6e7819ULL, 0x000fc6000001146eULL, 0x000000bd00bf7306ULL, 0x000e620000205400ULL,
0x000000bab900720bULL, 0x004fce0003f7d000ULL, 0x0000003100a87306ULL, 0x000ff00000009400ULL,
0x0000003100a57306ULL, 0x000ea20000005400ULL, 0x000000bfbe00720bULL, 0x002fce0003fbd000ULL,
0x00000031005f7306ULL, 0x0002f0000000d400ULL, 0x000000ac00bb7306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x002fe200078e00ffULL, 0x000000a5a800720bULL, 0x004fc40003f3d000ULL,
0x000000b500a57245ULL, 0x000fe4000020d400ULL, 0x00000018ffc07819ULL, 0x000fe40000011431ULL,
0x000000ac00bc7306ULL, 0x0002a20000205400ULL, 0x000000b800a87245ULL, 0x000fe4000020d400ULL,
0x00000001a5a52812ULL, 0x000fe400078efcffULL, 0x00000001a8a83812ULL, 0x000fe400078efcffULL,
0x000000015f5f1812ULL, 0x008fe200078efcffULL, 0x0000003200a67306ULL, 0x000fe20000009400ULL,
0x000000ac00ac7245ULL, 0x002fce000020d400ULL, 0x0000003200a77306ULL, 0x000e620000005400ULL,
0x000000bcbb00720bULL, 0x004fce0003fdd000ULL, 0x000000c000c17306ULL, 0x000fec0000209400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000c000c27306ULL, 0x000ea20000205400ULL,
0x000000a7a600720bULL, 0x002fe40003f5d000ULL, 0x000000bd00a67245ULL, 0x000fc8000020d400ULL,
0x00000001a6a65812ULL, 0x000fe200078efcffULL, 0x000000a400ae7306ULL, 0x000fe60000209400ULL,
0x0000005fa6a6723eULL, 0x000fca00000010ffULL, 0x000000a400ad7306ULL, 0x0002e20000205400ULL,
0x000000c2c100720bULL, 0x004fce0003f7d000ULL, 0x000000c300c47306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fce000020d400ULL, 0x000000c300c57306ULL, 0x000e620000205400ULL,
0x000000adae00720bULL, 0x008fe20003f9d000ULL, 0x0001000026ad7824ULL, 0x000fe400078e00ffULL,
0x0000010027ae7824ULL, 0x000fc600078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x0000003300a27306ULL, 0x000fe20000009400ULL, 0x00000018ffae7819ULL, 0x000fca00000114aeULL,
0x00000001a4a44812ULL, 0x000fe400078efcffULL, 0x0000003300a37306ULL, 0x000ea20000005400ULL,
0x000000c5c400720bULL, 0x002fce0003fbd000ULL, 0x0000002c009e7306ULL, 0x000ff00000009400ULL,
0x0000002c009f7306ULL, 0x000e620000005400ULL, 0x000000a3a200720bULL, 0x004fe40003fdd000ULL,
0x000000c000a27245ULL, 0x000fc8000020d400ULL, 0x00000001a2a23812ULL, 0x000fe200078efcffULL,
0x000000b000c67306ULL, 0x000ff00000209400ULL, 0x000000b000c77306ULL, 0x0004e20000205400ULL,
0x0000009f9e00720bULL, 0x002fe20003f3d000ULL, 0x00000100269f7824ULL, 0x000fe200078e00ffULL,
0x000000c3009e7245ULL, 0x000fc8000020d400ULL, 0x000000019e9e5812ULL, 0x000fe200078efcffULL,
0x0000009500a07306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x004fe4000020d400ULL,
0x00000018ff9f7819ULL, 0x000fca000001149fULL, 0x0000009500a17306ULL, 0x0002a20000205400ULL,
0x000000c7c600720bULL, 0x008fce0003f7d000ULL, 0x000000af00b37306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x002fca000020d400ULL, 0x00000001b0b03812ULL, 0x000fe400078efcffULL,
0x000000af00c87306ULL, 0x0002e20000205400ULL, 0x000000a1a000720bULL, 0x004fe20003f9d000ULL,
0x0001000027a07824ULL, 0x000fca00078e00ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x00000024008f7306ULL, 0x000fe20000009400ULL, 0x000000af00af7245ULL, 0x002fca000020d400ULL,
0x0000000195954812ULL, 0x000fe400078efcffULL, 0x0000002400947306ULL, 0x000e620000005400ULL,
0x000000c8b300720bULL, 0x008fce0003fbd000ULL, 0x0000002400577306ULL, 0x0005ec000000d400ULL,
0x00000001afaf5812ULL, 0x000fe400078efcffULL, 0x00000032005c7306ULL, 0x000722000000d400ULL,
0x0000010024247824ULL, 0x004fe200078e00ffULL, 0x000000948f00720bULL, 0x002fc40003fbd000ULL,
0x0000008900947245ULL, 0x000fe4000020d400ULL, 0x00000018ffcc7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x000fe200078e00ffULL, 0x0000008900967306ULL, 0x000fe20000209400ULL,
0x000000ad008f7245ULL, 0x000fe2000020d400ULL, 0x000001002f327824ULL, 0x008fe400078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe40000011424ULL, 0x0000004b38247211ULL, 0x000fc400078fe0ffULL,
0x0000008900937306ULL, 0x0002a20000205400ULL, 0x000000015c5c2812ULL, 0x010fe400078efcffULL,
0x0000000157575812ULL, 0x000fe400078efcffULL, 0x0000000224757810ULL, 0x040fe40007ffe0ffULL,
0x0000000724247812ULL, 0x000fe200078e78d0ULL, 0x000000ab00b27306ULL, 0x000fe20000209400ULL,
0x000000c900897245ULL, 0x002fe4000020d400ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x00000020d0247824ULL, 0x000fe200078e0224ULL, 0x0000000775757812ULL, 0x000fc400078e78d0ULL,
0x000000044b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ab00b17306ULL, 0x0002e20000205400ULL,
0x000000939600720bULL, 0x004fe20003f5d000ULL, 0x0000001024247824ULL, 0x000fe200078e00ffULL,
0x000000cc00937245ULL, 0x000fe2000020d400ULL, 0x00000020d0757824ULL, 0x000fc800078e0275ULL,
0x000000c900ca7306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x0000000194942812ULL, 0x000fe400078efcffULL, 0x000000c900cb7306ULL, 0x000e620000205400ULL,
0x000000b1b200720bULL, 0x008fce0003f7d000ULL, 0x00000025008e7306ULL, 0x000fec0000009400ULL,
0x00000001abab3812ULL, 0x000fe400078efcffULL, 0x00000025008a7306ULL, 0x000ea20000005400ULL,
0x000000cbca00720bULL, 0x002fe40003f9d000ULL, 0x000000ab94ab723eULL, 0x000fca00000010ffULL,
0x0000002500567306ULL, 0x000e6c000000d400ULL, 0x0000000189894812ULL, 0x000fe400078efcffULL,
0x000000cf00b47306ULL, 0x000fe20000209400ULL, 0x0000008a8e00720bULL, 0x004fe40003f9d000ULL,
0x000000cf008a7245ULL, 0x000fc4000020d400ULL, 0x000000b6008e7245ULL, 0x000fc6000020d400ULL,
0x000000cf00257306ULL, 0x000eac0000205400ULL, 0x0000000156564812ULL, 0x002fe400078efcffULL,
0x0000003300587306ULL, 0x0002f0000000d400ULL, 0x0000009d00aa7306ULL, 0x000fe20000209400ULL,
0x00000025b400720bULL, 0x004fe20003f5d000ULL, 0x000100002f337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000009d00a97306ULL, 0x0002a20000205400ULL,
0x0000000158586812ULL, 0x008fca00078efcffULL, 0x000000018a8a2812ULL, 0x000fe400078efcffULL,
0x000000cc00cd7306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fe4000020d400ULL,
0x000000568a56723eULL, 0x000fca00000010ffULL, 0x000000cc00ce7306ULL, 0x000e620000205400ULL,
0x000000a9aa00720bULL, 0x004fe40003fdd000ULL, 0x00000058afaa723eULL, 0x000fca00000010ffULL,
0x0000002600867306ULL, 0x000fec0000009400ULL, 0x000000019d9d6812ULL, 0x000fe400078efcffULL,
0x0000002600877306ULL, 0x000ea20000005400ULL, 0x000000cecd00720bULL, 0x002fce0003f7d000ULL,
0x0000002600507306ULL, 0x000e6c000000d400ULL, 0x0000000193933812ULL, 0x000fe400078efcffULL,
0x000000ad00a37306ULL, 0x000fe20000209400ULL, 0x000000878600720bULL, 0x004fe40003f7d000ULL,
0x00000018ff867819ULL, 0x000fc4000001142aULL, 0x000000939d93723eULL, 0x000fc600000010ffULL,
0x000000ad00267306ULL, 0x000eac0000205400ULL, 0x0000000150503812ULL, 0x002fe400078efcffULL,
0x000000b600b57306ULL, 0x000ff00000209400ULL, 0x000000b600a77306ULL, 0x000e620000205400ULL,
0x00000026a300720bULL, 0x004fce0003f5d000ULL, 0x0000009a009b7306ULL, 0x000fec0000209400ULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x0000009a009c7306ULL, 0x0004e20000205400ULL,
0x000000a7b500720bULL, 0x002fe40003fbd000ULL, 0x000000508f50723eULL, 0x000fca00000010ffULL,
0x00000027007a7306ULL, 0x000fe20000009400ULL, 0x0000009a009a7245ULL, 0x004fca000020d400ULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x00000027007b7306ULL, 0x000e620000005400ULL,
0x0000009c9b00720bULL, 0x008fce0003fdd000ULL, 0x00000027004f7306ULL, 0x000eac000000d400ULL,
0x000000019a9a6812ULL, 0x000fe400078efcffULL, 0x0000009f00277306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x002fe40003f5d000ULL, 0x0000009f007b7245ULL, 0x000fca000020d400ULL,
0x0000009f00967306ULL, 0x000e6c0000205400ULL, 0x000000014f4f2812ULL, 0x004fe400078efcffULL,
0x000000a000a17306ULL, 0x000ff00000209400ULL, 0x000000a000257306ULL, 0x0004e20000205400ULL,
0x000000962700720bULL, 0x002fce0003f9d000ULL, 0x000000ae00a77306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x004fca000020d400ULL, 0x000000017b7b4812ULL, 0x000fe400078efcffULL,
0x000000ae00267306ULL, 0x000e620000205400ULL, 0x00000025a100720bULL, 0x008fe40003fdd000ULL,
0x000000ae00a17245ULL, 0x000fca000020d400ULL, 0x0000002c004e7306ULL, 0x0004ec000000d400ULL,
0x00000001a0a06812ULL, 0x000fe400078efcffULL, 0x0000007c008d7306ULL, 0x000fe20000209400ULL,
0x00000026a700720bULL, 0x002fe40003f7d000ULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x00000018ff2c7819ULL, 0x004fc40000011428ULL, 0x000000a2a4a7723eULL, 0x000fe400000010ffULL,
0x0000007c00907306ULL, 0x0005220000205400ULL, 0x000000014e4e1812ULL, 0x008fe400078efcffULL,
0x0000004fa0a0723eULL, 0x000fc600000010ffULL, 0x00000001a1a13812ULL, 0x000fe400078efcffULL,
0x0000007f00807306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x004fce000020d400ULL,
0x0000007f00827306ULL, 0x0004e20000205400ULL, 0x000000908d00720bULL, 0x010fce0003f5d000ULL,
0x0000009700997306ULL, 0x000fe20000209400ULL, 0x0000007f007f7245ULL, 0x004fca000020d400ULL,
0x000000017c7c2812ULL, 0x000fe400078efcffULL, 0x0000009700987306ULL, 0x0005220000205400ULL,
0x000000828000720bULL, 0x008fe20003f3d000ULL, 0x0001000029807824ULL, 0x040fe200078e00ffULL,
0x000000a6241c723cULL, 0x002fe2000004181cULL, 0x0000010029827824ULL, 0x000fe200078e00ffULL,
0x0000004e7c4e723eULL, 0x000fe400000010ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000008800917306ULL, 0x000fe20000209400ULL, 0x0000009700977245ULL, 0x004fc4000020d400ULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x000000aa2414723cULL, 0x000fe40000041814ULL,
0x000000017f7f1812ULL, 0x000fe400078efcffULL, 0x0000008800927306ULL, 0x0002a20000205400ULL,
0x000000989900720bULL, 0x010fce0003fbd000ULL, 0x00000081008c7306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x002fca000020d400ULL, 0x0000000197975812ULL, 0x000fe400078efcffULL,
0x00000081008b7306ULL, 0x0002e20000205400ULL, 0x000000929100720bULL, 0x004fe40003fdd000ULL,
0x000000578992723eULL, 0x000fe400000010ffULL, 0x0000008e9a57723eULL, 0x000fc600000010ffULL,
0x0000006700687306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fe2000020d400ULL,
0x000000922410723cULL, 0x040fe80000041810ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x00000067006b7306ULL, 0x0002a20000205400ULL, 0x0000008b8c00720bULL, 0x008fe20003f7d000ULL,
0x000100002b8b7824ULL, 0x040fe200078e00ffULL, 0x000000a188a1723eULL, 0x000fe200000010ffULL,
0x000001002b8c7824ULL, 0x000fe200078e00ffULL, 0x00000056240c723cULL, 0x000fe4000004180cULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x0000005b006c7306ULL, 0x000fe20000209400ULL,
0x0000006700677245ULL, 0x002fc4000020d400ULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x000000a02404723cULL, 0x000fe20000041804ULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x0000005b006a7306ULL, 0x0002e20000205400ULL, 0x0000006b6800720bULL, 0x004fce0003f5d000ULL,
0x0000002d00747306ULL, 0x000fe20000009400ULL, 0x0000005b005b7245ULL, 0x002fca000020d400ULL,
0x0000000167672812ULL, 0x000fe400078efcffULL, 0x0000002d00767306ULL, 0x000e620000005400ULL,
0x0000006a6c00720bULL, 0x008fe40003f3d000ULL, 0x00000081674f723eULL, 0x000fca00000010ffULL,
0x0000002e00737306ULL, 0x000fec0000009400ULL, 0x000000015b5b1812ULL, 0x000fe400078efcffULL,
0x0000002e00727306ULL, 0x000ea20000005400ULL, 0x000000767400720bULL, 0x002fe20003f9d000ULL,
0x0001000028767824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fc8000001142bULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000002f00637306ULL, 0x000ff00000009400ULL,
0x0000002f00647306ULL, 0x000e620000005400ULL, 0x000000727300720bULL, 0x004fce0003fbd000ULL,
0x0000008300847306ULL, 0x000ff00000209400ULL, 0x0000008300857306ULL, 0x0004e20000205400ULL,
0x000000646300720bULL, 0x002fce0003fdd000ULL, 0x0000006500697306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x004fce000020d400ULL, 0x0000006500667306ULL, 0x0002a20000205400ULL,
0x000000858400720bULL, 0x008fe20003f7d000ULL, 0x000100002a847824ULL, 0x040fe400078e00ffULL,
0x000001002a857824ULL, 0x000fc600078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x0000003200617306ULL, 0x000fe20000209400ULL, 0x0000006500657245ULL, 0x002fe4000020d400ULL,
0x00000018ff857819ULL, 0x000fc60000011485ULL, 0x0000000183833812ULL, 0x000fe400078efcffULL,
0x0000003200627306ULL, 0x0002e20000205400ULL, 0x000000666900720bULL, 0x004fce0003f5d000ULL,
0x00000028005e7306ULL, 0x000fe20000009400ULL, 0x0000003200327245ULL, 0x002fca000020d400ULL,
0x0000000165652812ULL, 0x000fe400078efcffULL, 0x00000028005d7306ULL, 0x000fe20000005400ULL,
0x000000626100720bULL, 0x008fce0003f3d000ULL, 0x00000028004d7306ULL, 0x0003ec000000d400ULL,
0x0000000132321812ULL, 0x000fe400078efcffULL, 0x0000002e00007306ULL, 0x000ea2000000d400ULL,
0x0000010028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe40000011428ULL,
0x0000003300707306ULL, 0x000fe20000209400ULL, 0x00000060a528723eULL, 0x000fce00000010ffULL,
0x0000003300717306ULL, 0x0002e20000205400ULL, 0x0000000100005812ULL, 0x004fce00078efcffULL,
0x0000002d00447306ULL, 0x000522000000d400ULL, 0x0000003300337245ULL, 0x002fce000020d400ULL,
0x00000029005a7306ULL, 0x000fe20000009400ULL, 0x00000018ff2d7819ULL, 0x004fe40000011429ULL,
0x000000717000720bULL, 0x008fca0003fbd000ULL, 0x0000002900597306ULL, 0x000fe20000005400ULL,
0x0000000144444812ULL, 0x010fce00078efcffULL, 0x00000029004c7306ULL, 0x0003e2000000d400ULL,
0x0000000133335812ULL, 0x000fce00078efcffULL, 0x00000077007d7306ULL, 0x000fe20000209400ULL,
0x000000a8ac29723eULL, 0x002fce00000010ffULL, 0x00000077007e7306ULL, 0x0002a20000205400ULL,
0x000000282420723cULL, 0x000fee0000041820ULL, 0x00000051006d7306ULL, 0x000fe20000209400ULL,
0x0000005c9e28723eULL, 0x000fe400000010ffULL, 0x000000b09529723eULL, 0x000fc400000010ffULL,
0x0000007700777245ULL, 0x002fc6000020d400ULL, 0x00000051006f7306ULL, 0x000e620000205400ULL,
0x0000007e7d00720bULL, 0x004fe20003f7d000ULL, 0x000000282418723cULL, 0x000fec0000041818ULL,
0x0000006e00787306ULL, 0x000fe20000209400ULL, 0x0000001075287824ULL, 0x000fca00078e00ffULL,
0x0000000177773812ULL, 0x000fe400078efcffULL, 0x0000006e00797306ULL, 0x0004e20000205400ULL,
0x0000006f6d00720bULL, 0x002fe40003f9d000ULL, 0x0000005d5e00720bULL, 0x000fca0003f7d000ULL,
0x0000007600637306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x004fce000020d400ULL,
0x0000007600647306ULL, 0x0002a20000205400ULL, 0x000000797800720bULL, 0x008fe40003f5d000ULL,
0x000000014d4d3812ULL, 0x000fca00078efcffULL, 0x0000002a00537306ULL, 0x000fe20000009400ULL,
0x0000007600767245ULL, 0x002fca000020d400ULL, 0x000000016e6e2812ULL, 0x000fe400078efcffULL,
0x0000002a00527306ULL, 0x000e620000005400ULL, 0x000000646300720bULL, 0x004fe40003f3d000ULL,
0x000000595a00720bULL, 0x000fca0003f5d000ULL, 0x00000068006b7306ULL, 0x000fec0000209400ULL,
0x0000000176761812ULL, 0x000fe400078efcffULL, 0x0000006800667306ULL, 0x0004e20000205400ULL,
0x000000525300720bULL, 0x002fe40003fbd000ULL, 0x0000005100527245ULL, 0x000fc4000020d400ULL,
0x0000007b9751723eULL, 0x000fe400000010ffULL, 0x0000000152524812ULL, 0x000fe200078efcffULL,
0x0000002c00307306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x004fe4000020d400ULL,
0x000000014c4c2812ULL, 0x000fe200078efcffULL, 0x000000502408723cULL, 0x000fe20000041808ULL,
0x0000004d7676723eULL, 0x000fc600000010ffULL, 0x0000002c00317306ULL, 0x0002a20000205400ULL,
0x000000666b00720bULL, 0x008fe40003f9d000ULL, 0x000000007726723eULL, 0x000fe400000010ffULL,
0x000000447f24723eULL, 0x000fe400000010ffULL, 0x000000836525723eULL, 0x000fe200000010ffULL,
0x0000002a00487306ULL, 0x000ee2000000d400ULL, 0x0000002c002c7245ULL, 0x002fe4000020d400ULL,
0x0000006e5b27723eULL, 0x000fc600000010ffULL, 0x0000000168684812ULL, 0x000fe400078efcffULL,
0x0000002b00557306ULL, 0x000fe20000009400ULL, 0x000000313000720bULL, 0x004fce0003f3d000ULL,
0x0000002b00547306ULL, 0x000fe20000005400ULL, 0x0000000148485812ULL, 0x008fca00078efcffULL,
0x000000012c2c1812ULL, 0x000fe400078efcffULL, 0x0000002b00497306ULL, 0x0003e4000000d400ULL,
0x000000682c77723eULL, 0x000fcc00000010ffULL, 0x0000002f00477306ULL, 0x000ea2000000d400ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x0000002d002e7306ULL, 0x000ff00000209400ULL,
0x0000002d002f7306ULL, 0x0007220000205400ULL, 0x0000000147476812ULL, 0x004fc400078efcffULL,
0x000000545500720bULL, 0x000fca0003fdd000ULL, 0x00000082005d7306ULL, 0x000fe20000209400ULL,
0x0000002d002d7245ULL, 0x008fce000020d400ULL, 0x0000008200587306ULL, 0x0004e20000205400ULL,
0x0000002f2e00720bULL, 0x010fe40003f9d000ULL, 0x0000000149496812ULL, 0x000fca00078efcffULL,
0x0000008000607306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x004fe2000020d400ULL,
0x00000024281c723cULL, 0x042fe8000004181cULL, 0x000000012d2d4812ULL, 0x000fe400078efcffULL,
0x00000080005c7306ULL, 0x0002a20000205400ULL, 0x000000585d00720bULL, 0x008fe20003f3d000ULL,
0x0000004e2820723cULL, 0x000fe20000041820ULL, 0x000000473324723eULL, 0x000fc400000010ffULL,
0x000000325225723eULL, 0x000fc600000010ffULL, 0x0000008400597306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fe2000020d400ULL, 0x000000262818723cULL, 0x040fe80000041818ULL,
0x0000000182821812ULL, 0x000fe400078efcffULL, 0x0000008400537306ULL, 0x0002e20000205400ULL,
0x0000005c6000720bULL, 0x004fe20003f7d000ULL, 0x000000242814723cULL, 0x000fe20000041814ULL,
0x000000822d4d723eULL, 0x000fca00000010ffULL, 0x0000007400727306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x002fe2000020d400ULL, 0x000000762810723cULL, 0x000fe20000041810ULL,
0x0000008c00257245ULL, 0x000fc6000020d400ULL, 0x0000000180803812ULL, 0x000fe400078efcffULL,
0x0000007400737306ULL, 0x0002a20000205400ULL, 0x000000535900720bULL, 0x008fe40003f5d000ULL,
0x0000004c804c723eULL, 0x000fca00000010ffULL, 0x0000008600877306ULL, 0x000fe20000209400ULL,
0x0000007400747245ULL, 0x002fe2000020d400ULL, 0x0000004c280c723cULL, 0x000fe8000004180cULL,
0x0000000184842812ULL, 0x000fe400078efcffULL, 0x00000086007a7306ULL, 0x0002e20000205400ULL,
0x000000737200720bULL, 0x004fe40003f3d000ULL, 0x000000488484723eULL, 0x000fca00000010ffULL,
0x0000008500547306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x002fca000020d400ULL,
0x0000000174741812ULL, 0x000fe400078efcffULL, 0x0000008500557306ULL, 0x0002a20000205400ULL,
0x0000007a8700720bULL, 0x008fe40003f7d000ULL, 0x000000044a00780cULL, 0x000fca0003f25270ULL,
0x0000008b00307306ULL, 0x000fe20000209400ULL, 0x0000008500857245ULL, 0x002fca000020d400ULL,
0x0000000186863812ULL, 0x000fe400078efcffULL, 0x0000008b002e7306ULL, 0x0002e20000205400ULL,
0x000000555400720bULL, 0x004fce0003f9d000ULL, 0x0000008c002f7306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x0000008c00007306ULL, 0x000e620000205400ULL, 0x0000002e3000720bULL, 0x008fe40003f5d000ULL,
0x000000858685723eULL, 0x000fce00000010ffULL, 0x000000842808723cULL, 0x000fe80000041808ULL,
0x000000018b8b2812ULL, 0x000fe400078efcffULL, 0x000000002f00720bULL, 0x002fe40003fbd000ULL,
0x000000498b24723eULL, 0x000fd600000010ffULL, 0x0000000125255812ULL, 0x000fc800078efcffULL,
0x000000257425723eULL, 0x000fce00000010ffULL, 0x000000242804723cULL, 0x000fe20000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff457224ULL, 0x000fe200078e003eULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd22000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003b247f8cULL, 0x000fe2000c80043fULL, 0x0000002039207220ULL, 0x040fe20000410000ULL,
0x0000002139217220ULL, 0x040fe20000410000ULL, 0x0000001c391c7220ULL, 0x040fe20000410000ULL,
0x000004003b007984ULL, 0x000e620000000800ULL, 0x0000001d391d7220ULL, 0x040fe20000410000ULL,
0x0000002239227220ULL, 0x040fe20000410000ULL, 0x0000002339237220ULL, 0x040fe20000410000ULL,
0x0000001a39267220ULL, 0x040fe20000410000ULL, 0x0000001b39277220ULL, 0x040fe20000410000ULL,
0x0000001439147220ULL, 0x040fe20000410000ULL, 0x0000001539157220ULL, 0x040fe20000410000ULL,
0x0000001639287220ULL, 0x040fe20000410000ULL, 0x0000001739297220ULL, 0x040fe20000410000ULL,
0x0000001039167220ULL, 0x040fe20000410000ULL, 0x0000001139177220ULL, 0x040fe20000410000ULL,
0x00000012392a7220ULL, 0x040fe20000410000ULL, 0x00000013392b7220ULL, 0x040fe20000410000ULL,
0x0000000c391a7220ULL, 0x040fe20000410000ULL, 0x0000000d391b7220ULL, 0x040fe20000410000ULL,
0x0000001839187220ULL, 0x040fe20000410000ULL, 0x0000001939197220ULL, 0x040fe20000410000ULL,
0x0000000e392c7220ULL, 0x040fe20000410000ULL, 0x0000000f392d7220ULL, 0x040fe20000410000ULL,
0x0000000839087220ULL, 0x040fe20000410000ULL, 0x0000000939097220ULL, 0x040fe20000410000ULL,
0x0000000a392e7220ULL, 0x040fe20000410000ULL, 0x0000000b392f7220ULL, 0x040fe20000410000ULL,
0x0000000439047220ULL, 0x040fe20000410000ULL, 0x0000000539057220ULL, 0x040fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0020ULL, 0x0000001e391e7220ULL, 0x040fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0021ULL, 0x0000001f391f7220ULL, 0x040fe20000410000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e001cULL, 0x0000000639067220ULL, 0x040fe20000410000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e001dULL, 0x0000000739077220ULL, 0x000fe20000410000ULL,
0x000000ffff107224ULL, 0x000fc400078e0014ULL, 0x000000ffff117224ULL, 0x000fe400078e0015ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0022ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0023ULL,
0x8000000000ff7812ULL, 0x002fe20007804825ULL, 0x000000ffff207224ULL, 0x000fe400078e0026ULL,
0x000000ffff217224ULL, 0x000fe400078e0027ULL, 0x000000ffff127224ULL, 0x000fc400078e0016ULL,
0x000000ffff137224ULL, 0x000fe400078e0017ULL, 0x000000ffff147224ULL, 0x000fe400078e001aULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x000000ffff227224ULL, 0x000fe400078e0028ULL,
0x000000ffff237224ULL, 0x000fe400078e0029ULL, 0x000000ffff267224ULL, 0x000fc400078e002aULL,
0x000000ffff277224ULL, 0x000fe400078e002bULL, 0x000000ffff0e7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0019ULL, 0x000000ffff167224ULL, 0x000fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e0009ULL, 0x000000ffff1a7224ULL, 0x000fc400078e0004ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff287224ULL, 0x000fe400078e002cULL,
0x000000ffff297224ULL, 0x000fe400078e002dULL, 0x000000ffff2a7224ULL, 0x000fe400078e002eULL,
0x000000ffff2b7224ULL, 0x000fe200078e002fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fc400078e0006ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0007ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x000004003b047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000438197824ULL, 0x000fe200078e00ffULL,
0x0000003c4000720cULL, 0x000fc80003f05270ULL, 0xfffffff019187812ULL, 0x000fca00078ec0ffULL,
0x0000008042187824ULL, 0x000fca00078e0218ULL, 0x0104000018047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000238007824ULL, 0x000fe400078e00ffULL,
0x00000001413f7824ULL, 0x000fc600078e0a3fULL, 0x0000000600007812ULL, 0x000fc800078ec0ffULL,
0x0000000100087812ULL, 0x040fe400078efcffULL, 0x0000000800097812ULL, 0x000fe400078efcffULL,
0x0000003f0800720cULL, 0x080fe40003f26070ULL, 0x0000001000087812ULL, 0x000fe400078efcffULL,
0x0000003f0900720cULL, 0x080fe40003f06070ULL, 0x0000003f0800720cULL, 0x000fc40003fc6070ULL,
0x0000001100097812ULL, 0x040fe400078efcffULL, 0x0000001800087812ULL, 0x040fe400078efcffULL,
0x0000003f0000720cULL, 0x080fe40003f46070ULL, 0x0000003f0900720cULL, 0x080fe40003fa6070ULL,
0x0000003f0800720cULL, 0x000fe40003f66070ULL, 0x0000000900247812ULL, 0x000fc400078efcffULL,
0x0000001900097812ULL, 0x040fe400078efcffULL, 0x0000002000087812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40004800000ULL,
0x0000003f2400720cULL, 0x080fe40003f86070ULL, 0x0000003f0900720cULL, 0x080fe40003f46070ULL,
0x0000003f0800720cULL, 0x000fe40003f26070ULL, 0x0000002100097812ULL, 0x040fe400078efcffULL,
0x0000002800087812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000003f0900720cULL, 0x080fe40003f06070ULL,
0x0000003f0800720cULL, 0x000fe40003f86070ULL, 0x0000002900097812ULL, 0x000fc400078efcffULL,
0x0000003000087812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000003f0900720cULL, 0x000fc40003fc6070ULL,
0x0000003f0800720cULL, 0x000fe40003fa6070ULL, 0x0000003100097812ULL, 0x040fe400078efcffULL,
0x0000003800087812ULL, 0x040fe400078efcffULL, 0x0000003900007812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff26267808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000003f0900720cULL, 0x080fe40003f66070ULL, 0x0000003f0800720cULL, 0x000fc40003f46070ULL,
0x0000003f0000720cULL, 0x000fe40003f26070ULL, 0xff7fffff27277808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff28287808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff29297808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0x0000000a04047209ULL, 0x004fe20007810000ULL,
0x0000001fff2e7424ULL, 0x000fe200078e00ffULL, 0x0000001c05057209ULL, 0x000fe20007810000ULL,
0xffffffffff2f7424ULL, 0x000fe200078e00ffULL, 0x0000000b04047209ULL, 0x000fe40007810000ULL,
0x0000001d05057209ULL, 0x000fc40007810000ULL, 0x0000000c04047209ULL, 0x000fe40007810000ULL,
0x0000001e05057209ULL, 0x000fe40007810000ULL, 0x0000000d04047209ULL, 0x000fe40007810000ULL,
0x0000001f05057209ULL, 0x000fe40007810000ULL, 0x0000000e04047209ULL, 0x000fe40007810000ULL,
0x0000002005057209ULL, 0x000fc40007810000ULL, 0x0000000f04047209ULL, 0x000fe40007810000ULL,
0x0000002105057209ULL, 0x000fe40007810000ULL, 0x0000001004047209ULL, 0x000fe40007810000ULL,
0x0000002205057209ULL, 0x000fe40007810000ULL, 0x0000001104047209ULL, 0x000fe40007810000ULL,
0x0000002305057209ULL, 0x000fc40007810000ULL, 0x0000001204047209ULL, 0x000fe40007810000ULL,
0x0000002605057209ULL, 0x000fe40007810000ULL, 0x0000001304047209ULL, 0x000fe40007810000ULL,
0x0000002705057209ULL, 0x000fe40007810000ULL, 0x0000001404047209ULL, 0x000fe40007810000ULL,
0x0000002805057209ULL, 0x000fc40007810000ULL, 0x0000001504047209ULL, 0x000fe40007810000ULL,
0x0000002905057209ULL, 0x000fe40007810000ULL, 0x0000001604047209ULL, 0x000fe40007810000ULL,
0x0000002a05057209ULL, 0x000fe40007810000ULL, 0x0000001704047209ULL, 0x000fe40007810000ULL,
0x0000002b05057209ULL, 0x000fc40007810000ULL, 0x0000001a04047209ULL, 0x000fe40007810000ULL,
0x0000002c05057209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fe40007810000ULL,
0x0000002d05247209ULL, 0x000fe20007810000ULL, 0x00001af27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0004007f89ULL, 0x0004e400000e0000ULL, 0x0000000004257209ULL, 0x00cfe20007810000ULL,
0x00001b127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0024007f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007057f89ULL, 0x000f2200000e0000ULL,
0x0000000024007209ULL, 0x004fc40007810000ULL, 0x0000000406067209ULL, 0x008fc60007810000ULL,
0x0c201f0000087f89ULL, 0x000ea200000e0000ULL, 0x0000000507077209ULL, 0x010fc60007810000ULL,
0x0c201f0025047f89ULL, 0x000ee800000e0000ULL, 0x0c201f0006097f89ULL, 0x000f2800000e0000ULL,
0x0c201f0007247f89ULL, 0x00026200000e0000ULL, 0x0000000800057209ULL, 0x004fe40007810000ULL,
0x0000000425047209ULL, 0x008fc40007810000ULL, 0x0000000906067209ULL, 0x010fc60007810000ULL,
0x3fb8aa3b04007820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000724077209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010800ULL,
0x0000000a00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010800ULL,
0x0000000c000a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b1b007823ULL, 0x000fc80000010800ULL, 0x0000000e000c7308ULL, 0x000ff00000000800ULL,
0x00000010000e7308ULL, 0x000ff00000000800ULL, 0x0000001200107308ULL, 0x000ff00000000800ULL,
0x0000001400127308ULL, 0x000ff00000000800ULL, 0x0000001600147308ULL, 0x000ff00000000800ULL,
0x0000001a00167308ULL, 0x0003f00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b051a7820ULL, 0x002fc80000410000ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081aULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001081aULL,
0x000000080b08723eULL, 0x004fe200000010ffULL, 0x0000001c00097308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2d1a7823ULL, 0x000fc4000001081aULL,
0x0000001d001d7308ULL, 0x000ee20000000800ULL, 0x00000004ff1c7e24ULL, 0x004fe2000f8e00ffULL,
0x0000000a0d0a723eULL, 0x002fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x3f8000001c1c783eULL, 0x000fe400000010ffULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x000000091d09723eULL, 0x008fe200000010ffULL, 0x000000ffff1d7224ULL, 0x000fcc00078e001cULL,
0x0000000f000f7308ULL, 0x000ea20000000800ULL, 0x0000001e1f0b723eULL, 0x002fce00000010ffULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x0000000fff1f7424ULL, 0x000fe200078e00ffULL,
0x0000001c0830723cULL, 0x000fe200000418ffULL, 0x0000000c0f0c723eULL, 0x004fca00000010ffULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x0000000e110e723eULL, 0x002fce00000010ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x00000020210d723eULL, 0x004fce00000010ffULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x00000022230f723eULL, 0x002fce00000010ffULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x0000001c0c30723cULL, 0x000fe20000041830ULL,
0x000000101310723eULL, 0x004fcc00000010ffULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x000000121512723eULL, 0x002fe400000010ffULL,
0xfffffffc38157812ULL, 0x000fc800078ec0ffULL, 0x000000151f1f7219ULL, 0x000fe200000006ffULL,
0x0000002800287308ULL, 0x000fe60000000800ULL, 0x000000001f1b73a1ULL, 0x000e6200000e8000ULL,
0x000000001f0473c4ULL, 0x000ee80000004000ULL, 0x0000002900297308ULL, 0x000f220000000800ULL,
0x000000262711723eULL, 0x004fce00000010ffULL, 0x0000001700177308ULL, 0x000ea20000000800ULL,
0x000000282913723eULL, 0x010fce00000010ffULL, 0x0000000000007308ULL, 0x000f220000000800ULL,
0x000000051fff7c12ULL, 0x002fe2000f80401bULL, 0x0000001c1030723cULL, 0x000fe20000041830ULL,
0x000000141714723eULL, 0x004fca00000010ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x000000160016723eULL, 0x010fce00000010ffULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x0000002a2b15723eULL, 0x002fe400000010ffULL, 0x0000002c1a17723eULL, 0x004fce00000010ffULL,
0x0000001c1430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000163204008947ULL, 0x008fde000b800000ULL, 0x001c1fff301c7589ULL, 0x0002a400000e0000ULL,
0x000000001f0073a1ULL, 0x000ee200000e8000ULL, 0x000000001f0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000051fff7c12ULL, 0x008fda000f804000ULL,
0x0000165204008947ULL, 0x010fea000b800000ULL, 0x001c1fff321d7589ULL, 0x00072800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL, 0x001c1fff1f1f7589ULL, 0x002e6400000e0000ULL,
0x00000002ff007819ULL, 0x000fe40000011638ULL, 0x0000000c192c7812ULL, 0x000fc400078ec0ffULL,
0x00000007001a7812ULL, 0x040fe200078ec0ffULL, 0x00000008001b7824ULL, 0x040fe200078e00ffULL,
0x00000000ff277212ULL, 0x000fe200078e33ffULL, 0x0000000800207824ULL, 0x000fe200078e00ffULL,
0x0000000338ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000800287824ULL, 0x040fe200078e00ffULL,
0x0000000800007810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81b1b7812ULL, 0x100fe400078ee21aULL,
0x0000000120217812ULL, 0x100fe200078ef61aULL, 0x0000000800307824ULL, 0x000fe200078e00ffULL,
0x0000000220227812ULL, 0x100fe200078ef61aULL, 0x0000000800297824ULL, 0x000fe200078e00ffULL,
0x0000000320237812ULL, 0x000fc400078ef61aULL, 0x0000000420247812ULL, 0x140fe400078ef61aULL,
0x0000000520257812ULL, 0x140fe400078ef61aULL, 0x0000000620267812ULL, 0x000fe200078ef61aULL,
0x0000000800207824ULL, 0x000fe200078e00ffULL, 0xfffffff828277812ULL, 0x000fe400078ee227ULL,
0x00000000ff287212ULL, 0x000fe400078e33ffULL, 0x00000007001a7812ULL, 0x000fc400078ec0ffULL,
0x0000a00042007811ULL, 0x000fe400078e58ffULL, 0xfffffff830307812ULL, 0x000fe400078ee228ULL,
0xfffffff829287812ULL, 0x000fe200078ee21aULL, 0x000000101b197824ULL, 0x000fe200078e0200ULL,
0x0000000120297812ULL, 0x000fe200078ef61aULL, 0x00000010221b7824ULL, 0x000fe200078e0200ULL,
0x00000002202a7812ULL, 0x100fe200078ef61aULL, 0x000000012c197824ULL, 0x000fe200078e0219ULL,
0x00000003202b7812ULL, 0x040fe200078ef61aULL, 0x0000001025227824ULL, 0x000fe200078e0200ULL,
0x00000004202d7812ULL, 0x100fe200078ef61aULL, 0x000000012c1b7824ULL, 0x000fe200078e021bULL,
0x00000005202e7812ULL, 0x000fe200078ef61aULL, 0x0000001028257824ULL, 0x000fe200078e0200ULL,
0x00000006202f7812ULL, 0x000fe200078ef61aULL, 0x00000010211a7824ULL, 0x100fe200078e0200ULL,
0x0000000819007388ULL, 0x0007e20000000800ULL, 0x0000001023207824ULL, 0x000fc400078e0200ULL,
0x0000001024217824ULL, 0x000fe400078e0200ULL, 0x000000012c1a7824ULL, 0x000fe400078e021aULL,
0x0000001026237824ULL, 0x100fe400078e0200ULL, 0x0000001027247824ULL, 0x000fe200078e0200ULL,
0x0000000a1a007388ULL, 0x0007e20000000800ULL, 0x000000012c207824ULL, 0x040fe400078e0220ULL,
0x000000012c217824ULL, 0x000fe200078e0221ULL, 0x0000000c1b007388ULL, 0x0007e20000000800ULL,
0x0000001029267824ULL, 0x000fc400078e0200ULL, 0x000000012c227824ULL, 0x000fe200078e0222ULL,
0x0000000e20007388ULL, 0x0007e20000000800ULL, 0x000000102a277824ULL, 0x100fe400078e0200ULL,
0x000000012c237824ULL, 0x040fe200078e0223ULL, 0x0000001021007388ULL, 0x0007e20000000800ULL,
0x000000102b287824ULL, 0x000fe400078e0200ULL, 0x000000012c247824ULL, 0x000fe200078e0224ULL,
0x0000001222007388ULL, 0x0007e20000000800ULL, 0x000000102d297824ULL, 0x000fc400078e0200ULL,
0x000000012c257824ULL, 0x000fe200078e0225ULL, 0x0000001423007388ULL, 0x0007e20000000800ULL,
0x000000102e2a7824ULL, 0x000fe400078e0200ULL, 0x000000012c267824ULL, 0x040fe200078e0226ULL,
0x0000001624007388ULL, 0x0007e20000000800ULL, 0x000000102f2b7824ULL, 0x100fe400078e0200ULL,
0x000000012c277824ULL, 0x000fe200078e0227ULL, 0x0000000925007388ULL, 0x0007e20000000800ULL,
0x0000001030007824ULL, 0x000fc400078e0200ULL, 0x000000012c287824ULL, 0x040fe200078e0228ULL,
0x0000000b26007388ULL, 0x0007e20000000800ULL, 0x000000012c297824ULL, 0x040fe400078e0229ULL,
0x000000012c2a7824ULL, 0x040fe200078e022aULL, 0x0000000d27007388ULL, 0x0007e20000000800ULL,
0x000000012c2b7824ULL, 0x040fe400078e022bULL, 0x000000012c007824ULL, 0x000fe200078e0200ULL,
0x0000000f28007388ULL, 0x0007e80000000800ULL, 0x0000001129007388ULL, 0x0007e80000000800ULL,
0x000000132a007388ULL, 0x0007e80000000800ULL, 0x000000152b007388ULL, 0x0007e80000000800ULL,
0x0000001700007388ULL, 0x0007e80000000800ULL, 0x0100000418008388ULL, 0x0007e80000000c00ULL,
0x0102001c18008388ULL, 0x0167e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003dff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003dff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003dff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030040407a10ULL, 0x000fe20007ffe0ffULL, 0x000018003dff7f8cULL, 0x0003e6000c80043fULL,
0x000000024000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb63000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x0001e9f000247802ULL, 0x000fe40000000f00ULL,
0x0000126000007944ULL, 0x012fea0003c00000ULL, 0xfffe2d4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x0001ea3000247802ULL, 0x000fe40000000f00ULL,
0x0000122000007944ULL, 0x012fea0003c00000ULL, 0xfffe2d8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x014fe200078e002dULL, 0x0001eaa000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0024ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fc400078e00ffULL, 0x0000116000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e002aULL, 0xfffe2da000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e0024ULL, 0x0001eb2000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff007224ULL, 0x000fc400078e002dULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x000010e000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xfffe2d5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e0050ULL, 0x0001eb9000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000107000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff757224ULL, 0x004fe200078e002aULL,
0xfffe30c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e004eULL,
0x0001ec0000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000100000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff747224ULL, 0x004fe200078e002aULL, 0xfffe308000007947ULL, 0x000fea000383ffffULL,
0x0000001fff297424ULL, 0x002fe200078e00ffULL, 0x0001ec6000317802ULL, 0x000fe20000000f00ULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000fa000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff397224ULL, 0x004fe200078e002aULL, 0xfffe56a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x004fe200078e004eULL, 0x0001ecd000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x002fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00000f3000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e002aULL,
0xfffe565000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x0001ed2000247802ULL, 0x000fc40000000f00ULL, 0x00000f3000007944ULL, 0x034fea0003c00000ULL,
0xfffe7cd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001ed6000247802ULL, 0x000fc40000000f00ULL, 0x00000ef000007944ULL, 0x034fea0003c00000ULL,
0xfffe7d1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e002aULL,
0x0001edd000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff007224ULL, 0x000fc400078e0025ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00000e3000007944ULL, 0x034fea0003c00000ULL, 0xfffe7d5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0x0001ee4000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e004eULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000dc000007944ULL, 0x032fea0003c00000ULL,
0xfffe7e0000007947ULL, 0x000fea000383ffffULL, 0x0000001fff297424ULL, 0x000fe200078e00ffULL,
0x0001ee9000317802ULL, 0x000fe20000000f00ULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x00000d7000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff687224ULL, 0x004fe200078e002aULL,
0xfffe806000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x008fe200078e004eULL,
0x0001ef0000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000d0000007944ULL, 0x036fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e002aULL, 0xfffe801000007947ULL, 0x000fea000383ffffULL,
0x0000001fff297424ULL, 0x000fe200078e00ffULL, 0x0001ef6000317802ULL, 0x000fe20000000f00ULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000ca000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff827224ULL, 0x004fe200078e002aULL, 0xfffea48000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e004eULL, 0x0001efd000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00000c3000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff817224ULL, 0x004fe200078e002aULL,
0xfffea43000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x0001f02000247802ULL, 0x000fc40000000f00ULL, 0x00000c3000007944ULL, 0x014fea0003c00000ULL,
0xfffec95000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001f06000247802ULL, 0x000fc40000000f00ULL, 0x00000bf000007944ULL, 0x014fea0003c00000ULL,
0xfffec99000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e002aULL,
0x0001f0d000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff007224ULL, 0x000fc400078e0025ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00000b3000007944ULL, 0x014fea0003c00000ULL, 0xfffec9d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0x0001f14000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e004eULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000ac000007944ULL, 0x012fea0003c00000ULL,
0xfffeca8000007947ULL, 0x000fea000383ffffULL, 0x0000001fff297424ULL, 0x000fe200078e00ffULL,
0x0001f19000317802ULL, 0x000fe20000000f00ULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x00000a7000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff7b7224ULL, 0x004fe200078e002aULL,
0xfffecce000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x008fe200078e004eULL,
0x0001f20000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000a0000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff7c7224ULL, 0x004fe200078e002aULL, 0xfffecc9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff297424ULL, 0x000fe200078e00ffULL, 0x0001f26000317802ULL, 0x000fe20000000f00ULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x000009a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff817224ULL, 0x004fe200078e002aULL, 0xfffef0e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e004eULL, 0x0001f2d000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000093000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff807224ULL, 0x004fe200078e002aULL,
0xfffef09000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x0001f32000247802ULL, 0x000fc40000000f00ULL, 0x0000093000007944ULL, 0x034fea0003c00000ULL,
0xffff169000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001f36000247802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x034fea0003c00000ULL,
0xffff16d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e002aULL,
0x0001f3d000317802ULL, 0x000fe20000000f00ULL, 0x000000ffff007224ULL, 0x000fc400078e0024ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000083000007944ULL, 0x034fea0003c00000ULL, 0xffff171000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0024ULL, 0x0001f44000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e004eULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x000007c000007944ULL, 0x032fea0003c00000ULL,
0xffff17c000007947ULL, 0x000fea000383ffffULL, 0x0000001fff297424ULL, 0x000fe200078e00ffULL,
0x0001f49000317802ULL, 0x000fe20000000f00ULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x0000077000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x004fe200078e002aULL,
0xffff1a2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x008fe200078e004eULL,
0x0001f50000317802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000070000007944ULL, 0x036fea0003c00000ULL,
0x000000ffff367224ULL, 0x004fe200078e002aULL, 0xffff19d000007947ULL, 0x000fea000383ffffULL,
0x0000001fff297424ULL, 0x000fe200078e00ffULL, 0x0001f56000317802ULL, 0x000fe20000000f00ULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x000006a000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff5d7224ULL, 0x004fe200078e002aULL, 0xffff3e6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x004fe200078e004eULL, 0x0001f5d000317802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000063000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff5f7224ULL, 0x004fe200078e002aULL,
0xffff3e1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff007224ULL, 0x000fe200078e0004ULL,
0x0001f63000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0xffffe4d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0024ULL, 0x0001f68000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fc400078e00ffULL, 0x0000053000007944ULL, 0x022fea0003c00000ULL,
0x0000000024057209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0006ULL,
0x0001f6d000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fc400078e00ffULL,
0x000004e000007944ULL, 0x000fea0003c00000ULL, 0x0000000006067209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0001f72000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000000007077209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0025ULL,
0x0001f77000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000000025047209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0005ULL, 0x0001f7c000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x000003f000007944ULL, 0x000fea0003c00000ULL,
0x0000000005057209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0006ULL,
0x0001f81000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x0000000006067209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0001f86000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0000ULL, 0xffffe38000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0030ULL, 0x0001f8e000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff287224ULL, 0x000fe400078e001fULL, 0x0000032000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e002aULL, 0xffffe96000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0032ULL, 0x0001f96000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff287224ULL, 0x000fe400078e001fULL, 0x000002a000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x0001f9c000317802ULL, 0x000fe20000000f00ULL,
0x00001c1fff297424ULL, 0x000fc400078e00ffULL, 0x000000ffff287224ULL, 0x000fe400078e001fULL,
0x000000ffff1d7224ULL, 0x004fe400078e002aULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e001fULL, 0x0001fa2000317802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e002aULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e002aULL, 0xffffe8a000007947ULL, 0x000fea000383ffffULL,
0x0180000031007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003100008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff31ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000031057812ULL, 0x000fd600078ec0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe045004007950ULL, 0x000fea0003c3ffffULL, 0x0000002f00007348ULL, 0x000fe80003800000ULL,
0x0c00000800007389ULL, 0x0002a400000e002eULL, 0x000000ffff087224ULL, 0x002fe400078e0009ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe040008007950ULL, 0x000fea0003c3ffffULL,
0x0000002800007348ULL, 0x000fe80003800000ULL, 0x0000002b002a7389ULL, 0x0002a400000e0029ULL,
0x000000ffff287224ULL, 0x002fe400078e0031ULL, 0x00000000ff297424ULL, 0x000fc800078e00ffULL,
0xfffe03b028007950ULL, 0x000fea0003c3ffffULL, 0x000000010000780cULL, 0x000fe20003f25070ULL,
0x00000000ff257424ULL, 0x000fe200078e00ffULL, 0x0000006200007348ULL, 0x000ff60003800000ULL,
0x0000000000007806ULL, 0x000fc800048e0100ULL, 0x0000006200007212ULL, 0x000fe200078ec0ffULL,
0xfffe035024007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000005a0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000b80ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c10ULL, 0x0000000000000b8cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000179cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000017c0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000017d0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000017f0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001888ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001898ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001a80ULL, 0x000000000001fd80ULL, 0xf000001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000021810ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000021c90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001880ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001ff80ULL, 0x000000000001ff80ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000021800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000021c90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 138608;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
