/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000021a10ULL, 0x0000000000021590ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001f8c0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001fa30ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000001fa70ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000001fab0ULL,
0x0000000000000150ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001fc00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001f8c000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x007cc80400288080ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8e082880808b0828ULL, 0x2880809008288080ULL, 0x8093082880809108ULL, 0x0828808095082880ULL,
0x8080980828808096ULL, 0xa208288080a10828ULL, 0x288080a308288080ULL, 0x80a508288080a408ULL,
0x08288080a6082880ULL, 0x8080a808288080a7ULL, 0xab08288080a90828ULL, 0x288080ac08288080ULL,
0x80b008288080ae08ULL, 0x08288080b1082880ULL, 0x8080ba08288080b3ULL, 0xc608288080c20828ULL,
0x2880809a08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880809aULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001f8c000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8e082880808b0828ULL,
0x2880809008288080ULL, 0x8093082880809108ULL, 0x0828808095082880ULL, 0x8080980828808096ULL,
0xa1082880809a0828ULL, 0x288080a208288080ULL, 0x80a408288080a308ULL, 0x08288080a5082880ULL,
0x8080a708288080a6ULL, 0xa908288080a80828ULL, 0x288080ab08288080ULL, 0x80ae08288080ac08ULL,
0x08288080b0082880ULL, 0x8080ba08288080b1ULL, 0xc608288080c20828ULL, 0x2880808c08288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880808cULL, 0x0000001cffffffffULL,
0x0000016800000000ULL, 0x0001fa3000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c082880808b0828ULL, 0x2880808e08288080ULL,
0x8091082880809008ULL, 0x0828808093082880ULL, 0x8080960828808095ULL, 0x9a08288080980828ULL,
0x288080a108288080ULL, 0x80a308288080a208ULL, 0x08288080a4082880ULL, 0x8080a608288080a5ULL,
0xa808288080a70828ULL, 0x288080a908288080ULL, 0x80ac08288080ab08ULL, 0x08288080ae082880ULL,
0x8080b108288080b0ULL, 0xc208288080ba0828ULL, 0x288080c608288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080c6ULL, 0x0000001cffffffffULL, 0x0000026000000000ULL,
0x0001fa7000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8c082880808b0828ULL, 0x2880808e08288080ULL, 0x8091082880809008ULL,
0x0828808093082880ULL, 0x8080960828808095ULL, 0x9a08288080980828ULL, 0x288080a108288080ULL,
0x80a308288080a208ULL, 0x08288080a4082880ULL, 0x8080a608288080a5ULL, 0xa808288080a70828ULL,
0x288080a908288080ULL, 0x80ac08288080ab08ULL, 0x08288080ae082880ULL, 0x8080ba08288080b0ULL,
0xc608288080c20828ULL, 0x288080b108288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x00002200288080b1ULL, 0x0000002cffffffffULL, 0x0000035800000000ULL, 0x0001fab000000000ULL,
0x0000015000000000ULL, 0x0000140400000000ULL, 0x80ac288080b10900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x00081204000000fdULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000eULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x0001de900001db90ULL,
0x0001e0100001dea0ULL, 0x0001e0300001e020ULL, 0xffffffff01c82904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500006dffffffffULL,
0x0500006d0500006dULL, 0xffffffff0500006dULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01c82804ffffffffULL,
0x00000110000000f0ULL, 0x000017b000001730ULL, 0x0000188000001850ULL, 0x00001c9000001c60ULL,
0x00001d7000001d00ULL, 0x0000433000004310ULL, 0x000043f000004390ULL, 0x00006a8000006a00ULL,
0x00006c5000006b30ULL, 0x00006f3000006f10ULL, 0x00006ff000006f90ULL, 0x0000942000009400ULL,
0x000094e000009480ULL, 0x0000ba000000b980ULL, 0x0000bbd00000bab0ULL, 0x0000beb00000be90ULL,
0x0000bf700000bf10ULL, 0x0000e3700000e350ULL, 0x0000e4300000e3d0ULL, 0x00010a30000109b0ULL,
0x00010c0000010ae0ULL, 0x00010ee000010ec0ULL, 0x00010fa000010f40ULL, 0x000133d0000133b0ULL,
0x0001349000013430ULL, 0x0001547000015460ULL, 0x0001774000015bf0ULL, 0x00017ee000017a20ULL,
0x0001875000017f10ULL, 0x0001d8e00001d8b0ULL, 0x0001d9000001d8f0ULL, 0x0001d9400001d920ULL,
0x0001d9700001d960ULL, 0x0001e0600001e000ULL, 0x0001e0800001e070ULL, 0x0001e8000001e7a0ULL,
0x0001e8c00001e860ULL, 0x0001e9900001e920ULL, 0x0001ea600001e9f0ULL, 0x0001eb200001eac0ULL,
0x0001ebe00001eb80ULL, 0x0001eca00001ec30ULL, 0x0001ed700001ed00ULL, 0x0001ee300001edd0ULL,
0x0001eef00001ee90ULL, 0x0001efb00001ef40ULL, 0x0001f0800001f010ULL, 0x0001f1400001f0e0ULL,
0x0001f2000001f1a0ULL, 0x0001f2c00001f250ULL, 0x0001f3900001f320ULL, 0x0001f4900001f410ULL,
0x0001f5700001f500ULL, 0x0001f6500001f5e0ULL, 0x0001f7300001f6c0ULL, 0x0001f8000001f790ULL,
0x0001f8a00001f850ULL, 0x0000023007003904ULL, 0x00010600000000ffULL, 0x00000270003f0100ULL,
0x000106080000000fULL, 0x000002b0003f0120ULL, 0x000106880000000fULL, 0x000003a0003f0120ULL,
0x000106a80000000fULL, 0x000003d0003f0120ULL, 0x000106b8000000ffULL, 0x00000500003f0100ULL,
0x00010600000000ffULL, 0x000006a0003f0107ULL, 0x0001068c00000009ULL, 0x00000750003f0102ULL,
0x0001068800000009ULL, 0x00000c80003f0101ULL, 0x000106a8000000ffULL, 0x00000d00003f0107ULL,
0x000106a8000000ffULL, 0x00000d60003f0101ULL, 0x000106b8000000ffULL, 0x00000ec0003f0101ULL,
0x000106bc000000ffULL, 0x00000f20003f0105ULL, 0x000106bc000000ffULL, 0x00000fa0003f0105ULL,
0x000106bc000000ffULL, 0x000014b0003f0105ULL, 0x000106b0000000ffULL, 0x00001530003f0107ULL,
0x000106b0000000ffULL, 0x00001540003f0101ULL, 0x000106ac000000ffULL, 0x000015b0003f0105ULL,
0x0001060800000009ULL, 0x000015d0003f0101ULL, 0x0001060c00000009ULL, 0x00001660003f0105ULL,
0x0001060c00000009ULL, 0x00001b40003f0105ULL, 0x000106ac000000ffULL, 0x00001bc0003f0105ULL,
0x000106ac000000ffULL, 0x00003c60003f0105ULL, 0x000106b8000000ffULL, 0x00003c70003f0101ULL,
0x000106bc000000ffULL, 0x00003cc0003f0105ULL, 0x000106bc000000ffULL, 0x00003d40003f0105ULL,
0x000106bc000000ffULL, 0x00004100003f0105ULL, 0x000106a8000000ffULL, 0x00004180003f0107ULL,
0x000106a8000000ffULL, 0x00004190003f0101ULL, 0x000106b4000000ffULL, 0x000041f0003f0105ULL,
0x000106b4000000ffULL, 0x00004270003f0105ULL, 0x000106b4000000ffULL, 0x00006200003f0105ULL,
0x000106b8000000ffULL, 0x00006270003f0101ULL, 0x00010688000000ffULL, 0x000062b0003f0101ULL,
0x000106bc000000ffULL, 0x00006300003f0105ULL, 0x000106bc000000ffULL, 0x00006380003f0105ULL,
0x000106bc000000ffULL, 0x000067c0003f0105ULL, 0x000106b0000000ffULL, 0x00006840003f0107ULL,
0x000106b0000000ffULL, 0x00006850003f0101ULL, 0x000106ac000000ffULL, 0x000068c0003f0105ULL,
0x0001062800000009ULL, 0x000068e0003f0101ULL, 0x0001062c00000009ULL, 0x00006970003f0105ULL,
0x0001062c00000009ULL, 0x00006e00003f0105ULL, 0x000106ac000000ffULL, 0x00006e80003f0105ULL,
0x000106ac000000ffULL, 0x00008d90003f0105ULL, 0x000106b8000000ffULL, 0x00008da0003f0101ULL,
0x000106bc000000ffULL, 0x00008df0003f0105ULL, 0x000106bc000000ffULL, 0x00008e70003f0105ULL,
0x000106bc000000ffULL, 0x00009200003f0105ULL, 0x000106a8000000ffULL, 0x00009280003f0107ULL,
0x000106a8000000ffULL, 0x00009290003f0101ULL, 0x000106b4000000ffULL, 0x000092f0003f0105ULL,
0x000106b4000000ffULL, 0x00009370003f0105ULL, 0x000106b4000000ffULL, 0x0000b260003f0105ULL,
0x000106b8000000ffULL, 0x0000b2d0003f0101ULL, 0x00010690000000ffULL, 0x0000b300003f0101ULL,
0x000106bc000000ffULL, 0x0000b350003f0105ULL, 0x000106bc000000ffULL, 0x0000b3d0003f0105ULL,
0x000106bc000000ffULL, 0x0000b740003f0105ULL, 0x000106b0000000ffULL, 0x0000b7c0003f0107ULL,
0x000106b0000000ffULL, 0x0000b7d0003f0101ULL, 0x000106ac000000ffULL, 0x0000b840003f0105ULL,
0x0001064800000009ULL, 0x0000b860003f0101ULL, 0x0001064c00000009ULL, 0x0000b8f0003f0105ULL,
0x0001064c00000009ULL, 0x0000bd80003f0105ULL, 0x000106ac000000ffULL, 0x0000be00003f0105ULL,
0x000106ac000000ffULL, 0x0000dd10003f0105ULL, 0x000106b8000000ffULL, 0x0000dd20003f0101ULL,
0x000106bc000000ffULL, 0x0000dd70003f0105ULL, 0x000106bc000000ffULL, 0x0000ddf0003f0105ULL,
0x000106bc000000ffULL, 0x0000e160003f0105ULL, 0x000106a8000000ffULL, 0x0000e1e0003f0107ULL,
0x000106a8000000ffULL, 0x0000e1f0003f0101ULL, 0x000106b4000000ffULL, 0x0000e240003f0105ULL,
0x000106b4000000ffULL, 0x0000e2c0003f0105ULL, 0x000106b4000000ffULL, 0x000101b0003f0105ULL,
0x000106b8000000ffULL, 0x00010220003f0101ULL, 0x00010698000000ffULL, 0x00010250003f0101ULL,
0x000106bc000000ffULL, 0x000102a0003f0105ULL, 0x000106bc000000ffULL, 0x00010320003f0105ULL,
0x000106bc000000ffULL, 0x00010770003f0105ULL, 0x000106b0000000ffULL, 0x000107f0003f0107ULL,
0x000106b0000000ffULL, 0x00010800003f0101ULL, 0x000106ac000000ffULL, 0x00010870003f0105ULL,
0x0001066800000009ULL, 0x00010890003f0101ULL, 0x0001066c00000009ULL, 0x00010920003f0105ULL,
0x0001066c00000009ULL, 0x00010db0003f0105ULL, 0x000106ac000000ffULL, 0x00010e30003f0105ULL,
0x000106ac000000ffULL, 0x00012d30003f0105ULL, 0x000106b8000000ffULL, 0x00012d40003f0101ULL,
0x000106bc000000ffULL, 0x00012d90003f0105ULL, 0x000106bc000000ffULL, 0x00012e10003f0105ULL,
0x000106bc000000ffULL, 0x000131c0003f0105ULL, 0x000106a8000000ffULL, 0x00013240003f0107ULL,
0x000106a8000000ffULL, 0x00013250003f0101ULL, 0x000106b4000000ffULL, 0x000132a0003f0105ULL,
0x000106b4000000ffULL, 0x00013320003f0105ULL, 0x000106b4000000ffULL, 0x00015210003f0105ULL,
0x000106b8000000ffULL, 0x00015270003f0101ULL, 0x000106a0000000ffULL, 0x00018aa0003f0101ULL,
0x00010600000000ffULL, 0x000198b0003f0101ULL, 0x00010604000000ffULL, 0x00019950003f0105ULL,
0x00010604000000ffULL, 0x00019c70003f0105ULL, 0x00010600000000ffULL, 0x00019c80003f0101ULL,
0x00010604000000ffULL, 0x00019d10003f0105ULL, 0x00010604000000ffULL, 0x0001cd90003f0105ULL,
0x000000000000003dULL, 0x0001cdc0003f0101ULL, 0x000000040000003dULL, 0x0001d1d0003f0105ULL,
0x000000040000003dULL, 0x0001e5f0003f0105ULL, 0x000000000000003fULL, 0x0001e650003f0101ULL,
0x000000080000003fULL, 0x0001e6b0003f0101ULL, 0x000000100000003fULL, 0x0001e720003f0101ULL,
0x000000180000003fULL, 0x00053803003f0101ULL, 0x000189a000101c04ULL, 0x00019e2000019d70ULL,
0x000004010001e760ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000043cULL, 0x0000001200000002ULL,
0x0000000000000344ULL, 0x0000001200000002ULL, 0x000000000000024cULL, 0x0000001200000002ULL,
0x0000000000000154ULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x0000000000000417ULL, 0x0000001200000002ULL, 0x000000000000031fULL, 0x0000001200000002ULL,
0x0000000000000227ULL, 0x0000001200000002ULL, 0x000000000000012fULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff3b7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001200077300ULL, 0x000fe200000e0000ULL, 0x000000083b057824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ee20000002200ULL, 0x00000200ff177424ULL, 0x000fc600078e00ffULL,
0x0000000000007919ULL, 0x000f220000002600ULL, 0x0000001200127309ULL, 0x000f660000000000ULL,
0x00000000000d7919ULL, 0x000f280000002700ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000005ff027819ULL, 0x002fc60000011606ULL, 0x00001fff04117589ULL, 0x0049e200000e0000ULL,
0x000000ffff127224ULL, 0x020fc600078e0a12ULL, 0x00001fff02027589ULL, 0x000e6200000e0000ULL,
0x0000000104037824ULL, 0x008fe400078e0203ULL, 0x0000000800047824ULL, 0x010fe400078e00ffULL,
0x00000080030f7824ULL, 0x000fe400078e0206ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000000d050a7224ULL, 0x000fe400078e0204ULL, 0x000000ff0f00720cULL, 0x000fc40003f25270ULL,
0x0000000f0f00780cULL, 0x000fe40003f44070ULL, 0x000000080700720cULL, 0x000fe40003f02070ULL,
0x000000030f00780cULL, 0x040fe40003f64070ULL, 0x0000007f0f00780cULL, 0x000fe20003f84070ULL,
0x0000000411067824ULL, 0x002fc800078e0202ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x00000002060b7824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x000000070b0e7812ULL, 0x040fe200078ec0ffULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x000000080b0c7817ULL, 0x000fe20007800000ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x010608060f00a388ULL, 0x0007e20000008a00ULL,
0x000000010f00780cULL, 0x000fe20003f44070ULL, 0xff317217ff10c424ULL, 0x000fe200078e00ffULL,
0x0000001f0e0e7812ULL, 0x004fe200078e7803ULL, 0x010688080f00b388ULL, 0x0005e20000008a00ULL,
0x000000010b137810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fc400078e0a0bULL,
0x000000010a047824ULL, 0x002fe200078e020bULL, 0x010400100f00c388ULL, 0x0003e20000004800ULL,
0x000000200b0e7824ULL, 0x000fe200078e020eULL, 0x000000ff0c00720cULL, 0x000fe20003f63070ULL,
0x000000010a067824ULL, 0x008fe200078e0213ULL, 0x000000010c00780cULL, 0x000fe20003f83070ULL,
0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL, 0x3fffff00ff08a424ULL, 0x004fe400078e00ffULL,
0x7fffff00ff09a424ULL, 0x000fe200078e00ffULL, 0x0000000713107812ULL, 0x002fe200078ec0ffULL,
0x7fffff80ff0b9424ULL, 0x000fc400078e00ffULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0106a8080f00a388ULL, 0x0003e20000008a00ULL, 0x00005c0004047625ULL, 0x080fe200078e0017ULL,
0x0000001f10107812ULL, 0x000fe400078e7803ULL, 0x0106b80aff009388ULL, 0x0005e20000000a00ULL,
0x000001f00c157812ULL, 0x000fe200078ec0ffULL, 0x00005c0006067625ULL, 0x000fe400078e0017ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001504047210ULL, 0x080fe20007fbe0ffULL,
0x0000002013107824ULL, 0x000fe200078e0210ULL, 0x0000001506067210ULL, 0x000fe20007f5e0ffULL,
0x000000100e137824ULL, 0x000fc400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400028e0605ULL,
0x000000ffff077224ULL, 0x000fe400010e0607ULL, 0x0000001010157824ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x002fe400078e0012ULL, 0x00000004ff0e7424ULL, 0x000fc800078e00ffULL,
0x000062000d087625ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004137faeULL, 0x0005e8000d901c46ULL, 0x0000000006157faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0106040fffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000608047981ULL, 0x004ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff1100720cULL, 0x000fe20003f05270ULL, 0x00000004ff057e24ULL, 0x002fe2000f8e00ffULL,
0x0000007f04067810ULL, 0x004fc40007ffe0ffULL, 0x000000ff04077810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff067819ULL, 0x000fe40000011606ULL, 0x00000008ff077819ULL, 0x000fca0000011607ULL,
0x000183a000008947ULL, 0x000fea0003800000ULL, 0x0000000205087824ULL, 0x000fe400078e00ffULL,
0x0000000802097824ULL, 0x000fe400078e00ffULL, 0x00000003ff107424ULL, 0x000fe200078e00ffULL,
0x000000060800720cULL, 0x000fda0003f06070ULL, 0x00006400080b8a10ULL, 0x000fe20007ffe0ffULL,
0x000000020d0a8824ULL, 0x000fc800078e00ffULL, 0x000064000a0b8a24ULL, 0x000fe400078e020bULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c1009ff738cULL, 0x0003e20000000000ULL, 0x000060000b0e8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060e0a8981ULL, 0x0004e2000c1e1900ULL,
0x00000004ff117819ULL, 0x000fe20000011603ULL, 0x00000100050b7824ULL, 0x040fe200078e00ffULL,
0x0000000105107810ULL, 0x002fe20007ffe0ffULL, 0x0106880009ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000211137810ULL, 0x040fe20007ffe0ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000000411167810ULL, 0x000fe20007ffe0ffULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000071000720cULL, 0x000fe20003f06070ULL, 0x0000000109127824ULL, 0x040fe200078e0213ULL,
0x0000000b04107217ULL, 0x000fe20007800000ULL, 0x0000000109177824ULL, 0x000fe200078e0216ULL,
0x0000000611197810ULL, 0x000fe20007ffe0ffULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000712147812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a0bULL,
0x00000007170e7812ULL, 0x004fe200078ec0ffULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000f140f7812ULL, 0x000fe200078e7803ULL, 0x0000000109147824ULL, 0x040fe200078e0219ULL,
0x0000002010107807ULL, 0x000fe20000000000ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000001012157824ULL, 0x000fe200078e020fULL,
0x0000000f0e127812ULL, 0x000fe200078e7803ULL, 0x00000001090f7824ULL, 0x040fe200078e0211ULL,
0x00000007141a7812ULL, 0x000fe200078ec0ffULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000001009107217ULL, 0x000fe20007800000ULL, 0x0000001017187824ULL, 0x000fe200078e0212ULL,
0x000000070f0e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff517224ULL, 0x000fe200078e00ffULL,
0x0000000f1a177812ULL, 0x000fe200078e7803ULL, 0x0000000110107824ULL, 0x000fe200078e0a09ULL,
0x0000000f0e0e7812ULL, 0x000fc600078e7803ULL, 0x00000010141a7824ULL, 0x000fe200078e0217ULL,
0x000000101600720cULL, 0x080fe20003f06070ULL, 0x000000100f127824ULL, 0x000fe200078e020eULL,
0x000000101100720cULL, 0x080fe20003f26070ULL, 0x00000080000e7824ULL, 0x000fe200078e020fULL,
0x000000101300720cULL, 0x000fc80003f46070ULL, 0x000000020e147810ULL, 0x040fe40007ffe0ffULL,
0x000000040e167810ULL, 0x000fe20007ffe0ffULL, 0x000058000a0b7a24ULL, 0x008fc800078e02ffULL,
0x000000800b0b7824ULL, 0x000fca00078e00ffULL, 0x0000000e0b1d7210ULL, 0x040fe40007f7e0ffULL,
0x000000140b147210ULL, 0x000fe40007f9e0ffULL, 0x000000060e0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00005e001d177a11ULL, 0x040fe200078640ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e06ffULL, 0x00005e0014117a11ULL, 0x000fe400078840ffULL,
0x00005f001d1d7a11ULL, 0x000fc400018f441cULL, 0x000000160b167210ULL, 0x040fe40007f7e0ffULL,
0x0000000e0b0b7210ULL, 0x000fe40007fbe0ffULL, 0x00005f00141b7a11ULL, 0x000fe200020f441bULL,
0x000000ffff0f7224ULL, 0x000fe200018e06ffULL, 0x000000f00c1c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe200028e06ffULL, 0x00005e0016137a11ULL, 0x000fe400078840ffULL,
0x00005e000b147a11ULL, 0x000fc400078a40ffULL, 0x00005f0016167a11ULL, 0x000fe400020f440fULL,
0x000000101900720cULL, 0x000fe40003f66070ULL, 0x000000171c0e7210ULL, 0x000fe40007f9e0ffULL,
0x00005f000b0b7a11ULL, 0x000fe200028f440cULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000001c11107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e061dULL,
0x0000c00012177811ULL, 0x000fc400078e20ffULL, 0x0000001c13127210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e061bULL, 0x0000001c14147210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e177faeULL, 0x0003e2000c901c46ULL,
0x0000c00015197811ULL, 0x000fe200078e20ffULL, 0x000000ffff137224ULL, 0x000fe200020e0616ULL,
0x0000c000181b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff157224ULL, 0x000fe200028e060bULL,
0x0000c0001a1d7811ULL, 0x000fe200078e20ffULL, 0x0000000010197faeULL, 0x0003e2000d101c46ULL,
0xff317217ff0b7424ULL, 0x000fc600078e00ffULL, 0x00000000121b7faeULL, 0x0003e2000c101c46ULL,
0x000000070500720cULL, 0x000fc60003f06070ULL, 0x00000000141d7faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff0e7f8cULL, 0x002e62000c80043fULL, 0x000000ffff507224ULL, 0x000fe200078e00ffULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x000144c000000947ULL, 0x000fea0003800000ULL, 0x000000020d0e7824ULL, 0x002fe400078e00ffULL,
0x0000000402f57824ULL, 0x000fc400078e00ffULL, 0x00006400ff0d7624ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe200078e000fULL, 0x00000002f5f67810ULL, 0x000fe20007ffe0ffULL,
0x000064000e0d7624ULL, 0x000fe400078e020dULL, 0xff317217ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe400078e00ffULL, 0x00000100050f7824ULL, 0x000fca00078e00ffULL,
0x000000040f00720cULL, 0x000fda0003f06070ULL, 0x000143d000000947ULL, 0x006fea0003800000ULL,
0x0106bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780482dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe4000780482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00107305ULL, 0x0002e4000021f000ULL,
0x3fa000000f0f7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x008fe40003800000ULL,
0x0106bc00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc4000780482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff147819ULL, 0x000fe20000011603ULL,
0x000058000a447a24ULL, 0x004fe200078e02ffULL, 0x0000002000117811ULL, 0x000fe400078e38ffULL,
0x0000000105107810ULL, 0x000fe20007ffe0ffULL, 0x0000000109667824ULL, 0x000fe200078e0214ULL,
0x00000020050f7811ULL, 0x000fe200078e40ffULL, 0x0000008044447824ULL, 0x000fe200078e00ffULL,
0x000000071000720cULL, 0x000fe20003f06070ULL, 0x0000000166137824ULL, 0x040fe200078e0211ULL,
0x0000000766127812ULL, 0x000fc400078ec0ffULL, 0x00000004141c7810ULL, 0x000fe40007ffe0ffULL,
0x0000001344137210ULL, 0x000fe40007f3e0ffULL, 0x0000000f04107217ULL, 0x000fe20007800000ULL,
0x00000001091e7824ULL, 0x000fe200078e021cULL, 0x00000002141b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f12177812ULL, 0x000fe200078e7803ULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00005e0013167a11ULL, 0x000fe200078240ffULL, 0x0000000110107824ULL, 0x000fe200078e0a0fULL,
0x00000006141d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109187824ULL, 0x000fc400078e021bULL,
0x0000001066667824ULL, 0x000fe200078e0217ULL, 0x00005f0013177a11ULL, 0x000fe200008f4412ULL,
0x0000000109567824ULL, 0x000fe200078e021dULL, 0x000000071e127812ULL, 0x000fe200078ec0ffULL,
0x00000001180f7824ULL, 0x100fe200078e0211ULL, 0x0000002010107807ULL, 0x000fe20000000000ULL,
0x000000011e137824ULL, 0x100fe200078e0211ULL, 0x00000007181a7812ULL, 0x000fe200078ec0ffULL,
0x0000000156117824ULL, 0x000fe200078e0211ULL, 0x0000000f12577812ULL, 0x000fe400078e7803ULL,
0x0000000756127812ULL, 0x000fc400078ec0ffULL, 0x0000001009107217ULL, 0x000fe20007800000ULL,
0x000000101e577824ULL, 0x000fe200078e0257ULL, 0x0000000f1a657812ULL, 0x100fe200078e7803ULL,
0x00000010031a7824ULL, 0x000fe200078e00ffULL, 0x0000000f440f7210ULL, 0x000fe40007f3e0ffULL,
0x0000000f12197812ULL, 0x000fe200078e7803ULL, 0x0000000110127824ULL, 0x000fe200078e0a09ULL,
0x0000001344137210ULL, 0x000fe20007f7e0ffULL, 0x0000001018657824ULL, 0x000fe200078e0265ULL,
0x00005e000f187a11ULL, 0x000fe200078440ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000001144117210ULL, 0x000fe20007fde0ffULL, 0x0000001056567824ULL, 0x000fe200078e0219ULL,
0x000000121400720cULL, 0x000fc40003f26070ULL, 0x00005f000f197a11ULL, 0x000fe200010f4410ULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x000000121c00720cULL, 0x000fe20003f46070ULL,
0x000000ffff147224ULL, 0x000fe200030e06ffULL, 0x000000f01a0f7812ULL, 0x000fe400078ec0ffULL,
0x00005e00131c7a11ULL, 0x040fe400078a40ffULL, 0x0000000f16167210ULL, 0x000fe40007f9e0ffULL,
0x00005f0013137a11ULL, 0x000fc400028f4410ULL, 0x00005e00111e7a11ULL, 0x040fe200078a40ffULL,
0x000000ffff177224ULL, 0x000fe200020e0617ULL, 0x0000e00066107811ULL, 0x000fe400078e20ffULL,
0x00005f0011147a11ULL, 0x000fe400028f4414ULL, 0x0000000f18187210ULL, 0x080fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016107faeULL, 0x0003e2000c901c46ULL,
0x000000121b00720cULL, 0x080fe40003f86070ULL, 0x000000121d00720cULL, 0x000fe20003f66070ULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x0000000f1c1c7210ULL, 0x000fc40007f3e0ffULL,
0x0000000f1e1e7210ULL, 0x000fe40007fbe0ffULL, 0x0000e00065117811ULL, 0x000fe200078e20ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e0613ULL, 0x0000e00057127811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e0614ULL, 0x0000e00056137811ULL, 0x000fe200078e20ffULL,
0x0000000018117faeULL, 0x0003e8000e101c46ULL, 0x000000001c127faeULL, 0x0003e8000d101c46ULL,
0x000000001e137faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff4c7f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff147984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106080009167f8cULL, 0x002fe2000c80043fULL,
0x8000000014ff7812ULL, 0x008fc60007844845ULL, 0x01060c0009197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe40007824817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400187305ULL, 0x0002e4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000180000735dULL, 0x008fe20003800000ULL,
0x01060c0009197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc40007824817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff167819ULL, 0x000fe40000011603ULL,
0x000000701a147812ULL, 0x000fe400078ec0ffULL, 0x0000000c16177812ULL, 0x000fca00078ec0ffULL,
0x0000000114147824ULL, 0x000fca00078e0217ULL, 0x0100000014167984ULL, 0x000e680000000800ULL,
0x0102000014177984ULL, 0x0007220000000800ULL, 0x0000000b1600720bULL, 0x002fe20003f3d000ULL,
0x0001d0427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x008fc800008e0100ULL,
0x0000ffff18197812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1a7424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fe40003f65270ULL, 0x0000000b1600720bULL, 0x000fe20003f34000ULL,
0x0001d0227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x000fe400008e0100ULL,
0x000000160b1d7209ULL, 0x040fe40007810000ULL, 0x0000ffff18187812ULL, 0x000fe400078e3cffULL,
0x00000002ff6f7819ULL, 0x000fe20000011603ULL, 0x0104001d1400b388ULL, 0x0003e20000000800ULL,
0x8000001d0b0b7221ULL, 0x000fe20000010000ULL, 0x0000001819ff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00687308ULL, 0x0002e20000000800ULL,
0x0001cfe27f007947ULL, 0x000fea000b800000ULL, 0x00001f6f680b7589ULL, 0x00a2e400000e0000ULL,
0x000000086f6f7810ULL, 0x002fe20007ffe0ffULL, 0x0001d0127f007947ULL, 0x000fea000b800000ULL,
0x00001f6f68677589ULL, 0x00032400000e0000ULL, 0x8000001d16161221ULL, 0x000fe20000010000ULL,
0x00000001ff1a7807ULL, 0x000fe20000800000ULL, 0x0000000b3d3d7220ULL, 0x088fe40000410000ULL,
0x3fb8aa3b16161820ULL, 0x000fe40000410000ULL, 0x0000000b3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001600151308ULL, 0x000ee20000000800ULL, 0x0000000b41417220ULL, 0x000fc40000410000ULL,
0x0000000b40407220ULL, 0x080fe40000410000ULL, 0x0000000b49497220ULL, 0x080fe40000410000ULL,
0x0000000b48487220ULL, 0x080fe40000410000ULL, 0x0000000b51517220ULL, 0x080fe40000410000ULL,
0x0000000b50507220ULL, 0x080fe40000410000ULL, 0x0000000b59597220ULL, 0x000fc40000410000ULL,
0x0000000b58587220ULL, 0x080fe40000410000ULL, 0x0000000b35357220ULL, 0x080fe40000410000ULL,
0x0000000b34347220ULL, 0x080fe40000410000ULL, 0x0000000b61617220ULL, 0x080fe40000410000ULL,
0x0000000b60607220ULL, 0x080fe40000410000ULL, 0x0000000b5d5d7220ULL, 0x000fc40000410000ULL,
0x0000000b5c5c7220ULL, 0x000fe40000410000ULL, 0x000000680c0c7220ULL, 0x000fe40000410000ULL,
0x000000673f3f7220ULL, 0x094fe40000410000ULL, 0x000000673e3e7220ULL, 0x080fe40000410000ULL,
0x0000006743437220ULL, 0x080fe40000410000ULL, 0x0000006742427220ULL, 0x000fc40000410000ULL,
0x000000674b4b7220ULL, 0x080fe40000410000ULL, 0x000000674a4a7220ULL, 0x080fe40000410000ULL,
0x0000006753537220ULL, 0x080fe40000410000ULL, 0x0000006752527220ULL, 0x080fe40000410000ULL,
0x000000675b5b7220ULL, 0x080fe40000410000ULL, 0x000000675a5a7220ULL, 0x000fc40000410000ULL,
0x0000006737377220ULL, 0x080fe40000410000ULL, 0x0000006736367220ULL, 0x080fe40000410000ULL,
0x0000006763637220ULL, 0x080fe40000410000ULL, 0x0000006762627220ULL, 0x080fe40000410000ULL,
0x000000675f5f7220ULL, 0x080fe40000410000ULL, 0x000000675e5e7220ULL, 0x000fc40000410000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e001dULL, 0x0000001517171220ULL, 0x008fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000c170c7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff167984ULL, 0x000ee40000000800ULL, 0x8000000016ff7812ULL, 0x008fe40007824845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff167424ULL, 0x000fc800078e00ffULL, 0x0000001600177305ULL, 0x000724000021f000ULL,
0x3fa0000016167823ULL, 0x008fe200000100ffULL, 0x000000170000735dULL, 0x010fe20003800000ULL,
0x0106ac00ff187984ULL, 0x000ee40000000800ULL, 0x8000000018ff7812ULL, 0x008fc40007824845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff16723eULL, 0x000fe400000010ffULL,
0x00000004ff7f7819ULL, 0x100fe40000011603ULL, 0x00000002fff77819ULL, 0x000fe40000011603ULL,
0x0000541016687816ULL, 0x002fe20000000016ULL, 0x0001cc827f007947ULL, 0x000fea000b800000ULL,
0x00001ff768717589ULL, 0x0002e400000e0000ULL, 0x00000008f7f47810ULL, 0x000fe20007ffe0ffULL,
0x0001ccc27f007947ULL, 0x000fea000b800000ULL, 0x00001ff468707589ULL, 0x00086400000e0000ULL,
0x00000010f7f97810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f9ULL, 0x00001d1000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0001dd6000007944ULL, 0x01cfea0003c00000ULL, 0x00000018f7f77810ULL, 0x002fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x000fe200078e00f7ULL,
0x00001d8000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x0001dcf000007944ULL, 0x01cfea0003c00000ULL,
0x0000000803167812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000f503177211ULL, 0x000fe400078fe0ffULL, 0x00000007161c7812ULL, 0x140fe400078ec803ULL,
0x0000000716187812ULL, 0x000fc400078ef803ULL, 0x000000171c557212ULL, 0x000fe400078e3cffULL,
0x000000f603177211ULL, 0x000fe400078fe0ffULL, 0x0000010018547811ULL, 0x040fe200078e20ffULL,
0x00000010184f7824ULL, 0x000fe200078e0255ULL, 0x000000171c197212ULL, 0x000fe400078e3cffULL,
0x000099101a1a7816ULL, 0x000fe200000000ffULL, 0x0000000155557824ULL, 0x000fe200078e0254ULL,
0x0000c0004f167811ULL, 0x000fe200078e20ffULL, 0x00000010184e7824ULL, 0x000fc400078e0219ULL,
0x0000000119547824ULL, 0x000fe200078e0254ULL, 0x0000c00055187811ULL, 0x000fe200078e20ffULL,
0x00000000161c783bULL, 0x000f620000004200ULL, 0x0000c0004e177811ULL, 0x000fe400078e20ffULL,
0x0000c00054197811ULL, 0x000fe200078e20ffULL, 0x000000001824783bULL, 0x000e680000004200ULL,
0x000000001728783bULL, 0x000f220000004200ULL, 0x00000018ff207819ULL, 0x020fe2000001141cULL,
0x0000001c00757306ULL, 0x000fe20000009400ULL, 0x00000018ff217819ULL, 0x000fc4000001141dULL,
0x00000018ff2d7819ULL, 0x000fe2000001141eULL, 0x00000100247b7824ULL, 0x002fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001141fULL, 0x00000018ff327819ULL, 0x010fe2000001142bULL,
0x00000020009d7306ULL, 0x000fe20000209400ULL, 0x00000018ff2f7819ULL, 0x000fe40000011428ULL,
0x00000018ff7b7819ULL, 0x000fca000001147bULL, 0x0000002000ea7306ULL, 0x000e700000205400ULL,
0x00000020009f7306ULL, 0x000f30000020d400ULL, 0x0000002100877306ULL, 0x000fe20000209400ULL,
0x000000ea9d00720bULL, 0x002fce0003fbd000ULL, 0x0000002100e67306ULL, 0x000e6c0000205400ULL,
0x000000019f9f5812ULL, 0x010fe400078efcffULL, 0x00000021009e7306ULL, 0x000970000020d400ULL,
0x0000002d00d37306ULL, 0x000fe20000209400ULL, 0x000000001920783bULL, 0x010f220000004200ULL,
0x000000e68700720bULL, 0x002fcc0003f5d000ULL, 0x0000002d00987306ULL, 0x000fee0000205400ULL,
0x000000019e9e2812ULL, 0x020fe200078efcffULL, 0x0000002d002c7306ULL, 0x0003f0000020d400ULL,
0x0000001c00ec7306ULL, 0x000f620000005400ULL, 0x00000018ff2d7819ULL, 0x002fce0000011429ULL,
0x0000002d00bb7306ULL, 0x000ff00000209400ULL, 0x0000002d00ba7306ULL, 0x000fe20000205400ULL,
0x00000018ff3a7819ULL, 0x010fe40000011420ULL, 0x00000018ff3b7819ULL, 0x000fc40000011421ULL,
0x00000018ff797819ULL, 0x000fe40000011422ULL, 0x000000ec7500720bULL, 0x020fe20003f9d000ULL,
0x0000002d008d7306ULL, 0x0003e2000020d400ULL, 0x00000018ff7a7819ULL, 0x000fce0000011423ULL,
0x0000001c00a37306ULL, 0x000f22000000d400ULL, 0x00000018ff2d7819ULL, 0x002fce0000011425ULL,
0x0000002d00ac7306ULL, 0x000ff00000209400ULL, 0x0000002d00ad7306ULL, 0x000fe20000205400ULL,
0x00000001a3a34812ULL, 0x010fce00078efcffULL, 0x0000002d00727306ULL, 0x0003f0000020d400ULL,
0x0000003200a77306ULL, 0x000fe20000209400ULL, 0x000001001c2d7824ULL, 0x042fe400078e00ffULL,
0x000100001c1c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000003200a47306ULL, 0x000fe20000205400ULL, 0x00000018ff1c7819ULL, 0x000fce000001141cULL,
0x0000003200847306ULL, 0x000ff0000020d400ULL, 0x0000003a00337306ULL, 0x000ff00000209400ULL,
0x0000003a00327306ULL, 0x000ff00000205400ULL, 0x0000003a00697306ULL, 0x000ff0000020d400ULL,
0x0000003b00857306ULL, 0x000ff00000209400ULL, 0x0000003b00867306ULL, 0x000ff00000205400ULL,
0x0000003b00687306ULL, 0x000ff0000020d400ULL, 0x0000002d003a7306ULL, 0x000ff00000209400ULL,
0x0000002d003b7306ULL, 0x000e700000205400ULL, 0x0000002d00b27306ULL, 0x000970000020d400ULL,
0x0000001d00ef7306ULL, 0x000fe20000009400ULL, 0x000001001e2d7824ULL, 0x010fe200078e00ffULL,
0x0000003b3a00720bULL, 0x002fcc0003f3d000ULL, 0x0000001d009c7306ULL, 0x000e6e0000005400ULL,
0x00000001b2b21812ULL, 0x020fe200078efcffULL, 0x0000001c00e87306ULL, 0x000ff00000209400ULL,
0x0000001c00ed7306ULL, 0x000f220000205400ULL, 0x0000009cef00720bULL, 0x002fce0003fdd000ULL,
0x0000001c00a27306ULL, 0x000370000020d400ULL, 0x0000002e00767306ULL, 0x000fe20000209400ULL,
0x00000018ff1c7819ULL, 0x002fe2000001142dULL, 0x000001001f2d7824ULL, 0x000fe200078e00ffULL,
0x000000ede800720bULL, 0x010fca0003f7d000ULL, 0x0000002e00d17306ULL, 0x000e700000205400ULL,
0x0000002e00937306ULL, 0x0008e2000020d400ULL, 0x00000001a2a23812ULL, 0x020fce00078efcffULL,
0x0000002f00787306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x010fe4000001142aULL,
0x000000d17600720bULL, 0x002fca0003f5d000ULL, 0x0000002f00c77306ULL, 0x000e700000205400ULL,
0x0000002f008b7306ULL, 0x000962000020d400ULL, 0x0000000193932812ULL, 0x008fce00078efcffULL,
0x00000079006e7306ULL, 0x000fe20000209400ULL, 0x00000018ff2f7819ULL, 0x010fe40000011424ULL,
0x000000c77800720bULL, 0x002fca0003f5d000ULL, 0x00000079006f7306ULL, 0x000ff00000205400ULL,
0x0000007900467306ULL, 0x0003e2000020d400ULL, 0x000000018b8b2812ULL, 0x020fce00078efcffULL,
0x0000002e00ab7306ULL, 0x000fe20000209400ULL, 0x00000018ff797819ULL, 0x002fce000001142dULL,
0x0000002e00a67306ULL, 0x000ff00000205400ULL, 0x0000002e00827306ULL, 0x0003f0000020d400ULL,
0x0000002f00ae7306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x002fce0000011426ULL,
0x0000002f00a57306ULL, 0x000ff00000205400ULL, 0x0000002f00777306ULL, 0x0003f0000020d400ULL,
0x0000001d00a07306ULL, 0x000ee2000000d400ULL, 0x00000018ff2f7819ULL, 0x002fce0000011427ULL,
0x0000007900da7306ULL, 0x000ff00000209400ULL, 0x0000007900df7306ULL, 0x000e620000205400ULL,
0x00000001a0a06812ULL, 0x008fce00078efcffULL, 0x0000002e00737306ULL, 0x000ff00000209400ULL,
0x0000002e00747306ULL, 0x000fe20000205400ULL, 0x000000dfda00720bULL, 0x002fce0003fdd000ULL,
0x0000002e00677306ULL, 0x0043f0000020d400ULL, 0x0000002f006c7306ULL, 0x000fe20000209400ULL,
0x000001001d2e7824ULL, 0x042fe400078e00ffULL, 0x000100001d1d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002f006d7306ULL, 0x000fe20000205400ULL,
0x00000018ff1d7819ULL, 0x000fce000001141dULL, 0x0000002f00477306ULL, 0x000ff0000020d400ULL,
0x0000001c00e27306ULL, 0x000ff00000209400ULL, 0x0000001c00e77306ULL, 0x000e700000205400ULL,
0x0000001c002f7306ULL, 0x0004f0000020d400ULL, 0x0000001e00d77306ULL, 0x000fe20000009400ULL,
0x00000100281c7824ULL, 0x004fe200078e00ffULL, 0x000000e7e200720bULL, 0x002fc80003f7d000ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001e00d07306ULL, 0x000e6e0000005400ULL,
0x000000012f2f3812ULL, 0x008fe200078efcffULL, 0x0000001e00387306ULL, 0x0004f0000000d400ULL,
0x0000002e008a7306ULL, 0x000fe20000209400ULL, 0x000100001e1e7824ULL, 0x004fe200078e00ffULL,
0x000000d0d700720bULL, 0x002fc80003fbd000ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000002e00e97306ULL, 0x000e6e0000205400ULL, 0x0000000138385812ULL, 0x008fe200078efcffULL,
0x0000002e00b37306ULL, 0x000ea6000020d400ULL, 0x000000382f38723eULL, 0x000fca00000010ffULL,
0x00000079002e7306ULL, 0x000ee2000020d400ULL, 0x000000e98a00720bULL, 0x002fce0003f3d000ULL,
0x0000001c00e07306ULL, 0x000fec0000209400ULL, 0x00000001b3b31812ULL, 0x004fe400078efcffULL,
0x0000001c00e57306ULL, 0x000e620000205400ULL, 0x000000012e2e6812ULL, 0x008fce00078efcffULL,
0x0000001d00e47306ULL, 0x000ff00000209400ULL, 0x0000001d00eb7306ULL, 0x000ea20000205400ULL,
0x000000e5e000720bULL, 0x002fce0003fdd000ULL, 0x0000001d00a17306ULL, 0x0002f0000020d400ULL,
0x0000002800c87306ULL, 0x000fe20000009400ULL, 0x00000100291d7824ULL, 0x002fe200078e00ffULL,
0x000000ebe400720bULL, 0x004fcc0003f9d000ULL, 0x0000002800997306ULL, 0x000fee0000005400ULL,
0x00000001a1a14812ULL, 0x008fe200078efcffULL, 0x0000002800927306ULL, 0x0003e2000000d400ULL,
0x00000098d300720bULL, 0x000fce0003f9d000ULL, 0x0000001e00dc7306ULL, 0x000fe20000209400ULL,
0x0001000028287824ULL, 0x002fca00078e00ffULL, 0x000000012c2c4812ULL, 0x000fe400078efcffULL,
0x0000001e00e17306ULL, 0x000e700000205400ULL, 0x0000001e002d7306ULL, 0x0005f0000020d400ULL,
0x0000001c00957306ULL, 0x000722000020d400ULL, 0x00000018ff1e7819ULL, 0x004fc4000001141dULL,
0x00000018ff1d7819ULL, 0x000fe40000011428ULL, 0x000000e1dc00720bULL, 0x002fc60003f7d000ULL,
0x0000001d00d67306ULL, 0x000fe20000209400ULL, 0x000001002a1c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe2000001141cULL, 0x000001002b1c7824ULL, 0x000fe200078e00ffULL,
0x0000001d00db7306ULL, 0x000e620000205400ULL, 0x0000000195956812ULL, 0x010fe400078efcffULL,
0x000000012d2d3812ULL, 0x000fe400078efcffULL, 0x00000099c800720bULL, 0x000fc60003f7d000ULL,
0x0000001f00977306ULL, 0x000ff00000009400ULL, 0x0000001f00d27306ULL, 0x000ea20000005400ULL,
0x000000dbd600720bULL, 0x002fe40003fdd000ULL, 0x0000000192923812ULL, 0x000fca00078efcffULL,
0x0000001f00397306ULL, 0x0002f0000000d400ULL, 0x0000001e00d47306ULL, 0x000fe20000209400ULL,
0x000100001f1f7824ULL, 0x002fe200078e00ffULL, 0x000000d29700720bULL, 0x004fc80003f3d000ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001e00d97306ULL, 0x000e6e0000205400ULL,
0x0000000139391812ULL, 0x008fe200078efcffULL, 0x0000001f00de7306ULL, 0x000fe20000209400ULL,
0x000000ff1a00720cULL, 0x000fc40003f25270ULL, 0x000000392e39723eULL, 0x000fca00000010ffULL,
0x0000001f00e37306ULL, 0x000ea20000205400ULL, 0x000000d9d400720bULL, 0x002fce0003f9d000ULL,
0x0000001f00967306ULL, 0x000e70000020d400ULL, 0x0000001e00917306ULL, 0x000ee2000020d400ULL,
0x000000e3de00720bULL, 0x004fce0003fbd000ULL, 0x0000001d00907306ULL, 0x000eac000020d400ULL,
0x0000000196965812ULL, 0x002fe400078efcffULL, 0x00000079001e7306ULL, 0x000fe20000209400ULL,
0x0000000191914812ULL, 0x008fe400078efcffULL, 0x000000babb00720bULL, 0x000fca0003f9d000ULL,
0x00000079001f7306ULL, 0x000e620000205400ULL, 0x0000000190906812ULL, 0x004fc800078efcffULL,
0x000000908b90723eULL, 0x000fc600000010ffULL, 0x0000002900c57306ULL, 0x000fe20000009400ULL,
0x000000018d8d4812ULL, 0x000fce00078efcffULL, 0x0000002900647306ULL, 0x000ea20000005400ULL,
0x0000001f1e00720bULL, 0x002fce0003fdd000ULL, 0x00000029008e7306ULL, 0x0002f0000000d400ULL,
0x0000007900287306ULL, 0x000f22000020d400ULL, 0x0001000029297824ULL, 0x002fe200078e00ffULL,
0x00000064c500720bULL, 0x004fc40003fbd000ULL, 0x0000000703647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002400b07306ULL, 0x000fe20000009400ULL,
0x0000000864647812ULL, 0x000fc800078ef803ULL, 0x000000077f7f7812ULL, 0x100fe400078e7864ULL,
0x000000018e8e5812ULL, 0x008fe200078efcffULL, 0x0000002900d87306ULL, 0x000fe20000209400ULL,
0x0000000128286812ULL, 0x010fe200078efcffULL, 0x00000008641a7824ULL, 0x000fe200078e027fULL,
0x000000a6ab00720bULL, 0x000fe20003fdd000ULL, 0x0001000026ab7824ULL, 0x000fe200078e00ffULL,
0x000000071b1b7812ULL, 0x000fe200078e7864ULL, 0x0001000022a67824ULL, 0x000fe400078e00ffULL,
0x0000002900dd7306ULL, 0x000e620000205400ULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x00000008641b7824ULL, 0x000fe200078e021bULL, 0x00000018ffa67819ULL, 0x000fc800000114a6ULL,
0x0000a0001b2e7811ULL, 0x000fe200078e20ffULL, 0x0000002400b17306ULL, 0x000fe20000005400ULL,
0x0000000182826812ULL, 0x000fce00078efcffULL, 0x00000024007e7306ULL, 0x0005e2000000d400ULL,
0x000000ddd800720bULL, 0x002fce0003f7d000ULL, 0x0000002a00b97306ULL, 0x000fe20000009400ULL,
0x0001000024247824ULL, 0x004fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002a00b87306ULL, 0x000e700000005400ULL, 0x0000002a00317306ULL, 0x0004f0000000d400ULL,
0x0000002900947306ULL, 0x000f22000020d400ULL, 0x000100002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000b8b900720bULL, 0x002fc80003fbd000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002b00b77306ULL, 0x000fee0000009400ULL, 0x0000000131315812ULL, 0x008fe200078efcffULL,
0x0000002b00b67306ULL, 0x000e620000005400ULL, 0x0000000194943812ULL, 0x010fce00078efcffULL,
0x0000007a006a7306ULL, 0x000ff00000209400ULL, 0x0000007a006b7306ULL, 0x000fe20000205400ULL,
0x000000b6b700720bULL, 0x002fe20003f7d000ULL, 0x0001000027b67824ULL, 0x000fca00078e00ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x0000007a00457306ULL, 0x0003f0000020d400ULL,
0x0000002400c47306ULL, 0x000fe20000209400ULL, 0x00000018ff7a7819ULL, 0x002fce000001141cULL,
0x0000002400c97306ULL, 0x000e700000205400ULL, 0x0000002a00ce7306ULL, 0x000ff00000209400ULL,
0x0000002a00d57306ULL, 0x000ea20000205400ULL, 0x000000c9c400720bULL, 0x002fce0003fdd000ULL,
0x0000002a00297306ULL, 0x0003f0000020d400ULL, 0x0000002b00307306ULL, 0x000722000000d400ULL,
0x00000100252a7824ULL, 0x002fe200078e00ffULL, 0x000000d5ce00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002500a87306ULL, 0x000fe20000009400ULL,
0x000100002b2b7824ULL, 0x008fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe4000001142bULL,
0x0000002500a97306ULL, 0x000fe20000005400ULL, 0x0000000130303812ULL, 0x010fe400078efcffULL,
0x0000000129294812ULL, 0x000fe400078efcffULL, 0x000000b1b000720bULL, 0x000fc60003f9d000ULL,
0x00000025007d7306ULL, 0x0003f0000000d400ULL, 0x0000007a001c7306ULL, 0x000fe20000209400ULL,
0x0001000025257824ULL, 0x002fe200078e00ffULL, 0x000000017e7e4812ULL, 0x000fc800078efcffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000007a001d7306ULL, 0x000e700000205400ULL,
0x0000007b00be7306ULL, 0x000ff00000209400ULL, 0x0000007b00bf7306ULL, 0x000ea20000205400ULL,
0x0000001d1c00720bULL, 0x002fc40003f5d000ULL, 0x0000a0001a1c7811ULL, 0x000fca00078e20ffULL,
0x0000002400887306ULL, 0x000e62000020d400ULL, 0x000000001c1c783bULL, 0x000eee0000000200ULL,
0x0000007900bc7306ULL, 0x000fe20000209400ULL, 0x000000bfbe00720bULL, 0x004fce0003f7d000ULL,
0x0000007900bd7306ULL, 0x000ea20000205400ULL, 0x0000000188886812ULL, 0x002fce00078efcffULL,
0x0000002500ca7306ULL, 0x000ff00000209400ULL, 0x0000002500cd7306ULL, 0x000e620000205400ULL,
0x000000bdbc00720bULL, 0x004fce0003fbd000ULL, 0x00000079002b7306ULL, 0x000522000020d400ULL,
0x000000711c1c9231ULL, 0x088fe400003400ffULL, 0x000000711e1e9231ULL, 0x000fe400003400ffULL,
0x000000701d1d9231ULL, 0x080fe400003400ffULL, 0x000000701f1f9231ULL, 0x000fe200003400ffULL,
0x0000007b00897306ULL, 0x000ee2000020d400ULL, 0x0000010026797824ULL, 0x004fe200078e00ffULL,
0x000000cdca00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff247819ULL, 0x000fe20000011479ULL,
0x0000010027797824ULL, 0x000fe200078e00ffULL, 0x0000007a008f7306ULL, 0x0002a2000020d400ULL,
0x000000012b2b5812ULL, 0x010fe400078efcffULL, 0x000000a5ae00720bULL, 0x000fca0003fbd000ULL,
0x0000002500817306ULL, 0x000962000020d400ULL, 0x0000000189893812ULL, 0x008fe200078efcffULL,
0x00000100207a7824ULL, 0x002fe200078e00ffULL, 0x000000a9a800720bULL, 0x000fca0003f7d000ULL,
0x0000002400c07306ULL, 0x000fe20000209400ULL, 0x000000018f8f2812ULL, 0x004fe400078efcffULL,
0x000000a4a700720bULL, 0x000fe40003f5d000ULL, 0x00000018ff257819ULL, 0x010fe4000001147aULL,
0x0000000177775812ULL, 0x000fe200078efcffULL, 0x0000002400c17306ULL, 0x000e620000205400ULL,
0x0000000181816812ULL, 0x020fe400078efcffULL, 0x000000017d7d3812ULL, 0x000fc400078efcffULL,
0x000000308f8f723eULL, 0x000fc600000010ffULL, 0x0000002000c27306ULL, 0x000fe20000009400ULL,
0x0000000184842812ULL, 0x000fce00078efcffULL, 0x0000002000c37306ULL, 0x000ea20000005400ULL,
0x000000c1c000720bULL, 0x002fce0003fdd000ULL, 0x0000002a00c67306ULL, 0x000ff00000209400ULL,
0x0000002a00cb7306ULL, 0x000e620000205400ULL, 0x000000c3c200720bULL, 0x004fce0003f7d000ULL,
0x0000002a008c7306ULL, 0x0005f0000020d400ULL, 0x0000002400837306ULL, 0x000ee2000020d400ULL,
0x00000018ff2a7819ULL, 0x004fe40000011479ULL, 0x000000cbc600720bULL, 0x002fca0003f5d000ULL,
0x0000002600af7306ULL, 0x000ff00000009400ULL, 0x0000002600aa7306ULL, 0x000e620000005400ULL,
0x0000000183836812ULL, 0x008fe400078efcffULL, 0x000000018c8c2812ULL, 0x000fc400078efcffULL,
0x000000adac00720bULL, 0x000fc60003f5d000ULL, 0x0000002700cc7306ULL, 0x000ff00000009400ULL,
0x0000002700cf7306ULL, 0x000ea20000005400ULL, 0x000000aaaf00720bULL, 0x002fe40003f9d000ULL,
0x0000000172722812ULL, 0x000fca00078efcffULL, 0x00000021003a7306ULL, 0x000ff00000009400ULL,
0x00000021003b7306ULL, 0x000e620000005400ULL, 0x000000cfcc00720bULL, 0x004fce0003fbd000ULL,
0x00000020007b7306ULL, 0x0004f0000000d400ULL, 0x0000002a00b47306ULL, 0x000fe20000209400ULL,
0x0001000020207824ULL, 0x004fe200078e00ffULL, 0x0000003b3a00720bULL, 0x002fc40003fdd000ULL,
0x000000381c38723cULL, 0x000fe40000041834ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002a00b57306ULL, 0x000e620000205400ULL, 0x000000017b7b3812ULL, 0x008fe400078efcffULL,
0x000000929534723eULL, 0x000fe400000010ffULL, 0x0000008e9135723eULL, 0x000fe400000010ffULL,
0x000000948d91723eULL, 0x000fe200000010ffULL, 0x0000002a00797306ULL, 0x0005e2000020d400ULL,
0x00000031288e723eULL, 0x000fc600000010ffULL, 0x000000341c34723cULL, 0x000fe80000041850ULL,
0x0000002100757306ULL, 0x000722000000d400ULL, 0x00000100212a7824ULL, 0x004fe200078e00ffULL,
0x000000b5b400720bULL, 0x002fc80003f5d000ULL, 0x00000018ffe47819ULL, 0x000fe4000001142aULL,
0x0000002000987306ULL, 0x000fe20000209400ULL, 0x0001000021217824ULL, 0x008fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000997306ULL, 0x000e620000205400ULL,
0x0000000175756812ULL, 0x010fe400078efcffULL, 0x0000000179792812ULL, 0x000fca00078efcffULL,
0x0000002600807306ULL, 0x000eb0000000d400ULL, 0x00000027007c7306ULL, 0x000722000000d400ULL,
0x000000999800720bULL, 0x002fce0003f7d000ULL, 0x00000025009a7306ULL, 0x000fe20000209400ULL,
0x0001000023277824ULL, 0x008fe200078e00ffULL, 0x0000000180804812ULL, 0x004fc800078efcffULL,
0x000000808380723eULL, 0x000fe400000010ffULL, 0x00000025009b7306ULL, 0x000e620000205400ULL,
0x000000017c7c5812ULL, 0x010fce00078efcffULL, 0x000000e4002a7306ULL, 0x000ff00000209400ULL,
0x000000e400977306ULL, 0x000ea20000205400ULL, 0x0000009b9a00720bULL, 0x002fce0003f9d000ULL,
0x0000002100ba7306ULL, 0x000ff00000209400ULL, 0x0000002100b97306ULL, 0x000e620000205400ULL,
0x000000972a00720bULL, 0x004fce0003fbd000ULL, 0x0000002000787306ULL, 0x0004f0000020d400ULL,
0x00000021007f7306ULL, 0x000962000020d400ULL, 0x0000010022207824ULL, 0x004fe200078e00ffULL,
0x000000b9ba00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002300877306ULL, 0x000fe20000009400ULL, 0x0000010023217824ULL, 0x010fe200078e00ffULL,
0x0000000178783812ULL, 0x008fc800078efcffULL, 0x00000018ffa87819ULL, 0x000fe40000011421ULL,
0x0000002000a47306ULL, 0x000fe20000209400ULL, 0x000000a19e21723eULL, 0x000fe400000010ffULL,
0x000000017f7f6812ULL, 0x020fca00078efcffULL, 0x0000002000a77306ULL, 0x000e700000205400ULL,
0x00000023008a7306ULL, 0x000ff00000005400ULL, 0x0000002300247306ULL, 0x0005e2000000d400ULL,
0x000000a7a400720bULL, 0x002fce0003f7d000ULL, 0x00000025007a7306ULL, 0x000e62000020d400ULL,
0x000000a0b323723eULL, 0x004fce00000010ffULL, 0x000000e400767306ULL, 0x000eb0000020d400ULL,
0x0000002000267306ULL, 0x000722000020d400ULL, 0x000000017a7a4812ULL, 0x002fe400078efcffULL,
0x000000323300720bULL, 0x000fc40003f9d000ULL, 0x000000901c30723cULL, 0x040fe60000041848ULL,
0x000000a800a57306ULL, 0x000fe20000209400ULL, 0x000000a29f20723eULL, 0x008fe400000010ffULL,
0x0000000176765812ULL, 0x004fe400078efcffULL, 0x000000868500720bULL, 0x000fe40003fbd000ULL,
0x0000007e8948723eULL, 0x000fe200000010ffULL, 0x000000a800a07306ULL, 0x000e620000205400ULL,
0x000000201c60723cULL, 0x000fe20000041860ULL, 0x0000000126263812ULL, 0x010fc400078efcffULL,
0x0000000169694812ULL, 0x000fe400078efcffULL, 0x0000008a8700720bULL, 0x000fe40003f9d000ULL,
0x00000022009c7306ULL, 0x000fe20000009400ULL, 0x0000002d2c20723eULL, 0x000fe400000010ffULL,
0x000000969321723eULL, 0x000fe200000010ffULL, 0x000000002e2c783bULL, 0x000ea20000000200ULL,
0x0000000168685812ULL, 0x000fe400078efcffULL, 0x000000747300720bULL, 0x000fe20003fbd000ULL,
0x00000022009d7306ULL, 0x000ee20000005400ULL, 0x000000a0a500720bULL, 0x002fe20003fdd000ULL,
0x000000201c58723cULL, 0x000fe20000041858ULL, 0x0000000124244812ULL, 0x000fc400078efcffULL,
0x0000006b6a00720bULL, 0x000fe40003f9d000ULL, 0x0000007d8c49723eULL, 0x000fe200000010ffULL,
0x0000002200257306ULL, 0x0003e2000000d400ULL, 0x000000298220723eULL, 0x000fe400000010ffULL,
0x0000002b8421723eULL, 0x000fe400000010ffULL, 0x0000008e1c28723cULL, 0x000fe20000041840ULL,
0x0000000167675812ULL, 0x000fe400078efcffULL, 0x000000a8009f7306ULL, 0x000f22000020d400ULL,
0x000000a3b222723eULL, 0x002fc400000010ffULL, 0x0000009d9c00720bULL, 0x008fe40003f5d000ULL,
0x0000000145454812ULL, 0x000fe400078efcffULL, 0x000000817241723eULL, 0x000fe200000010ffULL,
0x000000221c5c723cULL, 0x000fe2000004185cULL, 0x000000ab00227306ULL, 0x000fe20000209400ULL,
0x0000007c7981723eULL, 0x000fe400000010ffULL, 0x000000887740723eULL, 0x000fe400000010ffULL,
0x0000007b7a74723eULL, 0x000fc400000010ffULL, 0x000000201c1c723cULL, 0x000fe2000004183cULL,
0x000000ab00237306ULL, 0x000e620000205400ULL, 0x000000019f9f6812ULL, 0x010fe400078efcffULL,
0x0000000125252812ULL, 0x000fe200078efcffULL, 0x000000712c2c9231ULL, 0x084fe200003400ffULL,
0x0000006f6e00720bULL, 0x000fe20003f5d000ULL, 0x000000712e2e9231ULL, 0x000fe200003400ffULL,
0x00000018ff3c7819ULL, 0x000fe20000011427ULL, 0x000000b6008b7306ULL, 0x000fe20000209400ULL,
0x000000702d2d9231ULL, 0x080fe200003400ffULL, 0x000000757675723eULL, 0x000fe200000010ffULL,
0x000000702f2f9231ULL, 0x000fe200003400ffULL, 0x000000786978723eULL, 0x000fc400000010ffULL,
0x0000007f6879723eULL, 0x000fe400000010ffULL, 0x000000b600507306ULL, 0x000ea20000205400ULL,
0x000000232200720bULL, 0x002fe20003f7d000ULL, 0x000000482c48723cULL, 0x000fe2000004185cULL,
0x0000000146462812ULL, 0x000fe400078efcffULL, 0x000000252626723eULL, 0x000fc600000010ffULL,
0x000000ab00967306ULL, 0x000e64000020d400ULL, 0x000000402c40723cULL, 0x040fec0000041860ULL,
0x000000b600527306ULL, 0x000ee2000020d400ULL, 0x000000508b00720bULL, 0x004fe20003fdd000ULL,
0x000000802c38723cULL, 0x040fec0000041838ULL, 0x000000a600517306ULL, 0x000fe20000209400ULL,
0x0000000196963812ULL, 0x002fe200078efcffULL, 0x000000742c34723cULL, 0x000fe20000041834ULL,
0x0000006d6c00720bULL, 0x000fc40003f7d000ULL, 0x000000966750723eULL, 0x000fc600000010ffULL,
0x000000a600207306ULL, 0x000e620000205400ULL, 0x0000000152526812ULL, 0x008fe200078efcffULL,
0x000000782c30723cULL, 0x000fec0000041830ULL, 0x0000003c00277306ULL, 0x000fe20000209400ULL,
0x0000000147473812ULL, 0x000fce00078efcffULL, 0x0000003c00227306ULL, 0x000ea20000205400ULL,
0x000000205100720bULL, 0x002fe40003fbd000ULL, 0x000000524751723eULL, 0x000fca00000010ffULL,
0x000000a600217306ULL, 0x000e64000020d400ULL, 0x000000502c50723cULL, 0x000fec0000041858ULL,
0x0000003c003c7306ULL, 0x000ee2000020d400ULL, 0x000000222700720bULL, 0x004fe40003fdd000ULL,
0x000000249f27723eULL, 0x000fc400000010ffULL, 0x0000000121215812ULL, 0x002fca00078efcffULL,
0x000000262c28723cULL, 0x000fe20000041828ULL, 0x000000214646723eULL, 0x000fc600000010ffULL,
0x000000013c3c6812ULL, 0x008fc800078efcffULL, 0x0000003c4547723eULL, 0x000fce00000010ffULL,
0x000000462c2c723cULL, 0x000fe2000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff1c7f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000784481dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fc4000784481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff1e7424ULL, 0x000fc800078e00ffULL, 0x0000001e001f7305ULL, 0x0002a4000021f000ULL,
0x3fa000001e1e7823ULL, 0x002fe200000100ffULL, 0x0000001f0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000784481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000040051d7811ULL, 0x000fe400078e40ffULL,
0x00000004ff217819ULL, 0x000fc40000011603ULL, 0x0000001d041c7217ULL, 0x000fe40007800000ULL,
0x0000004000227811ULL, 0x000fe400078e38ffULL, 0x0000000221257810ULL, 0x000fe20007ffe0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e0a1dULL, 0x00000009221d7210ULL, 0x0c0fe40007ffe021ULL,
0x00000009221f7210ULL, 0x000fe40007ffe025ULL, 0x000000201c1c7807ULL, 0x000fc40000000000ULL,
0x0000001d441d7210ULL, 0x040fe40007f5e0ffULL, 0x0000001c091c7217ULL, 0x000fe40007800000ULL,
0x00000004213d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x0000001f441f7210ULL, 0x000fe20007f7e0ffULL, 0x000000011c207824ULL, 0x000fe200078e0a09ULL,
0x00005e001d1e7a11ULL, 0x000fe200078440ffULL, 0x00000001091c7824ULL, 0x000fe200078e023dULL,
0x00005e001f3c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005f001d1d7a11ULL, 0x000fc400010f4426ULL, 0x0000000f1e1e7210ULL, 0x000fe40007f5e0ffULL,
0x000000202100720cULL, 0x0c0fe40003f66070ULL, 0x0000000621277810ULL, 0x000fe20007ffe0ffULL,
0x000000011c217824ULL, 0x000fe200078e0222ULL, 0x00005f001f237a11ULL, 0x000fe200020f4424ULL,
0x000000ffff1f7224ULL, 0x000fe200010e061dULL, 0x000000202500720cULL, 0x000fe40003f46070ULL,
0x0000002144257210ULL, 0x000fc40007f9e0ffULL, 0x0000000922217210ULL, 0x000fe40007ffe027ULL,
0x0000c000661d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x0000002144217210ULL, 0x000fe40007fde0ffULL, 0x00005e0025247a11ULL, 0x040fe200078840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e1d7faeULL, 0x0003e2000d901c46ULL,
0x0000000f3c227210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3c7224ULL, 0x000fe200030e06ffULL,
0x00005f0025257a11ULL, 0x000fc400020f4426ULL, 0x00005e0021267a11ULL, 0x000fe200078840ffULL,
0x000000ffff237224ULL, 0x000fe200028e0623ULL, 0x000000203d00720cULL, 0x080fe40003f66070ULL,
0x000000202700720cULL, 0x000fe40003fa6070ULL, 0x0000000f24247210ULL, 0x080fe40007fde0ffULL,
0x00005f0021217a11ULL, 0x000fe400020f443cULL, 0x0000000f26267210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x0000c000651e7811ULL, 0x002fc400078e20ffULL,
0x0000c000571f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff277224ULL, 0x000fe200020e0621ULL,
0x0000c00056207811ULL, 0x000fe200078e20ffULL, 0x00000000221e7faeULL, 0x0003e8000d101c46ULL,
0x00000000241f7faeULL, 0x0003e8000d901c46ULL, 0x0000000026207faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff227f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fc4000784484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff457224ULL, 0x000fe200078e0023ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000784484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff217424ULL, 0x000fc800078e00ffULL,
0x0000002100227305ULL, 0x0002a4000021f000ULL, 0x3fa0000021217823ULL, 0x002fe200000100ffULL,
0x000000220000735dULL, 0x004fe20003800000ULL, 0x0106b400ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fc4000784484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff21723eULL, 0x000fe400000010ffULL, 0x00000002ff6f7819ULL, 0x000fe40000011603ULL,
0x0000000403257811ULL, 0x000fe400078fe0ffULL, 0x0000541021687816ULL, 0x000fe20000000021ULL,
0x0001a6b27f007947ULL, 0x000fea000b800000ULL, 0x00001f6f689f7589ULL, 0x0002a400000e0000ULL,
0x0001a6f27f007947ULL, 0x000fea000b800000ULL, 0x00001ff468a07589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f9ULL,
0x000043a000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fc400078e00ffULL, 0x0001b6d000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f7ULL,
0x0000440000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x0001b67000007944ULL, 0x01cfea0003c00000ULL,
0x0000e0004f217811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000e00055237811ULL, 0x000fe400078e20ffULL, 0x0000e0004e227811ULL, 0x000fe200078e20ffULL,
0x00000000213c783bULL, 0x000f620000004200ULL, 0x0000000725257812ULL, 0x000fc600078e7864ULL,
0x000000002358783bULL, 0x000fe40000004200ULL, 0x0000000864257824ULL, 0x000fe400078e0225ULL,
0x00000000224c783bULL, 0x000e620000004200ULL, 0x00000018ff247819ULL, 0x020fe2000001143cULL,
0x000001003c707824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe2000001143eULL,
0x0000003c00ef7306ULL, 0x000fe20000009400ULL, 0x00000018ff567819ULL, 0x000fe4000001143fULL,
0x00000018ff727819ULL, 0x000fc40000011470ULL, 0x00000018ff277819ULL, 0x000fe2000001143dULL,
0x000001004f787824ULL, 0x002fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011459ULL,
0x00000024006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff637819ULL, 0x000fe4000001145aULL,
0x00000018ff657819ULL, 0x000fe4000001145bULL, 0x00000018ff5d7819ULL, 0x000fe4000001144cULL,
0x00000018ff5e7819ULL, 0x000fe2000001144eULL, 0x00000024009b7306ULL, 0x000e620000205400ULL,
0x00000018ff787819ULL, 0x000fce0000011478ULL, 0x0000002400467306ULL, 0x000af0000020d400ULL,
0x0000005500d97306ULL, 0x000fe20000209400ULL, 0x0000e00054247811ULL, 0x020fe400078e20ffULL,
0x0000009b6c00720bULL, 0x002fca0003fdd000ULL, 0x0000005500da7306ULL, 0x000ff00000205400ULL,
0x0000005500977306ULL, 0x000fe2000020d400ULL, 0x0000000146466812ULL, 0x008fce00078efcffULL,
0x0000005600d87306ULL, 0x000ff00000209400ULL, 0x0000005600d77306ULL, 0x000ff00000205400ULL,
0x0000005600947306ULL, 0x0003f0000020d400ULL, 0x0000007200707306ULL, 0x000fe20000209400ULL,
0x000000002454783bULL, 0x002e6e0000004200ULL, 0x0000007200a37306ULL, 0x000ef00000205400ULL,
0x0000003c008c7306ULL, 0x000f700000005400ULL, 0x0000003c00b17306ULL, 0x0009e2000000d400ULL,
0x000000a37000720bULL, 0x008fce0003fbd000ULL, 0x0000007200c27306ULL, 0x0006a2000020d400ULL,
0x000100003c3c7824ULL, 0x010fe200078e00ffULL, 0x0000008cef00720bULL, 0x020fc80003f9d000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000002700687306ULL, 0x000fe20000209400ULL,
0x00000018ff737819ULL, 0x002fe20000011455ULL, 0x000001003e727824ULL, 0x008fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe40000011456ULL, 0x00000018ff777819ULL, 0x000fe40000011457ULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000002700837306ULL, 0x000e620000205400ULL,
0x00000001c2c25812ULL, 0x004fc400078efcffULL, 0x00000001b1b14812ULL, 0x000fca00078efcffULL,
0x0000003c00847306ULL, 0x000ff00000209400ULL, 0x0000003c00ed7306ULL, 0x000ea20000205400ULL,
0x000000836800720bULL, 0x002fce0003f7d000ULL, 0x0000006200a77306ULL, 0x000ff00000209400ULL,
0x0000006200aa7306ULL, 0x000fe20000205400ULL, 0x000000ed8400720bULL, 0x004fce0003fbd000ULL,
0x0000006200617306ULL, 0x000ff0000020d400ULL, 0x00000063008a7306ULL, 0x000ff00000209400ULL,
0x00000063008b7306ULL, 0x000ff00000205400ULL, 0x00000063006d7306ULL, 0x000ff0000020d400ULL,
0x0000007300627306ULL, 0x000ff00000209400ULL, 0x0000007300637306ULL, 0x000ff00000205400ULL,
0x0000007300667306ULL, 0x0003f0000020d400ULL, 0x0000003d009e7306ULL, 0x000fe20000009400ULL,
0x000001003d737824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000003d008d7306ULL, 0x000e700000005400ULL, 0x0000003d00ad7306ULL, 0x0004f0000000d400ULL,
0x0000003e00dd7306ULL, 0x000fe20000009400ULL, 0x000100003d3d7824ULL, 0x004fe200078e00ffULL,
0x0000008d9e00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003e009a7306ULL, 0x000e6e0000005400ULL, 0x00000001adad2812ULL, 0x008fe200078efcffULL,
0x0000003e00a57306ULL, 0x0004f0000000d400ULL, 0x00000065007f7306ULL, 0x000fe20000209400ULL,
0x000100003e3e7824ULL, 0x004fe200078e00ffULL, 0x0000009add00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000006500807306ULL, 0x000fee0000205400ULL,
0x00000001a5a56812ULL, 0x008fe200078efcffULL, 0x0000006500697306ULL, 0x000ff0000020d400ULL,
0x0000002700477306ULL, 0x0002b0000020d400ULL, 0x00000076006e7306ULL, 0x000fe20000209400ULL,
0x00000018ff277819ULL, 0x002fce000001144dULL, 0x00000076006f7306ULL, 0x000fe20000205400ULL,
0x0000000147473812ULL, 0x004fce00078efcffULL, 0x0000007600657306ULL, 0x000ff0000020d400ULL,
0x0000003c00bb7306ULL, 0x0002b0000020d400ULL, 0x0000007300767306ULL, 0x000fe20000209400ULL,
0x000001003f3c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000007300957306ULL, 0x000e620000205400ULL, 0x00000001bbbb5812ULL, 0x004fc800078efcffULL,
0x000000bb4646723eULL, 0x000fc600000010ffULL, 0x0000003d00ea7306ULL, 0x000ff00000209400ULL,
0x0000003d00eb7306ULL, 0x000ea20000205400ULL, 0x000000957600720bULL, 0x002fce0003f9d000ULL,
0x0000003e00e87306ULL, 0x000ff00000209400ULL, 0x0000003e00e97306ULL, 0x000e620000205400ULL,
0x000000ebea00720bULL, 0x004fce0003fbd000ULL, 0x0000003d00ae7306ULL, 0x0004f0000020d400ULL,
0x0000007200e47306ULL, 0x000fe20000209400ULL, 0x000001004c3d7824ULL, 0x004fe200078e00ffULL,
0x000000e9e800720bULL, 0x002fcc0003f7d000ULL, 0x0000007200e57306ULL, 0x000fe20000205400ULL,
0x00000001aeae5812ULL, 0x008fc800078efcffULL, 0x000000ae4747723eULL, 0x000fc600000010ffULL,
0x0000007200ac7306ULL, 0x0003f0000020d400ULL, 0x0000007300c07306ULL, 0x000ea2000020d400ULL,
0x00000018ff727819ULL, 0x002fce000001143dULL, 0x0000003e00a47306ULL, 0x000e70000020d400ULL,
0x0000003f00dc7306ULL, 0x000fe20000009400ULL, 0x00000001c0c04812ULL, 0x004fe400078efcffULL,
0x000000e5e400720bULL, 0x000fca0003f9d000ULL, 0x0000003f00917306ULL, 0x000ea20000005400ULL,
0x00000001a4a43812ULL, 0x002fce00078efcffULL, 0x0000002700d37306ULL, 0x000fe20000209400ULL,
0x00000001acac4812ULL, 0x000fe400078efcffULL, 0x000000dad900720bULL, 0x000fca0003f9d000ULL,
0x00000027008e7306ULL, 0x000fe20000205400ULL, 0x00000091dc00720bULL, 0x004fce0003fbd000ULL,
0x00000027007e7306ULL, 0x0003e2000020d400ULL, 0x0000000197974812ULL, 0x000fce00078efcffULL,
0x0000007200e27306ULL, 0x000fe20000209400ULL, 0x00000018ff277819ULL, 0x002fce0000011458ULL,
0x0000007200e37306ULL, 0x000e700000205400ULL, 0x0000004c00db7306ULL, 0x000ff00000009400ULL,
0x0000004c00927306ULL, 0x000ea20000005400ULL, 0x000000e3e200720bULL, 0x002fce0003f7d000ULL,
0x0000004c00937306ULL, 0x0002f0000000d400ULL, 0x0000005d00d67306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x002fe200078e00ffULL, 0x00000092db00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff737819ULL, 0x000fe2000001144cULL, 0x000001004e4c7824ULL, 0x000fe200078e00ffULL,
0x0000005d00717306ULL, 0x000fee0000205400ULL, 0x0000000193936812ULL, 0x008fe200078efcffULL,
0x0000005d00877306ULL, 0x0003e2000020d400ULL, 0x0000008ed300720bULL, 0x000fce0003fdd000ULL,
0x0000002700b47306ULL, 0x000fe20000209400ULL, 0x00000018ff5d7819ULL, 0x002fca000001144fULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x0000002700af7306ULL, 0x000ff00000205400ULL,
0x00000027005f7306ULL, 0x0003f0000020d400ULL, 0x0000003c00e67306ULL, 0x000fe20000209400ULL,
0x00000018ff277819ULL, 0x002fce0000011454ULL, 0x0000003c00e77306ULL, 0x000e700000205400ULL,
0x0000003c00a27306ULL, 0x0004f0000020d400ULL, 0x0000005e00be7306ULL, 0x000fe20000209400ULL,
0x000001004d3c7824ULL, 0x004fe200078e00ffULL, 0x000000e7e600720bULL, 0x002fcc0003f5d000ULL,
0x0000005e00c37306ULL, 0x000e6e0000205400ULL, 0x00000001a2a22812ULL, 0x008fe200078efcffULL,
0x0000005e007a7306ULL, 0x000eb0000020d400ULL, 0x0000005d00bf7306ULL, 0x000fe20000209400ULL,
0x000000c3be00720bULL, 0x002fe20003fdd000ULL, 0x0001000056be7824ULL, 0x000fca00078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe200000114beULL, 0x0000005d00c47306ULL, 0x000fec0000205400ULL,
0x000000017a7a6812ULL, 0x004fe400078efcffULL, 0x0000005d00757306ULL, 0x000ff0000020d400ULL,
0x0000003f009d7306ULL, 0x0002b0000000d400ULL, 0x00000027005d7306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000027005e7306ULL, 0x000fe20000205400ULL, 0x000000019d9d5812ULL, 0x004fe400078efcffULL,
0x000000d7d800720bULL, 0x000fca0003fbd000ULL, 0x0000002700677306ULL, 0x000ff0000020d400ULL,
0x00000077006a7306ULL, 0x000fe20000209400ULL, 0x0000000194945812ULL, 0x000fe400078efcffULL,
0x00000071d600720bULL, 0x000fca0003fbd000ULL, 0x00000077006b7306ULL, 0x000ff00000205400ULL,
0x0000007700277306ULL, 0x0003e2000020d400ULL, 0x0000000187875812ULL, 0x000fce00078efcffULL,
0x00000072009c7306ULL, 0x000ea2000020d400ULL, 0x00000018ff777819ULL, 0x002fce000001143cULL,
0x00000073003c7306ULL, 0x000ff00000209400ULL, 0x00000073003d7306ULL, 0x000e620000205400ULL,
0x000000019c9c3812ULL, 0x004fce00078efcffULL, 0x0000003f00e07306ULL, 0x000ff00000209400ULL,
0x0000003f00e17306ULL, 0x000ea20000205400ULL, 0x0000003d3c00720bULL, 0x002fce0003f7d000ULL,
0x0000007300987306ULL, 0x0002f0000020d400ULL, 0x0000004e00c17306ULL, 0x000fe20000009400ULL,
0x000000e1e000720bULL, 0x004fe20003f5d000ULL, 0x0000010059737824ULL, 0x002fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000004e00907306ULL, 0x000e620000005400ULL,
0x0000000198983812ULL, 0x008fce00078efcffULL, 0x0000007700de7306ULL, 0x000ff00000209400ULL,
0x0000007700df7306ULL, 0x000ea20000205400ULL, 0x00000090c100720bULL, 0x002fe20003f7d000ULL,
0x0000010057c17824ULL, 0x000fca00078e00ffULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000004e007d7306ULL, 0x0002f0000000d400ULL, 0x0000004d00267306ULL, 0x000fe20000009400ULL,
0x000100004e4e7824ULL, 0x002fe200078e00ffULL, 0x000000dfde00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000004d00d57306ULL, 0x000fe20000005400ULL,
0x000000017d7d3812ULL, 0x008fce00078efcffULL, 0x0000004d00897306ULL, 0x0003f0000000d400ULL,
0x0000003f00997306ULL, 0x000ea2000020d400ULL, 0x000100004d4d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe4000001144dULL, 0x0000004f00bc7306ULL, 0x000ff00000009400ULL,
0x0000004f00bd7306ULL, 0x000fe20000005400ULL, 0x0000000199992812ULL, 0x004fc400078efcffULL,
0x000000d52600720bULL, 0x000fca0003f5d000ULL, 0x0000004f00797306ULL, 0x0003f0000000d400ULL,
0x0000004e00cb7306ULL, 0x000fe20000209400ULL, 0x000100004f4f7824ULL, 0x002fe200078e00ffULL,
0x0000000189892812ULL, 0x000fc800078efcffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000004e00cc7306ULL, 0x000e700000205400ULL, 0x0000004e00857306ULL, 0x0004f0000020d400ULL,
0x0000007700967306ULL, 0x000962000020d400ULL, 0x000001005a4e7824ULL, 0x004fe200078e00ffULL,
0x000000cccb00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000072003e7306ULL, 0x000fe20000209400ULL, 0x00000018ff777819ULL, 0x010fcc000001144cULL,
0x0000000185853812ULL, 0x008fe200078efcffULL, 0x00000072003f7306ULL, 0x000e620000205400ULL,
0x0000000196964812ULL, 0x020fce00078efcffULL, 0x0000007800c97306ULL, 0x000ff00000209400ULL,
0x0000007800ca7306ULL, 0x000ea20000205400ULL, 0x0000003f3e00720bULL, 0x002fce0003f9d000ULL,
0x00000072008f7306ULL, 0x0002f0000020d400ULL, 0x0000004f00d17306ULL, 0x000fe20000209400ULL,
0x0000010058727824ULL, 0x002fe200078e00ffULL, 0x000000cac900720bULL, 0x004fc80003fbd000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000004f00d27306ULL, 0x000fe20000205400ULL,
0x000000018f8f4812ULL, 0x008fe400078efcffULL, 0x000000bdbc00720bULL, 0x000fe20003f9d000ULL,
0x0001000057bc7824ULL, 0x000fc800078e00ffULL, 0x0000004f00827306ULL, 0x0003e2000020d400ULL,
0x00000018ffbc7819ULL, 0x000fce00000114bcULL, 0x0000005900b57306ULL, 0x000fe20000009400ULL,
0x000001005b4f7824ULL, 0x002fe200078e00ffULL, 0x0000000179794812ULL, 0x000fc800078efcffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000005900b87306ULL, 0x000e700000005400ULL,
0x00000059005c7306ULL, 0x0004f0000000d400ULL, 0x00000077004c7306ULL, 0x000fe20000209400ULL,
0x0001000059597824ULL, 0x004fe200078e00ffULL, 0x000000b8b500720bULL, 0x002fc80003f7d000ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000077004d7306ULL, 0x000e6e0000205400ULL,
0x000000015c5c3812ULL, 0x008fe200078efcffULL, 0x0000007700887306ULL, 0x000ea2000020d400ULL,
0x000000aaa700720bULL, 0x000fce0003f7d000ULL, 0x0000004e00a97306ULL, 0x000fe20000209400ULL,
0x0000004d4c00720bULL, 0x002fca0003f5d000ULL, 0x0000000161613812ULL, 0x000fe400078efcffULL,
0x0000004e00b07306ULL, 0x000fec0000205400ULL, 0x0000000188882812ULL, 0x004fe400078efcffULL,
0x0000004e00777306ULL, 0x0003e2000020d400ULL, 0x000000c4bf00720bULL, 0x000fe20003f5d000ULL,
0x0000010056bf7824ULL, 0x000fe200078e00ffULL, 0x0000007d8888723eULL, 0x000fc800000010ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0000007200cd7306ULL, 0x000fe20000209400ULL,
0x00000100544e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000007200ce7306ULL, 0x000fe20000205400ULL, 0x0000000175752812ULL, 0x000fce00078efcffULL,
0x0000007200817306ULL, 0x000ff0000020d400ULL, 0x0000007800867306ULL, 0x000e70000020d400ULL,
0x0000004f00a17306ULL, 0x000ff00000209400ULL, 0x0000004f00a67306ULL, 0x000ea20000205400ULL,
0x0000000186865812ULL, 0x002fc400078efcffULL, 0x000000d2d100720bULL, 0x000fca0003fbd000ULL,
0x0000004f00727306ULL, 0x0002f0000020d400ULL, 0x0000005900c57306ULL, 0x000fe20000209400ULL,
0x00000006034f7811ULL, 0x002fe400078fe0ffULL, 0x0000000182825812ULL, 0x000fc400078efcffULL,
0x000000074f4f7812ULL, 0x000fe400078e7864ULL, 0x000000cecd00720bULL, 0x000fe20003fbd000ULL,
0x0000005900c67306ULL, 0x000fe20000205400ULL, 0x000000a6a100720bULL, 0x004fe20003f7d000ULL,
0x0000000864267824ULL, 0x000fca00078e024fULL, 0x0000a000263c7811ULL, 0x000fe200078e20ffULL,
0x0000005900787306ULL, 0x000fe8000020d400ULL, 0x0000000181815812ULL, 0x000fe200078efcffULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000afb400720bULL, 0x000fe40003fbd000ULL,
0x0000004e00917306ULL, 0x000fe20000209400ULL, 0x0000000172723812ULL, 0x008fc400078efcffULL,
0x000000807f00720bULL, 0x000fca0003f7d000ULL, 0x0000004e00927306ULL, 0x000fe60000205400ULL,
0x000000015f5f5812ULL, 0x000fe400078efcffULL, 0x000000b0a900720bULL, 0x000fc60003fbd000ULL,
0x0000004e00597306ULL, 0x0005e2000020d400ULL, 0x0000000169693812ULL, 0x000fce00078efcffULL,
0x0000005800b37306ULL, 0x000fe20000009400ULL, 0x0000a000254e7811ULL, 0x004fe400078e20ffULL,
0x0000000177775812ULL, 0x000fc800078efcffULL, 0x000000004e4c783bULL, 0x000ea20000000200ULL,
0x0000005800b67306ULL, 0x000ee20000005400ULL, 0x000000a03d3d9231ULL, 0x082fe400003400ffULL,
0x000000a03f3f9231ULL, 0x000fca00003400ffULL, 0x0000005800747306ULL, 0x000322000000d400ULL,
0x0000009f3c3c9231ULL, 0x080fe400003400ffULL, 0x0000009f3e3e9231ULL, 0x000fca00003400ffULL,
0x0000005a00b77306ULL, 0x000fe20000009400ULL, 0x0001000058587824ULL, 0x002fe200078e00ffULL,
0x000000b6b300720bULL, 0x008fc80003f9d000ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000005a00ba7306ULL, 0x000e6e0000005400ULL, 0x0000000174744812ULL, 0x010fe200078efcffULL,
0x0000007300cf7306ULL, 0x000fe60000209400ULL, 0x000000748174723eULL, 0x000fe200000010ffULL,
0x0000009f4c4c9231ULL, 0x004fc800003400ffULL, 0x0000007300d07306ULL, 0x000ea20000205400ULL,
0x000000bab700720bULL, 0x002fe20003fdd000ULL, 0x0000009f4e4e9231ULL, 0x000fe400003400ffULL,
0x000000a04d4d9231ULL, 0x080fe400003400ffULL, 0x000000a04f4f9231ULL, 0x000fe400003400ffULL,
0x0000005800c77306ULL, 0x000fea0000209400ULL, 0x000000464c40723cULL, 0x000fe60000041840ULL,
0x0000005800c87306ULL, 0x000e620000205400ULL, 0x000000d0cf00720bULL, 0x004fc60003f5d000ULL,
0x000000a49746723eULL, 0x000fe400000010ffULL, 0x000000999447723eULL, 0x000fe400000010ffULL,
0x0000005a00607306ULL, 0x0004ea000000d400ULL, 0x000000464c50723cULL, 0x000fe60000041850ULL,
0x00000073007b7306ULL, 0x000f22000020d400ULL, 0x000100005a5a7824ULL, 0x004fe200078e00ffULL,
0x000000c8c700720bULL, 0x002fc40003f9d000ULL, 0x000000988746723eULL, 0x000fe400000010ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x0000005b00b97306ULL, 0x000fe20000009400ULL,
0x0000000160606812ULL, 0x008fe400078efcffULL, 0x0000008b8a00720bULL, 0x000fe40003fdd000ULL,
0x0000008f7e47723eULL, 0x000fc600000010ffULL, 0x0000005b00d47306ULL, 0x000e620000005400ULL,
0x000000017b7b2812ULL, 0x010fe400078efcffULL, 0x000000c6c500720bULL, 0x000fe20003f5d000ULL,
0x000000464c30723cULL, 0x000fe80000041830ULL, 0x0000005b00737306ULL, 0x0005e2000000d400ULL,
0x000000016d6d6812ULL, 0x000fe400078efcffULL, 0x000000929100720bULL, 0x000fca0003fdd000ULL,
0x00000058007c7306ULL, 0x000ee2000020d400ULL, 0x000100005b5b7824ULL, 0x004fe200078e00ffULL,
0x0000000178782812ULL, 0x000fe400078efcffULL, 0x000000d4b900720bULL, 0x002fe40003f3d000ULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x0000005400ab7306ULL, 0x000fe20000009400ULL,
0x00000078617d723eULL, 0x000fe400000010ffULL, 0x0000000159596812ULL, 0x000fc400078efcffULL,
0x0000005e5d00720bULL, 0x000fc60003fdd000ULL, 0x0000005400b27306ULL, 0x000e620000005400ULL,
0x000000017c7c4812ULL, 0x008fe400078efcffULL, 0x0000000173731812ULL, 0x000fe400078efcffULL,
0x0000007c5f7c723eULL, 0x000fc600000010ffULL, 0x0000005400587306ULL, 0x0004e4000000d400ULL,
0x0000000167676812ULL, 0x000fe400078efcffULL, 0x0000006f6e00720bULL, 0x000fc80003fdd000ULL,
0x0000005a009b7306ULL, 0x000fe20000209400ULL, 0x0001000054547824ULL, 0x004fe200078e00ffULL,
0x000000b2ab00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005a009e7306ULL, 0x000e620000205400ULL, 0x0000000165656812ULL, 0x000fcc00078efcffULL,
0x0000000158584812ULL, 0x008fe200078efcffULL, 0x0000005a00767306ULL, 0x000eb0000020d400ULL,
0x0000005b00957306ULL, 0x000fe20000209400ULL, 0x0000009e9b00720bULL, 0x002fce0003fbd000ULL,
0x0000005b009a7306ULL, 0x000e6c0000205400ULL, 0x0000000176765812ULL, 0x004fe400078efcffULL,
0x0000005b005a7306ULL, 0x0004e4000020d400ULL, 0x000000766d76723eULL, 0x000fcc00000010ffULL,
0x0000005500a37306ULL, 0x000fe20000009400ULL, 0x00000100555b7824ULL, 0x004fe200078e00ffULL,
0x0000009a9500720bULL, 0x002fc80003f3d000ULL, 0x00000018ffd77819ULL, 0x000fe4000001145bULL,
0x0000005500a87306ULL, 0x000e6e0000005400ULL, 0x000000015a5a1812ULL, 0x008fe200078efcffULL,
0x0000005500707306ULL, 0x0004f0000000d400ULL, 0x00000056008c7306ULL, 0x000fe20000009400ULL,
0x0001000055557824ULL, 0x004fe200078e00ffULL, 0x000000a8a300720bULL, 0x002fcc0003f5d000ULL,
0x00000056008d7306ULL, 0x000e6e0000005400ULL, 0x0000000170702812ULL, 0x008fe200078efcffULL,
0x00000056006c7306ULL, 0x0004e2000000d400ULL, 0x000000636200720bULL, 0x000fce0003f5d000ULL,
0x0000005400907306ULL, 0x000fe20000209400ULL, 0x00000018ff567819ULL, 0x004fe40000011455ULL,
0x000000adc055723eULL, 0x000fe400000010ffULL, 0x0000008d8c00720bULL, 0x002fe40003fbd000ULL,
0x0000000166662812ULL, 0x000fe200078efcffULL, 0x0000005400bd7306ULL, 0x000e700000205400ULL,
0x0000005400647306ULL, 0x000524000020d400ULL, 0x000000016c6c5812ULL, 0x008fcc00078efcffULL,
0x000000d7005b7306ULL, 0x000fe20000209400ULL, 0x000000b1c254723eULL, 0x004fe400000010ffULL,
0x000000bd9000720bULL, 0x002fca0003f9d000ULL, 0x000000d7008e7306ULL, 0x000e620000205400ULL,
0x000000544c48723cULL, 0x000fee0000041848ULL, 0x000000a5ac54723eULL, 0x000fe200000010ffULL,
0x000000d700717306ULL, 0x000ea2000020d400ULL, 0x0000009da255723eULL, 0x000fc400000010ffULL,
0x0000000164644812ULL, 0x010fe400078efcffULL, 0x0000008e5b00720bULL, 0x002fc60003f7d000ULL,
0x000000544c38723cULL, 0x000fe20000041838ULL, 0x0000005600b37306ULL, 0x000fec0000209400ULL,
0x000000939c54723eULL, 0x000fe400000010ffULL, 0x000000899655723eULL, 0x000fe200000010ffULL,
0x0000005600b67306ULL, 0x000e620000205400ULL, 0x000000798689723eULL, 0x000fc400000010ffULL,
0x0000000171713812ULL, 0x004fca00078efcffULL, 0x000000bf00a07306ULL, 0x000fe20000209400ULL,
0x000000884c28723cULL, 0x000fee0000041828ULL, 0x000000bf009d7306ULL, 0x000ea20000205400ULL,
0x000000b6b300720bULL, 0x002fce0003f7d000ULL, 0x0000005700837306ULL, 0x000ff00000009400ULL,
0x0000005700847306ULL, 0x000e620000005400ULL, 0x0000009da000720bULL, 0x004fce0003f9d000ULL,
0x0000005700687306ULL, 0x000eb0000000d400ULL, 0x00000056009f7306ULL, 0x000722000020d400ULL,
0x000000848300720bULL, 0x002fce0003f3d000ULL, 0x000000bf00977306ULL, 0x000e62000020d400ULL,
0x000000544c54723cULL, 0x008fea0000041834ULL, 0x0000000168681812ULL, 0x004fe400078efcffULL,
0x000000857a34723eULL, 0x000fe200000010ffULL, 0x000000c100937306ULL, 0x000fe20000209400ULL,
0x000000827535723eULL, 0x000fc400000010ffULL, 0x0000005c7b75723eULL, 0x000fe400000010ffULL,
0x000000019f9f3812ULL, 0x010fe400078efcffULL, 0x0000000197974812ULL, 0x002fe200078efcffULL,
0x000000344c2c723cULL, 0x000fe2000004182cULL, 0x000000c1007e7306ULL, 0x000e620000205400ULL,
0x0000006b6a00720bULL, 0x000fca0003f7d000ULL, 0x000000607734723eULL, 0x000fe200000010ffULL,
0x000000743c5c723cULL, 0x000fe20000041848ULL, 0x000000be00467306ULL, 0x000fe20000209400ULL,
0x000000737235723eULL, 0x000fe400000010ffULL, 0x0000005a6977723eULL, 0x000fc600000010ffULL,
0x0000000127273812ULL, 0x000fe200078efcffULL, 0x0000007c3c60723cULL, 0x000fe20000041840ULL,
0x000000be00477306ULL, 0x000ea20000205400ULL, 0x0000007e9300720bULL, 0x002fe40003f5d000ULL,
0x0000009f6649723eULL, 0x000fc600000010ffULL, 0x0000006c9740723eULL, 0x000fe200000010ffULL,
0x000000343c34723cULL, 0x040fe20000041838ULL, 0x000000bc00487306ULL, 0x000fec0000209400ULL,
0x000000585938723eULL, 0x000fe400000010ffULL, 0x000000bc00417306ULL, 0x000e620000205400ULL,
0x000000474600720bULL, 0x004fe20003f9d000ULL, 0x000000763c58723cULL, 0x000fe20000041850ULL,
0x000000707139723eULL, 0x000fca00000010ffULL, 0x000000c100797306ULL, 0x000ea4000020d400ULL,
0x000000383c50723cULL, 0x000fec0000041854ULL, 0x000000be00be7306ULL, 0x000ee2000020d400ULL,
0x000000414800720bULL, 0x002fe40003fbd000ULL, 0x000000646748723eULL, 0x000fca00000010ffULL,
0x000000bc00bc7306ULL, 0x000e62000020d400ULL, 0x0000000179792812ULL, 0x004fe200078efcffULL,
0x000000483c48723cULL, 0x000fe60000041830ULL, 0x000000687941723eULL, 0x000fe400000010ffULL,
0x00000001bebe4812ULL, 0x008fc800078efcffULL, 0x000000be65be723eULL, 0x000fe200000010ffULL,
0x000000403c40723cULL, 0x000fe20000041828ULL, 0x00000001bcbc5812ULL, 0x002fc800078efcffULL,
0x000000bc27bf723eULL, 0x000fce00000010ffULL, 0x000000be3c3c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff287f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004005277811ULL, 0x000fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff2d7224ULL, 0x002fe400078e0029ULL, 0x000000270400720cULL, 0x000fda0003f24070ULL,
0x0000efe000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe4000782482dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe4000782482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a00277305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x000000270000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc4000782482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300ff277624ULL, 0x000fe200078e00ffULL,
0x00000001080a7812ULL, 0x000fc800078ec0ffULL, 0x000000010a00780cULL, 0x000fe20003f25070ULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0xffffffff27277811ULL, 0x000fc800078e08ffULL,
0x0000000127277807ULL, 0x000fca0004800000ULL, 0x0000000108087824ULL, 0x000fca00078e0227ULL,
0x000000060800720cULL, 0x000fe40003f26070ULL, 0x00000004ff4c7819ULL, 0x000fe40000011603ULL,
0x00000060002c7811ULL, 0x000fd200078e38ffULL, 0x000000270d289210ULL, 0x000fe20007ffe00eULL,
0x00000004ff299424ULL, 0x000fe200078e00ffULL, 0x000000092c2d7210ULL, 0x000fc60007ffe04cULL,
0x0000600028289625ULL, 0x000fe200078e0029ULL, 0x00000060052b7811ULL, 0x000fc800078e40ffULL,
0x00000006280a9981ULL, 0x000362000c1e1900ULL, 0x0000002d442d7210ULL, 0x000fe40007f3e0ffULL,
0x0000002b042a7217ULL, 0x000fe40007800000ULL, 0x0000000403467811ULL, 0x040fe200078fe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00000006033a7811ULL, 0x000fe200078fe0ffULL,
0x000000012a2a7824ULL, 0x000fe200078e0a2bULL, 0x000000024c4e7810ULL, 0x000fe40007ffe0ffULL,
0x00005e002d387a11ULL, 0x000fc400078240ffULL, 0x000000462c297210ULL, 0x142fe20007ffe009ULL,
0x0000000109287824ULL, 0x000fe200078e024eULL, 0x0000003a2c2b7210ULL, 0x000fe40007ffe009ULL,
0x00005f002d2f7a11ULL, 0x000fe400008f442eULL, 0x00000029442d7210ULL, 0x000fe20007f3e0ffULL,
0x0000000128297824ULL, 0x000fe200078e022cULL, 0x0000002b442b7210ULL, 0x000fe40007f7e0ffULL,
0x000000202a2a7807ULL, 0x000fe20000000000ULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x0000002944447210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x0000002a092a7217ULL, 0x000fc40007800000ULL, 0x00005e002b307a11ULL, 0x000fe400078640ffULL,
0x00005e002d2e7a11ULL, 0x000fe200078440ffULL, 0x000000012a297824ULL, 0x000fe200078e0a09ULL,
0x00005f002b317a11ULL, 0x000fe200018f442cULL, 0x000000ffff2b7224ULL, 0x000fe200008e06ffULL,
0x00005e00442c7a11ULL, 0x000fe400078640ffULL, 0x0000000f382a7210ULL, 0x000fe40007f9e0ffULL,
0x00005f002d2d7a11ULL, 0x000fc400010f4432ULL, 0x0000000f2e2e7210ULL, 0x000fe40007fde0ffULL,
0x000000294c00720cULL, 0x000fe40003f46070ULL, 0x00005f0044327a11ULL, 0x000fe200018f442bULL,
0x000000ffff2b7224ULL, 0x000fe200020e062fULL, 0x0000000f2c2c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2f7224ULL, 0x000fe200030e062dULL, 0x000000294e00720cULL, 0x080fe40003f26070ULL,
0x000000294600720cULL, 0x080fe20003f66070ULL, 0x000000ffff2d7224ULL, 0x000fe200028e0632ULL,
0x000000293a00720cULL, 0x000fc40003f86070ULL, 0x0000000f30307210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a107faeULL, 0x0003e8000d101c46ULL,
0x000000ffff317224ULL, 0x000fe400028e0631ULL, 0x000000002c117faeULL, 0x0003e8000c901c46ULL,
0x000000002e127faeULL, 0x0003e8000d901c46ULL, 0x0000000030137faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff4c7f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff2c7984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01062800092a7f8cULL, 0x000fe2000c80043fULL, 0x800000002cff7812ULL, 0x002fc60007844845ULL,
0x01062c0009297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000782482bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff297424ULL, 0x000fc800078e00ffULL,
0x00000029002c7305ULL, 0x0002e4000021f000ULL, 0x3fa0000029297823ULL, 0x002fe200000100ffULL,
0x0000002c0000735dULL, 0x008fe20003800000ULL, 0x01062c00092d7984ULL, 0x000e640000000800ULL,
0x800000002dff7812ULL, 0x002fc4000782482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01008000142a7984ULL, 0x000e680000000800ULL, 0x0102800014297984ULL, 0x0007220000000800ULL,
0x0000000b2a00720bULL, 0x002fe20003f3d000ULL, 0x000180927f007947ULL, 0x000fd8000b800000ULL,
0x00000000002b7806ULL, 0x008fc800008e0100ULL, 0x0000ffff2b2e7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ffba7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000010200780cULL, 0x000fe40003f65270ULL,
0x0000000b2a00720bULL, 0x000fe20003f34000ULL, 0x000180727f007947ULL, 0x000fd8000b800000ULL,
0x00000000002b7806ULL, 0x000fe400008e0100ULL, 0x0000002a0b2c7209ULL, 0x000fe40007810000ULL,
0x0000ffff2b2b7812ULL, 0x000fe400078e3cffULL, 0x00000002ff6f7819ULL, 0x000fe20000011603ULL,
0x8000002c0b2d7221ULL, 0x000fe20000010000ULL, 0x0104802c1400b388ULL, 0x0003e20000000800ULL,
0x0000002b2eff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b2d2d7820ULL, 0x000fc80000410000ULL,
0x0000002d00687308ULL, 0x000ee40000000800ULL, 0x000000680c0c7220ULL, 0x008fe20000410000ULL,
0x000180227f007947ULL, 0x000fea000b800000ULL, 0x00001f6f68677589ULL, 0x0022e400000e0000ULL,
0x000000675c5c7220ULL, 0x08cfe40000410000ULL, 0x000000675d5d7220ULL, 0x080fe40000410000ULL,
0x0000006760607220ULL, 0x080fe40000410000ULL, 0x0000006761617220ULL, 0x080fe40000410000ULL,
0x0000006734347220ULL, 0x000fc40000410000ULL, 0x0000006735357220ULL, 0x080fe40000410000ULL,
0x0000006758587220ULL, 0x080fe40000410000ULL, 0x0000006759597220ULL, 0x080fe40000410000ULL,
0x0000006750507220ULL, 0x080fe40000410000ULL, 0x0000006751517220ULL, 0x080fe40000410000ULL,
0x0000006748487220ULL, 0x000fc40000410000ULL, 0x0000006749497220ULL, 0x080fe40000410000ULL,
0x0000006740407220ULL, 0x080fe40000410000ULL, 0x0000006741417220ULL, 0x080fe40000410000ULL,
0x000000673c3c7220ULL, 0x080fe40000410000ULL, 0x000000673d3d7220ULL, 0x000fe20000410000ULL,
0x00017f527f007947ULL, 0x000fea000b800000ULL, 0x00001ff468677589ULL, 0x0004e400000e0000ULL,
0x0000002a0b0b7209ULL, 0x000fe20007810000ULL, 0x000000675e5e7220ULL, 0x08cfe20000410000ULL,
0x00000001ffba7807ULL, 0x000fe20000800000ULL, 0x000000675f5f7220ULL, 0x000fc40000410000ULL,
0x8000000b2a2a1221ULL, 0x000fe40000010000ULL, 0x0000006762627220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b2a2a1820ULL, 0x000fe40000410000ULL, 0x0000006763637220ULL, 0x080fe40000410000ULL,
0x0000002a00151308ULL, 0x000ea20000000800ULL, 0x0000006736367220ULL, 0x080fe40000410000ULL,
0x0000006737377220ULL, 0x000fc40000410000ULL, 0x000000675a5a7220ULL, 0x080fe40000410000ULL,
0x000000675b5b7220ULL, 0x080fe40000410000ULL, 0x0000006752527220ULL, 0x080fe40000410000ULL,
0x0000006753537220ULL, 0x080fe40000410000ULL, 0x000000674a4a7220ULL, 0x080fe40000410000ULL,
0x000000674b4b7220ULL, 0x000fc40000410000ULL, 0x0000006742427220ULL, 0x080fe40000410000ULL,
0x0000006743437220ULL, 0x080fe40000410000ULL, 0x000000673e3e7220ULL, 0x080fe40000410000ULL,
0x000000673f3f7220ULL, 0x000fe40000410000ULL, 0x0000002915291220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000c290c7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff2a7984ULL, 0x000ee40000000800ULL, 0x800000002aff7812ULL, 0x008fc40007824845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff297424ULL, 0x000fc800078e00ffULL, 0x00000029002a7305ULL, 0x000724000021f000ULL,
0x3fa0000029297823ULL, 0x008fe200000100ffULL, 0x0000002a0000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff2a7984ULL, 0x000ee40000000800ULL, 0x800000002aff7812ULL, 0x008fe40007824845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff29723eULL, 0x000fe400000010ffULL,
0x00000002ff6f7819ULL, 0x002fc40000011603ULL, 0x0000541029687816ULL, 0x000fe20000000029ULL,
0x00017cf27f007947ULL, 0x000fea000b800000ULL, 0x00001f6f68747589ULL, 0x0002e400000e0000ULL,
0x00017d327f007947ULL, 0x000fea000b800000ULL, 0x00001ff4686b7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f9ULL,
0x00006fa000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00018ad000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f7ULL,
0x0000700000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00018a7000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001644783bULL, 0x000f220000004200ULL,
0x00009910baba7816ULL, 0x000fc600000000ffULL, 0x000000001738783bULL, 0x000ee80000004200ULL,
0x000000001830783bULL, 0x000ea20000004200ULL, 0x00000018ff2c7819ULL, 0x010fe20000011445ULL,
0x00000100446f7824ULL, 0x002fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe20000011446ULL,
0x0000004400f27306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x000fe40000011447ULL,
0x00000018ff297819ULL, 0x000fc40000011444ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff4e7819ULL, 0x008fe20000011439ULL, 0x0000002c00727306ULL, 0x000fe20000209400ULL,
0x00000018ff4f7819ULL, 0x000fe4000001143aULL, 0x00000018ff547819ULL, 0x000fe4000001143bULL,
0x00000018ff577819ULL, 0x004fc60000011433ULL, 0x0000002c00737306ULL, 0x000ff00000205400ULL,
0x0000002c00a37306ULL, 0x000ff0000020d400ULL, 0x0000002d00c67306ULL, 0x000ff00000209400ULL,
0x0000002d00977306ULL, 0x000ff00000205400ULL, 0x0000002d00997306ULL, 0x000ff0000020d400ULL,
0x0000002e00c47306ULL, 0x000ff00000209400ULL, 0x0000002e00c37306ULL, 0x000ff00000205400ULL,
0x0000002e00907306ULL, 0x0003f0000020d400ULL, 0x0000002900ee7306ULL, 0x000fe20000209400ULL,
0x00000000192c783bULL, 0x002e6e0000004200ULL, 0x0000002900ef7306ULL, 0x000eb00000205400ULL,
0x0000006f00917306ULL, 0x000ff00000209400ULL, 0x0000006f00f87306ULL, 0x000ee20000205400ULL,
0x000000efee00720bULL, 0x004fce0003fbd000ULL, 0x0000006f00b67306ULL, 0x000530000020d400ULL,
0x0000004e00807306ULL, 0x000fe20000209400ULL, 0x00000100466f7824ULL, 0x004fe200078e00ffULL,
0x00000018ff707819ULL, 0x002fc4000001142dULL, 0x00000018ff717819ULL, 0x000fe4000001142eULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000004e00bc7306ULL, 0x000fe20000205400ULL,
0x000000f89100720bULL, 0x008fe40003f9d000ULL, 0x00000018ff777819ULL, 0x000fca000001142fULL,
0x0000004e00837306ULL, 0x0003ec000020d400ULL, 0x00000001b6b64812ULL, 0x010fe400078efcffULL,
0x0000004f00ad7306ULL, 0x000fe20000209400ULL, 0x00000018ff4e7819ULL, 0x002fe40000011431ULL,
0x000000737200720bULL, 0x000fca0003f9d000ULL, 0x0000004f00a77306ULL, 0x000ff00000205400ULL,
0x0000004f00797306ULL, 0x0003e2000020d400ULL, 0x00000001a3a34812ULL, 0x000fe400078efcffULL,
0x00000097c600720bULL, 0x000fca0003f9d000ULL, 0x0000004400927306ULL, 0x000ea20000005400ULL,
0x00000018ff4f7819ULL, 0x002fce0000011432ULL, 0x00000044002a7306ULL, 0x0002e2000000d400ULL,
0x0000000199994812ULL, 0x000fce00078efcffULL, 0x0000004e00af7306ULL, 0x000fe20000209400ULL,
0x0001000044447824ULL, 0x002fe200078e00ffULL, 0x00000092f200720bULL, 0x004fcc0003f7d000ULL,
0x0000004e00a87306ULL, 0x000fee0000205400ULL, 0x000000012a2a3812ULL, 0x008fe200078efcffULL,
0x0000004e00687306ULL, 0x000fe6000020d400ULL, 0x0000002ab62a723eULL, 0x000fca00000010ffULL,
0x0000004f009a7306ULL, 0x000ff00000209400ULL, 0x0000004f00987306ULL, 0x000ff00000205400ULL,
0x0000004f00667306ULL, 0x000ff0000020d400ULL, 0x0000007000697306ULL, 0x000ff00000209400ULL,
0x00000070006a7306ULL, 0x000ff00000205400ULL, 0x00000070004f7306ULL, 0x0003f0000020d400ULL,
0x0000007100567306ULL, 0x000fe20000209400ULL, 0x00000018ff707819ULL, 0x002fce0000011444ULL,
0x0000007100647306ULL, 0x000ff00000205400ULL, 0x00000071004e7306ULL, 0x0003f0000020d400ULL,
0x0000004500f17306ULL, 0x000fe20000009400ULL, 0x0000010045717824ULL, 0x002fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000004500887306ULL, 0x000e700000005400ULL,
0x00000045002b7306ULL, 0x0004f0000000d400ULL, 0x0000002900a47306ULL, 0x0008e2000020d400ULL,
0x0001000045457824ULL, 0x004fe200078e00ffULL, 0x00000088f100720bULL, 0x002fc80003f3d000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000006f00967306ULL, 0x000fe20000209400ULL,
0x00000018ff297819ULL, 0x010fcc0000011438ULL, 0x000000012b2b1812ULL, 0x008fe200078efcffULL,
0x0000006f00e67306ULL, 0x000e620000205400ULL, 0x00000001a4a45812ULL, 0x000fce00078efcffULL,
0x0000007000447306ULL, 0x000ff00000209400ULL, 0x0000007000f37306ULL, 0x000ea20000205400ULL,
0x000000e69600720bULL, 0x002fce0003fbd000ULL, 0x0000007000a67306ULL, 0x0002f0000020d400ULL,
0x0000004700cd7306ULL, 0x000fe20000009400ULL, 0x0000010047707824ULL, 0x002fe200078e00ffULL,
0x000000f34400720bULL, 0x004fc80003fdd000ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000004700ce7306ULL, 0x000fee0000005400ULL, 0x00000001a6a66812ULL, 0x008fe200078efcffULL,
0x00000047009b7306ULL, 0x0003f0000000d400ULL, 0x0000004500ec7306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x002fce00078e00ffULL, 0x0000004500ed7306ULL, 0x000e700000205400ULL,
0x0000004500a57306ULL, 0x0005f0000020d400ULL, 0x0000006f00a27306ULL, 0x000722000020d400ULL,
0x00000018ff457819ULL, 0x004fe20000011447ULL, 0x0000010038477824ULL, 0x000fe200078e00ffULL,
0x000000edec00720bULL, 0x002fca0003fdd000ULL, 0x0000004500e77306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x008fe20000011447ULL, 0x0000010039477824ULL, 0x000fcc00078e00ffULL,
0x0000004500e87306ULL, 0x000e620000205400ULL, 0x00000001a2a25812ULL, 0x010fe400078efcffULL,
0x00000001a5a56812ULL, 0x000fca00078efcffULL, 0x0000003800c57306ULL, 0x000ff00000009400ULL,
0x0000003800a17306ULL, 0x000fe20000005400ULL, 0x000000e8e700720bULL, 0x002fce0003fbd000ULL,
0x00000038008d7306ULL, 0x0003f0000000d400ULL, 0x0000004600897306ULL, 0x000fe20000009400ULL,
0x0001000038387824ULL, 0x002fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000004600f07306ULL, 0x000e700000005400ULL, 0x0000004600a07306ULL, 0x0005f0000000d400ULL,
0x0000004500947306ULL, 0x000722000020d400ULL, 0x0001000046467824ULL, 0x004fe200078e00ffULL,
0x000000f08900720bULL, 0x002fc80003f5d000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000003800de7306ULL, 0x000fe20000209400ULL, 0x000001003a457824ULL, 0x008fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000003800df7306ULL, 0x000e620000205400ULL,
0x0000000194945812ULL, 0x010fe400078efcffULL, 0x00000001a0a02812ULL, 0x000fe400078efcffULL,
0x000000c3c400720bULL, 0x000fc60003f5d000ULL, 0x0000004600da7306ULL, 0x000ff00000209400ULL,
0x0000004600db7306ULL, 0x000ea20000205400ULL, 0x000000dfde00720bULL, 0x002fe40003fbd000ULL,
0x0000000190902812ULL, 0x000fca00078efcffULL, 0x00000046009e7306ULL, 0x0002f0000020d400ULL,
0x0000007100957306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x002fe40000011447ULL,
0x000000dbda00720bULL, 0x004fca0003fdd000ULL, 0x0000007100eb7306ULL, 0x000e700000205400ULL,
0x00000038008b7306ULL, 0x000522000020d400ULL, 0x000000019e9e6812ULL, 0x008fce00078efcffULL,
0x0000004600477306ULL, 0x000fe20000209400ULL, 0x0000010030387824ULL, 0x004fe200078e00ffULL,
0x000000eb9500720bULL, 0x002fc80003f7d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000004600d57306ULL, 0x000e620000205400ULL, 0x000000018b8b5812ULL, 0x010fce00078efcffULL,
0x0000004500e27306ULL, 0x000ff00000209400ULL, 0x0000004500e37306ULL, 0x000ea20000205400ULL,
0x000000d54700720bULL, 0x002fce0003f9d000ULL, 0x00000046008c7306ULL, 0x0002f0000020d400ULL,
0x0000003b00c07306ULL, 0x000fe20000009400ULL, 0x000001003b467824ULL, 0x002fe200078e00ffULL,
0x000000e3e200720bULL, 0x004fc80003fbd000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000003b00b97306ULL, 0x000e620000005400ULL, 0x000000018c8c4812ULL, 0x008fce00078efcffULL,
0x0000003b007c7306ULL, 0x0004f0000000d400ULL, 0x0000007000d87306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x004fe200078e00ffULL, 0x000000b9c000720bULL, 0x002fc80003f9d000ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000007000d97306ULL, 0x000e6e0000205400ULL,
0x000000017c7c4812ULL, 0x008fe200078efcffULL, 0x0000007100b57306ULL, 0x000eb0000020d400ULL,
0x0000004500867306ULL, 0x000ee2000020d400ULL, 0x000000d9d800720bULL, 0x002fce0003f3d000ULL,
0x0000003900c17306ULL, 0x000fe20000009400ULL, 0x00000001b5b53812ULL, 0x004fe400078efcffULL,
0x000000cecd00720bULL, 0x000fe40003f7d000ULL, 0x0000002bb52b723eULL, 0x000fc600000010ffULL,
0x0000003900c27306ULL, 0x000e620000005400ULL, 0x0000000186865812ULL, 0x008fce00078efcffULL,
0x0000003b00c77306ULL, 0x000fe20000209400ULL, 0x000000019b9b3812ULL, 0x000fce00078efcffULL,
0x0000003b00c87306ULL, 0x000ea20000205400ULL, 0x000000c2c100720bULL, 0x002fce0003fdd000ULL,
0x0000002900be7306ULL, 0x000ff00000209400ULL, 0x0000002900bb7306ULL, 0x000e620000205400ULL,
0x000000c8c700720bULL, 0x004fce0003fbd000ULL, 0x0000002900847306ULL, 0x0004f0000020d400ULL,
0x0000003000b17306ULL, 0x000fe20000009400ULL, 0x00000018ff297819ULL, 0x004fe40000011430ULL,
0x000000bbbe00720bULL, 0x002fca0003f5d000ULL, 0x0000003000aa7306ULL, 0x000ff00000005400ULL,
0x0000003000757306ULL, 0x0003e2000000d400ULL, 0x0000000184842812ULL, 0x008fc800078efcffULL,
0x0000008b8484723eULL, 0x000fc600000010ffULL, 0x0000003900857306ULL, 0x0004e2000000d400ULL,
0x0001000030307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003800c97306ULL, 0x000fe20000209400ULL, 0x0001000039397824ULL, 0x004fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003800ca7306ULL, 0x000fe20000205400ULL,
0x0000000185856812ULL, 0x008fe400078efcffULL, 0x000000bc8000720bULL, 0x000fca0003fdd000ULL,
0x00000038007e7306ULL, 0x0003f0000020d400ULL, 0x00000070009f7306ULL, 0x000ea2000020d400ULL,
0x0000010032387824ULL, 0x002fe200078e00ffULL, 0x0000000183836812ULL, 0x000fc400078efcffULL,
0x000000a7ad00720bULL, 0x000fe20003fdd000ULL, 0x000000ffffa77224ULL, 0x000fc600078e00baULL,
0x0000003000cf7306ULL, 0x000ff00000209400ULL, 0x0000003000d07306ULL, 0x000fe20000205400ULL,
0x000000019f9f1812ULL, 0x004fe400078efcffULL, 0x000000a1c500720bULL, 0x000fc40003f3d000ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x000000cac900720bULL, 0x000fe20003fdd000ULL,
0x00000030007b7306ULL, 0x0003f0000020d400ULL, 0x0000006f00dc7306ULL, 0x000fe20000209400ULL,
0x00000018ff307819ULL, 0x002fe20000011438ULL, 0x0000010033387824ULL, 0x000fe200078e00ffULL,
0x000000018d8d1812ULL, 0x000fc400078efcffULL, 0x000000017e7e6812ULL, 0x000fc600078efcffULL,
0x0000006f00dd7306ULL, 0x000e700000205400ULL, 0x0000003b00817306ULL, 0x000eb0000020d400ULL,
0x0000005400b47306ULL, 0x000fe20000209400ULL, 0x000000dddc00720bULL, 0x002fce0003f7d000ULL,
0x0000005400ab7306ULL, 0x000e620000205400ULL, 0x0000000181815812ULL, 0x004fe400078efcffULL,
0x000000d0cf00720bULL, 0x000fca0003fbd000ULL, 0x0000003900e07306ULL, 0x000ff00000209400ULL,
0x0000003900e17306ULL, 0x000fe20000205400ULL, 0x000000abb400720bULL, 0x002fe20003f9d000ULL,
0x000100002eab7824ULL, 0x000fe200078e00ffULL, 0x000000017b7b5812ULL, 0x000fc400078efcffULL,
0x000000a8af00720bULL, 0x000fe40003fbd000ULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x00000039008a7306ULL, 0x0003f0000020d400ULL, 0x0000003100a97306ULL, 0x000fe20000009400ULL,
0x0000010031397824ULL, 0x002fe200078e00ffULL, 0x0000000168685812ULL, 0x000fc800078efcffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003100ac7306ULL, 0x000ff00000005400ULL,
0x0000003100767306ULL, 0x0003f0000000d400ULL, 0x0000003000cb7306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000cc7306ULL, 0x000ff00000205400ULL, 0x0000003000787306ULL, 0x0003f0000020d400ULL,
0x0000002900b27306ULL, 0x000fe20000209400ULL, 0x000001002c307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000002900b37306ULL, 0x000ff00000205400ULL,
0x00000029006c7306ULL, 0x0003f0000020d400ULL, 0x0000003200b07306ULL, 0x000fe20000009400ULL,
0x00000018ff297819ULL, 0x002fce000001142cULL, 0x0000003200ae7306ULL, 0x000e700000005400ULL,
0x0000003200677306ULL, 0x0004f0000000d400ULL, 0x0000003300d37306ULL, 0x000fe20000009400ULL,
0x0001000032327824ULL, 0x004fe200078e00ffULL, 0x000000aeb000720bULL, 0x002fc80003fdd000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003300d47306ULL, 0x000fee0000005400ULL,
0x0000000167676812ULL, 0x008fe200078efcffULL, 0x0000003300717306ULL, 0x0003f0000000d400ULL,
0x00000054007a7306ULL, 0x000ea2000020d400ULL, 0x0001000033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x00000057008f7306ULL, 0x000ff00000209400ULL,
0x00000057008e7306ULL, 0x000fe20000205400ULL, 0x000000017a7a4812ULL, 0x004fc400078efcffULL,
0x000000aca900720bULL, 0x000fca0003f9d000ULL, 0x0000005700557306ULL, 0x000ff0000020d400ULL,
0x00000029006d7306ULL, 0x000fe20000209400ULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x000000cccb00720bULL, 0x000fca0003f9d000ULL, 0x00000029006e7306ULL, 0x000ff00000205400ULL,
0x0000002900547306ULL, 0x000fe2000020d400ULL, 0x0000000178784812ULL, 0x000fe400078efcffULL,
0x000000989a00720bULL, 0x000fca0003f9d000ULL, 0x0000007700657306ULL, 0x000ff00000209400ULL,
0x0000007700577306ULL, 0x000fe20000205400ULL, 0x0000000166664812ULL, 0x000fce00078efcffULL,
0x0000007700297306ULL, 0x000ff0000020d400ULL, 0x0000006f00937306ULL, 0x000e70000020d400ULL,
0x0000003a00bd7306ULL, 0x000ff00000009400ULL, 0x0000003a00bf7306ULL, 0x000ea20000005400ULL,
0x0000000193933812ULL, 0x002fc400078efcffULL, 0x000000e1e000720bULL, 0x000fca0003f7d000ULL,
0x0000003a007d7306ULL, 0x0002f0000000d400ULL, 0x0000003100d67306ULL, 0x000fe20000209400ULL,
0x000100003a3a7824ULL, 0x002fe200078e00ffULL, 0x000000bfbd00720bULL, 0x004fc40003f3d000ULL,
0x000000018a8a3812ULL, 0x000fe400078efcffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003100d77306ULL, 0x000fee0000205400ULL, 0x000000017d7d1812ULL, 0x008fe200078efcffULL,
0x0000003100777306ULL, 0x0003e2000020d400ULL, 0x000000ffa700720cULL, 0x000fc40003f25270ULL,
0x0000007d8686723eULL, 0x000fca00000010ffULL, 0x0000003000977306ULL, 0x000fe20000209400ULL,
0x000001002d317824ULL, 0x002fca00078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe40000011431ULL,
0x0000003000a17306ULL, 0x000e700000205400ULL, 0x0000003000477306ULL, 0x0004f0000020d400ULL,
0x0000004600e47306ULL, 0x000fe20000209400ULL, 0x0000a8001a307811ULL, 0x004fc400078e20ffULL,
0x000000a19700720bULL, 0x002fca0003f9d000ULL, 0x0000004600e57306ULL, 0x000e700000205400ULL,
0x0000004600877306ULL, 0x000ea2000020d400ULL, 0x0000000147474812ULL, 0x008fce00078efcffULL,
0x00000032009c7306ULL, 0x000fe20000209400ULL, 0x000000e5e400720bULL, 0x002fce0003f5d000ULL,
0x00000032009d7306ULL, 0x000e6c0000205400ULL, 0x0000000187872812ULL, 0x004fe400078efcffULL,
0x0000003200707306ULL, 0x000ea2000020d400ULL, 0x000000aab100720bULL, 0x000fe20003f5d000ULL,
0x000001002eb17824ULL, 0x000fe200078e00ffULL, 0x0000007c8787723eULL, 0x000fe200000010ffULL,
0x000100002faa7824ULL, 0x000fc600078e00ffULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x0000003300957306ULL, 0x000fe20000209400ULL, 0x0000009d9c00720bULL, 0x002fe40003fdd000ULL,
0x00000018ffaa7819ULL, 0x000fc600000114aaULL, 0x0000000175752812ULL, 0x000fe400078efcffULL,
0x0000003300967306ULL, 0x000fe40000205400ULL, 0x000000757e7e723eULL, 0x000fc800000010ffULL,
0x0000000170706812ULL, 0x004fe400078efcffULL, 0x0000003300467306ULL, 0x0003e4000020d400ULL,
0x000000706666723eULL, 0x000fcc00000010ffULL, 0x0000003a00e97306ULL, 0x000fe20000209400ULL,
0x000000003030783bULL, 0x002e6e0000000200ULL, 0x0000003a00ea7306ULL, 0x000eb00000205400ULL,
0x0000003a00827306ULL, 0x000730000020d400ULL, 0x0000003900d17306ULL, 0x000fe20000209400ULL,
0x00000018ff3a7819ULL, 0x008fc40000011438ULL, 0x000000eae900720bULL, 0x004fca0003f7d000ULL,
0x0000003900d27306ULL, 0x000eb00000205400ULL, 0x00000039007f7306ULL, 0x000ee2000020d400ULL,
0x0000000182823812ULL, 0x010fe200078efcffULL, 0x0000007430309231ULL, 0x082fe200003400ffULL,
0x000000b3b200720bULL, 0x000fe20003f7d000ULL, 0x0000007432329231ULL, 0x000fe200003400ffULL,
0x000001002fb37824ULL, 0x000fe200078e00ffULL, 0x0000006b31319231ULL, 0x080fe200003400ffULL,
0x000000827982723eULL, 0x000fe200000010ffULL, 0x0000003a00387306ULL, 0x000fe20000209400ULL,
0x000000d2d100720bULL, 0x004fe20003f5d000ULL, 0x0000006b33339231ULL, 0x000fe200003400ffULL,
0x00000018ffb37819ULL, 0x000fca00000114b3ULL, 0x0000003a00397306ULL, 0x000e620000205400ULL,
0x0000002a305c723cULL, 0x040fe2000004185cULL, 0x000000016c6c3812ULL, 0x000fe400078efcffULL,
0x000000d7d600720bULL, 0x000fe40003f7d000ULL, 0x000000017f7f2812ULL, 0x008fe400078efcffULL,
0x0000003a006f7306ULL, 0x000ea2000020d400ULL, 0x000000a0a22a723eULL, 0x000fe200000010ffULL,
0x000000863040723cULL, 0x000fe20000041840ULL, 0x0000009b9f2b723eULL, 0x000fc400000010ffULL,
0x000000d4d300720bULL, 0x000fe40003f5d000ULL, 0x000000767f7f723eULL, 0x000fe200000010ffULL,
0x000000be00bb7306ULL, 0x000fe20000209400ULL, 0x000000393800720bULL, 0x002fe20003fbd000ULL,
0x0000002a3034723cULL, 0x000fe20000041834ULL, 0x0000000177773812ULL, 0x000fe400078efcffULL,
0x0000009e9938723eULL, 0x000fe400000010ffULL, 0x000000949039723eULL, 0x000fe200000010ffULL,
0x000000be00bc7306ULL, 0x000e620000205400ULL, 0x0000008d932a723eULL, 0x000fc400000010ffULL,
0x000000858c2b723eULL, 0x000fe400000010ffULL, 0x0000000171712812ULL, 0x000fe200078efcffULL,
0x000000383058723cULL, 0x040fe20000041858ULL, 0x000000016f6f5812ULL, 0x004fe200078efcffULL,
0x0000002c00b77306ULL, 0x000fe20000009400ULL, 0x0000008e8f00720bULL, 0x000fe40003fbd000ULL,
0x000000969500720bULL, 0x000fe40003f5d000ULL, 0x0000008a8385723eULL, 0x000fe200000010ffULL,
0x0000002a3050723cULL, 0x000fe20000041850ULL, 0x000000817a83723eULL, 0x000fe200000010ffULL,
0x0000002c00b87306ULL, 0x000ea20000005400ULL, 0x0000007b6c6c723eULL, 0x000fc400000010ffULL,
0x000000716f6f723eULL, 0x000fc600000010ffULL, 0x0000000155555812ULL, 0x000fe200078efcffULL,
0x000000843048723cULL, 0x000fe20000041848ULL, 0x0000002c00457306ULL, 0x000722000000d400ULL,
0x000000bcbb00720bULL, 0x002fe40003fbd000ULL, 0x0000000146462812ULL, 0x000fca00078efcffULL,
0x0000002d00917306ULL, 0x000fe20000009400ULL, 0x000100002c2c7824ULL, 0x008fe200078e00ffULL,
0x000000b8b700720bULL, 0x004fc80003f7d000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002d00927306ULL, 0x000e6e0000005400ULL, 0x0000000145453812ULL, 0x010fe200078efcffULL,
0x0000002d00447306ULL, 0x0004e2000000d400ULL, 0x0000006e6d00720bULL, 0x000fc40003f7d000ULL,
0x00000067786e723eULL, 0x000fe400000010ffULL, 0x000000465567723eULL, 0x000fe400000010ffULL,
0x00000077686d723eULL, 0x000fe200000010ffULL, 0x0000002e00887306ULL, 0x000fe20000009400ULL,
0x000100002d2d7824ULL, 0x004fe200078e00ffULL, 0x000000929100720bULL, 0x002fc80003fdd000ULL,
0x0000000154543812ULL, 0x000fe400078efcffULL, 0x0000002e00897306ULL, 0x000e6e0000005400ULL,
0x0000000144446812ULL, 0x008fe200078efcffULL, 0x0000002e003b7306ULL, 0x0005e2000000d400ULL,
0x0000006a6900720bULL, 0x000fce0003fdd000ULL, 0x000000be00807306ULL, 0x000ee2000020d400ULL,
0x00000018ff2e7819ULL, 0x004fe4000001142dULL, 0x000000a5a32d723eULL, 0x000fe400000010ffULL,
0x000000898800720bULL, 0x002fe40003f5d000ULL, 0x000000014f4f6812ULL, 0x000fe200078efcffULL,
0x0000002c00ad7306ULL, 0x000fe20000209400ULL, 0x000000645600720bULL, 0x000fce0003fdd000ULL,
0x0000002c00b27306ULL, 0x000e620000205400ULL, 0x0000000180805812ULL, 0x008fe400078efcffULL,
0x000000013b3b2812ULL, 0x000fe400078efcffULL, 0x00000044802b723eULL, 0x000fe400000010ffULL,
0x000000014e4e6812ULL, 0x000fe200078efcffULL, 0x0000002e00a97306ULL, 0x000ff00000209400ULL,
0x0000002e00a87306ULL, 0x000ea20000205400ULL, 0x000000b2ad00720bULL, 0x002fce0003f9d000ULL,
0x0000002c00a77306ULL, 0x0002f0000020d400ULL, 0x000000b100a37306ULL, 0x000fe20000209400ULL,
0x000000a6a42c723eULL, 0x002fe400000010ffULL, 0x000000a8a900720bULL, 0x004fca0003fbd000ULL,
0x0000002e00a47306ULL, 0x000e62000020d400ULL, 0x0000002c3060723cULL, 0x000fe20000041860ULL,
0x00000001a7a74812ULL, 0x008fc800078efcffULL, 0x000000a75454723eULL, 0x000fe400000010ffULL,
0x0000a8001b2c7811ULL, 0x000fe200078e20ffULL, 0x000000b100987306ULL, 0x000ea20000205400ULL,
0x000000823030723cULL, 0x000fe2000004183cULL, 0x00000001a4a45812ULL, 0x002fcc00078efcffULL,
0x000000b3008b7306ULL, 0x000fe20000209400ULL, 0x000000a44f55723eULL, 0x000fce00000010ffULL,
0x000000b3002a7306ULL, 0x000e620000205400ULL, 0x00000098a300720bULL, 0x004fce0003f9d000ULL,
0x0000002f00727306ULL, 0x000ff00000009400ULL, 0x0000002f00737306ULL, 0x000ea20000005400ULL,
0x0000002a8b00720bULL, 0x002fe40003fbd000ULL, 0x00000045472a723eULL, 0x000fca00000010ffULL,
0x0000002f003a7306ULL, 0x0002f0000000d400ULL, 0x000000b1008e7306ULL, 0x000f22000020d400ULL,
0x000000002c2c783bULL, 0x002e620000000200ULL, 0x000000737200720bULL, 0x004fcc0003f7d000ULL,
0x000000b3008f7306ULL, 0x000eae000020d400ULL, 0x000000013a3a3812ULL, 0x008fe200078efcffULL,
0x000000ab00387306ULL, 0x000fe20000209400ULL, 0x000000018e8e4812ULL, 0x010fe400078efcffULL,
0x000000576500720bULL, 0x000fc40003f9d000ULL, 0x0000003b8e8e723eULL, 0x000fc600000010ffULL,
0x000000ab00397306ULL, 0x000ee20000205400ULL, 0x000000018f8f5812ULL, 0x004fc800078efcffULL,
0x0000003a8f8f723eULL, 0x000fc600000010ffULL, 0x000000aa003c7306ULL, 0x000fe20000209400ULL,
0x0000000129294812ULL, 0x000fce00078efcffULL, 0x000000aa003d7306ULL, 0x000ea20000205400ULL,
0x000000393800720bULL, 0x008fe20003f5d000ULL, 0x000000742c2c9231ULL, 0x082fe400003400ffULL,
0x000000742e2e9231ULL, 0x000fe400003400ffULL, 0x0000006b2d2d9231ULL, 0x080fe400003400ffULL,
0x000000ab00ab7306ULL, 0x000e62000020d400ULL, 0x0000006b2f2f9231ULL, 0x000fce00003400ffULL,
0x000000aa00aa7306ULL, 0x000ee2000020d400ULL, 0x0000003d3c00720bULL, 0x004fe20003fbd000ULL,
0x0000007e2c5c723cULL, 0x000fe2000004185cULL, 0x00000001abab2812ULL, 0x002fce00078efcffULL,
0x0000006c2c60723cULL, 0x000fe20000041860ULL, 0x000000ab4e4e723eULL, 0x000fc600000010ffULL,
0x00000001aaaa5812ULL, 0x008fc800078efcffULL, 0x0000006e2c34723cULL, 0x000fe20000041834ULL,
0x000000aa294f723eULL, 0x000fce00000010ffULL, 0x000000662c58723cULL, 0x040ff00000041858ULL,
0x0000002a2c50723cULL, 0x040ff00000041850ULL, 0x000000542c48723cULL, 0x040ff00000041848ULL,
0x0000008e2c40723cULL, 0x040ff00000041840ULL, 0x0000004e2c2c723cULL, 0x000fe20000041830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff2a7f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fc4000784482bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000784482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff297424ULL, 0x000fc800078e00ffULL,
0x0000002900307305ULL, 0x0002a4000021f000ULL, 0x3fa0000029297823ULL, 0x002fe200000100ffULL,
0x000000300000735dULL, 0x004fe20003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc4000784482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff3e7819ULL, 0x000fe20000011603ULL, 0x000058000a2a7a24ULL, 0x020fe200078e02ffULL,
0x00000080052b7811ULL, 0x000fe400078e40ffULL, 0x000000023e447810ULL, 0x000fe20007ffe0ffULL,
0x0000000109297824ULL, 0x000fe200078e023eULL, 0x0000002b04307217ULL, 0x000fe20007800000ULL,
0x000000802a2a7824ULL, 0x000fe400078e00ffULL, 0x00000080003b7824ULL, 0x000fe400078e0229ULL,
0x0000000130307824ULL, 0x000fc600078e0a2bULL, 0x0000002a3b317210ULL, 0x040fe40007f5e0ffULL,
0x0000002030307807ULL, 0x000fe40000000000ULL, 0x000000043b397810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x0000003009307217ULL, 0x000fe40007800000ULL,
0x0000002a39397210ULL, 0x000fe40007f9e0ffULL, 0x00005e00313c7a11ULL, 0x000fe200078440ffULL,
0x00000001302b7824ULL, 0x000fe200078e0a09ULL, 0x000000023b337810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x00005f0031317a11ULL, 0x000fc400010f4432ULL,
0x0000002a33337210ULL, 0x000fe40007f5e0ffULL, 0x00005e0039387a11ULL, 0x000fe400078840ffULL,
0x000000063b3b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x00005f0039397a11ULL, 0x000fe400020f4430ULL, 0x0000000f3c307210ULL, 0x000fe40007fbe0ffULL,
0x00005e0033327a11ULL, 0x000fc400078640ffULL, 0x0000002a3b3b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x00005f0033337a11ULL, 0x000fe400018f443aULL,
0x0000000f32327210ULL, 0x000fe20007fde0ffULL, 0x000000ffff3c7224ULL, 0x000fe200020e06ffULL,
0x0000002b4400720cULL, 0x000fe40003f46070ULL, 0x0000000f38387210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff337224ULL, 0x000fe200030e0633ULL, 0x000000043e447810ULL, 0x000fc40007ffe0ffULL,
0x0000002b3e00720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff397224ULL, 0x000fe200028e0639ULL,
0x000000063e3e7810ULL, 0x000fe40007ffe0ffULL, 0x00005e003b3a7a11ULL, 0x040fe400078840ffULL,
0x0000002b4400720cULL, 0x080fe40003fc6070ULL, 0x0000002b3e00720cULL, 0x000fe40003fa6070ULL,
0x00005f003b2b7a11ULL, 0x000fc400020f443cULL, 0x0000000f3a3a7210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000301d7faeULL, 0x0003e8000d901c46ULL,
0x000000ffff3b7224ULL, 0x000fe200020e062bULL, 0x00000000321e7faeULL, 0x0003e8000d101c46ULL,
0x00000000381f7faeULL, 0x0003e8000f101c46ULL, 0x000000003a207faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff2b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x004fc4000784484dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x00000001092b7824ULL, 0x000fe200078e023eULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff317984ULL, 0x002e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe4000784484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc4000784484dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff30723eULL, 0x002fe400000010ffULL, 0x00000002ff6f7819ULL, 0x000fe40000011603ULL,
0x0000541030687816ULL, 0x000fe20000000030ULL, 0x000158d27f007947ULL, 0x000fea000b800000ULL,
0x00001f6f68ad7589ULL, 0x0002a400000e0000ULL, 0x000159127f007947ULL, 0x000fea000b800000ULL,
0x00001ff468ae7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f9ULL, 0x0000949000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x000165e000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f7ULL, 0x000094f000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0001658000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000213c783bULL, 0x000f680000004200ULL, 0x000000002230783bULL, 0x000e680000004200ULL,
0x00000000234c783bULL, 0x000ee20000004200ULL, 0x00000018ff387819ULL, 0x020fe2000001143cULL,
0x0000003c006b7306ULL, 0x000fe20000009400ULL, 0x00000018ff397819ULL, 0x000fe2000001143dULL,
0x000001003c717824ULL, 0x000fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fc4000001143eULL,
0x00000018ff3b7819ULL, 0x000fe4000001143fULL, 0x00000018ff477819ULL, 0x002fe20000011432ULL,
0x0000003800ee7306ULL, 0x000fe20000209400ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x00000018ff447819ULL, 0x000fe40000011430ULL, 0x00000018ff547819ULL, 0x000fe40000011433ULL,
0x00000018ff467819ULL, 0x000fe20000011431ULL, 0x0000003800f17306ULL, 0x000e620000205400ULL,
0x00000018ff567819ULL, 0x008fce000001144fULL, 0x0000003800b37306ULL, 0x000ef0000020d400ULL,
0x0000003900857306ULL, 0x000fe20000209400ULL, 0x000000f1ee00720bULL, 0x002fce0003f9d000ULL,
0x0000003900987306ULL, 0x000fec0000205400ULL, 0x00000001b3b34812ULL, 0x008fe400078efcffULL,
0x0000003900aa7306ULL, 0x000ff0000020d400ULL, 0x0000003a00927306ULL, 0x000ff00000209400ULL,
0x0000003a00dd7306ULL, 0x000ff00000205400ULL, 0x0000003a009f7306ULL, 0x000ff0000020d400ULL,
0x0000003b00937306ULL, 0x000ff00000209400ULL, 0x0000003b00dc7306ULL, 0x000ff00000205400ULL,
0x0000003b009a7306ULL, 0x0003f0000020d400ULL, 0x0000004700c67306ULL, 0x000fe20000209400ULL,
0x000000002438783bULL, 0x002e6e0000004200ULL, 0x0000004700c37306ULL, 0x000ff00000205400ULL,
0x00000047007a7306ULL, 0x0007f0000020d400ULL, 0x0000003c00b27306ULL, 0x000f620000005400ULL,
0x00000018ff477819ULL, 0x008fce000001144eULL, 0x00000047008c7306ULL, 0x000ff00000209400ULL,
0x00000047008d7306ULL, 0x000fe20000205400ULL, 0x00000018ff737819ULL, 0x002fe40000011439ULL,
0x000000b26b00720bULL, 0x020fc40003f7d000ULL, 0x00000018ff787819ULL, 0x000fe4000001143bULL,
0x00000018ff777819ULL, 0x000fe2000001143aULL, 0x0000004700647306ULL, 0x000ff0000020d400ULL,
0x0000003c00b77306ULL, 0x0002f0000000d400ULL, 0x0000007300687306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000007300697306ULL, 0x000fe20000205400ULL, 0x00000001b7b73812ULL, 0x008fce00078efcffULL,
0x0000007300477306ULL, 0x0003f0000020d400ULL, 0x0000003c00a57306ULL, 0x000fe20000209400ULL,
0x000001003d737824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000003c00a67306ULL, 0x000e700000205400ULL, 0x0000007300ea7306ULL, 0x000ff00000209400ULL,
0x0000007300ed7306ULL, 0x000ee20000205400ULL, 0x000000a6a500720bULL, 0x002fce0003fbd000ULL,
0x0000003d00917306ULL, 0x000ff00000009400ULL, 0x0000003d00907306ULL, 0x000e620000005400ULL,
0x000000edea00720bULL, 0x008fce0003f7d000ULL, 0x0000003d00b67306ULL, 0x0007f0000000d400ULL,
0x0000003c00b87306ULL, 0x000b22000020d400ULL, 0x000100003d3d7824ULL, 0x008fe200078e00ffULL,
0x000000909100720bULL, 0x002fc80003f5d000ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000007300bb7306ULL, 0x000e62000020d400ULL, 0x000001003f3c7824ULL, 0x020fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e00de7306ULL, 0x000fe20000009400ULL,
0x00000001b8b85812ULL, 0x010fe400078efcffULL, 0x00000001b6b62812ULL, 0x000fca00078efcffULL,
0x0000003e00997306ULL, 0x000ee20000005400ULL, 0x00000001bbbb3812ULL, 0x002fce00078efcffULL,
0x0000003d00ec7306ULL, 0x000ff00000209400ULL, 0x0000003d00ef7306ULL, 0x000e620000205400ULL,
0x00000099de00720bULL, 0x008fce0003f7d000ULL, 0x0000003f00df7306ULL, 0x000ff00000009400ULL,
0x0000003f00707306ULL, 0x000ee20000005400ULL, 0x000000efec00720bULL, 0x002fce0003fbd000ULL,
0x0000003f00a07306ULL, 0x000330000000d400ULL, 0x0000007100b17306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x002fe200078e00ffULL, 0x00000070df00720bULL, 0x008fc80003f5d000ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000007100747306ULL, 0x000e6e0000205400ULL,
0x00000001a0a02812ULL, 0x010fe200078efcffULL, 0x0000007100bc7306ULL, 0x0007f0000020d400ULL,
0x0000003e00a77306ULL, 0x000962000000d400ULL, 0x000001003e717824ULL, 0x008fe200078e00ffULL,
0x00000074b100720bULL, 0x002fc80003fdd000ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000003d00ab7306ULL, 0x0002e2000020d400ULL, 0x000100003e3e7824ULL, 0x010fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000007100867306ULL, 0x000fe20000209400ULL,
0x00000001a7a73812ULL, 0x020fe200078efcffULL, 0x00000100303d7824ULL, 0x002fe200078e00ffULL,
0x00000001bcbc6812ULL, 0x000fe400078efcffULL, 0x000000988500720bULL, 0x000fc60003fdd000ULL,
0x0000007100eb7306ULL, 0x000e620000205400ULL, 0x00000001abab5812ULL, 0x008fce00078efcffULL,
0x0000003c00e27306ULL, 0x000fe40000209400ULL, 0x00000001aaaa6812ULL, 0x000fcc00078efcffULL,
0x0000003c00e37306ULL, 0x000ee20000205400ULL, 0x000000eb8600720bULL, 0x002fce0003f9d000ULL,
0x0000003f00e67306ULL, 0x000ff00000209400ULL, 0x0000003f00e77306ULL, 0x000e620000205400ULL,
0x000000e3e200720bULL, 0x008fce0003fbd000ULL, 0x0000004400897306ULL, 0x000ff00000209400ULL,
0x0000004400d87306ULL, 0x000fe20000205400ULL, 0x000000e7e600720bULL, 0x002fce0003f7d000ULL,
0x00000044008b7306ULL, 0x0003f0000020d400ULL, 0x0000007100ac7306ULL, 0x000722000020d400ULL,
0x00000018ff447819ULL, 0x002fce000001144cULL, 0x0000004400b57306ULL, 0x000fe20000209400ULL,
0x00000018ff717819ULL, 0x008fce000001143dULL, 0x0000004400b47306ULL, 0x000fe20000205400ULL,
0x00000001acac4812ULL, 0x010fe400078efcffULL, 0x000000dd9200720bULL, 0x000fca0003f9d000ULL,
0x00000044006d7306ULL, 0x0003f0000020d400ULL, 0x0000003c00a17306ULL, 0x000722000020d400ULL,
0x00000018ff447819ULL, 0x002fe40000011438ULL, 0x000000019f9f4812ULL, 0x000fca00078efcffULL,
0x0000003f009b7306ULL, 0x000e62000020d400ULL, 0x00000100313c7824ULL, 0x008fce00078e00ffULL,
0x0000003100da7306ULL, 0x000fe20000009400ULL, 0x00000001a1a15812ULL, 0x010fe400078efcffULL,
0x000000dc9300720bULL, 0x000fca0003fbd000ULL, 0x0000003100d97306ULL, 0x000ee20000005400ULL,
0x000000019b9b3812ULL, 0x002fce00078efcffULL, 0x0000004600d77306ULL, 0x000fe20000209400ULL,
0x000000019a9a5812ULL, 0x000fe400078efcffULL, 0x000000d88900720bULL, 0x000fca0003fbd000ULL,
0x0000004600887306ULL, 0x000fe20000205400ULL, 0x000000d9da00720bULL, 0x008fce0003f7d000ULL,
0x0000004600827306ULL, 0x0003e2000020d400ULL, 0x000000018b8b5812ULL, 0x000fce00078efcffULL,
0x0000005400c27306ULL, 0x000fe20000209400ULL, 0x00000018ff467819ULL, 0x002fce000001144dULL,
0x0000005400bf7306ULL, 0x000ff00000205400ULL, 0x0000005400767306ULL, 0x000ff0000020d400ULL,
0x0000005600807306ULL, 0x000ff00000209400ULL, 0x0000005600817306ULL, 0x000ff00000205400ULL,
0x0000005600557306ULL, 0x000ff0000020d400ULL, 0x00000044006e7306ULL, 0x000ff00000209400ULL,
0x00000044006f7306ULL, 0x000ff00000205400ULL, 0x0000004400547306ULL, 0x000ff0000020d400ULL,
0x0000007800567306ULL, 0x000ff00000209400ULL, 0x0000007800577306ULL, 0x000ff00000205400ULL,
0x0000007800447306ULL, 0x0003f0000020d400ULL, 0x0000004600a87306ULL, 0x000fe20000209400ULL,
0x0000010032787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000004600a97306ULL, 0x000ff00000205400ULL, 0x0000004600677306ULL, 0x004ff0000020d400ULL,
0x0000007700657306ULL, 0x000ff00000209400ULL, 0x0000007700667306ULL, 0x000ff00000205400ULL,
0x0000007700467306ULL, 0x0003f0000020d400ULL, 0x00000031008e7306ULL, 0x0004e2000000d400ULL,
0x00000018ff777819ULL, 0x002fce000001143cULL, 0x0000007100e87306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x004fce00078e00ffULL, 0x0000007100e97306ULL, 0x000e620000205400ULL,
0x000000018e8e3812ULL, 0x008fce00078efcffULL, 0x0000003e00e47306ULL, 0x000ff00000209400ULL,
0x0000003e00e57306ULL, 0x000ea20000205400ULL, 0x000000e9e800720bULL, 0x002fce0003f5d000ULL,
0x00000077003c7306ULL, 0x000ff00000209400ULL, 0x00000077003d7306ULL, 0x000e620000205400ULL,
0x000000e5e400720bULL, 0x004fce0003fdd000ULL, 0x0000007800e07306ULL, 0x000ff00000209400ULL,
0x0000007800e17306ULL, 0x000ea20000205400ULL, 0x0000003d3c00720bULL, 0x002fe40003f9d000ULL,
0x0000a800263c7811ULL, 0x000fca00078e20ffULL, 0x0000003000db7306ULL, 0x000ff00000009400ULL,
0x0000003000727306ULL, 0x000fe20000005400ULL, 0x000000e1e000720bULL, 0x004fce0003f7d000ULL,
0x0000003000977306ULL, 0x0003f0000000d400ULL, 0x0000003200c87306ULL, 0x000fe20000009400ULL,
0x0001000030307824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011430ULL,
0x0000003200c77306ULL, 0x000ff00000005400ULL, 0x00000032007f7306ULL, 0x0003f0000000d400ULL,
0x0000007700957306ULL, 0x0004e2000020d400ULL, 0x0001000032327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000071009c7306ULL, 0x000322000020d400ULL,
0x0000010033777824ULL, 0x004fca00078e00ffULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x0000003300947306ULL, 0x000fe20000009400ULL, 0x00000018ff717819ULL, 0x002fe40000011431ULL,
0x0000000195954812ULL, 0x008fca00078efcffULL, 0x0000003300c57306ULL, 0x000fe20000005400ULL,
0x000000019c9c2812ULL, 0x010fce00078efcffULL, 0x0000003300797306ULL, 0x0003f0000000d400ULL,
0x0000003e00a27306ULL, 0x000ea2000020d400ULL, 0x0001000033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000007300307306ULL, 0x000ff00000209400ULL,
0x00000073003f7306ULL, 0x000e620000205400ULL, 0x00000001a2a26812ULL, 0x004fc400078efcffULL,
0x00000072db00720bULL, 0x000fca0003fdd000ULL, 0x00000078008a7306ULL, 0x000eb0000020d400ULL,
0x0000007100317306ULL, 0x000fe20000209400ULL, 0x0000003f3000720bULL, 0x002fe40003f5d000ULL,
0x0000a80025307811ULL, 0x000fc400078e20ffULL, 0x0000000197976812ULL, 0x000fe400078efcffULL,
0x00000088d700720bULL, 0x000fe20003fdd000ULL, 0x00000071003e7306ULL, 0x000e620000205400ULL,
0x000000018a8a3812ULL, 0x004fce00078efcffULL, 0x0000007700d17306ULL, 0x000fe80000209400ULL,
0x0000000182826812ULL, 0x000fe400078efcffULL, 0x000000c3c600720bULL, 0x000fe20003fdd000ULL,
0x000001003bc67824ULL, 0x000fe200078e00ffULL, 0x0000007700d27306ULL, 0x000ea20000205400ULL,
0x0000003e3100720bULL, 0x002fe40003f9d000ULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x00000018ffc67819ULL, 0x000fc800000114c6ULL, 0x0000003200cf7306ULL, 0x000fe60000209400ULL,
0x000000017a7a6812ULL, 0x000fca00078efcffULL, 0x0000003200d07306ULL, 0x000ee20000205400ULL,
0x000000d2d100720bULL, 0x004fce0003fbd000ULL, 0x0000003200877306ULL, 0x0005f0000020d400ULL,
0x00000071008f7306ULL, 0x000962000020d400ULL, 0x000001004e327824ULL, 0x004fe200078e00ffULL,
0x000000d0cf00720bULL, 0x008fc80003f7d000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003300d37306ULL, 0x000fe20000209400ULL, 0x000001004c717824ULL, 0x010fe200078e00ffULL,
0x000000ad3c3c9231ULL, 0x082fe400003400ffULL, 0x000000ad3e3e9231ULL, 0x000fe400003400ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x000000ae3d3d9231ULL, 0x080fe200003400ffULL,
0x0000003300d47306ULL, 0x000fe20000205400ULL, 0x000000018f8f4812ULL, 0x020fe200078efcffULL,
0x000000ae3f3f9231ULL, 0x000fe200003400ffULL, 0x0000000187873812ULL, 0x000fc400078efcffULL,
0x000000c59400720bULL, 0x000fe20003f9d000ULL, 0x000001003ac57824ULL, 0x000fe400078e00ffULL,
0x00000033007d7306ULL, 0x0003e6000020d400ULL, 0x00000018ffc57819ULL, 0x000fca00000114c5ULL,
0x0000007300967306ULL, 0x0004e2000020d400ULL, 0x000001004f337824ULL, 0x002fe200078e00ffULL,
0x0000000179794812ULL, 0x000fc800078efcffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000007700847306ULL, 0x000e62000020d400ULL, 0x000001004d737824ULL, 0x004fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000004d00c07306ULL, 0x000fe20000009400ULL,
0x0000000196962812ULL, 0x008fe400078efcffULL, 0x000000c7c800720bULL, 0x000fca0003f5d000ULL,
0x0000004d00bd7306ULL, 0x000ea20000005400ULL, 0x0000000184845812ULL, 0x002fe400078efcffULL,
0x000000d4d300720bULL, 0x000fca0003fbd000ULL, 0x0000003200af7306ULL, 0x000fe20000209400ULL,
0x000000017f7f2812ULL, 0x000fe400078efcffULL, 0x000000bfc200720bULL, 0x000fe20003f5d000ULL,
0x000100003ac27824ULL, 0x000fe200078e00ffULL, 0x0000007f8a8a723eULL, 0x000fe200000010ffULL,
0x000100003bbf7824ULL, 0x000fe400078e00ffULL, 0x0000003200b07306ULL, 0x000fe20000205400ULL,
0x000000bdc000720bULL, 0x004fe40003f7d000ULL, 0x000000017d7d5812ULL, 0x000fc400078efcffULL,
0x00000018ffc27819ULL, 0x000fe400000114c2ULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x0000003200777306ULL, 0x0003e2000020d400ULL, 0x0000000176762812ULL, 0x000fce00078efcffULL,
0x0000007100cb7306ULL, 0x000fe20000209400ULL, 0x0000010038327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000007100cc7306ULL, 0x000e700000205400ULL,
0x00000071007e7306ULL, 0x000eb0000020d400ULL, 0x0000003300a37306ULL, 0x000fe20000209400ULL,
0x000000cccb00720bULL, 0x002fce0003fbd000ULL, 0x0000003300a47306ULL, 0x000fec0000205400ULL,
0x000000017e7e5812ULL, 0x004fe400078efcffULL, 0x0000003300717306ULL, 0x0003e2000020d400ULL,
0x000000b4b500720bULL, 0x000fce0003fbd000ULL, 0x0000003200927306ULL, 0x000fe20000209400ULL,
0x0000010039337824ULL, 0x002fca00078e00ffULL, 0x00000018ffd87819ULL, 0x000fe40000011433ULL,
0x0000003200937306ULL, 0x000fe20000205400ULL, 0x000000016d6d5812ULL, 0x000fe400078efcffULL,
0x000000b0af00720bULL, 0x000fca0003fbd000ULL, 0x0000003200727306ULL, 0x0003f0000020d400ULL,
0x0000004d006c7306ULL, 0x0004e2000000d400ULL, 0x000000003030783bULL, 0x002e620000000200ULL,
0x0000000177775812ULL, 0x000fcc00078efcffULL, 0x0000004c00be7306ULL, 0x000fe20000009400ULL,
0x000100004d4d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004c00837306ULL, 0x000ea20000005400ULL, 0x000000016c6c3812ULL, 0x008fe400078efcffULL,
0x000000a9a800720bULL, 0x000fca0003f7d000ULL, 0x0000004c00757306ULL, 0x000730000000d400ULL,
0x0000007300cd7306ULL, 0x000fe20000209400ULL, 0x000100004c4c7824ULL, 0x008fe200078e00ffULL,
0x00000083be00720bULL, 0x004fc40003f9d000ULL, 0x0000000167673812ULL, 0x000fe400078efcffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000007300ce7306ULL, 0x000ea20000205400ULL,
0x000000a4a300720bULL, 0x000fe20003f7d000ULL, 0x000000ad30309231ULL, 0x082fe400003400ffULL,
0x000000ad32329231ULL, 0x000fe400003400ffULL, 0x000000ae31319231ULL, 0x080fe200003400ffULL,
0x0000000175754812ULL, 0x010fe200078efcffULL, 0x0000004e00ba7306ULL, 0x000fe20000009400ULL,
0x000000ae33339231ULL, 0x000fca00003400ffULL, 0x0000000171713812ULL, 0x000fe400078efcffULL,
0x0000004e00b97306ULL, 0x000e620000005400ULL, 0x000000cecd00720bULL, 0x004fe40003f5d000ULL,
0x000000818000720bULL, 0x000fca0003f7d000ULL, 0x0000004c00c97306ULL, 0x000ff00000209400ULL,
0x0000004c00ca7306ULL, 0x000ea20000205400ULL, 0x000000b9ba00720bULL, 0x002fe40003fdd000ULL,
0x0000000155553812ULL, 0x000fca00078efcffULL, 0x0000004e006a7306ULL, 0x0002f0000000d400ULL,
0x00000073007b7306ULL, 0x000f22000020d400ULL, 0x000100004e4e7824ULL, 0x002fe200078e00ffULL,
0x000000cac900720bULL, 0x004fc80003f9d000ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004c007c7306ULL, 0x000e62000020d400ULL, 0x000000016a6a6812ULL, 0x008fe400078efcffULL,
0x0000008d8c00720bULL, 0x000fca0003fdd000ULL, 0x0000004d00c17306ULL, 0x000fe20000209400ULL,
0x000000017b7b2812ULL, 0x010fc800078efcffULL, 0x0000006c7b7b723eULL, 0x000fc600000010ffULL,
0x0000004d00c47306ULL, 0x000ea20000205400ULL, 0x000000017c7c4812ULL, 0x002fe400078efcffULL,
0x0000000164646812ULL, 0x000fe400078efcffULL, 0x000000939200720bULL, 0x000fe40003fdd000ULL,
0x0000007c6d7c723eULL, 0x000fe200000010ffULL, 0x0000003800b17306ULL, 0x000ff00000009400ULL,
0x0000003800b27306ULL, 0x000e620000005400ULL, 0x000000c4c100720bULL, 0x004fc40003f5d000ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x0000006f6e00720bULL, 0x000fc60003fdd000ULL,
0x00000038006b7306ULL, 0x0004f0000000d400ULL, 0x0000004e009d7306ULL, 0x000fe20000209400ULL,
0x0001000038387824ULL, 0x004fe200078e00ffULL, 0x000000b2b100720bULL, 0x002fc40003f9d000ULL,
0x0000000154546812ULL, 0x000fe400078efcffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000004e009e7306ULL, 0x000e620000205400ULL, 0x000000666500720bULL, 0x000fcc0003fdd000ULL,
0x000000016b6b4812ULL, 0x008fe200078efcffULL, 0x0000004e00737306ULL, 0x000ea6000020d400ULL,
0x0000006b7272723eULL, 0x000fc600000010ffULL, 0x0000000146466812ULL, 0x000fe400078efcffULL,
0x0000003900a57306ULL, 0x000fe20000009400ULL, 0x0000009e9d00720bULL, 0x002fce0003fbd000ULL,
0x0000003900a67306ULL, 0x000fec0000005400ULL, 0x0000000173735812ULL, 0x004fe400078efcffULL,
0x00000039004e7306ULL, 0x0003e4000000d400ULL, 0x000000736464723eULL, 0x000fcc00000010ffULL,
0x0000003800947306ULL, 0x000fe20000209400ULL, 0x0001000039397824ULL, 0x002fca00078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe40000011439ULL, 0x0000003800c37306ULL, 0x000e620000205400ULL,
0x000000abaa39723eULL, 0x000fce00000010ffULL, 0x0000003800837306ULL, 0x0005f0000020d400ULL,
0x0000004d00787306ULL, 0x000ee2000020d400ULL, 0x000000b8b338723eULL, 0x004fe400000010ffULL,
0x000000c39400720bULL, 0x002fca0003f9d000ULL, 0x0000004f00d57306ULL, 0x000fe20000009400ULL,
0x000000383060723cULL, 0x000fee0000041860ULL, 0x0000004f00d67306ULL, 0x000e620000005400ULL,
0x000000a29f38723eULL, 0x000fe400000010ffULL, 0x0000009b9a39723eULL, 0x000fc400000010ffULL,
0x0000000178782812ULL, 0x008fe400078efcffULL, 0x000000a6a500720bULL, 0x000fe20003f5d000ULL,
0x0000003a00907306ULL, 0x000fe20000009400ULL, 0x0000000183834812ULL, 0x000fe200078efcffULL,
0x000000383058723cULL, 0x000fe60000041858ULL, 0x000000835454723eULL, 0x000fc600000010ffULL,
0x0000003a00917306ULL, 0x000ea20000005400ULL, 0x000000968b38723eULL, 0x000fe400000010ffULL,
0x0000008f8239723eULL, 0x000fe400000010ffULL, 0x000000d6d500720bULL, 0x002fe40003f3d000ULL,
0x00000079848b723eULL, 0x000fe200000010ffULL, 0x0000003a004d7306ULL, 0x0002e2000000d400ULL,
0x000000014e4e2812ULL, 0x000fe200078efcffULL, 0x000000383048723cULL, 0x000fe20000041848ULL,
0x000000696800720bULL, 0x000fca0003f5d000ULL, 0x0000003b00857306ULL, 0x000fe20000009400ULL,
0x000000b7bc3a723eULL, 0x002fe200000010ffULL, 0x0000008a3040723cULL, 0x040fe20000041840ULL,
0x000000877a38723eULL, 0x000fe400000010ffULL, 0x0000007d7639723eULL, 0x000fe400000010ffULL,
0x000000919000720bULL, 0x004fe20003fbd000ULL, 0x0000003b00867306ULL, 0x000fe20000005400ULL,
0x0000000147472812ULL, 0x000fe400078efcffULL, 0x000000757e7a723eULL, 0x000fe200000010ffULL,
0x00000038302c723cULL, 0x000fe2000004182cULL, 0x00000078677d723eULL, 0x000fc600000010ffULL,
0x0000003b004c7306ULL, 0x0003e8000000d400ULL, 0x000000014d4d5812ULL, 0x008fe200078efcffULL,
0x0000007c3c60723cULL, 0x000fe60000041860ULL, 0x000000d800887306ULL, 0x000fe20000209400ULL,
0x000000b6bb3b723eULL, 0x002fce00000010ffULL, 0x000000d800897306ULL, 0x000e620000205400ULL,
0x0000003a305c723cULL, 0x000fee000004185cULL, 0x0000004f00747306ULL, 0x0004e2000000d400ULL,
0x000000a7ac3a723eULL, 0x000fe400000010ffULL, 0x000000a0a13b723eULL, 0x000fca00000010ffULL,
0x000000bd00b97306ULL, 0x000fe20000209400ULL, 0x000100004f4f7824ULL, 0x004fe200078e00ffULL,
0x0000003a3034723cULL, 0x000fe20000041834ULL, 0x000000898800720bULL, 0x002fc60003f7d000ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x000000bd00ba7306ULL, 0x000fe20000205400ULL,
0x000000979c3a723eULL, 0x000fe200000010ffULL, 0x0000007a3c5c723cULL, 0x000fe2000004185cULL,
0x0000008e953b723eULL, 0x000fe400000010ffULL, 0x0000000174741812ULL, 0x008fc600078efcffULL,
0x0000004f00987306ULL, 0x000fe40000209400ULL, 0x0000003a3050723cULL, 0x000fec0000041850ULL,
0x0000004f00997306ULL, 0x000e620000205400ULL, 0x0000006a7730723eULL, 0x000fe400000010ffULL,
0x000000747131723eULL, 0x000fca00000010ffULL, 0x0000004f00707306ULL, 0x000ea4000020d400ULL,
0x000000303c34723cULL, 0x000fec0000041834ULL, 0x000000d8004f7306ULL, 0x000ee2000020d400ULL,
0x000000999800720bULL, 0x002fce0003f3d000ULL, 0x000000c500aa7306ULL, 0x000fec0000209400ULL,
0x0000000170701812ULL, 0x004fe400078efcffULL, 0x000000c500a17306ULL, 0x000e620000205400ULL,
0x000000014f4f3812ULL, 0x008fe400078efcffULL, 0x000000bab900720bULL, 0x000fc40003f7d000ULL,
0x000000868500720bULL, 0x000fe40003f3d000ULL, 0x000000705565723eULL, 0x000fe200000010ffULL,
0x000000bd00ae7306ULL, 0x000ea2000020d400ULL, 0x0000004e4f73723eULL, 0x000fca00000010ffULL,
0x000000643c58723cULL, 0x000fe40000041858ULL, 0x000000c5009a7306ULL, 0x000ee2000020d400ULL,
0x000000a1aa00720bULL, 0x002fe40003f9d000ULL, 0x000000014c4c1812ULL, 0x000fc600078efcffULL,
0x000000723c50723cULL, 0x000fe40000041850ULL, 0x000000c6008e7306ULL, 0x000fe20000209400ULL,
0x00000001aeae3812ULL, 0x004fe400078efcffULL, 0x000000575600720bULL, 0x000fe40003f7d000ULL,
0x000000ae4755723eULL, 0x000fc600000010ffULL, 0x000000c6003b7306ULL, 0x000e620000205400ULL,
0x000000019a9a4812ULL, 0x008fc600078efcffULL, 0x000000543c48723cULL, 0x000fe20000041848ULL,
0x0000004d9a9a723eULL, 0x000fc600000010ffULL, 0x000000c2003a7306ULL, 0x000fe20000209400ULL,
0x0000000144443812ULL, 0x000fce00078efcffULL, 0x000000c200337306ULL, 0x000ea20000205400ULL,
0x0000003b8e00720bULL, 0x002fce0003f5d000ULL, 0x000000bf00327306ULL, 0x000ff00000209400ULL,
0x000000bf00397306ULL, 0x000e620000205400ULL, 0x000000333a00720bULL, 0x004fce0003f9d000ULL,
0x000000c6009b7306ULL, 0x000eb0000020d400ULL, 0x000000c200317306ULL, 0x000ee2000020d400ULL,
0x000000393200720bULL, 0x002fce0003fbd000ULL, 0x000000bf00bf7306ULL, 0x000e62000020d400ULL,
0x000000019b9b2812ULL, 0x004fc800078efcffULL, 0x0000004c9b9b723eULL, 0x000fe400000010ffULL,
0x0000000131314812ULL, 0x008fc800078efcffULL, 0x000000314646723eULL, 0x000fe200000010ffULL,
0x0000009a3c40723cULL, 0x000fe20000041840ULL, 0x00000001bfbf5812ULL, 0x002fc800078efcffULL,
0x000000bf4447723eULL, 0x000fce00000010ffULL, 0x000000463c3c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff2c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000080052f7811ULL, 0x000fe200078e40ffULL, 0x01069000ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000002f0400720cULL, 0x000fda0003f24070ULL, 0x00009f9000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff2c7984ULL, 0x002e640000000800ULL, 0x800000002cff7812ULL, 0x002fe4000782482dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe4000782482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff2c7424ULL, 0x000fc800078e00ffULL,
0x0000002c002e7305ULL, 0x0002a4000021f000ULL, 0x3fa000002c2c7823ULL, 0x002fe200000100ffULL,
0x0000002e0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff2e7984ULL, 0x000e640000000800ULL,
0x800000002eff7812ULL, 0x002fc4000782482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff4c7819ULL, 0x000fe40000011603ULL, 0x0000002000307811ULL, 0x000fe400078e38ffULL,
0x000000a0052f7811ULL, 0x000fe400078e40ffULL, 0x0000004c302d7210ULL, 0x000fe40007ffe009ULL,
0x0000002f042c7217ULL, 0x000fe40007800000ULL, 0x0000002d2a2d7210ULL, 0x000fc40007f3e0ffULL,
0x000000024c567810ULL, 0x000fe20007ffe0ffULL, 0x000000012c2c7824ULL, 0x000fe200078e0a2fULL,
0x000000064c4e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e002d467a11ULL, 0x040fe400078240ffULL, 0x0000005630317210ULL, 0x000fe40007ffe009ULL,
0x00005f002d3b7a11ULL, 0x000fe400008f442eULL, 0x000000044c547810ULL, 0x000fc40007ffe0ffULL,
0x0000004e302d7210ULL, 0x100fe40007ffe009ULL, 0x000000312a317210ULL, 0x000fe40007f3e0ffULL,
0x00000054302f7210ULL, 0x000fe40007ffe009ULL, 0x0000002d2a2d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff447224ULL, 0x000fe200008e06ffULL, 0x000000202c2c7807ULL, 0x000fe40000000000ULL,
0x0000002f2a2f7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x0000002c092c7217ULL, 0x000fc40007800000ULL, 0x00005e00313a7a11ULL, 0x000fe200078240ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x00005e002d327a11ULL, 0x000fe400078640ffULL,
0x00005f0031397a11ULL, 0x000fe200008f4444ULL, 0x000000012c317824ULL, 0x000fe200078e0a09ULL,
0x00005e002f307a11ULL, 0x000fe400078440ffULL, 0x00005f002d337a11ULL, 0x000fe400018f442eULL,
0x0000000f462c7210ULL, 0x000fc40007f7e0ffULL, 0x0000000f3a2e7210ULL, 0x000fe40007f9e0ffULL,
0x00005f002f387a11ULL, 0x000fe200010f4438ULL, 0x000000ffff2d7224ULL, 0x000fe200018e063bULL,
0x000000314c00720cULL, 0x000fe20003f46070ULL, 0x000000ffff2f7224ULL, 0x000fe200020e0639ULL,
0x0000000f30307210ULL, 0x000fe40007fbe0ffULL, 0x000000315600720cULL, 0x080fe40003f26070ULL,
0x000000315400720cULL, 0x000fc40003f66070ULL, 0x000000314e00720cULL, 0x000fe20003f86070ULL,
0x000000ffff317224ULL, 0x000fe200028e0638ULL, 0x0000000f32327210ULL, 0x000fc60007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c107faeULL, 0x0003e4000d101c46ULL,
0x000000ffff337224ULL, 0x000fe400028e0633ULL, 0x000000002e117faeULL, 0x0003e8000c901c46ULL,
0x0000000030127faeULL, 0x0003e8000d901c46ULL, 0x0000000032137faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff767f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff2e7984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01064800092c7f8cULL, 0x000fe2000c80043fULL, 0x800000002eff7812ULL, 0x002fc60007844845ULL,
0x01064c00092f7984ULL, 0x000e640000000800ULL, 0x800000002fff7812ULL, 0x002fe4000782482dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff2e7424ULL, 0x000fc800078e00ffULL,
0x0000002e002f7305ULL, 0x0002e4000021f000ULL, 0x3fa000002e2e7823ULL, 0x002fe200000100ffULL,
0x0000002f0000735dULL, 0x008fe40003800000ULL, 0x01064c00092f7984ULL, 0x000e640000000800ULL,
0x800000002fff7812ULL, 0x002fc4000782482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01010000142e7984ULL, 0x000e680000000800ULL, 0x01030000142f7984ULL, 0x0007220000000800ULL,
0x0000000b2e00720bULL, 0x002fe20003f3d000ULL, 0x000134227f007947ULL, 0x000fd8000b800000ULL,
0x00000000002c7806ULL, 0x008fc800008e0100ULL, 0x0000ffff2c327812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ffbd7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000020200780cULL, 0x000fe40003f65270ULL,
0x0000000b2e00720bULL, 0x000fe20003f34000ULL, 0x000134027f007947ULL, 0x000fd8000b800000ULL,
0x00000000002c7806ULL, 0x000fe400008e0100ULL, 0x0000002e0b2d7209ULL, 0x040fe40007810000ULL,
0x0000ffff2c317812ULL, 0x000fe400078e3cffULL, 0x00000002ff6f7819ULL, 0x000fe20000011603ULL,
0x8000002d0b307221ULL, 0x000fe20000010000ULL, 0x0105002d1400b388ULL, 0x0003e20000000800ULL,
0x0000003132ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x0000003000687308ULL, 0x000ee40000000800ULL, 0x000000680c0c7220ULL, 0x008fe20000410000ULL,
0x000133b27f007947ULL, 0x000fea000b800000ULL, 0x00001f6f68677589ULL, 0x0022e400000e0000ULL,
0x000000675c5c7220ULL, 0x08cfe40000410000ULL, 0x000000675d5d7220ULL, 0x080fe40000410000ULL,
0x0000006760607220ULL, 0x080fe40000410000ULL, 0x0000006761617220ULL, 0x080fe40000410000ULL,
0x0000006734347220ULL, 0x000fc40000410000ULL, 0x0000006735357220ULL, 0x080fe40000410000ULL,
0x0000006758587220ULL, 0x080fe40000410000ULL, 0x0000006759597220ULL, 0x080fe40000410000ULL,
0x0000006750507220ULL, 0x080fe40000410000ULL, 0x0000006751517220ULL, 0x080fe40000410000ULL,
0x0000006748487220ULL, 0x000fc40000410000ULL, 0x0000006749497220ULL, 0x080fe40000410000ULL,
0x0000006740407220ULL, 0x080fe40000410000ULL, 0x0000006741417220ULL, 0x080fe40000410000ULL,
0x000000673c3c7220ULL, 0x080fe40000410000ULL, 0x000000673d3d7220ULL, 0x000fe20000410000ULL,
0x000132e27f007947ULL, 0x000fea000b800000ULL, 0x00001ff468677589ULL, 0x0004e400000e0000ULL,
0x0000002e0b0b7209ULL, 0x000fe20007810000ULL, 0x000000675e5e7220ULL, 0x08cfe20000410000ULL,
0x00000001ffbd7807ULL, 0x000fe20000800000ULL, 0x000000675f5f7220ULL, 0x000fc40000410000ULL,
0x8000000b2e2e1221ULL, 0x000fe40000010000ULL, 0x0000006762627220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b2e2e1820ULL, 0x000fe40000410000ULL, 0x0000006763637220ULL, 0x080fe40000410000ULL,
0x0000002e00151308ULL, 0x000ea20000000800ULL, 0x0000006736367220ULL, 0x080fe40000410000ULL,
0x0000006737377220ULL, 0x000fc40000410000ULL, 0x000000675a5a7220ULL, 0x080fe40000410000ULL,
0x000000675b5b7220ULL, 0x080fe40000410000ULL, 0x0000006752527220ULL, 0x080fe40000410000ULL,
0x0000006753537220ULL, 0x080fe40000410000ULL, 0x000000674a4a7220ULL, 0x080fe40000410000ULL,
0x000000674b4b7220ULL, 0x000fc40000410000ULL, 0x0000006742427220ULL, 0x080fe40000410000ULL,
0x0000006743437220ULL, 0x080fe40000410000ULL, 0x000000673e3e7220ULL, 0x080fe40000410000ULL,
0x000000673f3f7220ULL, 0x000fe40000410000ULL, 0x0000002f152f1220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000c2f0c7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff2c7984ULL, 0x000ee40000000800ULL, 0x800000002cff7812ULL, 0x008fc40007824845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2c7424ULL, 0x000fc800078e00ffULL, 0x0000002c002d7305ULL, 0x000724000021f000ULL,
0x3fa000002c2c7823ULL, 0x008fe200000100ffULL, 0x0000002d0000735dULL, 0x010fe20003800000ULL,
0x0106ac00ff2e7984ULL, 0x000ee40000000800ULL, 0x800000002eff7812ULL, 0x008fe40007824845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff2c723eULL, 0x000fe400000010ffULL,
0x00000002ff6f7819ULL, 0x002fc40000011603ULL, 0x000054102c687816ULL, 0x000fe2000000002cULL,
0x000130827f007947ULL, 0x000fea000b800000ULL, 0x00001f6f68717589ULL, 0x0002e400000e0000ULL,
0x000130c27f007947ULL, 0x000fea000b800000ULL, 0x00001ff468697589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f9ULL,
0x0000bf2000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00013b5000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f7ULL,
0x0000bf8000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00013af000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001638783bULL, 0x000f680000004200ULL,
0x000000001744783bULL, 0x000fe80000004200ULL, 0x000000001854783bULL, 0x000fe80000004200ULL,
0x00000000194c783bULL, 0x000f220000004200ULL, 0x00000100386f7824ULL, 0x022fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe20000011438ULL, 0x0000003800f07306ULL, 0x000fe20000009400ULL,
0x00000018ff2e7819ULL, 0x000fc4000001143aULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff2f7819ULL, 0x000fe4000001143bULL, 0x00000018ff2d7819ULL, 0x000fe20000011439ULL,
0x0000002c00967306ULL, 0x000fe20000209400ULL, 0x00000018ff707819ULL, 0x010fe4000001144dULL,
0x00000018ff747819ULL, 0x000fe4000001144eULL, 0x00000018ff307819ULL, 0x000fc6000001144cULL,
0x0000002c00ec7306ULL, 0x000e620000205400ULL, 0x00000018ff797819ULL, 0x000fce000001144fULL,
0x0000003800bc7306ULL, 0x000f300000005400ULL, 0x0000003800aa7306ULL, 0x000ae2000000d400ULL,
0x000000ec9600720bULL, 0x002fce0003fbd000ULL, 0x0000006f00bb7306ULL, 0x000fe20000209400ULL,
0x0001000038387824ULL, 0x020fe200078e00ffULL, 0x000000bcf000720bULL, 0x010fc80003fdd000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000006f00f37306ULL, 0x000e6e0000205400ULL,
0x00000001aaaa6812ULL, 0x008fe200078efcffULL, 0x0000006f00b87306ULL, 0x000730000020d400ULL,
0x0000002e00977306ULL, 0x000fe20000209400ULL, 0x000001003a6f7824ULL, 0x008fe200078e00ffULL,
0x000000f3bb00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000002e00ca7306ULL, 0x000fee0000205400ULL, 0x00000001b8b82812ULL, 0x010fe200078efcffULL,
0x0000002e009c7306ULL, 0x0003f0000020d400ULL, 0x0000002c00a67306ULL, 0x000722000020d400ULL,
0x00000018ff2e7819ULL, 0x002fce0000011446ULL, 0x0000002e00b07306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x008fce0000011444ULL, 0x0000002e00ab7306ULL, 0x000fe20000205400ULL,
0x00000001a6a65812ULL, 0x010fce00078efcffULL, 0x0000002e007d7306ULL, 0x0003f0000020d400ULL,
0x0000003800f17306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x002fce0000011456ULL,
0x0000003800f27306ULL, 0x000e700000205400ULL, 0x0000006f00e87306ULL, 0x000ff00000209400ULL,
0x0000006f00e97306ULL, 0x000ee20000205400ULL, 0x000000f2f100720bULL, 0x002fce0003f9d000ULL,
0x0000003800a97306ULL, 0x000330000020d400ULL, 0x0000003b00787306ULL, 0x000fe20000009400ULL,
0x000001003b387824ULL, 0x002fe200078e00ffULL, 0x000000e9e800720bULL, 0x008fcc0003fbd000ULL,
0x0000003b006d7306ULL, 0x000fe20000005400ULL, 0x00000001a9a94812ULL, 0x010fce00078efcffULL,
0x0000003b009e7306ULL, 0x0003f0000000d400ULL, 0x0000002e009d7306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x002fce00078e00ffULL, 0x0000002e00927306ULL, 0x000ff00000205400ULL,
0x0000002e00657306ULL, 0x000ff0000020d400ULL, 0x0000007000677306ULL, 0x004ff00000209400ULL,
0x0000007000687306ULL, 0x000ff00000205400ULL, 0x00000070002e7306ULL, 0x0003f0000020d400ULL,
0x0000003900ef7306ULL, 0x000fe20000009400ULL, 0x0000010039707824ULL, 0x002fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000003900957306ULL, 0x000e700000005400ULL,
0x0000003900a87306ULL, 0x0004f0000000d400ULL, 0x0000006f00a47306ULL, 0x000962000020d400ULL,
0x0001000039397824ULL, 0x004fe200078e00ffULL, 0x00000095ef00720bULL, 0x002fc80003f3d000ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000002d00757306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x010fcc000001143bULL, 0x00000001a8a81812ULL, 0x008fe200078efcffULL,
0x0000002d00e37306ULL, 0x000e620000205400ULL, 0x00000001a4a45812ULL, 0x020fce00078efcffULL,
0x0000006f00e47306ULL, 0x000ff00000209400ULL, 0x0000006f00e57306ULL, 0x000ea20000205400ULL,
0x000000e37500720bULL, 0x002fce0003f9d000ULL, 0x0000003900ea7306ULL, 0x000ff00000209400ULL,
0x0000003900eb7306ULL, 0x000e620000205400ULL, 0x000000e5e400720bULL, 0x004fce0003fbd000ULL,
0x0000003900a77306ULL, 0x0004f0000020d400ULL, 0x0000004400c97306ULL, 0x000fe20000009400ULL,
0x0000010044397824ULL, 0x004fe200078e00ffULL, 0x000000ebea00720bULL, 0x002fcc0003fdd000ULL,
0x0000004400987306ULL, 0x000fee0000005400ULL, 0x00000001a7a76812ULL, 0x008fe200078efcffULL,
0x00000044008d7306ULL, 0x0003f0000000d400ULL, 0x0000002d00a57306ULL, 0x0004e2000020d400ULL,
0x0001000044447824ULL, 0x002fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000007000ed7306ULL, 0x000fe20000209400ULL, 0x00000018ff2d7819ULL, 0x004fce0000011445ULL,
0x0000007000ee7306ULL, 0x000e620000205400ULL, 0x00000001a5a54812ULL, 0x008fe400078efcffULL,
0x000000ca9700720bULL, 0x000fca0003f9d000ULL, 0x0000007000b77306ULL, 0x0005f0000020d400ULL,
0x0000006f00937306ULL, 0x000722000020d400ULL, 0x00000018ff707819ULL, 0x004fe40000011438ULL,
0x000000019c9c4812ULL, 0x000fc400078efcffULL, 0x000000eeed00720bULL, 0x002fc60003f7d000ULL,
0x0000004400db7306ULL, 0x000fe20000209400ULL, 0x00000100466f7824ULL, 0x008fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000004400dc7306ULL, 0x000e620000205400ULL,
0x0000000193935812ULL, 0x010fe400078efcffULL, 0x00000001b7b73812ULL, 0x000fe400078efcffULL,
0x0000006d7800720bULL, 0x000fc60003f7d000ULL, 0x0000003a008a7306ULL, 0x000ff00000009400ULL,
0x0000003a008b7306ULL, 0x000ea20000005400ULL, 0x000000dcdb00720bULL, 0x002fe40003fbd000ULL,
0x000000019e9e3812ULL, 0x000fca00078efcffULL, 0x0000003a00a37306ULL, 0x0002f0000000d400ULL,
0x0000002d00c47306ULL, 0x000fe20000209400ULL, 0x000100003a3a7824ULL, 0x002fe200078e00ffULL,
0x0000008b8a00720bULL, 0x004fc80003f5d000ULL, 0x00000018ff387819ULL, 0x000fe4000001143aULL,
0x0000002d00c57306ULL, 0x000fee0000205400ULL, 0x00000001a3a32812ULL, 0x008fe200078efcffULL,
0x0000002d00857306ULL, 0x0003f0000020d400ULL, 0x0000007000d77306ULL, 0x000fe20000209400ULL,
0x00000018ff2d7819ULL, 0x002fce0000011455ULL, 0x0000007000d87306ULL, 0x000e700000205400ULL,
0x0000007000a27306ULL, 0x0004f0000020d400ULL, 0x0000002d00b17306ULL, 0x000fe20000209400ULL,
0x00000018ff707819ULL, 0x004fe20000011439ULL, 0x0000010045397824ULL, 0x000fe200078e00ffULL,
0x000000d8d700720bULL, 0x002fe20003f3d000ULL, 0x000001004cd77824ULL, 0x000fc800078e00ffULL,
0x0000002d00ac7306ULL, 0x000fe20000205400ULL, 0x00000018ffd77819ULL, 0x000fce00000114d7ULL,
0x0000002d00667306ULL, 0x000fe2000020d400ULL, 0x00000001a2a21812ULL, 0x008fe400078efcffULL,
0x00000098c900720bULL, 0x000fca0003f3d000ULL, 0x00000074002d7306ULL, 0x000ff00000209400ULL,
0x0000007400337306ULL, 0x000fe20000205400ULL, 0x000000018d8d1812ULL, 0x000fce00078efcffULL,
0x0000007400317306ULL, 0x0003f0000020d400ULL, 0x00000038003a7306ULL, 0x000fe20000209400ULL,
0x00000018ff747819ULL, 0x002fce0000011439ULL, 0x0000003800d97306ULL, 0x000e700000205400ULL,
0x0000003800a17306ULL, 0x000eb0000020d400ULL, 0x0000004400917306ULL, 0x000ee2000020d400ULL,
0x000000d93a00720bULL, 0x002fce0003fdd000ULL, 0x0000007400387306ULL, 0x000fec0000209400ULL,
0x00000001a1a16812ULL, 0x004fe400078efcffULL, 0x0000007400397306ULL, 0x000e620000205400ULL,
0x0000000191915812ULL, 0x008fce00078efcffULL, 0x0000006f00df7306ULL, 0x000ff00000209400ULL,
0x0000006f00e07306ULL, 0x000ea20000205400ULL, 0x000000393800720bULL, 0x002fe20003f9d000ULL,
0x000001004d387824ULL, 0x000fcc00078e00ffULL, 0x0000004500c67306ULL, 0x000ff00000009400ULL,
0x00000045006e7306ULL, 0x000e620000005400ULL, 0x000000e0df00720bULL, 0x004fce0003fbd000ULL,
0x0000004500877306ULL, 0x0004f0000000d400ULL, 0x0000002f00c77306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x004fe200078e00ffULL, 0x0000006ec600720bULL, 0x002fc80003fdd000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000002f00c87306ULL, 0x000e6e0000205400ULL,
0x0000000187876812ULL, 0x008fe200078efcffULL, 0x0000002f008f7306ULL, 0x0004e2000020d400ULL,
0x000000c5c400720bULL, 0x000fce0003fdd000ULL, 0x00000070003b7306ULL, 0x000fe20000209400ULL,
0x00000018ff2f7819ULL, 0x004fe40000011447ULL, 0x000000c8c700720bULL, 0x002fc60003f5d000ULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x0000007000da7306ULL, 0x000e620000205400ULL,
0x000000abb000720bULL, 0x000fce0003fdd000ULL, 0x0000007000997306ULL, 0x000522000020d400ULL,
0x000000018f8f2812ULL, 0x008fc800078efcffULL, 0x000000938f93723eULL, 0x000fe400000010ffULL,
0x000000017d7d6812ULL, 0x000fe200078efcffULL, 0x0000004700c07306ULL, 0x000fe20000009400ULL,
0x0000010047707824ULL, 0x004fe200078e00ffULL, 0x000000da3b00720bULL, 0x002fcc0003f7d000ULL,
0x0000004700c17306ULL, 0x000fee0000005400ULL, 0x0000000199993812ULL, 0x010fe200078efcffULL,
0x00000047007f7306ULL, 0x0003f0000000d400ULL, 0x0000006f00887306ULL, 0x0004e2000020d400ULL,
0x0001000047477824ULL, 0x002fce00078e00ffULL, 0x0000004600be7306ULL, 0x000fe20000009400ULL,
0x00000018ff6f7819ULL, 0x004fce0000011447ULL, 0x0000004600bf7306ULL, 0x000e620000005400ULL,
0x0000000188885812ULL, 0x008fce00078efcffULL, 0x0000004600807306ULL, 0x0004f0000000d400ULL,
0x0000007400907306ULL, 0x000962000020d400ULL, 0x0001000046467824ULL, 0x004fe200078e00ffULL,
0x000000bfbe00720bULL, 0x002fcc0003f3d000ULL, 0x0000004500dd7306ULL, 0x000fe20000209400ULL,
0x00000018ff747819ULL, 0x010fe40000011470ULL, 0x00000018ff707819ULL, 0x000fe20000011446ULL,
0x0000010054467824ULL, 0x000fc600078e00ffULL, 0x0000000180801812ULL, 0x008fe200078efcffULL,
0x0000004500de7306ULL, 0x000e620000205400ULL, 0x0000000190904812ULL, 0x020fe400078efcffULL,
0x000000c1c000720bULL, 0x000fe40003f9d000ULL, 0x00009910bdc07816ULL, 0x000fe200000000ffULL,
0x000100004cbd7824ULL, 0x000fe200078e00ffULL, 0x000000808888723eULL, 0x000fe200000010ffULL,
0x0000004500947306ULL, 0x000ea4000020d400ULL, 0x000000ffffab7224ULL, 0x000fe200078e00c0ULL,
0x00000018ffbd7819ULL, 0x000fc800000114bdULL, 0x000000ffab00720cULL, 0x000fe20003f25270ULL,
0x0000006f00447306ULL, 0x000fe20000209400ULL, 0x000000017f7f4812ULL, 0x000fe400078efcffULL,
0x000000dedd00720bULL, 0x002fca0003f7d000ULL, 0x0000006f00457306ULL, 0x000e700000205400ULL,
0x0000002c00c27306ULL, 0x000fe20000209400ULL, 0x0000000194943812ULL, 0x004fce00078efcffULL,
0x0000002c00c37306ULL, 0x000ea20000205400ULL, 0x000000454400720bULL, 0x002fe20003fbd000ULL,
0x000100004d447824ULL, 0x000fe200078e00ffULL, 0x000000a7a545723eULL, 0x000fca00000010ffULL,
0x0000002c00867306ULL, 0x0002f0000020d400ULL, 0x0000005400b67306ULL, 0x000fe20000009400ULL,
0x00000018ff2c7819ULL, 0x002fe40000011454ULL, 0x000000c3c200720bULL, 0x004fc40003f5d000ULL,
0x00000018ffc27819ULL, 0x000fe40000011438ULL, 0x0000b0001a387811ULL, 0x000fe200078e20ffULL,
0x0000005400ae7306ULL, 0x000fea0000005400ULL, 0x000000003838783bULL, 0x000e660000000200ULL,
0x0000005400727306ULL, 0x0005e2000000d400ULL, 0x0000000186862812ULL, 0x008fc800078efcffULL,
0x000000918686723eULL, 0x000fc600000010ffULL, 0x0000006f00837306ULL, 0x000722000020d400ULL,
0x0001000054547824ULL, 0x004fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000002f00b47306ULL, 0x000fe20000209400ULL, 0x00000100566f7824ULL, 0x008fce00078e00ffULL,
0x0000002f00b57306ULL, 0x000ea20000205400ULL, 0x0000000183835812ULL, 0x010fce00078efcffULL,
0x0000005400cf7306ULL, 0x000fe20000209400ULL, 0x0000007138389231ULL, 0x082fe400003400ffULL,
0x000000713a3a9231ULL, 0x000fca00003400ffULL, 0x0000005400d07306ULL, 0x000e620000205400ULL,
0x000000b5b400720bULL, 0x004fe20003f9d000ULL, 0x000001004fb47824ULL, 0x000fe200078e00ffULL,
0x0000006939399231ULL, 0x080fe400003400ffULL, 0x000000693b3b9231ULL, 0x000fe400003400ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000002f007c7306ULL, 0x0004f0000020d400ULL,
0x00000054007e7306ULL, 0x000962000020d400ULL, 0x000000d0cf00720bULL, 0x002fc40003fbd000ULL,
0x00000018ff2f7819ULL, 0x004fca0000011457ULL, 0x0000005500ad7306ULL, 0x000fe20000009400ULL,
0x00000018ff547819ULL, 0x010fe2000001146fULL, 0x00000100576f7824ULL, 0x000fe200078e00ffULL,
0x000000017c7c4812ULL, 0x008fca00078efcffULL, 0x0000005500af7306ULL, 0x000e620000005400ULL,
0x000000017e7e5812ULL, 0x020fe400078efcffULL, 0x000000acb100720bULL, 0x000fca0003fbd000ULL,
0x0000007400e17306ULL, 0x000ff00000209400ULL, 0x0000007400e27306ULL, 0x000ea20000205400ULL,
0x000000afad00720bULL, 0x002fe40003f9d000ULL, 0x0000000166665812ULL, 0x000fca00078efcffULL,
0x0000007400897306ULL, 0x0002f0000020d400ULL, 0x0000005500737306ULL, 0x000f22000000d400ULL,
0x00000018ff747819ULL, 0x002fe40000011446ULL, 0x000000e2e100720bULL, 0x004fca0003f5d000ULL,
0x0000007400467306ULL, 0x000ff00000209400ULL, 0x0000007400477306ULL, 0x000e620000205400ULL,
0x0000000189892812ULL, 0x008fe400078efcffULL, 0x0000000173734812ULL, 0x010fc400078efcffULL,
0x000000aeb600720bULL, 0x000fe20003f5d000ULL, 0x000100004fae7824ULL, 0x000fe200078e00ffULL,
0x0000007f8989723eULL, 0x000fe200000010ffULL, 0x0000007400817306ULL, 0x0004e6000020d400ULL,
0x00000018ffae7819ULL, 0x000fc600000114aeULL, 0x000000883840723cULL, 0x000fe40000041840ULL,
0x0000007000e67306ULL, 0x000fe20000209400ULL, 0x00000018ff747819ULL, 0x004fe4000001146fULL,
0x000000474600720bULL, 0x002fe40003fdd000ULL, 0x0000000172722812ULL, 0x000fe400078efcffULL,
0x000000a8b747723eULL, 0x000fe200000010ffULL, 0x0000007000e77306ULL, 0x000e620000205400ULL,
0x000000aab846723eULL, 0x000fce00000010ffULL, 0x0000005400cb7306ULL, 0x000fe20000209400ULL,
0x0000000181816812ULL, 0x008fe200078efcffULL, 0x00000046385c723cULL, 0x000fe6000004185cULL,
0x000000728172723eULL, 0x000fc600000010ffULL, 0x0000005400cc7306ULL, 0x000ea20000205400ULL,
0x000000e7e600720bULL, 0x002fce0003f7d000ULL, 0x0000007400b97306ULL, 0x000ff00000209400ULL,
0x0000007400ba7306ULL, 0x000e620000205400ULL, 0x000000cccb00720bULL, 0x004fce0003f9d000ULL,
0x0000007000847306ULL, 0x0004f0000020d400ULL, 0x00000054007a7306ULL, 0x000962000020d400ULL,
0x0000010055707824ULL, 0x004fe200078e00ffULL, 0x000000bab900720bULL, 0x002fe20003fbd000ULL,
0x0001000055557824ULL, 0x000fc600078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000074006f7306ULL, 0x000e62000020d400ULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0001000057547824ULL, 0x010fe200078e00ffULL, 0x0000000184843812ULL, 0x008fc800078efcffULL,
0x00000018fffa7819ULL, 0x000fe20000011454ULL, 0x0000002c00b27306ULL, 0x000fe20000209400ULL,
0x000000017a7a4812ULL, 0x020fe400078efcffULL, 0x000000929d00720bULL, 0x000fe40003f9d000ULL,
0x000000a19c92723eULL, 0x000fe400000010ffULL, 0x000000847d84723eULL, 0x000fe200000010ffULL,
0x0000002c00b37306ULL, 0x000ea20000205400ULL, 0x000000016f6f5812ULL, 0x002fc600078efcffULL,
0x000000923858723cULL, 0x000fe80000041858ULL, 0x0000002f008e7306ULL, 0x000fe20000209400ULL,
0x0000000165654812ULL, 0x000fce00078efcffULL, 0x0000002f008c7306ULL, 0x000e620000205400ULL,
0x000000b3b200720bULL, 0x004fe20003f7d000ULL, 0x000001004eb37824ULL, 0x040fe400078e00ffULL,
0x000100004eb27824ULL, 0x000fc600078e00ffULL, 0x00000018ffb37819ULL, 0x000fe200000114b3ULL,
0x0000007000d17306ULL, 0x000fe20000209400ULL, 0x00000018ffb27819ULL, 0x000fce00000114b2ULL,
0x0000007000d27306ULL, 0x000ea20000205400ULL, 0x0000008c8e00720bULL, 0x002fce0003fbd000ULL,
0x0000005600d57306ULL, 0x000ff00000009400ULL, 0x0000005600d67306ULL, 0x000e620000005400ULL,
0x000000d2d100720bULL, 0x004fce0003f5d000ULL, 0x0000002c006a7306ULL, 0x000eb0000020d400ULL,
0x0000002f002c7306ULL, 0x000ee2000020d400ULL, 0x000000d6d500720bULL, 0x002fce0003fdd000ULL,
0x00000030006b7306ULL, 0x000fe20000209400ULL, 0x000000016a6a3812ULL, 0x004fc800078efcffULL,
0x0000007e6a6a723eULL, 0x000fc600000010ffULL, 0x00000030006c7306ULL, 0x000fe20000205400ULL,
0x000000012c2c5812ULL, 0x008fce00078efcffULL, 0x0000003000327306ULL, 0x000ff0000020d400ULL,
0x0000007900647306ULL, 0x000ff00000209400ULL, 0x00000079002f7306ULL, 0x000ff00000205400ULL,
0x0000007900307306ULL, 0x000ff0000020d400ULL, 0x0000005500d37306ULL, 0x000ff00000209400ULL,
0x0000005500d47306ULL, 0x000e700000205400ULL, 0x0000005500797306ULL, 0x0004f0000020d400ULL,
0x0000007000827306ULL, 0x000f22000020d400ULL, 0x0001000056557824ULL, 0x004fe200078e00ffULL,
0x000000d4d300720bULL, 0x002fc80003f7d000ULL, 0x00000018fff87819ULL, 0x000fe40000011455ULL,
0x00000056007b7306ULL, 0x000e6e000000d400ULL, 0x0000000179793812ULL, 0x008fe200078efcffULL,
0x0000005700cd7306ULL, 0x000fe20000009400ULL, 0x0000000182822812ULL, 0x010fc800078efcffULL,
0x000000738273723eULL, 0x000fc600000010ffULL, 0x0000005700ce7306ULL, 0x000ea20000005400ULL,
0x000000017b7b6812ULL, 0x002fc800078efcffULL, 0x0000007b7a7a723eULL, 0x000fc600000010ffULL,
0x000000f8009f7306ULL, 0x000ff00000209400ULL, 0x000000f800a07306ULL, 0x000e620000205400ULL,
0x000000cecd00720bULL, 0x004fce0003f5d000ULL, 0x000000d700977306ULL, 0x000ff00000209400ULL,
0x000000d700987306ULL, 0x000ea20000205400ULL, 0x000000a09f00720bULL, 0x002fce0003fdd000ULL,
0x000000c200be7306ULL, 0x000ff00000209400ULL, 0x000000c200bf7306ULL, 0x000e620000205400ULL,
0x000000989700720bULL, 0x004fce0003f9d000ULL, 0x0000004f00757306ULL, 0x000ff00000009400ULL,
0x0000004f00787306ULL, 0x000fe20000005400ULL, 0x000000bfbe00720bULL, 0x002fce0003fbd000ULL,
0x0000004f006d7306ULL, 0x0003f0000000d400ULL, 0x0000004c00bb7306ULL, 0x000fe20000009400ULL,
0x00000018ff4f7819ULL, 0x002fe40000011444ULL, 0x000000a9a644723eULL, 0x000fca00000010ffULL,
0x0000004c00bc7306ULL, 0x000e640000005400ULL, 0x000000443860723cULL, 0x000fec0000041860ULL,
0x0000004c00557306ULL, 0x000ea2000000d400ULL, 0x0000b0001b447811ULL, 0x000fcc00078e20ffULL,
0x000000004444783bULL, 0x000ee20000000200ULL, 0x0000005700707306ULL, 0x000f22000000d400ULL,
0x000000bcbb00720bULL, 0x002fce0003f7d000ULL, 0x000000f800747306ULL, 0x000e6c000020d400ULL,
0x0000000155553812ULL, 0x004fe400078efcffULL, 0x000000d7006e7306ULL, 0x000ea2000020d400ULL,
0x0000000170702812ULL, 0x010fe400078efcffULL, 0x0000006c6b00720bULL, 0x000fc40003f7d000ULL,
0x000000706f7b723eULL, 0x000fe400000010ffULL, 0x00000079666b723eULL, 0x000fe200000010ffULL,
0x000000c2004c7306ULL, 0x000f22000020d400ULL, 0x0000000174746812ULL, 0x002fc800078efcffULL,
0x000000746574723eULL, 0x000fc600000010ffULL, 0x000000fa009a7306ULL, 0x000fe20000209400ULL,
0x000000016e6e4812ULL, 0x004fe400078efcffULL, 0x0000000132323812ULL, 0x000fe400078efcffULL,
0x000000787500720bULL, 0x000fe20003f7d000ULL, 0x0000007144449231ULL, 0x088fe400003400ffULL,
0x000000fa009b7306ULL, 0x000e620000205400ULL, 0x000000014c4c5812ULL, 0x010fe200078efcffULL,
0x0000007146469231ULL, 0x000fe200003400ffULL, 0x000000556e6e723eULL, 0x000fe200000010ffULL,
0x0000006945459231ULL, 0x000fc400003400ffULL, 0x0000006947479231ULL, 0x000fe400003400ffULL,
0x0000004d00957306ULL, 0x000fe40000009400ULL, 0x000000016d6d3812ULL, 0x000fc600078efcffULL,
0x00000072445c723cULL, 0x000fe6000004185cULL, 0x0000004d00967306ULL, 0x000ea20000005400ULL,
0x0000009b9a00720bULL, 0x002fc80003f5d000ULL, 0x0000006a4460723cULL, 0x000fe60000041860ULL,
0x000000bd00ab7306ULL, 0x000ff00000209400ULL, 0x000000bd00b07306ULL, 0x000e620000205400ULL,
0x000000969500720bULL, 0x004fce0003fdd000ULL, 0x0000004f00ad7306ULL, 0x000ff00000209400ULL,
0x0000004f00a87306ULL, 0x000ea20000205400ULL, 0x000000b0ab00720bULL, 0x002fce0003f9d000ULL,
0x0000004e008a7306ULL, 0x000ff00000009400ULL, 0x0000004e008b7306ULL, 0x000fe20000005400ULL,
0x000000a8ad00720bULL, 0x004fce0003fbd000ULL, 0x0000004e00577306ULL, 0x0003f0000000d400ULL,
0x0000004f00a97306ULL, 0x0004e2000020d400ULL, 0x000000a3a44e723eULL, 0x002fce00000010ffULL,
0x0000004d00567306ULL, 0x000e62000000d400ULL, 0x0000009ea24f723eULL, 0x004fce00000010ffULL,
0x0000004e3834723cULL, 0x000fe20000041834ULL, 0x000000fa00547306ULL, 0x000ea2000020d400ULL,
0x00000001a9a95812ULL, 0x008fca00078efcffULL, 0x0000008d994e723eULL, 0x000fe400000010ffULL,
0x000000bd004d7306ULL, 0x000ee2000020d400ULL, 0x00000087904f723eULL, 0x000fe400000010ffULL,
0x000000948587723eULL, 0x000fe400000010ffULL, 0x000000837c85723eULL, 0x000fe400000010ffULL,
0x0000000156566812ULL, 0x002fe200078efcffULL, 0x000000b300a57306ULL, 0x000fe20000209400ULL,
0x0000004e3850723cULL, 0x000fe20000041850ULL, 0x0000000154542812ULL, 0x004fc400078efcffULL,
0x0000008b8a00720bULL, 0x000fe40003f5d000ULL, 0x000000686700720bULL, 0x000fe40003fdd000ULL,
0x000000b3009c7306ULL, 0x000e620000205400ULL, 0x000000863848723cULL, 0x000fe20000041848ULL,
0x000000014d4d4812ULL, 0x008fe400078efcffULL, 0x000000542c75723eULL, 0x000fe400000010ffULL,
0x000000564c6f723eULL, 0x000fc400000010ffULL, 0x000000b4008d7306ULL, 0x000fe20000209400ULL,
0x000000843838723cULL, 0x000fe2000004183cULL, 0x0000000157572812ULL, 0x000fe400078efcffULL,
0x000000012e2e6812ULL, 0x000fe400078efcffULL, 0x000000332d00720bULL, 0x000fe40003fdd000ULL,
0x000000b400807306ULL, 0x000ea20000205400ULL, 0x0000009ca500720bULL, 0x002fe20003f9d000ULL,
0x0000007a4434723cULL, 0x000fe20000041834ULL, 0x0000004d3232723eULL, 0x000fc400000010ffULL,
0x000000a92e33723eULL, 0x000fc600000010ffULL, 0x000000b3008c7306ULL, 0x000e64000020d400ULL,
0x000000744458723cULL, 0x000fe20000041858ULL, 0x0000000131316812ULL, 0x000fca00078efcffULL,
0x000000b400867306ULL, 0x000ee2000020d400ULL, 0x000000808d00720bULL, 0x004fe20003fbd000ULL,
0x0000006e4450723cULL, 0x040fec0000041850ULL, 0x000000b2004e7306ULL, 0x000fe20000209400ULL,
0x000000018c8c4812ULL, 0x002fe200078efcffULL, 0x000000324448723cULL, 0x000fe20000041848ULL,
0x0000002f6400720bULL, 0x000fc40003f9d000ULL, 0x000000578c6c723eULL, 0x000fc600000010ffULL,
0x000000b2003d7306ULL, 0x000e620000205400ULL, 0x0000000186865812ULL, 0x008fc800078efcffULL,
0x0000006d866d723eULL, 0x000fc600000010ffULL, 0x000000ae003c7306ULL, 0x000fe20000209400ULL,
0x0000000130304812ULL, 0x000fc600078efcffULL, 0x0000006c4440723cULL, 0x000fe80000041840ULL,
0x000000ae003f7306ULL, 0x000ea20000205400ULL, 0x0000003d4e00720bULL, 0x002fce0003f5d000ULL,
0x000000b200b27306ULL, 0x000e70000020d400ULL, 0x000000ae00b37306ULL, 0x000ee2000020d400ULL,
0x0000003f3c00720bULL, 0x004fe40003fbd000ULL, 0x00000001b2b22812ULL, 0x002fc800078efcffULL,
0x000000b231b2723eULL, 0x000fce00000010ffULL, 0x00000001b3b35812ULL, 0x008fc800078efcffULL,
0x000000b330b3723eULL, 0x000fce00000010ffULL, 0x000000b24438723cULL, 0x000fe20000041838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff2c7f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff2f7984ULL, 0x000e640000000800ULL, 0x800000002fff7812ULL, 0x002fe4000784482dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff2f7984ULL, 0x000e640000000800ULL,
0x800000002fff7812ULL, 0x002fc4000784482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff2e7424ULL, 0x000fc800078e00ffULL,
0x0000002e002f7305ULL, 0x0002a4000021f000ULL, 0x3fa000002e2e7823ULL, 0x002fe200000100ffULL,
0x0000002f0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff2f7984ULL, 0x000e640000000800ULL,
0x800000002fff7812ULL, 0x002fe4000784482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004000327811ULL, 0x000fe400078e38ffULL, 0x000000c0052d7811ULL, 0x000fc600078e40ffULL,
0x00000001282f7824ULL, 0x100fe200078e0232ULL, 0x0000002d042c7217ULL, 0x000fe20007800000ULL,
0x0000000129317824ULL, 0x100fe400078e0232ULL, 0x000000012b337824ULL, 0x100fe200078e0232ULL,
0x0000002a2f2f7210ULL, 0x080fe20007f7e0ffULL, 0x000000012c2c7824ULL, 0x000fe200078e0a2dULL,
0x0000002a31307210ULL, 0x000fe20007f5e0ffULL, 0x000000011c3d7824ULL, 0x000fe400078e0232ULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e002f3e7a11ULL, 0x000fe200078640ffULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x00005e0030447a11ULL, 0x000fc400078440ffULL,
0x00005f002f2f7a11ULL, 0x000fe400018f442eULL, 0x0000002a33337210ULL, 0x080fe40007f7e0ffULL,
0x000000202c2c7807ULL, 0x000fe40000000000ULL, 0x00005f00302d7a11ULL, 0x000fe200010f4431ULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x0000002a3d317210ULL, 0x000fe40007f5e0ffULL,
0x0000002c092c7217ULL, 0x000fc40007800000ULL, 0x00005e0033327a11ULL, 0x040fe200078640ffULL,
0x000000ffff3c7224ULL, 0x000fe200010e06ffULL, 0x00000004ff3d7819ULL, 0x000fe20000011603ULL,
0x000000012c1c7824ULL, 0x000fe200078e0a09ULL, 0x00005f0033337a11ULL, 0x000fe400018f442eULL,
0x00005e0031307a11ULL, 0x000fe400078440ffULL, 0x0000000f442c7210ULL, 0x000fe40007f7e0ffULL,
0x000000023d3f7810ULL, 0x000fc40007ffe0ffULL, 0x00005f0031317a11ULL, 0x000fe200010f443cULL,
0x000000ffff2d7224ULL, 0x000fe200018e062dULL, 0x0000000f3e2e7210ULL, 0x080fe40007f9e0ffULL,
0x0000001c3f00720cULL, 0x080fe40003f46070ULL, 0x0000000f30307210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2f7224ULL, 0x000fe200020e062fULL, 0x000000043d3f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c3d00720cULL, 0x040fe20003f66070ULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x000000063d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c3f00720cULL, 0x080fe40003f86070ULL,
0x0000001c3d00720cULL, 0x000fe40003fa6070ULL, 0x0000000f32327210ULL, 0x000fca0007fde0ffULL,
0x000000ffff337224ULL, 0x000fe200030e0633ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c1d7faeULL, 0x0003e8000d901c46ULL, 0x000000002e1e7faeULL, 0x0003e8000d101c46ULL,
0x00000000301f7faeULL, 0x0003e8000e101c46ULL, 0x0000000032207faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff2d7984ULL, 0x002e640000000800ULL,
0x800000002dff7812ULL, 0x002fc40007844877ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff2d7984ULL, 0x000e640000000800ULL, 0x800000002dff7812ULL, 0x002fe40007844877ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c002c7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000002c0000735dULL, 0x004fe20003800000ULL,
0x0106b400ff2d7984ULL, 0x000e640000000800ULL, 0x800000002dff7812ULL, 0x002fc40007844877ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff1c723eULL, 0x000fe400000010ffULL,
0x00000002ff6f7819ULL, 0x000fe40000011603ULL, 0x000054101c687816ULL, 0x000fe2000000001cULL,
0x00010c927f007947ULL, 0x000fea000b800000ULL, 0x00001f6f68ad7589ULL, 0x0002a400000e0000ULL,
0x00010cd27f007947ULL, 0x000fea000b800000ULL, 0x00001ff468ac7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f9ULL,
0x0000e3e000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x0001169000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f7ULL,
0x0000e44000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x0001163000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000212c783bULL, 0x000f680000004200ULL,
0x00000000223c783bULL, 0x000e680000004200ULL, 0x00000000234c783bULL, 0x000ee20000004200ULL,
0x00000018ff307819ULL, 0x020fe2000001142dULL, 0x0000002c006a7306ULL, 0x002fe20000009400ULL,
0x00000018ff317819ULL, 0x000fe2000001142eULL, 0x000001002c707824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fc4000001142fULL, 0x00000018ff467819ULL, 0x000fe4000001143eULL,
0x00000018ff1c7819ULL, 0x000fe2000001142cULL, 0x0000003000847306ULL, 0x000fe20000209400ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff447819ULL, 0x000fe4000001143dULL,
0x00000018ff477819ULL, 0x000fe4000001143fULL, 0x00000018ff557819ULL, 0x008fe2000001144fULL,
0x0000003000857306ULL, 0x000ff00000205400ULL, 0x0000003000a97306ULL, 0x000ff0000020d400ULL,
0x0000003100dd7306ULL, 0x000ff00000209400ULL, 0x0000003100de7306ULL, 0x000ff00000205400ULL,
0x00000031009e7306ULL, 0x000ff0000020d400ULL, 0x0000003200927306ULL, 0x000ff00000209400ULL,
0x0000003200db7306ULL, 0x000ff00000205400ULL, 0x0000003200997306ULL, 0x0003f0000020d400ULL,
0x0000004600c37306ULL, 0x000fe20000209400ULL, 0x000000002430783bULL, 0x002e6e0000004200ULL,
0x0000004600c07306ULL, 0x000ff00000205400ULL, 0x0000004600797306ULL, 0x0007f0000020d400ULL,
0x0000002c00ef7306ULL, 0x000f620000005400ULL, 0x00000018ff467819ULL, 0x008fce000001144eULL,
0x00000046008a7306ULL, 0x000ff00000209400ULL, 0x00000046008b7306ULL, 0x000fe20000205400ULL,
0x00000018ff727819ULL, 0x002fe40000011431ULL, 0x000000ef6a00720bULL, 0x020fc40003f7d000ULL,
0x00000018ff767819ULL, 0x000fe40000011433ULL, 0x00000018ff737819ULL, 0x000fe20000011432ULL,
0x0000004600577306ULL, 0x000ff0000020d400ULL, 0x0000007200687306ULL, 0x000ff00000209400ULL,
0x0000007200697306ULL, 0x000ff00000205400ULL, 0x0000007200467306ULL, 0x0003f0000020d400ULL,
0x0000002c00b67306ULL, 0x000762000000d400ULL, 0x000001002d727824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000001c00f07306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x008fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000007200e97306ULL, 0x000fe20000209400ULL, 0x00000001b6b63812ULL, 0x020fce00078efcffULL,
0x0000007200ec7306ULL, 0x000e700000205400ULL, 0x0000001c008f7306ULL, 0x000ef00000205400ULL,
0x0000002c00a57306ULL, 0x000fe20000209400ULL, 0x000000ece900720bULL, 0x002fce0003f7d000ULL,
0x0000002c00f27306ULL, 0x000e620000205400ULL, 0x0000008ff000720bULL, 0x008fce0003f9d000ULL,
0x0000007200ba7306ULL, 0x000ef0000020d400ULL, 0x0000002d00ed7306ULL, 0x000fe20000009400ULL,
0x000000f2a500720bULL, 0x002fce0003f5d000ULL, 0x0000002d00907306ULL, 0x000e620000005400ULL,
0x00000001baba3812ULL, 0x008fce00078efcffULL, 0x0000002e00987306ULL, 0x000ff00000009400ULL,
0x0000002e006f7306ULL, 0x000ee20000005400ULL, 0x00000090ed00720bULL, 0x002fce0003fbd000ULL,
0x0000007000b17306ULL, 0x000ff00000209400ULL, 0x0000007000a47306ULL, 0x000e620000205400ULL,
0x0000006f9800720bULL, 0x008fce0003f7d000ULL, 0x0000007000bb7306ULL, 0x0007f0000020d400ULL,
0x0000002d00b57306ULL, 0x000b22000000d400ULL, 0x000001002e707824ULL, 0x008fe200078e00ffULL,
0x000000a4b100720bULL, 0x002fc80003fdd000ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000002c00b77306ULL, 0x0002e2000020d400ULL, 0x000100002d2d7824ULL, 0x020fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002f00dc7306ULL, 0x000fe20000009400ULL,
0x000001002f2c7824ULL, 0x002fe200078e00ffULL, 0x00000001b5b55812ULL, 0x010fe400078efcffULL,
0x00000001bbbb6812ULL, 0x000fe400078efcffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002f00917306ULL, 0x000fe20000005400ULL, 0x00000001b7b72812ULL, 0x008fc400078efcffULL,
0x000000858400720bULL, 0x000fca0003fdd000ULL, 0x0000002f009f7306ULL, 0x0003f0000000d400ULL,
0x0000001c00b27306ULL, 0x000722000020d400ULL, 0x000100002f2f7824ULL, 0x002fe200078e00ffULL,
0x00000001a9a96812ULL, 0x000fc800078efcffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000007000977306ULL, 0x000fe20000209400ULL, 0x00000018ff1c7819ULL, 0x008fce000001143cULL,
0x0000007000ea7306ULL, 0x000e620000205400ULL, 0x00000001b2b24812ULL, 0x010fce00078efcffULL,
0x0000002e00a67306ULL, 0x000730000000d400ULL, 0x0000002d00eb7306ULL, 0x000fe20000209400ULL,
0x000000ea9700720bULL, 0x002fe20003f9d000ULL, 0x000100002e2e7824ULL, 0x008fca00078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000002d00ee7306ULL, 0x000e620000205400ULL,
0x00000001a6a63812ULL, 0x010fce00078efcffULL, 0x0000002c00e17306ULL, 0x000ff00000209400ULL,
0x0000002c00e27306ULL, 0x000ee20000205400ULL, 0x000000eeeb00720bULL, 0x002fce0003f5d000ULL,
0x0000002f00e57306ULL, 0x000ff00000209400ULL, 0x0000002f00e67306ULL, 0x000e620000205400ULL,
0x000000e2e100720bULL, 0x008fce0003fbd000ULL, 0x0000001c00887306ULL, 0x000ff00000209400ULL,
0x0000001c00d77306ULL, 0x000fe20000205400ULL, 0x000000e6e500720bULL, 0x002fce0003f7d000ULL,
0x0000001c00897306ULL, 0x0003f0000020d400ULL, 0x0000007000ab7306ULL, 0x000ee2000020d400ULL,
0x00000018ff1c7819ULL, 0x002fce000001144cULL, 0x0000001c00b47306ULL, 0x000ff00000209400ULL,
0x0000001c00b37306ULL, 0x000fe20000205400ULL, 0x00000001abab4812ULL, 0x008fe400078efcffULL,
0x000000dedd00720bULL, 0x000fca0003f9d000ULL, 0x0000001c006c7306ULL, 0x0003f0000020d400ULL,
0x0000004400d67306ULL, 0x000fe20000209400ULL, 0x00000018ff1c7819ULL, 0x002fe40000011430ULL,
0x000000019e9e4812ULL, 0x000fca00078efcffULL, 0x0000004400877306ULL, 0x000ff00000205400ULL,
0x0000004400817306ULL, 0x0003f0000020d400ULL, 0x0000002d00aa7306ULL, 0x000722000020d400ULL,
0x00000018ff447819ULL, 0x002fce000001144dULL, 0x0000002c00a07306ULL, 0x000362000020d400ULL,
0x000001003c2d7824ULL, 0x008fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe4000001142dULL,
0x0000002f009a7306ULL, 0x000ee2000020d400ULL, 0x000001003d2c7824ULL, 0x002fe200078e00ffULL,
0x00000001aaaa2812ULL, 0x010fe400078efcffULL, 0x00000091dc00720bULL, 0x000fc80003f5d000ULL,
0x0000003d00d97306ULL, 0x000fe20000009400ULL, 0x00000001a0a05812ULL, 0x020fe400078efcffULL,
0x000000db9200720bULL, 0x000fca0003fbd000ULL, 0x0000003d00da7306ULL, 0x000e620000005400ULL,
0x000000019a9a3812ULL, 0x008fe400078efcffULL, 0x000000019f9f2812ULL, 0x000fca00078efcffULL,
0x0000004700be7306ULL, 0x000fe20000209400ULL, 0x0000000199995812ULL, 0x000fe400078efcffULL,
0x000000d78800720bULL, 0x000fca0003fbd000ULL, 0x0000004700c17306ULL, 0x000fe20000205400ULL,
0x000000dad900720bULL, 0x002fce0003f7d000ULL, 0x0000004700757306ULL, 0x000fe2000020d400ULL,
0x0000000189895812ULL, 0x000fce00078efcffULL, 0x00000055007c7306ULL, 0x000ff00000209400ULL,
0x00000055007d7306ULL, 0x000ff00000205400ULL, 0x0000005500547306ULL, 0x000ff0000020d400ULL,
0x0000001c006d7306ULL, 0x000ff00000209400ULL, 0x0000001c006e7306ULL, 0x000ff00000205400ULL,
0x0000001c00477306ULL, 0x000ff0000020d400ULL, 0x0000004400a77306ULL, 0x000ff00000209400ULL,
0x0000004400a87306ULL, 0x000ff00000205400ULL, 0x0000004400677306ULL, 0x004ff0000020d400ULL,
0x0000007600557306ULL, 0x000ff00000209400ULL, 0x0000007600567306ULL, 0x000ff00000205400ULL,
0x00000076001c7306ULL, 0x0003f0000020d400ULL, 0x0000007300647306ULL, 0x000fe20000209400ULL,
0x000001003e767824ULL, 0x002fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x0000007300657306ULL, 0x000ff00000205400ULL, 0x0000007300447306ULL, 0x0003f0000020d400ULL,
0x0000003d008c7306ULL, 0x0004e2000000d400ULL, 0x00000018ff737819ULL, 0x002fce000001142cULL,
0x00000073002c7306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x004fce00078e00ffULL,
0x00000073002d7306ULL, 0x000e620000205400ULL, 0x000000018c8c3812ULL, 0x008fce00078efcffULL,
0x0000007000e77306ULL, 0x000ff00000209400ULL, 0x0000007000e87306ULL, 0x000ea20000205400ULL,
0x0000002d2c00720bULL, 0x002fe20003f9d000ULL, 0x00000100312c7824ULL, 0x000fca00078e00ffULL,
0x00000018ffd77819ULL, 0x000fe2000001142cULL, 0x0000002e00e37306ULL, 0x000fe20000209400ULL,
0x0000b000252c7811ULL, 0x000fce00078e20ffULL, 0x0000002e00e47306ULL, 0x000e620000205400ULL,
0x000000e8e700720bULL, 0x004fce0003f5d000ULL, 0x0000007600df7306ULL, 0x000ff00000209400ULL,
0x0000007600e07306ULL, 0x000ea20000205400ULL, 0x000000e4e300720bULL, 0x002fce0003fdd000ULL,
0x0000003c00d87306ULL, 0x000ff00000009400ULL, 0x0000003c00717306ULL, 0x000fe20000005400ULL,
0x000000e0df00720bULL, 0x004fce0003f7d000ULL, 0x0000003c00947306ULL, 0x0003f0000000d400ULL,
0x0000003e00c77306ULL, 0x000fe20000009400ULL, 0x000100003c3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe4000001143cULL, 0x0000003e00c67306ULL, 0x000ff00000005400ULL,
0x0000003e007e7306ULL, 0x0003f0000000d400ULL, 0x0000007300957306ULL, 0x0004e2000020d400ULL,
0x000100003e3e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000070009b7306ULL, 0x000322000020d400ULL, 0x000001003f737824ULL, 0x004fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000002e00a17306ULL, 0x000ea2000020d400ULL,
0x00000018ff707819ULL, 0x002fe4000001143dULL, 0x0000000195954812ULL, 0x008fca00078efcffULL,
0x00000070003c7306ULL, 0x000fe20000209400ULL, 0x000000019b9b2812ULL, 0x010fce00078efcffULL,
0x00000070003d7306ULL, 0x000e620000205400ULL, 0x00000001a1a16812ULL, 0x004fe400078efcffULL,
0x00000071d800720bULL, 0x000fca0003fdd000ULL, 0x00000072002e7306ULL, 0x000ff00000209400ULL,
0x00000072002f7306ULL, 0x000ea20000205400ULL, 0x0000003d3c00720bULL, 0x002fe40003f9d000ULL,
0x0000000194946812ULL, 0x000fc400078efcffULL, 0x00000087d600720bULL, 0x000fe40003fdd000ULL,
0x0000b000263c7811ULL, 0x000fe200078e20ffULL, 0x00000076008d7306ULL, 0x000e70000020d400ULL,
0x0000007300d07306ULL, 0x000fe20000209400ULL, 0x0000002f2e00720bULL, 0x004fc40003f5d000ULL,
0x000000002c2c783bULL, 0x000ea20000000200ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x000000c0c300720bULL, 0x000fe20003fdd000ULL, 0x0000010033c37824ULL, 0x000fe200078e00ffULL,
0x0000007300d17306ULL, 0x000ee20000205400ULL, 0x000000018d8d3812ULL, 0x002fc600078efcffULL,
0x00000018ffc37819ULL, 0x000fc800000114c3ULL, 0x0000003e00ca7306ULL, 0x000fe60000209400ULL,
0x0000000179796812ULL, 0x000fca00078efcffULL, 0x0000003e00cb7306ULL, 0x000e620000205400ULL,
0x000000d1d000720bULL, 0x008fce0003fbd000ULL, 0x0000003f00937306ULL, 0x000ff00000009400ULL,
0x0000003f00c27306ULL, 0x000fe20000005400ULL, 0x000000cbca00720bULL, 0x002fe20003f7d000ULL,
0x000000ad2c2c9231ULL, 0x004fc400003400ffULL, 0x000000ad2e2e9231ULL, 0x000fe400003400ffULL,
0x000000ac2d2d9231ULL, 0x080fe400003400ffULL, 0x0000003f00787306ULL, 0x0003e2000000d400ULL,
0x000000ac2f2f9231ULL, 0x000fce00003400ffULL, 0x00000070008e7306ULL, 0x0004e2000020d400ULL,
0x000100003f3f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000007200967306ULL, 0x000322000020d400ULL, 0x000001004c707824ULL, 0x004fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000007300837306ULL, 0x000ea2000020d400ULL,
0x000000018e8e4812ULL, 0x008fe200078efcffULL, 0x000001004d727824ULL, 0x002fe200078e00ffULL,
0x000000c29300720bULL, 0x000fe20003f9d000ULL, 0x0000010032c27824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000003e00867306ULL, 0x0002e2000020d400ULL,
0x0000000196962812ULL, 0x010fe400078efcffULL, 0x000000c6c700720bULL, 0x000fe40003f5d000ULL,
0x00000018ffc27819ULL, 0x000fc600000114c2ULL, 0x0000004d00bf7306ULL, 0x000fe20000009400ULL,
0x000001004e3e7824ULL, 0x002fe200078e00ffULL, 0x0000000183835812ULL, 0x004fe400078efcffULL,
0x0000000178784812ULL, 0x000fe400078efcffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000004d00bc7306ULL, 0x000e620000005400ULL, 0x0000000186863812ULL, 0x008fe400078efcffULL,
0x000000017e7e2812ULL, 0x000fc400078efcffULL, 0x000000c1be00720bULL, 0x000fe20003f5d000ULL,
0x0001000032c17824ULL, 0x000fe400078e00ffULL, 0x0000003f00d27306ULL, 0x000fe20000209400ULL,
0x0001000033be7824ULL, 0x000fe400078e00ffULL, 0x00000018ffc17819ULL, 0x000fc600000114c1ULL,
0x00000018ffbe7819ULL, 0x000fe400000114beULL, 0x0000003f00d37306ULL, 0x000ea20000205400ULL,
0x000000bcbf00720bULL, 0x002fe40003f7d000ULL, 0x0000000175752812ULL, 0x000fca00078efcffULL,
0x0000004c00bd7306ULL, 0x000ff00000009400ULL, 0x0000004c00827306ULL, 0x000e620000005400ULL,
0x000000d3d200720bULL, 0x004fce0003fbd000ULL, 0x0000004d006b7306ULL, 0x0004f0000000d400ULL,
0x0000003f00807306ULL, 0x000962000020d400ULL, 0x00000082bd00720bULL, 0x002fe20003f9d000ULL,
0x000100004d4d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004c00747306ULL, 0x0002a2000000d400ULL, 0x000001004f3f7824ULL, 0x010fe200078e00ffULL,
0x000000016b6b3812ULL, 0x008fe400078efcffULL, 0x000000a8a700720bULL, 0x000fe40003f7d000ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000007000cc7306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x002fe200078e00ffULL, 0x0000000180805812ULL, 0x020fc800078efcffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000007000cd7306ULL, 0x000e620000205400ULL,
0x0000000174744812ULL, 0x004fe400078efcffULL, 0x0000000167673812ULL, 0x000fca00078efcffULL,
0x0000003e00ae7306ULL, 0x000ff00000209400ULL, 0x0000003e00af7306ULL, 0x000fe20000205400ULL,
0x000000cdcc00720bULL, 0x002fce0003fbd000ULL, 0x0000003e00777306ULL, 0x0003f0000020d400ULL,
0x0000004c00c87306ULL, 0x000fe20000209400ULL, 0x00000100303e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000004c00c97306ULL, 0x000e700000205400ULL,
0x00000070007f7306ULL, 0x000eb0000020d400ULL, 0x0000007200ce7306ULL, 0x000fe20000209400ULL,
0x000000c9c800720bULL, 0x002fce0003f9d000ULL, 0x0000007200cf7306ULL, 0x000e620000205400ULL,
0x000000017f7f5812ULL, 0x004fe400078efcffULL, 0x000000b3b400720bULL, 0x000fe40003fbd000ULL,
0x000000747f74723eULL, 0x000fc600000010ffULL, 0x0000004e00b97306ULL, 0x000ff00000009400ULL,
0x0000004e00b87306ULL, 0x000ea20000005400ULL, 0x000000cfce00720bULL, 0x002fe40003f5d000ULL,
0x000000016c6c5812ULL, 0x000fc400078efcffULL, 0x000000afae00720bULL, 0x000fc60003fbd000ULL,
0x0000003f00a27306ULL, 0x000ff00000209400ULL, 0x0000003f00a37306ULL, 0x000e620000205400ULL,
0x000000b8b900720bULL, 0x004fe40003fdd000ULL, 0x0000000177775812ULL, 0x000fca00078efcffULL,
0x0000004e00667306ULL, 0x0004f0000000d400ULL, 0x0000003f00707306ULL, 0x000f22000020d400ULL,
0x000100004e4e7824ULL, 0x004fe200078e00ffULL, 0x000000a3a200720bULL, 0x002fc80003f7d000ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000003e00917306ULL, 0x000fe20000209400ULL,
0x0000000166666812ULL, 0x008fe400078efcffULL, 0x0000008b8a00720bULL, 0x000fe40003fdd000ULL,
0x000000667766723eULL, 0x000fc600000010ffULL, 0x0000003e00927306ULL, 0x000e620000205400ULL,
0x0000000170703812ULL, 0x010fe400078efcffULL, 0x0000007d7c00720bULL, 0x000fca0003f7d000ULL,
0x0000003e00717306ULL, 0x0005e2000020d400ULL, 0x0000000157576812ULL, 0x000fce00078efcffULL,
0x0000004c007b7306ULL, 0x000ee2000020d400ULL, 0x000000003c3c783bULL, 0x004ea20000000200ULL,
0x0000000154543812ULL, 0x000fe400078efcffULL, 0x000000929100720bULL, 0x002fc80003fdd000ULL,
0x0000003000b07306ULL, 0x000ff00000009400ULL, 0x0000003000b17306ULL, 0x000e620000005400ULL,
0x000000017b7b4812ULL, 0x008fe400078efcffULL, 0x0000000171716812ULL, 0x000fc400078efcffULL,
0x0000006e6d00720bULL, 0x000fe40003fdd000ULL, 0x0000007b6c6c723eULL, 0x000fe200000010ffULL,
0x00000030006a7306ULL, 0x000730000000d400ULL, 0x00000072007a7306ULL, 0x000f62000020d400ULL,
0x0001000030307824ULL, 0x008fe200078e00ffULL, 0x000000b1b000720bULL, 0x002fc40003f9d000ULL,
0x0000000147476812ULL, 0x000fe400078efcffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000004e009c7306ULL, 0x000fe20000209400ULL, 0x000000ad3c3c9231ULL, 0x084fe200003400ffULL,
0x000000656400720bULL, 0x000fe20003fdd000ULL, 0x000000ad3e3e9231ULL, 0x000fe400003400ffULL,
0x000000ac3d3d9231ULL, 0x080fe400003400ffULL, 0x000000016a6a4812ULL, 0x010fe200078efcffULL,
0x0000004e009d7306ULL, 0x000e620000205400ULL, 0x000000017a7a2812ULL, 0x020fe200078efcffULL,
0x000000ac3f3f9231ULL, 0x000fe200003400ffULL, 0x0000006a716a723eULL, 0x000fc800000010ffULL,
0x0000000144446812ULL, 0x000fe200078efcffULL, 0x0000004e00727306ULL, 0x000eb0000020d400ULL,
0x0000004d00c47306ULL, 0x000fe20000209400ULL, 0x0000009d9c00720bULL, 0x002fce0003fbd000ULL,
0x0000004d00c57306ULL, 0x000e6c0000205400ULL, 0x0000000172725812ULL, 0x004fe400078efcffULL,
0x0000003100a47306ULL, 0x000fe40000009400ULL, 0x00000072576e723eULL, 0x000fcc00000010ffULL,
0x0000003100a57306ULL, 0x000fe20000005400ULL, 0x000000c5c400720bULL, 0x002fce0003f5d000ULL,
0x00000031004e7306ULL, 0x0003f0000000d400ULL, 0x0000004d00767306ULL, 0x000ea2000020d400ULL,
0x0001000031317824ULL, 0x002fca00078e00ffULL, 0x00000018ffbc7819ULL, 0x000fe40000011431ULL,
0x00000032008f7306ULL, 0x000fe20000009400ULL, 0x000000aaa931723eULL, 0x000fce00000010ffULL,
0x0000003200907306ULL, 0x000e620000005400ULL, 0x0000000176762812ULL, 0x004fe400078efcffULL,
0x000000a5a400720bULL, 0x000fe40003f5d000ULL, 0x00000076676d723eULL, 0x000fc600000010ffULL,
0x00000032004d7306ULL, 0x0004f0000000d400ULL, 0x0000003300847306ULL, 0x000fe20000009400ULL,
0x000000b6bb32723eULL, 0x004fe400000010ffULL, 0x000000014e4e2812ULL, 0x000fc400078efcffULL,
0x000000696800720bULL, 0x000fe40003f5d000ULL, 0x000000908f00720bULL, 0x002fe20003fbd000ULL,
0x0000003300857306ULL, 0x000ff00000005400ULL, 0x00000033004c7306ULL, 0x0003e4000000d400ULL,
0x0000000146462812ULL, 0x000fc400078efcffULL, 0x000000014d4d5812ULL, 0x008fc800078efcffULL,
0x0000003000937306ULL, 0x000fe20000209400ULL, 0x000000b5ba33723eULL, 0x002fce00000010ffULL,
0x0000003000c07306ULL, 0x000e620000205400ULL, 0x000000322c5c723cULL, 0x000fee000004185cULL,
0x0000003000827306ULL, 0x0004e2000020d400ULL, 0x000000a6ab32723eULL, 0x000fe400000010ffULL,
0x0000009fa033723eULL, 0x000fca00000010ffULL, 0x0000004f00d47306ULL, 0x000fe20000009400ULL,
0x000000b7b230723eULL, 0x004fe200000010ffULL, 0x000000322c34723cULL, 0x000fe20000041834ULL,
0x000000c09300720bULL, 0x002fca0003f9d000ULL, 0x0000004f00d57306ULL, 0x000e620000005400ULL,
0x000000949b32723eULL, 0x000fe200000010ffULL, 0x000000302c60723cULL, 0x000fe20000041860ULL,
0x0000008c9533723eULL, 0x000fca00000010ffULL, 0x000000d700877306ULL, 0x000fe20000209400ULL,
0x000000a19e30723eULL, 0x000fe200000010ffULL, 0x000000322c50723cULL, 0x000fe20000041850ULL,
0x0000009a9931723eULL, 0x000fe400000010ffULL, 0x0000000182824812ULL, 0x008fc600078efcffULL,
0x000000d700887306ULL, 0x000ea20000205400ULL, 0x000000d5d400720bULL, 0x002fe20003f3d000ULL,
0x000000302c58723cULL, 0x000fe20000041858ULL, 0x0000007e8d32723eULL, 0x000fe400000010ffULL,
0x000000788333723eULL, 0x000fe400000010ffULL, 0x000000824782723eULL, 0x000fe200000010ffULL,
0x0000004f00737306ULL, 0x0002e2000000d400ULL, 0x000000968930723eULL, 0x000fe200000010ffULL,
0x0000006c3c60723cULL, 0x000fe20000041860ULL, 0x0000008e8131723eULL, 0x000fca00000010ffULL,
0x000000c200a97306ULL, 0x000fe20000209400ULL, 0x000100004f4f7824ULL, 0x002fe200078e00ffULL,
0x000000302c48723cULL, 0x000fe20000041848ULL, 0x000000888700720bULL, 0x004fc60003f7d000ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x000000c200a07306ULL, 0x000e620000205400ULL,
0x000000867930723eULL, 0x000fe200000010ffULL, 0x000000322c40723cULL, 0x040fe20000041840ULL,
0x000000807531723eULL, 0x000fe400000010ffULL, 0x0000000173731812ULL, 0x008fe400078efcffULL,
0x0000006b7a75723eULL, 0x000fe200000010ffULL, 0x0000004f00977306ULL, 0x000fe20000209400ULL,
0x000000737067723eULL, 0x000fe200000010ffULL, 0x000000302c38723cULL, 0x000fec0000041838ULL,
0x0000004f00987306ULL, 0x000ea20000205400ULL, 0x000000a0a900720bULL, 0x002fe20003f9d000ULL,
0x000000743c5c723cULL, 0x040fec000004185cULL, 0x0000004f006f7306ULL, 0x000e64000020d400ULL,
0x000000663c34723cULL, 0x000fec0000041834ULL, 0x000000d7004f7306ULL, 0x000ee2000020d400ULL,
0x000000989700720bULL, 0x004fce0003f3d000ULL, 0x000000bc00b87306ULL, 0x000fec0000209400ULL,
0x000000016f6f1812ULL, 0x002fe400078efcffULL, 0x000000bc00b97306ULL, 0x000e620000205400ULL,
0x000000014f4f3812ULL, 0x008fe400078efcffULL, 0x000000858400720bULL, 0x000fc40003f3d000ULL,
0x0000006f546f723eULL, 0x000fe400000010ffULL, 0x0000004e4f6b723eULL, 0x000fe200000010ffULL,
0x000000c2009a7306ULL, 0x000ea8000020d400ULL, 0x0000006e3c58723cULL, 0x000fe80000041858ULL,
0x000000c100327306ULL, 0x000fe20000209400ULL, 0x000000b9b800720bULL, 0x002fc40003f7d000ULL,
0x000000014c4c1812ULL, 0x000fe200078efcffULL, 0x0000006a3c50723cULL, 0x000fe80000041850ULL,
0x000000c1002d7306ULL, 0x000e620000205400ULL, 0x000000019a9a4812ULL, 0x004fc800078efcffULL,
0x0000004d9a9a723eULL, 0x000fc600000010ffULL, 0x000000bc00ad7306ULL, 0x000eb0000020d400ULL,
0x000000c3008c7306ULL, 0x000fe20000209400ULL, 0x0000002d3200720bULL, 0x002fce0003f9d000ULL,
0x000000c3007d7306ULL, 0x000e620000205400ULL, 0x00000001adad3812ULL, 0x004fe400078efcffULL,
0x000000565500720bULL, 0x000fe40003f7d000ULL, 0x000000ad4683723eULL, 0x000fc600000010ffULL,
0x000000be002c7306ULL, 0x000fe80000209400ULL, 0x000000823c48723cULL, 0x000fe80000041848ULL,
0x000000be002f7306ULL, 0x000ea20000205400ULL, 0x0000007d8c00720bULL, 0x002fe40003f5d000ULL,
0x000000011c1c3812ULL, 0x000fca00078efcffULL, 0x000000c3009b7306ULL, 0x000e70000020d400ULL,
0x000000c100c17306ULL, 0x000ee2000020d400ULL, 0x0000002f2c00720bULL, 0x004fce0003fbd000ULL,
0x000000be002d7306ULL, 0x000ea2000020d400ULL, 0x000000019b9b2812ULL, 0x002fc800078efcffULL,
0x0000004c9b9b723eULL, 0x000fe400000010ffULL, 0x00000001c1c14812ULL, 0x008fc800078efcffULL,
0x000000c1442c723eULL, 0x000fe200000010ffULL, 0x0000009a3c40723cULL, 0x000fe20000041840ULL,
0x000000012d2d5812ULL, 0x004fc800078efcffULL, 0x0000002d1c2d723eULL, 0x000fce00000010ffULL,
0x0000002c3c3c723cULL, 0x000fe20000041838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff2c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c0052f7811ULL, 0x000fe200078e40ffULL,
0x01069800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000002f0400720cULL, 0x000fda0003f24070ULL,
0x0000504000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff087984ULL, 0x000ea40000000800ULL,
0x8000000008ff7812ULL, 0x006fe4000782482dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe4000782482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x00000008000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc4000782482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010e2d7824ULL, 0x000fe400078e0227ULL,
0x00000002ff087424ULL, 0x000fe400078e00ffULL, 0x00000001ff277424ULL, 0x000fe200078e00ffULL,
0x000000012d0a7812ULL, 0x000fc600078ec0ffULL, 0x0000030008087a24ULL, 0x000fe200078e0a27ULL,
0x000000010a00780cULL, 0x000fe20003f25070ULL, 0xffffffffff0a7424ULL, 0x000fc600078e00ffULL,
0x0000000108087807ULL, 0x000fca0004800000ULL, 0x000000012d087824ULL, 0x000fca00078e0208ULL,
0x000000060800720cULL, 0x000fe40003f26070ULL, 0x000000e005277811ULL, 0x000fe400078e40ffULL,
0x00000060001c7811ULL, 0x000fe400078e38ffULL, 0x00000027040e7217ULL, 0x000fce0007800000ULL,
0x00000001082c9824ULL, 0x000fe400078e020dULL, 0x00000004ff2d9424ULL, 0x000fe400078e00ffULL,
0x0000000128397824ULL, 0x000fe400078e021cULL, 0x000060002c2c9625ULL, 0x000fe200078e002dULL,
0x0000000403317811ULL, 0x000fc600078fe0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a27ULL,
0x000000062c0a9981ULL, 0x000362000c1e1900ULL, 0x00000001292f7824ULL, 0x000fe200078e021cULL,
0x0000000603337811ULL, 0x000fe400078fe0ffULL, 0x000000311c297210ULL, 0x100fe40007ffe009ULL,
0x0000002a2f2f7210ULL, 0x080fe40007f3e0ffULL, 0x000000200e0e7807ULL, 0x000fe40000000000ULL,
0x0000002a392d7210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x000000331c277210ULL, 0x000fc40007ffe009ULL, 0x0000002a29287210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe400078440ffULL,
0x0000000e090e7217ULL, 0x000fe20007800000ULL, 0x000000ffff297224ULL, 0x000fe200018e06ffULL,
0x0000002a271c7210ULL, 0x000fe40007f9e0ffULL, 0x00005e002f327a11ULL, 0x000fe200078240ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a09ULL, 0x00005f002d2d7a11ULL, 0x000fe200010f442eULL,
0x000000ffff277224ULL, 0x000fe200020e06ffULL, 0x00000004ff397819ULL, 0x000fc40000011603ULL,
0x00005e00282e7a11ULL, 0x000fe400078040ffULL, 0x00005f002f2f7a11ULL, 0x000fe400008f4430ULL,
0x00005e001c307a11ULL, 0x000fe400078240ffULL, 0x00000002393b7810ULL, 0x000fe40007ffe0ffULL,
0x00005f00282a7a11ULL, 0x000fe400000f4429ULL, 0x0000000f32287210ULL, 0x000fc40007f9e0ffULL,
0x0000000e3900720cULL, 0x080fe40003f66070ULL, 0x0000000f2c2c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe200020e062fULL, 0x00005f001c1c7a11ULL, 0x000fe400008f4427ULL,
0x0000000e3b00720cULL, 0x080fe20003f46070ULL, 0x000000ffff2d7224ULL, 0x000fe200028e062dULL,
0x0000000e3100720cULL, 0x080fe40003f26070ULL, 0x0000000e3300720cULL, 0x000fc40003f06070ULL,
0x0000000f2e2e7210ULL, 0x080fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028107faeULL, 0x0003e2000d901c46ULL, 0x0000000f30307210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff2f7224ULL, 0x000fe400020e062aULL, 0x000000ffff317224ULL, 0x000fe200028e061cULL,
0x000000002c117faeULL, 0x0003e8000d101c46ULL, 0x000000002e127faeULL, 0x0003e8000c901c46ULL,
0x0000000030137faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff287f8cULL, 0x002e68000c80043fULL,
0x0106ac00ff0e7984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106680009107f8cULL, 0x000fe2000c80043fULL,
0x800000000eff7812ULL, 0x004fc60007804845ULL, 0x01066c0009137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007824811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e00127305ULL, 0x0004e4000021f000ULL,
0x3fa000000e0e7823ULL, 0x004fe200000100ffULL, 0x000000120000735dULL, 0x008fe20003800000ULL,
0x01066c0009137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01018000140e7984ULL, 0x000ea80000000800ULL,
0x0103800014107984ULL, 0x0007220000000800ULL, 0x0000000b0e00720bULL, 0x004fe20003f3d000ULL,
0x0000e7027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000117806ULL, 0x008fc800008e0100ULL,
0x0000ffff11127812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff717424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000030200780cULL, 0x000fe40003f45270ULL, 0x0000000b0e00720bULL, 0x000fe20003f34000ULL,
0x0000e6e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000117806ULL, 0x000fe400008e0100ULL,
0x0000000e0b137209ULL, 0x000fe40007810000ULL, 0x0000ffff11117812ULL, 0x000fe400078e3cffULL,
0x00000002ff6f7819ULL, 0x000fe20000011603ULL, 0x800000130b0b7221ULL, 0x000fe20000010000ULL,
0x010580131400a388ULL, 0x0005e20000000800ULL, 0x0000001112ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00687308ULL, 0x000ee40000000800ULL,
0x000000680c0c7220ULL, 0x008fe20000410000ULL, 0x0000e6927f007947ULL, 0x000fea000b800000ULL,
0x00001f6f68677589ULL, 0x0044e400000e0000ULL, 0x000000675c5c7220ULL, 0x08cfe40000410000ULL,
0x000000675d5d7220ULL, 0x080fe40000410000ULL, 0x0000006760607220ULL, 0x080fe40000410000ULL,
0x0000006761617220ULL, 0x080fe40000410000ULL, 0x0000006734347220ULL, 0x000fc40000410000ULL,
0x0000006735357220ULL, 0x080fe40000410000ULL, 0x0000006758587220ULL, 0x080fe40000410000ULL,
0x0000006759597220ULL, 0x080fe40000410000ULL, 0x0000006750507220ULL, 0x080fe40000410000ULL,
0x0000006751517220ULL, 0x080fe40000410000ULL, 0x0000006748487220ULL, 0x000fc40000410000ULL,
0x0000006749497220ULL, 0x080fe40000410000ULL, 0x0000006740407220ULL, 0x080fe40000410000ULL,
0x0000006741417220ULL, 0x080fe40000410000ULL, 0x000000673c3c7220ULL, 0x080fe40000410000ULL,
0x000000673d3d7220ULL, 0x000fe20000410000ULL, 0x0000e5c27f007947ULL, 0x000fea000b800000ULL,
0x00001ff468677589ULL, 0x0004e400000e0000ULL, 0x800000130e0e1221ULL, 0x000fe20000010000ULL,
0x00000001ff717807ULL, 0x000fe20000800000ULL, 0x000000675e5e7220ULL, 0x00cfc40000410000ULL,
0x3fb8aa3b0e0e1820ULL, 0x000fe40000410000ULL, 0x000000675f5f7220ULL, 0x080fe40000410000ULL,
0x0000000e00151308ULL, 0x000ea20000000800ULL, 0x0000006762627220ULL, 0x080fe40000410000ULL,
0x0000006763637220ULL, 0x080fe40000410000ULL, 0x0000006736367220ULL, 0x080fe40000410000ULL,
0x0000006737377220ULL, 0x000fc40000410000ULL, 0x000000675a5a7220ULL, 0x080fe40000410000ULL,
0x000000675b5b7220ULL, 0x080fe40000410000ULL, 0x0000006752527220ULL, 0x080fe40000410000ULL,
0x0000006753537220ULL, 0x080fe40000410000ULL, 0x000000674a4a7220ULL, 0x080fe40000410000ULL,
0x000000674b4b7220ULL, 0x000fc40000410000ULL, 0x0000006742427220ULL, 0x080fe40000410000ULL,
0x0000006743437220ULL, 0x080fe40000410000ULL, 0x000000673e3e7220ULL, 0x080fe40000410000ULL,
0x000000673f3f7220ULL, 0x000fe40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0013ULL,
0x0000001015101220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000c100c7221ULL, 0x010fe20000010000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106ac00ff0e7984ULL, 0x000ea40000000800ULL,
0x800000000eff7812ULL, 0x004fc40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e00107305ULL, 0x0004e4000021f000ULL, 0x3fa000000e0e7823ULL, 0x004fe200000100ffULL,
0x000000100000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff107984ULL, 0x000ea40000000800ULL,
0x8000000010ff7812ULL, 0x004fe40007804845ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff0e723eULL, 0x000fe400000010ffULL, 0x00000002ff6f7819ULL, 0x002fc40000011603ULL,
0x000054100e687816ULL, 0x000fe2000000000eULL, 0x0000e3627f007947ULL, 0x000fea000b800000ULL,
0x00001f6f684d7589ULL, 0x0002a400000e0000ULL, 0x0000e3a27f007947ULL, 0x000fea000b800000ULL,
0x00001ff4682a7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f9ULL, 0x00010f5000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000eb2000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f7ULL, 0x00010fb000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000eac000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001738783bULL, 0x000e620000004200ULL, 0x0000991071717816ULL, 0x000fc400000000ffULL,
0x0000b8001b1b7811ULL, 0x000fe200078e20ffULL, 0x000000001610783bULL, 0x000ee80000004200ULL,
0x000000001830783bULL, 0x000fe80000004200ULL, 0x00000000192c783bULL, 0x0003240000004200ULL,
0x00000018ff197819ULL, 0x002fe2000001143aULL, 0x0000003800b97306ULL, 0x000fe20000009400ULL,
0x00000018ff1c7819ULL, 0x000fc4000001143bULL, 0x00000018ff167819ULL, 0x008fe40000011412ULL,
0x00000018ff177819ULL, 0x000fe40000011413ULL, 0x00000018ff0e7819ULL, 0x000fe20000011410ULL,
0x0000001900b17306ULL, 0x000fe20000209400ULL, 0x00000018ff147819ULL, 0x000fe40000011411ULL,
0x00000018ff697819ULL, 0x010fe4000001142dULL, 0x00000018ff6d7819ULL, 0x000fc4000001142eULL,
0x00000018ff467819ULL, 0x000fe20000011433ULL, 0x0000001900b07306ULL, 0x000fe20000205400ULL,
0x00000018ff6e7819ULL, 0x000fce000001142fULL, 0x00000019006f7306ULL, 0x0003f0000020d400ULL,
0x0000001600b87306ULL, 0x000fe20000209400ULL, 0x00000018ff197819ULL, 0x002fce0000011432ULL,
0x0000001600c17306ULL, 0x000ff00000205400ULL, 0x0000001600187306ULL, 0x000ff0000020d400ULL,
0x0000001700be7306ULL, 0x000ff00000209400ULL, 0x0000001700bd7306ULL, 0x000ff00000205400ULL,
0x0000001700897306ULL, 0x000ff0000020d400ULL, 0x0000001900817306ULL, 0x000ff00000209400ULL,
0x0000001900827306ULL, 0x000ff00000205400ULL, 0x00000019004e7306ULL, 0x0003f0000020d400ULL,
0x0000001c00177306ULL, 0x000fe20000209400ULL, 0x0000010010197824ULL, 0x002fca00078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000001c00167306ULL, 0x000ff00000205400ULL,
0x0000001c006c7306ULL, 0x000ff0000020d400ULL, 0x0000006900557306ULL, 0x000ff00000209400ULL,
0x0000006900647306ULL, 0x000ff00000205400ULL, 0x00000069001c7306ULL, 0x0003f0000020d400ULL,
0x0000001000887306ULL, 0x000fe20000009400ULL, 0x0000010011697824ULL, 0x002fca00078e00ffULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x0000001000857306ULL, 0x000e700000005400ULL,
0x0000001000a07306ULL, 0x000730000000d400ULL, 0x0000000e00947306ULL, 0x000fe20000209400ULL,
0x0001000010107824ULL, 0x008fe200078e00ffULL, 0x000000858800720bULL, 0x002fc80003f5d000ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000000e00d37306ULL, 0x000e6e0000205400ULL,
0x00000001a0a02812ULL, 0x010fe200078efcffULL, 0x0000001900d27306ULL, 0x000ff00000209400ULL,
0x0000001900d57306ULL, 0x000ee20000205400ULL, 0x000000d39400720bULL, 0x002fce0003fbd000ULL,
0x0000001900ab7306ULL, 0x000330000020d400ULL, 0x0000006900d67306ULL, 0x000fe20000209400ULL,
0x0000010012197824ULL, 0x002fe200078e00ffULL, 0x000000d5d200720bULL, 0x008fcc0003f7d000ULL,
0x0000006900d97306ULL, 0x000e6e0000205400ULL, 0x00000001abab3812ULL, 0x010fe200078efcffULL,
0x0000001000d77306ULL, 0x000ff00000209400ULL, 0x0000001000d47306ULL, 0x000ee20000205400ULL,
0x000000d9d600720bULL, 0x002fce0003f9d000ULL, 0x00000010009f7306ULL, 0x000330000020d400ULL,
0x0000001100cf7306ULL, 0x000fe20000009400ULL, 0x00000018ff107819ULL, 0x002fe20000011419ULL,
0x0000010013197824ULL, 0x000fe200078e00ffULL, 0x000000d4d700720bULL, 0x008fca0003f1d000ULL,
0x0000001100cc7306ULL, 0x000e700000005400ULL, 0x0000001400687306ULL, 0x000fe20000209400ULL,
0x000000019f9f0812ULL, 0x010fce00078efcffULL, 0x0000001400c97306ULL, 0x000ee20000205400ULL,
0x000000cccf00720bULL, 0x002fce0003fdd000ULL, 0x0000001400977306ULL, 0x0003f0000020d400ULL,
0x0000000e00987306ULL, 0x0008a2000020d400ULL, 0x00000018ff147819ULL, 0x002fe40000011439ULL,
0x000000c96800720bULL, 0x008fca0003f1d000ULL, 0x0000006900ac7306ULL, 0x0002e2000020d400ULL,
0x00000018ff0e7819ULL, 0x010fce0000011438ULL, 0x0000001000da7306ULL, 0x000fe20000209400ULL,
0x00000018ff697819ULL, 0x002fe40000011419ULL, 0x0000000198985812ULL, 0x004fe400078efcffULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x0000001000dd7306ULL, 0x000e620000205400ULL, 0x00000001acac4812ULL, 0x008fce00078efcffULL,
0x0000001400b47306ULL, 0x000ff00000209400ULL, 0x0000001400b57306ULL, 0x000fe20000205400ULL,
0x000000ddda00720bULL, 0x002fce0003fbd000ULL, 0x0000001400767306ULL, 0x0003f0000020d400ULL,
0x0000001300d17306ULL, 0x000fe20000009400ULL, 0x00000018ff147819ULL, 0x002fce0000011431ULL,
0x0000001300ce7306ULL, 0x000e700000005400ULL, 0x00000013008c7306ULL, 0x0004f0000000d400ULL,
0x0000006900dc7306ULL, 0x000fe20000209400ULL, 0x0001000013137824ULL, 0x004fe200078e00ffULL,
0x000000ced100720bULL, 0x002fcc0003f7d000ULL, 0x0000006900df7306ULL, 0x000e6e0000205400ULL,
0x000000018c8c3812ULL, 0x008fe200078efcffULL, 0x00000014009b7306ULL, 0x000ff00000209400ULL,
0x00000014009c7306ULL, 0x000fe20000205400ULL, 0x000000dfdc00720bULL, 0x002fce0003f9d000ULL,
0x0000001400567306ULL, 0x000ff0000020d400ULL, 0x0000006d004f7306ULL, 0x000ff00000209400ULL,
0x0000006d00547306ULL, 0x000ff00000205400ULL, 0x0000006d00147306ULL, 0x0003f0000020d400ULL,
0x0000001000937306ULL, 0x0004e2000020d400ULL, 0x00000100386d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x00000011009d7306ULL, 0x000322000000d400ULL,
0x00000018ff107819ULL, 0x004fce0000011413ULL, 0x0000006900197306ULL, 0x000522000020d400ULL,
0x0001000011117824ULL, 0x002fe200078e00ffULL, 0x0000000193935812ULL, 0x008fc800078efcffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000001000de7306ULL, 0x000fe20000209400ULL,
0x0000010039697824ULL, 0x004fe200078e00ffULL, 0x000000019d9d6812ULL, 0x010fe400078efcffULL,
0x000000c1b800720bULL, 0x000fe40003fdd000ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x0000001000137306ULL, 0x000e620000205400ULL, 0x0000000119194812ULL, 0x000fce00078efcffULL,
0x0000003800ba7306ULL, 0x000ea20000005400ULL, 0x0000000118186812ULL, 0x000fce00078efcffULL,
0x00000038007e7306ULL, 0x000722000000d400ULL, 0x00000013de00720bULL, 0x002fce0003fbd000ULL,
0x00000010008a7306ULL, 0x000322000020d400ULL, 0x0001000038387824ULL, 0x008fe200078e00ffULL,
0x000000bab900720bULL, 0x004fc80003f7d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000006d00e57306ULL, 0x000fe20000209400ULL, 0x000001003a107824ULL, 0x002fcc00078e00ffULL,
0x000000017e7e3812ULL, 0x010fe200078efcffULL, 0x0000006d00e27306ULL, 0x000e620000205400ULL,
0x000000018a8a5812ULL, 0x000fce00078efcffULL, 0x0000001100db7306ULL, 0x000ff00000209400ULL,
0x0000001100d87306ULL, 0x000ea20000205400ULL, 0x000000e2e500720bULL, 0x002fce0003f9d000ULL,
0x0000001200d07306ULL, 0x000ff00000009400ULL, 0x0000001200ad7306ULL, 0x000e620000005400ULL,
0x000000d8db00720bULL, 0x004fce0003f5d000ULL, 0x0000001200927306ULL, 0x0004f0000000d400ULL,
0x0000003900bb7306ULL, 0x000fe20000009400ULL, 0x0001000012127824ULL, 0x004fe200078e00ffULL,
0x000000add000720bULL, 0x002fcc0003f3d000ULL, 0x0000003900bc7306ULL, 0x000fee0000005400ULL,
0x0000000192921812ULL, 0x008fe200078efcffULL, 0x0000003900807306ULL, 0x0003e2000000d400ULL,
0x000000bdbe00720bULL, 0x000fce0003f3d000ULL, 0x0000006900e37306ULL, 0x000fe20000209400ULL,
0x0001000039397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000006900e07306ULL, 0x000e620000205400ULL, 0x0000000189891812ULL, 0x000fce00078efcffULL,
0x00000069008b7306ULL, 0x0005f0000020d400ULL, 0x00000011009e7306ULL, 0x000722000020d400ULL,
0x00000018ff697819ULL, 0x004fe20000011410ULL, 0x000001003b107824ULL, 0x000fe200078e00ffULL,
0x000000e0e300720bULL, 0x002fca0003fdd000ULL, 0x0000003800e47306ULL, 0x000fe20000209400ULL,
0x00000018ff117819ULL, 0x008fce0000011412ULL, 0x0000003800e77306ULL, 0x000e620000205400ULL,
0x000000019e9e2812ULL, 0x010fe400078efcffULL, 0x000000018b8b6812ULL, 0x000fe400078efcffULL,
0x000000b5b400720bULL, 0x000fe20003fdd000ULL, 0x000100002eb47824ULL, 0x000fe400078e00ffULL,
0x0000003a00b67306ULL, 0x000fe20000009400ULL, 0x000001002fb57824ULL, 0x000fe400078e00ffULL,
0x00000018ffb47819ULL, 0x000fc600000114b4ULL, 0x00000018ffb57819ULL, 0x000fe400000114b5ULL,
0x0000003a00af7306ULL, 0x000ea20000005400ULL, 0x000000e7e400720bULL, 0x002fe40003fbd000ULL,
0x0000000176766812ULL, 0x000fca00078efcffULL, 0x0000003a00747306ULL, 0x0002f0000000d400ULL,
0x0000003800847306ULL, 0x0008e2000020d400ULL, 0x000100003a3a7824ULL, 0x002fe200078e00ffULL,
0x000000afb600720bULL, 0x004fc80003f7d000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000006d00877306ULL, 0x000e62000020d400ULL, 0x00000018ff387819ULL, 0x010fcc0000011410ULL,
0x0000000174743812ULL, 0x008fe200078efcffULL, 0x0000003900e97306ULL, 0x000fe20000209400ULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x000000161700720bULL, 0x000fe40003f7d000ULL,
0x000000a0ab16723eULL, 0x000fe400000010ffULL, 0x0000009dac17723eULL, 0x000fe200000010ffULL,
0x0000003900e67306ULL, 0x000ea20000205400ULL, 0x0000000187874812ULL, 0x002fce00078efcffULL,
0x0000001100127306ULL, 0x000fe20000209400ULL, 0x000000016c6c3812ULL, 0x000fce00078efcffULL,
0x0000001100e17306ULL, 0x000e620000205400ULL, 0x000000e6e900720bULL, 0x004fce0003f9d000ULL,
0x00000011008f7306ULL, 0x000eb0000020d400ULL, 0x0000003800107306ULL, 0x000fe20000209400ULL,
0x000000e11200720bULL, 0x002fe20003f5d000ULL, 0x000001002d127824ULL, 0x000fcc00078e00ffULL,
0x0000003800117306ULL, 0x000fec0000205400ULL, 0x000000018f8f2812ULL, 0x004fe400078efcffULL,
0x0000003800777306ULL, 0x0003e2000020d400ULL, 0x000000bcbb00720bULL, 0x000fce0003f5d000ULL,
0x0000003a00bf7306ULL, 0x000fe20000209400ULL, 0x0000010031387824ULL, 0x002fca00078e00ffULL,
0x0000000180802812ULL, 0x000fe400078efcffULL, 0x0000003a00c07306ULL, 0x000e640000205400ULL,
0x000000808b8b723eULL, 0x000fcc00000010ffULL, 0x0000003a007c7306ULL, 0x0004f0000020d400ULL,
0x0000003b00b27306ULL, 0x000fe20000009400ULL, 0x00000018ff3a7819ULL, 0x004fe40000011438ULL,
0x000000c0bf00720bULL, 0x002fca0003fdd000ULL, 0x0000003b00b37306ULL, 0x000e700000005400ULL,
0x0000003a00c67306ULL, 0x000fe20000209400ULL, 0x000000017c7c6812ULL, 0x008fce00078efcffULL,
0x0000003a00c77306ULL, 0x000ea20000205400ULL, 0x000000b3b200720bULL, 0x002fce0003fbd000ULL,
0x0000003a00787306ULL, 0x0002f0000020d400ULL, 0x0000003300a57306ULL, 0x000fe20000009400ULL,
0x00000100333a7824ULL, 0x002fe200078e00ffULL, 0x000000c7c600720bULL, 0x004fcc0003fdd000ULL,
0x0000003300a27306ULL, 0x000e6e0000005400ULL, 0x0000000178786812ULL, 0x008fe200078efcffULL,
0x00000033004c7306ULL, 0x0005f0000000d400ULL, 0x00000039007d7306ULL, 0x000722000020d400ULL,
0x0001000033337824ULL, 0x004fe200078e00ffULL, 0x000000a2a500720bULL, 0x002fc80003f7d000ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000003b00707306ULL, 0x0002a2000000d400ULL,
0x0000010030397824ULL, 0x008fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003000aa7306ULL, 0x000fe20000009400ULL, 0x000000017d7d4812ULL, 0x010fe200078efcffULL,
0x000100003b3b7824ULL, 0x002fe200078e00ffULL, 0x000000111000720bULL, 0x000fe40003f9d000ULL,
0x000000014c4c3812ULL, 0x000fe400078efcffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003000a17306ULL, 0x000e620000005400ULL, 0x0000000170705812ULL, 0x004fce00078efcffULL,
0x0000003300947306ULL, 0x000fe20000209400ULL, 0x0000000177774812ULL, 0x000fc800078efcffULL,
0x000000707777723eULL, 0x000fc600000010ffULL, 0x0000003300ad7306ULL, 0x000ea20000205400ULL,
0x000000a1aa00720bULL, 0x002fce0003fbd000ULL, 0x0000003300687306ULL, 0x0002f0000020d400ULL,
0x0000000e00b77306ULL, 0x000fe20000209400ULL, 0x00000018ff337819ULL, 0x002fe40000011412ULL,
0x0000b8001a127811ULL, 0x000fc400078e20ffULL, 0x000000ad9400720bULL, 0x004fc60003f7d000ULL,
0x0000000e00ae7306ULL, 0x000e620000205400ULL, 0x000000001210783bULL, 0x000eae0000000200ULL,
0x0000000e00797306ULL, 0x0009e4000020d400ULL, 0x0000000168683812ULL, 0x008fcc00078efcffULL,
0x00000030006a7306ULL, 0x0006e2000000d400ULL, 0x00000018ff0e7819ULL, 0x010fe40000011430ULL,
0x000000aeb700720bULL, 0x002fca0003f3d000ULL, 0x0000003100a87306ULL, 0x000fe20000009400ULL,
0x0001000030307824ULL, 0x008fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011430ULL,
0x0000010032307824ULL, 0x000fe200078e00ffULL, 0x0000003100a97306ULL, 0x000e620000005400ULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x0000000179791812ULL, 0x000fe400078efcffULL,
0x00000018ff837819ULL, 0x000fe40000011430ULL, 0x000000b0b100720bULL, 0x000fe20003f3d000ULL,
0x0000003800c87306ULL, 0x000fe20000209400ULL, 0x0000004d10108231ULL, 0x084fe200003400ffULL,
0x000100002fb07824ULL, 0x000fe200078e00ffULL, 0x0000004d12128231ULL, 0x000fc400003400ffULL,
0x0000002a11118231ULL, 0x080fe400003400ffULL, 0x0000002a13138231ULL, 0x000fe200003400ffULL,
0x0000003800cb7306ULL, 0x000ea20000205400ULL, 0x00000018ffb07819ULL, 0x000fc600000114b0ULL,
0x000000016f6f1812ULL, 0x000fe400078efcffULL, 0x000000a9a800720bULL, 0x002fe20003f3d000ULL,
0x00000016105c723cULL, 0x000fe2000004185cULL, 0x00000031006b7306ULL, 0x0002ec000000d400ULL,
0x0000008f1816723eULL, 0x000fc400000010ffULL, 0x0000003900c47306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x002fe200078e00ffULL, 0x000000cbc800720bULL, 0x004fe40003fbd000ULL,
0x0000008a8917723eULL, 0x000fe400000010ffULL, 0x0000007e878a723eULL, 0x000fe400000010ffULL,
0x0000003900c57306ULL, 0x000e620000205400ULL, 0x000000016b6b1812ULL, 0x008fe400078efcffULL,
0x000000161058723cULL, 0x000fe40000041858ULL, 0x0000006b786b723eULL, 0x000fc600000010ffULL,
0x0000003900737306ULL, 0x0004e4000020d400ULL, 0x000000847916723eULL, 0x000fe200000010ffULL,
0x0000008a1050723cULL, 0x000fe20000041850ULL, 0x0000007d7617723eULL, 0x000fc800000010ffULL,
0x0000006900e87306ULL, 0x000fe20000209400ULL, 0x00000018ff397819ULL, 0x004fe40000011431ULL,
0x000000c5c400720bULL, 0x002fe20003f9d000ULL, 0x000000161048723cULL, 0x000fe80000041848ULL,
0x0000003900cd7306ULL, 0x000ff00000209400ULL, 0x0000003900ca7306ULL, 0x000e620000205400ULL,
0x0000000173734812ULL, 0x008fc800078efcffULL, 0x0000006a736a723eULL, 0x000fc600000010ffULL,
0x0000006900eb7306ULL, 0x000eb00000205400ULL, 0x0000003800727306ULL, 0x000722000020d400ULL,
0x000000cacd00720bULL, 0x002fce0003fdd000ULL, 0x00000039006d7306ULL, 0x000e62000020d400ULL,
0x00000018ff387819ULL, 0x008fe4000001143aULL, 0x000000ebe800720bULL, 0x004fca0003f5d000ULL,
0x00000069007f7306ULL, 0x000ea2000020d400ULL, 0x0000000172725812ULL, 0x010fe400078efcffULL,
0x0000009c9b00720bULL, 0x000fca0003fbd000ULL, 0x0000008300307306ULL, 0x000fe20000209400ULL,
0x000000016d6d6812ULL, 0x002fce00078efcffULL, 0x0000008300317306ULL, 0x000e620000205400ULL,
0x000000017f7f2812ULL, 0x004fe400078efcffULL, 0x0000000156565812ULL, 0x000fe400078efcffULL,
0x000000747f76723eULL, 0x000fe400000010ffULL, 0x0000007c6f74723eULL, 0x000fe200000010ffULL,
0x0000003b00c27306ULL, 0x000fe20000209400ULL, 0x0000006d566d723eULL, 0x000fc600000010ffULL,
0x000000761040723cULL, 0x000fe80000041840ULL, 0x0000003b00c37306ULL, 0x000ea20000205400ULL,
0x000000313000720bULL, 0x002fe40003fdd000ULL, 0x0000008c1931723eULL, 0x000fe400000010ffULL,
0x000000929330723eULL, 0x000fc600000010ffULL, 0x0000003800957306ULL, 0x000ff00000209400ULL,
0x0000003800967306ULL, 0x000e620000205400ULL, 0x000000c3c200720bULL, 0x004fce0003f5d000ULL,
0x0000003200a67306ULL, 0x000ff00000009400ULL, 0x0000003200a77306ULL, 0x000fe20000005400ULL,
0x000000969500720bULL, 0x002fce0003fbd000ULL, 0x0000003200577306ULL, 0x0003f0000000d400ULL,
0x0000002d00917306ULL, 0x000fe20000009400ULL, 0x0001000032327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000002d00907306ULL, 0x000ff00000005400ULL,
0x0000000e00a47306ULL, 0x000ff00000209400ULL, 0x0000000e00a37306ULL, 0x000e700000205400ULL,
0x0000002d003a7306ULL, 0x0005f0000000d400ULL, 0x0000002c009a7306ULL, 0x000fe20000009400ULL,
0x000100002d2d7824ULL, 0x004fe200078e00ffULL, 0x000000a3a400720bULL, 0x002fc80003f9d000ULL,
0x00000018ff1a7819ULL, 0x000fe4000001142dULL, 0x0000002c00997306ULL, 0x000e620000005400ULL,
0x0000009e972d723eULL, 0x000fce00000010ffULL, 0x0000003b00757306ULL, 0x000eb0000020d400ULL,
0x0000000e00677306ULL, 0x000722000020d400ULL, 0x000000999a00720bULL, 0x002fce0003f3d000ULL,
0x00000038003b7306ULL, 0x000e62000020d400ULL, 0x00000018ff0e7819ULL, 0x008fe4000001142cULL,
0x0000000175752812ULL, 0x004fe400078efcffULL, 0x000000a7a600720bULL, 0x000fe40003f5d000ULL,
0x000000756c75723eULL, 0x000fe200000010ffULL, 0x00000032008d7306ULL, 0x000fe20000209400ULL,
0x0000000167674812ULL, 0x010fe400078efcffULL, 0x000000909100720bULL, 0x000fc40003f9d000ULL,
0x00000072676c723eULL, 0x000fe200000010ffULL, 0x00000074103c723cULL, 0x000fe4000004183cULL,
0x00000032008e7306ULL, 0x000ea20000205400ULL, 0x000000013b3b5812ULL, 0x002fe400078efcffULL,
0x0000000157572812ULL, 0x000fe400078efcffULL, 0x0000004c3b6f723eULL, 0x000fc600000010ffULL,
0x0000003200697306ULL, 0x0003e2000020d400ULL, 0x000000013a3a4812ULL, 0x000fe400078efcffULL,
0x000000645500720bULL, 0x000fca0003f9d000ULL, 0x0000002c00447306ULL, 0x000722000000d400ULL,
0x000001002c327824ULL, 0x002fe200078e00ffULL, 0x0000008e8d00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000046007a7306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x008fe200078e00ffULL, 0x000000011c1c4812ULL, 0x000fc800078efcffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000046007b7306ULL, 0x000e620000205400ULL,
0x0000000144441812ULL, 0x010fe400078efcffULL, 0x0000000169692812ULL, 0x000fca00078efcffULL,
0x0000001a00a17306ULL, 0x000ff00000209400ULL, 0x0000001a00a07306ULL, 0x000fe20000205400ULL,
0x0000007b7a00720bULL, 0x002fce0003fbd000ULL, 0x0000001a00977306ULL, 0x0003f0000020d400ULL,
0x0000002c00b17306ULL, 0x000fe20000209400ULL, 0x000000001b18783bULL, 0x002e6e0000000200ULL,
0x0000002c00b27306ULL, 0x000eb00000205400ULL, 0x0000004600457306ULL, 0x000ef0000020d400ULL,
0x0000003200b87306ULL, 0x000fe20000209400ULL, 0x000000b2b100720bULL, 0x004fce0003f3d000ULL,
0x0000003200bd7306ULL, 0x000ea20000205400ULL, 0x0000000145455812ULL, 0x008fce00078efcffULL,
0x0000003200717306ULL, 0x000722000020d400ULL, 0x0000002a19198231ULL, 0x082fe400003400ffULL,
0x0000002a1b1b8231ULL, 0x000fe400003400ffULL, 0x0000004d18188231ULL, 0x080fe400003400ffULL,
0x0000004d1a1a8231ULL, 0x000fe200003400ffULL, 0x0000003300ae7306ULL, 0x000fe20000209400ULL,
0x000001002e327824ULL, 0x008fe200078e00ffULL, 0x000000bdb800720bULL, 0x004fc80003f7d000ULL,
0x00000018ff907819ULL, 0x000fe40000011432ULL, 0x0000003300b37306ULL, 0x000e6e0000205400ULL,
0x0000000171713812ULL, 0x010fe200078efcffULL, 0x0000002c00a67306ULL, 0x0004e6000020d400ULL,
0x000000447144723eULL, 0x000fca00000010ffULL, 0x0000000e00657306ULL, 0x000fe20000209400ULL,
0x0000009f982c723eULL, 0x004fe400000010ffULL, 0x000000b3ae00720bULL, 0x002fca0003fbd000ULL,
0x0000000e00667306ULL, 0x000e620000205400ULL, 0x00000001a6a61812ULL, 0x008fce00078efcffULL,
0x0000000e00277306ULL, 0x000eb0000020d400ULL, 0x0000006e00467306ULL, 0x000fe20000209400ULL,
0x000000666500720bULL, 0x002fce0003f7d000ULL, 0x0000006e00477306ULL, 0x000fec0000205400ULL,
0x0000000127273812ULL, 0x004fe400078efcffULL, 0x0000006e000e7306ULL, 0x000fe2000020d400ULL,
0x000000544f00720bULL, 0x000fe40003f7d000ULL, 0x00000068454f723eULL, 0x000fc400000010ffULL,
0x000000a62796723eULL, 0x000fc600000010ffULL, 0x00000083006e7306ULL, 0x000e6c000020d400ULL,
0x0000000114143812ULL, 0x000fe400078efcffULL, 0x0000002e00837306ULL, 0x000ff00000009400ULL,
0x0000002e00867306ULL, 0x000ea20000005400ULL, 0x000000016e6e6812ULL, 0x002fc400078efcffULL,
0x000000828100720bULL, 0x000fe40003fdd000ULL, 0x000000576e6e723eULL, 0x000fc600000010ffULL,
0x0000002e00397306ULL, 0x000e70000000d400ULL, 0x0000002f00857306ULL, 0x000fe20000009400ULL,
0x000000868300720bULL, 0x004fe40003f5d000ULL, 0x000000014e4e6812ULL, 0x000fc800078efcffULL,
0x000000694e4e723eULL, 0x000fe200000010ffULL, 0x0000002f00887306ULL, 0x000eac0000005400ULL,
0x0000000139392812ULL, 0x002fe200078efcffULL, 0x0000004e1858723cULL, 0x000fe20000041858ULL,
0x0000002f00387306ULL, 0x0002f0000000d400ULL, 0x0000009000917306ULL, 0x000fe20000209400ULL,
0x0000002c102c723cULL, 0x002fe20000041860ULL, 0x000000888500720bULL, 0x004fcc0003fdd000ULL,
0x0000009000607306ULL, 0x000e6e0000205400ULL, 0x0000000138386812ULL, 0x008fe200078efcffULL,
0x0000003300af7306ULL, 0x0004f0000020d400ULL, 0x000000b400167306ULL, 0x000fe20000209400ULL,
0x000000301030723cULL, 0x004fe20000041834ULL, 0x000000609100720bULL, 0x002fcc0003f3d000ULL,
0x0000009000347306ULL, 0x000e62000020d400ULL, 0x00000001afaf5812ULL, 0x008fe200078efcffULL,
0x0000006a1810723cULL, 0x000fe2000004185cULL, 0x000000a0a100720bULL, 0x000fe40003fbd000ULL,
0x0000003aaf45723eULL, 0x000fc600000010ffULL, 0x000000b400177306ULL, 0x000ea40000205400ULL,
0x0000006c182c723cULL, 0x040fec000004182cULL, 0x000000b500357306ULL, 0x000fe20000209400ULL,
0x0000000134341812ULL, 0x002fe200078efcffULL, 0x0000006e1830723cULL, 0x000fe20000041830ULL,
0x0000000197975812ULL, 0x000fc400078efcffULL, 0x000000474600720bULL, 0x000fe40003fbd000ULL,
0x000000971c97723eULL, 0x000fe200000010ffULL, 0x000000b500367306ULL, 0x000e620000205400ULL,
0x000000171600720bULL, 0x004fe20003f3d000ULL, 0x000000441850723cULL, 0x000fe20000041850ULL,
0x000000393434723eULL, 0x000fca00000010ffULL, 0x000000b0002a7306ULL, 0x000fe40000209400ULL,
0x000000010e0e5812ULL, 0x000fe200078efcffULL, 0x000000961848723cULL, 0x000fea0000041848ULL,
0x000000b0003b7306ULL, 0x000ea20000205400ULL, 0x000000363500720bULL, 0x002fce0003f9d000ULL,
0x000000b500617306ULL, 0x000e70000020d400ULL, 0x000000b400377306ULL, 0x000ee2000020d400ULL,
0x0000003b2a00720bULL, 0x004fce0003f5d000ULL, 0x000000b000177306ULL, 0x000ea2000020d400ULL,
0x0000000161614812ULL, 0x002fc800078efcffULL, 0x000000386135723eULL, 0x000fe400000010ffULL,
0x0000000137371812ULL, 0x008fc800078efcffULL, 0x000000371416723eULL, 0x000fe200000010ffULL,
0x000000341840723cULL, 0x000fe20000041840ULL, 0x0000000117172812ULL, 0x004fc800078efcffULL,
0x000000170e17723eULL, 0x000fce00000010ffULL, 0x00000016183c723cULL, 0x000fe2000004183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff167f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fe40007824817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc40007824817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e00147305ULL, 0x0002a4000021f000ULL, 0x3fa000000e0e7823ULL, 0x002fe200000100ffULL,
0x000000140000735dULL, 0x004fe20003800000ULL, 0x0106bc00ff197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe40007824817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300050e7a10ULL, 0x000fe20007ffe0ffULL, 0x000058000a167a24ULL, 0x020fe200078e02ffULL,
0x00000004ff357819ULL, 0x000fe20000011603ULL, 0x00000080002b7824ULL, 0x000fe200078e022bULL,
0x000000010e147810ULL, 0x040fe20007ffe0ffULL, 0x000001000e177824ULL, 0x000fc400078e00ffULL,
0x0000008016377824ULL, 0x000fe200078e00ffULL, 0xfffffffa2b0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000001704167217ULL, 0x000fe40007800000ULL, 0x000000071400720cULL, 0x000fe40003f46070ULL,
0x0000000e37277210ULL, 0x000fe20007f3e0ffULL, 0x0000000116167824ULL, 0x000fe200078e0a17ULL,
0xfffffffc2b147810ULL, 0x040fe40007ffe0ffULL, 0xfffffffe2b0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x0000002016167807ULL, 0x000fc40001000000ULL,
0x0000002b371c7210ULL, 0x000fe40007f3e0ffULL, 0x00005e0027367a11ULL, 0x000fe400078640ffULL,
0x0000001437197210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x0000000e371b7210ULL, 0x000fe40007fbe0ffULL, 0x0000001609167217ULL, 0x000fe20007800000ULL,
0x000000ffff347224ULL, 0x000fe200020e06ffULL, 0x00005f0027277a11ULL, 0x000fe200018f4418ULL,
0x000000ffff187224ULL, 0x000fe200028e06ffULL, 0x00005e001c147a11ULL, 0x000fe200078240ffULL,
0x00000001160e7824ULL, 0x000fe200078e0a09ULL, 0x00000002352b7810ULL, 0x000fc40007ffe0ffULL,
0x00005e00192a7a11ULL, 0x000fe400078440ffULL, 0x00005e001b1a7a11ULL, 0x000fe400078640ffULL,
0x00005f001c1c7a11ULL, 0x000fe400008f4417ULL, 0x00005f0019197a11ULL, 0x000fe400010f4434ULL,
0x00005f001b1b7a11ULL, 0x000fe400018f4418ULL, 0x0000000e2b00720cULL, 0x000fc40003f26070ULL,
0x0000000f36167210ULL, 0x080fe40007f9e0ffULL, 0x00000006352b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000e3500720cULL, 0x0c0fe20003f46070ULL, 0x000000ffff177224ULL, 0x000fe200020e0627ULL,
0x0000000f2a187210ULL, 0x080fe40007fbe0ffULL, 0x0000000435357810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1a1a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff197224ULL, 0x000fe200028e0619ULL,
0x0000000e3500720cULL, 0x000fc40003f86070ULL, 0x0000000e2b00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x0000000f140e7210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000161d7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200018e061cULL, 0x00000000181e7faeULL, 0x0003e8000c901c46ULL,
0x000000001a1f7faeULL, 0x0003e8000e101c46ULL, 0x000000000e207faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff447f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff0f7984ULL, 0x002e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007824829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106b400ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007824829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e000f7305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x0000000f0000735dULL, 0x004fe40003800000ULL,
0x0106b400ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fc40007824829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff0e723eULL, 0x000fe400000010ffULL,
0x00000002ff6f7819ULL, 0x000fe40000011603ULL, 0x000054100e687816ULL, 0x000fe2000000000eULL,
0x0000bf427f007947ULL, 0x000fea000b800000ULL, 0x00001f6f68177589ULL, 0x0002a400000e0000ULL,
0x0000bf827f007947ULL, 0x000fea000b800000ULL, 0x00001ff468f47589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f9ULL,
0x0001344000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x0000c63000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f7ULL,
0x000134a000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x0000c5d000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000211c783bULL, 0x000f680000004200ULL,
0x000000002234783bULL, 0x000fe80000004200ULL, 0x000000002318783bULL, 0x0003e80000004200ULL,
0x000000002428783bULL, 0x000ee20000004200ULL, 0x00000018ff217819ULL, 0x020fe2000001141dULL,
0x0000001c00bd7306ULL, 0x000fe20000009400ULL, 0x000001001c617824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc4000001141cULL, 0x00000018ff237819ULL, 0x002fe4000001141eULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000002100bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff277819ULL, 0x000fe4000001141fULL, 0x00000018ff6b7819ULL, 0x008fe4000001142aULL,
0x00000018ff3a7819ULL, 0x000fe4000001141bULL, 0x00000018ff677819ULL, 0x004fe20000011429ULL,
0x0000002100b87306ULL, 0x000fe20000205400ULL, 0x00000018ff6c7819ULL, 0x000fce000001142bULL,
0x00000021008c7306ULL, 0x0003f0000020d400ULL, 0x0000001c00867306ULL, 0x000ea20000005400ULL,
0x00000018ff217819ULL, 0x002fce0000011435ULL, 0x0000002100ad7306ULL, 0x000ff00000209400ULL,
0x0000002100a87306ULL, 0x000fe20000205400ULL, 0x00000086bd00720bULL, 0x004fce0003f5d000ULL,
0x0000002100667306ULL, 0x0003f0000020d400ULL, 0x0000006b00477306ULL, 0x000fe20000209400ULL,
0x00000018ff217819ULL, 0x002fce0000011419ULL, 0x00000021007f7306ULL, 0x000ff00000209400ULL,
0x0000002100807306ULL, 0x000ff00000205400ULL, 0x00000021004d7306ULL, 0x000ff0000020d400ULL,
0x0000006b004c7306ULL, 0x000ff00000205400ULL, 0x0000006b00217306ULL, 0x0003f0000020d400ULL,
0x0000001d00b97306ULL, 0x000fe20000009400ULL, 0x000001001d6b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x0000001d00727306ULL, 0x000e700000005400ULL,
0x0000001d000f7306ULL, 0x0004f0000000d400ULL, 0x0000006100bc7306ULL, 0x000fe20000209400ULL,
0x000100001d1d7824ULL, 0x004fe200078e00ffULL, 0x00000072b900720bULL, 0x002fcc0003f3d000ULL,
0x0000006100c17306ULL, 0x000e6e0000205400ULL, 0x000000010f0f1812ULL, 0x008fe200078efcffULL,
0x0000006100a17306ULL, 0x0005f0000020d400ULL, 0x0000001c000e7306ULL, 0x000762000000d400ULL,
0x00000018ff617819ULL, 0x004fc4000001141dULL, 0x000000c1bc00720bULL, 0x002fca0003fdd000ULL,
0x0000006100c07306ULL, 0x000fe20000209400ULL, 0x000100001c1c7824ULL, 0x008fce00078e00ffULL,
0x00000061001d7306ULL, 0x000e620000205400ULL, 0x000000010e0e2812ULL, 0x020fe400078efcffULL,
0x00000001a1a16812ULL, 0x000fe400078efcffULL, 0x000000b8bf00720bULL, 0x000fe40003fdd000ULL,
0x0000000ea10e723eULL, 0x000fe200000010ffULL, 0x0000001400ba7306ULL, 0x000ff00000209400ULL,
0x00000014008d7306ULL, 0x000ea20000205400ULL, 0x0000001dc000720bULL, 0x002fc40003f5d000ULL,
0x000000018c8c6812ULL, 0x000fca00078efcffULL, 0x0000001400167306ULL, 0x0002f0000020d400ULL,
0x0000002300bb7306ULL, 0x000fe20000209400ULL, 0x00000018ff147819ULL, 0x002fe40000011434ULL,
0x0000008dba00720bULL, 0x004fca0003f7d000ULL, 0x0000002300b67306ULL, 0x000ff00000205400ULL,
0x00000023007e7306ULL, 0x0003e2000020d400ULL, 0x0000000116163812ULL, 0x008fce00078efcffULL,
0x0000001400b07306ULL, 0x000fe20000209400ULL, 0x00000018ff237819ULL, 0x002fce0000011436ULL,
0x0000001400b37306ULL, 0x000ff00000205400ULL, 0x00000014006d7306ULL, 0x0003f0000020d400ULL,
0x0000002700b77306ULL, 0x000fe20000209400ULL, 0x00000018ff147819ULL, 0x002fce0000011418ULL,
0x0000002700b47306ULL, 0x000ff00000205400ULL, 0x0000002700747306ULL, 0x0003f0000020d400ULL,
0x0000002300a77306ULL, 0x000fe20000209400ULL, 0x00000018ff277819ULL, 0x002fce0000011437ULL,
0x00000023009c7306ULL, 0x000ff00000205400ULL, 0x0000002300647306ULL, 0x0003f0000020d400ULL,
0x00000061008f7306ULL, 0x000ea2000020d400ULL, 0x00000018ff237819ULL, 0x002fce000001141aULL,
0x0000001400887306ULL, 0x000ff00000209400ULL, 0x0000001400897306ULL, 0x000fe20000205400ULL,
0x000000018f8f2812ULL, 0x004fe400078efcffULL, 0x000000b6bb00720bULL, 0x000fca0003f5d000ULL,
0x00000014005c7306ULL, 0x0003f0000020d400ULL, 0x0000002700a27306ULL, 0x000fe20000209400ULL,
0x00000018ff147819ULL, 0x002fe40000011428ULL, 0x000000017e7e2812ULL, 0x000fca00078efcffULL,
0x0000002700a57306ULL, 0x000ff00000205400ULL, 0x00000027005e7306ULL, 0x000ff0000020d400ULL,
0x0000002300687306ULL, 0x000ff00000209400ULL, 0x0000002300697306ULL, 0x000ff00000205400ULL,
0x0000002300467306ULL, 0x000ff0000020d400ULL, 0x0000003a00627306ULL, 0x000ff00000209400ULL,
0x0000003a00657306ULL, 0x000ff00000205400ULL, 0x0000003a00397306ULL, 0x000ff0000020d400ULL,
0x0000001400567306ULL, 0x000ff00000209400ULL, 0x0000001400577306ULL, 0x000ff00000205400ULL,
0x0000001400277306ULL, 0x000ff0000020d400ULL, 0x00000067004e7306ULL, 0x000ff00000209400ULL,
0x00000067004f7306ULL, 0x000ff00000205400ULL, 0x0000006700237306ULL, 0x0003f0000020d400ULL,
0x0000006c003a7306ULL, 0x000fe20000209400ULL, 0x00000018ff677819ULL, 0x002fce000001141cULL,
0x0000006c003b7306ULL, 0x000ff00000205400ULL, 0x0000006c00147306ULL, 0x0003f0000020d400ULL,
0x0000001e00b57306ULL, 0x000fe20000009400ULL, 0x000001001e6c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000001e00a67306ULL, 0x000e700000005400ULL,
0x0000001e00877306ULL, 0x0004f0000000d400ULL, 0x00000067001c7306ULL, 0x000fe20000209400ULL,
0x000100001e1e7824ULL, 0x004fe200078e00ffULL, 0x000000a6b500720bULL, 0x002fc80003f7d000ULL,
0x00000018ff617819ULL, 0x000fe4000001141eULL, 0x0000006700c37306ULL, 0x000e6e0000205400ULL,
0x0000000187873812ULL, 0x008fe200078efcffULL, 0x0000006700977306ULL, 0x0004f0000020d400ULL,
0x0000003500ac7306ULL, 0x000fe20000009400ULL, 0x000001001f677824ULL, 0x004fe200078e00ffULL,
0x000000c31c00720bULL, 0x002fc40003fbd000ULL, 0x0000b800251c7811ULL, 0x000fe400078e20ffULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x0000003500b17306ULL, 0x000e6e0000005400ULL,
0x0000000197975812ULL, 0x008fe200078efcffULL, 0x0000001f00937306ULL, 0x000fe60000009400ULL,
0x000000971616723eULL, 0x000fca00000010ffULL, 0x0000001f00b27306ULL, 0x000ea20000005400ULL,
0x000000b1ac00720bULL, 0x002fce0003f5d000ULL, 0x0000001f00817306ULL, 0x0002f0000000d400ULL,
0x00000061001e7306ULL, 0x000fe20000209400ULL, 0x000100001f1f7824ULL, 0x002fe200078e00ffULL,
0x000000b29300720bULL, 0x004fcc0003f3d000ULL, 0x0000006100cb7306ULL, 0x000e6e0000205400ULL,
0x0000000181811812ULL, 0x008fe200078efcffULL, 0x0000006100857306ULL, 0x0004f0000020d400ULL,
0x0000006700c47306ULL, 0x000fe20000209400ULL, 0x0000010036617824ULL, 0x004fe200078e00ffULL,
0x000000cb1e00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006700c97306ULL, 0x000fee0000205400ULL, 0x0000000185856812ULL, 0x008fe200078efcffULL,
0x0000006700847306ULL, 0x0003e6000020d400ULL, 0x000000857e7e723eULL, 0x000fca00000010ffULL,
0x0000006b00c57306ULL, 0x000fe20000209400ULL, 0x0000010035677824ULL, 0x002fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x0000006b00be7306ULL, 0x000e700000205400ULL,
0x0000006b009e7306ULL, 0x0005f0000020d400ULL, 0x00000035006f7306ULL, 0x000762000000d400ULL,
0x00000018ff6b7819ULL, 0x004fc4000001141fULL, 0x000000bec500720bULL, 0x002fca0003f9d000ULL,
0x0000006b001f7306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x008fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000006b00c87306ULL, 0x000e620000205400ULL,
0x000000016f6f2812ULL, 0x020fe400078efcffULL, 0x000000019e9e4812ULL, 0x000fe400078efcffULL,
0x000000c9c400720bULL, 0x000fe40003f9d000ULL, 0x0000000f9e0f723eULL, 0x000fe200000010ffULL,
0x0000006100d17306ULL, 0x000ff00000209400ULL, 0x0000006100cc7306ULL, 0x000ea20000205400ULL,
0x000000c81f00720bULL, 0x002fc40003f7d000ULL, 0x0000000184844812ULL, 0x000fe200078efcffULL,
0x000000001c1c783bULL, 0x000e680000000200ULL, 0x0000006700d57306ULL, 0x000ff00000209400ULL,
0x0000006700d07306ULL, 0x000ee20000205400ULL, 0x000000ccd100720bULL, 0x004fce0003f5d000ULL,
0x00000067007a7306ULL, 0x000570000020d400ULL, 0x00000037009f7306ULL, 0x000fe20000009400ULL,
0x0000010037677824ULL, 0x004fe200078e00ffULL, 0x000000d0d500720bULL, 0x008fc80003fdd000ULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x00000037009a7306ULL, 0x000fe20000005400ULL,
0x000000171c1c8231ULL, 0x082fe400003400ffULL, 0x000000171e1e8231ULL, 0x000fc800003400ffULL,
0x000000017a7a6812ULL, 0x020fe200078efcffULL, 0x0000003700637306ULL, 0x0003e2000000d400ULL,
0x000000f41d1d8231ULL, 0x090fe400003400ffULL, 0x000000f41f1f8231ULL, 0x000fca00003400ffULL,
0x0000006c00c77306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x002fe200078e00ffULL,
0x0000000e1c10723cULL, 0x000fe80000041810ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000006c00c27306ULL, 0x000e700000205400ULL, 0x0000006c008e7306ULL, 0x0004f0000020d400ULL,
0x0000003400ae7306ULL, 0x000fe20000009400ULL, 0x00000100346c7824ULL, 0x004fe200078e00ffULL,
0x000000c2c700720bULL, 0x002fc80003fbd000ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000003400af7306ULL, 0x000e6e0000005400ULL, 0x000000018e8e5812ULL, 0x008fe200078efcffULL,
0x0000003400787306ULL, 0x0004e2000000d400ULL, 0x000000b4b700720bULL, 0x000fc40003fbd000ULL,
0x000000878e8e723eULL, 0x000fca00000010ffULL, 0x0000006b007d7306ULL, 0x000f22000020d400ULL,
0x0001000034347824ULL, 0x004fe200078e00ffULL, 0x000000afae00720bULL, 0x002fe20003f3d000ULL,
0x000100002aaf7824ULL, 0x000fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000006100777306ULL, 0x000e62000020d400ULL, 0x0000000174745812ULL, 0x000fe400078efcffULL,
0x000000b3b000720bULL, 0x000fe20003fbd000ULL, 0x000001002bb07824ULL, 0x000fe200078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe400000114afULL, 0x0000000178781812ULL, 0x008fe200078efcffULL,
0x0000003600ab7306ULL, 0x000fe20000009400ULL, 0x000000017d7d3812ULL, 0x010fc400078efcffULL,
0x000000a8ad00720bULL, 0x000fe20003f3d000ULL, 0x000001002aad7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fc600000114b0ULL, 0x0000003600aa7306ULL, 0x000ea20000005400ULL,
0x0000000177772812ULL, 0x002fe400078efcffULL, 0x000000016d6d5812ULL, 0x000fe400078efcffULL,
0x0000009a9f00720bULL, 0x000fe40003fbd000ULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x0000003700d77306ULL, 0x000fe20000209400ULL, 0x0000000166661812ULL, 0x000fe400078efcffULL,
0x0000009ca700720bULL, 0x000fca0003f3d000ULL, 0x0000003700d27306ULL, 0x000e620000205400ULL,
0x000000aaab00720bULL, 0x004fe20003f7d000ULL, 0x0001000029aa7824ULL, 0x000fe200078e00ffULL,
0x0000000163635812ULL, 0x000fc800078efcffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x0000003400d67306ULL, 0x000fe20000209400ULL, 0x0000000164641812ULL, 0x000fce00078efcffULL,
0x0000003400db7306ULL, 0x000fe20000205400ULL, 0x000000d2d700720bULL, 0x002fce0003f5d000ULL,
0x00000034007c7306ULL, 0x0003f0000020d400ULL, 0x00000036006a7306ULL, 0x0004e2000000d400ULL,
0x0000010018347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500d87306ULL, 0x000fe20000209400ULL, 0x0001000036367824ULL, 0x004fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003500dd7306ULL, 0x000e620000205400ULL,
0x000000016a6a3812ULL, 0x008fe400078efcffULL, 0x000000a5a200720bULL, 0x000fe40003f7d000ULL,
0x0000006a770e723eULL, 0x000fc600000010ffULL, 0x0000003500757306ULL, 0x0005f0000020d400ULL,
0x00000037006b7306ULL, 0x000722000020d400ULL, 0x0000010019357824ULL, 0x004fe200078e00ffULL,
0x000000015e5e3812ULL, 0x000fc400078efcffULL, 0x000000ddd800720bULL, 0x002fe40003fdd000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400d97306ULL, 0x000fe20000209400ULL,
0x000001001a377824ULL, 0x008fca00078e00ffULL, 0x00000018ffde7819ULL, 0x000fe40000011437ULL,
0x0000003400d47306ULL, 0x000e620000205400ULL, 0x000000016b6b2812ULL, 0x010fe400078efcffULL,
0x0000000175756812ULL, 0x000fc800078efcffULL, 0x000000756675723eULL, 0x000fe200000010ffULL,
0x0000001800a07306ULL, 0x000ff00000009400ULL, 0x0000001800a37306ULL, 0x000fe20000005400ULL,
0x000000d4d900720bULL, 0x002fce0003f5d000ULL, 0x00000018005f7306ULL, 0x0003f0000000d400ULL,
0x0000006c00ce7306ULL, 0x000fe20000209400ULL, 0x0001000018187824ULL, 0x002fca00078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000006c00d37306ULL, 0x000e700000205400ULL,
0x0000003600cf7306ULL, 0x000ff00000209400ULL, 0x0000003600ca7306ULL, 0x000ea20000205400ULL,
0x000000d3ce00720bULL, 0x002fce0003f9d000ULL, 0x0000003600737306ULL, 0x000e70000020d400ULL,
0x0000003500dc7306ULL, 0x000fe20000209400ULL, 0x000000cacf00720bULL, 0x004fce0003fdd000ULL,
0x0000003500e17306ULL, 0x000eac0000205400ULL, 0x0000000173736812ULL, 0x002fe400078efcffULL,
0x0000003500367306ULL, 0x0002e4000020d400ULL, 0x000000736464723eULL, 0x000fcc00000010ffULL,
0x0000006c007b7306ULL, 0x000f22000020d400ULL, 0x000001001b357824ULL, 0x002fe200078e00ffULL,
0x000000e1dc00720bULL, 0x004fcc0003f7d000ULL, 0x0000006700c67306ULL, 0x000fee0000209400ULL,
0x0000000136363812ULL, 0x008fe200078efcffULL, 0x0000006700cd7306ULL, 0x000e620000205400ULL,
0x000000017b7b4812ULL, 0x010fe400078efcffULL, 0x000000dbd600720bULL, 0x000fc40003f9d000ULL,
0x000000787b78723eULL, 0x000fc600000010ffULL, 0x00000067006e7306ULL, 0x000ff0000020d400ULL,
0x00000034006c7306ULL, 0x000ea2000020d400ULL, 0x000000017c7c4812ULL, 0x000fe400078efcffULL,
0x000000cdc600720bULL, 0x002fca0003f9d000ULL, 0x0000001800df7306ULL, 0x000ff00000209400ULL,
0x0000001800da7306ULL, 0x000e620000205400ULL, 0x000000016c6c2812ULL, 0x004fe400078efcffULL,
0x000000016e6e4812ULL, 0x000fc400078efcffULL, 0x000000a3a000720bULL, 0x000fe40003f9d000ULL,
0x000000636e0f723eULL, 0x000fe200000010ffULL, 0x0000001800677306ULL, 0x0004ec000020d400ULL,
0x0000000e1c40723cULL, 0x000fe40000041840ULL, 0x00000019009d7306ULL, 0x000fe20000009400ULL,
0x00000018ff187819ULL, 0x004fc40000011435ULL, 0x000000dadf00720bULL, 0x002fe40003f5d000ULL,
0x000000015f5f4812ULL, 0x000fe400078efcffULL, 0x000000898800720bULL, 0x000fe20003f9d000ULL,
0x0000001900947306ULL, 0x000e700000005400ULL, 0x0000001900557306ULL, 0x000522000000d400ULL,
0x0000000167672812ULL, 0x008fc600078efcffULL, 0x000000015c5c4812ULL, 0x000fc800078efcffULL,
0x00000018008a7306ULL, 0x000fe20000209400ULL, 0x0001000019197824ULL, 0x004fe200078e00ffULL,
0x000000949d00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018008b7306ULL, 0x000fee0000205400ULL, 0x0000000155555812ULL, 0x010fe200078efcffULL,
0x0000001800357306ULL, 0x0003e2000020d400ULL, 0x000000807f00720bULL, 0x000fc40003fbd000ULL,
0x0000007d747f723eULL, 0x000fe400000010ffULL, 0x0000007c6d74723eULL, 0x000fc600000010ffULL,
0x0000001a009b7306ULL, 0x000fe20000009400ULL, 0x0000010028187824ULL, 0x002fe200078e00ffULL,
0x0000007e1c58723cULL, 0x040fe80000041858ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000001a00967306ULL, 0x000e620000005400ULL, 0x000000014d4d5812ULL, 0x000fe200078efcffULL,
0x000000741c48723cULL, 0x000fec0000041848ULL, 0x0000001a00547306ULL, 0x0004f0000000d400ULL,
0x0000001b00987306ULL, 0x000fe20000009400ULL, 0x000100001a1a7824ULL, 0x004fe200078e00ffULL,
0x000000969b00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000001b00997306ULL, 0x000e6e0000005400ULL, 0x0000000154546812ULL, 0x008fe200078efcffULL,
0x0000001b00447306ULL, 0x0004e2000000d400ULL, 0x000000696800720bULL, 0x000fce0003fdd000ULL,
0x0000001900a97306ULL, 0x000fe20000209400ULL, 0x000100001b1b7824ULL, 0x004fe200078e00ffULL,
0x000000999800720bULL, 0x002fc80003f3d000ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x0000001900a47306ULL, 0x000e620000205400ULL, 0x0000000146466812ULL, 0x000fcc00078efcffULL,
0x0000000144441812ULL, 0x008fe200078efcffULL, 0x0000001900347306ULL, 0x0004e2000020d400ULL,
0x000000656200720bULL, 0x000fe40003f3d000ULL, 0x0000006b5e65723eULL, 0x000fe400000010ffULL,
0x0000005f6c5e723eULL, 0x000fe400000010ffULL, 0x00000055365f723eULL, 0x000fe200000010ffULL,
0x000000de00907306ULL, 0x000fe20000209400ULL, 0x0000010029197824ULL, 0x004fe200078e00ffULL,
0x000000a4a900720bULL, 0x002fe20003f7d000ULL, 0x000000641c3c723cULL, 0x000fe2000004183cULL,
0x000000675c62723eULL, 0x000fc400000010ffULL, 0x00000018ffae7819ULL, 0x000fe40000011419ULL,
0x000000de00917306ULL, 0x000e620000205400ULL, 0x0000000139391812ULL, 0x000fe400078efcffULL,
0x000000575600720bULL, 0x000fc80003f3d000ULL, 0x0000000134343812ULL, 0x008fe200078efcffULL,
0x0000001800a67306ULL, 0x000fe20000209400ULL, 0x0000008b8a00720bULL, 0x000fe40003f7d000ULL,
0x000000344d63723eULL, 0x000fca00000010ffULL, 0x0000001800b57306ULL, 0x000fe20000205400ULL,
0x000000919000720bULL, 0x002fe40003f5d000ULL, 0x0000000127271812ULL, 0x000fe400078efcffULL,
0x0000003b3a00720bULL, 0x000fe40003f3d000ULL, 0x0000000135353812ULL, 0x000fe200078efcffULL,
0x0000001800937306ULL, 0x0003e6000020d400ULL, 0x000000443535723eULL, 0x000fca00000010ffULL,
0x0000001a00827306ULL, 0x000fe20000209400ULL, 0x0000b80026187811ULL, 0x002fe400078e20ffULL,
0x0000000114141812ULL, 0x000fca00078efcffULL, 0x0000001a00837306ULL, 0x000ff00000205400ULL,
0x0000001a00377306ULL, 0x000ff0000020d400ULL, 0x0000001b00867306ULL, 0x000ff00000209400ULL,
0x0000001b008d7306ULL, 0x000e700000205400ULL, 0x0000001b00727306ULL, 0x0004f0000020d400ULL,
0x000000de00617306ULL, 0x000f22000020d400ULL, 0x000000001818783bULL, 0x004ea20000000200ULL,
0x0000008d8600720bULL, 0x002fcc0003f7d000ULL, 0x0000002800927306ULL, 0x000fee0000009400ULL,
0x0000000172723812ULL, 0x008fe200078efcffULL, 0x0000002800957306ULL, 0x000e620000005400ULL,
0x0000000161612812ULL, 0x010fe400078efcffULL, 0x000000838200720bULL, 0x000fc40003f5d000ULL,
0x000000546134723eULL, 0x000fc600000010ffULL, 0x0000002800387306ULL, 0x0007f0000000d400ULL,
0x0000002900767306ULL, 0x000fe20000009400ULL, 0x0001000028287824ULL, 0x008fe200078e00ffULL,
0x0000000137372812ULL, 0x000fc400078efcffULL, 0x000000b5a600720bULL, 0x000fe40003f5d000ULL,
0x00000018ffa87819ULL, 0x000fe40000011428ULL, 0x0000002900797306ULL, 0x000ee20000005400ULL,
0x0000001718188231ULL, 0x084fe200003400ffULL, 0x000000374646723eULL, 0x000fe200000010ffULL,
0x000000171a1a8231ULL, 0x000fe200003400ffULL, 0x0000008f8c17723eULL, 0x000fe200000010ffULL,
0x000000f419198231ULL, 0x080fe200003400ffULL, 0x00000081848f723eULL, 0x000fe200000010ffULL,
0x000000f41b1b8231ULL, 0x000fe200003400ffULL, 0x0000002900247306ULL, 0x000ea2000000d400ULL,
0x0000000193932812ULL, 0x000fc400078efcffULL, 0x000000161c2c723cULL, 0x000fe2000004182cULL,
0x000000959200720bULL, 0x002fc80003f1d000ULL, 0x000000ae00ac7306ULL, 0x000fe20000209400ULL,
0x000000797600720bULL, 0x008fe40003f9d000ULL, 0x0000006f7a79723eULL, 0x000fe200000010ffULL,
0x0000008e1c30723cULL, 0x040fe80000041830ULL, 0x000000ae00ab7306ULL, 0x000e620000205400ULL,
0x0000000138380812ULL, 0x000fe400078efcffULL, 0x0000004f4e00720bULL, 0x000fe20003f1d000ULL,
0x000000781c50723cULL, 0x000fe20000041850ULL, 0x000000389338723eULL, 0x000fc400000010ffULL,
0x0000000124244812ULL, 0x004fe200078efcffULL, 0x000000a800287306ULL, 0x000fe20000209400ULL,
0x0000004c4700720bULL, 0x000fe40003f9d000ULL, 0x000000723947723eULL, 0x000fca00000010ffULL,
0x000000a800297306ULL, 0x000ea20000205400ULL, 0x000000abac00720bULL, 0x002fe20003f7d000ULL,
0x000000461858723cULL, 0x000fe20000041858ULL, 0x0000000123230812ULL, 0x000fc600078efcffULL,
0x0000000121214812ULL, 0x000fe400078efcffULL, 0x0000002b005d7306ULL, 0x000fe40000009400ULL,
0x000000341834723cULL, 0x000fec0000041830ULL, 0x0000002b00607306ULL, 0x000e620000005400ULL,
0x000000292800720bULL, 0x004fce0003f5d000ULL, 0x000000ae00257306ULL, 0x000eb0000020d400ULL,
0x000000a800267306ULL, 0x000ee2000020d400ULL, 0x000000605d00720bULL, 0x002fe40003fdd000ULL,
0x0000005e185c723cULL, 0x000fea0000041810ULL, 0x000000aa00947306ULL, 0x000fe20000209400ULL,
0x0000000125253812ULL, 0x004fc400078efcffULL, 0x000000621860723cULL, 0x000fe4000004182cULL,
0x000000242539723eULL, 0x000fc600000010ffULL, 0x000000aa00997306ULL, 0x000e620000205400ULL,
0x0000000126262812ULL, 0x008fc600078efcffULL, 0x000000381850723cULL, 0x000fe20000041850ULL,
0x000000262726723eULL, 0x000fc600000010ffULL, 0x000000ad00887306ULL, 0x000ff00000209400ULL,
0x000000ad00177306ULL, 0x000ea20000205400ULL, 0x000000999400720bULL, 0x002fce0003f7d000ULL,
0x0000002b00207306ULL, 0x0002f0000000d400ULL, 0x0000002a00707306ULL, 0x000fe20000009400ULL,
0x000100002b2b7824ULL, 0x002fe200078e00ffULL, 0x000000178800720bULL, 0x004fc80003f5d000ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000002a00717306ULL, 0x000e620000005400ULL,
0x0000000120206812ULL, 0x008fce00078efcffULL, 0x0000002a00227306ULL, 0x000eb0000000d400ULL,
0x000000aa002a7306ULL, 0x000ee2000020d400ULL, 0x000000717000720bULL, 0x002fce0003fbd000ULL,
0x000000ad007d7306ULL, 0x000e6c000020d400ULL, 0x0000000122225812ULL, 0x004fe400078efcffULL,
0x000000b000167306ULL, 0x000fe20000209400ULL, 0x000000012a2a3812ULL, 0x008fc800078efcffULL,
0x0000002a2327723eULL, 0x000fc600000010ffULL, 0x000000b000697306ULL, 0x000ea20000205400ULL,
0x000000017d7d2812ULL, 0x002fc600078efcffULL, 0x000000261848723cULL, 0x000fe20000041848ULL,
0x000000227d22723eULL, 0x000fc600000010ffULL, 0x000000af000e7306ULL, 0x000ff00000209400ULL,
0x000000af000f7306ULL, 0x000e620000205400ULL, 0x000000691600720bULL, 0x004fce0003f7d000ULL,
0x0000002b00117306ULL, 0x000ff00000209400ULL, 0x0000002b00127306ULL, 0x000ea20000205400ULL,
0x0000000f0e00720bULL, 0x002fce0003f1d000ULL, 0x000000b0006d7306ULL, 0x000e70000020d400ULL,
0x000000af00107306ULL, 0x000ee2000020d400ULL, 0x000000121100720bULL, 0x004fce0003f5d000ULL,
0x0000002b002b7306ULL, 0x000ea2000020d400ULL, 0x000000016d6d3812ULL, 0x002fc800078efcffULL,
0x000000206d23723eULL, 0x000fe400000010ffULL, 0x0000000110100812ULL, 0x008fc800078efcffULL,
0x000000102110723eULL, 0x000fe200000010ffULL, 0x000000221840723cULL, 0x000fe20000041840ULL,
0x000000012b2b2812ULL, 0x004fc800078efcffULL, 0x0000002b1411723eULL, 0x000fce00000010ffULL,
0x00000010183c723cULL, 0x000fe2000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff2d7224ULL, 0x002fc600078e000fULL, 0x0000030005057a10ULL, 0x000fc80007ffe0ffULL,
0x000000070500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffebbc000007947ULL, 0x000fea000383ffffULL, 0x0000000000127919ULL, 0x000ee40000002500ULL,
0x000000071200720cULL, 0x008fda0003f06070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x018000000c007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff337224ULL, 0x000fe200078e000cULL,
0x00015380001a7802ULL, 0x000fe40000000f00ULL, 0x0000a54000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000c00037308ULL, 0x000ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc8000000000cULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff057624ULL, 0x000fe400078e00ffULL,
0x00006800ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x000ee8000c1e9900ULL,
0x0000000000077919ULL, 0x000f240000000000ULL, 0x00000002ff037819ULL, 0x010fe40000011607ULL,
0x0000000807077811ULL, 0x000fe200078ff0ffULL, 0x0000000005007220ULL, 0x008fca0000410000ULL,
0x00001f0300037589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f2200000e0000ULL,
0x0000005c035c7220ULL, 0x048fe40000410000ULL, 0x0000005d035d7220ULL, 0x040fe40000410000ULL,
0x0000006003607220ULL, 0x040fe40000410000ULL, 0x0000006103617220ULL, 0x000fc40000410000ULL,
0x0000003403347220ULL, 0x040fe40000410000ULL, 0x0000003503357220ULL, 0x040fe40000410000ULL,
0x0000005803587220ULL, 0x040fe40000410000ULL, 0x0000005903597220ULL, 0x040fe40000410000ULL,
0x0000005003507220ULL, 0x040fe40000410000ULL, 0x0000005103517220ULL, 0x000fc40000410000ULL,
0x0000004803487220ULL, 0x040fe40000410000ULL, 0x0000004903497220ULL, 0x040fe40000410000ULL,
0x0000004003407220ULL, 0x040fe40000410000ULL, 0x0000004103417220ULL, 0x040fe40000410000ULL,
0x0000003c033c7220ULL, 0x040fe40000410000ULL, 0x0000003d033d7220ULL, 0x000fc40000410000ULL,
0x0000005e075e7220ULL, 0x050fe40000410000ULL, 0x0000005f075f7220ULL, 0x040fe40000410000ULL,
0x0000006207627220ULL, 0x040fe40000410000ULL, 0x0000006307637220ULL, 0x040fe40000410000ULL,
0x0000003607367220ULL, 0x040fe40000410000ULL, 0x0000003707377220ULL, 0x000fc40000410000ULL,
0x0000005a075a7220ULL, 0x040fe40000410000ULL, 0x0000005b075b7220ULL, 0x040fe40000410000ULL,
0x0000005207527220ULL, 0x040fe40000410000ULL, 0x0000005307537220ULL, 0x040fe40000410000ULL,
0x0000004a074a7220ULL, 0x040fe40000410000ULL, 0x0000004b074b7220ULL, 0x000fc40000410000ULL,
0x0000004207427220ULL, 0x040fe40000410000ULL, 0x0000004307437220ULL, 0x040fe40000410000ULL,
0x0000003e073e7220ULL, 0x040fe40000410000ULL, 0x0000003f073f7220ULL, 0x000fe40000410000ULL,
0x0000000000037919ULL, 0x000ee20000000000ULL, 0x00000300ff207624ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x000000012000780cULL, 0x000fe40003f05270ULL,
0x0000000203007812ULL, 0x008fe400078ec0ffULL, 0x00000002ff137819ULL, 0x000fe40000011603ULL,
0x00000001ff047819ULL, 0x000fe40000011600ULL, 0x0000000200057811ULL, 0x000fc400078ff8ffULL,
0x0000000400087811ULL, 0x040fe400078ff8ffULL, 0x00000006000e7811ULL, 0x002fe400078ff8ffULL,
0x00000008031b7811ULL, 0x000fe400078ff0ffULL, 0x0000000704007812ULL, 0x100fe400078e7813ULL,
0x00000007080a7812ULL, 0x040fe400078e7813ULL, 0x0000000708087812ULL, 0x100fe200078e781bULL,
0x0000000813077824ULL, 0x000fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078e781bULL,
0x0000080002007824ULL, 0x000fe200078e00ffULL, 0x0000000705067812ULL, 0x100fe200078e7813ULL,
0x000000081b197824ULL, 0x040fe200078e0208ULL, 0x000000070e107812ULL, 0x040fe200078e7813ULL,
0x000000081b157824ULL, 0x000fe200078e0204ULL, 0x0000000705057812ULL, 0x100fe200078e781bULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0x000000070e0e7812ULL, 0x000fe200078e781bULL,
0x00000008130d7824ULL, 0x040fe200078e0206ULL, 0x0000a00000047810ULL, 0x000fe20007ffe0ffULL,
0x00000008130f7824ULL, 0x000fe200078e020aULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x000000081b177824ULL, 0x000fe200078e0205ULL, 0x0000005c5d05723eULL, 0x000fe200000010ffULL,
0x0000000813137824ULL, 0x000fe200078e0210ULL, 0x000000606106723eULL, 0x000fe200000010ffULL,
0x000000081b1b7824ULL, 0x000fe200078e020eULL, 0x0000005e5f0a723eULL, 0x000fe200000010ffULL,
0x0000001007077824ULL, 0x000fe200078e0204ULL, 0x00005410051c7816ULL, 0x000fe20000000006ULL,
0x000000100d0d7824ULL, 0x000fe200078e0204ULL, 0x00007632051d7816ULL, 0x000fe20000000006ULL,
0x000000100f117824ULL, 0x100fe200078e0204ULL, 0x000000505105723eULL, 0x000fe200000010ffULL,
0x0000001015157824ULL, 0x100fe200078e0204ULL, 0x000000484906723eULL, 0x000fe200000010ffULL,
0x0000001017177824ULL, 0x000fc400078e0204ULL, 0x0000001013137824ULL, 0x100fe400078e0204ULL,
0x0000001019197824ULL, 0x100fe400078e0204ULL, 0x000000101b1b7824ULL, 0x000fe400078e0204ULL,
0x00000001070e7824ULL, 0x000fe200078e0208ULL, 0x000000343507723eULL, 0x000fe200000010ffULL,
0x00000001080f7824ULL, 0x040fe200078e020dULL, 0x00000062630d723eULL, 0x000fe200000010ffULL,
0x0000000108117824ULL, 0x040fe200078e0211ULL, 0x0000001c0e007388ULL, 0x0003e20000000a00ULL,
0x0000000108157824ULL, 0x000fc400078e0215ULL, 0x0000000108177824ULL, 0x040fe400078e0217ULL,
0x0000000108137824ULL, 0x040fe400078e0213ULL, 0x0000000108197824ULL, 0x040fe400078e0219ULL,
0x00000001081b7824ULL, 0x000fe200078e021bULL, 0x000000585908723eULL, 0x000fe400000010ffULL,
0x00005410050e7816ULL, 0x002fe40000000006ULL, 0x00005410071c7816ULL, 0x000fc40000000008ULL,
0x00007632071d7816ULL, 0x000fe40000000008ULL, 0x000000404107723eULL, 0x000fe400000010ffULL,
0x0000003c3d08723eULL, 0x000fe200000010ffULL, 0x0000001c0f007388ULL, 0x0003e40000000a00ULL,
0x00007632050f7816ULL, 0x002fe40000000006ULL, 0x000000363705723eULL, 0x000fe400000010ffULL,
0x0000005a5b06723eULL, 0x000fe200000010ffULL, 0x0000000e11007388ULL, 0x0003e40000000a00ULL,
0x00005410070e7816ULL, 0x002fc40000000008ULL, 0x00007632070f7816ULL, 0x000fe40000000008ULL,
0x000000525307723eULL, 0x000fe400000010ffULL, 0x0000004a4b08723eULL, 0x000fe200000010ffULL,
0x0000000e13007388ULL, 0x0003e40000000a00ULL, 0x000054100a0e7816ULL, 0x142fe4000000000dULL,
0x000076320a0f7816ULL, 0x000fe4000000000dULL, 0x00000042430a723eULL, 0x000fc400000010ffULL,
0x0000003e3f0d723eULL, 0x000fe200000010ffULL, 0x0000000e15007388ULL, 0x0003e40000000a00ULL,
0x00005410050e7816ULL, 0x142fe40000000006ULL, 0x00007632050f7816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000000e17007388ULL, 0x0003e80000000a00ULL, 0x0000000619007388ULL, 0x0007e20000000a00ULL,
0x000054100a0e7816ULL, 0x002fc4000000000dULL, 0x000076320a0f7816ULL, 0x000fca000000000dULL,
0x0000000e1b007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002b5000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000002700ULL,
0x00000010030d7824ULL, 0x040fe200078e0200ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0x0000580020057a24ULL, 0x000fe200078e02ffULL, 0x0000000000077919ULL, 0x008e620000002600ULL,
0x00001000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000002003157810ULL, 0x000fe20007ffe0ffULL,
0x0000660005087a24ULL, 0x000fe200078e02ffULL, 0x00a000000d187984ULL, 0x0007220000000c00ULL,
0x000000ff0300720cULL, 0x000fc60000725670ULL, 0x00a200000d1c7984ULL, 0x0006a20000000c00ULL,
0x00000fff08067811ULL, 0x040fe400078e40ffULL, 0x01ffffff08087812ULL, 0x000fe200078ec0ffULL,
0x000058000a0a7a24ULL, 0x002fc800078e0207ULL, 0x000003000a057a24ULL, 0x000fc800078e02ffULL,
0x0000000105077824ULL, 0x000fca00078e0212ULL, 0x00000007060e7211ULL, 0x000fca00078fa0ffULL,
0x00006c000e0e7625ULL, 0x000fcc00078e000fULL, 0x00000400020e7825ULL, 0x000fcc00078e000eULL,
0x0000001015147825ULL, 0x000fc800078e000eULL, 0x0000001003127825ULL, 0x000fe200078e000eULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000001ff0e7819ULL, 0x01cfe20000011603ULL,
0x00000010030d7824ULL, 0x000fe400078e00ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x0000000c0e167812ULL, 0x000fe200078ec0ffULL, 0x0000000107107824ULL, 0x000fe200078e0208ULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x00006c00070e7625ULL, 0x000fc800078e0011ULL,
0x00006c0010107625ULL, 0x000fe200078e0011ULL, 0x0000000e160e7210ULL, 0x000fc80007b5e00dULL,
0x0000001016107210ULL, 0x000fe40007d9e00dULL, 0x0000000fff0f7210ULL, 0x000fe400017e64ffULL,
0x00000011ff117210ULL, 0x000fc600027ea4ffULL, 0x0000000b0e007986ULL, 0x0003e8000c101906ULL,
0x0000000c10007986ULL, 0x0003e4000c101906ULL, 0x0000001812007986ULL, 0x01c5e2000c101d06ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000001c14007986ULL, 0x0005e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x002fe200078e00ffULL, 0xffffffff20077810ULL, 0x000fc60007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x000000070a0a79a8ULL, 0x000ee400099ee1c6ULL,
0x000000070a00720cULL, 0x008fe20003f25270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000800000ULL, 0x0000000cff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff077984ULL, 0x000ee40000000000ULL, 0x000000ff0700720cULL, 0x008fda0003f25270ULL,
0x0000279000009947ULL, 0x000fea0003800000ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011603ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0x00000001050c7810ULL, 0x002fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000c0a137812ULL, 0x004fe400078ec0ffULL, 0x0000007007117812ULL, 0x000fe200078ec0ffULL,
0x00006c00050a7625ULL, 0x000fc800078e000fULL, 0x00006c000c0c7625ULL, 0x000fe200078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000c130c7210ULL, 0x000fe40007b5e011ULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a077981ULL, 0x000368000c1e1900ULL, 0x000000060c0e7981ULL, 0x000362000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a107981ULL, 0x000362000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a127981ULL, 0x000362000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a147981ULL, 0x000362000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a167981ULL, 0x000362000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe40003f06070ULL, 0x00000006050a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fe40007a3e011ULL,
0x00000007050c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e000fULL, 0x000000060a187981ULL, 0x000366000c1e1900ULL,
0x0000000c130c0210ULL, 0x000fc80007c7e011ULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c1c0981ULL, 0x000368000c1e1900ULL, 0x00000007200a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0c7819ULL, 0x000fc8000001160aULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x024fe400078e0007ULL, 0x000000080d0f7824ULL, 0x040fe200078e00ffULL,
0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000000c0d00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080f0a7810ULL, 0x040fe40007ffe0ffULL, 0x000000010f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001a07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1a7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000020f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000e07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0e7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000030f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a107981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000040f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001207077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a127981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000050f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001407077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a147981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000060f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a167981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000070f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001807077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a187981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0f0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000001c07077209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007a3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a1c7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x00000010030a7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010a0a7824ULL, 0x000fca00078e020bULL,
0x000000070a007388ULL, 0x0203e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000005060a7211ULL, 0x002fe200078fa0ffULL,
0x00001000ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x00000400023b7824ULL, 0x000fe200078e00ffULL, 0x00000016ff3d7819ULL, 0x000fe20000011602ULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000020030f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x0000003b0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000105108824ULL, 0x000fe200078e0208ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x00000080ff128424ULL, 0x004fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000010b0b7824ULL, 0x000fe200008e063dULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x0000100002227824ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00006c0010108625ULL, 0x000fe200078e0011ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001002178824ULL, 0x000fe200078e0203ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x00006c0005128625ULL, 0x000fc600078e0012ULL, 0x0000458017178811ULL, 0x000fe200078e20ffULL,
0x0000000107197824ULL, 0x000fe400078e020cULL, 0x00000010021b8824ULL, 0x000fe400078e0203ULL,
0x0000001003157824ULL, 0x040fe400078e0222ULL, 0x00000010030c7825ULL, 0x100fe200078e000aULL,
0x000041801b1b8811ULL, 0x000fe200078e20ffULL, 0x0000000019197984ULL, 0x000e640000000800ULL,
0x000000100f0e7825ULL, 0x000fc400078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c157faeULL, 0x0005e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000001003108825ULL, 0x040fe400078e0010ULL, 0x003800000e157faeULL, 0x0007e4000b901c46ULL,
0x0000001003128825ULL, 0x000fe400078e0012ULL, 0x0000000010178faeULL, 0x0009e4000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400078e00ffULL, 0x00000000121b8faeULL, 0x000be2000b901c46ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x00000000000c7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x010fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x020fe2000001ff00ULL, 0x00000d0000009947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134367810ULL, 0x000fc80007ffe0ffULL, 0x0000030036007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x0000000105357824ULL, 0x000fe200078e0236ULL,
0x000000070300780cULL, 0x040fe20003f24070ULL, 0x00001000ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000000136217812ULL, 0x040fe200078ec0ffULL, 0x00000800361c7824ULL, 0x000fe200078e00ffULL,
0x00000035061a7211ULL, 0x000fe400078fa0ffULL, 0x0000002003397810ULL, 0x000fe40007ffe0ffULL,
0x000008001c1f7812ULL, 0x000fe200078ec0ffULL, 0x00006c001a1a7625ULL, 0x000fc800078e001bULL,
0x00000001081d9824ULL, 0x000fe200078e0235ULL, 0x0000003b1a1a7210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff1e9424ULL, 0x000fe400078e00ffULL, 0x0000000202209824ULL, 0x000fe400078e0221ULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x00006c001d1c9625ULL, 0x000fc800078e001eULL,
0x00000001221e7824ULL, 0x000fe400078e021fULL, 0x00000002023a9824ULL, 0x000fe400078e0221ULL,
0x000000011b1b7824ULL, 0x000fe400000e063dULL, 0x0000000820379824ULL, 0x000fe400078e0203ULL,
0x00006c0035209625ULL, 0x000fc600078e0038ULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x0000001003357824ULL, 0x040fe400078e021eULL, 0x000000083a3a9824ULL, 0x000fe400078e0203ULL,
0x00000010031e9825ULL, 0x000fc800078e001cULL, 0x00000010391c7825ULL, 0x000fe200078e001aULL,
0x000041803a399811ULL, 0x000fc600078e20ffULL, 0x00000010031a7825ULL, 0x000fc800078e001aULL,
0x0000001003209825ULL, 0x000fe200078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800001a357faeULL, 0x0005e8000b901c46ULL, 0x003800001c357faeULL, 0x0005e8000b901c46ULL,
0x000000001e379faeULL, 0x0005e8000b901c46ULL, 0x0000000020399faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e0034ULL,
0x00000001ff1e7819ULL, 0x100fe20000011603ULL, 0x00000010031c7824ULL, 0x000fe200078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011603ULL, 0x000000801d1a7824ULL, 0x000fe200078e00ffULL,
0x0000000c1e1e7812ULL, 0x000fc400078ec0ffULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000835217824ULL, 0x040fe200078e00ffULL, 0x000000801a1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008351f7824ULL, 0x040fe200078e00ffULL, 0x0000000735407812ULL, 0x000fe400078ec0ffULL,
0x00000035ff3e7212ULL, 0x000fe200078e33ffULL, 0x00000100021b7824ULL, 0x000fe200078e021bULL,
0xfffffff81f1a7812ULL, 0x000fe400078ee240ULL, 0xfffffff8213e7812ULL, 0x000fc400078ee23eULL,
0x0000001b1e1c7210ULL, 0x000fe20007ffe01cULL, 0x00000008351b7824ULL, 0x040fe200078e00ffULL,
0x0000000835377810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001c3c7984ULL, 0x000ea20000000800ULL, 0x000000011b1e7812ULL, 0x100fe200078ef640ULL,
0x00000008371f7824ULL, 0x000fe200078e00ffULL, 0x000000021b207812ULL, 0x140fe200078ef640ULL,
0x004580001c4e7984ULL, 0x0004e20000000800ULL, 0x000000031b347812ULL, 0x100fe200078ef640ULL,
0x0000000837427824ULL, 0x000fe200078e00ffULL, 0x000000041b387812ULL, 0x140fe400078ef640ULL,
0x000000051b3a7812ULL, 0x000fe400078ef640ULL, 0x00000037ff4c7212ULL, 0x000fc800078e33ffULL,
0xfffffff81f4c7812ULL, 0x000fe400078ee24cULL, 0x00000007371f7812ULL, 0x000fe200078ec0ffULL,
0x0000003c191c7221ULL, 0x006fe20000010100ULL, 0x000000061b3c7812ULL, 0x000fe200078ef640ULL,
0x000008001d1b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b1c217820ULL, 0x000fe40000410000ULL,
0x00000004031c7824ULL, 0x000fe200078e00ffULL, 0x000008001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000837407824ULL, 0x000fc400078e00ffULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x00000180221b7810ULL, 0x000fe40007ffe01bULL, 0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8421c7812ULL, 0x000fe200078ee21fULL, 0x000000101a1a7824ULL, 0x000fe200078e021bULL,
0x0000000140427812ULL, 0x000fe200078ef61fULL, 0x000000103e3e7824ULL, 0x000fe200078e021bULL,
0x0000000240447812ULL, 0x000fe200078ef61fULL, 0x000000011a1a7824ULL, 0x000fe200078e021dULL,
0x0000000340467812ULL, 0x140fe200078ef61fULL, 0x000000011d3e7824ULL, 0x040fe200078e023eULL,
0x0000000440487812ULL, 0x000fe200078ef61fULL, 0x000000101e1e7824ULL, 0x000fe200078e021bULL,
0x00000005404a7812ULL, 0x000fe200078ef61fULL, 0x000000001a1a7984ULL, 0x000e620000000800ULL,
0x0000001020207824ULL, 0x000fe200078e021bULL, 0x0000000640407812ULL, 0x000fe200078ef61fULL,
0x000000011d1e7824ULL, 0x040fe200078e021eULL, 0x000000003e3e7984ULL, 0x000fe20000000800ULL,
0x000000011d207824ULL, 0x000fc400078e0220ULL, 0x0000001034347824ULL, 0x100fe400078e021bULL,
0x000000001e1e7984ULL, 0x000fe20000000800ULL, 0x0000004e214e7220ULL, 0x008fe40000410000ULL,
0x000000011d347824ULL, 0x040fe200078e0234ULL, 0x0000000020207984ULL, 0x000fe20000000800ULL,
0x0000001038387824ULL, 0x100fe400078e021bULL, 0x000000103a3a7824ULL, 0x000fe200078e021bULL,
0x00001f354e1f7589ULL, 0x000ea200000e0000ULL, 0x000000011d387824ULL, 0x000fc400078e0238ULL,
0x000000011d3a7824ULL, 0x040fe200078e023aULL, 0x0000000034347984ULL, 0x000ee20000000800ULL,
0x000000103c3c7824ULL, 0x100fe400078e021bULL, 0x000000101c1c7824ULL, 0x100fe200078e021bULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000011d3c7824ULL, 0x000fe400078e023cULL,
0x0000001042427824ULL, 0x100fe200078e021bULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x0000001044447824ULL, 0x000fc400078e021bULL, 0x0000001046467824ULL, 0x100fe200078e021bULL,
0x000000003c3c7984ULL, 0x000f220000000800ULL, 0x0000001048487824ULL, 0x100fe400078e021bULL,
0x000000104a4a7824ULL, 0x100fe400078e021bULL, 0x0000001040407824ULL, 0x100fe400078e021bULL,
0x000000104c4c7824ULL, 0x000fe200078e021bULL, 0x00005410ff1b7816ULL, 0x002fe2000000001aULL,
0x000000011d1c7824ULL, 0x040fe200078e021cULL, 0x00007610ff1a7816ULL, 0x000fe2000000001aULL,
0x000000011d427824ULL, 0x000fc400078e0242ULL, 0x0000001f1b327223ULL, 0x084fe20000010032ULL,
0x00005410ff1b7816ULL, 0x100fe2000000003eULL, 0x0000001f1a317223ULL, 0x080fe20000010031ULL,
0x00007610ff1a7816ULL, 0x000fe2000000003eULL, 0x000000001c1c7984ULL, 0x000e620000000800ULL,
0x000000011d447824ULL, 0x000fe400078e0244ULL, 0x0000001f1b247223ULL, 0x080fe20000010024ULL,
0x00005410ff1b7816ULL, 0x100fe2000000001eULL, 0x0000001f1a237223ULL, 0x000fe20000010023ULL,
0x00007610ff1a7816ULL, 0x000fe2000000001eULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x000000011d467824ULL, 0x000fc400078e0246ULL, 0x0000001f1b307223ULL, 0x080fe20000010030ULL,
0x00005410ff1b7816ULL, 0x100fe20000000020ULL, 0x0000001f1a2f7223ULL, 0x080fe2000001002fULL,
0x00007610ff1a7816ULL, 0x000fe20000000020ULL, 0x0000000044447984ULL, 0x000fe20000000800ULL,
0x000000011d487824ULL, 0x000fe400078e0248ULL, 0x0000001f1b2e7223ULL, 0x080fe2000001002eULL,
0x00005410ff1b7816ULL, 0x108fe20000000034ULL, 0x0000001f1a2d7223ULL, 0x000fe2000001002dULL,
0x00007610ff1a7816ULL, 0x000fe20000000034ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x000000334e337221ULL, 0x000fc40000010000ULL, 0x0000001f1b2c7223ULL, 0x080fe2000001002cULL,
0x00001f374e4e7589ULL, 0x000ea200000e0000ULL, 0x0000001f1a2b7223ULL, 0x080fe2000001002bULL,
0x00005410ff1b7816ULL, 0x010fe20000000038ULL, 0x000000011d4a7824ULL, 0x040fe200078e024aULL,
0x00007610ff1a7816ULL, 0x000fe20000000038ULL, 0x0000000048487984ULL, 0x000ee20000000800ULL,
0x000000011d407824ULL, 0x000fe400078e0240ULL, 0x0000001f1b2a7223ULL, 0x080fe2000001002aULL,
0x00005410ff1b7816ULL, 0x120fe2000000003aULL, 0x0000001f1a297223ULL, 0x000fe20000010029ULL,
0x00007610ff1a7816ULL, 0x000fe2000000003aULL, 0x000000004a4a7984ULL, 0x000f220000000800ULL,
0x000000011d4c7824ULL, 0x000fc400078e024cULL, 0x0000001f1b287223ULL, 0x080fe20000010028ULL,
0x00005410ff1b7816ULL, 0x100fe2000000003cULL, 0x0000001f1a277223ULL, 0x080fe20000010027ULL,
0x00007610ff1a7816ULL, 0x000fe2000000003cULL, 0x0000000040407984ULL, 0x000f620000000800ULL,
0x000000ffff347224ULL, 0x000fe400078e0036ULL, 0x0000001f1b267223ULL, 0x080fe20000010026ULL,
0x00005410ff1b7816ULL, 0x102fe2000000001cULL, 0x0000001f1a257223ULL, 0x000fe20000010025ULL,
0x00007610ff1a7816ULL, 0x000fe2000000001cULL, 0x000000004c4c7984ULL, 0x000e620000000800ULL,
0x0000030034007a0cULL, 0x000fe20003f06070ULL, 0x0000004e1b187223ULL, 0x084fe20000010018ULL,
0x00005410ff1b7816ULL, 0x100fe20000000042ULL, 0x0000004e1a177223ULL, 0x000fe20000010017ULL,
0x00007610ff1a7816ULL, 0x000fc60000000042ULL, 0x0000004e1b167223ULL, 0x080fe20000010016ULL,
0x00005410ff1b7816ULL, 0x100fe20000000044ULL, 0x0000004e1a157223ULL, 0x000fe20000010015ULL,
0x00007610ff1a7816ULL, 0x000fc60000000044ULL, 0x0000004e1b147223ULL, 0x080fe20000010014ULL,
0x00005410ff1b7816ULL, 0x100fe20000000046ULL, 0x0000004e1a137223ULL, 0x000fe20000010013ULL,
0x00007610ff1a7816ULL, 0x000fc60000000046ULL, 0x0000004e1b127223ULL, 0x080fe20000010012ULL,
0x00005410ff1b7816ULL, 0x108fe20000000048ULL, 0x0000004e1a117223ULL, 0x000fe20000010011ULL,
0x00007610ff1a7816ULL, 0x000fc60000000048ULL, 0x0000004e1b107223ULL, 0x080fe20000010010ULL,
0x00005410ff1b7816ULL, 0x110fe2000000004aULL, 0x0000004e1a0f7223ULL, 0x000fe2000001000fULL,
0x00007610ff1a7816ULL, 0x000fc6000000004aULL, 0x0000004e1b0e7223ULL, 0x080fe2000001000eULL,
0x00005410ff1b7816ULL, 0x120fe20000000040ULL, 0x0000004e1a0d7223ULL, 0x000fe2000001000dULL,
0x00007610ff1a7816ULL, 0x000fc60000000040ULL, 0x0000004e1b0c7223ULL, 0x080fe4000001000cULL,
0x0000004e1a0b7223ULL, 0x000fe2000001000bULL, 0x00005410ff1b7816ULL, 0x102fe4000000004cULL,
0x00007610ff1a7816ULL, 0x000fc6000000004cULL, 0x0000004e1b0a7223ULL, 0x080fe4000001000aULL,
0x0000004e1a077223ULL, 0x000fe20000010007ULL, 0xfffff32000008947ULL, 0x000fea000383ffffULL,
0x0180000033027810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000002027812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00017e20001a7802ULL, 0x000fe40000000f00ULL, 0x00007aa000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300027308ULL, 0x000ea40000001000ULL, 0xbf80000002037423ULL, 0x004fc80000000033ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fe40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000803417811ULL, 0x004fe400078ff0ffULL,
0x00000002ff337819ULL, 0x002fe40000011603ULL, 0x00000041ff437212ULL, 0x000fe200078e33ffULL,
0x00001f4102067589ULL, 0x000e6200000e0000ULL, 0x0000000841087824ULL, 0x000fc400078e00ffULL,
0x0000000833457824ULL, 0x000fe200078e00ffULL, 0x00001f3302057589ULL, 0x0004e400000e0000ULL,
0xfffffff808437812ULL, 0x000fca00078ee243ULL, 0x0000001043437824ULL, 0x000fe200078e0204ULL,
0x00000033ff027212ULL, 0x004fc800078e33ffULL, 0xfffffff845457812ULL, 0x000fe400078ee202ULL,
0x0000000733027812ULL, 0x000fe200078ec0ffULL, 0x0000001806187220ULL, 0x002fc60000410000ULL,
0x0000000202087812ULL, 0x000fe200078e3cffULL, 0x0000001706177220ULL, 0x040fe40000410000ULL,
0x0000001606167220ULL, 0x040fe40000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x0000001406147220ULL, 0x040fe40000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x0000001206127220ULL, 0x000fc40000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000001006107220ULL, 0x040fe40000410000ULL,
0x0000000f060f7220ULL, 0x040fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000000e060e7220ULL, 0x040fe20000410000ULL, 0x0000000741127812ULL, 0x000fe200078ec0ffULL,
0x0000000d060d7220ULL, 0x040fe20000410000ULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x0000000c060c7220ULL, 0x000fc40000410000ULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x0000000e0d0d723eULL, 0x000fe200000010ffULL, 0x0000000a060a7220ULL, 0x000fe20000410000ULL,
0x00000005020e7812ULL, 0x000fe200078e3cffULL, 0x0000000706077220ULL, 0x000fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x0000000833067824ULL, 0x000fe200078e00ffULL,
0x00000004020c7812ULL, 0x000fe200078e3cffULL, 0x0000003205327220ULL, 0x008fe20000410000ULL,
0x0000000a0707723eULL, 0x000fe200000010ffULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0xfffffff806197812ULL, 0x000fe200078ee233ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000000102067812ULL, 0x040fe200078e3cffULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x00000003020a7812ULL, 0x040fe200078e3cffULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x000000323131723eULL, 0x000fe200000010ffULL, 0x0000002c052c7220ULL, 0x000fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000010ffULL, 0x0000002b052b7220ULL, 0x000fe20000410000ULL,
0x0000002e2d2d723eULL, 0x000fe200000010ffULL, 0x0000002a052a7220ULL, 0x000fc40000410000ULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000010ffULL,
0x0000002805287220ULL, 0x040fe40000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000010ffULL, 0x0000002605267220ULL, 0x040fe40000410000ULL,
0x0000002505257220ULL, 0x000fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x0000002405247220ULL, 0x000fc40000410000ULL, 0x0000002305057220ULL, 0x000fe20000410000ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x00000008331b7824ULL, 0x040fe200078e0206ULL,
0x0000000212067812ULL, 0x040fe200078e3cffULL, 0x00000008331d7824ULL, 0x040fe200078e0208ULL,
0x0000000312087812ULL, 0x040fe200078e3cffULL, 0x00000008331f7824ULL, 0x040fe200078e020aULL,
0x00000004120a7812ULL, 0x040fe200078e3cffULL, 0x0000000833217824ULL, 0x040fe200078e020cULL,
0x00000005120c7812ULL, 0x040fe200078e3cffULL, 0x0000000833237824ULL, 0x040fe200078e020eULL,
0x00000006120e7812ULL, 0x040fe200078e3cffULL, 0x0000000833337824ULL, 0x000fe200078e0202ULL,
0x0000000112027812ULL, 0x000fe200078e3cffULL, 0x0000000841147824ULL, 0x000fe200078e00ffULL,
0x000000240505723eULL, 0x000fe200000010ffULL, 0x0000000403107824ULL, 0x000fc400078e00ffULL,
0x0000000841377824ULL, 0x040fe200078e0202ULL, 0xfffffff814357812ULL, 0x000fe200078ee241ULL,
0x0000000841397824ULL, 0x040fe200078e0206ULL, 0x0000000c101c7812ULL, 0x000fe200078ec0ffULL,
0x00000008413b7824ULL, 0x040fe400078e0208ULL, 0x00000008413d7824ULL, 0x040fe400078e020aULL,
0x00000008413f7824ULL, 0x040fe400078e020cULL, 0x0000000841417824ULL, 0x000fc400078e020eULL,
0x0000001019197824ULL, 0x100fe400078e0204ULL, 0x0000001045067824ULL, 0x100fe400078e0204ULL,
0x000000101b1b7824ULL, 0x100fe400078e0204ULL, 0x000000101d1d7824ULL, 0x100fe400078e0204ULL,
0x000000101f1f7824ULL, 0x100fe400078e0204ULL, 0x0000001035357824ULL, 0x000fc400078e0204ULL,
0x000000011c027824ULL, 0x000fe400078e0219ULL, 0x0000001021217824ULL, 0x100fe400078e0204ULL,
0x0000001023237824ULL, 0x100fe200078e0204ULL, 0x0000003102007388ULL, 0x0003e20000000800ULL,
0x0000001033337824ULL, 0x100fe400078e0204ULL, 0x0000001037377824ULL, 0x100fe400078e0204ULL,
0x0000001039397824ULL, 0x000fc400078e0204ULL, 0x000000103b3b7824ULL, 0x100fe400078e0204ULL,
0x000000103d3d7824ULL, 0x100fe400078e0204ULL, 0x000000103f3f7824ULL, 0x100fe400078e0204ULL,
0x0000001041417824ULL, 0x000fe400078e0204ULL, 0x000000011c107824ULL, 0x040fe400078e0206ULL,
0x000000011c047824ULL, 0x000fc400078e021bULL, 0x000000011c067824ULL, 0x040fe400078e021dULL,
0x000000011c087824ULL, 0x040fe200078e021fULL, 0x0000002f04007388ULL, 0x0005e20000000800ULL,
0x000000011c0a7824ULL, 0x040fe400078e0221ULL, 0x000000011c0c7824ULL, 0x040fe200078e0223ULL,
0x0000002d06007388ULL, 0x0005e20000000800ULL, 0x000000011c0e7824ULL, 0x040fe400078e0233ULL,
0x000000011c127824ULL, 0x040fe200078e0235ULL, 0x0000002b08007388ULL, 0x0005e20000000800ULL,
0x000000011c147824ULL, 0x000fc400078e0237ULL, 0x000000011c027824ULL, 0x042fe200078e0239ULL,
0x000000290a007388ULL, 0x0005e20000000800ULL, 0x000000011c167824ULL, 0x040fe400078e023bULL,
0x000000011c187824ULL, 0x040fe200078e023dULL, 0x000000270c007388ULL, 0x0005e20000000800ULL,
0x000000011c1e7824ULL, 0x040fe400078e0243ULL, 0x000000011c1a7824ULL, 0x040fe200078e023fULL,
0x000000250e007388ULL, 0x0005e20000000800ULL, 0x000000011c1c7824ULL, 0x000fc600078e0241ULL,
0x0000000510007388ULL, 0x0005e80000000800ULL, 0x0000001712007388ULL, 0x0005e80000000800ULL,
0x0000001514007388ULL, 0x0005e80000000800ULL, 0x0000001302007388ULL, 0x0005e80000000800ULL,
0x0000001116007388ULL, 0x0005e80000000800ULL, 0x0000000f18007388ULL, 0x0005e80000000800ULL,
0x0000000d1a007388ULL, 0x0005e80000000800ULL, 0x0000000b1c007388ULL, 0x0005e80000000800ULL,
0x000000071e007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000020030b7810ULL, 0x006fe20007ffe0ffULL, 0x0000000000087919ULL, 0x000e620000002600ULL,
0x00000003ff027819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff067819ULL, 0x008fe2000001160bULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000702047812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000706077812ULL, 0x000fc400078e480bULL, 0x0ffffff804057812ULL, 0x000fe400078ef803ULL,
0x0ffffff807077812ULL, 0x000fe400078ef80bULL, 0x00000007030a7812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x100fe400078e0200ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x000000070b007812ULL, 0x000fe400078ec0ffULL, 0x00a00000050c7984ULL, 0x000ee80000000c00ULL,
0x00a0000007107984ULL, 0x0009620000000c00ULL, 0x0000000808157824ULL, 0x002fc400078e00ffULL,
0x0000000808177824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0xfffffff815027812ULL, 0x000fe400078ee202ULL, 0xfffffff817067812ULL, 0x000fe400078ee206ULL,
0x0000000402087c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL,
0x1ffffff80a077812ULL, 0x010fe200078ef809ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0008027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0006047a11ULL, 0x000fc400078248ffULL, 0x00005b0008037a11ULL, 0x000fe400000f4c03ULL,
0x00005b0006057a11ULL, 0x000fe400008f4c05ULL, 0x1ffffff800097812ULL, 0x000fe200078ef809ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001009047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x008fe8000c101d06ULL, 0x0000001004007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011602ULL,
0xffffffffff387424ULL, 0x000fc800078e00ffULL, 0x0000000205397824ULL, 0x000fca00078e0208ULL,
0x000000063900720cULL, 0x000fda0003f06070ULL, 0x000000020d0a8824ULL, 0x000fc800078e00ffULL,
0x000064000a0a8a24ULL, 0x000fc800078e0239ULL, 0x000060000a0a8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff3c7624ULL, 0x000fe200078e00ffULL,
0x000000060a388981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff3d7624ULL, 0x000fc600078e00ffULL,
0x01060000ff087f8cULL, 0x000e68000c80043fULL, 0x000000063c3c7981ULL, 0x000762000c1e9900ULL,
0x00000001050e7810ULL, 0x040fe20007ffe0ffULL, 0x00000040023a7824ULL, 0x000fe400078e00ffULL,
0x0000008000007824ULL, 0x000fe200078e00ffULL, 0x000000070e00720cULL, 0x000fe20003f06070ULL,
0x00000100050f7824ULL, 0x000fc400078e023aULL, 0x000000803b3b7824ULL, 0x000fc600078e00ffULL,
0x0000004000207812ULL, 0x000fe200078ef80fULL, 0x0000003b38217224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011603ULL,
0x0000000f040a7217ULL, 0x000fe40007800000ULL, 0x000000081d177810ULL, 0x040fe20007ffe0ffULL,
0x000000011d0b7824ULL, 0x140fe200078e0220ULL, 0x000000101d197810ULL, 0x040fe20007ffe0ffULL,
0x000000010a127824ULL, 0x000fe200078e0a0fULL, 0x000000181d237810ULL, 0x000fe20007ffe0ffULL,
0x00000001170a7824ULL, 0x000fe200078e0220ULL, 0x0000000b210b7210ULL, 0x000fc40007f1e0ffULL,
0x000000300c1f7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff147819ULL, 0x100fe20000011603ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005e000b1a7a11ULL, 0x040fe400078040ffULL,
0x0000000314147812ULL, 0x000fe400078e4803ULL, 0x00005f000b157a11ULL, 0x000fe200000f440eULL,
0x00000001190b7824ULL, 0x100fe200078e0220ULL, 0x0000000a21167210ULL, 0x000fe20007f1e0ffULL,
0x00000001230e7824ULL, 0x000fe200078e0220ULL, 0x00002000020c7811ULL, 0x000fc400078e68ffULL,
0x0000000b21117210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x0000000e210e7210ULL, 0x000fe40007f5e0ffULL, 0x00005e0016137a11ULL, 0x040fe200078040ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078240ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00005f0016167a11ULL, 0x000fe200000f440fULL,
0x00000004170f7824ULL, 0x000fe200078e00ffULL, 0x00005f0011117a11ULL, 0x000fc400008f440aULL,
0x00005e000e187a11ULL, 0x040fe400078440ffULL, 0x0000001a1f0a7210ULL, 0x000fe40007f7e0ffULL,
0x000000121d00720cULL, 0x000fe40003f06070ULL, 0x00005f000e1e7a11ULL, 0x000fe200010f440bULL,
0x000000ffff0b7224ULL, 0x000fe200018e0615ULL, 0xfffffffc0f0f7812ULL, 0x000fe400078ee214ULL,
0x0ffffffc14037812ULL, 0x000fc400078ef803ULL, 0x000000121700720cULL, 0x080fe40003f26070ULL,
0x0000001f130e7210ULL, 0x080fe20007f7e0ffULL, 0x000000100f137824ULL, 0x100fe200078e020cULL,
0x000000201d177810ULL, 0x000fe20007ffe0ffULL, 0x0000001003037824ULL, 0x000fe200078e020cULL,
0x0000001f10107210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0616ULL,
0x000000121900720cULL, 0x040fe20003f46070ULL, 0x0000000120167824ULL, 0x000fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a037faeULL, 0x0003e2000c101c46ULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x000000301d1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0611ULL, 0x0000001621167210ULL, 0x000fe20007f1e0ffULL,
0x000000000e137faeULL, 0x0005e2000c901c46ULL, 0x000000122300720cULL, 0x000fc40003f86070ULL,
0xfffffffc19157812ULL, 0x000fe400078ee214ULL, 0x00005e00161a7a11ULL, 0x000fe200078c40ffULL,
0x0000000423037824ULL, 0x002fe200078e00ffULL, 0x0000001f180a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x0000001015157824ULL, 0x000fe200078e020cULL, 0xfffffffc03037812ULL, 0x000fe200078ee214ULL,
0x00000001200f7824ULL, 0x004fe200078e021bULL, 0x00005f00161c7a11ULL, 0x000fe200030f440bULL,
0x000000ffff0b7224ULL, 0x000fe200028e061eULL, 0x0000000010157faeULL, 0x0003e2000d101c46ULL,
0x0000001003037824ULL, 0x000fe200078e020cULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001200e7824ULL, 0x000fe200078e0219ULL, 0x000000121700720cULL, 0x080fe20003f66070ULL,
0x000000041b137824ULL, 0x000fe200078e00ffULL, 0x000000000a037faeULL, 0x0005e2000e101c46ULL,
0x0000000f21187210ULL, 0x000fe20007f9e0ffULL, 0x00000004170f7824ULL, 0x000fe200078e00ffULL,
0x000000121900720cULL, 0x000fc40003f46070ULL, 0x000000121b00720cULL, 0x080fe20003f26070ULL,
0x0000000120107824ULL, 0x002fe200078e021dULL, 0x000000121d00720cULL, 0x000fe20003f06070ULL,
0x0000000419117824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f0f7812ULL, 0x100fe200078ee214ULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000e21127210ULL, 0x000fe40007fbe0ffULL,
0xfffffffc13137812ULL, 0x000fe200078ee214ULL, 0x000000100f037824ULL, 0x004fe200078e020cULL,
0xfffffffc11117812ULL, 0x000fe200078ee214ULL, 0x000000ffff0f7224ULL, 0x000fe200028e06ffULL,
0x00005e00120e7a11ULL, 0x040fe200078a40ffULL, 0x0000001013177824ULL, 0x000fe200078e020cULL,
0xfffffffc1d0b7812ULL, 0x000fe200078ee214ULL, 0x0000001011157824ULL, 0x100fe200078e020cULL,
0x00005f0012137a11ULL, 0x000fe200028f440fULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x0000001021167210ULL, 0x000fe20007fde0ffULL, 0x000000100b197824ULL, 0x000fe200078e020cULL,
0x0000001f1a0a7210ULL, 0x000fc40007fbe0ffULL, 0x00005e0018107a11ULL, 0x000fe200078840ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x00005e0016127a11ULL, 0x000fe200078c40ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e061cULL, 0x0000001f0e0e7210ULL, 0x080fe40007fbe0ffULL,
0x00005f0018117a11ULL, 0x000fe400020f4411ULL, 0x00005f00160c7a11ULL, 0x000fe200030f440fULL,
0x000000ffff0f7224ULL, 0x000fe200028e0613ULL, 0x0000001f10107210ULL, 0x080fe20007f9e0ffULL,
0x000000000a037faeULL, 0x0003e2000d901c46ULL, 0x0000001f12127210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0611ULL, 0x000000000e157faeULL, 0x0003e2000d101c46ULL,
0x000000ffff137224ULL, 0x000fc600028e060cULL, 0x0000000010177faeULL, 0x0003e8000c901c46ULL,
0x0000000012197faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x00000020030a7211ULL, 0x04afe400078ff0ffULL, 0x00000008031b7811ULL, 0x000fe400078ff0ffULL,
0x0000000a210a7210ULL, 0x000fe40007f1e0ffULL, 0x00000018030f7811ULL, 0x000fc400078ff0ffULL,
0x00000003ff1a7819ULL, 0x000fe20000011603ULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005e000a1c7a11ULL, 0x000fe200078040ffULL, 0x0000000120107824ULL, 0x000fe200078e020fULL,
0x0000002003117811ULL, 0x000fe200078ff0ffULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x00005f000a267a11ULL, 0x000fe200000f440bULL, 0x000000011b0a7824ULL, 0x000fe200078e0220ULL,
0x00000010030b7811ULL, 0x040fe200078ff0ffULL, 0x0000000120127824ULL, 0x040fe200078e0211ULL,
0x0000002803137811ULL, 0x000fe200078ff0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x0000003003157811ULL, 0x040fe200078ff0ffULL, 0x00000001200e7824ULL, 0x000fe200078e020bULL,
0x0000003803177811ULL, 0x000fe200078ff0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x000000031a1a7812ULL, 0x000fe200078e4803ULL, 0x00000004131d7824ULL, 0x000fe200078e00ffULL,
0x0000000a21247210ULL, 0x000fe20007fde0ffULL, 0x00000004151f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b0a7812ULL, 0x100fe200078ee21aULL, 0x0000000120187824ULL, 0x000fe200078e0217ULL,
0x00002000021e7811ULL, 0x000fe200078e68ffULL, 0x0000000120147824ULL, 0x040fe200078e0213ULL,
0xfffffffc0f0b7812ULL, 0x100fe200078ee21aULL, 0x0000000120167824ULL, 0x000fe200078e0215ULL,
0x0000001021207210ULL, 0x000fe20007f1e0ffULL, 0x000000041b1b7824ULL, 0x000fe200078e00ffULL,
0x0000001221127210ULL, 0x000fe20007f3e0ffULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x0ffffffc1a157812ULL, 0x000fe200078ef803ULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0xfffffffc1d0f7812ULL, 0x000fe200078ee21aULL, 0x000000100a1d7824ULL, 0x100fe200078e021eULL,
0x0000000e21197210ULL, 0x000fe20007fbe0ffULL, 0x0000001015297824ULL, 0x000fe200078e021eULL,
0xfffffffc1f107812ULL, 0x000fe200078ee21aULL, 0x000000100b1f7824ULL, 0x100fe200078e021eULL,
0x00005e0024227a11ULL, 0x000fe200078c40ffULL, 0x000000100f237824ULL, 0x000fe200078e021eULL,
0xfffffffc110e7812ULL, 0x100fe200078ee21aULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0xfffffffc1b037812ULL, 0x000fe200078ee21aULL, 0x0000001010257824ULL, 0x000fe200078e021eULL,
0xfffffffc17117812ULL, 0x000fe200078ee21aULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x0000001621167210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x0000001821187210ULL, 0x000fe20007f9e0ffULL, 0x0000001003037824ULL, 0x100fe200078e021eULL,
0x00005f0024247a11ULL, 0x000fe200030f4413ULL, 0x0000001011277824ULL, 0x000fe200078e021eULL,
0x00005e0012157a11ULL, 0x000fe200078240ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x00005e0019107a11ULL, 0x000fc400078a40ffULL, 0x00005e0020137a11ULL, 0x000fe400078040ffULL,
0x0000001421147210ULL, 0x000fe20007f5e0ffULL, 0x000000100e217824ULL, 0x000fe200078e021eULL,
0x000000300c287812ULL, 0x000fe400078ec0ffULL, 0x00005f00121e7a11ULL, 0x000fe200008f440bULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0x00005f0019117a11ULL, 0x000fe400028f440aULL,
0x00005f0020207a11ULL, 0x000fe200000f440fULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x00005e00181a7a11ULL, 0x000fc400078640ffULL, 0x0000001c280a7210ULL, 0x000fe40007f1e0ffULL,
0x00005e0014177a11ULL, 0x000fe400078240ffULL, 0x00005e0016197a11ULL, 0x000fe400078440ffULL,
0x00005f00180c7a11ULL, 0x000fe200018f440bULL, 0x000000ffff0b7224ULL, 0x000fe200000e0626ULL,
0x00005f00141c7a11ULL, 0x000fe400008f440fULL, 0x00000022280e7210ULL, 0x000fc40007f1e0ffULL,
0x00005f00161b7a11ULL, 0x000fe200010f441bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a297faeULL, 0x0003e2000b901c46ULL, 0x0000001028107210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0624ULL, 0x0000001328127210ULL, 0x040fe40007f5e0ffULL,
0x0000001528147210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000001728167210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0620ULL,
0x0000001928187210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200018e061eULL,
0x0000001a281a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e061cULL,
0x000000000e037faeULL, 0x0003e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc400028e061bULL,
0x000000ffff1b7224ULL, 0x000fe200000e060cULL, 0x00000000101d7faeULL, 0x0003e8000b901c46ULL,
0x00000000121f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e8000b901c46ULL, 0x0000000018257faeULL, 0x0003e8000b901c46ULL,
0x000000001a277faeULL, 0x0003e4000b901c46ULL, 0x01060400ff037984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000003ff7812ULL, 0x002fc60007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x00000003000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe20003800000ULL, 0x01060400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002002037824ULL, 0x002fc800078e0203ULL,
0x0000002003097824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fc80000011603ULL,
0x1ffffffe08087812ULL, 0x000fe400078ec0ffULL, 0x000001e009097812ULL, 0x000fe400078ec0ffULL,
0x00000001080c7812ULL, 0x040fe400078efcffULL, 0x00000007080a7812ULL, 0x100fe400078e7803ULL,
0x000000070c0c7812ULL, 0x100fe400078e7803ULL, 0x00000010080e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090a7824ULL, 0x040fe200078e020aULL, 0x0000001108087810ULL, 0x000fe20007ffe0ffULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x000000070e0e7812ULL, 0x000fc400078e7803ULL,
0x000000000a147984ULL, 0x000e62000000cc00ULL, 0x0000000708087812ULL, 0x000fe400078e7803ULL,
0x00000001090e7824ULL, 0x040fe200078e020eULL, 0x000000000c107984ULL, 0x000ea4000000cc00ULL,
0x0000000109087824ULL, 0x000fe400078e0208ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff197224ULL, 0x000fc400078e0016ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0017ULL, 0x000000180a007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fca00078e0013ULL,
0x0000001c0c007388ULL, 0x000fe8000000cc00ULL, 0x0000000008107984ULL, 0x000e68000000cc00ULL,
0x000000000e147984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e0012ULL,
0x000000ffff227224ULL, 0x000fc400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff207224ULL, 0x004fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x000000200e007388ULL, 0x0003e8000000cc00ULL, 0x0000001008007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff087f8cULL, 0x002fe8000c80043fULL,
0x01060400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x00000003000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe20003800000ULL, 0x01060400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070500720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x3d8000003c3c7820ULL, 0x020fe20000410000ULL,
0x00010688023d7811ULL, 0x040fe200078e18ffULL, 0x000064000d3e7a24ULL, 0x000fe200078e02ffULL,
0xffffffff07407810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x00010608023f7811ULL, 0x000fe400078e28ffULL, 0x0000010005437824ULL, 0x000fe200078e023aULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000430400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x03cfea0003800000ULL, 0x000000ffff457224ULL, 0x000fe200078e0041ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fc4000001ff00ULL, 0x0000000142297810ULL, 0x000fe20007ffe0ffULL,
0x00000d9000007945ULL, 0x000fe20003800000ULL, 0x0000000145417812ULL, 0x000fe200078e0cffULL,
0x0000003b38477224ULL, 0x020fe200078e02ffULL, 0x00000002ff287819ULL, 0x000fc40000011629ULL,
0x000000042900780cULL, 0x040fe40003f06070ULL, 0x0000000329567812ULL, 0x000fe200078ec0ffULL,
0x00000300282b7a24ULL, 0x000fe400078e0205ULL, 0x000000ffff287224ULL, 0x000fe400078e0042ULL,
0x000001002b337824ULL, 0x040fe200078e023aULL, 0x000000012b2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff427224ULL, 0x000fc600078e0029ULL, 0x000000072a00720cULL, 0x000fe40003f26070ULL,
0x00000040332b7812ULL, 0x000fca00078ec0ffULL, 0x0000000100367824ULL, 0x000fcc00078e022bULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff357819ULL, 0x002fc80000011603ULL,
0x00000010354f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000135297824ULL, 0x140fe200078e0236ULL,
0x0000000835467810ULL, 0x040fe40007ffe0ffULL, 0x0000001835507810ULL, 0x000fe20007ffe0ffULL,
0x000000014f2b7824ULL, 0x100fe200078e0236ULL, 0x0000002947317210ULL, 0x000fe20007f3e0ffULL,
0x00000001462a7824ULL, 0x040fe200078e0236ULL, 0x0000002035517810ULL, 0x000fe20007ffe0ffULL,
0x00000004464d7824ULL, 0x000fe200078e00ffULL, 0x0000002b472f7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff347224ULL, 0x000fe200008e06ffULL, 0x0000002a472d7210ULL, 0x000fc40007f5e0ffULL,
0x00005e00312a7a11ULL, 0x000fe200078240ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005e002f2e7a11ULL, 0x040fe200078640ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x0000003304297217ULL, 0x000fe40007800000ULL, 0x00005f002f2f7a11ULL, 0x000fe200018f4430ULL,
0x0000000150307824ULL, 0x000fe200078e0236ULL, 0x00005e002d2c7a11ULL, 0x000fe200078440ffULL,
0x0000000129297824ULL, 0x000fe200078e0a33ULL, 0x0000002835527810ULL, 0x000fc40007ffe0ffULL,
0x00005f00312b7a11ULL, 0x000fe200008f4434ULL, 0x0000000151317824ULL, 0x100fe200078e0236ULL,
0x0000003035537810ULL, 0x040fe40007ffe0ffULL, 0x0000003835547810ULL, 0x000fe40007ffe0ffULL,
0x0000003047447210ULL, 0x000fe20007f3e0ffULL, 0x0000000153337824ULL, 0x000fe200078e0236ULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4432ULL, 0x0000000152327824ULL, 0x100fe200078e0236ULL,
0x000000293500720cULL, 0x000fe20003f46070ULL, 0x0000000154347824ULL, 0x000fe200078e0236ULL,
0x0000003147367210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200008e06ffULL,
0x00005e0044307a11ULL, 0x000fc400078240ffULL, 0x0000003247357210ULL, 0x040fe40007fde0ffULL,
0x00000003ff327819ULL, 0x000fe40000011603ULL, 0x0000003347377210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff337224ULL, 0x000fe200028e06ffULL, 0x0000003447477210ULL, 0x000fe20007f7e0ffULL,
0x0000000456347824ULL, 0x000fe200078e00ffULL, 0x00005f0044317a11ULL, 0x000fe200008f4431ULL,
0x0000000202447824ULL, 0x000fe200078e0241ULL, 0x00000003324e7812ULL, 0x100fe200078e4803ULL,
0x000000ffff4c7224ULL, 0x000fe200030e06ffULL, 0x000000294600720cULL, 0x000fe20003f26070ULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x0000200044447811ULL, 0x000fe200078e60ffULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x0ffffffc4e4b7812ULL, 0x000fc400078ef803ULL,
0xfffffffc34497812ULL, 0x000fe400078ee203ULL, 0xfffffffc4d4d7812ULL, 0x000fe200078ee24eULL,
0x000000104b4b7824ULL, 0x000fe200078e0244ULL, 0x00005e0036327a11ULL, 0x040fe200078a40ffULL,
0x00000010492a7825ULL, 0x000fe200078e002aULL, 0x00005e0047467a11ULL, 0x000fe400078840ffULL,
0x00005f0036337a11ULL, 0x000fe200028f4433ULL, 0x000000104d4d7824ULL, 0x000fe200078e0244ULL,
0x00005e0035347a11ULL, 0x000fe200078a40ffULL, 0x00000010492c7825ULL, 0x000fe200078e002cULL,
0x00005e0037367a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a4b7faeULL, 0x0003e2000d101c46ULL, 0x00005f0035357a11ULL, 0x000fc400028f444cULL,
0x00005f0037377a11ULL, 0x000fe200018f444aULL, 0x000000002c4d7faeULL, 0x0005e2000c901c46ULL,
0x00005f0047477a11ULL, 0x000fe400020f4448ULL, 0x000000294f00720cULL, 0x080fe40003f26070ULL,
0x000000295000720cULL, 0x080fe40003f46070ULL, 0x000000295100720cULL, 0x0c0fe20003f66070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x000000295200720cULL, 0x0c0fe20003f86070ULL,
0x00000004522b7824ULL, 0x002fe200078e00ffULL, 0x000000295300720cULL, 0x0c0fe20003fa6070ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x000000295400720cULL, 0x000fe20003fc6070ULL,
0x000000044f297824ULL, 0x000fe200078e00ffULL, 0xfffffffc514d7812ULL, 0x104fe200078ee24eULL,
0x00000004504f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc53517812ULL, 0x100fe200078ee24eULL,
0x00000004542d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc29297812ULL, 0x000fe200078ee24eULL,
0x000000104d4d7824ULL, 0x000fe200078e0244ULL, 0xfffffffc4f4b7812ULL, 0x000fe200078ee24eULL,
0x0000001051517824ULL, 0x000fe200078e0244ULL, 0xfffffffc2b4f7812ULL, 0x000fe200078ee24eULL,
0x0000001029297824ULL, 0x000fe200078e0244ULL, 0xfffffffc2d537812ULL, 0x000fe200078ee24eULL,
0x00000010492a7825ULL, 0x000fc800078e002eULL, 0x000000104b4b7824ULL, 0x000fe200078e0244ULL,
0x000000002a297faeULL, 0x0003e2000c901c46ULL, 0x00000010492c7825ULL, 0x000fc800078e0030ULL,
0x00000010492e7825ULL, 0x000fe200078e0032ULL, 0x000000002c4b7faeULL, 0x0003e6000d101c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e0244ULL, 0x000000002e4d7faeULL, 0x0003e2000d901c46ULL,
0x0000001049307825ULL, 0x000fc800078e0034ULL, 0x0000001049327825ULL, 0x000fe200078e0036ULL,
0x00000000304f7faeULL, 0x0003e6000e101c46ULL, 0x0000001053537824ULL, 0x000fe200078e0244ULL,
0x0000000032517faeULL, 0x0003e2000e901c46ULL, 0x0000001049347825ULL, 0x000fca00078e0046ULL,
0x0000000034537faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008032f7811ULL, 0x042fe400078ff0ffULL, 0x0000003603297211ULL, 0x040fe400078ff0ffULL,
0x0000001003317811ULL, 0x000fe200078ff0ffULL, 0x000000012f2a7824ULL, 0x000fe200078e0236ULL,
0x00000029472b7210ULL, 0x000fe20007f3e0ffULL, 0x000000042f4d7824ULL, 0x000fe200078e00ffULL,
0x0000001803337811ULL, 0x000fe200078ff0ffULL, 0x00000004314f7824ULL, 0x000fe200078e00ffULL,
0x0000002a47297210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x00005e002b2a7a11ULL, 0x000fc400078240ffULL, 0x0000002003357811ULL, 0x000fe200078ff0ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x00005e00292c7a11ULL, 0x000fe400078440ffULL,
0x00005f002b2b7a11ULL, 0x000fe200008f4430ULL, 0x00000001352f7824ULL, 0x000fe200078e0236ULL,
0x00005f00292d7a11ULL, 0x000fe200010f442eULL, 0x0000000202297824ULL, 0x000fe200078e0241ULL,
0x00000003ff307819ULL, 0x000fe20000011603ULL, 0x00000001332e7824ULL, 0x000fe200078e0236ULL,
0x0000002803377811ULL, 0x000fe200078ff0ffULL, 0x0000000433337824ULL, 0x000fe200078e00ffULL,
0x0000003003497811ULL, 0x000fe200078ff0ffULL, 0x0000000435357824ULL, 0x000fe200078e00ffULL,
0x00000038034b7811ULL, 0x000fc400078ff0ffULL, 0x0000200029537811ULL, 0x000fe200078e60ffULL,
0x0000000131297824ULL, 0x100fe200078e0236ULL, 0x0000000330347812ULL, 0x000fe200078e4803ULL,
0x0000000137307824ULL, 0x100fe400078e0236ULL, 0x0000000149317824ULL, 0x000fe200078e0236ULL,
0xfffffffc4d487812ULL, 0x000fe200078ee234ULL, 0x000000014b327824ULL, 0x000fe200078e0236ULL,
0x0000002947297210ULL, 0x000fe20007f7e0ffULL, 0x0000000437377824ULL, 0x000fe200078e00ffULL,
0xfffffffc4f4a7812ULL, 0x100fe200078ee234ULL, 0x0000000449497824ULL, 0x000fe200078e00ffULL,
0xfffffffc334c7812ULL, 0x100fe200078ee234ULL, 0x000000044b4b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc354e7812ULL, 0x100fe200078ee234ULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0xfffffffc37507812ULL, 0x000fc400078ee234ULL, 0xfffffffc49527812ULL, 0x100fe200078ee234ULL,
0x000000104a497824ULL, 0x100fe200078e0253ULL, 0xfffffffc4b547812ULL, 0x000fe200078ee234ULL,
0x000000104c4b7824ULL, 0x000fe200078e0253ULL, 0x0ffffffc34467812ULL, 0x000fe200078ef803ULL,
0x000000104e4d7824ULL, 0x100fe200078e0253ULL, 0x0000002e47347210ULL, 0x040fe20007f5e0ffULL,
0x00000010504f7824ULL, 0x100fe200078e0253ULL, 0x0000003247447210ULL, 0x040fe20007fbe0ffULL,
0x0000000456327824ULL, 0x000fe200078e00ffULL, 0x0000002f47337210ULL, 0x040fe20007f3e0ffULL,
0x0000001046577824ULL, 0x100fe200078e0253ULL, 0x0000003147377210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x00005e00292e7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff4c7224ULL, 0x000fe200008e06ffULL, 0x0000003047357210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff477224ULL, 0x000fe200028e06ffULL, 0x00005e0034307a11ULL, 0x000fe200078440ffULL,
0x0000001052517824ULL, 0x100fe200078e0253ULL, 0x00005f00292f7a11ULL, 0x000fe200030f4436ULL,
0x0000001048297824ULL, 0x000fe200078e0253ULL, 0xfffffffc32557812ULL, 0x000fe200078ee203ULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x00005f0034317a11ULL, 0x000fe200010f4431ULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078240ffULL,
0x00000010552a7825ULL, 0x000fe200078e002aULL, 0x00005e0035347a11ULL, 0x000fc400078440ffULL,
0x00005e0037367a11ULL, 0x000fe200078640ffULL, 0x00000010552c7825ULL, 0x000fe200078e002cULL,
0x00005e0044467a11ULL, 0x040fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a577faeULL, 0x0003e2000b901c46ULL, 0x00005f0033337a11ULL, 0x000fe200008f444cULL,
0x00000010552e7825ULL, 0x000fe200078e002eULL, 0x00005f0035357a11ULL, 0x000fe200010f444aULL,
0x000000002c297faeULL, 0x0003e2000b901c46ULL, 0x00005f0037377a11ULL, 0x000fe200018f4448ULL,
0x0000001055307825ULL, 0x040fe200078e0030ULL, 0x00005f0044477a11ULL, 0x000fe200020f4447ULL,
0x000000002e497faeULL, 0x0003e4000b901c46ULL, 0x0000001055327825ULL, 0x000fc400078e0032ULL,
0x00000000304b7faeULL, 0x0003e4000b901c46ULL, 0x0000001055347825ULL, 0x040fe400078e0034ULL,
0x00000000324d7faeULL, 0x0003e4000b901c46ULL, 0x0000001055367825ULL, 0x000fe400078e0036ULL,
0x00000000344f7faeULL, 0x0003e4000b901c46ULL, 0x0000001054537824ULL, 0x000fc400078e0253ULL,
0x0000001055467825ULL, 0x000fe200078e0046ULL, 0x0000000036517faeULL, 0x0003e8000b901c46ULL,
0x0000000046537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035600780cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x00000300ff2a7624ULL, 0x002fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x000000022a397824ULL, 0x000fca00078e0239ULL,
0x000000063900720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000023e2a7824ULL, 0x000fe400078e0239ULL, 0x00000004ff2b7424ULL, 0x000fc800078e00ffULL,
0x000060002a2a7625ULL, 0x000fca00078e002bULL, 0x000000062a387981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008284c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff4b7224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff803287812ULL, 0x000fe200078ec0ffULL,
0x00000002022c7824ULL, 0x000fe200078e0245ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000014b2f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000728287812ULL, 0x000fe400078ef803ULL,
0x000020002c2c7811ULL, 0x000fc400078e60ffULL, 0x00000001ff297819ULL, 0x000fc80000011628ULL,
0x00000003292a7812ULL, 0x000fc800078ec0ffULL, 0x0000004b2a297212ULL, 0x040fe400078e3cffULL,
0x0000002f2a2b7212ULL, 0x000fc600078e3cffULL, 0x0000000428297824ULL, 0x040fe400078e0229ULL,
0x00000004282b7824ULL, 0x000fe200078e022bULL, 0x0000002003287810ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x100fe400078e022cULL, 0x000000102b2b7824ULL, 0x000fe200078e022cULL,
0xfffffff828287812ULL, 0x000fe400078ec0ffULL, 0x000000002934783bULL, 0x000e640000000200ULL,
0x00000007282d7812ULL, 0x000fc400078ef803ULL, 0x000000002b30783bULL, 0x0004e40000000200ULL,
0x00000001ff287819ULL, 0x000fc8000001162dULL, 0x0000000328287812ULL, 0x000fc800078ec0ffULL,
0x0000002f282e7212ULL, 0x000fe400078e3cffULL, 0x00000018ff2a7819ULL, 0x002fe20000011435ULL,
0x0001000034587824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011434ULL,
0x0000003400a07306ULL, 0x000fe20000009400ULL, 0x00000018ff2b7819ULL, 0x004fe20000011436ULL,
0x0001000035597824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff447819ULL, 0x000fc40000011437ULL, 0x00000018ff467819ULL, 0x008fe20000011430ULL,
0x0000002a00a87306ULL, 0x000fe20000209400ULL, 0x00000018ff487819ULL, 0x000fe40000011431ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff4a7819ULL, 0x000fe40000011433ULL,
0x00000018ff497819ULL, 0x000fe20000011432ULL, 0x0000002a00ab7306ULL, 0x000ff00000205400ULL,
0x0000002a00857306ULL, 0x0003f0000020d400ULL, 0x0000002900a27306ULL, 0x000fe20000209400ULL,
0x0000004b282a7212ULL, 0x002fc400078e3cffULL, 0x000000024b4b7810ULL, 0x000fca0007ffe0ffULL,
0x0000002900a77306ULL, 0x000e700000205400ULL, 0x0000002900877306ULL, 0x0004f0000020d400ULL,
0x0000002b00aa7306ULL, 0x000fe20000209400ULL, 0x000000042d297824ULL, 0x044fe200078e022aULL,
0x000000a7a200720bULL, 0x002fe20003fdd000ULL, 0x000000042d2d7824ULL, 0x000fc400078e022eULL,
0x0000001029297824ULL, 0x100fe400078e022cULL, 0x000000102d2d7824ULL, 0x000fe200078e022cULL,
0x0000002b00a97306ULL, 0x000fea0000205400ULL, 0x000000002d2c783bULL, 0x000e640000000200ULL,
0x0000000187876812ULL, 0x008fe200078efcffULL, 0x0000002b00837306ULL, 0x0005f0000020d400ULL,
0x0000003400a17306ULL, 0x000ee20000005400ULL, 0x000000002928783bULL, 0x004eae0000000200ULL,
0x0000003400887306ULL, 0x000870000000d400ULL, 0x0000005800707306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x010fe200078e00ffULL, 0x000000a1a000720bULL, 0x008fc80003f5d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005800bb7306ULL, 0x000ee20000205400ULL,
0x00000018ff737819ULL, 0x002fe4000001142dULL, 0x00000018ff797819ULL, 0x000fca000001142eULL,
0x0000003500a37306ULL, 0x000fe20000009400ULL, 0x00000018ff5f7819ULL, 0x000fe4000001142cULL,
0x00000018ff7a7819ULL, 0x000fe4000001142fULL, 0x0000000188882812ULL, 0x000fc600078efcffULL,
0x0000003500a67306ULL, 0x000e620000005400ULL, 0x000000bb7000720bULL, 0x008fe20003f9d000ULL,
0x0001000028717824ULL, 0x004fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000003500867306ULL, 0x0004f0000000d400ULL, 0x0000003400bd7306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x004fe200078e00ffULL, 0x000000a6a300720bULL, 0x002fc80003fbd000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400ba7306ULL, 0x000e6e0000205400ULL,
0x0000000186865812ULL, 0x008fe200078efcffULL, 0x00000034009c7306ULL, 0x0005e2000020d400ULL,
0x000000a9aa00720bULL, 0x000fce0003fbd000ULL, 0x0000005800997306ULL, 0x000722000020d400ULL,
0x0001000037347824ULL, 0x004fe200078e00ffULL, 0x000000babd00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003600a57306ULL, 0x000fe20000009400ULL,
0x0001000036587824ULL, 0x008fe200078e00ffULL, 0x0000000183835812ULL, 0x000fc800078efcffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003600a47306ULL, 0x000e620000005400ULL,
0x0000000199994812ULL, 0x010fe400078efcffULL, 0x000000019c9c3812ULL, 0x000fe400078efcffULL,
0x000000aba800720bULL, 0x000fc60003f7d000ULL, 0x0000003600847306ULL, 0x0004f0000000d400ULL,
0x0000003500c67306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x0000000185853812ULL, 0x000fc400078efcffULL, 0x000000a4a500720bULL, 0x002fe40003f5d000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003500c97306ULL, 0x000e700000205400ULL,
0x00000035009a7306ULL, 0x000522000020d400ULL, 0x0000000184842812ULL, 0x008fce00078efcffULL,
0x00000037009d7306ULL, 0x000fe20000009400ULL, 0x00000018ff357819ULL, 0x004fe40000011428ULL,
0x000000c9c600720bULL, 0x002fca0003f9d000ULL, 0x00000037009e7306ULL, 0x000e700000005400ULL,
0x0000003700807306ULL, 0x0004e2000000d400ULL, 0x000000019a9a4812ULL, 0x010fce00078efcffULL,
0x0000003500d07306ULL, 0x000fe20000209400ULL, 0x0000010037377824ULL, 0x004fe200078e00ffULL,
0x0000009e9d00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003500d37306ULL, 0x000fee0000205400ULL, 0x0000000180803812ULL, 0x008fe200078efcffULL,
0x0000003500747306ULL, 0x0003f0000020d400ULL, 0x0000003400ce7306ULL, 0x000fe20000209400ULL,
0x0001000030357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400d17306ULL, 0x000e700000205400ULL, 0x00000034009b7306ULL, 0x0004f0000020d400ULL,
0x0000003000917306ULL, 0x000fe20000009400ULL, 0x00000018ff347819ULL, 0x004fc4000001142aULL,
0x000000d1ce00720bULL, 0x002fca0003f9d000ULL, 0x0000003000927306ULL, 0x000ff00000005400ULL,
0x0000003000547306ULL, 0x0003e2000000d400ULL, 0x000000019b9b4812ULL, 0x008fce00078efcffULL,
0x0000003600ca7306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x002fce00078e00ffULL,
0x0000003600cd7306ULL, 0x000ff00000205400ULL, 0x0000003600967306ULL, 0x0003f0000020d400ULL,
0x0000003700d27306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x002fce0000011429ULL,
0x0000003700d57306ULL, 0x000ff00000205400ULL, 0x00000037007d7306ULL, 0x0003f0000020d400ULL,
0x0000003400c77306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x002fce000001142bULL,
0x0000003400c47306ULL, 0x000ff00000205400ULL, 0x00000034006a7306ULL, 0x0003f0000020d400ULL,
0x0000005800c87306ULL, 0x000fe20000209400ULL, 0x0001000031347824ULL, 0x002fce00078e00ffULL,
0x0000005800cb7306ULL, 0x000e700000205400ULL, 0x0000003600cc7306ULL, 0x000ff00000209400ULL,
0x0000003600cf7306ULL, 0x000fe20000205400ULL, 0x000000cbc800720bULL, 0x002fce0003fdd000ULL,
0x00000036006f7306ULL, 0x0003f0000020d400ULL, 0x0000003500be7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fce0000011430ULL, 0x0000003500c17306ULL, 0x000ff00000205400ULL,
0x0000003500617306ULL, 0x0003f0000020d400ULL, 0x0000003700c07306ULL, 0x000fe20000209400ULL,
0x0001000032357824ULL, 0x002fce00078e00ffULL, 0x0000003700c37306ULL, 0x000ff00000205400ULL,
0x0000003700657306ULL, 0x0003f0000020d400ULL, 0x00000031008f7306ULL, 0x000fe20000009400ULL,
0x00000018ff377819ULL, 0x002fe20000011434ULL, 0x0000010031347824ULL, 0x000fcc00078e00ffULL,
0x00000031008a7306ULL, 0x000ff00000005400ULL, 0x0000003100527306ULL, 0x000ff0000000d400ULL,
0x0000003600bc7306ULL, 0x000ff00000209400ULL, 0x0000003600bf7306ULL, 0x000ff00000205400ULL,
0x0000003600307306ULL, 0x0003f0000020d400ULL, 0x0000003700b97306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fe20000011435ULL, 0x0000010032357824ULL, 0x000fcc00078e00ffULL,
0x0000003700b87306ULL, 0x000ff00000205400ULL, 0x0000003700317306ULL, 0x0003f0000020d400ULL,
0x0000005900c57306ULL, 0x000fe20000209400ULL, 0x0001000033377824ULL, 0x002fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe20000011437ULL, 0x0000010033377824ULL, 0x000fe200078e00ffULL,
0x0000005900c27306ULL, 0x000e680000205400ULL, 0x00000018ff5c7819ULL, 0x000fc80000011437ULL,
0x0000005900977306ULL, 0x0005f0000020d400ULL, 0x00000058009f7306ULL, 0x000722000020d400ULL,
0x00000018ff597819ULL, 0x004fe40000011435ULL, 0x000000c2c500720bULL, 0x002fca0003f3d000ULL,
0x0000007100d67306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x008fce0000011434ULL,
0x0000007100d97306ULL, 0x000e620000205400ULL, 0x000000019f9f6812ULL, 0x010fe400078efcffULL,
0x000000d5d200720bULL, 0x000fe40003fdd000ULL, 0x0000000197971812ULL, 0x000fe400078efcffULL,
0x000000cdca00720bULL, 0x000fe20003f3d000ULL, 0x00000033008b7306ULL, 0x000ff00000009400ULL,
0x00000033008e7306ULL, 0x000fe20000005400ULL, 0x000000d9d600720bULL, 0x002fc40003f9d000ULL,
0x000000017d7d6812ULL, 0x000fe400078efcffULL, 0x0000000196961812ULL, 0x000fc600078efcffULL,
0x0000003300507306ULL, 0x000ff0000000d400ULL, 0x0000005800b37306ULL, 0x000ff00000209400ULL,
0x0000005800b47306ULL, 0x000ff00000205400ULL, 0x0000005800347306ULL, 0x000ff0000020d400ULL,
0x0000005900817306ULL, 0x000ff00000209400ULL, 0x0000005900827306ULL, 0x000ff00000205400ULL,
0x0000005900357306ULL, 0x000ff0000020d400ULL, 0x0000005a00757306ULL, 0x000ff00000209400ULL,
0x0000005a00727306ULL, 0x000ff00000205400ULL, 0x0000005a00337306ULL, 0x000ff0000020d400ULL,
0x0000002800b77306ULL, 0x000ff00000009400ULL, 0x0000002800b27306ULL, 0x000e700000005400ULL,
0x00000028006c7306ULL, 0x0004f0000000d400ULL, 0x0000007300587306ULL, 0x000fe20000209400ULL,
0x0000010028287824ULL, 0x004fe200078e00ffULL, 0x000000b2b700720bULL, 0x002fc80003f3d000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000007300597306ULL, 0x000fee0000205400ULL,
0x000000016c6c1812ULL, 0x008fe200078efcffULL, 0x00000073005a7306ULL, 0x0003e2000020d400ULL,
0x000000cfcc00720bULL, 0x000fce0003f3d000ULL, 0x00000071007b7306ULL, 0x0004e2000020d400ULL,
0x0001000029737824ULL, 0x002fca00078e00ffULL, 0x00000018ffd47819ULL, 0x000fe40000011473ULL,
0x0000002900b57306ULL, 0x000fe20000009400ULL, 0x000100002a717824ULL, 0x004fe200078e00ffULL,
0x000000016f6f1812ULL, 0x000fcc00078efcffULL, 0x0000002900b67306ULL, 0x000e620000005400ULL,
0x000000017b7b4812ULL, 0x008fce00078efcffULL, 0x0000002800d87306ULL, 0x000ff00000209400ULL,
0x0000002800db7306ULL, 0x000ea20000205400ULL, 0x000000b6b500720bULL, 0x002fce0003fbd000ULL,
0x000000d400da7306ULL, 0x000ff00000209400ULL, 0x000000d400dd7306ULL, 0x000e620000205400ULL,
0x000000dbd800720bULL, 0x004fce0003fdd000ULL, 0x0000002900697306ULL, 0x0004f0000000d400ULL,
0x0000002a00b17306ULL, 0x000fe20000009400ULL, 0x0000010029297824ULL, 0x004fe200078e00ffULL,
0x000000ddda00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00b07306ULL, 0x000e620000005400ULL, 0x0000000169695812ULL, 0x008fe400078efcffULL,
0x000000c4c700720bULL, 0x000fca0003fbd000ULL, 0x0000002a00647306ULL, 0x0004f0000000d400ULL,
0x0000005c006d7306ULL, 0x000fe20000209400ULL, 0x000001002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000b0b100720bULL, 0x002fc40003f7d000ULL, 0x000000016a6a5812ULL, 0x000fe400078efcffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000005c006e7306ULL, 0x000fe20000205400ULL,
0x000000c1be00720bULL, 0x000fcc0003fbd000ULL, 0x0000000164643812ULL, 0x008fe200078efcffULL,
0x0000005c00377306ULL, 0x000fe2000020d400ULL, 0x000000929100720bULL, 0x000fca0003f7d000ULL,
0x0000000161615812ULL, 0x000fe400078efcffULL, 0x00000079005b7306ULL, 0x000fe20000209400ULL,
0x000000bfbc00720bULL, 0x000fca0003fbd000ULL, 0x0000000154543812ULL, 0x000fe400078efcffULL,
0x00000079005c7306ULL, 0x000fe20000205400ULL, 0x000000b8b900720bULL, 0x000fe40003f7d000ULL,
0x000000546154723eULL, 0x000fc600000010ffULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x00000079005d7306ULL, 0x000fec000020d400ULL, 0x0000000131313812ULL, 0x000fe400078efcffULL,
0x0000002800797306ULL, 0x0002b0000020d400ULL, 0x000000d4007c7306ULL, 0x000722000020d400ULL,
0x00000018ff287819ULL, 0x002fce0000011471ULL, 0x0000002900dc7306ULL, 0x000fe20000209400ULL,
0x000100002bd47824ULL, 0x008fe200078e00ffULL, 0x0000000179796812ULL, 0x004fcc00078efcffULL,
0x0000002900df7306ULL, 0x000e620000205400ULL, 0x000000017c7c4812ULL, 0x010fc800078efcffULL,
0x000000697c7c723eULL, 0x000fc600000010ffULL, 0x0000002a00e07306ULL, 0x000ff00000209400ULL,
0x0000002a00e37306ULL, 0x000ea20000205400ULL, 0x000000dfdc00720bULL, 0x002fce0003fdd000ULL,
0x0000003200907306ULL, 0x000ff00000009400ULL, 0x00000032008d7306ULL, 0x000fe20000005400ULL,
0x000000e3e000720bULL, 0x004fce0003f9d000ULL, 0x0000003200517306ULL, 0x000ff0000000d400ULL,
0x0000003600ac7306ULL, 0x000ff00000209400ULL, 0x0000003600ad7306ULL, 0x000ff00000205400ULL,
0x0000003600327306ULL, 0x000ff0000020d400ULL, 0x0000005f00667306ULL, 0x000ff00000209400ULL,
0x0000005f00677306ULL, 0x000ff00000205400ULL, 0x0000005f00367306ULL, 0x000ff0000020d400ULL,
0x0000007a005e7306ULL, 0x000ff00000209400ULL, 0x0000007a005f7306ULL, 0x000ff00000205400ULL,
0x0000007a00607306ULL, 0x000ff0000020d400ULL, 0x0000004400ae7306ULL, 0x000ff00000209400ULL,
0x0000004400af7306ULL, 0x000e700000205400ULL, 0x00000029007a7306ULL, 0x0004f0000020d400ULL,
0x0000002800de7306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x004fc400000114d4ULL,
0x000000afae00720bULL, 0x002fca0003f5d000ULL, 0x0000002800e17306ULL, 0x000fe20000205400ULL,
0x000000017a7a6812ULL, 0x008fce00078efcffULL, 0x0000002800737306ULL, 0x0003f0000020d400ULL,
0x0000002a00717306ULL, 0x0004e2000020d400ULL, 0x000100002c287824ULL, 0x002fce00078e00ffULL,
0x0000002900d47306ULL, 0x000fe20000209400ULL, 0x00000007032a7812ULL, 0x004fc800078ec0ffULL,
0x000000082aab7812ULL, 0x000fe200078ef803ULL, 0x000100002d2a7824ULL, 0x000fe400078e00ffULL,
0x0000002900d77306ULL, 0x000e620000205400ULL, 0x0000000171714812ULL, 0x008fe400078efcffULL,
0x000000c3c000720bULL, 0x000fe40003f9d000ULL, 0x00000018ffaa7819ULL, 0x000fc6000001142aULL,
0x0000002900707306ULL, 0x0005f0000020d400ULL, 0x0000004400787306ULL, 0x000ee2000020d400ULL,
0x00000018ff297819ULL, 0x004fe40000011428ULL, 0x0000004c03287211ULL, 0x000fc400078fe0ffULL,
0x000000d7d400720bULL, 0x002fe40003fdd000ULL, 0x0000000165654812ULL, 0x000fe200078efcffULL,
0x0000002900a17306ULL, 0x000fe20000209400ULL, 0x000000044c4c7810ULL, 0x000fce0007ffe0ffULL,
0x0000002900a27306ULL, 0x000fe20000205400ULL, 0x0000000178782812ULL, 0x008fe400078efcffULL,
0x000000d3d000720bULL, 0x000fe40003f5d000ULL, 0x0000000170706812ULL, 0x000fe400078efcffULL,
0x0000008a8f00720bULL, 0x000fe20003fdd000ULL, 0x00000029009e7306ULL, 0x0003e2000020d400ULL,
0x000001002f8f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe4000001148fULL,
0x0000002b00957306ULL, 0x000fe20000009400ULL, 0x0000000728297812ULL, 0x042fe400078e78abULL,
0x0000000228287810ULL, 0x000fe40007ffe0ffULL, 0x0000000174742812ULL, 0x000fe200078efcffULL,
0x00000020ab297824ULL, 0x000fe200078e0229ULL, 0x000000e1de00720bULL, 0x000fe20003f5d000ULL,
0x0000002b00987306ULL, 0x000e620000005400ULL, 0x0000000152526812ULL, 0x000fe200078efcffULL,
0x0000001029297824ULL, 0x000fe200078e00ffULL, 0x000000adac00720bULL, 0x000fc40003fdd000ULL,
0x000000797479723eULL, 0x000fe400000010ffULL, 0x000000523152723eULL, 0x000fe200000010ffULL,
0x0000002b00577306ULL, 0x0004e8000000d400ULL, 0x0000000173732812ULL, 0x000fc800078efcffULL,
0x0000004600937306ULL, 0x000fe20000209400ULL, 0x000001002b2b7824ULL, 0x004fe200078e00ffULL,
0x000000989500720bULL, 0x002fe40003f3d000ULL, 0x0000000132326812ULL, 0x000fe400078efcffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000004600947306ULL, 0x000e6e0000205400ULL,
0x0000000157571812ULL, 0x008fe200078efcffULL, 0x0000002c00687306ULL, 0x000fe20000009400ULL,
0x0000008d9000720bULL, 0x000fe20003f3d000ULL, 0x000001002e8d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001148dULL, 0x0000002c006b7306ULL, 0x000ea20000005400ULL,
0x000000949300720bULL, 0x002fca0003f9d000ULL, 0x0000000151511812ULL, 0x000fe400078efcffULL,
0x0000002c004f7306ULL, 0x0002e2000000d400ULL, 0x000000727500720bULL, 0x000fce0003f3d000ULL,
0x0000002b00a77306ULL, 0x000fe20000209400ULL, 0x000001002c2c7824ULL, 0x002fe200078e00ffULL,
0x0000006b6800720bULL, 0x004fc80003fdd000ULL, 0x00000018ffa97819ULL, 0x000fe4000001142cULL,
0x0000002b00a67306ULL, 0x000e620000205400ULL, 0x00000007282c7812ULL, 0x000fe400078e78abULL,
0x0000000133331812ULL, 0x000fc600078efcffULL, 0x00000020aba87824ULL, 0x000fe200078e022cULL,
0x00000088992c723eULL, 0x000fe200000010ffULL, 0x0000002b00a07306ULL, 0x000522000020d400ULL,
0x000000014f4f6812ULL, 0x008fce00078efcffULL, 0x00000046004d7306ULL, 0x000ee2000020d400ULL,
0x000000002928783bULL, 0x004ea20000000200ULL, 0x000000a6a700720bULL, 0x002fcc0003f5d000ULL,
0x00000048008c7306ULL, 0x000fee0000209400ULL, 0x00000001a0a02812ULL, 0x010fe200078efcffULL,
0x0000004800897306ULL, 0x000e620000205400ULL, 0x000000014d4d4812ULL, 0x008fe400078efcffULL,
0x000000b4b300720bULL, 0x000fc40003f9d000ULL, 0x0000008e8b00720bULL, 0x000fe20003f5d000ULL,
0x000100002f8e7824ULL, 0x000fe200078e00ffULL, 0x000000a06565723eULL, 0x000fe200000010ffULL,
0x00000049007f7306ULL, 0x000fe60000209400ULL, 0x00000018ff8e7819ULL, 0x000fca000001148eULL,
0x00000049007e7306ULL, 0x000ee20000205400ULL, 0x000000898c00720bULL, 0x002fe40003fbd000ULL,
0x0000000134344812ULL, 0x000fe400078efcffULL, 0x0000000150502812ULL, 0x000fe400078efcffULL,
0x000000a2a100720bULL, 0x000fe20003f5d000ULL, 0x0000004800477306ULL, 0x000e62000020d400ULL,
0x000000503350723eULL, 0x000fce00000010ffULL, 0x0000004900447306ULL, 0x000f22000020d400ULL,
0x0000007e7f00720bULL, 0x008fc60003f7d000ULL, 0x000000019e9e2812ULL, 0x000fc800078efcffULL,
0x0000004a00777306ULL, 0x000fe20000209400ULL, 0x0000000147475812ULL, 0x002fe400078efcffULL,
0x000000828100720bULL, 0x000fca0003fbd000ULL, 0x0000004a00767306ULL, 0x000e620000205400ULL,
0x0000000144443812ULL, 0x010fe400078efcffULL, 0x0000006e6d00720bULL, 0x000fca0003f7d000ULL,
0x0000002d00637306ULL, 0x000fe20000009400ULL, 0x0000000135355812ULL, 0x000fc800078efcffULL,
0x000000354435723eULL, 0x000fc600000010ffULL, 0x0000002d00627306ULL, 0x000ee20000005400ULL,
0x000000767700720bULL, 0x002fe40003f9d000ULL, 0x0000000137373812ULL, 0x000fe400078efcffULL,
0x000000676600720bULL, 0x000fc60003f7d000ULL, 0x0000002d004e7306ULL, 0x0003f0000000d400ULL,
0x0000004a00467306ULL, 0x000f22000020d400ULL, 0x000001002d2d7824ULL, 0x002fe200078e00ffULL,
0x000000626300720bULL, 0x008fc40003fbd000ULL, 0x000000647362723eULL, 0x000fe400000010ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001142dULL, 0x000000a900a37306ULL, 0x000fe20000209400ULL,
0x0000009c872d723eULL, 0x000fe200000010ffULL, 0x000100002e877824ULL, 0x000fe200078e00ffULL,
0x000000716a63723eULL, 0x000fe400000010ffULL, 0x000000577064723eULL, 0x000fe400000010ffULL,
0x00000018ff877819ULL, 0x000fe20000011487ULL, 0x000000a900a47306ULL, 0x000e620000205400ULL,
0x0000002c280c723cULL, 0x004fe2000004180cULL, 0x0000000146464812ULL, 0x010fc400078efcffULL,
0x0000000136363812ULL, 0x000fe400078efcffULL, 0x000000595800720bULL, 0x000fe40003f7d000ULL,
0x000000aa00a57306ULL, 0x000fe20000209400ULL, 0x00000086972c723eULL, 0x000fe200000010ffULL,
0x000000622814723cULL, 0x040fe20000041814ULL, 0x0000009a852d723eULL, 0x000fe400000010ffULL,
0x000000014e4e5812ULL, 0x000fe400078efcffULL, 0x0000005c5b00720bULL, 0x000fe20003fbd000ULL,
0x000000aa00987306ULL, 0x000ea20000205400ULL, 0x000000a4a300720bULL, 0x002fe20003f9d000ULL,
0x0000002c2808723cULL, 0x000fe20000041808ULL, 0x000000015a5a3812ULL, 0x000fc400078efcffULL,
0x0000004f9e9c723eULL, 0x000fc600000010ffULL, 0x0000002e00567306ULL, 0x000fe20000009400ULL,
0x0000007d782d723eULL, 0x000fe200000010ffULL, 0x000000642810723cULL, 0x040fe20000041810ULL,
0x000000809b2c723eULL, 0x000fe400000010ffULL, 0x0000006c7b78723eULL, 0x000fe400000010ffULL,
0x0000007a6f7d723eULL, 0x000fe200000010ffULL, 0x0000002e00557306ULL, 0x000e620000005400ULL,
0x00000098a500720bULL, 0x004fe20003fdd000ULL, 0x0000002c2820723cULL, 0x000fe20000041820ULL,
0x000000015d5d5812ULL, 0x000fca00078efcffULL, 0x0000002f004a7306ULL, 0x000fe40000009400ULL,
0x00000078281c723cULL, 0x040fec000004181cULL, 0x0000002f00537306ULL, 0x000ea20000005400ULL,
0x000000555600720bULL, 0x002fe20003f3d000ULL, 0x0000007c2818723cULL, 0x000fe20000041818ULL,
0x000000304d55723eULL, 0x000fca00000010ffULL, 0x0000002f00497306ULL, 0x0003f0000000d400ULL,
0x0000002e00487306ULL, 0x000722000000d400ULL, 0x00000096832f723eULL, 0x002fe400000010ffULL,
0x000000534a00720bULL, 0x004fc40003f5d000ULL, 0x000000344753723eULL, 0x000fe400000010ffULL,
0x000000513234723eULL, 0x000fe200000010ffULL, 0x000000a9009d7306ULL, 0x000e62000020d400ULL,
0x000000849f2e723eULL, 0x008fe400000010ffULL, 0x000000374651723eULL, 0x000fca00000010ffULL,
0x000000aa00917306ULL, 0x000ea2000020d400ULL, 0x0000002e2824723cULL, 0x000fe20000041824ULL,
0x0000000148481812ULL, 0x010fe400078efcffULL, 0x0000000149492812ULL, 0x000fc800078efcffULL,
0x0000008a008b7306ULL, 0x000fe20000209400ULL, 0x00000010a82e7824ULL, 0x000fe200078e00ffULL,
0x000000019d9d4812ULL, 0x002fc800078efcffULL, 0x0000009d369d723eULL, 0x000fe200000010ffULL,
0x000000002e2c783bULL, 0x000e620000000200ULL, 0x0000008a00887306ULL, 0x000ee20000205400ULL,
0x0000000191916812ULL, 0x004fc800078efcffULL, 0x0000004e914e723eULL, 0x000fc600000010ffULL,
0x0000008700837306ULL, 0x000ff00000209400ULL, 0x00000087007e7306ULL, 0x000ea20000205400ULL,
0x000000888b00720bULL, 0x008fce0003f9d000ULL, 0x0000008f00297306ULL, 0x000ff00000209400ULL,
0x0000008f002a7306ULL, 0x000ee20000205400ULL, 0x0000007e8300720bULL, 0x004fe20003fdd000ULL,
0x000000542c0c723cULL, 0x042fec000004180cULL, 0x0000008a00857306ULL, 0x000e64000020d400ULL,
0x000000522c08723cULL, 0x040fec0000041808ULL, 0x0000008700777306ULL, 0x000ea2000020d400ULL,
0x0000002a2900720bULL, 0x008fe20003f3d000ULL, 0x000000342c24723cULL, 0x000fec0000041824ULL,
0x0000008d00687306ULL, 0x000fe20000209400ULL, 0x0000000185854812ULL, 0x002fc400078efcffULL,
0x0000005f5e00720bULL, 0x000fe40003f9d000ULL, 0x000000855a4f723eULL, 0x000fe200000010ffULL,
0x000000502c20723cULL, 0x000fe40000041820ULL, 0x0000008d00697306ULL, 0x000e620000205400ULL,
0x0000000177776812ULL, 0x004fc800078efcffULL, 0x00000048775c723eULL, 0x000fe200000010ffULL,
0x0000009c2c1c723cULL, 0x000fe4000004181cULL, 0x0000008e00577306ULL, 0x000fe20000209400ULL,
0x0000000160604812ULL, 0x000fca00078efcffULL, 0x0000004e2c18723cULL, 0x000fe40000041818ULL,
0x0000008e00287306ULL, 0x000ea20000205400ULL, 0x000000696800720bULL, 0x002fce0003f7d000ULL,
0x0000008f008f7306ULL, 0x000e70000020d400ULL, 0x0000008d00567306ULL, 0x000ee2000020d400ULL,
0x000000285700720bULL, 0x004fce0003fdd000ULL, 0x0000008e008e7306ULL, 0x000ea2000020d400ULL,
0x000000018f8f1812ULL, 0x002fe400078efcffULL, 0x000000044b00780cULL, 0x000fe40003f25270ULL,
0x0000008f608f723eULL, 0x000fe400000010ffULL, 0x0000000156563812ULL, 0x008fc800078efcffULL,
0x000000565d5d723eULL, 0x000fe400000010ffULL, 0x000000018e8e6812ULL, 0x004fca00078efcffULL,
0x0000005c2c14723cULL, 0x000fe20000041814ULL, 0x000000498e8e723eULL, 0x000fce00000010ffULL,
0x0000008e2c10723cULL, 0x000fe20000041810ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff457224ULL, 0x000fe200078e0041ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd22000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003d287f8cULL, 0x000fe2000c80043fULL,
0x000000243c247220ULL, 0x040fe40000410000ULL, 0x000000253c257220ULL, 0x040fe20000410000ULL,
0x000004003d2b7984ULL, 0x000e620000000800ULL, 0x000000203c207220ULL, 0x040fe40000410000ULL,
0x0000000e3c2a7220ULL, 0x040fe40000410000ULL, 0x000000263c267220ULL, 0x000fc40000410000ULL,
0x000000273c277220ULL, 0x040fe40000410000ULL, 0x000000213c217220ULL, 0x040fe40000410000ULL,
0x0000000f3c2c7220ULL, 0x040fe40000410000ULL, 0x000000223c2d7220ULL, 0x040fe40000410000ULL,
0x000000233c2e7220ULL, 0x040fe40000410000ULL, 0x0000001e3c2f7220ULL, 0x000fc40000410000ULL,
0x0000001a3c317220ULL, 0x040fe40000410000ULL, 0x0000000c3c0c7220ULL, 0x040fe40000410000ULL,
0x0000000d3c0d7220ULL, 0x040fe40000410000ULL, 0x000000083c087220ULL, 0x040fe40000410000ULL,
0x000000093c097220ULL, 0x040fe40000410000ULL, 0x0000000a3c0a7220ULL, 0x000fc40000410000ULL,
0x0000000b3c0b7220ULL, 0x040fe40000410000ULL, 0x0000001c3c1c7220ULL, 0x040fe40000410000ULL,
0x0000001d3c1d7220ULL, 0x040fe40000410000ULL, 0x0000001f3c307220ULL, 0x040fe40000410000ULL,
0x0000001b3c327220ULL, 0x040fe20000410000ULL, 0x800000002bff7812ULL, 0x002fe20007804829ULL,
0x000000143c1a7220ULL, 0x000fc40000410000ULL, 0x000000163c337220ULL, 0x040fe40000410000ULL,
0x000000173c347220ULL, 0x040fe40000410000ULL, 0x000000123c357220ULL, 0x040fe40000410000ULL,
0x000000133c367220ULL, 0x040fe40000410000ULL, 0x000000153c1b7220ULL, 0x000fe40000410000ULL,
0x000000ffff127224ULL, 0x000fc400078e0024ULL, 0x000000ffff137224ULL, 0x000fe400078e0025ULL,
0x000000ffff147224ULL, 0x000fe400078e0020ULL, 0x000000ffff157224ULL, 0x000fe400078e0021ULL,
0x000000ffff207224ULL, 0x000fe400078e002aULL, 0x000000ffff247224ULL, 0x000fe400078e0026ULL,
0x000000ffff257224ULL, 0x000fc400078e0027ULL, 0x000000103c1e7220ULL, 0x040fe40000410000ULL,
0x000000113c1f7220ULL, 0x000fe40000410000ULL, 0x000000ffff217224ULL, 0x000fe400078e002cULL,
0x000000ffff267224ULL, 0x000fe400078e002dULL, 0x000000ffff277224ULL, 0x000fe400078e002eULL,
0x000000ffff2a7224ULL, 0x000fc400078e002fULL, 0x000000183c187220ULL, 0x040fe40000410000ULL,
0x000000193c197220ULL, 0x000fe40000410000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff107224ULL, 0x000fe400078e0008ULL,
0x000000ffff117224ULL, 0x000fc400078e0009ULL, 0x000000ffff167224ULL, 0x000fe400078e001cULL,
0x000000ffff177224ULL, 0x000fe400078e001dULL, 0x000000ffff227224ULL, 0x000fe400078e000aULL,
0x000000ffff237224ULL, 0x000fe400078e000bULL, 0x000000ffff2b7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2c7224ULL, 0x000fc400078e0031ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0033ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0034ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe400078e0035ULL, 0x000000ffff317224ULL, 0x000fe200078e0036ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x000004003d097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004031d7824ULL, 0x000fe200078e00ffULL, 0x000000400500720cULL, 0x000fc80003f05270ULL,
0xfffffff01d097812ULL, 0x000fca00078ec0ffULL, 0x00000080021c7824ULL, 0x000fca00078e0209ULL,
0x010400001c087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002030c7824ULL, 0x000fe400078e00ffULL, 0x0000000104437824ULL, 0x000fc600078e0a43ULL,
0x000000060c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000010c287812ULL, 0x040fe400078efcffULL,
0x000000080c327812ULL, 0x000fe400078efcffULL, 0x000000432800720cULL, 0x080fe40003f26070ULL,
0x000000100c287812ULL, 0x000fe400078efcffULL, 0x000000433200720cULL, 0x080fe40003f06070ULL,
0x000000432800720cULL, 0x000fc40003fc6070ULL, 0x000000110c327812ULL, 0x040fe400078efcffULL,
0x000000180c287812ULL, 0x040fe400078efcffULL, 0x000000430c00720cULL, 0x080fe40003f46070ULL,
0x000000433200720cULL, 0x080fe40003fa6070ULL, 0x000000432800720cULL, 0x000fe40003f66070ULL,
0x000000090c347812ULL, 0x000fc400078efcffULL, 0x000000190c327812ULL, 0x040fe400078efcffULL,
0x000000200c287812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40005000000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL, 0x000000433400720cULL, 0x080fe40003f86070ULL,
0x000000433200720cULL, 0x080fe40003f46070ULL, 0x000000432800720cULL, 0x000fe40003f26070ULL,
0x000000210c327812ULL, 0x040fe400078efcffULL, 0x000000280c287812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fc40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40004000000ULL,
0xff7fffff23237808ULL, 0x000fe40006000000ULL, 0xff7fffff11117808ULL, 0x000fe40006000000ULL,
0x000000433200720cULL, 0x080fe40003f06070ULL, 0x000000432800720cULL, 0x000fe40003f86070ULL,
0x000000290c327812ULL, 0x000fc400078efcffULL, 0x000000300c287812ULL, 0x000fe400078efcffULL,
0xff7fffff24247808ULL, 0x000fe40007000000ULL, 0xff7fffff12127808ULL, 0x000fe40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40006800000ULL, 0xff7fffff13137808ULL, 0x000fe40006800000ULL,
0x000000433200720cULL, 0x000fc40003fc6070ULL, 0x000000432800720cULL, 0x000fe40003fa6070ULL,
0x000000310c327812ULL, 0x040fe400078efcffULL, 0x000000380c287812ULL, 0x040fe400078efcffULL,
0x000000390c0c7812ULL, 0x000fe400078efcffULL, 0xff7fffff26267808ULL, 0x000fe40005800000ULL,
0xff7fffff14147808ULL, 0x000fc40005800000ULL, 0xff7fffff27277808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff16167808ULL, 0x000fe40004800000ULL, 0x000000433200720cULL, 0x080fe40003f66070ULL,
0x000000432800720cULL, 0x000fc40003f46070ULL, 0x000000430c00720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff17177808ULL, 0x000fe40004000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL, 0xff7fffff18187808ULL, 0x000fe40006000000ULL,
0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL, 0xff7fffff19197808ULL, 0x000fe40007000000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff30307808ULL, 0x000fc40005000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff31317808ULL, 0x000fe40004800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL,
0x0000000f080d7209ULL, 0x004fe40007810000ULL, 0x0000002009087209ULL, 0x000fe40007810000ULL,
0x0000000e0d0d7209ULL, 0x000fe40007810000ULL, 0x0000002108097209ULL, 0x000fc40007810000ULL,
0x000000100d087209ULL, 0x000fe40007810000ULL, 0x00000022090c7209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x000000230c0d7209ULL, 0x000fe40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x000000240d0c7209ULL, 0x000fc40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x000000250c0d7209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x000000260d0c7209ULL, 0x000fe40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x000000270c0d7209ULL, 0x000fc40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000002a0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000002b0c0d7209ULL, 0x000fe40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000002c0d0c7209ULL, 0x000fc40007810000ULL,
0x0000001908097209ULL, 0x000fe40007810000ULL, 0x0000002d0c0d7209ULL, 0x000fe40007810000ULL,
0x0000001a09087209ULL, 0x000fe40007810000ULL, 0x0000002e0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001b08097209ULL, 0x000fe40007810000ULL, 0x0000002f0c0d7209ULL, 0x000fc40007810000ULL,
0x0000001e09087209ULL, 0x000fe40007810000ULL, 0x000000300d0c7209ULL, 0x000fe40007810000ULL,
0x0000001f08097209ULL, 0x000fe40007810000ULL, 0x000000310c337209ULL, 0x000fe20007810000ULL,
0x00001b127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009087f89ULL, 0x0004e400000e0000ULL,
0x0000000809347209ULL, 0x008fe20007810000ULL, 0x00001b627f007947ULL, 0x000fea000b800000ULL,
0x0c401f0033087f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x004ea800000e0000ULL,
0x0c401f000b287f89ULL, 0x000f2200000e0000ULL, 0x00000008330c7209ULL, 0x008fc60007810000ULL,
0x0c201f0034087f89ULL, 0x000ee200000e0000ULL, 0x000000090a0d7209ULL, 0x004fc60007810000ULL,
0x0c201f000c097f89ULL, 0x000ea200000e0000ULL, 0x000000280b287209ULL, 0x010fc60007810000ULL,
0x0c201f000d327f89ULL, 0x002e6800000e0000ULL, 0x0c201f0028297f89ULL, 0x00092200000e0000ULL,
0x0000000834087209ULL, 0x008fe40007810000ULL, 0x000000090c097209ULL, 0x004fe40007810000ULL,
0x000000320d0a7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000fff6d7424ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x0000000f000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b12127823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b13137823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL,
0x0000000e000d7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f0b7823ULL, 0x000fe2000001080bULL,
0x0000000c0d0c723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b091f7820ULL, 0x000fe40000410000ULL,
0x00000004ff337e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001081fULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b22227823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b23237823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081fULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000010110e723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b25257823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001081fULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081fULL, 0x00000022000f7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b30307823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b311f7823ULL, 0x000fe2000001081fULL,
0x0000002300327308ULL, 0x0008a20000000800ULL, 0x3f8000003322783eULL, 0x008fe400000010ffULL,
0x00000020210d723eULL, 0x002fca00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000ffff237224ULL, 0x010fe200078e0022ULL, 0x0000000f320f723eULL, 0x004fcc00000010ffULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x000000220c34723cULL, 0x000fe200000418ffULL,
0x000000121310723eULL, 0x002fcc00000010ffULL, 0x0000001500157308ULL, 0x000e700000000800ULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000141512723eULL, 0x002fce00000010ffULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000242511723eULL, 0x004fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000262713723eULL, 0x002fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000221034723cULL, 0x000fee0000041834ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x004fe400000010ffULL,
0xfffffffc03187812ULL, 0x000fc800078ec0ffULL, 0x000000186d6d7219ULL, 0x000fe200000006ffULL,
0x0000002c002c7308ULL, 0x000fe60000000800ULL, 0x000000006d2073a1ULL, 0x000ea200000e8000ULL,
0x000000006d0473c4ULL, 0x000ee80000004000ULL, 0x0000002d002d7308ULL, 0x000f220000000800ULL,
0x0000002a2b15723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000002c2d17723eULL, 0x010fce00000010ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x000000056dff7c12ULL, 0x004fe2000f804020ULL, 0x000000221434723cULL, 0x000fec0000041834ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000010ffULL, 0x0000002e002e7308ULL, 0x000ff00000000800ULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x0000001e0b1a723eULL, 0x004fe400000010ffULL,
0x00000028290b7209ULL, 0x000fca0007810000ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x0000002e2f19723eULL, 0x002fe400000010ffULL,
0x000000301f1b723eULL, 0x004fce00000010ffULL, 0x000000221834723cULL, 0x000fe20000041834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000175204008947ULL, 0x008fde000b800000ULL,
0x001c1fff34647589ULL, 0x0002a400000e0000ULL, 0x000000006d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000006d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000056dff7c12ULL, 0x008fda000f80401eULL, 0x0000176204008947ULL, 0x010fea000b800000ULL,
0x001c1fff36657589ULL, 0x00072800000e0000ULL, 0x001c1fff66667589ULL, 0x00066800000e0000ULL,
0x001c1fff00677589ULL, 0x0006a400000e0000ULL, 0x00000002ff1e7819ULL, 0x000fe40000011603ULL,
0x0000000c1d357812ULL, 0x000fc400078ec0ffULL, 0x000000071e1f7812ULL, 0x040fe200078ec0ffULL,
0x000000081e247824ULL, 0x040fe200078e00ffULL, 0x0000001eff227212ULL, 0x000fe200078e33ffULL,
0x000000081e207824ULL, 0x040fe200078e00ffULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081e2f7824ULL, 0x040fe200078e00ffULL, 0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff824217812ULL, 0x100fe400078ee21fULL, 0x0000000120237812ULL, 0x100fe200078ef61fULL,
0x000000081e4b7824ULL, 0x000fe200078e00ffULL, 0x0000000220257812ULL, 0x100fe200078ef61fULL,
0x000000081e247824ULL, 0x000fe200078e00ffULL, 0x0000000320277812ULL, 0x000fc400078ef61fULL,
0x0000000420297812ULL, 0x140fe400078ef61fULL, 0x00000005202b7812ULL, 0x140fe400078ef61fULL,
0x00000006202d7812ULL, 0x000fe200078ef61fULL, 0x000000081e207824ULL, 0x040fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee222ULL, 0x0000001eff227212ULL, 0x000fe400078e33ffULL,
0x000000071e1f7812ULL, 0x000fc400078ec0ffULL, 0x0000a000021e7811ULL, 0x000fe400078e58ffULL,
0xfffffff824317812ULL, 0x100fe400078ee21fULL, 0x0000000120337812ULL, 0x140fe200078ef61fULL,
0x00000010211d7824ULL, 0x100fe200078e021eULL, 0x0000000220377812ULL, 0x140fe200078ef61fULL,
0x0000001029247824ULL, 0x100fe200078e021eULL, 0x0000000320437812ULL, 0x040fe200078ef61fULL,
0x00000001351d7824ULL, 0x000fe200078e021dULL, 0x0000000420457812ULL, 0x140fe200078ef61fULL,
0x000000102b267824ULL, 0x100fe200078e021eULL, 0x0000000520477812ULL, 0x140fe200078ef61fULL,
0x000000102d287824ULL, 0x100fe200078e021eULL, 0x0000000620497812ULL, 0x000fe200078ef61fULL,
0x00000010231f7824ULL, 0x000fe200078e021eULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee222ULL,
0x0000001025207824ULL, 0x100fe200078e021eULL, 0x0000000c1d007388ULL, 0x0007e20000000800ULL,
0x0000001027227824ULL, 0x000fc400078e021eULL, 0x00000001351f7824ULL, 0x040fe400078e021fULL,
0x0000000135217824ULL, 0x000fe400078e0220ULL, 0x000000102f2a7824ULL, 0x000fe200078e021eULL,
0x0000000e1f007388ULL, 0x0009e20000000800ULL, 0x0000000135237824ULL, 0x000fe400078e0222ULL,
0x00000010312c7824ULL, 0x000fe200078e021eULL, 0x0000001021007388ULL, 0x0009e20000000800ULL,
0x0000000135257824ULL, 0x000fc400078e0224ULL, 0x00000010332d7824ULL, 0x000fe200078e021eULL,
0x0000001223007388ULL, 0x0009e20000000800ULL, 0x0000000135277824ULL, 0x000fe400078e0226ULL,
0x00000010372e7824ULL, 0x000fe200078e021eULL, 0x0000001425007388ULL, 0x0009e20000000800ULL,
0x0000000135297824ULL, 0x000fe400078e0228ULL, 0x00000010432f7824ULL, 0x000fe200078e021eULL,
0x0000001627007388ULL, 0x0009e20000000800ULL, 0x00000001352b7824ULL, 0x000fc400078e022aULL,
0x0000001045307824ULL, 0x100fe200078e021eULL, 0x0000001829007388ULL, 0x0009e20000000800ULL,
0x0000001047317824ULL, 0x100fe400078e021eULL, 0x0000001049327824ULL, 0x100fe200078e021eULL,
0x0000001a2b007388ULL, 0x0009e20000000800ULL, 0x000000104b337824ULL, 0x000fe400078e021eULL,
0x00000001352c7824ULL, 0x040fe400078e022cULL, 0x00000001351e7824ULL, 0x000fc400078e022dULL,
0x00000001352e7824ULL, 0x040fe200078e022eULL, 0x0000000d2c007388ULL, 0x0009e20000000800ULL,
0x00000001350c7824ULL, 0x048fe400078e022fULL, 0x0000000135307824ULL, 0x040fe200078e0230ULL,
0x0000000f1e007388ULL, 0x0009e20000000800ULL, 0x0000000135207824ULL, 0x040fe400078e0231ULL,
0x0000000135327824ULL, 0x040fe200078e0232ULL, 0x000000112e007388ULL, 0x0009e20000000800ULL,
0x0000000135227824ULL, 0x000fc600078e0233ULL, 0x000000130c007388ULL, 0x0009e80000000800ULL,
0x0000001530007388ULL, 0x0009e80000000800ULL, 0x0000001720007388ULL, 0x0009e80000000800ULL,
0x0000001932007388ULL, 0x0009e80000000800ULL, 0x0000001b22007388ULL, 0x0009e80000000800ULL,
0x010000081c008388ULL, 0x0009e80000000c00ULL, 0x010200641c008388ULL, 0x0163e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003fff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008003fff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010003fff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030005057a10ULL, 0x000fe20007ffe0ffULL,
0x000018003fff7f8cULL, 0x0003e6000c80043fULL, 0x000000070500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb69000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff2c7807ULL, 0x008fe20004800000ULL,
0xffffffffff2d7424ULL, 0x000fe200078e00ffULL, 0x0001e7b000317802ULL, 0x000fe40000000f00ULL,
0x0000130000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0030ULL,
0xfffe2f7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2c7807ULL, 0x000fe20004800000ULL,
0xffffffffff2d7424ULL, 0x000fe200078e00ffULL, 0x0001e81000317802ULL, 0x000fe40000000f00ULL,
0x000012a000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0030ULL,
0xfffe2f9000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001e87000467802ULL, 0x000fe20000000f00ULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000120000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0067ULL,
0xfffe2fd000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001e8d000467802ULL, 0x000fe20000000f00ULL, 0xffffffffff6d7424ULL, 0x000fc400078e00ffULL,
0x000011a000007944ULL, 0x01cfea0003c00000ULL, 0xfffe2fb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x000fe200078e00f7ULL, 0x0001e93000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000114000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff717224ULL, 0x004fe200078e0067ULL,
0xfffe332000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL,
0x0001e9a000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x000010d000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff707224ULL, 0x004fe200078e0067ULL, 0xfffe32e000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0001ea0000467802ULL, 0x000fe20000000f00ULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x0000107000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff9f7224ULL, 0x004fe200078e0067ULL, 0xfffe590000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL, 0x0001ea7000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000100000007944ULL, 0x004fea0003c00000ULL, 0x000000ffffa07224ULL, 0x004fe200078e0067ULL,
0xfffe58b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2c7807ULL, 0x008fe20004800000ULL,
0xffffffffff2d7424ULL, 0x000fe200078e00ffULL, 0x0001ead000317802ULL, 0x000fe40000000f00ULL,
0x00000fe000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0030ULL,
0xfffe7f2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2c7807ULL, 0x000fe20004800000ULL,
0xffffffffff2d7424ULL, 0x000fe200078e00ffULL, 0x0001eb3000317802ULL, 0x000fe40000000f00ULL,
0x00000f8000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0030ULL,
0xfffe7f4000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6a7424ULL, 0x002fe200078e00ffULL,
0x0001eb9000467802ULL, 0x000fe20000000f00ULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x00000ee000007944ULL, 0x034fea0003c00000ULL, 0xfffe7fa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL, 0x0001ebf000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x00000e8000007944ULL, 0x030fea0003c00000ULL, 0xfffe806000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0001ec4000467802ULL, 0x000fe20000000f00ULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00000e3000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff747224ULL, 0x004fe200078e0067ULL, 0xfffe82c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL, 0x0001ecb000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x00000dc000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff6b7224ULL, 0x004fe200078e0067ULL,
0xfffe827000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001ed1000467802ULL, 0x000fe20000000f00ULL, 0xffffffffff6d7424ULL, 0x000fc400078e00ffULL,
0x00000d6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffffad7224ULL, 0x004fe200078e0067ULL,
0xfffea6e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL,
0x0001ed8000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00000cf000007944ULL, 0x004fea0003c00000ULL,
0x000000ffffae7224ULL, 0x004fe200078e0067ULL, 0xfffea69000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2c7807ULL, 0x008fe20004800000ULL, 0xffffffffff2d7424ULL, 0x000fe200078e00ffULL,
0x0001ede000317802ULL, 0x000fe40000000f00ULL, 0x00000cd000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0030ULL, 0xfffecb9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff2c7807ULL, 0x000fe20004800000ULL, 0xffffffffff2d7424ULL, 0x000fe200078e00ffULL,
0x0001ee4000317802ULL, 0x000fe40000000f00ULL, 0x00000c7000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0030ULL, 0xfffecbb000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6a7424ULL, 0x002fe200078e00ffULL, 0x0001eea000467802ULL, 0x000fe20000000f00ULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00000bd000007944ULL, 0x014fea0003c00000ULL,
0xfffecc1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL,
0x0001ef0000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00000b7000007944ULL, 0x010fea0003c00000ULL,
0xfffeccd000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001ef5000467802ULL, 0x000fe20000000f00ULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x00000b2000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff717224ULL, 0x004fe200078e0067ULL,
0xfffecf3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL,
0x0001efc000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x00000ab000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff697224ULL, 0x004fe200078e0067ULL, 0xfffecee000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0001f02000467802ULL, 0x000fe20000000f00ULL,
0xffffffffff6d7424ULL, 0x000fc400078e00ffULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffffad7224ULL, 0x004fe200078e0067ULL, 0xfffef32000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL, 0x0001f09000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x000009e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffffac7224ULL, 0x004fe200078e0067ULL,
0xfffef2d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2c7807ULL, 0x008fe20004800000ULL,
0xffffffffff2d7424ULL, 0x000fe200078e00ffULL, 0x0001f0f000317802ULL, 0x000fe40000000f00ULL,
0x000009c000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff117224ULL, 0x000fe200078e0030ULL,
0xffff18b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff2c7807ULL, 0x000fe20004800000ULL,
0xffffffffff2d7424ULL, 0x000fe200078e00ffULL, 0x0001f15000317802ULL, 0x000fe40000000f00ULL,
0x0000096000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff117224ULL, 0x000fe200078e0030ULL,
0xffff18d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6a7424ULL, 0x004fe200078e00ffULL,
0x0001f1b000467802ULL, 0x000fe20000000f00ULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x000008c000007944ULL, 0x032fea0003c00000ULL, 0xffff193000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL, 0x0001f21000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000086000007944ULL, 0x030fea0003c00000ULL, 0xffff19f000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0001f26000467802ULL, 0x000fe20000000f00ULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x0000081000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff4d7224ULL, 0x004fe200078e0067ULL, 0xffff1c5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL, 0x0001f2d000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x000007a000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e0067ULL,
0xffff1c0000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001f33000467802ULL, 0x000fe20000000f00ULL, 0xffffffffff6d7424ULL, 0x000fc400078e00ffULL,
0x0000074000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0067ULL,
0xffff407000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6f7224ULL, 0x002fe200078e00f4ULL,
0x0001f3a000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6d7424ULL, 0x000fe400078e00ffULL, 0x000006d000007944ULL, 0x004fea0003c00000ULL,
0x000000fffff47224ULL, 0x004fe200078e0067ULL, 0xffff402000007947ULL, 0x000fea000383ffffULL,
0x000000ffff297224ULL, 0x000fe200078e0009ULL, 0x0001f420000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000061000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0029ULL, 0xffffe48000007947ULL, 0x000fea000383ffffULL,
0x000000ffff297224ULL, 0x000fe200078e0033ULL, 0x0001f4a0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000059000007944ULL, 0x024fea0003c00000ULL,
0x0000002933367209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e000aULL,
0x0001f510000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x000000290a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e000bULL, 0x0001f580000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x000000290b287209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0034ULL,
0x0001f5f0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000002934087209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0036ULL, 0x0001f660000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000002936097209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e000aULL,
0x0001f6d0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000290a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0028ULL, 0x0001f740000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0xffffe26000007947ULL, 0x000fea000383ffffULL, 0x000000ffff687224ULL, 0x000fe200078e0034ULL,
0x0001f7a000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff6f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff6a7424ULL, 0x000fe400078e00ffULL, 0x000002d000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff647224ULL, 0x004fe200078e0067ULL, 0xffffe85000007947ULL, 0x000fea000383ffffULL,
0x000000ffff687224ULL, 0x002fe200078e0036ULL, 0x0001f81000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff6f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6a7424ULL, 0x000fc400078e00ffULL,
0x0000026000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff6f7224ULL, 0x002fe200078e00ffULL,
0x0001f86000467802ULL, 0x000fe20000000f00ULL, 0x00001c1fff6a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff657224ULL, 0x004fe400078e0067ULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6f7224ULL, 0x002fe200078e00ffULL, 0x0001f8b000467802ULL, 0x000fe20000000f00ULL,
0x00001c1fff6a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff667224ULL, 0x004fe400078e0067ULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xffffe7d000007947ULL, 0x000fea000383ffffULL,
0x0180000033037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003300038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff067807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000306ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff33ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000033057812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000306ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003300037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff1b7424ULL, 0x000fc800078e00ffULL,
0xfffe05d01a007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000004200007348ULL, 0x000fe80003800000ULL, 0x0c00003229297389ULL, 0x0002a200000e0035ULL,
0xfffe05900c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff477424ULL, 0x000fe200078e00ffULL,
0x0000006d00007348ULL, 0x000fe80003800000ULL, 0x0000006f68677389ULL, 0x0002a200000e006aULL,
0xfffe055046007950ULL, 0x000fea0003c3ffffULL, 0x000000012c00780cULL, 0x000fe20003f25070ULL,
0x0000002d00007348ULL, 0x000fd80003800000ULL, 0x00000000002c7806ULL, 0x000fc800048e0100ULL,
0x0000002d2c307212ULL, 0x000fe200078ec0ffULL, 0x000000ffff2c7224ULL, 0x000fe400078e0031ULL,
0x00000000ff2d7424ULL, 0x000fc800078e00ffULL, 0xfffe04e02c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000460ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a40ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ad0ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001660ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001690ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000016b0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001740ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001748ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001758ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001980ULL, 0x000000000001fc00ULL, 0xfd00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021580ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000021590ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021590ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000021a10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001740ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001fe40ULL, 0x000000000001fe40ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000021580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000021a10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 137968;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
