/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016c78ULL, 0x00000000000167f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000015530ULL, 0x0000000000000250ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000015780ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001553000000000ULL, 0x0000480400000000ULL, 0x0400288080810c00ULL, 0x00000000000054f8ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x88082880809f0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808088920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL,
0x0000006800000000ULL, 0x0001553000000000ULL, 0x0000025000000000ULL, 0x0000580400000000ULL,
0x808a288080820900ULL, 0x0900000004042880ULL, 0x2880808228808088ULL, 0x0000000e00082f04ULL,
0x0008120400000080ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000eULL, 0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000007c00043704ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x00801b0380005003ULL, 0x000144e000103104ULL, 0x00014500000144f0ULL,
0x00f0290400014510ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffff05000000ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000023ffffffffULL, 0x0500002205000022ULL,
0x0500002305000023ULL, 0x0500001f05000023ULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL,
0x0500001f0500001fULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL, 0x000000a000f02804ULL,
0x00001ff0000000f0ULL, 0x0000210000002090ULL, 0x000024d000002130ULL, 0x00004a10000025f0ULL,
0x00004af000004a80ULL, 0x00004e1000004b20ULL, 0x0000648000004e30ULL, 0x000072a000007230ULL,
0x0000734000007310ULL, 0x00007700000076c0ULL, 0x00009950000098e0ULL, 0x000099f0000099c0ULL,
0x00009e4000009d50ULL, 0x0000bb700000bb60ULL, 0x0000df000000c2e0ULL, 0x0000e4800000df30ULL,
0x0000e9100000e4a0ULL, 0x00013e0000013df0ULL, 0x00013e2000013e10ULL, 0x00013e7000013e50ULL,
0x00013ea000013e90ULL, 0x000144f0000144d0ULL, 0x0001454000014500ULL, 0x0001456000014550ULL,
0x000150d000015040ULL, 0x0001519000015130ULL, 0x0001526000015200ULL, 0x00015320000152c0ULL,
0x00015450000153b0ULL, 0x03d03904000154f0ULL, 0x000000ff00000170ULL, 0x000401000001c600ULL,
0x0000000400000250ULL, 0x003f01000001c608ULL, 0x00000004000002c0ULL, 0x003f01000001c610ULL,
0x00000003000004b0ULL, 0x003f01000001c648ULL, 0x000000ff000005b0ULL, 0x000401000001c658ULL,
0x000000ff00000990ULL, 0x000401070001c600ULL, 0x0000000700000b40ULL, 0x003f01010001c610ULL,
0x00000004000012e0ULL, 0x003f01070001c648ULL, 0x0000000400001310ULL, 0x003f01010001c658ULL,
0x00000004000015d0ULL, 0x003f01060001c658ULL, 0x0000000400001850ULL, 0x003f010a0001c658ULL,
0x000000ff00001e50ULL, 0x0008010700000000ULL, 0x0000002600001ed0ULL, 0x003f010600000000ULL,
0x0000000400001f20ULL, 0x003f010a0001c608ULL, 0x0000002600002390ULL, 0x003f010a00000000ULL,
0x00000004000042a0ULL, 0x003f01010001c658ULL, 0x00000004000042d0ULL, 0x003f01010001c610ULL,
0x0000000400004420ULL, 0x003f01060001c658ULL, 0x0000000400004630ULL, 0x003f010a0001c658ULL,
0x0000006c00004930ULL, 0x0007010700000000ULL, 0x000000ff00004960ULL, 0x0008010600000000ULL,
0x0000000400004970ULL, 0x003f010a0001c618ULL, 0x0000002300004d90ULL, 0x003f010a0001c648ULL,
0x0000000400006690ULL, 0x003f01010001c658ULL, 0x00000004000066b0ULL, 0x003f01010001c620ULL,
0x0000000400006bd0ULL, 0x003f01060001c658ULL, 0x0000000400006cd0ULL, 0x003f010a0001c658ULL,
0x000000ff00007150ULL, 0x0008010700000000ULL, 0x0000006c000071b0ULL, 0x0007010600000000ULL,
0x00000004000071c0ULL, 0x003f010a0001c628ULL, 0x00000022000075c0ULL, 0x003f010a0001c648ULL,
0x0000000400008ed0ULL, 0x003f01010001c658ULL, 0x0000000400008f00ULL, 0x003f01010001c630ULL,
0x0000000400009380ULL, 0x003f01060001c658ULL, 0x0000000400009520ULL, 0x003f010a0001c658ULL,
0x0000006c00009840ULL, 0x0007010700000000ULL, 0x000000ff00009870ULL, 0x0008010600000000ULL,
0x0000000400009880ULL, 0x003f010a0001c638ULL, 0x0000002300009c60ULL, 0x003f010a0001c648ULL,
0x000000040000b220ULL, 0x003f01010001c658ULL, 0x000000040000b250ULL, 0x003f01010001c640ULL,
0x0000000800010790ULL, 0x003f010a0001c600ULL, 0x0000000800010aa0ULL, 0x003f01010001c600ULL,
0x0000000800010ac0ULL, 0x003f010a0001c600ULL, 0x0000000a000135a0ULL, 0x003f010a0001c610ULL,
0x0000000a00014860ULL, 0x003f01010001c608ULL, 0x00000004000148a0ULL, 0x003f010a0001c658ULL,
0x0000000400014920ULL, 0x003f010a0001c608ULL, 0x00000026000149a0ULL, 0x003f010a00000000ULL,
0x0000000400014a20ULL, 0x003f010a0001c658ULL, 0x0000000400014aa0ULL, 0x003f010a0001c618ULL,
0x0000002300014b20ULL, 0x003f010a0001c648ULL, 0x0000000400014ba0ULL, 0x003f010a0001c658ULL,
0x0000000400014c20ULL, 0x003f010a0001c628ULL, 0x0000002200014ca0ULL, 0x003f010a0001c648ULL,
0x0000000400014d20ULL, 0x003f010a0001c658ULL, 0x0000000400014da0ULL, 0x003f010a0001c638ULL,
0x0000002300014e20ULL, 0x003f010a0001c648ULL, 0x0000000800014e80ULL, 0x003f010a0001c600ULL,
0x0000000800014f00ULL, 0x003f010a0001c600ULL, 0x0000000a00014f80ULL, 0x003f010a0001c610ULL,
0x00101c0400053803ULL, 0x00010ae00000ed50ULL, 0x0001488000010b80ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400581903ULL, 0x005802100000000fULL,
0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL, 0x00000000000000d4ULL,
0x0000000e00000002ULL, 0x0000000000015530ULL, 0x0000000000000044ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x00000000000000aaULL, 0x0000000e00000002ULL, 0x0000000000000000ULL,
0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000c7919ULL, 0x000eae0000002300ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x0000000000057919ULL, 0x000f2a0000002100ULL,
0x00000300ff007b82ULL, 0x000f620000000800ULL, 0x00000000000d7919ULL, 0x000f620000002700ULL,
0x0000000000177919ULL, 0x000f620000002600ULL, 0x000000010c027824ULL, 0x004fc400078e0203ULL,
0x00001fff0c0c7589ULL, 0x000ea400000e0000ULL, 0x0000008002037824ULL, 0x110fe200078e0205ULL,
0x00000005ff0e7819ULL, 0x000fe20000011605ULL, 0x00000004ff027e24ULL, 0x008fc6000f8e00ffULL,
0x000000ff0300720cULL, 0x040fe40003f45270ULL, 0x00001fff0e0e7589ULL, 0x000ee200000e0000ULL,
0x000000030300780cULL, 0x000fd40003f04070ULL, 0x0000000000242947ULL, 0x022fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01c60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001a000007945ULL, 0x000fe80003800000ULL, 0x0000000000600947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7fff000000057882ULL, 0x000fc60000000000ULL, 0x0000000403047c11ULL, 0x000fe2000f8e20ffULL,
0x001fffc000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000040612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f640000000000ULL,
0x01c60804063f75b2ULL, 0x0103700008000100ULL, 0xfffffffd00e81947ULL, 0x020fea000393ffffULL,
0x0000000000007918ULL, 0x010fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001fff0000047882ULL, 0x002fe20000000000ULL, 0x7ffc000000057882ULL, 0x000fd60000000000ULL,
0x00000000040612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f640000000000ULL,
0x01c61004063f75b2ULL, 0x0103700008000100ULL, 0xfffffffd00e81947ULL, 0x020fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000007f0300780cULL, 0x040fe20003f04070ULL,
0x00008e00ff107b82ULL, 0x000f620000000a00ULL, 0x000000010300780cULL, 0x000fe20003f24070ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x000000ff0c00720cULL, 0x004fd20003f65270ULL,
0x0000000000058919ULL, 0x000ea20000008800ULL, 0x0000040000048802ULL, 0x000fe20000000f00ULL,
0x000000040d107825ULL, 0x020fc600078e0010ULL, 0x0000065405048816ULL, 0x004fe20000000004ULL,
0xff317217ff058424ULL, 0x000fc800078e00ffULL, 0x0000000403048824ULL, 0x000fca00078e0204ULL,
0x01c4000504008388ULL, 0x0005e20000000800ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000403037c11ULL, 0x000fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x014fca0000000000ULL,
0x00000000030612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x01c64804063f75b2ULL, 0x0043300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00008200000c7ab9ULL, 0x000fe20000000a00ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x014fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01c65806043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x014fec0000010000ULL, 0x0000840000067ab9ULL, 0x002fe20000000800ULL,
0x0000000000e83947ULL, 0x000fea0003800000ULL, 0x0000000000127919ULL, 0x000e620000000000ULL,
0x000000040e037824ULL, 0x008fe200078e00ffULL, 0x00008800ff0a7b82ULL, 0x000ea20000000a00ULL,
0x0000000406047899ULL, 0x000fe2000800063fULL, 0x0000001017047824ULL, 0x000fcc00078e00ffULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000000312067211ULL, 0x042fe200078fd8ffULL,
0x000000040d037c24ULL, 0x000fe2000f8e0204ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x0000001012047824ULL, 0x000fe200078e00ffULL, 0x0000000706057812ULL, 0x040fe200078ec0ffULL,
0x0000000306167836ULL, 0x040fe20000000000ULL, 0x0000065405047896ULL, 0x008fe20008000004ULL,
0x0000000106087836ULL, 0x040fe20000000000ULL, 0x0000001f05057812ULL, 0x000fe200078e7812ULL,
0x0000000206147836ULL, 0x000fe20000000000ULL, 0x00000007160f7812ULL, 0x000fc400078ec0ffULL,
0x0000000708077812ULL, 0x000fe400078ec0ffULL, 0x0000000714097812ULL, 0x000fe400078ec0ffULL,
0x0000001f0f157812ULL, 0x000fe200078e7812ULL, 0x00000020060f7824ULL, 0x000fe200078e0205ULL,
0x0000001f07077812ULL, 0x000fe200078e7812ULL, 0x0000000103057824ULL, 0x000fe200078e0206ULL,
0x0000001f09097812ULL, 0x000fe200078e7812ULL, 0x0000002016157824ULL, 0x000fe200078e0215ULL,
0x000001f004197812ULL, 0x000fe200078ec0ffULL, 0x0000002008127824ULL, 0x000fe200078e0207ULL,
0x000000040f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020005047825ULL, 0x004fe200078e000aULL,
0x0000000415157c11ULL, 0x000fc6000f8e20ffULL, 0x0000000103077824ULL, 0x040fe200078e0208ULL,
0x0000001904047210ULL, 0x000fe20007f1e0ffULL, 0x0000002014137824ULL, 0x000fe400078e0209ULL,
0x0000000103097824ULL, 0x040fe400078e0214ULL, 0x0000000103037824ULL, 0x000fe200078e0216ULL,
0x0000000413137c11ULL, 0x000fe2000f8e20ffULL, 0x0000020007067825ULL, 0x000fc800078e000aULL,
0x0000020009087825ULL, 0x000fe200078e000aULL, 0x0000001906067210ULL, 0x000fc60007f3e0ffULL,
0x00000200030a7825ULL, 0x000fe200078e000aULL, 0x0000000412037c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000001908087210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x000000190a0a7210ULL, 0x000fe40007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000b901c4cULL,
0x000000ffff097224ULL, 0x000fe400000e0609ULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000006037faeULL, 0x0003e8000b901c4cULL, 0x0000000008137faeULL, 0x0003e8000b901c4cULL,
0x000000000a157faeULL, 0x0003e2000b901c4cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0001c60004047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0000000c10107981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0c00720cULL, 0x000fe40003f05270ULL, 0x00000000100b72caULL, 0x004fda00000e0000ULL,
0x0000007f0b047890ULL, 0x000fe4000fffe03fULL, 0x000000ff0b057890ULL, 0x000fe4000fffe03fULL,
0x000000073f047899ULL, 0x000fe40008011604ULL, 0x000000083f057899ULL, 0x000fe20008011605ULL,
0x000000e000c48947ULL, 0x000ff60003800000ULL, 0x0000000202037824ULL, 0x000fe200078e00ffULL,
0x00000000000b7919ULL, 0x000ea20000008800ULL, 0x00000400000a7802ULL, 0x000fc60000000f00ULL,
0x0000000403007c0cULL, 0x000fda000bf06070ULL, 0x00009000ff068b82ULL, 0x000f220000000800ULL,
0x000000020d048824ULL, 0x000fce00078e00ffULL, 0x00008c00ff088b82ULL, 0x000f620000000a00ULL,
0x0000000103058824ULL, 0x010fc800078e0206ULL, 0x0000000604078224ULL, 0x000fe200078e0205ULL,
0x000006540b047816ULL, 0x004fe2000000000aULL, 0x000000100e057824ULL, 0x008fe400078e00ffULL,
0x0000000407088825ULL, 0x020fc800078e0008ULL, 0xffffffffff067424ULL, 0x000fe400078e00ffULL,
0x00000004ff0a7424ULL, 0x000fe400078e00ffULL, 0x0000000104077824ULL, 0x000fc800078e0205ULL,
0x01c6100a07ff79a7ULL, 0x0005e2000850003fULL, 0x0000000c08068981ULL, 0x000722000c1e1900ULL,
0x00000100020f7824ULL, 0x040fe200078e00ffULL, 0x0000000706067899ULL, 0x000fe2000800063fULL,
0x00000001020c7836ULL, 0x000fe20000000000ULL, 0x00000000040772caULL, 0x040fe200000e0000ULL,
0x00014000041a7836ULL, 0x000fe20000000000ULL, 0x0000000b0f107c48ULL, 0x000fe4000ffe0000ULL,
0x000000050c007c0cULL, 0x000fe2000bf06070ULL, 0x0000000000077919ULL, 0x004ea20000000000ULL,
0x0000008017087824ULL, 0x008fc400078e00ffULL, 0x0000000110107824ULL, 0x000fe200078e0a0fULL,
0x00008a00ff0a7b82ULL, 0x000ee80000000a00ULL, 0x0000004010107807ULL, 0x000fe20000000000ULL,
0x0001c64807077890ULL, 0x000fc6000fffe03fULL, 0x0000001005107248ULL, 0x000fca0007fe0000ULL,
0x0000000110097824ULL, 0x000fe200078e0a05ULL, 0x00000004ff147819ULL, 0x004fe20000011607ULL,
0x0000001007277824ULL, 0x000fc600078e00ffULL, 0x000000091400720cULL, 0x0c0fe20003f06070ULL,
0x0000000105117824ULL, 0x000fe200078e0214ULL, 0x000000f027277812ULL, 0x000fe200078ec0ffULL,
0x0000000214167836ULL, 0x040fe40000000000ULL, 0x00000008141c7836ULL, 0x000fe20000000000ULL,
0x00000007110c7812ULL, 0x000fe200078ec0ffULL, 0x0000000105157824ULL, 0x040fe200078e0216ULL,
0x000000091600720cULL, 0x080fe20003f26070ULL, 0x0000000414167836ULL, 0x000fe20000000000ULL,
0x0000000f0c127812ULL, 0x000fe200078e7807ULL, 0x00000001051d7824ULL, 0x000fe200078e021cULL,
0x0000000715187812ULL, 0x000fe200078ec0ffULL, 0x0000000105177824ULL, 0x000fe200078e0216ULL,
0x000000091c00720cULL, 0x000fe20003f86070ULL, 0x00000010110f7824ULL, 0x000fe200078e0212ULL,
0x0000000f18187812ULL, 0x000fe200078e7807ULL, 0x0000000a141e7836ULL, 0x000fc40000000000ULL,
0x000000100f0f7824ULL, 0x000fe400078e021aULL, 0x0000000105217824ULL, 0x000fe400078e021eULL,
0x0000000c14207836ULL, 0x040fe40000000000ULL, 0x0000000e141c7836ULL, 0x000fc80000000000ULL,
0x0000000105257824ULL, 0x000fe400078e021cULL, 0x00000006060c7c24ULL, 0x010fca000f8e0208ULL,
0x0000007f0c117812ULL, 0x000fe400078ef811ULL, 0x0000007f0c137812ULL, 0x000fe200078ef815ULL,
0x0000001015157824ULL, 0x000fe400078e0218ULL, 0x0000010011107825ULL, 0x008fc800078e000aULL,
0x0000010013127825ULL, 0x000fe200078e000aULL, 0x0000002710107210ULL, 0x000fc60007f5e0ffULL,
0x0000000614187836ULL, 0x000fe20000000000ULL, 0x0000002712127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000092000720cULL, 0x080fe20003f46070ULL,
0x0000000105197824ULL, 0x000fe200078e0218ULL, 0x000000091800720cULL, 0x080fe20003fa6070ULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0005e2000c101c4cULL, 0x000000091600720cULL, 0x000fe20003f06070ULL,
0x0000001015157824ULL, 0x000fe200078e021aULL, 0x0000000717167812ULL, 0x000fc400078ec0ffULL,
0x000000071d187812ULL, 0x000fe400078ec0ffULL, 0x0000000f16167812ULL, 0x000fe200078e7807ULL,
0x0000000012157faeULL, 0x0007e2000c901c4cULL, 0x0000000f18187812ULL, 0x000fe400078e7807ULL,
0x000000091e00720cULL, 0x000fe20003f66070ULL, 0x00000010170f7824ULL, 0x004fe200078e0216ULL,
0x0000000719107812ULL, 0x000fe200078ec0ffULL, 0x000000101d1f7824ULL, 0x000fe200078e0218ULL,
0x0000007f0c117812ULL, 0x000fe200078ef817ULL, 0x000000100f0f7824ULL, 0x100fe200078e021aULL,
0x0000000721167812ULL, 0x000fe200078ec0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e021aULL,
0x0000007f0c1d7812ULL, 0x000fc400078ef81dULL, 0x0000000f10127812ULL, 0x008fe200078e7807ULL,
0x0000010011107825ULL, 0x000fe200078e000aULL, 0x0000007f0c137812ULL, 0x000fe400078ef819ULL,
0x0000000f16187812ULL, 0x000fe200078e7807ULL, 0x00000010191b7824ULL, 0x000fe200078e0212ULL,
0x0000002710147210ULL, 0x000fe20007fde0ffULL, 0x0000010013127825ULL, 0x000fe200078e000aULL,
0x000000091c00720cULL, 0x000fe40003f26070ULL, 0x00000007251e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200030e0611ULL, 0x0000002712167210ULL, 0x000fe20007fde0ffULL,
0x000001001d107825ULL, 0x000fe200078e000aULL, 0x0000000f1e1e7812ULL, 0x000fc400078e7807ULL,
0x00000000140f7faeULL, 0x000fe2000c101c4cULL, 0x0000001021097824ULL, 0x000fe200078e0218ULL,
0x0000007f0c217812ULL, 0x000fe200078ef821ULL, 0x00000001051d7824ULL, 0x000fe200078e0220ULL,
0x0000000502007c0cULL, 0x000fe2000bf06070ULL, 0x000000ffff177224ULL, 0x000fe200030e0613ULL,
0x0000002710187210ULL, 0x000fe20007fde0ffULL, 0x0000010021127825ULL, 0x000fe200078e000aULL,
0x0000007f0c237812ULL, 0x000fe400078ef81dULL, 0x000000071d1c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0611ULL, 0x0000002712127210ULL, 0x000fe20007fde0ffULL,
0x0000010023107825ULL, 0x000fe200078e000aULL, 0x0000007f0c237812ULL, 0x000fc400078ef825ULL,
0x0000000f1c1c7812ULL, 0x000fe200078e7807ULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x0000002710107210ULL, 0x000fe20007fde0ffULL, 0x00000100230a7825ULL, 0x000fc800078e000aULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000270a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101d217824ULL, 0x000fe400078e021cULL, 0x0000001025257824ULL, 0x000fe400078e021eULL,
0x000000101b1b7824ULL, 0x100fe400078e021aULL, 0x00000010091d7824ULL, 0x100fe400078e021aULL,
0x0000001021217824ULL, 0x100fe200078e021aULL, 0x00000000161b7faeULL, 0x0003e2000e901c4cULL,
0x0000001025257824ULL, 0x000fc400078e021aULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x00000000181f7faeULL, 0x0003e2000e101c4cULL, 0x00000001ff237424ULL, 0x000fe400078e00ffULL,
0xff317217ff097424ULL, 0x000fe200078e00ffULL, 0x00000000121d7faeULL, 0x0003e8000d901c4cULL,
0x0000000010217faeULL, 0x0003e8000d101c4cULL, 0x000000000a257faeULL, 0x0003e2000c901c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a47ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x01c6582304ff79a7ULL, 0x0005e2000850003fULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x002fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fc4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fc4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000a400580947ULL, 0x004fec0003800000ULL,
0x00009000ff0a7b82ULL, 0x000e620000000800ULL, 0x000000020d0d7824ULL, 0x000fe200078e00ffULL,
0x00007610ff7c7816ULL, 0x000fe2000000007cULL, 0xff317217ff097424ULL, 0x000fe200078e00ffULL,
0x00007610ff757816ULL, 0x000fe20000000075ULL, 0x000000ffff7d7224ULL, 0x000fe200078e00ffULL,
0x00007610ff0b7816ULL, 0x000fe2000000000bULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x0000000a0d0d7224ULL, 0x002fce00078e020aULL, 0x00000100020f7824ULL, 0x000fca00078e00ffULL,
0x0000000b0f007c0cULL, 0x000fda000bf06070ULL, 0x000000a400140947ULL, 0x000fea0003800000ULL,
0x0000ffff7c0f7812ULL, 0x000fe200078ec0ffULL, 0x00008a00ff787b82ULL, 0x000e620000000a00ULL,
0x00000004ff5a7819ULL, 0x000fe20000011607ULL, 0x0000000606337c24ULL, 0x000fe2000f8e0208ULL,
0x000088800f257816ULL, 0x000fe200000000ffULL, 0x0000000102227836ULL, 0x040fe20000000000ULL,
0x0000004002207811ULL, 0x000fe200078e40ffULL, 0x0000000105597824ULL, 0x000fe200078e025aULL,
0x0000000103237812ULL, 0x000fe200078ec0ffULL, 0x8000000025257824ULL, 0x000fe200078e00ffULL,
0x0000000b20217c48ULL, 0x000fe2000ffe0000ULL, 0x000000025a567836ULL, 0x040fe20000000000ULL,
0x0000007f59067812ULL, 0x000fe200078ec0ffULL, 0x01c65825040075a7ULL, 0x000ea2000806007fULL,
0x000000045a4e7836ULL, 0x000fe20000000000ULL, 0x0000000522007c0cULL, 0x000fe2000bf26070ULL,
0x000000065a3f7836ULL, 0x040fe20000000000ULL, 0x000000012300780cULL, 0x000fe20003f05070ULL,
0x000000085a3c7836ULL, 0x000fc40000000000ULL, 0x0000000a5a397836ULL, 0x040fe40000000000ULL,
0x0000000c5a357836ULL, 0x040fe40000000000ULL, 0x0000004033337836ULL, 0x000fe40000000000ULL,
0x0000000e5a327836ULL, 0x000fe40000000000ULL, 0x0000000105537824ULL, 0x040fe400078e0256ULL,
0x00000001054d7824ULL, 0x000fc400078e024eULL, 0x0000000121287824ULL, 0x000fe400078e0a20ULL,
0x00000001053e7824ULL, 0x000fe200078e023fULL, 0x0000007f4d227812ULL, 0x000fe200078ec0ffULL,
0x00000001053b7824ULL, 0x040fe400078e023cULL, 0x0000000105377824ULL, 0x040fe200078e0239ULL,
0x0000007f3e247812ULL, 0x000fe200078ec0ffULL, 0x0000000105347824ULL, 0x000fe200078e0235ULL,
0x0000007f3b267812ULL, 0x000fe200078ec0ffULL, 0x0000000105317824ULL, 0x000fe200078e0232ULL,
0x0000007f372a7812ULL, 0x000fe200078ec0ffULL, 0x0000000106217824ULL, 0x000fe200078e0233ULL,
0x0000007f53067812ULL, 0x000fe200078ec0ffULL, 0x00000010070f7824ULL, 0x000fe200078e00ffULL,
0x0000007f34307812ULL, 0x000fe200078ec0ffULL, 0x0000010021207825ULL, 0x002fe200078e0078ULL,
0x0000007f31367812ULL, 0x000fc400078ec0ffULL, 0x000000f00f587812ULL, 0x000fe200078ec0ffULL,
0x0000000106237824ULL, 0x100fe400078e0233ULL, 0x0000000122277824ULL, 0x100fe200078e0233ULL,
0x0000005820507210ULL, 0x000fe20007f5e0ffULL, 0x0000000124297824ULL, 0x100fe400078e0233ULL,
0x00000001262b7824ULL, 0x100fe400078e0233ULL, 0x000000012a4f7824ULL, 0x100fe400078e0233ULL,
0x0000000130577824ULL, 0x000fc400078e0233ULL, 0x0000000136337824ULL, 0x000fe400078e0233ULL,
0x0000010023227825ULL, 0x000fc800078e0078ULL, 0x0000010027267825ULL, 0x000fe200078e0078ULL,
0x0000000000083947ULL, 0x004fec0003800000ULL, 0x01c65825040075a7ULL, 0x000e64000806017fULL,
0x000001300008b947ULL, 0x002fea0003800000ULL, 0x0000010029247825ULL, 0x000fe200078e0078ULL,
0x0000004028287807ULL, 0x000fe40000800000ULL, 0x0000005822207210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff517224ULL, 0x000fe200010e0621ULL, 0x0000002805067248ULL, 0x000fe20007fe0000ULL,
0x000040007d557824ULL, 0x000fe200078e00ffULL, 0x00000058242a7210ULL, 0x000fe20007f5e0ffULL,
0x000001002b287825ULL, 0x000fe200078e0078ULL, 0x0000000759247812ULL, 0x000fe400078ec0ffULL,
0x0000005826227210ULL, 0x000fe20007f9e0ffULL, 0x00000001065b7824ULL, 0x000fe200078e0a05ULL,
0x0000000f24307812ULL, 0x000fe200078e7807ULL, 0x000000ffff2b7224ULL, 0x000fe200010e0625ULL,
0x00004000553d7812ULL, 0x000fe200078e0cffULL, 0x000000ffff217224ULL, 0x000fe200018e0623ULL,
0x0000005b5a00720cULL, 0x000fe20003f46070ULL, 0x0000010057247825ULL, 0x000fe200078e0078ULL,
0x0000005828287210ULL, 0x000fc40007f7e0ffULL, 0xffffffff006a7811ULL, 0x000fe200078e08ffULL,
0x000000ffff237224ULL, 0x000fe200020e0627ULL, 0x0001400004067810ULL, 0x000fe20007ffe03dULL,
0x0000001059577824ULL, 0x000fe200078e0230ULL, 0x0000000753307812ULL, 0x000fe200078ec0ffULL,
0x000001004f267825ULL, 0x000fe200078e0078ULL, 0x000000016a6a7807ULL, 0x000fe40004000000ULL,
0x0000000f30307812ULL, 0x000fe200078e7807ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x0000005826267210ULL, 0x000fe20007f7e0ffULL, 0x00000010573d7824ULL, 0x000fe200078e0206ULL,
0x000000074d367812ULL, 0x000fe200078ec0ffULL, 0x000000ffff6f7224ULL, 0x000fe200078e0003ULL,
0x0000005824247210ULL, 0x000fe20007f9e0ffULL, 0x0000000103037824ULL, 0x000fe200078e026aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000503d7faeULL, 0x0003e2000d101c4cULL,
0x00000010534f7824ULL, 0x000fe200078e0230ULL, 0x000000073e307812ULL, 0x000fe200078ec0ffULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x0000005b5600720cULL, 0x080fe20003f66070ULL,
0x000000104f5d7824ULL, 0x000fe200078e0206ULL, 0x0000000f36367812ULL, 0x000fe200078e7807ULL,
0x000000ffff257224ULL, 0x000fe200020e0625ULL, 0x0000005b4e00720cULL, 0x000fc40003f46070ULL,
0x0000000403007c0cULL, 0x000fe2000bf06070ULL, 0x000000104d4c7824ULL, 0x000fe200078e0236ULL,
0x0000000f305f7812ULL, 0x000fe200078e7807ULL, 0x0000010033507825ULL, 0x002fe200078e0078ULL,
0x0000005b3f00720cULL, 0x000fe40003f86070ULL, 0x000000017d5c7812ULL, 0x000fe200078e0cffULL,
0x000000103e3d7824ULL, 0x000fe200078e025fULL, 0x00000000205d7faeULL, 0x000fe2000d901c4cULL,
0x000000104c5f7824ULL, 0x100fe200078e0206ULL, 0x000000073b307812ULL, 0x000fe200078ec0ffULL,
0x000000103d617824ULL, 0x000fe200078e0206ULL, 0x000000005c0872caULL, 0x000fc400000e0000ULL,
0x00000000225f7faeULL, 0x0003e2000d101c4cULL, 0x0000000737367812ULL, 0x000fe400078ec0ffULL,
0x0000000f30307812ULL, 0x000fe200078e7807ULL, 0x000000002a617faeULL, 0x0005e2000e101c4cULL,
0x0000005b3c00720cULL, 0x080fe40003f46070ULL, 0x0000000734387812ULL, 0x000fe200078ec0ffULL,
0x000000103b3a7824ULL, 0x000fe200078e0230ULL, 0x0000000f36367812ULL, 0x000fe400078e7807ULL,
0x0000005b3900720cULL, 0x080fe20003f66070ULL, 0x00008c00ff228b82ULL, 0x002e620000000a00ULL,
0x0000000f38337812ULL, 0x000fe200078e7807ULL, 0x0000001037367824ULL, 0x000fe200078e0236ULL,
0x0000005b3500720cULL, 0x080fe20003f86070ULL, 0x000000103a2b7824ULL, 0x004fe200078e0206ULL,
0x00000007312a7812ULL, 0x000fe200078ec0ffULL, 0x0000001034337824ULL, 0x000fe200078e0233ULL,
0x0000005850207210ULL, 0x000fe20007fde0ffULL, 0x0000000708087291ULL, 0x000fe2000f8e183fULL,
0x0000000f2a307812ULL, 0x000fe200078e7807ULL, 0x00000000282b7faeULL, 0x0005e2000d101c4cULL,
0x0000005b3200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff217224ULL, 0x000fe200030e0651ULL,
0x0000006a0d5d8210ULL, 0x000fe20007ffe06fULL, 0x0000001031307824ULL, 0x000fe200078e0230ULL,
0x0000ffff752a7812ULL, 0x000fe200078ec0ffULL, 0x0000001036517824ULL, 0x100fe200078e0206ULL,
0x0000ffff0b387812ULL, 0x000fe200078ec0ffULL, 0x00000010335b7824ULL, 0x000fe200078e0206ULL,
0x000088802a2a7816ULL, 0x000fc400000000ffULL, 0x0000000026517faeULL, 0x000fe2000d901c4cULL,
0x0000001030297824ULL, 0x004fe200078e0206ULL, 0x0000888038387816ULL, 0x000fe200000000ffULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x00000000245b7faeULL, 0x0005e2000e101c4cULL,
0x000000045d228825ULL, 0x002fc600078e0022ULL, 0x0000000020297faeULL, 0x0003e8000e901c4cULL,
0x0000000c22068981ULL, 0x000362000c1e1900ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff257224ULL, 0x004fe400078e002aULL, 0x000000ffff5b7224ULL, 0x000fe200078e0038ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x000000077d267c11ULL, 0x000fe2000f8e18ffULL,
0x8000000025257824ULL, 0x000fc400078e00ffULL, 0x800000005b277824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x00000025260075a7ULL, 0x000262000800007fULL,
0x00000001ff207819ULL, 0x000fe40000011607ULL, 0x000000700f5d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c20207812ULL, 0x000fc800078ec0ffULL, 0x00000004205d7210ULL, 0x000fe20007ffe05dULL,
0x01c60827040075a7ULL, 0x000ea4000804017fULL, 0x000001280070a947ULL, 0x006fea0003800000ULL,
0x01c000005d207984ULL, 0x000e620000000800ULL, 0x0000000807227812ULL, 0x000fe200078ec0ffULL,
0x000000040e637824ULL, 0x000fe200078e025aULL, 0x0001400004557810ULL, 0x000fe20007ffe055ULL,
0x01c200005d677984ULL, 0x0004a20000000800ULL, 0x0000000722287812ULL, 0x000fe400078ec807ULL,
0x00000007226b7812ULL, 0x000fe400078ef807ULL, 0x0000006328637212ULL, 0x000fca00078e3cffULL,
0x000000106b6d7824ULL, 0x000fc800078e0263ULL, 0x000000106d247824ULL, 0x000fe200078e0255ULL,
0x000000092000720bULL, 0x002fda0003f5d000ULL, 0x00000000000f7806ULL, 0x000fc800010e0100ULL,
0x0000ffff0f237812ULL, 0x000fe2000784c0ffULL, 0x00000001ff0f7424ULL, 0x000fd800078e00ffULL,
0x0000000000d4a947ULL, 0x004fea0003800000ULL, 0x000000092000720bULL, 0x000fe40003f54000ULL,
0x0000002009387209ULL, 0x000fe40007810000ULL, 0x00000002ff217819ULL, 0x000fc60000011607ULL,
0x80000038090f7221ULL, 0x100fe40000010000ULL, 0x0000000821227836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fe40000410000ULL, 0x0000000000097806ULL, 0x000fe400010e0100ULL,
0x000000ff0e00720cULL, 0x000fe40003f45270ULL, 0x0000ffff092a7812ULL, 0x000fe200078e3cffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x000000ffff097224ULL, 0x000fc400078e0038ULL,
0x0000002a23ff7212ULL, 0x000fce000786c0ffULL, 0x01c400385d00a388ULL, 0x000fe80000000800ULL,
0x00001f220f227589ULL, 0x002e6400000e0000ULL, 0x8000003820203221ULL, 0x000fe20000010000ULL,
0x0000000f0c0c7220ULL, 0x000fe20000410000ULL, 0x00001f210f217589ULL, 0x0004e400000e0000ULL,
0x3fb8aa3b20203820ULL, 0x000fc80000410000ULL, 0x00000020000a3308ULL, 0x000f220000000800ULL,
0x00000001ff0f7807ULL, 0x004fe20001800000ULL, 0x000000221b1b7220ULL, 0x082fe20000410000ULL,
0x000000221a1a7220ULL, 0x080fe20000410000ULL, 0x0000002213137220ULL, 0x080fe20000410000ULL,
0x0000002212127220ULL, 0x080fe20000410000ULL, 0x0000002217177220ULL, 0x080fe20000410000ULL,
0x0000002216167220ULL, 0x080fe20000410000ULL, 0x000000222f2f7220ULL, 0x080fe20000410000ULL,
0x000000222e2e7220ULL, 0x080fe20000410000ULL, 0x0000002243437220ULL, 0x080fe20000410000ULL,
0x0000002242427220ULL, 0x080fe20000410000ULL, 0x000000224b4b7220ULL, 0x080fe20000410000ULL,
0x000000224a4a7220ULL, 0x080fe20000410000ULL, 0x0000002247477220ULL, 0x080fe20000410000ULL,
0x0000002246467220ULL, 0x080fe20000410000ULL, 0x000000221f1f7220ULL, 0x080fe20000410000ULL,
0x000000221e1e7220ULL, 0x000fe20000410000ULL, 0x0000002119197220ULL, 0x088fe20000410000ULL,
0x0000002118187220ULL, 0x080fe20000410000ULL, 0x0000002111117220ULL, 0x080fe20000410000ULL,
0x0000002110107220ULL, 0x080fe20000410000ULL, 0x0000002115157220ULL, 0x080fe20000410000ULL,
0x0000002114147220ULL, 0x080fe20000410000ULL, 0x000000212d2d7220ULL, 0x080fe20000410000ULL,
0x000000212c2c7220ULL, 0x080fe20000410000ULL, 0x0000002141417220ULL, 0x080fe20000410000ULL,
0x0000002140407220ULL, 0x080fe20000410000ULL, 0x0000002149497220ULL, 0x080fe20000410000ULL,
0x0000002148487220ULL, 0x080fe20000410000ULL, 0x0000002145457220ULL, 0x080fe20000410000ULL,
0x0000002144447220ULL, 0x080fe20000410000ULL, 0x000000211d1d7220ULL, 0x080fe20000410000ULL,
0x000000211c1c7220ULL, 0x000fe20000410000ULL, 0x0000000a67673220ULL, 0x010fce0000410000ULL,
0x0000000000080947ULL, 0x000fea0003800000ULL, 0x00000025260075a7ULL, 0x000e64000800017fULL,
0x0000012400748947ULL, 0x002fea0003800000ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x00000007075e7812ULL, 0x000fe200078ec0ffULL, 0x0000000c670c7221ULL, 0x000fe20000010000ULL,
0x000000020e617811ULL, 0x000fe400078e10ffULL, 0x000000085e5e7812ULL, 0x000fe400078ef807ULL,
0x00000002ff527819ULL, 0x000fe20000011607ULL, 0x000000015a617824ULL, 0x000fe200078e0261ULL,
0x000000075a217812ULL, 0x000fe400078e785eULL, 0x0000000aff50723eULL, 0x000fc400000010ffULL,
0x0000006128617212ULL, 0x000fe200078e3cffULL, 0x000000085e217824ULL, 0x000fe200078e0221ULL,
0x000099100f5f7816ULL, 0x000fe400000000ffULL, 0x00005410500f7816ULL, 0x000fe20000000050ULL,
0x0000001021387824ULL, 0x000fe200078e0204ULL, 0x0000000207777811ULL, 0x000fe200078fe0ffULL,
0x000000106b667824ULL, 0x000fe200078e0261ULL, 0x000000ff7cff7812ULL, 0x000fe2000788c0ffULL,
0x000000ffff507224ULL, 0x000fe200078e005fULL, 0x00001f520f687589ULL, 0x000fe200000e0000ULL,
0x0000001066287824ULL, 0x000fe200078e0255ULL, 0x0000000777777812ULL, 0x000fc400078e785eULL,
0x000000ff5000720cULL, 0x000fc60003f05270ULL, 0x000000002828783bULL, 0x000ea20000004200ULL,
0x000000085e777824ULL, 0x000fe400078e0277ULL, 0x0000010024207824ULL, 0x042fe200078e00ffULL,
0x0000888024547816ULL, 0x000fe200000000ffULL, 0x0000010025517824ULL, 0x040fe200078e00ffULL,
0x0000888025557816ULL, 0x000fe400000000ffULL, 0x00000018ff717819ULL, 0x000fe40000011420ULL,
0x012000003820783bULL, 0x000e620000000200ULL, 0x00000018ff607819ULL, 0x000fe20000011451ULL,
0x0000000852517836ULL, 0x000fe20000000000ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00000018ff6e7819ULL, 0x000fe20000011424ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011425ULL, 0x00001f510f5f7589ULL, 0x000ee200000e0000ULL,
0x00000018ff647819ULL, 0x000fc40000011427ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000007100717306ULL, 0x000f220000202400ULL, 0x00000018ff657819ULL, 0x000fce0000011426ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000018ff707819ULL, 0x004fe4000001142bULL,
0x00000018ff507819ULL, 0x000fca0000011429ULL, 0x00000060006c7306ULL, 0x0004e20000202400ULL,
0x0000541054547816ULL, 0x010fe40000000071ULL, 0x00000018ff627819ULL, 0x000fca0000011428ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x00000018ff607819ULL, 0x004fe2000001142aULL,
0x0000006820208232ULL, 0x082fe20000200000ULL, 0x0000541055557816ULL, 0x008fe2000000006cULL,
0x0000006822228232ULL, 0x000fe40000200000ULL, 0x00010000256c7824ULL, 0x000fe400078e00ffULL,
0x0000005f21218232ULL, 0x080fe20000200000ULL, 0x0000002400257306ULL, 0x000e620000202400ULL,
0x0000005f23238232ULL, 0x000fce0000200000ULL, 0x00000054201c723cULL, 0x000fe2000004181cULL,
0x0000006900697306ULL, 0x000fec0000202400ULL, 0x00000018ff547819ULL, 0x000fe2000001146cULL,
0x0000010026557824ULL, 0x040fe200078e00ffULL, 0x0000541025247816ULL, 0x002fe2000000006eULL,
0x0000010027257824ULL, 0x000fe200078e00ffULL, 0x00008880266c7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000005400547306ULL, 0x000e620000202400ULL,
0x00000018ff717819ULL, 0x000fe20000011455ULL, 0x00000100296e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc40000011425ULL, 0x0000888027557816ULL, 0x040fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000541054257816ULL, 0x002fca0000000069ULL, 0x0000007100717306ULL, 0x000e620000202400ULL,
0x0000888028547816ULL, 0x040fe200000000ffULL, 0x000000242044723cULL, 0x000fec0000041844ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000018ff257819ULL, 0x000fe20000011427ULL,
0x0000010028247824ULL, 0x000fe200078e00ffULL, 0x0000888029277816ULL, 0x000fca00000000ffULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000070000f7306ULL, 0x000fe20000202400ULL,
0x00000018ff287819ULL, 0x000fce0000011428ULL, 0x0000006500657306ULL, 0x000ff00000202400ULL,
0x0000006400647306ULL, 0x000ff00000202400ULL, 0x0000002600707306ULL, 0x0003f00000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x000054106c267816ULL, 0x002fce0000000071ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000541025257816ULL, 0x004fce0000000064ULL,
0x0000002400697306ULL, 0x0002a20000202400ULL, 0x000088802a647816ULL, 0x000fce00000000ffULL,
0x00000027006c7306ULL, 0x0007e20000202400ULL, 0x0000541070247816ULL, 0x002fce0000000065ULL,
0x0000006e006e7306ULL, 0x000e620000202400ULL, 0x0000541055277816ULL, 0x008fe20000000072ULL,
0x000000242040723cULL, 0x000fe20000041840ULL, 0x000001006b557811ULL, 0x000fca00078e20ffULL,
0x000000262048723cULL, 0x000fe20000041848ULL, 0x0000000163657824ULL, 0x000fe200078e0255ULL,
0x0000005000507306ULL, 0x000fe20000202400ULL, 0x000001002a247824ULL, 0x040fe400078e00ffULL,
0x000100002a2a7824ULL, 0x000fe400078e00ffULL, 0x000040007d277824ULL, 0x000fe200078e0204ULL,
0x0000541054267816ULL, 0x004fe20000000069ULL, 0x000000ffff547224ULL, 0x000fe200078e0064ULL,
0x00000018ff737819ULL, 0x000fe20000011424ULL, 0x0001400027697836ULL, 0x000fe20000000000ULL,
0x000054106c277816ULL, 0x002fe2000000006eULL, 0x0000002900297306ULL, 0x000e620000202400ULL,
0x000001002b6c7824ULL, 0x040fe200078e00ffULL, 0x000088802b647816ULL, 0x000fe200000000ffULL,
0x0000001065257824ULL, 0x000fe200078e0269ULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x00000026202c723cULL, 0x000fe2000004182cULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000006200627306ULL, 0x000fe20000202400ULL, 0x000000002524783bULL, 0x000ea20000004200ULL,
0x0000541029297816ULL, 0x002fcc0000000050ULL, 0x0000002800287306ULL, 0x000e620000202400ULL,
0x000100002b507824ULL, 0x000fce00078e00ffULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541028287816ULL, 0x002fce0000000062ULL, 0x0000007300737306ULL, 0x000e620000202400ULL,
0x00000018ff627819ULL, 0x000fe20000011450ULL, 0x0000001077507824ULL, 0x000fe200078e0204ULL,
0x000000282014723cULL, 0x000fea0000041814ULL, 0x0000006400647306ULL, 0x000fe40000202400ULL,
0x0000541054287816ULL, 0x002fcc0000000073ULL, 0x0000006c00717306ULL, 0x0002e20000202400ULL,
0x00000018ff6e7819ULL, 0x004fce0000011424ULL, 0x0000006000607306ULL, 0x000fe20000202400ULL,
0x00008880246c7816ULL, 0x002fe400000000ffULL, 0x0000541064297816ULL, 0x008fca0000000071ULL,
0x0000002a002b7306ULL, 0x000e620000202400ULL, 0x000000ffff647224ULL, 0x000fe400078e006cULL,
0x00000100246c7824ULL, 0x040fe400078e00ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x000000282010723cULL, 0x000fe40000041810ULL, 0x0000006200627306ULL, 0x000ea40000202400ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x000054102b547816ULL, 0x002fe20000000060ULL,
0x0000000161607824ULL, 0x000fe200078e0255ULL, 0x012000005028783bULL, 0x000e640000000200ULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x0000541062557816ULL, 0x004fe2000000000fULL,
0x00000010600f7824ULL, 0x000fe200078e0269ULL, 0x00000018ff627819ULL, 0x000fe2000001146cULL,
0x00000100256c7824ULL, 0x000fc800078e00ffULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x000000542020723cULL, 0x000fe20000041818ULL, 0x00000018ff707819ULL, 0x000fe2000001146cULL,
0x000000000f18783bULL, 0x000ea20000004200ULL, 0x00000018ff6c7819ULL, 0x000fc80000011425ULL,
0x0000006200557306ULL, 0x0007220000202400ULL, 0x0000888025547816ULL, 0x000fce00000000ffULL,
0x0000005400717306ULL, 0x0009e20000202400ULL, 0x00000018ff627819ULL, 0x008fce0000011427ULL,
0x0000007000707306ULL, 0x000ee20000202400ULL, 0x0000541064547816ULL, 0x010fe40000000055ULL,
0x00000018ff647819ULL, 0x000fe20000011426ULL, 0x0000006828288232ULL, 0x082fe40000200000ULL,
0x000000682a2a8232ULL, 0x000fe40000200000ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x0000005f29298232ULL, 0x080fe40000200000ULL, 0x0000005f2b2b8232ULL, 0x000fe20000200000ULL,
0x0000541071557816ULL, 0x008fc80000000070ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x00000018ff0f7819ULL, 0x004fe40000011418ULL, 0x00000054281c723cULL, 0x000fea000004181cULL,
0x0000006200627306ULL, 0x000fe40000202400ULL, 0x0001000025547824ULL, 0x000fe200078e00ffULL,
0x0000888026557816ULL, 0x000fca00000000ffULL, 0x0000002400257306ULL, 0x000e620000202400ULL,
0x00000018ff547819ULL, 0x000fce0000011454ULL, 0x0000005400717306ULL, 0x0004e20000202400ULL,
0x0000541025247816ULL, 0x002fe2000000006eULL, 0x0000010026257824ULL, 0x000fcc00078e00ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x004fe4000001141aULL, 0x00000018ff6e7819ULL, 0x000fe40000011425ULL,
0x0000541071257816ULL, 0x008fe4000000006cULL, 0x00008880276c7816ULL, 0x040fe200000000ffULL,
0x0000000f000f7306ULL, 0x000fe80000202400ULL, 0x000000242844723cULL, 0x000fe80000041844ULL,
0x0000006e006e7306ULL, 0x000e660000202400ULL, 0x0000010027257824ULL, 0x000fc400078e00ffULL,
0x000000ffff247224ULL, 0x000fe200078e006cULL, 0x00000018ff6c7819ULL, 0x000fe40000011419ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000002400707306ULL, 0x0003f00000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541055247816ULL, 0x002fc4000000006eULL,
0x00000018ff6e7819ULL, 0x000fe20000011426ULL, 0x0001000027267824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fc6000001141bULL, 0x0000006e00277306ULL, 0x0002e20000202400ULL,
0x00000018ff737819ULL, 0x000fe40000011426ULL, 0x0000888018267816ULL, 0x000fe400000000ffULL,
0x0000541070257816ULL, 0x004fc60000000025ULL, 0x0000007300737306ULL, 0x000ea20000202400ULL,
0x00000100196e7824ULL, 0x042fe400078e00ffULL, 0x0001000018707824ULL, 0x040fe200078e00ffULL,
0x000000242848723cULL, 0x000fe40000041848ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000002600267306ULL, 0x000fe20000202400ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000010018247824ULL, 0x000fe200078e00ffULL, 0x0000888019257816ULL, 0x000fc400000000ffULL,
0x0000541027187816ULL, 0x008fe20000000064ULL, 0x0001000019277824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x0000541073197816ULL, 0x004fe40000000062ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x000002006b627811ULL, 0x040fe400078e20ffULL, 0x000003006b6b7811ULL, 0x000fe200078e20ffULL,
0x0000002400717306ULL, 0x000e620000202400ULL, 0x000000182840723cULL, 0x000fe20000041840ULL,
0x0000000163647824ULL, 0x000fc400078e0262ULL, 0x0000000161627824ULL, 0x000fe400078e0262ULL,
0x0000001064727824ULL, 0x000fe400078e0269ULL, 0x0000002500257306ULL, 0x000ea20000202400ULL,
0x000088801a197816ULL, 0x000fe200000000ffULL, 0x0000000163637824ULL, 0x100fe400078e026bULL,
0x0000000161617824ULL, 0x000fe200078e026bULL, 0x0000541026187816ULL, 0x002fc60000000071ULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x000000ffff717224ULL, 0x000fe200078e0019ULL,
0x0000541025197816ULL, 0x004fcc000000006eULL, 0x0000002700277306ULL, 0x000e620000202400ULL,
0x000001001a257824ULL, 0x040fe400078e00ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018282c723cULL, 0x000fe8000004182cULL, 0x0000007000247306ULL, 0x000ea20000202400ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000018ff187819ULL, 0x000fc40000011425ULL,
0x0000541027257816ULL, 0x002fe2000000006cULL, 0x000001001b6c7824ULL, 0x040fe200078e00ffULL,
0x000088801b197816ULL, 0x040fe200000000ffULL, 0x00000071006e7306ULL, 0x000fe20000202400ULL,
0x000100001b1b7824ULL, 0x000fe400078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000541024247816ULL, 0x004fc6000000000fULL, 0x00000018000f7306ULL, 0x0003e80000202400ULL,
0x000000242824723cULL, 0x000fe20000041814ULL, 0x000000007214783bULL, 0x000ea60000004200ULL,
0x0000001900197306ULL, 0x000fe20000202400ULL, 0x00000018ff187819ULL, 0x002fe4000001141bULL,
0x00000004071b7811ULL, 0x000fc800078fe0ffULL, 0x000000071b1b7812ULL, 0x000fe200078e785eULL,
0x0000006c006c7306ULL, 0x000e700000202400ULL, 0x0000001800707306ULL, 0x0007e20000202400ULL,
0x0000541019197816ULL, 0x002fce000000006cULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x000054106e187816ULL, 0x008fe2000000000fULL, 0x000000085e0f7824ULL, 0x000fc800078e021bULL,
0x000000100f0f7824ULL, 0x000fe400078e0204ULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x000000182810723cULL, 0x000fe20000041810ULL, 0x00000018ff6c7819ULL, 0x004fe40000011414ULL,
0x00008880166e7816ULL, 0x000fc800000000ffULL, 0x0000001a00717306ULL, 0x0004e20000202400ULL,
0x0000541070557816ULL, 0x002fce0000000055ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x012000000f18783bULL, 0x004e620000000200ULL, 0x0000541071547816ULL, 0x008fcc0000000054ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x000000542820723cULL, 0x000fee0000041820ULL,
0x0000010014297824ULL, 0x040fe200078e00ffULL, 0x0000888014287816ULL, 0x040fe200000000ffULL,
0x00000100152b7824ULL, 0x040fe200078e00ffULL, 0x00008880152a7816ULL, 0x000fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x00000018ff547819ULL, 0x000fe20000011415ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000888017557816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000002900297306ULL, 0x000ea20000202400ULL,
0x0000006818188232ULL, 0x002fc40000200000ULL, 0x000000681a1a8232ULL, 0x000fca0000200000ULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x0000005f19198232ULL, 0x080fe40000200000ULL,
0x0000005f1b1b8232ULL, 0x000fca0000200000ULL, 0x0000002b002b7306ULL, 0x000e700000202400ULL,
0x0000001400737306ULL, 0x0005f00000202400ULL, 0x0000001500717306ULL, 0x0003e20000202400ULL,
0x0000541028147816ULL, 0x004fe20000000029ULL, 0x0000010016297824ULL, 0x000fc400078e00ffULL,
0x0000001062287824ULL, 0x000fc600078e0269ULL, 0x00000018ff777819ULL, 0x000fe20000011429ULL,
0x0000005400547306ULL, 0x000ea20000202400ULL, 0x000054102a157816ULL, 0x002fe4000000002bULL,
0x000000002828783bULL, 0x000e6a0000004200ULL, 0x00000014181c723cULL, 0x000fe2000004181cULL,
0x0000007700777306ULL, 0x000eec0000202400ULL, 0x0000010017147824ULL, 0x000fe200078e00ffULL,
0x0000541071157816ULL, 0x004fe20000000054ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x00000018ff547819ULL, 0x000fc40000011416ULL, 0x00000018ff707819ULL, 0x000fe40000011414ULL,
0x0000541073147816ULL, 0x000fe4000000006cULL, 0x00000018ff6c7819ULL, 0x000fe20000011417ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000007000707306ULL, 0x000ea60000202400ULL,
0x000000141844723cULL, 0x000fea0000041844ULL, 0x0000005400547306ULL, 0x000fe40000202400ULL,
0x000054106e147816ULL, 0x008fc40000000077ULL, 0x00000018ff6e7819ULL, 0x000fe40000011417ULL,
0x0000541055157816ULL, 0x004fe40000000070ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x0000888028177816ULL, 0x002fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe40000011428ULL,
0x00000018ff707819ULL, 0x000fe20000011429ULL, 0x000000141848723cULL, 0x000fe40000041848ULL,
0x0000006e00717306ULL, 0x000fea0000202400ULL, 0x0001000016147824ULL, 0x000fc600078e00ffULL,
0x0000001700177306ULL, 0x000fe40000202400ULL, 0x00000018ff147819ULL, 0x000fcc0000011414ULL,
0x0000001400157306ULL, 0x000e700000202400ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x0000541015147816ULL, 0x002fe20000000054ULL, 0x0000010028157824ULL, 0x000fcc00078e00ffULL,
0x0000007000167306ULL, 0x0003e20000202400ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011415ULL, 0x0000541071157816ULL, 0x000fe4000000006cULL,
0x00008880296c7816ULL, 0x000fe400000000ffULL, 0x0000005400547306ULL, 0x000ea20000202400ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x000000141840723cULL, 0x000fe20000041840ULL,
0x000088802b707816ULL, 0x002fc800000000ffULL, 0x0000002800287306ULL, 0x000fe40000202400ULL,
0x0000010029157824ULL, 0x040fe400078e00ffULL, 0x000000ffff147224ULL, 0x000fe400078e006cULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x00000014006c7306ULL, 0x0005e60000202400ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000001500157306ULL, 0x000e620000202400ULL, 0x0000541017147816ULL, 0x004fe20000000054ULL,
0x0000001063177824ULL, 0x000fe200078e0269ULL, 0x00000018ff547819ULL, 0x000fca000001142aULL,
0x0000002900297306ULL, 0x000ea20000202400ULL, 0x000054106c157816ULL, 0x002fce0000000015ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x000088802a6c7816ULL, 0x040fe200000000ffULL,
0x00000014182c723cULL, 0x000fec000004182cULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x000001002a157824ULL, 0x000fe200078e00ffULL, 0x0000541028147816ULL, 0x000fe20000000055ULL,
0x000001002b557824ULL, 0x000fca00078e00ffULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00000018ff287819ULL, 0x000fe40000011415ULL, 0x0000541029157816ULL, 0x004fe40000000016ULL,
0x00000018ff717819ULL, 0x000fe20000011455ULL, 0x000100002a557824ULL, 0x000fe400078e00ffULL,
0x0000002800297306ULL, 0x000e620000202400ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142bULL,
0x000000141824723cULL, 0x000fe20000041824ULL, 0x000000001714783bULL, 0x000ea20000004200ULL,
0x00000018ff6e7819ULL, 0x000fe20000011455ULL, 0x000100002b557824ULL, 0x000fc600078e00ffULL,
0x0000007100717306ULL, 0x000ee40000202400ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x000054106c287816ULL, 0x002fc80000000029ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x0000541070297816ULL, 0x008fce0000000071ULL, 0x0000006e002b7306ULL, 0x000e620000202400ULL,
0x0000000607717811ULL, 0x000fc800078fe0ffULL, 0x0000000771717812ULL, 0x000fe200078e785eULL,
0x000000281810723cULL, 0x000fe40000041810ULL, 0x0000005500557306ULL, 0x000ee40000202400ULL,
0x000000085e717824ULL, 0x000fc800078e0271ULL, 0x00000010715e7824ULL, 0x000fe200078e0204ULL,
0x000054102b287816ULL, 0x002fe40000000054ULL, 0x0000888014547816ULL, 0x044fe400000000ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011415ULL, 0x0000541055297816ULL, 0x008fe2000000002aULL,
0x0000010014557824ULL, 0x040fe200078e00ffULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00000018ff6c7819ULL, 0x000fe20000011414ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fc40000011416ULL, 0x000000281820723cULL, 0x000fe20000041820ULL,
0x012000005e18783bULL, 0x000e620000000200ULL, 0x00000018ff717819ULL, 0x000fe20000011455ULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x0000888015557816ULL, 0x000fe400000000ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001061287824ULL, 0x000fe400078e0269ULL,
0x0000010015697824ULL, 0x040fe400078e00ffULL, 0x0000007100717306ULL, 0x000ea20000202400ULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x000000002828783bULL, 0x000ee20000004200ULL,
0x00000018ff707819ULL, 0x000fc40000011469ULL, 0x00000018ff697819ULL, 0x000fe40000011417ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x0000541054547816ULL, 0x004fce0000000071ULL, 0x0000007000707306ULL, 0x000eb00000202400ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0000006818188232ULL, 0x002fe20000200000ULL,
0x0000541055557816ULL, 0x004fcc0000000070ULL, 0x0000001400717306ULL, 0x000e620000202400ULL,
0x000000681a1a8232ULL, 0x000fe40000200000ULL, 0x0000005f19198232ULL, 0x080fe40000200000ULL,
0x0000005f1b1b8232ULL, 0x000fe20000200000ULL, 0x000000ff75ff7812ULL, 0x000fe4000780c0ffULL,
0x0000001500157306ULL, 0x000ea20000202400ULL, 0x0000888028727816ULL, 0x008fc600000000ffULL,
0x00000054181c723cULL, 0x000fe2000004181cULL, 0x00000018ff5f7819ULL, 0x000fe40000011428ULL,
0x0000541071147816ULL, 0x002fe2000000006cULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x00008880166c7816ULL, 0x040fe400000000ffULL, 0x0000010016557824ULL, 0x040fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011429ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc4000001142aULL, 0x0000541015157816ULL, 0x004fe2000000006eULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x00008880176e7816ULL, 0x000fe400000000ffULL,
0x00000018ff167819ULL, 0x000fc60000011416ULL, 0x000000141844723cULL, 0x000fe40000041844ULL,
0x0000006e006e7306ULL, 0x000fea0000202400ULL, 0x00000018ff147819ULL, 0x000fe20000011455ULL,
0x0000010017557824ULL, 0x040fe400078e00ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x0000001400157306ULL, 0x000e640000202400ULL, 0x00000018ff707819ULL, 0x000fc40000011455ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000018ff557819ULL, 0x000fe4000001142bULL,
0x0000007000717306ULL, 0x000ea20000202400ULL, 0x000054106c147816ULL, 0x002fce0000000015ULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x000054106e157816ULL, 0x004fce0000000071ULL,
0x0000001600747306ULL, 0x0002a20000202400ULL, 0x00008880296e7816ULL, 0x040fe200000000ffULL,
0x000000141848723cULL, 0x000fec0000041848ULL, 0x00000017006c7306ULL, 0x0007220000202400ULL,
0x0000010028147824ULL, 0x000fe400078e00ffULL, 0x0000010029157824ULL, 0x000fca00078e00ffULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff167819ULL, 0x002fe40000011428ULL,
0x0000001400717306ULL, 0x0005e20000202400ULL, 0x00000018ff177819ULL, 0x008fce0000011429ULL,
0x0000001500707306ULL, 0x0009e20000202400ULL, 0x0000541074147816ULL, 0x004fe4000000006bULL,
0x000076107c747816ULL, 0x000fca0000000074ULL, 0x0000006e006e7306ULL, 0x000e620000202400ULL,
0x000054106c157816ULL, 0x010fe40000000069ULL, 0x000088802a6c7816ULL, 0x000fe400000000ffULL,
0x000088802b697816ULL, 0x000fc600000000ffULL, 0x000000141840723cULL, 0x000fe20000041840ULL,
0x0000005f005f7306ULL, 0x000fec0000202400ULL, 0x000001002b157824ULL, 0x040fe400078e00ffULL,
0x000001002a147824ULL, 0x040fe200078e00ffULL, 0x0000006800687306ULL, 0x000fe20000202400ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011415ULL,
0x000100002a157824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff287819ULL, 0x000fe4000001142bULL, 0x0000001600167306ULL, 0x000ea20000202400ULL,
0x00000018ff297819ULL, 0x000fe40000011415ULL, 0x000054106e157816ULL, 0x002fe20000000070ULL,
0x000000ffff6e7224ULL, 0x000fe400078e007dULL, 0x000000ffff7d7224ULL, 0x000fe400078e005cULL,
0x0000001700177306ULL, 0x000e620000202400ULL, 0x000000016e00780cULL, 0x000fce0003f45270ULL,
0x00000014006b7306ULL, 0x0007f00000202400ULL, 0x0000006c006c7306ULL, 0x000f220000202400ULL,
0x0000541072147816ULL, 0x008fce0000000071ULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x00000014182c723cULL, 0x000fee000004182cULL, 0x00000073002a7306ULL, 0x000ee20000202400ULL,
0x0000541016147816ULL, 0x004fe2000000005fULL, 0x00000001ff5f7424ULL, 0x000fe200078e00ffULL,
0x0000541017157816ULL, 0x002fc40000000068ULL, 0x00000001ff687807ULL, 0x000fe20000000000ULL,
0x01c6585f04ff79a7ULL, 0x0003e4000850003fULL, 0x0000005400547306ULL, 0x000fe40000202400ULL,
0x000000141814723cULL, 0x000fe20000041824ULL, 0x01c6105f04ff79a7ULL, 0x0003ea000850003fULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000054106c247816ULL, 0x010fc4000000006bULL,
0x0000541069257816ULL, 0x008fe4000000002aULL, 0x00000001ff6b7807ULL, 0x000fc60002000000ULL,
0x0000002900297306ULL, 0x000ea20000202400ULL, 0x000076106b7c7816ULL, 0x000fe2000000007cULL,
0x000000241810723cULL, 0x000fec0000041810ULL, 0x0000002800287306ULL, 0x000ee20000202400ULL,
0x0000541029247816ULL, 0x004fe40000000054ULL, 0x0000761075297816ULL, 0x000fc40000000029ULL,
0x0000007568757207ULL, 0x000fe40005000000ULL, 0x0000541028257816ULL, 0x008fce0000000055ULL,
0x000000241818723cULL, 0x000fee0000041820ULL, 0x0000004002207811ULL, 0x000fc800078e40ffULL,
0x0000000b20007c0cULL, 0x000fda000bf61070ULL, 0x00000074005cb947ULL, 0x002fea0003800000ULL,
0x800000006b6b7824ULL, 0x000fe200078e00ffULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x00000080027c7811ULL, 0x000fe200078e40ffULL, 0x0000000906557c24ULL, 0x020fe2000f8e02ffULL,
0x01c6586b040075a7ULL, 0x000e62000808007fULL, 0x000040006e697824ULL, 0x000fe200078e00ffULL,
0x0000000b7c237c48ULL, 0x000fe2000ffe0000ULL, 0x0000008055557824ULL, 0x000fe200078e0208ULL,
0x0000002968687207ULL, 0x000fe40005000000ULL, 0x0000400069697812ULL, 0x000fe200078ec0ffULL,
0x0000000123247824ULL, 0x000fe200078e0a7cULL, 0x0000007f55217812ULL, 0x000fc400078ef859ULL,
0x0000007f55257812ULL, 0x000fe400078ef853ULL, 0x0000007f55277812ULL, 0x000fe200078ef84dULL,
0x0000010021207825ULL, 0x000fe200078e0078ULL, 0x0000004024247807ULL, 0x000fe40000800000ULL,
0x0001400004697810ULL, 0x000fe20007ffe069ULL, 0x0000010025227825ULL, 0x100fe200078e0078ULL,
0x0000007f55257812ULL, 0x000fe400078ef83eULL, 0x0000005820207210ULL, 0x000fe20007f1e0ffULL,
0x0000010027267825ULL, 0x000fe200078e0078ULL, 0x0000002405547248ULL, 0x000fc40007fe0000ULL,
0x0000007f55737812ULL, 0x000fe200078ef837ULL, 0x0000010025247825ULL, 0x000fe200078e0078ULL,
0x00000058262a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x0000005822227210ULL, 0x000fe20007f1e0ffULL, 0x0000000154547824ULL, 0x000fe200078e0a05ULL,
0x0000005824287210ULL, 0x000fe20007fde0ffULL, 0x000000ffff2b7224ULL, 0x000fe200028e0627ULL,
0x0000007f55277812ULL, 0x000fe200078ef83bULL, 0x000000ffff237224ULL, 0x000fe200000e0623ULL,
0x000000545a00720cULL, 0x080fe20003f66070ULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x000000545600720cULL, 0x000fe20003f06070ULL, 0x0000001057677824ULL, 0x000fe200078e0269ULL,
0x0000000000084947ULL, 0x002ff60003800000ULL, 0x01c6586b040075a7ULL, 0x000e64000804017fULL,
0x0000010000eca947ULL, 0x002fea0003800000ULL, 0x000000104f717824ULL, 0x000fe200078e0269ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020677faeULL, 0x0003e2000d901c4cULL,
0x0000010027247825ULL, 0x000fe200078e0078ULL, 0x000000544e00720cULL, 0x080fe40003f46070ULL,
0x0000000022717faeULL, 0x0005e2000c101c4cULL, 0x0000007f55757812ULL, 0x000fe200078ef831ULL,
0x000000086e6c7824ULL, 0x000fe200078e00ffULL, 0x0000005824267210ULL, 0x000fe40007f1e0ffULL,
0x000000543200720cULL, 0x000fc40003fa6070ULL, 0x000000086c6c7812ULL, 0x000fe200078ec0ffULL,
0x0000010073207825ULL, 0x002fe200078e0078ULL, 0x0000007f55737812ULL, 0x000fe400078ef834ULL,
0x000000006c0972caULL, 0x000fe200000e0000ULL, 0x000000ffff277224ULL, 0x000fe200000e0625ULL,
0x0000005820247210ULL, 0x000fe20007f7e0ffULL, 0x0000010073227825ULL, 0x004fe200078e0078ULL,
0x000000543f00720cULL, 0x000fc60003f06070ULL, 0x000000ffff257224ULL, 0x000fe200018e0621ULL,
0x0000005822227210ULL, 0x000fe20007f7e0ffULL, 0x0000010075207825ULL, 0x000fc800078e0078ULL,
0x000000104c677824ULL, 0x000fe200078e0269ULL, 0x0000005820207210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x000000543900720cULL, 0x080fe20003f66070ULL,
0x0000001036717824ULL, 0x000fe200078e0269ULL, 0x000000002a677faeULL, 0x0003e2000d101c4cULL,
0x000000543c00720cULL, 0x080fe20003f46070ULL, 0x000000ffff217224ULL, 0x000fe200020e0621ULL,
0x000000543500720cULL, 0x000fe20003f86070ULL, 0x0000000907097290ULL, 0x000fe2000fffe03fULL,
0x0000001033737824ULL, 0x000fc400078e0269ULL, 0x0000001030757824ULL, 0x100fe400078e0269ULL,
0x000000103d2b7824ULL, 0x102fe200078e0269ULL, 0x0000ffff682a7812ULL, 0x000fe200078ec0ffULL,
0x000000103a677824ULL, 0x000fc600078e0269ULL, 0x00000000282b7faeULL, 0x000fe2000c101c4cULL,
0x000088802a2a7816ULL, 0x000fc600000000ffULL, 0x0000000026677faeULL, 0x0003e8000d101c4cULL,
0x0000000024717faeULL, 0x0007e8000d901c4cULL, 0x0000000022737faeULL, 0x0007e8000e101c4cULL,
0x0000000020757faeULL, 0x0007e2000e901c4cULL, 0x800000005b277824ULL, 0x002fc400078e00ffULL,
0x800000002a267824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000026ff0075a7ULL, 0x0002620008000048ULL, 0x01c61827040075a7ULL, 0x000ea4000804017fULL,
0x00000100003ca947ULL, 0x006fea0003800000ULL, 0x01c080005d207984ULL, 0x008e620000000800ULL,
0x000000016e237812ULL, 0x000fe200078e0cffULL, 0x00000001ff2a7424ULL, 0x000fe400078e00ffULL,
0x01c280005d757984ULL, 0x0004a40000000800ULL, 0x0000400023237824ULL, 0x000fc800078e0204ULL,
0x0001400023547836ULL, 0x000fc80000000000ULL, 0x000000106d677824ULL, 0x000fe200078e0254ULL,
0x000000092000720bULL, 0x002fda0003f5d000ULL, 0x0000000000217806ULL, 0x000fc800010e0100ULL,
0x0000ffff21227812ULL, 0x000fda000784c0ffULL, 0x0000000000cca947ULL, 0x004fea0003800000ULL,
0x000000092000720bULL, 0x000fe40003f54000ULL, 0x0000002009247209ULL, 0x000fca0007810000ULL,
0x8000002409217221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b21217820ULL, 0x000fe40000410000ULL,
0x0000000000097806ULL, 0x000fe400010e0100ULL, 0x000000010e00780cULL, 0x000fe40003f45270ULL,
0x0000ffff09237812ULL, 0x000fe200078e3cffULL, 0x0000002100217308ULL, 0x000e660000000800ULL,
0x0000002322ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff2a7807ULL, 0x000fc60001800000ULL,
0x01c480245d00a388ULL, 0x000fe80000000800ULL, 0x00001f5221097589ULL, 0x002e6400000e0000ULL,
0x8000002420223221ULL, 0x000fe20000010000ULL, 0x000000210c0c7220ULL, 0x000fe20000410000ULL,
0x00001f5121207589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b22223820ULL, 0x000fc80000410000ULL,
0x00000022000a3308ULL, 0x000ee20000000800ULL, 0x000000091c1c7220ULL, 0x082fe20000410000ULL,
0x000000091d1d7220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000948487220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x0000000940407220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000914147220ULL, 0x080fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x000fe20000410000ULL, 0x000000201e1e7220ULL, 0x084fe20000410000ULL,
0x000000201f1f7220ULL, 0x080fe20000410000ULL, 0x0000002046467220ULL, 0x080fe20000410000ULL,
0x0000002047477220ULL, 0x080fe20000410000ULL, 0x000000204a4a7220ULL, 0x080fe20000410000ULL,
0x000000204b4b7220ULL, 0x080fe20000410000ULL, 0x0000002042427220ULL, 0x080fe20000410000ULL,
0x0000002043437220ULL, 0x080fe20000410000ULL, 0x000000202e2e7220ULL, 0x080fe20000410000ULL,
0x000000202f2f7220ULL, 0x080fe20000410000ULL, 0x0000002016167220ULL, 0x080fe20000410000ULL,
0x0000002017177220ULL, 0x080fe20000410000ULL, 0x0000002012127220ULL, 0x080fe20000410000ULL,
0x0000002013137220ULL, 0x080fe20000410000ULL, 0x000000201a1a7220ULL, 0x080fe20000410000ULL,
0x000000201b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff097224ULL, 0x000fc400078e0024ULL,
0x000000750a753220ULL, 0x008fce0000410000ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x000000085c237824ULL, 0x000fc800078e0204ULL, 0x01c64826230075a7ULL, 0x000e64000800017fULL,
0x000000fc00548947ULL, 0x002fea0003800000ULL, 0x000000006724783bULL, 0x000e620000004200ULL,
0x0000000aff2b723eULL, 0x000fe200000010ffULL, 0x0000000c750c7221ULL, 0x000fe20000010000ULL,
0x000000ff68ff7812ULL, 0x000fe4000784c0ffULL, 0x000054102b767816ULL, 0x000fe4000000002bULL,
0x000099102a2b7816ULL, 0x000fc600000000ffULL, 0x00001f52767b7589ULL, 0x000fe200000e0000ULL,
0x000000ff2b00720cULL, 0x000fc60003f05270ULL, 0x00001f51767a7589ULL, 0x000fe200000e0000ULL,
0x0000010024207824ULL, 0x042fe200078e00ffULL, 0x0000888024707816ULL, 0x040fe200000000ffULL,
0x00000100252b7824ULL, 0x040fe200078e00ffULL, 0x0000888025727816ULL, 0x040fe400000000ffULL,
0x00000018ff717819ULL, 0x000fe40000011420ULL, 0x012800003820783bULL, 0x000e620000000200ULL,
0x00000018ff737819ULL, 0x000fe2000001142bULL, 0x00010000252b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011424ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011425ULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x00000018ff2b7819ULL, 0x000fc4000001142bULL, 0x00000018ff247819ULL, 0x000fca0000011424ULL,
0x0000007100717306ULL, 0x000ff00000202400ULL, 0x0000007200727306ULL, 0x000ff00000202400ULL,
0x0000007300257306ULL, 0x000eb00000202400ULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x0000007b20208232ULL, 0x002fc40000200000ULL, 0x0000007b22228232ULL, 0x000fe40000200000ULL,
0x0000007a21218232ULL, 0x080fe20000200000ULL, 0x0000541072257816ULL, 0x004fe40000000025ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x0000007a23238232ULL, 0x000fce0000200000ULL,
0x00000024002a7306ULL, 0x0002b00000202400ULL, 0x0000002b002b7306ULL, 0x000ee20000202400ULL,
0x0000541070247816ULL, 0x002fe20000000071ULL, 0x0000001066707824ULL, 0x000fe200078e0254ULL,
0x0000888027717816ULL, 0x000fca00000000ffULL, 0x00000024201c723cULL, 0x000fe2000004181cULL,
0x0000007100717306ULL, 0x000fec0000202400ULL, 0x000054102a247816ULL, 0x004fe40000000029ULL,
0x000054102b257816ULL, 0x008fe40000000028ULL, 0x0000888026287816ULL, 0x000fca00000000ffULL,
0x000000242044723cULL, 0x000fee0000041844ULL, 0x000000ffff247224ULL, 0x000fe400078e0028ULL,
0x0000010026257824ULL, 0x000fe400078e00ffULL, 0x0000010027287824ULL, 0x000fc400078e00ffULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff727819ULL, 0x000fe40000011428ULL, 0x000000007028783bULL, 0x000e660000004200ULL,
0x0000002500257306ULL, 0x000eb00000202400ULL, 0x0000007200727306ULL, 0x000ee20000202400ULL,
0x0000541024247816ULL, 0x004fc40000000025ULL, 0x0000541071257816ULL, 0x008fe20000000072ULL,
0x0001000027717824ULL, 0x000fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011471ULL,
0x000000242048723cULL, 0x000fea0000041848ULL, 0x0000007600767306ULL, 0x000fe40000202400ULL,
0x00000018ff247819ULL, 0x000fe20000011426ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011427ULL, 0x0000010028727824ULL, 0x042fe200078e00ffULL,
0x0000888028717816ULL, 0x000fc400000000ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000888029737816ULL, 0x000fca00000000ffULL, 0x0000002600277306ULL, 0x000e700000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541027247816ULL, 0x002fe20000000024ULL,
0x0000010029277824ULL, 0x000fcc00078e00ffULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000541076257816ULL, 0x004fca0000000025ULL,
0x0000007200727306ULL, 0x000e640000202400ULL, 0x000000242040723cULL, 0x000fec0000041840ULL,
0x0000007300267306ULL, 0x0005e20000202400ULL, 0x0000541071247816ULL, 0x002fce0000000072ULL,
0x0000002700277306ULL, 0x000e620000202400ULL, 0x000001002b727824ULL, 0x000fe400078e00ffULL,
0x000100002a737824ULL, 0x004fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011472ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000007600727306ULL, 0x000fe20000202400ULL,
0x0000541026257816ULL, 0x002fce0000000027ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x00000024202c723cULL, 0x000fee000004182cULL, 0x00000018ff257819ULL, 0x000fe20000011429ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011428ULL,
0x0001000028287824ULL, 0x000fc600078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011429ULL,
0x000001002a297824ULL, 0x040fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011428ULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x000088802a287816ULL, 0x000fe400000000ffULL,
0x00000018ff717819ULL, 0x000fe40000011429ULL, 0x000088802b297816ULL, 0x000fc600000000ffULL,
0x0000002500257306ULL, 0x000ff00000202400ULL, 0x0000002900297306ULL, 0x000e700000202400ULL,
0x0000002700277306ULL, 0x000ea20000202400ULL, 0x0000541029297816ULL, 0x002fce0000000072ULL,
0x0000002600267306ULL, 0x000e620000202400ULL, 0x00000018ff727819ULL, 0x000fe4000001142aULL,
0x00000018ff2a7819ULL, 0x000fe2000001142bULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000541027247816ULL, 0x004fc60000000024ULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000541026257816ULL, 0x002fca0000000025ULL,
0x0000007100717306ULL, 0x000e640000202400ULL, 0x000000242024723cULL, 0x000fec0000041814ULL,
0x0000007200727306ULL, 0x000ea20000202400ULL, 0x0000541028287816ULL, 0x002fe20000000071ULL,
0x0000001065717824ULL, 0x000fcc00078e0254ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x000000007114783bULL, 0x000e620000004200ULL, 0x000000282010723cULL, 0x000fec0000041810ULL,
0x0000002b002b7306ULL, 0x000ee20000202400ULL, 0x0000541073287816ULL, 0x004fe40000000072ULL,
0x000054102b297816ULL, 0x008fce000000002aULL, 0x000000282018723cULL, 0x000fe20000041818ULL,
0x012800005020783bULL, 0x000eac0000000200ULL, 0x0000010014297824ULL, 0x042fe200078e00ffULL,
0x0000888014287816ULL, 0x000fe200000000ffULL, 0x00000100152b7824ULL, 0x040fe200078e00ffULL,
0x00008880152a7816ULL, 0x000fc400000000ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x00000018ff727819ULL, 0x000fe20000011414ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fc80000011415ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000002900297306ULL, 0x000e700000202400ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x0000007b20208232ULL, 0x004fc40000200000ULL, 0x0000007b22228232ULL, 0x000fe20000200000ULL,
0x0000541028287816ULL, 0x002fc80000000029ULL, 0x0000002b002b7306ULL, 0x000e620000202400ULL,
0x0000007a21218232ULL, 0x080fe40000200000ULL, 0x0000007a23238232ULL, 0x000fca0000200000ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x000054102a297816ULL, 0x002fce000000002bULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x00008880162a7816ULL, 0x000fe200000000ffULL,
0x00000028201c723cULL, 0x000fec000004181cULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x0001000015287824ULL, 0x000fce00078e00ffULL, 0x0000001400157306ULL, 0x0002a20000202400ULL,
0x00000018ff767819ULL, 0x000fe20000011428ULL, 0x0000010016287824ULL, 0x000fcc00078e00ffULL,
0x0000007600767306ULL, 0x000ee20000202400ULL, 0x0000010017147824ULL, 0x042fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe40000011428ULL, 0x0000888017287816ULL, 0x000fe400000000ffULL,
0x00000018ff297819ULL, 0x000fe40000011414ULL, 0x0000002b002b7306ULL, 0x000e620000202400ULL,
0x0000541015147816ULL, 0x004fe20000000072ULL, 0x0000001060727824ULL, 0x000fe200078e0254ULL,
0x0000541076157816ULL, 0x008fca0000000073ULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x0001000017737824ULL, 0x000fe200078e00ffULL, 0x000000142044723cULL, 0x000fe80000041844ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000002900297306ULL, 0x000ea20000202400ULL,
0x000054102a147816ULL, 0x002fce000000002bULL, 0x0000007300767306ULL, 0x000fe20000202400ULL,
0x0000541028157816ULL, 0x004fe40000000029ULL, 0x000000007228783bULL, 0x000e6a0000004200ULL,
0x000000142048723cULL, 0x000fee0000041848ULL, 0x00000018ff147819ULL, 0x000fe20000011416ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fc80000011417ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000001400147306ULL, 0x000ff00000202400ULL,
0x0000001500157306ULL, 0x000eb00000202400ULL, 0x0000001600177306ULL, 0x0002e20000202400ULL,
0x0000541076157816ULL, 0x004fc40000000015ULL, 0x0000888029167816ULL, 0x002fe400000000ffULL,
0x0000541017147816ULL, 0x008fe20000000014ULL, 0x0000010029177824ULL, 0x000fc600078e00ffULL,
0x0000001600167306ULL, 0x000fe40000202400ULL, 0x00000018ff737819ULL, 0x000fe20000011417ULL,
0x000000142040723cULL, 0x000fea0000041840ULL, 0x0000007300737306ULL, 0x000fe40000202400ULL,
0x0000010028157824ULL, 0x040fe200078e00ffULL, 0x0000888028147816ULL, 0x000fc800000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001400147306ULL, 0x000ff00000202400ULL,
0x0000001500157306ULL, 0x000e640000202400ULL, 0x0000541014147816ULL, 0x002fc40000000015ULL,
0x0000541016157816ULL, 0x000fe20000000073ULL, 0x000001002a167824ULL, 0x000fe400078e00ffULL,
0x0000001064737824ULL, 0x000fc800078e0254ULL, 0x00000014202c723cULL, 0x000fee000004182cULL,
0x00000018ff147819ULL, 0x000fe20000011428ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011429ULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011428ULL, 0x0000001400147306ULL, 0x000fe20000202400ULL,
0x00000018ff767819ULL, 0x000fe40000011429ULL, 0x00000018ff297819ULL, 0x000fe40000011416ULL,
0x000088802a287816ULL, 0x000fe400000000ffULL, 0x000088802b167816ULL, 0x000fe200000000ffULL,
0x0000001700177306ULL, 0x000e700000202400ULL, 0x0000001500157306ULL, 0x000fe20000202400ULL,
0x0000541017147816ULL, 0x002fe20000000014ULL, 0x000001002b177824ULL, 0x000fcc00078e00ffULL,
0x0000007600767306ULL, 0x000e620000202400ULL, 0x00000018ff777819ULL, 0x000fce0000011417ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x0000541076157816ULL, 0x002fce0000000015ULL,
0x0000002900297306ULL, 0x000e620000202400ULL, 0x000100002b767824ULL, 0x000fe200078e00ffULL,
0x000000142024723cULL, 0x000fe80000041824ULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x0000001600167306ULL, 0x000fe20000202400ULL, 0x0000541028147816ULL, 0x002fce0000000029ULL,
0x0000007700177306ULL, 0x000e620000202400ULL, 0x00000018ff287819ULL, 0x000fe2000001142aULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc8000001142bULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x0000541016157816ULL, 0x002fce0000000017ULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x000000142010723cULL, 0x000fe20000041810ULL, 0x000000007314783bULL, 0x000e6c0000004200ULL,
0x0000002a002b7306ULL, 0x000eb00000202400ULL, 0x0000007600767306ULL, 0x000ee20000202400ULL,
0x000054102b287816ULL, 0x004fc40000000028ULL, 0x0000541076297816ULL, 0x008fce0000000029ULL,
0x000000282018723cULL, 0x000fe20000041818ULL, 0x012800000f20783bULL, 0x000eac0000000200ULL,
0x0000010014297824ULL, 0x042fe200078e00ffULL, 0x0000888014287816ULL, 0x000fe200000000ffULL,
0x00000100152b7824ULL, 0x040fe200078e00ffULL, 0x00008880152a7816ULL, 0x000fc400000000ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x0000888017767816ULL, 0x000fce00000000ffULL,
0x0000002900297306ULL, 0x000e700000202400ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x0000541028287816ULL, 0x002fce0000000029ULL, 0x0000002b002b7306ULL, 0x000e620000202400ULL,
0x0000007b20208232ULL, 0x084fe40000200000ULL, 0x0000007b22228232ULL, 0x000fe40000200000ULL,
0x0000007a21218232ULL, 0x080fe40000200000ULL, 0x0000007a23238232ULL, 0x000fe20000200000ULL,
0x000054102a297816ULL, 0x002fe2000000002bULL, 0x00000100162a7824ULL, 0x040fe200078e00ffULL,
0x00008880162b7816ULL, 0x000fc800000000ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x00000028201c723cULL, 0x000fe2000004181cULL, 0x0000002b002b7306ULL, 0x000fec0000202400ULL,
0x00000018ff297819ULL, 0x000fe20000011414ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011415ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000002a002a7306ULL, 0x000fe40000202400ULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff157819ULL, 0x000fc80000011415ULL, 0x0000002900297306ULL, 0x000ff00000202400ULL,
0x0000001400147306ULL, 0x000e700000202400ULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x0000541014147816ULL, 0x002fce0000000029ULL, 0x0000001500157306ULL, 0x000e620000202400ULL,
0x0000010017297824ULL, 0x000fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fcc0000011429ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x0000541015157816ULL, 0x002fce0000000028ULL,
0x0000007600287306ULL, 0x0002a20000202400ULL, 0x000000142044723cULL, 0x000fee0000041844ULL,
0x000054102b147816ULL, 0x000fe2000000002aULL, 0x0000001062767824ULL, 0x002fe200078e0254ULL,
0x0000541028157816ULL, 0x004fc80000000029ULL, 0x000000007628783bULL, 0x000e660000004200ULL,
0x000000142048723cULL, 0x000fee0000041848ULL, 0x00000018ff147819ULL, 0x000fe20000011416ULL,
0x0001000016167824ULL, 0x000fca00078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000001400147306ULL, 0x000ff00000202400ULL, 0x0000001600157306ULL, 0x0002a40000202400ULL,
0x0000010028167824ULL, 0x002fe200078e00ffULL, 0x00008880297d7816ULL, 0x000fc400000000ffULL,
0x0000541015147816ULL, 0x004fe40000000014ULL, 0x00000018ff157819ULL, 0x000fe20000011417ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000007d007d7306ULL, 0x000fe60000202400ULL, 0x00000018ff177819ULL, 0x000fca0000011417ULL,
0x0000001500157306ULL, 0x000ff00000202400ULL, 0x0000001700177306ULL, 0x000e700000202400ULL,
0x0000001600777306ULL, 0x000fe20000202400ULL, 0x0000541017157816ULL, 0x002fce0000000015ULL,
0x000000142040723cULL, 0x000fee0000041840ULL, 0x0000888028147816ULL, 0x000fe200000000ffULL,
0x0000010029157824ULL, 0x000fca00078e00ffULL, 0x0000001400147306ULL, 0x000e640000202400ULL,
0x0000541014147816ULL, 0x002fe40000000077ULL, 0x00000018ff777819ULL, 0x000fc80000011415ULL,
0x0000007700157306ULL, 0x0002a40000202400ULL, 0x000088802b777816ULL, 0x002fe400000000ffULL,
0x000054107d157816ULL, 0x004fce0000000015ULL, 0x00000014202c723cULL, 0x000fee000004182cULL,
0x00000018ff147819ULL, 0x000fe20000011428ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011429ULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000001400147306ULL, 0x000fe20000202400ULL,
0x00000018ff297819ULL, 0x000fce0000011429ULL, 0x0000001500157306ULL, 0x000ff00000202400ULL,
0x0000002800177306ULL, 0x000e700000202400ULL, 0x0000002900167306ULL, 0x0004e20000202400ULL,
0x0000541017147816ULL, 0x002fe20000000014ULL, 0x000001002b297824ULL, 0x004fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fc8000001142aULL, 0x00000018ff7d7819ULL, 0x000fe20000011429ULL,
0x000100002a297824ULL, 0x000fe200078e00ffULL, 0x0000541016157816ULL, 0x008fe20000000015ULL,
0x0000001700177306ULL, 0x000fe20000202400ULL, 0x00000018ff167819ULL, 0x000fe2000001142bULL,
0x000100002b2b7824ULL, 0x000fc800078e00ffULL, 0x000000142024723cULL, 0x000fe40000041824ULL,
0x0000001600167306ULL, 0x000fea0000202400ULL, 0x000001002a157824ULL, 0x040fe200078e00ffULL,
0x000088802a147816ULL, 0x000fe400000000ffULL, 0x0000007d002a7306ULL, 0x000fe40000202400ULL,
0x00000018ff287819ULL, 0x000fcc0000011415ULL, 0x0000001400147306ULL, 0x000ff00000202400ULL,
0x0000002800157306ULL, 0x0002a40000202400ULL, 0x00000018ff287819ULL, 0x002fc40000011429ULL,
0x00000018ff297819ULL, 0x000fe4000001142bULL, 0x0000541014147816ULL, 0x004fe40000000015ULL,
0x0000002800287306ULL, 0x000ff00000202400ULL, 0x0000007700157306ULL, 0x0002b00000202400ULL,
0x0000002900297306ULL, 0x000ee20000202400ULL, 0x0000001063777824ULL, 0x002fe200078e0254ULL,
0x0000541015157816ULL, 0x004fce000000002aULL, 0x000000142010723cULL, 0x000fee0000041810ULL,
0x0000541028147816ULL, 0x000fe40000000017ULL, 0x0000541029157816ULL, 0x008fce0000000016ULL,
0x000000142020723cULL, 0x000fe20000041818ULL, 0x000000007714783bULL, 0x000e680000004200ULL,
0x012800005e18783bULL, 0x000ea20000000200ULL, 0x0000010014297824ULL, 0x042fe200078e00ffULL,
0x0000888014287816ULL, 0x000fe200000000ffULL, 0x00000100152b7824ULL, 0x040fe200078e00ffULL,
0x00008880152a7816ULL, 0x000fe200000000ffULL, 0x0000007b18188232ULL, 0x084fe20000200000ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000007b1a1a8232ULL, 0x000fe20000200000ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x0000007a19198232ULL, 0x000fc40000200000ULL, 0x0000007a1b1b8232ULL, 0x000fe20000200000ULL,
0x00008880177a7816ULL, 0x000fe400000000ffULL, 0x000000ff74ff7812ULL, 0x000fe4000780c0ffULL,
0x0000002900297306ULL, 0x000e700000202400ULL, 0x0000002a002a7306ULL, 0x000fe60000202400ULL,
0x00000000003f7886ULL, 0x000fe20000000100ULL, 0x000000016e747812ULL, 0x000fe2000780c0ffULL,
0x000000013f0e7887ULL, 0x000fe2000c000000ULL, 0x0000541028287816ULL, 0x002fc40000000029ULL,
0x0000002b002b7306ULL, 0x000e640000202400ULL, 0x000054102a297816ULL, 0x002fe2000000002bULL,
0x00000100162a7824ULL, 0x040fe200078e00ffULL, 0x00008880162b7816ULL, 0x000fc800000000ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x00000028181c723cULL, 0x000fe2000004181cULL,
0x0000002b002b7306ULL, 0x000fec0000202400ULL, 0x00000018ff297819ULL, 0x000fe20000011414ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011415ULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x0000002a002a7306ULL, 0x000fe40000202400ULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000018ff157819ULL, 0x000fc80000011415ULL,
0x0000002900297306ULL, 0x000ff00000202400ULL, 0x0000001400147306ULL, 0x000e700000202400ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x0000541014147816ULL, 0x002fce0000000029ULL,
0x0000001500157306ULL, 0x000e620000202400ULL, 0x0000010017297824ULL, 0x000fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fcc0000011429ULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x0000541015157816ULL, 0x002fce0000000028ULL, 0x0000007a00287306ULL, 0x0002a20000202400ULL,
0x000000141844723cULL, 0x000fee0000041844ULL, 0x000054102b147816ULL, 0x000fe2000000002aULL,
0x00000010617a7824ULL, 0x002fe200078e0254ULL, 0x0000541028157816ULL, 0x004fc80000000029ULL,
0x000000007a28783bULL, 0x000e620000004200ULL, 0x01c6585f04ff79a7ULL, 0x0005e4000850003fULL,
0x000000141848723cULL, 0x000fe20000041848ULL, 0x01c6205f04ff79a7ULL, 0x0005ec000850003fULL,
0x00000018ff147819ULL, 0x000fe20000011416ULL, 0x0001000016167824ULL, 0x000fca00078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000001400147306ULL, 0x000ff00000202400ULL,
0x0000001600157306ULL, 0x0002e40000202400ULL, 0x0000010028167824ULL, 0x002fe200078e00ffULL,
0x00008880297d7816ULL, 0x000fc400000000ffULL, 0x0000541015147816ULL, 0x008fe40000000014ULL,
0x00000018ff157819ULL, 0x000fe20000011417ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000007d007d7306ULL, 0x000fe60000202400ULL,
0x00000018ff177819ULL, 0x000fca0000011417ULL, 0x0000001500157306ULL, 0x000ff00000202400ULL,
0x0000001700177306ULL, 0x000e700000202400ULL, 0x00000016007b7306ULL, 0x000fe20000202400ULL,
0x0000541017157816ULL, 0x002fce0000000015ULL, 0x000000141840723cULL, 0x000fee0000041840ULL,
0x0000888028147816ULL, 0x000fe200000000ffULL, 0x0000010029157824ULL, 0x000fca00078e00ffULL,
0x0000001400147306ULL, 0x000e640000202400ULL, 0x0000541014147816ULL, 0x002fe4000000007bULL,
0x00000018ff7b7819ULL, 0x000fc80000011415ULL, 0x0000007b00157306ULL, 0x0002e40000202400ULL,
0x000088802b7b7816ULL, 0x002fe400000000ffULL, 0x000054107d157816ULL, 0x008fce0000000015ULL,
0x00000014182c723cULL, 0x000fee000004182cULL, 0x00000018ff147819ULL, 0x000fe20000011428ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011429ULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000001400147306ULL, 0x000fe20000202400ULL, 0x00000018ff297819ULL, 0x000fce0000011429ULL,
0x0000001500157306ULL, 0x000ff00000202400ULL, 0x0000002800177306ULL, 0x000e700000202400ULL,
0x0000002900167306ULL, 0x0007220000202400ULL, 0x0000541017147816ULL, 0x002fe20000000014ULL,
0x000001002b297824ULL, 0x008fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011429ULL,
0x000100002a297824ULL, 0x000fe200078e00ffULL, 0x0000541016157816ULL, 0x010fce0000000015ULL,
0x000000141814723cULL, 0x000fee0000041824ULL, 0x000001002a257824ULL, 0x040fe200078e00ffULL,
0x000088802a247816ULL, 0x000fe400000000ffULL, 0x00000018ff267819ULL, 0x000fe2000001142bULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fc40000011425ULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x00000018ff277819ULL, 0x000fce000001142aULL,
0x0000002800257306ULL, 0x0002f00000202400ULL, 0x0000007d002a7306ULL, 0x0009e20000202400ULL,
0x00000018ff287819ULL, 0x002fe40000011429ULL, 0x00000018ff297819ULL, 0x000fc4000001142bULL,
0x0000541024247816ULL, 0x008fc60000000025ULL, 0x0000002700277306ULL, 0x000fe20000202400ULL,
0x000000ffff7d7224ULL, 0x010fce00078e0074ULL, 0x0000007b00257306ULL, 0x0002f00000202400ULL,
0x0000002600267306ULL, 0x000fe20000202400ULL, 0x00000001ff7b7807ULL, 0x002fe40001000000ULL,
0x0000000b7c007c0cULL, 0x000fe2000bf41070ULL, 0x0000000eff7c7e24ULL, 0x000fe2000f8e00ffULL,
0x0000541025257816ULL, 0x008fc6000000002aULL, 0x0000002800287306ULL, 0x000e680000202400ULL,
0x000000241810723cULL, 0x000fe80000041810ULL, 0x0000002900297306ULL, 0x000ee60000202400ULL,
0x0000541028247816ULL, 0x002fc40000000027ULL, 0x0000541029257816ULL, 0x008fce0000000026ULL,
0x000000241818723cULL, 0x000fee0000041820ULL, 0x000000687b207207ULL, 0x000fc80004000000ULL,
0x0000761020757816ULL, 0x000fe20000000075ULL, 0x0000004c0084a947ULL, 0x004fd80003800000ULL,
0x000000013f0a7887ULL, 0x000fe2000c000000ULL, 0x0000007f59207812ULL, 0x000fe200078ec0ffULL,
0x0000004055557836ULL, 0x000fe20000000000ULL, 0x0000007f53227812ULL, 0x000fe200078ec0ffULL,
0x0000001f0a0f7899ULL, 0x000fe4000800063fULL, 0x0000000120217824ULL, 0x100fe400078e0255ULL,
0x0000000122257824ULL, 0x000fe400078e0255ULL, 0x0000000fff037e24ULL, 0x000fc4000f8e00ffULL,
0x0000010021207825ULL, 0x100fe400078e0078ULL, 0x01c65803040075a7ULL, 0x0002a4000804007fULL,
0x0000010025247825ULL, 0x000fe200078e0078ULL, 0x0000005820207210ULL, 0x000fca0007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200020e0621ULL, 0x000000c002037811ULL, 0x002fc800078e40ffULL,
0x0000000b03067c48ULL, 0x000fca000ffe0000ULL, 0x0000000106067824ULL, 0x000fe400078e0a03ULL,
0x0000001057037824ULL, 0x000fc600078e0254ULL, 0x0000004006067807ULL, 0x000fc80000800000ULL,
0x0000000605067248ULL, 0x000fca0007fe0000ULL, 0x0000000106067824ULL, 0x000fca00078e0a05ULL,
0x000000065a00720cULL, 0x080fe40003f66070ULL, 0x000000065600720cULL, 0x000fe20003f26070ULL,
0x0000000000102947ULL, 0x004fd80003800000ULL, 0x0000001f0a0a7899ULL, 0x000fcc000800063fULL,
0x0000000aff237e24ULL, 0x000fc8000f8e00ffULL, 0x01c65823040075a7ULL, 0x000e64000804017fULL,
0x000000dc00a4a947ULL, 0x002fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020037faeULL, 0x0003e2000d901c4cULL, 0x0000007f4d227812ULL, 0x000fe200078ec0ffULL,
0x000000016f6a7824ULL, 0x000fe200078e026aULL, 0x0000ffff75757812ULL, 0x000fc600078ec0ffULL,
0x0000000122237824ULL, 0x000fe200078e0255ULL, 0x0000007f3e227812ULL, 0x000fe400078ec0ffULL,
0x0000888075757816ULL, 0x000fe400000000ffULL, 0x0000005824207210ULL, 0x002fe20007f5e0ffULL,
0x000000104c037824ULL, 0x000fe200078e0254ULL, 0x0000007f37247812ULL, 0x000fc600078ec0ffULL,
0x000000ffff217224ULL, 0x000fe400010e0625ULL, 0x000000104f257824ULL, 0x000fe400078e0254ULL,
0x0000000124277824ULL, 0x100fe200078e0255ULL, 0x0000007f34247812ULL, 0x000fe400078ec0ffULL,
0x0000000020257faeULL, 0x0003e2000c901c4cULL, 0x000000064e00720cULL, 0x000fe40003f26070ULL,
0x0000000124297824ULL, 0x000fe200078e0255ULL, 0x0000007f31247812ULL, 0x000fe200078ec0ffULL,
0x0000010023207825ULL, 0x002fc800078e0078ULL, 0x0000000122237824ULL, 0x000fe200078e0255ULL,
0x0000005820207210ULL, 0x000fe20007f5e0ffULL, 0x000000103d257824ULL, 0x000fe400078e0254ULL,
0x0000010023227825ULL, 0x000fc800078e0078ULL, 0x000000ffff217224ULL, 0x000fe200010e0621ULL,
0x000000063f00720cULL, 0x000fc80003f46070ULL, 0x0000000020037faeULL, 0x0003e4000c901c4cULL,
0x0000005822207210ULL, 0x002fe40007f3e0ffULL, 0x0000007f3b227812ULL, 0x000fe400078ec0ffULL,
0xffffffff00037811ULL, 0x000fe200078e08ffULL, 0x000000ffff217224ULL, 0x000fe400008e0623ULL,
0x0000000122237824ULL, 0x100fe200078e0255ULL, 0x000000016a227812ULL, 0x000fe200078ec0ffULL,
0x0000000124557824ULL, 0x000fe200078e0255ULL, 0x0000000020257faeULL, 0x0003e2000d101c4cULL,
0x000000063c00720cULL, 0x000fc40003f46070ULL, 0x000000012200780cULL, 0x000fc80003f25070ULL,
0x0000000103037807ULL, 0x000fe20004800000ULL, 0x0000010023207825ULL, 0x002fc800078e0078ULL,
0x000000016a037824ULL, 0x000fe200078e0203ULL, 0x0000005820227210ULL, 0x000fe20007f7e0ffULL,
0x000000103a257824ULL, 0x000fc600078e0254ULL, 0x0000000403007c0cULL, 0x000fe2000bf26070ULL,
0x000000ffff237224ULL, 0x000fe200018e0621ULL, 0x000000063900720cULL, 0x000fe20003f66070ULL,
0x0000010027207825ULL, 0x000fc600078e0078ULL, 0x0000000022257faeULL, 0x0003e2000d101c4cULL,
0x0000001036277824ULL, 0x000fe200078e0254ULL, 0x0000005820207210ULL, 0x000fe40007f9e0ffULL,
0x000000063500720cULL, 0x000fc60003f46070ULL, 0x000000ffff217224ULL, 0x000fca00020e0621ULL,
0x0000000020277faeULL, 0x0005e2000d901c4cULL, 0x0000010029227825ULL, 0x002fc800078e0078ULL,
0x0000001033257824ULL, 0x000fe200078e0254ULL, 0x0000005822227210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x00008c00ff209b82ULL, 0x004e620000000a00ULL,
0x0000000103279824ULL, 0x000fc600078e020dULL, 0x0000000022257faeULL, 0x0005e2000d101c4cULL,
0x000000063200720cULL, 0x000fe20003f46070ULL, 0xffffffffff067424ULL, 0x000fe400078e00ffULL,
0x0000010055227825ULL, 0x004fc600078e0078ULL, 0x0000005822227210ULL, 0x000fe20007f7e0ffULL,
0x0000000427209825ULL, 0x002fc800078e0020ULL, 0x000000ffff237224ULL, 0x000fe200018e0623ULL,
0x0000000c20069981ULL, 0x000362000c1e1900ULL, 0x0000001030277824ULL, 0x000fca00078e0254ULL,
0x0000000022277faeULL, 0x0003e2000d101c4cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x000000ffff257224ULL, 0x000fe400078e0075ULL,
0x800000005b297824ULL, 0x000fe400078e00ffULL, 0x8000000025257824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x000000256c0075a7ULL, 0x0002620008020047ULL,
0x01c62829040075a7ULL, 0x000ea4000804017fULL, 0x000000d80088a947ULL, 0x006fea0003800000ULL,
0x01c100005d207984ULL, 0x000e620000000800ULL, 0x00000001ff2a7424ULL, 0x000fe400078e00ffULL,
0x000000106d247824ULL, 0x000fe200078e0269ULL, 0x01c300005d6a7984ULL, 0x0004a20000000800ULL,
0x000000092000720bULL, 0x002fda0003f5d000ULL, 0x0000000000217806ULL, 0x000fc800010e0100ULL,
0x0000ffff21237812ULL, 0x000fda000784c0ffULL, 0x0000000000cca947ULL, 0x004fea0003800000ULL,
0x000000092000720bULL, 0x000fe40003f54000ULL, 0x0000002009227209ULL, 0x000fca0007810000ULL,
0x8000002209217221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b21217820ULL, 0x000fe40000410000ULL,
0x0000000000097806ULL, 0x000fe400010e0100ULL, 0x000000020e00780cULL, 0x000fe40003f45270ULL,
0x0000ffff09267812ULL, 0x000fe200078e3cffULL, 0x0000002100217308ULL, 0x000e660000000800ULL,
0x0000002623ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff2a7807ULL, 0x000fc60001800000ULL,
0x01c500225d00a388ULL, 0x000fe80000000800ULL, 0x00001f5221097589ULL, 0x002e6400000e0000ULL,
0x8000002220233221ULL, 0x000fe20000010000ULL, 0x000000210c0c7220ULL, 0x000fe20000410000ULL,
0x00001f5121207589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b23233820ULL, 0x000fc80000410000ULL,
0x00000023000a3308ULL, 0x000ee20000000800ULL, 0x000000091c1c7220ULL, 0x082fe20000410000ULL,
0x000000091d1d7220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000948487220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x0000000940407220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000914147220ULL, 0x080fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x000fe20000410000ULL, 0x000000201e1e7220ULL, 0x084fe20000410000ULL,
0x000000201f1f7220ULL, 0x080fe20000410000ULL, 0x0000002046467220ULL, 0x080fe20000410000ULL,
0x0000002047477220ULL, 0x080fe20000410000ULL, 0x000000204a4a7220ULL, 0x080fe20000410000ULL,
0x000000204b4b7220ULL, 0x080fe20000410000ULL, 0x0000002042427220ULL, 0x080fe20000410000ULL,
0x0000002043437220ULL, 0x080fe20000410000ULL, 0x000000202e2e7220ULL, 0x080fe20000410000ULL,
0x000000202f2f7220ULL, 0x080fe20000410000ULL, 0x0000002016167220ULL, 0x080fe20000410000ULL,
0x0000002017177220ULL, 0x080fe20000410000ULL, 0x0000002012127220ULL, 0x080fe20000410000ULL,
0x0000002013137220ULL, 0x080fe20000410000ULL, 0x000000201a1a7220ULL, 0x080fe20000410000ULL,
0x000000201b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff097224ULL, 0x000fc400078e0022ULL,
0x0000006a0a6a3220ULL, 0x008fce0000410000ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x000000016e217812ULL, 0x000fca00078ec0ffULL, 0x0000000821227824ULL, 0x000fc800078e0204ULL,
0x01c64825220075a7ULL, 0x000e64000802017fULL, 0x000000d400a89947ULL, 0x002fea0003800000ULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x0000000aff6d723eULL, 0x000fe200000010ffULL,
0x000000013f0a7887ULL, 0x000fe20008000000ULL, 0x0000000c6a0c7221ULL, 0x000fe20000010000ULL,
0x0000010024207824ULL, 0x042fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011424ULL,
0x00010000242b7824ULL, 0x040fe200078e00ffULL, 0x0000888024547816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011420ULL, 0x013000003820783bULL, 0x000fe20000000200ULL,
0x000054106d247816ULL, 0x000fe2000000006dULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x000099102a6d7816ULL, 0x000fc400000000ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142bULL,
0x00001f52246f7589ULL, 0x000e6200000e0000ULL, 0x0000888025757816ULL, 0x000fe200000000ffULL,
0x000000ffff2b7224ULL, 0x000fe200078e006dULL, 0x00000018ff287819ULL, 0x000fe20000011425ULL,
0x00001f51246d7589ULL, 0x0004e200000e0000ULL, 0x0000005500557306ULL, 0x000ea40000202400ULL,
0x000000ff2b00720cULL, 0x000fe20003f25270ULL, 0x00000100252b7824ULL, 0x040fe400078e00ffULL,
0x0001000025257824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001142bULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000541054247816ULL, 0x004fca0000000055ULL, 0x0000007c007c7306ULL, 0x000ea20000202400ULL,
0x00000018ff557819ULL, 0x000fe40000011426ULL, 0x00000018ff547819ULL, 0x000fca0000011427ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x0000006f20209232ULL, 0x082fe40000200000ULL,
0x0000006f22229232ULL, 0x000fca0000200000ULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x0000006d21219232ULL, 0x088fe40000200000ULL, 0x0000006d23239232ULL, 0x000fca0000200000ULL,
0x0000002a002a7306ULL, 0x000e700000202400ULL, 0x00000025002b7306ULL, 0x0004f00000202400ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x0000541075257816ULL, 0x004fce000000007cULL,
0x00000024201c723cULL, 0x000fe2000004181cULL, 0x0000005400547306ULL, 0x000fec0000202400ULL,
0x000054102a247816ULL, 0x002fe40000000029ULL, 0x000054102b257816ULL, 0x008fe20000000028ULL,
0x0000001066287824ULL, 0x000fc400078e0269ULL, 0x0000010027667824ULL, 0x000fc800078e00ffULL,
0x000000242044723cULL, 0x000fe20000041844ULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x00000018ff667819ULL, 0x000fca0000011466ULL, 0x0000010026257824ULL, 0x040fe200078e00ffULL,
0x0000888026247816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000006600667306ULL, 0x000fe40000202400ULL, 0x00000018ff757819ULL, 0x000fe40000011425ULL,
0x0000888027257816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002400247306ULL, 0x000ff00000202400ULL,
0x0000007500757306ULL, 0x000eb00000202400ULL, 0x0000002500257306ULL, 0x000ee20000202400ULL,
0x0000541024247816ULL, 0x004fce0000000075ULL, 0x0000002600267306ULL, 0x000ea20000202400ULL,
0x00000018ff757819ULL, 0x000fe40000011427ULL, 0x0000541025257816ULL, 0x008fca0000000066ULL,
0x0000007500277306ULL, 0x000ee20000202400ULL, 0x00000018ff667819ULL, 0x002fe20000011429ULL,
0x000000242048723cULL, 0x000fee0000041848ULL, 0x0000541026247816ULL, 0x004fe40000000055ULL,
0x0000541027257816ULL, 0x008fe20000000054ULL, 0x0000010029547824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011428ULL, 0x0000006600267306ULL, 0x0003e60000202400ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x000000242040723cULL, 0x000fe80000041840ULL,
0x0000002700277306ULL, 0x000fe20000202400ULL, 0x000001002b667824ULL, 0x002fc400078e00ffULL,
0x0000010028257824ULL, 0x040fe200078e00ffULL, 0x0000888028247816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x00000018ff557819ULL, 0x000fe20000011425ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000888029257816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fc80000011428ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002400247306ULL, 0x000ff00000202400ULL, 0x0000005500557306ULL, 0x000e700000202400ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541024247816ULL, 0x002fce0000000055ULL,
0x0000002800287306ULL, 0x000e620000202400ULL, 0x00000018ff557819ULL, 0x000fe4000001142aULL,
0x0000541025257816ULL, 0x004fca0000000054ULL, 0x0000002900297306ULL, 0x000ea20000202400ULL,
0x00000018ff547819ULL, 0x000fe2000001142bULL, 0x00000024202c723cULL, 0x000fec000004182cULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000541028247816ULL, 0x002fe40000000027ULL,
0x0000541029257816ULL, 0x004fca0000000026ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x000088802a287816ULL, 0x040fe200000000ffULL, 0x000000242014723cULL, 0x000fec0000041814ULL,
0x0000002800287306ULL, 0x000fe20000202400ULL, 0x000001002a247824ULL, 0x040fe200078e00ffULL,
0x000088802b257816ULL, 0x000fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fca00078e00ffULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011424ULL, 0x0000001065247824ULL, 0x000fe200078e0269ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000000ffff657224ULL, 0x000fe200078e0025ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000002900297306ULL, 0x000e620000202400ULL,
0x000000002424783bULL, 0x000eae0000004200ULL, 0x0000006500657306ULL, 0x000ee20000202400ULL,
0x0000541028287816ULL, 0x002fce0000000029ULL, 0x0000002a002a7306ULL, 0x000e620000202400ULL,
0x0000541065297816ULL, 0x008fce0000000066ULL, 0x0000002b002b7306ULL, 0x000ee20000202400ULL,
0x000000282010723cULL, 0x000fee0000041810ULL, 0x000054102a287816ULL, 0x002fe40000000055ULL,
0x000054102b297816ULL, 0x008fe20000000054ULL, 0x00000100252a7824ULL, 0x044fe200078e00ffULL,
0x0000888025547816ULL, 0x000fc400000000ffULL, 0x00000018ff667819ULL, 0x000fe20000011425ULL,
0x0001000025257824ULL, 0x000fe400078e00ffULL, 0x000000282020723cULL, 0x000fe20000041818ULL,
0x013000005018783bULL, 0x000e620000000200ULL, 0x00000018ff557819ULL, 0x000fe2000001142aULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000888026657816ULL, 0x000fe200000000ffULL, 0x0000010024297824ULL, 0x040fe200078e00ffULL,
0x0000888024287816ULL, 0x000fc600000000ffULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x00000018ff297819ULL, 0x000fce0000011429ULL, 0x0000002800287306ULL, 0x000ff00000202400ULL,
0x0000002900297306ULL, 0x000eb00000202400ULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x0000006f18189232ULL, 0x082fe20000200000ULL, 0x0000541028287816ULL, 0x004fe20000000029ULL,
0x0000006f1a1a9232ULL, 0x000fe20000200000ULL, 0x0000541054297816ULL, 0x000fe20000000055ULL,
0x0000006d19199232ULL, 0x000fc60000200000ULL, 0x0000002500257306ULL, 0x000e620000202400ULL,
0x0000006d1b1b9232ULL, 0x000fe20000200000ULL, 0x0000888027547816ULL, 0x000fcc00000000ffULL,
0x000000281828723cULL, 0x000fe2000004181cULL, 0x0000006500657306ULL, 0x000fec0000202400ULL,
0x00000018ff1c7819ULL, 0x000fe20000011424ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000100261e7824ULL, 0x000fe200078e00ffULL,
0x0000541025257816ULL, 0x002fe20000000066ULL, 0x00000100271f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc40000011424ULL, 0x00000018ff557819ULL, 0x000fe2000001141eULL,
0x00000010601e7824ULL, 0x000fe200078e0269ULL, 0x0000001c001c7306ULL, 0x000fe20000202400ULL,
0x00000018ff607819ULL, 0x000fce000001141fULL, 0x0000001d001d7306ULL, 0x000e700000202400ULL,
0x0000005500557306ULL, 0x000ea20000202400ULL, 0x000054101d247816ULL, 0x002fce000000001cULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x000000001e1c783bULL, 0x000ee20000004200ULL,
0x000000241844723cULL, 0x000fee0000041844ULL, 0x0000541065247816ULL, 0x004fe40000000055ULL,
0x0000541054257816ULL, 0x002fce0000000060ULL, 0x000000241848723cULL, 0x000fee0000041848ULL,
0x00000018ff247819ULL, 0x000fe20000011426ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011427ULL, 0x0001000027277824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002400247306ULL, 0x000fe20000202400ULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x000001001c557824ULL, 0x048fe200078e00ffULL,
0x000088801c547816ULL, 0x000fe200000000ffULL, 0x000001001d667824ULL, 0x000fc800078e00ffULL,
0x0000002500257306ULL, 0x000fe20000202400ULL, 0x000088801d757816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fca0000011455ULL, 0x0000002600657306ULL, 0x000e700000202400ULL,
0x0000002700607306ULL, 0x0004e20000202400ULL, 0x0000541065247816ULL, 0x002fce0000000024ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff277819ULL, 0x004fe40000011466ULL,
0x00000018ff667819ULL, 0x000fe2000001141cULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x0000541060257816ULL, 0x008fc60000000025ULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x00000018ff1c7819ULL, 0x000fc6000001141cULL, 0x000000241840723cULL, 0x000fe80000041840ULL,
0x0000007500267306ULL, 0x0005e60000202400ULL, 0x0000541054247816ULL, 0x002fca0000000055ULL,
0x0000002700277306ULL, 0x000e620000202400ULL, 0x00000018ff757819ULL, 0x004fe4000001141dULL,
0x000088801f547816ULL, 0x000fe400000000ffULL, 0x000088801e557816ULL, 0x000fc600000000ffULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000541026257816ULL, 0x002fce0000000027ULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x00000024182c723cULL, 0x000fee000004182cULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x000100001d247824ULL, 0x000fe400078e00ffULL,
0x000001001e257824ULL, 0x000fca00078e00ffULL, 0x0000001c001d7306ULL, 0x0002a20000202400ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff607819ULL, 0x000fca0000011425ULL,
0x00000024007c7306ULL, 0x0007220000202400ULL, 0x000001001f1c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x0000001064247824ULL, 0x008fcc00078e0269ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x0000001c00657306ULL, 0x0004f00000202400ULL, 0x0000006000607306ULL, 0x000ee20000202400ULL,
0x000054101d1c7816ULL, 0x004fc40000000066ULL, 0x000054107c1d7816ULL, 0x010fce0000000075ULL,
0x0000001c1814723cULL, 0x000fee0000041814ULL, 0x00005410541d7816ULL, 0x008fe40000000065ULL,
0x00000018ff547819ULL, 0x000fe2000001141eULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00005410551c7816ULL, 0x000fc40000000060ULL, 0x00000018ff557819ULL, 0x000fe2000001141fULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe2000001141eULL,
0x0000005400547306ULL, 0x000fe40000202400ULL, 0x0000001c1810723cULL, 0x000fe20000041810ULL,
0x00000018ff607819ULL, 0x000fe4000001141fULL, 0x0000888024667816ULL, 0x042fe400000000ffULL,
0x0000888025757816ULL, 0x000fe200000000ffULL, 0x00000064001d7306ULL, 0x0002a20000202400ULL,
0x00000100241c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe4000001141cULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x0000010025647824ULL, 0x002fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x000054101d547816ULL, 0x004fe20000000054ULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x013000000f1c783bULL, 0x000eae0000000200ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000541060557816ULL, 0x002fce0000000055ULL,
0x0000006500657306ULL, 0x000e620000202400ULL, 0x000000541820723cULL, 0x000fee0000041820ULL,
0x0000007500607306ULL, 0x000fe20000202400ULL, 0x00000018ff547819ULL, 0x000fe20000011424ULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000541066187816ULL, 0x002fca0000000065ULL,
0x0000006400647306ULL, 0x000e620000202400ULL, 0x0000888027557816ULL, 0x000fe400000000ffULL,
0x00000018ff247819ULL, 0x000fca0000011424ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000006f1c1c9232ULL, 0x084fe40000200000ULL, 0x0000006f1e1e9232ULL, 0x000fe40000200000ULL,
0x0000006d1d1d9232ULL, 0x080fe20000200000ULL, 0x0000541060197816ULL, 0x002fe20000000064ULL,
0x0000006d1f1f9232ULL, 0x000fe20000200000ULL, 0x00000018ff647819ULL, 0x000fe20000011425ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x0000888026607816ULL, 0x000fc800000000ffULL,
0x000000181c28723cULL, 0x000fe60000041828ULL, 0x0000006400647306ULL, 0x000fe80000202400ULL,
0x0001000025187824ULL, 0x000fe400078e00ffULL, 0x0000010026197824ULL, 0x000fe400078e00ffULL,
0x0000002400257306ULL, 0x000e620000202400ULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x00000018ff657819ULL, 0x000fe20000011419ULL, 0x0000010027197824ULL, 0x000fc800078e00ffULL,
0x0000001800757306ULL, 0x0004e20000202400ULL, 0x0000541025247816ULL, 0x002fce0000000054ULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x0000001062187824ULL, 0x004fe200078e0269ULL,
0x00000018ff627819ULL, 0x000fca0000011419ULL, 0x000000001818783bULL, 0x000e620000004200ULL,
0x0000006500657306ULL, 0x000ea20000202400ULL, 0x0000541075257816ULL, 0x008fce0000000064ULL,
0x0000006200627306ULL, 0x000ee20000202400ULL, 0x000000241c44723cULL, 0x000fee0000041844ULL,
0x0000541060247816ULL, 0x004fe40000000065ULL, 0x0000541055257816ULL, 0x008fce0000000062ULL,
0x000000241c48723cULL, 0x000fee0000041848ULL, 0x00000018ff247819ULL, 0x000fe20000011426ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011427ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000888018547816ULL, 0x042fe200000000ffULL,
0x0000010018557824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010019627824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x0000888019647816ULL, 0x000fe400000000ffULL, 0x000088801b7c7816ULL, 0x000fc600000000ffULL,
0x0000002500257306ULL, 0x000ff00000202400ULL, 0x0000002600657306ULL, 0x000e700000202400ULL,
0x0000002700607306ULL, 0x0004e20000202400ULL, 0x0000541065247816ULL, 0x002fce0000000024ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff277819ULL, 0x004fe40000011462ULL,
0x00000018ff627819ULL, 0x000fe20000011418ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x000088801a657816ULL, 0x000fe400000000ffULL, 0x0000541060257816ULL, 0x008fe20000000025ULL,
0x0000005500557306ULL, 0x000e620000202400ULL, 0x00000018ff607819ULL, 0x000fe20000011419ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fc60000011418ULL,
0x000000241c40723cULL, 0x000fe20000041840ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000006400267306ULL, 0x000fea0000202400ULL, 0x0000541054247816ULL, 0x002fc60000000055ULL,
0x0000002700277306ULL, 0x000e620000202400ULL, 0x00000018ff557819ULL, 0x000fe4000001141aULL,
0x00000018ff547819ULL, 0x000fca000001141bULL, 0x0000001800757306ULL, 0x0005e20000202400ULL,
0x0000541026257816ULL, 0x002fce0000000027ULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x000001001b187824ULL, 0x004fe200078e00ffULL, 0x000000241c2c723cULL, 0x000fe8000004182cULL,
0x00000018ff667819ULL, 0x000fe40000011418ULL, 0x0000006000607306ULL, 0x000fe20000202400ULL,
0x000001001a247824ULL, 0x040fe400078e00ffULL, 0x000100001a1a7824ULL, 0x000fca00078e00ffULL,
0x0000001900197306ULL, 0x000e620000202400ULL, 0x00000018ff647819ULL, 0x000fe20000011424ULL,
0x0000001063247824ULL, 0x000fe200078e0269ULL, 0x00000018ff187819ULL, 0x000fe2000001141aULL,
0x000100001b1a7824ULL, 0x000fc800078e00ffULL, 0x0000006500657306ULL, 0x000fe20000202400ULL,
0x000000002424783bULL, 0x000ea20000004200ULL, 0x00000018ff7d7819ULL, 0x000fe4000001141aULL,
0x0000541019197816ULL, 0x002fc80000000060ULL, 0x0000006400647306ULL, 0x000e700000202400ULL,
0x0000007c00637306ULL, 0x0007f00000202400ULL, 0x0000006600667306ULL, 0x000f220000202400ULL,
0x0000000aff7c7e24ULL, 0x008fce000f8e00ffULL, 0x00000018001b7306ULL, 0x0007f00000202400ULL,
0x0000005500557306ULL, 0x000e620000202400ULL, 0x0000541075187816ULL, 0x008fe40000000062ULL,
0x0000888026627816ULL, 0x004fc400000000ffULL, 0x00000018ff607819ULL, 0x000fc60000011426ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x000000181c14723cULL, 0x000fee0000041814ULL,
0x0000007d001a7306ULL, 0x0004e20000202400ULL, 0x0000541065187816ULL, 0x002fe40000000064ULL,
0x0000541063197816ULL, 0x010fe20000000066ULL, 0x0000001061637824ULL, 0x000fe200078e0269ULL,
0x00000018ff617819ULL, 0x000fc60000011427ULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x000000016e7d7812ULL, 0x004fe200078e0cffULL, 0x000000181c10723cULL, 0x000fec0000041810ULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x000054101b187816ULL, 0x000fe40000000055ULL,
0x000054101a197816ULL, 0x008fc40000000054ULL, 0x00000018ff557819ULL, 0x000fe40000011424ULL,
0x00000018ff547819ULL, 0x000fe20000011425ULL, 0x0000006100617306ULL, 0x000fe40000202400ULL,
0x000000181c20723cULL, 0x000fe20000041820ULL, 0x013000005e18783bULL, 0x000e6a0000000200ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000100241d7824ULL, 0x040fe200078e00ffULL,
0x00008880241c7816ULL, 0x000fe200000000ffULL, 0x00000100251e7824ULL, 0x000fc400078e00ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141dULL,
0x00008880251d7816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000018ff257819ULL, 0x000fca0000011425ULL,
0x0000002400247306ULL, 0x000eb00000202400ULL, 0x0000002500257306ULL, 0x000ee20000202400ULL,
0x0000541024247816ULL, 0x004fce0000000055ULL, 0x0000001c001c7306ULL, 0x000fe20000202400ULL,
0x0000006f18189232ULL, 0x082fe40000200000ULL, 0x0000006f1a1a9232ULL, 0x000fe40000200000ULL,
0x0000006d19199232ULL, 0x080fe40000200000ULL, 0x0000006d1b1b9232ULL, 0x000fe20000200000ULL,
0x0000001f001f7306ULL, 0x000e620000202400ULL, 0x0000541025257816ULL, 0x008fe20000000054ULL,
0x0000010026547824ULL, 0x000fc400078e00ffULL, 0x0001000026267824ULL, 0x000fc800078e00ffULL,
0x0000001d001d7306ULL, 0x000fe20000202400ULL, 0x000000241844723cULL, 0x000fe20000041844ULL,
0x000054101c1c7816ULL, 0x002fcc000000001fULL, 0x0000001e001e7306ULL, 0x000e620000202400ULL,
0x00000018ff247819ULL, 0x000fe20000011454ULL, 0x0000010027547824ULL, 0x000fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011454ULL, 0x0000002400257306ULL, 0x000ea20000202400ULL,
0x000054101d1d7816ULL, 0x002fce000000001eULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x0000001c181c723cULL, 0x000fe20000041828ULL, 0x000000006328783bULL, 0x0002e20000004200ULL,
0x0000541062247816ULL, 0x004fe20000000025ULL, 0x01c6585f04ff79a7ULL, 0x0005e2000850003fULL,
0x00000018ff627819ULL, 0x000fe40000011426ULL, 0x0000888027637816ULL, 0x002fe200000000ffULL,
0x01c6305f04ff79a7ULL, 0x0005ea000850003fULL, 0x0000006300637306ULL, 0x000e640000202400ULL,
0x0000541063257816ULL, 0x002fcc0000000064ULL, 0x0000006200637306ULL, 0x0006620000202400ULL,
0x000000241848723cULL, 0x000fe20000041848ULL, 0x0000010028627824ULL, 0x008fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fca0000011428ULL, 0x0001000027247824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe4000001142aULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff547819ULL, 0x000fe40000011429ULL, 0x00000018ff267819ULL, 0x000fc6000001142bULL,
0x0000002400647306ULL, 0x0002f00000202400ULL, 0x0000002500277306ULL, 0x0007e20000202400ULL,
0x0000541063247816ULL, 0x002fe20000000060ULL, 0x0000010029637824ULL, 0x000fe200078e00ffULL,
0x0000888028607816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541064257816ULL, 0x008fce0000000061ULL, 0x000000241840723cULL, 0x000fe20000041840ULL,
0x0000006000617306ULL, 0x0003ec0000202400ULL, 0x0000888029257816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x0000006200247306ULL, 0x0007220000202400ULL,
0x00000018ff607819ULL, 0x002fc40000011428ULL, 0x000088802a287816ULL, 0x000fe400000000ffULL,
0x00000018ff297819ULL, 0x000fc60000011429ULL, 0x0000002500257306ULL, 0x000fe20000202400ULL,
0x000001002a627824ULL, 0x048fe400078e00ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x0000541061247816ULL, 0x010fc80000000024ULL, 0x0000006300647306ULL, 0x0002e20000202400ULL,
0x00000018ff2a7819ULL, 0x000fce000001142aULL, 0x0000006000607306ULL, 0x000fe20000202400ULL,
0x00000018ff637819ULL, 0x002fe40000011462ULL, 0x000088802b627816ULL, 0x000fe400000000ffULL,
0x0000541025257816ULL, 0x008fc60000000064ULL, 0x0000002900617306ULL, 0x000e680000202400ULL,
0x00000024182c723cULL, 0x000fe8000004182cULL, 0x0000002800287306ULL, 0x000fe60000202400ULL,
0x000001002b247824ULL, 0x000fc400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x0000006300637306ULL, 0x000ee20000202400ULL, 0x0000541061257816ULL, 0x002fe40000000054ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff297819ULL, 0x000fe4000001142bULL,
0x000000016e2b7812ULL, 0x000fe200078ec0ffULL, 0x0000006200627306ULL, 0x000fe60000202400ULL,
0x000000012b00780cULL, 0x000fc80003f25070ULL, 0x0000007b68687207ULL, 0x000fe20004800000ULL,
0x0000002400657306ULL, 0x0003260000202400ULL, 0x000000ff68ff7812ULL, 0x000fc8000784c0ffULL,
0x00000001ff547807ULL, 0x000fe20001000000ULL, 0x0000002600267306ULL, 0x000fe20000202400ULL,
0x0000541060247816ULL, 0x002fe40000000055ULL, 0x0000007b54757207ULL, 0x000fca0004800000ULL,
0x0000002a002a7306ULL, 0x000e620000202400ULL, 0x000000241814723cULL, 0x000fee0000041814ULL,
0x0000002900297306ULL, 0x000e620000202400ULL, 0x0000541028247816ULL, 0x008fe40000000063ULL,
0x0000541062257816ULL, 0x010fce0000000065ULL, 0x000000241810723cULL, 0x000fee0000041810ULL,
0x000054102a247816ULL, 0x002fe40000000027ULL, 0x0000541029257816ULL, 0x000fce0000000026ULL,
0x000000241818723cULL, 0x000fee0000041820ULL, 0x000000c002207811ULL, 0x000fc800078e40ffULL,
0x0000000b20007c0cULL, 0x000fda000bf41070ULL, 0x000000240074a947ULL, 0x004fea0003800000ULL,
0x01c6586b040075a7ULL, 0x000e62000802007fULL, 0x0000000100207824ULL, 0x000fe400078e0202ULL,
0x0000000606227c24ULL, 0x020fe4000f8e0208ULL, 0x0000000120247836ULL, 0x040fe40000000000ULL,
0x0000010020207824ULL, 0x000fe200078e00ffULL, 0x0000007f22257812ULL, 0x000fe400078ef83bULL,
0x0000007f22237812ULL, 0x000fc400078ef837ULL, 0x0000000b20217c48ULL, 0x000fe4000ffe0000ULL,
0x0000007f22617812ULL, 0x000fe400078ef859ULL, 0x0000007f222b7812ULL, 0x000fe400078ef853ULL,
0x0000007f22297812ULL, 0x000fe200078ef84dULL, 0x0000010061607825ULL, 0x100fe200078e0078ULL,
0x0000007f22277812ULL, 0x000fe400078ef83eULL, 0x0000007f22377812ULL, 0x000fe200078ef834ULL,
0x000001002b2a7825ULL, 0x000fe200078e0078ULL, 0x0000007f223b7812ULL, 0x000fc400078ef831ULL,
0x0000000524007c0cULL, 0x000fe2000bf46070ULL, 0x0000000121317824ULL, 0x000fe400078e0a20ULL,
0x0000010029287825ULL, 0x000fc600078e0078ULL, 0x0000004031347807ULL, 0x000fe20001000000ULL,
0x0000010027267825ULL, 0x000fc800078e0078ULL, 0x0000010025247825ULL, 0x000fc800078e0078ULL,
0x0000010023227825ULL, 0x000fc800078e0078ULL, 0x0000010037207825ULL, 0x000fc800078e0078ULL,
0x000001003b787825ULL, 0x000fe200078e0078ULL, 0x0000000000081947ULL, 0x002fec0003800000ULL,
0x01c6586b040075a7ULL, 0x000e64000802017fULL, 0x000000b400f09947ULL, 0x002fea0003800000ULL,
0x0000003405347248ULL, 0x000fe20007fe0000ULL, 0x0000001057577824ULL, 0x100fe200078e0269ULL,
0x0000005860607210ULL, 0x000fe20007f3e0ffULL, 0x000000104f4f7824ULL, 0x000fe200078e0269ULL,
0x000000582a2a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000134317824ULL, 0x000fe200078e0a05ULL,
0x0000005828287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff617224ULL, 0x000fe200008e0661ULL,
0x0000005826267210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e062bULL,
0x000000315a00720cULL, 0x080fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x000000315600720cULL, 0x080fe20003fa6070ULL, 0x000000ffff277224ULL, 0x000fe200008e0627ULL,
0x000000314e00720cULL, 0x000fe20003f26070ULL, 0x000000104c3b7824ULL, 0x100fe200078e0269ULL,
0x0000005824247210ULL, 0x000fe20007f5e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0269ULL,
0x0000005822227210ULL, 0x000fe20007f7e0ffULL, 0x0000001036377824ULL, 0x000fc400078e0269ULL,
0x000000ffff257224ULL, 0x000fe200010e0625ULL, 0x000000313f00720cULL, 0x080fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000060577faeULL, 0x000fe2000e101c4cULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x000000313c00720cULL, 0x080fe20003f66070ULL,
0x0000001033337824ULL, 0x000fe200078e0269ULL, 0x000000002a4f7faeULL, 0x0005e2000e901c4cULL,
0x0000005820207210ULL, 0x000fe20007fbe0ffULL, 0x800000005b5b7824ULL, 0x000fe200078e00ffULL,
0x000000313900720cULL, 0x080fe20003f86070ULL, 0x00000000283b7faeULL, 0x0003e2000c901c4cULL,
0x000000313200720cULL, 0x080fe20003f26070ULL, 0x000000ffff217224ULL, 0x000fe200028e0621ULL,
0x000000313500720cULL, 0x000fe20003fa6070ULL, 0x000000103a397824ULL, 0x100fe200078e0269ULL,
0x0000005878587210ULL, 0x000fe20007fde0ffULL, 0x0000001030697824ULL, 0x000fe200078e0269ULL,
0x00000000263d7faeULL, 0x0003e2000d101c4cULL, 0x0000ffff752a7812ULL, 0x004fc400078ec0ffULL,
0x000000ffff597224ULL, 0x000fe200030e0679ULL, 0x0000000024397faeULL, 0x0003e4000d901c4cULL,
0x800000002a2a7824ULL, 0x000fe400078e00ffULL, 0x0000000022377faeULL, 0x0003e8000e101c4cULL,
0x0000000020337faeULL, 0x0003e8000e901c4cULL, 0x0000000058697faeULL, 0x0003e2000c901c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a49ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002aff0075a7ULL, 0x0004a20008020048ULL,
0x01c6385b040075a7ULL, 0x000ee4000804017fULL, 0x000000b40038a947ULL, 0x00cfea0003800000ULL,
0x01c180005d207984ULL, 0x002e620000000800ULL, 0x00000001ff567424ULL, 0x000fc600078e00ffULL,
0x01c380005d537984ULL, 0x0004a20000000800ULL, 0x000000092000720bULL, 0x002fda0003f5d000ULL,
0x0000000000217806ULL, 0x000fc800010e0100ULL, 0x0000ffff21227812ULL, 0x000fda000784c0ffULL,
0x0000000000cca947ULL, 0x004fea0003800000ULL, 0x000000092000720bULL, 0x000fe40003f54000ULL,
0x0000002009247209ULL, 0x000fca0007810000ULL, 0x8000002409217221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b21217820ULL, 0x000fe40000410000ULL, 0x0000000000097806ULL, 0x000fe400010e0100ULL,
0x000000030e00780cULL, 0x000fe40003f45270ULL, 0x0000ffff09237812ULL, 0x000fe200078e3cffULL,
0x0000002100217308ULL, 0x000e660000000800ULL, 0x0000002322ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff567807ULL, 0x000fc60001800000ULL, 0x01c580245d00a388ULL, 0x000fe80000000800ULL,
0x00001f5221097589ULL, 0x002e6400000e0000ULL, 0x8000002420223221ULL, 0x000fe20000010000ULL,
0x000000210c0c7220ULL, 0x000fe20000410000ULL, 0x00001f5121207589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b22223820ULL, 0x000fc80000410000ULL, 0x00000022000a3308ULL, 0x000ee20000000800ULL,
0x000000091c1c7220ULL, 0x082fe20000410000ULL, 0x000000091d1d7220ULL, 0x080fe20000410000ULL,
0x0000000944447220ULL, 0x080fe20000410000ULL, 0x0000000945457220ULL, 0x080fe20000410000ULL,
0x0000000948487220ULL, 0x080fe20000410000ULL, 0x0000000949497220ULL, 0x080fe20000410000ULL,
0x0000000940407220ULL, 0x080fe20000410000ULL, 0x0000000941417220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x0000000914147220ULL, 0x080fe20000410000ULL, 0x0000000915157220ULL, 0x080fe20000410000ULL,
0x0000000910107220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x000fe20000410000ULL,
0x000000201e1e7220ULL, 0x084fe20000410000ULL, 0x000000201f1f7220ULL, 0x080fe20000410000ULL,
0x0000002046467220ULL, 0x080fe20000410000ULL, 0x0000002047477220ULL, 0x080fe20000410000ULL,
0x000000204a4a7220ULL, 0x080fe20000410000ULL, 0x000000204b4b7220ULL, 0x080fe20000410000ULL,
0x0000002042427220ULL, 0x080fe20000410000ULL, 0x0000002043437220ULL, 0x080fe20000410000ULL,
0x000000202e2e7220ULL, 0x080fe20000410000ULL, 0x000000202f2f7220ULL, 0x080fe20000410000ULL,
0x0000002016167220ULL, 0x080fe20000410000ULL, 0x0000002017177220ULL, 0x080fe20000410000ULL,
0x0000002012127220ULL, 0x080fe20000410000ULL, 0x0000002013137220ULL, 0x080fe20000410000ULL,
0x000000201a1a7220ULL, 0x080fe20000410000ULL, 0x000000201b1b7220ULL, 0x000fe20000410000ULL,
0x000000ffff097224ULL, 0x000fc400078e0024ULL, 0x000000530a533220ULL, 0x008fce0000410000ULL,
0x00000000000c1947ULL, 0x000fea0003800000ULL, 0x000000085c237824ULL, 0x000fc800078e0204ULL,
0x01c6482a230075a7ULL, 0x000e64000802017fULL, 0x000000b000609947ULL, 0x002fea0003800000ULL,
0x000000007034783bULL, 0x000e620000004200ULL, 0x0000000aff5d723eULL, 0x000fe200000010ffULL,
0x0000000eff7c7e24ULL, 0x000fe2000f8e00ffULL, 0x0000991056567816ULL, 0x000fe200000000ffULL,
0x00000000674c783bULL, 0x000ea20000004200ULL, 0x0000000c530c7221ULL, 0x000fe20000010000ULL,
0x000000ffff7d7224ULL, 0x000fe200078e0074ULL, 0x000000ff5600720cULL, 0x000fe20003f25270ULL,
0x013800003838783bULL, 0x000fe80000000200ULL, 0x000000007328783bULL, 0x0007e80000004200ULL,
0x00000000713c783bULL, 0x0009e20000004200ULL, 0x000054105d737816ULL, 0x008fc6000000005dULL,
0x000000007220783bULL, 0x000fe80000004200ULL, 0x00001f5273527589ULL, 0x000ee800000e0000ULL,
0x000000007630783bULL, 0x000fe20000004200ULL, 0x00000018ff247819ULL, 0x002fe40000011434ULL,
0x00000018ff647819ULL, 0x000fe20000011435ULL, 0x000001004d557824ULL, 0x004fe200078e00ffULL,
0x0000002400717306ULL, 0x0103e20000202400ULL, 0x00000018ff637819ULL, 0x000fc4000001144cULL,
0x00000018ff5a7819ULL, 0x000fe2000001144dULL, 0x0000005238389232ULL, 0x088fe20000200000ULL,
0x000088804c577816ULL, 0x040fe200000000ffULL, 0x000000523a3a9232ULL, 0x000fe20000200000ULL,
0x000088804d5b7816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011455ULL, 0x000001004c247824ULL, 0x042fe200078e00ffULL,
0x00001f5173557589ULL, 0x000e6200000e0000ULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x00000018ff5c7819ULL, 0x000fc40000011424ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x000000007724783bULL, 0x0004e20000004200ULL, 0x00000018ff587819ULL, 0x000fe4000001144eULL,
0x00000018ff597819ULL, 0x000fe2000001144fULL, 0x0000005c005c7306ULL, 0x000f220000202400ULL,
0x00000018ff707819ULL, 0x000fe40000011436ULL, 0x00000018ff6f7819ULL, 0x000fe40000011437ULL,
0x000088803d787816ULL, 0x000fc400000000ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001143cULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x00000018ff6d7819ULL, 0x000fe4000001143dULL,
0x00000018ff6c7819ULL, 0x000fe2000001143eULL, 0x0000005539399232ULL, 0x082fe20000200000ULL,
0x000088803e777816ULL, 0x004fe200000000ffULL, 0x000000553b3b9232ULL, 0x000fe40000200000ULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x0000541057567816ULL, 0x010fc4000000005cULL,
0x00000018ff6a7819ULL, 0x000fe40000011420ULL, 0x00000018ff697819ULL, 0x000fe40000011421ULL,
0x00000018ff687819ULL, 0x000fe20000011422ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x00000018ff6b7819ULL, 0x000fe4000001143fULL, 0x00000018ff677819ULL, 0x000fe40000011423ULL,
0x00000018ff657819ULL, 0x000fc40000011429ULL, 0x00000018ff667819ULL, 0x000fe20000011428ULL,
0x0000007200727306ULL, 0x000e620000202400ULL, 0x00000018ff617819ULL, 0x000fe4000001142bULL,
0x00000018ff627819ULL, 0x000fe4000001142aULL, 0x00000018ff607819ULL, 0x000fe40000011430ULL,
0x00000018ff5d7819ULL, 0x000fe20000011431ULL, 0x0000004c004c7306ULL, 0x000ea20000202400ULL,
0x00000018ff517819ULL, 0x008fc40000011424ULL, 0x00000018ff5c7819ULL, 0x000fe40000011432ULL,
0x000054105b577816ULL, 0x002fc60000000072ULL, 0x0000004d004d7306ULL, 0x000e620000202400ULL,
0x00000018ff5b7819ULL, 0x000fc60000011433ULL, 0x00000056381c723cULL, 0x000fe2000004181cULL,
0x000054104c4c7816ULL, 0x004fc60000000063ULL, 0x0000005800587306ULL, 0x000fe60000202400ULL,
0x000088804e567816ULL, 0x040fe200000000ffULL, 0x000001004e577824ULL, 0x040fe200078e00ffULL,
0x000054104d4d7816ULL, 0x002fe2000000005aULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x000088804f5a7816ULL, 0x040fe200000000ffULL, 0x0000005900597306ULL, 0x000fe20000202400ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff637819ULL, 0x000fe2000001144eULL,
0x0000004c3844723cULL, 0x000fe80000041844ULL, 0x0000005600567306ULL, 0x000fe60000202400ULL,
0x000001004f4d7824ULL, 0x000fc400078e00ffULL, 0x000100004f4f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff4c7224ULL, 0x000fe200078e005aULL, 0x0000006300637306ULL, 0x000e620000202400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff727819ULL, 0x000fe4000001144fULL,
0x00000018ff5a7819ULL, 0x000fc60000011425ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x0000541063587816ULL, 0x002fce0000000058ULL, 0x0000007200727306ULL, 0x000e620000202400ULL,
0x0000010034637824ULL, 0x000fce00078e00ffULL, 0x0000004c00737306ULL, 0x0005e20000202400ULL,
0x0000541072597816ULL, 0x002fce0000000059ULL, 0x0000004d00767306ULL, 0x000e620000202400ULL,
0x00005410564c7816ULL, 0x004fe40000000057ULL, 0x0000888034577816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011426ULL,
0x000000583840723cULL, 0x000fe40000041840ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x00000018ff347819ULL, 0x000fc80000011434ULL, 0x00000018ff587819ULL, 0x000fe20000011463ULL,
0x0000010035637824ULL, 0x000fe200078e00ffULL, 0x00005410734d7816ULL, 0x002fe20000000076ULL,
0x0000003400347306ULL, 0x000e620000202400ULL, 0x0000888035737816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011463ULL,
0x00000018ff637819ULL, 0x000fe20000011427ULL, 0x0000004c384c723cULL, 0x000fe20000041848ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000005700727306ULL, 0x000fe20000202400ULL,
0x000000007a48783bULL, 0x0004e20000004200ULL, 0x0000541034347816ULL, 0x002fcc0000000071ULL,
0x0000003500357306ULL, 0x000e620000202400ULL, 0x0000888036717816ULL, 0x000fe400000000ffULL,
0x000088803c7a7816ULL, 0x004fca00000000ffULL, 0x0000005800597306ULL, 0x000ea20000202400ULL,
0x0000541035357816ULL, 0x002fce0000000064ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x0000010036647824ULL, 0x040fe400078e00ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x000000343814723cULL, 0x000fe20000041814ULL, 0x0000541072587816ULL, 0x004fc60000000059ULL,
0x0000007600767306ULL, 0x000e620000202400ULL, 0x0000888037727816ULL, 0x040fe400000000ffULL,
0x0000010037357824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc80000011464ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00000018ff577819ULL, 0x008fe40000011448ULL,
0x00000018ff647819ULL, 0x000fe4000001144bULL, 0x0000541073597816ULL, 0x002fc60000000076ULL,
0x0000003400347306ULL, 0x000e620000202400ULL, 0x00000018ff737819ULL, 0x000fe40000011435ULL,
0x00000018ff357819ULL, 0x000fe20000011436ULL, 0x0001000037367824ULL, 0x000fe200078e00ffULL,
0x00000058382c723cULL, 0x000fe6000004182cULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x00000018ff587819ULL, 0x000fe4000001144aULL,
0x0000541071347816ULL, 0x002fe40000000034ULL, 0x0000007300737306ULL, 0x000e620000202400ULL,
0x00000018ff597819ULL, 0x000fce0000011449ULL, 0x0000003500377306ULL, 0x0003f00000202400ULL,
0x0000007000707306ULL, 0x000ea20000202400ULL, 0x0000541072357816ULL, 0x002fe40000000073ULL,
0x000088803f727816ULL, 0x000fca00000000ffULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000000343810723cULL, 0x000fee0000041810ULL, 0x0000003600367306ULL, 0x000e620000202400ULL,
0x000001003c347824ULL, 0x000fe400078e00ffULL, 0x000001003d357824ULL, 0x000fc400078e00ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff717819ULL, 0x000fe20000011435ULL, 0x000100003c357824ULL, 0x000fe200078e00ffULL,
0x0000003400797306ULL, 0x0005f00000202400ULL, 0x0000007a007a7306ULL, 0x000ee20000202400ULL,
0x0000541037347816ULL, 0x004fc40000000070ULL, 0x00000018ff707819ULL, 0x000fe40000011435ULL,
0x0000541036357816ULL, 0x002fc6000000006fULL, 0x0000007800787306ULL, 0x000fe80000202400ULL,
0x000000343818723cULL, 0x000fe20000041818ULL, 0x013800005034783bULL, 0x000e660000000200ULL,
0x00000071003c7306ULL, 0x000ea60000202400ULL, 0x000001003e387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143dULL, 0x000001003f397824ULL, 0x000fe200078e00ffULL,
0x00008880203d7816ULL, 0x000fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x00000100203b7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0001000020207824ULL, 0x000fc400078e00ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003800767306ULL, 0x0007e20000202400ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff3f7819ULL, 0x000fca000001143fULL, 0x0000003900737306ULL, 0x0005e20000202400ULL,
0x000054107a387816ULL, 0x008fe40000000079ULL, 0x0000888029797816ULL, 0x000fca00000000ffULL,
0x0000006d006d7306ULL, 0x000fe20000202400ULL, 0x0000541078397816ULL, 0x004fe4000000003cULL,
0x0000888028787816ULL, 0x000fe200000000ffULL, 0x0000005234349232ULL, 0x082fe40000200000ULL,
0x0000005236369232ULL, 0x000fe40000200000ULL, 0x0000005535359232ULL, 0x080fe20000200000ULL,
0x00000070006f7306ULL, 0x000e620000202400ULL, 0x0000005537379232ULL, 0x000fce0000200000ULL,
0x0000003a003a7306ULL, 0x000ea20000202400ULL, 0x00000038341c723cULL, 0x000fee000004181cULL,
0x0000003e00717306ULL, 0x0007e20000202400ULL, 0x0000010021387824ULL, 0x000fe400078e00ffULL,
0x0000010022397824ULL, 0x000fc600078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011438ULL,
0x0000003b00707306ULL, 0x000fe20000202400ULL, 0x00008880213e7816ULL, 0x048fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000888022387816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x00000020003c7306ULL, 0x0003f00000202400ULL, 0x00000021003b7306ULL, 0x0005e20000202400ULL,
0x000054106f207816ULL, 0x002fce000000006eULL, 0x0000007700777306ULL, 0x000e620000202400ULL,
0x000054103a217816ULL, 0x004fe2000000006dULL, 0x00000100286d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe20000011439ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x0000888023397816ULL, 0x000fe400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000007200727306ULL, 0x000ea20000202400ULL, 0x000000203444723cULL, 0x000fe20000041844ULL,
0x00000018ff287819ULL, 0x000fcc0000011428ULL, 0x0000010023207824ULL, 0x040fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x0001000023217824ULL, 0x000fc600078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011420ULL, 0x00000018ff207819ULL, 0x000fe40000011422ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000006b006b7306ULL, 0x000ff00000202400ULL,
0x0000002000237306ULL, 0x0003f00000202400ULL, 0x0000002100227306ULL, 0x0005e20000202400ULL,
0x0000541077207816ULL, 0x002fce0000000076ULL, 0x0000003f003f7306ULL, 0x000e620000202400ULL,
0x0000541072217816ULL, 0x004fce0000000073ULL, 0x00000020344c723cULL, 0x000fe2000004184cULL,
0x0000003d003d7306ULL, 0x000fec0000202400ULL, 0x0000010029207824ULL, 0x000fe200078e00ffULL,
0x000054103f217816ULL, 0x002fe2000000006bULL, 0x0000003e003e7306ULL, 0x000fe20000202400ULL,
0x0001000029297824ULL, 0x000fc400078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x000001002a6b7824ULL, 0x000fe400078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000020007a7306ULL, 0x0003e20000202400ULL, 0x00000018ff6b7819ULL, 0x000fce000001146bULL,
0x0000005000507306ULL, 0x000ea20000202400ULL, 0x0000541071207816ULL, 0x002fe4000000006cULL,
0x000088802a6c7816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x000088802b717816ULL, 0x000fc600000000ffULL, 0x000000203440723cULL, 0x000fe20000041840ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x00000018ff2a7819ULL, 0x000fca000001142aULL,
0x000001002b207824ULL, 0x040fe200078e00ffULL, 0x000054103e217816ULL, 0x004fe20000000050ULL,
0x0000006900697306ULL, 0x000e620000202400ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000888031507816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000002000727306ULL, 0x0005f00000202400ULL,
0x0000006c003f7306ULL, 0x000fe20000202400ULL, 0x000054103d207816ULL, 0x004fce0000000070ULL,
0x00000020342c723cULL, 0x000fe2000004182cULL, 0x0000003800387306ULL, 0x000fec0000202400ULL,
0x0000010031207824ULL, 0x000fe200078e00ffULL, 0x000054103b217816ULL, 0x002fe20000000069ULL,
0x0000003a003a7306ULL, 0x000fe20000202400ULL, 0x00008880333b7816ULL, 0x000fe200000000ffULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fca0000011420ULL,
0x00000020006c7306ULL, 0x0003f00000202400ULL, 0x0000003900397306ULL, 0x000fe20000202400ULL,
0x000054103c207816ULL, 0x002fce000000006aULL, 0x0000006f006f7306ULL, 0x000e620000202400ULL,
0x000000203414723cULL, 0x000fee0000041814ULL, 0x0000010033207824ULL, 0x040fe200078e00ffULL,
0x0000006800687306ULL, 0x000ea20000202400ULL, 0x0001000033337824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000541039217816ULL, 0x002fe4000000006fULL,
0x0000006700677306ULL, 0x000e620000202400ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x00008880266f7816ULL, 0x000fe400000000ffULL, 0x0000541023687816ULL, 0x004fc60000000068ULL,
0x00000020003c7306ULL, 0x0005e20000202400ULL, 0x0000541022697816ULL, 0x002fce0000000067ULL,
0x0000002900767306ULL, 0x0003e20000202400ULL, 0x0000541038207816ULL, 0x004fce000000003aULL,
0x000000203410723cULL, 0x000fe20000041810ULL, 0x00000033003a7306ULL, 0x000fe20000202400ULL,
0x0000010030297824ULL, 0x002fc800078e00ffULL, 0x000000683434723cULL, 0x000fe20000041818ULL,
0x0000888025207816ULL, 0x040fe200000000ffULL, 0x0000010025217824ULL, 0x040fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000007800787306ULL, 0x000fe20000202400ULL,
0x0001000025257824ULL, 0x000fe400078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011421ULL,
0x0000010026187824ULL, 0x040fe200078e00ffULL, 0x0000888027697816ULL, 0x040fe200000000ffULL,
0x0000010027197824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000002000337306ULL, 0x0003e20000202400ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x00000100481a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fc40000011419ULL, 0x00000018ff197819ULL, 0x000fe40000011426ULL,
0x0000006d007b7306ULL, 0x000ea20000202400ULL, 0x013800000f20783bULL, 0x0022e20000000200ULL,
0x00000018ff687819ULL, 0x000fcc000001141aULL, 0x0000007900797306ULL, 0x000f220000202400ULL,
0x00010000270f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe4000001140fULL,
0x00000029006d7306ULL, 0x0003e20000202400ULL, 0x00008880480f7816ULL, 0x040fe200000000ffULL,
0x0001000048487824ULL, 0x000fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000002800777306ULL, 0x000be20000202400ULL, 0x0000010032297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000006b00737306ULL, 0x000fe20000202400ULL,
0x0000888030287816ULL, 0x060fe200000000ffULL, 0x0001000030307824ULL, 0x000fcc00078e00ffULL,
0x0000002b006b7306ULL, 0x0003e20000202400ULL, 0x0000005220209232ULL, 0x088fe40000200000ULL,
0x0000005222229232ULL, 0x000fe40000200000ULL, 0x0000005521219232ULL, 0x080fe40000200000ULL,
0x0000005523239232ULL, 0x000fe20000200000ULL, 0x00000029003e7306ULL, 0x0007e20000202400ULL,
0x00000018ff2b7819ULL, 0x002fe40000011430ULL, 0x00000018ff307819ULL, 0x000fe20000011431ULL,
0x0000010024317824ULL, 0x000fc800078e00ffULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x0000888024297816ULL, 0x048fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc80000011431ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x00000018006a7306ULL, 0x0005f00000202400ULL, 0x0000001900277306ULL, 0x0009e20000202400ULL,
0x0000541078187816ULL, 0x004fce000000007bULL, 0x0000002a006e7306ULL, 0x0003e20000202400ULL,
0x0000541079197816ULL, 0x010fce000000007aULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x00008880322a7816ULL, 0x042fe200000000ffULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018201c723cULL, 0x000fe2000004181cULL, 0x013800005e18783bULL, 0x000e620000000200ULL,
0x01c6585f04ff79a7ULL, 0x0005e4000850003fULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000006100617306ULL, 0x000fe20000202400ULL, 0x01c6405f04ff79a7ULL, 0x0005ee000850003fULL,
0x0000002400317306ULL, 0x0007f00000202400ULL, 0x0000006600667306ULL, 0x000f220000202400ULL,
0x0000888049247816ULL, 0x008fce00000000ffULL, 0x0000006500657306ULL, 0x000ee20000202400ULL,
0x0000541077667816ULL, 0x010fce0000000066ULL, 0x00000032003d7306ULL, 0x000fe20000202400ULL,
0x0000005218189232ULL, 0x082fe40000200000ULL, 0x000000521a1a9232ULL, 0x000fe20000200000ULL,
0x0000541076677816ULL, 0x008fc80000000065ULL, 0x0000002500327306ULL, 0x0003e20000202400ULL,
0x0000005519199232ULL, 0x080fe40000200000ULL, 0x0000010049657824ULL, 0x040fe400078e00ffULL,
0x000000551b1b9232ULL, 0x000fe40000200000ULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x000000662044723cULL, 0x000fe20000041844ULL, 0x00000024005e7306ULL, 0x0007e20000202400ULL,
0x0000541071257816ULL, 0x002fc40000000072ULL, 0x00000018ff497819ULL, 0x000fca0000011449ULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x000054103f247816ULL, 0x008fe40000000073ULL,
0x00000018ff3f7819ULL, 0x000fca0000011465ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x00000024204c723cULL, 0x000fee000004184cULL, 0x0000002b002b7306ULL, 0x000e620000202400ULL,
0x000054106e247816ULL, 0x000fe40000000062ULL, 0x000054106b257816ULL, 0x000fca0000000061ULL,
0x0000003000307306ULL, 0x000ee40000202400ULL, 0x000000242040723cULL, 0x000fe20000041840ULL,
0x000054102b607816ULL, 0x002fca0000000060ULL, 0x0000005c005c7306ULL, 0x000e620000202400ULL,
0x0000541030617816ULL, 0x008fce000000005dULL, 0x0000005b005b7306ULL, 0x000ee20000202400ULL,
0x000000602014723cULL, 0x000fe20000041814ULL, 0x000054103d5c7816ULL, 0x002fcc000000005cULL,
0x0000002800287306ULL, 0x000e620000202400ULL, 0x000054103a5d7816ULL, 0x008fce000000005bULL,
0x0000005000507306ULL, 0x000ee20000202400ULL, 0x0000005c2034723cULL, 0x000fe20000041834ULL,
0x0000541028247816ULL, 0x002fcc000000006dULL, 0x0000002a002a7306ULL, 0x000e620000202400ULL,
0x000001004a287824ULL, 0x000fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000003b003b7306ULL, 0x000f220000202400ULL, 0x0000541050257816ULL, 0x008fe4000000006cULL,
0x000054102a2a7816ULL, 0x002fca000000003eULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x00000024202c723cULL, 0x000fe2000004182cULL, 0x000054103b2b7816ULL, 0x010fcc000000003cULL,
0x0000003800387306ULL, 0x000e620000202400ULL, 0x000088804a257816ULL, 0x040fe200000000ffULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x0000002a2010723cULL, 0x000fea0000041810ULL,
0x0000005100517306ULL, 0x000fe40000202400ULL, 0x000001004b207824ULL, 0x040fe200078e00ffULL,
0x000088804b2a7816ULL, 0x000fca00000000ffULL, 0x0000005a005a7306ULL, 0x000ee20000202400ULL,
0x0000541029387816ULL, 0x002fe40000000038ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff237819ULL, 0x000fc6000001144aULL, 0x0000005600567306ULL, 0x000e620000202400ULL,
0x0000541032217816ULL, 0x008fce000000005aULL, 0x0000006300637306ULL, 0x000ff00000202400ULL,
0x0000002600267306ULL, 0x000ff00000202400ULL, 0x0000002000297306ULL, 0x0007f00000202400ULL,
0x0000002a00227306ULL, 0x000f220000202400ULL, 0x0000541031207816ULL, 0x008fce0000000051ULL,
0x000000201844723cULL, 0x000fe20000041844ULL, 0x0000005700577306ULL, 0x000fec0000202400ULL,
0x000100004b217824ULL, 0x000fe200078e00ffULL, 0x0000541027207816ULL, 0x002fe20000000056ULL,
0x0000005900597306ULL, 0x000fe20000202400ULL, 0x0000541022297816ULL, 0x010fc40000000029ULL,
0x00000018ff2a7819ULL, 0x000fe40000011421ULL, 0x0000541026217816ULL, 0x000fc60000000063ULL,
0x0000003900397306ULL, 0x000e680000202400ULL, 0x000000201840723cULL, 0x000fe80000041840ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x0000541033397816ULL, 0x002fce0000000039ULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x00000038181c723cULL, 0x000fee000004181cULL,
0x0000007000707306ULL, 0x000ff00000202400ULL, 0x0000000f000f7306ULL, 0x000ff00000202400ULL,
0x0000006800687306ULL, 0x000e700000202400ULL, 0x0000003f003f7306ULL, 0x000ee20000202400ULL,
0x000054100f3e7816ULL, 0x002fce0000000068ULL, 0x0000004800627306ULL, 0x0003220000202400ULL,
0x00009910750f7816ULL, 0x000fc800000000ffULL, 0x000000ff0f00720cULL, 0x000fe40003f25270ULL,
0x000054105e3f7816ULL, 0x008fe2000000003fULL, 0x0000004900247306ULL, 0x0007620000202400ULL,
0x000054106f487816ULL, 0x002fe4000000006aULL, 0x00000001ff548807ULL, 0x000fc60000800000ULL,
0x0000003e182c723cULL, 0x000fe2000004182cULL, 0x0000541062627816ULL, 0x010fe20000000057ULL,
0x0000002500257306ULL, 0x000fe20000202400ULL, 0x0000541069497816ULL, 0x008fe40000000070ULL,
0x0000761054757816ULL, 0x000fe40000000075ULL, 0x0000541024637816ULL, 0x020fc60000000059ULL,
0x0000002800287306ULL, 0x000e620000202400ULL, 0x000000481848723cULL, 0x000fec000004184cULL,
0x000000621814723cULL, 0x000fe20000041814ULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x0000541025287816ULL, 0x002fce0000000028ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x000000281810723cULL, 0x000fee0000041810ULL, 0x0000002300237306ULL, 0x000e700000202400ULL,
0x0000002a00217306ULL, 0x000ee20000202400ULL, 0x0000541023587816ULL, 0x002fc40000000058ULL,
0x0000541021597816ULL, 0x008fce0000000064ULL, 0x000000581818723cULL, 0x004fde0000041834ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000100027824ULL, 0x000fe200078e0202ULL,
0x000000ff0bff7812ULL, 0x000fc8000780c0ffULL, 0x0000000502007c0cULL, 0x000fe4000bf26070ULL,
0x00000001ff0b7807ULL, 0x000fd60000000000ULL, 0xffffff5800cc9947ULL, 0x020fea000383ffffULL,
0x0000000000057919ULL, 0x000e620000002500ULL, 0x000000ffff067224ULL, 0x000fe400078e0019ULL,
0x000000ffff077224ULL, 0x000fe400078e0018ULL, 0x000000ffff227224ULL, 0x000fe400078e001eULL,
0x000000ffff207224ULL, 0x000fe400078e001dULL, 0x000000ffff2b7224ULL, 0x000fe200078e001cULL,
0x0000000505007c0cULL, 0x002fda000bf06070ULL, 0x0000000000d80947ULL, 0x000fea0003800000ULL,
0x018000000c027836ULL, 0x000fe20000000000ULL, 0x000000c000007945ULL, 0x000fe80003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000ba9000087802ULL, 0x000fce0000000f00ULL,
0x0000009800a87944ULL, 0x000fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e000aULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000c00037308ULL, 0x000e640000001000ULL,
0xbf80000003027423ULL, 0x002fc8000000000cULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203087223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009400ff027b82ULL, 0x000ea40000000a00ULL, 0x0000000c02037981ULL, 0x004ea2000c1e9900ULL,
0x00000000000b7919ULL, 0x000ee40000000000ULL, 0x00000002ff0d7819ULL, 0x008fe4000001160bULL,
0x000000080b0b7811ULL, 0x000fe200078ff0ffULL, 0x0000000803087220ULL, 0x004fca0000410000ULL,
0x00001f0d080a7589ULL, 0x000ea800000e0000ULL, 0x00001f0b08187589ULL, 0x000ee200000e0000ULL,
0x0000002b0a2b7220ULL, 0x044fe20000410000ULL, 0x000000200a207220ULL, 0x040fe20000410000ULL,
0x000000440a447220ULL, 0x040fe20000410000ULL, 0x000000450a457220ULL, 0x040fe20000410000ULL,
0x000000480a487220ULL, 0x040fe20000410000ULL, 0x000000490a497220ULL, 0x040fe20000410000ULL,
0x000000400a407220ULL, 0x040fe20000410000ULL, 0x000000410a417220ULL, 0x040fe20000410000ULL,
0x0000002c0a2c7220ULL, 0x040fe20000410000ULL, 0x0000002d0a2d7220ULL, 0x040fe20000410000ULL,
0x000000140a147220ULL, 0x040fe20000410000ULL, 0x000000150a157220ULL, 0x040fe20000410000ULL,
0x000000100a107220ULL, 0x040fe20000410000ULL, 0x000000110a117220ULL, 0x040fe20000410000ULL,
0x000000070a077220ULL, 0x040fe20000410000ULL, 0x000000060a067220ULL, 0x000fe20000410000ULL,
0x0000002218227220ULL, 0x048fe20000410000ULL, 0x0000001f181f7220ULL, 0x040fe20000410000ULL,
0x0000004618467220ULL, 0x040fe20000410000ULL, 0x0000004718477220ULL, 0x040fe20000410000ULL,
0x0000004a184a7220ULL, 0x040fe20000410000ULL, 0x0000004b184b7220ULL, 0x040fe20000410000ULL,
0x0000004218427220ULL, 0x040fe20000410000ULL, 0x0000004318437220ULL, 0x040fe20000410000ULL,
0x0000002e182e7220ULL, 0x040fe20000410000ULL, 0x0000002f182f7220ULL, 0x040fe20000410000ULL,
0x0000001618167220ULL, 0x040fe20000410000ULL, 0x0000001718177220ULL, 0x040fe20000410000ULL,
0x0000001218127220ULL, 0x040fe20000410000ULL, 0x0000001318137220ULL, 0x040fe20000410000ULL,
0x0000001a181a7220ULL, 0x040fe20000410000ULL, 0x0000001b181b7220ULL, 0x000fce0000410000ULL,
0x0000000000197919ULL, 0x000ea20000000000ULL, 0x000000404140723eULL, 0x000fe400000010ffULL,
0x0000002c2d2c723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000141514723eULL, 0x000fe400000010ffULL, 0x000000101110723eULL, 0x000fe400000010ffULL,
0x000000221f1f723eULL, 0x000fe400000010ffULL, 0x000000464746723eULL, 0x000fc400000010ffULL,
0x0000004a4b4a723eULL, 0x000fe400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000161717723eULL, 0x000fe400000010ffULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fc400000010ffULL,
0x000054102e167816ULL, 0x140fe40000000017ULL, 0x000076322e177816ULL, 0x000fe40000000017ULL,
0x0000000219027812ULL, 0x004fe400078ec0ffULL, 0x00000002ff217819ULL, 0x000fe40000011619ULL,
0x0000000402187811ULL, 0x000fe400078ff8ffULL, 0x00000001ff037819ULL, 0x000fc40000011602ULL,
0x0000000202087811ULL, 0x040fe400078ff8ffULL, 0x0000000819297811ULL, 0x000fe400078ff0ffULL,
0x00000006021c7811ULL, 0x000fe400078ff8ffULL, 0x00000007180f7812ULL, 0x000fe400078e7821ULL,
0x0000000703027812ULL, 0x000fe400078e7821ULL, 0x00000007080a7812ULL, 0x000fe200078e7821ULL,
0x00000008211d7824ULL, 0x000fe200078e020fULL, 0x000000071c1e7812ULL, 0x000fe200078e7821ULL,
0x000008000e0f7824ULL, 0x000fe200078e0204ULL, 0x0000000703037812ULL, 0x000fe200078e7829ULL,
0x0000000819047824ULL, 0x000fe200078e00ffULL, 0x0000000708087812ULL, 0x000fe200078e7829ULL,
0x00000008210b7824ULL, 0x040fe200078e0202ULL, 0x0000000718187812ULL, 0x000fe200078e7829ULL,
0x00000008210d7824ULL, 0x000fe200078e020aULL, 0x000000071c1c7812ULL, 0x000fe200078e7829ULL,
0x0000000829237824ULL, 0x040fe200078e0203ULL, 0x0000000804047812ULL, 0x000fe200078ec0ffULL,
0x0000000829257824ULL, 0x040fe200078e0208ULL, 0x0000002b2002723eULL, 0x000fe200000010ffULL,
0x0000000829277824ULL, 0x000fe200078e0218ULL, 0x000000444503723eULL, 0x000fe200000010ffULL,
0x0000000821217824ULL, 0x000fe200078e021eULL, 0x000000070608723eULL, 0x000fe200000010ffULL,
0x0000000829297824ULL, 0x000fe200078e021cULL, 0x0000541002247816ULL, 0x000fe20000000003ULL,
0x000120000f187836ULL, 0x000fe20000000000ULL, 0x000054101f1e7816ULL, 0x000fc40000000046ULL,
0x000076321f1f7816ULL, 0x000fe20000000046ULL, 0x000000100b0b7824ULL, 0x100fe400078e0218ULL,
0x000000100d0d7824ULL, 0x100fe400078e0218ULL, 0x000000101d1d7824ULL, 0x100fe400078e0218ULL,
0x0000001023237824ULL, 0x100fe400078e0218ULL, 0x0000001025257824ULL, 0x100fe400078e0218ULL,
0x0000001021217824ULL, 0x000fc400078e0218ULL, 0x0000001027277824ULL, 0x100fe400078e0218ULL,
0x0000001029297824ULL, 0x000fe400078e0218ULL, 0x000000010b0b7824ULL, 0x000fe400078e0204ULL,
0x00000001040d7824ULL, 0x040fe400078e020dULL, 0x00000001041d7824ULL, 0x040fe400078e021dULL,
0x0000000104237824ULL, 0x000fc400078e0223ULL, 0x00000001040a7824ULL, 0x000fe200078e0225ULL,
0x0000763202257816ULL, 0x000fe20000000003ULL, 0x0000000104217824ULL, 0x040fe400078e0221ULL,
0x0000000104277824ULL, 0x040fe400078e0227ULL, 0x0000000104297824ULL, 0x000fe200078e0229ULL,
0x000000484904723eULL, 0x000fe200000010ffULL, 0x000000240b007388ULL, 0x0005e60000000a00ULL,
0x0000541004027816ULL, 0x000fc40000000040ULL, 0x0000763204037816ULL, 0x000fca0000000040ULL,
0x000000020d007388ULL, 0x0007e20000000a00ULL, 0x000000424325723eULL, 0x004fc800000010ffULL,
0x000054104a247816ULL, 0x140fe40000000025ULL, 0x000076324a257816ULL, 0x000fe40000000025ULL,
0x000054102c027816ULL, 0x148fe40000000014ULL, 0x000076322c037816ULL, 0x000fca0000000014ULL,
0x000000021d007388ULL, 0x0005e40000000a00ULL, 0x0000541010027816ULL, 0x144fe40000000008ULL,
0x0000763210037816ULL, 0x000fca0000000008ULL, 0x0000000221007388ULL, 0x0005e80000000a00ULL,
0x0000001e23007388ULL, 0x0007e80000000a00ULL, 0x000000240a007388ULL, 0x0007e20000000a00ULL,
0x0000541012027816ULL, 0x004fc6000000001aULL, 0x0000001627007388ULL, 0x0007e20000000a00ULL,
0x0000763212037816ULL, 0x000fca000000001aULL, 0x0000000229007388ULL, 0x0007e20000000a00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002400888947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000ea20000002700ULL, 0x00008400ff117b82ULL, 0x000ea20000000800ULL,
0x00000010190b7824ULL, 0x040fe200078e020fULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x0000000000027919ULL, 0x008ea20000002600ULL, 0x0000002019297836ULL, 0x040fe20000000000ULL,
0x00000400001b7802ULL, 0x000fe20000000f00ULL, 0x00000040192b7836ULL, 0x040fe20000000000ULL,
0x012200000b147984ULL, 0x0006e20000000c00ULL, 0x00009200ff037b82ULL, 0x000f220000000800ULL,
0x00000060192d7836ULL, 0x040fe20000000000ULL, 0x000000ff1900720cULL, 0x000fe20000725670ULL,
0x012400000b1c7984ULL, 0x0006e80000000c00ULL, 0x012600000b207984ULL, 0x0006e20000000c00ULL,
0x00009800ff067b82ULL, 0x000f620000000a00ULL, 0x00000000001a7919ULL, 0x000ee20000008800ULL,
0x000000110d0d7224ULL, 0x004fc400078e0202ULL, 0x0000001100027224ULL, 0x000fe400078e02ffULL,
0x012000000b107984ULL, 0x0004a20000000c00ULL, 0x000000000d047224ULL, 0x000fe400078e02ffULL,
0x0000000302087224ULL, 0x010fe400078e02ffULL, 0x00000001040a7824ULL, 0x000fc600078e0205ULL,
0x00001fff08057811ULL, 0x000fc800078e40ffULL, 0x0000000a05037211ULL, 0x000fe400078f98ffULL,
0x000006541a1b7816ULL, 0x008fc6000000001bULL, 0x0000200003027825ULL, 0x022fc800078e0006ULL,
0x000008000e027825ULL, 0x000fc800078e0002ULL, 0x0000001029287825ULL, 0x000fc800078e0002ULL,
0x000000102b2a7825ULL, 0x000fc800078e0002ULL, 0x000000102d2c7825ULL, 0x000fc800078e0002ULL,
0x0000001019267825ULL, 0x000fe200078e0002ULL, 0x01ffffff08037812ULL, 0x000fe200078ec0ffULL,
0x0000000000380947ULL, 0x004fec0003800000ULL, 0x00009800ff247b82ULL, 0x000e620000000a00ULL,
0x000000010a2f7824ULL, 0x000fe200078e0203ULL, 0x00000001ff087819ULL, 0x000fe20000011619ULL,
0x0000001019027824ULL, 0x000fc600078e00ffULL, 0x0000000c08087812ULL, 0x000fe200078ec0ffULL,
0x000000800a0a7825ULL, 0x002fc800078e0024ULL, 0x000000802f247825ULL, 0x000fe200078e0024ULL,
0x00000070022f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a080a7210ULL, 0x140fe40007b5e02fULL,
0x0000002408247210ULL, 0x000fe40007d9e02fULL, 0x0000000bff0b7210ULL, 0x000fe400017e64ffULL,
0x00000025ff257210ULL, 0x000fc600027ea4ffULL, 0x000000090a007986ULL, 0x0003e8000c10190cULL,
0x0000000c24007986ULL, 0x0003e4000c10190cULL, 0x0000001026007986ULL, 0x0005e8000c101d0cULL,
0x0000001428007986ULL, 0x0005e8000c101d0cULL, 0x0000001c2a007986ULL, 0x0005e8000c101d0cULL,
0x000000202c007986ULL, 0x0005e2000c101d0cULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000004c1947ULL, 0x000fea0003800000ULL, 0x00009600ff087b82ULL, 0x002e620000000a00ULL,
0xffffffff000b7836ULL, 0x000fe40000000000ULL, 0x000000040d087825ULL, 0x002fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x0000000b080879a8ULL, 0x000ee800099ee1ccULL, 0x00000000ff00798fULL, 0x008fe20002000000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fc40000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000b0800720cULL, 0x000fc80003f25270ULL,
0x00000001ff027807ULL, 0x000fca0000800000ULL, 0x00000002ff007988ULL, 0x0003e80008000004ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000001b027984ULL, 0x002e640000000000ULL, 0x000000ff0200720cULL, 0x002fda0003f25270ULL,
0x0000002000549947ULL, 0x000fea0003800000ULL, 0x0000000c00300947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x0000000000d88947ULL, 0x000fea0003800000ULL,
0x0000001019027824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011619ULL,
0x00000001040b7836ULL, 0x040fe40000000000ULL, 0x0000008004087825ULL, 0x100fe200078e0006ULL,
0x00000070021d7812ULL, 0x004fe400078ec0ffULL, 0x0000000c0a027812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fc600078e0006ULL, 0x00000008020c7210ULL, 0x140fe4000791e01dULL,
0x0000000a020a7210ULL, 0x000fe40007b5e01dULL, 0x00000009ff0d7210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000c0c087981ULL, 0x000368000c1e1900ULL,
0x0000000c0a097981ULL, 0x000362000c1e1900ULL, 0x000000020000780cULL, 0x000fda0003f05270ULL,
0x00000000009c8947ULL, 0x002fea0003800000ULL, 0x00000002040b7836ULL, 0x000fc80000000000ULL,
0x000000800b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a020a7210ULL, 0x000fc8000791e01dULL,
0x0000000bff0b7210ULL, 0x000fcc00007e24ffULL, 0x0000000c0a0b7981ULL, 0x000362000c1e1900ULL,
0x000000040000780cULL, 0x000fda0003f06070ULL, 0x0000000000808947ULL, 0x002fea0003800000ULL,
0x00000003040d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e0006ULL,
0x0000000c020c7210ULL, 0x000fc8000791e01dULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x0000000c0c117981ULL, 0x000362000c1e1900ULL, 0x000000040000780cULL, 0x000fda0003f05270ULL,
0x0000000000648947ULL, 0x002fea0003800000ULL, 0x00000004040d7836ULL, 0x000fc80000000000ULL,
0x000000800d0c7825ULL, 0x000fc600078e0006ULL, 0x0000000c020c7210ULL, 0x000fc8000791e01dULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x0000000c0c137981ULL, 0x000362000c1e1900ULL,
0x000000060000780cULL, 0x000fda0003f06070ULL, 0x0000000000488947ULL, 0x002fea0003800000ULL,
0x00000005040d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e0006ULL,
0x0000000c020c7210ULL, 0x000fc8000791e01dULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x0000000c0c157981ULL, 0x000362000c1e1900ULL, 0x000000060000780cULL, 0x000fda0003f05270ULL,
0x00000000002c8947ULL, 0x002fea0003800000ULL, 0x000000080000780cULL, 0x000fe20003f06070ULL,
0x00000006040d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e0006ULL,
0x0000000c020c7210ULL, 0x000fca0007a3e01dULL, 0x0000000704170836ULL, 0x000fe20000000000ULL,
0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL, 0x0000008017060825ULL, 0x000fe400078e0006ULL,
0x0000000c0c177981ULL, 0x000362000c1e1900ULL, 0x0000000602060210ULL, 0x000fc80007c7e01dULL,
0x00000007ff070210ULL, 0x000fca0001fe84ffULL, 0x0000000c061d0981ULL, 0x000368000c1e1900ULL,
0x0000000700027836ULL, 0x000fca0000000000ULL, 0x00000003ff027819ULL, 0x000fc80000011602ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x0000000800248947ULL, 0x000fea0003800000ULL,
0x00009800ff067b82ULL, 0x002e620000000a00ULL, 0x000000ffff107224ULL, 0x004fe200078e0004ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1f7224ULL, 0x020fe200078e0008ULL,
0x0000003f00057c82ULL, 0x000fcc0008000000ULL, 0x0000000400007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x0000000502007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400f41947ULL, 0x022fee0003800000ULL, 0x0000000804067890ULL, 0x000fe2000fffe03fULL,
0x0000001f08087209ULL, 0x000fe20007810000ULL, 0x0000000104077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010190a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011619ULL, 0x00000008100d7836ULL, 0x000fc60000000000ULL,
0x000000700a1f7812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x002fe200078e0006ULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e01fULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0c1f7981ULL, 0x000368000c1e1900ULL,
0x0000000400b42947ULL, 0x000fea0003800000ULL, 0x0000000904067890ULL, 0x000fe2000fffe03fULL,
0x0000000908087209ULL, 0x000fe20007810000ULL, 0x0000000204077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000001019097824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011619ULL, 0x00000009100d7836ULL, 0x002fc60000000000ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0a0c7210ULL, 0x000fc80007b3e009ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0c097981ULL, 0x000368000c1e1900ULL,
0x0000000400742947ULL, 0x000fea0003800000ULL, 0x0000000a04067890ULL, 0x000fe2000fffe03fULL,
0x0000000b08087209ULL, 0x000fe20007810000ULL, 0x0000000304077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010190a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x002fe20000011619ULL, 0x0000000a100b7836ULL, 0x000fc60000000000ULL,
0x000000700a0d7812ULL, 0x000fe200078ec0ffULL, 0x000000800b0a7825ULL, 0x000fe200078e0006ULL,
0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0c0a7210ULL, 0x000fc80007b3e00dULL,
0x0000000bff0b7210ULL, 0x000fcc0000fe64ffULL, 0x0000000c0a0b7981ULL, 0x000366000c1e1900ULL,
0x0000000400342947ULL, 0x000fea0003800000ULL, 0x0000000b04067890ULL, 0x000fe2000fffe03fULL,
0x0000001108087209ULL, 0x000fe20007810000ULL, 0x0000000404077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010190a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011619ULL, 0x0000000b100d7836ULL, 0x000fc60000000000ULL,
0x000000700a117812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e011ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0c117981ULL, 0x000368000c1e1900ULL,
0x0000000000f42947ULL, 0x000fea0003800000ULL, 0x0000000c04067890ULL, 0x000fe2000fffe03fULL,
0x0000001308087209ULL, 0x000fe20007810000ULL, 0x0000000504077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010190a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011619ULL, 0x0000000c100d7836ULL, 0x000fc60000000000ULL,
0x000000700a137812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0c137981ULL, 0x000368000c1e1900ULL,
0x0000000000b42947ULL, 0x000fea0003800000ULL, 0x0000000d04067890ULL, 0x000fe2000fffe03fULL,
0x0000001508087209ULL, 0x000fe20007810000ULL, 0x0000000604077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010190a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011619ULL, 0x0000000d100d7836ULL, 0x000fc60000000000ULL,
0x000000700a157812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e015ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0c157981ULL, 0x000368000c1e1900ULL,
0x0000000000742947ULL, 0x000fea0003800000ULL, 0x0000000e04067890ULL, 0x000fe2000fffe03fULL,
0x0000001708087209ULL, 0x000fe20007810000ULL, 0x0000000704077890ULL, 0x000fc8000fffe03fULL,
0x0000000600007c0cULL, 0x040fe4000bf23070ULL, 0x0000000700007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010190a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011619ULL, 0x0000000e100d7836ULL, 0x000fc60000000000ULL,
0x000000700a177812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e017ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x0000000c0c177981ULL, 0x000368000c1e1900ULL,
0x0000000000342947ULL, 0x000fea0003800000ULL, 0x0000000f04067890ULL, 0x000fe2000fffe03fULL,
0x0000001d08087209ULL, 0x000fca0007810000ULL, 0x0000000600007c0cULL, 0x000fda000bf23070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010190a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011619ULL, 0x0000000f100d7836ULL, 0x000fc60000000000ULL,
0x000000700a1d7812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007a3e01dULL,
0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL, 0x0000000c0c1d7981ULL, 0x000368000c1e1900ULL,
0x0000000804047890ULL, 0x000fe2000fffe03fULL, 0x0000000810107836ULL, 0x000fe20000000000ULL,
0xfffffff400f08947ULL, 0x000ff4000383ffffULL, 0x0000000000197919ULL, 0x000ee40000000000ULL,
0x0000001019027824ULL, 0x008fe200078e00ffULL, 0x00000001ff067819ULL, 0x002fc80000011619ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ec0ffULL,
0x0000001b06077210ULL, 0x000fca0007ffe002ULL, 0x0000000807007388ULL, 0x0203e40000000800ULL,
0x00009800ff107b82ULL, 0x004ea20000000a00ULL, 0x0000000405057211ULL, 0x000fe200078f98ffULL,
0x000008000e1a7824ULL, 0x000fe200078e00ffULL, 0x000000071900780cULL, 0x040fe20003f04070ULL,
0x0000001019207824ULL, 0x040fe200078e00ffULL, 0x00000015ff1c7819ULL, 0x000fe2000001160eULL,
0x0000000104477824ULL, 0x000fe200078e0203ULL, 0x00000001ff1d7819ULL, 0x000fe20000011619ULL,
0x0000002019097836ULL, 0x040fe20000000000ULL, 0x0000007020207812ULL, 0x000fe200078ec0ffULL,
0x00000040190b7836ULL, 0x000fe20000000000ULL, 0x0000000c1d1d7812ULL, 0x000fe200078ec0ffULL,
0x00000060190d7836ULL, 0x000fe20000000000ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x000010000e1e7824ULL, 0x140fe200078e021bULL, 0x0000001b1d1f7210ULL, 0x000fe20007ffe020ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000001000e128824ULL, 0x140fe200078e021bULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000001019137824ULL, 0x040fe200078e021eULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000001000e148824ULL, 0x000fe200078e021bULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000001019158824ULL, 0x000fe200078e0212ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000200005067825ULL, 0x006fe200078e0010ULL,
0x0000000000347805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000001019178824ULL, 0x000fe200078e0214ULL,
0x0000001a06027210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000107037824ULL, 0x000fe200008e061cULL,
0x000000ff0000720cULL, 0x000fc40003f25270ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000001009087825ULL, 0x100fe200078e0002ULL,
0x000000001f1f7984ULL, 0x000e620000000800ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000001019067825ULL, 0x000fe200078e0002ULL,
0x00000000003e7805ULL, 0x000fc6000001ff00ULL, 0x000000100b0a7825ULL, 0x100fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006137faeULL, 0x0005e6000b901c4cULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0038000008137faeULL, 0x0005e6000b901c4cULL,
0x00000080470c8825ULL, 0x100fe200078e0010ULL, 0x005800000a137faeULL, 0x0005e6000b901c4cULL,
0x0000008004108825ULL, 0x000fe200078e0010ULL, 0x0078000002137faeULL, 0x0005e6000b901c4cULL,
0x00000010190c8825ULL, 0x000fc800078e000cULL, 0x0000001019108825ULL, 0x000fe200078e0010ULL,
0x045800000c158faeULL, 0x0005e8000b901c4cULL, 0x0418000010178faeULL, 0x0005e8000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000800b49947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x104fe20000011619ULL, 0x0000000147477836ULL, 0x000fe20000000000ULL,
0xfffffff8ff077812ULL, 0x000fe200078ee219ULL, 0x0000000105497836ULL, 0x000fe20000000000ULL,
0x0000000302067812ULL, 0x000fe200078ec0ffULL, 0x00000001044d7836ULL, 0x000fe20000000000ULL,
0x00009800ff027b82ULL, 0x000ea20000000a00ULL, 0x0000000807097836ULL, 0x040fe20000000000ULL,
0x0000000406087812ULL, 0x000fe200078efcffULL, 0x0000000807437824ULL, 0x000fe200078e00ffULL,
0x0000000706427812ULL, 0x000fe200078e7807ULL, 0x0000000809457824ULL, 0x000fe200078e00ffULL,
0x0000000706447812ULL, 0x000fe200078e7809ULL, 0x00000001ff4b7424ULL, 0x000fe200078e00ffULL,
0x0000000708067812ULL, 0x000fe200078e7807ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x00000002ff467819ULL, 0x000fe20000011619ULL, 0x000001000e4f7824ULL, 0x000fe200078e021bULL,
0x0000000708087812ULL, 0x000fc400078e7809ULL, 0x0000004342427212ULL, 0x000fe200078efcffULL,
0x0000000846487836ULL, 0x000fe20000000000ULL, 0x0000004544447212ULL, 0x000fe400078efcffULL,
0x0000004306437212ULL, 0x000fe400078efcffULL, 0x0000004508457212ULL, 0x000fce00078efcffULL,
0x000000004b00720cULL, 0x000fda0003f06070ULL, 0x0000000000880947ULL, 0x000fea0003800000ULL,
0x0000200049047825ULL, 0x004fe200078e0002ULL, 0x000000071900780cULL, 0x000fe40003f24070ULL,
0x000000014b147812ULL, 0x000fe200078ec0ffULL, 0x0000002019077836ULL, 0x000fe20000000000ULL,
0x0000001a040a7210ULL, 0x000fe20007f1e0ffULL, 0x000008004b047824ULL, 0x000fe400078e00ffULL,
0x0000004019157836ULL, 0x000fe40000000000ULL, 0x00000001050b7824ULL, 0x000fe200000e061cULL,
0x0000080004057812ULL, 0x000fe200078ec0ffULL, 0x0000006019177836ULL, 0x000fc40000000000ULL,
0x000001000e4f9824ULL, 0x000fe400078e021bULL, 0x000000011e047824ULL, 0x000fe400078e0205ULL,
0x00000080470c9825ULL, 0x000fc800078e0002ULL, 0x000000804d089825ULL, 0x000fc800078e0002ULL,
0x0000008014129824ULL, 0x000fe400078e024fULL, 0x0000001019137824ULL, 0x040fe400078e0204ULL,
0x0000001019107825ULL, 0x000fc800078e000aULL, 0x0000001007047825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000010137faeULL, 0x0005e6000b901c4cULL,
0x0000008014149824ULL, 0x000fe200078e024fULL, 0x0038000004137faeULL, 0x0005e2000b901c4cULL,
0x0000001015067825ULL, 0x000fc800078e000aULL, 0x00000010170a7825ULL, 0x000fe200078e000aULL,
0x0058000006137faeULL, 0x0005e6000b901c4cULL, 0x00000010190c9825ULL, 0x040fe200078e000cULL,
0x007800000a137faeULL, 0x0005e6000b901c4cULL, 0x0000001019159824ULL, 0x040fe400078e0212ULL,
0x0000001019089825ULL, 0x000fc600078e0008ULL, 0x045800000c159faeULL, 0x0005e2000b901c4cULL,
0x0000001019179824ULL, 0x000fca00078e0214ULL, 0x0418000008179faeULL, 0x0005e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff4b047836ULL, 0x044fe20000000000ULL,
0x000000004b00720cULL, 0x040fe20003f06070ULL, 0x000000014b4b7836ULL, 0x000fe40000000000ULL,
0x0000008004057824ULL, 0x040fe400078e00ffULL, 0x0000080004047824ULL, 0x000fe400078e00ffULL,
0x0000000147477836ULL, 0x000fe20000000000ULL, 0x0000008005057812ULL, 0x000fe200078ec0ffULL,
0x0000000149497836ULL, 0x000fc40000000000ULL, 0x000000014d4d7836ULL, 0x000fe20000000000ULL,
0x0000004f20067210ULL, 0x000fe40007ffe005ULL, 0x0000080004057812ULL, 0x000fc600078ec0ffULL,
0x000000011d0d7824ULL, 0x000fe200078e0206ULL, 0x000001801e0c7810ULL, 0x000fe20007ffe005ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000d127984ULL, 0x000ea20000000800ULL,
0x0000001042047824ULL, 0x100fe400078e020cULL, 0x0000001043087824ULL, 0x100fe200078e020cULL,
0x004580000d517984ULL, 0x000fe20000000800ULL, 0x0000001044107824ULL, 0x100fe400078e020cULL,
0x0000001045147824ULL, 0x000fe200078e020cULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000808783bULL, 0x000f220000000200ULL, 0x000000121f157221ULL, 0x006fc60000010100ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x3fb8aa3b154e7820ULL, 0x000fc60000410000ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00007632040c7816ULL, 0x048fe2000000000cULL,
0x00010000040d7824ULL, 0x000fe200078e00ffULL, 0x0000004e004e7308ULL, 0x000ee20000000800ULL,
0x0000763205047816ULL, 0x000fe20000000004ULL, 0x0001000008557824ULL, 0x010fe200078e00ffULL,
0x00007632064c7816ULL, 0x000fe2000000004cULL, 0x0001000009507824ULL, 0x000fe400078e00ffULL,
0x000100000a577824ULL, 0x000fe400078e00ffULL, 0x00010000054a7824ULL, 0x000fc400078e00ffULL,
0x000100000b527824ULL, 0x000fe400078e00ffULL, 0x000100000c057824ULL, 0x000fe400078e00ffULL,
0x0001000007537824ULL, 0x000fe400078e00ffULL, 0x000000514e5d7220ULL, 0x008fe20000410000ULL,
0x00007632084e7816ULL, 0x000fe2000000004eULL, 0x0001000006517824ULL, 0x000fe200078e00ffULL,
0x0000763209087816ULL, 0x000fe20000000008ULL, 0x000000405d407221ULL, 0x000fe20000010000ULL,
0x00001f465d5e7589ULL, 0x000ee200000e0000ULL, 0x000076320a097816ULL, 0x000fc40000000009ULL,
0x000076320b0a7816ULL, 0x000fe2000000000aULL, 0x00001f485d5d7589ULL, 0x000f2200000e0000ULL,
0x0000763207067816ULL, 0x000fe20000000006ULL, 0x0001000004077824ULL, 0x000fe400078e00ffULL,
0x0001000008087824ULL, 0x000fe400078e00ffULL, 0x0001000009097824ULL, 0x000fe200078e00ffULL,
0x00007632100b7816ULL, 0x042fe2000000000bULL, 0x0001000013587824ULL, 0x040fe200078e00ffULL,
0x0000763213567816ULL, 0x000fe20000000056ULL, 0x0001000010597824ULL, 0x000fe200078e00ffULL,
0x0000763214137816ULL, 0x004fe20000000013ULL, 0x000100000b047824ULL, 0x000fe200078e00ffULL,
0x00007632155a7816ULL, 0x040fe2000000005aULL, 0x00010000155c7824ULL, 0x000fe200078e00ffULL,
0x0000763211107816ULL, 0x040fe20000000010ULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x0000763212547816ULL, 0x040fe20000000054ULL, 0x0001000012127824ULL, 0x000fc400078e00ffULL,
0x0000005e05347223ULL, 0x088fe20000010034ULL, 0x000100004c057824ULL, 0x000fe200078e00ffULL,
0x0000763216157816ULL, 0x000fe20000000015ULL, 0x0000005e07307223ULL, 0x080fe20000010030ULL,
0x0000005d04317223ULL, 0x010fe20000010031ULL, 0x0000005e052e7223ULL, 0x080fe2000001002eULL,
0x00007632175b7816ULL, 0x000fe2000000005bULL, 0x000100004e057824ULL, 0x000fe400078e00ffULL,
0x0000005e0d387223ULL, 0x000fe20000010038ULL, 0x0001000013047824ULL, 0x000fc400078e00ffULL,
0x0000005e4a3f7223ULL, 0x080fe2000001003fULL, 0x0001000006077824ULL, 0x000fe400078e00ffULL,
0x0000005e052a7223ULL, 0x080fe2000001002aULL, 0x0000005d04297223ULL, 0x000fe20000010029ULL,
0x0001000014147824ULL, 0x000fe400078e00ffULL, 0x0000005e513a7223ULL, 0x080fe2000001003aULL,
0x0001000016167824ULL, 0x000fe400078e00ffULL, 0x0000005e53367223ULL, 0x000fe20000010036ULL,
0x0001000017177824ULL, 0x000fc400078e00ffULL, 0x0000005e072c7223ULL, 0x080fe2000001002cULL,
0x000100000a0a7824ULL, 0x000fe400078e00ffULL, 0x0000005e55287223ULL, 0x080fe20000010028ULL,
0x0001000010107824ULL, 0x000fe400078e00ffULL, 0x0000005e503d7223ULL, 0x080fe2000001003dULL,
0x0001000054547824ULL, 0x000fe400078e00ffULL, 0x0000005e08277223ULL, 0x000fe20000010027ULL,
0x0001000056567824ULL, 0x000fc400078e00ffULL, 0x0000005e57327223ULL, 0x080fe20000010032ULL,
0x000100005a057824ULL, 0x000fe400078e00ffULL, 0x0000005e09247223ULL, 0x080fe20000010024ULL,
0x0001000015047824ULL, 0x000fe400078e00ffULL, 0x0000005e52257223ULL, 0x080fe20000010025ULL,
0x000100005b067824ULL, 0x000fe400078e00ffULL, 0x0000005e0a217223ULL, 0x000fe20000010021ULL,
0x0000005d593e7223ULL, 0x080fe2000001003eULL, 0x0000005d113c7223ULL, 0x080fe2000001003cULL,
0x0000005d102f7223ULL, 0x080fe2000001002fULL, 0x0000005d123b7223ULL, 0x080fe2000001003bULL,
0x0000005d542d7223ULL, 0x080fe2000001002dULL, 0x0000005d58397223ULL, 0x080fe20000010039ULL,
0x0000005d562b7223ULL, 0x080fe2000001002bULL, 0x0000005d14377223ULL, 0x080fe20000010037ULL,
0x0000005d5c357223ULL, 0x080fe20000010035ULL, 0x0000005d05267223ULL, 0x080fe20000010026ULL,
0x0000005d16337223ULL, 0x080fe20000010033ULL, 0x0000005d04237223ULL, 0x080fe20000010023ULL,
0x0000005d17227223ULL, 0x080fe20000010022ULL, 0x0000005d06417223ULL, 0x000fe20000010041ULL,
0xfffffff400ac8947ULL, 0x000fec000383ffffULL, 0x0180000040007836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe80000010000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0040ULL, 0x0000e3d000087802ULL, 0x000fce0000000f00ULL,
0x0000007000587944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e000aULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000004000037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000040ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000197919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x104fe40000011619ULL, 0x00000008190b7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff107819ULL, 0x000fe20000011619ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0300037589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff1a7812ULL, 0x000fc600078ee219ULL,
0x00001f0b000c7589ULL, 0x0022e400000e0000ULL, 0x000000081a1c7836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x000000081c177824ULL, 0x000fe400078e00ffULL,
0x0000003803047220ULL, 0x044fe20000410000ULL, 0x0000003403057220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000003a03067220ULL, 0x040fe20000410000ULL, 0x0000002e03077220ULL, 0x040fe20000410000ULL,
0x0000003603367220ULL, 0x040fe20000410000ULL, 0x0000002c03097220ULL, 0x040fe20000410000ULL,
0x0000002803087220ULL, 0x040fe20000410000ULL, 0x0000002a030b7220ULL, 0x042fe20000410000ULL,
0x0000003d033d7220ULL, 0x040fe20000410000ULL, 0x0000002703007220ULL, 0x040fe20000410000ULL,
0x00000032030a7220ULL, 0x040fe20000410000ULL, 0x00000024030d7220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002103027220ULL, 0x000fe20000410000ULL,
0x0000000310037812ULL, 0x000fe200078ec0ffULL, 0x0000003e0c3e7220ULL, 0x048fe20000410000ULL,
0x000000310c317220ULL, 0x040fe20000410000ULL, 0x0000003c0c3c7220ULL, 0x040fe20000410000ULL,
0x0000000403137812ULL, 0x000fe200078efcffULL, 0x0000002f0c2f7220ULL, 0x040fe20000410000ULL,
0x0000003b0c3b7220ULL, 0x040fe20000410000ULL, 0x0000002d0c107220ULL, 0x040fe20000410000ULL,
0x000000390c397220ULL, 0x040fe20000410000ULL, 0x0000002b0c127220ULL, 0x040fe20000410000ULL,
0x000000370c377220ULL, 0x040fe20000410000ULL, 0x000000290c147220ULL, 0x040fe20000410000ULL,
0x000000350c357220ULL, 0x040fe20000410000ULL, 0x000000260c267220ULL, 0x040fe20000410000ULL,
0x000000330c337220ULL, 0x040fe20000410000ULL, 0x000000230c167220ULL, 0x040fe20000410000ULL,
0x000000220c227220ULL, 0x040fe20000410000ULL, 0x000000410c417220ULL, 0x000fe20000410000ULL,
0x000000081a0c7824ULL, 0x000fe200078e00ffULL, 0x0000000703117812ULL, 0x000fc400078e781aULL,
0x00000007031e7812ULL, 0x000fe400078e781cULL, 0x0000000713157812ULL, 0x000fe400078e781aULL,
0x00000007131c7812ULL, 0x000fe400078e781cULL, 0x0000000c11037212ULL, 0x080fe400078efcffULL,
0x000000171e117212ULL, 0x080fe400078efcffULL, 0x0000000c15157212ULL, 0x000fe200078efcffULL,
0x0000001003037824ULL, 0x100fe200078e0218ULL, 0x000000171c177212ULL, 0x000fe200078efcffULL,
0x0000001011117824ULL, 0x100fe200078e0218ULL, 0x000000040504723eULL, 0x000fe200000010ffULL,
0x00000010150c7824ULL, 0x100fe200078e0218ULL, 0x000000060706723eULL, 0x000fe200000010ffULL,
0x0000001017187824ULL, 0x000fe200078e0218ULL, 0x0000003f3005723eULL, 0x000fc400000010ffULL,
0x000000360907723eULL, 0x000fe400000010ffULL, 0x000000080b08723eULL, 0x000fe400000010ffULL,
0x0000003d0009723eULL, 0x000fe200000010ffULL, 0x0000000403007844ULL, 0x0003e20000000200ULL,
0x0000000a0d0a723eULL, 0x000fe400000010ffULL, 0x00000025020b723eULL, 0x000fe400000010ffULL,
0x0000003e311c723eULL, 0x000fc400000010ffULL, 0x0000003c2f1d723eULL, 0x000fe200000010ffULL,
0x000000080c007844ULL, 0x0003e20000000200ULL, 0x0000003b101e723eULL, 0x000fe400000010ffULL,
0x00000039121f723eULL, 0x000fe400000010ffULL, 0x000000371414723eULL, 0x000fe400000010ffULL,
0x000000352615723eULL, 0x000fe200000010ffULL, 0x0000001c11007844ULL, 0x0003e20000000200ULL,
0x000000331616723eULL, 0x000fc400000010ffULL, 0x000000224117723eULL, 0x000fca00000010ffULL,
0x0000001418007844ULL, 0x0003e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000001a7919ULL, 0x000f220000002600ULL, 0x00000020191c7836ULL, 0x046fe20000000000ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0x0000004019207836ULL, 0x040fe20000000000ULL,
0x00000003ff007819ULL, 0x000fe20000011619ULL, 0x0000006019217836ULL, 0x000fe20000000000ULL,
0x00000003ff037819ULL, 0x008fe2000001161cULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff0d7819ULL, 0x000fe20000011620ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff187819ULL, 0x000fe20000011621ULL, 0x000000080e0e7824ULL, 0x000fe200078e00ffULL,
0x0000860000067ab9ULL, 0x000fc40000000a00ULL, 0x0000000718077812ULL, 0x000fc800078e4821ULL,
0x0ffffff807087812ULL, 0x000fca00078ef821ULL, 0x0000001008147824ULL, 0x000fe200078e020fULL,
0x00000004050472a4ULL, 0x002fca000f8e023fULL, 0x0120000014147984ULL, 0x000fe20000000c00ULL,
0x000000101a057824ULL, 0x050fe400078e00ffULL, 0x000000101a0c7824ULL, 0x040fe400078e00ffULL,
0x000000101a1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff005027812ULL, 0x000fe400078ee200ULL,
0xfffffff00c0c7812ULL, 0x000fe400078ee203ULL, 0x0000000700007812ULL, 0x000fc400078e4819ULL,
0x0000000703037812ULL, 0x000fe400078e481cULL, 0x000000070d057812ULL, 0x000fe400078e4820ULL,
0x0ffffff800007812ULL, 0x000fe400078ef819ULL, 0x0ffffff803047812ULL, 0x000fe400078ef81cULL,
0x0ffffff805067812ULL, 0x000fe200078ef820ULL, 0x0000001000007824ULL, 0x100fe200078e020fULL,
0x0000000402037c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001004097824ULL, 0x100fe200078e020fULL,
0xfffffff01e0d7812ULL, 0x000fe200078ee20dULL, 0x0000001006107824ULL, 0x000fc400078e020fULL,
0x0120000000047984ULL, 0x0002a20000000c00ULL, 0x000000101a0f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x0120000009087984ULL, 0x000ee20000000c00ULL,
0x0000000603027c11ULL, 0x040fe4000f8048ffULL, 0xfffffff00f187812ULL, 0x000fe200078ee218ULL,
0x0120000010107984ULL, 0x000f220000000c00ULL, 0x1ffffff80e007812ULL, 0x002fe400078ec0ffULL,
0x0000000703037c11ULL, 0x000fc400080f4c1aULL, 0x000000040c1e7c10ULL, 0x000fe4000ff1e0ffULL,
0x00000007001b7812ULL, 0x000fe400078ef819ULL, 0x000000040d0f7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x0000000418197c10ULL, 0x000fe2000ff5e0ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00000007001d7812ULL, 0x000fe400078ef81cULL,
0x000000061e0c7c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x000000060f0e7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x0000000619187c11ULL, 0x000fc4000f8448ffULL, 0x000000071e0d7c11ULL, 0x000fe400080f4c0dULL,
0x00000007001f7812ULL, 0x000fe400078ef820ULL, 0x000000070f0f7c11ULL, 0x000fe200088f4c1cULL,
0x000000101d0c7825ULL, 0x000fe200078e000cULL, 0x0000000700217812ULL, 0x000fe400078ef821ULL,
0x0000000719197c11ULL, 0x000fe200090f4c1aULL, 0x000000101f0e7825ULL, 0x000fe200078e000eULL,
0x0000000402007986ULL, 0x004fe6000c101d0cULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x000000080c007986ULL, 0x008fe8000c101d0cULL, 0x000000100e007986ULL, 0x010fe8000c101d0cULL,
0x0000001418007986ULL, 0x000fe2000c101d0cULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009400ff087b82ULL, 0x000e620000000a00ULL, 0x00000001ff037819ULL, 0x008fc8000001160eULL,
0x01ffffff03037812ULL, 0x000fca00078ec0ffULL, 0x0000000202037824ULL, 0x000fca00078e0203ULL,
0x0000000403007c0cULL, 0x000fe2000bf06070ULL, 0x0000000c08097981ULL, 0x002358000c1e9900ULL,
0x00009000ff058b82ULL, 0x000ea20000000800ULL, 0x000000020d048824ULL, 0x000fce00078e00ffULL,
0x00008c00ff0a8b82ULL, 0x000ee20000000a00ULL, 0x0000000102067836ULL, 0x000fe40000000000ULL,
0x0000000504058224ULL, 0x004fe400078e0203ULL, 0xffffffffff047424ULL, 0x000fe400078e00ffULL,
0x00000004050a8825ULL, 0x008fca00078e000aULL, 0x0000000c0a048981ULL, 0x000362000c1e1900ULL,
0x0000000506007c0cULL, 0x000fe2000bf06070ULL, 0x000000400e057824ULL, 0x000fe400078e00ffULL,
0x0000008017067824ULL, 0x000fe400078e00ffULL, 0x00000100020c7824ULL, 0x000fe200078e0205ULL,
0x0000000706067899ULL, 0x000fc8000800063fULL, 0x00000040060f7812ULL, 0x000fc600078ef80cULL,
0x0000000c00408947ULL, 0x002fea0003800000ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x0000000b0c157c48ULL, 0x000fe2000ffe0000ULL, 0x00000006040f7c24ULL, 0x020fe2000f8e020fULL,
0x0000040000087802ULL, 0x000fe20000000f00ULL, 0x0000000000117919ULL, 0x000ea40000008800ULL,
0x0000000115157824ULL, 0x000fe200078e0a0cULL, 0x00000003ff167819ULL, 0x002fe20000011607ULL,
0x0000001007137824ULL, 0x040fe200078e00ffULL, 0x0ffffff8070b7812ULL, 0x000fe400078ec0ffULL,
0x00000007160a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000416127836ULL, 0x040fe20000000000ULL,
0x0000065411087816ULL, 0x004fe20000000008ULL, 0x0000000816147836ULL, 0x000fe20000000000ULL,
0x000000070b257812ULL, 0x000fe200078ef80aULL, 0x0000000812277824ULL, 0x040fe200078e00ffULL,
0x00000007120a7212ULL, 0x080fe200078e3cffULL, 0x0000000814107824ULL, 0x040fe200078e00ffULL,
0x00000007140b7212ULL, 0x080fe200078e3cffULL, 0x0000000c16187836ULL, 0x040fe20000000000ULL,
0xfffffff827277812ULL, 0x000fe200078ee20aULL, 0x0000001416247836ULL, 0x000fe20000000000ULL,
0xfffffff8102b7812ULL, 0x000fe200078ee20bULL, 0x00000008182d7824ULL, 0x040fe200078e00ffULL,
0x00008a00ff0a7b82ULL, 0x000e620000000a00ULL, 0x00000007180c7212ULL, 0x080fe200078e3cffULL,
0x00000010161c7836ULL, 0x000fe20000000000ULL, 0x0000000724117212ULL, 0x0c0fe200078e3cffULL,
0x00000008241a7824ULL, 0x000fe200078e00ffULL, 0x0000007f16107812ULL, 0x000fe200078ec0ffULL,
0x000000081c2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20cULL,
0x0000001816267836ULL, 0x000fe20000000000ULL, 0x000000071c0c7212ULL, 0x000fe200078e3cffULL,
0x0000001c162a7836ULL, 0x000fe20000000000ULL, 0x000000151200720cULL, 0x080fe20003f86070ULL,
0x00000020162c7836ULL, 0x000fe20000000000ULL, 0xfffffff81a317812ULL, 0x000fe200078ee211ULL,
0x000000010f117824ULL, 0x000fe200078e0210ULL, 0x0000007f12127812ULL, 0x000fe200078ec0ffULL,
0x00000024162e7836ULL, 0x000fe20000000000ULL, 0x000000151400720cULL, 0x000fe20003fa6070ULL,
0x0000000826337824ULL, 0x000fe200078e00ffULL, 0x0000007f14147812ULL, 0x000fc400078ec0ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee20cULL, 0x00000070130c7812ULL, 0x000fe200078ec0ffULL,
0x000000010f137824ULL, 0x000fe200078e0212ULL, 0x000000151800720cULL, 0x0c0fe20003f06070ULL,
0x0000010011107825ULL, 0x002fe200078e000aULL, 0x0000007f181a7812ULL, 0x000fe400078ec0ffULL,
0x000000151c00720cULL, 0x040fe20003f46070ULL, 0x000000010f197824ULL, 0x000fe200078e0214ULL,
0x000000100c1e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010013127825ULL, 0x000fe200078e000aULL,
0x0000007f1c1c7812ULL, 0x000fc400078ec0ffULL, 0x0000007f26147812ULL, 0x000fe200078ec0ffULL,
0x0000010019187825ULL, 0x000fe200078e000aULL, 0x000000120c207210ULL, 0x000fe40007f7e0ffULL,
0x0000007f2c287812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e0611ULL,
0x000000180c227210ULL, 0x000fe20007fde0ffULL, 0x000000010f1b7824ULL, 0x040fe200078e021cULL,
0x000000152400720cULL, 0x040fe20003f26070ULL, 0x000000010f177824ULL, 0x000fe200078e021aULL,
0x0000007f24247812ULL, 0x000fe200078ec0ffULL, 0x000000ffff217224ULL, 0x000fe200018e0613ULL,
0x0000007f2a1c7812ULL, 0x000fe200078ec0ffULL, 0x000001001b127825ULL, 0x000fc800078e000aULL,
0x000000ffff237224ULL, 0x000fe200030e0619ULL, 0x000000120c127210ULL, 0x000fe20007fde0ffULL,
0x000000010f197824ULL, 0x000fe400078e0224ULL, 0x0000010017107825ULL, 0x000fc800078e000aULL,
0x0000010019187825ULL, 0x000fe200078e000aULL, 0x000000100c107210ULL, 0x000fc60007f7e0ffULL,
0x000000010f1b7824ULL, 0x000fe400078e0214ULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x000000180c187210ULL, 0x000fe20007fde0ffULL, 0x000001001b1a7825ULL, 0x000fc800078e000aULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x000000151600720cULL, 0x000fe20003f66070ULL,
0x000040000e147824ULL, 0x000fe400078e0208ULL, 0x000000010f1d7824ULL, 0x000fe400078e021cULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000001a0c247210ULL, 0x000fe20007fde0ffULL,
0x0000200014147836ULL, 0x000fe40000000000ULL, 0x000001001d1c7825ULL, 0x000fc800078e000aULL,
0x000000010f297824ULL, 0x000fe200078e0228ULL, 0x0000000726287212ULL, 0x040fe200078e3cffULL,
0x0000001025177824ULL, 0x000fe400078e0214ULL, 0x000000ffff257224ULL, 0x000fe200030e061bULL,
0x0000001c0c1c7210ULL, 0x000fe20007fde0ffULL, 0x00000100291a7825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e177faeULL, 0x0003e2000d901c4cULL,
0x000000152600720cULL, 0x080fe40003f66070ULL, 0x0000001027297824ULL, 0x100fe200078e0214ULL,
0xfffffff833337812ULL, 0x000fe200078ee228ULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x0000001a0c267210ULL, 0x000fe20007fde0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0214ULL,
0x0000007f2e1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000020297faeULL, 0x000fe2000e101c4cULL,
0x000000152a00720cULL, 0x040fe20003f86070ULL, 0x000000ffff277224ULL, 0x000fe200030e061bULL,
0x000000072a177212ULL, 0x0c2fe200078e3cffULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x00000000222b7faeULL, 0x000fe2000e901c4cULL, 0x000000082c1f7824ULL, 0x040fe200078e00ffULL,
0x000000072c1e7212ULL, 0x040fe200078e3cffULL, 0x000000010f1b7824ULL, 0x000fe200078e021aULL,
0x000000152c00720cULL, 0x000fe20003fa6070ULL, 0x000000102d2d7824ULL, 0x000fe200078e0214ULL,
0xfffffff82a177812ULL, 0x000fe200078ee217ULL, 0x000001001b1a7825ULL, 0x000fe200078e000aULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee21eULL, 0x00000000102d7faeULL, 0x0003e2000c101c4cULL,
0x000000102f2f7824ULL, 0x100fe200078e0214ULL, 0x0000001a0c1a7210ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x100fe400078e0214ULL, 0x0000001033337824ULL, 0x100fe200078e0214ULL,
0x00000000122f7faeULL, 0x0005e2000d101c4cULL, 0x0000001017177824ULL, 0x100fe400078e0214ULL,
0x000000101f1f7824ULL, 0x000fe200078e0214ULL, 0x0000000018317faeULL, 0x0007e2000c901c4cULL,
0x00000028161e7836ULL, 0x000fe20000000000ULL, 0x000000072e107212ULL, 0x042fe200078e3cffULL,
0x000000082e117824ULL, 0x000fe200078e00ffULL, 0x0000000024337faeULL, 0x000fe2000d901c4cULL,
0x0000002c16207836ULL, 0x000fc40000000000ULL, 0x0000003016227836ULL, 0x040fe20000000000ULL,
0x000000001c177faeULL, 0x0003e2000e101c4cULL, 0x0000003416287836ULL, 0x000fe20000000000ULL,
0x000000071e127212ULL, 0x004fe200078e3cffULL, 0x00000038162a7836ULL, 0x040fe20000000000ULL,
0x00000000261f7faeULL, 0x0005e2000e901c4cULL, 0x0000003c162c7836ULL, 0x000fe20000000000ULL,
0x000000151e00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff1b7224ULL, 0x000fe200030e061bULL,
0xfffffff811117812ULL, 0x000fe200078ee210ULL, 0x0000000822217824ULL, 0x000fe200078e00ffULL,
0x000000152e00720cULL, 0x080fe20003fc6070ULL, 0x0000000828187824ULL, 0x008fe200078e00ffULL,
0x000000152000720cULL, 0x000fe20003f86070ULL, 0x000000081e1d7824ULL, 0x042fe200078e00ffULL,
0x0000007f1e1e7812ULL, 0x000fc400078ec0ffULL, 0x000000152200720cULL, 0x080fe20003f66070ULL,
0x00000008201f7824ULL, 0x004fe200078e00ffULL, 0x000000152800720cULL, 0x080fe40003f46070ULL,
0x000000152a00720cULL, 0x080fe40003f26070ULL, 0x000000152c00720cULL, 0x000fe20003f06070ULL,
0x0000001011157824ULL, 0x000fe200078e0214ULL, 0x0000000720107212ULL, 0x040fe200078e3cffULL,
0x000000010f117824ULL, 0x000fe200078e021eULL, 0x0000007f20207812ULL, 0x000fc400078ec0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL, 0x0000010011107825ULL, 0x000fe200078e000aULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee212ULL, 0x000000001a157faeULL, 0x0003e2000f101c4cULL,
0x0000000722127212ULL, 0x0c0fe200078e3cffULL, 0x000000010f137824ULL, 0x000fe200078e0220ULL,
0x0000007f22227812ULL, 0x000fe200078ec0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0214ULL,
0xfffffff821217812ULL, 0x000fe200078ee212ULL, 0x0000010013127825ULL, 0x000fe200078e000aULL,
0x0000000728177212ULL, 0x000fc400078e3cffULL, 0x000000100c167210ULL, 0x000fe20007fde0ffULL,
0x000000010f197824ULL, 0x000fe200078e0222ULL, 0xfffffff818237812ULL, 0x000fe200078ee217ULL,
0x000000101f1f7824ULL, 0x000fe200078e0214ULL, 0x0000007f28287812ULL, 0x000fe200078ec0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0611ULL, 0x000000120c187210ULL, 0x000fe20007fde0ffULL,
0x0000010019107825ULL, 0x000fe200078e000aULL, 0x0000007f2a127812ULL, 0x000fe400078ec0ffULL,
0x0000007f2c1c7812ULL, 0x000fe200078ec0ffULL, 0x000000010f157824ULL, 0x042fe200078e0228ULL,
0x00000000161d7faeULL, 0x0003e2000e901c4cULL, 0x000000ffff197224ULL, 0x000fe200030e0613ULL,
0x000000100c1a7210ULL, 0x000fe20007fde0ffULL, 0x000000010f257824ULL, 0x000fc400078e0212ULL,
0x0000010015127825ULL, 0x000fe200078e000aULL, 0x00000000181f7faeULL, 0x0003e6000e101c4cULL,
0x000000ffff1b7224ULL, 0x000fe200030e0611ULL, 0x000000120c127210ULL, 0x000fe20007fde0ffULL,
0x0000010025107825ULL, 0x000fc800078e000aULL, 0x000000010f157824ULL, 0x000fe200078e021cULL,
0x000000072a0f7212ULL, 0x0c0fe200078e3cffULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x000000100c107210ULL, 0x000fe20007fde0ffULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x000000072c1c7212ULL, 0x040fe200078e3cffULL, 0x000000082c257824ULL, 0x000fe400078e00ffULL,
0x00000100150a7825ULL, 0x000fe200078e000aULL, 0xfffffff82a0f7812ULL, 0x000fe400078ee20fULL,
0xfffffff825257812ULL, 0x000fe200078ee21cULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000000a0c0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x000fc400078e0214ULL,
0x0000001023237824ULL, 0x100fe400078e0214ULL, 0x000000100f0f7824ULL, 0x100fe200078e0214ULL,
0x000000001a217faeULL, 0x0003e2000d901c4cULL, 0x0000001025257824ULL, 0x000fe400078e0214ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000012237faeULL, 0x0003e8000d101c4cULL,
0x00000000100f7faeULL, 0x0003e8000c901c4cULL, 0x000000000a257faeULL, 0x0003e2000c101c4cULL,
0x0000000800f47947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x0000040000087802ULL, 0x000fe20000000f00ULL, 0x00000006040f7c24ULL, 0x020fe2000f8e020fULL,
0x0000000000117919ULL, 0x000ea20000008800ULL, 0x00000003ff0c7819ULL, 0x002fe40000011607ULL,
0x0ffffff8070b7812ULL, 0x000fe400078ec0ffULL, 0x000000070c0a7212ULL, 0x0c0fe200078e3cffULL,
0x000000080c187836ULL, 0x040fe20000000000ULL, 0x0000065411087816ULL, 0x004fe20000000008ULL,
0x000000040c147836ULL, 0x000fe20000000000ULL, 0x000000070b127812ULL, 0x000fe200078ef80aULL,
0x00000008181a7824ULL, 0x040fe200078e00ffULL, 0x0000000718137212ULL, 0x080fe200078e3cffULL,
0x0000000c0c1c7836ULL, 0x000fe20000000000ULL, 0x0000000714107212ULL, 0x080fe200078e3cffULL,
0x000000100c207836ULL, 0x000fe20000000000ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x0000000814157824ULL, 0x000fe200078e00ffULL, 0x000000071c0a7212ULL, 0x0c0fe200078e3cffULL,
0x000000081c137824ULL, 0x000fe200078e00ffULL, 0x00000007200b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000820227824ULL, 0x000fe200078e00ffULL, 0xfffffff815167812ULL, 0x000fe200078ee210ULL,
0x000000140c247836ULL, 0x040fe20000000000ULL, 0xfffffff8131e7812ULL, 0x000fe200078ee20aULL,
0x0000001c0c2c7836ULL, 0x040fe20000000000ULL, 0xfffffff822227812ULL, 0x000fe200078ee20bULL,
0x000000200c307836ULL, 0x000fe20000000000ULL, 0x0000000724107212ULL, 0x080fe200078e3cffULL,
0x000000180c287836ULL, 0x000fe20000000000ULL, 0x000000072c0a7212ULL, 0x080fe200078e3cffULL,
0x0000000824157824ULL, 0x000fe200078e00ffULL, 0x00000007300b7212ULL, 0x080fe200078e3cffULL,
0x000000082c137824ULL, 0x000fe200078e00ffULL, 0x0000000728117212ULL, 0x080fe200078e3cffULL,
0x0000000830327824ULL, 0x000fe200078e00ffULL, 0xfffffff815267812ULL, 0x000fe200078ee210ULL,
0x0000002c0c3c7836ULL, 0x040fe20000000000ULL, 0xfffffff8132e7812ULL, 0x000fe200078ee20aULL,
0x000000300c407836ULL, 0x000fe20000000000ULL, 0xfffffff832327812ULL, 0x000fe200078ee20bULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x000000073c0a7212ULL, 0x080fe200078e3cffULL,
0x000000240c347836ULL, 0x000fe20000000000ULL, 0x00000007400b7212ULL, 0x080fe200078e3cffULL,
0x000000280c387836ULL, 0x000fe20000000000ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL,
0x0000000834157824ULL, 0x040fe200078e00ffULL, 0x0000000734107212ULL, 0x080fe200078e3cffULL,
0x000000083c137824ULL, 0x000fe200078e00ffULL, 0x0000000738117212ULL, 0x080fe200078e3cffULL,
0x0000000840427824ULL, 0x000fe200078e00ffULL, 0xfffffff815367812ULL, 0x000fe200078ee210ULL,
0x00000008383a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8133e7812ULL, 0x000fe200078ee20aULL,
0x000000340c447836ULL, 0x040fe20000000000ULL, 0xfffffff842427812ULL, 0x000fe200078ee20bULL,
0x000000380c487836ULL, 0x000fe20000000000ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee211ULL,
0x0000000844157824ULL, 0x000fe200078e00ffULL, 0x00008a00ff0a7b82ULL, 0x000e620000000a00ULL,
0x00000008484a7824ULL, 0x000fe200078e00ffULL, 0x0000000744107212ULL, 0x000fc400078e3cffULL,
0x0000000748117212ULL, 0x080fe400078e3cffULL, 0xfffffff815467812ULL, 0x000fe400078ee210ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee211ULL, 0x000040000e117824ULL, 0x000fe200078e0208ULL,
0x0000007f0c107812ULL, 0x040fe200078ec0ffULL, 0x0000003c0c0c7836ULL, 0x000fe20000000000ULL,
0x0000007f14147812ULL, 0x000fe200078ec0ffULL, 0x0000200011137836ULL, 0x000fe20000000000ULL,
0x0000007f18187812ULL, 0x000fe200078ec0ffULL, 0x000000010f117824ULL, 0x040fe200078e0210ULL,
0x0000007f0c107812ULL, 0x040fe200078ec0ffULL, 0x000000010f157824ULL, 0x040fe200078e0214ULL,
0x000000070c317212ULL, 0x040fe200078e3cffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x0000007f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x000000010f177824ULL, 0x040fe200078e0218ULL,
0x0000007f20207812ULL, 0x000fe200078ec0ffULL, 0x000000010f4d7824ULL, 0x040fe200078e0210ULL,
0x0000007f24247812ULL, 0x000fe200078ec0ffULL, 0x000000010f197824ULL, 0x040fe200078e021cULL,
0x0000007f28287812ULL, 0x000fe200078ec0ffULL, 0x000000010f1b7824ULL, 0x040fe200078e0220ULL,
0x0000007f2c2c7812ULL, 0x000fe200078ec0ffULL, 0x000000010f1d7824ULL, 0x040fe200078e0224ULL,
0x0000007f30307812ULL, 0x000fe200078ec0ffULL, 0x000000010f1f7824ULL, 0x040fe200078e0228ULL,
0x0000007f34347812ULL, 0x000fe200078ec0ffULL, 0x000000010f217824ULL, 0x040fe200078e022cULL,
0x0000007f38387812ULL, 0x000fe200078ec0ffULL, 0x000000010f237824ULL, 0x040fe200078e0230ULL,
0x0000007f3c3c7812ULL, 0x000fe200078ec0ffULL, 0x000000010f257824ULL, 0x040fe200078e0234ULL,
0x0000007f40407812ULL, 0x000fe200078ec0ffULL, 0x000000010f277824ULL, 0x040fe200078e0238ULL,
0x0000007f44447812ULL, 0x000fe200078ec0ffULL, 0x000000010f297824ULL, 0x040fe200078e023cULL,
0x0000007f48487812ULL, 0x000fe200078ec0ffULL, 0x000000010f2b7824ULL, 0x040fe200078e0240ULL,
0xfffffff80c147812ULL, 0x000fe200078ee231ULL, 0x000000010f2d7824ULL, 0x000fc400078e0244ULL,
0x000000010f2f7824ULL, 0x000fe400078e0248ULL, 0x00000010120c7824ULL, 0x100fe400078e0213ULL,
0x00000010160f7824ULL, 0x100fe400078e0213ULL, 0x000000101a337824ULL, 0x100fe400078e0213ULL,
0x000000101e357824ULL, 0x100fe400078e0213ULL, 0x0000001022377824ULL, 0x000fc400078e0213ULL,
0x0000001026397824ULL, 0x100fe400078e0213ULL, 0x000000102a3b7824ULL, 0x100fe400078e0213ULL,
0x000000102e3d7824ULL, 0x100fe400078e0213ULL, 0x00000010323f7824ULL, 0x100fe400078e0213ULL,
0x0000001036417824ULL, 0x100fe400078e0213ULL, 0x000000103a437824ULL, 0x000fc400078e0213ULL,
0x000000103e457824ULL, 0x100fe400078e0213ULL, 0x0000001042477824ULL, 0x100fe400078e0213ULL,
0x0000001046497824ULL, 0x100fe400078e0213ULL, 0x000000104a4b7824ULL, 0x100fe400078e0213ULL,
0x00000010144f7824ULL, 0x000fe400078e0213ULL, 0x0000010015127825ULL, 0x002fc800078e000aULL,
0x0000010017147825ULL, 0x000fc800078e000aULL, 0x0000010019167825ULL, 0x000fc800078e000aULL,
0x000001001b187825ULL, 0x000fc800078e000aULL, 0x0000001007107824ULL, 0x000fe400078e00ffULL,
0x000001001d1a7825ULL, 0x000fc600078e000aULL, 0x0000007010317812ULL, 0x000fe200078ec0ffULL,
0x000001001f1c7825ULL, 0x000fc800078e000aULL, 0x00000100211e7825ULL, 0x000fc800078e000aULL,
0x0000010023207825ULL, 0x000fc800078e000aULL, 0x0000010025227825ULL, 0x000fc800078e000aULL,
0x0000010027247825ULL, 0x000fc800078e000aULL, 0x0000010011107825ULL, 0x000fc800078e000aULL,
0x0000010029267825ULL, 0x000fc800078e000aULL, 0x000001002b287825ULL, 0x000fc800078e000aULL,
0x000001002d2a7825ULL, 0x000fc800078e000aULL, 0x000001002f2c7825ULL, 0x000fc800078e000aULL,
0x000001004d2e7825ULL, 0x000fe200078e000aULL, 0x00000010310a7210ULL, 0x000fe40007f1e0ffULL,
0x0000001231107210ULL, 0x000fe40007f3e0ffULL, 0x0000001431127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0611ULL, 0x0000001631147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0613ULL, 0x0000001831167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0615ULL, 0x0000001a31187210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e0617ULL, 0x0000001c311a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200000e0619ULL, 0x0000001e311c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e061bULL, 0x00000020311e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061dULL, 0x0000002231207210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200018e061fULL, 0x0000002431227210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0c7faeULL, 0x0003e2000b901c4cULL,
0x0000002631247210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e0621ULL,
0x0000002831267210ULL, 0x000fe20007f1e0ffULL, 0x00000000100f7faeULL, 0x0003e2000b901c4cULL,
0x000000ffff217224ULL, 0x000fe200008e0623ULL, 0x0000002a31287210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200010e0625ULL, 0x0000000012337faeULL, 0x0003e2000b901c4cULL,
0x000000ffff257224ULL, 0x000fe200018e0627ULL, 0x0000002c312a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0629ULL, 0x0000000014357faeULL, 0x0003e2000b901c4cULL,
0x0000002e312c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff297224ULL, 0x000fc400008e062bULL,
0x0000000016377faeULL, 0x0003e2000b901c4cULL, 0x000000ffff2b7224ULL, 0x000fe400010e062dULL,
0x000000ffff2d7224ULL, 0x000fe200018e062fULL, 0x0000000018397faeULL, 0x0003e8000b901c4cULL,
0x000000001a3b7faeULL, 0x0003e8000b901c4cULL, 0x000000001c3d7faeULL, 0x0003e8000b901c4cULL,
0x000000001e3f7faeULL, 0x0003e8000b901c4cULL, 0x0000000020417faeULL, 0x0003e8000b901c4cULL,
0x0000000022437faeULL, 0x0003e8000b901c4cULL, 0x0000000024457faeULL, 0x0003e8000b901c4cULL,
0x0000000026477faeULL, 0x0003e8000b901c4cULL, 0x0000000028497faeULL, 0x0003e8000b901c4cULL,
0x000000002a4b7faeULL, 0x0003e8000b901c4cULL, 0x000000002c4f7faeULL, 0x0003e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c600ff080075a7ULL, 0x000ea2000800017fULL,
0x000000030e00780cULL, 0x000fe20003f24070ULL, 0x00000001ff1f7424ULL, 0x002fe400078e00ffULL,
0x80000000ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000004400a88947ULL, 0x004ff20003800000ULL,
0x0000000000ac1947ULL, 0x000fea0003800000ULL, 0x000000200e0a7824ULL, 0x000fc800078e0207ULL,
0x000000200a0c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0b7819ULL, 0x000fc8000001160aULL,
0x1ffffffe0b0b7812ULL, 0x000fe400078ec0ffULL, 0x000001e00c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000010b117812ULL, 0x040fe200078efcffULL, 0x000000100b137836ULL, 0x040fe20000000000ULL,
0x000000070b0f7812ULL, 0x000fe200078e780aULL, 0x000000110b0b7836ULL, 0x000fe20000000000ULL,
0x0000000711117812ULL, 0x000fe400078e780aULL, 0x0000000713137812ULL, 0x000fe200078e780aULL,
0x000000010c0f7824ULL, 0x040fe200078e020fULL, 0x000000070b0b7812ULL, 0x000fe200078e780aULL,
0x000000010c117824ULL, 0x000fc400078e0211ULL, 0x000000100f0f7824ULL, 0x100fe400078e0208ULL,
0x0000001011117824ULL, 0x100fe400078e0208ULL, 0x000000010c0b7824ULL, 0x040fe200078e020bULL,
0x000000000f187984ULL, 0x000e620000000c00ULL, 0x000000010c137824ULL, 0x000fe400078e0213ULL,
0x000000100b0b7824ULL, 0x100fe200078e0208ULL, 0x0000000011147984ULL, 0x000ea20000000c00ULL,
0x0000001013137824ULL, 0x000fc400078e0208ULL, 0x000000ffff207224ULL, 0x002fe400078e0018ULL,
0x000000ffff217224ULL, 0x000fe400078e001aULL, 0x000000ffff227224ULL, 0x004fe400078e0014ULL,
0x000000ffff237224ULL, 0x000fe400078e0016ULL, 0x000000ffff247224ULL, 0x000fe400078e0019ULL,
0x000000ffff257224ULL, 0x000fe200078e001bULL, 0x000000200f007388ULL, 0x000fe20000000c00ULL,
0x000000ffff267224ULL, 0x000fc400078e0015ULL, 0x000000ffff277224ULL, 0x000fca00078e0017ULL,
0x0000002411007388ULL, 0x000fe80000000c00ULL, 0x000000000b147984ULL, 0x000e680000000c00ULL,
0x0000000013187984ULL, 0x000ea20000000c00ULL, 0x000000ffff2b7224ULL, 0x002fe400078e0016ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0014ULL, 0x000000ffff167224ULL, 0x000fe400078e0015ULL,
0x000000ffff287224ULL, 0x004fe400078e0018ULL, 0x000000ffff297224ULL, 0x000fe400078e001aULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x000000ffff157224ULL, 0x000fe200078e001bULL,
0x0000002813007388ULL, 0x0003e80000000c00ULL, 0x000000140b007388ULL, 0x0003e40000000c00ULL,
0x01c6001f08ff79a7ULL, 0x0005e2000850003fULL, 0x0000000502007c0cULL, 0x000fe2000bf26070ULL,
0x01c6001d080075a7ULL, 0x000ee4000800017fULL, 0x0000004400008947ULL, 0x00cff40003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000900000087ab9ULL, 0x000fe20000000800ULL,
0x3d80000009097820ULL, 0x000fe20000410000ULL, 0x000000100e0a7824ULL, 0x000fe200078e0208ULL,
0x00007610ff0c7816ULL, 0x000fe2000000000cULL, 0x000000ffff0b7224ULL, 0x002fe200078e00ffULL,
0xffffffff05077890ULL, 0x000fe2000fffe03fULL, 0x000000080d0d7c24ULL, 0x000fd6000f8e02ffULL,
0x00000100020f7824ULL, 0x000fca00078e0205ULL, 0x0000000b0f007c0cULL, 0x000fda000bf01070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e000bULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fce000001ff00ULL, 0x000000013c127836ULL, 0x000fe40000000000ULL,
0x000000ffff417224ULL, 0x000fe400078e003cULL, 0x000000ffff3c7224ULL, 0x100fe200078e0012ULL,
0x00000001ff0b7819ULL, 0x000fe40000011612ULL, 0x000000021200780cULL, 0x040fe40003f06070ULL,
0x0000000112117812ULL, 0x000fe200078ec0ffULL, 0x000000000b147224ULL, 0x000fc800078e0202ULL,
0x00000001140b7836ULL, 0x040fe40000000000ULL, 0x0000010014147824ULL, 0x000fc600078e0205ULL,
0x000000050b007c0cULL, 0x000fe4000bf26070ULL, 0x0000004014137812ULL, 0x000fe400078ec0ffULL,
0x00000001100b7812ULL, 0x000fc600078e0cffULL, 0x0000000106137824ULL, 0x000fcc00078e0213ULL,
0x0000000800f49947ULL, 0x020fea0003800000ULL, 0x00000003ff427819ULL, 0x000fe20000011607ULL,
0x0000000604407c24ULL, 0x000fe2000f8e0213ULL, 0x0000000b143d7c48ULL, 0x000fc6000ffe0000ULL,
0x0000000842447836ULL, 0x000fe40000000000ULL, 0x000000013d3d7824ULL, 0x000fe400078e0a14ULL,
0x0000000844567824ULL, 0x040fe200078e00ffULL, 0x0000000744157212ULL, 0x000fe200078e3cffULL,
0x00000004421e7836ULL, 0x040fe20000000000ULL, 0x0000003d4200720cULL, 0x040fe20003f26070ULL,
0x00000010425c7836ULL, 0x000fe20000000000ULL, 0xfffffff856567812ULL, 0x000fe200078ee215ULL,
0x000000081e177824ULL, 0x040fe200078e00ffULL, 0x00008a00ff147b82ULL, 0x000e620000000a00ULL,
0x000000071e127212ULL, 0x080fe200078e3cffULL, 0x0000001442607836ULL, 0x000fe20000000000ULL,
0x000000075c167212ULL, 0x0c0fe200078e3cffULL, 0x000000085c1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8173e7812ULL, 0x000fe200078ee212ULL, 0x0000000c42587836ULL, 0x000fe20000000000ULL,
0x0000000760177212ULL, 0x0c0fe200078e3cffULL, 0x0000000860627824ULL, 0x000fe200078e00ffULL,
0xfffffff81f5e7812ULL, 0x000fe200078ee216ULL, 0x0000000811167824ULL, 0x000fe200078e00ffULL,
0x0000000758127212ULL, 0x0c0fe200078e3cffULL, 0x00000008581d7824ULL, 0x000fe200078e00ffULL,
0xfffffff862627812ULL, 0x000fe200078ee217ULL, 0x0000001842527836ULL, 0x040fe20000000000ULL,
0x0000007f42177812ULL, 0x040fe200078ec0ffULL, 0x0000001c42507836ULL, 0x040fe20000000000ULL,
0xfffffff816137812ULL, 0x000fe200078ee207ULL, 0x00000020424e7836ULL, 0x000fe20000000000ULL,
0xfffffff81d5a7812ULL, 0x000fe200078ee212ULL, 0x000040000e127824ULL, 0x000fe200078e0208ULL,
0x0000000742167212ULL, 0x080fe200078e3cffULL, 0x0000000117177824ULL, 0x000fe200078e0240ULL,
0x0000000752547212ULL, 0x080fe200078e3cffULL, 0x000020000b437824ULL, 0x000fe200078e0212ULL,
0x00000007161c7812ULL, 0x000fe200078ec0ffULL, 0x00000024424c7836ULL, 0x000fe20000000000ULL,
0x00000007504a7212ULL, 0x000fe200078e3cffULL, 0x0000010017167825ULL, 0x002fe200078e0014ULL,
0x0ffffff81c1c7812ULL, 0x000fc400078ef807ULL, 0x000000074e487212ULL, 0x080fe200078e3cffULL,
0x00000008521f7824ULL, 0x000fe200078e00ffULL, 0x000000074c467212ULL, 0x000fe200078e3cffULL,
0x0000200043437836ULL, 0x000fe20000000000ULL, 0x0000007f60497812ULL, 0x000fe200078ec0ffULL,
0x00000008503f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f547812ULL, 0x000fe200078ee254ULL,
0x000000084e457824ULL, 0x000fe200078e00ffULL, 0x0000007f1e1f7812ULL, 0x000fe200078ec0ffULL,
0x000000084c477824ULL, 0x000fe200078e00ffULL, 0xfffffff83f4a7812ULL, 0x000fe200078ee24aULL,
0x000000101c1d7824ULL, 0x000fe200078e0243ULL, 0xfffffff845487812ULL, 0x000fe200078ee248ULL,
0x0000001013167825ULL, 0x000fe200078e0016ULL, 0x0000007f443f7812ULL, 0x000fc400078ec0ffULL,
0xfffffff847467812ULL, 0x000fe200078ee246ULL, 0x000000105a4b7824ULL, 0x100fe200078e0243ULL,
0x0000007f58457812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161d7faeULL, 0x0003e2000c901c4cULL, 0x0000007f5c477812ULL, 0x000fe200078ec0ffULL,
0x000000105e4d7824ULL, 0x100fe200078e0243ULL, 0x0000003d1e00720cULL, 0x080fe20003f26070ULL,
0x00000010624f7824ULL, 0x000fe200078e0243ULL, 0x0000003d4400720cULL, 0x080fe40003f46070ULL,
0x0000003d5800720cULL, 0x000fc40003f66070ULL, 0x0000003d5c00720cULL, 0x080fe40003f86070ULL,
0x0000003d6000720cULL, 0x000fe20003fa6070ULL, 0x000000011f1d7824ULL, 0x102fe200078e0240ULL,
0x0000007f52517812ULL, 0x000fe200078ec0ffULL, 0x000000013f1f7824ULL, 0x100fe200078e0240ULL,
0x0000007f50537812ULL, 0x000fe200078ec0ffULL, 0x00000001453f7824ULL, 0x100fe200078e0240ULL,
0x0000007f4e557812ULL, 0x000fe200078ec0ffULL, 0x0000000147457824ULL, 0x100fe400078e0240ULL,
0x0000000149177824ULL, 0x000fc400078e0240ULL, 0x000001001d1c7825ULL, 0x000fc800078e0014ULL,
0x000000103e477824ULL, 0x000fe400078e0243ULL, 0x000001001f1e7825ULL, 0x000fc800078e0014ULL,
0x000001003f3e7825ULL, 0x000fc800078e0014ULL, 0x0000010045447825ULL, 0x000fc800078e0014ULL,
0x0000010017167825ULL, 0x000fc800078e0014ULL, 0x00000010131c7825ULL, 0x000fc800078e001cULL,
0x0000001056497824ULL, 0x000fe200078e0243ULL, 0x000000001c477faeULL, 0x0003e2000c901c4cULL,
0x00000010131e7825ULL, 0x000fe200078e001eULL, 0x0000003d5200720cULL, 0x000fc60003f26070ULL,
0x00000010133e7825ULL, 0x040fe200078e003eULL, 0x000000001e497faeULL, 0x0005e2000d101c4cULL,
0x0000003d5000720cULL, 0x080fe40003f46070ULL, 0x0000001013447825ULL, 0x040fe200078e0044ULL,
0x000000003e4b7faeULL, 0x0007e2000d901c4cULL, 0x0000003d4e00720cULL, 0x080fe40003f66070ULL,
0x0000001013167825ULL, 0x000fe200078e0016ULL, 0x00000000444d7faeULL, 0x0009e2000e101c4cULL,
0x0000003d4c00720cULL, 0x000fc40003f86070ULL, 0x00000001511d7824ULL, 0x102fe200078e0240ULL,
0x0000007f4c497812ULL, 0x004fe200078ec0ffULL, 0x00000000164f7faeULL, 0x0003e2000e901c4cULL,
0x00000001531f7824ULL, 0x100fe400078e0240ULL, 0x00000001553f7824ULL, 0x108fe400078e0240ULL,
0x0000000149497824ULL, 0x000fe400078e0240ULL, 0x0000001054457824ULL, 0x010fe400078e0243ULL,
0x0000002842447836ULL, 0x000fc40000000000ULL, 0x000000104a477824ULL, 0x000fe400078e0243ULL,
0x000001001d167825ULL, 0x002fc800078e0014ULL, 0x000001001f1c7825ULL, 0x000fc800078e0014ULL,
0x000001003f1e7825ULL, 0x000fc800078e0014ULL, 0x0000001013167825ULL, 0x000fc800078e0016ULL,
0x00000100493e7825ULL, 0x000fe200078e0014ULL, 0x0000000016457faeULL, 0x0003e2000c901c4cULL,
0x0000003d4400720cULL, 0x000fe40003f26070ULL, 0x00000010131c7825ULL, 0x000fc800078e001cULL,
0x0000001048497824ULL, 0x000fe200078e0243ULL, 0x000000001c477faeULL, 0x0005e2000d101c4cULL,
0x00000010131e7825ULL, 0x000fe200078e001eULL, 0x0000000744167212ULL, 0x002fc600078e3cffULL,
0x00000010464b7824ULL, 0x000fe200078e0243ULL, 0x000000001e497faeULL, 0x0003e2000d901c4cULL,
0x00000010133e7825ULL, 0x000fc800078e003eULL, 0x0000000844177824ULL, 0x000fe200078e00ffULL,
0x000000003e4b7faeULL, 0x0007e2000e101c4cULL, 0x0000002c42467836ULL, 0x040fe40000000000ULL,
0x0000003042487836ULL, 0x040fe20000000000ULL, 0xfffffff817167812ULL, 0x000fe200078ee216ULL,
0x00000034424a7836ULL, 0x000fe20000000000ULL, 0x0000003d4600720cULL, 0x080fe20003f46070ULL,
0x00000038424c7836ULL, 0x000fe20000000000ULL, 0x0000003d4800720cULL, 0x080fe20003f66070ULL,
0x0000003c42507836ULL, 0x000fe20000000000ULL, 0x0000003d4a00720cULL, 0x080fe20003f86070ULL,
0x00000008461c7824ULL, 0x004fe200078e00ffULL, 0x0000003d4c00720cULL, 0x080fe20003fa6070ULL,
0x00000008481e7824ULL, 0x002fe200078e00ffULL, 0x0000003d5000720cULL, 0x000fe20003fc6070ULL,
0x000000084a3e7824ULL, 0x008fe200078e00ffULL, 0x0000000746177212ULL, 0x080fe200078e3cffULL,
0x000000084c4e7824ULL, 0x000fe200078e00ffULL, 0x00000007481d7212ULL, 0x000fc400078e3cffULL,
0x000000074a1f7212ULL, 0x080fe400078e3cffULL, 0x000000074c3d7212ULL, 0x080fe400078e3cffULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee217ULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee21dULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee21fULL, 0x000000101c477824ULL, 0x100fe200078e0243ULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee23dULL, 0x000000101e497824ULL, 0x100fe200078e0243ULL,
0x0000007f44177812ULL, 0x000fe200078ec0ffULL, 0x000000103e4b7824ULL, 0x100fe200078e0243ULL,
0x0000007f461d7812ULL, 0x000fe200078ec0ffULL, 0x000000104e4d7824ULL, 0x000fe200078e0243ULL,
0x0000007f481f7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x100fe200078e0240ULL,
0x0000007f4a3f7812ULL, 0x000fe200078ec0ffULL, 0x000000011d1d7824ULL, 0x100fe200078e0240ULL,
0x0000007f4c457812ULL, 0x000fe200078ec0ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0240ULL,
0x0000007f504f7812ULL, 0x040fe200078ec0ffULL, 0x000000013f3f7824ULL, 0x000fe200078e0240ULL,
0x00000007503d7212ULL, 0x040fe200078e3cffULL, 0x0000000850507824ULL, 0x000fc400078e00ffULL,
0x0000000145457824ULL, 0x100fe400078e0240ULL, 0x000000014f4f7824ULL, 0x000fe200078e0240ULL,
0xfffffff850407812ULL, 0x000fe200078ee23dULL, 0x00000010163d7824ULL, 0x000fe400078e0243ULL,
0x0000010017167825ULL, 0x000fc800078e0014ULL, 0x000001001d1c7825ULL, 0x000fc800078e0014ULL,
0x000001001f1e7825ULL, 0x000fc800078e0014ULL, 0x000001003f3e7825ULL, 0x000fc800078e0014ULL,
0x0000010045447825ULL, 0x000fc800078e0014ULL, 0x000001004f147825ULL, 0x000fc800078e0014ULL,
0x0000001013167825ULL, 0x000fc800078e0016ULL, 0x00000010131c7825ULL, 0x040fe200078e001cULL,
0x00000000163d7faeULL, 0x0003e6000c901c4cULL, 0x00000010131e7825ULL, 0x040fe200078e001eULL,
0x000000001c477faeULL, 0x0003e6000d101c4cULL, 0x00000010133e7825ULL, 0x040fe200078e003eULL,
0x000000001e497faeULL, 0x0003e6000d901c4cULL, 0x0000001013447825ULL, 0x040fe200078e0044ULL,
0x000000003e4b7faeULL, 0x0003e6000e101c4cULL, 0x0000001040437824ULL, 0x000fe200078e0243ULL,
0x00000000444d7faeULL, 0x0003e2000e901c4cULL, 0x0000001013147825ULL, 0x000fca00078e0014ULL,
0x0000000014437faeULL, 0x0003e2000f101c4cULL, 0x0000000800a87947ULL, 0x000fea0003800000ULL,
0x00000003ff427819ULL, 0x000fe20000011607ULL, 0x00008a00ff607b82ULL, 0x000e620000000a00ULL,
0x0000000604137c24ULL, 0x000fe4000f8e0213ULL, 0x0000000742447212ULL, 0x0c0fe200078e3cffULL,
0x0000000442467836ULL, 0x040fe40000000000ULL, 0x0000000c424a7836ULL, 0x000fe20000000000ULL,
0x0000000744447812ULL, 0x000fe200078ec0ffULL, 0x0000000846157824ULL, 0x040fe200078e00ffULL,
0x0000000746647212ULL, 0x080fe200078e3cffULL, 0x0000000842487836ULL, 0x000fe20000000000ULL,
0x000000074a627212ULL, 0x080fe200078e3cffULL, 0x0000002042547836ULL, 0x000fe20000000000ULL,
0xfffffff815647812ULL, 0x000fe200078ee264ULL, 0x000000084a157824ULL, 0x000fe200078e00ffULL,
0x0000000748637212ULL, 0x0c0fe200078e3cffULL, 0x0000000848127824ULL, 0x000fe200078e00ffULL,
0x00000007541e7212ULL, 0x080fe200078e3cffULL, 0x00000010424c7836ULL, 0x040fe20000000000ULL,
0xfffffff815627812ULL, 0x000fe200078ee262ULL, 0x00000014424e7836ULL, 0x040fe20000000000ULL,
0xfffffff812637812ULL, 0x000fe200078ee263ULL, 0x0000001842507836ULL, 0x000fe20000000000ULL,
0x000000074c437212ULL, 0x080fe200078e3cffULL, 0x0000000854157824ULL, 0x000fe200078e00ffULL,
0x000000074e407212ULL, 0x080fe200078e3cffULL, 0x000000084c127824ULL, 0x000fe200078e00ffULL,
0x00000007503d7212ULL, 0x080fe200078e3cffULL, 0x00000034425e7836ULL, 0x000fe20000000000ULL,
0xfffffff8151e7812ULL, 0x000fe200078ee21eULL, 0x000000084e177824ULL, 0x000fe200078e00ffULL,
0xfffffff812437812ULL, 0x000fe200078ee243ULL, 0x0000001c42527836ULL, 0x000fe20000000000ULL,
0x000000075e157212ULL, 0x080fe200078e3cffULL, 0x0000000850147824ULL, 0x000fe200078e00ffULL,
0xfffffff817407812ULL, 0x000fe200078ee240ULL, 0x0000002842587836ULL, 0x000fe20000000000ULL,
0x00000007521f7212ULL, 0x080fe200078e3cffULL, 0x000000085e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8143d7812ULL, 0x000fe200078ee23dULL, 0x0000002442567836ULL, 0x000fe20000000000ULL,
0x00000007581c7212ULL, 0x080fe200078e3cffULL, 0x0000000852127824ULL, 0x000fe200078e00ffULL,
0xfffffff83e157812ULL, 0x000fe200078ee215ULL, 0x0000000858177824ULL, 0x000fe200078e00ffULL,
0x00000007561d7212ULL, 0x080fe200078e3cffULL, 0x0000002c425a7836ULL, 0x040fe20000000000ULL,
0x0000007f423e7812ULL, 0x000fe200078ec0ffULL, 0x0000000856147824ULL, 0x000fe200078e00ffULL,
0xfffffff8121f7812ULL, 0x000fe200078ee21fULL, 0x00000030425c7836ULL, 0x040fe20000000000ULL,
0xfffffff8171c7812ULL, 0x000fe200078ee21cULL, 0x0000003842667836ULL, 0x000fe20000000000ULL,
0x000000075a177212ULL, 0x080fe200078e3cffULL, 0x0000003c42687836ULL, 0x000fe20000000000ULL,
0xfffffff8141d7812ULL, 0x000fe200078ee21dULL, 0x000000085a127824ULL, 0x000fe200078e00ffULL,
0x000000075c167212ULL, 0x0c0fe200078e3cffULL, 0x000000085c3f7824ULL, 0x000fe200078e00ffULL,
0x0000000766147212ULL, 0x0c0fe200078e3cffULL, 0x0000000866457824ULL, 0x000fe200078e00ffULL,
0x0000007f46467812ULL, 0x000fe200078ec0ffULL, 0x000000013e5f7824ULL, 0x100fe200078e0213ULL,
0x0000007f48487812ULL, 0x000fe200078ec0ffULL, 0x0000000868657824ULL, 0x000fe200078e00ffULL,
0x0000007f4a4a7812ULL, 0x000fe200078ec0ffULL, 0x00000001465d7824ULL, 0x100fe200078e0213ULL,
0x0000007f4c4c7812ULL, 0x000fe200078ec0ffULL, 0x0000000811467824ULL, 0x000fe200078e00ffULL,
0x0000007f4e4e7812ULL, 0x000fe200078ec0ffULL, 0x000000014a5b7824ULL, 0x100fe200078e0213ULL,
0x0000007f50507812ULL, 0x000fe200078ec0ffULL, 0x000000014c597824ULL, 0x100fe200078e0213ULL,
0x0000007f52527812ULL, 0x000fe200078ec0ffULL, 0x000000014e577824ULL, 0x100fe200078e0213ULL,
0x0000007f54547812ULL, 0x000fe200078ec0ffULL, 0x0000000150557824ULL, 0x100fe200078e0213ULL,
0x0000007f56567812ULL, 0x000fe200078ec0ffULL, 0x0000000152537824ULL, 0x100fe200078e0213ULL,
0x0000007f58587812ULL, 0x000fe200078ec0ffULL, 0x0000000154517824ULL, 0x100fe200078e0213ULL,
0x0000007f5a5a7812ULL, 0x000fe200078ec0ffULL, 0x00000001564f7824ULL, 0x100fe200078e0213ULL,
0x0000007f5c5c7812ULL, 0x000fe200078ec0ffULL, 0x00000001584d7824ULL, 0x100fe200078e0213ULL,
0x0000007f5e5e7812ULL, 0x000fe200078ec0ffULL, 0x000000015a4b7824ULL, 0x100fe200078e0213ULL,
0x0000007f66667812ULL, 0x000fe200078ec0ffULL, 0x000000015c497824ULL, 0x100fe200078e0213ULL,
0x0000007f683e7812ULL, 0x000fe200078ec0ffULL, 0x000000015e477824ULL, 0x100fe200078e0213ULL,
0xfffffff812177812ULL, 0x000fe200078ee217ULL, 0x000040000e127824ULL, 0x000fe200078e0208ULL,
0xfffffff83f167812ULL, 0x000fe200078ee216ULL, 0x00000001483f7824ULL, 0x100fe200078e0213ULL,
0xfffffff845147812ULL, 0x000fe200078ee214ULL, 0x0000000166457824ULL, 0x100fe200078e0213ULL,
0x0ffffff844447812ULL, 0x000fe200078ef807ULL, 0x000000013e697824ULL, 0x000fe200078e0213ULL,
0x00000007683e7212ULL, 0x000fe200078e3cffULL, 0x000020000b137824ULL, 0x000fc400078e0212ULL,
0x000001005f5e7825ULL, 0x102fe200078e0060ULL, 0xfffffff8653e7812ULL, 0x000fe400078ee23eULL,
0xfffffff846657812ULL, 0x000fe200078ee207ULL, 0x0000200013137836ULL, 0x000fe40000000000ULL,
0x000001005d5c7825ULL, 0x000fc800078e0060ULL, 0x0000001044677824ULL, 0x100fe400078e0213ULL,
0x0000001064647824ULL, 0x100fe400078e0213ULL, 0x0000001063637824ULL, 0x100fe400078e0213ULL,
0x0000001062627824ULL, 0x100fe400078e0213ULL, 0x0000001043437824ULL, 0x100fe400078e0213ULL,
0x0000001040407824ULL, 0x000fc400078e0213ULL, 0x000000103d3d7824ULL, 0x100fe400078e0213ULL,
0x000000101f1f7824ULL, 0x100fe400078e0213ULL, 0x000000101e1e7824ULL, 0x100fe400078e0213ULL,
0x000000101d1d7824ULL, 0x100fe400078e0213ULL, 0x000000101c1c7824ULL, 0x100fe400078e0213ULL,
0x0000001017177824ULL, 0x000fc400078e0213ULL, 0x0000001016167824ULL, 0x100fe400078e0213ULL,
0x0000001015157824ULL, 0x100fe400078e0213ULL, 0x0000001014147824ULL, 0x100fe400078e0213ULL,
0x000000103e137824ULL, 0x000fe400078e0213ULL, 0x000001003f3e7825ULL, 0x000fc800078e0060ULL,
0x000001005b5a7825ULL, 0x000fc800078e0060ULL, 0x0000010059587825ULL, 0x000fc800078e0060ULL,
0x0000010057567825ULL, 0x000fc800078e0060ULL, 0x00000010655e7825ULL, 0x000fc800078e005eULL,
0x0000010055547825ULL, 0x100fe200078e0060ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005e677faeULL, 0x0003e6000b901c4cULL, 0x0000010053527825ULL, 0x000fc800078e0060ULL,
0x00000010655c7825ULL, 0x000fc800078e005cULL, 0x0000010051507825ULL, 0x000fe200078e0060ULL,
0x000000005c647faeULL, 0x0003e6000b901c4cULL, 0x00000010653e7825ULL, 0x000fc800078e003eULL,
0x000001004f4e7825ULL, 0x000fe200078e0060ULL, 0x000000003e637faeULL, 0x0003e6000b901c4cULL,
0x00000010655a7825ULL, 0x000fc800078e005aULL, 0x000001004d4c7825ULL, 0x000fe200078e0060ULL,
0x000000005a627faeULL, 0x0003e6000b901c4cULL, 0x0000001065587825ULL, 0x000fc800078e0058ULL,
0x000001004b4a7825ULL, 0x000fe200078e0060ULL, 0x0000000058437faeULL, 0x0003e6000b901c4cULL,
0x0000001065567825ULL, 0x000fc800078e0056ULL, 0x0000010049487825ULL, 0x000fe200078e0060ULL,
0x0000000056407faeULL, 0x0003e6000b901c4cULL, 0x0000001065547825ULL, 0x000fc800078e0054ULL,
0x0000010047467825ULL, 0x000fe200078e0060ULL, 0x00000000543d7faeULL, 0x0003e6000b901c4cULL,
0x0000001065527825ULL, 0x000fc800078e0052ULL, 0x0000010045447825ULL, 0x000fe200078e0060ULL,
0x00000000521f7faeULL, 0x0003e6000b901c4cULL, 0x0000001065507825ULL, 0x000fc800078e0050ULL,
0x0000010069607825ULL, 0x000fe200078e0060ULL, 0x00000000501e7faeULL, 0x0003e6000b901c4cULL,
0x00000010654e7825ULL, 0x000fc800078e004eULL, 0x00000010654c7825ULL, 0x040fe200078e004cULL,
0x000000004e1d7faeULL, 0x0003e6000b901c4cULL, 0x00000010654a7825ULL, 0x040fe200078e004aULL,
0x000000004c1c7faeULL, 0x0003e6000b901c4cULL, 0x0000001065487825ULL, 0x040fe200078e0048ULL,
0x000000004a177faeULL, 0x0003e6000b901c4cULL, 0x0000001065467825ULL, 0x040fe200078e0046ULL,
0x0000000048167faeULL, 0x0003e6000b901c4cULL, 0x0000001065447825ULL, 0x040fe200078e0044ULL,
0x0000000046157faeULL, 0x0003e6000b901c4cULL, 0x0000001065607825ULL, 0x000fe200078e0060ULL,
0x0000000044147faeULL, 0x0003e8000b901c4cULL, 0x0000000060137faeULL, 0x0003e4000b901c4cULL,
0x000000ff1100720cULL, 0x000fda0003f25270ULL, 0x0000000000209947ULL, 0x000fea0003800000ULL,
0x0000000200037824ULL, 0x000fe400078e0203ULL, 0xffffffffff047424ULL, 0x000fc600078e00ffULL,
0x0000000403007c0cULL, 0x000fda000bf26070ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x00008c00ff147b82ULL, 0x002e620000000a00ULL, 0x000000020d117824ULL, 0x000fc800078e0203ULL,
0x0000000411147825ULL, 0x002fca00078e0014ULL, 0x0000000c14047981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000200010407824ULL, 0x002fe200078e0212ULL,
0xfffffff807107812ULL, 0x040fe200078ec0ffULL, 0x0000002007127836ULL, 0x040fe20000000000ULL,
0x0000000707447812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x00000007103f7812ULL, 0x000fe200078ef807ULL, 0x0000200040407836ULL, 0x000fe20000000000ULL,
0xfffffff812127812ULL, 0x000fe400078ec0ffULL, 0x00000008443e7812ULL, 0x000fc400078ef807ULL,
0x0000000712437812ULL, 0x000fe200078ef807ULL, 0x000080400000791aULL, 0x000fcc0000000000ULL,
0x000000073d107812ULL, 0x000fe200078e783fULL, 0x0000000841787824ULL, 0x000fe200078e023dULL,
0x000000073d147812ULL, 0x000fc600078e7843ULL, 0x000000083f117824ULL, 0x000fe400078e0210ULL,
0x0000000843157824ULL, 0x000fe400078e0214ULL, 0x0000001011117824ULL, 0x100fe400078e0240ULL,
0x0000001015157824ULL, 0x000fe400078e0240ULL, 0x0000000278787824ULL, 0x000fe400078e00ffULL,
0x000000001110783bULL, 0x000e680000000200ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x00000018ff5b7819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x00008880105f7816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x00008880115e7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x00000018ff557819ULL, 0x000fc40000011412ULL, 0x0000888012547816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff6f7819ULL, 0x000fe20000011413ULL,
0x00000010005d7306ULL, 0x0002e20000202400ULL, 0x0000888013717816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff687819ULL, 0x004fe20000011414ULL, 0x0000001100757306ULL, 0x0005e20000202400ULL,
0x0001000012107824ULL, 0x002fe200078e00ffULL, 0x00008880146d7816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011415ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x044fe200078e00ffULL, 0x0000001c00777306ULL, 0x000fe20000202400ULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00008880156a7816ULL, 0x000fc400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000001200737306ULL, 0x0003e20000202400ULL, 0x00000018ff5a7819ULL, 0x000fe40000011416ULL,
0x00000018ff457819ULL, 0x000fe40000011417ULL, 0x0000888016667816ULL, 0x000fe400000000ffULL,
0x0000888017617816ULL, 0x000fe200000000ffULL, 0x0000001300707306ULL, 0x0005e20000202400ULL,
0x000000013d127836ULL, 0x002fc40000000000ULL, 0x000000023d3d7836ULL, 0x000fc60000000000ULL,
0x00000007121c7812ULL, 0x000fe400078e783fULL, 0x0000001d00767306ULL, 0x0003e20000202400ULL,
0x0000000712127812ULL, 0x000fe400078e7843ULL, 0x000000083f137824ULL, 0x004fe200078e021cULL,
0x000000083d00780cULL, 0x000fe40003f25270ULL, 0x0000000843477824ULL, 0x000fe400078e0212ULL,
0x0000001013137824ULL, 0x100fe200078e0240ULL, 0x0000001000747306ULL, 0x0005e20000202400ULL,
0x0000001047127824ULL, 0x000fc600078e0240ULL, 0x00000000131c783bULL, 0x002e680000000200ULL,
0x0000001100727306ULL, 0x0009e20000202400ULL, 0x0001000014107824ULL, 0x044fe400078e00ffULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0001000015117824ULL, 0x050fe200078e00ffULL,
0x00000010006e7306ULL, 0x0005e20000202400ULL, 0x0000010015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000014006c7306ULL, 0x0009e20000202400ULL, 0x0001000016107824ULL, 0x044fe400078e00ffULL,
0x0000010016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011410ULL,
0x0000001500697306ULL, 0x0003e20000202400ULL, 0x0001000017147824ULL, 0x050fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000010017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000001600657306ULL, 0x000fe20000202400ULL, 0x000100001d157824ULL, 0x002fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe4000001141cULL, 0x000088801c487816ULL, 0x000fe400000000ffULL,
0x00000018ff567819ULL, 0x000fe40000011415ULL, 0x0000007807157211ULL, 0x000fe200078fe0ffULL,
0x0000001400627306ULL, 0x0003e20000202400ULL, 0x00000018ff4e7819ULL, 0x000fe2000001141dULL,
0x0000000278787836ULL, 0x000fe20000000000ULL, 0x0000000715157812ULL, 0x000fc400078e783eULL,
0x000088801d4f7816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001141fULL, 0x000000203e157824ULL, 0x000fe200078e0215ULL,
0x0000001700607306ULL, 0x000fe20000202400ULL, 0x000100001c147824ULL, 0x042fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0000001015157824ULL, 0x000fe200078e0208ULL,
0x000088801f577816ULL, 0x000fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000011006b7306ULL, 0x0003e20000202400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001141eULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x000088801e537816ULL, 0x000fc600000000ffULL, 0x0000001400507306ULL, 0x0005e20000202400ULL,
0x000000001210783bULL, 0x002e6e0000000200ULL, 0x0000005f005f7306ULL, 0x000f220000202400ULL,
0x000100001e147824ULL, 0x044fe400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011414ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x0000001c00517306ULL, 0x0007e20000202400ULL, 0x00000018ff1e7819ULL, 0x000fce000001141eULL,
0x0000001d00527306ULL, 0x0009e20000202400ULL, 0x000100001f1c7824ULL, 0x048fe400078e00ffULL,
0x000001001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x000054105d1d7816ULL, 0x010fe4000000005bULL,
0x00000018ff1f7819ULL, 0x000fca000001141fULL, 0x0000001c005c7306ULL, 0x0007e20000202400ULL,
0x00000018ff4b7819ULL, 0x002fe40000011410ULL, 0x00008880105d7816ULL, 0x000fe400000000ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011411ULL, 0x00000018ff477819ULL, 0x000fe20000011413ULL,
0x0000005e005e7306ULL, 0x000e620000202400ULL, 0x000054105f1c7816ULL, 0x008fe40000000077ULL,
0x00000018ff497819ULL, 0x000fca0000011412ULL, 0x0000001c1438723cULL, 0x004fe20000041838ULL,
0x0000005500557306ULL, 0x000eac0000202400ULL, 0x00010000101d7824ULL, 0x000fe200078e00ffULL,
0x000054105e1c7816ULL, 0x002fe20000000076ULL, 0x0000005400547306ULL, 0x000e620000202400ULL,
0x0000010010107824ULL, 0x000fc400078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001141dULL,
0x00000078071d7211ULL, 0x000fe400078fe0ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000001f005b7306ULL, 0x0007e20000202400ULL, 0x0000541073557816ULL, 0x004fe40000000055ULL,
0x0000541054547816ULL, 0x002fca0000000074ULL, 0x0000006f006f7306ULL, 0x000e620000202400ULL,
0x000000071d1f7812ULL, 0x008fe400078e783eULL, 0x00005410751d7816ULL, 0x000fe20000000063ULL,
0x000000541430723cULL, 0x000fe40000041830ULL, 0x000000203e1f7824ULL, 0x000fe400078e021fULL,
0x0000007100717306ULL, 0x000ea40000202400ULL, 0x000000101f1f7824ULL, 0x000fe200078e0208ULL,
0x0000001c1434723cULL, 0x000fe20000041834ULL, 0x0000010011557824ULL, 0x000fc800078e00ffULL,
0x00000010005e7306ULL, 0x0007e20000202400ULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x00010000111c7824ULL, 0x000fcc00078e00ffULL, 0x0000006d006d7306ULL, 0x000f220000202400ULL,
0x00000018ff107819ULL, 0x008fce000001141cULL, 0x0000001e00587306ULL, 0x0007f00000202400ULL,
0x0000006800687306ULL, 0x000ea20000202400ULL, 0x00008880111e7816ULL, 0x008fe400000000ffULL,
0x0000541070117816ULL, 0x002fc6000000006fULL, 0x000000ffff637224ULL, 0x000fe400078e001eULL,
0x0000001000547306ULL, 0x0005e20000202400ULL, 0x000000001f1c783bULL, 0x000e6e0000000200ULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x0000541071107816ULL, 0x004fce0000000072ULL,
0x0000006a006a7306ULL, 0x000ea20000202400ULL, 0x00000010142c723cULL, 0x000fee000004182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x000054106d107816ULL, 0x010fc6000000006eULL, 0x000000ffff6d7224ULL, 0x000fe200078e0011ULL,
0x000054106c117816ULL, 0x000fe20000000068ULL, 0x00010000126c7824ULL, 0x000fe400078e00ffULL,
0x0000006600667306ULL, 0x000fe60000202400ULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x000000101428723cULL, 0x000fe80000041828ULL, 0x0000006700677306ULL, 0x000ee60000202400ULL,
0x000054106a107816ULL, 0x004fc4000000006bULL, 0x0000541069117816ULL, 0x000fc60000000064ULL,
0x0000004500457306ULL, 0x000fe80000202400ULL, 0x000000101424723cULL, 0x000fe80000041824ULL,
0x0000006100617306ULL, 0x000ea60000202400ULL, 0x0000010012117824ULL, 0x000fe200078e00ffULL,
0x0000541066107816ULL, 0x008fc80000000067ULL, 0x00000018ff647819ULL, 0x000fe20000011411ULL,
0x0000004e004e7306ULL, 0x000ee20000202400ULL, 0x0000541065117816ULL, 0x000fe4000000005aULL,
0x0000888013657816ULL, 0x000fca00000000ffULL, 0x000000101420723cULL, 0x000fe20000041820ULL,
0x0000004f004f7306ULL, 0x000fec0000202400ULL, 0x0000541061107816ULL, 0x004fe40000000062ULL,
0x0000541060117816ULL, 0x000fe20000000045ULL, 0x0000005600567306ULL, 0x000ea20000202400ULL,
0x000000ffff457224ULL, 0x000fca00078e0065ULL, 0x000000101418723cULL, 0x000fe40000041818ULL,
0x0000004d004d7306ULL, 0x000fea0000202400ULL, 0x0001000013107824ULL, 0x040fe200078e00ffULL,
0x0000541052117816ULL, 0x008fe2000000004eULL, 0x0000010013157824ULL, 0x000fe200078e00ffULL,
0x0000005300537306ULL, 0x000fe40000202400ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff157819ULL, 0x000fc80000011415ULL, 0x0000005900597306ULL, 0x000ef00000202400ULL,
0x0000001000137306ULL, 0x0005f00000202400ULL, 0x0000004c004c7306ULL, 0x000fe20000202400ULL,
0x000054104f107816ULL, 0x004fce0000000056ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x000000101c34723cULL, 0x002fee0000041834ULL, 0x0000004800487306ULL, 0x000e620000202400ULL,
0x0000541053107816ULL, 0x008fe40000000059ULL, 0x0000541058117816ULL, 0x000fca000000004dULL,
0x0000004600467306ULL, 0x000ea40000202400ULL, 0x000000101c30723cULL, 0x000fe20000041830ULL,
0x0000541048507816ULL, 0x002fca0000000050ULL, 0x0000004b004b7306ULL, 0x000e620000202400ULL,
0x0000541057107816ULL, 0x000fe4000000005cULL, 0x000054105b117816ULL, 0x000fe4000000004cULL,
0x0000541051517816ULL, 0x004fc60000000046ULL, 0x0000004a004a7306ULL, 0x000fe40000202400ULL,
0x000000101c2c723cULL, 0x000fec000004182cULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x000054105e117816ULL, 0x002fe2000000004bULL, 0x000000501c38723cULL, 0x000fec0000041838ULL,
0x0000004700477306ULL, 0x000ff00000202400ULL, 0x0000005d005d7306ULL, 0x000ff00000202400ULL,
0x0000005f005f7306ULL, 0x000e700000202400ULL, 0x0000006300637306ULL, 0x000ea20000202400ULL,
0x000054105d107816ULL, 0x002fce000000005fULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x000000101c28723cULL, 0x000fe20000041828ULL, 0x0000541063547816ULL, 0x004fcc0000000054ULL,
0x0000006d00687306ULL, 0x000fe20000202400ULL, 0x0000541055557816ULL, 0x002fce000000004aULL,
0x0000006c00127306ULL, 0x000e620000202400ULL, 0x000000541c24723cULL, 0x000fee0000041824ULL,
0x00000064005a7306ULL, 0x000ea20000202400ULL, 0x0000541068487816ULL, 0x002fce0000000012ULL,
0x0000004500147306ULL, 0x000e620000202400ULL, 0x000054105a497816ULL, 0x004fce0000000049ULL,
0x0000001500167306ULL, 0x000ea20000202400ULL, 0x000000481c20723cULL, 0x000fe20000041820ULL,
0x0000541014147816ULL, 0x002fe40000000013ULL, 0x0000541016157816ULL, 0x004fce0000000047ULL,
0x000000141c18723cULL, 0x000fe20000041818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff0002c1947ULL, 0x000fde000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e000bULL,
0xffffffd400f88947ULL, 0x000fec000383ffffULL, 0x0000ffff0c107812ULL, 0x000fe200078ec0ffULL,
0x0000000920167220ULL, 0x080fe20000410000ULL, 0x000000800e207824ULL, 0x000fe400078e0208ULL,
0x0000000924147220ULL, 0x080fe20000410000ULL, 0x0000888010137816ULL, 0x000fe200000000ffULL,
0x0000000407107824ULL, 0x000fe400078e00ffULL, 0x0000000921177220ULL, 0x080fe20000410000ULL,
0x0000000938157220ULL, 0x080fe20000410000ULL, 0x0000000939397220ULL, 0x080fe20000410000ULL,
0x8000000013137824ULL, 0x000fe200078e00ffULL, 0xfffffff010117812ULL, 0x000fe200078ec0ffULL,
0x000000093a3a7220ULL, 0x080fe20000410000ULL, 0x000000093b3b7220ULL, 0x080fe20000410000ULL,
0x01c610130a0075a7ULL, 0x000e62000800017fULL, 0x0000000934347220ULL, 0x080fe20000410000ULL,
0x0000000935357220ULL, 0x080fe20000410000ULL, 0x0000000936367220ULL, 0x080fe20000410000ULL,
0x0000000937377220ULL, 0x080fe20000410000ULL, 0x0000000930307220ULL, 0x080fe20000410000ULL,
0x0000000931317220ULL, 0x080fe20000410000ULL, 0x0000000932327220ULL, 0x080fe20000410000ULL,
0x0000000933337220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x000000092e2e7220ULL, 0x080fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x0000000928287220ULL, 0x080fe20000410000ULL,
0x0000000929297220ULL, 0x080fe20000410000ULL, 0x000000092a2a7220ULL, 0x080fe20000410000ULL,
0x000000092b2b7220ULL, 0x080fe20000410000ULL, 0x0000000925257220ULL, 0x080fe20000410000ULL,
0x0000000926267220ULL, 0x080fe20000410000ULL, 0x0000000927277220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x0000000923237220ULL, 0x000fe20000410000ULL,
0x0000000120207824ULL, 0x000fc400078e0211ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x080fe20000410000ULL, 0x000000091a247220ULL, 0x080fe20000410000ULL,
0x000000091b217220ULL, 0x000fe20000410000ULL, 0x0000001800008947ULL, 0x002fec0003800000ULL,
0x01c4000020107984ULL, 0x0002a20000000c00ULL, 0x0000000702007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x00000002071a7824ULL, 0x000fe200078e00ffULL,
0x0000000b0f0f7c10ULL, 0x000fc8000fffe1ffULL, 0x000000061a1a7812ULL, 0x000fc800078ec0ffULL,
0x000000011a1c7812ULL, 0x040fe400078efcffULL, 0x000000081a1e7812ULL, 0x000fe400078efcffULL,
0x0000000f1c00720cULL, 0x080fe40003f26070ULL, 0x000000101a1c7812ULL, 0x000fe400078efcffULL,
0x0000000f1e00720cULL, 0x080fe40003f06070ULL, 0x0000000f1c00720cULL, 0x000fc40003fc6070ULL,
0x000000111a1e7812ULL, 0x040fe400078efcffULL, 0x000000181a1c7812ULL, 0x040fe400078efcffULL,
0x0000000f1a00720cULL, 0x080fe40003f46070ULL, 0x0000000f1e00720cULL, 0x080fe40003fa6070ULL,
0x0000000f1c00720cULL, 0x000fe40003f66070ULL, 0x000000091a387812ULL, 0x000fc400078efcffULL,
0x000000191a1e7812ULL, 0x040fe400078efcffULL, 0x000000201a1c7812ULL, 0x000fe400078efcffULL,
0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL, 0xff7fffff39397808ULL, 0x000fc40004800000ULL,
0x0000000f3800720cULL, 0x080fe40003f86070ULL, 0x0000000f1e00720cULL, 0x080fe40003f46070ULL,
0x0000000f1c00720cULL, 0x000fe40003f26070ULL, 0x000000211a1e7812ULL, 0x040fe400078efcffULL,
0x000000281a1c7812ULL, 0x000fe400078efcffULL, 0xff7fffff36367808ULL, 0x000fc40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40004000000ULL, 0xff7fffff37377808ULL, 0x000fe40006000000ULL,
0xff7fffff35357808ULL, 0x000fe40006000000ULL, 0x0000000f1e00720cULL, 0x080fe40003f06070ULL,
0x0000000f1c00720cULL, 0x000fe40003f86070ULL, 0x000000291a1e7812ULL, 0x000fc400078efcffULL,
0x000000301a1c7812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fe40007000000ULL,
0xff7fffff30307808ULL, 0x000fe40007000000ULL, 0xff7fffff33337808ULL, 0x000fe40006800000ULL,
0xff7fffff31317808ULL, 0x000fe40006800000ULL, 0x0000000f1e00720cULL, 0x000fc40003fc6070ULL,
0x0000000f1c00720cULL, 0x000fe40003fa6070ULL, 0x000000311a1e7812ULL, 0x040fe400078efcffULL,
0x000000381a1c7812ULL, 0x040fe400078efcffULL, 0x000000391a1a7812ULL, 0x000fe400078efcffULL,
0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff28287808ULL, 0x000fe40004800000ULL,
0x0000000f1e00720cULL, 0x080fe40003f66070ULL, 0x0000000f1c00720cULL, 0x000fc40003f46070ULL,
0x0000000f1a00720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fc40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40007000000ULL, 0xff7fffff22227808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff23237808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff24247808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fce0004800000ULL, 0x0000001510107209ULL, 0x004fe20007810000ULL,
0xffffffff00087882ULL, 0x000fe20000000000ULL, 0x0000003a111a7209ULL, 0x000fe40007810000ULL,
0x00000039100f7209ULL, 0x000fe40007810000ULL, 0x0000003b1a117209ULL, 0x000fe40007810000ULL,
0x000000340f107209ULL, 0x000fe40007810000ULL, 0x00000036111a7209ULL, 0x000fc40007810000ULL,
0x00000035100f7209ULL, 0x000fe40007810000ULL, 0x000000371a117209ULL, 0x000fe40007810000ULL,
0x000000300f107209ULL, 0x000fe40007810000ULL, 0x00000032111a7209ULL, 0x000fe40007810000ULL,
0x00000031100f7209ULL, 0x000fe40007810000ULL, 0x000000331a117209ULL, 0x000fc40007810000ULL,
0x0000002c0f107209ULL, 0x000fe40007810000ULL, 0x0000002e111a7209ULL, 0x000fe40007810000ULL,
0x0000002d100f7209ULL, 0x000fe40007810000ULL, 0x0000002f1a117209ULL, 0x000fe40007810000ULL,
0x000000280f107209ULL, 0x000fe40007810000ULL, 0x0000002a111a7209ULL, 0x000fc40007810000ULL,
0x00000029100f7209ULL, 0x000fe40007810000ULL, 0x0000002b1a117209ULL, 0x000fe40007810000ULL,
0x000000140f107209ULL, 0x000fe40007810000ULL, 0x00000026111a7209ULL, 0x000fe40007810000ULL,
0x00000025100f7209ULL, 0x000fe40007810000ULL, 0x000000271a117209ULL, 0x000fc40007810000ULL,
0x000000160f107209ULL, 0x000fe40007810000ULL, 0x00000022111a7209ULL, 0x000fe40007810000ULL,
0x00000017100f7209ULL, 0x000fe40007810000ULL, 0x000000231a117209ULL, 0x000fe40007810000ULL,
0x000000ff0cff7812ULL, 0x000fe4000780c0ffULL, 0x000000180f107209ULL, 0x000fc40007810000ULL,
0x00000024111a7209ULL, 0x000fe40007810000ULL, 0x00000001ff0c7807ULL, 0x000fe40000000000ULL,
0x0000001910107209ULL, 0x000fe40007810000ULL, 0x000000211a1a7209ULL, 0x000fe20007810000ULL,
0x00000012087c7947ULL, 0x000fec000b800000ULL, 0x0c401f00100f7f89ULL, 0x000e6800000e0000ULL,
0x0c401f001a117f89ULL, 0x000ea800000e0000ULL, 0x0c401f00121d7f89ULL, 0x000ee800000e0000ULL,
0x0c401f00131e7f89ULL, 0x000f2200000e0000ULL, 0x0000000f101b7209ULL, 0x002fc40007810000ULL,
0x000000111a1c7209ULL, 0x004fc60007810000ULL, 0x0c201f001b3c7f89ULL, 0x000e6200000e0000ULL,
0x0000001d121d7209ULL, 0x008fc60007810000ULL, 0x0c201f001c117f89ULL, 0x000ea200000e0000ULL,
0x0000001e130f7209ULL, 0x010fc60007810000ULL, 0x0c201f001d3e7f89ULL, 0x000ee800000e0000ULL,
0x0c201f000f387f89ULL, 0x00092200000e0000ULL, 0x0000003c1b107209ULL, 0x002fe40007810000ULL,
0x000000111c117209ULL, 0x004fe40007810000ULL, 0x0000003e1d127209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b101a7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b11417820ULL, 0x000fe20000410000ULL,
0x3f80000000087882ULL, 0x000fe40000000000ULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010841ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001081aULL, 0x00000039001c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b25257823ULL, 0x000fe2000001081aULL, 0x0000001700407308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b21217823ULL, 0x000fe20000010841ULL, 0x00000018003f7308ULL, 0x000ff00000000800ULL,
0x0000003400347308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000003600177308ULL, 0x000ff00000000800ULL, 0x0000003700187308ULL, 0x000e700000000800ULL,
0x0000002c00137308ULL, 0x0005e20000000800ULL, 0x000000171817723eULL, 0x002fce00000010ffULL,
0x0000001400397308ULL, 0x0003e20000000800ULL, 0x00000008ff2c7e24ULL, 0x004fca000f8e00ffULL,
0x3f8000002c2c783eULL, 0x000fe400000010ffULL, 0x0000002d003c7308ULL, 0x0004e20000000800ULL,
0x000000151c14723eULL, 0x002fe400000010ffULL, 0x0000003a3b15723eULL, 0x000fca00000010ffULL,
0x00000016003d7308ULL, 0x0002620000000800ULL, 0x000000ffff2d7224ULL, 0x004fe200078e002cULL,
0x000000133c1a723eULL, 0x008fcc00000010ffULL, 0x0000001900467308ULL, 0x000fe20000000800ULL,
0x000000343516723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b24137823ULL, 0x000fe20000010841ULL,
0x0000003d4024723eULL, 0x010fe200000010ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000002c141c723cULL, 0x000fe200000418ffULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000e700000000800ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x000000303118723eULL, 0x002fce00000010ffULL, 0x0000003300197308ULL, 0x000e700000000800ULL,
0x0000002e001b7308ULL, 0x000fe20000000800ULL, 0x000000321919723eULL, 0x002fce00000010ffULL,
0x0000002f00347308ULL, 0x000e700000000800ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000001b341b723eULL, 0x002fce00000010ffULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x0000002c181c723cULL, 0x000fee000004181cULL, 0x00000025003e7308ULL, 0x000ea20000000800ULL,
0x000000282928723eULL, 0x002fce00000010ffULL, 0x0000002a00257308ULL, 0x0005f00000000800ULL,
0x0000002b00367308ULL, 0x000e620000000800ULL, 0x000000393e2a723eULL, 0x004fce00000010ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000253629723eULL, 0x002fce00000010ffULL,
0x0000002700277308ULL, 0x000e700000000800ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x00000026272b723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000003f4626723eULL, 0x000fe200000010ffULL, 0x0000002c281c723cULL, 0x000fec000004181cULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x000000222325723eULL, 0x002fce00000010ffULL,
0x00000021002e7308ULL, 0x000e640000000800ULL, 0x000000132e27723eULL, 0x002fe400000010ffULL,
0xfffffffc07137812ULL, 0x000fcc00078ec0ffULL, 0x0000002c242c723cULL, 0x000fee000004181cULL,
0x0000000fff1c7424ULL, 0x000fca00078e00ffULL, 0x000000131c237219ULL, 0x000fe400000006ffULL,
0x000000380f137209ULL, 0x000fd20007810000ULL, 0x001c1fff2c1c7589ULL, 0x00026200000e0000ULL,
0x0000000000227806ULL, 0x000fe200038e0100ULL, 0x00000000231e73a1ULL, 0x000eb000000e8000ULL,
0x00000000230873c4ULL, 0x000ee20000004000ULL, 0x0000000000097886ULL, 0x000fc400038e0100ULL,
0x0000000923ff7c12ULL, 0x004fda000f80401eULL, 0x0000000e08888947ULL, 0x00afea000b800000ULL,
0x001c1fff2e1d7589ULL, 0x0002a800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x000ee800000e0000ULL,
0x001c1fff001f7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff447812ULL, 0x000fe200078ee244ULL,
0x000008000e237824ULL, 0x002fe200078e0208ULL, 0x00000003422c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff307224ULL, 0x000fe200078e0014ULL, 0x0000000307ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000844217836ULL, 0x000fe20000000000ULL, 0x000000042c2e7812ULL, 0x000fe200078efcffULL,
0x00000008440f7824ULL, 0x000fe200078e00ffULL, 0x000000072c227812ULL, 0x000fe200078e7844ULL,
0x0001200023237836ULL, 0x000fe20000000000ULL, 0x000000072e447812ULL, 0x000fe200078e7844ULL,
0x000000ffff317224ULL, 0x000fe200078e0016ULL, 0x000000072c2c7812ULL, 0x000fe200078e7821ULL,
0x000000ffff327224ULL, 0x000fe200078e0018ULL, 0x000000072e2e7812ULL, 0x000fe200078e7821ULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0x0000000f22227212ULL, 0x080fe200078efcffULL,
0x000000ffff337224ULL, 0x000fe200078e001aULL, 0x0000000f44447212ULL, 0x000fe200078efcffULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x000000212c2c7212ULL, 0x080fe200078efcffULL,
0x0000001022227824ULL, 0x100fe200078e0223ULL, 0x000000212e2e7212ULL, 0x000fe200078efcffULL,
0x0000001044447824ULL, 0x000fc400078e0223ULL, 0x000000ffff347224ULL, 0x000fe200078e0028ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000003022007844ULL, 0x0003e20000000200ULL,
0x000000ffff357224ULL, 0x000fe400078e002aULL, 0x000000ffff367224ULL, 0x000fe400078e0024ULL,
0x000000ffff377224ULL, 0x000fc400078e0026ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000102c2c7824ULL, 0x000fe200078e0223ULL, 0x0000003444007844ULL, 0x0003e20000000200ULL,
0x000000ffff167224ULL, 0x000fe400078e0019ULL, 0x000000ffff177224ULL, 0x000fe400078e001bULL,
0x000000102e2e7824ULL, 0x000fe400078e0223ULL, 0x000000ffff187224ULL, 0x000fe200078e0029ULL,
0x000000142c007844ULL, 0x0003e20000000200ULL, 0x000000ffff197224ULL, 0x000fc400078e002bULL,
0x000000ffff1a7224ULL, 0x000fe400078e0025ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0027ULL,
0x0000000100027824ULL, 0x000fe400078e0202ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x000000182e007844ULL, 0x0003e80000000200ULL, 0x01c0001020008388ULL, 0x0003e80000000c00ULL,
0x01c2001c20008388ULL, 0x01c3e20000000c00ULL, 0x0000000502007c0cULL, 0x000fe2000bf06070ULL,
0x01c6080f0aff79a7ULL, 0x0003d8000850003fULL, 0xffffffc000b88947ULL, 0x022fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff247224ULL, 0x000fce00078e0025ULL,
0x01c65825040075a7ULL, 0x000262000806017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000b95dULL, 0x000fea0003900000ULL, 0x01c658250400b5a7ULL, 0x000e64000806007fULL,
0xfffffffc00ecb947ULL, 0x002fea000383ffffULL, 0xfffffecc00dc7947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x100fe400078e0027ULL, 0x000000ffff217224ULL, 0x000fce00078e0027ULL,
0x01c60821040075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01c608210400a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xfffffed400707947ULL, 0x020fea000383ffffULL,
0x000000ffff207224ULL, 0x100fe400078e0025ULL, 0x000000ffff217224ULL, 0x000fce00078e0025ULL,
0x00000021260075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00000021260085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xfffffed8006c7947ULL, 0x020fea000383ffffULL,
0x000000ffff247224ULL, 0x100fe400078e006bULL, 0x000000ffff257224ULL, 0x000fce00078e006bULL,
0x01c65825040075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01c658250400a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xfffffef800f47947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x108fe400078e0027ULL, 0x000000ffff217224ULL, 0x000fce00078e0027ULL,
0x01c61821040075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01c618210400a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xfffffefc00a47947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x100fe400078e0026ULL, 0x000000ffff217224ULL, 0x000fce00078e0026ULL,
0x01c64821230075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c64821230085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff00008c7947ULL, 0x000fea000383ffffULL,
0x0000000aff227e24ULL, 0x000fe4000f8e00ffULL, 0x0000000aff237e24ULL, 0x000fce000f8e00ffULL,
0x01c65823040075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01c658230400a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff20003c7947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x100fe400078e0029ULL, 0x000000ffff217224ULL, 0x000fce00078e0029ULL,
0x01c62821040075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01c628210400a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff2400587947ULL, 0x020fea000383ffffULL,
0x000000ffff207224ULL, 0x100fe400078e0025ULL, 0x000000ffff217224ULL, 0x000fce00078e0025ULL,
0x01c64821220075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c64821220095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff2800387947ULL, 0x020fea000383ffffULL,
0x000000ffff627224ULL, 0x100fe400078e006bULL, 0x000000ffff637224ULL, 0x000fce00078e006bULL,
0x01c65863040075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c65863040095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff4400f07947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x102fe400078e005bULL, 0x000000ffff217224ULL, 0x000fce00078e005bULL,
0x01c63821040075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01c638210400a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff4800a87947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x100fe400078e002aULL, 0x000000ffff217224ULL, 0x000fce00078e002aULL,
0x01c64821230075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c64821230095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff4c00807947ULL, 0x000fea000383ffffULL,
0x01c600ff080075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c600ff080085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffb800407947ULL, 0x000fea000383ffffULL,
0x80000000ff0a7424ULL, 0x000fe400078e00ffULL, 0x80000000ff0b7424ULL, 0x002fc800078e00ffULL,
0x01c6000b080075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c6000b080085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e48947ULL, 0x002fea000383ffffULL, 0xffffffb800e07947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x100fe400078e0013ULL, 0x000000ffff117224ULL, 0x000fce00078e0013ULL,
0x01c610110a0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c610110a0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffe400e07947ULL, 0x020fea000383ffffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe400078e0010ULL,
0x00000002ff3d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff467424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fce00078e00ffULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0006e40000000046ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff407224ULL, 0x002fe400078e001aULL,
0x00000002ff3d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff467424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x004fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003d40387389ULL, 0x0002640000000046ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000f101b7209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003d40387389ULL, 0x0002640000000046ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000111a1c7209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e0013ULL, 0x000000ffff1d7224ULL, 0x000fce00078e0038ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003d40387389ULL, 0x0002640000000046ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001d121d7209ULL, 0x000fe20007810000ULL,
0x000000ffff407224ULL, 0x000fe400078e001bULL, 0x00000001ff3d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0002640000000046ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001e130f7209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e001cULL,
0x000000ffff3c7224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0002640000000046ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000003c1b107209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e001dULL,
0x000000ffff117224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0002640000000046ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000111c117209ULL, 0x000fe20007810000ULL, 0x000000ffff407224ULL, 0x000fe400078e000fULL,
0x000000ffff3e7224ULL, 0x000fce00078e0038ULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003d40387389ULL, 0x0002640000000046ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000003e1d127209ULL, 0x000fe20007810000ULL, 0xffffffe800e07947ULL, 0x020fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e1f7389ULL, 0x0006e40000000022ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1d7224ULL, 0x004fe400078e001fULL,
0x000000ffff2e7224ULL, 0x002fe400078e001eULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e1f7389ULL, 0x0006e40000000022ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x004fe400078e001fULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2e1f7389ULL, 0x0006e40000000022ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff000107947ULL, 0x026fea000383ffffULL, 0x018000000c027836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000c00028308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff0cff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000c037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000c00027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0008ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffea802507950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x0000000000000100ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000638ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000680ULL, 0x00000000000006a8ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d28ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d48ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d48ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000d78ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000dc0ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000015780ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016580ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000016590ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016590ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000016590ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000016c78ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016c78ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000dc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000015780ULL, 0x0000000000015780ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000016580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016590ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_90_cubin_len = 93640;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
