/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001f310ULL, 0x000000000001ee90ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000001d840ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x000000000001d9b0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000001d9f0ULL, 0x0000000000000110ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000001db00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001d84000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x00756c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080980828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880809892ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001d84000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808e0828808081ULL, 0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001d9b000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9e082880808e0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809e920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x0001d9f000000000ULL,
0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000f2ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0001ca2000183104ULL, 0x0001cc700001cc60ULL, 0x0001cdf00001cde0ULL,
0x010829040001ce00ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001d0500001dULL, 0x0500001d0500001dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000c001082804ULL, 0x00001680000000f0ULL,
0x0000179000001720ULL, 0x00002e60000017c0ULL, 0x00004e0000002f00ULL, 0x0000647000004e40ULL,
0x00006560000064f0ULL, 0x00007ba000006590ULL, 0x00009ad000007bf0ULL, 0x0000af1000009ae0ULL,
0x0000b0000000af90ULL, 0x0000c5100000b030ULL, 0x0000e5700000c520ULL, 0x0000fa600000e580ULL,
0x0000fb700000faf0ULL, 0x000112800000fba0ULL, 0x00012b80000112a0ULL, 0x000141c000012d30ULL,
0x00014950000141d0ULL, 0x000168d000016710ULL, 0x00016dd000016da0ULL, 0x0001c68000017620ULL,
0x0001c6c00001c6b0ULL, 0x0001c6f00001c6d0ULL, 0x0001c7300001c710ULL, 0x0001cdd00001c740ULL,
0x0001ce400001ce30ULL, 0x0001d4700001ce50ULL, 0x0001d5200001d4d0ULL, 0x0001d5c00001d570ULL,
0x0001d6600001d610ULL, 0x0001d7100001d6b0ULL, 0x0001d7d00001d780ULL, 0x05e039040001d820ULL,
0x000000ff00000170ULL, 0x003f010000010600ULL, 0x0000000f000001a0ULL, 0x003f013000010608ULL,
0x0000000f000001d0ULL, 0x003f013000010610ULL, 0x0000000f00000230ULL, 0x003f012000010648ULL,
0x000000ff00000240ULL, 0x003f010000010658ULL, 0x000000ff000005a0ULL, 0x003f010700010600ULL,
0x0000000000000770ULL, 0x003f010200000004ULL, 0x0000000000000880ULL, 0x003f010100000000ULL,
0x000000ff00000ce0ULL, 0x003f010700010648ULL, 0x000000ff00000d60ULL, 0x003f010100010658ULL,
0x000000ff00000ed0ULL, 0x003f01060001065cULL, 0x000000ff00000f30ULL, 0x003f01060001065cULL,
0x000000ff00000fb0ULL, 0x003f01060001065cULL, 0x000000ff00001430ULL, 0x003f010700010650ULL,
0x000000ff000014a0ULL, 0x003f01060001064cULL, 0x000000ff000014c0ULL, 0x003f01060001060cULL,
0x000000ff000015c0ULL, 0x003f01060001060cULL, 0x000000ff00001a20ULL, 0x003f01060001064cULL,
0x000000ff00001ac0ULL, 0x003f01060001064cULL, 0x000000ff00003a40ULL, 0x003f010100010658ULL,
0x000000ff00003a50ULL, 0x003f01060001065cULL, 0x000000ff00003a90ULL, 0x003f01060001065cULL,
0x000000ff00003b10ULL, 0x003f01060001065cULL, 0x000000ff00003de0ULL, 0x003f010700010648ULL,
0x000000ff00003e50ULL, 0x003f010600010654ULL, 0x000000ff00003ec0ULL, 0x003f010600010654ULL,
0x000000ff00003f60ULL, 0x003f010600010654ULL, 0x000000ff00005db0ULL, 0x003f010100010658ULL,
0x000000ff00005e20ULL, 0x003f010100010610ULL, 0x000000ff00005e70ULL, 0x003f01060001065cULL,
0x000000ff00005eb0ULL, 0x003f01060001065cULL, 0x000000ff00005f30ULL, 0x003f01060001065cULL,
0x000000ff00006280ULL, 0x003f010700010650ULL, 0x000000ff000062f0ULL, 0x003f01060001064cULL,
0x000000ff00006310ULL, 0x003f01060001061cULL, 0x000000ff000063f0ULL, 0x003f01060001061cULL,
0x000000ff00006800ULL, 0x003f01060001064cULL, 0x000000ff000068a0ULL, 0x003f01060001064cULL,
0x000000ff000086b0ULL, 0x003f010100010658ULL, 0x000000ff000086c0ULL, 0x003f01060001065cULL,
0x000000ff00008700ULL, 0x003f01060001065cULL, 0x000000ff00008780ULL, 0x003f01060001065cULL,
0x000000ff00008a00ULL, 0x003f010700010648ULL, 0x000000ff00008a70ULL, 0x003f010600010654ULL,
0x000000ff00008ac0ULL, 0x003f010600010654ULL, 0x000000ff00008b50ULL, 0x003f010600010654ULL,
0x000000ff0000a920ULL, 0x003f010100010658ULL, 0x000000ff0000a990ULL, 0x003f010100010620ULL,
0x000000ff0000a9e0ULL, 0x003f01060001065cULL, 0x000000ff0000aa20ULL, 0x003f01060001065cULL,
0x000000ff0000aaa0ULL, 0x003f01060001065cULL, 0x000000ff0000ad20ULL, 0x003f010700010650ULL,
0x000000ff0000ad90ULL, 0x003f01060001064cULL, 0x000000ff0000adb0ULL, 0x003f01060001062cULL,
0x000000ff0000ae90ULL, 0x003f01060001062cULL, 0x000000ff0000b2a0ULL, 0x003f01060001064cULL,
0x000000ff0000b340ULL, 0x003f01060001064cULL, 0x000000ff0000d150ULL, 0x003f010100010658ULL,
0x000000ff0000d160ULL, 0x003f01060001065cULL, 0x000000ff0000d1a0ULL, 0x003f01060001065cULL,
0x000000ff0000d220ULL, 0x003f01060001065cULL, 0x000000ff0000d4a0ULL, 0x003f010700010648ULL,
0x000000ff0000d510ULL, 0x003f010600010654ULL, 0x000000ff0000d560ULL, 0x003f010600010654ULL,
0x000000ff0000d5f0ULL, 0x003f010600010654ULL, 0x000000ff0000f3c0ULL, 0x003f010100010658ULL,
0x000000ff0000f430ULL, 0x003f010100010630ULL, 0x000000ff0000f480ULL, 0x003f01060001065cULL,
0x000000ff0000f4c0ULL, 0x003f01060001065cULL, 0x000000ff0000f540ULL, 0x003f01060001065cULL,
0x000000ff0000f890ULL, 0x003f010700010650ULL, 0x000000ff0000f900ULL, 0x003f01060001064cULL,
0x000000ff0000f920ULL, 0x003f01060001063cULL, 0x000000ff0000f9e0ULL, 0x003f01060001063cULL,
0x000000ff0000fdf0ULL, 0x003f01060001064cULL, 0x000000ff0000fe90ULL, 0x003f01060001064cULL,
0x000000ff00011c90ULL, 0x003f010100010658ULL, 0x000000ff00011ca0ULL, 0x003f01060001065cULL,
0x000000ff00011ce0ULL, 0x003f01060001065cULL, 0x000000ff00011d60ULL, 0x003f01060001065cULL,
0x000000ff00012010ULL, 0x003f010700010648ULL, 0x000000ff00012080ULL, 0x003f010600010654ULL,
0x000000ff000120d0ULL, 0x003f010600010654ULL, 0x000000ff00012160ULL, 0x003f010600010654ULL,
0x000000ff00013f50ULL, 0x003f010100010658ULL, 0x000000ff00013fb0ULL, 0x003f010100010640ULL,
0x000000ff000187c0ULL, 0x003f010600010604ULL, 0x000000ff00018850ULL, 0x003f010600010604ULL,
0x000000ff00018b80ULL, 0x003f010100010600ULL, 0x000000ff00018b90ULL, 0x003f010600010604ULL,
0x000000ff00018c10ULL, 0x003f010600010604ULL, 0x0000003d0001ba90ULL, 0x003f010600010614ULL,
0x0000003d0001bf60ULL, 0x003f010600010614ULL, 0x0000003d0001d3d0ULL, 0x003f010100010608ULL,
0x00101c0400053803ULL, 0x00018c6000017a80ULL, 0x0001d43000018d30ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000001c4ULL, 0x0000001100000002ULL, 0x0000000000000144ULL,
0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL,
0x0000001100000002ULL, 0x000000000000019aULL, 0x0000001100000002ULL, 0x000000000000011dULL,
0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff157424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e620000002200ULL, 0x0000580000047ab9ULL, 0x000fc60000000800ULL,
0x00000000005b7919ULL, 0x000ea80000002100ULL, 0x00000000003f7919ULL, 0x000ee80000002700ULL,
0x00000000002b7919ULL, 0x000f220000002600ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x104fe200078e025bULL, 0x00000005ff5b7819ULL, 0x000fe2000001165bULL,
0x00001fff08007589ULL, 0x00066600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe20003f04070ULL, 0x00001fff5b5b7589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x000fe20003f24070ULL, 0x000062003f087625ULL, 0x008fe200078e0015ULL,
0x000000010f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01060002ff00b388ULL, 0x0007e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x010608040f008388ULL, 0x0007e2000000ca00ULL, 0xff317217ff0e9424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff0aa424ULL, 0x000fe200078e00ffULL, 0x010610060f008388ULL, 0x0007e2000000ca00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff0ba424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0cb424ULL, 0x000fe200078e00ffULL, 0x0104000e0f009388ULL, 0x0007e20000004800ULL,
0x7fffff80ff0db424ULL, 0x000fc600078e00ffULL, 0x0106480a0f00a388ULL, 0x0007e80000008a00ULL,
0x0106580cff00b388ULL, 0x0007e80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003a000000947ULL, 0x000fea0003800000ULL, 0x0000000000127919ULL, 0x01ce620000000000ULL,
0x000000045b037824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x000000102b027824ULL, 0x000fc400078e00ffULL, 0x00000200ff147424ULL, 0x000fc600078e00ffULL,
0x000000053f047c24ULL, 0x000fe2000f8e0202ULL, 0x0000000312037211ULL, 0x042fe200078fd8ffULL,
0x0000001012027824ULL, 0x000fc600078e00ffULL, 0x0000000703057812ULL, 0x000fe400078ec0ffULL,
0x000001f002137812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x000fe200078e0203ULL,
0x0000001f05067812ULL, 0x000fe400078e7812ULL, 0x00000002030d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000103057810ULL, 0x040fe20007ffe0ffULL, 0x00000020030c7824ULL, 0x040fe200078e0206ULL,
0x00000003030f7810ULL, 0x000fe20007ffe0ffULL, 0x00005c0002027625ULL, 0x000fe200078e0014ULL,
0x000000070d0a7812ULL, 0x000fc400078ec0ffULL, 0x0000000705077812ULL, 0x000fe200078ec0ffULL,
0x0000000104067824ULL, 0x000fe200078e0205ULL, 0x0000001f0a107812ULL, 0x000fe200078e7812ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x000000070f0b7812ULL, 0x000fe400078ec0ffULL,
0x00000013020a7210ULL, 0x000fe20007f1e0ffULL, 0x000000200d107824ULL, 0x000fe200078e0210ULL,
0x0000001f070e7812ULL, 0x100fe200078e7812ULL, 0x0000000104077824ULL, 0x000fe200078e020dULL,
0x0000001f0b127812ULL, 0x000fe200078e7812ULL, 0x000000ffff0b7224ULL, 0x000fc400000e0603ULL,
0x00005c0006027625ULL, 0x000fc800078e0014ULL, 0x00000020050e7824ULL, 0x000fe200078e020eULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x00005c0007047625ULL, 0x000fc800078e0014ULL,
0x00005c0011067625ULL, 0x000fe200078e0014ULL, 0x0000001304047210ULL, 0x000fc60007f3e0ffULL,
0x000000200f127824ULL, 0x000fe200078e0212ULL, 0x0000001306067210ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001010117824ULL, 0x000fe200078e00ffULL, 0x00000000020f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400010e0607ULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006085a7981ULL, 0x01cea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000005ff647e24ULL, 0x008fe2000f8e00ffULL, 0x0000007f5a597810ULL, 0x004fc40007ffe0ffULL,
0x000000ff5a2f7810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff597819ULL, 0x000fe40000011659ULL,
0x00000008ff2f7819ULL, 0x000fca000001162fULL, 0x000173f000008947ULL, 0x000fea0003800000ULL,
0x0000000264587824ULL, 0x000fe200078e00ffULL, 0x000106105b007811ULL, 0x000fe200078e20ffULL,
0x00000003ff057424ULL, 0x002fe400078e00ffULL, 0xffffffffff2e7424ULL, 0x000fe200078e00ffULL,
0x000000595800720cULL, 0x000fda0003f06070ULL, 0x0000640058038a10ULL, 0x000fe20007ffe0ffULL,
0x000000023f028824ULL, 0x000fc800078e00ffULL, 0x0000640002028a24ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040500ff738cULL, 0x0003e20000000000ULL,
0x0000600002028625ULL, 0x000fe200078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006022e8981ULL, 0x0004e2000c1e1900ULL, 0x0000010064057824ULL, 0x042fe200078e00ffULL,
0x0000000164047810ULL, 0x000fe20007ffe0ffULL, 0x000000085b2d7824ULL, 0x000fe200078e00ffULL,
0x00000000002c7919ULL, 0x000e620000000000ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x000000055a067217ULL, 0x000fe20007800000ULL, 0x000000802b2b7824ULL, 0x000fe200078e00ffULL,
0x0000002f0400720cULL, 0x000fe20003f06070ULL, 0x00000100ff127424ULL, 0x000fe200078e00ffULL,
0x0000000000ff7f8cULL, 0x0009e2000c80043fULL, 0x0000000106067824ULL, 0x000fe200078e0a05ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0xff317217ff2a7424ULL, 0x000fe200078e00ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000002006067807ULL, 0x000fe20000000000ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000002d06067217ULL, 0x000fe20007800000ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x000000ffff457224ULL, 0x000fc400078e00ffULL,
0x0000000106067824ULL, 0x000fe200078e0a2dULL, 0x00000004ff047819ULL, 0x002fe2000001162cULL,
0x000000102c117824ULL, 0x000fc600078e00ffULL, 0x0000000204027810ULL, 0x044fe20007ffe0ffULL,
0x000000012d037824ULL, 0x040fe200078e0204ULL, 0x0000000404087810ULL, 0x040fe40007ffe0ffULL,
0x00000006040a7810ULL, 0x000fe20007ffe0ffULL, 0x000000012d077824ULL, 0x000fe200078e0202ULL,
0x0000000703057812ULL, 0x000fe200078ec0ffULL, 0x000000012d097824ULL, 0x040fe200078e0208ULL,
0x000000060200720cULL, 0x000fe20003f46070ULL, 0x000000012d0d7824ULL, 0x000fe200078e020aULL,
0x0000000f05027812ULL, 0x000fc400078e782cULL, 0x000000060400720cULL, 0x080fe40003f66070ULL,
0x0000000707057812ULL, 0x000fe400078ec0ffULL, 0x00000007090b7812ULL, 0x000fe400078ec0ffULL,
0x000000060a00720cULL, 0x080fe20003f06070ULL, 0x00000010030a7824ULL, 0x000fe200078e0202ULL,
0x000000060800720cULL, 0x000fe40003f26070ULL, 0x0000000f05027812ULL, 0x000fc400078e782cULL,
0x0000000f0b067812ULL, 0x000fe400078e782cULL, 0x000000f011117812ULL, 0x000fe200078ec0ffULL,
0x00000010070c7824ULL, 0x000fe200078e0202ULL, 0x000000070d0f7812ULL, 0x000fe200078ec0ffULL,
0x00000010090e7824ULL, 0x000fe200078e0206ULL, 0x0000c0000a0b7811ULL, 0x000fe400078e20ffULL,
0x0000000f0f107812ULL, 0x000fe400078e782cULL, 0x0000c0000e0f7811ULL, 0x000fc600078e20ffULL,
0x000000100d107824ULL, 0x000fe400078e0210ULL, 0x000000042e047c24ULL, 0x008fca000f8e022bULL,
0x0000007f04037812ULL, 0x040fe400078ef803ULL, 0x0000007f04057812ULL, 0x040fe400078ef807ULL,
0x0000007f04067812ULL, 0x040fe200078ef809ULL, 0x00005e0003027625ULL, 0x080fe200078e0012ULL,
0x0000007f04087812ULL, 0x000fe400078ef80dULL, 0x0000c0000c0d7811ULL, 0x000fe200078e20ffULL,
0x00005e0005047625ULL, 0x000fe200078e0012ULL, 0x0000001102027210ULL, 0x000fc60007fbe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0012ULL, 0x0000001104047210ULL, 0x000fc60007f9e0ffULL,
0x00005e0008087625ULL, 0x000fc800078e0012ULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x0000001106067210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000001108087210ULL, 0x000fe40007fde0ffULL, 0x0000c00010117811ULL, 0x000fe200078e20ffULL,
0x000000ffff077224ULL, 0x000fe200028e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0009e2000d901c46ULL, 0x000000ffff097224ULL, 0x000fc600030e0609ULL,
0x00000000040d7faeULL, 0x0009e8000d101c46ULL, 0x00000000060f7faeULL, 0x0009e2000c901c46ULL,
0x0000002f6400720cULL, 0x000fc60003f26070ULL, 0x0000000008117faeULL, 0x0009e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0001323000001947ULL, 0x000fea0003800000ULL, 0x000000045b287824ULL, 0x000fe200078e00ffULL,
0x00007610ff6a7816ULL, 0x000fe2000000006aULL, 0x000000023f007824ULL, 0x010fe200078e00ffULL,
0x00007610ff267816ULL, 0x000fe20000000026ULL, 0x00006400ff277624ULL, 0x000fe200078e00ffULL,
0x0000000228257810ULL, 0x000fe20007ffe0ffULL, 0xff317217ff2a7424ULL, 0x000fc400078e00ffULL,
0x0000640000277624ULL, 0x000fe400078e0227ULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x0000010064037824ULL, 0x000fca00078e00ffULL, 0x0000005a0300720cULL, 0x000fda0003f06070ULL,
0x0001311000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000ffff247224ULL, 0x000fe200078e0058ULL, 0x000076106a237816ULL, 0x000fe20000000023ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x01065c00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000004ff0a7819ULL, 0x000fe2000001162cULL,
0x000000042e067c24ULL, 0x000fe2000f8e022bULL, 0x0000002064037811ULL, 0x000fe200078e40ffULL,
0x00000100ff077424ULL, 0x000fe200078e00ffULL, 0x000000020a217810ULL, 0x000fe20007ffe0ffULL,
0x000000012d227824ULL, 0x040fe200078e020aULL, 0x000000035a027217ULL, 0x000fe20007800000ULL,
0x000000102c117824ULL, 0x000fe200078e00ffULL, 0x0000000164007810ULL, 0x000fe20007ffe0ffULL,
0x000000012d1d7824ULL, 0x000fe200078e0221ULL, 0x0000002006067810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a03ULL, 0x0000007f221f7812ULL, 0x000fc400078ec0ffULL,
0x0000007f1d1a7812ULL, 0x000fe400078ec0ffULL, 0x0000002f0000720cULL, 0x000fe20003f06070ULL,
0x000000011f037824ULL, 0x100fe200078e0206ULL, 0x000000040a1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a047824ULL, 0x000fe200078e0206ULL, 0x0000002002007807ULL, 0x000fe20000000000ULL,
0x00005e0003027625ULL, 0x080fe200078e0007ULL, 0x000000060a1c7810ULL, 0x000fe40007ffe0ffULL,
0x000000f011207812ULL, 0x000fe200078ec0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0007ULL,
0x000000002d007217ULL, 0x000fc40007800000ULL, 0x0000002002087210ULL, 0x080fe20007f3e0ffULL,
0x000000012d1b7824ULL, 0x040fe200078e021eULL, 0x0000002004047210ULL, 0x000fe20007f5e0ffULL,
0x000000012d197824ULL, 0x000fe200078e021cULL, 0x000000071d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001000b7824ULL, 0x000fe200078e0a2dULL, 0x0000007f1b187812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0603ULL, 0x0000007f19177812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x0000000b0a00720cULL, 0x080fe20003f26070ULL,
0x0000000118027824ULL, 0x100fe200078e0206ULL, 0x0000000b2100720cULL, 0x080fe20003f46070ULL,
0x0000000117067824ULL, 0x000fe200078e0206ULL, 0x0000000b1e00720cULL, 0x000fe20003f66070ULL,
0x00005e0002027625ULL, 0x000fe200078e0007ULL, 0x0000000b1c00720cULL, 0x000fc40003f86070ULL,
0x00000007220b7812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0007ULL,
0x000000071b0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000719137812ULL, 0x000fe400078ec0ffULL,
0x0000000f0b0b7812ULL, 0x100fe400078e782cULL, 0x0000000f0d007812ULL, 0x100fe400078e782cULL,
0x0000000f0f5e7812ULL, 0x100fe200078e782cULL, 0x0000001022617824ULL, 0x000fe200078e020bULL,
0x0000000f135c7812ULL, 0x000fe200078e782cULL, 0x000000101d5f7824ULL, 0x000fe200078e0200ULL,
0x0000002002027210ULL, 0x080fe20007fbe0ffULL, 0x000000101b5e7824ULL, 0x000fe200078e025eULL,
0x0000002006067210ULL, 0x000fe20007fde0ffULL, 0x00000010195c7824ULL, 0x000fe200078e025cULL,
0x0000e00061167811ULL, 0x000fe200078e20ffULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x0000e0005f157811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000e0005e147811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008167faeULL, 0x0003e2000c901c46ULL, 0x0000e0005c137811ULL, 0x000fc600078e20ffULL,
0x0000000004157faeULL, 0x0003e8000d101c46ULL, 0x0000000002147faeULL, 0x0003e8000d901c46ULL,
0x0000000006137faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff037984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff057984ULL, 0x000ea20000000800ULL, 0x0000ffff6a007812ULL, 0x000fc400078ec0ffULL,
0x0000ffff26027812ULL, 0x000fe400078ec0ffULL, 0x0000888000077816ULL, 0x000fe400000000ffULL,
0x0000888002127816ULL, 0x000fc600000000ffULL, 0x8000000007007824ULL, 0x000fe400078e00ffULL,
0x8000000012027824ULL, 0x000fc600078e00ffULL, 0x8000000003ff7812ULL, 0x002fe40007824800ULL,
0x8000000005ff7812ULL, 0x004fe20007844802ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000012037824ULL, 0x000fe400078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01060c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007844803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff007819ULL, 0x000fe2000001162cULL, 0x00000001ffb17424ULL, 0x000fe200078e00ffULL,
0x0000007011117812ULL, 0x000fe400078ec0ffULL, 0x0000000c00007812ULL, 0x000fca00078ec0ffULL,
0x0000000111117824ULL, 0x000fca00078e0200ULL, 0x0100000011037984ULL, 0x000e680000000800ULL,
0x0102000011007984ULL, 0x0004e20000000800ULL, 0x0000002a0300720bULL, 0x002fda0003f5d000ULL,
0x0000000000027806ULL, 0x000fc800010e0100ULL, 0x0000ffff02087812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x0000002a0300720bULL, 0x00cfe40003f54000ULL,
0x000000032a0a7209ULL, 0x000fe40007810000ULL, 0x00000002ff057819ULL, 0x000fc6000001162cULL,
0x8000000a2a027221ULL, 0x100fe20000010000ULL, 0x0000000805067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe400078e000aULL, 0x3fb8aa3b02047820ULL, 0x000fe40000410000ULL,
0x0000000000027806ULL, 0x000fe400010e0100ULL, 0x000000ff5b00720cULL, 0x000fe40003f45270ULL,
0x0000ffff02097812ULL, 0x000fe200078e3cffULL, 0x0000000400047308ULL, 0x000e660000000800ULL,
0x0000000908ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ffb17807ULL, 0x000fc60001800000ULL,
0x0104000a1100a388ULL, 0x000fe80000000800ULL, 0x00001f0604067589ULL, 0x002e6400000e0000ULL,
0x8000000a03033221ULL, 0x000fe20000010000ULL, 0x0000000429297220ULL, 0x000fe20000410000ULL,
0x00001f0504057589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b03033820ULL, 0x000fc80000410000ULL,
0x0000000300103308ULL, 0x000ee20000000800ULL, 0x000000063b3b7220ULL, 0x082fe20000410000ULL,
0x000000063a3a7220ULL, 0x080fe20000410000ULL, 0x0000000637377220ULL, 0x080fe20000410000ULL,
0x0000000636367220ULL, 0x080fe20000410000ULL, 0x0000000643437220ULL, 0x080fe20000410000ULL,
0x0000000642427220ULL, 0x080fe20000410000ULL, 0x0000000647477220ULL, 0x080fe20000410000ULL,
0x0000000646467220ULL, 0x080fe20000410000ULL, 0x000000064b4b7220ULL, 0x080fe20000410000ULL,
0x000000064a4a7220ULL, 0x080fe20000410000ULL, 0x000000064f4f7220ULL, 0x080fe20000410000ULL,
0x000000064e4e7220ULL, 0x080fe20000410000ULL, 0x0000000653537220ULL, 0x080fe20000410000ULL,
0x0000000652527220ULL, 0x080fe20000410000ULL, 0x0000000657577220ULL, 0x080fe20000410000ULL,
0x0000000656567220ULL, 0x000fe20000410000ULL, 0x0000000539397220ULL, 0x084fe20000410000ULL,
0x0000000538387220ULL, 0x080fe20000410000ULL, 0x0000000535357220ULL, 0x080fe20000410000ULL,
0x0000000534347220ULL, 0x080fe20000410000ULL, 0x0000000541417220ULL, 0x080fe20000410000ULL,
0x0000000540407220ULL, 0x080fe20000410000ULL, 0x0000000545457220ULL, 0x080fe20000410000ULL,
0x0000000544447220ULL, 0x080fe20000410000ULL, 0x0000000549497220ULL, 0x080fe20000410000ULL,
0x0000000548487220ULL, 0x080fe20000410000ULL, 0x000000054d4d7220ULL, 0x080fe20000410000ULL,
0x000000054c4c7220ULL, 0x080fe20000410000ULL, 0x0000000551517220ULL, 0x080fe20000410000ULL,
0x0000000550507220ULL, 0x080fe20000410000ULL, 0x0000000555557220ULL, 0x080fe20000410000ULL,
0x0000000554547220ULL, 0x000fe20000410000ULL, 0x0000001000003220ULL, 0x008fc80000410000ULL,
0x0000002900297221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff007984ULL, 0x000e620000000800ULL, 0x8000000007037824ULL, 0x000fca00078e00ffULL,
0x8000000000ff7812ULL, 0x002fe20007824803ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000007077824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01064c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007824807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000082c037812ULL, 0x040fe400078ec0ffULL, 0x000000282c027211ULL, 0x040fe400078fe0ffULL,
0x0000000703057812ULL, 0x140fe400078ec82cULL, 0x0000000703007812ULL, 0x000fe400078ef82cULL,
0x0000000205077212ULL, 0x000fe400078e3cffULL, 0x000000252c027211ULL, 0x000fc600078fe0ffULL,
0x00000010005d7824ULL, 0x000fe200078e0207ULL, 0x0000000205057212ULL, 0x000fc800078e3cffULL,
0x0000c0005d0f7811ULL, 0x000fe200078e20ffULL, 0x0000001000037824ULL, 0x040fe200078e0205ULL,
0x0000010000007811ULL, 0x000fc600078e20ffULL, 0x000000000f30783bULL, 0x000e620000004200ULL,
0x0000c000030e7811ULL, 0x000fe200078e20ffULL, 0x0000000107027824ULL, 0x100fe400078e0200ULL,
0x0000000105607824ULL, 0x000fe400078e0200ULL, 0x000000000e08783bULL, 0x000ea20000004200ULL,
0x0000c000020d7811ULL, 0x000fe400078e20ffULL, 0x0000c000600c7811ULL, 0x000fc600078e20ffULL,
0x000000000d3c783bULL, 0x000ee80000004200ULL, 0x000000000c04783bULL, 0x000f220000004200ULL,
0x0000010030e47824ULL, 0x042fe200078e00ffULL, 0x0000003000be7306ULL, 0x000fe20000009400ULL,
0x0001000030e67824ULL, 0x000fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe20000011430ULL,
0x0000010031de7824ULL, 0x040fe200078e00ffULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x0001000031e27824ULL, 0x000fe200078e00ffULL, 0x00000018ffe67819ULL, 0x000fe200000114e6ULL,
0x0000010032d07824ULL, 0x040fe200078e00ffULL, 0x000000e400c87306ULL, 0x000fe20000209400ULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x0000010033c97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x0001000032ca7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe20000011431ULL, 0x0000010009b47824ULL, 0x044fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe20000011432ULL, 0x000000e400cf7306ULL, 0x000e620000205400ULL,
0x00000018ffd07819ULL, 0x000fe200000114d0ULL, 0x0001000009af7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0001000033c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011409ULL, 0x0000010008ba7824ULL, 0x040fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe20000011433ULL, 0x0000003000bf7306ULL, 0x000ea20000005400ULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0001000008b57824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000001003ceb7824ULL, 0x008fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x000001003dd97824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x0000003000897306ULL, 0x000ee2000000d400ULL,
0x000000cfc800720bULL, 0x002fe20003fbd000ULL, 0x000001003ecf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x000001003fc87824ULL, 0x000fe200078e00ffULL,
0x00000018ffaf7819ULL, 0x000fc400000114afULL, 0x00000018ffa67819ULL, 0x000fe20000011408ULL,
0x000000e600307306ULL, 0x000fe20000209400ULL, 0x000000bfbe00720bULL, 0x004fe40003f7d000ULL,
0x00000018ff997819ULL, 0x000fe4000001140aULL, 0x00000018ff987819ULL, 0x000fe4000001140bULL,
0x00000018ff927819ULL, 0x000fe2000001143cULL, 0x000000e600d57306ULL, 0x000e620000205400ULL,
0x00000018ff7b7819ULL, 0x010fc40000011404ULL, 0x00000018ff767819ULL, 0x000fe40000011405ULL,
0x00000018ff007819ULL, 0x000fe40000011406ULL, 0x0000000189893812ULL, 0x008fe200078efcffULL,
0x000000de00e77306ULL, 0x000fe20000209400ULL, 0x00000018ffd97819ULL, 0x000fe400000114d9ULL,
0x00000018ff937819ULL, 0x000fe4000001143dULL, 0x00000018ff627819ULL, 0x000fc40000011407ULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x000000de00ea7306ULL, 0x000ea20000205400ULL,
0x000000d53000720bULL, 0x002fe20003f5d000ULL, 0x000100003dd57824ULL, 0x000fe200078e00ffULL,
0x000000e400307245ULL, 0x000fe4000020d400ULL, 0x00000018ffc87819ULL, 0x000fe400000114c8ULL,
0x0000000130305812ULL, 0x000fe200078efcffULL, 0x000000db00e57306ULL, 0x000fe20000209400ULL,
0x00000018ffd57819ULL, 0x000fc400000114d5ULL, 0x000000893030723eULL, 0x000fe400000010ffULL,
0x00000018ff687819ULL, 0x000fe4000001143eULL, 0x000000c800897245ULL, 0x000fe2000020d400ULL,
0x000000db00d27306ULL, 0x000e620000205400ULL, 0x000000eae700720bULL, 0x004fe40003fbd000ULL,
0x00000018ff637819ULL, 0x000fca000001143fULL, 0x0000003100e37306ULL, 0x000ff00000009400ULL,
0x0000003100e07306ULL, 0x000ea20000005400ULL, 0x000000d2e500720bULL, 0x002fce0003fdd000ULL,
0x0000003200d77306ULL, 0x000ff00000009400ULL, 0x0000003200d87306ULL, 0x000fe20000005400ULL,
0x000000e0e300720bULL, 0x004fce0003f9d000ULL, 0x000000e200e97306ULL, 0x000ff00000209400ULL,
0x000000e200e87306ULL, 0x000e700000205400ULL, 0x000000cb00d47306ULL, 0x000ff00000209400ULL,
0x000000cb00d37306ULL, 0x000ea20000205400ULL, 0x000000e8e900720bULL, 0x002fce0003f7d000ULL,
0x0000003300d67306ULL, 0x000ff00000009400ULL, 0x0000003300dd7306ULL, 0x000ff00000005400ULL,
0x0000003200857306ULL, 0x0003f0000000d400ULL, 0x0000003100887306ULL, 0x000722000000d400ULL,
0x000000e600327245ULL, 0x002fc8000020d400ULL, 0x0000000132322812ULL, 0x000fe400078efcffULL,
0x000000d8d700720bULL, 0x000fe20003f5d000ULL, 0x000000d000da7306ULL, 0x000fe20000209400ULL,
0x000000de00d77245ULL, 0x000fe2000020d400ULL, 0x000001000a317824ULL, 0x008fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe400000114ebULL, 0x00000001d7d75812ULL, 0x000fe400078efcffULL,
0x000000d3d400720bULL, 0x004fe20003fbd000ULL, 0x000000d000df7306ULL, 0x0002a20000205400ULL,
0x0000000188884812ULL, 0x010fe200078efcffULL, 0x0001000004d47824ULL, 0x000fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000010006d37824ULL, 0x000fe200078e00ffULL,
0x0000000185852812ULL, 0x000fc400078efcffULL, 0x00000018ffd47819ULL, 0x000fe200000114d4ULL,
0x000000c900dc7306ULL, 0x000fe20000209400ULL, 0x000000d000d07245ULL, 0x002fe4000020d400ULL,
0x00000018ffd37819ULL, 0x000fca00000114d3ULL, 0x000000c900e17306ULL, 0x0002e20000205400ULL,
0x000000dfda00720bULL, 0x004fe20003f9d000ULL, 0x0000010004df7824ULL, 0x000fe400078e00ffULL,
0x0001000005da7824ULL, 0x000fc600078e00ffULL, 0x00000018ffdf7819ULL, 0x000fe200000114dfULL,
0x0000000900ab7306ULL, 0x000fe20000009400ULL, 0x000000c900c97245ULL, 0x002fe4000020d400ULL,
0x00000018ffda7819ULL, 0x000fc600000114daULL, 0x00000001d0d04812ULL, 0x000fe400078efcffULL,
0x0000000900ac7306ULL, 0x000ff00000005400ULL, 0x00000009007c7306ULL, 0x0003f0000000d400ULL,
0x000000b000c07306ULL, 0x000fe20000209400ULL, 0x000000db00097245ULL, 0x002fc8000020d400ULL,
0x0000000109096812ULL, 0x000fe400078efcffULL, 0x000000ddd600720bULL, 0x000fe20003fdd000ULL,
0x000000b000c17306ULL, 0x000e620000205400ULL, 0x000000e200d67245ULL, 0x000fe4000020d400ULL,
0x000000cb00dd7245ULL, 0x000fe4000020d400ULL, 0x00000001d6d63812ULL, 0x000fe400078efcffULL,
0x000000e1dc00720bULL, 0x008fe20003f7d000ULL, 0x0000003300847306ULL, 0x0004e2000000d400ULL,
0x00000001dddd5812ULL, 0x000fc400078efcffULL, 0x000000c300cb7245ULL, 0x000fe4000020d400ULL,
0x000000320932723eULL, 0x000fc600000010ffULL, 0x000000ad00b27306ULL, 0x000fe20000209400ULL,
0x000000c1c000720bULL, 0x002fe20003fbd000ULL, 0x000001000b337824ULL, 0x004fe400078e00ffULL,
0x00000001c9c93812ULL, 0x000fc600078efcffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x000000ad00b37306ULL, 0x000e620000205400ULL, 0x0000000184846812ULL, 0x008fce00078efcffULL,
0x000000ca00cc7306ULL, 0x000ff00000209400ULL, 0x000000ca00d17306ULL, 0x0004e20000205400ULL,
0x000000b3b200720bULL, 0x002fe40003fdd000ULL, 0x000000b000b37245ULL, 0x000fc4000020d400ULL,
0x000000ad00b07245ULL, 0x000fe4000020d400ULL, 0x00000001b3b35812ULL, 0x000fe200078efcffULL,
0x000000c300cd7306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x004fca000020d400ULL,
0x00000001b0b06812ULL, 0x000fe400078efcffULL, 0x000000c300ce7306ULL, 0x000e620000205400ULL,
0x000000d1cc00720bULL, 0x008fce0003f9d000ULL, 0x000000b400c27306ULL, 0x000fec0000209400ULL,
0x00000001caca4812ULL, 0x000fe400078efcffULL, 0x000000b400c77306ULL, 0x000ea20000205400ULL,
0x000000cecd00720bULL, 0x002fe40003f7d000ULL, 0x000000cab3ca723eULL, 0x000fca00000010ffULL,
0x000000ba00c57306ULL, 0x000fec0000209400ULL, 0x00000001cbcb3812ULL, 0x000fe400078efcffULL,
0x000000ba00c67306ULL, 0x0002e20000205400ULL, 0x000000c7c200720bULL, 0x004fe40003fbd000ULL,
0x000000acab00720bULL, 0x000fc40003f7d000ULL, 0x000000b400ab7245ULL, 0x000fe4000020d400ULL,
0x000000cbb0cb723eULL, 0x000fe200000010ffULL, 0x000000b500bb7306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x00000001abab5812ULL, 0x000fe400078efcffULL,
0x000000b500c47306ULL, 0x0002a20000205400ULL, 0x000000c6c500720bULL, 0x008fe40003f9d000ULL,
0x000000017c7c3812ULL, 0x000fc800078efcffULL, 0x0000007cabab723eULL, 0x000fe200000010ffULL,
0x000000af00bc7306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x00000001baba4812ULL, 0x000fe400078efcffULL, 0x000000af00bd7306ULL, 0x0002e20000205400ULL,
0x000000c4bb00720bULL, 0x004fce0003fdd000ULL, 0x0000000800b97306ULL, 0x000fe20000009400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x00000001b5b56812ULL, 0x000fe400078efcffULL,
0x0000000800b87306ULL, 0x000e620000005400ULL, 0x000000bdbc00720bULL, 0x008fce0003fbd000ULL,
0x000000a600a97306ULL, 0x000fec0000209400ULL, 0x00000001afaf5812ULL, 0x000fe400078efcffULL,
0x000000a600a87306ULL, 0x0004e20000205400ULL, 0x000000b8b900720bULL, 0x002fce0003f5d000ULL,
0x0000000a00a47306ULL, 0x000fe20000009400ULL, 0x000000a600a67245ULL, 0x004fce000020d400ULL,
0x0000000a00a57306ULL, 0x000e620000005400ULL, 0x000000a8a900720bULL, 0x008fce0003f9d000ULL,
0x00000008007f7306ULL, 0x0004ec000000d400ULL, 0x00000001a6a64812ULL, 0x000fe400078efcffULL,
0x0000000b00a17306ULL, 0x000fe20000009400ULL, 0x00009910b1087816ULL, 0x004fe400000000ffULL,
0x000000a5a400720bULL, 0x002fc40003fdd000ULL, 0x000000ff0800720cULL, 0x000fe20003f25270ULL,
0x000100000b087824ULL, 0x000fe200078e00ffULL, 0x000000a300a47245ULL, 0x000fe2000020d400ULL,
0x0000000b00a27306ULL, 0x000e620000005400ULL, 0x000000017f7f2812ULL, 0x008fe400078efcffULL,
0x00000018ffbf7819ULL, 0x000fe20000011408ULL, 0x0001000007087824ULL, 0x000fe200078e00ffULL,
0x000000b5a6a6723eULL, 0x000fc600000010ffULL, 0x0000003100b67306ULL, 0x000ff00000209400ULL,
0x0000003100b77306ULL, 0x0004e20000205400ULL, 0x000000a2a100720bULL, 0x002fe40003fbd000ULL,
0x0000003100a17245ULL, 0x000fca000020d400ULL, 0x000000a300a77306ULL, 0x000fe20000209400ULL,
0x00000010ff31723eULL, 0x004fc800000010ffULL, 0x0000541031317816ULL, 0x000fc60000000031ULL,
0x000000a300aa7306ULL, 0x000e620000205400ULL, 0x000000b7b600720bULL, 0x008fce0003f7d000ULL,
0x0000000a007a7306ULL, 0x0004ec000000d400ULL, 0x00000001a1a13812ULL, 0x000fe400078efcffULL,
0x0000003300ae7306ULL, 0x000fe20000209400ULL, 0x000100000a0a7824ULL, 0x004fe200078e00ffULL,
0x000000aaa700720bULL, 0x002fc40003f5d000ULL, 0x00000002ffaa7819ULL, 0x000fe4000001162cULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x0000003300b17306ULL, 0x000e620000205400ULL,
0x000000017a7a6812ULL, 0x008fc800078efcffULL, 0x0000007aa17a723eULL, 0x000fe400000010ffULL,
0x00000001a4a42812ULL, 0x000fe200078efcffULL, 0x00000099009e7306ULL, 0x000ff00000209400ULL,
0x0000009900657306ULL, 0x0004e20000205400ULL, 0x000000b1ae00720bULL, 0x002fce0003f9d000ULL,
0x0000000b00797306ULL, 0x000e62000000d400ULL, 0x0000009900997245ULL, 0x004fce000020d400ULL,
0x0000000a000b7306ULL, 0x000fe20000209400ULL, 0x000000659e00720bULL, 0x008fe40003fdd000ULL,
0x000000072c657812ULL, 0x000fc800078ec0ffULL, 0x0000000865657812ULL, 0x000fe200078ef82cULL,
0x0000000a00be7306ULL, 0x000ea20000205400ULL, 0x0000000179795812ULL, 0x002fca00078efcffULL,
0x0000000199996812ULL, 0x000fe400078efcffULL, 0x000000bf00d27306ULL, 0x000ff00000209400ULL,
0x000000bf00db7306ULL, 0x0002e20000205400ULL, 0x000000be0b00720bULL, 0x004fce0003f7d000ULL,
0x0000003c009f7306ULL, 0x000fe20000009400ULL, 0x000000bf00bf7245ULL, 0x002fce000020d400ULL,
0x0000003c00a07306ULL, 0x000e620000005400ULL, 0x000000dbd200720bULL, 0x008fce0003fbd000ULL,
0x0000003c00787306ULL, 0x0004ec000000d400ULL, 0x00000001bfbf5812ULL, 0x000fe400078efcffULL,
0x00000098009d7306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x004fe200078e00ffULL,
0x000000a09f00720bULL, 0x002fc40003f5d000ULL, 0x0000003300a07245ULL, 0x000fe4000020d400ULL,
0x00000018ffdc7819ULL, 0x000fe2000001143cULL, 0x00010000063c7824ULL, 0x000fe200078e00ffULL,
0x00000098009c7306ULL, 0x0002a20000205400ULL, 0x00000001a0a04812ULL, 0x000fc600078efcffULL,
0x00000018ff3c7819ULL, 0x000fc6000001143cULL, 0x0000000178782812ULL, 0x008fe200078efcffULL,
0x00000004008e7306ULL, 0x000fe20000009400ULL, 0x0000009800987245ULL, 0x002fce000020d400ULL,
0x00000004008f7306ULL, 0x000fe20000005400ULL, 0x0000009c9d00720bULL, 0x004fe40003f9d000ULL,
0x0000000a009c7245ULL, 0x000fe4000020d400ULL, 0x00000008aa0a7810ULL, 0x000fe40007ffe0ffULL,
0x000000019c9c3812ULL, 0x000fe200078efcffULL, 0x0000000400717306ULL, 0x0003e6000000d400ULL,
0x0000009c999c723eULL, 0x000fc600000010ffULL, 0x0000000198984812ULL, 0x000fe400078efcffULL,
0x0000000500907306ULL, 0x000fe20000009400ULL, 0x0000010005047824ULL, 0x002fca00078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe40000011404ULL, 0x0000000500917306ULL, 0x000ff00000005400ULL,
0x00000005006f7306ULL, 0x000ff0000000d400ULL, 0x000000d800de7306ULL, 0x000ff00000209400ULL,
0x000000d800e17306ULL, 0x000e700000205400ULL, 0x000000dc00057306ULL, 0x000ff00000209400ULL,
0x000000dc00c07306ULL, 0x0004e20000205400ULL, 0x000000e1de00720bULL, 0x002fce0003f7d000ULL,
0x0000000600877306ULL, 0x000fe20000009400ULL, 0x000000dc00dc7245ULL, 0x004fce000020d400ULL,
0x0000000600867306ULL, 0x000fe20000005400ULL, 0x000000c00500720bULL, 0x008fce0003fbd000ULL,
0x0000000600677306ULL, 0x0003ec000000d400ULL, 0x00000001dcdc5812ULL, 0x000fe400078efcffULL,
0x000000d900b87306ULL, 0x000fe20000209400ULL, 0x00000004ff067819ULL, 0x002fc8000001162cULL,
0x0000000706067812ULL, 0x000fc600078e7865ULL, 0x000000d900b97306ULL, 0x000e640000205400ULL,
0x00000008650b7824ULL, 0x000fca00078e0206ULL, 0x0000a0000b057811ULL, 0x000fe200078e20ffULL,
0x0000003d009a7306ULL, 0x000ff00000009400ULL, 0x0000003d009b7306ULL, 0x000ea20000005400ULL,
0x000000b9b800720bULL, 0x002fce0003f5d000ULL, 0x0000009200977306ULL, 0x000ff00000209400ULL,
0x0000009200967306ULL, 0x000e620000205400ULL, 0x0000009b9a00720bULL, 0x004fe40003fdd000ULL,
0x000000d8009b7245ULL, 0x000fc8000020d400ULL, 0x000000019b9b3812ULL, 0x000fe200078efcffULL,
0x0000009300957306ULL, 0x000fe60000209400ULL, 0x000000789b78723eULL, 0x000fca00000010ffULL,
0x0000009300947306ULL, 0x0004e20000205400ULL, 0x000000969700720bULL, 0x002fe40003f9d000ULL,
0x00001faa31977589ULL, 0x0003ea00000e0000ULL, 0x000000d500ac7306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x004fe4000020d400ULL, 0x0000007fbaaa723eULL, 0x002fca00000010ffULL,
0x000000d500a77306ULL, 0x000e620000205400ULL, 0x000000949500720bULL, 0x008fe40003f7d000ULL,
0x000000d900947245ULL, 0x000fe4000020d400ULL, 0x0000009200957245ULL, 0x000fe4000020d400ULL,
0x0000000194942812ULL, 0x000fe200078efcffULL, 0x0000003e008a7306ULL, 0x000fe20000009400ULL,
0x00001f0a31927589ULL, 0x0005e200000e0000ULL, 0x0000000195954812ULL, 0x000fc800078efcffULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x0000003e008b7306ULL, 0x000ee20000005400ULL,
0x000000a7ac00720bULL, 0x002fe40003fbd000ULL, 0x000000919000720bULL, 0x000fe40003f7d000ULL,
0x00000088d731723eULL, 0x004fe400000010ffULL, 0x000000afa4a7723eULL, 0x000fe200000010ffULL,
0x0000003d00777306ULL, 0x0002b0000000d400ULL, 0x0000000700837306ULL, 0x000fe20000009400ULL,
0x00000100073d7824ULL, 0x002fe200078e00ffULL, 0x0000008b8a00720bULL, 0x008fc40003f5d000ULL,
0x000000d5008a7245ULL, 0x000fe4000020d400ULL, 0x000000016f6f3812ULL, 0x000fe400078efcffULL,
0x0000000700827306ULL, 0x000fe20000005400ULL, 0x0000000177776812ULL, 0x004fe400078efcffULL,
0x000000018a8a5812ULL, 0x000fe400078efcffULL, 0x0000008f8e00720bULL, 0x000fe40003fbd000ULL,
0x000000df008e7245ULL, 0x000fe2000020d400ULL, 0x0000000700667306ULL, 0x0003e2000000d400ULL,
0x000000da00d57245ULL, 0x000fc4000020d400ULL, 0x0000008a9393723eULL, 0x000fca00000010ffULL,
0x0000003f008c7306ULL, 0x000fe20000009400ULL, 0x000000000504783bULL, 0x002e620000000200ULL,
0x0000000171715812ULL, 0x000fcc00078efcffULL, 0x0000003f008d7306ULL, 0x000eb00000005400ULL,
0x000000cf00a57306ULL, 0x000ff00000209400ULL, 0x000000cf00a27306ULL, 0x000ee20000205400ULL,
0x0000008d8c00720bULL, 0x004fc40003fdd000ULL, 0x000000cf008c7245ULL, 0x000fca000020d400ULL,
0x0000003e00757306ULL, 0x000530000000d400ULL, 0x000000df009d7306ULL, 0x000fe20000209400ULL,
0x000000a2a500720bULL, 0x008fe20003f9d000ULL, 0x0000009704049231ULL, 0x082fe200003400ffULL,
0x000100003e3e7824ULL, 0x004fe200078e00ffULL, 0x0000009706069231ULL, 0x000fc400003400ffULL,
0x0000009205059231ULL, 0x080fe400003400ffULL, 0x000000df009a7306ULL, 0x000e620000205400ULL,
0x0000000175752812ULL, 0x010fe200078efcffULL, 0x0000009207079231ULL, 0x000fe200003400ffULL,
0x00000018ff3e7819ULL, 0x000fc6000001143eULL, 0x000000018c8c4812ULL, 0x000fe400078efcffULL,
0x0000003f00747306ULL, 0x0004e2000000d400ULL, 0x000000300454723cULL, 0x040fee0000041854ULL,
0x0000009f00a37306ULL, 0x000fe20000209400ULL, 0x0000009a9d00720bULL, 0x002fe20003f5d000ULL,
0x000100003f3f7824ULL, 0x004fe200078e00ffULL, 0x0000000721307812ULL, 0x000fe200078e7865ULL,
0x000000ca0448723cULL, 0x000fe20000041848ULL, 0x000000bf989d723eULL, 0x000fc400000010ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000009f00a87306ULL, 0x000e620000205400ULL,
0x0000000174746812ULL, 0x008fe200078efcffULL, 0x0000000865097824ULL, 0x000fe400078e0230ULL,
0x000000aa0444723cULL, 0x000fe40000041844ULL, 0x000000018e8e2812ULL, 0x000fe400078efcffULL,
0x000000c800337306ULL, 0x000fe20000209400ULL, 0x000000828300720bULL, 0x000fc40003f5d000ULL,
0x0000009f00827245ULL, 0x000fe2000020d400ULL, 0x000000a60440723cULL, 0x000fe20000041840ULL,
0x0000a00009307811ULL, 0x000fc600078e20ffULL, 0x000000c8009e7306ULL, 0x000ea20000205400ULL,
0x000000a8a300720bULL, 0x002fca0003fdd000ULL, 0x0000000166662812ULL, 0x000fe400078efcffULL,
0x0000007b00807306ULL, 0x000fec0000209400ULL, 0x0000000182826812ULL, 0x000fe400078efcffULL,
0x0000007b00817306ULL, 0x000e620000205400ULL, 0x0000009e3300720bULL, 0x004fc40003f9d000ULL,
0x000000d6dd33723eULL, 0x000fe400000010ffULL, 0x0000006f826f723eULL, 0x000fc600000010ffULL,
0x000000d400967306ULL, 0x000fe40000209400ULL, 0x000000320450723cULL, 0x000fe20000041850ULL,
0x000000003030783bULL, 0x000ea60000000200ULL, 0x0000000189894812ULL, 0x000fe400078efcffULL,
0x000000d4008b7306ULL, 0x0007220000205400ULL, 0x000000818000720bULL, 0x002fe40003fbd000ULL,
0x000000868700720bULL, 0x000fc40003f9d000ULL, 0x00000085d086723eULL, 0x000fe400000010ffULL,
0x00000084c987723eULL, 0x000fe200000010ffULL, 0x00000076007e7306ULL, 0x000fe20000209400ULL,
0x00000018ff847819ULL, 0x000fe4000001143dULL, 0x000000d400d47245ULL, 0x008fe4000020d400ULL,
0x000000748989723eULL, 0x000fe200000010ffULL, 0x00000086044c723cULL, 0x000fe4000004184cULL,
0x00000076007d7306ULL, 0x0002e20000205400ULL, 0x0000008b9600720bULL, 0x010fc40003fdd000ULL,
0x0000000167674812ULL, 0x000fca00078efcffULL, 0x000000d3008f7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fca000020d400ULL, 0x00000001d4d46812ULL, 0x000fe400078efcffULL,
0x000000d300907306ULL, 0x000e620000205400ULL, 0x0000007d7e00720bULL, 0x008fe40003f7d000ULL,
0x0000007b007d7245ULL, 0x000fe2000020d400ULL, 0x0000009231319231ULL, 0x084fe200003400ffULL,
0x00000079a07b723eULL, 0x000fe200000010ffULL, 0x0000009233339231ULL, 0x000fe200003400ffULL,
0x000000017d7d5812ULL, 0x000fe200078efcffULL, 0x000000da008d7306ULL, 0x000fe20000209400ULL,
0x000000779479723eULL, 0x000fe200000010ffULL, 0x0000009730309231ULL, 0x080fe200003400ffULL,
0x000000dc9592723eULL, 0x000fe200000010ffULL, 0x0000007a0434723cULL, 0x000fe20000041834ULL,
0x0000009732329231ULL, 0x000fe200003400ffULL, 0x0000000176763812ULL, 0x000fc400078efcffULL,
0x000000da00887306ULL, 0x000ea20000205400ULL, 0x000000908f00720bULL, 0x002fe40003fbd000ULL,
0x000000d47dd4723eULL, 0x000fe200000010ffULL, 0x0000009c0404723cULL, 0x000fe80000041838ULL,
0x0000003e003d7306ULL, 0x000fe60000209400ULL, 0x000000d3003a7245ULL, 0x000fe2000020d400ULL,
0x000000783054723cULL, 0x000fe20000041854ULL, 0x00000084003b7245ULL, 0x000fc4000020d400ULL,
0x000000013a3a5812ULL, 0x000fe200078efcffULL, 0x0000003e007c7306ULL, 0x0002e20000205400ULL,
0x000000888d00720bULL, 0x004fe40003fdd000ULL, 0x000000758c88723eULL, 0x000fe200000010ffULL,
0x000000923050723cULL, 0x000fe20000041850ULL, 0x000000673a3a723eULL, 0x000fc600000010ffULL,
0x00000000006b7306ULL, 0x000fe20000209400ULL, 0x0000003e003e7245ULL, 0x002fc6000020d400ULL,
0x00000088304c723cULL, 0x040fe4000004184cULL, 0x00000001d5d56812ULL, 0x000fe400078efcffULL,
0x0000000000707306ULL, 0x000e620000205400ULL, 0x0000007c3d00720bULL, 0x008fe40003fbd000ULL,
0x00000018ff3d7819ULL, 0x000fe40000011408ULL, 0x0000006300087245ULL, 0x000fe4000020d400ULL,
0x000000d576d5723eULL, 0x000fe200000010ffULL, 0x0000006800737306ULL, 0x000fec0000209400ULL,
0x000000013e3e5812ULL, 0x000fe200078efcffULL, 0x000000d43040723cULL, 0x000fe20000041840ULL,
0x0000006800727306ULL, 0x000ea20000205400ULL, 0x000000706b00720bULL, 0x002fce0003f9d000ULL,
0x0000008400837306ULL, 0x000ff00000209400ULL, 0x0000008400807306ULL, 0x000e620000205400ULL,
0x000000727300720bULL, 0x004fce0003f7d000ULL, 0x0000003f00387306ULL, 0x000ff00000209400ULL,
0x0000003f00397306ULL, 0x0004e20000205400ULL, 0x000000808300720bULL, 0x002fce0003fdd000ULL,
0x0000006300697306ULL, 0x000fe20000209400ULL, 0x0000003f003f7245ULL, 0x004fca000020d400ULL,
0x000000013b3b6812ULL, 0x000fe400078efcffULL, 0x00000063006c7306ULL, 0x000e620000205400ULL,
0x000000393800720bULL, 0x008fe40003f5d000ULL, 0x0000006800397245ULL, 0x000fe4000020d400ULL,
0x000000663b3b723eULL, 0x000fe400000010ffULL, 0x0000000139393812ULL, 0x000fe200078efcffULL,
0x00000062006d7306ULL, 0x000fe60000209400ULL, 0x0000003e393e723eULL, 0x000fe200000010ffULL,
0x0000003a3034723cULL, 0x000fe20000041834ULL, 0x0000000000397245ULL, 0x000fc4000020d400ULL,
0x000000013f3f2812ULL, 0x000fe200078efcffULL, 0x00000062006e7306ULL, 0x0004e20000205400ULL,
0x0000006c6900720bULL, 0x002fe40003fbd000ULL, 0x0000000139394812ULL, 0x000fca00078efcffULL,
0x0000003c007e7306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x004fca000020d400ULL,
0x0000000108085812ULL, 0x000fe400078efcffULL, 0x0000003c00777306ULL, 0x0002a20000205400ULL,
0x0000006e6d00720bULL, 0x008fe40003fdd000ULL, 0x000000718e6e723eULL, 0x000fe400000010ffULL,
0x0000003f083f723eULL, 0x000fc600000010ffULL, 0x0000003d006b7306ULL, 0x000fe20000209400ULL,
0x0000003c003c7245ULL, 0x002fe2000020d400ULL, 0x0000006e3044723cULL, 0x040fe80000041844ULL,
0x0000000162626812ULL, 0x000fe400078efcffULL, 0x0000003d00707306ULL, 0x0002e20000205400ULL,
0x000000777e00720bULL, 0x004fe20003f7d000ULL, 0x0000003e3048723cULL, 0x000fe20000041848ULL,
0x0000003d003d7245ULL, 0x002fd6000020d400ULL, 0x000000013c3c3812ULL, 0x000fe400078efcffULL,
0x000000706b00720bULL, 0x008fe40003f5d000ULL, 0x0000003c393c723eULL, 0x000fd600000010ffULL,
0x000000013d3d2812ULL, 0x000fc800078efcffULL, 0x0000003d623d723eULL, 0x000fce00000010ffULL,
0x0000003c3030723cULL, 0x000fe20000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01065c00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000004064057811ULL, 0x000fe200078e40ffULL,
0x000000042e087c24ULL, 0x000fe2000f8e022bULL, 0x00000004ff3c7819ULL, 0x000fe2000001162cULL,
0x00000100ff3b7424ULL, 0x000fe200078e00ffULL, 0x000000055a007217ULL, 0x000fc40007800000ULL,
0x0000004008087810ULL, 0x000fc60007ffe0ffULL, 0x0000000100007824ULL, 0x000fe400078e0a05ULL,
0x000000011f047824ULL, 0x100fe400078e0208ULL, 0x000000011a067824ULL, 0x100fe200078e0208ULL,
0x0000002000007807ULL, 0x000fe20000000000ULL, 0x0000000118387824ULL, 0x000fe400078e0208ULL,
0x00005e0004047625ULL, 0x000fe200078e003bULL, 0x000000002d007217ULL, 0x000fc60007800000ULL,
0x00005e0006067625ULL, 0x000fc800078e003bULL, 0x0000000100637824ULL, 0x000fe200078e0a2dULL,
0x00000020063e7210ULL, 0x080fe20007f9e0ffULL, 0x00005e0038387625ULL, 0x000fe200078e003bULL,
0x0000c0005e067811ULL, 0x000fe400078e20ffULL, 0x000000633c00720cULL, 0x000fe20003f46070ULL,
0x00000001173a7824ULL, 0x000fe200078e0208ULL, 0x00000020043c7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200020e0607ULL, 0x0000002038387210ULL, 0x000fe20007fbe0ffULL,
0x00005e003a3a7625ULL, 0x000fe200078e003bULL, 0x000000631e00720cULL, 0x000fc40003f86070ULL,
0x0000c00061087811ULL, 0x000fe200078e20ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e0605ULL,
0x000000632100720cULL, 0x080fe20003f66070ULL, 0x000000ffff397224ULL, 0x000fe200028e0639ULL,
0x000000631c00720cULL, 0x000fe40003fa6070ULL, 0x000000203a3a7210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c087faeULL, 0x0003e2000d101c46ULL,
0x0000c0005f077811ULL, 0x000fe400078e20ffULL, 0x0000c0005c057811ULL, 0x000fe200078e20ffULL,
0x000000ffff3b7224ULL, 0x000fc800030e063bULL, 0x000000003e077faeULL, 0x0003e8000d901c46ULL,
0x0000000038067faeULL, 0x0003e8000e101c46ULL, 0x000000003a057faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff397984ULL, 0x002e620000000800ULL,
0x0000ffff6a007812ULL, 0x000fc800078ec0ffULL, 0x0000888000047816ULL, 0x000fca00000000ffULL,
0x8000000004007824ULL, 0x000fca00078e00ffULL, 0x8000000039ff7812ULL, 0x002fe20007844800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x01065400ff397984ULL, 0x000e620000000800ULL, 0x8000000004007824ULL, 0x000fca00078e00ffULL,
0x8000000039ff7812ULL, 0x002fe20007844800ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000004047824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000387305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000380000735dULL, 0x004fe20003800000ULL,
0x01065400ff397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007844804ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000e0005d047811ULL, 0x000fe400078e20ffULL, 0x0000e00003037811ULL, 0x000fc400078e20ffULL,
0x0000e00002027811ULL, 0x000fe200078e20ffULL, 0x000000000438783bULL, 0x000e620000004200ULL,
0x0000e00060007811ULL, 0x000fc600078e20ffULL, 0x00000000033c783bULL, 0x000ea80000004200ULL,
0x00000000025c783bULL, 0x000ee80000004200ULL, 0x000000000060783bULL, 0x000f220000004200ULL,
0x0000010038c57824ULL, 0x042fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe20000011438ULL,
0x0001000038cf7824ULL, 0x000fe200078e00ffULL, 0x0000003800c17306ULL, 0x000fe20000009400ULL,
0x0000010039db7824ULL, 0x040fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x0001000039e87824ULL, 0x000fe200078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x000001003ea77824ULL, 0x044fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe20000011439ULL,
0x000100003eaa7824ULL, 0x000fe200078e00ffULL, 0x000000c500cc7306ULL, 0x000fe20000209400ULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x000001003ae27824ULL, 0x000fe200078e00ffULL,
0x00000018ffe87819ULL, 0x000fe200000114e8ULL, 0x000100003bc97824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe2000001143eULL, 0x000001003cc87824ULL, 0x000fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x000000c500ef7306ULL, 0x000e620000205400ULL,
0x00000018ff857819ULL, 0x008fe2000001145eULL, 0x000001003fa87824ULL, 0x000fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x000100003dd67824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe2000001143fULL, 0x000100005cea7824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe2000001143aULL, 0x0000003800c07306ULL, 0x000ea20000005400ULL,
0x00000018ff7f7819ULL, 0x000fc4000001145fULL, 0x00000018ffc87819ULL, 0x000fe400000114c8ULL,
0x00000018ffbb7819ULL, 0x000fe4000001143bULL, 0x00000018ffae7819ULL, 0x000fe2000001143cULL,
0x000000cd00667306ULL, 0x000fe20000209400ULL, 0x000000efcc00720bULL, 0x002fe40003f5d000ULL,
0x000000071ccc7812ULL, 0x000fe400078e7865ULL, 0x00000018ffd67819ULL, 0x000fc400000114d6ULL,
0x00000018ff9b7819ULL, 0x000fe2000001143dULL, 0x000000cd00c37306ULL, 0x000e620000205400ULL,
0x000000c0c100720bULL, 0x004fe20003f9d000ULL, 0x000100003fc17824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ffaa7819ULL, 0x000fe400000114aaULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000000cf00c67306ULL, 0x000fe20000209400ULL,
0x00000018ffc17819ULL, 0x000fc400000114c1ULL, 0x00000018ffa27819ULL, 0x000fe4000001145cULL,
0x00000018ff8d7819ULL, 0x000fe4000001145dULL, 0x00000018ff757819ULL, 0x010fe20000011460ULL,
0x000000cf00e97306ULL, 0x000ea20000205400ULL, 0x000000c36600720bULL, 0x002fe40003fbd000ULL,
0x000000c500c37245ULL, 0x000fe4000020d400ULL, 0x00000018ff6e7819ULL, 0x000fc40000011461ULL,
0x00000001c3c32812ULL, 0x000fe200078efcffULL, 0x00000038008e7306ULL, 0x0002e2000000d400ULL,
0x00000018ff677819ULL, 0x000fe40000011462ULL, 0x00000018ff687819ULL, 0x000fca0000011463ULL,
0x0000003900c27306ULL, 0x000fe20000009400ULL, 0x000000e9c600720bULL, 0x004fe20003f5d000ULL,
0x000100003a387824ULL, 0x002fe400078e00ffULL, 0x000100005de97824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000003900ed7306ULL, 0x000e620000005400ULL,
0x000000018e8e4812ULL, 0x008fe400078efcffULL, 0x00000018ffe97819ULL, 0x000fe400000114e9ULL,
0x0000008ec38e723eULL, 0x000fc600000010ffULL, 0x000000c700c47306ULL, 0x000ff00000209400ULL,
0x000000c700dd7306ULL, 0x0004e20000205400ULL, 0x000000edc200720bULL, 0x002fce0003f7d000ULL,
0x000000db00ce7306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x004fce000020d400ULL,
0x000000db00eb7306ULL, 0x0002a20000205400ULL, 0x000000ddc400720bULL, 0x008fe20003fdd000ULL,
0x000100005edd7824ULL, 0x000fca00078e00ffULL, 0x00000018ffdd7819ULL, 0x000fe200000114ddULL,
0x00000039008c7306ULL, 0x000722000000d400ULL, 0x000000db00db7245ULL, 0x002fca000020d400ULL,
0x00000001c7c76812ULL, 0x000fe400078efcffULL, 0x0000003e00b77306ULL, 0x000fe20000009400ULL,
0x000001003b397824ULL, 0x008fe200078e00ffULL, 0x000000ebce00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003e00ac7306ULL, 0x000fe20000005400ULL,
0x000000018c8c3812ULL, 0x010fcc00078efcffULL, 0x00000001dbdb4812ULL, 0x000fe200078efcffULL,
0x0000003e00807306ULL, 0x0003f0000000d400ULL, 0x000000e800d07306ULL, 0x000fe20000209400ULL,
0x000000071e3e7812ULL, 0x002fca00078e7865ULL, 0x0000000865667824ULL, 0x040fe400078e023eULL,
0x000000e800d57306ULL, 0x000fe20000205400ULL, 0x000001005c3e7824ULL, 0x000fe400078e00ffULL,
0x0000000865657824ULL, 0x000fe400078e02ccULL, 0x000100005fcc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fe2000001143eULL, 0x000001005e3e7824ULL, 0x000fe200078e00ffULL,
0x0000003a00e57306ULL, 0x000fe40000009400ULL, 0x00000018ffcc7819ULL, 0x000fcc00000114ccULL,
0x0000003a00d27306ULL, 0x000e700000005400ULL, 0x0000003900e47306ULL, 0x000ff00000209400ULL,
0x0000003900e77306ULL, 0x000ea20000205400ULL, 0x000000d2e500720bULL, 0x002fc40003f9d000ULL,
0x000000e800d27245ULL, 0x000fca000020d400ULL, 0x0000005e00937306ULL, 0x000ff00000009400ULL,
0x0000005e00947306ULL, 0x000fe20000005400ULL, 0x000000e7e400720bULL, 0x004fce0003f7d000ULL,
0x0000005e00747306ULL, 0x0003f0000000d400ULL, 0x000000e200e07306ULL, 0x000fe20000209400ULL,
0x000000cf005e7245ULL, 0x002fc8000020d400ULL, 0x000000015e5e2812ULL, 0x000fe400078efcffULL,
0x000000d5d000720bULL, 0x000fe20003f5d000ULL, 0x000000e200e17306ULL, 0x0003e20000205400ULL,
0x0001000060d57824ULL, 0x000fca00078e00ffULL, 0x00000018ffd57819ULL, 0x000fe400000114d5ULL,
0x0000003800e37306ULL, 0x000fe20000209400ULL, 0x000000e200e27245ULL, 0x002fc6000020d400ULL,
0x00000001d2d22812ULL, 0x000fc800078efcffULL, 0x0000003800e67306ULL, 0x000e700000205400ULL,
0x0000003b00b87306ULL, 0x000ff00000009400ULL, 0x0000003b00af7306ULL, 0x000ea20000005400ULL,
0x000000e6e300720bULL, 0x002fce0003fdd000ULL, 0x0000003a00877306ULL, 0x000e70000000d400ULL,
0x0000003f00bd7306ULL, 0x000fe20000009400ULL, 0x000000afb800720bULL, 0x004fe40003f5d000ULL,
0x0000003900af7245ULL, 0x000fc4000020d400ULL, 0x000000bb00b87245ULL, 0x000fe4000020d400ULL,
0x00000001afaf3812ULL, 0x000fe200078efcffULL, 0x0000003f00b07306ULL, 0x000fe20000005400ULL,
0x0000000187874812ULL, 0x002fce00078efcffULL, 0x0000003f007a7306ULL, 0x0003f0000000d400ULL,
0x0000003c00b37306ULL, 0x000fe20000009400ULL, 0x000001005f3f7824ULL, 0x002fce00078e00ffULL,
0x0000003c00ba7306ULL, 0x000e700000005400ULL, 0x0000005f00957306ULL, 0x000ff00000009400ULL,
0x0000005f00967306ULL, 0x000fe20000005400ULL, 0x000000bab300720bULL, 0x002fc40003f9d000ULL,
0x0000003800b37245ULL, 0x000fe4000020d400ULL, 0x0000a00065387811ULL, 0x000fe400078e20ffULL,
0x00000001b3b36812ULL, 0x000fe200078efcffULL, 0x0000005f00737306ULL, 0x0003f0000000d400ULL,
0x000000c900de7306ULL, 0x000fe20000209400ULL, 0x000000cd005f7245ULL, 0x002fe2000020d400ULL,
0x0000010060cd7824ULL, 0x000fc600078e00ffULL, 0x000000015f5f5812ULL, 0x000fe400078efcffULL,
0x000000e1e000720bULL, 0x000fe20003fbd000ULL, 0x000000c900df7306ULL, 0x0002a20000205400ULL,
0x00000018ffe07819ULL, 0x000fe400000114eaULL, 0x00000018ffcd7819ULL, 0x000fe400000114cdULL,
0x0000005e5f5e723eULL, 0x000fe400000010ffULL, 0x000000d2c75f723eULL, 0x000fe200000010ffULL,
0x000000ad00bf7306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fc6000020d400ULL,
0x00000001e2e25812ULL, 0x000fc800078efcffULL, 0x000000ad00be7306ULL, 0x000e620000205400ULL,
0x000000dfde00720bULL, 0x004fce0003f7d000ULL, 0x000000c800ca7306ULL, 0x000fec0000209400ULL,
0x00000001c9c93812ULL, 0x000fe400078efcffULL, 0x000000c800cb7306ULL, 0x000ea20000205400ULL,
0x000000bebf00720bULL, 0x002fce0003fbd000ULL, 0x0000003b00867306ULL, 0x0002f0000000d400ULL,
0x0000003c00847306ULL, 0x000962000000d400ULL, 0x000001003d3b7824ULL, 0x002fe200078e00ffULL,
0x000000cbca00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x000000bb00b57306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x010fe200078e00ffULL,
0x0000000186862812ULL, 0x008fc800078efcffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000000bb00b47306ULL, 0x000e620000205400ULL, 0x0000000184844812ULL, 0x020fe400078efcffULL,
0x000000acb700720bULL, 0x000fe40003f9d000ULL, 0x0000003c00ac7245ULL, 0x000fe4000020d400ULL,
0x00000018ffb77819ULL, 0x000fe2000001143fULL, 0x0000003d00bc7306ULL, 0x000fe20000009400ULL,
0x00000086afaf723eULL, 0x000fce00000010ffULL, 0x0000003d00ab7306ULL, 0x000ea20000005400ULL,
0x000000b4b500720bULL, 0x002fe40003f5d000ULL, 0x000000ad00b47245ULL, 0x000fe4000020d400ULL,
0x00000018ffb57819ULL, 0x000fe4000001143eULL, 0x00000001b4b45812ULL, 0x000fe200078efcffULL,
0x0000003b003a7306ULL, 0x000fe20000209400ULL, 0x000000ae00ad7245ULL, 0x000fe4000020d400ULL,
0x0000000180804812ULL, 0x000fc400078efcffULL, 0x000000b3b4b4723eULL, 0x000fe400000010ffULL,
0x00000001b8b82812ULL, 0x000fe200078efcffULL, 0x0000003b00d37306ULL, 0x000e620000205400ULL,
0x000000abbc00720bULL, 0x004fe40003f7d000ULL, 0x000000c800ab7245ULL, 0x000fc8000020d400ULL,
0x00000001abab6812ULL, 0x000fe200078efcffULL, 0x0000003c00d17306ULL, 0x000ff00000209400ULL,
0x0000003c00dc7306ULL, 0x0004e20000205400ULL, 0x000000d33a00720bULL, 0x002fce0003fbd000ULL,
0x000000ae00b27306ULL, 0x000fe20000209400ULL, 0x0000a000663c7811ULL, 0x004fce00078e20ffULL,
0x000000ae00b97306ULL, 0x000e620000205400ULL, 0x000000dcd100720bULL, 0x008fce0003fdd000ULL,
0x0000003d00837306ULL, 0x000eac000000d400ULL, 0x00000001acac6812ULL, 0x000fe400078efcffULL,
0x000000d600da7306ULL, 0x000fe20000209400ULL, 0x000000b9b200720bULL, 0x002fe40003f5d000ULL,
0x0000003b00b27245ULL, 0x000fc4000020d400ULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x00000002ffb97819ULL, 0x000fe4000001162cULL, 0x000000d6003d7306ULL, 0x0002e20000205400ULL,
0x00000001b2b25812ULL, 0x000fe400078efcffULL, 0x0000000183833812ULL, 0x004fe400078efcffULL,
0x000000b0bd00720bULL, 0x000fe40003f7d000ULL, 0x00000001adad2812ULL, 0x000fe200078efcffULL,
0x0000009b00b17306ULL, 0x000fe20000209400ULL, 0x000000d600d67245ULL, 0x002fc4000020d400ULL,
0x000000acadac723eULL, 0x000fca00000010ffULL, 0x0000009b00b67306ULL, 0x000e620000205400ULL,
0x0000003dda00720bULL, 0x008fe40003fbd000ULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x000000017a7a3812ULL, 0x000fc800078efcffULL, 0x0000009c009d7306ULL, 0x000fec0000209400ULL,
0x00000001d6d65812ULL, 0x000fe400078efcffULL, 0x0000009c009e7306ULL, 0x000ea20000205400ULL,
0x000000b6b100720bULL, 0x002fe40003fdd000ULL, 0x00000010ffb6723eULL, 0x000fc400000010ffULL,
0x0000009b00b17245ULL, 0x000fe4000020d400ULL, 0x00005410b6b67816ULL, 0x000fe200000000b6ULL,
0x000000a700d77306ULL, 0x000fe20000209400ULL, 0x000000a8009b7245ULL, 0x000fc6000020d400ULL,
0x00001fb9b6b97589ULL, 0x000e6400000e0000ULL, 0x00000001b1b16812ULL, 0x000fe400078efcffULL,
0x0000009e9d00720bULL, 0x004fe20003fdd000ULL, 0x000000a700d87306ULL, 0x0004e20000205400ULL,
0x00001f0ab69e7589ULL, 0x000f2200000e0000ULL, 0x0000009c009d7245ULL, 0x000fe4000020d400ULL,
0x000000d6b1ad723eULL, 0x000fc800000010ffULL, 0x000000e000e57306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x004fc6000020d400ULL, 0x000000019d9d6812ULL, 0x000fe400078efcffULL,
0x000000949300720bULL, 0x000fe40003fdd000ULL, 0x000000e000e47306ULL, 0x0005620000205400ULL,
0x000000d8d700720bULL, 0x008fe20003f5d000ULL, 0x000000b93c3c9231ULL, 0x082fe200003400ffULL,
0x000000a200937245ULL, 0x000fe2000020d400ULL, 0x000000b93e3e9231ULL, 0x080fe400003400ffULL,
0x000000b938389231ULL, 0x000fc400003400ffULL, 0x000000aa00a97306ULL, 0x000fe20000209400ULL,
0x000000b93a3a9231ULL, 0x000fe200003400ffULL, 0x000000e000e07245ULL, 0x004fe2000020d400ULL,
0x0000009e3d3d9231ULL, 0x090fe200003400ffULL, 0x0000000174746812ULL, 0x000fe200078efcffULL,
0x0000009e3f3f9231ULL, 0x080fe200003400ffULL, 0x00000001a7a72812ULL, 0x000fe200078efcffULL,
0x0000009e39399231ULL, 0x080fe200003400ffULL, 0x000000aa00c07306ULL, 0x0002a20000205400ULL,
0x0000009e3b3b9231ULL, 0x000fe200003400ffULL, 0x000000e4e500720bULL, 0x020fc40003f3d000ULL,
0x0000005e3c50723cULL, 0x000fe20000041850ULL, 0x00000080a780723eULL, 0x000fc600000010ffULL,
0x000000a800d47306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fe4000020d400ULL,
0x00000084ab5e723eULL, 0x000fe200000010ffULL, 0x000000ac3c40723cULL, 0x000fe20000041840ULL,
0x0000008500847245ULL, 0x000fe4000020d400ULL, 0x00000001e0e01812ULL, 0x000fe200078efcffULL,
0x000000a800d97306ULL, 0x000e620000205400ULL, 0x000000c0a900720bULL, 0x004fe40003f5d000ULL,
0x00000083b25f723eULL, 0x000fca00000010ffULL, 0x000000b500bb7306ULL, 0x000fe40000209400ULL,
0x0000005e3c44723cULL, 0x000fe80000041844ULL, 0x00000001aaaa2812ULL, 0x000fe400078efcffULL,
0x000000b500bc7306ULL, 0x000ea20000205400ULL, 0x000000d9d400720bULL, 0x002fe40003fbd000ULL,
0x000000cd005e7245ULL, 0x000fc4000020d400ULL, 0x000000aa9daa723eULL, 0x000fc600000010ffULL,
0x0000005c008f7306ULL, 0x000fec0000009400ULL, 0x000000019b9b5812ULL, 0x000fe400078efcffULL,
0x0000005c00907306ULL, 0x000e620000005400ULL, 0x000000bcbb00720bULL, 0x004fce0003f3d000ULL,
0x0000005d00917306ULL, 0x000ff00000009400ULL, 0x0000005d00927306ULL, 0x000ea20000005400ULL,
0x000000908f00720bULL, 0x002fe40003f7d000ULL, 0x0000009f00907245ULL, 0x000fc4000020d400ULL,
0x0000008cdb8f723eULL, 0x000fc600000010ffULL, 0x0000008500897306ULL, 0x000fe80000209400ULL,
0x0000008e3c54723cULL, 0x000fe80000041854ULL, 0x0000008500887306ULL, 0x0002e20000205400ULL,
0x000000929100720bULL, 0x004fe40003f5d000ULL, 0x0000008d00927245ULL, 0x000fca000020d400ULL,
0x000000c100c27306ULL, 0x000fe20000209400ULL, 0x000000cc00857245ULL, 0x002fce000020d400ULL,
0x000000c100c57306ULL, 0x0002a20000205400ULL, 0x000000888900720bULL, 0x008fe40003fdd000ULL,
0x000000b700887245ULL, 0x000fca000020d400ULL, 0x0000009f00a07306ULL, 0x000fe20000209400ULL,
0x000000c100c17245ULL, 0x002fca000020d400ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x0000009f00a17306ULL, 0x000e620000205400ULL, 0x000000c5c200720bULL, 0x004fce0003fbd000ULL,
0x000000b700ae7306ULL, 0x000fec0000209400ULL, 0x00000001c1c15812ULL, 0x000fe400078efcffULL,
0x000000b700bd7306ULL, 0x000fe20000205400ULL, 0x000000a1a000720bULL, 0x002fce0003f9d000ULL,
0x0000005c00797306ULL, 0x0002ac000000d400ULL, 0x0000000190904812ULL, 0x000fe400078efcffULL,
0x0000005d00767306ULL, 0x000722000000d400ULL, 0x000001005d5c7824ULL, 0x002fe200078e00ffULL,
0x000000c190ab723eULL, 0x000fc800000010ffULL, 0x00000018ffce7819ULL, 0x000fe2000001145cULL,
0x00000100635c7824ULL, 0x000fe200078e00ffULL, 0x0000008d00a57306ULL, 0x000fe20000209400ULL,
0x0000000179793812ULL, 0x004fe200078efcffULL, 0x00000100625d7824ULL, 0x008fe200078e00ffULL,
0x000000969500720bULL, 0x000fe20003f7d000ULL, 0x000000aa3c30723cULL, 0x000fe20000041830ULL,
0x000000ce00917245ULL, 0x000fe4000020d400ULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000008d00a67306ULL, 0x0002a20000205400ULL, 0x0000000176762812ULL, 0x010fc400078efcffULL,
0x00000018ff897819ULL, 0x000fe4000001145cULL, 0x0000007f005c7245ULL, 0x000fc6000020d400ULL,
0x000000c400c67306ULL, 0x000fe20000209400ULL, 0x000000b5008d7245ULL, 0x002fe4000020d400ULL,
0x0000000173733812ULL, 0x000fe400078efcffULL, 0x000000018d8d1812ULL, 0x000fe400078efcffULL,
0x000000bdae00720bULL, 0x000fe20003f3d000ULL, 0x000000c400cf7306ULL, 0x0002e20000205400ULL,
0x000000a6a500720bULL, 0x004fe40003f5d000ULL, 0x00000087e2ae723eULL, 0x000fc400000010ffULL,
0x000000c9b8b5723eULL, 0x000fc600000010ffULL, 0x000000cd009c7306ULL, 0x000fe20000209400ULL,
0x000000c400c47245ULL, 0x002fe2000020d400ULL, 0x000000ae3c4c723cULL, 0x040fe4000004184cULL,
0x0000000188881812ULL, 0x000fe400078efcffULL, 0x0000000192922812ULL, 0x000fe400078efcffULL,
0x000000cd009f7306ULL, 0x000e620000205400ULL, 0x000000cfc600720bULL, 0x008fe20003fbd000ULL,
0x000000b43c48723cULL, 0x000fec0000041848ULL, 0x000000ce00d07306ULL, 0x000fec0000209400ULL,
0x00000001c4c45812ULL, 0x000fc400078efcffULL, 0x000000ce00e17306ULL, 0x000ea20000205400ULL,
0x0000009f9c00720bULL, 0x002fe40003fdd000ULL, 0x00000079c490723eULL, 0x000fca00000010ffULL,
0x000000dd00b07306ULL, 0x000fec0000209400ULL, 0x000000015e5e6812ULL, 0x000fe400078efcffULL,
0x000000dd00a97306ULL, 0x0002e20000205400ULL, 0x000000e1d000720bULL, 0x004fce0003f9d000ULL,
0x0000006000977306ULL, 0x000fe20000009400ULL, 0x000000dd00dd7245ULL, 0x002fca000020d400ULL,
0x0000000191914812ULL, 0x000fe400078efcffULL, 0x0000006000987306ULL, 0x000fe20000005400ULL,
0x000000a9b000720bULL, 0x008fe40003f3d000ULL, 0x000000769191723eULL, 0x000fca00000010ffULL,
0x00000060006f7306ULL, 0x0003e4000000d400ULL, 0x000000903854723cULL, 0x000fe80000041854ULL,
0x00000001dddd1812ULL, 0x000fe400078efcffULL, 0x00000062008b7306ULL, 0x000fe20000009400ULL,
0x0000010061607824ULL, 0x002fe200078e00ffULL, 0x000000dd8484723eULL, 0x000fc800000010ffULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x00000062008a7306ULL, 0x000e640000005400ULL,
0x00000060005f7245ULL, 0x000fcc000020d400ULL, 0x000000a200a37306ULL, 0x000ff00000209400ULL,
0x000000a200a47306ULL, 0x000ea20000205400ULL, 0x0000008a8b00720bULL, 0x002fce0003f5d000ULL,
0x0000006000957306ULL, 0x000ff00000209400ULL, 0x0000006000967306ULL, 0x000e620000205400ULL,
0x000000a4a300720bULL, 0x004fce0003fbd000ULL, 0x0000007f00827306ULL, 0x000fec0000209400ULL,
0x0000000193935812ULL, 0x000fe400078efcffULL, 0x0000007f00817306ULL, 0x000ea20000205400ULL,
0x000000969500720bULL, 0x002fe40003fdd000ULL, 0x000000989700720bULL, 0x000fc40003fbd000ULL,
0x000000e093e0723eULL, 0x000fc600000010ffULL, 0x000000e900ba7306ULL, 0x000fec0000209400ULL,
0x000000015f5f6812ULL, 0x000fe400078efcffULL, 0x000000e900bf7306ULL, 0x0002e20000205400ULL,
0x000000818200720bULL, 0x004fe40003f3d000ULL, 0x0000007a9b81723eULL, 0x000fc400000010ffULL,
0x000000016f6f5812ULL, 0x000fc600078efcffULL, 0x000000cc00a07306ULL, 0x000fe20000209400ULL,
0x000000e900e97245ULL, 0x002fe2000020d400ULL, 0x000000803c34723cULL, 0x000fe20000041834ULL,
0x0000006f5e5e723eULL, 0x000fc600000010ffULL, 0x000000015c5c1812ULL, 0x000fe400078efcffULL,
0x000000cc00a17306ULL, 0x000e620000205400ULL, 0x000000bfba00720bULL, 0x008fe40003f9d000ULL,
0x00000075003e7245ULL, 0x000fe4000020d400ULL, 0x00000073883d723eULL, 0x000fe400000010ffULL,
0x000000748d3c723eULL, 0x000fe200000010ffULL, 0x000000d500947306ULL, 0x000fec0000209400ULL,
0x00000001e9e94812ULL, 0x000fe200078efcffULL, 0x0000003c384c723cULL, 0x000fe2000004184cULL,
0x000000d5008b7306ULL, 0x0004e20000205400ULL, 0x000000a1a000720bULL, 0x002fc40003f7d000ULL,
0x000000e992e1723eULL, 0x000fc600000010ffULL, 0x0000005d003c7245ULL, 0x000fe4000020d400ULL,
0x0000006100997306ULL, 0x000fe20000009400ULL, 0x000000d500d57245ULL, 0x004fe2000020d400ULL,
0x000000e03850723cULL, 0x000fe80000041850ULL, 0x0000000185853812ULL, 0x000fe400078efcffULL,
0x00000061009a7306ULL, 0x000e620000005400ULL, 0x0000008b9400720bULL, 0x008fc40003fdd000ULL,
0x000000855c85723eULL, 0x000fe400000010ffULL, 0x00000089005c7245ULL, 0x000fc6000020d400ULL,
0x00000075007b7306ULL, 0x000fe40000209400ULL, 0x000000843848723cULL, 0x000fe80000041848ULL,
0x00000001d5d56812ULL, 0x000fe400078efcffULL, 0x00000075007c7306ULL, 0x000ea20000205400ULL,
0x0000009a9900720bULL, 0x002fce0003f9d000ULL, 0x00000061006c7306ULL, 0x0002f0000000d400ULL,
0x00000063007e7306ULL, 0x000fe20000009400ULL, 0x0001000061617824ULL, 0x002fe200078e00ffULL,
0x0000007c7b00720bULL, 0x004fc80003f3d000ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x00000063007d7306ULL, 0x000e620000005400ULL, 0x000000016c6c4812ULL, 0x008fe400078efcffULL,
0x00000061003f7245ULL, 0x000fe4000020d400ULL, 0x0000006c5f5f723eULL, 0x000fe400000010ffULL,
0x000000013e3e1812ULL, 0x000fe200078efcffULL, 0x0000006e00787306ULL, 0x000fe60000209400ULL,
0x000000d53e3e723eULL, 0x000fe200000010ffULL, 0x0000005e3844723cULL, 0x000fe80000041844ULL,
0x0000006e00777306ULL, 0x0004e20000205400ULL, 0x0000007d7e00720bULL, 0x002fce0003f7d000ULL,
0x0000006700717306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x004fce000020d400ULL,
0x0000006700727306ULL, 0x0002a20000205400ULL, 0x000000777800720bULL, 0x008fce0003fbd000ULL,
0x0000006100877306ULL, 0x000fe20000209400ULL, 0x0000006700677245ULL, 0x002fca000020d400ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x0000006100867306ULL, 0x000e620000205400ULL,
0x000000727100720bULL, 0x004fce0003fdd000ULL, 0x0000005d00837306ULL, 0x000fec0000209400ULL,
0x0000000167676812ULL, 0x000fe400078efcffULL, 0x0000005d00827306ULL, 0x000ea20000205400ULL,
0x000000868700720bULL, 0x002fce0003f9d000ULL, 0x00000062006b7306ULL, 0x0002ec000000d400ULL,
0x000000013f3f4812ULL, 0x000fe400078efcffULL, 0x0000006300697306ULL, 0x000962000000d400ULL,
0x0001000062627824ULL, 0x002fe200078e00ffULL, 0x000000828300720bULL, 0x004fc40003f3d000ULL,
0x0000003f6e3f723eULL, 0x000fe400000010ffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x00000089007d7306ULL, 0x000fe20000209400ULL, 0x0001000063637824ULL, 0x010fe200078e00ffULL,
0x000000016b6b2812ULL, 0x008fe200078efcffULL, 0x0000003e3840723cULL, 0x000fe60000041840ULL,
0x00000018ff637819ULL, 0x000fc40000011463ULL, 0x00000089007a7306ULL, 0x000e620000205400ULL,
0x000000013c3c1812ULL, 0x000fe400078efcffULL, 0x0000000169693812ULL, 0x020fe400078efcffULL,
0x0000006b3c3c723eULL, 0x000fc600000010ffULL, 0x00000068006d7306ULL, 0x000ff00000209400ULL,
0x0000006800707306ULL, 0x0004e20000205400ULL, 0x0000007a7d00720bULL, 0x002fce0003fbd000ULL,
0x0000006200607306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x004fca000020d400ULL,
0x000000015c5c5812ULL, 0x000fe400078efcffULL, 0x0000006200777306ULL, 0x0002a20000205400ULL,
0x000000706d00720bULL, 0x008fe40003f9d000ULL, 0x000000695c3d723eULL, 0x000fca00000010ffULL,
0x0000006300737306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fe2000020d400ULL,
0x0000003c3834723cULL, 0x000fe80000041834ULL, 0x0000000168684812ULL, 0x000fe400078efcffULL,
0x0000006300727306ULL, 0x0002e20000205400ULL, 0x000000776000720bULL, 0x004fe40003f3d000ULL,
0x0000006300637245ULL, 0x002fd6000020d400ULL, 0x0000000162621812ULL, 0x000fe400078efcffULL,
0x000000727300720bULL, 0x008fe40003f5d000ULL, 0x000000626762723eULL, 0x000fd600000010ffULL,
0x0000000163632812ULL, 0x000fc800078efcffULL, 0x000000636863723eULL, 0x000fce00000010ffULL,
0x000000623838723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004064317811ULL, 0x000fe200078e40ffULL,
0x01061000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff6aff7812ULL, 0x000fe4000782c0ffULL,
0x000000315a00720cULL, 0x000fe40003f44070ULL, 0x00000001ff6a7807ULL, 0x000fd60000800000ULL,
0x0000e1700000a947ULL, 0x000fea0003800000ULL, 0x01065c00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01065c00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000300ff697624ULL, 0x000fe200078e00ffULL,
0x0000000158307812ULL, 0x000fe200078ec0ffULL, 0x000000042e3d7c24ULL, 0x000fe2000f8e022bULL,
0x0000006064317811ULL, 0x000fe200078e40ffULL, 0x00000100ff5e7424ULL, 0x000fe200078e00ffULL,
0x000000013000780cULL, 0x000fe20003f25070ULL, 0xffffffffff2e7424ULL, 0x000fe200078e00ffULL,
0xffffffff69697811ULL, 0x000fc800078e08ffULL, 0x0000000169697807ULL, 0x000fca0004800000ULL,
0x0000000158587824ULL, 0x000fca00078e0269ULL, 0x000000595800720cULL, 0x000fe40003f26070ULL,
0x000000315a307217ULL, 0x000fe40007800000ULL, 0x000000603d3d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000130307824ULL, 0x000fe400078e0a31ULL, 0x000000011f317824ULL, 0x000fc800078e023dULL,
0x0000006927329210ULL, 0x000fe20007ffe024ULL, 0x00000004ff339424ULL, 0x000fe200078e00ffULL,
0x00000020303c7807ULL, 0x000fe20000000000ULL, 0x000000011a3e7824ULL, 0x000fe400078e023dULL,
0x0000600032329625ULL, 0x000fe200078e0033ULL, 0x0000003c2d3c7217ULL, 0x000fc60007800000ULL,
0x00005e0031307625ULL, 0x080fe200078e005eULL, 0x00000006322e9981ULL, 0x000362000c1e1900ULL,
0x00000004ff5c7819ULL, 0x000fe4000001162cULL, 0x00000001183f7824ULL, 0x000fe400078e023dULL,
0x000000013c5d7824ULL, 0x000fe400078e0a2dULL, 0x00005e003e327625ULL, 0x002fe200078e005eULL,
0x00000020303e7210ULL, 0x080fe40007f3e0ffULL, 0x0000005d5c00720cULL, 0x000fe20003f46070ULL,
0x0000000117307824ULL, 0x000fe200078e023dULL, 0x0000002032327210ULL, 0x000fe20007f7e0ffULL,
0x00005e003f3c7625ULL, 0x000fc800078e005eULL, 0x000000ffff3f7224ULL, 0x000fe200008e0631ULL,
0x000000203c3c7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0030307625ULL, 0x000fe200078e005eULL,
0x0000005d2100720cULL, 0x000fc60003f26070ULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x0000005d1e00720cULL, 0x080fe20003f66070ULL, 0x000000ffff3d7224ULL, 0x000fe200020e063dULL,
0x0000005d1c00720cULL, 0x000fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e167faeULL, 0x0003e2000d101c46ULL, 0x0000002030307210ULL, 0x000fca0007fbe0ffULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x0000000032157faeULL, 0x0003e8000c901c46ULL,
0x000000003c147faeULL, 0x0003e8000d901c46ULL, 0x0000000030137faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff317984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01061c00ff327984ULL, 0x000ea20000000800ULL,
0x000000ff23ff7812ULL, 0x000fe2000782c0ffULL, 0x8000000012337824ULL, 0x000fc600078e00ffULL,
0x00000001ff677807ULL, 0x000fca0000800000ULL, 0x8000000067307824ULL, 0x000fca00078e00ffULL,
0x8000000031ff7812ULL, 0x002fe40007824830ULL, 0x8000000032ff7812ULL, 0x004fe20007844833ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fe400078e00ffULL, 0x8000000012327824ULL, 0x000fe400078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01061c00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844832ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0100800011317984ULL, 0x000e620000000800ULL,
0x00000001ff8d7424ULL, 0x000fc600078e00ffULL, 0x0102800011307984ULL, 0x0004e20000000800ULL,
0x0000002a3100720bULL, 0x002fda0003f5d000ULL, 0x0000000000327806ULL, 0x000fc800010e0100ULL,
0x0000ffff323c7812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x0000002a3100720bULL, 0x00cfe40003f54000ULL, 0x000000312a327209ULL, 0x000fe40007810000ULL,
0x00000002ff3e7819ULL, 0x000fc6000001162cULL, 0x800000322a337221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b33337820ULL, 0x000fe40000410000ULL, 0x00000000002a7806ULL, 0x000fe400010e0100ULL,
0x000000015b00780cULL, 0x000fe40003f45270ULL, 0x0000ffff2a3d7812ULL, 0x000fe200078e3cffULL,
0x0000003300337308ULL, 0x000e660000000800ULL, 0x0000003d3cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff8d7807ULL, 0x000fc60001800000ULL, 0x010480321100a388ULL, 0x000fe80000000800ULL,
0x00001f3e332a7589ULL, 0x002e6400000e0000ULL, 0x80000032313c3221ULL, 0x000fe20000010000ULL,
0x0000003329297220ULL, 0x000fe20000410000ULL, 0x00001f0a33317589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b3c3c3820ULL, 0x000fc80000410000ULL, 0x0000003c00103308ULL, 0x000ee20000000800ULL,
0x0000002a54547220ULL, 0x082fe20000410000ULL, 0x0000002a55557220ULL, 0x080fe20000410000ULL,
0x0000002a50507220ULL, 0x080fe20000410000ULL, 0x0000002a51517220ULL, 0x080fe20000410000ULL,
0x0000002a4c4c7220ULL, 0x080fe20000410000ULL, 0x0000002a4d4d7220ULL, 0x080fe20000410000ULL,
0x0000002a48487220ULL, 0x080fe20000410000ULL, 0x0000002a49497220ULL, 0x080fe20000410000ULL,
0x0000002a44447220ULL, 0x080fe20000410000ULL, 0x0000002a45457220ULL, 0x080fe20000410000ULL,
0x0000002a40407220ULL, 0x080fe20000410000ULL, 0x0000002a41417220ULL, 0x080fe20000410000ULL,
0x0000002a34347220ULL, 0x080fe20000410000ULL, 0x0000002a35357220ULL, 0x080fe20000410000ULL,
0x0000002a38387220ULL, 0x080fe20000410000ULL, 0x0000002a39397220ULL, 0x000fe20000410000ULL,
0x0000003156567220ULL, 0x084fe20000410000ULL, 0x0000003157577220ULL, 0x080fe20000410000ULL,
0x0000003152527220ULL, 0x080fe20000410000ULL, 0x0000003153537220ULL, 0x080fe20000410000ULL,
0x000000314e4e7220ULL, 0x080fe20000410000ULL, 0x000000314f4f7220ULL, 0x080fe20000410000ULL,
0x000000314a4a7220ULL, 0x080fe20000410000ULL, 0x000000314b4b7220ULL, 0x080fe20000410000ULL,
0x0000003146467220ULL, 0x080fe20000410000ULL, 0x0000003147477220ULL, 0x080fe20000410000ULL,
0x0000003142427220ULL, 0x080fe20000410000ULL, 0x0000003143437220ULL, 0x080fe20000410000ULL,
0x0000003136367220ULL, 0x080fe20000410000ULL, 0x0000003137377220ULL, 0x080fe20000410000ULL,
0x000000313a3a7220ULL, 0x080fe20000410000ULL, 0x000000313b3b7220ULL, 0x000fe20000410000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0032ULL, 0x0000003010303220ULL, 0x008fc80000410000ULL,
0x0000002930297221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff307984ULL, 0x000e620000000800ULL, 0x8000000067317824ULL, 0x000fca00078e00ffULL,
0x8000000030ff7812ULL, 0x002fe20007824831ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fe400078e00ffULL,
0x8000000067327824ULL, 0x000fe400078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01064c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000000f30783bULL, 0x000e680000004200ULL, 0x000000000d5c783bULL, 0x000fe80000004200ULL,
0x000000000e3c783bULL, 0x000ea80000004200ULL, 0x000000000c60783bULL, 0x000ee20000004200ULL,
0x0000010030e07824ULL, 0x042fe200078e00ffULL, 0x0000003000d07306ULL, 0x000fe20000009400ULL,
0x00000018ffe17819ULL, 0x000fe20000011430ULL, 0x0000010031e77824ULL, 0x040fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe20000011431ULL, 0x0001000030e87824ULL, 0x000fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x0000010032c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x0000003000d17306ULL, 0x000e620000005400ULL,
0x00000018ffe87819ULL, 0x000fe200000114e8ULL, 0x0001000031d37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000001003dbf7824ULL, 0x044fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe2000001145fULL, 0x000100003dcb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011432ULL, 0x000000e000d87306ULL, 0x000fe20000209400ULL,
0x00000018ffa97819ULL, 0x000fe20000011433ULL, 0x000001003ece7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe2000001143cULL, 0x000100003fe27824ULL, 0x040fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x000001003fd27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe2000001143dULL, 0x000000e000d97306ULL, 0x000ea20000205400ULL,
0x000000d1d000720bULL, 0x002fc40003fbd000ULL, 0x00000018ffbf7819ULL, 0x000fe400000114bfULL,
0x00000018ff867819ULL, 0x000fe4000001145eULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x000000e100df7306ULL, 0x000fe20000209400ULL, 0x00000018ff987819ULL, 0x000fe4000001143fULL,
0x00000018ffce7819ULL, 0x000fe400000114ceULL, 0x00000018ffad7819ULL, 0x000fc4000001143eULL,
0x00000018ff927819ULL, 0x000fe2000001145cULL, 0x000000e100dc7306ULL, 0x000e620000205400ULL,
0x000000d9d800720bULL, 0x004fe40003f7d000ULL, 0x00000018ffd87819ULL, 0x000fe200000114e2ULL,
0x000100005de27824ULL, 0x000fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fe400000114d2ULL,
0x00000018ff937819ULL, 0x000fe2000001145dULL, 0x0000003200c27306ULL, 0x000fe20000009400ULL,
0x00000018ffe27819ULL, 0x000fc400000114e2ULL, 0x00000018ff787819ULL, 0x008fe40000011460ULL,
0x00000018ff717819ULL, 0x000fe40000011461ULL, 0x00000018ff687819ULL, 0x000fe20000011462ULL,
0x0000003200dd7306ULL, 0x000ea20000005400ULL, 0x000000dcdf00720bULL, 0x002fe20003f5d000ULL,
0x000100005edf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fc80000011463ULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x0000003000957306ULL, 0x0002f0000000d400ULL,
0x000000e700e37306ULL, 0x000fe20000209400ULL, 0x0000010033307824ULL, 0x002fe200078e00ffULL,
0x000000ddc200720bULL, 0x004fe20003f3d000ULL, 0x000001005edd7824ULL, 0x000fe200078e00ffULL,
0x000000e000c27245ULL, 0x000fe2000020d400ULL, 0x000100005fe07824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fc40000011430ULL, 0x000000e700ea7306ULL, 0x0002a20000205400ULL,
0x0000000195955812ULL, 0x008fe400078efcffULL, 0x00000001c2c23812ULL, 0x000fe400078efcffULL,
0x00000018ffdd7819ULL, 0x000fe400000114ddULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x000000e800de7306ULL, 0x000fe20000209400ULL, 0x000000e700e77245ULL, 0x002fce000020d400ULL,
0x000000e800eb7306ULL, 0x000e620000205400ULL, 0x000000eae300720bULL, 0x004fce0003fbd000ULL,
0x0000003100d67306ULL, 0x000fec0000009400ULL, 0x00000001e7e75812ULL, 0x000fe400078efcffULL,
0x0000003100d57306ULL, 0x000ea20000005400ULL, 0x000000ebde00720bULL, 0x002fe20003f7d000ULL,
0x000001005fde7824ULL, 0x000fc400078e00ffULL, 0x000001005deb7824ULL, 0x000fc600078e00ffULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x000000c300e47306ULL, 0x000ff00000209400ULL,
0x000000c300e57306ULL, 0x0003e20000205400ULL, 0x000000d5d600720bULL, 0x004fce0003fdd000ULL,
0x000000bc00db7306ULL, 0x000fe20000209400ULL, 0x000000c300c37245ULL, 0x002fce000020d400ULL,
0x000000bc00da7306ULL, 0x0002b00000205400ULL, 0x00000031008e7306ULL, 0x000722000000d400ULL,
0x000000bc00bc7245ULL, 0x002fce000020d400ULL, 0x0000003300c17306ULL, 0x000fe20000009400ULL,
0x0001000032317824ULL, 0x008fe200078e00ffULL, 0x000000dadb00720bULL, 0x004fe20003f9d000ULL,
0x000001005cdb7824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003300c47306ULL, 0x000e620000005400ULL, 0x000000018e8e6812ULL, 0x010fe400078efcffULL,
0x00000018ffdb7819ULL, 0x000fc800000114dbULL, 0x00000001bcbc4812ULL, 0x000fe200078efcffULL,
0x0000003000d47306ULL, 0x000ff00000209400ULL, 0x0000003000d77306ULL, 0x000ea20000205400ULL,
0x000000c4c100720bULL, 0x002fc40003fbd000ULL, 0x00000018ffc17819ULL, 0x000fca00000114ebULL,
0x0000005f00917306ULL, 0x000ff00000009400ULL, 0x0000005f00907306ULL, 0x000fe20000005400ULL,
0x000000d7d400720bULL, 0x004fce0003fdd000ULL, 0x0000005f00767306ULL, 0x0003f0000000d400ULL,
0x0000003200887306ULL, 0x0004e2000000d400ULL, 0x000000e1005f7245ULL, 0x002fc8000020d400ULL,
0x000000015f5f2812ULL, 0x000fe400078efcffULL, 0x000000e5e400720bULL, 0x000fe20003f5d000ULL,
0x0000003100c57306ULL, 0x000fe20000209400ULL, 0x0001000033327824ULL, 0x004fe400078e00ffULL,
0x0000010060e47824ULL, 0x000fe400078e00ffULL, 0x0000010061e57824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003100ca7306ULL, 0x000e620000205400ULL,
0x0000000188881812ULL, 0x008fc400078efcffULL, 0x00000018ffe47819ULL, 0x000fe400000114e4ULL,
0x00000001c3c32812ULL, 0x000fe400078efcffULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x000000a300bb7306ULL, 0x000fe20000209400ULL, 0x00000088c388723eULL, 0x000fce00000010ffULL,
0x000000a300b87306ULL, 0x0004e20000205400ULL, 0x000000cac500720bULL, 0x002fce0003f5d000ULL,
0x0000003300877306ULL, 0x000322000000d400ULL, 0x000000a300a37245ULL, 0x004fce000020d400ULL,
0x000000a9009f7306ULL, 0x000fe20000209400ULL, 0x000001003c337824ULL, 0x002fe200078e00ffULL,
0x000000b8bb00720bULL, 0x008fe40003f9d000ULL, 0x0000003000b87245ULL, 0x000fe4000020d400ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x000000a9009a7306ULL, 0x000e620000205400ULL,
0x0000000187875812ULL, 0x010fe400078efcffULL, 0x00000001b8b86812ULL, 0x000fc800078efcffULL,
0x00000001a3a34812ULL, 0x000fe200078efcffULL, 0x0000003d00b77306ULL, 0x000ff00000009400ULL,
0x0000003d00b67306ULL, 0x000ea20000005400ULL, 0x0000009a9f00720bULL, 0x002fc40003fbd000ULL,
0x00000032009a7245ULL, 0x000fca000020d400ULL, 0x0000003200c67306ULL, 0x000ff00000209400ULL,
0x0000003200c77306ULL, 0x000e620000205400ULL, 0x000000b6b700720bULL, 0x004fe40003f3d000ULL,
0x0000003100b67245ULL, 0x000fc4000020d400ULL, 0x000000a900b77245ULL, 0x000fe4000020d400ULL,
0x00000001b6b62812ULL, 0x000fe200078efcffULL, 0x0000003c00b97306ULL, 0x000fe20000009400ULL,
0x00000001b7b75812ULL, 0x000fe400078efcffULL, 0x000000b6a3b6723eULL, 0x000fca00000010ffULL,
0x0000003c00ba7306ULL, 0x000fe20000005400ULL, 0x000000c7c600720bULL, 0x002fce0003fdd000ULL,
0x0000003c00857306ULL, 0x0003ec000000d400ULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000003300bd7306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x002fe200078e00ffULL,
0x0000009ab7b7723eULL, 0x000fc800000010ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003300be7306ULL, 0x000e700000205400ULL, 0x0000003d00827306ULL, 0x000eb0000000d400ULL,
0x000000d300e67306ULL, 0x000fe20000209400ULL, 0x000000bebd00720bULL, 0x002fce0003f5d000ULL,
0x000000d300e97306ULL, 0x0003e20000205400ULL, 0x0000000182821812ULL, 0x004fce00078efcffULL,
0x0000003c00c87306ULL, 0x000fe20000209400ULL, 0x000000d300d37245ULL, 0x002fce000020d400ULL,
0x0000003c003d7306ULL, 0x000e700000205400ULL, 0x0000003e00a17306ULL, 0x000ff00000009400ULL,
0x0000003e00a67306ULL, 0x000ea20000005400ULL, 0x0000003dc800720bULL, 0x002fce0003fbd000ULL,
0x000000b400a07306ULL, 0x000ff00000209400ULL, 0x000000b4009b7306ULL, 0x0002e20000205400ULL,
0x000000a6a100720bULL, 0x004fe40003fdd000ULL, 0x0000003300a67245ULL, 0x000fc4000020d400ULL,
0x0000009800a17245ULL, 0x000fe4000020d400ULL, 0x00000001a6a62812ULL, 0x000fe200078efcffULL,
0x000000bf00c07306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fce000020d400ULL,
0x000000bf00c97306ULL, 0x0002a20000205400ULL, 0x0000009ba000720bULL, 0x008fe40003f5d000ULL,
0x0000003c009b7245ULL, 0x000fe4000020d400ULL, 0x0000a8000b3c7811ULL, 0x000fe400078e20ffULL,
0x000000019b9b5812ULL, 0x000fe200078efcffULL, 0x0000005e009c7306ULL, 0x000fe20000009400ULL,
0x000000bf00bf7245ULL, 0x002fe4000020d400ULL, 0x000000d100a07245ULL, 0x000fc6000020d400ULL,
0x00000001b4b42812ULL, 0x000fe400078efcffULL, 0x0000005e00ab7306ULL, 0x000fe20000005400ULL,
0x000000c9c000720bULL, 0x004fe40003f9d000ULL, 0x0000009bb4b4723eULL, 0x000fca00000010ffULL,
0x0000005e00757306ULL, 0x0003ec000000d400ULL, 0x00000001bfbf4812ULL, 0x000fe400078efcffULL,
0x0000003f00b57306ULL, 0x000fe20000009400ULL, 0x000000e8005e7245ULL, 0x002fc8000020d400ULL,
0x000000015e5e3812ULL, 0x000fe400078efcffULL, 0x000000e9e600720bULL, 0x000fe20003f7d000ULL,
0x0000003f00a27306ULL, 0x000e620000005400ULL, 0x0000005e5f5e723eULL, 0x000fce00000010ffULL,
0x000000cb00cc7306ULL, 0x000fe80000209400ULL, 0x00000001d3d33812ULL, 0x000fe400078efcffULL,
0x000000bab900720bULL, 0x000fe40003f7d000ULL, 0x000000cb00cd7306ULL, 0x000ea20000205400ULL,
0x000000a2b500720bULL, 0x002fe40003fbd000ULL, 0x000000cb00b57245ULL, 0x000fc4000020d400ULL,
0x000000d3bc5f723eULL, 0x000fc600000010ffULL, 0x0000003f007f7306ULL, 0x000e66000000d400ULL,
0x0000000185853812ULL, 0x000fc800078efcffULL, 0x00000085a6a6723eULL, 0x000fe200000010ffULL,
0x000000b2009d7306ULL, 0x000fe20000209400ULL, 0x000000cdcc00720bULL, 0x004fce0003f9d000ULL,
0x000000b200a47306ULL, 0x0004e20000205400ULL, 0x000000017f7f5812ULL, 0x002fca00078efcffULL,
0x00000001b5b54812ULL, 0x000fe400078efcffULL, 0x0000009800af7306ULL, 0x000fe20000209400ULL,
0x000000b200b27245ULL, 0x004fce000020d400ULL, 0x00000098009e7306ULL, 0x000e620000205400ULL,
0x000000a49d00720bULL, 0x008fe40003f7d000ULL, 0x000000ce009d7245ULL, 0x000fca000020d400ULL,
0x000000ce00cf7306ULL, 0x000fec0000209400ULL, 0x00000001b2b23812ULL, 0x000fe400078efcffULL,
0x000000ce00d07306ULL, 0x000ea20000205400ULL, 0x0000009eaf00720bULL, 0x002fe40003fbd000ULL,
0x000000ad009e7245ULL, 0x000fc4000020d400ULL, 0x000000b5b2b5723eULL, 0x000fc600000010ffULL,
0x0000003e00807306ULL, 0x0002ec000000d400ULL, 0x00000001a1a15812ULL, 0x000fe400078efcffULL,
0x0000005c00b07306ULL, 0x000fe20000009400ULL, 0x000100003e3e7824ULL, 0x002fe200078e00ffULL,
0x000000d0cf00720bULL, 0x004fc80003f3d000ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000005c00a77306ULL, 0x000e620000005400ULL, 0x0000000180806812ULL, 0x008fe400078efcffULL,
0x0000003e009f7245ULL, 0x000fc8000020d400ULL, 0x000000019d9d1812ULL, 0x000fe200078efcffULL,
0x000000d800d97306ULL, 0x000ff00000209400ULL, 0x000000d800da7306ULL, 0x0004e20000205400ULL,
0x000000a7b000720bULL, 0x002fce0003f9d000ULL, 0x0000005c007c7306ULL, 0x000322000000d400ULL,
0x000000d800d87245ULL, 0x004fce000020d400ULL, 0x0000009200a87306ULL, 0x000fe20000209400ULL,
0x000100005c5c7824ULL, 0x002fe200078e00ffULL, 0x000000dad900720bULL, 0x008fc80003fdd000ULL,
0x00000018ffe17819ULL, 0x000fe2000001145cULL, 0x00000100635c7824ULL, 0x000fe200078e00ffULL,
0x0000009200997306ULL, 0x0002a20000205400ULL, 0x000000017c7c4812ULL, 0x010fcc00078efcffULL,
0x00000001d8d86812ULL, 0x000fe200078efcffULL, 0x0000003e00d67306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fce000020d400ULL, 0x0000003e003f7306ULL, 0x000e620000205400ULL,
0x00000099a800720bULL, 0x004fce0003fbd000ULL, 0x000000ad00b37306ULL, 0x000fec0000209400ULL,
0x0000000192925812ULL, 0x000fe400078efcffULL, 0x000000ad00aa7306ULL, 0x000ea20000205400ULL,
0x0000003fd600720bULL, 0x002fe40003f7d000ULL, 0x000000003c3c783bULL, 0x000fea0000000200ULL,
0x000000e100e67306ULL, 0x000fec0000209400ULL, 0x000000019f9f3812ULL, 0x000fc400078efcffULL,
0x000000e100e97306ULL, 0x0002e20000205400ULL, 0x000000aab300720bULL, 0x004fce0003f3d000ULL,
0x000000c100c47306ULL, 0x000fe20000209400ULL, 0x000000e100e17245ULL, 0x002fca000020d400ULL,
0x000000019e9e1812ULL, 0x000fe400078efcffULL, 0x000000c100b97306ULL, 0x000e620000205400ULL,
0x000000e9e600720bULL, 0x008fe40003fdd000ULL, 0x000000ab9c00720bULL, 0x000fe40003f3d000ULL,
0x000000c1009c7245ULL, 0x000fe4000020d400ULL, 0x0000009f9e9e723eULL, 0x000fe200000010ffULL,
0x000000db00dc7306ULL, 0x000fe20000209400ULL, 0x000000d8a19f723eULL, 0x000fca00000010ffULL,
0x00000001e1e16812ULL, 0x000fe400078efcffULL, 0x000000db00e37306ULL, 0x0004e20000205400ULL,
0x000000b9c400720bULL, 0x002fe40003f9d000ULL, 0x0000000175751812ULL, 0x000fe400078efcffULL,
0x000000e19292723eULL, 0x000fc600000010ffULL, 0x000000dd00327306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x004fca000020d400ULL, 0x000000019c9c4812ULL, 0x000fe400078efcffULL,
0x000000dd00337306ULL, 0x000e620000205400ULL, 0x000000e3dc00720bULL, 0x008fe40003f7d000ULL,
0x000000909100720bULL, 0x000fe40003f9d000ULL, 0x000000dd00907245ULL, 0x000fc6000020d400ULL,
0x000000d100d27306ULL, 0x000fec0000209400ULL, 0x00000001dbdb3812ULL, 0x000fe400078efcffULL,
0x000000d100d57306ULL, 0x000ea20000205400ULL, 0x000000333200720bULL, 0x002fe40003fbd000ULL,
0x000099108d337816ULL, 0x000fc400000000ffULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x0000007cdb7c723eULL, 0x000fe200000010ffULL, 0x000000e200307306ULL, 0x000fec0000209400ULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x000000e200317306ULL, 0x0002e20000205400ULL,
0x000000d5d200720bULL, 0x004fce0003f5d000ULL, 0x0000009300ac7306ULL, 0x000fe20000209400ULL,
0x000000e200e27245ULL, 0x002fca000020d400ULL, 0x00000001a0a02812ULL, 0x000fe400078efcffULL,
0x0000009300a57306ULL, 0x0002a20000205400ULL, 0x000000313000720bULL, 0x008fe40003fdd000ULL,
0x00000010ff30723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe4000001162cULL,
0x0000541030327816ULL, 0x000fe20000000030ULL, 0x000000de00a47306ULL, 0x000fe20000209400ULL,
0x000000ffff307224ULL, 0x000fe200078e0033ULL, 0x0000009300937245ULL, 0x002fc4000020d400ULL,
0x00001f31328d7589ULL, 0x0002e200000e0000ULL, 0x0000007fa07f723eULL, 0x000fe400000010ffULL,
0x00000001e2e26812ULL, 0x000fe200078efcffULL, 0x000000de00a97306ULL, 0x000f220000205400ULL,
0x000000a5ac00720bULL, 0x004fe20003f7d000ULL, 0x00001f0a32987589ULL, 0x000ea200000e0000ULL,
0x0000008ee731723eULL, 0x002fca00000010ffULL, 0x0000005d00ae7306ULL, 0x000fec0000009400ULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x0000005d00b17306ULL, 0x000e620000005400ULL,
0x000000a9a400720bULL, 0x010fe40003fbd000ULL, 0x000000e29393723eULL, 0x000fca00000010ffULL,
0x00000086008c7306ULL, 0x000ff00000209400ULL, 0x00000086008b7306ULL, 0x0008a20000205400ULL,
0x000000b1ae00720bULL, 0x002fce0003f5d000ULL, 0x00000060008f7306ULL, 0x000fe20000009400ULL,
0x0000008600867245ULL, 0x010fce000020d400ULL, 0x0000006000947306ULL, 0x000e620000005400ULL,
0x0000008b8c00720bULL, 0x004fce0003f3d000ULL, 0x0000005d007b7306ULL, 0x00052c000000d400ULL,
0x0000000186861812ULL, 0x000fe400078efcffULL, 0x000000df00a27306ULL, 0x000fe20000209400ULL,
0x000000948f00720bULL, 0x002fe20003fdd000ULL, 0x00000100625d7824ULL, 0x004fe200078e00ffULL,
0x000000de008f7245ULL, 0x000fc8000020d400ULL, 0x000000018f8f5812ULL, 0x000fe200078efcffULL,
0x000000df00a77306ULL, 0x0002a20000205400ULL, 0x000000017b7b2812ULL, 0x010fe400078efcffULL,
0x000000ff3000720cULL, 0x000fe40003f45270ULL, 0x00000095c230723eULL, 0x000fe400000010ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x000000e400a57306ULL, 0x000fe20000209400ULL,
0x000000df00df7245ULL, 0x002fc4000020d400ULL, 0x000000768f8f723eULL, 0x000fca00000010ffULL,
0x000000e400a87306ULL, 0x0003220000205400ULL, 0x000000a7a200720bULL, 0x004fe20003fbd000ULL,
0x0000008d3c3ca231ULL, 0x088fe200003400ffULL, 0x00000082bfa7723eULL, 0x000fe200000010ffULL,
0x0000008d3e3ea231ULL, 0x000fe400003400ffULL, 0x000000983d3da231ULL, 0x080fe400003400ffULL,
0x00000060006f7306ULL, 0x0004e2000000d400ULL, 0x000000e400e47245ULL, 0x002fe2000020d400ULL,
0x000000983f3fa231ULL, 0x000fc800003400ffULL, 0x00000001dfdf5812ULL, 0x000fe400078efcffULL,
0x00000083008a7306ULL, 0x000fe20000209400ULL, 0x0001000060607824ULL, 0x004fe200078e00ffULL,
0x000000a8a500720bULL, 0x010fe20003f3d000ULL, 0x0000005e3c50723cULL, 0x000fe20000041850ULL,
0x000000df8686723eULL, 0x000fe400000010ffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000008300897306ULL, 0x0002a20000205400ULL, 0x000000016f6f6812ULL, 0x008fc400078efcffULL,
0x00000083005e7245ULL, 0x000fe2000020d400ULL, 0x000000303c54723cULL, 0x040fe60000041854ULL,
0x00000001e4e41812ULL, 0x000fe200078efcffULL, 0x000000e000aa7306ULL, 0x000fe20000209400ULL,
0x00000018ff837819ULL, 0x002fe4000001145cULL, 0x0000a80009307811ULL, 0x000fe200078e20ffULL,
0x000000b63c48723cULL, 0x000fe20000041848ULL, 0x0000006fe4e4723eULL, 0x000fc600000010ffULL,
0x000000e000997306ULL, 0x000e620000205400ULL, 0x000000898a00720bULL, 0x004fe20003f9d000ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x00000087b889723eULL, 0x000fe200000010ffULL,
0x000000a63c44723cULL, 0x000fe20000041844ULL, 0x000000e000877245ULL, 0x000fc6000020d400ULL,
0x000000e500917306ULL, 0x000fe80000209400ULL, 0x000000883c4c723cULL, 0x000fe4000004184cULL,
0x000000015e5e4812ULL, 0x000fe400078efcffULL, 0x000000e500947306ULL, 0x0007220000205400ULL,
0x00000099aa00720bULL, 0x002fc60003fbd000ULL, 0x000000b43c40723cULL, 0x000fe80000041840ULL,
0x00000060008e7306ULL, 0x000fe20000209400ULL, 0x000000e500e57245ULL, 0x008fca000020d400ULL,
0x0000000187875812ULL, 0x000fe400078efcffULL, 0x00000060008b7306ULL, 0x0002e20000205400ULL,
0x000000949100720bULL, 0x010fe40003f3d000ULL, 0x000000875e87723eULL, 0x000fca00000010ffULL,
0x00000063007e7306ULL, 0x000fe20000009400ULL, 0x0000006000607245ULL, 0x002fe2000020d400ULL,
0x0000008d3030a231ULL, 0x084fe400003400ffULL, 0x0000008d3232a231ULL, 0x000fe400003400ffULL,
0x00000001e5e51812ULL, 0x000fe200078efcffULL, 0x000000983131a231ULL, 0x080fe200003400ffULL,
0x00000063007d7306ULL, 0x000e620000005400ULL, 0x0000008b8e00720bULL, 0x008fe20003fdd000ULL,
0x000000983333a231ULL, 0x000fe200003400ffULL, 0x00000075908e723eULL, 0x000fca00000010ffULL,
0x0000006100967306ULL, 0x000fe20000009400ULL, 0x000000923050723cULL, 0x040fea0000041850ULL,
0x0000000160606812ULL, 0x000fe400078efcffULL, 0x0000006100977306ULL, 0x000ea20000005400ULL,
0x0000007d7e00720bULL, 0x002fe20003f9d000ULL, 0x0000008e304c723cULL, 0x000fe2000004184cULL,
0x000000809d7e723eULL, 0x000fc400000010ffULL, 0x0000007b9c7d723eULL, 0x000fc600000010ffULL,
0x0000006200847306ULL, 0x000fe40000009400ULL, 0x0000007e3c34723cULL, 0x040fec0000041834ULL,
0x0000006200817306ULL, 0x000e620000005400ULL, 0x000000979600720bULL, 0x004fe20003f7d000ULL,
0x0000009e3c3c723cULL, 0x000fec0000041838ULL, 0x00000078007a7306ULL, 0x000fe20000209400ULL,
0x0000007800397245ULL, 0x000fe2000020d400ULL, 0x0000007c3054723cULL, 0x000fe20000041854ULL,
0x0000007100387245ULL, 0x000fc4000020d400ULL, 0x0000005d003a7245ULL, 0x000fc6000020d400ULL,
0x0000007800797306ULL, 0x000ea20000205400ULL, 0x000000818400720bULL, 0x002fe20003fbd000ULL,
0x000000863048723cULL, 0x000fec0000041848ULL, 0x0000007100747306ULL, 0x000ff00000209400ULL,
0x0000007100777306ULL, 0x000e620000205400ULL, 0x000000797a00720bULL, 0x004fce0003f3d000ULL,
0x0000006100707306ULL, 0x0004ec000000d400ULL, 0x0000000139391812ULL, 0x000fe400078efcffULL,
0x00000062006b7306ULL, 0x0008e2000000d400ULL, 0x0001000061617824ULL, 0x004fe200078e00ffULL,
0x000000777400720bULL, 0x002fc40003fdd000ULL, 0x000000603960723eULL, 0x000fe400000010ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000005d00827306ULL, 0x000fe20000209400ULL,
0x0001000062627824ULL, 0x010fe200078e00ffULL, 0x0000000170703812ULL, 0x008fe400078efcffULL,
0x0000006800397245ULL, 0x000fe4000020d400ULL, 0x00000018ff627819ULL, 0x000fc40000011462ULL,
0x00000061005f7306ULL, 0x000fe20000209400ULL, 0x0000000138386812ULL, 0x000fe400078efcffULL,
0x000000016b6b5812ULL, 0x000fe400078efcffULL, 0x00000070e5e5723eULL, 0x000fc600000010ffULL,
0x0000006100887306ULL, 0x0002a80000205400ULL, 0x000000e43044723cULL, 0x000fe80000041844ULL,
0x0000005d00817306ULL, 0x000ee20000205400ULL, 0x0000006100617245ULL, 0x002fce000020d400ULL,
0x0000008300807306ULL, 0x000fe20000209400ULL, 0x000000885f00720bULL, 0x004fce0003f7d000ULL,
0x00000083007b7306ULL, 0x000e620000205400ULL, 0x000000818200720bULL, 0x008fca0003f3d000ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x00000063006c7306ULL, 0x0004e4000000d400ULL,
0x000000613861723eULL, 0x000fc800000010ffULL, 0x000000013a3a1812ULL, 0x000fe400078efcffULL,
0x00000062003b7306ULL, 0x000fe20000209400ULL, 0x0001000063637824ULL, 0x004fe200078e00ffULL,
0x0000007b8000720bULL, 0x002fe20003fdd000ULL, 0x000000603040723cULL, 0x000fe20000041840ULL,
0x0000006b3a3a723eULL, 0x000fe400000010ffULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x00000062005c7306ULL, 0x0002a20000205400ULL, 0x000000016c6c4812ULL, 0x008fce00078efcffULL,
0x0000006800727306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fce000020d400ULL,
0x0000006800737306ULL, 0x000e620000205400ULL, 0x0000005c3b00720bULL, 0x004fe40003fbd000ULL,
0x00000083003b7245ULL, 0x000fc8000020d400ULL, 0x000000013b3b6812ULL, 0x000fe200078efcffULL,
0x0000006a006e7306ULL, 0x000fe60000209400ULL, 0x0000006c3b3b723eULL, 0x000fc600000010ffULL,
0x0000000162625812ULL, 0x000fe400078efcffULL, 0x0000006a006d7306ULL, 0x0004e20000205400ULL,
0x000000737200720bULL, 0x002fe20003f7d000ULL, 0x0000003a3034723cULL, 0x000fec0000041834ULL,
0x00000063005f7306ULL, 0x000fe20000209400ULL, 0x0000006a006a7245ULL, 0x004fca000020d400ULL,
0x0000000139393812ULL, 0x000fe400078efcffULL, 0x00000063005e7306ULL, 0x0002a20000205400ULL,
0x0000006d6e00720bULL, 0x008fe40003f3d000ULL, 0x000000623962723eULL, 0x000fe400000010ffULL,
0x0000006300637245ULL, 0x002fd2000020d400ULL, 0x000000016a6a1812ULL, 0x000fe400078efcffULL,
0x0000005e5f00720bULL, 0x004fda0003fdd000ULL, 0x0000000163636812ULL, 0x000fc800078efcffULL,
0x000000636a63723eULL, 0x000fce00000010ffULL, 0x00000062303c723cULL, 0x000fe2000004183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01065c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000008064317811ULL, 0x000fe200078e40ffULL, 0x000000042e687c24ULL, 0x020fe2000f8e022bULL,
0x00000004ff5c7819ULL, 0x000fe2000001162cULL, 0x00000100ff5e7424ULL, 0x000fe200078e00ffULL,
0x000000315a307217ULL, 0x000fc40007800000ULL, 0x0000007f68337812ULL, 0x040fe400078ef81dULL,
0x0000007f68397812ULL, 0x000fe200078ef81bULL, 0x0000000130307824ULL, 0x000fe200078e0a31ULL,
0x0000007f68317812ULL, 0x000fc800078ef822ULL, 0x0000002030327807ULL, 0x000fe20000000000ULL,
0x00005e0031307625ULL, 0x000fc600078e005eULL, 0x000000322d387217ULL, 0x000fe20007800000ULL,
0x00005e0033327625ULL, 0x000fe200078e005eULL, 0x00000020303a7210ULL, 0x080fe40007f3e0ffULL,
0x0000007f68307812ULL, 0x000fe200078ef819ULL, 0x00000001385d7824ULL, 0x000fe200078e0a2dULL,
0x0000002032327210ULL, 0x000fe20007f9e0ffULL, 0x00005e0039387625ULL, 0x000fc600078e005eULL,
0x0000005d2100720cULL, 0x080fe20003f66070ULL, 0x000000ffff3b7224ULL, 0x000fe200008e0631ULL,
0x0000002038387210ULL, 0x000fe20007fbe0ffULL, 0x00005e0030307625ULL, 0x000fe200078e005eULL,
0x0000005d5c00720cULL, 0x000fc60003f26070ULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x0000005d1e00720cULL, 0x080fe20003f86070ULL, 0x000000ffff397224ULL, 0x000fe200028e0639ULL,
0x0000005d1c00720cULL, 0x000fe40003fa6070ULL, 0x0000002030307210ULL, 0x000fca0007fde0ffULL,
0x000000ffff317224ULL, 0x000fe200030e0631ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a087faeULL, 0x0003e8000c901c46ULL, 0x0000000032077faeULL, 0x0003e8000d901c46ULL,
0x0000000038067faeULL, 0x0003e8000e101c46ULL, 0x0000000030057faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff307984ULL, 0x002e620000000800ULL,
0x8000000067317824ULL, 0x000fca00078e00ffULL, 0x8000000030ff7812ULL, 0x002fe20007824831ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fe400078e00ffULL, 0x8000000067327824ULL, 0x000fe400078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01065400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007824832ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000000430783bULL, 0x000e680000004200ULL,
0x00000000025c783bULL, 0x000ea80000004200ULL, 0x000000000338783bULL, 0x000ee80000004200ULL,
0x000000000060783bULL, 0x000f220000004200ULL, 0x0000010030b97824ULL, 0x042fe200078e00ffULL,
0x0000003000aa7306ULL, 0x000fe20000009400ULL, 0x0001000030c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fe20000011430ULL, 0x0000010031ea7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0001000031d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000010032e57824ULL, 0x040fe200078e00ffULL,
0x000000b900ae7306ULL, 0x000fe20000209400ULL, 0x00000018ffea7819ULL, 0x000fe200000114eaULL,
0x0000010033e07824ULL, 0x000fe200078e00ffULL, 0x00000018ffd97819ULL, 0x000fe200000114d9ULL,
0x0001000032df7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe20000011431ULL,
0x000100005de87824ULL, 0x004fe200078e00ffULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x000000b900af7306ULL, 0x0002a20000205400ULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x0001000033db7824ULL, 0x000fe200078e00ffULL, 0x00000018ffdf7819ULL, 0x000fe200000114dfULL,
0x0001000039d47824ULL, 0x008fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe20000011432ULL,
0x000001003aa97824ULL, 0x040fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001145dULL,
0x0000003000ef7306ULL, 0x000ee20000005400ULL, 0x000000b900b97245ULL, 0x002fe2000020d400ULL,
0x000100003ab07824ULL, 0x000fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x000001005ee47824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x010fc40000011460ULL,
0x00000018ffbf7819ULL, 0x000fe20000011433ULL, 0x000000c400b87306ULL, 0x000fe20000209400ULL,
0x000000afae00720bULL, 0x004fe40003fdd000ULL, 0x00000018ffd47819ULL, 0x000fe400000114d4ULL,
0x00000018ffbb7819ULL, 0x000fe40000011438ULL, 0x00000018ff947819ULL, 0x000fe20000011439ULL,
0x000000c400c57306ULL, 0x0002a20000205400ULL, 0x000000efaa00720bULL, 0x008fc40003fbd000ULL,
0x00000018ffa77819ULL, 0x000fe4000001143bULL, 0x00000018ff9f7819ULL, 0x000fe4000001143aULL,
0x00000001b9b96812ULL, 0x000fe200078efcffULL, 0x000000c300ba7306ULL, 0x000fe20000209400ULL,
0x000000c400c47245ULL, 0x002fe4000020d400ULL, 0x00000018ffa47819ULL, 0x000fe4000001145cULL,
0x00000018ffa97819ULL, 0x000fc400000114a9ULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x000000c300eb7306ULL, 0x0002e20000205400ULL, 0x000000c5b800720bULL, 0x004fe40003f3d000ULL,
0x00000018ff877819ULL, 0x000fe4000001145eULL, 0x00000018ff817819ULL, 0x000fe4000001145fULL,
0x00000018ffe87819ULL, 0x000fe200000114e8ULL, 0x0000003000a27306ULL, 0x000522000000d400ULL,
0x000000c300c37245ULL, 0x002fc4000020d400ULL, 0x00000018ff707819ULL, 0x000fe40000011461ULL,
0x00000018ff6a7819ULL, 0x000fe40000011462ULL, 0x00000001c4c41812ULL, 0x000fe200078efcffULL,
0x000000ea00ca7306ULL, 0x000fe20000209400ULL, 0x000000ebba00720bULL, 0x008fe20003fdd000ULL,
0x0000010039307824ULL, 0x004fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011463ULL,
0x000100005ceb7824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000ea00ed7306ULL, 0x000e620000205400ULL, 0x00000001a2a25812ULL, 0x010fca00078efcffULL,
0x00000001c3c36812ULL, 0x000fe400078efcffULL, 0x0000003100ab7306ULL, 0x000ff00000009400ULL,
0x0000003100ac7306ULL, 0x000ea20000005400ULL, 0x000000edca00720bULL, 0x002fe20003fbd000ULL,
0x000001005dca7824ULL, 0x000fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe200000114caULL,
0x000000d900cd7306ULL, 0x000ff00000209400ULL, 0x000000d900d07306ULL, 0x000e620000205400ULL,
0x000000acab00720bULL, 0x004fc40003f7d000ULL, 0x00000018ffac7819ULL, 0x000fca00000114b0ULL,
0x000000c700cb7306ULL, 0x000ff00000209400ULL, 0x000000c700c87306ULL, 0x0004e20000205400ULL,
0x000000d0cd00720bULL, 0x002fe20003f3d000ULL, 0x0001000060d07824ULL, 0x000fc400078e00ffULL,
0x0000010061cd7824ULL, 0x000fc600078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x000000e500d27306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x004fe4000020d400ULL,
0x00000018ffcd7819ULL, 0x000fca00000114cdULL, 0x000000e500d37306ULL, 0x000fe20000205400ULL,
0x000000c8cb00720bULL, 0x008fe20003fdd000ULL, 0x0000010060c87824ULL, 0x000fca00078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x00000031008e7306ULL, 0x0002ac000000d400ULL,
0x00000001c7c76812ULL, 0x000fe400078efcffULL, 0x000000e000e97306ULL, 0x000fe20000209400ULL,
0x0000010038317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x000000e000ec7306ULL, 0x000e620000205400ULL, 0x000000018e8e3812ULL, 0x004fce00078efcffULL,
0x0000003300e17306ULL, 0x000ff00000009400ULL, 0x0000003300ce7306ULL, 0x000fe20000005400ULL,
0x000000ece900720bULL, 0x002fce0003f7d000ULL, 0x0000005d00a17306ULL, 0x000ff00000009400ULL,
0x0000005d00927306ULL, 0x000ff00000005400ULL, 0x0000005d00787306ULL, 0x0003f0000000d400ULL,
0x000000df00e67306ULL, 0x000fe20000209400ULL, 0x000000ea005d7245ULL, 0x002fc8000020d400ULL,
0x000000015d5d5812ULL, 0x000fe400078efcffULL, 0x000000d3d200720bULL, 0x000fe20003fbd000ULL,
0x000000df00e77306ULL, 0x0002a20000205400ULL, 0x00000018ffd37819ULL, 0x000fe400000114ebULL,
0x0000008e5d5d723eULL, 0x000fca00000010ffULL, 0x000000c000cf7306ULL, 0x000fe20000209400ULL,
0x000000df00df7245ULL, 0x002fce000020d400ULL, 0x000000c000de7306ULL, 0x0002e20000205400ULL,
0x000000e7e600720bULL, 0x004fce0003fdd000ULL, 0x0000006000937306ULL, 0x000fe20000009400ULL,
0x000000c000c07245ULL, 0x002fca000020d400ULL, 0x00000001dfdf6812ULL, 0x000fe400078efcffULL,
0x0000006000967306ULL, 0x000ff00000005400ULL, 0x00000060006f7306ULL, 0x0003f0000000d400ULL,
0x000000db00e27306ULL, 0x000fe20000209400ULL, 0x000000d900607245ULL, 0x002fc8000020d400ULL,
0x0000000160601812ULL, 0x000fe400078efcffULL, 0x000000cee100720bULL, 0x000fe20003f3d000ULL,
0x000000db00e37306ULL, 0x0002a20000205400ULL, 0x000000e500ce7245ULL, 0x000fc8000020d400ULL,
0x00000001cece5812ULL, 0x000fe400078efcffULL, 0x000000decf00720bULL, 0x008fe20003fbd000ULL,
0x0000003100dd7306ULL, 0x000fe20000209400ULL, 0x000000e000cf7245ULL, 0x000fe4000020d400ULL,
0x000000db00db7245ULL, 0x002fe4000020d400ULL, 0x00000001cfcf3812ULL, 0x000fc600078efcffULL,
0x0000003100da7306ULL, 0x000e620000205400ULL, 0x000000e3e200720bULL, 0x004fc60003f7d000ULL,
0x00000001c0c05812ULL, 0x000fc800078efcffULL, 0x0000003000d17306ULL, 0x000fe20000209400ULL,
0x000000dfc0c0723eULL, 0x000fca00000010ffULL, 0x00000001dbdb3812ULL, 0x000fe400078efcffULL,
0x0000003000dc7306ULL, 0x000ea20000205400ULL, 0x000000dadd00720bULL, 0x002fce0003fdd000ULL,
0x0000003200c67306ULL, 0x000ff00000009400ULL, 0x0000003200b37306ULL, 0x000e620000005400ULL,
0x000000dcd100720bULL, 0x004fce0003fbd000ULL, 0x0000003200897306ULL, 0x0004f0000000d400ULL,
0x0000003900be7306ULL, 0x000fe20000009400ULL, 0x0001000038327824ULL, 0x004fe200078e00ffULL,
0x000000b3c600720bULL, 0x002fe20003f9d000ULL, 0x000100005fc67824ULL, 0x000fc600078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003900ad7306ULL, 0x000e620000005400ULL,
0x00000018ffc67819ULL, 0x000fcc00000114c6ULL, 0x0000000189894812ULL, 0x008fe200078efcffULL,
0x0000003300887306ULL, 0x000ea6000000d400ULL, 0x00000089cece723eULL, 0x000fca00000010ffULL,
0x000000bf00c17306ULL, 0x000fe20000209400ULL, 0x000000adbe00720bULL, 0x002fe40003f7d000ULL,
0x0000003100be7245ULL, 0x000fe4000020d400ULL, 0x0000003200ad7245ULL, 0x000fe4000020d400ULL,
0x00000001bebe6812ULL, 0x000fe200078efcffULL, 0x000000bf00c27306ULL, 0x000e620000205400ULL,
0x0000000188881812ULL, 0x004fc800078efcffULL, 0x00000088cfcf723eULL, 0x000fc600000010ffULL,
0x0000003200337306ULL, 0x000ff00000209400ULL, 0x0000003200d87306ULL, 0x000ea20000205400ULL,
0x000000c2c100720bULL, 0x002fe40003f3d000ULL, 0x000000bf00c27245ULL, 0x000fc4000020d400ULL,
0x0000003000bf7245ULL, 0x000fe4000020d400ULL, 0x0000a80066307811ULL, 0x000fe200078e20ffULL,
0x0000003800cc7306ULL, 0x000fe20000009400ULL, 0x00000001bfbf5812ULL, 0x000fca00078efcffULL,
0x00000001c2c21812ULL, 0x000fe400078efcffULL, 0x0000003800c97306ULL, 0x000e620000005400ULL,
0x000000d83300720bULL, 0x004fe40003fdd000ULL, 0x000000003030783bULL, 0x000fea0000000200ULL,
0x0000003800857306ULL, 0x000eac000000d400ULL, 0x00000001adad6812ULL, 0x000fc400078efcffULL,
0x000000d400d77306ULL, 0x000fe20000209400ULL, 0x000000c9cc00720bULL, 0x002fce0003f9d000ULL,
0x000000d400387306ULL, 0x0002ec0000205400ULL, 0x0000000185854812ULL, 0x004fe400078efcffULL,
0x0000003900867306ULL, 0x000522000000d400ULL, 0x000000d400d47245ULL, 0x002fe4000020d400ULL,
0x00000085bebe723eULL, 0x000fca00000010ffULL, 0x0000009400b47306ULL, 0x000fe20000209400ULL,
0x000001003b397824ULL, 0x004fe200078e00ffULL, 0x00000038d700720bULL, 0x008fe40003fbd000ULL,
0x0000a80065387811ULL, 0x000fe400078e20ffULL, 0x00000018ffaa7819ULL, 0x000fe40000011439ULL,
0x0000009400b77306ULL, 0x000e620000205400ULL, 0x0000000186863812ULL, 0x010fc800078efcffULL,
0x00000086bfbf723eULL, 0x000fe400000010ffULL, 0x00000001d4d45812ULL, 0x000fe200078efcffULL,
0x0000003b00bd7306ULL, 0x000ff00000009400ULL, 0x0000003b00b27306ULL, 0x000ea20000005400ULL,
0x000000b7b400720bULL, 0x002fc40003fdd000ULL, 0x00000002ffb77819ULL, 0x000fca000001162cULL,
0x0000003b007c7306ULL, 0x0002f0000000d400ULL, 0x0000003a00bc7306ULL, 0x000fe20000009400ULL,
0x000100003b3b7824ULL, 0x002fe200078e00ffULL, 0x000000b2bd00720bULL, 0x004fc40003f7d000ULL,
0x000000bb00b27245ULL, 0x000fe4000020d400ULL, 0x00000018ffaf7819ULL, 0x000fe2000001143bULL,
0x000001005c3b7824ULL, 0x000fe200078e00ffULL, 0x0000003a00b17306ULL, 0x000e680000005400ULL,
0x00000018ffb87819ULL, 0x000fe2000001143bULL, 0x000001005f3b7824ULL, 0x000fe400078e00ffULL,
0x000000017c7c3812ULL, 0x008fe200078efcffULL, 0x0000003a00827306ULL, 0x000eb0000000d400ULL,
0x000000bb00b57306ULL, 0x000fe20000209400ULL, 0x000000b1bc00720bULL, 0x002fc40003f9d000ULL,
0x0000009400b17245ULL, 0x000fc8000020d400ULL, 0x00000001b1b16812ULL, 0x000fe200078efcffULL,
0x000000bb00b67306ULL, 0x000e660000205400ULL, 0x000000d4b1b1723eULL, 0x000fc600000010ffULL,
0x0000000182824812ULL, 0x004fe400078efcffULL, 0x000000aa00397306ULL, 0x000ff00000209400ULL,
0x000000aa003a7306ULL, 0x000ea20000205400ULL, 0x000000b6b500720bULL, 0x002fc40003f3d000ULL,
0x00000018ffb57819ULL, 0x000fca000001143bULL, 0x0000009f00997306ULL, 0x000fec0000209400ULL,
0x00000001b2b21812ULL, 0x000fe400078efcffULL, 0x0000009f009e7306ULL, 0x0002e20000205400ULL,
0x0000003a3900720bULL, 0x004fe40003fbd000ULL, 0x000000003838783bULL, 0x000fea0000000200ULL,
0x0000005c00917306ULL, 0x000fe20000009400ULL, 0x0000009f009f7245ULL, 0x002fce000020d400ULL,
0x0000005c00a07306ULL, 0x000e620000005400ULL, 0x0000009e9900720bULL, 0x008fe40003fdd000ULL,
0x000000aa00997245ULL, 0x000fc8000020d400ULL, 0x0000000199995812ULL, 0x000fe200078efcffULL,
0x0000005c007b7306ULL, 0x0004ec000000d400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000af00ae7306ULL, 0x000fe20000209400ULL, 0x000100005e5c7824ULL, 0x004fe200078e00ffULL,
0x000000a09100720bULL, 0x002fc40003f7d000ULL, 0x000000ca00917245ULL, 0x000fe4000020d400ULL,
0x00000018ffb47819ULL, 0x000fe4000001145cULL, 0x000000af00b37306ULL, 0x0002a20000205400ULL,
0x00000010ff5c723eULL, 0x000fc800000010ffULL, 0x000054105c9e7816ULL, 0x000fe4000000005cULL,
0x000000017b7b3812ULL, 0x008fe200078efcffULL, 0x000000b800ba7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fe2000020d400ULL, 0x00001fb79eb77589ULL, 0x000e6800000e0000ULL,
0x00001f0a9e5c7589ULL, 0x000ee400000e0000ULL, 0x000000b800c57306ULL, 0x0009620000205400ULL,
0x000000b3ae00720bULL, 0x004fce0003fbd000ULL, 0x000000d300d97306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x010fca000020d400ULL, 0x00000001afaf5812ULL, 0x000fe400078efcffULL,
0x000000d300e67306ULL, 0x0005220000205400ULL, 0x000000c5ba00720bULL, 0x020fe20003fbd000ULL,
0x000000b73030a231ULL, 0x082fe400003400ffULL, 0x000000b73232a231ULL, 0x080fe400003400ffULL,
0x000000b73838a231ULL, 0x080fe400003400ffULL, 0x000000a400a57306ULL, 0x000fe20000209400ULL,
0x000000b73a3aa231ULL, 0x000fe200003400ffULL, 0x000000d300d37245ULL, 0x004fe2000020d400ULL,
0x0000005c3131a231ULL, 0x008fc400003400ffULL, 0x0000005c3333a231ULL, 0x080fe200003400ffULL,
0x00000001b8b85812ULL, 0x000fe200078efcffULL, 0x0000005c3939a231ULL, 0x080fe200003400ffULL,
0x000000a4009a7306ULL, 0x0002a20000205400ULL, 0x0000005c3b3ba231ULL, 0x000fe200003400ffULL,
0x000000e6d900720bULL, 0x010fe40003f5d000ULL, 0x000000a2b95c723eULL, 0x000fe200000010ffULL,
0x000000ce304c723cULL, 0x000fe6000004184cULL, 0x000000a900d57306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fc8000020d400ULL, 0x0000005c3054723cULL, 0x000fe40000041854ULL,
0x00000001d3d32812ULL, 0x000fe200078efcffULL, 0x000000a900d67306ULL, 0x0002e20000205400ULL,
0x0000009aa500720bULL, 0x004fc60003fbd000ULL, 0x000000b5005c7245ULL, 0x000fe2000020d400ULL,
0x000000be3044723cULL, 0x000fe60000041844ULL, 0x000000e400c17306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fca000020d400ULL, 0x00000001a4a45812ULL, 0x000fe400078efcffULL,
0x000000e400b67306ULL, 0x000e620000205400ULL, 0x000000d6d500720bULL, 0x008fe40003f3d000ULL,
0x000000969300720bULL, 0x000fe40003fbd000ULL, 0x0000008f00937245ULL, 0x000fc6000020d400ULL,
0x000000ac00ab7306ULL, 0x000fec0000209400ULL, 0x00000001a9a91812ULL, 0x000fe400078efcffULL,
0x000000ac00b07306ULL, 0x0004e20000205400ULL, 0x000000b6c100720bULL, 0x002fe40003f5d000ULL,
0x000000dbc2c1723eULL, 0x000fc400000010ffULL, 0x00000082a982723eULL, 0x000fe400000010ffULL,
0x000000016f6f5812ULL, 0x000fe200078efcffULL, 0x0000005e00907306ULL, 0x000fe20000009400ULL,
0x000000ac00ac7245ULL, 0x004fe2000020d400ULL, 0x000000c03048723cULL, 0x000fec0000041848ULL,
0x0000005e009b7306ULL, 0x000e620000005400ULL, 0x000000b0ab00720bULL, 0x008fc40003f3d000ULL,
0x000000adb2b0723eULL, 0x000fca00000010ffULL, 0x000000a700987306ULL, 0x000fe40000209400ULL,
0x000000b03040723cULL, 0x000fe80000041840ULL, 0x00000001acac1812ULL, 0x000fe400078efcffULL,
0x000000a700977306ULL, 0x000ea20000205400ULL, 0x0000009b9000720bULL, 0x002fe40003fdd000ULL,
0x000000a700907245ULL, 0x000fc4000020d400ULL, 0x00000092a100720bULL, 0x000fe40003f3d000ULL,
0x000000ac9fac723eULL, 0x000fe200000010ffULL, 0x000000b500bb7306ULL, 0x000ff00000209400ULL,
0x000000b500bc7306ULL, 0x0002e20000205400ULL, 0x000000979800720bULL, 0x004fc40003f9d000ULL,
0x0000000178781812ULL, 0x000fca00078efcffULL, 0x0000008f00a67306ULL, 0x000fe20000209400ULL,
0x000000c600b57245ULL, 0x002fca000020d400ULL, 0x0000000190904812ULL, 0x000fe400078efcffULL,
0x0000008f009d7306ULL, 0x0002a40000205400ULL, 0x000000af90ad723eULL, 0x000fe400000010ffULL,
0x0000007bb890723eULL, 0x000fc800000010ffULL, 0x0000005e00767306ULL, 0x000962000000d400ULL,
0x000000e4008f7245ULL, 0x002fe2000020d400ULL, 0x000000ac303c723cULL, 0x000fe6000004183cULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x000000bcbb00720bULL, 0x008fe20003f5d000ULL,
0x00000087008a7306ULL, 0x000fe20000209400ULL, 0x0000009da600720bULL, 0x004fe20003f3d000ULL,
0x00000100635e7824ULL, 0x010fca00078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001145eULL,
0x00000087008b7306ULL, 0x0002a20000205400ULL, 0x0000000176766812ULL, 0x020fe400078efcffULL,
0x00000081005e7245ULL, 0x000fe4000020d400ULL, 0x000000015c5c2812ULL, 0x000fe400078efcffULL,
0x0000000193931812ULL, 0x000fe200078efcffULL, 0x000000ca00cb7306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fce000020d400ULL, 0x000000ca00d27306ULL, 0x000e620000205400ULL,
0x0000008b8a00720bULL, 0x004fce0003fdd000ULL, 0x000000b400947306ULL, 0x000fec0000209400ULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x000000b400ab7306ULL, 0x0004e20000205400ULL,
0x000000d2cb00720bULL, 0x002fce0003f9d000ULL, 0x0000005f00a87306ULL, 0x000fe20000009400ULL,
0x000000b400b47245ULL, 0x004fca000020d400ULL, 0x0000000191914812ULL, 0x000fe400078efcffULL,
0x0000005f00957306ULL, 0x000e620000005400ULL, 0x000000ab9400720bULL, 0x008fe40003f5d000ULL,
0x000000789191723eULL, 0x000fca00000010ffULL, 0x0000008100847306ULL, 0x000fe40000209400ULL,
0x000000903854723cULL, 0x000fe80000041854ULL, 0x00000001b4b42812ULL, 0x000fe400078efcffULL,
0x0000008100837306ULL, 0x000ea20000205400ULL, 0x00000095a800720bULL, 0x002fe40003f7d000ULL,
0x000000b487b4723eULL, 0x000fca00000010ffULL, 0x000000e800c97306ULL, 0x000ff00000209400ULL,
0x000000e800cc7306ULL, 0x0002e20000205400ULL, 0x000000838400720bULL, 0x004fe40003f5d000ULL,
0x0000007c9983723eULL, 0x000fca00000010ffULL, 0x000000c8009b7306ULL, 0x000fe20000209400ULL,
0x000000e800e87245ULL, 0x002fe2000020d400ULL, 0x000000823034723cULL, 0x000fe80000041834ULL,
0x000000015e5e2812ULL, 0x000fe400078efcffULL, 0x000000c8009e7306ULL, 0x0002a20000205400ULL,
0x000000ccc900720bULL, 0x008fe40003f9d000ULL, 0x000000cd00c97245ULL, 0x000fca000020d400ULL,
0x0000005f00757306ULL, 0x000722000000d400ULL, 0x000000c800c87245ULL, 0x002fca000020d400ULL,
0x00000001e8e84812ULL, 0x000fe400078efcffULL, 0x00000062008d7306ULL, 0x000fe20000009400ULL,
0x0000009e9b00720bULL, 0x004fe20003fdd000ULL, 0x00000100625f7824ULL, 0x008fe200078e00ffULL,
0x000000e89393723eULL, 0x000fc800000010ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x00000062008c7306ULL, 0x000e620000005400ULL, 0x0000000175753812ULL, 0x010fca00078efcffULL,
0x00000001c8c86812ULL, 0x000fe400078efcffULL, 0x000000c600977306ULL, 0x000fe40000209400ULL,
0x0000006fc8c8723eULL, 0x000fcc00000010ffULL, 0x000000c600987306ULL, 0x000ea20000205400ULL,
0x0000008c8d00720bULL, 0x002fe40003f3d000ULL, 0x00000060c78d723eULL, 0x000fe400000010ffULL,
0x000000c3c48c723eULL, 0x000fc600000010ffULL, 0x0000006100a37306ULL, 0x000fe80000009400ULL,
0x0000008c3050723cULL, 0x000fe80000041850ULL, 0x00000061009c7306ULL, 0x000e620000005400ULL,
0x000000989700720bULL, 0x004fe40003f7d000ULL, 0x000000755c31723eULL, 0x000fc400000010ffULL,
0x000000768f30723eULL, 0x000fc600000010ffULL, 0x00000077007d7306ULL, 0x000fe80000209400ULL,
0x00000030384c723cULL, 0x000fe4000004184cULL, 0x00000001b5b53812ULL, 0x000fe400078efcffULL,
0x00000077007e7306ULL, 0x0004e20000205400ULL, 0x0000009ca300720bULL, 0x002fe40003f9d000ULL,
0x0000005f00307245ULL, 0x000fc4000020d400ULL, 0x0000008600317245ULL, 0x000fe4000020d400ULL,
0x000000b55eb5723eULL, 0x000fe200000010ffULL, 0x000000cd00927306ULL, 0x000fe20000209400ULL,
0x0000007700777245ULL, 0x004fca000020d400ULL, 0x000000b43848723cULL, 0x000fe40000041848ULL,
0x000000cd009d7306ULL, 0x000e620000205400ULL, 0x0000007e7d00720bULL, 0x008fce0003f5d000ULL,
0x00000061006e7306ULL, 0x0004ec000000d400ULL, 0x0000000177772812ULL, 0x000fe400078efcffULL,
0x0000006300807306ULL, 0x000fe20000009400ULL, 0x0001000061617824ULL, 0x004fe200078e00ffULL,
0x0000009d9200720bULL, 0x002fc40003fdd000ULL, 0x000000d3a492723eULL, 0x000fe400000010ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x00000063007f7306ULL, 0x000e620000005400ULL,
0x000000016e6e4812ULL, 0x008fe400078efcffULL, 0x0000006100d17245ULL, 0x000fe2000020d400ULL,
0x000000923850723cULL, 0x000fe60000041850ULL, 0x00000001c9c96812ULL, 0x000fe200078efcffULL,
0x00000070007a7306ULL, 0x000fe60000209400ULL, 0x0000006ec9c9723eULL, 0x000fca00000010ffULL,
0x0000007000797306ULL, 0x0004e20000205400ULL, 0x0000007f8000720bULL, 0x002fe20003f7d000ULL,
0x000000c83844723cULL, 0x000fec0000041844ULL, 0x000000d000957306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x004fce000020d400ULL, 0x000000d0008e7306ULL, 0x0002a20000205400ULL,
0x000000797a00720bULL, 0x008fce0003fbd000ULL, 0x00000061005d7306ULL, 0x000fe20000209400ULL,
0x000000d000d07245ULL, 0x002fca000020d400ULL, 0x0000000170705812ULL, 0x000fe400078efcffULL,
0x0000006100607306ULL, 0x000e620000205400ULL, 0x0000008e9500720bULL, 0x004fce0003fdd000ULL,
0x0000005f00857306ULL, 0x000fec0000209400ULL, 0x00000001d0d06812ULL, 0x000fe400078efcffULL,
0x0000005f00847306ULL, 0x000ea20000205400ULL, 0x000000605d00720bULL, 0x002fe40003f9d000ULL,
0x000000d077d0723eULL, 0x000fca00000010ffULL, 0x00000062006d7306ULL, 0x0002ec000000d400ULL,
0x00000001d1d14812ULL, 0x000fe400078efcffULL, 0x00000063006c7306ULL, 0x000962000000d400ULL,
0x0001000062627824ULL, 0x002fe200078e00ffULL, 0x000000848500720bULL, 0x004fc40003f5d000ULL,
0x000000d170d1723eULL, 0x000fe400000010ffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x00000086007f7306ULL, 0x000fe20000209400ULL, 0x0001000063637824ULL, 0x010fe200078e00ffULL,
0x000000016d6d1812ULL, 0x008fe200078efcffULL, 0x000000d03840723cULL, 0x000fe60000041840ULL,
0x00000018ff637819ULL, 0x000fc40000011463ULL, 0x00000086007c7306ULL, 0x000e620000205400ULL,
0x0000000130302812ULL, 0x000fe400078efcffULL, 0x000000016c6c3812ULL, 0x020fe400078efcffULL,
0x0000006d3030723eULL, 0x000fc600000010ffULL, 0x0000006a00737306ULL, 0x000ff00000209400ULL,
0x0000006a00747306ULL, 0x000ea20000205400ULL, 0x0000007c7f00720bULL, 0x002fce0003fbd000ULL,
0x0000006b00717306ULL, 0x000fec0000209400ULL, 0x0000000131315812ULL, 0x000fe400078efcffULL,
0x0000006b00727306ULL, 0x000e620000205400ULL, 0x000000747300720bULL, 0x004fe40003fdd000ULL,
0x0000006c3131723eULL, 0x000fca00000010ffULL, 0x0000006200797306ULL, 0x000fe40000209400ULL,
0x000000303834723cULL, 0x000fec0000041834ULL, 0x0000006200327306ULL, 0x0004e20000205400ULL,
0x000000727100720bULL, 0x002fce0003f9d000ULL, 0x0000006300337306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fce000020d400ULL, 0x00000063005c7306ULL, 0x0002a20000205400ULL,
0x000000327900720bULL, 0x008fe40003f5d000ULL, 0x0000006b00327245ULL, 0x000fc8000020d400ULL,
0x0000000132324812ULL, 0x000fe400078efcffULL, 0x0000006300637245ULL, 0x002fca000020d400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x0000005c3300720bULL, 0x004fe40003f3d000ULL,
0x0000006a00337245ULL, 0x000fc8000020d400ULL, 0x0000000133336812ULL, 0x000fc800078efcffULL,
0x000000623362723eULL, 0x000fc600000010ffULL, 0x0000000163631812ULL, 0x000fc800078efcffULL,
0x000000633263723eULL, 0x000fce00000010ffULL, 0x000000623838723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008064317811ULL, 0x000fe200078e40ffULL, 0x01062000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff23ff7812ULL, 0x000fe4000784c0ffULL, 0x000000315a00720cULL, 0x000fe40003f24070ULL,
0x00000001ff6a7807ULL, 0x000fd60005000000ULL, 0x0000960000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01065c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000a064317811ULL, 0x000fe200078e40ffULL, 0x00000100ff5e7424ULL, 0x000fe200078e00ffULL,
0x00000020683d7810ULL, 0x000fe40007ffe0ffULL, 0x000000315a307217ULL, 0x000fe40007800000ULL,
0x00000004ff5c7819ULL, 0x000fe2000001162cULL, 0x000000011a337824ULL, 0x000fe400078e023dULL,
0x0000000130307824ULL, 0x000fe400078e0a31ULL, 0x000000011f317824ULL, 0x000fc600078e023dULL,
0x0000002030327807ULL, 0x000fe20000000000ULL, 0x00005e0031307625ULL, 0x000fc600078e005eULL,
0x000000322d3c7217ULL, 0x000fe20007800000ULL, 0x00005e0033327625ULL, 0x000fe200078e005eULL,
0x00000020303e7210ULL, 0x000fc60007f3e0ffULL, 0x000000013c5d7824ULL, 0x000fe200078e0a2dULL,
0x0000002032327210ULL, 0x000fe20007f7e0ffULL, 0x0000000118307824ULL, 0x100fe400078e023dULL,
0x00000001173d7824ULL, 0x000fe200078e023dULL, 0x0000005d5c00720cULL, 0x080fe20003f46070ULL,
0x000000ffff3f7224ULL, 0x000fe200008e0631ULL, 0x0000005d2100720cULL, 0x080fe20003f26070ULL,
0x00005e0030307625ULL, 0x000fe200078e005eULL, 0x0000005d1c00720cULL, 0x000fc60003f86070ULL,
0x00005e003d3c7625ULL, 0x000fe200078e005eULL, 0x0000002030307210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff337224ULL, 0x000fe200018e0633ULL, 0x0000005d1e00720cULL, 0x000fe20003f66070ULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x000000203c3c7210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e167faeULL, 0x0003e8000d101c46ULL,
0x000000ffff3d7224ULL, 0x000fe200030e063dULL, 0x0000000032157faeULL, 0x0003ea000c901c46ULL,
0x0000000030147faeULL, 0x0003e8000d901c46ULL, 0x000000003c137faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff317984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01062c00ff327984ULL, 0x000ea20000000800ULL,
0x000000ff23ff7812ULL, 0x000fe2000782c0ffULL, 0x8000000012337824ULL, 0x000fc600078e00ffULL,
0x00000001ff6a7807ULL, 0x000fca0004800000ULL, 0x800000006a307824ULL, 0x000fca00078e00ffULL,
0x8000000031ff7812ULL, 0x002fe40007824830ULL, 0x8000000032ff7812ULL, 0x004fe20007844833ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fe400078e00ffULL, 0x8000000012327824ULL, 0x000fe400078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01062c00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844832ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0101000011317984ULL, 0x000e620000000800ULL,
0x00000001ff8e7424ULL, 0x000fc600078e00ffULL, 0x0103000011307984ULL, 0x0004e20000000800ULL,
0x0000002a3100720bULL, 0x002fda0003f5d000ULL, 0x0000000000327806ULL, 0x000fc800010e0100ULL,
0x0000ffff323c7812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x0000002a3100720bULL, 0x00cfe40003f54000ULL, 0x000000312a327209ULL, 0x000fe40007810000ULL,
0x00000002ff3e7819ULL, 0x000fc6000001162cULL, 0x800000322a337221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b33337820ULL, 0x000fe40000410000ULL, 0x00000000002a7806ULL, 0x000fe400010e0100ULL,
0x000000025b00780cULL, 0x000fe40003f45270ULL, 0x0000ffff2a3d7812ULL, 0x000fe200078e3cffULL,
0x0000003300337308ULL, 0x000e660000000800ULL, 0x0000003d3cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff8e7807ULL, 0x000fc60001800000ULL, 0x010500321100a388ULL, 0x000fe80000000800ULL,
0x00001f3e332a7589ULL, 0x002e6400000e0000ULL, 0x80000032313c3221ULL, 0x000fe20000010000ULL,
0x0000003329297220ULL, 0x000fe20000410000ULL, 0x00001f0a33317589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b3c3c3820ULL, 0x000fc80000410000ULL, 0x0000003c00103308ULL, 0x000ee20000000800ULL,
0x0000002a54547220ULL, 0x082fe20000410000ULL, 0x0000002a55557220ULL, 0x080fe20000410000ULL,
0x0000002a50507220ULL, 0x080fe20000410000ULL, 0x0000002a51517220ULL, 0x080fe20000410000ULL,
0x0000002a4c4c7220ULL, 0x080fe20000410000ULL, 0x0000002a4d4d7220ULL, 0x080fe20000410000ULL,
0x0000002a48487220ULL, 0x080fe20000410000ULL, 0x0000002a49497220ULL, 0x080fe20000410000ULL,
0x0000002a44447220ULL, 0x080fe20000410000ULL, 0x0000002a45457220ULL, 0x080fe20000410000ULL,
0x0000002a40407220ULL, 0x080fe20000410000ULL, 0x0000002a41417220ULL, 0x080fe20000410000ULL,
0x0000002a34347220ULL, 0x080fe20000410000ULL, 0x0000002a35357220ULL, 0x080fe20000410000ULL,
0x0000002a38387220ULL, 0x080fe20000410000ULL, 0x0000002a39397220ULL, 0x000fe20000410000ULL,
0x0000003156567220ULL, 0x084fe20000410000ULL, 0x0000003157577220ULL, 0x080fe20000410000ULL,
0x0000003152527220ULL, 0x080fe20000410000ULL, 0x0000003153537220ULL, 0x080fe20000410000ULL,
0x000000314e4e7220ULL, 0x080fe20000410000ULL, 0x000000314f4f7220ULL, 0x080fe20000410000ULL,
0x000000314a4a7220ULL, 0x080fe20000410000ULL, 0x000000314b4b7220ULL, 0x080fe20000410000ULL,
0x0000003146467220ULL, 0x080fe20000410000ULL, 0x0000003147477220ULL, 0x080fe20000410000ULL,
0x0000003142427220ULL, 0x080fe20000410000ULL, 0x0000003143437220ULL, 0x080fe20000410000ULL,
0x0000003136367220ULL, 0x080fe20000410000ULL, 0x0000003137377220ULL, 0x080fe20000410000ULL,
0x000000313a3a7220ULL, 0x080fe20000410000ULL, 0x000000313b3b7220ULL, 0x000fe20000410000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0032ULL, 0x0000003010303220ULL, 0x008fc80000410000ULL,
0x0000002930297221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff307984ULL, 0x000e620000000800ULL, 0x800000006a317824ULL, 0x000fca00078e00ffULL,
0x8000000030ff7812ULL, 0x002fe20007824831ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fe400078e00ffULL,
0x800000006a327824ULL, 0x000fe400078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01064c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000000f30783bULL, 0x000e620000004200ULL, 0x000099108e8e7816ULL, 0x000fc600000000ffULL,
0x000000000e3c783bULL, 0x000ea80000004200ULL, 0x000000000d5c783bULL, 0x000ee80000004200ULL,
0x000000000c60783bULL, 0x000f220000004200ULL, 0x0000010030dd7824ULL, 0x042fe200078e00ffULL,
0x0000003000c97306ULL, 0x000fe20000009400ULL, 0x0000010031eb7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd57819ULL, 0x000fe20000011431ULL, 0x0001000030e07824ULL, 0x000fe200078e00ffULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x0001000031df7824ULL, 0x000fe200078e00ffULL,
0x00000018ffeb7819ULL, 0x000fe200000114ebULL, 0x0000010032da7824ULL, 0x040fe200078e00ffULL,
0x0000003000ce7306ULL, 0x000e620000005400ULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x0001000032cf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fe20000011432ULL,
0x0000010033cd7824ULL, 0x040fe200078e00ffULL, 0x00000018ffae7819ULL, 0x004fe2000001143cULL,
0x000001003ebb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe27819ULL, 0x000fe20000011430ULL,
0x000000dd00cb7306ULL, 0x000fe20000209400ULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x0001000033c67824ULL, 0x000fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x000100003dbc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fc4000001143eULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x000000dd00d27306ULL, 0x000ea20000205400ULL,
0x000000cec900720bULL, 0x002fe20003f5d000ULL, 0x000100003ec97824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x008fe4000001145fULL, 0x00000018ffcf7819ULL, 0x000fe400000114cfULL,
0x00000018ffb47819ULL, 0x000fe20000011433ULL, 0x0000003100ee7306ULL, 0x000fe20000009400ULL,
0x00000018ff9a7819ULL, 0x000fc4000001143fULL, 0x00000018ffc67819ULL, 0x000fe400000114c6ULL,
0x00000018ffad7819ULL, 0x000fe4000001143dULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0000003100b97306ULL, 0x000e620000005400ULL, 0x000000d2cb00720bULL, 0x004fe40003f9d000ULL,
0x00000018ffc97819ULL, 0x000fe400000114c9ULL, 0x00000018ffbc7819ULL, 0x000fc400000114bcULL,
0x00000018ff947819ULL, 0x000fe2000001145cULL, 0x0000003000977306ULL, 0x0004e2000000d400ULL,
0x00000018ff957819ULL, 0x000fe4000001145dULL, 0x00000018ff887819ULL, 0x000fe4000001145eULL,
0x00000018ff7a7819ULL, 0x010fe40000011460ULL, 0x00000018ff757819ULL, 0x000fe20000011461ULL,
0x000000eb00ec7306ULL, 0x000fe20000209400ULL, 0x000000b9ee00720bULL, 0x002fe20003fdd000ULL,
0x000001003d307824ULL, 0x004fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fc40000011462ULL,
0x00000018ff6c7819ULL, 0x000fe40000011463ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000eb00ed7306ULL, 0x000e620000205400ULL, 0x0000000197972812ULL, 0x008fce00078efcffULL,
0x000000e000de7306ULL, 0x000ff00000209400ULL, 0x000000e000e37306ULL, 0x000fe20000205400ULL,
0x000000edec00720bULL, 0x002fe20003f5d000ULL, 0x000001005dec7824ULL, 0x000fcc00078e00ffULL,
0x0000003100907306ULL, 0x0002b0000000d400ULL, 0x0000003200d17306ULL, 0x000fe20000009400ULL,
0x000001003c317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003200d07306ULL, 0x000e620000005400ULL, 0x0000000190906812ULL, 0x004fce00078efcffULL,
0x00000032008b7306ULL, 0x0004f0000000d400ULL, 0x0000003c00c47306ULL, 0x000fe20000009400ULL,
0x000100003c327824ULL, 0x004fe200078e00ffULL, 0x000000d0d100720bULL, 0x002fc80003f3d000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003c00c57306ULL, 0x000fee0000005400ULL,
0x000000018b8b1812ULL, 0x008fe200078efcffULL, 0x0000003c00867306ULL, 0x0003f0000000d400ULL,
0x000000e200d37306ULL, 0x000fe20000209400ULL, 0x000001003f3c7824ULL, 0x002fca00078e00ffULL,
0x00000018ffb97819ULL, 0x000fe4000001143cULL, 0x000000e200d47306ULL, 0x000e620000205400ULL,
0x000000dd003c7245ULL, 0x000fe2000020d400ULL, 0x000100005edd7824ULL, 0x000fc600078e00ffULL,
0x000000013c3c4812ULL, 0x000fe400078efcffULL, 0x000000e3de00720bULL, 0x000fe20003f9d000ULL,
0x000000da00e97306ULL, 0x000fe20000209400ULL, 0x000001005fde7824ULL, 0x000fe200078e00ffULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x000100005de37824ULL, 0x000fe200078e00ffULL,
0x000000973c3c723eULL, 0x000fe400000010ffULL, 0x00000018ffde7819ULL, 0x000fe400000114deULL,
0x000000da00ea7306ULL, 0x0005e20000205400ULL, 0x000000d4d300720bULL, 0x002fe20003f7d000ULL,
0x000001005cd47824ULL, 0x000fe200078e00ffULL, 0x00000018ffe37819ULL, 0x000fc800000114e3ULL,
0x00000018ffd47819ULL, 0x000fe200000114d4ULL, 0x000000d500e67306ULL, 0x000fe20000209400ULL,
0x000000da00da7245ULL, 0x004fce000020d400ULL, 0x000000d500e57306ULL, 0x000ff00000205400ULL,
0x0000003300d97306ULL, 0x000ff00000009400ULL, 0x0000003300dc7306ULL, 0x000e700000005400ULL,
0x0000003e00b27306ULL, 0x000ff00000009400ULL, 0x0000003e00b37306ULL, 0x000fe20000005400ULL,
0x000000dcd900720bULL, 0x002fe20003fbd000ULL, 0x000001005edc7824ULL, 0x000fca00078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x0000003e00827306ULL, 0x0003f0000000d400ULL,
0x000000cd00e17306ULL, 0x000fe20000209400ULL, 0x000000e0003e7245ULL, 0x002fe2000020d400ULL,
0x000100005fe07824ULL, 0x000fc600078e00ffULL, 0x000000013e3e4812ULL, 0x000fe400078efcffULL,
0x000000e5e600720bULL, 0x000fe20003f9d000ULL, 0x000000cd00e47306ULL, 0x000e620000205400ULL,
0x0000010060e57824ULL, 0x000fe200078e00ffULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x0000010061e67824ULL, 0x000fc600078e00ffULL, 0x00000018ffe57819ULL, 0x000fe400000114e5ULL,
0x0000005f00937306ULL, 0x000fe20000009400ULL, 0x00000018ffe67819ULL, 0x000fce00000114e6ULL,
0x0000005f00927306ULL, 0x000fe20000005400ULL, 0x000000e4e100720bULL, 0x002fe40003fdd000ULL,
0x000000d500e47245ULL, 0x000fe4000020d400ULL, 0x00000018ffe17819ULL, 0x000fe400000114ecULL,
0x00000001e4e44812ULL, 0x000fe200078efcffULL, 0x0000005f00787306ULL, 0x0003f0000000d400ULL,
0x000000df00e77306ULL, 0x000fe20000209400ULL, 0x000000eb005f7245ULL, 0x002fc8000020d400ULL,
0x000000015f5f2812ULL, 0x000fe400078efcffULL, 0x000000eae900720bULL, 0x000fe20003f5d000ULL,
0x000000df00e87306ULL, 0x0003f00000205400ULL, 0x000000cf00d67306ULL, 0x000fe20000209400ULL,
0x000000df00df7245ULL, 0x002fc6000020d400ULL, 0x00000001dada2812ULL, 0x000fc800078efcffULL,
0x000000cf00db7306ULL, 0x0002b00000205400ULL, 0x000000b600c27306ULL, 0x000fe20000209400ULL,
0x000000cf00cf7245ULL, 0x002fce000020d400ULL, 0x000000b600c37306ULL, 0x0002e20000205400ULL,
0x000000dbd600720bULL, 0x004fce0003f5d000ULL, 0x0000003f00af7306ULL, 0x000fe20000009400ULL,
0x000000b600b67245ULL, 0x002fca000020d400ULL, 0x00000001cfcf2812ULL, 0x000fe400078efcffULL,
0x0000003f00a07306ULL, 0x000fe20000005400ULL, 0x000000c3c200720bULL, 0x008fe40003f9d000ULL,
0x000000cd00c27245ULL, 0x000fc8000020d400ULL, 0x00000001c2c26812ULL, 0x000fe200078efcffULL,
0x0000003f00817306ULL, 0x0003ec000000d400ULL, 0x00000001b6b64812ULL, 0x000fe400078efcffULL,
0x0000003300897306ULL, 0x000ea2000000d400ULL, 0x000100003f3f7824ULL, 0x002fca00078e00ffULL,
0x00000018ffd17819ULL, 0x000fe4000001143fULL, 0x000000b400b87306ULL, 0x000fe20000209400ULL,
0x000000e2003f7245ULL, 0x000fc8000020d400ULL, 0x000000013f3f3812ULL, 0x000fe400078efcffULL,
0x000000e8e700720bULL, 0x000fe20003f7d000ULL, 0x000000b400b57306ULL, 0x000e620000205400ULL,
0x0000000189895812ULL, 0x004fe400078efcffULL, 0x0000003e3f3e723eULL, 0x000fca00000010ffULL,
0x000000c600d77306ULL, 0x000fe80000209400ULL, 0x00000001dfdf3812ULL, 0x000fe400078efcffULL,
0x000000c5c400720bULL, 0x000fe40003f7d000ULL, 0x000000c600d87306ULL, 0x0004e20000205400ULL,
0x000000b5b800720bULL, 0x002fe40003fbd000ULL, 0x000000b400b57245ULL, 0x000fc4000020d400ULL,
0x000000dfe43f723eULL, 0x000fc600000010ffULL, 0x0000003d00ba7306ULL, 0x000fe20000009400ULL,
0x000000c600c67245ULL, 0x004fe4000020d400ULL, 0x0000000186863812ULL, 0x000fc600078efcffULL,
0x00000001b5b55812ULL, 0x000fe400078efcffULL, 0x0000003d00b77306ULL, 0x000e620000005400ULL,
0x000000d8d700720bULL, 0x008fce0003fdd000ULL, 0x0000003100c77306ULL, 0x000fec0000209400ULL,
0x00000001c6c66812ULL, 0x000fe400078efcffULL, 0x0000003100c87306ULL, 0x000ea20000205400ULL,
0x000000b7ba00720bULL, 0x002fe40003f3d000ULL, 0x000000b3b200720bULL, 0x000fc40003fdd000ULL,
0x0000003100b37245ULL, 0x000fe4000020d400ULL, 0x0000003000b27245ULL, 0x000fe2000020d400ULL,
0x0000003200bf7306ULL, 0x000ff00000209400ULL, 0x0000003200cc7306ULL, 0x000e620000205400ULL,
0x000000c8c700720bULL, 0x004fc40003f5d000ULL, 0x0000000182826812ULL, 0x000fca00078efcffULL,
0x0000003d00837306ULL, 0x000eac000000d400ULL, 0x00000001b3b32812ULL, 0x000fe400078efcffULL,
0x000000ad00b07306ULL, 0x000fe20000209400ULL, 0x000000ccbf00720bULL, 0x002fce0003fbd000ULL,
0x000000ad00b17306ULL, 0x0002e20000205400ULL, 0x0000000183831812ULL, 0x004fce00078efcffULL,
0x000000ae009f7306ULL, 0x000fe20000209400ULL, 0x000000ad00ad7245ULL, 0x002fce000020d400ULL,
0x000000ae009c7306ULL, 0x000e620000205400ULL, 0x000000b1b000720bULL, 0x008fce0003f7d000ULL,
0x000000bb00be7306ULL, 0x000fec0000209400ULL, 0x00000001adad3812ULL, 0x000fe400078efcffULL,
0x000000bb00337306ULL, 0x0004e20000205400ULL, 0x0000009c9f00720bULL, 0x002fe40003f5d000ULL,
0x00000032009c7245ULL, 0x000fc4000020d400ULL, 0x000000ae009f7245ULL, 0x000fe4000020d400ULL,
0x000000019c9c5812ULL, 0x000fe200078efcffULL, 0x0000003000c17306ULL, 0x000fe20000209400ULL,
0x000000a0af00720bULL, 0x000fe40003fbd000ULL, 0x000000bb00bb7245ULL, 0x004fe4000020d400ULL,
0x000000b900a07245ULL, 0x000fe4000020d400ULL, 0x000000019f9f2812ULL, 0x000fe200078efcffULL,
0x0000003000ca7306ULL, 0x0002a20000205400ULL, 0x00000033be00720bULL, 0x008fc40003f3d000ULL,
0x0000009c9f9c723eULL, 0x000fc600000010ffULL, 0x0000000181815812ULL, 0x000fe400078efcffULL,
0x000000c900cb7306ULL, 0x000fe20000209400ULL, 0x0000b0000b307811ULL, 0x002fca00078e20ffULL,
0x00000001bbbb1812ULL, 0x000fe200078efcffULL, 0x000000003030783bULL, 0x000fe20000000200ULL,
0x000000c900d07306ULL, 0x0002e20000205400ULL, 0x000000cac100720bULL, 0x004fce0003f9d000ULL,
0x000000a700aa7306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fca000020d400ULL,
0x00000001b2b24812ULL, 0x000fe400078efcffULL, 0x000000a700a57306ULL, 0x000e620000205400ULL,
0x000000d0cb00720bULL, 0x008fce0003f7d000ULL, 0x0000009a00a97306ULL, 0x000fec0000209400ULL,
0x00000001c9c93812ULL, 0x000fe400078efcffULL, 0x0000009a009e7306ULL, 0x000ea20000205400ULL,
0x000000a5aa00720bULL, 0x002fce0003f3d000ULL, 0x000000bc00bd7306ULL, 0x000ff00000209400ULL,
0x000000bc00c07306ULL, 0x0002e20000205400ULL, 0x0000009ea900720bULL, 0x004fe40003fbd000ULL,
0x000000a7009e7245ULL, 0x000fc8000020d400ULL, 0x000000019e9e1812ULL, 0x000fe200078efcffULL,
0x000000d400d97306ULL, 0x000fe20000209400ULL, 0x000000bc00bc7245ULL, 0x002fe4000020d400ULL,
0x000000c99e9e723eULL, 0x000fca00000010ffULL, 0x000000d400e27306ULL, 0x000e620000205400ULL,
0x000000c0bd00720bULL, 0x008fce0003f9d000ULL, 0x0000005e009d7306ULL, 0x000fec0000009400ULL,
0x00000001bcbc4812ULL, 0x000fe400078efcffULL, 0x0000005e00a47306ULL, 0x000ea20000005400ULL,
0x000000e2d900720bULL, 0x002fce0003f7d000ULL, 0x000000d100d27306ULL, 0x000ff00000209400ULL,
0x000000d100d37306ULL, 0x0002e20000205400ULL, 0x000000a49d00720bULL, 0x004fe40003f3d000ULL,
0x0000009a00a47245ULL, 0x000fc8000020d400ULL, 0x00000001a4a45812ULL, 0x000fe200078efcffULL,
0x000000b9003d7306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x002fce000020d400ULL,
0x000000b900ce7306ULL, 0x000e620000205400ULL, 0x000000d3d200720bULL, 0x008fce0003fdd000ULL,
0x0000005c00ac7306ULL, 0x000fec0000009400ULL, 0x00000001d1d16812ULL, 0x000fe400078efcffULL,
0x0000005c00a37306ULL, 0x000ea20000005400ULL, 0x000000ce3d00720bULL, 0x002fe40003f5d000ULL,
0x000000d1a49f723eULL, 0x000fca00000010ffULL, 0x0000005c007e7306ULL, 0x0002ec000000d400ULL,
0x00000001a0a02812ULL, 0x000fe400078efcffULL, 0x0000009400a27306ULL, 0x000fe20000209400ULL,
0x000100005c5c7824ULL, 0x002fe200078e00ffULL, 0x000000a3ac00720bULL, 0x004fc40003f9d000ULL,
0x000000d400a37245ULL, 0x000fe4000020d400ULL, 0x00000081a081723eULL, 0x000fe400000010ffULL,
0x00000094009b7306ULL, 0x000e620000205400ULL, 0x00000001a3a33812ULL, 0x000fcc00078efcffULL,
0x000000017e7e4812ULL, 0x008fe200078efcffULL, 0x0000005e00777306ULL, 0x0004e6000000d400ULL,
0x0000007ea37e723eULL, 0x000fca00000010ffULL, 0x0000009500a67306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x004fe2000001145cULL, 0x00000100635c7824ULL, 0x000fe200078e00ffULL,
0x0000009ba200720bULL, 0x002fe40003fbd000ULL, 0x0000005e009a7245ULL, 0x000fe4000020d400ULL,
0x00000094009b7245ULL, 0x000fe2000020d400ULL, 0x0000009500a17306ULL, 0x000e620000205400ULL,
0x000000e100947245ULL, 0x000fe4000020d400ULL, 0x0000000177771812ULL, 0x008fca00078efcffULL,
0x0000005e00e77306ULL, 0x000fe20000209400ULL, 0x000000019b9b5812ULL, 0x000fce00078efcffULL,
0x0000005e00e87306ULL, 0x0004e20000205400ULL, 0x000000a1a600720bULL, 0x002fe40003f7d000ULL,
0x00000002ffa17819ULL, 0x000fca000001162cULL, 0x0000005d00a87306ULL, 0x000fe20000009400ULL,
0x00000010ff5e723eULL, 0x004fc800000010ffULL, 0x000054105ea97816ULL, 0x000fe2000000005eULL,
0x000000ffff5e7224ULL, 0x000fe400078e008eULL, 0x0000005d00ab7306ULL, 0x000e620000005400ULL,
0x000000e8e700720bULL, 0x008fe20003fdd000ULL, 0x00001fa1a9a17589ULL, 0x000ea800000e0000ULL,
0x00001f0aa98e7589ULL, 0x000ee400000e0000ULL, 0x000000dc00b87306ULL, 0x000fec0000209400ULL,
0x000000019a9a6812ULL, 0x000fc400078efcffULL, 0x000000dc00b17306ULL, 0x0009620000205400ULL,
0x000000aba800720bULL, 0x002fe40003f5d000ULL, 0x0000009a9b9a723eULL, 0x000fca00000010ffULL,
0x000000e100d57306ULL, 0x000fe20000209400ULL, 0x000000dc00dc7245ULL, 0x010fce000020d400ULL,
0x000000e100c47306ULL, 0x000e620000205400ULL, 0x000000b1b800720bULL, 0x020fce0003fbd000ULL,
0x000000e300b77306ULL, 0x000fec0000209400ULL, 0x00000001dcdc5812ULL, 0x000fe400078efcffULL,
0x000000e300b47306ULL, 0x0009620000205400ULL, 0x000000c4d500720bULL, 0x002fce0003f9d000ULL,
0x0000005d007d7306ULL, 0x0002a2000000d400ULL, 0x000000e300e37245ULL, 0x010fca000020d400ULL,
0x0000000194944812ULL, 0x000fe400078efcffULL, 0x000000de00ae7306ULL, 0x000fe20000209400ULL,
0x000000b4b700720bULL, 0x020fe20003fdd000ULL, 0x00000100625d7824ULL, 0x002fe200078e00ffULL,
0x000000929300720bULL, 0x000fe40003f9d000ULL, 0x0000009500927245ULL, 0x000fe4000020d400ULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x000000de003d7306ULL, 0x000e620000205400ULL,
0x000000017d7d2812ULL, 0x004fc400078efcffULL, 0x000000ff5e00720cULL, 0x000fe40003f45270ULL,
0x0000008bda5e723eULL, 0x000fe400000010ffULL, 0x00000001e3e36812ULL, 0x000fe200078efcffULL,
0x00000088008f7306ULL, 0x000fe20000209400ULL, 0x0000000178784812ULL, 0x000fe400078efcffULL,
0x0000000192923812ULL, 0x000fc800078efcffULL, 0x000000e3929b723eULL, 0x000fe200000010ffULL,
0x00000088008c7306ULL, 0x0005220000205400ULL, 0x0000003dae00720bULL, 0x002fe20003fbd000ULL,
0x000000a13030a231ULL, 0x080fe200003400ffULL, 0x000000905f3d723eULL, 0x000fe200000010ffULL,
0x000000a13232a231ULL, 0x000fe200003400ffULL, 0x00000089c25f723eULL, 0x000fe200000010ffULL,
0x0000008e3131a231ULL, 0x088fe200003400ffULL, 0x000000e000897245ULL, 0x000fe2000020d400ULL,
0x0000006000917306ULL, 0x000fe20000009400ULL, 0x0000008e3333a231ULL, 0x000fe200003400ffULL,
0x0000008800887245ULL, 0x004fcc000020d400ULL, 0x0000006000967306ULL, 0x000e620000005400ULL,
0x0000008c8f00720bULL, 0x010fe20003f3d000ULL, 0x0000005e304c723cULL, 0x040fec000004184cULL,
0x000000dd00a57306ULL, 0x000fe20000209400ULL, 0x00000086b35e723eULL, 0x000fe200000010ffULL,
0x0000003c3054723cULL, 0x000fe20000041854ULL, 0x00000083b25f723eULL, 0x000fc400000010ffULL,
0x00000018ff837819ULL, 0x000fe4000001145cULL, 0x0000000188881812ULL, 0x000fe200078efcffULL,
0x000000dd00a87306ULL, 0x0004e20000205400ULL, 0x000000969100720bULL, 0x002fe20003fdd000ULL,
0x0000005e3044723cULL, 0x040fe20000041844ULL, 0x000000de00917245ULL, 0x000fe4000020d400ULL,
0x0000b000093c7811ULL, 0x000fe400078e20ffULL, 0x0000000191915812ULL, 0x000fe200078efcffULL,
0x000000e500a67306ULL, 0x000fe20000209400ULL, 0x000000dd00dd7245ULL, 0x004fe2000020d400ULL,
0x0000003e3050723cULL, 0x000fe20000041850ULL, 0x000000e5005e7245ULL, 0x000fe2000020d400ULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000e6005f7245ULL, 0x000fc4000020d400ULL,
0x000000789191723eULL, 0x000fe200000010ffULL, 0x000000e500a77306ULL, 0x000ea20000205400ULL,
0x000000a8a500720bULL, 0x008fce0003fbd000ULL, 0x00000085008d7306ULL, 0x000fec0000209400ULL,
0x00000001dddd5812ULL, 0x000fe400078efcffULL, 0x00000085008a7306ULL, 0x000ee20000205400ULL,
0x000000a7a600720bULL, 0x004fe40003f3d000ULL, 0x000000dd8888723eULL, 0x000fca00000010ffULL,
0x0000006000717306ULL, 0x00052c000000d400ULL, 0x000000015e5e1812ULL, 0x000fe400078efcffULL,
0x000000e0009d7306ULL, 0x000fe20000209400ULL, 0x0001000060607824ULL, 0x004fe200078e00ffULL,
0x0000008a8d00720bULL, 0x008fe20003f9d000ULL, 0x000000a13c3ca231ULL, 0x002fc600003400ffULL,
0x00000018ff907819ULL, 0x000fe20000011460ULL, 0x000000a13e3ea231ULL, 0x000fe200003400ffULL,
0x000000e000a27306ULL, 0x000e620000205400ULL, 0x000000cfb660723eULL, 0x000fe200000010ffULL,
0x0000008e3d3da231ULL, 0x080fe200003400ffULL, 0x0000000171716812ULL, 0x010fe200078efcffULL,
0x0000008e3f3fa231ULL, 0x000fc600003400ffULL, 0x000000715e5e723eULL, 0x000fe200000010ffULL,
0x0000006100987306ULL, 0x000fe60000009400ULL, 0x0000009a3c50723cULL, 0x000fea0000041850ULL,
0x0000006100997306ULL, 0x000ea20000005400ULL, 0x000000a29d00720bULL, 0x002fc40003fbd000ULL,
0x000000bcad9d723eULL, 0x000fca00000010ffULL, 0x0000006100727306ULL, 0x0002e4000000d400ULL,
0x0000009c3040723cULL, 0x000fe80000041840ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x000000e600957306ULL, 0x000fe20000209400ULL, 0x0001000061617824ULL, 0x002fe200078e00ffULL,
0x000000999800720bULL, 0x004fc80003f7d000ULL, 0x00000018ff8a7819ULL, 0x000fe40000011461ULL,
0x000000e600967306ULL, 0x000e620000205400ULL, 0x000000c6b561723eULL, 0x000fcc00000010ffULL,
0x0000000172723812ULL, 0x008fe200078efcffULL, 0x0000006300807306ULL, 0x000fe20000009400ULL,
0x000000603048723cULL, 0x000fee0000041848ULL, 0x00000063007f7306ULL, 0x000ea20000005400ULL,
0x0000008500607245ULL, 0x000fc4000020d400ULL, 0x000000969500720bULL, 0x002fe40003f3d000ULL,
0x0000000160604812ULL, 0x000fc600078efcffULL, 0x0000009000937306ULL, 0x000fe20000209400ULL,
0x000000896089723eULL, 0x000fce00000010ffULL, 0x00000090008c7306ULL, 0x000e620000205400ULL,
0x0000007f8000720bULL, 0x004fe20003f9d000ULL, 0x000000883c48723cULL, 0x000fe20000041848ULL,
0x00000082bb80723eULL, 0x000fe400000010ffULL, 0x000000015f5f1812ULL, 0x000fe400078efcffULL,
0x0000007d947f723eULL, 0x000fe200000010ffULL, 0x0000006200877306ULL, 0x000fe20000009400ULL,
0x000000725f5f723eULL, 0x000fe200000010ffULL, 0x000000803034723cULL, 0x040fec0000041834ULL,
0x0000006200847306ULL, 0x000ea20000005400ULL, 0x0000008c9300720bULL, 0x002fe20003fdd000ULL,
0x0000009e3030723cULL, 0x000fec0000041838ULL, 0x0000007a007b7306ULL, 0x000fe20000209400ULL,
0x0000009000387245ULL, 0x000fe2000020d400ULL, 0x0000007e3c54723cULL, 0x000fe20000041854ULL,
0x0000007a00397245ULL, 0x000fc4000020d400ULL, 0x0000005d003a7245ULL, 0x000fe4000020d400ULL,
0x0000000138386812ULL, 0x000fe200078efcffULL, 0x0000007a007c7306ULL, 0x000e620000205400ULL,
0x000000848700720bULL, 0x004fe20003fbd000ULL, 0x0000005e3c44723cULL, 0x000fe20000041844ULL,
0x00000077dc90723eULL, 0x000fca00000010ffULL, 0x0000007500767306ULL, 0x000fe40000209400ULL,
0x000000903c4c723cULL, 0x000fec000004184cULL, 0x0000007500797306ULL, 0x0004e20000205400ULL,
0x0000007c7b00720bULL, 0x002fce0003f3d000ULL, 0x0000005d00617306ULL, 0x000fe20000209400ULL,
0x0000007500757245ULL, 0x004fca000020d400ULL, 0x0000000139391812ULL, 0x000fe400078efcffULL,
0x0000005d00847306ULL, 0x000e620000205400ULL, 0x000000797600720bULL, 0x008fe40003fdd000ULL,
0x000000383938723eULL, 0x000fca00000010ffULL, 0x00000062006d7306ULL, 0x0004ec000000d400ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x0000008a008b7306ULL, 0x000fe20000209400ULL,
0x0001000062627824ULL, 0x004fe200078e00ffULL, 0x000000846100720bULL, 0x002fc80003f3d000ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000008a00987306ULL, 0x0002a20000205400ULL,
0x000000016d6d5812ULL, 0x008fcc00078efcffULL, 0x000000013a3a1812ULL, 0x000fe200078efcffULL,
0x0000008300827306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x002fe4000020d400ULL,
0x0000006d3a3a723eULL, 0x000fca00000010ffULL, 0x00000083007d7306ULL, 0x000e620000205400ULL,
0x000000988b00720bULL, 0x004fce0003f7d000ULL, 0x00000063006e7306ULL, 0x0004ec000000d400ULL,
0x000000018a8a3812ULL, 0x000fe400078efcffULL, 0x00000062003b7306ULL, 0x000fe20000209400ULL,
0x0001000063637824ULL, 0x004fe200078e00ffULL, 0x0000007d8200720bULL, 0x002fc40003fdd000ULL,
0x0000008a7539723eULL, 0x000fe400000010ffULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x00000062005c7306ULL, 0x0002a20000205400ULL, 0x000000016e6e4812ULL, 0x008fe400078efcffULL,
0x000000383c40723cULL, 0x000fea0000041840ULL, 0x0000006b00747306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x002fce000020d400ULL, 0x0000006b00737306ULL, 0x0002e20000205400ULL,
0x0000005c3b00720bULL, 0x004fe40003fbd000ULL, 0x00000083003b7245ULL, 0x000fc8000020d400ULL,
0x000000013b3b6812ULL, 0x000fe200078efcffULL, 0x0000006c00707306ULL, 0x000fe20000209400ULL,
0x0000006b006b7245ULL, 0x002fe4000020d400ULL, 0x0000006e3b3b723eULL, 0x000fc600000010ffULL,
0x0000000162625812ULL, 0x000fe400078efcffULL, 0x0000006c006f7306ULL, 0x0002a20000205400ULL,
0x000000737400720bULL, 0x008fe20003f7d000ULL, 0x0000003a3c34723cULL, 0x000fec0000041834ULL,
0x0000006300767306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fca000020d400ULL,
0x000000016b6b3812ULL, 0x000fe400078efcffULL, 0x0000006300617306ULL, 0x0002e20000205400ULL,
0x0000006f7000720bULL, 0x004fe40003f3d000ULL, 0x000000626b62723eULL, 0x000fe400000010ffULL,
0x0000006300637245ULL, 0x002fd2000020d400ULL, 0x000000016c6c1812ULL, 0x000fe400078efcffULL,
0x000000617600720bULL, 0x008fda0003fdd000ULL, 0x0000000163636812ULL, 0x000fc800078efcffULL,
0x000000636c63723eULL, 0x000fce00000010ffULL, 0x000000623c3c723cULL, 0x000fe20000041830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01065c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000c064317811ULL, 0x000fe200078e40ffULL, 0x00000100ff5e7424ULL, 0x000fe200078e00ffULL,
0x00000040683b7810ULL, 0x000fc40007ffe0ffULL, 0x000000315a307217ULL, 0x000fe40007800000ULL,
0x00000004ff5c7819ULL, 0x000fe2000001162cULL, 0x000000011a337824ULL, 0x000fe400078e023bULL,
0x0000000130307824ULL, 0x000fe400078e0a31ULL, 0x000000011f317824ULL, 0x100fe400078e023bULL,
0x0000000118397824ULL, 0x000fe200078e023bULL, 0x0000002030327807ULL, 0x000fe20000000000ULL,
0x00005e0031307625ULL, 0x000fc600078e005eULL, 0x000000322d387217ULL, 0x000fe20007800000ULL,
0x00005e0033327625ULL, 0x000fe200078e005eULL, 0x00000020303a7210ULL, 0x000fc60007f3e0ffULL,
0x00000001385d7824ULL, 0x000fe200078e0a2dULL, 0x0000002032327210ULL, 0x000fe20007f9e0ffULL,
0x00005e0039387625ULL, 0x000fc600078e005eULL, 0x0000005d2100720cULL, 0x080fe20003f66070ULL,
0x0000000117307824ULL, 0x000fe200078e023bULL, 0x0000002038387210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200008e0631ULL, 0x0000005d5c00720cULL, 0x000fe20003f26070ULL,
0x00005e0030307625ULL, 0x000fc800078e005eULL, 0x000000ffff337224ULL, 0x000fe200020e0633ULL,
0x0000005d1e00720cULL, 0x080fe20003f86070ULL, 0x000000ffff397224ULL, 0x000fe200028e0639ULL,
0x0000005d1c00720cULL, 0x000fe40003fa6070ULL, 0x0000002030307210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a087faeULL, 0x0003e4000c901c46ULL,
0x000000ffff317224ULL, 0x000fe400030e0631ULL, 0x0000000032077faeULL, 0x0003e8000d901c46ULL,
0x0000000038067faeULL, 0x0003e8000e101c46ULL, 0x0000000030057faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff307984ULL, 0x002e620000000800ULL,
0x800000006a317824ULL, 0x000fca00078e00ffULL, 0x8000000030ff7812ULL, 0x002fe20007824831ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x800000006a6a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x01065400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc4000782486aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000000430783bULL, 0x000e680000004200ULL,
0x00000000025c783bULL, 0x000ea80000004200ULL, 0x000000000338783bULL, 0x000ee80000004200ULL,
0x000000000060783bULL, 0x000f220000004200ULL, 0x0000010030b97824ULL, 0x042fe200078e00ffULL,
0x0000003000aa7306ULL, 0x000fe20000009400ULL, 0x0001000030c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fe20000011430ULL, 0x0000010031ea7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0001000031d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000010032e57824ULL, 0x040fe200078e00ffULL,
0x000000b900ae7306ULL, 0x000fe20000209400ULL, 0x00000018ffea7819ULL, 0x000fe200000114eaULL,
0x0000010033e07824ULL, 0x000fe200078e00ffULL, 0x00000018ffd97819ULL, 0x000fe200000114d9ULL,
0x0001000032df7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe20000011431ULL,
0x000100005de87824ULL, 0x004fe200078e00ffULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x000000b900af7306ULL, 0x0002a20000205400ULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x0001000033db7824ULL, 0x000fe200078e00ffULL, 0x00000018ffdf7819ULL, 0x000fe200000114dfULL,
0x0001000039d47824ULL, 0x008fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe20000011432ULL,
0x000001003aa97824ULL, 0x040fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001145dULL,
0x0000003000ef7306ULL, 0x000ee20000005400ULL, 0x000000b900b97245ULL, 0x002fe2000020d400ULL,
0x000100003ab07824ULL, 0x000fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x000001005ee47824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x010fc40000011460ULL,
0x00000018ffbf7819ULL, 0x000fe20000011433ULL, 0x000000c400b87306ULL, 0x000fe20000209400ULL,
0x000000afae00720bULL, 0x004fe40003fdd000ULL, 0x00000018ffd47819ULL, 0x000fe400000114d4ULL,
0x00000018ffbb7819ULL, 0x000fe40000011438ULL, 0x00000018ff947819ULL, 0x000fe20000011439ULL,
0x000000c400c57306ULL, 0x0002a20000205400ULL, 0x000000efaa00720bULL, 0x008fc40003fbd000ULL,
0x00000018ffa77819ULL, 0x000fe4000001143bULL, 0x00000018ff9f7819ULL, 0x000fe4000001143aULL,
0x00000001b9b96812ULL, 0x000fe200078efcffULL, 0x000000c300ba7306ULL, 0x000fe20000209400ULL,
0x000000c400c47245ULL, 0x002fe4000020d400ULL, 0x00000018ffa47819ULL, 0x000fe4000001145cULL,
0x00000018ffa97819ULL, 0x000fc400000114a9ULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x000000c300eb7306ULL, 0x0002e20000205400ULL, 0x000000c5b800720bULL, 0x004fe40003f3d000ULL,
0x00000018ff877819ULL, 0x000fe4000001145eULL, 0x00000018ff817819ULL, 0x000fe4000001145fULL,
0x00000018ffe87819ULL, 0x000fe200000114e8ULL, 0x0000003000a27306ULL, 0x000522000000d400ULL,
0x000000c300c37245ULL, 0x002fc4000020d400ULL, 0x00000018ff707819ULL, 0x000fe40000011461ULL,
0x00000018ff6a7819ULL, 0x000fe40000011462ULL, 0x00000001c4c41812ULL, 0x000fe200078efcffULL,
0x000000ea00ca7306ULL, 0x000fe20000209400ULL, 0x000000ebba00720bULL, 0x008fe20003fdd000ULL,
0x0000010039307824ULL, 0x004fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011463ULL,
0x000100005ceb7824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000ea00ed7306ULL, 0x000e620000205400ULL, 0x00000001a2a25812ULL, 0x010fca00078efcffULL,
0x00000001c3c36812ULL, 0x000fe400078efcffULL, 0x0000003100ab7306ULL, 0x000ff00000009400ULL,
0x0000003100ac7306ULL, 0x000ea20000005400ULL, 0x000000edca00720bULL, 0x002fe20003fbd000ULL,
0x000001005dca7824ULL, 0x000fca00078e00ffULL, 0x00000018ffca7819ULL, 0x000fe200000114caULL,
0x000000d900cd7306ULL, 0x000ff00000209400ULL, 0x000000d900d07306ULL, 0x000e620000205400ULL,
0x000000acab00720bULL, 0x004fc40003f7d000ULL, 0x00000018ffac7819ULL, 0x000fca00000114b0ULL,
0x000000c700cb7306ULL, 0x000ff00000209400ULL, 0x000000c700c87306ULL, 0x0004e20000205400ULL,
0x000000d0cd00720bULL, 0x002fe20003f3d000ULL, 0x0001000060d07824ULL, 0x000fc400078e00ffULL,
0x0000010061cd7824ULL, 0x000fc600078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x000000e500d27306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x004fe4000020d400ULL,
0x00000018ffcd7819ULL, 0x000fca00000114cdULL, 0x000000e500d37306ULL, 0x000fe20000205400ULL,
0x000000c8cb00720bULL, 0x008fe20003fdd000ULL, 0x0000010060c87824ULL, 0x000fca00078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x00000031008e7306ULL, 0x0002ac000000d400ULL,
0x00000001c7c76812ULL, 0x000fe400078efcffULL, 0x000000e000e97306ULL, 0x000fe20000209400ULL,
0x0000010038317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x000000e000ec7306ULL, 0x000e620000205400ULL, 0x000000018e8e3812ULL, 0x004fce00078efcffULL,
0x0000003300e17306ULL, 0x000ff00000009400ULL, 0x0000003300ce7306ULL, 0x000fe20000005400ULL,
0x000000ece900720bULL, 0x002fce0003f7d000ULL, 0x0000005d00a17306ULL, 0x000ff00000009400ULL,
0x0000005d00927306ULL, 0x000ff00000005400ULL, 0x0000005d00787306ULL, 0x0003f0000000d400ULL,
0x000000df00e67306ULL, 0x000fe20000209400ULL, 0x000000ea005d7245ULL, 0x002fc8000020d400ULL,
0x000000015d5d5812ULL, 0x000fe400078efcffULL, 0x000000d3d200720bULL, 0x000fe20003fbd000ULL,
0x000000df00e77306ULL, 0x0002a20000205400ULL, 0x00000018ffd37819ULL, 0x000fe400000114ebULL,
0x0000008e5d5d723eULL, 0x000fca00000010ffULL, 0x000000c000cf7306ULL, 0x000fe20000209400ULL,
0x000000df00df7245ULL, 0x002fce000020d400ULL, 0x000000c000de7306ULL, 0x0002e20000205400ULL,
0x000000e7e600720bULL, 0x004fce0003fdd000ULL, 0x0000006000937306ULL, 0x000fe20000009400ULL,
0x000000c000c07245ULL, 0x002fca000020d400ULL, 0x00000001dfdf6812ULL, 0x000fe400078efcffULL,
0x0000006000967306ULL, 0x000ff00000005400ULL, 0x00000060006f7306ULL, 0x0003f0000000d400ULL,
0x000000db00e27306ULL, 0x000fe20000209400ULL, 0x000000d900607245ULL, 0x002fc8000020d400ULL,
0x0000000160601812ULL, 0x000fe400078efcffULL, 0x000000cee100720bULL, 0x000fe20003f3d000ULL,
0x000000db00e37306ULL, 0x0002a20000205400ULL, 0x000000e500ce7245ULL, 0x000fc8000020d400ULL,
0x00000001cece5812ULL, 0x000fe400078efcffULL, 0x000000decf00720bULL, 0x008fe20003fbd000ULL,
0x0000003100dd7306ULL, 0x000fe20000209400ULL, 0x000000e000cf7245ULL, 0x000fe4000020d400ULL,
0x000000db00db7245ULL, 0x002fe4000020d400ULL, 0x00000001cfcf3812ULL, 0x000fc600078efcffULL,
0x0000003100da7306ULL, 0x000e620000205400ULL, 0x000000e3e200720bULL, 0x004fc60003f7d000ULL,
0x00000001c0c05812ULL, 0x000fc800078efcffULL, 0x0000003000d17306ULL, 0x000fe20000209400ULL,
0x000000dfc0c0723eULL, 0x000fca00000010ffULL, 0x00000001dbdb3812ULL, 0x000fe400078efcffULL,
0x0000003000dc7306ULL, 0x000ea20000205400ULL, 0x000000dadd00720bULL, 0x002fce0003fdd000ULL,
0x0000003200c67306ULL, 0x000ff00000009400ULL, 0x0000003200b37306ULL, 0x000e620000005400ULL,
0x000000dcd100720bULL, 0x004fce0003fbd000ULL, 0x0000003200897306ULL, 0x0004f0000000d400ULL,
0x0000003900be7306ULL, 0x000fe20000009400ULL, 0x0001000038327824ULL, 0x004fe200078e00ffULL,
0x000000b3c600720bULL, 0x002fe20003f9d000ULL, 0x000100005fc67824ULL, 0x000fc600078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003900ad7306ULL, 0x000e620000005400ULL,
0x00000018ffc67819ULL, 0x000fcc00000114c6ULL, 0x0000000189894812ULL, 0x008fe200078efcffULL,
0x0000003300887306ULL, 0x000ea6000000d400ULL, 0x00000089cece723eULL, 0x000fca00000010ffULL,
0x000000bf00c17306ULL, 0x000fe20000209400ULL, 0x000000adbe00720bULL, 0x002fe40003f7d000ULL,
0x0000003100be7245ULL, 0x000fe4000020d400ULL, 0x0000003200ad7245ULL, 0x000fe4000020d400ULL,
0x00000001bebe6812ULL, 0x000fe200078efcffULL, 0x000000bf00c27306ULL, 0x000e620000205400ULL,
0x0000000188881812ULL, 0x004fc800078efcffULL, 0x00000088cfcf723eULL, 0x000fc600000010ffULL,
0x0000003200337306ULL, 0x000ff00000209400ULL, 0x0000003200d87306ULL, 0x000ea20000205400ULL,
0x000000c2c100720bULL, 0x002fe40003f3d000ULL, 0x000000bf00c27245ULL, 0x000fc4000020d400ULL,
0x0000003000bf7245ULL, 0x000fe4000020d400ULL, 0x0000b00066307811ULL, 0x000fe200078e20ffULL,
0x0000003800cc7306ULL, 0x000fe20000009400ULL, 0x00000001bfbf5812ULL, 0x000fca00078efcffULL,
0x00000001c2c21812ULL, 0x000fe400078efcffULL, 0x0000003800c97306ULL, 0x000e620000005400ULL,
0x000000d83300720bULL, 0x004fe40003fdd000ULL, 0x000000003030783bULL, 0x000fea0000000200ULL,
0x0000003800857306ULL, 0x000eac000000d400ULL, 0x00000001adad6812ULL, 0x000fc400078efcffULL,
0x000000d400d77306ULL, 0x000fe20000209400ULL, 0x000000c9cc00720bULL, 0x002fce0003f9d000ULL,
0x000000d400387306ULL, 0x0002ec0000205400ULL, 0x0000000185854812ULL, 0x004fe400078efcffULL,
0x0000003900867306ULL, 0x000522000000d400ULL, 0x000000d400d47245ULL, 0x002fe4000020d400ULL,
0x00000085bebe723eULL, 0x000fca00000010ffULL, 0x0000009400b47306ULL, 0x000fe20000209400ULL,
0x000001003b397824ULL, 0x004fe200078e00ffULL, 0x00000038d700720bULL, 0x008fe40003fbd000ULL,
0x0000b00065387811ULL, 0x000fe400078e20ffULL, 0x00000018ffaa7819ULL, 0x000fe40000011439ULL,
0x0000009400b77306ULL, 0x000e620000205400ULL, 0x0000000186863812ULL, 0x010fc800078efcffULL,
0x00000086bfbf723eULL, 0x000fe400000010ffULL, 0x00000001d4d45812ULL, 0x000fe200078efcffULL,
0x0000003b00bd7306ULL, 0x000ff00000009400ULL, 0x0000003b00b27306ULL, 0x000ea20000005400ULL,
0x000000b7b400720bULL, 0x002fc40003fdd000ULL, 0x00000002ffb77819ULL, 0x000fca000001162cULL,
0x0000003b007c7306ULL, 0x0002f0000000d400ULL, 0x0000003a00bc7306ULL, 0x000fe20000009400ULL,
0x000100003b3b7824ULL, 0x002fe200078e00ffULL, 0x000000b2bd00720bULL, 0x004fc40003f7d000ULL,
0x000000bb00b27245ULL, 0x000fe4000020d400ULL, 0x00000018ffaf7819ULL, 0x000fe2000001143bULL,
0x000001005c3b7824ULL, 0x000fe200078e00ffULL, 0x0000003a00b17306ULL, 0x000e680000005400ULL,
0x00000018ffb87819ULL, 0x000fe2000001143bULL, 0x000001005f3b7824ULL, 0x000fe400078e00ffULL,
0x000000017c7c3812ULL, 0x008fe200078efcffULL, 0x0000003a00827306ULL, 0x000eb0000000d400ULL,
0x000000bb00b57306ULL, 0x000fe20000209400ULL, 0x000000b1bc00720bULL, 0x002fc40003f9d000ULL,
0x0000009400b17245ULL, 0x000fc8000020d400ULL, 0x00000001b1b16812ULL, 0x000fe200078efcffULL,
0x000000bb00b67306ULL, 0x000e660000205400ULL, 0x000000d4b1b1723eULL, 0x000fc600000010ffULL,
0x0000000182824812ULL, 0x004fe400078efcffULL, 0x000000aa00397306ULL, 0x000ff00000209400ULL,
0x000000aa003a7306ULL, 0x000ea20000205400ULL, 0x000000b6b500720bULL, 0x002fc40003f3d000ULL,
0x00000018ffb57819ULL, 0x000fca000001143bULL, 0x0000009f00997306ULL, 0x000fec0000209400ULL,
0x00000001b2b21812ULL, 0x000fe400078efcffULL, 0x0000009f009e7306ULL, 0x0002e20000205400ULL,
0x0000003a3900720bULL, 0x004fe40003fbd000ULL, 0x000000003838783bULL, 0x000fea0000000200ULL,
0x0000005c00917306ULL, 0x000fe20000009400ULL, 0x0000009f009f7245ULL, 0x002fce000020d400ULL,
0x0000005c00a07306ULL, 0x000e620000005400ULL, 0x0000009e9900720bULL, 0x008fe40003fdd000ULL,
0x000000aa00997245ULL, 0x000fc8000020d400ULL, 0x0000000199995812ULL, 0x000fe200078efcffULL,
0x0000005c007b7306ULL, 0x0004ec000000d400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000af00ae7306ULL, 0x000fe20000209400ULL, 0x000100005e5c7824ULL, 0x004fe200078e00ffULL,
0x000000a09100720bULL, 0x002fc40003f7d000ULL, 0x000000ca00917245ULL, 0x000fe4000020d400ULL,
0x00000018ffb47819ULL, 0x000fe4000001145cULL, 0x000000af00b37306ULL, 0x0002a20000205400ULL,
0x00000010ff5c723eULL, 0x000fc800000010ffULL, 0x000054105c9e7816ULL, 0x000fe4000000005cULL,
0x000000017b7b3812ULL, 0x008fe200078efcffULL, 0x000000b800ba7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fe2000020d400ULL, 0x00001fb79eb77589ULL, 0x000e6800000e0000ULL,
0x00001f0a9e5c7589ULL, 0x000ee400000e0000ULL, 0x000000b800c57306ULL, 0x0009620000205400ULL,
0x000000b3ae00720bULL, 0x004fce0003fbd000ULL, 0x000000d300d97306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x010fca000020d400ULL, 0x00000001afaf5812ULL, 0x000fe400078efcffULL,
0x000000d300e67306ULL, 0x0005220000205400ULL, 0x000000c5ba00720bULL, 0x020fe20003fbd000ULL,
0x000000b73030a231ULL, 0x082fe400003400ffULL, 0x000000b73232a231ULL, 0x080fe400003400ffULL,
0x000000b73838a231ULL, 0x080fe400003400ffULL, 0x000000a400a57306ULL, 0x000fe20000209400ULL,
0x000000b73a3aa231ULL, 0x000fe200003400ffULL, 0x000000d300d37245ULL, 0x004fe2000020d400ULL,
0x0000005c3131a231ULL, 0x008fc400003400ffULL, 0x0000005c3333a231ULL, 0x080fe200003400ffULL,
0x00000001b8b85812ULL, 0x000fe200078efcffULL, 0x0000005c3939a231ULL, 0x080fe200003400ffULL,
0x000000a4009a7306ULL, 0x0002a20000205400ULL, 0x0000005c3b3ba231ULL, 0x000fe200003400ffULL,
0x000000e6d900720bULL, 0x010fe40003f5d000ULL, 0x000000a2b95c723eULL, 0x000fe200000010ffULL,
0x000000ce304c723cULL, 0x000fe6000004184cULL, 0x000000a900d57306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fc8000020d400ULL, 0x0000005c3054723cULL, 0x000fe40000041854ULL,
0x00000001d3d32812ULL, 0x000fe200078efcffULL, 0x000000a900d67306ULL, 0x0002e20000205400ULL,
0x0000009aa500720bULL, 0x004fc60003fbd000ULL, 0x000000b5005c7245ULL, 0x000fe2000020d400ULL,
0x000000be3044723cULL, 0x000fe60000041844ULL, 0x000000e400c17306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fca000020d400ULL, 0x00000001a4a45812ULL, 0x000fe400078efcffULL,
0x000000e400b67306ULL, 0x000e620000205400ULL, 0x000000d6d500720bULL, 0x008fe40003f3d000ULL,
0x000000969300720bULL, 0x000fe40003fbd000ULL, 0x0000008f00937245ULL, 0x000fc6000020d400ULL,
0x000000ac00ab7306ULL, 0x000fec0000209400ULL, 0x00000001a9a91812ULL, 0x000fe400078efcffULL,
0x000000ac00b07306ULL, 0x0004e20000205400ULL, 0x000000b6c100720bULL, 0x002fe40003f5d000ULL,
0x000000dbc2c1723eULL, 0x000fc400000010ffULL, 0x00000082a982723eULL, 0x000fe400000010ffULL,
0x000000016f6f5812ULL, 0x000fe200078efcffULL, 0x0000005e00907306ULL, 0x000fe20000009400ULL,
0x000000ac00ac7245ULL, 0x004fe2000020d400ULL, 0x000000c03048723cULL, 0x000fec0000041848ULL,
0x0000005e009b7306ULL, 0x000e620000005400ULL, 0x000000b0ab00720bULL, 0x008fc40003f3d000ULL,
0x000000adb2b0723eULL, 0x000fca00000010ffULL, 0x000000a700987306ULL, 0x000fe40000209400ULL,
0x000000b03040723cULL, 0x000fe80000041840ULL, 0x00000001acac1812ULL, 0x000fe400078efcffULL,
0x000000a700977306ULL, 0x000ea20000205400ULL, 0x0000009b9000720bULL, 0x002fe40003fdd000ULL,
0x000000a700907245ULL, 0x000fc4000020d400ULL, 0x00000092a100720bULL, 0x000fe40003f3d000ULL,
0x000000ac9fac723eULL, 0x000fe200000010ffULL, 0x000000b500bb7306ULL, 0x000ff00000209400ULL,
0x000000b500bc7306ULL, 0x0002e20000205400ULL, 0x000000979800720bULL, 0x004fc40003f9d000ULL,
0x0000000178781812ULL, 0x000fca00078efcffULL, 0x0000008f00a67306ULL, 0x000fe20000209400ULL,
0x000000c600b57245ULL, 0x002fca000020d400ULL, 0x0000000190904812ULL, 0x000fe400078efcffULL,
0x0000008f009d7306ULL, 0x0002a40000205400ULL, 0x000000af90ad723eULL, 0x000fe400000010ffULL,
0x0000007bb890723eULL, 0x000fc800000010ffULL, 0x0000005e00767306ULL, 0x000962000000d400ULL,
0x000000e4008f7245ULL, 0x002fe2000020d400ULL, 0x000000ac303c723cULL, 0x000fe6000004183cULL,
0x000000018f8f2812ULL, 0x000fe400078efcffULL, 0x000000bcbb00720bULL, 0x008fe20003f5d000ULL,
0x00000087008a7306ULL, 0x000fe20000209400ULL, 0x0000009da600720bULL, 0x004fe20003f3d000ULL,
0x00000100635e7824ULL, 0x010fca00078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001145eULL,
0x00000087008b7306ULL, 0x0002a20000205400ULL, 0x0000000176766812ULL, 0x020fe400078efcffULL,
0x00000081005e7245ULL, 0x000fe4000020d400ULL, 0x000000015c5c2812ULL, 0x000fe400078efcffULL,
0x0000000193931812ULL, 0x000fe200078efcffULL, 0x000000ca00cb7306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fce000020d400ULL, 0x000000ca00d27306ULL, 0x000e620000205400ULL,
0x0000008b8a00720bULL, 0x004fce0003fdd000ULL, 0x000000b400947306ULL, 0x000fec0000209400ULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x000000b400ab7306ULL, 0x0004e20000205400ULL,
0x000000d2cb00720bULL, 0x002fce0003f9d000ULL, 0x0000005f00a87306ULL, 0x000fe20000009400ULL,
0x000000b400b47245ULL, 0x004fca000020d400ULL, 0x0000000191914812ULL, 0x000fe400078efcffULL,
0x0000005f00957306ULL, 0x000e620000005400ULL, 0x000000ab9400720bULL, 0x008fe40003f5d000ULL,
0x000000789191723eULL, 0x000fca00000010ffULL, 0x0000008100847306ULL, 0x000fe40000209400ULL,
0x000000903854723cULL, 0x000fe80000041854ULL, 0x00000001b4b42812ULL, 0x000fe400078efcffULL,
0x0000008100837306ULL, 0x000ea20000205400ULL, 0x00000095a800720bULL, 0x002fe40003f7d000ULL,
0x000000b487b4723eULL, 0x000fca00000010ffULL, 0x000000e800c97306ULL, 0x000ff00000209400ULL,
0x000000e800cc7306ULL, 0x0002e20000205400ULL, 0x000000838400720bULL, 0x004fe40003f5d000ULL,
0x0000007c9983723eULL, 0x000fca00000010ffULL, 0x000000c8009b7306ULL, 0x000fe20000209400ULL,
0x000000e800e87245ULL, 0x002fe2000020d400ULL, 0x000000823034723cULL, 0x000fe80000041834ULL,
0x000000015e5e2812ULL, 0x000fe400078efcffULL, 0x000000c8009e7306ULL, 0x0002a20000205400ULL,
0x000000ccc900720bULL, 0x008fe40003f9d000ULL, 0x000000cd00c97245ULL, 0x000fca000020d400ULL,
0x0000005f00757306ULL, 0x000722000000d400ULL, 0x000000c800c87245ULL, 0x002fca000020d400ULL,
0x00000001e8e84812ULL, 0x000fe400078efcffULL, 0x00000062008d7306ULL, 0x000fe20000009400ULL,
0x0000009e9b00720bULL, 0x004fe20003fdd000ULL, 0x00000100625f7824ULL, 0x008fe200078e00ffULL,
0x000000e89393723eULL, 0x000fc800000010ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x00000062008c7306ULL, 0x000e620000005400ULL, 0x0000000175753812ULL, 0x010fca00078efcffULL,
0x00000001c8c86812ULL, 0x000fe400078efcffULL, 0x000000c600977306ULL, 0x000fe40000209400ULL,
0x0000006fc8c8723eULL, 0x000fcc00000010ffULL, 0x000000c600987306ULL, 0x000ea20000205400ULL,
0x0000008c8d00720bULL, 0x002fe40003f3d000ULL, 0x00000060c78d723eULL, 0x000fe400000010ffULL,
0x000000c3c48c723eULL, 0x000fc600000010ffULL, 0x0000006100a37306ULL, 0x000fe80000009400ULL,
0x0000008c3050723cULL, 0x000fe80000041850ULL, 0x00000061009c7306ULL, 0x000e620000005400ULL,
0x000000989700720bULL, 0x004fe40003f7d000ULL, 0x000000755c31723eULL, 0x000fc400000010ffULL,
0x000000768f30723eULL, 0x000fc600000010ffULL, 0x00000077007d7306ULL, 0x000fe80000209400ULL,
0x00000030384c723cULL, 0x000fe4000004184cULL, 0x00000001b5b53812ULL, 0x000fe400078efcffULL,
0x00000077007e7306ULL, 0x0004e20000205400ULL, 0x0000009ca300720bULL, 0x002fe40003f9d000ULL,
0x0000005f00307245ULL, 0x000fc4000020d400ULL, 0x0000008600317245ULL, 0x000fe4000020d400ULL,
0x000000b55eb5723eULL, 0x000fe200000010ffULL, 0x000000cd00927306ULL, 0x000fe20000209400ULL,
0x0000007700777245ULL, 0x004fca000020d400ULL, 0x000000b43848723cULL, 0x000fe40000041848ULL,
0x000000cd009d7306ULL, 0x000e620000205400ULL, 0x0000007e7d00720bULL, 0x008fce0003f5d000ULL,
0x00000061006e7306ULL, 0x0004ec000000d400ULL, 0x0000000177772812ULL, 0x000fe400078efcffULL,
0x0000006300807306ULL, 0x000fe20000009400ULL, 0x0001000061617824ULL, 0x004fe200078e00ffULL,
0x0000009d9200720bULL, 0x002fc40003fdd000ULL, 0x000000d3a492723eULL, 0x000fe400000010ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x00000063007f7306ULL, 0x000e620000005400ULL,
0x000000016e6e4812ULL, 0x008fe400078efcffULL, 0x0000006100d17245ULL, 0x000fe2000020d400ULL,
0x000000923850723cULL, 0x000fe60000041850ULL, 0x00000001c9c96812ULL, 0x000fe200078efcffULL,
0x00000070007a7306ULL, 0x000fe60000209400ULL, 0x0000006ec9c9723eULL, 0x000fca00000010ffULL,
0x0000007000797306ULL, 0x0004e20000205400ULL, 0x0000007f8000720bULL, 0x002fe20003f7d000ULL,
0x000000c83844723cULL, 0x000fec0000041844ULL, 0x000000d000957306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x004fce000020d400ULL, 0x000000d0008e7306ULL, 0x0002a20000205400ULL,
0x000000797a00720bULL, 0x008fce0003fbd000ULL, 0x00000061005d7306ULL, 0x000fe20000209400ULL,
0x000000d000d07245ULL, 0x002fca000020d400ULL, 0x0000000170705812ULL, 0x000fe400078efcffULL,
0x0000006100607306ULL, 0x000e620000205400ULL, 0x0000008e9500720bULL, 0x004fce0003fdd000ULL,
0x0000005f00857306ULL, 0x000fec0000209400ULL, 0x00000001d0d06812ULL, 0x000fe400078efcffULL,
0x0000005f00847306ULL, 0x000ea20000205400ULL, 0x000000605d00720bULL, 0x002fe40003f9d000ULL,
0x000000d077d0723eULL, 0x000fca00000010ffULL, 0x00000062006d7306ULL, 0x0002ec000000d400ULL,
0x00000001d1d14812ULL, 0x000fe400078efcffULL, 0x00000063006c7306ULL, 0x000962000000d400ULL,
0x0001000062627824ULL, 0x002fe200078e00ffULL, 0x000000848500720bULL, 0x004fc40003f5d000ULL,
0x000000d170d1723eULL, 0x000fe400000010ffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x00000086007f7306ULL, 0x000fe20000209400ULL, 0x0001000063637824ULL, 0x010fe200078e00ffULL,
0x000000016d6d1812ULL, 0x008fe200078efcffULL, 0x000000d03840723cULL, 0x000fe60000041840ULL,
0x00000018ff637819ULL, 0x000fc40000011463ULL, 0x00000086007c7306ULL, 0x000e620000205400ULL,
0x0000000130302812ULL, 0x000fe400078efcffULL, 0x000000016c6c3812ULL, 0x020fe400078efcffULL,
0x0000006d3030723eULL, 0x000fc600000010ffULL, 0x0000006a00737306ULL, 0x000ff00000209400ULL,
0x0000006a00747306ULL, 0x000ea20000205400ULL, 0x0000007c7f00720bULL, 0x002fce0003fbd000ULL,
0x0000006b00717306ULL, 0x000fec0000209400ULL, 0x0000000131315812ULL, 0x000fe400078efcffULL,
0x0000006b00727306ULL, 0x000e620000205400ULL, 0x000000747300720bULL, 0x004fe40003fdd000ULL,
0x0000006c3131723eULL, 0x000fca00000010ffULL, 0x0000006200797306ULL, 0x000fe40000209400ULL,
0x000000303834723cULL, 0x000fec0000041834ULL, 0x0000006200327306ULL, 0x0004e20000205400ULL,
0x000000727100720bULL, 0x002fce0003f9d000ULL, 0x0000006300337306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fce000020d400ULL, 0x00000063005c7306ULL, 0x0002a20000205400ULL,
0x000000327900720bULL, 0x008fe40003f5d000ULL, 0x0000006b00327245ULL, 0x000fc8000020d400ULL,
0x0000000132324812ULL, 0x000fe400078efcffULL, 0x0000006300637245ULL, 0x002fca000020d400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x0000005c3300720bULL, 0x004fe40003f3d000ULL,
0x0000006a00337245ULL, 0x000fc8000020d400ULL, 0x0000000133336812ULL, 0x000fc800078efcffULL,
0x000000623362723eULL, 0x000fc600000010ffULL, 0x0000000163631812ULL, 0x000fc800078efcffULL,
0x000000633263723eULL, 0x000fce00000010ffULL, 0x000000623838723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c064317811ULL, 0x000fe200078e40ffULL, 0x01063000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff23ff7812ULL, 0x000fe4000784c0ffULL, 0x000000315a00720cULL, 0x000fe40003f24070ULL,
0x00000001ff6a7807ULL, 0x000fd60001000000ULL, 0x00004b6000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2e7424ULL, 0x000fc800078e00ffULL, 0x0000002e00307305ULL, 0x0002a4000021f000ULL,
0x3fa000002e2e7823ULL, 0x002fe200000100ffULL, 0x000000300000735dULL, 0x004fe40003800000ULL,
0x01065c00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000124697824ULL, 0x000fe400078e0269ULL, 0x00000300ff247624ULL, 0x000fc600078e00ffULL,
0x00000001692e7812ULL, 0x000fe400078ec0ffULL, 0xffffffff24247811ULL, 0x000fe400078e08ffULL,
0x000000012e00780cULL, 0x000fe20003f25070ULL, 0xffffffffff2e7424ULL, 0x000fc600078e00ffULL,
0x0000000124587807ULL, 0x000fca0004800000ULL, 0x0000000169587824ULL, 0x000fe200078e0258ULL,
0x000000e064317811ULL, 0x000fc800078e40ffULL, 0x000000595800720cULL, 0x000fe40003f26070ULL,
0x000000315a247217ULL, 0x000fe40007800000ULL, 0x0000006068687810ULL, 0x000fc60007ffe0ffULL,
0x0000000124247824ULL, 0x000fe400078e0a31ULL, 0x00000100ff3d7424ULL, 0x000fc800078e00ffULL,
0x0000000158329824ULL, 0x000fe400078e0227ULL, 0x00000004ff339424ULL, 0x000fe200078e00ffULL,
0x0000002024247807ULL, 0x000fe20000000000ULL, 0x000000011f307824ULL, 0x000fe400078e0268ULL,
0x0000600032329625ULL, 0x000fe200078e0033ULL, 0x000000242d247217ULL, 0x000fc60007800000ULL,
0x000000011a1a7824ULL, 0x000fe200078e0268ULL, 0x00000006322e9981ULL, 0x000362000c1e1900ULL,
0x00005e0030307625ULL, 0x000fe200078e003dULL, 0x00000004ff5c7819ULL, 0x000fc6000001162cULL,
0x00000001241f7824ULL, 0x000fe200078e0a2dULL, 0x00000020303e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000118307824ULL, 0x100fe400078e0268ULL, 0x00000001173c7824ULL, 0x000fe200078e0268ULL,
0x0000001f2100720cULL, 0x000fe20003f26070ULL, 0x00005e001a327625ULL, 0x002fe200078e003dULL,
0x0000001f1c00720cULL, 0x000fc60003f66070ULL, 0x000000ffff3f7224ULL, 0x000fe200000e0631ULL,
0x0000002032327210ULL, 0x000fe20007f5e0ffULL, 0x00005e0030307625ULL, 0x000fe200078e003dULL,
0x0000001f5c00720cULL, 0x000fc60003f06070ULL, 0x00005e003c3c7625ULL, 0x000fe200078e003dULL,
0x0000002030307210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff337224ULL, 0x000fe200010e0633ULL,
0x0000001f1e00720cULL, 0x000fe20003f46070ULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000203c3c7210ULL, 0x000fc60007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e167faeULL, 0x0003e4000c101c46ULL, 0x000000ffff3d7224ULL, 0x000fe400028e063dULL,
0x0000000032157faeULL, 0x0003e8000c901c46ULL, 0x0000000030147faeULL, 0x0003e8000d101c46ULL,
0x000000003c137faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff137984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01063c00ff147984ULL, 0x000ea20000000800ULL, 0x8000000067167824ULL, 0x000fc400078e00ffULL,
0x8000000012157824ULL, 0x000fc600078e00ffULL, 0x8000000013ff7812ULL, 0x002fe40007804816ULL,
0x8000000014ff7812ULL, 0x004fe20007824815ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000012147824ULL, 0x000fe400078e00ffULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200137305ULL, 0x0002a4000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x000000130000735dULL, 0x004fe40003800000ULL,
0x01063c00ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fc40007824814ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0101800011137984ULL, 0x000e620000000800ULL, 0x00000001ff797424ULL, 0x000fc600078e00ffULL,
0x0103800011127984ULL, 0x0004e20000000800ULL, 0x0000002a1300720bULL, 0x002fda0003f3d000ULL,
0x0000000000147806ULL, 0x000fc800008e0100ULL, 0x0000ffff14167812ULL, 0x000fda000782c0ffULL,
0x0000034000009947ULL, 0x000fea0003800000ULL, 0x0000002a1300720bULL, 0x00cfe40003f34000ULL,
0x000000132a187209ULL, 0x000fe40007810000ULL, 0x00000002ff1a7819ULL, 0x000fc6000001162cULL,
0x800000182a147221ULL, 0x100fe20000010000ULL, 0x000000ffff2a7224ULL, 0x000fc600078e0018ULL,
0x3fb8aa3b14157820ULL, 0x000fe40000410000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x000000035b00780cULL, 0x000fe40003f25270ULL, 0x0000ffff14177812ULL, 0x000fe200078e3cffULL,
0x0000001500157308ULL, 0x000e660000000800ULL, 0x0000001716ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff797807ULL, 0x000fc60001000000ULL, 0x0105801811009388ULL, 0x000fec0000000800ULL,
0x8000001813162221ULL, 0x000fe20000010000ULL, 0x00001f1a15147589ULL, 0x002e6200000e0000ULL,
0x0000001529297220ULL, 0x000fe40000410000ULL, 0x3fb8aa3b16162820ULL, 0x000fe20000410000ULL,
0x00001f0a15137589ULL, 0x000ea600000e0000ULL, 0x0000001600102308ULL, 0x000ee40000000800ULL,
0x0000001210122220ULL, 0x008fe20000410000ULL, 0x0000001454547220ULL, 0x082fe20000410000ULL,
0x0000001455557220ULL, 0x080fe20000410000ULL, 0x0000001450507220ULL, 0x080fe20000410000ULL,
0x0000001451517220ULL, 0x080fe20000410000ULL, 0x000000144c4c7220ULL, 0x080fe20000410000ULL,
0x000000144d4d7220ULL, 0x080fe20000410000ULL, 0x0000001448487220ULL, 0x080fe20000410000ULL,
0x0000001449497220ULL, 0x080fe20000410000ULL, 0x0000001444447220ULL, 0x080fe20000410000ULL,
0x0000001445457220ULL, 0x080fe20000410000ULL, 0x0000001440407220ULL, 0x080fe20000410000ULL,
0x0000001441417220ULL, 0x080fe20000410000ULL, 0x0000001434347220ULL, 0x080fe20000410000ULL,
0x0000001435357220ULL, 0x080fe20000410000ULL, 0x0000001438387220ULL, 0x080fe20000410000ULL,
0x0000001439397220ULL, 0x000fe20000410000ULL, 0x0000001356567220ULL, 0x084fe20000410000ULL,
0x0000001357577220ULL, 0x080fe20000410000ULL, 0x0000001352527220ULL, 0x080fe20000410000ULL,
0x0000001353537220ULL, 0x080fe20000410000ULL, 0x000000134e4e7220ULL, 0x080fe20000410000ULL,
0x000000134f4f7220ULL, 0x080fe20000410000ULL, 0x000000134a4a7220ULL, 0x080fe20000410000ULL,
0x000000134b4b7220ULL, 0x080fe20000410000ULL, 0x0000001346467220ULL, 0x080fe20000410000ULL,
0x0000001347477220ULL, 0x080fe20000410000ULL, 0x0000001342427220ULL, 0x080fe20000410000ULL,
0x0000001343437220ULL, 0x080fe20000410000ULL, 0x0000001336367220ULL, 0x080fe20000410000ULL,
0x0000001337377220ULL, 0x080fe20000410000ULL, 0x000000133a3a7220ULL, 0x080fe20000410000ULL,
0x000000133b3b7220ULL, 0x000fe20000410000ULL, 0x0000002912297221ULL, 0x00cfe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x01064c00ff117984ULL, 0x000e620000000800ULL,
0x8000000067127824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x002fe20007804812ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff117424ULL, 0x000fe400078e00ffULL, 0x8000000067137824ULL, 0x000fe400078e00ffULL,
0x0000001100127305ULL, 0x0002a4000021f000ULL, 0x3fa0000011117823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x01064c00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fc40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000000f14783bULL, 0x000e620000004200ULL,
0x0000b8000b0b7811ULL, 0x000fe400078e20ffULL, 0x0000991079797816ULL, 0x000fe200000000ffULL,
0x000000000e30783bULL, 0x000ea20000004200ULL, 0x0000b80009097811ULL, 0x000fc600078e20ffULL,
0x000000000d3c783bULL, 0x000ee80000004200ULL, 0x000000000c5c783bULL, 0x000f220000004200ULL,
0x0000010014dd7824ULL, 0x042fe200078e00ffULL, 0x0000001400d07306ULL, 0x000fe20000009400ULL,
0x0000010015ca7824ULL, 0x040fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe20000011414ULL,
0x0001000014d87824ULL, 0x000fe200078e00ffULL, 0x00000018ffdd7819ULL, 0x000fe200000114ddULL,
0x0000010016bf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffca7819ULL, 0x000fe200000114caULL,
0x0001000015c57824ULL, 0x000fe200078e00ffULL, 0x000000dd00d27306ULL, 0x000fe20000209400ULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x0001000030b17824ULL, 0x004fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011415ULL, 0x0001000032c27824ULL, 0x040fe200078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0001000033c37824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe20000011417ULL, 0x000000dd00e57306ULL, 0x000e620000205400ULL,
0x00000018ffa27819ULL, 0x000fe20000011431ULL, 0x0001000017ae7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x0000010032b97824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe20000011416ULL, 0x0000010033b67824ULL, 0x000fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x000000ca00e07306ULL, 0x000fe20000209400ULL,
0x00000018ffc27819ULL, 0x000fe200000114c2ULL, 0x000001003de77824ULL, 0x048fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011432ULL, 0x000100003de47824ULL, 0x000fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fe20000011433ULL, 0x000100003ce67824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000000ca00e37306ULL, 0x0004e20000205400ULL,
0x000000e5d200720bULL, 0x002fe20003f1d000ULL, 0x0001000031b87824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x000001003ec77824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011430ULL, 0x000100003fce7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001143dULL, 0x0000001400cf7306ULL, 0x000e620000005400ULL,
0x000000ca00ca7245ULL, 0x004fc4000020d400ULL, 0x00000018ff807819ULL, 0x000fe4000001143cULL,
0x00000018ffb87819ULL, 0x000fe400000114b8ULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x0000001500da7306ULL, 0x000fe20000009400ULL, 0x000000e3e000720bULL, 0x008fe40003f9d000ULL,
0x00000018ffb67819ULL, 0x000fe400000114b6ULL, 0x00000018ffc77819ULL, 0x000fc400000114c7ULL,
0x00000018ffe47819ULL, 0x000fe200000114e4ULL, 0x0000001500d37306ULL, 0x000ea20000005400ULL,
0x000000cfd000720bULL, 0x002fe20003fbd000ULL, 0x000001005dcf7824ULL, 0x010fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe4000001143eULL, 0x00000018ff747819ULL, 0x000fe4000001143fULL,
0x00000001caca4812ULL, 0x000fe200078efcffULL, 0x000000cb00d77306ULL, 0x000fe20000209400ULL,
0x00000018ffce7819ULL, 0x000fc400000114ceULL, 0x00000018ff6a7819ULL, 0x000fe4000001145cULL,
0x00000018ff1f7819ULL, 0x000fe4000001145dULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x000000cb00d67306ULL, 0x0002e20000205400ULL, 0x000000d3da00720bULL, 0x004fe40003f3d000ULL,
0x000000dd00d37245ULL, 0x000fe4000020d400ULL, 0x00000018ff117819ULL, 0x000fc4000001145eULL,
0x00000001d3d30812ULL, 0x000fe200078efcffULL, 0x0000001700d47306ULL, 0x000fe20000009400ULL,
0x000000cb00cb7245ULL, 0x002fe4000020d400ULL, 0x00000018ff127819ULL, 0x000fca000001145fULL,
0x0000001700d57306ULL, 0x000e620000005400ULL, 0x000000d6d700720bULL, 0x008fe40003f5d000ULL,
0x00000018ffd67819ULL, 0x000fca00000114e7ULL, 0x0000003000ab7306ULL, 0x000fec0000009400ULL,
0x00000001cbcb2812ULL, 0x000fe400078efcffULL, 0x0000003000ac7306ULL, 0x000ea20000005400ULL,
0x000000d5d400720bULL, 0x002fe40003f1d000ULL, 0x000000d800d47245ULL, 0x000fc4000020d400ULL,
0x000000c500d57245ULL, 0x000fc6000020d400ULL, 0x000000d800e27306ULL, 0x000ff00000209400ULL,
0x000000d800e17306ULL, 0x000e620000205400ULL, 0x000000acab00720bULL, 0x004fe40003f9d000ULL,
0x00000018ffab7819ULL, 0x000fca00000114e6ULL, 0x00000014007c7306ULL, 0x0004f0000000d400ULL,
0x0000009400cc7306ULL, 0x000fe20000209400ULL, 0x0000010017147824ULL, 0x004fe200078e00ffULL,
0x000000e1e200720bULL, 0x002fc80003f7d000ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000009400cd7306ULL, 0x0002a20000205400ULL, 0x000000017c7c5812ULL, 0x008fc800078efcffULL,
0x0000007cd37c723eULL, 0x000fe400000010ffULL, 0x00000001d4d43812ULL, 0x000fe200078efcffULL,
0x0000001600d97306ULL, 0x000fe20000009400ULL, 0x0000009400947245ULL, 0x002fe4000020d400ULL,
0x000000d4cbd4723eULL, 0x000fca00000010ffULL, 0x0000001600dc7306ULL, 0x000e620000005400ULL,
0x000000cdcc00720bULL, 0x004fce0003fbd000ULL, 0x00000017000d7306ULL, 0x0004ec000000d400ULL,
0x0000000194945812ULL, 0x000fe400078efcffULL, 0x0000003000757306ULL, 0x000922000000d400ULL,
0x000000dcd900720bULL, 0x002fe20003fdd000ULL, 0x0000010030177824ULL, 0x004fca00078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x000000bf00c97306ULL, 0x000fe20000209400ULL,
0x000000010d0d0812ULL, 0x008fe200078efcffULL, 0x000001003c307824ULL, 0x010fca00078e00ffULL,
0x00000018ffd07819ULL, 0x000fe20000011430ULL, 0x000000bf00c67306ULL, 0x0002a20000205400ULL,
0x0000000175754812ULL, 0x000fe200078efcffULL, 0x000001005f307824ULL, 0x000fcc00078e00ffULL,
0x0000008f008a7306ULL, 0x000fe20000209400ULL, 0x000000bf00bf7245ULL, 0x002fce000020d400ULL,
0x0000008f00977306ULL, 0x0002e20000205400ULL, 0x000000c6c900720bULL, 0x004fce0003f5d000ULL,
0x000000a200a37306ULL, 0x000fe20000209400ULL, 0x0000008f008f7245ULL, 0x002fca000020d400ULL,
0x00000001bfbf2812ULL, 0x000fe400078efcffULL, 0x000000a200a67306ULL, 0x000e620000205400ULL,
0x000000978a00720bULL, 0x008fce0003f1d000ULL, 0x000000c500db7306ULL, 0x000fec0000209400ULL,
0x000000018f8f0812ULL, 0x000fe400078efcffULL, 0x000000c500de7306ULL, 0x000ea20000205400ULL,
0x000000a6a300720bULL, 0x002fce0003f9d000ULL, 0x00000015007d7306ULL, 0x0002f0000000d400ULL,
0x000000a700a97306ULL, 0x000fe20000209400ULL, 0x0001000016157824ULL, 0x002fe200078e00ffULL,
0x000000dedb00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x000000a700aa7306ULL, 0x0002a20000205400ULL, 0x000000017d7d1812ULL, 0x008fc800078efcffULL,
0x0000007dca7d723eULL, 0x000fe400000010ffULL, 0x00000001d5d53812ULL, 0x000fe200078efcffULL,
0x00000016000e7306ULL, 0x000722000000d400ULL, 0x000000a700a77245ULL, 0x002fe4000020d400ULL,
0x000000d594d5723eULL, 0x000fca00000010ffULL, 0x00000032008e7306ULL, 0x000fe20000009400ULL,
0x0000010031167824ULL, 0x008fe200078e00ffULL, 0x000000aaa900720bULL, 0x004fc80003fbd000ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000032009d7306ULL, 0x000e620000005400ULL,
0x000000010e0e6812ULL, 0x010fe400078efcffULL, 0x00000016008a7245ULL, 0x000fc8000020d400ULL,
0x00000001a7a75812ULL, 0x000fe200078efcffULL, 0x0000001400c87306ULL, 0x000ff00000209400ULL,
0x0000001400df7306ULL, 0x000ea20000205400ULL, 0x0000009d8e00720bULL, 0x002fc40003fdd000ULL,
0x00000015008e7245ULL, 0x000fca000020d400ULL, 0x0000003200707306ULL, 0x000e70000000d400ULL,
0x0000003300a87306ULL, 0x000fe20000009400ULL, 0x000000dfc800720bULL, 0x004fce0003f3d000ULL,
0x00000033008d7306ULL, 0x000fe20000005400ULL, 0x0000000170706812ULL, 0x002fce00078efcffULL,
0x00000033006f7306ULL, 0x000ff0000000d400ULL, 0x0000001500bd7306ULL, 0x000ff00000209400ULL,
0x0000001500c47306ULL, 0x000e700000205400ULL, 0x000000b100b27306ULL, 0x000ff00000209400ULL,
0x000000b100b57306ULL, 0x0004e20000205400ULL, 0x000000c4bd00720bULL, 0x002fce0003f5d000ULL,
0x000000c200327306ULL, 0x000fe20000209400ULL, 0x000000b100b17245ULL, 0x004fca000020d400ULL,
0x000000018e8e2812ULL, 0x000fe400078efcffULL, 0x000000c200337306ULL, 0x0003e20000205400ULL,
0x000000b5b200720bULL, 0x008fe40003f1d000ULL, 0x0000008ea78e723eULL, 0x000fca00000010ffULL,
0x0000003100887306ULL, 0x000fe20000009400ULL, 0x000000c200c27245ULL, 0x002fca000020d400ULL,
0x00000001b1b10812ULL, 0x000fe400078efcffULL, 0x00000031009b7306ULL, 0x000e700000005400ULL,
0x0000001600ad7306ULL, 0x000ff00000209400ULL, 0x0000001600b47306ULL, 0x000ea20000205400ULL,
0x0000009b8800720bULL, 0x002fc40003f7d000ULL, 0x0000001400887245ULL, 0x000fc8000020d400ULL,
0x0000000188881812ULL, 0x000fe200078efcffULL, 0x0000003d00a07306ULL, 0x000ff00000009400ULL,
0x0000003d00897306ULL, 0x000fe20000005400ULL, 0x000000b4ad00720bULL, 0x004fce0003fbd000ULL,
0x0000003d006b7306ULL, 0x0003ec000000d400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x0000003c00a47306ULL, 0x000fe20000009400ULL, 0x000001003f3d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff977819ULL, 0x000fe4000001143dULL, 0x0000003c008b7306ULL, 0x000e620000005400ULL,
0x000000a2003d7245ULL, 0x000fc8000020d400ULL, 0x000000013d3d4812ULL, 0x000fe400078efcffULL,
0x000000333200720bULL, 0x000fe20003f9d000ULL, 0x0000003c006c7306ULL, 0x000eb0000000d400ULL,
0x000000c3003c7306ULL, 0x000fe20000209400ULL, 0x0000008ba400720bULL, 0x002fc40003f1d000ULL,
0x000000d0008b7245ULL, 0x000fe4000020d400ULL, 0x00000001c2c24812ULL, 0x000fc600078efcffULL,
0x000000c300d17306ULL, 0x0002ec0000205400ULL, 0x000000016c6c0812ULL, 0x004fe400078efcffULL,
0x000000ae00c07306ULL, 0x000fe20000209400ULL, 0x000000c300c37245ULL, 0x002fce000020d400ULL,
0x000000ae00b37306ULL, 0x0002a20000205400ULL, 0x000000d13c00720bULL, 0x008fce0003fdd000ULL,
0x0000001700af7306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x00000001c3c36812ULL, 0x000fe400078efcffULL, 0x0000001700b07306ULL, 0x000e620000205400ULL,
0x000000b3c000720bULL, 0x004fce0003f3d000ULL, 0x000000d000d27306ULL, 0x000fec0000209400ULL,
0x00000001aeae1812ULL, 0x000fe400078efcffULL, 0x000000d000d97306ULL, 0x000ea20000205400ULL,
0x000000b0af00720bULL, 0x002fe40003f5d000ULL, 0x0000008da800720bULL, 0x000fc40003f3d000ULL,
0x0000001700a87245ULL, 0x000fe4000020d400ULL, 0x000000000b14783bULL, 0x0003e20000000200ULL,
0x000000b800bb7306ULL, 0x000fe20000209400ULL, 0x000000ae8f8f723eULL, 0x000fca00000010ffULL,
0x00000001a8a82812ULL, 0x000fe400078efcffULL, 0x000000b800be7306ULL, 0x0007220000205400ULL,
0x000000d9d200720bULL, 0x004fe40003f9d000ULL, 0x000000e4000b7245ULL, 0x002fe4000020d400ULL,
0x000000016f6f1812ULL, 0x000fe400078efcffULL, 0x00000075a8a8723eULL, 0x000fe200000010ffULL,
0x0000003100737306ULL, 0x0002a2000000d400ULL, 0x000000b800b87245ULL, 0x008fca000020d400ULL,
0x000000018b8b4812ULL, 0x000fe400078efcffULL, 0x000000b900bc7306ULL, 0x000fe20000209400ULL,
0x000000bebb00720bULL, 0x010fe20003fbd000ULL, 0x000001005e317824ULL, 0x002fe200078e00ffULL,
0x0000006c8b6c723eULL, 0x000fc800000010ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x000000b900b77306ULL, 0x0002e20000205400ULL, 0x0000000173733812ULL, 0x004fc800078efcffULL,
0x000000738aa9723eULL, 0x000fe400000010ffULL, 0x00000001b8b85812ULL, 0x000fe200078efcffULL,
0x000000d600d77306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fe4000020d400ULL,
0x00000089a000720bULL, 0x000fe40003fbd000ULL, 0x0000009a00897245ULL, 0x000fe4000020d400ULL,
0x000000b83d3d723eULL, 0x000fe200000010ffULL, 0x000000d600c67306ULL, 0x0002a20000205400ULL,
0x000000b7bc00720bULL, 0x008fce0003f7d000ULL, 0x0000009300a57306ULL, 0x000fe20000209400ULL,
0x000000d600d67245ULL, 0x002fe4000020d400ULL, 0x000000016b6b5812ULL, 0x000fc600078efcffULL,
0x00000001b9b93812ULL, 0x000fe400078efcffULL, 0x00000093008c7306ULL, 0x000e620000205400ULL,
0x000000c6d700720bULL, 0x004fe40003fdd000ULL, 0x00000070b970723eULL, 0x000fca00000010ffULL,
0x0000008000847306ULL, 0x000fec0000209400ULL, 0x00000001d6d66812ULL, 0x000fe400078efcffULL,
0x0000008000837306ULL, 0x0004e20000205400ULL, 0x0000008ca500720bULL, 0x002fe40003f5d000ULL,
0x00000093008c7245ULL, 0x000fca000020d400ULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x004fca000020d400ULL, 0x000000018c8c2812ULL, 0x000fe400078efcffULL,
0x000000ab009b7306ULL, 0x0002a20000205400ULL, 0x000000838400720bULL, 0x008fce0003f1d000ULL,
0x0000009a009e7306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x0000000180800812ULL, 0x000fe400078efcffULL, 0x0000009a00a17306ULL, 0x000e620000205400ULL,
0x0000009bac00720bULL, 0x004fce0003f9d000ULL, 0x0000007f00857306ULL, 0x000fec0000209400ULL,
0x00000001abab4812ULL, 0x000fe400078efcffULL, 0x0000007f00867306ULL, 0x000ea20000205400ULL,
0x000000a19e00720bULL, 0x002fe40003f7d000ULL, 0x000000ab8080723eULL, 0x000fca00000010ffULL,
0x000000b600ba7306ULL, 0x000fec0000209400ULL, 0x0000000189893812ULL, 0x000fe400078efcffULL,
0x000000b600c17306ULL, 0x0002e20000205400ULL, 0x000000868500720bULL, 0x004fe40003fdd000ULL,
0x000000c289c2723eULL, 0x000fca00000010ffULL, 0x0000005d007e7306ULL, 0x000fe20000009400ULL,
0x000000b600b67245ULL, 0x002fce000020d400ULL, 0x0000005d00817306ULL, 0x000e620000005400ULL,
0x000000c1ba00720bULL, 0x008fce0003f5d000ULL, 0x000000c7008d7306ULL, 0x000fec0000209400ULL,
0x00000001b6b62812ULL, 0x000fe400078efcffULL, 0x000000c700a67306ULL, 0x0004e20000205400ULL,
0x000000817e00720bULL, 0x002fe40003f1d000ULL, 0x0000007f007e7245ULL, 0x000fc8000020d400ULL,
0x000000017e7e6812ULL, 0x000fe200078efcffULL, 0x0000003f00987306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x004fce000020d400ULL, 0x0000003f00917306ULL, 0x000e620000005400ULL,
0x000000a68d00720bULL, 0x008fce0003f9d000ULL, 0x0000009700a37306ULL, 0x000fec0000209400ULL,
0x00000001c7c74812ULL, 0x000fe400078efcffULL, 0x0000009700a07306ULL, 0x000ea20000205400ULL,
0x000000919800720bULL, 0x002fce0003f7d000ULL, 0x000000e4009d7306ULL, 0x000ff00000209400ULL,
0x000000e400aa7306ULL, 0x000e620000205400ULL, 0x000000a0a300720bULL, 0x004fce0003fdd000ULL,
0x0000003e009c7306ULL, 0x000ff00000009400ULL, 0x0000003e00957306ULL, 0x000ea20000005400ULL,
0x000000aa9d00720bULL, 0x002fce0003fbd000ULL, 0x0000003e00687306ULL, 0x0003ec000000d400ULL,
0x000000010b0b5812ULL, 0x000fe400078efcffULL, 0x0000003f00697306ULL, 0x000722000000d400ULL,
0x000100003e3e7824ULL, 0x002fe200078e00ffULL, 0x000000959c00720bULL, 0x004fc40003f5d000ULL,
0x000000ff7900720cULL, 0x000fe40003fa5270ULL, 0x00000018ff337819ULL, 0x000fe4000001143eULL,
0x0000005e00877306ULL, 0x000fe20000009400ULL, 0x000001005c3f7824ULL, 0x008fe200078e00ffULL,
0x00000010ff3e723eULL, 0x000fc800000010ffULL, 0x00000018ff837819ULL, 0x000fe4000001143fULL,
0x0000005e00827306ULL, 0x000e620000005400ULL, 0x00000002ff3f7819ULL, 0x000fe4000001162cULL,
0x000054103e8d7816ULL, 0x000fe4000000003eULL, 0x0000000169693812ULL, 0x010fe400078efcffULL,
0x0000000168682812ULL, 0x000fe200078efcffULL, 0x00000078000f7306ULL, 0x000fe20000209400ULL,
0x00001f3f8d3f7589ULL, 0x000ea400000e0000ULL, 0x00000068c768723eULL, 0x000fc400000010ffULL,
0x00001f0a8d3e7589ULL, 0x000ee600000e0000ULL, 0x00000078000c7306ULL, 0x000f220000205400ULL,
0x000000828700720bULL, 0x002fe40003f9d000ULL, 0x0000009700827245ULL, 0x000fc8000020d400ULL,
0x0000000182826812ULL, 0x000fe200078efcffULL, 0x0000003300327306ULL, 0x000fe60000209400ULL,
0x000000698269723eULL, 0x000fca00000010ffULL, 0x0000003300937306ULL, 0x000e620000205400ULL,
0x0000000c0f00720bULL, 0x010fe20003f7d000ULL, 0x0000003f1414d231ULL, 0x084fe400003400ffULL,
0x0000003f1616d231ULL, 0x000fe400003400ffULL, 0x0000003e1515d231ULL, 0x088fe400003400ffULL,
0x00000096009f7306ULL, 0x000fe20000209400ULL, 0x0000003e1717d231ULL, 0x000fce00003400ffULL,
0x0000009600927306ULL, 0x0004e20000205400ULL, 0x000000933200720bULL, 0x002fe20003fdd000ULL,
0x0000007c1454723cULL, 0x000fe20000041854ULL, 0x0000000ebf32723eULL, 0x000fca00000010ffULL,
0x0000005f007a7306ULL, 0x000fe20000009400ULL, 0x0000009600967245ULL, 0x004fe2000020d400ULL,
0x000000d41450723cULL, 0x040fec0000041850ULL, 0x0000005f007b7306ULL, 0x000e620000005400ULL,
0x000000929f00720bULL, 0x008fe20003f3d000ULL, 0x0000008e1448723cULL, 0x040fec0000041848ULL,
0x0000007400767306ULL, 0x000fe40000209400ULL, 0x000000a81444723cULL, 0x000fe80000041844ULL,
0x0000000196961812ULL, 0x000fc400078efcffULL, 0x0000007400777306ULL, 0x000fe20000205400ULL,
0x0000007b7a00720bULL, 0x002fe40003f5d000ULL, 0x000000c396c3723eULL, 0x000fca00000010ffULL,
0x000000ce003c7306ULL, 0x000ff00000209400ULL, 0x000000ce00917306ULL, 0x0003f00000205400ULL,
0x0000005c00907306ULL, 0x000fe20000009400ULL, 0x000000ce00ce7245ULL, 0x002fce000020d400ULL,
0x0000005c00997306ULL, 0x000e700000005400ULL, 0x0000005c00607306ULL, 0x0004f0000000d400ULL,
0x0000005d001a7306ULL, 0x0008e2000000d400ULL, 0x000100005c5c7824ULL, 0x004fe200078e00ffULL,
0x000000999000720bULL, 0x002fc80003f3d000ULL, 0x00000018ff797819ULL, 0x000fe4000001145cULL,
0x00000033005c7245ULL, 0x000fe2000020d400ULL, 0x000100005d5d7824ULL, 0x010fe200078e00ffULL,
0x0000006a00727306ULL, 0x000fe20000209400ULL, 0x0000000d8833723eULL, 0x000fe400000010ffULL,
0x000000015c5c6812ULL, 0x000fe200078efcffULL, 0x00000000090c783bULL, 0x0002a20000000200ULL,
0x00000018ff7b7819ULL, 0x000fe4000001145dULL, 0x00000078005d7245ULL, 0x000fe2000020d400ULL,
0x0000006a00717306ULL, 0x0009220000205400ULL, 0x000000913c00720bULL, 0x000fe20003fdd000ULL,
0x00000032144c723cULL, 0x000fe2000004184cULL, 0x000000015d5d3812ULL, 0x000fc400078efcffULL,
0x000000777600720bULL, 0x000fe40003f7d000ULL, 0x0000007400097245ULL, 0x002fe2000020d400ULL,
0x0000008300847306ULL, 0x000fe20000209400ULL, 0x0000000160601812ULL, 0x008fe400078efcffULL,
0x000000b18c3c723eULL, 0x000fe400000010ffULL, 0x0000006a006a7245ULL, 0x010fe4000020d400ULL,
0x00000001cece6812ULL, 0x000fe200078efcffULL, 0x0000008300857306ULL, 0x0002e20000205400ULL,
0x000000011a1a0812ULL, 0x000fe200078efcffULL, 0x0000003c1440723cULL, 0x000fe20000041840ULL,
0x0000000109093812ULL, 0x000fc400078efcffULL, 0x000000717200720bULL, 0x000fe40003f7d000ULL,
0x0000006fb671723eULL, 0x000fe200000010ffULL, 0x000000cf00867306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x002fe4000020d400ULL, 0x00000018ff727819ULL, 0x000fe40000011430ULL,
0x0000001f00307245ULL, 0x000fe2000020d400ULL, 0x000000701434723cULL, 0x000fe20000041834ULL,
0x0000005c5d5c723eULL, 0x000fe200000010ffULL, 0x000000cf00817306ULL, 0x0003220000205400ULL,
0x000000858400720bULL, 0x008fc40003fdd000ULL, 0x000000016a6a3812ULL, 0x000fe200078efcffULL,
0x0000003f0c0cd231ULL, 0x084fe200003400ffULL, 0x000000ce095d723eULL, 0x000fe200000010ffULL,
0x000000c21414723cULL, 0x000fe20000041838ULL, 0x0000003f0e0ed231ULL, 0x000fe200003400ffULL,
0x0000007b007c7306ULL, 0x000fe20000209400ULL, 0x000000cf00cf7245ULL, 0x002fe2000020d400ULL,
0x0000003e0d0dd231ULL, 0x080fe400003400ffULL, 0x0000003e0f0fd231ULL, 0x000fe400003400ffULL,
0x0000000183836812ULL, 0x000fc400078efcffULL, 0x0000007b007d7306ULL, 0x000e620000205400ULL,
0x000000818600720bULL, 0x010fe40003f3d000ULL, 0x0000000b7e81723eULL, 0x000fe200000010ffULL,
0x000000680c4c723cULL, 0x000fe2000004184cULL, 0x000000608360723eULL, 0x000fc600000010ffULL,
0x0000001f006e7306ULL, 0x000fe80000209400ULL, 0x000000800c50723cULL, 0x000fe40000041850ULL,
0x00000001cfcf1812ULL, 0x000fe400078efcffULL, 0x0000001f006d7306ULL, 0x000ea20000205400ULL,
0x0000007d7c00720bULL, 0x002fc60003f1d000ULL, 0x0000005c0c48723cULL, 0x000fe80000041848ULL,
0x0000003100327306ULL, 0x000ff00000209400ULL, 0x0000003100337306ULL, 0x000e620000205400ULL,
0x0000006d6e00720bULL, 0x004fc40003fdd000ULL, 0x0000006bd66d723eULL, 0x000fe400000010ffULL,
0x0000007b006b7245ULL, 0x000fc6000020d400ULL, 0x00000079007f7306ULL, 0x000fe20000209400ULL,
0x000000016b6b0812ULL, 0x000fe200078efcffULL, 0x0000006c0c54723cULL, 0x000fe80000041854ULL,
0x0000000130306812ULL, 0x000fe400078efcffULL, 0x00000079007a7306ULL, 0x0004e20000205400ULL,
0x000000333200720bULL, 0x002fe40003f7d000ULL, 0x0000006b306b723eULL, 0x000fca00000010ffULL,
0x0000005e00137306ULL, 0x000322000000d400ULL, 0x0000007900797245ULL, 0x004fce000020d400ULL,
0x0000005f00187306ULL, 0x000522000000d400ULL, 0x000100005e5e7824ULL, 0x002fe200078e00ffULL,
0x0000007a7f00720bULL, 0x008fc80003f3d000ULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000001200247306ULL, 0x000fe20000209400ULL, 0x000100005f5f7824ULL, 0x004fe200078e00ffULL,
0x0000000113134812ULL, 0x010fc800078efcffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000001200617306ULL, 0x0002a20000205400ULL, 0x0000000179791812ULL, 0x000fe400078efcffULL,
0x0000000118182812ULL, 0x000fe400078efcffULL, 0x000000796a6a723eULL, 0x000fc600000010ffULL,
0x0000001100637306ULL, 0x000fe20000209400ULL, 0x0000001200127245ULL, 0x002fc6000020d400ULL,
0x0000006a0c40723cULL, 0x000fe80000041840ULL, 0x0000001100627306ULL, 0x0002e20000205400ULL,
0x000000612400720bULL, 0x004fe40003f1d000ULL, 0x0000003100247245ULL, 0x000fe4000020d400ULL,
0x0000007200317245ULL, 0x000fe4000020d400ULL, 0x0000000124243812ULL, 0x000fe200078efcffULL,
0x00000072006f7306ULL, 0x000fe20000209400ULL, 0x0000001100117245ULL, 0x002fc4000020d400ULL,
0x0000001acf61723eULL, 0x000fe400000010ffULL, 0x000000132430723eULL, 0x000fe400000010ffULL,
0x0000000112120812ULL, 0x000fe200078efcffULL, 0x00000072006e7306ULL, 0x000e620000205400ULL,
0x000000626300720bULL, 0x008fe20003f3d000ULL, 0x000000600c44723cULL, 0x000fec0000041844ULL,
0x0000005e003c7306ULL, 0x000fec0000209400ULL, 0x0000000111111812ULL, 0x000fc400078efcffULL,
0x0000005e00397306ULL, 0x0004e20000205400ULL, 0x0000006e6f00720bULL, 0x002fce0003fdd000ULL,
0x0000005f000b7306ULL, 0x000fe20000209400ULL, 0x0000005e005e7245ULL, 0x004fca000020d400ULL,
0x0000000131316812ULL, 0x000fe400078efcffULL, 0x0000005f00327306ULL, 0x0002a20000205400ULL,
0x000000393c00720bULL, 0x008fe40003f7d000ULL, 0x000000183131723eULL, 0x000fe400000010ffULL,
0x0000005f005f7245ULL, 0x002fca000020d400ULL, 0x000000300c34723cULL, 0x000fe80000041834ULL,
0x000000015e5e3812ULL, 0x000fe400078efcffULL, 0x000000320b00720bULL, 0x004fe40003f9d000ULL,
0x0000005e115e723eULL, 0x000fd600000010ffULL, 0x000000015f5f4812ULL, 0x000fc800078efcffULL,
0x0000005f125f723eULL, 0x000fce00000010ffULL, 0x0000005e0c14723cULL, 0x000fe20000041814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x01065c00ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff097424ULL, 0x000fc800078e00ffULL, 0x00000009000b7305ULL, 0x0002a4000021f000ULL,
0x3fa0000009097823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x01065c00ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000030064097a10ULL, 0x000fe20007ffe0ffULL, 0x000000042e1a7c24ULL, 0x020fe2000f8e022bULL,
0x00000004ff187819ULL, 0x000fc4000001162cULL, 0x00000001090c7810ULL, 0x040fe20007ffe0ffULL,
0x00000100090b7824ULL, 0x000fc600078e00ffULL, 0x0000002f0c00720cULL, 0x000fe40003f06070ULL,
0x0000000b5a0e7217ULL, 0x000fe40007800000ULL, 0x0000007f1a0c7812ULL, 0x040fe400078ef822ULL,
0x0000007f1a227812ULL, 0x000fe200078ef81dULL, 0x000000010e0e7824ULL, 0x000fe400078e0a0bULL,
0x00000100ff0b7424ULL, 0x000fc600078e00ffULL, 0x000000200e0e7807ULL, 0x000fe20000000000ULL,
0x00005e000c0c7625ULL, 0x000fc600078e000bULL, 0x0000000e2d127217ULL, 0x000fe20007800000ULL,
0x00005e00220e7625ULL, 0x000fe200078e000bULL, 0x000000200c0c7210ULL, 0x000fc60007f1e0ffULL,
0x0000000112097824ULL, 0x000fe200078e0a2dULL, 0x0000007f1a127812ULL, 0x040fe200078ef81bULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000007f1a1a7812ULL, 0x000fe400078ef819ULL,
0x000000200e0e7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0012127625ULL, 0x000fe200078e000bULL,
0x000000091800720cULL, 0x080fe40003f26070ULL, 0x000000092100720cULL, 0x000fe20003f06070ULL,
0x00005e001a187625ULL, 0x000fe200078e000bULL, 0x000000091c00720cULL, 0x000fc40003f66070ULL,
0x0000002012127210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x000000091e00720cULL, 0x000fe40003f46070ULL, 0x0000002018207210ULL, 0x000fe20007fde0ffULL,
0x000000ffff137224ULL, 0x000fe400020e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c087faeULL, 0x0003e4000c901c46ULL, 0x000000ffff217224ULL, 0x000fe400030e0619ULL,
0x000000000e077faeULL, 0x0003e8000c101c46ULL, 0x0000000012067faeULL, 0x0003e8000d101c46ULL,
0x0000000020057faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff057984ULL, 0x002e620000000800ULL, 0x8000000067067824ULL, 0x000fca00078e00ffULL,
0x8000000005ff7812ULL, 0x002fe20007804806ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01065400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804806ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000067677824ULL, 0x000fe400078e00ffULL,
0x3e000000ff057424ULL, 0x000fc800078e00ffULL, 0x0000000500067305ULL, 0x0002a4000021f000ULL,
0x3fa0000005057823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01065400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000000404783bULL, 0x000e680000004200ULL, 0x00000000030c783bULL, 0x000ea80000004200ULL,
0x000000000218783bULL, 0x000ee80000004200ULL, 0x00000000001c783bULL, 0x000f220000004200ULL,
0x0000000400a67306ULL, 0x002fe20000009400ULL, 0x00000018ffb97819ULL, 0x000fe20000011404ULL,
0x0000010004917824ULL, 0x000fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe20000011405ULL,
0x0000010007af7824ULL, 0x040fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011406ULL,
0x0001000006ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe20000011407ULL,
0x0000000400b17306ULL, 0x000e620000005400ULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0001000007a77824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x000100000ca87824ULL, 0x004fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe20000011491ULL,
0x000001000e957824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x0000000400717306ULL, 0x000562000000d400ULL, 0x00000018ff387819ULL, 0x000fe2000001140cULL,
0x000100000da07824ULL, 0x000fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x000001000f917824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001140dULL,
0x0001000018d17824ULL, 0x008fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011495ULL,
0x0000000500bc7306ULL, 0x000fe20000009400ULL, 0x0001000004047824ULL, 0x004fe200078e00ffULL,
0x000000b1a600720bULL, 0x002fe20003fdd000ULL, 0x0000010019d37824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x000001001bd67824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe20000011404ULL, 0x0000010005047824ULL, 0x000fe200078e00ffULL,
0x0000000500bd7306ULL, 0x000e620000005400ULL, 0x00000018ff7e7819ULL, 0x000fe2000001140eULL,
0x000001001ad57824ULL, 0x040fe200078e00ffULL, 0x000000b600b17245ULL, 0x000fe2000020d400ULL,
0x000100001aa57824ULL, 0x000fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe20000011404ULL,
0x0000010006047824ULL, 0x000fe200078e00ffULL, 0x0000000171716812ULL, 0x020fe200078efcffULL,
0x000000b600b77306ULL, 0x000fe20000209400ULL, 0x00000018ff727819ULL, 0x000fe20000011418ULL,
0x000100001ba47824ULL, 0x000fe200078e00ffULL, 0x00000018ffc67819ULL, 0x000fe20000011404ULL,
0x000001000c047824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe2000001140fULL,
0x0001000019d47824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011491ULL,
0x000000b600b87306ULL, 0x0004e20000205400ULL, 0x000000bdbc00720bULL, 0x002fc40003f5d000ULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x00000018ff6c7819ULL, 0x000fe40000011419ULL,
0x00000018ffd67819ULL, 0x000fe200000114d6ULL, 0x0000000500737306ULL, 0x000362000000d400ULL,
0x000000b900b67245ULL, 0x004fe4000020d400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001141bULL,
0x00000018ffd57819ULL, 0x000fc400000114d5ULL, 0x00000018ffa57819ULL, 0x000fe200000114a5ULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x0001000005057824ULL, 0x002fe200078e00ffULL,
0x000000b8b700720bULL, 0x008fe40003f1d000ULL, 0x00000018ffd47819ULL, 0x000fe400000114d4ULL,
0x00000018ffc17819ULL, 0x000fe40000011405ULL, 0x000000be00c07306ULL, 0x000e620000205400ULL,
0x0000000173732812ULL, 0x020fc400078efcffULL, 0x00000018ff607819ULL, 0x000fe4000001141aULL,
0x00000018ffa47819ULL, 0x000fe400000114a4ULL, 0x00000001b1b10812ULL, 0x000fe200078efcffULL,
0x000000b900ba7306ULL, 0x000fe20000209400ULL, 0x00000018ff0b7819ULL, 0x010fe4000001141dULL,
0x00000018ff207819ULL, 0x000fe4000001141cULL, 0x00000018ff027819ULL, 0x000fc4000001141eULL,
0x00000018ff007819ULL, 0x000fe2000001141fULL, 0x000000b900bb7306ULL, 0x000ea20000205400ULL,
0x000000c0bf00720bULL, 0x002fce0003f3d000ULL, 0x0000009e00ac7306ULL, 0x000ff00000209400ULL,
0x0000009e00a97306ULL, 0x000e620000205400ULL, 0x000000bbba00720bULL, 0x004fce0003f7d000ULL,
0x000000c100c27306ULL, 0x000fec0000209400ULL, 0x00000001b6b63812ULL, 0x000fe400078efcffULL,
0x000000c100c37306ULL, 0x000ea20000205400ULL, 0x000000a9ac00720bULL, 0x002fe40003f1d000ULL,
0x000000be00ac7245ULL, 0x000fc4000020d400ULL, 0x00000018ffa97819ULL, 0x000fe400000114d1ULL,
0x00000001acac1812ULL, 0x000fe200078efcffULL, 0x000000c600c77306ULL, 0x000fe20000209400ULL,
0x000000b1b6b6723eULL, 0x000fce00000010ffULL, 0x000000c600c87306ULL, 0x000e620000205400ULL,
0x000000c3c200720bULL, 0x004fce0003fdd000ULL, 0x0000000700a37306ULL, 0x000ff00000009400ULL,
0x0000000700a27306ULL, 0x000ea20000005400ULL, 0x000000c8c700720bULL, 0x002fce0003f3d000ULL,
0x0000000c00a17306ULL, 0x000ff00000009400ULL, 0x0000000c009c7306ULL, 0x000e620000005400ULL,
0x000000a2a300720bULL, 0x004fe40003f7d000ULL, 0x000000c100a27245ULL, 0x000fc4000020d400ULL,
0x0000009e00a37245ULL, 0x000fe4000020d400ULL, 0x00000001a2a26812ULL, 0x000fe200078efcffULL,
0x000000af00cb7306ULL, 0x000fe20000209400ULL, 0x00000001a3a30812ULL, 0x000fce00078efcffULL,
0x000000af00cc7306ULL, 0x000ea20000205400ULL, 0x0000009ca100720bULL, 0x002fe40003fdd000ULL,
0x000000c6009c7245ULL, 0x000fc8000020d400ULL, 0x000000019c9c1812ULL, 0x000fe200078efcffULL,
0x00000093009b7306ULL, 0x000ff00000209400ULL, 0x0000009300987306ULL, 0x0002e20000205400ULL,
0x000000cccb00720bULL, 0x004fce0003f5d000ULL, 0x000000ae00c97306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fce000020d400ULL, 0x000000ae00ca7306ULL, 0x0002a20000205400ULL,
0x000000989b00720bULL, 0x008fe40003f3d000ULL, 0x000000af00987245ULL, 0x000fc8000020d400ULL,
0x0000000198982812ULL, 0x000fe200078efcffULL, 0x0000000700677306ULL, 0x000722000000d400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x0000000193931812ULL, 0x000fe400078efcffULL,
0x0000000400cf7306ULL, 0x000fe20000209400ULL, 0x000001000d077824ULL, 0x008fe200078e00ffULL,
0x000000cac900720bULL, 0x004fc80003f1d000ULL, 0x00000018ff077819ULL, 0x000fe40000011407ULL,
0x0000000400d07306ULL, 0x000e620000205400ULL, 0x0000000167673812ULL, 0x010fc800078efcffULL,
0x000000679867723eULL, 0x000fe400000010ffULL, 0x00000001aeae0812ULL, 0x000fe200078efcffULL,
0x000000a700cd7306ULL, 0x000ff00000209400ULL, 0x000000a700ce7306ULL, 0x0004e20000205400ULL,
0x000000d0cf00720bULL, 0x002fce0003f7d000ULL, 0x000000b200b07306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x004fce000020d400ULL, 0x000000b200b37306ULL, 0x0002a20000205400ULL,
0x000000cecd00720bULL, 0x008fce0003f5d000ULL, 0x0000000700b57306ULL, 0x000fe20000209400ULL,
0x000000b200b27245ULL, 0x002fca000020d400ULL, 0x00000001a7a72812ULL, 0x000fe400078efcffULL,
0x0000000700d27306ULL, 0x000e620000205400ULL, 0x000000b3b000720bULL, 0x004fe40003f9d000ULL,
0x00000018ffb07819ULL, 0x000fca00000114d3ULL, 0x0000000d008f7306ULL, 0x000fec0000009400ULL,
0x00000001b2b24812ULL, 0x000fe400078efcffULL, 0x0000000d00907306ULL, 0x000ea20000005400ULL,
0x000000d2b500720bULL, 0x002fe40003f3d000ULL, 0x00000071b2b2723eULL, 0x000fca00000010ffULL,
0x0000000c00617306ULL, 0x0002f0000000d400ULL, 0x0000003800887306ULL, 0x000fe20000209400ULL,
0x000000908f00720bULL, 0x004fe20003f1d000ULL, 0x00000100180c7824ULL, 0x002fe200078e00ffULL,
0x0000000400907245ULL, 0x000fc4000020d400ULL, 0x0000b80066047811ULL, 0x000fe400078e20ffULL,
0x0000000190903812ULL, 0x000fe200078efcffULL, 0x00000038003b7306ULL, 0x000e620000205400ULL,
0x0000000161616812ULL, 0x008fe400078efcffULL, 0x00000010ff66723eULL, 0x000fc800000010ffULL,
0x0000541066667816ULL, 0x000fe20000000066ULL, 0x000000a800ad7306ULL, 0x000fe80000209400ULL,
0x00001f0a660a7589ULL, 0x000fe800000e0000ULL, 0x000000a800b47306ULL, 0x0004e20000205400ULL,
0x0000003b8800720bULL, 0x002fce0003fdd000ULL, 0x0000000e00897306ULL, 0x000fe20000009400ULL,
0x000000a800a87245ULL, 0x004fce000020d400ULL, 0x0000000e008c7306ULL, 0x000e620000005400ULL,
0x000000b4ad00720bULL, 0x008fce0003f7d000ULL, 0x0000000600c47306ULL, 0x000fec0000009400ULL,
0x00000001a8a83812ULL, 0x000fe400078efcffULL, 0x0000000600c57306ULL, 0x000ea20000005400ULL,
0x0000008c8900720bULL, 0x002fe40003f5d000ULL, 0x0000000700897245ULL, 0x000fc8000020d400ULL,
0x0000000189891812ULL, 0x000fe200078efcffULL, 0x0000001800877306ULL, 0x000ff00000009400ULL,
0x00000018008a7306ULL, 0x000e620000005400ULL, 0x000000c5c400720bULL, 0x004fce0003f9d000ULL,
0x00000006006b7306ULL, 0x000eb0000000d400ULL, 0x00000086003a7306ULL, 0x000fe20000209400ULL,
0x0000008a8700720bULL, 0x002fe40003f3d000ULL, 0x0000003800877245ULL, 0x000fc4000020d400ULL,
0x0000b80065387811ULL, 0x000fe400078e20ffULL, 0x0000000187876812ULL, 0x000fe200078efcffULL,
0x0000008600397306ULL, 0x000e620000205400ULL, 0x000000016b6b4812ULL, 0x004fe400078efcffULL,
0x00000002ff657819ULL, 0x000fe4000001162cULL, 0x000000a887a8723eULL, 0x000fc600000010ffULL,
0x0000009500067306ULL, 0x000fe20000209400ULL, 0x00001f6566657589ULL, 0x0005ee00000e0000ULL,
0x0000009500057306ULL, 0x000ee20000205400ULL, 0x000000393a00720bULL, 0x002fe40003f7d000ULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x0000006b9c66723eULL, 0x004fc800000010ffULL,
0x0000000d00627306ULL, 0x000530000000d400ULL, 0x0000008d00947306ULL, 0x000fe20000209400ULL,
0x000000050600720bULL, 0x008fe20003fdd000ULL, 0x000001001e0d7824ULL, 0x004fe200078e00ffULL,
0x000000000404783bULL, 0x000ea80000000200ULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000008d00977306ULL, 0x000ee20000205400ULL, 0x0000000162620812ULL, 0x010fc800078efcffULL,
0x000000628989723eULL, 0x000fc600000010ffULL, 0x000000a000ab7306ULL, 0x000ff00000209400ULL,
0x000000a000aa7306ULL, 0x0009620000205400ULL, 0x000000979400720bULL, 0x008fe40003f9d000ULL,
0x0000008d00947245ULL, 0x000fe2000020d400ULL, 0x000000653838d231ULL, 0x002fc400003400ffULL,
0x000000653a3ad231ULL, 0x080fe400003400ffULL, 0x0000000e005d7306ULL, 0x0002e2000000d400ULL,
0x000000a000a07245ULL, 0x010fe2000020d400ULL, 0x0000000a3939d231ULL, 0x080fe400003400ffULL,
0x0000000a3b3bd231ULL, 0x080fe400003400ffULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x0000000f008b7306ULL, 0x000fe20000009400ULL, 0x000100000e0e7824ULL, 0x002fe200078e00ffULL,
0x000000aaab00720bULL, 0x020fe20003f1d000ULL, 0x000000650404d231ULL, 0x084fe200003400ffULL,
0x000000a794a7723eULL, 0x000fe200000010ffULL, 0x000000650606d231ULL, 0x000fe200003400ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0000000a0505d231ULL, 0x080fe200003400ffULL,
0x0000000f008e7306ULL, 0x000e620000005400ULL, 0x000000015d5d2812ULL, 0x008fe200078efcffULL,
0x0000000a0707d231ULL, 0x000fe200003400ffULL, 0x000000a9000a7245ULL, 0x000fc4000020d400ULL,
0x000000b000657245ULL, 0x000fe4000020d400ULL, 0x00000001a0a00812ULL, 0x000fe200078efcffULL,
0x0000001900847306ULL, 0x000fe20000009400ULL, 0x00000066044c723cULL, 0x000fee000004184cULL,
0x0000001900857306ULL, 0x000ea20000005400ULL, 0x0000008e8b00720bULL, 0x002fc40003f9d000ULL,
0x00000086008b7245ULL, 0x000fe4000020d400ULL, 0x0000009100867245ULL, 0x000fe4000020d400ULL,
0x000000018b8b3812ULL, 0x000fe200078efcffULL, 0x0000007e00827306ULL, 0x000ff00000209400ULL,
0x0000007e00837306ULL, 0x000e620000205400ULL, 0x000000858400720bULL, 0x004fc40003f1d000ULL,
0x0000009500847245ULL, 0x000fc8000020d400ULL, 0x0000000184846812ULL, 0x000fe200078efcffULL,
0x0000000e009a7306ULL, 0x000fe60000209400ULL, 0x0000005d8484723eULL, 0x000fca00000010ffULL,
0x0000000e009f7306ULL, 0x0004e20000205400ULL, 0x000000838200720bULL, 0x002fce0003f5d000ULL,
0x00000018003c7306ULL, 0x000322000000d400ULL, 0x0000000e000e7245ULL, 0x004fce000020d400ULL,
0x0000000f003d7306ULL, 0x000562000000d400ULL, 0x0000009f9a00720bULL, 0x008fe40003fdd000ULL,
0x00000018ff187819ULL, 0x002fe2000001140cULL, 0x000001001f0c7824ULL, 0x000fc800078e00ffULL,
0x0000007200757306ULL, 0x000fe20000209400ULL, 0x000100000f0f7824ULL, 0x004fe200078e00ffULL,
0x000000013c3c1812ULL, 0x010fc800078efcffULL, 0x00000018ff0f7819ULL, 0x000fe4000001140fULL,
0x0000007200747306ULL, 0x000e620000205400ULL, 0x000000013d3d4812ULL, 0x020fe400078efcffULL,
0x000000010e0e6812ULL, 0x000fca00078efcffULL, 0x0000007700807306ULL, 0x000ff00000209400ULL,
0x00000077007b7306ULL, 0x000ea20000205400ULL, 0x000000747500720bULL, 0x002fce0003f3d000ULL,
0x0000009100927306ULL, 0x000ff00000209400ULL, 0x0000009100997306ULL, 0x000e620000205400ULL,
0x0000007b8000720bULL, 0x004fe40003f9d000ULL, 0x0000007e007b7245ULL, 0x000fc8000020d400ULL,
0x000000017b7b2812ULL, 0x000fe200078efcffULL, 0x0000001900307306ULL, 0x000ea6000000d400ULL,
0x0000000e7b0e723eULL, 0x000fca00000010ffULL, 0x0000006c007c7306ULL, 0x000fe20000209400ULL,
0x000000999200720bULL, 0x002fce0003f7d000ULL, 0x0000006c00797306ULL, 0x000e620000205400ULL,
0x0000000130300812ULL, 0x004fca00078efcffULL, 0x0000000186863812ULL, 0x000fe400078efcffULL,
0x0000001b007f7306ULL, 0x000ff00000009400ULL, 0x0000001b007a7306ULL, 0x000ea20000005400ULL,
0x000000797c00720bULL, 0x002fce0003f1d000ULL, 0x0000001a00817306ULL, 0x000ff00000009400ULL,
0x0000001a00767306ULL, 0x000e620000005400ULL, 0x0000007a7f00720bULL, 0x004fce0003f5d000ULL,
0x000000a900b77306ULL, 0x000ff00000209400ULL, 0x000000a9009e7306ULL, 0x0004e20000205400ULL,
0x000000768100720bULL, 0x002fe40003fdd000ULL, 0x0000007700767245ULL, 0x000fc8000020d400ULL,
0x0000000176764812ULL, 0x000fe200078efcffULL, 0x0000001d006e7306ULL, 0x000fe20000009400ULL,
0x000000a08ba9723eULL, 0x004fce00000010ffULL, 0x0000001d006d7306ULL, 0x000fe20000005400ULL,
0x0000009eb700720bULL, 0x008fe20003fbd000ULL, 0x000000a80440723cULL, 0x000fe20000041840ULL,
0x000000a2a3b7723eULL, 0x000fca00000010ffULL, 0x0000000f00967306ULL, 0x000fe40000209400ULL,
0x000000b60450723cULL, 0x000fe80000041850ULL, 0x000000010a0a5812ULL, 0x000fe400078efcffULL,
0x0000000f009d7306ULL, 0x0002b00000205400ULL, 0x000000b000b37306ULL, 0x000fe20000209400ULL,
0x0000000f000f7245ULL, 0x002fce000020d400ULL, 0x000000b000b87306ULL, 0x000e620000205400ULL,
0x0000009d9600720bULL, 0x004fce0003f7d000ULL, 0x0000001b00137306ULL, 0x0004ec000000d400ULL,
0x000000010f0f3812ULL, 0x000fe400078efcffULL, 0x000000d6008a7306ULL, 0x000fe20000209400ULL,
0x000001001c1b7824ULL, 0x004fe200078e00ffULL, 0x000000b8b300720bULL, 0x002fc40003f9d000ULL,
0x00000073acb3723eULL, 0x000fe400000010ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001141bULL,
0x000000d6008f7306ULL, 0x0002a20000205400ULL, 0x00000072001b7245ULL, 0x000fe4000020d400ULL,
0x0000000113132812ULL, 0x008fe200078efcffULL, 0x000000b20454723cULL, 0x000fe20000041854ULL,
0x000000011b1b1812ULL, 0x000fe400078efcffULL, 0x0000006d6e00720bULL, 0x000fe20003f3d000ULL,
0x0000001a00247306ULL, 0x000722000000d400ULL, 0x0000006c006d7245ULL, 0x000fc4000020d400ULL,
0x000000d600d67245ULL, 0x002fe4000020d400ULL, 0x000000016d6d0812ULL, 0x000fe400078efcffULL,
0x0000000165654812ULL, 0x000fe200078efcffULL, 0x000000d5008d7306ULL, 0x000fe20000209400ULL,
0x0000008f8a00720bULL, 0x004fe20003f1d000ULL, 0x000001001d1a7824ULL, 0x008fe200078e00ffULL,
0x0000000f760f723eULL, 0x000fc800000010ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001141aULL,
0x000000d5008c7306ULL, 0x0002a20000205400ULL, 0x0000000124246812ULL, 0x010fe200078efcffULL,
0x0000000e0414723cULL, 0x000fe80000041814ULL, 0x00000001d6d60812ULL, 0x000fe400078efcffULL,
0x000000a500857306ULL, 0x000fe20000209400ULL, 0x000000d500d57245ULL, 0x002fce000020d400ULL,
0x000000a500887306ULL, 0x0002e20000205400ULL, 0x0000008c8d00720bULL, 0x004fce0003fbd000ULL,
0x0000001800197306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x002fca000020d400ULL,
0x00000001d5d55812ULL, 0x000fe400078efcffULL, 0x0000001800a67306ULL, 0x000e620000205400ULL,
0x000000888500720bULL, 0x008fe40003fdd000ULL, 0x000000619088723eULL, 0x000fe400000010ffULL,
0x000000a400617245ULL, 0x000fe4000020d400ULL, 0x0000003d8685723eULL, 0x000fe200000010ffULL,
0x000000d4009b7306ULL, 0x000fe20000209400ULL, 0x00000030653d723eULL, 0x000fe200000010ffULL,
0x000000880444723cULL, 0x000fe80000041844ULL, 0x00000001a5a56812ULL, 0x000fc400078efcffULL,
0x000000d400ba7306ULL, 0x0004e20000205400ULL, 0x000000a61900720bULL, 0x002fe20003f7d000ULL,
0x000000840434723cULL, 0x000fe20000041834ULL, 0x0000001800197245ULL, 0x000fe4000020d400ULL,
0x000000ae93a6723eULL, 0x000fc600000010ffULL, 0x0000006000637306ULL, 0x000fe20000209400ULL,
0x000000d400d47245ULL, 0x004fc6000020d400ULL, 0x000000a60448723cULL, 0x000fe40000041848ULL,
0x0000000119193812ULL, 0x000fe400078efcffULL, 0x0000006000687306ULL, 0x0002a20000205400ULL,
0x000000ba9b00720bULL, 0x008fe40003f9d000ULL, 0x0000000a1b04723eULL, 0x000fe400000010ffULL,
0x00000013d607723eULL, 0x000fe400000010ffULL, 0x0000003c193c723eULL, 0x000fe200000010ffULL,
0x0000001f006a7306ULL, 0x000fe20000009400ULL, 0x0000006000607245ULL, 0x002fc4000020d400ULL,
0x00000024d506723eULL, 0x000fc600000010ffULL, 0x00000001d4d44812ULL, 0x000fe200078efcffULL,
0x0000003c3854723cULL, 0x000fe20000041854ULL, 0x0000001f00697306ULL, 0x000e620000005400ULL,
0x000000686300720bULL, 0x004fe40003f1d000ULL, 0x000000d46d05723eULL, 0x000fc800000010ffULL,
0x00000006384c723cULL, 0x040fe2000004184cULL, 0x000000a400827306ULL, 0x000fec0000209400ULL,
0x0000000160600812ULL, 0x000fe200078efcffULL, 0x000000043850723cULL, 0x000fe20000041850ULL,
0x000000a400817306ULL, 0x000ea20000205400ULL, 0x000000696a00720bULL, 0x002fc40003fbd000ULL,
0x000000a56060723eULL, 0x000fc600000010ffULL, 0x0000002000057245ULL, 0x000fe4000020d400ULL,
0x0000001d00097306ULL, 0x0002e2000000d400ULL, 0x0000000b00047245ULL, 0x000fce000020d400ULL,
0x0000001c007d7306ULL, 0x000fe20000009400ULL, 0x000100001d1d7824ULL, 0x002fe200078e00ffULL,
0x000000818200720bULL, 0x004fc80003fdd000ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00787306ULL, 0x000e620000005400ULL, 0x0000000109091812ULL, 0x008fcc00078efcffULL,
0x0000000161616812ULL, 0x000fe200078efcffULL, 0x0000001e006f7306ULL, 0x000ff00000009400ULL,
0x0000001e00707306ULL, 0x000ea20000005400ULL, 0x000000787d00720bULL, 0x002fce0003f7d000ULL,
0x0000003e005f7306ULL, 0x000ff00000209400ULL, 0x0000003e005e7306ULL, 0x0002e20000205400ULL,
0x000000706f00720bULL, 0x004fce0003f9d000ULL, 0x0000007a00777306ULL, 0x000fe20000209400ULL,
0x0000003e003e7245ULL, 0x002fce000020d400ULL, 0x0000007a00187306ULL, 0x0002a20000205400ULL,
0x0000005e5f00720bULL, 0x008fe40003f5d000ULL, 0x00000018ff5e7819ULL, 0x000fca000001140cULL,
0x00000020003f7306ULL, 0x000fe20000209400ULL, 0x0000007a007a7245ULL, 0x002fca000020d400ULL,
0x000000013e3e2812ULL, 0x000fe400078efcffULL, 0x00000020005c7306ULL, 0x000e620000205400ULL,
0x000000187700720bULL, 0x004fe40003f1d000ULL, 0x000000613e61723eULL, 0x000fca00000010ffULL,
0x0000001c00117306ULL, 0x0004e4000000d400ULL, 0x000000603848723cULL, 0x000fe80000041848ULL,
0x000000017a7a0812ULL, 0x000fe400078efcffULL, 0x0000001d00697306ULL, 0x000fe20000209400ULL,
0x000100001c1c7824ULL, 0x004fe200078e00ffULL, 0x0000005c3f00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001d006a7306ULL, 0x0002a20000205400ULL,
0x0000000111113812ULL, 0x008fc800078efcffULL, 0x000000117a7a723eULL, 0x000fe400000010ffULL,
0x0000000105056812ULL, 0x000fe200078efcffULL, 0x0000000b00337306ULL, 0x000fe20000209400ULL,
0x0000001d001d7245ULL, 0x002fce000020d400ULL, 0x0000000b00327306ULL, 0x000e620000205400ULL,
0x0000006a6900720bULL, 0x004fce0003f3d000ULL, 0x0000007e00787306ULL, 0x000fec0000209400ULL,
0x000000011d1d1812ULL, 0x000fe400078efcffULL, 0x0000007e00757306ULL, 0x0004e20000205400ULL,
0x000000323300720bULL, 0x002fce0003f5d000ULL, 0x0000001c001a7306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x004fca000020d400ULL, 0x0000000104042812ULL, 0x000fe400078efcffULL,
0x0000001c006f7306ULL, 0x0002a20000205400ULL, 0x000000757800720bULL, 0x008fe40003f1d000ULL,
0x0000001d041d723eULL, 0x000fca00000010ffULL, 0x0000001e00087306ULL, 0x000722000000d400ULL,
0x0000001c001c7245ULL, 0x002fca000020d400ULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x0000001f00037306ULL, 0x000362000000d400ULL, 0x000100001e1e7824ULL, 0x008fe200078e00ffULL,
0x0000006f1a00720bULL, 0x004fe40003f7d000ULL, 0x000000097e7b723eULL, 0x000fe400000010ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000005e00187306ULL, 0x000fe20000209400ULL,
0x000100001f1f7824ULL, 0x002fe200078e00ffULL, 0x0000000108084812ULL, 0x010fe200078efcffULL,
0x0000007a3844723cULL, 0x000fe60000041844ULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x0000005e003f7306ULL, 0x0002a20000205400ULL, 0x000000011c1c3812ULL, 0x000fe400078efcffULL,
0x0000000103035812ULL, 0x020fe400078efcffULL, 0x0000001c051c723eULL, 0x000fc600000010ffULL,
0x0000000d00627306ULL, 0x000fe20000209400ULL, 0x0000005e005e7245ULL, 0x002fc6000020d400ULL,
0x0000001c3840723cULL, 0x000fe80000041840ULL, 0x0000000d005f7306ULL, 0x0002e20000205400ULL,
0x0000003f1800720bULL, 0x004fce0003f3d000ULL, 0x0000000200317306ULL, 0x000fe20000209400ULL,
0x0000000d000d7245ULL, 0x002fca000020d400ULL, 0x000000015e5e1812ULL, 0x000fe400078efcffULL,
0x0000000200227306ULL, 0x000e620000205400ULL, 0x0000005f6200720bULL, 0x008fe40003fdd000ULL,
0x000000035e09723eULL, 0x000fe400000010ffULL, 0x0000000200037245ULL, 0x000fc6000020d400ULL,
0x0000000000127306ULL, 0x000fec0000209400ULL, 0x000000010d0d6812ULL, 0x000fe400078efcffULL,
0x0000000000217306ULL, 0x0004e20000205400ULL, 0x000000223100720bULL, 0x002fe40003f1d000ULL,
0x000000080d08723eULL, 0x000fca00000010ffULL, 0x0000001e000c7306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x004fe2000020d400ULL, 0x000000083834723cULL, 0x000fe80000041834ULL,
0x0000000103030812ULL, 0x000fe400078efcffULL, 0x0000001e000f7306ULL, 0x0002a20000205400ULL,
0x000000211200720bULL, 0x008fce0003f7d000ULL, 0x0000001f000a7306ULL, 0x000fe20000209400ULL,
0x0000001e001e7245ULL, 0x002fca000020d400ULL, 0x0000000100003812ULL, 0x000fe400078efcffULL,
0x0000001f00137306ULL, 0x0002e20000205400ULL, 0x0000000f0c00720bULL, 0x004fe40003f5d000ULL,
0x0000001f001f7245ULL, 0x002fd6000020d400ULL, 0x000000011e1e2812ULL, 0x000fe400078efcffULL,
0x000000130a00720bULL, 0x008fe40003f9d000ULL, 0x0000001e031e723eULL, 0x000fd600000010ffULL,
0x000000011f1f4812ULL, 0x000fc800078efcffULL, 0x0000001f001f723eULL, 0x000fce00000010ffULL,
0x0000001e3838723cULL, 0x000fe20000041814ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01064000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff23ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff6a7807ULL, 0x000fe40004000000ULL,
0x0000030064647a10ULL, 0x000fe40007ffe0ffULL, 0x000000ff26ff7812ULL, 0x000fe4000780c0ffULL,
0x0000002f6400720cULL, 0x000fe40003f26070ULL, 0x00000001ff267807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xfffece6000007947ULL, 0x000fea000383ffffULL,
0x00000000000c7919ULL, 0x000e640000002500ULL, 0x0000002f0c00720cULL, 0x002fda0003f06070ULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x0180000029007810ULL, 0x010fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000140e000187802ULL, 0x000fe40000000f00ULL, 0x0000976000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002900007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000029ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x00000002ff077819ULL, 0x008fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x004fca0000410000ULL,
0x00001f0700047589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000005404547220ULL, 0x044fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000004c044c7220ULL, 0x040fe20000410000ULL, 0x0000004d044d7220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004004407220ULL, 0x040fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x000fe20000410000ULL,
0x0000005605567220ULL, 0x048fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000004e054e7220ULL, 0x040fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000004a054a7220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000004605467220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x000fe20000410000ULL,
0x00000000000e7919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000020e007812ULL, 0x014fc400078ec0ffULL, 0x00000002ff0d7819ULL, 0x000fe4000001160eULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000200037811ULL, 0x040fe400078ff8ffULL,
0x0000000400067811ULL, 0x040fe400078ff8ffULL, 0x00000006000a7811ULL, 0x000fe400078ff8ffULL,
0x000000080e157811ULL, 0x000fc400078ff0ffULL, 0x0000000702007812ULL, 0x100fe400078e780dULL,
0x0000000703047812ULL, 0x100fe400078e780dULL, 0x0000000706087812ULL, 0x100fe200078e780dULL,
0x000000080d057824ULL, 0x000fe200078e0200ULL, 0x000000070a0b7812ULL, 0x000fe200078e780dULL,
0x000008005b007824ULL, 0x000fe200078e00ffULL, 0x0000000706067812ULL, 0x100fe200078e7815ULL,
0x000000080d077824ULL, 0x040fe200078e0204ULL, 0x0000000702027812ULL, 0x100fe200078e7815ULL,
0x000000080d097824ULL, 0x000fe200078e0208ULL, 0x0000000703037812ULL, 0x000fe200078e7815ULL,
0x000000080d0d7824ULL, 0x000fe200078e020bULL, 0x000000070a0a7812ULL, 0x000fe200078e7815ULL,
0x0000000815137824ULL, 0x000fe200078e0206ULL, 0x000000505104723eULL, 0x000fe200000010ffULL,
0x00000008150b7824ULL, 0x000fe200078e0202ULL, 0x0000a00000027810ULL, 0x000fe20007ffe0ffULL,
0x000000080e067824ULL, 0x000fe200078e00ffULL, 0x000000525308723eULL, 0x000fe200000010ffULL,
0x0000000815117824ULL, 0x000fe200078e0203ULL, 0x000000545503723eULL, 0x000fe200000010ffULL,
0x0000000815157824ULL, 0x000fe200078e020aULL, 0x0000000806067812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x0000541003167816ULL, 0x000fe20000000004ULL,
0x000000100b0f7824ULL, 0x000fe200078e0202ULL, 0x0000763203177816ULL, 0x000fe20000000004ULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x000000444503723eULL, 0x000fe200000010ffULL,
0x0000001011117824ULL, 0x100fe200078e0202ULL, 0x000000404104723eULL, 0x000fe200000010ffULL,
0x00000010090b7824ULL, 0x000fc400078e0202ULL, 0x000000100d0d7824ULL, 0x100fe400078e0202ULL,
0x0000001013137824ULL, 0x100fe400078e0202ULL, 0x0000001015157824ULL, 0x000fe400078e0202ULL,
0x0000000105097824ULL, 0x000fe200078e0206ULL, 0x0000004c4d05723eULL, 0x000fe200000010ffULL,
0x00000001060f7824ULL, 0x040fe400078e020fULL, 0x00000001060a7824ULL, 0x040fe200078e0207ULL,
0x0000001609007388ULL, 0x0005e20000000a00ULL, 0x0000000106117824ULL, 0x040fe200078e0211ULL,
0x000000565707723eULL, 0x000fe200000010ffULL, 0x00000001060b7824ULL, 0x000fc400078e020bULL,
0x00000001060d7824ULL, 0x040fe400078e020dULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x0000000106157824ULL, 0x000fe200078e0215ULL, 0x000000484906723eULL, 0x000fc800000010ffULL,
0x0000541005167816ULL, 0x144fe40000000006ULL, 0x0000763205177816ULL, 0x000fe40000000006ULL,
0x000000343505723eULL, 0x000fe400000010ffULL, 0x000000383906723eULL, 0x000fe200000010ffULL,
0x000000160a007388ULL, 0x0005e40000000a00ULL, 0x0000541003167816ULL, 0x144fe40000000004ULL,
0x0000763203177816ULL, 0x000fc40000000004ULL, 0x00005410050a7816ULL, 0x100fe40000000006ULL,
0x0000004e4f03723eULL, 0x000fe200000010ffULL, 0x000000160b007388ULL, 0x0005e20000000a00ULL,
0x0000004a4b04723eULL, 0x000fe400000010ffULL, 0x00007632050b7816ULL, 0x004fe20000000006ULL,
0x00000300ff177624ULL, 0x000fe200078e00ffULL, 0x000000464705723eULL, 0x000fe400000010ffULL,
0x000000424306723eULL, 0x000fe200000010ffULL, 0x0000000a0d007388ULL, 0x0005e20000000a00ULL,
0x000000011700780cULL, 0x000fc40003f05270ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x000000363707723eULL, 0x000fe400000010ffULL,
0x0000003a3b08723eULL, 0x000fe200000010ffULL, 0x0000000a0f007388ULL, 0x0005e40000000a00ULL,
0x00005410030a7816ULL, 0x144fe40000000004ULL, 0x00007632030b7816ULL, 0x000fc40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000000a11007388ULL, 0x0005e20000000a00ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000000413007388ULL, 0x0005e80000000a00ULL,
0x0000000615007388ULL, 0x0005e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002cc000008947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x004ea20000000000ULL,
0x0000580017037a24ULL, 0x000fe200078e02ffULL, 0x000000ff5b00720cULL, 0x000fe20003f25270ULL,
0x00002000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ee20000002700ULL,
0x0000660003057a24ULL, 0x000fc600078e02ffULL, 0x0000000000067919ULL, 0x000ee20000002600ULL,
0x00000010040a7824ULL, 0x044fe200078e0200ULL, 0x0000002004117810ULL, 0x040fe40007ffe0ffULL,
0x0000004004137810ULL, 0x040fe40007ffe0ffULL, 0x00a000000a187984ULL, 0x0005220000000c00ULL,
0x0000006004157810ULL, 0x000fe20007ffe0ffULL, 0x0000580007077a24ULL, 0x008fe400078e0206ULL,
0x00a200000a1c7984ULL, 0x0004e20000000c00ULL, 0x00001fff05067811ULL, 0x000fe200078e40ffULL,
0x0000030007037a24ULL, 0x000fc400078e02ffULL, 0x00a400000a207984ULL, 0x0004620000000c00ULL,
0x000000ff0400720cULL, 0x000fe20003f05270ULL, 0x00000001030b7824ULL, 0x000fe400078e020cULL,
0x00a600000a247984ULL, 0x0004620000000c00ULL, 0x000000ff5b00720cULL, 0x000fe40000705670ULL,
0x0000000b06087211ULL, 0x000fca00078f98ffULL, 0x00006c0008087625ULL, 0x000fcc00078e0009ULL,
0x000008005b087825ULL, 0x000fcc00078e0008ULL, 0x0000001011107825ULL, 0x000fc800078e0008ULL,
0x0000001013127825ULL, 0x000fc800078e0008ULL, 0x0000001015147825ULL, 0x000fc800078e0008ULL,
0x00000010040e7825ULL, 0x000fe200078e0008ULL, 0x01ffffff05087812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x01cea20000000000ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x000000010b0c7824ULL, 0x040fe400078e0208ULL,
0x00006c000b0a7625ULL, 0x000fc800078e000dULL, 0x00006c000c0c7625ULL, 0x000fc800078e000dULL,
0x0000001005097824ULL, 0x004fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011605ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000a050a7210ULL, 0x140fe40007b5e009ULL, 0x0000000c050c7210ULL, 0x000fe40007d9e009ULL,
0x0000000bff0b7210ULL, 0x000fe400017e64ffULL, 0x0000000dff0d7210ULL, 0x000fc600027ea4ffULL,
0x0000002a0a007986ULL, 0x0005e8000c101906ULL, 0x000000290c007986ULL, 0x0005e4000c101906ULL,
0x000000180e007986ULL, 0x01c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000001c10007986ULL, 0x0005e8000c101d06ULL, 0x0000002012007986ULL, 0x0025e8000c101d06ULL,
0x0000002414007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0a7424ULL, 0x000fe200078e00ffULL,
0xffffffff17057810ULL, 0x000fc60007ffe0ffULL, 0x00006a00070a7625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000050a0a79a8ULL, 0x000ee400099ee1c6ULL, 0x000000050a00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff077807ULL, 0x000fca0000000000ULL,
0x00000007ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff057984ULL, 0x000ee40000000000ULL,
0x000000ff0500720cULL, 0x008fda0003f05270ULL, 0x0000285000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011604ULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x00000001030c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x002fe200078e00ffULL, 0x0000000c0a0f7812ULL, 0x004fe400078ec0ffULL,
0x0000007005097812ULL, 0x000fe200078ec0ffULL, 0x00006c00030a7625ULL, 0x000fc800078e0007ULL,
0x00006c000c0c7625ULL, 0x000fe200078e0007ULL, 0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL,
0x0000000c0f0c7210ULL, 0x000fe40007b5e009ULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a057981ULL, 0x000368000c1e1900ULL,
0x000000060c0e7981ULL, 0x000362000c1e1900ULL, 0x000000021700780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002030a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0007ULL, 0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a107981ULL, 0x000362000c1e1900ULL,
0x000000041700780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003030a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0007ULL,
0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a127981ULL, 0x000362000c1e1900ULL, 0x000000041700780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004030a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0007ULL, 0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a147981ULL, 0x000362000c1e1900ULL,
0x000000061700780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005030a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0007ULL,
0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a167981ULL, 0x000362000c1e1900ULL, 0x000000061700780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081700780cULL, 0x002fe40003f06070ULL,
0x00000006030a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0007ULL,
0x0000000a0f0a7210ULL, 0x000fe40007a3e009ULL, 0x00000007030c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000c0c0625ULL, 0x000fe400078e0007ULL,
0x000000060a1a7981ULL, 0x000366000c1e1900ULL, 0x0000000c0f0c0210ULL, 0x000fc80007c7e009ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c0c0981ULL, 0x000368000c1e1900ULL,
0x0000000717077810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff077819ULL, 0x000fc80000011607ULL,
0x000000ff0700720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff187224ULL, 0x004fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x020fe400078e0005ULL,
0x0000000818097824ULL, 0x040fe200078e00ffULL, 0x0000000118187810ULL, 0x000fc80007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x000000071800720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008090a7810ULL, 0x040fe40007ffe0ffULL,
0x00000001090b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001c05057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0f0a7210ULL, 0x000fc80007b3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1c7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009090a7810ULL, 0x042fe40007ffe0ffULL, 0x00000002090b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000e05057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001030a7824ULL, 0x000fe200078e020aULL, 0x00000001ff0e7819ULL, 0x000fe20000011604ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0e7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a090a7810ULL, 0x042fe40007ffe0ffULL,
0x00000003090b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001005057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0f0a7210ULL, 0x000fc80007b3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a107981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b090a7810ULL, 0x042fe40007ffe0ffULL, 0x00000004090b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001205057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001030a7824ULL, 0x000fe200078e020aULL, 0x00000001ff0f7819ULL, 0x000fe20000011604ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0f0a7210ULL, 0x000fc80007b3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a127981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c090a7810ULL, 0x042fe40007ffe0ffULL,
0x00000005090b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001405057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0f0a7210ULL, 0x000fc80007b3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a147981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d090a7810ULL, 0x042fe40007ffe0ffULL, 0x00000006090b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001605057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001030a7824ULL, 0x000fe200078e020aULL, 0x00000001ff0f7819ULL, 0x000fe20000011604ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0f0a7210ULL, 0x000fc80007b3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a167981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e090a7810ULL, 0x042fe40007ffe0ffULL,
0x00000007090b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001a05057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001030a7824ULL, 0x000fe200078e020aULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0f0a7210ULL, 0x000fc80007b3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1a7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f090a7810ULL, 0x002fe40007ffe0ffULL, 0x0000000c05057209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001030a7824ULL, 0x000fe200078e020aULL, 0x00000001ff0c7819ULL, 0x000fe20000011604ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001004097824ULL, 0x000fe200078e00ffULL,
0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007009097812ULL, 0x000fc800078ec0ffULL, 0x0000000a0c0a7210ULL, 0x000fc80007a3e009ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a0c7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000047919ULL, 0x000ee40000000000ULL,
0x0000001004077824ULL, 0x008fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011604ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c090a7812ULL, 0x002fca00078ec0ffULL,
0x00000001070a7824ULL, 0x000fca00078e020aULL, 0x000000050a007388ULL, 0x0203e40000000800ULL,
0x00000003060a7211ULL, 0x002fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000070400780cULL, 0x000fe20003f04070ULL,
0x000008005b187824ULL, 0x004fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe20000011604ULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x00000015ff197819ULL, 0x000fe2000001165bULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000c070c7812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x000000180a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000010005b297824ULL, 0x000fe200078e00ffULL, 0x00000020040d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x0000000103128824ULL, 0x000fe200078e0208ULL, 0x00000040040f7810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000006004117810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fe200008e0619ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff148424ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000105057824ULL, 0x000fe200078e020cULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00006c0012128625ULL, 0x000fe200078e0013ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000005287984ULL, 0x0002a20000000800ULL,
0x000000100d0c7825ULL, 0x100fe200078e000aULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000100f0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x000000105b1f8824ULL, 0x000fe400078e0204ULL, 0x00006c0003148625ULL, 0x000fc600078e0014ULL,
0x000045801f1f8811ULL, 0x000fe200078e20ffULL, 0x00000010041d7824ULL, 0x040fe400078e0229ULL,
0x00000010040a7825ULL, 0x000fc800078e000aULL, 0x000000105b218824ULL, 0x000fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a1d7faeULL, 0x0007e2000b901c46ULL,
0x0000001004128825ULL, 0x000fc600078e0012ULL, 0x0000418021218811ULL, 0x000fe200078e20ffULL,
0x0000001004148825ULL, 0x000fe200078e0014ULL, 0x003800000c1d7faeULL, 0x0009e6000b901c46ULL,
0x000000ffff057224ULL, 0x002fe200078e00ffULL, 0x005800000e1d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x00780000101d7faeULL, 0x0007e2000b901c46ULL,
0x000000ffff387224ULL, 0x000fc600078e00ffULL, 0x00000000121f8faeULL, 0x000be2000b901c46ULL,
0x00000000000c7805ULL, 0x010fc6000001ff00ULL, 0x0000000014218faeULL, 0x0009e2000b901c46ULL,
0x00000000000e7805ULL, 0x002fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000107805ULL, 0x008fe2000001ff00ULL, 0x0000000000127805ULL, 0x020fe2000001ff00ULL,
0x0000000000147805ULL, 0x010fe2000001ff00ULL, 0x00000d5000009947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x004fe400078e00ffULL, 0x000000ffff397224ULL, 0x000fca00078e00ffULL,
0x00000001393a7810ULL, 0x000fc80007ffe0ffULL, 0x000003003a007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x00000001033f7824ULL, 0x000fe200078e023aULL,
0x000000070400780cULL, 0x000fe20003f24070ULL, 0x00002000ff1d7424ULL, 0x000fe200078e00ffULL,
0x000000013a207812ULL, 0x040fe200078ec0ffULL, 0x000008003a1e7824ULL, 0x000fe200078e00ffULL,
0x0000003f061c7211ULL, 0x000fe400078f98ffULL, 0x0000002004217810ULL, 0x000fe40007ffe0ffULL,
0x000008001e1e7812ULL, 0x000fe200078ec0ffULL, 0x00006c001c1c7625ULL, 0x000fe200078e001dULL,
0x0000004004237810ULL, 0x000fc40007ffe0ffULL, 0x00000060043d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001291f7824ULL, 0x000fe200078e021eULL, 0x000000181c1c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000108249824ULL, 0x000fe400078e023fULL, 0x00000080ff259424ULL, 0x000fe400078e00ffULL,
0x000000011d1d7824ULL, 0x000fe400000e0619ULL, 0x000000025b279824ULL, 0x140fe400078e0220ULL,
0x000000025b419824ULL, 0x000fc400078e0220ULL, 0x00000080ff269424ULL, 0x000fe400078e00ffULL,
0x00000010043b7824ULL, 0x000fe400078e021fULL, 0x0000001021207825ULL, 0x000fc800078e001cULL,
0x0000001023227825ULL, 0x000fc800078e001cULL, 0x00000010041e7825ULL, 0x000fc800078e001cULL,
0x000000103d1c7825ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800001e3b7faeULL, 0x0003e6000b901c46ULL, 0x00006c0024249625ULL, 0x000fe200078e0025ULL,
0x00380000203b7faeULL, 0x0003e6000b901c46ULL, 0x00000008273d9824ULL, 0x000fe200078e0204ULL,
0x00580000223b7faeULL, 0x0003e2000b901c46ULL, 0x00006c003f269625ULL, 0x000fc600078e0026ULL,
0x000045803d3d9811ULL, 0x000fe200078e20ffULL, 0x00000008413f9824ULL, 0x000fe200078e0204ULL,
0x007800001c3b7faeULL, 0x0003e2000b901c46ULL, 0x0000001004249825ULL, 0x000fc600078e0024ULL,
0x000041803f3f9811ULL, 0x000fe200078e20ffULL, 0x0000001004269825ULL, 0x000fe200078e0026ULL,
0x00000000243d9faeULL, 0x0003e8000b901c46ULL, 0x00000000263f9faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000080391c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff1e7819ULL, 0x100fe20000011604ULL, 0x00000010041d7824ULL, 0x000fe200078e00ffULL,
0x00000002ff527819ULL, 0x000fc40000011604ULL, 0x000000801c1c7812ULL, 0x000fe400078ec0ffULL,
0x000000701d1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000852217824ULL, 0x000fe200078e00ffULL,
0x0000000c1e1e7812ULL, 0x000fe200078ec0ffULL, 0x000001005b1c7824ULL, 0x000fe200078e021cULL,
0x00000007523e7812ULL, 0x040fe200078ec0ffULL, 0x0000000852237824ULL, 0x000fe200078e00ffULL,
0x00000052ff407212ULL, 0x000fe400078e33ffULL, 0x0000001c1e1e7210ULL, 0x000fe20007ffe01dULL,
0x00000008521d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8211c7812ULL, 0x000fc400078ee23eULL,
0xfffffff823407812ULL, 0x000fe400078ee240ULL, 0x000000011d207812ULL, 0x000fe200078ef63eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180001e1f7984ULL, 0x000e620000000800ULL,
0x000000021d227812ULL, 0x140fe400078ef63eULL, 0x000000031d247812ULL, 0x140fe200078ef63eULL,
0x004580001e507984ULL, 0x0004e20000000800ULL, 0x000000041d267812ULL, 0x140fe400078ef63eULL,
0x000000051d3c7812ULL, 0x140fe400078ef63eULL, 0x000000061d3e7812ULL, 0x000fe200078ef63eULL,
0x00000800391d7824ULL, 0x000fe200078e00ffULL, 0x0000000852547810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff397224ULL, 0x000fc600078e003aULL, 0x000008001d1e7812ULL, 0x004fe200078ec0ffULL,
0x0000000854217824ULL, 0x040fe200078e00ffULL, 0x00000054ff4e7212ULL, 0x000fe200078e33ffULL,
0x0000000854447824ULL, 0x040fe200078e00ffULL, 0x00000180291d7810ULL, 0x000fe20007ffe01eULL,
0x0000000854427824ULL, 0x040fe200078e00ffULL, 0xfffffff8214e7812ULL, 0x000fe400078ee24eULL,
0x0000000754217812ULL, 0x000fe200078ec0ffULL, 0x000000101c1c7824ULL, 0x100fe200078e021dULL,
0x0000030039007a0cULL, 0x000fe20003f06070ULL, 0x0000001040407824ULL, 0x000fe200078e021dULL,
0xfffffff8441e7812ULL, 0x000fe200078ee221ULL, 0x0000001020207824ULL, 0x000fe200078e021dULL,
0x0000000142447812ULL, 0x000fe200078ef621ULL, 0x0000001022227824ULL, 0x000fe200078e021dULL,
0x0000000242467812ULL, 0x000fe200078ef621ULL, 0x0000001024247824ULL, 0x000fe200078e021dULL,
0x0000000342487812ULL, 0x000fe200078ef621ULL, 0x0000001026267824ULL, 0x000fe200078e021dULL,
0x00000004424a7812ULL, 0x000fe200078ef621ULL, 0x000000103c3c7824ULL, 0x000fe200078e021dULL,
0x00000005424c7812ULL, 0x000fe200078ef621ULL, 0x000000103e3e7824ULL, 0x000fe200078e021dULL,
0x0000000642427812ULL, 0x000fe200078ef621ULL, 0x0000001f281f7221ULL, 0x002fe20000010100ULL,
0x000000101e1e7824ULL, 0x000fc400078e021dULL, 0x0000001044447824ULL, 0x100fe200078e021dULL,
0x3fb8aa3b1f237820ULL, 0x000fe20000410000ULL, 0x00000004041f7824ULL, 0x000fe400078e00ffULL,
0x0000001046467824ULL, 0x100fe400078e021dULL, 0x0000001048487824ULL, 0x100fe200078e021dULL,
0x0000000c1f1f7812ULL, 0x000fe200078ec0ffULL, 0x0000002300237308ULL, 0x000ee20000000800ULL,
0x000000104a4a7824ULL, 0x100fe400078e021dULL, 0x000000104c4c7824ULL, 0x000fc400078e021dULL,
0x000000011c1c7824ULL, 0x000fe400078e021fULL, 0x000000011f407824ULL, 0x040fe400078e0240ULL,
0x000000011f207824ULL, 0x040fe200078e0220ULL, 0x000000001c257984ULL, 0x000e620000000800ULL,
0x000000011f227824ULL, 0x040fe400078e0222ULL, 0x000000011f247824ULL, 0x040fe200078e0224ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x000000011f267824ULL, 0x000fe200078e0226ULL,
0x0000005023237220ULL, 0x008fe20000410000ULL, 0x000000011f3c7824ULL, 0x040fe200078e023cULL,
0x0000000020207984ULL, 0x000fe20000000800ULL, 0x000000011f3e7824ULL, 0x000fe200078e023eULL,
0x0000003823387221ULL, 0x000fe20000010000ULL, 0x000000011f1e7824ULL, 0x040fe200078e021eULL,
0x0000000022227984ULL, 0x000fe20000000800ULL, 0x000000011f447824ULL, 0x000fc400078e0244ULL,
0x0000001042427824ULL, 0x100fe200078e021dULL, 0x00001f5223217589ULL, 0x000ea200000e0000ULL,
0x000000104e4e7824ULL, 0x000fe400078e021dULL, 0x000000011f467824ULL, 0x040fe200078e0246ULL,
0x0000000024247984ULL, 0x000ee20000000800ULL, 0x000000011f487824ULL, 0x040fe400078e0248ULL,
0x000000011f4a7824ULL, 0x040fe200078e024aULL, 0x0000000026267984ULL, 0x000f220000000800ULL,
0x000000011f4c7824ULL, 0x000fc400078e024cULL, 0x000000011f427824ULL, 0x040fe200078e0242ULL,
0x000000003c3c7984ULL, 0x000f620000000800ULL, 0x000000011f4e7824ULL, 0x000fc600078e024eULL,
0x000000003e3e7984ULL, 0x000f680000000800ULL, 0x000000001e1e7984ULL, 0x000f620000000800ULL,
0x00005410ff1c7816ULL, 0x002fc60000000025ULL, 0x0000000044447984ULL, 0x000fe20000000800ULL,
0x00007610ff1d7816ULL, 0x000fe20000000025ULL, 0x000000211c377223ULL, 0x004fe20000010037ULL,
0x00007610ff1c7816ULL, 0x000fc60000000040ULL, 0x000000211d367223ULL, 0x080fe20000010036ULL,
0x00005410ff1d7816ULL, 0x000fe20000000040ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x000000211c177223ULL, 0x080fe20000010017ULL, 0x00005410ff1c7816ULL, 0x000fe40000000020ULL,
0x000000211d1a7223ULL, 0x080fe2000001001aULL, 0x00007610ff1d7816ULL, 0x000fe20000000020ULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x000000211c357223ULL, 0x000fe20000010035ULL,
0x00005410ff1c7816ULL, 0x000fc40000000022ULL, 0x00001f5423237589ULL, 0x000e6200000e0000ULL,
0x000000211d347223ULL, 0x080fe20000010034ULL, 0x00007610ff1d7816ULL, 0x000fe20000000022ULL,
0x000000211c337223ULL, 0x080fe20000010033ULL, 0x00005410ff1c7816ULL, 0x008fe20000000024ULL,
0x000000004a4a7984ULL, 0x000ea40000000800ULL, 0x000000211d327223ULL, 0x080fe20000010032ULL,
0x00007610ff1d7816ULL, 0x000fe20000000024ULL, 0x000000211c317223ULL, 0x080fe20000010031ULL,
0x00005410ff1c7816ULL, 0x010fe20000000026ULL, 0x000000004c4c7984ULL, 0x000ee40000000800ULL,
0x000000211d307223ULL, 0x080fe20000010030ULL, 0x00007610ff1d7816ULL, 0x000fe20000000026ULL,
0x000000211c2f7223ULL, 0x080fe2000001002fULL, 0x00007610ff1c7816ULL, 0x020fe2000000003cULL,
0x0000000042427984ULL, 0x000f240000000800ULL, 0x000000211d2e7223ULL, 0x080fe2000001002eULL,
0x00005410ff1d7816ULL, 0x000fe2000000003cULL, 0x000000211c2b7223ULL, 0x080fe2000001002bULL,
0x00007610ff1c7816ULL, 0x000fe2000000003eULL, 0x000000004e4e7984ULL, 0x000f640000000800ULL,
0x000000211d2c7223ULL, 0x080fe2000001002cULL, 0x00005410ff1d7816ULL, 0x000fe2000000003eULL,
0x000000211c1b7223ULL, 0x000fe2000001001bULL, 0x00007610ff1c7816ULL, 0x000fc6000000001eULL,
0x000000211d2a7223ULL, 0x000fe2000001002aULL, 0x00005410ff1d7816ULL, 0x000fe2000000001eULL,
0x000000231c157223ULL, 0x002fe20000010015ULL, 0x00007610ff1c7816ULL, 0x000fc60000000044ULL,
0x000000231d167223ULL, 0x080fe20000010016ULL, 0x00005410ff1d7816ULL, 0x000fe20000000044ULL,
0x000000231c137223ULL, 0x000fe20000010013ULL, 0x00007610ff1c7816ULL, 0x000fc60000000046ULL,
0x000000231d147223ULL, 0x080fe20000010014ULL, 0x00005410ff1d7816ULL, 0x000fe20000000046ULL,
0x000000231c117223ULL, 0x000fe20000010011ULL, 0x00007610ff1c7816ULL, 0x000fc60000000048ULL,
0x000000231d127223ULL, 0x080fe20000010012ULL, 0x00005410ff1d7816ULL, 0x000fe20000000048ULL,
0x000000231c0f7223ULL, 0x000fe2000001000fULL, 0x00007610ff1c7816ULL, 0x004fc6000000004aULL,
0x000000231d107223ULL, 0x080fe20000010010ULL, 0x00005410ff1d7816ULL, 0x000fe2000000004aULL,
0x000000231c0d7223ULL, 0x000fe2000001000dULL, 0x00007610ff1c7816ULL, 0x008fc6000000004cULL,
0x000000231d0e7223ULL, 0x080fe2000001000eULL, 0x00005410ff1d7816ULL, 0x000fe2000000004cULL,
0x000000231c0b7223ULL, 0x000fe2000001000bULL, 0x00007610ff1c7816ULL, 0x010fc60000000042ULL,
0x000000231d0c7223ULL, 0x080fe2000001000cULL, 0x00005410ff1d7816ULL, 0x000fe20000000042ULL,
0x000000231c097223ULL, 0x000fe20000010009ULL, 0x00005410ff1c7816ULL, 0x020fc6000000004eULL,
0x000000231d0a7223ULL, 0x080fe4000001000aULL, 0x000000231c077223ULL, 0x000fe20000010007ULL,
0x00007610ff1c7816ULL, 0x000fca000000004eULL, 0x000000231c057223ULL, 0x000fe20000010005ULL,
0xfffff2d000008947ULL, 0x000fea000383ffffULL, 0x0180000038037810ULL, 0x004fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff297224ULL, 0x000fe200078e0038ULL,
0x00016d0000187802ULL, 0x000fe40000000f00ULL, 0x00006b4000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003800037308ULL, 0x000e640000001000ULL,
0xbf80000003047423ULL, 0x002fc80000000038ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000f280000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff187819ULL, 0x010fe40000011608ULL, 0x00000008083b7811ULL, 0x000fc600078ff0ffULL,
0x00001f1803047589ULL, 0x00cea200000e0000ULL, 0x0000003bff397212ULL, 0x000fe200078e33ffULL,
0x000000083b1c7824ULL, 0x000fe400078e00ffULL, 0x00001f3b03067589ULL, 0x00072600000e0000ULL,
0xfffffff81c397812ULL, 0x000fca00078ee239ULL, 0x0000001039397824ULL, 0x000fe200078e0202ULL,
0x00000018ff037212ULL, 0x008fe200078e33ffULL, 0x0000003704377220ULL, 0x044fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x000fe20000410000ULL, 0x0000000818047824ULL, 0x000fe200078e00ffULL,
0x0000001606167220ULL, 0x050fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000001306137220ULL, 0x040fe20000410000ULL,
0x0000001206127220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000000f060f7220ULL, 0x040fe20000410000ULL,
0x0000000e060e7220ULL, 0x040fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000000c060c7220ULL, 0x040fe20000410000ULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x0000000a060a7220ULL, 0x040fe20000410000ULL, 0x0000000906097220ULL, 0x040fe20000410000ULL,
0x0000000706077220ULL, 0x040fe20000410000ULL, 0x0000000506067220ULL, 0x000fe20000410000ULL,
0xfffffff8043d7812ULL, 0x000fe200078ee203ULL, 0x0000000818037824ULL, 0x040fe200078e00ffULL,
0x0000000718047812ULL, 0x000fc400078ec0ffULL, 0x0000000a0909723eULL, 0x000fe200000010ffULL,
0x000000083b0a7824ULL, 0x000fe200078e00ffULL, 0x000000070606723eULL, 0x000fe400000010ffULL,
0x0000000104057812ULL, 0x000fe400078e3cffULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000000408127824ULL, 0x000fe200078e00ffULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x0000000818057824ULL, 0x000fe200078e0205ULL, 0x0000000204077812ULL, 0x000fc400078e3cffULL,
0x000000073b107812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x000fe200078e0202ULL,
0x0000000304197812ULL, 0x000fe200078e3cffULL, 0x0000000818077824ULL, 0x000fe200078e0207ULL,
0xfffffff803037812ULL, 0x000fe400078ee218ULL, 0x00000004041d7812ULL, 0x000fe200078e3cffULL,
0x0000000818197824ULL, 0x000fe200078e0219ULL, 0x00000005041f7812ULL, 0x000fe200078e3cffULL,
0x0000001003037824ULL, 0x100fe200078e0202ULL, 0x0000000e0d0d723eULL, 0x000fe200000010ffULL,
0x00000008181d7824ULL, 0x040fe200078e021dULL, 0x0000000c0b0b723eULL, 0x000fe200000010ffULL,
0x00000008181f7824ULL, 0x000fe200078e021fULL, 0x0000000604217812ULL, 0x000fe200078e3cffULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0xfffffff80a237812ULL, 0x000fe200078ee23bULL,
0x0000001019197824ULL, 0x100fe200078e0202ULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x0000000818217824ULL, 0x000fe200078e0221ULL, 0x0000000110047812ULL, 0x040fe200078e3cffULL,
0x000000101d1d7824ULL, 0x100fe200078e0202ULL, 0x0000000210087812ULL, 0x040fe200078e3cffULL,
0x000000101f1f7824ULL, 0x000fe200078e0202ULL, 0x00000003100a7812ULL, 0x040fe200078e3cffULL,
0x000000083b257824ULL, 0x040fe200078e0204ULL, 0x00000004100c7812ULL, 0x040fe200078e3cffULL,
0x000000083b277824ULL, 0x040fe200078e0208ULL, 0x00000005100e7812ULL, 0x040fe200078e3cffULL,
0x000000083b297824ULL, 0x002fe200078e020aULL, 0x0000000610107812ULL, 0x000fe200078e3cffULL,
0x000000103d047824ULL, 0x100fe200078e0202ULL, 0x0000000c12167812ULL, 0x000fe200078ec0ffULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x000000333232723eULL, 0x000fe200000010ffULL,
0x000000083b337824ULL, 0x040fe200078e0210ULL, 0x000000313030723eULL, 0x000fe200000010ffULL,
0x000000083b317824ULL, 0x040fe200078e020eULL, 0x0000002f2e2e723eULL, 0x000fe200000010ffULL,
0x000000083b2f7824ULL, 0x000fe200078e020cULL, 0x000000373636723eULL, 0x000fe200000010ffULL,
0x0000000116037824ULL, 0x000fe200078e0203ULL, 0x000000353434723eULL, 0x000fe200000010ffULL,
0x0000000116057824ULL, 0x040fe200078e0205ULL, 0x0000002c2b2b723eULL, 0x000fe200000010ffULL,
0x0000000116077824ULL, 0x040fe200078e0207ULL, 0x0000003603007388ULL, 0x0003e20000000800ULL,
0x0000000116197824ULL, 0x000fe200078e0219ULL, 0x0000002a1b1b723eULL, 0x000fe200000010ffULL,
0x0000001023237824ULL, 0x100fe200078e0202ULL, 0x0000003405007388ULL, 0x0003e20000000800ULL,
0x0000001025257824ULL, 0x100fe200078e0202ULL, 0x0000001a1717723eULL, 0x000fe200000010ffULL,
0x0000001027277824ULL, 0x100fe200078e0202ULL, 0x0000003207007388ULL, 0x0003e20000000800ULL,
0x0000001029297824ULL, 0x100fe200078e0202ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0202ULL, 0x0000003019007388ULL, 0x0003e20000000800ULL,
0x0000001031317824ULL, 0x000fc400078e0202ULL, 0x0000001033337824ULL, 0x000fe400078e0202ULL,
0x00000001161d7824ULL, 0x040fe400078e021dULL, 0x0000000116087824ULL, 0x040fe400078e0204ULL,
0x0000000116027824ULL, 0x040fe200078e021fULL, 0x0000002e1d007388ULL, 0x0003e20000000800ULL,
0x0000000116047824ULL, 0x040fe400078e0221ULL, 0x00000001160a7824ULL, 0x040fe200078e0223ULL,
0x0000002b02007388ULL, 0x0003e20000000800ULL, 0x00000001160c7824ULL, 0x000fc400078e0225ULL,
0x00000001160e7824ULL, 0x040fe200078e0227ULL, 0x0000001b04007388ULL, 0x0003e20000000800ULL,
0x0000000116107824ULL, 0x040fe400078e0229ULL, 0x0000000116127824ULL, 0x040fe200078e022fULL,
0x0000001708007388ULL, 0x0003e20000000800ULL, 0x0000000116397824ULL, 0x040fe400078e0239ULL,
0x0000000116147824ULL, 0x040fe200078e0231ULL, 0x000000150a007388ULL, 0x0003e20000000800ULL,
0x0000000116167824ULL, 0x000fc600078e0233ULL, 0x000000130c007388ULL, 0x0003e80000000800ULL,
0x000000110e007388ULL, 0x0003e80000000800ULL, 0x0000000f10007388ULL, 0x0003e80000000800ULL,
0x0000000d12007388ULL, 0x0003e80000000800ULL, 0x0000000b14007388ULL, 0x0003e80000000800ULL,
0x0000000916007388ULL, 0x0003e80000000800ULL, 0x0000000639007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000147919ULL, 0x006e620000002600ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x0000580000057ab9ULL, 0x000fc40000000800ULL,
0x0000000000157919ULL, 0x000ee20000000000ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000001014037824ULL, 0x002fc600078e00ffULL, 0x00000004050472a4ULL, 0x004fe2000f8e023fULL,
0x0000001014067824ULL, 0x000fe200078e00ffULL, 0x00000003ff027819ULL, 0x008fe40000011615ULL,
0x0000002015167810ULL, 0x040fe40007ffe0ffULL, 0x0000004015177810ULL, 0x040fe40007ffe0ffULL,
0x0000006015207810ULL, 0x000fe40007ffe0ffULL, 0xfffffff003047812ULL, 0x000fc400078ee202ULL,
0x00000003ff037819ULL, 0x000fe40000011616ULL, 0x00000003ff077819ULL, 0x000fe40000011617ULL,
0x00000003ff0a7819ULL, 0x000fe40000011620ULL, 0x0000000702027812ULL, 0x000fe400078e4815ULL,
0x0000000703057812ULL, 0x000fe400078e4816ULL, 0xfffffff006067812ULL, 0x000fc400078ee203ULL,
0x0000000707087812ULL, 0x000fe400078e4817ULL, 0x000000070a0b7812ULL, 0x000fe400078e4820ULL,
0x0ffffff802037812ULL, 0x000fe400078ef815ULL, 0x0ffffff805057812ULL, 0x000fe400078ef816ULL,
0x0ffffff808097812ULL, 0x000fe200078ef817ULL, 0x00000010030c7824ULL, 0x000fe200078e0200ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef820ULL, 0x0000001005107824ULL, 0x100fe200078e0200ULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001009097824ULL, 0x100fe200078e0200ULL,
0x0000000715087812ULL, 0x000fe200078ec0ffULL, 0x000000100b1c7824ULL, 0x000fe200078e0200ULL,
0x00a000000c0c7984ULL, 0x000e620000000c00ULL, 0x0000001014007824ULL, 0x000fe200078e00ffULL,
0x1ffffff8080b7812ULL, 0x000fe200078ef82dULL, 0x0000001014057824ULL, 0x000fe200078e00ffULL,
0x00a0000010107984ULL, 0x000ea20000000c00ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0004027a11ULL, 0x000fc400078048ffULL, 0x00a0000009187984ULL, 0x0007220000000c00ULL,
0xfffffff000077812ULL, 0x000fe400078ee207ULL, 0x0000000716007812ULL, 0x000fe200078ec0ffULL,
0x00a000001c1c7984ULL, 0x000f620000000c00ULL, 0xfffffff005057812ULL, 0x000fe400078ee20aULL,
0x00005b0004037a11ULL, 0x000fe400000f4c03ULL, 0x0000000406167c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000717047812ULL, 0x000fe200078ec0ffULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x1ffffff800157812ULL, 0x000fc400078ef82dULL, 0x0000000407077c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000405007c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x1ffffff804177812ULL, 0x000fe200078ef82dULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x00005a0016047a11ULL, 0x000fe200078048ffULL, 0x000000ffff097224ULL, 0x008fe200010e06ffULL,
0x00005a0007067a11ULL, 0x000fe400078248ffULL, 0x00000007200a7812ULL, 0x000fc400078ec0ffULL,
0x00005a0000087a11ULL, 0x000fe400078448ffULL, 0x00005b0016057a11ULL, 0x000fe400000f4c05ULL,
0x00005b0007077a11ULL, 0x000fe200008f4c14ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x1ffffff80a2d7812ULL, 0x000fe200078ef82dULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x00005b0000097a11ULL, 0x000fc600010f4c09ULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x0000001004007986ULL, 0x004fe6000c101d06ULL, 0x000000102d087825ULL, 0x000fe200078e0008ULL,
0x0000001806007986ULL, 0x010fe8000c101d06ULL, 0x0000001c08007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff067624ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fe2000001165bULL, 0x00006900ff077624ULL, 0x000fc600078e00ffULL,
0x01ffffff00037812ULL, 0x000fe400078ec0ffULL, 0x00000006062e7981ULL, 0x000366000c1e9900ULL,
0x0000000264027824ULL, 0x000fca00078e0203ULL, 0x000000590200720cULL, 0x000fe40003f06070ULL,
0x0000000164007810ULL, 0x000fd60007ffe0ffULL, 0x000000023f038824ULL, 0x000fc800078e00ffULL,
0x0000640003048a24ULL, 0x000fe400078e0202ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000600004048625ULL, 0x000fca00078e0015ULL, 0x0000000604038981ULL, 0x000362000c1e1900ULL,
0x0000002f0000720cULL, 0x000fe20003f06070ULL, 0x000000405b2d7824ULL, 0x000fe400078e00ffULL,
0x000000802b2c7824ULL, 0x000fe400078e00ffULL, 0x00000100640b7824ULL, 0x000fe200078e022dULL,
0x0000000704047899ULL, 0x000fc8000800063fULL, 0x000000402c127812ULL, 0x000fc600078ef80bULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x002e620000000000ULL,
0x0000000403127c24ULL, 0x020fe2000f8e0212ULL, 0x0000000b5a007217ULL, 0x000fe20007800000ULL,
0x00000100ff1a7424ULL, 0x000fe200078e00ffULL, 0x000020005b157811ULL, 0x000fc600078e68ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x00000002ff1f7819ULL, 0x102fe20000011610ULL,
0x0000001010217824ULL, 0x000fe200078e00ffULL, 0x00000003ff137819ULL, 0x000fe40000011610ULL,
0x0000007f1f057812ULL, 0x040fe400078ec0ffULL, 0x000000081f0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000003021217812ULL, 0x000fe200078ec0ffULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x0000007f0f077812ULL, 0x040fe200078ec0ffULL, 0x000000040f147824ULL, 0x000fe200078e00ffULL,
0x000000101f237810ULL, 0x000fe20007ffe0ffULL, 0x00005e0005047625ULL, 0x000fe200078e001aULL,
0x000000181f257810ULL, 0x000fc40007ffe0ffULL, 0x0000007f23097812ULL, 0x000fe200078ec0ffULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0x00000021040a7210ULL, 0x080fe40007f1e0ffULL,
0x000000201f197810ULL, 0x000fe20007ffe0ffULL, 0x00005e0007067625ULL, 0x000fe200078e001aULL,
0x0000000313137812ULL, 0x000fe400078e4810ULL, 0x000000281f1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0605ULL, 0x0000007f25057812ULL, 0x000fe200078ec0ffULL,
0x0000000112097824ULL, 0x000fe200078e0209ULL, 0x00000021060c7210ULL, 0x000fc40007f1e0ffULL,
0x000000301f1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x000000002300720cULL, 0x000fe20003fa6070ULL, 0x00005e0009087625ULL, 0x000fe200078e001aULL,
0x000000002500720cULL, 0x000fc60003f86070ULL, 0x00005e0005047625ULL, 0x000fe200078e001aULL,
0x0000002108087210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0607ULL,
0x0000007f19077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x00000021040e7210ULL, 0x000fe20007f5e0ffULL, 0x000000041d167824ULL, 0x000fe200078e00ffULL,
0x000000001f00720cULL, 0x080fe20003f06070ULL, 0x0000000112077824ULL, 0x000fe200078e0207ULL,
0x000000000f00720cULL, 0x000fe20003f26070ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0605ULL,
0x0ffffffc13047812ULL, 0x000fe200078ef810ULL, 0x00005e0007067625ULL, 0x000fe200078e001aULL,
0x0000007f1b057812ULL, 0x000fc400078ec0ffULL, 0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001004177824ULL, 0x000fe200078e0215ULL, 0x0000002106107210ULL, 0x000fe20007f7e0ffULL,
0x0000000112057824ULL, 0x000fe200078e0205ULL, 0xfffffffc14067812ULL, 0x000fe200078ee213ULL,
0x000000041b147824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a177faeULL, 0x0003e2000c101c46ULL, 0x00005e0005047625ULL, 0x000fe200078e001aULL,
0x000000001b00720cULL, 0x080fe40003f46070ULL, 0x000000001f00720cULL, 0x080fe20003f06070ULL,
0x000000ffff117224ULL, 0x000fe200018e0607ULL, 0x000000001900720cULL, 0x000fe20003f66070ULL,
0x0000001006077824ULL, 0x000fe200078e0215ULL, 0xfffffffc14147812ULL, 0x100fe200078ee213ULL,
0x000000041f187824ULL, 0x000fe200078e00ffULL, 0xfffffffc16167812ULL, 0x000fc400078ee213ULL,
0x0000007f1d0b7812ULL, 0x042fe200078ec0ffULL, 0x000000000c077faeULL, 0x0003e2000c901c46ULL,
0x00000021040a7210ULL, 0x000fe20007fde0ffULL, 0x00000010161b7824ULL, 0x000fe200078e0215ULL,
0x000000001d00720cULL, 0x000fe20003f26070ULL, 0x0000000112047824ULL, 0x000fe200078e020bULL,
0xfffffffc18187812ULL, 0x000fe200078ee213ULL, 0x000000ffff0b7224ULL, 0x000fe400030e0605ULL,
0x00005e0004047625ULL, 0x000fe200078e001aULL, 0x0000007f1f077812ULL, 0x002fc600078ec0ffULL,
0x0000000423007824ULL, 0x000fe200078e00ffULL, 0x0000002104047210ULL, 0x000fe20007fde0ffULL,
0x00000004250c7824ULL, 0x000fe400078e00ffULL, 0x0000000112077824ULL, 0x000fe200078e0207ULL,
0xfffffffc00007812ULL, 0x100fe200078ee213ULL, 0x0000000419127824ULL, 0x000fe200078e00ffULL,
0xfffffffc0c0c7812ULL, 0x000fe200078ee213ULL, 0x00005e0007067625ULL, 0x000fc600078e001aULL,
0xfffffffc12127812ULL, 0x000fe200078ee213ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000002106067210ULL, 0x000fe20007fde0ffULL, 0x00000010000d7824ULL, 0x100fe400078e0215ULL,
0x000000100c137824ULL, 0x100fe400078e0215ULL, 0x0000001012177824ULL, 0x100fe200078e0215ULL,
0x00000000080d7faeULL, 0x0003e2000e901c46ULL, 0x0000001014197824ULL, 0x100fe400078e0215ULL,
0x0000001018157824ULL, 0x000fe200078e0215ULL, 0x000000000e137faeULL, 0x0003e2000e101c46ULL,
0x000000ffff077224ULL, 0x000fc600030e0607ULL, 0x0000000010177faeULL, 0x0003e8000d901c46ULL,
0x000000000a197faeULL, 0x0003e8000d101c46ULL, 0x00000000041b7faeULL, 0x0003e8000c901c46ULL,
0x0000000006157faeULL, 0x0003e2000c101c46ULL, 0x000005a000007947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x002e620000000000ULL, 0x0000000403127c24ULL, 0x020fe2000f8e0212ULL,
0x00000002ff047819ULL, 0x002fc40000011600ULL, 0x00000003ff057819ULL, 0x000fe40000011600ULL,
0x0000007f04077812ULL, 0x040fe400078ec0ffULL, 0x0000000804067810ULL, 0x040fe40007ffe0ffULL,
0x0000001004097810ULL, 0x040fe40007ffe0ffULL, 0x00000018040c7810ULL, 0x040fe40007ffe0ffULL,
0x00000020040f7810ULL, 0x000fc40007ffe0ffULL, 0x0000002804107810ULL, 0x000fe20007ffe0ffULL,
0x000000040c1c7824ULL, 0x000fe200078e00ffULL, 0x0000003004157810ULL, 0x040fe20007ffe0ffULL,
0x000000040f207824ULL, 0x000fe200078e00ffULL, 0x0000003804187810ULL, 0x000fe20007ffe0ffULL,
0x0000000112047824ULL, 0x000fe200078e0207ULL, 0x0000007f06077812ULL, 0x040fe200078ec0ffULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x0000007f090b7812ULL, 0x000fe200078ec0ffULL,
0x0000000410227824ULL, 0x000fe200078e00ffULL, 0x0000007f0c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000112087824ULL, 0x040fe200078e0207ULL, 0x0000007f0f117812ULL, 0x000fe200078ec0ffULL,
0x00000001120a7824ULL, 0x000fe200078e020bULL, 0x0000007f10137812ULL, 0x000fe200078ec0ffULL,
0x00000001120e7824ULL, 0x040fe200078e020dULL, 0x0000007f15177812ULL, 0x000fe200078ec0ffULL,
0x0000000112147824ULL, 0x000fe200078e0211ULL, 0x0000007f18197812ULL, 0x000fe200078ec0ffULL,
0x0000000112167824ULL, 0x040fe200078e0213ULL, 0x0000000305077812ULL, 0x100fe200078e4800ULL,
0x00000001121a7824ULL, 0x040fe200078e0217ULL, 0x000020005b0b7811ULL, 0x000fe200078e68ffULL,
0x00000001121e7824ULL, 0x000fe200078e0219ULL, 0xfffffffc06067812ULL, 0x100fe200078ee207ULL,
0x0000000409127824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c107812ULL, 0x100fe200078ee207ULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0ffffffc07007812ULL, 0x000fe200078ef800ULL,
0x0000000415247824ULL, 0x000fe200078e00ffULL, 0xfffffffc120c7812ULL, 0x100fe200078ee207ULL,
0x0000000418267824ULL, 0x000fe200078e00ffULL, 0xfffffffc20127812ULL, 0x000fe200078ee207ULL,
0x00000100ff137424ULL, 0x000fe200078e00ffULL, 0x0000003005157812ULL, 0x000fe200078ec0ffULL,
0x0000001006197824ULL, 0x000fe200078e020bULL, 0xfffffffc22187812ULL, 0x100fe200078ee207ULL,
0x00005e0004047625ULL, 0x000fe200078e0013ULL, 0xfffffffc241c7812ULL, 0x000fc400078ee207ULL,
0xfffffffc26207812ULL, 0x000fe200078ee207ULL, 0x00005e0008067625ULL, 0x000fe200078e0013ULL,
0x0000001504047210ULL, 0x000fc60007f1e0ffULL, 0x0000001000177824ULL, 0x100fe200078e020bULL,
0x0000001506067210ULL, 0x000fe20007f3e0ffULL, 0x000000100c1b7824ULL, 0x100fe400078e020bULL,
0x00000010101d7824ULL, 0x100fe400078e020bULL, 0x00000010121f7824ULL, 0x100fe400078e020bULL,
0x0000001018217824ULL, 0x000fe400078e020bULL, 0x00005e000a087625ULL, 0x000fc800078e0013ULL,
0x000000101c237824ULL, 0x100fe200078e020bULL, 0x0000001508087210ULL, 0x000fe20007f5e0ffULL,
0x0000001020257824ULL, 0x000fe400078e020bULL, 0x00005e000e0a7625ULL, 0x000fc800078e0013ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000150a0a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e00140c7625ULL, 0x000fc600078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004177faeULL, 0x0003e2000b901c46ULL, 0x00005e00160e7625ULL, 0x000fc800078e0013ULL,
0x00005e001a107625ULL, 0x000fc800078e0013ULL, 0x00005e001e127625ULL, 0x000fc800078e0013ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x000000150c0c7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x000000150e0e7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000001510107210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000001512127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x0000000006197faeULL, 0x0003e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fc400010e0611ULL, 0x000000ffff137224ULL, 0x000fe200018e0613ULL,
0x00000000081b7faeULL, 0x0003e8000b901c46ULL, 0x000000000a1d7faeULL, 0x0003e8000b901c46ULL,
0x000000000c1f7faeULL, 0x0003e8000b901c46ULL, 0x000000000e217faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e8000b901c46ULL, 0x0000000012257faeULL, 0x0003e4000b901c46ULL,
0x01060400ff007984ULL, 0x000ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x004fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01060400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000035b00780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x000000205b007824ULL, 0x004fc800078e0200ULL, 0x0000002000067824ULL, 0x002fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000001e006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105097812ULL, 0x040fe400078efcffULL,
0x0000000705077812ULL, 0x100fe400078e7800ULL, 0x0000000709097812ULL, 0x100fe400078e7800ULL,
0x00000010050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x040fe200078e0207ULL,
0x0000001105057810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x000000070b0b7812ULL, 0x000fc400078e7800ULL, 0x0000000007107984ULL, 0x000e62000000cc00ULL,
0x0000000705057812ULL, 0x000fe400078e7800ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x00000000090c7984ULL, 0x000ea4000000cc00ULL, 0x0000000106057824ULL, 0x000fe400078e0205ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fe200078e0013ULL,
0x0000001407007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fca00078e000fULL, 0x0000001809007388ULL, 0x000fe8000000cc00ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x000000000b107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c0b007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01060400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01060400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000002f6400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000387919ULL, 0x000ea20000000000ULL,
0x3d8000002e2e7820ULL, 0x000fe20000410000ULL, 0x000064003f3f7a24ULL, 0x000fe200078e02ffULL,
0xffffffff2f3b7810ULL, 0x000fe20007ffe0ffULL, 0x000000105b3d7824ULL, 0x000fe200078e00ffULL,
0x00007610ff3a7816ULL, 0x000fe2000000003aULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000704047899ULL, 0x000fe4000800063fULL,
0x0000010064397824ULL, 0x000fe200078e022dULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000395a00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff007224ULL, 0x000fe200078e003cULL, 0x0000000000207805ULL, 0x002fe2000001ff00ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x000000013e247810ULL, 0x000fe20007ffe0ffULL, 0x00000bd000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e003eULL, 0x00000001003c7812ULL, 0x000fc400078e0cffULL,
0x00000002ff257819ULL, 0x100fe20000011624ULL, 0x000000ffff3e7224ULL, 0x000fe200078e0024ULL,
0x000000042400780cULL, 0x040fe40003f06070ULL, 0x0000000324537812ULL, 0x000fe200078ec0ffULL,
0x0000030025267a24ULL, 0x000fc800078e0264ULL, 0x0000010026277824ULL, 0x040fe200078e022dULL,
0x0000000126287810ULL, 0x000fc80007ffe0ffULL, 0x0000002f2800720cULL, 0x000fe40003f26070ULL,
0x0000004027257812ULL, 0x000fca00078ec0ffULL, 0x000000012c267824ULL, 0x000fcc00078e0225ULL,
0x000005d000009947ULL, 0x020fea0003800000ULL, 0x000000275a247217ULL, 0x000fe20007800000ULL,
0x0000000403297c24ULL, 0x000fe2000f8e0226ULL, 0x00000002ff337819ULL, 0x104fe20000011638ULL,
0x0000000453357824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x000fe20000011638ULL,
0x0000000124287824ULL, 0x000fe200078e0a27ULL, 0x0000007f33247812ULL, 0x000fe200078ec0ffULL,
0x000000025b2a7824ULL, 0x000fe200078e023cULL, 0x0000000833277810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff4b7424ULL, 0x000fe200078e00ffULL, 0x0000000325377812ULL, 0x100fe200078e4838ULL,
0x0000000124247824ULL, 0x000fe200078e0229ULL, 0x0000007f27267812ULL, 0x040fe200078ec0ffULL,
0x0000000427307824ULL, 0x000fe200078e00ffULL, 0x000000283300720cULL, 0x000fe20003f26070ULL,
0x00005e0024247625ULL, 0x000fe200078e004bULL, 0xfffffffc35357812ULL, 0x000fc400078ee238ULL,
0x000020002a2a7811ULL, 0x000fe200078e60ffULL, 0x0000000126267824ULL, 0x000fe200078e0229ULL,
0x0ffffffc372b7812ULL, 0x000fe200078ef838ULL, 0x0000001035247825ULL, 0x000fe200078e0024ULL,
0x0000002833477810ULL, 0x000fe40007ffe0ffULL, 0x000000282700720cULL, 0x000fe20003f46070ULL,
0x00005e0026267625ULL, 0x000fe200078e004bULL, 0x0000001033417810ULL, 0x040fe40007ffe0ffULL,
0x0000001833437810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e022aULL,
0x0000002033457810ULL, 0x000fe20007ffe0ffULL, 0x0000001035267825ULL, 0x000fe200078e0026ULL,
0x0000003033497810ULL, 0x000fc40007ffe0ffULL, 0x0000003833337810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000c901c46ULL,
0xfffffffc30317812ULL, 0x000fe200078ee237ULL, 0x0000000443367824ULL, 0x000fe200078e00ffULL,
0x0000007f47307812ULL, 0x000fe200078ec0ffULL, 0x0000000445427824ULL, 0x000fe200078e00ffULL,
0x0000007f49327812ULL, 0x000fe200078ec0ffULL, 0x0000001031317824ULL, 0x000fe200078e022aULL,
0x0000007f33347812ULL, 0x000fe200078ec0ffULL, 0x0000000447447824ULL, 0x000fe200078e00ffULL,
0x000000284100720cULL, 0x080fe20003f26070ULL, 0x0000000449467824ULL, 0x000fe200078e00ffULL,
0x0000000026317faeULL, 0x0005e2000d101c46ULL, 0x00000001302b7824ULL, 0x102fe200078e0229ULL,
0x0000007f41247812ULL, 0x000fe200078ec0ffULL, 0x0000000132307824ULL, 0x100fe200078e0229ULL,
0x000000284300720cULL, 0x080fe20003f46070ULL, 0x0000000134327824ULL, 0x100fe200078e0229ULL,
0x000000284500720cULL, 0x080fe20003f66070ULL, 0x0000000441347824ULL, 0x000fe200078e00ffULL,
0x000000284700720cULL, 0x080fe20003f86070ULL, 0x0000000433487824ULL, 0x000fe200078e00ffULL,
0x000000284900720cULL, 0x080fe20003fa6070ULL, 0x0000000124247824ULL, 0x000fe200078e0229ULL,
0x000000283300720cULL, 0x000fe20003fc6070ULL, 0x00005e0030307625ULL, 0x004fe200078e004bULL,
0x0000007f43267812ULL, 0x000fc400078ec0ffULL, 0x0000007f45287812ULL, 0x000fe200078ec0ffULL,
0x00005e0032327625ULL, 0x080fe200078e004bULL, 0xfffffffc34257812ULL, 0x100fe400078ee237ULL,
0xfffffffc36417812ULL, 0x000fe200078ee237ULL, 0x0000000126267824ULL, 0x000fe200078e0229ULL,
0xfffffffc42437812ULL, 0x000fe200078ee237ULL, 0x0000000128287824ULL, 0x000fe200078e0229ULL,
0xfffffffc44457812ULL, 0x100fe200078ee237ULL, 0x00005e0026267625ULL, 0x000fe200078e004bULL,
0xfffffffc46477812ULL, 0x000fc400078ee237ULL, 0xfffffffc48497812ULL, 0x000fe200078ee237ULL,
0x0000001025377824ULL, 0x000fe400078e022aULL, 0x00005e0024247625ULL, 0x000fc800078e004bULL,
0x0000001041417824ULL, 0x100fe400078e022aULL, 0x0000001043437824ULL, 0x100fe400078e022aULL,
0x0000001045457824ULL, 0x100fe400078e022aULL, 0x0000001047477824ULL, 0x100fe400078e022aULL,
0x0000001049497824ULL, 0x000fe400078e022aULL, 0x00005e0028287625ULL, 0x000fc800078e004bULL,
0x00005e002b2a7625ULL, 0x000fc800078e004bULL, 0x0000001035247825ULL, 0x000fc800078e0024ULL,
0x0000001035267825ULL, 0x040fe200078e0026ULL, 0x0000000024377faeULL, 0x0003e6000c901c46ULL,
0x0000001035287825ULL, 0x040fe200078e0028ULL, 0x0000000026417faeULL, 0x0003e6000d101c46ULL,
0x00000010352a7825ULL, 0x040fe200078e002aULL, 0x0000000028437faeULL, 0x0003e6000d901c46ULL,
0x0000001035307825ULL, 0x040fe200078e0030ULL, 0x000000002a457faeULL, 0x0003e6000e101c46ULL,
0x0000001035327825ULL, 0x000fe200078e0032ULL, 0x0000000030477faeULL, 0x0003e8000e901c46ULL,
0x0000000032497faeULL, 0x0003e2000f101c46ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x004fe20000011638ULL, 0x0000000403267c24ULL, 0x000fc6000f8e0226ULL,
0x0000007f24257812ULL, 0x040fe400078ec0ffULL, 0x0000000824287810ULL, 0x040fe40007ffe0ffULL,
0x00000010242b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001824317810ULL, 0x040fe40007ffe0ffULL,
0x0000002024327810ULL, 0x040fe20007ffe0ffULL, 0x000000042b447824ULL, 0x000fe200078e00ffULL,
0x0000002824357810ULL, 0x040fe20007ffe0ffULL, 0x0000000431487824ULL, 0x000fe200078e00ffULL,
0x0000003024367810ULL, 0x000fe20007ffe0ffULL, 0x00000004324c7824ULL, 0x000fe200078e00ffULL,
0x0000003824437810ULL, 0x000fe20007ffe0ffULL, 0x0000000125247824ULL, 0x100fe200078e0226ULL,
0x0000007f28257812ULL, 0x040fe200078ec0ffULL, 0x0000000435507824ULL, 0x000fe200078e00ffULL,
0x0000007f2b277812ULL, 0x000fe200078ec0ffULL, 0x0000000428287824ULL, 0x000fe200078e00ffULL,
0x0000007f31297812ULL, 0x000fe200078ec0ffULL, 0x00000001252a7824ULL, 0x100fe200078e0226ULL,
0x0000007f32337812ULL, 0x000fe200078ec0ffULL, 0x0000000127307824ULL, 0x100fe200078e0226ULL,
0x0000007f35377812ULL, 0x000fe200078ec0ffULL, 0x0000000129347824ULL, 0x100fe200078e0226ULL,
0x0000007f36417812ULL, 0x000fe200078ec0ffULL, 0x0000000133427824ULL, 0x100fe200078e0226ULL,
0x0000007f43457812ULL, 0x000fe200078ec0ffULL, 0x0000000137467824ULL, 0x000fe200078e0226ULL,
0x00000003ff257819ULL, 0x000fe20000011638ULL, 0x00000001414a7824ULL, 0x000fc400078e0226ULL,
0x00000001454e7824ULL, 0x000fe200078e0226ULL, 0x0000000325277812ULL, 0x000fe200078e4838ULL,
0x000000025b267824ULL, 0x000fe400078e023cULL, 0x0000000436527824ULL, 0x000fe200078e00ffULL,
0xfffffffc44327812ULL, 0x100fe200078ee227ULL, 0x0000000443547824ULL, 0x000fe200078e00ffULL,
0x0000200026297811ULL, 0x000fe200078e60ffULL, 0x0000000453417824ULL, 0x000fe200078e00ffULL,
0xfffffffc48367812ULL, 0x000fe200078ee227ULL, 0x00000100ff377424ULL, 0x000fe200078e00ffULL,
0x0ffffffc27267812ULL, 0x000fe200078ef838ULL, 0x0000001032477824ULL, 0x000fe200078e0229ULL,
0xfffffffc4c447812ULL, 0x100fe200078ee227ULL, 0x00005e0024247625ULL, 0x000fe200078e0037ULL,
0xfffffffc50487812ULL, 0x000fc400078ee227ULL, 0xfffffffc28287812ULL, 0x000fe200078ee227ULL,
0x0000001026437824ULL, 0x000fe200078e0229ULL, 0xfffffffc524c7812ULL, 0x000fe200078ee227ULL,
0x0000001036497824ULL, 0x000fe200078e0229ULL, 0xfffffffc54507812ULL, 0x000fe200078ee227ULL,
0x0000001028457824ULL, 0x100fe200078e0229ULL, 0xfffffffc41417812ULL, 0x000fe200078ee238ULL,
0x00000010444b7824ULL, 0x100fe400078e0229ULL, 0x00000010484d7824ULL, 0x100fe400078e0229ULL,
0x000000104c4f7824ULL, 0x000fc400078e0229ULL, 0x0000001050517824ULL, 0x000fe400078e0229ULL,
0x00005e002a267625ULL, 0x000fc800078e0037ULL, 0x00005e0030287625ULL, 0x000fc800078e0037ULL,
0x00005e00342a7625ULL, 0x000fc800078e0037ULL, 0x00005e0042307625ULL, 0x000fc800078e0037ULL,
0x00005e0046327625ULL, 0x000fc800078e0037ULL, 0x0000001041247825ULL, 0x000fc800078e0024ULL,
0x00005e004a347625ULL, 0x080fe200078e0037ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024437faeULL, 0x0003e6000b901c46ULL, 0x00005e004e367625ULL, 0x000fc800078e0037ULL,
0x0000001041267825ULL, 0x000fc800078e0026ULL, 0x0000001041287825ULL, 0x040fe200078e0028ULL,
0x0000000026457faeULL, 0x0003e6000b901c46ULL, 0x00000010412a7825ULL, 0x040fe200078e002aULL,
0x0000000028477faeULL, 0x0003e6000b901c46ULL, 0x0000001041307825ULL, 0x040fe200078e0030ULL,
0x000000002a497faeULL, 0x0003e6000b901c46ULL, 0x0000001041327825ULL, 0x040fe200078e0032ULL,
0x00000000304b7faeULL, 0x0003e6000b901c46ULL, 0x0000001041347825ULL, 0x040fe200078e0034ULL,
0x00000000324d7faeULL, 0x0003e6000b901c46ULL, 0x0000001041367825ULL, 0x000fe200078e0036ULL,
0x00000000344f7faeULL, 0x0003e8000b901c46ULL, 0x0000000036517faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000035300780cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x00000300ff037624ULL, 0x000fc800078e00ffULL, 0x0000000203027824ULL, 0x000fe400078e0202ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x000000590200720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000023f247824ULL, 0x002fe400078e0202ULL,
0x00000004ff257424ULL, 0x000fc800078e00ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x0000000624037981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000840457824ULL, 0x002fe400078e00ffULL,
0x000000ffff437224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff838257812ULL, 0x000fe200078ec0ffULL, 0x000000025b297824ULL, 0x000fe200078e0200ULL,
0x00000001432b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000725257812ULL, 0x000fe400078ef838ULL, 0x0000200029297811ULL, 0x000fc400078e60ffULL,
0x00000001ff247819ULL, 0x000fe40000011625ULL, 0x0000000738cf7812ULL, 0x000fe400078ec0ffULL,
0x0000000324247812ULL, 0x000fe400078ec0ffULL, 0x00000008cfcf7812ULL, 0x000fe400078ef838ULL,
0x0000004324267212ULL, 0x040fe400078e3cffULL, 0x0000002b24247212ULL, 0x000fc600078e3cffULL,
0x0000000425267824ULL, 0x040fe400078e0226ULL, 0x0000000425247824ULL, 0x000fe200078e0224ULL,
0x0000002038257810ULL, 0x000fe20007ffe0ffULL, 0x0000001026267824ULL, 0x100fe400078e0229ULL,
0x0000001024247824ULL, 0x000fe200078e0229ULL, 0xfffffff825257812ULL, 0x000fe400078ec0ffULL,
0x000000002634783bULL, 0x000e640000000200ULL, 0x0000000725287812ULL, 0x000fc400078ef838ULL,
0x000000002430783bULL, 0x0004e40000000200ULL, 0x00000001ff247819ULL, 0x004fc80000011628ULL,
0x00000003242a7812ULL, 0x000fc800078ec0ffULL, 0x000000432a257212ULL, 0x040fe400078e3cffULL,
0x0000002b2a2b7212ULL, 0x000fe400078e3cffULL, 0x0000000243437810ULL, 0x000fe20007ffe0ffULL,
0x0000000428247824ULL, 0x040fe400078e0225ULL, 0x0000000428287824ULL, 0x000fe400078e022bULL,
0x0000001024247824ULL, 0x100fe400078e0229ULL, 0x0000001028287824ULL, 0x000fc800078e0229ULL,
0x000000002424783bULL, 0x000ea80000000200ULL, 0x000000002828783bULL, 0x000f220000000200ULL,
0x0000003400747306ULL, 0x002fe20000009400ULL, 0x00000018ffab7819ULL, 0x000fe20000011434ULL,
0x00010000345f7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe20000011435ULL,
0x0000010036af7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011436ULL,
0x0001000037ae7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe2000001145fULL,
0x0000003400b37306ULL, 0x000e620000005400ULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000010037aa7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011437ULL,
0x00010000307b7824ULL, 0x048fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x00010000317e7824ULL, 0x040fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x00000034005e7306ULL, 0x0006a2000000d400ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000010030807824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000010031817824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011430ULL,
0x0001000032757824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x000000b200b47306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x008fe200078e00ffULL,
0x000000b37400720bULL, 0x002fe20003f9d000ULL, 0x00000100326d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fc40000011432ULL, 0x00000018ffb67819ULL, 0x000fe20000011434ULL,
0x0001000035347824ULL, 0x000fe200078e00ffULL, 0x000000b200b57306ULL, 0x000e620000205400ULL,
0x00000018ff817819ULL, 0x000fe40000011481ULL, 0x00000018ff9c7819ULL, 0x004fe20000011424ULL,
0x0001000024c87824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe20000011434ULL,
0x0001000036347824ULL, 0x000fe200078e00ffULL, 0x000000015e5e4812ULL, 0x000fe200078efcffULL,
0x000000b600b77306ULL, 0x000fe20000209400ULL, 0x00000018ffc87819ULL, 0x000fc400000114c8ULL,
0x00000018ffc17819ULL, 0x000fe40000011434ULL, 0x00000018ff997819ULL, 0x000fe40000011425ULL,
0x00000018ff967819ULL, 0x000fe20000011426ULL, 0x000000b600b87306ULL, 0x000ea20000205400ULL,
0x000000b5b400720bULL, 0x002fe20003f5d000ULL, 0x0000010027b57824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011427ULL, 0x00000018ff637819ULL, 0x000fc40000011431ULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x0000003500a67306ULL, 0x000fe20000009400ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x00000018ff4c7819ULL, 0x000fc60000011433ULL, 0x0000003500a57306ULL, 0x000e620000005400ULL,
0x000000b8b700720bULL, 0x004fce0003f7d000ULL, 0x00000035005c7306ULL, 0x0004f0000000d400ULL,
0x000000ab00b97306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x004fe200078e00ffULL,
0x000000a5a600720bULL, 0x002fc40003f3d000ULL, 0x000000b600a67245ULL, 0x000fe4000020d400ULL,
0x00000018ffbe7819ULL, 0x000fe40000011435ULL, 0x000000ab00ba7306ULL, 0x0002a20000205400ULL,
0x000000b200a57245ULL, 0x000fe4000020d400ULL, 0x00000001a6a63812ULL, 0x000fe400078efcffULL,
0x00000001a5a52812ULL, 0x000fe400078efcffULL, 0x000000015c5c1812ULL, 0x008fe200078efcffULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fce000020d400ULL,
0x000000bb00bd7306ULL, 0x000e620000205400ULL, 0x000000bab900720bULL, 0x004fce0003fdd000ULL,
0x000000a300ad7306ULL, 0x000fec0000209400ULL, 0x00000001abab6812ULL, 0x000fe400078efcffULL,
0x000000a300ac7306ULL, 0x000ea20000205400ULL, 0x000000bdbc00720bULL, 0x002fe40003fbd000ULL,
0x000000a6abab723eULL, 0x000fca00000010ffULL, 0x000000be00bf7306ULL, 0x000ff00000209400ULL,
0x000000be00c07306ULL, 0x000e620000205400ULL, 0x000000acad00720bULL, 0x004fce0003f9d000ULL,
0x0000003600a47306ULL, 0x000ff00000009400ULL, 0x0000003600a77306ULL, 0x000ea20000005400ULL,
0x000000c0bf00720bULL, 0x002fce0003f7d000ULL, 0x0000003700a17306ULL, 0x000ff00000009400ULL,
0x0000003700a27306ULL, 0x000e620000005400ULL, 0x000000a7a400720bULL, 0x004fe20003f5d000ULL,
0x0001000026a47824ULL, 0x000fe200078e00ffULL, 0x000000bb00a77245ULL, 0x000fc8000020d400ULL,
0x00000001a7a75812ULL, 0x000fe200078efcffULL, 0x00000030009d7306ULL, 0x000fe20000009400ULL,
0x00000018ffa47819ULL, 0x000fce00000114a4ULL, 0x0000003000a07306ULL, 0x000ea20000005400ULL,
0x000000a2a100720bULL, 0x002fe40003fdd000ULL, 0x000000be00a17245ULL, 0x000fe4000020d400ULL,
0x0000009300a27245ULL, 0x000fe4000020d400ULL, 0x00000001a1a13812ULL, 0x000fe200078efcffULL,
0x000000c100c27306ULL, 0x000ff00000209400ULL, 0x000000c100c37306ULL, 0x000e620000205400ULL,
0x000000a09d00720bULL, 0x004fc40003f3d000ULL, 0x000000a300a07245ULL, 0x000fe4000020d400ULL,
0x000000af009d7245ULL, 0x000fe4000020d400ULL, 0x00000001a0a04812ULL, 0x000fe200078efcffULL,
0x00000093009f7306ULL, 0x000ff00000209400ULL, 0x00000093009e7306ULL, 0x000ea20000205400ULL,
0x000000c3c200720bULL, 0x002fce0003fbd000ULL, 0x000000af00c47306ULL, 0x000ff00000209400ULL,
0x000000af00c57306ULL, 0x0002e20000205400ULL, 0x0000009e9f00720bULL, 0x004fe20003f9d000ULL,
0x00010000279f7824ULL, 0x000fe200078e00ffULL, 0x000000c1009e7245ULL, 0x000fc8000020d400ULL,
0x000000019e9e5812ULL, 0x000fe200078efcffULL, 0x00000024008d7306ULL, 0x000fe20000009400ULL,
0x0000008800af7245ULL, 0x002fe4000020d400ULL, 0x00000018ff9f7819ULL, 0x000fc6000001149fULL,
0x00000001a2a24812ULL, 0x000fe400078efcffULL, 0x0000002400947306ULL, 0x000fe20000005400ULL,
0x000000c5c400720bULL, 0x008fce0003f7d000ULL, 0x0000002400527306ULL, 0x0003ec000000d400ULL,
0x000000019d9d3812ULL, 0x000fe400078efcffULL, 0x0000003600577306ULL, 0x0004e2000000d400ULL,
0x0000010024247824ULL, 0x002fca00078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x000fe200078e00ffULL, 0x0000008800957306ULL, 0x000fe20000209400ULL,
0x0000010033367824ULL, 0x004fc600078e00ffULL, 0x00000018ffce7819ULL, 0x000fe40000011424ULL,
0x0000004538247211ULL, 0x000fe400078fe0ffULL, 0x0000008800927306ULL, 0x000e620000205400ULL,
0x0000000157572812ULL, 0x008fe400078efcffULL, 0x0000000224747810ULL, 0x040fe40007ffe0ffULL,
0x0000000724247812ULL, 0x100fe400078e78cfULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x000000ae00c67306ULL, 0x000fe20000209400ULL, 0x0000000774747812ULL, 0x000fe200078e78cfULL,
0x00000020cf247824ULL, 0x000fe200078e0224ULL, 0x0000000445457810ULL, 0x000fc60007ffe0ffULL,
0x0000001024247824ULL, 0x000fe400078e00ffULL, 0x000000ae00c77306ULL, 0x0004e20000205400ULL,
0x000000929500720bULL, 0x002fe20003f5d000ULL, 0x00000020cf747824ULL, 0x000fe200078e0274ULL,
0x000000aa00927245ULL, 0x000fe4000020d400ULL, 0x0000009600957245ULL, 0x000fc6000020d400ULL,
0x000000aa00b17306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x004fca000020d400ULL,
0x00000001afaf2812ULL, 0x000fe400078efcffULL, 0x000000aa00b07306ULL, 0x0002a20000205400ULL,
0x000000c7c600720bULL, 0x008fce0003fbd000ULL, 0x000000c800c97306ULL, 0x000fe20000209400ULL,
0x0000005ea5aa723eULL, 0x002fe400000010ffULL, 0x00000063005e7245ULL, 0x000fc6000020d400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x000000c800ca7306ULL, 0x000e620000205400ULL,
0x000000b0b100720bULL, 0x004fe40003f7d000ULL, 0x000000948d00720bULL, 0x000fe40003fbd000ULL,
0x000000c8008d7245ULL, 0x000fe4000020d400ULL, 0x000000a400947245ULL, 0x000fe2000020d400ULL,
0x0000003700537306ULL, 0x0004ec000000d400ULL, 0x0000000192923812ULL, 0x000fc400078efcffULL,
0x0000009c00a97306ULL, 0x000fe20000209400ULL, 0x000000cac900720bULL, 0x002fe20003f9d000ULL,
0x0001000033377824ULL, 0x004fe200078e00ffULL, 0x0000000152525812ULL, 0x000fe400078efcffULL,
0x00000092afaf723eULL, 0x000fe400000010ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000009c00a87306ULL, 0x0002a20000205400ULL, 0x0000000153536812ULL, 0x008fc800078efcffULL,
0x00000053aeae723eULL, 0x000fe400000010ffULL, 0x000000018d8d4812ULL, 0x000fe200078efcffULL,
0x000000ce00b37306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fe4000020d400ULL,
0x000000528d52723eULL, 0x000fca00000010ffULL, 0x000000ce00b47306ULL, 0x000e620000205400ULL,
0x000000a8a900720bULL, 0x004fce0003fdd000ULL, 0x00000025008e7306ULL, 0x000fec0000009400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x0000002500897306ULL, 0x000ea20000005400ULL,
0x000000b4b300720bULL, 0x002fce0003f5d000ULL, 0x000000cb00cc7306ULL, 0x000ff00000209400ULL,
0x000000cb00cd7306ULL, 0x0002e20000205400ULL, 0x000000898e00720bULL, 0x004fe40003f9d000ULL,
0x000000ce008e7245ULL, 0x000fc8000020d400ULL, 0x000000018e8e2812ULL, 0x000fe200078efcffULL,
0x00000099009a7306ULL, 0x000fe20000209400ULL, 0x000000cb00cb7245ULL, 0x002fce000020d400ULL,
0x00000099009b7306ULL, 0x0002a20000205400ULL, 0x000000cdcc00720bULL, 0x008fce0003f7d000ULL,
0x000000a400ac7306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x00000001cbcb3812ULL, 0x000fe400078efcffULL, 0x000000a400a37306ULL, 0x000e620000205400ULL,
0x0000009b9a00720bULL, 0x004fe40003fdd000ULL, 0x000000cb9c53723eULL, 0x000fca00000010ffULL,
0x0000002600857306ULL, 0x000fec0000009400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x0000002600867306ULL, 0x000ea20000005400ULL, 0x000000a3ac00720bULL, 0x002fce0003f5d000ULL,
0x00000026004b7306ULL, 0x0002ec000000d400ULL, 0x0000000194942812ULL, 0x000fe400078efcffULL,
0x0000009f00937306ULL, 0x000fe20000209400ULL, 0x0000010026267824ULL, 0x002fe200078e00ffULL,
0x000000868500720bULL, 0x004fc40003f7d000ULL, 0x00000018ff857819ULL, 0x010fe4000001142aULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000009f00a87306ULL, 0x0002ae0000205400ULL,
0x000000014b4b3812ULL, 0x008fe200078efcffULL, 0x0000002500517306ULL, 0x000722000000d400ULL,
0x0000009f009f7245ULL, 0x002fc4000020d400ULL, 0x0000004b9494723eULL, 0x000fca00000010ffULL,
0x0000002700797306ULL, 0x000fe20000009400ULL, 0x0000010025257824ULL, 0x008fe200078e00ffULL,
0x000000a89300720bULL, 0x004fc80003fdd000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000027007a7306ULL, 0x000e620000005400ULL, 0x0000000151514812ULL, 0x010fe400078efcffULL,
0x0000002500887245ULL, 0x000fe4000020d400ULL, 0x000000518e8e723eULL, 0x000fe400000010ffULL,
0x000000019f9f6812ULL, 0x000fe200078efcffULL, 0x00000027004a7306ULL, 0x000eb0000000d400ULL,
0x0000002600277306ULL, 0x000fe20000209400ULL, 0x0000007a7900720bULL, 0x002fc40003f5d000ULL,
0x00000026007a7245ULL, 0x000fca000020d400ULL, 0x0000002600b07306ULL, 0x000e6c0000205400ULL,
0x000000014a4a2812ULL, 0x004fe400078efcffULL, 0x000000b500897306ULL, 0x000fe40000209400ULL,
0x0000004a9f4a723eULL, 0x000fcc00000010ffULL, 0x000000b5009a7306ULL, 0x0004e20000205400ULL,
0x000000b02700720bULL, 0x002fce0003f9d000ULL, 0x0000002500b27306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x004fca000020d400ULL, 0x000000017a7a4812ULL, 0x000fe400078efcffULL,
0x0000002500ad7306ULL, 0x0002a20000205400ULL, 0x0000009a8900720bULL, 0x008fe20003f7d000ULL,
0x0001000028897824ULL, 0x000fca00078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011489ULL,
0x0000008700907306ULL, 0x000fe20000209400ULL, 0x000000002424783bULL, 0x002e6a0000000200ULL,
0x00000001b5b53812ULL, 0x000fe400078efcffULL, 0x0000008700917306ULL, 0x000ee20000205400ULL,
0x000000adb200720bULL, 0x004fce0003fbd000ULL, 0x0000007b008c7306ULL, 0x000fec0000209400ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x0000007b008f7306ULL, 0x000ea20000205400ULL,
0x000000919000720bULL, 0x008fce0003fdd000ULL, 0x0000003000497306ULL, 0x000730000000d400ULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000008f8c00720bULL, 0x004fe20003f5d000ULL,
0x000000ae2414723cULL, 0x002fe20000041814ULL, 0x00000018ff307819ULL, 0x008fc40000011428ULL,
0x00000088998f723eULL, 0x000fc600000010ffULL, 0x0000007e00827306ULL, 0x000e620000205400ULL,
0x0000000149491812ULL, 0x010fe200078efcffULL, 0x000000aa2420723cULL, 0x040fec0000041820ULL,
0x0000003100737306ULL, 0x000fe40000009400ULL, 0x000000522410723cULL, 0x040fec0000041810ULL,
0x0000003100767306ULL, 0x000ea20000005400ULL, 0x000000827f00720bULL, 0x002fe20003f3d000ULL,
0x00010000297f7824ULL, 0x000fe200078e00ffULL, 0x0000008e240c723cULL, 0x000fe2000004180cULL,
0x000100002a827824ULL, 0x000fc600078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x00000080008b7306ULL, 0x000fe20000209400ULL, 0x00000018ff827819ULL, 0x000fce0000011482ULL,
0x00000080008a7306ULL, 0x000e620000205400ULL, 0x000000767300720bULL, 0x004fe40003f9d000ULL,
0x0000008700767245ULL, 0x000fe4000020d400ULL, 0x00000018ff737819ULL, 0x000fe4000001142bULL,
0x0000000176766812ULL, 0x000fe200078efcffULL, 0x0000009600987306ULL, 0x000fe60000209400ULL,
0x000000b5764b723eULL, 0x000fca00000010ffULL, 0x0000009600977306ULL, 0x000ea20000205400ULL,
0x0000008a8b00720bULL, 0x002fe20003f7d000ULL, 0x0000004a2404723cULL, 0x000fe20000041804ULL,
0x0000007b008a7245ULL, 0x000fe4000020d400ULL, 0x00000080008b7245ULL, 0x000fe2000020d400ULL,
0x0000010029807824ULL, 0x000fe200078e00ffULL, 0x000000018a8a2812ULL, 0x000fe200078efcffULL,
0x0000003300617306ULL, 0x000fe60000009400ULL, 0x00000018ff807819ULL, 0x000fc40000011480ULL,
0x000000498a8a723eULL, 0x000fe400000010ffULL, 0x000000018b8b3812ULL, 0x000fe200078efcffULL,
0x0000003300627306ULL, 0x000e620000005400ULL, 0x000000979800720bULL, 0x004fce0003fbd000ULL,
0x0000006600677306ULL, 0x000fec0000209400ULL, 0x0000000195955812ULL, 0x000fe400078efcffULL,
0x00000066006a7306ULL, 0x0004e20000205400ULL, 0x000000626100720bULL, 0x002fe40003fdd000ULL,
0x0000007e00617245ULL, 0x000fe2000020d400ULL, 0x000001002b7e7824ULL, 0x000fe200078e00ffULL,
0x0000007a9595723eULL, 0x000fc400000010ffULL, 0x0000000161611812ULL, 0x000fe200078efcffULL,
0x00000056006c7306ULL, 0x000fe20000209400ULL, 0x0000006600667245ULL, 0x004fe4000020d400ULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x000000942408723cULL, 0x000fe80000041808ULL,
0x0000005600697306ULL, 0x0002a20000205400ULL, 0x0000006a6700720bULL, 0x008fce0003f5d000ULL,
0x0000008100837306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x002fca000020d400ULL,
0x0000000166662812ULL, 0x000fe400078efcffULL, 0x0000008100847306ULL, 0x0002e20000205400ULL,
0x000000696c00720bULL, 0x004fe40003f3d000ULL, 0x0000008b668b723eULL, 0x000fca00000010ffULL,
0x0000003200727306ULL, 0x000fe20000009400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x0000000156561812ULL, 0x000fe400078efcffULL, 0x0000003200717306ULL, 0x000e620000005400ULL,
0x000000848300720bULL, 0x008fe20003f7d000ULL, 0x000001002a837824ULL, 0x000fe400078e00ffULL,
0x000100002b847824ULL, 0x000fc600078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x0000006300687306ULL, 0x000fe20000209400ULL, 0x00000018ff847819ULL, 0x000fca0000011484ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000006300657306ULL, 0x000ea20000205400ULL,
0x000000717200720bULL, 0x002fce0003fbd000ULL, 0x00000036005f7306ULL, 0x000ff00000209400ULL,
0x0000003600607306ULL, 0x0002e20000205400ULL, 0x000000656800720bULL, 0x004fce0003f5d000ULL,
0x00000075007c7306ULL, 0x000fe20000209400ULL, 0x0000003600367245ULL, 0x002fca000020d400ULL,
0x000000015e5e2812ULL, 0x000fe400078efcffULL, 0x00000075007d7306ULL, 0x000e620000205400ULL,
0x000000605f00720bULL, 0x008fe40003f3d000ULL, 0x000000815e49723eULL, 0x000fca00000010ffULL,
0x0000003200477306ULL, 0x000eac000000d400ULL, 0x0000000136361812ULL, 0x000fe400078efcffULL,
0x00000037006f7306ULL, 0x000fe20000209400ULL, 0x0000007d7c00720bULL, 0x002fce0003f7d000ULL,
0x0000003700707306ULL, 0x0002e20000205400ULL, 0x0000000147475812ULL, 0x004fce00078efcffULL,
0x0000006d00777306ULL, 0x000fe20000209400ULL, 0x0000003700377245ULL, 0x002fce000020d400ULL,
0x0000006d00787306ULL, 0x000e620000205400ULL, 0x000000706f00720bULL, 0x008fce0003fbd000ULL,
0x0000003100487306ULL, 0x0004ec000000d400ULL, 0x0000000137375812ULL, 0x000fe400078efcffULL,
0x0000004c006b7306ULL, 0x000fe20000209400ULL, 0x00000018ff317819ULL, 0x004fe40000011429ULL,
0x000000787700720bULL, 0x002fca0003f5d000ULL, 0x0000004c006e7306ULL, 0x000e620000205400ULL,
0x0000000148484812ULL, 0x008fc800078efcffULL, 0x000000486148723eULL, 0x000fc600000010ffULL,
0x00000028005d7306ULL, 0x000ff00000009400ULL, 0x0000002800587306ULL, 0x000ea20000005400ULL,
0x0000006e6b00720bULL, 0x002fce0003f9d000ULL, 0x0000002800467306ULL, 0x0003f0000000d400ULL,
0x0000008900627306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x002fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011428ULL, 0x0000008900677306ULL, 0x0002e20000205400ULL,
0x0000005ca728723eULL, 0x000fe400000010ffULL, 0x00000075005c7245ULL, 0x000fc8000020d400ULL,
0x000000015c5c3812ULL, 0x000fe200078efcffULL, 0x0000002900557306ULL, 0x000fe20000009400ULL,
0x000000585d00720bULL, 0x004fe40003f7d000ULL, 0x0000006d005d7245ULL, 0x000fe4000020d400ULL,
0x0000008900897245ULL, 0x002fe4000020d400ULL, 0x000000015d5d2812ULL, 0x000fe200078efcffULL,
0x0000002900547306ULL, 0x000e620000005400ULL, 0x000000676200720bULL, 0x008fc40003f3d000ULL,
0x000000475c5c723eULL, 0x000fe400000010ffULL, 0x0000005d565d723eULL, 0x000fe400000010ffULL,
0x0000000146463812ULL, 0x000fe200078efcffULL, 0x0000002900447306ULL, 0x0004ec000000d400ULL,
0x0000000189891812ULL, 0x000fc400078efcffULL, 0x0000002a004e7306ULL, 0x000fe20000009400ULL,
0x000000a1a029723eULL, 0x004fe400000010ffULL, 0x000000545500720bULL, 0x002fe40003f5d000ULL,
0x000000468946723eULL, 0x000fc600000010ffULL, 0x0000002a004d7306ULL, 0x000e620000005400ULL,
0x00000028241c723cULL, 0x000fee000004181cULL, 0x0000002a00417306ULL, 0x000522000000d400ULL,
0x0000001074287824ULL, 0x000fe200078e00ffULL, 0x0000000144442812ULL, 0x008fcc00078efcffULL,
0x0000002b00507306ULL, 0x000fe20000009400ULL, 0x000000579e2a723eULL, 0x004fe400000010ffULL,
0x0000004d4e00720bULL, 0x002fe40003fbd000ULL, 0x0000004c004d7245ULL, 0x000fc6000020d400ULL,
0x0000002b004f7306ULL, 0x000fe20000005400ULL, 0x000000014d4d4812ULL, 0x000fce00078efcffULL,
0x0000002b00427306ULL, 0x0003e2000000d400ULL, 0x0000000141415812ULL, 0x010fce00078efcffULL,
0x0000006a007b7306ULL, 0x000fe20000209400ULL, 0x0000009da22b723eULL, 0x002fce00000010ffULL,
0x0000006a00687306ULL, 0x0002a20000205400ULL, 0x0000002a2418723cULL, 0x000fe20000041818ULL,
0x000000002828783bULL, 0x000eec0000000200ULL, 0x0000003000347306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x002fe4000020d400ULL, 0x0000003000277245ULL, 0x000fc4000020d400ULL,
0x000000364d25723eULL, 0x000fc600000010ffULL, 0x0000003000357306ULL, 0x000e620000205400ULL,
0x000000687b00720bULL, 0x004fce0003f9d000ULL, 0x0000003300407306ULL, 0x000eac000000d400ULL,
0x000000016a6a4812ULL, 0x000fe400078efcffULL, 0x0000003100327306ULL, 0x000fe20000209400ULL,
0x000000353400720bULL, 0x002fce0003f3d000ULL, 0x0000003100337306ULL, 0x0003220000205400ULL,
0x0000000140406812ULL, 0x004fe200078efcffULL, 0x0000008a2820723cULL, 0x048fe20000041820ULL,
0x0000004f5000720bULL, 0x000fe40003fdd000ULL, 0x000000403724723eULL, 0x000fe400000010ffULL,
0x0000000127271812ULL, 0x000fe200078efcffULL, 0x0000007f00637306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fe2000020d400ULL, 0x00000048281c723cULL, 0x000fe2000004181cULL,
0x0000006a2747723eULL, 0x000fca00000010ffULL, 0x0000007f006c7306ULL, 0x0002a20000205400ULL,
0x000000333200720bULL, 0x010fe20003f9d000ULL, 0x000000242814723cULL, 0x000fe20000041814ULL,
0x0000000142426812ULL, 0x000fca00078efcffULL, 0x0000008000577306ULL, 0x000fe20000209400ULL,
0x0000007f007f7245ULL, 0x002fe2000020d400ULL, 0x0000005c2818723cULL, 0x040fe80000041818ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x0000008000547306ULL, 0x0002e20000205400ULL,
0x0000006c6300720bULL, 0x004fe20003f7d000ULL, 0x000000462810723cULL, 0x000fec0000041810ULL,
0x0000008200557306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x000000017f7f3812ULL, 0x000fe400078efcffULL, 0x00000082004e7306ULL, 0x0002a20000205400ULL,
0x000000545700720bULL, 0x008fe40003f3d000ULL, 0x000000447f24723eULL, 0x000fca00000010ffULL,
0x0000007300717306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x002fca000020d400ULL,
0x0000000180801812ULL, 0x000fe400078efcffULL, 0x0000007300727306ULL, 0x0002e20000205400ULL,
0x0000004e5500720bULL, 0x004fe40003f5d000ULL, 0x000000803125723eULL, 0x000fca00000010ffULL,
0x0000008400347306ULL, 0x000fe20000209400ULL, 0x0000007300737245ULL, 0x002fe2000020d400ULL,
0x00000024280c723cULL, 0x000fe8000004180cULL, 0x0000000182822812ULL, 0x000fe400078efcffULL,
0x0000008400337306ULL, 0x000e620000205400ULL, 0x000000727100720bULL, 0x008fe40003f3d000ULL,
0x0000008400257245ULL, 0x000fc4000020d400ULL, 0x000000418282723eULL, 0x000fc600000010ffULL,
0x0000008500867306ULL, 0x000fec0000209400ULL, 0x0000000173731812ULL, 0x000fe400078efcffULL,
0x0000008500797306ULL, 0x000ea20000205400ULL, 0x000000333400720bULL, 0x002fe40003f5d000ULL,
0x000000044300780cULL, 0x000fca0003f25270ULL, 0x00000083004c7306ULL, 0x000fec0000209400ULL,
0x0000000125252812ULL, 0x000fe400078efcffULL, 0x00000083004f7306ULL, 0x0002e20000205400ULL,
0x000000798600720bULL, 0x004fe40003f7d000ULL, 0x000000422524723eULL, 0x000fca00000010ffULL,
0x0000007e00267306ULL, 0x000fe20000209400ULL, 0x0000008300837245ULL, 0x002fce000020d400ULL,
0x0000007e00357306ULL, 0x0002a20000205400ULL, 0x0000004f4c00720bULL, 0x008fe40003f9d000ULL,
0x0000007e007e7245ULL, 0x002fd6000020d400ULL, 0x0000000183834812ULL, 0x000fe400078efcffULL,
0x000000352600720bULL, 0x004fe40003fbd000ULL, 0x0000008500267245ULL, 0x000fc8000020d400ULL,
0x0000000126263812ULL, 0x000fc800078efcffULL, 0x000000832683723eULL, 0x000fc600000010ffULL,
0x000000017e7e5812ULL, 0x000fc800078efcffULL, 0x0000007e7325723eULL, 0x000fe200000010ffULL,
0x000000822808723cULL, 0x040ff00000041808ULL, 0x000000242804723cULL, 0x000fe20000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff007224ULL, 0x000fe200078e003cULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd3e000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x010614003d257984ULL, 0x000e620000000800ULL,
0x0000ffff3a007812ULL, 0x000fe200078ec0ffULL, 0x0000001d2e1d7220ULL, 0x040fe20000410000ULL,
0x0000001a2e247220ULL, 0x040fe20000410000ULL, 0x000000142e147220ULL, 0x000fe20000410000ULL,
0x0000888000337816ULL, 0x000fe200000000ffULL, 0x0000001e2e1e7220ULL, 0x040fe20000410000ULL,
0x0000001b2e267220ULL, 0x040fe20000410000ULL, 0x000000152e157220ULL, 0x040fe20000410000ULL,
0x0000000c2e1a7220ULL, 0x040fe20000410000ULL, 0x000000202e207220ULL, 0x040fe20000410000ULL,
0x000000212e217220ULL, 0x040fe20000410000ULL, 0x000000222e227220ULL, 0x040fe20000410000ULL,
0x0000001f2e1f7220ULL, 0x040fe20000410000ULL, 0x000000162e277220ULL, 0x040fe20000410000ULL,
0x000000172e287220ULL, 0x040fe20000410000ULL, 0x0000000d2e1b7220ULL, 0x040fe20000410000ULL,
0x8000000033007824ULL, 0x000fe200078e00ffULL, 0x000000232e237220ULL, 0x040fe20000410000ULL,
0x000000182e187220ULL, 0x040fe20000410000ULL, 0x000000192e197220ULL, 0x040fe20000410000ULL,
0x000000102e167220ULL, 0x040fe20000410000ULL, 0x000000112e177220ULL, 0x040fe20000410000ULL,
0x0000001c2e1c7220ULL, 0x040fe20000410000ULL, 0x000000122e297220ULL, 0x040fe20000410000ULL,
0x000000132e2a7220ULL, 0x040fe20000410000ULL, 0x0000000e2e2b7220ULL, 0x040fe20000410000ULL,
0x0000000f2e307220ULL, 0x040fe20000410000ULL, 0x000000082e087220ULL, 0x040fe20000410000ULL,
0x000000092e097220ULL, 0x040fe20000410000ULL, 0x0000000a2e317220ULL, 0x040fe20000410000ULL,
0x0000000b2e327220ULL, 0x040fe20000410000ULL, 0x000000042e047220ULL, 0x040fe20000410000ULL,
0x000000052e057220ULL, 0x040fe20000410000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e001dULL,
0x000000062e067220ULL, 0x040fe20000410000ULL, 0x000000ffff107224ULL, 0x000fe200078e0014ULL,
0x000000072e077220ULL, 0x000fe20000410000ULL, 0x000000ffff117224ULL, 0x000fc400078e0015ULL,
0x000000ffff147224ULL, 0x000fe200078e001aULL, 0x8000000025ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff157224ULL, 0x000fe400078e001bULL,
0x000000ffff1a7224ULL, 0x000fc400078e0022ULL, 0x000000ffff1e7224ULL, 0x000fe400078e001fULL,
0x000000ffff0e7224ULL, 0x000fe400078e0018ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0019ULL,
0x000000ffff127224ULL, 0x000fe400078e0016ULL, 0x000000ffff137224ULL, 0x000fe400078e0017ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0023ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0024ULL,
0x000000ffff207224ULL, 0x000fe400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e0028ULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff237224ULL, 0x000fe400078e0029ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fc400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e0030ULL,
0x000000ffff277224ULL, 0x000fe400078e0031ULL, 0x000000ffff287224ULL, 0x000fe200078e0032ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe400078e0006ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0007ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000033337824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x010614003d047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc40007804833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004381c7824ULL, 0x000fe200078e00ffULL,
0x0000003b6400720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff01c007812ULL, 0x000fca00078ec0ffULL, 0x000000805b007824ULL, 0x000fca00078e0200ULL,
0x0104000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000238087824ULL, 0x000fe400078e00ffULL, 0x000000015a397824ULL, 0x000fc600078e0a39ULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108307812ULL, 0x040fe400078efcffULL,
0x0000000808327812ULL, 0x000fe400078efcffULL, 0x000000393000720cULL, 0x080fe40003f26070ULL,
0x0000001008307812ULL, 0x000fe400078efcffULL, 0x000000393200720cULL, 0x080fe40003f06070ULL,
0x000000393000720cULL, 0x000fc40003fc6070ULL, 0x0000001108327812ULL, 0x040fe400078efcffULL,
0x0000001808307812ULL, 0x040fe400078efcffULL, 0x000000390800720cULL, 0x080fe40003f46070ULL,
0x000000393200720cULL, 0x080fe40003fa6070ULL, 0x000000393000720cULL, 0x000fe40003f66070ULL,
0x0000000908347812ULL, 0x000fc400078efcffULL, 0x0000001908327812ULL, 0x040fe400078efcffULL,
0x0000002008307812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000393400720cULL, 0x080fe40003f86070ULL,
0x000000393200720cULL, 0x080fe40003f46070ULL, 0x000000393000720cULL, 0x000fe40003f26070ULL,
0x0000002108327812ULL, 0x040fe400078efcffULL, 0x0000002808307812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000393200720cULL, 0x080fe40003f06070ULL, 0x000000393000720cULL, 0x000fe40003f86070ULL,
0x0000002908327812ULL, 0x000fc400078efcffULL, 0x0000003008307812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000393200720cULL, 0x000fc40003fc6070ULL, 0x000000393000720cULL, 0x000fe40003fa6070ULL,
0x0000003108327812ULL, 0x040fe400078efcffULL, 0x0000003808307812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000393200720cULL, 0x080fe40003f66070ULL,
0x000000393000720cULL, 0x000fc40003f46070ULL, 0x000000390800720cULL, 0x000fe40003f26070ULL,
0xff7fffff24247808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff25257808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff26267808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff27277808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff28287808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff29297808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff367424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000001908317209ULL, 0x000fe40007810000ULL,
0x0000002a05337209ULL, 0x000fe20007810000ULL, 0x00000dc27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0031047f89ULL, 0x0004e400000e0000ULL, 0x0000000431317209ULL, 0x00cfe20007810000ULL,
0x00000df27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0033047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007307f89ULL, 0x000f2200000e0000ULL,
0x0000000433087209ULL, 0x004fc60007810000ULL, 0x0c201f0031047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000003007307209ULL, 0x010fc60007810000ULL, 0x0c201f0009327f89ULL, 0x002e6800000e0000ULL,
0x0c201f00302b7f89ULL, 0x00092200000e0000ULL, 0x0000000431047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000003209067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fc40000000000ULL,
0x00000005ff327e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3f8000003232783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL, 0x000000ffff337224ULL, 0x000fe200078e0032ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010819ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2a197823ULL, 0x000fe20000010819ULL,
0x0000000000087886ULL, 0x000fc400038e0100ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x0007f00000000800ULL, 0x0000001e001e7308ULL, 0x000f220000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000010ffULL, 0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x010fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x000000320834723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000320c34723cULL, 0x000fee0000041834ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe400000010ffULL, 0xfffffffc38147812ULL, 0x000fc800078ec0ffULL,
0x000000141d1d7219ULL, 0x000fe200000006ffULL, 0x0000002500257308ULL, 0x000fe60000000800ULL,
0x000000001d1e73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0573c4ULL, 0x000f280000004000ULL,
0x0000002600267308ULL, 0x000ea20000000800ULL, 0x000000232411723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000252613723eULL, 0x004fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000081dff7c12ULL, 0x008fe2000f80401eULL,
0x000000321034723cULL, 0x000fec0000041834ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x004fe400000010ffULL, 0x000000302b077209ULL, 0x000fca0007810000ULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x00000019001a7308ULL, 0x000ea20000000800ULL,
0x000000272815723eULL, 0x002fe400000010ffULL, 0x000000291a17723eULL, 0x004fce00000010ffULL,
0x000000321434723cULL, 0x000fe20000041834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000090205008947ULL, 0x010fde000b800000ULL, 0x001c1fff34187589ULL, 0x0002a400000e0000ULL,
0x000000001d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x000000081dff7c12ULL, 0x008fda000f80401aULL,
0x0000091205008947ULL, 0x010fea000b800000ULL, 0x001c1fff36197589ULL, 0x00072800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL, 0x001c1fff001b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x00afe40000011638ULL, 0x0000000c1c377812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0x0000000338ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d327824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d487824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f267812ULL, 0x000fc400078ef61eULL, 0x000000041f287812ULL, 0x140fe400078ef61eULL,
0x000000051f2a7812ULL, 0x140fe400078ef61eULL, 0x000000061f307812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x0000a0005b1d7811ULL, 0x000fe400078e58ffULL, 0xfffffff823347812ULL, 0x100fe400078ee21eULL,
0x000000011f367812ULL, 0x140fe200078ef61eULL, 0x00000010201c7824ULL, 0x000fe200078e021dULL,
0xfffffff848487812ULL, 0x000fe200078ee221ULL, 0x0000001024207824ULL, 0x100fe200078e021dULL,
0x000000021f3e7812ULL, 0x140fe200078ef61eULL, 0x0000001028247824ULL, 0x100fe200078e021dULL,
0x000000031f407812ULL, 0x140fe200078ef61eULL, 0x0000001030287824ULL, 0x100fe200078e021dULL,
0x000000041f427812ULL, 0x140fe200078ef61eULL, 0x0000001036307824ULL, 0x100fe200078e021dULL,
0x000000051f447812ULL, 0x140fe200078ef61eULL, 0x000000103e317824ULL, 0x100fe200078e021dULL,
0x000000061f467812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x0000001026227824ULL, 0x100fe400078e021dULL, 0x000000102a267824ULL, 0x100fe400078e021dULL,
0x00000001371f7824ULL, 0x000fe400078e021cULL, 0x00000010322a7824ULL, 0x100fe400078e021dULL,
0x00000010341c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x0000001040327824ULL, 0x000fc400078e021dULL, 0x0000001042337824ULL, 0x100fe400078e021dULL,
0x0000001044347824ULL, 0x100fe400078e021dULL, 0x0000001046357824ULL, 0x100fe400078e021dULL,
0x0000001048367824ULL, 0x000fe400078e021dULL, 0x00000001371d7824ULL, 0x040fe400078e021eULL,
0x0000000137217824ULL, 0x000fc400078e0220ULL, 0x0000000137237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000137257824ULL, 0x040fe400078e0224ULL,
0x0000000137277824ULL, 0x040fe200078e0226ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x0000000137297824ULL, 0x040fe400078e0228ULL, 0x00000001372b7824ULL, 0x040fe200078e022aULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x00000001371c7824ULL, 0x000fc400078e021cULL,
0x0000000137307824ULL, 0x040fe200078e0230ULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x00000001371e7824ULL, 0x040fe400078e0231ULL, 0x0000000137327824ULL, 0x040fe200078e0232ULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000137087824ULL, 0x042fe400078e0233ULL,
0x0000000137347824ULL, 0x040fe200078e0234ULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x0000000137207824ULL, 0x000fc400078e0235ULL, 0x0000000137367824ULL, 0x000fe200078e0236ULL,
0x000000162b007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b30007388ULL, 0x0007e80000000800ULL, 0x0000000d1e007388ULL, 0x0007e80000000800ULL,
0x0000000f32007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x0000001334007388ULL, 0x0007e80000000800ULL, 0x0000001520007388ULL, 0x0007e80000000800ULL,
0x0000001736007388ULL, 0x0007e80000000800ULL, 0x0100000400008388ULL, 0x0007e80000000c00ULL,
0x0102001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030064647a10ULL, 0x000fe20007ffe0ffULL, 0x010608003dff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff3aff7812ULL, 0x000fc4000780c0ffULL, 0x0000002f6400720cULL, 0x000fe40003f26070ULL,
0x00000001ff3a7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffb8d000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0031ULL, 0x0001d48000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fe400078e00ffULL, 0x0000053000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002bULL, 0xfffff1f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e0033ULL, 0x0001d4e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x000004d000007944ULL, 0x020fea0003c00000ULL,
0x0000002b33347209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0006ULL,
0x0001d53000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fe400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002b06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0007ULL, 0x0001d58000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002b07307209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0031ULL,
0x0001d5d000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002b31047209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0034ULL, 0x0001d62000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002b34057209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0006ULL,
0x0001d67000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0x0000002b06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0030ULL, 0x0001d6c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0xfffff0b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0034ULL,
0x0001d720001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fc400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000002d000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e001bULL, 0xfffff6a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x002fe200078e0036ULL, 0x0001d790001e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff217224ULL, 0x000fe400078e00ffULL, 0x00001c1fff227424ULL, 0x000fe400078e00ffULL,
0x0000026000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff217224ULL, 0x002fe200078e00ffULL,
0x0001d7e0001e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x004fe400078e001bULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x002fe200078e00ffULL, 0x0001d830001e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff227424ULL, 0x000fc400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e001bULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xfffff62000007947ULL, 0x000fea000383ffffULL,
0x0180000029037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000002900038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff29ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000029047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002900037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff197424ULL, 0x000fc800078e00ffULL,
0xfffe265018007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c0000322b2b7389ULL, 0x0002a200000e0035ULL,
0xfffe261008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000001d00007348ULL, 0x000fe80003800000ULL, 0x00000021201b7389ULL, 0x0002a200000e0022ULL,
0xfffe25d01e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000008ecULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010f8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001108ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001128ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001198ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011a0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011b0ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001380ULL, 0x000000000001db00ULL, 0xf200001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001ee80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001ee90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001ee90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001f310ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001198ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001dce8ULL, 0x000000000001dce8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001ee80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001f310ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_86_cubin_len = 127984;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
