/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000020c10ULL, 0x0000000000020790ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000001f330ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x000000000001f4c0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000001f500ULL, 0x0000000000000100ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000001f600ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001f33000000000ULL, 0x0000040400000000ULL, 0x810c000000100400ULL, 0x007cb00410288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080840828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808088920000ULL, 0x0000000000000022ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001f33000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8086288080840900ULL, 0x0900000004042880ULL, 0x2880808428808088ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080840828ULL, 0x2880808c08288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880808cULL, 0x0000001cffffffffULL,
0x0000010800000000ULL, 0x0001f4c000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080840828ULL, 0x2880808c08288080ULL,
0x8280162880809e08ULL, 0x0000000003102880ULL, 0x80809e9200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000018800000000ULL, 0x0001f50000000000ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000ffULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000001000000011ULL, 0x0000001100081104ULL, 0x0008120400000010ULL, 0x0000001000000011ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0001e1c000183104ULL, 0x0001e6600001e650ULL, 0x0001e7e00001e7d0ULL, 0x00e829040001e7f0ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002405000024ULL, 0x0500002405000024ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000b000e82804ULL, 0x00001f2000000250ULL, 0x0000204000001fb0ULL,
0x0000387000002060ULL, 0x00006bb0000038e0ULL, 0x00006cd000006c30ULL, 0x0000817000006d00ULL,
0x0000b740000081b0ULL, 0x0000b8600000b7c0ULL, 0x0000cf700000b890ULL, 0x000102500000d060ULL,
0x00010370000102d0ULL, 0x000133a0000103a0ULL, 0x000144f0000133d0ULL, 0x00014c8000014500ULL,
0x00016bf0000169f0ULL, 0x00017100000170d0ULL, 0x0001e07000017940ULL, 0x0001e0b00001e0a0ULL,
0x0001e0e00001e0c0ULL, 0x0001e1200001e100ULL, 0x0001e7c00001e130ULL, 0x0001e8300001e820ULL,
0x0001ee800001e840ULL, 0x0001ef700001ef00ULL, 0x0001f0500001efe0ULL, 0x0001f1300001f0c0ULL,
0x0001f2000001f1a0ULL, 0x0001f2c00001f270ULL, 0x03e039040001f310ULL, 0x000000ff00000160ULL,
0x003f01000001c600ULL, 0x0000000d00000190ULL, 0x003f01300001c608ULL, 0x0000000d000001c0ULL,
0x003f01300001c610ULL, 0x0000000d00000220ULL, 0x003f01200001c648ULL, 0x000000ff00000230ULL,
0x003f01000001c658ULL, 0x000000ff000005b0ULL, 0x003f01070001c600ULL, 0x0000002200000780ULL,
0x003f01020001c614ULL, 0x0000002200000880ULL, 0x003f01010001c610ULL, 0x000000ff00000fe0ULL,
0x003f01070001c648ULL, 0x000000ff00001060ULL, 0x003f01010001c658ULL, 0x000000ff000011f0ULL,
0x003f01060001c65cULL, 0x000000ff000012b0ULL, 0x003f01060001c65cULL, 0x000000ff00001340ULL,
0x003f01060001c65cULL, 0x000000ff00001cb0ULL, 0x0005010700000000ULL, 0x0000002000001d20ULL,
0x003f01060001c64cULL, 0x000000ff00001d60ULL, 0x003f01060001c60cULL, 0x000000ff00001e50ULL,
0x003f01060001c60cULL, 0x00000023000022e0ULL, 0x003f010600000004ULL, 0x0000002300002370ULL,
0x003f010600000004ULL, 0x000000ff00006170ULL, 0x003f01010001c658ULL, 0x000000ff000061e0ULL,
0x003f01010001c610ULL, 0x000000ff00006290ULL, 0x003f01060001c65cULL, 0x000000ff000062e0ULL,
0x003f01060001c65cULL, 0x000000ff00006370ULL, 0x003f01060001c65cULL, 0x00000002000069b0ULL,
0x003f01070001c648ULL, 0x0000000000006a20ULL, 0x003f010600000004ULL, 0x000000ff00006a40ULL,
0x003f01060001c61cULL, 0x000000ff00006b30ULL, 0x003f01060001c61cULL, 0x0000000c00006f90ULL,
0x003f010600000004ULL, 0x0000000c00007020ULL, 0x003f010600000004ULL, 0x000000ff0000ac20ULL,
0x003f01010001c658ULL, 0x000000ff0000acb0ULL, 0x003f01010001c620ULL, 0x000000ff0000ad30ULL,
0x003f01060001c65cULL, 0x000000ff0000ad90ULL, 0x003f01060001c65cULL, 0x000000ff0000ae20ULL,
0x003f01060001c65cULL, 0x000000ff0000b550ULL, 0x0005010700000000ULL, 0x000000000000b5c0ULL,
0x003f01060001c64cULL, 0x000000ff0000b5e0ULL, 0x003f01060001c62cULL, 0x000000ff0000b6c0ULL,
0x003f01060001c62cULL, 0x000000250000bb20ULL, 0x003f01060001c64cULL, 0x0000000c0000bc10ULL,
0x003f010600000004ULL, 0x000000ff0000f830ULL, 0x003f01010001c658ULL, 0x000000ff0000f8c0ULL,
0x003f01010001c630ULL, 0x000000ff0000f970ULL, 0x003f01060001c65cULL, 0x000000ff0000f9c0ULL,
0x003f01060001c65cULL, 0x000000ff0000fa50ULL, 0x003f01060001c65cULL, 0x0000000000010070ULL,
0x003f01070001c648ULL, 0x00000002000100e0ULL, 0x003f010600000004ULL, 0x000000ff00010100ULL,
0x003f01060001c63cULL, 0x000000ff000101d0ULL, 0x003f01060001c63cULL, 0x0000001900010630ULL,
0x003f010600000004ULL, 0x00000019000106c0ULL, 0x003f010600000004ULL, 0x000000ff00014220ULL,
0x003f01010001c658ULL, 0x000000ff00014280ULL, 0x003f01010001c640ULL, 0x000000ff00019700ULL,
0x003f01060001c604ULL, 0x000000ff00019790ULL, 0x003f01060001c604ULL, 0x000000ff00019ac0ULL,
0x003f01010001c600ULL, 0x000000ff00019ad0ULL, 0x003f01060001c604ULL, 0x000000ff00019b50ULL,
0x003f01060001c604ULL, 0x0000003d0001d4d0ULL, 0x003f01060001c614ULL, 0x0000003d0001d970ULL,
0x003f01060001c614ULL, 0x0000003d0001edc0ULL, 0x003f01010001c608ULL, 0x00101c0400053803ULL,
0x00019ba000017d80ULL, 0x0001ee2000019c70ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001fcULL, 0x0000001100000002ULL, 0x0000000000000174ULL, 0x0000001100000002ULL,
0x00000000000000dcULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001d4ULL, 0x0000001100000002ULL, 0x000000000000014fULL, 0x0000001100000002ULL,
0x00000000000000b2ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000107919ULL, 0x000e620000002300ULL,
0x00000004ff177424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0xfffffff001017810ULL, 0x000fe20007ffe0ffULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x0000580000047ab9ULL, 0x000fc60000000800ULL, 0x00000000000b7919ULL, 0x000ea80000002100ULL,
0x00000000000c7919ULL, 0x000ee80000002700ULL, 0x0000000000387919ULL, 0x000f220000002600ULL,
0x0000000110007824ULL, 0x002fc600078e0203ULL, 0x00001fff10107589ULL, 0x000e6200000e0000ULL,
0x00000080000d7824ULL, 0x104fe200078e020bULL, 0x00000005ff007819ULL, 0x000fc8000001160bULL,
0x000000ff0d00720cULL, 0x040fe40003f65270ULL, 0x000000030d00780cULL, 0x040fe40003f04070ULL,
0x0000007f0d00780cULL, 0x040fe40003f24070ULL, 0x000000010d00780cULL, 0x000fce0003f44070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL,
0x01c60002ff00b388ULL, 0x000fe20000000a00ULL, 0x3fffff80ff068424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff078424ULL, 0x000fe200078e00ffULL, 0x01c608040d008388ULL, 0x000fe2000000ca00ULL,
0xff317217ff0a9424ULL, 0x000fc400078e00ffULL, 0x3fffff80ff08a424ULL, 0x000fe200078e00ffULL,
0x01c610060d008388ULL, 0x000fe2000000ca00ULL, 0x000000ff1000720cULL, 0x002fe20003f05270ULL,
0x7fffff80ff09a424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0eb424ULL, 0x000fe200078e00ffULL,
0x01c4000a0d009388ULL, 0x0007e20000004800ULL, 0x7fffff80ff0fb424ULL, 0x000fc600078e00ffULL,
0x01c648080d00a388ULL, 0x0003e80000008a00ULL, 0x01c6580eff00b388ULL, 0x0003e20000000a00ULL,
0x000062000c0a7625ULL, 0x008fc600078e0017ULL, 0x00001fff00037589ULL, 0x0002a800000e0000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003a000000947ULL, 0x000fea0003800000ULL,
0x0000000000137919ULL, 0x012e620000000000ULL, 0x0000000403007824ULL, 0x004fe200078e00ffULL,
0x0000000404057899ULL, 0x000fe2000800063fULL, 0x0000001038057824ULL, 0x000fc400078e00ffULL,
0x00000200ff167424ULL, 0x000fe200078e00ffULL, 0x0000000013077211ULL, 0x042fe200078fd8ffULL,
0x0000001013027824ULL, 0x000fe400078e00ffULL, 0x000000050c007c24ULL, 0x000fe2000f8e0205ULL,
0x0000000707047812ULL, 0x040fe400078ec0ffULL, 0x000001f002157812ULL, 0x000fe400078ec0ffULL,
0x0000001f04027812ULL, 0x000fe200078e7813ULL, 0x0000000100047824ULL, 0x000fe200078e0207ULL,
0x00000002070d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000107097810ULL, 0x040fe20007ffe0ffULL,
0x00005c0004047625ULL, 0x000fe200078e0016ULL, 0x0000000307117810ULL, 0x000fe40007ffe0ffULL,
0x000000070d0e7812ULL, 0x000fe200078ec0ffULL, 0x0000002007027824ULL, 0x000fe200078e0202ULL,
0x0000000709077812ULL, 0x000fe200078ec0ffULL, 0x0000000100067824ULL, 0x000fe200078e0209ULL,
0x00000007110f7812ULL, 0x000fe400078ec0ffULL, 0x0000001f0e127812ULL, 0x000fc400078e7813ULL,
0x00000015040e7210ULL, 0x000fe40007f1e0ffULL, 0x0000001f07087812ULL, 0x000fe200078e7813ULL,
0x0000000100077824ULL, 0x040fe200078e020dULL, 0x0000001f0f147812ULL, 0x000fe200078e7813ULL,
0x0000000100137824ULL, 0x000fe400078e0211ULL, 0x000000ffff0f7224ULL, 0x000fe400000e0605ULL,
0x00005c0006047625ULL, 0x000fc800078e0016ULL, 0x0000002009007824ULL, 0x000fe200078e0208ULL,
0x0000001504047210ULL, 0x000fe20007f1e0ffULL, 0x00005c0007067625ULL, 0x000fc800078e0016ULL,
0x00005c0013087625ULL, 0x000fe200078e0016ULL, 0x0000001506067210ULL, 0x000fc60007f3e0ffULL,
0x000000200d127824ULL, 0x000fe200078e0212ULL, 0x0000001508087210ULL, 0x000fe20007f5e0ffULL,
0x0000002011147824ULL, 0x000fe400078e0214ULL, 0x00000010020d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400000e0605ULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400008e0607ULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fe400010e0609ULL,
0x0000001014157824ULL, 0x000fe200078e00ffULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000008157faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060a047981ULL, 0x012ee2000c1e1900ULL, 0x00000000000579c3ULL, 0x000e620000002500ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x00000005ff057e24ULL, 0x002fe2000f8e00ffULL,
0x0000007f04067810ULL, 0x008fc40007ffe0ffULL, 0x000000ff04077810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff067819ULL, 0x000fe40000011606ULL, 0x00000008ff077819ULL, 0x000fca0000011607ULL,
0x000176e000008947ULL, 0x000fea0003800000ULL, 0x0000000205087824ULL, 0x000fe400078e00ffULL,
0x0000001003227824ULL, 0x004fe400078e00ffULL, 0x00000003ff027424ULL, 0x000fe200078e00ffULL,
0x000000060800720cULL, 0x000fda0003f06070ULL, 0x0000640008098a10ULL, 0x000fe20007ffe0ffULL,
0x000000020c008824ULL, 0x000fc800078e00ffULL, 0x0000640000008a24ULL, 0x000fe400078e0209ULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6140222ff738cULL, 0x0003e20000000000ULL, 0x00006000000a8625ULL, 0x000fe200078e0017ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a098981ULL, 0x0004e2000c1e1900ULL,
0x00000100050d7824ULL, 0x040fe200078e00ffULL, 0x0000000105007810ULL, 0x000fe20007ffe0ffULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x0000000000207919ULL, 0x000f220000000000ULL,
0x00000080380e7824ULL, 0x000fe200078e00ffULL, 0x0000000d04027217ULL, 0x002fe20007800000ULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x000000070000720cULL, 0x000fe20003f06070ULL,
0x01c6100022ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000102027824ULL, 0x000fe200078e0a0dULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000004002027807ULL, 0x000fe20000000000ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x000000ffff517224ULL, 0x000fe200078e00ffULL, 0x0000000222027217ULL, 0x000fca0007800000ULL,
0x0000000102027824ULL, 0x000fe200078e0a22ULL, 0x00000004ff0d7819ULL, 0x010fe20000011620ULL,
0x0000001020257824ULL, 0x000fc600078e00ffULL, 0x000000020d0b7810ULL, 0x044fe20007ffe0ffULL,
0x00000001220f7824ULL, 0x040fe200078e020dULL, 0x000000060d157810ULL, 0x000fe40007ffe0ffULL,
0x000000020b00720cULL, 0x000fe20003f86070ULL, 0x0000000122117824ULL, 0x000fe200078e020bULL,
0x000000070f007812ULL, 0x000fe400078ec0ffULL, 0x000000f025257812ULL, 0x000fe400078ec0ffULL,
0x0000000f000a7812ULL, 0x000fc400078e7820ULL, 0x000000040d137810ULL, 0x000fe40007ffe0ffULL,
0x000000021500720cULL, 0x080fe20003f46070ULL, 0x000000100f1a7824ULL, 0x000fe200078e020aULL,
0x000000021300720cULL, 0x080fe20003f66070ULL, 0x0000000122157824ULL, 0x000fe200078e0215ULL,
0x0000000a0d1f7810ULL, 0x040fe40007ffe0ffULL, 0x000000020d00720cULL, 0x040fe40003fa6070ULL,
0x0000000c0d217810ULL, 0x000fc40007ffe0ffULL, 0x0000000e0d237810ULL, 0x000fe20007ffe0ffULL,
0x0000000409007c24ULL, 0x008fe2000f8e020eULL, 0x00000007110e7812ULL, 0x000fc800078ec0ffULL,
0x0000007f000a7812ULL, 0x000fe200078ef80fULL, 0x00000001220f7824ULL, 0x000fe200078e0213ULL,
0x0000000f0e0e7812ULL, 0x000fc600078e7820ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0027ULL,
0x000000070f107812ULL, 0x000fc600078ec0ffULL, 0x00000010111b7824ULL, 0x000fe200078e020eULL,
0x000000250a127210ULL, 0x000fe40007f1e0ffULL, 0x0000007f000a7812ULL, 0x000fe400078ef811ULL,
0x00000007150e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200000e060bULL,
0x000000080d117810ULL, 0x000fe20007ffe0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0027ULL,
0x0000000f0e0e7812ULL, 0x100fe400078e7820ULL, 0x0000000f10107812ULL, 0x000fe200078e7820ULL,
0x0000000122177824ULL, 0x000fe200078e0211ULL, 0x000000250a147210ULL, 0x000fe20007f1e0ffULL,
0x00000010151d7824ULL, 0x000fe200078e020eULL, 0x0000007f000a7812ULL, 0x040fe200078ef80fULL,
0x000000100f1c7824ULL, 0x000fe200078e0210ULL, 0x0000007f000e7812ULL, 0x000fe200078ef815ULL,
0x000000ffff157224ULL, 0x000fe200000e060bULL, 0x000000021100720cULL, 0x000fe20003f26070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0027ULL, 0x0000000717117812ULL, 0x000fc400078ec0ffULL,
0x0000007f00107812ULL, 0x000fe200078ef817ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0027ULL,
0x0000000f111e7812ULL, 0x000fe400078e7820ULL, 0x000000250a167210ULL, 0x000fe20007f1e0ffULL,
0x00005e0010107625ULL, 0x000fe200078e0027ULL, 0x000000250e187210ULL, 0x000fe40007fde0ffULL,
0x000140001b0d7811ULL, 0x000fe200078e20ffULL, 0x00000010171e7824ULL, 0x000fe200078e021eULL,
0x000140001d1d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff177224ULL, 0x000fe200000e060bULL,
0x000000021f00720cULL, 0x000fe20003f06070ULL, 0x00000001221f7824ULL, 0x000fc400078e021fULL,
0x000000ffff197224ULL, 0x000fe200030e060fULL, 0x000140001a0f7811ULL, 0x000fe400078e20ffULL,
0x0000007f000a7812ULL, 0x000fe400078ef81fULL, 0x0000002510107210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120f7faeULL, 0x0005e2000e901c46ULL,
0x000000022100720cULL, 0x080fe20003fa6070ULL, 0x00005e000a0a7625ULL, 0x000fe400078e0027ULL,
0x00000000140d7faeULL, 0x0007e2000e101c46ULL, 0x000000022300720cULL, 0x000fe20003f86070ULL,
0x0000000122217824ULL, 0x000fe200078e0221ULL, 0x000000071f027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000250a1a7210ULL, 0x000fe20007fde0ffULL,
0x0000000122237824ULL, 0x000fe200078e0223ULL, 0x0000007f000a7812ULL, 0x000fc400078ef821ULL,
0x0000000f02027812ULL, 0x100fe200078e7820ULL, 0x000000ffff1b7224ULL, 0x000fe200030e060bULL,
0x0000007f000e7812ULL, 0x000fe200078ef823ULL, 0x00005e000a0a7625ULL, 0x080fe200078e0027ULL,
0x0000000721007812ULL, 0x000fe400078ec0ffULL, 0x00000007230d7812ULL, 0x008fe200078ec0ffULL,
0x00005e000e0e7625ULL, 0x004fe200078e0027ULL, 0x000000250a127210ULL, 0x080fe40007fde0ffULL,
0x0000000f00007812ULL, 0x000fe200078e7820ULL, 0x000000101f027824ULL, 0x000fe200078e0202ULL,
0x0000000f0d0a7812ULL, 0x000fe200078e7820ULL, 0x000000ffff137224ULL, 0x000fe200030e060bULL,
0x000000250e0e7210ULL, 0x000fe20007fde0ffULL, 0x0000001021007824ULL, 0x000fe200078e0200ULL,
0x000140001c0b7811ULL, 0x000fe200078e20ffULL, 0x00000010230a7824ULL, 0x000fe200078e020aULL,
0x000140001e0d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x0001400002157811ULL, 0x000fe200078e20ffULL, 0x00000000160b7faeULL, 0x0005e2000d901c46ULL,
0x00014000001f7811ULL, 0x000fc400078e20ffULL, 0x000140000a217811ULL, 0x000fe200078e20ffULL,
0x00000000181d7faeULL, 0x0003e2000d101c46ULL, 0xff317217ff0a7424ULL, 0x000fc600078e00ffULL,
0x00000000100d7faeULL, 0x0003e8000c901c46ULL, 0x000000001a157faeULL, 0x0003e2000c101c46ULL,
0x000000070500720cULL, 0x000fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x004fe400078e00ffULL,
0x00000000121f7faeULL, 0x0003e8000e901c46ULL, 0x000000000e217faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01c64800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff507224ULL, 0x000fe200078e00ffULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0001325000000947ULL, 0x000fea0003800000ULL, 0x000000020c0d7824ULL, 0x002fe200078e00ffULL,
0x00000002030f7811ULL, 0x000fe200078e10ffULL, 0x00006400ff007624ULL, 0x000fe200078e00ffULL,
0x00007610ff027816ULL, 0x000fe20000000002ULL, 0xff317217ff0a7424ULL, 0x000fe200078e00ffULL,
0x00007610ff0c7816ULL, 0x000fe2000000000cULL, 0x000064000d0e7624ULL, 0x000fe200078e0200ULL,
0x00007610ff0d7816ULL, 0x000fe2000000000dULL, 0x000000ffff007224ULL, 0x000fc400078e00ffULL,
0x000000ffff4b7224ULL, 0x000fe400078e00ffULL, 0x0000080d01007387ULL, 0x0003e80000100600ULL,
0x00000100050f7824ULL, 0x000fca00078e00ffULL, 0x000000040f00720cULL, 0x000fda0003f06070ULL,
0x000130f000000947ULL, 0x026fea0003800000ULL, 0x01c65c00ff107984ULL, 0x000ea20000000800ULL,
0x0000ffff020e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff267224ULL, 0x000fc600078e0008ULL,
0x000088800e117816ULL, 0x000fe200000000ffULL, 0x000000ffff0e7224ULL, 0x000fc800078e0000ULL,
0x80000000110f7824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x004fe2000780480fULL,
0x0000000000007918ULL, 0x000fec0000000000ULL, 0x0000761002107816ULL, 0x000fe40000000010ULL,
0x000076100c277816ULL, 0x000fc60000000027ULL, 0x0000041001007387ULL, 0x0005e20000100600ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01c65c00ff107984ULL, 0x004ea40000000800ULL,
0x8000000010ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000011117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00107305ULL, 0x0004e4000021f000ULL,
0x3fa000000f0f7823ULL, 0x004fe200000100ffULL, 0x000000100000735dULL, 0x008fe40003800000ULL,
0x01c65c00ff107984ULL, 0x000ea40000000800ULL, 0x8000000010ff7812ULL, 0x004fc40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000107919ULL, 0x004ea20000002700ULL, 0x00000300ff287624ULL, 0x000fe200078e00ffULL,
0x00000001080f7812ULL, 0x000fe200078ec0ffULL, 0x00006400ff137624ULL, 0x000fe200078e00ffULL,
0x0000000000377919ULL, 0x000ee20000000000ULL, 0x0000001003197824ULL, 0x000fe200078e00ffULL,
0x000000010f00780cULL, 0x000fe40003f05070ULL, 0x0000000000127919ULL, 0x000f220000002600ULL,
0xffffffff28287811ULL, 0x000fc800078e08ffULL, 0x0000000128287807ULL, 0x000fca0004000000ULL,
0x0000000108087824ULL, 0x000fca00078e0228ULL, 0x000000060800720cULL, 0x000fe20003f06070ULL,
0x0000000210107824ULL, 0x004fe200078e00ffULL, 0x00000004ff187819ULL, 0x008fc60000011637ULL,
0x0000640010107624ULL, 0x000fe400078e0213ULL, 0x0000008012127824ULL, 0x010fe400078e00ffULL,
0x0000000119317824ULL, 0x000fe400078e0218ULL, 0x00000004091c7c24ULL, 0x000fe4000f8e0212ULL,
0x0000002810108210ULL, 0x000fe20007ffe026ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0x0000007f31127812ULL, 0x000fe200078ec0ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x000000401c1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000600010108625ULL, 0x000fe200078e0011ULL,
0x00000040050f7811ULL, 0x000fc400078e40ffULL, 0x0000000218167810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000000f04147217ULL, 0x000fe20007800000ULL,
0x0000000112137824ULL, 0x000fe400078e021cULL, 0x0000001037337824ULL, 0x000fe200078e00ffULL,
0x0000000105127810ULL, 0x000fe20007ffe0ffULL, 0x0000000610098981ULL, 0x000562000c1e1900ULL,
0x0000000114147824ULL, 0x000fe200078e0a0fULL, 0x00000004181a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001190f7824ULL, 0x000fe200078e0216ULL, 0x000000f033307812ULL, 0x000fe200078ec0ffULL,
0x0000400000327824ULL, 0x000fe200078e00ffULL, 0x000000071200720cULL, 0x000fc40003f06070ULL,
0x0000000618207810ULL, 0x000fe20007ffe0ffULL, 0x00005e0013107625ULL, 0x084fe200078e001dULL,
0x0000004014147807ULL, 0x000fe40000000000ULL, 0x0000007f0f157812ULL, 0x000fe400078ec0ffULL,
0x00000030101e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000119107824ULL, 0x040fe200078e021aULL,
0x0000001419147217ULL, 0x000fe20007800000ULL, 0x0000000115127824ULL, 0x000fe200078e021cULL,
0x0000000818347810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e0611ULL,
0x0000007f10fc7812ULL, 0x000fe200078ec0ffULL, 0x0000000119117824ULL, 0x000fe200078e0220ULL,
0x0000000a18367810ULL, 0x000fe20007ffe0ffULL, 0x0000000114297824ULL, 0x000fe200078e0a19ULL,
0x0000000c18447810ULL, 0x000fe20007ffe0ffULL, 0x00005e0012127625ULL, 0x000fe200078e001dULL,
0x0000007f11fb7812ULL, 0x000fc400078ec0ffULL, 0x000000291600720cULL, 0x080fe20003f86070ULL,
0x00000001fc147824ULL, 0x100fe200078e021cULL, 0x000000292000720cULL, 0x000fe20003f46070ULL,
0x00000001fb167824ULL, 0x000fe200078e021cULL, 0x0000003012207210ULL, 0x000fe20007f1e0ffULL,
0x0000000119127824ULL, 0x000fe200078e0234ULL, 0x0000000e18467810ULL, 0x000fe20007ffe0ffULL,
0x00005e0014147625ULL, 0x000fe200078e001dULL, 0x000000291800720cULL, 0x000fe40003fa6070ULL,
0x0000007f12fa7812ULL, 0x000fe200078ec0ffULL, 0x00005e0016167625ULL, 0x000fe200078e001dULL,
0x000000291a00720cULL, 0x000fc60003f66070ULL, 0x000000ffff217224ULL, 0x000fe200000e0613ULL,
0x0000003014227210ULL, 0x080fe20007f1e0ffULL, 0x0000000119147824ULL, 0x000fe200078e0236ULL,
0x0000003016247210ULL, 0x000fe20007f3e0ffULL, 0x00000001fa167824ULL, 0x000fe200078e021cULL,
0x0000400032137812ULL, 0x000fe200078e0cffULL, 0x000000ffff237224ULL, 0x000fe200000e0615ULL,
0x0000007f14f97812ULL, 0x000fe200078ec0ffULL, 0x000000ffff257224ULL, 0x000fe200008e0617ULL,
0x0001400013137810ULL, 0x000fe20007ffe0ffULL, 0x00005e0016167625ULL, 0x000fc800078e001dULL,
0x0000000119157824ULL, 0x000fe200078e0244ULL, 0x00000030162a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001f9187824ULL, 0x000fe400078e021cULL, 0x0000000119167824ULL, 0x000fe200078e0246ULL,
0x0000007f15f87812ULL, 0x000fe200078ec0ffULL, 0x00005e0018187625ULL, 0x000fc600078e001dULL,
0x0000007f16f77812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e0617ULL,
0x00000030182c7210ULL, 0x080fe20007f1e0ffULL, 0x00000001f81a7824ULL, 0x100fe200078e021cULL,
0x0000000731177812ULL, 0x000fe200078ec0ffULL, 0x00000001f71c7824ULL, 0x000fe200078e021cULL,
0x000000070f187812ULL, 0x000fe200078ec0ffULL, 0x00005e001a1a7625ULL, 0x080fe200078e001dULL,
0x0000000f17177812ULL, 0x100fe400078e7837ULL, 0x0000000f18187812ULL, 0x000fe200078e7837ULL,
0x000000ffff2d7224ULL, 0x000fe200000e0619ULL, 0x0000000710197812ULL, 0x000fe200078ec0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e001dULL, 0x000000301a2e7210ULL, 0x000fc40007f3e0ffULL,
0x0000000f19357812ULL, 0x000fe200078e7837ULL, 0x0000001031177824ULL, 0x000fe200078e0217ULL,
0x0000000100197812ULL, 0x000fe200078e0cffULL, 0x000000ffff2f7224ULL, 0x000fe200008e061bULL,
0x00000007111a7812ULL, 0x000fe200078ec0ffULL, 0x00000010171b7824ULL, 0x000fe200078e0213ULL,
0x00000000190573c2ULL, 0x000ea200000e0000ULL, 0x000000301c307210ULL, 0x000fe20007f1e0ffULL,
0x000000100f187824ULL, 0x000fe200078e0218ULL, 0x0000000f1a1c7812ULL, 0x000fe200078e7837ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e1b7faeULL, 0x0007e2000e901c46ULL,
0x00000010101a7824ULL, 0x000fe200078e0235ULL, 0x000000293400720cULL, 0x080fe20003f26070ULL,
0x000000ffff317224ULL, 0x000fe200000e061dULL, 0x0000000716347812ULL, 0x000fe200078ec0ffULL,
0x00000010181d7824ULL, 0x000fe200078e0213ULL, 0x000000293600720cULL, 0x000fc40003f06070ULL,
0x000000294400720cULL, 0x080fe40003fa6070ULL, 0x00000000201d7faeULL, 0x0009e2000e101c46ULL,
0x000000294600720cULL, 0x000fe20003f86070ULL, 0x00000010111b7824ULL, 0x008fe200078e021cULL,
0x00000007121c7812ULL, 0x000fe200078ec0ffULL, 0x000000101a1f7824ULL, 0x100fe200078e0213ULL,
0x00000007141e7812ULL, 0x000fe200078ec0ffULL, 0x000000101b297824ULL, 0x000fe200078e0213ULL,
0x0000000f1c357812ULL, 0x000fe400078e7837ULL, 0x00000000221f7faeULL, 0x0007e2000d901c46ULL,
0x0001c64805057891ULL, 0x004fe2000f8e183fULL, 0x0000000715207812ULL, 0x010fe200078ec0ffULL,
0x00000010121c7824ULL, 0x000fe200078e0235ULL, 0x0000000f1e1d7812ULL, 0x100fe200078e7837ULL,
0x0000000024297faeULL, 0x0005e2000d101c46ULL, 0x0000000f201e7812ULL, 0x000fe200078e7837ULL,
0x000000101c217824ULL, 0x000fe200078e0213ULL, 0x0000000f34357812ULL, 0x000fe200078e7837ULL,
0x00000010141d7824ULL, 0x000fc400078e021dULL, 0x00000010151e7824ULL, 0x000fe200078e021eULL,
0x000000002a217faeULL, 0x0009e2000c901c46ULL, 0x00000010161f7824ULL, 0x008fe400078e0235ULL,
0x000000101d237824ULL, 0x100fe400078e0213ULL, 0x000000101e257824ULL, 0x104fe400078e0213ULL,
0x000000101f137824ULL, 0x000fe200078e0213ULL, 0x000000002c237faeULL, 0x0005e2000c101c46ULL,
0x0000000800207824ULL, 0x000fc600078e00ffULL, 0x000000002e257faeULL, 0x0005e8000e901c46ULL,
0x0000000030137faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x010fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c0020227984ULL, 0x0007220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000080001377983ULL, 0x004ea20000100800ULL, 0x0000ffff0c137812ULL, 0x000fc600078ec0ffULL,
0x01c60c00ff247984ULL, 0x000e620000000800ULL, 0x0000888013297816ULL, 0x000fca00000000ffULL,
0x8000000029137824ULL, 0x000fca00078e00ffULL, 0x8000000022ff7812ULL, 0x010fe40007804813ULL,
0x0000ffff37207812ULL, 0x00cfc800078ec0ffULL, 0x0000888020207816ULL, 0x000fca00000000ffULL,
0x8000000020217824ULL, 0x000fca00078e00ffULL, 0x8000000024ff7812ULL, 0x002fe20007824821ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff137424ULL, 0x000fe400078e00ffULL, 0x8000000020227824ULL, 0x000fe400078e00ffULL,
0x0000001300217305ULL, 0x0002a4000021f000ULL, 0x3fa0000013137823ULL, 0x002fe200000100ffULL,
0x000000210000735dULL, 0x004fe40003800000ULL, 0x01c60c00ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fc40007824822ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000247919ULL, 0x000e620000000000ULL,
0x0000007033217812ULL, 0x000fe200078ec0ffULL, 0x00000001ffa87424ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x002fc80000011624ULL, 0x0000000c13227812ULL, 0x000fca00078ec0ffULL,
0x0000000121217824ULL, 0x000fca00078e0222ULL, 0x01c0000021137984ULL, 0x000e680000000800ULL,
0x01c2000021227984ULL, 0x0004e20000000800ULL, 0x0000000a1300720bULL, 0x002fda0003f3d000ULL,
0x0000000000237806ULL, 0x000fc800008e0100ULL, 0x0000ffff232a7812ULL, 0x000fda000782c0ffULL,
0x0000035000009947ULL, 0x000fea0003800000ULL, 0x0000000a1300720bULL, 0x00cfe40003f34000ULL,
0x000000130a2c7209ULL, 0x000fe40007810000ULL, 0x00000002ff247819ULL, 0x000fc60000011624ULL,
0x8000002c0a237221ULL, 0x000fe20000010000ULL, 0x0000000824257810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b23237820ULL, 0x000fe40000410000ULL, 0x00000000000a7806ULL, 0x000fe400008e0100ULL,
0x00000023002e7308ULL, 0x000e620000000800ULL, 0x000000ff0300720cULL, 0x000fe40003f25270ULL,
0x0000ffff0a2b7812ULL, 0x000fe200078e3cffULL, 0x000000ffff0a7224ULL, 0x000fc600078e002cULL,
0x0000002b2aff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ffa87807ULL, 0x000fc60001000000ULL,
0x01c4002c21009388ULL, 0x000fe20000000800ULL, 0x0000002e0b0b7220ULL, 0x002fc60000410000ULL,
0x00001f252e257589ULL, 0x000e6400000e0000ULL, 0x8000002c13132221ULL, 0x000fe40000010000ULL,
0x00001f242e247589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b13132820ULL, 0x000fc80000410000ULL,
0x00000013000d2308ULL, 0x000ee20000000800ULL, 0x000000254b4b7220ULL, 0x082fe40000410000ULL,
0x000000254a4a7220ULL, 0x080fe40000410000ULL, 0x000000254f4f7220ULL, 0x080fe40000410000ULL,
0x000000254e4e7220ULL, 0x080fe40000410000ULL, 0x000000253f3f7220ULL, 0x080fe40000410000ULL,
0x000000253e3e7220ULL, 0x000fc40000410000ULL, 0x0000002553537220ULL, 0x080fe40000410000ULL,
0x0000002552527220ULL, 0x080fe40000410000ULL, 0x000000255b5b7220ULL, 0x080fe40000410000ULL,
0x000000255a5a7220ULL, 0x080fe40000410000ULL, 0x0000002557577220ULL, 0x080fe40000410000ULL,
0x0000002556567220ULL, 0x000fc40000410000ULL, 0x000000253b3b7220ULL, 0x080fe40000410000ULL,
0x000000253a3a7220ULL, 0x080fe40000410000ULL, 0x0000002543437220ULL, 0x080fe40000410000ULL,
0x0000002542427220ULL, 0x000fe40000410000ULL, 0x0000002449497220ULL, 0x084fe40000410000ULL,
0x0000002448487220ULL, 0x000fc40000410000ULL, 0x000000244d4d7220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x0000002450507220ULL, 0x000fc40000410000ULL, 0x0000002459597220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x0000002438387220ULL, 0x000fc40000410000ULL, 0x0000002441417220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x000fe40000410000ULL, 0x0000000d22222220ULL, 0x008fc80000410000ULL,
0x0000000b220b7221ULL, 0x00cfe20000010000ULL, 0x000000f000000947ULL, 0x000fea0003800000ULL,
0x0001c64800237811ULL, 0x000fe200078e18ffULL, 0x8000000029227824ULL, 0x000fc800078e00ffULL,
0x0000040023137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804822ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000029297824ULL, 0x000fe400078e00ffULL, 0x3e000000ff137424ULL, 0x000fc800078e00ffULL,
0x0000001300227305ULL, 0x0002a4000021f000ULL, 0x3fa0000013137823ULL, 0x002fe200000100ffULL,
0x000000220000735dULL, 0x004fe40003800000ULL, 0x0000040023227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000e27919ULL, 0x000e620000000000ULL,
0x0000000203257811ULL, 0x000fe400078e10ffULL, 0x0001400032247810ULL, 0x000fe40007ffe0ffULL,
0x00014000002e7811ULL, 0x000fe400078e70ffULL, 0x00000004ff2a7819ULL, 0x002fe400000116e2ULL,
0x00000008e2137812ULL, 0x000fc600078ec0ffULL, 0x0000000403227824ULL, 0x000fe200078e022aULL,
0x0000000713237812ULL, 0x140fe200078ec8e2ULL, 0x000000012a2a7824ULL, 0x000fe200078e0225ULL,
0x0000000713137812ULL, 0x000fe400078ef8e2ULL, 0x0000002223227212ULL, 0x040fe400078e3cffULL,
0x0000002a232c7212ULL, 0x000fe400078e3cffULL, 0x00000100132f7811ULL, 0x040fe200078e20ffULL,
0x0000001013297824ULL, 0x040fe200078e0222ULL, 0x0000020013337811ULL, 0x040fe200078e20ffULL,
0x00000010132a7824ULL, 0x040fe200078e022cULL, 0x0000030013717811ULL, 0x000fe200078e20ffULL,
0x00000001222b7824ULL, 0x000fc400078e022fULL, 0x000000102a6c7824ULL, 0x000fe400078e0224ULL,
0x000000102b347824ULL, 0x000fe400078e022eULL, 0x000000012c307824ULL, 0x000fe400078e022fULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x0000001029687824ULL, 0x000fe400078e0224ULL,
0x0000001030647824ULL, 0x000fe200078e022eULL, 0x000000003434783bULL, 0x000fe20000004200ULL,
0x0000000122317824ULL, 0x000fc400078e0233ULL, 0x000000012c337824ULL, 0x000fe200078e0233ULL,
0x000000006868783bULL, 0x000ea20000004200ULL, 0x0000001031607824ULL, 0x100fe400078e022eULL,
0x0000000122707824ULL, 0x100fe200078e0271ULL, 0x000000006464783bULL, 0x000fe20000004200ULL,
0x0000001033447824ULL, 0x100fe400078e022eULL, 0x00000010705c7824ULL, 0x000fe200078e022eULL,
0x000000006060783bULL, 0x000ee20000004200ULL, 0x000000012c717824ULL, 0x000fc600078e0271ULL,
0x000000004444783bULL, 0x000f220000004200ULL, 0x00000010712e7824ULL, 0x000fc600078e022eULL,
0x000000005c5c783bULL, 0x000f220000004200ULL, 0x00000018ff2d7819ULL, 0x002fc8000001146dULL,
0x0000002d00ad7306ULL, 0x000fe20000209400ULL, 0x00000018ff257819ULL, 0x004fe4000001146aULL,
0x00000018ff237819ULL, 0x000fca0000011468ULL, 0x0000002d00a07306ULL, 0x000fe20000205400ULL,
0x00000018ff247819ULL, 0x000fe40000011469ULL, 0x00000018ff137819ULL, 0x008fca0000011463ULL,
0x0000002d00c17306ULL, 0x0003e2000020d400ULL, 0x00000018ff227819ULL, 0x010fe40000011444ULL,
0x00000018ff9d7819ULL, 0x000fe4000001145fULL, 0x00000018ff727819ULL, 0x000fc6000001145dULL,
0x0000002500bb7306ULL, 0x000fe20000209400ULL, 0x00000018ff2d7819ULL, 0x002fce0000011437ULL,
0x0000002d008d7306ULL, 0x000ff00000209400ULL, 0x0000002d00987306ULL, 0x000ff00000205400ULL,
0x0000002d00837306ULL, 0x0003f0000020d400ULL, 0x0000002500be7306ULL, 0x000fe20000205400ULL,
0x00000018ff2d7819ULL, 0x002fce0000011467ULL, 0x0000002d00887306ULL, 0x000ff00000209400ULL,
0x0000002d00ab7306ULL, 0x000ff00000205400ULL, 0x0000002d007e7306ULL, 0x0003f0000020d400ULL,
0x0000002500c57306ULL, 0x0005e2000020d400ULL, 0x000000002e2c783bULL, 0x002e6e0000004200ULL,
0x0000002300e17306ULL, 0x000fe20000209400ULL, 0x00000018ff257819ULL, 0x004fce000001146eULL,
0x0000002300ca7306ULL, 0x000eb00000205400ULL, 0x0000002300b27306ULL, 0x000730000020d400ULL,
0x0000002400cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff237819ULL, 0x008fc4000001146bULL,
0x000000cae100720bULL, 0x004fca0003f9d000ULL, 0x0000002400d57306ULL, 0x000ea20000205400ULL,
0x00000018ffae7819ULL, 0x002fe4000001142eULL, 0x00000018ffa77819ULL, 0x000fe4000001142dULL,
0x00000018ffaf7819ULL, 0x000fc6000001142fULL, 0x0000002400b07306ULL, 0x0002e2000020d400ULL,
0x00000001b2b24812ULL, 0x010fce00078efcffULL, 0x0000001300a67306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x002fe4000001146cULL, 0x000000d5cc00720bULL, 0x004fca0003f7d000ULL,
0x0000001300a57306ULL, 0x000ff00000205400ULL, 0x0000001300797306ULL, 0x0003e2000020d400ULL,
0x00000001b0b03812ULL, 0x008fce00078efcffULL, 0x0000002500a97306ULL, 0x000fe20000209400ULL,
0x00000018ff137819ULL, 0x002fce0000011447ULL, 0x0000002500327306ULL, 0x000ff00000205400ULL,
0x0000002500b57306ULL, 0x0003f0000020d400ULL, 0x0000002300ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x002fce0000011435ULL, 0x0000002300b97306ULL, 0x000ff00000205400ULL,
0x0000002300c47306ULL, 0x0003f0000020d400ULL, 0x0000002400b17306ULL, 0x000fe20000209400ULL,
0x00000018ff237819ULL, 0x002fce000001146fULL, 0x0000002400ac7306ULL, 0x000ff00000205400ULL,
0x0000002400c27306ULL, 0x0003f0000020d400ULL, 0x00000025009e7306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x002fce0000011434ULL, 0x00000025009b7306ULL, 0x000ff00000205400ULL,
0x0000002500907306ULL, 0x0003f0000020d400ULL, 0x0000001300937306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x002fce0000011466ULL, 0x0000001300947306ULL, 0x000ff00000205400ULL,
0x0000001300757306ULL, 0x000ff0000020d400ULL, 0x0000002300b67306ULL, 0x000ff00000209400ULL,
0x0000002300cd7306ULL, 0x000ff00000205400ULL, 0x0000002300b37306ULL, 0x0003f0000020d400ULL,
0x0000002400a17306ULL, 0x000fe20000209400ULL, 0x00000018ff237819ULL, 0x002fce0000011436ULL,
0x0000002400a27306ULL, 0x000ff00000205400ULL, 0x0000002400917306ULL, 0x0003f0000020d400ULL,
0x0000009d00e87306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x002fce0000011464ULL,
0x0000009d00e77306ULL, 0x000ff00000205400ULL, 0x0000009d00137306ULL, 0x0003f0000020d400ULL,
0x00000025008a7306ULL, 0x000fe20000209400ULL, 0x00000100689d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe4000001149dULL, 0x0000002500b77306ULL, 0x000ff00000205400ULL,
0x00000025007f7306ULL, 0x0003f0000020d400ULL, 0x0000002300997306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x002fce0000011462ULL, 0x00000023009a7306ULL, 0x000ff00000205400ULL,
0x0000002300927306ULL, 0x0003f0000020d400ULL, 0x00000024008c7306ULL, 0x000fe20000209400ULL,
0x00000018ff237819ULL, 0x002fce0000011465ULL, 0x0000002400967306ULL, 0x000ff00000205400ULL,
0x0000002400817306ULL, 0x0003f0000020d400ULL, 0x0000002300877306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x002fce0000011461ULL, 0x00000023008b7306ULL, 0x000ff00000205400ULL,
0x0000002300807306ULL, 0x0003f0000020d400ULL, 0x0000002400a47306ULL, 0x000fe20000209400ULL,
0x00000018ff237819ULL, 0x002fce0000011460ULL, 0x0000002400aa7306ULL, 0x000ff00000205400ULL,
0x00000024007b7306ULL, 0x0003f0000020d400ULL, 0x0000002500827306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x002fce0000011446ULL, 0x0000002500a37306ULL, 0x000ff00000205400ULL,
0x00000025007a7306ULL, 0x000ff0000020d400ULL, 0x0000009d00d67306ULL, 0x000ff00000209400ULL,
0x0000009d00e37306ULL, 0x000e700000205400ULL, 0x0000007200d17306ULL, 0x000ff00000209400ULL,
0x0000007200d07306ULL, 0x000fe20000205400ULL, 0x000000e3d600720bULL, 0x002fce0003f5d000ULL,
0x0000007200257306ULL, 0x000ff0000020d400ULL, 0x000000ae00f27306ULL, 0x000ff00000209400ULL,
0x000000ae00f17306ULL, 0x000ff00000205400ULL, 0x000000ae00727306ULL, 0x0003f0000020d400ULL,
0x0000006900c97306ULL, 0x000fe20000009400ULL, 0x0000010069ae7824ULL, 0x002fca00078e00ffULL,
0x00000018ffc07819ULL, 0x000fe400000114aeULL, 0x0000006900d27306ULL, 0x000e700000005400ULL,
0x0000006900857306ULL, 0x0004f0000000d400ULL, 0x0000006800ce7306ULL, 0x000fe20000009400ULL,
0x0001000069697824ULL, 0x004fe200078e00ffULL, 0x000000d2c900720bULL, 0x002fe20003f1d000ULL,
0x000100006bc97824ULL, 0x000fc600078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x0000006800cf7306ULL, 0x000e6e0000005400ULL, 0x0000000185850812ULL, 0x008fe200078efcffULL,
0x0000006800847306ULL, 0x0004f0000000d400ULL, 0x0000002300867306ULL, 0x000fe20000209400ULL,
0x0001000068687824ULL, 0x004fe200078e00ffULL, 0x000000cfce00720bULL, 0x002fe20003fbd000ULL,
0x000100006ace7824ULL, 0x000fc600078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe40000011468ULL,
0x0000002300897306ULL, 0x000fe20000205400ULL, 0x00000018ffde7819ULL, 0x000fcc00000114ceULL,
0x0000000184845812ULL, 0x008fe200078efcffULL, 0x00000023007d7306ULL, 0x0003f0000020d400ULL,
0x00000024009c7306ULL, 0x000fe20000209400ULL, 0x00000018ff237819ULL, 0x002fce0000011445ULL,
0x0000002400957306ULL, 0x000ff00000205400ULL, 0x0000002400767306ULL, 0x0003f0000020d400ULL,
0x0000002200977306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x002fce000001145eULL,
0x00000022008e7306ULL, 0x000ff00000205400ULL, 0x0000002200787306ULL, 0x000ff0000020d400ULL,
0x00000023008f7306ULL, 0x000ff00000209400ULL, 0x00000023009f7306ULL, 0x000ff00000205400ULL,
0x0000002300777306ULL, 0x0003f0000020d400ULL, 0x0000002400e67306ULL, 0x000fe20000209400ULL,
0x00000018ff237819ULL, 0x002fce000001145cULL, 0x0000002400d47306ULL, 0x000ff00000205400ULL,
0x0000002400227306ULL, 0x000ff0000020d400ULL, 0x000000a700f47306ULL, 0x000ff00000209400ULL,
0x000000a700f37306ULL, 0x000ff00000205400ULL, 0x000000a700247306ULL, 0x000ff0000020d400ULL,
0x0000009d00a77306ULL, 0x0002b0000020d400ULL, 0x0000006900b47306ULL, 0x000fe20000209400ULL,
0x000001006a9d7824ULL, 0x002fca00078e00ffULL, 0x00000018ffd37819ULL, 0x000fe2000001149dULL,
0x000001006b9d7824ULL, 0x000fe200078e00ffULL, 0x0000006900df7306ULL, 0x000e620000205400ULL,
0x00000001a7a72812ULL, 0x004fc600078efcffULL, 0x00000018ffd77819ULL, 0x000fe4000001149dULL,
0x00000084a784723eULL, 0x000fe400000010ffULL, 0x000000bd00687306ULL, 0x000ff00000209400ULL,
0x000000bd00dd7306ULL, 0x000ea20000205400ULL, 0x000000dfb400720bULL, 0x002fce0003f9d000ULL,
0x0000002300cb7306ULL, 0x000ff00000209400ULL, 0x00000023007c7306ULL, 0x000fe20000205400ULL,
0x000000dd6800720bULL, 0x004fe20003f5d000ULL, 0x000100006c687824ULL, 0x000fcc00078e00ffULL,
0x0000002300747306ULL, 0x0003f0000020d400ULL, 0x000000af00f07306ULL, 0x000fe20000209400ULL,
0x00000018ff237819ULL, 0x002fce000001142cULL, 0x0000002300f67306ULL, 0x000ff00000209400ULL,
0x0000002300f57306ULL, 0x000ff00000205400ULL, 0x0000002300737306ULL, 0x000ff0000020d400ULL,
0x000000af00e97306ULL, 0x000ff00000205400ULL, 0x000000af00237306ULL, 0x000ff0000020d400ULL,
0x000000c000af7306ULL, 0x000ff00000209400ULL, 0x000000c000dc7306ULL, 0x000ff00000205400ULL,
0x000000c000ae7306ULL, 0x000ff0000020d400ULL, 0x0000006a00c07306ULL, 0x000ff00000009400ULL,
0x0000006a00c77306ULL, 0x000e700000005400ULL, 0x0000006900b87306ULL, 0x000eb0000020d400ULL,
0x000000bd00bc7306ULL, 0x000ee2000020d400ULL, 0x000000c7c000720bULL, 0x002fce0003fdd000ULL,
0x0000006b00697306ULL, 0x000fe20000009400ULL, 0x00000001b8b84812ULL, 0x004fe400078efcffULL,
0x000000bebb00720bULL, 0x000fe20003f9d000ULL, 0x000001006fbb7824ULL, 0x000fc800078e00ffULL,
0x0000006b00d87306ULL, 0x000e620000005400ULL, 0x00000001bcbc2812ULL, 0x008fe400078efcffULL,
0x000000dcaf00720bULL, 0x000fe40003f5d000ULL, 0x00000018ffbb7819ULL, 0x000fc600000114bbULL,
0x0000006b00da7306ULL, 0x0004e2000000d400ULL, 0x00000001c5c54812ULL, 0x000fce00078efcffULL,
0x000000d700c67306ULL, 0x000fe20000209400ULL, 0x000001006c6b7824ULL, 0x004fe200078e00ffULL,
0x000000d86900720bULL, 0x002fe40003f3d000ULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x00000018ffe07819ULL, 0x000fe4000001146bULL, 0x000000d700bd7306ULL, 0x000e620000205400ULL,
0x00000085ae85723eULL, 0x000fcc00000010ffULL, 0x00000001dada1812ULL, 0x008fe200078efcffULL,
0x000000e000c07306ULL, 0x000fe20000209400ULL, 0x000000acb100720bULL, 0x000fe40003f3d000ULL,
0x00000007e2b17812ULL, 0x000fc800078ec0ffULL, 0x00000008b1b17812ULL, 0x000fe200078ef8e2ULL,
0x000000e000cf7306ULL, 0x000ea20000205400ULL, 0x000000bdc600720bULL, 0x002fca0003f7d000ULL,
0x00000001c2c21812ULL, 0x000fe400078efcffULL, 0x000000d300bf7306ULL, 0x000fe20000209400ULL,
0x000000cdb600720bULL, 0x000fce0003f3d000ULL, 0x000000d300c87306ULL, 0x000e620000205400ULL,
0x000000cfc000720bULL, 0x004fca0003f9d000ULL, 0x00000001b3b31812ULL, 0x000fe400078efcffULL,
0x0000006a00db7306ULL, 0x0004f0000000d400ULL, 0x000000d7009d7306ULL, 0x000f22000020d400ULL,
0x00000018ff6a7819ULL, 0x004fc400000114c9ULL, 0x000000c8bf00720bULL, 0x002fca0003f5d000ULL,
0x000000d300c37306ULL, 0x000e62000020d400ULL, 0x00000001dbdb6812ULL, 0x008fce00078efcffULL,
0x000000de00ce7306ULL, 0x000fe20000209400ULL, 0x000000019d9d3812ULL, 0x010fe400078efcffULL,
0x000000b9ba00720bULL, 0x000fca0003f7d000ULL, 0x000000de00d37306ULL, 0x000ea20000205400ULL,
0x00000001c3c32812ULL, 0x002fce00078efcffULL, 0x000000de00d97306ULL, 0x000e62000020d400ULL,
0x00000001c4c43812ULL, 0x000fce00078efcffULL, 0x0000006a00d27306ULL, 0x000fe20000209400ULL,
0x000000d3ce00720bULL, 0x004fce0003f5d000ULL, 0x0000006a00d77306ULL, 0x000eac0000205400ULL,
0x00000001d9d92812ULL, 0x002fe400078efcffULL, 0x0000006c00697306ULL, 0x000fe20000009400ULL,
0x000000a0ad00720bULL, 0x000fce0003f5d000ULL, 0x0000006c00de7306ULL, 0x000e620000005400ULL,
0x000000d7d200720bULL, 0x004fca0003fdd000ULL, 0x00000001c1c12812ULL, 0x000fe400078efcffULL,
0x0000006c00d87306ULL, 0x0005f0000000d400ULL, 0x0000006a00c97306ULL, 0x000722000020d400ULL,
0x000100006d6c7824ULL, 0x004fe200078e00ffULL, 0x000000de6900720bULL, 0x002fc40003fbd000ULL,
0x00000018ffde7819ULL, 0x000fe40000011468ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000006d00d67306ULL, 0x000fe20000009400ULL, 0x000001006d6a7824ULL, 0x008fca00078e00ffULL,
0x00000018ffe17819ULL, 0x000fe4000001146aULL, 0x0000006d00dd7306ULL, 0x000e620000005400ULL,
0x00000001c9c96812ULL, 0x010fe400078efcffULL, 0x00000001d8d85812ULL, 0x000fca00078efcffULL,
0x0000006d00cc7306ULL, 0x0004f0000000d400ULL, 0x000000e000c77306ULL, 0x000f22000020d400ULL,
0x000001006e6d7824ULL, 0x004fe200078e00ffULL, 0x000000ddd600720bULL, 0x002fc80003f1d000ULL,
0x00000018ffdf7819ULL, 0x000fe4000001146dULL, 0x0000006c00af7306ULL, 0x000fee0000209400ULL,
0x00000001cccc0812ULL, 0x008fe200078efcffULL, 0x0000006c00b47306ULL, 0x000fe20000205400ULL,
0x00000001c7c74812ULL, 0x010fc400078efcffULL, 0x00000032a900720bULL, 0x000fe20003f9d000ULL,
0x000100006f327824ULL, 0x000fc800078e00ffULL, 0x0000006c00c87306ULL, 0x000ff0000020d400ULL,
0x0000006e006c7306ULL, 0x000fe20000009400ULL, 0x00000001b5b54812ULL, 0x000fce00078efcffULL,
0x0000006e006d7306ULL, 0x000e700000005400ULL, 0x000000e1006a7306ULL, 0x000ff00000209400ULL,
0x000000e1006b7306ULL, 0x000ea20000205400ULL, 0x0000006d6c00720bULL, 0x002fc40003f7d000ULL,
0x00000018ff6d7819ULL, 0x000fe40000011432ULL, 0x00000004ff327819ULL, 0x000fc600000116e2ULL,
0x000000e100ca7306ULL, 0x000e62000020d400ULL, 0x0000000732327812ULL, 0x000fca00078e78b1ULL,
0x00000008b1327824ULL, 0x000fe400078e0232ULL, 0x000000de00687306ULL, 0x000fe20000209400ULL,
0x0000006b6a00720bULL, 0x004fe20003fdd000ULL, 0x000100006e6a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x000000de00697306ULL, 0x000eac0000205400ULL,
0x00000001caca6812ULL, 0x002fe400078efcffULL, 0x0000006f006b7306ULL, 0x000ff00000009400ULL,
0x0000006f006c7306ULL, 0x000e620000005400ULL, 0x000000696800720bULL, 0x004fc40003fdd000ULL,
0x0001200032687811ULL, 0x000fca00078e20ffULL, 0x0000006a00ce7306ULL, 0x000ff00000209400ULL,
0x0000006a00cf7306ULL, 0x000fe20000205400ULL, 0x0000006c6b00720bULL, 0x002fe40003fbd000ULL,
0x0000000dff6c723eULL, 0x000fc800000010ffULL, 0x000054106cc67816ULL, 0x000fe2000000006cULL,
0x0000006a00ba7306ULL, 0x0003e2000020d400ULL, 0x00000100346c7824ULL, 0x000fce00078e00ffULL,
0x0000006f00be7306ULL, 0x0004e2000000d400ULL, 0x000000006868783bULL, 0x002fee0000000200ULL,
0x000000bb00d67306ULL, 0x000fe20000209400ULL, 0x00000002ff6f7819ULL, 0x004fc800000116e2ULL,
0x000000086fa97810ULL, 0x000fc60007ffe0ffULL, 0x000000bb00d77306ULL, 0x000e620000205400ULL,
0x00000001bebe5812ULL, 0x008fe400078efcffULL, 0x000000a2a100720bULL, 0x000fca0003fbd000ULL,
0x000000bb00bd7306ULL, 0x0004f0000020d400ULL, 0x0000006d00d27306ULL, 0x000fe20000209400ULL,
0x00000018ffbb7819ULL, 0x004fe4000001146cULL, 0x00001fa9c66c7589ULL, 0x000fe200000e0000ULL,
0x000000d7d600720bULL, 0x002fc40003f5d000ULL, 0x0000000191915812ULL, 0x000fe400078efcffULL,
0x0000006d00d37306ULL, 0x000ff00000205400ULL, 0x0000006d00b97306ULL, 0x0003e2000020d400ULL,
0x00000001bdbd2812ULL, 0x008fce00078efcffULL, 0x0000006e00c07306ULL, 0x0004e2000000d400ULL,
0x00001f6fc66d7589ULL, 0x002e6e00000e0000ULL, 0x000000de00d57306ULL, 0x000862000020d400ULL,
0x00009910a86e7816ULL, 0x004fc800000000ffULL, 0x000000ff6e00720cULL, 0x000fe20003f05270ULL,
0x00010000346e7824ULL, 0x000fe400078e00ffULL, 0x0000003400ac7306ULL, 0x000fe20000009400ULL,
0x00000001c0c03812ULL, 0x008fe400078efcffULL, 0x000000d3d200720bULL, 0x000fe40003f7d000ULL,
0x00000018ffde7819ULL, 0x010fc6000001146eULL, 0x0000003400ad7306ULL, 0x000ea20000005400ULL,
0x00000001d5d56812ULL, 0x002fe200078efcffULL, 0x0000006d68688231ULL, 0x080fe200003400ffULL,
0x000000b4af00720bULL, 0x000fe20003fdd000ULL, 0x0000006d6a6a8231ULL, 0x000fe400003400ffULL,
0x0000006c69698231ULL, 0x080fe400003400ffULL, 0x0000006c6b6b8231ULL, 0x000fe200003400ffULL,
0x000000df00dc7306ULL, 0x000fe20000209400ULL, 0x00000001b9b93812ULL, 0x000fca00078efcffULL,
0x000000846840723cULL, 0x000fe20000041840ULL, 0x000000adac00720bULL, 0x004fe20003f7d000ULL,
0x000000df00dd7306ULL, 0x000e620000205400ULL, 0x00000001c8c86812ULL, 0x000fc800078efcffULL,
0x0000010035847824ULL, 0x000fe200078e00ffULL, 0x000000b8b085723eULL, 0x000fe400000010ffULL,
0x000000df00bf7306ULL, 0x0005f0000020d400ULL, 0x0000003400a07306ULL, 0x000ee2000000d400ULL,
0x00000018ffdf7819ULL, 0x004fc40000011484ULL, 0x000000bcb284723eULL, 0x000fe200000010ffULL,
0x0001000035b27824ULL, 0x000fe200078e00ffULL, 0x000000dddc00720bULL, 0x002fc60003fdd000ULL,
0x000000bb00a97306ULL, 0x000fe20000209400ULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x000000846838723cULL, 0x000fec0000041838ULL, 0x000000bb00a87306ULL, 0x000e620000205400ULL,
0x0000010036847824ULL, 0x000fe200078e00ffULL, 0x000000da9d85723eULL, 0x000fc400000010ffULL,
0x00000001a0a03812ULL, 0x008fe400078efcffULL, 0x00000001bfbf6812ULL, 0x000fe400078efcffULL,
0x000000bb00347306ULL, 0x000ea2000020d400ULL, 0x000000cfce00720bULL, 0x000fce0003fdd000ULL,
0x000000df00bb7306ULL, 0x000fec0000209400ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x000000df00af7306ULL, 0x000ee20000205400ULL, 0x000000a8a900720bULL, 0x002fce0003fdd000ULL,
0x000000de006f7306ULL, 0x000fec0000209400ULL, 0x0000000134346812ULL, 0x004fe400078efcffULL,
0x000000de00a77306ULL, 0x000e620000205400ULL, 0x000000afbb00720bULL, 0x008fe40003f7d000ULL,
0x000000a03434723eULL, 0x000fca00000010ffULL, 0x000000de006e7306ULL, 0x0004f0000020d400ULL,
0x0000003500ae7306ULL, 0x000fe20000009400ULL, 0x00000018ffde7819ULL, 0x004fe40000011484ULL,
0x000000dbc384723eULL, 0x000fc400000010ffULL, 0x000000a76f00720bULL, 0x002fc60003fdd000ULL,
0x0000003500b47306ULL, 0x000e640000005400ULL, 0x000000846854723cULL, 0x000fec0000041854ULL,
0x0000003500c67306ULL, 0x000ea2000000d400ULL, 0x000000d9c584723eULL, 0x000fe400000010ffULL,
0x000000c9c485723eULL, 0x000fe200000010ffULL, 0x0000010037c47824ULL, 0x000fe200078e00ffULL,
0x000000016e6e6812ULL, 0x008fc600078efcffULL, 0x000000df00357306ULL, 0x000ee2000020d400ULL,
0x000000b4ae00720bULL, 0x002fe20003f3d000ULL, 0x000000846858723cULL, 0x000fe20000041858ULL,
0x00000018ffda7819ULL, 0x000fca00000114c4ULL, 0x000000b200b87306ULL, 0x000fe20000209400ULL,
0x000000d8c784723eULL, 0x000fe200000010ffULL, 0x0001000036d87824ULL, 0x000fe200078e00ffULL,
0x000000ccca85723eULL, 0x000fc600000010ffULL, 0x00000001c6c61812ULL, 0x004fe400078efcffULL,
0x000000b200b07306ULL, 0x000e620000205400ULL, 0x0000000135353812ULL, 0x008fe200078efcffULL,
0x000000846850723cULL, 0x000fe20000041850ULL, 0x00000018ffd97819ULL, 0x000fe400000114d8ULL,
0x0000009b9e00720bULL, 0x000fe40003f3d000ULL, 0x000000c63535723eULL, 0x000fe200000010ffULL,
0x000000b200b27306ULL, 0x000ea2000020d400ULL, 0x000000d5c284723eULL, 0x000fc400000010ffULL,
0x000000c8c185723eULL, 0x000fca00000010ffULL, 0x000000de00bc7306ULL, 0x000fe20000209400ULL,
0x000000b0b800720bULL, 0x002fe20003f7d000ULL, 0x00000084683c723cULL, 0x000fe2000004183cULL,
0x0000000190901812ULL, 0x000fca00078efcffULL, 0x000000de00c37306ULL, 0x000e620000205400ULL,
0x000000c0bf84723eULL, 0x000fe200000010ffULL, 0x0001000037bf7824ULL, 0x000fe200078e00ffULL,
0x000000bebd85723eULL, 0x000fc600000010ffULL, 0x00000001b2b23812ULL, 0x004fe400078efcffULL,
0x000000de009d7306ULL, 0x000ea2000020d400ULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x00000084684c723cULL, 0x000fec000004184cULL, 0x000000d900cc7306ULL, 0x000fe20000209400ULL,
0x000000c3bc00720bULL, 0x002fc40003f7d000ULL, 0x000000bab584723eULL, 0x000fe200000010ffULL,
0x0000010064b57824ULL, 0x000fe200078e00ffULL, 0x000000b9b385723eULL, 0x000fc600000010ffULL,
0x000000d900ca7306ULL, 0x000e620000205400ULL, 0x00000018ffb57819ULL, 0x000fc600000114b5ULL,
0x000000846848723cULL, 0x000fe40000041848ULL, 0x000000019d9d3812ULL, 0x004fe400078efcffULL,
0x0000003600b67306ULL, 0x000fe60000009400ULL, 0x0000010065687824ULL, 0x040fe400078e00ffULL,
0x0001000065847824ULL, 0x000fc600078e00ffULL, 0x0000003600cd7306ULL, 0x000ea20000005400ULL,
0x000000cacc00720bULL, 0x002fe40003f7d000ULL, 0x00000018ff6b7819ULL, 0x000fe20000011468ULL,
0x0001000064687824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fc60000011484ULL,
0x0000003600c57306ULL, 0x000e62000000d400ULL, 0x00000018ff687819ULL, 0x000fce0000011468ULL,
0x000000d900367306ULL, 0x000ee2000020d400ULL, 0x000000cdb600720bULL, 0x004fce0003f9d000ULL,
0x000000bf00d27306ULL, 0x000fec0000209400ULL, 0x00000001c5c54812ULL, 0x002fe400078efcffULL,
0x000000bf00d37306ULL, 0x000e620000205400ULL, 0x0000000136363812ULL, 0x008fce00078efcffULL,
0x0000003700d87306ULL, 0x000ff00000009400ULL, 0x0000003700db7306ULL, 0x000ea20000005400ULL,
0x000000d3d200720bULL, 0x002fce0003f7d000ULL, 0x0000003700c87306ULL, 0x000e70000000d400ULL,
0x000000bf00377306ULL, 0x000ee2000020d400ULL, 0x000000dbd800720bULL, 0x004fce0003f5d000ULL,
0x000000b500d57306ULL, 0x000fec0000209400ULL, 0x00000001c8c82812ULL, 0x002fe400078efcffULL,
0x000000b500e57306ULL, 0x000e620000205400ULL, 0x0000000137373812ULL, 0x008fe400078efcffULL,
0x0000009a9900720bULL, 0x000fca0003f5d000ULL, 0x000000b500c17306ULL, 0x000eb0000020d400ULL,
0x0000006800e37306ULL, 0x000fe20000209400ULL, 0x000000e5d500720bULL, 0x002fe40003f7d000ULL,
0x0000000192922812ULL, 0x000fc400078efcffULL, 0x000000988d00720bULL, 0x000fc60003f5d000ULL,
0x0000006800e47306ULL, 0x000e6c0000205400ULL, 0x00000001c1c13812ULL, 0x004fe400078efcffULL,
0x0000006500697306ULL, 0x000fe40000009400ULL, 0x0000000183832812ULL, 0x000fcc00078efcffULL,
0x00000065006a7306ULL, 0x000ea20000005400ULL, 0x000000e4e300720bULL, 0x002fce0003f7d000ULL,
0x0000006800bf7306ULL, 0x000e70000020d400ULL, 0x0000006400de7306ULL, 0x000fe20000009400ULL,
0x0000006a6900720bULL, 0x004fe20003fbd000ULL, 0x0000010063697824ULL, 0x000fca00078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011469ULL, 0x0000006400e07306ULL, 0x000ea20000005400ULL,
0x00000001bfbf3812ULL, 0x002fce00078efcffULL, 0x0000006400c27306ULL, 0x0002f0000000d400ULL,
0x0000008400dd7306ULL, 0x000fe20000209400ULL, 0x0000010066647824ULL, 0x002fe200078e00ffULL,
0x000000e0de00720bULL, 0x004fcc0003fdd000ULL, 0x0000008400df7306ULL, 0x000e6e0000205400ULL,
0x00000001c2c26812ULL, 0x008fe200078efcffULL, 0x0000006500c07306ULL, 0x0004f0000000d400ULL,
0x0000008400bd7306ULL, 0x000f22000020d400ULL, 0x00000018ff657819ULL, 0x004fe20000011464ULL,
0x0000010067647824ULL, 0x000fe200078e00ffULL, 0x000000dfdd00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff687819ULL, 0x000fe20000011464ULL, 0x0000006500d67306ULL, 0x000fe20000209400ULL,
0x00000001c0c05812ULL, 0x008fe400078efcffULL, 0x000000968c00720bULL, 0x000fca0003fbd000ULL,
0x0000006500d77306ULL, 0x000e620000205400ULL, 0x00000001bdbd3812ULL, 0x010fce00078efcffULL,
0x0000006500b97306ULL, 0x0004e2000020d400ULL, 0x0000000181815812ULL, 0x000fe400078efcffULL,
0x0000008b8700720bULL, 0x000fca0003fbd000ULL, 0x0000006600e17306ULL, 0x000fe20000009400ULL,
0x0001000066657824ULL, 0x004fe200078e00ffULL, 0x000000d7d600720bULL, 0x002fc80003f7d000ULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x0000006600ec7306ULL, 0x000e620000005400ULL,
0x0000000180805812ULL, 0x000fcc00078efcffULL, 0x00000001b9b93812ULL, 0x008fe200078efcffULL,
0x0000006600ba7306ULL, 0x0004f0000000d400ULL, 0x000000da00c47306ULL, 0x000fe20000209400ULL,
0x0001000067667824ULL, 0x004fe200078e00ffULL, 0x000000ece100720bULL, 0x002fc40003f9d000ULL,
0x0000000000ec7919ULL, 0x000e640000000000ULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x000000da00c97306ULL, 0x000eae0000205400ULL, 0x00000001baba4812ULL, 0x008fe200078efcffULL,
0x000000da00c77306ULL, 0x000ef0000020d400ULL, 0x0000006500d97306ULL, 0x000fe20000209400ULL,
0x000000c9c400720bULL, 0x004fce0003f3d000ULL, 0x0000006500da7306ULL, 0x000eac0000205400ULL,
0x00000001c7c71812ULL, 0x008fe400078efcffULL, 0x0000006500b67306ULL, 0x000730000020d400ULL,
0x0000006600ce7306ULL, 0x000fe20000209400ULL, 0x0000010060657824ULL, 0x008fe200078e00ffULL,
0x000000dad900720bULL, 0x004fc80003f7d000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x0000006600cf7306ULL, 0x000eae0000205400ULL, 0x00000001b6b63812ULL, 0x010fe200078efcffULL,
0x0000006600b47306ULL, 0x000730000020d400ULL, 0x0000006800647306ULL, 0x000fe20000209400ULL,
0x0001000060667824ULL, 0x008fe200078e00ffULL, 0x000000cfce00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x0000006800857306ULL, 0x000eae0000205400ULL,
0x00000001b4b43812ULL, 0x010fe200078efcffULL, 0x0000006800b37306ULL, 0x000ef0000020d400ULL,
0x0000006500687306ULL, 0x000fe20000209400ULL, 0x000000856400720bULL, 0x004fce0003fbd000ULL,
0x0000006500bb7306ULL, 0x000eac0000205400ULL, 0x00000001b3b35812ULL, 0x008fe400078efcffULL,
0x0000006500af7306ULL, 0x000722000020d400ULL, 0x000000b78a00720bULL, 0x000fce0003fbd000ULL,
0x0000006000ea7306ULL, 0x000fe20000009400ULL, 0x0000010061657824ULL, 0x008fe200078e00ffULL,
0x000000bb6800720bULL, 0x004fe20003f7d000ULL, 0x000001005d687824ULL, 0x000fc600078e00ffULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x0000006000eb7306ULL, 0x000ea20000005400ULL,
0x000000898600720bULL, 0x000fe40003fbd000ULL, 0x00000018ff687819ULL, 0x000fc80000011468ULL,
0x00000001afaf3812ULL, 0x010fe200078efcffULL, 0x0000006b00dc7306ULL, 0x000fec0000209400ULL,
0x000000017d7d5812ULL, 0x000fe400078efcffULL, 0x0000006b00e27306ULL, 0x000ee20000205400ULL,
0x000000ebea00720bULL, 0x004fc40003fdd000ULL, 0x000000aaa400720bULL, 0x000fca0003fbd000ULL,
0x0000006b00be7306ULL, 0x000eb0000020d400ULL, 0x00000066006b7306ULL, 0x000fe20000209400ULL,
0x000000e2dc00720bULL, 0x008fe40003f5d000ULL, 0x000000017b7b5812ULL, 0x000fca00078efcffULL,
0x0000006600847306ULL, 0x000fec0000205400ULL, 0x00000001bebe2812ULL, 0x004fe400078efcffULL,
0x0000006600ac7306ULL, 0x0005f0000020d400ULL, 0x0000006000ad7306ULL, 0x000ee2000000d400ULL,
0x00000018ff667819ULL, 0x004fe20000011465ULL, 0x0001000061657824ULL, 0x000fcc00078e00ffULL,
0x0000006700ed7306ULL, 0x000ff00000009400ULL, 0x0000006700ef7306ULL, 0x000ea20000005400ULL,
0x00000001adad6812ULL, 0x008fce00078efcffULL, 0x0000006100607306ULL, 0x000ff00000009400ULL,
0x0000006100ee7306ULL, 0x000ee20000005400ULL, 0x000000efed00720bULL, 0x004fce0003f3d000ULL,
0x0000006100ae7306ULL, 0x000530000000d400ULL, 0x0000006700b57306ULL, 0x000322000000d400ULL,
0x0000010062617824ULL, 0x004fe200078e00ffULL, 0x000000ee6000720bULL, 0x008fe20003f5d000ULL,
0x0001000044607824ULL, 0x000fc600078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006300cc7306ULL, 0x000fe20000009400ULL, 0x00000018ff677819ULL, 0x002fe40000011465ULL,
0x00000018ff607819ULL, 0x000fc80000011460ULL, 0x00000001aeae2812ULL, 0x010fe200078efcffULL,
0x0000006300e17306ULL, 0x000e620000005400ULL, 0x00000001b5b51812ULL, 0x000fe400078efcffULL,
0x000000ab8800720bULL, 0x000fe40003f3d000ULL, 0x000000a38200720bULL, 0x000fc60003f5d000ULL,
0x0000006600cd7306ULL, 0x000ff00000209400ULL, 0x0000006600e07306ULL, 0x000ea20000205400ULL,
0x000000e1cc00720bULL, 0x002fe40003fdd000ULL, 0x000000017e7e1812ULL, 0x000fc400078efcffULL,
0x000000846b00720bULL, 0x000fe40003f3d000ULL, 0x000000017a7a2812ULL, 0x000fe200078efcffULL,
0x0000006600b07306ULL, 0x000e70000020d400ULL, 0x0000006100657306ULL, 0x000fe20000209400ULL,
0x000000e0cd00720bULL, 0x004fc40003f7d000ULL, 0x00000001acac1812ULL, 0x000fca00078efcffULL,
0x0000006100667306ULL, 0x000fec0000205400ULL, 0x00000001b0b03812ULL, 0x002fe400078efcffULL,
0x0000006100a87306ULL, 0x0003f0000020d400ULL, 0x0000006200b87306ULL, 0x000fe20000009400ULL,
0x0001000062617824ULL, 0x002fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006200bc7306ULL, 0x000e700000005400ULL, 0x0000006200a77306ULL, 0x0005f0000000d400ULL,
0x0000006300a17306ULL, 0x000722000000d400ULL, 0x0001000063627824ULL, 0x004fe200078e00ffULL,
0x000000bcb800720bULL, 0x002fc80003f9d000ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000006100d37306ULL, 0x000fe20000209400ULL, 0x0000010044637824ULL, 0x008fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000006100de7306ULL, 0x000fe20000205400ULL,
0x00000001a1a16812ULL, 0x010fe400078efcffULL, 0x00000001a7a74812ULL, 0x000fca00078efcffULL,
0x0000006300ca7306ULL, 0x000ff00000209400ULL, 0x0000006300d27306ULL, 0x000e700000205400ULL,
0x0000006100a27306ULL, 0x0005f0000020d400ULL, 0x0000006200d87306ULL, 0x000fe20000209400ULL,
0x0000010045617824ULL, 0x004fe200078e00ffULL, 0x000000d2ca00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000006200db7306ULL, 0x000e700000205400ULL,
0x00000067006a7306ULL, 0x000ff00000209400ULL, 0x00000067006f7306ULL, 0x000ea20000205400ULL,
0x000000dbd800720bULL, 0x002fce0003f9d000ULL, 0x0000006700a97306ULL, 0x000e70000020d400ULL,
0x0000009b00677306ULL, 0x000fe20000209400ULL, 0x0000006f6a00720bULL, 0x004fce0003f7d000ULL,
0x0000009b00697306ULL, 0x000eac0000205400ULL, 0x00000001a9a93812ULL, 0x002fe400078efcffULL,
0x0000009b009e7306ULL, 0x000e62000020d400ULL, 0x000000666500720bULL, 0x000fce0003f7d000ULL,
0x00000062009b7306ULL, 0x000ee2000020d400ULL, 0x000000696700720bULL, 0x004fca0003fbd000ULL,
0x00000001a8a83812ULL, 0x000fe400078efcffULL, 0x0000006100627306ULL, 0x000fe20000209400ULL,
0x000000ded300720bULL, 0x000fca0003f7d000ULL, 0x000000019e9e5812ULL, 0x002fe400078efcffULL,
0x0000006100c97306ULL, 0x000e620000205400ULL, 0x000000019b9b4812ULL, 0x008fe400078efcffULL,
0x0000008e9700720bULL, 0x000fe40003f9d000ULL, 0x000000a5a600720bULL, 0x000fe40003fbd000ULL,
0x00000001a2a23812ULL, 0x000fe200078efcffULL, 0x00000061008d7306ULL, 0x0005e6000020d400ULL,
0x000000a27a7a723eULL, 0x000fca00000010ffULL, 0x0000006300997306ULL, 0x000722000020d400ULL,
0x0001000045617824ULL, 0x004fe200078e00ffULL, 0x0000000179795812ULL, 0x000fe400078efcffULL,
0x000000c96200720bULL, 0x002fe40003fbd000ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000004400e27306ULL, 0x000fe20000009400ULL, 0x0000010046637824ULL, 0x008fe200078e00ffULL,
0x0000000178784812ULL, 0x000fc800078efcffULL, 0x00000018ffc37819ULL, 0x000fe40000011463ULL,
0x0000004400e37306ULL, 0x000e620000005400ULL, 0x0000000199996812ULL, 0x010fe400078efcffULL,
0x000000018d8d5812ULL, 0x000fe400078efcffULL, 0x0000009f8f00720bULL, 0x000fc60003fbd000ULL,
0x00000044009a7306ULL, 0x000eb0000000d400ULL, 0x0000006000447306ULL, 0x000fe20000209400ULL,
0x000000e3e200720bULL, 0x002fe40003f3d000ULL, 0x0000000177775812ULL, 0x000fca00078efcffULL,
0x0000006000df7306ULL, 0x000e6c0000205400ULL, 0x000000019a9a1812ULL, 0x004fe400078efcffULL,
0x0000006000987306ULL, 0x0004e4000020d400ULL, 0x0000009a999a723eULL, 0x000fcc00000010ffULL,
0x0000004500dc7306ULL, 0x000fe20000009400ULL, 0x0000010047607824ULL, 0x004fe200078e00ffULL,
0x000000df4400720bULL, 0x002fe20003fdd000ULL, 0x000100005e447824ULL, 0x000fc600078e00ffULL,
0x00000018ff857819ULL, 0x000fe40000011460ULL, 0x0000004500dd7306ULL, 0x000e620000005400ULL,
0x00000018ff8e7819ULL, 0x000fe40000011444ULL, 0x00000002ec447811ULL, 0x000fc800078fe0ffULL,
0x0000000744447812ULL, 0x000fe200078e78b1ULL, 0x0000004500967306ULL, 0x000ea2000000d400ULL,
0x0000000198986812ULL, 0x008fc600078efcffULL, 0x00000008b1977824ULL, 0x000fe200078e0244ULL,
0x000000987878723eULL, 0x000fc600000010ffULL, 0x0000006100457306ULL, 0x000fe20000209400ULL,
0x0001200097447811ULL, 0x000fe400078e20ffULL, 0x000000dddc00720bULL, 0x002fca0003f7d000ULL,
0x0000006100d57306ULL, 0x000e700000205400ULL, 0x00000061008c7306ULL, 0x000ee2000020d400ULL,
0x0000000196963812ULL, 0x004fce00078efcffULL, 0x0000008500607306ULL, 0x000fe20000209400ULL,
0x000000d54500720bULL, 0x002fe20003f3d000ULL, 0x000100005f457824ULL, 0x000fcc00078e00ffULL,
0x0000008500617306ULL, 0x000fec0000205400ULL, 0x000000018c8c1812ULL, 0x008fe400078efcffULL,
0x0000008500877306ULL, 0x0003f0000020d400ULL, 0x0000004600e47306ULL, 0x000fe20000009400ULL,
0x0001000046857824ULL, 0x002fca00078e00ffULL, 0x00000018ff857819ULL, 0x000fe40000011485ULL,
0x0000004600e57306ULL, 0x000e700000005400ULL, 0x00000046008a7306ULL, 0x0004f0000000d400ULL,
0x0000004700b77306ULL, 0x000fe20000009400ULL, 0x0001000047467824ULL, 0x004fe200078e00ffULL,
0x000000e5e400720bULL, 0x002fc80003f5d000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004700b87306ULL, 0x000e6e0000005400ULL, 0x000000018a8a2812ULL, 0x008fe200078efcffULL,
0x0000004700887306ULL, 0x0004e2000000d400ULL, 0x000000616000720bULL, 0x000fce0003f5d000ULL,
0x0000004600d67306ULL, 0x000fe20000209400ULL, 0x000001005c477824ULL, 0x004fe200078e00ffULL,
0x000000b8b700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004600d77306ULL, 0x000fe20000205400ULL, 0x0000000187872812ULL, 0x000fe400078efcffULL,
0x000000949300720bULL, 0x000fe40003f5d000ULL, 0x000000c2c194723eULL, 0x000fe400000010ffULL,
0x0000000188886812ULL, 0x008fe200078efcffULL, 0x0000004600867306ULL, 0x0003f0000020d400ULL,
0x0000005c00e07306ULL, 0x000fe20000009400ULL, 0x000100005c467824ULL, 0x002fe200078e00ffULL,
0x0000000175752812ULL, 0x000fc800078efcffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000005c00e17306ULL, 0x000e700000005400ULL, 0x0000005c00847306ULL, 0x0004f0000000d400ULL,
0x000000c300637306ULL, 0x000fe20000209400ULL, 0x000001005e5c7824ULL, 0x004fe200078e00ffULL,
0x000000e1e000720bULL, 0x002fc80003f9d000ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000000c300647306ULL, 0x000e6e0000205400ULL, 0x0000000184844812ULL, 0x008fe200078efcffULL,
0x000000c3008b7306ULL, 0x000ea2000020d400ULL, 0x0000007ccb00720bULL, 0x000fce0003f9d000ULL,
0x0000008500d97306ULL, 0x000fe20000209400ULL, 0x000000646300720bULL, 0x002fca0003f7d000ULL,
0x0000000174744812ULL, 0x000fe400078efcffULL, 0x0000008500da7306ULL, 0x000e6c0000205400ULL,
0x000000018b8b3812ULL, 0x004fe400078efcffULL, 0x0000008500897306ULL, 0x000ea2000020d400ULL,
0x000000959c00720bULL, 0x000fc40003f7d000ULL, 0x000000c0be95723eULL, 0x000fe200000010ffULL,
0x000001002fbe7824ULL, 0x000fe200078e00ffULL, 0x0000008a8b8a723eULL, 0x000fe400000010ffULL,
0x00000088878b723eULL, 0x000fe200000010ffULL, 0x0000004700c37306ULL, 0x000fe20000209400ULL,
0x000000dad900720bULL, 0x002fe40003fdd000ULL, 0x00000018ffbe7819ULL, 0x000fc600000114beULL,
0x0000000176763812ULL, 0x000fe400078efcffULL, 0x0000004700c47306ULL, 0x000e6c0000205400ULL,
0x0000000189896812ULL, 0x004fe400078efcffULL, 0x0000004700857306ULL, 0x0004e2000020d400ULL,
0x000000d7d600720bULL, 0x000fc40003fdd000ULL, 0x000000897676723eULL, 0x000fca00000010ffULL,
0x0000004600cd7306ULL, 0x000fe20000209400ULL, 0x000100005d477824ULL, 0x004fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000004600cc7306ULL, 0x000ea20000205400ULL,
0x0000000186866812ULL, 0x000fe400078efcffULL, 0x000000c4c300720bULL, 0x002fca0003fdd000ULL,
0x0000004600827306ULL, 0x000330000020d400ULL, 0x0000005d00e27306ULL, 0x000fe20000009400ULL,
0x000001005f467824ULL, 0x002fe200078e00ffULL, 0x0000000185856812ULL, 0x008fc400078efcffULL,
0x000000cccd00720bULL, 0x004fe40003fdd000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000005d00e37306ULL, 0x000e620000005400ULL, 0x000000848584723eULL, 0x000fce00000010ffULL,
0x0000005d006f7306ULL, 0x000ea2000000d400ULL, 0x0000000182826812ULL, 0x010fc800078efcffULL,
0x000000827474723eULL, 0x000fc600000010ffULL, 0x0000005c00aa7306ULL, 0x000fe20000209400ULL,
0x000000e3e200720bULL, 0x002fce0003f3d000ULL, 0x0000005c00ab7306ULL, 0x000e6c0000205400ULL,
0x000000016f6f1812ULL, 0x004fe400078efcffULL, 0x0000005c006a7306ULL, 0x000ea2000020d400ULL,
0x000000d0d100720bULL, 0x000fce0003f3d000ULL, 0x0000006800bb7306ULL, 0x000fe20000209400ULL,
0x000000abaa00720bULL, 0x002fca0003fdd000ULL, 0x0000000125251812ULL, 0x000fe400078efcffULL,
0x0000006800bc7306ULL, 0x000e6c0000205400ULL, 0x000000016a6a6812ULL, 0x004fe400078efcffULL,
0x00000068006b7306ULL, 0x000eb0000020d400ULL, 0x0000005e005c7306ULL, 0x000fe20000009400ULL,
0x000000bcbb00720bULL, 0x002fce0003f5d000ULL, 0x0000005e005d7306ULL, 0x000e6c0000005400ULL,
0x000000016b6b2812ULL, 0x004fe400078efcffULL, 0x0000005e00697306ULL, 0x0004e4000000d400ULL,
0x0000006f6b85723eULL, 0x000fcc00000010ffULL, 0x0000004700cf7306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x004fe40000011445ULL, 0x0000005d5c00720bULL, 0x002fe40003fbd000ULL,
0x000000c59d5c723eULL, 0x000fe400000010ffULL, 0x000000c8c75d723eULL, 0x000fe200000010ffULL,
0x0000004700ce7306ULL, 0x000e700000205400ULL, 0x0000004700687306ULL, 0x000ea2000020d400ULL,
0x0000000169695812ULL, 0x008fc400078efcffULL, 0x000000d4e600720bULL, 0x000fca0003fbd000ULL,
0x0000004600a37306ULL, 0x000fe20000209400ULL, 0x000000cecf00720bULL, 0x002fce0003f5d000ULL,
0x0000004600a47306ULL, 0x000e620000205400ULL, 0x0000000122225812ULL, 0x000fca00078efcffULL,
0x0000000168682812ULL, 0x004fe400078efcffULL, 0x0000004600657306ULL, 0x0004f0000020d400ULL,
0x0000005e00d87306ULL, 0x000fe20000209400ULL, 0x000000004444783bULL, 0x004ea20000000200ULL,
0x000000a4a300720bULL, 0x002fcc0003f5d000ULL, 0x0000005e00d57306ULL, 0x000e6e0000205400ULL,
0x0000000165652812ULL, 0x008fe200078efcffULL, 0x0000005e00627306ULL, 0x000730000020d400ULL,
0x0000005f00c97306ULL, 0x000fe20000009400ULL, 0x000001002d5e7824ULL, 0x008fe200078e00ffULL,
0x000000d5d800720bULL, 0x002fc80003f5d000ULL, 0x00000018ff937819ULL, 0x000fe4000001145eULL,
0x0000005f00ca7306ULL, 0x000e620000005400ULL, 0x00000006ec5e7811ULL, 0x000fc800078fe0ffULL,
0x000000075e5e7812ULL, 0x000fe400078e78b1ULL, 0x0000000162622812ULL, 0x010fe200078efcffULL,
0x0000005f00667306ULL, 0x000722000000d400ULL, 0x0000006d44448231ULL, 0x084fe400003400ffULL,
0x0000006d46468231ULL, 0x000fe400003400ffULL, 0x0000006c45458231ULL, 0x080fe400003400ffULL,
0x0000006c47478231ULL, 0x000fe200003400ffULL, 0x0000008e00d37306ULL, 0x000fe20000209400ULL,
0x000001002c5f7824ULL, 0x008fe200078e00ffULL, 0x000000cac900720bULL, 0x002fc80003f7d000ULL,
0x000000344440723cULL, 0x040fe20000041840ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000008e00d27306ULL, 0x000e6a0000205400ULL, 0x0000006e9134723eULL, 0x000fe200000010ffULL,
0x000000944450723cULL, 0x000fe20000041850ULL, 0x000000b29035723eULL, 0x000fe200000010ffULL,
0x0000008e00677306ULL, 0x000ea2000020d400ULL, 0x0000000166663812ULL, 0x010fc400078efcffULL,
0x000000e7e800720bULL, 0x000fe40003f7d000ULL, 0x000100002f947824ULL, 0x000fe200078e00ffULL,
0x000000344438723cULL, 0x000fe40000041838ULL, 0x0000005f008e7306ULL, 0x000fe20000209400ULL,
0x000000d2d300720bULL, 0x002fe40003fdd000ULL, 0x00000018ff947819ULL, 0x000fe40000011494ULL,
0x00000004ec347811ULL, 0x000fc400078fe0ffULL, 0x000000378335723eULL, 0x000fe200000010ffULL,
0x0000005f008f7306ULL, 0x000e620000205400ULL, 0x0000000734347812ULL, 0x000fe200078e78b1ULL,
0x000100002c837824ULL, 0x000fe200078e00ffULL, 0x0000000113133812ULL, 0x000fe400078efcffULL,
0x000000f5f600720bULL, 0x000fe20003f7d000ULL, 0x00000008b1b27824ULL, 0x040fe200078e0234ULL,
0x000000369234723eULL, 0x000fe200000010ffULL, 0x0000005f00647306ULL, 0x000722000020d400ULL,
0x00000008b1b17824ULL, 0x000fe200078e025eULL, 0x000000bf8192723eULL, 0x000fe200000010ffULL,
0x000001002ebf7824ULL, 0x000fe200078e00ffULL, 0x000000b47e81723eULL, 0x000fc400000010ffULL,
0x00012000b1367811ULL, 0x000fe200078e20ffULL, 0x000000344458723cULL, 0x040fe20000041858ULL,
0x00000093009c7306ULL, 0x000fe20000209400ULL, 0x00000018ffc07819ULL, 0x000fe40000011483ULL,
0x0000000167676812ULL, 0x004fe200078efcffULL, 0x000000003634783bULL, 0x000ea20000000200ULL,
0x0000008f8e00720bULL, 0x002fe40003fdd000ULL, 0x0000005c445c723cULL, 0x008fe20000041854ULL,
0x00000093009d7306ULL, 0x000e620000205400ULL, 0x00000018ffbf7819ULL, 0x000fc400000114bfULL,
0x0000000173733812ULL, 0x000fe400078efcffULL, 0x000000e9f000720bULL, 0x000fe40003f7d000ULL,
0x00012000b2547811ULL, 0x000fe200078e20ffULL, 0x00000093006e7306ULL, 0x0006a4000020d400ULL,
0x0000000164646812ULL, 0x010fc600078efcffULL, 0x000000005454783bULL, 0x000f260000000200ULL,
0x0000002c00b77306ULL, 0x000fe20000009400ULL, 0x000000bd8093723eULL, 0x008fe200000010ffULL,
0x000100002d807824ULL, 0x000fe200078e00ffULL, 0x0000009d9c00720bULL, 0x002fe20003f5d000ULL,
0x000100002ebd7824ULL, 0x000fe200078e00ffULL, 0x0000000123233812ULL, 0x000fc600078efcffULL,
0x0000002c00b87306ULL, 0x000e620000005400ULL, 0x00000092443c723cULL, 0x000fe2000004183cULL,
0x00000018ffbd7819ULL, 0x000fcc00000114bdULL, 0x0000002c00637306ULL, 0x000fe2000000d400ULL,
0x00000018ff927819ULL, 0x000fe40000011480ULL, 0x000000b67f80723eULL, 0x000fe200000010ffULL,
0x0000006d34348231ULL, 0x084fe200003400ffULL, 0x000000016e6e2812ULL, 0x000fe200078efcffULL,
0x0000006d36368231ULL, 0x000fe400003400ffULL, 0x0000002e009f7306ULL, 0x000fe20000009400ULL,
0x0000006c35358231ULL, 0x080fe200003400ffULL, 0x000000804448723cULL, 0x000fe20000041848ULL,
0x0000006c37378231ULL, 0x000fca00003400ffULL, 0x0000002e00a07306ULL, 0x000ea20000005400ULL,
0x0000006d54548231ULL, 0x090fe400003400ffULL, 0x0000006d56568231ULL, 0x000fca00003400ffULL,
0x0000002e00607306ULL, 0x000722000000d400ULL, 0x0000006c55558231ULL, 0x080fe400003400ffULL,
0x0000006c57578231ULL, 0x000fe200003400ffULL, 0x000000b8b700720bULL, 0x002fc80003f1d000ULL,
0x0000002f00907306ULL, 0x000fe20000009400ULL, 0x000000bab92e723eULL, 0x008fe400000010ffULL,
0x000000a09f00720bULL, 0x004fca0003f3d000ULL, 0x0000002f00917306ULL, 0x000e620000005400ULL,
0x0000000163630812ULL, 0x000fe400078efcffULL, 0x000000f3f400720bULL, 0x000fe40003f1d000ULL,
0x000000636464723eULL, 0x000fc600000010ffULL, 0x0000002f002c7306ULL, 0x0005e2000000d400ULL,
0x0000000160601812ULL, 0x010fce00078efcffULL, 0x000000c000837306ULL, 0x000fe20000209400ULL,
0x000000b5b32f723eULL, 0x004fe400000010ffULL, 0x0000000124240812ULL, 0x000fe400078efcffULL,
0x000000919000720bULL, 0x002fc60003fbd000ULL, 0x000000c000957306ULL, 0x000e620000205400ULL,
0x0000002e444c723cULL, 0x000fee000004184cULL, 0x000000ac7d44723eULL, 0x000fe200000010ffULL,
0x0000002d00a57306ULL, 0x000fe20000009400ULL, 0x000000a97b45723eULL, 0x000fc400000010ffULL,
0x000000adaf2e723eULL, 0x000fe400000010ffULL, 0x000000aeb02f723eULL, 0x000fe400000010ffULL,
0x000000958300720bULL, 0x002fe20003fdd000ULL, 0x0000002d00a67306ULL, 0x000e620000005400ULL,
0x000000445438723cULL, 0x000fe20000041838ULL, 0x0000009b797b723eULL, 0x000fe400000010ffULL,
0x0000008c7779723eULL, 0x000fe400000010ffULL, 0x000000968d9b723eULL, 0x000fc400000010ffULL,
0x0000002d00617306ULL, 0x000fe2000000d400ULL, 0x0000002e5440723cULL, 0x040fe20000041840ULL,
0x000000867577723eULL, 0x000fe400000010ffULL, 0x000000682575723eULL, 0x000fe400000010ffULL,
0x000000621345723eULL, 0x000fe400000010ffULL, 0x000000c0002d7306ULL, 0x000ea2000020d400ULL,
0x000000a7a82e723eULL, 0x000fe200000010ffULL, 0x0000007a5458723cULL, 0x000fe20000041858ULL,
0x000000a19e2f723eULL, 0x000fc400000010ffULL, 0x000000a6a500720bULL, 0x002fe40003f9d000ULL,
0x000000012c2c5812ULL, 0x000fe200078efcffULL, 0x00000092007f7306ULL, 0x000fe40000209400ULL,
0x0000002e545c723cULL, 0x040fec000004185cULL, 0x00000092007e7306ULL, 0x000e620000205400ULL,
0x000000012d2d6812ULL, 0x004fe200078efcffULL, 0x0000009a5450723cULL, 0x000fe20000041850ULL,
0x0000000161614812ULL, 0x000fc400078efcffULL, 0x000000f1f200720bULL, 0x000fc60003f9d000ULL,
0x000000bf00477306ULL, 0x000fe40000209400ULL, 0x00000078543c723cULL, 0x040fec000004183cULL,
0x000000bf00447306ULL, 0x000ea20000205400ULL, 0x0000007e7f00720bULL, 0x002fe20003f5d000ULL,
0x0000008a544c723cULL, 0x000fe2000004184cULL, 0x0000000172724812ULL, 0x000fca00078efcffULL,
0x0000009200467306ULL, 0x000e64000020d400ULL, 0x000000765448723cULL, 0x000fec0000041848ULL,
0x000000bf002f7306ULL, 0x000ee2000020d400ULL, 0x000000666555723eULL, 0x000fe200000010ffULL,
0x000000843440723cULL, 0x000fe20000041840ULL, 0x000000444700720bULL, 0x004fc40003fdd000ULL,
0x000000672244723eULL, 0x000fe400000010ffULL, 0x000000616e65723eULL, 0x000fe200000010ffULL,
0x000000be006c7306ULL, 0x000fe20000209400ULL, 0x0000000146462812ULL, 0x002fe200078efcffULL,
0x000000743438723cULL, 0x000fe20000041838ULL, 0x000000696a54723eULL, 0x000fca00000010ffULL,
0x000000be006d7306ULL, 0x000e620000205400ULL, 0x000000012f2f6812ULL, 0x008fe200078efcffULL,
0x000000443458723cULL, 0x000fe60000041858ULL, 0x000000602f60723eULL, 0x000fc600000010ffULL,
0x000000bd002e7306ULL, 0x000fe20000209400ULL, 0x0000002d7344723eULL, 0x000fe200000010ffULL,
0x000000543454723cULL, 0x000fe2000004185cULL, 0x000000462445723eULL, 0x000fca00000010ffULL,
0x000000bd006b7306ULL, 0x000ea20000205400ULL, 0x0000006d6c00720bULL, 0x002fe20003f5d000ULL,
0x000000643450723cULL, 0x040fec0000041850ULL, 0x0000009400257306ULL, 0x000fe40000209400ULL,
0x00000044343c723cULL, 0x000fec000004183cULL, 0x0000009400667306ULL, 0x000e620000205400ULL,
0x0000006b2e00720bULL, 0x004fce0003f1d000ULL, 0x000000be00797306ULL, 0x000eb0000020d400ULL,
0x000000bd00bd7306ULL, 0x000ee2000020d400ULL, 0x000000662500720bULL, 0x002fce0003fdd000ULL,
0x0000009400947306ULL, 0x000e62000020d400ULL, 0x0000000179792812ULL, 0x004fc800078efcffULL,
0x0000002c7961723eULL, 0x000fe400000010ffULL, 0x00000001bdbd0812ULL, 0x008fc800078efcffULL,
0x000000bd7222723eULL, 0x000fe200000010ffULL, 0x00000060344c723cULL, 0x000fe2000004184cULL,
0x0000000194946812ULL, 0x002fc800078efcffULL, 0x000000942323723eULL, 0x000fce00000010ffULL,
0x000000223448723cULL, 0x000fe20000041848ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff0cff7812ULL, 0x000fe2000782c0ffULL,
0x01c61000ffff7f8cULL, 0x000fe2000c80043fULL, 0x0000004005137811ULL, 0x000fe400078e40ffULL,
0x00000001ff5e7807ULL, 0x000fe40000800000ULL, 0x000000130400720cULL, 0x000fe40003f24070ULL,
0x000000ff02ff7812ULL, 0x000fc4000784c0ffULL, 0x000000010e00780cULL, 0x000fe40003f05270ULL,
0x00000001ff227807ULL, 0x000fe40001000000ULL, 0x0000000c5e0c7207ULL, 0x000fe40004000000ULL,
0x0000000100007812ULL, 0x000fe400078e0cffULL, 0x0000761022027816ULL, 0x000fe20000000002ULL,
0x0000e05000009947ULL, 0x000fea0003800000ULL, 0x01c65c00ff137984ULL, 0x000e620000000800ULL,
0x8000000022007824ULL, 0x000fca00078e00ffULL, 0x8000000013ff7812ULL, 0x002fe20007824800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007824800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000022137824ULL, 0x000fe400078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007824813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000580009007a24ULL, 0x020fe200078e02ffULL, 0x0000008005137811ULL, 0x000fe200078e40ffULL,
0x00000100ff5f7424ULL, 0x000fe200078e00ffULL, 0x0000000000237919ULL, 0x000ea20000002600ULL,
0x000040000ee57824ULL, 0x000fc600078e00ffULL, 0x0000000000617919ULL, 0x000ee20000000000ULL,
0x00000004ff0c7819ULL, 0x002fe20000011602ULL, 0x0000001003027824ULL, 0x000fe400078e00ffULL,
0x0000008023237824ULL, 0x004fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e020cULL,
0x0000008000237824ULL, 0x000fe200078e0223ULL, 0x0000000105007810ULL, 0x000fe20007ffe0ffULL,
0x0000001061607824ULL, 0x008fe200078e00ffULL, 0x00000004ff657819ULL, 0x000fe20000011661ULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x0000007f23247812ULL, 0x000fc400078ef802ULL,
0x000000f060607812ULL, 0x000fe400078ec0ffULL, 0x000000070000720cULL, 0x000fe20003f26070ULL,
0x00005e0024247625ULL, 0x000fe200078e005fULL, 0x0000001304007217ULL, 0x000fe40007800000ULL,
0x0000007f232c7812ULL, 0x040fe400078ef80fULL, 0x0000006024367210ULL, 0x000fe20007f5e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a13ULL, 0x0000007f23027812ULL, 0x040fe200078ef810ULL,
0x00005e002c2c7625ULL, 0x000fe200078e005fULL, 0x0000007f232e7812ULL, 0x000fc400078ef811ULL,
0x0000004000007807ULL, 0x000fe20000800000ULL, 0x000000ffff377224ULL, 0x000fe200010e0625ULL,
0x000000602c447210ULL, 0x080fe20007f5e0ffULL, 0x00005e0002247625ULL, 0x080fe200078e005fULL,
0x0000007f23347812ULL, 0x040fe400078ef812ULL, 0x0000007f23027812ULL, 0x040fe200078ef814ULL,
0x00005e002e2e7625ULL, 0x080fe200078e005fULL, 0x0000006024467210ULL, 0x000fe40007f7e0ffULL,
0x000000000c007217ULL, 0x000fe20007800000ULL, 0x000000ffff457224ULL, 0x000fe200010e062dULL,
0x000000602e5c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0034347625ULL, 0x000fe200078e005fULL,
0x0000007f232c7812ULL, 0x000fc400078ef815ULL, 0x0000007f232e7812ULL, 0x000fe200078ef816ULL,
0x000000ffff477224ULL, 0x000fe200018e0625ULL, 0x0000000265137810ULL, 0x040fe20007ffe0ffULL,
0x00005e0002247625ULL, 0x080fe200078e005fULL, 0x0000006034347210ULL, 0x080fe40007f7e0ffULL,
0x0000000865617810ULL, 0x040fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a0cULL,
0x0000000a65637810ULL, 0x040fe20007ffe0ffULL, 0x000000080e237824ULL, 0x000fe200078e00ffULL,
0x0000000c65677810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5d7224ULL, 0x000fe200010e062fULL,
0x0000006024247210ULL, 0x000fe20007f5e0ffULL, 0x00005e002c2c7625ULL, 0x000fe200078e005fULL,
0x000000001300720cULL, 0x000fc40003fa6070ULL, 0x00004000e5137812ULL, 0x000fe200078ec0ffULL,
0x00005e002e2e7625ULL, 0x000fe200078e005fULL, 0x00000004655f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000823027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff357224ULL, 0x000fe200018e0635ULL,
0x000000006500720cULL, 0x000fe20003f86070ULL, 0x000000ffff257224ULL, 0x000fe200010e0625ULL,
0x000000602c2c7210ULL, 0x000fe20007f3e0ffULL, 0x00000000020573c2ULL, 0x000e6200000e0000ULL,
0x000000005f00720cULL, 0x000fc40003f66070ULL, 0x000000602e2e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062dULL, 0x00000006655f7810ULL, 0x000fe40007ffe0ffULL,
0x0001400013137810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e062fULL,
0x000000005f00720cULL, 0x080fe40003f26070ULL, 0x000000006100720cULL, 0x000fe20003f46070ULL,
0x00000010175f7824ULL, 0x100fe400078e0213ULL, 0x0000001018617824ULL, 0x000fc600078e0213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000365f7faeULL, 0x0005e2000e101c46ULL,
0x000000006300720cULL, 0x080fe20003f86070ULL, 0x000000101a637824ULL, 0x100fe400078e0213ULL,
0x0000000044617faeULL, 0x0007e2000e901c46ULL, 0x000000006700720cULL, 0x080fe40003fa6070ULL,
0x0000000e65677810ULL, 0x000fe20007ffe0ffULL, 0x0000000046637faeULL, 0x0009e2000d901c46ULL,
0x000000101b657824ULL, 0x100fe200078e0213ULL, 0x0001c64805057890ULL, 0x002fe2000fffe03fULL,
0x000000006700720cULL, 0x000fe20003f66070ULL, 0x000000101c677824ULL, 0x100fe200078e0213ULL,
0x0001c64819007811ULL, 0x000fe200078e18ffULL, 0x000000101d377824ULL, 0x104fe200078e0213ULL,
0x000000005c657faeULL, 0x0009e2000c901c46ULL, 0x000000101e457824ULL, 0x008fc400078e0213ULL,
0x000000101f5f7824ULL, 0x000fe200078e0213ULL, 0x0000000034677faeULL, 0x0009e8000d101c46ULL,
0x0000000024377faeULL, 0x0009e8000e101c46ULL, 0x000000002c457faeULL, 0x0009e8000e901c46ULL,
0x000000002e5f7faeULL, 0x0009e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040000257984ULL, 0x0102a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c61c00ff027984ULL, 0x000ee20000000800ULL, 0x000000275e277207ULL, 0x000fe20004000000ULL,
0x80000000202d7824ULL, 0x000fc600078e00ffULL, 0x0000ffff27007812ULL, 0x002fc800078ec0ffULL,
0x0000888000247816ULL, 0x000fca00000000ffULL, 0x8000000024007824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x004fe40007804800ULL, 0x8000000002ff7812ULL, 0x008fe2000782482dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000020257824ULL, 0x000fe400078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x01c61c00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x01c0800021257984ULL, 0x000e620000000800ULL,
0x00000001ff837424ULL, 0x000fc600078e00ffULL, 0x01c2800021007984ULL, 0x0004e20000000800ULL,
0x0000000a2500720bULL, 0x002fda0003f3d000ULL, 0x0000000000027806ULL, 0x000fc800008e0100ULL,
0x0000ffff020c7812ULL, 0x000fda000782c0ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x0000000a2500720bULL, 0x00cfe20003f34000ULL, 0x00000000002e7919ULL, 0x000e620000000000ULL,
0x000000250a2c7209ULL, 0x000fca0007810000ULL, 0x8000002c0a027221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b020a7820ULL, 0x000fe40000410000ULL, 0x0000000000027806ULL, 0x000fe400008e0100ULL,
0x000000010300780cULL, 0x000fe40003f25270ULL, 0x0000ffff022d7812ULL, 0x000fe200078e3cffULL,
0x0000000a000a7308ULL, 0x000ea60000000800ULL, 0x0000002d0cff7212ULL, 0x000fc4000784c0ffULL,
0x00000002ff2f7819ULL, 0x102fe4000001162eULL, 0x00000002ff2e7819ULL, 0x000fc6000001162eULL,
0x01c4802c21009388ULL, 0x000fe20000000800ULL, 0x00000001ff837807ULL, 0x000fe40001000000ULL,
0x000000082e2e7810ULL, 0x000fe20007ffe0ffULL, 0x00001f2f0a027589ULL, 0x004e6400000e0000ULL,
0x8000002c25252221ULL, 0x000fe40000010000ULL, 0x0000000a0b0b7220ULL, 0x000fe20000410000ULL,
0x00001f2e0a0c7589ULL, 0x0004e200000e0000ULL, 0x3fb8aa3b25252820ULL, 0x000fc80000410000ULL,
0x00000025000d2308ULL, 0x000f220000000800ULL, 0x000000ffff0a7224ULL, 0x004fe400078e002cULL,
0x0000000240407220ULL, 0x082fe40000410000ULL, 0x0000000241417220ULL, 0x080fe40000410000ULL,
0x0000000238387220ULL, 0x080fe40000410000ULL, 0x0000000239397220ULL, 0x080fe40000410000ULL,
0x0000000254547220ULL, 0x000fc40000410000ULL, 0x0000000255557220ULL, 0x080fe40000410000ULL,
0x0000000258587220ULL, 0x080fe40000410000ULL, 0x0000000259597220ULL, 0x080fe40000410000ULL,
0x0000000250507220ULL, 0x080fe40000410000ULL, 0x0000000251517220ULL, 0x080fe40000410000ULL,
0x000000023c3c7220ULL, 0x000fc40000410000ULL, 0x000000023d3d7220ULL, 0x080fe40000410000ULL,
0x000000024c4c7220ULL, 0x080fe40000410000ULL, 0x000000024d4d7220ULL, 0x080fe40000410000ULL,
0x0000000248487220ULL, 0x080fe40000410000ULL, 0x0000000249497220ULL, 0x000fe40000410000ULL,
0x0000000c42427220ULL, 0x008fc40000410000ULL, 0x0000000c43437220ULL, 0x080fe40000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000c56567220ULL, 0x080fe40000410000ULL, 0x0000000c57577220ULL, 0x080fe40000410000ULL,
0x0000000c5a5a7220ULL, 0x000fc40000410000ULL, 0x0000000c5b5b7220ULL, 0x080fe40000410000ULL,
0x0000000c52527220ULL, 0x080fe40000410000ULL, 0x0000000c53537220ULL, 0x080fe40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000c4e4e7220ULL, 0x000fc40000410000ULL, 0x0000000c4f4f7220ULL, 0x080fe40000410000ULL,
0x0000000c4a4a7220ULL, 0x080fe40000410000ULL, 0x0000000c4b4b7220ULL, 0x000fe40000410000ULL,
0x000000000d002220ULL, 0x010fc80000410000ULL, 0x0000000b000b7221ULL, 0x00cfe20000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x0001c648190c7811ULL, 0x000fe200078e18ffULL,
0x8000000024257824ULL, 0x000fc800078e00ffULL, 0x000004000c007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000024257824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x000004000c027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000010e257812ULL, 0x000fe200078e0cffULL, 0x0000000000e47919ULL, 0x000e620000000000ULL,
0x0000991083837816ULL, 0x000fe400000000ffULL, 0x0001400025257811ULL, 0x000fca00078e70ffULL,
0x0000001029e77824ULL, 0x100fe400078e0225ULL, 0x000000102ae97824ULL, 0x100fe400078e0225ULL,
0x000000102bec7824ULL, 0x100fe200078e0225ULL, 0x00000000e76c783bULL, 0x000ea20000004200ULL,
0x0000001030ee7824ULL, 0x100fe400078e0225ULL, 0x0000001031f07824ULL, 0x100fe200078e0225ULL,
0x00000000e92c783bULL, 0x000fe20000004200ULL, 0x0000001033f17824ULL, 0x000fc400078e0225ULL,
0x0000001070f27824ULL, 0x100fe200078e0225ULL, 0x00000000ec5c783bULL, 0x000fe20000004200ULL,
0x0000001071607824ULL, 0x000fc600078e0225ULL, 0x00000000ee68783bULL, 0x000fe80000004200ULL,
0x00000000f064783bULL, 0x000fe80000004200ULL, 0x00000000f134783bULL, 0x000fe80000004200ULL,
0x00000000f244783bULL, 0x000ee80000004200ULL, 0x0000006001007387ULL, 0x000fe80000100800ULL,
0x000000006060783bULL, 0x000f220000004200ULL, 0x00000018ff0c7819ULL, 0x004fe2000001146eULL,
0x0000006c00bd7306ULL, 0x000fe20000009400ULL, 0x00000018ff247819ULL, 0x000fc4000001146fULL,
0x00000018ff027819ULL, 0x000fe4000001146dULL, 0x00000018ff007819ULL, 0x000fc6000001146cULL,
0x0000000c00b67306ULL, 0x000ff00000209400ULL, 0x0000000c00df7306ULL, 0x000ea20000205400ULL,
0x00000018ffbb7819ULL, 0x008fce0000011447ULL, 0x0000000c008c7306ULL, 0x000762000020d400ULL,
0x00000018ff727819ULL, 0x000fe40000011445ULL, 0x00000018ffbc7819ULL, 0x010fca0000011461ULL,
0x0000002400c97306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x008fe4000001142eULL,
0x00000018ffbe7819ULL, 0x000fe40000011462ULL, 0x00000018ffc67819ULL, 0x000fe40000011463ULL,
0x000000dfb600720bULL, 0x004fe20003fdd000ULL, 0x0000002400c47306ULL, 0x000ff00000205400ULL,
0x00000024008d7306ULL, 0x0005e8000020d400ULL, 0x000000018c8c6812ULL, 0x020fc800078efcffULL,
0x0000000c00b47306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x004fce000001142fULL,
0x0000000c00b77306ULL, 0x000ff00000205400ULL, 0x0000000c00b57306ULL, 0x0005f0000020d400ULL,
0x0000002400bf7306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x004fce000001145eULL,
0x0000002400c07306ULL, 0x000ff00000205400ULL, 0x0000002400957306ULL, 0x0005f0000020d400ULL,
0x0000000c00a27306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x004fce000001145fULL,
0x0000000c00a07306ULL, 0x000ff00000205400ULL, 0x0000000c008a7306ULL, 0x0005f0000020d400ULL,
0x00000024009c7306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x004fce000001146aULL,
0x00000024009d7306ULL, 0x000ff00000205400ULL, 0x0000002400897306ULL, 0x0005f0000020d400ULL,
0x0000000c00917306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x004fce000001146bULL,
0x0000000c00987306ULL, 0x000ff00000205400ULL, 0x0000000c00857306ULL, 0x0005f0000020d400ULL,
0x0000002400907306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x004fce0000011466ULL,
0x00000024008f7306ULL, 0x000ff00000205400ULL, 0x0000002400847306ULL, 0x0005f0000020d400ULL,
0x0000000c00a87306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x004fce0000011467ULL,
0x0000000c00a97306ULL, 0x000ff00000205400ULL, 0x0000000c007e7306ULL, 0x0005f0000020d400ULL,
0x0000002400a37306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x004fce0000011436ULL,
0x0000002400a47306ULL, 0x000ff00000205400ULL, 0x00000024007b7306ULL, 0x000ff0000020d400ULL,
0x0000000c00a17306ULL, 0x000ff00000209400ULL, 0x0000000c00a57306ULL, 0x000ff00000205400ULL,
0x0000000c00777306ULL, 0x0005f0000020d400ULL, 0x000000bb00d37306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x004fce0000011446ULL, 0x000000bb00d27306ULL, 0x000ff00000205400ULL,
0x000000bb00247306ULL, 0x0005f0000020d400ULL, 0x0000000c00cf7306ULL, 0x000fe20000209400ULL,
0x000001006cbb7824ULL, 0x004fca00078e00ffULL, 0x00000018ffc57819ULL, 0x000fe400000114bbULL,
0x0000000c00797306ULL, 0x000ff00000205400ULL, 0x0000000c00737306ULL, 0x000ff0000020d400ULL,
0x0000000200c87306ULL, 0x000ff00000209400ULL, 0x0000000200e17306ULL, 0x000eb00000205400ULL,
0x0000000200b97306ULL, 0x000730000020d400ULL, 0x000000bc00db7306ULL, 0x000fe20000209400ULL,
0x00000018ff027819ULL, 0x008fc4000001142dULL, 0x000000e1c800720bULL, 0x004fca0003f1d000ULL,
0x000000bc00d87306ULL, 0x000ff00000205400ULL, 0x000000bc000c7306ULL, 0x0005e2000020d400ULL,
0x00000001b9b90812ULL, 0x010fce00078efcffULL, 0x0000000000cd7306ULL, 0x000fe20000209400ULL,
0x000100006cbc7824ULL, 0x004fca00078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114bcULL,
0x000001006dbc7824ULL, 0x000fe200078e00ffULL, 0x0000000000b87306ULL, 0x000ea80000205400ULL,
0x00000018ffde7819ULL, 0x000fc800000114bcULL, 0x0000000000ba7306ULL, 0x000730000020d400ULL,
0x000000c500da7306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x008fe4000001142cULL,
0x000000b8cd00720bULL, 0x004fca0003f7d000ULL, 0x000000c500e37306ULL, 0x000eb00000205400ULL,
0x0000000200867306ULL, 0x000fe20000209400ULL, 0x00000001baba3812ULL, 0x010fce00078efcffULL,
0x0000000200c77306ULL, 0x000fe20000205400ULL, 0x000000e3da00720bULL, 0x004fce0003fbd000ULL,
0x0000000200c27306ULL, 0x0005f0000020d400ULL, 0x0000006c00ce7306ULL, 0x000ee20000005400ULL,
0x00000018ff027819ULL, 0x004fce000001145dULL, 0x0000006c00ca7306ULL, 0x000eb0000000d400ULL,
0x0000006d00d17306ULL, 0x000fe20000009400ULL, 0x000000cebd00720bULL, 0x008fe20003f9d000ULL,
0x000100006dce7824ULL, 0x000fca00078e00ffULL, 0x00000018ffe07819ULL, 0x000fe200000114ceULL,
0x0000006d006c7306ULL, 0x000eec0000005400ULL, 0x00000001caca4812ULL, 0x004fe400078efcffULL,
0x00000072007c7306ULL, 0x000ff00000209400ULL, 0x00000072007d7306ULL, 0x000fe20000205400ULL,
0x0000006cd100720bULL, 0x008fe20003f3d000ULL, 0x000001006e6c7824ULL, 0x000fca00078e00ffULL,
0x00000018ffe27819ULL, 0x000fe2000001146cULL, 0x0000007200747306ULL, 0x000fe2000020d400ULL,
0x000001006f6c7824ULL, 0x000fce00078e00ffULL, 0x0000000000b07306ULL, 0x000ff00000209400ULL,
0x0000000000c17306ULL, 0x000ff00000205400ULL, 0x0000000000c37306ULL, 0x0005f0000020d400ULL,
0x000000be00d77306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x004fce000001145cULL,
0x000000be00d67306ULL, 0x000ff00000205400ULL, 0x000000be00727306ULL, 0x000ff0000020d400ULL,
0x0000000200ac7306ULL, 0x000ff00000209400ULL, 0x0000000200ab7306ULL, 0x000ff00000205400ULL,
0x0000000200937306ULL, 0x0005f0000020d400ULL, 0x000000d000be7306ULL, 0x000fe20000209400ULL,
0x00000018ff027819ULL, 0x004fce0000011469ULL, 0x000000d000cb7306ULL, 0x000eb00000205400ULL,
0x0000000000ad7306ULL, 0x000ff00000209400ULL, 0x0000000000b37306ULL, 0x000fe20000205400ULL,
0x000000cbbe00720bULL, 0x004fce0003f5d000ULL, 0x0000000000947306ULL, 0x0005f0000020d400ULL,
0x0000000200997306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x004fce0000011468ULL,
0x0000000200967306ULL, 0x000ff00000205400ULL, 0x0000000200877306ULL, 0x0005f0000020d400ULL,
0x000000c500bb7306ULL, 0x000ee2000020d400ULL, 0x00000018ff027819ULL, 0x004fce0000011465ULL,
0x0000006e00c87306ULL, 0x000ff00000009400ULL, 0x0000006e00e17306ULL, 0x000ea20000005400ULL,
0x00000001bbbb5812ULL, 0x008fce00078efcffULL, 0x00000000009a7306ULL, 0x000ff00000209400ULL,
0x00000000009b7306ULL, 0x000fe20000205400ULL, 0x000000e1c800720bULL, 0x004fe20003fbd000ULL,
0x000100006ec87824ULL, 0x000fcc00078e00ffULL, 0x0000000000887306ULL, 0x0005f0000020d400ULL,
0x0000000200aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x004fce0000011464ULL,
0x00000002008e7306ULL, 0x000ff00000205400ULL, 0x00000002007f7306ULL, 0x0005f0000020d400ULL,
0x0000000000ae7306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x004fce0000011435ULL,
0x0000000000af7306ULL, 0x000ff00000205400ULL, 0x0000000000827306ULL, 0x0005f0000020d400ULL,
0x00000002009e7306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x004fce0000011434ULL,
0x00000002009f7306ULL, 0x000ff00000205400ULL, 0x0000000200787306ULL, 0x0005f0000020d400ULL,
0x0000006f00da7306ULL, 0x000fe20000009400ULL, 0x00000018ff027819ULL, 0x004fce0000011444ULL,
0x0000006f00cb7306ULL, 0x000eb00000005400ULL, 0x0000000000a77306ULL, 0x000ff00000209400ULL,
0x0000000000a67306ULL, 0x000fe20000205400ULL, 0x000000cbda00720bULL, 0x004fe20003f9d000ULL,
0x000100006fda7824ULL, 0x000fca00078e00ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x00000000007a7306ULL, 0x0005f0000020d400ULL, 0x0000000200807306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x004fce0000011437ULL, 0x0000000200817306ULL, 0x000ff00000205400ULL,
0x0000000200757306ULL, 0x0005f0000020d400ULL, 0x000000de00bc7306ULL, 0x000fe20000209400ULL,
0x00000018ff027819ULL, 0x004fce0000011460ULL, 0x000000de00bd7306ULL, 0x000ff00000205400ULL,
0x000000de00c57306ULL, 0x0005f0000020d400ULL, 0x00000000008b7306ULL, 0x000fe20000209400ULL,
0x00000018ffde7819ULL, 0x004fce000001146cULL, 0x0000000000927306ULL, 0x000ff00000205400ULL,
0x0000000000767306ULL, 0x000ff0000020d400ULL, 0x0000000200dd7306ULL, 0x000ff00000209400ULL,
0x0000000200dc7306ULL, 0x000ff00000205400ULL, 0x0000000200007306ULL, 0x000ff0000020d400ULL,
0x000000c600d57306ULL, 0x000ff00000209400ULL, 0x000000c600d47306ULL, 0x000ff00000205400ULL,
0x000000c600027306ULL, 0x000ff0000020d400ULL, 0x000000d000cc7306ULL, 0x000eb0000020d400ULL,
0x0000006d00c67306ULL, 0x000ef0000000d400ULL, 0x000000e000d07306ULL, 0x000fe20000209400ULL,
0x00000001cccc2812ULL, 0x004fc400078efcffULL, 0x000000bdbc00720bULL, 0x000fe20003f5d000ULL,
0x000001002cbc7824ULL, 0x000fc800078e00ffULL, 0x000000e000d97306ULL, 0x000ea20000205400ULL,
0x00000001c6c61812ULL, 0x008fe400078efcffULL, 0x000000c4c900720bULL, 0x000fca0003f3d000ULL,
0x000000e000cd7306ULL, 0x000722000020d400ULL, 0x00000001c5c52812ULL, 0x000fce00078efcffULL,
0x000000de006c7306ULL, 0x000fe20000209400ULL, 0x00000018ffe07819ULL, 0x008fe400000114c8ULL,
0x000000d9d000720bULL, 0x004fe40003f7d000ULL, 0x000000018d8d1812ULL, 0x000fc600078efcffULL,
0x000000de006d7306ULL, 0x000eb00000205400ULL, 0x0000006e00be7306ULL, 0x000ee2000000d400ULL,
0x00000001cdcd3812ULL, 0x010fe400078efcffULL, 0x000000c1b000720bULL, 0x000fca0003f7d000ULL,
0x000000e000c87306ULL, 0x000fe20000209400ULL, 0x0000006d6c00720bULL, 0x004fce0003f1d000ULL,
0x000000e000cb7306ULL, 0x000ea20000205400ULL, 0x00000001bebe5812ULL, 0x008fe400078efcffULL,
0x00000001c3c33812ULL, 0x000fca00078efcffULL, 0x000000de00b67306ULL, 0x000ef0000020d400ULL,
0x0000006f00df7306ULL, 0x000f22000000d400ULL, 0x000000cbc800720bULL, 0x004fce0003fbd000ULL,
0x000000da006e7306ULL, 0x000fe20000209400ULL, 0x00000001b6b60812ULL, 0x008fce00078efcffULL,
0x000000da006f7306ULL, 0x000ea20000205400ULL, 0x00000001dfdf4812ULL, 0x010fce00078efcffULL,
0x000000e000de7306ULL, 0x000ef0000020d400ULL, 0x0000002c006c7306ULL, 0x000fe20000009400ULL,
0x0000006f6e00720bULL, 0x004fce0003f1d000ULL, 0x0000002c006d7306ULL, 0x000ea20000005400ULL,
0x00000001dede5812ULL, 0x008fc800078efcffULL, 0x000000de8c8c723eULL, 0x000fc600000010ffULL,
0x000000e200ce7306ULL, 0x000ff00000209400ULL, 0x000000e200d17306ULL, 0x000ee20000205400ULL,
0x0000006d6c00720bULL, 0x004fe20003fbd000ULL, 0x000100002c6c7824ULL, 0x000fca00078e00ffULL,
0x00000018ffb07819ULL, 0x000fe2000001146cULL, 0x0000002d006e7306ULL, 0x000fe20000009400ULL,
0x00012800326c7811ULL, 0x000fce00078e20ffULL, 0x0000002d006f7306ULL, 0x000ea20000005400ULL,
0x000000d1ce00720bULL, 0x008fce0003f5d000ULL, 0x000000e200b87306ULL, 0x000722000020d400ULL,
0x0000006f6e00720bULL, 0x004fce0003fdd000ULL, 0x000000da00bd7306ULL, 0x000562000020d400ULL,
0x00000018ffe27819ULL, 0x008fe200000114bcULL, 0x000001002dbc7824ULL, 0x040fe200078e00ffULL,
0x000000006c6c783bULL, 0x000fe80000000200ULL, 0x00000018ffd17819ULL, 0x000fe200000114bcULL,
0x000000e200e17306ULL, 0x000fe20000209400ULL, 0x00000001b8b82812ULL, 0x010fe200078efcffULL,
0x000100002dda7824ULL, 0x004fe200078e00ffULL, 0x000000c78600720bULL, 0x000fc40003f5d000ULL,
0x00000002ff867819ULL, 0x102fe400000116e4ULL, 0x00000002ffe47819ULL, 0x000fe200000116e4ULL,
0x000000e200d07306ULL, 0x000e620000205400ULL, 0x00000001bdbd0812ULL, 0x020fe400078efcffULL,
0x00000008e4e47810ULL, 0x000fe40007ffe0ffULL, 0x00000018ffda7819ULL, 0x000fe400000114daULL,
0x000000bd8d8d723eULL, 0x000fe200000010ffULL, 0x000000d100bc7306ULL, 0x000fe20000209400ULL,
0x00000001c2c22812ULL, 0x000fc400078efcffULL, 0x000000d0e100720bULL, 0x002fca0003f9d000ULL,
0x000000d100d97306ULL, 0x000e700000205400ULL, 0x0000002c00d07306ULL, 0x0004f0000000d400ULL,
0x000000d100c17306ULL, 0x000f22000020d400ULL, 0x0000000dff2c723eULL, 0x004fc400000010ffULL,
0x000000d9bc00720bULL, 0x002fca0003f3d000ULL, 0x0000002d00d17306ULL, 0x0002a2000000d400ULL,
0x00000001d0d05812ULL, 0x008fce00078efcffULL, 0x000000e200ce7306ULL, 0x000762000020d400ULL,
0x000054102c2d7816ULL, 0x002fe2000000002cULL, 0x000000ffff2c7224ULL, 0x000fe200078e0083ULL,
0x00000001c1c11812ULL, 0x010fc600078efcffULL, 0x00001f862d867589ULL, 0x000e6200000e0000ULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x000000b000c77306ULL, 0x000fe20000209400ULL,
0x000001002e2c7824ULL, 0x000fe200078e00ffULL, 0x00001fe42d837589ULL, 0x00086200000e0000ULL,
0x00000001d1d16812ULL, 0x004fe400078efcffULL, 0x000000b7b400720bULL, 0x000fe40003fdd000ULL,
0x00000018ffe27819ULL, 0x008fe2000001142cULL, 0x000000b000cb7306ULL, 0x000ea20000205400ULL,
0x000000cabb2c723eULL, 0x000fc400000010ffULL, 0x00000001cece4812ULL, 0x020fe400078efcffULL,
0x000000c6c52d723eULL, 0x010fc600000010ffULL, 0x000000b000c97306ULL, 0x000ee4000020d400ULL,
0x00000001b5b56812ULL, 0x000fe200078efcffULL, 0x000000866c6c8231ULL, 0x082fe400003400ffULL,
0x000000866e6e8231ULL, 0x000fe200003400ffULL, 0x000000cbc700720bULL, 0x004fe20003f9d000ULL,
0x000000836d6d8231ULL, 0x080fe200003400ffULL, 0x0000002f00c77306ULL, 0x000fe20000009400ULL,
0x000000836f6f8231ULL, 0x000fce00003400ffULL, 0x0000002c6c40723cULL, 0x000fe20000041840ULL,
0x0000002f002c7306ULL, 0x000e640000005400ULL, 0x00000001c9c94812ULL, 0x008fc800078efcffULL,
0x000001002f2d7824ULL, 0x000fe200078e00ffULL, 0x0000008c6c58723cULL, 0x000fe20000041858ULL,
0x000000da00e07306ULL, 0x000fe60000209400ULL, 0x00000018ff2d7819ULL, 0x000fc6000001142dULL,
0x000000d0ce8c723eULL, 0x000fe400000010ffULL, 0x000000da00e17306ULL, 0x000ea20000205400ULL,
0x0000002cc700720bULL, 0x002fe20003f3d000ULL, 0x000100002e2c7824ULL, 0x000fe200078e00ffULL,
0x000000d1c18d723eULL, 0x000fca00000010ffULL, 0x000000e200b07306ULL, 0x000fe40000209400ULL,
0x0000008c6c50723cULL, 0x000fec0000041850ULL, 0x000000e200bc7306ULL, 0x000e620000205400ULL,
0x000000e1e000720bULL, 0x004fe40003f9d000ULL, 0x000000c9c38c723eULL, 0x000fca00000010ffULL,
0x0000002e00bb7306ULL, 0x000ff00000009400ULL, 0x0000002e00c67306ULL, 0x000ea20000005400ULL,
0x000000bcb000720bULL, 0x002fce0003f7d000ULL, 0x000000e200c47306ULL, 0x0002f0000020d400ULL,
0x000000da00c87306ULL, 0x000f22000020d400ULL, 0x00000018ffe27819ULL, 0x002fe2000001142cULL,
0x000100002f2c7824ULL, 0x000fe200078e00ffULL, 0x000000c6bb00720bULL, 0x004fca0003fbd000ULL,
0x0000002d00d97306ULL, 0x000fe20000209400ULL, 0x00000001c4c43812ULL, 0x008fce00078efcffULL,
0x0000002d00da7306ULL, 0x000e620000205400ULL, 0x00000001c8c84812ULL, 0x010fe400078efcffULL,
0x000000c0bf00720bULL, 0x000fe40003f9d000ULL, 0x000000c8c28d723eULL, 0x000fc600000010ffULL,
0x0000002e00c77306ULL, 0x0004e8000000d400ULL, 0x0000008c6c3c723cULL, 0x000fe8000004183cULL,
0x0000002d00c57306ULL, 0x000962000020d400ULL, 0x00000018ff2e7819ULL, 0x004fe4000001142cULL,
0x000000ccba2c723eULL, 0x000fe200000010ffULL, 0x000100005d8c7824ULL, 0x000fe200078e00ffULL,
0x000000dad900720bULL, 0x002fc40003f5d000ULL, 0x0000000195954812ULL, 0x000fe200078efcffULL,
0x000000e200ca7306ULL, 0x000fe20000209400ULL, 0x000000cdb92d723eULL, 0x010fe400000010ffULL,
0x00000001c7c75812ULL, 0x008fca00078efcffULL, 0x000000e200cb7306ULL, 0x000e620000205400ULL,
0x0000002c6c38723cULL, 0x000fe20000041838ULL, 0x00000001c5c52812ULL, 0x020fcc00078efcffULL,
0x0000002e00cc7306ULL, 0x000fe20000209400ULL, 0x000001005c2d7824ULL, 0x000fca00078e00ffULL,
0x00000018ffe07819ULL, 0x000fe4000001142dULL, 0x0000002e00cd7306ULL, 0x000ea20000205400ULL,
0x000000cbca00720bULL, 0x002fce0003f7d000ULL, 0x0000002f00c67306ULL, 0x0002f0000000d400ULL,
0x000000e200bb7306ULL, 0x000f22000020d400ULL, 0x000000dfb62f723eULL, 0x002fe400000010ffULL,
0x000000cdcc00720bULL, 0x004fca0003fbd000ULL, 0x0000002e00ba7306ULL, 0x0002a2000020d400ULL,
0x00000001c6c61812ULL, 0x008fce00078efcffULL, 0x0000005c00b47306ULL, 0x000fe20000009400ULL,
0x000000beb82e723eULL, 0x002fe200000010ffULL, 0x000100005cb87824ULL, 0x000fe200078e00ffULL,
0x00000001bbbb3812ULL, 0x010fca00078efcffULL, 0x0000005c00b97306ULL, 0x000e620000005400ULL,
0x0000002e6c54723cULL, 0x000fe20000041854ULL, 0x00000001baba5812ULL, 0x004fcc00078efcffULL,
0x0000005c002c7306ULL, 0x0004e2000000d400ULL, 0x000001005d2e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000005d00bf7306ULL, 0x000fe20000009400ULL,
0x00000018ff5c7819ULL, 0x004fe400000114b8ULL, 0x000000b9b400720bULL, 0x002fca0003f3d000ULL,
0x0000005d00c07306ULL, 0x000e700000005400ULL, 0x0000005c00b87306ULL, 0x000fe20000209400ULL,
0x000000012c2c1812ULL, 0x008fe400078efcffULL, 0x000000b3ad00720bULL, 0x000fca0003f3d000ULL,
0x0000005c00be7306ULL, 0x000ea20000205400ULL, 0x000000c0bf00720bULL, 0x002fce0003fdd000ULL,
0x0000005c002f7306ULL, 0x0003e2000020d400ULL, 0x0000000194941812ULL, 0x000fce00078efcffULL,
0x0000005d00c17306ULL, 0x000722000000d400ULL, 0x000000c7c45c723eULL, 0x002fe400000010ffULL,
0x000000beb800720bULL, 0x004fca0003f7d000ULL, 0x0000002e00bd7306ULL, 0x000fe20000209400ULL,
0x000000c6c55d723eULL, 0x008fe400000010ffULL, 0x00000018ffc57819ULL, 0x000fca000001148cULL,
0x0000005c6c4c723cULL, 0x000fe2000004184cULL, 0x00000001c1c16812ULL, 0x010fe200078efcffULL,
0x0000002e00bc7306ULL, 0x000e620000205400ULL, 0x000000abac00720bULL, 0x000fe40003fdd000ULL,
0x000000012f2f3812ULL, 0x000fe400078efcffULL, 0x000000bbb55c723eULL, 0x000fe200000010ffULL,
0x000001005eb57824ULL, 0x000fe200078e00ffULL, 0x000000ba955d723eULL, 0x000fe200000010ffULL,
0x0000002e00b07306ULL, 0x000ea6000020d400ULL, 0x00000018ff957819ULL, 0x000fc600000114b5ULL,
0x0000005c6c48723cULL, 0x000fe20000041848ULL, 0x0000000193936812ULL, 0x000fe200078efcffULL,
0x0000005e00c37306ULL, 0x000fe20000009400ULL, 0x000000bcbd00720bULL, 0x002fc80003f7d000ULL,
0x000001005f5c7824ULL, 0x000fe400078e00ffULL, 0x00000100686c7824ULL, 0x000fe200078e00ffULL,
0x0000005e00c27306ULL, 0x000e640000005400ULL, 0x00000018ff5c7819ULL, 0x000fc8000001145cULL,
0x00000001b0b03812ULL, 0x004fe400078efcffULL, 0x0000005c00e67306ULL, 0x000ff00000209400ULL,
0x0000005c00e87306ULL, 0x000ea20000205400ULL, 0x000000c2c300720bULL, 0x002fce0003f5d000ULL,
0x0000005e002e7306ULL, 0x0002f0000000d400ULL, 0x0000005c00ce7306ULL, 0x000962000020d400ULL,
0x000100005e5e7824ULL, 0x002fe200078e00ffULL, 0x000000e8e600720bULL, 0x004fc80003fdd000ULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000005f008d7306ULL, 0x000fe20000009400ULL,
0x00000100695c7824ULL, 0x010fe200078e00ffULL, 0x000000012e2e2812ULL, 0x008fe400078efcffULL,
0x000000a0a200720bULL, 0x000fe40003f5d000ULL, 0x00000018ffc67819ULL, 0x000fe4000001145cULL,
0x0000005e005d7306ULL, 0x000fe20000209400ULL, 0x00000001cece6812ULL, 0x020fce00078efcffULL,
0x0000005e006f7306ULL, 0x000e620000205400ULL, 0x000000018a8a2812ULL, 0x000fce00078efcffULL,
0x0000005f00c47306ULL, 0x000eb00000005400ULL, 0x0000005f00c97306ULL, 0x000722000000d400ULL,
0x0000006f5d00720bULL, 0x002fe20003fdd000ULL, 0x00000100655d7824ULL, 0x000fcc00078e00ffULL,
0x0000005e00cb7306ULL, 0x000e62000020d400ULL, 0x000100005f5f7824ULL, 0x008fe200078e00ffULL,
0x000000c48d00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000009500b57306ULL, 0x000fee0000209400ULL, 0x00000001c9c94812ULL, 0x010fe200078efcffULL,
0x0000005f006d7306ULL, 0x000fe20000209400ULL, 0x00000001cbcb6812ULL, 0x002fc400078efcffULL,
0x0000009d9c00720bULL, 0x000fca0003f9d000ULL, 0x0000005f00e47306ULL, 0x000e700000205400ULL,
0x0000009500eb7306ULL, 0x000fe20000205400ULL, 0x0000000189894812ULL, 0x000fce00078efcffULL,
0x0000009500cd7306ULL, 0x0005e2000020d400ULL, 0x000000e46d00720bULL, 0x002fce0003fdd000ULL,
0x0000005f00ca7306ULL, 0x000e62000020d400ULL, 0x00000018ff957819ULL, 0x004fce000001146cULL,
0x000000c6006c7306ULL, 0x000ff00000209400ULL, 0x000000c600d97306ULL, 0x000ea20000205400ULL,
0x00000001caca6812ULL, 0x002fce00078efcffULL, 0x00000095006e7306ULL, 0x000ff00000209400ULL,
0x0000009500e37306ULL, 0x000e620000205400ULL, 0x000000d96c00720bULL, 0x004fce0003fdd000ULL,
0x0000009500bb7306ULL, 0x0004f0000020d400ULL, 0x000000c5008c7306ULL, 0x000fe20000209400ULL,
0x0001000068957824ULL, 0x004fe200078e00ffULL, 0x000000e36e00720bULL, 0x002fcc0003f5d000ULL,
0x000000c500df7306ULL, 0x000e6e0000205400ULL, 0x00000001bbbb2812ULL, 0x008fe200078efcffULL,
0x000000c500cc7306ULL, 0x0005f0000020d400ULL, 0x000000c600ba7306ULL, 0x000ee2000020d400ULL,
0x00000018ffc57819ULL, 0x004fe20000011495ULL, 0x0001000069957824ULL, 0x000fe200078e00ffULL,
0x000000df8c00720bULL, 0x002fc80003f3d000ULL, 0x00000018ffbf7819ULL, 0x000fe20000011495ULL,
0x000000c500b47306ULL, 0x000ff00000209400ULL, 0x000000c500e27306ULL, 0x000e620000205400ULL,
0x00000001baba6812ULL, 0x008fc400078efcffULL, 0x00000001cccc1812ULL, 0x000fe400078efcffULL,
0x000000ebb500720bULL, 0x000fc60003f3d000ULL, 0x000000e000b77306ULL, 0x000ff00000209400ULL,
0x000000e000b67306ULL, 0x000ea20000205400ULL, 0x000000e2b400720bULL, 0x002fe40003fdd000ULL,
0x00000001cdcd1812ULL, 0x000fca00078efcffULL, 0x000000c500c67306ULL, 0x000e70000020d400ULL,
0x000000bf00d07306ULL, 0x000fe20000209400ULL, 0x000000b6b700720bULL, 0x004fe20003fbd000ULL,
0x000001006bb67824ULL, 0x000fca00078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x000000bf00d17306ULL, 0x000ea20000205400ULL, 0x00000001c6c66812ULL, 0x002fce00078efcffULL,
0x000000e0002d7306ULL, 0x000e70000020d400ULL, 0x00000068005c7306ULL, 0x000fe20000009400ULL,
0x000000d1d000720bULL, 0x004fce0003fdd000ULL, 0x00000068005e7306ULL, 0x000ea20000005400ULL,
0x000000012d2d5812ULL, 0x002fc800078efcffULL, 0x0000002c2d2c723eULL, 0x000fe400000010ffULL,
0x000000c1b02d723eULL, 0x000fe200000010ffULL, 0x000000bf00957306ULL, 0x000e70000020d400ULL,
0x000000b600e07306ULL, 0x000fe20000209400ULL, 0x0000005e5c00720bULL, 0x004fe20003fbd000ULL,
0x000100006a5c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001145cULL,
0x000000b600e17306ULL, 0x000ea20000205400ULL, 0x0000000195956812ULL, 0x002fe200078efcffULL,
0x000100006b5c7824ULL, 0x000fcc00078e00ffULL, 0x000000b600c27306ULL, 0x000e70000020d400ULL,
0x0000008d00de7306ULL, 0x000fe20000209400ULL, 0x000000e1e000720bULL, 0x004fce0003fdd000ULL,
0x0000008d00df7306ULL, 0x000eac0000205400ULL, 0x00000001c2c26812ULL, 0x002fe400078efcffULL,
0x0000006800c77306ULL, 0x0002f0000000d400ULL, 0x0000006a00b77306ULL, 0x000fe20000009400ULL,
0x000001006a687824ULL, 0x002fe200078e00ffULL, 0x000000dfde00720bULL, 0x004fcc0003fdd000ULL,
0x0000006a00ed7306ULL, 0x000e620000005400ULL, 0x00000001c7c75812ULL, 0x008fe400078efcffULL,
0x0000009b9a00720bULL, 0x000fca0003fbd000ULL, 0x0000006a00c47306ULL, 0x0005f0000000d400ULL,
0x0000008d00bf7306ULL, 0x000ee2000020d400ULL, 0x00000018ff6a7819ULL, 0x004fe4000001145cULL,
0x0000000188885812ULL, 0x000fc400078efcffULL, 0x000000edb700720bULL, 0x002fc60003f3d000ULL,
0x00000069005f7306ULL, 0x000ff00000009400ULL, 0x0000006900b97306ULL, 0x000e620000005400ULL,
0x00000001bfbf6812ULL, 0x008fe400078efcffULL, 0x00000001c4c41812ULL, 0x000fc400078efcffULL,
0x000000989100720bULL, 0x000fe20003f3d000ULL, 0x0001000034917824ULL, 0x000fe400078e00ffULL,
0x0000006a005c7306ULL, 0x000fe60000209400ULL, 0x00000018ff917819ULL, 0x000fca0000011491ULL,
0x0000006a005e7306ULL, 0x000ea20000205400ULL, 0x000000b95f00720bULL, 0x002fe20003f7d000ULL,
0x00000100645f7824ULL, 0x000fe200078e00ffULL, 0x0000000185851812ULL, 0x000fc800078efcffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000006a00be7306ULL, 0x0002f0000020d400ULL,
0x0000006900c87306ULL, 0x000962000000d400ULL, 0x00010000646a7824ULL, 0x002fe200078e00ffULL,
0x0000005e5c00720bULL, 0x004fe20003fdd000ULL, 0x00000100375c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x0000006b00ea7306ULL, 0x000fe20000005400ULL,
0x00000018ff697819ULL, 0x010fcc0000011468ULL, 0x00000001bebe6812ULL, 0x008fe200078efcffULL,
0x0000006a00bd7306ULL, 0x000fe20000209400ULL, 0x00000001c8c83812ULL, 0x020fe400078efcffULL,
0x000000969900720bULL, 0x000fca0003f7d000ULL, 0x0000006a00c07306ULL, 0x000e700000205400ULL,
0x0000006900687306ULL, 0x000fe20000209400ULL, 0x0000000187873812ULL, 0x000fc800078efcffULL,
0x000000958795723eULL, 0x000fc600000010ffULL, 0x0000006900da7306ULL, 0x000ea20000205400ULL,
0x000000c0bd00720bULL, 0x002fce0003fdd000ULL, 0x0000006900c37306ULL, 0x000e70000020d400ULL,
0x0000006b00697306ULL, 0x000ee20000009400ULL, 0x000000da6800720bULL, 0x004fce0003fbd000ULL,
0x0000006b00c57306ULL, 0x000eac000000d400ULL, 0x00000001c3c35812ULL, 0x002fe400078efcffULL,
0x00000064006b7306ULL, 0x000fe20000009400ULL, 0x000000ea6900720bULL, 0x008fce0003f9d000ULL,
0x0000006400ab7306ULL, 0x000e6c0000005400ULL, 0x00000001c5c54812ULL, 0x004fe400078efcffULL,
0x0000006400b67306ULL, 0x0004e2000000d400ULL, 0x0000008f9000720bULL, 0x000fe20003f9d000ULL,
0x00010000358f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff907819ULL, 0x000fe2000001148fULL,
0x0000005f008c7306ULL, 0x000fe20000209400ULL, 0x00000018ff647819ULL, 0x004fe4000001145dULL,
0x000000ab6b00720bULL, 0x002fc60003f5d000ULL, 0x0000000184844812ULL, 0x000fe400078efcffULL,
0x0000005f008d7306ULL, 0x000e700000205400ULL, 0x0000005f00b87306ULL, 0x000fe2000020d400ULL,
0x00000001b6b62812ULL, 0x008fc400078efcffULL, 0x000000afae00720bULL, 0x000fca0003f5d000ULL,
0x0000006a00b37306ULL, 0x0004e2000020d400ULL, 0x0000008d8c00720bULL, 0x002fe40003f3d000ULL,
0x00000018ff8d7819ULL, 0x000fca000001145cULL, 0x00000064005d7306ULL, 0x000fe20000209400ULL,
0x00010000656a7824ULL, 0x004fe200078e00ffULL, 0x0000000182822812ULL, 0x000fe400078efcffULL,
0x0000008eaa00720bULL, 0x000fe40003f5d000ULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000064005f7306ULL, 0x000e620000205400ULL, 0x00000001b3b36812ULL, 0x008fe400078efcffULL,
0x00000001b8b81812ULL, 0x000fc400078efcffULL, 0x000000b38282723eULL, 0x000fc600000010ffULL,
0x0000006400b97306ULL, 0x0004e2000020d400ULL, 0x000000017f7f2812ULL, 0x000fce00078efcffULL,
0x0000006a00b57306ULL, 0x000fe20000209400ULL, 0x0000005f5d00720bULL, 0x002fe20003fdd000ULL,
0x0000010067647824ULL, 0x004fe400078e00ffULL, 0x00010000365d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000006a006f7306ULL, 0x000e620000205400ULL,
0x00000018ffae7819ULL, 0x000fca000001145dULL, 0x00000001b9b96812ULL, 0x008fe400078efcffULL,
0x0000006a00ad7306ULL, 0x000eb0000020d400ULL, 0x00000064006a7306ULL, 0x000fe20000209400ULL,
0x0000006fb500720bULL, 0x002fce0003fdd000ULL, 0x00000064006c7306ULL, 0x000e6c0000205400ULL,
0x00000001adad6812ULL, 0x004fe400078efcffULL, 0x0000006600e47306ULL, 0x000ff00000009400ULL,
0x0000006600e37306ULL, 0x000ea20000005400ULL, 0x0000006c6a00720bULL, 0x002fce0003fdd000ULL,
0x00000064009d7306ULL, 0x0002f0000020d400ULL, 0x0000006500bc7306ULL, 0x000fe20000009400ULL,
0x0001000066647824ULL, 0x002fe200078e00ffULL, 0x000000e3e400720bULL, 0x004fc80003fbd000ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000006500e67306ULL, 0x000e620000005400ULL,
0x000000019d9d6812ULL, 0x008fce00078efcffULL, 0x0000006500b77306ULL, 0x0005f0000000d400ULL,
0x0000006600ab7306ULL, 0x000722000000d400ULL, 0x0000010066657824ULL, 0x004fe200078e00ffULL,
0x000000e6bc00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000064006b7306ULL, 0x000fe20000209400ULL, 0x0000010034667824ULL, 0x008fca00078e00ffULL,
0x00000018ff997819ULL, 0x000fe40000011466ULL, 0x0000006400b47306ULL, 0x000e620000205400ULL,
0x00000001abab5812ULL, 0x010fe400078efcffULL, 0x000000a9a800720bULL, 0x000fe40003fbd000ULL,
0x00000001b7b73812ULL, 0x000fc600078efcffULL, 0x00000065006d7306ULL, 0x000ff00000209400ULL,
0x00000065006e7306ULL, 0x000ea20000205400ULL, 0x000000b46b00720bULL, 0x002fe40003fdd000ULL,
0x000000017e7e5812ULL, 0x000fca00078efcffULL, 0x0000006500ac7306ULL, 0x0002f0000020d400ULL,
0x0000006700d97306ULL, 0x000fe20000009400ULL, 0x0001000067657824ULL, 0x002fe200078e00ffULL,
0x0000006e6d00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x0000006700e27306ULL, 0x000e6e0000005400ULL, 0x00000001acac3812ULL, 0x008fe200078efcffULL,
0x0000006700a07306ULL, 0x000ff0000000d400ULL, 0x0000006400a27306ULL, 0x0004e2000020d400ULL,
0x000000e2d900720bULL, 0x002fce0003f9d000ULL, 0x0000006500677306ULL, 0x000fe20000209400ULL,
0x0000010035647824ULL, 0x004fca00078e00ffULL, 0x00000018ffd07819ULL, 0x000fe40000011464ULL,
0x0000006500697306ULL, 0x000e620000205400ULL, 0x00000001a2a26812ULL, 0x008fe400078efcffULL,
0x00000001a0a04812ULL, 0x000fe400078efcffULL, 0x000000a4a300720bULL, 0x000fe40003f9d000ULL,
0x000000a27e7e723eULL, 0x000fe200000010ffULL, 0x0000009900667306ULL, 0x000ff00000209400ULL,
0x0000009900687306ULL, 0x000ea20000205400ULL, 0x000000696700720bULL, 0x002fc40003fdd000ULL,
0x000000017b7b4812ULL, 0x000fca00078efcffULL, 0x00000065009c7306ULL, 0x000e70000020d400ULL,
0x00000099009b7306ULL, 0x000ee2000020d400ULL, 0x000000686600720bULL, 0x004fe20003fbd000ULL,
0x0001000046667824ULL, 0x000fcc00078e00ffULL, 0x0000003500bc7306ULL, 0x000fe20000009400ULL,
0x000000019c9c6812ULL, 0x002fce00078efcffULL, 0x0000003500e37306ULL, 0x000e620000005400ULL,
0x000000019b9b5812ULL, 0x008fe400078efcffULL, 0x000000a6a700720bULL, 0x000fe40003fbd000ULL,
0x00000018ffa77819ULL, 0x000fc60000011466ULL, 0x0000003500987306ULL, 0x0004f0000000d400ULL,
0x0000009000d17306ULL, 0x000fe20000209400ULL, 0x0000010036357824ULL, 0x004fe200078e00ffULL,
0x000000017a7a5812ULL, 0x000fc400078efcffULL, 0x000000e3bc00720bULL, 0x002fe40003f5d000ULL,
0x00000018ffde7819ULL, 0x000fe40000011435ULL, 0x0000009000e07306ULL, 0x000ff00000205400ULL,
0x00000090008f7306ULL, 0x000fe2000020d400ULL, 0x0000000198982812ULL, 0x008fc400078efcffULL,
0x0000009f9e00720bULL, 0x000fca0003f5d000ULL, 0x000000d000647306ULL, 0x000ff00000209400ULL,
0x000000d000657306ULL, 0x000e620000205400ULL, 0x0000000178782812ULL, 0x000fce00078efcffULL,
0x0000008d005c7306ULL, 0x000ff00000209400ULL, 0x0000008d005e7306ULL, 0x000fe20000205400ULL,
0x000000656400720bULL, 0x002fe20003fdd000ULL, 0x0000010047647824ULL, 0x000fcc00078e00ffULL,
0x0000008d008c7306ULL, 0x000ff0000020d400ULL, 0x0000003600e87306ULL, 0x000ff00000009400ULL,
0x0000003600bd7306ULL, 0x000e700000005400ULL, 0x0000003600907306ULL, 0x0004f0000000d400ULL,
0x0000003700e27306ULL, 0x000fe20000009400ULL, 0x0001000037367824ULL, 0x004fe200078e00ffULL,
0x000000bde800720bULL, 0x002fc80003f7d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003700e47306ULL, 0x000fee0000005400ULL, 0x0000000190903812ULL, 0x008fe200078efcffULL,
0x00000037008d7306ULL, 0x0003e2000000d400ULL, 0x000000a5a100720bULL, 0x000fce0003f7d000ULL,
0x0000003400da7306ULL, 0x000fe20000009400ULL, 0x0000010044377824ULL, 0x002fca00078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe20000011437ULL, 0x0000010045377824ULL, 0x000fe200078e00ffULL,
0x0000003400e67306ULL, 0x000e620000005400ULL, 0x0000000177773812ULL, 0x000fc600078efcffULL,
0x00000018ff6c7819ULL, 0x000fc80000011437ULL, 0x00000034009a7306ULL, 0x000eb0000000d400ULL,
0x0000009100347306ULL, 0x000fe20000209400ULL, 0x000000e6da00720bULL, 0x002fce0003f3d000ULL,
0x0000009100e17306ULL, 0x000e6c0000205400ULL, 0x000000019a9a1812ULL, 0x004fe400078efcffULL,
0x000000d000967306ULL, 0x000ea2000020d400ULL, 0x000000e4e200720bULL, 0x000fe40003f3d000ULL,
0x0000009a9b9a723eULL, 0x000fca00000010ffULL, 0x00000036005f7306ULL, 0x000fe20000209400ULL,
0x000000e13400720bULL, 0x002fe40003f9d000ULL, 0x0001280097347811ULL, 0x000fc600078e20ffULL,
0x000000018d8d1812ULL, 0x000fe400078efcffULL, 0x0000003600aa7306ULL, 0x000e620000205400ULL,
0x0000000196966812ULL, 0x004fc800078efcffULL, 0x00000098969b723eULL, 0x000fc600000010ffULL,
0x00000036006f7306ULL, 0x000eb0000020d400ULL, 0x000000de00357306ULL, 0x000fe20000209400ULL,
0x000000aa5f00720bULL, 0x002fce0003f7d000ULL, 0x000000de00d07306ULL, 0x000e6c0000205400ULL,
0x000000016f6f3812ULL, 0x004fe400078efcffULL, 0x0000004400367306ULL, 0x000ff00000009400ULL,
0x0000004400377306ULL, 0x000ea20000005400ULL, 0x000000d03500720bULL, 0x002fce0003fbd000ULL,
0x0000009100997306ULL, 0x000e62000020d400ULL, 0x000000373600720bULL, 0x004fce0003fdd000ULL,
0x000000ae005d7306ULL, 0x000fe20000209400ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000000199994812ULL, 0x002fcc00078efcffULL, 0x000000ae00c07306ULL, 0x000fe20000205400ULL,
0x000000e0d100720bULL, 0x000fe40003f9d000ULL, 0x000000997a7a723eULL, 0x000fca00000010ffULL,
0x000000de00917306ULL, 0x000e6c000020d400ULL, 0x000000018f8f4812ULL, 0x000fe400078efcffULL,
0x0000005e5c00720bULL, 0x000fe20003f9d000ULL, 0x000000ae008e7306ULL, 0x000ee2000020d400ULL,
0x00010000475c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145cULL,
0x000000af00de7306ULL, 0x000fe20000209400ULL, 0x0000000191915812ULL, 0x002fc600078efcffULL,
0x000000018c8c4812ULL, 0x000fe400078efcffULL, 0x000000c05d00720bULL, 0x000fe40003f9d000ULL,
0x000000af00df7306ULL, 0x000e620000205400ULL, 0x0000008634348231ULL, 0x084fe200003400ffULL,
0x000000909190723eULL, 0x000fe200000010ffULL, 0x0000008636368231ULL, 0x000fe200003400ffULL,
0x0000008d8c91723eULL, 0x000fe200000010ffULL, 0x0000008335358231ULL, 0x080fe400003400ffULL,
0x0000008337378231ULL, 0x000fe200003400ffULL, 0x0000006c00d97306ULL, 0x000fe60000209400ULL,
0x000000018e8e4812ULL, 0x008fc400078efcffULL, 0x000000928b00720bULL, 0x000fe20003f9d000ULL,
0x0000002c3440723cULL, 0x000fe20000041840ULL, 0x000000c7bb92723eULL, 0x000fe200000010ffULL,
0x0000006c00da7306ULL, 0x000ea20000205400ULL, 0x000000dfde00720bULL, 0x002fe40003f7d000ULL,
0x0000008e778e723eULL, 0x000fe400000010ffULL, 0x0000002f942c723eULL, 0x000fe400000010ffULL,
0x000000cc932d723eULL, 0x000fe200000010ffULL, 0x0000006c006a7306ULL, 0x0002e2000020d400ULL,
0x000000c8ba93723eULL, 0x000fc400000010ffULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x000000c68894723eULL, 0x000fe200000010ffULL, 0x0000002c3438723cULL, 0x000fe20000041838ULL,
0x0001000061887824ULL, 0x000fe200078e00ffULL, 0x00000044006d7306ULL, 0x000962000000d400ULL,
0x00010000446c7824ULL, 0x002fe200078e00ffULL, 0x000000dad900720bULL, 0x004fc60003f9d000ULL,
0x0000002ecd2c723eULL, 0x000fe200000010ffULL, 0x00000100602e7824ULL, 0x000fe200078e00ffULL,
0x000000c9ce2d723eULL, 0x000fe200000010ffULL, 0x0000004500a87306ULL, 0x000fe20000009400ULL,
0x0001000045447824ULL, 0x010fe200078e00ffULL, 0x000000923450723cULL, 0x040fe20000041850ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142eULL, 0x00012800b12e7811ULL, 0x000fe400078e20ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000004500a97306ULL, 0x000e620000005400ULL,
0x000000016a6a4812ULL, 0x008fe200078efcffULL, 0x0000002c3454723cULL, 0x000fe20000041854ULL,
0x0001000060927824ULL, 0x000fe200078e00ffULL, 0x000000c5c293723eULL, 0x000fe200000010ffULL,
0x0000010063c27824ULL, 0x000fe200078e00ffULL, 0x000000016d6d6812ULL, 0x020fc400078efcffULL,
0x00000045006b7306ULL, 0x0005e2000000d400ULL, 0x00000100612c7824ULL, 0x000fe200078e00ffULL,
0x000000ca892d723eULL, 0x000fe200000010ffULL, 0x00000094343c723cULL, 0x000fe2000004183cULL,
0x00000018ffc77819ULL, 0x000fe40000011492ULL, 0x00000018ffc97819ULL, 0x000fe4000001142cULL,
0x000000af006e7306ULL, 0x000722000020d400ULL, 0x0000010046457824ULL, 0x004fe200078e00ffULL,
0x000000cb8a2c723eULL, 0x000fe200000010ffULL, 0x0001000062957824ULL, 0x040fe200078e00ffULL,
0x000000c4c392723eULL, 0x000fe200000010ffULL, 0x0000010062c37824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fc40000011445ULL, 0x0000004400b47306ULL, 0x000fe20000209400ULL,
0x00000018ffaf7819ULL, 0x008fe2000001146cULL, 0x0000002c3458723cULL, 0x040fe20000041858ULL,
0x000000a9a800720bULL, 0x002fe40003f5d000ULL, 0x00000018ffc47819ULL, 0x000fe20000011488ULL,
0x0001000063887824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x0000004400b57306ULL, 0x000e620000205400ULL, 0x000000016e6e3812ULL, 0x010fe200078efcffULL,
0x00000092344c723cULL, 0x000fe2000004184cULL, 0x000000818000720bULL, 0x000fc40003fdd000ULL,
0x00000018ffc27819ULL, 0x000fe400000114c2ULL, 0x00000018ff957819ULL, 0x000fe20000011495ULL,
0x0000004400677306ULL, 0x0004e2000020d400ULL, 0x000000016b6b2812ULL, 0x000fe400078efcffULL,
0x0000007d7c00720bULL, 0x000fe40003f5d000ULL, 0x0000006d6e6e723eULL, 0x000fc600000010ffULL,
0x000000af00bc7306ULL, 0x000fe20000209400ULL, 0x00000018ff447819ULL, 0x004fe40000011464ULL,
0x000000b5b400720bULL, 0x002fe40003f9d000ULL, 0x0000000175756812ULL, 0x000fc600078efcffULL,
0x000000af00bd7306ULL, 0x000e620000205400ULL, 0x0000000174742812ULL, 0x000fce00078efcffULL,
0x000000af006c7306ULL, 0x000ea2000020d400ULL, 0x0000000167674812ULL, 0x008fc800078efcffULL,
0x00000067746d723eULL, 0x000fc600000010ffULL, 0x0000004500ae7306ULL, 0x000fe20000209400ULL,
0x000000bdbc00720bULL, 0x002fce0003f7d000ULL, 0x0000004500af7306ULL, 0x000e6c0000205400ULL,
0x000000016c6c3812ULL, 0x004fe400078efcffULL, 0x0000004500697306ULL, 0x000ea4000020d400ULL,
0x0000006c756c723eULL, 0x000fcc00000010ffULL, 0x0000004400a37306ULL, 0x000fe20000209400ULL,
0x000000afae00720bULL, 0x002fce0003f7d000ULL, 0x0000004400a47306ULL, 0x000e6c0000205400ULL,
0x0000000169693812ULL, 0x004fe400078efcffULL, 0x0000004400647306ULL, 0x000eb0000020d400ULL,
0x0000004600457306ULL, 0x000fe20000009400ULL, 0x000000a4a300720bULL, 0x002fce0003f9d000ULL,
0x0000004600a67306ULL, 0x000e6c0000005400ULL, 0x0000000164644812ULL, 0x004fe400078efcffULL,
0x0000004600687306ULL, 0x000eb0000000d400ULL, 0x0000004700447306ULL, 0x000fe20000009400ULL,
0x000000a64500720bULL, 0x002fce0003fbd000ULL, 0x0000004700467306ULL, 0x000e6c0000005400ULL,
0x0000000168685812ULL, 0x004fe400078efcffULL, 0x000000a7009e7306ULL, 0x000fe20000209400ULL,
0x00000079cf00720bULL, 0x000fe40003fbd000ULL, 0x000000686968723eULL, 0x000fc400000010ffULL,
0x000000464400720bULL, 0x002fc60003f3d000ULL, 0x000000a7009f7306ULL, 0x000e620000205400ULL,
0x00012800b2447811ULL, 0x000fca00078e20ffULL, 0x0000000173735812ULL, 0x000fe400078efcffULL,
0x000000a700667306ULL, 0x000eb0000020d400ULL, 0x0000004700657306ULL, 0x000722000000d400ULL,
0x0000009f9e00720bULL, 0x002fce0003f7d000ULL, 0x0000002f00a67306ULL, 0x000fe20000209400ULL,
0x000000004444783bULL, 0x008e6a0000000200ULL, 0x0000000166663812ULL, 0x004fe400078efcffULL,
0x0000002f00a77306ULL, 0x000ea20000205400ULL, 0x0000000165651812ULL, 0x010fe400078efcffULL,
0x000000d2d300720bULL, 0x000fc40003f3d000ULL, 0x000000656469723eULL, 0x000fe400000010ffULL,
0x000000667366723eULL, 0x000fe200000010ffULL, 0x0000002f008b7306ULL, 0x000730000020d400ULL,
0x0000005e00d17306ULL, 0x000fe20000209400ULL, 0x000000002e2c783bULL, 0x008ee20000000200ULL,
0x000000a7a600720bULL, 0x004fc40003f7d000ULL, 0x0000000124241812ULL, 0x000fe400078efcffULL,
0x000000dcdd00720bULL, 0x000fe40003f3d000ULL, 0x0000005e00d07306ULL, 0x000eae0000205400ULL,
0x000000018b8b3812ULL, 0x010fe200078efcffULL, 0x0000006000c07306ULL, 0x000fe20000009400ULL,
0x0000008345458231ULL, 0x002fc400003400ffULL, 0x0000008347478231ULL, 0x000fe200003400ffULL,
0x0000000100001812ULL, 0x000fe200078efcffULL, 0x0000008644448231ULL, 0x080fe200003400ffULL,
0x000000d4d500720bULL, 0x000fe20003f3d000ULL, 0x0000008646468231ULL, 0x000fe200003400ffULL,
0x0000006000c17306ULL, 0x000e620000005400ULL, 0x000000d0d100720bULL, 0x004fca0003f9d000ULL,
0x0000009a4450723cULL, 0x000fe40000041850ULL, 0x00000060005d7306ULL, 0x000ea6000000d400ULL,
0x0000000102021812ULL, 0x000fc600078efcffULL, 0x00000090444c723cULL, 0x000fe4000004184cULL,
0x0000006200a97306ULL, 0x000fe20000009400ULL, 0x000000832d2d8231ULL, 0x088fe400003400ffULL,
0x000000832f2f8231ULL, 0x000fe200003400ffULL, 0x000000ad7f83723eULL, 0x000fe200000010ffULL,
0x000000862c2c8231ULL, 0x080fe200003400ffULL, 0x0000009c7b7f723eULL, 0x000fe200000010ffULL,
0x000000862e2e8231ULL, 0x000fe200003400ffULL, 0x0000006200aa7306ULL, 0x000ee20000005400ULL,
0x0000008f787b723eULL, 0x000fc400000010ffULL, 0x000000c1c000720bULL, 0x002fe20003f1d000ULL,
0x000000824438723cULL, 0x040fe20000041838ULL, 0x0000006f768f723eULL, 0x000fe400000010ffULL,
0x0000006b6a6f723eULL, 0x000fe200000010ffULL, 0x00000062005f7306ULL, 0x000328000000d400ULL,
0x0000007e4458723cULL, 0x000fe80000041858ULL, 0x0000006300a17306ULL, 0x000fe20000009400ULL,
0x000000bf8562723eULL, 0x002fc400000010ffULL, 0x000000b7b985723eULL, 0x000fe200000010ffULL,
0x0000007a443c723cULL, 0x000fe2000004183cULL, 0x000000015d5d0812ULL, 0x004fe400078efcffULL,
0x000000d8db00720bULL, 0x000fe20003f1d000ULL, 0x0000006300bb7306ULL, 0x000e620000005400ULL,
0x000000aaa900720bULL, 0x008fc60003f5d000ULL, 0x0000006c2c38723cULL, 0x000fe80000041838ULL,
0x0000006300607306ULL, 0x0005e8000000d400ULL, 0x000000010c0c0812ULL, 0x000fe400078efcffULL,
0x000000015f5f2812ULL, 0x010fc400078efcffULL, 0x0000005e005c7306ULL, 0x000ee2000020d400ULL,
0x000000be8463723eULL, 0x004fe400000010ffULL, 0x000000b6b884723eULL, 0x000fe400000010ffULL,
0x000000bba100720bULL, 0x002fc60003fbd000ULL, 0x000000623448723cULL, 0x000fe20000041848ULL,
0x000000c900a87306ULL, 0x000fec0000209400ULL, 0x000000abac34723eULL, 0x000fe200000010ffULL,
0x000000844440723cULL, 0x000fe20000041840ULL, 0x000000c9008a7306ULL, 0x000e620000205400ULL,
0x000000015c5c4812ULL, 0x008fc400078efcffULL, 0x000000a09d35723eULL, 0x000fe400000010ffULL,
0x0000000160605812ULL, 0x000fe400078efcffULL, 0x0000005c2467723eULL, 0x000fe200000010ffULL,
0x000000c700ba7306ULL, 0x000fe40000209400ULL, 0x000000344454723cULL, 0x040fec0000041854ULL,
0x000000c700877306ULL, 0x000ea20000205400ULL, 0x0000008aa800720bULL, 0x002fe20003f9d000ULL,
0x0000008e4448723cULL, 0x000fec0000041848ULL, 0x0000006100a57306ULL, 0x000fe20000009400ULL,
0x00000018ff467819ULL, 0x000fe20000011488ULL, 0x0000006e2c40723cULL, 0x000fe20000041840ULL,
0x0000005d8b88723eULL, 0x000fca00000010ffULL, 0x0000006100b07306ULL, 0x000e620000005400ULL,
0x00000087ba00720bULL, 0x004fe20003f7d000ULL, 0x000000682c54723cULL, 0x040fec0000041854ULL,
0x00000061005e7306ULL, 0x000ea4000000d400ULL, 0x000000662c58723cULL, 0x000fec0000041858ULL,
0x000000c900897306ULL, 0x000ee2000020d400ULL, 0x000000b0a500720bULL, 0x002fce0003fdd000ULL,
0x000000c700617306ULL, 0x000e6c000020d400ULL, 0x000000015e5e6812ULL, 0x004fe400078efcffULL,
0x000000c400947306ULL, 0x000fe20000209400ULL, 0x0000000189894812ULL, 0x008fe400078efcffULL,
0x000000d6d700720bULL, 0x000fc40003fdd000ULL, 0x0000005e8989723eULL, 0x000fc600000010ffULL,
0x000000c400927306ULL, 0x000ea20000205400ULL, 0x0000000161613812ULL, 0x002fc600078efcffULL,
0x000000882c50723cULL, 0x000fe80000041850ULL, 0x000000c300377306ULL, 0x000fe20000209400ULL,
0x0000000172726812ULL, 0x000fce00078efcffULL, 0x000000c300627306ULL, 0x000e620000205400ULL,
0x000000929400720bULL, 0x004fce0003f9d000ULL, 0x000000c400367306ULL, 0x000eb0000020d400ULL,
0x000000c300347306ULL, 0x000ee2000020d400ULL, 0x000000623700720bULL, 0x002fce0003f7d000ULL,
0x000000c200637306ULL, 0x000fe20000209400ULL, 0x0000000136364812ULL, 0x004fce00078efcffULL,
0x000000c200787306ULL, 0x000e620000205400ULL, 0x0000000134343812ULL, 0x008fc800078efcffULL,
0x0000005f3434723eULL, 0x000fc600000010ffULL, 0x0000009500357306ULL, 0x000ff00000209400ULL,
0x0000009500447306ULL, 0x000ea20000205400ULL, 0x000000786300720bULL, 0x002fce0003f9d000ULL,
0x0000004600457306ULL, 0x000ff00000209400ULL, 0x0000004600647306ULL, 0x000e620000205400ULL,
0x000000443500720bULL, 0x004fe40003f1d000ULL, 0x000000610044723eULL, 0x000fca00000010ffULL,
0x000000c200797306ULL, 0x000eb0000020d400ULL, 0x0000009500957306ULL, 0x000ee2000020d400ULL,
0x000000644500720bULL, 0x002fe40003f7d000ULL, 0x000000360c45723eULL, 0x000fca00000010ffULL,
0x0000004600737306ULL, 0x000e62000020d400ULL, 0x0000000179794812ULL, 0x004fe200078efcffULL,
0x000000442c3c723cULL, 0x000fe6000004183cULL, 0x000000607935723eULL, 0x000fe400000010ffULL,
0x0000000195950812ULL, 0x008fc800078efcffULL, 0x000000957272723eULL, 0x000fe200000010ffULL,
0x000000342c4c723cULL, 0x000fe2000004184cULL, 0x0000000173733812ULL, 0x002fc800078efcffULL,
0x000000730273723eULL, 0x000fce00000010ffULL, 0x000000722c48723cULL, 0x000fe20000041848ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040001ef7983ULL, 0x000ea20000100800ULL, 0x000000ff27ff7812ULL, 0x000fe4000784c0ffULL,
0x00000080052d7811ULL, 0x000fe200078e40ffULL, 0x01c62000ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000001ff247807ULL, 0x000fe40001000000ULL, 0x0000002d0400720cULL, 0x000fe40003f44070ULL,
0x000000010e007812ULL, 0x000fc8000782c0ffULL, 0x00000027240c7207ULL, 0x000fe40004800000ULL,
0x000000ffefff7812ULL, 0x004fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fe20004000000ULL,
0x000095b00000a947ULL, 0x000fea0003800000ULL, 0x01c65c00ff2d7984ULL, 0x000e620000000800ULL,
0x00000001ff027807ULL, 0x000fca0004000000ULL, 0x8000000002007824ULL, 0x000fca00078e00ffULL,
0x800000002dff7812ULL, 0x002fe20007824800ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01c65c00ff2d7984ULL, 0x000e640000000800ULL,
0x800000002dff7812ULL, 0x002fe40007824800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x80000000022d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc4000782482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000000002c7919ULL, 0x000e620000002700ULL, 0x00006400ff2e7624ULL, 0x000fe400078e00ffULL,
0x0000000126087824ULL, 0x000fe400078e0228ULL, 0x00000300ff007624ULL, 0x000fc600078e00ffULL,
0x0000000108027812ULL, 0x000fe400078ec0ffULL, 0xffffffff00007811ULL, 0x000fe400078e08ffULL,
0x000000010200780cULL, 0x000fc80003f25070ULL, 0x00000001002d7807ULL, 0x000fe20004800000ULL,
0x0000580009007a24ULL, 0x000fe400078e02ffULL, 0x000000022c2c7824ULL, 0x002fe400078e00ffULL,
0x0000001003347824ULL, 0x000fe400078e00ffULL, 0x000064002c2c7624ULL, 0x000fe400078e022eULL,
0x00000000002e7919ULL, 0x000e620000002600ULL, 0x0000000108087824ULL, 0x000fe200078e022dULL,
0x0000000105267810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff097424ULL, 0x000fc600078e00ffULL,
0x000000060800720cULL, 0x000fe20003f26070ULL, 0x000000802e2e7824ULL, 0x002fd800078e00ffULL,
0x00000001082c9824ULL, 0x000fe400078e022cULL, 0x0000008000027824ULL, 0x000fe400078e022eULL,
0x00000000002e7919ULL, 0x000e620000000000ULL, 0x00000004ff2d9424ULL, 0x000fe200078e00ffULL,
0x000000c0052f7811ULL, 0x000fe400078e40ffULL, 0x0000004002027810ULL, 0x000fe20007ffe0ffULL,
0x000060002c2c9625ULL, 0x000fe200078e002dULL, 0x00000004ff357819ULL, 0x002fc6000001162eULL,
0x00000100ff617424ULL, 0x000fe200078e00ffULL, 0x000000072600720cULL, 0x000fe20003f66070ULL,
0x000000062c099981ULL, 0x000362000c1e1900ULL, 0x0000002f04007217ULL, 0x000fe20007800000ULL,
0x0000000134347824ULL, 0x000fe200078e0235ULL, 0x0000007f0f2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000000357919ULL, 0x000ea20000000000ULL, 0x0000001003287824ULL, 0x000fe200078e00ffULL,
0x00000000190573c2ULL, 0x000ee200000e0000ULL, 0x0000007f34347812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fc400078e0a2fULL, 0x000000012e2e7824ULL, 0x100fe400078e0202ULL,
0x0000000134267824ULL, 0x100fe200078e0202ULL, 0x0000004000007807ULL, 0x000fe20001800000ULL,
0x00000001fcfc7824ULL, 0x000fe400078e0202ULL, 0x00005e00262c7625ULL, 0x002fe200078e0061ULL,
0x0000000028007217ULL, 0x000fc60007800000ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0061ULL,
0x00000001fa347824ULL, 0x100fe400078e0202ULL, 0x00000001fbfb7824ULL, 0x000fe400078e0202ULL,
0x0000001035607824ULL, 0x004fe200078e00ffULL, 0x00000004ff697819ULL, 0x000fe20000011635ULL,
0x0000000100007824ULL, 0x000fe200078e0a28ULL, 0x0001c64805057891ULL, 0x008fe2000f8e183fULL,
0x00005e0034347625ULL, 0x080fe200078e0061ULL, 0x000000f060607812ULL, 0x000fe400078ec0ffULL,
0x0000000469477810ULL, 0x000fe20007ffe0ffULL, 0x00000001f9f97824ULL, 0x100fe200078e0202ULL,
0x000000602c367210ULL, 0x080fe20007f3e0ffULL, 0x00000001f8f87824ULL, 0x100fe200078e0202ULL,
0x000000602e447210ULL, 0x000fe20007f5e0ffULL, 0x00000001f7027824ULL, 0x000fe200078e0202ULL,
0x000000004700720cULL, 0x080fe20003f66070ULL, 0x000000ffff377224ULL, 0x000fe200008e062dULL,
0x00000002695d7810ULL, 0x040fe20007ffe0ffULL, 0x00005e00fc2c7625ULL, 0x000fe200078e0061ULL,
0x000000006900720cULL, 0x000fc40003f86070ULL, 0x000000005d00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff457224ULL, 0x000fe200010e062fULL, 0x000000602c467210ULL, 0x080fe20007f3e0ffULL,
0x00005e00fb2e7625ULL, 0x080fe200078e0061ULL, 0x0000000869637810ULL, 0x040fe40007ffe0ffULL,
0x0000000a69657810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff477224ULL, 0x000fe200008e062dULL,
0x00000060345e7210ULL, 0x080fe20007f3e0ffULL, 0x00005e00f92c7625ULL, 0x000fe200078e0061ULL,
0x000000602e5c7210ULL, 0x000fc40007f5e0ffULL, 0x0000000c69677810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff5f7224ULL, 0x000fe200008e0635ULL, 0x000000602c2c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff5d7224ULL, 0x000fe200010e062fULL, 0x0000000e696b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e00f82e7625ULL, 0x000fc800078e0061ULL, 0x00005e0002347625ULL, 0x000fe200078e0061ULL,
0x0000000669617810ULL, 0x000fe40007ffe0ffULL, 0x000000602e2e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062dULL, 0x000000006100720cULL, 0x000fe20003f26070ULL,
0x0000001017617824ULL, 0x000fe200078e0225ULL, 0x0000006034347210ULL, 0x000fe20007fde0ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e062fULL, 0x000000006300720cULL, 0x080fe20003f46070ULL,
0x0000001018637824ULL, 0x100fe200078e0225ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036617faeULL, 0x0003e2000e101c46ULL, 0x000000006500720cULL, 0x000fe20003f86070ULL,
0x000000101a657824ULL, 0x000fc400078e0225ULL, 0x0000000044637faeULL, 0x0005e2000e901c46ULL,
0x000000006700720cULL, 0x080fe20003fa6070ULL, 0x000000101b677824ULL, 0x100fe400078e0225ULL,
0x0000000046657faeULL, 0x0007e2000d901c46ULL, 0x000000006b00720cULL, 0x000fe20003f66070ULL,
0x000000101c697824ULL, 0x100fe200078e0225ULL, 0x0000000823007812ULL, 0x000fe200078ec0ffULL,
0x000000101d377824ULL, 0x002fe200078e0225ULL, 0x000000005c677faeULL, 0x0007e2000c901c46ULL,
0x000000ffff357224ULL, 0x000fc400030e0635ULL, 0x000000101e457824ULL, 0x104fe200078e0225ULL,
0x000000005e697faeULL, 0x0007e2000d101c46ULL, 0x000000101f257824ULL, 0x000fc600078e0225ULL,
0x000000002c377faeULL, 0x0007e8000e101c46ULL, 0x000000002e457faeULL, 0x0007e8000e901c46ULL,
0x0000000034257faeULL, 0x0007e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c0000257984ULL, 0x0082a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c62c00ff027984ULL, 0x000ee20000000800ULL, 0x0000ffff0c0c7812ULL, 0x000fe200078ec0ffULL,
0x80000000202d7824ULL, 0x000fc600078e00ffULL, 0x000088800c007816ULL, 0x002fca00000000ffULL,
0x8000000000007824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x004fe40007824800ULL,
0x8000000002ff7812ULL, 0x008fe2000784482dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000020257824ULL, 0x000fe400078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01c62c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007844825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01c1000021257984ULL, 0x000e620000000800ULL, 0x00000001ff777424ULL, 0x000fc600078e00ffULL,
0x01c3000021007984ULL, 0x0004e20000000800ULL, 0x0000000a2500720bULL, 0x002fda0003f5d000ULL,
0x0000000000027806ULL, 0x000fc800010e0100ULL, 0x0000ffff020c7812ULL, 0x000fda000784c0ffULL,
0x000003700000a947ULL, 0x000fea0003800000ULL, 0x0000000a2500720bULL, 0x00cfe20003f54000ULL,
0x0000000000287919ULL, 0x000e620000000000ULL, 0x000000250a267209ULL, 0x000fca0007810000ULL,
0x800000260a027221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b020a7820ULL, 0x000fe40000410000ULL,
0x0000000000027806ULL, 0x000fe400010e0100ULL, 0x000000020300780cULL, 0x000fe40003f45270ULL,
0x0000ffff022d7812ULL, 0x000fe200078e3cffULL, 0x0000000a000a7308ULL, 0x000ea60000000800ULL,
0x0000002d0cff7212ULL, 0x000fc4000786c0ffULL, 0x00000002ff2f7819ULL, 0x102fe40000011628ULL,
0x00000002ff287819ULL, 0x000fc60000011628ULL, 0x01c500262100a388ULL, 0x000fe20000000800ULL,
0x00000001ff777807ULL, 0x000fe40001800000ULL, 0x0000000828287810ULL, 0x000fe20007ffe0ffULL,
0x00001f2f0a027589ULL, 0x004e6400000e0000ULL, 0x8000002625253221ULL, 0x000fe40000010000ULL,
0x0000000a0b0b7220ULL, 0x000fe20000410000ULL, 0x00001f280a0c7589ULL, 0x0004e200000e0000ULL,
0x3fb8aa3b25253820ULL, 0x000fc80000410000ULL, 0x00000025000d3308ULL, 0x000f220000000800ULL,
0x000000ffff0a7224ULL, 0x004fe400078e0026ULL, 0x0000000240407220ULL, 0x082fe40000410000ULL,
0x0000000241417220ULL, 0x080fe40000410000ULL, 0x0000000238387220ULL, 0x080fe40000410000ULL,
0x0000000239397220ULL, 0x080fe40000410000ULL, 0x0000000254547220ULL, 0x000fc40000410000ULL,
0x0000000255557220ULL, 0x080fe40000410000ULL, 0x0000000258587220ULL, 0x080fe40000410000ULL,
0x0000000259597220ULL, 0x080fe40000410000ULL, 0x0000000250507220ULL, 0x080fe40000410000ULL,
0x0000000251517220ULL, 0x080fe40000410000ULL, 0x000000023c3c7220ULL, 0x000fc40000410000ULL,
0x000000023d3d7220ULL, 0x080fe40000410000ULL, 0x000000024c4c7220ULL, 0x080fe40000410000ULL,
0x000000024d4d7220ULL, 0x080fe40000410000ULL, 0x0000000248487220ULL, 0x080fe40000410000ULL,
0x0000000249497220ULL, 0x000fe40000410000ULL, 0x0000000c42427220ULL, 0x008fc40000410000ULL,
0x0000000c43437220ULL, 0x080fe40000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe40000410000ULL, 0x0000000c56567220ULL, 0x080fe40000410000ULL,
0x0000000c57577220ULL, 0x080fe40000410000ULL, 0x0000000c5a5a7220ULL, 0x000fc40000410000ULL,
0x0000000c5b5b7220ULL, 0x080fe40000410000ULL, 0x0000000c52527220ULL, 0x080fe40000410000ULL,
0x0000000c53537220ULL, 0x080fe40000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000c4e4e7220ULL, 0x000fc40000410000ULL,
0x0000000c4f4f7220ULL, 0x080fe40000410000ULL, 0x0000000c4a4a7220ULL, 0x080fe40000410000ULL,
0x0000000c4b4b7220ULL, 0x000fe40000410000ULL, 0x000000000d003220ULL, 0x010fc80000410000ULL,
0x0000000b000b7221ULL, 0x00cfe20000010000ULL, 0x0000015000001947ULL, 0x000fea0003800000ULL,
0x0000000823257812ULL, 0x000fe400078ec0ffULL, 0x000000010eff7812ULL, 0x000fc8000782c0ffULL,
0x01c64c0025257984ULL, 0x000e620000000800ULL, 0x0000002724007207ULL, 0x000fc80004800000ULL,
0x0000ffff00007812ULL, 0x000fc800078ec0ffULL, 0x0000888000027816ULL, 0x000fca00000000ffULL,
0x8000000002007824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x002fe20007824800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000b000001947ULL, 0x000fea0003800000ULL,
0x000000010e007812ULL, 0x000fe200078ec0ffULL, 0x8000000002257824ULL, 0x000fe400078e00ffULL,
0x3e000000ff027424ULL, 0x000fe200078e00ffULL, 0x0001c648000c7811ULL, 0x000fc600078e18ffULL,
0x0000000200007305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000000000735dULL, 0x004fe40003800000ULL, 0x000004000c007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000010292c7824ULL, 0x100fe200078e0213ULL,
0x0000000000db7919ULL, 0x000e620000000000ULL, 0x000000102a347824ULL, 0x100fe400078e0213ULL,
0x000000102b447824ULL, 0x100fe400078e0213ULL, 0x000000002c2c783bULL, 0x000ea20000004200ULL,
0x00000010305c7824ULL, 0x100fe400078e0213ULL, 0x0000001033647824ULL, 0x100fe200078e0213ULL,
0x000000003434783bULL, 0x000fe20000004200ULL, 0x0000001070687824ULL, 0x000fc400078e0213ULL,
0x0000001031607824ULL, 0x100fe200078e0213ULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x00000010716c7824ULL, 0x000fc600078e0213ULL, 0x000000005c5c783bULL, 0x000ee80000004200ULL,
0x000000006464783bULL, 0x000f280000004200ULL, 0x000000006868783bULL, 0x000e680000004200ULL,
0x000000006060783bULL, 0x000e680000004200ULL, 0x000000006c6c783bULL, 0x000e620000004200ULL,
0x00000018ff027819ULL, 0x004fe2000001142dULL, 0x0000002c00c67306ULL, 0x000fe20000009400ULL,
0x00000018ff007819ULL, 0x000fc4000001142cULL, 0x00000018ff0c7819ULL, 0x000fe4000001142eULL,
0x00000018ff257819ULL, 0x000fc6000001142fULL, 0x0000000200b47306ULL, 0x000fe20000209400ULL,
0x00000018ff267819ULL, 0x008fe4000001145eULL, 0x00000018ff137819ULL, 0x010fca0000011467ULL,
0x0000000200ba7306ULL, 0x000fe20000205400ULL, 0x00000018ff2b7819ULL, 0x000fe40000011464ULL,
0x00000018ffac7819ULL, 0x002fe4000001146bULL, 0x00000018ff317819ULL, 0x000fe40000011468ULL,
0x00000018ff287819ULL, 0x000fe20000011460ULL, 0x0000000200917306ULL, 0x0003e2000020d400ULL,
0x00000018ff2a7819ULL, 0x000fe40000011463ULL, 0x00000018ffaf7819ULL, 0x000fc4000001146dULL,
0x00000018ffae7819ULL, 0x000fe4000001146cULL, 0x00000018ff297819ULL, 0x000fe20000011462ULL,
0x0000000000ca7306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x002fe40000011435ULL,
0x00000018ff337819ULL, 0x000fe40000011469ULL, 0x00000018ff307819ULL, 0x000fe40000011466ULL,
0x00000018ffb37819ULL, 0x000fe2000001146eULL, 0x0000000200987306ULL, 0x000fe20000209400ULL,
0x00000018ffb57819ULL, 0x000fce000001146fULL, 0x0000000200787306ULL, 0x000ff00000205400ULL,
0x0000000200aa7306ULL, 0x0003f0000020d400ULL, 0x0000000000cb7306ULL, 0x000ea20000205400ULL,
0x00000018ff027819ULL, 0x002fce0000011445ULL, 0x0000000000a17306ULL, 0x0002f0000020d400ULL,
0x00000002008f7306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x002fe40000011434ULL,
0x000000cbca00720bULL, 0x004fca0003fbd000ULL, 0x00000002008e7306ULL, 0x000ff00000205400ULL,
0x00000002008b7306ULL, 0x0003e2000020d400ULL, 0x00000001a1a15812ULL, 0x008fce00078efcffULL,
0x00000026007e7306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x002fce000001145dULL,
0x0000002600817306ULL, 0x000ff00000205400ULL, 0x0000002600747306ULL, 0x0003f0000020d400ULL,
0x0000000c00a57306ULL, 0x000fe20000209400ULL, 0x00000018ff267819ULL, 0x002fce0000011461ULL,
0x0000000c009e7306ULL, 0x000ff00000205400ULL, 0x0000000c00927306ULL, 0x0003f0000020d400ULL,
0x0000001300e07306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x002fce0000011436ULL,
0x00000013008a7306ULL, 0x000ff00000205400ULL, 0x0000001300717306ULL, 0x000ff0000020d400ULL,
0x00000000009d7306ULL, 0x000ff00000209400ULL, 0x00000000009c7306ULL, 0x000ff00000205400ULL,
0x0000000000b07306ULL, 0x0003f0000020d400ULL, 0x000000ac00f67306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x002fce0000011444ULL, 0x000000ac00f57306ULL, 0x000ff00000205400ULL,
0x000000ac00137306ULL, 0x0003f0000020d400ULL, 0x0000002c00a77306ULL, 0x000ea20000005400ULL,
0x000001002cac7824ULL, 0x002fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe400000114acULL,
0x0000002c00ad7306ULL, 0x0002f0000000d400ULL, 0x0000002500a27306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x002fe200078e00ffULL, 0x000000a7c600720bULL, 0x004fcc0003f3d000ULL,
0x0000002500a67306ULL, 0x000fee0000205400ULL, 0x00000001adad1812ULL, 0x008fe200078efcffULL,
0x0000002500c07306ULL, 0x0003e2000020d400ULL, 0x000000bab400720bULL, 0x000fe20003f3d000ULL,
0x0000010037ba7824ULL, 0x000fca00078e00ffULL, 0x00000018ffba7819ULL, 0x000fe200000114baULL,
0x0000000200807306ULL, 0x000fe20000209400ULL, 0x00000018ff257819ULL, 0x002fca0000011437ULL,
0x0000000191911812ULL, 0x000fe400078efcffULL, 0x0000000200827306ULL, 0x000ff00000205400ULL,
0x0000000200757306ULL, 0x000ff0000020d400ULL, 0x00000026007c7306ULL, 0x000ff00000209400ULL,
0x00000026009a7306ULL, 0x000ff00000205400ULL, 0x0000002600027306ULL, 0x000ff0000020d400ULL,
0x0000000c00bf7306ULL, 0x000ff00000209400ULL, 0x0000000c00937306ULL, 0x000ff00000205400ULL,
0x0000000c00ab7306ULL, 0x0003f0000020d400ULL, 0x0000002b00a07306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x002fce0000011446ULL, 0x0000002b009f7306ULL, 0x000ff00000205400ULL,
0x0000002b00267306ULL, 0x000ff0000020d400ULL, 0x0000000000967306ULL, 0x000ff00000209400ULL,
0x0000000000947306ULL, 0x000ff00000205400ULL, 0x0000000000907306ULL, 0x0003f0000020d400ULL,
0x0000003100eb7306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x002fce000001145cULL,
0x0000003100e67306ULL, 0x000ff00000205400ULL, 0x00000031002b7306ULL, 0x000ff0000020d400ULL,
0x0000002500b97306ULL, 0x000ff00000209400ULL, 0x0000002500be7306ULL, 0x000ff00000205400ULL,
0x0000002500a97306ULL, 0x0003f0000020d400ULL, 0x000000af00fc7306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x002fce0000011447ULL, 0x000000af00fb7306ULL, 0x000ff00000205400ULL,
0x000000af00317306ULL, 0x0003f0000020d400ULL, 0x0000002d00a87306ULL, 0x000fe20000009400ULL,
0x00000018ffaf7819ULL, 0x002fce000001142cULL, 0x0000002d00bc7306ULL, 0x000e700000005400ULL,
0x000000ae00707306ULL, 0x0005f0000020d400ULL, 0x0000000c008d7306ULL, 0x000fe20000209400ULL,
0x000001002dae7824ULL, 0x004fe200078e00ffULL, 0x000000bca800720bULL, 0x002fcc0003fdd000ULL,
0x0000000c008c7306ULL, 0x000ff00000205400ULL, 0x0000000c00797306ULL, 0x000ff0000020d400ULL,
0x0000002500857306ULL, 0x000ff00000209400ULL, 0x0000002500867306ULL, 0x000ff00000205400ULL,
0x00000025007a7306ULL, 0x0003f0000020d400ULL, 0x0000000000837306ULL, 0x000fe20000209400ULL,
0x00000018ff257819ULL, 0x002fce000001145fULL, 0x0000000000847306ULL, 0x000ff00000205400ULL,
0x0000000000767306ULL, 0x000ff0000020d400ULL, 0x00000028007f7306ULL, 0x000ff00000209400ULL,
0x00000028009b7306ULL, 0x000ff00000205400ULL, 0x00000028000c7306ULL, 0x000ff0000020d400ULL,
0x000000af002c7306ULL, 0x000ff00000209400ULL, 0x000000af00ce7306ULL, 0x000ff00000205400ULL,
0x000000af00b87306ULL, 0x0003f0000020d400ULL, 0x0000002900a37306ULL, 0x000fe20000209400ULL,
0x000001002faf7824ULL, 0x002fca00078e00ffULL, 0x00000018ffb67819ULL, 0x000fe400000114afULL,
0x0000002900a47306ULL, 0x000ff00000205400ULL, 0x0000002900007306ULL, 0x0003f0000020d400ULL,
0x0000002a00c37306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x002fce0000011465ULL,
0x0000002a00c47306ULL, 0x000ff00000205400ULL, 0x0000002a00287306ULL, 0x000ff0000020d400ULL,
0x000000ac00d07306ULL, 0x000ff00000209400ULL, 0x000000ac00d27306ULL, 0x000e700000205400ULL,
0x0000003000897306ULL, 0x000ff00000209400ULL, 0x0000003000957306ULL, 0x000fe20000205400ULL,
0x000000d2d000720bULL, 0x002fce0003f5d000ULL, 0x0000003000727306ULL, 0x0003f0000020d400ULL,
0x0000003300ef7306ULL, 0x000fe20000209400ULL, 0x00000018ff307819ULL, 0x002fce000001146aULL,
0x0000003300ed7306ULL, 0x000ff00000205400ULL, 0x00000033002a7306ULL, 0x000ff0000020d400ULL,
0x000000b300fa7306ULL, 0x000ff00000209400ULL, 0x000000b300f97306ULL, 0x000ff00000205400ULL,
0x000000b300337306ULL, 0x0003f0000020d400ULL, 0x000000ac00bd7306ULL, 0x0004e2000020d400ULL,
0x00000018ffb37819ULL, 0x002fce00000114aeULL, 0x00000025007b7306ULL, 0x000fe20000209400ULL,
0x000001002eac7824ULL, 0x004fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe400000114acULL,
0x00000025007d7306ULL, 0x000fe20000205400ULL, 0x00000001bdbd2812ULL, 0x008fe400078efcffULL,
0x000000ce2c00720bULL, 0x000fe20003f5d000ULL, 0x00010000342c7824ULL, 0x000fc800078e00ffULL,
0x0000002500737306ULL, 0x000ff0000020d400ULL, 0x0000002900877306ULL, 0x000fe20000209400ULL,
0x00000001b8b82812ULL, 0x000fce00078efcffULL, 0x0000002900887306ULL, 0x000ff00000205400ULL,
0x0000002900257306ULL, 0x000ff0000020d400ULL, 0x0000003000f47306ULL, 0x000ff00000209400ULL,
0x0000003000f37306ULL, 0x000ff00000205400ULL, 0x0000003000297306ULL, 0x000ff0000020d400ULL,
0x0000002d00997306ULL, 0x0002b0000000d400ULL, 0x000000b500f87306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x000000b500f77306ULL, 0x000fe20000205400ULL, 0x0000000199996812ULL, 0x004fce00078efcffULL,
0x000000b500307306ULL, 0x000ff0000020d400ULL, 0x000000b300d57306ULL, 0x000ff00000209400ULL,
0x000000b300d97306ULL, 0x000e700000205400ULL, 0x000000b300ae7306ULL, 0x000eb0000020d400ULL,
0x000000b600b37306ULL, 0x000fe20000209400ULL, 0x000000d9d500720bULL, 0x002fce0003f5d000ULL,
0x000000b600b57306ULL, 0x000e6c0000205400ULL, 0x00000001aeae2812ULL, 0x004fe400078efcffULL,
0x000000ac00cf7306ULL, 0x000ff00000209400ULL, 0x000000ac00d37306ULL, 0x000ea20000205400ULL,
0x000000b5b300720bULL, 0x002fce0003fdd000ULL, 0x000000ac00c97306ULL, 0x0003f0000020d400ULL,
0x000000b600bb7306ULL, 0x000722000020d400ULL, 0x000100002eac7824ULL, 0x002fe200078e00ffULL,
0x000000d3cf00720bULL, 0x004fc80003f5d000ULL, 0x00000018ffd77819ULL, 0x000fe400000114acULL,
0x0000002e00cc7306ULL, 0x000fe20000009400ULL, 0x000100002fb67824ULL, 0x008fca00078e00ffULL,
0x00000018ffd87819ULL, 0x000fe400000114b6ULL, 0x000000d700ac7306ULL, 0x000fe20000209400ULL,
0x00000001bbbb6812ULL, 0x010fe400078efcffULL, 0x00000001c9c92812ULL, 0x000fe400078efcffULL,
0x0000009ea500720bULL, 0x000fe20003f5d000ULL, 0x00010000369e7824ULL, 0x000fe400078e00ffULL,
0x000000d700af7306ULL, 0x000e660000205400ULL, 0x00000018ff9e7819ULL, 0x000fca000001149eULL,
0x0000002e00d17306ULL, 0x000ea40000005400ULL, 0x0000000192922812ULL, 0x000fcc00078efcffULL,
0x0000002e00c57306ULL, 0x000722000000d400ULL, 0x000000afac00720bULL, 0x002fce0003fdd000ULL,
0x000000d700c87306ULL, 0x000e62000020d400ULL, 0x00000100342e7824ULL, 0x008fe200078e00ffULL,
0x000000d1cc00720bULL, 0x004fc80003f9d000ULL, 0x00000018ffda7819ULL, 0x000fe2000001142eULL,
0x00000100352e7824ULL, 0x000fe200078e00ffULL, 0x0000002d00d47306ULL, 0x000fe80000209400ULL,
0x00000018ffd27819ULL, 0x000fc6000001142eULL, 0x00000001c5c54812ULL, 0x010fe200078efcffULL,
0x000000da00a77306ULL, 0x000fe20000209400ULL, 0x00000001c8c86812ULL, 0x002fe400078efcffULL,
0x000000a6a200720bULL, 0x000fca0003f9d000ULL, 0x000000da00a87306ULL, 0x000e700000205400ULL,
0x0000002d00d67306ULL, 0x000ea20000205400ULL, 0x00000001c0c04812ULL, 0x000fe400078efcffULL,
0x0000009c9d00720bULL, 0x000fca0003f9d000ULL, 0x0000002d00c17306ULL, 0x000ee2000020d400ULL,
0x000000a8a700720bULL, 0x002fce0003fdd000ULL, 0x0000002f002d7306ULL, 0x000fe20000009400ULL,
0x000000d6d400720bULL, 0x004fe40003fbd000ULL, 0x00000001b0b04812ULL, 0x000fca00078efcffULL,
0x0000002f00cd7306ULL, 0x000e6c0000005400ULL, 0x00000001c1c15812ULL, 0x008fe400078efcffULL,
0x0000002f00c27306ULL, 0x000eb0000000d400ULL, 0x000000da00d07306ULL, 0x000722000020d400ULL,
0x000000cd2d00720bULL, 0x002fce0003f7d000ULL, 0x000000d2002e7306ULL, 0x000fe20000209400ULL,
0x00000018ffda7819ULL, 0x008fca000001142cULL, 0x00000001c2c23812ULL, 0x004fe400078efcffULL,
0x000000d2002f7306ULL, 0x000e620000205400ULL, 0x00000001d0d06812ULL, 0x010fce00078efcffULL,
0x000000d200c67306ULL, 0x000eb0000020d400ULL, 0x0000003400bc7306ULL, 0x000fe20000009400ULL,
0x0000002f2e00720bULL, 0x002fe20003fdd000ULL, 0x00000100442e7824ULL, 0x000fcc00078e00ffULL,
0x0000003400cc7306ULL, 0x000e6c0000005400ULL, 0x00000001c6c66812ULL, 0x004fe400078efcffULL,
0x0000003400d17306ULL, 0x0004f0000000d400ULL, 0x0000003500cd7306ULL, 0x000fe20000009400ULL,
0x0001000035347824ULL, 0x004fe200078e00ffULL, 0x000000ccbc00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500ce7306ULL, 0x000e6e0000005400ULL,
0x00000001d1d15812ULL, 0x008fe200078efcffULL, 0x0000003500d27306ULL, 0x0004e2000000d400ULL,
0x000000789800720bULL, 0x000fc40003fbd000ULL, 0x00000002ff787819ULL, 0x100fe400000116dbULL,
0x00000002ffdb7819ULL, 0x000fc600000116dbULL, 0x000000da002c7306ULL, 0x000fe20000209400ULL,
0x0000010036357824ULL, 0x004fe200078e00ffULL, 0x000000cecd00720bULL, 0x002fe40003f3d000ULL,
0x00000008dbdb7810ULL, 0x000fe40007ffe0ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x000000da002d7306ULL, 0x000e620000205400ULL, 0x00000001aaaa5812ULL, 0x000fe400078efcffULL,
0x00000093bf00720bULL, 0x000fc80003fbd000ULL, 0x00000001d2d21812ULL, 0x008fe200078efcffULL,
0x000000d800b67306ULL, 0x000ff00000209400ULL, 0x000000d800b77306ULL, 0x000ea20000205400ULL,
0x0000002d2c00720bULL, 0x002fe20003fdd000ULL, 0x00010000442c7824ULL, 0x000fe200078e00ffULL,
0x00000001abab5812ULL, 0x000fca00078efcffULL, 0x000000d800c77306ULL, 0x000e70000020d400ULL,
0x0000003400d77306ULL, 0x000fe20000209400ULL, 0x000000b7b600720bULL, 0x004fce0003f7d000ULL,
0x0000003400d87306ULL, 0x000fec0000205400ULL, 0x00000001c7c73812ULL, 0x002fe400078efcffULL,
0x0000003400ca7306ULL, 0x000ff0000020d400ULL, 0x0000003500d57306ULL, 0x000ff00000209400ULL,
0x0000003500d67306ULL, 0x000e700000205400ULL, 0x0000003500b47306ULL, 0x000eb0000020d400ULL,
0x0000003600347306ULL, 0x000fe20000009400ULL, 0x000000d6d500720bULL, 0x002fce0003f9d000ULL,
0x0000003600357306ULL, 0x000e6c0000005400ULL, 0x00000001b4b44812ULL, 0x004fe400078efcffULL,
0x0000003600b57306ULL, 0x0004e2000000d400ULL, 0x000000beb900720bULL, 0x000fe40003f9d000ULL,
0x000000353400720bULL, 0x002fca0003f5d000ULL, 0x0000003700a27306ULL, 0x000fe20000009400ULL,
0x00000018ff357819ULL, 0x000fe2000001142cULL, 0x0001000037367824ULL, 0x004fe200078e00ffULL,
0x00013000322c7811ULL, 0x000fe400078e20ffULL, 0x00000018ff347819ULL, 0x000fe4000001142eULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003700a57306ULL, 0x000e620000005400ULL,
0x000000002c2c783bULL, 0x000fe20000000200ULL, 0x00000001a9a94812ULL, 0x000fc400078efcffULL,
0x00000001b5b52812ULL, 0x008fc800078efcffULL, 0x0000003600ce7306ULL, 0x000ff00000209400ULL,
0x0000003600cf7306ULL, 0x000fe20000205400ULL, 0x000000a5a200720bULL, 0x002fce0003f7d000ULL,
0x0000003600ac7306ULL, 0x0003f0000020d400ULL, 0x0000009e00cc7306ULL, 0x000fe20000209400ULL,
0x0000000dff36723eULL, 0x002fc800000010ffULL, 0x0000541036367816ULL, 0x000fc60000000036ULL,
0x0000009e00cd7306ULL, 0x000e640000205400ULL, 0x00001f7836787589ULL, 0x000eac00000e0000ULL,
0x0000009e00af7306ULL, 0x000ef0000020d400ULL, 0x0000004400a57306ULL, 0x000fe20000009400ULL,
0x000000cdcc00720bULL, 0x002fce0003f5d000ULL, 0x0000004400a67306ULL, 0x000e6c0000005400ULL,
0x00000001afaf2812ULL, 0x008fe400078efcffULL, 0x0000004400bc7306ULL, 0x000ef0000000d400ULL,
0x00000034009e7306ULL, 0x000fe20000209400ULL, 0x000000a6a500720bULL, 0x002fce0003f9d000ULL,
0x0000003400a27306ULL, 0x000fec0000205400ULL, 0x00000001bcbc4812ULL, 0x008fe400078efcffULL,
0x0000003400447306ULL, 0x0003e2000020d400ULL, 0x000000949600720bULL, 0x000fce0003f9d000ULL,
0x000000da00cb7306ULL, 0x000ee2000020d400ULL, 0x0000991077347816ULL, 0x002fe400000000ffULL,
0x00001fdb36777589ULL, 0x000e6400000e0000ULL, 0x000000ff3400720cULL, 0x000fe20003f25270ULL,
0x0000010045347824ULL, 0x000fe200078e00ffULL, 0x0000000190904812ULL, 0x000fe200078efcffULL,
0x00000035009c7306ULL, 0x000fe20000209400ULL, 0x0000008e8f00720bULL, 0x000fe40003f9d000ULL,
0x00000018ffd97819ULL, 0x000fc40000011434ULL, 0x000000adbd34723eULL, 0x000fe200000010ffULL,
0x0001000045bd7824ULL, 0x000fe400078e00ffULL, 0x00000035009d7306ULL, 0x000fe20000205400ULL,
0x00000001cbcb6812ULL, 0x008fe200078efcffULL, 0x000000782c2c9231ULL, 0x084fe200003400ffULL,
0x000000d8d700720bULL, 0x000fe20003fdd000ULL, 0x000000782e2e9231ULL, 0x000fe200003400ffULL,
0x00000018ffbd7819ULL, 0x000fe400000114bdULL, 0x000000018b8b4812ULL, 0x000fe200078efcffULL,
0x0000003500b67306ULL, 0x0005e2000020d400ULL, 0x000000772d2d9231ULL, 0x002fc400003400ffULL,
0x000000772f2f9231ULL, 0x000fca00003400ffULL, 0x0000003700b77306ULL, 0x000e62000000d400ULL,
0x00000099ae35723eULL, 0x004fe400000010ffULL, 0x00000001caca6812ULL, 0x000fca00078efcffULL,
0x000000342c40723cULL, 0x000fe20000041840ULL, 0x000000ba00d37306ULL, 0x000fec0000209400ULL,
0x0000010046347824ULL, 0x000fe200078e00ffULL, 0x000000c19135723eULL, 0x000fe200000010ffULL,
0x000000ba00d47306ULL, 0x000ea20000205400ULL, 0x00000001b7b73812ULL, 0x002fc400078efcffULL,
0x00000018ffd77819ULL, 0x000fe40000011434ULL, 0x000000b8a134723eULL, 0x000fe200000010ffULL,
0x0000010047b87824ULL, 0x000fe200078e00ffULL, 0x000000a29e00720bULL, 0x000fe20003f7d000ULL,
0x000000ba00b37306ULL, 0x000e66000020d400ULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x000000342c38723cULL, 0x000fe20000041838ULL, 0x000000d4d300720bULL, 0x004fc60003fdd000ULL,
0x0000004500a77306ULL, 0x000fe60000009400ULL, 0x000000c5c934723eULL, 0x000fe400000010ffULL,
0x000000c2bb35723eULL, 0x000fe400000010ffULL, 0x0000000144443812ULL, 0x000fe200078efcffULL,
0x0000004500a87306ULL, 0x000ea20000005400ULL, 0x0000009d9c00720bULL, 0x000fc60003f7d000ULL,
0x000000342c54723cULL, 0x000fe20000041854ULL, 0x00000001b3b36812ULL, 0x002fe400078efcffULL,
0x000000cfce00720bULL, 0x000fe20003fdd000ULL, 0x000000d900987306ULL, 0x000fe20000209400ULL,
0x000000bc4444723eULL, 0x000fe400000010ffULL, 0x000000c89234723eULL, 0x000fe200000010ffULL,
0x0001000046927824ULL, 0x000fe200078e00ffULL, 0x000000c7c035723eULL, 0x000fe400000010ffULL,
0x00000001b6b63812ULL, 0x000fe200078efcffULL, 0x000000d900377306ULL, 0x000e620000205400ULL,
0x000000a8a700720bULL, 0x004fc60003f5d000ULL, 0x00000001acac6812ULL, 0x000fe200078efcffULL,
0x000000342c58723cULL, 0x000fe20000041858ULL, 0x00000018ffd37819ULL, 0x000fe40000011492ULL,
0x0000004600c57306ULL, 0x000fe80000009400ULL, 0x0001000047347824ULL, 0x000fe200078e00ffULL,
0x000000d2c635723eULL, 0x000fc600000010ffULL, 0x0000004600c27306ULL, 0x000ea20000005400ULL,
0x00000018ffd47819ULL, 0x000fe40000011434ULL, 0x000000d1d034723eULL, 0x000fe400000010ffULL,
0x000000379800720bULL, 0x002fe20003f7d000ULL, 0x0001000061377824ULL, 0x000fe400078e00ffULL,
0x0000004500ba7306ULL, 0x000e64000000d400ULL, 0x000000342c50723cULL, 0x000fe20000041850ULL,
0x00000018ff967819ULL, 0x000fca0000011437ULL, 0x000000d700ad7306ULL, 0x000fe20000209400ULL,
0x000000cbb034723eULL, 0x000fe200000010ffULL, 0x000001005cb07824ULL, 0x000fe200078e00ffULL,
0x000000caaa35723eULL, 0x000fe400000010ffULL, 0x000000c2c500720bULL, 0x004fe40003fdd000ULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x000000d700ae7306ULL, 0x000ea20000205400ULL,
0x00000001baba2812ULL, 0x002fe200078efcffULL, 0x000000342c3c723cULL, 0x000fec000004183cULL,
0x000000d900457306ULL, 0x000e62000020d400ULL, 0x000000b5b434723eULL, 0x000fc400000010ffULL,
0x000000b7b335723eULL, 0x000fca00000010ffULL, 0x000000bd00997306ULL, 0x000fe20000209400ULL,
0x000000aead00720bULL, 0x004fe20003f5d000ULL, 0x000000342c4c723cULL, 0x000fec000004184cULL,
0x000000bd00367306ULL, 0x000ea20000205400ULL, 0x0000000145453812ULL, 0x002fe400078efcffULL,
0x000000afab34723eULL, 0x000fe200000010ffULL, 0x000001005dab7824ULL, 0x000fe200078e00ffULL,
0x000000aca935723eULL, 0x000fc400000010ffULL, 0x000000ba4545723eULL, 0x000fe200000010ffULL,
0x0000004600bb7306ULL, 0x000e62000000d400ULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x000100006dba7824ULL, 0x000fe400078e00ffULL, 0x000000342c2c723cULL, 0x000fe60000041848ULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x000000d700917306ULL, 0x000ee2000020d400ULL,
0x000000369900720bULL, 0x004fe20003f7d000ULL, 0x0000010062367824ULL, 0x000fc400078e00ffULL,
0x000001005e357824ULL, 0x000fe400078e00ffULL, 0x000100005d347824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe20000011436ULL, 0x000000b800a17306ULL, 0x000fe20000209400ULL,
0x00000001bbbb6812ULL, 0x002fe200078efcffULL, 0x000001005f487824ULL, 0x000fe200078e00ffULL,
0x0000008c8d00720bULL, 0x000fe20003fdd000ULL, 0x00010000628c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000010063367824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x000000b800c17306ULL, 0x000e620000205400ULL,
0x0000000191912812ULL, 0x008fc400078efcffULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x00000018ff8f7819ULL, 0x000fc60000011436ULL, 0x000000bd00bd7306ULL, 0x000ea2000020d400ULL,
0x0000000179796812ULL, 0x000fce00078efcffULL, 0x0000005c00cb7306ULL, 0x000fe20000009400ULL,
0x000000c1a100720bULL, 0x002fce0003f5d000ULL, 0x0000005c00ca7306ULL, 0x000e620000005400ULL,
0x00000001bdbd3812ULL, 0x004fce00078efcffULL, 0x000000b000cc7306ULL, 0x000ff00000209400ULL,
0x000000b000d07306ULL, 0x000ea20000205400ULL, 0x000000cacb00720bULL, 0x002fce0003f7d000ULL,
0x000000b800b87306ULL, 0x000e70000020d400ULL, 0x000000d300467306ULL, 0x000fe20000209400ULL,
0x000000d0cc00720bULL, 0x004fce0003fdd000ULL, 0x000000d300c77306ULL, 0x000ea20000205400ULL,
0x00000001b8b82812ULL, 0x002fce00078efcffULL, 0x0000005c00aa7306ULL, 0x0002f0000000d400ULL,
0x000000b000b97306ULL, 0x000f22000020d400ULL, 0x000100005c5c7824ULL, 0x002fe200078e00ffULL,
0x000000c74600720bULL, 0x004fe20003f5d000ULL, 0x0001000063467824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x000000ab00cf7306ULL, 0x000fe20000209400ULL,
0x00000001aaaa3812ULL, 0x008fe400078efcffULL, 0x000000848300720bULL, 0x000fca0003f7d000ULL,
0x000000ab00d67306ULL, 0x000e620000205400ULL, 0x00000001b9b96812ULL, 0x010fce00078efcffULL,
0x0000004700c97306ULL, 0x000fe20000009400ULL, 0x0000000176763812ULL, 0x000fce00078efcffULL,
0x0000004700c87306ULL, 0x000ea20000005400ULL, 0x000000d6cf00720bULL, 0x002fce0003fdd000ULL,
0x0000004700c07306ULL, 0x000e70000000d400ULL, 0x000000d300927306ULL, 0x000ee2000020d400ULL,
0x000000c8c900720bULL, 0x004fce0003fbd000ULL, 0x000000d400477306ULL, 0x000fec0000209400ULL,
0x00000001c0c05812ULL, 0x002fe400078efcffULL, 0x000000d400c67306ULL, 0x000e620000205400ULL,
0x0000000192922812ULL, 0x008fe400078efcffULL, 0x000000868500720bULL, 0x000fe20003fbd000ULL,
0x0000010065867824ULL, 0x000fe200078e00ffULL, 0x000000927992723eULL, 0x000fe200000010ffULL,
0x000100006f797824ULL, 0x000fc400078e00ffULL, 0x0000005d00ce7306ULL, 0x000fe60000009400ULL,
0x00000018ff797819ULL, 0x000fca0000011479ULL, 0x0000005d00cd7306ULL, 0x000ea20000005400ULL,
0x000000c64700720bULL, 0x002fe20003f5d000ULL, 0x0000010064477824ULL, 0x000fe200078e00ffULL,
0x000000017a7a5812ULL, 0x000fc800078efcffULL, 0x00000018ff857819ULL, 0x000fe20000011447ULL,
0x0000005d00ac7306ULL, 0x000e70000000d400ULL, 0x0000003500d17306ULL, 0x000fe20000209400ULL,
0x000000cdce00720bULL, 0x004fce0003f9d000ULL, 0x00000035005d7306ULL, 0x000eac0000205400ULL,
0x00000001acac4812ULL, 0x002fe400078efcffULL, 0x000000ab00be7306ULL, 0x000e62000020d400ULL,
0x000000828000720bULL, 0x000fce0003f9d000ULL, 0x0000005c00d57306ULL, 0x000fe20000209400ULL,
0x0000005dd100720bULL, 0x004fe20003f7d000ULL, 0x00000100675d7824ULL, 0x000fc800078e00ffULL,
0x0000000175754812ULL, 0x000fe400078efcffULL, 0x0000005c00d27306ULL, 0x000ea20000205400ULL,
0x00000001bebe6812ULL, 0x002fce00078efcffULL, 0x0000005c00bf7306ULL, 0x0003f0000020d400ULL,
0x000000d400937306ULL, 0x000ee2000020d400ULL, 0x00000018ff5c7819ULL, 0x002fe40000011448ULL,
0x000000d2d500720bULL, 0x004fca0003fdd000ULL, 0x0000005e00d97306ULL, 0x000ff00000009400ULL,
0x0000005e00da7306ULL, 0x000e620000005400ULL, 0x0000000193932812ULL, 0x008fe400078efcffULL,
0x00000001bfbf6812ULL, 0x000fc400078efcffULL, 0x000000937a93723eULL, 0x000fc600000010ffULL,
0x0000003500b07306ULL, 0x000eb0000020d400ULL, 0x0000005c004a7306ULL, 0x000fe20000209400ULL,
0x000000dad900720bULL, 0x002fce0003f5d000ULL, 0x0000005c00497306ULL, 0x000e620000205400ULL,
0x00000001b0b03812ULL, 0x004fce00078efcffULL, 0x0000003400d37306ULL, 0x000ff00000209400ULL,
0x0000003400d47306ULL, 0x000ea20000205400ULL, 0x000000494a00720bULL, 0x002fe20003f7d000ULL,
0x0001000066497824ULL, 0x000fcc00078e00ffULL, 0x0000003400b77306ULL, 0x0003f0000020d400ULL,
0x0000005e00b37306ULL, 0x000722000000d400ULL, 0x000100005e347824ULL, 0x002fe200078e00ffULL,
0x000000d4d300720bULL, 0x004fc80003fdd000ULL, 0x00000018ff4b7819ULL, 0x000fe20000011434ULL,
0x000100005f347824ULL, 0x000fe200078e00ffULL, 0x0000005f00d77306ULL, 0x000fe20000009400ULL,
0x00000100605e7824ULL, 0x008fc600078e00ffULL, 0x00000018ffa97819ULL, 0x000fe40000011434ULL,
0x00000018ffa67819ULL, 0x000fe4000001145eULL, 0x0000005f00d87306ULL, 0x000e620000005400ULL,
0x00000001b3b32812ULL, 0x010fe400078efcffULL, 0x000000817e00720bULL, 0x000fe40003f5d000ULL,
0x00000001b7b76812ULL, 0x000fc600078efcffULL, 0x0000005c00af7306ULL, 0x000eb0000020d400ULL,
0x0000004b00487306ULL, 0x000fe20000209400ULL, 0x000000d8d700720bULL, 0x002fe40003fbd000ULL,
0x0000000174742812ULL, 0x000fca00078efcffULL, 0x0000004b00357306ULL, 0x000e620000205400ULL,
0x00000001afaf3812ULL, 0x004fce00078efcffULL, 0x0000006000db7306ULL, 0x000ff00000009400ULL,
0x0000006000c27306ULL, 0x000ea20000005400ULL, 0x000000354800720bULL, 0x002fe20003f7d000ULL,
0x0001000067357824ULL, 0x000fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000005f00b47306ULL, 0x000e70000000d400ULL, 0x000000a6005f7306ULL, 0x000fe20000209400ULL,
0x000000c2db00720bULL, 0x004fce0003fdd000ULL, 0x000000a600a27306ULL, 0x000ea20000205400ULL,
0x00000001b4b45812ULL, 0x002fe400078efcffULL, 0x0000007d7b00720bULL, 0x000fca0003fbd000ULL,
0x0000004b00b57306ULL, 0x0002f0000020d400ULL, 0x000000a900347306ULL, 0x000fe20000209400ULL,
0x00010000604b7824ULL, 0x002fe200078e00ffULL, 0x000000a25f00720bULL, 0x004fc40003f5d000ULL,
0x0000000173735812ULL, 0x000fe400078efcffULL, 0x00000018ff9e7819ULL, 0x000fe4000001144bULL,
0x000000a9005c7306ULL, 0x000e620000205400ULL, 0x00000001b5b53812ULL, 0x008fe400078efcffULL,
0x0000009b7f00720bULL, 0x000fe40003fbd000ULL, 0x000000b57474723eULL, 0x000fc600000010ffULL,
0x0000006000a87306ULL, 0x0004f0000000d400ULL, 0x000000a900ab7306ULL, 0x000f22000020d400ULL,
0x0000010061607824ULL, 0x004fe200078e00ffULL, 0x0000005c3400720bULL, 0x002fe20003f7d000ULL,
0x0000010068347824ULL, 0x000fe200078e00ffULL, 0x000000010c0c5812ULL, 0x000fe200078efcffULL,
0x00000100695c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fc40000011460ULL,
0x000000a600a97306ULL, 0x000e62000020d400ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000001a8a86812ULL, 0x008fe400078efcffULL, 0x0000009a7c00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff5f7819ULL, 0x000fe2000001145cULL, 0x0000009e004b7306ULL, 0x000fe20000209400ULL,
0x00000001abab3812ULL, 0x010fce00078efcffULL, 0x0000009e005e7306ULL, 0x000ea20000205400ULL,
0x00000001a9a92812ULL, 0x002fe400078efcffULL, 0x0000000102026812ULL, 0x000fca00078efcffULL,
0x0000006200ae7306ULL, 0x000ff00000009400ULL, 0x0000006200de7306ULL, 0x000e620000005400ULL,
0x0000005e4b00720bULL, 0x004fce0003f5d000ULL, 0x00000062009d7306ULL, 0x0004f0000000d400ULL,
0x0000006100dc7306ULL, 0x000fe20000009400ULL, 0x00000018ff627819ULL, 0x004fe40000011446ULL,
0x000000deae00720bULL, 0x002fca0003f7d000ULL, 0x0000006100dd7306ULL, 0x000e700000005400ULL,
0x0000009400607306ULL, 0x000fe20000209400ULL, 0x000000019d9d3812ULL, 0x008fe400078efcffULL,
0x000000a4a300720bULL, 0x000fca0003f7d000ULL, 0x0000009400c57306ULL, 0x000fe20000205400ULL,
0x000000dddc00720bULL, 0x002fce0003f9d000ULL, 0x0000009400a77306ULL, 0x000fe2000020d400ULL,
0x0000000100003812ULL, 0x000fce00078efcffULL, 0x0000006300cb7306ULL, 0x000ff00000009400ULL,
0x0000006300ce7306ULL, 0x000ff00000005400ULL, 0x0000006300987306ULL, 0x000ff0000000d400ULL,
0x0000008e00c87306ULL, 0x000ff00000209400ULL, 0x0000008e00c97306ULL, 0x000ff00000205400ULL,
0x0000008e009c7306ULL, 0x000ff0000020d400ULL, 0x0000006200467306ULL, 0x000ff00000209400ULL,
0x0000006200637306ULL, 0x000ff00000205400ULL, 0x0000006200947306ULL, 0x0003f0000020d400ULL,
0x0000008c00cd7306ULL, 0x000fe20000209400ULL, 0x0001000064627824ULL, 0x002fca00078e00ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000008c00c77306ULL, 0x000e700000205400ULL,
0x0000006400d97306ULL, 0x000ff00000009400ULL, 0x0000006400da7306ULL, 0x000fe20000005400ULL,
0x000000c7cd00720bULL, 0x002fce0003fdd000ULL, 0x00000064008e7306ULL, 0x0003f0000000d400ULL,
0x0000006100a67306ULL, 0x000ea2000000d400ULL, 0x0001000065647824ULL, 0x002fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000009e00a57306ULL, 0x000e70000020d400ULL,
0x0000009600377306ULL, 0x000fe20000209400ULL, 0x00000001a6a64812ULL, 0x004fce00078efcffULL,
0x0000009600617306ULL, 0x000ea20000205400ULL, 0x00000001a5a52812ULL, 0x002fe400078efcffULL,
0x000000c56000720bULL, 0x000fca0003f5d000ULL, 0x0000003400c17306ULL, 0x000ff00000209400ULL,
0x0000003400c27306ULL, 0x000fe20000205400ULL, 0x000000613700720bULL, 0x004fe20003fbd000ULL,
0x000001006a377824ULL, 0x000fe200078e00ffULL, 0x00000001a7a72812ULL, 0x000fc400078efcffULL,
0x000000c9c800720bULL, 0x000fe40003f5d000ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x00000034007e7306ULL, 0x0003f0000020d400ULL, 0x0000008c00997306ULL, 0x0004e2000020d400ULL,
0x0001000068347824ULL, 0x002fe200078e00ffULL, 0x000000019c9c2812ULL, 0x000fc400078efcffULL,
0x000000dad900720bULL, 0x000fe40003f5d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000006400d27306ULL, 0x000fe20000209400ULL, 0x00000018ff8c7819ULL, 0x004fe40000011486ULL,
0x0000009d9c9c723eULL, 0x000fca00000010ffULL, 0x0000006400d57306ULL, 0x000fe20000205400ULL,
0x0000000199996812ULL, 0x008fe400078efcffULL, 0x000000018e8e2812ULL, 0x000fca00078efcffULL,
0x0000006400837306ULL, 0x0003f0000020d400ULL, 0x0000006200d87306ULL, 0x000fe20000209400ULL,
0x00000018ff647819ULL, 0x002fce000001146cULL, 0x0000006200df7306ULL, 0x000ff00000205400ULL,
0x00000062008d7306ULL, 0x0003f0000020d400ULL, 0x00000035004a7306ULL, 0x000fe20000209400ULL,
0x00000018ff627819ULL, 0x002fce000001145dULL, 0x0000003500cf7306ULL, 0x000ff00000205400ULL,
0x00000035007d7306ULL, 0x0003f0000020d400ULL, 0x00000069004b7306ULL, 0x000fe20000009400ULL,
0x0001000069357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000006900ea7306ULL, 0x000ff00000005400ULL, 0x00000069007c7306ULL, 0x000ff0000000d400ULL,
0x0000008500c67306ULL, 0x000ff00000209400ULL, 0x0000008500477306ULL, 0x000e700000205400ULL,
0x0000003400dc7306ULL, 0x000ff00000209400ULL, 0x0000003400db7306ULL, 0x000fe20000205400ULL,
0x00000047c600720bULL, 0x002fce0003fdd000ULL, 0x0000003400697306ULL, 0x0003f0000020d400ULL,
0x00000096009e7306ULL, 0x000ea2000020d400ULL, 0x000001006b347824ULL, 0x002fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000008c00cc7306ULL, 0x000ff00000209400ULL,
0x0000008c00d07306ULL, 0x000e620000205400ULL, 0x000000019e9e5812ULL, 0x004fc400078efcffULL,
0x000000cecb00720bULL, 0x000fca0003fbd000ULL, 0x0000008c00867306ULL, 0x000eb0000020d400ULL,
0x0000006500d67306ULL, 0x000fe20000009400ULL, 0x000000d0cc00720bULL, 0x002fe40003f7d000ULL,
0x0000000198985812ULL, 0x000fc400078efcffULL, 0x000000634600720bULL, 0x000fe20003fbd000ULL,
0x000001006c467824ULL, 0x000fe400078e00ffULL, 0x0000006500d77306ULL, 0x000e660000005400ULL,
0x00000018ff467819ULL, 0x000fc60000011446ULL, 0x0000000186863812ULL, 0x004fe400078efcffULL,
0x00000065008c7306ULL, 0x0004e4000000d400ULL, 0x0000000194945812ULL, 0x000fcc00078efcffULL,
0x00000062005d7306ULL, 0x000fe20000209400ULL, 0x0000010066657824ULL, 0x004fe200078e00ffULL,
0x000000d7d600720bULL, 0x002fc80003fbd000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x0000006200d17306ULL, 0x000fee0000205400ULL, 0x000000018c8c5812ULL, 0x008fe200078efcffULL,
0x0000006200807306ULL, 0x0003e2000020d400ULL, 0x000000888700720bULL, 0x000fce0003fbd000ULL,
0x0000006400647306ULL, 0x000ea20000205400ULL, 0x00000018ff627819ULL, 0x002fca0000011449ULL,
0x0000000125255812ULL, 0x000fe400078efcffULL, 0x0000008f00367306ULL, 0x000fe20000209400ULL,
0x000000ea4b00720bULL, 0x000fce0003fbd000ULL, 0x0000008f00ca7306ULL, 0x000e620000205400ULL,
0x000000ffffcb7224ULL, 0x004fca00078e0064ULL, 0x000000017c7c5812ULL, 0x000fe400078efcffULL,
0x0000006200497306ULL, 0x000fe20000209400ULL, 0x000000edef00720bULL, 0x000fce0003fbd000ULL,
0x0000006200487306ULL, 0x000fe20000205400ULL, 0x000000ca3600720bULL, 0x002fca0003f9d000ULL,
0x000000012a2a5812ULL, 0x000fe400078efcffULL, 0x0000006200827306ULL, 0x000ff0000020d400ULL,
0x00000034009a7306ULL, 0x000ff00000209400ULL, 0x00000034009b7306ULL, 0x000e700000205400ULL,
0x0000003400627306ULL, 0x0004f0000020d400ULL, 0x0000008f00967306ULL, 0x000f22000020d400ULL,
0x000100006a347824ULL, 0x004fe200078e00ffULL, 0x0000009b9a00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000085008f7306ULL, 0x000e6e000020d400ULL,
0x0000000162625812ULL, 0x008fe200078efcffULL, 0x0000006500d37306ULL, 0x000fe20000209400ULL,
0x0000000196964812ULL, 0x010fc400078efcffULL, 0x000000c4c300720bULL, 0x000fe40003f9d000ULL,
0x000000f5f600720bULL, 0x000fe40003fbd000ULL, 0x00000098969d723eULL, 0x000fe200000010ffULL,
0x0000006500d47306ULL, 0x000ea20000205400ULL, 0x000000018f8f6812ULL, 0x002fe400078efcffULL,
0x0000009fa000720bULL, 0x000fe40003fdd000ULL, 0x0000008e8f8e723eULL, 0x000fc400000010ffULL,
0x0000008c868f723eULL, 0x000fe200000010ffULL, 0x0000006500847306ULL, 0x000e62000020d400ULL,
0x0000000128284812ULL, 0x000fe400078efcffULL, 0x000000dfd800720bULL, 0x000fe40003f9d000ULL,
0x0000000113135812ULL, 0x000fc600078efcffULL, 0x0000003500de7306ULL, 0x000fe20000209400ULL,
0x0000000126266812ULL, 0x000fe400078efcffULL, 0x000000d4d300720bULL, 0x004fca0003fdd000ULL,
0x0000003500dd7306ULL, 0x000fe20000205400ULL, 0x000000018d8d4812ULL, 0x000fe400078efcffULL,
0x000000d5d200720bULL, 0x000fca0003f9d000ULL, 0x0000003500657306ULL, 0x0005e2000020d400ULL,
0x0000000184846812ULL, 0x002fe400078efcffULL, 0x000000d15d00720bULL, 0x000fca0003fdd000ULL,
0x0000003400c97306ULL, 0x000fe20000209400ULL, 0x000100006b357824ULL, 0x004fe200078e00ffULL,
0x0000000183834812ULL, 0x000fc800078efcffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400c67306ULL, 0x000fe20000205400ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x0000008ae000720bULL, 0x000fca0003fdd000ULL, 0x0000003400647306ULL, 0x0003f0000020d400ULL,
0x0000006700e37306ULL, 0x000fe20000009400ULL, 0x0001300097347811ULL, 0x002fe400078e20ffULL,
0x0000000171716812ULL, 0x000fc400078efcffULL, 0x000000c2c100720bULL, 0x000fc60003fdd000ULL,
0x0000006700e47306ULL, 0x000e700000005400ULL, 0x0000006700817306ULL, 0x000ea4000000d400ULL,
0x000000017e7e6812ULL, 0x000fc400078efcffULL, 0x000000e6eb00720bULL, 0x000fc80003fdd000ULL,
0x0000005f00ad7306ULL, 0x000fe20000209400ULL, 0x000000e4e300720bULL, 0x002fce0003f7d000ULL,
0x0000005f00ae7306ULL, 0x000fe20000205400ULL, 0x000000012b2b6812ULL, 0x000fca00078efcffULL,
0x0000000181813812ULL, 0x004fe400078efcffULL, 0x0000005f007b7306ULL, 0x000fe2000020d400ULL,
0x000000484900720bULL, 0x000fe40003f7d000ULL, 0x000000b69048723eULL, 0x000fe200000010ffULL,
0x000001006fb67824ULL, 0x000fe200078e00ffULL, 0x000000bd8b49723eULL, 0x000fe400000010ffULL,
0x000000bb9190723eULL, 0x000fe200000010ffULL, 0x0000003700a17306ULL, 0x000fe20000209400ULL,
0x000000c0b891723eULL, 0x000fe200000010ffULL, 0x000001006eb87824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fc600000114b6ULL, 0x0000000182823812ULL, 0x000fe400078efcffULL,
0x0000003700a27306ULL, 0x000e620000205400ULL, 0x000000cf4a00720bULL, 0x000fe40003f7d000ULL,
0x00013000b14a7811ULL, 0x000fe400078e20ffULL, 0x00000018ffb87819ULL, 0x000fc600000114b8ULL,
0x0000003700677306ULL, 0x000eac000020d400ULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x0000003500ca7306ULL, 0x000fe20000209400ULL, 0x000000a2a100720bULL, 0x002fce0003fdd000ULL,
0x0000003500c87306ULL, 0x000fec0000205400ULL, 0x0000000167676812ULL, 0x004fe400078efcffULL,
0x00000035005f7306ULL, 0x0003e2000020d400ULL, 0x000000c6c900720bULL, 0x000fce0003fdd000ULL,
0x0000006600e17306ULL, 0x000fe20000009400ULL, 0x000000003434783bULL, 0x002e6a0000000200ULL,
0x0000000164646812ULL, 0x000fe400078efcffULL, 0x0000006600e27306ULL, 0x000eb00000005400ULL,
0x0000006600857306ULL, 0x000722000000d400ULL, 0x000000e2e100720bULL, 0x004fce0003f5d000ULL,
0x00000046008a7306ULL, 0x000fe20000205400ULL, 0x00000018ff667819ULL, 0x008fce000001146cULL,
0x0000004600617306ULL, 0x000fe2000020d400ULL, 0x0000000185852812ULL, 0x010fe400078efcffULL,
0x000000958900720bULL, 0x000fe20003f5d000ULL, 0x0000007834349231ULL, 0x002fc800003400ffULL,
0x0000004600897306ULL, 0x0003e20000209400ULL, 0x0000007836369231ULL, 0x000fe200003400ffULL,
0x000000858484723eULL, 0x000fe200000010ffULL, 0x0000007735359231ULL, 0x080fe200003400ffULL,
0x000000818085723eULL, 0x000fe200000010ffULL, 0x0000007737379231ULL, 0x000fc600003400ffULL,
0x00000068005c7306ULL, 0x000fe20000009400ULL, 0x0000000172722812ULL, 0x000fc600078efcffULL,
0x000000443444723cULL, 0x002fe20000041840ULL, 0x000000827272723eULL, 0x000fc600000010ffULL,
0x0000006800e87306ULL, 0x000e660000005400ULL, 0x00013000b2407811ULL, 0x000fe200078e20ffULL,
0x000000483438723cULL, 0x040fe20000041838ULL, 0x000000004a48783bULL, 0x000ea60000000200ULL,
0x0000006600667306ULL, 0x000ee20000209400ULL, 0x000000004040783bULL, 0x000f260000000200ULL,
0x000000903454723cULL, 0x000fe80000041854ULL, 0x00000068007f7306ULL, 0x0006e2000000d400ULL,
0x000000e85c00720bULL, 0x002fc40003f9d000ULL, 0x000100006e907824ULL, 0x000fe200078e00ffULL,
0x000000923458723cULL, 0x000fe80000041858ULL, 0x0000006a00c57306ULL, 0x000fe20000009400ULL,
0x000000ffffce7224ULL, 0x008fe200078e0066ULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x000001006d687824ULL, 0x000fca00078e00ffULL, 0x0000006a00c77306ULL, 0x000e620000005400ULL,
0x000000017f7f4812ULL, 0x000fe400078efcffULL, 0x000000dbdc00720bULL, 0x000fe40003f9d000ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000007f7e7e723eULL, 0x000fe200000010ffULL,
0x0000006c00a37306ULL, 0x000fe20000009400ULL, 0x0000007848489231ULL, 0x084fe400003400ffULL,
0x000000784a4a9231ULL, 0x000fca00003400ffULL, 0x0000006c00a47306ULL, 0x000ea20000005400ULL,
0x0000007840409231ULL, 0x090fe200003400ffULL, 0x000000c7c500720bULL, 0x002fe20003f5d000ULL,
0x0000007842429231ULL, 0x000fe200003400ffULL, 0x0000000169694812ULL, 0x000fe200078efcffULL,
0x0000007741419231ULL, 0x080fe400003400ffULL, 0x0000007743439231ULL, 0x080fe200003400ffULL,
0x0000006c00607306ULL, 0x0002e2000000d400ULL, 0x0000007749499231ULL, 0x080fe400003400ffULL,
0x000000774b4b9231ULL, 0x000fe200003400ffULL, 0x000000aead00720bULL, 0x000fc40003f3d000ULL,
0x0000009c4054723cULL, 0x000fe40000041854ULL, 0x0000006a00667306ULL, 0x000f22000000d400ULL,
0x000100006c6c7824ULL, 0x002fe200078e00ffULL, 0x000000a4a300720bULL, 0x004fc80003f9d000ULL,
0x00000018ffbb7819ULL, 0x000fe4000001146cULL, 0x0000006d009f7306ULL, 0x000fe20000009400ULL,
0x000000aab96c723eULL, 0x000fe400000010ffULL, 0x000000017b7b1812ULL, 0x000fe400078efcffULL,
0x000000ddde00720bULL, 0x000fe40003f3d000ULL, 0x0000000160604812ULL, 0x008fe200078efcffULL,
0x0000006d00a07306ULL, 0x000e620000005400ULL, 0x0000000166662812ULL, 0x010fc400078efcffULL,
0x000000f3f400720bULL, 0x000fe40003f5d000ULL, 0x000000666766723eULL, 0x000fe400000010ffULL,
0x0000007c7b7f723eULL, 0x000fe200000010ffULL, 0x0000006d005e7306ULL, 0x0004e4000000d400ULL,
0x0000000165651812ULL, 0x000fcc00078efcffULL, 0x0000006b00c37306ULL, 0x000fe20000009400ULL,
0x000000acbe6d723eULL, 0x004fe400000010ffULL, 0x000000a09f00720bULL, 0x002fe40003f3d000ULL,
0x0000000129292812ULL, 0x000fe400078efcffULL, 0x0000008a8900720bULL, 0x000fe20003f5d000ULL,
0x0000006b00c47306ULL, 0x000e620000005400ULL, 0x0000006c3450723cULL, 0x000fe20000041850ULL,
0x000000642964723eULL, 0x000fcc00000010ffULL, 0x0000006b00637306ULL, 0x000ea2000000d400ULL,
0x000000b3b06c723eULL, 0x000fe400000010ffULL, 0x000000b4af6d723eULL, 0x000fe400000010ffULL,
0x000000015e5e1812ULL, 0x008fe400078efcffULL, 0x0000000161612812ULL, 0x000fe200078efcffULL,
0x0000006f006a7306ULL, 0x000fe20000009400ULL, 0x000000c4c300720bULL, 0x002fe20003f7d000ULL,
0x0000006c344c723cULL, 0x000fe2000004184cULL, 0x000000fbfc00720bULL, 0x000fc40003f3d000ULL,
0x000000cbce00720bULL, 0x000fe40003f5d000ULL, 0x000000606160723eULL, 0x000fe200000010ffULL,
0x0000006f006b7306ULL, 0x000e620000005400ULL, 0x000000a8a96c723eULL, 0x000fe200000010ffULL,
0x0000008e4050723cULL, 0x000fe20000041850ULL, 0x000000a6a76d723eULL, 0x000fc600000010ffULL,
0x0000000163633812ULL, 0x004fe400078efcffULL, 0x0000006f005c7306ULL, 0x0004e2000000d400ULL,
0x000000c8ca00720bULL, 0x000fe20003f7d000ULL, 0x0000006c4044723cULL, 0x040fe20000041844ULL,
0x0000000131311812ULL, 0x000fe400078efcffULL, 0x0000000170702812ULL, 0x000fe400078efcffULL,
0x000000f9fa00720bULL, 0x000fe20003f5d000ULL, 0x0000006e00877306ULL, 0x000fe20000009400ULL,
0x000000b7756f723eULL, 0x004fe200000010ffULL, 0x00000084404c723cULL, 0x000fe2000004184cULL,
0x000000ab7375723eULL, 0x000fc400000010ffULL, 0x0000007d7173723eULL, 0x000fe400000010ffULL,
0x000000015f5f3812ULL, 0x000fe200078efcffULL, 0x0000006e00887306ULL, 0x000ea20000005400ULL,
0x0000006b6a00720bULL, 0x002fe20003f7d000ULL, 0x00000074342c723cULL, 0x000fe2000004182cULL,
0x000000636267723eULL, 0x000fe400000010ffULL, 0x0000000133332812ULL, 0x000fc600078efcffULL,
0x0000006e005d7306ULL, 0x000324000000d400ULL, 0x000000664854723cULL, 0x000fe80000041854ULL,
0x000000015c5c3812ULL, 0x008fe400078efcffULL, 0x00000068008b7306ULL, 0x000fe20000209400ULL,
0x000000bf766e723eULL, 0x002fe400000010ffULL, 0x000000888700720bULL, 0x004fca0003fdd000ULL,
0x0000006800957306ULL, 0x000e620000205400ULL, 0x0000006e343c723cULL, 0x000fee000004183cULL,
0x000000bb007a7306ULL, 0x000fe20000209400ULL, 0x000000a50c34723eULL, 0x000fe200000010ffULL,
0x00000072402c723cULL, 0x000fe2000004182cULL, 0x0000009e0235723eULL, 0x000fc400000010ffULL,
0x000000015d5d6812ULL, 0x010fc600078efcffULL, 0x000000bb00917306ULL, 0x000ea20000205400ULL,
0x000000958b00720bULL, 0x002fe20003fbd000ULL, 0x000000344038723cULL, 0x000fec0000041838ULL,
0x0000006800687306ULL, 0x000e62000020d400ULL, 0x000000990034723eULL, 0x000fe400000010ffULL,
0x000000942835723eULL, 0x000fca00000010ffULL, 0x000000bb00767306ULL, 0x000ee2000020d400ULL,
0x000000917a00720bULL, 0x004fe20003f9d000ULL, 0x000000344058723cULL, 0x000fec0000041858ULL,
0x000000ba006e7306ULL, 0x000fe20000209400ULL, 0x0000008d2634723eULL, 0x000fe400000010ffULL,
0x000000832535723eULL, 0x000fc400000010ffULL, 0x0000000168685812ULL, 0x002fc600078efcffULL,
0x000000ba006f7306ULL, 0x000e620000205400ULL, 0x0000000176764812ULL, 0x008fe200078efcffULL,
0x00000034403c723cULL, 0x000fe2000004183cULL, 0x0000005e6861723eULL, 0x000fe400000010ffULL,
0x000000767070723eULL, 0x000fc600000010ffULL, 0x000000b800027306ULL, 0x000fe20000209400ULL,
0x000000692b34723eULL, 0x000fe200000010ffULL, 0x0000007e4840723cULL, 0x000fe20000041844ULL,
0x000000652a35723eULL, 0x000fe400000010ffULL, 0x0000005f1365723eULL, 0x000fc600000010ffULL,
0x000000b800377306ULL, 0x000ea20000205400ULL, 0x0000006f6e00720bULL, 0x002fe20003fbd000ULL,
0x000000344838723cULL, 0x040fec0000041838ULL, 0x000000ba00367306ULL, 0x000e64000020d400ULL,
0x000000644858723cULL, 0x040fec0000041858ULL, 0x000000b800007306ULL, 0x000ee2000020d400ULL,
0x000000370200720bULL, 0x004fe20003f9d000ULL, 0x000000604850723cULL, 0x000fec0000041850ULL,
0x000000b600287306ULL, 0x000fe20000209400ULL, 0x0000000136365812ULL, 0x002fc400078efcffULL,
0x000000f7f800720bULL, 0x000fe40003fbd000ULL, 0x000000363171723eULL, 0x000fc600000010ffULL,
0x000000b6006d7306ULL, 0x000e620000205400ULL, 0x0000000100004812ULL, 0x008fc600078efcffULL,
0x00000070483c723cULL, 0x000fe8000004183cULL, 0x00000090000c7306ULL, 0x000fe20000209400ULL,
0x0000000130305812ULL, 0x000fce00078efcffULL, 0x0000009000257306ULL, 0x000ea20000205400ULL,
0x0000006d2800720bULL, 0x002fe40003f3d000ULL, 0x0000005d0028723eULL, 0x000fe400000010ffULL,
0x000000010e007812ULL, 0x000fc600078ec0ffULL, 0x0000007900267306ULL, 0x000ff00000209400ULL,
0x00000079002b7306ULL, 0x000e620000205400ULL, 0x000000250c00720bULL, 0x004fce0003f9d000ULL,
0x000000b600757306ULL, 0x000eb0000020d400ULL, 0x0000009000907306ULL, 0x000ee2000020d400ULL,
0x0000002b2600720bULL, 0x002fce0003fdd000ULL, 0x0000007900917306ULL, 0x000e62000020d400ULL,
0x0000000175751812ULL, 0x004fe400078efcffULL, 0x000000010000780cULL, 0x000fe40003f25070ULL,
0x0000005c7529723eULL, 0x000fe400000010ffULL, 0x0000000190904812ULL, 0x008fc800078efcffULL,
0x000000903390723eULL, 0x000fe200000010ffULL, 0x00000028484c723cULL, 0x000fe2000004184cULL,
0x0000000191916812ULL, 0x002fc800078efcffULL, 0x000000913091723eULL, 0x000fce00000010ffULL,
0x000000904848723cULL, 0x000fe2000004182cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000400016a7983ULL, 0x000ea20000300800ULL,
0x0000002427277207ULL, 0x000fe40004800000ULL, 0x000000c005257811ULL, 0x000fe200078e40ffULL,
0x01c63000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff27ff7812ULL, 0x000fe4000782c0ffULL,
0x000000010e007812ULL, 0x000fe400078ec0ffULL, 0x00000001ff137807ULL, 0x000fc40000800000ULL,
0x000000250400720cULL, 0x000fe40003f24070ULL, 0x000000010000780cULL, 0x000fe40003f45070ULL,
0x000000010e007812ULL, 0x000fe400078e0cffULL, 0x00000024130c7207ULL, 0x000fe40005000000ULL,
0x000000ff6aff7812ULL, 0x004fc8000786c0ffULL, 0x00000001ff027807ULL, 0x000fe20001800000ULL,
0x0000497000009947ULL, 0x000fea0003800000ULL, 0x01c65c00ff007984ULL, 0x000e620000000800ULL,
0x8000000022257824ULL, 0x000fca00078e00ffULL, 0x8000000000ff7812ULL, 0x002fe20007824825ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000022257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000030005007a10ULL, 0x000fe20007ffe0ffULL, 0x00000100ff357424ULL, 0x000fe200078e00ffULL,
0x00004000e5e57812ULL, 0x000fe200078ec0ffULL, 0x0000000000247919ULL, 0x000ea20000002600ULL,
0x00000010032f7824ULL, 0x000fe400078e00ffULL, 0x00014000e5e57810ULL, 0x000fe20007ffe0ffULL,
0x00000000002d7919ULL, 0x000ee80000000000ULL, 0x000000101b1b7824ULL, 0x000fc400078e02e5ULL,
0x000000101d1d7824ULL, 0x100fe400078e02e5ULL, 0x000000101f1f7824ULL, 0x000fe200078e02e5ULL,
0x00000004ff227819ULL, 0x002fe20000011602ULL, 0x0000001003027824ULL, 0x000fe400078e00ffULL,
0x0000008024247824ULL, 0x004fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e0222ULL,
0x0000000409257c24ULL, 0x020fc4000f8e0224ULL, 0x000000102d2e7824ULL, 0x008fe200078e00ffULL,
0x00000004ff2d7819ULL, 0x000fe4000001162dULL, 0x0000007f25027812ULL, 0x040fe400078ef802ULL,
0x0000007f25227812ULL, 0x040fe200078ef80fULL, 0x00000100000f7824ULL, 0x000fe200078e00ffULL,
0x0000007f25247812ULL, 0x040fe400078ef810ULL, 0x0000007f25267812ULL, 0x000fe200078ef811ULL,
0x00005e0002107625ULL, 0x000fe200078e0035ULL, 0x0000000f04027217ULL, 0x000fc40007800000ULL,
0x0000000100007810ULL, 0x000fe20007ffe0ffULL, 0x00005e0026267625ULL, 0x000fe200078e0035ULL,
0x0000007f25287812ULL, 0x040fe400078ef812ULL, 0x000000070000720cULL, 0x000fe20003f26070ULL,
0x0000000102027824ULL, 0x000fe200078e0a0fULL, 0x0000007f252a7812ULL, 0x040fe200078ef814ULL,
0x00005e0028287625ULL, 0x080fe200078e0035ULL, 0x0000007f25127812ULL, 0x000fe400078ef815ULL,
0x0000004002027807ULL, 0x000fe20000800000ULL, 0x00005e0022147625ULL, 0x000fe200078e0035ULL,
0x000000f02e2e7812ULL, 0x000fc400078ec0ffULL, 0x000000022f027217ULL, 0x000fe20007800000ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0035ULL, 0x000000022d0f7810ULL, 0x040fe40007ffe0ffULL,
0x0000002e14147210ULL, 0x080fe20007f7e0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a2fULL,
0x0000002e28287210ULL, 0x080fe40007f3e0ffULL, 0x0000002e10107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x000000022d00720cULL, 0x080fe20003f86070ULL,
0x000000ffff297224ULL, 0x000fe200008e0629ULL, 0x000000020f00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000062d0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000002e26267210ULL, 0x000fe40007f7e0ffULL, 0x000000020f00720cULL, 0x080fe20003f26070ULL,
0x00000010170f7824ULL, 0x000fe200078e02e5ULL, 0x000000042d317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x0000007f252c7812ULL, 0x000fe200078ef816ULL,
0x00005e0024247625ULL, 0x080fe200078e0035ULL, 0x0000000823007812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e2000e101c46ULL,
0x0000000a2d177810ULL, 0x000fe20007ffe0ffULL, 0x00005e002c227625ULL, 0x000fe200078e0035ULL,
0x000000023100720cULL, 0x080fe20003f66070ULL, 0x00000000000573c2ULL, 0x000ea200000e0000ULL,
0x000000021700720cULL, 0x000fe20003f86070ULL, 0x0000001018317824ULL, 0x000fe200078e02e5ULL,
0x0000002e24247210ULL, 0x000fc40007f5e0ffULL, 0x0000000c2d177810ULL, 0x000fe40007ffe0ffULL,
0x0000000014317faeULL, 0x0007e2000e901c46ULL, 0x000000ffff257224ULL, 0x000fe200010e0625ULL,
0x000000021700720cULL, 0x000fe20003fa6070ULL, 0x00005e0012167625ULL, 0x000fe200078e0035ULL,
0x0000002e2a2a7210ULL, 0x080fe40007f5e0ffULL, 0x000000082d2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000101e0f7824ULL, 0x002fe200078e02e5ULL, 0x0000002e16107210ULL, 0x000fe20007fde0ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e062bULL, 0x000000022f00720cULL, 0x000fe20003f46070ULL,
0x000000101a2f7824ULL, 0x000fe200078e02e5ULL, 0x0000000e2d337810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fc400030e0617ULL, 0x000000101c2d7824ULL, 0x000fe200078e02e5ULL,
0x000000023300720cULL, 0x000fe20003fc6070ULL, 0x00000000242f7faeULL, 0x0003e2000d901c46ULL,
0x0000002e22147210ULL, 0x008fe20007f7e0ffULL, 0x0001c64805057890ULL, 0x004fe2000fffe03fULL,
0x0001c64819027811ULL, 0x000fe200078e18ffULL, 0x00000000261b7faeULL, 0x0003e4000c901c46ULL,
0x000000ffff157224ULL, 0x000fe400018e0623ULL, 0x00000000282d7faeULL, 0x0003e8000d101c46ULL,
0x000000002a1d7faeULL, 0x0003e8000e101c46ULL, 0x00000000100f7faeULL, 0x0003e8000e901c46ULL,
0x00000000141f7faeULL, 0x0003e8000f101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000400020f7984ULL, 0x0022a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c63c00ff027984ULL, 0x002e620000000800ULL, 0x0000ffff0c147812ULL, 0x000fe200078ec0ffULL,
0x8000000020117824ULL, 0x000fc800078e00ffULL, 0x8000000014007824ULL, 0x000fca00078e00ffULL,
0x800000000fff7812ULL, 0x004fe40007824800ULL, 0x8000000002ff7812ULL, 0x002fe20007844811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x80000000200f7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x01c63c00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc4000784480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x01c18000210f7984ULL, 0x000e620000000800ULL,
0x00000001ffa97424ULL, 0x000fc600078e00ffULL, 0x01c3800021007984ULL, 0x0004e20000000800ULL,
0x0000000a0f00720bULL, 0x002fda0003f5d000ULL, 0x0000000000027806ULL, 0x000fc800010e0100ULL,
0x0000ffff02117812ULL, 0x000fda000784c0ffULL, 0x000003700000a947ULL, 0x000fea0003800000ULL,
0x0000000000167919ULL, 0x00ce620000000000ULL, 0x0000000a0f00720bULL, 0x000fe40003f54000ULL,
0x0000000f0a127209ULL, 0x000fca0007810000ULL, 0x800000120a027221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b02107820ULL, 0x000fe40000410000ULL, 0x0000000000027806ULL, 0x000fe400010e0100ULL,
0x000000030300780cULL, 0x000fe40003f45270ULL, 0x0000001000107308ULL, 0x000ea20000000800ULL,
0x0000ffff020a7812ULL, 0x000fc800078e3cffULL, 0x0000000a11ff7212ULL, 0x000fe4000786c0ffULL,
0x00000002ff157819ULL, 0x102fe40000011616ULL, 0x00000002ff167819ULL, 0x000fe40000011616ULL,
0x01c580122100a388ULL, 0x000fe20000000800ULL, 0x00000001ffa97807ULL, 0x000fe40001800000ULL,
0x0000000816167810ULL, 0x000fe20007ffe0ffULL, 0x00001f1510027589ULL, 0x004e6200000e0000ULL,
0x000000100b0b7220ULL, 0x000fc40000410000ULL, 0x800000120f0f3221ULL, 0x000fe20000010000ULL,
0x00001f16100a7589ULL, 0x000ea600000e0000ULL, 0x3fb8aa3b0f0f3820ULL, 0x000fc80000410000ULL,
0x0000000f000d3308ULL, 0x000ee20000000800ULL, 0x0000000240407220ULL, 0x082fe40000410000ULL,
0x0000000241417220ULL, 0x000fe40000410000ULL, 0x0000000a42427220ULL, 0x084fe40000410000ULL,
0x0000000a43437220ULL, 0x080fe40000410000ULL, 0x0000000a3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000a3b3b7220ULL, 0x000fc40000410000ULL, 0x0000000a56567220ULL, 0x080fe40000410000ULL,
0x0000000a57577220ULL, 0x080fe40000410000ULL, 0x0000000a5a5a7220ULL, 0x080fe40000410000ULL,
0x0000000a5b5b7220ULL, 0x080fe40000410000ULL, 0x0000000a52527220ULL, 0x080fe40000410000ULL,
0x0000000a53537220ULL, 0x000fc40000410000ULL, 0x0000000a3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000a3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000a4e4e7220ULL, 0x080fe40000410000ULL,
0x0000000a4f4f7220ULL, 0x080fe40000410000ULL, 0x0000000a4a4a7220ULL, 0x080fe40000410000ULL,
0x0000000a4b4b7220ULL, 0x000fc40000410000ULL, 0x0000000238387220ULL, 0x080fe40000410000ULL,
0x0000000239397220ULL, 0x080fe40000410000ULL, 0x0000000254547220ULL, 0x080fe40000410000ULL,
0x0000000255557220ULL, 0x080fe40000410000ULL, 0x0000000258587220ULL, 0x080fe40000410000ULL,
0x0000000259597220ULL, 0x000fc40000410000ULL, 0x0000000250507220ULL, 0x080fe40000410000ULL,
0x0000000251517220ULL, 0x080fe40000410000ULL, 0x000000023c3c7220ULL, 0x080fe40000410000ULL,
0x000000023d3d7220ULL, 0x080fe40000410000ULL, 0x000000024c4c7220ULL, 0x080fe40000410000ULL,
0x000000024d4d7220ULL, 0x000fc40000410000ULL, 0x0000000248487220ULL, 0x080fe40000410000ULL,
0x0000000249497220ULL, 0x000fe40000410000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0012ULL,
0x000000000d003220ULL, 0x008fc80000410000ULL, 0x0000000b000b7221ULL, 0x00cfe20000010000ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0001c64819197811ULL, 0x000fe200078e18ffULL,
0x80000000140f7824ULL, 0x000fc800078e00ffULL, 0x0000040019007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000782480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x80000000140f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x0000040019027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc4000782480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000001127983ULL, 0x000ea20000300800ULL, 0x0001380032327811ULL, 0x000fc600078e20ffULL,
0x00000000f25c783bULL, 0x000e680000004200ULL, 0x00000000e744783bULL, 0x000ee80000004200ULL,
0x00000000e960783bULL, 0x000fe80000004200ULL, 0x00000000ec2c783bULL, 0x000fe80000004200ULL,
0x00000000ee28783bULL, 0x000fe80000004200ULL, 0x00000000f024783bULL, 0x000fe80000004200ULL,
0x00000000f11c783bULL, 0x000f280000004200ULL, 0x0000000000fb7919ULL, 0x000f620000000000ULL,
0x00000018ff6c7819ULL, 0x002fc4000001145fULL, 0x00000018ff147819ULL, 0x000fe4000001145dULL,
0x0000006c00d77306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x008fe40000011444ULL,
0x00000018ff107819ULL, 0x000fe40000011447ULL, 0x00000018ff0f7819ULL, 0x000fe40000011446ULL,
0x00000018ff027819ULL, 0x000fe20000011445ULL, 0x0000006c00d47306ULL, 0x000fe20000205400ULL,
0x00000002fffa7819ULL, 0x020fc800000116fbULL, 0x00000008fafa7810ULL, 0x000fc60007ffe0ffULL,
0x0000004400a87306ULL, 0x000fe20000009400ULL, 0x00000018ff117819ULL, 0x010fce000001141dULL,
0x0000004400c07306ULL, 0x000e700000005400ULL, 0x0000004400717306ULL, 0x000ef0000000d400ULL,
0x0000000000bf7306ULL, 0x000fe20000209400ULL, 0x000000c0a800720bULL, 0x002fce0003fbd000ULL,
0x0000000000f37306ULL, 0x000e6c0000205400ULL, 0x0000000171715812ULL, 0x008fe400078efcffULL,
0x0000000000727306ULL, 0x000730000020d400ULL, 0x0000001000987306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x008fc40000011460ULL, 0x000000f3bf00720bULL, 0x002fca0003fdd000ULL,
0x00000010009a7306ULL, 0x000ff00000205400ULL, 0x0000001000d07306ULL, 0x0003e2000020d400ULL,
0x0000000172726812ULL, 0x010fce00078efcffULL, 0x0000000000777306ULL, 0x000fe20000209400ULL,
0x00000018ff107819ULL, 0x002fce0000011463ULL, 0x00000000008b7306ULL, 0x000ff00000205400ULL,
0x0000000000927306ULL, 0x0003f0000020d400ULL, 0x00000010007f7306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x002fce000001142cULL, 0x00000010007e7306ULL, 0x000ff00000205400ULL,
0x0000001000bd7306ULL, 0x0003f0000020d400ULL, 0x0000000000767306ULL, 0x000fe20000209400ULL,
0x00000018ff107819ULL, 0x002fce000001142fULL, 0x0000000000787306ULL, 0x000ff00000205400ULL,
0x0000000000b47306ULL, 0x0003f0000020d400ULL, 0x00000010006b7306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x002fce0000011428ULL, 0x00000010008f7306ULL, 0x000ff00000205400ULL,
0x0000001000a17306ULL, 0x0003f0000020d400ULL, 0x0000000000317306ULL, 0x000fe20000209400ULL,
0x00000018ff107819ULL, 0x002fce000001142bULL, 0x0000000000307306ULL, 0x000ff00000205400ULL,
0x0000000000947306ULL, 0x0003f0000020d400ULL, 0x00000010001b7306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x002fce0000011424ULL, 0x00000010008d7306ULL, 0x000ff00000205400ULL,
0x0000001000837306ULL, 0x0003f0000020d400ULL, 0x00000000006d7306ULL, 0x000fe20000209400ULL,
0x00000018ff107819ULL, 0x002fce0000011427ULL, 0x0000000000647306ULL, 0x000ff00000205400ULL,
0x0000000000797306ULL, 0x0003e2000020d400ULL, 0x000000001234783bULL, 0x0044ee0000004200ULL,
0x0000001000e77306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x002fc4000001141cULL,
0x00000018ff127819ULL, 0x004fca000001145cULL, 0x00000012007a7306ULL, 0x000ff00000209400ULL,
0x00000012007b7306ULL, 0x000ff00000205400ULL, 0x0000001200177306ULL, 0x000ff0000020d400ULL,
0x0000006c00127306ULL, 0x0003e2000020d400ULL, 0x00000018ff6f7819ULL, 0x008fc40000011434ULL,
0x00000018ff817819ULL, 0x000fca0000011435ULL, 0x0000006f00f97306ULL, 0x000fe20000209400ULL,
0x00000100446c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011437ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011436ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000006f00f87306ULL, 0x000ff00000205400ULL, 0x0000006c00c17306ULL, 0x000ff00000209400ULL,
0x0000006c00f67306ULL, 0x000e700000205400ULL, 0x0000006c00e37306ULL, 0x0004f0000020d400ULL,
0x0000004400f47306ULL, 0x000fe20000209400ULL, 0x000000f6c100720bULL, 0x002fe20003f5d000ULL,
0x00000100466c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000004400f57306ULL, 0x000e6c0000205400ULL, 0x00000001e3e32812ULL, 0x008fe400078efcffULL,
0x0000006f00157306ULL, 0x0005f0000020d400ULL, 0x0000004400df7306ULL, 0x000ee2000020d400ULL,
0x00000100456f7824ULL, 0x004fe200078e00ffULL, 0x000000f5f400720bULL, 0x002fc80003f5d000ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000001000aa7306ULL, 0x000ff00000205400ULL,
0x0000006f00bb7306ULL, 0x000fe20000209400ULL, 0x00000001dfdf2812ULL, 0x008fce00078efcffULL,
0x0000006f00f27306ULL, 0x000e700000205400ULL, 0x0000001000337306ULL, 0x0005f0000020d400ULL,
0x0000006f00e47306ULL, 0x000ee2000020d400ULL, 0x00000018ff107819ULL, 0x004fc4000001141fULL,
0x000000f2bb00720bULL, 0x002fca0003f5d000ULL, 0x0000006c00447306ULL, 0x000ff00000209400ULL,
0x0000006c00e17306ULL, 0x000e620000205400ULL, 0x00000001e4e42812ULL, 0x008fce00078efcffULL,
0x0000000000657306ULL, 0x000ff00000209400ULL, 0x0000000000dd7306ULL, 0x000fe20000205400ULL,
0x000000e14400720bULL, 0x002fce0003f5d000ULL, 0x0000000000207306ULL, 0x000ff0000020d400ULL,
0x00000010009d7306ULL, 0x000ff00000209400ULL, 0x00000010009e7306ULL, 0x000ff00000205400ULL,
0x0000001000007306ULL, 0x000ff0000020d400ULL, 0x0000008100f77306ULL, 0x000ff00000209400ULL,
0x0000008100e87306ULL, 0x000ff00000205400ULL, 0x0000008100107306ULL, 0x0003f0000020d400ULL,
0x0000006c00db7306ULL, 0x0004e2000020d400ULL, 0x0000010047817824ULL, 0x002fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe40000011481ULL, 0x0000004600a77306ULL, 0x000fe20000009400ULL,
0x00000100616c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000008100e07306ULL, 0x000fe20000209400ULL, 0x00000001dbdb2812ULL, 0x008fce00078efcffULL,
0x0000008100e27306ULL, 0x000e700000205400ULL, 0x0000004600807306ULL, 0x000eb00000005400ULL,
0x0000004600667306ULL, 0x000722000000d400ULL, 0x000000e2e000720bULL, 0x002fce0003f5d000ULL,
0x0000004500ae7306ULL, 0x000fe20000009400ULL, 0x0001000046467824ULL, 0x008fe200078e00ffULL,
0x00000080a700720bULL, 0x004fc80003f3d000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004500ba7306ULL, 0x000e6e0000005400ULL, 0x0000000166661812ULL, 0x010fe200078efcffULL,
0x0000004500707306ULL, 0x0004e2000000d400ULL, 0x0000009a9800720bULL, 0x000fe20003f3d000ULL,
0x00000100299a7824ULL, 0x000fcc00078e00ffULL, 0x00000081006f7306ULL, 0x000f22000020d400ULL,
0x0001000045457824ULL, 0x004fe200078e00ffULL, 0x000000baae00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004600ed7306ULL, 0x000fe20000209400ULL,
0x00000001d0d01812ULL, 0x000fe400078efcffULL, 0x0000008b7700720bULL, 0x000fe20003f3d000ULL,
0x00010000288b7824ULL, 0x000fc600078e00ffULL, 0x0000000170703812ULL, 0x008fe200078efcffULL,
0x0000004600ee7306ULL, 0x000e620000205400ULL, 0x000000016f6f2812ULL, 0x010fce00078efcffULL,
0x0000004500ea7306ULL, 0x000fe20000209400ULL, 0x0000000192921812ULL, 0x000fce00078efcffULL,
0x0000004500f17306ULL, 0x000ea20000205400ULL, 0x000000eeed00720bULL, 0x002fce0003f5d000ULL,
0x0000004500de7306ULL, 0x0003f0000020d400ULL, 0x0000004600d67306ULL, 0x000722000020d400ULL,
0x0000010060457824ULL, 0x002fe200078e00ffULL, 0x000000f1ea00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000006c00997306ULL, 0x000fe20000209400ULL,
0x0000010063467824ULL, 0x008fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004500a07306ULL, 0x000fe20000209400ULL, 0x00000001d6d62812ULL, 0x010fe400078efcffULL,
0x00000001dede6812ULL, 0x000fca00078efcffULL, 0x0000004500ca7306ULL, 0x000e700000205400ULL,
0x0000004500d27306ULL, 0x0004f0000020d400ULL, 0x0000006c00957306ULL, 0x000f220000205400ULL,
0x000000caa000720bULL, 0x002fe20003f5d000ULL, 0x0000010062457824ULL, 0x004fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fc8000001149aULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000006000ce7306ULL, 0x000fec0000009400ULL, 0x00000001d2d22812ULL, 0x008fe400078efcffULL,
0x00000060009c7306ULL, 0x000e620000005400ULL, 0x000000959900720bULL, 0x010fce0003f5d000ULL,
0x0000006000967306ULL, 0x0004f0000000d400ULL, 0x0000006c00d37306ULL, 0x000f22000020d400ULL,
0x0001000060607824ULL, 0x004fe200078e00ffULL, 0x0000009cce00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x0000004500cf7306ULL, 0x000fee0000209400ULL,
0x0000000196963812ULL, 0x008fe200078efcffULL, 0x0000006000ef7306ULL, 0x000fe20000209400ULL,
0x00000001d3d32812ULL, 0x010fc400078efcffULL, 0x00000096d296723eULL, 0x000fca00000010ffULL,
0x0000006000f07306ULL, 0x000e700000205400ULL, 0x0000006000b67306ULL, 0x0004f0000020d400ULL,
0x0000004500e97306ULL, 0x000f220000205400ULL, 0x000000f0ef00720bULL, 0x002fe20003f5d000ULL,
0x000001002c607824ULL, 0x004fca00078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000000f00a27306ULL, 0x000fec0000209400ULL, 0x00000001b6b62812ULL, 0x008fe400078efcffULL,
0x0000000f00a67306ULL, 0x000fe20000205400ULL, 0x000000e9cf00720bULL, 0x010fe20003f5d000ULL,
0x000001002bcf7824ULL, 0x000fe200078e00ffULL, 0x000000b69292723eULL, 0x000fe200000010ffULL,
0x0000010036b67824ULL, 0x000fc800078e00ffULL, 0x0000000f00d17306ULL, 0x0003e2000020d400ULL,
0x00000018ffb67819ULL, 0x000fce00000114b6ULL, 0x0000004500907306ULL, 0x0004e2000020d400ULL,
0x00000018ff0f7819ULL, 0x002fce0000011462ULL, 0x00000046008c7306ULL, 0x000fe20000209400ULL,
0x0001000062457824ULL, 0x004fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00000046009b7306ULL, 0x000e620000205400ULL, 0x0000000190902812ULL, 0x008fce00078efcffULL,
0x0000000200ab7306ULL, 0x000ff00000209400ULL, 0x0000000200af7306ULL, 0x000ea20000205400ULL,
0x0000009b8c00720bULL, 0x002fce0003f5d000ULL, 0x0000000200737306ULL, 0x0002f0000020d400ULL,
0x0000000f007c7306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x002fe40000011461ULL,
0x000000afab00720bULL, 0x004fca0003fbd000ULL, 0x0000000f007d7306ULL, 0x000ff00000205400ULL,
0x0000000f00be7306ULL, 0x0003e2000020d400ULL, 0x0000000173735812ULL, 0x008fe400078efcffULL,
0x000000a6a200720bULL, 0x000fca0003fbd000ULL, 0x0000000200887306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fce000001142eULL, 0x0000000200877306ULL, 0x000e620000205400ULL,
0x00000001d1d15812ULL, 0x000fce00078efcffULL, 0x0000000200937306ULL, 0x0004f0000020d400ULL,
0x0000000f00cd7306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x004fe4000001142dULL,
0x000000878800720bULL, 0x002fca0003f7d000ULL, 0x0000000f006a7306ULL, 0x000ff00000205400ULL,
0x0000000f00a37306ULL, 0x0003e2000020d400ULL, 0x0000000193933812ULL, 0x008fce00078efcffULL,
0x00000002006e7306ULL, 0x000fe20000209400ULL, 0x00000018ff0f7819ULL, 0x002fce000001142aULL,
0x0000000200697306ULL, 0x000ff00000205400ULL, 0x0000000200b37306ULL, 0x0003f0000020d400ULL,
0x0000004600917306ULL, 0x0004e2000020d400ULL, 0x00000018ff027819ULL, 0x002fce0000011429ULL,
0x0000000f001a7306ULL, 0x000fe20000209400ULL, 0x0001000063467824ULL, 0x004fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000000f008e7306ULL, 0x000fe20000205400ULL,
0x0000000191912812ULL, 0x008fe400078efcffULL, 0x0000007d7c00720bULL, 0x000fca0003f5d000ULL,
0x0000000f00847306ULL, 0x0003f0000020d400ULL, 0x0000000200237306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fe40000011426ULL, 0x00000001bebe2812ULL, 0x000fca00078efcffULL,
0x0000000200197306ULL, 0x000ff00000205400ULL, 0x00000002008a7306ULL, 0x0003f0000020d400ULL,
0x0000000f00e57306ULL, 0x000fe20000209400ULL, 0x00000018ff027819ULL, 0x002fce0000011425ULL,
0x0000000f00e67306ULL, 0x000ff00000205400ULL, 0x0000000f00687306ULL, 0x0003f0000020d400ULL,
0x0000000200217306ULL, 0x000fe20000209400ULL, 0x00000018ff0f7819ULL, 0x002fce000001141eULL,
0x0000000200227306ULL, 0x000ff00000205400ULL, 0x0000000200747306ULL, 0x000ff0000020d400ULL,
0x0000000f00a57306ULL, 0x000ff00000209400ULL, 0x0000000f00a47306ULL, 0x000ff00000205400ULL,
0x0000000f00027306ULL, 0x0003f0000020d400ULL, 0x0000006000807306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fce000001145eULL, 0x0000006000ae7306ULL, 0x000e700000205400ULL,
0x0000000f00bc7306ULL, 0x000ff00000209400ULL, 0x0000000f00b77306ULL, 0x000fe20000205400ULL,
0x000000ae8000720bULL, 0x002fce0003f5d000ULL, 0x0000000f00167306ULL, 0x000ff0000020d400ULL,
0x0000008500d97306ULL, 0x000ff00000209400ULL, 0x0000008500d87306ULL, 0x000ff00000205400ULL,
0x00000085000f7306ULL, 0x000ff0000020d400ULL, 0x0000004500857306ULL, 0x000ff00000209400ULL,
0x0000004500867306ULL, 0x000ff00000205400ULL, 0x0000004500c77306ULL, 0x0003f0000020d400ULL,
0x0000004700897306ULL, 0x000fe20000009400ULL, 0x000100002c457824ULL, 0x002fce00078e00ffULL,
0x0000004700c27306ULL, 0x000e700000005400ULL, 0x0000004700677306ULL, 0x0004f0000000d400ULL,
0x0000004600c97306ULL, 0x000fe20000209400ULL, 0x0001000047477824ULL, 0x004fe200078e00ffULL,
0x000000c28900720bULL, 0x002fc80003f9d000ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004600ec7306ULL, 0x000fee0000205400ULL, 0x0000000167674812ULL, 0x008fe200078efcffULL,
0x0000004600c47306ULL, 0x0003f0000020d400ULL, 0x0000006000c17306ULL, 0x000ea2000020d400ULL,
0x00000018ff467819ULL, 0x002fce0000011445ULL, 0x0000004600a77306ULL, 0x000ff00000209400ULL,
0x0000004600a87306ULL, 0x000e620000205400ULL, 0x00000001c1c12812ULL, 0x004fce00078efcffULL,
0x0000004700cb7306ULL, 0x000ff00000209400ULL, 0x0000004700cc7306ULL, 0x000ea20000205400ULL,
0x000000a8a700720bULL, 0x002fce0003f5d000ULL, 0x0000004700d57306ULL, 0x000e70000020d400ULL,
0x00000063009f7306ULL, 0x000fe20000009400ULL, 0x000000cccb00720bULL, 0x004fce0003f9d000ULL,
0x0000006300c67306ULL, 0x000eac0000005400ULL, 0x00000001d5d54812ULL, 0x002fe400078efcffULL,
0x0000006300817306ULL, 0x000e70000000d400ULL, 0x0000002c00477306ULL, 0x000fe20000009400ULL,
0x000000c69f00720bULL, 0x004fce0003f9d000ULL, 0x0000002c00637306ULL, 0x000eac0000005400ULL,
0x0000000181814812ULL, 0x002fe400078efcffULL, 0x0000002c00c07306ULL, 0x0002e2000000d400ULL,
0x0000007e7f00720bULL, 0x000fe40003f9d000ULL, 0x000000819191723eULL, 0x000fe200000010ffULL,
0x0000010034817824ULL, 0x000fc800078e00ffULL, 0x0000006100ac7306ULL, 0x000fe20000009400ULL,
0x000001002d2c7824ULL, 0x002fe200078e00ffULL, 0x000000634700720bULL, 0x004fc80003f3d000ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000006100b07306ULL, 0x000e620000005400ULL,
0x00000001bdbd4812ULL, 0x000fe400078efcffULL, 0x000000787600720bULL, 0x000fc80003f9d000ULL,
0x00000001c0c01812ULL, 0x008fe200078efcffULL, 0x0000006100c37306ULL, 0x0005e2000000d400ULL,
0x000000696e00720bULL, 0x000fce0003f3d000ULL, 0x0000004600ba7306ULL, 0x000722000020d400ULL,
0x0001000061617824ULL, 0x004fe200078e00ffULL, 0x000000b0ac00720bULL, 0x002fe40003fdd000ULL,
0x00000001b4b44812ULL, 0x000fe400078efcffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000002c00457306ULL, 0x000fe20000209400ULL, 0x000100002d467824ULL, 0x008fe200078e00ffULL,
0x00000001b3b31812ULL, 0x000fc400078efcffULL, 0x0000006acd00720bULL, 0x000fe40003f3d000ULL,
0x00000018ff607819ULL, 0x000fe40000011446ULL, 0x0000002c00f67306ULL, 0x000e620000205400ULL,
0x00000001baba2812ULL, 0x010fe400078efcffULL, 0x00000001c3c36812ULL, 0x000fca00078efcffULL,
0x0000006200ad7306ULL, 0x000fe20000009400ULL, 0x00000001a3a31812ULL, 0x000fce00078efcffULL,
0x0000006200c87306ULL, 0x000ea20000005400ULL, 0x000000f64500720bULL, 0x002fce0003f5d000ULL,
0x00000062006c7306ULL, 0x000e70000000d400ULL, 0x0000002d00627306ULL, 0x000fe20000009400ULL,
0x000000c8ad00720bULL, 0x004fce0003fbd000ULL, 0x0000002d00897306ULL, 0x000fec0000005400ULL,
0x000000016c6c5812ULL, 0x002fe400078efcffULL, 0x0000002d00bf7306ULL, 0x0003e2000000d400ULL,
0x000000868500720bULL, 0x000fe40003fbd000ULL, 0x0000006c9090723eULL, 0x000fca00000010ffULL,
0x0000001100b97306ULL, 0x000fe20000209400ULL, 0x000001002e2d7824ULL, 0x002fca00078e00ffULL,
0x00000001c7c75812ULL, 0x000fe400078efcffULL, 0x0000001100b87306ULL, 0x000fe20000205400ULL,
0x000000ecc900720bULL, 0x000fce0003fbd000ULL, 0x0000001100187306ULL, 0x000fec000020d400ULL,
0x00000001c4c45812ULL, 0x000fe400078efcffULL, 0x0000001400b57306ULL, 0x000ff00000209400ULL,
0x0000001400757306ULL, 0x000ff00000205400ULL, 0x0000001400117306ULL, 0x000ff0000020d400ULL,
0x0000008200dc7306ULL, 0x000ff00000209400ULL, 0x0000008200da7306ULL, 0x000ff00000205400ULL,
0x0000008200147306ULL, 0x000ff0000020d400ULL, 0x0000006100c57306ULL, 0x000ff00000209400ULL,
0x0000006100eb7306ULL, 0x000e700000205400ULL, 0x0000006100827306ULL, 0x0005f0000020d400ULL,
0x0000002c00c27306ULL, 0x000722000020d400ULL, 0x00000018ff617819ULL, 0x004fc4000001142dULL,
0x000000ebc500720bULL, 0x002fe40003fdd000ULL, 0x00000018ffeb7819ULL, 0x000fc600000114cfULL,
0x00000061002d7306ULL, 0x000fe20000209400ULL, 0x000001002f2c7824ULL, 0x008fce00078e00ffULL,
0x0000006100f47306ULL, 0x000e620000205400ULL, 0x00000001c2c22812ULL, 0x010fe400078efcffULL,
0x0000000182826812ULL, 0x000fe400078efcffULL, 0x000000896200720bULL, 0x000fe40003fdd000ULL,
0x000000829393723eULL, 0x000fe200000010ffULL, 0x0000006000467306ULL, 0x000fe20000209400ULL,
0x0001000036827824ULL, 0x000fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x0000006000f57306ULL, 0x000ea20000205400ULL, 0x000000f42d00720bULL, 0x002fe40003f5d000ULL,
0x00000001bfbf6812ULL, 0x000fca00078efcffULL, 0x0000006000bb7306ULL, 0x0003f0000020d400ULL,
0x0000006100af7306ULL, 0x000ee2000020d400ULL, 0x00000018ff607819ULL, 0x002fe4000001142cULL,
0x000000f54600720bULL, 0x004fca0003f9d000ULL, 0x00000060002c7306ULL, 0x000ff00000209400ULL,
0x0000006000447306ULL, 0x000e620000205400ULL, 0x00000001afaf2812ULL, 0x008fe400078efcffULL,
0x00000001bbbb4812ULL, 0x000fca00078efcffULL, 0x0000006000ab7306ULL, 0x0004f0000020d400ULL,
0x0000002e009c7306ULL, 0x000fe20000009400ULL, 0x000100002e607824ULL, 0x004fe200078e00ffULL,
0x000000442c00720bULL, 0x002fc80003f5d000ULL, 0x00000018fff17819ULL, 0x000fe40000011460ULL,
0x0000002e00e17306ULL, 0x000e6e0000005400ULL, 0x00000001abab2812ULL, 0x008fe200078efcffULL,
0x0000002e00b07306ULL, 0x0004f0000000d400ULL, 0x000000f100607306ULL, 0x000fe20000209400ULL,
0x000100002f2e7824ULL, 0x004fe200078e00ffULL, 0x000000e19c00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff987819ULL, 0x000fe2000001142eULL, 0x00000100282e7824ULL, 0x000fe200078e00ffULL,
0x000000f100e27306ULL, 0x000e680000205400ULL, 0x00000018ffed7819ULL, 0x000fc6000001142eULL,
0x00000001b0b03812ULL, 0x008fe200078efcffULL, 0x0000002f00ce7306ULL, 0x000fe20000009400ULL,
0x0000008f6b00720bULL, 0x000fce0003f7d000ULL, 0x0000002f00ea7306ULL, 0x000ea20000005400ULL,
0x000000e26000720bULL, 0x002fca0003f5d000ULL, 0x00000001a1a13812ULL, 0x000fe400078efcffULL,
0x0000002f00ac7306ULL, 0x000e62000000d400ULL, 0x000000303100720bULL, 0x000fce0003f7d000ULL,
0x000000f100a67306ULL, 0x000722000020d400ULL, 0x000000eace00720bULL, 0x004fca0003fbd000ULL,
0x0000000194943812ULL, 0x000fe400078efcffULL, 0x000000ed002e7306ULL, 0x000fe20000209400ULL,
0x00000018fff17819ULL, 0x008fca000001148bULL, 0x00000001acac5812ULL, 0x002fe400078efcffULL,
0x000000ed002f7306ULL, 0x000e620000205400ULL, 0x00000001a6a62812ULL, 0x010fce00078efcffULL,
0x000000ed00a07306ULL, 0x000eb0000020d400ULL, 0x000000ca009a7306ULL, 0x000fe20000209400ULL,
0x0000002f2e00720bULL, 0x002fe20003f5d000ULL, 0x000001001d2e7824ULL, 0x000fcc00078e00ffULL,
0x000000ca00cc7306ULL, 0x000e6c0000205400ULL, 0x00000001a0a02812ULL, 0x004fe400078efcffULL,
0x0000009800617306ULL, 0x000ff00000209400ULL, 0x0000009800e07306ULL, 0x000ea20000205400ULL,
0x000000cc9a00720bULL, 0x002fce0003f5d000ULL, 0x0000009800a27306ULL, 0x000e70000020d400ULL,
0x0000002800ad7306ULL, 0x000fe20000009400ULL, 0x000000e06100720bULL, 0x004fce0003fbd000ULL,
0x0000002800c87306ULL, 0x000eac0000005400ULL, 0x00000001a2a25812ULL, 0x002fe400078efcffULL,
0x00000028009f7306ULL, 0x0002f0000000d400ULL, 0x000000ca00987306ULL, 0x000f22000020d400ULL,
0x0001000029287824ULL, 0x002fe200078e00ffULL, 0x000000c8ad00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff887819ULL, 0x000fe20000011428ULL, 0x000001002a287824ULL, 0x000fe200078e00ffULL,
0x000000f100ca7306ULL, 0x000fee0000209400ULL, 0x000000019f9f6812ULL, 0x008fe200078efcffULL,
0x000000f100ed7306ULL, 0x000e620000205400ULL, 0x0000000198982812ULL, 0x010fc400078efcffULL,
0x000000192300720bULL, 0x000fe20003fdd000ULL, 0x000100001d197824ULL, 0x000fc800078e00ffULL,
0x0000002900777306ULL, 0x000fe20000009400ULL, 0x00000018ff197819ULL, 0x000fce0000011419ULL,
0x0000002900ee7306ULL, 0x000ea20000005400ULL, 0x000000edca00720bULL, 0x002fe40003f5d000ULL,
0x000000018a8a6812ULL, 0x000fe400078efcffULL, 0x0000008e1a00720bULL, 0x000fc60003fdd000ULL,
0x0000002900997306ULL, 0x0003f0000000d400ULL, 0x000000f100957306ULL, 0x000ee2000020d400ULL,
0x00000018ff297819ULL, 0x002fe40000011428ULL, 0x000000ee7700720bULL, 0x004fc40003f9d000ULL,
0x0000000184846812ULL, 0x000fc600078efcffULL, 0x0000002900287306ULL, 0x000ff00000209400ULL,
0x0000002900c57306ULL, 0x000e620000205400ULL, 0x0000000195952812ULL, 0x008fe400078efcffULL,
0x0000000199994812ULL, 0x000fc400078efcffULL, 0x000000959494723eULL, 0x000fc600000010ffULL,
0x0000002900877306ULL, 0x0004f0000020d400ULL, 0x000000eb00cf7306ULL, 0x000fe20000209400ULL,
0x000000c52800720bULL, 0x002fe20003f5d000ULL, 0x000100002a297824ULL, 0x004fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x000000eb00e97306ULL, 0x000e6c0000205400ULL,
0x0000000187872812ULL, 0x008fe400078efcffULL, 0x0000002a00477306ULL, 0x000ff00000009400ULL,
0x0000002a00637306ULL, 0x000ea20000005400ULL, 0x000000e9cf00720bULL, 0x002fce0003f5d000ULL,
0x0000002a00897306ULL, 0x0002f0000000d400ULL, 0x0000008800c67306ULL, 0x000fe20000209400ULL,
0x000100002b2a7824ULL, 0x002fe200078e00ffULL, 0x000000634700720bULL, 0x004fc80003f3d000ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000008800cb7306ULL, 0x000e6e0000205400ULL,
0x0000000189891812ULL, 0x008fe200078efcffULL, 0x00000088008b7306ULL, 0x000ea2000020d400ULL,
0x0000008d1b00720bULL, 0x000fe20003f3d000ULL, 0x000100001f1b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x00000029009c7306ULL, 0x000fe20000209400ULL,
0x000000cbc600720bULL, 0x002fca0003f9d000ULL, 0x0000000183831812ULL, 0x000fe400078efcffULL,
0x0000002900f37306ULL, 0x000fe20000205400ULL, 0x000000222100720bULL, 0x000fe20003f3d000ULL,
0x000100005c227824ULL, 0x000fc800078e00ffULL, 0x000000018b8b4812ULL, 0x004fe400078efcffULL,
0x0000002900857306ULL, 0x0003e4000020d400ULL, 0x0000008b8a95723eULL, 0x000fe400000010ffULL,
0x00000089878a723eULL, 0x000fe400000010ffULL, 0x0000000174741812ULL, 0x000fe400078efcffULL,
0x000000eb00887306ULL, 0x000ea2000020d400ULL, 0x0000010024297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a009b7306ULL, 0x000ff00000209400ULL,
0x0000002a00f27306ULL, 0x000fe20000205400ULL, 0x0000000188882812ULL, 0x004fc400078efcffULL,
0x000000f39c00720bULL, 0x000fca0003f5d000ULL, 0x0000002a00867306ULL, 0x0003f0000020d400ULL,
0x0000002400eb7306ULL, 0x000fe20000009400ULL, 0x00010000242a7824ULL, 0x002fe200078e00ffULL,
0x0000000185852812ULL, 0x000fc800078efcffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002400ec7306ULL, 0x000e620000005400ULL, 0x000000858484723eULL, 0x000fce00000010ffULL,
0x00000024007f7306ULL, 0x0004f0000000d400ULL, 0x0000002b00627306ULL, 0x000fe20000009400ULL,
0x0000010025247824ULL, 0x004fe200078e00ffULL, 0x000000eceb00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000002b00e17306ULL, 0x000e6e0000005400ULL,
0x000000017f7f3812ULL, 0x008fe200078efcffULL, 0x0000002900c97306ULL, 0x000ff00000209400ULL,
0x0000002900f17306ULL, 0x000ea20000205400ULL, 0x000000e16200720bULL, 0x002fce0003fbd000ULL,
0x0000002900807306ULL, 0x0002f0000020d400ULL, 0x0000002400a87306ULL, 0x000fe20000209400ULL,
0x0001000025297824ULL, 0x002fe200078e00ffULL, 0x000000f1c900720bULL, 0x004fc80003f5d000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002400ef7306ULL, 0x000e6e0000205400ULL,
0x0000000180802812ULL, 0x008fe200078efcffULL, 0x00000024007e7306ULL, 0x0004f0000020d400ULL,
0x0000002b008c7306ULL, 0x000f22000000d400ULL, 0x0000010027247824ULL, 0x004fe200078e00ffULL,
0x000000efa800720bULL, 0x002fc80003f7d000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000029006e7306ULL, 0x000fee0000209400ULL, 0x000000017e7e3812ULL, 0x008fe200078efcffULL,
0x0000002900a77306ULL, 0x000fe20000205400ULL, 0x000000018c8c5812ULL, 0x010fc400078efcffULL,
0x000000f29b00720bULL, 0x000fe40003fbd000ULL, 0x0000008c888b723eULL, 0x000fc600000010ffULL,
0x0000002900767306ULL, 0x000ff0000020d400ULL, 0x0000002500ce7306ULL, 0x000fe20000009400ULL,
0x0000000186865812ULL, 0x000fe400078efcffULL, 0x000000646d00720bULL, 0x000fc40003fbd000ULL,
0x00000018ff647819ULL, 0x000fe20000011422ULL, 0x000100005d227824ULL, 0x000fe200078e00ffULL,
0x000000868385723eULL, 0x000fe200000010ffULL, 0x0000002500ea7306ULL, 0x000e620000005400ULL,
0x0000007f8086723eULL, 0x000fce00000010ffULL, 0x00000025007c7306ULL, 0x0004e2000000d400ULL,
0x0000000179795812ULL, 0x000fce00078efcffULL, 0x00000024002d7306ULL, 0x000fe20000209400ULL,
0x0000010026257824ULL, 0x004fe200078e00ffULL, 0x000000eace00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000002400297306ULL, 0x000e6e0000205400ULL,
0x000000017c7c4812ULL, 0x008fe200078efcffULL, 0x0000002400697306ULL, 0x0004e6000020d400ULL,
0x0000007c7e87723eULL, 0x000fca00000010ffULL, 0x0000002600ad7306ULL, 0x000fe20000009400ULL,
0x0001000026247824ULL, 0x004fe200078e00ffULL, 0x000000292d00720bULL, 0x002fe20003f3d000ULL,
0x000001005f297824ULL, 0x000fc600078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe40000011424ULL,
0x0000002600c87306ULL, 0x000e620000005400ULL, 0x00000018ff2d7819ULL, 0x000fcc0000011429ULL,
0x0000000169691812ULL, 0x008fe200078efcffULL, 0x0000002600777306ULL, 0x0004e2000000d400ULL,
0x000000e6e500720bULL, 0x000fce0003f3d000ULL, 0x0000002a00ae7306ULL, 0x000fe20000209400ULL,
0x0001000027267824ULL, 0x004fe200078e00ffULL, 0x000000c8ad00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002a00f07306ULL, 0x000e620000205400ULL,
0x0000000168681812ULL, 0x000fcc00078efcffULL, 0x0000000177776812ULL, 0x008fe200078efcffULL,
0x00000026002b7306ULL, 0x000ff00000209400ULL, 0x00000026002c7306ULL, 0x000fe20000205400ULL,
0x000000f0ae00720bULL, 0x002fce0003f5d000ULL, 0x0000002600607306ULL, 0x0003f0000020d400ULL,
0x0000002500457306ULL, 0x000fe20000209400ULL, 0x00000018ff267819ULL, 0x002fce000001142eULL,
0x0000002500467306ULL, 0x000e700000205400ULL, 0x0000002500787306ULL, 0x000eb0000020d400ULL,
0x0000002700257306ULL, 0x000fe20000009400ULL, 0x000000464500720bULL, 0x002fce0003fbd000ULL,
0x0000002700447306ULL, 0x000e6c0000005400ULL, 0x0000000178785812ULL, 0x004fe400078efcffULL,
0x00000027006a7306ULL, 0x0004e4000000d400ULL, 0x000000777878723eULL, 0x000fcc00000010ffULL,
0x00000026002e7306ULL, 0x000fe20000209400ULL, 0x000001001c277824ULL, 0x004fe200078e00ffULL,
0x000000442500720bULL, 0x002fc80003f7d000ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002600e07306ULL, 0x000fee0000205400ULL, 0x000000016a6a3812ULL, 0x008fe200078efcffULL,
0x00000026002f7306ULL, 0x0003e2000020d400ULL, 0x000000aae700720bULL, 0x000fce0003f7d000ULL,
0x0000001c00477306ULL, 0x000fe20000009400ULL, 0x000100001c267824ULL, 0x002fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000001c00637306ULL, 0x000e620000005400ULL,
0x0000000133333812ULL, 0x000fe400078efcffULL, 0x000000dd6500720bULL, 0x000fca0003f7d000ULL,
0x0000001c00627306ULL, 0x0004f0000000d400ULL, 0x0000002a007d7306ULL, 0x000f22000020d400ULL,
0x000001001e1c7824ULL, 0x004fe200078e00ffULL, 0x000000634700720bULL, 0x002fc40003f9d000ULL,
0x000000003244783bULL, 0x000fe20000000200ULL, 0x0000000120203812ULL, 0x000fe400078efcffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001d008f7306ULL, 0x000fee0000009400ULL,
0x0000000162624812ULL, 0x008fe200078efcffULL, 0x0000001d009a7306ULL, 0x000e620000005400ULL,
0x000000017d7d2812ULL, 0x010fc400078efcffULL, 0x000000a76e00720bULL, 0x000fca0003f5d000ULL,
0x0000001d00307306ULL, 0x0004f0000000d400ULL, 0x0000001c00ca7306ULL, 0x000fe20000209400ULL,
0x000001001f1d7824ULL, 0x004fe200078e00ffULL, 0x0000000176762812ULL, 0x000fc400078efcffULL,
0x0000009a8f00720bULL, 0x002fe40003f5d000ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00cb7306ULL, 0x000e620000205400ULL, 0x00000002ff9a7819ULL, 0x000fce00000116fbULL,
0x0000001c00287306ULL, 0x000522000020d400ULL, 0x0000000130302812ULL, 0x008fce00078efcffULL,
0x000000cd002a7306ULL, 0x000fe20000209400ULL, 0x000100001e1c7824ULL, 0x004fe200078e00ffULL,
0x000000cbca00720bULL, 0x002fcc0003f7d000ULL, 0x000000cd00247306ULL, 0x000e6e0000205400ULL,
0x0000000128283812ULL, 0x010fe200078efcffULL, 0x000000cd006b7306ULL, 0x000eb0000020d400ULL,
0x0000001900cc7306ULL, 0x000fe20000209400ULL, 0x000000242a00720bULL, 0x002fe20003fbd000ULL,
0x000100005e2a7824ULL, 0x000fcc00078e00ffULL, 0x0000001900cd7306ULL, 0x000e6c0000205400ULL,
0x000000016b6b5812ULL, 0x004fe400078efcffULL, 0x0000001900237306ULL, 0x000ea2000020d400ULL,
0x0000002c2b00720bULL, 0x000fe40003fbd000ULL, 0x00000071e32c723eULL, 0x000fc400000010ffULL,
0x0000006b6868723eULL, 0x000fc600000010ffULL, 0x0000001d00c67306ULL, 0x000fe20000209400ULL,
0x000000cdcc00720bULL, 0x002fca0003f5d000ULL, 0x0000000160605812ULL, 0x000fe400078efcffULL,
0x0000001d00c57306ULL, 0x000fec0000205400ULL, 0x0000000123232812ULL, 0x004fe400078efcffULL,
0x0000001d00197306ULL, 0x0003f0000020d400ULL, 0x0000001f00ce7306ULL, 0x000fe20000009400ULL,
0x00000018ff1d7819ULL, 0x002fce000001141cULL, 0x0000001f00cf7306ULL, 0x000ff00000005400ULL,
0x0000001f001a7306ULL, 0x000ff0000000d400ULL, 0x0000001d00ea7306ULL, 0x000ff00000209400ULL,
0x0000001d00e97306ULL, 0x000e700000205400ULL, 0x0000001d001f7306ULL, 0x0004f0000020d400ULL,
0x0000002700f47306ULL, 0x000fe20000209400ULL, 0x000001005d1d7824ULL, 0x004fe200078e00ffULL,
0x000000e9ea00720bULL, 0x002fc80003f7d000ULL, 0x00000018fff17819ULL, 0x000fe4000001141dULL,
0x0000002700f57306ULL, 0x000e6e0000205400ULL, 0x000000011f1f3812ULL, 0x008fe200078efcffULL,
0x0000002700617306ULL, 0x000ea2000020d400ULL, 0x0000009e9d00720bULL, 0x000fce0003f7d000ULL,
0x0000001e00ed7306ULL, 0x000fe20000009400ULL, 0x000000f5f400720bULL, 0x002fca0003f3d000ULL,
0x0000000100003812ULL, 0x000fe400078efcffULL, 0x0000001e00ee7306ULL, 0x000e6c0000005400ULL,
0x0000000161611812ULL, 0x004fe400078efcffULL, 0x0000001e00277306ULL, 0x0004e2000000d400ULL,
0x000000e02e00720bULL, 0x000fc40003f3d000ULL, 0x000000626162723eULL, 0x000fca00000010ffULL,
0x0000005c00c87306ULL, 0x000fe20000009400ULL, 0x000001005c1e7824ULL, 0x004fe200078e00ffULL,
0x000000eeed00720bULL, 0x002fc80003fbd000ULL, 0x000000012f2f1812ULL, 0x000fe400078efcffULL,
0x0000005c00c97306ULL, 0x000e620000005400ULL, 0x000000cfce00720bULL, 0x000fcc0003f3d000ULL,
0x0000000127275812ULL, 0x008fe200078efcffULL, 0x0000005c001d7306ULL, 0x0004e2000000d400ULL,
0x000000a4a500720bULL, 0x000fca0003fbd000ULL, 0x000000011a1a1812ULL, 0x000fe400078efcffULL,
0x0000002600e17306ULL, 0x000fe20000209400ULL, 0x00000018ff5c7819ULL, 0x004fe40000011422ULL,
0x000000c9c800720bULL, 0x002fc60003f5d000ULL, 0x0000000102025812ULL, 0x000fe400078efcffULL,
0x0000002600e27306ULL, 0x000e700000205400ULL, 0x0000002600317306ULL, 0x000522000020d400ULL,
0x000000011d1d2812ULL, 0x008fce00078efcffULL, 0x0000001b00ec7306ULL, 0x000fe20000209400ULL,
0x00000018ff267819ULL, 0x004fe4000001141eULL, 0x000000e2e100720bULL, 0x002fca0003f9d000ULL,
0x0000001b00eb7306ULL, 0x000e700000205400ULL, 0x0000001b001c7306ULL, 0x000ea2000020d400ULL,
0x0000000131314812ULL, 0x010fe400078efcffULL, 0x000000b8b900720bULL, 0x000fca0003f9d000ULL,
0x000000f1008e7306ULL, 0x000ff00000209400ULL, 0x000000f1008d7306ULL, 0x000fe20000205400ULL,
0x0000000118184812ULL, 0x000fe400078efcffULL, 0x000000c5c600720bULL, 0x000fca0003f9d000ULL,
0x000000f1001b7306ULL, 0x000ff0000020d400ULL, 0x0000005c00f27306ULL, 0x000fe20000209400ULL,
0x0000000119194812ULL, 0x000fe400078efcffULL, 0x000000ebec00720bULL, 0x002fc40003f9d000ULL,
0x0000001a1919723eULL, 0x000fc600000010ffULL, 0x0000005c00f17306ULL, 0x000ff00000205400ULL,
0x0000005c00227306ULL, 0x0003e2000020d400ULL, 0x000000011c1c4812ULL, 0x004fce00078efcffULL,
0x00000026009c7306ULL, 0x000fe20000209400ULL, 0x0000000dff5c723eULL, 0x002fce00000010ffULL,
0x00000026009b7306ULL, 0x000e700000205400ULL, 0x00000026001e7306ULL, 0x000eb0000020d400ULL,
0x0000006400f07306ULL, 0x000fe20000209400ULL, 0x0000009b9c00720bULL, 0x002fce0003f7d000ULL,
0x0000006400ef7306ULL, 0x000e6c0000205400ULL, 0x000000011e1e3812ULL, 0x004fe400078efcffULL,
0x0000006400267306ULL, 0x000ea2000020d400ULL, 0x0000007b7a00720bULL, 0x000fe40003f7d000ULL,
0x0000001d1e1a723eULL, 0x000fca00000010ffULL, 0x0000002d00647306ULL, 0x000fe20000209400ULL,
0x000000eff000720bULL, 0x002fca0003f5d000ULL, 0x0000000117173812ULL, 0x000fe400078efcffULL,
0x0000002d00637306ULL, 0x000fec0000205400ULL, 0x0000000126262812ULL, 0x004fe400078efcffULL,
0x0000002d00297306ULL, 0x0003e4000020d400ULL, 0x000000261726723eULL, 0x000fcc00000010ffULL,
0x0000005d00ad7306ULL, 0x000fe20000009400ULL, 0x000054105c2d7816ULL, 0x002fe4000000005cULL,
0x00000018ff5c7819ULL, 0x000fe4000001142aULL, 0x00009910a92a7816ULL, 0x000fe200000000ffULL,
0x00001ffa2d8f7589ULL, 0x000e6400000e0000ULL, 0x0000005d00ae7306ULL, 0x000ea20000005400ULL,
0x000000ff2a00720cULL, 0x000fe20003fc5270ULL, 0x00001f9a2d9a7589ULL, 0x00072c00000e0000ULL,
0x0000005d00217306ULL, 0x000b22000000d400ULL, 0x00000070e42d723eULL, 0x008fce00000010ffULL,
0x0000005c00f67306ULL, 0x000fe20000209400ULL, 0x000001005e5d7824ULL, 0x020fe200078e00ffULL,
0x000000aead00720bULL, 0x004fc80003f3d000ULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000008f4545e231ULL, 0x082fe200003400ffULL, 0x0000005c00f37306ULL, 0x000fe20000205400ULL,
0x0000008f4747e231ULL, 0x000fe400003400ffULL, 0x0000009a4444e231ULL, 0x090fe400003400ffULL,
0x0000009a4646e231ULL, 0x000fe400003400ffULL, 0x0000000121211812ULL, 0x000fe200078efcffULL,
0x0000005d006d7306ULL, 0x000fe20000209400ULL, 0x00000075b500720bULL, 0x000fc60003f3d000ULL,
0x0000002c4440723cULL, 0x040fe80000041840ULL, 0x0000005d006e7306ULL, 0x000e680000205400ULL,
0x00000092443c723cULL, 0x000fe4000004183cULL, 0x0000000111111812ULL, 0x000fc400078efcffULL,
0x0000005d00257306ULL, 0x0004e2000020d400ULL, 0x000000636400720bULL, 0x000fe40003f3d000ULL,
0x000000bab492723eULL, 0x000fe200000010ffULL, 0x00000090444c723cULL, 0x000fe2000004184cULL,
0x000000bbb393723eULL, 0x000fe400000010ffULL, 0x000000302f63723eULL, 0x000fe200000010ffULL,
0x0000005c002a7306ULL, 0x0009e2000020d400ULL, 0x000000de735d723eULL, 0x004fe400000010ffULL,
0x000000b0af90723eULL, 0x000fc400000010ffULL, 0x000000acab91723eULL, 0x000fe400000010ffULL,
0x0000000129291812ULL, 0x000fe200078efcffULL, 0x0000005e00a77306ULL, 0x000fe20000009400ULL,
0x000000df725c723eULL, 0x010fe400000010ffULL, 0x0000006e6d00720bULL, 0x002fe40003f7d000ULL,
0x000000d4d700720bULL, 0x000fe40003f3d000ULL, 0x000000312030723eULL, 0x000fe200000010ffULL,
0x0000005c4438723cULL, 0x000fe20000041838ULL, 0x0000005e00a87306ULL, 0x000e620000005400ULL,
0x000000231831723eULL, 0x000fc400000010ffULL, 0x000000272818723eULL, 0x000fc600000010ffULL,
0x00000066db5c723eULL, 0x000fe400000010ffULL, 0x000000676f5d723eULL, 0x000fe200000010ffULL,
0x0000005e00247306ULL, 0x000ea2000000d400ULL, 0x0000000125253812ULL, 0x008fe400078efcffULL,
0x0000000112121812ULL, 0x000fe400078efcffULL, 0x000000f3f600720bULL, 0x000fe20003f7d000ULL,
0x0000005c4454723cULL, 0x040fe20000041854ULL, 0x000000a8a700720bULL, 0x002fe20003fbd000ULL,
0x0000005f00a97306ULL, 0x000fea0000009400ULL, 0x000000d6d15c723eULL, 0x000fe200000010ffULL,
0x000100005fd17824ULL, 0x000fe200078e00ffULL, 0x000000d5d05d723eULL, 0x000fe200000010ffULL,
0x0000005f00aa7306ULL, 0x000e620000005400ULL, 0x0001380097d67811ULL, 0x000fe200078e20ffULL,
0x0001000034d07824ULL, 0x000fe200078e00ffULL, 0x000000c3d397723eULL, 0x000fe200000010ffULL,
0x0000010035d57824ULL, 0x040fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fe200000114d1ULL,
0x0001000035c37824ULL, 0x000fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x0000005f002b7306ULL, 0x000722000000d400ULL, 0x00000018ffd57819ULL, 0x000fe200000114d5ULL,
0x000000964450723cULL, 0x000fe20000041850ULL, 0x0000000124245812ULL, 0x004fc400078efcffULL,
0x000000b7bc00720bULL, 0x000fe40003fbd000ULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x0000003400707306ULL, 0x000fe20000009400ULL, 0x0000010037967824ULL, 0x000fe200078e00ffULL,
0x0000005c445c723cULL, 0x008fe20000041858ULL, 0x00000000d658783bULL, 0x0004e20000000200ULL,
0x000000aaa900720bULL, 0x002fe40003f9d000ULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x0000003400717306ULL, 0x000e620000005400ULL, 0x000000012a2a3812ULL, 0x000fc400078efcffULL,
0x00000018ffd67819ULL, 0x004fe20000011481ULL, 0x0001000037817824ULL, 0x000fe200078e00ffULL,
0x0000000116165812ULL, 0x000fe400078efcffULL, 0x000000242524723eULL, 0x000fe200000010ffULL,
0x00000034002c7306ULL, 0x000562000000d400ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x000000012b2b4812ULL, 0x010fe400078efcffULL, 0x0000002a1616723eULL, 0x000fc400000010ffULL,
0x0000002b2925723eULL, 0x000fe200000010ffULL, 0x0000003500727306ULL, 0x000fe20000009400ULL,
0x000000c7be34723eULL, 0x004fe400000010ffULL, 0x000000717000720bULL, 0x002fca0003f5d000ULL,
0x0000003500737306ULL, 0x000ff00000005400ULL, 0x00000035002d7306ULL, 0x0003e2000000d400ULL,
0x000000012c2c2812ULL, 0x020fe200078efcffULL, 0x0000009a5858e231ULL, 0x008fc400003400ffULL,
0x0000009a5a5ae231ULL, 0x000fe400003400ffULL, 0x0000008f5959e231ULL, 0x080fe400003400ffULL,
0x0000003600657306ULL, 0x000fe20000009400ULL, 0x000000c4bd35723eULL, 0x002fe200000010ffULL,
0x0000008f5b5be231ULL, 0x000fcc00003400ffULL, 0x0000003600667306ULL, 0x000e620000005400ULL,
0x000000344444723cULL, 0x000fee0000041848ULL, 0x00000036002e7306ULL, 0x0004e2000000d400ULL,
0x00013800b2347811ULL, 0x000fe200078e20ffULL, 0x000000925838723cULL, 0x000fe20000041838ULL,
0x00013800b1487811ULL, 0x000fca00078e20ffULL, 0x0000003700677306ULL, 0x000fe20000009400ULL,
0x000000c0c136723eULL, 0x004fe200000010ffULL, 0x000000004848783bULL, 0x000ea20000000200ULL,
0x000000a6a392723eULL, 0x000fe200000010ffULL, 0x000000905854723cULL, 0x040fe20000041854ULL,
0x000000a2a193723eULL, 0x000fe400000010ffULL, 0x000000666500720bULL, 0x002fe20003f7d000ULL,
0x00000037006f7306ULL, 0x000fe60000005400ULL, 0x0000009fa090723eULL, 0x000fe200000010ffULL,
0x00000092585c723cULL, 0x000fe2000004185cULL, 0x000000999891723eULL, 0x000fc600000010ffULL,
0x0000003700327306ULL, 0x0003e8000000d400ULL, 0x00000094583c723cULL, 0x000fe2000004183cULL,
0x000000012e2e3812ULL, 0x008fc600078efcffULL, 0x000000d000a17306ULL, 0x000fe20000209400ULL,
0x000000bfc237723eULL, 0x002fc600000010ffULL, 0x0000008a584c723cULL, 0x040fe8000004184cULL,
0x000000d000927306ULL, 0x000e680000205400ULL, 0x000000365840723cULL, 0x000fe20000041840ULL,
0x000000003434783bULL, 0x000ee60000000200ULL, 0x000000d100d37306ULL, 0x000fe20000209400ULL,
0x0000009a4848e231ULL, 0x004fc400003400ffULL, 0x0000009a4a4ae231ULL, 0x000fe200003400ffULL,
0x000000905850723cULL, 0x000fe20000041850ULL, 0x0000008f4949e231ULL, 0x080fe400003400ffULL,
0x0000008f4b4be231ULL, 0x000fe200003400ffULL, 0x000000d100d27306ULL, 0x000ea20000205400ULL,
0x00000092a100720bULL, 0x002fc60003f5d000ULL, 0x000000845844723cULL, 0x000fe80000041844ULL,
0x000000d1006c7306ULL, 0x000e66000020d400ULL, 0x0000007d7958723eULL, 0x000fe400000010ffULL,
0x000000767459723eULL, 0x000fe400000010ffULL, 0x0000006a6979723eULL, 0x000fe200000010ffULL,
0x000000d600d17306ULL, 0x000fe20000209400ULL, 0x000000603369723eULL, 0x000fc400000010ffULL,
0x000000d2d300720bULL, 0x004fca0003f9d000ULL, 0x000000d600bd7306ULL, 0x000ea20000205400ULL,
0x0000009a3434e231ULL, 0x088fe400003400ffULL, 0x0000009a3636e231ULL, 0x000fe400003400ffULL,
0x0000008f3535e231ULL, 0x000fc600003400ffULL, 0x000000d500b87306ULL, 0x000fe20000209400ULL,
0x0000008f3737e231ULL, 0x000fe200003400ffULL, 0x0000008d8e00720bULL, 0x000fe40003fdd000ULL,
0x000000016c6c4812ULL, 0x002fe400078efcffULL, 0x0000006f6700720bULL, 0x000fe40003f9d000ULL,
0x000000d500b17306ULL, 0x000e620000205400ULL, 0x000000863440723cULL, 0x000fe20000041840ULL,
0x000000bdd100720bULL, 0x004fc40003fbd000ULL, 0x0000006c1217723eULL, 0x000fc600000010ffULL,
0x000000011b1b6812ULL, 0x000fe200078efcffULL, 0x000000d000907306ULL, 0x000ea2000020d400ULL,
0x000000f1f200720bULL, 0x000fe20003fdd000ULL, 0x000000583438723cULL, 0x000fe20000041838ULL,
0x000000211b1b723eULL, 0x000fe400000010ffULL, 0x0000000132324812ULL, 0x000fc600078efcffULL,
0x000000b6005a7306ULL, 0x000fe20000209400ULL, 0x000000b1b800720bULL, 0x002fe20003f3d000ULL,
0x00000030343c723cULL, 0x040fe8000004183cULL, 0x0000000122226812ULL, 0x000fe400078efcffULL,
0x000000b600597306ULL, 0x000e620000205400ULL, 0x000000737200720bULL, 0x000fe20003fdd000ULL,
0x00000018344c723cULL, 0x000fe2000004184cULL, 0x0000001c0031723eULL, 0x000fc400000010ffULL,
0x0000000190902812ULL, 0x004fe400078efcffULL, 0x0000001f0230723eULL, 0x000fe200000010ffULL,
0x000000d600977306ULL, 0x000ea2000020d400ULL, 0x000000221127723eULL, 0x000fe200000010ffULL,
0x0000001a4840723cULL, 0x000fe80000041840ULL, 0x000000012d2d6812ULL, 0x000fe400078efcffULL,
0x000000d500ab7306ULL, 0x000ee2000020d400ULL, 0x000000595a00720bULL, 0x002fe20003f5d000ULL,
0x000000783454723cULL, 0x000fe20000041854ULL, 0x000000e8f700720bULL, 0x000fca0003fdd000ULL,
0x000000c300837306ULL, 0x000fe20000209400ULL, 0x0000000197975812ULL, 0x004fe200078efcffULL,
0x00000068345c723cULL, 0x000fe2000004185cULL, 0x000000f8f900720bULL, 0x000fe40003fbd000ULL,
0x0000002c972c723eULL, 0x000fc600000010ffULL, 0x000000c300887306ULL, 0x000e620000205400ULL,
0x00000001abab1812ULL, 0x008fe200078efcffULL, 0x000000623450723cULL, 0x000fe20000041850ULL,
0x0000000110106812ULL, 0x000fe400078efcffULL, 0x0000002dab2d723eULL, 0x000fc600000010ffULL,
0x000000b600337306ULL, 0x000ea2000020d400ULL, 0x0000000115155812ULL, 0x000fe200078efcffULL,
0x000000303444723cULL, 0x000fe20000041844ULL, 0x000000dadc00720bULL, 0x000fe40003fbd000ULL,
0x00000090157a723eULL, 0x000fc600000010ffULL, 0x0000008200007306ULL, 0x000fe20000209400ULL,
0x000000888300720bULL, 0x002fe20003f3d000ULL, 0x000000264838723cULL, 0x040fec0000041838ULL,
0x0000008200197306ULL, 0x000e620000205400ULL, 0x0000000133332812ULL, 0x004fe200078efcffULL,
0x000000244854723cULL, 0x000fe20000041854ULL, 0x0000000114145812ULL, 0x000fc400078efcffULL,
0x0000002e332e723eULL, 0x000fc600000010ffULL, 0x000000c3007b7306ULL, 0x000ea4000020d400ULL,
0x000000164858723cULL, 0x040fec000004185cULL, 0x00000096002f7306ULL, 0x000fe20000209400ULL,
0x000000190000720bULL, 0x002fe20003f5d000ULL, 0x0000002c4850723cULL, 0x000fec0000041850ULL,
0x0000009600207306ULL, 0x000e620000205400ULL, 0x000000017b7b1812ULL, 0x004fc400078efcffULL,
0x000000d8d900720bULL, 0x000fe40003f3d000ULL, 0x0000007b107b723eULL, 0x000fc600000010ffULL,
0x0000008100027306ULL, 0x000fe80000209400ULL, 0x0000007a483c723cULL, 0x000fe8000004183cULL,
0x00000081001b7306ULL, 0x000ea20000205400ULL, 0x000000202f00720bULL, 0x002fe40003fdd000ULL,
0x000000010f0f1812ULL, 0x000fca00078efcffULL, 0x0000009600237306ULL, 0x000e70000020d400ULL,
0x0000008200117306ULL, 0x000ee2000020d400ULL, 0x0000001b0200720bULL, 0x004fce0003f7d000ULL,
0x0000008100007306ULL, 0x000ea2000020d400ULL, 0x0000000123236812ULL, 0x002fc800078efcffULL,
0x00000032232f723eULL, 0x000fe400000010ffULL, 0x0000000111112812ULL, 0x008fc800078efcffULL,
0x000000111414723eULL, 0x000fe200000010ffULL, 0x0000002e484c723cULL, 0x000fe2000004184cULL,
0x0000000100003812ULL, 0x004fc800078efcffULL, 0x000000000f15723eULL, 0x000fe400000010ffULL,
0x000000010e007812ULL, 0x000fca000784c0ffULL, 0x000000144848723cULL, 0x000fe20000041844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c64000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000099100c027816ULL, 0x000fc800000000ffULL,
0x000000ff0200720cULL, 0x000fe40003f25270ULL, 0x00000001ff027807ULL, 0x000fe40004000000ULL,
0x00000001ff13a807ULL, 0x000fc80000800000ULL, 0x00007610130c7816ULL, 0x000fe4000000000cULL,
0x00000800010e7983ULL, 0x000ea20000300800ULL, 0x0000030005057a10ULL, 0x000fc80007ffe0ffULL,
0x000000070500720cULL, 0x000fe40003f26070ULL, 0x000000ff0eff7812ULL, 0x004fc8000780c0ffULL,
0x00000001ff0e7807ULL, 0x000fca0000000000ULL, 0x0000080e01007387ULL, 0x0005e40000100600ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xfffece6000007947ULL, 0x000fea000383ffffULL,
0x0000000000107919ULL, 0x002e640000002500ULL, 0x000000071000720cULL, 0x002fda0003f06070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000000b007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e000bULL, 0x0001441000087802ULL, 0x000fe40000000f00ULL,
0x0000af2000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0006ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc8000000000bULL, 0x800000ff02057221ULL, 0x000fc80000010100ULL,
0x0000000500007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff057624ULL, 0x000fe400078e00ffULL, 0x00006800ff047624ULL, 0x000fca00078e00ffULL,
0x0000000604057981ULL, 0x000ee8000c1e9900ULL, 0x0000000000077919ULL, 0x000f240000000000ULL,
0x00000002ff097819ULL, 0x030fe40000011607ULL, 0x0000000807077811ULL, 0x000fe200078ff0ffULL,
0x0000000005007220ULL, 0x008fca0000410000ULL, 0x00001f0900027589ULL, 0x000ee800000e0000ULL,
0x00001f0700077589ULL, 0x000f2200000e0000ULL, 0x0000004002407220ULL, 0x048fe40000410000ULL,
0x0000004102417220ULL, 0x040fe40000410000ULL, 0x0000003802387220ULL, 0x040fe40000410000ULL,
0x0000003902397220ULL, 0x000fc40000410000ULL, 0x0000005402547220ULL, 0x040fe40000410000ULL,
0x0000005502557220ULL, 0x040fe40000410000ULL, 0x0000005802587220ULL, 0x040fe40000410000ULL,
0x0000005902597220ULL, 0x040fe40000410000ULL, 0x0000005002507220ULL, 0x040fe40000410000ULL,
0x0000005102517220ULL, 0x000fc40000410000ULL, 0x0000003c023c7220ULL, 0x040fe40000410000ULL,
0x0000003d023d7220ULL, 0x040fe40000410000ULL, 0x0000004c024c7220ULL, 0x040fe40000410000ULL,
0x0000004d024d7220ULL, 0x040fe40000410000ULL, 0x0000004802487220ULL, 0x040fe40000410000ULL,
0x0000004902497220ULL, 0x000fc40000410000ULL, 0x0000004207427220ULL, 0x050fe40000410000ULL,
0x0000004307437220ULL, 0x040fe40000410000ULL, 0x0000003a073a7220ULL, 0x040fe40000410000ULL,
0x0000003b073b7220ULL, 0x040fe40000410000ULL, 0x0000005607567220ULL, 0x040fe40000410000ULL,
0x0000005707577220ULL, 0x000fc40000410000ULL, 0x0000005a075a7220ULL, 0x040fe40000410000ULL,
0x0000005b075b7220ULL, 0x040fe40000410000ULL, 0x0000005207527220ULL, 0x040fe40000410000ULL,
0x0000005307537220ULL, 0x040fe40000410000ULL, 0x0000003e073e7220ULL, 0x040fe40000410000ULL,
0x0000003f073f7220ULL, 0x000fc40000410000ULL, 0x0000004e074e7220ULL, 0x040fe40000410000ULL,
0x0000004f074f7220ULL, 0x040fe40000410000ULL, 0x0000004a074a7220ULL, 0x040fe40000410000ULL,
0x0000004b074b7220ULL, 0x000fe40000410000ULL, 0x0000000000127919ULL, 0x000ee80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000212007812ULL, 0x008fc400078ec0ffULL,
0x00000002ff117819ULL, 0x000fe40000011612ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000200047811ULL, 0x040fe400078ff8ffULL, 0x0000000400067811ULL, 0x040fe400078ff8ffULL,
0x00000006000c7811ULL, 0x000fe400078ff8ffULL, 0x0000000812197811ULL, 0x000fc400078ff0ffULL,
0x0000000702007812ULL, 0x100fe400078e7811ULL, 0x0000000706087812ULL, 0x040fe400078e7811ULL,
0x0000000706067812ULL, 0x100fe200078e7819ULL, 0x0000000811077824ULL, 0x000fe200078e0200ULL,
0x0000000702027812ULL, 0x000fe200078e7819ULL, 0x0000080003007824ULL, 0x000fe200078e00ffULL,
0x0000000704057812ULL, 0x100fe200078e7811ULL, 0x0000000819177824ULL, 0x040fe200078e0206ULL,
0x000000070c0e7812ULL, 0x004fe200078e7811ULL, 0x00000008190f7824ULL, 0x000fe200078e0202ULL,
0x0000000704047812ULL, 0x100fe200078e7819ULL, 0x0000000812067824ULL, 0x000fe200078e00ffULL,
0x000000070c0c7812ULL, 0x000fe200078e7819ULL, 0x0000000811097824ULL, 0x060fe200078e0205ULL,
0x0001200000027810ULL, 0x000fe20007ffe0ffULL, 0x00000008110d7824ULL, 0x000fe200078e0208ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x0000000819157824ULL, 0x000fe200078e0204ULL,
0x000000404104723eULL, 0x000fe200000010ffULL, 0x0000000811117824ULL, 0x000fe200078e020eULL,
0x000000383905723eULL, 0x000fe200000010ffULL, 0x0000000819197824ULL, 0x000fe200078e020cULL,
0x000000424308723eULL, 0x000fe200000010ffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x00005410041a7816ULL, 0x140fe20000000005ULL, 0x000000100f137824ULL, 0x100fe200078e0202ULL,
0x00007632041b7816ULL, 0x000fe20000000005ULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x000000505104723eULL, 0x000fe200000010ffULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x0000003c3d05723eULL, 0x000fe200000010ffULL, 0x000000100d0f7824ULL, 0x000fc400078e0202ULL,
0x0000001011117824ULL, 0x100fe400078e0202ULL, 0x0000001017177824ULL, 0x100fe400078e0202ULL,
0x0000001019197824ULL, 0x000fe400078e0202ULL, 0x00000001070c7824ULL, 0x000fe200078e0206ULL,
0x000000585907723eULL, 0x000fe200000010ffULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x00000001060d7824ULL, 0x040fe200078e0209ULL, 0x0000001a0c007388ULL, 0x0005e20000000a00ULL,
0x0000000106157824ULL, 0x040fe200078e0215ULL, 0x0000003a3b09723eULL, 0x000fe200000010ffULL,
0x00000001060f7824ULL, 0x000fc400078e020fULL, 0x0000000106117824ULL, 0x040fe400078e0211ULL,
0x0000000106177824ULL, 0x040fe400078e0217ULL, 0x0000000106197824ULL, 0x000fe200078e0219ULL,
0x000000545506723eULL, 0x000fe400000010ffULL, 0x00005410040c7816ULL, 0x004fe40000000005ULL,
0x00005410061a7816ULL, 0x140fe40000000007ULL, 0x00007632061b7816ULL, 0x000fc40000000007ULL,
0x0000004c4d06723eULL, 0x000fe400000010ffULL, 0x000000484907723eULL, 0x000fe200000010ffULL,
0x0000001a0d007388ULL, 0x0005e40000000a00ULL, 0x00007632040d7816ULL, 0x004fe20000000005ULL,
0x00000300ff1b7624ULL, 0x000fe200078e00ffULL, 0x000000565704723eULL, 0x000fe400000010ffULL,
0x0000005a5b05723eULL, 0x000fe200000010ffULL, 0x0000000c0f007388ULL, 0x0005e20000000a00ULL,
0x000000011b00780cULL, 0x000fc40003f05270ULL, 0x00005410060c7816ULL, 0x144fe40000000007ULL,
0x00007632060d7816ULL, 0x000fe40000000007ULL, 0x000000525306723eULL, 0x000fe400000010ffULL,
0x0000003e3f07723eULL, 0x000fe200000010ffULL, 0x0000000c11007388ULL, 0x0005e40000000a00ULL,
0x00005410080c7816ULL, 0x144fe40000000009ULL, 0x00007632080d7816ULL, 0x000fc40000000009ULL,
0x0000004e4f08723eULL, 0x000fe400000010ffULL, 0x0000004a4b09723eULL, 0x000fe200000010ffULL,
0x0000000c13007388ULL, 0x0005e40000000a00ULL, 0x00005410040c7816ULL, 0x144fe40000000005ULL,
0x00007632040d7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000c15007388ULL, 0x0005e20000000a00ULL,
0x0000541008067816ULL, 0x000fc40000000009ULL, 0x0000763208077816ULL, 0x000fe20000000009ULL,
0x0000000417007388ULL, 0x0005e80000000a00ULL, 0x0000000619007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002cb000008947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x004ea20000000000ULL, 0x000058001b057a24ULL, 0x000fe200078e02ffULL,
0x000000ff0300720cULL, 0x000fe20003f25270ULL, 0x00002000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000187919ULL, 0x000ee80000002700ULL, 0x0000000000077919ULL, 0x000ee20000002600ULL,
0x00000010040c7824ULL, 0x044fe200078e0200ULL, 0x0000002004137810ULL, 0x000fc40007ffe0ffULL,
0x0000004004157810ULL, 0x040fe40007ffe0ffULL, 0x012000000c1c7984ULL, 0x0005220000000c00ULL,
0x0000006004177810ULL, 0x000fe20007ffe0ffULL, 0x0000580018187a24ULL, 0x008fe400078e0207ULL,
0x012200000c207984ULL, 0x0004e20000000c00ULL, 0x0000660005077a24ULL, 0x000fe200078e02ffULL,
0x000000ff0400720cULL, 0x000fe20003f05270ULL, 0x0000030018057a24ULL, 0x000fe200078e02ffULL,
0x012400000c247984ULL, 0x0004640000000c00ULL, 0x00001fff07067811ULL, 0x000fe200078e40ffULL,
0x00000001050d7824ULL, 0x000fe200078e0210ULL, 0x012600000c287984ULL, 0x0004620000000c00ULL,
0x000000ff0300720cULL, 0x000fc60000705670ULL, 0x0000000d06087211ULL, 0x000fca00078f98ffULL,
0x00006c0008087625ULL, 0x000fcc00078e0009ULL, 0x0000080003087825ULL, 0x000fcc00078e0008ULL,
0x0000001013127825ULL, 0x000fc800078e0008ULL, 0x0000001015147825ULL, 0x000fc800078e0008ULL,
0x0000001017167825ULL, 0x000fc800078e0008ULL, 0x0000001004107825ULL, 0x000fe200078e0008ULL,
0x01ffffff07087812ULL, 0x000fe200078ec0ffULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x01cea20000000000ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x000000010d0e7824ULL, 0x040fe400078e0208ULL, 0x00006c000d0c7625ULL, 0x000fc800078e000fULL,
0x00006c000e0e7625ULL, 0x000fc800078e000fULL, 0x0000001007097824ULL, 0x004fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011607ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fc800078ec0ffULL, 0x0000000c070c7210ULL, 0x140fe40007b5e009ULL,
0x0000000e070e7210ULL, 0x000fe40007d9e009ULL, 0x0000000dff0d7210ULL, 0x000fe400017e64ffULL,
0x0000000fff0f7210ULL, 0x000fc600027ea4ffULL, 0x0000000a0c007986ULL, 0x0005e8000c101906ULL,
0x0000000b0e007986ULL, 0x0005e4000c101906ULL, 0x0000001c10007986ULL, 0x01c5e2000c101d06ULL,
0x0000014000007945ULL, 0x000fe60003800000ULL, 0x0000002012007986ULL, 0x0005e8000c101d06ULL,
0x0000002414007986ULL, 0x0025e8000c101d06ULL, 0x0000002816007986ULL, 0x0005e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0xffffffff1b077810ULL, 0x000fc60007ffe0ffULL,
0x00006a00180a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x000000070a0a79a8ULL, 0x000ee400099ee1c6ULL,
0x000000070a00720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff097807ULL, 0x000fca0000000000ULL, 0x00000009ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff077984ULL, 0x000ee40000000000ULL, 0x000000ff0700720cULL, 0x008fda0003f05270ULL,
0x0000284000008947ULL, 0x000fea0003800000ULL, 0x00000d1000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011604ULL, 0x0000001004077824ULL, 0x000fe200078e00ffULL,
0x00000001050c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x002fe200078e00ffULL,
0x0000000c0a117812ULL, 0x004fe400078ec0ffULL, 0x00000070070f7812ULL, 0x000fe200078ec0ffULL,
0x00006c00050a7625ULL, 0x000fc800078e0009ULL, 0x00006c000c0c7625ULL, 0x000fe200078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00fULL, 0x0000000c110c7210ULL, 0x000fe40007b5e00fULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a077981ULL, 0x000368000c1e1900ULL, 0x000000060c0e7981ULL, 0x000362000c1e1900ULL,
0x000000021b00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00fULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a107981ULL, 0x000362000c1e1900ULL, 0x000000041b00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00fULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a127981ULL, 0x000362000c1e1900ULL,
0x000000041b00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00fULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a147981ULL, 0x000362000c1e1900ULL, 0x000000061b00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00fULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a167981ULL, 0x000362000c1e1900ULL,
0x000000061b00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081b00780cULL, 0x002fe40003f06070ULL, 0x00000006050a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fe40007a3e00fULL,
0x00000007050c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e0009ULL, 0x000000060a187981ULL, 0x000366000c1e1900ULL,
0x0000000c110c0210ULL, 0x000fc80007c7e00fULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c1a0981ULL, 0x000368000c1e1900ULL, 0x000000071b097810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff097819ULL, 0x000fc80000011609ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x024fe400078e0007ULL, 0x000000080c0d7824ULL, 0x040fe200078e00ffULL,
0x000000010c0c7810ULL, 0x000fc80007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000000090c00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080d0a7810ULL, 0x040fe40007ffe0ffULL, 0x000000010d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001c07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011604ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010040f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1c7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000020d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000e07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011604ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010040e7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0e7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000030d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff107819ULL, 0x000fe20000011604ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010040f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a107981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000040d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001207077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011604ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010040f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a127981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000050d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001407077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011604ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010040f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a147981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000060d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011604ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010040f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a167981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000070d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001807077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011604ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010040f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a187981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0d0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000001a07077209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0f0a7210ULL, 0x000fc80007a3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a1a7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000047919ULL, 0x000ee40000000000ULL, 0x0000001004097824ULL, 0x008fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x002fc80000011604ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL, 0x00000001090a7824ULL, 0x000fca00078e020aULL,
0x000000070a007388ULL, 0x0203e40000000800ULL, 0x00000005060a7211ULL, 0x002fe200078f98ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00002000ff0b7424ULL, 0x000fe200078e00ffULL,
0x000000070400780cULL, 0x000fe20003f04070ULL, 0x00000800033f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011604ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x00000015ff417819ULL, 0x000fe20000011603ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000c090c7812ULL, 0x000fe200078ec0ffULL, 0x0000001004077824ULL, 0x000fe200078e00ffULL,
0x0000003f0a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000100003277824ULL, 0x004fe200078e00ffULL,
0x00000020040d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x0000000105128824ULL, 0x000fe200078e0208ULL,
0x00000040040f7810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff138424ULL, 0x000fe200078e00ffULL,
0x0000006004117810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200008e0641ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff148424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000107077824ULL, 0x000fe200078e020cULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00006c0012128625ULL, 0x000fe200078e0013ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000007267984ULL, 0x0002a20000000800ULL, 0x000000100d0c7825ULL, 0x100fe200078e000aULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000000100f0e7825ULL, 0x000fc800078e000aULL,
0x0000001011107825ULL, 0x000fc800078e000aULL, 0x00000010031b8824ULL, 0x000fe400078e0204ULL,
0x00006c0005148625ULL, 0x000fc600078e0014ULL, 0x000045801b1b8811ULL, 0x000fe200078e20ffULL,
0x0000001004177824ULL, 0x040fe400078e0227ULL, 0x00000010040a7825ULL, 0x000fc800078e000aULL,
0x00000010031d8824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a177faeULL, 0x0007e2000b901c46ULL, 0x0000001004128825ULL, 0x000fc600078e0012ULL,
0x000041801d1d8811ULL, 0x000fe200078e20ffULL, 0x0000001004148825ULL, 0x000fe200078e0014ULL,
0x003800000c177faeULL, 0x0009e6000b901c46ULL, 0x000000ffff077224ULL, 0x002fe200078e00ffULL,
0x005800000e177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x008fe4000001ff00ULL, 0x0078000010177faeULL, 0x0007e8000b901c46ULL,
0x00000000121b8faeULL, 0x000be2000b901c46ULL, 0x00000000000c7805ULL, 0x010fc6000001ff00ULL,
0x00000000141d8faeULL, 0x0009e2000b901c46ULL, 0x00000000000e7805ULL, 0x002fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x008fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x020fe2000001ff00ULL,
0x0000000000147805ULL, 0x010fe2000001ff00ULL, 0x00000d5000009947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x004fe400078e00ffULL, 0x000000ffff377224ULL, 0x000fca00078e00ffULL,
0x0000000137387810ULL, 0x000fc80007ffe0ffULL, 0x0000030038007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x00000001053d7824ULL, 0x000fe200078e0238ULL,
0x000000070400780cULL, 0x000fe20003f24070ULL, 0x00002000ff1b7424ULL, 0x000fe200078e00ffULL,
0x00000001381e7812ULL, 0x040fe200078ec0ffULL, 0x00000800381c7824ULL, 0x000fe200078e00ffULL,
0x0000003d061a7211ULL, 0x000fe400078f98ffULL, 0x00000020041f7810ULL, 0x000fe40007ffe0ffULL,
0x000008001c1c7812ULL, 0x000fe200078ec0ffULL, 0x00006c001a1a7625ULL, 0x000fe200078e001bULL,
0x0000004004217810ULL, 0x000fc40007ffe0ffULL, 0x00000060043b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001271d7824ULL, 0x000fe200078e021cULL, 0x0000003f1a1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000108229824ULL, 0x000fe400078e023dULL, 0x00000080ff239424ULL, 0x000fe400078e00ffULL,
0x000000011b1b7824ULL, 0x000fe400000e0641ULL, 0x0000000203259824ULL, 0x140fe400078e021eULL,
0x0000000203439824ULL, 0x000fc400078e021eULL, 0x00000080ff249424ULL, 0x000fe400078e00ffULL,
0x0000001004397824ULL, 0x000fe400078e021dULL, 0x000000101f1e7825ULL, 0x000fc800078e001aULL,
0x0000001021207825ULL, 0x000fc800078e001aULL, 0x00000010041c7825ULL, 0x000fc800078e001aULL,
0x000000103b1a7825ULL, 0x000fe200078e001aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800001c397faeULL, 0x0003e6000b901c46ULL, 0x00006c0022229625ULL, 0x000fe200078e0023ULL,
0x003800001e397faeULL, 0x0003e6000b901c46ULL, 0x00000008253b9824ULL, 0x000fe200078e0204ULL,
0x0058000020397faeULL, 0x0003e2000b901c46ULL, 0x00006c003d249625ULL, 0x000fc600078e0024ULL,
0x000045803b3b9811ULL, 0x000fe200078e20ffULL, 0x00000008433d9824ULL, 0x000fe200078e0204ULL,
0x007800001a397faeULL, 0x0003e2000b901c46ULL, 0x0000001004229825ULL, 0x000fc600078e0022ULL,
0x000041803d3d9811ULL, 0x000fe200078e20ffULL, 0x0000001004249825ULL, 0x000fe200078e0024ULL,
0x00000000223b9faeULL, 0x0003e8000b901c46ULL, 0x00000000243d9faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000080371a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff1c7819ULL, 0x100fe20000011604ULL, 0x00000010041b7824ULL, 0x000fe200078e00ffULL,
0x00000002ff507819ULL, 0x000fc40000011604ULL, 0x000000801a1a7812ULL, 0x000fe400078ec0ffULL,
0x000000701b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000008501f7824ULL, 0x000fe200078e00ffULL,
0x0000000c1c1c7812ULL, 0x000fe200078ec0ffULL, 0x00000100031a7824ULL, 0x000fe200078e021aULL,
0x00000007503c7812ULL, 0x040fe200078ec0ffULL, 0x0000000850217824ULL, 0x000fe200078e00ffULL,
0x00000050ff3e7212ULL, 0x000fe400078e33ffULL, 0x0000001a1c1c7210ULL, 0x000fe20007ffe01bULL,
0x00000008501b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1a7812ULL, 0x000fc400078ee23cULL,
0xfffffff8213e7812ULL, 0x000fe400078ee23eULL, 0x000000011b1e7812ULL, 0x000fe200078ef63cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180001c1d7984ULL, 0x000e620000000800ULL,
0x000000021b207812ULL, 0x140fe400078ef63cULL, 0x000000031b227812ULL, 0x140fe200078ef63cULL,
0x004580001c4e7984ULL, 0x0004e20000000800ULL, 0x000000041b247812ULL, 0x140fe400078ef63cULL,
0x000000051b3a7812ULL, 0x140fe400078ef63cULL, 0x000000061b3c7812ULL, 0x000fe200078ef63cULL,
0x00000800371b7824ULL, 0x000fe200078e00ffULL, 0x0000000850527810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff377224ULL, 0x000fc600078e0038ULL, 0x000008001b1c7812ULL, 0x004fe200078ec0ffULL,
0x00000008521f7824ULL, 0x040fe200078e00ffULL, 0x00000052ff4c7212ULL, 0x000fe200078e33ffULL,
0x0000000852427824ULL, 0x040fe200078e00ffULL, 0x00000180271b7810ULL, 0x000fe20007ffe01cULL,
0x0000000852407824ULL, 0x040fe200078e00ffULL, 0xfffffff81f4c7812ULL, 0x000fe400078ee24cULL,
0x00000007521f7812ULL, 0x000fe200078ec0ffULL, 0x000000101a1a7824ULL, 0x100fe200078e021bULL,
0x0000030037007a0cULL, 0x000fe20003f06070ULL, 0x000000103e3e7824ULL, 0x000fe200078e021bULL,
0xfffffff8421c7812ULL, 0x000fe200078ee21fULL, 0x000000101e1e7824ULL, 0x000fe200078e021bULL,
0x0000000140427812ULL, 0x000fe200078ef61fULL, 0x0000001020207824ULL, 0x000fe200078e021bULL,
0x0000000240447812ULL, 0x000fe200078ef61fULL, 0x0000001022227824ULL, 0x000fe200078e021bULL,
0x0000000340467812ULL, 0x000fe200078ef61fULL, 0x0000001024247824ULL, 0x000fe200078e021bULL,
0x0000000440487812ULL, 0x000fe200078ef61fULL, 0x000000103a3a7824ULL, 0x000fe200078e021bULL,
0x00000005404a7812ULL, 0x000fe200078ef61fULL, 0x000000103c3c7824ULL, 0x000fe200078e021bULL,
0x0000000640407812ULL, 0x000fe200078ef61fULL, 0x0000001d261d7221ULL, 0x002fc40000010100ULL,
0x000000101c1c7824ULL, 0x100fe400078e021bULL, 0x3fb8aa3b1d217820ULL, 0x000fe40000410000ULL,
0x00000004041d7824ULL, 0x000fe400078e00ffULL, 0x0000001042427824ULL, 0x100fe400078e021bULL,
0x0000002100217308ULL, 0x000ee20000000800ULL, 0x0000000c1d1d7812ULL, 0x000fe200078ec0ffULL,
0x0000001044447824ULL, 0x000fc400078e021bULL, 0x0000001046467824ULL, 0x000fe400078e021bULL,
0x000000011a1a7824ULL, 0x000fe400078e021dULL, 0x000000011d3e7824ULL, 0x040fe400078e023eULL,
0x000000011d1e7824ULL, 0x040fe200078e021eULL, 0x000000001a237984ULL, 0x000e620000000800ULL,
0x000000011d207824ULL, 0x040fe400078e0220ULL, 0x000000011d227824ULL, 0x000fe200078e0222ULL,
0x000000003e3e7984ULL, 0x000fe20000000800ULL, 0x0000004e21217220ULL, 0x008fc40000410000ULL,
0x000000011d247824ULL, 0x040fe200078e0224ULL, 0x000000001e1e7984ULL, 0x000fe20000000800ULL,
0x000000011d3a7824ULL, 0x040fe400078e023aULL, 0x000000011d3c7824ULL, 0x040fe200078e023cULL,
0x0000000020207984ULL, 0x000fe20000000800ULL, 0x000000011d1c7824ULL, 0x040fe400078e021cULL,
0x000000011d427824ULL, 0x000fe200078e0242ULL, 0x00001f50211f7589ULL, 0x000ea200000e0000ULL,
0x0000001048487824ULL, 0x000fc400078e021bULL, 0x000000104a4a7824ULL, 0x100fe200078e021bULL,
0x0000000022227984ULL, 0x000ee20000000800ULL, 0x0000001040407824ULL, 0x100fe400078e021bULL,
0x000000104c4c7824ULL, 0x000fe200078e021bULL, 0x0000000024247984ULL, 0x000f220000000800ULL,
0x000000011d447824ULL, 0x040fe400078e0244ULL, 0x000000011d467824ULL, 0x040fe200078e0246ULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x000000011d487824ULL, 0x000fc400078e0248ULL,
0x0000003621367221ULL, 0x000fe20000010000ULL, 0x000000003c3c7984ULL, 0x000f620000000800ULL,
0x000000011d4a7824ULL, 0x040fe400078e024aULL, 0x000000011d407824ULL, 0x040fe200078e0240ULL,
0x000000001c1c7984ULL, 0x000f620000000800ULL, 0x000000011d4c7824ULL, 0x000fe200078e024cULL,
0x00005410ff1a7816ULL, 0x102fe40000000023ULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x00007610ff1b7816ULL, 0x000fc40000000023ULL, 0x0000001f1a357223ULL, 0x084fe20000010035ULL,
0x00005410ff1a7816ULL, 0x000fe4000000003eULL, 0x0000001f1b347223ULL, 0x080fe20000010034ULL,
0x00007610ff1b7816ULL, 0x000fe2000000003eULL, 0x0000000044447984ULL, 0x000fe20000000800ULL,
0x0000001f1a197223ULL, 0x080fe20000010019ULL, 0x00005410ff1a7816ULL, 0x000fe4000000001eULL,
0x0000001f1b187223ULL, 0x080fe20000010018ULL, 0x00007610ff1b7816ULL, 0x000fe2000000001eULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x0000001f1a337223ULL, 0x000fe20000010033ULL,
0x00005410ff1a7816ULL, 0x000fc40000000020ULL, 0x00001f5221217589ULL, 0x000e6200000e0000ULL,
0x0000001f1b327223ULL, 0x080fe20000010032ULL, 0x00007610ff1b7816ULL, 0x000fe20000000020ULL,
0x0000001f1a317223ULL, 0x080fe20000010031ULL, 0x00005410ff1a7816ULL, 0x008fe20000000022ULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x0000001f1b307223ULL, 0x080fe20000010030ULL,
0x00007610ff1b7816ULL, 0x000fe20000000022ULL, 0x0000001f1a2f7223ULL, 0x080fe2000001002fULL,
0x00005410ff1a7816ULL, 0x010fe20000000024ULL, 0x000000004a4a7984ULL, 0x000ee40000000800ULL,
0x0000001f1b2e7223ULL, 0x080fe2000001002eULL, 0x00007610ff1b7816ULL, 0x000fe20000000024ULL,
0x0000001f1a2d7223ULL, 0x080fe2000001002dULL, 0x00005410ff1a7816ULL, 0x020fe2000000003aULL,
0x0000000040407984ULL, 0x000f240000000800ULL, 0x0000001f1b2c7223ULL, 0x080fe2000001002cULL,
0x00007610ff1b7816ULL, 0x000fe2000000003aULL, 0x0000001f1a2b7223ULL, 0x080fe2000001002bULL,
0x00005410ff1a7816ULL, 0x000fe2000000003cULL, 0x000000004c4c7984ULL, 0x000f640000000800ULL,
0x0000001f1b2a7223ULL, 0x080fe2000001002aULL, 0x00007610ff1b7816ULL, 0x000fe2000000003cULL,
0x0000001f1a297223ULL, 0x000fe20000010029ULL, 0x00005410ff1a7816ULL, 0x000fc6000000001cULL,
0x0000001f1b287223ULL, 0x000fe20000010028ULL, 0x00007610ff1b7816ULL, 0x000fe2000000001cULL,
0x000000211a177223ULL, 0x002fe20000010017ULL, 0x00005410ff1a7816ULL, 0x000fc60000000042ULL,
0x000000211b167223ULL, 0x080fe20000010016ULL, 0x00007610ff1b7816ULL, 0x000fe20000000042ULL,
0x000000211a157223ULL, 0x000fe20000010015ULL, 0x00005410ff1a7816ULL, 0x000fc60000000044ULL,
0x000000211b147223ULL, 0x080fe20000010014ULL, 0x00007610ff1b7816ULL, 0x000fe20000000044ULL,
0x000000211a137223ULL, 0x000fe20000010013ULL, 0x00005410ff1a7816ULL, 0x000fc60000000046ULL,
0x000000211b127223ULL, 0x080fe20000010012ULL, 0x00007610ff1b7816ULL, 0x000fe20000000046ULL,
0x000000211a117223ULL, 0x000fe20000010011ULL, 0x00005410ff1a7816ULL, 0x004fc60000000048ULL,
0x000000211b107223ULL, 0x080fe20000010010ULL, 0x00007610ff1b7816ULL, 0x000fe20000000048ULL,
0x000000211a0f7223ULL, 0x000fe2000001000fULL, 0x00005410ff1a7816ULL, 0x008fc6000000004aULL,
0x000000211b0e7223ULL, 0x080fe2000001000eULL, 0x00007610ff1b7816ULL, 0x000fe2000000004aULL,
0x000000211a0d7223ULL, 0x000fe2000001000dULL, 0x00005410ff1a7816ULL, 0x010fc60000000040ULL,
0x000000211b0c7223ULL, 0x080fe2000001000cULL, 0x00007610ff1b7816ULL, 0x000fe20000000040ULL,
0x000000211a0b7223ULL, 0x000fe2000001000bULL, 0x00005410ff1a7816ULL, 0x020fc6000000004cULL,
0x000000211b0a7223ULL, 0x080fe4000001000aULL, 0x000000211a097223ULL, 0x000fe20000010009ULL,
0x00007610ff1a7816ULL, 0x000fca000000004cULL, 0x000000211a077223ULL, 0x000fe20000010007ULL,
0xfffff2d000008947ULL, 0x000fea000383ffffULL, 0x0180000036047810ULL, 0x004fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000004047812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0001701000087802ULL, 0x000fe40000000f00ULL,
0x0000832000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e0006ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003600057308ULL, 0x000e640000001000ULL,
0xbf80000005047423ULL, 0x002fc80000000036ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000808217811ULL, 0x004fe400078ff0ffULL, 0x00000002ff1b7819ULL, 0x000fe40000011608ULL,
0x00000021ff237212ULL, 0x000fe200078e33ffULL, 0x00001f2104067589ULL, 0x000ea200000e0000ULL,
0x00000008211a7824ULL, 0x000fc400078e00ffULL, 0x000000081b257824ULL, 0x000fe200078e00ffULL,
0x00001f1b04057589ULL, 0x00072200000e0000ULL, 0x0000000821247824ULL, 0x000fe200078e00ffULL,
0xfffffff81a237812ULL, 0x000fe200078ee223ULL, 0x000000081b1a7824ULL, 0x000fc800078e00ffULL,
0x0000001023237824ULL, 0x000fe200078e0202ULL, 0x0000001bff047212ULL, 0x008fc800078e33ffULL,
0xfffffff825257812ULL, 0x000fe400078ee204ULL, 0x000000071b047812ULL, 0x000fe200078ec0ffULL,
0x0000000d060d7220ULL, 0x004fc60000410000ULL, 0x0000000404207812ULL, 0x000fe200078e3cffULL,
0x0000000c060c7220ULL, 0x000fe20000410000ULL, 0x00000002041c7812ULL, 0x040fe200078e3cffULL,
0x0000003505357220ULL, 0x050fe20000410000ULL, 0x00000003041e7812ULL, 0x000fe200078e3cffULL,
0x0000003405347220ULL, 0x040fe20000410000ULL, 0x0000000d0c0c723eULL, 0x000fe200000010ffULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000000504227812ULL, 0x000fe200078e3cffULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x000000353434723eULL, 0x000fe200000010ffULL,
0x0000003105317220ULL, 0x000fc40000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x000000333232723eULL, 0x000fe200000010ffULL, 0x0000002f052f7220ULL, 0x040fe40000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x000000313030723eULL, 0x000fe200000010ffULL,
0x0000002d052d7220ULL, 0x040fe40000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002f2e2e723eULL, 0x000fe200000010ffULL, 0x0000002b052b7220ULL, 0x000fc40000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000010ffULL,
0x0000002905297220ULL, 0x040fe40000410000ULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x0000001905197220ULL, 0x040fe40000410000ULL,
0x0000001805187220ULL, 0x000fe20000410000ULL, 0xfffffff81a057812ULL, 0x000fe200078ee21bULL,
0x0000001506157220ULL, 0x000fe20000410000ULL, 0x00000001041a7812ULL, 0x000fe200078e3cffULL,
0x0000001406147220ULL, 0x000fe20000410000ULL, 0x0000000604047812ULL, 0x000fe200078e3cffULL,
0x0000001706177220ULL, 0x000fe20000410000ULL, 0x000000191818723eULL, 0x000fe200000010ffULL,
0x0000001606167220ULL, 0x000fe20000410000ULL, 0x000000151414723eULL, 0x000fe200000010ffULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000000721157812ULL, 0x000fe200078ec0ffULL,
0x0000001206127220ULL, 0x000fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000010ffULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000000315177812ULL, 0x000fe200078e3cffULL,
0x0000001006107220ULL, 0x000fe20000410000ULL, 0x000000131212723eULL, 0x000fe200000010ffULL,
0x0000000f060f7220ULL, 0x000fe20000410000ULL, 0xfffffff824137812ULL, 0x000fe200078ee221ULL,
0x0000000e060e7220ULL, 0x000fe20000410000ULL, 0x000000111010723eULL, 0x000fe200000010ffULL,
0x0000000b060b7220ULL, 0x000fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000000a060a7220ULL, 0x000fe20000410000ULL, 0x0000000f0e0e723eULL, 0x000fe200000010ffULL,
0x0000000906097220ULL, 0x000fc40000410000ULL, 0x0000000706067220ULL, 0x000fe20000410000ULL,
0x0000000b0a0a723eULL, 0x000fe200000010ffULL, 0x000000081b0d7824ULL, 0x040fe400078e0220ULL,
0x0000000408207824ULL, 0x000fe200078e00ffULL, 0x000000090606723eULL, 0x000fe200000010ffULL,
0x000000081b077824ULL, 0x000fe200078e021aULL, 0x0000000215087812ULL, 0x000fe200078e3cffULL,
0x000000081b097824ULL, 0x040fe200078e021cULL, 0x0000000c20207812ULL, 0x000fe200078ec0ffULL,
0x000000081b0b7824ULL, 0x000fe200078e021eULL, 0x00000004151a7812ULL, 0x000fe200078e3cffULL,
0x000000081b117824ULL, 0x000fe200078e0204ULL, 0x0000000115047812ULL, 0x000fe200078e3cffULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x00000005151c7812ULL, 0x000fe200078e3cffULL,
0x000000081b0f7824ULL, 0x000fe200078e0222ULL, 0x00000006151e7812ULL, 0x000fe200078e3cffULL,
0x0000001007077824ULL, 0x000fc400078e0202ULL, 0x0000001009097824ULL, 0x100fe400078e0202ULL,
0x000000100b0b7824ULL, 0x100fe400078e0202ULL, 0x0000000120057824ULL, 0x000fe400078e0205ULL,
0x000000100d0d7824ULL, 0x000fe400078e0202ULL, 0x0000000821157824ULL, 0x000fe200078e0204ULL,
0x0000003405007388ULL, 0x0005e20000000800ULL, 0x000000100f0f7824ULL, 0x000fc400078e0202ULL,
0x0000000120077824ULL, 0x040fe400078e0207ULL, 0x0000000821197824ULL, 0x000fe400078e0208ULL,
0x0000001011117824ULL, 0x100fe200078e0202ULL, 0x0000003207007388ULL, 0x0005e20000000800ULL,
0x0000000120097824ULL, 0x040fe400078e0209ULL, 0x00000008211b7824ULL, 0x000fe400078e0217ULL,
0x0000001025047824ULL, 0x000fe200078e0202ULL, 0x0000003009007388ULL, 0x0005e20000000800ULL,
0x00000001200b7824ULL, 0x000fc400078e020bULL, 0x00000008211d7824ULL, 0x000fe400078e021aULL,
0x0000001013087824ULL, 0x000fe200078e0202ULL, 0x0000002e0b007388ULL, 0x0005e20000000800ULL,
0x00000001200d7824ULL, 0x040fe400078e020dULL, 0x00000008211f7824ULL, 0x000fe400078e021cULL,
0x0000001015177824ULL, 0x000fe200078e0202ULL, 0x0000002c0d007388ULL, 0x0005e20000000800ULL,
0x00000001200f7824ULL, 0x000fc400078e020fULL, 0x0000000821217824ULL, 0x000fe400078e021eULL,
0x0000001019197824ULL, 0x100fe200078e0202ULL, 0x0000002a0f007388ULL, 0x0005e20000000800ULL,
0x0000000120117824ULL, 0x040fe400078e0211ULL, 0x000000101b1b7824ULL, 0x000fe400078e0202ULL,
0x0000000120137824ULL, 0x000fe200078e0204ULL, 0x0000002811007388ULL, 0x0005e20000000800ULL,
0x000000101d1d7824ULL, 0x000fc400078e0202ULL, 0x0000000120157824ULL, 0x040fe200078e0208ULL,
0x0000001813007388ULL, 0x0005e20000000800ULL, 0x000000101f1f7824ULL, 0x100fe400078e0202ULL,
0x0000000120177824ULL, 0x040fe200078e0217ULL, 0x0000001615007388ULL, 0x0005e20000000800ULL,
0x0000001021217824ULL, 0x000fe400078e0202ULL, 0x0000000120197824ULL, 0x040fe200078e0219ULL,
0x0000001417007388ULL, 0x0005e20000000800ULL, 0x00000001201b7824ULL, 0x000fc400078e021bULL,
0x00000001201d7824ULL, 0x040fe200078e021dULL, 0x0000001219007388ULL, 0x0005e20000000800ULL,
0x00000001201f7824ULL, 0x040fe400078e021fULL, 0x0000000120217824ULL, 0x040fe200078e0221ULL,
0x000000101b007388ULL, 0x0005e20000000800ULL, 0x0000000120237824ULL, 0x000fc600078e0223ULL,
0x0000000e1d007388ULL, 0x0005e80000000800ULL, 0x0000000c1f007388ULL, 0x0005e80000000800ULL,
0x0000000a21007388ULL, 0x0005e80000000800ULL, 0x0000000623007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000177919ULL, 0x004ea20000000000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000000803037824ULL, 0x000fe200078e00ffULL, 0x0000000000147919ULL, 0x000f220000002600ULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x0000002017217810ULL, 0x004fc60007ffe0ffULL,
0x00000004050472a4ULL, 0x008fe2000f8e023fULL, 0x0000004017237810ULL, 0x040fe20007ffe0ffULL,
0x0000001014057824ULL, 0x050fe200078e00ffULL, 0x00000003ff027819ULL, 0x000fe20000011617ULL,
0x0000001014157824ULL, 0x040fe200078e00ffULL, 0x0000006017257810ULL, 0x000fe20007ffe0ffULL,
0x0000001014277824ULL, 0x040fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fe20000011621ULL,
0x0000001014297824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fe40000011623ULL,
0xfffffff005047812ULL, 0x000fc400078ee202ULL, 0x00000003ff0a7819ULL, 0x000fe40000011625ULL,
0x0000000702027812ULL, 0x000fe400078e4817ULL, 0x0000000706077812ULL, 0x000fe400078e4821ULL,
0x0000000708097812ULL, 0x002fe400078e4823ULL, 0x000000070a0b7812ULL, 0x000fe400078e4825ULL,
0x0ffffff802057812ULL, 0x000fc400078ef817ULL, 0x0ffffff807077812ULL, 0x000fe400078ef821ULL,
0x0ffffff809097812ULL, 0x000fe200078ef823ULL, 0x0000001005057824ULL, 0x100fe200078e0200ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef825ULL, 0x0000001007077824ULL, 0x100fe200078e0200ULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001009097824ULL, 0x100fe200078e0200ULL,
0x01200000050c7984ULL, 0x0002a20000000c00ULL, 0x000000100b0b7824ULL, 0x000fe200078e0200ULL,
0xfffffff015067812ULL, 0x000fe200078ee206ULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0120000007107984ULL, 0x0007220000000c00ULL, 0x00005a0004027a11ULL, 0x000fc400078048ffULL,
0xfffffff027087812ULL, 0x000fe200078ee208ULL, 0x0120000009187984ULL, 0x000b220000000c00ULL,
0x1ffffff803007812ULL, 0x000fe400078ec0ffULL, 0xfffffff0290a7812ULL, 0x000fe200078ee20aULL,
0x012000000b1c7984ULL, 0x000b220000000c00ULL, 0x00005b0004037a11ULL, 0x000fe400000f4c15ULL,
0x0000000406057c10ULL, 0x002fe4000ff1e0ffULL, 0x0000000408077c10ULL, 0x008fc4000ff3e0ffULL,
0x000000040a0a7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x00005a0007067a11ULL, 0x000fe200078248ffULL, 0x000000ffff097224ULL, 0x020fe200010e06ffULL,
0x00005a000a087a11ULL, 0x000fe400078448ffULL, 0x00000007000b7812ULL, 0x040fe400078ef817ULL,
0x0000000700157812ULL, 0x000fc400078ef821ULL, 0x00005b0005057a11ULL, 0x000fe200000f4c16ULL,
0x000000100b027825ULL, 0x000fe200078e0002ULL, 0x0000000700177812ULL, 0x040fe400078ef823ULL,
0x00005b0007077a11ULL, 0x000fe200008f4c14ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x0000000700217812ULL, 0x000fe400078ef825ULL, 0x00005b000a097a11ULL, 0x000fe200010f4c09ULL,
0x0000001017067825ULL, 0x000fe200078e0006ULL, 0x0000000c02007986ULL, 0x004fe6000c101d06ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000001004007986ULL, 0x010fe8000c101d06ULL,
0x0000001806007986ULL, 0x000fe8000c101d06ULL, 0x0000001c08007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff0a7624ULL, 0x000fe200078e00ffULL,
0x00000001ff007819ULL, 0x004fe20000011603ULL, 0x00006900ff0b7624ULL, 0x000fc600078e00ffULL,
0x01ffffff00007812ULL, 0x000fe400078ec0ffULL, 0x000000060a3b7981ULL, 0x000366000c1e9900ULL,
0x0000000205397824ULL, 0x000fe400078e0200ULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x000000063900720cULL, 0x000fe40003f06070ULL, 0x00000001050e7810ULL, 0x000fd60007ffe0ffULL,
0x000000020c088824ULL, 0x000fc800078e00ffULL, 0x0000640008088a24ULL, 0x000fc800078e0239ULL,
0x0000600008088625ULL, 0x000fca00078e0017ULL, 0x0000000608008981ULL, 0x000362000c1e1900ULL,
0x000000070e00720cULL, 0x000fe20003f06070ULL, 0x0000004003027824ULL, 0x000fe400078e00ffULL,
0x0000008038387824ULL, 0x000fe400078e00ffULL, 0x00000100050d7824ULL, 0x000fe200078e0202ULL,
0x0000000704047899ULL, 0x000fc8000800063fULL, 0x0000004038117812ULL, 0x000fc600078ef80dULL,
0x00000cb000008947ULL, 0x000fea0003800000ULL, 0x0000000000277919ULL, 0x002e620000000000ULL,
0x0000000d04087217ULL, 0x000fe20007800000ULL, 0x00000004001e7c24ULL, 0x020fe2000f8e0211ULL,
0x00002000031f7811ULL, 0x000fe200078e70ffULL, 0x00000100ff297424ULL, 0x000fe400078e00ffULL,
0x00000001080d7824ULL, 0x000fe200078e0a0dULL, 0x00000003ff327819ULL, 0x002fc80000011627ULL,
0x00000004320a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001032107810ULL, 0x040fe40007ffe0ffULL,
0x0000000832087810ULL, 0x000fe20007ffe0ffULL, 0x000000080a207824ULL, 0x040fe200078e00ffULL,
0x000000270a097212ULL, 0x000fe200078e3cffULL, 0x0000000810267824ULL, 0x000fe200078e00ffULL,
0x0000000c320e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000808227824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fc400078ee209ULL, 0x00000027100f7212ULL, 0x080fe200078e3cffULL,
0x000000080e247824ULL, 0x000fe200078e00ffULL, 0x0000002708097212ULL, 0x080fe400078e3cffULL,
0x0000001432187810ULL, 0x000fe40007ffe0ffULL, 0x000000270e0b7212ULL, 0x000fe400078e3cffULL,
0xfffffff826267812ULL, 0x000fe200078ee20fULL, 0x00000010270f7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x0000000818287824ULL, 0x000fe200078e00ffULL,
0x0000007f32097812ULL, 0x000fc400078ec0ffULL, 0xfffffff824247812ULL, 0x000fe400078ee20bULL,
0x00000027180b7212ULL, 0x000fe200078e3cffULL, 0x000000011e097824ULL, 0x000fe200078e0209ULL,
0x000000700f2b7812ULL, 0x000fe400078ec0ffULL, 0x0000007f080f7812ULL, 0x000fe400078ec0ffULL,
0xfffffff828287812ULL, 0x000fe400078ee20bULL, 0x0000007f0a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000011e0f7824ULL, 0x000fe200078e020fULL, 0x0000000d0800720cULL, 0x000fe20003fa6070ULL,
0x00005e0009087625ULL, 0x000fe200078e0029ULL, 0x0000007f0e117812ULL, 0x000fc400078ec0ffULL,
0x0000000d0e00720cULL, 0x000fe20003f06070ULL, 0x000000011e0b7824ULL, 0x000fe200078e020bULL,
0x0000007f10137812ULL, 0x000fe200078ec0ffULL, 0x00005e000f0e7625ULL, 0x000fe200078e0029ULL,
0x000000082b127210ULL, 0x000fe40007f3e0ffULL, 0x0000000d0a00720cULL, 0x080fe20003f86070ULL,
0x000000011e087824ULL, 0x000fe200078e0211ULL, 0x0000000d1000720cULL, 0x000fe20003f46070ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0029ULL, 0x0000000e2b0e7210ULL, 0x000fc40007f7e0ffULL,
0x00000018322a7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e107824ULL, 0x000fe200078e0213ULL,
0x0000001c322c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0609ULL,
0x0000000a2b147210ULL, 0x040fe20007f3e0ffULL, 0x00005e0008087625ULL, 0x080fe200078e0029ULL,
0x0000007f2c197812ULL, 0x000fe400078ec0ffULL, 0x00000007321a7812ULL, 0x000fe200078e4827ULL,
0x000000ffff0f7224ULL, 0x000fe200018e060fULL, 0x000000082b167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e060bULL, 0x0000007f180b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0010107625ULL, 0x000fe200078e0029ULL, 0x0000000d1800720cULL, 0x000fc40003f26070ULL,
0x00000020322e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200018e0609ULL,
0x0000007f2a097812ULL, 0x000fe200078ec0ffULL, 0x000000011e087824ULL, 0x000fe200078e020bULL,
0x000000102b107210ULL, 0x000fe20007fde0ffULL, 0x000000082a237824ULL, 0x000fe200078e00ffULL,
0x0ffffff81a1c7812ULL, 0x000fe200078ef827ULL, 0x000000011e0a7824ULL, 0x000fe200078e0209ULL,
0x0000007f2e1b7812ULL, 0x000fe200078ec0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0029ULL,
0x0000000d3200720cULL, 0x000fc40003f66070ULL, 0x0000002432307810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000082b187210ULL, 0x000fe20007fde0ffULL,
0x00005e000a0a7625ULL, 0x000fc800078e0029ULL, 0x000000011e087824ULL, 0x000fe400078e0219ULL,
0x000000ffff197224ULL, 0x000fe200030e0609ULL, 0x0000000a2b1a7210ULL, 0x000fe20007fde0ffULL,
0x00005e0008087625ULL, 0x000fc800078e0029ULL, 0x000000011e0a7824ULL, 0x000fe400078e021bULL,
0x000000101c217824ULL, 0x000fe400078e021fULL, 0x000000ffff1b7224ULL, 0x000fe200030e060bULL,
0x000000082b1c7210ULL, 0x000fe20007fde0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0029ULL,
0x000000272a087212ULL, 0x040fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012217faeULL, 0x0003e2000d901c46ULL, 0x0000000d2a00720cULL, 0x000fe20003f66070ULL,
0x000000ffff1d7224ULL, 0x000fe200030e0609ULL, 0x0000007f30097812ULL, 0x000fe200078ec0ffULL,
0x000000082e257824ULL, 0x000fe200078e00ffULL, 0xfffffff8232a7812ULL, 0x000fe200078ee208ULL,
0x0000001020237824ULL, 0x000fe200078e021fULL, 0x0000000a2b0a7210ULL, 0x000fe20007fde0ffULL,
0x000000011e097824ULL, 0x000fe200078e0209ULL, 0x000000272e207212ULL, 0x000fc400078e3cffULL,
0x0000000014237faeULL, 0x0005e2000e101c46ULL, 0x00005e0009087625ULL, 0x000fe200078e0029ULL,
0x0000000d2c00720cULL, 0x040fe40003f86070ULL, 0x000000272c137212ULL, 0x002fe200078e3cffULL,
0x0000001022217824ULL, 0x000fe200078e021fULL, 0xfffffff825207812ULL, 0x000fe200078ee220ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x000000082b127210ULL, 0x000fe20007fde0ffULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0x000000000e217faeULL, 0x0003e2000e901c46ULL,
0x0000000d2e00720cULL, 0x000fe20003fa6070ULL, 0x0000001024157824ULL, 0x104fe200078e021fULL,
0x0000002c32147810ULL, 0x000fe20007ffe0ffULL, 0x0000001020257824ULL, 0x000fe200078e021fULL,
0xfffffff82c087812ULL, 0x000fe200078ee213ULL, 0x000000ffff137224ULL, 0x000fe200030e0609ULL,
0x0000000016157faeULL, 0x0005e2000c101c46ULL, 0x0000001026097824ULL, 0x100fe200078e021fULL,
0x0000003032207810ULL, 0x000fe20007ffe0ffULL, 0x0000001008237824ULL, 0x100fe200078e021fULL,
0x0000003832227810ULL, 0x000fe20007ffe0ffULL, 0x00000010280f7824ULL, 0x102fe200078e021fULL,
0x00000028320e7810ULL, 0x000fe20007ffe0ffULL, 0x000000102a217824ULL, 0x000fe200078e021fULL,
0x0000000010097faeULL, 0x0003e2000d101c46ULL, 0x0000003c32247810ULL, 0x000fc40007ffe0ffULL,
0x0000002730087212ULL, 0x000fe200078e3cffULL, 0x000000080e167824ULL, 0x004fe200078e00ffULL,
0x00000000180f7faeULL, 0x0005e2000c901c46ULL, 0x0000000d3000720cULL, 0x080fe40003fc6070ULL,
0x0000000d2200720cULL, 0x080fe20003f26070ULL, 0x000000001a217faeULL, 0x0007e2000d901c46ULL,
0x0000000d2000720cULL, 0x000fe40003f66070ULL, 0x000000270e097212ULL, 0x002fe200078e3cffULL,
0x000000001c237faeULL, 0x0003e2000e101c46ULL, 0x0000003432107810ULL, 0x000fc40007ffe0ffULL,
0xfffffff816167812ULL, 0x000fe200078ee209ULL, 0x00000008300f7824ULL, 0x004fe200078e00ffULL,
0x000000000a257faeULL, 0x0005e2000e901c46ULL, 0x0000007f0e097812ULL, 0x000fe200078ec0ffULL,
0x0000000824197824ULL, 0x000fe200078e00ffULL, 0x0000000d0e00720cULL, 0x080fe20003fa6070ULL,
0x00000008201a7824ULL, 0x008fe200078e00ffULL, 0x0000000d1400720cULL, 0x080fe20003f86070ULL,
0x000000011e097824ULL, 0x000fe200078e0209ULL, 0x0000000d1000720cULL, 0x0c0fe20003f46070ULL,
0x00000008101c7824ULL, 0x002fe200078e00ffULL, 0x0000000d2400720cULL, 0x000fe20003f06070ULL,
0x00000008140d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f087812ULL, 0x000fc400078ee208ULL,
0x00000027200b7212ULL, 0x084fe400078e3cffULL, 0x00000027140a7212ULL, 0x000fe400078e3cffULL,
0xfffffff81a1a7812ULL, 0x000fe400078ee20bULL, 0x0000007f140b7812ULL, 0x000fe400078ec0ffULL,
0xfffffff80d187812ULL, 0x000fe200078ee20aULL, 0x00000010080d7824ULL, 0x000fe200078e021fULL,
0x0000007f200f7812ULL, 0x000fe200078ec0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0029ULL,
0x0000002710117212ULL, 0x000fc400078e3cffULL, 0x00000000120d7faeULL, 0x0003e2000f101c46ULL,
0x000000011e0b7824ULL, 0x040fe200078e020bULL, 0x000000082b0e7210ULL, 0x000fe20007fde0ffULL,
0x000000011e087824ULL, 0x000fe200078e020fULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL,
0x00005e000b0a7625ULL, 0x000fc800078e0029ULL, 0x000000ffff0f7224ULL, 0x000fe400030e0609ULL,
0x00005e0008087625ULL, 0x080fe200078e0029ULL, 0x0000007f100d7812ULL, 0x002fe400078ec0ffULL,
0x0000000a2b107210ULL, 0x040fe20007fde0ffULL, 0x000000101c1b7824ULL, 0x000fe200078e021fULL,
0x0000007f22137812ULL, 0x000fe200078ec0ffULL, 0x000000011e0a7824ULL, 0x000fe200078e020dULL,
0x0000007f240d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff117224ULL, 0x000fe200030e060bULL,
0x000000082b127210ULL, 0x000fe20007fde0ffULL, 0x00005e000a0a7625ULL, 0x000fc800078e0029ULL,
0x000000011e087824ULL, 0x000fe400078e0213ULL, 0x000000ffff137224ULL, 0x000fe200030e0609ULL,
0x0000000a2b147210ULL, 0x000fe20007fde0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0029ULL,
0x00000027240a7212ULL, 0x000fc600078e3cffULL, 0x000000011e177824ULL, 0x000fe200078e020dULL,
0xfffffff819207812ULL, 0x000fe200078ee20aULL, 0x000000ffff157224ULL, 0x000fe200030e060bULL,
0x000000082b087210ULL, 0x000fe20007fde0ffULL, 0x00000008221e7824ULL, 0x040fe200078e00ffULL,
0x00000027220d7212ULL, 0x000fe200078e3cffULL, 0x00005e00170a7625ULL, 0x000fc600078e0029ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000000a2b0a7210ULL, 0x000fe20007fde0ffULL, 0x00000010160d7824ULL, 0x100fe400078e021fULL,
0x0000001018177824ULL, 0x100fe400078e021fULL, 0x000000101a197824ULL, 0x100fe200078e021fULL,
0x000000000e0d7faeULL, 0x0003e2000e901c46ULL, 0x000000101e1d7824ULL, 0x100fe400078e021fULL,
0x00000010201f7824ULL, 0x000fe200078e021fULL, 0x0000000010177faeULL, 0x0003e2000e101c46ULL,
0x000000ffff0b7224ULL, 0x000fc600030e060bULL, 0x0000000012197faeULL, 0x0003e8000d901c46ULL,
0x00000000141b7faeULL, 0x0003e8000d101c46ULL, 0x00000000081d7faeULL, 0x0003e8000c901c46ULL,
0x000000000a1f7faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x002e620000000000ULL, 0x0000000400117c24ULL, 0x020fc4000f8e0211ULL,
0x00000100ff287424ULL, 0x000fe200078e00ffULL, 0x00000003ff097819ULL, 0x002fc80000011608ULL,
0x0000000409137810ULL, 0x040fe40007ffe0ffULL, 0x00000018091d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c09177810ULL, 0x000fe20007ffe0ffULL, 0x00000008130d7824ULL, 0x040fe200078e00ffULL,
0x00000008130a7212ULL, 0x080fe200078e3cffULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0x000000081d0e7212ULL, 0x000fe200078e3cffULL, 0x00000008170f7824ULL, 0x000fe200078e00ffULL,
0x0000002809257810ULL, 0x000fc40007ffe0ffULL, 0x0000000809157810ULL, 0x040fe40007ffe0ffULL,
0x00000014091b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fe200078e00ffULL,
0xfffffff80d107812ULL, 0x000fe200078ee20aULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0xfffffff81f247812ULL, 0x000fe200078ee20eULL, 0x000000081b207824ULL, 0x000fe200078e00ffULL,
0x00000008170a7212ULL, 0x000fe400078e3cffULL, 0x0000001c091f7810ULL, 0x000fc40007ffe0ffULL,
0x00000008250e7212ULL, 0x080fe400078e3cffULL, 0x0000001009197810ULL, 0x040fe40007ffe0ffULL,
0x0000002409237810ULL, 0x000fe40007ffe0ffULL, 0x00000008150b7212ULL, 0x080fe200078e3cffULL,
0x00000008191c7824ULL, 0x000fe200078e00ffULL, 0x000000081b0d7212ULL, 0x000fe200078e3cffULL,
0x0000000823327824ULL, 0x000fe200078e00ffULL, 0xfffffff80f187812ULL, 0x000fe200078ee20aULL,
0x000000081f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff827367812ULL, 0x000fc400078ee20eULL,
0x000000081f0a7212ULL, 0x000fe400078e3cffULL, 0x0000002c09277810ULL, 0x040fe40007ffe0ffULL,
0xfffffff814147812ULL, 0x000fe400078ee20bULL, 0xfffffff820207812ULL, 0x000fe400078ee20dULL,
0x0000002009217810ULL, 0x040fe40007ffe0ffULL, 0x00000034092b7810ULL, 0x000fc40007ffe0ffULL,
0x00000008190b7212ULL, 0x080fe200078e3cffULL, 0x00000008212e7824ULL, 0x000fe200078e00ffULL,
0x00000008230d7212ULL, 0x080fe200078e3cffULL, 0x000000082b447824ULL, 0x000fe200078e00ffULL,
0x00000038092d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80f2a7812ULL, 0x000fe200078ee20aULL,
0x00000008270f7824ULL, 0x040fe200078e00ffULL, 0x00000008270a7212ULL, 0x000fe200078e3cffULL,
0x000000082d2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fc400078ee20bULL,
0xfffffff832327812ULL, 0x000fe400078ee20dULL, 0x0000003009297810ULL, 0x000fe40007ffe0ffULL,
0x00000008210b7212ULL, 0x080fe400078e3cffULL, 0x000000082b0d7212ULL, 0x080fe200078e3cffULL,
0x0000000829407824ULL, 0x000fe200078e00ffULL, 0x000000082d0e7212ULL, 0x000fe400078e3cffULL,
0xfffffff80f3c7812ULL, 0x000fc400078ee20aULL, 0x0000007f090a7812ULL, 0x000fe400078ec0ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee20bULL, 0xfffffff844447812ULL, 0x000fe400078ee20dULL,
0x00000008290b7212ULL, 0x000fe400078e3cffULL, 0xfffffff82f487812ULL, 0x000fe400078ee20eULL,
0x00000007090d7812ULL, 0x000fc400078e4808ULL, 0x0000003c092f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111097824ULL, 0x000fe200078e020aULL, 0xfffffff840407812ULL, 0x000fe200078ee20bULL,
0x00000010080b7824ULL, 0x000fe200078e00ffULL, 0x0ffffff80d0a7812ULL, 0x000fe200078ef808ULL,
0x000000082f4a7824ULL, 0x040fe200078e00ffULL, 0x000000082f0d7212ULL, 0x000fe400078e3cffULL,
0x0000007f130e7812ULL, 0x000fe400078ec0ffULL, 0x0000007f2f087812ULL, 0x000fc400078ec0ffULL,
0x00002000030f7811ULL, 0x000fe200078e70ffULL, 0x0000000111137824ULL, 0x040fe200078e020eULL,
0xfffffff84a0e7812ULL, 0x000fe200078ee20dULL, 0x0000000111517824ULL, 0x000fe200078e0208ULL,
0x000000700b0d7812ULL, 0x000fe200078ec0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0028ULL,
0x0000007f191a7812ULL, 0x000fe400078ec0ffULL, 0x0000007f15127812ULL, 0x000fe200078ec0ffULL,
0x00000010142f7824ULL, 0x100fe200078e020fULL, 0x0000007f2b427812ULL, 0x000fe200078ec0ffULL,
0x000000100a2b7824ULL, 0x000fe200078e020fULL, 0x000000080d087210ULL, 0x000fe20007f1e0ffULL,
0x00005e00130a7625ULL, 0x000fe200078e0028ULL, 0x0000007f17167812ULL, 0x000fc400078ec0ffULL,
0x0000007f1d227812ULL, 0x000fe200078ec0ffULL, 0x0000000111197824ULL, 0x000fe200078e021aULL,
0x0000007f1b1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000111157824ULL, 0x000fe200078e0212ULL,
0x0000007f1f267812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x0000007f212c7812ULL, 0x000fe200078ec0ffULL, 0x0000001018317824ULL, 0x100fe200078e020fULL,
0x0000007f23307812ULL, 0x000fe200078ec0ffULL, 0x000000101c337824ULL, 0x100fe200078e020fULL,
0x0000007f25347812ULL, 0x000fe200078ec0ffULL, 0x0000001020357824ULL, 0x100fe200078e020fULL,
0x0000007f273a7812ULL, 0x000fe200078ec0ffULL, 0x0000001024377824ULL, 0x100fe200078e020fULL,
0x0000007f293e7812ULL, 0x000fe200078ec0ffULL, 0x000000102a3d7824ULL, 0x100fe200078e020fULL,
0x0000007f2d467812ULL, 0x000fe200078ec0ffULL, 0x00000010102d7824ULL, 0x100fe200078e020fULL,
0x0000000a0d0a7210ULL, 0x000fe20007f1e0ffULL, 0x000000102e3f7824ULL, 0x100fe200078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082b7faeULL, 0x0003e2000b901c46ULL,
0x0000001032417824ULL, 0x000fc400078e020fULL, 0x0000001036437824ULL, 0x100fe400078e020fULL,
0x000000103c457824ULL, 0x100fe400078e020fULL, 0x0000001040477824ULL, 0x100fe400078e020fULL,
0x00000010444b7824ULL, 0x100fe400078e020fULL, 0x00000010484f7824ULL, 0x100fe400078e020fULL,
0x000000100e537824ULL, 0x000fc400078e020fULL, 0x00005e0019127625ULL, 0x000fc800078e0028ULL,
0x0000000111177824ULL, 0x000fe400078e0216ULL, 0x00005e00150e7625ULL, 0x000fc800078e0028ULL,
0x00000001111d7824ULL, 0x000fe200078e0222ULL, 0x0000000e0d0e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001111b7824ULL, 0x040fe400078e021eULL, 0x00000001111f7824ULL, 0x040fe400078e0226ULL,
0x0000000111217824ULL, 0x040fe400078e022cULL, 0x0000000111237824ULL, 0x040fe400078e0230ULL,
0x0000000111257824ULL, 0x000fc400078e0234ULL, 0x0000000111277824ULL, 0x040fe400078e023aULL,
0x0000000111297824ULL, 0x040fe400078e023eULL, 0x0000000111497824ULL, 0x040fe400078e0242ULL,
0x00000001114d7824ULL, 0x000fe400078e0246ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000120d127210ULL, 0x000fe20007f1e0ffULL, 0x00005e0017107625ULL, 0x000fc600078e0028ULL,
0x000000000a2d7faeULL, 0x0003e2000b901c46ULL, 0x00005e001d167625ULL, 0x000fe200078e0028ULL,
0x000000100d107210ULL, 0x000fc60007f5e0ffULL, 0x00005e001b147625ULL, 0x000fc800078e0028ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x000000160d167210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x000000140d147210ULL, 0x000fe20007f3e0ffULL,
0x00005e00211a7625ULL, 0x000fc600078e0028ULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x00005e001f187625ULL, 0x000fc800078e0028ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000001a0d1a7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x000000180d187210ULL, 0x000fe20007f3e0ffULL, 0x00005e0027207625ULL, 0x000fc800078e0028ULL,
0x00005e00231c7625ULL, 0x000fc800078e0028ULL, 0x00005e00251e7625ULL, 0x000fc800078e0028ULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x000000200d207210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x0000001c0d1c7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x0000001e0d1e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0029227625ULL, 0x000fc600078e0028ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x00005e0049247625ULL, 0x000fc600078e0028ULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x00005e004d267625ULL, 0x000fc600078e0028ULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x00005e0051287625ULL, 0x000fc600078e0028ULL, 0x0000000016377faeULL, 0x0003e2000b901c46ULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0x000000220d227210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x000000240d247210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x000000260d267210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x000fe200000e0623ULL, 0x000000280d287210ULL, 0x000fe20007f7e0ffULL,
0x00000000183d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff257224ULL, 0x000fc400008e0625ULL,
0x000000ffff277224ULL, 0x000fe200010e0627ULL, 0x000000001a3f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fc600018e0629ULL, 0x000000001c417faeULL, 0x0003e8000b901c46ULL,
0x000000001e437faeULL, 0x0003e8000b901c46ULL, 0x0000000020457faeULL, 0x0003e8000b901c46ULL,
0x0000000022477faeULL, 0x0003e8000b901c46ULL, 0x00000000244b7faeULL, 0x0003e8000b901c46ULL,
0x00000000264f7faeULL, 0x0003e8000b901c46ULL, 0x0000000028537faeULL, 0x0003e4000b901c46ULL,
0x01c60400ff087984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000008ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x01c60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000030300780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000e640000000000ULL,
0x0000002003087824ULL, 0x002fc800078e0208ULL, 0x00000020080a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff097819ULL, 0x000fc80000011608ULL, 0x1ffffffe09097812ULL, 0x000fe400078ec0ffULL,
0x000001e00a0a7812ULL, 0x000fe400078ec0ffULL, 0x00000001090d7812ULL, 0x040fe400078efcffULL,
0x00000007090b7812ULL, 0x100fe400078e7808ULL, 0x000000070d0d7812ULL, 0x100fe400078e7808ULL,
0x00000010090f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010a0b7824ULL, 0x040fe200078e020bULL,
0x0000001109097810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0d7824ULL, 0x000fe200078e020dULL,
0x000000070f0f7812ULL, 0x000fc400078e7808ULL, 0x000000000b147984ULL, 0x000e62000000cc00ULL,
0x0000000709097812ULL, 0x000fe400078e7808ULL, 0x000000010a0f7824ULL, 0x040fe200078e020fULL,
0x000000000d107984ULL, 0x000ea4000000cc00ULL, 0x000000010a097824ULL, 0x000fe400078e0209ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fc400078e0016ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0017ULL,
0x000000180b007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1f7224ULL, 0x000fca00078e0013ULL, 0x0000001c0d007388ULL, 0x000fe8000000cc00ULL,
0x0000000009107984ULL, 0x000e68000000cc00ULL, 0x000000000f147984ULL, 0x000ea2000000cc00ULL,
0x000000ffff237224ULL, 0x002fe400078e0012ULL, 0x000000ffff227224ULL, 0x000fc400078e0010ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff207224ULL, 0x004fe400078e0014ULL,
0x000000ffff217224ULL, 0x000fe400078e0016ULL, 0x000000ffff107224ULL, 0x000fe400078e0015ULL,
0x000000ffff117224ULL, 0x000fe200078e0017ULL, 0x000000200f007388ULL, 0x0003e8000000cc00ULL,
0x0000001009007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01c60400ff087984ULL, 0x000ea40000000800ULL,
0x8000000008ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0022a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x01c60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000070500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003a7919ULL, 0x000ea20000000000ULL,
0x3d8000003b3b7820ULL, 0x000fe20000410000ULL, 0xffffffff073e7810ULL, 0x000fe20007ffe0ffULL,
0x000064000c3c7a24ULL, 0x000fe200078e02ffULL, 0x00007610ff3f7816ULL, 0x000fe2000000003fULL,
0x00000010033d7824ULL, 0x000fe200078e00ffULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x0000000704047899ULL, 0x000fe4000800063fULL,
0x0000010005417824ULL, 0x000fe200078e0202ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000410400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e0040ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff437224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x002fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x0000000143297810ULL, 0x000fe20007ffe0ffULL, 0x0000171000007945ULL, 0x000fe20003800000ULL,
0x0000000142407812ULL, 0x000fc400078e0cffULL, 0x00000001ff287819ULL, 0x000fe40000011629ULL,
0x000000022900780cULL, 0x040fe40003f06070ULL, 0x0000000129547812ULL, 0x000fe200078ec0ffULL,
0x00000300282b7a24ULL, 0x000fc800078e0205ULL, 0x000001002b2a7824ULL, 0x040fe200078e0202ULL,
0x000000012b287810ULL, 0x000fc80007ffe0ffULL, 0x000000072800720cULL, 0x000fe20003f26070ULL,
0x000000ffff287224ULL, 0x000fe200078e0043ULL, 0x000000402a2b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff437224ULL, 0x000fc800078e0029ULL, 0x00000001382b7824ULL, 0x000fcc00078e022bULL,
0x00000bb000009947ULL, 0x020fea0003800000ULL, 0x00000003ff367819ULL, 0x004fe2000001163aULL,
0x0000000400347c24ULL, 0x000fe2000f8e022bULL, 0x0000002a04297217ULL, 0x000fe20007800000ULL,
0x0000000203357824ULL, 0x000fe200078e0240ULL, 0x00000004362e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000854377824ULL, 0x000fe200078e00ffULL, 0x0000000836307810ULL, 0x040fe20007ffe0ffULL,
0x0000000129297824ULL, 0x000fe200078e0a2aULL, 0x0000001036457810ULL, 0x000fe20007ffe0ffULL,
0x000000082e2d7824ULL, 0x040fe200078e00ffULL, 0x0000003a2e2c7212ULL, 0x080fe200078e3cffULL,
0x0000000830317824ULL, 0x000fe200078e00ffULL, 0x0000000c36327810ULL, 0x040fe20007ffe0ffULL,
0x00000008454a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d447812ULL, 0x000fe200078ee22cULL,
0x00000100ff4f7424ULL, 0x000fe200078e00ffULL, 0x0000001436477810ULL, 0x000fe20007ffe0ffULL,
0x0000000832337824ULL, 0x000fe200078e00ffULL, 0x0000003a302a7212ULL, 0x000fc400078e3cffULL,
0x0000007f362b7812ULL, 0x000fe200078ec0ffULL, 0x00000008474c7824ULL, 0x000fe200078e00ffULL,
0x0000003a452d7212ULL, 0x080fe400078e3cffULL, 0xfffffff831467812ULL, 0x000fe200078ee22aULL,
0x000000012b2a7824ULL, 0x000fe200078e0234ULL, 0x0000003a322c7212ULL, 0x000fe400078e3cffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee22dULL, 0x00005e002a2a7625ULL, 0x000fe200078e004fULL,
0x00000018364e7810ULL, 0x000fc40007ffe0ffULL, 0x0000003a472f7212ULL, 0x000fe400078e3cffULL,
0x00000007362d7812ULL, 0x000fe200078e483aULL, 0x000000084e507824ULL, 0x000fe200078e00ffULL,
0x0000001c36527810ULL, 0x040fe40007ffe0ffULL, 0x0000002036557810ULL, 0x040fe40007ffe0ffULL,
0x000000293600720cULL, 0x000fe20003f26070ULL, 0x0000000852567824ULL, 0x000fe200078e00ffULL,
0xfffffff833487812ULL, 0x000fe200078ee22cULL, 0x0000000855587824ULL, 0x000fe200078e00ffULL,
0xfffffff84c4c7812ULL, 0x000fc400078ee22fULL, 0x0000200035357811ULL, 0x000fe400078e68ffULL,
0xfffffff837377812ULL, 0x100fe400078ee23aULL, 0x0ffffff82d2c7812ULL, 0x000fe200078ef83aULL,
0x000000104a4b7824ULL, 0x000fe200078e0235ULL, 0x0000003a4e2f7212ULL, 0x080fe200078e3cffULL,
0x00000010372a7825ULL, 0x000fe200078e002aULL, 0x0000003a52317212ULL, 0x080fe400078e3cffULL,
0x0000003a55337212ULL, 0x000fe200078e3cffULL, 0x000000102c2d7824ULL, 0x000fe200078e0235ULL,
0xfffffff850507812ULL, 0x000fe200078ee22fULL, 0x000000104c4d7824ULL, 0x000fe200078e0235ULL,
0xfffffff856567812ULL, 0x000fc400078ee231ULL, 0x0000007f2e2f7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0003e2000c901c46ULL,
0xfffffff858587812ULL, 0x000fe400078ee233ULL, 0x0000007f30317812ULL, 0x000fe400078ec0ffULL,
0x0000007f32337812ULL, 0x000fe400078ec0ffULL, 0x000000294500720cULL, 0x000fe20003f86070ULL,
0x00000001312c7824ULL, 0x000fe200078e0234ULL, 0x0000007f45457812ULL, 0x000fc400078ec0ffULL,
0x0000002436577810ULL, 0x000fe20007ffe0ffULL, 0x000000012f2a7824ULL, 0x102fe200078e0234ULL,
0x000000292e00720cULL, 0x080fe20003f26070ULL, 0x00000001332e7824ULL, 0x100fe200078e0234ULL,
0x000000293000720cULL, 0x080fe20003f46070ULL, 0x0000000145307824ULL, 0x000fe200078e0234ULL,
0x000000293200720cULL, 0x000fe20003f66070ULL, 0x00005e002a2a7625ULL, 0x000fe200078e004fULL,
0x000000294700720cULL, 0x040fe40003fa6070ULL, 0x0000007f47477812ULL, 0x000fe200078ec0ffULL,
0x00005e002c2c7625ULL, 0x000fe200078e004fULL, 0x0000003a57497212ULL, 0x000fc400078e3cffULL,
0x0000007f4e517812ULL, 0x000fe200078ec0ffULL, 0x00000008575a7824ULL, 0x000fe200078e00ffULL,
0x0000007f52537812ULL, 0x000fe200078ec0ffULL, 0x00005e002e2e7625ULL, 0x000fc600078e004fULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee249ULL, 0x00005e0030307625ULL, 0x000fc800078e004fULL,
0x0000000147327824ULL, 0x000fe400078e0234ULL, 0x0000001044457824ULL, 0x000fe200078e0235ULL,
0x0000002c36447810ULL, 0x000fe20007ffe0ffULL, 0x00000010372a7825ULL, 0x000fc800078e002aULL,
0x0000001046477824ULL, 0x000fe200078e0235ULL, 0x000000002a457faeULL, 0x0003e2000c901c46ULL,
0x00000010372c7825ULL, 0x000fe200078e002cULL, 0x000000294e00720cULL, 0x000fc60003f26070ULL,
0x0000001048497824ULL, 0x000fe200078e0235ULL, 0x000000002c477faeULL, 0x0005e2000d101c46ULL,
0x00000010372e7825ULL, 0x040fe200078e002eULL, 0x000000295200720cULL, 0x080fe40003f46070ULL,
0x0000003036487810ULL, 0x000fe20007ffe0ffULL, 0x0000001037307825ULL, 0x000fe200078e0030ULL,
0x000000002e497faeULL, 0x0007e2000d901c46ULL, 0x000000295500720cULL, 0x040fe40003f66070ULL,
0x00005e0032327625ULL, 0x000fe200078e004fULL, 0x00000000304b7faeULL, 0x0009e2000e101c46ULL,
0x0000007f55557812ULL, 0x000fc400078ec0ffULL, 0x000000295700720cULL, 0x000fe20003f86070ULL,
0x00000001512a7824ULL, 0x102fe200078e0234ULL, 0x0000007f57577812ULL, 0x000fe200078ec0ffULL,
0x00000001532c7824ULL, 0x104fe400078e0234ULL, 0x00000001552e7824ULL, 0x008fe400078e0234ULL,
0x0000001037327825ULL, 0x000fe200078e0032ULL, 0x00000034364b7810ULL, 0x010fc60007ffe0ffULL,
0x00005e002a2a7625ULL, 0x080fe200078e004fULL, 0x00000000324d7faeULL, 0x0003e6000e901c46ULL,
0x0000000157307824ULL, 0x000fe400078e0234ULL, 0x00005e002c2c7625ULL, 0x000fc800078e004fULL,
0x00005e002e2e7625ULL, 0x000fe200078e004fULL, 0x0000002836327810ULL, 0x002fc60007ffe0ffULL,
0x00005e0030307625ULL, 0x000fe200078e004fULL, 0x00000038364d7810ULL, 0x000fc60007ffe0ffULL,
0x0000001050337824ULL, 0x000fe200078e0235ULL, 0x000000294d00720cULL, 0x000fe20003fa6070ULL,
0x00000010372a7825ULL, 0x000fc800078e002aULL, 0x0000001056457824ULL, 0x000fe200078e0235ULL,
0x000000002a337faeULL, 0x0003e2000c901c46ULL, 0x00000010372c7825ULL, 0x000fe200078e002cULL,
0x000000293200720cULL, 0x000fc60003f26070ULL, 0x0000001058477824ULL, 0x000fe200078e0235ULL,
0x000000002c457faeULL, 0x0005e2000d101c46ULL, 0x00000010372e7825ULL, 0x000fe200078e002eULL,
0x000000294400720cULL, 0x000fc60003f46070ULL, 0x000000105a497824ULL, 0x000fe200078e0235ULL,
0x0000003c36337810ULL, 0x002fe20007ffe0ffULL, 0x0000001037307825ULL, 0x000fe200078e0030ULL,
0x0000003a322a7212ULL, 0x080fe200078e3cffULL, 0x000000002e477faeULL, 0x0003e2000d901c46ULL,
0x000000294800720cULL, 0x080fe20003f66070ULL, 0x00000008322b7824ULL, 0x000fe200078e00ffULL,
0x000000293300720cULL, 0x080fe20003fc6070ULL, 0x0000000030497faeULL, 0x0007e2000e101c46ULL,
0x000000294b00720cULL, 0x000fe20003f86070ULL, 0x0000000844467824ULL, 0x040fe200078e00ffULL,
0xfffffff82b367812ULL, 0x000fe200078ee22aULL, 0x000000084b4c7824ULL, 0x040fe200078e00ffULL,
0x0000003a44297212ULL, 0x080fe200078e3cffULL, 0x00000008482d7824ULL, 0x044fe200078e00ffULL,
0x0000003a4b2b7212ULL, 0x080fe200078e3cffULL, 0x000000084d2f7824ULL, 0x002fe200078e00ffULL,
0x0000003a482a7212ULL, 0x000fc400078e3cffULL, 0xfffffff846467812ULL, 0x000fe400078ee229ULL,
0x0000003a4d2c7212ULL, 0x080fe400078e3cffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee22bULL,
0x0000001046457824ULL, 0x100fe200078e0235ULL, 0x0000007f32297812ULL, 0x000fe400078ec0ffULL,
0xfffffff82d4a7812ULL, 0x000fe200078ee22aULL, 0x000000104c497824ULL, 0x108fe200078e0235ULL,
0x0000007f442b7812ULL, 0x000fe200078ec0ffULL, 0x0000000833447824ULL, 0x000fe200078e00ffULL,
0x0000007f482d7812ULL, 0x000fe200078ec0ffULL, 0x00000001292a7824ULL, 0x000fe200078e0234ULL,
0x0000007f4b4b7812ULL, 0x000fe200078ec0ffULL, 0x0000001036297824ULL, 0x000fe200078e0235ULL,
0xfffffff82f4e7812ULL, 0x000fe200078ee22cULL, 0x000000012b2c7824ULL, 0x100fe200078e0234ULL,
0x0000007f4d4d7812ULL, 0x000fe200078ec0ffULL, 0x000000012d2e7824ULL, 0x100fe200078e0234ULL,
0x0000003a33317212ULL, 0x000fe200078e3cffULL, 0x000000014b307824ULL, 0x100fe200078e0234ULL,
0x0000007f332f7812ULL, 0x000fe200078ec0ffULL, 0x000000014d327824ULL, 0x000fe200078e0234ULL,
0xfffffff844447812ULL, 0x000fe200078ee231ULL, 0x00005e002a2a7625ULL, 0x000fc800078e004fULL,
0x000000012f347824ULL, 0x000fe400078e0234ULL, 0x00005e002c2c7625ULL, 0x000fc800078e004fULL,
0x00005e002e2e7625ULL, 0x000fc800078e004fULL, 0x00005e0030307625ULL, 0x000fc800078e004fULL,
0x000000104a477824ULL, 0x100fe400078e0235ULL, 0x000000104e4b7824ULL, 0x100fe400078e0235ULL,
0x00000010444d7824ULL, 0x000fe400078e0235ULL, 0x00005e0032327625ULL, 0x000fc800078e004fULL,
0x00005e0034347625ULL, 0x000fc800078e004fULL, 0x00000010372a7825ULL, 0x000fc800078e002aULL,
0x00000010372c7825ULL, 0x040fe200078e002cULL, 0x000000002a297faeULL, 0x0003e6000c901c46ULL,
0x00000010372e7825ULL, 0x040fe200078e002eULL, 0x000000002c457faeULL, 0x0003e6000d101c46ULL,
0x0000001037307825ULL, 0x040fe200078e0030ULL, 0x000000002e477faeULL, 0x0003e6000d901c46ULL,
0x0000001037327825ULL, 0x040fe200078e0032ULL, 0x0000000030497faeULL, 0x0003e6000e101c46ULL,
0x0000001037347825ULL, 0x000fe200078e0034ULL, 0x00000000324b7faeULL, 0x0003e8000e901c46ULL,
0x00000000344d7faeULL, 0x0003e2000f101c46ULL, 0x00000a8000007947ULL, 0x000fea0003800000ULL,
0x00000003ff297819ULL, 0x004fe2000001163aULL, 0x0000000854557824ULL, 0x000fc400078e00ffULL,
0x00000100ff527424ULL, 0x000fe200078e00ffULL, 0x0000000829337810ULL, 0x040fe40007ffe0ffULL,
0x00000004292f7810ULL, 0x040fe40007ffe0ffULL, 0x0000001029477810ULL, 0x000fe20007ffe0ffULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0x00000014294b7810ULL, 0x000fe20007ffe0ffULL,
0x000000082f317824ULL, 0x000fe200078e00ffULL, 0x0000003a332c7212ULL, 0x080fe200078e3cffULL,
0x0000000847497824ULL, 0x000fe200078e00ffULL, 0x0000000c29377810ULL, 0x000fe20007ffe0ffULL,
0x000000084b307824ULL, 0x000fe200078e00ffULL, 0x0000003a2f2a7212ULL, 0x000fc400078e3cffULL,
0xfffffff835357812ULL, 0x000fe200078ee22cULL, 0x0000000837457824ULL, 0x000fe200078e00ffULL,
0x0000002029577810ULL, 0x000fe40007ffe0ffULL, 0xfffffff831317812ULL, 0x000fe400078ee22aULL,
0x00000018294f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000857677824ULL, 0x000fe200078e00ffULL,
0x0000003a472c7212ULL, 0x080fe400078e3cffULL, 0x0000003a4b2d7212ULL, 0x000fe200078e3cffULL,
0x000000084f517824ULL, 0x000fe200078e00ffULL, 0x0000001c29537810ULL, 0x000fc40007ffe0ffULL,
0x0000002429597810ULL, 0x000fe40007ffe0ffULL, 0x0000003a372a7212ULL, 0x000fe200078e3cffULL,
0x0000000853637824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe400078ee22cULL,
0xfffffff8304d7812ULL, 0x000fe200078ee22dULL, 0x0000000859307824ULL, 0x000fe200078e00ffULL,
0x00000030295f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff845457812ULL, 0x000fc400078ee22aULL,
0x00000028295b7810ULL, 0x000fe20007ffe0ffULL, 0x000000085f777824ULL, 0x000fe200078e00ffULL,
0x0000003a572c7212ULL, 0x080fe400078e3cffULL, 0x0000002c295d7810ULL, 0x000fe20007ffe0ffULL,
0x000000085b6f7824ULL, 0x000fe200078e00ffULL, 0x0000003a4f2e7212ULL, 0x080fe400078e3cffULL,
0x0000003a532a7212ULL, 0x080fe200078e3cffULL, 0x000000085d737824ULL, 0x000fe200078e00ffULL,
0x0000003a592d7212ULL, 0x000fc400078e3cffULL, 0x0000003429617810ULL, 0x000fe40007ffe0ffULL,
0xfffffff867677812ULL, 0x000fe400078ee22cULL, 0xfffffff851517812ULL, 0x000fe400078ee22eULL,
0xfffffff863637812ULL, 0x000fe400078ee22aULL, 0xfffffff8306b7812ULL, 0x000fe200078ee22dULL,
0x0000000861307824ULL, 0x000fe200078e00ffULL, 0x0000003829657810ULL, 0x000fc40007ffe0ffULL,
0x0000003a5f2c7212ULL, 0x080fe400078e3cffULL, 0x0000003a5b2e7212ULL, 0x080fe200078e3cffULL,
0x00000008657f7824ULL, 0x000fe200078e00ffULL, 0x0000003a5d2a7212ULL, 0x080fe400078e3cffULL,
0x0000003a612d7212ULL, 0x080fe400078e3cffULL, 0x0000003c29697810ULL, 0x000fe40007ffe0ffULL,
0xfffffff877777812ULL, 0x000fe200078ee22cULL, 0x00000004002c7c24ULL, 0x000fe2000f8e022bULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee22eULL, 0x0000000869837824ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe200078ee22aULL, 0x00000002032a7824ULL, 0x000fe200078e0240ULL,
0x0000003a652e7212ULL, 0x000fc400078e3cffULL, 0xfffffff8307b7812ULL, 0x000fe400078ee22dULL,
0x0000007f292b7812ULL, 0x040fe400078ec0ffULL, 0x00000007292d7812ULL, 0x000fe400078e483aULL,
0x0000007f2f2f7812ULL, 0x000fe200078ec0ffULL, 0x000000012b2b7824ULL, 0x100fe200078e022cULL,
0x0000003a69307212ULL, 0x000fe400078e3cffULL, 0x0000007f33337812ULL, 0x000fe200078ec0ffULL,
0x000000012f2f7824ULL, 0x000fe200078e022cULL, 0xfffffff87f7f7812ULL, 0x000fc400078ee22eULL,
0x0000007f37377812ULL, 0x000fe200078ec0ffULL, 0x0000000133337824ULL, 0x100fe200078e022cULL,
0x0000007f65297812ULL, 0x000fe400078ec0ffULL, 0x000020002a2e7811ULL, 0x000fe200078e68ffULL,
0x0000000137377824ULL, 0x000fe200078e022cULL, 0x0ffffff82d2d7812ULL, 0x000fe200078ef83aULL,
0x00005e002b2a7625ULL, 0x000fe200078e0052ULL, 0x0000007f47477812ULL, 0x000fe400078ec0ffULL,
0x0000007f4b4b7812ULL, 0x000fe200078ec0ffULL, 0x00000001297d7824ULL, 0x100fe200078e022cULL,
0x0000007f4f4f7812ULL, 0x000fe200078ec0ffULL, 0x0000000147477824ULL, 0x100fe200078e022cULL,
0x0000007f53537812ULL, 0x000fe200078ec0ffULL, 0x000000014b4b7824ULL, 0x100fe200078e022cULL,
0x0000007f57577812ULL, 0x000fe200078ec0ffULL, 0x000000014f4f7824ULL, 0x100fe200078e022cULL,
0x0000007f59597812ULL, 0x000fe200078ec0ffULL, 0x0000000153537824ULL, 0x100fe200078e022cULL,
0x0000007f5b5b7812ULL, 0x000fe200078ec0ffULL, 0x0000000157657824ULL, 0x000fe200078e022cULL,
0x0000007f5d5d7812ULL, 0x000fe200078ec0ffULL, 0x000000102d297824ULL, 0x000fe200078e022eULL,
0x0000007f5f5f7812ULL, 0x000fe200078ec0ffULL, 0x000000015b6d7824ULL, 0x100fe200078e022cULL,
0x0000007f61617812ULL, 0x000fe200078ec0ffULL, 0x000000015d717824ULL, 0x100fe200078e022cULL,
0x0000007f69817812ULL, 0x000fe200078ec0ffULL, 0x0000000159697824ULL, 0x000fe200078e022cULL,
0xfffffff883837812ULL, 0x000fe200078ee230ULL, 0x000000015f757824ULL, 0x000fe200078e022cULL,
0xfffffff855557812ULL, 0x000fe200078ee23aULL, 0x0000000161797824ULL, 0x000fc400078e022cULL,
0x0000000181817824ULL, 0x000fe400078e022cULL, 0x0000001031577824ULL, 0x100fe400078e022eULL,
0x0000001035597824ULL, 0x100fe400078e022eULL, 0x00000010455b7824ULL, 0x100fe400078e022eULL,
0x00000010495d7824ULL, 0x100fe400078e022eULL, 0x000000104d5f7824ULL, 0x000fc400078e022eULL,
0x0000001051617824ULL, 0x100fe400078e022eULL, 0x0000001063637824ULL, 0x100fe400078e022eULL,
0x0000001067677824ULL, 0x100fe400078e022eULL, 0x000000106b6b7824ULL, 0x100fe400078e022eULL,
0x000000106f6f7824ULL, 0x100fe400078e022eULL, 0x0000001073737824ULL, 0x000fc400078e022eULL,
0x0000001077777824ULL, 0x100fe400078e022eULL, 0x000000107b7b7824ULL, 0x100fe400078e022eULL,
0x000000107f7f7824ULL, 0x100fe400078e022eULL, 0x0000001083837824ULL, 0x000fe400078e022eULL,
0x00005e002f2c7625ULL, 0x000fc800078e0052ULL, 0x00005e00332e7625ULL, 0x000fc800078e0052ULL,
0x00005e0037307625ULL, 0x000fc800078e0052ULL, 0x00005e0047327625ULL, 0x000fc800078e0052ULL,
0x00000010552a7825ULL, 0x000fc800078e002aULL, 0x00005e004b347625ULL, 0x080fe200078e0052ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a297faeULL, 0x0003e6000b901c46ULL,
0x00005e004f367625ULL, 0x000fc800078e0052ULL, 0x00005e0053447625ULL, 0x000fc800078e0052ULL,
0x00000010552c7825ULL, 0x000fc800078e002cULL, 0x00005e0065467625ULL, 0x000fe200078e0052ULL,
0x000000002c577faeULL, 0x0005e6000b901c46ULL, 0x00000010552e7825ULL, 0x000fc800078e002eULL,
0x00005e0069487625ULL, 0x000fe200078e0052ULL, 0x000000002e597faeULL, 0x0005e6000b901c46ULL,
0x0000001055307825ULL, 0x000fc800078e0030ULL, 0x00005e006d4a7625ULL, 0x000fe200078e0052ULL,
0x00000000305b7faeULL, 0x0005e6000b901c46ULL, 0x0000001055327825ULL, 0x000fc800078e0032ULL,
0x00005e00712a7625ULL, 0x002fe200078e0052ULL, 0x00000000325d7faeULL, 0x0005e6000b901c46ULL,
0x0000001055347825ULL, 0x000fc800078e0034ULL, 0x00005e00754c7625ULL, 0x000fe200078e0052ULL,
0x00000000345f7faeULL, 0x0005e6000b901c46ULL, 0x0000001055367825ULL, 0x000fc800078e0036ULL,
0x00005e00794e7625ULL, 0x000fe200078e0052ULL, 0x0000000036617faeULL, 0x0005e6000b901c46ULL,
0x0000001055447825ULL, 0x000fc800078e0044ULL, 0x00005e007d507625ULL, 0x000fe200078e0052ULL,
0x0000000044637faeULL, 0x0005e6000b901c46ULL, 0x0000001055467825ULL, 0x000fc800078e0046ULL,
0x00005e0081527625ULL, 0x000fe200078e0052ULL, 0x0000000046677faeULL, 0x0005e6000b901c46ULL,
0x0000001055487825ULL, 0x000fc800078e0048ULL, 0x00000010554a7825ULL, 0x040fe200078e004aULL,
0x00000000486b7faeULL, 0x0005e6000b901c46ULL, 0x00000010552a7825ULL, 0x040fe200078e002aULL,
0x000000004a6f7faeULL, 0x0005e6000b901c46ULL, 0x00000010554c7825ULL, 0x040fe200078e004cULL,
0x000000002a737faeULL, 0x0005e6000b901c46ULL, 0x00000010554e7825ULL, 0x040fe200078e004eULL,
0x000000004c777faeULL, 0x0005e6000b901c46ULL, 0x0000001055507825ULL, 0x040fe200078e0050ULL,
0x000000004e7b7faeULL, 0x0005e6000b901c46ULL, 0x0000001055527825ULL, 0x000fe200078e0052ULL,
0x00000000507f7faeULL, 0x0005e8000b901c46ULL, 0x0000000052837faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5400720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff007624ULL, 0x000fc800078e00ffULL, 0x0000000200397824ULL, 0x000fe400078e0239ULL,
0xffffffffff007424ULL, 0x000fc600078e00ffULL, 0x000000063900720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000023c2a7824ULL, 0x006fe400078e0239ULL,
0x00000004ff2b7424ULL, 0x000fc800078e00ffULL, 0x000060002a2a7625ULL, 0x000fca00078e002bULL,
0x000000062a007981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010284b7824ULL, 0x006fe400078e00ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83a297812ULL, 0x000fe200078ec0ffULL, 0x00000002032d7824ULL, 0x000fe200078e0242ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014a2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000729297812ULL, 0x000fe400078ef83aULL, 0x000020002d2d7811ULL, 0x000fc400078e68ffULL,
0x000000074a287812ULL, 0x100fe400078e7829ULL, 0x000000072c2a7812ULL, 0x000fc600078e7829ULL,
0x0000000829287824ULL, 0x040fe400078e0228ULL, 0x00000008292a7824ULL, 0x000fe200078e022aULL,
0x000000203a297810ULL, 0x000fe20007ffe0ffULL, 0x0000001028287824ULL, 0x100fe400078e022dULL,
0x000000102a2a7824ULL, 0x000fe200078e022dULL, 0xfffffff829297812ULL, 0x000fe400078ec0ffULL,
0x000000002834783bULL, 0x000e640000000200ULL, 0x00000007292f7812ULL, 0x000fc400078ef83aULL,
0x000000002a30783bULL, 0x0004e40000000200ULL, 0x000000072c2c7812ULL, 0x000fca00078e782fULL,
0x000000082f2c7824ULL, 0x000fc800078e022cULL, 0x000000102c2c7824ULL, 0x000fe200078e022dULL,
0x00000018ff287819ULL, 0x002fe20000011434ULL, 0x0001000034557824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x004fe20000011435ULL, 0x00000034009f7306ULL, 0x000fe20000009400ULL,
0x00000018ff2b7819ULL, 0x000fe20000011436ULL, 0x0001000035587824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff447819ULL, 0x000fe40000011437ULL,
0x00000018ff457819ULL, 0x008fe20000011430ULL, 0x0000002800a17306ULL, 0x000fe20000209400ULL,
0x00000018ff487819ULL, 0x000fc40000011432ULL, 0x00000018ff477819ULL, 0x000fe40000011431ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff497819ULL, 0x000fe20000011433ULL,
0x0000002800a67306ULL, 0x000e700000205400ULL, 0x0000002800887306ULL, 0x0004f0000020d400ULL,
0x0000002a00ad7306ULL, 0x000fe20000209400ULL, 0x000000074a287812ULL, 0x004fc400078e782fULL,
0x000000a6a100720bULL, 0x002fe40003fdd000ULL, 0x000000024a4a7810ULL, 0x000fe20007ffe0ffULL,
0x000000082f287824ULL, 0x000fe400078e0228ULL, 0x0000002a00aa7306ULL, 0x000fe40000205400ULL,
0x0000001028287824ULL, 0x000fe400078e022dULL, 0x000000002c2c783bULL, 0x000e680000000200ULL,
0x0000002a00827306ULL, 0x000fe2000020d400ULL, 0x0000000188886812ULL, 0x008fce00078efcffULL,
0x0000002b00ac7306ULL, 0x000ff00000209400ULL, 0x0000002b00a97306ULL, 0x000ff00000205400ULL,
0x0000002b00807306ULL, 0x0005f0000020d400ULL, 0x0000003400a07306ULL, 0x000ee20000005400ULL,
0x000000002828783bULL, 0x004ea20000000200ULL, 0x00000018ff747819ULL, 0x002fc4000001142dULL,
0x00000018ff5e7819ULL, 0x000fc8000001142cULL, 0x0000003400867306ULL, 0x000322000000d400ULL,
0x00000018ff797819ULL, 0x000fe4000001142fULL, 0x00000018ff787819ULL, 0x000fca000001142eULL,
0x00000055006f7306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x002fe200078e00ffULL,
0x000000a09f00720bULL, 0x008fc80003f5d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000005500b87306ULL, 0x000e6e0000205400ULL, 0x0000000186862812ULL, 0x010fe200078efcffULL,
0x0000003500a27306ULL, 0x000ff00000009400ULL, 0x0000003500a57306ULL, 0x000ee20000005400ULL,
0x000000b86f00720bULL, 0x002fe20003f9d000ULL, 0x0001000028727824ULL, 0x004fc400078e00ffULL,
0x000100002bd37824ULL, 0x000fc600078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000003500837306ULL, 0x0002b0000000d400ULL, 0x0000003400b97306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x002fe200078e00ffULL, 0x000000a5a200720bULL, 0x008fc80003fbd000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400bc7306ULL, 0x000e6e0000205400ULL,
0x0000000183835812ULL, 0x004fe200078efcffULL, 0x00000034009b7306ULL, 0x0004e2000020d400ULL,
0x000000a9ac00720bULL, 0x000fce0003fbd000ULL, 0x0000003500c57306ULL, 0x000fe20000209400ULL,
0x0001000037347824ULL, 0x004fe200078e00ffULL, 0x000000bcb900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500c87306ULL, 0x000fe20000205400ULL,
0x0000000180805812ULL, 0x000fcc00078efcffULL, 0x000000019b9b3812ULL, 0x008fe200078efcffULL,
0x0000003500977306ULL, 0x0003e2000020d400ULL, 0x000000aaad00720bULL, 0x000fce0003f7d000ULL,
0x00000037009e7306ULL, 0x000fe20000009400ULL, 0x00000018ff357819ULL, 0x002fca0000011428ULL,
0x0000000182823812ULL, 0x000fe400078efcffULL, 0x00000037009d7306ULL, 0x000e700000005400ULL,
0x00000037007f7306ULL, 0x0005f0000000d400ULL, 0x0000005500997306ULL, 0x000722000020d400ULL,
0x0000010037377824ULL, 0x004fe200078e00ffULL, 0x0000009d9e00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003600a47306ULL, 0x000fe20000009400ULL,
0x0001000036557824ULL, 0x008fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000003600a37306ULL, 0x000e620000005400ULL, 0x0000000199994812ULL, 0x010fe400078efcffULL,
0x000000c8c500720bULL, 0x000fe40003f9d000ULL, 0x000000017f7f3812ULL, 0x000fc600078efcffULL,
0x0000003600817306ULL, 0x0004f0000000d400ULL, 0x0000003500cf7306ULL, 0x000fe20000209400ULL,
0x0000010036367824ULL, 0x004fe200078e00ffULL, 0x0000000197974812ULL, 0x000fc400078efcffULL,
0x000000a3a400720bULL, 0x002fe40003f5d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003500d27306ULL, 0x000ff00000205400ULL, 0x0000003500737306ULL, 0x0003e2000020d400ULL,
0x0000000181812812ULL, 0x008fce00078efcffULL, 0x0000003000907306ULL, 0x000fe20000009400ULL,
0x0001000030357824ULL, 0x002fce00078e00ffULL, 0x00000030008d7306ULL, 0x000ff00000005400ULL,
0x0000003000537306ULL, 0x0003f0000000d400ULL, 0x0000003400cd7306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fce00078e00ffULL, 0x0000003400d07306ULL, 0x000e700000205400ULL,
0x00000034009a7306ULL, 0x0004f0000020d400ULL, 0x0000003700d17306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fc4000001142aULL, 0x000000d0cd00720bULL, 0x002fca0003f9d000ULL,
0x0000003700d47306ULL, 0x000ff00000205400ULL, 0x00000037007c7306ULL, 0x0003e2000020d400ULL,
0x000000019a9a4812ULL, 0x008fc800078efcffULL, 0x0000007f9a9a723eULL, 0x000fc600000010ffULL,
0x0000003400c67306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x002fce000001142bULL,
0x0000003400c37306ULL, 0x000ff00000205400ULL, 0x0000003400677306ULL, 0x0003f0000020d400ULL,
0x0000003600cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x002fe20000011430ULL,
0x0001000031307824ULL, 0x000fcc00078e00ffULL, 0x0000003600c97306ULL, 0x000ff00000205400ULL,
0x0000003600937306ULL, 0x0003f0000020d400ULL, 0x0000003700bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fce0000011429ULL, 0x0000003700c27306ULL, 0x000ff00000205400ULL,
0x0000003700647306ULL, 0x0003f0000020d400ULL, 0x00000032008b7306ULL, 0x000fe20000009400ULL,
0x0001000032377824ULL, 0x002fce00078e00ffULL, 0x00000032008e7306ULL, 0x000ff00000005400ULL,
0x0000003200507306ULL, 0x0003f0000000d400ULL, 0x0000005500c77306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x002fce00078e00ffULL, 0x0000005500ca7306ULL, 0x000e700000205400ULL,
0x0000003600cb7306ULL, 0x000ff00000209400ULL, 0x0000003600ce7306ULL, 0x000fe20000205400ULL,
0x000000cac700720bULL, 0x002fce0003fdd000ULL, 0x00000036006b7306ULL, 0x0003f0000020d400ULL,
0x00000031008c7306ULL, 0x000fe20000009400ULL, 0x00000018ff367819ULL, 0x002fce0000011430ULL,
0x0000003100877306ULL, 0x000ff00000005400ULL, 0x0000003100517306ULL, 0x0003f0000000d400ULL,
0x0000003600ba7306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x002fce00078e00ffULL,
0x0000003600b77306ULL, 0x000ff00000205400ULL, 0x0000003600307306ULL, 0x0003f0000020d400ULL,
0x0000005800c47306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x002fe20000011432ULL,
0x0001000033327824ULL, 0x000fcc00078e00ffULL, 0x0000005800c17306ULL, 0x000e700000205400ULL,
0x0000005800967306ULL, 0x0005f0000020d400ULL, 0x00000055009c7306ULL, 0x000722000020d400ULL,
0x00000018ff587819ULL, 0x004fc40000011431ULL, 0x000000c1c400720bULL, 0x002fca0003f3d000ULL,
0x0000005800b57306ULL, 0x000fe20000209400ULL, 0x00000018ff557819ULL, 0x008fce0000011435ULL,
0x0000005800b67306ULL, 0x000fe20000205400ULL, 0x000000019c9c6812ULL, 0x010fe400078efcffULL,
0x000000d4d100720bULL, 0x000fe40003fdd000ULL, 0x0000000196961812ULL, 0x000fe400078efcffULL,
0x000000c9cc00720bULL, 0x000fe20003f3d000ULL, 0x0000005800317306ULL, 0x0003f0000020d400ULL,
0x0000007200d57306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x002fc40000011432ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000000193931812ULL, 0x000fc600078efcffULL,
0x0000007200d87306ULL, 0x000e700000205400ULL, 0x0000005500bd7306ULL, 0x000ff00000209400ULL,
0x0000005500c07306ULL, 0x000fe20000205400ULL, 0x000000d8d500720bULL, 0x002fce0003f9d000ULL,
0x0000005500607306ULL, 0x000ff0000020d400ULL, 0x0000003600957306ULL, 0x000ff00000209400ULL,
0x0000003600987306ULL, 0x000ff00000205400ULL, 0x0000003600557306ULL, 0x000ff0000020d400ULL,
0x0000005800717306ULL, 0x000ff00000209400ULL, 0x0000005800707306ULL, 0x000ff00000205400ULL,
0x0000005800327306ULL, 0x000ff0000020d400ULL, 0x0000002800b47306ULL, 0x000ff00000009400ULL,
0x0000002800b17306ULL, 0x000e700000005400ULL, 0x00000028006e7306ULL, 0x0004f0000000d400ULL,
0x0000007400367306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x000000b1b400720bULL, 0x002fc80003f3d000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000007400597306ULL, 0x000fee0000205400ULL, 0x000000016e6e1812ULL, 0x008fe200078efcffULL,
0x0000007400587306ULL, 0x0003e2000020d400ULL, 0x000000cecb00720bULL, 0x000fce0003f3d000ULL,
0x00000072007b7306ULL, 0x0004e2000020d400ULL, 0x0001000029747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000002800d77306ULL, 0x000fe20000209400ULL,
0x000100002a727824ULL, 0x004fe200078e00ffULL, 0x000000016b6b1812ULL, 0x000fcc00078efcffULL,
0x0000002800da7306ULL, 0x000e620000205400ULL, 0x000000017b7b4812ULL, 0x008fce00078efcffULL,
0x0000007400d97306ULL, 0x000ff00000209400ULL, 0x0000007400dc7306ULL, 0x000ea20000205400ULL,
0x000000dad700720bULL, 0x002fce0003fdd000ULL, 0x0000003300897306ULL, 0x000ff00000009400ULL,
0x00000033008a7306ULL, 0x000fe20000005400ULL, 0x000000dcd900720bULL, 0x004fce0003f9d000ULL,
0x00000033004f7306ULL, 0x0003f0000000d400ULL, 0x0000002900b27306ULL, 0x000fe20000009400ULL,
0x0000010033337824ULL, 0x002fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011433ULL,
0x0000002900b37306ULL, 0x000e700000005400ULL, 0x0000002900687306ULL, 0x0004f0000000d400ULL,
0x0000002a00b07306ULL, 0x000fe20000009400ULL, 0x0000010029297824ULL, 0x004fe200078e00ffULL,
0x000000b3b200720bULL, 0x002fc80003fbd000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00af7306ULL, 0x000e6e0000005400ULL, 0x0000000168685812ULL, 0x008fe200078efcffULL,
0x0000002a00637306ULL, 0x0004e2000000d400ULL, 0x000000c3c600720bULL, 0x000fce0003fbd000ULL,
0x0000005e00657306ULL, 0x000fe20000209400ULL, 0x000001002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000afb000720bULL, 0x002fc80003f7d000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000005e00667306ULL, 0x000fe20000205400ULL, 0x0000000167675812ULL, 0x000fe400078efcffULL,
0x000000c0bd00720bULL, 0x000fc80003fbd000ULL, 0x0000000163633812ULL, 0x008fe200078efcffULL,
0x0000005e00337306ULL, 0x000fe2000020d400ULL, 0x0000008d9000720bULL, 0x000fce0003f7d000ULL,
0x00000079005d7306ULL, 0x000fe20000209400ULL, 0x0000000160605812ULL, 0x000fca00078efcffULL,
0x0000000153533812ULL, 0x000fe400078efcffULL, 0x00000079005e7306ULL, 0x000fe20000205400ULL,
0x000000b7ba00720bULL, 0x000fe40003f7d000ULL, 0x000000536060723eULL, 0x000fca00000010ffULL,
0x00000079005f7306ULL, 0x000fec000020d400ULL, 0x0000000130303812ULL, 0x000fe400078efcffULL,
0x00000028007a7306ULL, 0x0002b0000020d400ULL, 0x0000007400797306ULL, 0x000ee2000020d400ULL,
0x00000018ff287819ULL, 0x002fce0000011472ULL, 0x0000003400bb7306ULL, 0x000fe20000209400ULL,
0x000000017a7a6812ULL, 0x004fce00078efcffULL, 0x0000003400be7306ULL, 0x000e620000205400ULL,
0x0000000179794812ULL, 0x008fc800078efcffULL, 0x000000687968723eULL, 0x000fc600000010ffULL,
0x0000003400357306ULL, 0x0004f0000020d400ULL, 0x0000002900db7306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fe40000011437ULL, 0x000000bebb00720bULL, 0x002fca0003fbd000ULL,
0x0000002900de7306ULL, 0x000e700000205400ULL, 0x0000002a00df7306ULL, 0x000fe20000209400ULL,
0x0000000135355812ULL, 0x008fce00078efcffULL, 0x0000002a00e27306ULL, 0x000ea20000205400ULL,
0x000000dedb00720bULL, 0x002fce0003fdd000ULL, 0x0000003400a77306ULL, 0x000ff00000209400ULL,
0x0000003400a87306ULL, 0x000fe20000205400ULL, 0x000000e2df00720bULL, 0x004fce0003f9d000ULL,
0x0000003400377306ULL, 0x000ff0000020d400ULL, 0x0000005b006c7306ULL, 0x000ff00000209400ULL,
0x0000005b006d7306ULL, 0x000ff00000205400ULL, 0x0000005b00347306ULL, 0x000ff0000020d400ULL,
0x00000078005a7306ULL, 0x000ff00000209400ULL, 0x00000078005b7306ULL, 0x000ff00000205400ULL,
0x00000078005c7306ULL, 0x000ff0000020d400ULL, 0x0000002b00917306ULL, 0x000ff00000009400ULL,
0x0000002b00947306ULL, 0x000e700000005400ULL, 0x0000002b00567306ULL, 0x0004f0000000d400ULL,
0x0000002900787306ULL, 0x0008e2000020d400ULL, 0x000001002b2b7824ULL, 0x004fe200078e00ffULL,
0x000000949100720bULL, 0x002fc80003f3d000ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000004400ab7306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x010fcc00000114d3ULL,
0x0000000156561812ULL, 0x008fe200078efcffULL, 0x0000004400ae7306ULL, 0x000e620000205400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x0000008e8b00720bULL, 0x000fe20003f3d000ULL,
0x000100002f8b7824ULL, 0x000fc800078e00ffULL, 0x0000002a00747306ULL, 0x0004e2000020d400ULL,
0x00000018ff8b7819ULL, 0x000fce000001148bULL, 0x0000002900d37306ULL, 0x000fe20000209400ULL,
0x000000aeab00720bULL, 0x002fe20003f5d000ULL, 0x000100002d2a7824ULL, 0x004fe200078e00ffULL,
0x0000000150501812ULL, 0x000fe400078efcffULL, 0x000000707100720bULL, 0x000fe40003f3d000ULL,
0x00000018ffab7819ULL, 0x000fe2000001142aULL, 0x0000002900d67306ULL, 0x000e620000205400ULL,
0x0000000174744812ULL, 0x008fe400078efcffULL, 0x000000c2bf00720bULL, 0x000fca0003f9d000ULL,
0x0000002800dd7306ULL, 0x000fe40000209400ULL, 0x0000000132321812ULL, 0x000fcc00078efcffULL,
0x0000002800e07306ULL, 0x000fe20000205400ULL, 0x000000d6d300720bULL, 0x002fe40003fdd000ULL,
0x0000000164644812ULL, 0x000fca00078efcffULL, 0x0000002800727306ULL, 0x0003f0000020d400ULL,
0x0000002b00a67306ULL, 0x000fe20000209400ULL, 0x000100002c287824ULL, 0x002fce00078e00ffULL,
0x0000002b00a57306ULL, 0x000ff00000205400ULL, 0x0000002b009f7306ULL, 0x0003f0000020d400ULL,
0x00000029006f7306ULL, 0x0004e2000020d400ULL, 0x000000073a2b7812ULL, 0x002fc800078ec0ffULL,
0x000000082ba97812ULL, 0x000fc600078ef83aULL, 0x0000004400777306ULL, 0x000e62000020d400ULL,
0x00000018ff297819ULL, 0x004fe40000011428ULL, 0x0000004b3a287211ULL, 0x000fe400078fe0ffULL,
0x000000044b4b7810ULL, 0x000fc60007ffe0ffULL, 0x0000002900a07306ULL, 0x000fe20000209400ULL,
0x000000016f6f6812ULL, 0x008fe400078efcffULL, 0x000000878c00720bULL, 0x000fe20003fdd000ULL,
0x000001002f8c7824ULL, 0x000fe200078e00ffULL, 0x000000566f56723eULL, 0x000fc600000010ffULL,
0x0000002900a17306ULL, 0x000fe20000205400ULL, 0x0000000177772812ULL, 0x002fe400078efcffULL,
0x000000d2cf00720bULL, 0x000fe40003f5d000ULL, 0x00000018ff8c7819ULL, 0x000fc6000001148cULL,
0x00000029009d7306ULL, 0x0003e2000020d400ULL, 0x0000000151516812ULL, 0x000fe400078efcffULL,
0x000000a8a700720bULL, 0x000fe40003fdd000ULL, 0x000000513030723eULL, 0x000fc600000010ffULL,
0x00000045008f7306ULL, 0x000fe20000209400ULL, 0x0000000728297812ULL, 0x042fe400078e78a9ULL,
0x0000000228287810ULL, 0x000fe40007ffe0ffULL, 0x0000000173732812ULL, 0x000fe200078efcffULL,
0x00000020a9297824ULL, 0x000fe200078e0229ULL, 0x000000e0dd00720bULL, 0x000fe20003f5d000ULL,
0x0000004500927306ULL, 0x000e620000205400ULL, 0x0000000137376812ULL, 0x000fe200078efcffULL,
0x0000001029297824ULL, 0x000fc600078e00ffULL, 0x000000503750723eULL, 0x000fc600000010ffULL,
0x0000002c00697306ULL, 0x000fe80000009400ULL, 0x0000000172722812ULL, 0x000fe400078efcffULL,
0x000000a5a600720bULL, 0x000fe40003f5d000ULL, 0x0000002c006a7306ULL, 0x000ea20000005400ULL,
0x000000928f00720bULL, 0x002fe40003f9d000ULL, 0x000000637272723eULL, 0x000fca00000010ffULL,
0x0000002c004e7306ULL, 0x0003e6000000d400ULL, 0x000000019f9f2812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe20003f5d000ULL, 0x000001002e8a7824ULL, 0x000fe400078e00ffULL,
0x00000045004c7306ULL, 0x000ee2000020d400ULL, 0x000001002c2c7824ULL, 0x002fe200078e00ffULL,
0x0000006a6900720bULL, 0x004fc40003fdd000ULL, 0x000000786b69723eULL, 0x000fe400000010ffULL,
0x00000018ffaa7819ULL, 0x000fe4000001142cULL, 0x00000048007e7306ULL, 0x000fe20000209400ULL,
0x00000007282c7812ULL, 0x000fe400078e78a9ULL, 0x000000002928783bULL, 0x000e620000000200ULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x00000020a9a97824ULL, 0x000fe200078e022cULL,
0x00000086992c723eULL, 0x000fe200000010ffULL, 0x00000048007d7306ULL, 0x000ea20000205400ULL,
0x000000014c4c4812ULL, 0x008fc400078efcffULL, 0x000000b6b500720bULL, 0x000fe40003f9d000ULL,
0x000000014e4e6812ULL, 0x000fe400078efcffULL, 0x000000014f4f2812ULL, 0x000fe200078efcffULL,
0x0000004800447306ULL, 0x000ee2000020d400ULL, 0x000000a1a000720bULL, 0x000fce0003f5d000ULL,
0x0000004700857306ULL, 0x000fe20000209400ULL, 0x0000007d7e00720bULL, 0x004fe40003f7d000ULL,
0x0000000131314812ULL, 0x000fc600078efcffULL, 0x000000019d9d2812ULL, 0x000fe400078efcffULL,
0x0000004700847306ULL, 0x000eac0000205400ULL, 0x0000000144443812ULL, 0x008fe400078efcffULL,
0x0000004900767306ULL, 0x000fe20000209400ULL, 0x0000006d6c00720bULL, 0x000fe20003f7d000ULL,
0x000000682814723cULL, 0x002fec0000041814ULL, 0x0000004900757306ULL, 0x000e620000205400ULL,
0x000000848500720bULL, 0x004fca0003fbd000ULL, 0x0000000134343812ULL, 0x000fe400078efcffULL,
0x0000002d00627306ULL, 0x000fe20000009400ULL, 0x000000666500720bULL, 0x000fce0003f7d000ULL,
0x0000002d00617306ULL, 0x000fe20000005400ULL, 0x000000757600720bULL, 0x002fe40003f9d000ULL,
0x0000006e7b76723eULL, 0x000fc600000010ffULL, 0x0000000133333812ULL, 0x000fe400078efcffULL,
0x0000002d004d7306ULL, 0x0003e2000000d400ULL, 0x000000593600720bULL, 0x000fce0003f7d000ULL,
0x0000004700467306ULL, 0x000ea2000020d400ULL, 0x000001002d2d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff877819ULL, 0x000fe4000001142dULL, 0x0000004900457306ULL, 0x000e62000020d400ULL,
0x0000009b882d723eULL, 0x000fe200000010ffULL, 0x000100002e887824ULL, 0x000fe200078e00ffULL,
0x0000007c779b723eULL, 0x000fe400000010ffULL, 0x0000007a7377723eULL, 0x000fe400000010ffULL,
0x00000018ff887819ULL, 0x000fe20000011488ULL, 0x000000aa00a27306ULL, 0x000fe20000209400ULL,
0x0000002c2818723cULL, 0x000fe20000041818ULL, 0x0000000146465812ULL, 0x004fc400078efcffULL,
0x000000989500720bULL, 0x000fe40003fbd000ULL, 0x000000746773723eULL, 0x000fe400000010ffULL,
0x000000aa00a37306ULL, 0x000ea20000205400ULL, 0x00000083962c723eULL, 0x000fe200000010ffULL,
0x0000009a2824723cULL, 0x040fe20000041824ULL, 0x00000097822d723eULL, 0x000fe400000010ffULL,
0x0000000145454812ULL, 0x002fe400078efcffULL, 0x0000000158583812ULL, 0x000fe200078efcffULL,
0x000000ab00a47306ULL, 0x000fe20000209400ULL, 0x0000000155555812ULL, 0x000fe200078efcffULL,
0x0000002c2808723cULL, 0x000fe20000041808ULL, 0x000000616200720bULL, 0x000fc40003fbd000ULL,
0x000000554451723eULL, 0x000fe400000010ffULL, 0x0000004f3244723eULL, 0x000fe200000010ffULL,
0x000000ab00917306ULL, 0x000e620000205400ULL, 0x000000a3a200720bULL, 0x004fe20003f9d000ULL,
0x00000010a92c7824ULL, 0x000fe200078e00ffULL, 0x00000076281c723cULL, 0x000fe2000004181cULL,
0x000000354c61723eULL, 0x000fe400000010ffULL, 0x000000314631723eULL, 0x000fe400000010ffULL,
0x0000002e00577306ULL, 0x000fe20000009400ULL, 0x000000014d4d5812ULL, 0x000fc400078efcffULL,
0x000000722810723cULL, 0x000fe20000041810ULL, 0x0000005b5a00720bULL, 0x000fe40003fbd000ULL,
0x000000344545723eULL, 0x000fe400000010ffULL, 0x0000002e00547306ULL, 0x000ea20000005400ULL,
0x00000091a400720bULL, 0x002fe40003fdd000ULL, 0x0000004e9d32723eULL, 0x000fca00000010ffULL,
0x0000002f00497306ULL, 0x000fe20000009400ULL, 0x000000015c5c5812ULL, 0x000fce00078efcffULL,
0x0000002f00527306ULL, 0x000e620000005400ULL, 0x000000545700720bULL, 0x004fe40003f3d000ULL,
0x0000009f6457723eULL, 0x000fca00000010ffULL, 0x0000002f00487306ULL, 0x0005e4000000d400ULL,
0x00000056280c723cULL, 0x000fec000004180cULL, 0x000000aa009e7306ULL, 0x000ee2000020d400ULL,
0x00000093802f723eULL, 0x004fe400000010ffULL, 0x000000524900720bULL, 0x002fca0003f5d000ULL,
0x000000ab00907306ULL, 0x000e70000020d400ULL, 0x0000008700897306ULL, 0x000fe20000209400ULL,
0x000000019e9e4812ULL, 0x008fe400078efcffULL, 0x0000000148482812ULL, 0x000fc400078efcffULL,
0x0000009e3333723eULL, 0x000fc600000010ffULL, 0x0000008700867306ULL, 0x000ea20000205400ULL,
0x0000000190906812ULL, 0x002fc800078efcffULL, 0x0000004d9090723eULL, 0x000fc600000010ffULL,
0x0000008800807306ULL, 0x000ff00000209400ULL, 0x00000088007d7306ULL, 0x000e620000205400ULL,
0x000000868900720bULL, 0x004fce0003f9d000ULL, 0x0000002e00477306ULL, 0x0004f0000000d400ULL,
0x0000008700837306ULL, 0x000f22000020d400ULL, 0x000000819c2e723eULL, 0x004fe400000010ffULL,
0x0000007d8000720bULL, 0x002fca0003fdd000ULL, 0x0000002e2820723cULL, 0x000fe20000041820ULL,
0x0000008c00287306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x0000000147471812ULL, 0x008fe400078efcffULL, 0x0000000183834812ULL, 0x010fc800078efcffULL,
0x0000008c002b7306ULL, 0x000ea20000205400ULL, 0x0000005e5d00720bULL, 0x000fe40003f9d000ULL,
0x000000835891723eULL, 0x000fca00000010ffULL, 0x00000088006e7306ULL, 0x000eec000020d400ULL,
0x000000015f5f4812ULL, 0x000fe400078efcffULL, 0x0000008a006a7306ULL, 0x000fe20000209400ULL,
0x0000002b2800720bULL, 0x004fce0003f3d000ULL, 0x0000008a006b7306ULL, 0x000ea20000205400ULL,
0x000000016e6e6812ULL, 0x008fc800078efcffULL, 0x000000476e6e723eULL, 0x000fc600000010ffULL,
0x0000008b00547306ULL, 0x000fe20000209400ULL, 0x000000602c18723cULL, 0x042fee0000041818ULL,
0x0000008b00297306ULL, 0x000e620000205400ULL, 0x0000006b6a00720bULL, 0x004fe20003f7d000ULL,
0x000000302c08723cULL, 0x040fec0000041808ULL, 0x0000008c008c7306ULL, 0x000ea4000020d400ULL,
0x000000502c20723cULL, 0x040fec0000041820ULL, 0x0000008a00637306ULL, 0x000ee2000020d400ULL,
0x000000295400720bULL, 0x002fe20003fdd000ULL, 0x000000442c24723cULL, 0x040fec0000041824ULL,
0x0000008b008b7306ULL, 0x000e62000020d400ULL, 0x000000018c8c1812ULL, 0x004fe200078efcffULL,
0x000000322c1c723cULL, 0x000fe2000004181cULL, 0x000000084a00780cULL, 0x000fc40003f25270ULL,
0x0000008c5f49723eULL, 0x000fe400000010ffULL, 0x0000000163633812ULL, 0x008fc600078efcffULL,
0x000000902c14723cULL, 0x000fe20000041814ULL, 0x000000635c6f723eULL, 0x000fe400000010ffULL,
0x000000018b8b6812ULL, 0x002fca00078efcffULL, 0x0000006e2c10723cULL, 0x000fe20000041810ULL,
0x000000488b48723eULL, 0x000fce00000010ffULL, 0x000000482c0c723cULL, 0x000fe2000004180cULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe16000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff427224ULL, 0x000fe200078e0040ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffc8e000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x01c614003d297984ULL, 0x000e620000000800ULL,
0x0000001a3b287220ULL, 0x040fe40000410000ULL, 0x000000083b1a7220ULL, 0x000fe20000410000ULL,
0x0000ffff3f087812ULL, 0x000fe200078ec0ffULL, 0x0000001b3b2a7220ULL, 0x040fe40000410000ULL,
0x000000203b207220ULL, 0x040fe20000410000ULL, 0x0000888008367816ULL, 0x000fe200000000ffULL,
0x000000213b217220ULL, 0x000fc40000410000ULL, 0x000000243b247220ULL, 0x040fe40000410000ULL,
0x0000001e3b2f7220ULL, 0x040fe40000410000ULL, 0x000000103b1b7220ULL, 0x040fe40000410000ULL,
0x8000000036087824ULL, 0x000fe400078e00ffULL, 0x000000183b187220ULL, 0x040fe40000410000ULL,
0x000000193b197220ULL, 0x000fc40000410000ULL, 0x0000000a3b2b7220ULL, 0x040fe40000410000ULL,
0x0000000b3b2c7220ULL, 0x040fe40000410000ULL, 0x000000223b2d7220ULL, 0x040fe40000410000ULL,
0x000000253b257220ULL, 0x040fe40000410000ULL, 0x000000113b1e7220ULL, 0x040fe40000410000ULL,
0x000000093b097220ULL, 0x000fc40000410000ULL, 0x000000233b2e7220ULL, 0x040fe40000410000ULL,
0x0000001c3b1c7220ULL, 0x040fe40000410000ULL, 0x0000001d3b1d7220ULL, 0x000fe20000410000ULL,
0x8000000029ff7812ULL, 0x002fe20007804808ULL, 0x0000001f3b307220ULL, 0x040fe40000410000ULL,
0x000000143b0a7220ULL, 0x040fe40000410000ULL, 0x000000153b0b7220ULL, 0x000fc40000410000ULL,
0x000000163b317220ULL, 0x040fe40000410000ULL, 0x000000173b327220ULL, 0x040fe40000410000ULL,
0x000000123b337220ULL, 0x040fe40000410000ULL, 0x000000133b347220ULL, 0x040fe40000410000ULL,
0x0000000c3b0c7220ULL, 0x040fe40000410000ULL, 0x0000000d3b1f7220ULL, 0x000fc40000410000ULL,
0x000000ffff107224ULL, 0x000fe400078e001aULL, 0x0000000e3b0d7220ULL, 0x040fe40000410000ULL,
0x0000000f3b357220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fe400078e0020ULL,
0x000000ffff137224ULL, 0x000fe400078e0021ULL, 0x000000ffff147224ULL, 0x000fc400078e0024ULL,
0x000000ffff1a7224ULL, 0x000fe400078e001bULL, 0x000000ffff0f7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0019ULL, 0x000000ffff157224ULL, 0x000fe400078e0025ULL,
0x000000ffff1b7224ULL, 0x000fe400078e001eULL, 0x000000ffff207224ULL, 0x000fc400078e0028ULL,
0x000000ffff217224ULL, 0x000fe400078e002aULL, 0x000000ffff227224ULL, 0x000fe400078e002bULL,
0x000000ffff237224ULL, 0x000fe400078e002cULL, 0x000000ffff247224ULL, 0x000fe400078e002dULL,
0x000000263b267220ULL, 0x040fe40000410000ULL, 0x000000273b277220ULL, 0x000fc40000410000ULL,
0x000000ffff117224ULL, 0x000fe400078e0009ULL, 0x000000ffff167224ULL, 0x000fe400078e001cULL,
0x000000ffff177224ULL, 0x000fe400078e001dULL, 0x000000ffff187224ULL, 0x000fe400078e000aULL,
0x000000ffff197224ULL, 0x000fe400078e000bULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff257224ULL, 0x000fe400078e002eULL, 0x000000ffff287224ULL, 0x000fe400078e002fULL,
0x000000ffff297224ULL, 0x000fe400078e0030ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0031ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2c7224ULL, 0x000fc400078e0033ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0034ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e000dULL,
0x000000ffff2f7224ULL, 0x000fe200078e0035ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000036367824ULL, 0x000fe400078e00ffULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x01c614003d097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804836ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000043a1d7824ULL, 0x000fe200078e00ffULL, 0x0000003e0500720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff01d1c7812ULL, 0x000fca00078ec0ffULL,
0x00000080031c7824ULL, 0x000fca00078e021cULL, 0x01c400001c087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000023a0c7824ULL, 0x000fe400078e00ffULL,
0x0000000104417824ULL, 0x000fc600078e0a41ULL, 0x000000060c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c307812ULL, 0x040fe400078efcffULL, 0x000000080c327812ULL, 0x000fe400078efcffULL,
0x000000413000720cULL, 0x080fe40003f26070ULL, 0x000000100c307812ULL, 0x000fe400078efcffULL,
0x000000413200720cULL, 0x080fe40003f06070ULL, 0x000000413000720cULL, 0x000fc40003fc6070ULL,
0x000000110c327812ULL, 0x040fe400078efcffULL, 0x000000180c307812ULL, 0x040fe400078efcffULL,
0x000000410c00720cULL, 0x080fe40003f46070ULL, 0x000000413200720cULL, 0x080fe40003fa6070ULL,
0x000000413000720cULL, 0x000fe40003f66070ULL, 0x000000090c347812ULL, 0x000fc400078efcffULL,
0x000000190c327812ULL, 0x040fe400078efcffULL, 0x000000200c307812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x000000413400720cULL, 0x080fe40003f86070ULL, 0x000000413200720cULL, 0x080fe40003f46070ULL,
0x000000413000720cULL, 0x000fe40003f26070ULL, 0x000000210c327812ULL, 0x040fe400078efcffULL,
0x000000280c307812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x000000413200720cULL, 0x080fe40003f06070ULL,
0x000000413000720cULL, 0x000fe40003f86070ULL, 0x000000290c327812ULL, 0x000fc400078efcffULL,
0x000000300c307812ULL, 0x000fe400078efcffULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x000000413200720cULL, 0x000fc40003fc6070ULL,
0x000000413000720cULL, 0x000fe40003fa6070ULL, 0x000000310c327812ULL, 0x040fe400078efcffULL,
0x000000380c307812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff28287808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x000000413200720cULL, 0x080fe40003f66070ULL, 0x000000413000720cULL, 0x000fc40003f46070ULL,
0x000000410c00720cULL, 0x000fe40003f26070ULL, 0xff7fffff29297808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff2b2b7808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff2e2e7808ULL, 0x000fc40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40004800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f080d7209ULL, 0x004fe40007810000ULL, 0x0000002009087209ULL, 0x000fe40007810000ULL,
0x0000000e0d0d7209ULL, 0x000fe40007810000ULL, 0x0000002108097209ULL, 0x000fc40007810000ULL,
0x000000100d087209ULL, 0x000fe40007810000ULL, 0x00000022090c7209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x000000230c0d7209ULL, 0x000fe40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x000000240d0c7209ULL, 0x000fc40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x000000250c0d7209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x000000260d0c7209ULL, 0x000fe40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x000000270c0d7209ULL, 0x000fc40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x000000280d0c7209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x000000290c0d7209ULL, 0x000fe40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000002a0d0c7209ULL, 0x000fc40007810000ULL,
0x0000001908097209ULL, 0x000fe40007810000ULL, 0x0000002b0c0d7209ULL, 0x000fe40007810000ULL,
0x0000001a09087209ULL, 0x000fe40007810000ULL, 0x0000002c0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001b08097209ULL, 0x000fe40007810000ULL, 0x0000002d0c0d7209ULL, 0x000fc40007810000ULL,
0x0000001e09087209ULL, 0x000fe40007810000ULL, 0x0000002e0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001f08097209ULL, 0x000fe40007810000ULL, 0x0000002f0c337209ULL, 0x000fe20007810000ULL,
0x00000dc27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009087f89ULL, 0x0004e400000e0000ULL,
0x0000000809347209ULL, 0x008fe20007810000ULL, 0x00000e127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0033087f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x004ea800000e0000ULL,
0x0c401f000b307f89ULL, 0x000f2200000e0000ULL, 0x00000008330c7209ULL, 0x008fc60007810000ULL,
0x0c201f0034087f89ULL, 0x000ee200000e0000ULL, 0x000000090a0d7209ULL, 0x004fc60007810000ULL,
0x0c201f000c097f89ULL, 0x000ea200000e0000ULL, 0x000000300b307209ULL, 0x010fc60007810000ULL,
0x0c201f000d327f89ULL, 0x002e6800000e0000ULL, 0x0c201f0030317f89ULL, 0x00092200000e0000ULL,
0x0000000834087209ULL, 0x008fe40007810000ULL, 0x000000090c097209ULL, 0x004fe40007810000ULL,
0x000000320d0a7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fc40000000000ULL, 0x00000005ff337e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL,
0x0000000000087886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x0000000f000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b12127823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b13137823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL,
0x0000000e000d7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f0b7823ULL, 0x000fe2000001080bULL,
0x0000000c0d0c723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b091f7820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001081fULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x00000010110e723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b25257823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001081fULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b29297823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081fULL,
0x00000022000f7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2f1f7823ULL, 0x000fe2000001081fULL, 0x0000002300327308ULL, 0x0008a20000000800ULL,
0x3f8000003322783eULL, 0x008fe400000010ffULL, 0x00000020210d723eULL, 0x002fca00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000ffff237224ULL, 0x010fe200078e0022ULL,
0x0000000f320f723eULL, 0x004fcc00000010ffULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x000000220c34723cULL, 0x000fe200000418ffULL, 0x000000121310723eULL, 0x002fcc00000010ffULL,
0x0000001500157308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x000000141512723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000242511723eULL, 0x004fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000262713723eULL, 0x002fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000221034723cULL, 0x000fee0000041834ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000181916723eULL, 0x004fe200000010ffULL, 0x0000000fff197424ULL, 0x000fe200078e00ffULL,
0xfffffffc3a187812ULL, 0x000fc800078ec0ffULL, 0x0000001819247219ULL, 0x000fe200000006ffULL,
0x0000002a002a7308ULL, 0x000fe60000000800ULL, 0x00000000242173a1ULL, 0x000ea200000e8000ULL,
0x00000000240573c4ULL, 0x000ee80000004000ULL, 0x0000002b002b7308ULL, 0x000f220000000800ULL,
0x000000282915723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000002a2b17723eULL, 0x010fce00000010ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000824ff7c12ULL, 0x004fe2000f804021ULL, 0x000000221434723cULL, 0x000fec0000041834ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000010ffULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0000001e0b1a723eULL, 0x004fe400000010ffULL,
0x00000030310b7209ULL, 0x000fca0007810000ULL, 0x0000002e002e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x0000002c2d19723eULL, 0x002fe400000010ffULL,
0x0000002e1f1b723eULL, 0x004fce00000010ffULL, 0x000000221834723cULL, 0x000fe20000041834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000a0205008947ULL, 0x008fde000b800000ULL,
0x001c1fff34207589ULL, 0x0002a400000e0000ULL, 0x00000000241f73a1ULL, 0x000ee200000e8000ULL,
0x00000000240573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x0000000824ff7c12ULL, 0x008fda000f80401fULL, 0x00000a1205008947ULL, 0x010fea000b800000ULL,
0x001c1fff36217589ULL, 0x00072800000e0000ULL, 0x001c1fff01227589ULL, 0x00066800000e0000ULL,
0x001c1fff23237589ULL, 0x0006a400000e0000ULL, 0x00000002ff1e7819ULL, 0x000fe4000001163aULL,
0x0000000c1d417812ULL, 0x000fc400078ec0ffULL, 0x000000071e1f7812ULL, 0x040fe200078ec0ffULL,
0x000000081e287824ULL, 0x040fe200078e00ffULL, 0x0000001eff267212ULL, 0x002fe200078e33ffULL,
0x000000081e247824ULL, 0x008fe200078e00ffULL, 0x000000033aff7812ULL, 0x000fe2000780c0ffULL,
0x000000081e337824ULL, 0x040fe200078e00ffULL, 0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff828257812ULL, 0x100fe400078ee21fULL, 0x0000000124277812ULL, 0x100fe200078ef61fULL,
0x000000081e4d7824ULL, 0x000fe200078e00ffULL, 0x0000000224297812ULL, 0x100fe200078ef61fULL,
0x000000081e287824ULL, 0x000fe200078e00ffULL, 0x00000003242b7812ULL, 0x000fc400078ef61fULL,
0x00000004242d7812ULL, 0x140fe400078ef61fULL, 0x00000005242f7812ULL, 0x140fe400078ef61fULL,
0x0000000624317812ULL, 0x000fe200078ef61fULL, 0x000000081e247824ULL, 0x040fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe400078ee226ULL, 0x0000001eff267212ULL, 0x000fe400078e33ffULL,
0x000000071e1f7812ULL, 0x000fc400078ec0ffULL, 0x00012000031e7811ULL, 0x000fe400078e58ffULL,
0xfffffff828357812ULL, 0x100fe400078ee21fULL, 0x0000000124377812ULL, 0x140fe200078ef61fULL,
0x00000010251d7824ULL, 0x100fe200078e021eULL, 0x0000000224437812ULL, 0x140fe200078ef61fULL,
0x000000102d287824ULL, 0x100fe200078e021eULL, 0x0000000324457812ULL, 0x040fe200078ef61fULL,
0x00000001411d7824ULL, 0x000fe200078e021dULL, 0x0000000424477812ULL, 0x140fe200078ef61fULL,
0x000000102f2a7824ULL, 0x100fe200078e021eULL, 0x0000000524497812ULL, 0x140fe200078ef61fULL,
0x00000010312c7824ULL, 0x100fe200078e021eULL, 0x00000006244b7812ULL, 0x000fe200078ef61fULL,
0x00000010271f7824ULL, 0x000fe200078e021eULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee226ULL,
0x0000001029247824ULL, 0x100fe200078e021eULL, 0x0000000c1d007388ULL, 0x0003e20000000800ULL,
0x000000102b267824ULL, 0x000fc400078e021eULL, 0x00000001411f7824ULL, 0x040fe400078e021fULL,
0x0000000141257824ULL, 0x000fe400078e0224ULL, 0x00000010332e7824ULL, 0x000fe200078e021eULL,
0x0000000e1f007388ULL, 0x0007e20000000800ULL, 0x0000000141277824ULL, 0x000fe400078e0226ULL,
0x0000001035307824ULL, 0x000fe200078e021eULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x0000000141297824ULL, 0x000fc400078e0228ULL, 0x0000001037317824ULL, 0x000fe200078e021eULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x00000001412b7824ULL, 0x000fe400078e022aULL,
0x0000001043327824ULL, 0x000fe200078e021eULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x00000001412d7824ULL, 0x000fe400078e022cULL, 0x0000001045337824ULL, 0x000fe200078e021eULL,
0x000000162b007388ULL, 0x0007e20000000800ULL, 0x00000001412f7824ULL, 0x000fc400078e022eULL,
0x0000001047347824ULL, 0x100fe200078e021eULL, 0x000000182d007388ULL, 0x0007e20000000800ULL,
0x0000001049357824ULL, 0x100fe400078e021eULL, 0x000000104b367824ULL, 0x100fe200078e021eULL,
0x0000001a2f007388ULL, 0x0007e20000000800ULL, 0x000000104d377824ULL, 0x000fe400078e021eULL,
0x0000000141307824ULL, 0x040fe400078e0230ULL, 0x00000001411e7824ULL, 0x000fc400078e0231ULL,
0x0000000141327824ULL, 0x040fe200078e0232ULL, 0x0000000d30007388ULL, 0x0007e20000000800ULL,
0x00000001410c7824ULL, 0x042fe400078e0233ULL, 0x0000000141347824ULL, 0x040fe200078e0234ULL,
0x0000000f1e007388ULL, 0x0007e20000000800ULL, 0x0000000141247824ULL, 0x040fe400078e0235ULL,
0x0000000141367824ULL, 0x040fe200078e0236ULL, 0x0000001132007388ULL, 0x0007e20000000800ULL,
0x0000000141267824ULL, 0x000fc600078e0237ULL, 0x000000130c007388ULL, 0x0007e80000000800ULL,
0x0000001534007388ULL, 0x0007e80000000800ULL, 0x0000001724007388ULL, 0x0007e80000000800ULL,
0x0000001936007388ULL, 0x0007e80000000800ULL, 0x0000001b26007388ULL, 0x0007e80000000800ULL,
0x01c000081c008388ULL, 0x0007e80000000c00ULL, 0x01c200201c008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030005057a10ULL, 0x000fe20007ffe0ffULL,
0x01c608003dff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff3fff7812ULL, 0x000fc4000780c0ffULL,
0x000000070500720cULL, 0x000fe40003f26070ULL, 0x00000001ff3f7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffae2000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff317224ULL, 0x000fe200078e0009ULL,
0x0001ee90000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x000fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000063000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0031ULL,
0xfffff1d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x000fe200078e0033ULL,
0x0001ef10000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x000005b000007944ULL, 0x024fea0003c00000ULL, 0x0000003133367209ULL, 0x004fe20007810000ULL,
0x000000ffff317224ULL, 0x000fe200078e000aULL, 0x0001ef80000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000054000007944ULL, 0x000fea0003c00000ULL,
0x000000310a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff317224ULL, 0x000fe200078e000bULL,
0x0001eff0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x000000310b307209ULL, 0x004fe20007810000ULL,
0x000000ffff317224ULL, 0x000fe200078e0034ULL, 0x0001f060000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000046000007944ULL, 0x000fea0003c00000ULL,
0x0000003134087209ULL, 0x004fe20007810000ULL, 0x000000ffff317224ULL, 0x000fe200078e0036ULL,
0x0001f0d0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000003136097209ULL, 0x004fe20007810000ULL,
0x000000ffff317224ULL, 0x000fe200078e000aULL, 0x0001f140000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x000000310a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff317224ULL, 0x000fe200078e0030ULL,
0x0001f1b0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0xffffefb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e0034ULL, 0x0001f210001e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fe400078e00ffULL, 0x00001c1fff277424ULL, 0x000fe400078e00ffULL,
0x000002f000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0023ULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x002fe200078e0036ULL,
0x0001f280001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe400078e00ffULL,
0x00001c1fff277424ULL, 0x000fc400078e00ffULL, 0x0000028000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff267224ULL, 0x002fe200078e00ffULL, 0x0001f2d0001e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff277424ULL, 0x000fc400078e00ffULL, 0x000000ffff217224ULL, 0x004fe400078e0023ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff267224ULL, 0x002fe200078e00ffULL,
0x0001f320001e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff277424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0023ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0xfffff52000007947ULL, 0x000fea000383ffffULL, 0x0180000036047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003600048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff36ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff047807ULL, 0x000fc80000000000ULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000036057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003600047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x00cfe400078e0004ULL, 0x000000ffff047224ULL, 0x000fe400078e0008ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe0b4004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000004200007348ULL, 0x000fe80003800000ULL,
0x0c00003231317389ULL, 0x0002a200000e0035ULL, 0xfffe0b000c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000002400007348ULL, 0x000fe80003800000ULL,
0x0000002625237389ULL, 0x0002a200000e0027ULL, 0xfffe0ac01e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000210ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007a8ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000820ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eccULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f00ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f20ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f90ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f98ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000fa8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x000000000001f600ULL, 0xff00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020780ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000020790ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020790ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000020c10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f90ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001f7f0ULL, 0x000000000001f7f0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000020780ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000020c10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_80_cubin_len = 134384;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
