/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000020a10ULL, 0x0000000000020590ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001e900ULL, 0x0000000000000180ULL,
0x000e002200000106ULL, 0x000000000001ea80ULL, 0x0000000000000050ULL, 0x000e002200000131ULL,
0x000000000001ead0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000001eb10ULL,
0x00000000000000f0ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001ec00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001e90000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x0078d80400288080ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9408288080840828ULL, 0x2880809508288080ULL, 0x8097082880809608ULL, 0x082880809e082880ULL,
0x8080a7082880809fULL, 0xaa08288080a80828ULL, 0x288080ab08288080ULL, 0x80ae08288080ad08ULL,
0x08288080af082880ULL, 0x8080b308288080b2ULL, 0xb708288080b40828ULL, 0x288080bf08288080ULL,
0x80c808288080c708ULL, 0x08288080da082880ULL, 0x8080e308288080e2ULL, 0x8508288080e40828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808085920000ULL, 0x0000000000000022ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001e90000000000ULL, 0x0000018000000000ULL,
0x0000480400000000ULL, 0x8080288080840900ULL, 0x0900000010042880ULL, 0x2880808428808085ULL,
0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8b082880808a0828ULL, 0x2880809208288080ULL,
0x809a082880809308ULL, 0x082880809b082880ULL, 0x80809e082880809dULL, 0xa2082880809f0828ULL,
0x288080a308288080ULL, 0x80aa08288080a708ULL, 0x08288080ab082880ULL, 0x8080af08288080aeULL,
0xb708288080b40828ULL, 0x288080bf08288080ULL, 0x80c808288080c708ULL, 0x08288080da082880ULL,
0x8080e308288080e2ULL, 0x8908288080e40828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808089920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000018000000000ULL,
0x0001ea8000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8088288080890900ULL,
0x0000000000002880ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8a08288080890828ULL,
0x2880808b08288080ULL, 0x8093082880809208ULL, 0x082880809a082880ULL, 0x80809d082880809bULL,
0x9f082880809e0828ULL, 0x288080a208288080ULL, 0x80a708288080a308ULL, 0x08288080aa082880ULL,
0x8080ae08288080abULL, 0xb408288080af0828ULL, 0x288080b708288080ULL, 0x80c708288080bf08ULL,
0x08288080c8082880ULL, 0x8080e308288080e2ULL, 0xda08288080e40828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080da920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000028800000000ULL, 0x0001ead000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8a08288080890828ULL, 0x2880808b08288080ULL,
0x8093082880809208ULL, 0x082880809a082880ULL, 0x80809d082880809bULL, 0x9f082880809e0828ULL,
0x288080a208288080ULL, 0x80a708288080a308ULL, 0x08288080aa082880ULL, 0x8080ae08288080abULL,
0xb408288080af0828ULL, 0x288080b708288080ULL, 0x80c708288080bf08ULL, 0x08288080da082880ULL,
0x8080e308288080e2ULL, 0xc808288080e40828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080c8920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000038000000000ULL,
0x0001eb1000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL,
0x00081204000000f1ULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0050190300500160ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x001c310400ff1b03ULL, 0x0001cde000000020ULL, 0x0001cfc00001cfb0ULL, 0x0001d1100001d100ULL,
0x01c829040001d120ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000d001c82804ULL, 0x00001500000000e0ULL,
0x0000162000001580ULL, 0x00001a3000001650ULL, 0x00001ad000001a60ULL, 0x00003fe000001b40ULL,
0x0000406000004000ULL, 0x00006510000040c0ULL, 0x0000664000006590ULL, 0x00006a2000006760ULL,
0x00006aa000006a40ULL, 0x00008e1000006b00ULL, 0x00008e9000008e30ULL, 0x0000b2c000008ef0ULL,
0x0000b3f00000b340ULL, 0x0000b7d00000b510ULL, 0x0000b8500000b7f0ULL, 0x0000dbc00000b8b0ULL,
0x0000dc400000dbe0ULL, 0x000100700000dca0ULL, 0x000101a0000100f0ULL, 0x00010580000102c0ULL,
0x00010600000105a0ULL, 0x0001299000010660ULL, 0x00012a10000129b0ULL, 0x00014c3000012a70ULL,
0x000153c000014c40ULL, 0x000170d000016f20ULL, 0x00017710000176d0ULL, 0x0001c9a000017f30ULL,
0x0001c9e00001c9d0ULL, 0x0001ca200001c9f0ULL, 0x0001ca500001ca40ULL, 0x0001d0f00001ca60ULL,
0x0001d1600001d150ULL, 0x0001d8800001d170ULL, 0x0001d9300001d8c0ULL, 0x0001da200001d9b0ULL,
0x0001daf00001da90ULL, 0x0001dbb00001db60ULL, 0x0001dc600001dbf0ULL, 0x0001dd200001dcd0ULL,
0x0001ddf00001dd90ULL, 0x0001deb00001de60ULL, 0x0001df600001def0ULL, 0x0001e0200001dfd0ULL,
0x0001e0f00001e090ULL, 0x0001e1b00001e160ULL, 0x0001e2600001e1f0ULL, 0x0001e3300001e2d0ULL,
0x0001e4100001e3a0ULL, 0x0001e4e00001e480ULL, 0x0001e5800001e530ULL, 0x0001e6200001e5d0ULL,
0x0001e6c00001e670ULL, 0x0001e7900001e710ULL, 0x0001e8700001e810ULL, 0x070039040001e8d0ULL,
0x000000ff00000210ULL, 0x003f010000010600ULL, 0x0000000000000250ULL, 0x003f012000010608ULL,
0x00000000000002c0ULL, 0x003f012000010688ULL, 0x0000000000000390ULL, 0x003f0120000106a8ULL,
0x000000ff000003c0ULL, 0x003f0100000106b8ULL, 0x000000ff000004d0ULL, 0x003f010700010600ULL,
0x0000002c00000670ULL, 0x003f01020001068cULL, 0x0000002c000009f0ULL, 0x003f010100010688ULL,
0x000000ff00000b40ULL, 0x003f0107000106a8ULL, 0x000000ff00000bc0ULL, 0x003f0101000106a8ULL,
0x000000ff00000c20ULL, 0x003f0101000106b8ULL, 0x000000ff00000d60ULL, 0x003f0105000106bcULL,
0x000000ff00000db0ULL, 0x003f0105000106bcULL, 0x000000ff00000e30ULL, 0x003f0105000106bcULL,
0x000000ff00001270ULL, 0x003f0107000106b0ULL, 0x000000ff000012f0ULL, 0x003f0101000106b0ULL,
0x000000ff00001300ULL, 0x003f0105000106acULL, 0x0000002c00001370ULL, 0x003f010100010608ULL,
0x0000002c00001390ULL, 0x003f01050001060cULL, 0x0000002c00001420ULL, 0x003f01050001060cULL,
0x000000ff00001910ULL, 0x003f0105000106acULL, 0x000000ff00001990ULL, 0x003f0105000106acULL,
0x000000ff00003a30ULL, 0x003f0101000106b8ULL, 0x000000ff00003a40ULL, 0x003f0105000106bcULL,
0x000000ff00003a90ULL, 0x003f0105000106bcULL, 0x000000ff00003b10ULL, 0x003f0105000106bcULL,
0x000000ff00003de0ULL, 0x003f0107000106a8ULL, 0x000000ff00003e60ULL, 0x003f0101000106a8ULL,
0x000000ff00003e70ULL, 0x003f0105000106b4ULL, 0x000000ff00003ed0ULL, 0x003f0105000106b4ULL,
0x000000ff00003f50ULL, 0x003f0105000106b4ULL, 0x000000ff00005ec0ULL, 0x003f0101000106b8ULL,
0x000000ff00005f30ULL, 0x003f010100010688ULL, 0x000000ff00005f70ULL, 0x003f0105000106bcULL,
0x000000ff00005fc0ULL, 0x003f0105000106bcULL, 0x000000ff00006040ULL, 0x003f0105000106bcULL,
0x000000ff000062d0ULL, 0x003f0107000106b0ULL, 0x000000ff00006350ULL, 0x003f0101000106b0ULL,
0x000000ff00006360ULL, 0x003f0105000106acULL, 0x0000002c000063d0ULL, 0x003f010100010628ULL,
0x0000002c000063f0ULL, 0x003f01050001062cULL, 0x0000002c00006480ULL, 0x003f01050001062cULL,
0x000000ff00006910ULL, 0x003f0105000106acULL, 0x000000ff00006990ULL, 0x003f0105000106acULL,
0x000000ff000088a0ULL, 0x003f0101000106b8ULL, 0x000000ff000088b0ULL, 0x003f0105000106bcULL,
0x000000ff00008900ULL, 0x003f0105000106bcULL, 0x000000ff00008980ULL, 0x003f0105000106bcULL,
0x000000ff00008c10ULL, 0x003f0107000106a8ULL, 0x000000ff00008c90ULL, 0x003f0101000106a8ULL,
0x000000ff00008ca0ULL, 0x003f0105000106b4ULL, 0x000000ff00008d00ULL, 0x003f0105000106b4ULL,
0x000000ff00008d80ULL, 0x003f0105000106b4ULL, 0x000000ff0000ac70ULL, 0x003f0101000106b8ULL,
0x000000ff0000ace0ULL, 0x003f010100010690ULL, 0x000000ff0000ad20ULL, 0x003f0105000106bcULL,
0x000000ff0000ad70ULL, 0x003f0105000106bcULL, 0x000000ff0000adf0ULL, 0x003f0105000106bcULL,
0x000000ff0000b080ULL, 0x003f0107000106b0ULL, 0x000000ff0000b100ULL, 0x003f0101000106b0ULL,
0x000000ff0000b110ULL, 0x003f0105000106acULL, 0x0000002c0000b180ULL, 0x003f010100010648ULL,
0x0000002c0000b1a0ULL, 0x003f01050001064cULL, 0x0000002c0000b230ULL, 0x003f01050001064cULL,
0x000000ff0000b6c0ULL, 0x003f0105000106acULL, 0x000000ff0000b740ULL, 0x003f0105000106acULL,
0x000000ff0000d650ULL, 0x003f0101000106b8ULL, 0x000000ff0000d660ULL, 0x003f0105000106bcULL,
0x000000ff0000d6b0ULL, 0x003f0105000106bcULL, 0x000000ff0000d730ULL, 0x003f0105000106bcULL,
0x000000ff0000d9c0ULL, 0x003f0107000106a8ULL, 0x000000ff0000da40ULL, 0x003f0101000106a8ULL,
0x000000ff0000da50ULL, 0x003f0105000106b4ULL, 0x000000ff0000dab0ULL, 0x003f0105000106b4ULL,
0x000000ff0000db30ULL, 0x003f0105000106b4ULL, 0x000000ff0000fa20ULL, 0x003f0101000106b8ULL,
0x000000ff0000fa90ULL, 0x003f010100010698ULL, 0x000000ff0000fad0ULL, 0x003f0105000106bcULL,
0x000000ff0000fb20ULL, 0x003f0105000106bcULL, 0x000000ff0000fba0ULL, 0x003f0105000106bcULL,
0x000000ff0000fe30ULL, 0x003f0107000106b0ULL, 0x000000ff0000feb0ULL, 0x003f0101000106b0ULL,
0x000000ff0000fec0ULL, 0x003f0105000106acULL, 0x0000002c0000ff30ULL, 0x003f010100010668ULL,
0x0000002c0000ff50ULL, 0x003f01050001066cULL, 0x0000002c0000ffe0ULL, 0x003f01050001066cULL,
0x000000ff00010470ULL, 0x003f0105000106acULL, 0x000000ff000104f0ULL, 0x003f0105000106acULL,
0x000000ff000123f0ULL, 0x003f0101000106b8ULL, 0x000000ff00012400ULL, 0x003f0105000106bcULL,
0x000000ff00012450ULL, 0x003f0105000106bcULL, 0x000000ff000124d0ULL, 0x003f0105000106bcULL,
0x000000ff00012790ULL, 0x003f0107000106a8ULL, 0x000000ff00012810ULL, 0x003f0101000106a8ULL,
0x000000ff00012820ULL, 0x003f0105000106b4ULL, 0x000000ff00012880ULL, 0x003f0105000106b4ULL,
0x000000ff00012900ULL, 0x003f0105000106b4ULL, 0x000000ff000147f0ULL, 0x003f0101000106b8ULL,
0x000000ff00014850ULL, 0x003f0101000106a0ULL, 0x000000ff00018230ULL, 0x003f010100010600ULL,
0x000000ff00018d20ULL, 0x003f010500010604ULL, 0x000000ff00018dc0ULL, 0x003f010500010604ULL,
0x000000ff000190e0ULL, 0x003f010100010600ULL, 0x000000ff000190f0ULL, 0x003f010500010604ULL,
0x000000ff00019180ULL, 0x003f010500010604ULL, 0x0000003b0001be20ULL, 0x003f010100000000ULL,
0x0000003b0001be60ULL, 0x003f010500000004ULL, 0x0000003b0001c2a0ULL, 0x003f010500000004ULL,
0x000000390001d6e0ULL, 0x003f010100000000ULL, 0x000000390001d740ULL, 0x003f010100000008ULL,
0x000000390001d7a0ULL, 0x003f010100000010ULL, 0x000000390001d810ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x000191e000018180ULL, 0x0001d85000019280ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000464ULL, 0x0000001200000002ULL, 0x000000000000036cULL,
0x0000001200000002ULL, 0x0000000000000264ULL, 0x0000001200000002ULL, 0x0000000000000154ULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000043aULL,
0x0000001200000002ULL, 0x0000000000000342ULL, 0x0000001200000002ULL, 0x000000000000023aULL,
0x0000001200000002ULL, 0x000000000000012aULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000007919ULL, 0x000ea20000002300ULL, 0x0000000e00057300ULL, 0x000ee600000e0000ULL,
0x0000000000027919ULL, 0x000f280000002200ULL, 0x0000000000267919ULL, 0x000f620000002600ULL,
0x0000000e00107309ULL, 0x0002a60000000000ULL, 0x00000000002b7919ULL, 0x000ee80000002700ULL,
0x0000000000067919ULL, 0x000ee20000000000ULL, 0x00000005ff257819ULL, 0x002fc60000011603ULL,
0x00000000002d7919ULL, 0x000e680000000000ULL, 0x00001fff000a7589ULL, 0x0049e800000e0000ULL,
0x00001fff25257589ULL, 0x000ea200000e0000ULL, 0x0000000100007824ULL, 0x010fe400078e0202ULL,
0x0000000826027824ULL, 0x020fc400078e00ffULL, 0x0000008000007824ULL, 0x000fe400078e0203ULL,
0x00005800ff037624ULL, 0x000fe200078e00ffULL, 0x000000060500720cULL, 0x008fe40003f02070ULL,
0x000000ff0000720cULL, 0x040fe20003f25270ULL, 0x0000000803037824ULL, 0x000fe200078e00ffULL,
0x0000000f0000780cULL, 0x040fe40003f44070ULL, 0x0000007f0000780cULL, 0x040fe20003f84070ULL,
0x0000002b03087224ULL, 0x000fe200078e0202ULL, 0x000000030000780cULL, 0x000fe20003f64070ULL,
0x000000040a047824ULL, 0x004fcc00078e0225ULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x0000000204097824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x00000008090b7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL, 0x01060002ff009388ULL, 0x0005e20000000a00ULL,
0xff317217ff0cc424ULL, 0x000fe200078e00ffULL, 0x00000001090d7810ULL, 0x000fe20007ffe0ffULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x010608040000a388ULL, 0x0007e20000008a00ULL,
0x000000010000780cULL, 0x000fe20003f44070ULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x000000070d0e7812ULL, 0x000fe200078ec0ffULL, 0x0104000c0000c388ULL, 0x0009e20000004800ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a09ULL, 0x0000000709027812ULL, 0x004fc400078ec0ffULL,
0x010688060000b388ULL, 0x0005e20000008a00ULL, 0x0000001f0e0e7812ULL, 0x102fe400078e782dULL,
0x0000001f02037812ULL, 0x000fe200078e782dULL, 0x0000000108027824ULL, 0x040fe200078e0209ULL,
0x000000ff0b00720cULL, 0x040fe20003f63070ULL, 0x0000000108047824ULL, 0x008fe200078e020dULL,
0x000000010b00780cULL, 0x000fe20003f83070ULL, 0x00000020090c7824ULL, 0x010fe400078e0203ULL,
0x3fffff80ff089424ULL, 0x000fc400078e00ffULL, 0x3fffff00ff06a424ULL, 0x004fe400078e00ffULL,
0x7fffff00ff07a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff099424ULL, 0x000fe400078e00ffULL,
0x00000200ff057424ULL, 0x000fe200078e00ffULL, 0x0106a8060000a388ULL, 0x0003e20000008a00ULL,
0x000000102d0b7824ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x080fe200078e0005ULL,
0x0106b808ff009388ULL, 0x0005e40000000a00ULL, 0x000001f00b0f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0004047625ULL, 0x000fe200078e0005ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000f02027210ULL, 0x080fe20007fbe0ffULL, 0x000000200d0e7824ULL, 0x000fe200078e020eULL,
0x0000000f04047210ULL, 0x000fe20007f5e0ffULL, 0x000000100c0c7824ULL, 0x000fc400078e00ffULL,
0x000000ffff037224ULL, 0x000fe400028e0603ULL, 0x000000ffff057224ULL, 0x000fe400010e0605ULL,
0x000000100e0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x002fe200078e0a10ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020c7faeULL, 0x0003e8000d901c46ULL,
0x00000000040e7faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000004ff027424ULL, 0x000fc600078e00ffULL, 0x01060400ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x000060002b027625ULL, 0x000fc600078e0002ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000602247981ULL, 0x0042a2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x00000004ff037e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff24027810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff027819ULL, 0x000fce0000011602ULL, 0x00017bb000008947ULL, 0x000fea0003800000ULL,
0x0000580026007a10ULL, 0x000fe20007ffe0ffULL, 0x000000022b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000103047810ULL, 0x000fe20007ffe0ffULL, 0x00000008252c7824ULL, 0x000fe400078e00ffULL,
0x000058002b2b7a24ULL, 0x000fe200078e0200ULL, 0x000000020400720cULL, 0x000fe20003f06070ULL,
0x00000003ff007424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff077819ULL, 0x000fe2000001162dULL, 0x01068c002cff738cULL, 0x0003e20000000000ULL,
0x000000f00b147812ULL, 0x000fe200078ec0ffULL, 0x00000100ff157424ULL, 0x000fe200078e00ffULL,
0x00000002070e7810ULL, 0x040fe20007ffe0ffULL, 0x000000012c057824ULL, 0x000fe200078e0207ULL,
0x0000000407107810ULL, 0x000fc40007ffe0ffULL, 0x0000000607127810ULL, 0x000fe20007ffe0ffULL,
0x000000012c087824ULL, 0x040fe200078e020eULL, 0x0000000705067812ULL, 0x000fe200078ec0ffULL,
0x0000010003007824ULL, 0x002fe400078e00ffULL, 0x000000012c0a7824ULL, 0x000fe200078e0210ULL,
0x0000000f06067812ULL, 0x100fe200078e782dULL, 0x000000012c137824ULL, 0x000fe200078e0212ULL,
0x0000000024047217ULL, 0x000fe40007800000ULL, 0x0000000708097812ULL, 0x000fe200078ec0ffULL,
0x00000010050d7824ULL, 0x000fe200078e0206ULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x100fe200078e0a00ULL, 0x0000000f09097812ULL, 0x100fe200078e782dULL,
0x000062002b007a24ULL, 0x000fe200078e0200ULL, 0x0000000f0b0b7812ULL, 0x000fc400078e782dULL,
0x0000002004067807ULL, 0x000fe20000000000ULL, 0x0000000100057824ULL, 0x000fe200078e0205ULL,
0x00000007130c7812ULL, 0x000fe200078ec0ffULL, 0x00000010080f7824ULL, 0x000fe200078e0209ULL,
0x000000062c067217ULL, 0x000fe20007800000ULL, 0x00005e0005047625ULL, 0x000fe200078e0015ULL,
0x0000c0000d0d7811ULL, 0x000fc600078e20ffULL, 0x000000100a117824ULL, 0x000fe200078e020bULL,
0x0000000f0c0b7812ULL, 0x000fe200078e782dULL, 0x0000000100097824ULL, 0x000fe200078e020aULL,
0x00000014040a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001060c7824ULL, 0x000fe400078e0a2cULL,
0x0000000100087824ULL, 0x040fe400078e0208ULL, 0x0000000100007824ULL, 0x000fe200078e0213ULL,
0x0000000c0700720cULL, 0x080fe20003f26070ULL, 0x0000001013137824ULL, 0x000fe200078e020bULL,
0x0000000c0e00720cULL, 0x080fe20003f46070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000000c1000720cULL, 0x080fe20003f66070ULL, 0x00005e0008047625ULL, 0x000fe200078e0015ULL,
0x0000000c1200720cULL, 0x000fc60003f06070ULL, 0x00005e0009067625ULL, 0x000fe200078e0015ULL,
0x0000001404047210ULL, 0x000fc60007f9e0ffULL, 0x00005e0000087625ULL, 0x000fe200078e0015ULL,
0x0000001406067210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000001408087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff077224ULL, 0x000fc800028e0607ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000c0000f0f7811ULL, 0x000fe200078e20ffULL, 0x010688002cff7f8cULL, 0x0003e2000c80043fULL,
0x0000c00011117811ULL, 0x000fe200078e20ffULL, 0xff317217ff2a7424ULL, 0x000fe200078e00ffULL,
0x0000c00013137811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c901c46ULL, 0x000000020300720cULL, 0x000fe20003f26070ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000040f7faeULL, 0x0003e2000d101c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x000000ffff157224ULL, 0x000fc600078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff267f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff2e7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x002fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00013be000001947ULL, 0x000fea0003800000ULL, 0x0000000425287824ULL, 0x000fe400078e00ffULL,
0x000000ffff577224ULL, 0x004fc400078e0027ULL, 0x000000ffff487224ULL, 0x008fe200078e002fULL,
0x0000000228277810ULL, 0x000fe20007ffe0ffULL, 0xff317217ff2a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fe400078e00ffULL, 0x0000010003007824ULL, 0x000fca00078e00ffULL,
0x000000240000720cULL, 0x000fda0003f06070ULL, 0x00013b1000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804848ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x00000000002e7305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x0000002e0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff2e7984ULL, 0x000e640000000800ULL,
0x800000002eff7812ULL, 0x002fc40007804848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002003007811ULL, 0x000fe200078e40ffULL, 0x00000100ff407424ULL, 0x000fe200078e00ffULL,
0x00000004ff3f7819ULL, 0x000fe2000001162dULL, 0x000000102d487824ULL, 0x000fe200078e00ffULL,
0x00000001032e7810ULL, 0x000fe40007ffe0ffULL, 0x00000000242f7217ULL, 0x000fe20007800000ULL,
0x000000012c357824ULL, 0x000fe200078e023fULL, 0x000000023f337810ULL, 0x040fe40007ffe0ffULL,
0x000000043f327810ULL, 0x000fc40007ffe0ffULL, 0x000000022e00720cULL, 0x000fe20003f06070ULL,
0x000000012f2e7824ULL, 0x100fe200078e0a00ULL, 0x000000063f317810ULL, 0x000fe20007ffe0ffULL,
0x000062002b007a24ULL, 0x000fe200078e0200ULL, 0x000000f048347812ULL, 0x000fe200078ec0ffULL,
0x000000012c307824ULL, 0x000fe200078e0233ULL, 0x000000202e387807ULL, 0x000fe20000000000ULL,
0x000000012c2f7824ULL, 0x040fe400078e0232ULL, 0x0000000135367824ULL, 0x100fe200078e0200ULL,
0x000000382c3e7217ULL, 0x000fe20007800000ULL, 0x0000000130397824ULL, 0x000fc400078e0200ULL,
0x000000012f3a7824ULL, 0x000fe400078e0200ULL, 0x00005e0036367625ULL, 0x000fc800078e0040ULL,
0x00005e0039387625ULL, 0x000fe200078e0040ULL, 0x00000034363c7210ULL, 0x000fc60007f3e0ffULL,
0x00005e003a3a7625ULL, 0x000fe200078e0040ULL, 0x0000003438387210ULL, 0x000fc60007f5e0ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0231ULL, 0x000000343a3a7210ULL, 0x000fe20007f7e0ffULL,
0x000000013e3e7824ULL, 0x000fe400078e0a2cULL, 0x000000012e367824ULL, 0x000fe200078e0200ULL,
0x0000000735007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3d7224ULL, 0x000fe200008e0637ULL,
0x0000003e3f00720cULL, 0x080fe20003f26070ULL, 0x000000ffff397224ULL, 0x000fe200010e0639ULL,
0x0000003e3300720cULL, 0x080fe20003f46070ULL, 0x000000ffff3b7224ULL, 0x000fe200018e063bULL,
0x0000003e3200720cULL, 0x000fe20003f66070ULL, 0x00005e0036367625ULL, 0x000fe200078e0040ULL,
0x0000003e3100720cULL, 0x000fc40003f86070ULL, 0x00000007303e7812ULL, 0x000fe400078ec0ffULL,
0x000000072f3f7812ULL, 0x000fe400078ec0ffULL, 0x000000072e407812ULL, 0x000fe400078ec0ffULL,
0x0000000f00007812ULL, 0x100fe400078e782dULL, 0x0000000f3e3e7812ULL, 0x100fe400078e782dULL,
0x0000000f3f3f7812ULL, 0x100fe200078e782dULL, 0x0000001035457824ULL, 0x000fe200078e0200ULL,
0x0000000f40407812ULL, 0x000fe200078e782dULL, 0x0000001030467824ULL, 0x000fe200078e023eULL,
0x0000003436367210ULL, 0x000fe20007fbe0ffULL, 0x000000102f477824ULL, 0x000fe200078e023fULL,
0x0000e00045447811ULL, 0x000fe200078e20ffULL, 0x000000102e617824ULL, 0x000fe200078e0240ULL,
0x0000e00046437811ULL, 0x000fe200078e20ffULL, 0x000000ffff377224ULL, 0x000fe200028e0637ULL,
0x0000e00047427811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c447faeULL, 0x0003e2000c901c46ULL, 0x0000e00061417811ULL, 0x000fc600078e20ffULL,
0x0000000038437faeULL, 0x0003e8000d101c46ULL, 0x000000003a427faeULL, 0x0003e8000d901c46ULL,
0x0000000036417faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff587f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010608002c367f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007844857ULL, 0x01060c002c387984ULL, 0x000e640000000800ULL,
0x8000000038ff7812ULL, 0x002fe40007824837ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000387305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000380000735dULL, 0x008fe40003800000ULL,
0x01060c002c387984ULL, 0x000e640000000800ULL, 0x8000000038ff7812ULL, 0x002fc40007824837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe2000001162dULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x0000007048407812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x0000000140407824ULL, 0x000fca00078e0200ULL,
0x0100000040367984ULL, 0x000e680000000800ULL, 0x0102000040377984ULL, 0x0007220000000800ULL,
0x0000002a3600720bULL, 0x002fe20003f3d000ULL, 0x0001c3627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00387812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff7a7424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000ff2500720cULL, 0x000fe40003f65270ULL,
0x0000002a3600720bULL, 0x000fe20003f34000ULL, 0x0001c3227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x000000362a397209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x010400394000b388ULL, 0x0003e20000000800ULL,
0x800000392a2a7221ULL, 0x000fe20000010000ULL, 0x0000000038ff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b2a2a7820ULL, 0x000fc80000410000ULL, 0x0000002a003a7308ULL, 0x0007240000000800ULL,
0x00000002ff2a7819ULL, 0x008fe2000001162dULL, 0x0001c2c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a3a387589ULL, 0x0122e400000e0000ULL, 0x000000082a2a7810ULL, 0x002fe20007ffe0ffULL,
0x0001c3127f007947ULL, 0x000fea000b800000ULL, 0x00001f2a3a2a7589ULL, 0x00032400000e0000ULL,
0x8000003936361221ULL, 0x100fe20000010000ULL, 0x0000002a23237220ULL, 0x090fe20000410000ULL,
0x0000002a22227220ULL, 0x080fe20000410000ULL, 0x0000002a1f1f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b36361820ULL, 0x000fe20000410000ULL, 0x0000002a1e1e7220ULL, 0x080fe20000410000ULL,
0x0000002a1b1b7220ULL, 0x080fe20000410000ULL, 0x0000002a1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003600261308ULL, 0x000f220000000800ULL, 0x0000002a17177220ULL, 0x080fe20000410000ULL,
0x0000002a16167220ULL, 0x080fe20000410000ULL, 0x0000002a13137220ULL, 0x080fe20000410000ULL,
0x0000002a12127220ULL, 0x080fe20000410000ULL, 0x0000002a0f0f7220ULL, 0x080fe20000410000ULL,
0x0000002a0e0e7220ULL, 0x080fe20000410000ULL, 0x0000002a0b0b7220ULL, 0x080fe20000410000ULL,
0x0000002a0a0a7220ULL, 0x080fe20000410000ULL, 0x0000002a07077220ULL, 0x080fe20000410000ULL,
0x0000002a06067220ULL, 0x000fe20000410000ULL, 0x0000003a29297220ULL, 0x000fe20000410000ULL,
0x00000001ff7a7807ULL, 0x000fe20000800000ULL, 0x0000003821217220ULL, 0x088fe20000410000ULL,
0x0000003820207220ULL, 0x080fe20000410000ULL, 0x000000381d1d7220ULL, 0x080fe20000410000ULL,
0x000000381c1c7220ULL, 0x080fe20000410000ULL, 0x0000003819197220ULL, 0x080fe20000410000ULL,
0x0000003818187220ULL, 0x080fe20000410000ULL, 0x0000003815157220ULL, 0x080fe20000410000ULL,
0x0000003814147220ULL, 0x080fe20000410000ULL, 0x0000003811117220ULL, 0x080fe20000410000ULL,
0x0000003810107220ULL, 0x080fe20000410000ULL, 0x000000380d0d7220ULL, 0x080fe20000410000ULL,
0x000000380c0c7220ULL, 0x080fe20000410000ULL, 0x0000003809097220ULL, 0x080fe20000410000ULL,
0x0000003808087220ULL, 0x080fe20000410000ULL, 0x0000003805057220ULL, 0x080fe20000410000ULL,
0x0000003804047220ULL, 0x000fe20000410000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0039ULL,
0x0000002637371220ULL, 0x010fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002937297221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ee40000000800ULL,
0x8000000000ff7812ULL, 0x008fc40007824857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000367305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000360000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff367984ULL, 0x000ee40000000800ULL,
0x8000000036ff7812ULL, 0x008fe40007824857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000026ff00723eULL, 0x000fe400000010ffULL, 0x00000004ff397819ULL, 0x000fc4000001162dULL,
0x00000002ff367819ULL, 0x000fe4000001162dULL, 0x0000541000627816ULL, 0x000fe20000000000ULL,
0x0001bfb27f007947ULL, 0x000fea000b800000ULL, 0x00001f3662737589ULL, 0x00072400000e0000ULL,
0x0000000836387810ULL, 0x000fe20007ffe0ffULL, 0x0001bff27f007947ULL, 0x000fea000b800000ULL,
0x00001f3862717589ULL, 0x0002e400000e0000ULL, 0x0000001036377810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff637224ULL, 0x000fe200078e0037ULL,
0x00001ae0005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x0001cff000007944ULL, 0x01efea0003c00000ULL,
0x0000001836367810ULL, 0x008fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x000fe200078e0036ULL, 0x00001b50005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0001cf8000007944ULL, 0x016fea0003c00000ULL, 0x000000082d007812ULL, 0x044fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000282d3a7211ULL, 0x002fe400078fe0ffULL,
0x00000007003b7812ULL, 0x140fe400078ec82dULL, 0x0000000700007812ULL, 0x000fe400078ef82dULL,
0x0000003a3b3a7212ULL, 0x000fe400078e3cffULL, 0x000000272d3c7211ULL, 0x000fc600078fe0ffULL,
0x00000010005f7824ULL, 0x000fe200078e023aULL, 0x0000003c3b3b7212ULL, 0x000fc800078e3cffULL,
0x0000c0005f3e7811ULL, 0x000fe200078e20ffULL, 0x00000010005e7824ULL, 0x040fe200078e023bULL,
0x0000010000007811ULL, 0x000fc600078e20ffULL, 0x000000003e54783bULL, 0x000e620000004200ULL,
0x0000c0005e3d7811ULL, 0x000fe200078e20ffULL, 0x000000013b5c7824ULL, 0x100fe400078e0200ULL,
0x000000013a5d7824ULL, 0x000fe400078e0200ULL, 0x000000003d4c783bULL, 0x000ea20000004200ULL,
0x0000c0005c3b7811ULL, 0x000fe400078e20ffULL, 0x0000c0005d3c7811ULL, 0x000fc600078e20ffULL,
0x000000003b50783bULL, 0x000ee80000004200ULL, 0x000000003c48783bULL, 0x000f620000004200ULL,
0x0000010054767824ULL, 0x042fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fe20000011454ULL,
0x0000005400d67306ULL, 0x000fe20000009400ULL, 0x0001000054e37824ULL, 0x000fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fe20000011455ULL, 0x0001000055da7824ULL, 0x040fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000010055d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe37819ULL, 0x000fe200000114e3ULL, 0x0000010056ba7824ULL, 0x000fe200078e00ffULL,
0x0000005400ea7306ULL, 0x000e620000005400ULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x000001004ecc7824ULL, 0x044fe200078e00ffULL, 0x00000018ffd97819ULL, 0x000fe200000114d9ULL,
0x000100004ec37824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fe20000011457ULL,
0x000001004cbe7824ULL, 0x040fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001144eULL,
0x0000005400927306ULL, 0x000ea2000000d400ULL, 0x00000018ffb57819ULL, 0x000fe20000011456ULL,
0x000100004cc27824ULL, 0x000fe200078e00ffULL, 0x00000018ff007819ULL, 0x008fe20000011452ULL,
0x0000010057bb7824ULL, 0x040fe200078e00ffULL, 0x00000018ffba7819ULL, 0x000fe200000114baULL,
0x0001000057bf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe200000114beULL,
0x000000de00e27306ULL, 0x000fe20000209400ULL, 0x000000ead600720bULL, 0x002fe20003fbd000ULL,
0x000001004dbd7824ULL, 0x040fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x000100004dce7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0001000048ee7824ULL, 0x020fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe2000001144cULL,
0x000000de00e17306ULL, 0x0002e20000205400ULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x0000010049e97824ULL, 0x040fe200078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x0001000049e67824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x000001004bd87824ULL, 0x000fe200078e00ffULL, 0x0000000192925812ULL, 0x004fe200078efcffULL,
0x0000007600eb7306ULL, 0x000fe20000209400ULL, 0x000000de00de7245ULL, 0x002fe2000020d400ULL,
0x000001004fc47824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x000001004ad77824ULL, 0x000fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fc4000001144dULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x0000007600547306ULL, 0x000e620000205400ULL,
0x000000e1e200720bULL, 0x008fe40003f7d000ULL, 0x00000018ff997819ULL, 0x000fe40000011448ULL,
0x00000018ff947819ULL, 0x000fe40000011449ULL, 0x00000018ff5b7819ULL, 0x000fe2000001144bULL,
0x000000e300ed7306ULL, 0x000fe20000209400ULL, 0x00000018ffc47819ULL, 0x000fc400000114c4ULL,
0x00000018ffe97819ULL, 0x000fe400000114e9ULL, 0x00000018ff667819ULL, 0x000fe4000001144aULL,
0x00000001dede3812ULL, 0x000fe200078efcffULL, 0x000000e300ec7306ULL, 0x0004e20000205400ULL,
0x00000054eb00720bULL, 0x002fe20003f5d000ULL, 0x0001000052547824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe4000001144fULL, 0x00000018ffe67819ULL, 0x000fc400000114e6ULL,
0x00000018ff5a7819ULL, 0x000fe20000011453ULL, 0x000000da00e47306ULL, 0x000fe20000209400ULL,
0x000000e300e37245ULL, 0x004fe4000020d400ULL, 0x00000018ffd77819ULL, 0x000fe400000114d7ULL,
0x00000018ff797819ULL, 0x000fe40000011450ULL, 0x00000018ff727819ULL, 0x000fe20000011451ULL,
0x000000da00e57306ULL, 0x0002a20000205400ULL, 0x000000eced00720bULL, 0x008fc40003fdd000ULL,
0x00000018ffd87819ULL, 0x000fca00000114d8ULL, 0x0000005600a67306ULL, 0x000fe20000009400ULL,
0x000000da00da7245ULL, 0x002fca000020d400ULL, 0x00000001e3e36812ULL, 0x000fe400078efcffULL,
0x0000005600ab7306ULL, 0x000e620000005400ULL, 0x000000e5e400720bULL, 0x004fce0003fbd000ULL,
0x000000d900e77306ULL, 0x000fec0000209400ULL, 0x00000001dada5812ULL, 0x000fe400078efcffULL,
0x000000d900e87306ULL, 0x0005e20000205400ULL, 0x000000aba600720bULL, 0x002fce0003f7d000ULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x000000d900d97245ULL, 0x004fce000020d400ULL,
0x000000b800607306ULL, 0x0002b00000205400ULL, 0x0000004e00b07306ULL, 0x000fe20000009400ULL,
0x000000b800b87245ULL, 0x002fce000020d400ULL, 0x0000004e00a87306ULL, 0x000fe20000005400ULL,
0x00000060b900720bULL, 0x004fe40003fdd000ULL, 0x000000072d607812ULL, 0x000fc800078ec0ffULL,
0x0000000860607812ULL, 0x000fe200078ef82dULL, 0x0000004e00787306ULL, 0x0003e6000000d400ULL,
0x0000000739397812ULL, 0x000fc600078e7860ULL, 0x00000001b8b86812ULL, 0x000fe400078efcffULL,
0x0000005600847306ULL, 0x0004e2000000d400ULL, 0x00000100524e7824ULL, 0x002fce00078e00ffULL,
0x0000005200867306ULL, 0x000fe20000009400ULL, 0x0001000056567824ULL, 0x004fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000005200857306ULL, 0x000fe20000005400ULL,
0x0000000184843812ULL, 0x008fce00078efcffULL, 0x0000005200637306ULL, 0x0003f0000000d400ULL,
0x0000005700a57306ULL, 0x000fe20000009400ULL, 0x0000007600527245ULL, 0x002fe2000020d400ULL,
0x0001000053767824ULL, 0x000fc600078e00ffULL, 0x0000000152522812ULL, 0x000fe400078efcffULL,
0x000000e8e700720bULL, 0x000fe20003f5d000ULL, 0x0000005700a37306ULL, 0x000e620000005400ULL,
0x000000925252723eULL, 0x000fe400000010ffULL, 0x00000018ff767819ULL, 0x000fca0000011476ULL,
0x000000b300b67306ULL, 0x000fe80000209400ULL, 0x00000001d9d92812ULL, 0x000fc800078efcffULL,
0x000000b300b77306ULL, 0x0004e20000205400ULL, 0x000000a3a500720bULL, 0x002fce0003fbd000ULL,
0x000000ba00db7306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x004fce000020d400ULL,
0x000000ba00dc7306ULL, 0x0002a20000205400ULL, 0x000000b7b600720bULL, 0x008fce0003f7d000ULL,
0x0000005600c97306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x002fca000020d400ULL,
0x00000001b3b33812ULL, 0x000fe400078efcffULL, 0x0000005600d47306ULL, 0x000e620000205400ULL,
0x000000dcdb00720bULL, 0x004fce0003f5d000ULL, 0x0000005500e07306ULL, 0x000fec0000009400ULL,
0x00000001baba2812ULL, 0x000fe400078efcffULL, 0x0000005500df7306ULL, 0x000ea20000005400ULL,
0x000000d4c900720bULL, 0x002fe40003fdd000ULL, 0x00000084ba84723eULL, 0x000fca00000010ffULL,
0x0000005700837306ULL, 0x000e70000000d400ULL, 0x000000be00c07306ULL, 0x000fe20000209400ULL,
0x000000dfe000720bULL, 0x004fce0003f9d000ULL, 0x000000be00c17306ULL, 0x0004e20000205400ULL,
0x0000000183835812ULL, 0x002fce00078efcffULL, 0x000000c200c67306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x004fce000020d400ULL, 0x000000c200cb7306ULL, 0x0002a20000205400ULL,
0x000000c1c000720bULL, 0x008fce0003fbd000ULL, 0x000000b5009e7306ULL, 0x000fe20000209400ULL,
0x000000c200c27245ULL, 0x002fca000020d400ULL, 0x00000001bebe5812ULL, 0x000fe400078efcffULL,
0x000000b500aa7306ULL, 0x0002e20000205400ULL, 0x000000cbc600720bULL, 0x004fce0003f7d000ULL,
0x0000005500917306ULL, 0x000562000000d400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x00000001c2c23812ULL, 0x000fe400078efcffULL, 0x0000004c00b47306ULL, 0x000fe20000009400ULL,
0x000000aa9e00720bULL, 0x008fe20003f5d000ULL, 0x000100004a557824ULL, 0x004fe200078e00ffULL,
0x00000056009e7245ULL, 0x000fc8000020d400ULL, 0x000000019e9e6812ULL, 0x000fe200078efcffULL,
0x0000004c00a97306ULL, 0x000e620000005400ULL, 0x0000000191914812ULL, 0x020fca00078efcffULL,
0x00000001b5b52812ULL, 0x000fe400078efcffULL, 0x000000bb00bc7306ULL, 0x000ff00000209400ULL,
0x000000bb00dd7306ULL, 0x0004e20000205400ULL, 0x000000a9b400720bULL, 0x002fce0003fdd000ULL,
0x000000ae00b17306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x004fce000020d400ULL,
0x000000ae009f7306ULL, 0x0002a20000205400ULL, 0x000000ddbc00720bULL, 0x008fce0003f9d000ULL,
0x000000cc00cf7306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x00000001bbbb4812ULL, 0x000fe400078efcffULL, 0x000000cc00ca7306ULL, 0x0002e20000205400ULL,
0x0000009fb100720bULL, 0x004fce0003fbd000ULL, 0x0000004c007e7306ULL, 0x000562000000d400ULL,
0x000000cc00cc7245ULL, 0x002fca000020d400ULL, 0x00000001aeae5812ULL, 0x000fe400078efcffULL,
0x000000bf00c77306ULL, 0x000fe20000209400ULL, 0x000099107a4c7816ULL, 0x004fe200000000ffULL,
0x000100004b7a7824ULL, 0x000fe200078e00ffULL, 0x000000cacf00720bULL, 0x008fe40003f7d000ULL,
0x000000ff4c00720cULL, 0x000fe20003f25270ULL, 0x00000100484c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x000000bf00c87306ULL, 0x0002a20000205400ULL,
0x000000017e7e6812ULL, 0x020fc400078efcffULL, 0x000000a8b000720bULL, 0x000fe40003fdd000ULL,
0x00000018ffd67819ULL, 0x000fe2000001144cULL, 0x00000100534c7824ULL, 0x000fe200078e00ffULL,
0x0000007ebe7e723eULL, 0x000fe200000010ffULL, 0x000000bd00577306ULL, 0x000fe20000209400ULL,
0x00000001cccc3812ULL, 0x000fe400078efcffULL, 0x000000bf00bf7245ULL, 0x002fca000020d400ULL,
0x000000bd00c57306ULL, 0x0002e20000205400ULL, 0x000000c8c700720bULL, 0x004fe40003f9d000ULL,
0x0000000178786812ULL, 0x000fca00078efcffULL, 0x0000004f00a17306ULL, 0x000fe20000009400ULL,
0x000000bd00bd7245ULL, 0x002fca000020d400ULL, 0x00000001bfbf4812ULL, 0x000fe400078efcffULL,
0x0000004f00a47306ULL, 0x000e620000005400ULL, 0x000000c55700720bULL, 0x008fce0003f5d000ULL,
0x000000c300d37306ULL, 0x000fec0000209400ULL, 0x00000001bdbd2812ULL, 0x000fe400078efcffULL,
0x000000c300d57306ULL, 0x0004e20000205400ULL, 0x000000a4a100720bULL, 0x002fce0003fbd000ULL,
0x0000004d00b27306ULL, 0x000fe20000009400ULL, 0x000000c300c37245ULL, 0x004fce000020d400ULL,
0x0000004d00a07306ULL, 0x000e620000005400ULL, 0x000000d5d300720bULL, 0x008fce0003f7d000ULL,
0x0000004d007b7306ULL, 0x0004ec000000d400ULL, 0x00000001c3c33812ULL, 0x000fe400078efcffULL,
0x0000009a003a7306ULL, 0x000fe20000209400ULL, 0x000100004f4d7824ULL, 0x004fe200078e00ffULL,
0x000000a0b200720bULL, 0x002fc80003f9d000ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000009a009b7306ULL, 0x0002ae0000205400ULL, 0x000000017b7b4812ULL, 0x008fe200078efcffULL,
0x0000004f00777306ULL, 0x000762000000d400ULL, 0x0000009a009a7245ULL, 0x002fce000020d400ULL,
0x0000004800a77306ULL, 0x000fe20000009400ULL, 0x0000009b3a00720bULL, 0x004fe20003fdd000ULL,
0x00000008603a7824ULL, 0x000fe200078e0239ULL, 0x0000004d009b7245ULL, 0x000fe2000020d400ULL,
0x00000100514f7824ULL, 0x008fc800078e00ffULL, 0x0000004800ac7306ULL, 0x000fe20000005400ULL,
0x0000000177775812ULL, 0x020fca00078efcffULL, 0x000000019a9a6812ULL, 0x000fe400078efcffULL,
0x0000004800757306ULL, 0x000fe4000000d400ULL, 0x000000c39a9a723eULL, 0x000fcc00000010ffULL,
0x0000004900887306ULL, 0x000ff00000009400ULL, 0x00000049008d7306ULL, 0x000ff00000005400ULL,
0x0000004900747306ULL, 0x000ff0000000d400ULL, 0x000000ce00d07306ULL, 0x000ff00000209400ULL,
0x000000ce00d17306ULL, 0x0002b00000205400ULL, 0x0000004d00487306ULL, 0x000fe20000209400ULL,
0x000000ce00ce7245ULL, 0x002fce000020d400ULL, 0x0000004d00497306ULL, 0x000e620000205400ULL,
0x000000d1d000720bULL, 0x004fce0003f5d000ULL, 0x0000004b00957306ULL, 0x000fec0000009400ULL,
0x00000001cece2812ULL, 0x000fe400078efcffULL, 0x0000004b00877306ULL, 0x000ea20000005400ULL,
0x000000494800720bULL, 0x002fe40003fbd000ULL, 0x0000a0003a487811ULL, 0x000fca00078e20ffULL,
0x0000004b006f7306ULL, 0x000fec000000d400ULL, 0x000000019b9b5812ULL, 0x000fe400078efcffULL,
0x000000d6004b7306ULL, 0x000fe20000209400ULL, 0x0000008d8800720bULL, 0x000fce0003fbd000ULL,
0x000000d600df7306ULL, 0x0002ec0000205400ULL, 0x0000000174745812ULL, 0x000fe400078efcffULL,
0x000000ad00af7306ULL, 0x000fe20000209400ULL, 0x000000d600d67245ULL, 0x002fe4000020d400ULL,
0x000000879500720bULL, 0x004fc40003fbd000ULL, 0x000000d700877245ULL, 0x000fc6000020d400ULL,
0x000000ad00a27306ULL, 0x0002a20000205400ULL, 0x000000df4b00720bULL, 0x008fce0003f7d000ULL,
0x000000c400cd7306ULL, 0x000fe20000209400ULL, 0x000000ad00ad7245ULL, 0x002fe4000020d400ULL,
0x000000016f6f5812ULL, 0x000fc600078efcffULL, 0x00000001d6d63812ULL, 0x000fe400078efcffULL,
0x000000c400d27306ULL, 0x0002e20000205400ULL, 0x000000a2af00720bULL, 0x004fce0003f9d000ULL,
0x0000004a00967306ULL, 0x000fe20000009400ULL, 0x000000c400c47245ULL, 0x002fca000020d400ULL,
0x00000001adad4812ULL, 0x000fe400078efcffULL, 0x0000004a00977306ULL, 0x000fe20000005400ULL,
0x000000d2cd00720bULL, 0x008fe40003f5d000ULL, 0x000000aca700720bULL, 0x000fca0003f9d000ULL,
0x0000004a00707306ULL, 0x0003ec000000d400ULL, 0x00000001c4c42812ULL, 0x000fe400078efcffULL,
0x000000e900a37306ULL, 0x000fe20000209400ULL, 0x00000100504a7824ULL, 0x002fe200078e00ffULL,
0x0000000175754812ULL, 0x000fc800078efcffULL, 0x00000018ffa47819ULL, 0x000fe4000001144aULL,
0x000000e900a57306ULL, 0x0002a20000205400ULL, 0x000000004848783bULL, 0x000ee20000000200ULL,
0x00000075d6d6723eULL, 0x000fcc00000010ffULL, 0x00000090009d7306ULL, 0x000fe20000209400ULL,
0x000000e900e97245ULL, 0x002fce000020d400ULL, 0x00000090009c7306ULL, 0x0003620000205400ULL,
0x000000a5a300720bULL, 0x004fce0003f7d000ULL, 0x000000e600567306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x002fca000020d400ULL, 0x00000001e9e93812ULL, 0x000fe400078efcffULL,
0x000000e600577306ULL, 0x0002a20000205400ULL, 0x0000009c9d00720bULL, 0x020fe40003f5d000ULL,
0x000000979600720bULL, 0x000fe40003f7d000ULL, 0x00000018ff9d7819ULL, 0x000fc6000001144fULL,
0x000000a400397306ULL, 0x000fe20000209400ULL, 0x000000e600e67245ULL, 0x002fe2000020d400ULL,
0x0000007348489231ULL, 0x098fe400003400ffULL, 0x000000734a4a9231ULL, 0x000fe400003400ffULL,
0x0000000190902812ULL, 0x000fe200078efcffULL, 0x0000007149499231ULL, 0x080fe200003400ffULL,
0x000000a4009c7306ULL, 0x0002e20000205400ULL, 0x000000575600720bULL, 0x004fe20003f9d000ULL,
0x000000714b4b9231ULL, 0x000fe200003400ffULL, 0x0000000170703812ULL, 0x000fc400078efcffULL,
0x000000e3de56723eULL, 0x000fe400000010ffULL, 0x000000dab857723eULL, 0x000fe200000010ffULL,
0x00000099008f7306ULL, 0x000fe20000209400ULL, 0x0000009b909b723eULL, 0x000fe400000010ffULL,
0x000000a400a47245ULL, 0x002fc6000020d400ULL, 0x00000001e6e64812ULL, 0x000fe200078efcffULL,
0x000000564808723cULL, 0x000fe20000041808ULL, 0x00000099008e7306ULL, 0x0002a20000205400ULL,
0x0000009c3900720bULL, 0x008fe40003f7d000ULL, 0x0000000733397812ULL, 0x000fc600078e7860ULL,
0x00000078cc56723eULL, 0x000fe200000010ffULL, 0x0000009a4820723cULL, 0x000fe20000041820ULL,
0x0000005000897306ULL, 0x000fe20000009400ULL, 0x0000000860397824ULL, 0x000fe200078e0239ULL,
0x0000009900997245ULL, 0x002fe4000020d400ULL, 0x00000077c457723eULL, 0x000fe400000010ffULL,
0x00000018ff777819ULL, 0x000fe40000011454ULL, 0x00000050008c7306ULL, 0x000e620000005400ULL,
0x0000008e8f00720bULL, 0x004fc40003f5d000ULL, 0x00000018ff8f7819ULL, 0x000fe4000001144eULL,
0x00000001a4a43812ULL, 0x000fc600078efcffULL, 0x0000005300827306ULL, 0x000fec0000009400ULL,
0x0000000199992812ULL, 0x000fe400078efcffULL, 0x0000005300817306ULL, 0x000ea20000005400ULL,
0x0000008c8900720bULL, 0x002fce0003f9d000ULL, 0x0000005300627306ULL, 0x0002f0000000d400ULL,
0x000000d7009f7306ULL, 0x000fe20000209400ULL, 0x00000018ff537819ULL, 0x002fe400000114eeULL,
0x000000818200720bULL, 0x004fc40003f7d000ULL, 0x0000005300887245ULL, 0x000fc6000020d400ULL,
0x000000d700a07306ULL, 0x0002b00000205400ULL, 0x0000005300b97306ULL, 0x000fe20000209400ULL,
0x00000074e9d7723eULL, 0x002fe400000010ffULL, 0x0000000162623812ULL, 0x008fca00078efcffULL,
0x0000005300a67306ULL, 0x0002e20000205400ULL, 0x000000a09f00720bULL, 0x004fce0003f5d000ULL,
0x00000050006c7306ULL, 0x000522000000d400ULL, 0x00000091d953723eULL, 0x002fca00000010ffULL,
0x0000000187872812ULL, 0x000fe400078efcffULL, 0x0000005100937306ULL, 0x000fe20000009400ULL,
0x0001000050507824ULL, 0x004fe200078e00ffULL, 0x000000a6b900720bULL, 0x008fc80003fdd000ULL,
0x00000018ff8d7819ULL, 0x000fe40000011450ULL, 0x00000051008b7306ULL, 0x000fe20000005400ULL,
0x000000016c6c4812ULL, 0x010fcc00078efcffULL, 0x0000000188886812ULL, 0x000fe200078efcffULL,
0x00000051006b7306ULL, 0x0003f0000000d400ULL, 0x000000d800a17306ULL, 0x000fe20000209400ULL,
0x0001000051517824ULL, 0x002fca00078e00ffULL, 0x00000018ff897819ULL, 0x000fe40000011451ULL,
0x000000524850723cULL, 0x000fe20000041804ULL, 0x000000d800a27306ULL, 0x0002ac0000205400ULL,
0x0000a00039047811ULL, 0x000fe400078e20ffULL, 0x0000009400987306ULL, 0x000fe20000209400ULL,
0x000000d800d87245ULL, 0x002fc6000020d400ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x00000094008a7306ULL, 0x0007220000205400ULL, 0x000000a2a100720bULL, 0x004fce0003f5d000ULL,
0x0000009d004d7306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x008fca000020d400ULL,
0x00000001d8d82812ULL, 0x000fe400078efcffULL, 0x0000009d008e7306ULL, 0x0004e20000205400ULL,
0x0000008a9800720bULL, 0x010fe40003fdd000ULL, 0x000000858600720bULL, 0x000fe40003f5d000ULL,
0x00000083bb85723eULL, 0x000fe400000010ffULL, 0x00000018ff837819ULL, 0x000fe2000001144cULL,
0x00000079007f7306ULL, 0x000fe20000209400ULL, 0x0000009eb54c723eULL, 0x000fc400000010ffULL,
0x0000009d009d7245ULL, 0x004fe2000020d400ULL, 0x00000084480c723cULL, 0x000fe4000004180cULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x0000007900807306ULL, 0x0005220000205400ULL,
0x0000008e4d00720bULL, 0x008fe40003fbd000ULL, 0x000000bfb34d723eULL, 0x000fe200000010ffULL,
0x0000007304049231ULL, 0x082fe200003400ffULL, 0x0000008b9300720bULL, 0x000fe20003fdd000ULL,
0x0000007306069231ULL, 0x000fe200003400ffULL, 0x0000000163632812ULL, 0x000fe200078efcffULL,
0x0000008d004f7306ULL, 0x000fe20000209400ULL, 0x0000007105059231ULL, 0x080fe200003400ffULL,
0x0000007900797245ULL, 0x004fe2000020d400ULL, 0x0000007107079231ULL, 0x000fc600003400ffULL,
0x000000019d9d5812ULL, 0x000fe400078efcffULL, 0x0000008d008a7306ULL, 0x0002a20000205400ULL,
0x000000807f00720bULL, 0x010fe40003f9d000ULL, 0x0000007bbd7f723eULL, 0x000fe400000010ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011455ULL, 0x000000016b6b6812ULL, 0x000fe200078efcffULL,
0x00000072007d7306ULL, 0x000fe20000209400ULL, 0x0000008d008d7245ULL, 0x002fe2000020d400ULL,
0x0000007e4814723cULL, 0x000fe20000041814ULL, 0x0000006b9d6b723eULL, 0x000fc600000010ffULL,
0x0000000179794812ULL, 0x000fe400078efcffULL, 0x00000072007c7306ULL, 0x0002e20000205400ULL,
0x0000008a4f00720bULL, 0x004fe20003fbd000ULL, 0x000000564854723cULL, 0x040fec000004181cULL,
0x0000008f00917306ULL, 0x000fe20000209400ULL, 0x00000088991c723eULL, 0x000fe200000010ffULL,
0x0000004c484c723cULL, 0x000fe20000041810ULL, 0x000000e6941d723eULL, 0x000fc400000010ffULL,
0x0000007200727245ULL, 0x002fe4000020d400ULL, 0x000000018d8d5812ULL, 0x000fe200078efcffULL,
0x0000008f00867306ULL, 0x0002a20000205400ULL, 0x000000c2ae10723eULL, 0x000fe200000010ffULL,
0x0000001c041c723cULL, 0x000fe20000041808ULL, 0x000000cead11723eULL, 0x000fe400000010ffULL,
0x0000007c7d00720bULL, 0x008fc60003fdd000ULL, 0x00000089008b7306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x002fe2000020d400ULL, 0x000000104810723cULL, 0x000fe20000041818ULL,
0x0000008300097245ULL, 0x000fca000020d400ULL, 0x00000089008c7306ULL, 0x0002e20000205400ULL,
0x000000869100720bULL, 0x004fe20003f9d000ULL, 0x000000d60448723cULL, 0x000fe20000041850ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000708718723eULL, 0x000fe400000010ffULL,
0x0000006fd819723eULL, 0x000fe200000010ffULL, 0x0000007b007c7306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x002fca000020d400ULL, 0x000000018f8f4812ULL, 0x000fe200078efcffULL,
0x000000180418723cULL, 0x000fe2000004180cULL, 0x0000007b00787306ULL, 0x0002a20000205400ULL,
0x0000008c8b00720bULL, 0x008fe40003fbd000ULL, 0x000000638f08723eULL, 0x000fc600000010ffULL,
0x0000008d790c723eULL, 0x000fe400000010ffULL, 0x00000066006e7306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x00000066006d7306ULL, 0x0002e20000205400ULL, 0x000000787c00720bULL, 0x004fe40003f9d000ULL,
0x00000089720d723eULL, 0x000fca00000010ffULL, 0x0000008300817306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x002fe2000020d400ULL, 0x0000000c040c723cULL, 0x000fe80000041810ULL,
0x000000017b7b4812ULL, 0x000fe400078efcffULL, 0x0000008300807306ULL, 0x000e620000205400ULL,
0x0000006d6e00720bULL, 0x008fe40003fdd000ULL, 0x0000007600117245ULL, 0x000fca000020d400ULL,
0x0000007a00717306ULL, 0x000fec0000209400ULL, 0x0000000166666812ULL, 0x000fe400078efcffULL,
0x0000007a00507306ULL, 0x000ea20000205400ULL, 0x000000808100720bULL, 0x002fe40003fbd000ULL,
0x0000007b6666723eULL, 0x000fca00000010ffULL, 0x0000000000677306ULL, 0x000fec0000209400ULL,
0x0000000109095812ULL, 0x000fe400078efcffULL, 0x00000000006a7306ULL, 0x0002e20000205400ULL,
0x000000507100720bULL, 0x004fe40003f7d000ULL, 0x000000620909723eULL, 0x000fca00000010ffULL,
0x0000005b00657306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x002fce000020d400ULL,
0x0000005b00647306ULL, 0x0002a20000205400ULL, 0x0000006a6700720bULL, 0x008fe40003f5d000ULL,
0x0000007a00677245ULL, 0x000fe4000020d400ULL, 0x0000006ca46a723eULL, 0x000fe400000010ffULL,
0x0000000167673812ULL, 0x000fe200078efcffULL, 0x0000005a00687306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x002fc6000020d400ULL, 0x0000006a0414723cULL, 0x000fe40000041814ULL,
0x0000000100002812ULL, 0x000fe400078efcffULL, 0x0000005a00697306ULL, 0x0002e20000205400ULL,
0x000000646500720bULL, 0x004fce0003f9d000ULL, 0x00000077007d7306ULL, 0x000fe20000209400ULL,
0x0000005a005a7245ULL, 0x002fca000020d400ULL, 0x000000015b5b4812ULL, 0x000fe400078efcffULL,
0x0000007700737306ULL, 0x0002a20000205400ULL, 0x000000696800720bULL, 0x008fe40003fbd000ULL,
0x000000675b67723eULL, 0x000fca00000010ffULL, 0x00000076000a7306ULL, 0x000fe20000209400ULL,
0x0000007700777245ULL, 0x002fe2000020d400ULL, 0x00000066044c723cULL, 0x000fe8000004184cULL,
0x000000015a5a5812ULL, 0x000fe400078efcffULL, 0x00000076000b7306ULL, 0x000e620000205400ULL,
0x000000737d00720bULL, 0x004fda0003fdd000ULL, 0x0000000177776812ULL, 0x000fe400078efcffULL,
0x0000000b0a00720bULL, 0x002fe40003f7d000ULL, 0x000000770010723eULL, 0x000fe200000010ffULL,
0x000000080408723cULL, 0x000ff40000041854ULL, 0x0000000111113812ULL, 0x000fc800078efcffULL,
0x000000115a11723eULL, 0x000fce00000010ffULL, 0x000000100404723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff107f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000127305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004003007811ULL, 0x000fe200078e40ffULL, 0x00000100ff517424ULL, 0x000fe200078e00ffULL,
0x00000004ff237819ULL, 0x000fc4000001162dULL, 0x0000000024107217ULL, 0x000fe40007800000ULL,
0x0000c00045457811ULL, 0x000fe400078e20ffULL, 0x0000c00046467811ULL, 0x000fe200078e20ffULL,
0x0000000110107824ULL, 0x100fe200078e0a00ULL, 0x0000c00047477811ULL, 0x000fe200078e20ffULL,
0x000062002b007a24ULL, 0x000fc600078e0200ULL, 0x0000002010107807ULL, 0x000fe20000000000ULL,
0x0000000135117824ULL, 0x100fe400078e0200ULL, 0x0000000130137824ULL, 0x100fe200078e0200ULL,
0x000000102c127217ULL, 0x000fe20007800000ULL, 0x000000012f207824ULL, 0x000fe400078e0200ULL,
0x00005e0011107625ULL, 0x000fc800078e0051ULL, 0x0000000112507824ULL, 0x000fe200078e0a2cULL,
0x0000003410107210ULL, 0x000fe20007f7e0ffULL, 0x00005e0013127625ULL, 0x000fc600078e0051ULL,
0x000000502300720cULL, 0x000fe20003f46070ULL, 0x00005e0020207625ULL, 0x000fe200078e0051ULL,
0x0000003412127210ULL, 0x000fc60007f9e0ffULL, 0x000000012e227824ULL, 0x000fe200078e0200ULL,
0x0000003420207210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0611ULL,
0x000000503300720cULL, 0x000fe20003f66070ULL, 0x00005e0022227625ULL, 0x000fc800078e0051ULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x000000503200720cULL, 0x080fe20003f86070ULL,
0x000000ffff217224ULL, 0x000fe200028e0621ULL, 0x000000503100720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010457faeULL, 0x0003e2000d101c46ULL,
0x0000003422227210ULL, 0x000fe40007fde0ffULL, 0x0000c00061507811ULL, 0x000fe200078e20ffULL,
0x0000000012467faeULL, 0x0003e4000d901c46ULL, 0x000000ffff237224ULL, 0x000fc800030e0623ULL,
0x0000000020477faeULL, 0x0003e8000e101c46ULL, 0x0000000022507faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff107f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844859ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff577224ULL, 0x000fe200078e0011ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007844859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000107305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000100000735dULL, 0x004fe40003800000ULL, 0x0106b400ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007844859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000026ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff637819ULL, 0x000fe4000001162dULL,
0x0000541000627816ULL, 0x000fe20000000000ULL, 0x00019ae27f007947ULL, 0x000fea000b800000ULL,
0x00001f6362817589ULL, 0x0002a400000e0000ULL, 0x00019b227f007947ULL, 0x000fea000b800000ULL,
0x00001f3862807589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x002fe200078e0037ULL, 0x00004070005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0001aa6000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x002fe200078e0036ULL, 0x000040d0005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0001aa0000007944ULL, 0x01cfea0003c00000ULL, 0x0000e0005f557811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0005c527811ULL, 0x000fe400078e20ffULL,
0x0000e0005e567811ULL, 0x000fe200078e20ffULL, 0x000000005520783bULL, 0x000f620000004200ULL,
0x0000e0005d517811ULL, 0x000fe400078e20ffULL, 0x0000000732537812ULL, 0x100fe200078e7860ULL,
0x00000000525c783bULL, 0x000e620000004200ULL, 0x0000000731547812ULL, 0x000fc600078e7860ULL,
0x000000005658783bULL, 0x000fe20000004200ULL, 0x0000000860537824ULL, 0x040fe400078e0253ULL,
0x0000000860547824ULL, 0x000fe200078e0254ULL, 0x000000005110783bULL, 0x000ee20000004200ULL,
0x0001000020e67824ULL, 0x060fe200078e00ffULL, 0x0000002000c37306ULL, 0x000fe20000009400ULL,
0x0000010020e47824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe20000011421ULL,
0x0001000021ca7824ULL, 0x040fe200078e00ffULL, 0x00000018ffe67819ULL, 0x000fe200000114e6ULL,
0x0000010021c97824ULL, 0x000fe200078e00ffULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x0001000022cd7824ULL, 0x000fe200078e00ffULL, 0x000000e600df7306ULL, 0x000fe20000209400ULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x000100005e607824ULL, 0x002fe200078e00ffULL,
0x00000018ffe57819ULL, 0x000fe20000011420ULL, 0x0001000023d17824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe20000011422ULL, 0x0000010010e07824ULL, 0x048fe200078e00ffULL,
0x00000018ff007819ULL, 0x004fe2000001145eULL, 0x000000e600d77306ULL, 0x000e620000205400ULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x0001000010ec7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe20000011423ULL, 0x0000010058d27824ULL, 0x040fe200078e00ffULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x0001000011eb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe20000011458ULL, 0x0000002000c77306ULL, 0x000ea20000005400ULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0001000058db7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011410ULL, 0x0000010059cf7824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011411ULL, 0x000001005ba77824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011412ULL, 0x000000e400a57306ULL, 0x000fe20000209400ULL,
0x000000d7df00720bULL, 0x002fe20003fbd000ULL, 0x000100005aa97824ULL, 0x000fe200078e00ffULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x000100005bbe7824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011413ULL, 0x000001005cd77824ULL, 0x040fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x000000e400c47306ULL, 0x0002e20000205400ULL,
0x000000c7c300720bULL, 0x004fe20003fdd000ULL, 0x000100005cdf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114e0ULL, 0x0000010011e07824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fc40000011459ULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x0000002100d97306ULL, 0x000fe20000009400ULL, 0x000000e400e47245ULL, 0x002fe4000020d400ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ffa37819ULL, 0x000fe4000001145aULL,
0x00000018ffbe7819ULL, 0x000fe200000114beULL, 0x0000002100d87306ULL, 0x000e620000005400ULL,
0x000000c4a500720bULL, 0x008fe20003f5d000ULL, 0x000001005ea57824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe2000001145bULL, 0x000100005dc47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fc400000114a9ULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x0000002100867306ULL, 0x0004e2000000d400ULL, 0x00000018ff707819ULL, 0x000fe4000001145cULL,
0x00000018ff697819ULL, 0x000fe4000001145dULL, 0x00000018ff647819ULL, 0x000fe4000001145fULL,
0x00000001e4e42812ULL, 0x000fe200078efcffULL, 0x000000bd00c67306ULL, 0x000fe20000209400ULL,
0x0000010023217824ULL, 0x004fe200078e00ffULL, 0x000000d8d900720bULL, 0x002fe20003f7d000ULL,
0x0001000013d87824ULL, 0x000fe200078e00ffULL, 0x00000018ffeb7819ULL, 0x000fc400000114ebULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x000000bd00c57306ULL, 0x0003e20000205400ULL,
0x00000018ffd77819ULL, 0x000fe400000114d7ULL, 0x00000018ffd87819ULL, 0x000fe400000114d8ULL,
0x00000018ffdf7819ULL, 0x000fe400000114dfULL, 0x0000000186863812ULL, 0x008fe200078efcffULL,
0x0000002000877306ULL, 0x0004e2000000d400ULL, 0x000000bd00bd7245ULL, 0x002fc4000020d400ULL,
0x00000018ffc47819ULL, 0x000fe400000114c4ULL, 0x00000018ffa57819ULL, 0x000fc600000114a5ULL,
0x000000ca00e77306ULL, 0x000fe20000209400ULL, 0x0000010022207824ULL, 0x004fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x000000ca00e87306ULL, 0x0002a20000205400ULL,
0x0000000187876812ULL, 0x008fce00078efcffULL, 0x0000002200c17306ULL, 0x000fe20000009400ULL,
0x000000ca00ca7245ULL, 0x002fce000020d400ULL, 0x0000002200c27306ULL, 0x000fe20000005400ULL,
0x000000e8e700720bULL, 0x004fce0003fdd000ULL, 0x0000002200827306ULL, 0x000fec000000d400ULL,
0x00000001caca6812ULL, 0x000fe400078efcffULL, 0x0000002100c87306ULL, 0x000ff00000209400ULL,
0x0000002100227306ULL, 0x000e700000205400ULL, 0x0000005e009b7306ULL, 0x000ff00000009400ULL,
0x0000005e009a7306ULL, 0x000fe20000005400ULL, 0x00000022c800720bULL, 0x002fce0003f7d000ULL,
0x0000005e00667306ULL, 0x0003f0000000d400ULL, 0x0000002300b47306ULL, 0x000fe20000009400ULL,
0x000000e6005e7245ULL, 0x002fe4000020d400ULL, 0x00000018ffe67819ULL, 0x000fc400000114ecULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x000000c5c600720bULL, 0x000fe20003fbd000ULL,
0x0000002300b37306ULL, 0x000e700000005400ULL, 0x00000023007f7306ULL, 0x000ea8000000d400ULL,
0x00000001bdbd5812ULL, 0x000fc800078efcffULL, 0x000000e500857306ULL, 0x000fe20000209400ULL,
0x000000b3b400720bULL, 0x002fe40003fdd000ULL, 0x0000002100b37245ULL, 0x000fe4000020d400ULL,
0x0000002000b47245ULL, 0x000fe4000020d400ULL, 0x00000001b3b33812ULL, 0x000fe200078efcffULL,
0x000000e500797306ULL, 0x0002ec0000205400ULL, 0x000000017f7f6812ULL, 0x004fc400078efcffULL,
0x000000cd00ce7306ULL, 0x000fe20000209400ULL, 0x000000e500e57245ULL, 0x002fce000020d400ULL,
0x000000cd00237306ULL, 0x0002a20000205400ULL, 0x000000798500720bULL, 0x008fe20003f9d000ULL,
0x000001005f857824ULL, 0x040fe400078e00ffULL, 0x000100005f797824ULL, 0x000fc600078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x000000d100d57306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x002fe4000020d400ULL, 0x00000018ff797819ULL, 0x000fc60000011479ULL,
0x00000001e5e54812ULL, 0x000fe400078efcffULL, 0x000000d100d67306ULL, 0x0002e20000205400ULL,
0x00000023ce00720bULL, 0x004fe40003fbd000ULL, 0x000000c2c100720bULL, 0x000fca0003f9d000ULL,
0x0000005800b67306ULL, 0x000fe20000009400ULL, 0x000000d100d17245ULL, 0x002fca000020d400ULL,
0x00000001cdcd5812ULL, 0x000fe400078efcffULL, 0x0000005800b77306ULL, 0x000e620000005400ULL,
0x000000d6d500720bULL, 0x008fe40003f7d000ULL, 0x0000000182824812ULL, 0x000fca00078efcffULL,
0x0000005900b07306ULL, 0x000fec0000009400ULL, 0x00000001d1d13812ULL, 0x000fe400078efcffULL,
0x0000005900af7306ULL, 0x000ea20000005400ULL, 0x000000b7b600720bULL, 0x002fce0003fbd000ULL,
0x00000058007d7306ULL, 0x0002f0000000d400ULL, 0x000000b900b17306ULL, 0x000fe20000209400ULL,
0x000000afb000720bULL, 0x004fe20003f7d000ULL, 0x0001000059587824ULL, 0x002fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x000000b900ac7306ULL, 0x0002a20000205400ULL,
0x000000017d7d5812ULL, 0x008fce00078efcffULL, 0x000000a600bc7306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fce000020d400ULL, 0x000000a600ae7306ULL, 0x000e620000205400ULL,
0x000000acb100720bULL, 0x004fce0003f9d000ULL, 0x000000c900e97306ULL, 0x000fec0000209400ULL,
0x00000001b9b94812ULL, 0x000fe400078efcffULL, 0x000000c900ea7306ULL, 0x0004e20000205400ULL,
0x000000aebc00720bULL, 0x002fe40003fbd000ULL, 0x000000d1b9b9723eULL, 0x000fca00000010ffULL,
0x0000001000a47306ULL, 0x000fe20000009400ULL, 0x000000c900c97245ULL, 0x004fce000020d400ULL,
0x0000001000957306ULL, 0x000fe20000005400ULL, 0x000000eae900720bULL, 0x008fce0003f5d000ULL,
0x0000001000637306ULL, 0x0003ec000000d400ULL, 0x00000001c9c92812ULL, 0x000fe400078efcffULL,
0x0000001100a27306ULL, 0x000fe20000009400ULL, 0x0000010013107824ULL, 0x002fca00078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe40000011410ULL, 0x0000001100897306ULL, 0x000fe20000005400ULL,
0x0000a00053107811ULL, 0x000fce00078e20ffULL, 0x0000001100717306ULL, 0x0003f0000000d400ULL,
0x0000001200887306ULL, 0x000fe20000009400ULL, 0x0000010012117824ULL, 0x002fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe40000011411ULL, 0x0000001200907306ULL, 0x000ff00000005400ULL,
0x00000012006f7306ULL, 0x0003f0000000d400ULL, 0x0000002000cb7306ULL, 0x000fe20000209400ULL,
0x0001000012127824ULL, 0x002fca00078e00ffULL, 0x00000018ffae7819ULL, 0x000fe40000011412ULL,
0x0000002000cc7306ULL, 0x0002b00000205400ULL, 0x000000d200d47306ULL, 0x000fe20000209400ULL,
0x0000a00054207811ULL, 0x002fcc00078e20ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000000d200d07306ULL, 0x0007620000205400ULL, 0x000000cccb00720bULL, 0x004fce0003f5d000ULL,
0x00000013009f7306ULL, 0x000fe20000009400ULL, 0x000000d200d27245ULL, 0x008fca000020d400ULL,
0x00000001b4b42812ULL, 0x000fe400078efcffULL, 0x00000013008d7306ULL, 0x000fe20000005400ULL,
0x000000d0d400720bULL, 0x020fce0003fdd000ULL, 0x00000013006e7306ULL, 0x0005ec000000d400ULL,
0x00000001d2d26812ULL, 0x000fe400078efcffULL, 0x000000db00dc7306ULL, 0x000fe20000209400ULL,
0x000000001010783bULL, 0x004ea20000000200ULL, 0x0000007dd2ce723eULL, 0x000fe200000010ffULL,
0x0000008120209231ULL, 0x002fca00003400ffULL, 0x000000db00e37306ULL, 0x0002e20000205400ULL,
0x0000008122229231ULL, 0x000fe400003400ffULL, 0x0000008021219231ULL, 0x090fe400003400ffULL,
0x0000008023239231ULL, 0x000fc600003400ffULL, 0x000000ab00bb7306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x002fce000020d400ULL, 0x000000ab00b27306ULL, 0x0003220000205400ULL,
0x000000e3dc00720bULL, 0x008fce0003fdd000ULL, 0x00000059007c7306ULL, 0x000762000000d400ULL,
0x000000ab00ab7245ULL, 0x002fca000020d400ULL, 0x00000001dbdb6812ULL, 0x000fe400078efcffULL,
0x0000005800e17306ULL, 0x000fe20000209400ULL, 0x000001005a597824ULL, 0x008fe200078e00ffULL,
0x000000b2bb00720bULL, 0x010fe20003f5d000ULL, 0x0000008110109231ULL, 0x084fe400003400ffULL,
0x0000008112129231ULL, 0x000fe200003400ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000008011119231ULL, 0x080fe200003400ffULL, 0x0000005800e27306ULL, 0x000e620000205400ULL,
0x000000017c7c3812ULL, 0x020fe200078efcffULL, 0x0000008013139231ULL, 0x000fca00003400ffULL,
0x00000001abab2812ULL, 0x000fe200078efcffULL, 0x0000005900dd7306ULL, 0x000ff00000209400ULL,
0x0000005900de7306ULL, 0x000ea20000205400ULL, 0x000000e2e100720bULL, 0x002fce0003f7d000ULL,
0x000000e600c57306ULL, 0x000ff00000209400ULL, 0x000000e600c17306ULL, 0x0002e20000205400ULL,
0x000000dedd00720bULL, 0x004fce0003fdd000ULL, 0x0000005a00b57306ULL, 0x000fe20000009400ULL,
0x000000e600e67245ULL, 0x002fce000020d400ULL, 0x0000005a00ad7306ULL, 0x000e620000005400ULL,
0x000000c1c500720bULL, 0x008fce0003f3d000ULL, 0x000000cf00d37306ULL, 0x000fec0000209400ULL,
0x00000001e6e61812ULL, 0x000fe400078efcffULL, 0x000000cf00da7306ULL, 0x0004e20000205400ULL,
0x000000adb500720bULL, 0x002fe40003f9d000ULL, 0x000000a600ad7245ULL, 0x000fc4000020d400ULL,
0x0000005800a67245ULL, 0x000fe4000020d400ULL, 0x00000001adad5812ULL, 0x000fe200078efcffULL,
0x0000005a00787306ULL, 0x000e62000000d400ULL, 0x00000001a6a63812ULL, 0x000fe400078efcffULL,
0x000000cf00cf7245ULL, 0x004fe4000020d400ULL, 0x0000005ee558723eULL, 0x000fc600000010ffULL,
0x0000005b008c7306ULL, 0x000fe20000009400ULL, 0x000000dad300720bULL, 0x008fce0003f5d000ULL,
0x0000005b008f7306ULL, 0x000ea20000005400ULL, 0x0000000178784812ULL, 0x002fca00078efcffULL,
0x00000001cfcf2812ULL, 0x000fe400078efcffULL, 0x000000a700a87306ULL, 0x000fe40000209400ULL,
0x0000007ccfcf723eULL, 0x000fcc00000010ffULL, 0x000000a7005a7306ULL, 0x0002e20000205400ULL,
0x0000008f8c00720bULL, 0x004fe20003f7d000ULL, 0x000000ce1014723cULL, 0x000fe20000041814ULL,
0x00000059008c7245ULL, 0x000fe4000020d400ULL, 0x000000cabd59723eULL, 0x000fe400000010ffULL,
0x000000018c8c6812ULL, 0x000fe200078efcffULL, 0x000000a300947306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x002fce000020d400ULL, 0x000000a300987306ULL, 0x0002a20000205400ULL,
0x0000005aa800720bULL, 0x008fce0003fbd000ULL, 0x000000ac00b27306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x00000001a7a75812ULL, 0x000fe400078efcffULL,
0x000000ac00b67306ULL, 0x0002e20000205400ULL, 0x000000989400720bULL, 0x004fce0003fdd000ULL,
0x0000008b00b87306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x002fca000020d400ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x0000008b00ba7306ULL, 0x0002a20000205400ULL,
0x000000b6b200720bULL, 0x008fe40003f3d000ULL, 0x000000908800720bULL, 0x000fca0003fdd000ULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x002fca000020d400ULL,
0x00000001acac1812ULL, 0x000fe400078efcffULL, 0x000000be00c07306ULL, 0x0002e20000205400ULL,
0x000000bab800720bULL, 0x004fe40003f5d000ULL, 0x000000016f6f6812ULL, 0x000fe400078efcffULL,
0x000000cdabb8723eULL, 0x000fc600000010ffULL, 0x0000005b00727306ULL, 0x000ea2000000d400ULL,
0x000000be00be7245ULL, 0x002fc6000020d400ULL, 0x000000b8104c723cULL, 0x000fe4000004184cULL,
0x000000018b8b2812ULL, 0x000fe400078efcffULL, 0x000000a100977306ULL, 0x000fe20000209400ULL,
0x000000c0bf00720bULL, 0x008fce0003fbd000ULL, 0x000000a100967306ULL, 0x0002e20000205400ULL,
0x0000000172723812ULL, 0x004fe400078efcffULL, 0x00000095a400720bULL, 0x000fc60003f7d000ULL,
0x00000001bebe5812ULL, 0x000fe400078efcffULL, 0x000000af00b57306ULL, 0x000fe20000209400ULL,
0x000000a100a17245ULL, 0x002fce000020d400ULL, 0x000000af00b77306ULL, 0x0002a20000205400ULL,
0x000000969700720bULL, 0x008fe40003f9d000ULL, 0x0000000163633812ULL, 0x000fe400078efcffULL,
0x0000008d9f00720bULL, 0x000fc60003f7d000ULL, 0x000000a900aa7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x00000001a1a14812ULL, 0x000fe400078efcffULL,
0x000000a9005b7306ULL, 0x0002e20000205400ULL, 0x000000b7b500720bULL, 0x004fe40003f3d000ULL,
0x000000016e6e3812ULL, 0x000fe400078efcffULL, 0x000000bea1a1723eULL, 0x000fc600000010ffULL,
0x000000c300c77306ULL, 0x000fe20000209400ULL, 0x000000a900a97245ULL, 0x002fca000020d400ULL,
0x00000001afaf1812ULL, 0x000fe400078efcffULL, 0x000000c300d97306ULL, 0x0002a20000205400ULL,
0x0000005baa00720bULL, 0x008fe40003f5d000ULL, 0x000000581058723cULL, 0x000fea000004181cULL,
0x0000005c008a7306ULL, 0x000fe20000009400ULL, 0x000000c300c37245ULL, 0x002fc4000020d400ULL,
0x000000788c1c723eULL, 0x000fe400000010ffULL, 0x00000072a71d723eULL, 0x000fe400000010ffULL,
0x00000001a9a92812ULL, 0x000fe200078efcffULL, 0x0000005c008e7306ULL, 0x000fe20000005400ULL,
0x000000d9c700720bULL, 0x004fe40003fbd000ULL, 0x00000089a200720bULL, 0x000fe20003f5d000ULL,
0x0000001c101c723cULL, 0x000fe20000041808ULL, 0x00000018ff727819ULL, 0x000fc60000011460ULL,
0x0000005c006b7306ULL, 0x0003ec000000d400ULL, 0x00000001c3c35812ULL, 0x000fe400078efcffULL,
0x0000005d009c7306ULL, 0x000fe20000009400ULL, 0x000001005d5c7824ULL, 0x002fe200078e00ffULL,
0x0000000171712812ULL, 0x000fc400078efcffULL, 0x00000063c308723eULL, 0x000fe400000010ffULL,
0x00000018ff807819ULL, 0x000fe4000001145cULL, 0x0000005d00927306ULL, 0x000fe20000005400ULL,
0x00000087e45c723eULL, 0x000fce00000010ffULL, 0x0000005d00677306ULL, 0x000ff0000000d400ULL,
0x0000005f00767306ULL, 0x000ff00000009400ULL, 0x0000005f00757306ULL, 0x000ff00000005400ULL,
0x0000005f00657306ULL, 0x000ff0000000d400ULL, 0x0000007e00847306ULL, 0x000ff00000209400ULL,
0x0000007e00837306ULL, 0x0002b00000205400ULL, 0x000000e0005d7306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fce000020d400ULL, 0x000000e0005f7306ULL, 0x0002e20000205400ULL,
0x000000838400720bULL, 0x004fce0003fdd000ULL, 0x000000ae00b07306ULL, 0x000fe20000209400ULL,
0x000000e000e07245ULL, 0x002fca000020d400ULL, 0x000000017e7e6812ULL, 0x000fe400078efcffULL,
0x000000ae008f7306ULL, 0x0002a20000205400ULL, 0x0000005f5d00720bULL, 0x008fe40003f9d000ULL,
0x00000086c95d723eULL, 0x000fca00000010ffULL, 0x0000009d00a07306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fe2000020d400ULL, 0x0000005c105c723cULL, 0x000fe80000041848ULL,
0x00000001e0e04812ULL, 0x000fe400078efcffULL, 0x0000009d00917306ULL, 0x0002e20000205400ULL,
0x0000008fb000720bULL, 0x004fe40003f3d000ULL, 0x00000082b448723eULL, 0x000fc400000010ffULL,
0x0000007fb349723eULL, 0x000fe400000010ffULL, 0x00000071e009723eULL, 0x000fe200000010ffULL,
0x00000077007b7306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fe4000020d400ULL,
0x000000c400717245ULL, 0x000fe2000020d400ULL, 0x000000481048723cULL, 0x000fe40000041818ULL,
0x00000001aeae1812ULL, 0x000fe400078efcffULL, 0x00000077007a7306ULL, 0x0002a20000205400ULL,
0x00000091a000720bULL, 0x008fc40003fbd000ULL, 0x000000a9a3a0723eULL, 0x000fe400000010ffULL,
0x000000dbad18723eULL, 0x000fe400000010ffULL, 0x000000a68b19723eULL, 0x000fe200000010ffULL,
0x000000eb00c27306ULL, 0x000fe20000209400ULL, 0x0000007700777245ULL, 0x002fca000020d400ULL,
0x000000019d9d5812ULL, 0x000fe200078efcffULL, 0x000000181018723cULL, 0x000fe2000004180cULL,
0x000000eb00b17306ULL, 0x0002e20000205400ULL, 0x0000007a7b00720bULL, 0x004fe40003f3d000ULL,
0x0000008e8a00720bULL, 0x000fe40003fbd000ULL, 0x000000e69d0a723eULL, 0x000fe400000010ffULL,
0x0000006fac0c723eULL, 0x000fe200000010ffULL, 0x000000d700887306ULL, 0x000fe20000209400ULL,
0x000000eb00eb7245ULL, 0x002fc4000020d400ULL, 0x0000006eaf0d723eULL, 0x000fc600000010ffULL,
0x0000000177771812ULL, 0x000fe400078efcffULL, 0x000000d700817306ULL, 0x0002a20000205400ULL,
0x000000b1c200720bULL, 0x008fe20003f9d000ULL, 0x0000000c200c723cULL, 0x000fe20000041848ULL,
0x000000016b6b5812ULL, 0x000fca00078efcffULL, 0x00000099009e7306ULL, 0x000fe20000209400ULL,
0x000000d700d77245ULL, 0x002fca000020d400ULL, 0x00000001ebeb4812ULL, 0x000fe400078efcffULL,
0x0000009900937306ULL, 0x0002e20000205400ULL, 0x000000818800720bULL, 0x004fe40003fdd000ULL,
0x000000929c00720bULL, 0x000fca0003f9d000ULL, 0x000000d800947306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fca000020d400ULL, 0x00000001d7d76812ULL, 0x000fe400078efcffULL,
0x000000d800897306ULL, 0x0002a20000205400ULL, 0x000000939e00720bULL, 0x008fe40003f5d000ULL,
0x0000000167674812ULL, 0x000fe400078efcffULL, 0x0000006bd748723eULL, 0x000fc600000010ffULL,
0x0000007000737306ULL, 0x000fe20000209400ULL, 0x000000d800d87245ULL, 0x002fca000020d400ULL,
0x0000000199992812ULL, 0x000fe400078efcffULL, 0x0000007000747306ULL, 0x0002e20000205400ULL,
0x000000899400720bULL, 0x004fe40003f7d000ULL, 0x000000eb990b723eULL, 0x000fe400000010ffULL,
0x0000009a9b00720bULL, 0x000fc60003f5d000ULL, 0x00000080008d7306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fca000020d400ULL, 0x00000001d8d83812ULL, 0x000fe400078efcffULL,
0x0000008000907306ULL, 0x0002a20000205400ULL, 0x000000747300720bULL, 0x008fe40003f3d000ULL,
0x000000757600720bULL, 0x000fe40003f7d000ULL, 0x0000000166662812ULL, 0x000fc600078efcffULL,
0x0000006900627306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x0000000170701812ULL, 0x000fe400078efcffULL, 0x0000006900617306ULL, 0x0002e20000205400ULL,
0x000000908d00720bULL, 0x004fe40003fdd000ULL, 0x0000000165653812ULL, 0x000fca00078efcffULL,
0x000000df00877306ULL, 0x000fe20000209400ULL, 0x0000006900697245ULL, 0x002fca000020d400ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x000000df00867306ULL, 0x0002a20000205400ULL,
0x000000616200720bULL, 0x008fe40003fbd000ULL, 0x000000a01060723cULL, 0x000fe20000041804ULL,
0x000000678049723eULL, 0x000fe400000010ffULL, 0x0000008500677245ULL, 0x000fe4000020d400ULL,
0x000000c400827306ULL, 0x000fe20000209400ULL, 0x000000df00df7245ULL, 0x002fc4000020d400ULL,
0x000000082004723cULL, 0x040fe2000004185cULL, 0x000000ae7e10723eULL, 0x000fe400000010ffULL,
0x0000000169695812ULL, 0x000fe400078efcffULL, 0x000000c4007f7306ULL, 0x000e620000205400ULL,
0x000000868700720bULL, 0x004fe40003fdd000ULL, 0x0000000a2008723cULL, 0x000fe20000041858ULL,
0x000000d87711723eULL, 0x000fc800000010ffULL, 0x000000a5007c7306ULL, 0x000fe60000209400ULL,
0x000000102010723cULL, 0x040fe6000004184cULL, 0x00000001dfdf6812ULL, 0x000fe400078efcffULL,
0x000000a5007a7306ULL, 0x0004e20000205400ULL, 0x0000007f8200720bULL, 0x002fe40003f9d000ULL,
0x000000df7070723eULL, 0x000fe200000010ffULL, 0x000000482014723cULL, 0x000fe80000041814ULL,
0x0000008500757306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x004fca000020d400ULL,
0x0000000171714812ULL, 0x000fe400078efcffULL, 0x0000008500767306ULL, 0x000e620000205400ULL,
0x0000007a7c00720bULL, 0x008fe40003f3d000ULL, 0x000000716971723eULL, 0x000fca00000010ffULL,
0x00000000006c7306ULL, 0x000fe40000209400ULL, 0x000000702018723cULL, 0x000fe80000041818ULL,
0x00000001a5a51812ULL, 0x000fe400078efcffULL, 0x00000000006d7306ULL, 0x0004e20000205400ULL,
0x000000767500720bULL, 0x002fe40003fbd000ULL, 0x00000066a566723eULL, 0x000fca00000010ffULL,
0x0000006400687306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x004fca000020d400ULL,
0x0000000167675812ULL, 0x000fe400078efcffULL, 0x00000064006a7306ULL, 0x0002a20000205400ULL,
0x0000006d6c00720bULL, 0x008fe40003fdd000ULL, 0x000000656767723eULL, 0x000fca00000010ffULL,
0x0000007200737306ULL, 0x000fe20000209400ULL, 0x0000006400647245ULL, 0x002fe2000020d400ULL,
0x00000066201c723cULL, 0x000fe8000004181cULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x0000007200747306ULL, 0x0002e20000205400ULL, 0x0000006a6800720bULL, 0x004fce0003f9d000ULL,
0x00000079005c7306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x002fca000020d400ULL,
0x0000000164644812ULL, 0x000fe400078efcffULL, 0x0000007900587306ULL, 0x000e620000205400ULL,
0x000000747300720bULL, 0x008fe40003f3d000ULL, 0x0000007900737245ULL, 0x000fd6000020d400ULL,
0x0000000172721812ULL, 0x000fe400078efcffULL, 0x000000585c00720bULL, 0x002fe40003f5d000ULL,
0x000000720072723eULL, 0x000fd600000010ffULL, 0x0000000173732812ULL, 0x000fc800078efcffULL,
0x000000736473723eULL, 0x000fce00000010ffULL, 0x000000722020723cULL, 0x000fe20000041860ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff487f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004003007811ULL, 0x000fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff487224ULL, 0x002fe400078e0049ULL, 0x000000002400720cULL, 0x000fda0003f24070ULL,
0x0000e90000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824848ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000497305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000490000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff497984ULL, 0x000e640000000800ULL, 0x8000000049ff7812ULL, 0x002fc40007824848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000006003007811ULL, 0x000fe200078e40ffULL,
0x00000100ff587424ULL, 0x000fe200078e00ffULL, 0x00000004ff4d7819ULL, 0x000fe4000001162dULL,
0x0000000024487217ULL, 0x000fe20007800000ULL, 0x000062002b4c7a24ULL, 0x000fc800078e0200ULL,
0x0000000148487824ULL, 0x000fe400078e0a00ULL, 0x0000000135497824ULL, 0x100fe400078e024cULL,
0x00000001304a7824ULL, 0x000fe200078e024cULL, 0x0000002048007807ULL, 0x000fe20000000000ULL,
0x00005e0049487625ULL, 0x000fc600078e0058ULL, 0x000000002c007217ULL, 0x000fe20007800000ULL,
0x00005e004a4a7625ULL, 0x000fe200078e0058ULL, 0x00000034484e7210ULL, 0x000fc60007f3e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a2cULL, 0x000000344a4a7210ULL, 0x000fe20007f7e0ffULL,
0x000000012f487824ULL, 0x100fe400078e024cULL, 0x000000012e4c7824ULL, 0x000fe200078e024cULL,
0x000000004d00720cULL, 0x080fe20003f46070ULL, 0x000000ffff4f7224ULL, 0x000fe200008e0649ULL,
0x000000003300720cULL, 0x000fe20003f26070ULL, 0x00005e0048487625ULL, 0x000fe200078e0058ULL,
0x000000003100720cULL, 0x000fc60003f86070ULL, 0x00005e004c4c7625ULL, 0x000fe200078e0058ULL,
0x0000003448487210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff4b7224ULL, 0x000fe200018e064bULL,
0x000000003200720cULL, 0x000fe20003f66070ULL, 0x000000ffff497224ULL, 0x000fe200028e0649ULL,
0x000000344c4c7210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004e447faeULL, 0x0003e8000d101c46ULL, 0x000000ffff4d7224ULL, 0x000fe200030e064dULL,
0x000000004a437faeULL, 0x0003ea000c901c46ULL, 0x0000000048427faeULL, 0x0003e8000d901c46ULL,
0x000000004c417faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff6c7f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010628002c487f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007844857ULL, 0x01062c002c4a7984ULL, 0x000e640000000800ULL,
0x800000004aff7812ULL, 0x002fe40007824849ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x00000000004a7305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x0000004a0000735dULL, 0x008fe40003800000ULL,
0x01062c002c4a7984ULL, 0x000e640000000800ULL, 0x800000004aff7812ULL, 0x002fc40007824849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01008000404a7984ULL, 0x000e680000000800ULL,
0x01028000404b7984ULL, 0x0007220000000800ULL, 0x0000002a4a00720bULL, 0x002fe20003f3d000ULL,
0x000176827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff004c7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ffc57424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000012500780cULL, 0x000fe40003f65270ULL, 0x0000002a4a00720bULL, 0x000fe20003f34000ULL,
0x000176427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x0000004a2a487209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fc600078e3cffULL,
0x800000482a497221ULL, 0x000fe20000010000ULL, 0x010480484000b388ULL, 0x0003e20000000800ULL,
0x000000004cff7212ULL, 0x000fe4000782c0ffULL, 0x3fb8aa3b49497820ULL, 0x000fe20000410000ULL,
0x00000002ff007819ULL, 0x000fca000001162dULL, 0x0000004900497308ULL, 0x000ee40000000800ULL,
0x0000004929297220ULL, 0x008fe20000410000ULL, 0x000175d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0049007589ULL, 0x0022e400000e0000ULL, 0x0000000004047220ULL, 0x08cfe20000410000ULL,
0x0000000005057220ULL, 0x080fe20000410000ULL, 0x0000000008087220ULL, 0x080fe20000410000ULL,
0x0000000009097220ULL, 0x080fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000d0d7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000020207220ULL, 0x080fe20000410000ULL,
0x0000000021217220ULL, 0x000fe20000410000ULL, 0x000175227f007947ULL, 0x000fea000b800000ULL,
0x00001f3849007589ULL, 0x0004e400000e0000ULL, 0x0000004a2a2a7209ULL, 0x000fe20007810000ULL,
0x0000000006067220ULL, 0x08cfe20000410000ULL, 0x00000001ffc57807ULL, 0x000fe20000800000ULL,
0x0000000007077220ULL, 0x080fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x8000002a4a4a1221ULL, 0x000fe20000010000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b4a4a1820ULL, 0x000fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x0000004a00261308ULL, 0x000ea20000000800ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x000fe20000410000ULL,
0x0000004b264b1220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000294b297221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ee40000000800ULL,
0x8000000000ff7812ULL, 0x008fc40007824857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000487305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000480000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff487984ULL, 0x000ee40000000800ULL,
0x8000000048ff7812ULL, 0x008fe40007824857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000026ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff637819ULL, 0x000fc4000001162dULL,
0x0000541000627816ULL, 0x000fe20000000000ULL, 0x000172d27f007947ULL, 0x000fea000b800000ULL,
0x00001f6362777589ULL, 0x00072400000e0000ULL, 0x000173127f007947ULL, 0x000fea000b800000ULL,
0x00001f3862787589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x008fe200078e0037ULL, 0x00006ab0005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0001802000007944ULL, 0x016fea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x008fe200078e0036ULL, 0x00006b10005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x00017fc000007944ULL, 0x016fea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003e48783bULL, 0x002e620000004200ULL, 0x00009910c5c67816ULL, 0x000fc600000000ffULL,
0x000000003d58783bULL, 0x000f680000004200ULL, 0x000000003c5c783bULL, 0x000f280000004200ULL,
0x000000003b4c783bULL, 0x000ee20000004200ULL, 0x0001000048e17824ULL, 0x042fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe20000011448ULL, 0x0000010048e27824ULL, 0x000fe200078e00ffULL,
0x0000004900e07306ULL, 0x000fe20000009400ULL, 0x00000018ffc77819ULL, 0x000fe20000011449ULL,
0x000001004bc87824ULL, 0x000fe200078e00ffULL, 0x00000018ffe17819ULL, 0x000fe200000114e1ULL,
0x0001000049d47824ULL, 0x040fe200078e00ffULL, 0x00000018ffe27819ULL, 0x000fe200000114e2ULL,
0x0000010049df7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x000000e100e97306ULL, 0x000fe20000209400ULL, 0x00000018ffd47819ULL, 0x000fe200000114d4ULL,
0x000100004ac97824ULL, 0x040fe200078e00ffULL, 0x00000018ffdf7819ULL, 0x000fe200000114dfULL,
0x000001005bb57824ULL, 0x020fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe2000001145bULL,
0x000100004bc37824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x000000e100e87306ULL, 0x000e620000205400ULL, 0x000001004acc7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x010fe2000001145cULL, 0x000100005abb7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000001005ab27824ULL, 0x000fe200078e00ffULL,
0x00000018ffcc7819ULL, 0x000fc400000114ccULL, 0x0000004900dc7306ULL, 0x000f220000005400ULL,
0x00000018ffaa7819ULL, 0x000fe4000001144bULL, 0x00000018ff9d7819ULL, 0x000fe40000011458ULL,
0x00000018ffa07819ULL, 0x000fe40000011459ULL, 0x00000018ffaf7819ULL, 0x000fe2000001144aULL,
0x0000004800d87306ULL, 0x000fe20000009400ULL, 0x000000e8e900720bULL, 0x002fe20003fbd000ULL,
0x000001005de87824ULL, 0x040fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe2000001145aULL,
0x000100005de97824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fc400000114b5ULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x0000004800d97306ULL, 0x000e620000005400ULL,
0x000000dce000720bULL, 0x010fe40003f7d000ULL, 0x00000018ffb27819ULL, 0x000fe400000114b2ULL,
0x00000018ff947819ULL, 0x000fe4000001145dULL, 0x00000018ff767819ULL, 0x008fe2000001144dULL,
0x000000db00da7306ULL, 0x000fe20000209400ULL, 0x00000018ff007819ULL, 0x004fc4000001144eULL,
0x00000018ff617819ULL, 0x000fe4000001145eULL, 0x00000018ff7d7819ULL, 0x000fe4000001144cULL,
0x00000018ff577819ULL, 0x000fe2000001144fULL, 0x000000db00dd7306ULL, 0x0004e20000205400ULL,
0x000000d9d800720bULL, 0x002fe20003f9d000ULL, 0x000001005fd97824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fc8000001145fULL, 0x00000018ffd97819ULL, 0x000fe200000114d9ULL,
0x000000e200de7306ULL, 0x000fe20000209400ULL, 0x000000db00db7245ULL, 0x004fce000020d400ULL,
0x000000e200e77306ULL, 0x000e620000205400ULL, 0x000000ddda00720bULL, 0x008fe40003f5d000ULL,
0x000000e100da7245ULL, 0x000fc8000020d400ULL, 0x00000001dada5812ULL, 0x000fe200078efcffULL,
0x000000c700d27306ULL, 0x000fec0000209400ULL, 0x00000001dbdb2812ULL, 0x000fe400078efcffULL,
0x000000c700d37306ULL, 0x0004e20000205400ULL, 0x000000e7de00720bULL, 0x002fe20003fdd000ULL,
0x000100005ce77824ULL, 0x000fc400078e00ffULL, 0x000001005ede7824ULL, 0x000fc600078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114e7ULL, 0x0000004900867306ULL, 0x000322000000d400ULL,
0x000000c700c77245ULL, 0x004fe4000020d400ULL, 0x00000018ffde7819ULL, 0x000fca00000114deULL,
0x000000c800d07306ULL, 0x000fe20000209400ULL, 0x000000d3d200720bULL, 0x008fe20003fbd000ULL,
0x0000010058497824ULL, 0x002fe200078e00ffULL, 0x000000df00d27245ULL, 0x000fc8000020d400ULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x000000c800d77306ULL, 0x0002a20000205400ULL,
0x0000000186863812ULL, 0x010fca00078efcffULL, 0x00000001c7c75812ULL, 0x000fe400078efcffULL,
0x0000004800877306ULL, 0x000722000000d400ULL, 0x000000c800c87245ULL, 0x002fce000020d400ULL,
0x000000d400e57306ULL, 0x000fe20000209400ULL, 0x000000d7d000720bULL, 0x004fe20003f7d000ULL,
0x0000010059487824ULL, 0x008fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x000000d400e47306ULL, 0x0002a20000205400ULL, 0x0000000187874812ULL, 0x010fca00078efcffULL,
0x00000001c8c83812ULL, 0x000fe400078efcffULL, 0x0000005b009c7306ULL, 0x000fe20000009400ULL,
0x000000d400d47245ULL, 0x002fce000020d400ULL, 0x0000005b009a7306ULL, 0x000fe20000005400ULL,
0x000000e4e500720bULL, 0x004fce0003f9d000ULL, 0x0000005b00817306ULL, 0x0003ec000000d400ULL,
0x00000001d4d44812ULL, 0x000fe400078efcffULL, 0x000000df00e37306ULL, 0x000fe20000209400ULL,
0x000100005b5b7824ULL, 0x002fca00078e00ffULL, 0x00000018ffc57819ULL, 0x000fe2000001145bULL,
0x000000ffff5b7224ULL, 0x000fe200078e00c6ULL, 0x000000df00e67306ULL, 0x000fe80000205400ULL,
0x000000ff5b00720cULL, 0x000fe20003f25270ULL, 0x000001005c5b7824ULL, 0x000fc600078e00ffULL,
0x000000c900cd7306ULL, 0x000fe40000209400ULL, 0x00000018ff5b7819ULL, 0x000fcc000001145bULL,
0x000000c900d17306ULL, 0x0002b00000205400ULL, 0x000000c300ce7306ULL, 0x000fe20000209400ULL,
0x000000c900c97245ULL, 0x002fce000020d400ULL, 0x000000c300cf7306ULL, 0x0002e20000205400ULL,
0x000000d1cd00720bULL, 0x004fce0003fbd000ULL, 0x0000004b00c17306ULL, 0x000fe20000009400ULL,
0x000000c300c37245ULL, 0x002fca000020d400ULL, 0x00000001c9c95812ULL, 0x000fe400078efcffULL,
0x0000004b00c27306ULL, 0x000e620000005400ULL, 0x000000cfce00720bULL, 0x008fce0003f7d000ULL,
0x0000005c009b7306ULL, 0x000fec0000009400ULL, 0x00000001c3c33812ULL, 0x000fe400078efcffULL,
0x0000005c00977306ULL, 0x000fe20000005400ULL, 0x000000c2c100720bULL, 0x002fe40003f9d000ULL,
0x00000018ffc17819ULL, 0x000fca00000114e8ULL, 0x0000005c00697306ULL, 0x0003f0000000d400ULL,
0x000000cc00d57306ULL, 0x000fe20000209400ULL, 0x000000e2005c7245ULL, 0x002fc8000020d400ULL,
0x000000015c5c6812ULL, 0x000fe400078efcffULL, 0x000000e6e300720bULL, 0x000fe20003fdd000ULL,
0x000000cc00d67306ULL, 0x0002b00000205400ULL, 0x000000aa00ac7306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fc6000020d400ULL, 0x00000001d2d26812ULL, 0x000fc800078efcffULL,
0x000000aa00ab7306ULL, 0x000e620000205400ULL, 0x000000d6d500720bULL, 0x004fce0003fdd000ULL,
0x0000004a00cb7306ULL, 0x000fec0000009400ULL, 0x00000001cccc6812ULL, 0x000fe400078efcffULL,
0x0000004a00ca7306ULL, 0x000ea20000005400ULL, 0x000000abac00720bULL, 0x002fe20003fbd000ULL,
0x000100004eab7824ULL, 0x000fc400078e00ffULL, 0x000001004fac7824ULL, 0x000fc600078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000004800bf7306ULL, 0x000fe20000209400ULL,
0x00000018ffac7819ULL, 0x000fce00000114acULL, 0x0000004800c47306ULL, 0x000e620000205400ULL,
0x000000cacb00720bULL, 0x004fce0003f5d000ULL, 0x0000004b00627306ULL, 0x000eb0000000d400ULL,
0x0000005900ad7306ULL, 0x000fe20000009400ULL, 0x000000c4bf00720bULL, 0x002fe20003f7d000ULL,
0x000001004dbf7824ULL, 0x000fca00078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x0000005900ae7306ULL, 0x000e620000005400ULL, 0x0000000162624812ULL, 0x004fce00078efcffULL,
0x0000005900647306ULL, 0x0004f0000000d400ULL, 0x0000005800b77306ULL, 0x000fe20000009400ULL,
0x0001000059597824ULL, 0x004fe200078e00ffULL, 0x000000aead00720bULL, 0x002fe20003f9d000ULL,
0x000001004ead7824ULL, 0x000fe200078e00ffULL, 0x000000aa00ae7245ULL, 0x000fe2000020d400ULL,
0x000100004faa7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fc40000011459ULL,
0x0000005800b97306ULL, 0x000e620000005400ULL, 0x00000001aeae5812ULL, 0x000fe400078efcffULL,
0x00000018ffad7819ULL, 0x000fe400000114adULL, 0x00000018ffaa7819ULL, 0x000fe400000114aaULL,
0x0000000164644812ULL, 0x008fe200078efcffULL, 0x0000009d009e7306ULL, 0x000ff00000209400ULL,
0x0000009d009f7306ULL, 0x0004e20000205400ULL, 0x000000b9b700720bULL, 0x002fc40003fdd000ULL,
0x0000004900b77245ULL, 0x000fca000020d400ULL, 0x0000004a00827306ULL, 0x000322000000d400ULL,
0x0000009d009d7245ULL, 0x004fce000020d400ULL, 0x000000af00b87306ULL, 0x000fe20000209400ULL,
0x0000009f9e00720bULL, 0x008fe20003fbd000ULL, 0x00010000584a7824ULL, 0x002fe200078e00ffULL,
0x00000048009e7245ULL, 0x000fe4000020d400ULL, 0x0000a8003a487811ULL, 0x000fe400078e20ffULL,
0x000000019e9e3812ULL, 0x000fe200078efcffULL, 0x000000af00ba7306ULL, 0x0002a20000205400ULL,
0x0000000182822812ULL, 0x010fe400078efcffULL, 0x00000018ff4a7819ULL, 0x000fc6000001144aULL,
0x000000019d9d5812ULL, 0x000fe400078efcffULL, 0x0000005900b07306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fce000020d400ULL, 0x0000005900b17306ULL, 0x000e620000205400ULL,
0x000000bab800720bULL, 0x004fe20003f5d000ULL, 0x000100004db87824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fc800000114e9ULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x0000005800607306ULL, 0x000eac000000d400ULL, 0x00000001afaf2812ULL, 0x000fe400078efcffULL,
0x0000005a00987306ULL, 0x000fe20000009400ULL, 0x000000b1b000720bULL, 0x002fce0003f7d000ULL,
0x0000005a00997306ULL, 0x000e620000005400ULL, 0x0000000160606812ULL, 0x004fce00078efcffULL,
0x0000004900bd7306ULL, 0x000ff00000209400ULL, 0x0000004900be7306ULL, 0x000ea20000205400ULL,
0x000000999800720bULL, 0x002fe40003fdd000ULL, 0x0000005900997245ULL, 0x000fc4000020d400ULL,
0x0000004a00987245ULL, 0x000fe4000020d400ULL, 0x0000000199993812ULL, 0x000fe200078efcffULL,
0x000000a000a17306ULL, 0x000fe20000209400ULL, 0x0000009a9c00720bULL, 0x000fce0003f7d000ULL,
0x000000a000a27306ULL, 0x0002e20000205400ULL, 0x000000bebd00720bULL, 0x004fe20003f5d000ULL,
0x000001004cbe7824ULL, 0x040fe400078e00ffULL, 0x000100004cbd7824ULL, 0x000fe400078e00ffULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000005a006a7306ULL, 0x000ea2000000d400ULL,
0x000000a000a07245ULL, 0x002fe4000020d400ULL, 0x00000018ffbe7819ULL, 0x000fc400000114beULL,
0x00000018ffbd7819ULL, 0x000fe400000114bdULL, 0x00000001b7b72812ULL, 0x000fe200078efcffULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x000000a2a100720bULL, 0x008fce0003f9d000ULL,
0x000000a300a57306ULL, 0x0002e20000205400ULL, 0x000000016a6a6812ULL, 0x004fca00078efcffULL,
0x00000001a0a04812ULL, 0x000fe400078efcffULL, 0x0000004a004b7306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fe4000020d400ULL, 0x00000099a099723eULL, 0x000fca00000010ffULL,
0x0000004a00587306ULL, 0x000e620000205400ULL, 0x000000a5a400720bULL, 0x008fce0003fdd000ULL,
0x000000b500b67306ULL, 0x000fec0000209400ULL, 0x00000001a3a36812ULL, 0x000fe400078efcffULL,
0x000000b5005a7306ULL, 0x0004e20000205400ULL, 0x000000584b00720bULL, 0x002fe40003f5d000ULL,
0x000000004848783bULL, 0x000e6a0000000200ULL, 0x0000009200a67306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x004fca000020d400ULL, 0x0000000198982812ULL, 0x000fe400078efcffULL,
0x0000009200a77306ULL, 0x0005220000205400ULL, 0x0000005ab600720bULL, 0x008fe40003fbd000ULL,
0x000000989d98723eULL, 0x000fca00000010ffULL, 0x000000bb00bc7306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x004fca000020d400ULL, 0x00000001b5b55812ULL, 0x000fe400078efcffULL,
0x000000bb00c07306ULL, 0x0004e20000205400ULL, 0x000000a7a600720bULL, 0x010fce0003f7d000ULL,
0x0000009300a87306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x004fe2000020d400ULL,
0x0000007748489231ULL, 0x082fe400003400ffULL, 0x000000774a4a9231ULL, 0x000fe400003400ffULL,
0x0000000192923812ULL, 0x000fe200078efcffULL, 0x0000007849499231ULL, 0x080fe200003400ffULL,
0x0000009300a97306ULL, 0x0002a20000205400ULL, 0x000000c0bc00720bULL, 0x008fe20003f9d000ULL,
0x000000784b4b9231ULL, 0x000fcc00003400ffULL, 0x000000b200b37306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fe2000020d400ULL, 0x000000984818723cULL, 0x000fe80000041818ULL,
0x00000001bbbb4812ULL, 0x000fe400078efcffULL, 0x000000b200b47306ULL, 0x0002e20000205400ULL,
0x000000a9a800720bULL, 0x004fe40003fdd000ULL, 0x000000bba3c4723eULL, 0x000fca00000010ffULL,
0x000000c500c67306ULL, 0x000fe20000209400ULL, 0x000000b200b27245ULL, 0x002fca000020d400ULL,
0x0000000193936812ULL, 0x000fe400078efcffULL, 0x000000c500d87306ULL, 0x0002a20000205400ULL,
0x000000b4b300720bULL, 0x008fce0003f5d000ULL, 0x000000c100c27306ULL, 0x000fe20000209400ULL,
0x000000c500c57245ULL, 0x002fca000020d400ULL, 0x00000001b2b22812ULL, 0x000fe400078efcffULL,
0x000000c100b97306ULL, 0x0002e20000205400ULL, 0x000000d8c600720bULL, 0x004fe40003fbd000ULL,
0x000000979b00720bULL, 0x000fe40003f5d000ULL, 0x0000005b00977245ULL, 0x000fe4000020d400ULL,
0x0000006ab26a723eULL, 0x000fe200000010ffULL, 0x0000005d008e7306ULL, 0x000fe20000009400ULL,
0x000000c100c17245ULL, 0x002fca000020d400ULL, 0x00000001c5c55812ULL, 0x000fe400078efcffULL,
0x0000005d008c7306ULL, 0x000fe20000005400ULL, 0x000000b9c200720bULL, 0x008fe40003f7d000ULL,
0x0000000169692812ULL, 0x000fe400078efcffULL, 0x000000c592c5723eULL, 0x000fc600000010ffULL,
0x0000005d00687306ULL, 0x000fe8000000d400ULL, 0x000000c44820723cULL, 0x000fe40000041820ULL,
0x00000001c1c13812ULL, 0x000fe400078efcffULL, 0x0000005b005d7306ULL, 0x000ff00000209400ULL,
0x0000005b00dd7306ULL, 0x000e700000205400ULL, 0x0000004d00907306ULL, 0x000ff00000009400ULL,
0x0000004d00897306ULL, 0x000fe20000005400ULL, 0x000000dd5d00720bULL, 0x002fc40003f9d000ULL,
0x00000062c85d723eULL, 0x000fe400000010ffULL, 0x000000c9af62723eULL, 0x000fc600000010ffULL,
0x0000004d00737306ULL, 0x000fec000000d400ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x0000004e00677306ULL, 0x000fe20000009400ULL, 0x0000008c8e00720bULL, 0x000fce0003f9d000ULL,
0x0000004e00657306ULL, 0x000fec0000005400ULL, 0x0000000168684812ULL, 0x000fe400078efcffULL,
0x0000004e006e7306ULL, 0x000ff0000000d400ULL, 0x000000de004d7306ULL, 0x000ff00000209400ULL,
0x000000de004e7306ULL, 0x000e700000205400ULL, 0x000000dc00d37306ULL, 0x000ff00000209400ULL,
0x000000dc00ca7306ULL, 0x0004e20000205400ULL, 0x0000004e4d00720bULL, 0x002fc40003fdd000ULL,
0x00000086d24d723eULL, 0x000fca00000010ffULL, 0x0000005e00917306ULL, 0x000fe20000009400ULL,
0x000000dc00dc7245ULL, 0x004fce000020d400ULL, 0x0000005e008a7306ULL, 0x000e620000005400ULL,
0x000000cad300720bULL, 0x008fce0003fbd000ULL, 0x000000d9009f7306ULL, 0x000fec0000209400ULL,
0x00000001dcdc5812ULL, 0x000fe400078efcffULL, 0x000000d900597306ULL, 0x0004e20000205400ULL,
0x0000008a9100720bULL, 0x002fe40003f7d000ULL, 0x000000de008a7245ULL, 0x000fc8000020d400ULL,
0x000000018a8a6812ULL, 0x000fe200078efcffULL, 0x0000005e007a7306ULL, 0x000322000000d400ULL,
0x000000d900d97245ULL, 0x004fce000020d400ULL, 0x0000004c00887306ULL, 0x000fe20000009400ULL,
0x000100005e5e7824ULL, 0x002fe200078e00ffULL, 0x000000599f00720bULL, 0x008fe40003fdd000ULL,
0x000000d4c759723eULL, 0x000fe400000010ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000004c008d7306ULL, 0x000fe20000005400ULL, 0x000000017a7a3812ULL, 0x010fcc00078efcffULL,
0x00000001d9d96812ULL, 0x000fe200078efcffULL, 0x0000004c00727306ULL, 0x000ff0000000d400ULL,
0x000000ba00cb7306ULL, 0x000ff00000209400ULL, 0x000000ba004c7306ULL, 0x0002b00000205400ULL,
0x0000005f008f7306ULL, 0x000fe20000009400ULL, 0x000000ba00ba7245ULL, 0x002fce000020d400ULL,
0x0000005f008b7306ULL, 0x000e620000005400ULL, 0x0000004ccb00720bULL, 0x004fe40003fbd000ULL,
0x000000875c4c723eULL, 0x000fe400000010ffULL, 0x00000082cc5c723eULL, 0x000fe400000010ffULL,
0x0000005e00827245ULL, 0x000fe2000020d400ULL, 0x0000004f00807306ULL, 0x000fec0000009400ULL,
0x00000001baba5812ULL, 0x000fc400078efcffULL, 0x0000004f006b7306ULL, 0x000fe20000005400ULL,
0x0000008b8f00720bULL, 0x002fe40003f9d000ULL, 0x0000008d8800720bULL, 0x000fca0003fbd000ULL,
0x0000004f006f7306ULL, 0x000ff0000000d400ULL, 0x0000005e004f7306ULL, 0x000fe20000209400ULL,
0x0000000172725812ULL, 0x000fce00078efcffULL, 0x0000005e00587306ULL, 0x000e700000205400ULL,
0x0000006100857306ULL, 0x000ff00000209400ULL, 0x0000006100847306ULL, 0x000ea20000205400ULL,
0x000000584f00720bULL, 0x002fc40003fdd000ULL, 0x0000004c484c723cULL, 0x000fe20000041804ULL,
0x000000dadb58723eULL, 0x000fc800000010ffULL, 0x0000005f007b7306ULL, 0x0002e4000000d400ULL,
0x0000a80039047811ULL, 0x000fe200078e20ffULL, 0x000000584858723cULL, 0x000fe60000041808ULL,
0x0000000182826812ULL, 0x000fe400078efcffULL, 0x0000006600837306ULL, 0x000fe20000209400ULL,
0x000100005f5f7824ULL, 0x002fe200078e00ffULL, 0x000000848500720bULL, 0x004fe20003f7d000ULL,
0x000000000404783bULL, 0x000e620000000200ULL, 0x00000060b708723eULL, 0x000fc400000010ffULL,
0x00000018ff9a7819ULL, 0x000fe4000001145fULL, 0x0000006600637306ULL, 0x000ea20000205400ULL,
0x000000017b7b4812ULL, 0x008fe400078efcffULL, 0x000000649e09723eULL, 0x000fe400000010ffULL,
0x0000006600847245ULL, 0x000fc6000020d400ULL, 0x000000be008c7306ULL, 0x000ff00000209400ULL,
0x000000be008e7306ULL, 0x0007220000205400ULL, 0x000000638300720bULL, 0x004fe40003f9d000ULL,
0x0000006100837245ULL, 0x000fc4000020d400ULL, 0x000000c3ae63723eULL, 0x000fe400000010ffULL,
0x0000000183833812ULL, 0x000fe200078efcffULL, 0x0000009400957306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x008fc6000020d400ULL, 0x000000624860723cULL, 0x000fe40000041810ULL,
0x0000000184844812ULL, 0x000fe400078efcffULL, 0x0000009400967306ULL, 0x0004e20000205400ULL,
0x0000008e8c00720bULL, 0x010fe40003f7d000ULL, 0x0000006b8000720bULL, 0x000fe20003f9d000ULL,
0x0000007704049231ULL, 0x082fe200003400ffULL, 0x00000081b56b723eULL, 0x000fe200000010ffULL,
0x0000007706069231ULL, 0x000fe200003400ffULL, 0x0000007a8a10723eULL, 0x000fe200000010ffULL,
0x0000009a005f7306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x004fe2000020d400ULL,
0x0000007805059231ULL, 0x080fe200003400ffULL, 0x0000007bd911723eULL, 0x000fe200000010ffULL,
0x0000007807079231ULL, 0x000fc400003400ffULL, 0x00000001bebe3812ULL, 0x000fe400078efcffULL,
0x0000009a009b7306ULL, 0x0002a20000205400ULL, 0x000000969500720bULL, 0x008fe40003f5d000ULL,
0x000000016f6f4812ULL, 0x000fca00078efcffULL, 0x000000bf008b7306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fca000020d400ULL, 0x0000000194942812ULL, 0x000fe400078efcffULL,
0x000000bf00877306ULL, 0x0002e20000205400ULL, 0x0000009b5f00720bULL, 0x004fe40003fdd000ULL,
0x000000899000720bULL, 0x000fe20003f5d000ULL, 0x0000005c485c723cULL, 0x000fe8000004180cULL,
0x000000bd00867306ULL, 0x000fe20000209400ULL, 0x000000bf00bf7245ULL, 0x002fc4000020d400ULL,
0x000000dc930c723eULL, 0x000fe400000010ffULL, 0x000000ba940d723eULL, 0x000fe400000010ffULL,
0x000000019a9a6812ULL, 0x000fe200078efcffULL, 0x000000bd00857306ULL, 0x0002a20000205400ULL,
0x000000878b00720bULL, 0x008fe40003f7d000ULL, 0x000000656700720bULL, 0x000fe20003fdd000ULL,
0x0000000c040c723cULL, 0x000fe20000041858ULL, 0x0000000173732812ULL, 0x000fc600078efcffULL,
0x0000007d007f7306ULL, 0x000fe20000209400ULL, 0x000000bd00bd7245ULL, 0x002fc6000020d400ULL,
0x000000084864723cULL, 0x040fe40000041814ULL, 0x00000001bfbf3812ULL, 0x000fe400078efcffULL,
0x0000007d007e7306ULL, 0x0002e20000205400ULL, 0x000000858600720bULL, 0x004fe40003fbd000ULL,
0x000000699708723eULL, 0x000fe400000010ffULL, 0x00000068c109723eULL, 0x000fe400000010ffULL,
0x0000006a4868723cULL, 0x000fe2000004181cULL, 0x0000007600797306ULL, 0x000fe20000209400ULL,
0x0000007d007d7245ULL, 0x002fc4000020d400ULL, 0x000000016e6e6812ULL, 0x000fe400078efcffULL,
0x000000828314723eULL, 0x000fe400000010ffULL, 0x00000001bdbd5812ULL, 0x000fe200078efcffULL,
0x00000076007c7306ULL, 0x0002a20000205400ULL, 0x0000007e7f00720bULL, 0x008fe40003f7d000ULL,
0x000000b8001d7245ULL, 0x000fe4000020d400ULL, 0x0000009a8415723eULL, 0x000fc400000010ffULL,
0x00000072be48723eULL, 0x000fe200000010ffULL, 0x000000b8000a7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fe4000020d400ULL, 0x00000073bf49723eULL, 0x000fc600000010ffULL,
0x000000017d7d3812ULL, 0x000fe400078efcffULL, 0x000000b8000b7306ULL, 0x000e620000205400ULL,
0x0000007c7900720bULL, 0x004fe20003fbd000ULL, 0x000000480448723cULL, 0x000fec0000041864ULL,
0x000000ad00127306ULL, 0x000fec0000209400ULL, 0x0000000176765812ULL, 0x000fc400078efcffULL,
0x000000ad00137306ULL, 0x0004e20000205400ULL, 0x0000000b0a00720bULL, 0x002fe40003f5d000ULL,
0x000000080408723cULL, 0x000fea000004184cULL, 0x000000ac00167306ULL, 0x000fe20000209400ULL,
0x000000ad00ad7245ULL, 0x004fe4000020d400ULL, 0x000000aa004d7245ULL, 0x000fc6000020d400ULL,
0x000000011d1d2812ULL, 0x000fe400078efcffULL, 0x000000ac00177306ULL, 0x0002a20000205400ULL,
0x000000131200720bULL, 0x008fe40003f7d000ULL, 0x0000001d761d723eULL, 0x000fe200000010ffULL,
0x000000100410723cULL, 0x000fe8000004185cULL, 0x0000000000757306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fca000020d400ULL, 0x00000001adad3812ULL, 0x000fe400078efcffULL,
0x0000000000747306ULL, 0x0002e20000205400ULL, 0x000000171600720bULL, 0x004fe40003fbd000ULL,
0x0000006ead6e723eULL, 0x000fe200000010ffULL, 0x000000140414723cULL, 0x000fe80000041860ULL,
0x0000005700717306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x002fca000020d400ULL,
0x00000001acac5812ULL, 0x000fe400078efcffULL, 0x0000005700707306ULL, 0x0002a20000205400ULL,
0x000000747500720bULL, 0x008fe40003f5d000ULL, 0x0000006fac6f723eULL, 0x000fca00000010ffULL,
0x000000ab001c7306ULL, 0x000fe20000209400ULL, 0x0000005700577245ULL, 0x002fca000020d400ULL,
0x0000000100002812ULL, 0x000fe400078efcffULL, 0x000000ab001e7306ULL, 0x0002e20000205400ULL,
0x000000707100720bULL, 0x004fce0003f7d000ULL, 0x000000aa001f7306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fca000020d400ULL, 0x0000000157573812ULL, 0x000fe400078efcffULL,
0x000000aa004c7306ULL, 0x000e620000205400ULL, 0x0000001e1c00720bULL, 0x008fe40003fdd000ULL,
0x000000bd7d1c723eULL, 0x000fd600000010ffULL, 0x00000001abab6812ULL, 0x000fe400078efcffULL,
0x0000004c1f00720bULL, 0x002fe40003fbd000ULL, 0x000000ab004c723eULL, 0x000fe200000010ffULL,
0x0000001c041c723cULL, 0x040ff00000041818ULL, 0x0000006e0418723cULL, 0x000fe40000041868ULL,
0x000000014d4d5812ULL, 0x000fc800078efcffULL, 0x0000004d574d723eULL, 0x000fce00000010ffULL,
0x0000004c0404723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff207f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007844821ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000227305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000220000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008003007811ULL, 0x000fe200078e40ffULL,
0x00000100ff587424ULL, 0x000fe200078e00ffULL, 0x00000004ff577819ULL, 0x000fc4000001162dULL,
0x0000000024207217ULL, 0x000fe20007800000ULL, 0x000062002b4f7a24ULL, 0x000fc800078e0200ULL,
0x0000000120207824ULL, 0x000fe400078e0a00ULL, 0x0000000135217824ULL, 0x100fe400078e024fULL,
0x0000000130227824ULL, 0x100fe200078e024fULL, 0x0000002020007807ULL, 0x000fe20000000000ULL,
0x000000012f4c7824ULL, 0x000fe400078e024fULL, 0x00005e0021207625ULL, 0x000fe200078e0058ULL,
0x000000002c007217ULL, 0x000fc60007800000ULL, 0x00005e0022227625ULL, 0x000fe200078e0058ULL,
0x00000034204e7210ULL, 0x000fc60007f5e0ffULL, 0x00005e004c4c7625ULL, 0x000fe200078e0058ULL,
0x0000003422227210ULL, 0x000fc60007f9e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a2cULL,
0x000000344c4c7210ULL, 0x000fe20007fbe0ffULL, 0x000000012e207824ULL, 0x000fe400078e024fULL,
0x000000ffff4f7224ULL, 0x000fe200010e0621ULL, 0x000000005700720cULL, 0x000fe20003f46070ULL,
0x00005e0020207625ULL, 0x000fe200078e0058ULL, 0x000000003300720cULL, 0x000fc60003f66070ULL,
0x000000ffff237224ULL, 0x000fe200020e0623ULL, 0x000000003200720cULL, 0x080fe20003f86070ULL,
0x000000ffff4d7224ULL, 0x000fe200028e064dULL, 0x000000003100720cULL, 0x000fe40003fa6070ULL,
0x0000003420207210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004e457faeULL, 0x0003e4000d101c46ULL, 0x000000ffff217224ULL, 0x000fe400030e0621ULL,
0x0000000022467faeULL, 0x0003e8000d901c46ULL, 0x000000004c477faeULL, 0x0003e8000e101c46ULL,
0x0000000020507faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff207f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc4000784486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff577224ULL, 0x000fe200078e0021ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000784486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000207305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000200000735dULL, 0x004fe40003800000ULL,
0x0106b400ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fc4000784486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000026ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff637819ULL, 0x000fe4000001162dULL, 0x0000541000627816ULL, 0x000fe20000000000ULL,
0x00014fb27f007947ULL, 0x000fea000b800000ULL, 0x00001f63627f7589ULL, 0x0002a400000e0000ULL,
0x00014ff27f007947ULL, 0x000fea000b800000ULL, 0x00001f38627e7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff637224ULL, 0x002fe200078e0037ULL,
0x00008ea0005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x00015c3000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff637224ULL, 0x002fe200078e0036ULL,
0x00008f00005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x00015bd000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000554c783bULL, 0x000f680000004200ULL,
0x00000000515c783bULL, 0x000fe80000004200ULL, 0x000000005620783bULL, 0x000e680000004200ULL,
0x000000005258783bULL, 0x000ee20000004200ULL, 0x000100004cde7824ULL, 0x060fe200078e00ffULL,
0x0000004c00b17306ULL, 0x000fe20000009400ULL, 0x000001004ce07824ULL, 0x000fe200078e00ffULL,
0x00000018ffd17819ULL, 0x000fe2000001144cULL, 0x000100004dd87824ULL, 0x040fe200078e00ffULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x000001004ddb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x000100004ec97824ULL, 0x040fe200078e00ffULL,
0x0000004c00a77306ULL, 0x000f620000005400ULL, 0x00000018ffcc7819ULL, 0x000fe2000001144dULL,
0x000001004ecd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x0000010020bc7824ULL, 0x002fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x0000010022a17824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x000000de00e77306ULL, 0x000fe20000209400ULL, 0x00000018ffb77819ULL, 0x000fe2000001144eULL,
0x0000010023a07824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001145eULL,
0x000001004fc87824ULL, 0x040fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x000100004fc27824ULL, 0x000fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe2000001144fULL,
0x000000de00e87306ULL, 0x000e620000205400ULL, 0x000000a7b100720bULL, 0x020fe20003fdd000ULL,
0x000100005eb17824ULL, 0x000fe200078e00ffULL, 0x00000018ffbc7819ULL, 0x000fe200000114bcULL,
0x0001000022a27824ULL, 0x000fe200078e00ffULL, 0x00000018ffac7819ULL, 0x000fe20000011420ULL,
0x0001000023a57824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011421ULL,
0x000000d100d07306ULL, 0x000fe20000209400ULL, 0x00000018ffa17819ULL, 0x000fc400000114a1ULL,
0x00000018ffa07819ULL, 0x000fe400000114a0ULL, 0x00000018ff947819ULL, 0x000fe40000011422ULL,
0x00000018ff977819ULL, 0x000fe20000011423ULL, 0x000000d100d27306ULL, 0x000b220000205400ULL,
0x000000e8e700720bULL, 0x002fe20003f5d000ULL, 0x000001005de77824ULL, 0x040fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000100005de87824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fc4000001145cULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0000004d00d97306ULL, 0x000fe20000009400ULL, 0x000000d100d17245ULL, 0x020fe4000020d400ULL,
0x00000018ffa57819ULL, 0x000fe400000114a5ULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x00000018ff867819ULL, 0x000fe2000001145dULL, 0x0000004d00cf7306ULL, 0x000e620000005400ULL,
0x000000d2d000720bULL, 0x010fc40003fbd000ULL, 0x00000018ffd27819ULL, 0x000fe400000114e7ULL,
0x00000018ffb17819ULL, 0x000fe400000114b1ULL, 0x00000018ff767819ULL, 0x000fe2000001145fULL,
0x000000e000e57306ULL, 0x000fe20000209400ULL, 0x00000018ff6c7819ULL, 0x008fe40000011458ULL,
0x00000018ff657819ULL, 0x000fe40000011459ULL, 0x00000018ff607819ULL, 0x000fc4000001145aULL,
0x00000001d1d15812ULL, 0x000fe200078efcffULL, 0x000000e000e67306ULL, 0x000ee20000205400ULL,
0x000000cfd900720bULL, 0x002fe40003f7d000ULL, 0x000000de00cf7245ULL, 0x000fe4000020d400ULL,
0x00000018ff007819ULL, 0x004fe4000001145bULL, 0x00000001cfcf2812ULL, 0x000fe200078efcffULL,
0x0000004c00877306ULL, 0x0002b0000000d400ULL, 0x000000cc00d47306ULL, 0x000fe20000209400ULL,
0x000000e6e500720bULL, 0x008fe20003f9d000ULL, 0x000001005ee57824ULL, 0x000fc400078e00ffULL,
0x00000100214c7824ULL, 0x002fe400078e00ffULL, 0x000100005ce67824ULL, 0x000fe200078e00ffULL,
0x00000018ffe57819ULL, 0x000fe200000114e5ULL, 0x000000cc00d57306ULL, 0x0002e20000205400ULL,
0x0000000187876812ULL, 0x004fe400078efcffULL, 0x00000018ff4c7819ULL, 0x000fca000001144cULL,
0x000000d800e27306ULL, 0x000fe20000209400ULL, 0x000000cc00cc7245ULL, 0x002fce000020d400ULL,
0x000000d800e17306ULL, 0x000e620000205400ULL, 0x000000d5d400720bULL, 0x008fe40003f5d000ULL,
0x000000db00d47245ULL, 0x000fca000020d400ULL, 0x0000004e00d37306ULL, 0x000fec0000009400ULL,
0x00000001cccc2812ULL, 0x000fe400078efcffULL, 0x0000004e00d67306ULL, 0x000ea20000005400ULL,
0x000000e1e200720bULL, 0x002fce0003fdd000ULL, 0x000000db00e37306ULL, 0x000ff00000209400ULL,
0x000000db00e47306ULL, 0x000fe20000205400ULL, 0x000000d6d300720bULL, 0x004fe40003fbd000ULL,
0x000000d800d37245ULL, 0x000fc8000020d400ULL, 0x00000001d3d36812ULL, 0x000fe200078efcffULL,
0x0000004f00c67306ULL, 0x000fe60000009400ULL, 0x000000d3ccd3723eULL, 0x000fca00000010ffULL,
0x0000004f00c77306ULL, 0x000e700000005400ULL, 0x000000c900ce7306ULL, 0x000ff00000209400ULL,
0x000000c900d77306ULL, 0x0004e20000205400ULL, 0x000000c7c600720bULL, 0x002fc40003fdd000ULL,
0x00000018ffc67819ULL, 0x000fca00000114e6ULL, 0x0000005e00927306ULL, 0x000fe20000009400ULL,
0x000000c900c97245ULL, 0x004fce000020d400ULL, 0x0000005e00887306ULL, 0x000fe20000005400ULL,
0x000000d7ce00720bULL, 0x008fce0003f5d000ULL, 0x0000005e006a7306ULL, 0x0003ec000000d400ULL,
0x00000001c9c92812ULL, 0x000fe400078efcffULL, 0x0000004e00827306ULL, 0x000ea2000000d400ULL,
0x000000e0005e7245ULL, 0x002fc8000020d400ULL, 0x000000015e5e4812ULL, 0x000fe400078efcffULL,
0x000000e4e300720bULL, 0x000fe20003f9d000ULL, 0x000000b700ba7306ULL, 0x000ff00000209400ULL,
0x000000b700bb7306ULL, 0x0002e20000205400ULL, 0x0000000182825812ULL, 0x004fc600078efcffULL,
0x00000001d4d44812ULL, 0x000fc800078efcffULL, 0x000000cd00dc7306ULL, 0x000fe20000209400ULL,
0x000000b700b77245ULL, 0x002fce000020d400ULL, 0x000000cd00dd7306ULL, 0x0002a20000205400ULL,
0x000000bbba00720bULL, 0x008fce0003fbd000ULL, 0x0000004f007d7306ULL, 0x000ee2000000d400ULL,
0x000000cd00cd7245ULL, 0x002fca000020d400ULL, 0x00000001b7b75812ULL, 0x000fe400078efcffULL,
0x000000b400b57306ULL, 0x000fe20000209400ULL, 0x000000dddc00720bULL, 0x004fce0003f9d000ULL,
0x000000b400b67306ULL, 0x0002a20000205400ULL, 0x000000017d7d6812ULL, 0x008fca00078efcffULL,
0x00000001cdcd4812ULL, 0x000fe400078efcffULL, 0x000000bc00c37306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x002fe4000020d400ULL, 0x00000082cd82723eULL, 0x000fca00000010ffULL,
0x000000bc00c47306ULL, 0x0002e20000205400ULL, 0x000000b6b500720bULL, 0x004fe40003fdd000ULL,
0x00000018ffb57819ULL, 0x000fca00000114e8ULL, 0x0000002000b87306ULL, 0x000fe20000009400ULL,
0x000000bc00bc7245ULL, 0x002fca000020d400ULL, 0x00000001b4b46812ULL, 0x000fe400078efcffULL,
0x0000002000b97306ULL, 0x000e620000005400ULL, 0x000000c4c300720bULL, 0x008fce0003f5d000ULL,
0x00000020007b7306ULL, 0x0004ec000000d400ULL, 0x00000001bcbc2812ULL, 0x000fe400078efcffULL,
0x0000004c00c07306ULL, 0x000fe20000209400ULL, 0x0001000020207824ULL, 0x004fe200078e00ffULL,
0x000000b9b800720bULL, 0x002fc80003f9d000ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000004c00c57306ULL, 0x000e6e0000205400ULL, 0x000000017b7b4812ULL, 0x008fe200078efcffULL,
0x0000002100b37306ULL, 0x000ff00000009400ULL, 0x0000002100b27306ULL, 0x000fe20000005400ULL,
0x000000c5c000720bULL, 0x002fe20003fbd000ULL, 0x0001000059c07824ULL, 0x000fca00078e00ffULL,
0x00000018ffc07819ULL, 0x000fe200000114c0ULL, 0x00000021007a7306ULL, 0x0003f0000000d400ULL,
0x000000ac00b07306ULL, 0x000fe20000209400ULL, 0x0001000021217824ULL, 0x002fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x000000ac00af7306ULL, 0x0002b00000205400ULL,
0x0000002000bd7306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x002fce000020d400ULL,
0x0000002000c17306ULL, 0x000e620000205400ULL, 0x000000afb000720bULL, 0x004fe20003f5d000ULL,
0x000001005ab07824ULL, 0x000fe200078e00ffULL, 0x0000004c00af7245ULL, 0x000fe4000020d400ULL,
0x0000a800534c7811ULL, 0x000fe400078e20ffULL, 0x00000001afaf5812ULL, 0x000fe200078efcffULL,
0x0000002100be7306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fca00000114b0ULL,
0x00000001acac2812ULL, 0x000fe400078efcffULL, 0x0000002100bf7306ULL, 0x000ea20000205400ULL,
0x000000c1bd00720bULL, 0x002fce0003fdd000ULL, 0x0000002200ad7306ULL, 0x000ff00000009400ULL,
0x0000002200ae7306ULL, 0x000e620000005400ULL, 0x000000bfbe00720bULL, 0x004fe20003fbd000ULL,
0x0000010058be7824ULL, 0x000fc400078e00ffULL, 0x0000010059bf7824ULL, 0x000fc800078e00ffULL,
0x0000009f00ab7306ULL, 0x000ff00000209400ULL, 0x0000009f00a97306ULL, 0x000ea20000205400ULL,
0x000000aead00720bULL, 0x002fe40003f9d000ULL, 0x0000002000ad7245ULL, 0x000fc4000020d400ULL,
0x0000a80054207811ULL, 0x000fe400078e20ffULL, 0x00000001adad6812ULL, 0x000fe200078efcffULL,
0x0000004d00857306ULL, 0x000e66000000d400ULL, 0x000000adacac723eULL, 0x000fca00000010ffULL,
0x0000002200777306ULL, 0x000ee2000000d400ULL, 0x000000a9ab00720bULL, 0x004fe40003fdd000ULL,
0x0000002100a97245ULL, 0x000fe4000020d400ULL, 0x0000009f00ab7245ULL, 0x000fe2000020d400ULL,
0x000100005b9f7824ULL, 0x000fe200078e00ffULL, 0x00000001a9a95812ULL, 0x000fe200078efcffULL,
0x000000a1004d7306ULL, 0x000fe20000209400ULL, 0x0000000185853812ULL, 0x002fe400078efcffULL,
0x00000018ff9f7819ULL, 0x000fc6000001149fULL, 0x00000001abab6812ULL, 0x000fe400078efcffULL,
0x000000a1004e7306ULL, 0x0002a20000205400ULL, 0x0000000177774812ULL, 0x008fe400078efcffULL,
0x000000a9abad723eULL, 0x000fca00000010ffULL, 0x000000a0004f7306ULL, 0x000fe20000209400ULL,
0x000000a100a17245ULL, 0x002fce000020d400ULL, 0x000000a000227306ULL, 0x0002e20000205400ULL,
0x0000004e4d00720bULL, 0x004fce0003f5d000ULL, 0x0000002300a87306ULL, 0x000fe20000009400ULL,
0x000000a000a07245ULL, 0x002fca000020d400ULL, 0x00000001a1a12812ULL, 0x000fe400078efcffULL,
0x0000002300aa7306ULL, 0x000fe20000005400ULL, 0x000000224f00720bULL, 0x008fe40003fbd000ULL,
0x000000004c4c783bULL, 0x000e6a0000000200ULL, 0x0000002300717306ULL, 0x0005ec000000d400ULL,
0x00000001a0a05812ULL, 0x000fc400078efcffULL, 0x0000005c008d7306ULL, 0x000fe20000009400ULL,
0x000001005c237824ULL, 0x004fce00078e00ffULL, 0x0000005c00937306ULL, 0x000ff00000005400ULL,
0x0000005c00707306ULL, 0x0005f0000000d400ULL, 0x000000c800da7306ULL, 0x000fe20000209400ULL,
0x00000018ff5c7819ULL, 0x004fe20000011423ULL, 0x000001005f237824ULL, 0x000fe200078e00ffULL,
0x0000007f4c4c9231ULL, 0x002fc400003400ffULL, 0x0000007f4e4e9231ULL, 0x000fe400003400ffULL,
0x00000018ffba7819ULL, 0x000fe20000011423ULL, 0x000000c800df7306ULL, 0x0002a20000205400ULL,
0x000000002020783bULL, 0x000ee20000000200ULL, 0x0000007e4d4d9231ULL, 0x080fe400003400ffULL,
0x0000007e4f4f9231ULL, 0x000fc800003400ffULL, 0x000000c200ca7306ULL, 0x000fe20000209400ULL,
0x000000c800c87245ULL, 0x002fce000020d400ULL, 0x000000c200cb7306ULL, 0x0003220000205400ULL,
0x000000dfda00720bULL, 0x004fce0003f7d000ULL, 0x000000c600c77306ULL, 0x000fe20000209400ULL,
0x000000c200c27245ULL, 0x002fca000020d400ULL, 0x00000001c8c83812ULL, 0x000fe400078efcffULL,
0x000000cbca00720bULL, 0x010fe20003f7d000ULL, 0x000000c600b87306ULL, 0x0002b00000205400ULL,
0x0000009400957306ULL, 0x000fe20000209400ULL, 0x0000007f20209231ULL, 0x088fe200003400ffULL,
0x000000c600c67245ULL, 0x002fe2000020d400ULL, 0x0000007f22229231ULL, 0x000fe200003400ffULL,
0x00000001c2c23812ULL, 0x000fe200078efcffULL, 0x0000007e21219231ULL, 0x080fe200003400ffULL,
0x000000b2b300720bULL, 0x000fe20003f7d000ULL, 0x0000007e23239231ULL, 0x000fe200003400ffULL,
0x0000009400967306ULL, 0x0002e20000205400ULL, 0x000000b8c700720bULL, 0x004fc40003f3d000ULL,
0x000000d2007e7245ULL, 0x000fca000020d400ULL, 0x000000e500b37306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fe4000020d400ULL, 0x000000017a7a3812ULL, 0x000fe400078efcffULL,
0x000000aaa800720bULL, 0x000fe20003f7d000ULL, 0x000100005aa87824ULL, 0x000fe200078e00ffULL,
0x00000001c6c61812ULL, 0x000fe200078efcffULL, 0x000000e500ae7306ULL, 0x0002a20000205400ULL,
0x000000969500720bULL, 0x008fe20003fdd000ULL, 0x000001005baa7824ULL, 0x000fe200078e00ffULL,
0x0000007aafaf723eULL, 0x000fc400000010ffULL, 0x00000018ffa87819ULL, 0x000fe400000114a8ULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000a500a67306ULL, 0x000fe20000209400ULL,
0x000000e500e57245ULL, 0x002fe4000020d400ULL, 0x0000000171713812ULL, 0x000fe400078efcffULL,
0x000000938d00720bULL, 0x000fe40003f7d000ULL, 0x0000000194946812ULL, 0x000fe200078efcffULL,
0x000000a500a77306ULL, 0x0002e20000205400ULL, 0x000000aeb300720bULL, 0x004fc40003f3d000ULL,
0x000000889200720bULL, 0x000fe40003fdd000ULL, 0x00000018ff887819ULL, 0x000fe400000114beULL,
0x0000007bbcae723eULL, 0x000fe200000010ffULL, 0x000000a200a37306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x002fe4000020d400ULL, 0x0000000170703812ULL, 0x000fc600078efcffULL,
0x00000001e5e51812ULL, 0x000fe400078efcffULL, 0x000000a200a47306ULL, 0x0002a20000205400ULL,
0x000000a7a600720bULL, 0x008fe40003fbd000ULL, 0x000000016a6a6812ULL, 0x000fc800078efcffULL,
0x0000006ae56a723eULL, 0x000fe200000010ffULL, 0x0000009700987306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x002fca000020d400ULL, 0x00000001a5a55812ULL, 0x000fe400078efcffULL,
0x0000009700997306ULL, 0x0002e20000205400ULL, 0x000000a4a300720bULL, 0x004fce0003f5d000ULL,
0x000000ba00bb7306ULL, 0x000fe20000209400ULL, 0x0000009700977245ULL, 0x002fca000020d400ULL,
0x00000001a2a22812ULL, 0x000fe400078efcffULL, 0x000000ba00bd7306ULL, 0x0002a20000205400ULL,
0x000000999800720bULL, 0x008fe40003f9d000ULL, 0x000000a29494723eULL, 0x000fca00000010ffULL,
0x0000005d008e7306ULL, 0x000fe20000009400ULL, 0x000000ba00ba7245ULL, 0x002fca000020d400ULL,
0x0000000197974812ULL, 0x000fe400078efcffULL, 0x0000005d008b7306ULL, 0x000e620000005400ULL,
0x000000bdbb00720bULL, 0x004fce0003f3d000ULL, 0x0000005d006d7306ULL, 0x000eac000000d400ULL,
0x00000001baba1812ULL, 0x000fe400078efcffULL, 0x0000005c005d7306ULL, 0x000fe20000209400ULL,
0x0000008b8e00720bULL, 0x002fe40003f5d000ULL, 0x00000018ff8b7819ULL, 0x000fca00000114bfULL,
0x0000005c00d07306ULL, 0x000e6c0000205400ULL, 0x000000016d6d2812ULL, 0x004fe400078efcffULL,
0x0000007c00817306ULL, 0x000ff00000209400ULL, 0x0000007c00807306ULL, 0x0004e20000205400ULL,
0x000000d05d00720bULL, 0x002fc40003fbd000ULL, 0x000000c2b45d723eULL, 0x000fca00000010ffULL,
0x000000d200d57306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x004fce000020d400ULL,
0x000000d200d67306ULL, 0x0002a20000205400ULL, 0x000000808100720bULL, 0x008fce0003fdd000ULL,
0x000000b100b97306ULL, 0x000fe20000209400ULL, 0x000000cfd1d2723eULL, 0x002fca00000010ffULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x000000b100967306ULL, 0x0002e20000205400ULL,
0x000000d6d500720bULL, 0x004fce0003f9d000ULL, 0x0000005f00897306ULL, 0x000fe20000009400ULL,
0x000000b100b17245ULL, 0x002fca000020d400ULL, 0x000000017e7e4812ULL, 0x000fe400078efcffULL,
0x0000005f008f7306ULL, 0x000e620000005400ULL, 0x00000096b900720bULL, 0x008fce0003f3d000ULL,
0x0000009a009b7306ULL, 0x000fec0000209400ULL, 0x00000001b1b11812ULL, 0x000fe400078efcffULL,
0x0000009a009c7306ULL, 0x0005e20000205400ULL, 0x0000008f8900720bULL, 0x002fe40003f7d000ULL,
0x000000b17c7c723eULL, 0x000fca00000010ffULL, 0x0000005f006b7306ULL, 0x0002e2000000d400ULL,
0x0000009a009a7245ULL, 0x004fce000020d400ULL, 0x00000086009d7306ULL, 0x000fe20000209400ULL,
0x000100005f5f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff957819ULL, 0x000fe4000001145fULL,
0x00000086009e7306ULL, 0x000e620000205400ULL, 0x0000005c005f7245ULL, 0x000fe4000020d400ULL,
0x000000016b6b3812ULL, 0x008fe400078efcffULL, 0x000000015f5f5812ULL, 0x000fe400078efcffULL,
0x0000009c9b00720bULL, 0x000fe20003fbd000ULL, 0x0000007600797306ULL, 0x000fe20000209400ULL,
0x00000086009b7245ULL, 0x000fc4000020d400ULL, 0x000000c9b75c723eULL, 0x000fe400000010ffULL,
0x000000705f70723eULL, 0x000fe400000010ffULL, 0x0000006bba6b723eULL, 0x000fe200000010ffULL,
0x0000007600787306ULL, 0x0004e20000205400ULL, 0x0000009e9d00720bULL, 0x002fc60003f5d000ULL,
0x000000019a9a5812ULL, 0x000fc800078efcffULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x004fe4000020d400ULL, 0x000000c69a9a723eULL, 0x000fc600000010ffULL,
0x000000019b9b2812ULL, 0x000fe400078efcffULL, 0x000000b500b27306ULL, 0x0002a20000205400ULL,
0x000000787900720bULL, 0x008fce0003f3d000ULL, 0x0000008800927306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x002fca000020d400ULL, 0x0000000176761812ULL, 0x000fe400078efcffULL,
0x0000008800937306ULL, 0x0002e20000205400ULL, 0x000000b2b600720bULL, 0x004fce0003f9d000ULL,
0x00000095008d7306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fca000020d400ULL,
0x00000001b5b54812ULL, 0x000fe400078efcffULL, 0x00000095008e7306ULL, 0x000e620000205400ULL,
0x000000939200720bULL, 0x008fe40003fdd000ULL, 0x000000b59b9b723eULL, 0x000fca00000010ffULL,
0x00000058008c7306ULL, 0x000fec0000009400ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x0000005800907306ULL, 0x000ea20000005400ULL, 0x0000008e8d00720bULL, 0x002fce0003f7d000ULL,
0x0000005800677306ULL, 0x0002f0000000d400ULL, 0x0000005a00847306ULL, 0x000fe20000009400ULL,
0x0001000058587824ULL, 0x002fe200078e00ffULL, 0x000000908c00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff7f7819ULL, 0x000fe40000011458ULL, 0x0000005a00837306ULL, 0x000e620000005400ULL,
0x000000875e58723eULL, 0x000fcc00000010ffULL, 0x0000000167675812ULL, 0x008fe200078efcffULL,
0x00000059008a7306ULL, 0x000fe60000009400ULL, 0x000000678888723eULL, 0x000fca00000010ffULL,
0x0000005900917306ULL, 0x000ea20000005400ULL, 0x000000838400720bULL, 0x002fe40003f5d000ULL,
0x0000007dc883723eULL, 0x000fe400000010ffULL, 0x00000095007d7245ULL, 0x000fe4000020d400ULL,
0x000000a59795723eULL, 0x000fe200000010ffULL, 0x0000005900637306ULL, 0x0002e2000000d400ULL,
0x000000017d7d3812ULL, 0x000fc800078efcffULL, 0x0000007d767d723eULL, 0x000fc600000010ffULL,
0x0000006c00727306ULL, 0x000fe20000209400ULL, 0x00000085d459723eULL, 0x002fe400000010ffULL,
0x000000918a00720bULL, 0x004fca0003f9d000ULL, 0x0000006c00737306ULL, 0x0002b00000205400ULL,
0x0000008b00897306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fe4000020d400ULL,
0x0000000163634812ULL, 0x008fca00078efcffULL, 0x0000008b008f7306ULL, 0x000e620000205400ULL,
0x000000737200720bULL, 0x004fce0003f3d000ULL, 0x0000005a00627306ULL, 0x000eac000000d400ULL,
0x000000016c6c1812ULL, 0x000fe400078efcffULL, 0x0000005b00757306ULL, 0x000fe20000009400ULL,
0x0000008f8900720bULL, 0x002fe40003fdd000ULL, 0x0000008b00897245ULL, 0x000fca000020d400ULL,
0x0000005b00747306ULL, 0x000e620000005400ULL, 0x0000000162622812ULL, 0x004fca00078efcffULL,
0x0000000189896812ULL, 0x000fe400078efcffULL, 0x0000005b00617306ULL, 0x0004e4000000d400ULL,
0x000000638989723eULL, 0x000fe400000010ffULL, 0x000000aa00637245ULL, 0x000fc8000020d400ULL,
0x00000065006f7306ULL, 0x000fe20000209400ULL, 0x000000584c58723cULL, 0x004fe20000041808ULL,
0x000000747500720bULL, 0x002fcc0003f7d000ULL, 0x00000065006e7306ULL, 0x0002a20000205400ULL,
0x000000d24c08723cULL, 0x040fec000004180cULL, 0x0000000161613812ULL, 0x008fe200078efcffULL,
0x0000007f005e7306ULL, 0x000fe20000209400ULL, 0x000000824c0c723cULL, 0x000fe20000041810ULL,
0x0000006500657245ULL, 0x002fcc000020d400ULL, 0x0000007f00847306ULL, 0x000e620000205400ULL,
0x0000005c4c10723cULL, 0x000fe20000041814ULL, 0x0000006e6f00720bULL, 0x004fcc0003fbd000ULL,
0x000000c000807306ULL, 0x000fe20000209400ULL, 0x00000077a15c723eULL, 0x000fe200000010ffULL,
0x000000ae4c14723cULL, 0x040fe20000041848ULL, 0x00000071a05d723eULL, 0x000fe400000010ffULL,
0x0000006d7e71723eULL, 0x000fe400000010ffULL, 0x0000000165655812ULL, 0x000fe200078efcffULL,
0x000000c000817306ULL, 0x000ea20000205400ULL, 0x000000845e00720bULL, 0x002fe20003fdd000ULL,
0x000000ac4c48723cULL, 0x000fe2000004181cULL, 0x0000007f007f7245ULL, 0x000fca000020d400ULL,
0x000000b0007a7306ULL, 0x000fe40000209400ULL, 0x0000005c4c1c723cULL, 0x040fe80000041818ULL,
0x000000017f7f6812ULL, 0x000fe400078efcffULL, 0x000000b000787306ULL, 0x0002e20000205400ULL,
0x000000818000720bULL, 0x004fe20003f9d000ULL, 0x000000944c4c723cULL, 0x000fe20000041804ULL,
0x000000c000197245ULL, 0x000fca000020d400ULL, 0x000000aa00747306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fe2000020d400ULL, 0x000000702004723cULL, 0x040fe80000041858ULL,
0x0000000119194812ULL, 0x000fe400078efcffULL, 0x000000aa00727306ULL, 0x000e620000205400ULL,
0x000000787a00720bULL, 0x008fe20003f3d000ULL, 0x0000009a2008723cULL, 0x000fe20000041808ULL,
0x000000196519723eULL, 0x000fca00000010ffULL, 0x0000006000687306ULL, 0x000fe40000209400ULL,
0x0000006a200c723cULL, 0x040fe8000004180cULL, 0x00000001b0b01812ULL, 0x000fe400078efcffULL,
0x0000006000697306ULL, 0x0004e20000205400ULL, 0x000000727400720bULL, 0x002fe20003fbd000ULL,
0x0000007c2010723cULL, 0x000fe20000041810ULL, 0x00000062b062723eULL, 0x000fca00000010ffULL,
0x0000000000647306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x004fe2000020d400ULL,
0x000000882014723cULL, 0x000fe80000041814ULL, 0x0000000163635812ULL, 0x000fe400078efcffULL,
0x0000000000667306ULL, 0x0002a20000205400ULL, 0x000000696800720bULL, 0x008fe40003fdd000ULL,
0x000000616363723eULL, 0x000fc400000010ffULL, 0x0000009f00617245ULL, 0x000fc6000020d400ULL,
0x000000a800187306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x002fe2000020d400ULL,
0x00000062201c723cULL, 0x000fe8000004181cULL, 0x0000000160606812ULL, 0x000fe400078efcffULL,
0x000000a8001a7306ULL, 0x0002e20000205400ULL, 0x000000666400720bULL, 0x004fce0003f9d000ULL,
0x0000009f001b7306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x0000000100004812ULL, 0x000fe400078efcffULL, 0x0000009f00587306ULL, 0x000e620000205400ULL,
0x0000001a1800720bULL, 0x008fe40003f3d000ULL, 0x0000007f6c18723eULL, 0x000fd600000010ffULL,
0x00000001a8a81812ULL, 0x000fe400078efcffULL, 0x000000581b00720bULL, 0x002fe40003f5d000ULL,
0x000000a86060723eULL, 0x000fe200000010ffULL, 0x000000182018723cULL, 0x000ff40000041848ULL,
0x0000000161612812ULL, 0x000fc800078efcffULL, 0x000000610061723eULL, 0x000fce00000010ffULL,
0x000000602020723cULL, 0x000fe2000004184cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff487f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008003007811ULL, 0x000fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff487224ULL, 0x002fe400078e0049ULL,
0x000000002400720cULL, 0x000fda0003f24070ULL, 0x00009b5000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824848ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000497305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000490000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff497984ULL, 0x000e640000000800ULL,
0x8000000049ff7812ULL, 0x002fc40007824848ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000a003007811ULL, 0x000fe200078e40ffULL, 0x00000100ff587424ULL, 0x000fe200078e00ffULL,
0x00000004ff4d7819ULL, 0x000fe4000001162dULL, 0x0000000024487217ULL, 0x000fe20007800000ULL,
0x000062002b4c7a24ULL, 0x000fc800078e0200ULL, 0x0000000148487824ULL, 0x000fe400078e0a00ULL,
0x0000000135497824ULL, 0x100fe400078e024cULL, 0x00000001304a7824ULL, 0x000fe200078e024cULL,
0x0000002048007807ULL, 0x000fe20000000000ULL, 0x00005e0049487625ULL, 0x000fc600078e0058ULL,
0x000000002c007217ULL, 0x000fe20007800000ULL, 0x00005e004a4a7625ULL, 0x000fe200078e0058ULL,
0x00000034484e7210ULL, 0x000fc60007f3e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a2cULL,
0x000000344a4a7210ULL, 0x000fe20007f7e0ffULL, 0x000000012f487824ULL, 0x100fe400078e024cULL,
0x000000012e4c7824ULL, 0x000fe200078e024cULL, 0x000000004d00720cULL, 0x080fe20003f46070ULL,
0x000000ffff4f7224ULL, 0x000fe200008e0649ULL, 0x000000003300720cULL, 0x000fe20003f26070ULL,
0x00005e0048487625ULL, 0x000fe200078e0058ULL, 0x000000003100720cULL, 0x000fc60003f86070ULL,
0x00005e004c4c7625ULL, 0x000fe200078e0058ULL, 0x0000003448487210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e064bULL, 0x000000003200720cULL, 0x000fe20003f66070ULL,
0x000000ffff497224ULL, 0x000fe200028e0649ULL, 0x000000344c4c7210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e447faeULL, 0x0003e8000d101c46ULL,
0x000000ffff4d7224ULL, 0x000fe200030e064dULL, 0x000000004a437faeULL, 0x0003ea000c901c46ULL,
0x0000000048427faeULL, 0x0003e8000d901c46ULL, 0x000000004c417faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff6c7f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010648002c487f8cULL, 0x002fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc60007844857ULL,
0x01064c002c4a7984ULL, 0x000e640000000800ULL, 0x800000004aff7812ULL, 0x002fe40007824849ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x00000000004a7305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x0000004a0000735dULL, 0x008fe40003800000ULL, 0x01064c002c4a7984ULL, 0x000e640000000800ULL,
0x800000004aff7812ULL, 0x002fc40007824849ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01010000404a7984ULL, 0x000e680000000800ULL, 0x01030000404b7984ULL, 0x0007220000000800ULL,
0x0000002a4a00720bULL, 0x002fe20003f3d000ULL, 0x00012bd27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff004c7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ffc57424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000022500780cULL, 0x000fe40003f65270ULL,
0x0000002a4a00720bULL, 0x000fe20003f34000ULL, 0x00012b927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x0000004a2a487209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x800000482a497221ULL, 0x000fe20000010000ULL,
0x010500484000b388ULL, 0x0003e20000000800ULL, 0x000000004cff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b49497820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fca000001162dULL,
0x0000004900497308ULL, 0x000ee40000000800ULL, 0x0000004929297220ULL, 0x008fe20000410000ULL,
0x00012b227f007947ULL, 0x000fea000b800000ULL, 0x00001f0049007589ULL, 0x0022e400000e0000ULL,
0x0000000004047220ULL, 0x08cfe20000410000ULL, 0x0000000005057220ULL, 0x080fe20000410000ULL,
0x0000000008087220ULL, 0x080fe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x000fe20000410000ULL,
0x00012a727f007947ULL, 0x000fea000b800000ULL, 0x00001f3849007589ULL, 0x0004e400000e0000ULL,
0x0000004a2a2a7209ULL, 0x000fe20007810000ULL, 0x0000000006067220ULL, 0x08cfe20000410000ULL,
0x00000001ffc57807ULL, 0x000fe20000800000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x8000002a4a4a1221ULL, 0x000fe20000010000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b4a4a1820ULL, 0x000fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000004a00261308ULL, 0x000ea20000000800ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x000fe20000410000ULL, 0x0000004b264b1220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000294b297221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc40007824857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000487305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000480000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff487984ULL, 0x000ee40000000800ULL, 0x8000000048ff7812ULL, 0x008fe40007824857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000026ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff637819ULL, 0x000fc4000001162dULL, 0x0000541000627816ULL, 0x000fe20000000000ULL,
0x000128227f007947ULL, 0x000fea000b800000ULL, 0x00001f6362777589ULL, 0x00072400000e0000ULL,
0x000128627f007947ULL, 0x000fea000b800000ULL, 0x00001f3862787589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff637224ULL, 0x008fe200078e0037ULL,
0x0000b860005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x0001327000007944ULL, 0x016fea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff637224ULL, 0x008fe200078e0036ULL,
0x0000b8c0005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x0001321000007944ULL, 0x016fea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003e48783bULL, 0x002e620000004200ULL,
0x00009910c5c67816ULL, 0x000fc600000000ffULL, 0x000000003d58783bULL, 0x000f680000004200ULL,
0x000000003c5c783bULL, 0x000f280000004200ULL, 0x000000003b4c783bULL, 0x000ee20000004200ULL,
0x0001000048e17824ULL, 0x042fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe20000011448ULL,
0x0000010048e27824ULL, 0x000fe200078e00ffULL, 0x0000004900e07306ULL, 0x000fe20000009400ULL,
0x00000018ffc77819ULL, 0x000fe20000011449ULL, 0x000001004bc87824ULL, 0x000fe200078e00ffULL,
0x00000018ffe17819ULL, 0x000fe200000114e1ULL, 0x0001000049d47824ULL, 0x040fe200078e00ffULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x0000010049df7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000000e100e97306ULL, 0x000fe20000209400ULL,
0x00000018ffd47819ULL, 0x000fe200000114d4ULL, 0x000100004ac97824ULL, 0x040fe200078e00ffULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x000001005bb57824ULL, 0x020fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe2000001145bULL, 0x000100004bc37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x000000e100e87306ULL, 0x000e620000205400ULL,
0x000001004acc7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x010fe2000001145cULL,
0x000100005abb7824ULL, 0x040fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x000001005ab27824ULL, 0x000fe200078e00ffULL, 0x00000018ffcc7819ULL, 0x000fc400000114ccULL,
0x0000004900dc7306ULL, 0x000f220000005400ULL, 0x00000018ffaa7819ULL, 0x000fe4000001144bULL,
0x00000018ff9d7819ULL, 0x000fe40000011458ULL, 0x00000018ffa07819ULL, 0x000fe40000011459ULL,
0x00000018ffaf7819ULL, 0x000fe2000001144aULL, 0x0000004800d87306ULL, 0x000fe20000009400ULL,
0x000000e8e900720bULL, 0x002fe20003fbd000ULL, 0x000001005de87824ULL, 0x040fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe2000001145aULL, 0x000100005de97824ULL, 0x000fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fc400000114b5ULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0000004800d97306ULL, 0x000e620000005400ULL, 0x000000dce000720bULL, 0x010fe40003f7d000ULL,
0x00000018ffb27819ULL, 0x000fe400000114b2ULL, 0x00000018ff947819ULL, 0x000fe4000001145dULL,
0x00000018ff767819ULL, 0x008fe2000001144dULL, 0x000000db00da7306ULL, 0x000fe20000209400ULL,
0x00000018ff007819ULL, 0x004fc4000001144eULL, 0x00000018ff617819ULL, 0x000fe4000001145eULL,
0x00000018ff7d7819ULL, 0x000fe4000001144cULL, 0x00000018ff577819ULL, 0x000fe2000001144fULL,
0x000000db00dd7306ULL, 0x0004e20000205400ULL, 0x000000d9d800720bULL, 0x002fe20003f9d000ULL,
0x000001005fd97824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fc8000001145fULL,
0x00000018ffd97819ULL, 0x000fe200000114d9ULL, 0x000000e200de7306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x004fce000020d400ULL, 0x000000e200e77306ULL, 0x000e620000205400ULL,
0x000000ddda00720bULL, 0x008fe40003f5d000ULL, 0x000000e100da7245ULL, 0x000fc8000020d400ULL,
0x00000001dada5812ULL, 0x000fe200078efcffULL, 0x000000c700d27306ULL, 0x000fec0000209400ULL,
0x00000001dbdb2812ULL, 0x000fe400078efcffULL, 0x000000c700d37306ULL, 0x0004e20000205400ULL,
0x000000e7de00720bULL, 0x002fe20003fdd000ULL, 0x000100005ce77824ULL, 0x000fc400078e00ffULL,
0x000001005ede7824ULL, 0x000fc600078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe200000114e7ULL,
0x0000004900867306ULL, 0x000322000000d400ULL, 0x000000c700c77245ULL, 0x004fe4000020d400ULL,
0x00000018ffde7819ULL, 0x000fca00000114deULL, 0x000000c800d07306ULL, 0x000fe20000209400ULL,
0x000000d3d200720bULL, 0x008fe20003fbd000ULL, 0x0000010058497824ULL, 0x002fe200078e00ffULL,
0x000000df00d27245ULL, 0x000fc8000020d400ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x000000c800d77306ULL, 0x0002a20000205400ULL, 0x0000000186863812ULL, 0x010fca00078efcffULL,
0x00000001c7c75812ULL, 0x000fe400078efcffULL, 0x0000004800877306ULL, 0x000722000000d400ULL,
0x000000c800c87245ULL, 0x002fce000020d400ULL, 0x000000d400e57306ULL, 0x000fe20000209400ULL,
0x000000d7d000720bULL, 0x004fe20003f7d000ULL, 0x0000010059487824ULL, 0x008fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x000000d400e47306ULL, 0x0002a20000205400ULL,
0x0000000187874812ULL, 0x010fca00078efcffULL, 0x00000001c8c83812ULL, 0x000fe400078efcffULL,
0x0000005b009c7306ULL, 0x000fe20000009400ULL, 0x000000d400d47245ULL, 0x002fce000020d400ULL,
0x0000005b009a7306ULL, 0x000fe20000005400ULL, 0x000000e4e500720bULL, 0x004fce0003f9d000ULL,
0x0000005b00817306ULL, 0x0003ec000000d400ULL, 0x00000001d4d44812ULL, 0x000fe400078efcffULL,
0x000000df00e37306ULL, 0x000fe20000209400ULL, 0x000100005b5b7824ULL, 0x002fca00078e00ffULL,
0x00000018ffc57819ULL, 0x000fe2000001145bULL, 0x000000ffff5b7224ULL, 0x000fe200078e00c6ULL,
0x000000df00e67306ULL, 0x000fe80000205400ULL, 0x000000ff5b00720cULL, 0x000fe20003f25270ULL,
0x000001005c5b7824ULL, 0x000fc600078e00ffULL, 0x000000c900cd7306ULL, 0x000fe40000209400ULL,
0x00000018ff5b7819ULL, 0x000fcc000001145bULL, 0x000000c900d17306ULL, 0x0002b00000205400ULL,
0x000000c300ce7306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fce000020d400ULL,
0x000000c300cf7306ULL, 0x0002e20000205400ULL, 0x000000d1cd00720bULL, 0x004fce0003fbd000ULL,
0x0000004b00c17306ULL, 0x000fe20000009400ULL, 0x000000c300c37245ULL, 0x002fca000020d400ULL,
0x00000001c9c95812ULL, 0x000fe400078efcffULL, 0x0000004b00c27306ULL, 0x000e620000005400ULL,
0x000000cfce00720bULL, 0x008fce0003f7d000ULL, 0x0000005c009b7306ULL, 0x000fec0000009400ULL,
0x00000001c3c33812ULL, 0x000fe400078efcffULL, 0x0000005c00977306ULL, 0x000fe20000005400ULL,
0x000000c2c100720bULL, 0x002fe40003f9d000ULL, 0x00000018ffc17819ULL, 0x000fca00000114e8ULL,
0x0000005c00697306ULL, 0x0003f0000000d400ULL, 0x000000cc00d57306ULL, 0x000fe20000209400ULL,
0x000000e2005c7245ULL, 0x002fc8000020d400ULL, 0x000000015c5c6812ULL, 0x000fe400078efcffULL,
0x000000e6e300720bULL, 0x000fe20003fdd000ULL, 0x000000cc00d67306ULL, 0x0002b00000205400ULL,
0x000000aa00ac7306ULL, 0x000fe20000209400ULL, 0x000000cc00cc7245ULL, 0x002fc6000020d400ULL,
0x00000001d2d26812ULL, 0x000fc800078efcffULL, 0x000000aa00ab7306ULL, 0x000e620000205400ULL,
0x000000d6d500720bULL, 0x004fce0003fdd000ULL, 0x0000004a00cb7306ULL, 0x000fec0000009400ULL,
0x00000001cccc6812ULL, 0x000fe400078efcffULL, 0x0000004a00ca7306ULL, 0x000ea20000005400ULL,
0x000000abac00720bULL, 0x002fe20003fbd000ULL, 0x000100004eab7824ULL, 0x000fc400078e00ffULL,
0x000001004fac7824ULL, 0x000fc600078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000004800bf7306ULL, 0x000fe20000209400ULL, 0x00000018ffac7819ULL, 0x000fce00000114acULL,
0x0000004800c47306ULL, 0x000e620000205400ULL, 0x000000cacb00720bULL, 0x004fce0003f5d000ULL,
0x0000004b00627306ULL, 0x000eb0000000d400ULL, 0x0000005900ad7306ULL, 0x000fe20000009400ULL,
0x000000c4bf00720bULL, 0x002fe20003f7d000ULL, 0x000001004dbf7824ULL, 0x000fca00078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0000005900ae7306ULL, 0x000e620000005400ULL,
0x0000000162624812ULL, 0x004fce00078efcffULL, 0x0000005900647306ULL, 0x0004f0000000d400ULL,
0x0000005800b77306ULL, 0x000fe20000009400ULL, 0x0001000059597824ULL, 0x004fe200078e00ffULL,
0x000000aead00720bULL, 0x002fe20003f9d000ULL, 0x000001004ead7824ULL, 0x000fe200078e00ffULL,
0x000000aa00ae7245ULL, 0x000fe2000020d400ULL, 0x000100004faa7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc40000011459ULL, 0x0000005800b97306ULL, 0x000e620000005400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ffaa7819ULL, 0x000fe400000114aaULL, 0x0000000164644812ULL, 0x008fe200078efcffULL,
0x0000009d009e7306ULL, 0x000ff00000209400ULL, 0x0000009d009f7306ULL, 0x0004e20000205400ULL,
0x000000b9b700720bULL, 0x002fc40003fdd000ULL, 0x0000004900b77245ULL, 0x000fca000020d400ULL,
0x0000004a00827306ULL, 0x000322000000d400ULL, 0x0000009d009d7245ULL, 0x004fce000020d400ULL,
0x000000af00b87306ULL, 0x000fe20000209400ULL, 0x0000009f9e00720bULL, 0x008fe20003fbd000ULL,
0x00010000584a7824ULL, 0x002fe200078e00ffULL, 0x00000048009e7245ULL, 0x000fe4000020d400ULL,
0x0000b0003a487811ULL, 0x000fe400078e20ffULL, 0x000000019e9e3812ULL, 0x000fe200078efcffULL,
0x000000af00ba7306ULL, 0x0002a20000205400ULL, 0x0000000182822812ULL, 0x010fe400078efcffULL,
0x00000018ff4a7819ULL, 0x000fc6000001144aULL, 0x000000019d9d5812ULL, 0x000fe400078efcffULL,
0x0000005900b07306ULL, 0x000fe20000209400ULL, 0x000000af00af7245ULL, 0x002fce000020d400ULL,
0x0000005900b17306ULL, 0x000e620000205400ULL, 0x000000bab800720bULL, 0x004fe20003f5d000ULL,
0x000100004db87824ULL, 0x000fe200078e00ffULL, 0x00000018ffba7819ULL, 0x000fc800000114e9ULL,
0x00000018ffb87819ULL, 0x000fe200000114b8ULL, 0x0000005800607306ULL, 0x000eac000000d400ULL,
0x00000001afaf2812ULL, 0x000fe400078efcffULL, 0x0000005a00987306ULL, 0x000fe20000009400ULL,
0x000000b1b000720bULL, 0x002fce0003f7d000ULL, 0x0000005a00997306ULL, 0x000e620000005400ULL,
0x0000000160606812ULL, 0x004fce00078efcffULL, 0x0000004900bd7306ULL, 0x000ff00000209400ULL,
0x0000004900be7306ULL, 0x000ea20000205400ULL, 0x000000999800720bULL, 0x002fe40003fdd000ULL,
0x0000005900997245ULL, 0x000fc4000020d400ULL, 0x0000004a00987245ULL, 0x000fe4000020d400ULL,
0x0000000199993812ULL, 0x000fe200078efcffULL, 0x000000a000a17306ULL, 0x000fe20000209400ULL,
0x0000009a9c00720bULL, 0x000fce0003f7d000ULL, 0x000000a000a27306ULL, 0x0002e20000205400ULL,
0x000000bebd00720bULL, 0x004fe20003f5d000ULL, 0x000001004cbe7824ULL, 0x040fe400078e00ffULL,
0x000100004cbd7824ULL, 0x000fe400078e00ffULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x0000005a006a7306ULL, 0x000ea2000000d400ULL, 0x000000a000a07245ULL, 0x002fe4000020d400ULL,
0x00000018ffbe7819ULL, 0x000fc400000114beULL, 0x00000018ffbd7819ULL, 0x000fe400000114bdULL,
0x00000001b7b72812ULL, 0x000fe200078efcffULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x000000a2a100720bULL, 0x008fce0003f9d000ULL, 0x000000a300a57306ULL, 0x0002e20000205400ULL,
0x000000016a6a6812ULL, 0x004fca00078efcffULL, 0x00000001a0a04812ULL, 0x000fe400078efcffULL,
0x0000004a004b7306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fe4000020d400ULL,
0x00000099a099723eULL, 0x000fca00000010ffULL, 0x0000004a00587306ULL, 0x000e620000205400ULL,
0x000000a5a400720bULL, 0x008fce0003fdd000ULL, 0x000000b500b67306ULL, 0x000fec0000209400ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x000000b5005a7306ULL, 0x0004e20000205400ULL,
0x000000584b00720bULL, 0x002fe40003f5d000ULL, 0x000000004848783bULL, 0x000e6a0000000200ULL,
0x0000009200a67306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x004fca000020d400ULL,
0x0000000198982812ULL, 0x000fe400078efcffULL, 0x0000009200a77306ULL, 0x0005220000205400ULL,
0x0000005ab600720bULL, 0x008fe40003fbd000ULL, 0x000000989d98723eULL, 0x000fca00000010ffULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x004fca000020d400ULL,
0x00000001b5b55812ULL, 0x000fe400078efcffULL, 0x000000bb00c07306ULL, 0x0004e20000205400ULL,
0x000000a7a600720bULL, 0x010fce0003f7d000ULL, 0x0000009300a87306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x004fe2000020d400ULL, 0x0000007748489231ULL, 0x082fe400003400ffULL,
0x000000774a4a9231ULL, 0x000fe400003400ffULL, 0x0000000192923812ULL, 0x000fe200078efcffULL,
0x0000007849499231ULL, 0x080fe200003400ffULL, 0x0000009300a97306ULL, 0x0002a20000205400ULL,
0x000000c0bc00720bULL, 0x008fe20003f9d000ULL, 0x000000784b4b9231ULL, 0x000fcc00003400ffULL,
0x000000b200b37306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fe2000020d400ULL,
0x000000984818723cULL, 0x000fe80000041818ULL, 0x00000001bbbb4812ULL, 0x000fe400078efcffULL,
0x000000b200b47306ULL, 0x0002e20000205400ULL, 0x000000a9a800720bULL, 0x004fe40003fdd000ULL,
0x000000bba3c4723eULL, 0x000fca00000010ffULL, 0x000000c500c67306ULL, 0x000fe20000209400ULL,
0x000000b200b27245ULL, 0x002fca000020d400ULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x000000c500d87306ULL, 0x0002a20000205400ULL, 0x000000b4b300720bULL, 0x008fce0003f5d000ULL,
0x000000c100c27306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x002fca000020d400ULL,
0x00000001b2b22812ULL, 0x000fe400078efcffULL, 0x000000c100b97306ULL, 0x0002e20000205400ULL,
0x000000d8c600720bULL, 0x004fe40003fbd000ULL, 0x000000979b00720bULL, 0x000fe40003f5d000ULL,
0x0000005b00977245ULL, 0x000fe4000020d400ULL, 0x0000006ab26a723eULL, 0x000fe200000010ffULL,
0x0000005d008e7306ULL, 0x000fe20000009400ULL, 0x000000c100c17245ULL, 0x002fca000020d400ULL,
0x00000001c5c55812ULL, 0x000fe400078efcffULL, 0x0000005d008c7306ULL, 0x000fe20000005400ULL,
0x000000b9c200720bULL, 0x008fe40003f7d000ULL, 0x0000000169692812ULL, 0x000fe400078efcffULL,
0x000000c592c5723eULL, 0x000fc600000010ffULL, 0x0000005d00687306ULL, 0x000fe8000000d400ULL,
0x000000c44820723cULL, 0x000fe40000041820ULL, 0x00000001c1c13812ULL, 0x000fe400078efcffULL,
0x0000005b005d7306ULL, 0x000ff00000209400ULL, 0x0000005b00dd7306ULL, 0x000e700000205400ULL,
0x0000004d00907306ULL, 0x000ff00000009400ULL, 0x0000004d00897306ULL, 0x000fe20000005400ULL,
0x000000dd5d00720bULL, 0x002fc40003f9d000ULL, 0x00000062c85d723eULL, 0x000fe400000010ffULL,
0x000000c9af62723eULL, 0x000fc600000010ffULL, 0x0000004d00737306ULL, 0x000fec000000d400ULL,
0x0000000197974812ULL, 0x000fe400078efcffULL, 0x0000004e00677306ULL, 0x000fe20000009400ULL,
0x0000008c8e00720bULL, 0x000fce0003f9d000ULL, 0x0000004e00657306ULL, 0x000fec0000005400ULL,
0x0000000168684812ULL, 0x000fe400078efcffULL, 0x0000004e006e7306ULL, 0x000ff0000000d400ULL,
0x000000de004d7306ULL, 0x000ff00000209400ULL, 0x000000de004e7306ULL, 0x000e700000205400ULL,
0x000000dc00d37306ULL, 0x000ff00000209400ULL, 0x000000dc00ca7306ULL, 0x0004e20000205400ULL,
0x0000004e4d00720bULL, 0x002fc40003fdd000ULL, 0x00000086d24d723eULL, 0x000fca00000010ffULL,
0x0000005e00917306ULL, 0x000fe20000009400ULL, 0x000000dc00dc7245ULL, 0x004fce000020d400ULL,
0x0000005e008a7306ULL, 0x000e620000005400ULL, 0x000000cad300720bULL, 0x008fce0003fbd000ULL,
0x000000d9009f7306ULL, 0x000fec0000209400ULL, 0x00000001dcdc5812ULL, 0x000fe400078efcffULL,
0x000000d900597306ULL, 0x0004e20000205400ULL, 0x0000008a9100720bULL, 0x002fe40003f7d000ULL,
0x000000de008a7245ULL, 0x000fc8000020d400ULL, 0x000000018a8a6812ULL, 0x000fe200078efcffULL,
0x0000005e007a7306ULL, 0x000322000000d400ULL, 0x000000d900d97245ULL, 0x004fce000020d400ULL,
0x0000004c00887306ULL, 0x000fe20000009400ULL, 0x000100005e5e7824ULL, 0x002fe200078e00ffULL,
0x000000599f00720bULL, 0x008fe40003fdd000ULL, 0x000000d4c759723eULL, 0x000fe400000010ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000004c008d7306ULL, 0x000fe20000005400ULL,
0x000000017a7a3812ULL, 0x010fcc00078efcffULL, 0x00000001d9d96812ULL, 0x000fe200078efcffULL,
0x0000004c00727306ULL, 0x000ff0000000d400ULL, 0x000000ba00cb7306ULL, 0x000ff00000209400ULL,
0x000000ba004c7306ULL, 0x0002b00000205400ULL, 0x0000005f008f7306ULL, 0x000fe20000009400ULL,
0x000000ba00ba7245ULL, 0x002fce000020d400ULL, 0x0000005f008b7306ULL, 0x000e620000005400ULL,
0x0000004ccb00720bULL, 0x004fe40003fbd000ULL, 0x000000875c4c723eULL, 0x000fe400000010ffULL,
0x00000082cc5c723eULL, 0x000fe400000010ffULL, 0x0000005e00827245ULL, 0x000fe2000020d400ULL,
0x0000004f00807306ULL, 0x000fec0000009400ULL, 0x00000001baba5812ULL, 0x000fc400078efcffULL,
0x0000004f006b7306ULL, 0x000fe20000005400ULL, 0x0000008b8f00720bULL, 0x002fe40003f9d000ULL,
0x0000008d8800720bULL, 0x000fca0003fbd000ULL, 0x0000004f006f7306ULL, 0x000ff0000000d400ULL,
0x0000005e004f7306ULL, 0x000fe20000209400ULL, 0x0000000172725812ULL, 0x000fce00078efcffULL,
0x0000005e00587306ULL, 0x000e700000205400ULL, 0x0000006100857306ULL, 0x000ff00000209400ULL,
0x0000006100847306ULL, 0x000ea20000205400ULL, 0x000000584f00720bULL, 0x002fc40003fdd000ULL,
0x0000004c484c723cULL, 0x000fe20000041804ULL, 0x000000dadb58723eULL, 0x000fc800000010ffULL,
0x0000005f007b7306ULL, 0x0002e4000000d400ULL, 0x0000b00039047811ULL, 0x000fe200078e20ffULL,
0x000000584858723cULL, 0x000fe60000041808ULL, 0x0000000182826812ULL, 0x000fe400078efcffULL,
0x0000006600837306ULL, 0x000fe20000209400ULL, 0x000100005f5f7824ULL, 0x002fe200078e00ffULL,
0x000000848500720bULL, 0x004fe20003f7d000ULL, 0x000000000404783bULL, 0x000e620000000200ULL,
0x00000060b708723eULL, 0x000fc400000010ffULL, 0x00000018ff9a7819ULL, 0x000fe4000001145fULL,
0x0000006600637306ULL, 0x000ea20000205400ULL, 0x000000017b7b4812ULL, 0x008fe400078efcffULL,
0x000000649e09723eULL, 0x000fe400000010ffULL, 0x0000006600847245ULL, 0x000fc6000020d400ULL,
0x000000be008c7306ULL, 0x000ff00000209400ULL, 0x000000be008e7306ULL, 0x0007220000205400ULL,
0x000000638300720bULL, 0x004fe40003f9d000ULL, 0x0000006100837245ULL, 0x000fc4000020d400ULL,
0x000000c3ae63723eULL, 0x000fe400000010ffULL, 0x0000000183833812ULL, 0x000fe200078efcffULL,
0x0000009400957306ULL, 0x000fe20000209400ULL, 0x000000be00be7245ULL, 0x008fc6000020d400ULL,
0x000000624860723cULL, 0x000fe40000041810ULL, 0x0000000184844812ULL, 0x000fe400078efcffULL,
0x0000009400967306ULL, 0x0004e20000205400ULL, 0x0000008e8c00720bULL, 0x010fe40003f7d000ULL,
0x0000006b8000720bULL, 0x000fe20003f9d000ULL, 0x0000007704049231ULL, 0x082fe200003400ffULL,
0x00000081b56b723eULL, 0x000fe200000010ffULL, 0x0000007706069231ULL, 0x000fe200003400ffULL,
0x0000007a8a10723eULL, 0x000fe200000010ffULL, 0x0000009a005f7306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x004fe2000020d400ULL, 0x0000007805059231ULL, 0x080fe200003400ffULL,
0x0000007bd911723eULL, 0x000fe200000010ffULL, 0x0000007807079231ULL, 0x000fc400003400ffULL,
0x00000001bebe3812ULL, 0x000fe400078efcffULL, 0x0000009a009b7306ULL, 0x0002a20000205400ULL,
0x000000969500720bULL, 0x008fe40003f5d000ULL, 0x000000016f6f4812ULL, 0x000fca00078efcffULL,
0x000000bf008b7306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fca000020d400ULL,
0x0000000194942812ULL, 0x000fe400078efcffULL, 0x000000bf00877306ULL, 0x0002e20000205400ULL,
0x0000009b5f00720bULL, 0x004fe40003fdd000ULL, 0x000000899000720bULL, 0x000fe20003f5d000ULL,
0x0000005c485c723cULL, 0x000fe8000004180cULL, 0x000000bd00867306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x002fc4000020d400ULL, 0x000000dc930c723eULL, 0x000fe400000010ffULL,
0x000000ba940d723eULL, 0x000fe400000010ffULL, 0x000000019a9a6812ULL, 0x000fe200078efcffULL,
0x000000bd00857306ULL, 0x0002a20000205400ULL, 0x000000878b00720bULL, 0x008fe40003f7d000ULL,
0x000000656700720bULL, 0x000fe20003fdd000ULL, 0x0000000c040c723cULL, 0x000fe20000041858ULL,
0x0000000173732812ULL, 0x000fc600078efcffULL, 0x0000007d007f7306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x002fc6000020d400ULL, 0x000000084864723cULL, 0x040fe40000041814ULL,
0x00000001bfbf3812ULL, 0x000fe400078efcffULL, 0x0000007d007e7306ULL, 0x0002e20000205400ULL,
0x000000858600720bULL, 0x004fe40003fbd000ULL, 0x000000699708723eULL, 0x000fe400000010ffULL,
0x00000068c109723eULL, 0x000fe400000010ffULL, 0x0000006a4868723cULL, 0x000fe2000004181cULL,
0x0000007600797306ULL, 0x000fe20000209400ULL, 0x0000007d007d7245ULL, 0x002fc4000020d400ULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x000000828314723eULL, 0x000fe400000010ffULL,
0x00000001bdbd5812ULL, 0x000fe200078efcffULL, 0x00000076007c7306ULL, 0x0002a20000205400ULL,
0x0000007e7f00720bULL, 0x008fe40003f7d000ULL, 0x000000b8001d7245ULL, 0x000fe4000020d400ULL,
0x0000009a8415723eULL, 0x000fc400000010ffULL, 0x00000072be48723eULL, 0x000fe200000010ffULL,
0x000000b8000a7306ULL, 0x000fe20000209400ULL, 0x0000007600767245ULL, 0x002fe4000020d400ULL,
0x00000073bf49723eULL, 0x000fc600000010ffULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x000000b8000b7306ULL, 0x000e620000205400ULL, 0x0000007c7900720bULL, 0x004fe20003fbd000ULL,
0x000000480448723cULL, 0x000fec0000041864ULL, 0x000000ad00127306ULL, 0x000fec0000209400ULL,
0x0000000176765812ULL, 0x000fc400078efcffULL, 0x000000ad00137306ULL, 0x0004e20000205400ULL,
0x0000000b0a00720bULL, 0x002fe40003f5d000ULL, 0x000000080408723cULL, 0x000fea000004184cULL,
0x000000ac00167306ULL, 0x000fe20000209400ULL, 0x000000ad00ad7245ULL, 0x004fe4000020d400ULL,
0x000000aa004d7245ULL, 0x000fc6000020d400ULL, 0x000000011d1d2812ULL, 0x000fe400078efcffULL,
0x000000ac00177306ULL, 0x0002a20000205400ULL, 0x000000131200720bULL, 0x008fe40003f7d000ULL,
0x0000001d761d723eULL, 0x000fe200000010ffULL, 0x000000100410723cULL, 0x000fe8000004185cULL,
0x0000000000757306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x002fca000020d400ULL,
0x00000001adad3812ULL, 0x000fe400078efcffULL, 0x0000000000747306ULL, 0x0002e20000205400ULL,
0x000000171600720bULL, 0x004fe40003fbd000ULL, 0x0000006ead6e723eULL, 0x000fe200000010ffULL,
0x000000140414723cULL, 0x000fe80000041860ULL, 0x0000005700717306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x002fca000020d400ULL, 0x00000001acac5812ULL, 0x000fe400078efcffULL,
0x0000005700707306ULL, 0x0002a20000205400ULL, 0x000000747500720bULL, 0x008fe40003f5d000ULL,
0x0000006fac6f723eULL, 0x000fca00000010ffULL, 0x000000ab001c7306ULL, 0x000fe20000209400ULL,
0x0000005700577245ULL, 0x002fca000020d400ULL, 0x0000000100002812ULL, 0x000fe400078efcffULL,
0x000000ab001e7306ULL, 0x0002e20000205400ULL, 0x000000707100720bULL, 0x004fce0003f7d000ULL,
0x000000aa001f7306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x0000000157573812ULL, 0x000fe400078efcffULL, 0x000000aa004c7306ULL, 0x000e620000205400ULL,
0x0000001e1c00720bULL, 0x008fe40003fdd000ULL, 0x000000bd7d1c723eULL, 0x000fd600000010ffULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x0000004c1f00720bULL, 0x002fe40003fbd000ULL,
0x000000ab004c723eULL, 0x000fe200000010ffULL, 0x0000001c041c723cULL, 0x040ff00000041818ULL,
0x0000006e0418723cULL, 0x000fe40000041868ULL, 0x000000014d4d5812ULL, 0x000fc800078efcffULL,
0x0000004d574d723eULL, 0x000fce00000010ffULL, 0x0000004c0404723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff207f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844821ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000227305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000220000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe40007844821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c003007811ULL, 0x000fe200078e40ffULL, 0x00000100ff587424ULL, 0x000fe200078e00ffULL,
0x00000004ff577819ULL, 0x000fc4000001162dULL, 0x0000000024207217ULL, 0x000fe20007800000ULL,
0x000062002b4f7a24ULL, 0x000fc800078e0200ULL, 0x0000000120207824ULL, 0x000fe400078e0a00ULL,
0x0000000135217824ULL, 0x100fe400078e024fULL, 0x0000000130227824ULL, 0x100fe200078e024fULL,
0x0000002020007807ULL, 0x000fe20000000000ULL, 0x000000012f4c7824ULL, 0x000fe400078e024fULL,
0x00005e0021207625ULL, 0x000fe200078e0058ULL, 0x000000002c007217ULL, 0x000fc60007800000ULL,
0x00005e0022227625ULL, 0x000fe200078e0058ULL, 0x00000034204e7210ULL, 0x000fc60007f5e0ffULL,
0x00005e004c4c7625ULL, 0x000fe200078e0058ULL, 0x0000003422227210ULL, 0x000fc60007f9e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a2cULL, 0x000000344c4c7210ULL, 0x000fe20007fbe0ffULL,
0x000000012e207824ULL, 0x000fe400078e024fULL, 0x000000ffff4f7224ULL, 0x000fe200010e0621ULL,
0x000000005700720cULL, 0x000fe20003f46070ULL, 0x00005e0020207625ULL, 0x000fe200078e0058ULL,
0x000000003300720cULL, 0x000fc60003f66070ULL, 0x000000ffff237224ULL, 0x000fe200020e0623ULL,
0x000000003200720cULL, 0x080fe20003f86070ULL, 0x000000ffff4d7224ULL, 0x000fe200028e064dULL,
0x000000003100720cULL, 0x000fe40003fa6070ULL, 0x0000003420207210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e457faeULL, 0x0003e4000d101c46ULL,
0x000000ffff217224ULL, 0x000fe400030e0621ULL, 0x0000000022467faeULL, 0x0003e8000d901c46ULL,
0x000000004c477faeULL, 0x0003e8000e101c46ULL, 0x0000000020507faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff207f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc4000784486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff577224ULL, 0x000fe200078e0021ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000784486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000207305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000200000735dULL, 0x004fe40003800000ULL, 0x0106b400ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fc4000784486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000026ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff637819ULL, 0x000fe4000001162dULL,
0x0000541000627816ULL, 0x000fe20000000000ULL, 0x000105027f007947ULL, 0x000fea000b800000ULL,
0x00001f63627f7589ULL, 0x0002a400000e0000ULL, 0x000105427f007947ULL, 0x000fea000b800000ULL,
0x00001f38627e7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x002fe200078e0037ULL, 0x0000dc50005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x00010e8000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x002fe200078e0036ULL, 0x0000dcb0005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x00010e2000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000554c783bULL, 0x000f680000004200ULL, 0x00000000515c783bULL, 0x000fe80000004200ULL,
0x000000005620783bULL, 0x000e680000004200ULL, 0x000000005258783bULL, 0x000ee20000004200ULL,
0x000100004cde7824ULL, 0x060fe200078e00ffULL, 0x0000004c00b17306ULL, 0x000fe20000009400ULL,
0x000001004ce07824ULL, 0x000fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fe2000001144cULL,
0x000100004dd87824ULL, 0x040fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fe200000114deULL,
0x000001004ddb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x000100004ec97824ULL, 0x040fe200078e00ffULL, 0x0000004c00a77306ULL, 0x000f620000005400ULL,
0x00000018ffcc7819ULL, 0x000fe2000001144dULL, 0x000001004ecd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x0000010020bc7824ULL, 0x002fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x0000010022a17824ULL, 0x000fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x000000de00e77306ULL, 0x000fe20000209400ULL,
0x00000018ffb77819ULL, 0x000fe2000001144eULL, 0x0000010023a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001145eULL, 0x000001004fc87824ULL, 0x040fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x000100004fc27824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe2000001144fULL, 0x000000de00e87306ULL, 0x000e620000205400ULL,
0x000000a7b100720bULL, 0x020fe20003fdd000ULL, 0x000100005eb17824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x0001000022a27824ULL, 0x000fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fe20000011420ULL, 0x0001000023a57824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe20000011421ULL, 0x000000d100d07306ULL, 0x000fe20000209400ULL,
0x00000018ffa17819ULL, 0x000fc400000114a1ULL, 0x00000018ffa07819ULL, 0x000fe400000114a0ULL,
0x00000018ff947819ULL, 0x000fe40000011422ULL, 0x00000018ff977819ULL, 0x000fe20000011423ULL,
0x000000d100d27306ULL, 0x000b220000205400ULL, 0x000000e8e700720bULL, 0x002fe20003f5d000ULL,
0x000001005de77824ULL, 0x040fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x000100005de87824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fc4000001145cULL,
0x00000018ffc27819ULL, 0x000fe200000114c2ULL, 0x0000004d00d97306ULL, 0x000fe20000009400ULL,
0x000000d100d17245ULL, 0x020fe4000020d400ULL, 0x00000018ffa57819ULL, 0x000fe400000114a5ULL,
0x00000018ffa27819ULL, 0x000fe400000114a2ULL, 0x00000018ff867819ULL, 0x000fe2000001145dULL,
0x0000004d00cf7306ULL, 0x000e620000005400ULL, 0x000000d2d000720bULL, 0x010fc40003fbd000ULL,
0x00000018ffd27819ULL, 0x000fe400000114e7ULL, 0x00000018ffb17819ULL, 0x000fe400000114b1ULL,
0x00000018ff767819ULL, 0x000fe2000001145fULL, 0x000000e000e57306ULL, 0x000fe20000209400ULL,
0x00000018ff6c7819ULL, 0x008fe40000011458ULL, 0x00000018ff657819ULL, 0x000fe40000011459ULL,
0x00000018ff607819ULL, 0x000fc4000001145aULL, 0x00000001d1d15812ULL, 0x000fe200078efcffULL,
0x000000e000e67306ULL, 0x000ee20000205400ULL, 0x000000cfd900720bULL, 0x002fe40003f7d000ULL,
0x000000de00cf7245ULL, 0x000fe4000020d400ULL, 0x00000018ff007819ULL, 0x004fe4000001145bULL,
0x00000001cfcf2812ULL, 0x000fe200078efcffULL, 0x0000004c00877306ULL, 0x0002b0000000d400ULL,
0x000000cc00d47306ULL, 0x000fe20000209400ULL, 0x000000e6e500720bULL, 0x008fe20003f9d000ULL,
0x000001005ee57824ULL, 0x000fc400078e00ffULL, 0x00000100214c7824ULL, 0x002fe400078e00ffULL,
0x000100005ce67824ULL, 0x000fe200078e00ffULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x000000cc00d57306ULL, 0x0002e20000205400ULL, 0x0000000187876812ULL, 0x004fe400078efcffULL,
0x00000018ff4c7819ULL, 0x000fca000001144cULL, 0x000000d800e27306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fce000020d400ULL, 0x000000d800e17306ULL, 0x000e620000205400ULL,
0x000000d5d400720bULL, 0x008fe40003f5d000ULL, 0x000000db00d47245ULL, 0x000fca000020d400ULL,
0x0000004e00d37306ULL, 0x000fec0000009400ULL, 0x00000001cccc2812ULL, 0x000fe400078efcffULL,
0x0000004e00d67306ULL, 0x000ea20000005400ULL, 0x000000e1e200720bULL, 0x002fce0003fdd000ULL,
0x000000db00e37306ULL, 0x000ff00000209400ULL, 0x000000db00e47306ULL, 0x000fe20000205400ULL,
0x000000d6d300720bULL, 0x004fe40003fbd000ULL, 0x000000d800d37245ULL, 0x000fc8000020d400ULL,
0x00000001d3d36812ULL, 0x000fe200078efcffULL, 0x0000004f00c67306ULL, 0x000fe60000009400ULL,
0x000000d3ccd3723eULL, 0x000fca00000010ffULL, 0x0000004f00c77306ULL, 0x000e700000005400ULL,
0x000000c900ce7306ULL, 0x000ff00000209400ULL, 0x000000c900d77306ULL, 0x0004e20000205400ULL,
0x000000c7c600720bULL, 0x002fc40003fdd000ULL, 0x00000018ffc67819ULL, 0x000fca00000114e6ULL,
0x0000005e00927306ULL, 0x000fe20000009400ULL, 0x000000c900c97245ULL, 0x004fce000020d400ULL,
0x0000005e00887306ULL, 0x000fe20000005400ULL, 0x000000d7ce00720bULL, 0x008fce0003f5d000ULL,
0x0000005e006a7306ULL, 0x0003ec000000d400ULL, 0x00000001c9c92812ULL, 0x000fe400078efcffULL,
0x0000004e00827306ULL, 0x000ea2000000d400ULL, 0x000000e0005e7245ULL, 0x002fc8000020d400ULL,
0x000000015e5e4812ULL, 0x000fe400078efcffULL, 0x000000e4e300720bULL, 0x000fe20003f9d000ULL,
0x000000b700ba7306ULL, 0x000ff00000209400ULL, 0x000000b700bb7306ULL, 0x0002e20000205400ULL,
0x0000000182825812ULL, 0x004fc600078efcffULL, 0x00000001d4d44812ULL, 0x000fc800078efcffULL,
0x000000cd00dc7306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fce000020d400ULL,
0x000000cd00dd7306ULL, 0x0002a20000205400ULL, 0x000000bbba00720bULL, 0x008fce0003fbd000ULL,
0x0000004f007d7306ULL, 0x000ee2000000d400ULL, 0x000000cd00cd7245ULL, 0x002fca000020d400ULL,
0x00000001b7b75812ULL, 0x000fe400078efcffULL, 0x000000b400b57306ULL, 0x000fe20000209400ULL,
0x000000dddc00720bULL, 0x004fce0003f9d000ULL, 0x000000b400b67306ULL, 0x0002a20000205400ULL,
0x000000017d7d6812ULL, 0x008fca00078efcffULL, 0x00000001cdcd4812ULL, 0x000fe400078efcffULL,
0x000000bc00c37306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fe4000020d400ULL,
0x00000082cd82723eULL, 0x000fca00000010ffULL, 0x000000bc00c47306ULL, 0x0002e20000205400ULL,
0x000000b6b500720bULL, 0x004fe40003fdd000ULL, 0x00000018ffb57819ULL, 0x000fca00000114e8ULL,
0x0000002000b87306ULL, 0x000fe20000009400ULL, 0x000000bc00bc7245ULL, 0x002fca000020d400ULL,
0x00000001b4b46812ULL, 0x000fe400078efcffULL, 0x0000002000b97306ULL, 0x000e620000005400ULL,
0x000000c4c300720bULL, 0x008fce0003f5d000ULL, 0x00000020007b7306ULL, 0x0004ec000000d400ULL,
0x00000001bcbc2812ULL, 0x000fe400078efcffULL, 0x0000004c00c07306ULL, 0x000fe20000209400ULL,
0x0001000020207824ULL, 0x004fe200078e00ffULL, 0x000000b9b800720bULL, 0x002fc80003f9d000ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000004c00c57306ULL, 0x000e6e0000205400ULL,
0x000000017b7b4812ULL, 0x008fe200078efcffULL, 0x0000002100b37306ULL, 0x000ff00000009400ULL,
0x0000002100b27306ULL, 0x000fe20000005400ULL, 0x000000c5c000720bULL, 0x002fe20003fbd000ULL,
0x0001000059c07824ULL, 0x000fca00078e00ffULL, 0x00000018ffc07819ULL, 0x000fe200000114c0ULL,
0x00000021007a7306ULL, 0x0003f0000000d400ULL, 0x000000ac00b07306ULL, 0x000fe20000209400ULL,
0x0001000021217824ULL, 0x002fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x000000ac00af7306ULL, 0x0002b00000205400ULL, 0x0000002000bd7306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fce000020d400ULL, 0x0000002000c17306ULL, 0x000e620000205400ULL,
0x000000afb000720bULL, 0x004fe20003f5d000ULL, 0x000001005ab07824ULL, 0x000fe200078e00ffULL,
0x0000004c00af7245ULL, 0x000fe4000020d400ULL, 0x0000b000534c7811ULL, 0x000fe400078e20ffULL,
0x00000001afaf5812ULL, 0x000fe200078efcffULL, 0x0000002100be7306ULL, 0x000fe20000209400ULL,
0x00000018ffb07819ULL, 0x000fca00000114b0ULL, 0x00000001acac2812ULL, 0x000fe400078efcffULL,
0x0000002100bf7306ULL, 0x000ea20000205400ULL, 0x000000c1bd00720bULL, 0x002fce0003fdd000ULL,
0x0000002200ad7306ULL, 0x000ff00000009400ULL, 0x0000002200ae7306ULL, 0x000e620000005400ULL,
0x000000bfbe00720bULL, 0x004fe20003fbd000ULL, 0x0000010058be7824ULL, 0x000fc400078e00ffULL,
0x0000010059bf7824ULL, 0x000fc800078e00ffULL, 0x0000009f00ab7306ULL, 0x000ff00000209400ULL,
0x0000009f00a97306ULL, 0x000ea20000205400ULL, 0x000000aead00720bULL, 0x002fe40003f9d000ULL,
0x0000002000ad7245ULL, 0x000fc4000020d400ULL, 0x0000b00054207811ULL, 0x000fe400078e20ffULL,
0x00000001adad6812ULL, 0x000fe200078efcffULL, 0x0000004d00857306ULL, 0x000e66000000d400ULL,
0x000000adacac723eULL, 0x000fca00000010ffULL, 0x0000002200777306ULL, 0x000ee2000000d400ULL,
0x000000a9ab00720bULL, 0x004fe40003fdd000ULL, 0x0000002100a97245ULL, 0x000fe4000020d400ULL,
0x0000009f00ab7245ULL, 0x000fe2000020d400ULL, 0x000100005b9f7824ULL, 0x000fe200078e00ffULL,
0x00000001a9a95812ULL, 0x000fe200078efcffULL, 0x000000a1004d7306ULL, 0x000fe20000209400ULL,
0x0000000185853812ULL, 0x002fe400078efcffULL, 0x00000018ff9f7819ULL, 0x000fc6000001149fULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x000000a1004e7306ULL, 0x0002a20000205400ULL,
0x0000000177774812ULL, 0x008fe400078efcffULL, 0x000000a9abad723eULL, 0x000fca00000010ffULL,
0x000000a0004f7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fce000020d400ULL,
0x000000a000227306ULL, 0x0002e20000205400ULL, 0x0000004e4d00720bULL, 0x004fce0003f5d000ULL,
0x0000002300a87306ULL, 0x000fe20000009400ULL, 0x000000a000a07245ULL, 0x002fca000020d400ULL,
0x00000001a1a12812ULL, 0x000fe400078efcffULL, 0x0000002300aa7306ULL, 0x000fe20000005400ULL,
0x000000224f00720bULL, 0x008fe40003fbd000ULL, 0x000000004c4c783bULL, 0x000e6a0000000200ULL,
0x0000002300717306ULL, 0x0005ec000000d400ULL, 0x00000001a0a05812ULL, 0x000fc400078efcffULL,
0x0000005c008d7306ULL, 0x000fe20000009400ULL, 0x000001005c237824ULL, 0x004fce00078e00ffULL,
0x0000005c00937306ULL, 0x000ff00000005400ULL, 0x0000005c00707306ULL, 0x0005f0000000d400ULL,
0x000000c800da7306ULL, 0x000fe20000209400ULL, 0x00000018ff5c7819ULL, 0x004fe20000011423ULL,
0x000001005f237824ULL, 0x000fe200078e00ffULL, 0x0000007f4c4c9231ULL, 0x002fc400003400ffULL,
0x0000007f4e4e9231ULL, 0x000fe400003400ffULL, 0x00000018ffba7819ULL, 0x000fe20000011423ULL,
0x000000c800df7306ULL, 0x0002a20000205400ULL, 0x000000002020783bULL, 0x000ee20000000200ULL,
0x0000007e4d4d9231ULL, 0x080fe400003400ffULL, 0x0000007e4f4f9231ULL, 0x000fc800003400ffULL,
0x000000c200ca7306ULL, 0x000fe20000209400ULL, 0x000000c800c87245ULL, 0x002fce000020d400ULL,
0x000000c200cb7306ULL, 0x0003220000205400ULL, 0x000000dfda00720bULL, 0x004fce0003f7d000ULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x000000c200c27245ULL, 0x002fca000020d400ULL,
0x00000001c8c83812ULL, 0x000fe400078efcffULL, 0x000000cbca00720bULL, 0x010fe20003f7d000ULL,
0x000000c600b87306ULL, 0x0002b00000205400ULL, 0x0000009400957306ULL, 0x000fe20000209400ULL,
0x0000007f20209231ULL, 0x088fe200003400ffULL, 0x000000c600c67245ULL, 0x002fe2000020d400ULL,
0x0000007f22229231ULL, 0x000fe200003400ffULL, 0x00000001c2c23812ULL, 0x000fe200078efcffULL,
0x0000007e21219231ULL, 0x080fe200003400ffULL, 0x000000b2b300720bULL, 0x000fe20003f7d000ULL,
0x0000007e23239231ULL, 0x000fe200003400ffULL, 0x0000009400967306ULL, 0x0002e20000205400ULL,
0x000000b8c700720bULL, 0x004fc40003f3d000ULL, 0x000000d2007e7245ULL, 0x000fca000020d400ULL,
0x000000e500b37306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fe4000020d400ULL,
0x000000017a7a3812ULL, 0x000fe400078efcffULL, 0x000000aaa800720bULL, 0x000fe20003f7d000ULL,
0x000100005aa87824ULL, 0x000fe200078e00ffULL, 0x00000001c6c61812ULL, 0x000fe200078efcffULL,
0x000000e500ae7306ULL, 0x0002a20000205400ULL, 0x000000969500720bULL, 0x008fe20003fdd000ULL,
0x000001005baa7824ULL, 0x000fe200078e00ffULL, 0x0000007aafaf723eULL, 0x000fc400000010ffULL,
0x00000018ffa87819ULL, 0x000fe400000114a8ULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x000000a500a67306ULL, 0x000fe20000209400ULL, 0x000000e500e57245ULL, 0x002fe4000020d400ULL,
0x0000000171713812ULL, 0x000fe400078efcffULL, 0x000000938d00720bULL, 0x000fe40003f7d000ULL,
0x0000000194946812ULL, 0x000fe200078efcffULL, 0x000000a500a77306ULL, 0x0002e20000205400ULL,
0x000000aeb300720bULL, 0x004fc40003f3d000ULL, 0x000000889200720bULL, 0x000fe40003fdd000ULL,
0x00000018ff887819ULL, 0x000fe400000114beULL, 0x0000007bbcae723eULL, 0x000fe200000010ffULL,
0x000000a200a37306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x002fe4000020d400ULL,
0x0000000170703812ULL, 0x000fc600078efcffULL, 0x00000001e5e51812ULL, 0x000fe400078efcffULL,
0x000000a200a47306ULL, 0x0002a20000205400ULL, 0x000000a7a600720bULL, 0x008fe40003fbd000ULL,
0x000000016a6a6812ULL, 0x000fc800078efcffULL, 0x0000006ae56a723eULL, 0x000fe200000010ffULL,
0x0000009700987306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fca000020d400ULL,
0x00000001a5a55812ULL, 0x000fe400078efcffULL, 0x0000009700997306ULL, 0x0002e20000205400ULL,
0x000000a4a300720bULL, 0x004fce0003f5d000ULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fca000020d400ULL, 0x00000001a2a22812ULL, 0x000fe400078efcffULL,
0x000000ba00bd7306ULL, 0x0002a20000205400ULL, 0x000000999800720bULL, 0x008fe40003f9d000ULL,
0x000000a29494723eULL, 0x000fca00000010ffULL, 0x0000005d008e7306ULL, 0x000fe20000009400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x0000005d008b7306ULL, 0x000e620000005400ULL, 0x000000bdbb00720bULL, 0x004fce0003f3d000ULL,
0x0000005d006d7306ULL, 0x000eac000000d400ULL, 0x00000001baba1812ULL, 0x000fe400078efcffULL,
0x0000005c005d7306ULL, 0x000fe20000209400ULL, 0x0000008b8e00720bULL, 0x002fe40003f5d000ULL,
0x00000018ff8b7819ULL, 0x000fca00000114bfULL, 0x0000005c00d07306ULL, 0x000e6c0000205400ULL,
0x000000016d6d2812ULL, 0x004fe400078efcffULL, 0x0000007c00817306ULL, 0x000ff00000209400ULL,
0x0000007c00807306ULL, 0x0004e20000205400ULL, 0x000000d05d00720bULL, 0x002fc40003fbd000ULL,
0x000000c2b45d723eULL, 0x000fca00000010ffULL, 0x000000d200d57306ULL, 0x000fe20000209400ULL,
0x0000007c007c7245ULL, 0x004fce000020d400ULL, 0x000000d200d67306ULL, 0x0002a20000205400ULL,
0x000000808100720bULL, 0x008fce0003fdd000ULL, 0x000000b100b97306ULL, 0x000fe20000209400ULL,
0x000000cfd1d2723eULL, 0x002fca00000010ffULL, 0x000000017c7c6812ULL, 0x000fe400078efcffULL,
0x000000b100967306ULL, 0x0002e20000205400ULL, 0x000000d6d500720bULL, 0x004fce0003f9d000ULL,
0x0000005f00897306ULL, 0x000fe20000009400ULL, 0x000000b100b17245ULL, 0x002fca000020d400ULL,
0x000000017e7e4812ULL, 0x000fe400078efcffULL, 0x0000005f008f7306ULL, 0x000e620000005400ULL,
0x00000096b900720bULL, 0x008fce0003f3d000ULL, 0x0000009a009b7306ULL, 0x000fec0000209400ULL,
0x00000001b1b11812ULL, 0x000fe400078efcffULL, 0x0000009a009c7306ULL, 0x0005e20000205400ULL,
0x0000008f8900720bULL, 0x002fe40003f7d000ULL, 0x000000b17c7c723eULL, 0x000fca00000010ffULL,
0x0000005f006b7306ULL, 0x0002e2000000d400ULL, 0x0000009a009a7245ULL, 0x004fce000020d400ULL,
0x00000086009d7306ULL, 0x000fe20000209400ULL, 0x000100005f5f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff957819ULL, 0x000fe4000001145fULL, 0x00000086009e7306ULL, 0x000e620000205400ULL,
0x0000005c005f7245ULL, 0x000fe4000020d400ULL, 0x000000016b6b3812ULL, 0x008fe400078efcffULL,
0x000000015f5f5812ULL, 0x000fe400078efcffULL, 0x0000009c9b00720bULL, 0x000fe20003fbd000ULL,
0x0000007600797306ULL, 0x000fe20000209400ULL, 0x00000086009b7245ULL, 0x000fc4000020d400ULL,
0x000000c9b75c723eULL, 0x000fe400000010ffULL, 0x000000705f70723eULL, 0x000fe400000010ffULL,
0x0000006bba6b723eULL, 0x000fe200000010ffULL, 0x0000007600787306ULL, 0x0004e20000205400ULL,
0x0000009e9d00720bULL, 0x002fc60003f5d000ULL, 0x000000019a9a5812ULL, 0x000fc800078efcffULL,
0x000000b500b67306ULL, 0x000fe20000209400ULL, 0x0000007600767245ULL, 0x004fe4000020d400ULL,
0x000000c69a9a723eULL, 0x000fc600000010ffULL, 0x000000019b9b2812ULL, 0x000fe400078efcffULL,
0x000000b500b27306ULL, 0x0002a20000205400ULL, 0x000000787900720bULL, 0x008fce0003f3d000ULL,
0x0000008800927306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x0000000176761812ULL, 0x000fe400078efcffULL, 0x0000008800937306ULL, 0x0002e20000205400ULL,
0x000000b2b600720bULL, 0x004fce0003f9d000ULL, 0x00000095008d7306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x002fca000020d400ULL, 0x00000001b5b54812ULL, 0x000fe400078efcffULL,
0x00000095008e7306ULL, 0x000e620000205400ULL, 0x000000939200720bULL, 0x008fe40003fdd000ULL,
0x000000b59b9b723eULL, 0x000fca00000010ffULL, 0x00000058008c7306ULL, 0x000fec0000009400ULL,
0x0000000188886812ULL, 0x000fe400078efcffULL, 0x0000005800907306ULL, 0x000ea20000005400ULL,
0x0000008e8d00720bULL, 0x002fce0003f7d000ULL, 0x0000005800677306ULL, 0x0002f0000000d400ULL,
0x0000005a00847306ULL, 0x000fe20000009400ULL, 0x0001000058587824ULL, 0x002fe200078e00ffULL,
0x000000908c00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff7f7819ULL, 0x000fe40000011458ULL,
0x0000005a00837306ULL, 0x000e620000005400ULL, 0x000000875e58723eULL, 0x000fcc00000010ffULL,
0x0000000167675812ULL, 0x008fe200078efcffULL, 0x00000059008a7306ULL, 0x000fe60000009400ULL,
0x000000678888723eULL, 0x000fca00000010ffULL, 0x0000005900917306ULL, 0x000ea20000005400ULL,
0x000000838400720bULL, 0x002fe40003f5d000ULL, 0x0000007dc883723eULL, 0x000fe400000010ffULL,
0x00000095007d7245ULL, 0x000fe4000020d400ULL, 0x000000a59795723eULL, 0x000fe200000010ffULL,
0x0000005900637306ULL, 0x0002e2000000d400ULL, 0x000000017d7d3812ULL, 0x000fc800078efcffULL,
0x0000007d767d723eULL, 0x000fc600000010ffULL, 0x0000006c00727306ULL, 0x000fe20000209400ULL,
0x00000085d459723eULL, 0x002fe400000010ffULL, 0x000000918a00720bULL, 0x004fca0003f9d000ULL,
0x0000006c00737306ULL, 0x0002b00000205400ULL, 0x0000008b00897306ULL, 0x000fe20000209400ULL,
0x0000006c006c7245ULL, 0x002fe4000020d400ULL, 0x0000000163634812ULL, 0x008fca00078efcffULL,
0x0000008b008f7306ULL, 0x000e620000205400ULL, 0x000000737200720bULL, 0x004fce0003f3d000ULL,
0x0000005a00627306ULL, 0x000eac000000d400ULL, 0x000000016c6c1812ULL, 0x000fe400078efcffULL,
0x0000005b00757306ULL, 0x000fe20000009400ULL, 0x0000008f8900720bULL, 0x002fe40003fdd000ULL,
0x0000008b00897245ULL, 0x000fca000020d400ULL, 0x0000005b00747306ULL, 0x000e620000005400ULL,
0x0000000162622812ULL, 0x004fca00078efcffULL, 0x0000000189896812ULL, 0x000fe400078efcffULL,
0x0000005b00617306ULL, 0x0004e4000000d400ULL, 0x000000638989723eULL, 0x000fe400000010ffULL,
0x000000aa00637245ULL, 0x000fc8000020d400ULL, 0x00000065006f7306ULL, 0x000fe20000209400ULL,
0x000000584c58723cULL, 0x004fe20000041808ULL, 0x000000747500720bULL, 0x002fcc0003f7d000ULL,
0x00000065006e7306ULL, 0x0002a20000205400ULL, 0x000000d24c08723cULL, 0x040fec000004180cULL,
0x0000000161613812ULL, 0x008fe200078efcffULL, 0x0000007f005e7306ULL, 0x000fe20000209400ULL,
0x000000824c0c723cULL, 0x000fe20000041810ULL, 0x0000006500657245ULL, 0x002fcc000020d400ULL,
0x0000007f00847306ULL, 0x000e620000205400ULL, 0x0000005c4c10723cULL, 0x000fe20000041814ULL,
0x0000006e6f00720bULL, 0x004fcc0003fbd000ULL, 0x000000c000807306ULL, 0x000fe20000209400ULL,
0x00000077a15c723eULL, 0x000fe200000010ffULL, 0x000000ae4c14723cULL, 0x040fe20000041848ULL,
0x00000071a05d723eULL, 0x000fe400000010ffULL, 0x0000006d7e71723eULL, 0x000fe400000010ffULL,
0x0000000165655812ULL, 0x000fe200078efcffULL, 0x000000c000817306ULL, 0x000ea20000205400ULL,
0x000000845e00720bULL, 0x002fe20003fdd000ULL, 0x000000ac4c48723cULL, 0x000fe2000004181cULL,
0x0000007f007f7245ULL, 0x000fca000020d400ULL, 0x000000b0007a7306ULL, 0x000fe40000209400ULL,
0x0000005c4c1c723cULL, 0x040fe80000041818ULL, 0x000000017f7f6812ULL, 0x000fe400078efcffULL,
0x000000b000787306ULL, 0x0002e20000205400ULL, 0x000000818000720bULL, 0x004fe20003f9d000ULL,
0x000000944c4c723cULL, 0x000fe20000041804ULL, 0x000000c000197245ULL, 0x000fca000020d400ULL,
0x000000aa00747306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fe2000020d400ULL,
0x000000702004723cULL, 0x040fe80000041858ULL, 0x0000000119194812ULL, 0x000fe400078efcffULL,
0x000000aa00727306ULL, 0x000e620000205400ULL, 0x000000787a00720bULL, 0x008fe20003f3d000ULL,
0x0000009a2008723cULL, 0x000fe20000041808ULL, 0x000000196519723eULL, 0x000fca00000010ffULL,
0x0000006000687306ULL, 0x000fe40000209400ULL, 0x0000006a200c723cULL, 0x040fe8000004180cULL,
0x00000001b0b01812ULL, 0x000fe400078efcffULL, 0x0000006000697306ULL, 0x0004e20000205400ULL,
0x000000727400720bULL, 0x002fe20003fbd000ULL, 0x0000007c2010723cULL, 0x000fe20000041810ULL,
0x00000062b062723eULL, 0x000fca00000010ffULL, 0x0000000000647306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x004fe2000020d400ULL, 0x000000882014723cULL, 0x000fe80000041814ULL,
0x0000000163635812ULL, 0x000fe400078efcffULL, 0x0000000000667306ULL, 0x0002a20000205400ULL,
0x000000696800720bULL, 0x008fe40003fdd000ULL, 0x000000616363723eULL, 0x000fc400000010ffULL,
0x0000009f00617245ULL, 0x000fc6000020d400ULL, 0x000000a800187306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x002fe2000020d400ULL, 0x00000062201c723cULL, 0x000fe8000004181cULL,
0x0000000160606812ULL, 0x000fe400078efcffULL, 0x000000a8001a7306ULL, 0x0002e20000205400ULL,
0x000000666400720bULL, 0x004fce0003f9d000ULL, 0x0000009f001b7306ULL, 0x000fe20000209400ULL,
0x000000a800a87245ULL, 0x002fca000020d400ULL, 0x0000000100004812ULL, 0x000fe400078efcffULL,
0x0000009f00587306ULL, 0x000e620000205400ULL, 0x0000001a1800720bULL, 0x008fe40003f3d000ULL,
0x0000007f6c18723eULL, 0x000fd600000010ffULL, 0x00000001a8a81812ULL, 0x000fe400078efcffULL,
0x000000581b00720bULL, 0x002fe40003f5d000ULL, 0x000000a86060723eULL, 0x000fe200000010ffULL,
0x000000182018723cULL, 0x000ff40000041848ULL, 0x0000000161612812ULL, 0x000fc800078efcffULL,
0x000000610061723eULL, 0x000fce00000010ffULL, 0x000000602020723cULL, 0x000fe2000004184cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff487f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c003007811ULL, 0x000fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff487224ULL, 0x002fe400078e0049ULL, 0x000000002400720cULL, 0x000fda0003f24070ULL,
0x00004da000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824848ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000497305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000490000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff497984ULL, 0x000e640000000800ULL, 0x8000000049ff7812ULL, 0x002fc40007824848ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000e003007811ULL, 0x000fe200078e40ffULL,
0x00000100ff597424ULL, 0x000fe200078e00ffULL, 0x00000004ff587819ULL, 0x000fe4000001162dULL,
0x0000000024487217ULL, 0x000fe20007800000ULL, 0x000062002b4a7a24ULL, 0x000fc800078e0200ULL,
0x0000000148487824ULL, 0x000fe400078e0a00ULL, 0x0000000135497824ULL, 0x100fe400078e024aULL,
0x00000001304b7824ULL, 0x000fe200078e024aULL, 0x0000002048007807ULL, 0x000fe20000000000ULL,
0x00005e0049487625ULL, 0x000fc600078e0059ULL, 0x000000002c007217ULL, 0x000fe20007800000ULL,
0x000000012f4c7824ULL, 0x100fe200078e024aULL, 0x00000034484e7210ULL, 0x000fe20007f1e0ffULL,
0x000000012e4d7824ULL, 0x000fe400078e024aULL, 0x0000000100007824ULL, 0x000fe400078e0a2cULL,
0x000000ffff4f7224ULL, 0x000fe400000e0649ULL, 0x00005e004b487625ULL, 0x000fe200078e0059ULL,
0x000000005800720cULL, 0x000fc40003f06070ULL, 0x000000003300720cULL, 0x080fe20003f26070ULL,
0x00005e004c4a7625ULL, 0x080fe200078e0059ULL, 0x000000003200720cULL, 0x080fe40003f46070ULL,
0x000000003100720cULL, 0x000fe20003f66070ULL, 0x00005e004d4c7625ULL, 0x000fe200078e0059ULL,
0x0000003448487210ULL, 0x080fe40007f9e0ffULL, 0x000000344a4a7210ULL, 0x080fe40007fbe0ffULL,
0x000000344c4c7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff497224ULL, 0x000fe200020e0649ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004e447faeULL, 0x0003e2000c101c46ULL,
0x000000ffff4b7224ULL, 0x000fc400028e064bULL, 0x000000ffff4d7224ULL, 0x000fe200030e064dULL,
0x0000000048437faeULL, 0x0003e8000c901c46ULL, 0x000000004a427faeULL, 0x0003e8000d101c46ULL,
0x000000004c417faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff587f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010668002c427f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007804857ULL, 0x01066c002c417984ULL, 0x000e640000000800ULL,
0x8000000041ff7812ULL, 0x002fe40007824843ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000417305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000410000735dULL, 0x008fe40003800000ULL,
0x01066c002c417984ULL, 0x000e640000000800ULL, 0x8000000041ff7812ULL, 0x002fc40007824843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101800040417984ULL, 0x000e680000000800ULL,
0x0103800040427984ULL, 0x0007220000000800ULL, 0x0000002a4100720bULL, 0x002fe20003f3d000ULL,
0x0000e1227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff00437812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ffcb7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000032500780cULL, 0x000fe40003f45270ULL, 0x0000002a4100720bULL, 0x000fe20003f34000ULL,
0x0000e0e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x000000412a3f7209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fc600078e3cffULL,
0x8000003f2a2a7221ULL, 0x000fe20000010000ULL, 0x0105803f4000a388ULL, 0x0003e20000000800ULL,
0x0000000043ff7212ULL, 0x000fe4000782c0ffULL, 0x3fb8aa3b2a2a7820ULL, 0x000fe20000410000ULL,
0x00000002ff007819ULL, 0x000fca000001162dULL, 0x0000002a002a7308ULL, 0x000ee40000000800ULL,
0x0000002a29297220ULL, 0x008fe20000410000ULL, 0x0000e0727f007947ULL, 0x000fea000b800000ULL,
0x00001f002a007589ULL, 0x0022e400000e0000ULL, 0x0000000004047220ULL, 0x08cfe20000410000ULL,
0x0000000005057220ULL, 0x080fe20000410000ULL, 0x0000000008087220ULL, 0x080fe20000410000ULL,
0x0000000009097220ULL, 0x080fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000d0d7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000020207220ULL, 0x080fe20000410000ULL,
0x0000000021217220ULL, 0x000fe20000410000ULL, 0x0000dfc27f007947ULL, 0x000fea000b800000ULL,
0x00001f382a007589ULL, 0x0004e400000e0000ULL, 0x8000003f41411221ULL, 0x100fe20000010000ULL,
0x00000001ffcb7807ULL, 0x000fe20000800000ULL, 0x0000000006067220ULL, 0x08cfe20000410000ULL,
0x0000000007077220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b41411820ULL, 0x000fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x0000004100261308ULL, 0x000ea20000000800ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x000fe20000410000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e003fULL,
0x0000004226421220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002942297221ULL, 0x010fe20000010000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x00000000003f7305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x0000003f0000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff3f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x002fe40007804857ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000026ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff607819ULL, 0x000fc4000001162dULL,
0x0000541000627816ULL, 0x000fe20000000000ULL, 0x0000dd727f007947ULL, 0x000fea000b800000ULL,
0x00001f6062607589ULL, 0x0002e400000e0000ULL, 0x0000ddc27f007947ULL, 0x000fea000b800000ULL,
0x00001f38625c7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x000fe200078e0037ULL, 0x00010610005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0000e4c000007944ULL, 0x01efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff637224ULL, 0x000fe200078e0036ULL, 0x00010670005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0000e46000007944ULL, 0x01efea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003e40783bULL, 0x000f620000004200ULL, 0x0000b8003a3a7811ULL, 0x000fc600078e20ffULL,
0x000000003d48783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000ee80000004200ULL,
0x000000003b4c783bULL, 0x000ea20000004200ULL, 0x0000010040dc7824ULL, 0x060fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fe20000011440ULL, 0x0000004100d47306ULL, 0x000fe20000009400ULL,
0x0001000040dd7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011443ULL,
0x0001000041c57824ULL, 0x040fe200078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe200000114dcULL,
0x0000010041ce7824ULL, 0x000fe200078e00ffULL, 0x00000018ffdd7819ULL, 0x000fe200000114ddULL,
0x0000010048b17824ULL, 0x050fe200078e00ffULL, 0x000000dc00d37306ULL, 0x000fe20000209400ULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x0001000048b67824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe20000011441ULL, 0x000001004bbd7824ULL, 0x040fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x000001004abc7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x000000dc00e37306ULL, 0x000f220000205400ULL,
0x00000018ffaa7819ULL, 0x000fe20000011442ULL, 0x000100004ac77824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011448ULL, 0x000100004bcc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x0000010049b27824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe200000114bdULL, 0x0000004100db7306ULL, 0x000f620000005400ULL,
0x00000018ff977819ULL, 0x000fe2000001144aULL, 0x000100003ce57824ULL, 0x008fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x000001003de67824ULL, 0x040fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe2000001144bULL, 0x000100003de47824ULL, 0x000fe200078e00ffULL,
0x00000018ffcc7819ULL, 0x000fe200000114ccULL, 0x000000d700da7306ULL, 0x000fe20000209400ULL,
0x000000e3d300720bULL, 0x010fe20003f9d000ULL, 0x000001003ed57824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001143cULL, 0x0001000049bf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fc400000114b2ULL, 0x00000018ffa67819ULL, 0x000fe20000011449ULL,
0x000000d700d97306ULL, 0x0007220000205400ULL, 0x000000dbd400720bULL, 0x020fe40003fbd000ULL,
0x000000dc00d47245ULL, 0x000fe4000020d400ULL, 0x00000018ff7a7819ULL, 0x000fe4000001143dULL,
0x00000001d4d44812ULL, 0x000fe200078efcffULL, 0x0000004000cf7306ULL, 0x000fe20000009400ULL,
0x000000d700d77245ULL, 0x008fc4000020d400ULL, 0x00000018ff737819ULL, 0x000fe4000001143eULL,
0x00000018ff6f7819ULL, 0x000fe4000001143fULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x0000004000d07306ULL, 0x000ee20000005400ULL, 0x000000d9da00720bULL, 0x010fe40003f5d000ULL,
0x00000018ffc77819ULL, 0x000fe400000114c7ULL, 0x00000018ffd57819ULL, 0x000fc400000114d5ULL,
0x00000018ffe47819ULL, 0x000fe200000114e4ULL, 0x0000004200d67306ULL, 0x000fe20000009400ULL,
0x00000018ff657819ULL, 0x004fe4000001144cULL, 0x00000018ff5b7819ULL, 0x000fe4000001144dULL,
0x00000018ff007819ULL, 0x000fe4000001144eULL, 0x00000001d7d72812ULL, 0x000fe200078efcffULL,
0x0000004200d87306ULL, 0x000ea20000005400ULL, 0x000000d0cf00720bULL, 0x008fe20003f3d000ULL,
0x000001004ccf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001144fULL,
0x000001004dd07824ULL, 0x000fc600078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x000000dd00e27306ULL, 0x000fe20000209400ULL, 0x00000018ffd07819ULL, 0x000fce00000114d0ULL,
0x000000dd00d27306ULL, 0x000ee20000205400ULL, 0x000000d8d600720bULL, 0x004fe40003f9d000ULL,
0x000000dd00d67245ULL, 0x000fca000020d400ULL, 0x0000004300ae7306ULL, 0x000ff00000009400ULL,
0x0000004300a17306ULL, 0x000ea20000005400ULL, 0x000000d2e200720bULL, 0x008fe40003fdd000ULL,
0x00000018ffd27819ULL, 0x000fca00000114e6ULL, 0x0000004000787306ULL, 0x00072c000000d400ULL,
0x00000001d6d66812ULL, 0x000fe400078efcffULL, 0x0000004200757306ULL, 0x000f62000000d400ULL,
0x0000010043407824ULL, 0x008fe200078e00ffULL, 0x000000a1ae00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x000000c500e07306ULL, 0x000fe20000209400ULL,
0x0000000178781812ULL, 0x010fce00078efcffULL, 0x000000c500e17306ULL, 0x0004e20000205400ULL,
0x0000000175754812ULL, 0x020fce00078efcffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x000000c500c57245ULL, 0x004fce000020d400ULL, 0x0000009300a27306ULL, 0x0005220000205400ULL,
0x000000e1e000720bULL, 0x008fce0003f3d000ULL, 0x000000ad009a7306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x004fca000020d400ULL, 0x00000001c5c51812ULL, 0x000fe400078efcffULL,
0x000000ad00917306ULL, 0x0004e20000205400ULL, 0x000000a29400720bULL, 0x010fce0003f9d000ULL,
0x000000ce00de7306ULL, 0x000fe20000209400ULL, 0x000000ad00ad7245ULL, 0x004fca000020d400ULL,
0x0000000193934812ULL, 0x000fe400078efcffULL, 0x000000ce00df7306ULL, 0x0005220000205400ULL,
0x000000919a00720bULL, 0x008fe40003fdd000ULL, 0x00000018ff9a7819ULL, 0x000fca00000114e5ULL,
0x0000004100877306ULL, 0x000762000000d400ULL, 0x000000ce00ce7245ULL, 0x004fca000020d400ULL,
0x00000001adad6812ULL, 0x000fe400078efcffULL, 0x0000004300747306ULL, 0x000462000000d400ULL,
0x0000010042417824ULL, 0x008fe200078e00ffULL, 0x000000dfde00720bULL, 0x010fe20003f7d000ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x000000c5adad723eULL, 0x000fe400000010ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x000000b100b47306ULL, 0x000fe20000209400ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0001000043437824ULL, 0x004fe200078e00ffULL,
0x0000000187875812ULL, 0x020fc400078efcffULL, 0x0000004200947245ULL, 0x000fe4000020d400ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x000000b100b57306ULL, 0x0004e20000205400ULL,
0x0000000174742812ULL, 0x002fe400078efcffULL, 0x00000001cece3812ULL, 0x000fe400078efcffULL,
0x0000004100917245ULL, 0x000fc6000020d400ULL, 0x0000004000af7306ULL, 0x000fe20000209400ULL,
0x000000b100b17245ULL, 0x004fce000020d400ULL, 0x0000004000c67306ULL, 0x000e620000205400ULL,
0x000000b5b400720bULL, 0x008fce0003f5d000ULL, 0x0000004800ac7306ULL, 0x000fec0000009400ULL,
0x00000001b1b12812ULL, 0x000fe400078efcffULL, 0x0000004800997306ULL, 0x000ea20000005400ULL,
0x000000c6af00720bULL, 0x002fce0003fbd000ULL, 0x0000009d00a87306ULL, 0x000ff00000209400ULL,
0x0000009d00a97306ULL, 0x0002e20000205400ULL, 0x00000099ac00720bULL, 0x004fe40003f3d000ULL,
0x0000004000997245ULL, 0x000fc4000020d400ULL, 0x000000d6d7ac723eULL, 0x000fe400000010ffULL,
0x0000000199995812ULL, 0x000fe200078efcffULL, 0x0000004200b07306ULL, 0x000fe20000209400ULL,
0x0000009d009d7245ULL, 0x002fe4000020d400ULL, 0x000000749999723eULL, 0x000fca00000010ffULL,
0x0000004200c47306ULL, 0x000e620000205400ULL, 0x000000a9a800720bULL, 0x008fce0003f9d000ULL,
0x0000004100c97306ULL, 0x000fec0000209400ULL, 0x000000019d9d4812ULL, 0x000fe400078efcffULL,
0x0000004100ca7306ULL, 0x000ea20000205400ULL, 0x000000c4b000720bULL, 0x002fce0003fdd000ULL,
0x000000b600b77306ULL, 0x000fec0000209400ULL, 0x0000000194946812ULL, 0x000fe400078efcffULL,
0x000000b600c37306ULL, 0x0002e20000205400ULL, 0x000000cac900720bULL, 0x004fce0003f7d000ULL,
0x0000004800707306ULL, 0x000522000000d400ULL, 0x000000b600b67245ULL, 0x002fca000020d400ULL,
0x0000000191913812ULL, 0x000fe400078efcffULL, 0x0000004300b97306ULL, 0x000fe20000209400ULL,
0x00009910cb487816ULL, 0x004fe200000000ffULL, 0x000001003ccb7824ULL, 0x000fe200078e00ffULL,
0x000000c3b700720bULL, 0x008fe40003f5d000ULL, 0x000000ff4800720cULL, 0x000fe20003f05270ULL,
0x000001004f487824ULL, 0x000fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x0000004300ba7306ULL, 0x000e620000205400ULL, 0x0000000170701812ULL, 0x010fc800078efcffULL,
0x00000070b170723eULL, 0x000fc600000010ffULL, 0x0000004a008e7306ULL, 0x000fe20000009400ULL,
0x00000001b6b62812ULL, 0x000fc800078efcffULL, 0x000000b69db6723eULL, 0x000fc600000010ffULL,
0x0000004a00a07306ULL, 0x000fe20000005400ULL, 0x000000bab900720bULL, 0x002fce0003fbd000ULL,
0x0000004a006b7306ULL, 0x000ff0000000d400ULL, 0x0000004b00927306ULL, 0x000ff00000009400ULL,
0x0000004b00957306ULL, 0x000e700000005400ULL, 0x000000bd00be7306ULL, 0x000ff00000209400ULL,
0x000000bd004a7306ULL, 0x0004e20000205400ULL, 0x000000959200720bULL, 0x002fce0003f3d000ULL,
0x00000049008f7306ULL, 0x000fe20000009400ULL, 0x000000bd00bd7245ULL, 0x004fce000020d400ULL,
0x0000004900a37306ULL, 0x000e620000005400ULL, 0x0000004abe00720bULL, 0x008fce0003f9d000ULL,
0x000000aa00ab7306ULL, 0x000fec0000209400ULL, 0x00000001bdbd4812ULL, 0x000fe400078efcffULL,
0x000000aa009f7306ULL, 0x0004e20000205400ULL, 0x000000a38f00720bULL, 0x002fe40003fdd000ULL,
0x00000043008f7245ULL, 0x000fc8000020d400ULL, 0x000000018f8f5812ULL, 0x000fe200078efcffULL,
0x000000bc00c07306ULL, 0x000fe20000209400ULL, 0x000000a08e00720bULL, 0x000fe40003fbd000ULL,
0x000000aa00aa7245ULL, 0x004fe4000020d400ULL, 0x0000008f938f723eULL, 0x000fc600000010ffULL,
0x000000bc00bb7306ULL, 0x0002a20000205400ULL, 0x0000009fab00720bULL, 0x008fca0003f7d000ULL,
0x000000016b6b5812ULL, 0x000fe400078efcffULL, 0x0000004b006a7306ULL, 0x000ee2000000d400ULL,
0x000000bc00bc7245ULL, 0x002fca000020d400ULL, 0x00000001aaaa3812ULL, 0x000fe400078efcffULL,
0x0000003c008d7306ULL, 0x000fe20000009400ULL, 0x000000bbc000720bULL, 0x004fce0003f5d000ULL,
0x0000003c009e7306ULL, 0x000fe20000005400ULL, 0x000000016a6a1812ULL, 0x008fc800078efcffULL,
0x0000006abdbd723eULL, 0x000fe400000010ffULL, 0x00000001bcbc2812ULL, 0x000fe200078efcffULL,
0x0000003c00677306ULL, 0x000fe6000000d400ULL, 0x0000006bbcbc723eULL, 0x000fca00000010ffULL,
0x0000008200967306ULL, 0x000ff00000209400ULL, 0x00000082009c7306ULL, 0x0002b00000205400ULL,
0x000000cc00cd7306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x002fce000020d400ULL,
0x000000cc003c7306ULL, 0x0002e20000205400ULL, 0x0000009c9600720bULL, 0x004fce0003f3d000ULL,
0x000000b200b37306ULL, 0x000fe20000209400ULL, 0x000000cc00cc7245ULL, 0x002fca000020d400ULL,
0x0000000182821812ULL, 0x000fe400078efcffULL, 0x000000b200b87306ULL, 0x0002a20000205400ULL,
0x0000003ccd00720bULL, 0x008fce0003f9d000ULL, 0x0000003d00907306ULL, 0x000fe20000009400ULL,
0x000000b200b27245ULL, 0x002fca000020d400ULL, 0x00000001cccc4812ULL, 0x000fe400078efcffULL,
0x0000003d009b7306ULL, 0x000e620000005400ULL, 0x000000b8b300720bULL, 0x004fce0003f7d000ULL,
0x0000003d00667306ULL, 0x0005ec000000d400ULL, 0x00000001b2b23812ULL, 0x000fe400078efcffULL,
0x00000049006e7306ULL, 0x000722000000d400ULL, 0x000001003f3d7824ULL, 0x004fe200078e00ffULL,
0x0000009b9000720bULL, 0x002fc40003f5d000ULL, 0x000000e4009b7245ULL, 0x000fe4000020d400ULL,
0x00000018ff927819ULL, 0x000fe4000001143dULL, 0x0000003e00837306ULL, 0x000fe20000009400ULL,
0x000001004e497824ULL, 0x008fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011449ULL,
0x0000003e00847306ULL, 0x000e620000005400ULL, 0x000000016e6e6812ULL, 0x010fe400078efcffULL,
0x0000000166662812ULL, 0x000fe400078efcffULL, 0x000000cc8249723eULL, 0x000fc600000010ffULL,
0x0000003e00637306ULL, 0x0004f0000000d400ULL, 0x0000003f007e7306ULL, 0x000fe20000009400ULL,
0x000100003e3e7824ULL, 0x004fe200078e00ffULL, 0x000000848300720bULL, 0x002fc80003f9d000ULL,
0x00000018ff4a7819ULL, 0x000fe4000001143eULL, 0x0000003f00867306ULL, 0x000fee0000005400ULL,
0x0000000163634812ULL, 0x008fe200078efcffULL, 0x0000003f00647306ULL, 0x0003f0000000d400ULL,
0x000000a600a77306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff967819ULL, 0x000fe4000001143fULL, 0x000000a600987306ULL, 0x0002a20000205400ULL,
0x000000003a3c783bULL, 0x000eee0000000200ULL, 0x0000009700a47306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fce000020d400ULL, 0x0000009700a57306ULL, 0x0003220000205400ULL,
0x00000098a700720bULL, 0x004fce0003fdd000ULL, 0x000000bf00c17306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fca000020d400ULL, 0x00000001a6a66812ULL, 0x000fe400078efcffULL,
0x000000bf00c27306ULL, 0x0002a20000205400ULL, 0x000000a5a400720bULL, 0x010fce0003fbd000ULL,
0x000000c700c87306ULL, 0x000fe20000209400ULL, 0x000000bf00bf7245ULL, 0x002fe2000020d400ULL,
0x000000603c3c8231ULL, 0x088fe400003400ffULL, 0x000000603e3e8231ULL, 0x000fe400003400ffULL,
0x0000000197975812ULL, 0x000fe200078efcffULL, 0x0000005c3d3d8231ULL, 0x080fe200003400ffULL,
0x000000c7004b7306ULL, 0x0002e20000205400ULL, 0x000000c2c100720bULL, 0x004fe20003f7d000ULL,
0x0000005c3f3f8231ULL, 0x000fcc00003400ffULL, 0x000000d500437306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x002fe2000020d400ULL, 0x000000ac3c08723cULL, 0x040fe80000041808ULL,
0x00000001bfbf3812ULL, 0x000fe400078efcffULL, 0x000000d5008e7306ULL, 0x0002a20000205400ULL,
0x0000004bc800720bULL, 0x008fe20003fdd000ULL, 0x000000bc3c1c723cULL, 0x000fe2000004181cULL,
0x000000d2004b7245ULL, 0x000fc4000020d400ULL, 0x0000009e8d00720bULL, 0x000fe40003f7d000ULL,
0x000000bfa6b7723eULL, 0x000fe200000010ffULL, 0x000000d200d97306ULL, 0x000fe20000209400ULL,
0x000000d500d57245ULL, 0x002fca000020d400ULL, 0x00000001c7c76812ULL, 0x000fe200078efcffULL,
0x000000b63c18723cULL, 0x000fe20000041818ULL, 0x000000d200d87306ULL, 0x000e620000205400ULL,
0x0000008e4300720bULL, 0x004fe40003f5d000ULL, 0x0000000167673812ULL, 0x000fe400078efcffULL,
0x00000094aa8e723eULL, 0x000fc600000010ffULL, 0x0000009a00a17306ULL, 0x000fe80000209400ULL,
0x0000008e3c10723cULL, 0x000fe40000041810ULL, 0x00000001d5d52812ULL, 0x000fe400078efcffULL,
0x0000009a00417306ULL, 0x0004e20000205400ULL, 0x000000d8d900720bULL, 0x002fce0003fbd000ULL,
0x000000cb00d17306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x004fca000020d400ULL,
0x000000014b4b5812ULL, 0x000fe400078efcffULL, 0x000000cb00d37306ULL, 0x0002a20000205400ULL,
0x00000041a100720bULL, 0x008fe40003f3d000ULL, 0x00000087ce41723eULL, 0x000fe400000010ffULL,
0x000000664b4b723eULL, 0x000fc600000010ffULL, 0x0000009200957306ULL, 0x000fe20000209400ULL,
0x000000cb00cb7245ULL, 0x002fca000020d400ULL, 0x000000019a9a1812ULL, 0x000fe400078efcffULL,
0x0000009200987306ULL, 0x0002e20000205400ULL, 0x000000d3d100720bULL, 0x004fe40003fdd000ULL,
0x000000867e00720bULL, 0x000fca0003f3d000ULL, 0x000000e400407306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fca000020d400ULL, 0x00000001cbcb6812ULL, 0x000fe400078efcffULL,
0x000000e400427306ULL, 0x000e620000205400ULL, 0x000000989500720bULL, 0x008fe40003f5d000ULL,
0x0000000164641812ULL, 0x000fe400078efcffULL, 0x000000759198723eULL, 0x000fc600000010ffULL,
0x0000008b008c7306ULL, 0x000fe80000209400ULL, 0x000000983c0c723cULL, 0x000fe4000004180cULL,
0x0000000192922812ULL, 0x000fe400078efcffULL, 0x0000008b00857306ULL, 0x0004e20000205400ULL,
0x000000424000720bULL, 0x002fe40003fbd000ULL, 0x00000078d440723eULL, 0x000fca00000010ffULL,
0x0000004a008d7306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x004fe2000020d400ULL,
0x000000403c40723cULL, 0x000fe80000041804ULL, 0x000000019b9b5812ULL, 0x000fe400078efcffULL,
0x0000004a00907306ULL, 0x0002a20000205400ULL, 0x0000b80039047811ULL, 0x000fe400078e20ffULL,
0x000000858c00720bULL, 0x008fc40003fdd000ULL, 0x0000004a00397245ULL, 0x000fe4000020d400ULL,
0x000000000404783bULL, 0x000ee20000000200ULL, 0x0000007300777306ULL, 0x000fe20000209400ULL,
0x00000067cb4a723eULL, 0x002fce00000010ffULL, 0x0000007300767306ULL, 0x0003220000205400ULL,
0x000000908d00720bULL, 0x004fe40003f5d000ULL, 0x000000018b8b6812ULL, 0x000fc800078efcffULL,
0x0000009a8b9a723eULL, 0x000fe200000010ffULL, 0x0000007a00817306ULL, 0x000fe20000209400ULL,
0x0000007300737245ULL, 0x002fca000020d400ULL, 0x0000000139392812ULL, 0x000fe400078efcffULL,
0x0000007a007f7306ULL, 0x0002a20000205400ULL, 0x000000767700720bULL, 0x010fce0003f3d000ULL,
0x0000004c008a7306ULL, 0x000fe20000009400ULL, 0x0000007a007a7245ULL, 0x002fca000020d400ULL,
0x0000000173731812ULL, 0x000fe200078efcffULL, 0x0000006004048231ULL, 0x088fe200003400ffULL,
0x0000004c007d7306ULL, 0x000e620000005400ULL, 0x0000007f8100720bULL, 0x004fe20003f7d000ULL,
0x0000006006068231ULL, 0x000fe400003400ffULL, 0x0000005c05058231ULL, 0x080fe400003400ffULL,
0x0000005c07078231ULL, 0x000fe400003400ffULL, 0x0000004d00797306ULL, 0x000fea0000009400ULL,
0x0000004a0440723cULL, 0x000fe20000041840ULL, 0x000000017a7a3812ULL, 0x000fc400078efcffULL,
0x0000004d007b7306ULL, 0x000ea20000005400ULL, 0x0000007d8a00720bULL, 0x002fe40003fdd000ULL,
0x0000009b7a9b723eULL, 0x000fca00000010ffULL, 0x00000096009c7306ULL, 0x000fe40000209400ULL,
0x0000009a0408723cULL, 0x000fec0000041808ULL, 0x00000096003a7306ULL, 0x0002e20000205400ULL,
0x0000007b7900720bULL, 0x004fce0003fbd000ULL, 0x0000006f00717306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x002fce000020d400ULL, 0x0000006f00727306ULL, 0x0002a20000205400ULL,
0x0000003a9c00720bULL, 0x008fce0003f5d000ULL, 0x000000cf00837306ULL, 0x000fe20000209400ULL,
0x0000006f006f7245ULL, 0x002fca000020d400ULL, 0x0000000196962812ULL, 0x000fe400078efcffULL,
0x000000cf007f7306ULL, 0x0002e20000205400ULL, 0x000000727100720bULL, 0x004fe40003f3d000ULL,
0x0000006eb271723eULL, 0x000fca00000010ffULL, 0x0000004c005f7306ULL, 0x000522000000d400ULL,
0x000000cf00cf7245ULL, 0x002fe2000020d400ULL, 0x000000703c14723cULL, 0x000fe80000041814ULL,
0x000000016f6f1812ULL, 0x000fe400078efcffULL, 0x00000065006d7306ULL, 0x000fe20000209400ULL,
0x000100004c4c7824ULL, 0x004fe200078e00ffULL, 0x0000007f8300720bULL, 0x008fc80003f5d000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000065006c7306ULL, 0x0002a20000205400ULL,
0x000000015f5f6812ULL, 0x010fcc00078efcffULL, 0x00000001cfcf2812ULL, 0x000fe200078efcffULL,
0x000000d0007d7306ULL, 0x000fe20000209400ULL, 0x0000006500657245ULL, 0x002fce000020d400ULL,
0x000000d0007b7306ULL, 0x0002e20000205400ULL, 0x0000006c6d00720bULL, 0x004fe40003f3d000ULL,
0x00000018ff6c7819ULL, 0x000fe40000011448ULL, 0x000000c79748723eULL, 0x000fc600000010ffULL,
0x0000004d005a7306ULL, 0x000522000000d400ULL, 0x000000d000d07245ULL, 0x002fc6000020d400ULL,
0x000000483c20723cULL, 0x000fe40000041820ULL, 0x0000000165651812ULL, 0x000fe400078efcffULL,
0x0000005b00697306ULL, 0x000fe20000209400ULL, 0x000100004d4d7824ULL, 0x004fe200078e00ffULL,
0x0000007b7d00720bULL, 0x008fe40003fdd000ULL, 0x00000039733e723eULL, 0x000fe400000010ffULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x0000005b00687306ULL, 0x0002a20000205400ULL,
0x000000015a5a5812ULL, 0x010fe400078efcffULL, 0x00000063d53c723eULL, 0x000fe400000010ffULL,
0x00000064923d723eULL, 0x000fe400000010ffULL, 0x00000001d0d06812ULL, 0x000fe200078efcffULL,
0x0000004d00757306ULL, 0x000fe20000209400ULL, 0x0000005b005b7245ULL, 0x002fe4000020d400ULL,
0x000000966f3f723eULL, 0x000fe200000010ffULL, 0x0000003c040c723cULL, 0x000fe8000004180cULL,
0x0000004d003a7306ULL, 0x0002e20000205400ULL, 0x000000686900720bULL, 0x004fc40003f5d000ULL,
0x0000005fcf3c723eULL, 0x000fe200000010ffULL, 0x0000003e0410723cULL, 0x000fe20000041810ULL,
0x0000005ad03d723eULL, 0x000fc600000010ffULL, 0x0000004e00887306ULL, 0x000fe20000009400ULL,
0x0000004d004d7245ULL, 0x002fc6000020d400ULL, 0x0000003c0414723cULL, 0x000fe40000041814ULL,
0x000000015b5b2812ULL, 0x000fe400078efcffULL, 0x0000004e00897306ULL, 0x000e620000005400ULL,
0x0000003a7500720bULL, 0x008fe40003fbd000ULL, 0x0000006c00757245ULL, 0x000fca000020d400ULL,
0x0000004c00787306ULL, 0x000fec0000209400ULL, 0x000000014d4d5812ULL, 0x000fe400078efcffULL,
0x0000004c00797306ULL, 0x0004e20000205400ULL, 0x000000898800720bULL, 0x002fe40003f7d000ULL,
0x0000004d5b4d723eULL, 0x000fca00000010ffULL, 0x0000007400727306ULL, 0x000fe20000209400ULL,
0x0000004c004c7245ULL, 0x004fce000020d400ULL, 0x00000074006e7306ULL, 0x0002a20000205400ULL,
0x000000797800720bULL, 0x008fce0003fdd000ULL, 0x0000004e00447306ULL, 0x000722000000d400ULL,
0x0000007400747245ULL, 0x002fca000020d400ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x0000004f00807306ULL, 0x000fe20000009400ULL, 0x000100004e4e7824ULL, 0x008fe200078e00ffULL,
0x0000006e7200720bULL, 0x004fe40003f3d000ULL, 0x0000004c654c723eULL, 0x000fe400000010ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000004f007c7306ULL, 0x000e620000005400ULL,
0x0000000144443812ULL, 0x010fc400078efcffULL, 0x0000004c0418723cULL, 0x000fe80000041818ULL,
0x0000000174741812ULL, 0x000fe200078efcffULL, 0x0000004f00577306ULL, 0x0004e6000000d400ULL,
0x000000447474723eULL, 0x000fca00000010ffULL, 0x0000000000627306ULL, 0x000fe20000209400ULL,
0x000100004f4f7824ULL, 0x004fe200078e00ffULL, 0x0000007c8000720bULL, 0x002fc80003f9d000ULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x0000000000617306ULL, 0x0002ae0000205400ULL,
0x0000000157574812ULL, 0x008fe200078efcffULL, 0x0000003b005d7306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x002fce000020d400ULL, 0x0000003b005e7306ULL, 0x0002e20000205400ULL,
0x000000616200720bULL, 0x004fce0003fdd000ULL, 0x0000006c006a7306ULL, 0x000fe20000209400ULL,
0x0000003b003b7245ULL, 0x002fca000020d400ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x0000006c00687306ULL, 0x000e620000205400ULL, 0x0000005e5d00720bULL, 0x008fce0003fbd000ULL,
0x0000004e00607306ULL, 0x000fec0000209400ULL, 0x000000013b3b5812ULL, 0x000fe400078efcffULL,
0x0000004e003a7306ULL, 0x0004e20000205400ULL, 0x000000686a00720bULL, 0x002fce0003f5d000ULL,
0x0000004f00487306ULL, 0x000fe20000209400ULL, 0x0000004e004e7245ULL, 0x004fca000020d400ULL,
0x0000000175752812ULL, 0x000fe400078efcffULL, 0x0000004f00397306ULL, 0x0002a20000205400ULL,
0x0000003a6000720bULL, 0x008fe40003f3d000ULL, 0x000000577575723eULL, 0x000fe400000010ffULL,
0x0000004f004f7245ULL, 0x002fca000020d400ULL, 0x00000074041c723cULL, 0x000fe8000004181cULL,
0x000000014e4e1812ULL, 0x000fe400078efcffULL, 0x000000394800720bULL, 0x004fe40003f7d000ULL,
0x0000004e004e723eULL, 0x000fd600000010ffULL, 0x000000014f4f3812ULL, 0x000fc800078efcffULL,
0x0000004f3b4f723eULL, 0x000fce00000010ffULL, 0x0000004e0420723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff047f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007824805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007824805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000030003007a10ULL, 0x000fe20007ffe0ffULL, 0x00000100ff397424ULL, 0x000fc600078e00ffULL,
0x0000000100057810ULL, 0x040fe20007ffe0ffULL, 0x0000010000047824ULL, 0x000fc600078e00ffULL,
0x000000020500720cULL, 0x000fe20003f26070ULL, 0x000062002b007a24ULL, 0x000fe200078e0204ULL,
0x0000000424067217ULL, 0x000fc60007800000ULL, 0x0000000130077824ULL, 0x000fe400078e0200ULL,
0x0000000106067824ULL, 0x000fe400078e0a04ULL, 0x0000000135047824ULL, 0x100fe200078e0200ULL,
0x00000004ff357819ULL, 0x000fe2000001162dULL, 0x000000012e2e7824ULL, 0x000fe200078e0200ULL,
0x0000002006067807ULL, 0x000fe20000800000ULL, 0x00005e0004047625ULL, 0x000fc600078e0039ULL,
0x000000062c307217ULL, 0x000fe20007800000ULL, 0x00005e0007067625ULL, 0x000fe200078e0039ULL,
0x00000034043a7210ULL, 0x000fc60007f3e0ffULL, 0x0000000130307824ULL, 0x000fe200078e0a2cULL,
0x0000003406067210ULL, 0x000fe20007f7e0ffULL, 0x000000012f047824ULL, 0x000fe400078e0200ULL,
0x000000ffff3b7224ULL, 0x000fe200008e0605ULL, 0x000000303500720cULL, 0x080fe20003f46070ULL,
0x00005e0004047625ULL, 0x080fe200078e0039ULL, 0x000000303300720cULL, 0x080fe40003f26070ULL,
0x000000303100720cULL, 0x000fe20003f86070ULL, 0x00005e002e2e7625ULL, 0x000fe200078e0039ULL,
0x0000003404047210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200018e0607ULL,
0x000000303200720cULL, 0x000fe20003f66070ULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0x000000342e347210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000d101c46ULL, 0x000000ffff357224ULL, 0x000fe200030e062fULL,
0x0000000006467faeULL, 0x0003ea000c901c46ULL, 0x0000000004477faeULL, 0x0003e8000d901c46ULL,
0x0000000034507faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff047f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007824859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff577224ULL, 0x000fe200078e0005ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x0106b400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc40007824859ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000026ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff5e7819ULL, 0x000fe4000001162dULL, 0x0000541000627816ULL, 0x000fe20000000000ULL,
0x0000ba427f007947ULL, 0x000fea000b800000ULL, 0x00001f5e625e7589ULL, 0x0002a400000e0000ULL,
0x0000ba927f007947ULL, 0x000fea000b800000ULL, 0x00001f38625f7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff637224ULL, 0x000fe200078e0037ULL,
0x00012a20005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x0000c0b000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff637224ULL, 0x000fe200078e0036ULL,
0x00012a80005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x0000c05000007944ULL, 0x01efea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005504783bULL, 0x000f680000004200ULL,
0x000000005630783bULL, 0x000e680000004200ULL, 0x000000005134783bULL, 0x000ee80000004200ULL,
0x000000005238783bULL, 0x008ee20000004200ULL, 0x00000100048d7824ULL, 0x020fe200078e00ffULL,
0x0000000400a17306ULL, 0x000fe20000009400ULL, 0x00000018ffae7819ULL, 0x000fe20000011404ULL,
0x0001000007a87824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x000fe20000011405ULL,
0x0000010030a47824ULL, 0x002fe200078e00ffULL, 0x00000018ffa67819ULL, 0x000fe2000001148dULL,
0x0001000031907824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe20000011406ULL,
0x0000000400a27306ULL, 0x000e620000005400ULL, 0x00000018ffa47819ULL, 0x000fe200000114a4ULL,
0x00000100328d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe20000011407ULL,
0x0001000032917824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011430ULL,
0x00000100338f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe20000011431ULL,
0x00000004006b7306ULL, 0x000b22000000d400ULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x0001000033937824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000010037d07824ULL, 0x000fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0001000036cf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011491ULL,
0x000000a600a37306ULL, 0x000fe20000209400ULL, 0x0001000004047824ULL, 0x020fe200078e00ffULL,
0x000000a2a100720bULL, 0x002fe20003f9d000ULL, 0x0000010034977824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011432ULL, 0x0000010036ce7824ULL, 0x000fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fe20000011404ULL, 0x0000010005047824ULL, 0x000fe200078e00ffULL,
0x000000a600a57306ULL, 0x0003620000205400ULL, 0x00000018ff7c7819ULL, 0x000fe20000011433ULL,
0x0000010038a17824ULL, 0x008fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001148fULL,
0x0001000035cd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fe20000011404ULL,
0x0000010006047824ULL, 0x000fe200078e00ffULL, 0x000000016b6b4812ULL, 0x010fe200078efcffULL,
0x0000000500b17306ULL, 0x000fe20000009400ULL, 0x000000a600a67245ULL, 0x002fe2000020d400ULL,
0x0000010039a27824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe20000011404ULL,
0x0000010007047824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fc40000011435ULL,
0x00000018ff937819ULL, 0x000fe20000011493ULL, 0x0000000500b27306ULL, 0x000e620000005400ULL,
0x000000a5a300720bULL, 0x020fe40003fdd000ULL, 0x00000018ffc37819ULL, 0x000fe20000011404ULL,
0x0000010031047824ULL, 0x000fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe400000114d0ULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x00000005006a7306ULL, 0x000722000000d400ULL,
0x00000018ff047819ULL, 0x000fc40000011404ULL, 0x00000018ff697819ULL, 0x000fe40000011434ULL,
0x00000018ff977819ULL, 0x000fe40000011497ULL, 0x00000001a6a66812ULL, 0x000fe200078efcffULL,
0x000000b300b47306ULL, 0x000fe20000209400ULL, 0x0001000005057824ULL, 0x008fe200078e00ffULL,
0x000000b2b100720bULL, 0x002fe40003f7d000ULL, 0x00000018ff597819ULL, 0x000fe40000011436ULL,
0x00000018ffb67819ULL, 0x000fc40000011405ULL, 0x000000b300b57306ULL, 0x000e620000205400ULL,
0x00000018ff507819ULL, 0x000fe40000011437ULL, 0x00000018ffa17819ULL, 0x000fe400000114a1ULL,
0x00000018ff3e7819ULL, 0x000fe40000011439ULL, 0x000000016a6a3812ULL, 0x010fe200078efcffULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x00000018ffcd7819ULL, 0x000fe400000114cdULL,
0x0000006ba6a6723eULL, 0x000fc400000010ffULL, 0x00000018ff467819ULL, 0x000fe40000011438ULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x000000ae00b07306ULL, 0x000ee20000205400ULL,
0x000000b5b400720bULL, 0x002fe40003fdd000ULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x00000018ff2e7819ULL, 0x000fe4000001143aULL, 0x00000018ff007819ULL, 0x004fe2000001143bULL,
0x000000ac00aa7306ULL, 0x000ff00000209400ULL, 0x000000ac00ad7306ULL, 0x0002a20000205400ULL,
0x000000b0af00720bULL, 0x008fce0003f5d000ULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fce000020d400ULL, 0x000000b600b87306ULL, 0x000e620000205400ULL,
0x000000adaa00720bULL, 0x004fe40003f3d000ULL, 0x000000ae00ad7245ULL, 0x000fe4000020d400ULL,
0x000000b300ae7245ULL, 0x000fe4000020d400ULL, 0x00000001adad2812ULL, 0x000fe200078efcffULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x00000001aeae6812ULL, 0x000fca00078efcffULL,
0x00000001acac1812ULL, 0x000fe400078efcffULL, 0x000000bd00bf7306ULL, 0x000ea20000205400ULL,
0x000000b8b700720bULL, 0x002fce0003f9d000ULL, 0x0000000700a77306ULL, 0x000ff00000009400ULL,
0x0000000700a97306ULL, 0x000e620000005400ULL, 0x000000bfbe00720bULL, 0x004fce0003fdd000ULL,
0x000000a000b97306ULL, 0x000ff00000209400ULL, 0x000000a000ba7306ULL, 0x0004e20000205400ULL,
0x000000a9a700720bULL, 0x002fe40003f5d000ULL, 0x000000b600a97245ULL, 0x000fc8000020d400ULL,
0x00000001a9a94812ULL, 0x000fe200078efcffULL, 0x0000000600bb7306ULL, 0x000fe20000009400ULL,
0x000000a000a07245ULL, 0x004fce000020d400ULL, 0x0000000600bc7306ULL, 0x000e620000005400ULL,
0x000000bab900720bULL, 0x008fce0003f3d000ULL, 0x00000030009f7306ULL, 0x000fec0000009400ULL,
0x00000001a0a01812ULL, 0x000fe400078efcffULL, 0x00000030009c7306ULL, 0x000ea20000005400ULL,
0x000000bcbb00720bULL, 0x002fe40003fbd000ULL, 0x000000a9a0a9723eULL, 0x000fca00000010ffULL,
0x0000000600617306ULL, 0x0002f0000000d400ULL, 0x0000008e00967306ULL, 0x000fe20000209400ULL,
0x0001000006067824ULL, 0x002fe200078e00ffULL, 0x0000009c9f00720bULL, 0x004fc40003f9d000ULL,
0x000000bd009f7245ULL, 0x000fe4000020d400ULL, 0x00000018ffc07819ULL, 0x000fe40000011406ULL,
0x0000008e00927306ULL, 0x0002a20000205400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x0000000161615812ULL, 0x008fe400078efcffULL, 0x000000c3009c7245ULL, 0x000fc6000020d400ULL,
0x0000000700607306ULL, 0x000722000000d400ULL, 0x0000008e008e7245ULL, 0x002fce000020d400ULL,
0x000000c000c17306ULL, 0x000fe20000209400ULL, 0x0001000030077824ULL, 0x008fe200078e00ffULL,
0x000000929600720bULL, 0x004fc80003fdd000ULL, 0x00000018ff077819ULL, 0x000fe40000011407ULL,
0x000000c000c27306ULL, 0x0002a20000205400ULL, 0x0000000160602812ULL, 0x010fcc00078efcffULL,
0x000000018e8e6812ULL, 0x000fe200078efcffULL, 0x000000a400c87306ULL, 0x000fe20000209400ULL,
0x000000c000c07245ULL, 0x002fce000020d400ULL, 0x000000a400c97306ULL, 0x0002e20000205400ULL,
0x000000c2c100720bULL, 0x004fce0003f3d000ULL, 0x0000008a00947306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fca000020d400ULL, 0x00000001c0c01812ULL, 0x000fe400078efcffULL,
0x0000008a00957306ULL, 0x0002a20000205400ULL, 0x000000c9c800720bULL, 0x008fe40003f5d000ULL,
0x000000c08e8e723eULL, 0x000fca00000010ffULL, 0x0000000400cb7306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x002fca000020d400ULL, 0x00000001a4a42812ULL, 0x000fe400078efcffULL,
0x0000000400cc7306ULL, 0x000e620000205400ULL, 0x000000959400720bULL, 0x004fce0003fbd000ULL,
0x00000030005a7306ULL, 0x000eac000000d400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x00000031008c7306ULL, 0x000fe20000009400ULL, 0x000000cccb00720bULL, 0x002fce0003fdd000ULL,
0x00000031008b7306ULL, 0x000e620000005400ULL, 0x000000015a5a4812ULL, 0x004fc800078efcffULL,
0x0000005aa45a723eULL, 0x000fc600000010ffULL, 0x0000000700307306ULL, 0x000ff00000209400ULL,
0x0000000700ca7306ULL, 0x000ea20000205400ULL, 0x0000008b8c00720bULL, 0x002fe40003f3d000ULL,
0x000000a8008b7245ULL, 0x000fca000020d400ULL, 0x0000003300877306ULL, 0x000ff00000009400ULL,
0x0000003300867306ULL, 0x000e620000005400ULL, 0x000000ca3000720bULL, 0x004fe40003f5d000ULL,
0x0000b80054307811ULL, 0x000fca00078e20ffULL, 0x000000c300c47306ULL, 0x000ff00000209400ULL,
0x000000c300c57306ULL, 0x000ea20000205400ULL, 0x000000868700720bULL, 0x002fe40003fbd000ULL,
0x0000000400867245ULL, 0x000fc4000020d400ULL, 0x0000b80053047811ULL, 0x000fe400078e20ffULL,
0x0000000186866812ULL, 0x000fe200078efcffULL, 0x0000006c00847306ULL, 0x000fe20000209400ULL,
0x0000008f00537245ULL, 0x000fce000020d400ULL, 0x0000006c00827306ULL, 0x0002e20000205400ULL,
0x000000c5c400720bULL, 0x004fce0003f7d000ULL, 0x00000031005d7306ULL, 0x000ea2000000d400ULL,
0x0000006c006c7245ULL, 0x002fca000020d400ULL, 0x000000019c9c3812ULL, 0x000fe400078efcffULL,
0x0000008100857306ULL, 0x000fe20000209400ULL, 0x000000828400720bULL, 0x008fe40003fdd000ULL,
0x0000000700827245ULL, 0x000fc8000020d400ULL, 0x0000000182822812ULL, 0x000fe200078efcffULL,
0x0000008100837306ULL, 0x0002e20000205400ULL, 0x000000015d5d1812ULL, 0x004fca00078efcffULL,
0x000000016c6c6812ULL, 0x000fe400078efcffULL, 0x0000009000317306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x002fce000020d400ULL, 0x0000009000ab7306ULL, 0x000e620000205400ULL,
0x000000838500720bULL, 0x008fe40003f9d000ULL, 0x0000009000837245ULL, 0x000fca000020d400ULL,
0x0000008d00067306ULL, 0x000fec0000209400ULL, 0x0000000181814812ULL, 0x000fe400078efcffULL,
0x0000008d00057306ULL, 0x0004e20000205400ULL, 0x000000ab3100720bULL, 0x002fe40003f3d000ULL,
0x000000828182723eULL, 0x000fca00000010ffULL, 0x00000033004f7306ULL, 0x000322000000d400ULL,
0x0000008d008d7245ULL, 0x004fca000020d400ULL, 0x0000000183831812ULL, 0x000fe400078efcffULL,
0x00000035007f7306ULL, 0x000fe20000009400ULL, 0x0000010035337824ULL, 0x002fe200078e00ffULL,
0x000000050600720bULL, 0x008fe40003f5d000ULL, 0x000000000404783bULL, 0x000e620000000200ULL,
0x000000836c83723eULL, 0x000fe400000010ffULL, 0x00000018ffa57819ULL, 0x000fe20000011433ULL,
0x0000003500787306ULL, 0x000ea20000005400ULL, 0x000000014f4f5812ULL, 0x010fcc00078efcffULL,
0x000000018d8d2812ULL, 0x000fe200078efcffULL, 0x000000a800c67306ULL, 0x000ff00000209400ULL,
0x000000a800c77306ULL, 0x0007220000205400ULL, 0x000000787f00720bULL, 0x004fc40003fbd000ULL,
0x00000093007f7245ULL, 0x000fca000020d400ULL, 0x0000009100997306ULL, 0x000fe20000209400ULL,
0x000000acada8723eULL, 0x008fce00000010ffULL, 0x00000091009a7306ULL, 0x0004e20000205400ULL,
0x000000c7c600720bULL, 0x010fe20003f7d000ULL, 0x0000005e04048231ULL, 0x082fe400003400ffULL,
0x0000005e06068231ULL, 0x000fc800003400ffULL, 0x0000003200897306ULL, 0x000fe20000009400ULL,
0x0000009100917245ULL, 0x004fe2000020d400ULL, 0x0000005f05058231ULL, 0x080fe400003400ffULL,
0x0000005f07078231ULL, 0x000fe400003400ffULL, 0x000000018b8b3812ULL, 0x000fe400078efcffULL,
0x0000003200887306ULL, 0x000e620000005400ULL, 0x0000009a9900720bULL, 0x008fe40003fdd000ULL,
0x000000a80408723cULL, 0x040fea0000041808ULL, 0x0000003200557306ULL, 0x0004e6000000d400ULL,
0x000000820418723cULL, 0x000fe60000041818ULL, 0x0000000191916812ULL, 0x000fc400078efcffULL,
0x0000008f00987306ULL, 0x000fe20000209400ULL, 0x0001000034327824ULL, 0x004fe200078e00ffULL,
0x000000888900720bULL, 0x002fc80003f7d000ULL, 0x00000018ffaf7819ULL, 0x000fe40000011432ULL,
0x0000008f009b7306ULL, 0x0002a20000205400ULL, 0x000000003030783bULL, 0x000f2c0000000200ULL,
0x0000000155553812ULL, 0x008fe200078efcffULL, 0x00000035004b7306ULL, 0x000762000000d400ULL,
0x0000008b8a8f723eULL, 0x002fce00000010ffULL, 0x00000064007a7306ULL, 0x000fe20000209400ULL,
0x0000009b9800720bULL, 0x004fe20003f9d000ULL, 0x000001003a357824ULL, 0x008fe200078e00ffULL,
0x0000008e0410723cULL, 0x000fea0000041810ULL, 0x0000006400747306ULL, 0x0002a20000205400ULL,
0x000000014b4b5812ULL, 0x020fca00078efcffULL, 0x0000000153534812ULL, 0x000fe400078efcffULL,
0x00000034006d7306ULL, 0x000fe20000009400ULL, 0x0000006400647245ULL, 0x002fce000020d400ULL,
0x0000003400717306ULL, 0x000e620000005400ULL, 0x000000747a00720bULL, 0x004fe20003fbd000ULL,
0x0000005e30308231ULL, 0x090fe400003400ffULL, 0x0000005e32328231ULL, 0x000fe400003400ffULL,
0x0000005f31318231ULL, 0x080fe400003400ffULL, 0x00000036007d7306ULL, 0x000fe20000009400ULL,
0x0000005f33338231ULL, 0x000fca00003400ffULL, 0x0000000164645812ULL, 0x000fe400078efcffULL,
0x0000003600707306ULL, 0x000ea20000005400ULL, 0x000000716d00720bULL, 0x002fce0003f3d000ULL,
0x0000007e00757306ULL, 0x000ff00000209400ULL, 0x0000007e00797306ULL, 0x0002e20000205400ULL,
0x000000707d00720bULL, 0x004fce0003fdd000ULL, 0x00000093009d7306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fce000020d400ULL, 0x00000093009e7306ULL, 0x000e620000205400ULL,
0x000000797500720bULL, 0x008fce0003f5d000ULL, 0x000000d000857306ULL, 0x000fec0000209400ULL,
0x000000017e7e2812ULL, 0x000fe400078efcffULL, 0x000000d000847306ULL, 0x0004e20000205400ULL,
0x0000009e9d00720bULL, 0x002fe40003f9d000ULL, 0x000000917e7e723eULL, 0x000fca00000010ffULL,
0x0000007c00807306ULL, 0x000fe20000209400ULL, 0x000000d000d07245ULL, 0x004fca000020d400ULL,
0x000000017f7f4812ULL, 0x000fe400078efcffULL, 0x0000007c00767306ULL, 0x0002a20000205400ULL,
0x000000848500720bULL, 0x008fce0003fbd000ULL, 0x0000003600487306ULL, 0x000ee2000000d400ULL,
0x0000007c007c7245ULL, 0x002fca000020d400ULL, 0x00000001d0d05812ULL, 0x000fe400078efcffULL,
0x000000cf00547306ULL, 0x000fe20000209400ULL, 0x000000768000720bULL, 0x004fce0003f7d000ULL,
0x000000cf006d7306ULL, 0x0002a20000205400ULL, 0x0000000148486812ULL, 0x008fca00078efcffULL,
0x000000017c7c3812ULL, 0x000fe400078efcffULL, 0x00000034004e7306ULL, 0x000722000000d400ULL,
0x000000cf00cf7245ULL, 0x002fe4000020d400ULL, 0x0000007f7c7f723eULL, 0x000fca00000010ffULL,
0x00000069006f7306ULL, 0x000fe20000209400ULL, 0x0000006d5400720bULL, 0x004fe20003fdd000ULL,
0x000001003b347824ULL, 0x008fe200078e00ffULL, 0x0000007e0420723cULL, 0x000fea0000041820ULL,
0x00000069006e7306ULL, 0x0002a20000205400ULL, 0x000000014e4e1812ULL, 0x010fca00078efcffULL,
0x00000001cfcf6812ULL, 0x000fe400078efcffULL, 0x0000003700777306ULL, 0x000fe20000009400ULL,
0x0000006900697245ULL, 0x002fce000020d400ULL, 0x0000003700727306ULL, 0x000e620000005400ULL,
0x0000006e6f00720bULL, 0x004fce0003f3d000ULL, 0x0000003700457306ULL, 0x0004ec000000d400ULL,
0x0000000169691812ULL, 0x000fe400078efcffULL, 0x0000009700367306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x004fe200078e00ffULL, 0x000000727700720bULL, 0x002fc80003f5d000ULL,
0x00000018ff717819ULL, 0x000fe40000011437ULL, 0x0000009700a37306ULL, 0x0002a20000205400ULL,
0x000000609c37723eULL, 0x000fcc00000010ffULL, 0x0000000145452812ULL, 0x008fe200078efcffULL,
0x000000af00b07306ULL, 0x000fe20000209400ULL, 0x0000009700977245ULL, 0x002fce000020d400ULL,
0x000000af00a77306ULL, 0x0002e20000205400ULL, 0x000000a33600720bULL, 0x004fe40003f9d000ULL,
0x000000619f36723eULL, 0x000fca00000010ffULL, 0x00000059005c7306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fe2000020d400ULL, 0x00000036040c723cULL, 0x000fe8000004180cULL,
0x0000000197974812ULL, 0x000fe400078efcffULL, 0x00000059005b7306ULL, 0x0002a20000205400ULL,
0x000000a7b000720bULL, 0x008fe40003f1d000ULL, 0x0000006aaea7723eULL, 0x000fc400000010ffULL,
0x0000004e974e723eULL, 0x000fe400000010ffULL, 0x000000a200377245ULL, 0x000fe2000020d400ULL,
0x000000a500aa7306ULL, 0x000fe20000209400ULL, 0x0000005900597245ULL, 0x002fe2000020d400ULL,
0x000000a60440723cULL, 0x000fe80000041840ULL, 0x00000001afaf0812ULL, 0x000fe400078efcffULL,
0x000000a500b17306ULL, 0x0002e20000205400ULL, 0x0000005b5c00720bULL, 0x004fc40003fbd000ULL,
0x00000018ff5c7819ULL, 0x000fe40000011435ULL, 0x0000005d865b723eULL, 0x000fe400000010ffULL,
0x0000004f5335723eULL, 0x000fe200000010ffULL, 0x0000007100757306ULL, 0x000fe20000209400ULL,
0x000000a500a57245ULL, 0x002fc6000020d400ULL, 0x0000005a0414723cULL, 0x000fe40000041814ULL,
0x0000000159595812ULL, 0x000fe400078efcffULL, 0x0000007100707306ULL, 0x0002a20000205400ULL,
0x000000b1aa00720bULL, 0x008fce0003f7d000ULL, 0x0000003900667306ULL, 0x000fe20000009400ULL,
0x0000007100717245ULL, 0x002fca000020d400ULL, 0x00000001a5a53812ULL, 0x000fe400078efcffULL,
0x0000003900657306ULL, 0x000e620000005400ULL, 0x000000707500720bULL, 0x004fe40003fdd000ULL,
0x0000004ba54f723eULL, 0x000fca00000010ffULL, 0x00000038007b7306ULL, 0x000fec0000009400ULL,
0x0000000171716812ULL, 0x000fe400078efcffULL, 0x0000003800737306ULL, 0x000ea20000005400ULL,
0x000000656600720bULL, 0x002fce0003f3d000ULL, 0x00000039003d7306ULL, 0x0002f0000000d400ULL,
0x000000a100727306ULL, 0x000fe20000209400ULL, 0x0001000039397824ULL, 0x002fe200078e00ffULL,
0x000000737b00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000000a1005e7306ULL, 0x0002a20000205400ULL, 0x000000013d3d1812ULL, 0x008fce00078efcffULL,
0x0000005000587306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fce000020d400ULL,
0x0000005000567306ULL, 0x0002e20000205400ULL, 0x0000005e7200720bULL, 0x004fce0003fbd000ULL,
0x000000cd00b27306ULL, 0x000fe20000209400ULL, 0x0000005000507245ULL, 0x002fca000020d400ULL,
0x00000001a1a15812ULL, 0x000fe400078efcffULL, 0x000000cd00927306ULL, 0x0002a20000205400ULL,
0x000000565800720bULL, 0x008fe40003f5d000ULL, 0x00000018ff587819ULL, 0x000fe40000011434ULL,
0x000000558d34723eULL, 0x000fc600000010ffULL, 0x0000004600517306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x002fc6000020d400ULL, 0x00000034041c723cULL, 0x000fe4000004181cULL,
0x0000000150502812ULL, 0x000fe400078efcffULL, 0x0000004600527306ULL, 0x0002e20000205400ULL,
0x00000092b200720bULL, 0x004fe40003f7d000ULL, 0x000000af6934723eULL, 0x000fe200000010ffULL,
0x0000004e3004723cULL, 0x000fe80000041840ULL, 0x00000038003f7306ULL, 0x000522000000d400ULL,
0x0000004600467245ULL, 0x002fca000020d400ULL, 0x00000001cdcd3812ULL, 0x000fe400078efcffULL,
0x000000ce008c7306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x004fe200078e00ffULL,
0x000000525100720bULL, 0x008fe40003fdd000ULL, 0x000000cd6435723eULL, 0x000fe400000010ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x000000ce00887306ULL, 0x0002a20000205400ULL,
0x000000013f3f4812ULL, 0x010fc400078efcffULL, 0x000000343008723cULL, 0x000fe80000041808ULL,
0x0000000146466812ULL, 0x000fe200078efcffULL, 0x0000003900617306ULL, 0x000fe20000209400ULL,
0x000000ce00ce7245ULL, 0x002fe4000020d400ULL, 0x000000cf5934723eULL, 0x000fe400000010ffULL,
0x000000715035723eULL, 0x000fc600000010ffULL, 0x0000003900547306ULL, 0x0002e20000205400ULL,
0x000000888c00720bULL, 0x004fc60003f1d000ULL, 0x000000343010723cULL, 0x000fe80000041810ULL,
0x000000a200737306ULL, 0x000fe20000209400ULL, 0x0000003900397245ULL, 0x002fca000020d400ULL,
0x00000001cece0812ULL, 0x000fe400078efcffULL, 0x000000a2006e7306ULL, 0x000e620000205400ULL,
0x000000546100720bULL, 0x008fe40003f3d000ULL, 0x00000048ce48723eULL, 0x000fca00000010ffULL,
0x0000003e004d7306ULL, 0x000fec0000209400ULL, 0x0000000139391812ULL, 0x000fe400078efcffULL,
0x0000003e004c7306ULL, 0x0004e20000205400ULL, 0x0000006e7300720bULL, 0x002fce0003fbd000ULL,
0x0000003a00677306ULL, 0x000fe20000009400ULL, 0x0000003e003e7245ULL, 0x004fca000020d400ULL,
0x0000000137375812ULL, 0x000fe400078efcffULL, 0x0000003a00687306ULL, 0x000e620000005400ULL,
0x0000004c4d00720bULL, 0x008fe40003f5d000ULL, 0x0000003d3737723eULL, 0x000fe400000010ffULL,
0x00000058003d7245ULL, 0x000fc6000020d400ULL, 0x00000038005f7306ULL, 0x000fec0000209400ULL,
0x000000013e3e2812ULL, 0x000fe400078efcffULL, 0x0000003800657306ULL, 0x0004e20000205400ULL,
0x000000686700720bULL, 0x002fe40003f7d000ULL, 0x000000393e39723eULL, 0x000fca00000010ffULL,
0x0000003a003c7306ULL, 0x000322000000d400ULL, 0x0000003800387245ULL, 0x004fce000020d400ULL,
0x0000003b00637306ULL, 0x000fe20000009400ULL, 0x000100003a3a7824ULL, 0x002fe200078e00ffULL,
0x000000655f00720bULL, 0x008fc80003f9d000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b00627306ULL, 0x000e620000005400ULL, 0x000000013c3c3812ULL, 0x010fcc00078efcffULL,
0x0000000138384812ULL, 0x000fe200078efcffULL, 0x0000003b002f7306ULL, 0x0004e6000000d400ULL,
0x000000384638723eULL, 0x000fca00000010ffULL, 0x0000005800557306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x004fe200078e00ffULL, 0x000000626300720bULL, 0x002fe20003f1d000ULL,
0x000000383018723cULL, 0x000fe60000041818ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000005800517306ULL, 0x000e6e0000205400ULL, 0x000000012f2f0812ULL, 0x008fe200078efcffULL,
0x0000002e00497306ULL, 0x000ff00000209400ULL, 0x0000002e004a7306ULL, 0x0004e20000205400ULL,
0x000000515500720bULL, 0x002fce0003f3d000ULL, 0x0000000000447306ULL, 0x000fe20000209400ULL,
0x0000002e002e7245ULL, 0x004fca000020d400ULL, 0x000000013d3d1812ULL, 0x000fe400078efcffULL,
0x0000000000477306ULL, 0x0002a20000205400ULL, 0x0000004a4900720bULL, 0x008fe40003fbd000ULL,
0x0000002f3d3d723eULL, 0x000fe400000010ffULL, 0x0000003b002f7245ULL, 0x000fe4000020d400ULL,
0x00000045d049723eULL, 0x000fe200000010ffULL, 0x0000005c00367306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x002fca000020d400ULL, 0x000000012e2e5812ULL, 0x000fe200078efcffULL,
0x00000048300c723cULL, 0x000fe2000004180cULL, 0x0000005c00567306ULL, 0x0002e20000205400ULL,
0x000000474400720bULL, 0x004fce0003f9d000ULL, 0x0000003a004c7306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x002fca000020d400ULL, 0x0000000100004812ULL, 0x000fe400078efcffULL,
0x0000003a004b7306ULL, 0x0002a20000205400ULL, 0x000000563600720bULL, 0x008fe40003fdd000ULL,
0x0000003fa136723eULL, 0x000fca00000010ffULL, 0x0000003b00407306ULL, 0x000fe20000209400ULL,
0x0000003a003a7245ULL, 0x002fe2000020d400ULL, 0x000000363014723cULL, 0x000fe80000041814ULL,
0x000000015c5c6812ULL, 0x000fe400078efcffULL, 0x0000003b00417306ULL, 0x000e620000205400ULL,
0x0000004b4c00720bULL, 0x004fe40003f5d000ULL, 0x0000003c5c3c723eULL, 0x000fce00000010ffULL,
0x0000003c301c723cULL, 0x000fe8000004181cULL, 0x000000013a3a2812ULL, 0x000fe400078efcffULL,
0x000000414000720bULL, 0x002fe40003f7d000ULL, 0x0000003a2e2e723eULL, 0x000fd600000010ffULL,
0x000000012f2f3812ULL, 0x000fc800078efcffULL, 0x0000002f002f723eULL, 0x000fce00000010ffULL,
0x0000002e3020723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff2e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff487224ULL, 0x002fc600078e002fULL, 0x0000030003037a10ULL, 0x000fc80007ffe0ffULL,
0x000000020300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffec48000007947ULL, 0x000fea000383ffffULL, 0x0000000000347919ULL, 0x000e620000002500ULL,
0x000000ffff337224ULL, 0x000fe400078e0023ULL, 0x000000ffff327224ULL, 0x000fe400078e0022ULL,
0x000000ffff317224ULL, 0x000fe400078e0021ULL, 0x000000ffff307224ULL, 0x000fe400078e0020ULL,
0x000000ffff2f7224ULL, 0x008fe400078e001fULL, 0x000000ffff2e7224ULL, 0x000fc400078e001eULL,
0x000000ffff2d7224ULL, 0x000fe400078e001dULL, 0x000000ffff2b7224ULL, 0x000fe400078e001cULL,
0x000000ffff287224ULL, 0x000fe400078e001bULL, 0x000000ffff277224ULL, 0x004fe400078e001aULL,
0x000000ffff267224ULL, 0x000fe400078e0019ULL, 0x000000ffff247224ULL, 0x000fe200078e0018ULL,
0x000000023400720cULL, 0x002fe20003f06070ULL, 0x000000ffff237224ULL, 0x000fc400078e0017ULL,
0x000000ffff227224ULL, 0x000fe400078e0016ULL, 0x000000ffff217224ULL, 0x000fe400078e0015ULL,
0x000000ffff207224ULL, 0x000fe400078e0014ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0013ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0011ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e000fULL,
0x000000ffff1a7224ULL, 0x000fe400078e000eULL, 0x000000ffff197224ULL, 0x000fe400078e000dULL,
0x000000ffff187224ULL, 0x000fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000bULL,
0x000000ffff167224ULL, 0x000fe400078e000aULL, 0x000000ffff157224ULL, 0x000fe400078e0009ULL,
0x000000ffff147224ULL, 0x000fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e0007ULL,
0x000000ffff127224ULL, 0x000fe400078e0006ULL, 0x000000ffff117224ULL, 0x000fc400078e0005ULL,
0x000000ffff107224ULL, 0x000fe200078e0004ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x0180000029007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe200078e0029ULL,
0x00014b6000057802ULL, 0x000fe40000000f00ULL, 0x00009da000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002900007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000029ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000200007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006600ff027624ULL, 0x000fe400078e00ffULL, 0x00006700ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x0002a8000c1e9900ULL, 0x0000000000037919ULL, 0x002e640000000000ULL,
0x00000002ff047819ULL, 0x002fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000002007220ULL, 0x00cfca0000410000ULL, 0x00001f0400027589ULL, 0x000e6800000e0000ULL,
0x00001f0300037589ULL, 0x000ea200000e0000ULL, 0x0000001002107220ULL, 0x042fe20000410000ULL,
0x0000001102117220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000001802187220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002602267220ULL, 0x040fe20000410000ULL, 0x0000002b022b7220ULL, 0x040fe20000410000ULL,
0x0000002d022d7220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x000fe20000410000ULL, 0x0000001203127220ULL, 0x044fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x000fe20000410000ULL, 0x0000000000007919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200027812ULL, 0x002fc400078ec0ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011600ULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x0000000202047811ULL, 0x040fe400078ff8ffULL, 0x0000000402077811ULL, 0x040fe400078ff8ffULL,
0x00000006020b7811ULL, 0x000fe400078ff8ffULL, 0x00000008000f7811ULL, 0x000fc400078ff0ffULL,
0x0000000703027812ULL, 0x100fe400078e780dULL, 0x0000000704057812ULL, 0x140fe400078e780dULL,
0x0000000707097812ULL, 0x000fe200078e780dULL, 0x000000080d067824ULL, 0x000fe200078e0202ULL,
0x0000000707077812ULL, 0x000fe200078e780fULL, 0x000000080d087824ULL, 0x000fe200078e0205ULL,
0x000000070b0c7812ULL, 0x000fe200078e780dULL, 0x0000080025027824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe200078e780fULL, 0x000000080f0e7824ULL, 0x000fe200078e0207ULL,
0x0000000704047812ULL, 0x000fe200078e780fULL, 0x000000080d0a7824ULL, 0x000fe200078e0209ULL,
0x000000070b057812ULL, 0x000fe200078e780fULL, 0x000000080d0c7824ULL, 0x000fc400078e020cULL,
0x000000080f0b7824ULL, 0x040fe200078e0203ULL, 0x0000a00002037810ULL, 0x000fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x000000080f0d7824ULL, 0x000fe200078e0204ULL,
0x000000101104723eULL, 0x000fe200000010ffULL, 0x000000080f0f7824ULL, 0x000fe200078e0205ULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x000000141505723eULL, 0x000fe200000010ffULL, 0x0000001008097824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0x0000541004107816ULL, 0x040fe20000000005ULL,
0x000000100b0b7824ULL, 0x000fe200078e0203ULL, 0x0000763204117816ULL, 0x000fe20000000005ULL,
0x000000100d0d7824ULL, 0x100fe400078e0203ULL, 0x000000100c0c7824ULL, 0x100fe400078e0203ULL,
0x000000100e0e7824ULL, 0x100fe400078e0203ULL, 0x000000100f0f7824ULL, 0x000fc400078e0203ULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000181906723eULL, 0x000fe200000010ffULL,
0x0000000107097824ULL, 0x040fe400078e0209ULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000001008007388ULL, 0x0003e20000000a00ULL, 0x00000001070b7824ULL, 0x040fe400078e020bULL,
0x00000001070d7824ULL, 0x040fe400078e020dULL, 0x00000001070c7824ULL, 0x000fc400078e020cULL,
0x00000001070e7824ULL, 0x040fe400078e020eULL, 0x00000001070f7824ULL, 0x000fe200078e020fULL,
0x0000001c1d07723eULL, 0x000fe400000010ffULL, 0x000000121308723eULL, 0x002fe200000010ffULL,
0x00000300ff127624ULL, 0x000fe200078e00ffULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe40000000007ULL, 0x0000002b2d06723eULL, 0x000fc400000010ffULL,
0x000000303107723eULL, 0x000fe200000010ffULL, 0x0000000409007388ULL, 0x0003e20000000a00ULL,
0x000000011200780cULL, 0x000fe40003f05270ULL, 0x000000202104723eULL, 0x002fe400000010ffULL,
0x000000242605723eULL, 0x000fe400000010ffULL, 0x000000161709723eULL, 0x000fe400000010ffULL,
0x0000541004107816ULL, 0x000fc40000000005ULL, 0x0000763204117816ULL, 0x000fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x000000100a007388ULL, 0x000fe20000000a00ULL, 0x000000222306723eULL, 0x000fe400000010ffULL,
0x000000272807723eULL, 0x000fe200000010ffULL, 0x000000040c007388ULL, 0x0003e40000000a00ULL,
0x0000541008047816ULL, 0x002fc40000000009ULL, 0x0000763208057816ULL, 0x000fe40000000009ULL,
0x0000002e2f08723eULL, 0x000fe400000010ffULL, 0x000000323309723eULL, 0x000fe200000010ffULL,
0x000000040b007388ULL, 0x0003e40000000a00ULL, 0x0000001a1b04723eULL, 0x002fe400000010ffULL,
0x0000001e1f05723eULL, 0x000fc800000010ffULL, 0x00005410040a7816ULL, 0x140fe40000000005ULL,
0x00007632040b7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000a0d007388ULL, 0x0003e20000000a00ULL,
0x0000541008067816ULL, 0x140fe40000000009ULL, 0x0000763208077816ULL, 0x000fe20000000009ULL,
0x000000040e007388ULL, 0x0003e80000000a00ULL, 0x000000060f007388ULL, 0x0003e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b6000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ea20000002700ULL, 0x0000001000047824ULL, 0x042fe200078e0202ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x0000000000057919ULL, 0x000ea20000002600ULL, 0x00000020000e7810ULL, 0x040fe40007ffe0ffULL,
0x000000ff0000720cULL, 0x000fe20000725670ULL, 0x00a0000004147984ULL, 0x000e680000000c00ULL,
0x00a2000004187984ULL, 0x0007240000000c00ULL, 0x0000580012047a24ULL, 0x008fc800078e02ffULL,
0x0000640004087a24ULL, 0x000fe400078e02ffULL, 0x0000580010107a24ULL, 0x004fc600078e0205ULL,
0x00000fff08057811ULL, 0x000fe200078e40ffULL, 0x0000030010047a24ULL, 0x000fc800078e02ffULL,
0x0000000104097824ULL, 0x000fca00078e0234ULL, 0x0000000905067211ULL, 0x000fca00078fa0ffULL,
0x00006a0006067625ULL, 0x000fcc00078e0007ULL, 0x0000040025067825ULL, 0x000fcc00078e0006ULL,
0x000000100e0e7825ULL, 0x000fc800078e0006ULL, 0x00000010000c7825ULL, 0x000fe200078e0006ULL,
0x01ffffff08067812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000001ff087819ULL, 0x012fe20000011600ULL, 0x0000001000077824ULL, 0x000fe400078e00ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c08117812ULL, 0x000fe200078ec0ffULL,
0x00000001090a7824ULL, 0x000fe200078e0206ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x00006a0009087625ULL, 0x000fc800078e000bULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000811087210ULL, 0x000fc80007b5e007ULL, 0x0000000a110a7210ULL, 0x000fe40007d9e007ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000002a08007986ULL, 0x0003e8000c101906ULL, 0x000000290a007986ULL, 0x0003e4000c101906ULL,
0x000000140c007986ULL, 0x0123e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000180e007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff087424ULL, 0x000fe200078e00ffULL,
0xffffffff12077810ULL, 0x000fc60007ffe0ffULL, 0x0000680010087625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000007080879a8ULL, 0x000ea400099ee1c6ULL, 0x000000070800720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff077807ULL, 0x000fca0000800000ULL,
0x00000007ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff077984ULL, 0x004ea40000000000ULL,
0x000000ff0700720cULL, 0x004fda0003f25270ULL, 0x000027a000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011600ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x00000001040a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x0000000c08147812ULL, 0x002fe400078ec0ffULL,
0x0000007007137812ULL, 0x000fe200078ec0ffULL, 0x00006a0004087625ULL, 0x000fc800078e0011ULL,
0x00006a000a0a7625ULL, 0x000fe200078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x0000000a140a7210ULL, 0x000fe40007b5e013ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608077981ULL, 0x000368000c1e1900ULL,
0x000000060a0c7981ULL, 0x000362000c1e1900ULL, 0x000000021200780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080d7981ULL, 0x000362000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080e7981ULL, 0x000362000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608107981ULL, 0x000362000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081200780cULL, 0x002fe40003f06070ULL,
0x0000000604087810ULL, 0x000fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fe40007a3e013ULL, 0x00000007040a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006a000a0a0625ULL, 0x000fe400078e0011ULL,
0x0000000608117981ULL, 0x000366000c1e1900ULL, 0x0000000a140a0210ULL, 0x000fc80007c7e013ULL,
0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL, 0x000000060a0a0981ULL, 0x000368000c1e1900ULL,
0x0000000712087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0b7819ULL, 0x000fc80000011608ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff127224ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x020fe400078e0007ULL,
0x0000000812147824ULL, 0x040fe200078e00ffULL, 0x0000000112127810ULL, 0x000fc80007ffe0ffULL,
0x0000030014007a0cULL, 0x000fe40003f26070ULL, 0x0000000b1200720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000814087810ULL, 0x040fe40007ffe0ffULL,
0x0000000114097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001307077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000914087810ULL, 0x042fe40007ffe0ffULL, 0x0000000214097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000c07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e00cULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080c7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000314097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000d07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000414097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000e07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e00eULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080e7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000514097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000f07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000f7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000614097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010107812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e010ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608107981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000714097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001107077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f14087810ULL, 0x002fe40007ffe0ffULL, 0x0000000a07077209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700a0a7812ULL, 0x000fc800078ec0ffULL, 0x0000000814087210ULL, 0x000fc80007a3e00aULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080a7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000087824ULL, 0x006fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108087824ULL, 0x000fca00078e0209ULL, 0x0000000708007388ULL, 0x0203e40000000800ULL,
0x0000000405087211ULL, 0x002fe200078fa0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011600ULL,
0x00006a0008087625ULL, 0x000fe200078e0009ULL, 0x00000016ff437819ULL, 0x000fe20000011625ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000040025427824ULL, 0x040fe200078e00ffULL, 0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000100025207824ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000004208087210ULL, 0x000fe20007f3e0ffULL,
0x0000000107177824ULL, 0x000fe200078e020aULL, 0x00000020000a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001040c8824ULL, 0x000fe200078e0206ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200008e0643ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0d8424ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0e8424ULL, 0x000fe200078e00ffULL, 0x0000000017177984ULL, 0x000e620000000800ULL,
0x00006a000c0c8625ULL, 0x000fe200078e000dULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000100a0a7825ULL, 0x000fe200078e0008ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000001000077824ULL, 0x040fe400078e0220ULL,
0x0000001025108824ULL, 0x000fe400078e0200ULL, 0x0000001000087825ULL, 0x000fc600078e0008ULL,
0x0000458010108811ULL, 0x000fe200078e20ffULL, 0x00006a00040e8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008077faeULL, 0x0005e6000b901c46ULL,
0x0000001025118824ULL, 0x000fe200078e0200ULL, 0x003800000a077faeULL, 0x0007e2000b901c46ULL,
0x00000010000c8825ULL, 0x000fc600078e000cULL, 0x0000418011118811ULL, 0x000fe200078e20ffULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000000000c108faeULL, 0x0009e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x000fe400078e00ffULL, 0x0000001000088825ULL, 0x004fe400078e000eULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000008118faeULL, 0x0005e2000b901c46ULL,
0x000000ffff167224ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000cf000009947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x002fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134357810ULL, 0x000fc80007ffe0ffULL, 0x0000030035007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x00000001041f7824ULL, 0x000fe200078e0235ULL,
0x000000070000780cULL, 0x040fe20003f24070ULL, 0x00001000ff197424ULL, 0x000fe200078e00ffULL,
0x00000001351e7812ULL, 0x040fe200078ec0ffULL, 0x00000800351a7824ULL, 0x000fe200078e00ffULL,
0x0000001f05187211ULL, 0x000fe400078fa0ffULL, 0x0000002000387810ULL, 0x000fe40007ffe0ffULL,
0x000008001a1c7812ULL, 0x000fe200078ec0ffULL, 0x00006a0018187625ULL, 0x000fc800078e0019ULL,
0x00000001061b9824ULL, 0x000fe200078e021fULL, 0x0000004218187210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff369424ULL, 0x000fe400078e00ffULL, 0x00000002251d9824ULL, 0x140fe400078e021eULL,
0x0000000225399824ULL, 0x000fe400078e021eULL, 0x00006a001b1a9625ULL, 0x000fc800078e0036ULL,
0x00000080ff1e9424ULL, 0x000fe400078e00ffULL, 0x00000001201c7824ULL, 0x000fe400078e021cULL,
0x0000000119197824ULL, 0x000fe400000e0643ULL, 0x000000081d379824ULL, 0x000fe400078e0200ULL,
0x00006a001f1e9625ULL, 0x000fc600078e001eULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x0000001000367824ULL, 0x040fe400078e021cULL, 0x0000000839399824ULL, 0x000fe400078e0200ULL,
0x00000010001c9825ULL, 0x000fc800078e001aULL, 0x00000010381a7825ULL, 0x000fe200078e0018ULL,
0x0000418039389811ULL, 0x000fc600078e20ffULL, 0x0000001000187825ULL, 0x000fc800078e0018ULL,
0x00000010001e9825ULL, 0x000fe200078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000018367faeULL, 0x0003e8000b901c46ULL, 0x003800001a367faeULL, 0x0003e8000b901c46ULL,
0x000000001c379faeULL, 0x0003e8000b901c46ULL, 0x000000001e389faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff377224ULL, 0x002fe200078e0034ULL,
0x00000001ff1a7819ULL, 0x100fe20000011600ULL, 0x0000001000197824ULL, 0x000fe200078e00ffULL,
0x00000002ff447819ULL, 0x000fe20000011600ULL, 0x0000008037187824ULL, 0x000fe200078e00ffULL,
0x0000000c1a1a7812ULL, 0x000fc400078ec0ffULL, 0x0000007019197812ULL, 0x000fe200078ec0ffULL,
0x00000008441b7824ULL, 0x000fe200078e00ffULL, 0x0000008018187812ULL, 0x000fe400078ec0ffULL,
0x00000044ff367212ULL, 0x000fe400078e33ffULL, 0x0000000744347812ULL, 0x040fe200078ec0ffULL,
0x0000010025187824ULL, 0x000fe200078e0218ULL, 0xfffffff81b367812ULL, 0x000fe400078ee236ULL,
0x0000000844457810ULL, 0x000fc40007ffe0ffULL, 0x000000181a187210ULL, 0x000fe20007ffe019ULL,
0x0000000844197824ULL, 0x000fe200078e00ffULL, 0x00000045ff3f7212ULL, 0x000fe200078e33ffULL,
0x0000000845387824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000181a7984ULL, 0x000e620000000800ULL, 0x00000001191b7812ULL, 0x100fe200078ef634ULL,
0x0000000845397824ULL, 0x000fe200078e00ffULL, 0x00000002191c7812ULL, 0x140fe200078ef634ULL,
0x0045800018417984ULL, 0x0004e20000000800ULL, 0x00000003191d7812ULL, 0x140fe400078ef634ULL,
0x00000004191e7812ULL, 0x140fe400078ef634ULL, 0x00000005191f7812ULL, 0x000fe400078ef634ULL,
0xfffffff8383f7812ULL, 0x000fe200078ee23fULL, 0x0000000844187824ULL, 0x004fca00078e00ffULL,
0xfffffff818187812ULL, 0x100fe400078ee234ULL, 0x0000000619347812ULL, 0x000fe200078ef634ULL,
0x0000080037197824ULL, 0x000fca00078e00ffULL, 0x0000080019197812ULL, 0x000fc800078ec0ffULL,
0x0000018020197810ULL, 0x000fca0007ffe019ULL, 0x0000001018187824ULL, 0x100fe400078e0219ULL,
0x0000001036367824ULL, 0x100fe400078e0219ULL, 0x000000101b1b7824ULL, 0x100fe200078e0219ULL,
0x0000001a171a7221ULL, 0x002fe20000010100ULL, 0x000000101c1c7824ULL, 0x100fe400078e0219ULL,
0x000000101d1d7824ULL, 0x000fe200078e0219ULL, 0x3fb8aa3b1a377820ULL, 0x000fe20000410000ULL,
0x00000004001a7824ULL, 0x000fc400078e00ffULL, 0x000000101e1e7824ULL, 0x100fe200078e0219ULL,
0x0000003700407308ULL, 0x0002e20000000800ULL, 0x000000101f1f7824ULL, 0x100fe200078e0219ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000001034347824ULL, 0x100fe400078e0219ULL,
0x000000103f3f7824ULL, 0x000fe400078e0219ULL, 0x0000000118187824ULL, 0x000fe200078e021aULL,
0x0000000745377812ULL, 0x002fe200078ec0ffULL, 0x000000011a367824ULL, 0x000fc400078e0236ULL,
0x000000011a1b7824ULL, 0x000fe200078e021bULL, 0xfffffff838387812ULL, 0x100fe200078ee237ULL,
0x000000011a1c7824ULL, 0x000fe200078e021cULL, 0x00000001393a7812ULL, 0x140fe200078ef637ULL,
0x0000004140407220ULL, 0x008fe20000410000ULL, 0x00000002393b7812ULL, 0x140fe200078ef637ULL,
0x0000000036417984ULL, 0x000fe20000000800ULL, 0x00000003393c7812ULL, 0x040fe200078ef637ULL,
0x000000011a1d7824ULL, 0x040fe200078e021dULL, 0x00000004393d7812ULL, 0x140fe200078ef637ULL,
0x000000001b367984ULL, 0x000fe20000000800ULL, 0x00000005393e7812ULL, 0x140fe200078ef637ULL,
0x000000011a1e7824ULL, 0x040fe200078e021eULL, 0x0000000639377812ULL, 0x000fe200078ef637ULL,
0x00001f44401b7589ULL, 0x000fe200000e0000ULL, 0x000000011a1f7824ULL, 0x000fe200078e021fULL,
0x0000003340337221ULL, 0x000fe20000010000ULL, 0x000000011a347824ULL, 0x000fe200078e0234ULL,
0x0000000018397984ULL, 0x000e620000000800ULL, 0x0000001038387824ULL, 0x000fc400078e0219ULL,
0x000000103a3a7824ULL, 0x100fe200078e0219ULL, 0x000000001c1c7984ULL, 0x000ea20000000800ULL,
0x000000011a387824ULL, 0x040fe400078e0238ULL, 0x000000011a3a7824ULL, 0x000fe200078e023aULL,
0x000000001d1d7984ULL, 0x000ee20000000800ULL, 0x000000103b3b7824ULL, 0x100fe400078e0219ULL,
0x000000103c3c7824ULL, 0x000fe200078e0219ULL, 0x000000001e1e7984ULL, 0x000f220000000800ULL,
0x000000011a3b7824ULL, 0x000fc400078e023bULL, 0x000000011a3c7824ULL, 0x000fe200078e023cULL,
0x000000001f1f7984ULL, 0x000f620000000800ULL, 0x000000103d3d7824ULL, 0x100fe400078e0219ULL,
0x000000103e3e7824ULL, 0x000fe200078e0219ULL, 0x0000000034347984ULL, 0x000ea20000000800ULL,
0x000000011a3d7824ULL, 0x040fe400078e023dULL, 0x000000011a3e7824ULL, 0x000fe200078e023eULL,
0x0000000038387984ULL, 0x000ea20000000800ULL, 0x0000001037377824ULL, 0x000fc400078e0219ULL,
0x000000011a3f7824ULL, 0x040fe200078e023fULL, 0x000000003a3a7984ULL, 0x000fe20000000800ULL,
0x000000011a377824ULL, 0x000fc600078e0237ULL, 0x00001f4540407589ULL, 0x000ea800000e0000ULL,
0x000000003b3b7984ULL, 0x000ea20000000800ULL, 0x00005410ff187816ULL, 0x002fc60000000039ULL,
0x000000003c3c7984ULL, 0x000e640000000800ULL, 0x0000001b18327223ULL, 0x080fe20000010032ULL,
0x00007610ff187816ULL, 0x000fe20000000039ULL, 0x000000003d3d7984ULL, 0x000e680000000800ULL,
0x0000001b18317223ULL, 0x080fe20000010031ULL, 0x00005410ff187816ULL, 0x100fe20000000041ULL,
0x000000003e3e7984ULL, 0x000e680000000800ULL, 0x0000001b18227223ULL, 0x080fe20000010022ULL,
0x00007610ff187816ULL, 0x000fe20000000041ULL, 0x0000000037377984ULL, 0x000e680000000800ULL,
0x0000001b18217223ULL, 0x080fe20000010021ULL, 0x00005410ff187816ULL, 0x000fe20000000036ULL,
0x000000003f3f7984ULL, 0x000e680000000800ULL, 0x0000001b18307223ULL, 0x000fe20000010030ULL,
0x00007610ff187816ULL, 0x000fca0000000036ULL, 0x0000001b182f7223ULL, 0x000fe2000001002fULL,
0x00005410ff187816ULL, 0x004fca000000001cULL, 0x0000001b182e7223ULL, 0x000fe2000001002eULL,
0x00007610ff187816ULL, 0x000fca000000001cULL, 0x0000001b182d7223ULL, 0x000fe2000001002dULL,
0x00005410ff187816ULL, 0x008fca000000001dULL, 0x0000001b182b7223ULL, 0x000fe2000001002bULL,
0x00007610ff187816ULL, 0x000fca000000001dULL, 0x0000001b182a7223ULL, 0x000fe2000001002aULL,
0x00005410ff187816ULL, 0x010fca000000001eULL, 0x0000001b18297223ULL, 0x000fe20000010029ULL,
0x00007610ff187816ULL, 0x000fca000000001eULL, 0x0000001b18287223ULL, 0x000fe20000010028ULL,
0x00005410ff187816ULL, 0x020fca000000001fULL, 0x0000001b18277223ULL, 0x000fe20000010027ULL,
0x00007610ff187816ULL, 0x000fca000000001fULL, 0x0000001b18267223ULL, 0x000fe20000010026ULL,
0x00005410ff187816ULL, 0x000fca0000000034ULL, 0x0000001b18247223ULL, 0x000fe20000010024ULL,
0x00007610ff187816ULL, 0x000fe20000000034ULL, 0x000000ffff347224ULL, 0x000fc800078e0035ULL,
0x0000001b18237223ULL, 0x000fe20000010023ULL, 0x00005410ff187816ULL, 0x000fe40000000038ULL,
0x0000030034007a0cULL, 0x000fc60003f06070ULL, 0x0000004018167223ULL, 0x000fe20000010016ULL,
0x00007610ff187816ULL, 0x000fca0000000038ULL, 0x0000004018157223ULL, 0x000fe20000010015ULL,
0x00005410ff187816ULL, 0x000fca000000003aULL, 0x0000004018147223ULL, 0x000fe20000010014ULL,
0x00007610ff187816ULL, 0x000fca000000003aULL, 0x0000004018137223ULL, 0x000fe20000010013ULL,
0x00005410ff187816ULL, 0x000fca000000003bULL, 0x0000004018127223ULL, 0x000fe20000010012ULL,
0x00007610ff187816ULL, 0x000fca000000003bULL, 0x0000004018117223ULL, 0x000fe20000010011ULL,
0x00005410ff187816ULL, 0x002fca000000003cULL, 0x0000004018107223ULL, 0x000fe20000010010ULL,
0x00007610ff187816ULL, 0x000fca000000003cULL, 0x00000040180f7223ULL, 0x000fe2000001000fULL,
0x00005410ff187816ULL, 0x000fca000000003dULL, 0x00000040180e7223ULL, 0x000fe2000001000eULL,
0x00007610ff187816ULL, 0x000fca000000003dULL, 0x00000040180d7223ULL, 0x000fe2000001000dULL,
0x00005410ff187816ULL, 0x000fca000000003eULL, 0x00000040180c7223ULL, 0x000fe2000001000cULL,
0x00007610ff187816ULL, 0x000fca000000003eULL, 0x00000040180b7223ULL, 0x000fe2000001000bULL,
0x00005410ff187816ULL, 0x000fca0000000037ULL, 0x00000040180a7223ULL, 0x000fe2000001000aULL,
0x00007610ff187816ULL, 0x000fca0000000037ULL, 0x0000004018097223ULL, 0x000fe20000010009ULL,
0x00005410ff187816ULL, 0x000fca000000003fULL, 0x0000004018087223ULL, 0x000fe20000010008ULL,
0x00007610ff187816ULL, 0x000fca000000003fULL, 0x0000004018077223ULL, 0x000fe20000010007ULL,
0xfffff33000008947ULL, 0x000fea000383ffffULL, 0x0180000033007810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000000007812ULL, 0x000fc600078ec0ffULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe200078e0033ULL,
0x0001760000057802ULL, 0x000fe40000000f00ULL, 0x0000730000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x008fe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300047308ULL, 0x000e640000001000ULL, 0xbf80000004337423ULL, 0x002fc80000000033ULL,
0x800000ff33337221ULL, 0x000fc80000010100ULL, 0x0000003304047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff177819ULL, 0x002fe20000011600ULL,
0x00000004001e7824ULL, 0x040fe200078e00ffULL, 0x00000008001d7811ULL, 0x000fe400078ff0ffULL,
0x00000017ff067212ULL, 0x000fe200078e33ffULL, 0x00001f1704057589ULL, 0x000e6200000e0000ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000071d1b7812ULL, 0x040fe200078ec0ffULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0x00001f1d04047589ULL, 0x000ea200000e0000ULL,
0x0000001dff1c7212ULL, 0x000fc400078e33ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x0000000817067824ULL, 0x000fe200078e00ffULL, 0x0000000c1e1e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8181c7812ULL, 0x000fe400078ee21cULL, 0xfffffff806067812ULL, 0x000fe400078ee217ULL,
0x000000031b187812ULL, 0x040fe200078e3cffULL, 0x000000101c1c7824ULL, 0x100fe200078e0203ULL,
0x000000041b197812ULL, 0x040fe200078e3cffULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x000000051b1a7812ULL, 0x000fe200078e3cffULL, 0x000000081d187824ULL, 0x000fc400078e0218ULL,
0x000000011e067824ULL, 0x000fe200078e0206ULL, 0x0000003205327220ULL, 0x042fe20000410000ULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x000fe20000410000ULL, 0x0000001604167220ULL, 0x044fe20000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000000d040d7220ULL, 0x040fe20000410000ULL, 0x0000000c040c7220ULL, 0x040fe20000410000ULL,
0x0000000b040b7220ULL, 0x040fe20000410000ULL, 0x0000000a040a7220ULL, 0x040fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000000804087220ULL, 0x040fe20000410000ULL,
0x0000000704047220ULL, 0x000fe20000410000ULL, 0x0000000717077812ULL, 0x000fe200078ec0ffULL,
0x0000002e052e7220ULL, 0x000fe20000410000ULL, 0x0000000a0909723eULL, 0x000fe200000010ffULL,
0x0000002d052d7220ULL, 0x040fe20000410000ULL, 0x000000080404723eULL, 0x000fe200000010ffULL,
0x0000002b052b7220ULL, 0x000fe20000410000ULL, 0x0000000107087812ULL, 0x000fe200078e3cffULL,
0x0000002a052a7220ULL, 0x000fe20000410000ULL, 0x0000000c0b0b723eULL, 0x000fe200000010ffULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x00000002070a7812ULL, 0x000fe200078e3cffULL,
0x0000002805287220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fe200000010ffULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x00000003070c7812ULL, 0x000fe200078e3cffULL,
0x0000002605267220ULL, 0x000fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000002405247220ULL, 0x000fe20000410000ULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x0000002305237220ULL, 0x000fe20000410000ULL, 0x00000004070e7812ULL, 0x000fe200078e3cffULL,
0x0000002205227220ULL, 0x000fe20000410000ULL, 0x0000000507107812ULL, 0x000fe200078e3cffULL,
0x0000002105057220ULL, 0x000fe20000410000ULL, 0x0000000607127812ULL, 0x000fe200078e3cffULL,
0x0000000817077824ULL, 0x000fe200078e0208ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000000817087824ULL, 0x000fe200078e020aULL, 0x000000323131723eULL, 0x000fe200000010ffULL,
0x00000008170a7824ULL, 0x000fe200078e020cULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x00000008170c7824ULL, 0x000fe200078e020eULL, 0x000000302f2f723eULL, 0x000fe200000010ffULL,
0x000000081d147824ULL, 0x000fe200078e00ffULL, 0x0000002e2d2d723eULL, 0x000fe200000010ffULL,
0x00000008170e7824ULL, 0x040fe200078e0210ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x0000000817107824ULL, 0x000fe200078e0212ULL, 0x000000011b127812ULL, 0x000fe200078e3cffULL,
0x0000001007077824ULL, 0x100fe200078e0203ULL, 0x000000021b177812ULL, 0x040fe200078e3cffULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0xfffffff814147812ULL, 0x000fe200078ee21dULL,
0x000000100a0a7824ULL, 0x100fe200078e0203ULL, 0x000000061b1b7812ULL, 0x000fe200078e3cffULL,
0x000000100c0c7824ULL, 0x100fe200078e0203ULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x000000081d167824ULL, 0x000fe200078e0212ULL, 0x000000272626723eULL, 0x000fe200000010ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0203ULL, 0x0000003106007388ULL, 0x0003e20000000800ULL,
0x000000011e077824ULL, 0x000fe200078e0207ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x000000081d177824ULL, 0x000fe200078e0217ULL, 0x000000220505723eULL, 0x000fe200000010ffULL,
0x0000001010107824ULL, 0x000fe200078e0203ULL, 0x0000002f07007388ULL, 0x0003e20000000800ULL,
0x000000011e087824ULL, 0x000fc400078e0208ULL, 0x000000101f127824ULL, 0x000fe400078e0203ULL,
0x000000011e0a7824ULL, 0x000fe200078e020aULL, 0x0000002d08007388ULL, 0x0003e20000000800ULL,
0x000000081d197824ULL, 0x040fe400078e0219ULL, 0x0000001014147824ULL, 0x000fe200078e0203ULL,
0x0000002a0a007388ULL, 0x0003e20000000800ULL, 0x000000011e0c7824ULL, 0x000fe400078e020cULL,
0x000000081d1a7824ULL, 0x000fc400078e021aULL, 0x0000001016167824ULL, 0x000fe200078e0203ULL,
0x000000280c007388ULL, 0x0003e20000000800ULL, 0x000000011e0e7824ULL, 0x040fe400078e020eULL,
0x000000081d1b7824ULL, 0x000fe400078e021bULL, 0x0000001017177824ULL, 0x100fe200078e0203ULL,
0x000000260e007388ULL, 0x0003e20000000800ULL, 0x000000011e107824ULL, 0x000fe400078e0210ULL,
0x0000001018187824ULL, 0x000fc400078e0203ULL, 0x000000011e127824ULL, 0x040fe200078e0212ULL,
0x0000002310007388ULL, 0x0003e20000000800ULL, 0x0000001019197824ULL, 0x100fe400078e0203ULL,
0x000000011e147824ULL, 0x000fe200078e0214ULL, 0x0000000512007388ULL, 0x0003e20000000800ULL,
0x000000101a1a7824ULL, 0x100fe400078e0203ULL, 0x000000011e167824ULL, 0x000fe200078e0216ULL,
0x0000001514007388ULL, 0x0003e20000000800ULL, 0x000000101b1b7824ULL, 0x000fc400078e0203ULL,
0x000000011e177824ULL, 0x040fe200078e0217ULL, 0x0000001316007388ULL, 0x0003e20000000800ULL,
0x000000011e187824ULL, 0x040fe400078e0218ULL, 0x000000011e197824ULL, 0x040fe200078e0219ULL,
0x0000001117007388ULL, 0x0003e20000000800ULL, 0x000000011e1a7824ULL, 0x040fe400078e021aULL,
0x000000011e1b7824ULL, 0x040fe200078e021bULL, 0x0000000f18007388ULL, 0x0003e20000000800ULL,
0x000000011e1c7824ULL, 0x000fc600078e021cULL, 0x0000000d19007388ULL, 0x0003e80000000800ULL,
0x0000000b1a007388ULL, 0x0003e80000000800ULL, 0x000000091b007388ULL, 0x0003e80000000800ULL,
0x000000041c007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002000117810ULL, 0x002fe20007ffe0ffULL, 0x0000000000077919ULL, 0x000e620000002600ULL,
0x00000003ff037819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff057819ULL, 0x100fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000703047812ULL, 0x000fe200078e4800ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000705067812ULL, 0x000fc400078e4811ULL, 0x0ffffff804047812ULL, 0x000fe400078ef800ULL,
0x0ffffff806067812ULL, 0x000fe400078ef811ULL, 0x0000000700107812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x100fe400078e0202ULL, 0x0000001006067824ULL, 0x000fc600078e0202ULL,
0x00a0000004087984ULL, 0x000ee80000000c00ULL, 0x00a00000060c7984ULL, 0x0009620000000c00ULL,
0x0000000807027824ULL, 0x042fe400078e00ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0xfffffff802037812ULL, 0x000fc400078ee203ULL,
0xfffffff807057812ULL, 0x000fe400078ee205ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000711067812ULL, 0x010fe200078ec0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fe200078048ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078248ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff810007812ULL, 0x100fe400078ef82cULL,
0x00005b0005057a11ULL, 0x000fe400008f4c07ULL, 0x1ffffff806067812ULL, 0x000fe200078ef82cULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001006047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x00000006043c7981ULL, 0x000362000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000103007810ULL, 0x000fe20007ffe0ffULL,
0x000000022b2b7824ULL, 0x000fe200078e00ffULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000004025277824ULL, 0x000fe200078e00ffULL, 0x000000020000720cULL, 0x000fe20003f06070ULL,
0x000058002b267a24ULL, 0x000fe400078e0226ULL, 0x00000100030d7824ULL, 0x000fc800078e0227ULL,
0x00006200261d7a24ULL, 0x000fcc00078e020dULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff167819ULL, 0x000fe2000001162dULL, 0x00000100ff197424ULL, 0x000fe200078e00ffULL,
0x000000300b187812ULL, 0x000fe400078ec0ffULL, 0x0000000816107810ULL, 0x040fe20007ffe0ffULL,
0x0000000116067824ULL, 0x140fe200078e021dULL, 0x0000001016177810ULL, 0x040fe40007ffe0ffULL,
0x00000018161a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110087824ULL, 0x000fe200078e021dULL,
0x0000000d24007217ULL, 0x000fe20007800000ULL, 0x00005e0006067625ULL, 0x000fe200078e0019ULL,
0x0000002016147810ULL, 0x000fc40007ffe0ffULL, 0x00000003ff127819ULL, 0x100fe2000001162dULL,
0x00005e0008087625ULL, 0x080fe200078e0019ULL, 0x00000018060e7210ULL, 0x080fe40007f1e0ffULL,
0x0000000312127812ULL, 0x000fe200078e482dULL, 0x00000001170a7824ULL, 0x100fe200078e021dULL,
0x0000001808087210ULL, 0x000fe20007f3e0ffULL, 0x000000011a0c7824ULL, 0x000fe200078e021dULL,
0x0000200025137811ULL, 0x000fe200078e68ffULL, 0x0000000100007824ULL, 0x000fe200078e0a0dULL,
0x0ffffffc122d7812ULL, 0x000fe200078ef82dULL, 0x00005e000a0a7625ULL, 0x000fe200078e0019ULL,
0x0000002816157810ULL, 0x000fc40007ffe0ffULL, 0x000000001700720cULL, 0x080fe20003fa6070ULL,
0x00005e000c0c7625ULL, 0x080fe200078e0019ULL, 0x000000001a00720cULL, 0x080fe40003f86070ULL,
0x000000001400720cULL, 0x000fe20003f66070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0607ULL,
0x000000180a0a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x000000180c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000011d067824ULL, 0x000fe400078e0214ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x000000001600720cULL, 0x000fe20003f06070ULL,
0x00005e0006067625ULL, 0x000fc800078e0019ULL, 0x0000000410117824ULL, 0x040fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000001000720cULL, 0x000fe20003f26070ULL,
0x000000102d2d7824ULL, 0x000fe200078e0213ULL, 0x0000001806107210ULL, 0x000fe20007f5e0ffULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc11067812ULL, 0x000fe400078ee212ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e2d7faeULL, 0x0005e2000c101c46ULL,
0x000000ffff117224ULL, 0x000fe200010e0607ULL, 0x000000001500720cULL, 0x000fe20003f46070ULL,
0x0000001006067824ULL, 0x000fc400078e0213ULL, 0x000000011d077824ULL, 0x000fc600078e0215ULL,
0x0000000008067faeULL, 0x0007e4000c901c46ULL, 0x00005e0007067625ULL, 0x088fe200078e0019ULL,
0x0000003016087810ULL, 0x040fe40007ffe0ffULL, 0x0000003816097810ULL, 0x000fe20007ffe0ffULL,
0x0000000414167824ULL, 0x000fe200078e00ffULL, 0x00000018060e7210ULL, 0x004fe20007fde0ffULL,
0x000000011d067824ULL, 0x000fe200078e0208ULL, 0x000000000800720cULL, 0x0c0fe20003f26070ULL,
0x00000004081b7824ULL, 0x000fe200078e00ffULL, 0x000000000900720cULL, 0x000fe20003f06070ULL,
0x0000000417007824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a147812ULL, 0x100fe200078ee212ULL,
0x0000000415177824ULL, 0x000fe200078e00ffULL, 0xfffffffc16157812ULL, 0x100fe200078ee212ULL,
0x000000ffff0f7224ULL, 0x000fe200030e0607ULL, 0xfffffffc00007812ULL, 0x100fe200078ee212ULL,
0x000000011d087824ULL, 0x000fe200078e0209ULL, 0xfffffffc17167812ULL, 0x100fe200078ee212ULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b177812ULL, 0x000fe200078ee212ULL,
0x00005e0006067625ULL, 0x000fc600078e0019ULL, 0xfffffffc09127812ULL, 0x000fe200078ee212ULL,
0x00005e0008087625ULL, 0x000fe200078e0019ULL, 0x0000001806067210ULL, 0x000fc60007fde0ffULL,
0x0000001000007824ULL, 0x000fe400078e0213ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000001808087210ULL, 0x000fe20007fde0ffULL, 0x0000001014147824ULL, 0x100fe200078e0213ULL,
0x000000000a007faeULL, 0x0005e2000e901c46ULL, 0x0000001015157824ULL, 0x100fe400078e0213ULL,
0x0000001016167824ULL, 0x100fe200078e0213ULL, 0x000000000c147faeULL, 0x0005e2000e101c46ULL,
0x0000001017177824ULL, 0x000fc400078e0213ULL, 0x0000001012127824ULL, 0x000fe200078e0213ULL,
0x0000000010157faeULL, 0x0005e2000d901c46ULL, 0x000000ffff097224ULL, 0x000fc600030e0609ULL,
0x000000000e167faeULL, 0x0005e8000d101c46ULL, 0x0000000006177faeULL, 0x0005e8000c901c46ULL,
0x0000000008127faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001162dULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x000000082d087811ULL, 0x000fc400078ff0ffULL, 0x000000102d077811ULL, 0x040fe400078ff0ffULL,
0x0000001d2d067211ULL, 0x040fe200078ff0ffULL, 0x0000000408107824ULL, 0x000fe200078e00ffULL,
0x00000003001e7812ULL, 0x000fe200078e482dULL, 0x0000000108007824ULL, 0x000fe200078e021dULL,
0x000000282d0c7811ULL, 0x000fe200078ff0ffULL, 0x000000011d087824ULL, 0x000fe200078e0207ULL,
0x000000300b207812ULL, 0x000fe200078ec0ffULL, 0x0000000407117824ULL, 0x000fe200078e00ffULL,
0x000000202d0b7811ULL, 0x040fe200078ff0ffULL, 0x00005e0006067625ULL, 0x000fe200078e001fULL,
0x000000182d097811ULL, 0x000fc400078ff0ffULL, 0x000000302d0d7811ULL, 0x000fe200078ff0ffULL,
0x000000011d197824ULL, 0x000fe200078e020cULL, 0x000000382d0e7811ULL, 0x000fe200078ff0ffULL,
0x000000040c137824ULL, 0x000fe200078e00ffULL, 0xfffffffc100c7812ULL, 0x100fe200078ee21eULL,
0x000000040b127824ULL, 0x000fe200078e00ffULL, 0x0000002006107210ULL, 0x000fe20007f1e0ffULL,
0x000000011d0a7824ULL, 0x000fe200078e0209ULL, 0x0000200025217811ULL, 0x000fe200078e68ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc12127812ULL, 0x100fe200078ee21eULL,
0x000000011d1b7824ULL, 0x000fe200078e020dULL, 0x0ffffffc1e2d7812ULL, 0x000fe200078ef82dULL,
0x000000040d157824ULL, 0x000fe200078e00ffULL, 0xfffffffc110d7812ULL, 0x100fe200078ee21eULL,
0x000000011d0f7824ULL, 0x000fe200078e020bULL, 0xfffffffc13137812ULL, 0x100fe200078ee21eULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0xfffffffc15157812ULL, 0x000fe200078ee21eULL,
0x000000011d1d7824ULL, 0x000fc400078e020eULL, 0x000000040e0b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc090e7812ULL, 0x000fe200078ee21eULL, 0x00005e0000067625ULL, 0x000fc600078e001fULL,
0xfffffffc0b1e7812ULL, 0x000fe200078ee21eULL, 0x00005e0008087625ULL, 0x000fc800078e001fULL,
0x0000001012187824ULL, 0x000fe200078e0221ULL, 0x0000002006127210ULL, 0x080fe20007f1e0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e001fULL, 0x0000002008147210ULL, 0x000fc60007f3e0ffULL,
0x00000010131a7824ULL, 0x000fe400078e0221ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x000000200a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010151c7824ULL, 0x000fe400078e0221ULL,
0x000000ffff157224ULL, 0x000fe400008e0609ULL, 0x00005e000f067625ULL, 0x000fc800078e001fULL,
0x000000100c007824ULL, 0x100fe400078e0221ULL, 0x000000100d167824ULL, 0x000fe400078e0221ULL,
0x00005e0019087625ULL, 0x000fc800078e001fULL, 0x000000100e177824ULL, 0x000fe200078e0221ULL,
0x0000002008087210ULL, 0x000fe20007f3e0ffULL, 0x00005e001b0c7625ULL, 0x000fc800078e001fULL,
0x00005e001d0e7625ULL, 0x000fe200078e001fULL, 0x000000200c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002006067210ULL, 0x080fe20007f1e0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0221ULL, 0x000000200e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0609ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff0d7224ULL, 0x000fe400010e060dULL, 0x000000101e1e7824ULL, 0x000fe200078e0221ULL,
0x0000000012007faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x0000000014167faeULL, 0x0005e8000b901c46ULL, 0x000000000a177faeULL, 0x0005e8000b901c46ULL,
0x0000000006187faeULL, 0x0005e8000b901c46ULL, 0x00000000081a7faeULL, 0x0005e8000b901c46ULL,
0x000000000c1c7faeULL, 0x0005e8000b901c46ULL, 0x000000000e1e7faeULL, 0x0005e4000b901c46ULL,
0x01060400ff007984ULL, 0x004ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x006fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000002025007824ULL, 0x002fc800078e0200ULL, 0x0000002000057824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x000001e005057812ULL, 0x000fe400078ec0ffULL, 0x0000000104077812ULL, 0x040fe400078efcffULL,
0x0000000704067812ULL, 0x140fe400078e7800ULL, 0x0000000707077812ULL, 0x000fe400078e7800ULL,
0x0000001004107810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x040fe200078e0206ULL,
0x0000001104047810ULL, 0x000fe20007ffe0ffULL, 0x0000000105077824ULL, 0x000fe200078e0207ULL,
0x0000000710107812ULL, 0x000fc400078e7800ULL, 0x00000000060c7984ULL, 0x000e62000000cc00ULL,
0x0000000704047812ULL, 0x000fe400078e7800ULL, 0x0000000105107824ULL, 0x040fe200078e0210ULL,
0x0000000007087984ULL, 0x000ea4000000cc00ULL, 0x0000000105047824ULL, 0x000fe400078e0204ULL,
0x000000ffff147224ULL, 0x002fe400078e000cULL, 0x000000ffff157224ULL, 0x000fc400078e000eULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fe200078e000fULL,
0x0000001406007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fca00078e000bULL, 0x0000001807007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x004fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001c10007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff047f8cULL, 0x002fe8000c80043fULL, 0x01060400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003d7919ULL, 0x000e620000000000ULL,
0x3d8000003c3c7820ULL, 0x020fe20000410000ULL, 0x00010688253b7811ULL, 0x040fe200078e18ffULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0xffffffff023a7810ULL, 0x000fe40007ffe0ffULL,
0x0001060825397811ULL, 0x000fe400078e28ffULL, 0x00000100033e7824ULL, 0x000fe200078e0227ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003e2400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff007224ULL, 0x000fe200078e0038ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x000000013f287810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e003fULL,
0x0000000100387812ULL, 0x000fc400078e0cffULL, 0x00000002ff297819ULL, 0x100fe20000011628ULL,
0x000000ffff3f7224ULL, 0x000fe200078e0028ULL, 0x000000042800780cULL, 0x000fc60003f06070ULL,
0x0000030029297a24ULL, 0x000fc800078e0203ULL, 0x00000100292c7824ULL, 0x040fe200078e0227ULL,
0x00000001292a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000328297812ULL, 0x000fe200078ec0ffULL,
0x0000620026367a24ULL, 0x000fe200078e022cULL, 0x000000022a00720cULL, 0x000fda0003f26070ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000000429347824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x102fe2000001163dULL, 0x0000000225357824ULL, 0x000fe200078e0238ULL,
0x0000002c24287217ULL, 0x000fe20007800000ULL, 0x00000100ff337424ULL, 0x000fe200078e00ffULL,
0x00000002ff2f7819ULL, 0x100fe4000001163dULL, 0x0000000329317812ULL, 0x100fe200078e483dULL,
0x00000001282c7824ULL, 0x000fe200078e0a2cULL, 0x000000082f297810ULL, 0x040fe20007ffe0ffULL,
0x000000012f287824ULL, 0x000fe200078e0236ULL, 0xfffffffc34347812ULL, 0x000fc400078ee23dULL,
0x0000002c2f00720cULL, 0x080fe20003f26070ULL, 0x00000001292a7824ULL, 0x040fe200078e0236ULL,
0x0000002c2900720cULL, 0x040fe20003f46070ULL, 0x00000004292e7824ULL, 0x000fe200078e00ffULL,
0x0000200035357811ULL, 0x000fe200078e60ffULL, 0x00005e0028287625ULL, 0x080fe200078e0033ULL,
0x0ffffffc312d7812ULL, 0x000fe400078ef83dULL, 0xfffffffc2e2e7812ULL, 0x000fe200078ee231ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0033ULL, 0x000000282f307810ULL, 0x000fc40007ffe0ffULL,
0x000000302f327810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0235ULL,
0x0000002c3000720cULL, 0x080fe20003f86070ULL, 0x0000001034287825ULL, 0x000fe200078e0028ULL,
0x0000002c3200720cULL, 0x000fc60003fa6070ULL, 0x000000102e2e7824ULL, 0x000fe200078e0235ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0003e2000c901c46ULL,
0x00000010342a7825ULL, 0x000fc800078e002aULL, 0x0000000430417824ULL, 0x000fe200078e00ffULL,
0x000000002a2e7faeULL, 0x0005e2000d101c46ULL, 0x0000000432427824ULL, 0x000fc600078e00ffULL,
0xfffffffc41417812ULL, 0x100fe400078ee231ULL, 0x000000102f297810ULL, 0x042fe40007ffe0ffULL,
0x000000182f2d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002c2900720cULL, 0x0c0fe20003f26070ULL,
0x0000000129287824ULL, 0x100fe200078e0236ULL, 0x000000202f2b7810ULL, 0x004fe20007ffe0ffULL,
0x0000000429297824ULL, 0x000fe200078e00ffULL, 0x000000382f2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000042d377824ULL, 0x040fe200078e00ffULL, 0x0000002c2d00720cULL, 0x080fe20003f46070ULL,
0x000000042b407824ULL, 0x040fe200078e00ffULL, 0x0000002c2b00720cULL, 0x080fe20003f66070ULL,
0x000000042f437824ULL, 0x040fe200078e00ffULL, 0x0000002c2f00720cULL, 0x000fe20003fc6070ULL,
0x00000001302e7824ULL, 0x100fe200078e0236ULL, 0xfffffffc37377812ULL, 0x100fe200078ee231ULL,
0x000000012d2a7824ULL, 0x100fe200078e0236ULL, 0xfffffffc40407812ULL, 0x100fe200078ee231ULL,
0x000000012b2c7824ULL, 0x100fe200078e0236ULL, 0xfffffffc42427812ULL, 0x100fe200078ee231ULL,
0x0000000132307824ULL, 0x100fe200078e0236ULL, 0xfffffffc43437812ULL, 0x100fe200078ee231ULL,
0x000000012f327824ULL, 0x000fe200078e0236ULL, 0xfffffffc29367812ULL, 0x000fe200078ee231ULL,
0x00005e0028287625ULL, 0x000fc800078e0033ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0033ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0033ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0033ULL,
0x00005e0030307625ULL, 0x000fc800078e0033ULL, 0x00005e0032327625ULL, 0x000fc800078e0033ULL,
0x0000001034287825ULL, 0x000fc800078e0028ULL, 0x00000010342a7825ULL, 0x000fc800078e002aULL,
0x00000010342c7825ULL, 0x000fc800078e002cULL, 0x00000010342e7825ULL, 0x000fc800078e002eULL,
0x0000001034307825ULL, 0x000fc800078e0030ULL, 0x0000001034327825ULL, 0x000fc800078e0032ULL,
0x0000001036347824ULL, 0x100fe400078e0235ULL, 0x0000001037367824ULL, 0x100fe400078e0235ULL,
0x0000001040377824ULL, 0x100fe200078e0235ULL, 0x0000000028347faeULL, 0x0003e2000c901c46ULL,
0x0000001041407824ULL, 0x100fe400078e0235ULL, 0x0000001042417824ULL, 0x100fe200078e0235ULL,
0x000000002a367faeULL, 0x0003e2000d101c46ULL, 0x0000001043357824ULL, 0x000fc600078e0235ULL,
0x000000002c377faeULL, 0x0003e8000d901c46ULL, 0x000000002e407faeULL, 0x0003e8000e101c46ULL,
0x0000000030417faeULL, 0x0003e8000e901c46ULL, 0x0000000032357faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x00000002252a7824ULL, 0x000fe200078e0238ULL,
0x000000083d2c7811ULL, 0x002fe200078ff0ffULL, 0x0000000429407824ULL, 0x000fe200078e00ffULL,
0x000000103d2d7811ULL, 0x040fe200078ff0ffULL, 0x00000100ff377424ULL, 0x000fe200078e00ffULL,
0x000000183d2f7811ULL, 0x040fe200078ff0ffULL, 0x000000042c427824ULL, 0x000fe200078e00ffULL,
0x000000203d317811ULL, 0x000fe200078ff0ffULL, 0x000000042d437824ULL, 0x000fe200078e00ffULL,
0x000000283d337811ULL, 0x000fe200078ff0ffULL, 0x000000042f447824ULL, 0x000fe200078e00ffULL,
0x000000303d357811ULL, 0x000fe200078ff0ffULL, 0x0000000431457824ULL, 0x000fe200078e00ffULL,
0x000000383d417811ULL, 0x000fe200078ff0ffULL, 0x0000000433497824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x100fe2000001163dULL, 0x00000004354a7824ULL, 0x000fe200078e00ffULL,
0x000020002a467811ULL, 0x000fe200078e60ffULL, 0x00000004414b7824ULL, 0x000fe200078e00ffULL,
0x000000363d287211ULL, 0x000fe200078ff0ffULL, 0x000000012c2a7824ULL, 0x100fe200078e0236ULL,
0x00000003292b7812ULL, 0x100fe200078e483dULL, 0x000000012d2c7824ULL, 0x100fe200078e0236ULL,
0xfffffffc40407812ULL, 0x000fe200078ee23dULL, 0x000000012f2e7824ULL, 0x100fe200078e0236ULL,
0xfffffffc42427812ULL, 0x100fe200078ee22bULL, 0x0000000131307824ULL, 0x100fe200078e0236ULL,
0xfffffffc43437812ULL, 0x100fe200078ee22bULL, 0x0000000133327824ULL, 0x100fe200078e0236ULL,
0xfffffffc44447812ULL, 0x100fe200078ee22bULL, 0x0000000135347824ULL, 0x100fe200078e0236ULL,
0xfffffffc45457812ULL, 0x100fe200078ee22bULL, 0x0000000141367824ULL, 0x000fe200078e0236ULL,
0xfffffffc49497812ULL, 0x100fe200078ee22bULL, 0x00005e0028287625ULL, 0x000fe200078e0037ULL,
0xfffffffc4a4a7812ULL, 0x000fc400078ee22bULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee22bULL,
0x00005e002c2c7625ULL, 0x000fe200078e0037ULL, 0x0ffffffc2b417812ULL, 0x000fc600078ef83dULL,
0x00005e002a2a7625ULL, 0x000fc800078e0037ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0037ULL,
0x00005e0030307625ULL, 0x000fc800078e0037ULL, 0x00005e0032327625ULL, 0x000fc800078e0037ULL,
0x00005e0034347625ULL, 0x000fc800078e0037ULL, 0x00005e0036367625ULL, 0x000fc800078e0037ULL,
0x0000001040287825ULL, 0x000fc800078e0028ULL, 0x00000010402a7825ULL, 0x000fc800078e002aULL,
0x00000010402c7825ULL, 0x000fc800078e002cULL, 0x00000010402e7825ULL, 0x000fc800078e002eULL,
0x0000001040307825ULL, 0x000fc800078e0030ULL, 0x0000001040327825ULL, 0x000fc800078e0032ULL,
0x0000001040347825ULL, 0x000fc800078e0034ULL, 0x0000001040367825ULL, 0x000fc800078e0036ULL,
0x0000001041487824ULL, 0x100fe400078e0246ULL, 0x0000001042407824ULL, 0x100fe400078e0246ULL,
0x0000001043417824ULL, 0x100fe200078e0246ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028487faeULL, 0x0003e2000b901c46ULL, 0x0000001044427824ULL, 0x100fe400078e0246ULL,
0x0000001045437824ULL, 0x100fe200078e0246ULL, 0x000000002a407faeULL, 0x0003e2000b901c46ULL,
0x0000001049447824ULL, 0x000fc400078e0246ULL, 0x000000104a457824ULL, 0x100fe200078e0246ULL,
0x000000002c417faeULL, 0x0003e2000b901c46ULL, 0x000000104b467824ULL, 0x000fc600078e0246ULL,
0x000000002e427faeULL, 0x0003e8000b901c46ULL, 0x0000000030437faeULL, 0x0003e8000b901c46ULL,
0x0000000032447faeULL, 0x0003e8000b901c46ULL, 0x0000000034457faeULL, 0x0003e8000b901c46ULL,
0x0000000036467faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000847417824ULL, 0x002fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83d287812ULL, 0x000fe200078ec0ffULL, 0x00000002252c7824ULL, 0x000fe200078e0200ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001402f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000728287812ULL, 0x000fe400078ef83dULL, 0x000020002c2c7811ULL, 0x000fe400078e60ffULL,
0x00000001ff297819ULL, 0x000fc40000011628ULL, 0x000000073dcb7812ULL, 0x000fe400078ec0ffULL,
0x0000000329297812ULL, 0x000fe400078ec0ffULL, 0x00000008cbcb7812ULL, 0x000fe400078ef83dULL,
0x00000040292a7212ULL, 0x040fe400078e3cffULL, 0x0000002f29297212ULL, 0x000fc600078e3cffULL,
0x00000004282a7824ULL, 0x040fe400078e022aULL, 0x0000000428297824ULL, 0x000fe200078e0229ULL,
0x000000203d287810ULL, 0x000fe20007ffe0ffULL, 0x000000102a2a7824ULL, 0x100fe400078e022cULL,
0x0000001029297824ULL, 0x000fe200078e022cULL, 0xfffffff828287812ULL, 0x000fe400078ec0ffULL,
0x000000002a34783bULL, 0x000e640000000200ULL, 0x00000007282d7812ULL, 0x000fc400078ef83dULL,
0x000000002930783bULL, 0x000ea40000000200ULL, 0x00000001ff287819ULL, 0x000fc8000001162dULL,
0x00000003282e7812ULL, 0x000fc800078ec0ffULL, 0x000000402e287212ULL, 0x040fe400078e3cffULL,
0x0000002f2e2e7212ULL, 0x000fe400078e3cffULL, 0x0000000240407810ULL, 0x000fe20007ffe0ffULL,
0x000000042d287824ULL, 0x040fe400078e0228ULL, 0x000000042d2e7824ULL, 0x000fe400078e022eULL,
0x0000001028287824ULL, 0x100fe400078e022cULL, 0x000000102e2e7824ULL, 0x000fc800078e022cULL,
0x000000002828783bULL, 0x000ee80000000200ULL, 0x000000002e2c783bULL, 0x000f220000000200ULL,
0x0000003400717306ULL, 0x002fe20000009400ULL, 0x00000018ffad7819ULL, 0x000fe20000011434ULL,
0x00010000345c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011435ULL,
0x0001000030777824ULL, 0x044fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fe20000011436ULL,
0x00010000317a7824ULL, 0x040fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe2000001145cULL,
0x0000003400a67306ULL, 0x000e620000005400ULL, 0x00000018ff847819ULL, 0x000fe20000011437ULL,
0x00000100307c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000010031807824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0001000032727824ULL, 0x040fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011430ULL,
0x00000034005b7306ULL, 0x000562000000d400ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000010032697824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fc40000011432ULL,
0x00000018ff607819ULL, 0x000fe40000011431ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x004fe200078e00ffULL,
0x000000a67100720bULL, 0x002fe40003f9d000ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0001000028c47824ULL, 0x008fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe20000011434ULL,
0x0001000035347824ULL, 0x000fe200078e00ffULL, 0x000000a700a97306ULL, 0x000e620000205400ULL,
0x00000018ff9e7819ULL, 0x000fc40000011428ULL, 0x00000018ff927819ULL, 0x000fe40000011429ULL,
0x00000018ffb07819ULL, 0x000fe20000011434ULL, 0x0001000036347824ULL, 0x000fe200078e00ffULL,
0x000000015b5b4812ULL, 0x020fe200078efcffULL, 0x0000003500a27306ULL, 0x000fe20000009400ULL,
0x00000018ffc47819ULL, 0x000fe400000114c4ULL, 0x00000018ffb87819ULL, 0x000fe20000011434ULL,
0x0001000037347824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc4000001142aULL,
0x00000018ff837819ULL, 0x000fe2000001142bULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a9a800720bULL, 0x002fe20003f5d000ULL, 0x0000010029a87824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe40000011434ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000000b000b27306ULL, 0x000e620000205400ULL,
0x00000018ff4c7819ULL, 0x000fce0000011433ULL, 0x0000003500a37306ULL, 0x000eb00000005400ULL,
0x000000aa00ab7306ULL, 0x000fe20000209400ULL, 0x000000b2b100720bULL, 0x002fce0003fbd000ULL,
0x000000aa00ac7306ULL, 0x0002e20000205400ULL, 0x000000a3a200720bULL, 0x004fe40003f3d000ULL,
0x000000a700a27245ULL, 0x000fe4000020d400ULL, 0x000000aa00a37245ULL, 0x000fe4000020d400ULL,
0x00000001a2a22812ULL, 0x000fe200078efcffULL, 0x0000003600a07306ULL, 0x000fe20000009400ULL,
0x000100002aaa7824ULL, 0x002fe400078e00ffULL, 0x0000005ba2a2723eULL, 0x000fc600000010ffULL,
0x00000018ffaa7819ULL, 0x000fe400000114aaULL, 0x0000003600a17306ULL, 0x000e620000005400ULL,
0x000000acab00720bULL, 0x008fce0003f7d000ULL, 0x00000035005a7306ULL, 0x0004ec000000d400ULL,
0x00000001a3a33812ULL, 0x000fe400078efcffULL, 0x000000ad00ae7306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x004fe200078e00ffULL, 0x000000a1a000720bULL, 0x002fc40003f5d000ULL,
0x000000b000a07245ULL, 0x000fe4000020d400ULL, 0x00000018ffb37819ULL, 0x000fe40000011435ULL,
0x000000ad00af7306ULL, 0x000e620000205400ULL, 0x00000001a0a05812ULL, 0x000fe400078efcffULL,
0x000000ad00a17245ULL, 0x000fe4000020d400ULL, 0x000000015a5a1812ULL, 0x008fc600078efcffULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x0000005aa05a723eULL, 0x000fce00000010ffULL,
0x000000b800ba7306ULL, 0x0004e20000205400ULL, 0x000000afae00720bULL, 0x002fce0003fdd000ULL,
0x000000b300b47306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x004fca000020d400ULL,
0x00000001a1a16812ULL, 0x000fe400078efcffULL, 0x000000b300b57306ULL, 0x000e620000205400ULL,
0x000000bab900720bULL, 0x008fe40003fbd000ULL, 0x000000a3a1a3723eULL, 0x000fca00000010ffULL,
0x0000003600577306ULL, 0x0004ec000000d400ULL, 0x00000001b8b85812ULL, 0x000fe400078efcffULL,
0x00000037009d7306ULL, 0x000fe20000009400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x000000b5b400720bULL, 0x002fc80003f7d000ULL, 0x00000018ffbb7819ULL, 0x000fe20000011436ULL,
0x0000010033367824ULL, 0x000fe200078e00ffULL, 0x00000037009c7306ULL, 0x000e620000005400ULL,
0x0000000157572812ULL, 0x008fe400078efcffULL, 0x000000bb00b97245ULL, 0x000fe4000020d400ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000057b8b8723eULL, 0x000fe200000010ffULL,
0x000000be00bf7306ULL, 0x000ff00000209400ULL, 0x000000be00c07306ULL, 0x0004e20000205400ULL,
0x0000009c9d00720bULL, 0x002fc40003fdd000ULL, 0x000000b3009c7245ULL, 0x000fc8000020d400ULL,
0x000000019c9c3812ULL, 0x000fe200078efcffULL, 0x0000009f00b67306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x004fce000020d400ULL, 0x0000009f00b77306ULL, 0x0002a20000205400ULL,
0x000000c0bf00720bULL, 0x008fce0003fbd000ULL, 0x00000028008d7306ULL, 0x000fe20000009400ULL,
0x0000009f009f7245ULL, 0x002fca000020d400ULL, 0x00000001bebe5812ULL, 0x000fe400078efcffULL,
0x00000028008f7306ULL, 0x000e620000005400ULL, 0x000000b7b600720bULL, 0x004fce0003f9d000ULL,
0x0000002800527306ULL, 0x0004ec000000d400ULL, 0x000000019f9f4812ULL, 0x000fe400078efcffULL,
0x0000008400957306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x0000008f8d00720bULL, 0x002fc40003fbd000ULL, 0x00000084008d7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc77819ULL, 0x000fe20000011428ULL, 0x0001000029287824ULL, 0x000fe200078e00ffULL,
0x0000008400937306ULL, 0x0002a20000205400ULL, 0x0000009c9f5b723eULL, 0x000fc600000010ffULL,
0x00000018ffca7819ULL, 0x000fe40000011428ULL, 0x000000413d287211ULL, 0x000fe400078fe0ffULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x000000c400847245ULL, 0x002fe4000020d400ULL,
0x0000000228717810ULL, 0x040fe40007ffe0ffULL, 0x0000000728287812ULL, 0x100fe400078e78cbULL,
0x0000000152525812ULL, 0x008fe200078efcffULL, 0x000000bb00bd7306ULL, 0x000e620000205400ULL,
0x000000939500720bULL, 0x004fe20003f5d000ULL, 0x00000020cb287824ULL, 0x000fe200078e0228ULL,
0x0000000771717812ULL, 0x000fc400078e78cbULL, 0x0000000441417810ULL, 0x000fe20007ffe0ffULL,
0x0000001028287824ULL, 0x000fe400078e00ffULL, 0x0000003700537306ULL, 0x0004e2000000d400ULL,
0x00000020cb717824ULL, 0x000fe200078e0271ULL, 0x000000a800cb7245ULL, 0x000fc8000020d400ULL,
0x000000018d8d2812ULL, 0x000fe400078efcffULL, 0x0000003000967306ULL, 0x000fe20000009400ULL,
0x0000010037377824ULL, 0x004fe200078e00ffULL, 0x000000bdbc00720bULL, 0x002fc80003f7d000ULL,
0x00000018ffc17819ULL, 0x000fe20000011437ULL, 0x0001000033377824ULL, 0x000fe200078e00ffULL,
0x00000030009a7306ULL, 0x000e620000005400ULL, 0x0000000153536812ULL, 0x008fe400078efcffULL,
0x000000c100bf7245ULL, 0x000fe4000020d400ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x00000001b9b93812ULL, 0x000fe200078efcffULL, 0x0000009400997306ULL, 0x000fe20000209400ULL,
0x00000053bebe723eULL, 0x000fce00000010ffULL, 0x00000094009b7306ULL, 0x0004e20000205400ULL,
0x0000009a9600720bULL, 0x002fe20003f3d000ULL, 0x000001002a967824ULL, 0x000fe400078e00ffULL,
0x000001002b9a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff967819ULL, 0x000fe20000011496ULL,
0x00000029008c7306ULL, 0x000fe20000009400ULL, 0x0000009400947245ULL, 0x004fe4000020d400ULL,
0x00000018ff9a7819ULL, 0x000fe4000001149aULL, 0x0000009600ab7245ULL, 0x000fc6000020d400ULL,
0x0000002900887306ULL, 0x000fe20000005400ULL, 0x0000009b9900720bULL, 0x008fe20003f9d000ULL,
0x000100002b997824ULL, 0x000fca00078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x00000029004d7306ULL, 0x000fec000000d400ULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x000000c100c27306ULL, 0x000fe40000209400ULL, 0x000000b994b9723eULL, 0x000fcc00000010ffULL,
0x000000c100c37306ULL, 0x000e700000205400ULL, 0x000000ca00a67306ULL, 0x000ff00000209400ULL,
0x000000ca00297306ULL, 0x0004e20000205400ULL, 0x000000c3c200720bULL, 0x002fce0003f7d000ULL,
0x000000c400c57306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x004fca000020d400ULL,
0x00000001bfbf3812ULL, 0x000fe400078efcffULL, 0x000000c400c67306ULL, 0x000e620000205400ULL,
0x00000029a600720bULL, 0x008fe40003f5d000ULL, 0x000000bf8dbf723eULL, 0x000fca00000010ffULL,
0x0000002a007d7306ULL, 0x000fec0000009400ULL, 0x00000001caca2812ULL, 0x000fe400078efcffULL,
0x0000002a007e7306ULL, 0x000fe20000005400ULL, 0x000000c6c500720bULL, 0x002fce0003f9d000ULL,
0x0000002a004b7306ULL, 0x000fec000000d400ULL, 0x0000000184844812ULL, 0x000fe400078efcffULL,
0x0000009e00a57306ULL, 0x000fe20000209400ULL, 0x000000888c00720bULL, 0x000fe40003f9d000ULL,
0x000000528452723eULL, 0x000fca00000010ffULL, 0x0000009e00a47306ULL, 0x0002ac0000205400ULL,
0x000000014d4d4812ULL, 0x000fe400078efcffULL, 0x000000c700c87306ULL, 0x000fe20000209400ULL,
0x0000009e009e7245ULL, 0x002fe4000020d400ULL, 0x0000004dcaca723eULL, 0x000fca00000010ffULL,
0x000000c700c97306ULL, 0x0002e20000205400ULL, 0x000000a4a500720bULL, 0x004fce0003fdd000ULL,
0x000000aa009d7306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x002fca000020d400ULL,
0x000000019e9e6812ULL, 0x000fe400078efcffULL, 0x000000aa002a7306ULL, 0x0002a20000205400ULL,
0x000000c9c800720bULL, 0x008fce0003f7d000ULL, 0x0000002b00757306ULL, 0x000fe20000009400ULL,
0x000000aa00aa7245ULL, 0x002fca000020d400ULL, 0x00000001c7c73812ULL, 0x000fe400078efcffULL,
0x0000002b00767306ULL, 0x000e620000005400ULL, 0x0000002a9d00720bULL, 0x004fe40003f5d000ULL,
0x0000007e7d00720bULL, 0x000fe40003f7d000ULL, 0x000000c79e53723eULL, 0x000fe400000010ffULL,
0x00000018ff7d7819ULL, 0x010fe2000001142eULL, 0x0000009200977306ULL, 0x000fec0000209400ULL,
0x00000001aaaa2812ULL, 0x000fc400078efcffULL, 0x0000009200987306ULL, 0x0004e20000205400ULL,
0x000000767500720bULL, 0x002fe20003f5d000ULL, 0x000100002d767824ULL, 0x000fe200078e00ffULL,
0x000000014b4b3812ULL, 0x000fc800078efcffULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000002b004a7306ULL, 0x000e62000000d400ULL, 0x0000009200927245ULL, 0x004fe4000020d400ULL,
0x0000004baaaa723eULL, 0x000fca00000010ffULL, 0x0000007700877306ULL, 0x000fe20000209400ULL,
0x000000989700720bULL, 0x008fce0003fdd000ULL, 0x0000007700897306ULL, 0x0004e20000205400ULL,
0x000000014a4a2812ULL, 0x002fca00078efcffULL, 0x0000000192926812ULL, 0x000fe400078efcffULL,
0x00000099008f7306ULL, 0x000fe20000209400ULL, 0x0000007700777245ULL, 0x004fce000020d400ULL,
0x0000009900297306ULL, 0x0002a20000205400ULL, 0x000000898700720bULL, 0x008fce0003f5d000ULL,
0x0000009a00887306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x0000000177772812ULL, 0x000fe400078efcffULL, 0x0000009a002a7306ULL, 0x0002e20000205400ULL,
0x000000298f00720bULL, 0x004fce0003fdd000ULL, 0x0000003000457306ULL, 0x000522000000d400ULL,
0x0000009a009a7245ULL, 0x002fca000020d400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x0000007a007b7306ULL, 0x000fe20000209400ULL, 0x0000002a8800720bULL, 0x008fe40003f7d000ULL,
0x00000018ff307819ULL, 0x004fe4000001142cULL, 0x0000004a994a723eULL, 0x000fc600000010ffULL,
0x0000007a007f7306ULL, 0x0002a20000205400ULL, 0x0000000145451812ULL, 0x010fca00078efcffULL,
0x000000019a9a3812ULL, 0x000fe400078efcffULL, 0x00000096002b7306ULL, 0x000fe20000209400ULL,
0x0000007a007a7245ULL, 0x002fce000020d400ULL, 0x0000009600937306ULL, 0x000e620000205400ULL,
0x0000007f7b00720bULL, 0x004fe20003f3d000ULL, 0x000100002e7b7824ULL, 0x040fe400078e00ffULL,
0x000001002e7f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000006200637306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x000fca000001147fULL,
0x000000017a7a1812ULL, 0x000fe400078efcffULL, 0x0000006200667306ULL, 0x0004e20000205400ULL,
0x000000932b00720bULL, 0x002fe40003f9d000ULL, 0x000000002828783bULL, 0x000e6a0000000200ULL,
0x00000083008a7306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x004fca000020d400ULL,
0x00000001abab4812ULL, 0x000fe400078efcffULL, 0x00000083008b7306ULL, 0x0005220000205400ULL,
0x000000666300720bULL, 0x008fce0003f5d000ULL, 0x0000007c00867306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x004fca000020d400ULL, 0x0000000162622812ULL, 0x000fe400078efcffULL,
0x0000007c00857306ULL, 0x0004e20000205400ULL, 0x0000008b8a00720bULL, 0x010fce0003fdd000ULL,
0x000000a800a77306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x004fe2000020d400ULL,
0x0000005a281c723cULL, 0x042fe8000004181cULL, 0x0000000183836812ULL, 0x000fe400078efcffULL,
0x000000a800a97306ULL, 0x000e620000205400ULL, 0x000000858600720bULL, 0x008fe40003f7d000ULL,
0x0000009a834b723eULL, 0x000fe200000010ffULL, 0x000000a22814723cULL, 0x040fe80000041814ULL,
0x0000005600677306ULL, 0x000fe80000209400ULL, 0x000000b82820723cULL, 0x000fe40000041820ULL,
0x000000017c7c3812ULL, 0x000fc400078efcffULL, 0x0000005600657306ULL, 0x0004e20000205400ULL,
0x000000a9a700720bULL, 0x002fc60003fbd000ULL, 0x000000be2818723cULL, 0x000fe80000041818ULL,
0x00000031006f7306ULL, 0x000fe20000009400ULL, 0x0000005600567245ULL, 0x004fc6000020d400ULL,
0x000000522810723cULL, 0x040fe40000041810ULL, 0x00000001cbcb5812ULL, 0x000fe400078efcffULL,
0x0000003100707306ULL, 0x000e620000005400ULL, 0x000000656700720bULL, 0x008fe40003f3d000ULL,
0x000000cb92cb723eULL, 0x000fe200000010ffULL, 0x0000004a2804723cULL, 0x040fe80000041804ULL,
0x00000033005e7306ULL, 0x000fe80000009400ULL, 0x000000ca280c723cULL, 0x000fe4000004180cULL,
0x0000000156561812ULL, 0x000fc400078efcffULL, 0x00000033005f7306ULL, 0x000ea20000005400ULL,
0x000000706f00720bULL, 0x002fe20003f9d000ULL, 0x000100002c707824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc8000001142fULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000006000647306ULL, 0x000ff00000209400ULL, 0x0000006000617306ULL, 0x0002e20000205400ULL,
0x0000005f5e00720bULL, 0x004fce0003fdd000ULL, 0x0000008000817306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x002fce000020d400ULL, 0x0000008000827306ULL, 0x0002a20000205400ULL,
0x000000616400720bULL, 0x008fce0003f5d000ULL, 0x0000008e00917306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x0000000160602812ULL, 0x000fe400078efcffULL,
0x0000008e00907306ULL, 0x0002e20000205400ULL, 0x000000828100720bULL, 0x004fe20003f7d000ULL,
0x000100002f817824ULL, 0x040fe400078e00ffULL, 0x000001002f827824ULL, 0x000fc600078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x00000036005c7306ULL, 0x000fe20000209400ULL,
0x0000008e008e7245ULL, 0x002fe4000020d400ULL, 0x00000018ff827819ULL, 0x000fc60000011482ULL,
0x0000000180803812ULL, 0x000fe400078efcffULL, 0x00000036005d7306ULL, 0x0002a20000205400ULL,
0x000000909100720bULL, 0x008fce0003fbd000ULL, 0x0000007200787306ULL, 0x000fe20000209400ULL,
0x0000003600367245ULL, 0x002fca000020d400ULL, 0x000000018e8e5812ULL, 0x000fe400078efcffULL,
0x0000007200797306ULL, 0x0002e20000205400ULL, 0x0000005d5c00720bULL, 0x004fe40003f3d000ULL,
0x000000ab8eab723eULL, 0x000fca00000010ffULL, 0x0000006900737306ULL, 0x000fe20000209400ULL,
0x0000007200727245ULL, 0x002fe2000020d400ULL, 0x000000aa2808723cULL, 0x000fe80000041808ULL,
0x0000000136361812ULL, 0x000fe400078efcffULL, 0x0000006900747306ULL, 0x000e620000205400ULL,
0x000000797800720bULL, 0x008fe40003f7d000ULL, 0x00000082002b7245ULL, 0x000fca000020d400ULL,
0x00000032006e7306ULL, 0x000fec0000009400ULL, 0x0000000172723812ULL, 0x000fe400078efcffULL,
0x00000032006d7306ULL, 0x000ea20000005400ULL, 0x000000747300720bULL, 0x002fe40003f5d000ULL,
0x0000006900737245ULL, 0x000fca000020d400ULL, 0x00000070005e7306ULL, 0x000fec0000209400ULL,
0x0000000173732812ULL, 0x000fe400078efcffULL, 0x00000070005f7306ULL, 0x0002e20000205400ULL,
0x0000006d6e00720bULL, 0x004fe40003fbd000ULL, 0x000000735673723eULL, 0x000fca00000010ffULL,
0x0000003100447306ULL, 0x000522000000d400ULL, 0x0000007000707245ULL, 0x002fce000020d400ULL,
0x0000004c00687306ULL, 0x000fe20000209400ULL, 0x0000005f5e00720bULL, 0x008fe40003f3d000ULL,
0x00000018ff317819ULL, 0x004fca000001142dULL, 0x0000004c006a7306ULL, 0x0002a20000205400ULL,
0x0000000144444812ULL, 0x010fc800078efcffULL, 0x000000447a44723eULL, 0x000fe400000010ffULL,
0x0000000170701812ULL, 0x000fe200078efcffULL, 0x0000002c00597306ULL, 0x000fe20000009400ULL,
0x0000004c004c7245ULL, 0x002fce000020d400ULL, 0x0000002c00587306ULL, 0x000e620000005400ULL,
0x0000006a6800720bULL, 0x004fce0003f9d000ULL, 0x0000002c00497306ULL, 0x0004ec000000d400ULL,
0x000000014c4c4812ULL, 0x000fe400078efcffULL, 0x0000002d00557306ULL, 0x000fe20000009400ULL,
0x000001002c2c7824ULL, 0x004fe200078e00ffULL, 0x000000585900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff637819ULL, 0x000fe2000001142cULL, 0x00000010712c7824ULL, 0x000fe200078e00ffULL,
0x0000002d00547306ULL, 0x000e640000005400ULL, 0x0000006300717245ULL, 0x000fca000020d400ULL,
0x0000000149493812ULL, 0x008fe200078efcffULL, 0x0000003200437306ULL, 0x000ea6000000d400ULL,
0x000000497070723eULL, 0x000fca00000010ffULL, 0x00000037006b7306ULL, 0x000fe20000209400ULL,
0x000000545500720bULL, 0x002fce0003f5d000ULL, 0x00000037006c7306ULL, 0x0002e20000205400ULL,
0x0000000143435812ULL, 0x004fc800078efcffULL, 0x000000437272723eULL, 0x000fe400000010ffULL,
0x000000364c43723eULL, 0x000fe200000010ffULL, 0x0000003000347306ULL, 0x000fe20000209400ULL,
0x0000003700377245ULL, 0x002fce000020d400ULL, 0x0000003000357306ULL, 0x0002a20000205400ULL,
0x0000006c6b00720bULL, 0x008fce0003fbd000ULL, 0x0000006300667306ULL, 0x000fe20000209400ULL,
0x0000003000307245ULL, 0x002fca000020d400ULL, 0x0000000137375812ULL, 0x000fe400078efcffULL,
0x0000006300617306ULL, 0x000e620000205400ULL, 0x000000353400720bULL, 0x004fe40003f3d000ULL,
0x000000457734723eULL, 0x000fe400000010ffULL, 0x0000007c6235723eULL, 0x000fe400000010ffULL,
0x000000806045723eULL, 0x000fe200000010ffULL, 0x0000002d00487306ULL, 0x0004ec000000d400ULL,
0x0000000130301812ULL, 0x000fc400078efcffULL, 0x0000003300427306ULL, 0x000f22000000d400ULL,
0x000001002d2d7824ULL, 0x004fe200078e00ffULL, 0x000000616600720bULL, 0x002fc80003f9d000ULL,
0x00000018ff5a7819ULL, 0x000fe4000001142dULL, 0x0000002e004f7306ULL, 0x000fe20000009400ULL,
0x0000000148482812ULL, 0x008fcc00078efcffULL, 0x0000000171714812ULL, 0x000fe200078efcffULL,
0x0000002e004e7306ULL, 0x000e620000005400ULL, 0x0000000142426812ULL, 0x010fe400078efcffULL,
0x000000713071723eULL, 0x000fe400000010ffULL, 0x000000423742723eULL, 0x000fc600000010ffULL,
0x0000002f00517306ULL, 0x000ff00000009400ULL, 0x0000002f00507306ULL, 0x000ea20000005400ULL,
0x0000004e4f00720bULL, 0x002fce0003fbd000ULL, 0x0000005a00587306ULL, 0x000ff00000209400ULL,
0x0000005a00547306ULL, 0x0002e20000205400ULL, 0x000000505100720bULL, 0x004fce0003fdd000ULL,
0x0000003100327306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x002fce000020d400ULL,
0x0000003100337306ULL, 0x0002a20000205400ULL, 0x000000545800720bULL, 0x008fce0003f3d000ULL,
0x0000007600647306ULL, 0x000fe20000209400ULL, 0x0000003100317245ULL, 0x002fca000020d400ULL,
0x000000015a5a1812ULL, 0x000fe400078efcffULL, 0x0000007600577306ULL, 0x0002e20000205400ULL,
0x000000333200720bULL, 0x004fce0003f9d000ULL, 0x0000007b00557306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fca000020d400ULL, 0x0000000131314812ULL, 0x000fe400078efcffULL,
0x0000007b004d7306ULL, 0x0002a20000205400ULL, 0x000000576400720bULL, 0x008fe40003f7d000ULL,
0x0000005a3149723eULL, 0x000fca00000010ffULL, 0x0000006f006d7306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x0000000176763812ULL, 0x000fe400078efcffULL,
0x0000006f006e7306ULL, 0x0002e20000205400ULL, 0x0000004d5500720bULL, 0x004fe40003f5d000ULL,
0x000000487648723eULL, 0x000fca00000010ffULL, 0x0000002e00467306ULL, 0x000ea2000000d400ULL,
0x0000006f006f7245ULL, 0x002fca000020d400ULL, 0x000000017b7b2812ULL, 0x000fe400078efcffULL,
0x0000002f00477306ULL, 0x000322000000d400ULL, 0x0000006e6d00720bULL, 0x008fce0003f3d000ULL,
0x0000007d007e7306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x002e620000000200ULL,
0x0000000146465812ULL, 0x004fc800078efcffULL, 0x000000016f6f1812ULL, 0x000fe400078efcffULL,
0x0000007d00757306ULL, 0x0004e20000205400ULL, 0x000000044000780cULL, 0x000fe40003f25270ULL,
0x0000000147476812ULL, 0x010fca00078efcffULL, 0x0000007f004e7306ULL, 0x000fe20000209400ULL,
0x0000007d007d7245ULL, 0x004fce000020d400ULL, 0x0000007f004f7306ULL, 0x000ea20000205400ULL,
0x000000757e00720bULL, 0x008fce0003f7d000ULL, 0x0000008100507306ULL, 0x000fec0000209400ULL,
0x000000017d7d3812ULL, 0x000fe400078efcffULL, 0x0000008100287306ULL, 0x0007220000205400ULL,
0x0000004f4e00720bULL, 0x004fe20003f9d000ULL, 0x000000342c14723cULL, 0x042fec0000041814ULL,
0x0000008200297306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x008fe2000020d400ULL,
0x000000442c1c723cULL, 0x040fec000004181cULL, 0x00000082002a7306ULL, 0x000e620000205400ULL,
0x000000285000720bULL, 0x010fe20003f5d000ULL, 0x000000722c20723cULL, 0x000fe20000041820ULL,
0x000000467b28723eULL, 0x000fce00000010ffULL, 0x000000422c18723cULL, 0x040fe80000041818ULL,
0x0000000181812812ULL, 0x000fe400078efcffULL, 0x0000002a2900720bULL, 0x002fe40003fbd000ULL,
0x0000007f00297245ULL, 0x000fe2000020d400ULL, 0x000000702c10723cULL, 0x000fe20000041810ULL,
0x00000047812a723eULL, 0x000fc400000010ffULL, 0x0000000129294812ULL, 0x000fc800078efcffULL,
0x000000297d29723eULL, 0x000fe200000010ffULL, 0x000000482c0c723cULL, 0x000fe4000004180cULL,
0x000000012b2b5812ULL, 0x000fc800078efcffULL, 0x0000002b6f2b723eULL, 0x000fe400000010ffULL,
0x000000282c08723cULL, 0x040ff00000041808ULL, 0x0000002a2c04723cULL, 0x000fe20000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff007224ULL, 0x000fe200078e0038ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd5f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003b287f8cULL, 0x000fe2000c80043fULL, 0x0000001c3c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d3c1d7220ULL, 0x040fe20000410000ULL, 0x000000203c207220ULL, 0x040fe20000410000ULL,
0x000004003b007984ULL, 0x000e620000000800ULL, 0x000000213c217220ULL, 0x040fe20000410000ULL,
0x000000143c147220ULL, 0x040fe20000410000ULL, 0x000000153c157220ULL, 0x040fe20000410000ULL,
0x000000163c2a7220ULL, 0x040fe20000410000ULL, 0x000000173c2b7220ULL, 0x040fe20000410000ULL,
0x000000223c227220ULL, 0x040fe20000410000ULL, 0x000000233c237220ULL, 0x040fe20000410000ULL,
0x0000001a3c2c7220ULL, 0x040fe20000410000ULL, 0x0000001b3c2d7220ULL, 0x040fe20000410000ULL,
0x000000103c167220ULL, 0x040fe20000410000ULL, 0x000000113c177220ULL, 0x040fe20000410000ULL,
0x000000123c2e7220ULL, 0x040fe20000410000ULL, 0x000000133c2f7220ULL, 0x040fe20000410000ULL,
0x0000000c3c1a7220ULL, 0x040fe20000410000ULL, 0x0000000d3c1b7220ULL, 0x040fe20000410000ULL,
0x000000183c187220ULL, 0x040fe20000410000ULL, 0x000000193c197220ULL, 0x040fe20000410000ULL,
0x0000000e3c307220ULL, 0x040fe20000410000ULL, 0x0000000f3c317220ULL, 0x040fe20000410000ULL,
0x000000083c087220ULL, 0x040fe20000410000ULL, 0x000000093c097220ULL, 0x040fe20000410000ULL,
0x0000000a3c327220ULL, 0x040fe20000410000ULL, 0x0000000b3c337220ULL, 0x040fe20000410000ULL,
0x000000043c047220ULL, 0x040fe20000410000ULL, 0x000000053c057220ULL, 0x040fe20000410000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e001cULL, 0x0000001e3c1e7220ULL, 0x040fe20000410000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e001dULL, 0x0000001f3c1f7220ULL, 0x040fe20000410000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0020ULL, 0x000000063c067220ULL, 0x040fe20000410000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0021ULL, 0x000000073c077220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0014ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1c7224ULL, 0x000fe400078e002aULL, 0x000000ffff1d7224ULL, 0x000fe200078e002bULL,
0x8000000000ff7812ULL, 0x002fe20007804829ULL, 0x000000ffff207224ULL, 0x000fe400078e0022ULL,
0x000000ffff217224ULL, 0x000fe400078e0023ULL, 0x000000ffff127224ULL, 0x000fc400078e0016ULL,
0x000000ffff137224ULL, 0x000fe400078e0017ULL, 0x000000ffff147224ULL, 0x000fe400078e001aULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x000000ffff227224ULL, 0x000fe400078e002cULL,
0x000000ffff237224ULL, 0x000fe400078e002dULL, 0x000000ffff2a7224ULL, 0x000fc400078e002eULL,
0x000000ffff2b7224ULL, 0x000fe400078e002fULL, 0x000000ffff107224ULL, 0x000fe400078e0018ULL,
0x000000ffff117224ULL, 0x000fe400078e0019ULL, 0x000000ffff167224ULL, 0x000fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e0009ULL, 0x000000ffff1a7224ULL, 0x000fc400078e0004ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0005ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0031ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0033ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fc400078e0006ULL,
0x000000ffff317224ULL, 0x000fe200078e0007ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x000004003b047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000043d197824ULL, 0x000fe200078e00ffULL,
0x0000003a0300720cULL, 0x000fc80003f05270ULL, 0xfffffff019187812ULL, 0x000fca00078ec0ffULL,
0x0000008025187824ULL, 0x000fca00078e0218ULL, 0x0104000018047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000023d007824ULL, 0x000fe400078e00ffULL,
0x00000001243e7824ULL, 0x000fc600078e0a3eULL, 0x0000000600007812ULL, 0x000fc800078ec0ffULL,
0x0000000100087812ULL, 0x040fe400078efcffULL, 0x0000000800097812ULL, 0x000fe400078efcffULL,
0x0000003e0800720cULL, 0x080fe40003f26070ULL, 0x0000001000087812ULL, 0x000fe400078efcffULL,
0x0000003e0900720cULL, 0x080fe40003f06070ULL, 0x0000003e0800720cULL, 0x000fc40003fc6070ULL,
0x0000001100097812ULL, 0x040fe400078efcffULL, 0x0000001800087812ULL, 0x040fe400078efcffULL,
0x0000003e0000720cULL, 0x080fe40003f46070ULL, 0x0000003e0900720cULL, 0x080fe40003fa6070ULL,
0x0000003e0800720cULL, 0x000fe40003f66070ULL, 0x0000000900287812ULL, 0x000fc400078efcffULL,
0x0000001900097812ULL, 0x040fe400078efcffULL, 0x0000002000087812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40004800000ULL,
0x0000003e2800720cULL, 0x080fe40003f86070ULL, 0x0000003e0900720cULL, 0x080fe40003f46070ULL,
0x0000003e0800720cULL, 0x000fe40003f26070ULL, 0x0000002100097812ULL, 0x040fe400078efcffULL,
0x0000002800087812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000003e0900720cULL, 0x080fe40003f06070ULL,
0x0000003e0800720cULL, 0x000fe40003f86070ULL, 0x0000002900097812ULL, 0x000fc400078efcffULL,
0x0000003000087812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000003e0900720cULL, 0x000fc40003fc6070ULL,
0x0000003e0800720cULL, 0x000fe40003fa6070ULL, 0x0000003100097812ULL, 0x040fe400078efcffULL,
0x0000003800087812ULL, 0x040fe400078efcffULL, 0x0000003900007812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000003e0900720cULL, 0x080fe40003f66070ULL, 0x0000003e0800720cULL, 0x000fc40003f46070ULL,
0x0000003e0000720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff30307808ULL, 0x000fc40005000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff31317808ULL, 0x000fe40004800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0x0000000a04047209ULL, 0x004fe20007810000ULL,
0x0000001fff327424ULL, 0x000fe200078e00ffULL, 0x0000001c05057209ULL, 0x000fe20007810000ULL,
0xffffffffff337424ULL, 0x000fe200078e00ffULL, 0x0000000b04047209ULL, 0x000fe40007810000ULL,
0x0000001d05057209ULL, 0x000fc40007810000ULL, 0x0000000c04047209ULL, 0x000fe40007810000ULL,
0x0000001e05057209ULL, 0x000fe40007810000ULL, 0x0000000d04047209ULL, 0x000fe40007810000ULL,
0x0000001f05057209ULL, 0x000fe40007810000ULL, 0x0000000e04047209ULL, 0x000fe40007810000ULL,
0x0000002005057209ULL, 0x000fc40007810000ULL, 0x0000000f04047209ULL, 0x000fe40007810000ULL,
0x0000002105057209ULL, 0x000fe40007810000ULL, 0x0000001004047209ULL, 0x000fe40007810000ULL,
0x0000002205057209ULL, 0x000fe40007810000ULL, 0x0000001104047209ULL, 0x000fe40007810000ULL,
0x0000002305057209ULL, 0x000fc40007810000ULL, 0x0000001204047209ULL, 0x000fe40007810000ULL,
0x0000002a05057209ULL, 0x000fe40007810000ULL, 0x0000001304047209ULL, 0x000fe40007810000ULL,
0x0000002b05057209ULL, 0x000fe40007810000ULL, 0x0000001404047209ULL, 0x000fe40007810000ULL,
0x0000002c05057209ULL, 0x000fc40007810000ULL, 0x0000001504047209ULL, 0x000fe40007810000ULL,
0x0000002d05057209ULL, 0x000fe40007810000ULL, 0x0000001604047209ULL, 0x000fe40007810000ULL,
0x0000002e05057209ULL, 0x000fe40007810000ULL, 0x0000001704047209ULL, 0x000fe40007810000ULL,
0x0000002f05057209ULL, 0x000fc40007810000ULL, 0x0000001a04047209ULL, 0x000fe40007810000ULL,
0x0000003005057209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fe40007810000ULL,
0x0000003105287209ULL, 0x000fe20007810000ULL, 0x00001b127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0004007f89ULL, 0x0004e400000e0000ULL, 0x0000000004297209ULL, 0x00cfe20007810000ULL,
0x00001b327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0028007f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007057f89ULL, 0x000f2200000e0000ULL,
0x0000000028007209ULL, 0x004fc40007810000ULL, 0x0000000406067209ULL, 0x008fc60007810000ULL,
0x0c201f0000087f89ULL, 0x000ea200000e0000ULL, 0x0000000507077209ULL, 0x010fc60007810000ULL,
0x0c201f0029047f89ULL, 0x000ee800000e0000ULL, 0x0c201f0006097f89ULL, 0x000f2800000e0000ULL,
0x0c201f0007287f89ULL, 0x00026200000e0000ULL, 0x0000000800057209ULL, 0x004fe40007810000ULL,
0x0000000429047209ULL, 0x008fc40007810000ULL, 0x0000000906067209ULL, 0x010fc60007810000ULL,
0x3fb8aa3b04007820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000728077209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010800ULL,
0x0000000a00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010800ULL,
0x0000000c000a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b1b007823ULL, 0x000fc80000010800ULL, 0x0000000e000c7308ULL, 0x000ff00000000800ULL,
0x00000010000e7308ULL, 0x000ff00000000800ULL, 0x0000001200107308ULL, 0x000ff00000000800ULL,
0x0000001400127308ULL, 0x000ff00000000800ULL, 0x0000001600147308ULL, 0x000ff00000000800ULL,
0x0000001a00167308ULL, 0x0003f00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b051a7820ULL, 0x002fc80000410000ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081aULL, 0x0000000d000d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081aULL,
0x000000080b08723eULL, 0x004fe200000010ffULL, 0x0000001c00097308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b311a7823ULL, 0x000fc4000001081aULL,
0x0000001d001d7308ULL, 0x000ee20000000800ULL, 0x00000004ff1c7e24ULL, 0x004fe2000f8e00ffULL,
0x0000000a0d0a723eULL, 0x002fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x3f8000001c1c783eULL, 0x000fe400000010ffULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x000000091d09723eULL, 0x008fe200000010ffULL, 0x000000ffff1d7224ULL, 0x000fcc00078e001cULL,
0x0000000f000f7308ULL, 0x000ea20000000800ULL, 0x0000001e1f0b723eULL, 0x002fce00000010ffULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x0000000fff1f7424ULL, 0x000fe200078e00ffULL,
0x0000001c0834723cULL, 0x000fe200000418ffULL, 0x0000000c0f0c723eULL, 0x004fca00000010ffULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x0000000e110e723eULL, 0x002fce00000010ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x00000020210d723eULL, 0x004fce00000010ffULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x00000022230f723eULL, 0x002fce00000010ffULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x0000001c0c34723cULL, 0x000fe20000041834ULL,
0x000000101310723eULL, 0x004fcc00000010ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000ea20000000800ULL, 0x000000121512723eULL, 0x002fe400000010ffULL,
0xfffffffc3d157812ULL, 0x000fc800078ec0ffULL, 0x000000151f1f7219ULL, 0x000fe200000006ffULL,
0x0000002c002c7308ULL, 0x000fe60000000800ULL, 0x000000001f1b73a1ULL, 0x000e6200000e8000ULL,
0x000000001f0473c4ULL, 0x000ee80000004000ULL, 0x0000002d002d7308ULL, 0x000f220000000800ULL,
0x0000002a2b11723eULL, 0x004fce00000010ffULL, 0x0000001700177308ULL, 0x000ea20000000800ULL,
0x0000002c2d13723eULL, 0x010fce00000010ffULL, 0x0000000000007308ULL, 0x000f220000000800ULL,
0x000000051fff7c12ULL, 0x002fe2000f80401bULL, 0x0000001c1034723cULL, 0x000fe20000041834ULL,
0x000000141714723eULL, 0x004fca00000010ffULL, 0x0000002e002e7308ULL, 0x000ff00000000800ULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x000000160016723eULL, 0x010fce00000010ffULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x0000002e2f15723eULL, 0x002fe400000010ffULL, 0x000000301a17723eULL, 0x004fce00000010ffULL,
0x0000001c1434723cULL, 0x000fe20000041834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000165204008947ULL, 0x008fde000b800000ULL, 0x001c1fff341c7589ULL, 0x0002a400000e0000ULL,
0x000000001f0073a1ULL, 0x000ee200000e8000ULL, 0x000000001f0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000051fff7c12ULL, 0x008fda000f804000ULL,
0x0000167204008947ULL, 0x010fea000b800000ULL, 0x001c1fff361d7589ULL, 0x00072800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL, 0x001c1fff1f1f7589ULL, 0x002e6400000e0000ULL,
0x00000002ff007819ULL, 0x000fe4000001163dULL, 0x0000000c19307812ULL, 0x000fc400078ec0ffULL,
0x00000007001a7812ULL, 0x040fe200078ec0ffULL, 0x00000008001b7824ULL, 0x040fe200078e00ffULL,
0x00000000ff2b7212ULL, 0x000fe200078e33ffULL, 0x0000000800207824ULL, 0x040fe200078e00ffULL,
0x000000033dff7812ULL, 0x000fe2000780c0ffULL, 0x00000008002c7824ULL, 0x040fe200078e00ffULL,
0x0000000800007810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81b1b7812ULL, 0x100fe400078ee21aULL,
0x0000000120217812ULL, 0x100fe200078ef61aULL, 0x0000000800347824ULL, 0x000fe200078e00ffULL,
0x0000000220227812ULL, 0x100fe200078ef61aULL, 0x00000008002d7824ULL, 0x000fe200078e00ffULL,
0x0000000320237812ULL, 0x000fc400078ef61aULL, 0x0000000420287812ULL, 0x140fe400078ef61aULL,
0x0000000520297812ULL, 0x140fe400078ef61aULL, 0x00000006202a7812ULL, 0x000fe200078ef61aULL,
0x0000000800207824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2b7812ULL, 0x000fe400078ee22bULL,
0x00000000ff2c7212ULL, 0x000fe400078e33ffULL, 0x00000007001a7812ULL, 0x000fc400078ec0ffULL,
0x0000a00025007811ULL, 0x000fe400078e58ffULL, 0xfffffff834347812ULL, 0x000fe400078ee22cULL,
0xfffffff82d2c7812ULL, 0x000fe200078ee21aULL, 0x000000101b197824ULL, 0x000fe200078e0200ULL,
0x00000001202d7812ULL, 0x000fe200078ef61aULL, 0x00000010221b7824ULL, 0x000fe200078e0200ULL,
0x00000002202e7812ULL, 0x100fe200078ef61aULL, 0x0000000130197824ULL, 0x000fe200078e0219ULL,
0x00000003202f7812ULL, 0x040fe200078ef61aULL, 0x0000001029227824ULL, 0x000fe200078e0200ULL,
0x0000000420317812ULL, 0x100fe200078ef61aULL, 0x00000001301b7824ULL, 0x000fe200078e021bULL,
0x0000000520327812ULL, 0x000fe200078ef61aULL, 0x000000102c297824ULL, 0x000fe200078e0200ULL,
0x0000000620337812ULL, 0x000fe200078ef61aULL, 0x00000010211a7824ULL, 0x100fe200078e0200ULL,
0x0000000819007388ULL, 0x0007e20000000800ULL, 0x0000001023207824ULL, 0x000fc400078e0200ULL,
0x0000001028217824ULL, 0x000fe400078e0200ULL, 0x00000001301a7824ULL, 0x000fe400078e021aULL,
0x000000102a237824ULL, 0x100fe400078e0200ULL, 0x000000102b287824ULL, 0x000fe200078e0200ULL,
0x0000000a1a007388ULL, 0x0007e20000000800ULL, 0x0000000130207824ULL, 0x040fe400078e0220ULL,
0x0000000130217824ULL, 0x000fe200078e0221ULL, 0x0000000c1b007388ULL, 0x0007e20000000800ULL,
0x000000102d2a7824ULL, 0x000fc400078e0200ULL, 0x0000000130227824ULL, 0x000fe200078e0222ULL,
0x0000000e20007388ULL, 0x0007e20000000800ULL, 0x000000102e2b7824ULL, 0x100fe400078e0200ULL,
0x0000000130237824ULL, 0x040fe200078e0223ULL, 0x0000001021007388ULL, 0x0007e20000000800ULL,
0x000000102f2c7824ULL, 0x000fe400078e0200ULL, 0x0000000130287824ULL, 0x000fe200078e0228ULL,
0x0000001222007388ULL, 0x0007e20000000800ULL, 0x00000010312d7824ULL, 0x000fc400078e0200ULL,
0x0000000130297824ULL, 0x000fe200078e0229ULL, 0x0000001423007388ULL, 0x0007e20000000800ULL,
0x00000010322e7824ULL, 0x000fe400078e0200ULL, 0x00000001302a7824ULL, 0x040fe200078e022aULL,
0x0000001628007388ULL, 0x0007e20000000800ULL, 0x00000010332f7824ULL, 0x100fe400078e0200ULL,
0x00000001302b7824ULL, 0x000fe200078e022bULL, 0x0000000929007388ULL, 0x0007e20000000800ULL,
0x0000001034007824ULL, 0x000fc400078e0200ULL, 0x00000001302c7824ULL, 0x040fe200078e022cULL,
0x0000000b2a007388ULL, 0x0007e20000000800ULL, 0x00000001302d7824ULL, 0x040fe400078e022dULL,
0x00000001302e7824ULL, 0x040fe200078e022eULL, 0x0000000d2b007388ULL, 0x0007e20000000800ULL,
0x00000001302f7824ULL, 0x040fe400078e022fULL, 0x0000000130007824ULL, 0x000fe200078e0200ULL,
0x0000000f2c007388ULL, 0x0007e80000000800ULL, 0x000000112d007388ULL, 0x0007e80000000800ULL,
0x000000132e007388ULL, 0x0007e80000000800ULL, 0x000000152f007388ULL, 0x0007e80000000800ULL,
0x0000001700007388ULL, 0x0007e80000000800ULL, 0x0100000418008388ULL, 0x0007e80000000c00ULL,
0x0102001c18008388ULL, 0x0167e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000039ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080039ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100039ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030003037a10ULL, 0x000fe20007ffe0ffULL, 0x0000180039ff7f8cULL, 0x0003e6000c80043fULL,
0x000000020300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffba0000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x0001d89000487802ULL, 0x000fe40000000f00ULL,
0x0000128000007944ULL, 0x014fea0003c00000ULL, 0xfffe3c7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x0001d8d000487802ULL, 0x000fe40000000f00ULL,
0x0000124000007944ULL, 0x014fea0003c00000ULL, 0xfffe3cb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x012fe200078e003aULL, 0x0001d940005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff637224ULL, 0x000fe400078e002aULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fc400078e00ffULL, 0x0000119000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff387224ULL, 0x004fe200078e0000ULL, 0xfffe3cd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff637224ULL, 0x000fe200078e002aULL, 0x0001d9c0005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff627224ULL, 0x000fc400078e003aULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x0000111000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e0000ULL, 0xfffe3c8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff637224ULL, 0x000fe200078e0036ULL, 0x0001da30005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x000010a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff737224ULL, 0x004fe200078e0000ULL,
0xfffe3ff000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x000fe200078e0038ULL,
0x0001daa0005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x0000103000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff717224ULL, 0x004fe200078e0000ULL, 0xfffe3fb000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5b7424ULL, 0x000fe200078e00ffULL, 0x0001db00005a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x00000fd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff817224ULL, 0x004fe200078e0000ULL, 0xfffe64d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff637224ULL, 0x002fe200078e0038ULL, 0x0001db70005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x00000f6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff807224ULL, 0x004fe200078e0000ULL,
0xfffe648000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x0001dbc000487802ULL, 0x000fc40000000f00ULL, 0x00000f5000007944ULL, 0x014fea0003c00000ULL,
0xfffe895000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001dc0000487802ULL, 0x000fc40000000f00ULL, 0x00000f1000007944ULL, 0x014fea0003c00000ULL,
0xfffe899000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x002fe200078e0000ULL,
0x0001dc70005a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff627224ULL, 0x000fc400078e0049ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x00000e6000007944ULL, 0x014fea0003c00000ULL, 0xfffe89d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x000fe200078e0049ULL, 0x0001dce0005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff637224ULL, 0x000fe400078e0038ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x00000df000007944ULL, 0x012fea0003c00000ULL,
0xfffe8a8000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5b7424ULL, 0x000fe200078e00ffULL,
0x0001dd30005a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff647424ULL, 0x000fc400078e00ffULL,
0x00000da000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff777224ULL, 0x004fe200078e0000ULL,
0xfffe8ce000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x008fe200078e0038ULL,
0x0001dda0005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x00000d3000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff787224ULL, 0x004fe200078e0000ULL, 0xfffe8c9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5b7424ULL, 0x000fe200078e00ffULL, 0x0001de00005a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x00000cd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff7f7224ULL, 0x004fe200078e0000ULL, 0xfffeb00000007947ULL, 0x000fea000383ffffULL,
0x000000ffff637224ULL, 0x002fe200078e0038ULL, 0x0001de70005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x00000c6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff7e7224ULL, 0x004fe200078e0000ULL,
0xfffeafb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x0001dec000487802ULL, 0x000fc40000000f00ULL, 0x00000c5000007944ULL, 0x014fea0003c00000ULL,
0xfffed40000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001df0000487802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x014fea0003c00000ULL,
0xfffed44000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x002fe200078e0000ULL,
0x0001df70005a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff627224ULL, 0x000fc400078e0049ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x00000b6000007944ULL, 0x014fea0003c00000ULL, 0xfffed48000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x000fe200078e0049ULL, 0x0001dfe0005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff637224ULL, 0x000fe400078e0038ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x00000af000007944ULL, 0x012fea0003c00000ULL,
0xfffed53000007947ULL, 0x000fea000383ffffULL, 0x0000001fff5b7424ULL, 0x000fe200078e00ffULL,
0x0001e030005a7802ULL, 0x000fe20000000f00ULL, 0xffffffffff647424ULL, 0x000fc400078e00ffULL,
0x00000aa000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff777224ULL, 0x004fe200078e0000ULL,
0xfffed79000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x008fe200078e0038ULL,
0x0001e0a0005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x00000a3000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff787224ULL, 0x004fe200078e0000ULL, 0xfffed74000007947ULL, 0x000fea000383ffffULL,
0x0000001fff5b7424ULL, 0x000fe200078e00ffULL, 0x0001e100005a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x000009d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff7f7224ULL, 0x004fe200078e0000ULL, 0xfffefab000007947ULL, 0x000fea000383ffffULL,
0x000000ffff637224ULL, 0x002fe200078e0038ULL, 0x0001e170005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0000096000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff7e7224ULL, 0x004fe200078e0000ULL,
0xfffefa6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x0001e1c000487802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x014fea0003c00000ULL,
0xffff1eb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001e20000487802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x014fea0003c00000ULL,
0xffff1ef000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x002fe200078e0000ULL,
0x0001e270005a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff627224ULL, 0x000fc400078e002aULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0000086000007944ULL, 0x014fea0003c00000ULL, 0xffff1f3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x000fe200078e002aULL, 0x0001e2e0005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff637224ULL, 0x000fe400078e0038ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x000007f000007944ULL, 0x012fea0003c00000ULL,
0xffff1fe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x000fe200078e0060ULL,
0x0001e340005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff647424ULL, 0x000fe400078e00ffULL, 0x0000079000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff607224ULL, 0x004fe200078e0000ULL, 0xffff223000007947ULL, 0x000fea000383ffffULL,
0x000000ffff637224ULL, 0x000fe200078e0038ULL, 0x0001e3b0005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0000072000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff5c7224ULL, 0x004fe200078e0000ULL,
0xffff21e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff637224ULL, 0x000fe200078e005eULL,
0x0001e420005a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff647424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff5e7224ULL, 0x004fe200078e0000ULL, 0xffff456000007947ULL, 0x000fea000383ffffULL,
0x000000ffff637224ULL, 0x000fe200078e0038ULL, 0x0001e490005a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff647424ULL, 0x000fe400078e00ffULL,
0x0000064000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff5f7224ULL, 0x004fe200078e0000ULL,
0xffff451000007947ULL, 0x000fea000383ffffULL, 0x000000ffff007224ULL, 0x000fe200078e0004ULL,
0x0001e4f000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fe400078e00ffULL,
0x0000059000007944ULL, 0x002fea0003c00000ULL, 0xffffe4b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0x0001e54000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fe400078e00ffULL, 0x0000054000007944ULL, 0x002fea0003c00000ULL,
0x0000000028057209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0006ULL,
0x0001e59000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fe400078e00ffULL,
0x000004f000007944ULL, 0x000fea0003c00000ULL, 0x0000000006067209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0001e5e000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x0000000007077209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0029ULL,
0x0001e63000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x0000045000007944ULL, 0x000fea0003c00000ULL, 0x0000000029047209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0005ULL, 0x0001e68000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x0000040000007944ULL, 0x000fea0003c00000ULL,
0x0000000005057209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0006ULL,
0x0001e6d000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x0000000006067209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0001e72000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e0000ULL, 0xffffe36000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x000fe200078e0034ULL, 0x0001e7a0005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff637224ULL, 0x000fc400078e00ffULL, 0x00001c1fff5b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff647224ULL, 0x000fe400078e001fULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0000ULL, 0xffffe94000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x000fe200078e0036ULL, 0x0001e820005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff637224ULL, 0x000fe400078e00ffULL, 0x00001c1fff5b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff647224ULL, 0x000fe400078e001fULL, 0x000002b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x0001e880005a7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff5b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff647224ULL, 0x000fe400078e001fULL,
0x000000ffff1d7224ULL, 0x004fe400078e0000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff647224ULL, 0x000fe200078e001fULL, 0x0001e8e0005a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff637224ULL, 0x000fe400078e00ffULL, 0x00001c1fff5b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e0000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e0000ULL, 0xffffe88000007947ULL, 0x000fea000383ffffULL,
0x0180000004007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000067812ULL, 0x000fc800078ec0ffULL, 0x018000000600780cULL, 0x000fda0003f05070ULL,
0x0000000400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0600720cULL, 0x040fe40003f25070ULL, 0x008000000600780cULL, 0x000fe40003f02070ULL,
0x00000001ff067807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000006ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000004047812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000006ff7212ULL, 0x000fda000780c0ffULL,
0x0080000004000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x006fe400078e0005ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe158004007950ULL, 0x000fea0003c3ffffULL,
0x0000003300007348ULL, 0x000fe80003800000ULL, 0x0c00000800007389ULL, 0x0002a400000e0032ULL,
0x000000ffff087224ULL, 0x002fe400078e0009ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe153008007950ULL, 0x000fea0003c3ffffULL, 0x0000006400007348ULL, 0x000fe80003800000ULL,
0x0000006362007389ULL, 0x0002a400000e005bULL, 0x00000000ff5b7424ULL, 0x002fc800078e00ffULL,
0xfffe14f05a007950ULL, 0x000fea0003c3ffffULL, 0x000000010000780cULL, 0x000fe20003f25070ULL,
0x00000000ff497424ULL, 0x000fe200078e00ffULL, 0x0000003f00007348ULL, 0x000ff60003800000ULL,
0x0000000000007806ULL, 0x000fc800048e0100ULL, 0x0000003f00007212ULL, 0x000fe200078ec0ffULL,
0xfffe149048007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000478ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a58ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ae8ULL, 0x0000000000000b8cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001674ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001698ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000016a8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000016c8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001758ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001760ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001770ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001980ULL, 0x000000000001ec00ULL, 0xf100001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020580ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000020590ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020590ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000020a10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001758ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001ee28ULL, 0x000000000001ee28ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000020580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000020a10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_89_cubin_len = 133872;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
