/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000020d10ULL, 0x0000000000020890ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001ec30ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001eda0ULL, 0x0000000000000050ULL, 0x000e002200000131ULL,
0x000000000001edf0ULL, 0x0000000000000050ULL, 0x000e00220000015bULL, 0x000000000001ee40ULL,
0x0000000000000140ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001ef80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001ec3000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x0079a40400288080ULL, 0x0000000000000000ULL, 0x000000acffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080910828808081ULL,
0x9808288080920828ULL, 0x2880809a08288080ULL, 0x809e082880809d08ULL, 0x082880809f082880ULL,
0x8080a808288080a1ULL, 0xac08288080aa0828ULL, 0x288080b108288080ULL, 0x80be08288080b308ULL,
0x08288080bf082880ULL, 0x8080d008288080c7ULL, 0xd808288080d10828ULL, 0x288080db08288080ULL,
0x80e408288080e308ULL, 0x1628808086082880ULL, 0x0000031028808280ULL, 0x8692000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001ec3000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x000000acffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9208288080910828ULL, 0x2880809308288080ULL, 0x8099082880809808ULL, 0x082880809a082880ULL,
0x80809f082880809eULL, 0xaa08288080a10828ULL, 0x288080ac08288080ULL, 0x80be08288080b108ULL,
0x08288080bf082880ULL, 0x8080d008288080c7ULL, 0xd808288080d10828ULL, 0x288080db08288080ULL,
0x80e408288080e308ULL, 0x1628808089082880ULL, 0x0000031028808280ULL, 0x8992000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000015000000000ULL, 0x0001eda000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8088288080890900ULL, 0x0000000000002880ULL,
0x000000b4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9108288080890828ULL, 0x2880809208288080ULL,
0x8098082880809308ULL, 0x0828808099082880ULL, 0x80809e082880809aULL, 0xa1082880809f0828ULL,
0x288080a808288080ULL, 0x80ac08288080aa08ULL, 0x08288080b1082880ULL, 0x8080bf08288080beULL,
0xd008288080c70828ULL, 0x288080d108288080ULL, 0x80db08288080d808ULL, 0x08288080e4082880ULL,
0x80828016288080e3ULL, 0x0000000000031028ULL, 0x288080e392000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x0000024000000000ULL, 0x0001edf000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80d8288080e30900ULL, 0x0000000000002880ULL, 0x000000b4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x9108288080890828ULL, 0x2880809208288080ULL, 0x8098082880809308ULL,
0x0828808099082880ULL, 0x80809e082880809aULL, 0xa1082880809f0828ULL, 0x288080a808288080ULL,
0x80ac08288080aa08ULL, 0x08288080b1082880ULL, 0x8080bf08288080beULL, 0xd008288080c70828ULL,
0x288080d808288080ULL, 0x80e308288080db08ULL, 0x08288080e4082880ULL, 0x80828016288080d1ULL,
0x0000000000031028ULL, 0x288080d192000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x0000033800000000ULL, 0x0001ee4000000000ULL, 0x0000014000000000ULL, 0x0000140400000000ULL,
0x80d0288080d10900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL, 0x00081204000000f8ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000eULL, 0x000c170400501903ULL,
0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL,
0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000020001c3104ULL, 0x0001d0300001cc10ULL, 0x0001d1200001d040ULL, 0x0001d1400001d130ULL,
0xffffffff01c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000023ffffffffULL, 0x0500002305000023ULL, 0xffffffff05000023ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01c82804ffffffffULL, 0x000000f0000000e0ULL, 0x00001570000014f0ULL,
0x0000164000001610ULL, 0x00001a6000001a30ULL, 0x00001b6000001ae0ULL, 0x0000402000004000ULL,
0x0000410000004090ULL, 0x000065d000006550ULL, 0x000067a000006680ULL, 0x00006a8000006a60ULL,
0x00006b6000006af0ULL, 0x00008e9000008e70ULL, 0x00008f7000008f00ULL, 0x0000b3c00000b340ULL,
0x0000b5900000b470ULL, 0x0000b8700000b850ULL, 0x0000b9500000b8e0ULL, 0x0000dc800000dc60ULL,
0x0000dd600000dcf0ULL, 0x000101b000010130ULL, 0x0001038000010260ULL, 0x0001066000010640ULL,
0x00010740000106d0ULL, 0x00012aa000012a80ULL, 0x00012b8000012b10ULL, 0x00014c6000014c50ULL,
0x00016f10000153e0ULL, 0x000176d0000170c0ULL, 0x00017f3000017710ULL, 0x0001c9900001c960ULL,
0x0001c9b00001c9a0ULL, 0x0001c9f00001c9d0ULL, 0x0001ca200001ca10ULL, 0x0001d1700001d110ULL,
0x0001d1900001d180ULL, 0x0001d9100001d8b0ULL, 0x0001da100001d990ULL, 0x0001db100001da90ULL,
0x0001dc000001db80ULL, 0x0001dcc00001dc60ULL, 0x0001ddb00001dd40ULL, 0x0001de900001de10ULL,
0x0001df900001df10ULL, 0x0001e0500001dff0ULL, 0x0001e1400001e0d0ULL, 0x0001e2200001e1a0ULL,
0x0001e3200001e2a0ULL, 0x0001e3e00001e380ULL, 0x0001e4d00001e460ULL, 0x0001e5c00001e540ULL,
0x0001e6b00001e630ULL, 0x0001e7b00001e730ULL, 0x0001e8900001e820ULL, 0x0001e9700001e900ULL,
0x0001ea500001e9e0ULL, 0x0001eb400001eac0ULL, 0x0001ec000001eba0ULL, 0x0000021007003904ULL,
0x00010600000000ffULL, 0x00000250003f0100ULL, 0x0001060800000003ULL, 0x000002c0003f0120ULL,
0x0001068800000003ULL, 0x00000390003f0120ULL, 0x000106a800000003ULL, 0x000003c0003f0120ULL,
0x000106b8000000ffULL, 0x000004d0003f0100ULL, 0x00010600000000ffULL, 0x00000670003f0107ULL,
0x0001068c00000016ULL, 0x000009f0003f0102ULL, 0x0001068800000016ULL, 0x00000b30003f0101ULL,
0x000106a8000000ffULL, 0x00000bc0003f0107ULL, 0x000106a8000000ffULL, 0x00000c20003f0101ULL,
0x000106b8000000ffULL, 0x00000d60003f0101ULL, 0x000106bc000000ffULL, 0x00000db0003f0105ULL,
0x000106bc000000ffULL, 0x00000e30003f0105ULL, 0x000106bc000000ffULL, 0x00001270003f0105ULL,
0x000106b0000000ffULL, 0x000012f0003f0107ULL, 0x000106b0000000ffULL, 0x00001300003f0101ULL,
0x000106ac000000ffULL, 0x00001370003f0105ULL, 0x0001060800000016ULL, 0x00001390003f0101ULL,
0x0001060c00000016ULL, 0x00001420003f0105ULL, 0x0001060c00000016ULL, 0x00001910003f0105ULL,
0x000106ac000000ffULL, 0x00001990003f0105ULL, 0x000106ac000000ffULL, 0x00003a50003f0105ULL,
0x000106b8000000ffULL, 0x00003a60003f0101ULL, 0x000106bc000000ffULL, 0x00003ab0003f0105ULL,
0x000106bc000000ffULL, 0x00003b30003f0105ULL, 0x000106bc000000ffULL, 0x00003e00003f0105ULL,
0x000106a8000000ffULL, 0x00003e80003f0107ULL, 0x000106a8000000ffULL, 0x00003e90003f0101ULL,
0x000106b4000000ffULL, 0x00003ef0003f0105ULL, 0x000106b4000000ffULL, 0x00003f70003f0105ULL,
0x000106b4000000ffULL, 0x00005f00003f0105ULL, 0x000106b8000000ffULL, 0x00005f70003f0101ULL,
0x00010688000000ffULL, 0x00005fb0003f0101ULL, 0x000106bc000000ffULL, 0x00006000003f0105ULL,
0x000106bc000000ffULL, 0x00006080003f0105ULL, 0x000106bc000000ffULL, 0x00006310003f0105ULL,
0x000106b0000000ffULL, 0x00006390003f0107ULL, 0x000106b0000000ffULL, 0x000063a0003f0101ULL,
0x000106ac000000ffULL, 0x00006410003f0105ULL, 0x0001062800000016ULL, 0x00006430003f0101ULL,
0x0001062c00000016ULL, 0x000064c0003f0105ULL, 0x0001062c00000016ULL, 0x00006950003f0105ULL,
0x000106ac000000ffULL, 0x000069d0003f0105ULL, 0x000106ac000000ffULL, 0x00008900003f0105ULL,
0x000106b8000000ffULL, 0x00008910003f0101ULL, 0x000106bc000000ffULL, 0x00008960003f0105ULL,
0x000106bc000000ffULL, 0x000089e0003f0105ULL, 0x000106bc000000ffULL, 0x00008c70003f0105ULL,
0x000106a8000000ffULL, 0x00008cf0003f0107ULL, 0x000106a8000000ffULL, 0x00008d00003f0101ULL,
0x000106b4000000ffULL, 0x00008d60003f0105ULL, 0x000106b4000000ffULL, 0x00008de0003f0105ULL,
0x000106b4000000ffULL, 0x0000acf0003f0105ULL, 0x000106b8000000ffULL, 0x0000ad60003f0101ULL,
0x00010690000000ffULL, 0x0000ada0003f0101ULL, 0x000106bc000000ffULL, 0x0000adf0003f0105ULL,
0x000106bc000000ffULL, 0x0000ae70003f0105ULL, 0x000106bc000000ffULL, 0x0000b100003f0105ULL,
0x000106b0000000ffULL, 0x0000b180003f0107ULL, 0x000106b0000000ffULL, 0x0000b190003f0101ULL,
0x000106ac000000ffULL, 0x0000b200003f0105ULL, 0x0001064800000016ULL, 0x0000b220003f0101ULL,
0x0001064c00000016ULL, 0x0000b2b0003f0105ULL, 0x0001064c00000016ULL, 0x0000b740003f0105ULL,
0x000106ac000000ffULL, 0x0000b7c0003f0105ULL, 0x000106ac000000ffULL, 0x0000d6f0003f0105ULL,
0x000106b8000000ffULL, 0x0000d700003f0101ULL, 0x000106bc000000ffULL, 0x0000d750003f0105ULL,
0x000106bc000000ffULL, 0x0000d7d0003f0105ULL, 0x000106bc000000ffULL, 0x0000da60003f0105ULL,
0x000106a8000000ffULL, 0x0000dae0003f0107ULL, 0x000106a8000000ffULL, 0x0000daf0003f0101ULL,
0x000106b4000000ffULL, 0x0000db50003f0105ULL, 0x000106b4000000ffULL, 0x0000dbd0003f0105ULL,
0x000106b4000000ffULL, 0x0000fae0003f0105ULL, 0x000106b8000000ffULL, 0x0000fb50003f0101ULL,
0x00010698000000ffULL, 0x0000fb90003f0101ULL, 0x000106bc000000ffULL, 0x0000fbe0003f0105ULL,
0x000106bc000000ffULL, 0x0000fc60003f0105ULL, 0x000106bc000000ffULL, 0x0000fef0003f0105ULL,
0x000106b0000000ffULL, 0x0000ff70003f0107ULL, 0x000106b0000000ffULL, 0x0000ff80003f0101ULL,
0x000106ac000000ffULL, 0x0000fff0003f0105ULL, 0x0001066800000016ULL, 0x00010010003f0101ULL,
0x0001066c00000016ULL, 0x000100a0003f0105ULL, 0x0001066c00000016ULL, 0x00010530003f0105ULL,
0x000106ac000000ffULL, 0x000105b0003f0105ULL, 0x000106ac000000ffULL, 0x000124e0003f0105ULL,
0x000106b8000000ffULL, 0x000124f0003f0101ULL, 0x000106bc000000ffULL, 0x00012540003f0105ULL,
0x000106bc000000ffULL, 0x000125c0003f0105ULL, 0x000106bc000000ffULL, 0x00012880003f0105ULL,
0x000106a8000000ffULL, 0x00012900003f0107ULL, 0x000106a8000000ffULL, 0x00012910003f0101ULL,
0x000106b4000000ffULL, 0x00012970003f0105ULL, 0x000106b4000000ffULL, 0x000129f0003f0105ULL,
0x000106b4000000ffULL, 0x00014900003f0105ULL, 0x000106b8000000ffULL, 0x00014960003f0101ULL,
0x000106a0000000ffULL, 0x00018230003f0101ULL, 0x00010600000000ffULL, 0x00018d20003f0101ULL,
0x00010604000000ffULL, 0x00018dc0003f0105ULL, 0x00010604000000ffULL, 0x000190e0003f0105ULL,
0x00010600000000ffULL, 0x000190f0003f0101ULL, 0x00010604000000ffULL, 0x00019180003f0105ULL,
0x00010604000000ffULL, 0x0001be20003f0105ULL, 0x0000000000000039ULL, 0x0001be50003f0101ULL,
0x0000000400000039ULL, 0x0001c280003f0105ULL, 0x0000000400000039ULL, 0x0001d700003f0105ULL,
0x000000000000003bULL, 0x0001d760003f0101ULL, 0x000000080000003bULL, 0x0001d7c0003f0101ULL,
0x000000100000003bULL, 0x0001d830003f0101ULL, 0x000000180000003bULL, 0x00053803003f0101ULL,
0x0001818000101c04ULL, 0x00019280000191e0ULL, 0x000004010001d870ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000040cULL, 0x0000001200000002ULL, 0x0000000000000314ULL, 0x0000001200000002ULL,
0x000000000000021cULL, 0x0000001200000002ULL, 0x000000000000013cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x00000000000003e3ULL, 0x0000001200000002ULL,
0x00000000000002ebULL, 0x0000001200000002ULL, 0x00000000000001f6ULL, 0x0000001200000002ULL,
0x0000000000000116ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x0000001000077300ULL, 0x000ee200000e0000ULL, 0x0000000805057824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000f280000002200ULL, 0x0000000000117919ULL, 0x000f620000002600ULL,
0x0000001000137309ULL, 0x0002e60000000000ULL, 0x0000000000177919ULL, 0x000ee80000002700ULL,
0x0000000000087919ULL, 0x000ee20000000000ULL, 0x00000005ff007819ULL, 0x002fc60000011604ULL,
0x00001fff020c7589ULL, 0x0049e800000e0000ULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x0000000102027824ULL, 0x010fc800078e0203ULL, 0x0000008002037824ULL, 0x000fe400078e0204ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x0000000811047824ULL, 0x020fe200078e00ffULL,
0x000000080700720cULL, 0x008fe40003f02070ULL, 0x000000ff0300720cULL, 0x000fe20003f25270ULL,
0x00000017050a7224ULL, 0x000fe200078e0204ULL, 0x0000000f0300780cULL, 0x040fe40003f44070ULL,
0x0000007f0300780cULL, 0x000fc40003f84070ULL, 0x000000030300780cULL, 0x000fe20003f64070ULL,
0x000000040c067824ULL, 0x002fcc00078e0200ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x00000002060b7824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x000000080b0d7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0xff317217ff0ec424ULL, 0x000fe200078e00ffULL, 0x000000010b0f7810ULL, 0x000fe20007ffe0ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x010608060300a388ULL, 0x0007e20000008a00ULL,
0x000000010300780cULL, 0x000fe20003f44070ULL, 0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL,
0x000000070f107812ULL, 0x000fe200078ec0ffULL, 0x0104000e0300c388ULL, 0x0009e20000004800ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a0bULL, 0x000000070b047812ULL, 0x002fc400078ec0ffULL,
0x010688080300b388ULL, 0x0003e20000008a00ULL, 0x0000001f10107812ULL, 0x104fe400078e7802ULL,
0x0000001f04057812ULL, 0x000fe200078e7802ULL, 0x000000010a047824ULL, 0x040fe200078e020bULL,
0x000000ff0d00720cULL, 0x040fe20003f63070ULL, 0x000000010a067824ULL, 0x008fe200078e020fULL,
0x000000010d00780cULL, 0x000fe20003f83070ULL, 0x000000200b0e7824ULL, 0x010fe400078e0205ULL,
0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL, 0x3fffff00ff08a424ULL, 0x002fe400078e00ffULL,
0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe400078e00ffULL,
0x00000200ff077424ULL, 0x000fe200078e00ffULL, 0x0106a8080300a388ULL, 0x0003e20000008a00ULL,
0x00000010020d7824ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x080fe200078e0007ULL,
0x0106b80aff009388ULL, 0x0005e40000000a00ULL, 0x000001f00d127812ULL, 0x000fe200078ec0ffULL,
0x00005c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000001204047210ULL, 0x080fe20007fbe0ffULL, 0x000000200f107824ULL, 0x000fe200078e0210ULL,
0x0000001206067210ULL, 0x000fe20007f5e0ffULL, 0x000000100e0e7824ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x000000ffff077224ULL, 0x000fe400010e0607ULL,
0x0000001010107824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x002fe200078e0a13ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040e7faeULL, 0x0003e8000d901c46ULL,
0x0000000006107faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000004ff047424ULL, 0x000fc600078e00ffULL, 0x01060403ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000600017047625ULL, 0x000fc600078e0004ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000604037981ULL, 0x004ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x00000004ff147e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff03157810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff157819ULL, 0x000fce0000011615ULL, 0x00017bb000008947ULL, 0x000fea0003800000ULL,
0x0000580011047a10ULL, 0x000fe20007ffe0ffULL, 0x0000000217177824ULL, 0x000fe200078e00ffULL,
0x0000000114057810ULL, 0x000fe20007ffe0ffULL, 0x0000000800167824ULL, 0x000fe400078e00ffULL,
0x0000580017177a24ULL, 0x000fe200078e0204ULL, 0x000000150500720cULL, 0x000fe20003f06070ULL,
0x00000003ff047424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff087819ULL, 0x000fe20000011602ULL, 0x01068c0416ff738cULL, 0x0003e20000000000ULL,
0x000000f00d1a7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff1b7424ULL, 0x000fe200078e00ffULL,
0x00000002080e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000116077824ULL, 0x000fe200078e0208ULL,
0x0000000408107810ULL, 0x000fc40007ffe0ffULL, 0x0000000608137810ULL, 0x000fe20007ffe0ffULL,
0x00000001160a7824ULL, 0x000fe200078e020eULL, 0x0000000707097812ULL, 0x000fe200078ec0ffULL,
0x0000010014047824ULL, 0x002fe400078e00ffULL, 0x00000001160b7824ULL, 0x040fe200078e0210ULL,
0x0000000f09097812ULL, 0x000fe200078e7802ULL, 0x0000620017067a24ULL, 0x000fe200078e0204ULL,
0x0000000403057217ULL, 0x000fe20007800000ULL, 0x0000000116187824ULL, 0x000fe200078e0213ULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x00000010070d7824ULL, 0x000fc400078e0209ULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x000000070a047812ULL, 0x000fe200078ec0ffULL,
0x0000000106117824ULL, 0x000fe200078e020bULL, 0x0000000f0c0c7812ULL, 0x000fe200078e7802ULL,
0x0000000106197824ULL, 0x000fe200078e0218ULL, 0x0000000f04097812ULL, 0x000fe200078e7802ULL,
0x0000000106047824ULL, 0x000fe200078e0207ULL, 0x0000002005077807ULL, 0x000fe20000000000ULL,
0x000000100b127824ULL, 0x000fe200078e020cULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x000000100a0f7824ULL, 0x000fe200078e0209ULL, 0x0000000716077217ULL, 0x000fe20007800000ULL,
0x0000000106097824ULL, 0x000fe200078e020aULL, 0x00000007180a7812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fc600078e001bULL, 0x0000000f0a0b7812ULL, 0x000fe200078e7802ULL,
0x00000001070c7824ULL, 0x000fe200078e0a16ULL, 0x0000001a040a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0011067625ULL, 0x000fc600078e001bULL, 0x0000000c0800720cULL, 0x000fe20003f26070ULL,
0x0000001018187824ULL, 0x000fe200078e020bULL, 0x0000001a06067210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0605ULL, 0x0000000c0e00720cULL, 0x080fe20003f46070ULL,
0x00005e0009047625ULL, 0x080fe200078e001bULL, 0x0000000c1000720cULL, 0x080fe40003f66070ULL,
0x0000000c1300720cULL, 0x000fe20003f06070ULL, 0x00005e0019087625ULL, 0x000fe200078e001bULL,
0x0000001a04047210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000001a08087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fc800020e0605ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000c0000f0f7811ULL, 0x000fe200078e20ffULL, 0x0106880016ff7f8cULL, 0x0003e2000c80043fULL,
0x0000c00012127811ULL, 0x000fe200078e20ffULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c901c46ULL, 0x000000151400720cULL, 0x000fe20003f26070ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x00000000040f7faeULL, 0x0005e2000d101c46ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff4d7224ULL, 0x000fe200078e00ffULL,
0x0000000006127faeULL, 0x0007e2000d901c46ULL, 0x0000c00018047811ULL, 0x004fe200078e20ffULL,
0xff317217ff187424ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x008fc6000001ff00ULL,
0x0000000008047faeULL, 0x0005e8000c101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000047805ULL, 0x000fc6000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x002fec0000008000ULL,
0x0106a800ff1a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff1c7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00013cf000001947ULL, 0x000fea0003800000ULL, 0x00000004001e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x002fc400078e001bULL, 0x000000ffff3e7224ULL, 0x004fe200078e001dULL,
0x000000021e1f7810ULL, 0x000fe20007ffe0ffULL, 0xff317217ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x00000100141a7824ULL, 0x000fca00078e00ffULL,
0x000000031a00720cULL, 0x000fda0003f06070ULL, 0x00013c2000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff1a7984ULL, 0x000e640000000800ULL, 0x800000001aff7812ULL, 0x002fe4000780483eULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff1a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fe4000780483eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff1a7424ULL, 0x000fc800078e00ffULL,
0x0000001a001b7305ULL, 0x0002a4000021f000ULL, 0x3fa000001a1a7823ULL, 0x002fe200000100ffULL,
0x0000001b0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff1b7984ULL, 0x000e640000000800ULL,
0x800000001bff7812ULL, 0x002fc4000780483eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020141a7811ULL, 0x000fe200078e40ffULL, 0x00000100ff307424ULL, 0x000fe200078e00ffULL,
0x00000004ff2f7819ULL, 0x000fe20000011602ULL, 0x0000001002317824ULL, 0x000fe200078e00ffULL,
0x0000001a031c7217ULL, 0x000fe20007800000ULL, 0x00006200172b7a24ULL, 0x100fe200078e021aULL,
0x00000001141b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000116207824ULL, 0x000fe200078e022fULL,
0x000000022f227810ULL, 0x040fe20007ffe0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e0a1aULL,
0x000000042f237810ULL, 0x000fe20007ffe0ffULL, 0x00000001201a7824ULL, 0x000fe200078e022bULL,
0x000000151b00720cULL, 0x000fe20003f06070ULL, 0x0000000116257824ULL, 0x040fe200078e0222ULL,
0x000000062f247810ULL, 0x000fe20007ffe0ffULL, 0x0000000116267824ULL, 0x000fe200078e0223ULL,
0x000000201c1c7807ULL, 0x000fe20000000000ULL, 0x00000001251d7824ULL, 0x100fe200078e022bULL,
0x000000f031217812ULL, 0x000fe200078ec0ffULL, 0x0000000126287824ULL, 0x000fe200078e022bULL,
0x0000001c162c7217ULL, 0x000fe20007800000ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0030ULL,
0x00005e001d1c7625ULL, 0x000fe200078e0030ULL, 0x000000211a2a7210ULL, 0x000fc60007f3e0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0030ULL, 0x000000211c1c7210ULL, 0x000fc60007f5e0ffULL,
0x0000000116277824ULL, 0x000fe200078e0224ULL, 0x00000021282e7210ULL, 0x000fe20007f7e0ffULL,
0x000000012c2c7824ULL, 0x000fe200078e0a16ULL, 0x0000000720287812ULL, 0x000fe200078ec0ffULL,
0x00000001271a7824ULL, 0x000fe400078e022bULL, 0x000000ffff2b7224ULL, 0x000fe200008e061bULL,
0x0000002c2f00720cULL, 0x080fe20003f26070ULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x0000000f28287812ULL, 0x000fe200078e7802ULL, 0x000000ffff2f7224ULL, 0x000fe200018e0629ULL,
0x0000002c2200720cULL, 0x000fe20003f46070ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0030ULL,
0x0000002c2300720cULL, 0x000fc40003f66070ULL, 0x0000002c2400720cULL, 0x000fe20003f86070ULL,
0x0000001020627824ULL, 0x000fe200078e0228ULL, 0x0000000725297812ULL, 0x000fe400078ec0ffULL,
0x00000007262c7812ULL, 0x000fe400078ec0ffULL, 0x0000000727307812ULL, 0x000fe400078ec0ffULL,
0x0000000f29297812ULL, 0x100fe400078e7802ULL, 0x0000000f2c2c7812ULL, 0x000fc400078e7802ULL,
0x0000000f30307812ULL, 0x000fe200078e7802ULL, 0x0000001025617824ULL, 0x000fe200078e0229ULL,
0x0000e00062287811ULL, 0x000fe200078e20ffULL, 0x0000001026607824ULL, 0x000fe200078e022cULL,
0x000000211a1a7210ULL, 0x000fe20007fbe0ffULL, 0x00000010275f7824ULL, 0x000fe200078e0230ULL,
0x0000e00061297811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a287faeULL, 0x0003e4000c901c46ULL, 0x000000ffff1b7224ULL, 0x000fe400028e061bULL,
0x000000001c297faeULL, 0x0005e2000d101c46ULL, 0x0000e000602a7811ULL, 0x002fc400078e20ffULL,
0x0000e0005f2b7811ULL, 0x000fc600078e20ffULL, 0x000000002e2a7faeULL, 0x0005e8000d901c46ULL,
0x000000001a2b7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x0106b000ff1a7f8cULL, 0x000e68000c80043fULL,
0x0106ac00ff2c7984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060800161c7f8cULL, 0x000fe2000c80043fULL,
0x800000002cff7812ULL, 0x004fc6000784483dULL, 0x01060c00162e7984ULL, 0x000ea40000000800ULL,
0x800000002eff7812ULL, 0x004fe4000782481dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2c7424ULL, 0x000fc800078e00ffULL, 0x0000002c002e7305ULL, 0x0004e4000021f000ULL,
0x3fa000002c2c7823ULL, 0x004fe200000100ffULL, 0x0000002e0000735dULL, 0x008fe40003800000ULL,
0x01060c00162e7984ULL, 0x000ea40000000800ULL, 0x800000002eff7812ULL, 0x004fc4000782481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff1c7819ULL, 0x000fe40000011602ULL,
0x00000070312c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c1c1c7812ULL, 0x000fca00078ec0ffULL,
0x000000012c2c7824ULL, 0x000fca00078e021cULL, 0x010000002c1c7984ULL, 0x000ea80000000800ULL,
0x010200002c2e7984ULL, 0x0007220000000800ULL, 0x000000181c00720bULL, 0x004fe20003f3d000ULL,
0x0001c3927f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x008fc800008e0100ULL,
0x0000ffff1d2f7812ULL, 0x000fe2000782c0ffULL, 0x000003c000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1d7424ULL, 0x000fd600078e00ffULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f65270ULL, 0x000000181c00720bULL, 0x000fe20003f34000ULL,
0x0001c3727f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x000fe400008e0100ULL,
0x0000001c18307209ULL, 0x000fe40007810000ULL, 0x0000ffff1d1d7812ULL, 0x000fc600078e3cffULL,
0x010400302c00b388ULL, 0x0005e20000000800ULL, 0x8000003018187221ULL, 0x000fe20000010000ULL,
0x0000001d2fff7212ULL, 0x000fc6000782c0ffULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x0000001800317308ULL, 0x0007240000000800ULL, 0x00000002ff187819ULL, 0x008fe20000011602ULL,
0x0001c3327f007947ULL, 0x000fea000b800000ULL, 0x00001f18311d7589ULL, 0x0144e400000e0000ULL,
0x0000000818187810ULL, 0x004fe20007ffe0ffULL, 0x0001c3827f007947ULL, 0x000fea000b800000ULL,
0x00001f1831187589ULL, 0x00052400000e0000ULL, 0x800000301c1c1221ULL, 0x000fe40000010000ULL,
0x0000001807077220ULL, 0x090fe40000410000ULL, 0x3fb8aa3b1c1c1820ULL, 0x000fe40000410000ULL,
0x0000001806067220ULL, 0x000fc40000410000ULL, 0x0000001c002d1308ULL, 0x0009620000000800ULL,
0x0000001847477220ULL, 0x080fe40000410000ULL, 0x0000001846467220ULL, 0x080fe40000410000ULL,
0x000000184b4b7220ULL, 0x080fe40000410000ULL, 0x000000184a4a7220ULL, 0x080fe20000410000ULL,
0x00000001ff1c7807ULL, 0x010fe20000800000ULL, 0x000000184f4f7220ULL, 0x080fe40000410000ULL,
0x000000184e4e7220ULL, 0x000fc40000410000ULL, 0x0000001843437220ULL, 0x080fe40000410000ULL,
0x0000001842427220ULL, 0x080fe40000410000ULL, 0x0000001813137220ULL, 0x080fe40000410000ULL,
0x0000001812127220ULL, 0x080fe40000410000ULL, 0x000000180f0f7220ULL, 0x080fe40000410000ULL,
0x000000180e0e7220ULL, 0x000fc40000410000ULL, 0x000000180b0b7220ULL, 0x080fe40000410000ULL,
0x000000180a0a7220ULL, 0x000fe40000410000ULL, 0x0000001d05057220ULL, 0x088fe40000410000ULL,
0x0000001d04047220ULL, 0x080fe40000410000ULL, 0x0000001d45457220ULL, 0x080fe40000410000ULL,
0x0000001d44447220ULL, 0x000fc40000410000ULL, 0x0000001d49497220ULL, 0x080fe40000410000ULL,
0x0000001d48487220ULL, 0x080fe40000410000ULL, 0x0000001d4d4d7220ULL, 0x080fe40000410000ULL,
0x0000001d4c4c7220ULL, 0x080fe40000410000ULL, 0x0000001d41417220ULL, 0x080fe40000410000ULL,
0x0000001d40407220ULL, 0x000fc40000410000ULL, 0x0000001d11117220ULL, 0x080fe40000410000ULL,
0x0000001d10107220ULL, 0x080fe40000410000ULL, 0x0000001d0d0d7220ULL, 0x080fe40000410000ULL,
0x0000001d0c0c7220ULL, 0x080fe40000410000ULL, 0x0000001d09097220ULL, 0x080fe40000410000ULL,
0x0000001d08087220ULL, 0x000fe20000410000ULL, 0x000076101c1d7816ULL, 0x000fe2000000001dULL,
0x0000003119197220ULL, 0x000fc40000410000ULL, 0x000000ffff187224ULL, 0x000fe400078e0030ULL,
0x0000002d2e2e1220ULL, 0x020fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000192e197221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff1c7984ULL, 0x000ee40000000800ULL,
0x800000001cff7812ULL, 0x008fe4000782483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c002e7305ULL, 0x000724000021f000ULL, 0x3fa000001c1c7823ULL, 0x008fe200000100ffULL,
0x0000002e0000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff2e7984ULL, 0x000ee40000000800ULL,
0x800000002eff7812ULL, 0x008fc4000782483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002dff1c723eULL, 0x000fe400000010ffULL, 0x00000004ff357819ULL, 0x100fe40000011602ULL,
0x00000002ff307819ULL, 0x000fe40000011602ULL, 0x000054101c1c7816ULL, 0x000fe2000000001cULL,
0x0001c0127f007947ULL, 0x000fea000b800000ULL, 0x00001f301c777589ULL, 0x00072400000e0000ULL,
0x00000008302e7810ULL, 0x000fe20007ffe0ffULL, 0x0001c0627f007947ULL, 0x000fea000b800000ULL,
0x00001f2e1c717589ULL, 0x0004e400000e0000ULL, 0x00000010302f7810ULL, 0x000fe20007ffe0ffULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e001cULL,
0x00001af000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fc400078e002fULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001d30000007944ULL, 0x01efea0003c00000ULL, 0x0000001830307810ULL, 0x008fe20007ffe0ffULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e001cULL,
0x00001b7000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fe400078e0030ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001d28000007944ULL, 0x016fea0003c00000ULL, 0x00000008021c7812ULL, 0x044fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001e02317211ULL, 0x000fc400078fe0ffULL,
0x000000071c327812ULL, 0x140fe400078ec802ULL, 0x000000071c1c7812ULL, 0x000fe400078ef802ULL,
0x00000031325c7212ULL, 0x000fe400078e3cffULL, 0x0000001f02337211ULL, 0x000fe400078fe0ffULL,
0x000099101d1d7816ULL, 0x000fe200000000ffULL, 0x000000101c5e7824ULL, 0x000fe200078e025cULL,
0x0000003332347212ULL, 0x000fc800078e3cffULL, 0x0000c0005e317811ULL, 0x000fe200078e20ffULL,
0x000000101c5d7824ULL, 0x040fe200078e0234ULL, 0x000001001c1c7811ULL, 0x000fc600078e20ffULL,
0x00000000313c783bULL, 0x000ea20000004200ULL, 0x0000c0005d327811ULL, 0x000fe200078e20ffULL,
0x000000015c5c7824ULL, 0x100fe400078e021cULL, 0x00000001341c7824ULL, 0x000fe400078e021cULL,
0x000000003254783bULL, 0x000ee20000004200ULL, 0x0000c0005c337811ULL, 0x000fe400078e20ffULL,
0x0000c0001c347811ULL, 0x000fc600078e20ffULL, 0x000000003350783bULL, 0x000f680000004200ULL,
0x000000003438783bULL, 0x000f220000004200ULL, 0x000001003c6d7824ULL, 0x004fe200078e00ffULL,
0x0000003d00ef7306ULL, 0x000fe20000009400ULL, 0x00000018ffa77819ULL, 0x000fe4000001143dULL,
0x00000018ffa87819ULL, 0x000fe4000001143cULL, 0x00000018ff6d7819ULL, 0x000fc4000001146dULL,
0x00000018ff987819ULL, 0x000fe2000001143fULL, 0x0000003d00a07306ULL, 0x000ea20000005400ULL,
0x00000018ff9f7819ULL, 0x000fe4000001143eULL, 0x00000018ff8d7819ULL, 0x008fe40000011454ULL,
0x00000018ff8e7819ULL, 0x000fe40000011455ULL, 0x00000018ff587819ULL, 0x000fe20000011456ULL,
0x0000006d00f17306ULL, 0x000fe20000209400ULL, 0x00000018ff787819ULL, 0x020fc40000011450ULL,
0x00000018ff597819ULL, 0x000fe40000011457ULL, 0x00000018ff727819ULL, 0x000fe40000011451ULL,
0x00000018ff6b7819ULL, 0x010fe20000011438ULL, 0x0000006d00f27306ULL, 0x000ee20000205400ULL,
0x000000a0ef00720bULL, 0x004fe40003fdd000ULL, 0x00000018ff677819ULL, 0x000fe40000011439ULL,
0x00000018ff647819ULL, 0x000fc4000001143aULL, 0x00000018ff637819ULL, 0x000fe2000001143bULL,
0x0000006d00ba7306ULL, 0x000522000020d400ULL, 0x00000018ff667819ULL, 0x000fe40000011452ULL,
0x00000018ff657819ULL, 0x000fca0000011453ULL, 0x0000003d00377306ULL, 0x000a62000000d400ULL,
0x000001003d6d7824ULL, 0x004fe200078e00ffULL, 0x000000f2f100720bULL, 0x008fc80003f3d000ULL,
0x00000018ffb97819ULL, 0x000fe4000001146dULL, 0x0000003c00757306ULL, 0x000fe20000009400ULL,
0x000100003d3d7824ULL, 0x020fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00f07306ULL, 0x000ea20000005400ULL, 0x00000001baba1812ULL, 0x010fe400078efcffULL,
0x0000000137376812ULL, 0x002fca00078efcffULL, 0x0000003c00367306ULL, 0x0002f0000000d400ULL,
0x000000b9006d7306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x002fe200078e00ffULL,
0x000000f07500720bULL, 0x004fc80003f9d000ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x000000b900867306ULL, 0x000e6e0000205400ULL, 0x0000000136364812ULL, 0x008fe200078efcffULL,
0x0000003d00ea7306ULL, 0x000fe60000209400ULL, 0x00000036ba36723eULL, 0x000fca00000010ffULL,
0x0000003d00eb7306ULL, 0x000ea20000205400ULL, 0x000000866d00720bULL, 0x002fce0003f3d000ULL,
0x0000003d00a97306ULL, 0x0002f0000020d400ULL, 0x0000003c00ec7306ULL, 0x000fe20000209400ULL,
0x000001003f3d7824ULL, 0x002fe200078e00ffULL, 0x000000ebea00720bULL, 0x004fe20003f9d000ULL,
0x0000010039ea7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00ed7306ULL, 0x000e620000205400ULL, 0x00000018ffea7819ULL, 0x000fcc00000114eaULL,
0x00000001a9a94812ULL, 0x008fe200078efcffULL, 0x000000a700707306ULL, 0x000ff00000209400ULL,
0x000000a700857306ULL, 0x000ea20000205400ULL, 0x000000edec00720bULL, 0x002fce0003f7d000ULL,
0x0000003c00aa7306ULL, 0x0002f0000020d400ULL, 0x0000003d00e17306ULL, 0x000fe20000209400ULL,
0x000001003e3c7824ULL, 0x002fe200078e00ffULL, 0x000000857000720bULL, 0x004fc80003f5d000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003d00e27306ULL, 0x000e620000205400ULL,
0x00000001aaaa3812ULL, 0x008fce00078efcffULL, 0x000000b900b97306ULL, 0x000eb0000020d400ULL,
0x0000003f00da7306ULL, 0x000fe20000009400ULL, 0x000000e2e100720bULL, 0x002fce0003fdd000ULL,
0x0000003f00d87306ULL, 0x000e620000005400ULL, 0x00000001b9b91812ULL, 0x004fc800078efcffULL,
0x00000037b937723eULL, 0x000fc600000010ffULL, 0x0000003c009a7306ULL, 0x000ff00000209400ULL,
0x0000003c00e97306ULL, 0x000ea20000205400ULL, 0x000000d8da00720bULL, 0x002fce0003f3d000ULL,
0x0000003c00a67306ULL, 0x0002f0000020d400ULL, 0x000000a700a77306ULL, 0x000f22000020d400ULL,
0x00000100543c7824ULL, 0x002fe200078e00ffULL, 0x000000e99a00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000009800767306ULL, 0x000fee0000209400ULL,
0x00000001a6a63812ULL, 0x008fe200078efcffULL, 0x0000009800d47306ULL, 0x000e620000205400ULL,
0x00000001a7a72812ULL, 0x010fce00078efcffULL, 0x0000003e00d97306ULL, 0x000ff00000009400ULL,
0x0000003e009b7306ULL, 0x000fe20000005400ULL, 0x000000d47600720bULL, 0x002fce0003f5d000ULL,
0x0000003e00a57306ULL, 0x0003f0000000d400ULL, 0x0000003d00a47306ULL, 0x0004e2000020d400ULL,
0x000100003e3e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003c00e77306ULL, 0x000fe20000209400ULL, 0x00000100553d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00e87306ULL, 0x000e620000205400ULL,
0x00000001a4a46812ULL, 0x008fce00078efcffULL, 0x0000003f00a27306ULL, 0x0004f0000000d400ULL,
0x000000a800a17306ULL, 0x000fe20000209400ULL, 0x000100003f3f7824ULL, 0x004fe200078e00ffULL,
0x000000e8e700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x000000a800ee7306ULL, 0x000e620000205400ULL, 0x00000001a2a21812ULL, 0x008fe400078efcffULL,
0x000000ff1d00720cULL, 0x000fe40003f25270ULL, 0x00000007021d7812ULL, 0x000fc600078ec0ffULL,
0x0000005400cf7306ULL, 0x000fe20000009400ULL, 0x000000081d1d7812ULL, 0x000fc800078ef802ULL,
0x0000000735357812ULL, 0x000fc600078e781dULL, 0x00000054009e7306ULL, 0x000fe20000005400ULL,
0x000000eea100720bULL, 0x002fe20003fbd000ULL, 0x000000081d357824ULL, 0x000fcc00078e0235ULL,
0x0000005400967306ULL, 0x0003f0000000d400ULL, 0x0000009800987306ULL, 0x000ea2000020d400ULL,
0x0001000054547824ULL, 0x002fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000003e00e37306ULL, 0x000ff00000209400ULL, 0x0000003e00e47306ULL, 0x000e620000205400ULL,
0x0000000198982812ULL, 0x004fce00078efcffULL, 0x0000008d00c97306ULL, 0x000ff00000209400ULL,
0x0000008d00ca7306ULL, 0x000ea20000205400ULL, 0x000000e4e300720bULL, 0x002fce0003f7d000ULL,
0x0000003c00997306ULL, 0x0002f0000020d400ULL, 0x0000003d00db7306ULL, 0x000fe20000209400ULL,
0x00000100563c7824ULL, 0x002fe200078e00ffULL, 0x000000cac900720bULL, 0x004fc80003f5d000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003d00dc7306ULL, 0x000fe20000205400ULL,
0x0000000199996812ULL, 0x008fce00078efcffULL, 0x0000003d00957306ULL, 0x0003f0000020d400ULL,
0x0000005400dd7306ULL, 0x000fe20000209400ULL, 0x00000100573d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff937819ULL, 0x000fe4000001143dULL, 0x0000005400de7306ULL, 0x000e700000205400ULL,
0x000000a800a87306ULL, 0x000eb0000020d400ULL, 0x0000003e00a37306ULL, 0x000ee2000020d400ULL,
0x000000dedd00720bULL, 0x002fce0003fdd000ULL, 0x0000003f00e57306ULL, 0x000fe20000209400ULL,
0x00000001a8a85812ULL, 0x004fe400078efcffULL, 0x0000009bd900720bULL, 0x000fca0003fbd000ULL,
0x0000003f00e67306ULL, 0x000e620000205400ULL, 0x00000001a3a33812ULL, 0x008fe400078efcffULL,
0x0000009ecf00720bULL, 0x000fca0003f7d000ULL, 0x0000003f009c7306ULL, 0x000ea2000020d400ULL,
0x00000001a5a55812ULL, 0x000fce00078efcffULL, 0x0000008d008d7306ULL, 0x000ee2000020d400ULL,
0x000000e6e500720bULL, 0x002fe40003fbd000ULL, 0x0000000196963812ULL, 0x000fca00078efcffULL,
0x0000003c003e7306ULL, 0x000fec0000209400ULL, 0x000000019c9c5812ULL, 0x004fe400078efcffULL,
0x0000003c003f7306ULL, 0x000fe20000205400ULL, 0x000000018d8d2812ULL, 0x008fce00078efcffULL,
0x0000003c00927306ULL, 0x000ff0000020d400ULL, 0x00000093003c7306ULL, 0x000ff00000209400ULL,
0x00000093003d7306ULL, 0x000e700000205400ULL, 0x0000005500c87306ULL, 0x000ff00000009400ULL,
0x0000005500797306ULL, 0x000ea20000005400ULL, 0x0000003d3c00720bULL, 0x002fc40003f5d000ULL,
0x0000a000353c7811ULL, 0x000fca00078e20ffULL, 0x0000005500917306ULL, 0x0003f0000000d400ULL,
0x0000005400947306ULL, 0x000722000020d400ULL, 0x0001000055557824ULL, 0x002fe200078e00ffULL,
0x00000079c800720bULL, 0x004fc80003fbd000ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000009f00d57306ULL, 0x000fe20000209400ULL, 0x0000010050547824ULL, 0x008fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000009f009d7306ULL, 0x000e620000205400ULL,
0x0000000194946812ULL, 0x010fe400078efcffULL, 0x0000003f3e00720bULL, 0x000fe40003fdd000ULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x0000000191915812ULL, 0x000fe400078efcffULL,
0x0000005500df7306ULL, 0x000ff00000209400ULL, 0x0000005500e07306ULL, 0x000ee20000205400ULL,
0x0000009dd500720bULL, 0x002fc40003f9d000ULL, 0x0000000192926812ULL, 0x000fca00078efcffULL,
0x0000009f009f7306ULL, 0x000e70000020d400ULL, 0x0000005800b17306ULL, 0x000fe20000209400ULL,
0x000000e0df00720bULL, 0x008fce0003f7d000ULL, 0x0000005800ad7306ULL, 0x000ee20000205400ULL,
0x000000019f9f4812ULL, 0x002fe400078efcffULL, 0x000000dcdb00720bULL, 0x000fe20003f9d000ULL,
0x000000773c3c9231ULL, 0x084fe400003400ffULL, 0x000000773e3e9231ULL, 0x000fe400003400ffULL,
0x0000005500977306ULL, 0x000e62000020d400ULL, 0x000000713d3d9231ULL, 0x080fe400003400ffULL,
0x000000713f3f9231ULL, 0x000fca00003400ffULL, 0x0000005700bb7306ULL, 0x000fe20000009400ULL,
0x000000adb100720bULL, 0x008fe20003fdd000ULL, 0x000000363c08723cULL, 0x000fe20000041808ULL,
0x0000000195954812ULL, 0x000fe200078efcffULL, 0x000100003ab17824ULL, 0x000fc800078e00ffULL,
0x0000005700807306ULL, 0x000ea20000005400ULL, 0x0000000197973812ULL, 0x002fe400078efcffULL,
0x0000000722367812ULL, 0x000fe400078e781dULL, 0x00000018ffb17819ULL, 0x000fc600000114b1ULL,
0x0000005000b77306ULL, 0x000fe20000009400ULL, 0x000000081d367824ULL, 0x000fce00078e0236ULL,
0x0000005000b87306ULL, 0x000fe20000005400ULL, 0x00000080bb00720bULL, 0x004fce0003f7d000ULL,
0x00000050007f7306ULL, 0x0003f0000000d400ULL, 0x0000005400c27306ULL, 0x000fe20000209400ULL,
0x0001000050507824ULL, 0x002fca00078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005400c37306ULL, 0x000ff00000205400ULL, 0x00000054008b7306ULL, 0x0003f0000020d400ULL,
0x0000005800587306ULL, 0x000ea2000020d400ULL, 0x0000010051547824ULL, 0x002fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005600bd7306ULL, 0x000ff00000009400ULL,
0x0000005600bc7306ULL, 0x000e620000005400ULL, 0x0000000158586812ULL, 0x004fce00078efcffULL,
0x0000008e00bf7306ULL, 0x000ff00000209400ULL, 0x0000008e00be7306ULL, 0x000ea20000205400ULL,
0x000000bcbd00720bULL, 0x002fce0003fbd000ULL, 0x0000005000cb7306ULL, 0x000ff00000209400ULL,
0x0000005000cc7306ULL, 0x000e620000205400ULL, 0x000000bebf00720bULL, 0x004fce0003f9d000ULL,
0x0000005600887306ULL, 0x0004f0000000d400ULL, 0x0000005700877306ULL, 0x000962000000d400ULL,
0x0001000056567824ULL, 0x004fe200078e00ffULL, 0x000000cccb00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000005400cd7306ULL, 0x000fe20000209400ULL,
0x0001000057577824ULL, 0x010fe200078e00ffULL, 0x0000000188885812ULL, 0x008fc800078efcffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000005400ce7306ULL, 0x000fe20000205400ULL,
0x0000000187873812ULL, 0x020fe400078efcffULL, 0x000000c3c200720bULL, 0x000fe40003f7d000ULL,
0x000000889292723eULL, 0x000fc600000010ffULL, 0x00000054008c7306ULL, 0x0003f0000020d400ULL,
0x0000005100af7306ULL, 0x000fe20000009400ULL, 0x0000010038547824ULL, 0x002fe200078e00ffULL,
0x000000018b8b3812ULL, 0x000fc800078efcffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005100b07306ULL, 0x000e700000005400ULL, 0x00000051007e7306ULL, 0x0004f0000000d400ULL,
0x0000009300937306ULL, 0x000f22000020d400ULL, 0x0001000051517824ULL, 0x004fe200078e00ffULL,
0x000000b0af00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005900ae7306ULL, 0x000fee0000209400ULL, 0x000000017e7e3812ULL, 0x008fe200078efcffULL,
0x0000005900ab7306ULL, 0x000e620000205400ULL, 0x0000000193932812ULL, 0x010fc800078efcffULL,
0x000000879393723eULL, 0x000fc600000010ffULL, 0x0000008e008e7306ULL, 0x000eb0000020d400ULL,
0x0000005600d67306ULL, 0x000fe20000209400ULL, 0x000000abae00720bULL, 0x002fce0003f5d000ULL,
0x0000005600d77306ULL, 0x000e620000205400ULL, 0x000000018e8e4812ULL, 0x004fce00078efcffULL,
0x00000056008f7306ULL, 0x000eb0000020d400ULL, 0x0000005700c07306ULL, 0x000fe20000209400ULL,
0x000000d7d600720bULL, 0x002fce0003f9d000ULL, 0x0000005700c17306ULL, 0x000e6c0000205400ULL,
0x000000018f8f4812ULL, 0x004fe400078efcffULL, 0x0000005700907306ULL, 0x000fe2000020d400ULL,
0x000000b8b700720bULL, 0x000fce0003f9d000ULL, 0x0000005000847306ULL, 0x0004e2000020d400ULL,
0x000000c1c000720bULL, 0x002fca0003fbd000ULL, 0x000000017f7f4812ULL, 0x000fe400078efcffULL,
0x0000003800c67306ULL, 0x000fe20000009400ULL, 0x0000010052507824ULL, 0x004fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000003800c77306ULL, 0x000e620000005400ULL,
0x0000000184846812ULL, 0x008fe400078efcffULL, 0x0000000190905812ULL, 0x000fca00078efcffULL,
0x00000038007d7306ULL, 0x0004f0000000d400ULL, 0x0000005100d07306ULL, 0x000fe20000209400ULL,
0x0001000038387824ULL, 0x004fe200078e00ffULL, 0x000000c7c600720bULL, 0x002fc80003f7d000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005100d17306ULL, 0x000e6e0000205400ULL,
0x000000017d7d3812ULL, 0x008fe200078efcffULL, 0x0000005400567306ULL, 0x000ff00000209400ULL,
0x0000005400577306ULL, 0x000fe20000205400ULL, 0x000000d1d000720bULL, 0x002fce0003fdd000ULL,
0x00000054007b7306ULL, 0x000ff0000020d400ULL, 0x0000003900547306ULL, 0x000ff00000009400ULL,
0x0000003900557306ULL, 0x000ff00000005400ULL, 0x0000003900757306ULL, 0x0003f0000000d400ULL,
0x00000038009d7306ULL, 0x000fe20000209400ULL, 0x0001000039397824ULL, 0x002fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000038009e7306ULL, 0x000e700000205400ULL,
0x0000003800797306ULL, 0x0004f0000020d400ULL, 0x0000005900597306ULL, 0x000f22000020d400ULL,
0x000001003a387824ULL, 0x004fe200078e00ffULL, 0x0000009e9d00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003900be7306ULL, 0x000fee0000209400ULL,
0x0000000179793812ULL, 0x008fe200078efcffULL, 0x0000003900bc7306ULL, 0x000fe20000205400ULL,
0x0000000159592812ULL, 0x010fc400078efcffULL, 0x000000cecd00720bULL, 0x000fca0003f5d000ULL,
0x0000003900807306ULL, 0x0003f0000020d400ULL, 0x0000005100817306ULL, 0x0004e2000020d400ULL,
0x000001003b397824ULL, 0x002fe200078e00ffULL, 0x000000018c8c2812ULL, 0x000fc800078efcffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000007800b67306ULL, 0x000fe20000209400ULL,
0x0000010053517824ULL, 0x004fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011451ULL,
0x0000007800ac7306ULL, 0x000e620000205400ULL, 0x0000000181816812ULL, 0x008fce00078efcffULL,
0x0000005000c47306ULL, 0x000ff00000209400ULL, 0x0000005000c57306ULL, 0x000ea20000205400ULL,
0x000000acb600720bULL, 0x002fe20003fbd000ULL, 0x000100003bac7824ULL, 0x000fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x0000003800ad7306ULL, 0x000ff00000209400ULL,
0x0000003800ae7306ULL, 0x000e620000205400ULL, 0x000000c5c400720bULL, 0x004fce0003fdd000ULL,
0x0000003800ab7306ULL, 0x0004f0000020d400ULL, 0x0000003900af7306ULL, 0x000fe20000209400ULL,
0x000000aaa838723eULL, 0x004fe400000010ffULL, 0x000000aead00720bULL, 0x002fca0003f7d000ULL,
0x0000003900b07306ULL, 0x000ff00000205400ULL, 0x0000003900a87306ULL, 0x0003e2000020d400ULL,
0x00000001abab3812ULL, 0x008fce00078efcffULL, 0x0000007200b37306ULL, 0x000fe20000209400ULL,
0x000000a9a739723eULL, 0x002fce00000010ffULL, 0x0000007200b47306ULL, 0x000e620000205400ULL,
0x000000383c0c723cULL, 0x000fee000004180cULL, 0x0000007800787306ULL, 0x000ea2000020d400ULL,
0x0000a00036387811ULL, 0x000fce00078e20ffULL, 0x0000005000837306ULL, 0x000ee2000020d400ULL,
0x000000b4b300720bULL, 0x002fce0003f5d000ULL, 0x0000005200b57306ULL, 0x000fe20000009400ULL,
0x0000000178785812ULL, 0x004fce00078efcffULL, 0x0000005200b27306ULL, 0x000e620000005400ULL,
0x0000000183836812ULL, 0x008fe400078efcffULL, 0x000000555400720bULL, 0x000fe40003fdd000ULL,
0x000000a39f54723eULL, 0x000fe400000010ffULL, 0x0000009c9855723eULL, 0x000fe200000010ffULL,
0x0000005300d27306ULL, 0x000ff00000009400ULL, 0x0000005300d37306ULL, 0x000ea20000005400ULL,
0x000000b2b500720bULL, 0x002fc40003f9d000ULL, 0x0000000175756812ULL, 0x000fe400078efcffULL,
0x000000bcbe00720bULL, 0x000fc60003fdd000ULL, 0x0000003a00a07306ULL, 0x000ff00000009400ULL,
0x0000003a00a17306ULL, 0x000fe20000005400ULL, 0x000000d3d200720bULL, 0x004fe40003fbd000ULL,
0x0000000180806812ULL, 0x000fc400078efcffULL, 0x000000b0af00720bULL, 0x000fc60003fdd000ULL,
0x0000003a00707306ULL, 0x000ff0000000d400ULL, 0x0000003b00857306ULL, 0x000fe40000009400ULL,
0x00000001a8a86812ULL, 0x000fcc00078efcffULL, 0x0000003b00867306ULL, 0x000ff00000005400ULL,
0x0000003b006d7306ULL, 0x0003f0000000d400ULL, 0x0000007200727306ULL, 0x000ea2000020d400ULL,
0x000000003838783bULL, 0x002e6e0000000200ULL, 0x0000007a00507306ULL, 0x000ff00000209400ULL,
0x0000007a00517306ULL, 0x000ee20000205400ULL, 0x0000000172722812ULL, 0x004fce00078efcffULL,
0x0000005200827306ULL, 0x000530000000d400ULL, 0x00000053007c7306ULL, 0x000a62000000d400ULL,
0x000000515000720bULL, 0x008fe20003f5d000ULL, 0x0001000052527824ULL, 0x004fe200078e00ffULL,
0x000000a5a650723eULL, 0x000fc400000010ffULL, 0x000000a2a451723eULL, 0x000fe400000010ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x000000ea009a7306ULL, 0x000fe20000209400ULL,
0x0000000182824812ULL, 0x010fe200078efcffULL, 0x0001000053537824ULL, 0x020fe200078e00ffULL,
0x000000575600720bULL, 0x000fe20003f9d000ULL, 0x000000503c10723cULL, 0x040fe20000041810ULL,
0x0000007738389231ULL, 0x082fe400003400ffULL, 0x000000773a3a9231ULL, 0x000fe200003400ffULL,
0x000000ea009b7306ULL, 0x000e620000205400ULL, 0x000000017c7c5812ULL, 0x000fe200078efcffULL,
0x0000007139399231ULL, 0x080fe200003400ffULL, 0x000000969950723eULL, 0x000fe200000010ffULL,
0x000000543c54723cULL, 0x000fe20000041840ULL, 0x000000919551723eULL, 0x000fe200000010ffULL,
0x000000713b3b9231ULL, 0x000fc400003400ffULL, 0x000000ea00767306ULL, 0x000ea2000020d400ULL,
0x000000017b7b4812ULL, 0x000fe400078efcffULL, 0x00000018ff417819ULL, 0x000fe20000011453ULL,
0x000000503c4c723cULL, 0x000fe2000004184cULL, 0x000000978e53723eULL, 0x000fe400000010ffULL,
0x0000008f5840723eULL, 0x000fe200000010ffULL, 0x0000006b008a7306ULL, 0x000fe20000209400ULL,
0x0000009b9a00720bULL, 0x002fce0003fbd000ULL, 0x0000006b00897306ULL, 0x000e6c0000205400ULL,
0x0000000176765812ULL, 0x004fe400078efcffULL, 0x00000067005a7306ULL, 0x000ff00000209400ULL,
0x00000067005b7306ULL, 0x000ea20000205400ULL, 0x000000898a00720bULL, 0x002fce0003f9d000ULL,
0x0000005200377306ULL, 0x000ff00000209400ULL, 0x00000052009f7306ULL, 0x000e620000205400ULL,
0x0000005b5a00720bULL, 0x004fce0003fbd000ULL, 0x0000005200987306ULL, 0x0005f0000020d400ULL,
0x0000006b006b7306ULL, 0x000ee2000020d400ULL, 0x000000948d52723eULL, 0x004fe400000010ffULL,
0x0000009f3700720bULL, 0x002fca0003f7d000ULL, 0x0000006700677306ULL, 0x000e62000020d400ULL,
0x000000523c50723cULL, 0x000fee0000041848ULL, 0x0000007a007a7306ULL, 0x000ea2000020d400ULL,
0x0000007f8b48723eULL, 0x000fe400000010ffULL, 0x0000007e8c49723eULL, 0x000fc400000010ffULL,
0x000000016b6b4812ULL, 0x008fe400078efcffULL, 0x000000868500720bULL, 0x000fe20003f9d000ULL,
0x0000006600737306ULL, 0x000fe20000209400ULL, 0x0000000167675812ULL, 0x002fe200078efcffULL,
0x000000483848723cULL, 0x000fe20000041808ULL, 0x0000000198983812ULL, 0x000fca00078efcffULL,
0x0000006600747306ULL, 0x000e620000205400ULL, 0x000000017a7a2812ULL, 0x004fe400078efcffULL,
0x000000a1a000720bULL, 0x000fe40003f5d000ULL, 0x000000016d6d4812ULL, 0x000fe400078efcffULL,
0x000000806709723eULL, 0x000fe200000010ffULL, 0x0000004100427306ULL, 0x000fe20000209400ULL,
0x000000796b08723eULL, 0x000fce00000010ffULL, 0x0000004100437306ULL, 0x000ea20000205400ULL,
0x000000747300720bULL, 0x002fe40003fbd000ULL, 0x0000000170702812ULL, 0x000fca00078efcffULL,
0x0000004100877306ULL, 0x0003f0000020d400ULL, 0x0000006600667306ULL, 0x000ee2000020d400ULL,
0x000000905941723eULL, 0x002fe400000010ffULL, 0x000000923c58723cULL, 0x000fe20000041844ULL,
0x000000434200720bULL, 0x004fc80003fdd000ULL, 0x00000064006e7306ULL, 0x000fe40000209400ULL,
0x000000847844723eULL, 0x000fe200000010ffULL, 0x000000403c04723cULL, 0x000fe20000041804ULL,
0x000000817245723eULL, 0x000fc800000010ffULL, 0x00000064006f7306ULL, 0x000e620000205400ULL,
0x0000000166665812ULL, 0x008fe400078efcffULL, 0x000000443844723cULL, 0x000fe2000004180cULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x000000828340723eULL, 0x000fe400000010ffULL,
0x0000006300687306ULL, 0x000fe20000209400ULL, 0x0000007c7a41723eULL, 0x000fe400000010ffULL,
0x0000007d7b0c723eULL, 0x000fc400000010ffULL, 0x00000075760d723eULL, 0x000fe400000010ffULL,
0x000000986666723eULL, 0x000fe200000010ffULL, 0x00000063006a7306ULL, 0x000ea20000205400ULL,
0x0000006f6e00720bULL, 0x002fe20003f5d000ULL, 0x000000403840723cULL, 0x040fec0000041810ULL,
0x00000065006c7306ULL, 0x000fe20000209400ULL, 0x00000070ab10723eULL, 0x000fe200000010ffULL,
0x0000000c380c723cULL, 0x000fe2000004184cULL, 0x0000006da811723eULL, 0x000fca00000010ffULL,
0x0000006500697306ULL, 0x000e620000205400ULL, 0x0000006a6800720bULL, 0x004fe20003f9d000ULL,
0x000000103810723cULL, 0x000fec0000041858ULL, 0x000000b1007e7306ULL, 0x000ff00000209400ULL,
0x000000b1003c7306ULL, 0x000ea20000205400ULL, 0x000000696c00720bULL, 0x002fce0003f7d000ULL,
0x000000ac000a7306ULL, 0x000ff00000209400ULL, 0x000000ac000b7306ULL, 0x000e620000205400ULL,
0x0000003c7e00720bULL, 0x004fce0003fbd000ULL, 0x0000006400647306ULL, 0x000eb0000020d400ULL,
0x0000006300637306ULL, 0x000ee2000020d400ULL, 0x0000000b0a00720bULL, 0x002fe40003fdd000ULL,
0x000000083808723cULL, 0x000fea0000041850ULL, 0x0000006500657306ULL, 0x000e62000020d400ULL,
0x0000000164642812ULL, 0x004fce00078efcffULL, 0x000000b100b17306ULL, 0x000ea2000020d400ULL,
0x0000000163634812ULL, 0x008fce00078efcffULL, 0x000000ac004d7306ULL, 0x000ee2000020d400ULL,
0x0000000165653812ULL, 0x002fc800078efcffULL, 0x000000876567723eULL, 0x000fe400000010ffULL,
0x00000001b1b15812ULL, 0x004fc800078efcffULL, 0x000000b1644c723eULL, 0x000fe200000010ffULL,
0x000000663854723cULL, 0x000fe20000041854ULL, 0x000000014d4d6812ULL, 0x008fc800078efcffULL,
0x0000004d634d723eULL, 0x000fce00000010ffULL, 0x0000004c384c723cULL, 0x000fe20000041804ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff047f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007844805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007844805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007844805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004014047811ULL, 0x000fe200078e40ffULL, 0x00000100ff3d7424ULL, 0x000fe200078e00ffULL,
0x00000004ff3b7819ULL, 0x000fc40000011602ULL, 0x0000000403057217ULL, 0x000fe20007800000ULL,
0x0000620017377a24ULL, 0x000fc800078e0204ULL, 0x0000000105057824ULL, 0x000fe400078e0a04ULL,
0x0000000120047824ULL, 0x100fe400078e0237ULL, 0x0000000125077824ULL, 0x100fe200078e0237ULL,
0x0000002005057807ULL, 0x000fe20000000000ULL, 0x0000000126387824ULL, 0x100fe400078e0237ULL,
0x00000001273a7824ULL, 0x000fe200078e0237ULL, 0x0000000516067217ULL, 0x000fe20007800000ULL,
0x00005e0004047625ULL, 0x000fe200078e003dULL, 0x0000c00062377811ULL, 0x000fc600078e20ffULL,
0x00000001063f7824ULL, 0x000fe200078e0a16ULL, 0x0000002104047210ULL, 0x000fe20007f7e0ffULL,
0x00005e0007067625ULL, 0x000fc600078e003dULL, 0x0000003f3b00720cULL, 0x000fe20003f46070ULL,
0x00005e0038387625ULL, 0x000fe200078e003dULL, 0x0000002106067210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200018e0605ULL, 0x00000021383c7210ULL, 0x000fe20007fbe0ffULL,
0x00005e003a3a7625ULL, 0x000fe200078e003dULL, 0x0000003f2200720cULL, 0x080fe40003f66070ULL,
0x0000c00061387811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200020e0607ULL,
0x0000003f2300720cULL, 0x080fe20003f86070ULL, 0x000000ffff3d7224ULL, 0x000fe200028e0639ULL,
0x0000003f2400720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004377faeULL, 0x0003e2000d101c46ULL, 0x000000213a3e7210ULL, 0x000fc40007fde0ffULL,
0x0000c00060397811ULL, 0x000fe400078e20ffULL, 0x0000c0005f3a7811ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200030e063bULL, 0x0000000006387faeULL, 0x0005e8000d901c46ULL,
0x000000003c397faeULL, 0x0005e8000e101c46ULL, 0x000000003e3a7faeULL, 0x0005e8000e901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff047f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff067984ULL, 0x004e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc4000784481bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0005ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000784481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc4000784481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002dff04723eULL, 0x000fe400000010ffULL, 0x00000002ff647819ULL, 0x000fe40000011602ULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x00019b427f007947ULL, 0x000fea000b800000ULL,
0x00001f6404ad7589ULL, 0x0002a400000e0000ULL, 0x00019b927f007947ULL, 0x000fea000b800000ULL,
0x00001f2e043e7589ULL, 0x00072400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0004ULL, 0x000040a000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x002fe400078e002fULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x0001ad5000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0004ULL,
0x0000411000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x002fc400078e0030ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001ace000007944ULL, 0x01cfea0003c00000ULL, 0x0000e0005e3b7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0005d3c7811ULL, 0x000fe400078e20ffULL,
0x0000e0001c1b7811ULL, 0x000fe200078e20ffULL, 0x000000003b04783bULL, 0x00ae620000004200ULL,
0x0000e0005c1a7811ULL, 0x000fc600078e20ffULL, 0x000000003c50783bULL, 0x000ee80000004200ULL,
0x000000001a5c783bULL, 0x000f680000004200ULL, 0x000000001b58783bULL, 0x004ea20000004200ULL,
0x0000000400717306ULL, 0x002fe20000009400ULL, 0x00000018ffb27819ULL, 0x000fe20000011404ULL,
0x00000100041c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe20000011405ULL,
0x00000100537e7824ULL, 0x008fe200078e00ffULL, 0x00000018ffa17819ULL, 0x000fc40000011406ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000000400987306ULL, 0x000e620000005400ULL,
0x00000018ff8f7819ULL, 0x000fe40000011450ULL, 0x00000018ff9f7819ULL, 0x000fe40000011407ULL,
0x00000018ff617819ULL, 0x000fe40000011452ULL, 0x00000018ff817819ULL, 0x000fe20000011453ULL,
0x0000000400b97306ULL, 0x000722000000d400ULL, 0x00000018ff637819ULL, 0x000fc40000011451ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff787819ULL, 0x020fe4000001145cULL,
0x00000018ff727819ULL, 0x000fe2000001145dULL, 0x0000001c00777306ULL, 0x000fe20000209400ULL,
0x0001000004047824ULL, 0x008fe200078e00ffULL, 0x000000987100720bULL, 0x002fe40003fbd000ULL,
0x00000018ff6d7819ULL, 0x000fe4000001145eULL, 0x00000018ff047819ULL, 0x000fc40000011404ULL,
0x0000001c00a97306ULL, 0x000e620000205400ULL, 0x00000018ff697819ULL, 0x000fe4000001145fULL,
0x00000018ff677819ULL, 0x004fe40000011458ULL, 0x00000018ff667819ULL, 0x000fe40000011459ULL,
0x00000001b9b95812ULL, 0x010fe200078efcffULL, 0x0000000400f17306ULL, 0x000fe20000209400ULL,
0x00000018ff657819ULL, 0x000fe4000001145aULL, 0x00000018ff647819ULL, 0x000fca000001145bULL,
0x0000000400f27306ULL, 0x000ea20000205400ULL, 0x000000a97700720bULL, 0x002fce0003f9d000ULL,
0x0000001c00c67306ULL, 0x0002f0000020d400ULL, 0x00000005008c7306ULL, 0x000fe20000009400ULL,
0x00000100051c7824ULL, 0x002fe200078e00ffULL, 0x000000f2f100720bULL, 0x004fc80003f7d000ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000000500997306ULL, 0x000e620000005400ULL,
0x00000001c6c64812ULL, 0x008fce00078efcffULL, 0x0000000500b57306ULL, 0x0005f0000000d400ULL,
0x0000000400b87306ULL, 0x000722000020d400ULL, 0x0001000005057824ULL, 0x004fe200078e00ffULL,
0x000000998c00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000003f00e27306ULL, 0x000fe20000209400ULL, 0x0000010006047824ULL, 0x008fca00078e00ffULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x0000003f00e17306ULL, 0x000e620000205400ULL,
0x00000001b8b83812ULL, 0x010fe400078efcffULL, 0x00000001b5b52812ULL, 0x000fca00078efcffULL,
0x0000000600e07306ULL, 0x000ff00000009400ULL, 0x00000006007b7306ULL, 0x000fe20000005400ULL,
0x000000e1e200720bULL, 0x002fce0003f7d000ULL, 0x0000000600a87306ULL, 0x0003f0000000d400ULL,
0x0000000500ef7306ULL, 0x000fe20000209400ULL, 0x0001000006067824ULL, 0x002fca00078e00ffULL,
0x00000018ff067819ULL, 0x000fe40000011406ULL, 0x0000000500f07306ULL, 0x000e700000205400ULL,
0x0000003f003f7306ULL, 0x000eb0000020d400ULL, 0x0000001c008d7306ULL, 0x000fe20000209400ULL,
0x000000f0ef00720bULL, 0x002fce0003fbd000ULL, 0x0000001c00ee7306ULL, 0x000e620000205400ULL,
0x000000013f3f3812ULL, 0x004fce00078efcffULL, 0x0000000600ea7306ULL, 0x000ff00000209400ULL,
0x0000000600eb7306ULL, 0x000ea20000205400ULL, 0x000000ee8d00720bULL, 0x002fce0003f9d000ULL,
0x0000000400e67306ULL, 0x000ff00000209400ULL, 0x0000000400e77306ULL, 0x000fe20000205400ULL,
0x000000ebea00720bULL, 0x004fce0003f7d000ULL, 0x0000000400ae7306ULL, 0x0003f0000020d400ULL,
0x0000000500af7306ULL, 0x0004e2000020d400ULL, 0x0000010050047824ULL, 0x002fca00078e00ffULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x0000000700df7306ULL, 0x000fe20000009400ULL,
0x0000010007057824ULL, 0x004fca00078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x00000007009a7306ULL, 0x000e620000005400ULL, 0x00000001afaf5812ULL, 0x008fc800078efcffULL,
0x000000af3f3f723eULL, 0x000fc600000010ffULL, 0x0000001c00c77306ULL, 0x000eb0000020d400ULL,
0x0000000600a57306ULL, 0x000722000020d400ULL, 0x0000009adf00720bULL, 0x002fce0003fbd000ULL,
0x0000000400e47306ULL, 0x000fe20000209400ULL, 0x0000010052067824ULL, 0x008fe200078e00ffULL,
0x00000001c7c74812ULL, 0x004fe400078efcffULL, 0x000000e7e600720bULL, 0x000fe40003f9d000ULL,
0x00000018ff927819ULL, 0x000fe40000011406ULL, 0x0000000400e57306ULL, 0x000e620000205400ULL,
0x00000001a5a53812ULL, 0x010fce00078efcffULL, 0x0000000500e87306ULL, 0x000fe20000209400ULL,
0x00000001aeae4812ULL, 0x000fce00078efcffULL, 0x0000000500e97306ULL, 0x000ea20000205400ULL,
0x000000e5e400720bULL, 0x002fce0003f7d000ULL, 0x0000000500a47306ULL, 0x0002f0000020d400ULL,
0x00000050009b7306ULL, 0x000fe20000009400ULL, 0x0000010051057824ULL, 0x002fe200078e00ffULL,
0x000000e9e800720bULL, 0x004fc80003f5d000ULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000005000dc7306ULL, 0x000fee0000005400ULL, 0x00000001a4a42812ULL, 0x008fe200078efcffULL,
0x00000050009c7306ULL, 0x0003f0000000d400ULL, 0x0000000700a37306ULL, 0x0004e2000000d400ULL,
0x0001000050507824ULL, 0x002fca00078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000009f007c7306ULL, 0x000fe20000209400ULL, 0x0001000007077824ULL, 0x004fca00078e00ffULL,
0x00000018ff077819ULL, 0x000fe40000011407ULL, 0x0000009f00db7306ULL, 0x000e620000205400ULL,
0x00000001a3a35812ULL, 0x008fce00078efcffULL, 0x0000000400a07306ULL, 0x000eb0000020d400ULL,
0x00000005001c7306ULL, 0x000fe20000209400ULL, 0x000000db7c00720bULL, 0x002fe20003fbd000ULL,
0x0000010059db7824ULL, 0x000fca00078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x0000000500e37306ULL, 0x000fe20000205400ULL, 0x00000001a0a03812ULL, 0x004fce00078efcffULL,
0x00000005009e7306ULL, 0x000ff0000020d400ULL, 0x0000005200c27306ULL, 0x000ff00000009400ULL,
0x0000005200967306ULL, 0x000ff00000005400ULL, 0x0000005200627306ULL, 0x0003f0000000d400ULL,
0x0000005300c07306ULL, 0x000fe20000009400ULL, 0x0001000052527824ULL, 0x002fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000005300857306ULL, 0x000ff00000005400ULL,
0x0000005300607306ULL, 0x0003f0000000d400ULL, 0x000000b2006b7306ULL, 0x000fe20000209400ULL,
0x0001000053537824ULL, 0x002fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x000000b2006c7306ULL, 0x000e700000205400ULL, 0x000000a100de7306ULL, 0x000ff00000209400ULL,
0x000000a100dd7306ULL, 0x000ea20000205400ULL, 0x0000006c6b00720bULL, 0x002fce0003fdd000ULL,
0x0000005000047306ULL, 0x000ff00000209400ULL, 0x0000005000057306ULL, 0x000e620000205400ULL,
0x000000ddde00720bULL, 0x004fce0003f9d000ULL, 0x0000009f009f7306ULL, 0x000eb0000020d400ULL,
0x0000000700ec7306ULL, 0x000fe20000209400ULL, 0x000000050400720bULL, 0x002fce0003f7d000ULL,
0x0000000700ed7306ULL, 0x000e620000205400ULL, 0x000000019f9f5812ULL, 0x004fce00078efcffULL,
0x0000008f00d67306ULL, 0x000ff00000209400ULL, 0x0000008f00917306ULL, 0x000ea20000205400ULL,
0x000000edec00720bULL, 0x002fce0003f5d000ULL, 0x0000005200ce7306ULL, 0x000ff00000209400ULL,
0x0000005200cf7306ULL, 0x000fe20000205400ULL, 0x00000091d600720bULL, 0x004fce0003fbd000ULL,
0x00000052008e7306ULL, 0x0003f0000020d400ULL, 0x0000005300d47306ULL, 0x000fe20000209400ULL,
0x000001005c527824ULL, 0x002fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000005300d57306ULL, 0x000ff00000205400ULL, 0x0000005300897306ULL, 0x0003f0000020d400ULL,
0x000000b200b27306ULL, 0x000ea2000020d400ULL, 0x000001005d537824ULL, 0x002fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x000000a100a17306ULL, 0x000e70000020d400ULL,
0x00000050009d7306ULL, 0x000ee2000020d400ULL, 0x00000001b2b26812ULL, 0x004fc400078efcffULL,
0x0000007be000720bULL, 0x000fca0003fdd000ULL, 0x0000005100da7306ULL, 0x000fe20000009400ULL,
0x00000001a1a14812ULL, 0x002fe400078efcffULL, 0x000000e31c00720bULL, 0x000fca0003f9d000ULL,
0x0000005100907306ULL, 0x000fe20000005400ULL, 0x000000019d9d3812ULL, 0x008fe400078efcffULL,
0x00000096c200720bULL, 0x000fe20003f7d000ULL, 0x000100005ac27824ULL, 0x000fe200078e00ffULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x000000dc9b00720bULL, 0x000fe20003fdd000ULL,
0x0000005100937306ULL, 0x0003e2000000d400ULL, 0x000000019e9e4812ULL, 0x000fe400078efcffULL,
0x00000018ffc27819ULL, 0x000fca00000114c2ULL, 0x0000005200d07306ULL, 0x000fe20000209400ULL,
0x0001000051517824ULL, 0x002fe200078e00ffULL, 0x0000000162623812ULL, 0x000fe400078efcffULL,
0x000000cfce00720bULL, 0x000fe40003f7d000ULL, 0x00000018ff977819ULL, 0x000fe40000011451ULL,
0x0000005200d17306ULL, 0x000fe20000205400ULL, 0x000000019c9c6812ULL, 0x000fce00078efcffULL,
0x00000052008a7306ULL, 0x0003e2000020d400ULL, 0x000000018e8e3812ULL, 0x000fce00078efcffULL,
0x0000005300d27306ULL, 0x000fe20000209400ULL, 0x000001005e527824ULL, 0x002fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000005300d37306ULL, 0x000ff00000205400ULL,
0x0000005300847306ULL, 0x0003f0000020d400ULL, 0x0000000700a27306ULL, 0x000ea2000020d400ULL,
0x000001005f537824ULL, 0x002fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005c00ba7306ULL, 0x000ff00000009400ULL, 0x0000005c00bb7306ULL, 0x000fe20000005400ULL,
0x00000001a2a22812ULL, 0x004fc400078efcffULL, 0x00000090da00720bULL, 0x000fca0003f5d000ULL,
0x0000005c007d7306ULL, 0x0003f0000000d400ULL, 0x0000005d00bf7306ULL, 0x000fe20000009400ULL,
0x000100005c5c7824ULL, 0x002fe200078e00ffULL, 0x0000000193932812ULL, 0x000fc800078efcffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000005d00bc7306ULL, 0x000e700000005400ULL,
0x0000005d00767306ULL, 0x0004f0000000d400ULL, 0x0000008f008f7306ULL, 0x000f22000020d400ULL,
0x000100005d5d7824ULL, 0x004fe200078e00ffULL, 0x000000bcbf00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000005e00bd7306ULL, 0x000fee0000009400ULL,
0x0000000176763812ULL, 0x008fe200078efcffULL, 0x0000005e00be7306ULL, 0x000fe20000005400ULL,
0x000000018f8f5812ULL, 0x010fce00078efcffULL, 0x0000005e00707306ULL, 0x0003f0000000d400ULL,
0x0000007e00cc7306ULL, 0x000fe20000209400ULL, 0x000100005e5e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000007e00cd7306ULL, 0x000e700000205400ULL,
0x0000005f00d87306ULL, 0x000ff00000009400ULL, 0x0000005f00d97306ULL, 0x000fe20000005400ULL,
0x000000cdcc00720bULL, 0x002fce0003fbd000ULL, 0x0000005f00807306ULL, 0x0003f0000000d400ULL,
0x0000009700507306ULL, 0x000fe20000209400ULL, 0x000100005f5f7824ULL, 0x002fce00078e00ffULL,
0x0000009700517306ULL, 0x000e700000205400ULL, 0x0000007e008b7306ULL, 0x000eb0000020d400ULL,
0x0000005200b07306ULL, 0x000fe20000209400ULL, 0x000000515000720bULL, 0x002fce0003f9d000ULL,
0x0000005200b17306ULL, 0x000fe20000205400ULL, 0x000000018b8b5812ULL, 0x004fe400078efcffULL,
0x000000d5d400720bULL, 0x000fca0003fbd000ULL, 0x0000005200837306ULL, 0x0003f0000020d400ULL,
0x0000005300a67306ULL, 0x000fe20000209400ULL, 0x00000018ff527819ULL, 0x002fe4000001145fULL,
0x0000000189895812ULL, 0x000fc400078efcffULL, 0x000000d1d000720bULL, 0x000fc60003fbd000ULL,
0x0000005300a77306ULL, 0x000ff00000205400ULL, 0x00000053007e7306ULL, 0x0003e4000020d400ULL,
0x000000018a8a5812ULL, 0x000fcc00078efcffULL, 0x0000005c00ca7306ULL, 0x000fe20000209400ULL,
0x0000010058537824ULL, 0x002fca00078e00ffULL, 0x00000018ffdf7819ULL, 0x000fe40000011453ULL,
0x0000005c00cb7306ULL, 0x000fe20000205400ULL, 0x0000000724537812ULL, 0x000fce00078e781dULL,
0x0000005c00867306ULL, 0x000ff0000020d400ULL, 0x0000005d00c87306ULL, 0x000ff00000209400ULL,
0x0000005d00c97306ULL, 0x000ff00000205400ULL, 0x0000005d00827306ULL, 0x000ff0000020d400ULL,
0x0000005e005c7306ULL, 0x000ff00000209400ULL, 0x0000005e005d7306ULL, 0x000ff00000205400ULL,
0x0000005e007f7306ULL, 0x000ff0000020d400ULL, 0x00000052005e7306ULL, 0x000ff00000209400ULL,
0x00000052005f7306ULL, 0x000ff00000205400ULL, 0x00000052007b7306ULL, 0x0003f0000020d400ULL,
0x0000009200067306ULL, 0x000fe20000209400ULL, 0x0000000723527812ULL, 0x002fca00078e781dULL,
0x000000081d1c7824ULL, 0x040fe400078e0252ULL, 0x0000009200077306ULL, 0x000e620000205400ULL,
0x000000081d1d7824ULL, 0x000fe400078e0253ULL, 0x0000a0001c507811ULL, 0x000fc600078e20ffULL,
0x0000a0001d047811ULL, 0x000fe400078e20ffULL, 0x0000009700977306ULL, 0x000ea2000020d400ULL,
0x000000005050783bULL, 0x000eee0000000200ULL, 0x0000006300d77306ULL, 0x000fe20000209400ULL,
0x000000070600720bULL, 0x002fc40003f5d000ULL, 0x000000000404783bULL, 0x000e6a0000000200ULL,
0x0000006300757306ULL, 0x000f220000205400ULL, 0x0000000197974812ULL, 0x004fe400078efcffULL,
0x00000085c000720bULL, 0x000fca0003f9d000ULL, 0x0000009200927306ULL, 0x000eb0000020d400ULL,
0x0000006300637306ULL, 0x000f62000020d400ULL, 0x00000075d700720bULL, 0x010fe40003fdd000ULL,
0x0000000160604812ULL, 0x000fc400078efcffULL, 0x000000bbba00720bULL, 0x000fc60003f9d000ULL,
0x0000008100c47306ULL, 0x000fe20000209400ULL, 0x0000000192922812ULL, 0x004fe200078efcffULL,
0x0000003e51519231ULL, 0x088fe400003400ffULL, 0x0000003e53539231ULL, 0x080fe200003400ffULL,
0x000000629262723eULL, 0x000fe200000010ffULL, 0x000000ad50509231ULL, 0x080fe400003400ffULL,
0x0000008100c57306ULL, 0x000ea20000205400ULL, 0x0000000163636812ULL, 0x020fe200078efcffULL,
0x000000ad52529231ULL, 0x080fe200003400ffULL, 0x000000017d7d4812ULL, 0x000fe200078efcffULL,
0x0000003e05059231ULL, 0x082fe200003400ffULL, 0x000000cbca00720bULL, 0x000fe20003f9d000ULL,
0x0000003e07079231ULL, 0x000fe200003400ffULL, 0x000000b8b23e723eULL, 0x000fe200000010ffULL,
0x0000006100c17306ULL, 0x000fe20000209400ULL, 0x000000ad04049231ULL, 0x000fc400003400ffULL,
0x000000ad06069231ULL, 0x000fe200003400ffULL, 0x000000d9d800720bULL, 0x000fe40003f3d000ULL,
0x0000003e5044723cULL, 0x000fe40000041844ULL, 0x0000006100c37306ULL, 0x000e620000205400ULL,
0x000000c5c400720bULL, 0x004fe20003f5d000ULL, 0x000001005bc47824ULL, 0x000fe200078e00ffULL,
0x0000000186864812ULL, 0x000fe400078efcffULL, 0x000000a5a13e723eULL, 0x000fc400000010ffULL,
0x000000a29f3f723eULL, 0x000fe200000010ffULL, 0x0000007200ac7306ULL, 0x000fe20000209400ULL,
0x0000000180801812ULL, 0x000fe400078efcffULL, 0x0000005f5e00720bULL, 0x000fe40003f3d000ULL,
0x00000018ffc47819ULL, 0x000fe200000114c4ULL, 0x0000003e5054723cULL, 0x000fe40000041854ULL,
0x0000007200ab7306ULL, 0x000ea20000205400ULL, 0x000000c3c100720bULL, 0x002fe20003fdd000ULL,
0x000001005ac37824ULL, 0x000fc400078e00ffULL, 0x000100005bc17824ULL, 0x000fc600078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000007800b77306ULL, 0x000fe20000209400ULL,
0x00000018ffc17819ULL, 0x000fe400000114c1ULL, 0x000000017b7b1812ULL, 0x000fca00078efcffULL,
0x0000007800b67306ULL, 0x000e620000205400ULL, 0x000000abac00720bULL, 0x004fce0003f7d000ULL,
0x0000008100817306ULL, 0x000eb0000020d400ULL, 0x0000006100617306ULL, 0x000ee2000020d400ULL,
0x000000b6b700720bULL, 0x002fce0003fbd000ULL, 0x0000007200727306ULL, 0x000e62000020d400ULL,
0x0000000181812812ULL, 0x004fe400078efcffULL, 0x000000d3d200720bULL, 0x000fe40003f5d000ULL,
0x000000898189723eULL, 0x000fc600000010ffULL, 0x0000007800787306ULL, 0x000ea2000020d400ULL,
0x0000000161616812ULL, 0x008fe400078efcffULL, 0x000000bebd00720bULL, 0x000fca0003fdd000ULL,
0x0000005800b37306ULL, 0x000fe20000009400ULL, 0x0000000172723812ULL, 0x002fe400078efcffULL,
0x000000a7a600720bULL, 0x000fe40003f7d000ULL, 0x0000000184842812ULL, 0x000fe400078efcffULL,
0x000000c9c800720bULL, 0x000fe20003f5d000ULL, 0x0000005800b47306ULL, 0x000e620000005400ULL,
0x0000000178785812ULL, 0x004fe400078efcffULL, 0x000000b1b000720bULL, 0x000fc40003fbd000ULL,
0x0000000170706812ULL, 0x000fc600078efcffULL, 0x0000005800777306ULL, 0x0004e2000000d400ULL,
0x000000017e7e3812ULL, 0x000fc600078efcffULL, 0x0000000182822812ULL, 0x000fc800078efcffULL,
0x0000006d00947306ULL, 0x000fe20000209400ULL, 0x0001000058587824ULL, 0x004fe200078e00ffULL,
0x000000b4b300720bULL, 0x002fe40003f9d000ULL, 0x0000000183835812ULL, 0x000fe400078efcffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000006d00957306ULL, 0x000e620000205400ULL,
0x0000005d5c00720bULL, 0x000fe40003fbd000ULL, 0x0000009d8f5c723eULL, 0x000fc400000010ffULL,
0x00000097635d723eULL, 0x000fe400000010ffULL, 0x0000000177774812ULL, 0x008fe200078efcffULL,
0x0000006900877306ULL, 0x000fe20000209400ULL, 0x000000608b63723eULL, 0x000fc600000010ffULL,
0x0000005c505c723cULL, 0x000fe40000041808ULL, 0x000000017f7f5812ULL, 0x000fe400078efcffULL,
0x0000006900887306ULL, 0x000ea20000205400ULL, 0x000000959400720bULL, 0x002fe40003fdd000ULL,
0x0000007d8a08723eULL, 0x000fe400000010ffULL, 0x000000768409723eULL, 0x000fc600000010ffULL,
0x0000005900a97306ULL, 0x000ff00000009400ULL, 0x0000005900aa7306ULL, 0x000e620000005400ULL,
0x000000888700720bULL, 0x004fe40003f7d000ULL, 0x0000008e6188723eULL, 0x000fc400000010ffULL,
0x000000625060723cULL, 0x000fe60000041810ULL, 0x0000005900717306ULL, 0x0004e8000000d400ULL,
0x000000708310723eULL, 0x000fe400000010ffULL, 0x000000807e11723eULL, 0x000fe400000010ffULL,
0x0000005a00987306ULL, 0x000fe20000009400ULL, 0x0001000059597824ULL, 0x004fe200078e00ffULL,
0x000000aaa900720bULL, 0x002fcc0003f5d000ULL, 0x0000005a00997306ULL, 0x000e6e0000005400ULL,
0x0000000171712812ULL, 0x008fe200078efcffULL, 0x0000005a006c7306ULL, 0x0004f0000000d400ULL,
0x0000005800967306ULL, 0x000fe20000209400ULL, 0x00000018ff5a7819ULL, 0x004fc40000011459ULL,
0x000000b5c759723eULL, 0x000fe400000010ffULL, 0x000000999800720bULL, 0x002fc60003fbd000ULL,
0x0000005800c07306ULL, 0x000e700000205400ULL, 0x0000005800857306ULL, 0x0005e4000020d400ULL,
0x000000016c6c5812ULL, 0x008fcc00078efcffULL, 0x0000006d006d7306ULL, 0x000ee2000020d400ULL,
0x000000b9c658723eULL, 0x004fe400000010ffULL, 0x000000c09600720bULL, 0x002fca0003f9d000ULL,
0x0000006900697306ULL, 0x000e62000020d400ULL, 0x000000585048723cULL, 0x000fee0000041848ULL,
0x000000df009a7306ULL, 0x000fe20000209400ULL, 0x000000a8ae58723eULL, 0x000fe400000010ffULL,
0x000000a3a459723eULL, 0x000fc400000010ffULL, 0x000000016d6d6812ULL, 0x008fe400078efcffULL,
0x0000000185854812ULL, 0x000fe200078efcffULL, 0x000000df009b7306ULL, 0x000ea20000205400ULL,
0x0000000169693812ULL, 0x002fe200078efcffULL, 0x000000585040723cULL, 0x000fe60000041840ULL,
0x0000007b697b723eULL, 0x000fc600000010ffULL, 0x000000db00907306ULL, 0x000fe20000209400ULL,
0x0000009ca058723eULL, 0x000fe200000010ffULL, 0x000000080408723cULL, 0x000fe20000041848ULL,
0x000000939e59723eULL, 0x000fca00000010ffULL, 0x000000db00917306ULL, 0x000e620000205400ULL,
0x0000009b9a00720bULL, 0x004fce0003fdd000ULL, 0x0000006600737306ULL, 0x000fe40000209400ULL,
0x000000100410723cULL, 0x000fec0000041840ULL, 0x0000006600747306ULL, 0x000ea20000205400ULL,
0x000000919000720bULL, 0x002fce0003f7d000ULL, 0x000000df007c7306ULL, 0x000e70000020d400ULL,
0x000000db00757306ULL, 0x000ee2000020d400ULL, 0x000000747300720bULL, 0x004fce0003f5d000ULL,
0x0000006700797306ULL, 0x000fe20000209400ULL, 0x000000017c7c6812ULL, 0x002fce00078efcffULL,
0x00000067007a7306ULL, 0x000e620000205400ULL, 0x0000000175753812ULL, 0x008fce00078efcffULL,
0x0000005a00ba7306ULL, 0x000ff00000209400ULL, 0x0000005a00bb7306ULL, 0x000ea20000205400ULL,
0x0000007a7900720bULL, 0x002fe40003fdd000ULL, 0x0000007f6d7a723eULL, 0x000fca00000010ffULL,
0x000000c300af7306ULL, 0x000fe40000209400ULL, 0x0000007a0440723cULL, 0x000fec0000041854ULL,
0x000000c300a37306ULL, 0x000e620000205400ULL, 0x000000bbba00720bULL, 0x004fce0003f7d000ULL,
0x0000005b008c7306ULL, 0x000ff00000009400ULL, 0x0000005b008d7306ULL, 0x000ea20000005400ULL,
0x000000a3af00720bULL, 0x002fce0003f9d000ULL, 0x0000005b006b7306ULL, 0x000e70000000d400ULL,
0x0000005a00ad7306ULL, 0x000722000020d400ULL, 0x0000008d8c00720bULL, 0x004fce0003f3d000ULL,
0x0000006600667306ULL, 0x000ea2000020d400ULL, 0x000000585058723cULL, 0x048fea000004180cULL,
0x000000016b6b1812ULL, 0x002fe400078efcffULL, 0x00000086780c723eULL, 0x000fe200000010ffULL,
0x0000006700677306ULL, 0x000e62000020d400ULL, 0x00000082720d723eULL, 0x000fe200000010ffULL,
0x000000885050723cULL, 0x000fe2000004184cULL, 0x00000001adad3812ULL, 0x010fc400078efcffULL,
0x0000000166662812ULL, 0x004fc600078efcffULL, 0x000000c300c37306ULL, 0x000ea2000020d400ULL,
0x000000777c4c723eULL, 0x000fe200000010ffULL, 0x0000000c040c723cULL, 0x000fe20000041844ULL,
0x00000071754d723eULL, 0x000fe400000010ffULL, 0x000000ad6649723eULL, 0x000fc600000010ffULL,
0x000000c400937306ULL, 0x000fe20000209400ULL, 0x0000000167676812ULL, 0x002fe200078efcffULL,
0x0000004c044c723cULL, 0x000fec0000041858ULL, 0x000000c400877306ULL, 0x000e620000205400ULL,
0x00000001c3c34812ULL, 0x004fce00078efcffULL, 0x00000065006e7306ULL, 0x000ff00000209400ULL,
0x00000065006f7306ULL, 0x000ea20000205400ULL, 0x000000879300720bULL, 0x002fce0003f5d000ULL,
0x0000006400687306ULL, 0x000ff00000209400ULL, 0x00000064006a7306ULL, 0x000e620000205400ULL,
0x0000006f6e00720bULL, 0x004fce0003fdd000ULL, 0x000000c2003e7306ULL, 0x000ff00000209400ULL,
0x000000c2003f7306ULL, 0x000ea20000205400ULL, 0x0000006a6800720bULL, 0x002fce0003f7d000ULL,
0x000000c100487306ULL, 0x000ff00000209400ULL, 0x000000c100447306ULL, 0x000e620000205400ULL,
0x0000003f3e00720bULL, 0x004fce0003f9d000ULL, 0x000000c400c47306ULL, 0x000eb0000020d400ULL,
0x0000006500657306ULL, 0x000ee2000020d400ULL, 0x000000444800720bULL, 0x002fe40003fbd000ULL,
0x000000856748723eULL, 0x000fc400000010ffULL, 0x0000006cc344723eULL, 0x000fc600000010ffULL,
0x0000006400647306ULL, 0x000e62000020d400ULL, 0x00000001c4c42812ULL, 0x004fe200078efcffULL,
0x000000480448723cULL, 0x000fe6000004185cULL, 0x0000006bc445723eULL, 0x000fc600000010ffULL,
0x000000c200c27306ULL, 0x000ea2000020d400ULL, 0x0000000165656812ULL, 0x008fc600078efcffULL,
0x000000440444723cULL, 0x000fe80000041860ULL, 0x000000c100c17306ULL, 0x000ee2000020d400ULL,
0x0000000164643812ULL, 0x002fe400078efcffULL, 0x00000001c2c24812ULL, 0x004fc800078efcffULL,
0x000000c265c2723eULL, 0x000fe400000010ffULL, 0x00000001c1c15812ULL, 0x008fc800078efcffULL,
0x000000c164c3723eULL, 0x000fce00000010ffULL, 0x000000c20404723cULL, 0x000fe20000041850ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000040143e7811ULL, 0x002fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000003e0300720cULL, 0x000fe20003f24070ULL, 0x000000ffff3e7224ULL, 0x000fd800078e003fULL,
0x0000e9d000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff3f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x002fe4000782483eULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff3f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe4000782483eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff3f7424ULL, 0x000fc800078e00ffULL, 0x0000003f00507305ULL, 0x0002a4000021f000ULL,
0x3fa000003f3f7823ULL, 0x002fe200000100ffULL, 0x000000500000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff507984ULL, 0x000e640000000800ULL, 0x8000000050ff7812ULL, 0x002fc4000782483eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000060143e7811ULL, 0x000fe200078e40ffULL,
0x00000100ff587424ULL, 0x000fe200078e00ffULL, 0x00000004ff577819ULL, 0x000fe40000011602ULL,
0x0000003e033f7217ULL, 0x000fe20007800000ULL, 0x0000620017527a24ULL, 0x000fc800078e023eULL,
0x000000013f3f7824ULL, 0x000fe400078e0a3eULL, 0x00000001203e7824ULL, 0x100fe400078e0252ULL,
0x0000000125517824ULL, 0x000fe200078e0252ULL, 0x000000203f507807ULL, 0x000fe20000000000ULL,
0x00005e003e3e7625ULL, 0x000fc600078e0058ULL, 0x0000005016537217ULL, 0x000fe20007800000ULL,
0x00005e0051507625ULL, 0x000fe200078e0058ULL, 0x000000213e547210ULL, 0x000fc60007f3e0ffULL,
0x0000000153567824ULL, 0x000fe200078e0a16ULL, 0x0000002150507210ULL, 0x000fe20007f7e0ffULL,
0x00000001263e7824ULL, 0x100fe400078e0252ULL, 0x0000000127527824ULL, 0x000fe200078e0252ULL,
0x000000565700720cULL, 0x080fe20003f46070ULL, 0x000000ffff557224ULL, 0x000fe200008e063fULL,
0x000000562200720cULL, 0x000fe20003f26070ULL, 0x00005e003e3e7625ULL, 0x000fe200078e0058ULL,
0x000000562400720cULL, 0x000fc60003f86070ULL, 0x00005e0052527625ULL, 0x000fe200078e0058ULL,
0x000000213e3e7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff517224ULL, 0x000fe200018e0651ULL,
0x000000562300720cULL, 0x000fe20003f66070ULL, 0x000000ffff3f7224ULL, 0x000fe200028e063fULL,
0x0000002152527210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000054287faeULL, 0x0003e8000d101c46ULL, 0x000000ffff537224ULL, 0x000fe200030e0653ULL,
0x0000000050297faeULL, 0x0003ea000c901c46ULL, 0x000000003e2a7faeULL, 0x0005e8000d901c46ULL,
0x00000000522b7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x0106b000ff3e7f8cULL, 0x000e68000c80043fULL,
0x0106ac00ff527984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106280016507f8cULL, 0x000fe2000c80043fULL,
0x8000000052ff7812ULL, 0x004fc6000784483dULL, 0x01062c0016537984ULL, 0x000ea40000000800ULL,
0x8000000053ff7812ULL, 0x004fe40007824851ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff527424ULL, 0x000fc800078e00ffULL, 0x0000005200537305ULL, 0x0004e4000021f000ULL,
0x3fa0000052527823ULL, 0x004fe200000100ffULL, 0x000000530000735dULL, 0x008fe40003800000ULL,
0x01062c0016537984ULL, 0x000ea40000000800ULL, 0x8000000053ff7812ULL, 0x004fc40007824851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010080002c527984ULL, 0x000ea80000000800ULL,
0x010280002c537984ULL, 0x0007220000000800ULL, 0x000000185200720bULL, 0x004fe20003f3d000ULL,
0x000176e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000507806ULL, 0x008fc800008e0100ULL,
0x0000ffff50557812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff867424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe40003f65270ULL, 0x000000185200720bULL, 0x000fe20003f34000ULL,
0x000176c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000507806ULL, 0x000fe400008e0100ULL,
0x0000005218517209ULL, 0x000fe40007810000ULL, 0x0000ffff50507812ULL, 0x000fe400078e3cffULL,
0x00000002ff5a7819ULL, 0x000fe20000011602ULL, 0x8000005118547221ULL, 0x000fe20000010000ULL,
0x010480512c00b388ULL, 0x0005e20000000800ULL, 0x0000005055ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b54547820ULL, 0x000fcc0000410000ULL, 0x0000005400547308ULL, 0x000ee40000000800ULL,
0x0000005419197220ULL, 0x008fe20000410000ULL, 0x000176727f007947ULL, 0x000fea000b800000ULL,
0x00001f5a545a7589ULL, 0x0044e400000e0000ULL, 0x0000005a08087220ULL, 0x08cfe40000410000ULL,
0x0000005a09097220ULL, 0x080fe40000410000ULL, 0x0000005a0c0c7220ULL, 0x080fe40000410000ULL,
0x0000005a0d0d7220ULL, 0x080fe40000410000ULL, 0x0000005a10107220ULL, 0x000fc40000410000ULL,
0x0000005a11117220ULL, 0x080fe40000410000ULL, 0x0000005a40407220ULL, 0x080fe40000410000ULL,
0x0000005a41417220ULL, 0x080fe40000410000ULL, 0x0000005a4c4c7220ULL, 0x080fe40000410000ULL,
0x0000005a4d4d7220ULL, 0x080fe40000410000ULL, 0x0000005a48487220ULL, 0x000fc40000410000ULL,
0x0000005a49497220ULL, 0x080fe40000410000ULL, 0x0000005a44447220ULL, 0x080fe40000410000ULL,
0x0000005a45457220ULL, 0x080fe40000410000ULL, 0x0000005a04047220ULL, 0x080fe40000410000ULL,
0x0000005a05057220ULL, 0x000fe20000410000ULL, 0x000175c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2e545a7589ULL, 0x0004e400000e0000ULL, 0x0000005218187209ULL, 0x000fe20007810000ULL,
0x0000005a0a0a7220ULL, 0x08cfe20000410000ULL, 0x00000001ff867807ULL, 0x000fe20000800000ULL,
0x0000005a0b0b7220ULL, 0x000fc40000410000ULL, 0x8000001852521221ULL, 0x000fe40000010000ULL,
0x0000005a0e0e7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b52521820ULL, 0x000fe40000410000ULL,
0x0000005a0f0f7220ULL, 0x080fe40000410000ULL, 0x00000052002d1308ULL, 0x000ea20000000800ULL,
0x0000005a12127220ULL, 0x080fe40000410000ULL, 0x0000005a13137220ULL, 0x000fc40000410000ULL,
0x0000005a42427220ULL, 0x080fe40000410000ULL, 0x0000005a43437220ULL, 0x080fe40000410000ULL,
0x0000005a4e4e7220ULL, 0x080fe40000410000ULL, 0x0000005a4f4f7220ULL, 0x080fe40000410000ULL,
0x0000005a4a4a7220ULL, 0x080fe40000410000ULL, 0x0000005a4b4b7220ULL, 0x000fc40000410000ULL,
0x0000005a46467220ULL, 0x080fe40000410000ULL, 0x0000005a47477220ULL, 0x080fe40000410000ULL,
0x0000005a06067220ULL, 0x080fe40000410000ULL, 0x0000005a07077220ULL, 0x000fe40000410000ULL,
0x000000532d531220ULL, 0x014fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000001953197221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff507984ULL, 0x000ea40000000800ULL,
0x8000000050ff7812ULL, 0x004fc4000782483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff507424ULL, 0x000fc800078e00ffULL,
0x0000005000517305ULL, 0x0004e4000021f000ULL, 0x3fa0000050507823ULL, 0x004fe200000100ffULL,
0x000000510000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff517984ULL, 0x000ea40000000800ULL,
0x8000000051ff7812ULL, 0x004fe4000782483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002dff3d723eULL, 0x000fe400000010ffULL, 0x00000002ff647819ULL, 0x000fc40000011602ULL,
0x000054103d3d7816ULL, 0x000fe2000000003dULL, 0x000173727f007947ULL, 0x000fea000b800000ULL,
0x00001f643d757589ULL, 0x0004e400000e0000ULL, 0x000173c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2e3d707589ULL, 0x0008a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e003dULL, 0x00006b0000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x004fe400078e002fULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x000182f000007944ULL, 0x01afea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e003dULL,
0x00006b7000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x004fe400078e0030ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001828000007944ULL, 0x01afea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003158783bULL, 0x004ea80000004200ULL, 0x00000000325c783bULL, 0x000f680000004200ULL,
0x000000003350783bULL, 0x000f280000004200ULL, 0x000000003454783bULL, 0x000ee20000004200ULL,
0x0000010058747824ULL, 0x004fe200078e00ffULL, 0x0000005800f47306ULL, 0x000fe20000009400ULL,
0x00000018ffa67819ULL, 0x000fc40000011458ULL, 0x00000018ffa57819ULL, 0x000fe40000011459ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff987819ULL, 0x000fe2000001145bULL,
0x00000058006f7306ULL, 0x000ea20000005400ULL, 0x00000018ff9e7819ULL, 0x000fe4000001145aULL,
0x00000018ff8c7819ULL, 0x020fe4000001145cULL, 0x00000018ff767819ULL, 0x010fc40000011450ULL,
0x00000018ff717819ULL, 0x000fe20000011451ULL, 0x0000005800aa7306ULL, 0x000962000000d400ULL,
0x00000018ff617819ULL, 0x000fe4000001145fULL, 0x00000018ff8b7819ULL, 0x000fe4000001145dULL,
0x00000018ff607819ULL, 0x000fe4000001145eULL, 0x00000018ff6e7819ULL, 0x000fe20000011452ULL,
0x000000a6006d7306ULL, 0x000fe20000209400ULL, 0x0001000058587824ULL, 0x010fe200078e00ffULL,
0x0000006ff400720bULL, 0x004fc40003f7d000ULL, 0x00000018ff687819ULL, 0x000fe40000011453ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x000000a600f17306ULL, 0x000ea20000205400ULL,
0x00000018ff667819ULL, 0x008fe40000011454ULL, 0x00000018ff657819ULL, 0x000fe40000011455ULL,
0x00000018ff647819ULL, 0x000fe40000011456ULL, 0x00000001aaaa3812ULL, 0x020fe200078efcffULL,
0x0000007400f57306ULL, 0x000fe20000209400ULL, 0x00000018ff3d7819ULL, 0x000fce0000011457ULL,
0x0000007400977306ULL, 0x000ee20000205400ULL, 0x000000f16d00720bULL, 0x004fce0003fbd000ULL,
0x00000058007e7306ULL, 0x000ff00000209400ULL, 0x0000005800f07306ULL, 0x000fe20000205400ULL,
0x00000097f500720bULL, 0x008fce0003fdd000ULL, 0x0000005800a97306ULL, 0x0005f0000020d400ULL,
0x0000007400b97306ULL, 0x000722000020d400ULL, 0x000001005a587824ULL, 0x004fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000005900f37306ULL, 0x000fe20000009400ULL,
0x0000010059747824ULL, 0x008fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000059008f7306ULL, 0x000ea20000005400ULL, 0x00000001b9b96812ULL, 0x010fe400078efcffULL,
0x000000f07e00720bULL, 0x000fca0003fdd000ULL, 0x0000005900a87306ULL, 0x0007f0000000d400ULL,
0x000000a600a67306ULL, 0x000f22000020d400ULL, 0x0001000059597824ULL, 0x008fe200078e00ffULL,
0x00000001a9a96812ULL, 0x000fc400078efcffULL, 0x0000008ff300720bULL, 0x004fe40003f3d000ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000058009c7306ULL, 0x000ff00000209400ULL,
0x0000005800eb7306ULL, 0x000ea20000205400ULL, 0x00000001a6a65812ULL, 0x010fc400078efcffULL,
0x00000001a8a81812ULL, 0x000fca00078efcffULL, 0x0000005900ee7306ULL, 0x000ff00000209400ULL,
0x0000005900ef7306ULL, 0x000ee20000205400ULL, 0x000000eb9c00720bULL, 0x004fce0003fbd000ULL,
0x0000005900a77306ULL, 0x000530000020d400ULL, 0x0000005b00797306ULL, 0x000fe20000009400ULL,
0x000001005b597824ULL, 0x004fe200078e00ffULL, 0x000000efee00720bULL, 0x008fc80003fdd000ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000005b00d67306ULL, 0x000fee0000005400ULL,
0x00000001a7a76812ULL, 0x010fe200078efcffULL, 0x0000005b00a27306ULL, 0x0005f0000000d400ULL,
0x0000005a00907306ULL, 0x000fe20000009400ULL, 0x000100005b5b7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x0000005a00f27306ULL, 0x000eb00000005400ULL,
0x0000005a00a47306ULL, 0x000730000000d400ULL, 0x0000005800587306ULL, 0x000f62000020d400ULL,
0x000100005a5a7824ULL, 0x008fe200078e00ffULL, 0x000000f29000720bULL, 0x004fc80003f5d000ULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x000000a500677306ULL, 0x000fee0000209400ULL,
0x00000001a4a42812ULL, 0x010fe200078efcffULL, 0x000000a5007d7306ULL, 0x000ea20000205400ULL,
0x0000000158585812ULL, 0x020fc800078efcffULL, 0x000000a45858723eULL, 0x000fc600000010ffULL,
0x0000005b00ec7306ULL, 0x000ff00000209400ULL, 0x0000005b00ed7306ULL, 0x000ee20000205400ULL,
0x0000007d6700720bULL, 0x004fce0003f9d000ULL, 0x0000005a00e17306ULL, 0x000ff00000209400ULL,
0x0000005a00e27306ULL, 0x000ea20000205400ULL, 0x000000edec00720bULL, 0x008fce0003fbd000ULL,
0x0000005a00a37306ULL, 0x000730000020d400ULL, 0x0000005c00a17306ULL, 0x000fe20000009400ULL,
0x000001005c5a7824ULL, 0x008fe200078e00ffULL, 0x000000e2e100720bULL, 0x004fc80003fdd000ULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x0000005c00c87306ULL, 0x000fee0000005400ULL,
0x00000001a3a36812ULL, 0x010fe200078efcffULL, 0x0000005c00947306ULL, 0x0005f0000000d400ULL,
0x0000007400817306ULL, 0x000fe20000209400ULL, 0x000100005c5c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x00000074009b7306ULL, 0x000eb00000205400ULL,
0x000000a500a57306ULL, 0x000ef0000020d400ULL, 0x0000005b009a7306ULL, 0x000962000020d400ULL,
0x0000009b8100720bULL, 0x004fce0003f7d000ULL, 0x0000009e009d7306ULL, 0x000fe20000209400ULL,
0x000001005d5b7824ULL, 0x010fe200078e00ffULL, 0x00000001a5a54812ULL, 0x008fc800078efcffULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x0000009e00d17306ULL, 0x000ea20000205400ULL,
0x000000019a9a5812ULL, 0x020fce00078efcffULL, 0x0000005900df7306ULL, 0x000ff00000209400ULL,
0x0000005900e07306ULL, 0x000ee20000205400ULL, 0x000000d19d00720bULL, 0x004fce0003f9d000ULL,
0x0000005c00e57306ULL, 0x000ff00000209400ULL, 0x0000005c00e67306ULL, 0x000ea20000205400ULL,
0x000000e0df00720bULL, 0x008fce0003f3d000ULL, 0x0000005c00927306ULL, 0x000730000020d400ULL,
0x0000005000b27306ULL, 0x000fe20000009400ULL, 0x00000100505c7824ULL, 0x008fe200078e00ffULL,
0x000000e6e500720bULL, 0x004fc80003fbd000ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000005000af7306ULL, 0x000fee0000005400ULL, 0x0000000192925812ULL, 0x010fe200078efcffULL,
0x00000050007f7306ULL, 0x0005f0000000d400ULL, 0x0000007400ba7306ULL, 0x000ee2000020d400ULL,
0x0001000050507824ULL, 0x004fca00078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005a00e37306ULL, 0x000ff00000209400ULL, 0x0000005a00e47306ULL, 0x000ea20000205400ULL,
0x00000001baba3812ULL, 0x008fc400078efcffULL, 0x000000d67900720bULL, 0x000fca0003f7d000ULL,
0x0000005a00997306ULL, 0x000730000020d400ULL, 0x0000009800c97306ULL, 0x000fe20000209400ULL,
0x000001005e5a7824ULL, 0x008fe200078e00ffULL, 0x00000001a2a23812ULL, 0x000fc400078efcffULL,
0x000000e4e300720bULL, 0x004fe40003f7d000ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000009800ca7306ULL, 0x000eb00000205400ULL, 0x0000005c00cb7306ULL, 0x000fe20000209400ULL,
0x0000000199993812ULL, 0x010fce00078efcffULL, 0x0000005c00cc7306ULL, 0x000fe20000205400ULL,
0x000000cac900720bULL, 0x004fce0003f5d000ULL, 0x0000005c00877306ULL, 0x0005f0000020d400ULL,
0x0000005100ae7306ULL, 0x000fe20000009400ULL, 0x00000100515c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000005100b17306ULL, 0x000ff00000005400ULL,
0x0000005100807306ULL, 0x0005f0000000d400ULL, 0x0000005000d27306ULL, 0x000fe20000209400ULL,
0x0001000051517824ULL, 0x004fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005000d37306ULL, 0x000ff00000205400ULL, 0x0000005000857306ULL, 0x0005f0000020d400ULL,
0x0000009e009e7306ULL, 0x000ee2000020d400ULL, 0x0000010052507824ULL, 0x004fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000005900597306ULL, 0x000eb0000020d400ULL,
0x0000005d00c77306ULL, 0x000fe20000009400ULL, 0x000000019e9e4812ULL, 0x008fce00078efcffULL,
0x0000005d007a7306ULL, 0x000ee20000005400ULL, 0x0000000159591812ULL, 0x004fe400078efcffULL,
0x000000c8a100720bULL, 0x000fe40003f3d000ULL, 0x000000a25959723eULL, 0x000fc600000010ffULL,
0x0000005b00d97306ULL, 0x000ff00000209400ULL, 0x0000005b00da7306ULL, 0x000ea20000205400ULL,
0x0000007ac700720bULL, 0x008fe40003fdd000ULL, 0x0000000194941812ULL, 0x000fca00078efcffULL,
0x0000005a00db7306ULL, 0x000ff00000209400ULL, 0x0000005a00dc7306ULL, 0x000ee20000205400ULL,
0x000000dad900720bULL, 0x004fce0003f9d000ULL, 0x0000005b00937306ULL, 0x000530000020d400ULL,
0x0000005a008e7306ULL, 0x000a62000020d400ULL, 0x000001005f5b7824ULL, 0x004fe200078e00ffULL,
0x000000dcdb00720bULL, 0x008fc80003fbd000ULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x0000005f00c17306ULL, 0x000fe20000009400ULL, 0x000100005e5a7824ULL, 0x020fe200078e00ffULL,
0x0000000193934812ULL, 0x010fc800078efcffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000005f00bf7306ULL, 0x000ea20000005400ULL, 0x000000018e8e5812ULL, 0x002fce00078efcffULL,
0x0000005f00627306ULL, 0x0002f0000000d400ULL, 0x0000009800987306ULL, 0x000f22000020d400ULL,
0x000100005f5f7824ULL, 0x002fe200078e00ffULL, 0x000000bfc100720bULL, 0x004fc80003f9d000ULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000008c00c67306ULL, 0x000fee0000209400ULL,
0x0000000162624812ULL, 0x008fe200078efcffULL, 0x0000008c00c47306ULL, 0x000e620000205400ULL,
0x0000000198982812ULL, 0x010fce00078efcffULL, 0x0000005100d77306ULL, 0x000ff00000209400ULL,
0x0000005100d87306ULL, 0x000fe20000205400ULL, 0x000000c4c600720bULL, 0x002fce0003f5d000ULL,
0x0000005100827306ULL, 0x0003f0000020d400ULL, 0x0000005000cd7306ULL, 0x000fe20000209400ULL,
0x0000010053517824ULL, 0x002fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005000ce7306ULL, 0x000ff00000205400ULL, 0x0000005000837306ULL, 0x0003f0000020d400ULL,
0x0000005d008d7306ULL, 0x0004e2000000d400ULL, 0x0000010054507824ULL, 0x002fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000005e00c57306ULL, 0x000fe20000009400ULL,
0x000100005d5d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000005e00c37306ULL, 0x000e620000005400ULL, 0x000000018d8d6812ULL, 0x008fce00078efcffULL,
0x0000005e00637306ULL, 0x000eb0000000d400ULL, 0x0000005200b37306ULL, 0x000fe20000009400ULL,
0x000000c3c500720bULL, 0x002fce0003f3d000ULL, 0x0000005200b67306ULL, 0x000fec0000005400ULL,
0x0000000163631812ULL, 0x004fe400078efcffULL, 0x0000005200847306ULL, 0x0003f0000000d400ULL,
0x0000005300cf7306ULL, 0x000fe20000009400ULL, 0x0001000052527824ULL, 0x002fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000005300d07306ULL, 0x000ff00000005400ULL,
0x00000053007c7306ULL, 0x0003f0000000d400ULL, 0x0000005b00dd7306ULL, 0x000fe20000209400ULL,
0x0001000053537824ULL, 0x002fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005b00de7306ULL, 0x000ff00000205400ULL, 0x0000005b005e7306ULL, 0x000ff0000020d400ULL,
0x0000005a00e97306ULL, 0x000ff00000209400ULL, 0x0000005a00ea7306ULL, 0x000ff00000205400ULL,
0x0000005a008a7306ULL, 0x000ff0000020d400ULL, 0x0000005f005a7306ULL, 0x000ff00000209400ULL,
0x0000005f005b7306ULL, 0x000e700000205400ULL, 0x0000008b00c07306ULL, 0x000ff00000209400ULL,
0x0000008b00c27306ULL, 0x000ea20000205400ULL, 0x0000005b5a00720bULL, 0x002fc40003fbd000ULL,
0x000000a9a65a723eULL, 0x000fe400000010ffULL, 0x000000a7a55b723eULL, 0x000fc600000010ffULL,
0x0000005100bb7306ULL, 0x000ff00000209400ULL, 0x0000005100bc7306ULL, 0x000fe20000205400ULL,
0x000000c2c000720bULL, 0x004fe40003fdd000ULL, 0x0000991086c07816ULL, 0x000fca00000000ffULL,
0x00000051007b7306ULL, 0x0003f0000020d400ULL, 0x00000050009d7306ULL, 0x000fe20000209400ULL,
0x0000010055517824ULL, 0x002fca00078e00ffULL, 0x00000018ffc47819ULL, 0x000fe40000011451ULL,
0x0000005000a17306ULL, 0x000ff00000205400ULL, 0x00000050007a7306ULL, 0x0003f0000020d400ULL,
0x0000005d00e77306ULL, 0x000fe20000209400ULL, 0x0000a80035507811ULL, 0x002fce00078e20ffULL,
0x0000005d00e87306ULL, 0x000e700000205400ULL, 0x0000005d00917306ULL, 0x000eb0000020d400ULL,
0x0000005c00d47306ULL, 0x000fe20000209400ULL, 0x000000e8e700720bULL, 0x002fce0003f7d000ULL,
0x0000005c00d57306ULL, 0x000fec0000205400ULL, 0x0000000191913812ULL, 0x004fe400078efcffULL,
0x0000005c00887306ULL, 0x000fe2000020d400ULL, 0x000000eae900720bULL, 0x000fce0003f7d000ULL,
0x00000052005c7306ULL, 0x000fec0000209400ULL, 0x000000018a8a3812ULL, 0x000fe400078efcffULL,
0x00000052005d7306ULL, 0x000ff00000205400ULL, 0x0000005200817306ULL, 0x000ff0000020d400ULL,
0x00000053009b7306ULL, 0x000ff00000209400ULL, 0x00000053009c7306ULL, 0x000ff00000205400ULL,
0x0000005300797306ULL, 0x0003f0000020d400ULL, 0x0000005f00897306ULL, 0x000ea2000020d400ULL,
0x000000005050783bULL, 0x002e6e0000000200ULL, 0x0000008b008b7306ULL, 0x000ef0000020d400ULL,
0x0000006100b07306ULL, 0x000fe20000209400ULL, 0x0000000189895812ULL, 0x004fc400078efcffULL,
0x000000d3d200720bULL, 0x000fca0003fbd000ULL, 0x0000006100b47306ULL, 0x000ea20000205400ULL,
0x000000018b8b6812ULL, 0x008fce00078efcffULL, 0x0000006000b57306ULL, 0x000fe20000209400ULL,
0x0000000185855812ULL, 0x000fce00078efcffULL, 0x0000006000ac7306ULL, 0x000ee20000205400ULL,
0x000000b4b000720bULL, 0x004fe20003f9d000ULL, 0x0000010056b47824ULL, 0x000fca00078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000008c008c7306ULL, 0x000eb0000020d400ULL,
0x0000006100617306ULL, 0x000f22000020d400ULL, 0x000000acb500720bULL, 0x008fe20003fdd000ULL,
0x000000ffffac7224ULL, 0x000fc400078e00c0ULL, 0x0000010057b57824ULL, 0x000fc600078e00ffULL,
0x000000ffac00720cULL, 0x000fe20003f25270ULL, 0x0000007100b87306ULL, 0x000fe20000209400ULL,
0x000000018c8c2812ULL, 0x004fe400078efcffULL, 0x000000dedd00720bULL, 0x000fe40003f5d000ULL,
0x00000018ffb57819ULL, 0x000fe400000114b5ULL, 0x000000928c8c723eULL, 0x000fe200000010ffULL,
0x0000007100ad7306ULL, 0x000ea20000205400ULL, 0x0000000161614812ULL, 0x010fc400078efcffULL,
0x000000b1ae00720bULL, 0x000fe20003f9d000ULL, 0x0000007550509231ULL, 0x082fe400003400ffULL,
0x0000007552529231ULL, 0x000fe400003400ffULL, 0x0000007600ab7306ULL, 0x000fe20000209400ULL,
0x000000015e5e2812ULL, 0x000fe200078efcffULL, 0x0000007051519231ULL, 0x080fe200003400ffULL,
0x000000afb200720bULL, 0x000fe20003f5d000ULL, 0x0001000056b27824ULL, 0x000fe200078e00ffULL,
0x0000007053539231ULL, 0x000fe200003400ffULL, 0x0001000057af7824ULL, 0x000fc400078e00ffULL,
0x0000007600b77306ULL, 0x000e620000205400ULL, 0x000000adb800720bULL, 0x004fe40003fbd000ULL,
0x0000000180804812ULL, 0x000fe200078efcffULL, 0x0000005a500c723cULL, 0x040fe2000004180cULL,
0x000000cecd00720bULL, 0x000fe40003f9d000ULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x0000005400bd7306ULL, 0x000fe20000009400ULL, 0x000000017f7f2812ULL, 0x000fe400078efcffULL,
0x000000d5d400720bULL, 0x000fe20003f5d000ULL, 0x000000585010723cULL, 0x000fe20000041810ULL,
0x000000a39e5a723eULL, 0x000fc400000010ffULL, 0x0000009a985b723eULL, 0x000fe200000010ffULL,
0x0000005400be7306ULL, 0x000fe20000005400ULL, 0x000000b7ab00720bULL, 0x002fe40003f7d000ULL,
0x0000000183834812ULL, 0x000fe400078efcffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000005a5058723cULL, 0x000fe40000041840ULL, 0x0000005400747306ULL, 0x0003e2000000d400ULL,
0x0000000188882812ULL, 0x000fc400078efcffULL, 0x000000d0cf00720bULL, 0x000fe40003f5d000ULL,
0x000000638e40723eULL, 0x000fe400000010ffULL, 0x000000625e41723eULL, 0x000fe200000010ffULL,
0x0000006000607306ULL, 0x000ea2000020d400ULL, 0x0001000054547824ULL, 0x002fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000007100717306ULL, 0x000e62000020d400ULL,
0x000000017c7c2812ULL, 0x000fe400078efcffULL, 0x0000009c9b00720bULL, 0x000fca0003f5d000ULL,
0x00000055005f7306ULL, 0x000fe20000009400ULL, 0x0000000160606812ULL, 0x004fe400078efcffULL,
0x000000cccb00720bULL, 0x000fe40003fdd000ULL, 0x0000008a608a723eULL, 0x000fc600000010ffULL,
0x0000005500977306ULL, 0x000ea20000005400ULL, 0x0000000171715812ULL, 0x002fe400078efcffULL,
0x000000bcbb00720bULL, 0x000fe40003fbd000ULL, 0x0000000179792812ULL, 0x000fc600078efcffULL,
0x00000055006f7306ULL, 0x0003e2000000d400ULL, 0x0000000187876812ULL, 0x000fe400078efcffULL,
0x000000b6b300720bULL, 0x000fca0003fdd000ULL, 0x00000056008f7306ULL, 0x000fe20000009400ULL,
0x0001000055557824ULL, 0x002fe200078e00ffULL, 0x000000017b7b5812ULL, 0x000fcc00078efcffULL,
0x0000005600907306ULL, 0x000e620000005400ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x0000005d5c00720bULL, 0x000fe40003fdd000ULL, 0x0000008d935d723eULL, 0x000fe400000010ffULL,
0x000000918b8d723eULL, 0x000fe200000010ffULL, 0x00000056006d7306ULL, 0x000722000000d400ULL,
0x00000094995c723eULL, 0x000fe400000010ffULL, 0x00000089618b723eULL, 0x000fc400000010ffULL,
0x000000405060723cULL, 0x040fe60000041844ULL, 0x0000005400ac7306ULL, 0x000fe20000209400ULL,
0x00000018ff567819ULL, 0x008fe40000011455ULL, 0x000000a8ba55723eULL, 0x000fe400000010ffULL,
0x0000000181816812ULL, 0x000fe200078efcffULL, 0x0000005c504c723cULL, 0x000fe2000004184cULL,
0x000000975f00720bULL, 0x004fe20003fdd000ULL, 0x0000005400b07306ULL, 0x000fe20000205400ULL,
0x000000908f00720bULL, 0x002fc40003f5d000ULL, 0x000000848340723eULL, 0x000fe400000010ffULL,
0x0000007c7b41723eULL, 0x000fe200000010ffULL, 0x0000008c505c723cULL, 0x040fe40000041848ULL,
0x0000005400ab7306ULL, 0x0003e8000020d400ULL, 0x000000016f6f6812ULL, 0x000fe400078efcffULL,
0x0000007f8748723eULL, 0x000fe200000010ffULL, 0x0000008a5004723cULL, 0x000fe20000041804ULL,
0x0000006e00a07306ULL, 0x000fe20000209400ULL, 0x000000aab954723eULL, 0x002fc400000010ffULL,
0x000000016d6d2812ULL, 0x010fe400078efcffULL, 0x000000808849723eULL, 0x000fc600000010ffULL,
0x0000006e009f7306ULL, 0x000e700000205400ULL, 0x0000006800967306ULL, 0x000ff00000209400ULL,
0x0000006800957306ULL, 0x000ea20000205400ULL, 0x0000009fa000720bULL, 0x002fce0003f9d000ULL,
0x00000057007d7306ULL, 0x000ff00000009400ULL, 0x00000057007e7306ULL, 0x000fe20000005400ULL,
0x000000959600720bULL, 0x004fce0003fbd000ULL, 0x0000005700677306ULL, 0x000ff0000000d400ULL,
0x0000005600ae7306ULL, 0x000ff00000209400ULL, 0x0000005600a87306ULL, 0x000ff00000205400ULL,
0x0000005600a67306ULL, 0x0003f0000020d400ULL, 0x0000007600767306ULL, 0x000ea2000020d400ULL,
0x000000545054723cULL, 0x002fee0000041808ULL, 0x0000a80036087811ULL, 0x000fe200078e20ffULL,
0x0000006e006e7306ULL, 0x000e6a000020d400ULL, 0x000000000808783bULL, 0x000ee20000000200ULL,
0x0000000176763812ULL, 0x004fc400078efcffULL, 0x0000006800687306ULL, 0x000ea2000020d400ULL,
0x000000d8d700720bULL, 0x000fe40003f7d000ULL, 0x000000857644723eULL, 0x000fca00000010ffULL,
0x000000c400c37306ULL, 0x000fe20000209400ULL, 0x000000016e6e4812ULL, 0x002fe400078efcffULL,
0x000000a19d00720bULL, 0x000fc60003f9d000ULL, 0x0000000182823812ULL, 0x000fe400078efcffULL,
0x000000c400bf7306ULL, 0x000e620000205400ULL, 0x0000000168685812ULL, 0x004fe400078efcffULL,
0x000000bebd00720bULL, 0x000fe40003f7d000ULL, 0x000000827145723eULL, 0x000fe400000010ffULL,
0x000000796879723eULL, 0x000fe200000010ffULL, 0x000000c400867306ULL, 0x000ea2000020d400ULL,
0x000000017a7a4812ULL, 0x000fc400078efcffULL, 0x000000b0ac00720bULL, 0x000fe40003f9d000ULL,
0x000000bfc300720bULL, 0x002fc60003fbd000ULL, 0x0000006600777306ULL, 0x000fe20000209400ULL,
0x0000000174743812ULL, 0x000fe200078efcffULL, 0x0000007508089231ULL, 0x088fe400003400ffULL,
0x000000750a0a9231ULL, 0x000fc800003400ffULL, 0x00000001abab4812ULL, 0x000fe200078efcffULL,
0x0000006600787306ULL, 0x000e620000205400ULL, 0x0000007009099231ULL, 0x080fe400003400ffULL,
0x000000700b0b9231ULL, 0x000fe200003400ffULL, 0x0000000186865812ULL, 0x004fe400078efcffULL,
0x000000a8ae00720bULL, 0x000fe40003fbd000ULL, 0x0000006500727306ULL, 0x000fe40000209400ULL,
0x000000440844723cULL, 0x040fec000004180cULL, 0x0000006500737306ULL, 0x000ea20000205400ULL,
0x000000787700720bULL, 0x002fe20003f7d000ULL, 0x000000480848723cULL, 0x000fe20000041854ULL,
0x00000001a6a65812ULL, 0x000fc400078efcffULL, 0x000000747a0c723eULL, 0x000fe400000010ffULL,
0x0000006f860d723eULL, 0x000fe200000010ffULL, 0x000000b400a57306ULL, 0x000fe20000209400ULL,
0x000000816e78723eULL, 0x000fce00000010ffULL, 0x000000b4009e7306ULL, 0x000e620000205400ULL,
0x000000737200720bULL, 0x004fce0003fdd000ULL, 0x000000b500427306ULL, 0x000ff00000209400ULL,
0x000000b500437306ULL, 0x000ea20000205400ULL, 0x0000009ea500720bULL, 0x002fce0003f9d000ULL,
0x0000006600667306ULL, 0x000e70000020d400ULL, 0x0000006500657306ULL, 0x000ee2000020d400ULL,
0x000000434200720bULL, 0x004fe40003fbd000ULL, 0x000000400840723cULL, 0x000fea0000041810ULL,
0x000000b400b47306ULL, 0x000ea2000020d400ULL, 0x0000000166663812ULL, 0x002fc400078efcffULL,
0x0000007e7d00720bULL, 0x000fe20003f7d000ULL, 0x000000780810723cULL, 0x000fe80000041858ULL,
0x000000b500b57306ULL, 0x000e62000020d400ULL, 0x0000000165656812ULL, 0x008fce00078efcffULL,
0x0000006400697306ULL, 0x000fe20000209400ULL, 0x00000001b4b44812ULL, 0x004fe400078efcffULL,
0x0000000167673812ULL, 0x000fe400078efcffULL, 0x0000006db452723eULL, 0x000fc600000010ffULL,
0x00000064006a7306ULL, 0x000ea20000205400ULL, 0x00000001b5b55812ULL, 0x002fc800078efcffULL,
0x00000067b553723eULL, 0x000fc600000010ffULL, 0x0000003d006b7306ULL, 0x000ff00000209400ULL,
0x0000003d006c7306ULL, 0x000e620000205400ULL, 0x0000006a6900720bULL, 0x004fce0003fdd000ULL,
0x000000b2007f7306ULL, 0x000ff00000209400ULL, 0x000000b200507306ULL, 0x000ea20000205400ULL,
0x0000006c6b00720bULL, 0x002fce0003f9d000ULL, 0x000000af00517306ULL, 0x000ff00000209400ULL,
0x000000af000e7306ULL, 0x000e620000205400ULL, 0x000000507f00720bULL, 0x004fe40003f5d000ULL,
0x000000ab6650723eULL, 0x000fca00000010ffULL, 0x0000006400647306ULL, 0x000eb0000020d400ULL,
0x0000003d003d7306ULL, 0x000ee2000020d400ULL, 0x0000000e5100720bULL, 0x002fe40003fbd000ULL,
0x000000a66551723eULL, 0x000fe200000010ffULL, 0x0000000c080c723cULL, 0x000fe8000004184cULL,
0x000000b200b27306ULL, 0x000e62000020d400ULL, 0x0000000164646812ULL, 0x004fc600078efcffULL,
0x00000050084c723cULL, 0x000fe8000004185cULL, 0x000000af00af7306ULL, 0x000ea2000020d400ULL,
0x000000013d3d4812ULL, 0x008fc600078efcffULL, 0x000000520850723cULL, 0x000fe20000041860ULL,
0x00000001b2b22812ULL, 0x002fc800078efcffULL, 0x000000b26464723eULL, 0x000fe400000010ffULL,
0x00000001afaf5812ULL, 0x004fc800078efcffULL, 0x000000af3d65723eULL, 0x000fce00000010ffULL,
0x000000640808723cULL, 0x000fe20000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff047f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007844805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x3fa0000006067823ULL, 0x002fe200000100ffULL, 0x000000070000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008014047811ULL, 0x000fe200078e40ffULL,
0x00000100ff5a7424ULL, 0x000fe200078e00ffULL, 0x00000004ff597819ULL, 0x000fc40000011602ULL,
0x0000000403057217ULL, 0x000fe20007800000ULL, 0x00006200173d7a24ULL, 0x000fc800078e0204ULL,
0x0000000105057824ULL, 0x000fe400078e0a04ULL, 0x0000000120047824ULL, 0x100fe400078e023dULL,
0x0000000125077824ULL, 0x100fe200078e023dULL, 0x0000002005067807ULL, 0x000fe20000000000ULL,
0x0000000126557824ULL, 0x000fe400078e023dULL, 0x00005e0004047625ULL, 0x000fe200078e005aULL,
0x0000000616547217ULL, 0x000fc60007800000ULL, 0x00005e0007067625ULL, 0x000fe200078e005aULL,
0x0000002104567210ULL, 0x000fc60007f5e0ffULL, 0x0000000154587824ULL, 0x000fe200078e0a16ULL,
0x0000002106067210ULL, 0x000fe20007f9e0ffULL, 0x00005e0055547625ULL, 0x000fc600078e005aULL,
0x000000582200720cULL, 0x080fe20003f66070ULL, 0x0000000127047824ULL, 0x000fe200078e023dULL,
0x0000002154547210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff577224ULL, 0x000fe200010e0605ULL,
0x000000585900720cULL, 0x000fe20003f46070ULL, 0x00005e0004047625ULL, 0x000fc800078e005aULL,
0x000000ffff077224ULL, 0x000fe200020e0607ULL, 0x000000582300720cULL, 0x080fe20003f86070ULL,
0x000000ffff557224ULL, 0x000fe200028e0655ULL, 0x000000582400720cULL, 0x000fe40003fa6070ULL,
0x0000002104047210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000056377faeULL, 0x0003e4000d101c46ULL, 0x000000ffff057224ULL, 0x000fe400030e0605ULL,
0x0000000006387faeULL, 0x0003e8000d901c46ULL, 0x0000000054397faeULL, 0x0003e8000e101c46ULL,
0x00000000043a7faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x0106a800ff047f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc4000784483fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e0005ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000784483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0106b400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc4000784483fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002dff04723eULL, 0x000fe400000010ffULL,
0x00000002ff3e7819ULL, 0x000fe40000011602ULL, 0x0000541004047816ULL, 0x000fe20000000004ULL,
0x000150527f007947ULL, 0x000fea000b800000ULL, 0x00001f3e043e7589ULL, 0x0002a400000e0000ULL,
0x000150b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2e04ae7589ULL, 0x00072400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0004ULL,
0x00008f1000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fe400078e002fULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fc400078e00ffULL,
0x00015ee000007944ULL, 0x01efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0004ULL, 0x00008f8000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fc400078e0030ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00015e7000007944ULL, 0x01efea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003b5c783bULL, 0x000f680000004200ULL,
0x000000003c54783bULL, 0x000e680000004200ULL, 0x000000001a04783bULL, 0x00ae680000004200ULL,
0x000000001b58783bULL, 0x004ea20000004200ULL, 0x0000005c00f37306ULL, 0x020fe20000009400ULL,
0x000001005c707824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fe2000001145cULL,
0x000001005d7d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001145dULL,
0x00000100577e7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fc40000011470ULL,
0x0000005c00957306ULL, 0x000ee20000005400ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x00000018ff9e7819ULL, 0x000fe4000001145fULL, 0x00000018ffa17819ULL, 0x000fe4000001145eULL,
0x00000018ff847819ULL, 0x000fe20000011456ULL, 0x000000bd00707306ULL, 0x000fe20000209400ULL,
0x00000018ff607819ULL, 0x000fe40000011454ULL, 0x00000018ff807819ULL, 0x000fc40000011457ULL,
0x00000018ff787819ULL, 0x002fe40000011404ULL, 0x00000018ff617819ULL, 0x000fe20000011455ULL,
0x000000bd00767306ULL, 0x000e620000205400ULL, 0x00000095f300720bULL, 0x008fe40003f7d000ULL,
0x00000018ff727819ULL, 0x000fe40000011405ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x00000018ff6f7819ULL, 0x000fe20000011406ULL, 0x0000005c00b87306ULL, 0x000762000000d400ULL,
0x00000018ff697819ULL, 0x000fc40000011407ULL, 0x00000018ff677819ULL, 0x004fe40000011458ULL,
0x00000018ff667819ULL, 0x000fe40000011459ULL, 0x00000018ff657819ULL, 0x000fe2000001145aULL,
0x0000007d00817306ULL, 0x000fe20000209400ULL, 0x000100005c5c7824ULL, 0x008fe200078e00ffULL,
0x000000767000720bULL, 0x002fe40003f5d000ULL, 0x00000018ff647819ULL, 0x000fe4000001145bULL,
0x00000018ff5c7819ULL, 0x000fc4000001145cULL, 0x0000007d009c7306ULL, 0x000e620000205400ULL,
0x00000001b8b83812ULL, 0x020fce00078efcffULL, 0x0000005d00f27306ULL, 0x000ff00000009400ULL,
0x0000005d00967306ULL, 0x000ea20000005400ULL, 0x0000009c8100720bULL, 0x002fce0003f7d000ULL,
0x0000005d00b67306ULL, 0x0002f0000000d400ULL, 0x000000b3006c7306ULL, 0x000fe20000209400ULL,
0x000100005d5d7824ULL, 0x002fe200078e00ffULL, 0x00000096f200720bULL, 0x004fc80003fbd000ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x000000b300a07306ULL, 0x000e6e0000205400ULL,
0x00000001b6b65812ULL, 0x008fe200078efcffULL, 0x000000bd00bd7306ULL, 0x000eb0000020d400ULL,
0x0000005c008c7306ULL, 0x000fe20000209400ULL, 0x000000a06c00720bULL, 0x002fce0003f9d000ULL,
0x0000005c009f7306ULL, 0x000e620000205400ULL, 0x00000001bdbd2812ULL, 0x004fce00078efcffULL,
0x0000007d00bc7306ULL, 0x0004f0000020d400ULL, 0x0000005e00e07306ULL, 0x000fe20000009400ULL,
0x0000009f8c00720bULL, 0x002fe20003f5d000ULL, 0x00000100567d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x0000005e007b7306ULL, 0x000e620000005400ULL,
0x00000001bcbc3812ULL, 0x008fce00078efcffULL, 0x0000005c00b77306ULL, 0x0004f0000020d400ULL,
0x0000005d00f07306ULL, 0x000fe20000209400ULL, 0x000001005e5c7824ULL, 0x004fe200078e00ffULL,
0x0000007be000720bULL, 0x002fc80003f7d000ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000005d00f17306ULL, 0x000e620000205400ULL, 0x00000001b7b72812ULL, 0x008fce00078efcffULL,
0x0000005d00ad7306ULL, 0x0004f0000020d400ULL, 0x0000005f00dd7306ULL, 0x000fe20000009400ULL,
0x000001005f5d7824ULL, 0x004fe200078e00ffULL, 0x000000f1f000720bULL, 0x002fc80003f5d000ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000005f00997306ULL, 0x000e6e0000005400ULL,
0x00000001adad2812ULL, 0x008fe200078efcffULL, 0x0000005f00a27306ULL, 0x0004f0000000d400ULL,
0x000000b300b37306ULL, 0x000f62000020d400ULL, 0x000100005f5f7824ULL, 0x004fe200078e00ffULL,
0x00000099dd00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000005c009d7306ULL, 0x000fee0000209400ULL, 0x00000001a2a22812ULL, 0x008fe200078efcffULL,
0x0000005c00ef7306ULL, 0x000e620000205400ULL, 0x00000001b3b34812ULL, 0x020fce00078efcffULL,
0x0000005e00a97306ULL, 0x0004f0000000d400ULL, 0x0000005d00e77306ULL, 0x000fe20000209400ULL,
0x000000ef9d00720bULL, 0x002fe20003f9d000ULL, 0x000100005e5e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005d00e87306ULL, 0x000e620000205400ULL,
0x00000001a9a93812ULL, 0x008fce00078efcffULL, 0x0000005f00eb7306ULL, 0x000ff00000209400ULL,
0x0000005f00ec7306ULL, 0x000ea20000205400ULL, 0x000000e8e700720bULL, 0x002fce0003fbd000ULL,
0x0000005c00ac7306ULL, 0x0002f0000020d400ULL, 0x0000003f008b7306ULL, 0x000fe20000209400ULL,
0x00000100545c7824ULL, 0x002fe200078e00ffULL, 0x000000eceb00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000003f00687306ULL, 0x000e620000205400ULL,
0x00000001acac4812ULL, 0x008fce00078efcffULL, 0x000000a100de7306ULL, 0x000ff00000209400ULL,
0x000000a100df7306ULL, 0x000ea20000205400ULL, 0x000000688b00720bULL, 0x002fce0003fdd000ULL,
0x0000005d00a37306ULL, 0x0002f0000020d400ULL, 0x0000005f005f7306ULL, 0x000f62000020d400ULL,
0x00000100555d7824ULL, 0x002fe200078e00ffULL, 0x000000dfde00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000005500d97306ULL, 0x000fe20000009400ULL,
0x00000001a3a35812ULL, 0x008fce00078efcffULL, 0x0000005500da7306ULL, 0x000e620000005400ULL,
0x000000015f5f3812ULL, 0x020fce00078efcffULL, 0x0000005600c77306ULL, 0x000ff00000009400ULL,
0x0000005600757306ULL, 0x000fe20000005400ULL, 0x000000dad900720bULL, 0x002fce0003f7d000ULL,
0x0000005600887306ULL, 0x0003f0000000d400ULL, 0x0000009e009a7306ULL, 0x000fe20000209400ULL,
0x0001000056567824ULL, 0x002fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000009e00dc7306ULL, 0x000e700000205400ULL, 0x0000003f003f7306ULL, 0x000eb0000020d400ULL,
0x000000a100a17306ULL, 0x000ee2000020d400ULL, 0x000000dc9a00720bULL, 0x002fce0003fbd000ULL,
0x0000005700c37306ULL, 0x000fe20000009400ULL, 0x000000013f3f6812ULL, 0x004fc800078efcffULL,
0x000000ad3f3f723eULL, 0x000fc600000010ffULL, 0x0000005700bf7306ULL, 0x000fe20000005400ULL,
0x00000001a1a14812ULL, 0x008fce00078efcffULL, 0x0000005700857306ULL, 0x0003f0000000d400ULL,
0x0000005e00e97306ULL, 0x000fe20000209400ULL, 0x0001000057577824ULL, 0x002fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000005e00ea7306ULL, 0x000e700000205400ULL,
0x0000005d00e17306ULL, 0x000ff00000209400ULL, 0x0000005d00e27306ULL, 0x000ea20000205400ULL,
0x000000eae900720bULL, 0x002fce0003fdd000ULL, 0x0000005600ce7306ULL, 0x000ff00000209400ULL,
0x0000005600cf7306ULL, 0x000fe20000205400ULL, 0x000000e2e100720bULL, 0x004fce0003f9d000ULL,
0x00000056008e7306ULL, 0x0003f0000020d400ULL, 0x0000000400c07306ULL, 0x000fe20000009400ULL,
0x0000010004567824ULL, 0x002fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000000400917306ULL, 0x000ff00000005400ULL, 0x00000004007f7306ULL, 0x0003f0000000d400ULL,
0x0000005c00ed7306ULL, 0x000fe20000209400ULL, 0x0001000004047824ULL, 0x002fca00078e00ffULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x0000005c00ee7306ULL, 0x000e700000205400ULL,
0x0000005500987306ULL, 0x0004f0000000d400ULL, 0x0000009e009e7306ULL, 0x000f62000020d400ULL,
0x0001000055557824ULL, 0x004fe200078e00ffULL, 0x000000eeed00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff977819ULL, 0x000fe40000011455ULL, 0x0000006000d87306ULL, 0x000fe20000209400ULL,
0x0000000198983812ULL, 0x008fce00078efcffULL, 0x0000006000d77306ULL, 0x000e620000205400ULL,
0x000000019e9e5812ULL, 0x020fce00078efcffULL, 0x0000007d00e57306ULL, 0x000ff00000209400ULL,
0x0000007d00e67306ULL, 0x000ea20000205400ULL, 0x000000d7d800720bULL, 0x002fce0003fbd000ULL,
0x0000005400db7306ULL, 0x000ff00000009400ULL, 0x00000054007c7306ULL, 0x000fe20000005400ULL,
0x000000e6e500720bULL, 0x004fce0003f7d000ULL, 0x00000054009b7306ULL, 0x0003f0000000d400ULL,
0x0000005e00a47306ULL, 0x0004e2000020d400ULL, 0x0001000054547824ULL, 0x002fce00078e00ffULL,
0x0000005700d47306ULL, 0x000fe20000209400ULL, 0x00000018ff5e7819ULL, 0x004fce0000011454ULL,
0x0000005700d57306ULL, 0x000fe20000205400ULL, 0x00000001a4a46812ULL, 0x008fe400078efcffULL,
0x0000007cdb00720bULL, 0x000fca0003fdd000ULL, 0x0000005700897306ULL, 0x0003f0000020d400ULL,
0x0000000500c67306ULL, 0x000fe20000009400ULL, 0x0000010005577824ULL, 0x002fe200078e00ffULL,
0x000000019b9b6812ULL, 0x000fc800078efcffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000000500c27306ULL, 0x000ff00000005400ULL, 0x0000000500777306ULL, 0x0003f0000000d400ULL,
0x0000000400ca7306ULL, 0x000fe20000209400ULL, 0x0001000005057824ULL, 0x002fca00078e00ffULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000000400cb7306ULL, 0x000ff00000205400ULL,
0x0000000400877306ULL, 0x0003f0000020d400ULL, 0x0000005d005d7306ULL, 0x000ea2000020d400ULL,
0x0000010006047824ULL, 0x002fca00078e00ffULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x0000005c005c7306ULL, 0x000e70000020d400ULL, 0x0000009700557306ULL, 0x000fe20000209400ULL,
0x000000015d5d4812ULL, 0x004fc800078efcffULL, 0x000000985d5d723eULL, 0x000fc600000010ffULL,
0x0000009700e47306ULL, 0x000ea20000205400ULL, 0x000000015c5c2812ULL, 0x002fc800078efcffULL,
0x0000009b5c5c723eULL, 0x000fc600000010ffULL, 0x0000005e00547306ULL, 0x000ff00000209400ULL,
0x0000005e00e37306ULL, 0x000e620000205400ULL, 0x000000e45500720bULL, 0x004fce0003f9d000ULL,
0x0000006000607306ULL, 0x000eb0000020d400ULL, 0x0000007d00927306ULL, 0x000ee2000020d400ULL,
0x000000e35400720bULL, 0x002fe40003f5d000ULL, 0x0000a8001c547811ULL, 0x000fca00078e20ffULL,
0x0000007e00cc7306ULL, 0x000fe20000209400ULL, 0x0000000160605812ULL, 0x004fce00078efcffULL,
0x0000007e00cd7306ULL, 0x000e620000205400ULL, 0x0000000192923812ULL, 0x008fe400078efcffULL,
0x000000cfce00720bULL, 0x000fca0003f7d000ULL, 0x0000000500c87306ULL, 0x000ff00000209400ULL,
0x0000000500c97306ULL, 0x000fe20000205400ULL, 0x000000cdcc00720bULL, 0x002fe40003fbd000ULL,
0x000000018e8e3812ULL, 0x000fc400078efcffULL, 0x000000c2c600720bULL, 0x000fc60003f7d000ULL,
0x0000000500827306ULL, 0x0003f0000020d400ULL, 0x0000000400af7306ULL, 0x000fe20000209400ULL,
0x0000010007057824ULL, 0x002fe200078e00ffULL, 0x0000000177773812ULL, 0x000fc800078efcffULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000000400b07306ULL, 0x000ff00000205400ULL,
0x0000000400837306ULL, 0x0003f0000020d400ULL, 0x0000007e008d7306ULL, 0x000ea2000020d400ULL,
0x0000010058047824ULL, 0x002fca00078e00ffULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x0000000600b97306ULL, 0x000ff00000009400ULL, 0x0000000600ba7306ULL, 0x000fe20000005400ULL,
0x000000018d8d5812ULL, 0x004fc400078efcffULL, 0x000000d5d400720bULL, 0x000fca0003fbd000ULL,
0x0000000600717306ULL, 0x0003f0000000d400ULL, 0x0000000700bb7306ULL, 0x000fe20000009400ULL,
0x0001000006067824ULL, 0x002fe200078e00ffULL, 0x0000000189895812ULL, 0x000fc800078efcffULL,
0x00000018ff067819ULL, 0x000fe40000011406ULL, 0x0000000700d67306ULL, 0x000ff00000005400ULL,
0x00000007007e7306ULL, 0x0003f0000000d400ULL, 0x0000009700977306ULL, 0x000ea2000020d400ULL,
0x0001000007077824ULL, 0x002fca00078e00ffULL, 0x00000018ff077819ULL, 0x000fe40000011407ULL,
0x0000005e005e7306ULL, 0x000e70000020d400ULL, 0x0000000500a57306ULL, 0x000fe20000209400ULL,
0x0000000197974812ULL, 0x004fc400078efcffULL, 0x000000bfc300720bULL, 0x000fe20003f9d000ULL,
0x000100005ac37824ULL, 0x000fc800078e00ffULL, 0x0000000500a67306ULL, 0x000fe20000205400ULL,
0x000000015e5e2812ULL, 0x002fe400078efcffULL, 0x00000075c700720bULL, 0x000fe40003f5d000ULL,
0x0000005e6060723eULL, 0x000fe400000010ffULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x00000005007d7306ULL, 0x0003e2000020d400ULL, 0x0000000185854812ULL, 0x000fe400078efcffULL,
0x00000091c000720bULL, 0x000fca0003f9d000ULL, 0x0000000400997306ULL, 0x000fe20000209400ULL,
0x0000010059057824ULL, 0x002fe200078e00ffULL, 0x0000000188882812ULL, 0x000fc800078efcffULL,
0x00000018ffd77819ULL, 0x000fe40000011405ULL, 0x00000004009a7306ULL, 0x000fe20000205400ULL,
0x000000017f7f4812ULL, 0x000fe400078efcffULL, 0x000000cbca00720bULL, 0x000fe40003f9d000ULL,
0x000000889292723eULL, 0x000fc600000010ffULL, 0x00000004007c7306ULL, 0x0003f0000020d400ULL,
0x00000061008f7306ULL, 0x000fe20000209400ULL, 0x0000a8001d047811ULL, 0x002fe400078e20ffULL,
0x0000000187874812ULL, 0x000fca00078efcffULL, 0x0000006100907306ULL, 0x000e700000205400ULL,
0x0000005600d07306ULL, 0x000ff00000209400ULL, 0x0000005600d17306ULL, 0x000ea20000205400ULL,
0x000000908f00720bULL, 0x002fce0003fdd000ULL, 0x00000056008a7306ULL, 0x000e70000020d400ULL,
0x0000005700d27306ULL, 0x000fe20000209400ULL, 0x000000d1d000720bULL, 0x004fce0003fbd000ULL,
0x0000005700d37306ULL, 0x000fec0000205400ULL, 0x000000018a8a5812ULL, 0x002fe400078efcffULL,
0x0000005700867306ULL, 0x0003e4000020d400ULL, 0x0000007f8a8a723eULL, 0x000fcc00000010ffULL,
0x00000006009f7306ULL, 0x000fe20000209400ULL, 0x000000005454783bULL, 0x002e6e0000000200ULL,
0x0000000600a07306ULL, 0x000ff00000205400ULL, 0x0000000600817306ULL, 0x000ff0000020d400ULL,
0x00000007009c7306ULL, 0x000ff00000209400ULL, 0x00000007009d7306ULL, 0x000ff00000205400ULL,
0x00000007007b7306ULL, 0x0005e2000020d400ULL, 0x0000003e54549231ULL, 0x002fc400003400ffULL,
0x0000003e56569231ULL, 0x000fe400003400ffULL, 0x000000ae55559231ULL, 0x090fe400003400ffULL,
0x000000ae57579231ULL, 0x000fe200003400ffULL, 0x0000006100617306ULL, 0x000e62000020d400ULL,
0x000000000404783bULL, 0x004eae0000000200ULL, 0x0000008000c17306ULL, 0x000ff00000209400ULL,
0x0000008000be7306ULL, 0x000ee20000205400ULL, 0x0000000161616812ULL, 0x002fc800078efcffULL,
0x000000976161723eULL, 0x000fc600000010ffULL, 0x0000008400c57306ULL, 0x000ff00000209400ULL,
0x0000008400c47306ULL, 0x000e620000205400ULL, 0x000000bec100720bULL, 0x008fe20003f5d000ULL,
0x000100005bbe7824ULL, 0x000fca00078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe200000114beULL,
0x0000007200ab7306ULL, 0x000fe20000209400ULL, 0x0000003e04049231ULL, 0x084fe400003400ffULL,
0x0000003e06069231ULL, 0x000fe200003400ffULL, 0x000000b7b33e723eULL, 0x000fe200000010ffULL,
0x000000ae05059231ULL, 0x080fe400003400ffULL, 0x000000ae07079231ULL, 0x000fe200003400ffULL,
0x0000007200aa7306ULL, 0x000ea20000205400ULL, 0x000000c4c500720bULL, 0x002fe20003fdd000ULL,
0x000001005ac47824ULL, 0x000fe200078e00ffULL, 0x000000d6bb00720bULL, 0x000fe20003f3d000ULL,
0x0000003e5444723cULL, 0x000fe20000041844ULL, 0x000001005bc57824ULL, 0x000fc400078e00ffULL,
0x00000018ffc47819ULL, 0x000fe200000114c4ULL, 0x0000008000807306ULL, 0x000e64000020d400ULL,
0x00000018ffc57819ULL, 0x000fcc00000114c5ULL, 0x0000008400847306ULL, 0x000ee2000020d400ULL,
0x000000aaab00720bULL, 0x004fe40003f7d000ULL, 0x000000017e7e1812ULL, 0x000fe400078efcffULL,
0x0000009d9c00720bULL, 0x000fc60003f3d000ULL, 0x0000007200727306ULL, 0x000ea2000020d400ULL,
0x0000000180802812ULL, 0x002fe400078efcffULL, 0x000000d3d200720bULL, 0x000fca0003f5d000ULL,
0x0000007800b57306ULL, 0x000fe20000209400ULL, 0x0000000184846812ULL, 0x008fe400078efcffULL,
0x000000bab900720bULL, 0x000fe40003fdd000ULL, 0x000000017b7b1812ULL, 0x000fe400078efcffULL,
0x0000008e8484723eULL, 0x000fe200000010ffULL, 0x0000007800b47306ULL, 0x000e620000205400ULL,
0x0000000172723812ULL, 0x004fe400078efcffULL, 0x000000a6a500720bULL, 0x000fc40003f7d000ULL,
0x0000000186862812ULL, 0x000fe400078efcffULL, 0x000000c9c800720bULL, 0x000fe20003f5d000ULL,
0x0000005800b17306ULL, 0x000fe20000009400ULL, 0x0000000171716812ULL, 0x000fce00078efcffULL,
0x0000005800b27306ULL, 0x000ea20000005400ULL, 0x000000b4b500720bULL, 0x002fe40003fbd000ULL,
0x000000017d7d3812ULL, 0x000fe400078efcffULL, 0x0000000182822812ULL, 0x000fc600078efcffULL,
0x0000007800787306ULL, 0x000e70000020d400ULL, 0x0000005800767306ULL, 0x000722000000d400ULL,
0x000000b2b100720bULL, 0x004fce0003f9d000ULL, 0x0000006f00937306ULL, 0x000fe20000209400ULL,
0x0001000058587824ULL, 0x008fe200078e00ffULL, 0x0000000178785812ULL, 0x002fe400078efcffULL,
0x000000b0af00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000006f00947306ULL, 0x000e620000205400ULL, 0x0000000176764812ULL, 0x010fce00078efcffULL,
0x0000006900627306ULL, 0x000fe20000209400ULL, 0x0000000183835812ULL, 0x000fe400078efcffULL,
0x000000a09f00720bULL, 0x000fca0003fbd000ULL, 0x0000006900637306ULL, 0x000ea20000205400ULL,
0x000000949300720bULL, 0x002fe40003fdd000ULL, 0x000000858d93723eULL, 0x000fe400000010ffULL,
0x000000898085723eULL, 0x000fc600000010ffULL, 0x0000005900a77306ULL, 0x000fe20000009400ULL,
0x0000000181815812ULL, 0x000fe200078efcffULL, 0x000000925450723cULL, 0x040fec0000041850ULL,
0x0000005900a87306ULL, 0x000e620000005400ULL, 0x000000636200720bULL, 0x004fe40003f7d000ULL,
0x000000605460723cULL, 0x000fea000004184cULL, 0x0000005900707306ULL, 0x0004f0000000d400ULL,
0x0000005a00957306ULL, 0x000fe20000009400ULL, 0x0001000059597824ULL, 0x004fe200078e00ffULL,
0x000000a8a700720bULL, 0x002fcc0003f5d000ULL, 0x0000005a00967306ULL, 0x000e6e0000005400ULL,
0x0000000170702812ULL, 0x008fe200078efcffULL, 0x0000005a006c7306ULL, 0x0004f0000000d400ULL,
0x0000005800bf7306ULL, 0x000fe20000209400ULL, 0x00000018ff5a7819ULL, 0x004fc40000011459ULL,
0x000000b6bc59723eULL, 0x000fe400000010ffULL, 0x000000969500720bULL, 0x002fc60003fbd000ULL,
0x0000005800c17306ULL, 0x000e700000205400ULL, 0x0000005800917306ULL, 0x0005e4000020d400ULL,
0x000000016c6c5812ULL, 0x008fcc00078efcffULL, 0x0000006f006f7306ULL, 0x000ee2000020d400ULL,
0x000000b8bd58723eULL, 0x004fe400000010ffULL, 0x000000c1bf00720bULL, 0x002fca0003f9d000ULL,
0x0000006900697306ULL, 0x000e62000020d400ULL, 0x000000585448723cULL, 0x000fee0000041848ULL,
0x000000d7008f7306ULL, 0x000fe20000209400ULL, 0x000000016f6f6812ULL, 0x008fe400078efcffULL,
0x0000009a9900720bULL, 0x000fc40003fdd000ULL, 0x000000a9ac58723eULL, 0x000fe400000010ffULL,
0x000000a2a359723eULL, 0x000fe200000010ffULL, 0x000000d700907306ULL, 0x000ea20000205400ULL,
0x0000000169693812ULL, 0x002fe400078efcffULL, 0x0000000191914812ULL, 0x000fe400078efcffULL,
0x0000007b697b723eULL, 0x000fe200000010ffULL, 0x000000585440723cULL, 0x000fe40000041840ULL,
0x0000005b008b7306ULL, 0x000fe20000009400ULL, 0x000000017c7c6812ULL, 0x000fc800078efcffULL,
0x000000767c4c723eULL, 0x000fc600000010ffULL, 0x0000005b008c7306ULL, 0x000e620000005400ULL,
0x000000908f00720bULL, 0x004fce0003f7d000ULL, 0x000000c400ad7306ULL, 0x000ff00000209400ULL,
0x000000c4003e7306ULL, 0x000ea20000205400ULL, 0x0000008c8b00720bULL, 0x002fe40003f3d000ULL,
0x00000077868b723eULL, 0x000fca00000010ffULL, 0x0000006600737306ULL, 0x000ff00000209400ULL,
0x0000006600747306ULL, 0x000e620000205400ULL, 0x0000003ead00720bULL, 0x004fce0003f9d000ULL,
0x000000d700757306ULL, 0x000eb0000020d400ULL, 0x0000006700797306ULL, 0x000fe20000209400ULL,
0x000000747300720bULL, 0x002fce0003f5d000ULL, 0x00000067007a7306ULL, 0x000e620000205400ULL,
0x0000000175753812ULL, 0x004fc800078efcffULL, 0x00000070754d723eULL, 0x000fc600000010ffULL,
0x0000005a00b97306ULL, 0x000ff00000209400ULL, 0x0000005a00ba7306ULL, 0x000ea20000205400ULL,
0x0000007a7900720bULL, 0x002fe40003fdd000ULL, 0x000000816f7a723eULL, 0x000fca00000010ffULL,
0x0000005b00687306ULL, 0x0002f0000000d400ULL, 0x0000005a00ae7306ULL, 0x000962000020d400ULL,
0x0000005f9e5b723eULL, 0x002fe400000010ffULL, 0x0000005c545c723cULL, 0x000fe2000004180cULL,
0x000000bab900720bULL, 0x004fc80003f7d000ULL, 0x000000c400c47306ULL, 0x000e62000020d400ULL,
0x000000a4a15a723eULL, 0x010fe400000010ffULL, 0x00000087780c723eULL, 0x000fe400000010ffULL,
0x00000082720d723eULL, 0x000fe400000010ffULL, 0x0000000168681812ULL, 0x008fe200078efcffULL,
0x000000c3003f7306ULL, 0x000fe20000209400ULL, 0x0000005a5458723cULL, 0x000fe20000041810ULL,
0x00000001aeae3812ULL, 0x020fcc00078efcffULL, 0x000000c3004e7306ULL, 0x000ea20000205400ULL,
0x000000845454723cULL, 0x000fe20000041808ULL, 0x00000001c4c44812ULL, 0x002fe400078efcffULL,
0x000000718310723eULL, 0x000fe400000010ffULL, 0x0000007e7d11723eULL, 0x000fe400000010ffULL,
0x0000006600667306ULL, 0x000e62000020d400ULL, 0x0000008a0408723cULL, 0x040fee0000041848ULL,
0x0000006700677306ULL, 0x000ee2000020d400ULL, 0x0000004e3f00720bULL, 0x004fe20003f9d000ULL,
0x0000000c040c723cULL, 0x040fec0000041844ULL, 0x000000c500987306ULL, 0x000fe20000209400ULL,
0x0000000166662812ULL, 0x002fe200078efcffULL, 0x000000100410723cULL, 0x000fe20000041840ULL,
0x0000006cc444723eULL, 0x000fc400000010ffULL, 0x000000ae6649723eULL, 0x000fc600000010ffULL,
0x000000c500947306ULL, 0x000e620000205400ULL, 0x0000000167676812ULL, 0x008fe200078efcffULL,
0x0000007a0440723cULL, 0x040fec0000041858ULL, 0x00000065006e7306ULL, 0x000fe40000209400ULL,
0x0000004c044c723cULL, 0x000fec000004185cULL, 0x00000065006d7306ULL, 0x000ea20000205400ULL,
0x000000949800720bULL, 0x002fce0003f5d000ULL, 0x00000064006a7306ULL, 0x000ff00000209400ULL,
0x00000064006b7306ULL, 0x000e620000205400ULL, 0x0000006d6e00720bULL, 0x004fce0003fdd000ULL,
0x000000be00487306ULL, 0x000ff00000209400ULL, 0x000000be003e7306ULL, 0x000ea20000205400ULL,
0x0000006b6a00720bULL, 0x002fce0003f7d000ULL, 0x000000c500c57306ULL, 0x000e70000020d400ULL,
0x0000006500657306ULL, 0x000ee2000020d400ULL, 0x0000003e4800720bULL, 0x004fe40003fbd000ULL,
0x000000916748723eULL, 0x000fca00000010ffULL, 0x0000006400647306ULL, 0x000ea2000020d400ULL,
0x00000001c5c52812ULL, 0x002fe200078efcffULL, 0x000000480448723cULL, 0x000fe60000041860ULL,
0x00000068c545723eULL, 0x000fc600000010ffULL, 0x000000c300c37306ULL, 0x000e62000020d400ULL,
0x0000000165656812ULL, 0x008fc600078efcffULL, 0x000000440444723cULL, 0x000fe80000041850ULL,
0x000000be003f7306ULL, 0x000ee2000020d400ULL, 0x0000000164643812ULL, 0x004fe400078efcffULL,
0x00000001c3c34812ULL, 0x002fc800078efcffULL, 0x000000c3653e723eULL, 0x000fe400000010ffULL,
0x000000013f3f5812ULL, 0x008fc800078efcffULL, 0x0000003f643f723eULL, 0x000fce00000010ffULL,
0x0000003e0404723cULL, 0x000fe20000041854ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff3e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000080143e7811ULL, 0x002fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000003e0300720cULL, 0x000fe20003f24070ULL,
0x000000ffff3e7224ULL, 0x000fd800078e003fULL, 0x00009be000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff3f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe4000782483eULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff3f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x002fe4000782483eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff3f7424ULL, 0x000fc800078e00ffULL,
0x0000003f00507305ULL, 0x0002a4000021f000ULL, 0x3fa000003f3f7823ULL, 0x002fe200000100ffULL,
0x000000500000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff507984ULL, 0x000e640000000800ULL,
0x8000000050ff7812ULL, 0x002fc4000782483eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000a0143e7811ULL, 0x000fe200078e40ffULL, 0x00000100ff587424ULL, 0x000fe200078e00ffULL,
0x00000004ff577819ULL, 0x000fe40000011602ULL, 0x0000003e033f7217ULL, 0x000fe20007800000ULL,
0x0000620017527a24ULL, 0x000fc800078e023eULL, 0x000000013f3f7824ULL, 0x000fe400078e0a3eULL,
0x00000001203e7824ULL, 0x100fe400078e0252ULL, 0x0000000125517824ULL, 0x000fe200078e0252ULL,
0x000000203f507807ULL, 0x000fe20000000000ULL, 0x00005e003e3e7625ULL, 0x000fc600078e0058ULL,
0x0000005016537217ULL, 0x000fe20007800000ULL, 0x00005e0051507625ULL, 0x000fe200078e0058ULL,
0x000000213e547210ULL, 0x000fc60007f3e0ffULL, 0x0000000153567824ULL, 0x000fe200078e0a16ULL,
0x0000002150507210ULL, 0x000fe20007f7e0ffULL, 0x00000001263e7824ULL, 0x100fe400078e0252ULL,
0x0000000127527824ULL, 0x000fe200078e0252ULL, 0x000000565700720cULL, 0x080fe20003f46070ULL,
0x000000ffff557224ULL, 0x000fe200008e063fULL, 0x000000562200720cULL, 0x000fe20003f26070ULL,
0x00005e003e3e7625ULL, 0x000fe200078e0058ULL, 0x000000562400720cULL, 0x000fc60003f86070ULL,
0x00005e0052527625ULL, 0x000fe200078e0058ULL, 0x000000213e3e7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff517224ULL, 0x000fe200018e0651ULL, 0x000000562300720cULL, 0x000fe20003f66070ULL,
0x000000ffff3f7224ULL, 0x000fe200028e063fULL, 0x0000002152527210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000054287faeULL, 0x0003e8000d101c46ULL,
0x000000ffff537224ULL, 0x000fe200030e0653ULL, 0x0000000050297faeULL, 0x0003ea000c901c46ULL,
0x000000003e2a7faeULL, 0x0005e8000d901c46ULL, 0x00000000522b7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x002fec0000008000ULL,
0x0106b000ff3e7f8cULL, 0x000e68000c80043fULL, 0x0106ac00ff527984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106480016507f8cULL, 0x000fe2000c80043fULL, 0x8000000052ff7812ULL, 0x004fc6000784483dULL,
0x01064c0016537984ULL, 0x000ea40000000800ULL, 0x8000000053ff7812ULL, 0x004fe40007824851ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff527424ULL, 0x000fc800078e00ffULL,
0x0000005200537305ULL, 0x0004e4000021f000ULL, 0x3fa0000052527823ULL, 0x004fe200000100ffULL,
0x000000530000735dULL, 0x008fe40003800000ULL, 0x01064c0016537984ULL, 0x000ea40000000800ULL,
0x8000000053ff7812ULL, 0x004fc40007824851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010100002c527984ULL, 0x000ea80000000800ULL, 0x010300002c537984ULL, 0x0007220000000800ULL,
0x000000185200720bULL, 0x004fe20003f3d000ULL, 0x00012c827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000507806ULL, 0x008fc800008e0100ULL, 0x0000ffff50557812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff867424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f65270ULL,
0x000000185200720bULL, 0x000fe20003f34000ULL, 0x00012c627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000507806ULL, 0x000fe400008e0100ULL, 0x0000005218517209ULL, 0x000fe40007810000ULL,
0x0000ffff50507812ULL, 0x000fe400078e3cffULL, 0x00000002ff5a7819ULL, 0x000fe20000011602ULL,
0x8000005118547221ULL, 0x000fe20000010000ULL, 0x010500512c00b388ULL, 0x0005e20000000800ULL,
0x0000005055ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b54547820ULL, 0x000fcc0000410000ULL,
0x0000005400547308ULL, 0x000ee40000000800ULL, 0x0000005419197220ULL, 0x008fe20000410000ULL,
0x00012c127f007947ULL, 0x000fea000b800000ULL, 0x00001f5a545a7589ULL, 0x0044e400000e0000ULL,
0x0000005a08087220ULL, 0x08cfe40000410000ULL, 0x0000005a09097220ULL, 0x080fe40000410000ULL,
0x0000005a0c0c7220ULL, 0x080fe40000410000ULL, 0x0000005a0d0d7220ULL, 0x080fe40000410000ULL,
0x0000005a10107220ULL, 0x000fc40000410000ULL, 0x0000005a11117220ULL, 0x080fe40000410000ULL,
0x0000005a40407220ULL, 0x080fe40000410000ULL, 0x0000005a41417220ULL, 0x080fe40000410000ULL,
0x0000005a4c4c7220ULL, 0x080fe40000410000ULL, 0x0000005a4d4d7220ULL, 0x080fe40000410000ULL,
0x0000005a48487220ULL, 0x000fc40000410000ULL, 0x0000005a49497220ULL, 0x080fe40000410000ULL,
0x0000005a44447220ULL, 0x080fe40000410000ULL, 0x0000005a45457220ULL, 0x080fe40000410000ULL,
0x0000005a04047220ULL, 0x080fe40000410000ULL, 0x0000005a05057220ULL, 0x000fe20000410000ULL,
0x00012b627f007947ULL, 0x000fea000b800000ULL, 0x00001f2e545a7589ULL, 0x0004e400000e0000ULL,
0x0000005218187209ULL, 0x000fe20007810000ULL, 0x0000005a0a0a7220ULL, 0x08cfe20000410000ULL,
0x00000001ff867807ULL, 0x000fe20000800000ULL, 0x0000005a0b0b7220ULL, 0x000fc40000410000ULL,
0x8000001852521221ULL, 0x000fe40000010000ULL, 0x0000005a0e0e7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b52521820ULL, 0x000fe40000410000ULL, 0x0000005a0f0f7220ULL, 0x080fe40000410000ULL,
0x00000052002d1308ULL, 0x000ea20000000800ULL, 0x0000005a12127220ULL, 0x080fe40000410000ULL,
0x0000005a13137220ULL, 0x000fc40000410000ULL, 0x0000005a42427220ULL, 0x080fe40000410000ULL,
0x0000005a43437220ULL, 0x080fe40000410000ULL, 0x0000005a4e4e7220ULL, 0x080fe40000410000ULL,
0x0000005a4f4f7220ULL, 0x080fe40000410000ULL, 0x0000005a4a4a7220ULL, 0x080fe40000410000ULL,
0x0000005a4b4b7220ULL, 0x000fc40000410000ULL, 0x0000005a46467220ULL, 0x080fe40000410000ULL,
0x0000005a47477220ULL, 0x080fe40000410000ULL, 0x0000005a06067220ULL, 0x080fe40000410000ULL,
0x0000005a07077220ULL, 0x000fe40000410000ULL, 0x000000532d531220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000001953197221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff507984ULL, 0x000ea40000000800ULL, 0x8000000050ff7812ULL, 0x004fc4000782483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff507424ULL, 0x000fc800078e00ffULL, 0x0000005000517305ULL, 0x0004e4000021f000ULL,
0x3fa0000050507823ULL, 0x004fe200000100ffULL, 0x000000510000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff517984ULL, 0x000ea40000000800ULL, 0x8000000051ff7812ULL, 0x004fe4000782483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002dff3d723eULL, 0x000fe400000010ffULL,
0x00000002ff647819ULL, 0x000fc40000011602ULL, 0x000054103d3d7816ULL, 0x000fe2000000003dULL,
0x000129127f007947ULL, 0x000fea000b800000ULL, 0x00001f643d757589ULL, 0x0004e400000e0000ULL,
0x000129627f007947ULL, 0x000fea000b800000ULL, 0x00001f2e3d707589ULL, 0x0008a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e003dULL,
0x0000b8f000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x004fe400078e002fULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001350000007944ULL, 0x01afea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e003dULL, 0x0000b96000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x004fe400078e0030ULL, 0x0000001fff597424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0001349000007944ULL, 0x01afea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003158783bULL, 0x004ea80000004200ULL,
0x00000000325c783bULL, 0x000f680000004200ULL, 0x000000003350783bULL, 0x000f280000004200ULL,
0x000000003454783bULL, 0x000ee20000004200ULL, 0x0000010058747824ULL, 0x004fe200078e00ffULL,
0x0000005800f47306ULL, 0x000fe20000009400ULL, 0x00000018ffa67819ULL, 0x000fc40000011458ULL,
0x00000018ffa57819ULL, 0x000fe40000011459ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff987819ULL, 0x000fe2000001145bULL, 0x00000058006f7306ULL, 0x000ea20000005400ULL,
0x00000018ff9e7819ULL, 0x000fe4000001145aULL, 0x00000018ff8c7819ULL, 0x020fe4000001145cULL,
0x00000018ff767819ULL, 0x010fc40000011450ULL, 0x00000018ff717819ULL, 0x000fe20000011451ULL,
0x0000005800aa7306ULL, 0x000962000000d400ULL, 0x00000018ff617819ULL, 0x000fe4000001145fULL,
0x00000018ff8b7819ULL, 0x000fe4000001145dULL, 0x00000018ff607819ULL, 0x000fe4000001145eULL,
0x00000018ff6e7819ULL, 0x000fe20000011452ULL, 0x000000a6006d7306ULL, 0x000fe20000209400ULL,
0x0001000058587824ULL, 0x010fe200078e00ffULL, 0x0000006ff400720bULL, 0x004fc40003f7d000ULL,
0x00000018ff687819ULL, 0x000fe40000011453ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x000000a600f17306ULL, 0x000ea20000205400ULL, 0x00000018ff667819ULL, 0x008fe40000011454ULL,
0x00000018ff657819ULL, 0x000fe40000011455ULL, 0x00000018ff647819ULL, 0x000fe40000011456ULL,
0x00000001aaaa3812ULL, 0x020fe200078efcffULL, 0x0000007400f57306ULL, 0x000fe20000209400ULL,
0x00000018ff3d7819ULL, 0x000fce0000011457ULL, 0x0000007400977306ULL, 0x000ee20000205400ULL,
0x000000f16d00720bULL, 0x004fce0003fbd000ULL, 0x00000058007e7306ULL, 0x000ff00000209400ULL,
0x0000005800f07306ULL, 0x000fe20000205400ULL, 0x00000097f500720bULL, 0x008fce0003fdd000ULL,
0x0000005800a97306ULL, 0x0005f0000020d400ULL, 0x0000007400b97306ULL, 0x000722000020d400ULL,
0x000001005a587824ULL, 0x004fca00078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000005900f37306ULL, 0x000fe20000009400ULL, 0x0000010059747824ULL, 0x008fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000059008f7306ULL, 0x000ea20000005400ULL,
0x00000001b9b96812ULL, 0x010fe400078efcffULL, 0x000000f07e00720bULL, 0x000fca0003fdd000ULL,
0x0000005900a87306ULL, 0x0007f0000000d400ULL, 0x000000a600a67306ULL, 0x000f22000020d400ULL,
0x0001000059597824ULL, 0x008fe200078e00ffULL, 0x00000001a9a96812ULL, 0x000fc400078efcffULL,
0x0000008ff300720bULL, 0x004fe40003f3d000ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000058009c7306ULL, 0x000ff00000209400ULL, 0x0000005800eb7306ULL, 0x000ea20000205400ULL,
0x00000001a6a65812ULL, 0x010fc400078efcffULL, 0x00000001a8a81812ULL, 0x000fca00078efcffULL,
0x0000005900ee7306ULL, 0x000ff00000209400ULL, 0x0000005900ef7306ULL, 0x000ee20000205400ULL,
0x000000eb9c00720bULL, 0x004fce0003fbd000ULL, 0x0000005900a77306ULL, 0x000530000020d400ULL,
0x0000005b00797306ULL, 0x000fe20000009400ULL, 0x000001005b597824ULL, 0x004fe200078e00ffULL,
0x000000efee00720bULL, 0x008fc80003fdd000ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005b00d67306ULL, 0x000fee0000005400ULL, 0x00000001a7a76812ULL, 0x010fe200078efcffULL,
0x0000005b00a27306ULL, 0x0005f0000000d400ULL, 0x0000005a00907306ULL, 0x000fe20000009400ULL,
0x000100005b5b7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x0000005a00f27306ULL, 0x000eb00000005400ULL, 0x0000005a00a47306ULL, 0x000730000000d400ULL,
0x0000005800587306ULL, 0x000f62000020d400ULL, 0x000100005a5a7824ULL, 0x008fe200078e00ffULL,
0x000000f29000720bULL, 0x004fc80003f5d000ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x000000a500677306ULL, 0x000fee0000209400ULL, 0x00000001a4a42812ULL, 0x010fe200078efcffULL,
0x000000a5007d7306ULL, 0x000ea20000205400ULL, 0x0000000158585812ULL, 0x020fc800078efcffULL,
0x000000a45858723eULL, 0x000fc600000010ffULL, 0x0000005b00ec7306ULL, 0x000ff00000209400ULL,
0x0000005b00ed7306ULL, 0x000ee20000205400ULL, 0x0000007d6700720bULL, 0x004fce0003f9d000ULL,
0x0000005a00e17306ULL, 0x000ff00000209400ULL, 0x0000005a00e27306ULL, 0x000ea20000205400ULL,
0x000000edec00720bULL, 0x008fce0003fbd000ULL, 0x0000005a00a37306ULL, 0x000730000020d400ULL,
0x0000005c00a17306ULL, 0x000fe20000009400ULL, 0x000001005c5a7824ULL, 0x008fe200078e00ffULL,
0x000000e2e100720bULL, 0x004fc80003fdd000ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000005c00c87306ULL, 0x000fee0000005400ULL, 0x00000001a3a36812ULL, 0x010fe200078efcffULL,
0x0000005c00947306ULL, 0x0005f0000000d400ULL, 0x0000007400817306ULL, 0x000fe20000209400ULL,
0x000100005c5c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x00000074009b7306ULL, 0x000eb00000205400ULL, 0x000000a500a57306ULL, 0x000ef0000020d400ULL,
0x0000005b009a7306ULL, 0x000962000020d400ULL, 0x0000009b8100720bULL, 0x004fce0003f7d000ULL,
0x0000009e009d7306ULL, 0x000fe20000209400ULL, 0x000001005d5b7824ULL, 0x010fe200078e00ffULL,
0x00000001a5a54812ULL, 0x008fc800078efcffULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x0000009e00d17306ULL, 0x000ea20000205400ULL, 0x000000019a9a5812ULL, 0x020fce00078efcffULL,
0x0000005900df7306ULL, 0x000ff00000209400ULL, 0x0000005900e07306ULL, 0x000ee20000205400ULL,
0x000000d19d00720bULL, 0x004fce0003f9d000ULL, 0x0000005c00e57306ULL, 0x000ff00000209400ULL,
0x0000005c00e67306ULL, 0x000ea20000205400ULL, 0x000000e0df00720bULL, 0x008fce0003f3d000ULL,
0x0000005c00927306ULL, 0x000730000020d400ULL, 0x0000005000b27306ULL, 0x000fe20000009400ULL,
0x00000100505c7824ULL, 0x008fe200078e00ffULL, 0x000000e6e500720bULL, 0x004fc80003fbd000ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000005000af7306ULL, 0x000fee0000005400ULL,
0x0000000192925812ULL, 0x010fe200078efcffULL, 0x00000050007f7306ULL, 0x0005f0000000d400ULL,
0x0000007400ba7306ULL, 0x000ee2000020d400ULL, 0x0001000050507824ULL, 0x004fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000005a00e37306ULL, 0x000ff00000209400ULL,
0x0000005a00e47306ULL, 0x000ea20000205400ULL, 0x00000001baba3812ULL, 0x008fc400078efcffULL,
0x000000d67900720bULL, 0x000fca0003f7d000ULL, 0x0000005a00997306ULL, 0x000730000020d400ULL,
0x0000009800c97306ULL, 0x000fe20000209400ULL, 0x000001005e5a7824ULL, 0x008fe200078e00ffULL,
0x00000001a2a23812ULL, 0x000fc400078efcffULL, 0x000000e4e300720bULL, 0x004fe40003f7d000ULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x0000009800ca7306ULL, 0x000eb00000205400ULL,
0x0000005c00cb7306ULL, 0x000fe20000209400ULL, 0x0000000199993812ULL, 0x010fce00078efcffULL,
0x0000005c00cc7306ULL, 0x000fe20000205400ULL, 0x000000cac900720bULL, 0x004fce0003f5d000ULL,
0x0000005c00877306ULL, 0x0005f0000020d400ULL, 0x0000005100ae7306ULL, 0x000fe20000009400ULL,
0x00000100515c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000005100b17306ULL, 0x000ff00000005400ULL, 0x0000005100807306ULL, 0x0005f0000000d400ULL,
0x0000005000d27306ULL, 0x000fe20000209400ULL, 0x0001000051517824ULL, 0x004fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005000d37306ULL, 0x000ff00000205400ULL,
0x0000005000857306ULL, 0x0005f0000020d400ULL, 0x0000009e009e7306ULL, 0x000ee2000020d400ULL,
0x0000010052507824ULL, 0x004fca00078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005900597306ULL, 0x000eb0000020d400ULL, 0x0000005d00c77306ULL, 0x000fe20000009400ULL,
0x000000019e9e4812ULL, 0x008fce00078efcffULL, 0x0000005d007a7306ULL, 0x000ee20000005400ULL,
0x0000000159591812ULL, 0x004fe400078efcffULL, 0x000000c8a100720bULL, 0x000fe40003f3d000ULL,
0x000000a25959723eULL, 0x000fc600000010ffULL, 0x0000005b00d97306ULL, 0x000ff00000209400ULL,
0x0000005b00da7306ULL, 0x000ea20000205400ULL, 0x0000007ac700720bULL, 0x008fe40003fdd000ULL,
0x0000000194941812ULL, 0x000fca00078efcffULL, 0x0000005a00db7306ULL, 0x000ff00000209400ULL,
0x0000005a00dc7306ULL, 0x000ee20000205400ULL, 0x000000dad900720bULL, 0x004fce0003f9d000ULL,
0x0000005b00937306ULL, 0x000530000020d400ULL, 0x0000005a008e7306ULL, 0x000a62000020d400ULL,
0x000001005f5b7824ULL, 0x004fe200078e00ffULL, 0x000000dcdb00720bULL, 0x008fc80003fbd000ULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x0000005f00c17306ULL, 0x000fe20000009400ULL,
0x000100005e5a7824ULL, 0x020fe200078e00ffULL, 0x0000000193934812ULL, 0x010fc800078efcffULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x0000005f00bf7306ULL, 0x000ea20000005400ULL,
0x000000018e8e5812ULL, 0x002fce00078efcffULL, 0x0000005f00627306ULL, 0x0002f0000000d400ULL,
0x0000009800987306ULL, 0x000f22000020d400ULL, 0x000100005f5f7824ULL, 0x002fe200078e00ffULL,
0x000000bfc100720bULL, 0x004fc80003f9d000ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000008c00c67306ULL, 0x000fee0000209400ULL, 0x0000000162624812ULL, 0x008fe200078efcffULL,
0x0000008c00c47306ULL, 0x000e620000205400ULL, 0x0000000198982812ULL, 0x010fce00078efcffULL,
0x0000005100d77306ULL, 0x000ff00000209400ULL, 0x0000005100d87306ULL, 0x000fe20000205400ULL,
0x000000c4c600720bULL, 0x002fce0003f5d000ULL, 0x0000005100827306ULL, 0x0003f0000020d400ULL,
0x0000005000cd7306ULL, 0x000fe20000209400ULL, 0x0000010053517824ULL, 0x002fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005000ce7306ULL, 0x000ff00000205400ULL,
0x0000005000837306ULL, 0x0003f0000020d400ULL, 0x0000005d008d7306ULL, 0x0004e2000000d400ULL,
0x0000010054507824ULL, 0x002fca00078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005e00c57306ULL, 0x000fe20000009400ULL, 0x000100005d5d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000005e00c37306ULL, 0x000e620000005400ULL,
0x000000018d8d6812ULL, 0x008fce00078efcffULL, 0x0000005e00637306ULL, 0x000eb0000000d400ULL,
0x0000005200b37306ULL, 0x000fe20000009400ULL, 0x000000c3c500720bULL, 0x002fce0003f3d000ULL,
0x0000005200b67306ULL, 0x000fec0000005400ULL, 0x0000000163631812ULL, 0x004fe400078efcffULL,
0x0000005200847306ULL, 0x0003f0000000d400ULL, 0x0000005300cf7306ULL, 0x000fe20000009400ULL,
0x0001000052527824ULL, 0x002fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000005300d07306ULL, 0x000ff00000005400ULL, 0x00000053007c7306ULL, 0x0003f0000000d400ULL,
0x0000005b00dd7306ULL, 0x000fe20000209400ULL, 0x0001000053537824ULL, 0x002fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000005b00de7306ULL, 0x000ff00000205400ULL,
0x0000005b005e7306ULL, 0x000ff0000020d400ULL, 0x0000005a00e97306ULL, 0x000ff00000209400ULL,
0x0000005a00ea7306ULL, 0x000ff00000205400ULL, 0x0000005a008a7306ULL, 0x000ff0000020d400ULL,
0x0000005f005a7306ULL, 0x000ff00000209400ULL, 0x0000005f005b7306ULL, 0x000e700000205400ULL,
0x0000008b00c07306ULL, 0x000ff00000209400ULL, 0x0000008b00c27306ULL, 0x000ea20000205400ULL,
0x0000005b5a00720bULL, 0x002fc40003fbd000ULL, 0x000000a9a65a723eULL, 0x000fe400000010ffULL,
0x000000a7a55b723eULL, 0x000fc600000010ffULL, 0x0000005100bb7306ULL, 0x000ff00000209400ULL,
0x0000005100bc7306ULL, 0x000fe20000205400ULL, 0x000000c2c000720bULL, 0x004fe40003fdd000ULL,
0x0000991086c07816ULL, 0x000fca00000000ffULL, 0x00000051007b7306ULL, 0x0003f0000020d400ULL,
0x00000050009d7306ULL, 0x000fe20000209400ULL, 0x0000010055517824ULL, 0x002fca00078e00ffULL,
0x00000018ffc47819ULL, 0x000fe40000011451ULL, 0x0000005000a17306ULL, 0x000ff00000205400ULL,
0x00000050007a7306ULL, 0x0003f0000020d400ULL, 0x0000005d00e77306ULL, 0x000fe20000209400ULL,
0x0000b00035507811ULL, 0x002fce00078e20ffULL, 0x0000005d00e87306ULL, 0x000e700000205400ULL,
0x0000005d00917306ULL, 0x000eb0000020d400ULL, 0x0000005c00d47306ULL, 0x000fe20000209400ULL,
0x000000e8e700720bULL, 0x002fce0003f7d000ULL, 0x0000005c00d57306ULL, 0x000fec0000205400ULL,
0x0000000191913812ULL, 0x004fe400078efcffULL, 0x0000005c00887306ULL, 0x000fe2000020d400ULL,
0x000000eae900720bULL, 0x000fce0003f7d000ULL, 0x00000052005c7306ULL, 0x000fec0000209400ULL,
0x000000018a8a3812ULL, 0x000fe400078efcffULL, 0x00000052005d7306ULL, 0x000ff00000205400ULL,
0x0000005200817306ULL, 0x000ff0000020d400ULL, 0x00000053009b7306ULL, 0x000ff00000209400ULL,
0x00000053009c7306ULL, 0x000ff00000205400ULL, 0x0000005300797306ULL, 0x0003f0000020d400ULL,
0x0000005f00897306ULL, 0x000ea2000020d400ULL, 0x000000005050783bULL, 0x002e6e0000000200ULL,
0x0000008b008b7306ULL, 0x000ef0000020d400ULL, 0x0000006100b07306ULL, 0x000fe20000209400ULL,
0x0000000189895812ULL, 0x004fc400078efcffULL, 0x000000d3d200720bULL, 0x000fca0003fbd000ULL,
0x0000006100b47306ULL, 0x000ea20000205400ULL, 0x000000018b8b6812ULL, 0x008fce00078efcffULL,
0x0000006000b57306ULL, 0x000fe20000209400ULL, 0x0000000185855812ULL, 0x000fce00078efcffULL,
0x0000006000ac7306ULL, 0x000ee20000205400ULL, 0x000000b4b000720bULL, 0x004fe20003f9d000ULL,
0x0000010056b47824ULL, 0x000fca00078e00ffULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0000008c008c7306ULL, 0x000eb0000020d400ULL, 0x0000006100617306ULL, 0x000f22000020d400ULL,
0x000000acb500720bULL, 0x008fe20003fdd000ULL, 0x000000ffffac7224ULL, 0x000fc400078e00c0ULL,
0x0000010057b57824ULL, 0x000fc600078e00ffULL, 0x000000ffac00720cULL, 0x000fe20003f25270ULL,
0x0000007100b87306ULL, 0x000fe20000209400ULL, 0x000000018c8c2812ULL, 0x004fe400078efcffULL,
0x000000dedd00720bULL, 0x000fe40003f5d000ULL, 0x00000018ffb57819ULL, 0x000fe400000114b5ULL,
0x000000928c8c723eULL, 0x000fe200000010ffULL, 0x0000007100ad7306ULL, 0x000ea20000205400ULL,
0x0000000161614812ULL, 0x010fc400078efcffULL, 0x000000b1ae00720bULL, 0x000fe20003f9d000ULL,
0x0000007550509231ULL, 0x082fe400003400ffULL, 0x0000007552529231ULL, 0x000fe400003400ffULL,
0x0000007600ab7306ULL, 0x000fe20000209400ULL, 0x000000015e5e2812ULL, 0x000fe200078efcffULL,
0x0000007051519231ULL, 0x080fe200003400ffULL, 0x000000afb200720bULL, 0x000fe20003f5d000ULL,
0x0001000056b27824ULL, 0x000fe200078e00ffULL, 0x0000007053539231ULL, 0x000fe200003400ffULL,
0x0001000057af7824ULL, 0x000fc400078e00ffULL, 0x0000007600b77306ULL, 0x000e620000205400ULL,
0x000000adb800720bULL, 0x004fe40003fbd000ULL, 0x0000000180804812ULL, 0x000fe200078efcffULL,
0x0000005a500c723cULL, 0x040fe2000004180cULL, 0x000000cecd00720bULL, 0x000fe40003f9d000ULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x0000005400bd7306ULL, 0x000fe20000009400ULL,
0x000000017f7f2812ULL, 0x000fe400078efcffULL, 0x000000d5d400720bULL, 0x000fe20003f5d000ULL,
0x000000585010723cULL, 0x000fe20000041810ULL, 0x000000a39e5a723eULL, 0x000fc400000010ffULL,
0x0000009a985b723eULL, 0x000fe200000010ffULL, 0x0000005400be7306ULL, 0x000fe20000005400ULL,
0x000000b7ab00720bULL, 0x002fe40003f7d000ULL, 0x0000000183834812ULL, 0x000fe400078efcffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000005a5058723cULL, 0x000fe40000041840ULL,
0x0000005400747306ULL, 0x0003e2000000d400ULL, 0x0000000188882812ULL, 0x000fc400078efcffULL,
0x000000d0cf00720bULL, 0x000fe40003f5d000ULL, 0x000000638e40723eULL, 0x000fe400000010ffULL,
0x000000625e41723eULL, 0x000fe200000010ffULL, 0x0000006000607306ULL, 0x000ea2000020d400ULL,
0x0001000054547824ULL, 0x002fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000007100717306ULL, 0x000e62000020d400ULL, 0x000000017c7c2812ULL, 0x000fe400078efcffULL,
0x0000009c9b00720bULL, 0x000fca0003f5d000ULL, 0x00000055005f7306ULL, 0x000fe20000009400ULL,
0x0000000160606812ULL, 0x004fe400078efcffULL, 0x000000cccb00720bULL, 0x000fe40003fdd000ULL,
0x0000008a608a723eULL, 0x000fc600000010ffULL, 0x0000005500977306ULL, 0x000ea20000005400ULL,
0x0000000171715812ULL, 0x002fe400078efcffULL, 0x000000bcbb00720bULL, 0x000fe40003fbd000ULL,
0x0000000179792812ULL, 0x000fc600078efcffULL, 0x00000055006f7306ULL, 0x0003e2000000d400ULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x000000b6b300720bULL, 0x000fca0003fdd000ULL,
0x00000056008f7306ULL, 0x000fe20000009400ULL, 0x0001000055557824ULL, 0x002fe200078e00ffULL,
0x000000017b7b5812ULL, 0x000fcc00078efcffULL, 0x0000005600907306ULL, 0x000e620000005400ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x0000005d5c00720bULL, 0x000fe40003fdd000ULL,
0x0000008d935d723eULL, 0x000fe400000010ffULL, 0x000000918b8d723eULL, 0x000fe200000010ffULL,
0x00000056006d7306ULL, 0x000722000000d400ULL, 0x00000094995c723eULL, 0x000fe400000010ffULL,
0x00000089618b723eULL, 0x000fc400000010ffULL, 0x000000405060723cULL, 0x040fe60000041844ULL,
0x0000005400ac7306ULL, 0x000fe20000209400ULL, 0x00000018ff567819ULL, 0x008fe40000011455ULL,
0x000000a8ba55723eULL, 0x000fe400000010ffULL, 0x0000000181816812ULL, 0x000fe200078efcffULL,
0x0000005c504c723cULL, 0x000fe2000004184cULL, 0x000000975f00720bULL, 0x004fe20003fdd000ULL,
0x0000005400b07306ULL, 0x000fe20000205400ULL, 0x000000908f00720bULL, 0x002fc40003f5d000ULL,
0x000000848340723eULL, 0x000fe400000010ffULL, 0x0000007c7b41723eULL, 0x000fe200000010ffULL,
0x0000008c505c723cULL, 0x040fe40000041848ULL, 0x0000005400ab7306ULL, 0x0003e8000020d400ULL,
0x000000016f6f6812ULL, 0x000fe400078efcffULL, 0x0000007f8748723eULL, 0x000fe200000010ffULL,
0x0000008a5004723cULL, 0x000fe20000041804ULL, 0x0000006e00a07306ULL, 0x000fe20000209400ULL,
0x000000aab954723eULL, 0x002fc400000010ffULL, 0x000000016d6d2812ULL, 0x010fe400078efcffULL,
0x000000808849723eULL, 0x000fc600000010ffULL, 0x0000006e009f7306ULL, 0x000e700000205400ULL,
0x0000006800967306ULL, 0x000ff00000209400ULL, 0x0000006800957306ULL, 0x000ea20000205400ULL,
0x0000009fa000720bULL, 0x002fce0003f9d000ULL, 0x00000057007d7306ULL, 0x000ff00000009400ULL,
0x00000057007e7306ULL, 0x000fe20000005400ULL, 0x000000959600720bULL, 0x004fce0003fbd000ULL,
0x0000005700677306ULL, 0x000ff0000000d400ULL, 0x0000005600ae7306ULL, 0x000ff00000209400ULL,
0x0000005600a87306ULL, 0x000ff00000205400ULL, 0x0000005600a67306ULL, 0x0003f0000020d400ULL,
0x0000007600767306ULL, 0x000ea2000020d400ULL, 0x000000545054723cULL, 0x002fee0000041808ULL,
0x0000b00036087811ULL, 0x000fe200078e20ffULL, 0x0000006e006e7306ULL, 0x000e6a000020d400ULL,
0x000000000808783bULL, 0x000ee20000000200ULL, 0x0000000176763812ULL, 0x004fc400078efcffULL,
0x0000006800687306ULL, 0x000ea2000020d400ULL, 0x000000d8d700720bULL, 0x000fe40003f7d000ULL,
0x000000857644723eULL, 0x000fca00000010ffULL, 0x000000c400c37306ULL, 0x000fe20000209400ULL,
0x000000016e6e4812ULL, 0x002fe400078efcffULL, 0x000000a19d00720bULL, 0x000fc60003f9d000ULL,
0x0000000182823812ULL, 0x000fe400078efcffULL, 0x000000c400bf7306ULL, 0x000e620000205400ULL,
0x0000000168685812ULL, 0x004fe400078efcffULL, 0x000000bebd00720bULL, 0x000fe40003f7d000ULL,
0x000000827145723eULL, 0x000fe400000010ffULL, 0x000000796879723eULL, 0x000fe200000010ffULL,
0x000000c400867306ULL, 0x000ea2000020d400ULL, 0x000000017a7a4812ULL, 0x000fc400078efcffULL,
0x000000b0ac00720bULL, 0x000fe40003f9d000ULL, 0x000000bfc300720bULL, 0x002fc60003fbd000ULL,
0x0000006600777306ULL, 0x000fe20000209400ULL, 0x0000000174743812ULL, 0x000fe200078efcffULL,
0x0000007508089231ULL, 0x088fe400003400ffULL, 0x000000750a0a9231ULL, 0x000fc800003400ffULL,
0x00000001abab4812ULL, 0x000fe200078efcffULL, 0x0000006600787306ULL, 0x000e620000205400ULL,
0x0000007009099231ULL, 0x080fe400003400ffULL, 0x000000700b0b9231ULL, 0x000fe200003400ffULL,
0x0000000186865812ULL, 0x004fe400078efcffULL, 0x000000a8ae00720bULL, 0x000fe40003fbd000ULL,
0x0000006500727306ULL, 0x000fe40000209400ULL, 0x000000440844723cULL, 0x040fec000004180cULL,
0x0000006500737306ULL, 0x000ea20000205400ULL, 0x000000787700720bULL, 0x002fe20003f7d000ULL,
0x000000480848723cULL, 0x000fe20000041854ULL, 0x00000001a6a65812ULL, 0x000fc400078efcffULL,
0x000000747a0c723eULL, 0x000fe400000010ffULL, 0x0000006f860d723eULL, 0x000fe200000010ffULL,
0x000000b400a57306ULL, 0x000fe20000209400ULL, 0x000000816e78723eULL, 0x000fce00000010ffULL,
0x000000b4009e7306ULL, 0x000e620000205400ULL, 0x000000737200720bULL, 0x004fce0003fdd000ULL,
0x000000b500427306ULL, 0x000ff00000209400ULL, 0x000000b500437306ULL, 0x000ea20000205400ULL,
0x0000009ea500720bULL, 0x002fce0003f9d000ULL, 0x0000006600667306ULL, 0x000e70000020d400ULL,
0x0000006500657306ULL, 0x000ee2000020d400ULL, 0x000000434200720bULL, 0x004fe40003fbd000ULL,
0x000000400840723cULL, 0x000fea0000041810ULL, 0x000000b400b47306ULL, 0x000ea2000020d400ULL,
0x0000000166663812ULL, 0x002fc400078efcffULL, 0x0000007e7d00720bULL, 0x000fe20003f7d000ULL,
0x000000780810723cULL, 0x000fe80000041858ULL, 0x000000b500b57306ULL, 0x000e62000020d400ULL,
0x0000000165656812ULL, 0x008fce00078efcffULL, 0x0000006400697306ULL, 0x000fe20000209400ULL,
0x00000001b4b44812ULL, 0x004fe400078efcffULL, 0x0000000167673812ULL, 0x000fe400078efcffULL,
0x0000006db452723eULL, 0x000fc600000010ffULL, 0x00000064006a7306ULL, 0x000ea20000205400ULL,
0x00000001b5b55812ULL, 0x002fc800078efcffULL, 0x00000067b553723eULL, 0x000fc600000010ffULL,
0x0000003d006b7306ULL, 0x000ff00000209400ULL, 0x0000003d006c7306ULL, 0x000e620000205400ULL,
0x0000006a6900720bULL, 0x004fce0003fdd000ULL, 0x000000b2007f7306ULL, 0x000ff00000209400ULL,
0x000000b200507306ULL, 0x000ea20000205400ULL, 0x0000006c6b00720bULL, 0x002fce0003f9d000ULL,
0x000000af00517306ULL, 0x000ff00000209400ULL, 0x000000af000e7306ULL, 0x000e620000205400ULL,
0x000000507f00720bULL, 0x004fe40003f5d000ULL, 0x000000ab6650723eULL, 0x000fca00000010ffULL,
0x0000006400647306ULL, 0x000eb0000020d400ULL, 0x0000003d003d7306ULL, 0x000ee2000020d400ULL,
0x0000000e5100720bULL, 0x002fe40003fbd000ULL, 0x000000a66551723eULL, 0x000fe200000010ffULL,
0x0000000c080c723cULL, 0x000fe8000004184cULL, 0x000000b200b27306ULL, 0x000e62000020d400ULL,
0x0000000164646812ULL, 0x004fc600078efcffULL, 0x00000050084c723cULL, 0x000fe8000004185cULL,
0x000000af00af7306ULL, 0x000ea2000020d400ULL, 0x000000013d3d4812ULL, 0x008fc600078efcffULL,
0x000000520850723cULL, 0x000fe20000041860ULL, 0x00000001b2b22812ULL, 0x002fc800078efcffULL,
0x000000b26464723eULL, 0x000fe400000010ffULL, 0x00000001afaf5812ULL, 0x004fc800078efcffULL,
0x000000af3d65723eULL, 0x000fce00000010ffULL, 0x000000640808723cULL, 0x000fe20000041804ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff047f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007844805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007844805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007844805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c014047811ULL, 0x000fe200078e40ffULL, 0x00000100ff5a7424ULL, 0x000fe200078e00ffULL,
0x00000004ff597819ULL, 0x000fc40000011602ULL, 0x0000000403057217ULL, 0x000fe20007800000ULL,
0x00006200173d7a24ULL, 0x000fc800078e0204ULL, 0x0000000105057824ULL, 0x000fe400078e0a04ULL,
0x0000000120047824ULL, 0x100fe400078e023dULL, 0x0000000125077824ULL, 0x100fe200078e023dULL,
0x0000002005067807ULL, 0x000fe20000000000ULL, 0x0000000126557824ULL, 0x000fe400078e023dULL,
0x00005e0004047625ULL, 0x000fe200078e005aULL, 0x0000000616547217ULL, 0x000fc60007800000ULL,
0x00005e0007067625ULL, 0x000fe200078e005aULL, 0x0000002104567210ULL, 0x000fc60007f5e0ffULL,
0x0000000154587824ULL, 0x000fe200078e0a16ULL, 0x0000002106067210ULL, 0x000fe20007f9e0ffULL,
0x00005e0055547625ULL, 0x000fc600078e005aULL, 0x000000582200720cULL, 0x080fe20003f66070ULL,
0x0000000127047824ULL, 0x000fe200078e023dULL, 0x0000002154547210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff577224ULL, 0x000fe200010e0605ULL, 0x000000585900720cULL, 0x000fe20003f46070ULL,
0x00005e0004047625ULL, 0x000fc800078e005aULL, 0x000000ffff077224ULL, 0x000fe200020e0607ULL,
0x000000582300720cULL, 0x080fe20003f86070ULL, 0x000000ffff557224ULL, 0x000fe200028e0655ULL,
0x000000582400720cULL, 0x000fe40003fa6070ULL, 0x0000002104047210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000056377faeULL, 0x0003e4000d101c46ULL,
0x000000ffff057224ULL, 0x000fe400030e0605ULL, 0x0000000006387faeULL, 0x0003e8000d901c46ULL,
0x0000000054397faeULL, 0x0003e8000e101c46ULL, 0x00000000043a7faeULL, 0x0005e8000e901c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x002fec0000008000ULL,
0x0106a800ff047f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc4000784483fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0005ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000784483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc4000784483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002dff04723eULL, 0x000fe400000010ffULL, 0x00000002ff3e7819ULL, 0x000fe40000011602ULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x000105f27f007947ULL, 0x000fea000b800000ULL,
0x00001f3e043e7589ULL, 0x0002a400000e0000ULL, 0x000106527f007947ULL, 0x000fea000b800000ULL,
0x00001f2e04ae7589ULL, 0x00072400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0004ULL, 0x0000dd0000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fe400078e002fULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x000110f000007944ULL, 0x01efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0004ULL,
0x0000dd7000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fc400078e0030ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001108000007944ULL, 0x01efea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003b5c783bULL, 0x000f680000004200ULL, 0x000000003c54783bULL, 0x000e680000004200ULL,
0x000000001a04783bULL, 0x00ae680000004200ULL, 0x000000001b58783bULL, 0x004ea20000004200ULL,
0x0000005c00f37306ULL, 0x020fe20000009400ULL, 0x000001005c707824ULL, 0x000fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe2000001145cULL, 0x000001005d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001145dULL, 0x00000100577e7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fc40000011470ULL, 0x0000005c00957306ULL, 0x000ee20000005400ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff9e7819ULL, 0x000fe4000001145fULL,
0x00000018ffa17819ULL, 0x000fe4000001145eULL, 0x00000018ff847819ULL, 0x000fe20000011456ULL,
0x000000bd00707306ULL, 0x000fe20000209400ULL, 0x00000018ff607819ULL, 0x000fe40000011454ULL,
0x00000018ff807819ULL, 0x000fc40000011457ULL, 0x00000018ff787819ULL, 0x002fe40000011404ULL,
0x00000018ff617819ULL, 0x000fe20000011455ULL, 0x000000bd00767306ULL, 0x000e620000205400ULL,
0x00000095f300720bULL, 0x008fe40003f7d000ULL, 0x00000018ff727819ULL, 0x000fe40000011405ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff6f7819ULL, 0x000fe20000011406ULL,
0x0000005c00b87306ULL, 0x000762000000d400ULL, 0x00000018ff697819ULL, 0x000fc40000011407ULL,
0x00000018ff677819ULL, 0x004fe40000011458ULL, 0x00000018ff667819ULL, 0x000fe40000011459ULL,
0x00000018ff657819ULL, 0x000fe2000001145aULL, 0x0000007d00817306ULL, 0x000fe20000209400ULL,
0x000100005c5c7824ULL, 0x008fe200078e00ffULL, 0x000000767000720bULL, 0x002fe40003f5d000ULL,
0x00000018ff647819ULL, 0x000fe4000001145bULL, 0x00000018ff5c7819ULL, 0x000fc4000001145cULL,
0x0000007d009c7306ULL, 0x000e620000205400ULL, 0x00000001b8b83812ULL, 0x020fce00078efcffULL,
0x0000005d00f27306ULL, 0x000ff00000009400ULL, 0x0000005d00967306ULL, 0x000ea20000005400ULL,
0x0000009c8100720bULL, 0x002fce0003f7d000ULL, 0x0000005d00b67306ULL, 0x0002f0000000d400ULL,
0x000000b3006c7306ULL, 0x000fe20000209400ULL, 0x000100005d5d7824ULL, 0x002fe200078e00ffULL,
0x00000096f200720bULL, 0x004fc80003fbd000ULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x000000b300a07306ULL, 0x000e6e0000205400ULL, 0x00000001b6b65812ULL, 0x008fe200078efcffULL,
0x000000bd00bd7306ULL, 0x000eb0000020d400ULL, 0x0000005c008c7306ULL, 0x000fe20000209400ULL,
0x000000a06c00720bULL, 0x002fce0003f9d000ULL, 0x0000005c009f7306ULL, 0x000e620000205400ULL,
0x00000001bdbd2812ULL, 0x004fce00078efcffULL, 0x0000007d00bc7306ULL, 0x0004f0000020d400ULL,
0x0000005e00e07306ULL, 0x000fe20000009400ULL, 0x0000009f8c00720bULL, 0x002fe20003f5d000ULL,
0x00000100567d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000005e007b7306ULL, 0x000e620000005400ULL, 0x00000001bcbc3812ULL, 0x008fce00078efcffULL,
0x0000005c00b77306ULL, 0x0004f0000020d400ULL, 0x0000005d00f07306ULL, 0x000fe20000209400ULL,
0x000001005e5c7824ULL, 0x004fe200078e00ffULL, 0x0000007be000720bULL, 0x002fc80003f7d000ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000005d00f17306ULL, 0x000e620000205400ULL,
0x00000001b7b72812ULL, 0x008fce00078efcffULL, 0x0000005d00ad7306ULL, 0x0004f0000020d400ULL,
0x0000005f00dd7306ULL, 0x000fe20000009400ULL, 0x000001005f5d7824ULL, 0x004fe200078e00ffULL,
0x000000f1f000720bULL, 0x002fc80003f5d000ULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000005f00997306ULL, 0x000e6e0000005400ULL, 0x00000001adad2812ULL, 0x008fe200078efcffULL,
0x0000005f00a27306ULL, 0x0004f0000000d400ULL, 0x000000b300b37306ULL, 0x000f62000020d400ULL,
0x000100005f5f7824ULL, 0x004fe200078e00ffULL, 0x00000099dd00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000005c009d7306ULL, 0x000fee0000209400ULL,
0x00000001a2a22812ULL, 0x008fe200078efcffULL, 0x0000005c00ef7306ULL, 0x000e620000205400ULL,
0x00000001b3b34812ULL, 0x020fce00078efcffULL, 0x0000005e00a97306ULL, 0x0004f0000000d400ULL,
0x0000005d00e77306ULL, 0x000fe20000209400ULL, 0x000000ef9d00720bULL, 0x002fe20003f9d000ULL,
0x000100005e5e7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000005d00e87306ULL, 0x000e620000205400ULL, 0x00000001a9a93812ULL, 0x008fce00078efcffULL,
0x0000005f00eb7306ULL, 0x000ff00000209400ULL, 0x0000005f00ec7306ULL, 0x000ea20000205400ULL,
0x000000e8e700720bULL, 0x002fce0003fbd000ULL, 0x0000005c00ac7306ULL, 0x0002f0000020d400ULL,
0x0000003f008b7306ULL, 0x000fe20000209400ULL, 0x00000100545c7824ULL, 0x002fe200078e00ffULL,
0x000000eceb00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000003f00687306ULL, 0x000e620000205400ULL, 0x00000001acac4812ULL, 0x008fce00078efcffULL,
0x000000a100de7306ULL, 0x000ff00000209400ULL, 0x000000a100df7306ULL, 0x000ea20000205400ULL,
0x000000688b00720bULL, 0x002fce0003fdd000ULL, 0x0000005d00a37306ULL, 0x0002f0000020d400ULL,
0x0000005f005f7306ULL, 0x000f62000020d400ULL, 0x00000100555d7824ULL, 0x002fe200078e00ffULL,
0x000000dfde00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000005500d97306ULL, 0x000fe20000009400ULL, 0x00000001a3a35812ULL, 0x008fce00078efcffULL,
0x0000005500da7306ULL, 0x000e620000005400ULL, 0x000000015f5f3812ULL, 0x020fce00078efcffULL,
0x0000005600c77306ULL, 0x000ff00000009400ULL, 0x0000005600757306ULL, 0x000fe20000005400ULL,
0x000000dad900720bULL, 0x002fce0003f7d000ULL, 0x0000005600887306ULL, 0x0003f0000000d400ULL,
0x0000009e009a7306ULL, 0x000fe20000209400ULL, 0x0001000056567824ULL, 0x002fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000009e00dc7306ULL, 0x000e700000205400ULL,
0x0000003f003f7306ULL, 0x000eb0000020d400ULL, 0x000000a100a17306ULL, 0x000ee2000020d400ULL,
0x000000dc9a00720bULL, 0x002fce0003fbd000ULL, 0x0000005700c37306ULL, 0x000fe20000009400ULL,
0x000000013f3f6812ULL, 0x004fc800078efcffULL, 0x000000ad3f3f723eULL, 0x000fc600000010ffULL,
0x0000005700bf7306ULL, 0x000fe20000005400ULL, 0x00000001a1a14812ULL, 0x008fce00078efcffULL,
0x0000005700857306ULL, 0x0003f0000000d400ULL, 0x0000005e00e97306ULL, 0x000fe20000209400ULL,
0x0001000057577824ULL, 0x002fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000005e00ea7306ULL, 0x000e700000205400ULL, 0x0000005d00e17306ULL, 0x000ff00000209400ULL,
0x0000005d00e27306ULL, 0x000ea20000205400ULL, 0x000000eae900720bULL, 0x002fce0003fdd000ULL,
0x0000005600ce7306ULL, 0x000ff00000209400ULL, 0x0000005600cf7306ULL, 0x000fe20000205400ULL,
0x000000e2e100720bULL, 0x004fce0003f9d000ULL, 0x00000056008e7306ULL, 0x0003f0000020d400ULL,
0x0000000400c07306ULL, 0x000fe20000009400ULL, 0x0000010004567824ULL, 0x002fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000000400917306ULL, 0x000ff00000005400ULL,
0x00000004007f7306ULL, 0x0003f0000000d400ULL, 0x0000005c00ed7306ULL, 0x000fe20000209400ULL,
0x0001000004047824ULL, 0x002fca00078e00ffULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x0000005c00ee7306ULL, 0x000e700000205400ULL, 0x0000005500987306ULL, 0x0004f0000000d400ULL,
0x0000009e009e7306ULL, 0x000f62000020d400ULL, 0x0001000055557824ULL, 0x004fe200078e00ffULL,
0x000000eeed00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff977819ULL, 0x000fe40000011455ULL,
0x0000006000d87306ULL, 0x000fe20000209400ULL, 0x0000000198983812ULL, 0x008fce00078efcffULL,
0x0000006000d77306ULL, 0x000e620000205400ULL, 0x000000019e9e5812ULL, 0x020fce00078efcffULL,
0x0000007d00e57306ULL, 0x000ff00000209400ULL, 0x0000007d00e67306ULL, 0x000ea20000205400ULL,
0x000000d7d800720bULL, 0x002fce0003fbd000ULL, 0x0000005400db7306ULL, 0x000ff00000009400ULL,
0x00000054007c7306ULL, 0x000fe20000005400ULL, 0x000000e6e500720bULL, 0x004fce0003f7d000ULL,
0x00000054009b7306ULL, 0x0003f0000000d400ULL, 0x0000005e00a47306ULL, 0x0004e2000020d400ULL,
0x0001000054547824ULL, 0x002fce00078e00ffULL, 0x0000005700d47306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x004fce0000011454ULL, 0x0000005700d57306ULL, 0x000fe20000205400ULL,
0x00000001a4a46812ULL, 0x008fe400078efcffULL, 0x0000007cdb00720bULL, 0x000fca0003fdd000ULL,
0x0000005700897306ULL, 0x0003f0000020d400ULL, 0x0000000500c67306ULL, 0x000fe20000009400ULL,
0x0000010005577824ULL, 0x002fe200078e00ffULL, 0x000000019b9b6812ULL, 0x000fc800078efcffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000000500c27306ULL, 0x000ff00000005400ULL,
0x0000000500777306ULL, 0x0003f0000000d400ULL, 0x0000000400ca7306ULL, 0x000fe20000209400ULL,
0x0001000005057824ULL, 0x002fca00078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000000400cb7306ULL, 0x000ff00000205400ULL, 0x0000000400877306ULL, 0x0003f0000020d400ULL,
0x0000005d005d7306ULL, 0x000ea2000020d400ULL, 0x0000010006047824ULL, 0x002fca00078e00ffULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x0000005c005c7306ULL, 0x000e70000020d400ULL,
0x0000009700557306ULL, 0x000fe20000209400ULL, 0x000000015d5d4812ULL, 0x004fc800078efcffULL,
0x000000985d5d723eULL, 0x000fc600000010ffULL, 0x0000009700e47306ULL, 0x000ea20000205400ULL,
0x000000015c5c2812ULL, 0x002fc800078efcffULL, 0x0000009b5c5c723eULL, 0x000fc600000010ffULL,
0x0000005e00547306ULL, 0x000ff00000209400ULL, 0x0000005e00e37306ULL, 0x000e620000205400ULL,
0x000000e45500720bULL, 0x004fce0003f9d000ULL, 0x0000006000607306ULL, 0x000eb0000020d400ULL,
0x0000007d00927306ULL, 0x000ee2000020d400ULL, 0x000000e35400720bULL, 0x002fe40003f5d000ULL,
0x0000b0001c547811ULL, 0x000fca00078e20ffULL, 0x0000007e00cc7306ULL, 0x000fe20000209400ULL,
0x0000000160605812ULL, 0x004fce00078efcffULL, 0x0000007e00cd7306ULL, 0x000e620000205400ULL,
0x0000000192923812ULL, 0x008fe400078efcffULL, 0x000000cfce00720bULL, 0x000fca0003f7d000ULL,
0x0000000500c87306ULL, 0x000ff00000209400ULL, 0x0000000500c97306ULL, 0x000fe20000205400ULL,
0x000000cdcc00720bULL, 0x002fe40003fbd000ULL, 0x000000018e8e3812ULL, 0x000fc400078efcffULL,
0x000000c2c600720bULL, 0x000fc60003f7d000ULL, 0x0000000500827306ULL, 0x0003f0000020d400ULL,
0x0000000400af7306ULL, 0x000fe20000209400ULL, 0x0000010007057824ULL, 0x002fe200078e00ffULL,
0x0000000177773812ULL, 0x000fc800078efcffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000000400b07306ULL, 0x000ff00000205400ULL, 0x0000000400837306ULL, 0x0003f0000020d400ULL,
0x0000007e008d7306ULL, 0x000ea2000020d400ULL, 0x0000010058047824ULL, 0x002fca00078e00ffULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x0000000600b97306ULL, 0x000ff00000009400ULL,
0x0000000600ba7306ULL, 0x000fe20000005400ULL, 0x000000018d8d5812ULL, 0x004fc400078efcffULL,
0x000000d5d400720bULL, 0x000fca0003fbd000ULL, 0x0000000600717306ULL, 0x0003f0000000d400ULL,
0x0000000700bb7306ULL, 0x000fe20000009400ULL, 0x0001000006067824ULL, 0x002fe200078e00ffULL,
0x0000000189895812ULL, 0x000fc800078efcffULL, 0x00000018ff067819ULL, 0x000fe40000011406ULL,
0x0000000700d67306ULL, 0x000ff00000005400ULL, 0x00000007007e7306ULL, 0x0003f0000000d400ULL,
0x0000009700977306ULL, 0x000ea2000020d400ULL, 0x0001000007077824ULL, 0x002fca00078e00ffULL,
0x00000018ff077819ULL, 0x000fe40000011407ULL, 0x0000005e005e7306ULL, 0x000e70000020d400ULL,
0x0000000500a57306ULL, 0x000fe20000209400ULL, 0x0000000197974812ULL, 0x004fc400078efcffULL,
0x000000bfc300720bULL, 0x000fe20003f9d000ULL, 0x000100005ac37824ULL, 0x000fc800078e00ffULL,
0x0000000500a67306ULL, 0x000fe20000205400ULL, 0x000000015e5e2812ULL, 0x002fe400078efcffULL,
0x00000075c700720bULL, 0x000fe40003f5d000ULL, 0x0000005e6060723eULL, 0x000fe400000010ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x00000005007d7306ULL, 0x0003e2000020d400ULL,
0x0000000185854812ULL, 0x000fe400078efcffULL, 0x00000091c000720bULL, 0x000fca0003f9d000ULL,
0x0000000400997306ULL, 0x000fe20000209400ULL, 0x0000010059057824ULL, 0x002fe200078e00ffULL,
0x0000000188882812ULL, 0x000fc800078efcffULL, 0x00000018ffd77819ULL, 0x000fe40000011405ULL,
0x00000004009a7306ULL, 0x000fe20000205400ULL, 0x000000017f7f4812ULL, 0x000fe400078efcffULL,
0x000000cbca00720bULL, 0x000fe40003f9d000ULL, 0x000000889292723eULL, 0x000fc600000010ffULL,
0x00000004007c7306ULL, 0x0003f0000020d400ULL, 0x00000061008f7306ULL, 0x000fe20000209400ULL,
0x0000b0001d047811ULL, 0x002fe400078e20ffULL, 0x0000000187874812ULL, 0x000fca00078efcffULL,
0x0000006100907306ULL, 0x000e700000205400ULL, 0x0000005600d07306ULL, 0x000ff00000209400ULL,
0x0000005600d17306ULL, 0x000ea20000205400ULL, 0x000000908f00720bULL, 0x002fce0003fdd000ULL,
0x00000056008a7306ULL, 0x000e70000020d400ULL, 0x0000005700d27306ULL, 0x000fe20000209400ULL,
0x000000d1d000720bULL, 0x004fce0003fbd000ULL, 0x0000005700d37306ULL, 0x000fec0000205400ULL,
0x000000018a8a5812ULL, 0x002fe400078efcffULL, 0x0000005700867306ULL, 0x0003e4000020d400ULL,
0x0000007f8a8a723eULL, 0x000fcc00000010ffULL, 0x00000006009f7306ULL, 0x000fe20000209400ULL,
0x000000005454783bULL, 0x002e6e0000000200ULL, 0x0000000600a07306ULL, 0x000ff00000205400ULL,
0x0000000600817306ULL, 0x000ff0000020d400ULL, 0x00000007009c7306ULL, 0x000ff00000209400ULL,
0x00000007009d7306ULL, 0x000ff00000205400ULL, 0x00000007007b7306ULL, 0x0005e2000020d400ULL,
0x0000003e54549231ULL, 0x002fc400003400ffULL, 0x0000003e56569231ULL, 0x000fe400003400ffULL,
0x000000ae55559231ULL, 0x090fe400003400ffULL, 0x000000ae57579231ULL, 0x000fe200003400ffULL,
0x0000006100617306ULL, 0x000e62000020d400ULL, 0x000000000404783bULL, 0x004eae0000000200ULL,
0x0000008000c17306ULL, 0x000ff00000209400ULL, 0x0000008000be7306ULL, 0x000ee20000205400ULL,
0x0000000161616812ULL, 0x002fc800078efcffULL, 0x000000976161723eULL, 0x000fc600000010ffULL,
0x0000008400c57306ULL, 0x000ff00000209400ULL, 0x0000008400c47306ULL, 0x000e620000205400ULL,
0x000000bec100720bULL, 0x008fe20003f5d000ULL, 0x000100005bbe7824ULL, 0x000fca00078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe200000114beULL, 0x0000007200ab7306ULL, 0x000fe20000209400ULL,
0x0000003e04049231ULL, 0x084fe400003400ffULL, 0x0000003e06069231ULL, 0x000fe200003400ffULL,
0x000000b7b33e723eULL, 0x000fe200000010ffULL, 0x000000ae05059231ULL, 0x080fe400003400ffULL,
0x000000ae07079231ULL, 0x000fe200003400ffULL, 0x0000007200aa7306ULL, 0x000ea20000205400ULL,
0x000000c4c500720bULL, 0x002fe20003fdd000ULL, 0x000001005ac47824ULL, 0x000fe200078e00ffULL,
0x000000d6bb00720bULL, 0x000fe20003f3d000ULL, 0x0000003e5444723cULL, 0x000fe20000041844ULL,
0x000001005bc57824ULL, 0x000fc400078e00ffULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x0000008000807306ULL, 0x000e64000020d400ULL, 0x00000018ffc57819ULL, 0x000fcc00000114c5ULL,
0x0000008400847306ULL, 0x000ee2000020d400ULL, 0x000000aaab00720bULL, 0x004fe40003f7d000ULL,
0x000000017e7e1812ULL, 0x000fe400078efcffULL, 0x0000009d9c00720bULL, 0x000fc60003f3d000ULL,
0x0000007200727306ULL, 0x000ea2000020d400ULL, 0x0000000180802812ULL, 0x002fe400078efcffULL,
0x000000d3d200720bULL, 0x000fca0003f5d000ULL, 0x0000007800b57306ULL, 0x000fe20000209400ULL,
0x0000000184846812ULL, 0x008fe400078efcffULL, 0x000000bab900720bULL, 0x000fe40003fdd000ULL,
0x000000017b7b1812ULL, 0x000fe400078efcffULL, 0x0000008e8484723eULL, 0x000fe200000010ffULL,
0x0000007800b47306ULL, 0x000e620000205400ULL, 0x0000000172723812ULL, 0x004fe400078efcffULL,
0x000000a6a500720bULL, 0x000fc40003f7d000ULL, 0x0000000186862812ULL, 0x000fe400078efcffULL,
0x000000c9c800720bULL, 0x000fe20003f5d000ULL, 0x0000005800b17306ULL, 0x000fe20000009400ULL,
0x0000000171716812ULL, 0x000fce00078efcffULL, 0x0000005800b27306ULL, 0x000ea20000005400ULL,
0x000000b4b500720bULL, 0x002fe40003fbd000ULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x0000000182822812ULL, 0x000fc600078efcffULL, 0x0000007800787306ULL, 0x000e70000020d400ULL,
0x0000005800767306ULL, 0x000722000000d400ULL, 0x000000b2b100720bULL, 0x004fce0003f9d000ULL,
0x0000006f00937306ULL, 0x000fe20000209400ULL, 0x0001000058587824ULL, 0x008fe200078e00ffULL,
0x0000000178785812ULL, 0x002fe400078efcffULL, 0x000000b0af00720bULL, 0x000fe40003fbd000ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000006f00947306ULL, 0x000e620000205400ULL,
0x0000000176764812ULL, 0x010fce00078efcffULL, 0x0000006900627306ULL, 0x000fe20000209400ULL,
0x0000000183835812ULL, 0x000fe400078efcffULL, 0x000000a09f00720bULL, 0x000fca0003fbd000ULL,
0x0000006900637306ULL, 0x000ea20000205400ULL, 0x000000949300720bULL, 0x002fe40003fdd000ULL,
0x000000858d93723eULL, 0x000fe400000010ffULL, 0x000000898085723eULL, 0x000fc600000010ffULL,
0x0000005900a77306ULL, 0x000fe20000009400ULL, 0x0000000181815812ULL, 0x000fe200078efcffULL,
0x000000925450723cULL, 0x040fec0000041850ULL, 0x0000005900a87306ULL, 0x000e620000005400ULL,
0x000000636200720bULL, 0x004fe40003f7d000ULL, 0x000000605460723cULL, 0x000fea000004184cULL,
0x0000005900707306ULL, 0x0004f0000000d400ULL, 0x0000005a00957306ULL, 0x000fe20000009400ULL,
0x0001000059597824ULL, 0x004fe200078e00ffULL, 0x000000a8a700720bULL, 0x002fcc0003f5d000ULL,
0x0000005a00967306ULL, 0x000e6e0000005400ULL, 0x0000000170702812ULL, 0x008fe200078efcffULL,
0x0000005a006c7306ULL, 0x0004f0000000d400ULL, 0x0000005800bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff5a7819ULL, 0x004fc40000011459ULL, 0x000000b6bc59723eULL, 0x000fe400000010ffULL,
0x000000969500720bULL, 0x002fc60003fbd000ULL, 0x0000005800c17306ULL, 0x000e700000205400ULL,
0x0000005800917306ULL, 0x0005e4000020d400ULL, 0x000000016c6c5812ULL, 0x008fcc00078efcffULL,
0x0000006f006f7306ULL, 0x000ee2000020d400ULL, 0x000000b8bd58723eULL, 0x004fe400000010ffULL,
0x000000c1bf00720bULL, 0x002fca0003f9d000ULL, 0x0000006900697306ULL, 0x000e62000020d400ULL,
0x000000585448723cULL, 0x000fee0000041848ULL, 0x000000d7008f7306ULL, 0x000fe20000209400ULL,
0x000000016f6f6812ULL, 0x008fe400078efcffULL, 0x0000009a9900720bULL, 0x000fc40003fdd000ULL,
0x000000a9ac58723eULL, 0x000fe400000010ffULL, 0x000000a2a359723eULL, 0x000fe200000010ffULL,
0x000000d700907306ULL, 0x000ea20000205400ULL, 0x0000000169693812ULL, 0x002fe400078efcffULL,
0x0000000191914812ULL, 0x000fe400078efcffULL, 0x0000007b697b723eULL, 0x000fe200000010ffULL,
0x000000585440723cULL, 0x000fe40000041840ULL, 0x0000005b008b7306ULL, 0x000fe20000009400ULL,
0x000000017c7c6812ULL, 0x000fc800078efcffULL, 0x000000767c4c723eULL, 0x000fc600000010ffULL,
0x0000005b008c7306ULL, 0x000e620000005400ULL, 0x000000908f00720bULL, 0x004fce0003f7d000ULL,
0x000000c400ad7306ULL, 0x000ff00000209400ULL, 0x000000c4003e7306ULL, 0x000ea20000205400ULL,
0x0000008c8b00720bULL, 0x002fe40003f3d000ULL, 0x00000077868b723eULL, 0x000fca00000010ffULL,
0x0000006600737306ULL, 0x000ff00000209400ULL, 0x0000006600747306ULL, 0x000e620000205400ULL,
0x0000003ead00720bULL, 0x004fce0003f9d000ULL, 0x000000d700757306ULL, 0x000eb0000020d400ULL,
0x0000006700797306ULL, 0x000fe20000209400ULL, 0x000000747300720bULL, 0x002fce0003f5d000ULL,
0x00000067007a7306ULL, 0x000e620000205400ULL, 0x0000000175753812ULL, 0x004fc800078efcffULL,
0x00000070754d723eULL, 0x000fc600000010ffULL, 0x0000005a00b97306ULL, 0x000ff00000209400ULL,
0x0000005a00ba7306ULL, 0x000ea20000205400ULL, 0x0000007a7900720bULL, 0x002fe40003fdd000ULL,
0x000000816f7a723eULL, 0x000fca00000010ffULL, 0x0000005b00687306ULL, 0x0002f0000000d400ULL,
0x0000005a00ae7306ULL, 0x000962000020d400ULL, 0x0000005f9e5b723eULL, 0x002fe400000010ffULL,
0x0000005c545c723cULL, 0x000fe2000004180cULL, 0x000000bab900720bULL, 0x004fc80003f7d000ULL,
0x000000c400c47306ULL, 0x000e62000020d400ULL, 0x000000a4a15a723eULL, 0x010fe400000010ffULL,
0x00000087780c723eULL, 0x000fe400000010ffULL, 0x00000082720d723eULL, 0x000fe400000010ffULL,
0x0000000168681812ULL, 0x008fe200078efcffULL, 0x000000c3003f7306ULL, 0x000fe20000209400ULL,
0x0000005a5458723cULL, 0x000fe20000041810ULL, 0x00000001aeae3812ULL, 0x020fcc00078efcffULL,
0x000000c3004e7306ULL, 0x000ea20000205400ULL, 0x000000845454723cULL, 0x000fe20000041808ULL,
0x00000001c4c44812ULL, 0x002fe400078efcffULL, 0x000000718310723eULL, 0x000fe400000010ffULL,
0x0000007e7d11723eULL, 0x000fe400000010ffULL, 0x0000006600667306ULL, 0x000e62000020d400ULL,
0x0000008a0408723cULL, 0x040fee0000041848ULL, 0x0000006700677306ULL, 0x000ee2000020d400ULL,
0x0000004e3f00720bULL, 0x004fe20003f9d000ULL, 0x0000000c040c723cULL, 0x040fec0000041844ULL,
0x000000c500987306ULL, 0x000fe20000209400ULL, 0x0000000166662812ULL, 0x002fe200078efcffULL,
0x000000100410723cULL, 0x000fe20000041840ULL, 0x0000006cc444723eULL, 0x000fc400000010ffULL,
0x000000ae6649723eULL, 0x000fc600000010ffULL, 0x000000c500947306ULL, 0x000e620000205400ULL,
0x0000000167676812ULL, 0x008fe200078efcffULL, 0x0000007a0440723cULL, 0x040fec0000041858ULL,
0x00000065006e7306ULL, 0x000fe40000209400ULL, 0x0000004c044c723cULL, 0x000fec000004185cULL,
0x00000065006d7306ULL, 0x000ea20000205400ULL, 0x000000949800720bULL, 0x002fce0003f5d000ULL,
0x00000064006a7306ULL, 0x000ff00000209400ULL, 0x00000064006b7306ULL, 0x000e620000205400ULL,
0x0000006d6e00720bULL, 0x004fce0003fdd000ULL, 0x000000be00487306ULL, 0x000ff00000209400ULL,
0x000000be003e7306ULL, 0x000ea20000205400ULL, 0x0000006b6a00720bULL, 0x002fce0003f7d000ULL,
0x000000c500c57306ULL, 0x000e70000020d400ULL, 0x0000006500657306ULL, 0x000ee2000020d400ULL,
0x0000003e4800720bULL, 0x004fe40003fbd000ULL, 0x000000916748723eULL, 0x000fca00000010ffULL,
0x0000006400647306ULL, 0x000ea2000020d400ULL, 0x00000001c5c52812ULL, 0x002fe200078efcffULL,
0x000000480448723cULL, 0x000fe60000041860ULL, 0x00000068c545723eULL, 0x000fc600000010ffULL,
0x000000c300c37306ULL, 0x000e62000020d400ULL, 0x0000000165656812ULL, 0x008fc600078efcffULL,
0x000000440444723cULL, 0x000fe80000041850ULL, 0x000000be003f7306ULL, 0x000ee2000020d400ULL,
0x0000000164643812ULL, 0x004fe400078efcffULL, 0x00000001c3c34812ULL, 0x002fc800078efcffULL,
0x000000c3653e723eULL, 0x000fe400000010ffULL, 0x000000013f3f5812ULL, 0x008fc800078efcffULL,
0x0000003f643f723eULL, 0x000fce00000010ffULL, 0x0000003e0404723cULL, 0x000fe20000041854ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff3e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c0143e7811ULL, 0x002fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000003e0300720cULL, 0x000fe20003f24070ULL, 0x000000ffff3e7224ULL, 0x000fd800078e003fULL,
0x00004df000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff3f7984ULL, 0x000e640000000800ULL,
0x800000003fff7812ULL, 0x002fe4000782483eULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff3f7984ULL, 0x000e640000000800ULL, 0x800000003fff7812ULL, 0x002fe4000782483eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff3f7424ULL, 0x000fc800078e00ffULL, 0x0000003f00507305ULL, 0x0002a4000021f000ULL,
0x3fa000003f3f7823ULL, 0x002fe200000100ffULL, 0x000000500000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff507984ULL, 0x000e640000000800ULL, 0x8000000050ff7812ULL, 0x002fc4000782483eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000e0143e7811ULL, 0x000fe200078e40ffULL,
0x00000100ff587424ULL, 0x000fe200078e00ffULL, 0x00000004ff577819ULL, 0x000fe40000011602ULL,
0x0000003e033f7217ULL, 0x000fe20007800000ULL, 0x0000620017507a24ULL, 0x000fc800078e023eULL,
0x000000013f3f7824ULL, 0x000fe400078e0a3eULL, 0x00000001203e7824ULL, 0x100fe400078e0250ULL,
0x0000000125527824ULL, 0x000fe200078e0250ULL, 0x000000203f517807ULL, 0x000fe20000000000ULL,
0x00005e003e3e7625ULL, 0x000fc600078e0058ULL, 0x0000005116517217ULL, 0x000fe20007800000ULL,
0x0000000127537824ULL, 0x000fe200078e0250ULL, 0x000000213e547210ULL, 0x000fc60007f1e0ffULL,
0x0000000151567824ULL, 0x000fe400078e0a16ULL, 0x0000000126517824ULL, 0x000fe400078e0250ULL,
0x000000ffff557224ULL, 0x000fe200000e063fULL, 0x000000565700720cULL, 0x000fe20003f06070ULL,
0x00005e00523e7625ULL, 0x000fe200078e0058ULL, 0x000000562200720cULL, 0x080fe40003f26070ULL,
0x000000562300720cULL, 0x000fe20003f46070ULL, 0x00005e0051507625ULL, 0x000fe200078e0058ULL,
0x000000562400720cULL, 0x000fc40003f66070ULL, 0x000000213e3e7210ULL, 0x080fe20007f9e0ffULL,
0x00005e0053527625ULL, 0x000fe200078e0058ULL, 0x0000002150507210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200020e063fULL, 0x0000002152527210ULL, 0x000fe20007fde0ffULL,
0x000000ffff517224ULL, 0x000fe200028e0651ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000054287faeULL, 0x0003e6000c101c46ULL, 0x000000ffff537224ULL, 0x000fe200030e0653ULL,
0x000000003e297faeULL, 0x0005e8000c901c46ULL, 0x00000000502a7faeULL, 0x0005e8000d101c46ULL,
0x00000000522b7faeULL, 0x0005e8000d901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff3e7f8cULL, 0x004e68000c80043fULL,
0x0106ac00ff2a7984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106680016287f8cULL, 0x000fe2000c80043fULL,
0x800000002aff7812ULL, 0x004fc6000780483dULL, 0x01066c00162b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x004fe40007824829ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff2a7424ULL, 0x000fc800078e00ffULL, 0x0000002a002b7305ULL, 0x0004e4000021f000ULL,
0x3fa000002a2a7823ULL, 0x004fe200000100ffULL, 0x0000002b0000735dULL, 0x008fe40003800000ULL,
0x01066c00162b7984ULL, 0x000ea40000000800ULL, 0x800000002bff7812ULL, 0x004fc40007824829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010180002c287984ULL, 0x000ea80000000800ULL,
0x010380002c297984ULL, 0x0007220000000800ULL, 0x000000182800720bULL, 0x004fe20003f3d000ULL,
0x0000e2227f007947ULL, 0x000fd8000b800000ULL, 0x00000000002a7806ULL, 0x008fc800008e0100ULL,
0x0000ffff2a2b7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff927424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f45270ULL, 0x000000182800720bULL, 0x000fe20003f34000ULL,
0x0000e2027f007947ULL, 0x000fd8000b800000ULL, 0x00000000002a7806ULL, 0x000fe400008e0100ULL,
0x0000002818507209ULL, 0x000fe40007810000ULL, 0x0000ffff2a2a7812ULL, 0x000fe400078e3cffULL,
0x00000002ff5a7819ULL, 0x000fe20000011602ULL, 0x8000005018187221ULL, 0x000fe20000010000ULL,
0x010580502c00a388ULL, 0x0005e20000000800ULL, 0x0000002a2bff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b18187820ULL, 0x000fcc0000410000ULL, 0x0000001800187308ULL, 0x000ee40000000800ULL,
0x0000001819197220ULL, 0x008fe20000410000ULL, 0x0000e1b27f007947ULL, 0x000fea000b800000ULL,
0x00001f5a185a7589ULL, 0x0044e400000e0000ULL, 0x0000005a08087220ULL, 0x08cfe40000410000ULL,
0x0000005a09097220ULL, 0x080fe40000410000ULL, 0x0000005a0c0c7220ULL, 0x080fe40000410000ULL,
0x0000005a0d0d7220ULL, 0x080fe40000410000ULL, 0x0000005a10107220ULL, 0x000fc40000410000ULL,
0x0000005a11117220ULL, 0x080fe40000410000ULL, 0x0000005a40407220ULL, 0x080fe40000410000ULL,
0x0000005a41417220ULL, 0x080fe40000410000ULL, 0x0000005a4c4c7220ULL, 0x080fe40000410000ULL,
0x0000005a4d4d7220ULL, 0x080fe40000410000ULL, 0x0000005a48487220ULL, 0x000fc40000410000ULL,
0x0000005a49497220ULL, 0x080fe40000410000ULL, 0x0000005a44447220ULL, 0x080fe40000410000ULL,
0x0000005a45457220ULL, 0x080fe40000410000ULL, 0x0000005a04047220ULL, 0x080fe40000410000ULL,
0x0000005a05057220ULL, 0x000fe20000410000ULL, 0x0000e1027f007947ULL, 0x000fea000b800000ULL,
0x00001f2e185a7589ULL, 0x0004e400000e0000ULL, 0x8000005028281221ULL, 0x000fe20000010000ULL,
0x00000001ff927807ULL, 0x000fe20000800000ULL, 0x0000005a0a0a7220ULL, 0x00cfc40000410000ULL,
0x3fb8aa3b28281820ULL, 0x000fe40000410000ULL, 0x0000005a0b0b7220ULL, 0x080fe40000410000ULL,
0x00000028002d1308ULL, 0x000ea20000000800ULL, 0x0000005a0e0e7220ULL, 0x080fe40000410000ULL,
0x0000005a0f0f7220ULL, 0x080fe40000410000ULL, 0x0000005a12127220ULL, 0x080fe40000410000ULL,
0x0000005a13137220ULL, 0x000fc40000410000ULL, 0x0000005a42427220ULL, 0x080fe40000410000ULL,
0x0000005a43437220ULL, 0x080fe40000410000ULL, 0x0000005a4e4e7220ULL, 0x080fe40000410000ULL,
0x0000005a4f4f7220ULL, 0x080fe40000410000ULL, 0x0000005a4a4a7220ULL, 0x080fe40000410000ULL,
0x0000005a4b4b7220ULL, 0x000fc40000410000ULL, 0x0000005a46467220ULL, 0x080fe40000410000ULL,
0x0000005a47477220ULL, 0x080fe40000410000ULL, 0x0000005a06067220ULL, 0x080fe40000410000ULL,
0x0000005a07077220ULL, 0x000fe40000410000ULL, 0x000000ffff187224ULL, 0x000fe400078e0050ULL,
0x000000292d291220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000001929197221ULL, 0x010fe20000010000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106ac00ff287984ULL, 0x000ea40000000800ULL,
0x8000000028ff7812ULL, 0x004fc4000780483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff287424ULL, 0x000fc800078e00ffULL,
0x0000002800297305ULL, 0x0004e4000021f000ULL, 0x3fa0000028287823ULL, 0x004fe200000100ffULL,
0x000000290000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff297984ULL, 0x000ea40000000800ULL,
0x8000000029ff7812ULL, 0x004fe4000780483dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002dff28723eULL, 0x000fe400000010ffULL, 0x00000002ff627819ULL, 0x000fc40000011602ULL,
0x0000541028287816ULL, 0x000fe20000000028ULL, 0x0000deb27f007947ULL, 0x000fea000b800000ULL,
0x00001f6228627589ULL, 0x0004e400000e0000ULL, 0x0000df127f007947ULL, 0x000fea000b800000ULL,
0x00001f2e285d7589ULL, 0x0008a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0028ULL, 0x000106e000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fe400078e002fULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000e71000007944ULL, 0x01efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0028ULL,
0x0001075000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fe400078e0030ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000e6a000007944ULL, 0x01efea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003128783bULL, 0x014ea20000004200ULL, 0x0000991092927816ULL, 0x000fc600000000ffULL,
0x000000003254783bULL, 0x000f280000004200ULL, 0x000000003450783bULL, 0x000be80000004200ULL,
0x000000003358783bULL, 0x000ee20000004200ULL, 0x0000002800e97306ULL, 0x004fe20000009400ULL,
0x00000018ff347819ULL, 0x020fe20000011428ULL, 0x0000010028717824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fc40000011429ULL, 0x00000018ff8c7819ULL, 0x000fe4000001142bULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000002800eb7306ULL, 0x000ea20000005400ULL,
0x00000018ff8f7819ULL, 0x000fe4000001142aULL, 0x00000018ff7d7819ULL, 0x010fe40000011454ULL,
0x00000018ff797819ULL, 0x000fe40000011455ULL, 0x00000018ff6d7819ULL, 0x008fe20000011458ULL,
0x0000002800a17306ULL, 0x000722000000d400ULL, 0x00000018ff747819ULL, 0x000fc40000011456ULL,
0x00000018ff707819ULL, 0x000fe40000011457ULL, 0x00000018ff687819ULL, 0x000fe40000011459ULL,
0x00000018ff5f7819ULL, 0x000fe2000001145bULL, 0x0000003400897306ULL, 0x000fe20000209400ULL,
0x0001000028287824ULL, 0x008fe200078e00ffULL, 0x000000ebe900720bULL, 0x004fe40003f5d000ULL,
0x00000018ff647819ULL, 0x000fe4000001145aULL, 0x00000018ff287819ULL, 0x000fc40000011428ULL,
0x00000034008a7306ULL, 0x000ea20000205400ULL, 0x00000018ff5c7819ULL, 0x000fe40000011450ULL,
0x00000018ff3d7819ULL, 0x000fe40000011451ULL, 0x00000018ff317819ULL, 0x000fe40000011452ULL,
0x00000001a1a12812ULL, 0x010fe200078efcffULL, 0x0000002800ee7306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x000fce0000011453ULL, 0x0000002800ed7306ULL, 0x000ee20000205400ULL,
0x0000008a8900720bULL, 0x004fce0003fbd000ULL, 0x0000002800a07306ULL, 0x000530000020d400ULL,
0x0000007100ea7306ULL, 0x000fe20000209400ULL, 0x000001002a287824ULL, 0x004fe200078e00ffULL,
0x000000edee00720bULL, 0x008fc80003f1d000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000007100ec7306ULL, 0x000eae0000205400ULL, 0x00000001a0a00812ULL, 0x010fe200078efcffULL,
0x0000007100b07306ULL, 0x000730000020d400ULL, 0x0000002900d57306ULL, 0x000fe20000009400ULL,
0x0000010029717824ULL, 0x008fe200078e00ffULL, 0x000000ecea00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000002900d47306ULL, 0x000eae0000005400ULL,
0x00000001b0b03812ULL, 0x010fe200078efcffULL, 0x00000029009f7306ULL, 0x000730000000d400ULL,
0x0000003400347306ULL, 0x000f62000020d400ULL, 0x0001000029297824ULL, 0x008fe200078e00ffULL,
0x000000d4d500720bULL, 0x004fc80003fdd000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002800dd7306ULL, 0x000fee0000209400ULL, 0x000000019f9f6812ULL, 0x010fe200078efcffULL,
0x0000002800de7306ULL, 0x000ea20000205400ULL, 0x0000000134345812ULL, 0x020fc800078efcffULL,
0x000000a03434723eULL, 0x000fc600000010ffULL, 0x0000002900f17306ULL, 0x000ff00000209400ULL,
0x0000002900f27306ULL, 0x000ee20000205400ULL, 0x000000dedd00720bULL, 0x004fce0003fbd000ULL,
0x00000029009e7306ULL, 0x000530000020d400ULL, 0x0000002b00d87306ULL, 0x000fe20000009400ULL,
0x000001002b297824ULL, 0x004fe200078e00ffULL, 0x000000f2f100720bULL, 0x008fc80003f5d000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002b00957306ULL, 0x000eae0000005400ULL,
0x000000019e9e2812ULL, 0x010fe200078efcffULL, 0x0000002b00337306ULL, 0x0007f0000000d400ULL,
0x0000002800967306ULL, 0x000962000020d400ULL, 0x000100002b2b7824ULL, 0x008fe200078e00ffULL,
0x00000095d800720bULL, 0x004fc80003f7d000ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000002a00d77306ULL, 0x000fe20000009400ULL, 0x0000010054287824ULL, 0x010fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002b00e37306ULL, 0x000fe20000209400ULL,
0x0000000196965812ULL, 0x020fe400078efcffULL, 0x0000000133333812ULL, 0x000fca00078efcffULL,
0x0000002b00e47306ULL, 0x000eb00000205400ULL, 0x0000002a00d67306ULL, 0x000ef00000005400ULL,
0x0000002a00327306ULL, 0x000962000000d400ULL, 0x000000e4e300720bULL, 0x004fce0003fbd000ULL,
0x0000005400c27306ULL, 0x000fe20000009400ULL, 0x000100002a2a7824ULL, 0x010fe200078e00ffULL,
0x000000d6d700720bULL, 0x008fc80003f3d000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000005400c17306ULL, 0x000eae0000005400ULL, 0x0000000132321812ULL, 0x020fe200078efcffULL,
0x0000005400827306ULL, 0x000726000000d400ULL, 0x000000329632723eULL, 0x000fca00000010ffULL,
0x0000002a00e17306ULL, 0x000fe20000209400ULL, 0x0001000054547824ULL, 0x008fe200078e00ffULL,
0x000000c1c200720bULL, 0x004fc80003f7d000ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000002a00e27306ULL, 0x000eae0000205400ULL, 0x0000000182823812ULL, 0x010fe200078efcffULL,
0x0000002a00947306ULL, 0x000ef0000020d400ULL, 0x0000002b008e7306ULL, 0x000f22000020d400ULL,
0x000000e2e100720bULL, 0x004fce0003f5d000ULL, 0x0000007100ef7306ULL, 0x000fec0000209400ULL,
0x0000000194942812ULL, 0x008fe400078efcffULL, 0x0000007100f07306ULL, 0x000ea20000205400ULL,
0x000000018e8e5812ULL, 0x010fce00078efcffULL, 0x00000054002a7306ULL, 0x000ff00000209400ULL,
0x00000054002b7306ULL, 0x000ee20000205400ULL, 0x000000f0ef00720bULL, 0x004fce0003f9d000ULL,
0x0000007100b17306ULL, 0x000eb0000020d400ULL, 0x0000005400867306ULL, 0x000962000020d400ULL,
0x0000002b2a00720bULL, 0x008fce0003fbd000ULL, 0x0000005700b77306ULL, 0x000fe20000009400ULL,
0x0000010056547824ULL, 0x010fe200078e00ffULL, 0x00000001b1b14812ULL, 0x004fc800078efcffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005700b87306ULL, 0x000ea20000005400ULL,
0x0000000186865812ULL, 0x020fce00078efcffULL, 0x0000008f00cc7306ULL, 0x000ff00000209400ULL,
0x0000008f00cd7306ULL, 0x000ee20000205400ULL, 0x000000b8b700720bULL, 0x004fce0003fbd000ULL,
0x0000002900df7306ULL, 0x000ff00000209400ULL, 0x0000002900e07306ULL, 0x000ea20000205400ULL,
0x000000cdcc00720bULL, 0x008fe20003fdd000ULL, 0x000000ffffcc7224ULL, 0x000fcc00078e0092ULL,
0x0000002900937306ULL, 0x000730000020d400ULL, 0x0000008c00c57306ULL, 0x000fe20000209400ULL,
0x0000010055297824ULL, 0x008fe200078e00ffULL, 0x000000e0df00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff8d7819ULL, 0x000fe40000011429ULL, 0x0000008c00a27306ULL, 0x000eae0000205400ULL,
0x0000000193934812ULL, 0x010fe200078efcffULL, 0x0000005700737306ULL, 0x000ee6000000d400ULL,
0x000000339333723eULL, 0x000fca00000010ffULL, 0x0000008f008f7306ULL, 0x000f22000020d400ULL,
0x000000a2c500720bULL, 0x004fce0003f3d000ULL, 0x0000002800e57306ULL, 0x000fe20000209400ULL,
0x0000000173735812ULL, 0x008fce00078efcffULL, 0x0000002800e67306ULL, 0x000ea20000205400ULL,
0x000000018f8f6812ULL, 0x010fce00078efcffULL, 0x00000028008b7306ULL, 0x000ef0000020d400ULL,
0x0000005800af7306ULL, 0x000fe20000009400ULL, 0x000000e6e500720bULL, 0x004fce0003f9d000ULL,
0x0000005800a67306ULL, 0x000eac0000005400ULL, 0x000000018b8b4812ULL, 0x008fe400078efcffULL,
0x0000008d00287306ULL, 0x000fe40000209400ULL, 0x000000828b82723eULL, 0x000fcc00000010ffULL,
0x0000008d00297306ULL, 0x000ee20000205400ULL, 0x000000a6af00720bULL, 0x004fce0003fbd000ULL,
0x0000005500bf7306ULL, 0x000ff00000009400ULL, 0x0000005500c07306ULL, 0x000ea20000005400ULL,
0x000000292800720bULL, 0x008fe20003fdd000ULL, 0x0000010051287824ULL, 0x000fcc00078e00ffULL,
0x0000005500837306ULL, 0x000730000000d400ULL, 0x0000005400d97306ULL, 0x000fe20000209400ULL,
0x0001000055557824ULL, 0x008fe200078e00ffULL, 0x000000c0bf00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005400da7306ULL, 0x000eae0000205400ULL,
0x0000000183832812ULL, 0x010fe200078efcffULL, 0x0000005400817306ULL, 0x0007f0000020d400ULL,
0x00000058006e7306ULL, 0x000962000000d400ULL, 0x0000010058547824ULL, 0x008fe200078e00ffULL,
0x000000dad900720bULL, 0x004fc80003f5d000ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000008c008c7306ULL, 0x000ea2000020d400ULL, 0x0001000058587824ULL, 0x010fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000007d00bd7306ULL, 0x000fe20000209400ULL,
0x000000016e6e5812ULL, 0x020fe400078efcffULL, 0x0000000181812812ULL, 0x000fca00078efcffULL,
0x0000007d00be7306ULL, 0x000ee20000205400ULL, 0x000000018c8c1812ULL, 0x004fce00078efcffULL,
0x0000005500e77306ULL, 0x000ff00000209400ULL, 0x0000005500e87306ULL, 0x000ea20000205400ULL,
0x000000bebd00720bULL, 0x008fe40003f3d000ULL, 0x00000018ffbe7819ULL, 0x000fc40000011428ULL,
0x0000b80035287811ULL, 0x000fc600078e20ffULL, 0x0000005500807306ULL, 0x000726000020d400ULL,
0x000000002828783bULL, 0x000f6a0000000200ULL, 0x0000008d008d7306ULL, 0x000e62000020d400ULL,
0x0000010057557824ULL, 0x008fe200078e00ffULL, 0x000000e8e700720bULL, 0x004fe20003f9d000ULL,
0x0001000057577824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005600a37306ULL, 0x000fe20000009400ULL, 0x00000018ff577819ULL, 0x000fcc0000011457ULL,
0x0000000180804812ULL, 0x010fe200078efcffULL, 0x0000005600b67306ULL, 0x000ea20000005400ULL,
0x000000018d8d6812ULL, 0x002fc800078efcffULL, 0x000000838d83723eULL, 0x000fc600000010ffULL,
0x0000007900b97306ULL, 0x000ff00000209400ULL, 0x0000007900ba7306ULL, 0x000e620000205400ULL,
0x000000b6a300720bULL, 0x004fe20003f7d000ULL, 0x0001000053b67824ULL, 0x000fca00078e00ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x0000005800ce7306ULL, 0x000ff00000209400ULL,
0x0000005800cf7306ULL, 0x000ea20000205400ULL, 0x000000bab900720bULL, 0x002fe20003fdd000ULL,
0x0000010052ba7824ULL, 0x000fc400078e00ffULL, 0x0001000052b97824ULL, 0x000fc600078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x0000005600787306ULL, 0x0002e2000000d400ULL,
0x00000018ffb97819ULL, 0x000fce00000114b9ULL, 0x0000005500db7306ULL, 0x000fe20000209400ULL,
0x0001000056567824ULL, 0x002fe200078e00ffULL, 0x000000cfce00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000005500dc7306ULL, 0x000e620000205400ULL,
0x0000000178783812ULL, 0x008fc800078efcffULL, 0x000000788178723eULL, 0x000fc600000010ffULL,
0x00000055007b7306ULL, 0x0004f0000020d400ULL, 0x0000007d007d7306ULL, 0x000f22000020d400ULL,
0x0000010059557824ULL, 0x004fe200078e00ffULL, 0x000000dcdb00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000007900797306ULL, 0x000e6e000020d400ULL,
0x000000017b7b4812ULL, 0x008fe200078efcffULL, 0x0000005800757306ULL, 0x000ea2000020d400ULL,
0x000000017d7d1812ULL, 0x010fce00078efcffULL, 0x0000007400bb7306ULL, 0x000fe20000209400ULL,
0x0000000179796812ULL, 0x002fce00078efcffULL, 0x0000007400bc7306ULL, 0x000e620000205400ULL,
0x0000000175755812ULL, 0x004fce00078efcffULL, 0x0000007000a57306ULL, 0x000ff00000209400ULL,
0x0000007000a47306ULL, 0x000ea20000205400ULL, 0x000000bcbb00720bULL, 0x002fe20003f3d000ULL,
0x0000010053bb7824ULL, 0x000fca00078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x00000068009c7306ULL, 0x000ff00000209400ULL, 0x00000068009d7306ULL, 0x000e620000205400ULL,
0x000000a4a500720bULL, 0x004fce0003f7d000ULL, 0x0000005600c37306ULL, 0x000ff00000209400ULL,
0x0000005600c47306ULL, 0x000ea20000205400ULL, 0x0000009d9c00720bULL, 0x002fce0003fbd000ULL,
0x0000009900d07306ULL, 0x000ff00000209400ULL, 0x0000009900d17306ULL, 0x000e620000205400ULL,
0x000000c4c300720bULL, 0x004fce0003fdd000ULL, 0x0000005500ca7306ULL, 0x000ff00000209400ULL,
0x0000005500cb7306ULL, 0x000fe20000205400ULL, 0x000000d1d000720bULL, 0x002fce0003f1d000ULL,
0x00000055007a7306ULL, 0x0003f0000020d400ULL, 0x0000007400747306ULL, 0x000ea2000020d400ULL,
0x000001005b557824ULL, 0x002fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000007000707306ULL, 0x000e70000020d400ULL, 0x0000006800687306ULL, 0x000ee2000020d400ULL,
0x0000000174741812ULL, 0x004fce00078efcffULL, 0x00000056007c7306ULL, 0x000ea2000020d400ULL,
0x0000000170703812ULL, 0x002fce00078efcffULL, 0x0000005900ad7306ULL, 0x000fe20000009400ULL,
0x0000000168685812ULL, 0x008fce00078efcffULL, 0x0000005900ae7306ULL, 0x000e620000005400ULL,
0x000000017c7c6812ULL, 0x004fe400078efcffULL, 0x000000cbca00720bULL, 0x000fe40003fdd000ULL,
0x0000007c747c723eULL, 0x000fc600000010ffULL, 0x0000005b00aa7306ULL, 0x000ff00000009400ULL,
0x0000005b00a77306ULL, 0x000ea20000005400ULL, 0x000000aead00720bULL, 0x002fe40003f3d000ULL,
0x000000017a7a6812ULL, 0x000fca00078efcffULL, 0x0000005700c67306ULL, 0x000ff00000209400ULL,
0x0000005700c77306ULL, 0x000e620000205400ULL, 0x000000a7aa00720bULL, 0x004fce0003f7d000ULL,
0x0000005400c87306ULL, 0x000ff00000209400ULL, 0x0000005400c97306ULL, 0x000ea20000205400ULL,
0x000000c7c600720bULL, 0x002fce0003f5d000ULL, 0x0000005500977306ULL, 0x000ff00000209400ULL,
0x0000005500987306ULL, 0x000e620000205400ULL, 0x000000c9c800720bULL, 0x004fce0003f9d000ULL,
0x0000009900997306ULL, 0x000eb0000020d400ULL, 0x00000059006f7306ULL, 0x000722000000d400ULL,
0x000000989700720bULL, 0x002fce0003fbd000ULL, 0x0000005b00637306ULL, 0x000362000000d400ULL,
0x0001000059597824ULL, 0x008fe200078e00ffULL, 0x0000000199990812ULL, 0x004fe400078efcffULL,
0x000000ffcc00720cULL, 0x000fe40003f05270ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005400767306ULL, 0x0004e2000020d400ULL, 0x000100005b5b7824ULL, 0x002fe200078e00ffULL,
0x000000016f6f1812ULL, 0x010fc400078efcffULL, 0x0000009e9935723eULL, 0x000fe400000010ffULL,
0x0000006f7a6f723eULL, 0x000fe400000010ffULL, 0x0000005a00ab7306ULL, 0x000fe20000009400ULL,
0x000001005a547824ULL, 0x004fe200078e00ffULL, 0x0000000163633812ULL, 0x020fe200078efcffULL,
0x0000006228288231ULL, 0x080fe400003400ffULL, 0x000000622a2a8231ULL, 0x000fe200003400ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000005d29298231ULL, 0x080fe200003400ffULL,
0x0000005a00ac7306ULL, 0x000fe20000005400ULL, 0x0000000176764812ULL, 0x008fe200078efcffULL,
0x0000005d2b2b8231ULL, 0x000fc600003400ffULL, 0x0000006e766e723eULL, 0x000fc600000010ffULL,
0x0000005a00677306ULL, 0x0003e2000000d400ULL, 0x000000322810723cULL, 0x040fee0000041810ULL,
0x0000005700777306ULL, 0x0004e2000020d400ULL, 0x000100005a5a7824ULL, 0x002fe200078e00ffULL,
0x00000034280c723cULL, 0x000fe2000004180cULL, 0x000000867d32723eULL, 0x000fc400000010ffULL,
0x000000807933723eULL, 0x000fe400000010ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000005500587306ULL, 0x000e62000020d400ULL, 0x00000018ff577819ULL, 0x004fe2000001145bULL,
0x00000082284c723cULL, 0x040fe2000004184cULL, 0x000000948f34723eULL, 0x000fe400000010ffULL,
0x0000008e8c35723eULL, 0x000fe400000010ffULL, 0x000000737b79723eULL, 0x000fe200000010ffULL,
0x00000050009b7306ULL, 0x000fe20000009400ULL, 0x0000000177772812ULL, 0x008fe200078efcffULL,
0x000000322848723cULL, 0x000fe20000041848ULL, 0x000000acab00720bULL, 0x000fc40003f5d000ULL,
0x00000077707d723eULL, 0x000fc600000010ffULL, 0x00000050009a7306ULL, 0x000ea20000005400ULL,
0x0000000158585812ULL, 0x002fe200078efcffULL, 0x000000342840723cULL, 0x000fe60000041840ULL,
0x000000635863723eULL, 0x000fc600000010ffULL, 0x0000006d00a97306ULL, 0x000fe20000209400ULL,
0x0000000167672812ULL, 0x000fe200078efcffULL, 0x000000782844723cULL, 0x040fec0000041844ULL,
0x0000006d00a87306ULL, 0x000e620000205400ULL, 0x0000009a9b00720bULL, 0x004fe20003f3d000ULL,
0x0000007c2804723cULL, 0x000fec0000041804ULL, 0x0000005f007e7306ULL, 0x000ff00000209400ULL,
0x0000005f007f7306ULL, 0x000ea20000205400ULL, 0x000000a8a900720bULL, 0x002fce0003f9d000ULL,
0x0000005900d27306ULL, 0x000ff00000209400ULL, 0x0000005900d37306ULL, 0x000e620000205400ULL,
0x0000007f7e00720bULL, 0x004fce0003fbd000ULL, 0x00000057005b7306ULL, 0x000ff00000209400ULL,
0x0000005700957306ULL, 0x000ea20000205400ULL, 0x000000d3d200720bULL, 0x002fce0003fdd000ULL,
0x0000005900717306ULL, 0x000e70000020d400ULL, 0x0000005a00907306ULL, 0x000fe20000209400ULL,
0x000000955b00720bULL, 0x004fce0003f7d000ULL, 0x0000005a00917306ULL, 0x000ea20000205400ULL,
0x0000000171716812ULL, 0x002fc800078efcffULL, 0x000000716871723eULL, 0x000fc600000010ffULL,
0x0000005a00597306ULL, 0x0003f0000020d400ULL, 0x00000050005e7306ULL, 0x000722000000d400ULL,
0x00000100505a7824ULL, 0x002fe200078e00ffULL, 0x000000919000720bULL, 0x004fc80003f5d000ULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x0000005100b47306ULL, 0x000fe20000009400ULL,
0x0001000050507824ULL, 0x008fca00078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005100b57306ULL, 0x000fe20000005400ULL, 0x000000015e5e1812ULL, 0x010fe400078efcffULL,
0x0000000159592812ULL, 0x000fca00078efcffULL, 0x0000005100567306ULL, 0x0003f0000000d400ULL,
0x0000006d006d7306ULL, 0x000ea2000020d400ULL, 0x0001000051517824ULL, 0x002fce00078e00ffULL,
0x0000005f005f7306ULL, 0x000e70000020d400ULL, 0x0000005700577306ULL, 0x000ee2000020d400ULL,
0x000000016d6d4812ULL, 0x004fe400078efcffULL, 0x000000b5b400720bULL, 0x000fc40003f9d000ULL,
0x000000756d70723eULL, 0x000fc600000010ffULL, 0x0000005400b27306ULL, 0x000fe20000209400ULL,
0x000000015f5f5812ULL, 0x002fce00078efcffULL, 0x0000005400b37306ULL, 0x000e620000205400ULL,
0x0000000157573812ULL, 0x008fe400078efcffULL, 0x0000000156564812ULL, 0x000fca00078efcffULL,
0x0000005a00927306ULL, 0x000ff00000209400ULL, 0x0000005a00a27306ULL, 0x000ea20000205400ULL,
0x000000b3b200720bULL, 0x002fce0003fdd000ULL, 0x000000be00bd7306ULL, 0x000ff00000209400ULL,
0x000000be00b77306ULL, 0x000e620000205400ULL, 0x000000a29200720bULL, 0x004fce0003f7d000ULL,
0x0000005000b87306ULL, 0x000ff00000209400ULL, 0x0000005000a57306ULL, 0x000ea20000205400ULL,
0x000000b7bd00720bULL, 0x002fce0003fbd000ULL, 0x0000005200877306ULL, 0x000ff00000009400ULL,
0x0000005200887306ULL, 0x000e620000005400ULL, 0x000000a5b800720bULL, 0x004fce0003f3d000ULL,
0x0000005200557306ULL, 0x0005f0000000d400ULL, 0x0000005000a47306ULL, 0x000722000020d400ULL,
0x00000018ff527819ULL, 0x004fe40000011451ULL, 0x0000009fb151723eULL, 0x000fc400000010ffULL,
0x000000888700720bULL, 0x002fc60003f5d000ULL, 0x0000005400727306ULL, 0x000e62000020d400ULL,
0x000000a1b050723eULL, 0x008fce00000010ffULL, 0x0000005300897306ULL, 0x000fe20000009400ULL,
0x00000001a4a41812ULL, 0x010fe400078efcffULL, 0x0000000155552812ULL, 0x000fca00078efcffULL,
0x00000053008a7306ULL, 0x000fe20000005400ULL, 0x0000000172726812ULL, 0x002fce00078efcffULL,
0x0000005300547306ULL, 0x000ff0000000d400ULL, 0x0000005200a67306ULL, 0x000ff00000209400ULL,
0x00000052009f7306ULL, 0x000ff00000205400ULL, 0x0000005200997306ULL, 0x0003f0000020d400ULL,
0x0000005a005a7306ULL, 0x000ea2000020d400ULL, 0x000000502850723cULL, 0x002fee0000041808ULL,
0x000000be00a37306ULL, 0x000e62000020d400ULL, 0x0000b80036087811ULL, 0x000fcc00078e20ffULL,
0x000000000808783bULL, 0x000ee20000000200ULL, 0x0000006400847306ULL, 0x000fe20000209400ULL,
0x000000015a5a3812ULL, 0x004fc800078efcffULL, 0x0000005e5a5a723eULL, 0x000fc600000010ffULL,
0x0000006400857306ULL, 0x000ea20000205400ULL, 0x00000001a3a35812ULL, 0x002fe400078efcffULL,
0x0000009fa600720bULL, 0x000fe40003fbd000ULL, 0x00000056a35b723eULL, 0x000fc600000010ffULL,
0x0000005c006b7306ULL, 0x000ff00000209400ULL, 0x0000005c006c7306ULL, 0x000e620000205400ULL,
0x000000858400720bULL, 0x004fe40003fdd000ULL, 0x0000000199995812ULL, 0x000fca00078efcffULL,
0x0000003d00697306ULL, 0x000fe20000209400ULL, 0x0000006208088231ULL, 0x008fce00003400ffULL,
0x0000003d006a7306ULL, 0x000ea20000205400ULL, 0x0000006c6b00720bULL, 0x002fe20003f7d000ULL,
0x000000620a0a8231ULL, 0x000fe200003400ffULL, 0x000000677262723eULL, 0x000fe200000010ffULL,
0x0000005d09098231ULL, 0x080fe400003400ffULL, 0x0000005d0b0b8231ULL, 0x000fe400003400ffULL,
0x000000ba00967306ULL, 0x000fea0000209400ULL, 0x0000006e0850723cULL, 0x000fe60000041850ULL,
0x000000ba00367306ULL, 0x000e620000205400ULL, 0x0000006a6900720bULL, 0x004fc80003f9d000ULL,
0x00000070080c723cULL, 0x040fe6000004180cULL, 0x0000006400647306ULL, 0x000eaa000020d400ULL,
0x000000620810723cULL, 0x000fe60000041810ULL, 0x0000005c005c7306ULL, 0x000ee2000020d400ULL,
0x000000369600720bULL, 0x002fc80003f3d000ULL, 0x0000005a084c723cULL, 0x000fe6000004184cULL,
0x0000003d003d7306ULL, 0x000e62000020d400ULL, 0x0000000164646812ULL, 0x004fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe40003fdd000ULL, 0x000000596464723eULL, 0x000fc600000010ffULL,
0x000000ba00ba7306ULL, 0x000ea2000020d400ULL, 0x000000015c5c3812ULL, 0x008fc800078efcffULL,
0x000000a45c5c723eULL, 0x000fc600000010ffULL, 0x0000003100657306ULL, 0x000fe20000209400ULL,
0x000000013d3d4812ULL, 0x002fe400078efcffULL, 0x0000000154546812ULL, 0x000fe400078efcffULL,
0x000000993d5d723eULL, 0x000fc600000010ffULL, 0x0000003100667306ULL, 0x000e620000205400ULL,
0x00000001baba1812ULL, 0x004fc600078efcffULL, 0x0000005c0848723cULL, 0x000fe20000041848ULL,
0x00000055baba723eULL, 0x000fc600000010ffULL, 0x0000002c00607306ULL, 0x000ff00000209400ULL,
0x0000002c00617306ULL, 0x000ea20000205400ULL, 0x000000666500720bULL, 0x002fe40003f7d000ULL,
0x000000575f65723eULL, 0x000fca00000010ffULL, 0x000000bb00347306ULL, 0x000fe40000209400ULL,
0x000000640840723cULL, 0x000fec0000041840ULL, 0x000000bb00357306ULL, 0x000e620000205400ULL,
0x000000616000720bULL, 0x004fce0003fbd000ULL, 0x000000b900327306ULL, 0x000ff00000209400ULL,
0x000000b900287306ULL, 0x000ea20000205400ULL, 0x000000353400720bULL, 0x002fce0003f9d000ULL,
0x000000b600297306ULL, 0x000ff00000209400ULL, 0x000000b6002a7306ULL, 0x000e620000205400ULL,
0x000000283200720bULL, 0x004fce0003f3d000ULL, 0x0000003100317306ULL, 0x000eb0000020d400ULL,
0x0000002c002c7306ULL, 0x000ee2000020d400ULL, 0x0000002a2900720bULL, 0x002fce0003f5d000ULL,
0x000000bb00bb7306ULL, 0x000e62000020d400ULL, 0x0000000131313812ULL, 0x004fce00078efcffULL,
0x000000b900b97306ULL, 0x000ea2000020d400ULL, 0x000000012c2c5812ULL, 0x008fce00078efcffULL,
0x000000b600b67306ULL, 0x000ee2000020d400ULL, 0x00000001bbbb4812ULL, 0x002fc800078efcffULL,
0x00000054bbbb723eULL, 0x000fe400000010ffULL, 0x00000001b9b91812ULL, 0x004fc800078efcffULL,
0x000000b93128723eULL, 0x000fe200000010ffULL, 0x000000ba0844723cULL, 0x000fe20000041844ULL,
0x00000001b6b62812ULL, 0x008fc800078efcffULL, 0x000000b62c29723eULL, 0x000fce00000010ffULL,
0x000000280804723cULL, 0x000fe20000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff087f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe40007824809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc40007824809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a000b7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007824809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000030014087a10ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2a7424ULL, 0x000fc800078e00ffULL, 0x0000010008097824ULL, 0x040fe200078e00ffULL,
0x0000000108087810ULL, 0x000fc60007ffe0ffULL, 0x0000620017297a24ULL, 0x000fe200078e0209ULL,
0x00000009030a7217ULL, 0x000fe40007800000ULL, 0x000000150800720cULL, 0x000fe20003f26070ULL,
0x0000000120087824ULL, 0x000fe400078e0229ULL, 0x000000010a0a7824ULL, 0x000fe400078e0a09ULL,
0x00000001250b7824ULL, 0x000fe200078e0229ULL, 0x00000004ff257819ULL, 0x000fe20000011602ULL,
0x00005e0008087625ULL, 0x000fe200078e002aULL, 0x000000200a0a7807ULL, 0x000fc60000800000ULL,
0x0000000127277824ULL, 0x000fe200078e0229ULL, 0x0000000a16207217ULL, 0x000fe20007800000ULL,
0x00005e000b0a7625ULL, 0x000fe200078e002aULL, 0x0000002108287210ULL, 0x000fc60007f3e0ffULL,
0x0000000120207824ULL, 0x000fe200078e0a16ULL, 0x000000210a0a7210ULL, 0x080fe20007f7e0ffULL,
0x0000000126087824ULL, 0x000fe400078e0229ULL, 0x000000ffff297224ULL, 0x000fe200008e0609ULL,
0x000000202500720cULL, 0x000fe20003f46070ULL, 0x00005e0008087625ULL, 0x000fe200078e002aULL,
0x000000202200720cULL, 0x080fe40003f26070ULL, 0x000000202400720cULL, 0x000fe20003f86070ULL,
0x00005e0027267625ULL, 0x000fe200078e002aULL, 0x0000002108087210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e060bULL, 0x000000202300720cULL, 0x000fe20003f66070ULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x0000002126207210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028377faeULL, 0x0003e8000d101c46ULL,
0x000000ffff217224ULL, 0x000fe200030e0627ULL, 0x000000000a387faeULL, 0x0003ea000c901c46ULL,
0x0000000008397faeULL, 0x0005e8000d901c46ULL, 0x00000000203a7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x002fec0000008000ULL,
0x0106a800ff087f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc4000782483fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0009ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe4000782483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x0106b400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc4000782483fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002dff08723eULL, 0x000fe400000010ffULL, 0x00000002ff647819ULL, 0x000fe40000011602ULL,
0x0000541008087816ULL, 0x000fe20000000008ULL, 0x0000bb727f007947ULL, 0x000fea000b800000ULL,
0x00001f64086e7589ULL, 0x0002a400000e0000ULL, 0x0000bbc27f007947ULL, 0x000fea000b800000ULL,
0x00001f2e08717589ULL, 0x00072400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff647224ULL, 0x002fe200078e002fULL, 0x00012b2000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fe400078e0008ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x0000c2d000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0008ULL,
0x00012b9000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x002fc400078e0030ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000c26000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003b38783bULL, 0x000f620000004200ULL, 0x0000b8001d1d7811ULL, 0x000fc600078e20ffULL,
0x000000003c20783bULL, 0x000e680000004200ULL, 0x000000001a08783bULL, 0x00ae680000004200ULL,
0x000000001b24783bULL, 0x000ee20000004200ULL, 0x00000100385f7824ULL, 0x020fe200078e00ffULL,
0x0000003800b97306ULL, 0x000fe20000009400ULL, 0x00000018ff867819ULL, 0x000fc40000011439ULL,
0x00000018ff8f7819ULL, 0x000fe40000011438ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x00000018ff7a7819ULL, 0x000fe2000001143aULL, 0x0000003800837306ULL, 0x000f620000005400ULL,
0x00000018ff6b7819ULL, 0x000fe40000011420ULL, 0x00000018ff617819ULL, 0x000fe40000011421ULL,
0x00000018ff737819ULL, 0x000fc4000001143bULL, 0x00000018ff587819ULL, 0x000fe20000011423ULL,
0x0000005f00bb7306ULL, 0x000fe20000209400ULL, 0x00000018ff5e7819ULL, 0x000fe40000011422ULL,
0x00000018ff567819ULL, 0x002fe40000011408ULL, 0x00000018ff367819ULL, 0x000fe40000011409ULL,
0x00000018ff357819ULL, 0x000fe2000001140aULL, 0x0000005f00bc7306ULL, 0x000e620000205400ULL,
0x00000083b900720bULL, 0x020fc40003f5d000ULL, 0x00000018ff2f7819ULL, 0x000fe4000001140bULL,
0x00000018ff2c7819ULL, 0x008fe40000011424ULL, 0x00000018ff2a7819ULL, 0x000fe20000011425ULL,
0x0000005f00a37306ULL, 0x000762000020d400ULL, 0x00000018ff287819ULL, 0x000fe40000011426ULL,
0x00000018ff1a7819ULL, 0x000fca0000011427ULL, 0x0000003900b57306ULL, 0x000fe20000009400ULL,
0x00000100395f7824ULL, 0x008fe200078e00ffULL, 0x000000bcbb00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000039006d7306ULL, 0x000e6e0000005400ULL,
0x00000001a3a36812ULL, 0x020fe200078efcffULL, 0x0000003900927306ULL, 0x0007f0000000d400ULL,
0x0000003800937306ULL, 0x000b22000000d400ULL, 0x0001000039397824ULL, 0x008fe200078e00ffULL,
0x0000006db500720bULL, 0x002fc80003f3d000ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000008f00b87306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x020fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003900c27306ULL, 0x000fe20000209400ULL,
0x0000000193932812ULL, 0x010fe400078efcffULL, 0x0000000192921812ULL, 0x000fca00078efcffULL,
0x0000003900c17306ULL, 0x000e700000205400ULL, 0x0000003800bd7306ULL, 0x000ff00000209400ULL,
0x0000003800be7306ULL, 0x000ee20000205400ULL, 0x000000c1c200720bULL, 0x002fce0003f5d000ULL,
0x0000003800a27306ULL, 0x0003f0000020d400ULL, 0x00000039008b7306ULL, 0x000962000020d400ULL,
0x000001003a387824ULL, 0x002fe200078e00ffULL, 0x000000bebd00720bULL, 0x008fc80003fbd000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000008f00897306ULL, 0x000e620000205400ULL,
0x000001003b397824ULL, 0x010fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000007a00b67306ULL, 0x000fe20000209400ULL, 0x000000018b8b2812ULL, 0x020fe400078efcffULL,
0x00000001a2a25812ULL, 0x000fca00078efcffULL, 0x0000007a00b37306ULL, 0x000ee20000205400ULL,
0x00000089b800720bULL, 0x002fce0003f7d000ULL, 0x0000003800c47306ULL, 0x000ff00000209400ULL,
0x0000003800c37306ULL, 0x000e620000205400ULL, 0x000000b3b600720bULL, 0x008fce0003f5d000ULL,
0x00000038008a7306ULL, 0x000730000020d400ULL, 0x0000002000a97306ULL, 0x000fe20000009400ULL,
0x0000010020387824ULL, 0x008fe200078e00ffULL, 0x000000c3c400720bULL, 0x002fc80003fbd000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000002000aa7306ULL, 0x000fee0000005400ULL,
0x000000018a8a5812ULL, 0x010fe200078efcffULL, 0x0000002000727306ULL, 0x0003f0000000d400ULL,
0x0000008f008f7306ULL, 0x000ee2000020d400ULL, 0x0001000020207824ULL, 0x002fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000007a007a7306ULL, 0x000e70000020d400ULL,
0x0000003a00b07306ULL, 0x000fe20000009400ULL, 0x000000018f8f3812ULL, 0x008fce00078efcffULL,
0x0000003a00b17306ULL, 0x000ee20000005400ULL, 0x000000017a7a2812ULL, 0x002fce00078efcffULL,
0x0000002100a87306ULL, 0x000ff00000009400ULL, 0x0000002100ac7306ULL, 0x000e620000005400ULL,
0x000000b1b000720bULL, 0x008fce0003f7d000ULL, 0x0000003900c67306ULL, 0x000ff00000209400ULL,
0x0000003900c57306ULL, 0x000fe20000205400ULL, 0x000000aca800720bULL, 0x002fce0003f5d000ULL,
0x00000039007e7306ULL, 0x0003f0000020d400ULL, 0x0000002100687306ULL, 0x000722000000d400ULL,
0x0000010021397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003b00ae7306ULL, 0x000fe20000009400ULL, 0x0001000021217824ULL, 0x008fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000003b008c7306ULL, 0x000e620000005400ULL,
0x0000000168682812ULL, 0x010fce00078efcffULL, 0x0000003b007b7306ULL, 0x000730000000d400ULL,
0x0000002000d57306ULL, 0x000fe20000209400ULL, 0x000100003b3b7824ULL, 0x008fe200078e00ffULL,
0x0000008cae00720bULL, 0x002fc80003f3d000ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000002000d67306ULL, 0x000fee0000205400ULL, 0x000000017b7b1812ULL, 0x010fe200078efcffULL,
0x0000002000777306ULL, 0x0003e2000020d400ULL, 0x000000aaa900720bULL, 0x000fe20003f3d000ULL,
0x0000010026a97824ULL, 0x000fc400078e00ffULL, 0x0001000026aa7824ULL, 0x000fc600078e00ffULL,
0x00000018ffa97819ULL, 0x000fe200000114a9ULL, 0x0000003a00827306ULL, 0x000722000000d400ULL,
0x0000010022207824ULL, 0x002fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fc800000114aaULL,
0x00000018ff6f7819ULL, 0x000fe40000011420ULL, 0x0000002100db7306ULL, 0x000fe20000209400ULL,
0x000100003a3a7824ULL, 0x008fe200078e00ffULL, 0x0000000172721812ULL, 0x000fc800078efcffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000002100dc7306ULL, 0x000fe20000205400ULL,
0x0000000182823812ULL, 0x010fc800078efcffULL, 0x000000828a8a723eULL, 0x000fc600000010ffULL,
0x0000002100707306ULL, 0x000ff0000020d400ULL, 0x0000003b00cb7306ULL, 0x000ff00000209400ULL,
0x0000003b00cc7306ULL, 0x000e700000205400ULL, 0x0000006f00217306ULL, 0x000ff00000209400ULL,
0x0000006f00207306ULL, 0x000ee20000205400ULL, 0x000000cccb00720bULL, 0x002fce0003f7d000ULL,
0x0000003800cf7306ULL, 0x000ff00000209400ULL, 0x0000003800d07306ULL, 0x000fe20000205400ULL,
0x000000202100720bULL, 0x008fce0003f5d000ULL, 0x0000003800787306ULL, 0x0003f0000020d400ULL,
0x00000023009e7306ULL, 0x000fe20000009400ULL, 0x0000010023387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000023009b7306ULL, 0x000ff00000005400ULL,
0x00000023005c7306ULL, 0x0003f0000000d400ULL, 0x0000005f00c07306ULL, 0x000fe20000209400ULL,
0x0001000023237824ULL, 0x002fca00078e00ffULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000005f00bf7306ULL, 0x000e700000205400ULL, 0x0000002200a67306ULL, 0x000ff00000009400ULL,
0x0000002200a57306ULL, 0x000fe20000005400ULL, 0x000000bfc000720bULL, 0x002fce0003f9d000ULL,
0x0000002200647306ULL, 0x0003f0000000d400ULL, 0x0000003b00797306ULL, 0x000ee2000020d400ULL,
0x0001000022227824ULL, 0x002fca00078e00ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000006f006f7306ULL, 0x000e70000020d400ULL, 0x0000002300d47306ULL, 0x000fe20000209400ULL,
0x0000000179793812ULL, 0x008fc400078efcffULL, 0x000000a5a600720bULL, 0x000fca0003f7d000ULL,
0x0000002300d37306ULL, 0x000ee20000205400ULL, 0x000000016f6f2812ULL, 0x002fce00078efcffULL,
0x0000002200ce7306ULL, 0x000fe20000209400ULL, 0x0000000164643812ULL, 0x000fce00078efcffULL,
0x0000002200cd7306ULL, 0x000fe20000205400ULL, 0x000000d3d400720bULL, 0x008fce0003f5d000ULL,
0x00000022006c7306ULL, 0x0003f0000020d400ULL, 0x0000005f00a47306ULL, 0x000ee2000020d400ULL,
0x0000010008227824ULL, 0x002fca00078e00ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000002300657306ULL, 0x000330000020d400ULL, 0x0000008600ba7306ULL, 0x000fe20000209400ULL,
0x0000010009237824ULL, 0x002fe200078e00ffULL, 0x00000001a4a44812ULL, 0x008fc400078efcffULL,
0x000000c5c600720bULL, 0x000fe40003f9d000ULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000008600b77306ULL, 0x000e620000205400ULL, 0x0000000165652812ULL, 0x010fce00078efcffULL,
0x00000058009a7306ULL, 0x000fe20000209400ULL, 0x000000017e7e4812ULL, 0x000fe400078efcffULL,
0x000000d0cf00720bULL, 0x000fca0003f9d000ULL, 0x0000005800a07306ULL, 0x000ee20000205400ULL,
0x000000b7ba00720bULL, 0x002fce0003fdd000ULL, 0x0000002200da7306ULL, 0x000fe20000209400ULL,
0x0000000178784812ULL, 0x000fe400078efcffULL, 0x000000d6d500720bULL, 0x000fe40003f9d000ULL,
0x000000727872723eULL, 0x000fc600000010ffULL, 0x0000002200d87306ULL, 0x000e620000205400ULL,
0x000000a09a00720bULL, 0x008fce0003f7d000ULL, 0x0000000800a17306ULL, 0x000fe20000009400ULL,
0x0000000177774812ULL, 0x000fce00078efcffULL, 0x00000008009d7306ULL, 0x000fe20000005400ULL,
0x000000d8da00720bULL, 0x002fce0003f5d000ULL, 0x00000008005a7306ULL, 0x0043f0000000d400ULL,
0x0000000900997306ULL, 0x000fe20000009400ULL, 0x0001000008087824ULL, 0x002fca00078e00ffULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x0000000900957306ULL, 0x000ff00000005400ULL,
0x00000009003f7306ULL, 0x0003f0000000d400ULL, 0x0000007300b47306ULL, 0x000fe20000209400ULL,
0x0001000009097824ULL, 0x002fca00078e00ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x0000007300b27306ULL, 0x000e700000205400ULL, 0x0000008600867306ULL, 0x000eb0000020d400ULL,
0x0000005800587306ULL, 0x000ee2000020d400ULL, 0x000000b2b400720bULL, 0x002fce0003fbd000ULL,
0x0000002200667306ULL, 0x000e62000020d400ULL, 0x0000000186866812ULL, 0x004fce00078efcffULL,
0x0000000800e07306ULL, 0x000fe20000209400ULL, 0x0000000158583812ULL, 0x008fc800078efcffULL,
0x000000655865723eULL, 0x000fc600000010ffULL, 0x0000000800df7306ULL, 0x000ea20000205400ULL,
0x0000000166662812ULL, 0x002fce00078efcffULL, 0x0000000800607306ULL, 0x0002f0000020d400ULL,
0x0000003a00c77306ULL, 0x000fe20000209400ULL, 0x000001000a087824ULL, 0x002fe200078e00ffULL,
0x000000dfe000720bULL, 0x004fc80003f5d000ULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x0000003a00c87306ULL, 0x000e6e0000205400ULL, 0x0000000160602812ULL, 0x008fe200078efcffULL,
0x0000002300dd7306ULL, 0x000ff00000209400ULL, 0x0000002300de7306ULL, 0x000ea20000205400ULL,
0x000000c8c700720bULL, 0x002fce0003fdd000ULL, 0x0000003a00817306ULL, 0x000e70000020d400ULL,
0x0000000900d97306ULL, 0x000fe20000209400ULL, 0x000000dedd00720bULL, 0x004fce0003f7d000ULL,
0x0000000900d77306ULL, 0x000fe20000205400ULL, 0x0000000181816812ULL, 0x002fc800078efcffULL,
0x000000817a7a723eULL, 0x000fc600000010ffULL, 0x00000009003a7306ULL, 0x0003f0000020d400ULL,
0x00000008008e7306ULL, 0x000fe20000209400ULL, 0x000001000b097824ULL, 0x002fca00078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000008008d7306ULL, 0x000e700000205400ULL,
0x00000008003b7306ULL, 0x0004f0000020d400ULL, 0x0000007300737306ULL, 0x000f22000020d400ULL,
0x0000010024087824ULL, 0x004fe200078e00ffULL, 0x0000008d8e00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x0000006b00af7306ULL, 0x000fee0000209400ULL,
0x000000013b3b2812ULL, 0x008fe200078efcffULL, 0x0000006b00ad7306ULL, 0x000e620000205400ULL,
0x0000000173735812ULL, 0x010fce00078efcffULL, 0x0000003800c97306ULL, 0x000ff00000209400ULL,
0x0000003800ca7306ULL, 0x000ea20000205400ULL, 0x000000adaf00720bULL, 0x002fce0003fbd000ULL,
0x0000003800677306ULL, 0x000e70000020d400ULL, 0x00000023005f7306ULL, 0x000ee2000020d400ULL,
0x000000cac900720bULL, 0x004fce0003f9d000ULL, 0x0000000a00967306ULL, 0x000fec0000009400ULL,
0x0000000167674812ULL, 0x002fe400078efcffULL, 0x0000000a00987306ULL, 0x000fe20000005400ULL,
0x000000015f5f3812ULL, 0x008fe400078efcffULL, 0x000000d7d900720bULL, 0x000fc40003f7d000ULL,
0x0000009da100720bULL, 0x000fc60003f9d000ULL, 0x0000000a003e7306ULL, 0x0003f0000000d400ULL,
0x0000000b00947306ULL, 0x000fe20000009400ULL, 0x000100000a0a7824ULL, 0x002fe200078e00ffULL,
0x000000013a3a3812ULL, 0x000fc400078efcffULL, 0x000000015a5a4812ULL, 0x000fe400078efcffULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x0000000b00977306ULL, 0x000fe20000005400ULL,
0x0000005a665a723eULL, 0x000fce00000010ffULL, 0x0000000b00337306ULL, 0x0003f0000000d400ULL,
0x0000006100ab7306ULL, 0x000fe20000209400ULL, 0x000100000b0b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x0000006100a77306ULL, 0x000e700000205400ULL,
0x0000003900d27306ULL, 0x000ff00000209400ULL, 0x0000003900d17306ULL, 0x000ea20000205400ULL,
0x000000a7ab00720bULL, 0x002fe20003f3d000ULL, 0x0000010027ab7824ULL, 0x000fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x0000000900887306ULL, 0x000ff00000209400ULL,
0x0000000900877306ULL, 0x000e620000205400ULL, 0x000000d1d200720bULL, 0x004fce0003fdd000ULL,
0x0000000900387306ULL, 0x0004f0000020d400ULL, 0x0000000800b07306ULL, 0x000fe20000209400ULL,
0x0000010025097824ULL, 0x004fe200078e00ffULL, 0x000000878800720bULL, 0x002fc80003f7d000ULL,
0x00000018ff227819ULL, 0x000fe40000011409ULL, 0x0000000800ae7306ULL, 0x000fee0000205400ULL,
0x0000000138383812ULL, 0x008fe200078efcffULL, 0x00000008008c7306ULL, 0x0003f0000020d400ULL,
0x0000006b006b7306ULL, 0x000ea2000020d400ULL, 0x0000b8001c087811ULL, 0x002fc400078e20ffULL,
0x00000093a31c723eULL, 0x000fca00000010ffULL, 0x0000003900767306ULL, 0x000e70000020d400ULL,
0x0000000a007f7306ULL, 0x000fe20000209400ULL, 0x000000016b6b5812ULL, 0x004fe400078efcffULL,
0x0000009b9e00720bULL, 0x000fca0003fbd000ULL, 0x0000000a00807306ULL, 0x000ea20000205400ULL,
0x0000000176766812ULL, 0x002fe400078efcffULL, 0x000000dcdb00720bULL, 0x000fca0003fdd000ULL,
0x0000000a00397306ULL, 0x000e62000020d400ULL, 0x000000015c5c5812ULL, 0x000fe400078efcffULL,
0x000000959900720bULL, 0x000fca0003fbd000ULL, 0x0000000b00837306ULL, 0x000fe20000209400ULL,
0x000000807f00720bULL, 0x004fe40003f5d000ULL, 0x0000000170706812ULL, 0x000fe400078efcffULL,
0x000000cdce00720bULL, 0x000fc60003fdd000ULL, 0x0000000b00897306ULL, 0x000ea20000205400ULL,
0x000000013f3f5812ULL, 0x000fca00078efcffULL, 0x0000000139392812ULL, 0x002fe400078efcffULL,
0x0000000b006d7306ULL, 0x0002e2000020d400ULL, 0x000000aeb000720bULL, 0x000fe40003f5d000ULL,
0x000000016c6c6812ULL, 0x000fe400078efcffULL, 0x000000989600720bULL, 0x000fc60003fdd000ULL,
0x0000002200a87306ULL, 0x000fe20000209400ULL, 0x000000000808783bULL, 0x002e620000000200ULL,
0x000000898300720bULL, 0x004fc80003f7d000ULL, 0x000000018c8c2812ULL, 0x000fe400078efcffULL,
0x0000002200a67306ULL, 0x000ea40000205400ULL, 0x000000013e3e6812ULL, 0x000fc800078efcffULL,
0x0000003e3b3e723eULL, 0x000fe400000010ffULL, 0x0000002200a57306ULL, 0x000962000020d400ULL,
0x000000016d6d3812ULL, 0x008fce00078efcffULL, 0x0000006100617306ULL, 0x000ee2000020d400ULL,
0x000000001d20783bULL, 0x0108620000000200ULL, 0x000000a6a800720bULL, 0x004fcc0003f7d000ULL,
0x0000005e009c7306ULL, 0x000fe20000209400ULL, 0x00000092a41d723eULL, 0x010fcc00000010ffULL,
0x00000001a5a53812ULL, 0x020fe200078efcffULL, 0x0000005e009f7306ULL, 0x000ea20000205400ULL,
0x0000000161611812ULL, 0x008fe200078efcffULL, 0x0000006e08088231ULL, 0x082fe400003400ffULL,
0x0000006e0a0a8231ULL, 0x000fe400003400ffULL, 0x0000007109098231ULL, 0x080fe400003400ffULL,
0x0000005e005e7306ULL, 0x000e62000020d400ULL, 0x000000710b0b8231ULL, 0x000fe200003400ffULL,
0x0000009f9c00720bULL, 0x004fcc0003f3d000ULL, 0x0000002400907306ULL, 0x000fe20000009400ULL,
0x0000001c0850723cULL, 0x000fee0000041850ULL, 0x0000002400917306ULL, 0x000ea20000005400ULL,
0x0000006e20208231ULL, 0x080fe200003400ffULL, 0x000000776b1c723eULL, 0x000fe200000010ffULL,
0x0000006e22228231ULL, 0x000fe200003400ffULL, 0x000000015e5e1812ULL, 0x002fe200078efcffULL,
0x0000007121218231ULL, 0x080fe200003400ffULL, 0x000000979400720bULL, 0x000fe20003f3d000ULL,
0x0000007123238231ULL, 0x000fe200003400ffULL, 0x0000002400317306ULL, 0x0002e2000000d400ULL,
0x00000070611d723eULL, 0x000fce00000010ffULL, 0x0000005600847306ULL, 0x000fe20000209400ULL,
0x0001000024247824ULL, 0x002fe200078e00ffULL, 0x000000919000720bULL, 0x004fe20003f1d000ULL,
0x0000001c0848723cULL, 0x000fe20000041848ULL, 0x0000000133331812ULL, 0x000fe400078efcffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000005600857306ULL, 0x000e6e0000205400ULL,
0x0000000131310812ULL, 0x008fe200078efcffULL, 0x00000036007c7306ULL, 0x000fe60000209400ULL,
0x000000318c8c723eULL, 0x000fca00000010ffULL, 0x00000036007d7306ULL, 0x000ea20000205400ULL,
0x000000858400720bULL, 0x002fce0003f9d000ULL, 0x0000002f005b7306ULL, 0x000ff00000209400ULL,
0x0000002f005d7306ULL, 0x000e620000205400ULL, 0x0000007d7c00720bULL, 0x004fce0003fbd000ULL,
0x0000002400a77306ULL, 0x000ff00000209400ULL, 0x00000024009b7306ULL, 0x000ea20000205400ULL,
0x0000005d5b00720bULL, 0x002fe40003f3d000ULL, 0x0000003f5f5b723eULL, 0x000fc400000010ffULL,
0x00000033383f723eULL, 0x000fc600000010ffULL, 0x0000002500747306ULL, 0x000ff00000009400ULL,
0x0000002500757306ULL, 0x000fe20000005400ULL, 0x0000009ba700720bULL, 0x004fce0003f5d000ULL,
0x00000025002b7306ULL, 0x0003f0000000d400ULL, 0x0000005600567306ULL, 0x000ea2000020d400ULL,
0x0001000025257824ULL, 0x002fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002600697306ULL, 0x000ff00000009400ULL, 0x00000026006a7306ULL, 0x000fe20000005400ULL,
0x0000000156564812ULL, 0x004fc400078efcffULL, 0x000000757400720bULL, 0x000fe40003f9d000ULL,
0x000000605656723eULL, 0x000fc600000010ffULL, 0x0000002600297306ULL, 0x000ff0000000d400ULL,
0x0000002400267306ULL, 0x0002a2000020d400ULL, 0x000000012b2b4812ULL, 0x000fc800078efcffULL,
0x0000002ba58d723eULL, 0x000fc600000010ffULL, 0x0000002500947306ULL, 0x000fe20000209400ULL,
0x000000a28f24723eULL, 0x002fce00000010ffULL, 0x0000002500927306ULL, 0x000e620000205400ULL,
0x0000000126262812ULL, 0x004fce00078efcffULL, 0x00000025006e7306ULL, 0x0005f0000020d400ULL,
0x0000002f002f7306ULL, 0x000ee2000020d400ULL, 0x0000008b8625723eULL, 0x004fe400000010ffULL,
0x0000007b7e8b723eULL, 0x000fc400000010ffULL, 0x00000079737b723eULL, 0x000fe400000010ffULL,
0x000000687673723eULL, 0x000fe200000010ffULL, 0x0000003500627306ULL, 0x000fe20000209400ULL,
0x00000024080c723cULL, 0x000fe2000004180cULL, 0x000000929400720bULL, 0x002fcc0003f7d000ULL,
0x0000003500637306ULL, 0x000e620000205400ULL, 0x000000646f24723eULL, 0x000fe200000010ffULL,
0x0000008a0810723cULL, 0x040fe20000041810ULL, 0x0000005c6725723eULL, 0x000fe400000010ffULL,
0x000000012f2f1812ULL, 0x008fe400078efcffULL, 0x0000006c5e64723eULL, 0x000fe200000010ffULL,
0x0000002c00547306ULL, 0x000fe20000209400ULL, 0x000000016e6e3812ULL, 0x000fe200078efcffULL,
0x000000240844723cULL, 0x000fe20000041844ULL, 0x0000006d2f6d723eULL, 0x000fca00000010ffULL,
0x0000002c00557306ULL, 0x000ea20000205400ULL, 0x000000636200720bULL, 0x002fe20003fdd000ULL,
0x0000007a0840723cULL, 0x040fec0000041840ULL, 0x0000002a00377306ULL, 0x000fe40000209400ULL,
0x00000072084c723cULL, 0x040fec000004184cULL, 0x0000002a003c7306ULL, 0x000e620000205400ULL,
0x000000555400720bULL, 0x004fe20003f3d000ULL, 0x000000640804723cULL, 0x000fec0000041804ULL,
0x000000a900717306ULL, 0x000fe40000209400ULL, 0x0000005a2008723cULL, 0x040fec0000041850ULL,
0x000000a9007c7306ULL, 0x000ea20000205400ULL, 0x0000003c3700720bULL, 0x002fe20003f1d000ULL,
0x0000003e2010723cULL, 0x040fec0000041810ULL, 0x0000002700577306ULL, 0x000fe40000009400ULL,
0x0000008c204c723cULL, 0x000fec000004184cULL, 0x0000002700597306ULL, 0x000fe20000005400ULL,
0x0000007c7100720bULL, 0x004fce0003f5d000ULL, 0x00000027001b7306ULL, 0x0003f0000000d400ULL,
0x0000003600367306ULL, 0x000ea2000020d400ULL, 0x0001000027277824ULL, 0x002fca00078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000003500357306ULL, 0x000e70000020d400ULL,
0x0000002c002c7306ULL, 0x000ee2000020d400ULL, 0x0000000136365812ULL, 0x004fc400078efcffULL,
0x0000006a6900720bULL, 0x000fca0003fbd000ULL, 0x0000002a002a7306ULL, 0x000ea2000020d400ULL,
0x0000000135356812ULL, 0x002fe400078efcffULL, 0x000000595700720bULL, 0x000fe40003fdd000ULL,
0x0000003a3657723eULL, 0x000fe400000010ffULL, 0x00000039356c723eULL, 0x000fe200000010ffULL,
0x000000a900a97306ULL, 0x000e62000020d400ULL, 0x000000012c2c1812ULL, 0x008fe400078efcffULL,
0x0000000129295812ULL, 0x000fe200078efcffULL, 0x00000056200c723cULL, 0x000fe2000004180cULL,
0x000000262c26723eULL, 0x000fc600000010ffULL, 0x0000002800327306ULL, 0x000fe20000209400ULL,
0x000000012a2a0812ULL, 0x004fe400078efcffULL, 0x000000011b1b6812ULL, 0x000fe200078efcffULL,
0x0000006c2040723cULL, 0x000fe80000041840ULL, 0x0000002800347306ULL, 0x000ea20000205400ULL,
0x00000001a9a92812ULL, 0x002fce00078efcffULL, 0x0000001a002e7306ULL, 0x000ff00000209400ULL,
0x0000001a00307306ULL, 0x000e620000205400ULL, 0x000000343200720bULL, 0x004fce0003f9d000ULL,
0x000000ab00687306ULL, 0x000ff00000209400ULL, 0x000000ab00617306ULL, 0x000ea20000205400ULL,
0x000000302e00720bULL, 0x002fce0003f3d000ULL, 0x000000aa001c7306ULL, 0x000ff00000209400ULL,
0x000000aa001d7306ULL, 0x000e620000205400ULL, 0x000000616800720bULL, 0x004fce0003f7d000ULL,
0x0000002700247306ULL, 0x000ff00000209400ULL, 0x0000002700257306ULL, 0x000ea20000205400ULL,
0x0000001d1c00720bULL, 0x002fe40003f1d000ULL, 0x00000029a91c723eULL, 0x000fca00000010ffULL,
0x0000002800287306ULL, 0x000e70000020d400ULL, 0x0000001a001a7306ULL, 0x000ee2000020d400ULL,
0x000000252400720bULL, 0x004fce0003f5d000ULL, 0x000000ab00ab7306ULL, 0x000ea2000020d400ULL,
0x0000000128284812ULL, 0x002fce00078efcffULL, 0x000000aa00aa7306ULL, 0x000e62000020d400ULL,
0x000000011a1a1812ULL, 0x008fce00078efcffULL, 0x00000027002b7306ULL, 0x000722000020d400ULL,
0x00000001abab3812ULL, 0x004fc800078efcffULL, 0x0000001bab1d723eULL, 0x000fe400000010ffULL,
0x00000001aaaa0812ULL, 0x002fe400078efcffULL, 0x0000006e2a27723eULL, 0x008fe400000010ffULL,
0x000000aa2828723eULL, 0x000fe200000010ffULL, 0x0000001c2044723cULL, 0x000fe20000041844ULL,
0x000000012b2b2812ULL, 0x010fc800078efcffULL, 0x0000002b1a29723eULL, 0x000fc600000010ffULL,
0x000000262048723cULL, 0x040ff00000041848ULL, 0x000000282004723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff1a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff3e7224ULL, 0x002fc600078e001bULL,
0x0000030014147a10ULL, 0x000fc80007ffe0ffULL, 0x000000151400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffec37000007947ULL, 0x000fea000383ffffULL,
0x0000000000247919ULL, 0x000ee20000002500ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0013ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1d7224ULL, 0x004fe400078e0011ULL,
0x000000ffff237224ULL, 0x000fe400078e0007ULL, 0x000000ffff227224ULL, 0x000fe400078e0006ULL,
0x000000ffff217224ULL, 0x000fc400078e0005ULL, 0x000000ffff207224ULL, 0x000fe400078e0004ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x002fe400078e000fULL,
0x000000ffff1a7224ULL, 0x000fe400078e000eULL, 0x000000ffff177224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000cULL, 0x000000152400720cULL, 0x008fe20003f06070ULL,
0x000000ffff157224ULL, 0x000fc400078e000bULL, 0x000000ffff147224ULL, 0x000fe400078e000aULL,
0x000000ffff127224ULL, 0x000fe400078e0009ULL, 0x000000ffff117224ULL, 0x000fcc00078e0008ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000019027810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff337224ULL, 0x000fe200078e0019ULL, 0x00014b7000067802ULL, 0x000fe40000000f00ULL,
0x0000a0c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0002ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001900047308ULL, 0x000e640000001000ULL,
0xbf80000004027423ULL, 0x002fc80000000019ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000204047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006600ff027624ULL, 0x000fe400078e00ffULL, 0x00006700ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x0004e8000c1e9900ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x004fe20000011605ULL, 0x0000000402027220ULL, 0x008fe20000410000ULL,
0x0000000805047811ULL, 0x000fc800078ff0ffULL, 0x00001f0302037589ULL, 0x000ea800000e0000ULL,
0x00001f0402047589ULL, 0x000ee200000e0000ULL, 0x0000001103117220ULL, 0x044fe40000410000ULL,
0x0000001203127220ULL, 0x040fe40000410000ULL, 0x0000001303137220ULL, 0x040fe40000410000ULL,
0x0000001703177220ULL, 0x000fc40000410000ULL, 0x0000001c031c7220ULL, 0x040fe40000410000ULL,
0x0000001d031d7220ULL, 0x040fe40000410000ULL, 0x0000004003407220ULL, 0x040fe40000410000ULL,
0x0000004103417220ULL, 0x040fe40000410000ULL, 0x0000004c034c7220ULL, 0x040fe40000410000ULL,
0x0000004d034d7220ULL, 0x000fc40000410000ULL, 0x0000004803487220ULL, 0x040fe40000410000ULL,
0x0000004903497220ULL, 0x040fe40000410000ULL, 0x0000004403447220ULL, 0x040fe40000410000ULL,
0x0000004503457220ULL, 0x040fe40000410000ULL, 0x0000002003207220ULL, 0x040fe40000410000ULL,
0x0000002103217220ULL, 0x000fc40000410000ULL, 0x0000001404147220ULL, 0x048fe40000410000ULL,
0x0000001504157220ULL, 0x040fe40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x040fe40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x000fc40000410000ULL, 0x0000004204427220ULL, 0x040fe40000410000ULL,
0x0000004304437220ULL, 0x040fe40000410000ULL, 0x0000004e044e7220ULL, 0x040fe40000410000ULL,
0x0000004f044f7220ULL, 0x040fe40000410000ULL, 0x0000004a044a7220ULL, 0x040fe40000410000ULL,
0x0000004b044b7220ULL, 0x000fc40000410000ULL, 0x0000004604467220ULL, 0x040fe40000410000ULL,
0x0000004704477220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fe40000410000ULL, 0x0000000000027919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000202037812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011602ULL, 0x00000001ff047819ULL, 0x000fe40000011603ULL,
0x0000000203057811ULL, 0x040fe400078ff8ffULL, 0x0000000403087811ULL, 0x040fe400078ff8ffULL,
0x00000006030c7811ULL, 0x000fe400078ff8ffULL, 0x0000000802107811ULL, 0x000fc400078ff0ffULL,
0x0000000704037812ULL, 0x100fe400078e780eULL, 0x0000000705067812ULL, 0x140fe400078e780eULL,
0x00000007080a7812ULL, 0x000fe200078e780eULL, 0x000000080e077824ULL, 0x000fe200078e0203ULL,
0x0000000708087812ULL, 0x000fe200078e7810ULL, 0x000000080e097824ULL, 0x000fe200078e0206ULL,
0x000000070c0d7812ULL, 0x000fe200078e780eULL, 0x0000080000037824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x000fe200078e7810ULL, 0x00000008100f7824ULL, 0x000fe200078e0208ULL,
0x0000000705057812ULL, 0x000fe200078e7810ULL, 0x000000080e0b7824ULL, 0x000fe200078e020aULL,
0x000000070c067812ULL, 0x000fe200078e7810ULL, 0x000000080e0d7824ULL, 0x000fc400078e020dULL,
0x00000008100c7824ULL, 0x000fe200078e0204ULL, 0x0000a00003047810ULL, 0x000fe20007ffe0ffULL,
0x0000000802087824ULL, 0x000fe400078e00ffULL, 0x00000008100e7824ULL, 0x000fe200078e0205ULL,
0x000000111205723eULL, 0x000fe200000010ffULL, 0x0000000810107824ULL, 0x000fe200078e0206ULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x000000131706723eULL, 0x000fe200000010ffULL, 0x00000010090a7824ULL, 0x000fc400078e0204ULL,
0x000000100b0b7824ULL, 0x000fe200078e0204ULL, 0x0000541005127816ULL, 0x040fe20000000006ULL,
0x000000100c0c7824ULL, 0x000fe200078e0204ULL, 0x0000763205137816ULL, 0x000fe20000000006ULL,
0x000000100e0e7824ULL, 0x100fe200078e0204ULL, 0x0000004c4d05723eULL, 0x000fe200000010ffULL,
0x000000100d0d7824ULL, 0x100fe400078e0204ULL, 0x000000100f0f7824ULL, 0x100fe400078e0204ULL,
0x0000001010107824ULL, 0x000fc400078e0204ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x0000001c1d07723eULL, 0x000fe200000010ffULL, 0x00000001080a7824ULL, 0x040fe400078e020aULL,
0x00000001080b7824ULL, 0x040fe200078e020bULL, 0x0000001209007388ULL, 0x0005e20000000a00ULL,
0x00000001080c7824ULL, 0x040fe400078e020cULL, 0x00000001080e7824ULL, 0x040fe400078e020eULL,
0x00000001080d7824ULL, 0x000fc400078e020dULL, 0x00000001080f7824ULL, 0x040fe400078e020fULL,
0x0000000108107824ULL, 0x000fe200078e0210ULL, 0x000000404108723eULL, 0x000fe400000010ffULL,
0x000000141509723eULL, 0x004fe200000010ffULL, 0x00000300ff147624ULL, 0x000fe200078e00ffULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe40000000008ULL,
0x000000202108723eULL, 0x000fc400000010ffULL, 0x000000011400780cULL, 0x000fe20003f05270ULL,
0x000000060a007388ULL, 0x0005e40000000a00ULL, 0x000000484906723eULL, 0x004fe400000010ffULL,
0x000000444507723eULL, 0x000fe400000010ffULL, 0x0000001a1b0a723eULL, 0x000fe400000010ffULL,
0x0000541005127816ULL, 0x140fe40000000006ULL, 0x0000763205137816ULL, 0x000fc40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000120b007388ULL, 0x000fe20000000a00ULL, 0x0000541009087816ULL, 0x140fe4000000000aULL,
0x0000763209097816ULL, 0x000fe2000000000aULL, 0x000000060d007388ULL, 0x0005e20000000a00ULL,
0x0000001e1f05723eULL, 0x000fe400000010ffULL, 0x00000022230a723eULL, 0x000fe200000010ffULL,
0x000000080c007388ULL, 0x0007e20000000a00ULL, 0x000000424306723eULL, 0x004fc400000010ffULL,
0x0000004e4f07723eULL, 0x000fe400000010ffULL, 0x0000004a4b08723eULL, 0x008fe400000010ffULL,
0x000000464709723eULL, 0x000fe400000010ffULL, 0x00005410050c7816ULL, 0x140fe40000000006ULL,
0x00007632050d7816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000000c0e007388ULL, 0x0005e20000000a00ULL,
0x0000541009087816ULL, 0x140fe4000000000aULL, 0x0000763209097816ULL, 0x000fe2000000000aULL,
0x000000060f007388ULL, 0x0005e80000000a00ULL, 0x0000000810007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b4000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x004ea20000002700ULL, 0x0000001002057824ULL, 0x000fe200078e0203ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00001000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x00000020020e7810ULL, 0x040fe40007ffe0ffULL,
0x000000ff0200720cULL, 0x000fe20000725670ULL, 0x00a00000051c7984ULL, 0x000ee80000000c00ULL,
0x00a2000005207984ULL, 0x0008640000000c00ULL, 0x0000580014057a24ULL, 0x010fc800078e02ffULL,
0x0000640005077a24ULL, 0x000fe400078e02ffULL, 0x0000580010107a24ULL, 0x004fc600078e0206ULL,
0x00000fff07067811ULL, 0x040fe400078e40ffULL, 0x01ffffff07077812ULL, 0x000fe200078ec0ffULL,
0x0000030010057a24ULL, 0x000fc800078e02ffULL, 0x00000001050a7824ULL, 0x000fca00078e0224ULL,
0x0000000a06087211ULL, 0x000fca00078fa0ffULL, 0x00006a0008087625ULL, 0x000fcc00078e0009ULL,
0x0000040000087825ULL, 0x000fcc00078e0008ULL, 0x000000100e0e7825ULL, 0x000fc800078e0008ULL,
0x00000010020c7825ULL, 0x000fe200078e0008ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x00afe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011602ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0207ULL,
0x0000007008127812ULL, 0x000fe400078ec0ffULL, 0x0000000c09137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a087625ULL, 0x000fc800078e0011ULL, 0x00006a000b0a7625ULL, 0x000fe200078e0011ULL,
0x0000000813087210ULL, 0x000fc80007b5e012ULL, 0x0000000a130a7210ULL, 0x000fe40007d9e012ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000001808007986ULL, 0x0003e8000c101906ULL, 0x000000190a007986ULL, 0x0003e4000c101906ULL,
0x0000001c0c007986ULL, 0x00a3e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000200e007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff087424ULL, 0x000fe200078e00ffULL,
0xffffffff140a7810ULL, 0x000fc60007ffe0ffULL, 0x0000680010087625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000a080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000a0800720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff097807ULL, 0x000fca0000800000ULL,
0x00000009ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x000ee40000000000ULL,
0x000000ff0800720cULL, 0x008fda0003f25270ULL, 0x0000278000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001002087824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x004fe20000011602ULL, 0x00000080ff127424ULL, 0x000fe200078e00ffULL,
0x00000001050a7810ULL, 0x000fe40007ffe0ffULL, 0x0000007008137812ULL, 0x000fe400078ec0ffULL,
0x0000000c09157812ULL, 0x000fe200078ec0ffULL, 0x00006a0005087625ULL, 0x000fc800078e0012ULL,
0x00006a000a0a7625ULL, 0x000fe200078e0012ULL, 0x0000000815087210ULL, 0x000fc8000791e013ULL,
0x0000000a150a7210ULL, 0x000fe40007b5e013ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x00000006080c7981ULL, 0x002368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x000000021400780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000205087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000815087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080e7981ULL, 0x000362000c1e1900ULL,
0x000000041400780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000305087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000815087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000041400780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000405087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000815087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608107981ULL, 0x000362000c1e1900ULL,
0x000000061400780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000505087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000815087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000061400780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081400780cULL, 0x002fe40003f06070ULL,
0x0000000605087810ULL, 0x000fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000815087210ULL, 0x000fe40007a3e013ULL, 0x00000007050a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006a000a0a0625ULL, 0x000fe400078e0012ULL,
0x0000000608127981ULL, 0x000366000c1e1900ULL, 0x0000000a150a0210ULL, 0x000fc80007c7e013ULL,
0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL, 0x000000060a130981ULL, 0x000368000c1e1900ULL,
0x0000000714087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x020fe400078e000cULL,
0x000000080b157824ULL, 0x040fe200078e00ffULL, 0x000000010b0b7810ULL, 0x000fc80007ffe0ffULL,
0x0000030015007a0cULL, 0x000fe40003f26070ULL, 0x0000000a0b00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000815087810ULL, 0x040fe40007ffe0ffULL,
0x0000000115097810ULL, 0x004fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000140c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff177819ULL, 0x000fe20000011602ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001002147824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007014147812ULL, 0x000fc800078ec0ffULL,
0x0000000817087210ULL, 0x000fc80007b3e014ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608147981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000915087810ULL, 0x042fe40007ffe0ffULL, 0x0000000215097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff177819ULL, 0x000fe20000011602ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010020d7824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000817087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000315097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000e0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff177819ULL, 0x000fe20000011602ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010020e7824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000817087210ULL, 0x000fc80007b3e00eULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080e7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000415097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff177819ULL, 0x000fe20000011602ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010020f7824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000817087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000515097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000100c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff177819ULL, 0x000fe20000011602ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001002107824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010107812ULL, 0x000fc800078ec0ffULL,
0x0000000817087210ULL, 0x000fc80007b3e010ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608107981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000615097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000110c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff177819ULL, 0x000fe20000011602ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001002117824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000817087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000715097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000120c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff177819ULL, 0x000fe20000011602ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001002127824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007012127812ULL, 0x000fc800078ec0ffULL,
0x0000000817087210ULL, 0x000fc80007b3e012ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608127981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f15087810ULL, 0x002fe40007ffe0ffULL, 0x000000130c0c7209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011602ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001002137824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007a3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000ee40000000000ULL,
0x0000001002087824ULL, 0x00afe200078e00ffULL, 0x00000001ff097819ULL, 0x004fc80000011602ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108087824ULL, 0x000fca00078e0209ULL, 0x0000000c08007388ULL, 0x0203e40000000800ULL,
0x0000000506087211ULL, 0x002fe200078fa0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00001000ff097424ULL, 0x004fe200078e00ffULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x00000010020a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011602ULL,
0x00006a0008087625ULL, 0x000fe200078e0009ULL, 0x00000016ff437819ULL, 0x000fe20000011600ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000700a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000040000427824ULL, 0x040fe200078e00ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000100000227824ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x0000004208087210ULL, 0x000fe20007f3e0ffULL,
0x000000010a197824ULL, 0x000fe200078e020bULL, 0x00000020020a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001050c8824ULL, 0x000fe200078e0207ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200008e0643ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0d8424ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0e8424ULL, 0x000fe200078e00ffULL, 0x0000000019197984ULL, 0x000e620000000800ULL,
0x00006a000c0c8625ULL, 0x000fe200078e000dULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000100a0a7825ULL, 0x000fe200078e0008ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000001002107824ULL, 0x000fe400078e0222ULL,
0x0000001000118824ULL, 0x000fe400078e0202ULL, 0x0000001002087825ULL, 0x000fc600078e0008ULL,
0x0000458011118811ULL, 0x000fe200078e20ffULL, 0x00006a00050e8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008107faeULL, 0x0005e6000b901c46ULL,
0x0000001000128824ULL, 0x000fe200078e0202ULL, 0x003800000a107faeULL, 0x0007e2000b901c46ULL,
0x00000010020c8825ULL, 0x000fc800078e000cULL, 0x00000010020e8825ULL, 0x000fe200078e000eULL,
0x000000000c118faeULL, 0x0009e2000b901c46ULL, 0x0000418012098811ULL, 0x004fe400078e20ffULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x008fe2000001ff00ULL,
0x000000000e098faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x004fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000cf000009947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x002fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fca00078e00ffULL, 0x0000000134357810ULL, 0x000fc80007ffe0ffULL,
0x0000030035007a0cULL, 0x000fda0003f06070ULL, 0x0000023000000947ULL, 0x000fea0003800000ULL,
0x0000000105217824ULL, 0x000fe200078e0235ULL, 0x000000070200780cULL, 0x000fe20003f24070ULL,
0x00001000ff1b7424ULL, 0x000fe200078e00ffULL, 0x0000000135207812ULL, 0x040fe200078ec0ffULL,
0x00000800351c7824ULL, 0x000fe200078e00ffULL, 0x00000021061a7211ULL, 0x000fe400078fa0ffULL,
0x0000002002387810ULL, 0x000fe40007ffe0ffULL, 0x000008001c1e7812ULL, 0x000fe200078ec0ffULL,
0x00006a001a1a7625ULL, 0x000fc800078e001bULL, 0x00000001071d9824ULL, 0x000fe200078e0221ULL,
0x000000421a1a7210ULL, 0x000fe20007f1e0ffULL, 0x00000080ff369424ULL, 0x000fe400078e00ffULL,
0x00000002001f9824ULL, 0x140fe400078e0220ULL, 0x0000000200399824ULL, 0x000fe400078e0220ULL,
0x00006a001d1c9625ULL, 0x000fc800078e0036ULL, 0x00000080ff209424ULL, 0x000fe400078e00ffULL,
0x00000001221e7824ULL, 0x000fe400078e021eULL, 0x000000011b1b7824ULL, 0x000fe400000e0643ULL,
0x000000081f379824ULL, 0x000fe400078e0202ULL, 0x00006a0021209625ULL, 0x000fc600078e0020ULL,
0x0000458037379811ULL, 0x000fe200078e20ffULL, 0x0000001002367824ULL, 0x040fe400078e021eULL,
0x0000000839399824ULL, 0x000fe400078e0202ULL, 0x00000010021e9825ULL, 0x000fc800078e001cULL,
0x00000010381c7825ULL, 0x000fe200078e001aULL, 0x0000418039389811ULL, 0x000fc600078e20ffULL,
0x00000010021a7825ULL, 0x000fc800078e001aULL, 0x0000001002209825ULL, 0x000fe200078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800001a367faeULL, 0x0003e8000b901c46ULL,
0x003800001c367faeULL, 0x0003e8000b901c46ULL, 0x000000001e379faeULL, 0x0003e8000b901c46ULL,
0x0000000020389faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff377224ULL, 0x002fe200078e0034ULL, 0x00000001ff1c7819ULL, 0x100fe20000011602ULL,
0x00000010021b7824ULL, 0x000fe200078e00ffULL, 0x00000002ff447819ULL, 0x000fe20000011602ULL,
0x00000080371a7824ULL, 0x000fe200078e00ffULL, 0x0000000c1c1c7812ULL, 0x000fc400078ec0ffULL,
0x000000701b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000008441d7824ULL, 0x000fe200078e00ffULL,
0x000000801a1a7812ULL, 0x000fe400078ec0ffULL, 0x00000044ff367212ULL, 0x000fe400078e33ffULL,
0x0000000744347812ULL, 0x000fe200078ec0ffULL, 0x00000100001a7824ULL, 0x000fe200078e021aULL,
0xfffffff81d367812ULL, 0x000fe400078ee236ULL, 0x0000000844457810ULL, 0x000fc40007ffe0ffULL,
0x0000001a1c1a7210ULL, 0x000fe20007ffe01bULL, 0x00000008441b7824ULL, 0x000fe200078e00ffULL,
0x00000045ff3f7212ULL, 0x000fe200078e33ffULL, 0x0000000845387824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180001a1c7984ULL, 0x000e620000000800ULL,
0x000000011b1d7812ULL, 0x100fe200078ef634ULL, 0x0000000845397824ULL, 0x000fe200078e00ffULL,
0x000000021b1e7812ULL, 0x140fe200078ef634ULL, 0x004580001a417984ULL, 0x0004e20000000800ULL,
0x000000031b1f7812ULL, 0x140fe400078ef634ULL, 0x000000041b207812ULL, 0x140fe400078ef634ULL,
0x000000051b217812ULL, 0x000fe400078ef634ULL, 0xfffffff8383f7812ULL, 0x000fe200078ee23fULL,
0x00000008441a7824ULL, 0x004fca00078e00ffULL, 0xfffffff81a1a7812ULL, 0x100fe400078ee234ULL,
0x000000061b347812ULL, 0x000fe200078ef634ULL, 0x00000800371b7824ULL, 0x000fca00078e00ffULL,
0x000008001b1b7812ULL, 0x000fc800078ec0ffULL, 0x00000180221b7810ULL, 0x000fca0007ffe01bULL,
0x000000101a1a7824ULL, 0x100fe400078e021bULL, 0x0000001036367824ULL, 0x100fe400078e021bULL,
0x000000101d1d7824ULL, 0x100fe400078e021bULL, 0x0000001c191c7221ULL, 0x002fe40000010100ULL,
0x000000101e1e7824ULL, 0x000fe400078e021bULL, 0x3fb8aa3b1c377820ULL, 0x000fc40000410000ULL,
0x00000004021c7824ULL, 0x000fe400078e00ffULL, 0x0000003700407308ULL, 0x0002e20000000800ULL,
0x000000101f1f7824ULL, 0x100fe400078e021bULL, 0x0000000c1c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000001020207824ULL, 0x100fe400078e021bULL, 0x0000001021217824ULL, 0x000fe400078e021bULL,
0x000000011a1a7824ULL, 0x000fe200078e021cULL, 0x0000000745377812ULL, 0x002fe200078ec0ffULL,
0x000000011c367824ULL, 0x000fc400078e0236ULL, 0x000000011c1d7824ULL, 0x000fe200078e021dULL,
0xfffffff838387812ULL, 0x100fe200078ee237ULL, 0x000000011c1e7824ULL, 0x000fe200078e021eULL,
0x00000001393a7812ULL, 0x140fe200078ef637ULL, 0x0000004140407220ULL, 0x008fe20000410000ULL,
0x00000002393b7812ULL, 0x140fe200078ef637ULL, 0x0000000036417984ULL, 0x000fe20000000800ULL,
0x00000003393c7812ULL, 0x040fe200078ef637ULL, 0x000000011c1f7824ULL, 0x040fe200078e021fULL,
0x00000004393d7812ULL, 0x140fe200078ef637ULL, 0x000000001d367984ULL, 0x000fe20000000800ULL,
0x00000005393e7812ULL, 0x140fe200078ef637ULL, 0x000000011c207824ULL, 0x040fe200078e0220ULL,
0x0000000639377812ULL, 0x000fe200078ef637ULL, 0x00001f44401d7589ULL, 0x000fe200000e0000ULL,
0x000000011c217824ULL, 0x000fc400078e0221ULL, 0x0000001034347824ULL, 0x100fe200078e021bULL,
0x000000001a397984ULL, 0x000e620000000800ULL, 0x0000001038387824ULL, 0x100fe400078e021bULL,
0x000000011c347824ULL, 0x040fe200078e0234ULL, 0x000000001e1e7984ULL, 0x000ea20000000800ULL,
0x000000011c387824ULL, 0x000fe400078e0238ULL, 0x000000103a3a7824ULL, 0x100fe200078e021bULL,
0x000000001f1f7984ULL, 0x000ee20000000800ULL, 0x000000103b3b7824ULL, 0x000fc400078e021bULL,
0x000000011c3a7824ULL, 0x040fe200078e023aULL, 0x0000000020207984ULL, 0x000f220000000800ULL,
0x000000011c3b7824ULL, 0x000fe400078e023bULL, 0x0000003340337221ULL, 0x000fe20000010000ULL,
0x0000000021217984ULL, 0x000f620000000800ULL, 0x000000103c3c7824ULL, 0x100fe400078e021bULL,
0x000000103d3d7824ULL, 0x000fe200078e021bULL, 0x0000000034347984ULL, 0x000ea20000000800ULL,
0x000000011c3c7824ULL, 0x000fc400078e023cULL, 0x000000011c3d7824ULL, 0x000fe200078e023dULL,
0x0000000038387984ULL, 0x000ea20000000800ULL, 0x000000103e3e7824ULL, 0x100fe400078e021bULL,
0x0000001037377824ULL, 0x000fe200078e021bULL, 0x000000003a3a7984ULL, 0x000fe20000000800ULL,
0x000000011c3e7824ULL, 0x040fe400078e023eULL, 0x000000011c377824ULL, 0x000fe200078e0237ULL,
0x00001f4540407589ULL, 0x000ea200000e0000ULL, 0x000000103f3f7824ULL, 0x000fc600078e021bULL,
0x000000003b3b7984ULL, 0x000ea20000000800ULL, 0x000000011c3f7824ULL, 0x000fe200078e023fULL,
0x00005410ff1a7816ULL, 0x102fe40000000039ULL, 0x000000003c3c7984ULL, 0x000e660000000800ULL,
0x0000001d1a327223ULL, 0x080fe20000010032ULL, 0x00007610ff1a7816ULL, 0x000fe20000000039ULL,
0x000000003d3d7984ULL, 0x000e680000000800ULL, 0x0000001d1a317223ULL, 0x080fe20000010031ULL,
0x00005410ff1a7816ULL, 0x100fe20000000041ULL, 0x000000003e3e7984ULL, 0x000e680000000800ULL,
0x0000001d1a247223ULL, 0x080fe20000010024ULL, 0x00007610ff1a7816ULL, 0x000fe20000000041ULL,
0x0000000037377984ULL, 0x000e680000000800ULL, 0x0000001d1a237223ULL, 0x080fe20000010023ULL,
0x00005410ff1a7816ULL, 0x000fe20000000036ULL, 0x000000003f3f7984ULL, 0x000e680000000800ULL,
0x0000001d1a307223ULL, 0x000fe20000010030ULL, 0x00007610ff1a7816ULL, 0x000fca0000000036ULL,
0x0000001d1a2f7223ULL, 0x000fe2000001002fULL, 0x00005410ff1a7816ULL, 0x004fca000000001eULL,
0x0000001d1a2e7223ULL, 0x000fe2000001002eULL, 0x00007610ff1a7816ULL, 0x000fca000000001eULL,
0x0000001d1a2d7223ULL, 0x000fe2000001002dULL, 0x00005410ff1a7816ULL, 0x008fca000000001fULL,
0x0000001d1a2c7223ULL, 0x000fe2000001002cULL, 0x00007610ff1a7816ULL, 0x000fca000000001fULL,
0x0000001d1a2b7223ULL, 0x000fe2000001002bULL, 0x00005410ff1a7816ULL, 0x010fca0000000020ULL,
0x0000001d1a2a7223ULL, 0x000fe2000001002aULL, 0x00007610ff1a7816ULL, 0x000fca0000000020ULL,
0x0000001d1a297223ULL, 0x000fe20000010029ULL, 0x00005410ff1a7816ULL, 0x020fca0000000021ULL,
0x0000001d1a287223ULL, 0x000fe20000010028ULL, 0x00007610ff1a7816ULL, 0x000fca0000000021ULL,
0x0000001d1a277223ULL, 0x000fe20000010027ULL, 0x00005410ff1a7816ULL, 0x000fca0000000034ULL,
0x0000001d1a267223ULL, 0x000fe20000010026ULL, 0x00007610ff1a7816ULL, 0x000fe20000000034ULL,
0x000000ffff347224ULL, 0x000fc800078e0035ULL, 0x0000001d1a257223ULL, 0x000fe20000010025ULL,
0x00005410ff1a7816ULL, 0x000fe40000000038ULL, 0x0000030034007a0cULL, 0x000fc60003f06070ULL,
0x000000401a187223ULL, 0x000fe20000010018ULL, 0x00007610ff1a7816ULL, 0x000fca0000000038ULL,
0x000000401a177223ULL, 0x000fe20000010017ULL, 0x00005410ff1a7816ULL, 0x000fca000000003aULL,
0x000000401a157223ULL, 0x000fe20000010015ULL, 0x00007610ff1a7816ULL, 0x000fca000000003aULL,
0x000000401a147223ULL, 0x000fe20000010014ULL, 0x00005410ff1a7816ULL, 0x000fca000000003bULL,
0x000000401a137223ULL, 0x000fe20000010013ULL, 0x00007610ff1a7816ULL, 0x000fca000000003bULL,
0x000000401a127223ULL, 0x000fe20000010012ULL, 0x00005410ff1a7816ULL, 0x002fca000000003cULL,
0x000000401a117223ULL, 0x000fe20000010011ULL, 0x00007610ff1a7816ULL, 0x000fca000000003cULL,
0x000000401a107223ULL, 0x000fe20000010010ULL, 0x00005410ff1a7816ULL, 0x000fca000000003dULL,
0x000000401a0f7223ULL, 0x000fe2000001000fULL, 0x00007610ff1a7816ULL, 0x000fca000000003dULL,
0x000000401a0e7223ULL, 0x000fe2000001000eULL, 0x00005410ff1a7816ULL, 0x000fca000000003eULL,
0x000000401a0d7223ULL, 0x000fe2000001000dULL, 0x00007610ff1a7816ULL, 0x000fca000000003eULL,
0x000000401a0c7223ULL, 0x000fe2000001000cULL, 0x00005410ff1a7816ULL, 0x000fca0000000037ULL,
0x000000401a0b7223ULL, 0x000fe2000001000bULL, 0x00007610ff1a7816ULL, 0x000fca0000000037ULL,
0x000000401a0a7223ULL, 0x000fe2000001000aULL, 0x00005410ff1a7816ULL, 0x000fca000000003fULL,
0x000000401a097223ULL, 0x000fe20000010009ULL, 0x00007610ff1a7816ULL, 0x000fca000000003fULL,
0x000000401a087223ULL, 0x000fe20000010008ULL, 0xfffff33000008947ULL, 0x000fea000383ffffULL,
0x0180000033007810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000000007812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0001760000067802ULL, 0x000fe40000000f00ULL, 0x0000763000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0002ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300007308ULL, 0x000e640000001000ULL, 0xbf80000000337423ULL, 0x002fc80000000033ULL,
0x800000ff33337221ULL, 0x000fc80000010100ULL, 0x0000003300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff197819ULL, 0x004fe20000011602ULL,
0x00000004021f7824ULL, 0x040fe200078e00ffULL, 0x00000008021e7811ULL, 0x000fe400078ff0ffULL,
0x00000019ff067212ULL, 0x000fe200078e33ffULL, 0x00001f1900057589ULL, 0x000ea200000e0000ULL,
0x0000001eff1d7212ULL, 0x000fe200078e33ffULL, 0x000000081e077824ULL, 0x040fe200078e00ffULL,
0x000000071e1c7812ULL, 0x000fe200078ec0ffULL, 0x00001f1e00007589ULL, 0x000ee200000e0000ULL,
0x0000000819207824ULL, 0x000fe200078e00ffULL, 0x0000000c1f1f7812ULL, 0x000fc400078ec0ffULL,
0xfffffff8071d7812ULL, 0x000fe400078ee21dULL, 0x0000000719077812ULL, 0x040fe400078ec0ffULL,
0xfffffff820207812ULL, 0x000fe200078ee206ULL, 0x0000000819067824ULL, 0x000fe200078e00ffULL,
0x000000041c1a7812ULL, 0x040fe200078e3cffULL, 0x000000101d1d7824ULL, 0x000fe200078e0204ULL,
0x000000051c1b7812ULL, 0x000fe400078e3cffULL, 0xfffffff806067812ULL, 0x000fe200078ee219ULL,
0x000000081e1a7824ULL, 0x000fc400078e021aULL, 0x000000081e1b7824ULL, 0x000fe400078e021bULL,
0x0000001006067824ULL, 0x000fe400078e0204ULL, 0x0000003205327220ULL, 0x044fe40000410000ULL,
0x0000003105317220ULL, 0x000fe40000410000ULL, 0x0000001800187220ULL, 0x048fe40000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x000000323131723eULL, 0x000fe200000010ffULL,
0x0000001500157220ULL, 0x000fc40000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x0000001300137220ULL, 0x000fe20000410000ULL,
0x000000021c187812ULL, 0x000fe200078e3cffULL, 0x0000001200127220ULL, 0x000fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000010ffULL, 0x0000001100117220ULL, 0x040fe40000410000ULL,
0x0000001000107220ULL, 0x000fe20000410000ULL, 0x000000131212723eULL, 0x000fe200000010ffULL,
0x0000000f000f7220ULL, 0x000fc40000410000ULL, 0x0000000e000e7220ULL, 0x000fe20000410000ULL,
0x000000111010723eULL, 0x000fe200000010ffULL, 0x0000000d000d7220ULL, 0x040fe20000410000ULL,
0x0000000607117812ULL, 0x040fe200078e3cffULL, 0x0000000c000c7220ULL, 0x000fe20000410000ULL,
0x0000000f0e0e723eULL, 0x000fe200000010ffULL, 0x0000000b000b7220ULL, 0x040fe20000410000ULL,
0x00000005070f7812ULL, 0x040fe200078e3cffULL, 0x0000000a000a7220ULL, 0x000fe20000410000ULL,
0x0000000d0c0c723eULL, 0x000fe200000010ffULL, 0x0000000900097220ULL, 0x040fe20000410000ULL,
0x00000004070d7812ULL, 0x040fe200078e3cffULL, 0x0000000800007220ULL, 0x000fe20000410000ULL,
0x0000000107087812ULL, 0x000fe200078e3cffULL, 0x000000081e137824ULL, 0x000fe200078e00ffULL,
0x0000000b0a0a723eULL, 0x000fe200000010ffULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x000000090000723eULL, 0x000fe200000010ffULL, 0x0000002f052f7220ULL, 0x000fe20000410000ULL,
0x0000000207097812ULL, 0x000fe200078e3cffULL, 0x0000002e052e7220ULL, 0x000fe20000410000ULL,
0x00000003070b7812ULL, 0x000fe200078e3cffULL, 0x0000000819077824ULL, 0x000fe200078e0208ULL,
0xfffffff813137812ULL, 0x000fe200078ee21eULL, 0x0000000819087824ULL, 0x000fe200078e0209ULL,
0x000000302f2f723eULL, 0x000fe200000010ffULL, 0x0000000819097824ULL, 0x000fc400078e020bULL,
0x00000008190b7824ULL, 0x040fe400078e020dULL, 0x00000008190d7824ULL, 0x040fe400078e020fULL,
0x00000008190f7824ULL, 0x000fe200078e0211ULL, 0x000000011c117812ULL, 0x040fe200078e3cffULL,
0x0000002d052d7220ULL, 0x000fe20000410000ULL, 0x000000031c197812ULL, 0x040fe200078e3cffULL,
0x0000001007077824ULL, 0x000fe200078e0204ULL, 0x000000061c1c7812ULL, 0x000fe200078e3cffULL,
0x0000002c052c7220ULL, 0x000fe20000410000ULL, 0x0000002e2d2d723eULL, 0x000fe200000010ffULL,
0x0000002b052b7220ULL, 0x000fc40000410000ULL, 0x0000001008087824ULL, 0x100fe400078e0204ULL,
0x0000002a052a7220ULL, 0x000fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000010ffULL,
0x0000002905297220ULL, 0x000fe40000410000ULL, 0x0000001009097824ULL, 0x000fe400078e0204ULL,
0x0000002805287220ULL, 0x000fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000010ffULL,
0x0000002705277220ULL, 0x000fc40000410000ULL, 0x000000011f067824ULL, 0x000fe400078e0206ULL,
0x000000100b0b7824ULL, 0x100fe200078e0204ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000003106007388ULL, 0x0005e20000000800ULL,
0x0000002505257220ULL, 0x040fe40000410000ULL, 0x0000002405247220ULL, 0x000fe40000410000ULL,
0x000000081e157824ULL, 0x000fe200078e0211ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x000000100d0d7824ULL, 0x000fc400078e0204ULL, 0x000000011f077824ULL, 0x000fe400078e0207ULL,
0x0000002305057220ULL, 0x000fe40000410000ULL, 0x000000081e187824ULL, 0x040fe200078e0218ULL,
0x0000002f07007388ULL, 0x0005e20000000800ULL, 0x000000100f0f7824ULL, 0x000fe200078e0204ULL,
0x000000240505723eULL, 0x000fe200000010ffULL, 0x000000011f087824ULL, 0x000fe400078e0208ULL,
0x000000081e197824ULL, 0x000fc400078e0219ULL, 0x0000001020117824ULL, 0x100fe200078e0204ULL,
0x0000002d08007388ULL, 0x0005e20000000800ULL, 0x000000011f097824ULL, 0x000fe400078e0209ULL,
0x0000001013137824ULL, 0x100fe400078e0204ULL, 0x000000011f0b7824ULL, 0x000fe200078e020bULL,
0x0000002b09007388ULL, 0x0005e20000000800ULL, 0x0000001015157824ULL, 0x000fe400078e0204ULL,
0x000000011f0d7824ULL, 0x000fe200078e020dULL, 0x000000290b007388ULL, 0x0005e20000000800ULL,
0x000000081e1c7824ULL, 0x000fc400078e021cULL, 0x0000001018187824ULL, 0x100fe200078e0204ULL,
0x000000270d007388ULL, 0x0005e20000000800ULL, 0x000000011f0f7824ULL, 0x000fe400078e020fULL,
0x0000001019197824ULL, 0x100fe400078e0204ULL, 0x000000011f117824ULL, 0x040fe200078e0211ULL,
0x000000250f007388ULL, 0x0005e20000000800ULL, 0x000000101a1a7824ULL, 0x100fe400078e0204ULL,
0x000000011f137824ULL, 0x000fe200078e0213ULL, 0x0000000511007388ULL, 0x0005e20000000800ULL,
0x000000101b1b7824ULL, 0x000fc400078e0204ULL, 0x000000011f157824ULL, 0x040fe200078e0215ULL,
0x0000001713007388ULL, 0x0005e20000000800ULL, 0x000000101c1c7824ULL, 0x000fe400078e0204ULL,
0x000000011f187824ULL, 0x040fe200078e0218ULL, 0x0000001415007388ULL, 0x0005e20000000800ULL,
0x000000011f197824ULL, 0x040fe400078e0219ULL, 0x000000011f1a7824ULL, 0x040fe200078e021aULL,
0x0000001218007388ULL, 0x0005e20000000800ULL, 0x000000011f1b7824ULL, 0x000fc400078e021bULL,
0x000000011f1c7824ULL, 0x040fe200078e021cULL, 0x0000001019007388ULL, 0x0005e20000000800ULL,
0x000000011f1d7824ULL, 0x000fc600078e021dULL, 0x0000000e1a007388ULL, 0x0005e80000000800ULL,
0x0000000c1b007388ULL, 0x0005e80000000800ULL, 0x0000000a1c007388ULL, 0x0005e80000000800ULL,
0x000000001d007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002002117810ULL, 0x004fe20007ffe0ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x00000003ff007819ULL, 0x100fe20000011602ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff057819ULL, 0x100fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000700047812ULL, 0x000fe200078e4802ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000705067812ULL, 0x000fc400078e4811ULL, 0x0ffffff804047812ULL, 0x000fe400078ef802ULL,
0x0ffffff806067812ULL, 0x000fe400078ef811ULL, 0x0000000702107812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x100fe400078e0203ULL, 0x0000001006067824ULL, 0x000fc600078e0203ULL,
0x00a0000004087984ULL, 0x000f280000000c00ULL, 0x00a00000060c7984ULL, 0x0023620000000c00ULL,
0x0000000807037824ULL, 0x044fe400078e00ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe4000f8e023fULL, 0xfffffff803007812ULL, 0x000fc400078ee200ULL,
0xfffffff807057812ULL, 0x000fe400078ee205ULL, 0x0000000400007c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000711067812ULL, 0x002fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fe200078048ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078248ffULL,
0x00005b0000037a11ULL, 0x000fe400000f4c03ULL, 0x1ffffff810007812ULL, 0x100fe400078ef816ULL,
0x00005b0005057a11ULL, 0x000fe400008f4c07ULL, 0x1ffffff806067812ULL, 0x000fe200078ef816ULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001006047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x010fe8000c101d06ULL, 0x0000000c04007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604387981ULL, 0x000362000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000114067810ULL, 0x000fe20007ffe0ffULL,
0x0000000217177824ULL, 0x000fe200078e00ffULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000004000167824ULL, 0x000fe200078e00ffULL, 0x000000150600720cULL, 0x000fe20003f06070ULL,
0x0000580017177a24ULL, 0x000fe400078e0211ULL, 0x0000010014127824ULL, 0x000fc800078e0216ULL,
0x0000620017217a24ULL, 0x000fcc00078e0212ULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1b7819ULL, 0x000fe20000011602ULL, 0x00000100ff1d7424ULL, 0x000fe200078e00ffULL,
0x00000012030a7217ULL, 0x000fe40007800000ULL, 0x000000081b107810ULL, 0x040fe20007ffe0ffULL,
0x000000011b067824ULL, 0x140fe200078e0221ULL, 0x000000101b1e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010a127824ULL, 0x000fe200078e0a12ULL, 0x000000181b1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110087824ULL, 0x000fe200078e0221ULL, 0x000000300d1c7812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e001dULL, 0x000000201b197810ULL, 0x000fc40007ffe0ffULL,
0x00000003ff137819ULL, 0x100fe20000011602ULL, 0x00005e0008087625ULL, 0x080fe200078e001dULL,
0x0000001c060e7210ULL, 0x080fe40007f1e0ffULL, 0x0000000313137812ULL, 0x100fe200078e4802ULL,
0x000000011e0b7824ULL, 0x100fe200078e0221ULL, 0x0000001c08087210ULL, 0x000fe20007f3e0ffULL,
0x000000011f0c7824ULL, 0x000fe200078e0221ULL, 0x0000200000187811ULL, 0x000fe200078e68ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e001dULL, 0x0ffffffc13027812ULL, 0x000fc400078ef802ULL,
0x000000281b1a7810ULL, 0x000fe20007ffe0ffULL, 0x00005e000c0c7625ULL, 0x080fe200078e001dULL,
0x000000121e00720cULL, 0x080fe40003fa6070ULL, 0x000000121f00720cULL, 0x000fe20003f86070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x0000001c0a0a7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000001c0c0c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000121067824ULL, 0x000fe200078e0219ULL, 0x000000121900720cULL, 0x080fe20003f66070ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x000000121b00720cULL, 0x000fe20003f06070ULL,
0x00005e0006067625ULL, 0x000fc800078e001dULL, 0x0000000410117824ULL, 0x040fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000121000720cULL, 0x000fe20003f26070ULL,
0x0000001002027824ULL, 0x100fe200078e0218ULL, 0x0000001c06107210ULL, 0x000fe20007f5e0ffULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc11067812ULL, 0x000fe200078ee213ULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e027faeULL, 0x0005e2000c101c46ULL, 0x000000ffff117224ULL, 0x000fe200010e0607ULL,
0x000000121a00720cULL, 0x000fe20003f46070ULL, 0x0000001006067824ULL, 0x000fe200078e0218ULL,
0xfffffffc19197812ULL, 0x000fe200078ee213ULL, 0x0000000121077824ULL, 0x000fc400078e021aULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0x0000000008067faeULL, 0x0007e2000c901c46ULL,
0x0000001019197824ULL, 0x000fe200078e0218ULL, 0x000000301b027810ULL, 0x004fe40007ffe0ffULL,
0xfffffffc1a1a7812ULL, 0x000fe400078ee213ULL, 0x000000120200720cULL, 0x000fc60003f26070ULL,
0x000000101a1a7824ULL, 0x000fe200078e0218ULL, 0x000000381b087810ULL, 0x008fe20007ffe0ffULL,
0x00005e0007067625ULL, 0x000fc600078e001dULL, 0x000000120800720cULL, 0x000fe20003f06070ULL,
0x000000041f127824ULL, 0x000fe200078e00ffULL, 0x0000001c060e7210ULL, 0x000fe20007fde0ffULL,
0x0000000121067824ULL, 0x040fe400078e0202ULL, 0x00000004021b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e027812ULL, 0x000fe200078ee213ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0607ULL,
0xfffffffc12127812ULL, 0x100fe200078ee213ULL, 0x0000000121097824ULL, 0x000fe200078e0208ULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee213ULL, 0x0000000408087824ULL, 0x000fc400078e00ffULL,
0x00005e0006067625ULL, 0x000fc600078e001dULL, 0xfffffffc08137812ULL, 0x000fe200078ee213ULL,
0x00005e0009087625ULL, 0x000fe200078e001dULL, 0x0000001c06067210ULL, 0x000fc60007fde0ffULL,
0x0000001002027824ULL, 0x100fe400078e0218ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000001c08087210ULL, 0x000fe20007fde0ffULL, 0x0000001012127824ULL, 0x100fe200078e0218ULL,
0x000000000a027faeULL, 0x0005e2000e901c46ULL, 0x000000101b1b7824ULL, 0x100fe400078e0218ULL,
0x0000001013137824ULL, 0x000fe200078e0218ULL, 0x000000000c127faeULL, 0x0005e2000e101c46ULL,
0x000000ffff097224ULL, 0x000fc600030e0609ULL, 0x0000000010197faeULL, 0x0005e8000d901c46ULL,
0x000000000e1a7faeULL, 0x0005e8000d101c46ULL, 0x00000000061b7faeULL, 0x0005e8000c901c46ULL,
0x0000000008137faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x00000003ff087819ULL, 0x000fe20000011602ULL, 0x00000100ff237424ULL, 0x000fe200078e00ffULL,
0x0000000802097811ULL, 0x000fc400078ff0ffULL, 0x0000001002077811ULL, 0x040fe400078ff0ffULL,
0x0000002102067211ULL, 0x000fe200078ff0ffULL, 0x0000000409117824ULL, 0x000fe200078e00ffULL,
0x000000300d247812ULL, 0x000fe200078ec0ffULL, 0x0000000407127824ULL, 0x000fe200078e00ffULL,
0x0000000308197812ULL, 0x000fe200078e4802ULL, 0x0000000109087824ULL, 0x000fe200078e0221ULL,
0x00000018020a7811ULL, 0x040fe200078ff0ffULL, 0x0000000121097824ULL, 0x000fe200078e0207ULL,
0x00000020020c7811ULL, 0x000fe200078ff0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x00000028020d7811ULL, 0x000fc400078ff0ffULL, 0x00000030020f7811ULL, 0x040fe200078ff0ffULL,
0x00000001210b7824ULL, 0x040fe200078e020aULL, 0x0000003802107811ULL, 0x000fe200078ff0ffULL,
0x00000001210e7824ULL, 0x000fe200078e020cULL, 0x0ffffffc19187812ULL, 0x000fe200078ef802ULL,
0x00000001211d7824ULL, 0x000fe200078e020dULL, 0xfffffffc11027812ULL, 0x000fe200078ee219ULL,
0x00000001211f7824ULL, 0x040fe200078e020fULL, 0x0000200000227811ULL, 0x000fe200078e68ffULL,
0x0000000121217824ULL, 0x000fe400078e0210ULL, 0x00000004101c7824ULL, 0x000fe200078e00ffULL,
0x0000002406107210ULL, 0x000fe20007f1e0ffULL, 0x000000040d1a7824ULL, 0x000fc400078e00ffULL,
0x000000040c137824ULL, 0x000fe200078e00ffULL, 0xfffffffc120c7812ULL, 0x100fe200078ee219ULL,
0x000000040f1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a127812ULL, 0x000fe200078ee219ULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0xfffffffc130f7812ULL, 0x100fe200078ee219ULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b137812ULL, 0x000fe200078ee219ULL,
0x00005e0008067625ULL, 0x000fc600078e0023ULL, 0xfffffffc0a0d7812ULL, 0x100fe200078ee219ULL,
0x00005e0009087625ULL, 0x000fe200078e0023ULL, 0xfffffffc1c197812ULL, 0x000fc600078ee219ULL,
0x00000010121e7824ULL, 0x000fe200078e0222ULL, 0x0000002406127210ULL, 0x000fe20007f1e0ffULL,
0x00005e000b0a7625ULL, 0x000fc800078e0023ULL, 0x0000001018257824ULL, 0x100fe200078e0222ULL,
0x0000002408187210ULL, 0x000fe20007f3e0ffULL, 0x0000001013207824ULL, 0x100fe400078e0222ULL,
0x0000001002027824ULL, 0x100fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010257faeULL, 0x0005e2000b901c46ULL, 0x000000100c1a7824ULL, 0x100fe400078e0222ULL,
0x000000100d1b7824ULL, 0x100fe400078e0222ULL, 0x000000100f1c7824ULL, 0x000fc400078e0222ULL,
0x000000ffff137224ULL, 0x000fe200000e0607ULL, 0x000000240a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001019227824ULL, 0x000fe400078e0222ULL, 0x000000ffff197224ULL, 0x000fe200008e0609ULL,
0x0000000012027faeULL, 0x0005e2000b901c46ULL, 0x00005e000e067625ULL, 0x000fc600078e0023ULL,
0x00000000181a7faeULL, 0x0005e2000b901c46ULL, 0x00005e001d087625ULL, 0x000fc800078e0023ULL,
0x00005e001f0c7625ULL, 0x000fe200078e0023ULL, 0x0000002408087210ULL, 0x000fc60007f3e0ffULL,
0x00005e00210e7625ULL, 0x000fe200078e0023ULL, 0x000000240c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002406067210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000240e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000000a1b7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fe400000e0607ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x00000000061c7faeULL, 0x0005e8000b901c46ULL, 0x00000000081e7faeULL, 0x0005e8000b901c46ULL,
0x000000000c207faeULL, 0x0005e8000b901c46ULL, 0x000000000e227faeULL, 0x0005e4000b901c46ULL,
0x01060400ff027984ULL, 0x004ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000002ff7812ULL, 0x006fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x0000000200067305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fc800078e0202ULL, 0x0000002002057824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011602ULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x000001e005057812ULL, 0x000fe400078ec0ffULL, 0x0000000104077812ULL, 0x040fe400078efcffULL,
0x0000000704067812ULL, 0x140fe400078e7802ULL, 0x0000000707077812ULL, 0x000fe400078e7802ULL,
0x0000001004107810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x040fe200078e0206ULL,
0x0000001104047810ULL, 0x000fe20007ffe0ffULL, 0x0000000105077824ULL, 0x000fe200078e0207ULL,
0x0000000710107812ULL, 0x000fc400078e7802ULL, 0x00000000060c7984ULL, 0x000e62000000cc00ULL,
0x0000000704047812ULL, 0x000fe400078e7802ULL, 0x0000000105107824ULL, 0x040fe200078e0210ULL,
0x0000000007087984ULL, 0x000ea4000000cc00ULL, 0x0000000105047824ULL, 0x000fe400078e0204ULL,
0x000000ffff187224ULL, 0x002fe400078e000cULL, 0x000000ffff197224ULL, 0x000fc400078e000eULL,
0x000000ffff1a7224ULL, 0x004fe400078e0008ULL, 0x000000ffff1b7224ULL, 0x000fe400078e000aULL,
0x000000ffff1c7224ULL, 0x000fe400078e000dULL, 0x000000ffff1d7224ULL, 0x000fe200078e000fULL,
0x0000001806007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1f7224ULL, 0x000fca00078e000bULL, 0x0000001c07007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff237224ULL, 0x002fe400078e000aULL, 0x000000ffff227224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff207224ULL, 0x004fe400078e000cULL,
0x000000ffff217224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000002010007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff047f8cULL, 0x002fe8000c80043fULL, 0x01060400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x0000000200067305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000151400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3d80000038387820ULL, 0x020fe20000410000ULL, 0x0001068800397811ULL, 0x040fe200078e18ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0xffffffff153a7810ULL, 0x000fe40007ffe0ffULL,
0x00010608003b7811ULL, 0x000fe400078e28ffULL, 0x00000100143d7824ULL, 0x000fe200078e0216ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003d0300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e003cULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fc4000001ff00ULL, 0x000000013f287810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fe200078e003fULL,
0x000000013e3c7812ULL, 0x000fc400078e0cffULL, 0x00000002ff297819ULL, 0x100fe20000011628ULL,
0x000000ffff3f7224ULL, 0x000fe200078e0028ULL, 0x000000042800780cULL, 0x000fc60003f06070ULL,
0x0000030029297a24ULL, 0x000fc800078e0214ULL, 0x00000100292c7824ULL, 0x040fe200078e0216ULL,
0x00000001292a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000328297812ULL, 0x000fe200078ec0ffULL,
0x0000620017367a24ULL, 0x000fe200078e022cULL, 0x000000152a00720cULL, 0x000fda0003f26070ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000000429347824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x002fe20000011602ULL, 0x0000000200357824ULL, 0x000fe200078e023cULL,
0x0000002c03287217ULL, 0x000fe20007800000ULL, 0x00000100ff337424ULL, 0x000fe200078e00ffULL,
0x00000002ff2f7819ULL, 0x100fe40000011602ULL, 0x0000000329317812ULL, 0x000fe200078e4802ULL,
0x00000001282c7824ULL, 0x000fe200078e0a2cULL, 0x000000082f297810ULL, 0x040fe20007ffe0ffULL,
0x000000012f287824ULL, 0x000fe200078e0236ULL, 0xfffffffc34347812ULL, 0x000fc400078ee202ULL,
0x0000002c2f00720cULL, 0x080fe20003f26070ULL, 0x00000001292a7824ULL, 0x040fe200078e0236ULL,
0x0000002c2900720cULL, 0x040fe20003f46070ULL, 0x00000004292e7824ULL, 0x000fe200078e00ffULL,
0x0000200035357811ULL, 0x000fe200078e60ffULL, 0x00005e0028287625ULL, 0x080fe200078e0033ULL,
0x0ffffffc312d7812ULL, 0x000fe400078ef802ULL, 0xfffffffc2e2e7812ULL, 0x000fe200078ee231ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0033ULL, 0x000000282f307810ULL, 0x000fc40007ffe0ffULL,
0x000000302f327810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0235ULL,
0x0000002c3000720cULL, 0x080fe20003f86070ULL, 0x0000001034287825ULL, 0x000fe200078e0028ULL,
0x0000002c3200720cULL, 0x000fc60003fa6070ULL, 0x000000102e2e7824ULL, 0x000fe200078e0235ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0003e2000c901c46ULL,
0x00000010342a7825ULL, 0x000fc800078e002aULL, 0x0000000430417824ULL, 0x000fe200078e00ffULL,
0x000000002a2e7faeULL, 0x0005e2000d101c46ULL, 0x0000000432427824ULL, 0x000fc600078e00ffULL,
0xfffffffc41417812ULL, 0x100fe400078ee231ULL, 0x000000102f297810ULL, 0x042fe40007ffe0ffULL,
0x000000182f2d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002c2900720cULL, 0x0c0fe20003f26070ULL,
0x0000000129287824ULL, 0x100fe200078e0236ULL, 0x000000202f2b7810ULL, 0x004fe20007ffe0ffULL,
0x0000000429297824ULL, 0x000fe200078e00ffULL, 0x000000382f2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000042d377824ULL, 0x040fe200078e00ffULL, 0x0000002c2d00720cULL, 0x080fe20003f46070ULL,
0x000000042b407824ULL, 0x040fe200078e00ffULL, 0x0000002c2b00720cULL, 0x080fe20003f66070ULL,
0x000000042f437824ULL, 0x040fe200078e00ffULL, 0x0000002c2f00720cULL, 0x000fe20003fc6070ULL,
0x00000001302e7824ULL, 0x100fe200078e0236ULL, 0xfffffffc37377812ULL, 0x100fe200078ee231ULL,
0x000000012d2a7824ULL, 0x100fe200078e0236ULL, 0xfffffffc40407812ULL, 0x100fe200078ee231ULL,
0x000000012b2c7824ULL, 0x100fe200078e0236ULL, 0xfffffffc42427812ULL, 0x100fe200078ee231ULL,
0x0000000132307824ULL, 0x100fe200078e0236ULL, 0xfffffffc43437812ULL, 0x100fe200078ee231ULL,
0x000000012f327824ULL, 0x000fe200078e0236ULL, 0xfffffffc29367812ULL, 0x000fe200078ee231ULL,
0x00005e0028287625ULL, 0x000fc800078e0033ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0033ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0033ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0033ULL,
0x00005e0030307625ULL, 0x000fc800078e0033ULL, 0x00005e0032327625ULL, 0x000fc800078e0033ULL,
0x0000001034287825ULL, 0x000fc800078e0028ULL, 0x00000010342a7825ULL, 0x000fc800078e002aULL,
0x00000010342c7825ULL, 0x000fc800078e002cULL, 0x00000010342e7825ULL, 0x000fc800078e002eULL,
0x0000001034307825ULL, 0x000fc800078e0030ULL, 0x0000001034327825ULL, 0x000fc800078e0032ULL,
0x0000001036347824ULL, 0x100fe400078e0235ULL, 0x0000001037367824ULL, 0x100fe400078e0235ULL,
0x0000001040377824ULL, 0x100fe200078e0235ULL, 0x0000000028347faeULL, 0x0003e2000c901c46ULL,
0x0000001041407824ULL, 0x100fe400078e0235ULL, 0x0000001042417824ULL, 0x100fe200078e0235ULL,
0x000000002a367faeULL, 0x0003e2000d101c46ULL, 0x0000001043357824ULL, 0x000fc600078e0235ULL,
0x000000002c377faeULL, 0x0003e8000d901c46ULL, 0x000000002e407faeULL, 0x0003e8000e101c46ULL,
0x0000000030417faeULL, 0x0003e8000e901c46ULL, 0x0000000032357faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x00000002002a7824ULL, 0x000fe200078e023cULL,
0x00000008022c7811ULL, 0x042fe200078ff0ffULL, 0x0000000429407824ULL, 0x000fe200078e00ffULL,
0x00000010022d7811ULL, 0x040fe200078ff0ffULL, 0x00000100ff377424ULL, 0x000fe200078e00ffULL,
0x00000018022f7811ULL, 0x000fe200078ff0ffULL, 0x000000042c427824ULL, 0x000fe200078e00ffULL,
0x0000002002317811ULL, 0x040fe200078ff0ffULL, 0x000000042d437824ULL, 0x000fe200078e00ffULL,
0x0000002802337811ULL, 0x040fe200078ff0ffULL, 0x000000042f447824ULL, 0x000fe200078e00ffULL,
0x0000003002357811ULL, 0x040fe200078ff0ffULL, 0x0000000431457824ULL, 0x000fe200078e00ffULL,
0x0000003802417811ULL, 0x000fe200078ff0ffULL, 0x0000000433497824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x000fe20000011602ULL, 0x00000004354a7824ULL, 0x000fe200078e00ffULL,
0x000020002a467811ULL, 0x000fe200078e60ffULL, 0x00000004414b7824ULL, 0x000fe200078e00ffULL,
0x0000003602287211ULL, 0x000fe200078ff0ffULL, 0x000000012c2a7824ULL, 0x000fe200078e0236ULL,
0x00000003292b7812ULL, 0x000fe200078e4802ULL, 0x000000012d2c7824ULL, 0x000fe200078e0236ULL,
0xfffffffc40407812ULL, 0x000fe200078ee202ULL, 0x000000012f2e7824ULL, 0x100fe200078e0236ULL,
0xfffffffc42427812ULL, 0x100fe200078ee22bULL, 0x0000000131307824ULL, 0x100fe200078e0236ULL,
0xfffffffc43437812ULL, 0x100fe200078ee22bULL, 0x0000000133327824ULL, 0x100fe200078e0236ULL,
0xfffffffc44447812ULL, 0x100fe200078ee22bULL, 0x0000000135347824ULL, 0x100fe200078e0236ULL,
0xfffffffc45457812ULL, 0x100fe200078ee22bULL, 0x0000000141367824ULL, 0x000fe200078e0236ULL,
0xfffffffc49497812ULL, 0x100fe200078ee22bULL, 0x00005e0028287625ULL, 0x000fe200078e0037ULL,
0xfffffffc4a4a7812ULL, 0x000fc400078ee22bULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee22bULL,
0x00005e002c2c7625ULL, 0x000fe200078e0037ULL, 0x0ffffffc2b417812ULL, 0x000fc600078ef802ULL,
0x00005e002a2a7625ULL, 0x000fc800078e0037ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0037ULL,
0x00005e0030307625ULL, 0x000fc800078e0037ULL, 0x00005e0032327625ULL, 0x000fc800078e0037ULL,
0x00005e0034347625ULL, 0x000fc800078e0037ULL, 0x00005e0036367625ULL, 0x000fc800078e0037ULL,
0x0000001040287825ULL, 0x000fc800078e0028ULL, 0x00000010402a7825ULL, 0x000fc800078e002aULL,
0x00000010402c7825ULL, 0x000fc800078e002cULL, 0x00000010402e7825ULL, 0x000fc800078e002eULL,
0x0000001040307825ULL, 0x000fc800078e0030ULL, 0x0000001040327825ULL, 0x000fc800078e0032ULL,
0x0000001040347825ULL, 0x000fc800078e0034ULL, 0x0000001040367825ULL, 0x000fc800078e0036ULL,
0x0000001041487824ULL, 0x100fe400078e0246ULL, 0x0000001042407824ULL, 0x100fe400078e0246ULL,
0x0000001043417824ULL, 0x100fe200078e0246ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028487faeULL, 0x0003e2000b901c46ULL, 0x0000001044427824ULL, 0x100fe400078e0246ULL,
0x0000001045437824ULL, 0x100fe200078e0246ULL, 0x000000002a407faeULL, 0x0003e2000b901c46ULL,
0x0000001049447824ULL, 0x000fc400078e0246ULL, 0x000000104a457824ULL, 0x100fe200078e0246ULL,
0x000000002c417faeULL, 0x0003e2000b901c46ULL, 0x000000104b467824ULL, 0x000fc600078e0246ULL,
0x000000002e427faeULL, 0x0003e8000b901c46ULL, 0x0000000030437faeULL, 0x0003e8000b901c46ULL,
0x0000000032447faeULL, 0x0003e8000b901c46ULL, 0x0000000034457faeULL, 0x0003e8000b901c46ULL,
0x0000000036467faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000847477824ULL, 0x000fc400078e00ffULL,
0x000000ffff467224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff802287812ULL, 0x000fe200078ec0ffULL, 0x00000002002c7824ULL, 0x000fe200078e023eULL,
0x00000001462b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000728287812ULL, 0x000fe400078ef802ULL, 0x000020002c2c7811ULL, 0x000fe400078e60ffULL,
0x00000001ff297819ULL, 0x000fc80000011628ULL, 0x0000000329297812ULL, 0x000fc800078ec0ffULL,
0x00000046292a7212ULL, 0x040fe400078e3cffULL, 0x0000002b29297212ULL, 0x000fc600078e3cffULL,
0x00000004282a7824ULL, 0x040fe400078e022aULL, 0x0000000428297824ULL, 0x000fe200078e0229ULL,
0x0000002002287810ULL, 0x000fe20007ffe0ffULL, 0x000000102a2a7824ULL, 0x100fe400078e022cULL,
0x0000001029297824ULL, 0x000fe200078e022cULL, 0xfffffff828287812ULL, 0x000fe400078ec0ffULL,
0x000000002a34783bULL, 0x000e640000000200ULL, 0x00000007282d7812ULL, 0x000fc400078ef802ULL,
0x000000002930783bULL, 0x0004e40000000200ULL, 0x00000001ff287819ULL, 0x000fc8000001162dULL,
0x0000000328287812ULL, 0x000fc800078ec0ffULL, 0x0000004628297212ULL, 0x044fe400078e3cffULL,
0x0000002b282e7212ULL, 0x000fe400078e3cffULL, 0x0000000246467810ULL, 0x000fe20007ffe0ffULL,
0x000000042d297824ULL, 0x040fe400078e0229ULL, 0x000000042d2e7824ULL, 0x000fe400078e022eULL,
0x0000001029297824ULL, 0x100fe400078e022cULL, 0x000000102e2e7824ULL, 0x000fc800078e022cULL,
0x000000002928783bULL, 0x000ea80000000200ULL, 0x000000002e2c783bULL, 0x000f220000000200ULL,
0x0001000034537824ULL, 0x002fe200078e00ffULL, 0x00000034009b7306ULL, 0x000fe20000009400ULL,
0x00000018ff787819ULL, 0x000fe40000011434ULL, 0x00000018ff737819ULL, 0x000fe40000011435ULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff6c7819ULL, 0x000fe20000011437ULL,
0x00000034009c7306ULL, 0x000e620000005400ULL, 0x00000018ff6e7819ULL, 0x000fe40000011436ULL,
0x00000018ff407819ULL, 0x008fe40000011432ULL, 0x00000018ff417819ULL, 0x000fe40000011433ULL,
0x00000018ff487819ULL, 0x000fe20000011430ULL, 0x0000003400767306ULL, 0x000762000000d400ULL,
0x00000018ff427819ULL, 0x000fce0000011431ULL, 0x00000053006b7306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x008fe200078e00ffULL, 0x0000009c9b00720bULL, 0x002fe20003f5d000ULL,
0x0001000028847824ULL, 0x004fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe40000011428ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005300b37306ULL, 0x000e620000205400ULL,
0x00000018ff847819ULL, 0x000fe40000011484ULL, 0x00000018ff6a7819ULL, 0x000fc40000011429ULL,
0x00000018ff637819ULL, 0x000fe4000001142aULL, 0x0000000176762812ULL, 0x020fe200078efcffULL,
0x0000005300917306ULL, 0x0004e2000020d400ULL, 0x00000018ff5d7819ULL, 0x000fe4000001142bULL,
0x00000018ff557819ULL, 0x010fe4000001142dULL, 0x00000018ff5b7819ULL, 0x000fe4000001142fULL,
0x00000018ff587819ULL, 0x000fe2000001142eULL, 0x0000003500a07306ULL, 0x000fe20000009400ULL,
0x0001000035537824ULL, 0x004fe200078e00ffULL, 0x000000b36b00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000003500a17306ULL, 0x000e6e0000005400ULL,
0x0000000191914812ULL, 0x008fe200078efcffULL, 0x0000003500727306ULL, 0x0004f0000000d400ULL,
0x0000003400b67306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x004fe200078e00ffULL,
0x000000a1a000720bULL, 0x002fc80003fbd000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400b77306ULL, 0x000e6e0000205400ULL, 0x0000000172725812ULL, 0x008fe200078efcffULL,
0x0000003400987306ULL, 0x0004f0000020d400ULL, 0x00000078009d7306ULL, 0x000fe20000209400ULL,
0x0001000036347824ULL, 0x004fe200078e00ffULL, 0x000000b7b600720bULL, 0x002fc80003f7d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000078009a7306ULL, 0x000e6e0000205400ULL,
0x0000000198983812ULL, 0x008fe200078efcffULL, 0x0000003500c27306ULL, 0x000ff00000209400ULL,
0x0000003500c37306ULL, 0x000ea20000205400ULL, 0x0000009a9d00720bULL, 0x002fce0003fdd000ULL,
0x0000003400c47306ULL, 0x000ff00000209400ULL, 0x0000003400c57306ULL, 0x000fe20000205400ULL,
0x000000c3c200720bULL, 0x004fce0003f9d000ULL, 0x00000034009f7306ULL, 0x0003f0000020d400ULL,
0x0000007800787306ULL, 0x000ea2000020d400ULL, 0x0001000037347824ULL, 0x002fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500907306ULL, 0x0002f0000020d400ULL,
0x0000003400c87306ULL, 0x000fe20000209400ULL, 0x0000000178786812ULL, 0x004fe200078efcffULL,
0x0001000032357824ULL, 0x002fe200078e00ffULL, 0x000000c5c400720bULL, 0x000fc80003fdd000ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003400c97306ULL, 0x000e620000205400ULL,
0x0000000190904812ULL, 0x008fce00078efcffULL, 0x0000003700967306ULL, 0x000fe20000009400ULL,
0x000000019f9f6812ULL, 0x000fce00078efcffULL, 0x0000003700927306ULL, 0x000fe20000005400ULL,
0x000000c9c800720bULL, 0x002fce0003f9d000ULL, 0x00000037006d7306ULL, 0x0003f0000000d400ULL,
0x0000003400977306ULL, 0x0004e2000020d400ULL, 0x0000010037377824ULL, 0x002fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000007300a57306ULL, 0x000fe20000209400ULL,
0x0001000030347824ULL, 0x004fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000007300a67306ULL, 0x000e620000205400ULL, 0x0000000197974812ULL, 0x008fce00078efcffULL,
0x0000003700ce7306ULL, 0x000ff00000209400ULL, 0x0000003700cf7306ULL, 0x000ea20000205400ULL,
0x000000a6a500720bULL, 0x002fce0003f7d000ULL, 0x0000008400d07306ULL, 0x000ff00000209400ULL,
0x0000008400d17306ULL, 0x000e620000205400ULL, 0x000000cfce00720bULL, 0x004fce0003fdd000ULL,
0x0000005300b87306ULL, 0x000ff00000209400ULL, 0x0000005300b97306ULL, 0x000ea20000205400ULL,
0x000000d1d000720bULL, 0x002fce0003f9d000ULL, 0x0000002800b07306ULL, 0x000ff00000009400ULL,
0x0000002800af7306ULL, 0x000fe20000005400ULL, 0x000000b9b800720bULL, 0x004fce0003f3d000ULL,
0x0000002800697306ULL, 0x0003f0000000d400ULL, 0x0000008400947306ULL, 0x0004e2000020d400ULL,
0x0000010028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000036009e7306ULL, 0x000fe20000009400ULL, 0x0001000029847824ULL, 0x004fca00078e00ffULL,
0x00000018ff847819ULL, 0x000fe40000011484ULL, 0x0000003600a27306ULL, 0x000e620000005400ULL,
0x0000000194944812ULL, 0x008fce00078efcffULL, 0x0000003600717306ULL, 0x0004f0000000d400ULL,
0x0000006e00a47306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x000000a29e00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000006e00a37306ULL, 0x000e6e0000205400ULL, 0x0000000171712812ULL, 0x008fe200078efcffULL,
0x0000002800d27306ULL, 0x000ff00000209400ULL, 0x0000002800d37306ULL, 0x000fe20000205400ULL,
0x000000a3a400720bULL, 0x002fce0003fbd000ULL, 0x0000002800997306ULL, 0x0003f0000020d400ULL,
0x0000007300737306ULL, 0x000ea2000020d400ULL, 0x000100002a287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000037008b7306ULL, 0x0002f0000020d400ULL,
0x00000053008f7306ULL, 0x000f22000020d400ULL, 0x0000000173733812ULL, 0x004fe200078efcffULL,
0x0001000033377824ULL, 0x002fe200078e00ffULL, 0x000000929600720bULL, 0x000fc80003f7d000ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000008400d47306ULL, 0x000fe20000209400ULL,
0x000000018b8b6812ULL, 0x008fe400078efcffULL, 0x000000d3d200720bULL, 0x000fca0003fdd000ULL,
0x0000008400d57306ULL, 0x000e620000205400ULL, 0x000000018f8f1812ULL, 0x010fe400078efcffULL,
0x000000016d6d3812ULL, 0x000fca00078efcffULL, 0x0000003600c77306ULL, 0x000fe20000209400ULL,
0x0000000199996812ULL, 0x000fce00078efcffULL, 0x0000003600c67306ULL, 0x000ea20000205400ULL,
0x000000d5d400720bULL, 0x002fce0003f9d000ULL, 0x0000002900ad7306ULL, 0x000ff00000009400ULL,
0x0000002900ae7306ULL, 0x000fe20000005400ULL, 0x000000c6c700720bULL, 0x004fce0003f3d000ULL,
0x0000002900647306ULL, 0x0003f0000000d400ULL, 0x0000002a00ac7306ULL, 0x000fe20000009400ULL,
0x0000010029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00ab7306ULL, 0x000e700000005400ULL, 0x0000002a005e7306ULL, 0x0004f0000000d400ULL,
0x0000008400897306ULL, 0x000f22000020d400ULL, 0x000001002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000abac00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002800d87306ULL, 0x000fee0000209400ULL, 0x000000015e5e3812ULL, 0x008fe200078efcffULL,
0x0000002800d97306ULL, 0x000fe20000205400ULL, 0x0000000189894812ULL, 0x010fce00078efcffULL,
0x0000002800847306ULL, 0x0003f0000020d400ULL, 0x0000006e006e7306ULL, 0x000ea2000020d400ULL,
0x000100002b287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000036008e7306ULL, 0x0002f0000020d400ULL, 0x0000002900d67306ULL, 0x000fe20000209400ULL,
0x0000010032367824ULL, 0x002fe200078e00ffULL, 0x000000016e6e5812ULL, 0x004fc400078efcffULL,
0x000000aead00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000002900d77306ULL, 0x000e620000205400ULL, 0x000000018e8e1812ULL, 0x008fe400078efcffULL,
0x000000afb000720bULL, 0x000fca0003f3d000ULL, 0x0000002a00da7306ULL, 0x000fe20000209400ULL,
0x0000000164645812ULL, 0x000fc800078efcffULL, 0x000000648964723eULL, 0x000fc600000010ffULL,
0x0000002a00db7306ULL, 0x000ea20000205400ULL, 0x000000d7d600720bULL, 0x002fe40003fdd000ULL,
0x0000000169691812ULL, 0x000fc800078efcffULL, 0x000000699494723eULL, 0x000fe200000010ffULL,
0x0000002800dc7306ULL, 0x000ff00000209400ULL, 0x0000002800dd7306ULL, 0x000fe20000205400ULL,
0x000000dbda00720bULL, 0x004fce0003f9d000ULL, 0x00000028006b7306ULL, 0x0003f0000020d400ULL,
0x0000006c00a77306ULL, 0x000fe20000209400ULL, 0x000100002c287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000006c00a87306ULL, 0x000e700000205400ULL,
0x00000029008a7306ULL, 0x0004f0000020d400ULL, 0x0000006300bb7306ULL, 0x000fe20000209400ULL,
0x0000000702297812ULL, 0x004fc400078ec0ffULL, 0x000000a8a700720bULL, 0x002fe40003f5d000ULL,
0x0000000829a27812ULL, 0x000fc600078ef802ULL, 0x0000006300ba7306ULL, 0x000e620000205400ULL,
0x000000018a8a6812ULL, 0x008fe400078efcffULL, 0x000000dddc00720bULL, 0x000fca0003fdd000ULL,
0x0000002a00857306ULL, 0x0004f0000020d400ULL, 0x00000030007f7306ULL, 0x000fe20000009400ULL,
0x000000babb00720bULL, 0x002fe20003fbd000ULL, 0x000100002d2a7824ULL, 0x004fe200078e00ffULL,
0x000000016b6b6812ULL, 0x000fc800078efcffULL, 0x00000018ffa37819ULL, 0x000fe2000001142aULL,
0x00000030007e7306ULL, 0x000e620000005400ULL, 0x0000000185854812ULL, 0x008fce00078efcffULL,
0x0000005d00c07306ULL, 0x000ff00000209400ULL, 0x0000005d00c17306ULL, 0x000ea20000205400ULL,
0x0000007e7f00720bULL, 0x002fce0003f7d000ULL, 0x00000028009b7306ULL, 0x000ff00000209400ULL,
0x0000002800967306ULL, 0x000fe20000205400ULL, 0x000000c1c000720bULL, 0x004fce0003f9d000ULL,
0x0000002800927306ULL, 0x0003f0000020d400ULL, 0x0000006a00cb7306ULL, 0x000fe20000209400ULL,
0x0000004702287211ULL, 0x002fe400078fe0ffULL, 0x0000000447477810ULL, 0x000fc40007ffe0ffULL,
0x0000000728297812ULL, 0x040fe400078e78a2ULL, 0x0000000228287810ULL, 0x000fe20007ffe0ffULL,
0x0000006a00ca7306ULL, 0x000e640000205400ULL, 0x00000020a2297824ULL, 0x000fc800078e0229ULL,
0x0000001029297824ULL, 0x000fe400078e00ffULL, 0x00000032007c7306ULL, 0x000ff00000009400ULL,
0x00000032007d7306ULL, 0x000fe20000005400ULL, 0x000000cacb00720bULL, 0x002fce0003f3d000ULL,
0x00000032004c7306ULL, 0x000ff0000000d400ULL, 0x0000003400be7306ULL, 0x000ff00000209400ULL,
0x0000003400bf7306ULL, 0x000ff00000205400ULL, 0x00000034005c7306ULL, 0x0003f0000020d400ULL,
0x0000003500a97306ULL, 0x000fe20000209400ULL, 0x0001000031347824ULL, 0x002fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500aa7306ULL, 0x000ff00000205400ULL,
0x0000003500327306ULL, 0x000ff0000020d400ULL, 0x0000003600937306ULL, 0x000ff00000209400ULL,
0x0000003600957306ULL, 0x000ff00000205400ULL, 0x0000003600357306ULL, 0x0003f0000020d400ULL,
0x0000003300797306ULL, 0x000fe20000009400ULL, 0x0000010033367824ULL, 0x002fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000033007a7306ULL, 0x000ff00000005400ULL,
0x00000033004b7306ULL, 0x000ff0000000d400ULL, 0x0000006c006c7306ULL, 0x000e70000020d400ULL,
0x0000003700837306ULL, 0x000ff00000209400ULL, 0x0000003700827306ULL, 0x000fe20000205400ULL,
0x000000016c6c2812ULL, 0x002fce00078efcffULL, 0x0000003700337306ULL, 0x0003f0000020d400ULL,
0x0000002b008c7306ULL, 0x000fe20000009400ULL, 0x00000018ff377819ULL, 0x002fce000001142cULL,
0x0000002b008d7306ULL, 0x000ff00000005400ULL, 0x0000002b00527306ULL, 0x0003f0000000d400ULL,
0x0000002c00657306ULL, 0x000fe20000009400ULL, 0x000001002b2b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000002c00667306ULL, 0x000ff00000005400ULL,
0x0000002c004a7306ULL, 0x0003f0000000d400ULL, 0x0000008600cd7306ULL, 0x000fe20000209400ULL,
0x000001002c2c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000008600cc7306ULL, 0x000e700000205400ULL, 0x0000006300637306ULL, 0x000eb0000020d400ULL,
0x00000030004f7306ULL, 0x000722000000d400ULL, 0x000000cccd00720bULL, 0x002fce0003f5d000ULL,
0x0000005d005d7306ULL, 0x000e62000020d400ULL, 0x0000010030307824ULL, 0x008fe200078e00ffULL,
0x0000000163635812ULL, 0x004fe400078efcffULL, 0x000000bfbe00720bULL, 0x000fe40003fbd000ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000031007b7306ULL, 0x000fe20000009400ULL,
0x000000014f4f3812ULL, 0x010fe400078efcffULL, 0x000000856385723eULL, 0x000fca00000010ffULL,
0x0000003100777306ULL, 0x000ea20000005400ULL, 0x000000015d5d4812ULL, 0x002fe400078efcffULL,
0x000000015c5c5812ULL, 0x000fc800078efcffULL, 0x0000004f5c5c723eULL, 0x000fe200000010ffULL,
0x0000004800877306ULL, 0x000ff00000209400ULL, 0x0000004800887306ULL, 0x000e620000205400ULL,
0x000000777b00720bULL, 0x004fe20003fdd000ULL, 0x000100002f7b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000006a006a7306ULL, 0x000eb0000020d400ULL,
0x0000003400b57306ULL, 0x000fe20000209400ULL, 0x000000888700720bULL, 0x002fce0003f9d000ULL,
0x0000003400b47306ULL, 0x000e620000205400ULL, 0x000000016a6a1812ULL, 0x004fe400078efcffULL,
0x0000008d8c00720bULL, 0x000fca0003f3d000ULL, 0x00000031004e7306ULL, 0x0004f0000000d400ULL,
0x0000002c009d7306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x004fe200078e00ffULL,
0x000000b4b500720bULL, 0x002fc40003f7d000ULL, 0x0000000152521812ULL, 0x000fe400078efcffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000002c009e7306ULL, 0x000fe20000205400ULL,
0x000000014e4e6812ULL, 0x008fe400078efcffULL, 0x000000aaa900720bULL, 0x000fe40003fdd000ULL,
0x0000007d7c00720bULL, 0x000fe20003f3d000ULL, 0x000001002f7c7824ULL, 0x000fc400078e00ffULL,
0x0000002c009c7306ULL, 0x0003e6000020d400ULL, 0x00000018ff7c7819ULL, 0x000fca000001147cULL,
0x0000002b00b37306ULL, 0x000fe20000209400ULL, 0x00000007282c7812ULL, 0x002fe400078e78a2ULL,
0x0000000132326812ULL, 0x000fe400078efcffULL, 0x000000666500720bULL, 0x000fe20003fdd000ULL,
0x00000020a2a27824ULL, 0x000fe200078e022cULL, 0x00000076912c723eULL, 0x000fe200000010ffULL,
0x0000002b00a17306ULL, 0x000fe20000205400ULL, 0x000000014c4c1812ULL, 0x000fe400078efcffULL,
0x000000828300720bULL, 0x000fc40003f3d000ULL, 0x0000008a6a65723eULL, 0x000fc600000010ffULL,
0x0000002b009a7306ULL, 0x0003e4000020d400ULL, 0x000000014a4a6812ULL, 0x000fcc00078efcffULL,
0x0000008600867306ULL, 0x000ea2000020d400ULL, 0x000000002928783bULL, 0x002e620000000200ULL,
0x0000000133331812ULL, 0x000fcc00078efcffULL, 0x0000003000bc7306ULL, 0x000ff00000209400ULL,
0x0000003000bd7306ULL, 0x000ee20000205400ULL, 0x0000000186862812ULL, 0x004fe400078efcffULL,
0x000000d9d800720bULL, 0x000fca0003f5d000ULL, 0x0000004800487306ULL, 0x000eb0000020d400ULL,
0x0000003400347306ULL, 0x000f22000020d400ULL, 0x000000bdbc00720bULL, 0x008fe40003fbd000ULL,
0x0000000184842812ULL, 0x000fc400078efcffULL, 0x000000a1b300720bULL, 0x000fe40003f5d000ULL,
0x0000005e8484723eULL, 0x000fe200000010ffULL, 0x0000004000757306ULL, 0x000fe20000209400ULL,
0x0000000148484812ULL, 0x004fe200078efcffULL, 0x00000064281c723cULL, 0x042fec000004181cULL,
0x0000004000747306ULL, 0x000e620000205400ULL, 0x0000000134343812ULL, 0x010fe200078efcffULL,
0x000000842818723cULL, 0x000fe20000041818ULL, 0x000000019a9a2812ULL, 0x000fc400078efcffULL,
0x0000007a7900720bULL, 0x000fe20003f5d000ULL, 0x000001002e7a7824ULL, 0x000fe400078e00ffULL,
0x0000003100b17306ULL, 0x000fe60000209400ULL, 0x00000018ff7a7819ULL, 0x000fca000001147aULL,
0x0000003100b27306ULL, 0x000ea20000205400ULL, 0x000000747500720bULL, 0x002fe40003f7d000ULL,
0x000000014b4b2812ULL, 0x000fe400078efcffULL, 0x000000969b00720bULL, 0x000fc60003f5d000ULL,
0x0000003000307306ULL, 0x000e70000020d400ULL, 0x0000004200817306ULL, 0x000fe20000209400ULL,
0x000000b2b100720bULL, 0x004fe40003f9d000ULL, 0x0000000192922812ULL, 0x000fca00078efcffULL,
0x0000004200807306ULL, 0x000ea20000205400ULL, 0x0000000130305812ULL, 0x002fce00078efcffULL,
0x0000004000407306ULL, 0x000e70000020d400ULL, 0x0000003100317306ULL, 0x000ee2000020d400ULL,
0x000000808100720bULL, 0x004fce0003fbd000ULL, 0x0000004100707306ULL, 0x000fe20000209400ULL,
0x0000000140403812ULL, 0x002fce00078efcffULL, 0x00000041006f7306ULL, 0x000e620000205400ULL,
0x0000000131314812ULL, 0x008fce00078efcffULL, 0x0000003600677306ULL, 0x000ff00000209400ULL,
0x0000003600687306ULL, 0x000ea20000205400ULL, 0x0000006f7000720bULL, 0x002fce0003f9d000ULL,
0x0000002d00627306ULL, 0x000ff00000009400ULL, 0x0000002d00617306ULL, 0x000fe20000005400ULL,
0x000000686700720bULL, 0x004fce0003f7d000ULL, 0x0000002d00497306ULL, 0x0003f0000000d400ULL,
0x0000004200427306ULL, 0x000ea2000020d400ULL, 0x000001002d2d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff777819ULL, 0x000fe4000001142dULL, 0x00000098782d723eULL, 0x000fe200000010ffULL,
0x0000004100417306ULL, 0x000e62000020d400ULL, 0x000100002e787824ULL, 0x000fca00078e00ffULL,
0x0000002c280c723cULL, 0x000fe2000004180cULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000003600367306ULL, 0x000ee2000020d400ULL, 0x0000000142425812ULL, 0x004fe400078efcffULL,
0x000000959300720bULL, 0x000fe40003fbd000ULL, 0x000000728f2c723eULL, 0x000fe400000010ffULL,
0x00000090732d723eULL, 0x000fe200000010ffULL, 0x0000003700607306ULL, 0x000fe20000209400ULL,
0x0000000141414812ULL, 0x002fc400078efcffULL, 0x0000009e9d00720bULL, 0x000fe40003f9d000ULL,
0x000000998695723eULL, 0x000fe200000010ffULL, 0x0000002c2808723cULL, 0x040fe20000041808ULL,
0x000000314231723eULL, 0x000fe200000010ffULL, 0x00000037005f7306ULL, 0x000e620000205400ULL,
0x0000000136363812ULL, 0x008fe400078efcffULL, 0x0000000135355812ULL, 0x000fe400078efcffULL,
0x0000008b6c2d723eULL, 0x000fe200000010ffULL, 0x000000942820723cULL, 0x000fe20000041820ULL,
0x0000006d972c723eULL, 0x000fe200000010ffULL, 0x000000a300a07306ULL, 0x000fe20000209400ULL,
0x000000616200720bULL, 0x000fc40003fbd000ULL, 0x000000019c9c4812ULL, 0x000fe400078efcffULL,
0x000000354035723eULL, 0x000fe200000010ffULL, 0x0000002c2824723cULL, 0x000fe20000041824ULL,
0x000000364141723eULL, 0x000fe200000010ffULL, 0x000000a3008c7306ULL, 0x000ea20000205400ULL,
0x0000005f6000720bULL, 0x002fe40003f7d000ULL, 0x0000004b3340723eULL, 0x000fe400000010ffULL,
0x0000004a9236723eULL, 0x000fc400000010ffULL, 0x0000000149495812ULL, 0x000fe200078efcffULL,
0x0000002e00517306ULL, 0x000ff00000009400ULL, 0x0000002e00507306ULL, 0x000e620000005400ULL,
0x0000008ca000720bULL, 0x004fce0003fdd000ULL, 0x0000002f00457306ULL, 0x000ff00000009400ULL,
0x0000002f004d7306ULL, 0x000ea20000005400ULL, 0x000000505100720bULL, 0x002fe40003f3d000ULL,
0x000000526b50723eULL, 0x000fc400000010ffULL, 0x0000009a5d51723eULL, 0x000fe400000010ffULL,
0x00000030485d723eULL, 0x000fe200000010ffULL, 0x0000002f00447306ULL, 0x0003e2000000d400ULL,
0x0000004e3430723eULL, 0x000fe400000010ffULL, 0x0000004c3234723eULL, 0x000fe200000010ffULL,
0x000000502810723cULL, 0x000fe80000041810ULL, 0x0000002e00437306ULL, 0x000722000000d400ULL,
0x0000008e6e2f723eULL, 0x002fc400000010ffULL, 0x0000004d4500720bULL, 0x004fca0003f5d000ULL,
0x0000003700377306ULL, 0x000e62000020d400ULL, 0x000000719f2e723eULL, 0x008fce00000010ffULL,
0x000000a3007e7306ULL, 0x000ea2000020d400ULL, 0x0000002e2804723cULL, 0x000fe20000041804ULL,
0x0000000143431812ULL, 0x010fe400078efcffULL, 0x0000000144442812ULL, 0x000fc800078efcffULL,
0x0000005500537306ULL, 0x000fe20000209400ULL, 0x00000010a22e7824ULL, 0x000fe200078e00ffULL,
0x0000000137373812ULL, 0x002fc800078efcffULL, 0x0000009c3737723eULL, 0x000fe200000010ffULL,
0x000000002e2c783bULL, 0x000e620000000200ULL, 0x0000005500547306ULL, 0x000ee20000205400ULL,
0x000000017e7e6812ULL, 0x004fce00078efcffULL, 0x0000007700797306ULL, 0x000ff00000209400ULL,
0x0000007700767306ULL, 0x000ea20000205400ULL, 0x000000545300720bULL, 0x008fe40003f7d000ULL,
0x000000497e54723eULL, 0x000fca00000010ffULL, 0x00000078006e7306ULL, 0x000ff00000209400ULL,
0x00000078006c7306ULL, 0x000ee20000205400ULL, 0x000000767900720bULL, 0x004fe20003f9d000ULL,
0x0000005c2c0c723cULL, 0x042fec000004180cULL, 0x0000007c00297306ULL, 0x000fe40000209400ULL,
0x000000302c08723cULL, 0x040fec0000041808ULL, 0x0000007c002a7306ULL, 0x000e620000205400ULL,
0x0000006c6e00720bULL, 0x008fe20003fdd000ULL, 0x000000342c04723cULL, 0x040fec0000041804ULL,
0x0000005500557306ULL, 0x000ea4000020d400ULL, 0x000000402c24723cULL, 0x040fec0000041824ULL,
0x0000007700777306ULL, 0x000ee2000020d400ULL, 0x0000002a2900720bULL, 0x002fe20003f3d000ULL,
0x000000362c20723cULL, 0x000fec0000041820ULL, 0x0000007800787306ULL, 0x000e62000020d400ULL,
0x0000000155553812ULL, 0x004fce00078efcffULL, 0x0000005800567306ULL, 0x000fe20000209400ULL,
0x0000000177774812ULL, 0x008fc800078efcffULL, 0x000000775555723eULL, 0x000fc600000010ffULL,
0x0000005800577306ULL, 0x000ea20000205400ULL, 0x0000000178786812ULL, 0x002fc600078efcffULL,
0x000000542c1c723cULL, 0x000fe2000004181cULL, 0x000000437878723eULL, 0x000fc600000010ffULL,
0x0000005b00597306ULL, 0x000ff00000209400ULL, 0x0000005b005a7306ULL, 0x000e620000205400ULL,
0x000000575600720bULL, 0x004fce0003fbd000ULL, 0x0000007a00667306ULL, 0x000ff00000209400ULL,
0x0000007a00617306ULL, 0x000ea20000205400ULL, 0x0000005a5900720bULL, 0x002fce0003f9d000ULL,
0x0000007b00527306ULL, 0x000ff00000209400ULL, 0x0000007b00287306ULL, 0x000e620000205400ULL,
0x000000616600720bULL, 0x004fce0003f7d000ULL, 0x0000007c00457306ULL, 0x000eb0000020d400ULL,
0x0000005800587306ULL, 0x000ee2000020d400ULL, 0x000000285200720bULL, 0x002fce0003fdd000ULL,
0x0000005b005b7306ULL, 0x000e62000020d400ULL, 0x0000000145451812ULL, 0x004fe400078efcffULL,
0x000000044600780cULL, 0x000fca0003f25270ULL, 0x0000007a007a7306ULL, 0x000ea2000020d400ULL,
0x0000000158585812ULL, 0x008fce00078efcffULL, 0x0000007b007b7306ULL, 0x000ee2000020d400ULL,
0x000000015b5b4812ULL, 0x002fc800078efcffULL, 0x000000455b45723eULL, 0x000fe400000010ffULL,
0x000000017a7a3812ULL, 0x004fc800078efcffULL, 0x0000007a5879723eULL, 0x000fe400000010ffULL,
0x000000017b7b6812ULL, 0x008fca00078efcffULL, 0x000000782c18723cULL, 0x000fe20000041818ULL,
0x000000447b44723eULL, 0x000fce00000010ffULL, 0x000000442c10723cULL, 0x000fe20000041810ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e003cULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd5f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000039287f8cULL, 0x000fe2000c80043fULL, 0x0000002438247220ULL, 0x040fe40000410000ULL,
0x0000002038207220ULL, 0x040fe20000410000ULL, 0x00000400392a7984ULL, 0x000e620000000800ULL,
0x0000002138217220ULL, 0x040fe40000410000ULL, 0x0000000c380c7220ULL, 0x040fe40000410000ULL,
0x0000000d380d7220ULL, 0x000fc40000410000ULL, 0x0000000e382b7220ULL, 0x040fe40000410000ULL,
0x0000000f382c7220ULL, 0x040fe40000410000ULL, 0x0000000a382d7220ULL, 0x040fe40000410000ULL,
0x0000000b382e7220ULL, 0x040fe40000410000ULL, 0x00000006382f7220ULL, 0x040fe40000410000ULL,
0x0000000738307220ULL, 0x000fc40000410000ULL, 0x0000002538257220ULL, 0x040fe40000410000ULL,
0x0000000838087220ULL, 0x040fe40000410000ULL, 0x0000000938097220ULL, 0x040fe40000410000ULL,
0x0000000438047220ULL, 0x040fe40000410000ULL, 0x0000000538057220ULL, 0x040fe40000410000ULL,
0x0000002238317220ULL, 0x000fc40000410000ULL, 0x0000002338327220ULL, 0x040fe40000410000ULL,
0x0000001c381c7220ULL, 0x040fe40000410000ULL, 0x0000001d381d7220ULL, 0x040fe40000410000ULL,
0x0000001e38337220ULL, 0x040fe40000410000ULL, 0x0000001f38347220ULL, 0x000fe20000410000ULL,
0x800000002aff7812ULL, 0x002fe20007804829ULL, 0x0000001838067220ULL, 0x000fc40000410000ULL,
0x0000001938077220ULL, 0x040fe40000410000ULL, 0x0000001a38357220ULL, 0x040fe40000410000ULL,
0x0000001b38367220ULL, 0x040fe40000410000ULL, 0x00000010381e7220ULL, 0x040fe40000410000ULL,
0x0000001238377220ULL, 0x040fe40000410000ULL, 0x00000013383e7220ULL, 0x000fc40000410000ULL,
0x00000011381f7220ULL, 0x000fe40000410000ULL, 0x000000ffff107224ULL, 0x000fe400078e0024ULL,
0x000000ffff127224ULL, 0x000fe400078e0020ULL, 0x000000ffff137224ULL, 0x000fe400078e0021ULL,
0x000000ffff0a7224ULL, 0x000fe400078e000cULL, 0x000000ffff0b7224ULL, 0x000fc400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e0025ULL, 0x000000ffff207224ULL, 0x000fe400078e002bULL,
0x000000ffff217224ULL, 0x000fe400078e002cULL, 0x000000ffff227224ULL, 0x000fe400078e002dULL,
0x000000ffff237224ULL, 0x000fe400078e002eULL, 0x000000ffff247224ULL, 0x000fc400078e002fULL,
0x0000002638267220ULL, 0x040fe40000410000ULL, 0x0000002738277220ULL, 0x000fe40000410000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0004ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0005ULL,
0x000000ffff187224ULL, 0x000fe400078e001cULL, 0x000000ffff197224ULL, 0x000fe400078e001dULL,
0x000000ffff1a7224ULL, 0x000fe400078e0006ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0007ULL,
0x000000ffff257224ULL, 0x000fe400078e0030ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0031ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0033ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0034ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0035ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0036ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fc400078e0037ULL,
0x000000ffff317224ULL, 0x000fe200078e003eULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0000040039057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004021d7824ULL, 0x000fe200078e00ffULL,
0x0000003a1400720cULL, 0x000fc80003f05270ULL, 0xfffffff01d1c7812ULL, 0x000fca00078ec0ffULL,
0x00000080001c7824ULL, 0x000fca00078e021cULL, 0x010400001c047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202087824ULL, 0x000fe400078e00ffULL,
0x00000001033d7824ULL, 0x000fc600078e0a3dULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108097812ULL, 0x040fe400078efcffULL, 0x0000000808287812ULL, 0x040fe400078efcffULL,
0x0000003d0900720cULL, 0x080fe40003f26070ULL, 0x0000001008097812ULL, 0x000fe400078efcffULL,
0x0000003d2800720cULL, 0x080fe40003f06070ULL, 0x0000003d0900720cULL, 0x000fc40003fc6070ULL,
0x0000001108287812ULL, 0x040fe400078efcffULL, 0x0000001808097812ULL, 0x040fe400078efcffULL,
0x0000003d0800720cULL, 0x080fe40003f46070ULL, 0x0000003d2800720cULL, 0x080fe40003fa6070ULL,
0x0000003d0900720cULL, 0x000fe40003f66070ULL, 0x0000000908297812ULL, 0x000fc400078efcffULL,
0x0000001908287812ULL, 0x040fe400078efcffULL, 0x0000002008097812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40004800000ULL,
0x0000003d2900720cULL, 0x080fe40003f86070ULL, 0x0000003d2800720cULL, 0x080fe40003f46070ULL,
0x0000003d0900720cULL, 0x000fe40003f26070ULL, 0x0000002108287812ULL, 0x040fe400078efcffULL,
0x0000002808097812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000003d2800720cULL, 0x080fe40003f06070ULL,
0x0000003d0900720cULL, 0x000fe40003f86070ULL, 0x0000002908287812ULL, 0x000fc400078efcffULL,
0x0000003008097812ULL, 0x000fe400078efcffULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000003d2800720cULL, 0x000fc40003fc6070ULL,
0x0000003d0900720cULL, 0x000fe40003fa6070ULL, 0x0000003108287812ULL, 0x040fe400078efcffULL,
0x0000003808097812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000003d2800720cULL, 0x080fe40003f66070ULL, 0x0000003d0900720cULL, 0x000fc40003f46070ULL,
0x0000003d0800720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff30307808ULL, 0x000fc40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff31317808ULL, 0x000fe40004800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0x0000000a04047209ULL, 0x004fe40007810000ULL,
0x0000002005057209ULL, 0x000fe40007810000ULL, 0x0000000b04047209ULL, 0x000fe40007810000ULL,
0x0000002105057209ULL, 0x000fc40007810000ULL, 0x0000000c04047209ULL, 0x000fe40007810000ULL,
0x0000002205057209ULL, 0x000fe40007810000ULL, 0x0000000d04047209ULL, 0x000fe40007810000ULL,
0x0000002305057209ULL, 0x000fe40007810000ULL, 0x0000000e04047209ULL, 0x000fe40007810000ULL,
0x0000002405057209ULL, 0x000fc40007810000ULL, 0x0000000f04047209ULL, 0x000fe40007810000ULL,
0x0000002505057209ULL, 0x000fe40007810000ULL, 0x0000001004047209ULL, 0x000fe40007810000ULL,
0x0000002605057209ULL, 0x000fe40007810000ULL, 0x0000001104047209ULL, 0x000fe40007810000ULL,
0x0000002705057209ULL, 0x000fc40007810000ULL, 0x0000001204047209ULL, 0x000fe40007810000ULL,
0x0000002a05057209ULL, 0x000fe40007810000ULL, 0x0000001304047209ULL, 0x000fe40007810000ULL,
0x0000002b05057209ULL, 0x000fe40007810000ULL, 0x0000001804047209ULL, 0x000fe40007810000ULL,
0x0000002c05057209ULL, 0x000fc40007810000ULL, 0x0000001904047209ULL, 0x000fe40007810000ULL,
0x0000002d05057209ULL, 0x000fe40007810000ULL, 0x0000001a04047209ULL, 0x000fe40007810000ULL,
0x0000002e05057209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fe40007810000ULL,
0x0000002f05057209ULL, 0x000fc40007810000ULL, 0x0000001e04047209ULL, 0x000fe40007810000ULL,
0x0000003005057209ULL, 0x000fe40007810000ULL, 0x0000001f04287209ULL, 0x000fe40007810000ULL,
0x0000003105057209ULL, 0x000fe20007810000ULL, 0x00001d827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0028047f89ULL, 0x0004e400000e0000ULL, 0x0000000428327209ULL, 0x008fe20007810000ULL,
0x00001dd27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006087f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007097f89ULL, 0x000f6200000e0000ULL,
0x0000000405057209ULL, 0x008fc60007810000ULL, 0x0c201f0032047f89ULL, 0x000ee200000e0000ULL,
0x0000000806067209ULL, 0x010fc60007810000ULL, 0x0c201f0005087f89ULL, 0x000f2200000e0000ULL,
0x0000000907077209ULL, 0x020fc60007810000ULL, 0x0c201f0006287f89ULL, 0x004ea800000e0000ULL,
0x0c201f0007297f89ULL, 0x00026200000e0000ULL, 0x0000000432047209ULL, 0x008fe40007810000ULL,
0x0000000805057209ULL, 0x010fe40007810000ULL, 0x0000002806067209ULL, 0x004fe40007810000ULL,
0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b05287820ULL, 0x000fe20000410000ULL, 0x0000000729077209ULL, 0x006fe20007810000ULL,
0x3fb8aa3b0a0a7823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b0b0b7823ULL, 0x000fe40000010808ULL,
0x3fb8aa3b21217823ULL, 0x000fe40000010828ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010808ULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x000fe40000010808ULL,
0x3fb8aa3b22227823ULL, 0x100fe40000010828ULL, 0x3fb8aa3b23237823ULL, 0x000fc40000010828ULL,
0x3fb8aa3b20207823ULL, 0x000fe20000010828ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b10107823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010808ULL,
0x0000002000097308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b12127823ULL, 0x000fc40000010808ULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b18187823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010808ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x00000004ff207e24ULL, 0x002fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010808ULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010808ULL, 0x3f8000002020783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010808ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f087823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b24247823ULL, 0x100fe40000010828ULL,
0x3fb8aa3b25257823ULL, 0x100fe40000010828ULL, 0x3fb8aa3b26267823ULL, 0x000fe20000010828ULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x000000092109723eULL, 0x004fe200000010ffULL,
0x000000ffff217224ULL, 0x000fe400078e0020ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010828ULL,
0x3fb8aa3b2a2a7823ULL, 0x000fc40000010828ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe40000010828ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe40000010828ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe40000010828ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010828ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe40000010828ULL,
0x3fb8aa3b30307823ULL, 0x000fc40000010828ULL, 0x3fb8aa3b31287823ULL, 0x000fc60000010828ULL,
0x00000008001f7308ULL, 0x0007f00000000800ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000a0b08723eULL, 0x008fe400000010ffULL, 0x0000000c0d0a723eULL, 0x002fc400000010ffULL,
0x00000022230b723eULL, 0x004fe200000010ffULL, 0x0000000fff237424ULL, 0x000fe400078e00ffULL,
0x0000000f000f7308ULL, 0x000e680000000800ULL, 0x000000200834723cULL, 0x000fe800000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x004fe200000010ffULL,
0x000000ffff107224ULL, 0x000fc400078e0020ULL, 0x000000ffff117224ULL, 0x000fc800078e0020ULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x00000024250d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000026270f723eULL, 0x004fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000100c34723cULL, 0x000fee0000041834ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x000000181912723eULL, 0x004fe200000010ffULL, 0x000000ffff187224ULL, 0x000fc400078e0020ULL,
0x000000ffff197224ULL, 0x000fc800078e0020ULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000ea20000000800ULL, 0x0000002a2b11723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000002c2d13723eULL, 0x004fce00000010ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000181034723cULL, 0x000fee0000041834ULL,
0x0000001e001e7308ULL, 0x000ea20000000800ULL, 0xfffffffc02187812ULL, 0x000fce00078ec0ffULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x0000001823237219ULL, 0x000fe400000006ffULL,
0x0000001a1b18723eULL, 0x002fe400000010ffULL, 0x00000000232173a1ULL, 0x000e6200000e8000ULL,
0x00000000230473c4ULL, 0x000ee40000004000ULL, 0x0000002f002f7308ULL, 0x000f220000000800ULL,
0x0000001e1f1a723eULL, 0x004fe200000010ffULL, 0x000000ffff1e7224ULL, 0x000fc400078e0020ULL,
0x000000ffff1f7224ULL, 0x000fc800078e0020ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000ea20000000800ULL, 0x0000002e2f19723eULL, 0x010fe400000010ffULL,
0x0000000523ff7c12ULL, 0x002fc4000f804021ULL, 0x00000030281b723eULL, 0x004fce00000010ffULL,
0x0000001e1834723cULL, 0x000fe80000041834ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000196204008947ULL, 0x008fde000b800000ULL, 0x001c1fff34207589ULL, 0x0002a400000e0000ULL,
0x00000000231e73a1ULL, 0x000ee200000e8000ULL, 0x00000000230473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000523ff7c12ULL, 0x008fda000f80401eULL,
0x0000198204008947ULL, 0x010fea000b800000ULL, 0x001c1fff36217589ULL, 0x00072800000e0000ULL,
0x001c1fff22227589ULL, 0x00066800000e0000ULL, 0x001c1fff23237589ULL, 0x002e6400000e0000ULL,
0x00000002ff1e7819ULL, 0x000fe40000011602ULL, 0x0000000c1d317812ULL, 0x000fc400078ec0ffULL,
0x000000071e1f7812ULL, 0x040fe200078ec0ffULL, 0x000000081e247824ULL, 0x040fe200078e00ffULL,
0x0000001eff2c7212ULL, 0x000fe200078e33ffULL, 0x000000081e257824ULL, 0x000fe200078e00ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081e2d7824ULL, 0x040fe200078e00ffULL,
0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824247812ULL, 0x100fe400078ee21fULL,
0x0000000125267812ULL, 0x140fe200078ef61fULL, 0x000000081e357824ULL, 0x040fe200078e00ffULL,
0x0000000225277812ULL, 0x140fe200078ef61fULL, 0x000000081e2e7824ULL, 0x000fe200078e00ffULL,
0x0000000325287812ULL, 0x000fc400078ef61fULL, 0x0000000425297812ULL, 0x140fe400078ef61fULL,
0x00000005252a7812ULL, 0x140fe400078ef61fULL, 0x00000006252b7812ULL, 0x000fe200078ef61fULL,
0x000000081e257824ULL, 0x040fe200078e00ffULL, 0xfffffff82d2c7812ULL, 0x000fe400078ee22cULL,
0x0000001eff2d7212ULL, 0x000fe400078e33ffULL, 0x000000071e1f7812ULL, 0x000fc400078ec0ffULL,
0x0000a000001e7811ULL, 0x000fe400078e58ffULL, 0xfffffff835357812ULL, 0x000fe400078ee22dULL,
0xfffffff82e2d7812ULL, 0x100fe200078ee21fULL, 0x00000010241d7824ULL, 0x100fe200078e021eULL,
0x00000001252e7812ULL, 0x100fe200078ef61fULL, 0x0000001027247824ULL, 0x100fe200078e021eULL,
0x00000002252f7812ULL, 0x000fe200078ef61fULL, 0x00000001311d7824ULL, 0x000fe200078e021dULL,
0x0000000325307812ULL, 0x140fe200078ef61fULL, 0x000000102a277824ULL, 0x000fe200078e021eULL,
0x0000000425327812ULL, 0x100fe200078ef61fULL, 0x0000000131247824ULL, 0x000fe200078e0224ULL,
0x0000000525337812ULL, 0x100fe200078ef61fULL, 0x000000102d2a7824ULL, 0x100fe200078e021eULL,
0x0000000625347812ULL, 0x000fe200078ef61fULL, 0x00000010261f7824ULL, 0x100fe200078e021eULL,
0x000000081d007388ULL, 0x0007e20000000800ULL, 0x0000001028257824ULL, 0x000fc400078e021eULL,
0x0000001029267824ULL, 0x100fe400078e021eULL, 0x00000001311f7824ULL, 0x000fe400078e021fULL,
0x000000102b287824ULL, 0x100fe400078e021eULL, 0x000000102c297824ULL, 0x000fe200078e021eULL,
0x0000000a1f007388ULL, 0x0007e20000000800ULL, 0x0000000131257824ULL, 0x040fe400078e0225ULL,
0x0000000131267824ULL, 0x000fe200078e0226ULL, 0x0000000c24007388ULL, 0x0007e20000000800ULL,
0x000000102e2b7824ULL, 0x000fc400078e021eULL, 0x0000000131277824ULL, 0x000fe200078e0227ULL,
0x0000000e25007388ULL, 0x0007e20000000800ULL, 0x000000102f2c7824ULL, 0x000fe400078e021eULL,
0x0000000131287824ULL, 0x040fe200078e0228ULL, 0x0000001026007388ULL, 0x0007e20000000800ULL,
0x00000010302d7824ULL, 0x100fe400078e021eULL, 0x0000000131297824ULL, 0x000fe200078e0229ULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x00000010322e7824ULL, 0x000fc400078e021eULL,
0x00000001312a7824ULL, 0x000fe200078e022aULL, 0x0000001828007388ULL, 0x0007e20000000800ULL,
0x00000010332f7824ULL, 0x100fe400078e021eULL, 0x00000001312b7824ULL, 0x040fe200078e022bULL,
0x0000001a29007388ULL, 0x0007e20000000800ULL, 0x0000001034307824ULL, 0x000fe400078e021eULL,
0x00000001312c7824ULL, 0x000fe200078e022cULL, 0x000000092a007388ULL, 0x0007e20000000800ULL,
0x00000010351e7824ULL, 0x000fc400078e021eULL, 0x00000001312d7824ULL, 0x040fe200078e022dULL,
0x0000000b2b007388ULL, 0x0007e20000000800ULL, 0x00000001312e7824ULL, 0x040fe400078e022eULL,
0x00000001312f7824ULL, 0x040fe200078e022fULL, 0x0000000d2c007388ULL, 0x0007e20000000800ULL,
0x0000000131307824ULL, 0x040fe400078e0230ULL, 0x00000001311e7824ULL, 0x000fe200078e021eULL,
0x0000000f2d007388ULL, 0x0007e80000000800ULL, 0x000000112e007388ULL, 0x0007e80000000800ULL,
0x000000132f007388ULL, 0x0007e80000000800ULL, 0x0000001930007388ULL, 0x0007e80000000800ULL,
0x0000001b1e007388ULL, 0x0007e80000000800ULL, 0x010000041c008388ULL, 0x0007e80000000c00ULL,
0x010200201c008388ULL, 0x0167e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003bff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003bff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003bff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030014147a10ULL, 0x000fe20007ffe0ffULL, 0x000018003bff7f8cULL, 0x0003e6000c80043fULL,
0x000000151400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb9e000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff507807ULL, 0x008fe20004800000ULL, 0xffffffffff547424ULL, 0x000fe200078e00ffULL,
0x0001d8c000517802ULL, 0x000fe40000000f00ULL, 0x0000158000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0054ULL, 0xfffe3c2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff507807ULL, 0x000fe20004800000ULL, 0xffffffffff547424ULL, 0x000fe200078e00ffULL,
0x0001d92000517802ULL, 0x000fe40000000f00ULL, 0x0000152000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0054ULL, 0xfffe3c4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x014fe200078e0031ULL, 0x0001d9a000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fe400078e0018ULL, 0x0000001fff597424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000145000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x004fe200078e005aULL, 0xfffe3c6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff647224ULL, 0x000fe200078e0018ULL, 0x0001da2000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fe400078e0031ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x000013d000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e005aULL, 0xfffe3c1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e001cULL, 0x0001daa000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fc400078e0030ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000135000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff777224ULL, 0x004fe200078e005aULL, 0xfffe3f8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e001cULL, 0x0001db2000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fe400078e002eULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x000012d000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff717224ULL, 0x004fe200078e005aULL, 0xfffe3f3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0004ULL, 0x0001db9000637802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000126000007944ULL, 0x000fea0003c00000ULL, 0x000000ffffad7224ULL, 0x004fe200078e005aULL,
0xfffe646000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0004ULL,
0x0001dc1000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x002fe400078e002eULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x000011e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e005aULL,
0xfffe640000007947ULL, 0x000fea000383ffffULL, 0x00000001ff507807ULL, 0x008fe20004800000ULL,
0xffffffffff547424ULL, 0x000fe200078e00ffULL, 0x0001dc7000517802ULL, 0x000fc40000000f00ULL,
0x000011d000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff507224ULL, 0x000fe200078e0054ULL,
0xfffe88d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff507807ULL, 0x000fe20004800000ULL,
0xffffffffff547424ULL, 0x000fe200078e00ffULL, 0x0001dcd000517802ULL, 0x000fc40000000f00ULL,
0x0000117000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff507224ULL, 0x000fe200078e0054ULL,
0xfffe88f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff647224ULL, 0x004fe200078e005aULL,
0x0001dd5000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e0054ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x000010a000007944ULL, 0x012fea0003c00000ULL, 0xfffe893000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0054ULL, 0x0001ddc000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fe400078e002eULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000103000007944ULL, 0x012fea0003c00000ULL,
0xfffe89e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e003dULL,
0x0001de2000637802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000fd000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff757224ULL, 0x004fe200078e005aULL, 0xfffe8c3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e003dULL, 0x0001dea000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x004fe400078e002eULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000f5000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff707224ULL, 0x004fe200078e005aULL, 0xfffe8bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff647224ULL, 0x000fe200078e003eULL, 0x0001df2000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e0004ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000ed000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff3e7224ULL, 0x004fe200078e005aULL, 0xfffeaf4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0004ULL, 0x0001dfa000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fe400078e002eULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000e5000007944ULL, 0x006fea0003c00000ULL,
0x000000ffffae7224ULL, 0x004fe200078e005aULL, 0xfffeaee000007947ULL, 0x000fea000383ffffULL,
0x00000001ff507807ULL, 0x008fe20004800000ULL, 0xffffffffff547424ULL, 0x000fe200078e00ffULL,
0x0001e00000517802ULL, 0x000fc40000000f00ULL, 0x00000e4000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff507224ULL, 0x000fe200078e0054ULL, 0xfffed33000007947ULL, 0x000fea000383ffffULL,
0x00000001ff507807ULL, 0x000fe20004800000ULL, 0xffffffffff547424ULL, 0x000fe200078e00ffULL,
0x0001e06000517802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff507224ULL, 0x000fe200078e0054ULL, 0xfffed35000007947ULL, 0x000fea000383ffffULL,
0x000000ffff647224ULL, 0x004fe200078e005aULL, 0x0001e0e000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e0054ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000d1000007944ULL, 0x012fea0003c00000ULL,
0xfffed39000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0054ULL,
0x0001e15000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fe400078e002eULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000ca000007944ULL, 0x012fea0003c00000ULL, 0xfffed44000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e003dULL, 0x0001e1b000637802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000c4000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff757224ULL, 0x004fe200078e005aULL,
0xfffed69000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e003dULL,
0x0001e23000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x004fe400078e002eULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000bc000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff707224ULL, 0x004fe200078e005aULL,
0xfffed63000007947ULL, 0x000fea000383ffffULL, 0x000000ffff647224ULL, 0x000fe200078e003eULL,
0x0001e2b000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e0004ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000b4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e005aULL,
0xfffef9a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0004ULL,
0x0001e33000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fe400078e002eULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000ac000007944ULL, 0x006fea0003c00000ULL, 0x000000ffffae7224ULL, 0x004fe200078e005aULL,
0xfffef94000007947ULL, 0x000fea000383ffffULL, 0x00000001ff507807ULL, 0x008fe20004800000ULL,
0xffffffffff547424ULL, 0x000fe200078e00ffULL, 0x0001e39000517802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0054ULL,
0xffff1d9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff507807ULL, 0x000fe20004800000ULL,
0xffffffffff547424ULL, 0x000fe200078e00ffULL, 0x0001e3f000517802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0054ULL,
0xffff1db000007947ULL, 0x000fea000383ffffULL, 0x000000ffff647224ULL, 0x004fe200078e005aULL,
0x0001e47000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e0018ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000098000007944ULL, 0x012fea0003c00000ULL, 0xffff1df000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0018ULL, 0x0001e4e000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff647224ULL, 0x000fe400078e002eULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000091000007944ULL, 0x012fea0003c00000ULL,
0xffff1ea000007947ULL, 0x000fea000383ffffULL, 0x000000ffff647224ULL, 0x000fe200078e0062ULL,
0x0001e55000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e0028ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x000008a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff627224ULL, 0x004fe200078e005aULL,
0xffff20e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0028ULL,
0x0001e5d000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fe400078e002eULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000082000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff5d7224ULL, 0x004fe200078e005aULL,
0xffff208000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0008ULL,
0x0001e64000637802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x000007b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6e7224ULL, 0x004fe200078e005aULL, 0xffff443000007947ULL, 0x000fea000383ffffULL,
0x000000ffff647224ULL, 0x002fe200078e002eULL, 0x0001e6c000637802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fe400078e0008ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff717224ULL, 0x004fe200078e005aULL, 0xffff43d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0028ULL, 0x0001e74000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff297424ULL, 0x000fc400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fe400078e00ffULL, 0x0000066000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0029ULL, 0xffffe21000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0001e7c000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff297424ULL, 0x000fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fe400078e00ffULL, 0x000005e000007944ULL, 0x006fea0003c00000ULL,
0x0000002905057209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001e83000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff297424ULL, 0x000fc400078e00ffULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fe400078e00ffULL,
0x0000057000007944ULL, 0x000fea0003c00000ULL, 0x0000002906067209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x0001e8a000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff297424ULL, 0x000fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fe400078e00ffULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x0000002907077209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e0032ULL,
0x0001e91000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff297424ULL, 0x000fc400078e00ffULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000002932047209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0001e98000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff297424ULL, 0x000fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fe400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000002905057209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001e9f000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff297424ULL, 0x000fc400078e00ffULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fe400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x0000002906067209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x0001ea6000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff297424ULL, 0x000fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fe400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffdff000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0034ULL,
0x0001ead000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fc400078e00ffULL,
0x00001c1fff597424ULL, 0x000fe400078e00ffULL, 0x000000ffff587224ULL, 0x000fe400078e0023ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e005aULL,
0xffffe63000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0036ULL,
0x0001eb5000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fe400078e00ffULL,
0x00001c1fff597424ULL, 0x000fe400078e00ffULL, 0x000000ffff587224ULL, 0x000fe400078e0023ULL,
0x000002a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff647224ULL, 0x000fe200078e00ffULL,
0x0001ebb000637802ULL, 0x000fe20000000f00ULL, 0x00001c1fff597424ULL, 0x000fc400078e00ffULL,
0x000000ffff587224ULL, 0x000fe400078e0023ULL, 0x000000ffff217224ULL, 0x004fe400078e005aULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff587224ULL, 0x000fe200078e0023ULL,
0x0001ec1000637802ULL, 0x000fe20000000f00ULL, 0x000000ffff647224ULL, 0x000fe400078e00ffULL,
0x00001c1fff597424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e005aULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e005aULL,
0xffffe57000007947ULL, 0x000fea000383ffffULL, 0x0180000033027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003300028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000205ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff33ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000205ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000033057812ULL, 0x000fd600078ec0ffULL, 0x0080000005020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003300027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe126006007950ULL, 0x000fea0003c3ffffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x0c00002908297389ULL, 0x0002a400000e0033ULL,
0x000000ffff087224ULL, 0x002fe400078e0009ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe121008007950ULL, 0x000fea0003c3ffffULL, 0x0000005800007348ULL, 0x000fe80003800000ULL,
0x000000645b5a7389ULL, 0x0002a400000e0059ULL, 0x000000ffff587224ULL, 0x002fe400078e0063ULL,
0x00000000ff597424ULL, 0x000fc800078e00ffULL, 0xfffe11c058007950ULL, 0x000fea0003c3ffffULL,
0x000000015000780cULL, 0x000fe20003f25070ULL, 0x0000005400007348ULL, 0x000fd80003800000ULL,
0x0000000000507806ULL, 0x000fc800048e0100ULL, 0x0000005450547212ULL, 0x000fe200078ec0ffULL,
0x000000ffff507224ULL, 0x000fe400078e0051ULL, 0x00000000ff517424ULL, 0x000fc800078e00ffULL,
0xfffe115050007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000430ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a10ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000aa0ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001630ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001650ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001660ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001710ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001718ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001728ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x000000000001ef80ULL, 0xf800001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020880ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000020890ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020890ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000020d10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001710ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001f170ULL, 0x000000000001f170ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000020880ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000020d10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin_len = 134640;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
