/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016570ULL, 0x00000000000160f0ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000014e30ULL, 0x0000000000000250ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000015080ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00014e3000000000ULL, 0x0000480400000000ULL, 0x0400288080810c00ULL, 0x0000000000005338ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8016288080890828ULL, 0x0000000310288082ULL,
0x8089920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL,
0x00014e3000000000ULL, 0x0000025000000000ULL, 0x0000580400000000ULL, 0x808a288080820900ULL,
0x0900000004042880ULL, 0x2880808228808089ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x00013d5000103104ULL, 0x00013d7000013d60ULL, 0x00ec290400013d80ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500000805000005ULL, 0x0500000505000008ULL, 0x0500000505000005ULL,
0x0500001c0500001cULL, 0x0500001c0500001cULL, 0x0500001c0500001cULL, 0x0500001c0500001cULL,
0x0500001c0500001cULL, 0x00ec28040500001cULL, 0x000000f0000000b0ULL, 0x00001e8000001de0ULL,
0x00001f3000001f10ULL, 0x000023c0000023b0ULL, 0x00004850000047e0ULL, 0x000048f0000048d0ULL,
0x00004d1000004c20ULL, 0x00006fb000006f40ULL, 0x0000705000007030ULL, 0x0000744000007390ULL,
0x000096c000009640ULL, 0x0000976000009740ULL, 0x00009a9000009a80ULL, 0x0000b9800000b970ULL,
0x0000dd000000c0f0ULL, 0x0000e2800000dd30ULL, 0x0000e7100000e2a0ULL, 0x0001366000013650ULL,
0x0001368000013670ULL, 0x000136d0000136b0ULL, 0x00013700000136f0ULL, 0x00013d6000013d40ULL,
0x00013db000013d70ULL, 0x00013dd000013dc0ULL, 0x000149c000014930ULL, 0x00014a8000014a20ULL,
0x00014b5000014af0ULL, 0x00014bf000014ba0ULL, 0x00014d5000014cb0ULL, 0x03d0390400014df0ULL,
0x000000ff00000170ULL, 0x000401000001c600ULL, 0x0000000200000250ULL, 0x003f01000001c608ULL,
0x00000002000002c0ULL, 0x003f01000001c610ULL, 0x00000000000004b0ULL, 0x003f01000001c648ULL,
0x000000ff000005c0ULL, 0x000401000001c658ULL, 0x000000ff00000990ULL, 0x000401070001c600ULL,
0x0000007d00000b90ULL, 0x000e01010001c610ULL, 0x000000ff00001220ULL, 0x000e01070001c648ULL,
0x000000ff00001250ULL, 0x000e01010001c658ULL, 0x000000ff000014e0ULL, 0x000e01060001c658ULL,
0x000000ff00001840ULL, 0x000e010a0001c658ULL, 0x0000000700001c60ULL, 0x0010010700000000ULL,
0x0000002400001cb0ULL, 0x0010010600000000ULL, 0x000000ff00001d00ULL, 0x000e010a0001c608ULL,
0x0000002400002180ULL, 0x0010010a00000000ULL, 0x000000ff00003c50ULL, 0x000e01010001c658ULL,
0x000000ff00003ce0ULL, 0x000e01010001c610ULL, 0x000000ff00004200ULL, 0x000e01060001c658ULL,
0x000000ff000044d0ULL, 0x000e010a0001c658ULL, 0x0000000b00004700ULL, 0x0010010700000000ULL,
0x0000003d00004740ULL, 0x0010010600000000ULL, 0x000000ff00004750ULL, 0x000e010a0001c618ULL,
0x000000ff00004b60ULL, 0x0004010a0001c648ULL, 0x000000ff000062f0ULL, 0x000e01010001c658ULL,
0x000000ff00006340ULL, 0x000e01010001c620ULL, 0x000000ff000069d0ULL, 0x000e01060001c658ULL,
0x000000ff00006a90ULL, 0x000e010a0001c658ULL, 0x0000000a00006e90ULL, 0x0010010700000000ULL,
0x0000000b00006ec0ULL, 0x000e01060001c648ULL, 0x000000ff00006ed0ULL, 0x000e010a0001c628ULL,
0x000000ff000072d0ULL, 0x0004010a0001c648ULL, 0x000000ff00008b00ULL, 0x000e01010001c658ULL,
0x000000ff00008b80ULL, 0x000e01010001c630ULL, 0x000000ff000090e0ULL, 0x000e01060001c658ULL,
0x000000ff00009160ULL, 0x000e010a0001c658ULL, 0x0000000b000095a0ULL, 0x0010010700000000ULL,
0x0000003d000095d0ULL, 0x0010010600000000ULL, 0x000000ff000095e0ULL, 0x000e010a0001c638ULL,
0x000000ff000099d0ULL, 0x0006010a0001c648ULL, 0x000000ff0000af70ULL, 0x000e01010001c658ULL,
0x000000ff0000afa0ULL, 0x000e01010001c640ULL, 0x00000002000102d0ULL, 0x003f010a0001c600ULL,
0x00000002000105e0ULL, 0x003f01010001c600ULL, 0x0000000200010600ULL, 0x003f010a0001c600ULL,
0x0000007200012e00ULL, 0x003f010a0001c610ULL, 0x00000072000140d0ULL, 0x003f01010001c608ULL,
0x0000000700014120ULL, 0x003f010a0001c658ULL, 0x00000009000141a0ULL, 0x003f010a0001c608ULL,
0x0000000b00014230ULL, 0x003f010a00000000ULL, 0x0000003d000142c0ULL, 0x003f010a0001c658ULL,
0x0000000500014350ULL, 0x003f010a0001c618ULL, 0x0000000f000143e0ULL, 0x003f010a0001c648ULL,
0x0000002700014470ULL, 0x003f010a0001c658ULL, 0x0000000d000144f0ULL, 0x003f010a0001c628ULL,
0x0000000d00014580ULL, 0x003f010a0001c648ULL, 0x0000000500014610ULL, 0x003f010a0001c658ULL,
0x0000000300014690ULL, 0x003f010a0001c638ULL, 0x0000000700014720ULL, 0x003f010a0001c648ULL,
0x0000000200014780ULL, 0x003f010a0001c600ULL, 0x0000000200014800ULL, 0x003f010a0001c600ULL,
0x0000007200014870ULL, 0x003f010a0001c610ULL, 0x00101c0400053803ULL, 0x000106200000eb50ULL,
0x000140f0000106a0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x00080a0400501903ULL, 0x005002100000000fULL, 0x0000000800043604ULL, 0xffffffff00000000ULL,
0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000000ULL, 0x00000000000000ccULL, 0x0000000e00000002ULL, 0x0000000000014e30ULL,
0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a5ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000c7919ULL, 0x000eae0000002300ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x0000000000057919ULL, 0x000f2a0000002100ULL,
0x00000300ff677b82ULL, 0x000f620000000800ULL, 0x0000000000157919ULL, 0x000f6e0000002700ULL,
0x00000000000779c3ULL, 0x000f620000002600ULL, 0x00000004ff687e24ULL, 0x008fc4000f8e00ffULL,
0x000000010c007824ULL, 0x004fe400078e0203ULL, 0x00001fff0c0c7589ULL, 0x000ea400000e0000ULL,
0x0000008000007824ULL, 0x110fe200078e0205ULL, 0x00000005ff667819ULL, 0x000fc80000011605ULL,
0x000000ff0000720cULL, 0x040fe40003f45270ULL, 0x00001fff66667589ULL, 0x000ee200000e0000ULL,
0x000000030000780cULL, 0x000fd40003f04070ULL, 0x0000000000242947ULL, 0x022fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01c60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001a000007945ULL, 0x000fe80003800000ULL, 0x0000000000600947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7fff000000057882ULL, 0x000fc60000000000ULL, 0x0000000400027c11ULL, 0x000fe2000f8e20ffULL,
0x001fffc000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000020612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f640000000000ULL,
0x01c60804063f75b2ULL, 0x0103700008000100ULL, 0xfffffffd00e81947ULL, 0x020fea000393ffffULL,
0x0000000000007918ULL, 0x010fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001fff0000047882ULL, 0x002fe20000000000ULL, 0x7ffc000000057882ULL, 0x000fd60000000000ULL,
0x00000000020612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f640000000000ULL,
0x01c61004063f75b2ULL, 0x0103700008000100ULL, 0xfffffffd00e81947ULL, 0x020fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000007f0000780cULL, 0x040fe20003f04070ULL,
0x00008400ff6c7b82ULL, 0x000f620000000800ULL, 0x000000010000780cULL, 0x000fe20003f24070ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x000000ff0c00720cULL, 0x004fca0003f65270ULL,
0x00008c00ff0a7b82ULL, 0x000f680000000a00ULL, 0x0000000000038919ULL, 0x000ea20000008800ULL,
0x0000040000028802ULL, 0x000fc80000000f00ULL, 0x0000065403058816ULL, 0x004fe20000000002ULL,
0xff317217ff038424ULL, 0x000fc800078e00ffULL, 0x0000000400028824ULL, 0x000fca00078e0205ULL,
0x01c4000302008388ULL, 0x0009e20000000800ULL, 0x0000000000381947ULL, 0x022fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000400007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x010fca0000000000ULL,
0x00000000000612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x01c64804063f75b2ULL, 0x0043300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00008200000c7ab9ULL, 0x000fe20000000a00ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x00000004150a7825ULL, 0x000fc600078e000aULL,
0x0000000000242947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x014fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01c65808043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x014fec0000010000ULL,
0x0000000000e83947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000ea20000000000ULL,
0x0000000466027824ULL, 0x008fe200078e00ffULL, 0x00008800ff087b82ULL, 0x000ee20000000a00ULL,
0x0000000407047899ULL, 0x002fe2000800063fULL, 0x000000106c007824ULL, 0x000fca00078e00ffULL,
0x0000000400007e24ULL, 0x000fe2000f8e0215ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000211037211ULL, 0x044fe200078fd8ffULL,
0x0000001011027824ULL, 0x000fe200078e00ffULL, 0x0000065405047896ULL, 0x002fe40008000004ULL,
0x0000000703047812ULL, 0x040fe200078ec0ffULL, 0x0000000203077836ULL, 0x040fe20000000000ULL,
0x000001f002137812ULL, 0x000fe200078ec0ffULL, 0x0000000103057836ULL, 0x040fe20000000000ULL,
0x0000001f04047812ULL, 0x000fe200078e7811ULL, 0x00000003030f7836ULL, 0x000fe20000000000ULL,
0x00000007070d7812ULL, 0x000fc400078ec0ffULL, 0x0000000705067812ULL, 0x000fe400078ec0ffULL,
0x0000001f0d107812ULL, 0x000fe200078e7811ULL, 0x00000020030d7824ULL, 0x000fe200078e0204ULL,
0x000000070f0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000100037824ULL, 0x000fe200078e0203ULL,
0x0000001f06067812ULL, 0x000fe200078e7811ULL, 0x0000002007107824ULL, 0x000fe200078e0210ULL,
0x0000001f0e127812ULL, 0x000fe200078e7811ULL, 0x0000020003027825ULL, 0x008fe200078e0008ULL,
0x000000040d0d7c11ULL, 0x000fc6000f8e20ffULL, 0x00000020050e7824ULL, 0x000fe200078e0206ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x0000000100057824ULL, 0x040fe400078e0205ULL,
0x0000000100077824ULL, 0x040fe400078e0207ULL, 0x0000000100117824ULL, 0x000fe400078e020fULL,
0x0000020005047825ULL, 0x000fc800078e0008ULL, 0x0000020007067825ULL, 0x000fe200078e0008ULL,
0x0000001304047210ULL, 0x000fc60007f3e0ffULL, 0x0000020011087825ULL, 0x000fe200078e0008ULL,
0x0000000410117c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000001306067210ULL, 0x000fe20007f1e0ffULL, 0x000000200f127824ULL, 0x000fe200078e0212ULL,
0x0000001308087210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x000000040e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000000412137c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e8000b901c4cULL,
0x00000000040f7faeULL, 0x0003e8000b901c4cULL, 0x0000000006117faeULL, 0x0003e8000b901c4cULL,
0x0000000008137faeULL, 0x0003e2000b901c4cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0001c60004047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0000000c0a0a7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0c00720cULL, 0x000fe40003f05270ULL, 0x000000000a0f72caULL, 0x004fda00000e0000ULL,
0x000000ff0f047890ULL, 0x002fc8000fffe03fULL, 0x000000083f057899ULL, 0x000fe20008011604ULL,
0x000000e0004c8947ULL, 0x000ff60003800000ULL, 0x00000000000679c3ULL, 0x000e620000008800ULL,
0x00000000007c7919ULL, 0x000f220000000000ULL, 0x0000000168007836ULL, 0x040fe20000000000ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000010068057824ULL, 0x000fe400078e00ffULL,
0x000000076c037c36ULL, 0x000fe20008000000ULL, 0x0000000500007c0cULL, 0x000fe2000bf06070ULL,
0x00000004ff027424ULL, 0x000fe200078e00ffULL, 0x0000000f05007c48ULL, 0x000fe2000ffe0000ULL,
0x00000002157a7824ULL, 0x000fc400078e00ffULL, 0x00000010667d7824ULL, 0x008fe400078e00ffULL,
0x0000000100007824ULL, 0x000fe400078e0a05ULL, 0x0000006c7a7a7224ULL, 0x000fc600078e0203ULL,
0x0000004000007807ULL, 0x000fc80000000000ULL, 0x000000007d007248ULL, 0x000fe20007fe0000ULL,
0x00000654060e7896ULL, 0x002fc60008000004ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x00000001000c7824ULL, 0x000fe200078e0a7dULL, 0x0001c6480e107890ULL, 0x000fe2000fffe03fULL,
0x000000047a007c24ULL, 0x000fe2000f8e0205ULL, 0x000140000e047890ULL, 0x000fe2000fffe03fULL,
0x00000004ff0d7819ULL, 0x010fe2000001167cULL, 0x01c610027dff79a7ULL, 0x0003e2000850000eULL,
0x000000107c1b7824ULL, 0x000fe400078e00ffULL, 0x0000000c0d00720cULL, 0x000fe20003f46070ULL,
0x000000017d077824ULL, 0x000fc400078e020dULL, 0x000000020d047836ULL, 0x000fe20000000000ULL,
0x000000f01b1b7812ULL, 0x000fe200078ec0ffULL, 0x000000040d067836ULL, 0x000fe20000000000ULL,
0x0000000707057812ULL, 0x000fe200078ec0ffULL, 0x000000017d097824ULL, 0x040fe200078e0204ULL,
0x0000000c0400720cULL, 0x080fe20003f66070ULL, 0x000000017d0b7824ULL, 0x000fe200078e0206ULL,
0x0000000f05047812ULL, 0x000fe200078e787cULL, 0x0000000c0d147836ULL, 0x000fe20000000000ULL,
0x0000000709057812ULL, 0x000fe200078ec0ffULL, 0x00008a00ff027b82ULL, 0x002e620000000a00ULL,
0x000000070b0f7812ULL, 0x000fe200078ec0ffULL, 0x00000010070e7824ULL, 0x000fe200078e0204ULL,
0x0000000f05047812ULL, 0x000fe200078e787cULL, 0x0000000100057824ULL, 0x000fe200078e0207ULL,
0x0000000c0600720cULL, 0x000fe20003f06070ULL, 0x0000000100077824ULL, 0x000fe200078e0209ULL,
0x0000000f0f067812ULL, 0x000fe200078e787cULL, 0x0000001009107824ULL, 0x000fe200078e0204ULL,
0x000000040e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000100097824ULL, 0x000fc400078e020bULL,
0x000000100b127824ULL, 0x000fe200078e0206ULL, 0x0000000410117c11ULL, 0x000fe2000f8e20ffULL,
0x000000060d0b7836ULL, 0x040fe40000000000ULL, 0x000000080d107836ULL, 0x000fe40000000000ULL,
0x000000017d137824ULL, 0x000fe200078e020bULL, 0x0000000c0b00720cULL, 0x000fe20003f26070ULL,
0x0000000e0d167836ULL, 0x000fe40000000000ULL, 0x000000017d157824ULL, 0x000fc400078e0214ULL,
0x0000010005047825ULL, 0x002fc800078e0002ULL, 0x0000010007067825ULL, 0x000fe200078e0002ULL,
0x0000001b040a7210ULL, 0x000fc60007f9e0ffULL, 0x0000010009087825ULL, 0x000fe200078e0002ULL,
0x0000001b06067210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0605ULL,
0x0000000713057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000001b08087210ULL, 0x000fe20007f9e0ffULL, 0x000000017d177824ULL, 0x000fe200078e0216ULL,
0x0000000f05047812ULL, 0x000fe200078e787cULL, 0x0000000100057824ULL, 0x000fe200078e0213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000d101c4cULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x0000000c1000720cULL, 0x080fe20003fa6070ULL,
0x00000010130e7824ULL, 0x000fe200078e0204ULL, 0x0000000006117faeULL, 0x0007e2000d901c4cULL,
0x0000010005047825ULL, 0x000fe200078e0002ULL, 0x0000000c1400720cULL, 0x000fc40003f66070ULL,
0x0000000c1600720cULL, 0x080fe20003f46070ULL, 0x0000000a0d137836ULL, 0x000fe40000000000ULL,
0x000000017d0d7824ULL, 0x000fe200078e0210ULL, 0x0000001b040a7210ULL, 0x002fe20007fde0ffULL,
0x0000000100197824ULL, 0x040fe200078e0217ULL, 0x0000000c1300720cULL, 0x000fe20003f86070ULL,
0x000000017d137824ULL, 0x000fe200078e0213ULL, 0x000000070d0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000100077824ULL, 0x008fe400078e020dULL, 0x000000ffff0b7224ULL, 0x000fe200030e0605ULL,
0x0000000f0f107812ULL, 0x000fe200078e787cULL, 0x0000010007047825ULL, 0x000fe200078e0002ULL,
0x00000007130f7812ULL, 0x000fc600078ec0ffULL, 0x0000000100117824ULL, 0x000fe200078e0213ULL,
0x0000001b040c7210ULL, 0x000fe20007fde0ffULL, 0x000000100d107824ULL, 0x000fe400078e0210ULL,
0x0000010011067825ULL, 0x000fc800078e0002ULL, 0x0000000100117824ULL, 0x000fe200078e0215ULL,
0x0000000f0f007812ULL, 0x000fe200078e787cULL, 0x000000ffff0d7224ULL, 0x000fe200030e0605ULL,
0x0000001b06067210ULL, 0x000fe20007fde0ffULL, 0x0000010011047825ULL, 0x000fe200078e0002ULL,
0x00000007150f7812ULL, 0x000fe400078ec0ffULL, 0x0000000717117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000001b04047210ULL, 0x000fe20007fde0ffULL,
0x0000010019027825ULL, 0x000fe200078e0002ULL, 0x0000000f0f147812ULL, 0x000fc400078e787cULL,
0x0000000f11167812ULL, 0x000fe200078e787cULL, 0x0000001013007824ULL, 0x000fe200078e0200ULL,
0x00000004120f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000001b02027210ULL, 0x000fe20007fde0ffULL, 0x0000001015147824ULL, 0x000fe200078e0214ULL,
0x000000040e117c11ULL, 0x000fe2000f8e20ffULL, 0x0000001017167824ULL, 0x000fe200078e0216ULL,
0x0000000410137c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0x0000000400157c11ULL, 0x000fe2000f8e20ffULL, 0x00000000080f7faeULL, 0x0003e2000c101c4cULL,
0x0000000414177c11ULL, 0x000fe2000f8e20ffULL, 0xff317217ff007424ULL, 0x000fe200078e00ffULL,
0x0000000416197c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a117faeULL, 0x000fe2000c901c4cULL,
0x0000000568007c0cULL, 0x000fc6000bf06070ULL, 0x000000000c137faeULL, 0x000fe8000e901c4cULL,
0x0000000006157faeULL, 0x0005e2000e101c4cULL, 0x00000001ff087424ULL, 0x002fc600078e00ffULL,
0x0000000004177faeULL, 0x000fe8000d901c4cULL, 0x0000000002197faeULL, 0x0005e2000d101c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a50ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x01c65808ffff79a7ULL, 0x0003e2000850000eULL,
0x000000ffff067224ULL, 0x004fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fc4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000a400000947ULL, 0x002fec0003800000ULL,
0x0000000266027811ULL, 0x000fe200078e10ffULL, 0xff317217ff007424ULL, 0x000fe200078e00ffULL,
0x00007610ff057816ULL, 0x000fe20000000005ULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x00007610ff047816ULL, 0x000fe20000000004ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00007610ff7b7816ULL, 0x000fce000000007bULL, 0x0000010068027824ULL, 0x000fca00078e00ffULL,
0x0000000f02007c0cULL, 0x000fda000bf06070ULL, 0x000000a000c40947ULL, 0x000fea0003800000ULL,
0x0000ffff05077812ULL, 0x000fe200078ec0ffULL, 0x00008e0000127ab9ULL, 0x000fe20000000800ULL,
0x00000004ff647819ULL, 0x000fe2000001167cULL, 0x00008a00ff6a7b82ULL, 0x000e620000000a00ULL,
0x0000888007127816ULL, 0x000fe200000000ffULL, 0x0000000168027836ULL, 0x040fe20000000000ULL,
0x0000004068037811ULL, 0x000fe200078e40ffULL, 0x000000017d0a7824ULL, 0x000fe400078e0264ULL,
0x8000000012127824ULL, 0x000fe200078e00ffULL, 0x0000000502007c0cULL, 0x000fe2000bf06070ULL,
0x00000004646f7836ULL, 0x000fe20000000000ULL, 0x000000070a097812ULL, 0x000fe200078ec0ffULL,
0x01c65812ff0075a7ULL, 0x000ea2000802004eULL, 0x00000008646d7836ULL, 0x000fc40000000000ULL,
0x000000017d0c7824ULL, 0x040fe200078e026fULL, 0x0000000f09097812ULL, 0x000fe200078e787cULL,
0x000000127a077c24ULL, 0x000fe4000f8e0203ULL, 0x0000000264707836ULL, 0x000fe20000000000ULL,
0x000000070c0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000a646c7836ULL, 0x000fe40000000000ULL,
0x000000017d107824ULL, 0x000fe200078e026dULL, 0x0000000f0b0b7812ULL, 0x000fe200078e787cULL,
0x000000100a5b7824ULL, 0x000fc400078e0209ULL, 0x000000010a0d7824ULL, 0x000fe200078e0207ULL,
0x0000000710137812ULL, 0x000fe200078ec0ffULL, 0x000000017d0a7824ULL, 0x040fe400078e0270ULL,
0x00000006646e7836ULL, 0x000fe20000000000ULL, 0x0000000f13137812ULL, 0x000fe200078e787cULL,
0x000000017d247824ULL, 0x040fe200078e026cULL, 0x000000070a097812ULL, 0x000fe200078ec0ffULL,
0x0000000c64697836ULL, 0x040fe40000000000ULL, 0x0000000e64657836ULL, 0x000fe20000000000ULL,
0x0000000f09097812ULL, 0x000fe200078e787cULL, 0x000000017d0e7824ULL, 0x000fc400078e026eULL,
0x000000100c597824ULL, 0x000fe200078e020bULL, 0x00000007240b7812ULL, 0x000fe200078ec0ffULL,
0x000000017d267824ULL, 0x040fe200078e0269ULL, 0x000000070e117812ULL, 0x000fe200078ec0ffULL,
0x000000017d547824ULL, 0x000fe200078e0265ULL, 0x0000000f0b0b7812ULL, 0x000fe200078e787cULL,
0x0000001010577824ULL, 0x000fe200078e0213ULL, 0x0000000726137812ULL, 0x000fe200078ec0ffULL,
0x000000107c027824ULL, 0x000fe200078e00ffULL, 0x0000000754317812ULL, 0x000fe200078ec0ffULL,
0x000000100a5a7824ULL, 0x000fe200078e0209ULL, 0x0000000f11097812ULL, 0x000fe200078e787cULL,
0x000000010c117824ULL, 0x000fe200078e0207ULL, 0x0000000f13137812ULL, 0x000fe200078e787cULL,
0x0000001024567824ULL, 0x000fe200078e020bULL, 0x0000000f310b7812ULL, 0x000fe200078e787cULL,
0x000001000d0c7825ULL, 0x002fe200078e006aULL, 0x000000f002637812ULL, 0x000fc600078ec0ffULL,
0x000000010a0f7824ULL, 0x000fe200078e0207ULL, 0x000000630c0a7210ULL, 0x000fe20007f5e0ffULL,
0x000000100e587824ULL, 0x040fe400078e0209ULL, 0x000000010e097824ULL, 0x100fe400078e0207ULL,
0x0000000110257824ULL, 0x100fe400078e0207ULL, 0x0000000124277824ULL, 0x100fe200078e0207ULL,
0x0000000f03247c48ULL, 0x000fe2000ffe0000ULL, 0x00000001543f7824ULL, 0x000fc400078e0207ULL,
0x0000001026557824ULL, 0x040fe400078e0213ULL, 0x0000000126317824ULL, 0x000fe400078e0207ULL,
0x0000001054547824ULL, 0x000fe400078e020bULL, 0x000001000f0e7825ULL, 0x000fc800078e006aULL,
0x0000010011107825ULL, 0x000fe200078e006aULL, 0x0000000000081947ULL, 0x004fec0003800000ULL,
0x01c65812ff0075a7ULL, 0x000e64000802014eULL, 0x0000012800289947ULL, 0x002fea0003800000ULL,
0x0000000124247824ULL, 0x000fe200078e0a03ULL, 0x0000000e04077899ULL, 0x000fe2000800063fULL,
0x000000ffff0b7224ULL, 0x000fe200010e060dULL, 0x00000063100c7210ULL, 0x000fe20007f5e0ffULL,
0x0000010025127825ULL, 0x000fe200078e006aULL, 0x0000004024247807ULL, 0x000fe20000000000ULL,
0x0000400007067892ULL, 0x000fe2000f8e0c3fULL, 0x000000630e0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0611ULL, 0x000000247d247248ULL, 0x000fe20007fe0000ULL,
0x0000010009107825ULL, 0x000fe200078e006aULL, 0x000140000e067890ULL, 0x000fe2000fffe006ULL,
0x0000006312127210ULL, 0x000fe20007f9e0ffULL, 0x0000000304087899ULL, 0x000fe2000800063fULL,
0x0000000124077824ULL, 0x000fe200078e0a7dULL, 0x0000006310107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x000000065b097c11ULL, 0x000fe2000f8e20ffULL,
0x0000010027247825ULL, 0x000fe200078e006aULL, 0x000000076400720cULL, 0x080fe20003f46070ULL,
0x0000000808097892ULL, 0x000fe2000f8e0c3fULL, 0x000000077000720cULL, 0x080fe20003f26070ULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x000000076f00720cULL, 0x000fe20003f66070ULL,
0x0000010031267825ULL, 0x000fe200078e006aULL, 0x000000065a337c11ULL, 0x000fc4000f8e20ffULL,
0x00000006593d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe200020e0613ULL,
0x0000006324247210ULL, 0x000fe20007f9e0ffULL, 0x000001003f307825ULL, 0x000fe200078e006aULL,
0x0000006326267210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a097faeULL, 0x0003e2000d101c4cULL, 0x000000076d00720cULL, 0x080fe20003f46070ULL,
0x000000ffff257224ULL, 0x000fe200020e0625ULL, 0x000000076900720cULL, 0x080fe20003f86070ULL,
0x000000000e337faeULL, 0x0007e2000c901c4cULL, 0x000000076e00720cULL, 0x080fe20003f26070ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x000000076500720cULL, 0x080fe20003fa6070ULL,
0x000000000c3d7faeULL, 0x0009e2000d901c4cULL, 0x000000076c00720cULL, 0x000fc40003f66070ULL,
0x0000000658077c11ULL, 0x000fe4000f8e20ffULL, 0x0000006330307210ULL, 0x000fe40007fde0ffULL,
0x0000000657097c11ULL, 0x002fe4000f8e20ffULL, 0x00000006560b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000010077faeULL, 0x0003e2000c901c4cULL, 0x00000006540f7c11ULL, 0x008fe2000f8e20ffULL,
0x000000ffff317224ULL, 0x000fe200030e0631ULL, 0x00000006550d7c11ULL, 0x010fe2000f8e20ffULL,
0x0000000910067290ULL, 0x000fe2000fffe03fULL, 0x0000000012097faeULL, 0x000fe2000d101c4cULL,
0x0000ffff040a7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7b0c7812ULL, 0x000fe200078ec0ffULL,
0x00000000240b7faeULL, 0x0007e2000d901c4cULL, 0x000088800a0a7816ULL, 0x000fe200000000ffULL,
0x00000009ff077e24ULL, 0x002fe4000f8e00ffULL, 0x00000000260d7faeULL, 0x0005e2000e101c4cULL,
0x000088800c507816ULL, 0x000fe200000000ffULL, 0x000000ffff117224ULL, 0x000fe400078e000aULL,
0x00000000300f7faeULL, 0x0005e4000e901c4cULL, 0x8000000011117824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000008ff247e24ULL, 0x008fc4000f8e00ffULL,
0x80000000500a7824ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000011240075a7ULL, 0x0002620008020050ULL,
0x00000001ff097819ULL, 0x004fe4000001167cULL, 0x0000007002077812ULL, 0x000fe400078ec0ffULL,
0x0000000c09027812ULL, 0x000fc800078ec0ffULL, 0x0000000e02077c10ULL, 0x000fe2000fffe007ULL,
0x01c6080aff0075a7ULL, 0x000ea4000804014eULL, 0x000001240018a947ULL, 0x006fea0003800000ULL,
0x01c00000070b7984ULL, 0x000e620000000800ULL, 0x000000087c097812ULL, 0x000fe200078ec0ffULL,
0x00000004660c7824ULL, 0x000fe200078e0264ULL, 0x000140000e067890ULL, 0x000fe2000fffe007ULL,
0x00000001ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000000709257812ULL, 0x000fe200078ec87cULL,
0x0000000810087290ULL, 0x000fe2000fffe03fULL, 0x0000000709097812ULL, 0x000fe400078ef87cULL,
0x0000000c250c7212ULL, 0x000fca00078e3cffULL, 0x0000001009477824ULL, 0x000fca00078e020cULL,
0x0000000647107c11ULL, 0x000fe4000f8e20ffULL, 0x000000000b00720bULL, 0x002fda0003f5d000ULL,
0x0000000000027806ULL, 0x000fc800010e0100ULL, 0x0000ffff020f7812ULL, 0x000fe4000784c0ffULL,
0x01c2000007027984ULL, 0x0002b60000000800ULL, 0x0000000000d4a947ULL, 0x002fea0003800000ULL,
0x000000000b00720bULL, 0x000fe40003f54000ULL, 0x0000000b00127209ULL, 0x000fe40007810000ULL,
0x00000002ff0d7819ULL, 0x000fc6000001167cULL, 0x80000012000a7221ULL, 0x000fe40000010000ULL,
0x000000080d0e7836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fe40000410000ULL,
0x0000000000007806ULL, 0x000fe400010e0100ULL, 0x0000000a00137308ULL, 0x0002e20000000800ULL,
0x000000ff6600720cULL, 0x000fe40003f45270ULL, 0x0000ffff00007812ULL, 0x000fc800078e3cffULL,
0x000000000fff7212ULL, 0x000fe2000786c0ffULL, 0x000000ffff007224ULL, 0x000fc600078e0012ULL,
0x00000001ff0a7807ULL, 0x002fc60001800000ULL, 0x01c400120700a388ULL, 0x000fe20000000800ULL,
0x0000001306067220ULL, 0x008fc60000410000ULL, 0x00001f0e130e7589ULL, 0x000e6400000e0000ULL,
0x800000120b0b3221ULL, 0x000fe40000010000ULL, 0x00001f0d130d7589ULL, 0x000ee400000e0000ULL,
0x3fb8aa3b0b0b3820ULL, 0x000fc80000410000ULL, 0x0000000b00083308ULL, 0x000f220000000800ULL,
0x0000000e1b1b7220ULL, 0x082fe20000410000ULL, 0x0000000e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000e17177220ULL, 0x080fe20000410000ULL, 0x0000000e16167220ULL, 0x080fe20000410000ULL,
0x0000000e1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000e1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000e37377220ULL, 0x080fe20000410000ULL, 0x0000000e36367220ULL, 0x080fe20000410000ULL,
0x0000000e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000e23237220ULL, 0x080fe20000410000ULL, 0x0000000e22227220ULL, 0x000fe20000410000ULL,
0x0000000d19197220ULL, 0x088fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d35357220ULL, 0x080fe20000410000ULL, 0x0000000d34347220ULL, 0x080fe20000410000ULL,
0x0000000d39397220ULL, 0x080fe20000410000ULL, 0x0000000d38387220ULL, 0x080fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000d29297220ULL, 0x080fe20000410000ULL, 0x0000000d28287220ULL, 0x080fe20000410000ULL,
0x0000000d21217220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x000fe20000410000ULL,
0x0000000802023220ULL, 0x014fce0000410000ULL, 0x0000000000081947ULL, 0x000fea0003800000ULL,
0x00000011240075a7ULL, 0x000e640008020150ULL, 0x0000012000189947ULL, 0x002fea0003800000ULL,
0x00000002660b7811ULL, 0x000fe200078e10ffULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x00000002ff727819ULL, 0x000fe2000001167cULL, 0x000000010400788cULL, 0x000fe2000bf05270ULL,
0x000099100a5f7816ULL, 0x000fe200000000ffULL, 0x00000001640e7824ULL, 0x000fe200078e020bULL,
0x000000077c0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000872717836ULL, 0x000fe20000000000ULL,
0x000000ff5f00720cULL, 0x000fe20003f25270ULL, 0x0000000104087892ULL, 0x000fe2000f8e0c3fULL,
0x000000080b467812ULL, 0x000fe200078ef87cULL, 0x00000001ff757424ULL, 0x000fe200078e00ffULL,
0x0000000e250d7212ULL, 0x000fe200078e3cffULL, 0x0000000602067221ULL, 0x004fe20000010000ULL,
0x00000007640b7812ULL, 0x000fc400078e7846ULL, 0x00000100095c7811ULL, 0x040fe200078e20ffULL,
0x00000010094f7824ULL, 0x000fe200078e020dULL, 0x0000000f03007c0cULL, 0x000fe2000bf41070ULL,
0x00000008460b7824ULL, 0x000fe200078e020bULL, 0x000000ff05ff7812ULL, 0x000fe2000788c0ffULL,
0x000000010c537824ULL, 0x100fe200078e025cULL, 0x000000064f3c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000e04067291ULL, 0x000fe4000f8e703fULL, 0x0000000e0b617c11ULL, 0x000fe2000f8e20ffULL,
0x000000010d5c7824ULL, 0x000fe200078e025cULL, 0x00000008ff0b723eULL, 0x000fe200000010ffULL,
0x0001400006067890ULL, 0x000fe2000fffe03fULL, 0x000000003c3c783bULL, 0x000ea20000004200ULL,
0x000000000000781cULL, 0x000fc40003f6f008ULL, 0x000054100b457816ULL, 0x000fe2000000000bULL,
0x012000006140783bULL, 0x000fe20000000200ULL, 0x0000000653247c11ULL, 0x000fe4000f8e20ffULL,
0x000000065c307c11ULL, 0x000fe2000f8e20ffULL, 0x00001f72450b7589ULL, 0x000ee800000e0000ULL,
0x00001f71450a7589ULL, 0x000f2200000e0000ULL, 0x00000018ff5d7819ULL, 0x002fe20000011410ULL,
0x00000100100f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011411ULL,
0x00000100115f7824ULL, 0x040fe200078e00ffULL, 0x0000888010447816ULL, 0x040fe200000000ffULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00008880115e7816ULL, 0x040fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x00000018ff117819ULL, 0x000fc40000011411ULL,
0x00000018ff517819ULL, 0x000fe20000011412ULL, 0x000000003030783bULL, 0x000f620000004200ULL,
0x00000018ff4e7819ULL, 0x000fe20000011413ULL, 0x0000005200527306ULL, 0x000fe20000202400ULL,
0x00000018ff0f7819ULL, 0x000fce000001140fULL, 0x0000001000107306ULL, 0x000f220000202400ULL,
0x00000018ff4c7819ULL, 0x004fe4000001143dULL, 0x00000018ff4d7819ULL, 0x000fe2000001143cULL,
0x0000000b40409232ULL, 0x008fe20000200000ULL, 0x000088803e627816ULL, 0x000fc600000000ffULL,
0x0000001100117306ULL, 0x000ea20000202400ULL, 0x0000000b42429232ULL, 0x000fe20000200000ULL,
0x000088803f737816ULL, 0x000fe200000000ffULL, 0x0000000a41419232ULL, 0x090fe20000200000ULL,
0x00000018ff4b7819ULL, 0x000fe2000001143fULL, 0x0000000a43439232ULL, 0x000fe20000200000ULL,
0x00000018ff4a7819ULL, 0x000fe4000001143eULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x0000541010107816ULL, 0x000fe4000000005dULL, 0x00008880125d7816ULL, 0x000fc400000000ffULL,
0x0000541011117816ULL, 0x004fc60000000052ULL, 0x0000005f005f7306ULL, 0x000ea20000202400ULL,
0x00000018ff497819ULL, 0x002fe40000011424ULL, 0x00000018ff487819ULL, 0x000fe20000011425ULL,
0x000000104028723cULL, 0x000fe20000041828ULL, 0x00000018ff0e7819ULL, 0x000fc60000011426ULL,
0x0000005d00527306ULL, 0x000fe60000202400ULL, 0x0000888013117816ULL, 0x040fe400000000ffULL,
0x000054105e457816ULL, 0x004fe2000000005fULL, 0x00000100125e7824ULL, 0x040fe400078e00ffULL,
0x0000005100517306ULL, 0x000fe20000202400ULL, 0x0001000012127824ULL, 0x000fe400078e00ffULL,
0x00000018ff107819ULL, 0x000fe2000001145eULL, 0x00000100135e7824ULL, 0x000fc400078e00ffULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x00000010005f7306ULL, 0x000e620000202400ULL,
0x00000018ff607819ULL, 0x000fe4000001145eULL, 0x00000018ff5e7819ULL, 0x000fe40000011412ULL,
0x00000018ff137819ULL, 0x000fc60000011413ULL, 0x0000001100117306ULL, 0x000fe20000202400ULL,
0x000088803c127816ULL, 0x000fe400000000ffULL, 0x0000541052107816ULL, 0x002fca000000005fULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x000001003c527824ULL, 0x000fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011452ULL, 0x0000004e004e7306ULL, 0x000fe20000202400ULL,
0x0000541011117816ULL, 0x002fce0000000060ULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x00000010402c723cULL, 0x000fee000004182cULL, 0x00000013005d7306ULL, 0x000e620000202400ULL,
0x000001003d107824ULL, 0x040fe200078e00ffULL, 0x000088803d117816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fca00078e00ffULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x00000018ff607819ULL, 0x000fe20000011410ULL, 0x000100003c107824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc8000001143dULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000001100137306ULL, 0x0003f00000202400ULL, 0x00000060003c7306ULL, 0x0004e20000202400ULL,
0x000054105d117816ULL, 0x002fce000000004eULL, 0x0000001000527306ULL, 0x0003220000202400ULL,
0x0000020009607811ULL, 0x044fe400078e20ffULL, 0x0000030009097811ULL, 0x000fca00078e20ffULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x000054105e107816ULL, 0x002fe20000000051ULL,
0x000001003e517824ULL, 0x040fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fe400078e00ffULL,
0x000000010c5e7824ULL, 0x000fe200078e0260ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x000000104038723cULL, 0x000fe20000041838ULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x000000010d607824ULL, 0x000fca00078e0260ULL,
0x0000001200127306ULL, 0x000fe20000202400ULL, 0x0000541013117816ULL, 0x008fe4000000003cULL,
0x00005410523c7816ULL, 0x010fe2000000004dULL, 0x000001003f4d7824ULL, 0x040fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000054103d3d7816ULL, 0x002fe2000000004cULL,
0x0000005f005f7306ULL, 0x000e620000202400ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4c7819ULL, 0x000fc6000001143fULL, 0x0000003c401c723cULL, 0x000fe4000004181cULL,
0x00000062004e7306ULL, 0x0005ea0000202400ULL, 0x000000027c3d7811ULL, 0x000fe400078fe0ffULL,
0x0000541012107816ULL, 0x002fe2000000005fULL, 0x0000005100517306ULL, 0x000e620000202400ULL,
0x000000073d3d7812ULL, 0x000fc400078e7846ULL, 0x000000065e127c11ULL, 0x000fc6000f8e20ffULL,
0x00000008463d7824ULL, 0x000fe200078e023dULL, 0x000000104034723cULL, 0x000fe20000041834ULL,
0x0000007300527306ULL, 0x000be20000202400ULL, 0x000000001210783bULL, 0x000ee40000004200ULL,
0x0000000e3d627c11ULL, 0x004fe4000f8e20ffULL, 0x000054104e3c7816ULL, 0x002fc60000000051ULL,
0x0000004d005f7306ULL, 0x000e620000202400ULL, 0x00008880264e7816ULL, 0x000fe400000000ffULL,
0x00000018ff737819ULL, 0x020fe40000011432ULL, 0x00000018ff517819ULL, 0x000fc60000011433ULL,
0x0000004a004a7306ULL, 0x000fe20000202400ULL, 0x00005410523d7816ULL, 0x002fce000000005fULL,
0x0000004b004b7306ULL, 0x000fe20000202400ULL, 0x00008880335f7816ULL, 0x000fce00000000ffULL,
0x0000004400447306ULL, 0x000ff00000202400ULL, 0x0000000f000f7306ULL, 0x000e620000202400ULL,
0x00000018ff527819ULL, 0x008fce0000011410ULL, 0x0000003e005d7306ULL, 0x0004e20000202400ULL,
0x0000541044447816ULL, 0x002fce000000000fULL, 0x0000004c004c7306ULL, 0x000e620000202400ULL,
0x0000003c403c723cULL, 0x004fe20000041814ULL, 0x012000006214783bULL, 0x000ea20000000200ULL,
0x00000018ff0f7819ULL, 0x000fe40000011427ULL, 0x000054105d4a7816ULL, 0x008fe4000000004aULL,
0x000000444020723cULL, 0x000fe20000041820ULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x000054104c4b7816ULL, 0x002fce000000004bULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x00000018ff457819ULL, 0x000fe40000011430ULL, 0x00000018ff447819ULL, 0x000fe20000011431ULL,
0x0000004a4018723cULL, 0x000fe20000041818ULL, 0x00000018ff4c7819ULL, 0x000fc60000011411ULL,
0x0000000e000e7306ULL, 0x000fe60000202400ULL, 0x0000010024417824ULL, 0x040fe200078e00ffULL,
0x0000888024407816ULL, 0x040fe200000000ffULL, 0x0000010025437824ULL, 0x040fe200078e00ffULL,
0x0000888025427816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000004000407306ULL, 0x000fe20000202400ULL,
0x00000018ff4a7819ULL, 0x000fc40000011424ULL, 0x00000018ff4b7819ULL, 0x000fe20000011425ULL,
0x0000000b14149232ULL, 0x084fe40000200000ULL, 0x0000000b16169232ULL, 0x000fe40000200000ULL,
0x0000004100417306ULL, 0x000e620000202400ULL, 0x0000000a15159232ULL, 0x080fe40000200000ULL,
0x0000000a17179232ULL, 0x000fca0000200000ULL, 0x0000004200427306ULL, 0x000fe20000202400ULL,
0x0000541040247816ULL, 0x002fce0000000041ULL, 0x0000004300437306ULL, 0x000e620000202400ULL,
0x0000000660407c11ULL, 0x000fce000f8e20ffULL, 0x0000004a004a7306ULL, 0x000ea20000202400ULL,
0x0000541042257816ULL, 0x002fce0000000043ULL, 0x0000004b004b7306ULL, 0x000e620000202400ULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x000000241420723cULL, 0x000fec0000041820ULL,
0x0000000f000f7306ULL, 0x000fe20000202400ULL, 0x000000ffff257224ULL, 0x000fe200078e004eULL,
0x000054104a247816ULL, 0x004fe20000000049ULL, 0x00000100264a7824ULL, 0x000fca00078e00ffULL,
0x0000004500457306ULL, 0x000fe20000202400ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011413ULL, 0x00000018ff4a7819ULL, 0x000fc8000001144aULL,
0x0000002500497306ULL, 0x0003f00000202400ULL, 0x0000004400447306ULL, 0x000fe20000202400ULL,
0x000054104b257816ULL, 0x002fe40000000048ULL, 0x00008880274b7816ULL, 0x000fca00000000ffULL,
0x000000241428723cULL, 0x000fe20000041828ULL, 0x0000004a00487306ULL, 0x0002ac0000202400ULL,
0x0000010027247824ULL, 0x040fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011412ULL,
0x0000004b004b7306ULL, 0x000fe20000202400ULL, 0x00000018ff4a7819ULL, 0x002fe20000011426ULL,
0x0001000027267824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fc40000011424ULL,
0x00000018ff247819ULL, 0x008fe40000011440ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000005d00747306ULL, 0x0002e20000202400ULL, 0x0000541049487816ULL, 0x004fce0000000048ULL,
0x0000004a00277306ULL, 0x000ea20000202400ULL, 0x000000010c5d7824ULL, 0x002fe200078e0209ULL,
0x000054104b497816ULL, 0x008fcc0000000074ULL, 0x0000002600267306ULL, 0x000e620000202400ULL,
0x00000048142c723cULL, 0x000fe2000004182cULL, 0x00005410270e7816ULL, 0x004fe2000000000eULL,
0x0000010031277824ULL, 0x000fca00078e00ffULL, 0x00000073004d7306ULL, 0x0005e20000202400ULL,
0x0000010030497824ULL, 0x040fe200078e00ffULL, 0x0000888030487816ULL, 0x040fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00005410260f7816ULL, 0x002fc8000000000fULL,
0x0000005f000c7306ULL, 0x000fe20000202400ULL, 0x00000018ff4b7819ULL, 0x000fe40000011449ULL,
0x0000888031497816ULL, 0x040fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000000e1438723cULL, 0x000fe20000041838ULL,
0x00000018ff4a7819ULL, 0x000fe20000011427ULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x0000888032277816ULL, 0x000fc800000000ffULL, 0x00000018ff0f7819ULL, 0x000fe20000011431ULL,
0x00000100320e7824ULL, 0x000fe400078e00ffULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x0000010033317824ULL, 0x040fe400078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0001000033337824ULL, 0x000fe400078e00ffULL, 0x00000018ff737819ULL, 0x004fe40000011431ULL,
0x0000000f000f7306ULL, 0x000e700000202400ULL, 0x0000000e00267306ULL, 0x0005e20000202400ULL,
0x000054100f0f7816ULL, 0x002fce0000000044ULL, 0x0000002700277306ULL, 0x000e620000202400ULL,
0x00010000320e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fc80000011441ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x0000007300327306ULL, 0x000eb00000202400ULL,
0x0000000e00317306ULL, 0x0007f00000202400ULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x00005410300e7816ULL, 0x008fe20000000045ULL, 0x000000010d457824ULL, 0x000fe200078e0209ULL,
0x00000018ff307819ULL, 0x000fc40000011433ULL, 0x0000888012097816ULL, 0x000fc600000000ffULL,
0x0000000e141c723cULL, 0x000fe2000004181cULL, 0x0000003000307306ULL, 0x000fec0000202400ULL,
0x000000047c0f7811ULL, 0x000fe400078fe0ffULL, 0x00005410270e7816ULL, 0x002fe20000000026ULL,
0x0000004b004b7306ULL, 0x000e620000202400ULL, 0x000000070f277812ULL, 0x000fc400078e7846ULL,
0x000054100c0f7816ULL, 0x004fe40000000032ULL, 0x00008880100c7816ULL, 0x000fe200000000ffULL,
0x0000000846277824ULL, 0x000fe200078e0227ULL, 0x00000018ff267819ULL, 0x000fe20000011442ULL,
0x0000004900497306ULL, 0x000fe40000202400ULL, 0x0000000e143c723cULL, 0x000fe2000004183cULL,
0x0000000e27777c11ULL, 0x000fe4000f8e20ffULL, 0x00000018ff277819ULL, 0x000fc40000011443ULL,
0x0000541048487816ULL, 0x002fe2000000004bULL, 0x0000004a004a7306ULL, 0x000e620000202400ULL,
0x00005410310e7816ULL, 0x000fe4000000004dULL, 0x00005410300f7816ULL, 0x000fe40000000051ULL,
0x012000007730783bULL, 0x000ea60000000200ULL, 0x0000005200527306ULL, 0x000fe40000202400ULL,
0x0000000e1418723cULL, 0x000fe20000041818ULL, 0x0000541049497816ULL, 0x002fca000000004aULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x00000100100e7824ULL, 0x040fe400078e00ffULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x000000481448723cULL, 0x000fe40000041834ULL,
0x00000018ff0f7819ULL, 0x000fe4000001140eULL, 0x0000000c000c7306ULL, 0x000fe20000202400ULL,
0x00008880110e7816ULL, 0x040fe400000000ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000010011157824ULL, 0x000fe200078e00ffULL, 0x000000065d347c11ULL, 0x000fe2000f8e20ffULL,
0x0001000011117824ULL, 0x000fc400078e00ffULL, 0x00000010004d7306ULL, 0x0003e20000202400ULL,
0x00000018ff167819ULL, 0x000fe40000011415ULL, 0x00000018ff177819ULL, 0x000fe20000011411ULL,
0x000000003434783bULL, 0x000ee80000004200ULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x0000010012107824ULL, 0x042fe400078e00ffULL, 0x0001000012127824ULL, 0x000fc400078e00ffULL,
0x0000000b30309232ULL, 0x084fe40000200000ULL, 0x0000000b32329232ULL, 0x000fe20000200000ULL,
0x0000001700177306ULL, 0x000e620000202400ULL, 0x0000000a31319232ULL, 0x080fe20000200000ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000000a33339232ULL, 0x000fca0000200000ULL,
0x0000001600517306ULL, 0x0005220000202400ULL, 0x0000541017177816ULL, 0x002fce000000004cULL,
0x0000000f000f7306ULL, 0x000e620000202400ULL, 0x000054104d167816ULL, 0x004fe40000000052ULL,
0x00008880134d7816ULL, 0x000fe400000000ffULL, 0x000054100e0d7816ULL, 0x010fc60000000051ULL,
0x000000163028723cULL, 0x000fe20000041828ULL, 0x00000009004c7306ULL, 0x0005e20000202400ULL,
0x00000018ff157819ULL, 0x008fca0000011435ULL, 0x00000018ff177819ULL, 0x000fe20000011410ULL,
0x0000010013107824ULL, 0x040fe200078e00ffULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x000054100c0c7816ULL, 0x002fe2000000000fULL, 0x0001000013097824ULL, 0x004fe200078e00ffULL,
0x00000006450f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000400067c82ULL, 0x000fe20008000000ULL,
0x00000018ff517819ULL, 0x000fe20000011410ULL, 0x0000000800047c82ULL, 0x000fe20008000000ULL,
0x00000018ff117819ULL, 0x000fe20000011436ULL, 0x0000001700177306ULL, 0x000e620000202400ULL,
0x0000000c3020723cULL, 0x000fe20000041820ULL, 0x000000000f0c783bULL, 0x000ea20000004200ULL,
0x00000018ff167819ULL, 0x000fc40000011437ULL, 0x00000018ff147819ULL, 0x000fc60000011434ULL,
0x0000005100527306ULL, 0x000ee20000202400ULL, 0x000054104c4c7816ULL, 0x002fce0000000017ULL,
0x0000002500257306ULL, 0x000fe20000202400ULL, 0x0000888040177816ULL, 0x000fe400000000ffULL,
0x000054104d4d7816ULL, 0x008fca0000000052ULL, 0x0000001200127306ULL, 0x000e640000202400ULL,
0x0000004c302c723cULL, 0x000fec000004182cULL, 0x0000004e004e7306ULL, 0x000fe20000202400ULL,
0x00000018ff4c7819ULL, 0x000fce0000011409ULL, 0x0000001700177306ULL, 0x000fe20000202400ULL,
0x00000018ff517819ULL, 0x004fe4000001140dULL, 0x00000018ff107819ULL, 0x000fe4000001140cULL,
0x00000018ff097819ULL, 0x000fc6000001140eULL, 0x0000004c004d7306ULL, 0x0002b00000202400ULL,
0x0000005100137306ULL, 0x0007e20000202400ULL, 0x00005410124c7816ULL, 0x002fe20000000025ULL,
0x0000010040127824ULL, 0x000fc400078e00ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x000054104d4d7816ULL, 0x004fc6000000004eULL, 0x0000002400247306ULL, 0x000fe20000202400ULL,
0x00000018ff257819ULL, 0x000fe20000011412ULL, 0x0000010041127824ULL, 0x040fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000004c3038723cULL, 0x000fe60000041838ULL,
0x00000018ff4e7819ULL, 0x000fe20000011412ULL, 0x00000025004c7306ULL, 0x000fe20000202400ULL,
0x00000018ff127819ULL, 0x000fe4000001140fULL, 0x00008880414d7816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fc800078e00ffULL, 0x0000004e004e7306ULL, 0x000fe20000202400ULL,
0x00000018ff517819ULL, 0x008fce0000011441ULL, 0x0000004d004d7306ULL, 0x000e700000202400ULL,
0x0000004000257306ULL, 0x0004e20000202400ULL, 0x000054104d417816ULL, 0x002fce000000004eULL,
0x0000004400447306ULL, 0x000fe20000202400ULL, 0x0000541017407816ULL, 0x004fe4000000004cULL,
0x0000888042177816ULL, 0x000fe400000000ffULL, 0x00008880344e7816ULL, 0x000fe400000000ffULL,
0x0000541025247816ULL, 0x008fe20000000024ULL, 0x0000005100517306ULL, 0x000e620000202400ULL,
0x000000403048723cULL, 0x000fee0000041848ULL, 0x000000ffff417224ULL, 0x000fe200078e0017ULL,
0x0000002600267306ULL, 0x000fe20000202400ULL, 0x0000010042177824ULL, 0x000fc400078e00ffULL,
0x0000010043407824ULL, 0x040fe400078e00ffULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011417ULL, 0x0000888043177816ULL, 0x040fe200000000ffULL,
0x0000004100417306ULL, 0x000fe20000202400ULL, 0x00000018ff527819ULL, 0x000fe20000011440ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x0000541051257816ULL, 0x002fe40000000044ULL,
0x00000018ff407819ULL, 0x000fc40000011442ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000004d004d7306ULL, 0x000e620000202400ULL, 0x0000888035427816ULL, 0x000fe200000000ffULL,
0x00000024301c723cULL, 0x000fe2000004181cULL, 0x0000888036447816ULL, 0x000fca00000000ffULL,
0x0000001700177306ULL, 0x000fe20000202400ULL, 0x0000010034247824ULL, 0x040fe400078e00ffULL,
0x0000010035257824ULL, 0x040fe400078e00ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000005200527306ULL, 0x000ea20000202400ULL, 0x00000018ff257819ULL, 0x000fc60000011425ULL,
0x00000018ff347819ULL, 0x000fc80000011434ULL, 0x0000002400517306ULL, 0x0003f00000202400ULL,
0x00000025004c7306ULL, 0x0005e20000202400ULL, 0x0000541041247816ULL, 0x002fe4000000004dULL,
0x00000018ff417819ULL, 0x000fe20000011435ULL, 0x0000010036357824ULL, 0x000fc400078e00ffULL,
0x0001000036367824ULL, 0x000fe400078e00ffULL, 0x0000002700277306ULL, 0x000fe20000202400ULL,
0x0000541017257816ULL, 0x004fe40000000052ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x00000018ff357819ULL, 0x000fc60000011435ULL, 0x0000004000407306ULL, 0x000e620000202400ULL,
0x00000024303c723cULL, 0x000fee000004183cULL, 0x0000004300437306ULL, 0x000ea20000202400ULL,
0x000000067c257811ULL, 0x000fc800078fe0ffULL, 0x0000000725257812ULL, 0x000fe400078e7846ULL,
0x0000541040267816ULL, 0x002fe20000000026ULL, 0x0000004100177306ULL, 0x0003e40000202400ULL,
0x0000000846257824ULL, 0x000fe200078e0225ULL, 0x0000888037467816ULL, 0x000fe400000000ffULL,
0x0000541043277816ULL, 0x004fc60000000027ULL, 0x0000004e004e7306ULL, 0x000ea20000202400ULL,
0x0000000e255f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010037417824ULL, 0x042fe400078e00ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x000000263030723cULL, 0x000fe20000041818ULL,
0x012000005f18783bULL, 0x000e640000000200ULL, 0x0000004200427306ULL, 0x000ee20000202400ULL,
0x00000018ff4d7819ULL, 0x000fe20000011437ULL, 0x01c65875ffff79a7ULL, 0x0009e2000850000eULL,
0x000088800c377816ULL, 0x040fe200000000ffULL, 0x000001000c267824ULL, 0x040fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x000100000c0c7824ULL, 0x000fc400078e00ffULL,
0x0000003600257306ULL, 0x000be20000202400ULL, 0x00000018ff437819ULL, 0x000fe20000011426ULL,
0x000001000d267824ULL, 0x040fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x01c61075ffff79a7ULL, 0x0009e8000850000eULL, 0x0000004400247306ULL, 0x0005e20000202400ULL,
0x000088800d367816ULL, 0x060fe200000000ffULL, 0x000100000d0d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x0000004600407306ULL, 0x000be20000202400ULL,
0x00000018ff447819ULL, 0x004fce0000011426ULL, 0x0000000c00267306ULL, 0x0005e20000202400ULL,
0x000088800e467816ULL, 0x020fe200000000ffULL, 0x0000000b18189232ULL, 0x002fcc0000200000ULL,
0x0000000d00277306ULL, 0x0006620000202400ULL, 0x000054104e0c7816ULL, 0x004fe20000000051ULL,
0x0000000b1a1a9232ULL, 0x000fe40000200000ULL, 0x000001000e0b7824ULL, 0x040fe400078e00ffULL,
0x0000000a19199232ULL, 0x080fe40000200000ULL, 0x000100000e0e7824ULL, 0x000fe400078e00ffULL,
0x0000000a1b1b9232ULL, 0x000fe20000200000ULL, 0x000000ff04ff7812ULL, 0x000fe2000782c0ffULL,
0x0000003500357306ULL, 0x000fe20000202400ULL, 0x00005410420d7816ULL, 0x008fc4000000004cULL,
0x000088800f427816ULL, 0x000fe400000000ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0000000c1820723cULL, 0x000fe20000041820ULL,
0x0000004100417306ULL, 0x000ea20000202400ULL, 0x0000541027277816ULL, 0x002fca0000000013ULL,
0x000001000f0c7824ULL, 0x040fe400078e00ffULL, 0x000100000f0f7824ULL, 0x000fe200078e00ffULL,
0x0000001400147306ULL, 0x000fe40000202400ULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x00000018ff0f7819ULL, 0x000fe4000001140fULL, 0x00005410400d7816ULL, 0x004fe40000000041ULL,
0x0000001500157306ULL, 0x000e700000202400ULL, 0x0000003400347306ULL, 0x000ea20000202400ULL,
0x0000541017157816ULL, 0x002fce0000000015ULL, 0x00000046000a7306ULL, 0x000fe20000202400ULL,
0x0000541034147816ULL, 0x004fce0000000014ULL, 0x0000000b000b7306ULL, 0x000e620000202400ULL,
0x000000141828723cULL, 0x000fee0000041828ULL, 0x0000001100117306ULL, 0x000fe20000202400ULL,
0x000054100a0a7816ULL, 0x002fce000000000bULL, 0x0000001600167306ULL, 0x000ff00000202400ULL,
0x0000001000107306ULL, 0x000e700000202400ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x0000541026267816ULL, 0x002fce0000000010ULL, 0x0000003700377306ULL, 0x000fe20000202400ULL,
0x00000026181c723cULL, 0x000fee000004181cULL, 0x0000004300437306ULL, 0x000e700000202400ULL,
0x0000003600367306ULL, 0x000fe20000202400ULL, 0x0000541037347816ULL, 0x002fce0000000043ULL,
0x0000004400447306ULL, 0x000e700000202400ULL, 0x0000004200427306ULL, 0x000ff00000202400ULL,
0x0000000c00467306ULL, 0x0004f00000202400ULL, 0x0000000900097306ULL, 0x000fe20000202400ULL,
0x00005410240c7816ULL, 0x004fc40000000035ULL, 0x0000541036357816ULL, 0x002fe40000000044ULL,
0x00005410420b7816ULL, 0x008fc60000000046ULL, 0x0000001200127306ULL, 0x000fe20000202400ULL,
0x0000000c182c723cULL, 0x000fec000004182cULL, 0x000000341834723cULL, 0x000fe20000041848ULL,
0x0000000e000e7306ULL, 0x000e620000202400ULL, 0x00005410250c7816ULL, 0x000fe40000000011ULL,
0x000054104d0d7816ULL, 0x000fc40000000016ULL, 0x0000000a1814723cULL, 0x000fe6000004183cULL,
0x0000000f000f7306ULL, 0x000ea60000202400ULL, 0x0000000c1838723cULL, 0x000fe20000041838ULL,
0x00007610053c7816ULL, 0x000fe4000000003cULL, 0x000054100e0e7816ULL, 0x002fe40000000009ULL,
0x00000001ff097807ULL, 0x000fc80002000000ULL, 0x0000761009057816ULL, 0x000fe40000000005ULL,
0x000054100f0f7816ULL, 0x004fce0000000012ULL, 0x0000000e1818723cULL, 0x000fee0000041830ULL,
0x00000001ff337807ULL, 0x000fe40000800000ULL, 0x0000761004327816ULL, 0x000fe40000000032ULL,
0x0000000433027207ULL, 0x000fc80005800000ULL, 0x0000761002047816ULL, 0x000fe20000000004ULL,
0x000000740060a947ULL, 0x010ff00003800000ULL, 0x0000008068047811ULL, 0x000fe200078e40ffULL,
0x8000000009097824ULL, 0x000fe200078e00ffULL, 0x0000000e06047899ULL, 0x000fe4000800063fULL,
0x0000000f04057c48ULL, 0x000fe2000ffe0000ULL, 0x000000127a3e7c24ULL, 0x100fe2000f8e0204ULL,
0x01c65809ff0075a7ULL, 0x000e6200080a004eULL, 0x0000400004047892ULL, 0x000fe4000f8ec03fULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x000000643e0b7210ULL, 0x140fe20007ffe07dULL,
0x000140000e0a7890ULL, 0x000fe2000fffe004ULL, 0x000000703e037210ULL, 0x000fc40007ffe07dULL,
0x0000006f3e0d7210ULL, 0x040fe20007ffe07dULL, 0x000001000b0a7825ULL, 0x000fe200078e006aULL,
0x000000693e0f7210ULL, 0x000fc60007ffe07dULL, 0x0000010003027825ULL, 0x000fe200078e006aULL,
0x000000630a307210ULL, 0x000fc60007f3e0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e006aULL,
0x0000006302267210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff317224ULL, 0x000fe200008e060bULL,
0x0000006e3e0b7210ULL, 0x040fe20007ffe07dULL, 0x000000ffff277224ULL, 0x000fe200010e0603ULL,
0x0000006d3e037210ULL, 0x000fe40007ffe07dULL, 0x000000630c247210ULL, 0x000fe20007f3e0ffULL,
0x000001000b0a7825ULL, 0x100fe200078e006aULL, 0x00000040050c7807ULL, 0x000fe40000000000ULL,
0x0000000a5b057c11ULL, 0x000fe2000f8e20ffULL, 0x0000010003027825ULL, 0x000fe200078e006aULL,
0x0000000c7d0c7248ULL, 0x000fc60007fe0000ULL, 0x000000ffff257224ULL, 0x000fe200008e060dULL,
0x000000630a127210ULL, 0x000fe40007f3e0ffULL, 0x0000006c3e0d7210ULL, 0x040fe40007ffe07dULL,
0x0000006302107210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe400008e060bULL,
0x000001000d0a7825ULL, 0x000fe200078e006aULL, 0x000000653e0d7210ULL, 0x000fc60007ffe07dULL,
0x000000ffff117224ULL, 0x000fe200010e0603ULL, 0x000000630a0e7210ULL, 0x000fe20007f3e0ffULL,
0x000001000f027825ULL, 0x000fc800078e006aULL, 0x000000ffff0f7224ULL, 0x000fe200008e060bULL,
0x00000063020a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010c027824ULL, 0x000fe400078e0a7dULL,
0x000001000d0c7825ULL, 0x000fc600078e006aULL, 0x000000026400720cULL, 0x080fe20003f86070ULL,
0x000000ffff0b7224ULL, 0x000fe200010e0603ULL, 0x000000630c0c7210ULL, 0x000fe40007fde0ffULL,
0x000000027000720cULL, 0x080fe40003f46070ULL, 0x000000026f00720cULL, 0x000fe20003f26070ULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0000003233037207ULL, 0x000fe20005800000ULL,
0x0000000000085947ULL, 0x002ff40003800000ULL, 0x01c65809ff0075a7ULL, 0x000e64000806014eULL,
0x000000fc0068b947ULL, 0x002fea0003800000ULL, 0x0000000a5a337c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030057faeULL, 0x0003e2000e101c4cULL,
0x0000000a593d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000306097899ULL, 0x000fe2000800063fULL,
0x000000026e00720cULL, 0x080fe20003f86070ULL, 0x0000000026337faeULL, 0x0005e2000d101c4cULL,
0x000000026d00720cULL, 0x080fe20003f66070ULL, 0x0000000809047892ULL, 0x000fe2000f8ec03fULL,
0x000000026900720cULL, 0x080fe20003f46070ULL, 0x00000000243d7faeULL, 0x0007e2000c901c4cULL,
0x000000026c00720cULL, 0x000fe20003f26070ULL, 0x0000000410117290ULL, 0x000fe2000fffe03fULL,
0x0000000a583f7c11ULL, 0x000fc4000f8e20ffULL, 0x000000026500720cULL, 0x000fe40003fa6070ULL,
0x0000000a57057c11ULL, 0x002fe2000f8e20ffULL, 0x00000000123f7faeULL, 0x000fe2000e101c4cULL,
0x0000000a56317c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a55277c11ULL, 0x004fe2000f8e20ffULL,
0x0000000010057faeULL, 0x0003e2000d901c4cULL, 0x0000000a54257c11ULL, 0x008fe4000f8e20ffULL,
0x0000ffff03027812ULL, 0x000fe200078ec0ffULL, 0x000000000e317faeULL, 0x0005e6000c901c4cULL,
0x0000888002027816ULL, 0x000fe200000000ffULL, 0x000000000a277faeULL, 0x0007e8000d101c4cULL,
0x000000000c257faeULL, 0x0009e2000e901c4cULL, 0x000000ffff057224ULL, 0x002fc400078e0002ULL,
0x8000000050027824ULL, 0x000fe400078e00ffULL, 0x80000000050e7824ULL, 0x004fe400078e00ffULL,
0x00000004ff0b7e24ULL, 0x008fe2000f8e00ffULL, 0x0000000804047892ULL, 0x000fe2000f8e3c3fULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000004ff3d7e24ULL, 0x000fe2000f8e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a51ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000e3d0075a7ULL, 0x0009220008020050ULL, 0x01c61802ff0075a7ULL, 0x000e64000804014eULL,
0x000000f800eca947ULL, 0x012fea0003800000ULL, 0x01c08000070d7984ULL, 0x000e620000000800ULL,
0x0000000e08047291ULL, 0x000fe2000f8e703fULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x01c2800007057984ULL, 0x0004a20000000800ULL, 0x00014000040b7890ULL, 0x000fcc000fffe03fULL,
0x0000000b473e7c11ULL, 0x000fe4000f8e20ffULL, 0x000000000d00720bULL, 0x002fda0003f5d000ULL,
0x0000000000027806ULL, 0x000fc800010e0100ULL, 0x0000ffff020a7812ULL, 0x000fda000784c0ffULL,
0x0000000000cca947ULL, 0x004fea0003800000ULL, 0x000000000d00720bULL, 0x000fe40003f54000ULL,
0x0000000d000c7209ULL, 0x000fca0007810000ULL, 0x8000000c00027221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b02027820ULL, 0x000fe40000410000ULL, 0x0000000000007806ULL, 0x000fe400010e0100ULL,
0x00000002000f7308ULL, 0x000e620000000800ULL, 0x000000016600780cULL, 0x000fe40003f45270ULL,
0x0000ffff00117812ULL, 0x000fc800078e3cffULL, 0x000000110aff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff257807ULL, 0x000fc60001800000ULL, 0x01c4800c0700a388ULL, 0x000fe20000000800ULL,
0x0000000f06067220ULL, 0x002fc60000410000ULL, 0x00001f720f007589ULL, 0x000e6400000e0000ULL,
0x8000000c0d0d3221ULL, 0x000fe40000010000ULL, 0x00001f710f0a7589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b0d0d3820ULL, 0x000fc80000410000ULL, 0x0000000d00083308ULL, 0x000ee20000000800ULL,
0x0000000020207220ULL, 0x082fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x0000000038387220ULL, 0x080fe20000410000ULL, 0x0000000039397220ULL, 0x080fe20000410000ULL,
0x0000000034347220ULL, 0x080fe20000410000ULL, 0x0000000035357220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x000fe20000410000ULL,
0x0000000a22227220ULL, 0x084fe20000410000ULL, 0x0000000a23237220ULL, 0x080fe20000410000ULL,
0x0000000a2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000a2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000a2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000a2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000a3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000a3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000a36367220ULL, 0x080fe20000410000ULL, 0x0000000a37377220ULL, 0x080fe20000410000ULL,
0x0000000a1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000a1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000a16167220ULL, 0x080fe20000410000ULL, 0x0000000a17177220ULL, 0x080fe20000410000ULL,
0x0000000a1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000a1b1b7220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x000fc400078e000cULL, 0x0000000508053220ULL, 0x008fce0000410000ULL,
0x00000000000c1947ULL, 0x000fea0003800000ULL, 0x0000000e08047291ULL, 0x000fd2000f8e183fULL,
0x01c6480eff0075a7ULL, 0x000e640008020144ULL, 0x000000f8000c9947ULL, 0x002fea0003800000ULL,
0x000000003e30783bULL, 0x000e620000004200ULL, 0x00000008ff0a723eULL, 0x000fe200000010ffULL,
0x0000000106077892ULL, 0x000fe2000f80c03fULL, 0x0000991025487816ULL, 0x000fe200000000ffULL,
0x012800006110783bULL, 0x000fe20000000200ULL, 0x000054100a497816ULL, 0x000fe2000000000aULL,
0x00000001ff4e7424ULL, 0x000fe200078e00ffULL, 0x000000ff4800720cULL, 0x000fe20003f25270ULL,
0x0000000605067221ULL, 0x000fe20000010000ULL, 0x0000000b4f4d7c11ULL, 0x000fe2000f8e20ffULL,
0x00001f72490a7589ULL, 0x000ea200000e0000ULL, 0x0000000b53517c11ULL, 0x000fe2000f8e20ffULL,
0x0000000700047c82ULL, 0x000fe20008000000ULL, 0x000000ff03ff7812ULL, 0x000fe2000786c0ffULL,
0x000000004d0c783bULL, 0x000ee20000004200ULL, 0x000000ff3cff7812ULL, 0x000fc8000784c0ffULL,
0x00000001ff787807ULL, 0x000fc80005000000ULL, 0x0000761078057816ULL, 0x000fe20000000005ULL,
0x0000010030027824ULL, 0x042fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011430ULL,
0x0001000031487824ULL, 0x040fe200078e00ffULL, 0x0000888030247816ULL, 0x040fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011402ULL,
0x0000000a10109232ULL, 0x084fe20000200000ULL, 0x00001f7149027589ULL, 0x0002a200000e0000ULL,
0x0000888031267816ULL, 0x040fe200000000ffULL, 0x0000004400447306ULL, 0x000fe20000202400ULL,
0x00000018ff407819ULL, 0x000fe20000011431ULL, 0x0000000a12129232ULL, 0x000fe20000200000ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000ffff257224ULL, 0x000fe200078e0026ULL,
0x00000018ff437819ULL, 0x000fe20000011432ULL, 0x0000010031267824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011433ULL, 0x0000003000317306ULL, 0x000f220000202400ULL,
0x00000018ff497819ULL, 0x002fc40000011448ULL, 0x0000888032487816ULL, 0x000fe400000000ffULL,
0x00000018ff4a7819ULL, 0x008fe4000001140fULL, 0x00000018ff467819ULL, 0x000fe2000001140cULL,
0x0000004000407306ULL, 0x000fe20000202400ULL, 0x00000018ff427819ULL, 0x000fe4000001140dULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff3f7819ULL, 0x000fe2000001140eULL,
0x0000000211119232ULL, 0x084fe20000200000ULL, 0x0000541031307816ULL, 0x010fe20000000044ULL,
0x0000004900497306ULL, 0x000e620000202400ULL, 0x0000000213139232ULL, 0x000fce0000200000ULL,
0x0000004800487306ULL, 0x000fe20000202400ULL, 0x0000541049317816ULL, 0x002fe20000000040ULL,
0x0000010032407824ULL, 0x040fe200078e00ffULL, 0x0000888033497816ULL, 0x000fe200000000ffULL,
0x0001000032327824ULL, 0x000fc800078e00ffULL, 0x0000004a00447306ULL, 0x000fe20000202400ULL,
0x000000301028723cULL, 0x000fe20000041828ULL, 0x00000018ff327819ULL, 0x000fcc0000011432ULL,
0x0000004900497306ULL, 0x000fe20000202400ULL, 0x00000018ff307819ULL, 0x000fe20000011440ULL,
0x0000010033407824ULL, 0x040fe400078e00ffULL, 0x0001000033337824ULL, 0x000fc600078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011440ULL, 0x0000003000317306ULL, 0x000e620000202400ULL,
0x00000018ff337819ULL, 0x000fce0000011433ULL, 0x0000004b004c7306ULL, 0x000ea20000202400ULL,
0x0000541048307816ULL, 0x002fce0000000031ULL, 0x00000032004a7306ULL, 0x0003e20000202400ULL,
0x0000541049317816ULL, 0x004fce000000004cULL, 0x0000004300437306ULL, 0x000ea20000202400ULL,
0x000088800c497816ULL, 0x040fe200000000ffULL, 0x000001000d327824ULL, 0x002fe200078e00ffULL,
0x00000030102c723cULL, 0x000fe8000004182cULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000004100417306ULL, 0x000fe40000202400ULL, 0x000001000c317824ULL, 0x000fc400078e00ffULL,
0x000100000c0c7824ULL, 0x000fc800078e00ffULL, 0x0000003300487306ULL, 0x000e620000202400ULL,
0x000000ffff307224ULL, 0x000fe200078e0049ULL, 0x00000018ff4b7819ULL, 0x000fe40000011431ULL,
0x000088800d317816ULL, 0x040fe200000000ffULL, 0x000100000d0d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000004600467306ULL, 0x000fe40000202400ULL,
0x00000018ff0d7819ULL, 0x000fcc000001140dULL, 0x0000004200427306ULL, 0x000ff00000202400ULL,
0x0000000c00337306ULL, 0x0004f00000202400ULL, 0x0000000d00497306ULL, 0x0003220000202400ULL,
0x000054104a0c7816ULL, 0x004fc40000000043ULL, 0x0000000b5c4a7c11ULL, 0x000fca000f8e20ffULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x00005410480d7816ULL, 0x002fe40000000041ULL,
0x000088800e487816ULL, 0x000fca00000000ffULL, 0x0000002700277306ULL, 0x000e620000202400ULL,
0x0000000c1038723cULL, 0x000fee0000041838ULL, 0x0000002500257306ULL, 0x000fe20000202400ULL,
0x00005410330c7816ULL, 0x008fe20000000046ULL, 0x000000ffff467224ULL, 0x000fe200078e0048ULL,
0x00005410490d7816ULL, 0x010fe20000000042ULL, 0x000001000e487824ULL, 0x000fc400078e00ffULL,
0x000100000e0e7824ULL, 0x000fe200078e00ffULL, 0x0000541024247816ULL, 0x002fe20000000027ULL,
0x0000002600267306ULL, 0x000e620000202400ULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000000c101c723cULL, 0x000fe2000004181cULL, 0x00000018ff0e7819ULL, 0x000fca000001140eULL,
0x0000004600427306ULL, 0x000fe20000202400ULL, 0x000001000f0c7824ULL, 0x040fe200078e00ffULL,
0x000088800f0d7816ULL, 0x040fe200000000ffULL, 0x000100000f0f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000541025257816ULL, 0x002fe20000000026ULL,
0x0000004800497306ULL, 0x000e620000202400ULL, 0x00000018ff0f7819ULL, 0x000fca000001140fULL,
0x000000241020723cULL, 0x000fe20000041820ULL, 0x000000005124783bULL, 0x000ea20000004200ULL,
0x0000000d000d7306ULL, 0x000ff00000202400ULL, 0x0000000c00467306ULL, 0x0002f00000202400ULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x00005410420c7816ULL, 0x002fc40000000049ULL,
0x000054100d0d7816ULL, 0x008fca0000000046ULL, 0x0000004b004b7306ULL, 0x000e640000202400ULL,
0x0000000c1014723cULL, 0x000fec0000041814ULL, 0x0000003100317306ULL, 0x000fe20000202400ULL,
0x0000541030307816ULL, 0x002fce000000004bULL, 0x0000003200327306ULL, 0x000e620000202400ULL,
0x00000018ff407819ULL, 0x004fe40000011424ULL, 0x00000018ff417819ULL, 0x000fe40000011425ULL,
0x00000018ff437819ULL, 0x000fe40000011426ULL, 0x00000018ff497819ULL, 0x000fe20000011427ULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x0000541031317816ULL, 0x002fce0000000032ULL,
0x0000000e000e7306ULL, 0x000e620000202400ULL, 0x000000301034723cULL, 0x000fe20000041834ULL,
0x000000004a30783bULL, 0x000eac0000004200ULL, 0x0000000f000f7306ULL, 0x000ee20000202400ULL,
0x000054100e0c7816ULL, 0x002fce000000003fULL, 0x0000004000407306ULL, 0x000fe20000202400ULL,
0x000054100f0d7816ULL, 0x008fce0000000044ULL, 0x0000004100417306ULL, 0x000fe20000202400ULL,
0x0000000c1010723cULL, 0x000fe20000041818ULL, 0x01280000620c783bULL, 0x000e6c0000000200ULL,
0x0000004300437306ULL, 0x000fe20000202400ULL, 0x0000010024197824ULL, 0x040fe200078e00ffULL,
0x0000888024187816ULL, 0x040fe200000000ffULL, 0x00000100251b7824ULL, 0x040fe200078e00ffULL,
0x00008880251a7816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe2000001141bULL, 0x0000001800187306ULL, 0x000fe20000202400ULL,
0x00000018ff1b7819ULL, 0x000fc40000011424ULL, 0x00000018ff247819ULL, 0x000fe40000011425ULL,
0x00000018ff487819ULL, 0x004fe40000011431ULL, 0x0000888031257816ULL, 0x000fe200000000ffULL,
0x0000001900197306ULL, 0x000ea20000202400ULL, 0x00000018ff3f7819ULL, 0x000fe40000011432ULL,
0x00000018ff427819ULL, 0x000fe40000011430ULL, 0x00000018ff467819ULL, 0x000fc60000011433ULL,
0x0000001a001a7306ULL, 0x000fe20000202400ULL, 0x0000541018187816ULL, 0x004fce0000000019ULL,
0x00000044004b7306ULL, 0x000ea20000202400ULL, 0x0000000a0c0c9232ULL, 0x082fe40000200000ULL,
0x0000000a0e0e9232ULL, 0x000fe40000200000ULL, 0x000000020d0d9232ULL, 0x080fe40000200000ULL,
0x000000020f0f9232ULL, 0x000fe20000200000ULL, 0x0000001b001b7306ULL, 0x000e620000202400ULL,
0x000054101a197816ULL, 0x004fe4000000004bULL, 0x00008880261a7816ULL, 0x000fca00000000ffULL,
0x0000002400247306ULL, 0x000ea20000202400ULL, 0x000000180c20723cULL, 0x000fe20000041820ULL,
0x000054101b407816ULL, 0x002fcc0000000040ULL, 0x0000004900497306ULL, 0x000fe20000202400ULL,
0x000000ffff187224ULL, 0x000fe400078e001aULL, 0x0000010026197824ULL, 0x000fe400078e00ffULL,
0x00000100271a7824ULL, 0x040fe200078e00ffULL, 0x0000541024417816ULL, 0x004fe20000000041ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011419ULL,
0x0000001800187306ULL, 0x000fe20000202400ULL, 0x0000888027197816ULL, 0x040fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe2000001141aULL,
0x000000400c28723cULL, 0x000fe20000041828ULL, 0x00000018ff1a7819ULL, 0x000fe20000011426ULL,
0x0000010031267824ULL, 0x040fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe20000011427ULL,
0x0000004b004b7306ULL, 0x000e620000202400ULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x0000888030247816ULL, 0x000fc400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe20000011426ULL,
0x0001000030267824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011431ULL,
0x000000ffff407224ULL, 0x000fe200078e0024ULL, 0x0000001900197306ULL, 0x000fe20000202400ULL,
0x0000010032317824ULL, 0x000fe200078e00ffULL, 0x0000000b5e417c11ULL, 0x000fe2000f8e20ffULL,
0x0000010030247824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000541018187816ULL, 0x002fc4000000004bULL, 0x0000004400447306ULL, 0x000e620000202400ULL,
0x00000018ff4b7819ULL, 0x000fe40000011431ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000888033317816ULL, 0x000fc600000000ffULL, 0x0000001a001a7306ULL, 0x000ea20000202400ULL,
0x0000541019197816ULL, 0x002fce0000000044ULL, 0x0000001b001b7306ULL, 0x000e620000202400ULL,
0x0000888032447816ULL, 0x040fe200000000ffULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x000000180c2c723cULL, 0x000fea000004182cULL, 0x0000004c00307306ULL, 0x0007e40000202400ULL,
0x000054101a187816ULL, 0x004fe20000000043ULL, 0x0000010033437824ULL, 0x000fe200078e00ffULL,
0x000054101b197816ULL, 0x002fc80000000049ULL, 0x0000002500257306ULL, 0x000e620000202400ULL,
0x00000018ff4c7819ULL, 0x008fe20000011432ULL, 0x0001000033327824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x000000180c38723cULL, 0x000fe60000041838ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000004000407306ULL, 0x000fe20000202400ULL,
0x000000004118783bULL, 0x000ea20000004200ULL, 0x0000541025257816ULL, 0x002fcc0000000030ULL,
0x0000002400247306ULL, 0x000e700000202400ULL, 0x0000004400497306ULL, 0x0007e20000202400ULL,
0x0000541040247816ULL, 0x002fce0000000024ULL, 0x0000004b004b7306ULL, 0x000e620000202400ULL,
0x0000000b60447c11ULL, 0x008fe2000f8e20ffULL, 0x000000240c34723cULL, 0x000fec0000041834ULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x0000541049307816ULL, 0x002fce000000004bULL,
0x0000004300437306ULL, 0x000e620000202400ULL, 0x00000018ff407819ULL, 0x004fce0000011418ULL,
0x0000004200427306ULL, 0x000fe20000202400ULL, 0x0000541031317816ULL, 0x002fce0000000043ULL,
0x0000004800487306ULL, 0x000fe20000202400ULL, 0x000000300c14723cULL, 0x000fee0000041814ULL,
0x0000003f003f7306ULL, 0x000ff00000202400ULL, 0x0000004600467306ULL, 0x000ff00000202400ULL,
0x0000002600267306ULL, 0x000e700000202400ULL, 0x0000002700277306ULL, 0x000ea20000202400ULL,
0x0000541026247816ULL, 0x002fce0000000042ULL, 0x0000004c00337306ULL, 0x000e620000202400ULL,
0x00000018ff427819ULL, 0x000fe40000011419ULL, 0x0000541027257816ULL, 0x004fca0000000048ULL,
0x0000003200327306ULL, 0x000ea20000202400ULL, 0x00000018ff487819ULL, 0x000fe2000001141aULL,
0x000000240c24723cULL, 0x000fe2000004181cULL, 0x0000541033307816ULL, 0x002fe2000000003fULL,
0x0000010019337824ULL, 0x000fc800078e00ffULL, 0x0000004000407306ULL, 0x000fe20000202400ULL,
0x00000000441c783bULL, 0x000e620000004200ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000541032317816ULL, 0x004fe40000000046ULL, 0x0000888019327816ULL, 0x000fe400000000ffULL,
0x0000004200437306ULL, 0x0003e20000202400ULL, 0x00000018ff467819ULL, 0x000fe4000001141bULL,
0x000000300c10723cULL, 0x000fe20000041810ULL, 0x01280000770c783bULL, 0x000ea80000000200ULL,
0x0000003200327306ULL, 0x000fe40000202400ULL, 0x0000010018317824ULL, 0x040fe200078e00ffULL,
0x0000888018307816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000003300337306ULL, 0x000fe20000202400ULL,
0x00000018ff187819ULL, 0x000fce0000011418ULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x00000018ff427819ULL, 0x002fce000001141cULL, 0x0000003100317306ULL, 0x000e620000202400ULL,
0x00000018ff3f7819ULL, 0x000fce000001141dULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x0000000a0c0c9232ULL, 0x084fe40000200000ULL, 0x0000000a0e0e9232ULL, 0x000fe20000200000ULL,
0x0000541030307816ULL, 0x002fe20000000031ULL, 0x000000020d0d9232ULL, 0x080fe20000200000ULL,
0x0000541032317816ULL, 0x000fe20000000033ULL, 0x000000020f0f9232ULL, 0x000fe20000200000ULL,
0x0000004600467306ULL, 0x000fe20000202400ULL, 0x00000018ff327819ULL, 0x000fe4000001141eULL,
0x00000018ff337819ULL, 0x000fc6000001141fULL, 0x000000300c20723cULL, 0x000fe40000041820ULL,
0x0000004200427306ULL, 0x000fea0000202400ULL, 0x0001000019307824ULL, 0x000fc600078e00ffULL,
0x0000001800197306ULL, 0x000e640000202400ULL, 0x00000018ff497819ULL, 0x000fe40000011430ULL,
0x000088801a307816ULL, 0x000fc800000000ffULL, 0x00000049004c7306ULL, 0x000ea20000202400ULL,
0x0000541019187816ULL, 0x002fe20000000040ULL, 0x000001001a197824ULL, 0x000fe200078e00ffULL,
0x000088801b407816ULL, 0x000fca00000000ffULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011419ULL,
0x000054104c197816ULL, 0x004fe40000000043ULL, 0x00000018ff497819ULL, 0x000fe4000001141aULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x000088801c1a7816ULL, 0x000fe400000000ffULL,
0x000088801d437816ULL, 0x000fe200000000ffULL, 0x000000180c28723cULL, 0x000fe80000041828ULL,
0x0000003100317306ULL, 0x000e660000202400ULL, 0x000001001b187824ULL, 0x000fc400078e00ffULL,
0x000000ffff197224ULL, 0x000fe400078e0040ULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000004900497306ULL, 0x000fe60000202400ULL,
0x00000018ff1b7819ULL, 0x000fca000001141bULL, 0x0000001900197306ULL, 0x000ff00000202400ULL,
0x0000001800407306ULL, 0x0002b00000202400ULL, 0x0000001b001b7306ULL, 0x000ee20000202400ULL,
0x0000541030187816ULL, 0x002fe20000000031ULL, 0x000001001c307824ULL, 0x000fc400078e00ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x0000541019197816ULL, 0x004fc60000000040ULL,
0x0000001a001a7306ULL, 0x000fe20000202400ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000000b5d407c11ULL, 0x000fe2000f8e20ffULL,
0x000000180c2c723cULL, 0x000fe4000004182cULL, 0x00000030004b7306ULL, 0x000e6a0000202400ULL,
0x000001001d187824ULL, 0x000fe200078e00ffULL, 0x000054101b197816ULL, 0x008fe20000000046ULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x000001001e467824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x00000018ff1d7819ULL, 0x000fc8000001141dULL, 0x00000018004c7306ULL, 0x0004f00000202400ULL,
0x0000001c00317306ULL, 0x0003e20000202400ULL, 0x0000541049187816ULL, 0x004fe40000000048ULL,
0x000088801e497816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fc40000011446ULL, 0x000088801f467816ULL, 0x000fe200000000ffULL,
0x0000001d00307306ULL, 0x0006a20000202400ULL, 0x000054101a1c7816ULL, 0x002fe2000000004bULL,
0x000000180c38723cULL, 0x000fe20000041838ULL, 0x000000004018783bULL, 0x000e6a0000004200ULL,
0x0000003200327306ULL, 0x000fe20000202400ULL, 0x00005410431d7816ULL, 0x008fc4000000004cULL,
0x0000000b454c7c11ULL, 0x000fca000f8e20ffULL, 0x0000001c0c34723cULL, 0x000fe20000041834ULL,
0x0000004900437306ULL, 0x000fec0000202400ULL, 0x000001001f1c7824ULL, 0x000fe400078e00ffULL,
0x0000003300337306ULL, 0x000fe60000202400ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141cULL,
0x00000018ff1c7819ULL, 0x000fe2000001141eULL, 0x000100001f1e7824ULL, 0x000fe400078e00ffULL,
0x0000004800487306ULL, 0x000fe60000202400ULL, 0x00000018ff1e7819ULL, 0x000fca000001141eULL,
0x0000004600467306ULL, 0x000ff00000202400ULL, 0x0000001d00497306ULL, 0x0005f00000202400ULL,
0x0000001c001f7306ULL, 0x0007220000202400ULL, 0x00005410301d7816ULL, 0x004fc4000000003fULL,
0x0000888018307816ULL, 0x002fca00000000ffULL, 0x0000001e001e7306ULL, 0x000e620000202400ULL,
0x00005410311c7816ULL, 0x008fe40000000042ULL, 0x00000018ff317819ULL, 0x000fe40000011418ULL,
0x00000018ff427819ULL, 0x000fe4000001141bULL, 0x000054101f327816ULL, 0x010fe20000000032ULL,
0x0000001c0c24723cULL, 0x000fe20000041824ULL, 0x00000031003f7306ULL, 0x0005ec0000202400ULL,
0x00005410431c7816ULL, 0x000fc40000000048ULL, 0x00005410461d7816ULL, 0x000fe20000000049ULL,
0x0000010018317824ULL, 0x004fe200078e00ffULL, 0x000054101e337816ULL, 0x002fe20000000033ULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011419ULL, 0x0000001c0c14723cULL, 0x000fe20000041814ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x000000004c1c783bULL, 0x000e620000004200ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x00000018ff467819ULL, 0x000fe2000001141aULL, 0x000000320c10723cULL, 0x000fe20000041810ULL,
0x012800005f0c783bULL, 0x000ea20000000200ULL, 0x01c6584effff79a7ULL, 0x0007e8000850000eULL,
0x0000003100317306ULL, 0x000f220000202400ULL, 0x0000010019327824ULL, 0x040fe200078e00ffULL,
0x0000888019337816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x01c6204effff79a7ULL, 0x0007e4000850000eULL, 0x00000018ff487819ULL, 0x000fc40000011432ULL,
0x0000003300497306ULL, 0x000fe20000202400ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000541030307816ULL, 0x010fca0000000031ULL, 0x0000004800487306ULL, 0x000f300000202400ULL,
0x0000001800187306ULL, 0x000f620000202400ULL, 0x00000018ff327819ULL, 0x002fe4000001141cULL,
0x0000541049317816ULL, 0x010fca0000000048ULL, 0x0000004600467306ULL, 0x000fe20000202400ULL,
0x00000018ff337819ULL, 0x000fe2000001141dULL, 0x0000000a0c0c9232ULL, 0x084fe40000200000ULL,
0x0000000a0e0e9232ULL, 0x000fe20000200000ULL, 0x00000018ff0a7819ULL, 0x000fe2000001141fULL,
0x000000020d0d9232ULL, 0x080fe20000200000ULL, 0x0000541018187816ULL, 0x020fe2000000003fULL,
0x0000001900487306ULL, 0x000e620000202400ULL, 0x000000020f0f9232ULL, 0x000fe20000200000ULL,
0x000088801b3f7816ULL, 0x000fc400000000ffULL, 0x00000018ff027819ULL, 0x000fe4000001141eULL,
0x000000000000781cULL, 0x000fe40003f2f008ULL, 0x000000300c20723cULL, 0x000fe20000041820ULL,
0x0000004200427306ULL, 0x000fe20000202400ULL, 0x0000541048197816ULL, 0x002fca0000000043ULL,
0x000001001a317824ULL, 0x040fe200078e00ffULL, 0x000088801a307816ULL, 0x040fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x0000000200027306ULL, 0x000fe40000202400ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x000000180c28723cULL, 0x000fe20000041828ULL,
0x00000018ff1a7819ULL, 0x000fc8000001141aULL, 0x0000003000307306ULL, 0x000fe40000202400ULL,
0x000001001b187824ULL, 0x040fe400078e00ffULL, 0x000000ffff197224ULL, 0x000fe200078e003fULL,
0x000088801c3f7816ULL, 0x000fe200000000ffULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000003100317306ULL, 0x000e660000202400ULL,
0x00000018ff1b7819ULL, 0x000fca000001141bULL, 0x0000001900197306ULL, 0x000ff00000202400ULL,
0x0000001800487306ULL, 0x0002b00000202400ULL, 0x0000001a00437306ULL, 0x0009e20000202400ULL,
0x0000541030187816ULL, 0x002fe20000000031ULL, 0x000001001c307824ULL, 0x000fc400078e00ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x0000541019197816ULL, 0x004fc60000000048ULL,
0x0000001b001b7306ULL, 0x000e620000202400ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x000088801d487816ULL, 0x040fe400000000ffULL, 0x000088801e1a7816ULL, 0x010fe200000000ffULL,
0x000000180c2c723cULL, 0x000fe2000004182cULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000003000317306ULL, 0x0005ea0000202400ULL, 0x000001001d187824ULL, 0x000fc400078e00ffULL,
0x000001001e197824ULL, 0x040fe200078e00ffULL, 0x0000003f003f7306ULL, 0x000fe20000202400ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x004fe40000011419ULL,
0x000054101b197816ULL, 0x002fe40000000042ULL, 0x0000001800497306ULL, 0x0003e20000202400ULL,
0x00000018ff427819ULL, 0x000fc4000001141eULL, 0x00000018ff1d7819ULL, 0x000fca000001141dULL,
0x0000004800487306ULL, 0x000ea20000202400ULL, 0x0000541043187816ULL, 0x002fe40000000046ULL,
0x000088801f437816ULL, 0x000fca00000000ffULL, 0x000000180c38723cULL, 0x000fe20000041838ULL,
0x0000001a001a7306ULL, 0x000fec0000202400ULL, 0x000001001f187824ULL, 0x040fe200078e00ffULL,
0x0000541048197816ULL, 0x004fe20000000049ULL, 0x00000030001b7306ULL, 0x0002a20000202400ULL,
0x000100001f1f7824ULL, 0x000fc400078e00ffULL, 0x00000018ff187819ULL, 0x000fca0000011418ULL,
0x0000004300437306ULL, 0x000fe20000202400ULL, 0x00000018ff307819ULL, 0x002fce000001141fULL,
0x0000001800467306ULL, 0x0003300000202400ULL, 0x0000004200427306ULL, 0x000f620000202400ULL,
0x000054103f187816ULL, 0x002fce0000000031ULL, 0x000000180c34723cULL, 0x000fe20000041834ULL,
0x0000003200327306ULL, 0x000fec0000202400ULL, 0x000054101a187816ULL, 0x004fe4000000001bULL,
0x0000003300337306ULL, 0x000fe20000202400ULL, 0x0000541043197816ULL, 0x010fce0000000046ULL,
0x0000000a000a7306ULL, 0x000fe20000202400ULL, 0x000000180c14723cULL, 0x000fee0000041814ULL,
0x0000001c001c7306ULL, 0x000e620000202400ULL, 0x0000541042187816ULL, 0x020fe40000000002ULL,
0x00000001ff027807ULL, 0x000fc40001800000ULL, 0x0000000f04007c0cULL, 0x000fe4000bf61070ULL,
0x0000000302797207ULL, 0x000fe20004800000ULL, 0x0000001d001d7306ULL, 0x000ea60000202400ULL,
0x0000761079047816ULL, 0x000fe40000000004ULL, 0x000054101c1c7816ULL, 0x002fc60000000032ULL,
0x0000003000307306ULL, 0x000e620000202400ULL, 0x000054101d1d7816ULL, 0x004fce0000000033ULL,
0x0000001c0c1c723cULL, 0x000fe20000041824ULL, 0x0000541030197816ULL, 0x002fce000000000aULL,
0x000000180c18723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000004c0068b947ULL, 0x008fde0003800000ULL, 0x00000001ff0a7807ULL, 0x000fe40005000000ULL,
0x000000c0680d7811ULL, 0x000fc600078e40ffULL, 0x800000000a057824ULL, 0x000fe200078e00ffULL,
0x0000000f0d107c48ULL, 0x000fc6000ffe0000ULL, 0x01c65805ff0075a7ULL, 0x0002a4000808004eULL,
0x0000000110267824ULL, 0x100fe400078e0a0dULL, 0x000000127a057c24ULL, 0x002fca000f8e020dULL,
0x00000064050f7210ULL, 0x140fe40007ffe07dULL, 0x0000007005137210ULL, 0x140fe40007ffe07dULL,
0x0000006f05117210ULL, 0x000fe20007ffe07dULL, 0x000001000f0e7825ULL, 0x000fc800078e006aULL,
0x0000010013127825ULL, 0x000fe200078e006aULL, 0x000000630e0c7210ULL, 0x000fc60007f7e0ffULL,
0x0000010011107825ULL, 0x000fe200078e006aULL, 0x00000000000c4947ULL, 0x004ff20003800000ULL,
0x800000000a0a7824ULL, 0x000fc800078e00ffULL, 0x01c6580aff0075a7ULL, 0x000e64000808014eULL,
0x000000d80064c947ULL, 0x002fea0003800000ULL, 0x00000063120e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e060fULL, 0x0000006e05257210ULL, 0x040fe20007ffe07dULL,
0x0000000809047892ULL, 0x000fe2000f8e0c3fULL, 0x0000004026267807ULL, 0x000fe20000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200020e0613ULL, 0x0000006d05277210ULL, 0x000fe20007ffe07dULL,
0x0000010025127825ULL, 0x000fe200078e006aULL, 0x0000006c05317210ULL, 0x000fe20007ffe07dULL,
0x0000000410097290ULL, 0x000fe2000fffe03fULL, 0x000000267d0a7248ULL, 0x000fe20007fe0000ULL,
0x0000010027247825ULL, 0x000fe200078e006aULL, 0x0000006312127210ULL, 0x000fc40007f1e0ffULL,
0x0000006310107210ULL, 0x000fe20007fbe0ffULL, 0x0000010031267825ULL, 0x000fe200078e006aULL,
0x0000006905337210ULL, 0x100fe40007ffe07dULL, 0x0000000b5a3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a7dULL, 0x0000006326267210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000006324247210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x0000000a6400720cULL, 0x080fe20003f86070ULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x0000000a7000720cULL, 0x080fe20003fa6070ULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000000a6f00720cULL, 0x080fe20003f06070ULL,
0x0000010033307825ULL, 0x000fe200078e006aULL, 0x0000000a6e00720cULL, 0x000fc40003f66070ULL,
0x0000006505337210ULL, 0x000fe40007ffe07dULL, 0x0000000b5b057c11ULL, 0x000fe4000f8e20ffULL,
0x0000006330307210ULL, 0x000fe20007fde0ffULL, 0x0000010033327825ULL, 0x000fe200078e006aULL,
0x0000000b59437c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c057faeULL, 0x0003e2000e101c4cULL, 0x0000000b58497c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff317224ULL, 0x000fe200030e0631ULL, 0x0000000a6c00720cULL, 0x080fe20003f86070ULL,
0x000000000e3f7faeULL, 0x0005e2000e901c4cULL, 0x0000000a6d00720cULL, 0x000fc40003fa6070ULL,
0x0000ffff04047812ULL, 0x000fe200078ec0ffULL, 0x0000000010437faeULL, 0x0007e2000c101c4cULL,
0x0000000a6900720cULL, 0x080fe40003f06070ULL, 0x00000063320c7210ULL, 0x002fe20007fde0ffULL,
0x0000000012497faeULL, 0x0003e2000d901c4cULL, 0x0000000a6500720cULL, 0x000fe20003f66070ULL,
0x00000004ff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000b56057c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e0633ULL, 0x0000000b57337c11ULL, 0x000fc4000f8e20ffULL,
0x0000000b550f7c11ULL, 0x004fe4000f8e20ffULL, 0x0000000b54117c11ULL, 0x008fe2000f8e20ffULL,
0x0000000024337faeULL, 0x0005e2000e901c4cULL, 0x0000888004127816ULL, 0x002fe200000000ffULL,
0x8000000050047824ULL, 0x000fe400078e00ffULL, 0x0000000026057faeULL, 0x0005e4000e101c4cULL,
0x8000000012127824ULL, 0x000fe400078e00ffULL, 0x00000000300f7faeULL, 0x0005e8000c101c4cULL,
0x000000000c117faeULL, 0x0005e2000d901c4cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x01c648120b0075a7ULL, 0x000262000800004eULL, 0x01c62804ff0075a7ULL, 0x000ee4000806014eULL,
0x000000d40078b947ULL, 0x00afea0003800000ULL, 0x01c1000007057984ULL, 0x004e620000000800ULL,
0x0000000a47107c11ULL, 0x000fe2000f8e20ffULL, 0x00000001ff327424ULL, 0x000fe400078e00ffULL,
0x01c30000070a7984ULL, 0x0004a20000000800ULL, 0x000000000500720bULL, 0x002fda0003f7d000ULL,
0x0000000000047806ULL, 0x000fc800018e0100ULL, 0x0000ffff040e7812ULL, 0x000fda000786c0ffULL,
0x0000000000ccb947ULL, 0x004fea0003800000ULL, 0x000000000500720bULL, 0x000fe40003f74000ULL,
0x0000000500047209ULL, 0x000fca0007810000ULL, 0x80000004000c7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL, 0x0000000000007806ULL, 0x000fe400018e0100ULL,
0x0000000c000d7308ULL, 0x000e620000000800ULL, 0x000000026600780cULL, 0x000fe40003f65270ULL,
0x0000ffff000f7812ULL, 0x000fc800078e3cffULL, 0x0000000f0eff7212ULL, 0x000fc8000788c0ffULL,
0x00000001ff327807ULL, 0x000fc60002000000ULL, 0x01c500040700b388ULL, 0x000fe20000000800ULL,
0x0000000d06067220ULL, 0x002fc60000410000ULL, 0x00001f720d007589ULL, 0x000e6400000e0000ULL,
0x80000004050e4221ULL, 0x000fe40000010000ULL, 0x00001f710d057589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b0e0e4820ULL, 0x000fc80000410000ULL, 0x0000000e00084308ULL, 0x000ee20000000800ULL,
0x0000000020207220ULL, 0x082fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x0000000038387220ULL, 0x080fe20000410000ULL, 0x0000000039397220ULL, 0x080fe20000410000ULL,
0x0000000034347220ULL, 0x080fe20000410000ULL, 0x0000000035357220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x000fe20000410000ULL,
0x0000000522227220ULL, 0x084fe20000410000ULL, 0x0000000523237220ULL, 0x080fe20000410000ULL,
0x000000052a2a7220ULL, 0x080fe20000410000ULL, 0x000000052b2b7220ULL, 0x080fe20000410000ULL,
0x000000052e2e7220ULL, 0x080fe20000410000ULL, 0x000000052f2f7220ULL, 0x080fe20000410000ULL,
0x000000053a3a7220ULL, 0x080fe20000410000ULL, 0x000000053b3b7220ULL, 0x080fe20000410000ULL,
0x0000000536367220ULL, 0x080fe20000410000ULL, 0x0000000537377220ULL, 0x080fe20000410000ULL,
0x000000051e1e7220ULL, 0x080fe20000410000ULL, 0x000000051f1f7220ULL, 0x080fe20000410000ULL,
0x0000000516167220ULL, 0x080fe20000410000ULL, 0x0000000517177220ULL, 0x080fe20000410000ULL,
0x000000051a1a7220ULL, 0x080fe20000410000ULL, 0x000000051b1b7220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x000fc400078e0004ULL, 0x0000000a080a4220ULL, 0x008fce0000410000ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000106047892ULL, 0x000fc8000f8ec03fULL,
0x0000000e04047291ULL, 0x000fd2000f8e183fULL, 0x01c64812ff0075a7ULL, 0x000e640008000144ULL,
0x000000d000988947ULL, 0x002fea0003800000ULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x00000008ff05723eULL, 0x000fe200000010ffULL, 0x0000000106047892ULL, 0x000fe2000f8ec03fULL,
0x00009910323f7816ULL, 0x000fe200000000ffULL, 0x013000006124783bULL, 0x000fe20000000200ULL,
0x0000541005497816ULL, 0x000fe20000000005ULL, 0x000000010400788cULL, 0x000fe2000bf05070ULL,
0x0000000a4f0c7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001ff737424ULL, 0x000fe200078e00ffULL,
0x0000000a5e5e7c11ULL, 0x000fe2000f8e20ffULL, 0x00001f7249057589ULL, 0x000fe200000e0000ULL,
0x0000000800047c82ULL, 0x000fe20008000000ULL, 0x000000000000781cULL, 0x000fe20003f6f008ULL,
0x000000060a067221ULL, 0x000fe20000010000ULL, 0x000000000c0c783bULL, 0x000ea40000004200ULL,
0x0000000203037207ULL, 0x000fe20005800000ULL, 0x0000010010047824ULL, 0x042fe200078e00ffULL,
0x0000888010427816ULL, 0x000fe200000000ffULL, 0x0000010011327824ULL, 0x040fe200078e00ffULL,
0x0000888011337816ULL, 0x000fc400000000ffULL, 0x00000018ff437819ULL, 0x000fe40000011404ULL,
0x00001f7149047589ULL, 0x0002e200000e0000ULL, 0x0000004200427306ULL, 0x000fe20000202400ULL,
0x00000018ff477819ULL, 0x000fe20000011432ULL, 0x000000ffff327224ULL, 0x000fe200078e003fULL,
0x00000018ff307819ULL, 0x000fe20000011411ULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011410ULL, 0x000000ff3200720cULL, 0x000fe20003f05270ULL,
0x0000004300437306ULL, 0x000f220000202400ULL, 0x0001000010327824ULL, 0x000fe200078e00ffULL,
0x0000888013497816ULL, 0x002fc400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe40000011412ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003300337306ULL, 0x000fe20000202400ULL,
0x00000018ff467819ULL, 0x000fe40000011413ULL, 0x00000018ff3f7819ULL, 0x004fe2000001140cULL,
0x0000000524248232ULL, 0x080fe40000200000ULL, 0x0000000526268232ULL, 0x000fe20000200000ULL,
0x0000541042107816ULL, 0x010fe20000000043ULL, 0x0000004700487306ULL, 0x0002a20000202400ULL,
0x00000018ff427819ULL, 0x000fe20000011411ULL, 0x0000000425258232ULL, 0x088fe20000200000ULL,
0x0000888012437816ULL, 0x000fe200000000ffULL, 0x0000000427278232ULL, 0x000fc80000200000ULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x00000018ff477819ULL, 0x002fe4000001140dULL,
0x0000541033117816ULL, 0x004fca0000000048ULL, 0x0000003000307306ULL, 0x000fe40000202400ULL,
0x000000102420723cULL, 0x000fec0000041820ULL, 0x0000003200327306ULL, 0x000e620000202400ULL,
0x0000010012107824ULL, 0x040fe400078e00ffULL, 0x0001000012127824ULL, 0x000fca00078e00ffULL,
0x0000004200337306ULL, 0x0004e20000202400ULL, 0x00000018ff487819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x0000541032107816ULL, 0x002fc60000000031ULL,
0x0000004300437306ULL, 0x000fe20000202400ULL, 0x0000000a53317c11ULL, 0x000fe4000f8e20ffULL,
0x00000018ff427819ULL, 0x004fe4000001140eULL, 0x0000541033117816ULL, 0x008fc60000000030ULL,
0x0000004800487306ULL, 0x000e620000202400ULL, 0x000000003130783bULL, 0x000ea60000004200ULL,
0x000000102428723cULL, 0x000fe80000041828ULL, 0x0000004900117306ULL, 0x000fe60000202400ULL,
0x0000010013107824ULL, 0x000fc400078e00ffULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff137819ULL, 0x000fca0000011413ULL, 0x00000010004e7306ULL, 0x0002f00000202400ULL,
0x0000004600467306ULL, 0x000fe20000202400ULL, 0x0000541043107816ULL, 0x002fe40000000048ULL,
0x00000018ff437819ULL, 0x000fc4000001140fULL, 0x0000541011117816ULL, 0x008fc6000000004eULL,
0x0000001200497306ULL, 0x0002e20000202400ULL, 0x00000018ff487819ULL, 0x004fe40000011430ULL,
0x00008880334b7816ULL, 0x000fe200000000ffULL, 0x00000010242c723cULL, 0x000fe8000004182cULL,
0x0000001300117306ULL, 0x000ea20000202400ULL, 0x000088800c127816ULL, 0x002fe400000000ffULL,
0x0000541049107816ULL, 0x008fca000000003cULL, 0x0000001200127306ULL, 0x000fe20000202400ULL,
0x0000541011117816ULL, 0x004fe20000000046ULL, 0x000001000c467824ULL, 0x000fcc00078e00ffULL,
0x00000048003c7306ULL, 0x0003e20000202400ULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x000000102438723cULL, 0x000fe60000041838ULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000004600137306ULL, 0x0004e40000202400ULL,
0x000001000d107824ULL, 0x040fe200078e00ffULL, 0x000088800d117816ULL, 0x040fe200000000ffULL,
0x000100000d0d7824ULL, 0x000fc800078e00ffULL, 0x0000003f003f7306ULL, 0x000fe20000202400ULL,
0x00000018ff487819ULL, 0x002fe40000011410ULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x000088800e467816ULL, 0x004fc600000000ffULL, 0x0000001100117306ULL, 0x000ff00000202400ULL,
0x0000004800487306ULL, 0x000e700000202400ULL, 0x0000000c00107306ULL, 0x0006b00000202400ULL,
0x0000004700477306ULL, 0x000fe20000202400ULL, 0x00005410120c7816ULL, 0x008fce0000000013ULL,
0x0000000d00127306ULL, 0x0002f00000202400ULL, 0x0000004600467306ULL, 0x000fe20000202400ULL,
0x00005410110d7816ULL, 0x002fe20000000048ULL, 0x000001000e117824ULL, 0x000fc400078e00ffULL,
0x000100000e0e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011411ULL,
0x0000000c2434723cULL, 0x000fe20000041834ULL, 0x000088800f117816ULL, 0x000fe200000000ffULL,
0x0000004200427306ULL, 0x000fea0000202400ULL, 0x00005410100c7816ULL, 0x004fe2000000003fULL,
0x000000ffff3f7224ULL, 0x000fe200078e0011ULL, 0x00005410120d7816ULL, 0x008fe20000000047ULL,
0x0000004900497306ULL, 0x000fe20000202400ULL, 0x00000018ff477819ULL, 0x000fc40000011431ULL,
0x0000000a5c107c11ULL, 0x000fc6000f8e20ffULL, 0x0000000c241c723cULL, 0x000fe4000004181cULL,
0x0000003f000d7306ULL, 0x0003e20000202400ULL, 0x000000001010783bULL, 0x000ea80000004200ULL,
0x000001000f0c7824ULL, 0x000fc600078e00ffULL, 0x0000004300437306ULL, 0x000fe20000202400ULL,
0x00000018ff3f7819ULL, 0x002fe40000011432ULL, 0x00000018ff487819ULL, 0x000fe4000001140cULL,
0x00000018ff0c7819ULL, 0x000fe2000001140eULL, 0x000100000f0e7824ULL, 0x000fe400078e00ffULL,
0x0000004700477306ULL, 0x000fe60000202400ULL, 0x00000018ff0e7819ULL, 0x000fca000001140eULL,
0x0000004800487306ULL, 0x000e700000202400ULL, 0x0000000c000f7306ULL, 0x0007220000202400ULL,
0x000054100d0d7816ULL, 0x002fce0000000048ULL, 0x0000000e000e7306ULL, 0x000e620000202400ULL,
0x00005410460c7816ULL, 0x008fe40000000049ULL, 0x0000888032487816ULL, 0x000fe400000000ffULL,
0x00000018ff467819ULL, 0x000fe40000011433ULL, 0x000054100f427816ULL, 0x010fe20000000042ULL,
0x0000000c2414723cULL, 0x000fe20000041814ULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x000054100e437816ULL, 0x002fc40000000043ULL, 0x01300000620c783bULL, 0x000e6a0000000200ULL,
0x0000004b004b7306ULL, 0x000fe20000202400ULL, 0x000000422418723cULL, 0x000fee0000041818ULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x0000888031267816ULL, 0x040fe200000000ffULL,
0x0000010031277824ULL, 0x040fe200078e00ffULL, 0x0000888030247816ULL, 0x040fe200000000ffULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x004fe20000011410ULL,
0x0000010030257824ULL, 0x040fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x00000018ff257819ULL, 0x000fc40000011425ULL,
0x00000018ff307819ULL, 0x000fca0000011430ULL, 0x00000031004e7306ULL, 0x0004f00000202400ULL,
0x0000003000437306ULL, 0x0009620000202400ULL, 0x0000010033317824ULL, 0x004fe400078e00ffULL,
0x000000050c0c8232ULL, 0x002fc40000200000ULL, 0x0001000033337824ULL, 0x000fe400078e00ffULL,
0x000000050e0e8232ULL, 0x000fe20000200000ULL, 0x00000018ff4f7819ULL, 0x000fe20000011431ULL,
0x000000040d0d8232ULL, 0x080fe20000200000ULL, 0x000054104e317816ULL, 0x008fe20000000047ULL,
0x0000010032307824ULL, 0x050fe200078e00ffULL, 0x0000004f004e7306ULL, 0x0003e20000202400ULL,
0x000000040f0f8232ULL, 0x000fe40000200000ULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fc80000011430ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000003000497306ULL, 0x000be20000202400ULL, 0x00008880114f7816ULL, 0x002fce00000000ffULL,
0x0000002500257306ULL, 0x000e620000202400ULL, 0x0000541043307816ULL, 0x020fe4000000003cULL,
0x00000018ff437819ULL, 0x000fe40000011411ULL, 0x00000018ff3c7819ULL, 0x000fc60000011412ULL,
0x0000002600267306ULL, 0x000fe20000202400ULL, 0x000000300c28723cULL, 0x000fe20000041828ULL,
0x0000541024247816ULL, 0x002fcc0000000025ULL, 0x0000002700277306ULL, 0x000e620000202400ULL,
0x0000541048307816ULL, 0x000fe40000000049ULL, 0x000054104b317816ULL, 0x000fe4000000004eULL,
0x00000018ff4e7819ULL, 0x000fe20000011433ULL, 0x0000010010337824ULL, 0x040fe200078e00ffULL,
0x00008880104b7816ULL, 0x040fe200000000ffULL, 0x0000004600467306ULL, 0x000fe20000202400ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x000000300c2c723cULL, 0x000fe2000004182cULL,
0x00000018ff497819ULL, 0x000fc60000011413ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000003200307306ULL, 0x000ea20000202400ULL, 0x0000541026257816ULL, 0x002fce0000000027ULL,
0x0000004e00317306ULL, 0x000e620000202400ULL, 0x000000240c20723cULL, 0x000fe20000041820ULL,
0x000000005e24783bULL, 0x000ee20000004200ULL, 0x0000541030307816ULL, 0x004fca000000003fULL,
0x0000004200427306ULL, 0x000fe20000202400ULL, 0x00000018ff3f7819ULL, 0x000fe40000011433ULL,
0x0000541031317816ULL, 0x002fca0000000046ULL, 0x0000004300437306ULL, 0x000fe40000202400ULL,
0x000000300c30723cULL, 0x000fec0000041838ULL, 0x0000004b004b7306ULL, 0x000fe20000202400ULL,
0x00010000113b7824ULL, 0x040fe400078e00ffULL, 0x0000010011397824ULL, 0x000fca00078e00ffULL,
0x0000003f00467306ULL, 0x0003e20000202400ULL, 0x000000ffff387224ULL, 0x000fe200078e004fULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff397819ULL, 0x000fc80000011439ULL,
0x0000001000117306ULL, 0x000ea20000202400ULL, 0x00000018ff4f7819ULL, 0x008fe40000011427ULL,
0x00000018ff477819ULL, 0x000fe40000011424ULL, 0x00000018ff487819ULL, 0x000fc60000011425ULL,
0x0000003b004e7306ULL, 0x000ee20000202400ULL, 0x00000018ff3f7819ULL, 0x002fe40000011426ULL,
0x0000541011107816ULL, 0x004fca0000000042ULL, 0x00000038003a7306ULL, 0x0003e20000202400ULL,
0x000054104e117816ULL, 0x008fce0000000043ULL, 0x0000003900397306ULL, 0x000ea20000202400ULL,
0x000054104b387816ULL, 0x002fe20000000046ULL, 0x00000100124b7824ULL, 0x040fe200078e00ffULL,
0x0000888012467816ULL, 0x040fe200000000ffULL, 0x00000100134e7824ULL, 0x000fe400078e00ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x000000100c1c723cULL, 0x000fe2000004181cULL,
0x0000004f00427306ULL, 0x0003e20000202400ULL, 0x00000018ff4b7819ULL, 0x000fca000001144bULL,
0x0000888013117816ULL, 0x040fe400000000ffULL, 0x000054103a397816ULL, 0x004fe20000000039ULL,
0x0000004600437306ULL, 0x000fe20000202400ULL, 0x00000018ff4f7819ULL, 0x002fe4000001144eULL,
0x00000018ff4e7819ULL, 0x000fe20000011412ULL, 0x0001000013127824ULL, 0x000fe200078e00ffULL,
0x0000000a603a7c11ULL, 0x000fe2000f8e20ffULL, 0x000000380c34723cULL, 0x000fe40000041834ULL,
0x0000004b00107306ULL, 0x000e620000202400ULL, 0x00000018ff127819ULL, 0x000fc40000011412ULL,
0x000000003a38783bULL, 0x000eaa0000004200ULL, 0x0000001100117306ULL, 0x000fe20000202400ULL,
0x0000541043107816ULL, 0x002fce0000000010ULL, 0x0000004f00467306ULL, 0x000e700000202400ULL,
0x0000003c003c7306ULL, 0x000fe20000202400ULL, 0x0000541011117816ULL, 0x002fce0000000046ULL,
0x0000004900497306ULL, 0x000fe20000202400ULL, 0x000000100c14723cULL, 0x000fee0000041814ULL,
0x0000004e00137306ULL, 0x000e620000202400ULL, 0x00000018ff4b7819ULL, 0x004fe4000001143aULL,
0x00000018ff437819ULL, 0x000fc40000011438ULL, 0x00000018ff467819ULL, 0x000fc60000011439ULL,
0x0000001200127306ULL, 0x000ea20000202400ULL, 0x0000541013107816ULL, 0x002fce000000003cULL,
0x0000004700477306ULL, 0x000fe20000202400ULL, 0x0000541012117816ULL, 0x004fe20000000049ULL,
0x0000010025127824ULL, 0x000fcc00078e00ffULL, 0x0000004b003c7306ULL, 0x0003e20000202400ULL,
0x00000018ff497819ULL, 0x000fe2000001143bULL, 0x000000100c18723cULL, 0x000fe20000041818ULL,
0x01300000770c783bULL, 0x000eaa0000000200ULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x00000018ff4b7819ULL, 0x002fe20000011412ULL, 0x0000010024117824ULL, 0x040fe200078e00ffULL,
0x0000888024107816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fc800078e00ffULL,
0x0000004b004e7306ULL, 0x000fe20000202400ULL, 0x00000018ff137819ULL, 0x000fe40000011411ULL,
0x0000888025117816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe40000011424ULL, 0x0000888026247816ULL, 0x000fe200000000ffULL,
0x0000001000107306ULL, 0x000ff00000202400ULL, 0x0000001300137306ULL, 0x000e700000202400ULL,
0x0000001100117306ULL, 0x000ee20000202400ULL, 0x000000050c0c8232ULL, 0x004fe20000200000ULL,
0x0000541010107816ULL, 0x002fcc0000000013ULL, 0x0000001200127306ULL, 0x000e620000202400ULL,
0x00000018ff137819ULL, 0x000fe20000011425ULL, 0x000000050e0e8232ULL, 0x000fe40000200000ULL,
0x0000010026257824ULL, 0x000fe400078e00ffULL, 0x000000040d0d8232ULL, 0x080fe40000200000ULL,
0x000000040f0f8232ULL, 0x000fe20000200000ULL, 0x0000541011117816ULL, 0x008fe2000000004eULL,
0x0000001300137306ULL, 0x000ea20000202400ULL, 0x00000018ff4b7819ULL, 0x000fc40000011425ULL,
0x0000888027257816ULL, 0x000fc600000000ffULL, 0x000000100c20723cULL, 0x000fe40000041820ULL,
0x0000002400247306ULL, 0x000fea0000202400ULL, 0x0000010027107824ULL, 0x040fe400078e00ffULL,
0x0001000026117824ULL, 0x000fe200078e00ffULL, 0x0000004b004b7306ULL, 0x000ee20000202400ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fc40000011410ULL,
0x00000018ff4e7819ULL, 0x000fe40000011411ULL, 0x0000541012107816ULL, 0x002fe40000000047ULL,
0x0000541013117816ULL, 0x004fe20000000048ULL, 0x0000002500257306ULL, 0x000fe20000202400ULL,
0x0000000a5d127c11ULL, 0x000fe2000f8e20ffULL, 0x0000010038487824ULL, 0x040fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000888038477816ULL, 0x000fe200000000ffULL,
0x000000100c28723cULL, 0x000fe20000041828ULL, 0x000000001210783bULL, 0x000e620000004200ULL,
0x0000005200267306ULL, 0x000ea20000202400ULL, 0x0000541024247816ULL, 0x008fe2000000004bULL,
0x00000100394b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe2000001144bULL,
0x0000003f003f7306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000541025257816ULL, 0x004fca0000000026ULL, 0x0000004e004e7306ULL, 0x000ea20000202400ULL,
0x0000000a45267c11ULL, 0x000fe4000f8e20ffULL, 0x0000888039457816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x000000240c2c723cULL, 0x000fe6000004182cULL,
0x00000027004f7306ULL, 0x0007220000202400ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000054104e4e7816ULL, 0x004fca000000003fULL, 0x0000004700477306ULL, 0x000fe20000202400ULL,
0x000000002624783bULL, 0x008ea20000004200ULL, 0x000054104f4f7816ULL, 0x010fcc0000000042ULL,
0x0000004800527306ULL, 0x000fe20000202400ULL, 0x00000018ff4b7819ULL, 0x002fe20000011411ULL,
0x0000004e0c30723cULL, 0x000fec0000041830ULL, 0x00000045003f7306ULL, 0x0003e20000202400ULL,
0x00000018ff4e7819ULL, 0x000fce0000011410ULL, 0x0000005300427306ULL, 0x0007220000202400ULL,
0x00000018ff457819ULL, 0x002fce0000011412ULL, 0x0000004e00487306ULL, 0x0003e20000202400ULL,
0x0000888012537816ULL, 0x008fe400000000ffULL, 0x000054103f4f7816ULL, 0x010fca0000000042ULL,
0x0000004300437306ULL, 0x000fe20000202400ULL, 0x00005410474e7816ULL, 0x002fe40000000052ULL,
0x000088803a3f7816ULL, 0x040fe400000000ffULL, 0x00000018ff477819ULL, 0x000fe40000011413ULL,
0x00000018ff427819ULL, 0x004fe20000011424ULL, 0x0000003800387306ULL, 0x000e620000202400ULL,
0x0000004e0c34723cULL, 0x000fee0000041834ULL, 0x0000004600467306ULL, 0x000fe20000202400ULL,
0x000001003a4e7824ULL, 0x000fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000003900397306ULL, 0x000ea20000202400ULL,
0x0000541038387816ULL, 0x002fce0000000043ULL, 0x0000003f00437306ULL, 0x0003e20000202400ULL,
0x0000541039397816ULL, 0x004fce0000000046ULL, 0x0000004e004e7306ULL, 0x000ea20000202400ULL,
0x000088803b467816ULL, 0x040fe400000000ffULL, 0x00000018ff3f7819ULL, 0x002fe20000011426ULL,
0x000000380c1c723cULL, 0x000fe8000004181cULL, 0x0000004900497306ULL, 0x000fe60000202400ULL,
0x000001003b397824ULL, 0x000fc400078e00ffULL, 0x000000ffff387224ULL, 0x000fc600078e0046ULL,
0x0000004b004b7306ULL, 0x000fe20000202400ULL, 0x00000018ff467819ULL, 0x000fe40000011425ULL,
0x00000018ff397819ULL, 0x000fca0000011439ULL, 0x00000038004f7306ULL, 0x0005f00000202400ULL,
0x0000003900527306ULL, 0x000e620000202400ULL, 0x0000541043387816ULL, 0x004fe4000000004eULL,
0x00000018ff4e7819ULL, 0x000fe2000001143aULL, 0x000100003b3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fc60000011427ULL, 0x0000004e003b7306ULL, 0x0004e20000202400ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x000054104f397816ULL, 0x002fca0000000052ULL,
0x0000003a003a7306ULL, 0x000e620000202400ULL, 0x0001000010527824ULL, 0x040fe200078e00ffULL,
0x00008880114e7816ULL, 0x044fe200000000ffULL, 0x00000100114f7824ULL, 0x000fe200078e00ffULL,
0x000000380c14723cULL, 0x000fe80000041814ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000004e004e7306ULL, 0x000fe40000202400ULL, 0x0000888010387816ULL, 0x040fe200000000ffULL,
0x0000010010397824ULL, 0x000fe200078e00ffULL, 0x000054103b107816ULL, 0x008fe2000000003cULL,
0x00010000113b7824ULL, 0x000fe200078e00ffULL, 0x000054103a117816ULL, 0x002fc40000000049ULL,
0x0000004f004f7306ULL, 0x000fe20000202400ULL, 0x00000018ff3c7819ULL, 0x000fe40000011452ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x000000100c0c723cULL, 0x000fe20000041818ULL, 0x013000005f18783bULL, 0x000e620000000200ULL,
0x0000003c003c7306ULL, 0x000ea20000202400ULL, 0x00008880133a7816ULL, 0x000fe200000000ffULL,
0x01c65873ffff79a7ULL, 0x0007e6000850000eULL, 0x0000010012107824ULL, 0x000fc400078e00ffULL,
0x0000010013117824ULL, 0x040fe200078e00ffULL, 0x0000003b00497306ULL, 0x000f220000202400ULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x01c63073ffff79a7ULL, 0x0007e2000850000eULL, 0x000054103c487816ULL, 0x004fe40000000048ULL,
0x0000003800387306ULL, 0x000fe20000202400ULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x0000541049497816ULL, 0x010fca000000004bULL, 0x0000003900397306ULL, 0x000eb00000202400ULL,
0x00000010005c7306ULL, 0x0005e20000202400ULL, 0x0000000518188232ULL, 0x002fce0000200000ULL,
0x0000005300537306ULL, 0x000e620000202400ULL, 0x000000051a1a8232ULL, 0x000fe40000200000ULL,
0x0000010025057824ULL, 0x000fe400078e00ffULL, 0x0000000419198232ULL, 0x080fe20000200000ULL,
0x0000541038107816ULL, 0x004fe20000000039ULL, 0x000000041b1b8232ULL, 0x000fe40000200000ULL,
0x0000010024047824ULL, 0x000fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x0000003a003a7306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fc40000011412ULL,
0x00000018ff047819ULL, 0x000fe20000011404ULL, 0x000000481828723cULL, 0x000fe20000041828ULL,
0x0000888024127816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x000000ff03ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000500527306ULL, 0x0005e60000202400ULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000203037207ULL, 0x000fe20005800000ULL,
0x00000011003b7306ULL, 0x0009620000202400ULL, 0x0000010027057824ULL, 0x004fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011405ULL, 0x0001000026057824ULL, 0x000fe200078e00ffULL,
0x0000001300397306ULL, 0x0005e20000202400ULL, 0x000054104e117816ULL, 0x010fe4000000004fULL,
0x00008880254e7816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff057819ULL, 0x000fc60000011405ULL, 0x00000004004f7306ULL, 0x0009e20000202400ULL,
0x00000018ff137819ULL, 0x004fe20000011424ULL, 0x000000101820723cULL, 0x000fe20000041820ULL,
0x00000018ff247819ULL, 0x000fe40000011425ULL, 0x0000888027257816ULL, 0x040fe200000000ffULL,
0x0001000027277824ULL, 0x000fe400078e00ffULL, 0x0000001200127306ULL, 0x000ea20000202400ULL,
0x0000010026047824ULL, 0x050fe200078e00ffULL, 0x0000888026107816ULL, 0x000fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x0000004e004e7306ULL, 0x000f300000202400ULL, 0x00000004003c7306ULL, 0x0003f00000202400ULL,
0x0000000500117306ULL, 0x000be20000202400ULL, 0x0000541053047816ULL, 0x002fce000000005cULL,
0x0000004200427306ULL, 0x000fe20000202400ULL, 0x000054103a057816ULL, 0x020fce000000003bULL,
0x0000004600467306ULL, 0x000fe20000202400ULL, 0x00000004182c723cULL, 0x000fee000004182cULL,
0x0000001300137306ULL, 0x000e620000202400ULL, 0x0000541012047816ULL, 0x004fe4000000004fULL,
0x000054104e057816ULL, 0x010fca0000000052ULL, 0x0000002400247306ULL, 0x000ea40000202400ULL,
0x000000041834723cULL, 0x000fec0000041834ULL, 0x0000001000107306ULL, 0x000f220000202400ULL,
0x0000541013047816ULL, 0x002fe40000000042ULL, 0x0000541024057816ULL, 0x004fca0000000046ULL,
0x0000002500257306ULL, 0x000fe40000202400ULL, 0x00000004181c723cULL, 0x000fec000004181cULL,
0x0000004800267306ULL, 0x000e620000202400ULL, 0x0000541010047816ULL, 0x010fce000000003cULL,
0x0000004500457306ULL, 0x000fe20000202400ULL, 0x0000541025057816ULL, 0x002fce0000000026ULL,
0x0000004700477306ULL, 0x000e620000202400ULL, 0x000000041814723cULL, 0x000fee0000041814ULL,
0x0000003800387306ULL, 0x000ea20000202400ULL, 0x000000c068047811ULL, 0x000fe400078e40ffULL,
0x0000541039397816ULL, 0x002fca0000000047ULL, 0x0000003f003f7306ULL, 0x000e620000202400ULL,
0x0000000f04007c0cULL, 0x000fe4000bf01070ULL, 0x00000001ff057807ULL, 0x000fe40001000000ULL,
0x0000761003047816ULL, 0x000fe40000000004ULL, 0x0000541038387816ULL, 0x004fe20000000045ULL,
0x0000004300437306ULL, 0x000fec0000202400ULL, 0x000000381838723cULL, 0x000fe20000041830ULL,
0x0000541011427816ULL, 0x002fe2000000003fULL, 0x0000002700277306ULL, 0x000e640000202400ULL,
0x0000541027437816ULL, 0x002fce0000000043ULL, 0x000000421818723cULL, 0x000fe2000004180cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000002400948947ULL, 0x008fde0003800000ULL,
0x01c65809ff0075a7ULL, 0x000e62000800004eULL, 0x0000000167037824ULL, 0x000fc800078e0268ULL,
0x0000000103057836ULL, 0x040fe40000000000ULL, 0x0000010003037824ULL, 0x000fc600078e00ffULL,
0x0000000505007c0cULL, 0x000fe2000bf46070ULL, 0x000000127a0a7c24ULL, 0x000fe2000f8e0203ULL,
0x0000000f030e7c48ULL, 0x000fe2000ffe0000ULL, 0x0000000000080947ULL, 0x002ff40003800000ULL,
0x01c65809ff0075a7ULL, 0x000e64000800014eULL, 0x000000b400188947ULL, 0x002fea0003800000ULL,
0x000000700a277210ULL, 0x000fe20007ffe07dULL, 0x000000010e037824ULL, 0x000fe200078e0a03ULL,
0x0000006d0a0f7210ULL, 0x140fe40007ffe07dULL, 0x000000640a257210ULL, 0x040fe20007ffe07dULL,
0x0000010027267825ULL, 0x000fe200078e006aULL, 0x0000006f0a337210ULL, 0x140fe40007ffe07dULL,
0x0000006e0a0d7210ULL, 0x000fe20007ffe07dULL, 0x000001000f0e7825ULL, 0x000fe200078e006aULL,
0x0000006326267210ULL, 0x000fc40007f7e0ffULL, 0x0000006c0a117210ULL, 0x040fe20007ffe07dULL,
0x0000010025247825ULL, 0x000fe200078e006aULL, 0x000000690a137210ULL, 0x140fe40007ffe07dULL,
0x000000650a317210ULL, 0x000fe20007ffe07dULL, 0x000000ffff277224ULL, 0x000fe200018e0627ULL,
0x00000040030a7807ULL, 0x000fe20001000000ULL, 0x0000010033327825ULL, 0x100fe200078e006aULL,
0x000000630e0e7210ULL, 0x000fe40007f7e0ffULL, 0x0000000a7d0a7248ULL, 0x000fe20007fe0000ULL,
0x0000010031307825ULL, 0x000fe200078e006aULL, 0x0000006324247210ULL, 0x000fc40007f1e0ffULL,
0x0000000a5b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a7dULL,
0x0000000a5a037c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e060fULL,
0x0000006330307210ULL, 0x000fe20007f7e0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e006aULL,
0x0000000a6400720cULL, 0x080fe40003f86070ULL, 0x0000000a7000720cULL, 0x000fe20003fa6070ULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000006332327210ULL, 0x000fe20007f1e0ffULL,
0x0000010011107825ULL, 0x000fe200078e006aULL, 0x000000630c0c7210ULL, 0x000fc40007f5e0ffULL,
0x0000000a59597c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff317224ULL, 0x000fe200018e0631ULL,
0x0000000a6f00720cULL, 0x080fe20003f66070ULL, 0x0000010013127825ULL, 0x000fe200078e006aULL,
0x0000000a58097c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245b7faeULL, 0x000fe2000e101c4cULL, 0x0000000a6c00720cULL, 0x080fe20003f86070ULL,
0x000000ffff337224ULL, 0x000fe200000e0633ULL, 0x0000006310107210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x0000006312127210ULL, 0x000fe20007f5e0ffULL,
0x0000000026037faeULL, 0x0003e2000e901c4cULL, 0x0000000a6900720cULL, 0x080fe20003fa6070ULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000000a6e00720cULL, 0x080fe20003f06070ULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x0000000a6d00720cULL, 0x080fe20003f46070ULL,
0x0000000032597faeULL, 0x0007e2000d901c4cULL, 0x0000000a6500720cULL, 0x000fc40003f66070ULL,
0x0000000a57577c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a56057c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a55557c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a54037c11ULL, 0x002fe2000f8e20ffULL,
0x000000000c097faeULL, 0x0007e2000c101c4cULL, 0x0000ffff04247812ULL, 0x000fe200078ec0ffULL,
0x8000000050047824ULL, 0x000fe400078e00ffULL, 0x000000000e577faeULL, 0x0007e4000d101c4cULL,
0x8000000024247824ULL, 0x000fc400078e00ffULL, 0x0000000010057faeULL, 0x0007e8000e101c4cULL,
0x0000000012557faeULL, 0x0007e8000e901c4cULL, 0x0000000030037faeULL, 0x0007e2000d901c4cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a51ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000243d0075a7ULL, 0x0002620008000050ULL,
0x01c63804ff0075a7ULL, 0x000ea4000804014eULL, 0x000000b0001ca947ULL, 0x006fea0003800000ULL,
0x01c1800007057984ULL, 0x008e620000000800ULL, 0x0000000106067892ULL, 0x000fe2000f8e0c3fULL,
0x00000001ff427424ULL, 0x000fe200078e00ffULL, 0x000000000500720bULL, 0x002fda0003f5d000ULL,
0x0000000000037806ULL, 0x000fc800010e0100ULL, 0x0000ffff030a7812ULL, 0x000fe4000784c0ffULL,
0x01c3800007037984ULL, 0x0002b60000000800ULL, 0x0000000000cca947ULL, 0x002fea0003800000ULL,
0x000000000500720bULL, 0x000fe40003f54000ULL, 0x00000005000c7209ULL, 0x000fca0007810000ULL,
0x8000000c00047221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b04047820ULL, 0x000fe40000410000ULL,
0x0000000000007806ULL, 0x000fe400010e0100ULL, 0x0000000400097308ULL, 0x000e620000000800ULL,
0x000000036600780cULL, 0x000fe40003f45270ULL, 0x0000ffff000b7812ULL, 0x000fc800078e3cffULL,
0x0000000b0aff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff427807ULL, 0x000fc60001800000ULL,
0x01c5800c0700a388ULL, 0x000fe20000000800ULL, 0x0000000906067220ULL, 0x002fc60000410000ULL,
0x00001f7209007589ULL, 0x000e6400000e0000ULL, 0x8000000c050a3221ULL, 0x000fe40000010000ULL,
0x00001f7109057589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b0a0a3820ULL, 0x000fc80000410000ULL,
0x0000000a00083308ULL, 0x000f220000000800ULL, 0x0000000020207220ULL, 0x082fe20000410000ULL,
0x0000000021217220ULL, 0x080fe20000410000ULL, 0x0000000028287220ULL, 0x080fe20000410000ULL,
0x0000000029297220ULL, 0x080fe20000410000ULL, 0x000000002c2c7220ULL, 0x080fe20000410000ULL,
0x000000002d2d7220ULL, 0x080fe20000410000ULL, 0x0000000038387220ULL, 0x080fe20000410000ULL,
0x0000000039397220ULL, 0x080fe20000410000ULL, 0x0000000034347220ULL, 0x080fe20000410000ULL,
0x0000000035357220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x000fe20000410000ULL, 0x0000000522227220ULL, 0x088fe20000410000ULL,
0x0000000523237220ULL, 0x080fe20000410000ULL, 0x000000052a2a7220ULL, 0x080fe20000410000ULL,
0x000000052b2b7220ULL, 0x080fe20000410000ULL, 0x000000052e2e7220ULL, 0x080fe20000410000ULL,
0x000000052f2f7220ULL, 0x080fe20000410000ULL, 0x000000053a3a7220ULL, 0x080fe20000410000ULL,
0x000000053b3b7220ULL, 0x080fe20000410000ULL, 0x0000000536367220ULL, 0x080fe20000410000ULL,
0x0000000537377220ULL, 0x080fe20000410000ULL, 0x000000051e1e7220ULL, 0x080fe20000410000ULL,
0x000000051f1f7220ULL, 0x080fe20000410000ULL, 0x0000000516167220ULL, 0x080fe20000410000ULL,
0x0000000517177220ULL, 0x080fe20000410000ULL, 0x000000051a1a7220ULL, 0x080fe20000410000ULL,
0x000000051b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x000fc400078e000cULL,
0x0000000308033220ULL, 0x014fce0000410000ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000000e06067291ULL, 0x000fd2000f8e183fULL, 0x01c64824ff0075a7ULL, 0x000e640008000146ULL,
0x000000ac00408947ULL, 0x002fea0003800000ULL, 0x000000003e0c783bULL, 0x000e620000004200ULL,
0x00000008ff52723eULL, 0x000fe200000010ffULL, 0x0000000603067221ULL, 0x004fe20000010000ULL,
0x0000000700047c82ULL, 0x000fe20008000000ULL, 0x000000004a3c783bULL, 0x000fe80000004200ULL,
0x013800006148783bULL, 0x0005e80000000200ULL, 0x000000004110783bULL, 0x0003e20000004200ULL,
0x0000541052617816ULL, 0x004fc60000000052ULL, 0x000000004d30783bULL, 0x0004e80000004200ULL,
0x00001f7261527589ULL, 0x000fe800000e0000ULL, 0x00001f7161537589ULL, 0x0009e800000e0000ULL,
0x000000005124783bULL, 0x000f680000004200ULL, 0x000000004444783bULL, 0x000f620000004200ULL,
0x000001000c417824ULL, 0x042fe200078e00ffULL, 0x000088800c4d7816ULL, 0x004fe200000000ffULL,
0x000001000d437824ULL, 0x040fe200078e00ffULL, 0x000088800d4e7816ULL, 0x000fc400000000ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000004d004d7306ULL, 0x000fe20000202400ULL, 0x00000018ff637819ULL, 0x000fe2000001140cULL,
0x000100000c0c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe2000001140dULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x000088800e697816ULL, 0x000fe400000000ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x00000041006a7306ULL, 0x0002a20000202400ULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x000000ffff617224ULL, 0x010fe200078e0069ULL,
0x00000018ff5e7819ULL, 0x000fc4000001140eULL, 0x00000018ff5d7819ULL, 0x000fe4000001140fULL,
0x00000018ff5c7819ULL, 0x008fe20000011430ULL, 0x0000004e004e7306ULL, 0x000fe20000202400ULL,
0x0000991042417816ULL, 0x002fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011431ULL,
0x000000ff4100720cULL, 0x000fe40003f05270ULL, 0x00000018ff597819ULL, 0x000fe20000011432ULL,
0x00000043004f7306ULL, 0x0002e20000202400ULL, 0x00000018ff5a7819ULL, 0x000fc40000011433ULL,
0x00000018ff077819ULL, 0x020fe40000011425ULL, 0x00000018ff547819ULL, 0x000fe40000011424ULL,
0x00000018ff577819ULL, 0x000fe20000011426ULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x00000018ff567819ULL, 0x000fe20000011427ULL, 0x0000005248488232ULL, 0x080fe20000200000ULL,
0x00000018ff587819ULL, 0x000fe2000001143cULL, 0x000000524a4a8232ULL, 0x000fe20000200000ULL,
0x00000018ff057819ULL, 0x000fe20000011410ULL, 0x0000005349498232ULL, 0x080fe20000200000ULL,
0x00000018ff517819ULL, 0x000fe20000011411ULL, 0x0000000c00647306ULL, 0x0005220000202400ULL,
0x000000534b4b8232ULL, 0x000fe20000200000ULL, 0x000000004040783bULL, 0x002e620000004200ULL,
0x00000018ff557819ULL, 0x000fc4000001143dULL, 0x00000018ff0b7819ULL, 0x000fe4000001143eULL,
0x00000018ff767819ULL, 0x000fe20000011446ULL, 0x0000000d00657306ULL, 0x0007e20000202400ULL,
0x000054104d0c7816ULL, 0x004fe2000000006aULL, 0x000001000e4d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff0a7819ULL, 0x000fe2000001143fULL, 0x000100000e0e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff047819ULL, 0x000fe40000011412ULL, 0x00000018ff6a7819ULL, 0x000fe2000001144dULL,
0x0000006000607306ULL, 0x000ea20000202400ULL, 0x000054104e0d7816ULL, 0x008fc4000000004fULL,
0x000088800f4d7816ULL, 0x000fe400000000ffULL, 0x00000018ff507819ULL, 0x000fe40000011413ULL,
0x00000018ff097819ULL, 0x000fe20000011445ULL, 0x0000000c4820723cULL, 0x000fe20000041820ULL,
0x0000006100617306ULL, 0x000fe20000202400ULL, 0x00000018ff757819ULL, 0x000fe40000011447ULL,
0x00000018ff707819ULL, 0x000fc60000011444ULL, 0x00005410640c7816ULL, 0x010fe20000000063ULL,
0x000001000f647824ULL, 0x040fe200078e00ffULL, 0x0000006a006a7306ULL, 0x000ee20000202400ULL,
0x000000ffff0d7224ULL, 0x000fe400078e004dULL, 0x000100000f0f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x000000004c4c783bULL, 0x000f260000004200ULL,
0x0000000d00637306ULL, 0x0005e20000202400ULL, 0x00000018ff6e7819ULL, 0x002fc40000011440ULL,
0x00000018ff6c7819ULL, 0x000fe40000011441ULL, 0x00000018ff747819ULL, 0x000fe40000011442ULL,
0x00000018ff737819ULL, 0x000fe20000011443ULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x00005410650d7816ULL, 0x004fce0000000060ULL, 0x0000006400607306ULL, 0x000e620000202400ULL,
0x0000000c4828723cULL, 0x000fee0000041828ULL, 0x00005410610c7816ULL, 0x008fe2000000006aULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00005410630d7816ULL, 0x002fc40000000060ULL,
0x00000018ff607819ULL, 0x000fca000001140fULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00000018ff6f7819ULL, 0x010fe2000001144cULL, 0x0000000c482c723cULL, 0x000fe2000004182cULL,
0x00000018ff697819ULL, 0x000fe4000001144eULL, 0x00000018ff6a7819ULL, 0x000fc6000001144dULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x00000018ff657819ULL, 0x000fe4000001144fULL,
0x00000018ff0c7819ULL, 0x000fe4000001140eULL, 0x00008880300e7816ULL, 0x000fc600000000ffULL,
0x0000000c000d7306ULL, 0x000e700000202400ULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x000054100d0c7816ULL, 0x002fe2000000005eULL, 0x00000100300d7824ULL, 0x000fcc00078e00ffULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe4000001140dULL, 0x00005410600d7816ULL, 0x000fe4000000005dULL,
0x00008880315d7816ULL, 0x040fe400000000ffULL, 0x0000005900597306ULL, 0x000fe60000202400ULL,
0x0000000c4838723cULL, 0x000fea0000041838ULL, 0x0000000f000f7306ULL, 0x000e640000202400ULL,
0x00000100310d7824ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e005dULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000000c005d7306ULL, 0x0003f00000202400ULL, 0x0000000d005e7306ULL, 0x000ea20000202400ULL,
0x000054100e0c7816ULL, 0x002fc4000000000fULL, 0x00000018ff0f7819ULL, 0x000fe40000011430ULL,
0x00000018ff0e7819ULL, 0x000fc60000011431ULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x000054105d0d7816ULL, 0x004fce000000005eULL, 0x0000000f000f7306ULL, 0x000e620000202400ULL,
0x0000000c4834723cULL, 0x000fee0000041834ULL, 0x0000000e000e7306ULL, 0x000ea20000202400ULL,
0x00000100320d7824ULL, 0x040fe200078e00ffULL, 0x00008880320c7816ULL, 0x040fe200000000ffULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x000054100f5c7816ULL, 0x002fe2000000005cULL,
0x00000100330f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fc4000001140dULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00008880330d7816ULL, 0x040fe200000000ffULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe4000001140fULL,
0x000054100e5d7816ULL, 0x004fe4000000005bULL, 0x00000018ff0e7819ULL, 0x000fe20000011432ULL,
0x0000000c000c7306ULL, 0x000fe20000202400ULL, 0x00000018ff0f7819ULL, 0x000fe20000011433ULL,
0x0000010024327824ULL, 0x000fe200078e00ffULL, 0x00008880255b7816ULL, 0x000fe200000000ffULL,
0x0000005c481c723cULL, 0x000fe2000004181cULL, 0x0001000027337824ULL, 0x000fc400078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000003100317306ULL, 0x000e640000202400ULL,
0x00000018ff647819ULL, 0x000fe40000011433ULL, 0x00008880245d7816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x000088803d337816ULL, 0x000fe400000000ffULL,
0x0000000d000d7306ULL, 0x000fe40000202400ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x000054100c0c7816ULL, 0x002fc80000000031ULL, 0x0000003000307306ULL, 0x000e620000202400ULL,
0x0000010025317824ULL, 0x040fe400078e00ffULL, 0x0001000025257824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011431ULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000888026317816ULL, 0x000fe400000000ffULL,
0x000054100d0d7816ULL, 0x002fc60000000030ULL, 0x0000000f000f7306ULL, 0x000e620000202400ULL,
0x0000888027307816ULL, 0x000fc600000000ffULL, 0x0000000c4814723cULL, 0x000fe80000041814ULL,
0x00000032005e7306ULL, 0x000fe60000202400ULL, 0x00000100260c7824ULL, 0x000fe400078e00ffULL,
0x00000100270d7824ULL, 0x000fc600078e00ffULL, 0x00000025006d7306ULL, 0x0005e20000202400ULL,
0x00000018ff0c7819ULL, 0x000fce000001140cULL, 0x0000000c00327306ULL, 0x0007e20000202400ULL,
0x00000018ff257819ULL, 0x004fe4000001140dULL, 0x000054100f0d7816ULL, 0x002fca000000005aULL,
0x00000024006b7306ULL, 0x0003e20000202400ULL, 0x000054100e0c7816ULL, 0x008fe20000000059ULL,
0x00010000260e7824ULL, 0x000fcc00078e00ffULL, 0x0000000c4818723cULL, 0x000fe20000041818ULL,
0x00000018ff247819ULL, 0x002fe2000001140eULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x01380000620c783bULL, 0x000e680000000200ULL, 0x000088803c487816ULL, 0x040fe200000000ffULL,
0x000100003c497824ULL, 0x000fe200078e00ffULL, 0x00008880104a7816ULL, 0x000fe200000000ffULL,
0x0000005b005b7306ULL, 0x000fe60000202400ULL, 0x00000018ff497819ULL, 0x000fca0000011449ULL,
0x0000005c005c7306ULL, 0x000eb00000202400ULL, 0x0000002500267306ULL, 0x0007f00000202400ULL,
0x0000002400277306ULL, 0x0009e20000202400ULL, 0x000001003c257824ULL, 0x008fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000000700077306ULL, 0x000ee20000202400ULL,
0x000001003d247824ULL, 0x050fe400078e00ffULL, 0x000000520c0c8232ULL, 0x082fe40000200000ULL,
0x000100003d3d7824ULL, 0x000fe400078e00ffULL, 0x000000520e0e8232ULL, 0x000fe20000200000ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000000530d0d8232ULL, 0x080fe20000200000ULL,
0x0000002500637306ULL, 0x0005e20000202400ULL, 0x000000530f0f8232ULL, 0x000fe20000200000ULL,
0x00000018ff3d7819ULL, 0x000fcc000001143dULL, 0x00000024003c7306ULL, 0x0003e20000202400ULL,
0x000054105b257816ULL, 0x004fe4000000005cULL, 0x000088803e5c7816ULL, 0x000fe400000000ffULL,
0x000088803f5b7816ULL, 0x000fc600000000ffULL, 0x0000003100317306ULL, 0x000fe20000202400ULL,
0x000054105d247816ULL, 0x002fce000000005eULL, 0x000000240c20723cULL, 0x000fe20000041820ULL,
0x0000003000307306ULL, 0x000e6c0000202400ULL, 0x000001003e247824ULL, 0x040fe400078e00ffULL,
0x000001003f257824ULL, 0x040fe200078e00ffULL, 0x0000004900617306ULL, 0x0005e20000202400ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fc40000011425ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000024005d7306ULL, 0x0009e20000202400ULL,
0x0000888011497816ULL, 0x004fe400000000ffULL, 0x00000018ff3f7819ULL, 0x000fca000001143fULL,
0x00000025005e7306ULL, 0x0007e20000202400ULL, 0x000054106b247816ULL, 0x010fce0000000054ULL,
0x0000005700577306ULL, 0x000fe20000202400ULL, 0x000054106d257816ULL, 0x008fe20000000007ULL,
0x0000010010077824ULL, 0x040fe400078e00ffULL, 0x0001000010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff077819ULL, 0x000fe20000011407ULL, 0x000000240c28723cULL, 0x000fe20000041828ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005600567306ULL, 0x000fea0000202400ULL,
0x0000010011247824ULL, 0x000fe200078e00ffULL, 0x0000888013257816ULL, 0x000fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000010006b7306ULL, 0x0005e40000202400ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00000018ff6d7819ULL, 0x000fe40000011411ULL,
0x0000541030117816ULL, 0x002fe40000000026ULL, 0x0000006400647306ULL, 0x000e620000202400ULL,
0x0000541031107816ULL, 0x004fe40000000032ULL, 0x0000888045317816ULL, 0x000fca00000000ffULL,
0x000000100c2c723cULL, 0x000fe2000004182cULL, 0x00000024004b7306ULL, 0x000fec0000202400ULL,
0x0000010012117824ULL, 0x000fe400078e00ffULL, 0x0000010013107824ULL, 0x040fe200078e00ffULL,
0x0000004800627306ULL, 0x000fe20000202400ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000001100247306ULL, 0x0003f00000202400ULL,
0x0000001000267306ULL, 0x0005e20000202400ULL, 0x0000541064117816ULL, 0x002fce0000000056ULL,
0x0000003300337306ULL, 0x000fe20000202400ULL, 0x0000541027107816ULL, 0x004fe40000000057ULL,
0x0000888044277816ULL, 0x000fca00000000ffULL, 0x000000100c38723cULL, 0x000fe20000041838ULL,
0x0000005800587306ULL, 0x000e6c0000202400ULL, 0x0000010044107824ULL, 0x040fe400078e00ffULL,
0x0000010045117824ULL, 0x040fe200078e00ffULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fc40000011411ULL,
0x0000541061547816ULL, 0x002fe40000000058ULL, 0x0000001000307306ULL, 0x0003e20000202400ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff447819ULL, 0x000fca0000011444ULL,
0x0000001100327306ULL, 0x0005e20000202400ULL, 0x0000541062107816ULL, 0x002fe20000000063ULL,
0x00000001ff637424ULL, 0x000fcc00078e00ffULL, 0x0000003d00607306ULL, 0x0002e20000202400ULL,
0x0000541033117816ULL, 0x004fe4000000003cULL, 0x00008880463c7816ULL, 0x000fca00000000ffULL,
0x000000100c34723cULL, 0x000fe20000041834ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00008880473d7816ULL, 0x002fca00000000ffULL, 0x0000010047117824ULL, 0x040fe200078e00ffULL,
0x0000541060557816ULL, 0x008fe20000000055ULL, 0x0000010046107824ULL, 0x040fe200078e00ffULL,
0x0000005b005b7306ULL, 0x000e620000202400ULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x000000540c1c723cULL, 0x000fe2000004181cULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000003e005a7306ULL, 0x000fe20000202400ULL,
0x00000018ff477819ULL, 0x000fce0000011447ULL, 0x00000011003e7306ULL, 0x0005f00000202400ULL,
0x0000001000337306ULL, 0x0007e20000202400ULL, 0x0000010041117824ULL, 0x004fce00078e00ffULL,
0x0000004600577306ULL, 0x0005e20000202400ULL, 0x0000010040107824ULL, 0x008fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000000700487306ULL, 0x0007e20000202400ULL,
0x00000018ff467819ULL, 0x004fe20000011411ULL, 0x0001000040117824ULL, 0x000fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011411ULL, 0x0000000b000b7306ULL, 0x000fe20000202400ULL,
0x0000888012077816ULL, 0x048fe200000000ffULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x000054105b117816ULL, 0x002fc8000000005eULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000000a000a7306ULL, 0x000ff00000202400ULL, 0x0000003f00597306ULL, 0x000e700000202400ULL,
0x00000010003f7306ULL, 0x0005f00000202400ULL, 0x0000001200727306ULL, 0x000fe20000202400ULL,
0x000054105c107816ULL, 0x004fce000000005dULL, 0x0000001300647306ULL, 0x0005e20000202400ULL,
0x000000100c14723cULL, 0x000fee0000041814ULL, 0x0000004500627306ULL, 0x0007e20000202400ULL,
0x013800007710783bULL, 0x004eae0000000200ULL, 0x0000004700567306ULL, 0x0003e20000202400ULL,
0x0000888040457816ULL, 0x008fce00000000ffULL, 0x0000004600407306ULL, 0x0007e20000202400ULL,
0x0000541059477816ULL, 0x002fce000000000aULL, 0x0000004400717306ULL, 0x0003e20000202400ULL,
0x000054105a467816ULL, 0x008fe4000000000bULL, 0x00008880420b7816ULL, 0x000fca00000000ffULL,
0x000000460c0c723cULL, 0x000fe20000041818ULL, 0x0000888041447816ULL, 0x042fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x0000004a004a7306ULL, 0x000e680000202400ULL,
0x0000010043187824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011441ULL,
0x0000010042417824ULL, 0x040fe400078e00ffULL, 0x0000005210108232ULL, 0x004fe20000200000ULL,
0x0000004900497306ULL, 0x000ea20000202400ULL, 0x00000018ff197819ULL, 0x000fe20000011418ULL,
0x0001000042187824ULL, 0x000fc400078e00ffULL, 0x0000005212128232ULL, 0x000fe20000200000ULL,
0x0000888043467816ULL, 0x040fe200000000ffULL, 0x0000005311118232ULL, 0x080fe40000200000ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000001900427306ULL, 0x000fe20000202400ULL, 0x0000005313138232ULL, 0x000fe20000200000ULL,
0x000054104a487816ULL, 0x002fe40000000048ULL, 0x00000018ff417819ULL, 0x000fc40000011441ULL,
0x0000541049497816ULL, 0x004fe4000000004bULL, 0x0000001800477306ULL, 0x0003ea0000202400ULL,
0x000000481020723cULL, 0x000fe60000041820ULL, 0x0000000700077306ULL, 0x000ea20000202400ULL,
0x013800005f18783bULL, 0x002e620000000200ULL, 0x01c65863ffff79a7ULL, 0x0007e4000850000eULL,
0x000001004c497824ULL, 0x000fc800078e00ffULL, 0x0000002500257306ULL, 0x000f220000202400ULL,
0x01c64063ffff79a7ULL, 0x0007e2000850000eULL, 0x0000541007247816ULL, 0x004fcc0000000024ULL,
0x0000000500057306ULL, 0x000ea20000202400ULL, 0x0000541025257816ULL, 0x010fce0000000026ULL,
0x0000005100517306ULL, 0x000fe20000202400ULL, 0x000001004e267824ULL, 0x000fe200078e00ffULL,
0x00000024102c723cULL, 0x000fe2000004182cULL, 0x000054106b487816ULL, 0x004fca0000000005ULL,
0x0000006d006d7306ULL, 0x000ea20000202400ULL, 0x00000018ff057819ULL, 0x000fe40000011449ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x000001004d257824ULL, 0x000fc800078e00ffULL,
0x0000000400047306ULL, 0x000f220000202400ULL, 0x0000005218188232ULL, 0x082fe40000200000ULL,
0x000000521a1a8232ULL, 0x000fe40000200000ULL, 0x0000005319198232ULL, 0x080fe20000200000ULL,
0x000054106d497816ULL, 0x004fe40000000051ULL, 0x0000007000707306ULL, 0x000e620000202400ULL,
0x000000531b1b8232ULL, 0x000fe20000200000ULL, 0x000000ff79ff7812ULL, 0x000fc6000780c0ffULL,
0x000000481028723cULL, 0x000fe20000041828ULL, 0x0000541072247816ULL, 0x010fe40000000004ULL,
0x0000005000507306ULL, 0x000ea20000202400ULL, 0x00000018ff047819ULL, 0x000fc60000011425ULL,
0x000088804d487816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x0000541071707816ULL, 0x002fe40000000070ULL, 0x0000000900097306ULL, 0x000e620000202400ULL,
0x000000ffff077224ULL, 0x000fe200078e0048ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000541064257816ULL, 0x004fc80000000050ULL, 0x0000007600767306ULL, 0x000ea60000202400ULL,
0x000000241038723cULL, 0x000fe20000041838ULL, 0x0000541062717816ULL, 0x002fc80000000009ULL,
0x0000007500757306ULL, 0x000e640000202400ULL, 0x000088804e257816ULL, 0x000fe200000000ffULL,
0x00000070101c723cULL, 0x000fe2000004181cULL, 0x0000541057767816ULL, 0x004fc80000000076ULL,
0x0000002700277306ULL, 0x000ea20000202400ULL, 0x000100004e4e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x0000003100317306ULL, 0x000f220000202400ULL,
0x0000541056777816ULL, 0x002fe40000000075ULL, 0x0000541027307816ULL, 0x004fca0000000030ULL,
0x0000003c003c7306ULL, 0x000e620000202400ULL, 0x00000076100c723cULL, 0x000fe2000004180cULL,
0x000001004f277824ULL, 0x000fe200078e00ffULL, 0x0000541031317816ULL, 0x010fca0000000032ULL,
0x0000003d003d7306ULL, 0x000ea20000202400ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x000000301034723cULL, 0x000fe20000041834ULL, 0x000054103c3c7816ULL, 0x002fca0000000033ULL,
0x0000004500457306ULL, 0x000e620000202400ULL, 0x000054103d3d7816ULL, 0x004fce000000003eULL,
0x0000004400447306ULL, 0x000ea20000202400ULL, 0x0000003c1014723cULL, 0x000fee0000041814ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0000541045107816ULL, 0x002fe4000000003fULL,
0x0000541044117816ULL, 0x004fca0000000040ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x000088804f137816ULL, 0x040fe200000000ffULL, 0x000100004f4f7824ULL, 0x000fe200078e00ffULL,
0x000000101820723cULL, 0x000fe80000041820ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000005500557306ULL, 0x000e700000202400ULL, 0x0000005400547306ULL, 0x000ea20000202400ULL,
0x0000541055107816ULL, 0x002fce000000006eULL, 0x0000000b000a7306ULL, 0x0003e20000202400ULL,
0x0000541054117816ULL, 0x004fce000000006cULL, 0x0000004100417306ULL, 0x000ea20000202400ULL,
0x00000018ff0b7819ULL, 0x002fe40000011443ULL, 0x000088804c437816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x000000101828723cULL, 0x000fe60000041828ULL,
0x0000007400747306ULL, 0x000e620000202400ULL, 0x00000018ff247819ULL, 0x000fc6000001144cULL,
0x000054100a107816ULL, 0x004fc80000000041ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x00005410470a7816ULL, 0x002fce0000000074ULL, 0x0000000b000b7306ULL, 0x000e700000202400ULL,
0x0000004300437306ULL, 0x000fe20000202400ULL, 0x000054100b0b7816ULL, 0x002fce0000000073ULL,
0x0000000500057306ULL, 0x000e620000202400ULL, 0x0000000a1838723cULL, 0x000fee0000041838ULL,
0x0000000700077306ULL, 0x000fe20000202400ULL, 0x00005410430a7816ULL, 0x002fce0000000005ULL,
0x0000000400047306ULL, 0x000e700000202400ULL, 0x0000002600127306ULL, 0x000fe20000202400ULL,
0x00005410070b7816ULL, 0x002fce0000000004ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x00000001ff077807ULL, 0x000fc80000000000ULL, 0x0000000702027207ULL, 0x000fe20004800000ULL,
0x0000000a1834723cULL, 0x000fe40000041834ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x0000991002027816ULL, 0x000fc800000000ffULL, 0x000000ff0200720cULL, 0x000fc60003f05270ULL,
0x0000004600467306ULL, 0x000e620000202400ULL, 0x00000001ff079807ULL, 0x000fce0000000000ULL,
0x0000002400247306ULL, 0x000ea20000202400ULL, 0x0000541046117816ULL, 0x002fce0000000042ULL,
0x0000004d00097306ULL, 0x000e620000202400ULL, 0x00000010182c723cULL, 0x000fe2000004182cULL,
0x0000541024047816ULL, 0x004fcc000000006fULL, 0x0000002500257306ULL, 0x000ea20000202400ULL,
0x0000541009057816ULL, 0x002fce000000006aULL, 0x0000001300137306ULL, 0x000fe20000202400ULL,
0x00000004181c723cULL, 0x000fe2000004181cULL, 0x0000541025127816ULL, 0x004fcc0000000012ULL,
0x0000002700267306ULL, 0x000e620000202400ULL, 0x0000761078057816ULL, 0x000fe40000000005ULL,
0x0000761007047816ULL, 0x000fca0000000004ULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x0000541013137816ULL, 0x002fce0000000026ULL, 0x0000006500657306ULL, 0x000fe20000202400ULL,
0x000000121814723cULL, 0x000fee0000041814ULL, 0x0000004e004e7306ULL, 0x000e700000202400ULL,
0x0000004f000a7306ULL, 0x000ea20000202400ULL, 0x000054104e4e7816ULL, 0x002fc40000000069ULL,
0x000054100a4f7816ULL, 0x004fce0000000065ULL, 0x0000004e1818723cULL, 0x008fde000004180cULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000167687824ULL, 0x000fe200078e0268ULL,
0x000000ff7bff7812ULL, 0x000fc8000780c0ffULL, 0x0000000568007c0cULL, 0x000fe4000bf26070ULL,
0x00000001ff7b7807ULL, 0x000fd60000000000ULL, 0xffffff5c001c9947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000e620000002500ULL, 0x000000ffff317224ULL, 0x000fe400078e002dULL,
0x000000ffff2d7224ULL, 0x000fe400078e0029ULL, 0x000000ffff047224ULL, 0x000fe400078e0016ULL,
0x000000ffff077224ULL, 0x000fe400078e0015ULL, 0x000000ffff087224ULL, 0x000fe400078e0014ULL,
0x000000ffff297224ULL, 0x000fc400078e0023ULL, 0x000000ffff277224ULL, 0x000fe200078e0021ULL,
0x0000000505007c0cULL, 0x002fda000bf06070ULL, 0x0000000000dc0947ULL, 0x000fea0003800000ULL,
0x0180000006027836ULL, 0x000fe20000000000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e0006ULL,
0x0000b8a000097802ULL, 0x000fce0000000f00ULL, 0x0000009400647944ULL, 0x000fea0003c00000ULL,
0x000000ffff097224ULL, 0x000fe200078e000aULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000600097308ULL, 0x000e640000001000ULL, 0xbf80000009027423ULL, 0x002fc80000000006ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000209097223ULL, 0x000fce0000000009ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x000ea40000000a00ULL,
0x0000000c02027981ULL, 0x004ea2000c1e9900ULL, 0x00000000000c7919ULL, 0x000ee40000000000ULL,
0x00000002ff0a7819ULL, 0x008fe4000001160cULL, 0x000000080c0c7811ULL, 0x000fe200078ff0ffULL,
0x0000000902097220ULL, 0x004fca0000410000ULL, 0x00001f0a090a7589ULL, 0x000ea800000e0000ULL,
0x00001f0c090c7589ULL, 0x000ee200000e0000ULL, 0x000000200a207220ULL, 0x044fe20000410000ULL,
0x000000270a277220ULL, 0x040fe20000410000ULL, 0x000000280a287220ULL, 0x040fe20000410000ULL,
0x0000002d0a2d7220ULL, 0x040fe20000410000ULL, 0x0000002c0a2c7220ULL, 0x040fe20000410000ULL,
0x000000310a317220ULL, 0x040fe20000410000ULL, 0x000000380a387220ULL, 0x040fe20000410000ULL,
0x000000390a397220ULL, 0x040fe20000410000ULL, 0x000000340a347220ULL, 0x040fe20000410000ULL,
0x000000350a357220ULL, 0x040fe20000410000ULL, 0x0000001c0a1c7220ULL, 0x040fe20000410000ULL,
0x0000001d0a1d7220ULL, 0x040fe20000410000ULL, 0x000000080a087220ULL, 0x040fe20000410000ULL,
0x000000070a077220ULL, 0x040fe20000410000ULL, 0x000000180a187220ULL, 0x040fe20000410000ULL,
0x000000190a197220ULL, 0x000fe20000410000ULL, 0x000000220c227220ULL, 0x048fe20000410000ULL,
0x000000290c297220ULL, 0x040fe20000410000ULL, 0x0000002a0c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b0c2b7220ULL, 0x040fe20000410000ULL, 0x0000002e0c2e7220ULL, 0x040fe20000410000ULL,
0x0000002f0c2f7220ULL, 0x040fe20000410000ULL, 0x0000003a0c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b0c3b7220ULL, 0x040fe20000410000ULL, 0x000000360c367220ULL, 0x040fe20000410000ULL,
0x000000370c377220ULL, 0x040fe20000410000ULL, 0x0000001e0c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f0c1f7220ULL, 0x040fe20000410000ULL, 0x000000040c047220ULL, 0x040fe20000410000ULL,
0x000000170c177220ULL, 0x040fe20000410000ULL, 0x0000001a0c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b0c1b7220ULL, 0x000fce0000410000ULL, 0x0000000000157919ULL, 0x000ea20000000000ULL,
0x0000000e66147c11ULL, 0x000fe4000f8e58ffULL, 0x000000383939723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000343534723eULL, 0x000fe200000010ffULL,
0x0001200014167836ULL, 0x000fe20000000000ULL, 0x0000001c1d1c723eULL, 0x000fe400000010ffULL,
0x000000080707723eULL, 0x000fe400000010ffULL, 0x0000541034087816ULL, 0x000fc4000000001cULL,
0x000000181918723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe400000010ffULL, 0x0000003a3b3a723eULL, 0x000fe400000010ffULL,
0x000000016700780cULL, 0x000fe40003f05270ULL, 0x000000363736723eULL, 0x000fc400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x000000041704723eULL, 0x000fe400000010ffULL,
0x0000000215027812ULL, 0x044fe400078ec0ffULL, 0x00000002ff117819ULL, 0x000fe40000011615ULL,
0x00000002020a7811ULL, 0x000fe400078ff8ffULL, 0x0000000815257811ULL, 0x000fc400078ff0ffULL,
0x00000001ff037819ULL, 0x000fe40000011602ULL, 0x000000070a0b7812ULL, 0x000fe400078e7811ULL,
0x000000070a0a7812ULL, 0x000fe400078e7825ULL, 0x00000004020c7811ULL, 0x040fe200078ff8ffULL,
0x00000008110b7824ULL, 0x000fe200078e020bULL, 0x00000006020e7811ULL, 0x000fe200078ff8ffULL,
0x0000000825217824ULL, 0x000fe200078e020aULL, 0x0000000703027812ULL, 0x000fe200078e7811ULL,
0x00000008150a7824ULL, 0x000fe200078e00ffULL, 0x000000070c0d7812ULL, 0x000fe200078e7811ULL,
0x0000001021217824ULL, 0x000fe200078e0216ULL, 0x0000000703037812ULL, 0x000fe200078e7825ULL,
0x0000000811097824ULL, 0x040fe200078e0202ULL, 0x000000080a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000008110f7824ULL, 0x000fe200078e020dULL, 0x000000070e107812ULL, 0x000fe200078e7811ULL,
0x0000001009097824ULL, 0x100fe200078e0216ULL, 0x000000202702723eULL, 0x000fe200000010ffULL,
0x000000100b0d7824ULL, 0x000fe200078e0216ULL, 0x000000070c0c7812ULL, 0x000fe200078e7825ULL,
0x0000000825137824ULL, 0x000fe200078e0203ULL, 0x000000282d03723eULL, 0x000fe200000010ffULL,
0x00000001090b7824ULL, 0x000fe200078e020aULL, 0x0000002c3109723eULL, 0x000fe200000010ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0216ULL, 0x0000541002267816ULL, 0x140fe20000000003ULL,
0x0000000811117824ULL, 0x000fe200078e0210ULL, 0x0000763202277816ULL, 0x000fe20000000003ULL,
0x000000010a0d7824ULL, 0x040fe200078e020dULL, 0x0000541009387816ULL, 0x040fe20000000039ULL,
0x000000010a0f7824ULL, 0x000fe200078e020fULL, 0x0000763209397816ULL, 0x000fe20000000039ULL,
0x0000001011117824ULL, 0x000fe200078e0216ULL, 0x0000763234097816ULL, 0x000fe2000000001cULL,
0x000000260b007388ULL, 0x000fe20000000a00ULL, 0x0000001013137824ULL, 0x000fe200078e0216ULL,
0x000000222902723eULL, 0x000fe200000010ffULL, 0x000000010a117824ULL, 0x040fe200078e0211ULL,
0x000000380d007388ULL, 0x000fe20000000a00ULL, 0x000000070e0e7812ULL, 0x000fe200078e7825ULL,
0x000000010a137824ULL, 0x000fc400078e0213ULL, 0x000000080f007388ULL, 0x0005e20000000a00ULL,
0x0000000825237824ULL, 0x040fe400078e020cULL, 0x0000000825257824ULL, 0x000fe400078e020eULL,
0x000000010a217824ULL, 0x040fe400078e0221ULL, 0x0000001023237824ULL, 0x100fe400078e0216ULL,
0x0000001025257824ULL, 0x000fe400078e0216ULL, 0x000000010a237824ULL, 0x040fe200078e0223ULL,
0x0000541007087816ULL, 0x144fe20000000018ULL, 0x000000010a257824ULL, 0x000fe200078e0225ULL,
0x0000763207097816ULL, 0x000fca0000000018ULL, 0x0000000811007388ULL, 0x0005e40000000a00ULL,
0x0000541002087816ULL, 0x144fe4000000002aULL, 0x0000763202097816ULL, 0x000fe4000000002aULL,
0x0000001a1b02723eULL, 0x000fc600000010ffULL, 0x0000000813007388ULL, 0x0005e20000000a00ULL,
0x00005410040a7816ULL, 0x140fe40000000002ULL, 0x00007632040b7816ULL, 0x000fe40000000002ULL,
0x000054102e087816ULL, 0x144fe4000000003aULL, 0x000076322e097816ULL, 0x000fca000000003aULL,
0x0000000821007388ULL, 0x0005e40000000a00ULL, 0x0000541036087816ULL, 0x144fe4000000001eULL,
0x0000763236097816ULL, 0x000fca000000001eULL, 0x0000000823007388ULL, 0x0005e80000000a00ULL,
0x0000000a25007388ULL, 0x0005e20000000a00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002400848947ULL, 0x000fea0003800000ULL, 0x00000000002a7919ULL, 0x000ee20000002700ULL,
0x00008400ff027b82ULL, 0x000ee20000000800ULL, 0x000000ff6600720cULL, 0x000fe20003f05270ULL,
0x0000001015177824ULL, 0x040fe200078e0214ULL, 0x0000000000037919ULL, 0x000ee20000002600ULL,
0x0000002015257836ULL, 0x044fe20000000000ULL, 0x000000ff1500720cULL, 0x040fe20000725670ULL,
0x0000004015277836ULL, 0x040fe20000000000ULL, 0x0000000000207919ULL, 0x000ea20000008800ULL,
0x00009000ff077b82ULL, 0x000f220000000800ULL, 0x0000006015297836ULL, 0x000fe20000000000ULL,
0x0120000017087984ULL, 0x000f680000000c00ULL, 0x01220000170c7984ULL, 0x000f640000000c00ULL,
0x00009600ff1c7b82ULL, 0x000f640000000a00ULL, 0x0124000017107984ULL, 0x000f680000000c00ULL,
0x0126000017187984ULL, 0x0005640000000c00ULL, 0x0000040000177802ULL, 0x004fe20000000f00ULL,
0x000000022a2a7224ULL, 0x008fc400078e0203ULL, 0x0000000267027224ULL, 0x000fe400078e02ffULL,
0x000000672a047224ULL, 0x000fe200078e02ffULL, 0x0000065420177816ULL, 0x000fe20000000017ULL,
0x0000000702077224ULL, 0x010fe400078e02ffULL, 0x00000001041e7824ULL, 0x000fc600078e0205ULL,
0x00001fff07057811ULL, 0x000fc800078e40ffULL, 0x0000001e05037211ULL, 0x000fca00078f98ffULL,
0x0000200003027825ULL, 0x020fc800078e001cULL, 0x0000080066027825ULL, 0x000fc800078e0002ULL,
0x0000001025247825ULL, 0x000fc800078e0002ULL, 0x0000001027267825ULL, 0x000fc800078e0002ULL,
0x0000001029287825ULL, 0x000fc800078e0002ULL, 0x0000001015227825ULL, 0x000fe200078e0002ULL,
0x01ffffff07037812ULL, 0x000fe200078ec0ffULL, 0x0000000000380947ULL, 0x002fec0003800000ULL,
0x00009600ff207b82ULL, 0x000e620000000a00ULL, 0x000000011e077824ULL, 0x000fe200078e0203ULL,
0x00000001ff2b7819ULL, 0x000fe20000011615ULL, 0x0000001015027824ULL, 0x000fc600078e00ffULL,
0x0000000c2b2b7812ULL, 0x000fe200078ec0ffULL, 0x000000801e1e7825ULL, 0x002fc800078e0020ULL,
0x0000008007207825ULL, 0x000fe200078e0020ULL, 0x0000007002077812ULL, 0x000fc800078ec0ffULL,
0x0000001e2b1e7210ULL, 0x140fe40007b5e007ULL, 0x000000202b207210ULL, 0x000fe40007d9e007ULL,
0x0000001fff1f7210ULL, 0x000fe400017e64ffULL, 0x00000021ff217210ULL, 0x000fc600027ea4ffULL,
0x000000001e007986ULL, 0x0003e8000c10190cULL, 0x0000000620007986ULL, 0x0003e4000c10190cULL,
0x0000000822007986ULL, 0x0005e8000c101d0cULL, 0x0000000c24007986ULL, 0x0005e8000c101d0cULL,
0x0000001026007986ULL, 0x0005e8000c101d0cULL, 0x0000001828007986ULL, 0x0005e2000c101d0cULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000004c1947ULL, 0x000fea0003800000ULL,
0x00009400ff067b82ULL, 0x002e620000000a00ULL, 0xffffffff67097836ULL, 0x004fe40000000000ULL,
0x000000042a067825ULL, 0x002fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000009060679a8ULL, 0x000ea800099ee1ccULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x000000090600720cULL, 0x000fc80003f25270ULL, 0x00000001ff007807ULL, 0x000fca0000800000ULL,
0x00000000ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000017007984ULL, 0x002e640000000000ULL,
0x000000ff0000720cULL, 0x002fda0003f25270ULL, 0x0000002000509947ULL, 0x000fea0003800000ULL,
0x0000000c00300947ULL, 0x000fea0003800000ULL, 0x000000ff6700720cULL, 0x000fda0003f05270ULL,
0x0000000000d88947ULL, 0x000fea0003800000ULL, 0x0000001015007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe20000011615ULL, 0x0000000104097836ULL, 0x044fe40000000000ULL,
0x0000008004067825ULL, 0x100fe200078e001cULL, 0x0000007000197812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fe200078ec0ffULL, 0x0000008009087825ULL, 0x000fc600078e001cULL,
0x0000000602067210ULL, 0x140fe4000791e019ULL, 0x0000000802087210ULL, 0x000fe40007b5e019ULL,
0x00000007ff077210ULL, 0x000fe400007e24ffULL, 0x00000009ff097210ULL, 0x000fc600017e64ffULL,
0x0000000c06007981ULL, 0x000368000c1e1900ULL, 0x0000000c08097981ULL, 0x000362000c1e1900ULL,
0x000000026700780cULL, 0x000fda0003f05270ULL, 0x00000000009c8947ULL, 0x002fea0003800000ULL,
0x0000000204077836ULL, 0x000fc80000000000ULL, 0x0000008007067825ULL, 0x000fc600078e001cULL,
0x0000000602067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000c060b7981ULL, 0x000362000c1e1900ULL, 0x000000046700780cULL, 0x000fda0003f06070ULL,
0x0000000000808947ULL, 0x002fea0003800000ULL, 0x0000000304077836ULL, 0x000fc80000000000ULL,
0x0000008007067825ULL, 0x000fc600078e001cULL, 0x0000000602067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000c060f7981ULL, 0x000362000c1e1900ULL,
0x000000046700780cULL, 0x000fda0003f05270ULL, 0x0000000000648947ULL, 0x002fea0003800000ULL,
0x0000000404077836ULL, 0x000fc80000000000ULL, 0x0000008007067825ULL, 0x000fc600078e001cULL,
0x0000000602067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000c06117981ULL, 0x000362000c1e1900ULL, 0x000000066700780cULL, 0x000fda0003f06070ULL,
0x0000000000488947ULL, 0x002fea0003800000ULL, 0x0000000504077836ULL, 0x000fc80000000000ULL,
0x0000008007067825ULL, 0x000fc600078e001cULL, 0x0000000602067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000c06137981ULL, 0x000362000c1e1900ULL,
0x000000066700780cULL, 0x000fda0003f05270ULL, 0x00000000002c8947ULL, 0x002fea0003800000ULL,
0x000000086700780cULL, 0x000fe20003f06070ULL, 0x0000000604077836ULL, 0x000fc80000000000ULL,
0x0000008007067825ULL, 0x000fc600078e001cULL, 0x0000000602067210ULL, 0x000fca0007a3e019ULL,
0x00000007040d0836ULL, 0x000fe20000000000ULL, 0x00000007ff077210ULL, 0x000fc60000fe44ffULL,
0x000000800d1c0825ULL, 0x000fc600078e001cULL, 0x0000001c020c0210ULL, 0x000fe40007c7e019ULL,
0x0000000c06197981ULL, 0x000364000c1e1900ULL, 0x0000001dff0d0210ULL, 0x000fca0001fe84ffULL,
0x0000000c0c1b0981ULL, 0x000368000c1e1900ULL, 0x0000000767027836ULL, 0x000fca0000000000ULL,
0x00000003ff027819ULL, 0x000fc80000011602ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x0000000800248947ULL, 0x000fea0003800000ULL, 0x00009600ff067b82ULL, 0x002e620000000a00ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0004ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1d7224ULL, 0x020fe200078e0000ULL, 0x0000003f00057c82ULL, 0x000fcc0008000000ULL,
0x0000000467007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000502007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400f41947ULL, 0x022fee0003800000ULL,
0x0000000804067890ULL, 0x000fe2000fffe03fULL, 0x0000001d00007209ULL, 0x000fe20007810000ULL,
0x0000000104077890ULL, 0x000fc8000fffe03fULL, 0x0000000667007c0cULL, 0x040fe4000bf23070ULL,
0x0000000767007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001015087824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011615ULL,
0x000000080e0d7836ULL, 0x000fc60000000000ULL, 0x00000070081d7812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x002fe200078e0006ULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0c7210ULL, 0x000fc80007b3e01dULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x0000000c0c1d7981ULL, 0x000368000c1e1900ULL, 0x0000000400b42947ULL, 0x000fea0003800000ULL,
0x0000000904067890ULL, 0x000fe2000fffe03fULL, 0x0000000900007209ULL, 0x000fe20007810000ULL,
0x0000000204077890ULL, 0x000fc8000fffe03fULL, 0x0000000667007c0cULL, 0x040fe4000bf23070ULL,
0x0000000767007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001015087824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011615ULL,
0x000000090e097836ULL, 0x000fc60000000000ULL, 0x00000070080d7812ULL, 0x002fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000080a087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fcc0000fe64ffULL,
0x0000000c08097981ULL, 0x000366000c1e1900ULL, 0x0000000400742947ULL, 0x000fea0003800000ULL,
0x0000000a04067890ULL, 0x000fe2000fffe03fULL, 0x0000000b00007209ULL, 0x000fe20007810000ULL,
0x0000000304077890ULL, 0x000fc8000fffe03fULL, 0x0000000667007c0cULL, 0x040fe4000bf23070ULL,
0x0000000767007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001015087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011615ULL,
0x0000000a0e0b7836ULL, 0x000fc60000000000ULL, 0x00000070080d7812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0006ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0c0a7210ULL, 0x000fc80007b3e00dULL, 0x0000000bff0b7210ULL, 0x000fcc0000fe64ffULL,
0x0000000c0a0b7981ULL, 0x000366000c1e1900ULL, 0x0000000400342947ULL, 0x000fea0003800000ULL,
0x0000000b04067890ULL, 0x000fe2000fffe03fULL, 0x0000000f00007209ULL, 0x000fe20007810000ULL,
0x0000000404077890ULL, 0x000fc8000fffe03fULL, 0x0000000667007c0cULL, 0x040fe4000bf23070ULL,
0x0000000767007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001015087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011615ULL,
0x0000000b0e0d7836ULL, 0x000fc60000000000ULL, 0x00000070080f7812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e0006ULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0c7210ULL, 0x000fc80007b3e00fULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x0000000c0c0f7981ULL, 0x000368000c1e1900ULL, 0x0000000000f42947ULL, 0x000fea0003800000ULL,
0x0000000c04067890ULL, 0x000fe2000fffe03fULL, 0x0000001100007209ULL, 0x000fe20007810000ULL,
0x0000000504077890ULL, 0x000fc8000fffe03fULL, 0x0000000667007c0cULL, 0x040fe4000bf23070ULL,
0x0000000767007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001015087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011615ULL,
0x0000000c0e0d7836ULL, 0x000fc60000000000ULL, 0x0000007008117812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e0006ULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0c7210ULL, 0x000fc80007b3e011ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x0000000c0c117981ULL, 0x000368000c1e1900ULL, 0x0000000000b42947ULL, 0x000fea0003800000ULL,
0x0000000d04067890ULL, 0x000fe2000fffe03fULL, 0x0000001300007209ULL, 0x000fe20007810000ULL,
0x0000000604077890ULL, 0x000fc8000fffe03fULL, 0x0000000667007c0cULL, 0x040fe4000bf23070ULL,
0x0000000767007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001015087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011615ULL,
0x0000000d0e0d7836ULL, 0x000fc60000000000ULL, 0x0000007008137812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e0006ULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x0000000c0c137981ULL, 0x000368000c1e1900ULL, 0x0000000000742947ULL, 0x000fea0003800000ULL,
0x0000000e04067890ULL, 0x000fe2000fffe03fULL, 0x0000001900007209ULL, 0x000fe20007810000ULL,
0x0000000704077890ULL, 0x000fc8000fffe03fULL, 0x0000000667007c0cULL, 0x040fe4000bf23070ULL,
0x0000000767007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001015087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011615ULL,
0x0000000e0e0d7836ULL, 0x000fc60000000000ULL, 0x0000007008197812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e0006ULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0c7210ULL, 0x000fc80007b3e019ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x0000000c0c197981ULL, 0x000368000c1e1900ULL, 0x0000000000342947ULL, 0x000fea0003800000ULL,
0x0000000f04067890ULL, 0x000fe2000fffe03fULL, 0x0000001b00007209ULL, 0x000fca0007810000ULL,
0x0000000667007c0cULL, 0x000fda000bf23070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001015087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011615ULL,
0x0000000f0e0d7836ULL, 0x000fc60000000000ULL, 0x00000070081b7812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e0006ULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0c7210ULL, 0x000fc80007a3e01bULL, 0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL,
0x0000000c0c1b7981ULL, 0x000368000c1e1900ULL, 0x0000000804047890ULL, 0x000fe2000fffe03fULL,
0x000000080e0e7836ULL, 0x000fe20000000000ULL, 0xfffffff400f08947ULL, 0x000ff4000383ffffULL,
0x0000000000157919ULL, 0x000ee40000000000ULL, 0x0000001015027824ULL, 0x008fe200078e00ffULL,
0x00000001ff067819ULL, 0x002fc80000011615ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ec0ffULL, 0x0000001706077210ULL, 0x000fca0007ffe002ULL,
0x0000000007007388ULL, 0x0203e40000000800ULL, 0x00009600ff0e7b82ULL, 0x004ea20000000a00ULL,
0x0000000405057211ULL, 0x000fe200078f98ffULL, 0x0000080066007824ULL, 0x002fe200078e00ffULL,
0x000000071500780cULL, 0x040fe20003f04070ULL, 0x00000010151c7824ULL, 0x040fe200078e00ffULL,
0x00000015ff187819ULL, 0x000fe20000011666ULL, 0x0000000104437824ULL, 0x000fe200078e0203ULL,
0x00000001ff197819ULL, 0x000fe20000011615ULL, 0x0000002015097836ULL, 0x040fe20000000000ULL,
0x000000701c1c7812ULL, 0x000fe200078ec0ffULL, 0x00000040150b7836ULL, 0x000fe20000000000ULL,
0x0000000c19197812ULL, 0x000fe200078ec0ffULL, 0x00000060150d7836ULL, 0x000fe20000000000ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00001000661a7824ULL, 0x140fe200078e0217ULL,
0x00000017191b7210ULL, 0x000fe20007ffe01cULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000010066108824ULL, 0x140fe200078e0217ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000001015117824ULL, 0x040fe200078e021aULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000010066128824ULL, 0x000fe200078e0217ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000001015138824ULL, 0x000fe200078e0210ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000200005067825ULL, 0x004fe200078e000eULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000001015258824ULL, 0x000fe200078e0212ULL, 0x0000000006027210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000107037824ULL, 0x000fe200008e0618ULL, 0x000000ff6700720cULL, 0x000fc40003f25270ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000001009087825ULL, 0x100fe200078e0002ULL, 0x000000001b1b7984ULL, 0x000e620000000800ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000001015067825ULL, 0x000fc800078e0002ULL, 0x000000100b0a7825ULL, 0x100fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006117faeULL, 0x000fe6000b901c4cULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0038000008117faeULL, 0x000fe6000b901c4cULL,
0x00000080430c8825ULL, 0x100fe200078e000eULL, 0x005800000a117faeULL, 0x000fe6000b901c4cULL,
0x00000080040e8825ULL, 0x000fe200078e000eULL, 0x0078000002117faeULL, 0x000fe6000b901c4cULL,
0x00000010150c8825ULL, 0x000fc800078e000cULL, 0x00000010150e8825ULL, 0x000fe200078e000eULL,
0x045800000c138faeULL, 0x000fe8000b901c4cULL, 0x041800000e258faeULL, 0x0005e8000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000247805ULL, 0x004fe2000001ff00ULL,
0x0000000800b49947ULL, 0x002fec0003800000ULL, 0x00000003ff027819ULL, 0x100fe20000011615ULL,
0x0000000143437836ULL, 0x000fe20000000000ULL, 0xfffffff8ff077812ULL, 0x000fe200078ee215ULL,
0x0000000105457836ULL, 0x000fe20000000000ULL, 0x0000000302067812ULL, 0x000fe200078ec0ffULL,
0x0000000104477836ULL, 0x000fe20000000000ULL, 0x00009600ff027b82ULL, 0x000e620000000a00ULL,
0x0000000807097836ULL, 0x040fe20000000000ULL, 0x0000000406087812ULL, 0x000fe200078efcffULL,
0x00000008073f7824ULL, 0x000fe200078e00ffULL, 0x00000007063e7812ULL, 0x000fe200078e7807ULL,
0x0000000809417824ULL, 0x000fe200078e00ffULL, 0x0000000706407812ULL, 0x000fe200078e7809ULL,
0x00000001ff427424ULL, 0x000fe200078e00ffULL, 0x0000000708067812ULL, 0x000fe200078e7807ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff447819ULL, 0x000fe20000011615ULL,
0x0000010066497824ULL, 0x000fe200078e0217ULL, 0x0000000708087812ULL, 0x000fc400078e7809ULL,
0x0000003f3e3e7212ULL, 0x000fe200078efcffULL, 0x0000000844467836ULL, 0x000fe20000000000ULL,
0x0000004140407212ULL, 0x000fe400078efcffULL, 0x0000003f063f7212ULL, 0x000fe400078efcffULL,
0x0000004108417212ULL, 0x000fce00078efcffULL, 0x000000674200720cULL, 0x000fda0003f06070ULL,
0x0000000000880947ULL, 0x000fea0003800000ULL, 0x0000200045047825ULL, 0x002fe200078e0002ULL,
0x000000071500780cULL, 0x040fe40003f24070ULL, 0x0000000142127812ULL, 0x040fe200078ec0ffULL,
0x0000002015077836ULL, 0x040fe20000000000ULL, 0x00000000040a7210ULL, 0x000fe20007f1e0ffULL,
0x0000080042047824ULL, 0x000fe400078e00ffULL, 0x0000004015137836ULL, 0x000fe40000000000ULL,
0x00000001050b7824ULL, 0x000fe200000e0618ULL, 0x0000080004057812ULL, 0x000fe200078ec0ffULL,
0x00000060154b7836ULL, 0x000fc40000000000ULL, 0x0000010066499824ULL, 0x000fe400078e0217ULL,
0x000000011a047824ULL, 0x000fe400078e0205ULL, 0x00000080430c9825ULL, 0x000fc800078e0002ULL,
0x0000008047089825ULL, 0x000fc800078e0002ULL, 0x0000008012109824ULL, 0x000fe400078e0249ULL,
0x0000001015117824ULL, 0x040fe400078e0204ULL, 0x00000010150e7825ULL, 0x000fc800078e000aULL,
0x0000001007047825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e117faeULL, 0x0003e6000b901c4cULL, 0x0000008012129824ULL, 0x000fe200078e0249ULL,
0x0038000004117faeULL, 0x0003e2000b901c4cULL, 0x0000001013067825ULL, 0x000fc800078e000aULL,
0x000000104b0a7825ULL, 0x000fe200078e000aULL, 0x0058000006117faeULL, 0x0003e6000b901c4cULL,
0x00000010150c9825ULL, 0x040fe200078e000cULL, 0x007800000a117faeULL, 0x0003e6000b901c4cULL,
0x0000001015139824ULL, 0x040fe400078e0210ULL, 0x0000001015089825ULL, 0x000fc600078e0008ULL,
0x045800000c139faeULL, 0x0003e2000b901c4cULL, 0x00000010154b9824ULL, 0x000fca00078e0212ULL,
0x04180000084b9faeULL, 0x0003e4000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff42047836ULL, 0x042fe20000000000ULL, 0x000000674200720cULL, 0x040fe20003f06070ULL,
0x0000000142427836ULL, 0x000fe40000000000ULL, 0x0000008004057824ULL, 0x040fe400078e00ffULL,
0x0000080004047824ULL, 0x000fe400078e00ffULL, 0x0000000143437836ULL, 0x000fe20000000000ULL,
0x0000008005057812ULL, 0x000fe200078ec0ffULL, 0x0000000145457836ULL, 0x000fc40000000000ULL,
0x0000000147477836ULL, 0x000fe20000000000ULL, 0x000000491c067210ULL, 0x000fe40007ffe005ULL,
0x0000080004057812ULL, 0x000fc600078ec0ffULL, 0x0000000119487824ULL, 0x000fe200078e0206ULL,
0x000001801a107810ULL, 0x000fe20007ffe005ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000480e7984ULL, 0x000e620000000800ULL, 0x000000103f087824ULL, 0x100fe400078e0210ULL,
0x000000103e047824ULL, 0x100fe200078e0210ULL, 0x00458000484b7984ULL, 0x000fe20000000800ULL,
0x00000010400c7824ULL, 0x100fe400078e0210ULL, 0x0000001041107824ULL, 0x000fe200078e0210ULL,
0x000000000808783bULL, 0x000ea80000000200ULL, 0x000000000404783bULL, 0x000ee20000000200ULL,
0x0000000e1b117221ULL, 0x002fc60000010100ULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x3fb8aa3b114e7820ULL, 0x000fc60000410000ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x0001000008517824ULL, 0x004fe400078e00ffULL, 0x0000004e004e7308ULL, 0x000ea20000000800ULL,
0x0001000009507824ULL, 0x000fe200078e00ffULL, 0x0000763204487816ULL, 0x008fe20000000048ULL,
0x000100000a537824ULL, 0x000fe200078e00ffULL, 0x00007632064c7816ULL, 0x040fe2000000004cULL,
0x000100000b527824ULL, 0x000fe400078e00ffULL, 0x00010000064d7824ULL, 0x000fe200078e00ffULL,
0x0000763207067816ULL, 0x040fe20000000006ULL, 0x00010000074f7824ULL, 0x000fc400078e00ffULL,
0x00010000054a7824ULL, 0x000fe400078e00ffULL, 0x0000004b4e5b7220ULL, 0x004fe20000410000ULL,
0x00007632084e7816ULL, 0x000fe2000000004eULL, 0x00010000044b7824ULL, 0x000fe200078e00ffULL,
0x0000763209087816ULL, 0x000fe20000000008ULL, 0x0000003c5b3c7221ULL, 0x000fe20000010000ULL,
0x00001f445b5c7589ULL, 0x000ea200000e0000ULL, 0x000076320a097816ULL, 0x000fe40000000009ULL,
0x0000763205047816ULL, 0x000fe20000000004ULL, 0x00001f465b5b7589ULL, 0x000ee200000e0000ULL,
0x000076320b0a7816ULL, 0x000fe2000000000aULL, 0x0001000048057824ULL, 0x000fc400078e00ffULL,
0x0001000004077824ULL, 0x000fe400078e00ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x000076320c0b7816ULL, 0x042fe2000000000bULL, 0x000100000f587824ULL, 0x040fe200078e00ffULL,
0x000076320f567816ULL, 0x000fe20000000056ULL, 0x000100000c557824ULL, 0x000fe200078e00ffULL,
0x00007632100f7816ULL, 0x010fe2000000000fULL, 0x000100000b047824ULL, 0x000fe200078e00ffULL,
0x0000763211577816ULL, 0x040fe20000000057ULL, 0x00010000115a7824ULL, 0x000fe200078e00ffULL,
0x000076320d0c7816ULL, 0x040fe2000000000cULL, 0x000100000d0d7824ULL, 0x000fe200078e00ffULL,
0x000076320e547816ULL, 0x040fe20000000054ULL, 0x000100000e0e7824ULL, 0x000fc400078e00ffULL,
0x0000005c05307223ULL, 0x084fe20000010030ULL, 0x0000763212117816ULL, 0x000fe20000000011ULL,
0x000100004c057824ULL, 0x000fe200078e00ffULL, 0x0000763213597816ULL, 0x000fe20000000059ULL,
0x0000005b042d7223ULL, 0x088fe2000001002dULL, 0x000100000f047824ULL, 0x000fe400078e00ffULL,
0x0000005c072c7223ULL, 0x080fe2000001002cULL, 0x0001000006077824ULL, 0x000fe400078e00ffULL,
0x0000005c052a7223ULL, 0x000fe2000001002aULL, 0x0000005b04257223ULL, 0x000fe20000010025ULL,
0x0001000010107824ULL, 0x000fc400078e00ffULL, 0x0000005c4b347223ULL, 0x080fe20000010034ULL,
0x0001000012127824ULL, 0x000fe400078e00ffULL, 0x0000005c4a3b7223ULL, 0x080fe2000001003bULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x0000005c4d367223ULL, 0x080fe20000010036ULL,
0x000100004e057824ULL, 0x000fe400078e00ffULL, 0x0000005c4f327223ULL, 0x000fe20000010032ULL,
0x0001000009097824ULL, 0x000fc400078e00ffULL, 0x0000005c07287223ULL, 0x080fe20000010028ULL,
0x000100000a0a7824ULL, 0x000fe400078e00ffULL, 0x0000005c51247223ULL, 0x080fe20000010024ULL,
0x000100000c0c7824ULL, 0x000fe400078e00ffULL, 0x0000005c05267223ULL, 0x080fe20000010026ULL,
0x0001000054547824ULL, 0x000fe400078e00ffULL, 0x0000005c50397223ULL, 0x000fe20000010039ULL,
0x0001000056567824ULL, 0x000fc400078e00ffULL, 0x0000005c08237223ULL, 0x080fe20000010023ULL,
0x0001000057577824ULL, 0x000fe400078e00ffULL, 0x0000005c532e7223ULL, 0x080fe2000001002eULL,
0x0001000011047824ULL, 0x000fe400078e00ffULL, 0x0000005c09207223ULL, 0x080fe20000010020ULL,
0x0001000059067824ULL, 0x000fe400078e00ffULL, 0x0000005c52217223ULL, 0x080fe20000010021ULL,
0x0000005c0a1d7223ULL, 0x000fe2000001001dULL, 0x0000005b553a7223ULL, 0x080fe2000001003aULL,
0x0000005b0d387223ULL, 0x080fe20000010038ULL, 0x0000005b0c2b7223ULL, 0x080fe2000001002bULL,
0x0000005b0e377223ULL, 0x080fe20000010037ULL, 0x0000005b54297223ULL, 0x080fe20000010029ULL,
0x0000005b58357223ULL, 0x080fe20000010035ULL, 0x0000005b56277223ULL, 0x080fe20000010027ULL,
0x0000005b10337223ULL, 0x080fe20000010033ULL, 0x0000005b5a317223ULL, 0x080fe20000010031ULL,
0x0000005b57227223ULL, 0x080fe20000010022ULL, 0x0000005b122f7223ULL, 0x080fe2000001002fULL,
0x0000005b041f7223ULL, 0x080fe2000001001fULL, 0x0000005b131e7223ULL, 0x080fe2000001001eULL,
0x0000005b063d7223ULL, 0x000fe2000001003dULL, 0xfffffff400ac8947ULL, 0x000fec000383ffffULL,
0x018000003c007836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe80000010000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000e1d000097802ULL, 0x000fce0000000f00ULL,
0x0000006c00187944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e000aULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000003c00037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc8000000003cULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000157919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x104fe40000011615ULL, 0x00000008150b7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff0e7819ULL, 0x000fe20000011615ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0300037589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff1a7812ULL, 0x000fc600078ee215ULL,
0x00001f0b000c7589ULL, 0x00072400000e0000ULL, 0x000000081a1c7836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x000000081c177824ULL, 0x000fe400078e00ffULL,
0x0000003403047220ULL, 0x044fe20000410000ULL, 0x0000003003057220ULL, 0x040fe20000410000ULL,
0x0000003b033b7220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000003603067220ULL, 0x040fe20000410000ULL, 0x0000002a03077220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000002803097220ULL, 0x040fe20000410000ULL,
0x0000002403087220ULL, 0x040fe20000410000ULL, 0x00000026030b7220ULL, 0x048fe20000410000ULL,
0x0000003903397220ULL, 0x040fe20000410000ULL, 0x0000002303007220ULL, 0x040fe20000410000ULL,
0x0000002e030a7220ULL, 0x040fe20000410000ULL, 0x00000020030d7220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000001d03027220ULL, 0x000fe20000410000ULL,
0x000000030e037812ULL, 0x000fe200078ec0ffULL, 0x0000003a0c3a7220ULL, 0x050fe20000410000ULL,
0x0000002d0c2d7220ULL, 0x040fe20000410000ULL, 0x000000380c387220ULL, 0x040fe20000410000ULL,
0x0000000403117812ULL, 0x000fe200078efcffULL, 0x0000002b0c2b7220ULL, 0x040fe20000410000ULL,
0x000000370c377220ULL, 0x040fe20000410000ULL, 0x000000290c0e7220ULL, 0x040fe20000410000ULL,
0x000000350c357220ULL, 0x040fe20000410000ULL, 0x000000270c107220ULL, 0x040fe20000410000ULL,
0x000000330c337220ULL, 0x040fe20000410000ULL, 0x000000250c127220ULL, 0x040fe20000410000ULL,
0x000000310c317220ULL, 0x040fe20000410000ULL, 0x000000220c227220ULL, 0x040fe20000410000ULL,
0x0000002f0c2f7220ULL, 0x040fe20000410000ULL, 0x0000001f0c187220ULL, 0x040fe20000410000ULL,
0x0000001e0c1e7220ULL, 0x040fe20000410000ULL, 0x0000003d0c3d7220ULL, 0x000fe20000410000ULL,
0x000000081a0c7824ULL, 0x000fe200078e00ffULL, 0x00000007030f7812ULL, 0x000fc400078e781aULL,
0x0000000703207812ULL, 0x000fe400078e781cULL, 0x0000000711137812ULL, 0x000fe400078e781aULL,
0x00000007111c7812ULL, 0x000fe400078e781cULL, 0x0000000c0f037212ULL, 0x080fe400078efcffULL,
0x00000017200f7212ULL, 0x080fe400078efcffULL, 0x0000000c13117212ULL, 0x000fe200078efcffULL,
0x0000001003037824ULL, 0x100fe200078e0216ULL, 0x000000171c177212ULL, 0x000fe200078efcffULL,
0x000000100f137824ULL, 0x100fe200078e0216ULL, 0x000000040504723eULL, 0x000fe200000010ffULL,
0x0000001011117824ULL, 0x100fe200078e0216ULL, 0x000000060706723eULL, 0x000fe200000010ffULL,
0x0000001017167824ULL, 0x000fe200078e0216ULL, 0x0000003b2c05723eULL, 0x000fc400000010ffULL,
0x000000320907723eULL, 0x000fe400000010ffULL, 0x000000080b08723eULL, 0x000fe400000010ffULL,
0x000000390009723eULL, 0x000fe200000010ffULL, 0x0000000403007844ULL, 0x0005e20000000200ULL,
0x0000000a0d0a723eULL, 0x000fe400000010ffULL, 0x00000021020b723eULL, 0x000fe400000010ffULL,
0x0000003a2d0c723eULL, 0x000fc400000010ffULL, 0x000000382b0d723eULL, 0x000fe200000010ffULL,
0x0000000811007844ULL, 0x0005e20000000200ULL, 0x000000370e0e723eULL, 0x000fe400000010ffULL,
0x00000035100f723eULL, 0x000fe400000010ffULL, 0x000000331230723eULL, 0x000fe400000010ffULL,
0x000000312231723eULL, 0x000fe200000010ffULL, 0x0000000c13007844ULL, 0x0005e20000000200ULL,
0x0000002f1832723eULL, 0x000fc400000010ffULL, 0x0000001e3d33723eULL, 0x000fca00000010ffULL,
0x0000003016007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000197919ULL, 0x004e620000002600ULL, 0x00000020151d7836ULL, 0x040fe20000000000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000040151f7836ULL, 0x040fe20000000000ULL,
0x00000003ff007819ULL, 0x000fe20000011615ULL, 0x0000006015217836ULL, 0x000fe20000000000ULL,
0x00000003ff037819ULL, 0x000fe2000001161dULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff177819ULL, 0x000fe2000001161fULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff187819ULL, 0x000fe20000011621ULL, 0x0000000866667824ULL, 0x000fe200078e00ffULL,
0x0000000703047812ULL, 0x000fe200078e481dULL, 0x0000860000067ab9ULL, 0x000fe20000000a00ULL,
0x0000000717067812ULL, 0x000fc400078e481fULL, 0x0000000718087812ULL, 0x000fe400078e4821ULL,
0x0ffffff806077812ULL, 0x000fe400078ef81fULL, 0x0ffffff808097812ULL, 0x000fe400078ef821ULL,
0x1ffffff866667812ULL, 0x000fe200078ec0ffULL, 0x00000010070c7824ULL, 0x100fe400078e0214ULL,
0x0000001009107824ULL, 0x000fe200078e0214ULL, 0x00000004050472a4ULL, 0x004fe2000f8e023fULL,
0x00000007661b7812ULL, 0x000fc400078ef815ULL, 0x012000000c0c7984ULL, 0x000fe20000000c00ULL,
0x00000007661f7812ULL, 0x000fe200078ef81fULL, 0x0000001019057824ULL, 0x042fe400078e00ffULL,
0x0120000010107984ULL, 0x000fe20000000c00ULL, 0x0000001019167824ULL, 0x000fe200078e00ffULL,
0x0000000766217812ULL, 0x000fe400078ef821ULL, 0xfffffff005027812ULL, 0x000fe400078ee200ULL,
0x0000000700007812ULL, 0x000fc400078e4815ULL, 0xfffffff016167812ULL, 0x000fe400078ee203ULL,
0x0ffffff800037812ULL, 0x000fe400078ef815ULL, 0x0ffffff804057812ULL, 0x000fe400078ef81dULL,
0x0000000402007c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001003047824ULL, 0x100fe200078e0214ULL,
0x00000007661d7812ULL, 0x000fe200078ef81dULL, 0x0000001005087824ULL, 0x000fe400078e0214ULL,
0x0000001019147824ULL, 0x000fc400078e00ffULL, 0x0120000004047984ULL, 0x000e620000000c00ULL,
0x0000001019197824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0120000008087984ULL, 0x000ea20000000c00ULL, 0x0000000600027c11ULL, 0x040fe4000f8048ffULL,
0xfffffff014177812ULL, 0x000fe400078ee217ULL, 0xfffffff019187812ULL, 0x000fe400078ee218ULL,
0x0000000700037c11ULL, 0x000fc400080f4c03ULL, 0x0000000416157c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000417177c10ULL, 0x000fe2000ff3e0ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x0000000418007c10ULL, 0x000fc6000ff5e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x0000000615147c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000000617167c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x0000000600187c11ULL, 0x040fe4000f8448ffULL, 0x0000000715157c11ULL, 0x000fe400080f4c1cULL,
0x0000000717177c11ULL, 0x000fe400088f4c1aULL, 0x0000000700197c11ULL, 0x000fe200090f4c19ULL,
0x000000101d147825ULL, 0x000fc800078e0014ULL, 0x000000101f167825ULL, 0x000fc800078e0016ULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000402007986ULL, 0x002fe8000c101d0cULL,
0x0000000814007986ULL, 0x004fe8000c101d0cULL, 0x0000000c16007986ULL, 0x000fe8000c101d0cULL,
0x0000001018007986ULL, 0x000fe2000c101d0cULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009200ff027b82ULL, 0x000e620000000a00ULL, 0x0000000168007836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x0000000c02697981ULL, 0x002366000c1e9900ULL,
0x0000000500007c0cULL, 0x000fe2000bf06070ULL, 0x0000000215157824ULL, 0x000fe400078e00ffULL,
0x0000004066737824ULL, 0x008fe400078e00ffULL, 0x00000007156c7e24ULL, 0x000fc4000f8e026cULL,
0x0000010068077824ULL, 0x000fc800078e0273ULL, 0x000000046c067c24ULL, 0x000fe4000f8e0207ULL,
0x0000000800fc8947ULL, 0x002fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x00008a00ff047b82ULL, 0x000ea20000000a00ULL, 0x0000000f070e7c48ULL, 0x000fe2000ffe0000ULL,
0x00000000000b7919ULL, 0x000ee20000008800ULL, 0x0000040000027802ULL, 0x000fc60000000f00ULL,
0x000000010e0e7824ULL, 0x000fe200078e0a07ULL, 0x00000003ff297819ULL, 0x002fe20000011600ULL,
0x0000001000037824ULL, 0x040fe200078e00ffULL, 0x0ffffff800097812ULL, 0x000fe400078ec0ffULL,
0x0000000029087212ULL, 0x0c0fe200078e3cffULL, 0x0000000c290d7836ULL, 0x000fe20000000000ULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x0000000429077836ULL, 0x040fe20000000000ULL,
0x0000000709267812ULL, 0x000fe200078ef808ULL, 0x0000000129097824ULL, 0x000fe200078e0206ULL,
0x000006540b027816ULL, 0x008fe20000000002ULL, 0x00000008290b7836ULL, 0x000fe20000000000ULL,
0x000000000d0f7212ULL, 0x080fe200078e3cffULL, 0x0000010009087825ULL, 0x004fe200078e0004ULL,
0x00000000070a7212ULL, 0x000fc400078e3cffULL, 0x000000000b0c7212ULL, 0x000fe200078e3cffULL,
0x000000080d207824ULL, 0x000fe200078e00ffULL, 0x0000000803147210ULL, 0x000fe20007f1e0ffULL,
0x0000000807117824ULL, 0x000fe200078e00ffULL, 0x0000000e0b00720cULL, 0x0c0fe20003f46070ULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20fULL,
0x000000ffff157224ULL, 0x000fe200000e0609ULL, 0xfffffff8111c7812ULL, 0x000fe200078ee20aULL,
0x0000000106097824ULL, 0x040fe200078e0207ULL, 0x0000000e0d00720cULL, 0x080fe20003f66070ULL,
0x00000001060b7824ULL, 0x000fe200078e020bULL, 0xfffffff8131e7812ULL, 0x000fe200078ee20cULL,
0x00000010290f7836ULL, 0x000fe20000000000ULL, 0x0000000e0700720cULL, 0x000fe20003f86070ULL,
0x00000014291d7836ULL, 0x000fc40000000000ULL, 0x0000010009087825ULL, 0x000fc800078e0004ULL,
0x000001000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000803167210ULL, 0x000fc60007f1e0ffULL,
0x00000001060d7824ULL, 0x040fe200078e020dULL, 0x0000000a03187210ULL, 0x000fe20007f3e0ffULL,
0x0000000106117824ULL, 0x040fe400078e020fULL, 0x0000000106137824ULL, 0x000fe400078e021dULL,
0x000001000d0c7825ULL, 0x000fc800078e0004ULL, 0x0000010011107825ULL, 0x000fc800078e0004ULL,
0x0000010013127825ULL, 0x000fc800078e0004ULL, 0x000000ffff177224ULL, 0x000fe200000e0609ULL,
0x0000000c031a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fe200008e060bULL,
0x00000010030a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001829217836ULL, 0x000fe20000000000ULL,
0x0000001203087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e060dULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x000fe200008e0611ULL,
0x000000000f107212ULL, 0x000fe200078e3cffULL, 0x000000ffff097224ULL, 0x000fe200028e0613ULL,
0x0000000e2900720cULL, 0x080fe20003fa6070ULL, 0x00000001060d7824ULL, 0x000fe200078e0221ULL,
0x0000000e1d00720cULL, 0x000fe20003f26070ULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0x000000001d0f7212ULL, 0x080fe200078e3cffULL, 0x0000400066077824ULL, 0x000fe200078e0202ULL,
0x0000000021237212ULL, 0x000fe200078e3cffULL, 0x000000081d247824ULL, 0x000fe200078e00ffULL,
0xfffffff811227812ULL, 0x000fe200078ee210ULL, 0x0000001c291d7836ULL, 0x000fc40000000000ULL,
0x000001000d0c7825ULL, 0x000fe200078e0004ULL, 0xfffffff824247812ULL, 0x000fc600078ee20fULL,
0x0000200007077836ULL, 0x000fe20000000000ULL, 0x0000000c030c7210ULL, 0x000fe20007fde0ffULL,
0x0000000106117824ULL, 0x000fe400078e021dULL, 0x00000010260f7824ULL, 0x000fe400078e0207ULL,
0x0000010011107825ULL, 0x000fc600078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140f7faeULL, 0x0003e2000e901c4cULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x0000000e2100720cULL, 0x000fe20003fa6070ULL, 0x000000101c1f7824ULL, 0x000fe200078e0207ULL,
0x00000010031c7210ULL, 0x000fe20007fde0ffULL, 0x0000002029257836ULL, 0x000fe20000000000ULL,
0x000000001d107212ULL, 0x000fe200078e3cffULL, 0x0000000821267824ULL, 0x000fe200078e00ffULL,
0x00000000161f7faeULL, 0x0005e2000e101c4cULL, 0x0000000106137824ULL, 0x000fe200078e0225ULL,
0x0000000e1d00720cULL, 0x000fe20003f86070ULL, 0x0000002c29217836ULL, 0x000fe20000000000ULL,
0xfffffff826147812ULL, 0x002fe200078ee223ULL, 0x000000081d0f7824ULL, 0x000fc400078e00ffULL,
0x0000001020157824ULL, 0x000fe400078e0207ULL, 0x000000ffff1d7224ULL, 0x000fe400030e0611ULL,
0x0000010013127825ULL, 0x000fe200078e0004ULL, 0xfffffff80f167812ULL, 0x004fe400078ee210ULL,
0x0000000025177212ULL, 0x000fe200078e3cffULL, 0x000000101e0f7824ULL, 0x000fe200078e0207ULL,
0x0000001203127210ULL, 0x000fe20007fde0ffULL, 0x00000024291f7836ULL, 0x000fc40000000000ULL,
0x0000000825207824ULL, 0x000fe200078e00ffULL, 0x00000000180f7faeULL, 0x0003e2000d101c4cULL,
0x0000000106117824ULL, 0x000fe200078e021fULL, 0x0000000e1f00720cULL, 0x040fe20003f46070ULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x000000001f1e7212ULL, 0x040fe200078e3cffULL,
0x000000001a157faeULL, 0x0005e2000d901c4cULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000e2500720cULL, 0x000fe20003f66070ULL, 0x0000010011107825ULL, 0x000fc600078e0004ULL,
0xfffffff81f1e7812ULL, 0x000fe200078ee21eULL, 0x00000010220f7824ULL, 0x102fe200078e0207ULL,
0xfffffff820187812ULL, 0x000fe200078ee217ULL, 0x00000028291f7836ULL, 0x040fe20000000000ULL,
0x0000001003107210ULL, 0x000fe20007fde0ffULL, 0x0000001014177824ULL, 0x100fe200078e0207ULL,
0x000000000a0f7faeULL, 0x0003e2000c101c4cULL, 0x0000001024157824ULL, 0x104fe400078e0207ULL,
0x0000001016197824ULL, 0x100fe400078e0207ULL, 0x00000010181b7824ULL, 0x000fe200078e0207ULL,
0x0000000008157faeULL, 0x0005e2000c901c4cULL, 0x0000003029237836ULL, 0x000fc40000000000ULL,
0x0000003429257836ULL, 0x040fe20000000000ULL, 0x000000000c177faeULL, 0x0007e2000e901c4cULL,
0x0000003829277836ULL, 0x000fe20000000000ULL, 0x0000000e2100720cULL, 0x080fe20003fa6070ULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000001c197faeULL, 0x000fe2000e101c4cULL,
0x000000101e0f7824ULL, 0x002fe200078e0207ULL, 0x0000000e1f00720cULL, 0x040fe20003fc6070ULL,
0x00000001060b7824ULL, 0x000fe200078e0221ULL, 0x000000001f087212ULL, 0x044fe200078e3cffULL,
0x000000081f097824ULL, 0x000fe200078e00ffULL, 0x00000000121b7faeULL, 0x0003e2000d901c4cULL,
0x0000003c29157836ULL, 0x000fe20000000000ULL, 0x0000000e2300720cULL, 0x080fe20003f86070ULL,
0x0000000821147824ULL, 0x000fe200078e00ffULL, 0x0000000e2500720cULL, 0x080fe20003f66070ULL,
0x00000000100f7faeULL, 0x0005e2000d101c4cULL, 0x0000000e2700720cULL, 0x080fe20003f26070ULL,
0x000001000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000e1500720cULL, 0x000fc40003f06070ULL,
0x00000000230e7212ULL, 0x080fe200078e3cffULL, 0x0000000106177824ULL, 0x048fe200078e0215ULL,
0xfffffff809127812ULL, 0x002fe200078ee208ULL, 0x0000000106097824ULL, 0x040fe200078e021fULL,
0x00000000210d7212ULL, 0x000fe200078e3cffULL, 0x0000000106137824ULL, 0x000fe400078e0223ULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0xfffffff814147812ULL, 0x000fc600078ee20dULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x00000008030c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000825117824ULL, 0x004fe400078e00ffULL, 0x00000008151a7824ULL, 0x000fe200078e00ffULL,
0xfffffff823167812ULL, 0x000fe200078ee20eULL, 0x000000ffff0d7224ULL, 0x000fe200010e0609ULL,
0x0000000a030e7210ULL, 0x000fe20007f5e0ffULL, 0x0000010013087825ULL, 0x000fe200078e0004ULL,
0x00000000250a7212ULL, 0x000fc600078e3cffULL, 0x0000000106257824ULL, 0x000fe200078e0225ULL,
0xfffffff811187812ULL, 0x000fe200078ee20aULL, 0x000000ffff0f7224ULL, 0x000fe200010e060bULL,
0x0000000803107210ULL, 0x000fe20007f5e0ffULL, 0x00000100250a7825ULL, 0x000fc800078e0004ULL,
0x0000000106137824ULL, 0x000fe200078e0227ULL, 0x0000000027067212ULL, 0x080fe200078e3cffULL,
0x000000ffff117224ULL, 0x000fe200010e0609ULL, 0x0000000a030a7210ULL, 0x000fe20007f5e0ffULL,
0x0000010013087825ULL, 0x000fe200078e0004ULL, 0x0000000015137212ULL, 0x000fc600078e3cffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000803087210ULL, 0x000fe20007f5e0ffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL,
0x0000010017047825ULL, 0x000fc600078e0004ULL, 0xfffffff827067812ULL, 0x000fe200078ee206ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000000403047210ULL, 0x000fe20007f5e0ffULL,
0x0000001012137824ULL, 0x100fe400078e0207ULL, 0x0000001014157824ULL, 0x100fe400078e0207ULL,
0x0000001016177824ULL, 0x100fe200078e0207ULL, 0x000000000c137faeULL, 0x0003e2000f101c4cULL,
0x0000001018037824ULL, 0x100fe400078e0207ULL, 0x0000001006197824ULL, 0x100fe200078e0207ULL,
0x000000000e157faeULL, 0x0003e2000e901c4cULL, 0x000000101a077824ULL, 0x000fc400078e0207ULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x0000000010177faeULL, 0x0003e8000e101c4cULL,
0x000000000a037faeULL, 0x0003e8000d901c4cULL, 0x0000000008197faeULL, 0x0003e8000c901c4cULL,
0x0000000004077faeULL, 0x0003e2000c101c4cULL, 0x0000000800b07947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0000040000027802ULL, 0x000fe20000000f00ULL,
0x0000000000077919ULL, 0x000ea20000008800ULL, 0x00000003ff037819ULL, 0x002fe40000011600ULL,
0x0ffffff800057812ULL, 0x000fe400078ec0ffULL, 0x0000000003047212ULL, 0x0c0fe200078e3cffULL,
0x0000000403097836ULL, 0x000fe20000000000ULL, 0x0000065407027816ULL, 0x004fe20000000002ULL,
0x00000008030d7836ULL, 0x000fe20000000000ULL, 0x0000000705087812ULL, 0x000fe200078ef804ULL,
0x0000000809137824ULL, 0x040fe200078e00ffULL, 0x0000000009047212ULL, 0x080fe200078e3cffULL,
0x000000080d0c7824ULL, 0x040fe200078e00ffULL, 0x000000000d057212ULL, 0x080fe200078e3cffULL,
0x0000001803157836ULL, 0x040fe20000000000ULL, 0xfffffff8130a7812ULL, 0x000fe200078ee204ULL,
0x0000001403137836ULL, 0x000fe20000000000ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x0000000815147824ULL, 0x040fe200078e00ffULL, 0x0000000015057212ULL, 0x080fe200078e3cffULL,
0x00000008131b7824ULL, 0x040fe200078e00ffULL, 0x0000000013047212ULL, 0x080fe200078e3cffULL,
0x00000028031d7836ULL, 0x040fe20000000000ULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x0000001003117836ULL, 0x040fe20000000000ULL, 0xfffffff81b127812ULL, 0x000fe200078ee204ULL,
0x00000024031b7836ULL, 0x000fe20000000000ULL, 0x000000001d057212ULL, 0x080fe200078e3cffULL,
0x0000000c030f7836ULL, 0x000fe20000000000ULL, 0x00000000110b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000811107824ULL, 0x000fe200078e00ffULL, 0x000000001b047212ULL, 0x0c0fe200078e3cffULL,
0x000000081b237824ULL, 0x000fe200078e00ffULL, 0x000000000f077212ULL, 0x080fe200078e3cffULL,
0x000000081d1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee20bULL,
0x0000002003197836ULL, 0x000fe20000000000ULL, 0xfffffff8231a7812ULL, 0x000fe200078ee204ULL,
0x000000080f0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL,
0x0000001c03177836ULL, 0x000fe20000000000ULL, 0x00000000190b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000819187824ULL, 0x000fe200078e00ffULL, 0x00008a00ff047b82ULL, 0x000e620000000a00ULL,
0x0000003003217836ULL, 0x000fe20000000000ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x0000000817167824ULL, 0x040fe200078e00ffULL, 0x0000000017077212ULL, 0x080fe200078e3cffULL,
0x0000002c031f7836ULL, 0x000fe20000000000ULL, 0xfffffff818187812ULL, 0x000fe200078ee20bULL,
0x0000000821207824ULL, 0x040fe200078e00ffULL, 0x00000000210b7212ULL, 0x080fe200078e3cffULL,
0x0000003403237836ULL, 0x040fe20000000000ULL, 0xfffffff816167812ULL, 0x000fe200078ee207ULL,
0x0000003803277836ULL, 0x000fe20000000000ULL, 0x000000001f077212ULL, 0x080fe200078e3cffULL,
0x0000003c03297836ULL, 0x000fe20000000000ULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x000000081f1e7824ULL, 0x000fe200078e00ffULL, 0x0000000027227212ULL, 0x080fe200078e3cffULL,
0x00000001060b7824ULL, 0x040fe200078e0209ULL, 0x0000000023097212ULL, 0x080fe200078e3cffULL,
0x0000000106257824ULL, 0x040fe200078e0223ULL, 0x0000000029247212ULL, 0x000fe200078e3cffULL,
0x0000000823267824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL,
0x0000000106237824ULL, 0x000fc400078e0227ULL, 0x0000000106457824ULL, 0x000fe400078e0229ULL,
0x0000000827277824ULL, 0x000fe400078e00ffULL, 0x0000000829297824ULL, 0x000fe400078e00ffULL,
0x0000000103077824ULL, 0x000fe200078e0206ULL, 0xfffffff827227812ULL, 0x000fe200078ee222ULL,
0x0000400066037824ULL, 0x000fe200078e0202ULL, 0xfffffff829247812ULL, 0x000fe200078ee224ULL,
0x00000001060d7824ULL, 0x000fc400078e020dULL, 0x00000001060f7824ULL, 0x040fe400078e020fULL,
0x0000000106117824ULL, 0x040fe400078e0211ULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x0000000106157824ULL, 0x040fe400078e0215ULL, 0x0000000106177824ULL, 0x040fe400078e0217ULL,
0x0000000106197824ULL, 0x000fc400078e0219ULL, 0x00000001061b7824ULL, 0x040fe400078e021bULL,
0x00000001061d7824ULL, 0x040fe400078e021dULL, 0x00000001061f7824ULL, 0x040fe400078e021fULL,
0x0000000106217824ULL, 0x000fe200078e0221ULL, 0xfffffff826067812ULL, 0x000fe200078ee209ULL,
0x0000200003097836ULL, 0x000fe40000000000ULL, 0x0000001000037824ULL, 0x000fc400078e00ffULL,
0x0000001008277824ULL, 0x100fe400078e0209ULL, 0x000000100a297824ULL, 0x100fe200078e0209ULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x000000100c2b7824ULL, 0x100fe400078e0209ULL,
0x000000100e2d7824ULL, 0x100fe400078e0209ULL, 0x00000010102f7824ULL, 0x100fe400078e0209ULL,
0x0000001012317824ULL, 0x000fc400078e0209ULL, 0x0000001014337824ULL, 0x100fe400078e0209ULL,
0x0000001016357824ULL, 0x100fe400078e0209ULL, 0x0000001018377824ULL, 0x100fe400078e0209ULL,
0x000000101a397824ULL, 0x100fe400078e0209ULL, 0x000000101c3b7824ULL, 0x100fe400078e0209ULL,
0x000000101e3d7824ULL, 0x000fc400078e0209ULL, 0x00000010203f7824ULL, 0x100fe400078e0209ULL,
0x0000001006417824ULL, 0x100fe400078e0209ULL, 0x0000001022437824ULL, 0x100fe400078e0209ULL,
0x0000001024477824ULL, 0x000fe400078e0209ULL, 0x000001000b087825ULL, 0x002fc800078e0004ULL,
0x000001000d0a7825ULL, 0x000fc800078e0004ULL, 0x000001000f0c7825ULL, 0x000fc800078e0004ULL,
0x00000100110e7825ULL, 0x000fc800078e0004ULL, 0x0000010013107825ULL, 0x000fc800078e0004ULL,
0x0000010015127825ULL, 0x000fc800078e0004ULL, 0x0000010017147825ULL, 0x000fc800078e0004ULL,
0x0000010019167825ULL, 0x000fc800078e0004ULL, 0x000001001b187825ULL, 0x000fc800078e0004ULL,
0x0000010007067825ULL, 0x000fc800078e0004ULL, 0x000001001d1a7825ULL, 0x000fc800078e0004ULL,
0x000001001f1c7825ULL, 0x000fc800078e0004ULL, 0x00000100211e7825ULL, 0x000fc800078e0004ULL,
0x0000010025207825ULL, 0x000fc800078e0004ULL, 0x0000010023227825ULL, 0x000fc800078e0004ULL,
0x0000010045247825ULL, 0x000fe200078e0004ULL, 0x0000000603047210ULL, 0x000fe40007f1e0ffULL,
0x0000000803067210ULL, 0x000fe40007f3e0ffULL, 0x0000000a03087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0607ULL, 0x0000000c030a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0609ULL, 0x0000000e030c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e060bULL, 0x00000010030e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e060dULL, 0x0000001203107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060fULL, 0x0000001403127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e0611ULL, 0x0000001603147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0613ULL, 0x0000001803167210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200018e0615ULL, 0x0000001a03187210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004277faeULL, 0x0003e2000b901c4cULL,
0x0000001c031a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0617ULL,
0x0000001e031c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000006297faeULL, 0x0003e2000b901c4cULL,
0x000000ffff177224ULL, 0x000fe200008e0619ULL, 0x00000020031e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e061bULL, 0x00000000082b7faeULL, 0x0003e2000b901c4cULL,
0x000000ffff1b7224ULL, 0x000fe200018e061dULL, 0x0000002203207210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061fULL, 0x000000000a2d7faeULL, 0x0003e2000b901c4cULL,
0x0000002403227210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1f7224ULL, 0x000fc400008e0621ULL,
0x000000000c2f7faeULL, 0x0003e2000b901c4cULL, 0x000000ffff217224ULL, 0x000fe400010e0623ULL,
0x000000ffff237224ULL, 0x000fe200018e0625ULL, 0x000000000e317faeULL, 0x0003e8000b901c4cULL,
0x0000000010337faeULL, 0x0003e8000b901c4cULL, 0x0000000012357faeULL, 0x0003e8000b901c4cULL,
0x0000000014377faeULL, 0x0003e8000b901c4cULL, 0x0000000016397faeULL, 0x0003e8000b901c4cULL,
0x00000000183b7faeULL, 0x0003e8000b901c4cULL, 0x000000001a3d7faeULL, 0x0003e8000b901c4cULL,
0x000000001c3f7faeULL, 0x0003e8000b901c4cULL, 0x000000001e417faeULL, 0x0003e8000b901c4cULL,
0x0000000020437faeULL, 0x0003e8000b901c4cULL, 0x0000000022477faeULL, 0x0003e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c600ff020075a7ULL, 0x000ea2000800017fULL,
0x000000036600780cULL, 0x000fe20003f24070ULL, 0x00000001ff157424ULL, 0x002fe400078e00ffULL,
0x80000000ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000004400188947ULL, 0x004ff20003800000ULL,
0x0000000000ac1947ULL, 0x000fea0003800000ULL, 0x0000002066037824ULL, 0x000fc800078e0200ULL,
0x0000002003057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x000001e005057812ULL, 0x000fe400078ec0ffULL,
0x0000000104087812ULL, 0x000fe400078efcffULL, 0x0000000704067812ULL, 0x000fe400078e7803ULL,
0x0000000708087812ULL, 0x000fc600078e7803ULL, 0x0000000105077824ULL, 0x040fe400078e0206ULL,
0x0000000105097824ULL, 0x000fe400078e0208ULL, 0x0000001007077824ULL, 0x100fe400078e0202ULL,
0x0000001009097824ULL, 0x000fe400078e0202ULL, 0x0000001004067836ULL, 0x040fe20000000000ULL,
0x0000000007107984ULL, 0x000e620000000c00ULL, 0x0000001104047836ULL, 0x000fc60000000000ULL,
0x00000000090c7984ULL, 0x000ea20000000c00ULL, 0x0000000706067812ULL, 0x000fe400078e7803ULL,
0x0000000704047812ULL, 0x000fc600078e7803ULL, 0x0000000105037824ULL, 0x040fe400078e0206ULL,
0x0000000105057824ULL, 0x000fe400078e0204ULL, 0x0000001003037824ULL, 0x100fe400078e0202ULL,
0x0000001005057824ULL, 0x000fe400078e0202ULL, 0x000000ffff187224ULL, 0x002fe400078e0010ULL,
0x000000ffff197224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0013ULL, 0x0000001807007388ULL, 0x000fe20000000c00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fca00078e000fULL,
0x0000001c09007388ULL, 0x000fe80000000c00ULL, 0x00000000050c7984ULL, 0x000e680000000c00ULL,
0x0000000003107984ULL, 0x000ea20000000c00ULL, 0x000000ffff237224ULL, 0x002fe400078e000eULL,
0x000000ffff227224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff207224ULL, 0x004fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002003007388ULL, 0x0003e80000000c00ULL, 0x0000000c05007388ULL, 0x0003e40000000c00ULL,
0x01c6001502ff79a7ULL, 0x0005e2000850003fULL, 0x0000000568007c0cULL, 0x000fe2000bf26070ULL,
0x01c6000b020075a7ULL, 0x000ee4000800017fULL, 0x0000004000708947ULL, 0x00cff40003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x3d80000069697820ULL, 0x020fe20000410000ULL,
0x0000001066727824ULL, 0x000fe200078e0202ULL, 0x00007610ff6d7816ULL, 0x000fe2000000006dULL,
0x000000ffff607224ULL, 0x000fe200078e00ffULL, 0xffffffff05047890ULL, 0x000fd8000fffe03fULL,
0x0000010068717824ULL, 0x000fca00078e0273ULL, 0x0000000f71007c0cULL, 0x000fda000bf01070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x002fe200078e0060ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000ffff657224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fce000001ff00ULL, 0x0000000165047836ULL, 0x000fe20000000000ULL,
0x00008e0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000103607812ULL, 0x000fc600078e0cffULL,
0x00000001ff057819ULL, 0x000fe40000011604ULL, 0x000000020400780cULL, 0x000fc60003f06070ULL,
0x0000006705067224ULL, 0x000fc800078e0268ULL, 0x0000000106057836ULL, 0x040fe40000000000ULL,
0x0000010006097824ULL, 0x000fe400078e0273ULL, 0x000000ffff067224ULL, 0x000fe200078e0065ULL,
0x0000000505007c0cULL, 0x000fe2000bf26070ULL, 0x000000066c0a7c24ULL, 0x000fe2000f8e0209ULL,
0x0000000104057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff657224ULL, 0x000fd400078e0004ULL,
0x0000000800b09947ULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fe20000011600ULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x0000000f090c7c48ULL, 0x000fc6000ffe0000ULL,
0x00000004071d7836ULL, 0x040fe20000000000ULL, 0xfffffff805057812ULL, 0x000fe200078ee200ULL,
0x00000008071f7836ULL, 0x040fe40000000000ULL, 0x0000000c073d7836ULL, 0x000fe20000000000ULL,
0x000000001d047212ULL, 0x080fe200078e3cffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a09ULL,
0x000000001f087212ULL, 0x080fe200078e3cffULL, 0x000000081d0b7824ULL, 0x000fe200078e00ffULL,
0x000000003d097212ULL, 0x000fe200078e3cffULL, 0x000000081f0d7824ULL, 0x000fe200078e00ffULL,
0x0000000c1d00720cULL, 0x000fe20003f46070ULL, 0x000000083d427824ULL, 0x000fe200078e00ffULL,
0xfffffff80b3c7812ULL, 0x000fe200078ee204ULL, 0x0000001407417836ULL, 0x040fe20000000000ULL,
0xfffffff80d407812ULL, 0x000fe200078ee208ULL, 0x00000010073f7836ULL, 0x000fe20000000000ULL,
0xfffffff842427812ULL, 0x000fe200078ee209ULL, 0x00000008410b7824ULL, 0x040fe200078e00ffULL,
0x0000000041087212ULL, 0x080fe200078e3cffULL, 0x000000083f097824ULL, 0x040fe200078e00ffULL,
0x000000003f047212ULL, 0x080fe200078e3cffULL, 0x0000001807437836ULL, 0x040fe20000000000ULL,
0xfffffff80b467812ULL, 0x000fe200078ee208ULL, 0x0000001c07457836ULL, 0x000fe20000000000ULL,
0xfffffff809447812ULL, 0x000fe200078ee204ULL, 0x00000008430d7824ULL, 0x040fe200078e00ffULL,
0x00008a00ff087b82ULL, 0x000e620000000a00ULL, 0x0000000043147212ULL, 0x080fe200078e3cffULL,
0x0000002007477836ULL, 0x000fe20000000000ULL, 0x0000000045127212ULL, 0x0c0fe200078e3cffULL,
0x00000008450b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d147812ULL, 0x000fe200078ee214ULL,
0x00000008470d7824ULL, 0x040fe200078e00ffULL, 0x0000000047107212ULL, 0x080fe200078e3cffULL,
0x0000002407497836ULL, 0x000fe20000000000ULL, 0xfffffff80b127812ULL, 0x000fe200078ee212ULL,
0x0000400066047824ULL, 0x000fe200078e0202ULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x00000008490b7824ULL, 0x040fe200078e00ffULL, 0x00000000490e7212ULL, 0x080fe200078e3cffULL,
0x0000000107177824ULL, 0x140fe200078e020aULL, 0x00000000070d7212ULL, 0x000fe200078e3cffULL,
0x000000011d1d7824ULL, 0x000fe200078e020aULL, 0xfffffff80b0e7812ULL, 0x000fe200078ee20eULL,
0x00002000600b7824ULL, 0x000fe200078e0204ULL, 0x000000070d0d7812ULL, 0x000fc400078ec0ffULL,
0x0000000c0700720cULL, 0x080fe20003f26070ULL, 0x000020000b0b7836ULL, 0x000fe20000000000ULL,
0x0ffffff80d1e7812ULL, 0x000fe200078ef800ULL, 0x0000010017167825ULL, 0x002fe200078e0008ULL,
0x0000000c1f00720cULL, 0x080fe40003f66070ULL, 0x0000000c3d00720cULL, 0x080fe20003f86070ULL,
0x000000011f1f7824ULL, 0x100fe200078e020aULL, 0x0000000c3f00720cULL, 0x000fe20003fa6070ULL,
0x000000013d3d7824ULL, 0x100fe400078e020aULL, 0x000000013f3f7824ULL, 0x000fc400078e020aULL,
0x000001001d1c7825ULL, 0x000fc800078e0008ULL, 0x000000101e0d7824ULL, 0x100fe400078e020bULL,
0x000000103c0f7824ULL, 0x000fe400078e020bULL, 0x000001001f1e7825ULL, 0x000fc800078e0008ULL,
0x000001003d3c7825ULL, 0x000fc800078e0008ULL, 0x0000001005167825ULL, 0x000fc800078e0016ULL,
0x000001003f3e7825ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000160d7faeULL, 0x0003e2000c901c4cULL, 0x0000000c4100720cULL, 0x000fe40003f26070ULL,
0x00000010051c7825ULL, 0x000fc800078e001cULL, 0x0000001040117824ULL, 0x000fe200078e020bULL,
0x000000001c0f7faeULL, 0x0005e2000d101c4cULL, 0x00000010051e7825ULL, 0x000fe200078e001eULL,
0x0000000c4300720cULL, 0x000fc60003f46070ULL, 0x0000001042137824ULL, 0x000fe200078e020bULL,
0x000000001e117faeULL, 0x0007e2000d901c4cULL, 0x00000010053c7825ULL, 0x000fe200078e003cULL,
0x0000000c4500720cULL, 0x000fc60003f66070ULL, 0x0000001044157824ULL, 0x000fe200078e020bULL,
0x000000003c137faeULL, 0x000fe2000e101c4cULL, 0x00000010053e7825ULL, 0x000fe200078e003eULL,
0x0000000c4700720cULL, 0x000fc60003f86070ULL, 0x0000000141177824ULL, 0x102fe200078e020aULL,
0x000000003e157faeULL, 0x0003e2000e901c4cULL, 0x00000001431d7824ULL, 0x004fe200078e020aULL,
0x0000000c4900720cULL, 0x000fe20003fa6070ULL, 0x0000010017167825ULL, 0x000fc800078e0008ULL,
0x00000001450f7824ULL, 0x100fe400078e020aULL, 0x0000000147117824ULL, 0x008fe400078e020aULL,
0x000001001d1c7825ULL, 0x000fc800078e0008ULL, 0x00000001493f7824ULL, 0x002fe400078e020aULL,
0x000001000f1e7825ULL, 0x000fc800078e0008ULL, 0x00000100113c7825ULL, 0x000fc800078e0008ULL,
0x00000010460d7824ULL, 0x000fe400078e020bULL, 0x0000001005167825ULL, 0x000fc800078e0016ULL,
0x000001003f3e7825ULL, 0x000fe200078e0008ULL, 0x00000000160d7faeULL, 0x0003e6000c901c4cULL,
0x00000010140f7824ULL, 0x000fe400078e020bULL, 0x00000010051c7825ULL, 0x000fc800078e001cULL,
0x0000001012117824ULL, 0x000fe200078e020bULL, 0x000000001c0f7faeULL, 0x0005e2000d101c4cULL,
0x00000010051e7825ULL, 0x000fc800078e001eULL, 0x0000001010137824ULL, 0x000fe200078e020bULL,
0x000000001e117faeULL, 0x000fe2000d901c4cULL, 0x00000010053c7825ULL, 0x000fc800078e003cULL,
0x000000100e0d7824ULL, 0x002fe200078e020bULL, 0x000000003c137faeULL, 0x000fe2000e101c4cULL,
0x00000010053e7825ULL, 0x000fc800078e003eULL, 0x0000002c07177836ULL, 0x040fe20000000000ULL,
0x000000003e0d7faeULL, 0x0003e2000e901c4cULL, 0x0000002807157836ULL, 0x040fe40000000000ULL,
0x0000003007417836ULL, 0x000fe20000000000ULL, 0x0000000c1700720cULL, 0x000fe20003f46070ULL,
0x0000003407437836ULL, 0x000fe20000000000ULL, 0x00000000150e7212ULL, 0x000fe200078e3cffULL,
0x0000003807457836ULL, 0x000fe20000000000ULL, 0x0000000c1500720cULL, 0x080fe20003f26070ULL,
0x0000003c071d7836ULL, 0x004fe20000000000ULL, 0x0000000c4100720cULL, 0x000fe20003f66070ULL,
0x0000000817107824ULL, 0x040fe200078e00ffULL, 0x00000000170d7212ULL, 0x002fe200078e3cffULL,
0x00000008150f7824ULL, 0x000fe200078e00ffULL, 0x0000000c4300720cULL, 0x080fe20003f86070ULL,
0x0000000141117824ULL, 0x100fe200078e020aULL, 0x0000000c4500720cULL, 0x080fe20003fa6070ULL,
0x0000000143137824ULL, 0x100fe200078e020aULL, 0x0000000c1d00720cULL, 0x000fe20003fc6070ULL,
0x00000001453d7824ULL, 0x100fe200078e020aULL, 0xfffffff8100c7812ULL, 0x000fe200078ee20dULL,
0x00000001150d7824ULL, 0x100fe200078e020aULL, 0xfffffff80f0e7812ULL, 0x000fe200078ee20eULL,
0x0000000841157824ULL, 0x040fe200078e00ffULL, 0x0000000041107212ULL, 0x080fe200078e3cffULL,
0x00000001170f7824ULL, 0x100fe200078e020aULL, 0x0000000043127212ULL, 0x080fe200078e3cffULL,
0x000000011d417824ULL, 0x000fe200078e020aULL, 0x0000000045147212ULL, 0x080fe200078e3cffULL,
0x0000000843437824ULL, 0x000fe200078e00ffULL, 0x000000001d0a7212ULL, 0x000fe200078e3cffULL,
0x0000000845457824ULL, 0x000fe200078e00ffULL, 0xfffffff815107812ULL, 0x000fe200078ee210ULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff843127812ULL, 0x000fe200078ee212ULL,
0x000000100e157824ULL, 0x100fe200078e020bULL, 0xfffffff845147812ULL, 0x000fe200078ee214ULL,
0x000000100c177824ULL, 0x100fe200078e020bULL, 0xfffffff81d0a7812ULL, 0x000fe200078ee20aULL,
0x00000010101d7824ULL, 0x000fc400078e020bULL, 0x00000010121f7824ULL, 0x100fe400078e020bULL,
0x00000010143f7824ULL, 0x100fe400078e020bULL, 0x000000100a437824ULL, 0x000fe400078e020bULL,
0x000001000d0a7825ULL, 0x000fc800078e0008ULL, 0x000001000f0c7825ULL, 0x000fc800078e0008ULL,
0x00000100110e7825ULL, 0x000fc800078e0008ULL, 0x0000010013107825ULL, 0x000fc800078e0008ULL,
0x000001003d127825ULL, 0x000fc800078e0008ULL, 0x0000010041087825ULL, 0x000fc800078e0008ULL,
0x00000010050a7825ULL, 0x000fc800078e000aULL, 0x00000010050c7825ULL, 0x040fe200078e000cULL,
0x000000000a157faeULL, 0x0003e6000c901c4cULL, 0x00000010050e7825ULL, 0x040fe200078e000eULL,
0x000000000c177faeULL, 0x0003e6000d101c4cULL, 0x0000001005107825ULL, 0x040fe200078e0010ULL,
0x000000000e1d7faeULL, 0x0003e6000d901c4cULL, 0x0000001005127825ULL, 0x040fe200078e0012ULL,
0x00000000101f7faeULL, 0x0003e6000e101c4cULL, 0x0000001005087825ULL, 0x000fe200078e0008ULL,
0x00000000123f7faeULL, 0x0003e8000e901c4cULL, 0x0000000008437faeULL, 0x0003e2000f101c4cULL,
0x0000000800647947ULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fe20000011600ULL,
0x00008a00ff487b82ULL, 0x000e620000000a00ULL, 0x0000000805797824ULL, 0x000fc600078e00ffULL,
0x00000004070b7836ULL, 0x040fe40000000000ULL, 0x0000000807177836ULL, 0x000fe40000000000ULL,
0x000000080b047824ULL, 0x040fe200078e00ffULL, 0x000000000b157212ULL, 0x080fe200078e3cffULL,
0x0000000c071d7836ULL, 0x000fe20000000000ULL, 0x0000000017147212ULL, 0x080fe200078e3cffULL,
0x00000014073d7836ULL, 0x040fe20000000000ULL, 0xfffffff804157812ULL, 0x000fe200078ee215ULL,
0x00000018073f7836ULL, 0x000fe20000000000ULL, 0x000000001d137212ULL, 0x080fe200078e3cffULL,
0x0000000817097824ULL, 0x000fe200078e00ffULL, 0x000000003d117212ULL, 0x080fe200078e3cffULL,
0x000000081d087824ULL, 0x000fe200078e00ffULL, 0x000000003f107212ULL, 0x080fe200078e3cffULL,
0x00000010071f7836ULL, 0x000fe20000000000ULL, 0xfffffff809147812ULL, 0x000fe200078ee214ULL,
0x000000083d047824ULL, 0x000fe200078e00ffULL, 0xfffffff808137812ULL, 0x000fe200078ee213ULL,
0x000000083f0d7824ULL, 0x000fe200078e00ffULL, 0x000000001f127212ULL, 0x080fe200078e3cffULL,
0x0000002407457836ULL, 0x040fe20000000000ULL, 0xfffffff804117812ULL, 0x000fe200078ee211ULL,
0x0000001c07417836ULL, 0x000fe20000000000ULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x000000081f097824ULL, 0x000fe200078e00ffULL, 0x00000000450d7212ULL, 0x080fe200078e3cffULL,
0x0000002007437836ULL, 0x000fe20000000000ULL, 0x00000000410f7212ULL, 0x080fe200078e3cffULL,
0x0000000845087824ULL, 0x000fe200078e00ffULL, 0xfffffff809127812ULL, 0x000fe200078ee212ULL,
0x0000000841047824ULL, 0x000fe200078e00ffULL, 0x00000000430e7212ULL, 0x080fe200078e3cffULL,
0x0000002c074b7836ULL, 0x040fe20000000000ULL, 0xfffffff8080d7812ULL, 0x000fe200078ee20dULL,
0x0000002807477836ULL, 0x000fe20000000000ULL, 0xfffffff8040f7812ULL, 0x000fe200078ee20fULL,
0x0000000843097824ULL, 0x000fe200078e00ffULL, 0x000000004b087212ULL, 0x080fe200078e3cffULL,
0x0000003007597836ULL, 0x000fe20000000000ULL, 0x0000000047047212ULL, 0x080fe200078e3cffULL,
0x000000084b5d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8090e7812ULL, 0x000fe200078ee20eULL,
0x00000008475b7824ULL, 0x000fe200078e00ffULL, 0x0000000059097212ULL, 0x080fe200078e3cffULL,
0x00000038076b7836ULL, 0x040fe20000000000ULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee208ULL,
0x0000003407617836ULL, 0x000fe20000000000ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee204ULL,
0x00000008590c7824ULL, 0x000fe200078e00ffULL, 0x000000006b087212ULL, 0x0c0fe200078e3cffULL,
0x000000086b6f7824ULL, 0x000fe200078e00ffULL, 0x0000000061047212ULL, 0x080fe200078e3cffULL,
0x0000003c07757836ULL, 0x000fe20000000000ULL, 0xfffffff80c5f7812ULL, 0x000fe200078ee209ULL,
0x0000000861637824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee208ULL,
0x00000008750c7824ULL, 0x040fe200078e00ffULL, 0x0000000075097212ULL, 0x080fe200078e3cffULL,
0x000000011d517824ULL, 0x000fe200078e020aULL, 0xfffffff863637812ULL, 0x000fe200078ee204ULL,
0x0000400066047824ULL, 0x000fe200078e0202ULL, 0x0000000007087212ULL, 0x000fe200078e3cffULL,
0x00000001411d7824ULL, 0x100fe200078e020aULL, 0xfffffff80c777812ULL, 0x000fe200078ee209ULL,
0x000000014b417824ULL, 0x100fe200078e020aULL, 0x0000000708057812ULL, 0x000fe200078ec0ffULL,
0x00000001074b7824ULL, 0x000fc400078e020aULL, 0x0000200060097824ULL, 0x000fe200078e0204ULL,
0x0ffffff805057812ULL, 0x000fe200078ef800ULL, 0x000000010b4d7824ULL, 0x100fe400078e020aULL,
0x00000001174f7824ULL, 0x100fe200078e020aULL, 0xfffffff879177812ULL, 0x000fe200078ee200ULL,
0x000000011f537824ULL, 0x000fe400078e020aULL, 0x000001004b4a7825ULL, 0x002fc800078e0048ULL,
0x00002000091c7836ULL, 0x000fe40000000000ULL, 0x000000013d557824ULL, 0x000fe400078e020aULL,
0x000001004d4c7825ULL, 0x000fc800078e0048ULL, 0x000000013f577824ULL, 0x000fe400078e020aULL,
0x000001004f4e7825ULL, 0x000fc800078e0048ULL, 0x00000001431f7824ULL, 0x000fe400078e020aULL,
0x0000010051507825ULL, 0x000fc800078e0048ULL, 0x00000001453d7824ULL, 0x100fe400078e020aULL,
0x00000001473f7824ULL, 0x100fe400078e020aULL, 0x0000000159437824ULL, 0x000fe400078e020aULL,
0x0000010053527825ULL, 0x000fc800078e0048ULL, 0x0000000161457824ULL, 0x100fe400078e020aULL,
0x000000016b477824ULL, 0x100fe400078e020aULL, 0x0000000175597824ULL, 0x000fe400078e020aULL,
0x0000001005167824ULL, 0x000fe400078e021cULL, 0x0000010055547825ULL, 0x000fc800078e0048ULL,
0x0000001015157824ULL, 0x100fe400078e021cULL, 0x0000001014147824ULL, 0x100fe400078e021cULL,
0x0000001013137824ULL, 0x100fe400078e021cULL, 0x0000001012127824ULL, 0x100fe400078e021cULL,
0x0000001011117824ULL, 0x100fe400078e021cULL, 0x0000001010107824ULL, 0x000fc400078e021cULL,
0x000000100f0f7824ULL, 0x100fe400078e021cULL, 0x000000100e0e7824ULL, 0x100fe400078e021cULL,
0x000000100d0d7824ULL, 0x100fe400078e021cULL, 0x000000105b0c7824ULL, 0x100fe400078e021cULL,
0x000000105d0b7824ULL, 0x100fe400078e021cULL, 0x000000105f0a7824ULL, 0x000fc400078e021cULL,
0x0000001063097824ULL, 0x100fe400078e021cULL, 0x000000106f087824ULL, 0x100fe400078e021cULL,
0x0000001077057824ULL, 0x000fe400078e021cULL, 0x0000010057567825ULL, 0x000fc800078e0048ULL,
0x00000010174a7825ULL, 0x000fc800078e004aULL, 0x000001001d1c7825ULL, 0x000fe200078e0048ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004a167faeULL, 0x0003e6000b901c4cULL,
0x00000010174c7825ULL, 0x000fc800078e004cULL, 0x000001001f1e7825ULL, 0x000fe200078e0048ULL,
0x000000004c157faeULL, 0x0003e6000b901c4cULL, 0x00000010174e7825ULL, 0x000fc800078e004eULL,
0x000001003d3c7825ULL, 0x000fe200078e0048ULL, 0x000000004e147faeULL, 0x0003e6000b901c4cULL,
0x0000001017507825ULL, 0x000fc800078e0050ULL, 0x000001003f3e7825ULL, 0x000fe200078e0048ULL,
0x0000000050137faeULL, 0x0003e6000b901c4cULL, 0x0000001017527825ULL, 0x000fc800078e0052ULL,
0x0000010041407825ULL, 0x000fe200078e0048ULL, 0x0000000052127faeULL, 0x0003e6000b901c4cULL,
0x0000001017547825ULL, 0x000fc800078e0054ULL, 0x0000010043427825ULL, 0x000fe200078e0048ULL,
0x0000000054117faeULL, 0x0003e6000b901c4cULL, 0x0000001017567825ULL, 0x000fc800078e0056ULL,
0x0000010045447825ULL, 0x000fe200078e0048ULL, 0x0000000056107faeULL, 0x0003e6000b901c4cULL,
0x00000010171c7825ULL, 0x000fc800078e001cULL, 0x0000010047467825ULL, 0x000fe200078e0048ULL,
0x000000001c0f7faeULL, 0x0003e6000b901c4cULL, 0x00000010171e7825ULL, 0x000fc800078e001eULL,
0x0000010059487825ULL, 0x000fe200078e0048ULL, 0x000000001e0e7faeULL, 0x0003e6000b901c4cULL,
0x00000010173c7825ULL, 0x000fc800078e003cULL, 0x00000010173e7825ULL, 0x040fe200078e003eULL,
0x000000003c0d7faeULL, 0x0003e6000b901c4cULL, 0x0000001017407825ULL, 0x040fe200078e0040ULL,
0x000000003e0c7faeULL, 0x0003e6000b901c4cULL, 0x0000001017427825ULL, 0x040fe200078e0042ULL,
0x00000000400b7faeULL, 0x0003e6000b901c4cULL, 0x0000001017447825ULL, 0x040fe200078e0044ULL,
0x00000000420a7faeULL, 0x0003e6000b901c4cULL, 0x0000001017467825ULL, 0x040fe200078e0046ULL,
0x0000000044097faeULL, 0x0003e6000b901c4cULL, 0x0000001017487825ULL, 0x000fe200078e0048ULL,
0x0000000046087faeULL, 0x0003e8000b901c4cULL, 0x0000000048057faeULL, 0x0003e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000200003057824ULL, 0x002fe200078e0204ULL,
0xfffffff8005f7812ULL, 0x040fe200078ec0ffULL, 0x0000002000037836ULL, 0x040fe20000000000ULL,
0x0000000700097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x000000075f5f7812ULL, 0x000fe200078ef800ULL, 0x0000200005057836ULL, 0x000fe20000000000ULL,
0xfffffff803037812ULL, 0x000fe400078ec0ffULL, 0x0000000809647812ULL, 0x000fc400078ef800ULL,
0x0000000703087812ULL, 0x000fe200078ef800ULL, 0x000080400000791aULL, 0x000fcc0000000000ULL,
0x00000007040a7812ULL, 0x000fe200078e785fULL, 0x00000001040b7836ULL, 0x000fe20000000000ULL,
0x0000000704037812ULL, 0x000fe200078e7808ULL, 0x0000000806777824ULL, 0x000fe400078e0204ULL,
0x000000085f0a7824ULL, 0x000fe400078e020aULL, 0x00000008080c7824ULL, 0x000fe400078e0203ULL,
0x000000100a0a7824ULL, 0x100fe400078e0205ULL, 0x000000100c0c7824ULL, 0x000fc400078e0205ULL,
0x0000000277777824ULL, 0x000fe200078e00ffULL, 0x000000000a10783bULL, 0x000e620000000200ULL,
0x0000000204047836ULL, 0x000fc60000000000ULL, 0x000000000c0c783bULL, 0x000ea40000000200ULL,
0x000000080400780cULL, 0x000fe20003f25270ULL, 0x00010000110a7824ULL, 0x002fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011410ULL, 0x0001000010037824ULL, 0x040fe200078e00ffULL,
0x00008880104d7816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x00000018ff037819ULL, 0x000fe20000011403ULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff5b7819ULL, 0x004fe4000001140cULL, 0x000088800c5c7816ULL, 0x000fe400000000ffULL,
0x00000018ff4f7819ULL, 0x000fe20000011411ULL, 0x0000000a00707306ULL, 0x0003e20000202400ULL,
0x00000018ff557819ULL, 0x000fe40000011412ULL, 0x00000018ff5a7819ULL, 0x000fe40000011413ULL,
0x00008880116e7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x0000888012547816ULL, 0x000fe200000000ffULL, 0x0000001000757306ULL, 0x000fe20000202400ULL,
0x00010000130a7824ULL, 0x042fe200078e00ffULL, 0x0000888013627816ULL, 0x040fe200000000ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fc40000011411ULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x0000000300747306ULL, 0x0003e20000202400ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x00000018ff477819ULL, 0x000fe4000001140fULL,
0x000088800f487816ULL, 0x000fe400000000ffULL, 0x00000018ff567819ULL, 0x000fe2000001140dULL,
0x0000000a00637306ULL, 0x0005e20000202400ULL, 0x0001000012037824ULL, 0x042fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe2000001140eULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x000088800d587816ULL, 0x000fc400000000ffULL, 0x00000018ff037819ULL, 0x000fe40000011403ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x00000011006f7306ULL, 0x000fe20000202400ULL,
0x000000070b0a7812ULL, 0x004fe400078e785fULL, 0x000000070b0b7812ULL, 0x000fe400078e7808ULL,
0x000088800e517816ULL, 0x000fe200000000ffULL, 0x000000085f107824ULL, 0x000fe400078e020aULL,
0x00000003006b7306ULL, 0x0003e20000202400ULL, 0x000100000d0a7824ULL, 0x000fc400078e00ffULL,
0x0000001010107824ULL, 0x000fe400078e0205ULL, 0x000001000d0d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x00000000101c783bULL, 0x000ea20000000200ULL,
0x000100000c037824ULL, 0x042fe200078e00ffULL, 0x00000012006a7306ULL, 0x000fe20000202400ULL,
0x000001000c0c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x00000018ff037819ULL, 0x000fc40000011403ULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x0000001300617306ULL, 0x000ff00000202400ULL, 0x0000000c005d7306ULL, 0x0003f00000202400ULL,
0x00000003005e7306ULL, 0x0007e20000202400ULL, 0x00000008080c7824ULL, 0x002fc800078e020bULL,
0x000000100c0c7824ULL, 0x000fc600078e0205ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x000100000e037824ULL, 0x048fe200078e00ffULL, 0x000000000c10783bULL, 0x000e620000000200ULL,
0x000001000e0e7824ULL, 0x000fe400078e00ffULL, 0x000100001d157824ULL, 0x004fe200078e00ffULL,
0x00000018ff037819ULL, 0x000fe20000011403ULL, 0x000100001c147824ULL, 0x040fe200078e00ffULL,
0x000088801c0b7816ULL, 0x000fe200000000ffULL, 0x0000005500557306ULL, 0x000ea20000202400ULL,
0x00000018ff437819ULL, 0x000fc40000011415ULL, 0x0000007700157211ULL, 0x000fe200078fe0ffULL,
0x0000000277777836ULL, 0x000fe20000000000ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000000715157812ULL, 0x000fe200078e7864ULL, 0x0000000300527306ULL, 0x0007e20000202400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001141dULL, 0x000088801d3e7816ULL, 0x040fe200000000ffULL,
0x0000002064157824ULL, 0x000fe200078e0215ULL, 0x00000018ff3c7819ULL, 0x000fe2000001141eULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x000088801e427816ULL, 0x000fe200000000ffULL,
0x00000014003f7306ULL, 0x0009e20000202400ULL, 0x0000001015157824ULL, 0x000fe200078e0202ULL,
0x00000018ff037819ULL, 0x008fe2000001141cULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x000054106a557816ULL, 0x004fe40000000055ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000100001e147824ULL, 0x050fe200078e00ffULL,
0x0000005400547306ULL, 0x000ea20000202400ULL, 0x000001001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000007700777211ULL, 0x000fe400078fe0ffULL, 0x00000018ff457819ULL, 0x000fe40000011414ULL,
0x000000001514783bULL, 0x000ee20000000200ULL, 0x000088801f467816ULL, 0x000fe200000000ffULL,
0x0000001c00407306ULL, 0x0009e20000202400ULL, 0x00000018ff1e7819ULL, 0x000fc4000001141eULL,
0x0000000777777812ULL, 0x000fe400078e7864ULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x0000541054547816ULL, 0x004fe2000000006bULL, 0x0000004f004f7306ULL, 0x000fe20000202400ULL,
0x000100001f1c7824ULL, 0x010fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x002fe20000011412ULL,
0x0000002064777824ULL, 0x000fe400078e0277ULL, 0x00000100116b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000005a005a7306ULL, 0x000e700000202400ULL,
0x0000006e006e7306ULL, 0x000ff00000202400ULL, 0x0000006200627306ULL, 0x000ea20000202400ULL,
0x000000541430723cULL, 0x008fee0000041830ULL, 0x0000001d00417306ULL, 0x0007e20000202400ULL,
0x0000541061557816ULL, 0x002fc4000000005aULL, 0x0000541062547816ULL, 0x004fca0000000063ULL,
0x0000000a00597306ULL, 0x0003e20000202400ULL, 0x00008880101d7816ULL, 0x008fe400000000ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001146bULL, 0x00000054142c723cULL, 0x000fe8000004182cULL,
0x0000001c004b7306ULL, 0x0005e20000202400ULL, 0x000100000f0a7824ULL, 0x042fe400078e00ffULL,
0x000001000f0f7824ULL, 0x000fe200078e00ffULL, 0x0000888012557816ULL, 0x000fc400000000ffULL,
0x00000018ff0a7819ULL, 0x000fe4000001140aULL, 0x0000005c005c7306ULL, 0x000e620000202400ULL,
0x000054104d1c7816ULL, 0x004fe40000000074ULL, 0x00000018ff4a7819ULL, 0x000fe4000001140fULL,
0x00000018ff0f7819ULL, 0x000fe2000001141fULL, 0x000001001f1f7824ULL, 0x000fe400078e00ffULL,
0x0000001d004d7306ULL, 0x0005e60000202400ULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x000054105c547816ULL, 0x002fc6000000005eULL, 0x0000005b005b7306ULL, 0x000e620000202400ULL,
0x00005410751d7816ULL, 0x004fe2000000004eULL, 0x00000100104e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x000fc600078e0055ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000001c1438723cULL, 0x000fe20000041838ULL, 0x0000001e00447306ULL, 0x0005ec0000202400ULL,
0x000054106e1c7816ULL, 0x000fe40000000070ULL, 0x000054106f1d7816ULL, 0x000fe2000000004fULL,
0x00010000101e7824ULL, 0x004fe200078e00ffULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x000054105d557816ULL, 0x002fe2000000005bULL, 0x00010000125d7824ULL, 0x000fc400078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000001c1434723cULL, 0x000fe40000041834ULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000000a00497306ULL, 0x0002a60000202400ULL,
0x000000541428723cULL, 0x000fe20000041828ULL, 0x00010000111d7824ULL, 0x000fe400078e00ffULL,
0x00000010771c7824ULL, 0x000fc400078e0202ULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x00000018ff6a7819ULL, 0x000fe4000001141dULL, 0x00000018ff0a7819ULL, 0x002fe40000011413ULL,
0x0000541048487816ULL, 0x004fc60000000049ULL, 0x0000005000507306ULL, 0x000ff00000202400ULL,
0x0000004700477306ULL, 0x000ff00000202400ULL, 0x0000005800587306ULL, 0x000e700000202400ULL,
0x0000000d00577306ULL, 0x0004e20000202400ULL, 0x0000541058547816ULL, 0x002fce0000000059ULL,
0x0000005100517306ULL, 0x000e620000202400ULL, 0x00000018ff0d7819ULL, 0x004fe40000011411ULL,
0x0000541057557816ULL, 0x008fca0000000056ULL, 0x0000000e00537306ULL, 0x0004e40000202400ULL,
0x000000541424723cULL, 0x000fe20000041824ULL, 0x0000541051527816ULL, 0x002fca0000000052ULL,
0x0000004a004a7306ULL, 0x000e620000202400ULL, 0x00000018ff0e7819ULL, 0x004fe40000011410ULL,
0x0000888013517816ULL, 0x000fe200000000ffULL, 0x0000010012547824ULL, 0x000fe200078e00ffULL,
0x0000541053537816ULL, 0x008fc60000000050ULL, 0x0000001f004c7306ULL, 0x0005e20000202400ULL,
0x00000018ff547819ULL, 0x000fc60000011454ULL, 0x000000521420723cULL, 0x000fe20000041820ULL,
0x000054104a497816ULL, 0x002fc60000000047ULL, 0x0000001e00107306ULL, 0x0003e20000202400ULL,
0x00008880111f7816ULL, 0x004fe200000000ffULL, 0x000000ffff477224ULL, 0x000fc800078e0051ULL,
0x000000ffff4f7224ULL, 0x000fe200078e001fULL, 0x000000481418723cULL, 0x000fe20000041818ULL,
0x0000000b000b7306ULL, 0x000ea20000202400ULL, 0x000000001c1c783bULL, 0x002e6a0000000200ULL,
0x0001000013157824ULL, 0x040fe400078e00ffULL, 0x0000000300037306ULL, 0x000ee20000202400ULL,
0x0000010013137824ULL, 0x000fca00078e00ffULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x000054100b147816ULL, 0x004fe2000000003fULL, 0x0000000f000f7306ULL, 0x000fe20000202400ULL,
0x00000018ff0b7819ULL, 0x000fe40000011415ULL, 0x0000541040157816ULL, 0x008fca0000000003ULL,
0x0000000e000e7306ULL, 0x000ff00000202400ULL, 0x0000003e003e7306ULL, 0x000ff00000202400ULL,
0x0000004300437306ULL, 0x000ea20000202400ULL, 0x000000141c38723cULL, 0x002fee0000041838ULL,
0x0000004e004e7306ULL, 0x000e620000202400ULL, 0x000054104d147816ULL, 0x000fc40000000010ULL,
0x000054103e3e7816ULL, 0x004fca0000000043ULL, 0x0000003d003d7306ULL, 0x000ea20000202400ULL,
0x000054104e157816ULL, 0x002fce000000000eULL, 0x0000003c003c7306ULL, 0x000e620000202400ULL,
0x000000141c28723cULL, 0x000fe20000041828ULL, 0x00005410413f7816ULL, 0x004fcc000000003dULL,
0x0000000d000d7306ULL, 0x000fe20000202400ULL, 0x0000003e1c34723cULL, 0x000fe20000041834ULL,
0x0000541044437816ULL, 0x002fcc000000003cULL, 0x0000000c000c7306ULL, 0x000ff00000202400ULL,
0x0000000a000a7306ULL, 0x000ff00000202400ULL, 0x0000004200427306ULL, 0x000ff00000202400ULL,
0x0000004500457306ULL, 0x000e700000202400ULL, 0x0000004600467306ULL, 0x000ea20000202400ULL,
0x0000541042427816ULL, 0x002fce0000000045ULL, 0x0000004f004f7306ULL, 0x000fe20000202400ULL,
0x000000421c30723cULL, 0x000fe20000041830ULL, 0x0000541046467816ULL, 0x004fcc000000004bULL,
0x0000006a00117306ULL, 0x000e700000202400ULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x000054104f0e7816ULL, 0x002fce0000000011ULL, 0x0000005c005b7306ULL, 0x000ff00000202400ULL,
0x0000005d00127306ULL, 0x000e700000202400ULL, 0x0000005400507306ULL, 0x000fe20000202400ULL,
0x000054105b127816ULL, 0x002fce0000000012ULL, 0x0000004700167306ULL, 0x0003f00000202400ULL,
0x0000000b000b7306ULL, 0x000ea20000202400ULL, 0x000054104c477816ULL, 0x002fe4000000000fULL,
0x000054105a0f7816ULL, 0x000fca000000000dULL, 0x0000001300177306ULL, 0x0002e20000202400ULL,
0x000000461c2c723cULL, 0x000fe2000004182cULL, 0x0000541016167816ULL, 0x004fca000000000bULL,
0x0000000e1c24723cULL, 0x000fe20000041824ULL, 0x0000541050137816ULL, 0x002fe4000000000cULL,
0x0000541017177816ULL, 0x008fca000000000aULL, 0x000000121c20723cULL, 0x000fec0000041820ULL,
0x000000161c18723cULL, 0x000fe20000041818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff0002c1947ULL, 0x000fde000383ffffULL, 0x000000ffff037224ULL, 0x000fe200078e0060ULL,
0xffffffd800a88947ULL, 0x000fec000383ffffULL, 0x0000ffff6d037812ULL, 0x000fe200078ec0ffULL,
0x0000000400047824ULL, 0x000fe400078e00ffULL, 0x0000006938057220ULL, 0x080fe20000410000ULL,
0x0000006939397220ULL, 0x080fe20000410000ULL, 0x00008880030b7816ULL, 0x000fe200000000ffULL,
0x0000008066037824ULL, 0x000fe200078e0202ULL, 0xfffffff004047812ULL, 0x000fe200078ec0ffULL,
0x000000693a3a7220ULL, 0x080fe20000410000ULL, 0x000000693b3b7220ULL, 0x000fe20000410000ULL,
0x800000000b0b7824ULL, 0x000fc400078e00ffULL, 0x0000006934347220ULL, 0x080fe20000410000ULL,
0x0000006935357220ULL, 0x080fe20000410000ULL, 0x0000006936367220ULL, 0x080fe20000410000ULL,
0x01c6100b720075a7ULL, 0x000e62000800017fULL, 0x0000006937377220ULL, 0x080fe20000410000ULL,
0x0000006930307220ULL, 0x080fe20000410000ULL, 0x0000006931317220ULL, 0x080fe20000410000ULL,
0x0000006932327220ULL, 0x080fe20000410000ULL, 0x0000006933337220ULL, 0x080fe20000410000ULL,
0x000000692c2c7220ULL, 0x080fe20000410000ULL, 0x000000692d2d7220ULL, 0x080fe20000410000ULL,
0x000000692e2e7220ULL, 0x080fe20000410000ULL, 0x000000692f2f7220ULL, 0x080fe20000410000ULL,
0x0000006928287220ULL, 0x080fe20000410000ULL, 0x0000006929297220ULL, 0x080fe20000410000ULL,
0x000000692a2a7220ULL, 0x080fe20000410000ULL, 0x000000692b2b7220ULL, 0x080fe20000410000ULL,
0x0000006924247220ULL, 0x080fe20000410000ULL, 0x0000006925257220ULL, 0x080fe20000410000ULL,
0x0000006926267220ULL, 0x080fe20000410000ULL, 0x0000006927277220ULL, 0x080fe20000410000ULL,
0x0000006920207220ULL, 0x080fe20000410000ULL, 0x0000006921217220ULL, 0x080fe20000410000ULL,
0x0000006922227220ULL, 0x080fe20000410000ULL, 0x0000006923237220ULL, 0x000fe20000410000ULL,
0x0000000103037824ULL, 0x000fc400078e0204ULL, 0x0000006918187220ULL, 0x080fe20000410000ULL,
0x0000006919197220ULL, 0x080fe20000410000ULL, 0x000000691a1a7220ULL, 0x080fe20000410000ULL,
0x000000691b1b7220ULL, 0x000fe20000410000ULL, 0x0000001800288947ULL, 0x002fec0003800000ULL,
0x01c40000030c7984ULL, 0x0002a20000000c00ULL, 0x0000000468007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x0000000200047824ULL, 0x000fe200078e00ffULL,
0x0000000f71717c10ULL, 0x000fc8000fffe1ffULL, 0x0000000604047812ULL, 0x000fc800078ec0ffULL,
0x0000000104067812ULL, 0x040fe400078efcffULL, 0x0000000804087812ULL, 0x000fe400078efcffULL,
0x000000710600720cULL, 0x080fe40003f26070ULL, 0x0000001004067812ULL, 0x000fe400078efcffULL,
0x000000710800720cULL, 0x080fe40003f06070ULL, 0x000000710600720cULL, 0x000fc40003fc6070ULL,
0x0000001104087812ULL, 0x040fe400078efcffULL, 0x0000001804067812ULL, 0x040fe400078efcffULL,
0x000000710400720cULL, 0x080fe40003f46070ULL, 0x000000710800720cULL, 0x080fe40003fa6070ULL,
0x000000710600720cULL, 0x000fe40003f66070ULL, 0x00000009040a7812ULL, 0x000fc400078efcffULL,
0x0000001904087812ULL, 0x040fe400078efcffULL, 0x0000002004067812ULL, 0x000fe400078efcffULL,
0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL, 0xff7fffff05057808ULL, 0x000fe40005000000ULL,
0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL, 0xff7fffff39397808ULL, 0x000fc40004800000ULL,
0x000000710a00720cULL, 0x080fe40003f86070ULL, 0x000000710800720cULL, 0x080fe40003f46070ULL,
0x000000710600720cULL, 0x000fe40003f26070ULL, 0x0000002104087812ULL, 0x040fe400078efcffULL,
0x0000002804067812ULL, 0x000fe400078efcffULL, 0xff7fffff36367808ULL, 0x000fc40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40004000000ULL, 0xff7fffff37377808ULL, 0x000fe40006000000ULL,
0xff7fffff35357808ULL, 0x000fe40006000000ULL, 0x000000710800720cULL, 0x080fe40003f06070ULL,
0x000000710600720cULL, 0x000fe40003f86070ULL, 0x0000002904087812ULL, 0x000fc400078efcffULL,
0x0000003004067812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fe40007000000ULL,
0xff7fffff30307808ULL, 0x000fe40007000000ULL, 0xff7fffff33337808ULL, 0x000fe40006800000ULL,
0xff7fffff31317808ULL, 0x000fe40006800000ULL, 0x000000710800720cULL, 0x000fc40003fc6070ULL,
0x000000710600720cULL, 0x000fe40003fa6070ULL, 0x0000003104087812ULL, 0x040fe400078efcffULL,
0x0000003804067812ULL, 0x040fe400078efcffULL, 0x0000003904047812ULL, 0x000fe400078efcffULL,
0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff28287808ULL, 0x000fe40004800000ULL,
0x000000710800720cULL, 0x080fe40003f66070ULL, 0x000000710600720cULL, 0x000fc40003f46070ULL,
0x000000710400720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40006000000ULL,
0xff7fffff24247808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fc40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40007000000ULL, 0xff7fffff22227808ULL, 0x000fe40006800000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff23237808ULL, 0x000fe40005800000ULL,
0xff7fffff21217808ULL, 0x000fe40005800000ULL, 0xff7fffff1a1a7808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fce0004800000ULL, 0x000000050c0c7209ULL, 0x004fe20007810000ULL,
0xffffffff00067882ULL, 0x000fe20000000000ULL, 0x0000003a0d047209ULL, 0x000fe40007810000ULL,
0x000000390c0b7209ULL, 0x000fe40007810000ULL, 0x0000003b040d7209ULL, 0x000fe40007810000ULL,
0x000000340b047209ULL, 0x000fe40007810000ULL, 0x000000360d067209ULL, 0x000fc40007810000ULL,
0x00000035040b7209ULL, 0x000fe40007810000ULL, 0x00000037060d7209ULL, 0x000fe40007810000ULL,
0x000000300b047209ULL, 0x000fe40007810000ULL, 0x000000320d067209ULL, 0x000fe40007810000ULL,
0x00000031040b7209ULL, 0x000fe40007810000ULL, 0x00000033060d7209ULL, 0x000fc40007810000ULL,
0x0000002c0b047209ULL, 0x000fe40007810000ULL, 0x0000002e0d067209ULL, 0x000fe40007810000ULL,
0x0000002d040b7209ULL, 0x000fe40007810000ULL, 0x0000002f060d7209ULL, 0x000fe40007810000ULL,
0x000000280b047209ULL, 0x000fe40007810000ULL, 0x0000002a0d067209ULL, 0x000fc40007810000ULL,
0x00000029040b7209ULL, 0x000fe40007810000ULL, 0x0000002b060d7209ULL, 0x000fe40007810000ULL,
0x000000240b047209ULL, 0x000fe40007810000ULL, 0x000000260d067209ULL, 0x000fe40007810000ULL,
0x00000025040b7209ULL, 0x000fe40007810000ULL, 0x00000027060d7209ULL, 0x000fc40007810000ULL,
0x000000200b047209ULL, 0x000fe40007810000ULL, 0x000000220d067209ULL, 0x000fe40007810000ULL,
0x00000021040b7209ULL, 0x000fe40007810000ULL, 0x00000023060d7209ULL, 0x000fe40007810000ULL,
0x000000ff6dff7812ULL, 0x000fe4000780c0ffULL, 0x000000180b047209ULL, 0x000fc40007810000ULL,
0x0000001a0d067209ULL, 0x000fe40007810000ULL, 0x00000001ff6d7807ULL, 0x000fe40000000000ULL,
0x0000001904087209ULL, 0x000fe40007810000ULL, 0x0000001b06067209ULL, 0x000fe20007810000ULL,
0x0000001206a07947ULL, 0x000fec000b800000ULL, 0x0c401f00080b7f89ULL, 0x000e6800000e0000ULL,
0x0c401f00060d7f89ULL, 0x000ea800000e0000ULL, 0x0c401f000e117f89ULL, 0x000ee800000e0000ULL,
0x0c401f000f047f89ULL, 0x000f2200000e0000ULL, 0x0000000b080a7209ULL, 0x002fc40007810000ULL,
0x0000000d06107209ULL, 0x004fc60007810000ULL, 0x0c201f000a0d7f89ULL, 0x000e6200000e0000ULL,
0x000000110e117209ULL, 0x008fc60007810000ULL, 0x0c201f0010137f89ULL, 0x000ea200000e0000ULL,
0x000000040f047209ULL, 0x010fc60007810000ULL, 0x0c201f0011127f89ULL, 0x000ee800000e0000ULL,
0x0c201f00040b7f89ULL, 0x00092200000e0000ULL, 0x0000000d0a0c7209ULL, 0x002fe40007810000ULL,
0x00000013100d7209ULL, 0x004fe40007810000ULL, 0x00000012110e7209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b0c067820ULL, 0x000fe20000410000ULL, 0x3f80000000067882ULL, 0x000fc60000000000ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b05057823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010806ULL,
0x0000002c00167308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010806ULL,
0x0000000500057308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0d2c7820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b20207823ULL, 0x000fe20000010806ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b36367823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b37377823ULL, 0x000fe2000001082cULL, 0x0000003900107308ULL, 0x000e620000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b19067823ULL, 0x000fe20000010806ULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001082cULL, 0x0000003400127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082cULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082cULL,
0x3fb8aa3b1b1b7823ULL, 0x000fe2000001082cULL, 0x000000051010723eULL, 0x002fc400000010ffULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x3fb8aa3b22057823ULL, 0x000fce000001082cULL,
0x0000003a00117308ULL, 0x000fe20000000800ULL, 0x000000123512723eULL, 0x002fce00000010ffULL,
0x0000003b001c7308ULL, 0x000e700000000800ULL, 0x0000003600137308ULL, 0x000fe20000000800ULL,
0x000000111c11723eULL, 0x002fce00000010ffULL, 0x00000037001e7308ULL, 0x000e700000000800ULL,
0x00000018000a7308ULL, 0x0005e20000000800ULL, 0x000000131e13723eULL, 0x002fce00000010ffULL,
0x0000002000087308ULL, 0x000fe20000000800ULL, 0x00000006ff187e24ULL, 0x004fca000f8e00ffULL,
0x3f8000001818783eULL, 0x000fe400000010ffULL, 0x0000000600397308ULL, 0x000fe60000000800ULL,
0x000000ffff197224ULL, 0x000fca00078e0018ULL, 0x0000003000147308ULL, 0x000fe20000000800ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00000018101c723cULL, 0x000fe400000418ffULL,
0x0000003100317308ULL, 0x000e700000000800ULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x000000143114723eULL, 0x002fce00000010ffULL, 0x0000003200157308ULL, 0x000fe20000000800ULL,
0x000000162d16723eULL, 0x004fce00000010ffULL, 0x0000003300067308ULL, 0x000e700000000800ULL,
0x0000002e00177308ULL, 0x000fe20000000800ULL, 0x000000150615723eULL, 0x002fce00000010ffULL,
0x0000002f00207308ULL, 0x000e620000000800ULL, 0x3fb8aa3b23067823ULL, 0x000fce000001082cULL,
0x00000021000f7308ULL, 0x000fe20000000800ULL, 0x000000172017723eULL, 0x002fce00000010ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x00000018141c723cULL, 0x000fee000004181cULL,
0x0000002900297308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000282920723eULL, 0x002fce00000010ffULL, 0x0000002500257308ULL, 0x000e700000000800ULL,
0x0000002a00217308ULL, 0x000fe20000000800ULL, 0x000000242522723eULL, 0x002fce00000010ffULL,
0x0000002b00307308ULL, 0x000e620000000800ULL, 0x000000080f24723eULL, 0x000fe400000010ffULL,
0x0000000b040f7209ULL, 0x010fca0007810000ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000213021723eULL, 0x002fce00000010ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000000500057308ULL, 0x000fe20000000800ULL, 0x000000262723723eULL, 0x002fce00000010ffULL,
0x0000000600067308ULL, 0x000e620000000800ULL, 0x0000000a3926723eULL, 0x000fe200000010ffULL,
0x00000018201c723cULL, 0x000fec000004181cULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000050625723eULL, 0x002fce00000010ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000fff067424ULL, 0x000fe200078e00ffULL, 0xfffffffc00057812ULL, 0x000fc800078ec0ffULL,
0x0000000506057219ULL, 0x000fe400000006ffULL, 0x0000001a1b27723eULL, 0x002fce00000010ffULL,
0x00000018241c723cULL, 0x000fde000004181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x001c1fff1c187589ULL, 0x00026200000e0000ULL, 0x0000000000087806ULL, 0x000fe200038e0100ULL,
0x00000000050673a1ULL, 0x000eb000000e8000ULL, 0x00000000050673c4ULL, 0x000ee20000004000ULL,
0x0000000000077886ULL, 0x000fc400038e0100ULL, 0x0000000705ff7c12ULL, 0x004fda000f804006ULL,
0x0000000e06ac8947ULL, 0x00afea000b800000ULL, 0x001c1fff1e197589ULL, 0x0002a800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x000ee800000e0000ULL, 0x001c1fff001b7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff097812ULL, 0x000fe200078ee209ULL, 0x0000080066087824ULL, 0x000fe200078e0202ULL,
0x0000000307077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0010ULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000809067836ULL, 0x000fe20000000000ULL,
0x00000004070b7812ULL, 0x000fe200078efcffULL, 0x0000000809047824ULL, 0x000fe200078e00ffULL,
0x0000000707057812ULL, 0x002fe200078e7809ULL, 0x0001200008087836ULL, 0x000fe20000000000ULL,
0x000000070b097812ULL, 0x000fe200078e7809ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0012ULL,
0x0000000707077812ULL, 0x000fe200078e7806ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0014ULL,
0x000000070b0b7812ULL, 0x000fe200078e7806ULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0x0000000405057212ULL, 0x080fe200078efcffULL, 0x000000ffff1f7224ULL, 0x000fe200078e0016ULL,
0x0000000409097212ULL, 0x000fe200078efcffULL, 0x000000ffff287224ULL, 0x000fe200078e0020ULL,
0x0000000607077212ULL, 0x080fe200078efcffULL, 0x0000001005057824ULL, 0x100fe200078e0208ULL,
0x000000060b0b7212ULL, 0x000fe200078efcffULL, 0x0000001009097824ULL, 0x000fc400078e0208ULL,
0x000000ffff297224ULL, 0x000fe200078e0022ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000001c05007844ULL, 0x0003e20000000200ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0024ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0026ULL, 0x0000001007077824ULL, 0x000fc400078e0208ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0011ULL, 0x0000002809007844ULL, 0x0003e20000000200ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0013ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0015ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0017ULL, 0x000000100b0b7824ULL, 0x000fe400078e0208ULL,
0x000000ffff147224ULL, 0x000fe200078e0021ULL, 0x0000002c07007844ULL, 0x0003e20000000200ULL,
0x000000ffff157224ULL, 0x000fc400078e0023ULL, 0x000000ffff167224ULL, 0x000fe400078e0025ULL,
0x000000ffff177224ULL, 0x000fe400078e0027ULL, 0x0000000167687824ULL, 0x000fe400078e0268ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x000000140b007844ULL, 0x0003e80000000200ULL,
0x01c0000c03008388ULL, 0x0003e80000000c00ULL, 0x01c2001803008388ULL, 0x01c3e20000000c00ULL,
0x0000000568007c0cULL, 0x000fe2000bf06070ULL, 0x01c6081172ff79a7ULL, 0x0003d8000850003fULL,
0xffffffc400648947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff137224ULL, 0x000fce00078e0012ULL, 0x0000000eff077e24ULL, 0x000fc8000f8e00ffULL,
0x01c65813070075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c65813070095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xfffffed400b87947ULL, 0x000fea000383ffffULL,
0x000000ffff0b7224ULL, 0x000fce00078e000aULL, 0x0000000eff097e24ULL, 0x000fc8000f8e00ffULL,
0x01c6080b090075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x01c6080b0900a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00e8a947ULL, 0x002fea000383ffffULL, 0xfffffed800c87947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x100fe400078e0011ULL, 0x000000ffff0f7224ULL, 0x000fce00078e0011ULL,
0x00000008ff0b7e24ULL, 0x000fc8000f8e00ffULL, 0x0000000f0b0075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0000000f0b0095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xfffffedc00c47947ULL, 0x004fea000383ffffULL, 0x000000ffff327224ULL, 0x100fe400078e0009ULL,
0x000000ffff337224ULL, 0x000fce00078e0009ULL, 0x0000000eff3d7e24ULL, 0x000fc8000f8e00ffULL,
0x01c658333d0075a7ULL, 0x000262000806017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000b95dULL, 0x000fea0003900000ULL, 0x01c658333d00b5a7ULL, 0x000e64000806007fULL,
0xfffffffc00e8b947ULL, 0x002fea000383ffffULL, 0xffffff0000747947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x100fe400078e0002ULL, 0x000000ffff0d7224ULL, 0x000fce00078e0002ULL,
0x0000000eff057e24ULL, 0x000fc8000f8e00ffULL, 0x01c6180d050075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x01c6180d0500a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00e8a947ULL, 0x002fea000383ffffULL,
0xffffff0000f07947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x100fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fce00078e000eULL, 0x00000004ff0f7e24ULL, 0x000fc8000f8e00ffULL,
0x01c6480d0f0075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c6480d0f0095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff0400d07947ULL, 0x000fea000383ffffULL,
0x000000ffff247224ULL, 0x100fe400078e000aULL, 0x000000ffff257224ULL, 0x000fce00078e000aULL,
0x0000000eff277e24ULL, 0x000fc8000f8e00ffULL, 0x01c65825270075a7ULL, 0x000262000808017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000c95dULL, 0x000fea0003900000ULL,
0x01c658252700c5a7ULL, 0x000e64000808007fULL, 0xfffffffc00e8c947ULL, 0x002fea000383ffffULL,
0xffffff2400787947ULL, 0x000fea000383ffffULL, 0x000000ffff057224ULL, 0x004fce00078e0004ULL,
0x0000000eff0d7e24ULL, 0x000fc8000f8e00ffULL, 0x01c628050d0075a7ULL, 0x000262000806017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000b95dULL, 0x000fea0003900000ULL,
0x01c628050d00b5a7ULL, 0x000e64000806007fULL, 0xfffffffc00e8b947ULL, 0x002fea000383ffffULL,
0xffffff2800687947ULL, 0x000fea000383ffffULL, 0x000000ffff047224ULL, 0x100fe400078e0012ULL,
0x000000ffff057224ULL, 0x000fce00078e0012ULL, 0x00000004ff0d7e24ULL, 0x000fc8000f8e00ffULL,
0x01c648050d0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c648050d0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffff2c00447947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x100fe400078e0009ULL, 0x000000ffff0d7224ULL, 0x000fce00078e0009ULL,
0x0000000eff057e24ULL, 0x000fc8000f8e00ffULL, 0x01c6580d050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c6580d050085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffff4800c47947ULL, 0x000fea000383ffffULL, 0x000000ffff057224ULL, 0x008fce00078e0004ULL,
0x0000000eff037e24ULL, 0x000fc8000f8e00ffULL, 0x01c63805030075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x01c638050300a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00e8a947ULL, 0x002fea000383ffffULL,
0xffffff4c00c47947ULL, 0x000fea000383ffffULL, 0x000000ffff047224ULL, 0x100fe400078e0024ULL,
0x000000ffff057224ULL, 0x000fce00078e0024ULL, 0x00000006ff077e24ULL, 0x000fc8000f8e00ffULL,
0x01c64805070075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c64805070085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffff50009c7947ULL, 0x004fea000383ffffULL,
0x01c600ff020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c600ff020085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffb800d07947ULL, 0x020fea000383ffffULL,
0x80000000ff047424ULL, 0x000fe400078e00ffULL, 0x80000000ff057424ULL, 0x002fc800078e00ffULL,
0x01c60005020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c60005020085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e48947ULL, 0x002fea000383ffffULL, 0xffffffbc00707947ULL, 0x020fea000383ffffULL,
0x000000ffff0a7224ULL, 0x000fce00078e000bULL, 0x01c6100b720075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c6100b720085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffe400bc7947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x000fe400078e0008ULL, 0x00000002ff147424ULL, 0x000fe400078e00ffULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1c7424ULL, 0x000fce00078e00ffULL,
0x000000001c087348ULL, 0x000fea0003c00000ULL, 0x0c000014150c7389ULL, 0x0006e40000000017ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff157224ULL, 0x002fe400078e0006ULL, 0x00000002ff147424ULL, 0x000fe400078e00ffULL,
0x0000001fff177424ULL, 0x000fe400078e00ffULL, 0xffffffffff1c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x004fce00078e000cULL, 0x000000001c087348ULL, 0x000fea0003c00000ULL,
0x0c000014150c7389ULL, 0x0002640000000017ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000b080a7209ULL, 0x000fe20007810000ULL, 0x000000ffff157224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fce00078e000cULL, 0x000000001c087348ULL, 0x000fea0003c00000ULL,
0x0c000014150c7389ULL, 0x0002640000000017ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000d06107209ULL, 0x000fe20007810000ULL, 0x000000ffff157224ULL, 0x000fe400078e000fULL,
0x000000ffff117224ULL, 0x000fce00078e000cULL, 0x000000001c087348ULL, 0x000fea0003c00000ULL,
0x0c000014150c7389ULL, 0x0002640000000017ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000110e117209ULL, 0x000fe20007810000ULL, 0x000000ffff157224ULL, 0x000fe400078e000aULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x000000ffff047224ULL, 0x000fce00078e000cULL,
0x000000001c087348ULL, 0x000fea0003c00000ULL, 0x0c000014150c7389ULL, 0x0002640000000017ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000040f047209ULL, 0x000fe20007810000ULL,
0x000000ffff157224ULL, 0x000fe400078e0010ULL, 0x000000ffff0d7224ULL, 0x000fce00078e000cULL,
0x000000001c087348ULL, 0x000fea0003c00000ULL, 0x0c000014150c7389ULL, 0x0002640000000017ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000ffff157224ULL, 0x000fe400078e0011ULL,
0x000000ffff137224ULL, 0x000fce00078e000cULL, 0x000000001c087348ULL, 0x000fea0003c00000ULL,
0x0c000014150c7389ULL, 0x0002640000000017ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000ffff157224ULL, 0x000fe400078e0004ULL, 0x000000ffff127224ULL, 0x000fce00078e000cULL,
0x000000001c087348ULL, 0x000fea0003c00000ULL, 0x0c000014150c7389ULL, 0x0002640000000017ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x00000012110e7209ULL, 0x000fe20007810000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000cULL, 0x0000000d0a0c7209ULL, 0x000fe40007810000ULL,
0x00000013100d7209ULL, 0x000fe20007810000ULL, 0xffffffe800b87947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x000fce00078e0005ULL,
0x000000001c087348ULL, 0x000fea0003c00000ULL, 0x0000001b1e1b7389ULL, 0x0006e4000000000bULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff197224ULL, 0x004fe400078e001bULL,
0x000000ffff1e7224ULL, 0x002fe400078e001aULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x000fce00078e0005ULL,
0x000000001c087348ULL, 0x000fea0003c00000ULL, 0x0000001b1e1b7389ULL, 0x0006e4000000000bULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x004fe400078e001bULL,
0x000000ffff1e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x000fce00078e0005ULL,
0x000000001c087348ULL, 0x000fea0003c00000ULL, 0x0000001b1e1b7389ULL, 0x0006e4000000000bULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffec00ec7947ULL, 0x006fea000383ffffULL, 0x018000003c027836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000003c00028308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff3cff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x800000003c037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000003c00027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0009ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffeb002107950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL, 0x0000000e00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000630ULL, 0x0000000000000048ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000678ULL, 0x00000000000006a0ULL, 0x0000000d00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d18ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d38ULL, 0x0000000000000000ULL, 0x0000000d00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d38ULL, 0x0000000000000030ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d68ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000db0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000015080ULL, 0x0000000e00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015e80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000015e90ULL, 0x0000000000000400ULL, 0x0000000d00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015e90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000015e90ULL, 0x0000000000000260ULL, 0x0000000d00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000016570ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016570ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000db0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000e00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015080ULL,
0x0000000000015080ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000015e80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL, 0x0000000000000414ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015e90ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_90_cubin_len = 91840;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
