/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001ee90ULL, 0x000000000001ea10ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000001d340ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x000000000001d4d0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000001d510ULL, 0x00000000000000f0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000001d600ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001d34000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x0074300400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080840828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808089920000ULL, 0x0000000000000022ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001d34000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8087288080840900ULL, 0x0900000004042880ULL, 0x2880808428808089ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9808288080960828ULL, 0x288080c008288080ULL,
0x8280162880808808ULL, 0x0000000003102880ULL, 0x8080889200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000010800000000ULL, 0x0001d4d000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9608288080880828ULL,
0x2880809808288080ULL, 0x809e08288080c008ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x22002880809e9200ULL, 0x0000001cffffffffULL, 0x0000019000000000ULL, 0x0001d51000000000ULL,
0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000f1ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL, 0x0050190300500160ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0018310400ff1b03ULL, 0x0001c7600001c520ULL, 0x0001c8e00001c770ULL, 0x0001c9000001c8f0ULL,
0xffffffff01082904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001dffffffffULL, 0x0500001d0500001dULL, 0xffffffff0500001dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01082804ffffffffULL, 0x0000023000000090ULL, 0x000015f000001560ULL,
0x0000169000001660ULL, 0x00002dd000002da0ULL, 0x00004ea000004d40ULL, 0x0000631000006290ULL,
0x000063c000006390ULL, 0x0000799000007970ULL, 0x000098a000009840ULL, 0x0000adb00000ad30ULL,
0x0000ae600000ae30ULL, 0x0000c3d00000c3a0ULL, 0x0000e3400000e2e0ULL, 0x0000f8300000f7b0ULL,
0x0000f8e00000f8b0ULL, 0x00010e3000010b60ULL, 0x00012db000012da0ULL, 0x000140b0000140a0ULL,
0x000164d000014830ULL, 0x00016cb000016620ULL, 0x0001752000016ce0ULL, 0x0001c1b00001c180ULL,
0x0001c1d00001c1c0ULL, 0x0001c2100001c1f0ULL, 0x0001c2400001c230ULL, 0x0001c9300001c8d0ULL,
0x0001c9500001c940ULL, 0x0001cfd00001cf70ULL, 0x0001d0700001d020ULL, 0x0001d1100001d0c0ULL,
0x0001d1b00001d160ULL, 0x0001d2800001d210ULL, 0x0001d3200001d2d0ULL, 0x0000015005e03904ULL,
0x00010600000000ffULL, 0x00000180003f0100ULL, 0x000106080000000fULL, 0x000001b0003f0130ULL,
0x000106100000000fULL, 0x00000210003f0130ULL, 0x000106480000000fULL, 0x00000220003f0120ULL,
0x00010658000000ffULL, 0x000005a0003f0100ULL, 0x00010600000000ffULL, 0x00000820003f0107ULL,
0x0000000400000000ULL, 0x00000a90003f0102ULL, 0x0000000000000000ULL, 0x00000c20003f0101ULL,
0x00010648000000ffULL, 0x00000cd0003f0107ULL, 0x00010658000000ffULL, 0x00000e10003f0101ULL,
0x0001065c000000ffULL, 0x00000e60003f0106ULL, 0x0001065c000000ffULL, 0x00000ee0003f0106ULL,
0x0001065c000000ffULL, 0x00001310003f0106ULL, 0x00010650000000ffULL, 0x00001380003f0107ULL,
0x0001064c000000ffULL, 0x000013a0003f0106ULL, 0x0001060c000000ffULL, 0x000014a0003f0106ULL,
0x0001060c000000ffULL, 0x00001900003f0106ULL, 0x0001064c000000ffULL, 0x000019a0003f0106ULL,
0x0001064c000000ffULL, 0x00003930003f0106ULL, 0x00010658000000ffULL, 0x00003940003f0101ULL,
0x0001065c000000ffULL, 0x00003980003f0106ULL, 0x0001065c000000ffULL, 0x00003a00003f0106ULL,
0x0001065c000000ffULL, 0x00003cc0003f0106ULL, 0x00010648000000ffULL, 0x00003d30003f0107ULL,
0x00010654000000ffULL, 0x00003da0003f0106ULL, 0x00010654000000ffULL, 0x00003e40003f0106ULL,
0x00010654000000ffULL, 0x00005ca0003f0106ULL, 0x00010658000000ffULL, 0x00005d10003f0101ULL,
0x00010610000000ffULL, 0x00005d60003f0101ULL, 0x0001065c000000ffULL, 0x00005da0003f0106ULL,
0x0001065c000000ffULL, 0x00005e20003f0106ULL, 0x0001065c000000ffULL, 0x000060a0003f0106ULL,
0x00010650000000ffULL, 0x00006110003f0107ULL, 0x0001064c000000ffULL, 0x00006130003f0106ULL,
0x0001061c000000ffULL, 0x00006210003f0106ULL, 0x0001061c000000ffULL, 0x00006620003f0106ULL,
0x0001064c000000ffULL, 0x000066c0003f0106ULL, 0x0001064c000000ffULL, 0x000084d0003f0106ULL,
0x00010658000000ffULL, 0x000084e0003f0101ULL, 0x0001065c000000ffULL, 0x00008520003f0106ULL,
0x0001065c000000ffULL, 0x000085a0003f0106ULL, 0x0001065c000000ffULL, 0x00008820003f0106ULL,
0x00010648000000ffULL, 0x00008890003f0107ULL, 0x00010654000000ffULL, 0x000088e0003f0106ULL,
0x00010654000000ffULL, 0x00008970003f0106ULL, 0x00010654000000ffULL, 0x0000a740003f0106ULL,
0x00010658000000ffULL, 0x0000a7b0003f0101ULL, 0x00010620000000ffULL, 0x0000a800003f0101ULL,
0x0001065c000000ffULL, 0x0000a840003f0106ULL, 0x0001065c000000ffULL, 0x0000a8c0003f0106ULL,
0x0001065c000000ffULL, 0x0000ab40003f0106ULL, 0x00010650000000ffULL, 0x0000abb0003f0107ULL,
0x0001064c000000ffULL, 0x0000abd0003f0106ULL, 0x0001062c000000ffULL, 0x0000acb0003f0106ULL,
0x0001062c000000ffULL, 0x0000b0c0003f0106ULL, 0x0001064c000000ffULL, 0x0000b160003f0106ULL,
0x0001064c000000ffULL, 0x0000cf70003f0106ULL, 0x00010658000000ffULL, 0x0000cf80003f0101ULL,
0x0001065c000000ffULL, 0x0000cfc0003f0106ULL, 0x0001065c000000ffULL, 0x0000d040003f0106ULL,
0x0001065c000000ffULL, 0x0000d2c0003f0106ULL, 0x00010648000000ffULL, 0x0000d330003f0107ULL,
0x00010654000000ffULL, 0x0000d380003f0106ULL, 0x00010654000000ffULL, 0x0000d410003f0106ULL,
0x00010654000000ffULL, 0x0000f1e0003f0106ULL, 0x00010658000000ffULL, 0x0000f250003f0101ULL,
0x00010630000000ffULL, 0x0000f2a0003f0101ULL, 0x0001065c000000ffULL, 0x0000f2e0003f0106ULL,
0x0001065c000000ffULL, 0x0000f360003f0106ULL, 0x0001065c000000ffULL, 0x0000f5e0003f0106ULL,
0x00010650000000ffULL, 0x0000f650003f0107ULL, 0x0001064c000000ffULL, 0x0000f670003f0106ULL,
0x0001063c000000ffULL, 0x0000f730003f0106ULL, 0x0001063c000000ffULL, 0x0000fb40003f0106ULL,
0x0001064c000000ffULL, 0x0000fbe0003f0106ULL, 0x0001064c000000ffULL, 0x000119e0003f0106ULL,
0x00010658000000ffULL, 0x000119f0003f0101ULL, 0x0001065c000000ffULL, 0x00011a30003f0106ULL,
0x0001065c000000ffULL, 0x00011ab0003f0106ULL, 0x0001065c000000ffULL, 0x00011d60003f0106ULL,
0x00010648000000ffULL, 0x00011dd0003f0107ULL, 0x00010654000000ffULL, 0x00011e20003f0106ULL,
0x00010654000000ffULL, 0x00011eb0003f0106ULL, 0x00010654000000ffULL, 0x00013ca0003f0106ULL,
0x00010658000000ffULL, 0x00013d00003f0101ULL, 0x00010640000000ffULL, 0x00018500003f0101ULL,
0x00010604000000ffULL, 0x00018590003f0106ULL, 0x00010604000000ffULL, 0x000188c0003f0106ULL,
0x00010600000000ffULL, 0x000188d0003f0101ULL, 0x00010604000000ffULL, 0x00018950003f0106ULL,
0x00010604000000ffULL, 0x0001b590003f0106ULL, 0x000106140000003aULL, 0x0001ba60003f0106ULL,
0x000106140000003aULL, 0x0001ced0003f0106ULL, 0x000106080000003aULL, 0x00053803003f0101ULL,
0x0001798000101c04ULL, 0x00018a40000189a0ULL, 0x000004010001cf30ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000204ULL, 0x0000001100000002ULL, 0x000000000000017cULL, 0x0000001100000002ULL,
0x00000000000000dcULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001e1ULL, 0x0000001100000002ULL, 0x0000000000000154ULL, 0x0000001100000002ULL,
0x00000000000000b2ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002300ULL,
0x00000004ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000d7919ULL, 0x000ea80000002100ULL,
0x0000000000277919ULL, 0x000ee80000002700ULL, 0x0000000000127919ULL, 0x000f220000002600ULL,
0x000000010e007824ULL, 0x002fc600078e0203ULL, 0x00001fff0e0e7589ULL, 0x000e6200000e0000ULL,
0x00000080000f7824ULL, 0x104fe200078e020dULL, 0x00000005ff007819ULL, 0x000fe2000001160dULL,
0x00006000270c7625ULL, 0x008fc600078e000cULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe40003f04070ULL, 0x0000007f0f00780cULL, 0x040fe40003f24070ULL,
0x000000010f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01060002ff00b388ULL, 0x0005e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x010608040f008388ULL, 0x0005e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff08a424ULL, 0x000fe200078e00ffULL, 0x010610060f008388ULL, 0x0005e2000000ca00ULL,
0x000000ff0e00720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff09a424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0ab424ULL, 0x000fe200078e00ffULL, 0x010400100f009388ULL, 0x0005e20000004800ULL,
0x7fffff80ff0bb424ULL, 0x000fc600078e00ffULL, 0x010648080f00a388ULL, 0x0005e80000008a00ULL,
0x0106580aff00b388ULL, 0x0005e80000000a00ULL, 0x00001fff00027589ULL, 0x00046800000e0000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003b000000947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x014ea20000000000ULL, 0x00005800ff007624ULL, 0x000fc400078e00ffULL,
0x0000000402047824ULL, 0x002fe400078e00ffULL, 0x0000001012037824ULL, 0x000fe400078e00ffULL,
0x0000001000007824ULL, 0x000fe400078e00ffULL, 0x00000200ff147424ULL, 0x000fe400078e00ffULL,
0x0000002700007224ULL, 0x000fe200078e0203ULL, 0x000000040f057211ULL, 0x004fc800078fd8ffULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0000000205097810ULL, 0x040fe40007ffe0ffULL,
0x0000000305117810ULL, 0x040fe40007ffe0ffULL, 0x0000000705037812ULL, 0x000fe400078ec0ffULL,
0x0000000707067812ULL, 0x000fe400078ec0ffULL, 0x0000000709087812ULL, 0x000fc400078ec0ffULL,
0x00000007110b7812ULL, 0x000fe400078ec0ffULL, 0x0000001f03047812ULL, 0x100fe200078e780fULL,
0x000000100f037824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x100fe400078e780fULL,
0x0000001f080a7812ULL, 0x000fe200078e780fULL, 0x0000000100087824ULL, 0x040fe200078e0209ULL,
0x0000001f0b107812ULL, 0x000fe200078e780fULL, 0x00000020050f7824ULL, 0x000fe200078e0204ULL,
0x000001f003137812ULL, 0x000fe200078ec0ffULL, 0x0000000100057824ULL, 0x000fc400078e0205ULL,
0x0000002007037824ULL, 0x000fe400078e0206ULL, 0x00005c0005047625ULL, 0x000fc800078e0014ULL,
0x0000000100077824ULL, 0x000fe200078e0207ULL, 0x0000001304047210ULL, 0x000fe20007f1e0ffULL,
0x00000001000b7824ULL, 0x000fe400078e0211ULL, 0x0000002009007824ULL, 0x000fe400078e020aULL,
0x00005c0007067625ULL, 0x000fc800078e0014ULL, 0x00005c0008087625ULL, 0x000fe200078e0014ULL,
0x0000001306067210ULL, 0x000fc60007f3e0ffULL, 0x00005c000b0a7625ULL, 0x000fc800078e0014ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000001308087210ULL, 0x080fe20007f1e0ffULL,
0x0000002011107824ULL, 0x000fe200078e0210ULL, 0x000000130a0a7210ULL, 0x000fe20007f5e0ffULL,
0x000000100f0f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400008e0607ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fc400000e0609ULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000006037faeULL, 0x0003e2000b901c46ULL,
0x000000ffff0b7224ULL, 0x000fe400010e060bULL, 0x0000001010137824ULL, 0x000fe200078e00ffULL,
0x0000000008117faeULL, 0x0003e8000b901c46ULL, 0x000000000a137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000060c037981ULL, 0x016ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x00000004ff247e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff03257810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff257819ULL, 0x000fce0000011625ULL, 0x0001731000008947ULL, 0x000fea0003800000ULL,
0x0000000000267919ULL, 0x000e620000000000ULL, 0x0000010024047824ULL, 0x000fe200078e00ffULL,
0x0000580012007a10ULL, 0x000fe20007ffe0ffULL, 0x0000000227277824ULL, 0x000fe200078e00ffULL,
0x0000000124067810ULL, 0x000fe20007ffe0ffULL, 0x00000003ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000403057217ULL, 0x000fe20007800000ULL, 0x0000580027277a24ULL, 0x000fe200078e0200ULL,
0x000000250600720cULL, 0x000fe20003f06070ULL, 0x00000008022c7824ULL, 0x040fe200078e00ffULL,
0x0001061002007811ULL, 0x000fe200078e20ffULL, 0x0000000105057824ULL, 0x000fe200078e0a04ULL,
0x00000004ff087819ULL, 0x002fe20000011626ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000012c097824ULL, 0x000fe200078e0208ULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x0000620027067a24ULL, 0x000fe200078e0204ULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff137424ULL, 0x000fe200078e00ffULL, 0x0000000709077812ULL, 0x000fe200078ec0ffULL,
0x0000001026117824ULL, 0x000fe200078e00ffULL, 0x0000002c05057217ULL, 0x000fe20007800000ULL,
0x0000040d00ff738cULL, 0x0003e20000000000ULL, 0x0000000f07047812ULL, 0x000fc400078e7826ULL,
0x00000004080b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105077824ULL, 0x000fe200078e0a2cULL,
0x000000f011117812ULL, 0x000fe200078ec0ffULL, 0x00000010090c7824ULL, 0x000fe400078e0204ULL,
0x0000000106047824ULL, 0x000fe200078e0209ULL, 0x000000070800720cULL, 0x000fe20003f66070ULL,
0x000000012c097824ULL, 0x000fe200078e020aULL, 0x0000000608087810ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0013ULL, 0x000000070a00720cULL, 0x000fc40003f46070ULL,
0x000000070b00720cULL, 0x080fe20003f26070ULL, 0x000000012c0d7824ULL, 0x002fe200078e020bULL,
0x000000070800720cULL, 0x000fe20003f06070ULL, 0x000000012c0f7824ULL, 0x000fe200078e0208ULL,
0x00000011040a7210ULL, 0x000fe40007f9e0ffULL, 0x0000000709077812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e0605ULL, 0x0000000f07047812ULL, 0x000fe400078e7826ULL,
0x000000070d057812ULL, 0x000fe400078ec0ffULL, 0x000000070f077812ULL, 0x000fe200078ec0ffULL,
0x00000010090e7824ULL, 0x000fe200078e0204ULL, 0x0000000f05087812ULL, 0x100fe200078e7826ULL,
0x0000000106047824ULL, 0x040fe200078e0209ULL, 0x0000000f07127812ULL, 0x000fe200078e7826ULL,
0x0000000106077824ULL, 0x000fc400078e020dULL, 0x0000000106097824ULL, 0x000fe400078e020fULL,
0x000000100d107824ULL, 0x000fe400078e0208ULL, 0x000000100f127824ULL, 0x000fe400078e0212ULL,
0x00005e0004047625ULL, 0x000fc800078e0013ULL, 0x00005e0007067625ULL, 0x000fc800078e0013ULL,
0x00005e0009087625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000001104047210ULL, 0x080fe20007f9e0ffULL, 0x0000000000ff7f8cULL, 0x0003e2000c80043fULL,
0x0000001106067210ULL, 0x080fe20007fbe0ffULL, 0xff317217ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000001108087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000c0000c0d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000c0000e0f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000c00010117811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0005e2000d901c46ULL, 0x0000c00012137811ULL, 0x000fe200078e20ffULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000040f7faeULL, 0x0007e2000d101c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000006117faeULL, 0x0009e2000c901c46ULL, 0x000000252400720cULL, 0x000fc60003f26070ULL,
0x0000000008137faeULL, 0x000be2000c101c46ULL, 0x000000ffff0d7224ULL, 0x004fc600078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000e7805ULL, 0x008fc6000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000107805ULL, 0x010fe2000001ff00ULL,
0x0000000000127805ULL, 0x020fe4000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0001301000001947ULL, 0x000fea0003800000ULL,
0x00000004022f7824ULL, 0x000fe200078e00ffULL, 0x00007610ff647816ULL, 0x000fe20000000064ULL,
0xff317217ff2d7424ULL, 0x000fe200078e00ffULL, 0x00007610ff307816ULL, 0x000fe20000000030ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x000000022f317810ULL, 0x000fc40007ffe0ffULL,
0x0000010024007824ULL, 0x000fca00078e00ffULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x00012f2000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000761064537816ULL, 0x000fe20000000053ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01065c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000002024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff437424ULL, 0x000fe200078e00ffULL,
0x00000004ff417819ULL, 0x000fe20000011626ULL, 0x00000010263e7824ULL, 0x000fe200078e00ffULL,
0x0000000003297217ULL, 0x000fe20007800000ULL, 0x00006200273b7a24ULL, 0x100fe200078e0200ULL,
0x0000000124287810ULL, 0x000fe20007ffe0ffULL, 0x000000012c337824ULL, 0x000fe200078e0241ULL,
0x0000000241357810ULL, 0x000fe20007ffe0ffULL, 0x0000000129297824ULL, 0x000fe200078e0a00ULL,
0x0000000441377810ULL, 0x000fc40007ffe0ffULL, 0x000000252800720cULL, 0x000fe20003f06070ULL,
0x000000012c367824ULL, 0x040fe200078e0235ULL, 0x0000000641397810ULL, 0x000fe20007ffe0ffULL,
0x000000012c387824ULL, 0x000fe200078e0237ULL, 0x00000020292b7807ULL, 0x000fe20000000000ULL,
0x0000000133287824ULL, 0x100fe200078e023bULL, 0x000000f03e347812ULL, 0x000fe200078ec0ffULL,
0x00000001362a7824ULL, 0x100fe200078e023bULL, 0x0000002b2c3f7217ULL, 0x000fe20007800000ULL,
0x00000001383c7824ULL, 0x000fe400078e023bULL, 0x00005e0028287625ULL, 0x000fc800078e0043ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0043ULL, 0x0000003428447210ULL, 0x000fc60007f3e0ffULL,
0x00005e003c3c7625ULL, 0x000fe200078e0043ULL, 0x000000342a2a7210ULL, 0x000fc60007f5e0ffULL,
0x000000012c3a7824ULL, 0x000fe200078e0239ULL, 0x000000343c467210ULL, 0x000fe20007f7e0ffULL,
0x000000013f007824ULL, 0x000fe400078e0a2cULL, 0x000000013a287824ULL, 0x000fe200078e023bULL,
0x00000007333b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff457224ULL, 0x000fe200008e0629ULL,
0x000000004100720cULL, 0x080fe20003f26070ULL, 0x000000ffff2b7224ULL, 0x000fe200010e062bULL,
0x000000003500720cULL, 0x080fe20003f46070ULL, 0x000000ffff477224ULL, 0x000fe200018e063dULL,
0x000000003700720cULL, 0x080fe20003f66070ULL, 0x00005e0028287625ULL, 0x000fe200078e0043ULL,
0x000000003900720cULL, 0x000fc40003f86070ULL, 0x00000007363d7812ULL, 0x000fe400078ec0ffULL,
0x0000000f3b007812ULL, 0x000fe400078e7826ULL, 0x00000007383b7812ULL, 0x000fe400078ec0ffULL,
0x000000073a3f7812ULL, 0x000fe200078ec0ffULL, 0x00000010334b7824ULL, 0x000fe200078e0200ULL,
0x0000000f3d3d7812ULL, 0x100fe400078e7826ULL, 0x0000000f3b3b7812ULL, 0x000fc400078e7826ULL,
0x0000000f3f417812ULL, 0x000fe200078e7826ULL, 0x00000010365d7824ULL, 0x000fe200078e023dULL,
0x0000003428287210ULL, 0x000fe20007fbe0ffULL, 0x00000010385c7824ULL, 0x000fe200078e023bULL,
0x0000e0004b3f7811ULL, 0x000fe200078e20ffULL, 0x000000103a3d7824ULL, 0x000fe200078e0241ULL,
0x0000e0005d407811ULL, 0x000fe200078e20ffULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x0000e0005c417811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000443f7faeULL, 0x0003e2000c901c46ULL, 0x0000e0003d427811ULL, 0x000fc600078e20ffULL,
0x000000002a407faeULL, 0x0003e8000d101c46ULL, 0x0000000046417faeULL, 0x0003e8000d901c46ULL,
0x0000000028427faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff297984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff2b7984ULL, 0x000ea20000000800ULL, 0x0000ffff64007812ULL, 0x000fc400078ec0ffULL,
0x0000ffff30287812ULL, 0x000fe400078ec0ffULL, 0x00008880003b7816ULL, 0x000fe400000000ffULL,
0x0000888028437816ULL, 0x000fc600000000ffULL, 0x800000003b007824ULL, 0x000fe400078e00ffULL,
0x8000000043287824ULL, 0x000fc600078e00ffULL, 0x8000000029ff7812ULL, 0x002fe40007824800ULL,
0x800000002bff7812ULL, 0x004fe20007844828ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000043297824ULL, 0x000fe400078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01060c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc40007844829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff007819ULL, 0x000fe20000011626ULL, 0x00000001ffa57424ULL, 0x000fe200078e00ffULL,
0x000000703e447812ULL, 0x000fe400078ec0ffULL, 0x0000000c00297812ULL, 0x000fca00078ec0ffULL,
0x0000000144447824ULL, 0x000fca00078e0229ULL, 0x0100000044007984ULL, 0x000e680000000800ULL,
0x0102000044297984ULL, 0x0004e20000000800ULL, 0x0000002d0000720bULL, 0x002fda0003f5d000ULL,
0x0000000000287806ULL, 0x000fc800010e0100ULL, 0x0000ffff283c7812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x0000002d0000720bULL, 0x00cfe40003f54000ULL,
0x000000002d477209ULL, 0x000fe40007810000ULL, 0x00000002ff2b7819ULL, 0x000fc60000011626ULL,
0x800000472d287221ULL, 0x000fe20000010000ULL, 0x000000082b2d7810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b282a7820ULL, 0x000fe40000410000ULL, 0x0000000000287806ULL, 0x000fe400010e0100ULL,
0x000000ff0200720cULL, 0x000fe40003f45270ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x0000ffff28457812ULL, 0x000fc800078e3cffULL, 0x000000453cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ffa57807ULL, 0x000fe40001800000ULL, 0x010400474400a388ULL, 0x000fe80000000800ULL,
0x00001f2d2a2d7589ULL, 0x002e6200000e0000ULL, 0x0000002a2e2e7220ULL, 0x000fe40000410000ULL,
0x8000004700003221ULL, 0x000fe20000010000ULL, 0x00001f2b2a2b7589ULL, 0x000ea600000e0000ULL,
0x3fb8aa3b00003820ULL, 0x000fc80000410000ULL, 0x0000000000323308ULL, 0x000ee20000000800ULL,
0x0000002d23237220ULL, 0x082fe20000410000ULL, 0x0000002d22227220ULL, 0x080fe20000410000ULL,
0x0000002d17177220ULL, 0x080fe20000410000ULL, 0x0000002d16167220ULL, 0x080fe20000410000ULL,
0x0000002d13137220ULL, 0x080fe20000410000ULL, 0x0000002d12127220ULL, 0x080fe20000410000ULL,
0x0000002d0f0f7220ULL, 0x080fe20000410000ULL, 0x0000002d0e0e7220ULL, 0x080fe20000410000ULL,
0x0000002d0b0b7220ULL, 0x080fe20000410000ULL, 0x0000002d0a0a7220ULL, 0x080fe20000410000ULL,
0x0000002d07077220ULL, 0x080fe20000410000ULL, 0x0000002d06067220ULL, 0x080fe20000410000ULL,
0x0000002d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000002d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000002d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000002d1a1a7220ULL, 0x000fe20000410000ULL,
0x0000002b21217220ULL, 0x084fe20000410000ULL, 0x0000002b20207220ULL, 0x080fe20000410000ULL,
0x0000002b15157220ULL, 0x080fe20000410000ULL, 0x0000002b14147220ULL, 0x080fe20000410000ULL,
0x0000002b11117220ULL, 0x080fe20000410000ULL, 0x0000002b10107220ULL, 0x080fe20000410000ULL,
0x0000002b0d0d7220ULL, 0x080fe20000410000ULL, 0x0000002b0c0c7220ULL, 0x080fe20000410000ULL,
0x0000002b09097220ULL, 0x080fe20000410000ULL, 0x0000002b08087220ULL, 0x080fe20000410000ULL,
0x0000002b05057220ULL, 0x080fe20000410000ULL, 0x0000002b04047220ULL, 0x080fe20000410000ULL,
0x0000002b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000002b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000002b19197220ULL, 0x080fe20000410000ULL, 0x0000002b18187220ULL, 0x000fe20000410000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0047ULL, 0x0000003229293220ULL, 0x008fc80000410000ULL,
0x0000002e292e7221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff007984ULL, 0x000e620000000800ULL, 0x800000003b297824ULL, 0x000fca00078e00ffULL,
0x8000000000ff7812ULL, 0x002fe20007824829ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000003b3b7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01064c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc4000782483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000826297812ULL, 0x040fe400078ec0ffULL, 0x0000002f26007211ULL, 0x040fe400078fe0ffULL,
0x00000007292b7812ULL, 0x140fe400078ec826ULL, 0x0000000729297812ULL, 0x000fe400078ef826ULL,
0x000000002b007212ULL, 0x000fe400078e3cffULL, 0x0000003126287211ULL, 0x000fc600078fe0ffULL,
0x0000001029527824ULL, 0x000fe200078e0200ULL, 0x000000282b287212ULL, 0x000fc800078e3cffULL,
0x0000c00052457811ULL, 0x000fe200078e20ffULL, 0x0000001029507824ULL, 0x040fe200078e0228ULL,
0x0000010029297811ULL, 0x000fc600078e20ffULL, 0x000000004554783bULL, 0x000e620000004200ULL,
0x0000c00050467811ULL, 0x000fe200078e20ffULL, 0x0000000100517824ULL, 0x100fe400078e0229ULL,
0x00000001283c7824ULL, 0x000fe400078e0229ULL, 0x00000000464c783bULL, 0x000ea20000004200ULL,
0x0000c00051477811ULL, 0x000fe400078e20ffULL, 0x0000c0003c487811ULL, 0x000fc600078e20ffULL,
0x000000004758783bULL, 0x000ee80000004200ULL, 0x000000004828783bULL, 0x000f220000004200ULL,
0x0000010054d47824ULL, 0x042fe200078e00ffULL, 0x0000005400d57306ULL, 0x000fe20000009400ULL,
0x0001000054d67824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe20000011454ULL,
0x0000010055cb7824ULL, 0x040fe200078e00ffULL, 0x00000018ffd47819ULL, 0x000fe200000114d4ULL,
0x0001000055d27824ULL, 0x000fe200078e00ffULL, 0x00000018ffd67819ULL, 0x000fe200000114d6ULL,
0x0000010056c77824ULL, 0x040fe200078e00ffULL, 0x000000d400d77306ULL, 0x000fe20000209400ULL,
0x00000018ffcb7819ULL, 0x000fe200000114cbULL, 0x0000010057c37824ULL, 0x040fe200078e00ffULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x0001000057bd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000001004dae7824ULL, 0x004fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fe20000011455ULL, 0x000000d400de7306ULL, 0x000e620000205400ULL,
0x00000018ffa47819ULL, 0x000fe20000011457ULL, 0x0001000056c07824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe2000001144dULL, 0x000001004cb47824ULL, 0x040fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe2000001144eULL, 0x0000010059df7824ULL, 0x008fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000005400dc7306ULL, 0x000ea20000005400ULL,
0x00000018ffc07819ULL, 0x000fe200000114c0ULL, 0x000100004caf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fc40000011456ULL, 0x00000018ff8a7819ULL, 0x000fe40000011459ULL,
0x00000018ff007819ULL, 0x010fe2000001142aULL, 0x0000005500cd7306ULL, 0x000fe20000009400ULL,
0x000000ded700720bULL, 0x002fe20003fbd000ULL, 0x0000010058de7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe200000114bdULL, 0x000001005bd77824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe400000114b4ULL, 0x00000018ff857819ULL, 0x000fe20000011458ULL,
0x0000005500a67306ULL, 0x000e620000005400ULL, 0x000000dcd500720bULL, 0x004fe20003f7d000ULL,
0x0001000059dc7824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fc40000011428ULL,
0x00000018ff707819ULL, 0x000fe40000011429ULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x000000d600d97306ULL, 0x000fe20000209400ULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ff9d7819ULL, 0x000fe4000001144cULL, 0x00000018ff5e7819ULL, 0x000fe4000001142bULL,
0x00000018ff8f7819ULL, 0x000fe2000001144fULL, 0x000000d600e07306ULL, 0x000ea20000205400ULL,
0x000000a6cd00720bULL, 0x002fc40003f9d000ULL, 0x000000d600a67245ULL, 0x000fe4000020d400ULL,
0x00000018ffdc7819ULL, 0x000fe400000114dcULL, 0x00000018ffd77819ULL, 0x000fe200000114d7ULL,
0x000000a900d17306ULL, 0x000fe20000209400ULL, 0x00000018ff657819ULL, 0x000fe4000001145aULL,
0x00000018ff617819ULL, 0x000fca000001145bULL, 0x000000a900ce7306ULL, 0x0002e20000205400ULL,
0x000000e0d900720bULL, 0x004fe20003f5d000ULL, 0x000001005ad97824ULL, 0x000fca00078e00ffULL,
0x00000018ffd97819ULL, 0x000fe200000114d9ULL, 0x000000cb00d87306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fca000020d400ULL, 0x00000001a6a62812ULL, 0x000fe400078efcffULL,
0x000000cb00db7306ULL, 0x000fe20000205400ULL, 0x000000ced100720bULL, 0x008fce0003fdd000ULL,
0x0000005500807306ULL, 0x0002ac000000d400ULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x0000005400887306ULL, 0x000722000000d400ULL, 0x00009910a5557816ULL, 0x002fce00000000ffULL,
0x000000d200dd7306ULL, 0x000fe20000209400ULL, 0x000001004e547824ULL, 0x008fe200078e00ffULL,
0x0000000180804812ULL, 0x004fc800078efcffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x000000d200da7306ULL, 0x000e620000205400ULL, 0x0000000188883812ULL, 0x010fce00078efcffULL,
0x000000c700cc7306ULL, 0x000ff00000209400ULL, 0x000000c700cf7306ULL, 0x000ea20000205400ULL,
0x000000dadd00720bULL, 0x002fce0003f7d000ULL, 0x0000005700a87306ULL, 0x000ff00000009400ULL,
0x0000005700b37306ULL, 0x000e620000005400ULL, 0x000000cfcc00720bULL, 0x004fe20003f9d000ULL,
0x0000010028cf7824ULL, 0x000fc400078e00ffULL, 0x0000010029cc7824ULL, 0x000fc600078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x00000057007e7306ULL, 0x0004e2000000d400ULL,
0x00000018ffcc7819ULL, 0x000fce00000114ccULL, 0x0000005600ab7306ULL, 0x000fe20000009400ULL,
0x000100004d577824ULL, 0x004fe200078e00ffULL, 0x000000b3a800720bULL, 0x002fe20003fdd000ULL,
0x000001002ab37824ULL, 0x000fe200078e00ffULL, 0x000000d200a87245ULL, 0x000fe4000020d400ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000005600ca7306ULL, 0x000e620000005400ULL,
0x00000001a8a83812ULL, 0x000fe400078efcffULL, 0x00000018ffb37819ULL, 0x000fc800000114b3ULL,
0x000000017e7e6812ULL, 0x008fe200078efcffULL, 0x0000004d00a37306ULL, 0x000ff00000009400ULL,
0x0000004d00a27306ULL, 0x000fe20000005400ULL, 0x000000caab00720bULL, 0x002fc40003f5d000ULL,
0x000000cb00ab7245ULL, 0x000fe4000020d400ULL, 0x00000018ffca7819ULL, 0x000fc600000114deULL,
0x0000004d00767306ULL, 0x0003f0000000d400ULL, 0x0000004e009b7306ULL, 0x000fe20000009400ULL,
0x000100004e4d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000004e009c7306ULL, 0x000ff00000005400ULL, 0x0000004e00757306ULL, 0x0003f0000000d400ULL,
0x000000c200c87306ULL, 0x000fe20000209400ULL, 0x000000ffff4e7224ULL, 0x002fe200078e0055ULL,
0x000000d400557245ULL, 0x000fc8000020d400ULL, 0x0000000155555812ULL, 0x000fe400078efcffULL,
0x000000c200a77306ULL, 0x000e620000205400ULL, 0x000000dbd800720bULL, 0x000fe40003fbd000ULL,
0x000000ff4e00720cULL, 0x000fca0003f25270ULL, 0x000000c300d07306ULL, 0x000fec0000209400ULL,
0x00000001abab5812ULL, 0x000fe400078efcffULL, 0x000000c300d37306ULL, 0x000ea20000205400ULL,
0x000000a7c800720bULL, 0x002fe20003fbd000ULL, 0x0001000028c87824ULL, 0x000fc400078e00ffULL,
0x000001002ba77824ULL, 0x000fc600078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x000000c000c67306ULL, 0x000fe20000209400ULL, 0x00000018ffa77819ULL, 0x000fce00000114a7ULL,
0x000000c000c97306ULL, 0x000fe20000205400ULL, 0x000000d3d000720bULL, 0x004fce0003f7d000ULL,
0x00000056007f7306ULL, 0x000e70000000d400ULL, 0x0000004c00b27306ULL, 0x000ff00000009400ULL,
0x0000004c00b97306ULL, 0x000ea20000005400ULL, 0x000000017f7f2812ULL, 0x002fce00078efcffULL,
0x000000aa00bc7306ULL, 0x000ff00000209400ULL, 0x000000aa00bb7306ULL, 0x000fe20000205400ULL,
0x000000b9b200720bULL, 0x004fe40003f5d000ULL, 0x000000c000b27245ULL, 0x000fc4000020d400ULL,
0x000000a400b97245ULL, 0x000fc6000020d400ULL, 0x0000005900917306ULL, 0x000ff00000009400ULL,
0x0000005900927306ULL, 0x000ff00000005400ULL, 0x0000005900717306ULL, 0x0003f0000000d400ULL,
0x0000002a00817306ULL, 0x000fe20000009400ULL, 0x000100002a597824ULL, 0x002fca00078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000002a004a7306ULL, 0x000ff00000005400ULL,
0x0000002a00607306ULL, 0x0003f0000000d400ULL, 0x000000a400ac7306ULL, 0x000fe20000209400ULL,
0x000000c7002a7245ULL, 0x002fc8000020d400ULL, 0x000000012a2a4812ULL, 0x000fe400078efcffULL,
0x000000c9c600720bULL, 0x000fe20003f9d000ULL, 0x000000a400ad7306ULL, 0x000e700000205400ULL,
0x000000bd00c47306ULL, 0x000fe80000209400ULL, 0x00000001b2b24812ULL, 0x000fc800078efcffULL,
0x000000bd00c57306ULL, 0x000fe20000205400ULL, 0x000000adac00720bULL, 0x002fe40003fdd000ULL,
0x000000aa00ad7245ULL, 0x000fe4000020d400ULL, 0x000000bd00aa7245ULL, 0x000fc6000020d400ULL,
0x000000b400be7306ULL, 0x000fec0000209400ULL, 0x00000001b9b96812ULL, 0x000fe400078efcffULL,
0x000000b400bf7306ULL, 0x0002b00000205400ULL, 0x0000005800937306ULL, 0x000fe20000009400ULL,
0x000000b400b47245ULL, 0x002fce000020d400ULL, 0x0000005800967306ULL, 0x000fe20000005400ULL,
0x000000bfbe00720bULL, 0x004fce0003f9d000ULL, 0x0000005800727306ULL, 0x0003ec000000d400ULL,
0x00000001b4b44812ULL, 0x000fe400078efcffULL, 0x0000002800847306ULL, 0x000fe20000009400ULL,
0x0001000058587824ULL, 0x002fca00078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe20000011458ULL,
0x000100002b587824ULL, 0x000fe200078e00ffULL, 0x0000002800877306ULL, 0x000fe80000005400ULL,
0x00000018ff587819ULL, 0x000fc80000011458ULL, 0x00000028006b7306ULL, 0x0003f0000000d400ULL,
0x00000029008b7306ULL, 0x000fe20000009400ULL, 0x0001000029287824ULL, 0x002fce00078e00ffULL,
0x0000002900867306ULL, 0x000ff00000005400ULL, 0x00000029006a7306ULL, 0x0003f0000000d400ULL,
0x000000ae00b87306ULL, 0x000fe20000209400ULL, 0x000000c200297245ULL, 0x002fc8000020d400ULL,
0x0000000129295812ULL, 0x000fe400078efcffULL, 0x000000bbbc00720bULL, 0x000fe20003fbd000ULL,
0x000000ae00c17306ULL, 0x000e620000205400ULL, 0x00000018ffbb7819ULL, 0x000fe400000114dfULL,
0x000000a82929723eULL, 0x000fca00000010ffULL, 0x0000002b007d7306ULL, 0x000fe80000009400ULL,
0x00000001adad5812ULL, 0x000fc800078efcffULL, 0x0000002b007c7306ULL, 0x000fe20000005400ULL,
0x000000c1b800720bULL, 0x002fce0003fbd000ULL, 0x0000002b005f7306ULL, 0x0003f0000000d400ULL,
0x000000af00b57306ULL, 0x000fe20000209400ULL, 0x000000c3002b7245ULL, 0x002fc8000020d400ULL,
0x000000012b2b3812ULL, 0x000fe400078efcffULL, 0x000000c5c400720bULL, 0x000fe20003f7d000ULL,
0x000000af00ba7306ULL, 0x0002b00000205400ULL, 0x0000009d00a17306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fc6000020d400ULL, 0x00000001aaaa3812ULL, 0x000fe400078efcffULL,
0x000000a2a300720bULL, 0x000fe40003f7d000ULL, 0x0000009d009e7306ULL, 0x000e620000205400ULL,
0x000000bab500720bULL, 0x004fe40003fdd000ULL, 0x000000ae00a37245ULL, 0x000fc8000020d400ULL,
0x00000001a3a35812ULL, 0x000fe200078efcffULL, 0x0000004c00797306ULL, 0x0004e6000000d400ULL,
0x0000000176763812ULL, 0x000fc600078efcffULL, 0x00000001afaf6812ULL, 0x000fe400078efcffULL,
0x0000009a009f7306ULL, 0x000fe20000209400ULL, 0x000001004f4c7824ULL, 0x004fe200078e00ffULL,
0x0000009ea100720bULL, 0x002fe40003f9d000ULL, 0x0000009d009e7245ULL, 0x000fe4000020d400ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000009a00a07306ULL, 0x0002a20000205400ULL,
0x0000000179792812ULL, 0x008fc400078efcffULL, 0x0000009c9b00720bULL, 0x000fe40003fdd000ULL,
0x00000057009b7245ULL, 0x000fe4000020d400ULL, 0x000000019e9e4812ULL, 0x000fe200078efcffULL,
0x0000005700b67306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fe4000020d400ULL,
0x000000bb009c7245ULL, 0x000fe4000020d400ULL, 0x00000076a3a3723eULL, 0x000fc600000010ffULL,
0x0000005700b77306ULL, 0x0002e20000205400ULL, 0x000000a09f00720bULL, 0x004fe40003f5d000ULL,
0x0000000175756812ULL, 0x000fca00078efcffULL, 0x0000005400b07306ULL, 0x000fe20000209400ULL,
0x0000000726577812ULL, 0x002fca00078ec0ffULL, 0x000000019a9a2812ULL, 0x000fe400078efcffULL,
0x0000005400b17306ULL, 0x000e620000205400ULL, 0x000000b7b600720bULL, 0x008fe40003fbd000ULL,
0x000000969300720bULL, 0x000fe40003f5d000ULL, 0x0000004c00967245ULL, 0x000fe4000020d400ULL,
0x0000004d00937245ULL, 0x000fe2000020d400ULL, 0x0000004c00567306ULL, 0x000fec0000209400ULL,
0x000000019b9b5812ULL, 0x000fc400078efcffULL, 0x0000004c00a57306ULL, 0x000ea20000205400ULL,
0x000000b1b000720bULL, 0x002fe40003f7d000ULL, 0x0000000172722812ULL, 0x000fca00078efcffULL,
0x0000004f00997306ULL, 0x000ff00000009400ULL, 0x0000004f00947306ULL, 0x000e620000005400ULL,
0x000000a55600720bULL, 0x004fce0003f9d000ULL, 0x0000004900977306ULL, 0x000fec0000209400ULL,
0x0000000196964812ULL, 0x000fe400078efcffULL, 0x00000049003e7306ULL, 0x000ea20000205400ULL,
0x000000949900720bULL, 0x002fe40003fbd000ULL, 0x0000005400947245ULL, 0x000fc4000020d400ULL,
0x00000032ff54723eULL, 0x000fe400000010ffULL, 0x0000000194943812ULL, 0x000fe200078efcffULL,
0x0000004f00737306ULL, 0x0002e2000000d400ULL, 0x0000541054547816ULL, 0x000fe40000000054ULL,
0x000000759476723eULL, 0x000fca00000010ffULL, 0x0000008f00987306ULL, 0x000fe20000209400ULL,
0x000100004f4f7824ULL, 0x002fe200078e00ffULL, 0x0000003e9700720bULL, 0x004fe40003fdd000ULL,
0x00000008573e7812ULL, 0x000fe400078ef826ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000008f00957306ULL, 0x000e620000205400ULL, 0x0000000173735812ULL, 0x008fce00078efcffULL,
0x0000004d004e7306ULL, 0x000ff00000209400ULL, 0x0000004d00d57306ULL, 0x0004e20000205400ULL,
0x000000959800720bULL, 0x002fe40003f9d000ULL, 0x0000004900987245ULL, 0x000fc4000020d400ULL,
0x0000004f00957245ULL, 0x000fe4000020d400ULL, 0x0000000198986812ULL, 0x000fe200078efcffULL,
0x0000004f00ce7306ULL, 0x000fe20000209400ULL, 0x00000004ff4d7819ULL, 0x004fe40000011626ULL,
0x000000929100720bULL, 0x000fe40003fdd000ULL, 0x000000074d497812ULL, 0x000fe400078e783eULL,
0x0000008f00927245ULL, 0x000fe2000020d400ULL, 0x0000004f00cd7306ULL, 0x0002a20000205400ULL,
0x000000d54e00720bULL, 0x008fe20003f7d000ULL, 0x000000083e497824ULL, 0x000fe200078e0249ULL,
0x000000ca008f7245ULL, 0x000fc4000020d400ULL, 0x0000000192924812ULL, 0x000fe400078efcffULL,
0x0000a000494c7811ULL, 0x000fe200078e20ffULL, 0x000000ca00d17306ULL, 0x000fe20000209400ULL,
0x0000000171716812ULL, 0x000fc800078efcffULL, 0x000000004c4c783bULL, 0x002fe20000000200ULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x000000ca00d07306ULL, 0x000e620000205400ULL,
0x000000cdce00720bULL, 0x004fe40003fbd000ULL, 0x000000939894723eULL, 0x000fca00000010ffULL,
0x000000cb00c27306ULL, 0x000fec0000209400ULL, 0x0000000195955812ULL, 0x000fe400078efcffULL,
0x000000cb00c37306ULL, 0x0004e20000205400ULL, 0x000000d0d100720bULL, 0x002fe40003f7d000ULL,
0x000000959295723eULL, 0x000fca00000010ffULL, 0x0000008500907306ULL, 0x000fe20000209400ULL,
0x000000cb00cb7245ULL, 0x004fca000020d400ULL, 0x000000018f8f3812ULL, 0x000fe400078efcffULL,
0x00000085008d7306ULL, 0x000e620000205400ULL, 0x000000c3c200720bULL, 0x008fe40003fbd000ULL,
0x000000728f72723eULL, 0x000fca00000010ffULL, 0x0000008a008e7306ULL, 0x000fec0000209400ULL,
0x00000001cbcb5812ULL, 0x000fe400078efcffULL, 0x0000008a003b7306ULL, 0x000ea20000205400ULL,
0x0000008d9000720bULL, 0x002fe40003f9d000ULL, 0x00000002ff8d7819ULL, 0x000fca0000011626ULL,
0x000000bb00bc7306ULL, 0x000ff00000209400ULL, 0x000000bb00bd7306ULL, 0x000e620000205400ULL,
0x0000003b8e00720bULL, 0x004fe40003f7d000ULL, 0x000000088d3b7810ULL, 0x000fc40007ffe0ffULL,
0x00001f8d548d7589ULL, 0x000ea200000e0000ULL, 0x00000085008e7245ULL, 0x000fe4000020d400ULL,
0x000000dc00a27306ULL, 0x000fe20000209400ULL, 0x00001f3b54907589ULL, 0x00072200000e0000ULL,
0x000000018e8e4812ULL, 0x000fe400078efcffULL, 0x000000d700857245ULL, 0x000fe4000020d400ULL,
0x000000cb8e8e723eULL, 0x000fe400000010ffULL, 0x000000dc009f7306ULL, 0x000f620000205400ULL,
0x000000bdbc00720bULL, 0x002fc40003f5d000ULL, 0x000000885554723eULL, 0x008fe400000010ffULL,
0x00000080ab55723eULL, 0x000fe400000010ffULL, 0x000000cf00807245ULL, 0x000fe2000020d400ULL,
0x000000d9009d7306ULL, 0x000fe20000209400ULL, 0x0000008d4c4c9231ULL, 0x004fca00003400ffULL,
0x000000019c9c2812ULL, 0x000fe200078efcffULL, 0x0000008d4e4e9231ULL, 0x000fe200003400ffULL,
0x000000d900567306ULL, 0x000e620000205400ULL, 0x0000009fa200720bULL, 0x020fe20003fbd000ULL,
0x000000904d4d9231ULL, 0x090fe400003400ffULL, 0x000000904f4f9231ULL, 0x000fc800003400ffULL,
0x0000005a00897306ULL, 0x000fe60000009400ULL, 0x000000944c20723cULL, 0x000fea0000041820ULL,
0x0000005a00827306ULL, 0x000ea20000005400ULL, 0x000000569d00720bULL, 0x002fce0003f9d000ULL,
0x0000005b008c7306ULL, 0x000ff00000009400ULL, 0x0000005b00837306ULL, 0x000e620000005400ULL,
0x000000828900720bULL, 0x004fe40003f5d000ULL, 0x000000dc00827245ULL, 0x000fc8000020d400ULL,
0x0000000182825812ULL, 0x000fe200078efcffULL, 0x000000d700977306ULL, 0x000fe20000209400ULL,
0x000000878400720bULL, 0x000fe40003fbd000ULL, 0x000000d900847245ULL, 0x000fe4000020d400ULL,
0x00000018ff877819ULL, 0x000fe40000011428ULL, 0x0000000184844812ULL, 0x000fe200078efcffULL,
0x000000d700a07306ULL, 0x000ea20000205400ULL, 0x000000838c00720bULL, 0x002fc40003fdd000ULL,
0x0000008a00837245ULL, 0x000fe4000020d400ULL, 0x000000a6a928723eULL, 0x000fe400000010ffULL,
0x0000000183833812ULL, 0x000fe200078efcffULL, 0x0000005a006f7306ULL, 0x0002e2000000d400ULL,
0x000000868b00720bULL, 0x000fe40003f7d000ULL, 0x000000016b6b5812ULL, 0x000fe200078efcffULL,
0x000000284c1c723cULL, 0x000fe2000004181cULL, 0x0000008700c97245ULL, 0x000fc4000020d400ULL,
0x00000082838f723eULL, 0x000fe200000010ffULL, 0x000000cf00577306ULL, 0x000fe20000209400ULL,
0x000000a09700720bULL, 0x004fe20003f9d000ULL, 0x000100005a5a7824ULL, 0x002fc800078e00ffULL,
0x000000016a6a3812ULL, 0x000fe400078efcffULL, 0x000000cf00a47306ULL, 0x000e620000205400ULL,
0x000000016f6f2812ULL, 0x008fe400078efcffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000006f8484723eULL, 0x000fe400000010ffULL, 0x0000000185854812ULL, 0x000fe200078efcffULL,
0x0000005b006e7306ULL, 0x0004e2000000d400ULL, 0x0000004a8100720bULL, 0x000fce0003f9d000ULL,
0x000000cc00997306ULL, 0x000fe20000209400ULL, 0x000000a45700720bULL, 0x002fe20003f5d000ULL,
0x000100005b5b7824ULL, 0x004fe200078e00ffULL, 0x000000544c54723cULL, 0x000fe60000041818ULL,
0x0000000160604812ULL, 0x000fe400078efcffULL, 0x000000cc00a27306ULL, 0x000e620000205400ULL,
0x000000016e6e6812ULL, 0x008fe400078efcffULL, 0x0000000735197812ULL, 0x000fc400078e783eULL,
0x0000007f2a18723eULL, 0x000fe400000010ffULL, 0x0000000180802812ULL, 0x000fe200078efcffULL,
0x00000074007a7306ULL, 0x000fe20000209400ULL, 0x000000083e4a7824ULL, 0x000fe200078e0219ULL,
0x0000007e2b19723eULL, 0x000fe400000010ffULL, 0x0000007c7d00720bULL, 0x000fe40003f5d000ULL,
0x000000cc007f7245ULL, 0x000fe4000020d400ULL, 0x00000074007b7306ULL, 0x000ea20000205400ULL,
0x000000a29900720bULL, 0x002fe20003fdd000ULL, 0x000000184c18723cULL, 0x000fe20000041804ULL,
0x000000b2ad7c723eULL, 0x000fc400000010ffULL, 0x000000aab97d723eULL, 0x000fe400000010ffULL,
0x00000079b4a2723eULL, 0x000fe200000010ffULL, 0x000000c800917306ULL, 0x000fe20000209400ULL,
0x0000007400797245ULL, 0x000fe4000020d400ULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000007c4c04723cULL, 0x000fe20000041808ULL, 0x0000a0004a2a7811ULL, 0x000fe400078e20ffULL,
0x000000017f7f6812ULL, 0x000fe200078efcffULL, 0x000000c8008a7306ULL, 0x0002e20000205400ULL,
0x0000007b7a00720bULL, 0x004fc40003fbd000ULL, 0x000000af9e08723eULL, 0x000fe200000010ffULL,
0x000000002a28783bULL, 0x000ea20000000200ULL, 0x0000009b9a09723eULL, 0x000fe200000010ffULL,
0x000000a24c0c723cULL, 0x000fe2000004180cULL, 0x000000015f5f2812ULL, 0x000fe200078efcffULL,
0x0000007000777306ULL, 0x000fe20000209400ULL, 0x000000c800c87245ULL, 0x002fe4000020d400ULL,
0x0000006e8585723eULL, 0x000fc600000010ffULL, 0x000000084c08723cULL, 0x000fe20000041810ULL,
0x0000000179795812ULL, 0x000fe200078efcffULL, 0x0000007000787306ULL, 0x0003220000205400ULL,
0x0000008a9100720bULL, 0x008fc80003fdd000ULL, 0x0000006b8012723eULL, 0x000fe400000010ffULL,
0x0000006a7f13723eULL, 0x000fe200000010ffULL, 0x000000b300887306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fca000020d400ULL, 0x00000001c8c86812ULL, 0x000fe400078efcffULL,
0x000000b300817306ULL, 0x0002e20000205400ULL, 0x000000787700720bULL, 0x010fe40003f7d000ULL,
0x000000739677723eULL, 0x000fe400000010ffULL, 0x000000719c73723eULL, 0x000fe400000010ffULL,
0x000000c879c8723eULL, 0x000fe200000010ffULL, 0x0000008700867306ULL, 0x000fe20000209400ULL,
0x000000b300b37245ULL, 0x002fe2000020d400ULL, 0x000000764c14723cULL, 0x000fe20000041814ULL,
0x0000008d28289231ULL, 0x004fc600003400ffULL, 0x0000000170703812ULL, 0x000fe200078efcffULL,
0x0000008d2a2a9231ULL, 0x000fe200003400ffULL, 0x0000008700897306ULL, 0x000e620000205400ULL,
0x000000818800720bULL, 0x008fe20003fbd000ULL, 0x0000009029299231ULL, 0x080fe200003400ffULL,
0x000000a7004c7245ULL, 0x000fe2000020d400ULL, 0x000000902b2b9231ULL, 0x000fc800003400ffULL,
0x0000000000667306ULL, 0x000fe60000209400ULL, 0x000000722854723cULL, 0x040fe60000041854ULL,
0x00000001b3b35812ULL, 0x000fe400078efcffULL, 0x0000000000697306ULL, 0x0004e20000205400ULL,
0x000000898600720bULL, 0x002fe40003fdd000ULL, 0x00000060b34e723eULL, 0x000fe200000010ffULL,
0x0000008e281c723cULL, 0x000fe8000004181cULL, 0x0000005a00787306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x004fc6000020d400ULL, 0x000000842818723cULL, 0x000fe40000041818ULL,
0x00000001c9c96812ULL, 0x000fe400078efcffULL, 0x0000005a00757306ULL, 0x0002a20000205400ULL,
0x000000696600720bULL, 0x008fe40003f9d000ULL, 0x000000c970c9723eULL, 0x000fca00000010ffULL,
0x00000065006d7306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x002fca000020d400ULL,
0x0000000100004812ULL, 0x000fe400078efcffULL, 0x00000065006c7306ULL, 0x0002e20000205400ULL,
0x000000757800720bULL, 0x004fce0003fbd000ULL, 0x000000a7007e7306ULL, 0x000fe20000209400ULL,
0x0000006500657245ULL, 0x002fca000020d400ULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x000000a7007b7306ULL, 0x000e620000205400ULL, 0x0000006c6d00720bULL, 0x008fce0003f7d000ULL,
0x0000005b00107306ULL, 0x000fec0000209400ULL, 0x0000000165653812ULL, 0x000fe400078efcffULL,
0x0000005b00117306ULL, 0x0004e20000205400ULL, 0x0000007b7e00720bULL, 0x002fe40003fdd000ULL,
0x0000005a655a723eULL, 0x000fca00000010ffULL, 0x0000006100637306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x004fca000020d400ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x0000006100627306ULL, 0x000e620000205400ULL, 0x000000111000720bULL, 0x008fe40003f5d000ULL,
0x0000005f4c4f723eULL, 0x000fe200000010ffULL, 0x000000122810723cULL, 0x000fe2000004180cULL,
0x00000061004c7245ULL, 0x000fc6000020d400ULL, 0x0000005e00677306ULL, 0x000fe80000209400ULL,
0x000000c8280c723cULL, 0x000fe40000041808ULL, 0x000000015b5b2812ULL, 0x000fe400078efcffULL,
0x0000005e00687306ULL, 0x0004e20000205400ULL, 0x000000626300720bULL, 0x002fc60003fbd000ULL,
0x0000004e2808723cULL, 0x000fe80000041814ULL, 0x0000005900747306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x004fca000020d400ULL, 0x000000014c4c5812ULL, 0x000fe400078efcffULL,
0x0000005900717306ULL, 0x0002a20000205400ULL, 0x000000686700720bULL, 0x008fe40003fdd000ULL,
0x0000005b4c5b723eULL, 0x000fca00000010ffULL, 0x00000058004d7306ULL, 0x000fe20000209400ULL,
0x0000005900597245ULL, 0x002fe2000020d400ULL, 0x0000005a2814723cULL, 0x000fe80000041804ULL,
0x000000015e5e6812ULL, 0x000fe400078efcffULL, 0x0000005800667306ULL, 0x000e620000205400ULL,
0x000000717400720bULL, 0x004fda0003f7d000ULL, 0x0000000159593812ULL, 0x000fe400078efcffULL,
0x000000664d00720bULL, 0x002fe40003f5d000ULL, 0x00000058004d7245ULL, 0x000fe4000020d400ULL,
0x00000059004c723eULL, 0x000fd200000010ffULL, 0x000000014d4d2812ULL, 0x000fc800078efcffULL,
0x0000004d5e4d723eULL, 0x000fce00000010ffULL, 0x0000004c2804723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000207305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000200000735dULL, 0x004fe40003800000ULL,
0x01065c00ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000004024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff4f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff4d7819ULL, 0x000fc40000011626ULL, 0x0000000003217217ULL, 0x000fe20007800000ULL,
0x00006200272b7a24ULL, 0x100fe200078e0200ULL, 0x0000c0004b4b7811ULL, 0x000fe400078e20ffULL,
0x0000c0005d4c7811ULL, 0x000fe200078e20ffULL, 0x0000000121217824ULL, 0x000fe200078e0a00ULL,
0x0000c0003d4e7811ULL, 0x000fe200078e20ffULL, 0x0000000133207824ULL, 0x100fe400078e022bULL,
0x0000000136227824ULL, 0x100fe200078e022bULL, 0x0000002021217807ULL, 0x000fe20000000000ULL,
0x0000000138287824ULL, 0x000fc400078e022bULL, 0x000000013a2b7824ULL, 0x000fe200078e022bULL,
0x000000212c237217ULL, 0x000fe20007800000ULL, 0x00005e0020207625ULL, 0x000fc800078e004fULL,
0x0000000123007824ULL, 0x000fe200078e0a2cULL, 0x0000003420207210ULL, 0x000fe20007f7e0ffULL,
0x00005e0022227625ULL, 0x000fc600078e004fULL, 0x000000004d00720cULL, 0x000fe20003f46070ULL,
0x00005e0028287625ULL, 0x080fe200078e004fULL, 0x0000003422227210ULL, 0x080fe40007f9e0ffULL,
0x0000c0005c4d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff217224ULL, 0x000fe200018e0621ULL,
0x0000003428287210ULL, 0x000fe20007fbe0ffULL, 0x00005e002b2a7625ULL, 0x000fe200078e004fULL,
0x000000003500720cULL, 0x000fc60003f66070ULL, 0x000000ffff237224ULL, 0x000fe200020e0623ULL,
0x000000003700720cULL, 0x080fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x000000003900720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000204b7faeULL, 0x0003e2000d101c46ULL, 0x000000342a2a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0x00000000224c7faeULL, 0x0003e8000d901c46ULL,
0x00000000284d7faeULL, 0x0003e8000e101c46ULL, 0x000000002a4e7faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff217984ULL, 0x002e620000000800ULL,
0x0000ffff64007812ULL, 0x000fc800078ec0ffULL, 0x0000888000207816ULL, 0x000fca00000000ffULL,
0x8000000020007824ULL, 0x000fca00078e00ffULL, 0x8000000021ff7812ULL, 0x002fe20007844800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x01065400ff217984ULL, 0x000e620000000800ULL, 0x8000000020007824ULL, 0x000fca00078e00ffULL,
0x8000000021ff7812ULL, 0x002fe20007844800ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000020207824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000217305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000210000735dULL, 0x004fe40003800000ULL,
0x01065400ff217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fc40007844820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000e000524f7811ULL, 0x000fe400078e20ffULL, 0x0000e00050507811ULL, 0x000fe400078e20ffULL,
0x0000e00051517811ULL, 0x000fe200078e20ffULL, 0x000000004f58783bULL, 0x000e620000004200ULL,
0x0000e0003c3c7811ULL, 0x000fe400078e20ffULL, 0x00000007373d7812ULL, 0x000fe200078e783eULL,
0x00000000505c783bULL, 0x000ea80000004200ULL, 0x000000005128783bULL, 0x000ee20000004200ULL,
0x000000083e3d7824ULL, 0x000fc600078e023dULL, 0x000000003c20783bULL, 0x000f220000004200ULL,
0x0000010058de7824ULL, 0x042fe200078e00ffULL, 0x0000005800c47306ULL, 0x000fe20000009400ULL,
0x0001000058eb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe20000011459ULL,
0x0000010059e67824ULL, 0x040fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fe200000114deULL,
0x0001000059cb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffeb7819ULL, 0x000fe200000114ebULL,
0x000100005abe7824ULL, 0x040fe200078e00ffULL, 0x000000de007e7306ULL, 0x000fe20000209400ULL,
0x00000018ffe67819ULL, 0x000fe200000114e6ULL, 0x000001005abc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe37819ULL, 0x000fe20000011458ULL, 0x000001005bbb7824ULL, 0x040fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe200000114cbULL, 0x000001005cc67824ULL, 0x044fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe200000114beULL, 0x000000de00cd7306ULL, 0x0002a20000205400ULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x000100005bc77824ULL, 0x000fe200078e00ffULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x000100005cce7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe200000114c6ULL, 0x000001005dc57824ULL, 0x040fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe2000001145aULL, 0x0000005800bd7306ULL, 0x000f620000005400ULL,
0x000000de00de7245ULL, 0x002fe2000020d400ULL, 0x000100005dd67824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe2000001145bULL, 0x0001000028ee7824ULL, 0x008fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x0000010029df7824ULL, 0x040fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x000000eb00d27306ULL, 0x000fe20000209400ULL,
0x000000cd7e00720bULL, 0x004fe20003f9d000ULL, 0x0001000029ea7824ULL, 0x000fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fe2000001145cULL, 0x0000010020cd7824ULL, 0x010fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe2000001145dULL, 0x000100002add7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011428ULL, 0x000000eb00d57306ULL, 0x000e620000205400ULL,
0x000000bdc400720bULL, 0x020fe20003fdd000ULL, 0x0000010028c47824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001145eULL, 0x000100002bcc7824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011429ULL, 0x00010000227e7824ULL, 0x000fe200078e00ffULL,
0x00000001dede4812ULL, 0x000fe200078efcffULL, 0x000000e600ec7306ULL, 0x000fe20000209400ULL,
0x00000018ff707819ULL, 0x000fc40000011420ULL, 0x00000018ff7d7819ULL, 0x000fe4000001142aULL,
0x00000018ff757819ULL, 0x000fe4000001142bULL, 0x00000018ff697819ULL, 0x000fe20000011421ULL,
0x000000e600ed7306ULL, 0x000ea20000205400ULL, 0x000000d5d200720bULL, 0x002fe20003f5d000ULL,
0x0001000020d57824ULL, 0x000fe200078e00ffULL, 0x00000018ff007819ULL, 0x000fe20000011422ULL,
0x0000010021d27824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fc40000011423ULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x0000005800837306ULL, 0x0002e2000000d400ULL,
0x00000018ffd67819ULL, 0x000fe400000114d6ULL, 0x00000018ff9c7819ULL, 0x000fe4000001145fULL,
0x00000018ffc47819ULL, 0x000fe400000114c4ULL, 0x00000018ffdf7819ULL, 0x000fe200000114dfULL,
0x0000005900e07306ULL, 0x000fe20000009400ULL, 0x000000edec00720bULL, 0x004fe20003f9d000ULL,
0x000001005e587824ULL, 0x002fe200078e00ffULL, 0x00000018ffdd7819ULL, 0x000fc400000114ddULL,
0x00000018ffea7819ULL, 0x000fe400000114eaULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000005900e17306ULL, 0x000e620000005400ULL, 0x0000000183836812ULL, 0x008fe400078efcffULL,
0x00000018ffcd7819ULL, 0x000fe400000114cdULL, 0x00000018ffcc7819ULL, 0x000fe400000114ccULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x000000b500e47306ULL, 0x000fe20000209400ULL,
0x00000083dede723eULL, 0x000fc400000010ffULL, 0x00000018ffd57819ULL, 0x000fe400000114d5ULL,
0x00000018ff7e7819ULL, 0x000fc6000001147eULL, 0x000000b500e77306ULL, 0x000ea20000205400ULL,
0x000000e1e000720bULL, 0x002fe40003f7d000ULL, 0x000000eb00e07245ULL, 0x000fc8000020d400ULL,
0x00000001e0e02812ULL, 0x000fe200078efcffULL, 0x000000e300b97306ULL, 0x000ff00000209400ULL,
0x000000e300787306ULL, 0x0002e20000205400ULL, 0x000000e7e400720bULL, 0x004fc40003fdd000ULL,
0x000000e600e77245ULL, 0x000fc8000020d400ULL, 0x00000001e7e74812ULL, 0x000fe200078efcffULL,
0x000000cb00e87306ULL, 0x000fe20000209400ULL, 0x000000e300e37245ULL, 0x002fce000020d400ULL,
0x000000cb00e97306ULL, 0x0002a20000205400ULL, 0x00000078b900720bULL, 0x008fe20003fbd000ULL,
0x0001000021b97824ULL, 0x000fe400078e00ffULL, 0x0001000023787824ULL, 0x000fc600078e00ffULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000005a00b77306ULL, 0x000fe20000009400ULL,
0x000000cb00cb7245ULL, 0x002fe4000020d400ULL, 0x00000018ff787819ULL, 0x000fc60000011478ULL,
0x00000001e3e35812ULL, 0x000fe400078efcffULL, 0x0000005a00b87306ULL, 0x000e620000005400ULL,
0x000000e9e800720bULL, 0x004fce0003f5d000ULL, 0x000000be00bf7306ULL, 0x000fec0000209400ULL,
0x00000001cbcb2812ULL, 0x000fe400078efcffULL, 0x000000be00c27306ULL, 0x0004e20000205400ULL,
0x000000b8b700720bULL, 0x002fe40003f9d000ULL, 0x000000b500b87245ULL, 0x000fc8000020d400ULL,
0x00000001b8b86812ULL, 0x000fe200078efcffULL, 0x000000bc00e27306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x004fe4000020d400ULL, 0x000000cbb8cb723eULL, 0x000fca00000010ffULL,
0x000000bc00e57306ULL, 0x000e620000205400ULL, 0x000000c2bf00720bULL, 0x008fce0003fdd000ULL,
0x0000005b00b67306ULL, 0x000fec0000009400ULL, 0x00000001bebe6812ULL, 0x000fe400078efcffULL,
0x0000005b00a37306ULL, 0x000ea20000005400ULL, 0x000000e5e200720bULL, 0x002fe40003fbd000ULL,
0x00000018ffe27819ULL, 0x000fca00000114eeULL, 0x0000005900887306ULL, 0x0002f0000000d400ULL,
0x000000bb00ba7306ULL, 0x000fe20000209400ULL, 0x000000a3b600720bULL, 0x004fe20003f5d000ULL,
0x000001005f597824ULL, 0x002fe200078e00ffULL, 0x000000bc00a37245ULL, 0x000fc8000020d400ULL,
0x00000001a3a35812ULL, 0x000fe200078efcffULL, 0x000000bb00c37306ULL, 0x000e620000205400ULL,
0x0000000188883812ULL, 0x008fe400078efcffULL, 0x00000018ff597819ULL, 0x000fca0000011459ULL,
0x000000c600c87306ULL, 0x000ff00000209400ULL, 0x000000c600c17306ULL, 0x000ea20000205400ULL,
0x000000c3ba00720bULL, 0x002fce0003f7d000ULL, 0x0000005b007f7306ULL, 0x000e70000000d400ULL,
0x000000b000b37306ULL, 0x000fe20000209400ULL, 0x000000c1c800720bULL, 0x004fce0003fdd000ULL,
0x000000b000aa7306ULL, 0x000ea20000205400ULL, 0x000000017f7f2812ULL, 0x002fce00078efcffULL,
0x000000ae00b27306ULL, 0x000ff00000209400ULL, 0x000000ae00a77306ULL, 0x0002e20000205400ULL,
0x000000aab300720bULL, 0x004fe40003fbd000ULL, 0x000000bb00aa7245ULL, 0x000fc8000020d400ULL,
0x00000001aaaa3812ULL, 0x000fe200078efcffULL, 0x0000005a00807306ULL, 0x000522000000d400ULL,
0x000000ae00ae7245ULL, 0x002fce000020d400ULL, 0x0000005c00b47306ULL, 0x000fe20000009400ULL,
0x000000a7b200720bULL, 0x008fe20003f5d000ULL, 0x000100005e5a7824ULL, 0x004fe200078e00ffULL,
0x000000b000a77245ULL, 0x000fc8000020d400ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000005c00a97306ULL, 0x000e620000005400ULL, 0x0000000180804812ULL, 0x010fe400078efcffULL,
0x00000001a7a75812ULL, 0x000fc600078efcffULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x000000c700c97306ULL, 0x000fe20000209400ULL, 0x000000bea7be723eULL, 0x000fce00000010ffULL,
0x000000c700ca7306ULL, 0x0004e20000205400ULL, 0x000000a9b400720bULL, 0x002fe40003f9d000ULL,
0x000000c600a97245ULL, 0x000fc8000020d400ULL, 0x00000001a9a96812ULL, 0x000fe200078efcffULL,
0x000000ce00d17306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x004fce000020d400ULL,
0x000000ce00dc7306ULL, 0x0002a20000205400ULL, 0x000000cac900720bULL, 0x008fe40003f7d000ULL,
0x000000e0e3ca723eULL, 0x000fca00000010ffULL, 0x000000ac00a67306ULL, 0x000fe20000209400ULL,
0x000000ce00ce7245ULL, 0x002fca000020d400ULL, 0x00000001c7c73812ULL, 0x000fe400078efcffULL,
0x000000ac00ab7306ULL, 0x000e620000205400ULL, 0x000000dcd100720bULL, 0x004fe40003fdd000ULL,
0x000000c7aebf723eULL, 0x000fca00000010ffULL, 0x0000005d00b17306ULL, 0x000fec0000009400ULL,
0x00000001cece6812ULL, 0x000fe400078efcffULL, 0x0000005d009e7306ULL, 0x000ea20000005400ULL,
0x000000aba600720bULL, 0x002fe40003f5d000ULL, 0x000000ac00ab7245ULL, 0x000fca000020d400ULL,
0x0000008900a57306ULL, 0x000fec0000209400ULL, 0x00000001abab2812ULL, 0x000fe400078efcffULL,
0x0000008900a87306ULL, 0x000e620000205400ULL, 0x0000009eb100720bULL, 0x004fe40003f7d000ULL,
0x000000c5009e7245ULL, 0x000fca000020d400ULL, 0x0000005d007b7306ULL, 0x0004f0000000d400ULL,
0x0000005800d77306ULL, 0x000fe20000209400ULL, 0x00000007395d7812ULL, 0x004fe400078e783eULL,
0x000000a8a500720bULL, 0x002fc40003fdd000ULL, 0x0000008900a57245ULL, 0x000fe2000020d400ULL,
0x000000083e3e7824ULL, 0x000fe200078e025dULL, 0x00000002ffa87819ULL, 0x000fe20000011626ULL,
0x0000005800d87306ULL, 0x000e620000205400ULL, 0x00000100225d7824ULL, 0x000fe200078e00ffULL,
0x000000017b7b3812ULL, 0x008fe400078efcffULL, 0x0000005900897245ULL, 0x000fc8000020d400ULL,
0x0000002800857306ULL, 0x000fe20000009400ULL, 0x00000001a5a56812ULL, 0x000fce00078efcffULL,
0x0000002800967306ULL, 0x000fe20000005400ULL, 0x000000d8d700720bULL, 0x002fce0003f5d000ULL,
0x0000002800747306ULL, 0x0003f0000000d400ULL, 0x0000005f00ad7306ULL, 0x000fe20000009400ULL,
0x000001002a287824ULL, 0x002fca00078e00ffULL, 0x00000018ffb07819ULL, 0x000fe40000011428ULL,
0x0000005f00a47306ULL, 0x000e620000005400ULL, 0x0000a0003d287811ULL, 0x000fce00078e20ffULL,
0x0000005c007c7306ULL, 0x0004f0000000d400ULL, 0x0000005e00af7306ULL, 0x000fe20000009400ULL,
0x00000100235c7824ULL, 0x004fe200078e00ffULL, 0x000000a4ad00720bULL, 0x002fc40003f7d000ULL,
0x00000032ffad723eULL, 0x000fc800000010ffULL, 0x0000005e00a27306ULL, 0x000e620000005400ULL,
0x000000017c7c4812ULL, 0x008fce00078efcffULL, 0x0000002900957306ULL, 0x000ff00000009400ULL,
0x0000002900867306ULL, 0x000fe20000005400ULL, 0x000000a2af00720bULL, 0x002fe40003f9d000ULL,
0x0000005800a27245ULL, 0x000fc8000020d400ULL, 0x00000001a2a22812ULL, 0x000fe200078efcffULL,
0x0000002900717306ULL, 0x0003f0000000d400ULL, 0x0000002000877306ULL, 0x000fe20000009400ULL,
0x000001002b297824ULL, 0x002fca00078e00ffULL, 0x00000018ffa67819ULL, 0x000fe40000011429ULL,
0x00000020008c7306ULL, 0x000ff00000005400ULL, 0x00000020006a7306ULL, 0x0003f0000000d400ULL,
0x00000093008d7306ULL, 0x000fe20000209400ULL, 0x0000a0003e207811ULL, 0x002fce00078e20ffULL,
0x0000009300947306ULL, 0x000e700000205400ULL, 0x0000002a00847306ULL, 0x000ff00000009400ULL,
0x0000002a008f7306ULL, 0x000fe20000005400ULL, 0x000000948d00720bULL, 0x002fc40003fdd000ULL,
0x00005410ad8d7816ULL, 0x000fca00000000adULL, 0x0000002a006f7306ULL, 0x000fe2000000d400ULL,
0x00001f3b8d587589ULL, 0x000fee00000e0000ULL, 0x0000002b009f7306ULL, 0x000ff00000009400ULL,
0x0000002b008a7306ULL, 0x000ff00000005400ULL, 0x0000002b006e7306ULL, 0x0003f0000000d400ULL,
0x00000021009a7306ULL, 0x000fe20000009400ULL, 0x000000002828783bULL, 0x002e6e0000000200ULL,
0x0000002100917306ULL, 0x000ff00000005400ULL, 0x0000002100677306ULL, 0x000ff0000000d400ULL,
0x0000002200997306ULL, 0x000ff00000009400ULL, 0x0000002200987306ULL, 0x000ff00000005400ULL,
0x0000002200657306ULL, 0x000fe2000000d400ULL, 0x0000005829299231ULL, 0x002fc400003400ffULL,
0x000000582b2b9231ULL, 0x000fca00003400ffULL, 0x0000002300767306ULL, 0x000ff00000009400ULL,
0x0000002300637306ULL, 0x000ff00000005400ULL, 0x0000002300667306ULL, 0x0003f0000000d400ULL,
0x0000005a005b7306ULL, 0x000fe20000209400ULL, 0x000000002020783bULL, 0x002e6e0000000200ULL,
0x0000005a00a07306ULL, 0x000eb00000205400ULL, 0x000000c500c07306ULL, 0x000ff00000209400ULL,
0x000000c500cf7306ULL, 0x000ee20000205400ULL, 0x000000a05b00720bULL, 0x004fc40003f5d000ULL,
0x00001fa88d5b7589ULL, 0x00052a00000e0000ULL, 0x000000d600da7306ULL, 0x000fe20000209400ULL,
0x000000c4008d7245ULL, 0x004fce000020d400ULL, 0x000000d600d37306ULL, 0x0005620000205400ULL,
0x000000cfc000720bULL, 0x008fe20003fbd000ULL, 0x0000005821219231ULL, 0x082fe400003400ffULL,
0x0000005823239231ULL, 0x000fe200003400ffULL, 0x00000080a358723eULL, 0x000fc600000010ffULL,
0x000000e200b77306ULL, 0x000fe20000209400ULL, 0x000000d600d67245ULL, 0x004fe2000020d400ULL,
0x0000005b28289231ULL, 0x090fe400003400ffULL, 0x0000005b2a2a9231ULL, 0x080fe400003400ffULL,
0x000000019e9e5812ULL, 0x000fe200078efcffULL, 0x0000005b20209231ULL, 0x080fe200003400ffULL,
0x000000e200b67306ULL, 0x0002a20000205400ULL, 0x000000d3da00720bULL, 0x020fe20003fbd000ULL,
0x0000005b22229231ULL, 0x000fe200003400ffULL, 0x000000be2814723cULL, 0x000fea0000041814ULL,
0x0000005900d47306ULL, 0x000fe20000209400ULL, 0x000000e200e27245ULL, 0x002fc4000020d400ULL,
0x000000ca281c723cULL, 0x000fe6000004181cULL, 0x00000001d6d65812ULL, 0x000fe400078efcffULL,
0x0000005900d97306ULL, 0x0002e20000205400ULL, 0x000000b6b700720bULL, 0x004fce0003f3d000ULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x0000007faa59723eULL, 0x002fca00000010ffULL,
0x00000001e2e21812ULL, 0x000fe400078efcffULL, 0x000000b000b47306ULL, 0x0002a20000205400ULL,
0x000000d9d400720bULL, 0x008fce0003fbd000ULL, 0x0000005e00777306ULL, 0x000ee2000000d400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x0000005f00607306ULL, 0x000322000000d400ULL, 0x000000b4b100720bULL, 0x004fce0003f3d000ULL,
0x0000009c008e7306ULL, 0x000fe20000209400ULL, 0x000100005f5f7824ULL, 0x002fe200078e00ffULL,
0x0000000177774812ULL, 0x008fc800078efcffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000009c008b7306ULL, 0x0002a20000205400ULL, 0x00000001b0b01812ULL, 0x000fe400078efcffULL,
0x0000000160603812ULL, 0x010fe400078efcffULL, 0x000000968500720bULL, 0x000fe40003f7d000ULL,
0x0000005f00857245ULL, 0x000fe2000020d400ULL, 0x0000005f005e7306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fc4000020d400ULL, 0x000000608989723eULL, 0x000fca00000010ffULL,
0x0000005f00bd7306ULL, 0x000e620000205400ULL, 0x0000008b8e00720bULL, 0x004fe40003f9d000ULL,
0x00000093008e7245ULL, 0x000fe4000020d400ULL, 0x0000005a008b7245ULL, 0x000fe4000020d400ULL,
0x000000018e8e6812ULL, 0x000fe200078efcffULL, 0x000000a600ac7306ULL, 0x000fe20000209400ULL,
0x0000008f8400720bULL, 0x000fe20003fdd000ULL, 0x000000582858723cULL, 0x000fe20000041818ULL,
0x000000018b8b2812ULL, 0x000fc400078efcffULL, 0x000000869500720bULL, 0x000fe40003f5d000ULL,
0x000000019c9c4812ULL, 0x000fe200078efcffULL, 0x000000a600af7306ULL, 0x000ea20000205400ULL,
0x000000bd5e00720bULL, 0x002fe40003fbd000ULL, 0x000000df00847245ULL, 0x000fe4000020d400ULL,
0x0000007ca918723eULL, 0x000fe400000010ffULL, 0x000000016f6f6812ULL, 0x000fe200078efcffULL,
0x0000007d00817306ULL, 0x000fe20000209400ULL, 0x0000000174743812ULL, 0x000fc400078efcffULL,
0x0000007d007c7245ULL, 0x000fe4000020d400ULL, 0x0000008a9f00720bULL, 0x000fe40003f7d000ULL,
0x0000000185855812ULL, 0x000fe200078efcffULL, 0x0000007d00827306ULL, 0x000e620000205400ULL,
0x000000afac00720bULL, 0x004fe40003f3d000ULL, 0x0000007b9e19723eULL, 0x000fe400000010ffULL,
0x0000000171712812ULL, 0x000fc400078efcffULL, 0x0000008b8e8e723eULL, 0x000fe200000010ffULL,
0x000000c400d07306ULL, 0x000fe40000209400ULL, 0x000000016e6e3812ULL, 0x000fe200078efcffULL,
0x000000182810723cULL, 0x000fea0000041810ULL, 0x000000c400db7306ULL, 0x000ea20000205400ULL,
0x000000828100720bULL, 0x002fc40003fdd000ULL, 0x000000a600817245ULL, 0x000fe4000020d400ULL,
0x00000018ff827819ULL, 0x000fe4000001145dULL, 0x0000000181811812ULL, 0x000fe200078efcffULL,
0x000000df00e17306ULL, 0x000fec0000209400ULL, 0x000000017c7c6812ULL, 0x000fc400078efcffULL,
0x000000df00e47306ULL, 0x0002e20000205400ULL, 0x000000dbd000720bULL, 0x004fce0003fbd000ULL,
0x000000dd00a47306ULL, 0x000fe20000209400ULL, 0x00000088e7df723eULL, 0x002fe400000010ffULL,
0x00000077a288723eULL, 0x000fc600000010ffULL, 0x000000018d8d5812ULL, 0x000fe400078efcffULL,
0x000000dd00ad7306ULL, 0x0002a20000205400ULL, 0x000000e4e100720bULL, 0x008fe20003f9d000ULL,
0x000000de2854723cULL, 0x000fe20000041854ULL, 0x000000748d18723eULL, 0x000fca00000010ffULL,
0x0000009b00a17306ULL, 0x000fe20000209400ULL, 0x000000dd00dd7245ULL, 0x002fca000020d400ULL,
0x0000000184844812ULL, 0x000fe400078efcffULL, 0x0000009b00907306ULL, 0x0002e20000205400ULL,
0x000000ada400720bULL, 0x004fe40003f3d000ULL, 0x000000718419723eULL, 0x000fe400000010ffULL,
0x000000b900717245ULL, 0x000fc6000020d400ULL, 0x00000075007a7306ULL, 0x000fe20000209400ULL,
0x0000009b009b7245ULL, 0x002fe2000020d400ULL, 0x000000182018723cULL, 0x000fe80000041854ULL,
0x00000001dddd1812ULL, 0x000fe400078efcffULL, 0x0000007500797306ULL, 0x0002a20000205400ULL,
0x00000090a100720bULL, 0x008fe40003fbd000ULL, 0x0000006900547245ULL, 0x000fca000020d400ULL,
0x000000ea00b37306ULL, 0x000fe20000209400ULL, 0x0000007500757245ULL, 0x002fca000020d400ULL,
0x000000019b9b5812ULL, 0x000fe400078efcffULL, 0x000000ea00b27306ULL, 0x0002e20000205400ULL,
0x000000797a00720bULL, 0x004fe40003f3d000ULL, 0x0000008c8700720bULL, 0x000fe40003fbd000ULL,
0x00000018ff797819ULL, 0x000fe4000001145cULL, 0x000000e29be2723eULL, 0x000fe200000010ffULL,
0x000000cd00867306ULL, 0x000fe20000209400ULL, 0x000000ea00ea7245ULL, 0x002fca000020d400ULL,
0x0000000175751812ULL, 0x000fe400078efcffULL, 0x000000cd008f7306ULL, 0x0002a20000205400ULL,
0x000000b2b300720bULL, 0x008fe40003f9d000ULL, 0x000000016a6a5812ULL, 0x000fca00078efcffULL,
0x000000cc005e7306ULL, 0x000fe20000209400ULL, 0x000000cd00cd7245ULL, 0x002fca000020d400ULL,
0x00000001eaea4812ULL, 0x000fe400078efcffULL, 0x000000cc005f7306ULL, 0x0002e20000205400ULL,
0x0000008f8600720bULL, 0x004fe40003fdd000ULL, 0x000000919a00720bULL, 0x000fe40003f9d000ULL,
0x000000859c8f723eULL, 0x000fc600000010ffULL, 0x00000097009d7306ULL, 0x000fe20000209400ULL,
0x000000cc00cc7245ULL, 0x002fca000020d400ULL, 0x00000001cdcd6812ULL, 0x000fe400078efcffULL,
0x0000009700927306ULL, 0x0002a20000205400ULL, 0x0000005f5e00720bULL, 0x008fe40003f7d000ULL,
0x000000ceab5e723eULL, 0x000fe400000010ffULL, 0x000000d6a55f723eULL, 0x000fe400000010ffULL,
0x0000000167674812ULL, 0x000fe200078efcffULL, 0x0000007000617306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fc6000020d400ULL, 0x0000005e285c723cULL, 0x000fe4000004180cULL,
0x00000001cccc3812ULL, 0x000fe400078efcffULL, 0x0000007000627306ULL, 0x0002e20000205400ULL,
0x000000929d00720bULL, 0x004fe40003f5d000ULL, 0x000000637600720bULL, 0x000fe40003f7d000ULL,
0x0000006acd0c723eULL, 0x000fc600000010ffULL, 0x000000d200907306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fca000020d400ULL, 0x0000000197972812ULL, 0x000fe400078efcffULL,
0x000000d200937306ULL, 0x0002a20000205400ULL, 0x000000626100720bULL, 0x008fe40003f3d000ULL,
0x000000989900720bULL, 0x000fe20003f5d000ULL, 0x000000882860723cULL, 0x000fe20000041808ULL,
0x0000000166663812ULL, 0x000fe400078efcffULL, 0x000000ea97e3723eULL, 0x000fe200000010ffULL,
0x0000006900737306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x002fc4000020d400ULL,
0x000000dd7c08723eULL, 0x000fe200000010ffULL, 0x0000008e2828723cULL, 0x000fe20000041804ULL,
0x000000cc7509723eULL, 0x000fe400000010ffULL, 0x0000000170701812ULL, 0x000fe200078efcffULL,
0x0000006900727306ULL, 0x000e620000205400ULL, 0x000000939000720bULL, 0x004fe40003fdd000ULL,
0x0000000165652812ULL, 0x000fe200078efcffULL, 0x000000082008723cULL, 0x000fe20000041814ULL,
0x0000006fb004723eULL, 0x000fc400000010ffULL, 0x0000006e8105723eULL, 0x000fe200000010ffULL,
0x000000d500837306ULL, 0x000fe60000209400ULL, 0x0000007900157245ULL, 0x000fe2000020d400ULL,
0x000000e2201c723cULL, 0x000fe2000004181cULL, 0x0000000000177245ULL, 0x000fe4000020d400ULL,
0x00000001d2d26812ULL, 0x000fe200078efcffULL, 0x000000d5008a7306ULL, 0x0004e20000205400ULL,
0x000000727300720bULL, 0x002fc60003fbd000ULL, 0x000000042004723cULL, 0x000fe80000041858ULL,
0x000000b900807306ULL, 0x000fe20000209400ULL, 0x000000d500d57245ULL, 0x004fca000020d400ULL,
0x0000000154545812ULL, 0x000fe400078efcffULL, 0x000000b9007f7306ULL, 0x000e620000205400ULL,
0x0000008a8300720bULL, 0x008fce0003fdd000ULL, 0x00000082007b7306ULL, 0x000fec0000209400ULL,
0x00000001d5d56812ULL, 0x000fe400078efcffULL, 0x00000082007a7306ULL, 0x0004e20000205400ULL,
0x0000007f8000720bULL, 0x002fe40003f9d000ULL, 0x00000078007f7245ULL, 0x000fc4000020d400ULL,
0x000000d57070723eULL, 0x000fc600000010ffULL, 0x0000007900767306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x004fca000020d400ULL, 0x0000000171714812ULL, 0x000fe400078efcffULL,
0x00000079000d7306ULL, 0x000e620000205400ULL, 0x0000007a7b00720bULL, 0x008fe40003f3d000ULL,
0x000000715471723eULL, 0x000fca00000010ffULL, 0x00000000006c7306ULL, 0x000fec0000209400ULL,
0x0000000182821812ULL, 0x000fe400078efcffULL, 0x00000000006d7306ULL, 0x000ea20000205400ULL,
0x0000000d7600720bULL, 0x002fe40003fbd000ULL, 0x00000067d20d723eULL, 0x000fc400000010ffULL,
0x000000658214723eULL, 0x000fc600000010ffULL, 0x0000005200687306ULL, 0x000fec0000209400ULL,
0x0000000115155812ULL, 0x000fe400078efcffULL, 0x00000052006b7306ULL, 0x0002e20000205400ULL,
0x0000006d6c00720bULL, 0x004fe40003fdd000ULL, 0x000000661515723eULL, 0x000fca00000010ffULL,
0x0000007e000e7306ULL, 0x000fe20000209400ULL, 0x0000005200527245ULL, 0x002fca000020d400ULL,
0x0000000117176812ULL, 0x000fe400078efcffULL, 0x0000007e000f7306ULL, 0x0002a20000205400ULL,
0x0000006b6800720bULL, 0x008fce0003f9d000ULL, 0x0000007800557306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fca000020d400ULL, 0x0000000152524812ULL, 0x000fe400078efcffULL,
0x0000007800567306ULL, 0x000e620000205400ULL, 0x0000000f0e00720bULL, 0x004fe40003f3d000ULL,
0x0000000c200c723cULL, 0x040ff00000041810ULL, 0x000000702010723cULL, 0x000fe6000004185cULL,
0x000000017e7e1812ULL, 0x000fc400078efcffULL, 0x000000565500720bULL, 0x002fe40003f5d000ULL,
0x0000007e177e723eULL, 0x000fe400000010ffULL, 0x000000142014723cULL, 0x000ff20000041860ULL,
0x000000017f7f2812ULL, 0x000fc800078efcffULL, 0x0000007f527f723eULL, 0x000fce00000010ffULL,
0x0000007e2020723cULL, 0x000fe20000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004024007811ULL, 0x000fe200078e40ffULL, 0x01061000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff64ff7812ULL, 0x000fe4000782c0ffULL, 0x000000000300720cULL, 0x000fe40003f44070ULL,
0x00000001ff647807ULL, 0x000fd60000800000ULL, 0x0000dfd00000a947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01065c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000006024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff5b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff597819ULL, 0x000fe40000011626ULL, 0x0000000003297217ULL, 0x000fe20007800000ULL,
0x0000620027557a24ULL, 0x000fc800078e0200ULL, 0x0000000129297824ULL, 0x000fe400078e0a00ULL,
0x0000000133287824ULL, 0x100fe400078e0255ULL, 0x00000001362a7824ULL, 0x000fe200078e0255ULL,
0x00000020292b7807ULL, 0x000fe20000000000ULL, 0x00005e0028287625ULL, 0x000fc600078e005bULL,
0x0000002b2c577217ULL, 0x000fe20007800000ULL, 0x00005e002a2a7625ULL, 0x000fe200078e005bULL,
0x0000003428567210ULL, 0x000fc60007f3e0ffULL, 0x0000000157007824ULL, 0x000fe200078e0a2cULL,
0x000000342a2a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000138287824ULL, 0x100fe400078e0255ULL,
0x000000013a557824ULL, 0x000fe200078e0255ULL, 0x000000005900720cULL, 0x080fe20003f46070ULL,
0x000000ffff577224ULL, 0x000fe200008e0629ULL, 0x000000003500720cULL, 0x080fe20003f26070ULL,
0x00005e0028287625ULL, 0x000fe200078e005bULL, 0x000000003900720cULL, 0x000fc60003f86070ULL,
0x00005e0055547625ULL, 0x000fe200078e005bULL, 0x0000003428287210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e062bULL, 0x000000003700720cULL, 0x000fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x0000003454547210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000563f7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff557224ULL, 0x000fe200030e0655ULL, 0x000000002a407faeULL, 0x0003ea000c901c46ULL,
0x0000000028417faeULL, 0x0003e8000d901c46ULL, 0x0000000054427faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff297984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01061c00ff287984ULL, 0x000ea20000000800ULL,
0x000000ff53ff7812ULL, 0x000fe2000782c0ffULL, 0x80000000432b7824ULL, 0x000fc600078e00ffULL,
0x00000001ff527807ULL, 0x000fca0000800000ULL, 0x8000000052007824ULL, 0x000fca00078e00ffULL,
0x8000000029ff7812ULL, 0x002fe40007824800ULL, 0x8000000028ff7812ULL, 0x004fe2000784482bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000043297824ULL, 0x000fe400078e00ffULL,
0x0000000000287305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000280000735dULL, 0x004fe40003800000ULL, 0x01061c00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fc40007844829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0100800044007984ULL, 0x000e620000000800ULL,
0x00000001ff637424ULL, 0x000fc600078e00ffULL, 0x0102800044297984ULL, 0x0004e20000000800ULL,
0x0000002d0000720bULL, 0x002fda0003f5d000ULL, 0x0000000000287806ULL, 0x000fc800010e0100ULL,
0x0000ffff28547812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x0000002d0000720bULL, 0x00cfe40003f54000ULL, 0x000000002d2b7209ULL, 0x000fe40007810000ULL,
0x00000002ff557819ULL, 0x000fc60000011626ULL, 0x8000002b2d287221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b282a7820ULL, 0x000fe40000410000ULL, 0x0000000000287806ULL, 0x000fe400010e0100ULL,
0x000000010200780cULL, 0x000fe40003f45270ULL, 0x0000ffff282d7812ULL, 0x000fe200078e3cffULL,
0x0000002a002a7308ULL, 0x000e660000000800ULL, 0x0000002d54ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff637807ULL, 0x000fc60001800000ULL, 0x0104802b4400a388ULL, 0x000fec0000000800ULL,
0x8000002b002d3221ULL, 0x100fe20000010000ULL, 0x00001f552a287589ULL, 0x002e6200000e0000ULL,
0x0000002a2e2e7220ULL, 0x000fe40000410000ULL, 0x3fb8aa3b2d2d3820ULL, 0x000fe20000410000ULL,
0x00001f3b2a007589ULL, 0x000ea600000e0000ULL, 0x0000002d00323308ULL, 0x0007240000000800ULL,
0x000000ffff2d7224ULL, 0x008fe200078e002bULL, 0x0000002932293220ULL, 0x010fe20000410000ULL,
0x0000002818187220ULL, 0x082fe20000410000ULL, 0x0000002819197220ULL, 0x080fe20000410000ULL,
0x000000281c1c7220ULL, 0x080fe20000410000ULL, 0x000000281d1d7220ULL, 0x080fe20000410000ULL,
0x0000002804047220ULL, 0x080fe20000410000ULL, 0x0000002805057220ULL, 0x080fe20000410000ULL,
0x0000002808087220ULL, 0x080fe20000410000ULL, 0x0000002809097220ULL, 0x080fe20000410000ULL,
0x000000280c0c7220ULL, 0x080fe20000410000ULL, 0x000000280d0d7220ULL, 0x080fe20000410000ULL,
0x0000002810107220ULL, 0x080fe20000410000ULL, 0x0000002811117220ULL, 0x080fe20000410000ULL,
0x0000002814147220ULL, 0x080fe20000410000ULL, 0x0000002815157220ULL, 0x080fe20000410000ULL,
0x0000002820207220ULL, 0x080fe20000410000ULL, 0x0000002821217220ULL, 0x000fe20000410000ULL,
0x000000001a1a7220ULL, 0x084fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x000fe20000410000ULL,
0x0000002e292e7221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff007984ULL, 0x000e620000000800ULL, 0x8000000052297824ULL, 0x000fca00078e00ffULL,
0x8000000000ff7812ULL, 0x002fe20007824829ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000052297824ULL, 0x000fe400078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01064c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc40007824829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000004528783bULL, 0x000e620000004200ULL, 0x0000991063637816ULL, 0x000fc600000000ffULL,
0x00000000465c783bULL, 0x000ea80000004200ULL, 0x000000004758783bULL, 0x000ee80000004200ULL,
0x000000004854783bULL, 0x000f220000004200ULL, 0x0000010029d17824ULL, 0x042fe200078e00ffULL,
0x0000002800d97306ULL, 0x000fe20000009400ULL, 0x0001000028e07824ULL, 0x040fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe20000011428ULL, 0x0000010028e47824ULL, 0x000fe200078e00ffULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x0001000029d27824ULL, 0x000fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x000100002bbb7824ULL, 0x000fe200078e00ffULL,
0x000000d100e27306ULL, 0x000fe20000209400ULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x000001005cb87824ULL, 0x004fe200078e00ffULL, 0x00000018ffd27819ULL, 0x000fe200000114d2ULL,
0x000001005db97824ULL, 0x040fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011429ULL,
0x000100005dc57824ULL, 0x000fe200078e00ffULL, 0x00000018ffb17819ULL, 0x000fe2000001142bULL,
0x000000d100e57306ULL, 0x0002a20000205400ULL, 0x00000018ff9e7819ULL, 0x000fe2000001142aULL,
0x000100005fcb7824ULL, 0x040fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fe2000001145cULL,
0x000001005ec47824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0001000058ec7824ULL, 0x048fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000000e000e97306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x002fe2000020d400ULL,
0x0000010058eb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x000001005fc37824ULL, 0x000fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x0000010059ea7824ULL, 0x040fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x000000e000e87306ULL, 0x0002e20000205400ULL, 0x000000e5e200720bULL, 0x004fe20003fbd000ULL,
0x0001000059e37824ULL, 0x000fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x000001005ad67824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe2000001145fULL,
0x000001005bdb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffac7819ULL, 0x000fe2000001145dULL,
0x0000002800cc7306ULL, 0x000ea20000005400ULL, 0x000000e000e07245ULL, 0x002fc4000020d400ULL,
0x00000018ff897819ULL, 0x000fe40000011458ULL, 0x00000018ff717819ULL, 0x010fe40000011455ULL,
0x00000001d1d15812ULL, 0x000fe200078efcffULL, 0x000000e400e67306ULL, 0x000fe20000209400ULL,
0x000000e8e900720bULL, 0x008fe40003f7d000ULL, 0x00000018ff007819ULL, 0x000fe40000011456ULL,
0x00000018ffa67819ULL, 0x000fc4000001145eULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x000000e400e77306ULL, 0x0002e20000205400ULL, 0x000000ccd900720bULL, 0x004fe20003f9d000ULL,
0x000100005ad97824ULL, 0x000fe200078e00ffULL, 0x00000018ffea7819ULL, 0x000fe400000114eaULL,
0x00000018ffe37819ULL, 0x000fe400000114e3ULL, 0x00000001e0e03812ULL, 0x000fe200078efcffULL,
0x00000029007f7306ULL, 0x000fe20000009400ULL, 0x000000e400e47245ULL, 0x002fc4000020d400ULL,
0x00000018ffd67819ULL, 0x000fe400000114d6ULL, 0x00000018ff867819ULL, 0x000fe4000001145aULL,
0x00000018ff8c7819ULL, 0x000fe20000011459ULL, 0x0000002900847306ULL, 0x000e620000005400ULL,
0x000000e7e600720bULL, 0x008fe20003f3d000ULL, 0x0000010055e67824ULL, 0x000fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe400000114ebULL, 0x00000018ff767819ULL, 0x000fc40000011454ULL,
0x00000018ff687819ULL, 0x000fe20000011457ULL, 0x0000002800657306ULL, 0x0004e2000000d400ULL,
0x00000018ffdb7819ULL, 0x000fe400000114dbULL, 0x00000018ffd97819ULL, 0x000fe400000114d9ULL,
0x00000018ff827819ULL, 0x000fe4000001145bULL, 0x00000001e4e41812ULL, 0x000fe200078efcffULL,
0x0000002b00b57306ULL, 0x000fe20000009400ULL, 0x000001002b287824ULL, 0x004fe200078e00ffULL,
0x000000847f00720bULL, 0x002fe20003fdd000ULL, 0x0001000056847824ULL, 0x000fe200078e00ffULL,
0x00000018ffe67819ULL, 0x000fe200000114e6ULL, 0x00010000577f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x0000002b00b67306ULL, 0x000e620000005400ULL,
0x0000000165654812ULL, 0x008fe400078efcffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x00000018ff7f7819ULL, 0x000fc6000001147fULL, 0x000000cd00e17306ULL, 0x000ff00000209400ULL,
0x000000cd00de7306ULL, 0x0004e20000205400ULL, 0x000000b6b500720bULL, 0x002fe40003fbd000ULL,
0x0000009b00b67245ULL, 0x000fca000020d400ULL, 0x000000d200d77306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x004fce000020d400ULL, 0x000000d200d87306ULL, 0x000e620000205400ULL,
0x000000dee100720bULL, 0x008fe40003f5d000ULL, 0x000000d200e17245ULL, 0x000fca000020d400ULL,
0x0000002900647306ULL, 0x0004ec000000d400ULL, 0x00000001cdcd2812ULL, 0x000fe400078efcffULL,
0x0000002a00dc7306ULL, 0x000fe20000009400ULL, 0x000001002a297824ULL, 0x004fe200078e00ffULL,
0x000000d8d700720bULL, 0x002fc40003f7d000ULL, 0x000000e0cde0723eULL, 0x000fe400000010ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a00df7306ULL, 0x000e620000005400ULL,
0x0000000164646812ULL, 0x008fcc00078efcffULL, 0x00000001e1e13812ULL, 0x000fe200078efcffULL,
0x0000009b00cf7306ULL, 0x000ff00000209400ULL, 0x0000009b00d07306ULL, 0x0004e20000205400ULL,
0x000000dfdc00720bULL, 0x002fce0003f3d000ULL, 0x0000002800d57306ULL, 0x000fe20000209400ULL,
0x00000029009b7245ULL, 0x004fce000020d400ULL, 0x0000002800da7306ULL, 0x000e620000205400ULL,
0x000000d0cf00720bULL, 0x008fce0003f9d000ULL, 0x0000002b00877306ULL, 0x000eac000000d400ULL,
0x00000001b6b64812ULL, 0x000fe400078efcffULL, 0x000000b100b27306ULL, 0x000fe20000209400ULL,
0x000000dad500720bULL, 0x002fe40003fdd000ULL, 0x000000e1b6e1723eULL, 0x000fca00000010ffULL,
0x000000b100937306ULL, 0x000e620000205400ULL, 0x0000000187875812ULL, 0x004fce00078efcffULL,
0x0000005c009c7306ULL, 0x000ff00000009400ULL, 0x0000005c009d7306ULL, 0x000ea20000005400ULL,
0x00000093b200720bULL, 0x002fce0003fbd000ULL, 0x0000002900d37306ULL, 0x000ff00000209400ULL,
0x0000002900d47306ULL, 0x000e620000205400ULL, 0x0000009d9c00720bULL, 0x004fe40003f7d000ULL,
0x00000028009c7245ULL, 0x000fc4000020d400ULL, 0x0000a80049287811ULL, 0x000fe400078e20ffULL,
0x000000019c9c6812ULL, 0x000fe200078efcffULL, 0x0000005c00857306ULL, 0x0004f0000000d400ULL,
0x0000002a00607306ULL, 0x000962000000d400ULL, 0x000100005c5c7824ULL, 0x004fe200078e00ffULL,
0x000000d4d300720bULL, 0x002fc80003f5d000ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000005d009a7306ULL, 0x000fe20000009400ULL, 0x000100002a2a7824ULL, 0x010fe200078e00ffULL,
0x0000005c00937245ULL, 0x000fe4000020d400ULL, 0x0000000185853812ULL, 0x008fe400078efcffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000005d00917306ULL, 0x000e620000005400ULL,
0x0000000160601812ULL, 0x020fc400078efcffULL, 0x000000019b9b2812ULL, 0x000fca00078efcffULL,
0x0000009e00b37306ULL, 0x000ff00000209400ULL, 0x0000009e00b47306ULL, 0x0004e20000205400ULL,
0x000000919a00720bULL, 0x002fe40003f3d000ULL, 0x000000b1009a7245ULL, 0x000fc4000020d400ULL,
0x0000002a00917245ULL, 0x000fe4000020d400ULL, 0x000000019a9a5812ULL, 0x000fe200078efcffULL,
0x000000bb00bd7306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x004fce000020d400ULL,
0x000000bb00be7306ULL, 0x0002a20000205400ULL, 0x000000b4b300720bULL, 0x008fce0003f9d000ULL,
0x0000005c00c07306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x002fca000020d400ULL,
0x000000019e9e4812ULL, 0x000fe400078efcffULL, 0x0000005c00c17306ULL, 0x000e620000205400ULL,
0x000000bebd00720bULL, 0x004fce0003fdd000ULL, 0x0000002a00b77306ULL, 0x000fec0000209400ULL,
0x00000001bbbb6812ULL, 0x000fe400078efcffULL, 0x0000002a00ce7306ULL, 0x000ea20000205400ULL,
0x000000c1c000720bULL, 0x002fce0003fbd000ULL, 0x000000b900ba7306ULL, 0x000fec0000209400ULL,
0x0000000193935812ULL, 0x000fe400078efcffULL, 0x000000b900bf7306ULL, 0x000e620000205400ULL,
0x000000ceb700720bULL, 0x004fce0003f5d000ULL, 0x0000005e00987306ULL, 0x000fec0000009400ULL,
0x0000000191912812ULL, 0x000fe400078efcffULL, 0x0000005e009f7306ULL, 0x000ea20000005400ULL,
0x000000bfba00720bULL, 0x002fce0003f9d000ULL, 0x0000005f00ae7306ULL, 0x000ff00000009400ULL,
0x0000005f00997306ULL, 0x000e620000005400ULL, 0x0000009f9800720bULL, 0x004fe40003fdd000ULL,
0x000000b900987245ULL, 0x000fc8000020d400ULL, 0x0000000198984812ULL, 0x000fe200078efcffULL,
0x000000b800bc7306ULL, 0x000ff00000209400ULL, 0x000000b8002b7306ULL, 0x0004e20000205400ULL,
0x00000099ae00720bULL, 0x002fce0003fbd000ULL, 0x0000005e007e7306ULL, 0x000322000000d400ULL,
0x000000b800b87245ULL, 0x004fce000020d400ULL, 0x000000c500c77306ULL, 0x000fe20000209400ULL,
0x0000002bbc00720bULL, 0x008fe20003f5d000ULL, 0x000100005e5e7824ULL, 0x002fe200078e00ffULL,
0x000000002828783bULL, 0x000fe80000000200ULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x000000c500c87306ULL, 0x0002a20000205400ULL, 0x000000017e7e6812ULL, 0x010fe400078efcffULL,
0x0000005e00997245ULL, 0x000fc6000020d400ULL, 0x00000001b8b82812ULL, 0x000fe400078efcffULL,
0x000000cb00cc7306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x002fce000020d400ULL,
0x000000cb00dd7306ULL, 0x0002e20000205400ULL, 0x000000c8c700720bULL, 0x004fce0003f9d000ULL,
0x0000005d00817306ULL, 0x000ea2000000d400ULL, 0x000000cb00cb7245ULL, 0x002fca000020d400ULL,
0x00000001c5c54812ULL, 0x000fe400078efcffULL, 0x0000005f007d7306ULL, 0x000e62000000d400ULL,
0x000000ddcc00720bULL, 0x008fce0003fdd000ULL, 0x000000c400c67306ULL, 0x000fe20000209400ULL,
0x0000000181811812ULL, 0x004fca00078efcffULL, 0x00000001cbcb6812ULL, 0x000fe400078efcffULL,
0x000000c4005d7306ULL, 0x000ea20000205400ULL, 0x000000017d7d5812ULL, 0x002fce00078efcffULL,
0x0000009000a77306ULL, 0x000ff00000209400ULL, 0x0000009000967306ULL, 0x000e620000205400ULL,
0x0000005dc600720bULL, 0x004fce0003f3d000ULL, 0x0000005800ab7306ULL, 0x000ff00000009400ULL,
0x0000005800a27306ULL, 0x000ea20000005400ULL, 0x00000096a700720bULL, 0x002fe40003fbd000ULL,
0x0000009000967245ULL, 0x000fca000020d400ULL, 0x00000058007a7306ULL, 0x0002ec000000d400ULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x00000055008e7306ULL, 0x000fe20000009400ULL,
0x0001000055587824ULL, 0x002fe200078e00ffULL, 0x000000a2ab00720bULL, 0x004fc40003f9d000ULL,
0x000000c300a27245ULL, 0x000fe4000020d400ULL, 0x000000cb96a7723eULL, 0x000fe400000010ffULL,
0x00000055008f7306ULL, 0x000fee0000005400ULL, 0x000000017a7a4812ULL, 0x008fe200078efcffULL,
0x00000055006e7306ULL, 0x0003f0000000d400ULL, 0x000000ad00977306ULL, 0x000fe20000209400ULL,
0x0000010056557824ULL, 0x002fce00078e00ffULL, 0x000000ad00947306ULL, 0x000e700000205400ULL,
0x0000005600837306ULL, 0x000ff00000009400ULL, 0x0000005600807306ULL, 0x000fe20000005400ULL,
0x000000949700720bULL, 0x002fc40003f5d000ULL, 0x000000c400977245ULL, 0x000fe4000020d400ULL,
0x000000ad00947245ULL, 0x000fe4000020d400ULL, 0x0000000197971812ULL, 0x000fe200078efcffULL,
0x0000005600697306ULL, 0x0003ec000000d400ULL, 0x0000000194942812ULL, 0x000fc400078efcffULL,
0x000000ac00af7306ULL, 0x000fe20000209400ULL, 0x00000018ff567819ULL, 0x002fc800000114ecULL,
0x0000005600907245ULL, 0x000fc6000020d400ULL, 0x0000005600dc7306ULL, 0x000ff00000209400ULL,
0x0000005600cf7306ULL, 0x000e700000205400ULL, 0x000000ac00b07306ULL, 0x0004f00000205400ULL,
0x000000a600aa7306ULL, 0x000fe20000209400ULL, 0x000000cfdc00720bULL, 0x002fc40003fdd000ULL,
0x000000ac00ac7245ULL, 0x004fca000020d400ULL, 0x000000a600a37306ULL, 0x0002a20000205400ULL,
0x000000b0af00720bULL, 0x008fca0003f7d000ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x0000008900a17306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x002fca000020d400ULL,
0x00000001acac3812ULL, 0x000fe400078efcffULL, 0x0000008900927306ULL, 0x0002e20000205400ULL,
0x000000a3aa00720bULL, 0x004fce0003f3d000ULL, 0x000000c300c27306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x002fca000020d400ULL, 0x00000001a6a61812ULL, 0x000fe400078efcffULL,
0x000000c300c97306ULL, 0x000e620000205400ULL, 0x00000092a100720bULL, 0x008fce0003fbd000ULL,
0x000000ea00b57306ULL, 0x000fec0000209400ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x000000ea00b47306ULL, 0x0004e20000205400ULL, 0x000000c9c200720bULL, 0x002fce0003f5d000ULL,
0x000000e3009d7306ULL, 0x000fe20000209400ULL, 0x000000ea00ea7245ULL, 0x004fca000020d400ULL,
0x00000001a2a22812ULL, 0x000fe400078efcffULL, 0x000000e300b27306ULL, 0x0002a20000205400ULL,
0x000000b4b500720bULL, 0x008fe40003f9d000ULL, 0x0000007da27d723eULL, 0x000fca00000010ffULL,
0x0000005e00ca7306ULL, 0x000fe20000209400ULL, 0x000000e300e37245ULL, 0x002fca000020d400ULL,
0x00000001eaea4812ULL, 0x000fe400078efcffULL, 0x0000005e005f7306ULL, 0x000e620000205400ULL,
0x000000b29d00720bULL, 0x004fce0003fdd000ULL, 0x0000005a00957306ULL, 0x000fec0000009400ULL,
0x00000001e3e36812ULL, 0x000fe400078efcffULL, 0x0000005a00a47306ULL, 0x000ea20000005400ULL,
0x0000005fca00720bULL, 0x002fce0003f7d000ULL, 0x000000d6009f7306ULL, 0x000fec0000209400ULL,
0x0000000199993812ULL, 0x000fe400078efcffULL, 0x000000d600b07306ULL, 0x000e620000205400ULL,
0x000000a49500720bULL, 0x004fe40003f3d000ULL, 0x00000002ff957819ULL, 0x000fc40000011626ULL,
0x00000099a6a6723eULL, 0x000fc600000010ffULL, 0x0000005900a87306ULL, 0x000ff00000009400ULL,
0x0000005900a97306ULL, 0x000ea20000005400ULL, 0x000000b09f00720bULL, 0x002fce0003fbd000ULL,
0x0000005a00737306ULL, 0x0002f0000000d400ULL, 0x0000005900797306ULL, 0x000962000000d400ULL,
0x00000100545a7824ULL, 0x002fe200078e00ffULL, 0x000000a9a800720bULL, 0x004fc80003f5d000ULL,
0x00000018ff9d7819ULL, 0x000fe4000001145aULL, 0x0000005b008a7306ULL, 0x000fe20000009400ULL,
0x0001000054597824ULL, 0x010fe200078e00ffULL, 0x00000032ff5a723eULL, 0x000fe400000010ffULL,
0x0000000173731812ULL, 0x008fe400078efcffULL, 0x000054105aa47816ULL, 0x000fe2000000005aULL,
0x000000ffff5a7224ULL, 0x000fe200078e0063ULL, 0x0000005b00677306ULL, 0x000e620000005400ULL,
0x0000000179792812ULL, 0x020fc400078efcffULL, 0x00001f95a4957589ULL, 0x000ea200000e0000ULL,
0x000000ff5a00720cULL, 0x000fc60003f45270ULL, 0x00001f3ba4927589ULL, 0x000ee200000e0000ULL,
0x0000005400667306ULL, 0x000ff00000009400ULL, 0x00000054008b7306ULL, 0x000f220000005400ULL,
0x000000678a00720bULL, 0x002fc40003f9d000ULL, 0x000000d6008a7245ULL, 0x000fe4000020d400ULL,
0x00000064d167723eULL, 0x000fe400000010ffULL, 0x000000018a8a5812ULL, 0x000fe200078efcffULL,
0x00000054006d7306ULL, 0x000362000000d400ULL, 0x000000952828a231ULL, 0x084fe400003400ffULL,
0x000000952a2aa231ULL, 0x000fe400003400ffULL, 0x000000922929a231ULL, 0x008fc600003400ffULL,
0x00000057007c7306ULL, 0x000fe20000009400ULL, 0x0000010057547824ULL, 0x002fe200078e00ffULL,
0x0000008b6600720bULL, 0x010fe20003fdd000ULL, 0x000000922b2ba231ULL, 0x000fe200003400ffULL,
0x00000065e466723eULL, 0x000fe400000010ffULL, 0x00000018ff8b7819ULL, 0x000fe40000011459ULL,
0x00000057007b7306ULL, 0x000fe20000005400ULL, 0x000000bb9a59723eULL, 0x000fe200000010ffULL,
0x000000a62820723cULL, 0x040fea0000041820ULL, 0x000000016d6d6812ULL, 0x020fe200078efcffULL,
0x00000057006a7306ULL, 0x000fe4000000d400ULL, 0x000000662864723cULL, 0x000fec0000041818ULL,
0x000000e700e87306ULL, 0x000fe20000209400ULL, 0x0000a8004a187811ULL, 0x000fcc00078e20ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x000000e700577306ULL, 0x0004f00000205400ULL,
0x000000db005d7306ULL, 0x000fe20000209400ULL, 0x000000e700e77245ULL, 0x004fce000020d400ULL,
0x000000db00ae7306ULL, 0x0005220000205400ULL, 0x00000057e800720bULL, 0x008fce0003f7d000ULL,
0x000000d9005c7306ULL, 0x000fe20000209400ULL, 0x000000db00db7245ULL, 0x004fca000020d400ULL,
0x00000001e7e73812ULL, 0x000fe400078efcffULL, 0x000000d900577306ULL, 0x0004e20000205400ULL,
0x000000ae5d00720bULL, 0x010fe40003fbd000ULL, 0x000000879c5d723eULL, 0x000fe200000010ffULL,
0x000000951818a231ULL, 0x002fc800003400ffULL, 0x0000008c00a57306ULL, 0x000fe20000209400ULL,
0x000000d900d97245ULL, 0x004fe2000020d400ULL, 0x000000951a1aa231ULL, 0x000fe400003400ffULL,
0x000000921919a231ULL, 0x080fe400003400ffULL, 0x00000001dbdb5812ULL, 0x000fe200078efcffULL,
0x000000921b1ba231ULL, 0x000fe200003400ffULL, 0x0000008c00a07306ULL, 0x0002a20000205400ULL,
0x000000575c00720bULL, 0x008fe40003fbd000ULL, 0x000000609b5c723eULL, 0x000fc400000010ffULL,
0x000000c5ac57723eULL, 0x000fc600000010ffULL, 0x0000005b00747306ULL, 0x000722000000d400ULL,
0x0000008c008c7245ULL, 0x002fca000020d400ULL, 0x00000001d9d95812ULL, 0x000fe400078efcffULL,
0x00000086008d7306ULL, 0x000fe20000209400ULL, 0x000100005b5b7824ULL, 0x008fe200078e00ffULL,
0x000000a0a500720bULL, 0x004fc80003f7d000ULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x0000008600887306ULL, 0x0002a20000205400ULL, 0x0000000174744812ULL, 0x010fcc00078efcffULL,
0x000000018c8c3812ULL, 0x000fe200078efcffULL, 0x0000005b005e7306ULL, 0x000fe20000209400ULL,
0x0000008600867245ULL, 0x002fe4000020d400ULL, 0x0000008f8e00720bULL, 0x000fca0003f7d000ULL,
0x0000005b005f7306ULL, 0x000e620000205400ULL, 0x000000888d00720bULL, 0x004fe40003f3d000ULL,
0x00000018ff887819ULL, 0x000fe40000011458ULL, 0x000000919e58723eULL, 0x000fe400000010ffULL,
0x00000018ff917819ULL, 0x000fe20000011455ULL, 0x0000008200627306ULL, 0x000fe20000209400ULL,
0x000000016e6e3812ULL, 0x000fca00078efcffULL, 0x0000000186861812ULL, 0x000fe400078efcffULL,
0x0000008200617306ULL, 0x0004e20000205400ULL, 0x0000005f5e00720bULL, 0x002fe40003fbd000ULL,
0x0000005c285c723cULL, 0x000fea0000041804ULL, 0x0000009d00567306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x004fc4000020d400ULL, 0x000000e38c05723eULL, 0x000fca00000010ffULL,
0x0000009d009f7306ULL, 0x000e620000205400ULL, 0x000000616200720bULL, 0x008fe40003f9d000ULL,
0x000000e02860723cULL, 0x000fea000004181cULL, 0x000000e600a07306ULL, 0x000fe40000209400ULL,
0x00000085b81c723eULL, 0x000fc400000010ffULL, 0x0000005b00857245ULL, 0x000fe4000020d400ULL,
0x00000081981d723eULL, 0x000fe200000010ffULL, 0x000000582858723cULL, 0x040fe20000041808ULL,
0x000000e6008f7306ULL, 0x000ea20000205400ULL, 0x0000009f5600720bULL, 0x002fe40003f3d000ULL,
0x0000000185855812ULL, 0x000fe400078efcffULL, 0x000000808300720bULL, 0x000fe40003fbd000ULL,
0x0000009d00807245ULL, 0x000fe2000020d400ULL, 0x0000008b008e7306ULL, 0x000fe20000209400ULL,
0x000000e600817245ULL, 0x000fe2000020d400ULL, 0x0000001c281c723cULL, 0x000fe2000004180cULL,
0x0000000182824812ULL, 0x000fc400078efcffULL, 0x0000007b7c00720bULL, 0x000fe40003f9d000ULL,
0x0000000180801812ULL, 0x000fe200078efcffULL, 0x0000008b008d7306ULL, 0x0002e20000205400ULL,
0x0000008fa000720bULL, 0x004fe40003f3d000ULL, 0x00000018ff7b7819ULL, 0x000fe40000011454ULL,
0x0000007e977c723eULL, 0x000fe400000010ffULL, 0x00000079ea09723eULL, 0x000fe200000010ffULL,
0x0000007600787306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x002fc4000020d400ULL,
0x000000939456723eULL, 0x000fe400000010ffULL, 0x000000738a0c723eULL, 0x000fe400000010ffULL,
0x0000000181811812ULL, 0x000fe200078efcffULL, 0x0000007600777306ULL, 0x0002a20000205400ULL,
0x0000008d8e00720bULL, 0x008fe20003fdd000ULL, 0x000000562854723cULL, 0x000fe20000041810ULL,
0x00000074db0d723eULL, 0x000fe400000010ffULL, 0x0000000169695812ULL, 0x000fc400078efcffULL,
0x000000016a6a4812ULL, 0x000fe200078efcffULL, 0x0000007100727306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fe2000020d400ULL, 0x0000007c2810723cULL, 0x000fe20000041814ULL,
0x0000007ae708723eULL, 0x000fe400000010ffULL, 0x0000006d8080723eULL, 0x000fe400000010ffULL,
0x000000018b8b6812ULL, 0x000fe200078efcffULL, 0x0000007100757306ULL, 0x000e620000205400ULL,
0x000000777800720bULL, 0x004fe20003f3d000ULL, 0x000000081808723cULL, 0x000fe20000041864ULL,
0x0000007100167245ULL, 0x000fc4000020d400ULL, 0x0000008800157245ULL, 0x000fe4000020d400ULL,
0x000000858229723eULL, 0x000fe200000010ffULL, 0x0000008800877306ULL, 0x000fe20000209400ULL,
0x0000007f00857245ULL, 0x000fe4000020d400ULL, 0x000000d98628723eULL, 0x000fe400000010ffULL,
0x0000006e8181723eULL, 0x000fe400000010ffULL, 0x0000000176761812ULL, 0x000fe200078efcffULL,
0x0000008800047306ULL, 0x000ea20000205400ULL, 0x000000757200720bULL, 0x002fe20003fdd000ULL,
0x000000281828723cULL, 0x040fec0000041858ULL, 0x0000009100987306ULL, 0x000fe40000209400ULL,
0x00000080181c723cULL, 0x000fe8000004181cULL, 0x0000000116166812ULL, 0x000fc400078efcffULL,
0x00000091000f7306ULL, 0x000e620000205400ULL, 0x000000048700720bULL, 0x004fe40003f7d000ULL,
0x000000908904723eULL, 0x000fca00000010ffULL, 0x0000007b007e7306ULL, 0x000fe40000209400ULL,
0x000000041804723cULL, 0x040fe80000041860ULL, 0x0000000115153812ULL, 0x000fe400078efcffULL,
0x0000007b00797306ULL, 0x000ea20000205400ULL, 0x0000000f9800720bULL, 0x002fe40003f3d000ULL,
0x0000000c180c723cULL, 0x000fe2000004185cULL, 0x000000151615723eULL, 0x000fc800000010ffULL,
0x0000000000707306ULL, 0x000fe40000209400ULL, 0x00000091005c7245ULL, 0x000fe4000020d400ULL,
0x0000007b005d7245ULL, 0x000fe4000020d400ULL, 0x000000015c5c1812ULL, 0x000fe400078efcffULL,
0x00000000006f7306ULL, 0x000e620000205400ULL, 0x000000797e00720bULL, 0x004fe40003fdd000ULL,
0x000000695c5c723eULL, 0x000fca00000010ffULL, 0x00000068006c7306ULL, 0x000fec0000209400ULL,
0x000000015d5d6812ULL, 0x000fe400078efcffULL, 0x00000068006b7306ULL, 0x0004e20000205400ULL,
0x0000006f7000720bULL, 0x002fe40003f7d000ULL, 0x0000006a5d5d723eULL, 0x000fca00000010ffULL,
0x0000008400147306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x004fe2000020d400ULL,
0x0000005c1810723cULL, 0x000fec0000041810ULL, 0x0000008400177306ULL, 0x0002a20000205400ULL,
0x0000006b6c00720bULL, 0x008fce0003f3d000ULL, 0x0000007f00607306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x002fca000020d400ULL, 0x0000000168681812ULL, 0x000fe400078efcffULL,
0x0000007f005f7306ULL, 0x000e620000205400ULL, 0x000000171400720bULL, 0x004fe40003fbd000ULL,
0x0000008b7614723eULL, 0x000fce00000010ffULL, 0x000000141814723cULL, 0x000fe80000041854ULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x0000005f6000720bULL, 0x002fe40003fdd000ULL,
0x0000000000557245ULL, 0x000fc8000020d400ULL, 0x0000000155553812ULL, 0x000fc800078efcffULL,
0x000000845584723eULL, 0x000fc600000010ffULL, 0x0000000185856812ULL, 0x000fc800078efcffULL,
0x000000856885723eULL, 0x000fce00000010ffULL, 0x000000841818723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000207305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000200000735dULL, 0x004fe40003800000ULL,
0x01065c00ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000008024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff5b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff597819ULL, 0x000fc40000011626ULL, 0x0000000003217217ULL, 0x000fe20007800000ULL,
0x0000620027577a24ULL, 0x000fc800078e0200ULL, 0x0000000121217824ULL, 0x000fe400078e0a00ULL,
0x0000000133207824ULL, 0x100fe400078e0257ULL, 0x0000000136227824ULL, 0x100fe200078e0257ULL,
0x0000002021237807ULL, 0x000fe20000000000ULL, 0x0000000138547824ULL, 0x000fe400078e0257ULL,
0x00005e0020207625ULL, 0x000fe200078e005bULL, 0x000000232c557217ULL, 0x000fc60007800000ULL,
0x00005e0022227625ULL, 0x000fe200078e005bULL, 0x0000003420567210ULL, 0x000fc60007f3e0ffULL,
0x0000000155007824ULL, 0x000fe200078e0a2cULL, 0x0000003422227210ULL, 0x000fe20007f9e0ffULL,
0x00005e0054547625ULL, 0x000fc600078e005bULL, 0x000000003500720cULL, 0x000fe20003f66070ULL,
0x000000013a207824ULL, 0x000fe200078e0257ULL, 0x0000003454547210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff577224ULL, 0x000fe200008e0621ULL, 0x000000005900720cULL, 0x000fe20003f26070ULL,
0x00005e0020207625ULL, 0x000fc800078e005bULL, 0x000000ffff237224ULL, 0x000fe200020e0623ULL,
0x000000003700720cULL, 0x080fe20003f86070ULL, 0x000000ffff557224ULL, 0x000fe200028e0655ULL,
0x000000003900720cULL, 0x000fe40003fa6070ULL, 0x0000003420207210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000564b7faeULL, 0x0003e4000c901c46ULL,
0x000000ffff217224ULL, 0x000fe400030e0621ULL, 0x00000000224c7faeULL, 0x0003e8000d901c46ULL,
0x00000000544d7faeULL, 0x0003e8000e101c46ULL, 0x00000000204e7faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff007984ULL, 0x000ea20000000800ULL,
0x8000000052217824ULL, 0x002fca00078e00ffULL, 0x8000000000ff7812ULL, 0x004fe20007824821ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000052217824ULL, 0x000fe400078e00ffULL,
0x0000000000207305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000200000735dULL, 0x004fe40003800000ULL, 0x01065400ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fc40007824821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000004f54783bULL, 0x000e680000004200ULL,
0x000000005058783bULL, 0x000ea80000004200ULL, 0x000000003c5c783bULL, 0x000ee80000004200ULL,
0x000000005120783bULL, 0x000f220000004200ULL, 0x0000010054db7824ULL, 0x042fe200078e00ffULL,
0x0000005400bf7306ULL, 0x000fe20000009400ULL, 0x0000010055e37824ULL, 0x040fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe20000011455ULL, 0x0001000054e87824ULL, 0x000fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x0001000055dd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe37819ULL, 0x000fe200000114e3ULL, 0x0000010058c87824ULL, 0x044fe200078e00ffULL,
0x000000db00807306ULL, 0x000fe20000209400ULL, 0x00000018ffe87819ULL, 0x000fe200000114e8ULL,
0x0001000057c97824ULL, 0x000fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fe20000011454ULL,
0x0001000058ce7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe20000011456ULL,
0x0000010059c77824ULL, 0x000fe200078e00ffULL, 0x00000018ffdd7819ULL, 0x000fe200000114ddULL,
0x000000db009f7306ULL, 0x0002a20000205400ULL, 0x00000018ff607819ULL, 0x008fe2000001145fULL,
0x0000010020c17824ULL, 0x050fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x0001000020eb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010021ec7824ULL, 0x040fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x0000005400be7306ULL, 0x000ee20000005400ULL, 0x000000db00db7245ULL, 0x002fe2000020d400ULL,
0x0001000021e47824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fe20000011457ULL,
0x0001000023c37824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe200000114c7ULL,
0x0001000059d47824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe20000011459ULL,
0x000000e300e97306ULL, 0x000fe20000209400ULL, 0x0000009f8000720bULL, 0x004fe20003f9d000ULL,
0x000001005f807824ULL, 0x000fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe20000011420ULL,
0x000100005ba47824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011421ULL,
0x000100005aa17824ULL, 0x000fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fe2000001145aULL,
0x000000e300ea7306ULL, 0x000e620000205400ULL, 0x000000bebf00720bULL, 0x008fe20003fdd000ULL,
0x0001000022bf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe20000011422ULL,
0x000100005ccf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011423ULL,
0x000001005e9f7824ULL, 0x000fe200078e00ffULL, 0x00000001dbdb4812ULL, 0x000fe200078efcffULL,
0x000000e800ab7306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fc40000011458ULL,
0x00000018ffd47819ULL, 0x000fe400000114d4ULL, 0x00000018ffa47819ULL, 0x000fe400000114a4ULL,
0x00000018ffa17819ULL, 0x000fe200000114a1ULL, 0x000000e800c47306ULL, 0x000ea20000205400ULL,
0x000000eae900720bULL, 0x002fe40003f9d000ULL, 0x00000018ff9d7819ULL, 0x000fe4000001145bULL,
0x00000018ff6c7819ULL, 0x000fc4000001145cULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000005400847306ULL, 0x0002e2000000d400ULL, 0x00000018ff007819ULL, 0x000fe4000001145eULL,
0x00000018ff657819ULL, 0x000fe4000001145dULL, 0x00000018ffbf7819ULL, 0x000fe400000114bfULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000000ba00e27306ULL, 0x000fe20000209400ULL,
0x000000c4ab00720bULL, 0x004fe20003f3d000ULL, 0x0000010057547824ULL, 0x002fe200078e00ffULL,
0x00000018ffe47819ULL, 0x000fe200000114e4ULL, 0x000001005cc47824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x000100005dab7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x000000ba00e17306ULL, 0x0002a20000205400ULL,
0x0000000184846812ULL, 0x008fc400078efcffULL, 0x00000018ffc47819ULL, 0x000fe400000114c4ULL,
0x00000018ffab7819ULL, 0x000fe400000114abULL, 0x00000018ff9f7819ULL, 0x000fe2000001149fULL,
0x000000de00787306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x002fe4000020d400ULL,
0x00000018ff807819ULL, 0x000fca0000011480ULL, 0x000000de007b7306ULL, 0x0002e20000205400ULL,
0x000000e1e200720bULL, 0x004fe40003fdd000ULL, 0x000000e300e27245ULL, 0x000fc8000020d400ULL,
0x00000001e2e24812ULL, 0x000fe200078efcffULL, 0x0000005500dc7306ULL, 0x000fe20000009400ULL,
0x000000de00de7245ULL, 0x002fca000020d400ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x0000005500e77306ULL, 0x000e620000005400ULL, 0x0000007b7800720bULL, 0x008fe20003fbd000ULL,
0x000100005f787824ULL, 0x000fe400078e00ffULL, 0x000100005e7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000005500897306ULL, 0x0004e2000000d400ULL,
0x00000018ff7b7819ULL, 0x000fca000001147bULL, 0x00000001dede5812ULL, 0x000fe400078efcffULL,
0x0000005600bd7306ULL, 0x000fe20000009400ULL, 0x0000010056557824ULL, 0x004fe200078e00ffULL,
0x000000e7dc00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005600bc7306ULL, 0x000e6e0000005400ULL, 0x0000000189893812ULL, 0x008fe200078efcffULL,
0x0000005600817306ULL, 0x0004f0000000d400ULL, 0x000000dd00e57306ULL, 0x000fe20000209400ULL,
0x0001000056567824ULL, 0x004fe200078e00ffULL, 0x000000bcbd00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x000000dd00e67306ULL, 0x0003ee0000205400ULL,
0x0000000181814812ULL, 0x008fe200078efcffULL, 0x0000005600c27306ULL, 0x000fe20000209400ULL,
0x000000dd00dd7245ULL, 0x002fce000020d400ULL, 0x0000005600cd7306ULL, 0x000e700000205400ULL,
0x0000005500df7306ULL, 0x000ff00000209400ULL, 0x0000005500e07306ULL, 0x000ea20000205400ULL,
0x000000cdc200720bULL, 0x002fce0003fdd000ULL, 0x0000005f00757306ULL, 0x000ff00000009400ULL,
0x0000005f00747306ULL, 0x000fe20000005400ULL, 0x000000e0df00720bULL, 0x004fe40003fbd000ULL,
0x00000018ffdf7819ULL, 0x000fca00000114ebULL, 0x0000005f00627306ULL, 0x0003f0000000d400ULL,
0x0000005800b97306ULL, 0x000fe20000009400ULL, 0x000000e8005f7245ULL, 0x002fc8000020d400ULL,
0x000000015f5f1812ULL, 0x000fe400078efcffULL, 0x000000e6e500720bULL, 0x000fe20003f3d000ULL,
0x0000005800ac7306ULL, 0x000e700000005400ULL, 0x0000005400c07306ULL, 0x000fe80000209400ULL,
0x00000001dddd1812ULL, 0x000fc800078efcffULL, 0x0000005400d97306ULL, 0x000ea20000205400ULL,
0x000000acb900720bULL, 0x002fe40003f9d000ULL, 0x0000005600ac7245ULL, 0x000fc8000020d400ULL,
0x00000001acac6812ULL, 0x000fe200078efcffULL, 0x0000005700b87306ULL, 0x000ff00000009400ULL,
0x0000005700bb7306ULL, 0x000e620000005400ULL, 0x000000d9c000720bULL, 0x004fce0003f7d000ULL,
0x000000c800ca7306ULL, 0x000ff00000209400ULL, 0x000000c800c57306ULL, 0x0004e20000205400ULL,
0x000000bbb800720bULL, 0x002fe40003f3d000ULL, 0x0000005500b87245ULL, 0x000fc8000020d400ULL,
0x00000001b8b85812ULL, 0x000fe200078efcffULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x000000c800c87245ULL, 0x004fe4000020d400ULL, 0x00000081b8b8723eULL, 0x000fca00000010ffULL,
0x000000b500af7306ULL, 0x0002a20000205400ULL, 0x000000c5ca00720bULL, 0x008fce0003fdd000ULL,
0x000000c900cb7306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x00000001c8c86812ULL, 0x000fe400078efcffULL, 0x000000c900cc7306ULL, 0x0002e20000205400ULL,
0x000000afb600720bULL, 0x004fe40003fbd000ULL, 0x0000005400b67245ULL, 0x000fe4000020d400ULL,
0x0000a8003d547811ULL, 0x000fe400078e20ffULL, 0x00000001b6b63812ULL, 0x000fe200078efcffULL,
0x000000ce00d17306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fca000020d400ULL,
0x00000001b5b55812ULL, 0x000fe400078efcffULL, 0x000000ce00d87306ULL, 0x0002a20000205400ULL,
0x000000cccb00720bULL, 0x008fce0003f7d000ULL, 0x00000057007f7306ULL, 0x000ee2000000d400ULL,
0x000000ce00ce7245ULL, 0x002fca000020d400ULL, 0x00000001c9c93812ULL, 0x000fe400078efcffULL,
0x000000b300b77306ULL, 0x000fe20000209400ULL, 0x000000d8d100720bULL, 0x004fce0003fdd000ULL,
0x000000b300aa7306ULL, 0x000e620000205400ULL, 0x000000017f7f1812ULL, 0x008fc800078efcffULL,
0x0000007fb6b9723eULL, 0x000fe400000010ffULL, 0x00000001cece6812ULL, 0x000fe200078efcffULL,
0x0000005900b47306ULL, 0x000fe20000009400ULL, 0x000000c3007f7245ULL, 0x000fce000020d400ULL,
0x0000005900a37306ULL, 0x000ea20000005400ULL, 0x000000aab700720bULL, 0x002fe40003f3d000ULL,
0x000000b300aa7245ULL, 0x000fca000020d400ULL, 0x00000058007d7306ULL, 0x0002ec000000d400ULL,
0x00000001aaaa1812ULL, 0x000fe400078efcffULL, 0x0000005a00b17306ULL, 0x000fe20000009400ULL,
0x000000a3b400720bULL, 0x004fe20003f7d000ULL, 0x000001005a587824ULL, 0x002fe200078e00ffULL,
0x000000b000a37245ULL, 0x000fc8000020d400ULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000005a00a67306ULL, 0x000e620000005400ULL, 0x000000017d7d4812ULL, 0x008fce00078efcffULL,
0x000000c700577306ULL, 0x000ff00000209400ULL, 0x000000c700d07306ULL, 0x0004e20000205400ULL,
0x000000a6b100720bULL, 0x002fe40003f9d000ULL, 0x00000032ffb1723eULL, 0x000fc800000010ffULL,
0x00005410b1b17816ULL, 0x000fe200000000b1ULL, 0x0000008a00a87306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x004fce000020d400ULL, 0x0000008a00ad7306ULL, 0x000e620000205400ULL,
0x000000d05700720bULL, 0x008fe40003fbd000ULL, 0x000000005454783bULL, 0x000fea0000000200ULL,
0x0000002000867306ULL, 0x000fec0000009400ULL, 0x00000001c7c75812ULL, 0x000fc400078efcffULL,
0x0000002000977306ULL, 0x000fe20000005400ULL, 0x000000ada800720bULL, 0x002fce0003fdd000ULL,
0x0000002000707306ULL, 0x0003f0000000d400ULL, 0x00000059007c7306ULL, 0x0004e2000000d400ULL,
0x0000010022207824ULL, 0x002fca00078e00ffULL, 0x00000018ffb37819ULL, 0x000fe40000011420ULL,
0x0000005b00b27306ULL, 0x000fe20000009400ULL, 0x0000a8003e207811ULL, 0x000fe200078e20ffULL,
0x000001005b597824ULL, 0x004fca00078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000005b00a77306ULL, 0x000e620000005400ULL, 0x000000017c7c3812ULL, 0x008fce00078efcffULL,
0x0000002100967306ULL, 0x000ff00000009400ULL, 0x0000002100877306ULL, 0x000fe20000005400ULL,
0x000000a7b200720bULL, 0x002fe40003f7d000ULL, 0x0000008a00a77245ULL, 0x000fc4000020d400ULL,
0x00000058008a7245ULL, 0x000fe4000020d400ULL, 0x00000001a7a76812ULL, 0x000fe200078efcffULL,
0x00000021006d7306ULL, 0x0003f0000000d400ULL, 0x0000002200857306ULL, 0x000fe20000009400ULL,
0x0000010023217824ULL, 0x002fca00078e00ffULL, 0x00000018ffa67819ULL, 0x000fe40000011421ULL,
0x0000002200907306ULL, 0x000fe40000005400ULL, 0x000000a600817245ULL, 0x000fcc000020d400ULL,
0x00000022006b7306ULL, 0x000ff0000000d400ULL, 0x0000002300a07306ULL, 0x000ff00000009400ULL,
0x00000023008b7306ULL, 0x000ff00000005400ULL, 0x00000023006a7306ULL, 0x0003f0000000d400ULL,
0x00000094008e7306ULL, 0x000fe20000209400ULL, 0x000000002020783bULL, 0x002fee0000000200ULL,
0x0000009400957306ULL, 0x0002b00000205400ULL, 0x000000b000a97306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fce000020d400ULL, 0x000000b000ae7306ULL, 0x0002e20000205400ULL,
0x000000958e00720bULL, 0x004fe40003fdd000ULL, 0x00000059008e7245ULL, 0x000fca000020d400ULL,
0x0000005800d57306ULL, 0x000fe20000209400ULL, 0x00000002ffb07819ULL, 0x002fca0000011626ULL,
0x00001fb0b1957589ULL, 0x000e6200000e0000ULL, 0x0000000194946812ULL, 0x000fe200078efcffULL,
0x0000005800d67306ULL, 0x0005220000205400ULL, 0x000000aea900720bULL, 0x008fe40003f3d000ULL,
0x000000908500720bULL, 0x000fca0003fdd000ULL, 0x000000d400d77306ULL, 0x000fe20000209400ULL,
0x00001f3bb1587589ULL, 0x004eaa00000e0000ULL, 0x00000001a3a31812ULL, 0x000fe400078efcffULL,
0x000000d400d27306ULL, 0x0007620000205400ULL, 0x000000d6d500720bULL, 0x010fe40003f3d000ULL,
0x000000016b6b6812ULL, 0x000fe200078efcffULL, 0x000000955454a231ULL, 0x002fc800003400ffULL,
0x000000df00bc7306ULL, 0x000fe20000209400ULL, 0x000000955656a231ULL, 0x080fe200003400ffULL,
0x000000d400d47245ULL, 0x008fe2000020d400ULL, 0x000000952020a231ULL, 0x080fe400003400ffULL,
0x000000952222a231ULL, 0x000fe200003400ffULL, 0x000000018a8a1812ULL, 0x000fe400078efcffULL,
0x000000df00bb7306ULL, 0x0002e20000205400ULL, 0x000000d2d700720bULL, 0x020fe20003fbd000ULL,
0x000000585555a231ULL, 0x004fc400003400ffULL, 0x000000585757a231ULL, 0x080fe400003400ffULL,
0x000000582121a231ULL, 0x080fe400003400ffULL, 0x0000005900d37306ULL, 0x000fe20000209400ULL,
0x000000582323a231ULL, 0x000fe200003400ffULL, 0x000000df00df7245ULL, 0x002fe4000020d400ULL,
0x0000005fde58723eULL, 0x000fe400000010ffULL, 0x00000001d4d45812ULL, 0x000fc400078efcffULL,
0x0000005900da7306ULL, 0x0002a20000205400ULL, 0x000000bbbc00720bULL, 0x008fce0003f5d000ULL,
0x000000b300b47306ULL, 0x000fe20000209400ULL, 0x000000ddba59723eULL, 0x002fca00000010ffULL,
0x00000001dfdf2812ULL, 0x000fe400078efcffULL, 0x000000b300a97306ULL, 0x000e620000205400ULL,
0x000000dad300720bULL, 0x004fce0003fbd000ULL, 0x0000005b00717306ULL, 0x000eac000000d400ULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x000000a4005b7306ULL, 0x000fe20000209400ULL,
0x000000a9b400720bULL, 0x002fce0003f5d000ULL, 0x000000a400be7306ULL, 0x0002e20000205400ULL,
0x0000000171713812ULL, 0x004fe400078efcffULL, 0x000000978600720bULL, 0x000fca0003f7d000ULL,
0x0000005a00777306ULL, 0x000ea2000000d400ULL, 0x000000a400a47245ULL, 0x002fce000020d400ULL,
0x000000a1005a7306ULL, 0x000fe20000209400ULL, 0x000000be5b00720bULL, 0x008fe40003fbd000ULL,
0x0000000170703812ULL, 0x000fe400078efcffULL, 0x0000008ba000720bULL, 0x000fe40003f7d000ULL,
0x000000718e8b723eULL, 0x000fe200000010ffULL, 0x000000a100a57306ULL, 0x0002e20000205400ULL,
0x0000000177774812ULL, 0x004fc800078efcffULL, 0x000000778a8a723eULL, 0x000fe400000010ffULL,
0x00000001a4a45812ULL, 0x000fe200078efcffULL, 0x0000009d008f7306ULL, 0x000fe20000209400ULL,
0x000000a100a17245ULL, 0x002fe4000020d400ULL, 0x000000016a6a3812ULL, 0x000fca00078efcffULL,
0x0000009d008c7306ULL, 0x0002a20000205400ULL, 0x000000a55a00720bULL, 0x008fe40003f3d000ULL,
0x000000585458723cULL, 0x040fea0000041804ULL, 0x000000a600ae7306ULL, 0x000fe20000209400ULL,
0x0000009d009d7245ULL, 0x002fe4000020d400ULL, 0x000000b85404723cULL, 0x000fe6000004180cULL,
0x00000001a1a11812ULL, 0x000fc400078efcffULL, 0x000000a600ad7306ULL, 0x000e620000205400ULL,
0x0000008c8f00720bULL, 0x004fe40003f9d000ULL, 0x000000879600720bULL, 0x000fe40003f3d000ULL,
0x0000009800877245ULL, 0x000fe4000020d400ULL, 0x0000007dc80c723eULL, 0x000fe200000010ffULL,
0x0000005c00887306ULL, 0x000fe20000009400ULL, 0x0000007cc70d723eULL, 0x000fe400000010ffULL,
0x000000a19494723eULL, 0x000fc600000010ffULL, 0x000000019d9d4812ULL, 0x000fe400078efcffULL,
0x0000005c008d7306ULL, 0x000fe20000005400ULL, 0x000000016d6d1812ULL, 0x000fe200078efcffULL,
0x0000000c540c723cULL, 0x000fec000004181cULL, 0x0000005c00667306ULL, 0x0005f0000000d400ULL,
0x0000005e009a7306ULL, 0x000fe20000009400ULL, 0x000001005d5c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff857819ULL, 0x000fe4000001145cULL, 0x0000005e00997306ULL, 0x000fe20000005400ULL,
0x00000084db5c723eULL, 0x000fe400000010ffULL, 0x000000b300847245ULL, 0x000fc8000020d400ULL,
0x0000000184842812ULL, 0x000fe200078efcffULL, 0x0000005e00617306ULL, 0x0005e2000000d400ULL,
0x000000adae00720bULL, 0x002fe40003f5d000ULL, 0x0000006b8484723eULL, 0x000fca00000010ffULL,
0x0000005d009b7306ULL, 0x000fe20000009400ULL, 0x00000018ff5e7819ULL, 0x004fc800000114ecULL,
0x0000005e00867245ULL, 0x000fe4000020d400ULL, 0x0000000181812812ULL, 0x000fe200078efcffULL,
0x0000005d00927306ULL, 0x000ff00000005400ULL, 0x0000005d00637306ULL, 0x000ff0000000d400ULL,
0x000000c100c67306ULL, 0x000ff00000209400ULL, 0x000000c1005d7306ULL, 0x0002b00000205400ULL,
0x0000007e00827306ULL, 0x000fe20000209400ULL, 0x000000c100c17245ULL, 0x002fce000020d400ULL,
0x0000007e00837306ULL, 0x0002e20000205400ULL, 0x0000005dc600720bULL, 0x004fe40003fbd000ULL,
0x00000089e25d723eULL, 0x000fca00000010ffULL, 0x0000005e00dc7306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fca000020d400ULL, 0x00000001c1c15812ULL, 0x000fe400078efcffULL,
0x0000005e00e17306ULL, 0x0002a20000205400ULL, 0x000000838200720bULL, 0x008fe40003fdd000ULL,
0x00000070c170723eULL, 0x000fca00000010ffULL, 0x000000bf00a87306ULL, 0x000fe20000209400ULL,
0x0000005c545c723cULL, 0x002fea0000041808ULL, 0x000000017e7e6812ULL, 0x000fe400078efcffULL,
0x000000bf00a57306ULL, 0x0002e20000205400ULL, 0x000000e1dc00720bULL, 0x004fe40003f9d000ULL,
0x000000acb508723eULL, 0x000fc400000010ffULL, 0x000000c9aa09723eULL, 0x000fc600000010ffULL,
0x000000c3008c7306ULL, 0x000fe20000209400ULL, 0x000000bf00bf7245ULL, 0x002fc6000020d400ULL,
0x000000085408723cULL, 0x040fe40000041828ULL, 0x0000000186864812ULL, 0x000fe400078efcffULL,
0x000000c3008f7306ULL, 0x000e620000205400ULL, 0x000000a5a800720bULL, 0x008fe40003f5d000ULL,
0x000000cea328723eULL, 0x000fe400000010ffULL, 0x000000d4a729723eULL, 0x000fe400000010ffULL,
0x0000006d8671723eULL, 0x000fe200000010ffULL, 0x0000009c00a27306ULL, 0x000fe80000209400ULL,
0x000000285428723cULL, 0x000fe40000041814ULL, 0x00000001bfbf2812ULL, 0x000fc400078efcffULL,
0x0000009c00917306ULL, 0x0004e20000205400ULL, 0x0000008f8c00720bULL, 0x002fe40003f7d000ULL,
0x000000bf7e7e723eULL, 0x000fe200000010ffULL, 0x0000008a5414723cULL, 0x000fe80000041810ULL,
0x000000e400af7306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x004fe4000020d400ULL,
0x0000008500107245ULL, 0x000fc4000020d400ULL, 0x000000ab00117245ULL, 0x000fe4000020d400ULL,
0x000000017f7f3812ULL, 0x000fe200078efcffULL, 0x000000e400c07306ULL, 0x0002a20000205400ULL,
0x00000091a200720bULL, 0x008fe40003fbd000ULL, 0x000000747500720bULL, 0x000fe40003f7d000ULL,
0x000000c400757245ULL, 0x000fe4000020d400ULL, 0x0000006500127245ULL, 0x000fe2000020d400ULL,
0x000000c400907306ULL, 0x000fe20000209400ULL, 0x000000e400e47245ULL, 0x002fca000020d400ULL,
0x000000019c9c5812ULL, 0x000fe400078efcffULL, 0x000000c400957306ULL, 0x000e620000205400ULL,
0x000000c0af00720bULL, 0x004fe40003f9d000ULL, 0x0000008d8800720bULL, 0x000fe40003fbd000ULL,
0x000000df9c1c723eULL, 0x000fe400000010ffULL, 0x0000000162623812ULL, 0x000fe200078efcffULL,
0x00000076007a7306ULL, 0x000fec0000209400ULL, 0x00000001e4e44812ULL, 0x000fc400078efcffULL,
0x0000007600797306ULL, 0x0004e20000205400ULL, 0x000000959000720bULL, 0x002fe40003fdd000ULL,
0x000000929b00720bULL, 0x000fe40003f9d000ULL, 0x000000a49d95723eULL, 0x000fe400000010ffULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x00000098009e7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x004fc6000020d400ULL, 0x000000945454723cULL, 0x000fe40000041818ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x0000009800937306ULL, 0x000e620000205400ULL,
0x000000797a00720bULL, 0x008fe40003f5d000ULL, 0x0000000163634812ULL, 0x000fe200078efcffULL,
0x000000702018723cULL, 0x000fe2000004185cULL, 0x000000667566723eULL, 0x000fc600000010ffULL,
0x0000008500917306ULL, 0x000fec0000209400ULL, 0x0000000176762812ULL, 0x000fe400078efcffULL,
0x0000008500967306ULL, 0x0004e20000205400ULL, 0x000000939e00720bULL, 0x002fe40003f3d000ULL,
0x0000007f767f723eULL, 0x000fca00000010ffULL, 0x0000006c00727306ULL, 0x000fe20000209400ULL,
0x0000006a8185723eULL, 0x004fe200000010ffULL, 0x0000007e2008723cULL, 0x040fe80000041808ULL,
0x0000000187871812ULL, 0x000fe400078efcffULL, 0x0000006c00737306ULL, 0x0002a20000205400ULL,
0x000000969100720bULL, 0x008fe20003fdd000ULL, 0x000000842004723cULL, 0x000fe20000041804ULL,
0x000000e4871d723eULL, 0x000fc400000010ffULL, 0x000000999a00720bULL, 0x000fc60003f3d000ULL,
0x00000065006f7306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fe2000020d400ULL,
0x0000001c201c723cULL, 0x000fe80000041858ULL, 0x0000000110106812ULL, 0x000fe400078efcffULL,
0x00000065006e7306ULL, 0x000e620000205400ULL, 0x000000737200720bULL, 0x004fe40003f5d000ULL,
0x0000009f00587245ULL, 0x000fc4000020d400ULL, 0x0000000161611812ULL, 0x000fc600078efcffULL,
0x000000cf00887306ULL, 0x000fec0000209400ULL, 0x000000016c6c2812ULL, 0x000fe400078efcffULL,
0x000000cf00897306ULL, 0x0004e20000205400ULL, 0x0000006e6f00720bULL, 0x002fce0003fbd000ULL,
0x000000ab00827306ULL, 0x000fe20000209400ULL, 0x000000cf00cf7245ULL, 0x004fca000020d400ULL,
0x0000000112125812ULL, 0x000fe400078efcffULL, 0x000000ab00837306ULL, 0x000e620000205400ULL,
0x000000898800720bULL, 0x008fce0003fdd000ULL, 0x0000009f007c7306ULL, 0x000fec0000209400ULL,
0x00000001cfcf6812ULL, 0x000fe400078efcffULL, 0x0000009f00797306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003f9d000ULL, 0x0000006000647306ULL, 0x000fec0000209400ULL,
0x0000000111114812ULL, 0x000fe400078efcffULL, 0x0000006000677306ULL, 0x0002e20000205400ULL,
0x000000797c00720bULL, 0x004fe40003f5d000ULL, 0x000000111211723eULL, 0x000fca00000010ffULL,
0x0000008000747306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x002fca000020d400ULL,
0x0000000158582812ULL, 0x000fe400078efcffULL, 0x0000008000737306ULL, 0x000e620000205400ULL,
0x000000676400720bULL, 0x008fe40003f9d000ULL, 0x000000631067723eULL, 0x000fe400000010ffULL,
0x000000cf6c10723eULL, 0x000fe400000010ffULL, 0x000000615858723eULL, 0x000fe200000010ffULL,
0x0000000000687306ULL, 0x000fe40000209400ULL, 0x00000066200c723cULL, 0x000fe8000004180cULL,
0x0000000160604812ULL, 0x000fc400078efcffULL, 0x0000000000697306ULL, 0x0004e20000205400ULL,
0x000000737400720bULL, 0x002fce0003fbd000ULL, 0x0000007b00137306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x004fce000020d400ULL, 0x0000007b006e7306ULL, 0x0002a20000205400ULL,
0x000000696800720bULL, 0x008fce0003fdd000ULL, 0x00000078005c7306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x0000007800597306ULL, 0x000e620000205400ULL, 0x0000006e1300720bULL, 0x004fe40003f5d000ULL,
0x000000102010723cULL, 0x000fee0000041828ULL, 0x0000007800297245ULL, 0x000fc8000020d400ULL,
0x000000017b7b2812ULL, 0x000fe400078efcffULL, 0x000000595c00720bULL, 0x002fe40003f3d000ULL,
0x0000008000597245ULL, 0x000fe4000020d400ULL, 0x0000007b0028723eULL, 0x000fe400000010ffULL,
0x0000000159595812ULL, 0x000fc800078efcffULL, 0x000000625959723eULL, 0x000fc600000010ffULL,
0x0000000129291812ULL, 0x000fc800078efcffULL, 0x000000296029723eULL, 0x000fe200000010ffULL,
0x000000582014723cULL, 0x040ff00000041814ULL, 0x000000282020723cULL, 0x000fe20000041854ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008024007811ULL, 0x000fe200078e40ffULL, 0x01062000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff53ff7812ULL, 0x000fc4000784c0ffULL, 0x000000000300720cULL, 0x000fe40003f24070ULL,
0x00000001ff647807ULL, 0x000fd60005000000ULL, 0x0000953000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01065c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000a024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff5b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff597819ULL, 0x000fe40000011626ULL, 0x0000000003297217ULL, 0x000fe20007800000ULL,
0x0000620027557a24ULL, 0x000fc800078e0200ULL, 0x0000000129297824ULL, 0x000fe400078e0a00ULL,
0x0000000133287824ULL, 0x100fe400078e0255ULL, 0x00000001362a7824ULL, 0x000fe200078e0255ULL,
0x00000020292b7807ULL, 0x000fe20000000000ULL, 0x00005e0028287625ULL, 0x000fc600078e005bULL,
0x0000002b2c577217ULL, 0x000fe20007800000ULL, 0x00005e002a2a7625ULL, 0x000fe200078e005bULL,
0x0000003428567210ULL, 0x000fc60007f3e0ffULL, 0x0000000157007824ULL, 0x000fe200078e0a2cULL,
0x000000342a2a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000138287824ULL, 0x100fe400078e0255ULL,
0x000000013a557824ULL, 0x000fe200078e0255ULL, 0x000000005900720cULL, 0x080fe20003f46070ULL,
0x000000ffff577224ULL, 0x000fe200008e0629ULL, 0x000000003500720cULL, 0x080fe20003f26070ULL,
0x00005e0028287625ULL, 0x000fe200078e005bULL, 0x000000003900720cULL, 0x000fc60003f86070ULL,
0x00005e0055547625ULL, 0x000fe200078e005bULL, 0x0000003428287210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e062bULL, 0x000000003700720cULL, 0x000fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x0000003454547210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000563f7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff557224ULL, 0x000fe200030e0655ULL, 0x000000002a407faeULL, 0x0003ea000c901c46ULL,
0x0000000028417faeULL, 0x0003e8000d901c46ULL, 0x0000000054427faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff297984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01062c00ff287984ULL, 0x000ea20000000800ULL,
0x000000ff53ff7812ULL, 0x000fe2000782c0ffULL, 0x80000000432b7824ULL, 0x000fc600078e00ffULL,
0x00000001ff647807ULL, 0x000fca0004800000ULL, 0x8000000064007824ULL, 0x000fca00078e00ffULL,
0x8000000029ff7812ULL, 0x002fe40007824800ULL, 0x8000000028ff7812ULL, 0x004fe2000784482bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000043297824ULL, 0x000fe400078e00ffULL,
0x0000000000287305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000280000735dULL, 0x004fe40003800000ULL, 0x01062c00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fc40007844829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0101000044007984ULL, 0x000e620000000800ULL,
0x00000001ff607424ULL, 0x000fc600078e00ffULL, 0x0103000044297984ULL, 0x0004e20000000800ULL,
0x0000002d0000720bULL, 0x002fda0003f5d000ULL, 0x0000000000287806ULL, 0x000fc800010e0100ULL,
0x0000ffff28547812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x0000002d0000720bULL, 0x00cfe40003f54000ULL, 0x000000002d2b7209ULL, 0x000fe40007810000ULL,
0x00000002ff557819ULL, 0x000fc60000011626ULL, 0x8000002b2d287221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b282a7820ULL, 0x000fe40000410000ULL, 0x0000000000287806ULL, 0x000fe400010e0100ULL,
0x000000020200780cULL, 0x000fe40003f45270ULL, 0x0000ffff282d7812ULL, 0x000fe200078e3cffULL,
0x0000002a002a7308ULL, 0x000e660000000800ULL, 0x0000002d54ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff607807ULL, 0x000fc60001800000ULL, 0x0105002b4400a388ULL, 0x000fec0000000800ULL,
0x8000002b002d3221ULL, 0x100fe20000010000ULL, 0x00001f552a287589ULL, 0x002e6200000e0000ULL,
0x0000002a2e2e7220ULL, 0x000fe40000410000ULL, 0x3fb8aa3b2d2d3820ULL, 0x000fe20000410000ULL,
0x00001f3b2a007589ULL, 0x000ea600000e0000ULL, 0x0000002d00323308ULL, 0x0007240000000800ULL,
0x000000ffff2d7224ULL, 0x008fe200078e002bULL, 0x0000002932293220ULL, 0x010fe20000410000ULL,
0x0000002818187220ULL, 0x082fe20000410000ULL, 0x0000002819197220ULL, 0x080fe20000410000ULL,
0x000000281c1c7220ULL, 0x080fe20000410000ULL, 0x000000281d1d7220ULL, 0x080fe20000410000ULL,
0x0000002804047220ULL, 0x080fe20000410000ULL, 0x0000002805057220ULL, 0x080fe20000410000ULL,
0x0000002808087220ULL, 0x080fe20000410000ULL, 0x0000002809097220ULL, 0x080fe20000410000ULL,
0x000000280c0c7220ULL, 0x080fe20000410000ULL, 0x000000280d0d7220ULL, 0x080fe20000410000ULL,
0x0000002810107220ULL, 0x080fe20000410000ULL, 0x0000002811117220ULL, 0x080fe20000410000ULL,
0x0000002814147220ULL, 0x080fe20000410000ULL, 0x0000002815157220ULL, 0x080fe20000410000ULL,
0x0000002820207220ULL, 0x080fe20000410000ULL, 0x0000002821217220ULL, 0x000fe20000410000ULL,
0x000000001a1a7220ULL, 0x084fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x000fe20000410000ULL,
0x0000002e292e7221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff007984ULL, 0x000e620000000800ULL, 0x8000000064297824ULL, 0x000fca00078e00ffULL,
0x8000000000ff7812ULL, 0x002fe20007824829ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000064297824ULL, 0x000fe400078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01064c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc40007824829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000004554783bULL, 0x000e680000004200ULL, 0x000000004628783bULL, 0x000ea80000004200ULL,
0x00000000475c783bULL, 0x000ee80000004200ULL, 0x000000004858783bULL, 0x000f220000004200ULL,
0x00000018ffd17819ULL, 0x002fe20000011454ULL, 0x0000010055d47824ULL, 0x000fe200078e00ffULL,
0x0000005500d97306ULL, 0x000fe20000009400ULL, 0x00000100547c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011456ULL, 0x0000010056cc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd47819ULL, 0x000fe200000114d4ULL, 0x0001000054e07824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000010057b67824ULL, 0x000fe200078e00ffULL,
0x000000d100e17306ULL, 0x000fe20000209400ULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x0001000055d57824ULL, 0x000fe200078e00ffULL, 0x00000018ffe07819ULL, 0x000fe200000114e0ULL,
0x0001000057b97824ULL, 0x000fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000010029b77824ULL, 0x044fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe20000011455ULL,
0x000000d100e67306ULL, 0x0002a20000205400ULL, 0x00000018ffd57819ULL, 0x000fe200000114d5ULL,
0x000001002ac17824ULL, 0x000fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe20000011457ULL,
0x0001000029c27824ULL, 0x000fe200078e00ffULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000001002bc07824ULL, 0x000fe200078e00ffULL, 0x00000018ffac7819ULL, 0x000fe20000011428ULL,
0x000000d400e27306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x002fe2000020d400ULL,
0x000100005cea7824ULL, 0x008fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fe200000114b7ULL,
0x000001005de87824ULL, 0x000fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fc400000114c1ULL,
0x00000018ffa97819ULL, 0x000fe20000011429ULL, 0x000000d400e37306ULL, 0x0002e20000205400ULL,
0x000000e6e100720bULL, 0x004fe40003f5d000ULL, 0x00000018ff917819ULL, 0x000fe4000001142bULL,
0x00000018ffa47819ULL, 0x000fe4000001142aULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0000005500da7306ULL, 0x000ea20000005400ULL, 0x000000d400d47245ULL, 0x002fc4000020d400ULL,
0x00000018ffc07819ULL, 0x000fe400000114c0ULL, 0x00000018ff007819ULL, 0x010fe4000001145aULL,
0x00000001d1d12812ULL, 0x000fe200078efcffULL, 0x0000005400c97306ULL, 0x000fe20000009400ULL,
0x000000e3e200720bULL, 0x008fe40003fbd000ULL, 0x00000018ff657819ULL, 0x000fe4000001145bULL,
0x00000018ff897819ULL, 0x000fc4000001145cULL, 0x00000018ff7f7819ULL, 0x000fe2000001145fULL,
0x0000005400e47306ULL, 0x000e620000005400ULL, 0x000000dad900720bULL, 0x004fe20003fdd000ULL,
0x000001005fd97824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001145dULL,
0x00000018ffe87819ULL, 0x000fe400000114e8ULL, 0x00000001d4d45812ULL, 0x000fe200078efcffULL,
0x0000007c00807306ULL, 0x000fe20000209400ULL, 0x00000018ffd97819ULL, 0x000fc400000114d9ULL,
0x00000018ff837819ULL, 0x000fe4000001145eULL, 0x00000018ff737819ULL, 0x000fe40000011458ULL,
0x00000018ff6e7819ULL, 0x000fe20000011459ULL, 0x0000007c00e57306ULL, 0x000ea20000205400ULL,
0x000000e4c900720bULL, 0x002fe20003f9d000ULL, 0x000100005de47824ULL, 0x000fca00078e00ffULL,
0x00000018ffe47819ULL, 0x000fe200000114e4ULL, 0x000000cc00d67306ULL, 0x000ff00000209400ULL,
0x000000cc00d77306ULL, 0x0002e20000205400ULL, 0x000000e58000720bULL, 0x004fe20003f3d000ULL,
0x000100005a807824ULL, 0x000fc400078e00ffULL, 0x0000010059e57824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x00000054008e7306ULL, 0x000ea2000000d400ULL,
0x000000cc00cc7245ULL, 0x002fe4000020d400ULL, 0x00000018ffe57819ULL, 0x000fca00000114e5ULL,
0x000000e000e77306ULL, 0x000fe20000209400ULL, 0x000000d7d600720bULL, 0x008fce0003f5d000ULL,
0x000000e000547306ULL, 0x0002e20000205400ULL, 0x000000018e8e4812ULL, 0x004fca00078efcffULL,
0x00000001cccc2812ULL, 0x000fe400078efcffULL, 0x0000005600de7306ULL, 0x000fe20000009400ULL,
0x000000e000e07245ULL, 0x002fce000020d400ULL, 0x0000005600df7306ULL, 0x000e620000005400ULL,
0x00000054e700720bULL, 0x008fe20003f7d000ULL, 0x000001005b547824ULL, 0x040fe200078e00ffULL,
0x0000007c00e77245ULL, 0x000fe2000020d400ULL, 0x000100005b7c7824ULL, 0x000fc600078e00ffULL,
0x00000001e7e71812ULL, 0x000fe200078efcffULL, 0x0000005600857306ULL, 0x0004e2000000d400ULL,
0x00000018ff7c7819ULL, 0x000fca000001147cULL, 0x00000001e0e03812ULL, 0x000fe400078efcffULL,
0x0000005700cb7306ULL, 0x000fe20000009400ULL, 0x0001000056567824ULL, 0x004fe200078e00ffULL,
0x000000dfde00720bULL, 0x002fc80003f3d000ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000005700ca7306ULL, 0x000e6e0000005400ULL, 0x0000000185851812ULL, 0x008fe200078efcffULL,
0x0000005500617306ULL, 0x0004e6000000d400ULL, 0x00000085cccc723eULL, 0x000fca00000010ffULL,
0x000000b600d87306ULL, 0x000fe20000209400ULL, 0x000000cacb00720bULL, 0x002fe20003fbd000ULL,
0x000001005c557824ULL, 0x004fca00078e00ffULL, 0x00000018ffe17819ULL, 0x000fe20000011455ULL,
0x000000b600dd7306ULL, 0x000e620000205400ULL, 0x0000000161616812ULL, 0x008fe200078efcffULL,
0x000001005a557824ULL, 0x000fc600078e00ffULL, 0x00000061d461723eULL, 0x000fc600000010ffULL,
0x000000b400d27306ULL, 0x000ff00000209400ULL, 0x000000b400d37306ULL, 0x0004e20000205400ULL,
0x000000ddd800720bULL, 0x002fce0003fdd000ULL, 0x0000005600cd7306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x004fce000020d400ULL, 0x0000005600d07306ULL, 0x0002a20000205400ULL,
0x000000d3d200720bULL, 0x008fce0003f9d000ULL, 0x000000d500db7306ULL, 0x000fe20000209400ULL,
0x0000005600567245ULL, 0x002fca000020d400ULL, 0x00000001b4b44812ULL, 0x000fe400078efcffULL,
0x000000d500dc7306ULL, 0x0002e20000205400ULL, 0x000000d0cd00720bULL, 0x004fe40003f5d000ULL,
0x000000b600cd7245ULL, 0x000fc8000020d400ULL, 0x00000001cdcd6812ULL, 0x000fe200078efcffULL,
0x0000005700847306ULL, 0x000522000000d400ULL, 0x000000d500d57245ULL, 0x002fca000020d400ULL,
0x0000000156562812ULL, 0x000fe400078efcffULL, 0x000000af00b17306ULL, 0x000fe20000209400ULL,
0x0000010028577824ULL, 0x004fe200078e00ffULL, 0x000000dcdb00720bULL, 0x008fc80003f7d000ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x000000af00947306ULL, 0x000e620000205400ULL,
0x0000000184845812ULL, 0x010fc800078efcffULL, 0x00000084cdcd723eULL, 0x000fe400000010ffULL,
0x00000001d5d53812ULL, 0x000fe200078efcffULL, 0x0000002800b27306ULL, 0x000ff00000009400ULL,
0x0000002800b57306ULL, 0x000ea20000005400ULL, 0x00000094b100720bULL, 0x002fc40003fbd000ULL,
0x000000b700947245ULL, 0x000fca000020d400ULL, 0x0000002800827306ULL, 0x0002f0000000d400ULL,
0x000000b900ce7306ULL, 0x000fe20000209400ULL, 0x0001000028287824ULL, 0x002fe200078e00ffULL,
0x000000b5b200720bULL, 0x004fc80003f7d000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x000000b900cf7306ULL, 0x0002ae0000205400ULL, 0x0000000182823812ULL, 0x008fe200078efcffULL,
0x00000029009b7306ULL, 0x000fe20000009400ULL, 0x000000b900b97245ULL, 0x002fce000020d400ULL,
0x0000002900927306ULL, 0x000e620000005400ULL, 0x000000cfce00720bULL, 0x004fce0003fdd000ULL,
0x0000009d00b07306ULL, 0x000fec0000209400ULL, 0x00000001b9b96812ULL, 0x000fe400078efcffULL,
0x0000009d00b37306ULL, 0x0004e20000205400ULL, 0x000000929b00720bULL, 0x002fe40003f3d000ULL,
0x000000af00927245ULL, 0x000fc8000020d400ULL, 0x0000000192925812ULL, 0x000fe200078efcffULL,
0x0000005700ba7306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x004fce000020d400ULL,
0x0000005700bb7306ULL, 0x0002a20000205400ULL, 0x000000b3b000720bULL, 0x008fce0003f9d000ULL,
0x0000002800bc7306ULL, 0x000fe20000209400ULL, 0x0000005700577245ULL, 0x002fca000020d400ULL,
0x000000019d9d4812ULL, 0x000fe400078efcffULL, 0x0000002800bf7306ULL, 0x000e620000205400ULL,
0x000000bbba00720bULL, 0x004fce0003f5d000ULL, 0x00000029007d7306ULL, 0x000eac000000d400ULL,
0x0000000157572812ULL, 0x000fe400078efcffULL, 0x0000002a00997306ULL, 0x000fe20000009400ULL,
0x000000bfbc00720bULL, 0x002fce0003fbd000ULL, 0x0000002a009c7306ULL, 0x000e620000005400ULL,
0x000000017d7d1812ULL, 0x004fce00078efcffULL, 0x000000ac00987306ULL, 0x000ff00000209400ULL,
0x000000ac00957306ULL, 0x0004e20000205400ULL, 0x0000009c9900720bULL, 0x002fe40003fdd000ULL,
0x000000c000997245ULL, 0x000fc4000020d400ULL, 0x000000e1009c7245ULL, 0x000fc6000020d400ULL,
0x000000b700b87306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x004fce000020d400ULL,
0x000000b700bd7306ULL, 0x000e620000205400ULL, 0x000000959800720bULL, 0x008fe40003f5d000ULL,
0x0000002800957245ULL, 0x000fe4000020d400ULL, 0x000000c100987245ULL, 0x000fe4000020d400ULL,
0x0000000195955812ULL, 0x000fe200078efcffULL, 0x000000c100c47306ULL, 0x000fe20000209400ULL,
0x0000b00049287811ULL, 0x000fca00078e20ffULL, 0x00000001acac2812ULL, 0x000fe400078efcffULL,
0x000000c100297306ULL, 0x000ea20000205400ULL, 0x000000bdb800720bULL, 0x002fce0003f9d000ULL,
0x000000a900ad7306ULL, 0x000fec0000209400ULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x000000a900ae7306ULL, 0x0002e20000205400ULL, 0x00000029c400720bULL, 0x004fce0003f3d000ULL,
0x0000002b00ab7306ULL, 0x000fe20000009400ULL, 0x000000a900a97245ULL, 0x002fca000020d400ULL,
0x0000000198981812ULL, 0x000fe400078efcffULL, 0x0000002b009a7306ULL, 0x000e620000005400ULL,
0x000000aead00720bULL, 0x008fce0003f7d000ULL, 0x0000002b007a7306ULL, 0x0005ec000000d400ULL,
0x00000001a9a93812ULL, 0x000fe400078efcffULL, 0x0000002a007b7306ULL, 0x000722000000d400ULL,
0x000100002b2b7824ULL, 0x004fe200078e00ffULL, 0x0000009aab00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x000000a400a77306ULL, 0x000fe20000209400ULL,
0x000100002a2a7824ULL, 0x008fe200078e00ffULL, 0x0000002b009b7245ULL, 0x000fc8000020d400ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002b00c97306ULL, 0x000fe20000209400ULL,
0x000000017b7b6812ULL, 0x010fe400078efcffULL, 0x0000002a009a7245ULL, 0x000fe4000020d400ULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x0000007b9898723eULL, 0x000fe200000010ffULL,
0x0000002b00da7306ULL, 0x000e700000205400ULL, 0x000000a400a27306ULL, 0x000eb00000205400ULL,
0x000000c200c37306ULL, 0x000fe20000209400ULL, 0x000000dac900720bULL, 0x002fce0003fdd000ULL,
0x000000c200c67306ULL, 0x0002e20000205400ULL, 0x000000a2a700720bULL, 0x004fca0003f3d000ULL,
0x000000019b9b6812ULL, 0x000fe400078efcffULL, 0x0000002a00c77306ULL, 0x000fe20000209400ULL,
0x000000c200c27245ULL, 0x002fce000020d400ULL, 0x0000002a00c87306ULL, 0x0002a20000205400ULL,
0x000000c6c300720bULL, 0x008fce0003f9d000ULL, 0x000000c000be7306ULL, 0x000fe20000209400ULL,
0x000000002828783bULL, 0x002fea0000000200ULL, 0x00000001c2c24812ULL, 0x000fe400078efcffULL,
0x000000c000c57306ULL, 0x000e620000205400ULL, 0x000000c8c700720bULL, 0x004fce0003f7d000ULL,
0x0000009100a67306ULL, 0x000fec0000209400ULL, 0x000000019a9a3812ULL, 0x000fe400078efcffULL,
0x0000009100977306ULL, 0x000ea20000205400ULL, 0x000000c5be00720bULL, 0x002fce0003f5d000ULL,
0x0000005a00817306ULL, 0x000fec0000009400ULL, 0x0000000199992812ULL, 0x000fe400078efcffULL,
0x0000005a007e7306ULL, 0x000fe20000005400ULL, 0x00000097a600720bULL, 0x004fe40003fbd000ULL,
0x000000a400977245ULL, 0x000fc4000020d400ULL, 0x0000007a9999723eULL, 0x000fe400000010ffULL,
0x0000000197971812ULL, 0x000fe200078efcffULL, 0x0000005a00667306ULL, 0x0003e6000000d400ULL,
0x0000009a979a723eULL, 0x000fca00000010ffULL, 0x0000005b00797306ULL, 0x000fe20000009400ULL,
0x00000018ff5a7819ULL, 0x002fce00000114eaULL, 0x0000005b00787306ULL, 0x000ff00000005400ULL,
0x0000005b00677306ULL, 0x000ff0000000d400ULL, 0x0000005a005b7306ULL, 0x000ff00000209400ULL,
0x0000005a00d27306ULL, 0x000e700000205400ULL, 0x0000005c00aa7306ULL, 0x000ff00000009400ULL,
0x0000005c009f7306ULL, 0x000ea20000005400ULL, 0x000000d25b00720bULL, 0x002fce0003fdd000ULL,
0x0000005e00967306ULL, 0x000ff00000009400ULL, 0x0000005e00a17306ULL, 0x000e620000005400ULL,
0x0000009faa00720bULL, 0x004fe40003f9d000ULL, 0x00000002ff9f7819ULL, 0x000fca0000011626ULL,
0x000000e100e67306ULL, 0x000ff00000209400ULL, 0x000000e100e97306ULL, 0x000ea20000205400ULL,
0x000000a19600720bULL, 0x002fe40003f3d000ULL, 0x0000009100967245ULL, 0x000fc4000020d400ULL,
0x0000005a00917245ULL, 0x000fe4000020d400ULL, 0x0000000196965812ULL, 0x000fe200078efcffULL,
0x0000005d00a57306ULL, 0x000fe20000009400ULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x000000e800a17245ULL, 0x000fe4000020d400ULL, 0x0000009b969b723eULL, 0x000fc600000010ffULL,
0x0000005d00a87306ULL, 0x000e620000005400ULL, 0x000000e9e600720bULL, 0x004fce0003f7d000ULL,
0x0000008900a07306ULL, 0x000fec0000209400ULL, 0x000000019c9c3812ULL, 0x000fe400078efcffULL,
0x0000008900937306ULL, 0x000ea20000205400ULL, 0x000000a8a500720bULL, 0x002fce0003f5d000ULL,
0x0000005c00777306ULL, 0x0002f0000000d400ULL, 0x0000005f008a7306ULL, 0x000fe20000009400ULL,
0x00000100585c7824ULL, 0x002fe200078e00ffULL, 0x00000093a000720bULL, 0x004fc40003fbd000ULL,
0x0000008c00937245ULL, 0x000fe4000020d400ULL, 0x00000018ffa67819ULL, 0x000fe4000001145cULL,
0x0000005f00637306ULL, 0x000fe20000005400ULL, 0x00000032ff5c723eULL, 0x000fe400000010ffULL,
0x0000000177774812ULL, 0x008fca00078efcffULL, 0x0000005f00717306ULL, 0x0003f0000000d400ULL,
0x0000005d00767306ULL, 0x0004e2000000d400ULL, 0x000100005f5f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001145fULL, 0x0000008c00a37306ULL, 0x000fe20000209400ULL,
0x000001005e5d7824ULL, 0x004fe200078e00ffULL, 0x00009910605f7816ULL, 0x000fe400000000ffULL,
0x000054105c607816ULL, 0x000fe4000000005cULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x000000ffff5c7224ULL, 0x000fe200078e005fULL, 0x0000008c009e7306ULL, 0x000e620000205400ULL,
0x00001f9f609f7589ULL, 0x000ea200000e0000ULL, 0x0000000176762812ULL, 0x008fc400078efcffULL,
0x000000ff5c00720cULL, 0x000fe20003f45270ULL, 0x00001f3b60a07589ULL, 0x00072200000e0000ULL,
0x000000e0d15c723eULL, 0x000fe400000010ffULL, 0x0000005d00b17306ULL, 0x000fe20000209400ULL,
0x0000008ee760723eULL, 0x008fce00000010ffULL, 0x0000005d00ae7306ULL, 0x0007620000205400ULL,
0x0000009ea300720bULL, 0x002fe40003f7d000ULL, 0x00000089009e7245ULL, 0x000fe4000020d400ULL,
0x0000005d00897245ULL, 0x000fe4000020d400ULL, 0x000000019e9e5812ULL, 0x000fe200078efcffULL,
0x000000e800ca7306ULL, 0x000fe20000209400ULL, 0x0000009f2828a231ULL, 0x084fe200003400ffULL,
0x000000d5b45d723eULL, 0x008fe200000010ffULL, 0x0000009f2a2aa231ULL, 0x000fc400003400ffULL,
0x000000a02929a231ULL, 0x090fe200003400ffULL, 0x0000000193933812ULL, 0x000fe200078efcffULL,
0x000000a02b2ba231ULL, 0x000fe200003400ffULL, 0x000000e800b37306ULL, 0x000e620000205400ULL,
0x000000aeb100720bULL, 0x020fca0003fbd000ULL, 0x000000cc2804723cULL, 0x040fe40000041804ULL,
0x000000e400b07306ULL, 0x000fec0000209400ULL, 0x0000000189895812ULL, 0x000fe200078efcffULL,
0x0000009a2820723cULL, 0x000fe20000041820ULL, 0x000000e400af7306ULL, 0x0004e20000205400ULL,
0x000000b3ca00720bULL, 0x002fce0003f9d000ULL, 0x000000d900ab7306ULL, 0x000fe20000209400ULL,
0x000000e400e47245ULL, 0x004fca000020d400ULL, 0x00000001a1a14812ULL, 0x000fe400078efcffULL,
0x000000d900aa7306ULL, 0x000e620000205400ULL, 0x000000afb000720bULL, 0x008fe40003fdd000ULL,
0x000000638a00720bULL, 0x000fe40003f9d000ULL, 0x000000d9008a7245ULL, 0x000fc6000020d400ULL,
0x0000005800627306ULL, 0x000fec0000009400ULL, 0x00000001e4e46812ULL, 0x000fe400078efcffULL,
0x00000058008b7306ULL, 0x000ea20000005400ULL, 0x000000aaab00720bULL, 0x002fe40003fbd000ULL,
0x0000000171714812ULL, 0x000fca00078efcffULL, 0x0000005e00707306ULL, 0x0002ec000000d400ULL,
0x000000018a8a5812ULL, 0x000fe400078efcffULL, 0x00000083008d7306ULL, 0x000fe20000209400ULL,
0x000100005e5e7824ULL, 0x002fe200078e00ffULL, 0x0000008b6200720bULL, 0x004fc40003fdd000ULL,
0x000000602860723cULL, 0x000fe20000041818ULL, 0x000000718a71723eULL, 0x000fe400000010ffULL,
0x00000018ffa27819ULL, 0x000fe2000001145eULL, 0x0000008300887306ULL, 0x0002a20000205400ULL,
0x0000000170701812ULL, 0x008fe400078efcffULL, 0x0000b0004a187811ULL, 0x000fe400078e20ffULL,
0x000000708970723eULL, 0x000fc600000010ffULL, 0x00000059008f7306ULL, 0x000fe20000009400ULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x0000008300837245ULL, 0x002fcc000020d400ULL,
0x0000005900907306ULL, 0x000e620000005400ULL, 0x000000888d00720bULL, 0x004fce0003f3d000ULL,
0x000000a2005e7306ULL, 0x000fec0000209400ULL, 0x0000000183831812ULL, 0x000fe400078efcffULL,
0x000000a200a57306ULL, 0x0005220000205400ULL, 0x000000908f00720bULL, 0x002fce0003f7d000ULL,
0x000000a6005a7306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x004fce000020d400ULL,
0x000000a600a77306ULL, 0x000e620000205400ULL, 0x000000a55e00720bULL, 0x010fe20003fbd000ULL,
0x0000009f1818a231ULL, 0x088fe200003400ffULL, 0x0000005c285c723cULL, 0x000fe2000004181cULL,
0x0000009f1a1aa231ULL, 0x000fe400003400ffULL, 0x000000a01919a231ULL, 0x080fe400003400ffULL,
0x00000058006a7306ULL, 0x0004e2000000d400ULL, 0x000000a01b1ba231ULL, 0x000fe200003400ffULL,
0x0000007d941d723eULL, 0x000fc400000010ffULL, 0x000000a6007d7245ULL, 0x000fe4000020d400ULL,
0x00000001a2a25812ULL, 0x000fe400078efcffULL, 0x0000007f00877306ULL, 0x000fe20000209400ULL,
0x0001000058587824ULL, 0x004fe200078e00ffULL, 0x000000a75a00720bULL, 0x002fe20003f3d000ULL,
0x000000701804723cULL, 0x000fe20000041804ULL, 0x00000082571c723eULL, 0x000fe400000010ffULL,
0x00000018ff8b7819ULL, 0x000fc40000011458ULL, 0x0000007f00867306ULL, 0x0002a20000205400ULL,
0x000000569d58723eULL, 0x000fe400000010ffULL, 0x000000016a6a6812ULL, 0x008fe200078efcffULL,
0x0000001c281c723cULL, 0x000fe2000004180cULL, 0x00000095ac56723eULL, 0x000fe400000010ffULL,
0x000000017d7d1812ULL, 0x000fe200078efcffULL, 0x0000005b00a47306ULL, 0x000fe20000209400ULL,
0x000000c2a957723eULL, 0x000fe400000010ffULL, 0x0000007f007f7245ULL, 0x002fc4000020d400ULL,
0x0000005b00827245ULL, 0x000fe4000020d400ULL, 0x000000779c0c723eULL, 0x000fe200000010ffULL,
0x0000005b00a37306ULL, 0x000e620000205400ULL, 0x000000868700720bULL, 0x004fe40003f9d000ULL,
0x00000018ff867819ULL, 0x000fe40000011455ULL, 0x00000076a10d723eULL, 0x000fe400000010ffULL,
0x0000006a7d6a723eULL, 0x000fe200000010ffULL, 0x000000e500a87306ULL, 0x000fe80000209400ULL,
0x0000000c180c723cULL, 0x000fe40000041860ULL, 0x000000017f7f4812ULL, 0x000fc400078efcffULL,
0x000000e5008f7306ULL, 0x000ea20000205400ULL, 0x000000a3a400720bULL, 0x002fe40003fbd000ULL,
0x000000787900720bULL, 0x000fe40003f9d000ULL, 0x00000018ff787819ULL, 0x000fe40000011454ULL,
0x000000562854723cULL, 0x040fe20000041810ULL, 0x0000008b008c7306ULL, 0x000fec0000209400ULL,
0x0000000182825812ULL, 0x000fe200078efcffULL, 0x000000982810723cULL, 0x000fe20000041814ULL,
0x0000008b008d7306ULL, 0x0002e20000205400ULL, 0x0000008fa800720bULL, 0x004fc40003f3d000ULL,
0x0000007e8100720bULL, 0x000fe40003fbd000ULL, 0x0000000167674812ULL, 0x000fe400078efcffULL,
0x000000e500167245ULL, 0x000fe2000020d400ULL, 0x0000007300747306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fe4000020d400ULL, 0x0000007300147245ULL, 0x000fe4000020d400ULL,
0x0000008600177245ULL, 0x000fc4000020d400ULL, 0x0000000116161812ULL, 0x000fe200078efcffULL,
0x0000007300757306ULL, 0x000e620000205400ULL, 0x0000008d8c00720bULL, 0x008fe40003fdd000ULL,
0x0000000166665812ULL, 0x000fca00078efcffULL, 0x0000006e006f7306ULL, 0x000fec0000209400ULL,
0x000000018b8b6812ULL, 0x000fe400078efcffULL, 0x0000006e00727306ULL, 0x0004e20000205400ULL,
0x000000757400720bULL, 0x002fce0003f3d000ULL, 0x00000059006b7306ULL, 0x000322000000d400ULL,
0x0000006e006e7245ULL, 0x004fca000020d400ULL, 0x0000000114141812ULL, 0x000fe400078efcffULL,
0x0000008600887306ULL, 0x000fe20000209400ULL, 0x0001000059597824ULL, 0x002fe200078e00ffULL,
0x000000726f00720bULL, 0x008fe40003fdd000ULL, 0x0000008b1414723eULL, 0x000fe400000010ffULL,
0x00000018ff857819ULL, 0x000fe40000011459ULL, 0x000000b99259723eULL, 0x000fe200000010ffULL,
0x0000008600817306ULL, 0x000e620000205400ULL, 0x000000016b6b3812ULL, 0x010fc400078efcffULL,
0x0000008500157245ULL, 0x000fe4000020d400ULL, 0x0000006b166b723eULL, 0x000fe200000010ffULL,
0x000000582858723cULL, 0x000fe20000041808ULL, 0x000000016e6e6812ULL, 0x000fe200078efcffULL,
0x0000008500847306ULL, 0x000fea0000209400ULL, 0x000000919e08723eULL, 0x000fe200000010ffULL,
0x0000006a181c723cULL, 0x000fe2000004181cULL, 0x000000e49309723eULL, 0x000fe200000010ffULL,
0x0000008500877306ULL, 0x000ea20000205400ULL, 0x000000818800720bULL, 0x002fc40003f3d000ULL,
0x0000007c00817245ULL, 0x000fe4000020d400ULL, 0x000000a28328723eULL, 0x000fe200000010ffULL,
0x000000081808723cULL, 0x040fe2000004185cULL, 0x000000827f29723eULL, 0x000fe200000010ffULL,
0x0000007800797306ULL, 0x000fec0000209400ULL, 0x0000000117171812ULL, 0x000fe200078efcffULL,
0x000000281828723cULL, 0x000fe20000041858ULL, 0x00000078007a7306ULL, 0x0002e20000205400ULL,
0x000000878400720bULL, 0x004fc40003f7d000ULL, 0x000000661766723eULL, 0x000fca00000010ffULL,
0x00000000006d7306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x002fca000020d400ULL,
0x0000000115153812ULL, 0x000fe400078efcffULL, 0x00000000006c7306ULL, 0x000e620000205400ULL,
0x0000007a7900720bULL, 0x008fe40003fdd000ULL, 0x000000156e15723eULL, 0x000fca00000010ffULL,
0x0000006500697306ULL, 0x000fe40000209400ULL, 0x000000141814723cULL, 0x000fe80000041854ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x0000006500687306ULL, 0x000ea20000205400ULL,
0x0000006c6d00720bULL, 0x002fe40003f7d000ULL, 0x0000000000557245ULL, 0x000fc4000020d400ULL,
0x0000006500007245ULL, 0x000fe4000020d400ULL, 0x000000677867723eULL, 0x000fe200000010ffULL,
0x0000008000767306ULL, 0x000fec0000209400ULL, 0x0000000155553812ULL, 0x000fe200078efcffULL,
0x000000661810723cULL, 0x000fe20000041810ULL, 0x0000008000617306ULL, 0x0002e20000205400ULL,
0x000000686900720bULL, 0x004fce0003f3d000ULL, 0x0000007c005c7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x0000000100001812ULL, 0x000fe400078efcffULL,
0x0000007c005d7306ULL, 0x000e620000205400ULL, 0x000000617600720bULL, 0x008fda0003fbd000ULL,
0x0000000180805812ULL, 0x000fe400078efcffULL, 0x0000005d5c00720bULL, 0x002fe40003fdd000ULL,
0x000000805580723eULL, 0x000fd600000010ffULL, 0x0000000181816812ULL, 0x000fc800078efcffULL,
0x000000810081723eULL, 0x000fce00000010ffULL, 0x000000801818723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000207305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000200000735dULL, 0x004fe40003800000ULL,
0x01065c00ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000c024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff5b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff597819ULL, 0x000fc40000011626ULL, 0x0000000003217217ULL, 0x000fe20007800000ULL,
0x0000620027577a24ULL, 0x000fc800078e0200ULL, 0x0000000121217824ULL, 0x000fe400078e0a00ULL,
0x0000000133207824ULL, 0x100fe400078e0257ULL, 0x0000000136227824ULL, 0x100fe200078e0257ULL,
0x0000002021237807ULL, 0x000fe20000000000ULL, 0x0000000138547824ULL, 0x000fe400078e0257ULL,
0x00005e0020207625ULL, 0x000fe200078e005bULL, 0x000000232c557217ULL, 0x000fc60007800000ULL,
0x00005e0022227625ULL, 0x000fe200078e005bULL, 0x0000003420567210ULL, 0x000fc60007f3e0ffULL,
0x0000000155007824ULL, 0x000fe200078e0a2cULL, 0x0000003422227210ULL, 0x000fe20007f9e0ffULL,
0x00005e0054547625ULL, 0x000fc600078e005bULL, 0x000000003500720cULL, 0x000fe20003f66070ULL,
0x000000013a207824ULL, 0x000fe200078e0257ULL, 0x0000003454547210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff577224ULL, 0x000fe200008e0621ULL, 0x000000005900720cULL, 0x000fe20003f26070ULL,
0x00005e0020207625ULL, 0x000fc800078e005bULL, 0x000000ffff237224ULL, 0x000fe200020e0623ULL,
0x000000003700720cULL, 0x080fe20003f86070ULL, 0x000000ffff557224ULL, 0x000fe200028e0655ULL,
0x000000003900720cULL, 0x000fe40003fa6070ULL, 0x0000003420207210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000564b7faeULL, 0x0003e4000c901c46ULL,
0x000000ffff217224ULL, 0x000fe400030e0621ULL, 0x00000000224c7faeULL, 0x0003e8000d901c46ULL,
0x00000000544d7faeULL, 0x0003e8000e101c46ULL, 0x00000000204e7faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff007984ULL, 0x000ea20000000800ULL,
0x8000000064217824ULL, 0x002fca00078e00ffULL, 0x8000000000ff7812ULL, 0x004fe20007824821ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000064217824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000207305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000200000735dULL, 0x004fe40003800000ULL, 0x01065400ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fc40007824821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000004f54783bULL, 0x000e680000004200ULL,
0x000000005058783bULL, 0x000ea80000004200ULL, 0x000000003c5c783bULL, 0x000ee80000004200ULL,
0x000000005120783bULL, 0x000f220000004200ULL, 0x0000010054db7824ULL, 0x042fe200078e00ffULL,
0x0000005400bf7306ULL, 0x000fe20000009400ULL, 0x0000010055e37824ULL, 0x040fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe20000011455ULL, 0x0001000054e87824ULL, 0x000fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x0001000055dd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe37819ULL, 0x000fe200000114e3ULL, 0x0000010058c87824ULL, 0x044fe200078e00ffULL,
0x000000db00807306ULL, 0x000fe20000209400ULL, 0x00000018ffe87819ULL, 0x000fe200000114e8ULL,
0x0001000057c97824ULL, 0x000fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fe20000011454ULL,
0x0001000058ce7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe20000011456ULL,
0x0000010059c77824ULL, 0x000fe200078e00ffULL, 0x00000018ffdd7819ULL, 0x000fe200000114ddULL,
0x000000db009f7306ULL, 0x0002a20000205400ULL, 0x00000018ff607819ULL, 0x008fe2000001145fULL,
0x0000010020c17824ULL, 0x050fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x0001000020eb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010021ec7824ULL, 0x040fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x0000005400be7306ULL, 0x000ee20000005400ULL, 0x000000db00db7245ULL, 0x002fe2000020d400ULL,
0x0001000021e47824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fe20000011457ULL,
0x0001000023c37824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe200000114c7ULL,
0x0001000059d47824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe20000011459ULL,
0x000000e300e97306ULL, 0x000fe20000209400ULL, 0x0000009f8000720bULL, 0x004fe20003f9d000ULL,
0x000001005f807824ULL, 0x000fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe20000011420ULL,
0x000100005ba47824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011421ULL,
0x000100005aa17824ULL, 0x000fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fe2000001145aULL,
0x000000e300ea7306ULL, 0x000e620000205400ULL, 0x000000bebf00720bULL, 0x008fe20003fdd000ULL,
0x0001000022bf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe20000011422ULL,
0x000100005ccf7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011423ULL,
0x000001005e9f7824ULL, 0x000fe200078e00ffULL, 0x00000001dbdb4812ULL, 0x000fe200078efcffULL,
0x000000e800ab7306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fc40000011458ULL,
0x00000018ffd47819ULL, 0x000fe400000114d4ULL, 0x00000018ffa47819ULL, 0x000fe400000114a4ULL,
0x00000018ffa17819ULL, 0x000fe200000114a1ULL, 0x000000e800c47306ULL, 0x000ea20000205400ULL,
0x000000eae900720bULL, 0x002fe40003f9d000ULL, 0x00000018ff9d7819ULL, 0x000fe4000001145bULL,
0x00000018ff6c7819ULL, 0x000fc4000001145cULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000005400847306ULL, 0x0002e2000000d400ULL, 0x00000018ff007819ULL, 0x000fe4000001145eULL,
0x00000018ff657819ULL, 0x000fe4000001145dULL, 0x00000018ffbf7819ULL, 0x000fe400000114bfULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000000ba00e27306ULL, 0x000fe20000209400ULL,
0x000000c4ab00720bULL, 0x004fe20003f3d000ULL, 0x0000010057547824ULL, 0x002fe200078e00ffULL,
0x00000018ffe47819ULL, 0x000fe200000114e4ULL, 0x000001005cc47824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x000100005dab7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x000000ba00e17306ULL, 0x0002a20000205400ULL,
0x0000000184846812ULL, 0x008fc400078efcffULL, 0x00000018ffc47819ULL, 0x000fe400000114c4ULL,
0x00000018ffab7819ULL, 0x000fe400000114abULL, 0x00000018ff9f7819ULL, 0x000fe2000001149fULL,
0x000000de00787306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x002fe4000020d400ULL,
0x00000018ff807819ULL, 0x000fca0000011480ULL, 0x000000de007b7306ULL, 0x0002e20000205400ULL,
0x000000e1e200720bULL, 0x004fe40003fdd000ULL, 0x000000e300e27245ULL, 0x000fc8000020d400ULL,
0x00000001e2e24812ULL, 0x000fe200078efcffULL, 0x0000005500dc7306ULL, 0x000fe20000009400ULL,
0x000000de00de7245ULL, 0x002fca000020d400ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x0000005500e77306ULL, 0x000e620000005400ULL, 0x0000007b7800720bULL, 0x008fe20003fbd000ULL,
0x000100005f787824ULL, 0x000fe400078e00ffULL, 0x000100005e7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000005500897306ULL, 0x0004e2000000d400ULL,
0x00000018ff7b7819ULL, 0x000fca000001147bULL, 0x00000001dede5812ULL, 0x000fe400078efcffULL,
0x0000005600bd7306ULL, 0x000fe20000009400ULL, 0x0000010056557824ULL, 0x004fe200078e00ffULL,
0x000000e7dc00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005600bc7306ULL, 0x000e6e0000005400ULL, 0x0000000189893812ULL, 0x008fe200078efcffULL,
0x0000005600817306ULL, 0x0004f0000000d400ULL, 0x000000dd00e57306ULL, 0x000fe20000209400ULL,
0x0001000056567824ULL, 0x004fe200078e00ffULL, 0x000000bcbd00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x000000dd00e67306ULL, 0x0003ee0000205400ULL,
0x0000000181814812ULL, 0x008fe200078efcffULL, 0x0000005600c27306ULL, 0x000fe20000209400ULL,
0x000000dd00dd7245ULL, 0x002fce000020d400ULL, 0x0000005600cd7306ULL, 0x000e700000205400ULL,
0x0000005500df7306ULL, 0x000ff00000209400ULL, 0x0000005500e07306ULL, 0x000ea20000205400ULL,
0x000000cdc200720bULL, 0x002fce0003fdd000ULL, 0x0000005f00757306ULL, 0x000ff00000009400ULL,
0x0000005f00747306ULL, 0x000fe20000005400ULL, 0x000000e0df00720bULL, 0x004fe40003fbd000ULL,
0x00000018ffdf7819ULL, 0x000fca00000114ebULL, 0x0000005f00627306ULL, 0x0003f0000000d400ULL,
0x0000005800b97306ULL, 0x000fe20000009400ULL, 0x000000e8005f7245ULL, 0x002fc8000020d400ULL,
0x000000015f5f1812ULL, 0x000fe400078efcffULL, 0x000000e6e500720bULL, 0x000fe20003f3d000ULL,
0x0000005800ac7306ULL, 0x000e700000005400ULL, 0x0000005400c07306ULL, 0x000fe80000209400ULL,
0x00000001dddd1812ULL, 0x000fc800078efcffULL, 0x0000005400d97306ULL, 0x000ea20000205400ULL,
0x000000acb900720bULL, 0x002fe40003f9d000ULL, 0x0000005600ac7245ULL, 0x000fc8000020d400ULL,
0x00000001acac6812ULL, 0x000fe200078efcffULL, 0x0000005700b87306ULL, 0x000ff00000009400ULL,
0x0000005700bb7306ULL, 0x000e620000005400ULL, 0x000000d9c000720bULL, 0x004fce0003f7d000ULL,
0x000000c800ca7306ULL, 0x000ff00000209400ULL, 0x000000c800c57306ULL, 0x0004e20000205400ULL,
0x000000bbb800720bULL, 0x002fe40003f3d000ULL, 0x0000005500b87245ULL, 0x000fc8000020d400ULL,
0x00000001b8b85812ULL, 0x000fe200078efcffULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x000000c800c87245ULL, 0x004fe4000020d400ULL, 0x00000081b8b8723eULL, 0x000fca00000010ffULL,
0x000000b500af7306ULL, 0x0002a20000205400ULL, 0x000000c5ca00720bULL, 0x008fce0003fdd000ULL,
0x000000c900cb7306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x00000001c8c86812ULL, 0x000fe400078efcffULL, 0x000000c900cc7306ULL, 0x0002e20000205400ULL,
0x000000afb600720bULL, 0x004fe40003fbd000ULL, 0x0000005400b67245ULL, 0x000fe4000020d400ULL,
0x0000b0003d547811ULL, 0x000fe400078e20ffULL, 0x00000001b6b63812ULL, 0x000fe200078efcffULL,
0x000000ce00d17306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fca000020d400ULL,
0x00000001b5b55812ULL, 0x000fe400078efcffULL, 0x000000ce00d87306ULL, 0x0002a20000205400ULL,
0x000000cccb00720bULL, 0x008fce0003f7d000ULL, 0x00000057007f7306ULL, 0x000ee2000000d400ULL,
0x000000ce00ce7245ULL, 0x002fca000020d400ULL, 0x00000001c9c93812ULL, 0x000fe400078efcffULL,
0x000000b300b77306ULL, 0x000fe20000209400ULL, 0x000000d8d100720bULL, 0x004fce0003fdd000ULL,
0x000000b300aa7306ULL, 0x000e620000205400ULL, 0x000000017f7f1812ULL, 0x008fc800078efcffULL,
0x0000007fb6b9723eULL, 0x000fe400000010ffULL, 0x00000001cece6812ULL, 0x000fe200078efcffULL,
0x0000005900b47306ULL, 0x000fe20000009400ULL, 0x000000c3007f7245ULL, 0x000fce000020d400ULL,
0x0000005900a37306ULL, 0x000ea20000005400ULL, 0x000000aab700720bULL, 0x002fe40003f3d000ULL,
0x000000b300aa7245ULL, 0x000fca000020d400ULL, 0x00000058007d7306ULL, 0x0002ec000000d400ULL,
0x00000001aaaa1812ULL, 0x000fe400078efcffULL, 0x0000005a00b17306ULL, 0x000fe20000009400ULL,
0x000000a3b400720bULL, 0x004fe20003f7d000ULL, 0x000001005a587824ULL, 0x002fe200078e00ffULL,
0x000000b000a37245ULL, 0x000fc8000020d400ULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000005a00a67306ULL, 0x000e620000005400ULL, 0x000000017d7d4812ULL, 0x008fce00078efcffULL,
0x000000c700577306ULL, 0x000ff00000209400ULL, 0x000000c700d07306ULL, 0x0004e20000205400ULL,
0x000000a6b100720bULL, 0x002fe40003f9d000ULL, 0x00000032ffb1723eULL, 0x000fc800000010ffULL,
0x00005410b1b17816ULL, 0x000fe200000000b1ULL, 0x0000008a00a87306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x004fce000020d400ULL, 0x0000008a00ad7306ULL, 0x000e620000205400ULL,
0x000000d05700720bULL, 0x008fe40003fbd000ULL, 0x000000005454783bULL, 0x000fea0000000200ULL,
0x0000002000867306ULL, 0x000fec0000009400ULL, 0x00000001c7c75812ULL, 0x000fc400078efcffULL,
0x0000002000977306ULL, 0x000fe20000005400ULL, 0x000000ada800720bULL, 0x002fce0003fdd000ULL,
0x0000002000707306ULL, 0x0003f0000000d400ULL, 0x00000059007c7306ULL, 0x0004e2000000d400ULL,
0x0000010022207824ULL, 0x002fca00078e00ffULL, 0x00000018ffb37819ULL, 0x000fe40000011420ULL,
0x0000005b00b27306ULL, 0x000fe20000009400ULL, 0x0000b0003e207811ULL, 0x000fe200078e20ffULL,
0x000001005b597824ULL, 0x004fca00078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000005b00a77306ULL, 0x000e620000005400ULL, 0x000000017c7c3812ULL, 0x008fce00078efcffULL,
0x0000002100967306ULL, 0x000ff00000009400ULL, 0x0000002100877306ULL, 0x000fe20000005400ULL,
0x000000a7b200720bULL, 0x002fe40003f7d000ULL, 0x0000008a00a77245ULL, 0x000fc4000020d400ULL,
0x00000058008a7245ULL, 0x000fe4000020d400ULL, 0x00000001a7a76812ULL, 0x000fe200078efcffULL,
0x00000021006d7306ULL, 0x0003f0000000d400ULL, 0x0000002200857306ULL, 0x000fe20000009400ULL,
0x0000010023217824ULL, 0x002fca00078e00ffULL, 0x00000018ffa67819ULL, 0x000fe40000011421ULL,
0x0000002200907306ULL, 0x000fe40000005400ULL, 0x000000a600817245ULL, 0x000fcc000020d400ULL,
0x00000022006b7306ULL, 0x000ff0000000d400ULL, 0x0000002300a07306ULL, 0x000ff00000009400ULL,
0x00000023008b7306ULL, 0x000ff00000005400ULL, 0x00000023006a7306ULL, 0x0003f0000000d400ULL,
0x00000094008e7306ULL, 0x000fe20000209400ULL, 0x000000002020783bULL, 0x002fee0000000200ULL,
0x0000009400957306ULL, 0x0002b00000205400ULL, 0x000000b000a97306ULL, 0x000fe20000209400ULL,
0x0000009400947245ULL, 0x002fce000020d400ULL, 0x000000b000ae7306ULL, 0x0002e20000205400ULL,
0x000000958e00720bULL, 0x004fe40003fdd000ULL, 0x00000059008e7245ULL, 0x000fca000020d400ULL,
0x0000005800d57306ULL, 0x000fe20000209400ULL, 0x00000002ffb07819ULL, 0x002fca0000011626ULL,
0x00001fb0b1957589ULL, 0x000e6200000e0000ULL, 0x0000000194946812ULL, 0x000fe200078efcffULL,
0x0000005800d67306ULL, 0x0005220000205400ULL, 0x000000aea900720bULL, 0x008fe40003f3d000ULL,
0x000000908500720bULL, 0x000fca0003fdd000ULL, 0x000000d400d77306ULL, 0x000fe20000209400ULL,
0x00001f3bb1587589ULL, 0x004eaa00000e0000ULL, 0x00000001a3a31812ULL, 0x000fe400078efcffULL,
0x000000d400d27306ULL, 0x0007620000205400ULL, 0x000000d6d500720bULL, 0x010fe40003f3d000ULL,
0x000000016b6b6812ULL, 0x000fe200078efcffULL, 0x000000955454a231ULL, 0x002fc800003400ffULL,
0x000000df00bc7306ULL, 0x000fe20000209400ULL, 0x000000955656a231ULL, 0x080fe200003400ffULL,
0x000000d400d47245ULL, 0x008fe2000020d400ULL, 0x000000952020a231ULL, 0x080fe400003400ffULL,
0x000000952222a231ULL, 0x000fe200003400ffULL, 0x000000018a8a1812ULL, 0x000fe400078efcffULL,
0x000000df00bb7306ULL, 0x0002e20000205400ULL, 0x000000d2d700720bULL, 0x020fe20003fbd000ULL,
0x000000585555a231ULL, 0x004fc400003400ffULL, 0x000000585757a231ULL, 0x080fe400003400ffULL,
0x000000582121a231ULL, 0x080fe400003400ffULL, 0x0000005900d37306ULL, 0x000fe20000209400ULL,
0x000000582323a231ULL, 0x000fe200003400ffULL, 0x000000df00df7245ULL, 0x002fe2000020d400ULL,
0x000000b85404723cULL, 0x000fe20000041804ULL, 0x0000005fde58723eULL, 0x000fe400000010ffULL,
0x00000001d4d45812ULL, 0x000fc400078efcffULL, 0x0000005900da7306ULL, 0x0002a20000205400ULL,
0x000000bbbc00720bULL, 0x008fce0003f5d000ULL, 0x000000b300b47306ULL, 0x000fe20000209400ULL,
0x000000ddba59723eULL, 0x002fca00000010ffULL, 0x00000001dfdf2812ULL, 0x000fe400078efcffULL,
0x000000b300a97306ULL, 0x000e620000205400ULL, 0x000000dad300720bULL, 0x004fce0003fbd000ULL,
0x0000005b00717306ULL, 0x000eac000000d400ULL, 0x000000018e8e5812ULL, 0x000fe400078efcffULL,
0x000000a4005b7306ULL, 0x000fe20000209400ULL, 0x000000a9b400720bULL, 0x002fce0003f5d000ULL,
0x000000a400be7306ULL, 0x0002e20000205400ULL, 0x0000000171713812ULL, 0x004fe400078efcffULL,
0x000000978600720bULL, 0x000fca0003f7d000ULL, 0x0000005a00777306ULL, 0x000ea2000000d400ULL,
0x000000a400a47245ULL, 0x002fce000020d400ULL, 0x000000a1005a7306ULL, 0x000fe20000209400ULL,
0x000000be5b00720bULL, 0x008fe40003fbd000ULL, 0x0000000170703812ULL, 0x000fe400078efcffULL,
0x0000008ba000720bULL, 0x000fe40003f7d000ULL, 0x000000718e8b723eULL, 0x000fe200000010ffULL,
0x000000a100a57306ULL, 0x0002e20000205400ULL, 0x0000000177774812ULL, 0x004fc800078efcffULL,
0x000000778a8a723eULL, 0x000fe400000010ffULL, 0x00000001a4a45812ULL, 0x000fe200078efcffULL,
0x0000009d008f7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fe4000020d400ULL,
0x000000016a6a3812ULL, 0x000fca00078efcffULL, 0x0000009d008c7306ULL, 0x0002a20000205400ULL,
0x000000a55a00720bULL, 0x008fe40003f3d000ULL, 0x000000585458723cULL, 0x000fea0000041808ULL,
0x000000a600ae7306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fe4000020d400ULL,
0x000000acb508723eULL, 0x000fc400000010ffULL, 0x000000c9aa09723eULL, 0x000fe400000010ffULL,
0x00000001a1a11812ULL, 0x000fe200078efcffULL, 0x000000a600ad7306ULL, 0x000e620000205400ULL,
0x0000008c8f00720bULL, 0x004fe40003f9d000ULL, 0x000000879600720bULL, 0x000fe20003f3d000ULL,
0x000000085408723cULL, 0x000fe20000041828ULL, 0x0000009800877245ULL, 0x000fe4000020d400ULL,
0x000000a19494723eULL, 0x000fe200000010ffULL, 0x0000005c00887306ULL, 0x000fe60000009400ULL,
0x000000cea328723eULL, 0x000fc400000010ffULL, 0x000000d4a729723eULL, 0x000fe400000010ffULL,
0x000000019d9d4812ULL, 0x000fe200078efcffULL, 0x0000005c008d7306ULL, 0x000fe20000005400ULL,
0x000000016d6d1812ULL, 0x000fc600078efcffULL, 0x000000285428723cULL, 0x040fe80000041814ULL,
0x0000005c00667306ULL, 0x0005e8000000d400ULL, 0x0000008a5414723cULL, 0x000fe80000041810ULL,
0x0000005e009a7306ULL, 0x000fe20000009400ULL, 0x000001005d5c7824ULL, 0x004fc400078e00ffULL,
0x000000ab00117245ULL, 0x000fe4000020d400ULL, 0x0000006500127245ULL, 0x000fe4000020d400ULL,
0x00000018ff857819ULL, 0x000fe2000001145cULL, 0x0000005e00997306ULL, 0x000fe20000005400ULL,
0x00000084db5c723eULL, 0x000fe400000010ffULL, 0x000000b300847245ULL, 0x000fe4000020d400ULL,
0x0000008500107245ULL, 0x000fc4000020d400ULL, 0x0000000184842812ULL, 0x000fe200078efcffULL,
0x0000005e00617306ULL, 0x0005e2000000d400ULL, 0x000000adae00720bULL, 0x002fe40003f5d000ULL,
0x0000006b8484723eULL, 0x000fca00000010ffULL, 0x0000005d009b7306ULL, 0x000fe20000009400ULL,
0x00000018ff5e7819ULL, 0x004fc800000114ecULL, 0x0000005e00867245ULL, 0x000fe4000020d400ULL,
0x0000000181812812ULL, 0x000fe200078efcffULL, 0x0000005d00927306ULL, 0x000ff00000005400ULL,
0x0000005d00637306ULL, 0x000ff0000000d400ULL, 0x000000c100c67306ULL, 0x000ff00000209400ULL,
0x000000c1005d7306ULL, 0x0002b00000205400ULL, 0x0000007e00827306ULL, 0x000fe20000209400ULL,
0x000000c100c17245ULL, 0x002fce000020d400ULL, 0x0000007e00837306ULL, 0x0002e20000205400ULL,
0x0000005dc600720bULL, 0x004fe40003fbd000ULL, 0x00000089e25d723eULL, 0x000fca00000010ffULL,
0x0000005e00dc7306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x002fca000020d400ULL,
0x00000001c1c15812ULL, 0x000fe400078efcffULL, 0x0000005e00e17306ULL, 0x0002a20000205400ULL,
0x000000838200720bULL, 0x008fe40003fdd000ULL, 0x00000070c170723eULL, 0x000fca00000010ffULL,
0x000000bf00a87306ULL, 0x000fe20000209400ULL, 0x0000005c545c723cULL, 0x002fea000004180cULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x000000bf00a57306ULL, 0x0002e20000205400ULL,
0x000000e1dc00720bULL, 0x004fe40003f9d000ULL, 0x0000007dc80c723eULL, 0x000fc400000010ffULL,
0x0000007cc70d723eULL, 0x000fc600000010ffULL, 0x000000c3008c7306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x002fc6000020d400ULL, 0x0000000c540c723cULL, 0x000fe4000004181cULL,
0x0000000186864812ULL, 0x000fe400078efcffULL, 0x000000c3008f7306ULL, 0x000e620000205400ULL,
0x000000a5a800720bULL, 0x008fe40003f5d000ULL, 0x0000006d8671723eULL, 0x000fca00000010ffULL,
0x0000009c00a27306ULL, 0x000fec0000209400ULL, 0x00000001bfbf2812ULL, 0x000fe400078efcffULL,
0x0000009c00917306ULL, 0x0004e20000205400ULL, 0x0000008f8c00720bULL, 0x002fe40003f7d000ULL,
0x000000bf7e7e723eULL, 0x000fca00000010ffULL, 0x000000e400af7306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x004fca000020d400ULL, 0x000000017f7f3812ULL, 0x000fe400078efcffULL,
0x000000e400c07306ULL, 0x0002a20000205400ULL, 0x00000091a200720bULL, 0x008fe40003fbd000ULL,
0x000000747500720bULL, 0x000fe40003f7d000ULL, 0x000000c400757245ULL, 0x000fc6000020d400ULL,
0x000000c400907306ULL, 0x000fe20000209400ULL, 0x000000e400e47245ULL, 0x002fca000020d400ULL,
0x000000019c9c5812ULL, 0x000fe400078efcffULL, 0x000000c400957306ULL, 0x000e620000205400ULL,
0x000000c0af00720bULL, 0x004fe40003f9d000ULL, 0x0000008d8800720bULL, 0x000fe40003fbd000ULL,
0x000000df9c1c723eULL, 0x000fe400000010ffULL, 0x0000000162623812ULL, 0x000fe200078efcffULL,
0x00000076007a7306ULL, 0x000fec0000209400ULL, 0x00000001e4e44812ULL, 0x000fc400078efcffULL,
0x0000007600797306ULL, 0x0004e20000205400ULL, 0x000000959000720bULL, 0x002fe40003fdd000ULL,
0x000000929b00720bULL, 0x000fe40003f9d000ULL, 0x000000a49d95723eULL, 0x000fe400000010ffULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x00000098009e7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x004fc6000020d400ULL, 0x000000945454723cULL, 0x000fe40000041818ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x0000009800937306ULL, 0x000e620000205400ULL,
0x000000797a00720bULL, 0x008fe40003f5d000ULL, 0x0000000163634812ULL, 0x000fe200078efcffULL,
0x000000702018723cULL, 0x000fe2000004185cULL, 0x000000667566723eULL, 0x000fc600000010ffULL,
0x0000008500917306ULL, 0x000fec0000209400ULL, 0x0000000176762812ULL, 0x000fe400078efcffULL,
0x0000008500967306ULL, 0x0004e20000205400ULL, 0x000000939e00720bULL, 0x002fe40003f3d000ULL,
0x0000007f767f723eULL, 0x000fca00000010ffULL, 0x0000006c00727306ULL, 0x000fe20000209400ULL,
0x0000006a8185723eULL, 0x004fe200000010ffULL, 0x0000007e2008723cULL, 0x040fe80000041808ULL,
0x0000000187871812ULL, 0x000fe400078efcffULL, 0x0000006c00737306ULL, 0x0002a20000205400ULL,
0x000000969100720bULL, 0x008fe20003fdd000ULL, 0x000000842004723cULL, 0x000fe20000041804ULL,
0x000000e4871d723eULL, 0x000fc400000010ffULL, 0x000000999a00720bULL, 0x000fc60003f3d000ULL,
0x00000065006f7306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fe2000020d400ULL,
0x0000001c201c723cULL, 0x000fe80000041858ULL, 0x0000000110106812ULL, 0x000fe400078efcffULL,
0x00000065006e7306ULL, 0x000e620000205400ULL, 0x000000737200720bULL, 0x004fe40003f5d000ULL,
0x0000009f00587245ULL, 0x000fc4000020d400ULL, 0x0000000161611812ULL, 0x000fc600078efcffULL,
0x000000cf00887306ULL, 0x000fec0000209400ULL, 0x000000016c6c2812ULL, 0x000fe400078efcffULL,
0x000000cf00897306ULL, 0x0004e20000205400ULL, 0x0000006e6f00720bULL, 0x002fce0003fbd000ULL,
0x000000ab00827306ULL, 0x000fe20000209400ULL, 0x000000cf00cf7245ULL, 0x004fca000020d400ULL,
0x0000000112125812ULL, 0x000fe400078efcffULL, 0x000000ab00837306ULL, 0x000e620000205400ULL,
0x000000898800720bULL, 0x008fce0003fdd000ULL, 0x0000009f007c7306ULL, 0x000fec0000209400ULL,
0x00000001cfcf6812ULL, 0x000fe400078efcffULL, 0x0000009f00797306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fce0003f9d000ULL, 0x0000006000647306ULL, 0x000fec0000209400ULL,
0x0000000111114812ULL, 0x000fe400078efcffULL, 0x0000006000677306ULL, 0x0002e20000205400ULL,
0x000000797c00720bULL, 0x004fe40003f5d000ULL, 0x000000111211723eULL, 0x000fca00000010ffULL,
0x0000008000747306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x002fca000020d400ULL,
0x0000000158582812ULL, 0x000fe400078efcffULL, 0x0000008000737306ULL, 0x000e620000205400ULL,
0x000000676400720bULL, 0x008fe40003f9d000ULL, 0x000000631067723eULL, 0x000fe400000010ffULL,
0x000000cf6c10723eULL, 0x000fe400000010ffULL, 0x000000615858723eULL, 0x000fe200000010ffULL,
0x0000000000687306ULL, 0x000fe40000209400ULL, 0x00000066200c723cULL, 0x000fe8000004180cULL,
0x0000000160604812ULL, 0x000fc400078efcffULL, 0x0000000000697306ULL, 0x0004e20000205400ULL,
0x000000737400720bULL, 0x002fce0003fbd000ULL, 0x0000007b00137306ULL, 0x000fe20000209400ULL,
0x0000000000007245ULL, 0x004fce000020d400ULL, 0x0000007b006e7306ULL, 0x0002a20000205400ULL,
0x000000696800720bULL, 0x008fce0003fdd000ULL, 0x00000078005c7306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x0000007800597306ULL, 0x000e620000205400ULL, 0x0000006e1300720bULL, 0x004fe40003f5d000ULL,
0x000000102010723cULL, 0x000fee0000041828ULL, 0x0000007800297245ULL, 0x000fc8000020d400ULL,
0x000000017b7b2812ULL, 0x000fe400078efcffULL, 0x000000595c00720bULL, 0x002fe40003f3d000ULL,
0x0000008000597245ULL, 0x000fe4000020d400ULL, 0x0000007b0028723eULL, 0x000fe400000010ffULL,
0x0000000159595812ULL, 0x000fc800078efcffULL, 0x000000625959723eULL, 0x000fc600000010ffULL,
0x0000000129291812ULL, 0x000fc800078efcffULL, 0x000000296029723eULL, 0x000fe200000010ffULL,
0x000000582014723cULL, 0x040ff00000041814ULL, 0x000000282020723cULL, 0x000fe20000041854ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c024007811ULL, 0x000fe200078e40ffULL, 0x01063000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff53ff7812ULL, 0x000fc4000784c0ffULL, 0x000000000300720cULL, 0x000fe40003f24070ULL,
0x00000001ff647807ULL, 0x000fd60001000000ULL, 0x00004a9000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01065c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000e024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff5b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff597819ULL, 0x000fe40000011626ULL, 0x0000000003297217ULL, 0x000fe20007800000ULL,
0x00006200272b7a24ULL, 0x000fc800078e0200ULL, 0x0000000129297824ULL, 0x000fe400078e0a00ULL,
0x0000000133287824ULL, 0x100fe400078e022bULL, 0x00000001362a7824ULL, 0x000fe200078e022bULL,
0x0000002029557807ULL, 0x000fe20000000000ULL, 0x00005e0028287625ULL, 0x000fc600078e005bULL,
0x000000552c557217ULL, 0x000fe20007800000ULL, 0x0000000138547824ULL, 0x000fe200078e022bULL,
0x0000003428567210ULL, 0x000fc60007f1e0ffULL, 0x0000000155007824ULL, 0x000fe400078e0a2cULL,
0x000000013a557824ULL, 0x000fe400078e022bULL, 0x000000ffff577224ULL, 0x000fe200000e0629ULL,
0x000000005900720cULL, 0x080fe20003f06070ULL, 0x00005e002a287625ULL, 0x080fe200078e005bULL,
0x000000003500720cULL, 0x080fe40003f26070ULL, 0x000000003700720cULL, 0x080fe20003f46070ULL,
0x00005e00542a7625ULL, 0x000fe200078e005bULL, 0x000000003900720cULL, 0x000fc40003f66070ULL,
0x0000003428287210ULL, 0x080fe20007f9e0ffULL, 0x00005e0055547625ULL, 0x000fe200078e005bULL,
0x000000342a2a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe200020e0629ULL,
0x0000003454547210ULL, 0x000fe20007fde0ffULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000563f7faeULL, 0x0003e6000c101c46ULL,
0x000000ffff557224ULL, 0x000fe200030e0655ULL, 0x0000000028407faeULL, 0x0003e8000c901c46ULL,
0x000000002a417faeULL, 0x0003e8000d101c46ULL, 0x0000000054427faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff007984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01063c00ff287984ULL, 0x002e620000000800ULL,
0x8000000052297824ULL, 0x000fc400078e00ffULL, 0x80000000432b7824ULL, 0x000fc600078e00ffULL,
0x8000000000ff7812ULL, 0x004fe40007804829ULL, 0x8000000028ff7812ULL, 0x002fe2000782482bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000043437824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000287305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000280000735dULL, 0x004fe40003800000ULL, 0x01063c00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fc40007824843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0101800044007984ULL, 0x000e620000000800ULL,
0x00000001ff727424ULL, 0x000fc600078e00ffULL, 0x0103800044297984ULL, 0x0004e20000000800ULL,
0x0000002d0000720bULL, 0x002fda0003f3d000ULL, 0x0000000000287806ULL, 0x000fc800008e0100ULL,
0x0000ffff282b7812ULL, 0x000fda000782c0ffULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x0000002d0000720bULL, 0x00cfe40003f34000ULL, 0x000000002d3f7209ULL, 0x000fca0007810000ULL,
0x8000003f2d287221ULL, 0x000fe20000010000ULL, 0x00000002ff2d7819ULL, 0x000fc60000011626ULL,
0x3fb8aa3b282a7820ULL, 0x000fe40000410000ULL, 0x0000000000287806ULL, 0x000fe400008e0100ULL,
0x000000030200780cULL, 0x000fe40003f25270ULL, 0x0000ffff28407812ULL, 0x000fe200078e3cffULL,
0x0000002a002a7308ULL, 0x000e660000000800ULL, 0x000000402bff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff727807ULL, 0x000fc60001000000ULL, 0x0105803f44009388ULL, 0x000fec0000000800ULL,
0x8000003f002b2221ULL, 0x100fe20000010000ULL, 0x00001f2d2a287589ULL, 0x0022a200000e0000ULL,
0x0000002a2e2e7220ULL, 0x000fe40000410000ULL, 0x3fb8aa3b2b2b2820ULL, 0x000fe20000410000ULL,
0x00001f3b2a007589ULL, 0x000ee600000e0000ULL, 0x0000002b00322308ULL, 0x000f220000000800ULL,
0x000000ffff2d7224ULL, 0x002fe200078e003fULL, 0x0000002932292220ULL, 0x010fe20000410000ULL,
0x0000002818187220ULL, 0x084fe20000410000ULL, 0x0000002819197220ULL, 0x080fe20000410000ULL,
0x000000281c1c7220ULL, 0x080fe20000410000ULL, 0x000000281d1d7220ULL, 0x080fe20000410000ULL,
0x0000002804047220ULL, 0x080fe20000410000ULL, 0x0000002805057220ULL, 0x080fe20000410000ULL,
0x0000002808087220ULL, 0x080fe20000410000ULL, 0x0000002809097220ULL, 0x080fe20000410000ULL,
0x000000280c0c7220ULL, 0x080fe20000410000ULL, 0x000000280d0d7220ULL, 0x080fe20000410000ULL,
0x0000002810107220ULL, 0x080fe20000410000ULL, 0x0000002811117220ULL, 0x080fe20000410000ULL,
0x0000002814147220ULL, 0x080fe20000410000ULL, 0x0000002815157220ULL, 0x080fe20000410000ULL,
0x0000002820207220ULL, 0x080fe20000410000ULL, 0x0000002821217220ULL, 0x000fe20000410000ULL,
0x000000001a1a7220ULL, 0x088fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x000fe20000410000ULL,
0x0000002e292e7221ULL, 0x00cfe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x01064c00ff007984ULL, 0x000e620000000800ULL, 0x8000000052297824ULL, 0x000fca00078e00ffULL,
0x8000000000ff7812ULL, 0x002fe20007804829ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000052297824ULL, 0x000fe400078e00ffULL, 0x0000000000287305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x01064c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000004528783bULL, 0x000e680000004200ULL, 0x000000004640783bULL, 0x000ea80000004200ULL,
0x000000004754783bULL, 0x000ee80000004200ULL, 0x000000004858783bULL, 0x000f220000004200ULL,
0x00000018ffbd7819ULL, 0x002fe20000011428ULL, 0x0000010028d77824ULL, 0x000fe200078e00ffULL,
0x0000002800e17306ULL, 0x000fe20000009400ULL, 0x0000010029c87824ULL, 0x000fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe20000011429ULL, 0x000001002ac47824ULL, 0x000fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fe200000114d7ULL, 0x0001000028cc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000001002bc17824ULL, 0x000fe200078e00ffULL,
0x0000002800ae7306ULL, 0x000e620000005400ULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x000100002ac97824ULL, 0x000fe200078e00ffULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x0001000029c57824ULL, 0x000fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x000100002bb77824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe2000001142aULL,
0x000000bd00c77306ULL, 0x000fe20000209400ULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010040a37824ULL, 0x004fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x0001000043aa7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001142bULL,
0x0000010055e47824ULL, 0x008fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fe200000114b7ULL,
0x000000bd00c67306ULL, 0x0004e20000205400ULL, 0x000000aee100720bULL, 0x002fe20003fbd000ULL,
0x0001000055e57824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe200000114a3ULL,
0x0001000042a67824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe20000011440ULL,
0x0000010057dc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x0000002900cf7306ULL, 0x000fe20000009400ULL, 0x000000bd00bd7245ULL, 0x004fe2000020d400ULL,
0x0000010056df7824ULL, 0x040fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe20000011442ULL,
0x0001000056ac7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe20000011443ULL,
0x0000010054e07824ULL, 0x040fe200078e00ffULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x0000002900b07306ULL, 0x000e620000005400ULL, 0x000000c6c700720bULL, 0x008fe20003f5d000ULL,
0x0001000057ad7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc67819ULL, 0x000fe200000114e4ULL,
0x0001000054e27824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc40000011454ULL,
0x00000018ff977819ULL, 0x000fe20000011441ULL, 0x000000d700de7306ULL, 0x000fe20000209400ULL,
0x00000018ff7b7819ULL, 0x000fe40000011455ULL, 0x00000018ff707819ULL, 0x000fe40000011456ULL,
0x00000018ffa67819ULL, 0x000fe400000114a6ULL, 0x00000001bdbd2812ULL, 0x000fe200078efcffULL,
0x000000d700e37306ULL, 0x000ea20000205400ULL, 0x000000b0cf00720bULL, 0x002fc40003f3d000ULL,
0x000000d700b07245ULL, 0x000fe4000020d400ULL, 0x00000018ffdc7819ULL, 0x000fe400000114dcULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x000000c800d87306ULL, 0x000fe20000209400ULL,
0x00000018ffae7819ULL, 0x000fe400000114e0ULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ff6c7819ULL, 0x000fc40000011457ULL, 0x00000018ff627819ULL, 0x010fe20000011458ULL,
0x000000c800db7306ULL, 0x000e620000205400ULL, 0x000000e3de00720bULL, 0x004fe40003f1d000ULL,
0x00000018ffdf7819ULL, 0x000fe400000114dfULL, 0x00000018ff477819ULL, 0x000fe40000011459ULL,
0x00000018ff007819ULL, 0x000fe2000001145aULL, 0x0000002800797306ULL, 0x0004e2000000d400ULL,
0x00000018ff3f7819ULL, 0x000fca000001145bULL, 0x00000001b0b00812ULL, 0x000fe400078efcffULL,
0x000000b500bf7306ULL, 0x000fe20000209400ULL, 0x000000dbd800720bULL, 0x002fe20003f9d000ULL,
0x0001000040287824ULL, 0x004fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x000000b500c07306ULL, 0x000e620000205400ULL, 0x0000000179795812ULL, 0x008fce00078efcffULL,
0x000000c400d27306ULL, 0x000ff00000209400ULL, 0x000000c400cd7306ULL, 0x0004e20000205400ULL,
0x000000c0bf00720bULL, 0x002fe40003fbd000ULL, 0x000000c800bf7245ULL, 0x000fc8000020d400ULL,
0x00000001bfbf4812ULL, 0x000fe200078efcffULL, 0x000000cc00dd7306ULL, 0x000fe20000209400ULL,
0x000000c400c47245ULL, 0x004fce000020d400ULL, 0x000000cc00da7306ULL, 0x0002a20000205400ULL,
0x000000cdd200720bULL, 0x008fe40003f5d000ULL, 0x000000c500cd7245ULL, 0x000fca000020d400ULL,
0x0000002900787306ULL, 0x000722000000d400ULL, 0x000000cc00cc7245ULL, 0x002fca000020d400ULL,
0x00000001c4c42812ULL, 0x000fe400078efcffULL, 0x0000002b00c27306ULL, 0x000fe20000009400ULL,
0x0000010041297824ULL, 0x008fe200078e00ffULL, 0x000000dadd00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002b00c37306ULL, 0x000e620000005400ULL,
0x0000000178781812ULL, 0x010fcc00078efcffULL, 0x00000001cccc3812ULL, 0x000fe200078efcffULL,
0x0000004000be7306ULL, 0x000fe60000009400ULL, 0x000000ccbdcc723eULL, 0x000fca00000010ffULL,
0x0000004000bb7306ULL, 0x000ea20000005400ULL, 0x000000c3c200720bULL, 0x002fce0003f1d000ULL,
0x000000c100d67306ULL, 0x000ff00000209400ULL, 0x000000c100d97306ULL, 0x000e620000205400ULL,
0x000000bbbe00720bULL, 0x004fe40003f9d000ULL, 0x000000b500be7245ULL, 0x000fc4000020d400ULL,
0x00000018ffbb7819ULL, 0x000fe400000114e2ULL, 0x00000001bebe5812ULL, 0x000fe200078efcffULL,
0x0000009f00b27306ULL, 0x000ff00000209400ULL, 0x0000009f00b17306ULL, 0x000ea20000205400ULL,
0x000000d9d600720bULL, 0x002fce0003f3d000ULL, 0x000000c900ca7306ULL, 0x000ff00000209400ULL,
0x000000c900d57306ULL, 0x0002e20000205400ULL, 0x000000b1b200720bULL, 0x004fe40003fbd000ULL,
0x000000c100b27245ULL, 0x000fc8000020d400ULL, 0x00000001b2b21812ULL, 0x000fe200078efcffULL,
0x000000c500d37306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fce000020d400ULL,
0x000000c500d07306ULL, 0x000e620000205400ULL, 0x000000d5ca00720bULL, 0x008fce0003f5d000ULL,
0x0000002b00717306ULL, 0x0004ec000000d400ULL, 0x00000001c9c92812ULL, 0x000fe400078efcffULL,
0x00000088009d7306ULL, 0x000fe20000209400ULL, 0x00010000412b7824ULL, 0x004fe200078e00ffULL,
0x000000d0d300720bULL, 0x002fc80003f7d000ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000088009e7306ULL, 0x0002a20000205400ULL, 0x0000000171710812ULL, 0x008fc800078efcffULL,
0x00000071b2c5723eULL, 0x000fe400000010ffULL, 0x00000001cdcd3812ULL, 0x000fe200078efcffULL,
0x000000b700d47306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fe4000020d400ULL,
0x000000cdbecd723eULL, 0x000fca00000010ffULL, 0x000000b700cb7306ULL, 0x0002e20000205400ULL,
0x0000009e9d00720bULL, 0x004fe40003f1d000ULL, 0x0000009f009e7245ULL, 0x000fc8000020d400ULL,
0x000000019e9e5812ULL, 0x000fe200078efcffULL, 0x0000002a00ce7306ULL, 0x000fe20000009400ULL,
0x000000b700b77245ULL, 0x002fe4000020d400ULL, 0x000000c99e9e723eULL, 0x000fc600000010ffULL,
0x0000000188880812ULL, 0x000fe400078efcffULL, 0x0000002a00d17306ULL, 0x000e620000005400ULL,
0x000000cbd400720bULL, 0x008fce0003f3d000ULL, 0x0000002900b37306ULL, 0x000fec0000209400ULL,
0x00000001b7b71812ULL, 0x000fe400078efcffULL, 0x0000002900ba7306ULL, 0x000ea20000205400ULL,
0x000000d1ce00720bULL, 0x002fe40003fdd000ULL, 0x000000b7889f723eULL, 0x000fca00000010ffULL,
0x000000a300b87306ULL, 0x000ff00000209400ULL, 0x000000a300b97306ULL, 0x000e620000205400ULL,
0x000000bab300720bULL, 0x004fce0003fbd000ULL, 0x0000004100af7306ULL, 0x000ff00000009400ULL,
0x0000004100b47306ULL, 0x000ea20000005400ULL, 0x000000b9b800720bULL, 0x002fce0003f5d000ULL,
0x00000043009c7306ULL, 0x000ff00000009400ULL, 0x0000004300877306ULL, 0x000e620000005400ULL,
0x000000b4af00720bULL, 0x004fce0003f7d000ULL, 0x0000002800a97306ULL, 0x000ff00000209400ULL,
0x0000002800b67306ULL, 0x000ea20000205400ULL, 0x000000879c00720bULL, 0x002fe40003f3d000ULL,
0x00000029009c7245ULL, 0x000fc4000020d400ULL, 0x0000008c00877245ULL, 0x000fe4000020d400ULL,
0x000000019c9c5812ULL, 0x000fe200078efcffULL, 0x0000002a00737306ULL, 0x0002f0000000d400ULL,
0x00000040006f7306ULL, 0x000962000000d400ULL, 0x000000b6a900720bULL, 0x004fe20003f1d000ULL,
0x00000100432a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000004200a27306ULL, 0x000fe20000009400ULL, 0x0000010042407824ULL, 0x010fe200078e00ffULL,
0x0000000173736812ULL, 0x008fc800078efcffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004200a57306ULL, 0x000e620000005400ULL, 0x000000016f6f4812ULL, 0x020fe400078efcffULL,
0x00000073c4c4723eULL, 0x000fca00000010ffULL, 0x0000002b00a77306ULL, 0x000ff00000209400ULL,
0x0000002b00a87306ULL, 0x000ea20000205400ULL, 0x000000a5a200720bULL, 0x002fe40003fdd000ULL,
0x000000a300a27245ULL, 0x000fc8000020d400ULL, 0x00000001a2a22812ULL, 0x000fe200078efcffULL,
0x0000008c009b7306ULL, 0x000fe60000209400ULL, 0x0000006fa2a2723eULL, 0x000fca00000010ffULL,
0x0000008c00867306ULL, 0x0002e20000205400ULL, 0x000000a8a700720bULL, 0x004fce0003fbd000ULL,
0x00000041006b7306ULL, 0x000ea2000000d400ULL, 0x00000097008c7245ULL, 0x002fce000020d400ULL,
0x0000004000a07306ULL, 0x000fe20000209400ULL, 0x000000869b00720bULL, 0x008fe40003f5d000ULL,
0x0000002800867245ULL, 0x000fe4000020d400ULL, 0x0000b80049287811ULL, 0x000fe400078e20ffULL,
0x0000000186860812ULL, 0x000fe200078efcffULL, 0x0000004000a17306ULL, 0x000e620000205400ULL,
0x000000016b6b3812ULL, 0x004fe400078efcffULL, 0x00000002ff497819ULL, 0x000fc40000011626ULL,
0x0000006b9ca3723eULL, 0x000fe400000010ffULL, 0x0000000187872812ULL, 0x000fe200078efcffULL,
0x0000005400987306ULL, 0x000fe60000009400ULL, 0x000000868786723eULL, 0x000fca00000010ffULL,
0x0000005400857306ULL, 0x000ea20000005400ULL, 0x000000a1a000720bULL, 0x002fce0003f7d000ULL,
0x0000004200677306ULL, 0x000e70000000d400ULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000000859800720bULL, 0x004fe40003f1d000ULL, 0x0000002b00857245ULL, 0x000fc8000020d400ULL,
0x0000000185855812ULL, 0x000fe200078efcffULL, 0x000000aa00bc7306ULL, 0x0004e20000205400ULL,
0x0000000167676812ULL, 0x002fce00078efcffULL, 0x0000005500957306ULL, 0x000fe20000009400ULL,
0x000000aa00aa7245ULL, 0x004fce000020d400ULL, 0x0000005500847306ULL, 0x000e620000005400ULL,
0x000000bcab00720bULL, 0x008fce0003fdd000ULL, 0x0000009000937306ULL, 0x000fec0000209400ULL,
0x00000001aaaa6812ULL, 0x000fe400078efcffULL, 0x0000009000967306ULL, 0x000ea20000205400ULL,
0x000000849500720bULL, 0x002fe40003fbd000ULL, 0x0000004000847245ULL, 0x000fc4000020d400ULL,
0x00000032ff40723eULL, 0x000fe400000010ffULL, 0x0000000184843812ULL, 0x000fe200078efcffULL,
0x000000c600c27306ULL, 0x000fe60000209400ULL, 0x000000678484723eULL, 0x000fca00000010ffULL,
0x000000c600c37306ULL, 0x0002e20000205400ULL, 0x000000969300720bULL, 0x004fe40003f7d000ULL,
0x0000002a00937245ULL, 0x000fca000020d400ULL, 0x0000004300687306ULL, 0x000ea2000000d400ULL,
0x000000c600c67245ULL, 0x002fce000020d400ULL, 0x0000008f00927306ULL, 0x000fe20000209400ULL,
0x000000c3c200720bULL, 0x008fce0003fdd000ULL, 0x0000008f008b7306ULL, 0x0002e20000205400ULL,
0x0000000168681812ULL, 0x004fca00078efcffULL, 0x00000001c6c66812ULL, 0x000fe400078efcffULL,
0x0000005500637306ULL, 0x000522000000d400ULL, 0x0000008f008f7245ULL, 0x002fce000020d400ULL,
0x0000005400647306ULL, 0x000362000000d400ULL, 0x0000008b9200720bULL, 0x008fe20003f3d000ULL,
0x000001005a557824ULL, 0x004fe200078e00ffULL, 0x00000090008b7245ULL, 0x000fe4000020d400ULL,
0x0000541040907816ULL, 0x000fe40000000040ULL, 0x0000991072407816ULL, 0x000fe200000000ffULL,
0x000000e500a57306ULL, 0x000fe20000209400ULL, 0x0000000163635812ULL, 0x010fe200078efcffULL,
0x00001f4990497589ULL, 0x000fe200000e0000ULL, 0x0000007b00727245ULL, 0x000fe2000020d400ULL,
0x000001005b547824ULL, 0x002fe200078e00ffULL, 0x000000018b8b3812ULL, 0x000fc400078efcffULL,
0x000000018f8f1812ULL, 0x000fe200078efcffULL, 0x000000e500b87306ULL, 0x0002a20000205400ULL,
0x0000000164640812ULL, 0x020fe400078efcffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x000000aa8f8f723eULL, 0x000fc600000010ffULL, 0x0000007c00807306ULL, 0x000fe20000209400ULL,
0x000000e500e57245ULL, 0x002fce000020d400ULL, 0x0000007c007f7306ULL, 0x0002e20000205400ULL,
0x000000b8a500720bULL, 0x004fce0003fbd000ULL, 0x0000009700997306ULL, 0x000fe20000209400ULL,
0x0000007c007c7245ULL, 0x002fca000020d400ULL, 0x00000001e5e55812ULL, 0x000fe400078efcffULL,
0x00000097009a7306ULL, 0x000e620000205400ULL, 0x0000007f8000720bULL, 0x008fe40003f1d000ULL,
0x000000ff4000720cULL, 0x000fe40003fa5270ULL, 0x00000079b040723eULL, 0x000fc600000010ffULL,
0x0000002a00417306ULL, 0x000fec0000209400ULL, 0x000000017c7c0812ULL, 0x000fe400078efcffULL,
0x0000002a00a47306ULL, 0x0004e20000205400ULL, 0x0000009a9900720bULL, 0x002fce0003f9d000ULL,
0x0000007b00817306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x004e6a0000000200ULL,
0x000000018c8c4812ULL, 0x000fe400078efcffULL, 0x0000007b00827306ULL, 0x000ea20000205400ULL,
0x000000a44100720bULL, 0x008fe40003f5d000ULL, 0x000000858c87723eULL, 0x000fca00000010ffULL,
0x0000005600947306ULL, 0x000fec0000009400ULL, 0x0000000193932812ULL, 0x000fe400078efcffULL,
0x00000056008d7306ULL, 0x000ee20000005400ULL, 0x000000828100720bULL, 0x004fe40003fdd000ULL,
0x000000689385723eULL, 0x000fca00000010ffULL, 0x0000005600607306ULL, 0x00052c000000d400ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000a600427306ULL, 0x000fe20000209400ULL,
0x0000010058567824ULL, 0x004fe200078e00ffULL, 0x000000492828d231ULL, 0x082fe200003400ffULL,
0x0000008d9400720bULL, 0x008fe20003f5d000ULL, 0x000000492a2ad231ULL, 0x000fe200003400ffULL,
0x000000ae008d7245ULL, 0x000fc4000020d400ULL, 0x00000018ff7f7819ULL, 0x000fe20000011456ULL,
0x000000a600437306ULL, 0x0002a20000205400ULL, 0x00001f3b90567589ULL, 0x000eee00000e0000ULL,
0x000000dc00987306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x002fc4000020d400ULL,
0x0000000160602812ULL, 0x010fca00078efcffULL, 0x000000dc00417306ULL, 0x0003220000205400ULL,
0x000000434200720bULL, 0x004fce0003f9d000ULL, 0x0000005700917306ULL, 0x000fe20000009400ULL,
0x000000562929d231ULL, 0x088fe200003400ffULL, 0x000000dc00dc7245ULL, 0x002fe2000020d400ULL,
0x000000562b2bd231ULL, 0x000fc600003400ffULL, 0x00000001a6a64812ULL, 0x000fe400078efcffULL,
0x00000057008a7306ULL, 0x000e620000005400ULL, 0x000000419800720bULL, 0x010fe20003fdd000ULL,
0x000000cc281c723cULL, 0x000fe2000004181cULL, 0x00000078bf41723eULL, 0x000fca00000010ffULL,
0x000000ac00427306ULL, 0x000fe40000209400ULL, 0x000000c42804723cULL, 0x040fe80000041804ULL,
0x00000001dcdc6812ULL, 0x000fe400078efcffULL, 0x000000ac00437306ULL, 0x0004e20000205400ULL,
0x0000008a9100720bULL, 0x002fe20003f7d000ULL, 0x0000009e2808723cULL, 0x040fec0000041808ULL,
0x0000005800897306ULL, 0x000fe20000009400ULL, 0x000000ac00ac7245ULL, 0x004fe2000020d400ULL,
0x000000a2280c723cULL, 0x040fec000004180cULL, 0x00000058008e7306ULL, 0x000e620000005400ULL,
0x000000434200720bULL, 0x008fe20003fdd000ULL, 0x000000862810723cULL, 0x040fec0000041810ULL,
0x0000005700617306ULL, 0x0004e4000000d400ULL, 0x000000402840723cULL, 0x000fe80000041818ULL,
0x00000001acac6812ULL, 0x000fc400078efcffULL, 0x0000007000757306ULL, 0x000fe20000209400ULL,
0x0000b8004a187811ULL, 0x000fe200078e20ffULL, 0x0000010059577824ULL, 0x004fe200078e00ffULL,
0x0000008e8900720bULL, 0x002fe20003f3d000ULL, 0x000000842814723cULL, 0x000fe60000041814ULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x0000007000747306ULL, 0x000ea20000205400ULL,
0x0000000161613812ULL, 0x008fe400078efcffULL, 0x00000018ff827819ULL, 0x000fc40000011457ULL,
0x0000007000577245ULL, 0x000fe4000020d400ULL, 0x00000061dc61723eULL, 0x000fe200000010ffULL,
0x000000ae00de7306ULL, 0x000ff00000209400ULL, 0x000000ae00cf7306ULL, 0x000ee20000205400ULL,
0x000000747500720bULL, 0x004fce0003f7d000ULL, 0x000000ad008a7306ULL, 0x000fec0000209400ULL,
0x0000000157573812ULL, 0x000fe400078efcffULL, 0x000000ad00897306ULL, 0x0005220000205400ULL,
0x000000cfde00720bULL, 0x008fe40003f9d000ULL, 0x000000ac57ac723eULL, 0x000fe200000010ffULL,
0x000000491818d231ULL, 0x002fc800003400ffULL, 0x0000006c006d7306ULL, 0x000fe20000209400ULL,
0x000000ad00ad7245ULL, 0x004fe2000020d400ULL, 0x000000491a1ad231ULL, 0x000fe200003400ffULL,
0x0000008200497245ULL, 0x000fe2000020d400ULL, 0x000000561919d231ULL, 0x080fe400003400ffULL,
0x000000018d8d4812ULL, 0x000fe200078efcffULL, 0x000000561b1bd231ULL, 0x000fe200003400ffULL,
0x0000006c006e7306ULL, 0x0002a20000205400ULL, 0x000000898a00720bULL, 0x010fe40003fdd000ULL,
0x000000648d64723eULL, 0x000fca00000010ffULL, 0x000000bb00b57306ULL, 0x000fe20000209400ULL,
0x0000006c006c7245ULL, 0x002fca000020d400ULL, 0x00000001adad6812ULL, 0x000fe400078efcffULL,
0x000000bb00b47306ULL, 0x0002e20000205400ULL, 0x0000006e6d00720bULL, 0x004fce0003f7d000ULL,
0x0000005b00777306ULL, 0x000fe20000009400ULL, 0x000000bb00bb7245ULL, 0x002fca000020d400ULL,
0x000000016c6c3812ULL, 0x000fe400078efcffULL, 0x0000005b00767306ULL, 0x000e620000005400ULL,
0x000000b4b500720bULL, 0x008fe40003f9d000ULL, 0x000000ad6cad723eULL, 0x000fca00000010ffULL,
0x0000007f00807306ULL, 0x000fe40000209400ULL, 0x000000ac1808723cULL, 0x000fe80000041808ULL,
0x00000001bbbb4812ULL, 0x000fe400078efcffULL, 0x0000007f00817306ULL, 0x0004e20000205400ULL,
0x000000767700720bULL, 0x002fe40003f5d000ULL, 0x000000bb7c7c723eULL, 0x000fca00000010ffULL,
0x00000058005c7306ULL, 0x000322000000d400ULL, 0x0000007f007f7245ULL, 0x004fce000020d400ULL,
0x00000059007a7306ULL, 0x000fe20000009400ULL, 0x0001000058587824ULL, 0x002fe200078e00ffULL,
0x000000818000720bULL, 0x008fc80003fdd000ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000059007d7306ULL, 0x000e620000005400ULL, 0x000000015c5c1812ULL, 0x010fcc00078efcffULL,
0x000000017f7f6812ULL, 0x000fe200078efcffULL, 0x0000006200697306ULL, 0x000fe60000209400ULL,
0x0000005c7f5c723eULL, 0x000fca00000010ffULL, 0x00000062006a7306ULL, 0x000ea20000205400ULL,
0x0000007d7a00720bULL, 0x002fe40003f1d000ULL, 0x000000e5727d723eULL, 0x000fca00000010ffULL,
0x000000df009d7306ULL, 0x000fe40000209400ULL, 0x0000007c181c723cULL, 0x000fec000004181cULL,
0x000000df009a7306ULL, 0x0002e20000205400ULL, 0x0000006a6900720bULL, 0x004fe40003f7d000ULL,
0x00000018ff697819ULL, 0x000fca0000011454ULL, 0x00000082008e7306ULL, 0x000fe20000209400ULL,
0x000000df00df7245ULL, 0x002fce000020d400ULL, 0x00000082007b7306ULL, 0x000e620000205400ULL,
0x0000009a9d00720bULL, 0x008fce0003f9d000ULL, 0x0000005900467306ULL, 0x0004ec000000d400ULL,
0x00000001dfdf4812ULL, 0x000fe400078efcffULL, 0x0000004700667306ULL, 0x000fe20000209400ULL,
0x0001000059597824ULL, 0x004fe200078e00ffULL, 0x0000007b8e00720bULL, 0x002fc40003f3d000ULL,
0x000000a68b8e723eULL, 0x000fe400000010ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000004700657306ULL, 0x000e620000205400ULL, 0x0000000146460812ULL, 0x008fe400078efcffULL,
0x0000008e2820723cULL, 0x000fe20000041820ULL, 0x00000060df60723eULL, 0x000fc600000010ffULL,
0x0000000149491812ULL, 0x000fe200078efcffULL, 0x0000005a00837306ULL, 0x000fe40000009400ULL,
0x0000006200297245ULL, 0x000fe2000020d400ULL, 0x000000601804723cULL, 0x000fe20000041804ULL,
0x0000004700287245ULL, 0x000fe4000020d400ULL, 0x0000000129293812ULL, 0x000fe400078efcffULL,
0x0000005a007e7306ULL, 0x000ea20000005400ULL, 0x000000656600720bULL, 0x002fc40003fdd000ULL,
0x00000063c665723eULL, 0x000fca00000010ffULL, 0x0000005800787306ULL, 0x000fe40000209400ULL,
0x000000641840723cULL, 0x000fe80000041840ULL, 0x0000000128286812ULL, 0x000fe400078efcffULL,
0x0000005800777306ULL, 0x0002e20000205400ULL, 0x0000007e8300720bULL, 0x004fce0003f9d000ULL,
0x00000059004a7306ULL, 0x000fe20000209400ULL, 0x0000005800587245ULL, 0x002fce000020d400ULL,
0x0000005900717306ULL, 0x0002a20000205400ULL, 0x000000777800720bULL, 0x008fce0003f3d000ULL,
0x00000055006d7306ULL, 0x000fe20000209400ULL, 0x0000005900597245ULL, 0x002fca000020d400ULL,
0x0000000158581812ULL, 0x000fe400078efcffULL, 0x00000055006e7306ULL, 0x0002e20000205400ULL,
0x000000714a00720bULL, 0x004fe40003f1d000ULL, 0x000000582958723eULL, 0x000fe400000010ffULL,
0x0000000000297245ULL, 0x000fc6000020d400ULL, 0x0000005a00447306ULL, 0x000522000000d400ULL,
0x0000005500557245ULL, 0x002fca000020d400ULL, 0x0000000159590812ULL, 0x000fe400078efcffULL,
0x0000005b00457306ULL, 0x000362000000d400ULL, 0x000100005a5a7824ULL, 0x004fe200078e00ffULL,
0x0000006e6d00720bULL, 0x008fe40003f7d000ULL, 0x000000592859723eULL, 0x000fe400000010ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x00000000005e7306ULL, 0x000fe20000209400ULL,
0x000100005b5b7824ULL, 0x002fe200078e00ffULL, 0x0000000144444812ULL, 0x010fe200078efcffULL,
0x000000581810723cULL, 0x000fe60000041810ULL, 0x00000018ff5b7819ULL, 0x000fc4000001145bULL,
0x00000000005f7306ULL, 0x0002a20000205400ULL, 0x0000000155553812ULL, 0x000fe400078efcffULL,
0x0000000145452812ULL, 0x020fe400078efcffULL, 0x000000445544723eULL, 0x000fc600000010ffULL,
0x0000003f00487306ULL, 0x000fe20000209400ULL, 0x0000003f00007245ULL, 0x002fce000020d400ULL,
0x0000003f005d7306ULL, 0x000e620000205400ULL, 0x0000005f5e00720bULL, 0x004fce0003f3d000ULL,
0x0000006900677306ULL, 0x000fec0000209400ULL, 0x0000000129291812ULL, 0x000fe400078efcffULL,
0x0000006900667306ULL, 0x000ea20000205400ULL, 0x0000005d4800720bULL, 0x002fe40003f1d000ULL,
0x00000046495d723eULL, 0x000fca00000010ffULL, 0x0000005a00547306ULL, 0x000fe40000209400ULL,
0x0000005c180c723cULL, 0x000fe8000004180cULL, 0x0000000100000812ULL, 0x000fe400078efcffULL,
0x0000005a002b7306ULL, 0x0002e20000205400ULL, 0x000000666700720bULL, 0x004fce0003fdd000ULL,
0x0000005b002a7306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x002fce000020d400ULL,
0x0000005b00577306ULL, 0x0002a20000205400ULL, 0x0000002b5400720bULL, 0x008fe40003f7d000ULL,
0x0000005b005b7245ULL, 0x002fd6000020d400ULL, 0x000000015a5a3812ULL, 0x000fe400078efcffULL,
0x000000572a00720bULL, 0x004fe40003f9d000ULL, 0x00000069002a7245ULL, 0x000fe4000020d400ULL,
0x0000005a295a723eULL, 0x000fe400000010ffULL, 0x000000012a2a6812ULL, 0x000fc800078efcffULL,
0x000000452a45723eULL, 0x000fc600000010ffULL, 0x000000015b5b4812ULL, 0x000fc800078efcffULL,
0x0000005b005b723eULL, 0x000fe200000010ffULL, 0x000000441814723cULL, 0x040ff00000041814ULL,
0x0000005a1820723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000187305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000180000735dULL, 0x004fe40003800000ULL, 0x01065c00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000030024007a10ULL, 0x000fe20007ffe0ffULL,
0x00000100ff3f7424ULL, 0x000fc800078e00ffULL, 0x0000010000187824ULL, 0x040fe200078e00ffULL,
0x0000000100007810ULL, 0x000fc60007ffe0ffULL, 0x0000620027297a24ULL, 0x100fe200078e0218ULL,
0x0000001803197217ULL, 0x000fe40007800000ULL, 0x000000250000720cULL, 0x000fe20003f06070ULL,
0x00000001361a7824ULL, 0x100fe400078e0229ULL, 0x0000000119197824ULL, 0x000fe400078e0a18ULL,
0x0000000133187824ULL, 0x000fe200078e0229ULL, 0x00000004ff337819ULL, 0x000fe40000011626ULL,
0x00000020191b7807ULL, 0x000fe20000000000ULL, 0x00005e0018187625ULL, 0x000fc600078e003fULL,
0x0000001b2c2b7217ULL, 0x000fe20007800000ULL, 0x00005e001a1a7625ULL, 0x000fe200078e003fULL,
0x00000034182a7210ULL, 0x000fc60007f1e0ffULL, 0x000000012b007824ULL, 0x000fe200078e0a2cULL,
0x000000341a1a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000138187824ULL, 0x100fe400078e0229ULL,
0x000000013a297824ULL, 0x000fe200078e0229ULL, 0x000000003300720cULL, 0x080fe20003f26070ULL,
0x000000ffff2b7224ULL, 0x000fe200000e0619ULL, 0x000000003500720cULL, 0x080fe20003f06070ULL,
0x00005e0018187625ULL, 0x000fe200078e003fULL, 0x000000003900720cULL, 0x000fc60003f66070ULL,
0x00005e0029287625ULL, 0x000fe200078e003fULL, 0x0000003418187210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x000000003700720cULL, 0x000fe20003f46070ULL,
0x000000ffff197224ULL, 0x000fe200020e0619ULL, 0x0000003428347210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a4b7faeULL, 0x0003e8000c901c46ULL,
0x000000ffff357224ULL, 0x000fe200030e0629ULL, 0x000000001a4c7faeULL, 0x0003ea000c101c46ULL,
0x00000000184d7faeULL, 0x0003e8000d101c46ULL, 0x00000000344e7faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff007984ULL, 0x000ea20000000800ULL,
0x8000000052197824ULL, 0x002fca00078e00ffULL, 0x8000000000ff7812ULL, 0x004fe20007804819ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01065400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000052197824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000187305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000180000735dULL, 0x004fe40003800000ULL, 0x01065400ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fc40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000004f4c783bULL, 0x000e680000004200ULL,
0x000000005018783bULL, 0x000ea80000004200ULL, 0x000000005128783bULL, 0x000ee80000004200ULL,
0x000000003c34783bULL, 0x000f220000004200ULL, 0x0000004c009a7306ULL, 0x002fe20000009400ULL,
0x00000018ffaf7819ULL, 0x000fe2000001144cULL, 0x000001004c8d7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe2000001144dULL, 0x0000010018a97824ULL, 0x044fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001144eULL, 0x0001000018a67824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe2000001148dULL, 0x0000004c009d7306ULL, 0x000e620000005400ULL,
0x00000018ffa97819ULL, 0x000fe200000114a9ULL, 0x000001001a8e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001144fULL, 0x00010000199e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011418ULL, 0x0000010019a57824ULL, 0x000fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe200000114a6ULL, 0x0000004c006b7306ULL, 0x000562000000d400ULL,
0x00000018ff8e7819ULL, 0x000fe2000001148eULL, 0x0000010028937824ULL, 0x008fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011419ULL, 0x000100002aa37824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe2000001149eULL, 0x000100002ba27824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe2000001141aULL, 0x0000004d00b17306ULL, 0x000fe20000009400ULL,
0x000100004c4c7824ULL, 0x004fe200078e00ffULL, 0x0000009d9a00720bULL, 0x002fe20003fdd000ULL,
0x00010000349a7824ULL, 0x010fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fc40000011428ULL,
0x00000018ffac7819ULL, 0x000fe2000001144cULL, 0x000001004d4c7824ULL, 0x000fe200078e00ffULL,
0x0000004d00b27306ULL, 0x000e620000005400ULL, 0x00000018ff6f7819ULL, 0x000fe4000001141bULL,
0x00000018ff647819ULL, 0x000fe40000011429ULL, 0x00000018ffb37819ULL, 0x000fe2000001144cULL,
0x000001004e4c7824ULL, 0x000fe200078e00ffULL, 0x000000016b6b6812ULL, 0x020fe200078efcffULL,
0x000000ac00a77306ULL, 0x000fe20000209400ULL, 0x00000018ff5b7819ULL, 0x000fc4000001142aULL,
0x00000018ffbd7819ULL, 0x000fe2000001144cULL, 0x000001004f4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe400000114a5ULL, 0x00000018ff567819ULL, 0x000fe2000001142bULL,
0x000000ac00ae7306ULL, 0x0004e20000205400ULL, 0x00000018ffc57819ULL, 0x000fe2000001144cULL,
0x000100001b4c7824ULL, 0x000fe200078e00ffULL, 0x000000b2b100720bULL, 0x002fe40003f5d000ULL,
0x000000b300b17245ULL, 0x000fc4000020d400ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000004d006a7306ULL, 0x000322000000d400ULL, 0x000000ac00ac7245ULL, 0x004fe4000020d400ULL,
0x00000018ff937819ULL, 0x000fe40000011493ULL, 0x00000018ffa37819ULL, 0x000fe400000114a3ULL,
0x00000018ffa27819ULL, 0x000fe200000114a2ULL, 0x000000af00ad7306ULL, 0x000fe20000209400ULL,
0x000100004d4d7824ULL, 0x002fe200078e00ffULL, 0x000000aea700720bULL, 0x008fc40003f1d000ULL,
0x00000018ff467819ULL, 0x000fe40000011434ULL, 0x00000018ffb67819ULL, 0x000fe2000001144dULL,
0x000100001a4d7824ULL, 0x000fe200078e00ffULL, 0x000000af00b07306ULL, 0x0002a20000205400ULL,
0x000000016a6a2812ULL, 0x010fe400078efcffULL, 0x000000b600ae7245ULL, 0x000fe4000020d400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000001acac0812ULL, 0x000fe200078efcffULL,
0x000000a8009f7306ULL, 0x000fe20000209400ULL, 0x000000af00af7245ULL, 0x002fc4000020d400ULL,
0x00000018ff3c7819ULL, 0x000fe40000011435ULL, 0x00000018ff9a7819ULL, 0x000fe4000001149aULL,
0x00000018ff337819ULL, 0x000fe20000011436ULL, 0x000000a800a07306ULL, 0x0002e20000205400ULL,
0x000000b0ad00720bULL, 0x004fe40003f7d000ULL, 0x00000018ff007819ULL, 0x000fca0000011437ULL,
0x000000b600b77306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x00000001afaf3812ULL, 0x000fe400078efcffULL, 0x000000b600b87306ULL, 0x000e620000205400ULL,
0x000000a09f00720bULL, 0x008fe20003f9d000ULL, 0x0000010034a07824ULL, 0x000fe200078e00ffULL,
0x000000acafac723eULL, 0x000fe200000010ffULL, 0x00000100359f7824ULL, 0x000fc600078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x000000a100b97306ULL, 0x000fe20000209400ULL,
0x00000018ff9f7819ULL, 0x000fca000001149fULL, 0x00000001a8a84812ULL, 0x000fe400078efcffULL,
0x000000a100ba7306ULL, 0x0004e20000205400ULL, 0x000000b8b700720bULL, 0x002fe40003fdd000ULL,
0x0000006ba8a8723eULL, 0x000fca00000010ffULL, 0x0000004e00bb7306ULL, 0x000fe20000009400ULL,
0x000000a100a17245ULL, 0x004fca000020d400ULL, 0x00000001aeae6812ULL, 0x000fe400078efcffULL,
0x0000004e00bc7306ULL, 0x000e620000005400ULL, 0x000000bab900720bULL, 0x008fce0003f1d000ULL,
0x0000004e00637306ULL, 0x0004ec000000d400ULL, 0x00000001a1a10812ULL, 0x000fe400078efcffULL,
0x0000004f00c37306ULL, 0x000fe20000009400ULL, 0x000100004e4e7824ULL, 0x004fe200078e00ffULL,
0x000000bcbb00720bULL, 0x002fc80003f9d000ULL, 0x00000018ffc07819ULL, 0x000fe2000001144eULL,
0x000001001b4e7824ULL, 0x000fe200078e00ffULL, 0x0000004f00c47306ULL, 0x000e680000005400ULL,
0x00000018ff4e7819ULL, 0x000fc6000001144eULL, 0x0000000163634812ULL, 0x008fe200078efcffULL,
0x00000018009c7306ULL, 0x000ff00000009400ULL, 0x00000018009b7306ULL, 0x000ea20000005400ULL,
0x000000c4c300720bULL, 0x002fce0003f7d000ULL, 0x000000b300b47306ULL, 0x000ff00000209400ULL,
0x000000b300b57306ULL, 0x000e620000205400ULL, 0x0000009b9c00720bULL, 0x004fe40003fdd000ULL,
0x000000bd009c7245ULL, 0x000fca000020d400ULL, 0x000000c000c17306ULL, 0x000ff00000209400ULL,
0x000000c000c27306ULL, 0x000ea20000205400ULL, 0x000000b5b400720bULL, 0x002fce0003f3d000ULL,
0x0000004f00607306ULL, 0x0002ec000000d400ULL, 0x00000001b1b11812ULL, 0x000fe400078efcffULL,
0x000000a900cb7306ULL, 0x000fe20000209400ULL, 0x000000c2c100720bULL, 0x004fe20003f1d000ULL,
0x000100004f4f7824ULL, 0x002fca00078e00ffULL, 0x00000018ffc87819ULL, 0x000fe2000001144fULL,
0x000000a900cc7306ULL, 0x000e620000205400ULL, 0x0000000160603812ULL, 0x008fe200078efcffULL,
0x00010000354f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000008a00917306ULL, 0x000ff00000209400ULL, 0x0000008a00947306ULL, 0x000ea20000205400ULL,
0x000000cccb00720bULL, 0x002fce0003f7d000ULL, 0x00000018005c7306ULL, 0x000e70000000d400ULL,
0x0000008100837306ULL, 0x000fe20000209400ULL, 0x000000949100720bULL, 0x004fe40003f9d000ULL,
0x000000c000917245ULL, 0x000fc4000020d400ULL, 0x0000008f00947245ULL, 0x000fe4000020d400ULL,
0x0000000191910812ULL, 0x000fe200078efcffULL, 0x0000008100827306ULL, 0x0004e20000205400ULL,
0x000000015c5c6812ULL, 0x002fce00078efcffULL, 0x000000bd00be7306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x004fce000020d400ULL, 0x000000bd00bf7306ULL, 0x000e620000205400ULL,
0x000000828300720bULL, 0x008fce0003fdd000ULL, 0x00000019008b7306ULL, 0x000fec0000009400ULL,
0x0000000181816812ULL, 0x000fe400078efcffULL, 0x00000019008c7306ULL, 0x000ea20000005400ULL,
0x000000bfbe00720bULL, 0x002fce0003f3d000ULL, 0x000000c500c67306ULL, 0x000fec0000209400ULL,
0x000000019c9c1812ULL, 0x000fe400078efcffULL, 0x000000c500c77306ULL, 0x000e620000205400ULL,
0x0000008c8b00720bULL, 0x004fe40003f1d000ULL, 0x000000a9008b7245ULL, 0x000fc4000020d400ULL,
0x0000006ab1a9723eULL, 0x000fe400000010ffULL, 0x000000018b8b3812ULL, 0x000fe200078efcffULL,
0x000000a600cd7306ULL, 0x000fe60000209400ULL, 0x0000005c8b5c723eULL, 0x000fca00000010ffULL,
0x000000a600ce7306ULL, 0x0004e20000205400ULL, 0x000000c7c600720bULL, 0x002fce0003f5d000ULL,
0x00000019005f7306ULL, 0x000e62000000d400ULL, 0x000000a600a67245ULL, 0x004fce000020d400ULL,
0x0000008f00987306ULL, 0x000fe20000209400ULL, 0x000000cecd00720bULL, 0x008fce0003f7d000ULL,
0x0000008f00977306ULL, 0x0004e20000205400ULL, 0x000000015f5f0812ULL, 0x002fca00078efcffULL,
0x00000001a6a63812ULL, 0x000fe400078efcffULL, 0x0000008e00197306ULL, 0x000fe20000209400ULL,
0x0000008a008f7245ULL, 0x004fe4000020d400ULL, 0x000000a681a6723eULL, 0x000fe400000010ffULL,
0x000000018f8f4812ULL, 0x000fc600078efcffULL, 0x0000008e00187306ULL, 0x000e620000205400ULL,
0x000000979800720bULL, 0x008fe40003f3d000ULL, 0x000000c500977245ULL, 0x000fc8000020d400ULL,
0x0000000197972812ULL, 0x000fe200078efcffULL, 0x0000009e00ab7306ULL, 0x000fe60000209400ULL,
0x000000609797723eULL, 0x000fc600000010ffULL, 0x0000000194941812ULL, 0x000fe400078efcffULL,
0x0000009e00aa7306ULL, 0x0004e20000205400ULL, 0x000000181900720bULL, 0x002fe40003fdd000ULL,
0x000000919494723eULL, 0x000fca00000010ffULL, 0x0000001a00867306ULL, 0x000fe20000009400ULL,
0x0000009e009e7245ULL, 0x004fce000020d400ULL, 0x0000001a00877306ULL, 0x000fe20000005400ULL,
0x000000aaab00720bULL, 0x008fce0003f1d000ULL, 0x0000001a00587306ULL, 0x0003ec000000d400ULL,
0x000000019e9e0812ULL, 0x000fe400078efcffULL, 0x0000002800847306ULL, 0x000fe20000009400ULL,
0x00000100291a7824ULL, 0x002fca00078e00ffULL, 0x00000018ffa77819ULL, 0x000fe4000001141aULL,
0x0000002800857306ULL, 0x000fe20000005400ULL, 0x0000b8003d1a7811ULL, 0x000fe400078e20ffULL,
0x00000002ff3d7819ULL, 0x000fca0000011626ULL, 0x0000002800527306ULL, 0x0003f0000000d400ULL,
0x000000c800c97306ULL, 0x000fe20000209400ULL, 0x0001000028287824ULL, 0x002fca00078e00ffULL,
0x00000018ffb07819ULL, 0x000fe40000011428ULL, 0x000000c800ca7306ULL, 0x0002a20000205400ULL,
0x0000b8003e287811ULL, 0x000fe400078e20ffULL, 0x00000032ff3e723eULL, 0x000fca00000010ffULL,
0x0000001b00887306ULL, 0x000fe20000009400ULL, 0x000000c800c87245ULL, 0x002fce000020d400ULL,
0x0000001b00897306ULL, 0x000e620000005400ULL, 0x000000cac900720bULL, 0x004fce0003f5d000ULL,
0x0000001b00557306ULL, 0x0004ec000000d400ULL, 0x00000001c8c82812ULL, 0x000fe400078efcffULL,
0x00000029007c7306ULL, 0x000fe20000009400ULL, 0x000001002a1b7824ULL, 0x004fe200078e00ffULL,
0x000000878600720bULL, 0x000fc40003f5d000ULL, 0x000000a500867245ULL, 0x000fe4000020d400ULL,
0x00000018ff8c7819ULL, 0x000fe4000001141bULL, 0x00000029007d7306ULL, 0x000ea20000005400ULL,
0x000000001a18783bULL, 0x000fe20000000200ULL, 0x000000898800720bULL, 0x002fca0003f9d000ULL,
0x0000000158582812ULL, 0x000fe200078efcffULL, 0x00000029004b7306ULL, 0x00032e000000d400ULL,
0x0000000155554812ULL, 0x008fe200078efcffULL, 0x0000002a00797306ULL, 0x000fe20000009400ULL,
0x0001000029297824ULL, 0x002fe200078e00ffULL, 0x0000007d7c00720bULL, 0x004fc40003f1d000ULL,
0x0000008e007d7245ULL, 0x000fe4000020d400ULL, 0x00000018ff9b7819ULL, 0x000fe40000011429ULL,
0x0000002a006e7306ULL, 0x000fe20000005400ULL, 0x000000017d7d6812ULL, 0x000fe400078efcffULL,
0x0000009b00b17245ULL, 0x000fe4000020d400ULL, 0x000000587d58723eULL, 0x000fe400000010ffULL,
0x000000014b4b0812ULL, 0x010fe200078efcffULL, 0x0000002a004a7306ULL, 0x0003f0000000d400ULL,
0x0000007e00807306ULL, 0x000fe20000209400ULL, 0x000001002b2a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe4000001142aULL, 0x0000007e007f7306ULL, 0x000e700000205400ULL,
0x000000a500cf7306ULL, 0x000ff00000209400ULL, 0x000000a500d07306ULL, 0x000ea20000205400ULL,
0x0000007f8000720bULL, 0x002fc40003f7d000ULL, 0x0000007e007f7245ULL, 0x000fe4000020d400ULL,
0x000054103e7e7816ULL, 0x000fc6000000003eULL, 0x0000002b00777306ULL, 0x000fe40000009400ULL,
0x00001f3d7e3d7589ULL, 0x000e6800000e0000ULL, 0x00001f3b7e3e7589ULL, 0x00072200000e0000ULL,
0x000000017f7f3812ULL, 0x000fe200078efcffULL, 0x0000002b00727306ULL, 0x000fe20000005400ULL,
0x000000d0cf00720bULL, 0x004fce0003f3d000ULL, 0x0000002b00457306ULL, 0x0005e2000000d400ULL,
0x0000008c003b7245ULL, 0x008fca000020d400ULL, 0x0000000186861812ULL, 0x000fe400078efcffULL,
0x0000006400747306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x004ea20000000200ULL,
0x000000858400720bULL, 0x000fe20003f3d000ULL, 0x0000003d1818d231ULL, 0x082fe400003400ffULL,
0x0000003d1a1ad231ULL, 0x000fe400003400ffULL, 0x0000003e1919d231ULL, 0x090fe200003400ffULL,
0x0000006400717306ULL, 0x0002e20000205400ULL, 0x0000003e1b1bd231ULL, 0x000fcc00003400ffULL,
0x0000000152521812ULL, 0x000fe200078efcffULL, 0x0000004e008d7306ULL, 0x000fe20000209400ULL,
0x0000006400647245ULL, 0x002fe2000020d400ULL, 0x000000a81840723cULL, 0x000fec0000041840ULL,
0x0000004e00927306ULL, 0x0003220000205400ULL, 0x000000717400720bULL, 0x008fce0003f1d000ULL,
0x0000004d00967306ULL, 0x000fe20000209400ULL, 0x0000004e004e7245ULL, 0x002fca000020d400ULL,
0x0000000164640812ULL, 0x000fe400078efcffULL, 0x0000004d00997306ULL, 0x0002e20000205400ULL,
0x000000928d00720bULL, 0x010fe20003f7d000ULL, 0x0000003d2828d231ULL, 0x084fe400003400ffULL,
0x0000003d2a2ad231ULL, 0x000fe400003400ffULL, 0x0000003e2929d231ULL, 0x080fe400003400ffULL,
0x00000076007a7306ULL, 0x000fe20000209400ULL, 0x0000004d004d7245ULL, 0x002fe2000020d400ULL,
0x0000003e2b2bd231ULL, 0x000fe200003400ffULL, 0x000000a7003e7245ULL, 0x000fc6000020d400ULL,
0x000000014e4e3812ULL, 0x000fe400078efcffULL, 0x00000076007b7306ULL, 0x0002a20000205400ULL,
0x000000999600720bULL, 0x008fe40003fdd000ULL, 0x000000639c96723eULL, 0x000fca00000010ffULL,
0x000000b000b37306ULL, 0x000fe20000209400ULL, 0x0000007600767245ULL, 0x002fe2000020d400ULL,
0x000000961804723cULL, 0x000fe80000041804ULL, 0x000000014d4d6812ULL, 0x000fe400078efcffULL,
0x000000b000b47306ULL, 0x0002e20000205400ULL, 0x0000007b7a00720bULL, 0x004fe40003f5d000ULL,
0x0000006e7900720bULL, 0x000fca0003fdd000ULL, 0x0000006f00787306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x0000000176762812ULL, 0x000fe400078efcffULL,
0x0000006f00737306ULL, 0x000e620000205400ULL, 0x000000b4b300720bULL, 0x008fe40003fbd000ULL,
0x000000727700720bULL, 0x000fe40003f5d000ULL, 0x0000006f00777245ULL, 0x000fe4000020d400ULL,
0x000000014a4a6812ULL, 0x000fe200078efcffULL, 0x0000004c00907306ULL, 0x000fe20000209400ULL,
0x0000004d7676723eULL, 0x000fca00000010ffULL, 0x00000001b0b05812ULL, 0x000fe400078efcffULL,
0x0000004c00957306ULL, 0x0004e20000205400ULL, 0x000000737800720bULL, 0x002fe40003f9d000ULL,
0x0000000145452812ULL, 0x000fca00078efcffULL, 0x0000008200847306ULL, 0x000fe20000209400ULL,
0x0000004c004c7245ULL, 0x004fca000020d400ULL, 0x0000000177774812ULL, 0x000fe400078efcffULL,
0x0000008200857306ULL, 0x0002a20000205400ULL, 0x000000959000720bULL, 0x008fe40003f7d000ULL,
0x000000c88f95723eULL, 0x000fca00000010ffULL, 0x00000069006d7306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x002fe2000020d400ULL, 0x000000941808723cULL, 0x000fe80000041808ULL,
0x000000014c4c3812ULL, 0x000fe400078efcffULL, 0x00000069006c7306ULL, 0x0002e20000205400ULL,
0x000000858400720bULL, 0x004fe40003f1d000ULL, 0x0000004c7777723eULL, 0x000fca00000010ffULL,
0x0000008c008a7306ULL, 0x000fe20000209400ULL, 0x0000006900697245ULL, 0x002fe2000020d400ULL,
0x000000761820723cULL, 0x000fe80000041820ULL, 0x0000000182820812ULL, 0x000fe400078efcffULL,
0x0000008c00877306ULL, 0x000e620000205400ULL, 0x0000006c6d00720bULL, 0x008fce0003f3d000ULL,
0x0000005b005e7306ULL, 0x000fec0000209400ULL, 0x0000000169691812ULL, 0x000fe400078efcffULL,
0x0000005b005d7306ULL, 0x000ea20000205400ULL, 0x000000878a00720bULL, 0x002fe40003fbd000ULL,
0x000000b069b0723eULL, 0x000fca00000010ffULL, 0x00000093009d7306ULL, 0x000fec0000209400ULL,
0x000000013b3b5812ULL, 0x000fe400078efcffULL, 0x0000009300a47306ULL, 0x0002e20000205400ULL,
0x0000005d5e00720bULL, 0x004fe40003f1d000ULL, 0x0000005f865d723eULL, 0x000fc400000010ffULL,
0x0000004a3b4a723eULL, 0x000fc600000010ffULL, 0x000000a700ad7306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fe2000020d400ULL, 0x0000005c180c723cULL, 0x000fec000004180cULL,
0x000000a700b27306ULL, 0x0002a20000205400ULL, 0x000000a49d00720bULL, 0x008fce0003f7d000ULL,
0x000000a3007c7306ULL, 0x000fe20000209400ULL, 0x0000009e7fa7723eULL, 0x002fca00000010ffULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x000000a300837306ULL, 0x0002e20000205400ULL,
0x000000b2ad00720bULL, 0x004fe20003f9d000ULL, 0x000000a61810723cULL, 0x000fe20000041810ULL,
0x000000aea1ad723eULL, 0x000fe400000010ffULL, 0x0000009f00a17245ULL, 0x000fc6000020d400ULL,
0x00000056005a7306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fe2000020d400ULL,
0x000000ac181c723cULL, 0x000fe8000004181cULL, 0x000000013e3e4812ULL, 0x000fe400078efcffULL,
0x0000005600597306ULL, 0x0002a20000205400ULL, 0x000000837c00720bULL, 0x008fce0003fdd000ULL,
0x0000003500667306ULL, 0x000fe20000009400ULL, 0x0000005600567245ULL, 0x002fca000020d400ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x0000003500657306ULL, 0x000e620000005400ULL,
0x000000595a00720bULL, 0x004fe40003f5d000ULL, 0x0000005b005a7245ULL, 0x000fe4000020d400ULL,
0x000000554e59723eULL, 0x000fe400000010ffULL, 0x000000015a5a0812ULL, 0x000fe200078efcffULL,
0x0000003700627306ULL, 0x000fe20000009400ULL, 0x000000a2005b7245ULL, 0x000fc4000020d400ULL,
0x000000a35a5a723eULL, 0x000fe200000010ffULL, 0x000000581814723cULL, 0x000fe40000041814ULL,
0x0000000156562812ULL, 0x000fe400078efcffULL, 0x0000003700617306ULL, 0x000ea20000005400ULL,
0x000000656600720bULL, 0x002fce0003f3d000ULL, 0x0000003400757306ULL, 0x000ff00000009400ULL,
0x0000003400707306ULL, 0x000e620000005400ULL, 0x000000616200720bULL, 0x004fce0003fbd000ULL,
0x0000009b00987306ULL, 0x000ff00000209400ULL, 0x0000009b00b57306ULL, 0x0004e20000205400ULL,
0x000000707500720bULL, 0x002fce0003f7d000ULL, 0x000000a2007a7306ULL, 0x000fe20000209400ULL,
0x0000004f009b7245ULL, 0x004fce000020d400ULL, 0x000000a200737306ULL, 0x000e620000205400ULL,
0x000000b59800720bULL, 0x008fce0003f9d000ULL, 0x000000a0006e7306ULL, 0x000fec0000209400ULL,
0x00000001b1b14812ULL, 0x000fe400078efcffULL, 0x000000a0003d7306ULL, 0x0004e20000205400ULL,
0x000000737a00720bULL, 0x002fe40003fdd000ULL, 0x000000b164b1723eULL, 0x000fca00000010ffULL,
0x00000034003f7306ULL, 0x000322000000d400ULL, 0x000000a000a07245ULL, 0x004fe2000020d400ULL,
0x000000b0281c723cULL, 0x000fe8000004181cULL, 0x000000015b5b6812ULL, 0x000fe400078efcffULL,
0x00000035003a7306ULL, 0x000562000000d400ULL, 0x0000010037347824ULL, 0x002fe200078e00ffULL,
0x0000003d6e00720bULL, 0x008fc40003f1d000ULL, 0x0000005b565b723eULL, 0x000fe400000010ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011434ULL, 0x0000003600677306ULL, 0x000fe20000009400ULL,
0x0000010036357824ULL, 0x004fe200078e00ffULL, 0x000000529334723eULL, 0x000fe200000010ffULL,
0x0000005a2808723cULL, 0x000fe20000041808ULL, 0x000000013f3f3812ULL, 0x010fe400078efcffULL,
0x00000018ff5e7819ULL, 0x000fc40000011435ULL, 0x0000003600687306ULL, 0x000e620000005400ULL,
0x0000004b3e35723eULL, 0x000fe400000010ffULL, 0x00000001a0a00812ULL, 0x000fe400078efcffULL,
0x000000013a3a1812ULL, 0x020fe400078efcffULL, 0x00000045824b723eULL, 0x000fe200000010ffULL,
0x0000004600547306ULL, 0x000fe20000209400ULL, 0x000000342818723cULL, 0x000fe20000041840ULL,
0x0000003fa0a0723eULL, 0x000fcc00000010ffULL, 0x0000004600577306ULL, 0x000ea20000205400ULL,
0x000000686700720bULL, 0x002fe20003f9d000ULL, 0x0000004a2804723cULL, 0x000fe20000041804ULL,
0x0000004600357245ULL, 0x000fca000020d400ULL, 0x0000003c00517306ULL, 0x000ff00000209400ULL,
0x0000003c00507306ULL, 0x0002e20000205400ULL, 0x000000575400720bULL, 0x004fce0003fdd000ULL,
0x0000009f006f7306ULL, 0x000fe20000209400ULL, 0x0000003c003c7245ULL, 0x002fca000020d400ULL,
0x0000000135356812ULL, 0x000fe400078efcffULL, 0x0000009f006c7306ULL, 0x000e620000205400ULL,
0x000000505100720bULL, 0x008fce0003f5d000ULL, 0x0000009a006a7306ULL, 0x000fec0000209400ULL,
0x000000013c3c2812ULL, 0x000fe400078efcffULL, 0x0000009a00657306ULL, 0x0004e20000205400ULL,
0x0000006c6f00720bULL, 0x002fce0003f1d000ULL, 0x0000004f00617306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x004fca000020d400ULL, 0x00000001a1a10812ULL, 0x000fe400078efcffULL,
0x0000004f00607306ULL, 0x000e620000205400ULL, 0x000000656a00720bULL, 0x008fe40003f7d000ULL,
0x0000003aa1a1723eULL, 0x000fca00000010ffULL, 0x0000003600397306ULL, 0x0004e4000000d400ULL,
0x000000a0280c723cULL, 0x000fe8000004180cULL, 0x000000019a9a3812ULL, 0x000fe400078efcffULL,
0x0000003700387306ULL, 0x000962000000d400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x000000606100720bULL, 0x002fc40003f3d000ULL, 0x0000009a359a723eULL, 0x000fe400000010ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003300497306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x010fe200078e00ffULL, 0x0000000139394812ULL, 0x008fc800078efcffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003300487306ULL, 0x0002a20000205400ULL,
0x000000019b9b1812ULL, 0x000fe400078efcffULL, 0x0000000138385812ULL, 0x020fe400078efcffULL,
0x0000009b3c9b723eULL, 0x000fc600000010ffULL, 0x0000000000447306ULL, 0x000fe20000209400ULL,
0x0000003300337245ULL, 0x002fc6000020d400ULL, 0x0000009a2810723cULL, 0x000fe80000041810ULL,
0x0000000000477306ULL, 0x0002e20000205400ULL, 0x000000484900720bULL, 0x004fce0003f1d000ULL,
0x0000005e005f7306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x002fca000020d400ULL,
0x0000000133330812ULL, 0x000fe400078efcffULL, 0x0000005e00627306ULL, 0x0002a20000205400ULL,
0x000000474400720bULL, 0x008fce0003f7d000ULL, 0x0000005c005d7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x002fca000020d400ULL, 0x0000000100003812ULL, 0x000fe400078efcffULL,
0x0000005c004c7306ULL, 0x000e620000205400ULL, 0x000000625f00720bULL, 0x004fe40003fdd000ULL,
0x0000005c005f7245ULL, 0x000fca000020d400ULL, 0x00000036003d7306ULL, 0x000fec0000209400ULL,
0x000000015e5e6812ULL, 0x000fe400078efcffULL, 0x00000036003e7306ULL, 0x0004e20000205400ULL,
0x0000004c5d00720bULL, 0x002fe40003f3d000ULL, 0x000000395e5e723eULL, 0x000fca00000010ffULL,
0x0000003700347306ULL, 0x000fe20000209400ULL, 0x0000003600367245ULL, 0x004fca000020d400ULL,
0x000000015f5f1812ULL, 0x000fe400078efcffULL, 0x00000037003b7306ULL, 0x0002a20000205400ULL,
0x0000003e3d00720bULL, 0x008fe40003f5d000ULL, 0x000000385f5f723eULL, 0x000fe400000010ffULL,
0x0000003700377245ULL, 0x002fca000020d400ULL, 0x0000005e2814723cULL, 0x000fe80000041814ULL,
0x0000000136362812ULL, 0x000fe400078efcffULL, 0x0000003b3400720bULL, 0x004fe40003f9d000ULL,
0x000000363336723eULL, 0x000fd600000010ffULL, 0x0000000137374812ULL, 0x000fc800078efcffULL,
0x000000370037723eULL, 0x000fce00000010ffULL, 0x000000362820723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01064000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff53ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff647807ULL, 0x000fe40004000000ULL, 0x0000030024247a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff30ff7812ULL, 0x000fe4000780c0ffULL, 0x000000252400720cULL, 0x000fe40003f26070ULL,
0x00000001ff307807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xfffed05000007947ULL, 0x000fea000383ffffULL, 0x0000000000317919ULL, 0x000e620000002500ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0023ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0021ULL,
0x000000ffff297224ULL, 0x000fe400078e0017ULL, 0x000000ffff277224ULL, 0x000fe400078e0015ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0022ULL, 0x000000ffff387224ULL, 0x000fc400078e0020ULL,
0x000000ffff237224ULL, 0x000fe400078e0013ULL, 0x000000ffff217224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe400078e000fULL, 0x000000ffff157224ULL, 0x000fe400078e000dULL,
0x000000ffff367224ULL, 0x000fe400078e0016ULL, 0x000000ffff347224ULL, 0x000fe200078e0014ULL,
0x000000253100720cULL, 0x002fe20003f06070ULL, 0x000000ffff327224ULL, 0x000fc400078e0012ULL,
0x000000ffff307224ULL, 0x000fe400078e0010ULL, 0x000000ffff2a7224ULL, 0x000fe400078e000eULL,
0x000000ffff287224ULL, 0x000fe400078e000cULL, 0x000000ffff137224ULL, 0x000fe400078e000bULL,
0x000000ffff267224ULL, 0x000fe400078e000aULL, 0x000000ffff117224ULL, 0x000fc400078e0009ULL,
0x000000ffff247224ULL, 0x000fe400078e0008ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0007ULL,
0x000000ffff227224ULL, 0x000fe400078e0006ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0005ULL,
0x000000ffff207224ULL, 0x000fe200078e0004ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x018000002e007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff397224ULL, 0x000fe200078e002eULL,
0x00013fc000097802ULL, 0x000fe40000000f00ULL, 0x0000938000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002e00037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc8000000002eULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff057624ULL, 0x000fe400078e00ffULL,
0x00006600ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x000ea8000c1e9900ULL,
0x0000000000077919ULL, 0x000ee40000000000ULL, 0x00000002ff037819ULL, 0x008fe40000011607ULL,
0x0000000807077811ULL, 0x000fe200078ff0ffULL, 0x0000000005007220ULL, 0x004fca0000410000ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0700077589ULL, 0x000ee200000e0000ULL,
0x0000001803187220ULL, 0x044fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x040fe20000410000ULL,
0x0000002003207220ULL, 0x040fe20000410000ULL, 0x0000000d030d7220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000001103117220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000003003307220ULL, 0x040fe20000410000ULL, 0x0000002103217220ULL, 0x040fe20000410000ULL,
0x0000003403347220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000003803387220ULL, 0x040fe20000410000ULL, 0x0000002b032b7220ULL, 0x000fe20000410000ULL,
0x0000001a071a7220ULL, 0x048fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003607367220ULL, 0x040fe20000410000ULL, 0x0000002907297220ULL, 0x040fe20000410000ULL,
0x0000003a073a7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fe20000410000ULL,
0x0000000000107919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000210007812ULL, 0x004fc400078ec0ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011610ULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x0000000200047811ULL, 0x040fe400078ff8ffULL,
0x0000000400077811ULL, 0x040fe400078ff8ffULL, 0x00000006000b7811ULL, 0x000fe400078ff8ffULL,
0x0000000810167811ULL, 0x000fc400078ff0ffULL, 0x0000000703007812ULL, 0x100fe400078e780eULL,
0x0000000704057812ULL, 0x100fe400078e780eULL, 0x0000000707097812ULL, 0x000fe200078e780eULL,
0x000000080e067824ULL, 0x000fe200078e0200ULL, 0x000000070b0c7812ULL, 0x000fe200078e780eULL,
0x0000080002007824ULL, 0x000fe200078e00ffULL, 0x0000000707077812ULL, 0x100fe200078e7816ULL,
0x000000080e087824ULL, 0x040fe200078e0205ULL, 0x0000000703037812ULL, 0x100fe200078e7816ULL,
0x000000080e0a7824ULL, 0x000fe200078e0209ULL, 0x0000000704047812ULL, 0x000fe200078e7816ULL,
0x000000080e0e7824ULL, 0x000fe200078e020cULL, 0x000000070b0b7812ULL, 0x000fe200078e7816ULL,
0x0000000816147824ULL, 0x040fe200078e0207ULL, 0x0000001c1d05723eULL, 0x000fe200000010ffULL,
0x00000008160c7824ULL, 0x000fe200078e0203ULL, 0x0000a00000037810ULL, 0x000fe20007ffe0ffULL,
0x0000000810077824ULL, 0x000fe200078e00ffULL, 0x0000001e1f09723eULL, 0x000fe200000010ffULL,
0x0000000816127824ULL, 0x040fe200078e0204ULL, 0x000000181904723eULL, 0x000fe200000010ffULL,
0x0000000816167824ULL, 0x000fe200078e020bULL, 0x0000000807077812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000541004187816ULL, 0x000fe20000000005ULL,
0x000000100c107824ULL, 0x000fe200078e0203ULL, 0x0000763204197816ULL, 0x000fe20000000005ULL,
0x0000001008087824ULL, 0x100fe200078e0203ULL, 0x000000281504723eULL, 0x000fe200000010ffULL,
0x0000001012127824ULL, 0x100fe200078e0203ULL, 0x000000302105723eULL, 0x000fe200000010ffULL,
0x000000100a0c7824ULL, 0x000fc400078e0203ULL, 0x000000100e0e7824ULL, 0x100fe400078e0203ULL,
0x0000001014147824ULL, 0x100fe400078e0203ULL, 0x0000001016167824ULL, 0x000fe400078e0203ULL,
0x00000001060a7824ULL, 0x000fe200078e0207ULL, 0x000000200d06723eULL, 0x000fe200000010ffULL,
0x0000000107107824ULL, 0x040fe400078e0210ULL, 0x00000001070b7824ULL, 0x040fe200078e0208ULL,
0x000000180a007388ULL, 0x0005e20000000a00ULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x0000001a1b08723eULL, 0x000fe200000010ffULL, 0x00000001070c7824ULL, 0x000fc400078e020cULL,
0x00000001070e7824ULL, 0x040fe400078e020eULL, 0x0000000107147824ULL, 0x040fe400078e0214ULL,
0x0000000107167824ULL, 0x000fe200078e0216ULL, 0x000000241107723eULL, 0x000fe200000010ffULL,
0x00000300ff287624ULL, 0x000fe200078e00ffULL, 0x00005410040a7816ULL, 0x004fe40000000005ULL,
0x0000541006187816ULL, 0x140fe40000000007ULL, 0x0000763206197816ULL, 0x000fc40000000007ULL,
0x000000342706723eULL, 0x000fe400000010ffULL, 0x000000382b07723eULL, 0x000fe200000010ffULL,
0x000000180b007388ULL, 0x0005e20000000a00ULL, 0x000000012800780cULL, 0x000fe40003f05270ULL,
0x00007632040b7816ULL, 0x004fe40000000005ULL, 0x000000220f04723eULL, 0x000fe400000010ffULL,
0x000000261305723eULL, 0x000fe200000010ffULL, 0x0000000a0c007388ULL, 0x0005e40000000a00ULL,
0x00005410060a7816ULL, 0x004fc40000000007ULL, 0x00007632060b7816ULL, 0x000fe40000000007ULL,
0x0000002a1706723eULL, 0x000fe400000010ffULL, 0x000000322307723eULL, 0x000fe200000010ffULL,
0x0000000a0e007388ULL, 0x0005e40000000a00ULL, 0x00005410080a7816ULL, 0x144fe40000000009ULL,
0x00007632080b7816ULL, 0x000fe40000000009ULL, 0x000000362908723eULL, 0x000fc400000010ffULL,
0x0000003a2f09723eULL, 0x000fe200000010ffULL, 0x0000000a10007388ULL, 0x0005e40000000a00ULL,
0x00005410040a7816ULL, 0x144fe40000000005ULL, 0x00007632040b7816ULL, 0x000fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x0000000a12007388ULL, 0x0005e20000000a00ULL, 0x0000541008067816ULL, 0x000fc40000000009ULL,
0x0000763208077816ULL, 0x000fe20000000009ULL, 0x0000000414007388ULL, 0x0005e80000000a00ULL,
0x0000000616007388ULL, 0x0005e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002ce000008947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x004ea20000000000ULL,
0x0000580028047a24ULL, 0x000fe200078e02ffULL, 0x000000ff0200720cULL, 0x000fe20003f25270ULL,
0x00002000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000167919ULL, 0x000ee20000002700ULL,
0x0000640004067a24ULL, 0x000fc600078e02ffULL, 0x0000000000077919ULL, 0x000ee20000002600ULL,
0x00000010050b7824ULL, 0x044fe200078e0200ULL, 0x0000002005117810ULL, 0x040fe40007ffe0ffULL,
0x0000004005137810ULL, 0x040fe40007ffe0ffULL, 0x00a000000b187984ULL, 0x0005220000000c00ULL,
0x0000006005157810ULL, 0x000fe20007ffe0ffULL, 0x0000580016167a24ULL, 0x008fe400078e0207ULL,
0x00a200000b1c7984ULL, 0x0004e20000000c00ULL, 0x00001fff06077811ULL, 0x000fe200078e40ffULL,
0x0000030016047a24ULL, 0x000fc400078e02ffULL, 0x00a400000b207984ULL, 0x0004620000000c00ULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x00000001040a7824ULL, 0x000fe400078e0231ULL,
0x00a600000b247984ULL, 0x0004620000000c00ULL, 0x000000ff0200720cULL, 0x000fe40000705670ULL,
0x0000000a07087211ULL, 0x000fca00078f98ffULL, 0x00006a0008087625ULL, 0x000fcc00078e0009ULL,
0x0000080002087825ULL, 0x000fcc00078e0008ULL, 0x0000001011107825ULL, 0x000fc800078e0008ULL,
0x0000001013127825ULL, 0x000fc800078e0008ULL, 0x0000001015147825ULL, 0x000fc800078e0008ULL,
0x00000010050e7825ULL, 0x000fe200078e0008ULL, 0x01ffffff06097812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x01cea20000000000ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x000000010a0c7824ULL, 0x040fe400078e0209ULL,
0x00006a000a0a7625ULL, 0x000fc800078e000dULL, 0x00006a000c0c7625ULL, 0x000fc800078e000dULL,
0x0000001006087824ULL, 0x004fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fc80000011606ULL,
0x0000007008177812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ec0ffULL,
0x0000000a060a7210ULL, 0x140fe40007b5e017ULL, 0x0000000c060c7210ULL, 0x000fe40007d9e017ULL,
0x0000000bff0b7210ULL, 0x000fe400017e64ffULL, 0x0000000dff0d7210ULL, 0x000fc600027ea4ffULL,
0x0000002d0a007986ULL, 0x0005e8000c101906ULL, 0x0000002e0c007986ULL, 0x0005e4000c101906ULL,
0x000000180e007986ULL, 0x01c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000001c10007986ULL, 0x0005e8000c101d06ULL, 0x0000002012007986ULL, 0x0025e8000c101d06ULL,
0x0000002414007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0xffffffff280d7810ULL, 0x000fc60007ffe0ffULL, 0x00006800160a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000d0a0a79a8ULL, 0x000ee400099ee1c6ULL, 0x0000000d0a00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff067807ULL, 0x000fca0000000000ULL,
0x00000006ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x002e640000000000ULL,
0x000000ff0600720cULL, 0x002fda0003f05270ULL, 0x0000287000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001040c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001005067824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe20000011605ULL,
0x00000080ff197424ULL, 0x004fc600078e00ffULL, 0x00000070061b7812ULL, 0x000fe200078ec0ffULL,
0x00006a00040a7625ULL, 0x000fe200078e0019ULL, 0x0000000c08087812ULL, 0x000fc600078ec0ffULL,
0x00006a000c0c7625ULL, 0x000fe200078e0019ULL, 0x0000000a080a7210ULL, 0x000fc8000791e01bULL,
0x0000000c080c7210ULL, 0x000fe40007b5e01bULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a067981ULL, 0x000368000c1e1900ULL,
0x000000060c0f7981ULL, 0x000362000c1e1900ULL, 0x000000022800780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002040a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a080a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a117981ULL, 0x000362000c1e1900ULL,
0x000000042800780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003040a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a080a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a137981ULL, 0x000362000c1e1900ULL, 0x000000042800780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004040a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a080a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a157981ULL, 0x000362000c1e1900ULL,
0x000000062800780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005040a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a080a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a177981ULL, 0x000362000c1e1900ULL, 0x000000062800780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082800780cULL, 0x002fe40003f06070ULL,
0x00000006040a7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a080a7210ULL, 0x000fe40007a3e01bULL, 0x00000007040c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006a000c0c0625ULL, 0x000fe400078e0019ULL,
0x000000060a197981ULL, 0x000366000c1e1900ULL, 0x0000000c080c0210ULL, 0x000fc80007c7e01bULL,
0x0000000dff0d0210ULL, 0x000fcc0001fe84ffULL, 0x000000060c0d0981ULL, 0x000366000c1e1900ULL,
0x0000000728087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff087819ULL, 0x000fc80000011608ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1b7224ULL, 0x004fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x020fe400078e0006ULL,
0x000000081b0c7824ULL, 0x040fe200078e00ffULL, 0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000000081b00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080c0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000010c0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001d06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010050e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e1d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e01dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1d7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090c0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000020c0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000000f06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0f7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000030c0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001106067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010050e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e117812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a117981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0c0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000040c0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001306067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e137812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e013ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a137981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000050c0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001506067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010050e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e157812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e015ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a157981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0c0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000060c0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001706067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e177812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e017ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a177981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000070c0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001906067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010050e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e197812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e019ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0c0b7810ULL, 0x002fe40007ffe0ffULL, 0x0000000d06067209ULL, 0x000fe40007810000ULL,
0x000003000b007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff0e7819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007a3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a0d7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x000ee40000000000ULL,
0x0000001005087824ULL, 0x008fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x002fc80000011605ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0b7812ULL, 0x000fca00078ec0ffULL,
0x00000001080b7824ULL, 0x000fca00078e020bULL, 0x000000060b007388ULL, 0x0203e40000000800ULL,
0x00000004070a7211ULL, 0x000fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff0b7424ULL, 0x002fe200078e00ffULL, 0x000000070500780cULL, 0x040fe20003f04070ULL,
0x0000001005067824ULL, 0x040fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe20000011605ULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x00000015ff1a7819ULL, 0x004fe20000011602ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x0000080002197824ULL, 0x000fe200078e00ffULL, 0x0000000c080d7812ULL, 0x000fe200078ec0ffULL,
0x00001000022a7824ULL, 0x000fe200078e00ffULL, 0x00000040050f7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000000190a0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000106067824ULL, 0x000fe200078e020dULL, 0x00000020050d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000104128824ULL, 0x000fe200078e0209ULL, 0x0000006005117810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000010b0b7824ULL, 0x000fe200008e061aULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x00000000061d7984ULL, 0x0002a20000000800ULL,
0x00006a0012128625ULL, 0x000fe200078e0013ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000100d0c7825ULL, 0x000fe200078e000aULL, 0x0000000000387805ULL, 0x000fc6000001ff00ULL,
0x000000100f0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x00000010021f8824ULL, 0x000fe400078e0205ULL, 0x00006a0004148625ULL, 0x000fc600078e0015ULL,
0x000045801f1f8811ULL, 0x000fe200078e20ffULL, 0x0000001005177824ULL, 0x040fe400078e022aULL,
0x00000010050a7825ULL, 0x000fc800078e000aULL, 0x0000001002218824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a177faeULL, 0x0007e2000b901c46ULL,
0x0000001005128825ULL, 0x000fc600078e0012ULL, 0x0000418021218811ULL, 0x000fe200078e20ffULL,
0x0000001005148825ULL, 0x000fe200078e0014ULL, 0x003800000c177faeULL, 0x0009e6000b901c46ULL,
0x000000ffff067224ULL, 0x002fe200078e00ffULL, 0x005800000e177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x0078000010177faeULL, 0x0007e2000b901c46ULL,
0x000000ffff1c7224ULL, 0x000fc400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x00000000121f8faeULL, 0x000be2000b901c46ULL, 0x00000000000c7805ULL, 0x010fe2000001ff00ULL,
0x000000ffff2d7224ULL, 0x000fe400078e00ffULL, 0x0000000014218faeULL, 0x0009e2000b901c46ULL,
0x00000000000e7805ULL, 0x002fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000107805ULL, 0x008fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x020fe2000001ff00ULL, 0x0000000000147805ULL, 0x010fe2000001ff00ULL,
0x00000d6000009947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x004fe400078e00ffULL,
0x000000ffff3a7224ULL, 0x000fca00078e00ffULL, 0x000000013a3b7810ULL, 0x000fc80007ffe0ffULL,
0x000003003b007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x00000001043c7824ULL, 0x000fe200078e023bULL, 0x000000070500780cULL, 0x000fe20003f24070ULL,
0x00002000ff1f7424ULL, 0x000fe200078e00ffULL, 0x000000013b237812ULL, 0x040fe200078ec0ffULL,
0x000008003b207824ULL, 0x000fe200078e00ffULL, 0x0000003c071e7211ULL, 0x000fe400078f98ffULL,
0x0000002005257810ULL, 0x040fe40007ffe0ffULL, 0x0000080020217812ULL, 0x000fe200078ec0ffULL,
0x00006a001e1e7625ULL, 0x000fe200078e001fULL, 0x0000004005297810ULL, 0x000fc40007ffe0ffULL,
0x00000060053f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012a207824ULL, 0x000fe200078e0221ULL,
0x000000191e1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000109269824ULL, 0x000fe400078e023cULL,
0x00000080ff279424ULL, 0x000fe400078e00ffULL, 0x000000011f1f7824ULL, 0x000fe400000e061aULL,
0x0000000202289824ULL, 0x140fe400078e0223ULL, 0x00000002023e9824ULL, 0x000fc400078e0223ULL,
0x00000080ff419424ULL, 0x000fe400078e00ffULL, 0x00000010053d7824ULL, 0x000fe400078e0220ULL,
0x0000001025227825ULL, 0x000fc800078e001eULL, 0x0000001029247825ULL, 0x000fc800078e001eULL,
0x0000001005207825ULL, 0x000fc800078e001eULL, 0x000000103f1e7825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000203d7faeULL, 0x0003e6000b901c46ULL,
0x00006a0026269625ULL, 0x000fe200078e0027ULL, 0x00380000223d7faeULL, 0x0003e6000b901c46ULL,
0x00000008283f9824ULL, 0x000fe200078e0205ULL, 0x00580000243d7faeULL, 0x0003e2000b901c46ULL,
0x00006a003c289625ULL, 0x000fc600078e0041ULL, 0x000045803f3f9811ULL, 0x000fe200078e20ffULL,
0x000000083e3e9824ULL, 0x000fe200078e0205ULL, 0x007800001e3d7faeULL, 0x0003e2000b901c46ULL,
0x0000001005269825ULL, 0x000fc600078e0026ULL, 0x000041803e419811ULL, 0x000fe200078e20ffULL,
0x0000001005289825ULL, 0x000fe200078e0028ULL, 0x00000000263f9faeULL, 0x0003e8000b901c46ULL,
0x0000000028419faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff217224ULL, 0x002fe200078e003aULL, 0x00000001ff227819ULL, 0x100fe20000011605ULL,
0x0000001005207824ULL, 0x000fe200078e00ffULL, 0x00000002ff277819ULL, 0x000fe20000011605ULL,
0x00000080211e7824ULL, 0x000fe200078e00ffULL, 0x0000000c22227812ULL, 0x000fc400078ec0ffULL,
0x0000007020207812ULL, 0x000fe200078ec0ffULL, 0x0000000827257824ULL, 0x040fe200078e00ffULL,
0x000000801e1f7812ULL, 0x000fe200078ec0ffULL, 0x0000000827237824ULL, 0x040fe200078e00ffULL,
0x0000000727407812ULL, 0x000fe400078ec0ffULL, 0x00000027ff3e7212ULL, 0x000fe200078e33ffULL,
0x00000100021f7824ULL, 0x000fe200078e021fULL, 0xfffffff8231e7812ULL, 0x000fe400078ee240ULL,
0xfffffff8253e7812ULL, 0x000fc400078ee23eULL, 0x0000001f22207210ULL, 0x000fe20007ffe020ULL,
0x00000008271f7824ULL, 0x040fe200078e00ffULL, 0x0000000827297810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000203c7984ULL, 0x000e620000000800ULL,
0x000000011f227812ULL, 0x100fe200078ef640ULL, 0x0000000829237824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x140fe200078ef640ULL, 0x00458000204e7984ULL, 0x0002a20000000800ULL,
0x000000031f267812ULL, 0x100fe200078ef640ULL, 0x0000000829427824ULL, 0x000fe200078e00ffULL,
0x000000041f287812ULL, 0x140fe400078ef640ULL, 0x000000051f3a7812ULL, 0x000fe400078ef640ULL,
0x00000029ff4c7212ULL, 0x000fc800078e33ffULL, 0xfffffff8234c7812ULL, 0x000fe400078ee24cULL,
0x0000000729237812ULL, 0x000fe200078ec0ffULL, 0x0000003c1d207221ULL, 0x002fe20000010100ULL,
0x000000061f3c7812ULL, 0x000fe200078ef640ULL, 0x00000800211f7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b20257820ULL, 0x000fe20000410000ULL, 0x0000000405207824ULL, 0x000fe400078e00ffULL,
0x000008001f1f7812ULL, 0x000fe200078ec0ffULL, 0x0000000829407824ULL, 0x000fc400078e00ffULL,
0x0000000c20217812ULL, 0x000fe200078ec0ffULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000001802a1f7810ULL, 0x000fe40007ffe01fULL, 0xfffffff842207812ULL, 0x100fe400078ee223ULL,
0x0000000140427812ULL, 0x000fe200078ef623ULL, 0x000000101e1e7824ULL, 0x000fe200078e021fULL,
0x0000000240447812ULL, 0x000fe200078ef623ULL, 0x000000103e3e7824ULL, 0x000fe200078e021fULL,
0x0000000340467812ULL, 0x000fe200078ef623ULL, 0x000000011e1e7824ULL, 0x000fe200078e0221ULL,
0x0000000440487812ULL, 0x140fe200078ef623ULL, 0x00000001213e7824ULL, 0x000fe200078e023eULL,
0x00000005404a7812ULL, 0x000fe200078ef623ULL, 0x0000001022227824ULL, 0x000fe200078e021fULL,
0x0000000640407812ULL, 0x000fe200078ef623ULL, 0x000000001e1e7984ULL, 0x000e620000000800ULL,
0x0000001024247824ULL, 0x000fe200078e021fULL, 0x0000004e254e7220ULL, 0x004fe20000410000ULL,
0x0000000121227824ULL, 0x040fe200078e0222ULL, 0x000000003e3e7984ULL, 0x000fe20000000800ULL,
0x0000000121247824ULL, 0x000fe200078e0224ULL, 0x000000394e397221ULL, 0x000fe20000010000ULL,
0x0000001026267824ULL, 0x100fe200078e021fULL, 0x00001f274e237589ULL, 0x000ea200000e0000ULL,
0x0000001028287824ULL, 0x000fc400078e021fULL, 0x0000000121267824ULL, 0x040fe200078e0226ULL,
0x0000000022227984ULL, 0x000ee20000000800ULL, 0x0000000121287824ULL, 0x040fe400078e0228ULL,
0x000000103a3a7824ULL, 0x100fe200078e021fULL, 0x0000000024247984ULL, 0x000f220000000800ULL,
0x000000103c3c7824ULL, 0x000fe400078e021fULL, 0x00000001213a7824ULL, 0x040fe200078e023aULL,
0x0000000026267984ULL, 0x000f620000000800ULL, 0x00000001213c7824ULL, 0x000fc400078e023cULL,
0x0000001020207824ULL, 0x100fe200078e021fULL, 0x0000000028287984ULL, 0x000f620000000800ULL,
0x0000001042427824ULL, 0x100fe400078e021fULL, 0x0000001044447824ULL, 0x100fe200078e021fULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x0000001046467824ULL, 0x100fe400078e021fULL,
0x0000001048487824ULL, 0x100fe200078e021fULL, 0x000000003c3c7984ULL, 0x000f620000000800ULL,
0x000000104a4a7824ULL, 0x000fc400078e021fULL, 0x0000001040407824ULL, 0x100fe200078e021fULL,
0x00001f294e4e7589ULL, 0x000fe200000e0000ULL, 0x000000104c4c7824ULL, 0x000fe400078e021fULL,
0x0000000121207824ULL, 0x040fe200078e0220ULL, 0x00005410ff1f7816ULL, 0x002fe2000000001eULL,
0x0000000121427824ULL, 0x040fe200078e0242ULL, 0x00007610ff1e7816ULL, 0x000fe2000000001eULL,
0x0000000121447824ULL, 0x000fe400078e0244ULL, 0x000000231f387223ULL, 0x084fe20000010038ULL,
0x00007610ff1f7816ULL, 0x100fe2000000003eULL, 0x0000000020207984ULL, 0x000e620000000800ULL,
0x000000231e377223ULL, 0x080fe20000010037ULL, 0x00005410ff1e7816ULL, 0x000fe2000000003eULL,
0x0000000121467824ULL, 0x000fe200078e0246ULL, 0x000000231f187223ULL, 0x080fe20000010018ULL,
0x00005410ff1f7816ULL, 0x108fe20000000022ULL, 0x0000000042427984ULL, 0x000ea20000000800ULL,
0x000000231e1b7223ULL, 0x080fe2000001001bULL, 0x00007610ff1e7816ULL, 0x000fe20000000022ULL,
0x0000000121487824ULL, 0x000fe200078e0248ULL, 0x000000231f367223ULL, 0x080fe20000010036ULL,
0x00005410ff1f7816ULL, 0x110fe20000000024ULL, 0x0000000044447984ULL, 0x000ee20000000800ULL,
0x000000231e357223ULL, 0x080fe20000010035ULL, 0x00007610ff1e7816ULL, 0x000fe20000000024ULL,
0x00000001214a7824ULL, 0x000fe200078e024aULL, 0x000000231f347223ULL, 0x080fe20000010034ULL,
0x00005410ff1f7816ULL, 0x120fe20000000026ULL, 0x0000000046467984ULL, 0x000f220000000800ULL,
0x000000231e337223ULL, 0x080fe20000010033ULL, 0x00007610ff1e7816ULL, 0x000fe20000000026ULL,
0x0000000121407824ULL, 0x000fe200078e0240ULL, 0x000000231f327223ULL, 0x080fe20000010032ULL,
0x00005410ff1f7816ULL, 0x100fe20000000028ULL, 0x0000000048487984ULL, 0x000f620000000800ULL,
0x000000231e317223ULL, 0x080fe20000010031ULL, 0x00007610ff1e7816ULL, 0x000fe20000000028ULL,
0x00000001214c7824ULL, 0x000fe200078e024cULL, 0x000000231f307223ULL, 0x080fe20000010030ULL,
0x00005410ff1f7816ULL, 0x100fe2000000003aULL, 0x000000004a4a7984ULL, 0x000f620000000800ULL,
0x000000231e2f7223ULL, 0x080fe2000001002fULL, 0x00007610ff1e7816ULL, 0x000fe2000000003aULL,
0x000000ffff3a7224ULL, 0x000fe200078e003bULL, 0x000000231f2e7223ULL, 0x080fe2000001002eULL,
0x00007610ff1f7816ULL, 0x100fe2000000003cULL, 0x0000000040407984ULL, 0x000f620000000800ULL,
0x000000231e2d7223ULL, 0x000fe2000001002dULL, 0x00005410ff1e7816ULL, 0x000fc4000000003cULL,
0x000000231f1c7223ULL, 0x080fe2000001001cULL, 0x00007610ff1f7816ULL, 0x102fe20000000020ULL,
0x000000004c4c7984ULL, 0x000e620000000800ULL, 0x000000231e2b7223ULL, 0x000fe2000001002bULL,
0x00005410ff1e7816ULL, 0x000fe40000000020ULL, 0x0000004e1f167223ULL, 0x080fe20000010016ULL,
0x00007610ff1f7816ULL, 0x104fe40000000042ULL, 0x0000004e1e177223ULL, 0x000fe20000010017ULL,
0x00005410ff1e7816ULL, 0x000fc40000000042ULL, 0x0000004e1f147223ULL, 0x080fe20000010014ULL,
0x00007610ff1f7816ULL, 0x108fe40000000044ULL, 0x0000004e1e157223ULL, 0x080fe20000010015ULL,
0x00005410ff1e7816ULL, 0x000fe40000000044ULL, 0x0000004e1f127223ULL, 0x080fe20000010012ULL,
0x00007610ff1f7816ULL, 0x110fe40000000046ULL, 0x0000004e1e137223ULL, 0x000fe20000010013ULL,
0x00005410ff1e7816ULL, 0x000fc40000000046ULL, 0x0000004e1f107223ULL, 0x080fe20000010010ULL,
0x00007610ff1f7816ULL, 0x120fe40000000048ULL, 0x0000004e1e117223ULL, 0x080fe20000010011ULL,
0x00005410ff1e7816ULL, 0x000fe40000000048ULL, 0x0000004e1f0e7223ULL, 0x080fe2000001000eULL,
0x00007610ff1f7816ULL, 0x100fe4000000004aULL, 0x000003003a007a0cULL, 0x000fe20003f06070ULL,
0x0000004e1e0f7223ULL, 0x080fe2000001000fULL, 0x00005410ff1e7816ULL, 0x000fe2000000004aULL,
0x0000004e1f0c7223ULL, 0x000fe2000001000cULL, 0x00007610ff1f7816ULL, 0x000fc60000000040ULL,
0x0000004e1e0d7223ULL, 0x080fe2000001000dULL, 0x00005410ff1e7816ULL, 0x000fe20000000040ULL,
0x0000004e1f0a7223ULL, 0x000fe2000001000aULL, 0x00005410ff1f7816ULL, 0x002fc6000000004cULL,
0x0000004e1e0b7223ULL, 0x080fe4000001000bULL, 0x0000004e1f087223ULL, 0x000fe20000010008ULL,
0x00007610ff1f7816ULL, 0x000fca000000004cULL, 0x0000004e1f067223ULL, 0x000fe20000010006ULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x0180000039027810ULL, 0x004fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000002027812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00016bf000097802ULL, 0x000fe40000000f00ULL,
0x0000675000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003900027308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000039ULL, 0x800000ff04057221ULL, 0x000fc80000010100ULL,
0x0000000502027223ULL, 0x000fe40000000002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008073c7811ULL, 0x004fe400078ff0ffULL, 0x00000002ff097819ULL, 0x000fe40000011607ULL,
0x0000003cff3a7212ULL, 0x000fe200078e33ffULL, 0x00001f3c02057589ULL, 0x000ea200000e0000ULL,
0x000000083c1d7824ULL, 0x000fc400078e00ffULL, 0x0000000809197824ULL, 0x000fe200078e00ffULL,
0x00001f0902047589ULL, 0x00072400000e0000ULL, 0xfffffff81d3a7812ULL, 0x000fca00078ee23aULL,
0x000000103a3a7824ULL, 0x000fe200078e0203ULL, 0x00000009ff027212ULL, 0x008fc800078e33ffULL,
0xfffffff8193e7812ULL, 0x000fe200078ee202ULL, 0x0000000809027824ULL, 0x000fe200078e00ffULL,
0x0000001705177220ULL, 0x044fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001105117220ULL, 0x040fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000000f050f7220ULL, 0x040fe20000410000ULL, 0x0000000e050e7220ULL, 0x040fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000000c050c7220ULL, 0x040fe20000410000ULL,
0x0000000b050b7220ULL, 0x040fe20000410000ULL, 0x0000000a050a7220ULL, 0x040fe20000410000ULL,
0x0000000805087220ULL, 0x040fe20000410000ULL, 0x0000000605057220ULL, 0x000fe20000410000ULL,
0x0000000709067812ULL, 0x000fe200078ec0ffULL, 0x0000003804387220ULL, 0x050fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x000000080505723eULL, 0x000fe200000010ffULL, 0x0000001804047220ULL, 0x000fe20000410000ULL,
0x0000000106087812ULL, 0x000fc400078e3cffULL, 0x0000000206187812ULL, 0x040fe400078e3cffULL,
0x00000003061a7812ULL, 0x040fe400078e3cffULL, 0x00000004061e7812ULL, 0x040fe400078e3cffULL,
0x0000000506207812ULL, 0x040fe400078e3cffULL, 0x0000000606227812ULL, 0x000fe200078e3cffULL,
0x0000000809067824ULL, 0x040fe200078e0208ULL, 0x0000000b0a0a723eULL, 0x000fe200000010ffULL,
0x000000083c0b7824ULL, 0x000fe200078e00ffULL, 0x000000131212723eULL, 0x000fe200000010ffULL,
0x0000000809087824ULL, 0x040fe200078e0218ULL, 0x000000111010723eULL, 0x000fe200000010ffULL,
0x0000000809187824ULL, 0x000fe200078e021aULL, 0x000000073c117812ULL, 0x000fe200078ec0ffULL,
0x0000000407137824ULL, 0x000fe200078e00ffULL, 0xfffffff802027812ULL, 0x000fe200078ee209ULL,
0x00000008091a7824ULL, 0x040fe200078e021eULL, 0x000000151414723eULL, 0x000fe200000010ffULL,
0x00000008091e7824ULL, 0x040fe200078e0220ULL, 0x0000000f0e0e723eULL, 0x000fe200000010ffULL,
0x0000000809207824ULL, 0x000fe200078e0222ULL, 0x0000000d0c0c723eULL, 0x000fe200000010ffULL,
0x0000001002027824ULL, 0x100fe200078e0203ULL, 0xfffffff80b227812ULL, 0x000fe200078ee23cULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x0000000111077812ULL, 0x040fe200078e3cffULL,
0x0000001008087824ULL, 0x100fe200078e0203ULL, 0x0000000211097812ULL, 0x040fe200078e3cffULL,
0x0000001018187824ULL, 0x100fe200078e0203ULL, 0x00000003110b7812ULL, 0x040fe200078e3cffULL,
0x000000101a1a7824ULL, 0x000fe200078e0203ULL, 0x00000004110d7812ULL, 0x040fe200078e3cffULL,
0x000000083c247824ULL, 0x040fe200078e0207ULL, 0x00000005110f7812ULL, 0x000fe200078e3cffULL,
0x000000083c267824ULL, 0x040fe200078e0209ULL, 0x0000000c13157812ULL, 0x000fe200078ec0ffULL,
0x000000083c287824ULL, 0x040fe200078e020bULL, 0x0000000611117812ULL, 0x000fe200078e3cffULL,
0x000000083c2a7824ULL, 0x040fe200078e020dULL, 0x000000383737723eULL, 0x000fe200000010ffULL,
0x0000000115027824ULL, 0x000fe200078e0202ULL, 0x000000302f2f723eULL, 0x000fe200000010ffULL,
0x000000083c307824ULL, 0x040fe200078e0211ULL, 0x0000002e2d2d723eULL, 0x000fe200000010ffULL,
0x000000083c2e7824ULL, 0x000fe200078e020fULL, 0x000000363535723eULL, 0x000fe200000010ffULL,
0x000000101e1e7824ULL, 0x100fe200078e0203ULL, 0x000000343333723eULL, 0x000fe200000010ffULL,
0x0000000115067824ULL, 0x000fe200078e0206ULL, 0x000000323131723eULL, 0x000fe200000010ffULL,
0x0000001020207824ULL, 0x100fe200078e0203ULL, 0x0000003702007388ULL, 0x0005e20000000800ULL,
0x0000000115087824ULL, 0x040fe200078e0208ULL, 0x0000002b1c1c723eULL, 0x000fe200000010ffULL,
0x000000103e077824ULL, 0x100fe200078e0203ULL, 0x0000003506007388ULL, 0x0005e20000000800ULL,
0x0000000115187824ULL, 0x040fe200078e0218ULL, 0x0000001b0404723eULL, 0x000fe200000010ffULL,
0x0000001022227824ULL, 0x100fe200078e0203ULL, 0x0000003308007388ULL, 0x0005e20000000800ULL,
0x00000001151a7824ULL, 0x000fe200078e021aULL, 0x000000171616723eULL, 0x000fe200000010ffULL,
0x0000001024247824ULL, 0x100fe200078e0203ULL, 0x0000003118007388ULL, 0x0005e20000000800ULL,
0x0000001026267824ULL, 0x000fc400078e0203ULL, 0x0000001028287824ULL, 0x100fe200078e0203ULL,
0x0000002f1a007388ULL, 0x0005e20000000800ULL, 0x000000102a2a7824ULL, 0x100fe400078e0203ULL,
0x000000102e2e7824ULL, 0x100fe400078e0203ULL, 0x0000001030307824ULL, 0x000fe400078e0203ULL,
0x00000001151e7824ULL, 0x040fe400078e021eULL, 0x0000000115037824ULL, 0x000fc400078e0220ULL,
0x0000000115077824ULL, 0x040fe200078e0207ULL, 0x0000002d1e007388ULL, 0x0005e20000000800ULL,
0x0000000115097824ULL, 0x040fe400078e0222ULL, 0x00000001150b7824ULL, 0x040fe200078e0224ULL,
0x0000001c03007388ULL, 0x0005e20000000800ULL, 0x00000001150d7824ULL, 0x040fe400078e0226ULL,
0x00000001150f7824ULL, 0x040fe200078e0228ULL, 0x0000000407007388ULL, 0x0005e20000000800ULL,
0x0000000115117824ULL, 0x000fc400078e022aULL, 0x00000001153a7824ULL, 0x040fe200078e023aULL,
0x0000001609007388ULL, 0x0005e20000000800ULL, 0x0000000115137824ULL, 0x040fe400078e022eULL,
0x0000000115157824ULL, 0x000fe200078e0230ULL, 0x000000140b007388ULL, 0x0005e80000000800ULL,
0x000000120d007388ULL, 0x0005e80000000800ULL, 0x000000100f007388ULL, 0x0005e80000000800ULL,
0x0000000e11007388ULL, 0x0005e80000000800ULL, 0x0000000c13007388ULL, 0x0005e80000000800ULL,
0x0000000a15007388ULL, 0x0005e80000000800ULL, 0x000000053a007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000147919ULL, 0x004ea20000002600ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000580000057ab9ULL, 0x000fc40000000800ULL,
0x0000000000157919ULL, 0x000f220000000000ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000001014037824ULL, 0x004fc600078e00ffULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x0000001014067824ULL, 0x040fe200078e00ffULL, 0x00000003ff027819ULL, 0x010fe20000011615ULL,
0x0000001014217824ULL, 0x000fe200078e00ffULL, 0x0000002015167810ULL, 0x040fe40007ffe0ffULL,
0x0000004015177810ULL, 0x040fe40007ffe0ffULL, 0x0000006015207810ULL, 0x000fe40007ffe0ffULL,
0xfffffff003047812ULL, 0x000fc400078ee202ULL, 0x00000003ff037819ULL, 0x000fe40000011616ULL,
0x00000003ff077819ULL, 0x000fe40000011617ULL, 0x00000003ff0a7819ULL, 0x000fe40000011620ULL,
0x0000000702027812ULL, 0x000fe400078e4815ULL, 0x0000000703057812ULL, 0x000fe400078e4816ULL,
0xfffffff006067812ULL, 0x000fc400078ee203ULL, 0x0000000707087812ULL, 0x000fe400078e4817ULL,
0x000000070a0b7812ULL, 0x000fe400078e4820ULL, 0x0ffffff802037812ULL, 0x000fe400078ef815ULL,
0x0ffffff805057812ULL, 0x000fe400078ef816ULL, 0x0ffffff808097812ULL, 0x000fe200078ef817ULL,
0x00000010030c7824ULL, 0x000fe200078e0200ULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef820ULL,
0x0000001005057824ULL, 0x100fe200078e0200ULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001009097824ULL, 0x000fe200078e0200ULL, 0xfffffff0210a7812ULL, 0x000fe200078ee20aULL,
0x000000100b1c7824ULL, 0x000fe200078e0200ULL, 0x00a000000c0c7984ULL, 0x000ea20000000c00ULL,
0x0000001014007824ULL, 0x000fe200078e00ffULL, 0x00000007150b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00a0000005107984ULL, 0x0007220000000c00ULL,
0x00005a0004027a11ULL, 0x000fc400078048ffULL, 0xfffffff000007812ULL, 0x000fe200078ee207ULL,
0x00a0000009187984ULL, 0x000a620000000c00ULL, 0x00005b0004037a11ULL, 0x000fe400000f4c03ULL,
0x0000000717077812ULL, 0x000fe200078ec0ffULL, 0x00a000001c1c7984ULL, 0x000e620000000c00ULL,
0x0000000716057812ULL, 0x008fe400078ec0ffULL, 0x0000000400007c10ULL, 0x000fe4000ff3e0ffULL,
0x1ffffff805157812ULL, 0x000fc400078ef82cULL, 0x0000000406057c10ULL, 0x000fe4000ff1e0ffULL,
0x000000040a0a7c10ULL, 0x000fe4000ff5e0ffULL, 0x1ffffff807177812ULL, 0x000fe200078ef82cULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00005a0005047a11ULL, 0x000fe200078048ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000000720097812ULL, 0x020fe200078ec0ffULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0x00005a0000067a11ULL, 0x000fc400078248ffULL,
0x00005a000a087a11ULL, 0x000fe400078448ffULL, 0x1ffffff80b0b7812ULL, 0x000fe400078ef82cULL,
0x00005b0005057a11ULL, 0x000fe400000f4c14ULL, 0x1ffffff809217812ULL, 0x000fe200078ef82cULL,
0x000000100b027825ULL, 0x000fe200078e0002ULL, 0x00005b0000077a11ULL, 0x000fe400008f4c07ULL,
0x00005b000a097a11ULL, 0x000fe200010f4c23ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x004fe6000c101d06ULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x0000001004007986ULL, 0x010fe6000c101d06ULL, 0x0000001021087825ULL, 0x000fe200078e0008ULL,
0x0000001806007986ULL, 0x002fe8000c101d06ULL, 0x0000001c08007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x00000006043c7981ULL, 0x000362000c1e9900ULL,
0x0000000124007810ULL, 0x000fe20007ffe0ffULL, 0x0000000227077824ULL, 0x000fe400078e00ffULL,
0x0000004002277824ULL, 0x000fe200078e00ffULL, 0x000000250000720cULL, 0x000fe20003f06070ULL,
0x0000580007267a24ULL, 0x000fe400078e0212ULL, 0x0000010024097824ULL, 0x000fc800078e0227ULL,
0x0000620026187a24ULL, 0x000fcc00078e0209ULL, 0x000005c000008947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x002e620000000000ULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x0000000903007217ULL, 0x000fe40007800000ULL, 0x0000200002147811ULL, 0x000fc600078e68ffULL,
0x0000000100007824ULL, 0x000fe200078e0a09ULL, 0x00000002ff1d7819ULL, 0x102fe2000001160fULL,
0x000000100f1f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fe4000001160fULL,
0x000000081d117810ULL, 0x040fe20007ffe0ffULL, 0x000000011d047824ULL, 0x140fe200078e0218ULL,
0x000000181d297810ULL, 0x040fe40007ffe0ffULL, 0x000000101d237810ULL, 0x000fe20007ffe0ffULL,
0x0000000111067824ULL, 0x000fe200078e0218ULL, 0x000000301f1f7812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x000000201d177810ULL, 0x000fc40007ffe0ffULL,
0x0000000312127812ULL, 0x100fe200078e480fULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000001f040c7210ULL, 0x080fe40007f1e0ffULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x00000001290a7824ULL, 0x100fe200078e0218ULL, 0x0000001f06067210ULL, 0x000fe20007f3e0ffULL,
0x0000000123087824ULL, 0x000fe200078e0218ULL, 0x0ffffffc120f7812ULL, 0x000fe200078ef80fULL,
0x00005e000a0a7625ULL, 0x000fe200078e0021ULL, 0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000002300720cULL, 0x080fe20003fa6070ULL, 0x0000000118047824ULL, 0x000fe200078e0217ULL,
0x000000001700720cULL, 0x080fe20003f66070ULL, 0x00005e0008087625ULL, 0x000fe200078e0021ULL,
0x000000002900720cULL, 0x000fc60003f86070ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x0000001f08087210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000001f0a0a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0004047625ULL, 0x000fc800078e0021ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000001f040e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000118047824ULL, 0x000fe200078e0219ULL, 0x000000001100720cULL, 0x080fe20003f26070ULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000001d00720cULL, 0x080fe20003f06070ULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000100f137824ULL, 0x000fe400078e0214ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0605ULL,
0xfffffffc11117812ULL, 0x000fe200078ee212ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x000000001900720cULL, 0x000fc60003f46070ULL, 0x0000001011157824ULL, 0x000fe200078e0214ULL,
0x0000001f04107210ULL, 0x000fe20007fde0ffULL, 0x0000000118047824ULL, 0x000fe200078e021bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c137faeULL, 0x0003e2000c101c46ULL,
0x000000001d00720cULL, 0x080fe40003f06070ULL, 0x000000ffff117224ULL, 0x000fe200030e0605ULL,
0x0000000006157faeULL, 0x0005e2000c901c46ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x000000001b00720cULL, 0x000fc80003f26070ULL, 0x0000001f04047210ULL, 0x000fe20007fde0ffULL,
0x00000004230d7824ULL, 0x002fe400078e00ffULL, 0x0000000429137824ULL, 0x000fe400078e00ffULL,
0x0000000118067824ULL, 0x004fe200078e021dULL, 0xfffffffc0d0d7812ULL, 0x100fe200078ee212ULL,
0x0000000417157824ULL, 0x000fe200078e00ffULL, 0xfffffffc13137812ULL, 0x100fe200078ee212ULL,
0x0000000419177824ULL, 0x000fe400078e00ffULL, 0x000000041b197824ULL, 0x000fe200078e00ffULL,
0xfffffffc15157812ULL, 0x100fe200078ee212ULL, 0x000000041d1b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc17177812ULL, 0x100fe200078ee212ULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0xfffffffc19197812ULL, 0x000fc400078ee212ULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee212ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000001f06067210ULL, 0x000fe20007fde0ffULL,
0x000000100d0d7824ULL, 0x100fe400078e0214ULL, 0x0000001013137824ULL, 0x100fe400078e0214ULL,
0x0000001015157824ULL, 0x100fe200078e0214ULL, 0x00000000080d7faeULL, 0x0003e2000e901c46ULL,
0x0000001017177824ULL, 0x100fe400078e0214ULL, 0x0000001019197824ULL, 0x100fe200078e0214ULL,
0x000000000a137faeULL, 0x0003e2000e101c46ULL, 0x000000101b1b7824ULL, 0x000fc400078e0214ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x000000000e157faeULL, 0x0003e8000d901c46ULL,
0x0000000010177faeULL, 0x0003e8000d101c46ULL, 0x0000000004197faeULL, 0x0003e8000c901c46ULL,
0x00000000061b7faeULL, 0x0003e2000c101c46ULL, 0x0000050000007947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x002e620000000000ULL, 0x00000100ff237424ULL, 0x000fe200078e00ffULL,
0x0000200002217811ULL, 0x000fe200078e68ffULL, 0x000000100f067824ULL, 0x042fe200078e00ffULL,
0x000000100f057811ULL, 0x000fc400078ff0ffULL, 0x000000180f047211ULL, 0x000fe400078ff0ffULL,
0x00000003ff007819ULL, 0x000fe2000001160fULL, 0x0000000405137824ULL, 0x000fe200078e00ffULL,
0x000000080f0d7811ULL, 0x040fe400078ff0ffULL, 0x0000003006297812ULL, 0x000fe200078ec0ffULL,
0x0000000118067824ULL, 0x000fe200078e0205ULL, 0x000000200f097811ULL, 0x040fe200078ff0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0023ULL, 0x000000180f077811ULL, 0x000fc400078ff0ffULL,
0x00000003001a7812ULL, 0x000fe200078e480fULL, 0x000000010d007824ULL, 0x000fe200078e0218ULL,
0x000000280f0a7811ULL, 0x000fe200078ff0ffULL, 0x000000040d117824ULL, 0x000fe200078e00ffULL,
0x000000300f0b7811ULL, 0x000fe200078ff0ffULL, 0x00000001180d7824ULL, 0x000fe200078e0209ULL,
0x00000029040e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x000000380f0c7811ULL, 0x000fe200078ff0ffULL, 0x0000000118087824ULL, 0x000fe200078e0207ULL,
0x0ffffffc1a127812ULL, 0x000fe200078ef80fULL, 0x0000000407077824ULL, 0x000fe200078e00ffULL,
0xfffffffc09107812ULL, 0x000fe200078ee21aULL, 0x0000000118147824ULL, 0x000fc400078e020aULL,
0x000000040a157824ULL, 0x000fe200078e00ffULL, 0xfffffffc110a7812ULL, 0x100fe200078ee21aULL,
0x0000000118167824ULL, 0x040fe400078e020bULL, 0x000000ffff0f7224ULL, 0x000fe200000e0605ULL,
0xfffffffc15117812ULL, 0x000fe200078ee21aULL, 0x0000000118187824ULL, 0x000fe400078e020cULL,
0x000000040c197824ULL, 0x000fe200078e00ffULL, 0xfffffffc070c7812ULL, 0x000fe200078ee21aULL,
0x00005e0000047625ULL, 0x000fc800078e0023ULL, 0x000000040b177824ULL, 0x000fe200078e00ffULL,
0xfffffffc130b7812ULL, 0x000fe200078ee21aULL, 0x00005e0006067625ULL, 0x000fc600078e0023ULL,
0xfffffffc17137812ULL, 0x100fe200078ee21aULL, 0x00000010101b7824ULL, 0x000fe200078e0221ULL,
0x0000002904107210ULL, 0x000fe20007f1e0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0023ULL,
0xfffffffc191a7812ULL, 0x000fc600078ee21aULL, 0x00000010122b7824ULL, 0x100fe200078e0221ULL,
0x0000002906127210ULL, 0x080fe20007f3e0ffULL, 0x00000010111d7824ULL, 0x000fe400078e0221ULL,
0x000000ffff117224ULL, 0x000fe200000e0605ULL, 0x0000002908087210ULL, 0x000fe20007f1e0ffULL,
0x00000010131f7824ULL, 0x000fe200078e0221ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e2b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fe400008e0607ULL,
0x00005e000d047625ULL, 0x000fc800078e0023ULL, 0x000000100a157824ULL, 0x100fe400078e0221ULL,
0x000000100b177824ULL, 0x100fe400078e0221ULL, 0x00005e0014067625ULL, 0x000fe200078e0023ULL,
0x0000000010157faeULL, 0x0003e6000b901c46ULL, 0x000000100c197824ULL, 0x000fe200078e0221ULL,
0x0000002906067210ULL, 0x000fe20007f3e0ffULL, 0x00005e00160a7625ULL, 0x080fe200078e0023ULL,
0x0000000012177faeULL, 0x0003e6000b901c46ULL, 0x00005e00180c7625ULL, 0x000fe200078e0023ULL,
0x000000290a0a7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x0000002904047210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000290c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000008197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400000e0605ULL,
0x000000101a217824ULL, 0x000fe400078e0221ULL, 0x000000ffff0d7224ULL, 0x000fe200018e060dULL,
0x00000000041b7faeULL, 0x0003e8000b901c46ULL, 0x00000000061d7faeULL, 0x0003e8000b901c46ULL,
0x000000000a1f7faeULL, 0x0003e8000b901c46ULL, 0x000000000c217faeULL, 0x0003e4000b901c46ULL,
0x01060400ff007984ULL, 0x000ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x004fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01060400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000030200780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x002e640000000000ULL,
0x0000002002007824ULL, 0x002fc800078e0205ULL, 0x0000002000067824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000001e006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105097812ULL, 0x040fe400078efcffULL,
0x0000000705077812ULL, 0x100fe400078e7800ULL, 0x0000000709097812ULL, 0x100fe400078e7800ULL,
0x00000010050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x040fe200078e0207ULL,
0x0000001105057810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x000000070b0b7812ULL, 0x000fc400078e7800ULL, 0x0000000007107984ULL, 0x000e62000000cc00ULL,
0x0000000705057812ULL, 0x000fe400078e7800ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x00000000090c7984ULL, 0x000ea4000000cc00ULL, 0x0000000106057824ULL, 0x000fe400078e0205ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fe200078e0013ULL,
0x0000001407007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fca00078e000fULL, 0x0000001809007388ULL, 0x000fe8000000cc00ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x000000000b107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c0b007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01060400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01060400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000252400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003d7919ULL, 0x000ea20000000000ULL,
0x3d8000003c3c7820ULL, 0x020fe20000410000ULL, 0x00000010023a7824ULL, 0x000fe200078e00ffULL,
0xffffffff253b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x00007610ff387816ULL, 0x000fe40000000038ULL, 0x00000100243e7824ULL, 0x000fe200078e0227ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003e0300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x008fea0003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0039ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x0000000100287810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e0000ULL,
0x000000013f397812ULL, 0x000fc400078e0cffULL, 0x00000002ff297819ULL, 0x100fe20000011628ULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0x000000042800780cULL, 0x000fc60003f06070ULL,
0x00000300292a7a24ULL, 0x000fe200078e0224ULL, 0x0000000328297812ULL, 0x000fc600078ec0ffULL,
0x000001002a2b7824ULL, 0x040fe200078e0227ULL, 0x000000012a2c7810ULL, 0x000fc60007ffe0ffULL,
0x0000620026367a24ULL, 0x000fe200078e022bULL, 0x000000252c00720cULL, 0x000fda0003f26070ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000002b03287217ULL, 0x000fe20007800000ULL,
0x00000004292e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff317819ULL, 0x004fe2000001163dULL,
0x0000000202347824ULL, 0x000fe200078e0239ULL, 0x00000003ff2a7819ULL, 0x000fe2000001163dULL,
0x00000001282c7824ULL, 0x000fe200078e0a2bULL, 0x0000000831297810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff337424ULL, 0x000fe200078e00ffULL, 0x000000032a427812ULL, 0x100fe200078e483dULL,
0x0000000131287824ULL, 0x140fe200078e0236ULL, 0x0000002c3100720cULL, 0x080fe20003f26070ULL,
0x00000001292a7824ULL, 0x040fe200078e0236ULL, 0x0000002c2900720cULL, 0x040fe20003f46070ULL,
0x00000004292f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc2e357812ULL, 0x000fe200078ee23dULL,
0x00005e0028287625ULL, 0x000fe200078e0033ULL, 0x0000200034347811ULL, 0x000fc400078e60ffULL,
0x0ffffffc422d7812ULL, 0x000fe200078ef83dULL, 0x00005e002a2a7625ULL, 0x000fe200078e0033ULL,
0xfffffffc2f2f7812ULL, 0x000fe400078ee242ULL, 0x0000001031377810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0234ULL, 0x0000001831417810ULL, 0x000fe20007ffe0ffULL,
0x0000001035287825ULL, 0x000fe200078e0028ULL, 0x0000002031437810ULL, 0x040fe40007ffe0ffULL,
0x0000002831457810ULL, 0x000fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0234ULL,
0x0000003031477810ULL, 0x000fe20007ffe0ffULL, 0x00000010352a7825ULL, 0x000fe200078e002aULL,
0x0000003831317810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282d7faeULL, 0x0003e2000c901c46ULL, 0x0000002c3700720cULL, 0x080fe20003f26070ULL,
0x00000001452e7824ULL, 0x100fe200078e0236ULL, 0x0000002c4300720cULL, 0x080fe20003f66070ULL,
0x000000002a2f7faeULL, 0x0005e2000d101c46ULL, 0x0000002c4100720cULL, 0x080fe20003f46070ULL,
0x0000000147307824ULL, 0x100fe200078e0236ULL, 0x0000002c4500720cULL, 0x080fe20003f86070ULL,
0x0000000131327824ULL, 0x100fe200078e0236ULL, 0x0000002c4700720cULL, 0x080fe20003fa6070ULL,
0x0000000431497824ULL, 0x040fe200078e00ffULL, 0x0000002c3100720cULL, 0x000fe20003fc6070ULL,
0x0000000137287824ULL, 0x002fc400078e0236ULL, 0x00000001432c7824ULL, 0x000fe200078e0236ULL,
0xfffffffc49497812ULL, 0x000fe200078ee242ULL, 0x00000001412a7824ULL, 0x004fe400078e0236ULL,
0x0000000437377824ULL, 0x000fe400078e00ffULL, 0x0000000441417824ULL, 0x000fe400078e00ffULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0xfffffffc37377812ULL, 0x100fe200078ee242ULL,
0x00005e0028287625ULL, 0x000fe200078e0033ULL, 0xfffffffc41417812ULL, 0x000fc400078ee242ULL,
0xfffffffc43437812ULL, 0x000fe200078ee242ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0033ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0033ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0033ULL,
0x00005e0030307625ULL, 0x000fc800078e0033ULL, 0x0000000445457824ULL, 0x000fe400078e00ffULL,
0x00005e0032327625ULL, 0x000fc600078e0033ULL, 0xfffffffc45457812ULL, 0x000fe200078ee242ULL,
0x0000000447477824ULL, 0x000fe400078e00ffULL, 0x0000001035287825ULL, 0x000fc600078e0028ULL,
0xfffffffc47477812ULL, 0x000fe200078ee242ULL, 0x00000010352a7825ULL, 0x000fc800078e002aULL,
0x00000010352c7825ULL, 0x000fc800078e002cULL, 0x00000010352e7825ULL, 0x000fc800078e002eULL,
0x0000001035307825ULL, 0x000fc800078e0030ULL, 0x0000001035327825ULL, 0x000fc800078e0032ULL,
0x0000001037357824ULL, 0x100fe400078e0234ULL, 0x0000001041377824ULL, 0x100fe400078e0234ULL,
0x0000001043417824ULL, 0x100fe200078e0234ULL, 0x0000000028357faeULL, 0x0003e2000c901c46ULL,
0x0000001045437824ULL, 0x100fe400078e0234ULL, 0x0000001047457824ULL, 0x100fe200078e0234ULL,
0x000000002a377faeULL, 0x0003e2000d101c46ULL, 0x0000001049477824ULL, 0x000fc600078e0234ULL,
0x000000002c417faeULL, 0x0003e8000d901c46ULL, 0x000000002e437faeULL, 0x0003e8000e101c46ULL,
0x0000000030457faeULL, 0x0003e8000e901c46ULL, 0x0000000032477faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x00000004292c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff2a7819ULL, 0x004fe2000001163dULL, 0x0000000202297824ULL, 0x000fe200078e0239ULL,
0x000000083d2b7811ULL, 0x040fe200078ff0ffULL, 0x00000100ff377424ULL, 0x000fe200078e00ffULL,
0x000000103d2d7811ULL, 0x000fc400078ff0ffULL, 0x000000183d2f7811ULL, 0x040fe400078ff0ffULL,
0x000000203d317811ULL, 0x040fe400078ff0ffULL, 0x000000283d337811ULL, 0x000fe200078ff0ffULL,
0x000000012f2e7824ULL, 0x100fe200078e0236ULL, 0x000000303d357811ULL, 0x000fe200078ff0ffULL,
0x0000000131307824ULL, 0x100fe200078e0236ULL, 0x000000383d437811ULL, 0x000fe200078ff0ffULL,
0x0000000133327824ULL, 0x100fe200078e0236ULL, 0xfffffffc2c417812ULL, 0x100fe200078ee23dULL,
0x000000012d2c7824ULL, 0x100fe200078e0236ULL, 0x000000032a427812ULL, 0x000fe200078e483dULL,
0x000000012b2a7824ULL, 0x100fe200078e0236ULL, 0x000000363d287211ULL, 0x000fe200078ff0ffULL,
0x0000000135347824ULL, 0x000fe200078e0236ULL, 0x00002000294d7811ULL, 0x000fe200078e60ffULL,
0x000000042b2b7824ULL, 0x000fc400078e00ffULL, 0x000000042d2d7824ULL, 0x000fe400078e00ffULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc2b447812ULL, 0x100fe200078ee242ULL,
0x0000000431317824ULL, 0x000fe200078e00ffULL, 0xfffffffc2d467812ULL, 0x100fe200078ee242ULL,
0x0000000433337824ULL, 0x000fe200078e00ffULL, 0xfffffffc2f487812ULL, 0x100fe200078ee242ULL,
0x0000000435357824ULL, 0x000fe200078e00ffULL, 0xfffffffc314a7812ULL, 0x000fe200078ee242ULL,
0x0000000143367824ULL, 0x000fe200078e0236ULL, 0xfffffffc334c7812ULL, 0x100fe200078ee242ULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0xfffffffc354e7812ULL, 0x000fe200078ee242ULL,
0x00005e0028287625ULL, 0x000fc600078e0037ULL, 0xfffffffc43507812ULL, 0x000fe200078ee242ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0037ULL, 0x0ffffffc42427812ULL, 0x000fc600078ef83dULL,
0x00005e002c2c7625ULL, 0x000fc800078e0037ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0037ULL,
0x00005e0030307625ULL, 0x000fc800078e0037ULL, 0x00005e0032327625ULL, 0x000fc800078e0037ULL,
0x00005e0034347625ULL, 0x000fc800078e0037ULL, 0x00005e0036367625ULL, 0x000fc800078e0037ULL,
0x0000001041287825ULL, 0x000fc800078e0028ULL, 0x00000010412a7825ULL, 0x000fc800078e002aULL,
0x00000010412c7825ULL, 0x000fc800078e002cULL, 0x00000010412e7825ULL, 0x000fc800078e002eULL,
0x0000001041307825ULL, 0x000fc800078e0030ULL, 0x0000001041327825ULL, 0x000fc800078e0032ULL,
0x0000001041347825ULL, 0x000fc800078e0034ULL, 0x0000001041367825ULL, 0x000fc800078e0036ULL,
0x00000010424f7824ULL, 0x100fe400078e024dULL, 0x0000001044417824ULL, 0x100fe400078e024dULL,
0x0000001046437824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000284f7faeULL, 0x0003e2000b901c46ULL, 0x0000001048457824ULL, 0x100fe400078e024dULL,
0x000000104a477824ULL, 0x100fe200078e024dULL, 0x000000002a417faeULL, 0x0003e2000b901c46ULL,
0x000000104c497824ULL, 0x000fc400078e024dULL, 0x000000104e4b7824ULL, 0x100fe200078e024dULL,
0x000000002c437faeULL, 0x0003e2000b901c46ULL, 0x00000010504d7824ULL, 0x000fc600078e024dULL,
0x000000002e457faeULL, 0x0003e8000b901c46ULL, 0x0000000030477faeULL, 0x0003e8000b901c46ULL,
0x0000000032497faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e8000b901c46ULL,
0x00000000364d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000840427824ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83d287812ULL, 0x002fe200078ec0ffULL, 0x00000002022c7824ULL, 0x000fe200078e023fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001402e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000728287812ULL, 0x000fe400078ef83dULL, 0x000020002c2c7811ULL, 0x000fe400078e60ffULL,
0x00000001ff297819ULL, 0x000fc40000011628ULL, 0x000000073dcc7812ULL, 0x000fe400078ec0ffULL,
0x0000000329297812ULL, 0x000fe400078ec0ffULL, 0x00000008cccc7812ULL, 0x000fe400078ef83dULL,
0x00000040292b7212ULL, 0x040fe400078e3cffULL, 0x0000002e29297212ULL, 0x000fc600078e3cffULL,
0x00000004282b7824ULL, 0x040fe400078e022bULL, 0x0000000428297824ULL, 0x000fe200078e0229ULL,
0x000000203d287810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x100fe400078e022cULL,
0x0000001029297824ULL, 0x000fe200078e022cULL, 0xfffffff828287812ULL, 0x000fe400078ec0ffULL,
0x000000002b34783bULL, 0x000e640000000200ULL, 0x00000007282d7812ULL, 0x000fc400078ef83dULL,
0x000000002930783bULL, 0x0004e40000000200ULL, 0x00000001ff287819ULL, 0x000fc8000001162dULL,
0x00000003282f7812ULL, 0x000fc800078ec0ffULL, 0x000000402f287212ULL, 0x040fe400078e3cffULL,
0x0000002e2f2e7212ULL, 0x000fe400078e3cffULL, 0x0000000240407810ULL, 0x000fe20007ffe0ffULL,
0x000000042d297824ULL, 0x044fe400078e0228ULL, 0x000000042d2d7824ULL, 0x000fe400078e022eULL,
0x0000001029297824ULL, 0x100fe400078e022cULL, 0x000000102d2d7824ULL, 0x000fc800078e022cULL,
0x000000002928783bULL, 0x000ea80000000200ULL, 0x000000002d2c783bULL, 0x000f220000000200ULL,
0x0000003400717306ULL, 0x002fe20000009400ULL, 0x00000018ffad7819ULL, 0x000fe20000011434ULL,
0x00010000345c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011435ULL,
0x0001000030777824ULL, 0x048fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011437ULL,
0x00010000317a7824ULL, 0x040fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe2000001145cULL,
0x0000003400a67306ULL, 0x000e620000005400ULL, 0x00000018ff947819ULL, 0x000fe20000011436ULL,
0x00000100307c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000010032697824ULL, 0x040fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011430ULL,
0x00000100317f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x00000034005b7306ULL, 0x000762000000d400ULL, 0x00000018ff607819ULL, 0x000fe20000011431ULL,
0x0001000032727824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x00000018ff567819ULL, 0x000fe40000011432ULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x008fe200078e00ffULL,
0x000000a67100720bULL, 0x002fe40003f9d000ULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0001000028c47824ULL, 0x004fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe20000011434ULL,
0x0001000035347824ULL, 0x000fe200078e00ffULL, 0x000000a700a97306ULL, 0x000e620000205400ULL,
0x00000018ff9d7819ULL, 0x000fc40000011428ULL, 0x00000018ff917819ULL, 0x000fe40000011429ULL,
0x00000018ffb07819ULL, 0x000fe20000011434ULL, 0x0001000036347824ULL, 0x000fe200078e00ffULL,
0x000000015b5b4812ULL, 0x020fe200078efcffULL, 0x0000003500a27306ULL, 0x000fe20000009400ULL,
0x00000018ffc47819ULL, 0x000fe400000114c4ULL, 0x00000018ffb87819ULL, 0x000fe20000011434ULL,
0x0001000037347824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc4000001142aULL,
0x00000018ff837819ULL, 0x000fe2000001142bULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a9a800720bULL, 0x002fe20003f5d000ULL, 0x0000010029a87824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe20000011434ULL, 0x000100002aa97824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x000000b000b27306ULL, 0x000e620000205400ULL, 0x00000018ffa97819ULL, 0x000fc400000114a9ULL,
0x000000a800cb7245ULL, 0x000fe4000020d400ULL, 0x00000018ff4c7819ULL, 0x000fc60000011433ULL,
0x0000003500a37306ULL, 0x000eb00000005400ULL, 0x0000003600a07306ULL, 0x000fe20000009400ULL,
0x000000b2b100720bULL, 0x002fce0003fbd000ULL, 0x0000003600a17306ULL, 0x000e620000005400ULL,
0x000000a3a200720bULL, 0x004fe40003f3d000ULL, 0x000000a700a27245ULL, 0x000fe4000020d400ULL,
0x000000aa00a37245ULL, 0x000fe4000020d400ULL, 0x00000001a2a22812ULL, 0x000fe200078efcffULL,
0x000000b800b97306ULL, 0x000fe60000209400ULL, 0x0000005ba2a2723eULL, 0x000fca00000010ffULL,
0x000000b800ba7306ULL, 0x0004e20000205400ULL, 0x000000a1a000720bULL, 0x002fe40003f5d000ULL,
0x000000b000a17245ULL, 0x000fe4000020d400ULL, 0x000000ad00a07245ULL, 0x000fe4000020d400ULL,
0x00000001a1a15812ULL, 0x000fe200078efcffULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x004fce000020d400ULL, 0x000000aa00ac7306ULL, 0x000e620000205400ULL,
0x000000bab900720bULL, 0x008fce0003fbd000ULL, 0x00000035005a7306ULL, 0x0004ec000000d400ULL,
0x00000001b8b85812ULL, 0x000fe400078efcffULL, 0x0000009f00b67306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x004fe200078e00ffULL, 0x000000acab00720bULL, 0x002fc80003f7d000ULL,
0x00000018ffb37819ULL, 0x000fe40000011435ULL, 0x0000009f00b77306ULL, 0x000e620000205400ULL,
0x000000015a5a1812ULL, 0x008fc800078efcffULL, 0x0000005aa15a723eULL, 0x000fe400000010ffULL,
0x00000001a3a33812ULL, 0x000fe200078efcffULL, 0x000000be00bf7306ULL, 0x000ff00000209400ULL,
0x000000be00c07306ULL, 0x0004e20000205400ULL, 0x000000b7b600720bULL, 0x002fce0003f9d000ULL,
0x000000ad00ae7306ULL, 0x000fe20000209400ULL, 0x000000be00be7245ULL, 0x004fce000020d400ULL,
0x000000ad00af7306ULL, 0x000e620000205400ULL, 0x000000c0bf00720bULL, 0x008fce0003fbd000ULL,
0x00000028008d7306ULL, 0x000fec0000009400ULL, 0x00000001bebe5812ULL, 0x000fe400078efcffULL,
0x0000002800907306ULL, 0x000ea20000005400ULL, 0x000000afae00720bULL, 0x002fce0003fdd000ULL,
0x0000002800527306ULL, 0x0003ec000000d400ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x0000003600577306ULL, 0x000762000000d400ULL, 0x0000010028287824ULL, 0x002fe200078e00ffULL,
0x000000908d00720bULL, 0x004fc40003fbd000ULL, 0x000000c4008d7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc77819ULL, 0x000fe20000011428ULL, 0x0001000029287824ULL, 0x000fe200078e00ffULL,
0x0000008400967306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x008fe200078e00ffULL,
0x0000009100907245ULL, 0x000fe4000020d400ULL, 0x00000018ffca7819ULL, 0x000fe40000011428ULL,
0x00000018ffbb7819ULL, 0x000fe20000011436ULL, 0x0000010033367824ULL, 0x000fe200078e00ffULL,
0x0000008400937306ULL, 0x0002a20000205400ULL, 0x0000000157572812ULL, 0x020fc400078efcffULL,
0x0000000152525812ULL, 0x000fe400078efcffULL, 0x000000bb00b97245ULL, 0x000fe4000020d400ULL,
0x000000423d287211ULL, 0x000fe200078fe0ffULL, 0x0000003000957306ULL, 0x000fe20000009400ULL,
0x0000008400847245ULL, 0x002fe4000020d400ULL, 0x0000000228717810ULL, 0x040fe40007ffe0ffULL,
0x0000000728287812ULL, 0x000fc400078e78ccULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x00000030009a7306ULL, 0x000e620000005400ULL, 0x000000939600720bULL, 0x004fe20003f5d000ULL,
0x00000020cc287824ULL, 0x000fe200078e0228ULL, 0x0000000771717812ULL, 0x000fe400078e78ccULL,
0x00000057b8b8723eULL, 0x000fe200000010ffULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x000000a3a0a3723eULL, 0x000fe200000010ffULL, 0x000000b300b47306ULL, 0x000fe20000209400ULL,
0x00000020cc717824ULL, 0x000fe200078e0271ULL, 0x0000000442427810ULL, 0x000fc80007ffe0ffULL,
0x0000000184842812ULL, 0x000fe400078efcffULL, 0x000000b300b57306ULL, 0x000ea20000205400ULL,
0x0000009a9500720bULL, 0x002fe40003f3d000ULL, 0x0000009f009a7245ULL, 0x000fe2000020d400ULL,
0x000001002b9f7824ULL, 0x000fc600078e00ffULL, 0x000000019a9a4812ULL, 0x000fe200078efcffULL,
0x0000009400997306ULL, 0x000fe20000209400ULL, 0x00000018ff9f7819ULL, 0x000fce000001149fULL,
0x00000094009c7306ULL, 0x0002e20000205400ULL, 0x000000b5b400720bULL, 0x004fce0003f7d000ULL,
0x00000037009e7306ULL, 0x000fe20000009400ULL, 0x0000009400947245ULL, 0x002fce000020d400ULL,
0x00000037009b7306ULL, 0x000e620000005400ULL, 0x0000009c9900720bULL, 0x008fe20003f9d000ULL,
0x000100002b997824ULL, 0x000fca00078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x00000029008b7306ULL, 0x000fec0000009400ULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x0000002900887306ULL, 0x000fe20000005400ULL, 0x0000009b9e00720bULL, 0x002fc40003fdd000ULL,
0x000000b3009b7245ULL, 0x000fc8000020d400ULL, 0x000000019b9b3812ULL, 0x000fe200078efcffULL,
0x00000029004d7306ULL, 0x000fe6000000d400ULL, 0x0000009b9a5b723eULL, 0x000fca00000010ffULL,
0x000000ca00a67306ULL, 0x000ff00000209400ULL, 0x000000ca00297306ULL, 0x0002b00000205400ULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x002fce000020d400ULL,
0x000000bb00bd7306ULL, 0x000e620000205400ULL, 0x00000029a600720bULL, 0x004fce0003f5d000ULL,
0x0000003700537306ULL, 0x0004ec000000d400ULL, 0x00000001caca2812ULL, 0x000fe400078efcffULL,
0x000000c400c57306ULL, 0x000fe20000209400ULL, 0x0000010037377824ULL, 0x004fe200078e00ffULL,
0x000000bdbc00720bULL, 0x002fc80003f7d000ULL, 0x00000018ffc17819ULL, 0x000fe20000011437ULL,
0x0001000033377824ULL, 0x000fe200078e00ffULL, 0x000000c400c67306ULL, 0x000e620000205400ULL,
0x0000000153536812ULL, 0x008fe400078efcffULL, 0x000000c100bf7245ULL, 0x000fe4000020d400ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x00000001b9b93812ULL, 0x000fe200078efcffULL,
0x000000a800a77306ULL, 0x000fe20000209400ULL, 0x00000053bebe723eULL, 0x000fc400000010ffULL,
0x000000b994b9723eULL, 0x000fca00000010ffULL, 0x000000a800aa7306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fce0003f9d000ULL, 0x0000009d00a57306ULL, 0x000fec0000209400ULL,
0x000000018d8d4812ULL, 0x000fe400078efcffULL, 0x0000009d00a47306ULL, 0x000e620000205400ULL,
0x000000aaa700720bULL, 0x004fe40003fbd000ULL, 0x000000888b00720bULL, 0x000fc40003f9d000ULL,
0x0000009d00887245ULL, 0x000fe4000020d400ULL, 0x000000528d52723eULL, 0x000fe200000010ffULL,
0x000000a9009e7306ULL, 0x000fec0000209400ULL, 0x00000001cbcb5812ULL, 0x000fe400078efcffULL,
0x000000a900957306ULL, 0x000ea20000205400ULL, 0x000000a4a500720bULL, 0x002fc40003fdd000ULL,
0x000000014d4d4812ULL, 0x000fc800078efcffULL, 0x0000004dcaca723eULL, 0x000fe200000010ffULL,
0x000000c100c27306ULL, 0x000fec0000209400ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x000000c100c37306ULL, 0x000e620000205400ULL, 0x000000959e00720bULL, 0x004fce0003f5d000ULL,
0x0000008e00927306ULL, 0x000ff00000209400ULL, 0x0000008e008f7306ULL, 0x0004e20000205400ULL,
0x000000c3c200720bULL, 0x002fce0003f7d000ULL, 0x0000002b00757306ULL, 0x000fe20000009400ULL,
0x0000008e008e7245ULL, 0x004fca000020d400ULL, 0x00000001bfbf3812ULL, 0x000fe400078efcffULL,
0x0000002b00767306ULL, 0x000e620000005400ULL, 0x0000008f9200720bULL, 0x008fe40003fbd000ULL,
0x000000a900927245ULL, 0x000fe4000020d400ULL, 0x000000bf84bf723eULL, 0x000fe400000010ffULL,
0x0000000192922812ULL, 0x000fe200078efcffULL, 0x0000009100977306ULL, 0x000fec0000209400ULL,
0x000000018e8e5812ULL, 0x000fc400078efcffULL, 0x0000009100987306ULL, 0x000ea20000205400ULL,
0x000000767500720bULL, 0x002fe40003f5d000ULL, 0x0000007700767245ULL, 0x000fca000020d400ULL,
0x000000c700c87306ULL, 0x000ff00000209400ULL, 0x000000c700c97306ULL, 0x0002e20000205400ULL,
0x000000989700720bULL, 0x004fce0003fdd000ULL, 0x0000002a007d7306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x002fca000020d400ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x0000002a007e7306ULL, 0x000e620000005400ULL, 0x000000c9c800720bULL, 0x008fe40003f7d000ULL,
0x000000cb90cb723eULL, 0x000fca00000010ffULL, 0x0000002a004b7306ULL, 0x0004ec000000d400ULL,
0x00000001c7c73812ULL, 0x000fe400078efcffULL, 0x0000002b004a7306ULL, 0x000f62000000d400ULL,
0x000001002a2a7824ULL, 0x004fe200078e00ffULL, 0x0000007e7d00720bULL, 0x002fc40003f7d000ULL,
0x000000c78853723eULL, 0x000fe400000010ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000007700877306ULL, 0x000fe20000209400ULL, 0x00000018ff7d7819ULL, 0x010fcc000001142eULL,
0x000000014b4b3812ULL, 0x008fe200078efcffULL, 0x00000077008a7306ULL, 0x0002a20000205400ULL,
0x000000014a4a2812ULL, 0x020fe400078efcffULL, 0x0000004b9292723eULL, 0x000fca00000010ffULL,
0x0000009900937306ULL, 0x000fe20000209400ULL, 0x0000007c00777245ULL, 0x002fce000020d400ULL,
0x00000099009c7306ULL, 0x0002e20000205400ULL, 0x0000008a8700720bULL, 0x004fce0003f5d000ULL,
0x0000002a002b7306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x0000000176762812ULL, 0x000fe400078efcffULL, 0x0000002a00967306ULL, 0x000e620000205400ULL,
0x0000009c9300720bULL, 0x008fe40003fdd000ULL, 0x0000002a00937245ULL, 0x000fca000020d400ULL,
0x0000006200637306ULL, 0x000fec0000209400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x0000006200667306ULL, 0x0004e20000205400ULL, 0x000000962b00720bULL, 0x002fe40003f9d000ULL,
0x0000004a994a723eULL, 0x000fca00000010ffULL, 0x0000008300897306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fca000020d400ULL, 0x0000000193934812ULL, 0x000fe400078efcffULL,
0x00000083008c7306ULL, 0x000e620000205400ULL, 0x000000666300720bULL, 0x008fe40003f5d000ULL,
0x000000938e93723eULL, 0x000fca00000010ffULL, 0x0000009f00297306ULL, 0x000fec0000209400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x0000009f00987306ULL, 0x0004e20000205400ULL,
0x0000008c8900720bULL, 0x002fce0003fdd000ULL, 0x0000003000457306ULL, 0x000322000000d400ULL,
0x0000009f009f7245ULL, 0x004fce000020d400ULL, 0x0000007a007b7306ULL, 0x000fe20000209400ULL,
0x000000982900720bULL, 0x008fe40003f7d000ULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x00000018ff307819ULL, 0x002fc8000001142cULL, 0x0000007a00807306ULL, 0x000e620000205400ULL,
0x0000000145451812ULL, 0x010fc800078efcffULL, 0x000000457676723eULL, 0x000fe400000010ffULL,
0x000000019f9f3812ULL, 0x000fe200078efcffULL, 0x00000031006f7306ULL, 0x000ff00000009400ULL,
0x0000003100707306ULL, 0x000ee20000005400ULL, 0x000000807b00720bULL, 0x002fe20003f3d000ULL,
0x000100002d7b7824ULL, 0x000fc400078e00ffULL, 0x000001002e807824ULL, 0x000fc600078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x00000033005e7306ULL, 0x000fe20000009400ULL,
0x00000018ff807819ULL, 0x000fce0000011480ULL, 0x00000033005f7306ULL, 0x000e620000005400ULL,
0x000000706f00720bULL, 0x008fe40003f9d000ULL, 0x0000008300707245ULL, 0x000fe2000020d400ULL,
0x0000005a281c723cULL, 0x044fe2000004181cULL, 0x00000018ff6f7819ULL, 0x000fe4000001142fULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x0000006000647306ULL, 0x000fe60000209400ULL,
0x0000009f704b723eULL, 0x000fe200000010ffULL, 0x000000a22814723cULL, 0x000fe80000041814ULL,
0x0000006000617306ULL, 0x0004e20000205400ULL, 0x0000005f5e00720bULL, 0x002fc40003fdd000ULL,
0x0000007a005f7245ULL, 0x000fe2000020d400ULL, 0x000000b82820723cULL, 0x000fe60000041820ULL,
0x000000015f5f1812ULL, 0x000fe200078efcffULL, 0x0000007c00867306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x004fc6000020d400ULL, 0x000000be2818723cULL, 0x000fe80000041818ULL,
0x0000007c00857306ULL, 0x0002a20000205400ULL, 0x000000616400720bULL, 0x008fc60003f5d000ULL,
0x000000522810723cULL, 0x000fe80000041810ULL, 0x0000005600687306ULL, 0x000fe20000209400ULL,
0x000100002e7c7824ULL, 0x002fc600078e00ffULL, 0x000000ca280c723cULL, 0x040fe4000004180cULL,
0x0000000160602812ULL, 0x000fe400078efcffULL, 0x0000005600657306ULL, 0x0002e20000205400ULL,
0x000000858600720bULL, 0x004fe20003f7d000ULL, 0x000100002c857824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000000922808723cULL, 0x000fe60000041808ULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000006900737306ULL, 0x000fe20000209400ULL,
0x0000005600567245ULL, 0x002fc6000020d400ULL, 0x0000004a2804723cULL, 0x000fe40000041804ULL,
0x0000000177773812ULL, 0x000fe400078efcffULL, 0x0000006900747306ULL, 0x000e620000205400ULL,
0x000000656800720bULL, 0x008fe40003f3d000ULL, 0x0000007c00297245ULL, 0x000fe4000020d400ULL,
0x000000776277723eULL, 0x000fc600000010ffULL, 0x0000007f00817306ULL, 0x000fec0000209400ULL,
0x0000000156561812ULL, 0x000fe400078efcffULL, 0x0000007f00827306ULL, 0x0004e20000205400ULL,
0x000000747300720bULL, 0x002fe40003f5d000ULL, 0x0000006900737245ULL, 0x000fca000020d400ULL,
0x00000032006e7306ULL, 0x000fe20000009400ULL, 0x0000007f007f7245ULL, 0x004fca000020d400ULL,
0x0000000173732812ULL, 0x000fe400078efcffULL, 0x00000032006d7306ULL, 0x000e620000005400ULL,
0x000000828100720bULL, 0x008fe20003f7d000ULL, 0x000100002f817824ULL, 0x040fe200078e00ffULL,
0x000000735673723eULL, 0x000fe200000010ffULL, 0x000001002f827824ULL, 0x000fc600078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x00000036005c7306ULL, 0x000fe20000209400ULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x00000081002a7245ULL, 0x000fc6000020d400ULL,
0x000000017f7f3812ULL, 0x000fe400078efcffULL, 0x00000036005d7306ULL, 0x000ea20000205400ULL,
0x0000006d6e00720bULL, 0x002fe40003fbd000ULL, 0x0000007f6045723eULL, 0x000fca00000010ffULL,
0x0000002d00557306ULL, 0x000ff00000009400ULL, 0x0000002d00547306ULL, 0x000e620000005400ULL,
0x0000005d5c00720bULL, 0x004fce0003f3d000ULL, 0x0000007200787306ULL, 0x000ff00000209400ULL,
0x0000007200797306ULL, 0x0004e20000205400ULL, 0x000000545500720bULL, 0x002fe40003f5d000ULL,
0x0000003600557245ULL, 0x000fc4000020d400ULL, 0x0000003700547245ULL, 0x000fe4000020d400ULL,
0x0000000155551812ULL, 0x000fe200078efcffULL, 0x0000003100447306ULL, 0x000322000000d400ULL,
0x0000007200727245ULL, 0x004fe4000020d400ULL, 0x0000008500367245ULL, 0x000fca000020d400ULL,
0x0000003200437306ULL, 0x000ea2000000d400ULL, 0x000000797800720bULL, 0x008fe40003f7d000ULL,
0x00000018ff317819ULL, 0x002fca000001142dULL, 0x0000004c00677306ULL, 0x000fe20000209400ULL,
0x0000000144444812ULL, 0x010fc800078efcffULL, 0x000000445f44723eULL, 0x000fe400000010ffULL,
0x0000000172723812ULL, 0x000fe200078efcffULL, 0x0000004c006a7306ULL, 0x0002e20000205400ULL,
0x0000000143435812ULL, 0x004fc800078efcffULL, 0x000000437272723eULL, 0x000fc600000010ffULL,
0x00000037006b7306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x002fce000020d400ULL,
0x00000037006c7306ULL, 0x000e620000205400ULL, 0x0000006a6700720bULL, 0x008fce0003f9d000ULL,
0x00000085005e7306ULL, 0x000fec0000209400ULL, 0x000000014c4c4812ULL, 0x000fe400078efcffULL,
0x0000008500637306ULL, 0x000ea20000205400ULL, 0x0000006c6b00720bULL, 0x002fe40003fbd000ULL,
0x000000554c55723eULL, 0x000fca00000010ffULL, 0x0000002c00597306ULL, 0x000fec0000009400ULL,
0x0000000154545812ULL, 0x000fe400078efcffULL, 0x0000002c00587306ULL, 0x000e620000005400ULL,
0x000000635e00720bULL, 0x004fce0003f3d000ULL, 0x0000002c00497306ULL, 0x0004ec000000d400ULL,
0x0000000136361812ULL, 0x000fe400078efcffULL, 0x0000002e004f7306ULL, 0x000fe20000009400ULL,
0x000001002c2c7824ULL, 0x004fe200078e00ffULL, 0x000000585900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff667819ULL, 0x000fe2000001142cULL, 0x00000010712c7824ULL, 0x000fe200078e00ffULL,
0x0000002e004e7306ULL, 0x000e640000005400ULL, 0x0000006600377245ULL, 0x000fca000020d400ULL,
0x0000000149493812ULL, 0x008fe200078efcffULL, 0x00000066007a7306ULL, 0x000fe60000209400ULL,
0x000000493636723eULL, 0x000fca00000010ffULL, 0x0000006600617306ULL, 0x000ea20000205400ULL,
0x0000004e4f00720bULL, 0x002fce0003fbd000ULL, 0x0000003000347306ULL, 0x000ff00000209400ULL,
0x0000003000357306ULL, 0x0002e20000205400ULL, 0x000000617a00720bULL, 0x004fce0003f9d000ULL,
0x0000002d00487306ULL, 0x000522000000d400ULL, 0x0000003000307245ULL, 0x002fca000020d400ULL,
0x0000000137374812ULL, 0x000fe400078efcffULL, 0x0000003300417306ULL, 0x000e62000000d400ULL,
0x000001002d2d7824ULL, 0x004fe200078e00ffULL, 0x000000353400720bULL, 0x008fc80003f3d000ULL,
0x00000018ff5a7819ULL, 0x000fe4000001142dULL, 0x0000002f00517306ULL, 0x000fe20000009400ULL,
0x0000000148482812ULL, 0x010fcc00078efcffULL, 0x0000000130301812ULL, 0x000fe200078efcffULL,
0x0000002f00507306ULL, 0x000ea20000005400ULL, 0x0000000141416812ULL, 0x002fe400078efcffULL,
0x000000373037723eULL, 0x000fe400000010ffULL, 0x0000006f00307245ULL, 0x000fe4000020d400ULL,
0x000000415454723eULL, 0x000fe200000010ffULL, 0x0000003100327306ULL, 0x000ff00000209400ULL,
0x0000003100337306ULL, 0x0002e20000205400ULL, 0x000000505100720bULL, 0x004fce0003fdd000ULL,
0x0000005a00587306ULL, 0x000fe20000209400ULL, 0x0000003100317245ULL, 0x002fce000020d400ULL,
0x0000005a00597306ULL, 0x0002a20000205400ULL, 0x000000333200720bULL, 0x008fce0003f9d000ULL,
0x0000007b00647306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x002fca000020d400ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x0000007b00577306ULL, 0x0002e20000205400ULL,
0x000000595800720bULL, 0x004fce0003f3d000ULL, 0x0000007c005b7306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x0000007c004e7306ULL, 0x000e620000205400ULL, 0x000000576400720bULL, 0x008fe40003f7d000ULL,
0x0000005a3149723eULL, 0x000fca00000010ffULL, 0x0000006f006d7306ULL, 0x000fec0000209400ULL,
0x000000017b7b3812ULL, 0x000fe400078efcffULL, 0x0000006f006e7306ULL, 0x000ea20000205400ULL,
0x0000004e5b00720bULL, 0x002fe40003f5d000ULL, 0x000000487b48723eULL, 0x000fca00000010ffULL,
0x0000002e00467306ULL, 0x000e6c000000d400ULL, 0x0000000129292812ULL, 0x000fe400078efcffULL,
0x0000002f00477306ULL, 0x000722000000d400ULL, 0x0000006e6d00720bULL, 0x004fce0003f3d000ULL,
0x0000007d007e7306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x008ea20000000200ULL,
0x0000000146465812ULL, 0x002fc800078efcffULL, 0x0000000130301812ULL, 0x000fe400078efcffULL,
0x0000007d00757306ULL, 0x0002e20000205400ULL, 0x000000044000780cULL, 0x000fe40003f25270ULL,
0x0000000147476812ULL, 0x010fca00078efcffULL, 0x00000080004d7306ULL, 0x000fe20000209400ULL,
0x0000007d007d7245ULL, 0x002fce000020d400ULL, 0x0000008000507306ULL, 0x0003220000205400ULL,
0x000000757e00720bULL, 0x008fce0003f7d000ULL, 0x0000008100347306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x00000081002b7306ULL, 0x000e620000205400ULL, 0x000000504d00720bULL, 0x010fe20003f9d000ULL,
0x000000762c14723cULL, 0x044fec0000041814ULL, 0x0000008200287306ULL, 0x000fe40000209400ULL,
0x000000442c1c723cULL, 0x000fe8000004181cULL, 0x0000000180804812ULL, 0x000fc400078efcffULL,
0x0000008200337306ULL, 0x000ea20000205400ULL, 0x0000002b3400720bULL, 0x002fe20003f5d000ULL,
0x000000722c20723cULL, 0x000fe20000041820ULL, 0x00000082002b7245ULL, 0x000fce000020d400ULL,
0x000000542c18723cULL, 0x040fe80000041818ULL, 0x000000012a2a2812ULL, 0x000fe400078efcffULL,
0x000000332800720bULL, 0x004fe40003fbd000ULL, 0x000000462928723eULL, 0x000fe200000010ffULL,
0x000000362c10723cULL, 0x000fe20000041810ULL, 0x000000807d29723eULL, 0x000fc400000010ffULL,
0x000000472a2a723eULL, 0x000fca00000010ffULL, 0x000000482c0c723cULL, 0x000fe4000004180cULL,
0x000000012b2b5812ULL, 0x000fc800078efcffULL, 0x0000002b302b723eULL, 0x000fe400000010ffULL,
0x000000282c08723cULL, 0x040ff00000041808ULL, 0x0000002a2c04723cULL, 0x000fe20000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd5f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x010614003a297984ULL, 0x000e620000000800ULL,
0x0000ffff38007812ULL, 0x000fe200078ec0ffULL, 0x0000001d3c1d7220ULL, 0x040fe20000410000ULL,
0x0000001e3c1e7220ULL, 0x040fe20000410000ULL, 0x000000143c147220ULL, 0x000fe20000410000ULL,
0x0000888000337816ULL, 0x000fe200000000ffULL, 0x000000153c157220ULL, 0x040fe20000410000ULL,
0x0000001f3c1f7220ULL, 0x040fe20000410000ULL, 0x0000001a3c2b7220ULL, 0x040fe20000410000ULL,
0x0000001b3c2c7220ULL, 0x040fe20000410000ULL, 0x000000163c287220ULL, 0x040fe20000410000ULL,
0x000000173c2a7220ULL, 0x040fe20000410000ULL, 0x000000203c207220ULL, 0x040fe20000410000ULL,
0x000000213c217220ULL, 0x040fe20000410000ULL, 0x000000223c227220ULL, 0x040fe20000410000ULL,
0x0000000c3c1a7220ULL, 0x040fe20000410000ULL, 0x0000000d3c1b7220ULL, 0x040fe20000410000ULL,
0x8000000033007824ULL, 0x000fe200078e00ffULL, 0x000000233c237220ULL, 0x040fe20000410000ULL,
0x000000183c187220ULL, 0x040fe20000410000ULL, 0x000000193c197220ULL, 0x040fe20000410000ULL,
0x000000103c167220ULL, 0x040fe20000410000ULL, 0x000000113c177220ULL, 0x040fe20000410000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e001dULL, 0x0000001c3c1c7220ULL, 0x040fe20000410000ULL,
0x000000123c2d7220ULL, 0x040fe20000410000ULL, 0x000000133c2e7220ULL, 0x040fe20000410000ULL,
0x0000000e3c2f7220ULL, 0x040fe20000410000ULL, 0x0000000f3c307220ULL, 0x040fe20000410000ULL,
0x000000083c087220ULL, 0x040fe20000410000ULL, 0x000000093c097220ULL, 0x040fe20000410000ULL,
0x0000000a3c317220ULL, 0x040fe20000410000ULL, 0x0000000b3c327220ULL, 0x040fe20000410000ULL,
0x000000043c047220ULL, 0x040fe20000410000ULL, 0x000000053c057220ULL, 0x040fe20000410000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e001eULL, 0x000000063c067220ULL, 0x040fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0014ULL, 0x000000073c077220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0015ULL, 0x8000000029ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff1e7224ULL, 0x000fc400078e001fULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff147224ULL, 0x000fe400078e001aULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x000000ffff1f7224ULL, 0x000fe400078e0022ULL,
0x000000ffff107224ULL, 0x000fc400078e0018ULL, 0x000000ffff117224ULL, 0x000fe400078e0019ULL,
0x000000ffff127224ULL, 0x000fe400078e0016ULL, 0x000000ffff137224ULL, 0x000fe400078e0017ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0028ULL, 0x000000ffff1b7224ULL, 0x000fe400078e002aULL,
0x000000ffff207224ULL, 0x000fc400078e0023ULL, 0x000000ffff217224ULL, 0x000fe400078e002bULL,
0x000000ffff227224ULL, 0x000fe400078e002cULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff167224ULL, 0x000fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fc400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff237224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0031ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0032ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0007ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000033337824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x010614003a047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc40007804833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000043d1c7824ULL, 0x000fe200078e00ffULL,
0x0000003b2400720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008002007824ULL, 0x000fca00078e0205ULL,
0x0104000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000023d087824ULL, 0x000fe400078e00ffULL, 0x00000001033e7824ULL, 0x000fc600078e0a3eULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x00000001092f7812ULL, 0x040fe400078efcffULL,
0x0000000809317812ULL, 0x000fe400078efcffULL, 0x0000003e2f00720cULL, 0x080fe40003f26070ULL,
0x00000010092f7812ULL, 0x000fe400078efcffULL, 0x0000003e3100720cULL, 0x080fe40003f06070ULL,
0x0000003e2f00720cULL, 0x000fc40003fc6070ULL, 0x0000001109317812ULL, 0x040fe400078efcffULL,
0x00000018092f7812ULL, 0x040fe400078efcffULL, 0x0000003e0900720cULL, 0x080fe40003f46070ULL,
0x0000003e3100720cULL, 0x080fe40003fa6070ULL, 0x0000003e2f00720cULL, 0x000fe40003f66070ULL,
0x0000000909337812ULL, 0x000fc400078efcffULL, 0x0000001909317812ULL, 0x040fe400078efcffULL,
0x00000020092f7812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000003e3300720cULL, 0x080fe40003f86070ULL,
0x0000003e3100720cULL, 0x080fe40003f46070ULL, 0x0000003e2f00720cULL, 0x000fe40003f26070ULL,
0x0000002109317812ULL, 0x040fe400078efcffULL, 0x00000028092f7812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000003e3100720cULL, 0x080fe40003f06070ULL, 0x0000003e2f00720cULL, 0x000fe40003f86070ULL,
0x0000002909317812ULL, 0x000fc400078efcffULL, 0x00000030092f7812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000003e3100720cULL, 0x000fc40003fc6070ULL, 0x0000003e2f00720cULL, 0x000fe40003fa6070ULL,
0x0000003109317812ULL, 0x040fe400078efcffULL, 0x00000038092f7812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000003e3100720cULL, 0x080fe40003f66070ULL,
0x0000003e2f00720cULL, 0x000fc40003f46070ULL, 0x0000003e0900720cULL, 0x000fe40003f26070ULL,
0xff7fffff28287808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff2a2a7808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff2d2d7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff367424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000002a05047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002b04057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002c05047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002d04057209ULL, 0x000fe40007810000ULL, 0x0000001908317209ULL, 0x000fe40007810000ULL,
0x0000002e05337209ULL, 0x000fe20007810000ULL, 0x00000dc27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0031047f89ULL, 0x0004e400000e0000ULL, 0x0000000431317209ULL, 0x00cfe20007810000ULL,
0x00000df27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0033047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007307f89ULL, 0x000f2200000e0000ULL,
0x0000000433087209ULL, 0x004fc60007810000ULL, 0x0c201f0031047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000003007307209ULL, 0x010fc60007810000ULL, 0x0c201f0009327f89ULL, 0x002e6800000e0000ULL,
0x0c201f00302f7f89ULL, 0x00092200000e0000ULL, 0x0000000431047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000003209067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x00000004ff327e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3f8000003232783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL, 0x000000ffff337224ULL, 0x000fe200078e0032ULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2e197823ULL, 0x000fe20000010819ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x0007f00000000800ULL, 0x0000001e001e7308ULL, 0x000f620000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000010ffULL, 0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x020fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x000000320834723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000320c34723cULL, 0x000fee0000041834ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe400000010ffULL, 0xfffffffc3d147812ULL, 0x000fc800078ec0ffULL,
0x000000141d1d7219ULL, 0x000fe200000006ffULL, 0x0000002900297308ULL, 0x000fe60000000800ULL,
0x000000001d1e73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f680000004000ULL,
0x0000002a002a7308ULL, 0x000f220000000800ULL, 0x000000232811723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000292a13723eULL, 0x010fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000051dff7c12ULL, 0x008fe2000f80401eULL,
0x000000321034723cULL, 0x000fec0000041834ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ee20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x008fe400000010ffULL, 0x000000302f077209ULL, 0x004fca0007810000ULL,
0x0000002d002d7308ULL, 0x000ff00000000800ULL, 0x00000019001a7308ULL, 0x000ea20000000800ULL,
0x0000002b2c15723eULL, 0x002fe400000010ffULL, 0x0000002d1a17723eULL, 0x004fce00000010ffULL,
0x000000321434723cULL, 0x000fe20000041834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000090204008947ULL, 0x020fde000b800000ULL, 0x001c1fff34187589ULL, 0x0002a400000e0000ULL,
0x000000001d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000051dff7c12ULL, 0x008fda000f80401aULL,
0x0000091204008947ULL, 0x010fea000b800000ULL, 0x001c1fff36197589ULL, 0x00072800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL, 0x001c1fff001b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x00afe4000001163dULL, 0x0000000c1c377812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x000000033dff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d327824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d487824ULL, 0x000fe200078e00ffULL,
0x000000021f287812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f2a7812ULL, 0x000fc400078ef61eULL, 0x000000041f2c7812ULL, 0x140fe400078ef61eULL,
0x000000051f2e7812ULL, 0x140fe400078ef61eULL, 0x000000061f307812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x0000a000021d7811ULL, 0x000fe400078e58ffULL, 0xfffffff823347812ULL, 0x100fe400078ee21eULL,
0x000000011f367812ULL, 0x140fe200078ef61eULL, 0x00000010201c7824ULL, 0x000fe200078e021dULL,
0xfffffff848487812ULL, 0x000fe200078ee221ULL, 0x0000001028207824ULL, 0x100fe200078e021dULL,
0x000000021f3e7812ULL, 0x140fe200078ef61eULL, 0x000000102c287824ULL, 0x100fe200078e021dULL,
0x000000031f407812ULL, 0x140fe200078ef61eULL, 0x00000010302c7824ULL, 0x100fe200078e021dULL,
0x000000041f427812ULL, 0x140fe200078ef61eULL, 0x0000001036307824ULL, 0x100fe200078e021dULL,
0x000000051f447812ULL, 0x140fe200078ef61eULL, 0x000000103e317824ULL, 0x100fe200078e021dULL,
0x000000061f467812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x000000102a227824ULL, 0x100fe400078e021dULL, 0x000000102e2a7824ULL, 0x100fe400078e021dULL,
0x00000001371f7824ULL, 0x000fe400078e021cULL, 0x00000010322e7824ULL, 0x100fe400078e021dULL,
0x00000010341c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x0000001040327824ULL, 0x000fc400078e021dULL, 0x0000001042337824ULL, 0x100fe400078e021dULL,
0x0000001044347824ULL, 0x100fe400078e021dULL, 0x0000001046357824ULL, 0x100fe400078e021dULL,
0x0000001048367824ULL, 0x000fe400078e021dULL, 0x00000001371d7824ULL, 0x040fe400078e021eULL,
0x0000000137217824ULL, 0x000fc400078e0220ULL, 0x0000000137237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000137297824ULL, 0x040fe400078e0228ULL,
0x00000001372b7824ULL, 0x040fe200078e022aULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x00000001372d7824ULL, 0x040fe400078e022cULL, 0x00000001372f7824ULL, 0x040fe200078e022eULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x00000001371c7824ULL, 0x000fc400078e021cULL,
0x0000000137307824ULL, 0x040fe200078e0230ULL, 0x0000001029007388ULL, 0x0007e20000000800ULL,
0x00000001371e7824ULL, 0x040fe400078e0231ULL, 0x0000000137327824ULL, 0x040fe200078e0232ULL,
0x000000122b007388ULL, 0x0007e20000000800ULL, 0x0000000137087824ULL, 0x042fe400078e0233ULL,
0x0000000137347824ULL, 0x040fe200078e0234ULL, 0x000000142d007388ULL, 0x0007e20000000800ULL,
0x0000000137207824ULL, 0x000fc400078e0235ULL, 0x0000000137367824ULL, 0x000fe200078e0236ULL,
0x000000162f007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b30007388ULL, 0x0007e80000000800ULL, 0x0000000d1e007388ULL, 0x0007e80000000800ULL,
0x0000000f32007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x0000001334007388ULL, 0x0007e80000000800ULL, 0x0000001520007388ULL, 0x0007e80000000800ULL,
0x0000001736007388ULL, 0x0007e80000000800ULL, 0x0100000400008388ULL, 0x0007e80000000c00ULL,
0x0102001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030024247a10ULL, 0x000fe20007ffe0ffULL, 0x010608003aff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff38ff7812ULL, 0x000fc4000780c0ffULL, 0x000000252400720cULL, 0x000fe40003f26070ULL,
0x00000001ff387807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffbae000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0031ULL, 0x0001cf8000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fe400078e00ffULL, 0x0000055000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002fULL, 0xfffff1f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2f7224ULL, 0x000fe200078e0033ULL, 0x0001cfe000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x000004f000007944ULL, 0x000fea0003c00000ULL,
0x0000002f33347209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0006ULL,
0x0001d03000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fe400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000002f06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0007ULL, 0x0001d08000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fc400078e00ffULL, 0x0000045000007944ULL, 0x000fea0003c00000ULL,
0x0000002f07307209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0031ULL,
0x0001d0d000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x0000002f31047209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0034ULL, 0x0001d12000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000002f34057209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0006ULL,
0x0001d17000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x0000002f06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0030ULL, 0x0001d1c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0xfffff0b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0034ULL,
0x0001d220001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fc400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e001bULL, 0xfffff6a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x002fe200078e0036ULL, 0x0001d290001e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff217224ULL, 0x000fe400078e00ffULL, 0x00001c1fff227424ULL, 0x000fe400078e00ffULL,
0x0000028000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff217224ULL, 0x002fe200078e00ffULL,
0x0001d2e0001e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x004fe400078e001bULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x002fe200078e00ffULL, 0x0001d330001e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff227424ULL, 0x000fc400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e001bULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0xfffff62000007947ULL, 0x000fea000383ffffULL,
0x0180000039047810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000004057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003900048308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff047807ULL, 0x004fc80004000000ULL,
0x0000000405ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff39ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000405ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000039057812ULL, 0x000fd600078ec0ffULL,
0x0080000005040812ULL, 0x000fe200078efcffULL, 0x000000ffff048224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003900047308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x00cfe400078e0004ULL,
0x000000ffff047224ULL, 0x000fe400078e0009ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe2b3004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c0000322f2f7389ULL, 0x0002a200000e0035ULL,
0xfffe2af008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000001d00007348ULL, 0x000fe80003800000ULL, 0x00000021201b7389ULL, 0x0002a200000e0022ULL,
0xfffe2ab01e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000218ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007b0ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000828ULL, 0x00000000000008e8ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001110ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001130ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001140ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001160ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011d0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011d8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011e8ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001400ULL, 0x000000000001d600ULL, 0xf100001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001ea00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001ea10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001ea10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001ee90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000011d0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001d830ULL, 0x000000000001d830ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001ea00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001ee90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_89_cubin_len = 126832;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
