/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000020510ULL, 0x0000000000020090ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x000000000001ec10ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x000000000001ed80ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x000000000001edc0ULL, 0x0000000000000140ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x000000000001ef00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001ec1000000000ULL, 0x0000040400000000ULL, 0x810c000000100400ULL, 0x007ae80430288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80809a0828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880809a92ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001ec1000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80809a0828808081ULL, 0x80162880808c0828ULL, 0x0000000310288082ULL, 0x808c920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001ed8000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x9e082880809a0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809e920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x0001edc000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000ffULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000003000000011ULL, 0x0000001100081104ULL, 0x0008120400000030ULL,
0x0000003000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000dULL,
0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0001daa000183104ULL, 0x0001df400001df30ULL, 0x0001e0c00001e0b0ULL,
0x00e829040001e0d0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002405000024ULL, 0x0500002405000024ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000a000e82804ULL, 0x00001cf000000100ULL,
0x00001e0000001d80ULL, 0x0000390000001e30ULL, 0x00006a8000003a70ULL, 0x00006bb000006b00ULL,
0x0000837000006bd0ULL, 0x0000b540000083b0ULL, 0x0000b6600000b5c0ULL, 0x0000d0a00000b690ULL,
0x000100100000d130ULL, 0x0001014000010090ULL, 0x00012ce000010160ULL, 0x000143c000012cf0ULL,
0x00014b50000143d0ULL, 0x00016b0000016900ULL, 0x00016ff000016fc0ULL, 0x0001d95000017830ULL,
0x0001d9900001d980ULL, 0x0001d9c00001d9a0ULL, 0x0001da000001d9e0ULL, 0x0001e0a00001da10ULL,
0x0001e1100001e100ULL, 0x0001e7600001e120ULL, 0x0001e8500001e7e0ULL, 0x0001e9300001e8c0ULL,
0x0001ea100001e9a0ULL, 0x0001eae00001ea80ULL, 0x0001eba00001eb50ULL, 0x03e039040001ebf0ULL,
0x000000ff00000170ULL, 0x003f01000001c600ULL, 0x0000000f000001a0ULL, 0x003f01300001c608ULL,
0x0000000f000001d0ULL, 0x003f01300001c610ULL, 0x0000000f00000230ULL, 0x003f01200001c648ULL,
0x000000ff00000240ULL, 0x003f01000001c658ULL, 0x000000ff000005b0ULL, 0x003f01070001c600ULL,
0x000000f800000820ULL, 0x003f01020001c614ULL, 0x000000f800000bf0ULL, 0x003f01010001c610ULL,
0x000000ff00000f50ULL, 0x003f01070001c648ULL, 0x000000ff00000fd0ULL, 0x003f01010001c658ULL,
0x000000ff00001130ULL, 0x003f01060001c65cULL, 0x000000ff000011e0ULL, 0x003f01060001c65cULL,
0x000000ff00001270ULL, 0x003f01060001c65cULL, 0x0000002600001a70ULL, 0x003f01070001c648ULL,
0x0000002900001ae0ULL, 0x003f01060001c64cULL, 0x000000ff00001b20ULL, 0x003f01060001c60cULL,
0x000000ff00001c20ULL, 0x003f01060001c60cULL, 0x0000002900002090ULL, 0x003f010600000004ULL,
0x0000002900002130ULL, 0x003f010600000004ULL, 0x000000ff00006070ULL, 0x003f01010001c658ULL,
0x000000ff000060e0ULL, 0x003f01010001c610ULL, 0x000000ff00006190ULL, 0x003f01060001c65cULL,
0x000000ff000061e0ULL, 0x003f01060001c65cULL, 0x000000ff00006270ULL, 0x003f01060001c65cULL,
0x0000000800006880ULL, 0x003f01070001c648ULL, 0x0000000c000068f0ULL, 0x003f01060001c64cULL,
0x000000ff00006910ULL, 0x003f01060001c61cULL, 0x000000ff00006a00ULL, 0x003f01060001c61cULL,
0x0000001200006e70ULL, 0x003f01060001c64cULL, 0x0000001200006f00ULL, 0x003f01060001c64cULL,
0x000000ff0000ab70ULL, 0x003f01010001c658ULL, 0x000000ff0000ac00ULL, 0x003f01010001c620ULL,
0x000000ff0000ac80ULL, 0x003f01060001c65cULL, 0x000000ff0000ace0ULL, 0x003f01060001c65cULL,
0x000000ff0000ad70ULL, 0x003f01060001c65cULL, 0x0000000c0000b350ULL, 0x003f01070001c648ULL,
0x000000120000b3c0ULL, 0x003f01060001c64cULL, 0x000000ff0000b3e0ULL, 0x003f01060001c62cULL,
0x000000ff0000b4c0ULL, 0x003f01060001c62cULL, 0x0000000c0000b940ULL, 0x003f01060001c64cULL,
0x000000130000ba20ULL, 0x003f010600000004ULL, 0x000000ff0000f610ULL, 0x003f01010001c658ULL,
0x000000ff0000f6a0ULL, 0x003f01010001c630ULL, 0x000000ff0000f740ULL, 0x003f01060001c65cULL,
0x000000ff0000f790ULL, 0x003f01060001c65cULL, 0x000000ff0000f820ULL, 0x003f01060001c65cULL,
0x000000120000fe20ULL, 0x003f01070001c648ULL, 0x0000000a0000fe90ULL, 0x003f01060001c64cULL,
0x000000ff0000feb0ULL, 0x003f01060001c63cULL, 0x000000ff0000ff90ULL, 0x003f01060001c63cULL,
0x0000000a00010410ULL, 0x003f01060001c64cULL, 0x0000000d00010500ULL, 0x003f010600000004ULL,
0x000000ff00014110ULL, 0x003f01010001c658ULL, 0x000000ff00014170ULL, 0x003f01010001c640ULL,
0x000000ff00019340ULL, 0x003f01060001c604ULL, 0x000000ff000193d0ULL, 0x003f01060001c604ULL,
0x000000ff00019700ULL, 0x003f01010001c600ULL, 0x000000ff00019710ULL, 0x003f01060001c604ULL,
0x000000ff00019790ULL, 0x003f01060001c604ULL, 0x000000390001cde0ULL, 0x003f01060001c614ULL,
0x000000390001d250ULL, 0x003f01060001c614ULL, 0x000000390001e6a0ULL, 0x003f01010001c608ULL,
0x00101c0400053803ULL, 0x000197e000017c70ULL, 0x0001e70000019880ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000001c4ULL, 0x0000001100000002ULL, 0x0000000000000144ULL,
0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL,
0x0000001100000002ULL, 0x000000000000019aULL, 0x0000001100000002ULL, 0x000000000000011dULL,
0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0xffffffd001017810ULL, 0x000fe20007ffe0ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x00000000000b7919ULL, 0x000ea80000002100ULL, 0x0000000000147919ULL, 0x000ee80000002700ULL,
0x0000000000157919ULL, 0x000f220000002600ULL, 0x000000010e007824ULL, 0x002fc600078e0203ULL,
0x00001fff0e0e7589ULL, 0x000e6200000e0000ULL, 0x00000080000f7824ULL, 0x104fe200078e020bULL,
0x00000005ff007819ULL, 0x000fe2000001160bULL, 0x00006000140a7625ULL, 0x008fc600078e0011ULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000030f00780cULL, 0x040fe20003f04070ULL,
0x00001fff00007589ULL, 0x000ea200000e0000ULL, 0x0000007f0f00780cULL, 0x040fe40003f24070ULL,
0x000000010f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01c60002ff00b388ULL, 0x0007e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x01c608040f008388ULL, 0x0007e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff08a424ULL, 0x000fe200078e00ffULL, 0x01c610060f008388ULL, 0x0007e2000000ca00ULL,
0x000000ff0e00720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff09a424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0cb424ULL, 0x000fe200078e00ffULL, 0x01c400100f009388ULL, 0x0007e20000004800ULL,
0x7fffff80ff0db424ULL, 0x000fc600078e00ffULL, 0x01c648080f00a388ULL, 0x0007e80000008a00ULL,
0x01c6580cff00b388ULL, 0x0007e80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003b000000947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x01ce620000000000ULL,
0x0000000400047824ULL, 0x000fc400078e00ffULL, 0x00005800ff027624ULL, 0x000fe400078e00ffULL,
0x0000001015037824ULL, 0x000fe400078e00ffULL, 0x0000001002027824ULL, 0x000fe400078e00ffULL,
0x00000200ff167424ULL, 0x000fe200078e00ffULL, 0x000000040f057211ULL, 0x002fe200078fd8ffULL,
0x0000001402047224ULL, 0x000fc600078e0203ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x00000003050d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000705027812ULL, 0x000fe400078ec0ffULL,
0x0000000707037812ULL, 0x000fe200078ec0ffULL, 0x0000000104117824ULL, 0x000fe200078e020dULL,
0x000000070d0c7812ULL, 0x000fe400078ec0ffULL, 0x0000001f02027812ULL, 0x000fc400078e780fULL,
0x0000000205097810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03067812ULL, 0x100fe200078e780fULL,
0x000000100f037824ULL, 0x000fe200078e00ffULL, 0x0000001f0c127812ULL, 0x000fe200078e780fULL,
0x00000020050c7824ULL, 0x000fe200078e0202ULL, 0x0000000709087812ULL, 0x000fe200078ec0ffULL,
0x0000000104027824ULL, 0x040fe200078e0205ULL, 0x000001f003137812ULL, 0x000fe200078ec0ffULL,
0x0000000104057824ULL, 0x000fe200078e0207ULL, 0x0000001f08087812ULL, 0x000fe200078e780fULL,
0x00005c0002027625ULL, 0x000fc800078e0016ULL, 0x00000020070f7824ULL, 0x000fe200078e0206ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x000fe400078e0209ULL,
0x00005c0005047625ULL, 0x000fc800078e0016ULL, 0x0000002009107824ULL, 0x000fe200078e0208ULL,
0x0000001304047210ULL, 0x000fe20007f3e0ffULL, 0x00005c0006067625ULL, 0x000fc800078e0016ULL,
0x00005c0011087625ULL, 0x000fc800078e0016ULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000001306067210ULL, 0x080fe20007f1e0ffULL, 0x000000200d127824ULL, 0x000fe200078e0212ULL,
0x0000001308087210ULL, 0x000fe20007f5e0ffULL, 0x000000100c0d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400000e0607ULL, 0x0000001010117824ULL, 0x000fe200078e00ffULL,
0x00000000040f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fe400010e0609ULL,
0x0000001012137824ULL, 0x000fe200078e00ffULL, 0x0000000006117faeULL, 0x0003e8000b901c46ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060a027981ULL, 0x01eea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x00000004ff037e24ULL, 0x002fe2000f8e00ffULL,
0x000000ff02047810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff047819ULL, 0x000fce0000011604ULL,
0x000175f000008947ULL, 0x000fea0003800000ULL, 0x0000000000207919ULL, 0x000e620000000000ULL,
0x0000580015067a10ULL, 0x000fe20007ffe0ffULL, 0x0000000214057824ULL, 0x000fe400078e00ffULL,
0x0000010003077824ULL, 0x000fe400078e00ffULL, 0x0000580005087a24ULL, 0x000fe200078e0206ULL,
0x0000000103057810ULL, 0x000fe20007ffe0ffULL, 0x0000001000f87824ULL, 0x000fe200078e00ffULL,
0x0000000702067217ULL, 0x000fe20007800000ULL, 0x00000003ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000040500720cULL, 0x000fe20003f06070ULL, 0x0000620008057a24ULL, 0x000fc400078e0207ULL,
0x0000000106067824ULL, 0x000fe400078e0a07ULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff147819ULL, 0x002fe20000011620ULL, 0x00000010201d7824ULL, 0x000fc800078e00ffULL,
0x00000001f8087824ULL, 0x000fc800078e0214ULL, 0x0000000105077824ULL, 0x000fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004006097807ULL, 0x000fe20000000000ULL,
0x00005e0007067625ULL, 0x000fe200078e001fULL, 0x000000f01d1d7812ULL, 0x000fe200078ec0ffULL,
0x01c6140df8ff738cULL, 0x0003e20000000000ULL, 0x00000009f8097217ULL, 0x000fe40007800000ULL,
0x0000001d060e7210ULL, 0x000fe40007f1e0ffULL, 0x00000007080a7812ULL, 0x000fe200078ec0ffULL,
0x0000000109157824ULL, 0x000fe200078e0af8ULL, 0x0000000214067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x0000000f0a0b7812ULL, 0x000fc400078e7820ULL,
0x0000000414077810ULL, 0x000fe40007ffe0ffULL, 0x000000150600720cULL, 0x080fe20003f86070ULL,
0x00000001f8067824ULL, 0x000fe200078e0206ULL, 0x0000000614097810ULL, 0x000fe20007ffe0ffULL,
0x0000001008167824ULL, 0x000fe200078e020bULL, 0x000000150700720cULL, 0x000fe20003f66070ULL,
0x00000001f8087824ULL, 0x000fe200078e0207ULL, 0x00000008140b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001f80a7824ULL, 0x000fe200078e0209ULL, 0x0000000706077812ULL, 0x000fc400078ec0ffULL,
0x000000150900720cULL, 0x080fe20003f46070ULL, 0x00000001f80c7824ULL, 0x000fe200078e020bULL,
0x0000000708097812ULL, 0x000fe400078ec0ffULL, 0x0000000f07077812ULL, 0x100fe400078e7820ULL,
0x000000150b00720cULL, 0x000fe40003f26070ULL, 0x0000000f09097812ULL, 0x000fe200078e7820ULL,
0x0000001006177824ULL, 0x000fe200078e0207ULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000105067824ULL, 0x000fe200078e0206ULL, 0x000000070c077812ULL, 0x000fe200078ec0ffULL,
0x0000001008187824ULL, 0x000fe200078e0209ULL, 0x0000000f0b0b7812ULL, 0x000fe200078e7820ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x0000000f070d7812ULL, 0x002fe200078e7820ULL,
0x00005e0006067625ULL, 0x000fc800078e001fULL, 0x000000100a197824ULL, 0x000fe200078e020bULL,
0x0000001d06107210ULL, 0x000fe20007f1e0ffULL, 0x00005e0008087625ULL, 0x000fe200078e001fULL,
0x0000000a14067810ULL, 0x000fc60007ffe0ffULL, 0x00000001050a7824ULL, 0x040fe200078e020aULL,
0x0000001d08127210ULL, 0x000fe20007fbe0ffULL, 0x000000100c1a7824ULL, 0x000fe400078e020dULL,
0x00000001050c7824ULL, 0x000fe400078e020cULL, 0x00005e000a0a7625ULL, 0x000fc800078e001fULL,
0x00005e000c0c7625ULL, 0x000fe200078e001fULL, 0x0000001d0a0a7210ULL, 0x000fc60007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0609ULL, 0x0000001d0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x00000001f81c7824ULL, 0x000fe200078e0206ULL, 0x0001400016097811ULL, 0x000fe200078e20ffULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0x000000150600720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x000000151400720cULL, 0x000fe20003fc6070ULL,
0x000000ffff0d7224ULL, 0x000fe400028e060dULL, 0x0000000105067824ULL, 0x000fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000c14087810ULL, 0x000fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e001fULL, 0x01c61000f8ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000e141b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0001400017177811ULL, 0x000fe200078e20ffULL, 0x00000001f8167824ULL, 0x000fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e097faeULL, 0x0005e2000f101c46ULL,
0x0000001d06147210ULL, 0x000fe20007fde0ffULL, 0x00000001f81e7824ULL, 0x000fe200078e021bULL,
0x000000150800720cULL, 0x080fe20003fa6070ULL, 0x0000000105067824ULL, 0x000fe200078e0216ULL,
0x0000000010177faeULL, 0x0007e2000e101c46ULL, 0x000000151b00720cULL, 0x000fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200030e0607ULL, 0x000000071c087812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e001fULL, 0x0001400019197811ULL, 0x000fe200078e20ffULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000007160f7812ULL, 0x004fe200078ec0ffULL,
0x0000000105097824ULL, 0x000fe200078e021eULL, 0x0000000f08057812ULL, 0x100fe200078e7820ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x0000001d060e7210ULL, 0x000fe20007fde0ffULL,
0x00005e0009087625ULL, 0x000fe200078e001fULL, 0x000000071e107812ULL, 0x008fe200078ec0ffULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000f0f117812ULL, 0x100fe200078e7820ULL,
0x000000101c057824ULL, 0x000fe200078e0205ULL, 0x0000000f10177812ULL, 0x000fe200078e7820ULL,
0x000000ffff0f7224ULL, 0x000fe200030e0607ULL, 0x0000001d08087210ULL, 0x000fe20007fde0ffULL,
0x0000001016167824ULL, 0x000fe200078e0211ULL, 0x0001400018077811ULL, 0x000fe200078e20ffULL,
0x000000101e1e7824ULL, 0x000fe200078e0217ULL, 0x000140001a117811ULL, 0x000fe200078e20ffULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0001400005177811ULL, 0x000fe200078e20ffULL,
0x0000000012077faeULL, 0x0005e2000d901c46ULL, 0x00014000161b7811ULL, 0x000fe200078e20ffULL,
0xff317217ff057424ULL, 0x000fe200078e00ffULL, 0x000140001e1d7811ULL, 0x000fe200078e20ffULL,
0x000000000a197faeULL, 0x0003e2000d101c46ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000000c117faeULL, 0x0003e2000c901c46ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x000000ffff517224ULL, 0x000fc400078e00ffULL, 0x0000000014177faeULL, 0x0003e2000c101c46ULL,
0x000000040300720cULL, 0x000fc60003f06070ULL, 0x000000000e1b7faeULL, 0x0003e8000e901c46ULL,
0x00000000081d7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c64800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff507224ULL, 0x000fe200078e00ffULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000131c000000947ULL, 0x000fea0003800000ULL,
0x00007610ff077816ULL, 0x000fe20000000007ULL, 0xff317217ff057424ULL, 0x000fe200078e00ffULL,
0x0000000200087811ULL, 0x002fe200078e10ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x00007610ff127816ULL, 0x000fe20000000012ULL, 0x0000280701007387ULL, 0x0003e20000100600ULL,
0x00007610ff137816ULL, 0x000fe20000000013ULL, 0x000000ffff4b7224ULL, 0x000fc400078e00ffULL,
0x0000010003097824ULL, 0x000fca00078e00ffULL, 0x000000020900720cULL, 0x000fda0003f06070ULL,
0x0001309000000947ULL, 0x006fea0003800000ULL, 0x01c65c00ff097984ULL, 0x000ea20000000800ULL,
0x0000ffff12087812ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fc600078e000cULL,
0x00008880080a7816ULL, 0x000fca00000000ffULL, 0x800000000a087824ULL, 0x000fca00078e00ffULL,
0x8000000009ff7812ULL, 0x004fe20007804808ULL, 0x0000000000007918ULL, 0x000fec0000000000ULL,
0x0000761012097816ULL, 0x000fe40000000009ULL, 0x0000761013e97816ULL, 0x000fc600000000e9ULL,
0x0000240901007387ULL, 0x0005e20000100600ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01c65c00ff097984ULL, 0x004ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007804808ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000a0a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0004e4000021f000ULL, 0x3fa0000008087823ULL, 0x004fe200000100ffULL,
0x000000090000735dULL, 0x008fe40003800000ULL, 0x01c65c00ff097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fc4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000000000d7919ULL, 0x000ee20000002600ULL,
0x00000040030b7811ULL, 0x000fe200078e40ffULL, 0x00000100ff277424ULL, 0x000fe400078e00ffULL,
0x0000000000097919ULL, 0x004ea20000002700ULL, 0x0000000b020e7217ULL, 0x000fe20007800000ULL,
0x000000080c297824ULL, 0x040fe400078e00ffULL, 0x0000000000247919ULL, 0x000f220000000000ULL,
0x000040000c287824ULL, 0x000fe400078e00ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0bULL,
0x0000000829267812ULL, 0x000fc800078e0cffULL, 0x00000000260473c2ULL, 0x000f6200000e0000ULL,
0x000058000d0d7a10ULL, 0x008fe20007ffe0ffULL, 0x0000000209097824ULL, 0x004fe200078e00ffULL,
0x00000004ff1a7819ULL, 0x010fc60000011624ULL, 0x0000580009097a24ULL, 0x000fe200078e020dULL,
0x00000001030d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010242a7824ULL, 0x000fe200078e00ffULL,
0x000000021a1b7810ULL, 0x040fe20007ffe0ffULL, 0x00006200090a7a24ULL, 0x000fe200078e020bULL,
0x000000041a1d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001f8f57824ULL, 0x000fe200078e021aULL,
0x000000f02a2d7812ULL, 0x000fe200078ec0ffULL, 0x00000001f80b7824ULL, 0x000fe200078e021bULL,
0x000000040d00720cULL, 0x000fe20003f06070ULL, 0x00000001f5087824ULL, 0x040fe200078e020aULL,
0x000000061a1f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001f80d7824ULL, 0x000fe200078e021dULL,
0x00000007f50f7812ULL, 0x000fe200078ec0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0027ULL,
0x000000081a207810ULL, 0x000fe20007ffe0ffULL, 0x0001c64804047890ULL, 0x020fe2000fffe03fULL,
0x0000000f0f147812ULL, 0x000fe200078e7824ULL, 0x00000001f8117824ULL, 0x000fe200078e021fULL,
0x0000002d08187210ULL, 0x000fe20007f3e0ffULL, 0x00000001f8157824ULL, 0x000fe200078e0220ULL,
0x000000070b087812ULL, 0x000fe200078ec0ffULL, 0x00000010f5f57824ULL, 0x000fe200078e0214ULL,
0x0000000a1a217810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200008e0609ULL,
0x0000000f08087812ULL, 0x000fc400078e7824ULL, 0x000000070d0f7812ULL, 0x000fe200078ec0ffULL,
0x00000001f8177824ULL, 0x000fe200078e0221ULL, 0x0000000c1a2b7810ULL, 0x000fe20007ffe0ffULL,
0x000000100bf47824ULL, 0x040fe200078e0208ULL, 0x000000400e097807ULL, 0x000fe20000000000ULL,
0x000000010b087824ULL, 0x000fe200078e020aULL, 0x00000007110e7812ULL, 0x000fe200078ec0ffULL,
0x00000001f8237824ULL, 0x000fe200078e022bULL, 0x0000000f0ff27812ULL, 0x000fe200078e7824ULL,
0x00000001110f7824ULL, 0x100fe200078e020aULL, 0x00000007150b7812ULL, 0x000fe200078ec0ffULL,
0x00000001171e7824ULL, 0x000fe200078e020aULL, 0x0000000e1a2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000100df27824ULL, 0x040fe200078e02f2ULL, 0x0000000f0e147812ULL, 0x000fe200078e7824ULL,
0x000000010d0e7824ULL, 0x000fe200078e020aULL, 0x0000000f0b167812ULL, 0x000fe200078e7824ULL,
0x00000001f8257824ULL, 0x040fe200078e022cULL, 0x00000007170d7812ULL, 0x000fe200078ec0ffULL,
0x0000001011f17824ULL, 0x000fe200078e0214ULL, 0x00000007230b7812ULL, 0x000fe200078ec0ffULL,
0x0000001015147824ULL, 0x000fe200078e0216ULL, 0x0000000f0d1c7812ULL, 0x000fe200078e7824ULL,
0x0000000115117824ULL, 0x000fe200078e020aULL, 0x0000000f0b167812ULL, 0x000fe200078e7824ULL,
0x0000000123227824ULL, 0x000fe200078e020aULL, 0x00000007250d7812ULL, 0x000fe200078ec0ffULL,
0x0000001017157824ULL, 0x000fe200078e021cULL, 0x00000009f80b7217ULL, 0x000fe20007800000ULL,
0x00005e0008087625ULL, 0x000fe200078e0027ULL, 0x0000000f0d1c7812ULL, 0x000fc600078e7824ULL,
0x000000010b0d7824ULL, 0x000fe400078e0af8ULL, 0x0000000125247824ULL, 0x040fe400078e020aULL,
0x00005e000e0a7625ULL, 0x000fe200078e0027ULL, 0x0000000d1a00720cULL, 0x000fe40003f86070ULL,
0x0000002d081a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001025177824ULL, 0x000fe200078e021cULL,
0x0000000d1b00720cULL, 0x000fe20003fa6070ULL, 0x00005e000f0e7625ULL, 0x000fe200078e0027ULL,
0x0000002d0a1c7210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e0609ULL,
0x0000000d1d00720cULL, 0x000fe20003f06070ULL, 0x00005e0011087625ULL, 0x000fe200078e0027ULL,
0x0000002d0e0e7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e060bULL,
0x0000000d1f00720cULL, 0x000fe20003f26070ULL, 0x00005e001e0a7625ULL, 0x000fe200078e0027ULL,
0x0000002d081e7210ULL, 0x000fe40007f7e0ffULL, 0x0000400028087812ULL, 0x000fe200078e0cffULL,
0x0000001023167824ULL, 0x000fe400078e0216ULL, 0x000000ffff1f7224ULL, 0x000fe200018e0609ULL,
0x0001400008117810ULL, 0x000fe20007ffe0ffULL, 0x00005e0022087625ULL, 0x000fe200078e0027ULL,
0x0000000d2100720cULL, 0x000fc60003f66070ULL, 0x00000010f5237824ULL, 0x000fe400078e0211ULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000000d2000720cULL, 0x000fe20003f46070ULL,
0x00000010f4257824ULL, 0x000fe200078e0211ULL, 0x0000002d0a207210ULL, 0x080fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0005e2000e101c46ULL,
0x0000002d08087210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff217224ULL, 0x000fe200030e060bULL,
0x000000001a257faeULL, 0x0007e2000e901c46ULL, 0x00005e00240a7625ULL, 0x000fe200078e0027ULL,
0x0000000d2b00720cULL, 0x000fc60003fa6070ULL, 0x000000ffff097224ULL, 0x000fe200020e0609ULL,
0x0000000d2c00720cULL, 0x000fe20003f86070ULL, 0x00000010f20d7824ULL, 0x100fe200078e0211ULL,
0x0000002d0a0a7210ULL, 0x000fe20007fde0ffULL, 0x00000010f1277824ULL, 0x100fe400078e0211ULL,
0x0000001014197824ULL, 0x104fe200078e0211ULL, 0x000000001c0d7faeULL, 0x0005e2000c101c46ULL,
0x00000010151b7824ULL, 0x108fe400078e0211ULL, 0x0000001016237824ULL, 0x000fe200078e0211ULL,
0x000000000e277faeULL, 0x0005e2000c901c46ULL, 0x000000ffff0b7224ULL, 0x000fc400030e060bULL,
0x0000001017117824ULL, 0x000fe200078e0211ULL, 0x000000001e197faeULL, 0x0005e8000d101c46ULL,
0x00000000201b7faeULL, 0x0005e8000d901c46ULL, 0x0000000008237faeULL, 0x0005e8000e901c46ULL,
0x000000000a117faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c00290b7984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00002800012d7983ULL, 0x000f220000100800ULL, 0x0000ffff13087812ULL, 0x000fc600078ec0ffULL,
0x01c60c00ff0a7984ULL, 0x000f620000000800ULL, 0x00008880080e7816ULL, 0x000fca00000000ffULL,
0x800000000e087824ULL, 0x000fca00078e00ffULL, 0x800000000bff7812ULL, 0x008fe40007804808ULL,
0x0000ffff2d097812ULL, 0x010fc800078ec0ffULL, 0x0000888009187816ULL, 0x000fca00000000ffULL,
0x8000000018097824ULL, 0x000fca00078e00ffULL, 0x800000000aff7812ULL, 0x020fe20007824809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0001c64829297810ULL, 0x004fe20007ffe0ffULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fe400078e00ffULL,
0x80000000180a7824ULL, 0x000fe400078e00ffULL, 0x0000000800097305ULL, 0x0004e4000021f000ULL,
0x3fa0000008087823ULL, 0x004fe200000100ffULL, 0x000000090000735dULL, 0x008fe40003800000ULL,
0x01c60c00ff097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fc4000782480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000000000b7919ULL, 0x000ea20000000000ULL, 0x000000702a197812ULL, 0x000fe200078ec0ffULL,
0x00000001ff2b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x004fc8000001160bULL,
0x0000000c08087812ULL, 0x000fca00078ec0ffULL, 0x0000000119197824ULL, 0x000fca00078e0208ULL,
0x01c0000019087984ULL, 0x000ea80000000800ULL, 0x01c2000019097984ULL, 0x0007220000000800ULL,
0x000000050800720bULL, 0x004fda0003f3d000ULL, 0x00000000000a7806ULL, 0x000fc800008e0100ULL,
0x0000ffff0a0f7812ULL, 0x000fda000782c0ffULL, 0x0000035000009947ULL, 0x000fea0003800000ULL,
0x000000050800720bULL, 0x018fe40003f34000ULL, 0x00000008051c7209ULL, 0x000fe40007810000ULL,
0x00000002ff0b7819ULL, 0x000fc6000001160bULL, 0x8000001c050a7221ULL, 0x000fe20000010000ULL,
0x000000080b0d7810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b0a0a7820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fe400008e0100ULL, 0x000000ff0000720cULL, 0x000fe40003f25270ULL,
0x0000ffff051a7812ULL, 0x000fe200078e3cffULL, 0x0000000a000a7308ULL, 0x000ea20000000800ULL,
0x000000ffff057224ULL, 0x000fe400078e001cULL, 0x0000001a0fff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff2b7807ULL, 0x000fc60001000000ULL, 0x01c4001c19009388ULL, 0x000fe80000000800ULL,
0x00001f0d0a0d7589ULL, 0x004ea400000e0000ULL, 0x8000001c08082221ULL, 0x000fe40000010000ULL,
0x0000000a06067220ULL, 0x000fe20000410000ULL, 0x00001f0b0a0b7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b08082820ULL, 0x000fc80000410000ULL, 0x0000000800072308ULL, 0x002e620000000800ULL,
0x0000000d4b4b7220ULL, 0x084fe40000410000ULL, 0x0000000d4a4a7220ULL, 0x080fe40000410000ULL,
0x0000000d4f4f7220ULL, 0x080fe40000410000ULL, 0x0000000d4e4e7220ULL, 0x080fe40000410000ULL,
0x0000000d3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000d3e3e7220ULL, 0x000fc40000410000ULL,
0x0000000d53537220ULL, 0x080fe40000410000ULL, 0x0000000d52527220ULL, 0x080fe40000410000ULL,
0x0000000d5b5b7220ULL, 0x080fe40000410000ULL, 0x0000000d5a5a7220ULL, 0x080fe40000410000ULL,
0x0000000d57577220ULL, 0x080fe40000410000ULL, 0x0000000d56567220ULL, 0x000fc40000410000ULL,
0x0000000d37377220ULL, 0x080fe40000410000ULL, 0x0000000d36367220ULL, 0x080fe40000410000ULL,
0x0000000d43437220ULL, 0x080fe40000410000ULL, 0x0000000d42427220ULL, 0x000fe40000410000ULL,
0x0000000b49497220ULL, 0x088fe40000410000ULL, 0x0000000b48487220ULL, 0x000fc40000410000ULL,
0x0000000b4d4d7220ULL, 0x080fe40000410000ULL, 0x0000000b4c4c7220ULL, 0x080fe40000410000ULL,
0x0000000b3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000b3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000b51517220ULL, 0x080fe40000410000ULL, 0x0000000b50507220ULL, 0x000fc40000410000ULL,
0x0000000b59597220ULL, 0x080fe40000410000ULL, 0x0000000b58587220ULL, 0x080fe40000410000ULL,
0x0000000b55557220ULL, 0x080fe40000410000ULL, 0x0000000b54547220ULL, 0x080fe40000410000ULL,
0x0000000b35357220ULL, 0x080fe40000410000ULL, 0x0000000b34347220ULL, 0x000fc40000410000ULL,
0x0000000b41417220ULL, 0x080fe40000410000ULL, 0x0000000b40407220ULL, 0x000fe40000410000ULL,
0x0000000709092220ULL, 0x002fc80000410000ULL, 0x0000000609067221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000040029087984ULL, 0x000ea20000000800ULL,
0x800000000e097824ULL, 0x000fca00078e00ffULL, 0x8000000008ff7812ULL, 0x004fe20007804809ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000e0e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0004e4000021f000ULL, 0x3fa0000008087823ULL, 0x004fe200000100ffULL,
0x000000090000735dULL, 0x008fe40003800000ULL, 0x0000040029097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fc4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000dc7919ULL, 0x000ea20000000000ULL,
0x00000002000f7811ULL, 0x000fe400078e10ffULL, 0x00014000280b7810ULL, 0x000fe40007ffe0ffULL,
0x000140000c1c7811ULL, 0x000fe400078e70ffULL, 0x00000004ff0d7819ULL, 0x004fe400000116dcULL,
0x00000008dc087812ULL, 0x000fc600078ec0ffULL, 0x0000000400097824ULL, 0x000fe200078e020dULL,
0x00000007080a7812ULL, 0x140fe200078ec8dcULL, 0x000000010d0d7824ULL, 0x000fe200078e020fULL,
0x0000000708087812ULL, 0x000fe400078ef8dcULL, 0x000000090a097212ULL, 0x040fe400078e3cffULL,
0x0000000d0a1b7212ULL, 0x000fe400078e3cffULL, 0x00000100081e7811ULL, 0x040fe200078e20ffULL,
0x00000010080e7824ULL, 0x040fe200078e0209ULL, 0x0000020008207811ULL, 0x040fe200078e20ffULL,
0x00000010081a7824ULL, 0x000fc400078e021bULL, 0x000000100e687824ULL, 0x100fe200078e020bULL,
0x0000100e01007387ULL, 0x000fe20000100800ULL, 0x000000101a747824ULL, 0x000fe400078e020bULL,
0x0000000109117824ULL, 0x100fe400078e021eULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x000000011b0f7824ULL, 0x000fe400078e021eULL, 0x00000010115c7824ULL, 0x100fe200078e021cULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x000000100f447824ULL, 0x000fc800078e021cULL,
0x000000005c5c783bULL, 0x000f280000004200ULL, 0x000000004444783bULL, 0x000f620000004200ULL,
0x00000018ff0a7819ULL, 0x004fe20000011468ULL, 0x0000010068827824ULL, 0x000fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001146aULL, 0x0000006900a47306ULL, 0x000fe20000009400ULL,
0x00000018ff0e7819ULL, 0x008fe40000011475ULL, 0x00000018ff8d7819ULL, 0x000fc40000011482ULL,
0x00000018ff0b7819ULL, 0x000fe40000011469ULL, 0x00000018ff1d7819ULL, 0x010fe2000001145fULL,
0x0000000e00907306ULL, 0x000fe20000209400ULL, 0x00000018ff1e7819ULL, 0x020fce0000011446ULL,
0x0000000e002d7306ULL, 0x000ff00000205400ULL, 0x0000000e008c7306ULL, 0x0005f0000020d400ULL,
0x0000000a00a67306ULL, 0x000fe20000209400ULL, 0x00000001090e7824ULL, 0x004fc800078e0220ULL,
0x000000100e607824ULL, 0x000fc600078e021cULL, 0x0000000a00d27306ULL, 0x000ea60000205400ULL,
0x000000006060783bULL, 0x000eea0000004200ULL, 0x0000000a00b77306ULL, 0x000970000020d400ULL,
0x0000000d00a97306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x010fc4000001146bULL,
0x000000d2a600720bULL, 0x004fca0003f9d000ULL, 0x0000000a00a77306ULL, 0x000ff00000209400ULL,
0x0000000a00a87306ULL, 0x000fe20000205400ULL, 0x00000001b7b74812ULL, 0x020fce00078efcffULL,
0x0000000a00cd7306ULL, 0x0005f0000020d400ULL, 0x0000000d00ab7306ULL, 0x000fe20000205400ULL,
0x00000018ff0a7819ULL, 0x004fce0000011477ULL, 0x0000000d00ce7306ULL, 0x0005f0000020d400ULL,
0x0000000a00c37306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x004fce0000011476ULL,
0x0000000a00c97306ULL, 0x000ff00000205400ULL, 0x0000000a009d7306ULL, 0x0005f0000020d400ULL,
0x0000000d00857306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x004fce000001145eULL,
0x0000000d00cc7306ULL, 0x000ff00000205400ULL, 0x0000000d00a07306ULL, 0x0005f0000020d400ULL,
0x0000000a007b7306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x004fce000001145dULL,
0x0000000a007c7306ULL, 0x000ff00000205400ULL, 0x0000000a00787306ULL, 0x0005f0000020d400ULL,
0x0000000d00837306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x004fce0000011445ULL,
0x0000000d007e7306ULL, 0x000ff00000205400ULL, 0x0000000d00797306ULL, 0x0005f0000020d400ULL,
0x0000000a006d7306ULL, 0x000fe20000209400ULL, 0x000000011b0d7824ULL, 0x004fe200078e0220ULL,
0x0000030008207811ULL, 0x000fc400078e20ffULL, 0x00000018ff087819ULL, 0x008fe20000011463ULL,
0x000000100d647824ULL, 0x000fc600078e021cULL, 0x0000000a009e7306ULL, 0x000fe60000205400ULL,
0x000000006464783bULL, 0x000eaa0000004200ULL, 0x0000000a002c7306ULL, 0x0007f0000020d400ULL,
0x0000001e006e7306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x008fce0000011460ULL,
0x0000000a008f7306ULL, 0x000ff00000209400ULL, 0x0000000a00927306ULL, 0x000ff00000205400ULL,
0x0000000a00287306ULL, 0x0007f0000020d400ULL, 0x0000001e009a7306ULL, 0x000fe20000205400ULL,
0x00000001090a7824ULL, 0x008fc400078e0220ULL, 0x000000011b097824ULL, 0x000fe200078e0220ULL,
0x00000018ff1b7819ULL, 0x004fe20000011467ULL, 0x000000100a387824ULL, 0x100fe400078e021cULL,
0x0000001009307824ULL, 0x000fe200078e021cULL, 0x0000001e002a7306ULL, 0x0005e6000020d400ULL,
0x000000003838783bULL, 0x000ee80000004200ULL, 0x000000003030783bULL, 0x000f220000004200ULL,
0x0000008d00a57306ULL, 0x000fe20000209400ULL, 0x00000018ff1e7819ULL, 0x004fce0000011466ULL,
0x0000001e00f37306ULL, 0x000ff00000209400ULL, 0x0000001e00f07306ULL, 0x000ff00000205400ULL,
0x0000001e00227306ULL, 0x0007f0000020d400ULL, 0x0000008d00c67306ULL, 0x000ea20000205400ULL,
0x00000018ff1e7819ULL, 0x008fc4000001143aULL, 0x00000018ff1c7819ULL, 0x000fe40000011438ULL,
0x00000018ff877819ULL, 0x010fc60000011431ULL, 0x0000001b00f77306ULL, 0x000fe20000209400ULL,
0x00000018ff1f7819ULL, 0x000fe4000001143bULL, 0x00000018ff947819ULL, 0x000fe40000011432ULL,
0x00000018ff207819ULL, 0x000fe40000011430ULL, 0x00000018ff967819ULL, 0x000fe20000011433ULL,
0x0000001b00f67306ULL, 0x000fe20000205400ULL, 0x000000c6a500720bULL, 0x004fe20003f1d000ULL,
0x0001000076c67824ULL, 0x000fcc00078e00ffULL, 0x0000001b00217306ULL, 0x000ff0000020d400ULL,
0x0000001e001b7306ULL, 0x000ff0000020d400ULL, 0x00000087001e7306ULL, 0x0005f0000020d400ULL,
0x00000008009b7306ULL, 0x000fe20000209400ULL, 0x0000010069877824ULL, 0x004fce00078e00ffULL,
0x0000000800b07306ULL, 0x000ff00000205400ULL, 0x0000000800257306ULL, 0x000ff0000020d400ULL,
0x0000001c00fa7306ULL, 0x000ff00000209400ULL, 0x0000001c00f97306ULL, 0x000ff00000205400ULL,
0x0000001c00087306ULL, 0x000ff0000020d400ULL, 0x0000001f001c7306ULL, 0x000ff0000020d400ULL,
0x00000094001f7306ULL, 0x0005f0000020d400ULL, 0x0000000b00957306ULL, 0x000fe20000209400ULL,
0x00000018ff947819ULL, 0x004fce0000011487ULL, 0x0000000b008e7306ULL, 0x000eb00000205400ULL,
0x0000000b00b37306ULL, 0x0007f0000020d400ULL, 0x0000008d00827306ULL, 0x000962000020d400ULL,
0x00000018ff0b7819ULL, 0x008fc40000011474ULL, 0x0000008e9500720bULL, 0x004fca0003f9d000ULL,
0x0000009400a37306ULL, 0x000fe20000209400ULL, 0x000001006a8d7824ULL, 0x010fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x0000009400ad7306ULL, 0x000ea20000205400ULL,
0x0000000182820812ULL, 0x020fe400078efcffULL, 0x00000001b3b34812ULL, 0x000fca00078efcffULL,
0x0000000b00917306ULL, 0x000ff00000209400ULL, 0x0000000b00937306ULL, 0x000fe20000205400ULL,
0x000000ada300720bULL, 0x004fce0003f1d000ULL, 0x0000000b00ac7306ULL, 0x0005f0000020d400ULL,
0x0000006900c57306ULL, 0x000ee20000005400ULL, 0x00000018ff0b7819ULL, 0x004fce000001145cULL,
0x00000069008b7306ULL, 0x000530000000d400ULL, 0x0000001d007a7306ULL, 0x000fe20000209400ULL,
0x0001000069697824ULL, 0x004fe200078e00ffULL, 0x000000c5a400720bULL, 0x008fc80003f5d000ULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x0000001d00717306ULL, 0x000fee0000205400ULL,
0x000000018b8b2812ULL, 0x010fe200078efcffULL, 0x0000001d00707306ULL, 0x0005f0000020d400ULL,
0x0000006800a17306ULL, 0x000fe20000009400ULL, 0x00000018ff1d7819ULL, 0x004fce0000011447ULL,
0x0000006800c27306ULL, 0x000eb00000005400ULL, 0x00000068008a7306ULL, 0x000730000000d400ULL,
0x0000000b00897306ULL, 0x000fe20000209400ULL, 0x0001000068687824ULL, 0x008fe200078e00ffULL,
0x000000c2a100720bULL, 0x004fc80003fdd000ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x0000000b00887306ULL, 0x000fee0000205400ULL, 0x000000018a8a6812ULL, 0x010fe200078efcffULL,
0x0000000b00807306ULL, 0x0005e6000020d400ULL, 0x0000008a828a723eULL, 0x000fe200000010ffULL,
0x000100005f827824ULL, 0x000fc800078e00ffULL, 0x0000001d00987306ULL, 0x000fe20000209400ULL,
0x00000018ff0b7819ULL, 0x004fe40000011444ULL, 0x00000018ff827819ULL, 0x000fca0000011482ULL,
0x0000001d00997306ULL, 0x000ff00000205400ULL, 0x0000001d00297306ULL, 0x0005f0000020d400ULL,
0x0000000b00aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff1d7819ULL, 0x004fce0000011462ULL,
0x0000000b009f7306ULL, 0x000ff00000205400ULL, 0x0000000b006c7306ULL, 0x0005f0000020d400ULL,
0x0000009400877306ULL, 0x000ee2000020d400ULL, 0x00000018ff0b7819ULL, 0x004fce0000011461ULL,
0x0000001d00737306ULL, 0x000ff00000209400ULL, 0x0000001d002e7306ULL, 0x000fe20000205400ULL,
0x0000000187870812ULL, 0x008fc800078efcffULL, 0x0000008b878b723eULL, 0x000fc600000010ffULL,
0x0000001d00267306ULL, 0x0005f0000020d400ULL, 0x0000006900ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff1d7819ULL, 0x004fce0000011465ULL, 0x0000006900bc7306ULL, 0x000eb00000205400ULL,
0x0000000b002f7306ULL, 0x000ff00000209400ULL, 0x0000000b00727306ULL, 0x000fe20000205400ULL,
0x000000bcba00720bULL, 0x004fce0003f1d000ULL, 0x0000000b00277306ULL, 0x0005f0000020d400ULL,
0x0000006800c77306ULL, 0x000fe20000209400ULL, 0x00000018ff0b7819ULL, 0x004fce0000011464ULL,
0x0000006800cf7306ULL, 0x000eb00000205400ULL, 0x0000006800d37306ULL, 0x000730000020d400ULL,
0x0000001d007f7306ULL, 0x000fe20000209400ULL, 0x000001006b687824ULL, 0x008fe200078e00ffULL,
0x000000cfc700720bULL, 0x004fc40003f3d000ULL, 0x00000018ffcf7819ULL, 0x000fe400000114c6ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000001d00847306ULL, 0x000fee0000205400ULL,
0x00000001d3d31812ULL, 0x010fe200078efcffULL, 0x0000001d00237306ULL, 0x0005f0000020d400ULL,
0x0000000b006f7306ULL, 0x000fe20000209400ULL, 0x00000018ff1d7819ULL, 0x004fce0000011439ULL,
0x0000000b007d7306ULL, 0x000ff00000205400ULL, 0x0000000b00247306ULL, 0x000ff0000020d400ULL,
0x0000001d00fc7306ULL, 0x000ff00000209400ULL, 0x0000001d00fb7306ULL, 0x000ff00000205400ULL,
0x0000001d000b7306ULL, 0x000ff0000020d400ULL, 0x00000020001d7306ULL, 0x000ff0000020d400ULL,
0x0000009600207306ULL, 0x000ff0000020d400ULL, 0x0000006900be7306ULL, 0x0004f0000020d400ULL,
0x0000006800967306ULL, 0x000fe20000209400ULL, 0x0000010074697824ULL, 0x004fca00078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe40000011469ULL, 0x0000006800af7306ULL, 0x000ea20000205400ULL,
0x00000001bebe0812ULL, 0x008fce00078efcffULL, 0x0000006800bd7306ULL, 0x000730000020d400ULL,
0x0000006a00b97306ULL, 0x000fe20000009400ULL, 0x0000010075687824ULL, 0x008fe200078e00ffULL,
0x000000af9600720bULL, 0x004fc80003f1d000ULL, 0x00000018ffc07819ULL, 0x000fe40000011468ULL,
0x0000006a00d97306ULL, 0x000eae0000005400ULL, 0x00000001bdbd0812ULL, 0x010fe200078efcffULL,
0x0000006a00867306ULL, 0x000730000000d400ULL, 0x0000007500a27306ULL, 0x000fe20000009400ULL,
0x000100006a6a7824ULL, 0x008fe200078e00ffULL, 0x000000d9b900720bULL, 0x004fc80003fbd000ULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x0000007500ca7306ULL, 0x000eae0000005400ULL,
0x0000000186865812ULL, 0x010fe200078efcffULL, 0x0000008d00b57306ULL, 0x000fe20000209400ULL,
0x000000aba900720bULL, 0x000fce0003fbd000ULL, 0x0000008d009c7306ULL, 0x000ee20000205400ULL,
0x000000caa200720bULL, 0x004fca0003f3d000ULL, 0x00000001cece5812ULL, 0x000fe400078efcffULL,
0x0000008d00b87306ULL, 0x000ea2000020d400ULL, 0x000000939100720bULL, 0x000fce0003fbd000ULL,
0x000000c000687306ULL, 0x000fe20000209400ULL, 0x0000009cb500720bULL, 0x008fca0003f5d000ULL,
0x00000001acac5812ULL, 0x000fe400078efcffULL, 0x000000c000697306ULL, 0x000fe20000205400ULL,
0x000000cc8500720bULL, 0x000fca0003fbd000ULL, 0x00000001b8b82812ULL, 0x004fe400078efcffULL,
0x000000c0008d7306ULL, 0x0005ec000020d400ULL, 0x00000001a0a05812ULL, 0x000fe400078efcffULL,
0x0000006a00b27306ULL, 0x000fe20000209400ULL, 0x0001000075c07824ULL, 0x004fca00078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe400000114c0ULL, 0x0000006a00b47306ULL, 0x000eb00000205400ULL,
0x0000006b00bb7306ULL, 0x000ff00000009400ULL, 0x0000006b00d87306ULL, 0x000ee20000005400ULL,
0x000000b4b200720bULL, 0x004fce0003f1d000ULL, 0x0000006b00817306ULL, 0x000530000000d400ULL,
0x000000bf00977306ULL, 0x000fe20000209400ULL, 0x000100006b6b7824ULL, 0x004fe200078e00ffULL,
0x000000d8bb00720bULL, 0x008fe20003f7d000ULL, 0x000100005ed87824ULL, 0x000fc600078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x000000bf00947306ULL, 0x000fe20000205400ULL,
0x00000018ffd87819ULL, 0x000fcc00000114d8ULL, 0x0000000181813812ULL, 0x010fe200078efcffULL,
0x000000bf00c17306ULL, 0x000fe2000020d400ULL, 0x000000a8a700720bULL, 0x000fce0003f7d000ULL,
0x0000007500bf7306ULL, 0x0004ec000000d400ULL, 0x00000001cdcd3812ULL, 0x000fe400078efcffULL,
0x000000db00d47306ULL, 0x000fe20000209400ULL, 0x0000010077757824ULL, 0x004fe200078e00ffULL,
0x0000002d9000720bULL, 0x000fe20003f7d000ULL, 0x000001005f2d7824ULL, 0x000fca00078e00ffULL,
0x000000db00d57306ULL, 0x000ea20000205400ULL, 0x00000001bfbf1812ULL, 0x008fe400078efcffULL,
0x00000018ff937819ULL, 0x000fe4000001142dULL, 0x00000007ff2d723eULL, 0x000fe400000010ffULL,
0x000000018c8c3812ULL, 0x000fe200078efcffULL, 0x0000006a00d17306ULL, 0x000722000020d400ULL,
0x000054102dd97816ULL, 0x000fce000000002dULL, 0x0000007400ae7306ULL, 0x000fe20000009400ULL,
0x00010000746a7824ULL, 0x008fe200078e00ffULL, 0x000000d5d400720bULL, 0x004fc80003f3d000ULL,
0x00000018ffda7819ULL, 0x000fe4000001146aULL, 0x0000007400cb7306ULL, 0x000ea20000005400ULL,
0x00000001d1d10812ULL, 0x010fce00078efcffULL, 0x0000007400c87306ULL, 0x000730000000d400ULL,
0x0000006b00b17306ULL, 0x000fe20000209400ULL, 0x0000010076747824ULL, 0x008fe200078e00ffULL,
0x000000cbae00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000006b00b67306ULL, 0x000eae0000205400ULL, 0x00000001c8c86812ULL, 0x010fe200078efcffULL,
0x000000db00c07306ULL, 0x000ef0000020d400ULL, 0x0000006b00d07306ULL, 0x000f22000020d400ULL,
0x000000b6b100720bULL, 0x004fc40003f1d000ULL, 0x00000007dcb17812ULL, 0x000fc800078ec0ffULL,
0x00000008b1b17812ULL, 0x000fe200078ef8dcULL, 0x000000da006a7306ULL, 0x000fe20000209400ULL,
0x00000001c0c01812ULL, 0x008fe400078efcffULL, 0x000000c9c300720bULL, 0x000fca0003f3d000ULL,
0x000000da006b7306ULL, 0x000ea20000205400ULL, 0x00000001d0d00812ULL, 0x010fe400078efcffULL,
0x000000949700720bULL, 0x000fca0003f1d000ULL, 0x000000da00c47306ULL, 0x000722000020d400ULL,
0x000000019d9d1812ULL, 0x000fce00078efcffULL, 0x0000007600b97306ULL, 0x000fe20000009400ULL,
0x00000018ffda7819ULL, 0x008fe40000011475ULL, 0x00000001c1c10812ULL, 0x000fe400078efcffULL,
0x000000696800720bULL, 0x000fe40003f1d000ULL, 0x0000006b6a00720bULL, 0x004fe20003fdd000ULL,
0x0000007600bb7306ULL, 0x000eb00000005400ULL, 0x0000007600a67306ULL, 0x000764000000d400ULL,
0x000000018d8d0812ULL, 0x000fc400078efcffULL, 0x00000001c4c46812ULL, 0x010fc800078efcffULL,
0x0000007400d67306ULL, 0x000fe20000209400ULL, 0x0001000077767824ULL, 0x008fe200078e00ffULL,
0x000000bbb900720bULL, 0x004fc80003f9d000ULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x0000007400d77306ULL, 0x000eae0000205400ULL, 0x00000001a6a64812ULL, 0x020fe200078efcffULL,
0x0000007400a17306ULL, 0x000ef0000020d400ULL, 0x0000007700747306ULL, 0x000fe20000009400ULL,
0x000000d7d600720bULL, 0x004fce0003fdd000ULL, 0x0000007700757306ULL, 0x000eac0000005400ULL,
0x00000001a1a16812ULL, 0x008fe400078efcffULL, 0x0000007700a57306ULL, 0x000730000000d400ULL,
0x0000007600ad7306ULL, 0x000fe20000209400ULL, 0x000001005c777824ULL, 0x008fe200078e00ffULL,
0x000000757400720bULL, 0x004fe20003f5d000ULL, 0x000100005d747824ULL, 0x000fc600078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011477ULL, 0x0000007600ae7306ULL, 0x000ea20000205400ULL,
0x00000018ff747819ULL, 0x000fcc0000011474ULL, 0x00000001a5a52812ULL, 0x010fe200078efcffULL,
0x0000007600a27306ULL, 0x000730000020d400ULL, 0x0000005c00ba7306ULL, 0x000fe20000009400ULL,
0x000100005c767824ULL, 0x008fe200078e00ffULL, 0x000000aead00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x0000005c00957306ULL, 0x000eae0000005400ULL,
0x00000001a2a24812ULL, 0x010fe200078efcffULL, 0x0000005c009c7306ULL, 0x000730000000d400ULL,
0x00000077008e7306ULL, 0x000fe20000209400ULL, 0x000001005d5c7824ULL, 0x008fe200078e00ffULL,
0x00000095ba00720bULL, 0x004fc40003f9d000ULL, 0x00000018ffba7819ULL, 0x000fe4000001143bULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000007700967306ULL, 0x000eae0000205400ULL,
0x000000019c9c4812ULL, 0x010fe200078efcffULL, 0x0000007600cb7306ULL, 0x000fe20000209400ULL,
0x0000007e8300720bULL, 0x000fce0003f9d000ULL, 0x0000007600ca7306ULL, 0x000fe20000205400ULL,
0x000000968e00720bULL, 0x004fca0003f3d000ULL, 0x0000000179794812ULL, 0x000fe400078efcffULL,
0x0000007600af7306ULL, 0x000fe2000020d400ULL, 0x0000007c7b00720bULL, 0x000fce0003f9d000ULL,
0x0000005c00b27306ULL, 0x000fec0000209400ULL, 0x0000000178784812ULL, 0x000fe400078efcffULL,
0x0000005c00767306ULL, 0x000ff00000205400ULL, 0x0000005c00b67306ULL, 0x0005f0000020d400ULL,
0x0000007700b57306ULL, 0x000ee2000020d400ULL, 0x00000004ff5c7819ULL, 0x004fc800000116dcULL,
0x000000075c5c7812ULL, 0x000fc600078e78b1ULL, 0x0000005d00bc7306ULL, 0x000fe40000009400ULL,
0x00000008b15c7824ULL, 0x000fca00078e025cULL, 0x000120005c687811ULL, 0x000fe200078e20ffULL,
0x0000005d00bb7306ULL, 0x000ea20000005400ULL, 0x00000001b5b51812ULL, 0x008fe400078efcffULL,
0x000000cacb00720bULL, 0x000fe40003f3d000ULL, 0x000000006868783bULL, 0x000fe60000000200ULL,
0x0000005d00b47306ULL, 0x000730000000d400ULL, 0x000000da00c27306ULL, 0x000fe20000209400ULL,
0x000001005e5d7824ULL, 0x008fe200078e00ffULL, 0x00000001afaf1812ULL, 0x000fc400078efcffULL,
0x00000076b200720bULL, 0x000fe40003f3d000ULL, 0x00000018ff777819ULL, 0x000fe4000001145dULL,
0x000000da00c57306ULL, 0x000ee20000205400ULL, 0x000000bbbc00720bULL, 0x004fce0003fbd000ULL,
0x000000da00a47306ULL, 0x000562000020d400ULL, 0x00000001b6b61812ULL, 0x000fca00078efcffULL,
0x00000001b4b45812ULL, 0x010fe400078efcffULL, 0x000000cf00c67306ULL, 0x000fe20000209400ULL,
0x00000002ffda7819ULL, 0x004fe400000116dcULL, 0x000000c5c200720bULL, 0x008fc60003f7d000ULL,
0x00001fdad92d7589ULL, 0x000ea400000e0000ULL, 0x000000cf00c77306ULL, 0x000ef00000205400ULL,
0x000000cf00a37306ULL, 0x000f22000020d400ULL, 0x00000001a4a43812ULL, 0x020fce00078efcffULL,
0x0000007400d27306ULL, 0x000fe20000209400ULL, 0x000000c7c600720bULL, 0x008fce0003fdd000ULL,
0x0000007400cf7306ULL, 0x000eec0000205400ULL, 0x00000001a3a36812ULL, 0x010fe400078efcffULL,
0x0000007400a97306ULL, 0x000f22000020d400ULL, 0x000000888900720bULL, 0x000fce0003fdd000ULL,
0x00000093005d7306ULL, 0x000fec0000209400ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x0000009300747306ULL, 0x000fe20000205400ULL, 0x000000cfd200720bULL, 0x008fce0003fdd000ULL,
0x0000009300917306ULL, 0x0007ec000020d400ULL, 0x00000001a9a96812ULL, 0x010fe400078efcffULL,
0x0000007700757306ULL, 0x000fe20000209400ULL, 0x00000008da937810ULL, 0x008fce0007ffe0ffULL,
0x0000007700ab7306ULL, 0x000ef00000205400ULL, 0x0000007700907306ULL, 0x000962000020d400ULL,
0x000000ab7500720bULL, 0x008fce0003f3d000ULL, 0x0000005e00977306ULL, 0x000fe20000009400ULL,
0x000099102b777816ULL, 0x010fe400000000ffULL, 0x00001f93d92b7589ULL, 0x00072200000e0000ULL,
0x00000018ffab7819ULL, 0x000fe4000001143aULL, 0x000000ff7700720cULL, 0x000fe20003f05270ULL,
0x0000010044777824ULL, 0x000fe200078e00ffULL, 0x0000005e00b97306ULL, 0x000e620000005400ULL,
0x0000000190901812ULL, 0x020fe400078efcffULL, 0x000000745d00720bULL, 0x000fe20003f3d000ULL,
0x00000100665d7824ULL, 0x000fc800078e00ffULL, 0x0000005e00a87306ULL, 0x000a62000000d400ULL,
0x00000018ff777819ULL, 0x000fe40000011477ULL, 0x0000002d68688231ULL, 0x084fe200003400ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000002d6a6a8231ULL, 0x000fc600003400ffULL,
0x0000005f00937306ULL, 0x008fe20000009400ULL, 0x000000d3b75e723eULL, 0x020fe200000010ffULL,
0x0000002b69698231ULL, 0x090fe200003400ffULL, 0x0000000191911812ULL, 0x000fe200078efcffULL,
0x0000002b6b6b8231ULL, 0x000fe200003400ffULL, 0x000000b99700720bULL, 0x002fc60003f5d000ULL,
0x0000005f00947306ULL, 0x000e620000005400ULL, 0x00000018ffb97819ULL, 0x000fe4000001143bULL,
0x0000008a6840723cULL, 0x000fea0000041840ULL, 0x0000005f00a77306ULL, 0x0004e4000000d400ULL,
0x00000001a8a82812ULL, 0x000fc400078efcffULL, 0x000000717a00720bULL, 0x000fe40003f5d000ULL,
0x000000a89090723eULL, 0x000fe400000010ffULL, 0x000000d800ef7306ULL, 0x000fe20000209400ULL,
0x000000beb35f723eULL, 0x004fe400000010ffULL, 0x000000949300720bULL, 0x002fca0003f7d000ULL,
0x000000d800ee7306ULL, 0x000e620000205400ULL, 0x0000005e6834723cULL, 0x000fe20000041834ULL,
0x0000000170702812ULL, 0x000fe400078efcffULL, 0x0000009faa00720bULL, 0x000fc80003f5d000ULL,
0x00000086b85e723eULL, 0x000fe200000010ffULL, 0x000000d800877306ULL, 0x000ea2000020d400ULL,
0x00000081bd5f723eULL, 0x000fe200000010ffULL, 0x0000010045867824ULL, 0x000fe200078e00ffULL,
0x00000001a7a73812ULL, 0x008fe400078efcffULL, 0x000000eeef00720bULL, 0x002fc60003f3d000ULL,
0x0000007700b77306ULL, 0x000fe20000209400ULL, 0x0000005e6854723cULL, 0x000fe20000041854ULL,
0x00000018ffd37819ULL, 0x000fe20000011486ULL, 0x0000000000ee7919ULL, 0x000e620000000000ULL,
0x000000016c6c2812ULL, 0x000fe400078efcffULL, 0x00000018ffef7819ULL, 0x000fe40000011433ULL,
0x0000007700b37306ULL, 0x000ee20000205400ULL, 0x00010000445e7824ULL, 0x000fe200078e00ffULL,
0x000000d0cd5f723eULL, 0x000fc400000010ffULL, 0x0000000187871812ULL, 0x004fe400078efcffULL,
0x00000018ff8a7819ULL, 0x000fe4000001145eULL, 0x000000d1ce5e723eULL, 0x000fe200000010ffULL,
0x0000007700777306ULL, 0x000ea2000020d400ULL, 0x000000877878723eULL, 0x000fe400000010ffULL,
0x000000a79191723eULL, 0x000fc600000010ffULL, 0x0000005e6858723cULL, 0x000fe20000041858ULL,
0x000000b3b700720bULL, 0x008fe20003f3d000ULL, 0x000000d300b87306ULL, 0x000fea0000209400ULL,
0x000000c8c15e723eULL, 0x000fe400000010ffULL, 0x000000bf8d5f723eULL, 0x000fe200000010ffULL,
0x000000d300bd7306ULL, 0x000ee80000205400ULL, 0x0000000177771812ULL, 0x004fc400078efcffULL,
0x0000005e6850723cULL, 0x000fe40000041850ULL, 0x000000d300867306ULL, 0x000eaa000020d400ULL,
0x000000c4ac5e723eULL, 0x000fe400000010ffULL, 0x000000c08c5f723eULL, 0x000fe200000010ffULL,
0x0000008a00ec7306ULL, 0x000fe20000209400ULL, 0x000000bdb800720bULL, 0x008fca0003f3d000ULL,
0x0000005e683c723cULL, 0x000fe4000004183cULL, 0x0000008a00eb7306ULL, 0x000eea0000205400ULL,
0x00000100465e7824ULL, 0x000fe200078e00ffULL, 0x0000000186861812ULL, 0x004fe200078efcffULL,
0x00000100475f7824ULL, 0x000fe200078e00ffULL, 0x00000044008b7306ULL, 0x000ff00000009400ULL,
0x0000004400be7306ULL, 0x000ea20000005400ULL, 0x000000ebec00720bULL, 0x008fc40003f3d000ULL,
0x00000018ffeb7819ULL, 0x100fe40000011432ULL, 0x00000018ffec7819ULL, 0x000fc60000011432ULL,
0x0000004400817306ULL, 0x000730000000d400ULL, 0x0000004500c37306ULL, 0x000fe20000009400ULL,
0x0001000045447824ULL, 0x008fe200078e00ffULL, 0x000000be8b00720bULL, 0x004fcc0003fbd000ULL,
0x0000004500c17306ULL, 0x000eae0000005400ULL, 0x0000000181815812ULL, 0x010fe200078efcffULL,
0x00000045008d7306ULL, 0x0007e2000000d400ULL, 0x0000009e6d00720bULL, 0x000fce0003fbd000ULL,
0x0000008a00857306ULL, 0x000962000020d400ULL, 0x000000a5a445723eULL, 0x008fe400000010ffULL,
0x00000018ffa47819ULL, 0x000fe4000001145eULL, 0x000000c1c300720bULL, 0x004fe40003fdd000ULL,
0x000000012c2c5812ULL, 0x000fe200078efcffULL, 0x000000a4005e7306ULL, 0x000fe20000209400ULL,
0x00000018ff8a7819ULL, 0x010fe40000011444ULL, 0x000000a6a144723eULL, 0x000fc400000010ffULL,
0x000000999800720bULL, 0x000fc60003fbd000ULL, 0x000000a400c57306ULL, 0x000ea20000205400ULL,
0x0000000185851812ULL, 0x020fe200078efcffULL, 0x00000044684c723cULL, 0x000fe2000004184cULL,
0x000000018d8d6812ULL, 0x000fca00078efcffULL, 0x0000008a00e77306ULL, 0x000fe20000209400ULL,
0x000000a3a044723eULL, 0x000fe400000010ffULL, 0x000000a29d45723eULL, 0x000fe400000010ffULL,
0x0000000129295812ULL, 0x000fc600078efcffULL, 0x0000008a00e37306ULL, 0x000ee20000205400ULL,
0x000000c55e00720bULL, 0x004fe20003f3d000ULL, 0x000000446868723cULL, 0x000fec0000041848ULL,
0x0000008a00a17306ULL, 0x0005e2000020d400ULL, 0x0001000047447824ULL, 0x000fe400078e00ffULL,
0x0000010060457824ULL, 0x000fc600078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x000000a400a67306ULL, 0x000f22000020d400ULL, 0x00000018ff8a7819ULL, 0x004fe4000001145fULL,
0x000000e3e700720bULL, 0x008fca0003fdd000ULL, 0x0000008a005f7306ULL, 0x000ff00000209400ULL,
0x0000008a00d87306ULL, 0x000ea20000205400ULL, 0x00000001a6a61812ULL, 0x010fe400078efcffULL,
0x00000001a1a16812ULL, 0x000fc400078efcffULL, 0x0000009a6e00720bULL, 0x000fc60003fdd000ULL,
0x0000008a00ad7306ULL, 0x000ef0000020d400ULL, 0x0000004400d57306ULL, 0x000fe20000209400ULL,
0x000000d85f00720bULL, 0x004fe40003f3d000ULL, 0x000000012a2a6812ULL, 0x000fca00078efcffULL,
0x0000004400d67306ULL, 0x000eac0000205400ULL, 0x00000001adad1812ULL, 0x008fe400078efcffULL,
0x0000004700c07306ULL, 0x000ff00000009400ULL, 0x0000004700c87306ULL, 0x000fe20000005400ULL,
0x000000d6d500720bULL, 0x004fce0003f3d000ULL, 0x0000004700a07306ULL, 0x0005f0000000d400ULL,
0x0000004600bf7306ULL, 0x000fe20000009400ULL, 0x00000018ff477819ULL, 0x004fe20000011445ULL,
0x0001000060457824ULL, 0x000fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011445ULL,
0x0000004600c27306ULL, 0x000eb00000005400ULL, 0x00000046008c7306ULL, 0x0007f0000000d400ULL,
0x0000004400ac7306ULL, 0x000962000020d400ULL, 0x0001000046467824ULL, 0x008fe200078e00ffULL,
0x000000c2bf00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000006000df7306ULL, 0x000fe20000009400ULL, 0x0000010061447824ULL, 0x010fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011444ULL, 0x0001000061447824ULL, 0x000fe200078e00ffULL,
0x0000006000e07306ULL, 0x000ea20000005400ULL, 0x00000001acac1812ULL, 0x020fe400078efcffULL,
0x000000928f00720bULL, 0x000fe40003f3d000ULL, 0x00000018ff4b7819ULL, 0x000fe40000011444ULL,
0x000000018c8c4812ULL, 0x000fe200078efcffULL, 0x0000004800c67306ULL, 0x000fe60000209400ULL,
0x0000008ca68c723eULL, 0x000fca00000010ffULL, 0x0000004800c77306ULL, 0x000ee20000205400ULL,
0x000000e0df00720bULL, 0x004fe40003f5d000ULL, 0x0000000128281812ULL, 0x000fca00078efcffULL,
0x00000048009d7306ULL, 0x000530000020d400ULL, 0x0000004600d77306ULL, 0x000fe20000209400ULL,
0x0000010062487824ULL, 0x004fe200078e00ffULL, 0x000000c7c600720bULL, 0x008fcc0003fdd000ULL,
0x0000004600d97306ULL, 0x000eae0000205400ULL, 0x000000019d9d6812ULL, 0x010fe200078efcffULL,
0x0000004600ae7306ULL, 0x000ee2000020d400ULL, 0x000000722f00720bULL, 0x000fe40003fdd000ULL,
0x0000009d2828723eULL, 0x000fca00000010ffULL, 0x0000006000a37306ULL, 0x000962000000d400ULL,
0x000000d9d700720bULL, 0x004fca0003f9d000ULL, 0x0000000127276812ULL, 0x000fe400078efcffULL,
0x0000004a00457306ULL, 0x000fe20000209400ULL, 0x00000018ff607819ULL, 0x010fca0000011448ULL,
0x00000001aeae4812ULL, 0x008fe400078efcffULL, 0x0000004a00467306ULL, 0x000ea20000205400ULL,
0x00000001a3a32812ULL, 0x020fce00078efcffULL, 0x0000004a00a57306ULL, 0x000730000020d400ULL,
0x0000006100cc7306ULL, 0x000fe20000009400ULL, 0x00000100634a7824ULL, 0x008fe200078e00ffULL,
0x000000464500720bULL, 0x004fcc0003fbd000ULL, 0x0000006100cd7306ULL, 0x000eae0000005400ULL,
0x00000001a5a55812ULL, 0x010fe200078efcffULL, 0x0000006100a27306ULL, 0x000730000000d400ULL,
0x0000006000487306ULL, 0x000fe20000209400ULL, 0x00000018ff617819ULL, 0x008fe2000001144aULL,
0x00010000624a7824ULL, 0x000fe200078e00ffULL, 0x000000cdcc00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000006000497306ULL, 0x000eb00000205400ULL,
0x0000004700d37306ULL, 0x000fe20000209400ULL, 0x00000001a2a24812ULL, 0x010fc800078efcffULL,
0x000000a2a587723eULL, 0x000fc600000010ffULL, 0x0000004700d47306ULL, 0x000fe20000205400ULL,
0x000000494800720bULL, 0x004fe20003f3d000ULL, 0x0000010030497824ULL, 0x000fcc00078e00ffULL,
0x0000004700a47306ULL, 0x000ff0000020d400ULL, 0x0000004b00447306ULL, 0x000ff00000209400ULL,
0x0000004b00477306ULL, 0x000eb00000205400ULL, 0x0000004a00d07306ULL, 0x000ff00000209400ULL,
0x0000004a00dd7306ULL, 0x000ee20000205400ULL, 0x000000474400720bULL, 0x004fe20003f5d000ULL,
0x000001003b447824ULL, 0x000fca00078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011444ULL,
0x0000004a00947306ULL, 0x0005e2000020d400ULL, 0x000100003a447824ULL, 0x000fca00078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011444ULL, 0x0000006000967306ULL, 0x000962000020d400ULL,
0x00000100654a7824ULL, 0x004fe200078e00ffULL, 0x000000ddd000720bULL, 0x008fc80003fdd000ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000006500e67306ULL, 0x000fe20000009400ULL,
0x0000010064607824ULL, 0x010fca00078e00ffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000006500e87306ULL, 0x000ea20000005400ULL, 0x0000000196961812ULL, 0x020fe400078efcffULL,
0x0000000194946812ULL, 0x000fca00078efcffULL, 0x0000004b00957306ULL, 0x000730000020d400ULL,
0x0000006400e47306ULL, 0x000fe20000009400ULL, 0x00010000634b7824ULL, 0x008fe200078e00ffULL,
0x000000e8e600720bULL, 0x004fc80003f3d000ULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000006400e57306ULL, 0x000ea20000005400ULL, 0x0000000195952812ULL, 0x010fce00078efcffULL,
0x0000004a00cb7306ULL, 0x000ff00000209400ULL, 0x0000004a00cf7306ULL, 0x000fe20000205400ULL,
0x000000e5e400720bULL, 0x004fce0003f5d000ULL, 0x0000004a007e7306ULL, 0x0005f0000020d400ULL,
0x0000006500837306ULL, 0x000ee2000000d400ULL, 0x00010000644a7824ULL, 0x004fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000008200ed7306ULL, 0x000ff00000209400ULL,
0x0000008200ea7306ULL, 0x000ea20000205400ULL, 0x0000000183831812ULL, 0x008fc400078efcffULL,
0x0000007d6f00720bULL, 0x000fe20003f3d000ULL, 0x00010000327d7824ULL, 0x000fe400078e00ffULL,
0x00010000336f7824ULL, 0x000fe400078e00ffULL, 0x0000006300db7306ULL, 0x000fe20000009400ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff6f7819ULL, 0x000fca000001146fULL,
0x0000006300dc7306ULL, 0x000ee20000005400ULL, 0x000000eaed00720bULL, 0x004fe40003f7d000ULL,
0x0000000124241812ULL, 0x000fca00078efcffULL, 0x0000006200da7306ULL, 0x000ff00000009400ULL,
0x0000006200de7306ULL, 0x000fe20000005400ULL, 0x000000dcdb00720bULL, 0x008fce0003fbd000ULL,
0x0000006200977306ULL, 0x0005f0000000d400ULL, 0x00000064008b7306ULL, 0x000ee2000000d400ULL,
0x00000018ff627819ULL, 0x004fce000001143aULL, 0x0000004a00e17306ULL, 0x000ff00000209400ULL,
0x0000004a00e27306ULL, 0x000ea20000205400ULL, 0x000000018b8b2812ULL, 0x008fce00078efcffULL,
0x0000005d00be7306ULL, 0x000ff00000209400ULL, 0x0000005d00c17306ULL, 0x000fe20000205400ULL,
0x000000e2e100720bULL, 0x004fce0003f5d000ULL, 0x0000005d007b7306ULL, 0x0005f0000020d400ULL,
0x0000004b00ce7306ULL, 0x000fe20000209400ULL, 0x00010000665d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000004b00d17306ULL, 0x000eb00000205400ULL,
0x0000004b00897306ULL, 0x000730000020d400ULL, 0x0000006200627306ULL, 0x000f620000209400ULL,
0x00010000654b7824ULL, 0x008fe200078e00ffULL, 0x000000d1ce00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x0000005d00bd7306ULL, 0x000fee0000209400ULL,
0x0000000189896812ULL, 0x010fe200078efcffULL, 0x0000005d00647306ULL, 0x000fe20000205400ULL,
0x000000ffffc77224ULL, 0x020fce00078e0062ULL, 0x0000005d00757306ULL, 0x0005f0000020d400ULL,
0x0000008200827306ULL, 0x000ee2000020d400ULL, 0x00000100395d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000006300937306ULL, 0x000eb0000000d400ULL,
0x0000004b00c37306ULL, 0x000fe20000209400ULL, 0x0000000182823812ULL, 0x008fc400078efcffULL,
0x000000c8c000720bULL, 0x000fca0003f7d000ULL, 0x0000004b00d27306ULL, 0x000ee20000205400ULL,
0x0000000193935812ULL, 0x004fe400078efcffULL, 0x0000002e7300720bULL, 0x000fca0003fbd000ULL,
0x0000004a00887306ULL, 0x000522000020d400ULL, 0x00000001a0a03812ULL, 0x000fe400078efcffULL,
0x000000d4d300720bULL, 0x000fe40003f7d000ULL, 0x00000018ffd47819ULL, 0x100fe40000011430ULL,
0x00000018ffd37819ULL, 0x000fe20000011430ULL, 0x0000006000767306ULL, 0x000fe20000209400ULL,
0x00000100674a7824ULL, 0x004fe200078e00ffULL, 0x000000d2c300720bULL, 0x008fe20003f3d000ULL,
0x0000010031c37824ULL, 0x000fe200078e00ffULL, 0x0000000126265812ULL, 0x000fc400078efcffULL,
0x000000b09b00720bULL, 0x000fe40003fbd000ULL, 0x0000006000ca7306ULL, 0x000ea20000205400ULL,
0x0000000188882812ULL, 0x010fe400078efcffULL, 0x000000847f00720bULL, 0x000fe40003f5d000ULL,
0x00000001a4a43812ULL, 0x000fe400078efcffULL, 0x000000deda00720bULL, 0x000fe20003f7d000ULL,
0x0000006100c47306ULL, 0x000fe20000209400ULL, 0x00000006ee847811ULL, 0x002fc400078fe0ffULL,
0x00000018ffc37819ULL, 0x000fe400000114c3ULL, 0x0000000784847812ULL, 0x000fe400078e78b1ULL,
0x0000000125255812ULL, 0x000fe200078efcffULL, 0x0000006100c97306ULL, 0x000e620000205400ULL,
0x000000ca7600720bULL, 0x004fe40003fdd000ULL, 0x0000000123232812ULL, 0x000fe400078efcffULL,
0x0000000197973812ULL, 0x000fc400078efcffULL, 0x000000942626723eULL, 0x000fe200000010ffULL,
0x00000061008e7306ULL, 0x0004e2000020d400ULL, 0x000000979696723eULL, 0x000fe400000010ffULL,
0x000000882424723eULL, 0x000fca00000010ffULL, 0x0000005d00b37306ULL, 0x000fe20000209400ULL,
0x0000010038617824ULL, 0x004fe200078e00ffULL, 0x000000c9c400720bULL, 0x002fc80003f9d000ULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000005d00b27306ULL, 0x000fee0000205400ULL,
0x000000018e8e4812ULL, 0x008fe200078efcffULL, 0x0000005d00637306ULL, 0x0003e6000020d400ULL,
0x000000938e97723eULL, 0x000fca00000010ffULL, 0x0000003800e37306ULL, 0x000fe20000009400ULL,
0x00010000385d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000003800e77306ULL, 0x000e700000005400ULL, 0x00000038006e7306ULL, 0x0004f0000000d400ULL,
0x0000003900df7306ULL, 0x000fe20000009400ULL, 0x0001000039387824ULL, 0x004fe200078e00ffULL,
0x000000e7e300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003900e07306ULL, 0x000fee0000005400ULL, 0x000000016e6e5812ULL, 0x008fe200078efcffULL,
0x0000003900657306ULL, 0x0003e2000000d400ULL, 0x000000f9fa00720bULL, 0x000fce0003fbd000ULL,
0x00000060008a7306ULL, 0x0004e2000020d400ULL, 0x000001003a397824ULL, 0x002fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00bb7306ULL, 0x000fe20000009400ULL,
0x00000018ff607819ULL, 0x004fe4000001144aULL, 0x0000000108085812ULL, 0x000fca00078efcffULL,
0x0000003a00bc7306ULL, 0x000fe20000005400ULL, 0x000000018a8a6812ULL, 0x008fe400078efcffULL,
0x000000cfcb00720bULL, 0x000fca0003fdd000ULL, 0x0000003a00627306ULL, 0x0003f0000000d400ULL,
0x0000004b007c7306ULL, 0x000ea2000020d400ULL, 0x00000002ee3a7811ULL, 0x002fe400078fe0ffULL,
0x000000017e7e6812ULL, 0x000fc400078efcffULL, 0x000000073a3a7812ULL, 0x000fe400078e78b1ULL,
0x000000e0df00720bULL, 0x000fe20003fdd000ULL, 0x00000060004a7306ULL, 0x000fe20000209400ULL,
0x000000837e83723eULL, 0x000fe200000010ffULL, 0x00000008b1767824ULL, 0x000fca00078e023aULL,
0x0001200076447811ULL, 0x000fe200078e20ffULL, 0x00000060004b7306ULL, 0x000e620000205400ULL,
0x000000017c7c1812ULL, 0x004fe400078efcffULL, 0x000000c1be00720bULL, 0x000fe40003f3d000ULL,
0x0000000165656812ULL, 0x000fe400078efcffULL, 0x000000fbfc00720bULL, 0x000fe20003fdd000ULL,
0x0000006000717306ULL, 0x0004f0000020d400ULL, 0x00000045009a7306ULL, 0x000fe20000209400ULL,
0x0001000067607824ULL, 0x004fe200078e00ffULL, 0x0000004b4a00720bULL, 0x002fc40003f5d000ULL,
0x000000017b7b1812ULL, 0x000fe400078efcffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x00000045009b7306ULL, 0x000fe20000205400ULL, 0x00000064bd00720bULL, 0x000fe40003f3d000ULL,
0x000000010b0b6812ULL, 0x000fc800078efcffULL, 0x0000000171712812ULL, 0x008fe200078efcffULL,
0x0000006000ea7306ULL, 0x000fec0000209400ULL, 0x0000000175751812ULL, 0x000fe400078efcffULL,
0x0000006000c87306ULL, 0x000e620000205400ULL, 0x000000f6f700720bULL, 0x000fce0003f3d000ULL,
0x00000045005e7306ULL, 0x0005ec000020d400ULL, 0x0000000121211812ULL, 0x000fe400078efcffULL,
0x0000006600bf7306ULL, 0x000fe20000009400ULL, 0x000000004444783bULL, 0x004ea20000000200ULL,
0x000000c8ea00720bULL, 0x002fc40003f5d000ULL, 0x000000b2b300720bULL, 0x000fc80003f3d000ULL,
0x0000006600c07306ULL, 0x000e700000005400ULL, 0x0000006700c27306ULL, 0x000fe20000009400ULL,
0x0000000163631812ULL, 0x000fce00078efcffULL, 0x0000006700ed7306ULL, 0x000ee20000005400ULL,
0x000000c0bf00720bULL, 0x002fce0003f7d000ULL, 0x0000006700747306ULL, 0x000e70000000d400ULL,
0x0000006000677306ULL, 0x000f22000020d400ULL, 0x0000002d44448231ULL, 0x084fe200003400ffULL,
0x000000edc200720bULL, 0x008fe20003f9d000ULL, 0x0000002d46468231ULL, 0x000fc400003400ffULL,
0x0000002b45458231ULL, 0x080fe400003400ffULL, 0x0000002b47478231ULL, 0x000fe200003400ffULL,
0x0000006100b77306ULL, 0x000fec0000209400ULL, 0x000000904454723cULL, 0x000fe20000041854ULL,
0x0000000174744812ULL, 0x002fe200078efcffULL, 0x0000006100b87306ULL, 0x000e620000205400ULL,
0x0000000167672812ULL, 0x010fc400078efcffULL, 0x000000bcbb00720bULL, 0x000fe40003f9d000ULL,
0x000000817790723eULL, 0x000fe400000010ffULL, 0x0000008d8691723eULL, 0x000fe200000010ffULL,
0x000000ab00ab7306ULL, 0x000ea20000205400ULL, 0x000000a0ad8d723eULL, 0x000fe400000010ffULL,
0x000000a3a486723eULL, 0x000fc600000010ffULL, 0x000000904450723cULL, 0x000fe40000041850ULL,
0x000000b900b97306ULL, 0x000ee20000205400ULL, 0x000000b8b700720bULL, 0x002fe40003f5d000ULL,
0x0000000162624812ULL, 0x000fc600078efcffULL, 0x0000008c444c723cULL, 0x000fe4000004184cULL,
0x000000ba00ba7306ULL, 0x000e620000209400ULL, 0x000000ffffc67224ULL, 0x004fc800078e00abULL,
0x000000ffffde7224ULL, 0x000fe200078e00c6ULL, 0x00000018ffc67819ULL, 0x000fe40000011449ULL,
0x00000061006d7306ULL, 0x000ea2000020d400ULL, 0x000000ffffd97224ULL, 0x008fe200078e00b9ULL,
0x000000b4b649723eULL, 0x000fe200000010ffULL, 0x0001000030b67824ULL, 0x000fe200078e00ffULL,
0x000000dec700720bULL, 0x000fe20003f9d000ULL, 0x000000ffffcc7224ULL, 0x000fe200078e00d9ULL,
0x00000018ffd97819ULL, 0x000fe20000011431ULL, 0x0000010032b47824ULL, 0x000fe200078e00ffULL,
0x0000005d00d87306ULL, 0x000fe20000209400ULL, 0x000000ffffd67224ULL, 0x002fe200078e00baULL,
0x00000018ffb67819ULL, 0x000fc400000114b6ULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x000000ffffcd7224ULL, 0x000fe200078e00d6ULL, 0x00000018ffd67819ULL, 0x000fe40000011431ULL,
0x0000005d00c57306ULL, 0x000e620000205400ULL, 0x000000016d6d2812ULL, 0x004fe400078efcffULL,
0x000000011b1b4812ULL, 0x000fca00078efcffULL, 0x0000004800c47306ULL, 0x000ff00000209400ULL,
0x0000004800bf7306ULL, 0x000fe20000205400ULL, 0x000000c5d800720bULL, 0x002fce0003f5d000ULL,
0x00000048005f7306ULL, 0x0003f0000020d400ULL, 0x0000003800d77306ULL, 0x000fe20000209400ULL,
0x00000004ee487811ULL, 0x002fe400078fe0ffULL, 0x00000018ffee7819ULL, 0x000fc40000011433ULL,
0x0000000748487812ULL, 0x000fc600078e78b1ULL, 0x0000003800d57306ULL, 0x000e640000205400ULL,
0x00000008b1b07824ULL, 0x000fe200078e0248ULL, 0x0000009cb548723eULL, 0x000fe200000010ffULL,
0x0001000031b57824ULL, 0x000fe400078e00ffULL, 0x00000008b1b17824ULL, 0x000fe400078e0284ULL,
0x00000066007a7306ULL, 0x000ea2000000d400ULL, 0x00000100339c7824ULL, 0x000fe200078e00ffULL,
0x000000484440723cULL, 0x000fe20000041840ULL, 0x00000018ffb57819ULL, 0x000fc600000114b5ULL,
0x00000018ff9c7819ULL, 0x000fe4000001149cULL, 0x0000003800607306ULL, 0x000ee2000020d400ULL,
0x00012000b1487811ULL, 0x000fe400078e20ffULL, 0x000000d5d700720bULL, 0x002fc80003f3d000ULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x00000039009e7306ULL, 0x000fe20000209400ULL,
0x000000017a7a3812ULL, 0x004fe400078efcffULL, 0x000000f0f300720bULL, 0x000fe40003f7d000ULL,
0x0000007a7b7a723eULL, 0x000fe400000010ffULL, 0x00000074717b723eULL, 0x000fe200000010ffULL,
0x00000039009f7306ULL, 0x000fe20000205400ULL, 0x0000000160601812ULL, 0x008fc400078efcffULL,
0x0000009b9a00720bULL, 0x000fca0003f3d000ULL, 0x0000003900617306ULL, 0x000fe2000020d400ULL,
0x0000000122223812ULL, 0x000fc800078efcffULL, 0x000000752222723eULL, 0x000fc600000010ffULL,
0x0000005d00667306ULL, 0x000ea2000020d400ULL, 0x000000015e5e1812ULL, 0x000fce00078efcffULL,
0x0000003000aa7306ULL, 0x000fe20000009400ULL, 0x0000002d48488231ULL, 0x002fce00003400ffULL,
0x0000003000ab7306ULL, 0x000fe20000005400ULL, 0x0000000166662812ULL, 0x004fe200078efcffULL,
0x0000002d4a4a8231ULL, 0x000fe200003400ffULL, 0x0000009f9e00720bULL, 0x000fe20003f5d000ULL,
0x0000002b49498231ULL, 0x080fe200003400ffULL, 0x000000660866723eULL, 0x000fe200000010ffULL,
0x0000002b4b4b8231ULL, 0x000fe400003400ffULL, 0x0000003000397306ULL, 0x0003f0000000d400ULL,
0x0000003100987306ULL, 0x000fe20000009400ULL, 0x000000af8030723eULL, 0x002fc400000010ffULL,
0x0000000161612812ULL, 0x000fe400078efcffULL, 0x000000bfc400720bULL, 0x000fe40003f5d000ULL,
0x000000626162723eULL, 0x000fe200000010ffULL, 0x0000003100997306ULL, 0x000e700000005400ULL,
0x0000003100387306ULL, 0x0004e4000000d400ULL, 0x000000015f5f2812ULL, 0x000fcc00078efcffULL,
0x00000032008f7306ULL, 0x000fe20000009400ULL, 0x000000a97931723eULL, 0x004fe400000010ffULL,
0x000000827079723eULL, 0x000fe400000010ffULL, 0x000000999800720bULL, 0x002fe40003fbd000ULL,
0x0000008b8a82723eULL, 0x000fe200000010ffULL, 0x0000003200927306ULL, 0x000e620000005400ULL,
0x000000304434723cULL, 0x040fee0000041834ULL, 0x00000032002f7306ULL, 0x0005e2000000d400ULL,
0x000000784458723cULL, 0x000fe20000041858ULL, 0x0000000138385812ULL, 0x008fcc00078efcffULL,
0x0000003300727306ULL, 0x000fe20000009400ULL, 0x00012000b0327811ULL, 0x004fe400078e20ffULL,
0x000000856c78723eULL, 0x000fe400000010ffULL, 0x000000a12c79723eULL, 0x000fe400000010ffULL,
0x000000928f00720bULL, 0x002fe20003fdd000ULL, 0x0000003300737306ULL, 0x000e680000005400ULL,
0x00000078443c723cULL, 0x000fe8000004183cULL, 0x00000033002e7306ULL, 0x0005e6000000d400ULL,
0x000000ac2979723eULL, 0x000fc400000010ffULL, 0x000000952729723eULL, 0x000fe400000010ffULL,
0x000000ae2a78723eULL, 0x000fe200000010ffULL, 0x0000003b00b97306ULL, 0x000fe20000009400ULL,
0x000000003230783bULL, 0x004ea20000000200ULL, 0x000000892527723eULL, 0x000fe400000010ffULL,
0x0000007c2325723eULL, 0x000fe400000010ffULL, 0x000000784468723cULL, 0x000fe20000041868ULL,
0x000000672123723eULL, 0x000fe200000010ffULL, 0x0000003b00ba7306ULL, 0x000ee20000005400ULL,
0x000000600b67723eULL, 0x000fc400000010ffULL, 0x000000737200720bULL, 0x002fe40003f9d000ULL,
0x000000012f2f6812ULL, 0x000fc600078efcffULL, 0x0000003b005d7306ULL, 0x000330000000d400ULL,
0x000000c6007f7306ULL, 0x000fe20000209400ULL, 0x000100003b3b7824ULL, 0x002fe200078e00ffULL,
0x000000bab900720bULL, 0x008fc40003f7d000ULL, 0x000000012e2e4812ULL, 0x000fe400078efcffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x000000c600847306ULL, 0x000e6e0000205400ULL,
0x000000015d5d3812ULL, 0x010fe200078efcffULL, 0x0000003b00c27306ULL, 0x000fe20000209400ULL,
0x0000002d30308231ULL, 0x084fe200003400ffULL, 0x000000cccd00720bULL, 0x000fe20003f7d000ULL,
0x0000002d32328231ULL, 0x000fc400003400ffULL, 0x0000002b31318231ULL, 0x080fe400003400ffULL,
0x0000002b33338231ULL, 0x000fe200003400ffULL, 0x0000003b00c07306ULL, 0x000ea20000205400ULL,
0x000000847f00720bULL, 0x002fe40003f5d000ULL, 0x000000abaa00720bULL, 0x000fc60003f1d000ULL,
0x000000283034723cULL, 0x040fe20000041834ULL, 0x000000011c1c3812ULL, 0x000fe200078efcffULL,
0x0000003b003a7306ULL, 0x000e6c000020d400ULL, 0x000000263058723cULL, 0x000fe40000041858ULL,
0x000000c300807306ULL, 0x000fe20000209400ULL, 0x000000c0c200720bULL, 0x004fc40003f3d000ULL,
0x0000000139390812ULL, 0x000fc600078efcffULL, 0x000000863040723cULL, 0x040fe40000041840ULL,
0x000000c300a77306ULL, 0x000eac0000205400ULL, 0x000000013a3a1812ULL, 0x002fe200078efcffULL,
0x000000963054723cULL, 0x040fe20000041854ULL, 0x000000c6003b7306ULL, 0x000e6e000020d400ULL,
0x000000823050723cULL, 0x000fe20000041850ULL, 0x000000b600707306ULL, 0x000fe20000209400ULL,
0x000000a78000720bULL, 0x004fcc0003f3d000ULL, 0x00000024303c723cULL, 0x000fe2000004183cULL,
0x000000b600777306ULL, 0x000ea20000205400ULL, 0x000000013b3b2812ULL, 0x002fca00078efcffULL,
0x0000006e6d24723eULL, 0x000fe200000010ffULL, 0x0000007a304c723cULL, 0x000fe2000004184cULL,
0x000000c300647306ULL, 0x000e62000020d400ULL, 0x000000656325723eULL, 0x000fe400000010ffULL,
0x0000005d5e63723eULL, 0x000fc800000010ffULL, 0x000000223068723cULL, 0x000fe20000041868ULL,
0x000000b5002a7306ULL, 0x000fe20000209400ULL, 0x000000777000720bULL, 0x004fca0003f5d000ULL,
0x0000005f1b22723eULL, 0x000fe200000010ffULL, 0x000000244840723cULL, 0x000fe20000041840ULL,
0x000000b500817306ULL, 0x000ea20000205400ULL, 0x0000000164641812ULL, 0x002fe400078efcffULL,
0x0000003a1c23723eULL, 0x000fc600000010ffULL, 0x000000393b24723eULL, 0x000fe200000010ffULL,
0x000000664834723cULL, 0x000fe20000041834ULL, 0x000000b6002c7306ULL, 0x000e62000020d400ULL,
0x000000386425723eULL, 0x000fcc00000010ffULL, 0x000000624854723cULL, 0x000fe20000041854ULL,
0x000000d600d67306ULL, 0x000fe20000205400ULL, 0x000000812a00720bULL, 0x004fcc0003f3d000ULL,
0x000000224858723cULL, 0x000fe20000041858ULL, 0x000000d900d97306ULL, 0x000ea20000209400ULL,
0x000000012c2c2812ULL, 0x002fcc00078efcffULL, 0x000000244850723cULL, 0x000fe20000041850ULL,
0x000000d300d37306ULL, 0x000ff00000205400ULL, 0x000000d400d47306ULL, 0x000e620000209400ULL,
0x000000d6d900720bULL, 0x004fce0003f1d000ULL, 0x000000b4002d7306ULL, 0x000fec0000209400ULL,
0x000000011e1e0812ULL, 0x000fe400078efcffULL, 0x000000b400287306ULL, 0x000ea20000205400ULL,
0x000000d3d400720bULL, 0x002fce0003f7d000ULL, 0x000000b5002b7306ULL, 0x000e6c000020d400ULL,
0x000000011d1d3812ULL, 0x000fe400078efcffULL, 0x000000b400447306ULL, 0x000ee2000020d400ULL,
0x000000282d00720bULL, 0x004fce0003f5d000ULL, 0x0000009c00277306ULL, 0x000fe20000209400ULL,
0x000000012b2b1812ULL, 0x002fc800078efcffULL, 0x0000002b1e2b723eULL, 0x000fc600000010ffULL,
0x0000009c00467306ULL, 0x000e620000205400ULL, 0x0000000144442812ULL, 0x008fc800078efcffULL,
0x0000002f4444723eULL, 0x000fc600000010ffULL, 0x000000ec00ec7306ULL, 0x000ff00000205400ULL,
0x000000eb00eb7306ULL, 0x000ea20000209400ULL, 0x000000462700720bULL, 0x002fce0003f3d000ULL,
0x000000ef00ef7306ULL, 0x000ff00000205400ULL, 0x000000ee00ee7306ULL, 0x000e620000209400ULL,
0x000000eceb00720bULL, 0x004fce0003fbd000ULL, 0x0000007d00217306ULL, 0x000fec0000209400ULL,
0x000000011f1f5812ULL, 0x000fe400078efcffULL, 0x0000007d00267306ULL, 0x000ea20000205400ULL,
0x000000efee00720bULL, 0x002fce0003f7d000ULL, 0x0000006f000b7306ULL, 0x000fec0000209400ULL,
0x0000000120203812ULL, 0x000fe400078efcffULL, 0x0000006f002a7306ULL, 0x000e620000205400ULL,
0x000000262100720bULL, 0x004fce0003f1d000ULL, 0x0000009c00457306ULL, 0x000eb0000020d400ULL,
0x0000007d00087306ULL, 0x000ee2000020d400ULL, 0x0000002a0b00720bULL, 0x002fe40003f5d000ULL,
0x0000002c1d2a723eULL, 0x000fca00000010ffULL, 0x0000006f006f7306ULL, 0x000e62000020d400ULL,
0x0000000145451812ULL, 0x004fe200078efcffULL, 0x0000002a483c723cULL, 0x000fe6000004183cULL,
0x0000002e4545723eULL, 0x000fe400000010ffULL, 0x0000000108080812ULL, 0x008fc800078efcffULL,
0x000000081f1c723eULL, 0x000fe200000010ffULL, 0x00000044484c723cULL, 0x000fe2000004184cULL,
0x000000016f6f2812ULL, 0x002fc800078efcffULL, 0x0000006f201d723eULL, 0x000fce00000010ffULL,
0x0000001c4848723cULL, 0x000fe20000041868ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff13ff7812ULL, 0x000fe2000782c0ffULL,
0x01c61000ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000040030b7811ULL, 0x000fe400078e40ffULL,
0x00000001ff2e7807ULL, 0x000fe40000800000ULL, 0x0000000b0200720cULL, 0x000fe40003f24070ULL,
0x000000ff12ff7812ULL, 0x000fc4000784c0ffULL, 0x000000011000780cULL, 0x000fe40003f05270ULL,
0x00000001ff1b7807ULL, 0x000fe40001000000ULL, 0x000000132e137207ULL, 0x000fe40004000000ULL,
0x000000010c0c7812ULL, 0x000fe400078e0cffULL, 0x000076101b127816ULL, 0x000fe20000000012ULL,
0x0000e03000009947ULL, 0x000fea0003800000ULL, 0x01c65c00ff0b7984ULL, 0x000e620000000800ULL,
0x800000001b087824ULL, 0x000fca00078e00ffULL, 0x800000000bff7812ULL, 0x002fe20007824808ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007824808ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff087424ULL, 0x000fe400078e00ffULL, 0x800000001b0c7824ULL, 0x000fe400078e00ffULL,
0x00000008000b7305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x0000000b0000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc4000782480cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000137919ULL, 0x000e620000002600ULL,
0x00000080030b7811ULL, 0x040fe200078e40ffULL, 0x00000100ff317424ULL, 0x000fe200078e00ffULL,
0x00000001031d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000127919ULL, 0x000ea20000002700ULL,
0x0000000b02087217ULL, 0x000fe20007800000ULL, 0x0000400010ef7824ULL, 0x000fe200078e00ffULL,
0x000000041d00720cULL, 0x000fe20003f26070ULL, 0x00000000001c7919ULL, 0x000ee40000000000ULL,
0x0000000108087824ULL, 0x000fe200078e0a0bULL, 0x0000580013137a10ULL, 0x002fe20007ffe0ffULL,
0x0000000212127824ULL, 0x004fc800078e00ffULL, 0x0000580012127a24ULL, 0x000fe200078e0213ULL,
0x00000004ff0c7819ULL, 0x008fe2000001161cULL, 0x000000101c337824ULL, 0x000fe400078e00ffULL,
0x00006200122f7a24ULL, 0x000fe200078e020bULL, 0x000000020c327810ULL, 0x000fe40007ffe0ffULL,
0x000000f033337812ULL, 0x000fe400078ec0ffULL, 0x0000000c2f127210ULL, 0x140fe40007ffe0f8ULL,
0x000000322f1c7210ULL, 0x000fc40007ffe0f8ULL, 0x000000060c447810ULL, 0x000fe20007ffe0ffULL,
0x00005e0012127625ULL, 0x080fe200078e0031ULL, 0x000000040c5e7810ULL, 0x040fe40007ffe0ffULL,
0x000000080c3a7810ULL, 0x000fe20007ffe0ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e0031ULL,
0x0000003312227210ULL, 0x080fe40007f5e0ffULL, 0x0000005e2f127210ULL, 0x140fe40007ffe0f8ULL,
0x0000000a0c387810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200010e0613ULL,
0x000000331c247210ULL, 0x000fe20007f5e0ffULL, 0x00005e0012127625ULL, 0x000fe200078e0031ULL,
0x000000442f1c7210ULL, 0x000fc40007ffe0f8ULL, 0x0000003a2f1e7210ULL, 0x140fe20007ffe0f8ULL,
0x000000ffff257224ULL, 0x000fe200010e061dULL, 0x0000000c0c307810ULL, 0x000fe20007ffe0ffULL,
0x00005e001c1c7625ULL, 0x080fe200078e0031ULL, 0x00000040080b7807ULL, 0x000fe40000800000ULL,
0x000000382f207210ULL, 0x140fe20007ffe0f8ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0031ULL,
0x000000331c287210ULL, 0x080fe40007f7e0ffULL, 0x0000003312267210ULL, 0x000fe20007f5e0ffULL,
0x00000008101c7824ULL, 0x000fe200078e00ffULL, 0x000000302f127210ULL, 0x000fe20007ffe0f8ULL,
0x00005e0020207625ULL, 0x000fe200078e0031ULL, 0x0000000bf80b7217ULL, 0x000fc40007800000ULL,
0x0000000e0c467810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe200010e0613ULL,
0x000000331e2a7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0012127625ULL, 0x000fe200078e0031ULL,
0x000000081c087812ULL, 0x000fe400078ec0ffULL, 0x000000462f1e7210ULL, 0x100fe20007ffe0f8ULL,
0x000000010b0b7824ULL, 0x000fe200078e0af8ULL, 0x00000033202c7210ULL, 0x080fe20007f5e0ffULL,
0x00000000080473c2ULL, 0x000e6200000e0000ULL, 0x000000ffff2b7224ULL, 0x000fe200020e061fULL,
0x00004000ef207812ULL, 0x000fe200078ec0ffULL, 0x000000ffff297224ULL, 0x000fe200018e061dULL,
0x0000003312127210ULL, 0x000fe20007f3e0ffULL, 0x00005e001e1e7625ULL, 0x000fe200078e0031ULL,
0x0000000b0c00720cULL, 0x000fc40003f86070ULL, 0x0000000b3200720cULL, 0x080fe20003fa6070ULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x0000000b5e00720cULL, 0x000fe20003f66070ULL,
0x000000ffff2d7224ULL, 0x000fe200010e0621ULL, 0x0001400020207810ULL, 0x000fe40007ffe0ffULL,
0x000000331e1e7210ULL, 0x000fe40007f3e0ffULL, 0x0000000b3a00720cULL, 0x000fe20003f46070ULL,
0x00000010f51d7824ULL, 0x100fe200078e0220ULL, 0x000000081c0c7812ULL, 0x000fe200078e0cffULL,
0x00000010f4217824ULL, 0x000fc400078e0220ULL, 0x00000010f22f7824ULL, 0x100fe200078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221d7faeULL, 0x0005e2000e101c46ULL,
0x000000ffff1f7224ULL, 0x000fe200008e061fULL, 0x0000000b4400720cULL, 0x080fe20003f26070ULL,
0x00000010f1317824ULL, 0x100fe200078e0220ULL, 0x0000000b3800720cULL, 0x080fe20003f86070ULL,
0x0000000024217faeULL, 0x0007e2000e901c46ULL, 0x0000000b3000720cULL, 0x080fe20003fa6070ULL,
0x0000001015337824ULL, 0x100fe200078e0220ULL, 0x0001c64804047890ULL, 0x002fe2000fffe03fULL,
0x00000000262f7faeULL, 0x0003e2000d901c46ULL, 0x0000000b4600720cULL, 0x000fe20003f66070ULL,
0x00000010140b7824ULL, 0x000fc400078e0220ULL, 0x00000010161d7824ULL, 0x104fe400078e0220ULL,
0x0000000028317faeULL, 0x0003e2000c901c46ULL, 0x0000001017217824ULL, 0x008fc600078e0220ULL,
0x000000002a0b7faeULL, 0x0003e8000d101c46ULL, 0x000000002c337faeULL, 0x0003e8000e101c46ULL,
0x00000000121d7faeULL, 0x0003e8000e901c46ULL, 0x000000001e217faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c64c000c137984ULL, 0x0022a20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c61c00ff0c7984ULL, 0x002e620000000800ULL,
0x000000e92e0b7207ULL, 0x000fe20004000000ULL, 0x80000000181d7824ULL, 0x000fc600078e00ffULL,
0x0000ffff0b087812ULL, 0x000fc800078ec0ffULL, 0x00008880081e7816ULL, 0x000fca00000000ffULL,
0x800000001e087824ULL, 0x000fca00078e00ffULL, 0x8000000013ff7812ULL, 0x004fe40007804808ULL,
0x800000000cff7812ULL, 0x002fe2000782481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fe400078e00ffULL,
0x8000000018137824ULL, 0x000fe400078e00ffULL, 0x00000008000c7305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x0000000c0000735dULL, 0x004fe40003800000ULL,
0x01c61c00ff0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fc40007824813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x01c0800019087984ULL, 0x000e620000000800ULL, 0x00000001ff947424ULL, 0x000fc600078e00ffULL,
0x01c28000190c7984ULL, 0x0004e20000000800ULL, 0x000000050800720bULL, 0x002fda0003f3d000ULL,
0x0000000000127806ULL, 0x000fc800008e0100ULL, 0x0000ffff121d7812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000050800720bULL, 0x00cfe20003f34000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0x0000000805247209ULL, 0x000fca0007810000ULL,
0x8000002405127221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b12127820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fe400008e0100ULL, 0x0000001200137308ULL, 0x000ea20000000800ULL,
0x000000010000780cULL, 0x000fe40003f25270ULL, 0x0000ffff05227812ULL, 0x000fc800078e3cffULL,
0x000000221dff7212ULL, 0x000fe4000784c0ffULL, 0x00000002ff267819ULL, 0x102fe4000001161fULL,
0x00000002ff1f7819ULL, 0x000fc6000001161fULL, 0x01c4802419009388ULL, 0x000fe20000000800ULL,
0x00000001ff947807ULL, 0x000fe20001000000ULL, 0x0000001306067220ULL, 0x004fe20000410000ULL,
0x000000081f1f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f2613057589ULL, 0x000e6400000e0000ULL,
0x80000024081d2221ULL, 0x000fe40000010000ULL, 0x00001f1f13087589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b1d1d2820ULL, 0x000fc80000410000ULL, 0x0000001d00072308ULL, 0x000ee20000000800ULL,
0x0000000540407220ULL, 0x082fe40000410000ULL, 0x0000000541417220ULL, 0x080fe40000410000ULL,
0x0000000534347220ULL, 0x080fe40000410000ULL, 0x0000000535357220ULL, 0x080fe40000410000ULL,
0x0000000554547220ULL, 0x080fe40000410000ULL, 0x0000000555557220ULL, 0x000fc40000410000ULL,
0x0000000558587220ULL, 0x080fe40000410000ULL, 0x0000000559597220ULL, 0x080fe40000410000ULL,
0x0000000550507220ULL, 0x080fe40000410000ULL, 0x0000000551517220ULL, 0x080fe40000410000ULL,
0x000000053c3c7220ULL, 0x080fe40000410000ULL, 0x000000053d3d7220ULL, 0x000fc40000410000ULL,
0x000000054c4c7220ULL, 0x080fe40000410000ULL, 0x000000054d4d7220ULL, 0x080fe40000410000ULL,
0x0000000548487220ULL, 0x080fe40000410000ULL, 0x0000000549497220ULL, 0x000fe40000410000ULL,
0x0000000842427220ULL, 0x084fe40000410000ULL, 0x0000000843437220ULL, 0x000fc40000410000ULL,
0x0000000836367220ULL, 0x080fe40000410000ULL, 0x0000000837377220ULL, 0x080fe40000410000ULL,
0x0000000856567220ULL, 0x080fe40000410000ULL, 0x0000000857577220ULL, 0x080fe40000410000ULL,
0x000000085a5a7220ULL, 0x080fe40000410000ULL, 0x000000085b5b7220ULL, 0x000fc40000410000ULL,
0x0000000852527220ULL, 0x080fe40000410000ULL, 0x0000000853537220ULL, 0x080fe40000410000ULL,
0x000000083e3e7220ULL, 0x080fe40000410000ULL, 0x000000083f3f7220ULL, 0x080fe40000410000ULL,
0x000000084e4e7220ULL, 0x080fe40000410000ULL, 0x000000084f4f7220ULL, 0x000fc40000410000ULL,
0x000000084a4a7220ULL, 0x080fe40000410000ULL, 0x000000084b4b7220ULL, 0x000fe40000410000ULL,
0x000000ffff057224ULL, 0x000fe400078e0024ULL, 0x0000000c070c2220ULL, 0x008fc80000410000ULL,
0x000000060c067221ULL, 0x00cfe20000010000ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000000810127824ULL, 0x000fe400078e00ffULL, 0x800000001e137824ULL, 0x000fc600078e00ffULL,
0x0000000812127812ULL, 0x000fca00078e0cffULL, 0x01c64c0012087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000001e137824ULL, 0x000fe400078e00ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x00000008000c7305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x0000000c0000735dULL, 0x004fe40003800000ULL,
0x01c64c00120c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fc40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00001000010c7983ULL, 0x000ea20000100800ULL, 0x00000001101d7812ULL, 0x000fc600078e0cffULL,
0x0000000000d87919ULL, 0x000e620000000000ULL, 0x000140001d1d7811ULL, 0x000fca00078e70ffULL,
0x00000010111e7824ULL, 0x000fca00078e021dULL, 0x000000001e64783bULL, 0x000fe20000004200ULL,
0x000000100c087824ULL, 0x004fca00078e021dULL, 0x0000000801007387ULL, 0x000fe80000100800ULL,
0x000000000844783bULL, 0x0004e40000004200ULL, 0x000000101a087824ULL, 0x004fca00078e021dULL,
0x0000040801007387ULL, 0x000fe80000100800ULL, 0x0000081e01007387ULL, 0x0005e80000100800ULL,
0x000000000830783bULL, 0x000f220000004200ULL, 0x000000100f1e7824ULL, 0x004fca00078e021dULL,
0x00000c1e01007387ULL, 0x000fe80000100800ULL, 0x000000001e38783bULL, 0x0005e20000004200ULL,
0x00000018ff0c7819ULL, 0x008fe20000011445ULL, 0x0000004400c07306ULL, 0x000fe20000009400ULL,
0x00000018ff137819ULL, 0x000fe20000011447ULL, 0x000000100e1e7824ULL, 0x004fe200078e021dULL,
0x00000018ff087819ULL, 0x000fe40000011444ULL, 0x00000018ff127819ULL, 0x000fc40000011446ULL,
0x0000141e01007387ULL, 0x000fe20000100800ULL, 0x0000000c00b37306ULL, 0x000fe60000209400ULL,
0x000000001e2c783bULL, 0x0005ea0000004200ULL, 0x0000000c00ad7306ULL, 0x000fe20000205400ULL,
0x000000100d1e7824ULL, 0x004fca00078e021dULL, 0x0000181e01007387ULL, 0x000fe40000100800ULL,
0x0000000c009f7306ULL, 0x0009e4000020d400ULL, 0x000000001e60783bULL, 0x0005ec0000004200ULL,
0x0000001300937306ULL, 0x000fe20000209400ULL, 0x00000018ff0c7819ULL, 0x010fe20000011431ULL,
0x000000100a1e7824ULL, 0x004fca00078e021dULL, 0x000000001e68783bULL, 0x000ea20000004200ULL,
0x0000000c009a7306ULL, 0x000fe60000209400ULL, 0x00001c1e01007387ULL, 0x0007ea0000100800ULL,
0x0000000c00b67306ULL, 0x000fe20000205400ULL, 0x00000010091e7824ULL, 0x008fce00078e021dULL,
0x0000000c00a37306ULL, 0x0007e2000020d400ULL, 0x000000001e6c783bULL, 0x000f280000004200ULL,
0x0000201e01007387ULL, 0x0005e60000100800ULL, 0x0000001300977306ULL, 0x000fe20000205400ULL,
0x00000018ff0c7819ULL, 0x008fce0000011465ULL, 0x0000000c00867306ULL, 0x000fe20000209400ULL,
0x00000018ff1e7819ULL, 0x004fce0000011468ULL, 0x0000000c00877306ULL, 0x000fe20000205400ULL,
0x00000018ff8e7819ULL, 0x000fe4000001146bULL, 0x00000018ff1f7819ULL, 0x000fca0000011469ULL,
0x0000000c00857306ULL, 0x0005f0000020d400ULL, 0x0000001e00e57306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x004fe40000011439ULL, 0x00000018ffa27819ULL, 0x010fc4000001146cULL,
0x00000018ffa57819ULL, 0x000fe4000001146dULL, 0x00000018ffa77819ULL, 0x000fe2000001146fULL,
0x0000000c00777306ULL, 0x000fe20000209400ULL, 0x00000018ffa67819ULL, 0x000fce000001146eULL,
0x0000000c007c7306ULL, 0x000ff00000205400ULL, 0x0000000c005e7306ULL, 0x0005f0000020d400ULL,
0x0000001e00e47306ULL, 0x000fe20000205400ULL, 0x00000018ff0c7819ULL, 0x004fce000001142dULL,
0x0000000c00747306ULL, 0x000ff00000209400ULL, 0x0000000c00907306ULL, 0x000ff00000205400ULL,
0x0000000c00297306ULL, 0x0005f0000020d400ULL, 0x0000001300a87306ULL, 0x0007e2000020d400ULL,
0x00000018ff0c7819ULL, 0x004fce0000011461ULL, 0x0000000c00967306ULL, 0x000fe20000209400ULL,
0x00000018ff137819ULL, 0x008fce0000011433ULL, 0x0000000c00957306ULL, 0x000ff00000205400ULL,
0x0000000c00257306ULL, 0x000ff0000020d400ULL, 0x0000001e000c7306ULL, 0x000ff0000020d400ULL,
0x0000008e00eb7306ULL, 0x000ff00000209400ULL, 0x0000008e00ea7306ULL, 0x000ff00000205400ULL,
0x0000008e001e7306ULL, 0x0005f0000020d400ULL, 0x0000004400c97306ULL, 0x000ee20000005400ULL,
0x00000100448e7824ULL, 0x004fca00078e00ffULL, 0x00000018ffa47819ULL, 0x000fe2000001148eULL,
0x00000100458e7824ULL, 0x000fe200078e00ffULL, 0x00000044008f7306ULL, 0x000530000000d400ULL,
0x0000001200a07306ULL, 0x000fe20000209400ULL, 0x0001000044447824ULL, 0x004fe200078e00ffULL,
0x000000c9c000720bULL, 0x008fc80003fbd000ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000012009e7306ULL, 0x000fee0000205400ULL, 0x000000018f8f5812ULL, 0x010fe200078efcffULL,
0x0000001200bc7306ULL, 0x0005f0000020d400ULL, 0x0000001300b47306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x004fce0000011432ULL, 0x0000001300ae7306ULL, 0x000ff00000205400ULL,
0x0000001300ab7306ULL, 0x0005f0000020d400ULL, 0x0000000800cc7306ULL, 0x000fe20000209400ULL,
0x00000018ff137819ULL, 0x004fce0000011467ULL, 0x0000000800ce7306ULL, 0x000eb00000205400ULL,
0x0000000800b77306ULL, 0x000730000020d400ULL, 0x0000001200ba7306ULL, 0x000fe20000209400ULL,
0x00000018ff087819ULL, 0x008fc40000011430ULL, 0x000000cecc00720bULL, 0x004fca0003fdd000ULL,
0x0000001200be7306ULL, 0x000ff00000205400ULL, 0x0000001200ac7306ULL, 0x0005e2000020d400ULL,
0x00000001b7b76812ULL, 0x010fce00078efcffULL, 0x00000013007f7306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x004fce0000011466ULL, 0x0000001300807306ULL, 0x000ff00000205400ULL,
0x0000001300797306ULL, 0x0005f0000020d400ULL, 0x0000004400b27306ULL, 0x000fe20000209400ULL,
0x00000018ff137819ULL, 0x004fce000001143bULL, 0x0000004400d17306ULL, 0x000eb00000205400ULL,
0x0000000800987306ULL, 0x000ff00000209400ULL, 0x00000008009b7306ULL, 0x000fe20000205400ULL,
0x000000d1b200720bULL, 0x004fce0003f7d000ULL, 0x0000000800aa7306ULL, 0x0005f0000020d400ULL,
0x0000001200817306ULL, 0x000fe20000209400ULL, 0x00000018ff087819ULL, 0x004fce0000011464ULL,
0x0000001200827306ULL, 0x000ff00000205400ULL, 0x00000012007a7306ULL, 0x0005f0000020d400ULL,
0x0000001300997306ULL, 0x000fe20000209400ULL, 0x00000018ff127819ULL, 0x004fce000001143aULL,
0x0000001300787306ULL, 0x000ff00000205400ULL, 0x00000013002b7306ULL, 0x0005f0000020d400ULL,
0x000000a200f97306ULL, 0x000fe20000209400ULL, 0x00000018ff137819ULL, 0x004fce000001142fULL,
0x000000a200f77306ULL, 0x000ff00000205400ULL, 0x000000a200217306ULL, 0x000ff0000020d400ULL,
0x000000a400a27306ULL, 0x000ff00000209400ULL, 0x000000a400af7306ULL, 0x000eb00000205400ULL,
0x000000a400bb7306ULL, 0x000730000020d400ULL, 0x0000000800887306ULL, 0x000fe20000209400ULL,
0x0000010046a47824ULL, 0x008fe200078e00ffULL, 0x000000afa200720bULL, 0x004fcc0003f3d000ULL,
0x0000000800897306ULL, 0x000fee0000205400ULL, 0x00000001bbbb1812ULL, 0x010fe200078efcffULL,
0x00000008008d7306ULL, 0x0005f0000020d400ULL, 0x0000001200727306ULL, 0x000fe20000209400ULL,
0x00000018ff087819ULL, 0x004fce0000011438ULL, 0x0000001200757306ULL, 0x000ff00000205400ULL,
0x00000012005d7306ULL, 0x0005f0000020d400ULL, 0x0000001300837306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x004fce000001142eULL, 0x0000001300847306ULL, 0x000ff00000205400ULL,
0x0000001300277306ULL, 0x0005f0000020d400ULL, 0x0000004500a17306ULL, 0x000fe20000009400ULL,
0x00000018ff137819ULL, 0x004fce0000011463ULL, 0x0000004500c77306ULL, 0x000eb00000005400ULL,
0x0000004400d47306ULL, 0x000730000020d400ULL, 0x0000004600cb7306ULL, 0x000fe20000009400ULL,
0x00000018ff447819ULL, 0x008fe200000114a4ULL, 0x0000010047a47824ULL, 0x000fe200078e00ffULL,
0x000000c7a100720bULL, 0x004fe20003f9d000ULL, 0x0001000030a17824ULL, 0x000fc800078e00ffULL,
0x0000004600cd7306ULL, 0x000ea20000005400ULL, 0x00000001d4d43812ULL, 0x010fe400078efcffULL,
0x000000adb300720bULL, 0x000fca0003f7d000ULL, 0x00000008007b7306ULL, 0x000ff00000209400ULL,
0x00000008007d7306ULL, 0x000fe20000205400ULL, 0x000000cdcb00720bULL, 0x004fe40003f1d000ULL,
0x000000019f9f3812ULL, 0x000fca00078efcffULL, 0x00000008005f7306ULL, 0x0005f0000020d400ULL,
0x00000012008a7306ULL, 0x000fe20000209400ULL, 0x00000018ff087819ULL, 0x004fce000001142cULL,
0x00000012008b7306ULL, 0x000ff00000205400ULL, 0x0000001200287306ULL, 0x0005f0000020d400ULL,
0x0000001300707306ULL, 0x000fe20000209400ULL, 0x00000018ff127819ULL, 0x004fce0000011462ULL,
0x0000001300717306ULL, 0x000ff00000205400ULL, 0x0000001300237306ULL, 0x000ff0000020d400ULL,
0x000000a500f67306ULL, 0x000ff00000209400ULL, 0x000000a500f37306ULL, 0x000ff00000205400ULL,
0x000000a500137306ULL, 0x0005f0000020d400ULL, 0x0000004400b87306ULL, 0x000fe20000209400ULL,
0x00000018ffa57819ULL, 0x004fce000001148eULL, 0x0000004400b97306ULL, 0x000eb00000205400ULL,
0x0000004400c37306ULL, 0x000730000020d400ULL, 0x00000045008c7306ULL, 0x000a62000000d400ULL,
0x0001000047447824ULL, 0x008fe200078e00ffULL, 0x000000b9b800720bULL, 0x004fc80003fdd000ULL,
0x00000018ffca7819ULL, 0x000fe20000011444ULL, 0x0000010030447824ULL, 0x000fe200078e00ffULL,
0x0000004700d27306ULL, 0x000fe20000009400ULL, 0x0001000045457824ULL, 0x020fc600078e00ffULL,
0x00000018ffd67819ULL, 0x000fe20000011444ULL, 0x0000010031447824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004700d37306ULL, 0x000ea20000005400ULL,
0x00000001c3c36812ULL, 0x010fe400078efcffULL, 0x00000018ffd77819ULL, 0x000fe40000011444ULL,
0x000000018c8c4812ULL, 0x002fc600078efcffULL, 0x0000000800737306ULL, 0x000ff00000209400ULL,
0x0000000800917306ULL, 0x000fe20000205400ULL, 0x000000d3d200720bULL, 0x004fe40003f5d000ULL,
0x00000018ffd27819ULL, 0x000fca00000114a1ULL, 0x00000008002a7306ULL, 0x0003f0000020d400ULL,
0x0000001200927306ULL, 0x000fe20000209400ULL, 0x00000018ff087819ULL, 0x002fce0000011460ULL,
0x00000012007e7306ULL, 0x000ff00000205400ULL, 0x0000001200247306ULL, 0x0003f0000020d400ULL,
0x000000a500c57306ULL, 0x000fe20000209400ULL, 0x00000018ff127819ULL, 0x002fce000001146aULL,
0x000000a500c87306ULL, 0x000e700000205400ULL, 0x000000a5008e7306ULL, 0x0004f0000020d400ULL,
0x00000008009c7306ULL, 0x000fe20000209400ULL, 0x00000018ffa57819ULL, 0x004fc400000114a4ULL,
0x000000c8c500720bULL, 0x002fe20003f3d000ULL, 0x0000010033c87824ULL, 0x000fc800078e00ffULL,
0x00000008009d7306ULL, 0x000ff00000205400ULL, 0x0000000800267306ULL, 0x000fe2000020d400ULL,
0x000000018e8e1812ULL, 0x008fce00078efcffULL, 0x0000001200e97306ULL, 0x000ff00000209400ULL,
0x0000001200e87306ULL, 0x000ff00000205400ULL, 0x0000001200227306ULL, 0x000ff0000020d400ULL,
0x0000001f00e77306ULL, 0x000ff00000209400ULL, 0x0000001f00e67306ULL, 0x000ff00000205400ULL,
0x0000001f00087306ULL, 0x000ff0000020d400ULL, 0x000000a700ed7306ULL, 0x000ff00000209400ULL,
0x000000a700ec7306ULL, 0x000ff00000205400ULL, 0x000000a700127306ULL, 0x000ff0000020d400ULL,
0x000000a600f07306ULL, 0x000ff00000209400ULL, 0x000000a600ee7306ULL, 0x000ff00000205400ULL,
0x000000a6001f7306ULL, 0x000ff0000020d400ULL, 0x000000a500b57306ULL, 0x000ff00000209400ULL,
0x000000a500a47306ULL, 0x000e700000205400ULL, 0x000000a500a77306ULL, 0x000eb0000020d400ULL,
0x0000004500d07306ULL, 0x000fe20000209400ULL, 0x000000a4b500720bULL, 0x002fce0003f7d000ULL,
0x0000004500d57306ULL, 0x000e6c0000205400ULL, 0x00000001a7a73812ULL, 0x004fe400078efcffULL,
0x0000004500c67306ULL, 0x0004f0000020d400ULL, 0x000000ca00a67306ULL, 0x000fe20000209400ULL,
0x0001000046457824ULL, 0x004fe200078e00ffULL, 0x000000d5d000720bULL, 0x002fc40003fbd000ULL,
0x00000018ffd57819ULL, 0x000fe400000114c8ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x000000ca00a57306ULL, 0x000fee0000205400ULL, 0x00000001c6c65812ULL, 0x008fe200078efcffULL,
0x000000ca00bd7306ULL, 0x000fe2000020d400ULL, 0x0000009ea000720bULL, 0x000fe20003fbd000ULL,
0x00010000329e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe2000001149eULL,
0x0000003000c97306ULL, 0x000fec0000009400ULL, 0x00000001bcbc5812ULL, 0x000fe400078efcffULL,
0x0000003000ca7306ULL, 0x000e620000005400ULL, 0x0000009b9800720bULL, 0x000fce0003fbd000ULL,
0x0000003000cd7306ULL, 0x0004ec000000d400ULL, 0x00000001aaaa5812ULL, 0x000fe400078efcffULL,
0x0000003100cb7306ULL, 0x000fe20000009400ULL, 0x0001000031307824ULL, 0x004fe200078e00ffULL,
0x000000cac900720bULL, 0x002fc80003f3d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003100cc7306ULL, 0x000e6e0000005400ULL, 0x00000001cdcd1812ULL, 0x008fe200078efcffULL,
0x0000003100ce7306ULL, 0x0004f0000000d400ULL, 0x0000004600bf7306ULL, 0x000f22000000d400ULL,
0x0000010032317824ULL, 0x004fe200078e00ffULL, 0x000000cccb00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000004500c17306ULL, 0x000fee0000209400ULL,
0x00000001cece4812ULL, 0x008fe200078efcffULL, 0x0000004500c27306ULL, 0x000e620000205400ULL,
0x00000001bfbf0812ULL, 0x010fc400078efcffULL, 0x000000a5a600720bULL, 0x000fca0003f1d000ULL,
0x000000d200a17306ULL, 0x000ff00000209400ULL, 0x000000d200a27306ULL, 0x000ea20000205400ULL,
0x000000c2c100720bULL, 0x002fe40003fdd000ULL, 0x00000001bdbd0812ULL, 0x000fca00078efcffULL,
0x000000d200af7306ULL, 0x000e70000020d400ULL, 0x0000003000c77306ULL, 0x000fe20000209400ULL,
0x000000a2a100720bULL, 0x004fce0003f3d000ULL, 0x0000003000d37306ULL, 0x000eac0000205400ULL,
0x00000001afaf1812ULL, 0x002fe400078efcffULL, 0x0000003000b27306ULL, 0x000e70000020d400ULL,
0x0000003100d17306ULL, 0x000fe20000209400ULL, 0x000000d3c700720bULL, 0x004fce0003f9d000ULL,
0x0000003100d27306ULL, 0x000eac0000205400ULL, 0x00000001b2b24812ULL, 0x002fe400078efcffULL,
0x0000003100c57306ULL, 0x000e70000020d400ULL, 0x0000003200307306ULL, 0x000fe20000009400ULL,
0x000000d2d100720bULL, 0x004fce0003f3d000ULL, 0x0000003200317306ULL, 0x000eac0000005400ULL,
0x00000001c5c51812ULL, 0x002fe400078efcffULL, 0x0000004700a97306ULL, 0x000e70000000d400ULL,
0x000000d600467306ULL, 0x000fe20000209400ULL, 0x000000313000720bULL, 0x004fe20003f7d000ULL,
0x0000010064307824ULL, 0x000fcc00078e00ffULL, 0x000000d600477306ULL, 0x000ea20000205400ULL,
0x00000001a9a92812ULL, 0x002fce00078efcffULL, 0x0000004500cf7306ULL, 0x000e70000020d400ULL,
0x0000003300a07306ULL, 0x000fe20000009400ULL, 0x000000474600720bULL, 0x004fe40003f1d000ULL,
0x00000018ff477819ULL, 0x000fe20000011430ULL, 0x0001000064307824ULL, 0x000fc800078e00ffULL,
0x0000003300ad7306ULL, 0x000ea20000005400ULL, 0x00000001cfcf6812ULL, 0x002fe400078efcffULL,
0x000000979300720bULL, 0x000fca0003fdd000ULL, 0x0000003200ca7306ULL, 0x0002f0000000d400ULL,
0x000000d700447306ULL, 0x000fe20000209400ULL, 0x0001000033327824ULL, 0x002fe200078e00ffULL,
0x000000ada000720bULL, 0x004fc40003f5d000ULL, 0x00000001a8a86812ULL, 0x000fe400078efcffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x000000d700457306ULL, 0x000e620000205400ULL,
0x00000001caca3812ULL, 0x008fce00078efcffULL, 0x0000009e00c97306ULL, 0x000ff00000209400ULL,
0x0000009e00cc7306ULL, 0x000ea20000205400ULL, 0x000000454400720bULL, 0x002fe40003fdd000ULL,
0x00000002ff457819ULL, 0x000fc400000116d8ULL, 0x00000007ff44723eULL, 0x000fe400000010ffULL,
0x00000002ffd87819ULL, 0x000fe200000116d8ULL, 0x0000009e00b57306ULL, 0x0003e6000020d400ULL,
0x00000008d8d87810ULL, 0x000fca0007ffe0ffULL, 0x0000003300cb7306ULL, 0x000ee2000000d400ULL,
0x00000018ff9e7819ULL, 0x002fe40000011430ULL, 0x000128005c307811ULL, 0x000fe400078e20ffULL,
0x000000ccc900720bULL, 0x004fc60003f9d000ULL, 0x0000003200b87306ULL, 0x000ff00000209400ULL,
0x0000003200b97306ULL, 0x000e620000205400ULL, 0x00000001cbcb2812ULL, 0x008fe400078efcffULL,
0x000000aeb400720bULL, 0x000fc40003f5d000ULL, 0x00000001b5b54812ULL, 0x000fc600078efcffULL,
0x0000003200ad7306ULL, 0x0004f0000020d400ULL, 0x000000d600c47306ULL, 0x000962000020d400ULL,
0x000000003030783bULL, 0x004fe20000000200ULL, 0x000000b9b800720bULL, 0x002fc40003f3d000ULL,
0x00000001abab2812ULL, 0x000fc800078efcffULL, 0x0000004700a07306ULL, 0x000fe20000209400ULL,
0x0000541044d67816ULL, 0x010fca0000000044ULL, 0x00001f45d6457589ULL, 0x000e6200000e0000ULL,
0x00000001adad1812ULL, 0x008fe200078efcffULL, 0x00000047009b7306ULL, 0x000ea20000205400ULL,
0x00000001c4c40812ULL, 0x020fe200078efcffULL, 0x00001fd8d6447589ULL, 0x000eec00000e0000ULL,
0x0000004700c27306ULL, 0x000970000020d400ULL, 0x0000006400a57306ULL, 0x000fe20000009400ULL,
0x0000991094477816ULL, 0x010fc400000000ffULL, 0x0000009ba000720bULL, 0x004fe40003f3d000ULL,
0x000000ff4700720cULL, 0x000fc60003f05270ULL, 0x0000006400a67306ULL, 0x000ff00000005400ULL,
0x0000006400467306ULL, 0x0005e2000000d400ULL, 0x00000001c2c21812ULL, 0x020fe200078efcffULL,
0x0000004530308231ULL, 0x002fc400003400ffULL, 0x0000004532328231ULL, 0x000fe400003400ffULL,
0x0000004431318231ULL, 0x088fe400003400ffULL, 0x0000009e00987306ULL, 0x000fe20000209400ULL,
0x0000010065647824ULL, 0x004fe200078e00ffULL, 0x0000004433338231ULL, 0x000fcc00003400ffULL,
0x0000009e00977306ULL, 0x000e700000205400ULL, 0x000000d500c87306ULL, 0x000ff00000209400ULL,
0x000000d500d07306ULL, 0x000ea20000205400ULL, 0x000000979800720bULL, 0x002fce0003f3d000ULL,
0x000000d500b37306ULL, 0x0003f0000020d400ULL, 0x0000009e00937306ULL, 0x000ee2000020d400ULL,
0x00000018ffd57819ULL, 0x002fe40000011464ULL, 0x0000008fbb64723eULL, 0x000fe200000010ffULL,
0x0001000065bb7824ULL, 0x000fe200078e00ffULL, 0x000000d0c800720bULL, 0x004fc60003fbd000ULL,
0x0000006500a47306ULL, 0x000fe20000009400ULL, 0x00000018ffbb7819ULL, 0x000fce00000114bbULL,
0x00000065009e7306ULL, 0x000e620000005400ULL, 0x0000000193931812ULL, 0x008fe400078efcffULL,
0x00000001b3b35812ULL, 0x000fe400078efcffULL, 0x000000a6a500720bULL, 0x000fc60003fbd000ULL,
0x0000006500477306ULL, 0x0004f0000000d400ULL, 0x000000d500947306ULL, 0x000fe20000209400ULL,
0x0000008c8e65723eULL, 0x004fe400000010ffULL, 0x0000009ea400720bULL, 0x002fc40003f5d000ULL,
0x0000000146465812ULL, 0x000fc600078efcffULL, 0x000000bb008c7306ULL, 0x000fe20000209400ULL,
0x000000643040723cULL, 0x000fee0000041840ULL, 0x000000bb008e7306ULL, 0x000e620000205400ULL,
0x0000010066647824ULL, 0x000fe200078e00ffULL, 0x0000000147472812ULL, 0x008fe200078efcffULL,
0x0000010067657824ULL, 0x000fe200078e00ffULL, 0x000000878600720bULL, 0x000fe20003f5d000ULL,
0x000100002e867824ULL, 0x000fc600078e00ffULL, 0x000000d5008f7306ULL, 0x000ea40000205400ULL,
0x00000018ff867819ULL, 0x000fcc0000011486ULL, 0x000000d500c17306ULL, 0x0007e2000020d400ULL,
0x0000008e8c00720bULL, 0x002fe20003f3d000ULL, 0x000001002f8c7824ULL, 0x000fe200078e00ffULL,
0x0000000185852812ULL, 0x000fe400078efcffULL, 0x000000828100720bULL, 0x000fe20003f5d000ULL,
0x0000010060827824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe2000001148cULL,
0x000000d700c07306ULL, 0x000e62000020d400ULL, 0x00000018ffd57819ULL, 0x008fe20000011464ULL,
0x000100002f817824ULL, 0x000fe200078e00ffULL, 0x000000d4b764723eULL, 0x000fc400000010ffULL,
0x00000018ffd47819ULL, 0x000fe40000011465ULL, 0x000000c69f65723eULL, 0x000fe200000010ffULL,
0x000000bb00bb7306ULL, 0x000ee2000020d400ULL, 0x0000008f9400720bULL, 0x004fe40003fbd000ULL,
0x000000017a7a2812ULL, 0x000fe400078efcffULL, 0x000000807f00720bULL, 0x000fe20003f5d000ULL,
0x000000643034723cULL, 0x000fe20000041834ULL, 0x00000018ff877819ULL, 0x000fe20000011482ULL,
0x000000d500a27306ULL, 0x000fe20000209400ULL, 0x00000001c0c06812ULL, 0x002fc400078efcffULL,
0x000000b69a00720bULL, 0x000fe40003fdd000ULL, 0x000000bfc364723eULL, 0x000fe400000010ffULL,
0x000000a9a765723eULL, 0x000fe200000010ffULL, 0x000000d500a17306ULL, 0x000e620000205400ULL,
0x00000001bbbb1812ULL, 0x008fe400078efcffULL, 0x00000001c1c15812ULL, 0x000fe400078efcffULL,
0x0000000179792812ULL, 0x000fe200078efcffULL, 0x000000643054723cULL, 0x000fe20000041854ULL,
0x0000007d7b00720bULL, 0x000fe20003f5d000ULL, 0x000000d500b77306ULL, 0x000ea2000020d400ULL,
0x00000001a3a36812ULL, 0x000fc400078efcffULL, 0x000000beba00720bULL, 0x000fe40003fdd000ULL,
0x0001000066647824ULL, 0x000fe200078e00ffULL, 0x000000bda865723eULL, 0x000fe400000010ffULL,
0x000000d4009f7306ULL, 0x000fe20000209400ULL, 0x000000a1a200720bULL, 0x002fe40003f3d000ULL,
0x00000018ffd07819ULL, 0x000fe40000011464ULL, 0x000000cfbc64723eULL, 0x000fc400000010ffULL,
0x000000015f5f2812ULL, 0x000fe200078efcffULL, 0x000000d4009a7306ULL, 0x000e620000205400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000898800720bULL, 0x000fe20003fdd000ULL,
0x000000643058723cULL, 0x000fe20000041858ULL, 0x000001002e897824ULL, 0x000fe200078e00ffULL,
0x00000001b7b71812ULL, 0x004fe400078efcffULL, 0x0000006600c67306ULL, 0x000fe20000009400ULL,
0x0000007c7700720bULL, 0x000fc40003f5d000ULL, 0x000000cdc464723eULL, 0x000fe400000010ffULL,
0x000000cec065723eULL, 0x000fe400000010ffULL, 0x00000018ff897819ULL, 0x000fe20000011489ULL,
0x0000006600c77306ULL, 0x000ea20000005400ULL, 0x0000009a9f00720bULL, 0x002fe40003f3d000ULL,
0x000000018d8d6812ULL, 0x000fe200078efcffULL, 0x000000643050723cULL, 0x000fe20000041850ULL,
0x00000018ff817819ULL, 0x000fc40000011481ULL, 0x000000015e5e2812ULL, 0x000fe200078efcffULL,
0x0000006600bf7306ULL, 0x0003e2000000d400ULL, 0x000000757200720bULL, 0x000fe40003f5d000ULL,
0x0000010039657824ULL, 0x000fe200078e00ffULL, 0x000000afaa64723eULL, 0x000fc800000010ffULL,
0x000000d400b67306ULL, 0x000ee2000020d400ULL, 0x0001000067667824ULL, 0x002fe200078e00ffULL,
0x00000018ffce7819ULL, 0x000fe40000011465ULL, 0x000000b2a365723eULL, 0x000fe400000010ffULL,
0x00000018ffcf7819ULL, 0x000fe40000011466ULL, 0x0000006700a77306ULL, 0x000fe20000009400ULL,
0x000000c7c600720bULL, 0x004fe40003f7d000ULL, 0x00000064303c723cULL, 0x000fe2000004183cULL,
0x000000015d5d2812ULL, 0x000fc400078efcffULL, 0x000000917300720bULL, 0x000fe40003f5d000ULL,
0x000000cf00667306ULL, 0x000fe20000209400ULL, 0x00000001b6b61812ULL, 0x008fe400078efcffULL,
0x000000cac564723eULL, 0x000fe400000010ffULL, 0x000000cbb365723eULL, 0x000fe400000010ffULL,
0x00000001bfbf3812ULL, 0x000fe200078efcffULL, 0x000000cf00bd7306ULL, 0x000e660000205400ULL,
0x000000012a2a2812ULL, 0x000fe200078efcffULL, 0x00000064304c723cULL, 0x000fe8000004184cULL,
0x0000006700c87306ULL, 0x000ea60000005400ULL, 0x0001000038647824ULL, 0x000fe200078e00ffULL,
0x000000adab65723eULL, 0x000fe200000010ffULL, 0x0001000039ab7824ULL, 0x000fc600078e00ffULL,
0x0000006700c37306ULL, 0x000722000000d400ULL, 0x000000bd6600720bULL, 0x002fe20003f3d000ULL,
0x0000010061667824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe40000011464ULL,
0x000000b5ac64723eULL, 0x000fc600000010ffULL, 0x000000cf00c07306ULL, 0x000e62000020d400ULL,
0x0000010038677824ULL, 0x008fe200078e00ffULL, 0x000000c8a700720bULL, 0x004fe40003f9d000ULL,
0x000000643030723cULL, 0x000fe40000041848ULL, 0x00000018ffcd7819ULL, 0x000fe40000011467ULL,
0x000000ce00af7306ULL, 0x000fe60000209400ULL, 0x000001003a487824ULL, 0x000fc400078e00ffULL,
0x000001003b647824ULL, 0x000fe400078e00ffULL, 0x00000001c3c34812ULL, 0x010fe200078efcffULL,
0x000000cd00677306ULL, 0x000fe20000209400ULL, 0x00000001c0c01812ULL, 0x002fe400078efcffULL,
0x00000018ff4b7819ULL, 0x000fe40000011448ULL, 0x00000018ff657819ULL, 0x000fc60000011464ULL,
0x000000cd00c47306ULL, 0x000e700000205400ULL, 0x000000cd00aa7306ULL, 0x000eb0000020d400ULL,
0x000000ce00b27306ULL, 0x000ee20000205400ULL, 0x000000c46700720bULL, 0x002fe20003f3d000ULL,
0x0001000061677824ULL, 0x000fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000003900cc7306ULL, 0x000fec0000009400ULL, 0x00000001aaaa1812ULL, 0x004fe400078efcffULL,
0x0000003900cd7306ULL, 0x000e620000005400ULL, 0x000000b2af00720bULL, 0x008fce0003f3d000ULL,
0x0000003900b47306ULL, 0x0005f0000000d400ULL, 0x000000ce00a37306ULL, 0x000ee2000020d400ULL,
0x00000018ff397819ULL, 0x004fe400000114abULL, 0x000000cdcc00720bULL, 0x002fca0003fbd000ULL,
0x0000003900ca7306ULL, 0x000ff00000209400ULL, 0x00000039004a7306ULL, 0x000e620000205400ULL,
0x00000001a3a31812ULL, 0x008fe400078efcffULL, 0x00000001b4b45812ULL, 0x000fca00078efcffULL,
0x0000003900ba7306ULL, 0x000eb0000020d400ULL, 0x0000004b00487306ULL, 0x000fe20000209400ULL,
0x0000004aca00720bULL, 0x002fe20003f3d000ULL, 0x00000100634a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001144aULL, 0x0000004b00497306ULL, 0x000e6c0000205400ULL,
0x00000001baba1812ULL, 0x004fe400078efcffULL, 0x0000004b00b87306ULL, 0x0004f0000020d400ULL,
0x0000006500c57306ULL, 0x000fe20000209400ULL, 0x000100003a4b7824ULL, 0x004fe200078e00ffULL,
0x000000494800720bULL, 0x002fe20003f3d000ULL, 0x0001000062487824ULL, 0x000fc600078e00ffULL,
0x00000018ff647819ULL, 0x000fe2000001144bULL, 0x000100003b4b7824ULL, 0x000fe200078e00ffULL,
0x0000006500cb7306ULL, 0x000e6e0000205400ULL, 0x00000001b8b81812ULL, 0x008fe200078efcffULL,
0x0000006500ab7306ULL, 0x0004e2000020d400ULL, 0x000000cbc500720bULL, 0x002fce0003f3d000ULL,
0x0000003a00d47306ULL, 0x000fe20000009400ULL, 0x00000018ff657819ULL, 0x004fce000001144bULL,
0x0000006500be7306ULL, 0x000fe20000209400ULL, 0x00000001abab1812ULL, 0x008fce00078efcffULL,
0x0000006500db7306ULL, 0x000e700000205400ULL, 0x0000003a00de7306ULL, 0x000eb00000005400ULL,
0x0000003a00b97306ULL, 0x000722000000d400ULL, 0x000000dbbe00720bULL, 0x002fce0003f3d000ULL,
0x000000d000a97306ULL, 0x000fe20000209400ULL, 0x000001002c3a7824ULL, 0x008fe200078e00ffULL,
0x000000ded400720bULL, 0x004fcc0003f9d000ULL, 0x000000d000a87306ULL, 0x000e6e0000205400ULL,
0x00000001b9b94812ULL, 0x010fe200078efcffULL, 0x000000d000bc7306ULL, 0x000eb0000020d400ULL,
0x0000003b00397306ULL, 0x000fe20000009400ULL, 0x000000a8a900720bULL, 0x002fce0003f7d000ULL,
0x0000003b00d07306ULL, 0x000e6c0000005400ULL, 0x00000001bcbc3812ULL, 0x004fe400078efcffULL,
0x0000003b00ad7306ULL, 0x0005f0000000d400ULL, 0x0000006500ac7306ULL, 0x000722000020d400ULL,
0x00000018ff3b7819ULL, 0x004fe2000001143aULL, 0x000100002c3a7824ULL, 0x000fe200078e00ffULL,
0x000000d03900720bULL, 0x002fe20003f7d000ULL, 0x0001000060397824ULL, 0x000fc800078e00ffULL,
0x0000003b00ce7306ULL, 0x000fe20000209400ULL, 0x00000018ff657819ULL, 0x008fe4000001143aULL,
0x00000018ff397819ULL, 0x000fca0000011439ULL, 0x0000003b00cf7306ULL, 0x000e620000205400ULL,
0x00000001acac1812ULL, 0x010fe400078efcffULL, 0x00000001adad3812ULL, 0x000fca00078efcffULL,
0x0000003800c97306ULL, 0x000ff00000009400ULL, 0x0000003800d17306ULL, 0x000ea20000005400ULL,
0x000000cfce00720bULL, 0x002fce0003f3d000ULL, 0x0000002c004b7306ULL, 0x000ff00000009400ULL,
0x0000002c00d67306ULL, 0x000e620000005400ULL, 0x000000d1c900720bULL, 0x004fce0003fdd000ULL,
0x0000002c00a57306ULL, 0x000eb0000000d400ULL, 0x0000003b00a67306ULL, 0x000ee2000020d400ULL,
0x000000d64b00720bULL, 0x002fce0003fbd000ULL, 0x00000065002c7306ULL, 0x000fec0000209400ULL,
0x00000001a5a55812ULL, 0x004fe400078efcffULL, 0x00000065003a7306ULL, 0x000e620000205400ULL,
0x00000001a6a61812ULL, 0x008fce00078efcffULL, 0x00000065009e7306ULL, 0x0004f0000020d400ULL,
0x0000003800b37306ULL, 0x000f22000000d400ULL, 0x000100002d657824ULL, 0x004fe200078e00ffULL,
0x0000003a2c00720bULL, 0x002fe20003f3d000ULL, 0x000001006a2c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff887819ULL, 0x000fe40000011465ULL, 0x000000ae00387306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x000fcc000001142cULL, 0x000000019e9e1812ULL, 0x008fe200078efcffULL,
0x000000ae00d57306ULL, 0x000e620000205400ULL, 0x00000001b3b36812ULL, 0x010fe400078efcffULL,
0x0000009e2a2a723eULL, 0x000fca00000010ffULL, 0x000000ae00b57306ULL, 0x000eb0000020d400ULL,
0x0000006400dc7306ULL, 0x000fe20000209400ULL, 0x000000d53800720bULL, 0x002fe20003fdd000ULL,
0x0000010062387824ULL, 0x000fcc00078e00ffULL, 0x0000006400dd7306ULL, 0x000e6c0000205400ULL,
0x00000001b5b56812ULL, 0x004fe400078efcffULL, 0x0000006400ae7306ULL, 0x0004f0000020d400ULL,
0x0000002d00e27306ULL, 0x000fe20000009400ULL, 0x000001002d647824ULL, 0x004fe200078e00ffULL,
0x000000dddc00720bULL, 0x002fc80003f9d000ULL, 0x00000018ffa07819ULL, 0x000fe40000011464ULL,
0x0000002d00e37306ULL, 0x000e6e0000005400ULL, 0x00000001aeae4812ULL, 0x008fe200078efcffULL,
0x0000002d00a47306ULL, 0x000ea2000000d400ULL, 0x000000789900720bULL, 0x000fce0003f9d000ULL,
0x00000088002d7306ULL, 0x000fe20000209400ULL, 0x000000e3e200720bULL, 0x002fca0003fdd000ULL,
0x000000012b2b4812ULL, 0x000fe400078efcffULL, 0x0000008800657306ULL, 0x000e620000205400ULL,
0x000000907400720bULL, 0x000fca0003f9d000ULL, 0x00000001a4a46812ULL, 0x004fe400078efcffULL,
0x000000a0003b7306ULL, 0x000fec0000209400ULL, 0x0000000129294812ULL, 0x000fe400078efcffULL,
0x000000a000647306ULL, 0x000ea20000205400ULL, 0x000000652d00720bULL, 0x002fe20003f3d000ULL,
0x000001006b2d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x000000a000a77306ULL, 0x000e70000020d400ULL, 0x0000002e00a07306ULL, 0x000fe20000009400ULL,
0x000000643b00720bULL, 0x004fce0003fbd000ULL, 0x0000002e00e07306ULL, 0x000eac0000005400ULL,
0x00000001a7a75812ULL, 0x002fe400078efcffULL, 0x0000002e00987306ULL, 0x000e70000000d400ULL,
0x00000086002e7306ULL, 0x000fe20000209400ULL, 0x000000e0a000720bULL, 0x004fce0003f7d000ULL,
0x0000008600d87306ULL, 0x000fec0000205400ULL, 0x0000000198983812ULL, 0x002fe400078efcffULL,
0x0000008600947306ULL, 0x0003e2000020d400ULL, 0x000000848300720bULL, 0x000fce0003f7d000ULL,
0x00000088009b7306ULL, 0x000ea2000020d400ULL, 0x00000018ff867819ULL, 0x002fca0000011466ULL,
0x0000000127273812ULL, 0x000fe400078efcffULL, 0x0000008600d37306ULL, 0x000ff00000209400ULL,
0x0000008600d47306ULL, 0x000fe20000205400ULL, 0x000000019b9b1812ULL, 0x004fce00078efcffULL,
0x0000008600827306ULL, 0x000ff0000020d400ULL, 0x0000006000667306ULL, 0x000ff00000009400ULL,
0x0000006000de7306ULL, 0x000e700000005400ULL, 0x0000006100df7306ULL, 0x000ff00000009400ULL,
0x0000006100e17306ULL, 0x000ea20000005400ULL, 0x000000de6600720bULL, 0x002fce0003f3d000ULL,
0x0000006100867306ULL, 0x0002f0000000d400ULL, 0x0000008900c67306ULL, 0x000fe20000209400ULL,
0x00000018ff617819ULL, 0x002fe40000011438ULL, 0x000000e1df00720bULL, 0x004fca0003f9d000ULL,
0x0000008900c77306ULL, 0x000e700000205400ULL, 0x0000008900977306ULL, 0x000ea2000020d400ULL,
0x0000000186864812ULL, 0x008fce00078efcffULL, 0x0000008700d17306ULL, 0x000fe20000209400ULL,
0x000000c7c600720bULL, 0x002fce0003f5d000ULL, 0x0000008700d27306ULL, 0x000fec0000205400ULL,
0x0000000197972812ULL, 0x004fe400078efcffULL, 0x0000008700897306ULL, 0x000fe2000020d400ULL,
0x0000008b8a00720bULL, 0x000fce0003f5d000ULL, 0x0000006000887306ULL, 0x000e6c000000d400ULL,
0x0000000128282812ULL, 0x000fe400078efcffULL, 0x0000003900607306ULL, 0x000fe20000209400ULL,
0x000000d4d300720bULL, 0x000fce0003f5d000ULL, 0x0000003900cd7306ULL, 0x000ea20000205400ULL,
0x0000000188881812ULL, 0x002fca00078efcffULL, 0x0000000182822812ULL, 0x000fe400078efcffULL,
0x0000003900877306ULL, 0x000e70000020d400ULL, 0x0000006100387306ULL, 0x000fe20000209400ULL,
0x000000cd6000720bULL, 0x004fce0003f7d000ULL, 0x0000006100397306ULL, 0x000fec0000205400ULL,
0x0000000187873812ULL, 0x002fe400078efcffULL, 0x0000006100807306ULL, 0x0003f0000020d400ULL,
0x0000008c00c87306ULL, 0x000fe20000209400ULL, 0x00000018ff617819ULL, 0x002fce0000011448ULL,
0x0000008c00c97306ULL, 0x000e700000205400ULL, 0x0000002f00d77306ULL, 0x000ff00000009400ULL,
0x0000002f00da7306ULL, 0x000ea20000005400ULL, 0x000000c9c800720bULL, 0x002fce0003fdd000ULL,
0x0000007d004a7306ULL, 0x000ff00000209400ULL, 0x0000007d004b7306ULL, 0x000fe20000205400ULL,
0x000000dad700720bULL, 0x004fce0003fbd000ULL, 0x0000007d007b7306ULL, 0x000ff0000020d400ULL,
0x0000006100487306ULL, 0x000ff00000209400ULL, 0x0000006100497306ULL, 0x000ff00000205400ULL,
0x00000061007d7306ULL, 0x0003f0000020d400ULL, 0x0000006700cc7306ULL, 0x000fe20000209400ULL,
0x0000010069617824ULL, 0x002fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006700d07306ULL, 0x000e700000205400ULL, 0x0000008c008e7306ULL, 0x000eb0000020d400ULL,
0x0000002f008f7306ULL, 0x000ee2000000d400ULL, 0x000000d0cc00720bULL, 0x002fce0003f3d000ULL,
0x00000081002f7306ULL, 0x000fe20000209400ULL, 0x000000018e8e6812ULL, 0x004fe400078efcffULL,
0x000000d82e00720bULL, 0x000fca0003fdd000ULL, 0x0000008100d97306ULL, 0x000e620000205400ULL,
0x000000018f8f5812ULL, 0x008fce00078efcffULL, 0x00000081008c7306ULL, 0x000ea2000020d400ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x000000d2d100720bULL, 0x000fe40003fdd000ULL,
0x000000942828723eULL, 0x000fc600000010ffULL, 0x0000006200af7306ULL, 0x000fe20000009400ULL,
0x000000d92f00720bULL, 0x002fce0003fbd000ULL, 0x0000006200b27306ULL, 0x000e620000005400ULL,
0x0000000189896812ULL, 0x000fe400078efcffULL, 0x0000009d9c00720bULL, 0x000fe40003fdd000ULL,
0x000000888988723eULL, 0x000fe400000010ffULL, 0x000000018c8c5812ULL, 0x004fe200078efcffULL,
0x0000006200817306ULL, 0x0004e2000000d400ULL, 0x000000868289723eULL, 0x000fce00000010ffULL,
0x0000006300d57306ULL, 0x000fe20000009400ULL, 0x0001000063627824ULL, 0x004fe200078e00ffULL,
0x000000b2af00720bULL, 0x002fe40003fbd000ULL, 0x0000000126266812ULL, 0x000fe400078efcffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000006300d67306ULL, 0x000e620000005400ULL,
0x000000959600720bULL, 0x000fe40003fdd000ULL, 0x000000872626723eULL, 0x000fc800000010ffULL,
0x0000000181815812ULL, 0x008fe200078efcffULL, 0x00000063007c7306ULL, 0x0005e2000000d400ULL,
0x000000494800720bULL, 0x000fe40003fbd000ULL, 0x00012800b1487811ULL, 0x000fc600078e20ffULL,
0x0000000125256812ULL, 0x000fe400078efcffULL, 0x0000006100be7306ULL, 0x000fe20000209400ULL,
0x0000010068637824ULL, 0x004fe200078e00ffULL, 0x0000007e9200720bULL, 0x000fe40003fdd000ULL,
0x000000bc7a92723eULL, 0x000fe200000010ffULL, 0x000100006dbc7824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000006100bd7306ULL, 0x000ea20000205400ULL,
0x000000017d7d5812ULL, 0x000fc400078efcffULL, 0x000000717000720bULL, 0x000fe40003fbd000ULL,
0x000000d6d500720bULL, 0x002fe40003f5d000ULL, 0x0000000124246812ULL, 0x000fe200078efcffULL,
0x0000006100727306ULL, 0x0002e2000020d400ULL, 0x00000018ffbc7819ULL, 0x000fe400000114bcULL,
0x0000007d2424723eULL, 0x000fca00000010ffULL, 0x0000006800db7306ULL, 0x000fe20000009400ULL,
0x0001000068617824ULL, 0x002fe200078e00ffULL, 0x0000000123235812ULL, 0x000fe400078efcffULL,
0x000000bdbe00720bULL, 0x004fe40003fbd000ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006800dc7306ULL, 0x000e620000005400ULL, 0x000000017c7c2812ULL, 0x000fce00078efcffULL,
0x0000006800787306ULL, 0x000ea2000000d400ULL, 0x0000000172725812ULL, 0x008fce00078efcffULL,
0x0000002c009f7306ULL, 0x000fe20000209400ULL, 0x000000dcdb00720bULL, 0x002fce0003f9d000ULL,
0x0000002c00a07306ULL, 0x000fec0000205400ULL, 0x0000000178784812ULL, 0x004fe400078efcffULL,
0x0000002c00687306ULL, 0x0003e2000020d400ULL, 0x000000e4e500720bULL, 0x000fce0003f9d000ULL,
0x00000067007f7306ULL, 0x000ea2000020d400ULL, 0x000100006a2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002d00997306ULL, 0x000fe20000209400ULL,
0x000000010c0c4812ULL, 0x000fce00078efcffULL, 0x0000002d009a7306ULL, 0x000fe20000205400ULL,
0x000000017f7f1812ULL, 0x004fe400078efcffULL, 0x000000393800720bULL, 0x000fe40003f3d000ULL,
0x00000046c238723eULL, 0x000fe400000010ffULL, 0x00000047c139723eULL, 0x000fe200000010ffULL,
0x0000002d00647306ULL, 0x0003f0000020d400ULL, 0x0000002c00907306ULL, 0x000fe20000209400ULL,
0x000100006b2d7824ULL, 0x002fe200078e00ffULL, 0x0000000180801812ULL, 0x000fc400078efcffULL,
0x0000004b4a00720bULL, 0x000fe40003f3d000ULL, 0x00000018ff3a7819ULL, 0x000fe2000001142dULL,
0x000001006c2d7824ULL, 0x000fe200078e00ffULL, 0x0000002c00917306ULL, 0x000fe20000205400ULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x000000818080723eULL, 0x000fe400000010ffULL,
0x00000018ff3b7819ULL, 0x000fc8000001142dULL, 0x0000002c00667306ULL, 0x0005e2000020d400ULL,
0x000000017b7b1812ULL, 0x000fc800078efcffULL, 0x0000007c7b81723eULL, 0x000fc600000010ffULL,
0x0000006200ca7306ULL, 0x000fe20000209400ULL, 0x00012800762c7811ULL, 0x004fcc00078e20ffULL,
0x000000002c2c783bULL, 0x000ea20000000200ULL, 0x0000006200cb7306ULL, 0x000ef00000205400ULL,
0x0000006200757306ULL, 0x000970000020d400ULL, 0x0000006300c47306ULL, 0x000fe20000209400ULL,
0x0001000069627824ULL, 0x010fe200078e00ffULL, 0x000000cbca00720bULL, 0x008fe20003f3d000ULL,
0x0000004548488231ULL, 0x002fc400003400ffULL, 0x000000454a4a8231ULL, 0x000fe200003400ffULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0000004449498231ULL, 0x080fe200003400ffULL,
0x0000006300c57306ULL, 0x000e620000205400ULL, 0x000000444b4b8231ULL, 0x000fcc00003400ffULL,
0x0000000175751812ULL, 0x020fe200078efcffULL, 0x0000006100a87306ULL, 0x000fe20000209400ULL,
0x000000452c2c8231ULL, 0x004fce00003400ffULL, 0x0000006100a97306ULL, 0x000fe20000205400ULL,
0x000000452e2e8231ULL, 0x000fe200003400ffULL, 0x000000c5c400720bULL, 0x002fe20003f3d000ULL,
0x000000442d2d8231ULL, 0x080fe400003400ffULL, 0x000000442f2f8231ULL, 0x000fc600003400ffULL,
0x0000006100747306ULL, 0x000fe8000020d400ULL, 0x000000382c40723cULL, 0x000fe80000041840ULL,
0x0000006200a17306ULL, 0x000fe60000209400ULL, 0x000000bfb738723eULL, 0x000fe200000010ffULL,
0x000001006fb77824ULL, 0x000fe200078e00ffULL, 0x000000c3b639723eULL, 0x000fe200000010ffULL,
0x000100006eb67824ULL, 0x000fc400078e00ffULL, 0x0000006200a27306ULL, 0x000e620000205400ULL,
0x00000018ffb77819ULL, 0x000fe400000114b7ULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x000000382c54723cULL, 0x000fe80000041854ULL, 0x0000006200677306ULL, 0x000eb0000020d400ULL,
0x0000003a008b7306ULL, 0x000fe20000209400ULL, 0x000000a2a100720bULL, 0x002fce0003fbd000ULL,
0x0000003a008a7306ULL, 0x000e6c0000205400ULL, 0x0000000167675812ULL, 0x004fe400078efcffULL,
0x0000003a00617306ULL, 0x0004e2000020d400ULL, 0x0000009a9900720bULL, 0x000fce0003fbd000ULL,
0x0000003b00837306ULL, 0x000fe20000209400ULL, 0x000000938d3a723eULL, 0x004fe400000010ffULL,
0x000000c07993723eULL, 0x000fe200000010ffULL, 0x000100006f797824ULL, 0x000fe400078e00ffULL,
0x0000000164645812ULL, 0x000fe400078efcffULL, 0x0000003b00847306ULL, 0x000fe20000205400ULL,
0x0000008a8b00720bULL, 0x002fe20003fbd000ULL, 0x000000922c58723cULL, 0x000fe20000041858ULL,
0x00000018ff797819ULL, 0x000fca0000011479ULL, 0x0000003b00627306ULL, 0x0003ec000020d400ULL,
0x0000000161615812ULL, 0x008fe400078efcffULL, 0x0000006300777306ULL, 0x000ea2000020d400ULL,
0x000000bb853b723eULL, 0x002fe200000010ffULL, 0x000001006ebb7824ULL, 0x000fca00078e00ffULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x0000003a2c34723cULL, 0x000fe20000041834ULL,
0x0000006900dd7306ULL, 0x000fec0000009400ULL, 0x00012800b03a7811ULL, 0x000fe400078e20ffULL,
0x0000000177771812ULL, 0x004fe200078efcffULL, 0x0000006900ce7306ULL, 0x000e620000005400ULL,
0x000000a9a800720bULL, 0x000fc40003f3d000ULL, 0x000000003a38783bULL, 0x000eaa0000000200ULL,
0x0000006c00af7306ULL, 0x000fec0000009400ULL, 0x0000000174741812ULL, 0x000fc400078efcffULL,
0x000000a09f00720bULL, 0x000fe20003f3d000ULL, 0x0000006c00b27306ULL, 0x000fe20000005400ULL,
0x000000cedd00720bULL, 0x002fe40003f7d000ULL, 0x000000740c74723eULL, 0x000fca00000010ffULL,
0x0000006c00637306ULL, 0x0003e8000000d400ULL, 0x0000000168681812ULL, 0x000fe400078efcffULL,
0x000000919000720bULL, 0x000fe40003f3d000ULL, 0x0000006900737306ULL, 0x000ee2000000d400ULL,
0x000100006c6c7824ULL, 0x002fca00078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe4000001146cULL,
0x0000006b00c67306ULL, 0x000fe20000009400ULL, 0x000000b3aa6c723eULL, 0x000fe200000010ffULL,
0x0000004538388231ULL, 0x084fe200003400ffULL, 0x0000000166661812ULL, 0x000fe200078efcffULL,
0x000000453a3a8231ULL, 0x000fe200003400ffULL, 0x000000848300720bULL, 0x000fe20003f3d000ULL,
0x0000004439398231ULL, 0x080fe400003400ffULL, 0x0000006b00c77306ULL, 0x000e620000005400ULL,
0x000000443b3b8231ULL, 0x000fe200003400ffULL, 0x0000000173733812ULL, 0x008fc400078efcffULL,
0x000000e6e700720bULL, 0x000fe40003f7d000ULL, 0x000000b2af00720bULL, 0x000fe40003f1d000ULL,
0x0000006b00657306ULL, 0x000ea4000000d400ULL, 0x0000000162621812ULL, 0x000fcc00078efcffULL,
0x0000006a00c87306ULL, 0x000fe20000009400ULL, 0x000000c7c600720bULL, 0x002fe40003fdd000ULL,
0x0000000108083812ULL, 0x000fe400078efcffULL, 0x0000000163630812ULL, 0x000fe400078efcffULL,
0x000000f3f600720bULL, 0x000fe20003f1d000ULL, 0x0000006a00c97306ULL, 0x000e620000005400ULL,
0x000000636262723eULL, 0x000fca00000010ffULL, 0x0000000165656812ULL, 0x004fe400078efcffULL,
0x0000006a00697306ULL, 0x0004e2000000d400ULL, 0x000000eaeb00720bULL, 0x000fc60003fdd000ULL,
0x0000000113130812ULL, 0x000fc800078efcffULL, 0x0000006e00957306ULL, 0x000fe20000009400ULL,
0x000001006d6a7824ULL, 0x004fe200078e00ffULL, 0x000000c9c800720bULL, 0x002fc80003f5d000ULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x0000006e00967306ULL, 0x000e620000005400ULL,
0x000000011e1e6812ULL, 0x000fe400078efcffULL, 0x000000f7f900720bULL, 0x000fc80003fdd000ULL,
0x0000000169692812ULL, 0x008fe200078efcffULL, 0x0000006e00467306ULL, 0x0004e2000000d400ULL,
0x000000e8e900720bULL, 0x000fe40003f5d000ULL, 0x000000696868723eULL, 0x000fe400000010ffULL,
0x000000656469723eULL, 0x000fc600000010ffULL, 0x0000006f006b7306ULL, 0x000fe20000009400ULL,
0x000000b55f6e723eULL, 0x004fe400000010ffULL, 0x000000adab5f723eULL, 0x000fe400000010ffULL,
0x000000969500720bULL, 0x002fe40003f7d000ULL, 0x0000000122222812ULL, 0x000fe200078efcffULL,
0x0000006f007e7306ULL, 0x000e620000005400ULL, 0x0000000121216812ULL, 0x000fe400078efcffULL,
0x000000eced00720bULL, 0x000fc40003fdd000ULL, 0x000000662222723eULL, 0x000fc600000010ffULL,
0x0000006f00477306ULL, 0x000524000000d400ULL, 0x0000000146463812ULL, 0x008fcc00078efcffULL,
0x0000006d009c7306ULL, 0x000fe20000009400ULL, 0x000000ba5e6f723eULL, 0x004fe400000010ffULL,
0x000000b9b85e723eULL, 0x000fe400000010ffULL, 0x0000007e6b00720bULL, 0x002fe40003f5d000ULL,
0x0000000112126812ULL, 0x000fe200078efcffULL, 0x0000006d009d7306ULL, 0x000e620000005400ULL,
0x0000006e2c3c723cULL, 0x040fee000004183cULL, 0x0000006d00607306ULL, 0x0005e2000000d400ULL,
0x0000005e2c4c723cULL, 0x000fe2000004184cULL, 0x0000000147472812ULL, 0x010fcc00078efcffULL,
0x000000a5a65e723eULL, 0x000fe200000010ffULL, 0x0000006a00857306ULL, 0x000fe20000209400ULL,
0x000000b4a36d723eULL, 0x004fe400000010ffULL, 0x000000a4a75f723eULL, 0x000fe400000010ffULL,
0x0000009d9c00720bULL, 0x002fc60003f9d000ULL, 0x0000006c2c50723cULL, 0x000fe20000041850ULL,
0x0000006a008d7306ULL, 0x000e6c0000205400ULL, 0x000000ae5d6c723eULL, 0x000fe200000010ffULL,
0x0000005e3840723cULL, 0x000fe20000041840ULL, 0x000000ac2b6d723eULL, 0x000fe200000010ffULL,
0x000000bf007a7306ULL, 0x000fe20000209400ULL, 0x0000009b292b723eULL, 0x000fc400000010ffULL,
0x0000008c2729723eULL, 0x000fe400000010ffULL, 0x0000007f2527723eULL, 0x000fe200000010ffULL,
0x0000006c2c30723cULL, 0x000fe20000041830ULL, 0x0000008d8500720bULL, 0x002fe20003fbd000ULL,
0x000000bf00717306ULL, 0x000e620000205400ULL, 0x000000752325723eULL, 0x000fe400000010ffULL,
0x000000670875723eULL, 0x000fe400000010ffULL, 0x00000098972c723eULL, 0x000fe200000010ffULL,
0x0000002a3834723cULL, 0x000fe20000041834ULL, 0x0000008f8e2d723eULL, 0x000fe200000010ffULL,
0x0000006a006a7306ULL, 0x000ea2000020d400ULL, 0x0000000160604812ULL, 0x000fc400078efcffULL,
0x000000eef000720bULL, 0x000fe40003f9d000ULL, 0x000000611e23723eULL, 0x000fe200000010ffULL,
0x00000026383c723cULL, 0x000fe4000004183cULL, 0x000000bf00707306ULL, 0x000ee2000020d400ULL,
0x000000717a00720bULL, 0x002fc80003f3d000ULL, 0x000000787726723eULL, 0x000fe200000010ffULL,
0x0000002c3854723cULL, 0x040fe20000041854ULL, 0x000000737227723eULL, 0x000fe200000010ffULL,
0x000000bc005d7306ULL, 0x000fe20000209400ULL, 0x000000016a6a5812ULL, 0x004fe400078efcffULL,
0x000000011f1f4812ULL, 0x000fe400078efcffULL, 0x000000606a63723eULL, 0x000fe200000010ffULL,
0x000000283858723cULL, 0x000fe40000041858ULL, 0x000000bc006e7306ULL, 0x000e620000205400ULL,
0x0000000170701812ULL, 0x008fc800078efcffULL, 0x000000702170723eULL, 0x000fe200000010ffULL,
0x000000243830723cULL, 0x000fe40000041830ULL, 0x000000bb002f7306ULL, 0x000fec0000209400ULL,
0x000000264840723cULL, 0x000fe40000041840ULL, 0x000000bb002a7306ULL, 0x000ea20000205400ULL,
0x0000006e5d00720bULL, 0x002fca0003fbd000ULL, 0x000000883850723cULL, 0x040fe40000041850ULL,
0x000000bc002e7306ULL, 0x000e6c000020d400ULL, 0x00000080384c723cULL, 0x000fe4000004184cULL,
0x000000bb002b7306ULL, 0x000ee2000020d400ULL, 0x0000002a2f00720bULL, 0x004fca0003f3d000ULL,
0x000000744834723cULL, 0x000fe40000041834ULL, 0x000000b700297306ULL, 0x000fe20000209400ULL,
0x000000012e2e5812ULL, 0x002fc800078efcffULL, 0x0000002e1371723eULL, 0x000fe200000010ffULL,
0x000000684854723cULL, 0x000fe40000041854ULL, 0x000000b7002c7306ULL, 0x000e620000205400ULL,
0x000000012b2b1812ULL, 0x008fc800078efcffULL, 0x000000462b46723eULL, 0x000fe200000010ffULL,
0x000000224858723cULL, 0x040fe40000041858ULL, 0x000000b600287306ULL, 0x000fec0000209400ULL,
0x000000624850723cULL, 0x000fe40000041850ULL, 0x000000b600257306ULL, 0x000ea20000205400ULL,
0x0000002c2900720bULL, 0x002fca0003fbd000ULL, 0x00000070483c723cULL, 0x000fe4000004183cULL,
0x0000007900087306ULL, 0x000ff00000209400ULL, 0x0000007900277306ULL, 0x000e620000205400ULL,
0x000000252800720bULL, 0x004fce0003f1d000ULL, 0x000000b700447306ULL, 0x000eb0000020d400ULL,
0x000000b600b67306ULL, 0x000ee2000020d400ULL, 0x000000270800720bULL, 0x002fce0003f3d000ULL,
0x0000007900b77306ULL, 0x000e62000020d400ULL, 0x0000000144445812ULL, 0x004fc800078efcffULL,
0x000000474447723eULL, 0x000fe400000010ffULL, 0x00000001b6b60812ULL, 0x008fc800078efcffULL,
0x000000b61fb6723eULL, 0x000fe200000010ffULL, 0x00000046484c723cULL, 0x000fe2000004184cULL,
0x00000001b7b71812ULL, 0x002fc800078efcffULL, 0x000000b712b7723eULL, 0x000fce00000010ffULL,
0x000000b64848723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000240001fa7983ULL, 0x000ea20000100800ULL,
0x000000ff0bff7812ULL, 0x000fe4000784c0ffULL, 0x0000008003137811ULL, 0x000fe200078e40ffULL,
0x01c62000ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000001ff087807ULL, 0x000fe40001000000ULL,
0x000000130200720cULL, 0x000fe40003f44070ULL, 0x00000001100c7812ULL, 0x000fc8000782c0ffULL,
0x0000000b08137207ULL, 0x000fe40004800000ULL, 0x000000fffaff7812ULL, 0x004fc8000780c0ffULL,
0x00000001ff127807ULL, 0x000fe20004000000ULL, 0x000095400000a947ULL, 0x000fea0003800000ULL,
0x01c65c00ff1f7984ULL, 0x000e620000000800ULL, 0x00000001ff127807ULL, 0x000fca0004000000ULL,
0x80000000120c7824ULL, 0x000fca00078e00ffULL, 0x800000001fff7812ULL, 0x002fe2000782480cULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000782480cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x80000000121f7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c00127305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fc4000782481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000227919ULL, 0x000e620000002600ULL,
0x000000c003217811ULL, 0x040fe200078e40ffULL, 0x00000100ff317424ULL, 0x000fe200078e00ffULL,
0x00000001031f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000001e7919ULL, 0x000ea20000002700ULL,
0x00000021020c7217ULL, 0x000fe20007800000ULL, 0x00000010f2397824ULL, 0x100fe200078e021dULL,
0x000000041f00720cULL, 0x000fe20003f86070ULL, 0x0000000000237919ULL, 0x000ee20000000000ULL,
0x00000010f13b7824ULL, 0x000fe400078e021dULL, 0x000000010c0c7824ULL, 0x000fc400078e0a21ULL,
0x0000001015457824ULL, 0x000fe200078e021dULL, 0x0000580022227a10ULL, 0x002fe20007ffe0ffULL,
0x000000021e1e7824ULL, 0x004fc800078e00ffULL, 0x000058001e1e7a24ULL, 0x000fe200078e0222ULL,
0x00000004ff127819ULL, 0x008fe20000011623ULL, 0x0000001023337824ULL, 0x000fe400078e00ffULL,
0x000062001e2f7a24ULL, 0x000fe200078e0221ULL, 0x0000000212467810ULL, 0x000fe40007ffe0ffULL,
0x000000f033337812ULL, 0x000fe400078ec0ffULL, 0x000000122f1e7210ULL, 0x140fe40007ffe0f8ULL,
0x000000462f227210ULL, 0x000fc40007ffe0f8ULL, 0x0000000812447810ULL, 0x000fe20007ffe0ffULL,
0x00005e001e1e7625ULL, 0x080fe200078e0031ULL, 0x00000004123a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000612327810ULL, 0x000fe20007ffe0ffULL, 0x00005e0022227625ULL, 0x000fe200078e0031ULL,
0x000000331e287210ULL, 0x000fe40007f3e0ffULL, 0x000000442f1e7210ULL, 0x140fe40007ffe0f8ULL,
0x0000003a2f247210ULL, 0x140fe20007ffe0f8ULL, 0x000000ffff297224ULL, 0x000fe200008e061fULL,
0x000000322f267210ULL, 0x000fe20007ffe0f8ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0031ULL,
0x0000000a12387810ULL, 0x000fc40007ffe0ffULL, 0x000000400c217807ULL, 0x000fe20002000000ULL,
0x00000008100c7824ULL, 0x000fe200078e00ffULL, 0x00000033222a7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0024247625ULL, 0x000fe200078e0031ULL, 0x000000382f227210ULL, 0x000fe40007ffe0f8ULL,
0x00000021f8217217ULL, 0x000fe20007800000ULL, 0x00005e0026267625ULL, 0x000fe200078e0031ULL,
0x0000000c12307810ULL, 0x040fe40007ffe0ffULL, 0x0000000e125e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e0623ULL, 0x000000331e2e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0022227625ULL, 0x000fe200078e0031ULL, 0x000000080c0c7812ULL, 0x000fc400078e0cffULL,
0x00000033242c7210ULL, 0x080fe20007f5e0ffULL, 0x0000000121217824ULL, 0x100fe200078e0af8ULL,
0x0000003326267210ULL, 0x080fe20007f7e0ffULL, 0x000000000c0473c2ULL, 0x000e6200000e0000ULL,
0x000000302f1e7210ULL, 0x140fe20007ffe0f8ULL, 0x000000ffff2d7224ULL, 0x000fe200010e0625ULL,
0x0000005e2f247210ULL, 0x000fe20007ffe0f8ULL, 0x000000ffff2f7224ULL, 0x000fe200008e061fULL,
0x0000003322227210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200018e0627ULL,
0x000000211200720cULL, 0x000fe20003f86070ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0031ULL,
0x000000214600720cULL, 0x000fc40003fa6070ULL, 0x000000213a00720cULL, 0x000fe20003f66070ULL,
0x00005e0024247625ULL, 0x000fe200078e0031ULL, 0x000000081c127812ULL, 0x000fc600078ec0ffULL,
0x000000ffff237224ULL, 0x000fe200008e0623ULL, 0x000000331e1e7210ULL, 0x080fe20007f3e0ffULL,
0x00000010f5317824ULL, 0x100fe200078e021dULL, 0x0000003324247210ULL, 0x000fe20007f5e0ffULL,
0x00000010f4337824ULL, 0x000fe400078e021dULL, 0x000000ffff1f7224ULL, 0x000fe200008e061fULL,
0x000000213200720cULL, 0x080fe20003f26070ULL, 0x000000ffff257224ULL, 0x000fe200010e0625ULL,
0x000000214400720cULL, 0x080fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0005e2000e101c46ULL, 0x000000213800720cULL, 0x000fe20003f86070ULL,
0x0001c64804047890ULL, 0x002fc4000fffe03fULL, 0x000000002a337faeULL, 0x0003e2000e901c46ULL,
0x000000213000720cULL, 0x000fc60003fa6070ULL, 0x000000002c397faeULL, 0x0003e2000d901c46ULL,
0x000000215e00720cULL, 0x000fe20003f66070ULL, 0x0000001014217824ULL, 0x100fe400078e021dULL,
0x0000001016297824ULL, 0x104fe200078e021dULL, 0x00000000263b7faeULL, 0x0003e2000c901c46ULL,
0x00000010171d7824ULL, 0x000fc600078e021dULL, 0x000000002e217faeULL, 0x0003e8000d101c46ULL,
0x0000000022457faeULL, 0x0003e8000e101c46ULL, 0x000000001e297faeULL, 0x0003e8000e901c46ULL,
0x00000000241d7faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c00121d7984ULL, 0x0022a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c62c00ff127984ULL, 0x002e620000000800ULL, 0x0000ffff13137812ULL, 0x000fc800078ec0ffULL,
0x00008880130c7816ULL, 0x000fe200000000ffULL, 0x8000000018137824ULL, 0x000fc800078e00ffULL,
0x800000000c0c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x004fe4000782480cULL,
0x8000000012ff7812ULL, 0x002fe20007844813ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fe400078e00ffULL,
0x8000000018137824ULL, 0x000fe400078e00ffULL, 0x0000000c00127305ULL, 0x0002a4000021f000ULL,
0x3fa000000c0c7823ULL, 0x002fe200000100ffULL, 0x000000120000735dULL, 0x004fe40003800000ULL,
0x01c62c00ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fc40007844813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01c10000190c7984ULL, 0x000e620000000800ULL, 0x00000001ff737424ULL, 0x000fc600078e00ffULL,
0x01c3000019127984ULL, 0x0004e20000000800ULL, 0x000000050c00720bULL, 0x002fda0003f5d000ULL,
0x0000000000137806ULL, 0x000fc800010e0100ULL, 0x0000ffff131d7812ULL, 0x000fda000784c0ffULL,
0x000003700000a947ULL, 0x000fea0003800000ULL, 0x000000050c00720bULL, 0x00cfe20003f54000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0x0000000c05227209ULL, 0x000fca0007810000ULL,
0x8000002205137221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b13137820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fe400010e0100ULL, 0x000000020000780cULL, 0x000fe40003f45270ULL,
0x0000ffff051e7812ULL, 0x000fe200078e3cffULL, 0x0000001300137308ULL, 0x000ea60000000800ULL,
0x0000001e1dff7212ULL, 0x000fc4000786c0ffULL, 0x00000002ff247819ULL, 0x102fe4000001161fULL,
0x00000002ff1f7819ULL, 0x000fc6000001161fULL, 0x01c500221900a388ULL, 0x000fe20000000800ULL,
0x00000001ff737807ULL, 0x000fe40001800000ULL, 0x000000081f1f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f2413057589ULL, 0x004e6400000e0000ULL, 0x800000220c1d3221ULL, 0x000fe40000010000ULL,
0x0000001306067220ULL, 0x000fe20000410000ULL, 0x00001f1f130c7589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b1d1d3820ULL, 0x000fc80000410000ULL, 0x0000001d00073308ULL, 0x000ee20000000800ULL,
0x0000000540407220ULL, 0x082fe40000410000ULL, 0x0000000541417220ULL, 0x080fe40000410000ULL,
0x0000000534347220ULL, 0x080fe40000410000ULL, 0x0000000535357220ULL, 0x080fe40000410000ULL,
0x0000000554547220ULL, 0x080fe40000410000ULL, 0x0000000555557220ULL, 0x000fc40000410000ULL,
0x0000000558587220ULL, 0x080fe40000410000ULL, 0x0000000559597220ULL, 0x080fe40000410000ULL,
0x0000000550507220ULL, 0x080fe40000410000ULL, 0x0000000551517220ULL, 0x080fe40000410000ULL,
0x000000053c3c7220ULL, 0x080fe40000410000ULL, 0x000000053d3d7220ULL, 0x000fc40000410000ULL,
0x000000054c4c7220ULL, 0x080fe40000410000ULL, 0x000000054d4d7220ULL, 0x080fe40000410000ULL,
0x0000000548487220ULL, 0x080fe40000410000ULL, 0x0000000549497220ULL, 0x000fe40000410000ULL,
0x0000000c42427220ULL, 0x084fe40000410000ULL, 0x0000000c43437220ULL, 0x000fc40000410000ULL,
0x0000000c36367220ULL, 0x080fe40000410000ULL, 0x0000000c37377220ULL, 0x080fe40000410000ULL,
0x0000000c56567220ULL, 0x080fe40000410000ULL, 0x0000000c57577220ULL, 0x080fe40000410000ULL,
0x0000000c5a5a7220ULL, 0x080fe40000410000ULL, 0x0000000c5b5b7220ULL, 0x000fc40000410000ULL,
0x0000000c52527220ULL, 0x080fe40000410000ULL, 0x0000000c53537220ULL, 0x080fe40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000c4e4e7220ULL, 0x080fe40000410000ULL, 0x0000000c4f4f7220ULL, 0x000fc40000410000ULL,
0x0000000c4a4a7220ULL, 0x080fe40000410000ULL, 0x0000000c4b4b7220ULL, 0x000fe40000410000ULL,
0x000000ffff057224ULL, 0x000fe400078e0022ULL, 0x0000001207123220ULL, 0x008fc80000410000ULL,
0x0000000612067221ULL, 0x00cfe20000010000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x00000008100c7824ULL, 0x040fe200078e00ffULL, 0x0000000110ff7812ULL, 0x000fc8000782c0ffULL,
0x000000080c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000000b08127207ULL, 0x000fc60004800000ULL,
0x01c64c000c137984ULL, 0x000e620000000800ULL, 0x0000ffff12127812ULL, 0x000fc800078ec0ffULL,
0x00008880121d7816ULL, 0x000fca00000000ffULL, 0x800000001d127824ULL, 0x000fca00078e00ffULL,
0x8000000013ff7812ULL, 0x002fe20007824812ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x00000001100c7812ULL, 0x000fe200078ec0ffULL,
0x800000001d1d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff127424ULL, 0x000fe200078e00ffULL,
0x0001c6480c137811ULL, 0x000fc600078e18ffULL, 0x00000012000c7305ULL, 0x0002a4000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x0000000c0000735dULL, 0x004fe40003800000ULL,
0x00000400130c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fc4000782481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00001000010c7983ULL, 0x000ea20000300800ULL, 0x000000100d647824ULL, 0x100fe400078e0220ULL,
0x000000100a687824ULL, 0x100fe200078e0220ULL, 0x0000000000d77919ULL, 0x000e620000000000ULL,
0x00000010096c7824ULL, 0x100fe400078e0220ULL, 0x000000101a447824ULL, 0x100fe200078e0220ULL,
0x000000006464783bULL, 0x000ee20000004200ULL, 0x0000001011307824ULL, 0x100fe400078e0220ULL,
0x000000100f387824ULL, 0x100fe200078e0220ULL, 0x000000006868783bULL, 0x000f220000004200ULL,
0x000000100e607824ULL, 0x000fc600078e0220ULL, 0x000000006c6c783bULL, 0x000f680000004200ULL,
0x000000004444783bULL, 0x000e680000004200ULL, 0x000000003030783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x000e680000004200ULL, 0x000000006060783bULL, 0x000e620000004200ULL,
0x00000018ff247819ULL, 0x008fe20000011466ULL, 0x0000006500df7306ULL, 0x000fe20000009400ULL,
0x00000018ff097819ULL, 0x000fc40000011467ULL, 0x00000018ff917819ULL, 0x010fe4000001146bULL,
0x00000018ff257819ULL, 0x000fe40000011469ULL, 0x00000018ff927819ULL, 0x020fe2000001146dULL,
0x0000002400e47306ULL, 0x000fe20000209400ULL, 0x00000018ff957819ULL, 0x000fe4000001146fULL,
0x00000018ff117819ULL, 0x002fe40000011445ULL, 0x00000018ff937819ULL, 0x000fc4000001146eULL,
0x00000018ff0f7819ULL, 0x000fe20000011430ULL, 0x0000002400e37306ULL, 0x000fe20000205400ULL,
0x00000018ff1d7819ULL, 0x000fe40000011438ULL, 0x00000018ff1f7819ULL, 0x000fe4000001143bULL,
0x00000018ff227819ULL, 0x000fc60000011462ULL, 0x0000002400287306ULL, 0x0003e2000020d400ULL,
0x00000018ff237819ULL, 0x000fe40000011463ULL, 0x00000018ff1e7819ULL, 0x000fe4000001143aULL,
0x00000018ff217819ULL, 0x000fc60000011460ULL, 0x0000009200fa7306ULL, 0x000fe20000209400ULL,
0x00000018ff247819ULL, 0x002fce000001146aULL, 0x0000002400ec7306ULL, 0x000ff00000209400ULL,
0x0000002400eb7306ULL, 0x000ff00000205400ULL, 0x0000009200f97306ULL, 0x000ff00000205400ULL,
0x0000001100b47306ULL, 0x000ff00000209400ULL, 0x0000001100b57306ULL, 0x000ff00000205400ULL,
0x00000011008d7306ULL, 0x0003f0000020d400ULL, 0x0000000900e67306ULL, 0x000fe20000209400ULL,
0x00000018ff117819ULL, 0x002fce0000011431ULL, 0x0000000900e57306ULL, 0x000ff00000205400ULL,
0x0000000900277306ULL, 0x000ff0000020d400ULL, 0x0000009100ee7306ULL, 0x000ff00000209400ULL,
0x0000009100ed7306ULL, 0x000ff00000205400ULL, 0x0000009100097306ULL, 0x000ff0000020d400ULL,
0x0000001100857306ULL, 0x000ff00000209400ULL, 0x00000011007e7306ULL, 0x000ff00000205400ULL,
0x00000011007d7306ULL, 0x000ff0000020d400ULL, 0x0000001d00777306ULL, 0x000ff00000209400ULL,
0x0000001d00747306ULL, 0x000ff00000205400ULL, 0x0000001d00117306ULL, 0x000ff0000020d400ULL,
0x00000022008c7306ULL, 0x000ff00000209400ULL, 0x00000022008b7306ULL, 0x000ff00000205400ULL,
0x00000022000d7306ULL, 0x0003f0000020d400ULL, 0x0000001f00997306ULL, 0x000fe20000209400ULL,
0x00000018ff227819ULL, 0x002fce0000011465ULL, 0x0000001f009f7306ULL, 0x000ff00000205400ULL,
0x0000001f001d7306ULL, 0x000ff0000020d400ULL, 0x00000023007f7306ULL, 0x000ff00000209400ULL,
0x0000002300807306ULL, 0x000ff00000205400ULL, 0x00000023001f7306ULL, 0x0003e2000020d400ULL,
0x000000100c2c7824ULL, 0x004fce00078e0220ULL, 0x0000002400207306ULL, 0x000fe2000020d400ULL,
0x000000002c2c783bULL, 0x000ea20000004200ULL, 0x00000018ff237819ULL, 0x002fcc0000011468ULL,
0x0000009200247306ULL, 0x0005f0000020d400ULL, 0x00000022002b7306ULL, 0x000ff00000209400ULL,
0x00000022005d7306ULL, 0x000ff00000205400ULL, 0x00000022000a7306ULL, 0x000ff0000020d400ULL,
0x0000002300e87306ULL, 0x000fe20000209400ULL, 0x000001002d927824ULL, 0x004fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe2000001142dULL, 0x000001002c917824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fc4000001142eULL, 0x00000018ff927819ULL, 0x000fe40000011492ULL,
0x0000002c00be7306ULL, 0x000fe20000009400ULL, 0x00000018ff917819ULL, 0x000fe40000011491ULL,
0x00000018ff0c7819ULL, 0x000fe4000001142cULL, 0x00000018ff1a7819ULL, 0x000fc6000001142fULL,
0x0000002c00bc7306ULL, 0x000e700000005400ULL, 0x0000002c00847306ULL, 0x0004f0000000d400ULL,
0x0000009200ad7306ULL, 0x000fe20000209400ULL, 0x000000bcbe00720bULL, 0x002fe20003f7d000ULL,
0x000100002c2c7824ULL, 0x004fc400078e00ffULL, 0x0001000045bc7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000009200c27306ULL, 0x000e6c0000205400ULL,
0x0000000184843812ULL, 0x008fe400078efcffULL, 0x0000009200b77306ULL, 0x000eb0000020d400ULL,
0x0000001200907306ULL, 0x000fe20000209400ULL, 0x000000c2ad00720bULL, 0x002fce0003f7d000ULL,
0x00000012008f7306ULL, 0x000e6c0000205400ULL, 0x00000001b7b73812ULL, 0x004fe400078efcffULL,
0x0000009100cc7306ULL, 0x000ff00000209400ULL, 0x0000009100cd7306ULL, 0x000ea20000205400ULL,
0x0000008f9000720bULL, 0x002fce0003f7d000ULL, 0x0000009100d17306ULL, 0x0002f0000020d400ULL,
0x0000002e00ab7306ULL, 0x000fe20000009400ULL, 0x000001002e917824ULL, 0x002fe200078e00ffULL,
0x000000cdcc00720bULL, 0x004fc80003f5d000ULL, 0x00000018ff917819ULL, 0x000fe40000011491ULL,
0x0000002e00ac7306ULL, 0x000e6e0000005400ULL, 0x00000001d1d12812ULL, 0x008fe200078efcffULL,
0x0000002e00bb7306ULL, 0x0004f0000000d400ULL, 0x0000002300e77306ULL, 0x000fe20000205400ULL,
0x000100002e2e7824ULL, 0x004fe200078e00ffULL, 0x000000acab00720bULL, 0x002fe20003f9d000ULL,
0x0000010047ac7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000002300227306ULL, 0x0003ee000020d400ULL, 0x00000001bbbb4812ULL, 0x008fe200078efcffULL,
0x0000001200787306ULL, 0x0004e2000020d400ULL, 0x00000018ff237819ULL, 0x002fce000001146cULL,
0x0000002300fc7306ULL, 0x000fe20000209400ULL, 0x00000018ff127819ULL, 0x004fce0000011446ULL,
0x0000002300fb7306ULL, 0x000fe20000205400ULL, 0x0000000178783812ULL, 0x008fce00078efcffULL,
0x0000002300267306ULL, 0x000ff0000020d400ULL, 0x0000009500f37306ULL, 0x000ff00000209400ULL,
0x0000009500f07306ULL, 0x000ff00000205400ULL, 0x0000009500237306ULL, 0x000ff0000020d400ULL,
0x0000002e00957306ULL, 0x000ff00000209400ULL, 0x0000002e00b67306ULL, 0x000e700000205400ULL,
0x0000002c00d47306ULL, 0x000ff00000209400ULL, 0x0000002c00d57306ULL, 0x000ea20000205400ULL,
0x000000b69500720bULL, 0x002fce0003f7d000ULL, 0x0000002c00af7306ULL, 0x0002f0000020d400ULL,
0x0000002f00a77306ULL, 0x000fe20000009400ULL, 0x000001002f2c7824ULL, 0x002fe200078e00ffULL,
0x000000d5d400720bULL, 0x004fc80003f5d000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002f00aa7306ULL, 0x000e6e0000005400ULL, 0x00000001afaf2812ULL, 0x008fe200078efcffULL,
0x0000002f00837306ULL, 0x0004f0000000d400ULL, 0x0000002d00b27306ULL, 0x000fe20000009400ULL,
0x000100002f2f7824ULL, 0x004fe200078e00ffULL, 0x000000aaa700720bULL, 0x002fc80003fbd000ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x0000002d00b37306ULL, 0x000e6e0000005400ULL,
0x0000000183835812ULL, 0x008fe200078efcffULL, 0x0000002d00757306ULL, 0x0004f0000000d400ULL,
0x0000000c00a47306ULL, 0x000fe20000209400ULL, 0x000100002d2d7824ULL, 0x004fe200078e00ffULL,
0x000000b3b200720bULL, 0x002fc80003f3d000ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000000c00a57306ULL, 0x000e6e0000205400ULL, 0x0000000175751812ULL, 0x008fe200078efcffULL,
0x0000000c00797306ULL, 0x0004f0000020d400ULL, 0x0000001a00717306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x004fc40000011444ULL, 0x000000a5a400720bULL, 0x002fca0003fdd000ULL,
0x0000001a00727306ULL, 0x000ff00000205400ULL, 0x0000001a00c77306ULL, 0x0003e2000020d400ULL,
0x0000000179796812ULL, 0x008fce00078efcffULL, 0x0000002e00cf7306ULL, 0x0004e2000020d400ULL,
0x00000018ff1a7819ULL, 0x002fce0000011432ULL, 0x0000002f00927306ULL, 0x000fe20000209400ULL,
0x00010000442e7824ULL, 0x004fca00078e00ffULL, 0x00000018ffd67819ULL, 0x000fe4000001142eULL,
0x0000002f00a87306ULL, 0x000e620000205400ULL, 0x00000001cfcf3812ULL, 0x008fce00078efcffULL,
0x0000000c002a7306ULL, 0x000ff00000209400ULL, 0x0000000c00297306ULL, 0x000fe20000205400ULL,
0x000000a89200720bULL, 0x002fce0003f7d000ULL, 0x0000000c00a67306ULL, 0x000ff0000020d400ULL,
0x0000001300897306ULL, 0x000ff00000209400ULL, 0x00000013008a7306ULL, 0x000e700000205400ULL,
0x0000001300867306ULL, 0x0004f0000020d400ULL, 0x0000001a007c7306ULL, 0x000fe20000209400ULL,
0x00000018ff137819ULL, 0x004fc40000011447ULL, 0x0000008a8900720bULL, 0x002fca0003fbd000ULL,
0x0000001a007b7306ULL, 0x000ff00000205400ULL, 0x0000001a000c7306ULL, 0x0003e2000020d400ULL,
0x0000000186865812ULL, 0x008fe400078efcffULL, 0x000000727100720bULL, 0x000fca0003fbd000ULL,
0x0000002d00c47306ULL, 0x000fe20000209400ULL, 0x00000018ff1a7819ULL, 0x002fce0000011439ULL,
0x0000002d00c57306ULL, 0x000e620000205400ULL, 0x00000001c7c75812ULL, 0x000fe400078efcffULL,
0x000000292a00720bULL, 0x000fe20003fbd000ULL, 0x00000100332a7824ULL, 0x000fe400078e00ffULL,
0x0000010032297824ULL, 0x000fe400078e00ffULL, 0x0000002d00ae7306ULL, 0x0004e6000020d400ULL,
0x00000018ff297819ULL, 0x000fca0000011429ULL, 0x0000001300a27306ULL, 0x000fe20000209400ULL,
0x00000100442d7824ULL, 0x004fe200078e00ffULL, 0x000000c5c400720bULL, 0x002fe40003f5d000ULL,
0x00000001a6a65812ULL, 0x000fe400078efcffULL, 0x00000018ffc17819ULL, 0x000fe4000001142dULL,
0x0000001300c07306ULL, 0x000fee0000205400ULL, 0x00000001aeae2812ULL, 0x008fe200078efcffULL,
0x00000013009b7306ULL, 0x0003f0000020d400ULL, 0x0000000f00877306ULL, 0x000fe20000209400ULL,
0x00000018ff137819ULL, 0x002fce0000011433ULL, 0x0000000f00887306ULL, 0x000ff00000205400ULL,
0x0000000f00947306ULL, 0x000ff0000020d400ULL, 0x0000001a00a17306ULL, 0x000ff00000209400ULL,
0x0000001a00a07306ULL, 0x000ff00000205400ULL, 0x0000001a000e7306ULL, 0x000ff0000020d400ULL,
0x0000001e009a7306ULL, 0x000ff00000209400ULL, 0x0000001e009e7306ULL, 0x000ff00000205400ULL,
0x0000001e000f7306ULL, 0x0003f0000020d400ULL, 0x0000002100987306ULL, 0x000fe20000209400ULL,
0x00000018ff1e7819ULL, 0x002fce0000011461ULL, 0x0000002100977306ULL, 0x000ff00000205400ULL,
0x00000021001a7306ULL, 0x0003f0000020d400ULL, 0x0000001200bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff217819ULL, 0x002fce0000011464ULL, 0x00000012008e7306ULL, 0x000ff00000205400ULL,
0x0000001200a37306ULL, 0x000ff0000020d400ULL, 0x0000001300707306ULL, 0x000ff00000209400ULL,
0x00000013007a7306ULL, 0x000ff00000205400ULL, 0x0000001300127306ULL, 0x000ff0000020d400ULL,
0x0000009100b87306ULL, 0x000ff00000209400ULL, 0x0000009100b97306ULL, 0x000e700000205400ULL,
0x0000009100bd7306ULL, 0x000eb0000020d400ULL, 0x0000002f00ce7306ULL, 0x000ee2000020d400ULL,
0x000000b9b800720bULL, 0x002fce0003f3d000ULL, 0x0000001e005e7306ULL, 0x000fec0000209400ULL,
0x00000001bdbd1812ULL, 0x004fe400078efcffULL, 0x0000001e005f7306ULL, 0x000fe20000205400ULL,
0x00000001cece3812ULL, 0x008fce00078efcffULL, 0x0000001e00137306ULL, 0x000ff0000020d400ULL,
0x000000c100917306ULL, 0x000ff00000209400ULL, 0x000000c100967306ULL, 0x000e700000205400ULL,
0x0000002100817306ULL, 0x000ff00000209400ULL, 0x0000002100827306ULL, 0x000fe20000205400ULL,
0x000000969100720bULL, 0x002fce0003f7d000ULL, 0x00000021001e7306ULL, 0x000ff0000020d400ULL,
0x0000002500ea7306ULL, 0x000ff00000209400ULL, 0x0000002500e97306ULL, 0x000ff00000205400ULL,
0x0000002500217306ULL, 0x000ff0000020d400ULL, 0x0000009300f77306ULL, 0x000ff00000209400ULL,
0x0000009300f67306ULL, 0x000ff00000205400ULL, 0x0000009300257306ULL, 0x000ff0000020d400ULL,
0x0000002c00937306ULL, 0x000ff00000209400ULL, 0x0000002c009c7306ULL, 0x000e700000205400ULL,
0x0000002c00d07306ULL, 0x0004f0000020d400ULL, 0x0000004400ba7306ULL, 0x000fe20000009400ULL,
0x00000100452c7824ULL, 0x004fe200078e00ffULL, 0x0000009c9300720bULL, 0x002fc80003f5d000ULL,
0x00000018ffc37819ULL, 0x000fe4000001142cULL, 0x0000004400c67306ULL, 0x000e6e0000005400ULL,
0x00000001d0d02812ULL, 0x008fe200078efcffULL, 0x00000045009d7306ULL, 0x000ff00000009400ULL,
0x0000004500a97306ULL, 0x000ea20000005400ULL, 0x000000c6ba00720bULL, 0x002fce0003fdd000ULL,
0x0000004500cb7306ULL, 0x0002f0000000d400ULL, 0x000000c100c97306ULL, 0x000f22000020d400ULL,
0x0000010046457824ULL, 0x002fe200078e00ffULL, 0x000000a99d00720bULL, 0x004fc80003f3d000ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000004400ca7306ULL, 0x0002ae000000d400ULL,
0x00000001cbcb1812ULL, 0x008fe200078efcffULL, 0x000000c3002d7306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x002fc400000114bcULL, 0x00000001c9c93812ULL, 0x010fe400078efcffULL,
0x000000b5b400720bULL, 0x000fc60003f3d000ULL, 0x000000c3002c7306ULL, 0x000e620000205400ULL,
0x00000001caca6812ULL, 0x004fce00078efcffULL, 0x000000c300c87306ULL, 0x000ea4000020d400ULL,
0x000000018d8d1812ULL, 0x000fcc00078efcffULL, 0x000000d6002e7306ULL, 0x000fe20000209400ULL,
0x0000002c2d00720bULL, 0x002fe40003f7d000ULL, 0x000130005c2c7811ULL, 0x000fca00078e20ffULL,
0x000000d6002f7306ULL, 0x000e6c0000205400ULL, 0x00000001c8c83812ULL, 0x004fe400078efcffULL,
0x000000d600c37306ULL, 0x0004f0000020d400ULL, 0x0000004400d27306ULL, 0x000fe20000209400ULL,
0x00000018ffd67819ULL, 0x004fc400000114acULL, 0x0000002f2e00720bULL, 0x002fe40003fdd000ULL,
0x000000002c2c783bULL, 0x000fe60000000200ULL, 0x0000004400d37306ULL, 0x000e700000205400ULL,
0x0000004400c17306ULL, 0x000522000020d400ULL, 0x00000001c3c36812ULL, 0x008fce00078efcffULL,
0x0000004600b27306ULL, 0x000fe20000009400ULL, 0x0001000046447824ULL, 0x004fe200078e00ffULL,
0x000000d3d200720bULL, 0x002fc80003fdd000ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004600b37306ULL, 0x000e6e0000005400ULL, 0x00000001c1c16812ULL, 0x010fe200078efcffULL,
0x0000004600ac7306ULL, 0x0004e2000000d400ULL, 0x0000008ebf00720bULL, 0x000fce0003fdd000ULL,
0x0000004500bc7306ULL, 0x000fe20000209400ULL, 0x0001000047467824ULL, 0x004fe200078e00ffULL,
0x000000b3b200720bULL, 0x002fc80003f9d000ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004500be7306ULL, 0x000e620000205400ULL, 0x00000001a3a36812ULL, 0x000fcc00078efcffULL,
0x00000001acac4812ULL, 0x008fe200078efcffULL, 0x0000004500ab7306ULL, 0x000eb0000020d400ULL,
0x0000004700457306ULL, 0x000fe20000009400ULL, 0x000000bebc00720bULL, 0x002fce0003fbd000ULL,
0x0000004700ad7306ULL, 0x000e6c0000005400ULL, 0x00000001abab5812ULL, 0x004fe400078efcffULL,
0x0000004600c57306ULL, 0x000fe20000209400ULL, 0x000000c0a200720bULL, 0x000fce0003fbd000ULL,
0x0000004600c67306ULL, 0x000fe20000205400ULL, 0x000000ad4500720bULL, 0x002fca0003f5d000ULL,
0x000000019b9b5812ULL, 0x000fe400078efcffULL, 0x0000004600a47306ULL, 0x0003f0000020d400ULL,
0x0000004700aa7306ULL, 0x0004e2000000d400ULL, 0x0001000030467824ULL, 0x002fca00078e00ffULL,
0x00000018ff907819ULL, 0x000fe40000011446ULL, 0x0000004400c27306ULL, 0x000fe20000209400ULL,
0x0000010030477824ULL, 0x004fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004400c47306ULL, 0x000e620000205400ULL, 0x00000001aaaa2812ULL, 0x008fce00078efcffULL,
0x0000004400a57306ULL, 0x000eb0000020d400ULL, 0x0000003000ba7306ULL, 0x000fe20000009400ULL,
0x000000c4c200720bULL, 0x002fce0003f9d000ULL, 0x00000030009c7306ULL, 0x000e6c0000005400ULL,
0x00000001a5a54812ULL, 0x004fe400078efcffULL, 0x0000003000447306ULL, 0x0004f0000000d400ULL,
0x0000009000b97306ULL, 0x000fe20000209400ULL, 0x0000010031307824ULL, 0x004fe200078e00ffULL,
0x0000009cba00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000009000b87306ULL, 0x000e6e0000205400ULL, 0x0000000144444812ULL, 0x008fe200078efcffULL,
0x0000009000467306ULL, 0x000eb0000020d400ULL, 0x0000003000907306ULL, 0x000fe20000209400ULL,
0x000000b8b900720bULL, 0x002fce0003fdd000ULL, 0x0000003000b37306ULL, 0x000e6c0000205400ULL,
0x0000000146466812ULL, 0x004fe400078efcffULL, 0x0000003000ad7306ULL, 0x0004f0000020d400ULL,
0x0000004700937306ULL, 0x000fe20000209400ULL, 0x00000018ff307819ULL, 0x004fc4000001142aULL,
0x00000002ff2a7819ULL, 0x100fe400000116d7ULL, 0x00000002ffd77819ULL, 0x000fe400000116d7ULL,
0x000000b39000720bULL, 0x002fe20003fdd000ULL, 0x00000047008f7306ULL, 0x000e620000205400ULL,
0x00000008d7d77810ULL, 0x000fce0007ffe0ffULL, 0x0000004700957306ULL, 0x000528000020d400ULL,
0x00000001adad6812ULL, 0x008fc800078efcffULL, 0x00000031009d7306ULL, 0x000fe20000009400ULL,
0x0001000031477824ULL, 0x004fe200078e00ffULL, 0x0000008f9300720bULL, 0x002fc80003f5d000ULL,
0x00000018ff717819ULL, 0x000fe40000011447ULL, 0x0000003100927306ULL, 0x000e6e0000005400ULL,
0x0000000195952812ULL, 0x010fe200078efcffULL, 0x0000003100457306ULL, 0x0004e6000000d400ULL,
0x000000449544723eULL, 0x000fe200000010ffULL, 0x000100006c957824ULL, 0x000fc800078e00ffULL,
0x0000002900a97306ULL, 0x000fe20000209400ULL, 0x00000007ff31723eULL, 0x004fe400000010ffULL,
0x000000929d00720bULL, 0x002fe40003fbd000ULL, 0x0000541031d57816ULL, 0x000fe40000000031ULL,
0x0000991073317816ULL, 0x000fe200000000ffULL, 0x0000002900a87306ULL, 0x000fe40000205400ULL,
0x00001f2ad52a7589ULL, 0x000e6200000e0000ULL, 0x000000ff3100720cULL, 0x000fc40003f65270ULL,
0x00000075b731723eULL, 0x000fc600000010ffULL, 0x0000002900727306ULL, 0x0005e2000020d400ULL,
0x0000000145455812ULL, 0x008fe400078efcffULL, 0x0000007e8500720bULL, 0x000fe40003fbd000ULL,
0x00000045ad45723eULL, 0x000fe200000010ffULL, 0x000001006fad7824ULL, 0x000fe400078e00ffULL,
0x0000007100b27306ULL, 0x000fe20000209400ULL, 0x00001fd7d5297589ULL, 0x004ea400000e0000ULL,
0x00000018ffad7819ULL, 0x000fca00000114adULL, 0x0000007100917306ULL, 0x000ee20000205400ULL,
0x000000017d7d5812ULL, 0x000fe200078efcffULL, 0x0000002a2c2cb231ULL, 0x082fe400003400ffULL,
0x0000002a2e2eb231ULL, 0x000fc800003400ffULL, 0x0000007100477306ULL, 0x000e70000020d400ULL,
0x0000003000897306ULL, 0x000fe20000209400ULL, 0x000000292d2db231ULL, 0x084fe200003400ffULL,
0x00000091b200720bULL, 0x008fe20003fdd000ULL, 0x000000292f2fb231ULL, 0x000fca00003400ffULL,
0x00000030008a7306ULL, 0x000eae0000205400ULL, 0x0000000147476812ULL, 0x002fe200078efcffULL,
0x0000003000717306ULL, 0x0002e2000020d400ULL, 0x000000a8a900720bULL, 0x000fce0003fdd000ULL,
0x0000003200b67306ULL, 0x000fe20000009400ULL, 0x00000084d130723eULL, 0x002fe200000010ffULL,
0x0001000032847824ULL, 0x000fe200078e00ffULL, 0x0000008a8900720bULL, 0x004fc60003fbd000ULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000302c40723cULL, 0x000fe20000041840ULL,
0x0000003200967306ULL, 0x000e620000005400ULL, 0x00000018ff847819ULL, 0x000fca0000011484ULL,
0x0001000033307824ULL, 0x000fe200078e00ffULL, 0x0000000171715812ULL, 0x008fe200078efcffULL,
0x0000010038317824ULL, 0x000fe200078e00ffULL, 0x0000003200737306ULL, 0x0004e2000000d400ULL,
0x00000096b600720bULL, 0x002fce0003f5d000ULL, 0x0000003300b47306ULL, 0x000fe20000009400ULL,
0x00000018ff327819ULL, 0x004fe40000011430ULL, 0x000000af7930723eULL, 0x000fca00000010ffULL,
0x0000003300b57306ULL, 0x000e620000005400ULL, 0x0000000173732812ULL, 0x008fce00078efcffULL,
0x0000003300757306ULL, 0x0004e2000000d400ULL, 0x000000737272723eULL, 0x000fce00000010ffULL,
0x000000d600cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff337819ULL, 0x004fe40000011431ULL,
0x000000ae7831723eULL, 0x000fe400000010ffULL, 0x000000b5b400720bULL, 0x002fc60003f9d000ULL,
0x000000d600cd7306ULL, 0x000e640000205400ULL, 0x000000302c34723cULL, 0x000fec0000041834ULL,
0x000000d600a77306ULL, 0x000ea2000020d400ULL, 0x000000bbbd30723eULL, 0x000fe400000010ffULL,
0x00000083d031723eULL, 0x000fc400000010ffULL, 0x0000000175754812ULL, 0x008fe400078efcffULL,
0x0000007b7c00720bULL, 0x000fe20003f9d000ULL, 0x0000003200dd7306ULL, 0x000fe20000209400ULL,
0x000000cdcc00720bULL, 0x002fe20003f3d000ULL, 0x000000302c54723cULL, 0x000fe20000041854ULL,
0x000000757173723eULL, 0x000fe400000010ffULL, 0x00000018ff757819ULL, 0x000fc60000011495ULL,
0x0000003200d77306ULL, 0x000fe20000205400ULL, 0x000000cf8630723eULL, 0x000fe400000010ffULL,
0x000000cec731723eULL, 0x000fe400000010ffULL, 0x000000010c0c4812ULL, 0x000fe400078efcffULL,
0x00000001a7a71812ULL, 0x004fe200078efcffULL, 0x0000003200797306ULL, 0x0003e2000020d400ULL,
0x000000c6c500720bULL, 0x000fe20003f3d000ULL, 0x000000302c58723cULL, 0x000fe20000041858ULL,
0x0000007a7000720bULL, 0x000fca0003f9d000ULL, 0x0000003300af7306ULL, 0x000fe20000209400ULL,
0x000000cac930723eULL, 0x000fe200000010ffULL, 0x0000010039327824ULL, 0x002fe200078e00ffULL,
0x000000cbc831723eULL, 0x000fc600000010ffULL, 0x00000001a4a41812ULL, 0x000fe400078efcffULL,
0x0000003300ae7306ULL, 0x000fe20000205400ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x000000302c50723cULL, 0x000fe20000041850ULL, 0x000000888700720bULL, 0x000fe40003f3d000ULL,
0x0000000112124812ULL, 0x000fc600078efcffULL, 0x0000003300787306ULL, 0x0003e2000020d400ULL,
0x000000c3a630723eULL, 0x000fe400000010ffULL, 0x000000c18d31723eULL, 0x000fca00000010ffULL,
0x0000003a00c37306ULL, 0x000fe20000009400ULL, 0x0001000038337824ULL, 0x002fe200078e00ffULL,
0x000000302c3c723cULL, 0x000fe2000004183cULL, 0x0000000194941812ULL, 0x000fc600078efcffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000003a00c27306ULL, 0x000e620000005400ULL,
0x000000acab30723eULL, 0x000fe400000010ffULL, 0x000000aaa731723eULL, 0x000fca00000010ffULL,
0x0000003200bb7306ULL, 0x000fe40000209400ULL, 0x000000302c4c723cULL, 0x000fec000004184cULL,
0x0000003200bd7306ULL, 0x000ea20000205400ULL, 0x000000a5a330723eULL, 0x000fe400000010ffULL,
0x000000a49b31723eULL, 0x000fc400000010ffULL, 0x000000c2c300720bULL, 0x002fc60003f5d000ULL,
0x0000003200867306ULL, 0x0002f0000020d400ULL, 0x0000003800bc7306ULL, 0x000fe20000009400ULL,
0x000001003a327824ULL, 0x002fe200078e00ffULL, 0x000000bdbb00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff9b7819ULL, 0x000fe40000011432ULL, 0x0000003800be7306ULL, 0x000e6e0000005400ULL,
0x0000000186864812ULL, 0x008fe200078efcffULL, 0x0000003800837306ULL, 0x000eb0000000d400ULL,
0x0000003900bf7306ULL, 0x000fe20000009400ULL, 0x000000bebc00720bULL, 0x002fce0003f3d000ULL,
0x0000003900387306ULL, 0x000e6c0000005400ULL, 0x0000000183831812ULL, 0x004fe400078efcffULL,
0x0000003300e27306ULL, 0x000ff00000209400ULL, 0x0000003300e17306ULL, 0x000ea20000205400ULL,
0x00000038bf00720bULL, 0x002fe20003fdd000ULL, 0x0001000064387824ULL, 0x000fcc00078e00ffULL,
0x00000033008e7306ULL, 0x0003f0000020d400ULL, 0x0000003a008d7306ULL, 0x000722000000d400ULL,
0x000000302c30723cULL, 0x002fe20000041848ULL, 0x000000e1e200720bULL, 0x004fcc0003f9d000ULL,
0x000001003b2c7824ULL, 0x000fe200078e00ffULL, 0x0000003900a27306ULL, 0x0002a2000000d400ULL,
0x000100003a3a7824ULL, 0x008fc600078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000002c00cb7306ULL, 0x000fe20000209400ULL,
0x000000018d8d2812ULL, 0x010fe200078efcffULL, 0x0001000039397824ULL, 0x002fe200078e00ffULL,
0x0000009e9a00720bULL, 0x000fe40003f5d000ULL, 0x000000018e8e4812ULL, 0x000fe400078efcffULL,
0x00000018ffa77819ULL, 0x000fe20000011439ULL, 0x0000002c00cc7306ULL, 0x000e620000205400ULL,
0x00000001a2a26812ULL, 0x004fc400078efcffULL, 0x000000747700720bULL, 0x000fca0003fdd000ULL,
0x0000002c00ab7306ULL, 0x0005e2000020d400ULL, 0x000000010f0f2812ULL, 0x000fce00078efcffULL,
0x0000008400d97306ULL, 0x000fe20000209400ULL, 0x00000100602c7824ULL, 0x044fe200078e00ffULL,
0x0000000111116812ULL, 0x000fe400078efcffULL, 0x000000a0a100720bULL, 0x000fe40003fdd000ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142cULL, 0x00010000602c7824ULL, 0x000fe200078e00ffULL,
0x0000008400b77306ULL, 0x000ea80000205400ULL, 0x00000018ff2f7819ULL, 0x000fc8000001142cULL,
0x0000002e004a7306ULL, 0x000fe20000209400ULL, 0x000000010e0e6812ULL, 0x000fe400078efcffULL,
0x000000cccb00720bULL, 0x002fca0003fdd000ULL, 0x0000002e004b7306ULL, 0x000e620000205400ULL,
0x000000b7d900720bULL, 0x004fce0003fbd000ULL, 0x0000008400847306ULL, 0x000ea2000020d400ULL,
0x00000001abab6812ULL, 0x000fce00078efcffULL, 0x0000003a00c77306ULL, 0x000fe20000209400ULL,
0x0000004b4a00720bULL, 0x002fe20003f5d000ULL, 0x000001006a4a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000003a00c87306ULL, 0x000e620000205400ULL,
0x0000000184845812ULL, 0x004fe400078efcffULL, 0x000000d7dd00720bULL, 0x000fca0003fbd000ULL,
0x0000003a00ac7306ULL, 0x0005f0000020d400ULL, 0x0000002e00a57306ULL, 0x000ee2000020d400ULL,
0x00000100613a7824ULL, 0x004fe200078e00ffULL, 0x0000000179795812ULL, 0x000fc400078efcffULL,
0x000000aeaf00720bULL, 0x000fe40003fbd000ULL, 0x000000c8c700720bULL, 0x002fe40003fdd000ULL,
0x0000002f002c7306ULL, 0x000fe20000209400ULL, 0x000000791295723eULL, 0x000fe400000010ffULL,
0x000000a28679723eULL, 0x000fca00000010ffULL, 0x0000002f002d7306ULL, 0x000e620000205400ULL,
0x00000001a5a52812ULL, 0x008fe400078efcffULL, 0x0000000178785812ULL, 0x000fe400078efcffULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000837878723eULL, 0x000fe200000010ffULL,
0x0000003b00c17306ULL, 0x000ff00000009400ULL, 0x0000003b00c47306ULL, 0x000ea20000005400ULL,
0x0000002d2c00720bULL, 0x002fe20003f5d000ULL, 0x000001006b2c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142cULL, 0x0000003b00a47306ULL, 0x0002e2000000d400ULL,
0x000100006a2c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000006000da7306ULL, 0x000fe20000009400ULL, 0x000100003b3b7824ULL, 0x002fe200078e00ffULL,
0x000000c4c100720bULL, 0x004fc80003fbd000ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000006000d87306ULL, 0x000e6e0000005400ULL, 0x00000001a4a45812ULL, 0x008fe200078efcffULL,
0x0000006000a37306ULL, 0x0004e2000000d400ULL, 0x0000009f9900720bULL, 0x000fce0003fbd000ULL,
0x000000a700397306ULL, 0x000fe20000209400ULL, 0x00000018ff607819ULL, 0x004fe2000001143aULL,
0x00010000613a7824ULL, 0x000fe200078e00ffULL, 0x000000d8da00720bULL, 0x002fc60003f3d000ULL,
0x000000011d1d5812ULL, 0x000fe400078efcffULL, 0x000000a700c97306ULL, 0x000e620000205400ULL,
0x00000018ffba7819ULL, 0x000fe4000001143aULL, 0x0000005f5e00720bULL, 0x000fca0003fbd000ULL,
0x000000a700a67306ULL, 0x000ea2000020d400ULL, 0x00000001a3a31812ULL, 0x008fce00078efcffULL,
0x0000003b00c57306ULL, 0x000fe20000209400ULL, 0x000000c93900720bULL, 0x002fe20003f9d000ULL,
0x0001000067397824ULL, 0x000fe200078e00ffULL, 0x0000000113135812ULL, 0x000fc800078efcffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000003b00c67306ULL, 0x000e6c0000205400ULL,
0x00000001a6a64812ULL, 0x004fe400078efcffULL, 0x0000003b00a77306ULL, 0x0004f0000020d400ULL,
0x0000009b00c07306ULL, 0x000fe20000209400ULL, 0x00000100623b7824ULL, 0x004fe200078e00ffULL,
0x000000c6c500720bULL, 0x002fcc0003fdd000ULL, 0x0000009b00cf7306ULL, 0x000e6e0000205400ULL,
0x00000001a7a76812ULL, 0x008fe200078efcffULL, 0x0000009b00aa7306ULL, 0x000ea2000020d400ULL,
0x000000979800720bULL, 0x000fce0003fdd000ULL, 0x0000002f009b7306ULL, 0x000ee2000020d400ULL,
0x000000cfc000720bULL, 0x002fca0003f9d000ULL, 0x000000011a1a6812ULL, 0x000fe400078efcffULL,
0x000000ba002f7306ULL, 0x000fec0000209400ULL, 0x00000001aaaa4812ULL, 0x004fe400078efcffULL,
0x000000ba003a7306ULL, 0x000e620000205400ULL, 0x000000019b9b2812ULL, 0x008fc800078efcffULL,
0x0000009b1a12723eULL, 0x000fc600000010ffULL, 0x0000006100ca7306ULL, 0x000ff00000009400ULL,
0x0000006100ce7306ULL, 0x000ea20000005400ULL, 0x0000003a2f00720bULL, 0x002fce0003f5d000ULL,
0x00000061009c7306ULL, 0x0003f0000000d400ULL, 0x000000ba00927306ULL, 0x000ee2000020d400ULL,
0x00000018ff617819ULL, 0x002fe4000001143bULL, 0x000000ceca00720bULL, 0x004fca0003f9d000ULL,
0x00000061003b7306ULL, 0x000ff00000209400ULL, 0x0000006100497306ULL, 0x000e620000205400ULL,
0x0000000192922812ULL, 0x008fe400078efcffULL, 0x000000019c9c4812ULL, 0x000fc400078efcffULL,
0x000000921313723eULL, 0x000fc600000010ffULL, 0x0000006100937306ULL, 0x0004f0000020d400ULL,
0x0000006300cd7306ULL, 0x000fe20000009400ULL, 0x0001000062617824ULL, 0x004fe200078e00ffULL,
0x000000493b00720bULL, 0x002fc40003fdd000ULL, 0x000000477d49723eULL, 0x000fe400000010ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000006300d07306ULL, 0x000e6e0000005400ULL,
0x0000000193936812ULL, 0x008fe200078efcffULL, 0x0000006100d27306ULL, 0x000fe20000209400ULL,
0x0000008b8c00720bULL, 0x000fce0003fdd000ULL, 0x0000006100d67306ULL, 0x000ea20000205400ULL,
0x000000d0cd00720bULL, 0x002fca0003f5d000ULL, 0x000000010d0d6812ULL, 0x000fe400078efcffULL,
0x0000006100917306ULL, 0x0002f0000020d400ULL, 0x00000060002e7306ULL, 0x000fe20000209400ULL,
0x0000010065617824ULL, 0x002fe200078e00ffULL, 0x000000d6d200720bULL, 0x004fc80003fbd000ULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000006000487306ULL, 0x000e6e0000205400ULL,
0x0000000191915812ULL, 0x008fe200078efcffULL, 0x00000060009d7306ULL, 0x0004f0000020d400ULL,
0x0000006300907306ULL, 0x000f22000000d400ULL, 0x0000010063607824ULL, 0x004fe200078e00ffULL,
0x000000482e00720bULL, 0x002fe20003f3d000ULL, 0x000001006c487824ULL, 0x000fc600078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011460ULL, 0x0000006100d47306ULL, 0x000fe20000209400ULL,
0x00000018ff4b7819ULL, 0x000fe40000011448ULL, 0x000000469448723eULL, 0x000fe400000010ffULL,
0x00013000b0947811ULL, 0x000fe400078e20ffULL, 0x000000019d9d1812ULL, 0x008fe200078efcffULL,
0x0000006100d37306ULL, 0x000fe20000205400ULL, 0x0000000190902812ULL, 0x010fc400078efcffULL,
0x000000807f00720bULL, 0x000fca0003f5d000ULL, 0x00000061007e7306ULL, 0x0003f0000020d400ULL,
0x0000008700b87306ULL, 0x000fe20000209400ULL, 0x00000018ff617819ULL, 0x002fe40000011438ULL,
0x000000011f1f2812ULL, 0x000fca00078efcffULL, 0x0000008700607306ULL, 0x000e700000205400ULL,
0x00000087008f7306ULL, 0x000eb0000020d400ULL, 0x0000006100d97306ULL, 0x000fe20000209400ULL,
0x00000060b800720bULL, 0x002fce0003f9d000ULL, 0x0000006100387306ULL, 0x000e6c0000205400ULL,
0x000000018f8f4812ULL, 0x004fe400078efcffULL, 0x0000006100877306ULL, 0x0004e4000020d400ULL,
0x000000908f8f723eULL, 0x000fcc00000010ffULL, 0x0000006200b97306ULL, 0x000fe20000009400ULL,
0x0000010067617824ULL, 0x004fe200078e00ffULL, 0x00000038d900720bULL, 0x002fe40003f5d000ULL,
0x0001300076387811ULL, 0x000fe400078e20ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000006200ba7306ULL, 0x000e6e0000005400ULL, 0x0000000187872812ULL, 0x008fe200078efcffULL,
0x0000006200967306ULL, 0x0004f0000000d400ULL, 0x0000006100bb7306ULL, 0x000fe20000209400ULL,
0x0001000063627824ULL, 0x004fe200078e00ffULL, 0x000000bab900720bULL, 0x002fe20003f3d000ULL,
0x0000010064637824ULL, 0x000fc400078e00ffULL, 0x000001006eba7824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000006100bd7306ULL, 0x000fe20000205400ULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x00000018ffba7819ULL, 0x000fc800000114baULL,
0x0000000196961812ULL, 0x008fe200078efcffULL, 0x0000006100707306ULL, 0x0003f0000020d400ULL,
0x0000006200be7306ULL, 0x000fe20000209400ULL, 0x0001000066617824ULL, 0x002fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000006200bc7306ULL, 0x000e700000205400ULL,
0x0000006200887306ULL, 0x0004f0000020d400ULL, 0x0000006500e07306ULL, 0x000f220000005400ULL,
0x0001000065627824ULL, 0x004fe200078e00ffULL, 0x000000bcbe00720bULL, 0x002fe20003fbd000ULL,
0x000001006dbc7824ULL, 0x000fc600078e00ffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000006500857306ULL, 0x000e62000000d400ULL, 0x00000018ffbc7819ULL, 0x000fcc00000114bcULL,
0x0000000188885812ULL, 0x008fe200078efcffULL, 0x0000006100c17306ULL, 0x000fe20000209400ULL,
0x000000d3d400720bULL, 0x000fe40003fbd000ULL, 0x000000e0df00720bULL, 0x010fca0003f9d000ULL,
0x0000006100c47306ULL, 0x000fec0000205400ULL, 0x000000017e7e5812ULL, 0x000fe400078efcffULL,
0x0000006100777306ULL, 0x0005e2000020d400ULL, 0x0000005d2b00720bULL, 0x000fe40003fbd000ULL,
0x0000000185854812ULL, 0x002fc800078efcffULL, 0x000000857e85723eULL, 0x000fe200000010ffULL,
0x0000003900b37306ULL, 0x000fe20000209400ULL, 0x0000010069617824ULL, 0x004fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000003900b47306ULL, 0x000e620000205400ULL,
0x000000010a0a5812ULL, 0x000fe400078efcffULL, 0x000000bdbb00720bULL, 0x000fe20003fbd000ULL,
0x000100006dbb7824ULL, 0x000fc800078e00ffULL, 0x0000003900657306ULL, 0x0004e2000020d400ULL,
0x00000018ffbb7819ULL, 0x000fce00000114bbULL, 0x0000006400db7306ULL, 0x000fe20000009400ULL,
0x0001000068397824ULL, 0x004fe200078e00ffULL, 0x0000000170705812ULL, 0x000fe400078efcffULL,
0x000000b4b300720bULL, 0x002fe40003fbd000ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000006400dc7306ULL, 0x000e700000005400ULL, 0x00000064008a7306ULL, 0x000ea2000000d400ULL,
0x0000000165655812ULL, 0x008fce00078efcffULL, 0x0000006200c37306ULL, 0x000fe20000209400ULL,
0x000000dcdb00720bULL, 0x002fce0003f3d000ULL, 0x0000006200bf7306ULL, 0x000e6c0000205400ULL,
0x000000018a8a1812ULL, 0x004fe400078efcffULL, 0x00000062007a7306ULL, 0x0004e2000020d400ULL,
0x000000828100720bULL, 0x000fce0003f3d000ULL, 0x0000006700d87306ULL, 0x000fe20000009400ULL,
0x0000010068627824ULL, 0x004fe200078e00ffULL, 0x000000bfc300720bULL, 0x002fc80003f9d000ULL,
0x000000011e1e1812ULL, 0x000fe400078efcffULL, 0x0000006700da7306ULL, 0x000e620000005400ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x000000871e1e723eULL, 0x000fc800000010ffULL,
0x000000017a7a4812ULL, 0x008fe200078efcffULL, 0x0000006700747306ULL, 0x000eb0000000d400ULL,
0x0000006100a87306ULL, 0x000fe20000209400ULL, 0x000000dad800720bULL, 0x002fce0003f5d000ULL,
0x0000006100a97306ULL, 0x000fec0000205400ULL, 0x0000000174742812ULL, 0x004fe400078efcffULL,
0x0000006100647306ULL, 0x0003e2000020d400ULL, 0x000000e5e600720bULL, 0x000fce0003f5d000ULL,
0x0000006800ca7306ULL, 0x000fe20000009400ULL, 0x0001000069617824ULL, 0x002fca00078e00ffULL,
0x0000000127272812ULL, 0x000fe400078efcffULL, 0x0000006800c97306ULL, 0x000e700000005400ULL,
0x0000006800677306ULL, 0x000eb0000000d400ULL, 0x0000006900b27306ULL, 0x000fe20000009400ULL,
0x000000c9ca00720bULL, 0x002fce0003f9d000ULL, 0x0000006900b57306ULL, 0x000fec0000005400ULL,
0x0000000167674812ULL, 0x004fe400078efcffULL, 0x0000006900687306ULL, 0x000ff0000000d400ULL,
0x0000003900c77306ULL, 0x000ff00000209400ULL, 0x0000003900c57306ULL, 0x000e700000205400ULL,
0x0000003900697306ULL, 0x0004f0000020d400ULL, 0x0000006300d17306ULL, 0x000fe20000209400ULL,
0x000000003838783bULL, 0x004ea20000000200ULL, 0x000000c5c700720bULL, 0x002fcc0003f9d000ULL,
0x0000006300d57306ULL, 0x000e6e0000205400ULL, 0x0000000169694812ULL, 0x008fe200078efcffULL,
0x0000006300897306ULL, 0x000730000020d400ULL, 0x0000004a009e7306ULL, 0x000fe20000209400ULL,
0x0000010066637824ULL, 0x008fe200078e00ffULL, 0x000000d5d100720bULL, 0x002fc80003fdd000ULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000004a009f7306ULL, 0x000fee0000205400ULL,
0x0000000189896812ULL, 0x010fe200078efcffULL, 0x0000006300c27306ULL, 0x000fe20000209400ULL,
0x0000002a3838b231ULL, 0x004fc400003400ffULL, 0x0000002a3a3ab231ULL, 0x000fe400003400ffULL,
0x000000293939b231ULL, 0x080fe400003400ffULL, 0x000000293b3bb231ULL, 0x000fe200003400ffULL,
0x0000006300d77306ULL, 0x000e6c0000205400ULL, 0x000000443844723cULL, 0x040fe20000041840ULL,
0x000000009440783bULL, 0x0004e20000000200ULL, 0x00000063007b7306ULL, 0x000f2c000020d400ULL,
0x000000483834723cULL, 0x000fe20000041834ULL, 0x000000840c94723eULL, 0x004fe200000010ffULL,
0x0000004a00637306ULL, 0x0005e2000020d400ULL, 0x000000d7c200720bULL, 0x002fc40003f3d000ULL,
0x0000008a8984723eULL, 0x000fc600000010ffULL, 0x000000943858723cULL, 0x000fe40000041858ULL,
0x0000006600dd7306ULL, 0x000fe20000009400ULL, 0x00013000b14a7811ULL, 0x004fca00078e20ffULL,
0x000000017b7b1812ULL, 0x010fe200078efcffULL, 0x000000783850723cULL, 0x000fe20000041850ULL,
0x0000006600de7306ULL, 0x000e620000005400ULL, 0x000000c4c100720bULL, 0x000fca0003f3d000ULL,
0x0000008daa78723eULL, 0x000fe200000010ffULL, 0x000000723854723cULL, 0x000fe20000041854ULL,
0x0000004b00817306ULL, 0x000fe20000209400ULL, 0x000000a4ab79723eULL, 0x000fca00000010ffULL,
0x0000000177771812ULL, 0x000fe200078efcffULL, 0x0000002a4040b231ULL, 0x088fe200003400ffULL,
0x0000004b00827306ULL, 0x000fe20000205400ULL, 0x000000dedd00720bULL, 0x002fe20003fdd000ULL,
0x0000002a4242b231ULL, 0x000fe200003400ffULL, 0x000000b5b200720bULL, 0x000fe20003f3d000ULL,
0x000000294141b231ULL, 0x080fe200003400ffULL, 0x000000a60e73723eULL, 0x000fe200000010ffULL,
0x000000294343b231ULL, 0x000fe200003400ffULL, 0x000000ac0f0e723eULL, 0x000fe200000010ffULL,
0x0000004b005d7306ULL, 0x0003e2000020d400ULL, 0x00000078384c723cULL, 0x000fe2000004184cULL,
0x000000a71d0f723eULL, 0x000fc400000010ffULL, 0x0000008e1172723eULL, 0x000fe400000010ffULL,
0x00000096938e723eULL, 0x000fe400000010ffULL, 0x00000066007c7306ULL, 0x000ea2000000d400ULL,
0x000000004a48783bULL, 0x002e620000000200ULL, 0x0000000168681812ULL, 0x000fe200078efcffULL,
0x000000124034723cULL, 0x000fe20000041834ULL, 0x000000e9ea00720bULL, 0x000fc80003f3d000ULL,
0x0000006200ae7306ULL, 0x000fe40000209400ULL, 0x000000652713723eULL, 0x000fe200000010ffULL,
0x0000000e3830723cULL, 0x040fea0000041830ULL, 0x0000006200af7306ULL, 0x000ee20000205400ULL,
0x000000017c7c6812ULL, 0x004fe400078efcffULL, 0x000000e3e400720bULL, 0x000fe20003fdd000ULL,
0x00000072383c723cULL, 0x000fe2000004183cULL, 0x0000000121211812ULL, 0x000fc400078efcffULL,
0x000000910d0e723eULL, 0x000fe200000010ffULL, 0x0000006200667306ULL, 0x000522000020d400ULL,
0x000000881f0f723eULL, 0x000fe400000010ffULL, 0x000000a3a572723eULL, 0x000fe200000010ffULL,
0x0000008e4054723cULL, 0x000fe20000041854ULL, 0x0000009c9d73723eULL, 0x000fe400000010ffULL,
0x0000007a0a1f723eULL, 0x000fe200000010ffULL, 0x0000006a00b67306ULL, 0x000fe20000009400ULL,
0x000000afae00720bULL, 0x008fc40003f5d000ULL, 0x00000018ff627819ULL, 0x004fe20000011461ULL,
0x0000000e4058723cULL, 0x000fe20000041858ULL, 0x0000000128286812ULL, 0x000fc600078efcffULL,
0x0000006a00b77306ULL, 0x000ea20000005400ULL, 0x0000002a4848b231ULL, 0x082fe200003400ffULL,
0x000000772812723eULL, 0x000fe200000010ffULL, 0x0000002a4a4ab231ULL, 0x000fe200003400ffULL,
0x0000007c7b0e723eULL, 0x000fe200000010ffULL, 0x000000294949b231ULL, 0x080fe200003400ffULL,
0x0000000166662812ULL, 0x010fe200078efcffULL, 0x000000294b4bb231ULL, 0x000fe200003400ffULL,
0x0000002d00977306ULL, 0x000fe20000209400ULL, 0x000000a9a800720bULL, 0x000fe20003f7d000ULL,
0x000000724044723cULL, 0x000fe20000041844ULL, 0x000000e7e800720bULL, 0x000fc40003f5d000ULL,
0x00000074700f723eULL, 0x000fe400000010ffULL, 0x000000676666723eULL, 0x000fe200000010ffULL,
0x0000002d00987306ULL, 0x000e620000205400ULL, 0x000000b7b600720bULL, 0x004fe20003fdd000ULL,
0x0000001e403c723cULL, 0x040fe8000004183cULL, 0x0000000164643812ULL, 0x000fe400078efcffULL,
0x0000006c00a07306ULL, 0x000fe20000009400ULL, 0x0000000122222812ULL, 0x000fe200078efcffULL,
0x0000000e404c723cULL, 0x000fe2000004184cULL, 0x0000009f9e00720bULL, 0x000fc40003f5d000ULL,
0x000000686467723eULL, 0x000fc600000010ffULL, 0x0000006c00a17306ULL, 0x000ea20000005400ULL,
0x000000989700720bULL, 0x002fe20003f3d000ULL, 0x000000844050723cULL, 0x040fec0000041850ULL,
0x0000006200cb7306ULL, 0x000fe20000209400ULL, 0x0000000163632812ULL, 0x000fe200078efcffULL,
0x000000124030723cULL, 0x000fec0000041830ULL, 0x0000006200c87306ULL, 0x000e620000205400ULL,
0x000000a1a000720bULL, 0x004fe20003f9d000ULL, 0x000000664840723cULL, 0x000fec0000041844ULL,
0x0000006200617306ULL, 0x000eb0000020d400ULL, 0x0000006a00627306ULL, 0x000ee2000000d400ULL,
0x000000c8cb00720bULL, 0x002fce0003f7d000ULL, 0x0000002d005e7306ULL, 0x000e6c000020d400ULL,
0x0000000161613812ULL, 0x004fe400078efcffULL, 0x0000006c002e7306ULL, 0x000ea2000000d400ULL,
0x0000000162626812ULL, 0x008fe400078efcffULL, 0x000000ebec00720bULL, 0x000fc40003fdd000ULL,
0x00000061210d723eULL, 0x000fe400000010ffULL, 0x000000626362723eULL, 0x000fe200000010ffULL,
0x00000075000c7306ULL, 0x000fe20000209400ULL, 0x000000015e5e1812ULL, 0x002fe400078efcffULL,
0x000000edee00720bULL, 0x000fca0003f3d000ULL, 0x0000007500717306ULL, 0x000e620000205400ULL,
0x000000012e2e4812ULL, 0x004fe400078efcffULL, 0x0000000120206812ULL, 0x000fe400078efcffULL,
0x000000828100720bULL, 0x000fc60003fdd000ULL, 0x0000006b00b87306ULL, 0x000fe20000009400ULL,
0x0000000109091812ULL, 0x000fce00078efcffULL, 0x0000006b00b97306ULL, 0x000ea20000005400ULL,
0x000000710c00720bULL, 0x002fe40003f9d000ULL, 0x00000069220c723eULL, 0x000fe400000010ffULL,
0x000000015d5d6812ULL, 0x000fe400078efcffULL, 0x000000fbfc00720bULL, 0x000fe20003fdd000ULL,
0x0000006d00997306ULL, 0x000fe20000009400ULL, 0x0000002e5d2e723eULL, 0x000fe200000010ffULL,
0x0000000c4834723cULL, 0x000fec0000041834ULL, 0x0000006d009a7306ULL, 0x000e620000005400ULL,
0x000000b9b800720bULL, 0x004fc60003fbd000ULL, 0x0000000126266812ULL, 0x000fe400078efcffULL,
0x000000f6f700720bULL, 0x000fe40003fdd000ULL, 0x0000006d002d7306ULL, 0x000eb0000000d400ULL,
0x0000002c00c67306ULL, 0x000fe20000209400ULL, 0x0000009a9900720bULL, 0x002fc40003f7d000ULL,
0x0000000125256812ULL, 0x000fca00078efcffULL, 0x0000002c00c07306ULL, 0x000e6c0000205400ULL,
0x000000012d2d3812ULL, 0x004fe400078efcffULL, 0x000000bc007d7306ULL, 0x000fe20000209400ULL,
0x000000f9fa00720bULL, 0x000fce0003f7d000ULL, 0x000000bc006d7306ULL, 0x000ea20000205400ULL,
0x000000c0c600720bULL, 0x002fca0003f5d000ULL, 0x0000000124243812ULL, 0x000fe400078efcffULL,
0x0000006b00607306ULL, 0x0002f0000000d400ULL, 0x0000007500117306ULL, 0x000f22000020d400ULL,
0x000100006b6b7824ULL, 0x002fe200078e00ffULL, 0x0000006d7d00720bULL, 0x004fc80003f3d000ULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x000000ba001a7306ULL, 0x000fe20000209400ULL,
0x0000000160605812ULL, 0x008fc800078efcffULL, 0x000000605e63723eULL, 0x000fc600000010ffULL,
0x000000ba00397306ULL, 0x000e620000205400ULL, 0x0000000111114812ULL, 0x010fc600078efcffULL,
0x000000624854723cULL, 0x000fe20000041854ULL, 0x000000112626723eULL, 0x000fc600000010ffULL,
0x0000002c005f7306ULL, 0x000eb0000020d400ULL, 0x0000006b008b7306ULL, 0x000fe20000209400ULL,
0x000000391a00720bULL, 0x002fce0003f9d000ULL, 0x0000006b008c7306ULL, 0x000e620000205400ULL,
0x000000015f5f2812ULL, 0x004fc800078efcffULL, 0x0000005f2020723eULL, 0x000fc600000010ffULL,
0x000000bc006c7306ULL, 0x000eb0000020d400ULL, 0x0000006e007f7306ULL, 0x000fe20000009400ULL,
0x0000008c8b00720bULL, 0x002fce0003fbd000ULL, 0x0000006e00807306ULL, 0x000e620000005400ULL,
0x000000016c6c1812ULL, 0x004fce00078efcffULL, 0x0000006e002c7306ULL, 0x0004f0000000d400ULL,
0x000000bb001d7306ULL, 0x000fe20000209400ULL, 0x000100006e6e7824ULL, 0x004fe200078e00ffULL,
0x000000807f00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x000000bb002a7306ULL, 0x000e6e0000205400ULL, 0x000000012c2c2812ULL, 0x008fe200078efcffULL,
0x0000006b002f7306ULL, 0x000eb0000020d400ULL, 0x0000006f006a7306ULL, 0x000fe20000009400ULL,
0x0000002a1d00720bULL, 0x002fce0003f3d000ULL, 0x0000006f006b7306ULL, 0x000e620000005400ULL,
0x000000012f2f5812ULL, 0x004fc800078efcffULL, 0x0000002f0921723eULL, 0x000fe400000010ffULL,
0x0000002d6c2f723eULL, 0x000fe200000010ffULL, 0x0000006f002b7306ULL, 0x0004e2000000d400ULL,
0x0000000110097812ULL, 0x000fc600078ec0ffULL, 0x000000204858723cULL, 0x040fe80000041858ULL,
0x000000ba003b7306ULL, 0x000f22000020d400ULL, 0x000100006f6f7824ULL, 0x004fe200078e00ffULL,
0x0000006b6a00720bULL, 0x002fe40003fbd000ULL, 0x0000002e4850723cULL, 0x000fe40000041850ULL,
0x00000018ff6f7819ULL, 0x000fc4000001146fULL, 0x0000006e000a7306ULL, 0x000fee0000209400ULL,
0x000000012b2b5812ULL, 0x008fe200078efcffULL, 0x0000006e000f7306ULL, 0x000e620000205400ULL,
0x000000013b3b4812ULL, 0x010fc800078efcffULL, 0x0000002c3b2a723eULL, 0x000fc600000010ffULL,
0x000000bb00297306ULL, 0x000eb0000020d400ULL, 0x000000ad00387306ULL, 0x000fe20000209400ULL,
0x0000000f0a00720bULL, 0x002fce0003f9d000ULL, 0x000000ad00737306ULL, 0x000e620000205400ULL,
0x0000000129291812ULL, 0x004fe400078efcffULL, 0x000000f0f300720bULL, 0x000fe40003f3d000ULL,
0x000000292427723eULL, 0x000fc600000010ffULL, 0x0000006f000e7306ULL, 0x000fe80000209400ULL,
0x00000026483c723cULL, 0x000fe8000004183cULL, 0x0000006f000d7306ULL, 0x000ea20000205400ULL,
0x000000733800720bULL, 0x002fe40003f7d000ULL, 0x0000000123231812ULL, 0x000fc400078efcffULL,
0x000000010900780cULL, 0x000fc60003f25070ULL, 0x000000ad001e7306ULL, 0x000e70000020d400ULL,
0x0000006e006e7306ULL, 0x000ee2000020d400ULL, 0x0000000d0e00720bULL, 0x004fce0003f5d000ULL,
0x0000006f000a7306ULL, 0x000ea2000020d400ULL, 0x000000011e1e3812ULL, 0x002fc800078efcffULL,
0x0000002b1e2b723eULL, 0x000fe400000010ffULL, 0x000000016e6e4812ULL, 0x008fc800078efcffULL,
0x0000006e2522723eULL, 0x000fe200000010ffULL, 0x0000002a484c723cULL, 0x000fe2000004184cULL,
0x000000010a0a2812ULL, 0x004fc800078efcffULL, 0x0000000a2323723eULL, 0x000fce00000010ffULL,
0x000000224848723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000240001e17983ULL, 0x000ea20000300800ULL,
0x000000080b097207ULL, 0x000fe40004800000ULL, 0x00000001100c7812ULL, 0x000fe200078e0cffULL,
0x01c63000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff09ff7812ULL, 0x000fe4000784c0ffULL,
0x000000c003097811ULL, 0x000fe400078e40ffULL, 0x00000001ff0d7807ULL, 0x000fc40001000000ULL,
0x000000090200720cULL, 0x000fe40003f44070ULL, 0x000000080d0d7207ULL, 0x000fc80004800000ULL,
0x000076100d137816ULL, 0x000fe40000000013ULL, 0x000000ffe1ff7812ULL, 0x004fc8000786c0ffULL,
0x00000001ff127807ULL, 0x000fe20001800000ULL, 0x00004a800000a947ULL, 0x000fea0003800000ULL,
0x01c65c00ff097984ULL, 0x000e620000000800ULL, 0x800000001b0a7824ULL, 0x000fca00078e00ffULL,
0x8000000009ff7812ULL, 0x002fe2000782480aULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01c65c00ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000782480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000001b1b7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff097424ULL, 0x000fc800078e00ffULL, 0x00000009000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000009097823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc4000782481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000000000d7919ULL, 0x000e620000002600ULL, 0x0000030003097a10ULL, 0x000fe20007ffe0ffULL,
0x00000100ff317424ULL, 0x000fe200078e00ffULL, 0x00004000efef7812ULL, 0x000fe200078ec0ffULL,
0x00000000000c7919ULL, 0x000ea20000002700ULL, 0x000000081c127812ULL, 0x000fe200078ec0ffULL,
0x0000010009117824ULL, 0x040fe200078e00ffULL, 0x0000000109097810ULL, 0x000fe20007ffe0ffULL,
0x00000000000a7919ULL, 0x000ee20000000000ULL, 0x00014000efef7810ULL, 0x000fe20007ffe0ffULL,
0x00000000120473c2ULL, 0x000f2200000e0000ULL, 0x000000040900720cULL, 0x000fc60003f26070ULL,
0x00000010f5f57824ULL, 0x100fe400078e02efULL, 0x00000010f1f17824ULL, 0x100fe400078e02efULL,
0x0000001015157824ULL, 0x100fe400078e02efULL, 0x0000001017177824ULL, 0x000fe200078e02efULL,
0x000058000d0d7a10ULL, 0x002fe20007ffe0ffULL, 0x000000020c0c7824ULL, 0x004fc800078e00ffULL,
0x000058000c0c7a24ULL, 0x000fe200078e020dULL, 0x00000004ff1d7819ULL, 0x008fe2000001160aULL,
0x000000100a287824ULL, 0x000fe200078e00ffULL, 0x00000011020a7217ULL, 0x000fe20007800000ULL,
0x000062000c297a24ULL, 0x100fe200078e0211ULL, 0x000000021d277810ULL, 0x000fe20007ffe0ffULL,
0x0001c64804047890ULL, 0x010fe2000fffe03fULL, 0x000000f028287812ULL, 0x000fe200078ec0ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a11ULL, 0x0000001d290c7210ULL, 0x140fe40007ffe0f8ULL,
0x00000027290e7210ULL, 0x000fc40007ffe0f8ULL, 0x000000041d2f7810ULL, 0x040fe20007ffe0ffULL,
0x00005e000c0c7625ULL, 0x080fe200078e0031ULL, 0x000000061d2d7810ULL, 0x000fe40007ffe0ffULL,
0x000000400a097807ULL, 0x000fe20000800000ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0031ULL,
0x000000280c1e7210ULL, 0x080fe40007f5e0ffULL, 0x0000002f290c7210ULL, 0x140fe40007ffe0f8ULL,
0x000000280e207210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e060dULL,
0x0000002d290e7210ULL, 0x000fe20007ffe0f8ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0031ULL,
0x000000081d2b7810ULL, 0x000fc40007ffe0ffULL, 0x00000009f8097217ULL, 0x000fe20007800000ULL,
0x000000ffff217224ULL, 0x000fe200018e060fULL, 0x000000280c227210ULL, 0x080fe20007f3e0ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e0031ULL, 0x0000002b290c7210ULL, 0x100fe40007ffe0f8ULL,
0x0000000a1d117810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200008e060dULL,
0x000000280e247210ULL, 0x000fe20007f3e0ffULL, 0x00000001090a7824ULL, 0x100fe200078e0af8ULL,
0x00000011291a7210ULL, 0x000fe20007ffe0f8ULL, 0x00005e000c0c7625ULL, 0x000fc600078e0031ULL,
0x0000000a1d00720cULL, 0x000fe20003f86070ULL, 0x000000ffff257224ULL, 0x000fe200008e060fULL,
0x000000280c267210ULL, 0x000fe20007f3e0ffULL, 0x00000010f4097824ULL, 0x000fe200078e02efULL,
0x0000000a2700720cULL, 0x080fe20003fa6070ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0031ULL,
0x0000000a2b00720cULL, 0x080fe40003f66070ULL, 0x0000000e1d2b7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe200008e060dULL, 0x0000000c1d0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010f21d7824ULL, 0x000fe200078e02efULL, 0x0000000a2f00720cULL, 0x000fe20003f26070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001ef57faeULL, 0x0003e2000e101c46ULL,
0x0000000d290c7210ULL, 0x000fc40007ffe0f8ULL, 0x000000281a1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000020097faeULL, 0x0005e2000e901c46ULL, 0x0000000a0d00720cULL, 0x080fe20003fa6070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0031ULL, 0x0000002b290e7210ULL, 0x000fe40007ffe0f8ULL,
0x0000000a1100720cULL, 0x000fe20003f86070ULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x000000280c0c7210ULL, 0x000fe20007fde0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0031ULL,
0x0000000a2d00720cULL, 0x080fe20003f46070ULL, 0x00000000221d7faeULL, 0x0003e4000c901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0000000a2b00720cULL, 0x000fe20003fc6070ULL,
0x0000001014117824ULL, 0x100fe200078e02efULL, 0x000000280e0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001016097824ULL, 0x004fe200078e02efULL, 0x000000081c0a7812ULL, 0x000fc600078e0cffULL,
0x000000ffff0f7224ULL, 0x000fe400008e060fULL, 0x0000000024f17faeULL, 0x0003e8000d101c46ULL,
0x0000000026117faeULL, 0x0003e8000d901c46ULL, 0x000000001a157faeULL, 0x0003e8000e101c46ULL,
0x000000000c097faeULL, 0x0003e8000e901c46ULL, 0x000000000e177faeULL, 0x0003e8000f101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c64c000a0a7984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c63c00ff0c7984ULL, 0x002e620000000800ULL,
0x0000ffff13097812ULL, 0x000fe200078ec0ffULL, 0x80000000180d7824ULL, 0x000fc800078e00ffULL,
0x8000000009097824ULL, 0x000fca00078e00ffULL, 0x800000000aff7812ULL, 0x004fe40007824809ULL,
0x800000000cff7812ULL, 0x002fe2000784480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000000110117812ULL, 0x000fe200078e0cffULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x80000000180d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff097424ULL, 0x000fc800078e00ffULL,
0x00000009000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000009097823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe40003800000ULL, 0x01c63c00ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc4000784480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x01c18000190a7984ULL, 0x000e620000000800ULL,
0x00000001ff617424ULL, 0x000fc600078e00ffULL, 0x01c3800019097984ULL, 0x0004e20000000800ULL,
0x000000050a00720bULL, 0x002fda0003f5d000ULL, 0x00000000000c7806ULL, 0x000fc800010e0100ULL,
0x0000ffff0c0e7812ULL, 0x000fda000784c0ffULL, 0x000003700000a947ULL, 0x000fea0003800000ULL,
0x000000050a00720bULL, 0x00cfe20003f54000ULL, 0x0000000000137919ULL, 0x000e620000000000ULL,
0x0000000a05127209ULL, 0x000fca0007810000ULL, 0x80000012050c7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL, 0x0000000000057806ULL, 0x000fe400010e0100ULL,
0x0000000c000d7308ULL, 0x000ea20000000800ULL, 0x000000030000780cULL, 0x000fe40003f45270ULL,
0x0000ffff050f7812ULL, 0x000fc800078e3cffULL, 0x0000000f0eff7212ULL, 0x000fe4000786c0ffULL,
0x00000002ff147819ULL, 0x102fe40000011613ULL, 0x00000002ff137819ULL, 0x000fc60000011613ULL,
0x01c580121900a388ULL, 0x000fe20000000800ULL, 0x00000001ff617807ULL, 0x000fe20001800000ULL,
0x0000000d06067220ULL, 0x004fe20000410000ULL, 0x0000000813137810ULL, 0x000fe20007ffe0ffULL,
0x00001f140d057589ULL, 0x000e6400000e0000ULL, 0x800000120a0e3221ULL, 0x000fe40000010000ULL,
0x00001f130d0a7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b0e0e3820ULL, 0x000fc80000410000ULL,
0x0000000e00073308ULL, 0x000ee20000000800ULL, 0x0000000540407220ULL, 0x082fe40000410000ULL,
0x0000000541417220ULL, 0x080fe40000410000ULL, 0x0000000534347220ULL, 0x080fe40000410000ULL,
0x0000000535357220ULL, 0x080fe40000410000ULL, 0x0000000554547220ULL, 0x080fe40000410000ULL,
0x0000000555557220ULL, 0x000fc40000410000ULL, 0x0000000558587220ULL, 0x080fe40000410000ULL,
0x0000000559597220ULL, 0x080fe40000410000ULL, 0x0000000550507220ULL, 0x080fe40000410000ULL,
0x0000000551517220ULL, 0x080fe40000410000ULL, 0x000000053c3c7220ULL, 0x080fe40000410000ULL,
0x000000053d3d7220ULL, 0x000fc40000410000ULL, 0x000000054c4c7220ULL, 0x080fe40000410000ULL,
0x000000054d4d7220ULL, 0x080fe40000410000ULL, 0x0000000548487220ULL, 0x080fe40000410000ULL,
0x0000000549497220ULL, 0x000fe40000410000ULL, 0x0000000a42427220ULL, 0x084fe40000410000ULL,
0x0000000a43437220ULL, 0x000fc40000410000ULL, 0x0000000a36367220ULL, 0x080fe40000410000ULL,
0x0000000a37377220ULL, 0x080fe40000410000ULL, 0x0000000a56567220ULL, 0x080fe40000410000ULL,
0x0000000a57577220ULL, 0x080fe40000410000ULL, 0x0000000a5a5a7220ULL, 0x080fe40000410000ULL,
0x0000000a5b5b7220ULL, 0x000fc40000410000ULL, 0x0000000a52527220ULL, 0x080fe40000410000ULL,
0x0000000a53537220ULL, 0x080fe40000410000ULL, 0x0000000a3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000a3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000a4e4e7220ULL, 0x080fe40000410000ULL,
0x0000000a4f4f7220ULL, 0x000fc40000410000ULL, 0x0000000a4a4a7220ULL, 0x080fe40000410000ULL,
0x0000000a4b4b7220ULL, 0x000fe40000410000ULL, 0x000000ffff057224ULL, 0x000fe400078e0012ULL,
0x0000000907093220ULL, 0x008fc80000410000ULL, 0x0000000609067221ULL, 0x00cfe20000010000ULL,
0x0000017000001947ULL, 0x000fea0003800000ULL, 0x0000000810097824ULL, 0x040fe200078e00ffULL,
0x0000000110ff7812ULL, 0x000fc8000784c0ffULL, 0x00000008090a7812ULL, 0x000fe400078e0cffULL,
0x0000000b08097207ULL, 0x000fc80005000000ULL, 0x01c64c000a0a7984ULL, 0x000e620000000800ULL,
0x000000ff09ff7812ULL, 0x000fc8000782c0ffULL, 0x00000001ff097807ULL, 0x000fc80000800000ULL,
0x0000000908097207ULL, 0x000fc80005000000ULL, 0x0000ffff090c7812ULL, 0x000fca00078ec0ffULL,
0x800000000c097824ULL, 0x000fca00078e00ffULL, 0x800000000aff7812ULL, 0x002fe20007824809ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0001c648110d7811ULL, 0x000fe200078e18ffULL, 0x800000000c0f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff097424ULL, 0x000fc800078e00ffULL, 0x00000009000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000009097823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe40003800000ULL,
0x000004000d0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc4000782480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000000010c7983ULL, 0x000ea80000300800ULL, 0x00000400010a7983ULL, 0x000ee80000300800ULL,
0x00000800010e7983ULL, 0x000f280000300800ULL, 0x00000c00010f7983ULL, 0x000f680000300800ULL,
0x000000000c2c783bULL, 0x004e680000004200ULL, 0x000000000a44783bULL, 0x008ea80000004200ULL,
0x000000000e28783bULL, 0x0107280000004200ULL, 0x000000000f24783bULL, 0x020a680000004200ULL,
0x00001400010e7983ULL, 0x008ee80000300800ULL, 0x0000180001117983ULL, 0x000ea80000300800ULL,
0x00001c00010f7983ULL, 0x020f680000300800ULL, 0x000000000e18783bULL, 0x0087280000004200ULL,
0x000000001120783bULL, 0x004ea80000004200ULL, 0x00002000010e7983ULL, 0x008ee80000300800ULL,
0x000000000f30783bULL, 0x0205620000004200ULL, 0x00000018ff0c7819ULL, 0x002fc4000001142eULL,
0x00000018ff0a7819ULL, 0x000fe4000001142dULL, 0x0000000c00a37306ULL, 0x000ff00000209400ULL,
0x0000000c00cf7306ULL, 0x000ff00000205400ULL, 0x0000000c00d17306ULL, 0x0003e4000020d400ULL,
0x00000018ff0c7819ULL, 0x002fcc0000011446ULL, 0x0000000a00c27306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x000fce000001142fULL, 0x0000000a00a97306ULL, 0x000ff00000205400ULL,
0x0000000a005d7306ULL, 0x0003f0000020d400ULL, 0x0000000c007c7306ULL, 0x000fe20000209400ULL,
0x00000018ff0a7819ULL, 0x002fce0000011445ULL, 0x0000000c007a7306ULL, 0x000ff00000205400ULL,
0x0000000c00b87306ULL, 0x0009e4000020d400ULL, 0x00000018ff0c7819ULL, 0x010fcc000001142aULL,
0x0000000a00817306ULL, 0x000ff00000209400ULL, 0x0000000a00827306ULL, 0x000ff00000205400ULL,
0x0000000a00917306ULL, 0x0003f0000020d400ULL, 0x0000000c001d7306ULL, 0x000fe20000209400ULL,
0x00000018ff0a7819ULL, 0x002fce0000011429ULL, 0x0000000c00657306ULL, 0x000ff00000205400ULL,
0x0000000c00a27306ULL, 0x0003e4000020d400ULL, 0x00000018ff0c7819ULL, 0x002fcc0000011426ULL,
0x0000000d006b7306ULL, 0x000fe20000209400ULL, 0x00000018ff097819ULL, 0x000fce000001142cULL,
0x0000000d00957306ULL, 0x000ff00000205400ULL, 0x0000000d00c17306ULL, 0x0003f0000020d400ULL,
0x0000000a00cb7306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x002fce0000011447ULL,
0x0000000a00647306ULL, 0x000ff00000205400ULL, 0x0000000a00b37306ULL, 0x0003f0000020d400ULL,
0x0000000c00837306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x002fce0000011425ULL,
0x0000000c00847306ULL, 0x000ff00000205400ULL, 0x0000000c00807306ULL, 0x0003e4000020d400ULL,
0x00000018ff0c7819ULL, 0x002fcc000001141aULL, 0x0000000d006d7306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x004fce0000011423ULL, 0x0000000d007b7306ULL, 0x000ff00000205400ULL,
0x0000000d00ad7306ULL, 0x0003f0000020d400ULL, 0x0000000a00997306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x002fce000001142bULL, 0x0000000a00987306ULL, 0x000ff00000205400ULL,
0x0000000a008c7306ULL, 0x0003f0000020d400ULL, 0x0000000c00607306ULL, 0x000fe20000209400ULL,
0x00000018ff0a7819ULL, 0x002fce0000011419ULL, 0x0000000c00747306ULL, 0x000fe20000205400ULL,
0x000000000e38783bULL, 0x008e6e0000004200ULL, 0x0000000c00627306ULL, 0x0005e2000020d400ULL,
0x00000018ff737819ULL, 0x020fe40000011433ULL, 0x00000018ff0c7819ULL, 0x004fca0000011422ULL,
0x0000000900bc7306ULL, 0x000ff00000209400ULL, 0x0000000900df7306ULL, 0x000ff00000205400ULL,
0x0000000900727306ULL, 0x0005f0000020d400ULL, 0x0000000d00c87306ULL, 0x000fe20000209400ULL,
0x00000018ff097819ULL, 0x004fce0000011444ULL, 0x0000000d00c07306ULL, 0x000fe20000205400ULL,
0x00000018ff757819ULL, 0x002fce0000011439ULL, 0x0000000d009e7306ULL, 0x0003f0000020d400ULL,
0x0000000a00867306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x002fce0000011427ULL,
0x0000000a00967306ULL, 0x000ff00000205400ULL, 0x0000000a00697306ULL, 0x0003f0000020d400ULL,
0x0000000c00a17306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x002fce0000011421ULL,
0x0000000c00a07306ULL, 0x000ff00000205400ULL, 0x0000000c00157306ULL, 0x0003e2000020d400ULL,
0x00000018ff7d7819ULL, 0x000fe4000001143aULL, 0x00000018ff0c7819ULL, 0x002fca0000011432ULL,
0x00000009008f7306ULL, 0x000ff00000209400ULL, 0x00000009008d7306ULL, 0x000ff00000205400ULL,
0x0000000900907306ULL, 0x0003f0000020d400ULL, 0x0000000d001c7306ULL, 0x000fe20000209400ULL,
0x00000018ff097819ULL, 0x002fce0000011428ULL, 0x0000000d001e7306ULL, 0x000ff00000205400ULL,
0x0000000d007f7306ULL, 0x0003f0000020d400ULL, 0x0000000a00ac7306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x002fce000001141bULL, 0x0000000a00b77306ULL, 0x000ff00000205400ULL,
0x0000000a00117306ULL, 0x0003f0000020d400ULL, 0x0000000f009a7306ULL, 0x000fe20000209400ULL,
0x00000018ff0a7819ULL, 0x002fce0000011431ULL, 0x0000000f009b7306ULL, 0x000ff00000205400ULL,
0x0000000f000e7306ULL, 0x000ff0000020d400ULL, 0x0000000c00d57306ULL, 0x000ff00000209400ULL,
0x0000000c00d07306ULL, 0x000ff00000205400ULL, 0x0000000c00137306ULL, 0x000ff0000020d400ULL,
0x0000007300d77306ULL, 0x000ff00000209400ULL, 0x0000007300d67306ULL, 0x000ff00000205400ULL,
0x00000073000f7306ULL, 0x0003f0000020d400ULL, 0x0000007500fb7306ULL, 0x000fe20000209400ULL,
0x000001002c737824ULL, 0x002fce00078e00ffULL, 0x0000007500fa7306ULL, 0x000ff00000205400ULL,
0x00000075000c7306ULL, 0x0003f0000020d400ULL, 0x0000002c00a57306ULL, 0x000fe20000009400ULL,
0x000001002d757824ULL, 0x002fce00078e00ffULL, 0x0000002c00ba7306ULL, 0x000ff00000005400ULL,
0x0000002c00a77306ULL, 0x0003f0000000d400ULL, 0x0000000900637306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x002fce00078e00ffULL, 0x00000009006c7306ULL, 0x000fe20000205400ULL,
0x00000018ff2c7819ULL, 0x000fce000001142cULL, 0x0000000900b47306ULL, 0x0003f0000020d400ULL,
0x0000000d00707306ULL, 0x000fe20000209400ULL, 0x00000018ff097819ULL, 0x002fce0000011424ULL,
0x0000000d00717306ULL, 0x000ff00000205400ULL, 0x0000000d001f7306ULL, 0x000ff0000020d400ULL,
0x0000002e008a7306ULL, 0x000ff00000009400ULL, 0x0000002e00e87306ULL, 0x000e700000005400ULL,
0x0000000a006a7306ULL, 0x000ff00000209400ULL, 0x0000000a00687306ULL, 0x000ff00000205400ULL,
0x0000000a000d7306ULL, 0x000ff0000020d400ULL, 0x0000007d00f97306ULL, 0x000ff00000209400ULL,
0x0000007d00de7306ULL, 0x000ff00000205400ULL, 0x0000007d000a7306ULL, 0x0005f0000020d400ULL,
0x0000000900bf7306ULL, 0x000fe20000209400ULL, 0x00000018ff7d7819ULL, 0x004fe20000011475ULL,
0x000001002e757824ULL, 0x000fcc00078e00ffULL, 0x0000000900177306ULL, 0x000ff00000205400ULL,
0x00000009008e7306ULL, 0x0005e2000020d400ULL, 0x00000018ff737819ULL, 0x000fce0000011473ULL,
0x0000002e006f7306ULL, 0x000722000000d400ULL, 0x00000018ff097819ULL, 0x004fe20000011418ULL,
0x000100002e2e7824ULL, 0x008fcc00078e00ffULL, 0x0000002d00b57306ULL, 0x000fe20000009400ULL,
0x00000018ff2e7819ULL, 0x000fce000001142eULL, 0x0000002d00bb7306ULL, 0x000ff00000005400ULL,
0x0000002d00a67306ULL, 0x0005f0000000d400ULL, 0x0000002c00b67306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x004fce00078e00ffULL, 0x0000002c00db7306ULL, 0x000fe20000205400ULL,
0x00000018ff2d7819ULL, 0x000fce000001142dULL, 0x0000002c00dd7306ULL, 0x0005f0000020d400ULL,
0x0000000900677306ULL, 0x000fe20000209400ULL, 0x00000018ff2c7819ULL, 0x004fce0000011475ULL,
0x0000000900667306ULL, 0x000ff00000205400ULL, 0x0000000900797306ULL, 0x0005e2000020d400ULL,
0x000000e88a00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff097819ULL, 0x004fca0000011420ULL,
0x0000002c00ce7306ULL, 0x000ff00000209400ULL, 0x0000002c00d37306ULL, 0x000ff00000205400ULL,
0x0000002c00757306ULL, 0x0003f0000020d400ULL, 0x00000009005f7306ULL, 0x000fe20000209400ULL,
0x00000100442c7824ULL, 0x002fce00078e00ffULL, 0x00000009005e7306ULL, 0x000fe20000205400ULL,
0x00000018ff2c7819ULL, 0x000fce000001142cULL, 0x0000000900167306ULL, 0x0003e2000020d400ULL,
0x00000018ff7e7819ULL, 0x000fce000001143bULL, 0x0000002e00947306ULL, 0x000fe20000209400ULL,
0x00000018ff097819ULL, 0x002fce0000011430ULL, 0x0000002e009d7306ULL, 0x000e700000205400ULL,
0x0000007300f17306ULL, 0x000ff00000209400ULL, 0x0000007300f27306ULL, 0x000ff00000205400ULL,
0x0000007300e37306ULL, 0x000ff0000020d400ULL, 0x0000002d00d47306ULL, 0x000ff00000209400ULL,
0x0000002d00da7306ULL, 0x000ff00000205400ULL, 0x0000002d00737306ULL, 0x0005f0000020d400ULL,
0x0000000900777306ULL, 0x000fe20000209400ULL, 0x000100002f2d7824ULL, 0x004fce00078e00ffULL,
0x0000000900787306ULL, 0x000fe20000205400ULL, 0x00000018ff2d7819ULL, 0x000fce000001142dULL,
0x0000000900147306ULL, 0x0005e4000020d400ULL, 0x00000018ff097819ULL, 0x004fcc0000011438ULL,
0x0000002c00e27306ULL, 0x000fe20000209400ULL, 0x000000016f6f6812ULL, 0x010fce00078efcffULL,
0x0000002c00c97306ULL, 0x000ff00000205400ULL, 0x0000002c00977306ULL, 0x0005e2000020d400ULL,
0x0000009d9400720bULL, 0x002fce0003fdd000ULL, 0x0000000900fc7306ULL, 0x000fe20000205400ULL,
0x00000100462c7824ULL, 0x004fce00078e00ffULL, 0x0000000900127306ULL, 0x000ff0000020d400ULL,
0x0000007e00dc7306ULL, 0x000ff00000209400ULL, 0x0000007e00d87306ULL, 0x000ff00000205400ULL,
0x0000007e00097306ULL, 0x0003f0000020d400ULL, 0x0000002f00b97306ULL, 0x000fe20000009400ULL,
0x000001002f7e7824ULL, 0x002fce00078e00ffULL, 0x0000002f00eb7306ULL, 0x000ff00000005400ULL,
0x0000002f006e7306ULL, 0x000ff0000000d400ULL, 0x0000002e002f7306ULL, 0x000e70000020d400ULL,
0x0000002d00ee7306ULL, 0x000ff00000209400ULL, 0x0000002d00ef7306ULL, 0x000ff00000205400ULL,
0x0000002d00d27306ULL, 0x0005f0000020d400ULL, 0x00000047009c7306ULL, 0x000fe20000009400ULL,
0x00000018ff2d7819ULL, 0x004fce000001142cULL, 0x0000004700e67306ULL, 0x000ea20000005400ULL,
0x00000018ff7e7819ULL, 0x000fce000001147eULL, 0x0000007d00a87306ULL, 0x000ff00000209400ULL,
0x0000007d00ae7306ULL, 0x000ff00000205400ULL, 0x0000007d00e47306ULL, 0x0007e2000020d400ULL,
0x00000100472e7824ULL, 0x000fce00078e00ffULL, 0x0000004500af7306ULL, 0x000fe20000009400ULL,
0x00000100457d7824ULL, 0x008fce00078e00ffULL, 0x0000004500c37306ULL, 0x000ff00000005400ULL,
0x0000004500937306ULL, 0x0007f0000000d400ULL, 0x0000004400ab7306ULL, 0x000fe20000009400ULL,
0x0001000045457824ULL, 0x008fce00078e00ffULL, 0x0000004400f07306ULL, 0x000fe20000005400ULL,
0x00000018ff457819ULL, 0x000fce0000011445ULL, 0x0000004400927306ULL, 0x0007f0000000d400ULL,
0x0000002d002c7306ULL, 0x000fe20000209400ULL, 0x0001000044447824ULL, 0x008fce00078e00ffULL,
0x0000002d008b7306ULL, 0x000fe20000205400ULL, 0x00000018ff447819ULL, 0x000fce0000011444ULL,
0x0000002d00c57306ULL, 0x0007e4000020d400ULL, 0x00010000472d7824ULL, 0x008fcc00078e00ffULL,
0x0000007e009f7306ULL, 0x000fe20000209400ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x000000012f2f6812ULL, 0x002fca00078efcffULL, 0x0000007e00ca7306ULL, 0x000fe20000205400ULL,
0x000000e69c00720bULL, 0x004fce0003fdd000ULL, 0x0000007e00d97306ULL, 0x000ff0000020d400ULL,
0x0000004400887306ULL, 0x000ff00000209400ULL, 0x0000004400897306ULL, 0x000ff00000205400ULL,
0x0000004400877306ULL, 0x0003f0000020d400ULL, 0x0000004500ec7306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x002fce000001142eULL, 0x0000004500ed7306ULL, 0x000ff00000205400ULL,
0x0000004500857306ULL, 0x000ff0000020d400ULL, 0x0000004700c77306ULL, 0x000e70000000d400ULL,
0x0000002d00457306ULL, 0x000ff00000209400ULL, 0x0000002d007e7306ULL, 0x000ea20000205400ULL,
0x00010000462e7824ULL, 0x000fce00078e00ffULL, 0x0000004400e17306ULL, 0x000ff00000209400ULL,
0x0000004400cc7306ULL, 0x000ff00000205400ULL, 0x0000004400c47306ULL, 0x0007e2000020d400ULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x0000010028447824ULL, 0x008fcc00078e00ffULL,
0x0000004600e07306ULL, 0x000fe20000009400ULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000018ff2e7819ULL, 0x000fca000001142eULL, 0x0000004600e77306ULL, 0x000fe20000005400ULL,
0x00000001c7c76812ULL, 0x002fe400078efcffULL, 0x0000007e4500720bULL, 0x004fca0003fdd000ULL,
0x0000004600c67306ULL, 0x000ff0000000d400ULL, 0x0000002d00bd7306ULL, 0x000e70000020d400ULL,
0x0000004400467306ULL, 0x000ff00000209400ULL, 0x0000004400477306ULL, 0x000eb00000205400ULL,
0x0000007d00cd7306ULL, 0x000ff00000209400ULL, 0x0000007d00e57306ULL, 0x000ff00000205400ULL,
0x0000007d00b27306ULL, 0x000ff0000020d400ULL, 0x0000002e00aa7306ULL, 0x000ff00000209400ULL,
0x0000002e007d7306ULL, 0x000ff00000205400ULL, 0x0000002e00be7306ULL, 0x0007e2000020d400ULL,
0x000000bbb500720bULL, 0x000fe20003f5d000ULL, 0x00010000282e7824ULL, 0x008fcc00078e00ffULL,
0x0000004400bb7306ULL, 0x000722000020d400ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x00000001bdbd6812ULL, 0x002fca00078efcffULL, 0x0000002e00e97306ULL, 0x000fe20000209400ULL,
0x000000474600720bULL, 0x004fe40003fdd000ULL, 0x000000f2f100720bULL, 0x000fca0003f9d000ULL,
0x0000002e00ea7306ULL, 0x000e620000205400ULL, 0x0001000029447824ULL, 0x008fca00078e00ffULL,
0x00000018fff17819ULL, 0x000fe40000011444ULL, 0x0000002e00b57306ULL, 0x000ea2000020d400ULL,
0x00000001bbbb6812ULL, 0x010fe400078efcffULL, 0x000000baa500720bULL, 0x000fe40003f3d000ULL,
0x00000001e3e34812ULL, 0x000fc600078efcffULL, 0x000000f100447306ULL, 0x000fe20000209400ULL,
0x000000eae900720bULL, 0x002fe40003fdd000ULL, 0x000000ebb900720bULL, 0x000fe40003fbd000ULL,
0x000000dbb600720bULL, 0x000fc60003f9d000ULL, 0x000000f100e87306ULL, 0x000e700000205400ULL,
0x0000002800a47306ULL, 0x000ff00000009400ULL, 0x0000002800a57306ULL, 0x000ff00000005400ULL,
0x0000002800ba7306ULL, 0x0007f0000000d400ULL, 0x00000029008a7306ULL, 0x000fe20000009400ULL,
0x0000010029287824ULL, 0x008fce00078e00ffULL, 0x0000002900eb7306ULL, 0x000ff00000005400ULL,
0x0000002900b97306ULL, 0x0007e2000000d400ULL, 0x000000dfbc00720bULL, 0x000fe20003f7d000ULL,
0x000001002a297824ULL, 0x008fcc00078e00ffULL, 0x000000f100b67306ULL, 0x000ee2000020d400ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff287819ULL, 0x000fca0000011428ULL,
0x0000002900df7306ULL, 0x000fe20000209400ULL, 0x00000001b5b56812ULL, 0x004fe400078efcffULL,
0x00000001dddd4812ULL, 0x000fe400078efcffULL, 0x000000e84400720bULL, 0x002fc60003fdd000ULL,
0x0000002900db7306ULL, 0x000e620000205400ULL, 0x000000dad400720bULL, 0x000fe40003f9d000ULL,
0x00000001a7a71812ULL, 0x000fca00078efcffULL, 0x00000028002d7306ULL, 0x000fe20000209400ULL,
0x000000aea800720bULL, 0x000fce0003f3d000ULL, 0x00000028002e7306ULL, 0x000ff00000205400ULL,
0x0000002800bc7306ULL, 0x0005e4000020d400ULL, 0x000001002b287824ULL, 0x004fcc00078e00ffULL,
0x0000002900ae7306ULL, 0x000522000020d400ULL, 0x00000018fff17819ULL, 0x000fe40000011428ULL,
0x00000001b6b66812ULL, 0x008fca00078efcffULL, 0x000000f100d47306ULL, 0x000fe20000209400ULL,
0x000100002a297824ULL, 0x004fe200078e00ffULL, 0x0000000172723812ULL, 0x000fe400078efcffULL,
0x0000000173734812ULL, 0x000fe400078efcffULL, 0x000000dbdf00720bULL, 0x002fe40003fdd000ULL,
0x000000f100da7306ULL, 0x000e620000205400ULL, 0x000000f0ab00720bULL, 0x000fe40003f7d000ULL,
0x000000d3ce00720bULL, 0x000fc40003f9d000ULL, 0x00000018fff07819ULL, 0x000fe20000011429ULL,
0x000100002b297824ULL, 0x000fe200078e00ffULL, 0x00000001e4e41812ULL, 0x000fe200078efcffULL,
0x0000002a00287306ULL, 0x000fe20000009400ULL, 0x000000c3af00720bULL, 0x000fe40003f3d000ULL,
0x00000001a6a62812ULL, 0x000fe400078efcffULL, 0x000000a9c200720bULL, 0x000fc60003f5d000ULL,
0x0000002a00ab7306ULL, 0x000fe20000005400ULL, 0x00000001aeae6812ULL, 0x010fce00078efcffULL,
0x0000002a00af7306ULL, 0x0005e2000000d400ULL, 0x0000000175754812ULL, 0x000fe400078efcffULL,
0x000000dad400720bULL, 0x002fe40003fdd000ULL, 0x00000018ff2a7819ULL, 0x004fc60000011429ULL,
0x000000f100a87306ULL, 0x0002a2000020d400ULL, 0x000000ca9f00720bULL, 0x000fe20003f9d000ULL,
0x0000010024297824ULL, 0x000fcc00078e00ffULL, 0x0000002b00c27306ULL, 0x000ff00000009400ULL,
0x0000002b00c37306ULL, 0x000ff00000005400ULL, 0x0000002b00a97306ULL, 0x000ff0000000d400ULL,
0x0000002a002b7306ULL, 0x000ff00000209400ULL, 0x0000002a00d37306ULL, 0x000ee20000205400ULL,
0x00000018fff17819ULL, 0x002fc40000011429ULL, 0x00000001a8a86812ULL, 0x004fe400078efcffULL,
0x00000001d9d94812ULL, 0x000fc600078efcffULL, 0x0000002a009f7306ULL, 0x000e62000020d400ULL,
0x000000efee00720bULL, 0x000fe20003f9d000ULL, 0x0000010025947824ULL, 0x000fe200078e00ffULL,
0x000000015d5d2812ULL, 0x000fca00078efcffULL, 0x000000f100297306ULL, 0x000fe20000209400ULL,
0x000000d32b00720bULL, 0x008fe40003fdd000ULL, 0x000000cfa300720bULL, 0x000fca0003f5d000ULL,
0x000000f100ca7306ULL, 0x000ea20000205400ULL, 0x00000018ffee7819ULL, 0x000fe40000011494ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x00000001d2d24812ULL, 0x000fc600078efcffULL,
0x000000f1009d7306ULL, 0x000ee2000020d400ULL, 0x000000019f9f6812ULL, 0x002fe400078efcffULL,
0x000000e7e000720bULL, 0x000fe40003fbd000ULL, 0x000000c9e200720bULL, 0x000fc60003f9d000ULL,
0x000000ee00f67306ULL, 0x000fe20000209400ULL, 0x000000ca2900720bULL, 0x004fe20003fdd000ULL,
0x0001000024c97824ULL, 0x000fe200078e00ffULL, 0x00000001d1d12812ULL, 0x000fca00078efcffULL,
0x000000ee00f77306ULL, 0x000e620000205400ULL, 0x000000956b00720bULL, 0x000fce0003f5d000ULL,
0x0000002400e07306ULL, 0x000ff00000009400ULL, 0x0000002400e77306ULL, 0x000ff00000005400ULL,
0x00000024009c7306ULL, 0x0005e4000000d400ULL, 0x0001000025247824ULL, 0x004fcc00078e00ffULL,
0x000000ee00947306ULL, 0x000ea2000020d400ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x000000019d9d6812ULL, 0x008fca00078efcffULL, 0x0000002400e67306ULL, 0x000fe20000209400ULL,
0x000000f7f600720bULL, 0x002fe40003fdd000ULL, 0x00000001c1c12812ULL, 0x000fca00078efcffULL,
0x0000002400f57306ULL, 0x000e620000205400ULL, 0x0000008d8f00720bULL, 0x000fe40003f5d000ULL,
0x0000000197974812ULL, 0x000fca00078efcffULL, 0x00000025002a7306ULL, 0x000fe20000009400ULL,
0x000000e5cd00720bULL, 0x000fce0003f9d000ULL, 0x00000025006b7306ULL, 0x000ff00000005400ULL,
0x0000002500957306ULL, 0x0007e4000000d400ULL, 0x0000010026257824ULL, 0x008fcc00078e00ffULL,
0x00000024008d7306ULL, 0x000ee2000020d400ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000000194946812ULL, 0x004fca00078efcffULL, 0x0000002500cd7306ULL, 0x000fe20000209400ULL,
0x0000000192923812ULL, 0x000fe400078efcffULL, 0x000000f5e600720bULL, 0x002fe40003fdd000ULL,
0x000000898800720bULL, 0x000fc60003f7d000ULL, 0x0000002500e57306ULL, 0x000e620000205400ULL,
0x0000000190902812ULL, 0x000fe200078efcffULL, 0x0000010027897824ULL, 0x000fe200078e00ffULL,
0x000000828100720bULL, 0x000fe40003f5d000ULL, 0x00000001c6c65812ULL, 0x000fe400078efcffULL,
0x0000007a7c00720bULL, 0x000fe40003fbd000ULL, 0x00000001b2b24812ULL, 0x000fe400078efcffULL,
0x000000edec00720bULL, 0x000fc40003f9d000ULL, 0x00000018ffec7819ULL, 0x000fe20000011489ULL,
0x0000002500887306ULL, 0x000522000020d400ULL, 0x000000018d8d6812ULL, 0x008fe400078efcffULL,
0x0000000193931812ULL, 0x000fe400078efcffULL, 0x0000000187873812ULL, 0x000fc600078efcffULL,
0x000000ec00f37306ULL, 0x000fe20000209400ULL, 0x000000e5cd00720bULL, 0x002fe20003fdd000ULL,
0x0001000026257824ULL, 0x004fe200078e00ffULL, 0x000000a5a400720bULL, 0x000fe40003f3d000ULL,
0x000000eb8a00720bULL, 0x000fc60003f7d000ULL, 0x000000ec00f47306ULL, 0x000e620000205400ULL,
0x0000000191912812ULL, 0x000fe400078efcffULL, 0x000000cce100720bULL, 0x000fe40003f5d000ULL,
0x00000001b8b85812ULL, 0x000fc600078efcffULL, 0x0000002600a47306ULL, 0x000fe20000009400ULL,
0x0000007b6d00720bULL, 0x000fce0003fbd000ULL, 0x0000002600a57306ULL, 0x000ff00000005400ULL,
0x00000026008a7306ULL, 0x0005e2000000d400ULL, 0x0000000185854812ULL, 0x000fe200078efcffULL,
0x0001000027267824ULL, 0x004fcc00078e00ffULL, 0x000000ec00897306ULL, 0x000ea2000020d400ULL,
0x0000008b2c00720bULL, 0x000fe40003f9d000ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff257819ULL, 0x000fc60000011425ULL, 0x0000002600f17306ULL, 0x000fe20000209400ULL,
0x0000000188886812ULL, 0x010fe400078efcffULL, 0x000000f4f300720bULL, 0x002fca0003fdd000ULL,
0x0000002600f27306ULL, 0x000e620000205400ULL, 0x00000001c4c42812ULL, 0x000fe400078efcffULL,
0x0000007daa00720bULL, 0x000fe40003f5d000ULL, 0x00000001adad5812ULL, 0x000fc600078efcffULL,
0x000000f000ce7306ULL, 0x000fe20000209400ULL, 0x0000006c6300720bULL, 0x000fce0003fbd000ULL,
0x000000f000cf7306ULL, 0x000ff00000205400ULL, 0x000000f000a37306ULL, 0x000fe2000020d400ULL,
0x00000001b9b93812ULL, 0x000fce00078efcffULL, 0x0000002500ef7306ULL, 0x000ff00000209400ULL,
0x0000002500f07306ULL, 0x000ff00000205400ULL, 0x0000002500817306ULL, 0x0007f0000020d400ULL,
0x0000002600827306ULL, 0x000962000020d400ULL, 0x0000010018257824ULL, 0x008fe200078e00ffULL,
0x00000001c5c54812ULL, 0x000fcc00078efcffULL, 0x0000001800cc7306ULL, 0x000fe20000009400ULL,
0x0001000018267824ULL, 0x010fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fcc0000011425ULL,
0x0000001800e17306ULL, 0x000fe20000005400ULL, 0x00000018ff267819ULL, 0x000fce0000011426ULL,
0x00000018007d7306ULL, 0x0007e2000000d400ULL, 0x00000064cb00720bULL, 0x000fe40003f7d000ULL,
0x000000ab2800720bULL, 0x000fe20003f9d000ULL, 0x0000010019187824ULL, 0x008fc800078e00ffULL,
0x0000002500ab7306ULL, 0x000fe20000209400ULL, 0x00000018ffee7819ULL, 0x000fe400000114c9ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000000189896812ULL, 0x004fc600078efcffULL,
0x0000002500aa7306ULL, 0x000ea20000205400ULL, 0x000000f2f100720bULL, 0x002fce0003fdd000ULL,
0x0000002600287306ULL, 0x000fe20000209400ULL, 0x00000001b4b45812ULL, 0x000fce00078efcffULL,
0x0000002600457306ULL, 0x000fe20000205400ULL, 0x000000e7e000720bULL, 0x000fce0003fbd000ULL,
0x00000026007a7306ULL, 0x0003f0000020d400ULL, 0x0000002700247306ULL, 0x000fe20000009400ULL,
0x0001000019267824ULL, 0x002fce00078e00ffULL, 0x00000027002c7306ULL, 0x000fe20000005400ULL,
0x00000018ff637819ULL, 0x000fce0000011426ULL, 0x00000027008b7306ULL, 0x000ff0000000d400ULL,
0x00000025007e7306ULL, 0x000ff0000020d400ULL, 0x0000001800277306ULL, 0x000ff00000209400ULL,
0x0000001800257306ULL, 0x000ff00000205400ULL, 0x00000018007c7306ULL, 0x0003e2000020d400ULL,
0x00000001baba1812ULL, 0x000fe200078efcffULL, 0x000001001b187824ULL, 0x002fcc00078e00ffULL,
0x000000ee00c97306ULL, 0x000fe20000209400ULL, 0x0000002e2d00720bULL, 0x000fe40003f3d000ULL,
0x00000018ff187819ULL, 0x000fca0000011418ULL, 0x000000ee00e27306ULL, 0x000e620000205400ULL,
0x00000001b3b33812ULL, 0x000fe400078efcffULL, 0x000000651d00720bULL, 0x000fca0003f7d000ULL,
0x0000006300467306ULL, 0x000fe20000209400ULL, 0x00000001bebe2812ULL, 0x000fe400078efcffULL,
0x0000000182826812ULL, 0x020fca00078efcffULL, 0x0000006300477306ULL, 0x000fe20000205400ULL,
0x000000c3c200720bULL, 0x000fe40003f5d000ULL, 0x000000aaab00720bULL, 0x004fca0003fdd000ULL,
0x00000063006d7306ULL, 0x000ff0000020d400ULL, 0x00000018002e7306ULL, 0x000ff00000209400ULL,
0x0000001800447306ULL, 0x000ff00000205400ULL, 0x0000001800637306ULL, 0x0005e2000020d400ULL,
0x000000019c9c5812ULL, 0x000fe200078efcffULL, 0x000100001a187824ULL, 0x004fcc00078e00ffULL,
0x0000001900c27306ULL, 0x000fe20000009400ULL, 0x000000e2c900720bULL, 0x002fe40003fbd000ULL,
0x00000018ff187819ULL, 0x000fca0000011418ULL, 0x0000001900c37306ULL, 0x000ff00000005400ULL,
0x00000019007b7306ULL, 0x0003e2000000d400ULL, 0x00000001a2a23812ULL, 0x000fce00078efcffULL,
0x000000ee008f7306ULL, 0x000ea2000020d400ULL, 0x000001001a197824ULL, 0x002fe200078e00ffULL,
0x000000c0c800720bULL, 0x000fc80003f7d000ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000001800e77306ULL, 0x000fe20000209400ULL, 0x00000001afaf4812ULL, 0x000fce00078efcffULL,
0x0000001800e87306ULL, 0x000fe20000205400ULL, 0x000000cfce00720bULL, 0x000fce0003f9d000ULL,
0x0000001800657306ULL, 0x0003e2000020d400ULL, 0x000000017e7e6812ULL, 0x000fe200078efcffULL,
0x0000010021187824ULL, 0x002fcc00078e00ffULL, 0x0000001900267306ULL, 0x000fe20000209400ULL,
0x000000452800720bULL, 0x000fe40003fdd000ULL, 0x00000018ff187819ULL, 0x000fca0000011418ULL,
0x00000019002d7306ULL, 0x000e620000205400ULL, 0x00000001bcbc1812ULL, 0x000fe400078efcffULL,
0x0000006b2a00720bULL, 0x000fca0003f3d000ULL, 0x00000019006c7306ULL, 0x0007e2000020d400ULL,
0x000000018f8f5812ULL, 0x004fe200078efcffULL, 0x000100001b197824ULL, 0x008fcc00078e00ffULL,
0x0000001800d37306ULL, 0x000fe20000209400ULL, 0x000000989900720bULL, 0x000fe40003fbd000ULL,
0x00000018ff197819ULL, 0x000fca0000011419ULL, 0x0000001800d47306ULL, 0x000fe20000205400ULL,
0x000000019e9e3812ULL, 0x000fce00078efcffULL, 0x00000018001d7306ULL, 0x0005e2000020d400ULL,
0x00000017bf00720bULL, 0x000fe20003f7d000ULL, 0x0001000020187824ULL, 0x004fcc00078e00ffULL,
0x0000001900df7306ULL, 0x000fe20000209400ULL, 0x0001000021177824ULL, 0x000fe200078e00ffULL,
0x00000001a3a34812ULL, 0x000fcc00078efcffULL, 0x0000001900e07306ULL, 0x000fe20000205400ULL,
0x0000002c2400720bULL, 0x000fce0003f9d000ULL, 0x00000019002a7306ULL, 0x0005e2000020d400ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x00000001a9a92812ULL, 0x000fe400078efcffULL,
0x00000018ff197819ULL, 0x004fc60000011418ULL, 0x0000001a00ed7306ULL, 0x000fe20000009400ULL,
0x000000474600720bULL, 0x000fe40003fdd000ULL, 0x000000a5a400720bULL, 0x000fca0003f5d000ULL,
0x0000001a00ee7306ULL, 0x000ea20000005400ULL, 0x0000000195951812ULL, 0x000fe400078efcffULL,
0x00000018ff177819ULL, 0x000fca0000011417ULL, 0x0000001a006b7306ULL, 0x0007e2000000d400ULL,
0x000000e1cc00720bULL, 0x000fe20003f3d000ULL, 0x0000000000f37919ULL, 0x000f2c0000000000ULL,
0x0000001900ce7306ULL, 0x000fe20000209400ULL, 0x00000100201a7824ULL, 0x008fe200078e00ffULL,
0x000000018c8c5812ULL, 0x000fcc00078efcffULL, 0x0000001900cf7306ULL, 0x000fe20000205400ULL,
0x00000018ff1a7819ULL, 0x000fce000001141aULL, 0x0000001900297306ULL, 0x0007e2000020d400ULL,
0x0000001e1c00720bULL, 0x000fe20003fbd000ULL, 0x0000010023197824ULL, 0x008fcc00078e00ffULL,
0x0000002000a47306ULL, 0x000ff00000009400ULL, 0x0000002000a57306ULL, 0x000ff00000005400ULL,
0x00000020002c7306ULL, 0x0007e2000000d400ULL, 0x000000018b8b4812ULL, 0x000fc400078efcffULL,
0x00000018ff207819ULL, 0x008fca0000011419ULL, 0x0000001a00da7306ULL, 0x000fe20000209400ULL,
0x000000c3c200720bULL, 0x000fce0003f9d000ULL, 0x0000001a00db7306ULL, 0x000fe20000205400ULL,
0x000000016d6d6812ULL, 0x000fce00078efcffULL, 0x0000001a002b7306ULL, 0x0007e2000020d400ULL,
0x000000018a8a2812ULL, 0x000fce00078efcffULL, 0x0000001700ca7306ULL, 0x000fe20000209400ULL,
0x00000100221a7824ULL, 0x008fce00078e00ffULL, 0x0000001700cb7306ULL, 0x000fe20000205400ULL,
0x000000442e00720bULL, 0x000fce0003fdd000ULL, 0x0000001700187306ULL, 0x000fe2000020d400ULL,
0x000000f0ef00720bULL, 0x000fce0003f5d000ULL, 0x0000002000bf7306ULL, 0x000fe20000209400ULL,
0x000000017d7d1812ULL, 0x000fce00078efcffULL, 0x0000002000c07306ULL, 0x000fe20000205400ULL,
0x000138005c447811ULL, 0x000fce00078e20ffULL, 0x0000002000177306ULL, 0x0007e2000020d400ULL,
0x000000252700720bULL, 0x000fe20003f3d000ULL, 0x00010000231c7824ULL, 0x000fcc00078e00ffULL,
0x0000001b00eb7306ULL, 0x000fe20000009400ULL, 0x0001000022207824ULL, 0x008fe200078e00ffULL,
0x000000017f7f5812ULL, 0x000fe200078efcffULL, 0x000000004444783bULL, 0x000fe60000000200ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000001b00ec7306ULL, 0x000ee20000005400ULL,
0x000000666700720bULL, 0x000fce0003fbd000ULL, 0x0000001b00647306ULL, 0x000a62000000d400ULL,
0x0001000030667824ULL, 0x000fce00078e00ffULL, 0x0000002100e97306ULL, 0x000fe20000009400ULL,
0x00000018ff1b7819ULL, 0x020fce000001141aULL, 0x0000002100ea7306ULL, 0x000ff00000005400ULL,
0x0000002100247306ULL, 0x000be2000000d400ULL, 0x0000010032277824ULL, 0x000fe400078e00ffULL,
0x0000010030217824ULL, 0x020fca00078e00ffULL, 0x0000002200e17306ULL, 0x000fe20000009400ULL,
0x00000018ff1c7819ULL, 0x000fce000001141cULL, 0x0000002200e27306ULL, 0x000ff00000005400ULL,
0x0000002200197306ULL, 0x000fe2000000d400ULL, 0x00000018ff667819ULL, 0x000fce0000011466ULL,
0x0000001b00c87306ULL, 0x000ff00000209400ULL, 0x0000001b00c97306ULL, 0x000f700000205400ULL,
0x0000001b001a7306ULL, 0x000e70000020d400ULL, 0x0000002000e67306ULL, 0x000ff00000209400ULL,
0x0000002000e57306ULL, 0x000ff00000205400ULL, 0x0000002000227306ULL, 0x0003e2000020d400ULL,
0x000000017b7b4812ULL, 0x000fce00078efcffULL, 0x0000002300cc7306ULL, 0x000fe20000009400ULL,
0x0000010031207824ULL, 0x002fce00078e00ffULL, 0x0000002300cd7306ULL, 0x000e620000005400ULL,
0x00000018ffef7819ULL, 0x000fce0000011420ULL, 0x00000023001b7306ULL, 0x0002a2000000d400ULL,
0x000000018e8e3812ULL, 0x000fe400078efcffULL, 0x00000018ff237819ULL, 0x002fca0000011421ULL,
0x0000003000c27306ULL, 0x000fe20000009400ULL, 0x0000002d2600720bULL, 0x000fe40003f9d000ULL,
0x000000848300720bULL, 0x000fe40003f7d000ULL, 0x0000000181812812ULL, 0x000fc600078efcffULL,
0x0000002300997306ULL, 0x000fe20000209400ULL, 0x00000007ff26723eULL, 0x000fe400000010ffULL,
0x00000002fff47819ULL, 0x010fca00000116f3ULL, 0x0000002300987306ULL, 0x000fe20000205400ULL,
0x000000eeed00720bULL, 0x004fe40003f5d000ULL, 0x000000017c7c1812ULL, 0x000fca00078efcffULL,
0x0000002300217306ULL, 0x000fe2000020d400ULL, 0x000000968600720bULL, 0x000fce0003f3d000ULL,
0x0000003000c37306ULL, 0x000fe20000005400ULL, 0x00000002ff967819ULL, 0x000fce00000116f3ULL,
0x0000003000207306ULL, 0x0003e2000000d400ULL, 0x00000008f4f47810ULL, 0x000fce0007ffe0ffULL,
0x0000003100aa7306ULL, 0x000fe20000009400ULL, 0x0001000031307824ULL, 0x002fce00078e00ffULL,
0x0000003100ab7306ULL, 0x000e700000005400ULL, 0x0000003100237306ULL, 0x000530000000d400ULL,
0x0000001c00f67306ULL, 0x000fe20000209400ULL, 0x00000018ff317819ULL, 0x004fce0000011427ULL,
0x0000001c00f57306ULL, 0x000ff00000205400ULL, 0x0000001c001e7306ULL, 0x000ff0000020d400ULL,
0x000000ef00837306ULL, 0x000ff00000209400ULL, 0x000000ef00847306ULL, 0x000eb00000205400ULL,
0x000000ef001c7306ULL, 0x000ff0000020d400ULL, 0x0000006600ef7306ULL, 0x000ff00000209400ULL,
0x0000006600ed7306ULL, 0x000ff00000205400ULL, 0x0000006600287306ULL, 0x000ff0000020d400ULL,
0x0000003100667306ULL, 0x000ff00000209400ULL, 0x0000003100677306ULL, 0x000ff00000205400ULL,
0x0000003100277306ULL, 0x0003e4000020d400ULL, 0x0000541026317816ULL, 0x002fca0000000026ULL,
0x00001ff431867589ULL, 0x000fe800000e0000ULL, 0x00001f9631967589ULL, 0x000e6200000e0000ULL,
0x00009910612e7816ULL, 0x000fe400000000ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000000169691812ULL, 0x000fe400078efcffULL, 0x000000ff2e00720cULL, 0x000fe20003f25270ULL,
0x0000003000f07306ULL, 0x000ff00000209400ULL, 0x0000003000ee7306ULL, 0x000ff00000205400ULL,
0x0000003000257306ULL, 0x0003e2000020d400ULL, 0x0000000180803812ULL, 0x000fe200078efcffULL,
0x0001000032307824ULL, 0x002fe200078e00ffULL, 0x000000eceb00720bULL, 0x008fc80003f7d000ULL,
0x00000018ff5c7819ULL, 0x000fe20000011430ULL, 0x0000009644449231ULL, 0x080fe200003400ffULL,
0x000000735d5d723eULL, 0x000fe200000010ffULL, 0x0000009646469231ULL, 0x000fe200003400ffULL,
0x0000005c00ec7306ULL, 0x000fe20000209400ULL, 0x0000008645459231ULL, 0x080fe200003400ffULL,
0x0000000163636812ULL, 0x000fe200078efcffULL, 0x0000008647479231ULL, 0x000fe200003400ffULL,
0x000000746000720bULL, 0x000fc80003fdd000ULL, 0x0000005c00eb7306ULL, 0x000ff00000205400ULL,
0x0000005c00617306ULL, 0x0003e4000020d400ULL, 0x000000dd725c723eULL, 0x002fce00000010ffULL,
0x0000005c4434723cULL, 0x000fe20000041834ULL, 0x0000000162626812ULL, 0x000fcc00078efcffULL,
0x0000006f755c723eULL, 0x000fe400000010ffULL, 0x0000006ed95d723eULL, 0x000fe400000010ffULL,
0x000000717000720bULL, 0x000fca0003fdd000ULL, 0x0000005c4454723cULL, 0x000fee0000041854ULL,
0x0000002fd15c723eULL, 0x000fe400000010ffULL, 0x000000d2c15d723eULL, 0x000fe400000010ffULL,
0x000000011f1f6812ULL, 0x000fca00078efcffULL, 0x0000005c4458723cULL, 0x000fe20000041858ULL,
0x0000005e5f00720bULL, 0x000fcc0003fdd000ULL, 0x00013800765c7811ULL, 0x000fcc00078e20ffULL,
0x000000005c5c783bULL, 0x000e620000000200ULL, 0x000000a7e330723eULL, 0x000fe400000010ffULL,
0x000000a6e431723eULL, 0x000fe400000010ffULL, 0x0000000164643812ULL, 0x000fe400078efcffULL,
0x000000e0df00720bULL, 0x000fe40003f7d000ULL, 0x000000929792723eULL, 0x000fe200000010ffULL,
0x000000304440723cULL, 0x000fe20000041840ULL, 0x00000093b293723eULL, 0x000fe200000010ffULL,
0x0000003800727306ULL, 0x000fe20000009400ULL, 0x00000018fff77819ULL, 0x000fe20000011438ULL,
0x0001000038d17824ULL, 0x000fc400078e00ffULL, 0x0001000039c17824ULL, 0x000fe400078e00ffULL,
0x000000924450723cULL, 0x000fe40000041850ULL, 0x000000012a2a3812ULL, 0x000fe200078efcffULL,
0x0000003800737306ULL, 0x000fe20000005400ULL, 0x000000dbda00720bULL, 0x000fc60003f7d000ULL,
0x0000010038937824ULL, 0x000fe400078e00ffULL, 0x0000010039927824ULL, 0x000fe400078e00ffULL,
0x0000003800607306ULL, 0x0007e2000000d400ULL, 0x00000100332d7824ULL, 0x000fce00078e00ffULL,
0x0000003900747306ULL, 0x000fe20000009400ULL, 0x000000c6c538723eULL, 0x008fce00000010ffULL,
0x0000003900757306ULL, 0x000fe20000005400ULL, 0x0001000033da7824ULL, 0x000fce00078e00ffULL,
0x0000003900307306ULL, 0x0007e2000000d400ULL, 0x000000879090723eULL, 0x000fe200000010ffULL,
0x000001003ab27824ULL, 0x000fe200078e00ffULL, 0x000000859191723eULL, 0x000fe400000010ffULL,
0x000000c7c439723eULL, 0x008fc600000010ffULL, 0x0000003300a67306ULL, 0x000fe20000009400ULL,
0x000100003a877824ULL, 0x000fe200078e00ffULL, 0x000000965c5c9231ULL, 0x082fe200003400ffULL,
0x000001003b977824ULL, 0x040fe200078e00ffULL, 0x000000965e5e9231ULL, 0x000fe200003400ffULL,
0x000100003b857824ULL, 0x000fe200078e00ffULL, 0x00000038444c723cULL, 0x000fe4000004184cULL,
0x0000003300a77306ULL, 0x000fe20000005400ULL, 0x000000865d5d9231ULL, 0x080fe400003400ffULL,
0x000000865f5f9231ULL, 0x000fc400003400ffULL, 0x000000babb38723eULL, 0x000fc600000010ffULL,
0x0000003300317306ULL, 0x000fe2000000d400ULL, 0x000000b9bc39723eULL, 0x000fe400000010ffULL,
0x0000000179795812ULL, 0x000fca00078efcffULL, 0x0000003a006e7306ULL, 0x000fe20000009400ULL,
0x000000012b2b3812ULL, 0x000fe400078efcffULL, 0x0000000116166812ULL, 0x000fca00078efcffULL,
0x0000003a006f7306ULL, 0x000fe20000005400ULL, 0x000000a5a400720bULL, 0x000fce0003fbd000ULL,
0x0000003a002f7306ULL, 0x0003e2000000d400ULL, 0x000000d4d300720bULL, 0x000fce0003f7d000ULL,
0x0000003b00707306ULL, 0x000fe20000009400ULL, 0x000000beb83a723eULL, 0x002fce00000010ffULL,
0x0000003b00717306ULL, 0x000fe20000005400ULL, 0x000000c9c800720bULL, 0x020fce0003fdd000ULL,
0x0000003b00337306ULL, 0x0003e2000000d400ULL, 0x00000090443c723cULL, 0x000fe2000004183cULL,
0x000000bdad3b723eULL, 0x002fce00000010ffULL, 0x000000385c40723cULL, 0x000fee0000041840ULL,
0x00013800b0387811ULL, 0x000fe200078e20ffULL, 0x0000003a4444723cULL, 0x000fe20000041848ULL,
0x000000016c6c4812ULL, 0x000fc800078efcffULL, 0x000000003838783bULL, 0x000e640000000200ULL,
0x00013800b1487811ULL, 0x000fe400078e20ffULL, 0x000000016b6b2812ULL, 0x000fc800078efcffULL,
0x000000004848783bULL, 0x000ee20000000200ULL, 0x000000012c2c5812ULL, 0x000fe400078efcffULL,
0x000000011d1d3812ULL, 0x000fe400078efcffULL, 0x000000011a1a6812ULL, 0x000fe400078efcffULL,
0x000000eae900720bULL, 0x000fe40003f9d000ULL, 0x000000e8e700720bULL, 0x000fe40003f5d000ULL,
0x000000cfce00720bULL, 0x000fc40003fbd000ULL, 0x000000cdcc00720bULL, 0x000fe40003f7d000ULL,
0x000000e5e600720bULL, 0x000fca0003fdd000ULL, 0x0000000124244812ULL, 0x000fe400078efcffULL,
0x0000000165652812ULL, 0x000fe400078efcffULL, 0x0000000129295812ULL, 0x000fe400078efcffULL,
0x000000011b1b3812ULL, 0x000fe400078efcffULL, 0x0000000122226812ULL, 0x000fe400078efcffULL,
0x000000e2e100720bULL, 0x000fc40003f5d000ULL, 0x000000cbca00720bULL, 0x000fe40003f9d000ULL,
0x000000b7ac00720bULL, 0x000fe40003fbd000ULL, 0x000000abaa00720bULL, 0x000fe40003f7d000ULL,
0x0000009b9a00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x00000018fff17819ULL, 0x000fe2000001142dULL, 0x0000003200a57306ULL, 0x000fe20000009400ULL,
0x00000018ffb87819ULL, 0x000fc40000011492ULL, 0x000000b5b492723eULL, 0x000fe400000010ffULL,
0x0000000118184812ULL, 0x000fc600078efcffULL, 0x0000009300c47306ULL, 0x000fe20000209400ULL,
0x0000000111115812ULL, 0x000fe400078efcffULL, 0x0000000119192812ULL, 0x000fe400078efcffULL,
0x000000010e0e6812ULL, 0x000fc600078efcffULL, 0x0000009300ad7306ULL, 0x000fe20000205400ULL,
0x0000000123233812ULL, 0x010fe400078efcffULL, 0x000000c3c200720bULL, 0x000fe40003f9d000ULL,
0x000000c0bf00720bULL, 0x000fc60003fbd000ULL, 0x0000009300ac7306ULL, 0x0009e2000020d400ULL,
0x000000a0a100720bULL, 0x000fe40003f5d000ULL, 0x000000989900720bULL, 0x000fe40003fdd000ULL,
0x000000686a00720bULL, 0x000fc60003f7d000ULL, 0x0000003200a47306ULL, 0x000f620000005400ULL,
0x000000b6b393723eULL, 0x010fce00000010ffULL, 0x000000f1002d7306ULL, 0x000fe20000209400ULL,
0x000000925c34723cULL, 0x000fee0000041834ULL, 0x000000f1002e7306ULL, 0x000f220000205400ULL,
0x0000009638389231ULL, 0x082fe400003400ffULL, 0x000000963a3a9231ULL, 0x000fc400003400ffULL,
0x0000009648489231ULL, 0x088fe400003400ffULL, 0x000000964a4a9231ULL, 0x000fe400003400ffULL,
0x0000008639399231ULL, 0x080fe400003400ffULL, 0x000000863b3b9231ULL, 0x080fe400003400ffULL,
0x0000008649499231ULL, 0x080fe400003400ffULL, 0x000000864b4b9231ULL, 0x000fe200003400ffULL,
0x000000848300720bULL, 0x004fe20003f3d000ULL, 0x0000003200267306ULL, 0x000e62000000d400ULL,
0x000000a3a292723eULL, 0x000fc400000010ffULL, 0x0000009f9e93723eULL, 0x000fe400000010ffULL,
0x0000000117175812ULL, 0x000fc600078efcffULL, 0x000000f100327306ULL, 0x000ea2000020d400ULL,
0x0000000115152812ULL, 0x000fe400078efcffULL, 0x0000000121216812ULL, 0x000fe400078efcffULL,
0x0000000120204812ULL, 0x000fe400078efcffULL, 0x000000010d0d3812ULL, 0x000fe400078efcffULL,
0x000000f5f600720bULL, 0x000fe40003fbd000ULL, 0x000000a4a500720bULL, 0x020fc40003f5d000ULL,
0x000000787700720bULL, 0x000fe40003fdd000ULL, 0x000000edef00720bULL, 0x000fe40003f9d000ULL,
0x0000002e2d00720bULL, 0x010fe20003f7d000ULL, 0x000000925c58723cULL, 0x000fe20000041858ULL,
0x000000818080723eULL, 0x000fe400000010ffULL, 0x000000827f81723eULL, 0x000fe400000010ffULL,
0x0000007b7c7f723eULL, 0x000fc400000010ffULL, 0x000000011c1c1812ULL, 0x000fe400078efcffULL,
0x00000018ffda7819ULL, 0x000fe400000114daULL, 0x00000018ffd17819ULL, 0x000fe400000114d1ULL,
0x0000007a797a723eULL, 0x000fe400000010ffULL, 0x0000006d697b723eULL, 0x000fe400000010ffULL,
0x000000eef000720bULL, 0x000fc40003f3d000ULL, 0x000000afae90723eULL, 0x000fe400000010ffULL,
0x000000a9a891723eULL, 0x000fe200000010ffULL, 0x000000da00d97306ULL, 0x000fe20000209400ULL,
0x000000011e1e5812ULL, 0x000fe400078efcffULL, 0x0000000128284812ULL, 0x000fe400078efcffULL,
0x0000000114146812ULL, 0x000fe400078efcffULL, 0x0000000126262812ULL, 0x002fe200078efcffULL,
0x000000da00d27306ULL, 0x000e620000205400ULL, 0x0000000132323812ULL, 0x004fe200078efcffULL,
0x000000805c44723cULL, 0x000fe20000041844ULL, 0x000000a7a600720bULL, 0x000fc40003fbd000ULL,
0x000000737200720bULL, 0x000fc60003f9d000ULL, 0x000000b800b77306ULL, 0x000fe20000209400ULL,
0x000000676600720bULL, 0x000fe20003fdd000ULL, 0x0000007a3834723cULL, 0x000fe20000041834ULL,
0x000000d0d500720bULL, 0x000fe40003f5d000ULL, 0x000000d6d700720bULL, 0x000fc60003f7d000ULL,
0x000000b800b07306ULL, 0x000ea20000205400ULL, 0x0000008f8e8e723eULL, 0x000fe200000010ffULL,
0x000000905c54723cULL, 0x000fec0000041854ULL, 0x000000d1009e7306ULL, 0x000fe20000209400ULL,
0x0000009c9d90723eULL, 0x000fce00000010ffULL, 0x000000d100937306ULL, 0x000ee20000205400ULL,
0x000000959491723eULL, 0x000fe400000010ffULL, 0x0000008d8c8f723eULL, 0x000fe400000010ffULL,
0x0000008a8888723eULL, 0x000fe400000010ffULL, 0x0000008b8989723eULL, 0x000fe400000010ffULL,
0x00000064636d723eULL, 0x000fe400000010ffULL, 0x000000656262723eULL, 0x000fc400000010ffULL,
0x0000002a1f63723eULL, 0x000fe400000010ffULL, 0x0000000125251812ULL, 0x000fe400078efcffULL,
0x00000018ffc17819ULL, 0x000fe400000114c1ULL, 0x00000018ffb27819ULL, 0x000fe400000114b2ULL,
0x000000757400720bULL, 0x000fe20003f3d000ULL, 0x000000da00767306ULL, 0x000f22000020d400ULL,
0x000000905c50723cULL, 0x000fe20000041850ULL, 0x0000000127276812ULL, 0x000fc400078efcffULL,
0x0000000131315812ULL, 0x000fe400078efcffULL, 0x0000000113132812ULL, 0x000fe400078efcffULL,
0x000000b800a87306ULL, 0x000f62000020d400ULL, 0x0000008e5c3c723cULL, 0x000fe2000004183cULL,
0x000000010f0f3812ULL, 0x000fe400078efcffULL, 0x0000000160604812ULL, 0x000fc800078efcffULL,
0x000000d1008d7306ULL, 0x000f22000020d400ULL, 0x000000885c4c723cULL, 0x000fe2000004184cULL,
0x000000ebec00720bULL, 0x000fe40003fdd000ULL, 0x000000d2d900720bULL, 0x002fe40003fbd000ULL,
0x000000adc400720bULL, 0x000fe40003f5d000ULL, 0x000000f700f77306ULL, 0x000e620000209400ULL,
0x000000623858723cULL, 0x000fe20000041858ULL, 0x000000b0b700720bULL, 0x004fc40003f7d000ULL,
0x000000939e00720bULL, 0x008fc80003f9d000ULL, 0x000000c100827306ULL, 0x000fe20000209400ULL,
0x00000018ff977819ULL, 0x000fe40000011497ULL, 0x00000029162a723eULL, 0x000fca00000010ffULL,
0x000000c100897306ULL, 0x000ea20000205400ULL, 0x0000001b171b723eULL, 0x000fe400000010ffULL,
0x000000221516723eULL, 0x000fca00000010ffULL, 0x000000b2005c7306ULL, 0x000fe20000209400ULL,
0x0000002c2b2c723eULL, 0x000fce00000010ffULL, 0x000000b2005f7306ULL, 0x000ee20000205400ULL,
0x0000001e0e17723eULL, 0x000fe400000010ffULL, 0x000000281414723eULL, 0x000fe400000010ffULL,
0x000000250d15723eULL, 0x000fe400000010ffULL, 0x000000241d2d723eULL, 0x000fe400000010ffULL,
0x00000018112b723eULL, 0x000fe200000010ffULL, 0x00000097001d7306ULL, 0x000fe20000209400ULL,
0x0000000130301812ULL, 0x000fc400078efcffULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff857819ULL, 0x000fc60000011485ULL, 0x0000009700187306ULL, 0x000e620000205400ULL,
0x000000fafb00720bULL, 0x000fe20003f3d000ULL, 0x000000163844723cULL, 0x000fe20000041844ULL,
0x0000000161616812ULL, 0x000fe400078efcffULL, 0x0000000176765812ULL, 0x010fc600078efcffULL,
0x000000c1005d7306ULL, 0x000f24000020d400ULL, 0x000000144834723cULL, 0x000fe20000041834ULL,
0x00000001acac2812ULL, 0x000fe400078efcffULL, 0x00000001a8a83812ULL, 0x020fc600078efcffULL,
0x000000b2005e7306ULL, 0x000f62000020d400ULL, 0x000000018d8d4812ULL, 0x000fe400078efcffULL,
0x0000006f6e00720bULL, 0x000fe40003fdd000ULL, 0x000000fcf700720bULL, 0x002fc60003f5d000ULL,
0x0000008700117306ULL, 0x000fe20000209400ULL, 0x000000898200720bULL, 0x004fe40003f7d000ULL,
0x0000005f5c00720bULL, 0x008fca0003f9d000ULL, 0x0000008700167306ULL, 0x000e620000205400ULL,
0x00000061130e723eULL, 0x000fe400000010ffULL, 0x000000760f0f723eULL, 0x000fca00000010ffULL,
0x00000085000d7306ULL, 0x000ff00000209400ULL, 0x0000008500147306ULL, 0x000ea20000205400ULL,
0x0000007d7e7e723eULL, 0x000fe400000010ffULL, 0x0000006b6c6c723eULL, 0x000fc400000010ffULL,
0x000000191a1a723eULL, 0x000fc600000010ffULL, 0x0000009700247306ULL, 0x000ee2000020d400ULL,
0x000000010c0c1812ULL, 0x000fe400078efcffULL, 0x000000181d00720bULL, 0x000fe20003f3d000ULL,
0x0000000e4858723cULL, 0x000fe20000041858ULL, 0x000000717000720bULL, 0x000fc60003fbd000ULL,
0x0000008700877306ULL, 0x000ea2000020d400ULL, 0x0000000112122812ULL, 0x000fe400078efcffULL,
0x000000015d5d3812ULL, 0x010fe200078efcffULL, 0x0000007e3840723cULL, 0x000fe20000041840ULL,
0x000000015e5e4812ULL, 0x020fc600078efcffULL, 0x00000085000e7306ULL, 0x000f22000020d400ULL,
0x000000012f2f6812ULL, 0x000fe400078efcffULL, 0x000000def900720bULL, 0x000fe20003f5d000ULL,
0x0000006c3854723cULL, 0x000fe20000041854ULL, 0x000000d8dc00720bULL, 0x000fe40003f7d000ULL,
0x000000161100720bULL, 0x002fe40003f9d000ULL, 0x000000140d00720bULL, 0x004fc60003fdd000ULL,
0x0000002c3850723cULL, 0x040ff00000041850ULL, 0x0000002a383c723cULL, 0x040ff0000004183cULL,
0x0000001a384c723cULL, 0x000fe2000004184cULL, 0x0000005d0c13723eULL, 0x000fc400000010ffULL,
0x0000000124241812ULL, 0x008fe400078efcffULL, 0x00000001100c7812ULL, 0x000fe4000782c0ffULL,
0x0000000133335812ULL, 0x000fe400078efcffULL, 0x0000000b080b7207ULL, 0x000fe40004800000ULL,
0x000000010a0a2812ULL, 0x000fe400078efcffULL, 0x0000000187874812ULL, 0x000fc400078efcffULL,
0x0000000109093812ULL, 0x000fe400078efcffULL, 0x000000010e0e6812ULL, 0x010fe400078efcffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000202120723eULL, 0x000fe400000010ffULL,
0x000000313227723eULL, 0x000fe400000010ffULL, 0x000000231c21723eULL, 0x000fc400000010ffULL,
0x00000060ac60723eULL, 0x000fe400000010ffULL, 0x00000030a861723eULL, 0x000fe400000010ffULL,
0x0000008d1212723eULL, 0x000fe400000010ffULL, 0x0000002f5e32723eULL, 0x000fe400000010ffULL,
0x000000332433723eULL, 0x000fe400000010ffULL, 0x000000ff0bff7812ULL, 0x000fc4000784c0ffULL,
0x000000870a0a723eULL, 0x000fe400000010ffULL, 0x0000000e090b723eULL, 0x000fe200000010ffULL,
0x000000204840723cULL, 0x040ff00000041840ULL, 0x000000264854723cULL, 0x040ff00000041854ULL,
0x000000604850723cULL, 0x040ff00000041850ULL, 0x00000012483c723cULL, 0x040ff0000004183cULL,
0x00000032484c723cULL, 0x040ff0000004184cULL, 0x0000000a4848723cULL, 0x000fe20000041844ULL,
0x00000001ff137807ULL, 0x000fc80001000000ULL, 0x0000001308087207ULL, 0x000fe20004800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff60000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c64000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000991008087816ULL, 0x000fe400000000ffULL, 0x00000001ff127807ULL, 0x000fe40004000000ULL,
0x000000ff0800720cULL, 0x000fc80003f45270ULL, 0x00000001ff139807ULL, 0x000fe40001000000ULL,
0x0000280001087983ULL, 0x000ea20000300800ULL, 0x0000030003037a10ULL, 0x000fc80007ffe0ffULL,
0x000000040300720cULL, 0x000fe40003f26070ULL, 0x000000ff08ff7812ULL, 0x004fc8000780c0ffULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x0000280801007387ULL, 0x0005e40000100600ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xfffecec000007947ULL, 0x000fea000383ffffULL,
0x00000000000f7919ULL, 0x002e640000002500ULL, 0x000000040f00720cULL, 0x002fda0003f06070ULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x0180000006027810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0006ULL, 0x000142f0001a7802ULL, 0x000fe40000000f00ULL,
0x0000a92000007944ULL, 0x004fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000600037308ULL, 0x000e640000001000ULL, 0xbf80000003027423ULL, 0x002fc80000000006ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203047223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000097919ULL, 0x000f640000000000ULL, 0x00000002ff077819ULL, 0x026fe40000011609ULL,
0x0000000809097811ULL, 0x000fe200078ff0ffULL, 0x0000000403047220ULL, 0x018fca0000410000ULL,
0x00001f0704077589ULL, 0x000e6800000e0000ULL, 0x00001f0904097589ULL, 0x000ea200000e0000ULL,
0x0000004007407220ULL, 0x042fe40000410000ULL, 0x0000004107417220ULL, 0x040fe40000410000ULL,
0x0000003407347220ULL, 0x040fe40000410000ULL, 0x0000003507357220ULL, 0x000fc40000410000ULL,
0x0000005407547220ULL, 0x040fe40000410000ULL, 0x0000005507557220ULL, 0x040fe40000410000ULL,
0x0000005807587220ULL, 0x040fe40000410000ULL, 0x0000005907597220ULL, 0x040fe40000410000ULL,
0x0000005007507220ULL, 0x040fe40000410000ULL, 0x0000005107517220ULL, 0x000fc40000410000ULL,
0x0000003c073c7220ULL, 0x040fe40000410000ULL, 0x0000003d073d7220ULL, 0x040fe40000410000ULL,
0x0000004c074c7220ULL, 0x040fe40000410000ULL, 0x0000004d074d7220ULL, 0x040fe40000410000ULL,
0x0000004807487220ULL, 0x040fe40000410000ULL, 0x0000004907497220ULL, 0x000fc40000410000ULL,
0x0000004209427220ULL, 0x044fe40000410000ULL, 0x0000004309437220ULL, 0x040fe40000410000ULL,
0x0000003609367220ULL, 0x040fe40000410000ULL, 0x0000003709377220ULL, 0x040fe40000410000ULL,
0x0000005609567220ULL, 0x040fe40000410000ULL, 0x0000005709577220ULL, 0x000fc40000410000ULL,
0x0000005a095a7220ULL, 0x040fe40000410000ULL, 0x0000005b095b7220ULL, 0x040fe40000410000ULL,
0x0000005209527220ULL, 0x040fe40000410000ULL, 0x0000005309537220ULL, 0x040fe40000410000ULL,
0x0000003e093e7220ULL, 0x040fe40000410000ULL, 0x0000003f093f7220ULL, 0x000fc40000410000ULL,
0x0000004e094e7220ULL, 0x040fe40000410000ULL, 0x0000004f094f7220ULL, 0x040fe40000410000ULL,
0x0000004a094a7220ULL, 0x040fe40000410000ULL, 0x0000004b094b7220ULL, 0x000fe40000410000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0x00000300ff197624ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x000000011900780cULL, 0x000fe40003f05270ULL,
0x0000000211027812ULL, 0x002fe400078ec0ffULL, 0x00000002ff107819ULL, 0x000fe40000011611ULL,
0x00000001ff037819ULL, 0x000fe40000011602ULL, 0x0000000202047811ULL, 0x000fc400078ff8ffULL,
0x0000000402097811ULL, 0x040fe400078ff8ffULL, 0x00000006020d7811ULL, 0x000fe400078ff8ffULL,
0x0000000811187811ULL, 0x000fe400078ff0ffULL, 0x0000000703027812ULL, 0x100fe400078e7810ULL,
0x0000000704077812ULL, 0x100fe400078e7810ULL, 0x00000007090b7812ULL, 0x000fe200078e7810ULL,
0x0000000810087824ULL, 0x004fe200078e0202ULL, 0x000000070d0e7812ULL, 0x000fe200078e7810ULL,
0x0000080000027824ULL, 0x000fe200078e00ffULL, 0x0000000709097812ULL, 0x100fe200078e7818ULL,
0x00000008100a7824ULL, 0x040fe200078e0207ULL, 0x0000000703037812ULL, 0x100fe200078e7818ULL,
0x00000008100c7824ULL, 0x000fe200078e020bULL, 0x0000000704047812ULL, 0x000fe200078e7818ULL,
0x0000000810107824ULL, 0x000fe200078e020eULL, 0x000000070d0d7812ULL, 0x000fe200078e7818ULL,
0x0000000818167824ULL, 0x040fe200078e0209ULL, 0x000000343507723eULL, 0x000fe200000010ffULL,
0x00000008180e7824ULL, 0x000fe200078e0203ULL, 0x0001200002037810ULL, 0x000fe20007ffe0ffULL,
0x0000000811097824ULL, 0x000fe200078e00ffULL, 0x00000036370b723eULL, 0x000fe200000010ffULL,
0x0000000818147824ULL, 0x040fe200078e0204ULL, 0x000000404104723eULL, 0x000fe200000010ffULL,
0x0000000818187824ULL, 0x000fe200078e020dULL, 0x0000000809097812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0x00005410041a7816ULL, 0x000fe20000000007ULL,
0x000000100e127824ULL, 0x000fe200078e0203ULL, 0x00007632041b7816ULL, 0x000fe20000000007ULL,
0x000000100a0a7824ULL, 0x100fe200078e0203ULL, 0x000000505104723eULL, 0x000fe200000010ffULL,
0x0000001014147824ULL, 0x100fe200078e0203ULL, 0x0000003c3d07723eULL, 0x000fe200000010ffULL,
0x000000100c0e7824ULL, 0x000fc400078e0203ULL, 0x0000001010107824ULL, 0x100fe400078e0203ULL,
0x0000001016167824ULL, 0x100fe400078e0203ULL, 0x0000001018187824ULL, 0x000fe400078e0203ULL,
0x00000001080c7824ULL, 0x000fe200078e0209ULL, 0x000000545508723eULL, 0x000fe200000010ffULL,
0x0000000109127824ULL, 0x040fe400078e0212ULL, 0x00000001090d7824ULL, 0x040fe200078e020aULL,
0x0000001a0c007388ULL, 0x0003e20000000a00ULL, 0x0000000109147824ULL, 0x000fe200078e0214ULL,
0x00000042430a723eULL, 0x000fe200000010ffULL, 0x00000001090e7824ULL, 0x000fc400078e020eULL,
0x0000000109107824ULL, 0x040fe400078e0210ULL, 0x0000000109167824ULL, 0x040fe400078e0216ULL,
0x0000000109187824ULL, 0x000fe200078e0218ULL, 0x000000585909723eULL, 0x000fe400000010ffULL,
0x00005410040c7816ULL, 0x002fe40000000007ULL, 0x00005410081a7816ULL, 0x140fe40000000009ULL,
0x00007632081b7816ULL, 0x000fc40000000009ULL, 0x0000004c4d08723eULL, 0x000fe400000010ffULL,
0x000000484909723eULL, 0x000fe200000010ffULL, 0x0000001a0d007388ULL, 0x0003e40000000a00ULL,
0x00007632040d7816ULL, 0x002fe40000000007ULL, 0x000000565704723eULL, 0x000fe400000010ffULL,
0x0000005a5b07723eULL, 0x000fe200000010ffULL, 0x0000000c0e007388ULL, 0x0003e40000000a00ULL,
0x00005410080c7816ULL, 0x002fc40000000009ULL, 0x00007632080d7816ULL, 0x000fe40000000009ULL,
0x000000525308723eULL, 0x000fe400000010ffULL, 0x0000003e3f09723eULL, 0x000fe200000010ffULL,
0x0000000c10007388ULL, 0x0003e40000000a00ULL, 0x000054100a0c7816ULL, 0x142fe4000000000bULL,
0x000076320a0d7816ULL, 0x000fe4000000000bULL, 0x0000004e4f0a723eULL, 0x000fc400000010ffULL,
0x0000004a4b0b723eULL, 0x000fe200000010ffULL, 0x0000000c12007388ULL, 0x0003e40000000a00ULL,
0x00005410040c7816ULL, 0x142fe40000000007ULL, 0x00007632040d7816ULL, 0x000fca0000000007ULL,
0x0000000c14007388ULL, 0x0003e40000000a00ULL, 0x00005410080c7816ULL, 0x142fe40000000009ULL,
0x00007632080d7816ULL, 0x000fe40000000009ULL, 0x000054100a087816ULL, 0x140fe4000000000bULL,
0x000076320a097816ULL, 0x000fe2000000000bULL, 0x0000000c16007388ULL, 0x0003e80000000a00ULL,
0x0000000818007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002cd000008947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x0000580019047a24ULL, 0x000fe200078e02ffULL, 0x000000ff0000720cULL, 0x000fe20003f25270ULL,
0x00002000ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000187919ULL, 0x002e620000002700ULL,
0x0000640004087a24ULL, 0x000fc600078e02ffULL, 0x0000000000097919ULL, 0x000e620000002600ULL,
0x00000010070d7824ULL, 0x044fe200078e0202ULL, 0x0000002007137810ULL, 0x040fe40007ffe0ffULL,
0x0000004007157810ULL, 0x040fe40007ffe0ffULL, 0x012000000d1c7984ULL, 0x0004e20000000c00ULL,
0x0000006007177810ULL, 0x000fe20007ffe0ffULL, 0x0000580018187a24ULL, 0x002fe400078e0209ULL,
0x012200000d207984ULL, 0x0004620000000c00ULL, 0x00001fff08097811ULL, 0x000fe200078e40ffULL,
0x0000030018047a24ULL, 0x000fc400078e02ffULL, 0x012400000d247984ULL, 0x0005220000000c00ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x00000001040c7824ULL, 0x000fe400078e020fULL,
0x012600000d287984ULL, 0x0004620000000c00ULL, 0x000000ff0000720cULL, 0x000fe40000705670ULL,
0x0000000c090a7211ULL, 0x000fca00078f98ffULL, 0x00006a000a0a7625ULL, 0x000fcc00078e000bULL,
0x00000800000a7825ULL, 0x000fcc00078e000aULL, 0x0000001013127825ULL, 0x000fc800078e000aULL,
0x0000001015147825ULL, 0x000fc800078e000aULL, 0x0000001017167825ULL, 0x000fc800078e000aULL,
0x0000001007107825ULL, 0x000fe200078e000aULL, 0x01ffffff080b7812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x00cea20000000000ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x000000010c0e7824ULL, 0x040fe400078e020bULL,
0x00006a000c0c7625ULL, 0x000fc800078e000fULL, 0x00006a000e0e7625ULL, 0x000fc800078e000fULL,
0x00000010080a7824ULL, 0x004fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fc80000011608ULL,
0x000000700a1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ec0ffULL,
0x0000000c080c7210ULL, 0x140fe40007b5e01bULL, 0x0000000e080e7210ULL, 0x000fe40007d9e01bULL,
0x0000000dff0d7210ULL, 0x000fe400017e64ffULL, 0x0000000fff0f7210ULL, 0x000fc600027ea4ffULL,
0x000000050c007986ULL, 0x0005e8000c101906ULL, 0x000000060e007986ULL, 0x0005e4000c101906ULL,
0x0000001c10007986ULL, 0x00c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000002012007986ULL, 0x0025e8000c101d06ULL, 0x0000002414007986ULL, 0x0105e8000c101d06ULL,
0x0000002816007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0xffffffff19057810ULL, 0x000fc60007ffe0ffULL, 0x00006800180c7625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000050c0c79a8ULL, 0x000ee400099ee1c6ULL, 0x000000050c00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff067807ULL, 0x000fca0000000000ULL,
0x00000006ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff057984ULL, 0x000ee40000000000ULL,
0x000000ff0500720cULL, 0x008fda0003f05270ULL, 0x0000286000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001040e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001007057824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x002fe20000011607ULL,
0x00000080ff117424ULL, 0x004fc600078e00ffULL, 0x0000007005137812ULL, 0x000fe200078ec0ffULL,
0x00006a00040c7625ULL, 0x000fe200078e0011ULL, 0x0000000c06147812ULL, 0x000fc600078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fe200078e0011ULL, 0x0000000c140c7210ULL, 0x000fc8000791e013ULL,
0x0000000e140e7210ULL, 0x000fe40007b5e013ULL, 0x0000000dff0d7210ULL, 0x000fe400007e24ffULL,
0x0000000fff0f7210ULL, 0x000fc600017e64ffULL, 0x000000060c057981ULL, 0x000368000c1e1900ULL,
0x000000060e067981ULL, 0x000362000c1e1900ULL, 0x000000021900780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002040c7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c140c7210ULL, 0x000fc8000791e013ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c087981ULL, 0x000362000c1e1900ULL,
0x000000041900780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003040c7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c140c7210ULL, 0x000fc8000791e013ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c0a7981ULL, 0x000362000c1e1900ULL, 0x000000041900780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004040c7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c140c7210ULL, 0x000fc8000791e013ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c107981ULL, 0x000362000c1e1900ULL,
0x000000061900780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005040c7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c140c7210ULL, 0x000fc8000791e013ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c127981ULL, 0x000362000c1e1900ULL, 0x000000061900780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081900780cULL, 0x002fe40003f06070ULL,
0x00000006040c7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c140c7210ULL, 0x000fe40007a3e013ULL, 0x00000007040e0810ULL, 0x000fe40007ffe0ffULL,
0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL, 0x00006a000e0e0625ULL, 0x000fca00078e0011ULL,
0x0000000e140e0210ULL, 0x000fe40007c7e013ULL, 0x000000060c147981ULL, 0x000364000c1e1900ULL,
0x0000000fff0f0210ULL, 0x000fca0001fe84ffULL, 0x000000060e160981ULL, 0x000368000c1e1900ULL,
0x00000007190c7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0e7819ULL, 0x000fc8000001160cULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff187224ULL, 0x020fe400078e0005ULL,
0x000000080f117824ULL, 0x044fe200078e00ffULL, 0x000000010f0f7810ULL, 0x000fc80007ffe0ffULL,
0x0000030011007a0cULL, 0x000fe40003f26070ULL, 0x0000000e0f00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008110d7810ULL, 0x040fe40007ffe0ffULL,
0x00000001110c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001805057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x00000001ff157819ULL, 0x000fe20000011607ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001007137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000c150c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c187981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009110d7810ULL, 0x042fe40007ffe0ffULL, 0x00000002110c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000000605057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040c7824ULL, 0x000fe200078e020dULL, 0x00000001ff157819ULL, 0x000fe20000011607ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001007067824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007006137812ULL, 0x000fc800078ec0ffULL, 0x0000000c150c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c067981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a110d7810ULL, 0x042fe40007ffe0ffULL,
0x00000003110c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000000805057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x00000001ff157819ULL, 0x000fe20000011607ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001007087824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007008137812ULL, 0x000fc800078ec0ffULL,
0x0000000c150c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c087981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b110d7810ULL, 0x042fe40007ffe0ffULL, 0x00000004110c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000000a05057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040c7824ULL, 0x000fe200078e020dULL, 0x00000001ff157819ULL, 0x000fe20000011607ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x00000010070a7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a000c0c7625ULL, 0x000fc600078e000dULL,
0x000000700a137812ULL, 0x000fc800078ec0ffULL, 0x0000000c150c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c0a7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c110d7810ULL, 0x042fe40007ffe0ffULL,
0x00000005110c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001005057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x00000001ff157819ULL, 0x000fe20000011607ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001007107824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000c150c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c107981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d110d7810ULL, 0x042fe40007ffe0ffULL, 0x00000006110c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001205057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040c7824ULL, 0x000fe200078e020dULL, 0x00000001ff157819ULL, 0x000fe20000011607ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001007127824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012137812ULL, 0x000fc800078ec0ffULL, 0x0000000c150c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c127981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e110d7810ULL, 0x042fe40007ffe0ffULL,
0x00000007110c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001405057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040c7824ULL, 0x000fe200078e020dULL,
0x00000001ff147819ULL, 0x000fe20000011607ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001007137824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006a000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c147981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f11117810ULL, 0x000fe40007ffe0ffULL, 0x0000001605057209ULL, 0x000fe40007810000ULL,
0x0000030011007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040c7824ULL, 0x002fe200078e0211ULL, 0x00000001ff137819ULL, 0x000fe20000011607ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001007117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006a000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000c130c7210ULL, 0x000fc80007a3e011ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL, 0x000000060c167981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x000ee40000000000ULL,
0x0000001007067824ULL, 0x028fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fc80000011607ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c080d7812ULL, 0x002fca00078ec0ffULL,
0x0000000106067824ULL, 0x000fca00078e020dULL, 0x0000000506007388ULL, 0x0003e40000000800ULL,
0x00000004090c7211ULL, 0x000fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000070700780cULL, 0x040fe20003f04070ULL,
0x0000080000417824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x002fe20000011607ULL,
0x00006a000c0c7625ULL, 0x000fe200078e000dULL, 0x00000015ff437819ULL, 0x000fe20000011600ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000c06067812ULL, 0x000fe200078ec0ffULL,
0x0000001007057824ULL, 0x040fe200078e00ffULL, 0x000000410c0c7210ULL, 0x000fe20007f3e0ffULL,
0x0000100000287824ULL, 0x004fe200078e00ffULL, 0x00000020070f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x0000000104148824ULL, 0x000fe200078e020bULL, 0x0000004007117810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x0000006007137810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200008e0643ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff178424ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00006a0014148625ULL, 0x000fe200078e0015ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000105057824ULL, 0x000fe200078e0206ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000100f0e7825ULL, 0x000fe200078e000cULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0x0000000005267984ULL, 0x0002a20000000800ULL, 0x0000001011107825ULL, 0x000fc800078e000cULL,
0x0000001013127825ULL, 0x000fc800078e000cULL, 0x00000010001d8824ULL, 0x000fe400078e0207ULL,
0x00006a0004168625ULL, 0x000fc600078e0017ULL, 0x000045801d1d8811ULL, 0x000fe200078e20ffULL,
0x00000010071b7824ULL, 0x040fe400078e0228ULL, 0x00000010070c7825ULL, 0x000fc800078e000cULL,
0x00000010001f8824ULL, 0x000fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c1b7faeULL, 0x0007e2000b901c46ULL, 0x0000001007148825ULL, 0x000fc600078e0014ULL,
0x000041801f1f8811ULL, 0x000fe200078e20ffULL, 0x0000001007168825ULL, 0x000fe200078e0016ULL,
0x003800000e1b7faeULL, 0x0009e6000b901c46ULL, 0x000000ffff057224ULL, 0x002fe200078e00ffULL,
0x00580000101b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x00780000121b7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff277224ULL, 0x000fc400078e00ffULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x00000000141d8faeULL, 0x000be2000b901c46ULL,
0x00000000000e7805ULL, 0x010fe2000001ff00ULL, 0x000000ffff367224ULL, 0x000fe400078e00ffULL,
0x00000000161f8faeULL, 0x0009e2000b901c46ULL, 0x0000000000107805ULL, 0x002fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x008fe2000001ff00ULL,
0x0000000000147805ULL, 0x020fe2000001ff00ULL, 0x0000000000167805ULL, 0x010fe2000001ff00ULL,
0x00000d5000009947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x004fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fca00078e00ffULL, 0x0000000137397810ULL, 0x000fc80007ffe0ffULL,
0x0000030039007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x0000000104387824ULL, 0x000fe200078e0239ULL, 0x000000070700780cULL, 0x000fe20003f24070ULL,
0x00002000ff1b7424ULL, 0x000fe200078e00ffULL, 0x00000001391f7812ULL, 0x040fe200078ec0ffULL,
0x00000800391c7824ULL, 0x000fe200078e00ffULL, 0x00000038091a7211ULL, 0x000fe400078f98ffULL,
0x0000002007217810ULL, 0x040fe40007ffe0ffULL, 0x000008001c1d7812ULL, 0x000fe200078ec0ffULL,
0x00006a001a1a7625ULL, 0x000fe200078e001bULL, 0x0000004007257810ULL, 0x000fc40007ffe0ffULL,
0x00000060073d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001281c7824ULL, 0x000fe200078e021dULL,
0x000000411a1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b229824ULL, 0x000fe400078e0238ULL,
0x00000080ff239424ULL, 0x000fe400078e00ffULL, 0x000000011b1b7824ULL, 0x000fe400000e0643ULL,
0x0000000200249824ULL, 0x140fe400078e021fULL, 0x00000002003a9824ULL, 0x000fc400078e021fULL,
0x00000080ff3f9424ULL, 0x000fe400078e00ffULL, 0x00000010073b7824ULL, 0x000fe400078e021cULL,
0x00000010211e7825ULL, 0x000fc800078e001aULL, 0x0000001025207825ULL, 0x000fc800078e001aULL,
0x00000010071c7825ULL, 0x000fc800078e001aULL, 0x000000103d1a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800001c3b7faeULL, 0x0003e6000b901c46ULL,
0x00006a0022229625ULL, 0x000fe200078e0023ULL, 0x003800001e3b7faeULL, 0x0003e6000b901c46ULL,
0x00000008243d9824ULL, 0x000fe200078e0207ULL, 0x00580000203b7faeULL, 0x0003e2000b901c46ULL,
0x00006a0038249625ULL, 0x000fc600078e003fULL, 0x000045803d3d9811ULL, 0x000fe200078e20ffULL,
0x000000083a3a9824ULL, 0x000fe200078e0207ULL, 0x007800001a3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001007229825ULL, 0x000fc600078e0022ULL, 0x000041803a3f9811ULL, 0x000fe200078e20ffULL,
0x0000001007249825ULL, 0x000fe200078e0024ULL, 0x00000000223d9faeULL, 0x0003e8000b901c46ULL,
0x00000000243f9faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000080371a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff1d7819ULL, 0x100fe20000011607ULL,
0x00000010071c7824ULL, 0x000fe200078e00ffULL, 0x00000002ff4e7819ULL, 0x000fc40000011607ULL,
0x000000801a1b7812ULL, 0x000fe400078ec0ffULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x000000084e1f7824ULL, 0x000fe200078e00ffULL, 0x0000000c1d1d7812ULL, 0x000fe200078ec0ffULL,
0x00000100001b7824ULL, 0x000fe200078e021bULL, 0x000000074e3a7812ULL, 0x040fe200078ec0ffULL,
0x000000084e217824ULL, 0x040fe200078e00ffULL, 0x0000004eff3c7212ULL, 0x000fe400078e33ffULL,
0x0000001b1d1c7210ULL, 0x000fe20007ffe01cULL, 0x000000084e1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1a7812ULL, 0x000fc400078ee23aULL, 0xfffffff8213c7812ULL, 0x000fe400078ee23cULL,
0x000000011b1e7812ULL, 0x000fe200078ef63aULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001c1d7984ULL, 0x000e620000000800ULL, 0x000000021b207812ULL, 0x140fe400078ef63aULL,
0x000000031b227812ULL, 0x140fe200078ef63aULL, 0x004580001c4c7984ULL, 0x0004e20000000800ULL,
0x000000041b247812ULL, 0x140fe400078ef63aULL, 0x000000051b387812ULL, 0x140fe400078ef63aULL,
0x000000061b3a7812ULL, 0x000fe200078ef63aULL, 0x00000800371b7824ULL, 0x000fe200078e00ffULL,
0x000000084e507810ULL, 0x000fe20007ffe0ffULL, 0x00000004071c7824ULL, 0x004fc400078e00ffULL,
0x000000ffff377224ULL, 0x000fe200078e0039ULL, 0x000008001b1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008501f7824ULL, 0x040fe200078e00ffULL, 0x00000050ff4a7212ULL, 0x000fe200078e33ffULL,
0x0000000850407824ULL, 0x000fe200078e00ffULL, 0x00000180281b7810ULL, 0x000fe20007ffe01bULL,
0x00000008503e7824ULL, 0x040fe200078e00ffULL, 0xfffffff81f4a7812ULL, 0x000fe400078ee24aULL,
0x00000007501f7812ULL, 0x000fe200078ec0ffULL, 0x000000101a1a7824ULL, 0x100fe200078e021bULL,
0x0000030037007a0cULL, 0x000fe20003f06070ULL, 0x000000103c3c7824ULL, 0x000fe200078e021bULL,
0x000000023e427812ULL, 0x000fe200078ef61fULL, 0x000000101e1e7824ULL, 0x000fe200078e021bULL,
0x000000033e447812ULL, 0x000fe200078ef61fULL, 0x0000001020207824ULL, 0x000fe200078e021bULL,
0x000000043e467812ULL, 0x000fe200078ef61fULL, 0x0000001022227824ULL, 0x000fe200078e021bULL,
0x000000053e487812ULL, 0x000fe200078ef61fULL, 0x0000001024247824ULL, 0x000fc400078e021bULL,
0x0000001038387824ULL, 0x100fe400078e021bULL, 0x000000103a3a7824ULL, 0x000fe400078e021bULL,
0x0000001d261d7221ULL, 0x002fe40000010100ULL, 0x0000001042427824ULL, 0x100fe400078e021bULL,
0x3fb8aa3b1d217820ULL, 0x000fe20000410000ULL, 0x0000000c1c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000001044447824ULL, 0x000fe200078e021bULL, 0xfffffff8401c7812ULL, 0x000fe200078ee21fULL,
0x0000001046467824ULL, 0x000fe200078e021bULL, 0x000000013e407812ULL, 0x000fe200078ef61fULL,
0x000000011a1a7824ULL, 0x000fe200078e021dULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x000000011d3c7824ULL, 0x040fe200078e023cULL, 0x000000063e3e7812ULL, 0x000fe200078ef61fULL,
0x000000011d1e7824ULL, 0x040fe200078e021eULL, 0x000000001a237984ULL, 0x000e620000000800ULL,
0x000000011d207824ULL, 0x000fc400078e0220ULL, 0x000000011d227824ULL, 0x040fe200078e0222ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x000000011d247824ULL, 0x040fe400078e0224ULL,
0x000000011d387824ULL, 0x040fe200078e0238ULL, 0x000000001e1e7984ULL, 0x000fe20000000800ULL,
0x000000101c1c7824ULL, 0x000fe400078e021bULL, 0x000000011d3a7824ULL, 0x000fe200078e023aULL,
0x0000000020207984ULL, 0x000fe20000000800ULL, 0x0000004c21217220ULL, 0x008fc40000410000ULL,
0x000000011d1c7824ULL, 0x040fe200078e021cULL, 0x0000000022227984ULL, 0x000fe20000000800ULL,
0x0000001040407824ULL, 0x100fe400078e021bULL, 0x0000001048487824ULL, 0x100fe200078e021bULL,
0x00001f4e211f7589ULL, 0x000ea200000e0000ULL, 0x000000103e3e7824ULL, 0x100fe400078e021bULL,
0x000000104a4a7824ULL, 0x000fe200078e021bULL, 0x0000000024247984ULL, 0x000ee20000000800ULL,
0x000000011d407824ULL, 0x000fc400078e0240ULL, 0x000000011d427824ULL, 0x040fe200078e0242ULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000011d447824ULL, 0x040fe400078e0244ULL,
0x000000011d467824ULL, 0x000fe200078e0246ULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x0000003621367221ULL, 0x000fe40000010000ULL, 0x000000011d487824ULL, 0x040fe200078e0248ULL,
0x000000001c1c7984ULL, 0x000f220000000800ULL, 0x000000011d3e7824ULL, 0x000fc400078e023eULL,
0x000000011d4a7824ULL, 0x000fe200078e024aULL, 0x00005410ff1a7816ULL, 0x102fe20000000023ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x00007610ff1b7816ULL, 0x000fc60000000023ULL,
0x0000001f1a357223ULL, 0x084fe20000010035ULL, 0x00005410ff1a7816ULL, 0x000fe2000000003cULL,
0x0000001f1b347223ULL, 0x080fe20000010034ULL, 0x00007610ff1b7816ULL, 0x000fe2000000003cULL,
0x0000000042427984ULL, 0x000fe40000000800ULL, 0x0000001f1a197223ULL, 0x080fe20000010019ULL,
0x00005410ff1a7816ULL, 0x000fe2000000001eULL, 0x0000001f1b187223ULL, 0x080fe20000010018ULL,
0x00007610ff1b7816ULL, 0x000fe2000000001eULL, 0x0000000044447984ULL, 0x000fe40000000800ULL,
0x0000001f1a337223ULL, 0x080fe20000010033ULL, 0x00005410ff1a7816ULL, 0x000fe20000000020ULL,
0x0000001f1b327223ULL, 0x080fe20000010032ULL, 0x00007610ff1b7816ULL, 0x000fe20000000020ULL,
0x00001f5021217589ULL, 0x000e6400000e0000ULL, 0x0000001f1a317223ULL, 0x080fe20000010031ULL,
0x00005410ff1a7816ULL, 0x000fe20000000022ULL, 0x0000001f1b307223ULL, 0x080fe20000010030ULL,
0x00007610ff1b7816ULL, 0x000fe20000000022ULL, 0x0000000046467984ULL, 0x000ea40000000800ULL,
0x0000001f1a2f7223ULL, 0x080fe2000001002fULL, 0x00005410ff1a7816ULL, 0x008fe20000000024ULL,
0x0000001f1b2e7223ULL, 0x080fe2000001002eULL, 0x00007610ff1b7816ULL, 0x000fe20000000024ULL,
0x0000000048487984ULL, 0x000ee40000000800ULL, 0x0000001f1a2d7223ULL, 0x080fe2000001002dULL,
0x00005410ff1a7816ULL, 0x010fe20000000038ULL, 0x0000001f1b2c7223ULL, 0x080fe2000001002cULL,
0x00007610ff1b7816ULL, 0x000fe20000000038ULL, 0x000000003e3e7984ULL, 0x000f240000000800ULL,
0x0000001f1a2b7223ULL, 0x080fe2000001002bULL, 0x00005410ff1a7816ULL, 0x020fe2000000003aULL,
0x0000001f1b2a7223ULL, 0x080fe2000001002aULL, 0x00007610ff1b7816ULL, 0x000fe2000000001cULL,
0x000000004a4a7984ULL, 0x000f640000000800ULL, 0x0000001f1a297223ULL, 0x000fe20000010029ULL,
0x00007610ff1a7816ULL, 0x000fe2000000003aULL, 0x000000211b167223ULL, 0x002fe20000010016ULL,
0x00007610ff1b7816ULL, 0x000fc60000000040ULL, 0x0000001f1a277223ULL, 0x000fe20000010027ULL,
0x00005410ff1a7816ULL, 0x000fe2000000001cULL, 0x000000211b147223ULL, 0x000fe20000010014ULL,
0x00007610ff1b7816ULL, 0x000fc60000000042ULL, 0x000000211a177223ULL, 0x080fe20000010017ULL,
0x00005410ff1a7816ULL, 0x000fe20000000040ULL, 0x000000211b127223ULL, 0x000fe20000010012ULL,
0x00007610ff1b7816ULL, 0x000fc60000000044ULL, 0x000000211a157223ULL, 0x080fe20000010015ULL,
0x00005410ff1a7816ULL, 0x000fe20000000042ULL, 0x000000211b107223ULL, 0x000fe20000010010ULL,
0x00007610ff1b7816ULL, 0x004fc60000000046ULL, 0x000000211a137223ULL, 0x080fe20000010013ULL,
0x00005410ff1a7816ULL, 0x000fe20000000044ULL, 0x000000211b0e7223ULL, 0x000fe2000001000eULL,
0x00007610ff1b7816ULL, 0x008fc60000000048ULL, 0x000000211a117223ULL, 0x080fe20000010011ULL,
0x00005410ff1a7816ULL, 0x000fe20000000046ULL, 0x000000211b0c7223ULL, 0x000fe2000001000cULL,
0x00005410ff1b7816ULL, 0x010fc6000000003eULL, 0x000000211a0f7223ULL, 0x080fe2000001000fULL,
0x00005410ff1a7816ULL, 0x000fe20000000048ULL, 0x000000211b0a7223ULL, 0x000fe2000001000aULL,
0x00007610ff1b7816ULL, 0x000fc6000000003eULL, 0x000000211a0d7223ULL, 0x080fe2000001000dULL,
0x00007610ff1a7816ULL, 0x020fe2000000004aULL, 0x000000211b087223ULL, 0x000fe20000010008ULL,
0x00005410ff1b7816ULL, 0x000fc6000000004aULL, 0x000000211a057223ULL, 0x080fe40000010005ULL,
0x000000211b067223ULL, 0x000fe20000010006ULL, 0xfffff2d000008947ULL, 0x000fea000383ffffULL,
0x0180000036047810ULL, 0x004fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000004047812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0036ULL, 0x00016f10001a7802ULL, 0x000fe40000000f00ULL,
0x00007d0000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003600077308ULL, 0x000e640000001000ULL, 0xbf80000007047423ULL, 0x002fc80000000036ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000407047223ULL, 0x000fe40000000007ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000b7919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000080b3a7811ULL, 0x010fe400078ff0ffULL,
0x00000002ff1b7819ULL, 0x000fe4000001160bULL, 0x0000003aff3c7212ULL, 0x000fe200078e33ffULL,
0x00001f3a04077589ULL, 0x00ee6200000e0000ULL, 0x000000083a1f7824ULL, 0x000fc400078e00ffULL,
0x000000081b1d7824ULL, 0x000fe200078e00ffULL, 0x00001f1b041a7589ULL, 0x000ea400000e0000ULL,
0xfffffff81f3c7812ULL, 0x000fca00078ee23cULL, 0x000000103c3c7824ULL, 0x000fe400078e0203ULL,
0x0000000d070d7220ULL, 0x042fe40000410000ULL, 0x0000000c070c7220ULL, 0x040fe40000410000ULL,
0x0000001307137220ULL, 0x040fe40000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000000d0c0c723eULL, 0x000fe200000010ffULL, 0x0000000607067220ULL, 0x000fc40000410000ULL,
0x0000000507057220ULL, 0x000fe20000410000ULL, 0x000000131212723eULL, 0x000fe200000010ffULL,
0x000000351a357220ULL, 0x004fe20000410000ULL, 0x000000073a137812ULL, 0x000fe200078ec0ffULL,
0x000000341a347220ULL, 0x040fe20000410000ULL, 0x000000060505723eULL, 0x000fe200000010ffULL,
0x000000331a337220ULL, 0x040fe40000410000ULL, 0x000000321a327220ULL, 0x000fe20000410000ULL,
0x000000353434723eULL, 0x000fe200000010ffULL, 0x000000311a317220ULL, 0x000fc40000410000ULL,
0x000000301a307220ULL, 0x000fe20000410000ULL, 0x000000333232723eULL, 0x000fe200000010ffULL,
0x0000002f1a2f7220ULL, 0x040fe40000410000ULL, 0x0000002e1a2e7220ULL, 0x000fe20000410000ULL,
0x000000313030723eULL, 0x000fe200000010ffULL, 0x0000002d1a2d7220ULL, 0x040fe40000410000ULL,
0x0000002c1a2c7220ULL, 0x000fe20000410000ULL, 0x0000002f2e2e723eULL, 0x000fe200000010ffULL,
0x0000002b1a2b7220ULL, 0x000fc40000410000ULL, 0x0000002a1a2a7220ULL, 0x000fe20000410000ULL,
0x0000002d2c2c723eULL, 0x000fe200000010ffULL, 0x000000291a297220ULL, 0x040fe40000410000ULL,
0x000000271a047220ULL, 0x000fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x000000191a197220ULL, 0x040fe40000410000ULL, 0x000000181a187220ULL, 0x000fe20000410000ULL,
0x0000001bff1a7212ULL, 0x000fe200078e33ffULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x000000290404723eULL, 0x000fe200000010ffULL, 0x0000001607167220ULL, 0x000fe20000410000ULL,
0xfffffff81d3e7812ULL, 0x000fe200078ee21aULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x000000191818723eULL, 0x000fe200000010ffULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x000000171616723eULL, 0x000fe200000010ffULL, 0x0000001107117220ULL, 0x000fc40000410000ULL,
0x0000001007107220ULL, 0x040fe20000410000ULL, 0x000000151414723eULL, 0x000fe200000010ffULL,
0x0000000f070f7220ULL, 0x040fe40000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x000000111010723eULL, 0x000fe200000010ffULL, 0x0000000a070a7220ULL, 0x000fe20000410000ULL,
0x0000000513117812ULL, 0x000fe200078e3cffULL, 0x0000000807097220ULL, 0x000fe20000410000ULL,
0x000000071b077812ULL, 0x040fe200078ec0ffULL, 0x000000083a0d7824ULL, 0x000fe200078e00ffULL,
0x0000000f0e0e723eULL, 0x000fe200000010ffULL, 0x000000081b067824ULL, 0x000fe200078e00ffULL,
0x0000000a0909723eULL, 0x000fe200000010ffULL, 0x000000040b157824ULL, 0x000fe200078e00ffULL,
0x0000000107087812ULL, 0x040fe200078e3cffULL, 0x000000083a387824ULL, 0x000fe200078e0211ULL,
0x00000002070a7812ULL, 0x000fc400078e3cffULL, 0x00000003071a7812ULL, 0x000fe200078e3cffULL,
0x000000081b087824ULL, 0x000fe200078e0208ULL, 0x00000004071c7812ULL, 0x000fe200078e3cffULL,
0x000000081b0a7824ULL, 0x000fe200078e020aULL, 0x00000005071e7812ULL, 0x000fe200078e3cffULL,
0x000000081b1a7824ULL, 0x000fe200078e021aULL, 0x0000000607207812ULL, 0x000fe200078e3cffULL,
0x000000081b1c7824ULL, 0x000fe200078e021cULL, 0xfffffff80d227812ULL, 0x000fe200078ee23aULL,
0x000000081b1e7824ULL, 0x000fe200078e021eULL, 0x0000000113077812ULL, 0x000fe200078e3cffULL,
0x000000081b207824ULL, 0x000fe200078e0220ULL, 0x00000002130b7812ULL, 0x040fe200078e3cffULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0x00000003130d7812ULL, 0x040fe200078e3cffULL,
0x000000083a247824ULL, 0x040fe200078e0207ULL, 0x00000004130f7812ULL, 0x040fe200078e3cffULL,
0x000000083a267824ULL, 0x000fe200078e020bULL, 0xfffffff806067812ULL, 0x000fe200078ee21bULL,
0x000000083a287824ULL, 0x040fe200078e020dULL, 0x0000000613137812ULL, 0x000fe200078e3cffULL,
0x000000083a367824ULL, 0x000fe200078e020fULL, 0x0000000c15217812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x000fc400078e0203ULL, 0x000000083a3a7824ULL, 0x000fe400078e0213ULL,
0x000000103e0b7824ULL, 0x100fe400078e0203ULL, 0x000000100a0a7824ULL, 0x100fe400078e0203ULL,
0x000000101a1a7824ULL, 0x100fe400078e0203ULL, 0x0000001022227824ULL, 0x000fe400078e0203ULL,
0x0000000121077824ULL, 0x000fc400078e0206ULL, 0x000000101c1c7824ULL, 0x100fe400078e0203ULL,
0x000000101e1e7824ULL, 0x100fe200078e0203ULL, 0x0000003407007388ULL, 0x0003e20000000800ULL,
0x0000001020207824ULL, 0x100fe400078e0203ULL, 0x0000001024247824ULL, 0x100fe400078e0203ULL,
0x0000001026267824ULL, 0x100fe400078e0203ULL, 0x0000001028287824ULL, 0x000fc400078e0203ULL,
0x0000001036367824ULL, 0x100fe400078e0203ULL, 0x0000001038387824ULL, 0x100fe400078e0203ULL,
0x000000103a3a7824ULL, 0x000fe400078e0203ULL, 0x0000000121157824ULL, 0x040fe400078e020bULL,
0x0000000121037824ULL, 0x040fe400078e0208ULL, 0x00000001210b7824ULL, 0x000fc400078e020aULL,
0x00000001210d7824ULL, 0x040fe200078e021aULL, 0x0000003203007388ULL, 0x0005e20000000800ULL,
0x00000001210f7824ULL, 0x040fe400078e021cULL, 0x0000000121117824ULL, 0x040fe200078e021eULL,
0x000000300b007388ULL, 0x0005e20000000800ULL, 0x0000000121137824ULL, 0x040fe400078e0220ULL,
0x0000000121177824ULL, 0x040fe200078e0222ULL, 0x0000002e0d007388ULL, 0x0005e20000000800ULL,
0x0000000121197824ULL, 0x000fc400078e0224ULL, 0x0000000121077824ULL, 0x042fe200078e0226ULL,
0x0000002c0f007388ULL, 0x0005e20000000800ULL, 0x00000001211b7824ULL, 0x040fe400078e0228ULL,
0x00000001211d7824ULL, 0x040fe200078e0236ULL, 0x0000002a11007388ULL, 0x0005e20000000800ULL,
0x00000001211f7824ULL, 0x040fe400078e0238ULL, 0x00000001213a7824ULL, 0x040fe200078e023aULL,
0x0000000413007388ULL, 0x0005e20000000800ULL, 0x00000001213c7824ULL, 0x000fc600078e023cULL,
0x0000001815007388ULL, 0x0005e80000000800ULL, 0x0000001617007388ULL, 0x0005e80000000800ULL,
0x0000001419007388ULL, 0x0005e80000000800ULL, 0x0000001207007388ULL, 0x0005e80000000800ULL,
0x000000101b007388ULL, 0x0005e80000000800ULL, 0x0000000e1d007388ULL, 0x0005e80000000800ULL,
0x0000000c1f007388ULL, 0x0005e80000000800ULL, 0x000000093a007388ULL, 0x0005e80000000800ULL,
0x000000053c007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000167919ULL, 0x006e620000000000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x0000000800007824ULL, 0x000fe200078e00ffULL,
0x0000000000147919ULL, 0x000ee20000002600ULL, 0x0000000405057899ULL, 0x000fc6000800063fULL,
0x1ffffff800007812ULL, 0x000fe400078ec0ffULL, 0x0000002016157810ULL, 0x002fe20007ffe0ffULL,
0x00000004050472a4ULL, 0x004fe2000f8e023fULL, 0x00000003ff037819ULL, 0x000fe20000011616ULL,
0x0000001014047824ULL, 0x008fe200078e00ffULL, 0x0000004016177810ULL, 0x000fe20007ffe0ffULL,
0x0000001014237824ULL, 0x000fe200078e00ffULL, 0x0000006016217810ULL, 0x000fe20007ffe0ffULL,
0x0000001014257824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc40000011615ULL,
0xfffffff004047812ULL, 0x000fe400078ee203ULL, 0x00000003ff087819ULL, 0x000fe40000011617ULL,
0x00000003ff0a7819ULL, 0x000fe40000011621ULL, 0x0000000703037812ULL, 0x000fe400078e4816ULL,
0x0000000705067812ULL, 0x000fe400078e4815ULL, 0x0000000708097812ULL, 0x000fc400078e4817ULL,
0x000000070a0b7812ULL, 0x000fe400078e4821ULL, 0x0ffffff803037812ULL, 0x000fe400078ef816ULL,
0x0ffffff806077812ULL, 0x000fe400078ef815ULL, 0x0ffffff809097812ULL, 0x000fe200078ef817ULL,
0x00000010030c7824ULL, 0x100fe200078e0202ULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef821ULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001009097824ULL, 0x000fe200078e0202ULL, 0xfffffff023087812ULL, 0x000fe200078ee208ULL,
0x000000100b0b7824ULL, 0x000fe200078e0202ULL, 0x012000000c0c7984ULL, 0x000e620000000c00ULL,
0x0000001014027824ULL, 0x000fe200078e00ffULL, 0xfffffff0250a7812ULL, 0x000fe200078ee20aULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0120000007107984ULL, 0x000ea20000000c00ULL,
0x0000000700157812ULL, 0x000fc400078ef815ULL, 0xfffffff002057812ULL, 0x000fe200078ee205ULL,
0x0120000009187984ULL, 0x0007220000000c00ULL, 0x00005a0004027a11ULL, 0x000fe400078048ffULL,
0x000000040a0a7c10ULL, 0x000fe2000ff5e0ffULL, 0x012000000b1c7984ULL, 0x000b220000000c00ULL,
0x00005b0004037a11ULL, 0x000fe400000f4c03ULL, 0x0000000405057c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff097224ULL, 0x008fe200010e06ffULL, 0x0000000408077c10ULL, 0x000fc4000ff3e0ffULL,
0x00005a000a087a11ULL, 0x000fe400078448ffULL, 0x00000007000b7812ULL, 0x060fe200078ef816ULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x00005a0005047a11ULL, 0x000fe200078048ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x00005a0007067a11ULL, 0x000fe200078248ffULL,
0x000000100b027825ULL, 0x000fe200078e0002ULL, 0x00005b0005057a11ULL, 0x000fe400000f4c16ULL,
0x0000000700177812ULL, 0x000fc400078ef817ULL, 0x00005b0007077a11ULL, 0x000fe200008f4c14ULL,
0x0000001015047825ULL, 0x000fe200078e0004ULL, 0x0000000700217812ULL, 0x000fe400078ef821ULL,
0x00005b000a097a11ULL, 0x000fe200010f4c09ULL, 0x0000001017067825ULL, 0x000fc800078e0006ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000000c02007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x004fe8000c101d06ULL, 0x0000001806007986ULL, 0x010fe8000c101d06ULL,
0x0000001c08007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff387624ULL, 0x000fe400078e00ffULL, 0x00006700ff397624ULL, 0x000fca00078e00ffULL,
0x0000000638387981ULL, 0x000362000c1e9900ULL, 0x0000000103057810ULL, 0x000fe20007ffe0ffULL,
0x0000000214147824ULL, 0x000fe400078e00ffULL, 0x0000004000067824ULL, 0x000fe200078e00ffULL,
0x000000040500720cULL, 0x000fe20003f06070ULL, 0x0000580014057a24ULL, 0x000fe400078e0215ULL,
0x00000100030e7824ULL, 0x000fc800078e0206ULL, 0x0000620005297a24ULL, 0x000fcc00078e020eULL,
0x00000ba000008947ULL, 0x000fea0003800000ULL, 0x00000000002b7919ULL, 0x002e620000000000ULL,
0x0000000e02077217ULL, 0x000fe20007800000ULL, 0x00000100ff2d7424ULL, 0x000fe200078e00ffULL,
0x00002000001c7811ULL, 0x000fc600078e70ffULL, 0x0000000107077824ULL, 0x000fe200078e0a0eULL,
0x00000003ff247819ULL, 0x002fe2000001162bULL, 0x000000102b0d7824ULL, 0x000fc600078e00ffULL,
0x00000004240a7810ULL, 0x040fe40007ffe0ffULL, 0x00000008240c7810ULL, 0x000fe40007ffe0ffULL,
0x0000002b0a087212ULL, 0x0c0fe200078e3cffULL, 0x000000080a1b7824ULL, 0x000fe200078e00ffULL,
0x0000002b0c097212ULL, 0x0c0fe200078e3cffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x0000000c240e7810ULL, 0x040fe40007ffe0ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x0000000124087824ULL, 0x000fe200078e0229ULL, 0xfffffff810217812ULL, 0x000fe200078ee209ULL,
0x000000080e107824ULL, 0x040fe200078e00ffULL, 0x0000002b0e0b7212ULL, 0x000fe200078e3cffULL,
0x00005e0008087625ULL, 0x000fe200078e002dULL, 0x000000700d2f7812ULL, 0x000fc400078ec0ffULL,
0xfffffff810237812ULL, 0x000fe200078ee20bULL, 0x000000101b1f7824ULL, 0x100fe200078e021cULL,
0x0000001024147810ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e021cULL,
0x000000082f107210ULL, 0x000fe20007f1e0ffULL, 0x0000000129087824ULL, 0x000fe200078e020aULL,
0x0000002b140b7212ULL, 0x040fe200078e3cffULL, 0x0000000814127824ULL, 0x000fe200078e00ffULL,
0x000000070a00720cULL, 0x080fe20003f86070ULL, 0x000000ffff117224ULL, 0x000fe200000e0609ULL,
0x000000070e00720cULL, 0x000fe20003f66070ULL, 0x00005e0008087625ULL, 0x000fe200078e002dULL,
0xfffffff812257812ULL, 0x000fc400078ee20bULL, 0x000000070c00720cULL, 0x000fe20003f46070ULL,
0x00000001290a7824ULL, 0x000fe200078e020cULL, 0x000000082f127210ULL, 0x000fe20007f3e0ffULL,
0x00000001290e7824ULL, 0x040fe200078e020eULL, 0x0000001424187810ULL, 0x000fe20007ffe0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e002dULL, 0x000000071400720cULL, 0x000fe40003f06070ULL,
0x00000018241a7810ULL, 0x040fe20007ffe0ffULL, 0x00000001290c7824ULL, 0x000fe200078e0214ULL,
0x00000007241e7812ULL, 0x000fe200078e482bULL, 0x000000ffff137224ULL, 0x000fe200008e0609ULL,
0x0000000a2f147210ULL, 0x000fe20007f3e0ffULL, 0x00005e000e087625ULL, 0x000fe200078e002dULL,
0x0000001c24207810ULL, 0x000fc40007ffe0ffULL, 0x0000002b180a7212ULL, 0x000fe200078e3cffULL,
0x00000001290f7824ULL, 0x000fe200078e0218ULL, 0x0ffffff81e1d7812ULL, 0x000fe200078ef82bULL,
0x00005e000c0c7625ULL, 0x000fe200078e002dULL, 0x0000002024227810ULL, 0x000fe40007ffe0ffULL,
0x0000002b1a1e7212ULL, 0x000fe200078e3cffULL, 0x000000ffff157224ULL, 0x000fe200008e060bULL,
0x000000082f167210ULL, 0x000fe20007f3e0ffULL, 0x00005e000f0e7625ULL, 0x000fe200078e002dULL,
0x0000000c2f0c7210ULL, 0x000fc60007fbe0ffULL, 0x0000000129087824ULL, 0x000fe200078e021aULL,
0x0000000e2f0e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0609ULL,
0x000000071800720cULL, 0x080fe20003f26070ULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0x000000072400720cULL, 0x000fe20003fa6070ULL, 0x00005e0008087625ULL, 0x000fc800078e002dULL,
0x000000ffff0f7224ULL, 0x000fe400030e060fULL, 0x0000000818277824ULL, 0x000fe200078e00ffULL,
0x000000082f187210ULL, 0x000fe20007fde0ffULL, 0x0000000129087824ULL, 0x000fe400078e0220ULL,
0x000000101d1d7824ULL, 0x000fe200078e021cULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x000000ffff197224ULL, 0x000fe400030e0609ULL, 0x00005e0008087625ULL, 0x000fe200078e002dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0003e2000e901c46ULL,
0x000000071a00720cULL, 0x000fc40003fa6070ULL, 0x0000001023237824ULL, 0x000fe200078e021cULL,
0x00000000121f7faeULL, 0x0005e2000e101c46ULL, 0x000000081a317824ULL, 0x000fe200078e00ffULL,
0x000000082f1a7210ULL, 0x000fe20007fde0ffULL, 0x00000001290a7824ULL, 0x000fe200078e0222ULL,
0x0000002b20087212ULL, 0x040fe200078e3cffULL, 0x0000000014217faeULL, 0x0007e2000d101c46ULL,
0x000000072000720cULL, 0x000fe20003f86070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e002dULL,
0x0000002424107810ULL, 0x002fe20007ffe0ffULL, 0x0000000016237faeULL, 0x0003e2000d901c46ULL,
0x000000072200720cULL, 0x000fe20003f66070ULL, 0x00000008201d7824ULL, 0x000fe200078e00ffULL,
0x0000002b22117212ULL, 0x040fe200078e3cffULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0xfffffff831137812ULL, 0x004fe200078ee21eULL, 0x000000ffff1b7224ULL, 0x000fe200030e0609ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL, 0x0000000129087824ULL, 0x000fe200078e0210ULL,
0x0000000a2f0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001025257824ULL, 0x000fe200078e021cULL,
0xfffffff822157812ULL, 0x008fe200078ee211ULL, 0x00005e0008087625ULL, 0x000fe200078e002dULL,
0x000000071000720cULL, 0x000fc40003f46070ULL, 0x0000002b10127212ULL, 0x000fe200078e3cffULL,
0x0000001027277824ULL, 0x100fe200078e021cULL, 0x000000000c257faeULL, 0x0005e2000c101c46ULL,
0x0000001013137824ULL, 0x100fe200078e021cULL, 0x0000003024147810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x000000000e277faeULL, 0x0007e2000c901c46ULL,
0x00000008101f7824ULL, 0x000fe200078e00ffULL, 0x000000082f107210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021cULL, 0x0000002824087810ULL, 0x040fe20007ffe0ffULL,
0x0000001015157824ULL, 0x000fe200078e021cULL, 0x0000000018137faeULL, 0x0009e2000e901c46ULL,
0xfffffff81f177812ULL, 0x002fe200078ee212ULL, 0x000000ffff117224ULL, 0x000fe200030e0609ULL,
0x0000002c24127810ULL, 0x040fe20007ffe0ffULL, 0x000000001a1d7faeULL, 0x0003e2000e101c46ULL,
0x0000003424167810ULL, 0x040fe20007ffe0ffULL, 0x0000001017177824ULL, 0x000fe200078e021cULL,
0x00000038241e7810ULL, 0x040fe20007ffe0ffULL, 0x000000000a157faeULL, 0x0005e2000d901c46ULL,
0x0000003c24207810ULL, 0x000fe20007ffe0ffULL, 0x00000001290e7824ULL, 0x008fe200078e0214ULL,
0x000000070800720cULL, 0x040fe20003fc6070ULL, 0x0000000010177faeULL, 0x0007e2000d101c46ULL,
0x0000002b08097212ULL, 0x000fc400078e3cffULL, 0x000000071200720cULL, 0x080fe20003fa6070ULL,
0x00000008201d7824ULL, 0x002fe200078e00ffULL, 0x000000071400720cULL, 0x080fe20003f86070ULL,
0x000000081e1b7824ULL, 0x000fe200078e00ffULL, 0x000000071600720cULL, 0x080fe20003f66070ULL,
0x00000008080a7824ULL, 0x004fe200078e00ffULL, 0x000000071e00720cULL, 0x080fe20003f26070ULL,
0x0000000129087824ULL, 0x000fe200078e0208ULL, 0x000000072000720cULL, 0x000fe40003f06070ULL,
0xfffffff80a077812ULL, 0x000fe200078ee209ULL, 0x00005e0008087625ULL, 0x000fe200078e002dULL,
0x0000002b120d7212ULL, 0x000fc400078e3cffULL, 0x0000002b140f7212ULL, 0x080fe200078e3cffULL,
0x00000001290a7824ULL, 0x000fe200078e0212ULL, 0x000000082f0c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000812127824ULL, 0x000fe200078e00ffULL, 0x0000002b16117212ULL, 0x008fe200078e3cffULL,
0x00005e000a0a7625ULL, 0x000fc600078e002dULL, 0xfffffff812157812ULL, 0x000fe200078ee20dULL,
0x000000ffff0d7224ULL, 0x000fe400010e0609ULL, 0x0000000814147824ULL, 0x000fe400078e00ffULL,
0x00005e000e087625ULL, 0x000fe200078e002dULL, 0x0000000a2f0e7210ULL, 0x000fe40007f5e0ffULL,
0xfffffff814177812ULL, 0x000fe200078ee20fULL, 0x00000001290a7824ULL, 0x000fe200078e0216ULL,
0x0000002b1e147212ULL, 0x000fe200078e3cffULL, 0x0000000816127824ULL, 0x000fc400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060bULL, 0x000000082f107210ULL, 0x000fe20007f5e0ffULL,
0x00005e000a0a7625ULL, 0x080fe200078e002dULL, 0xfffffff812197812ULL, 0x010fe400078ee211ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee214ULL, 0x0000000129087824ULL, 0x000fe400078e021eULL,
0x000000ffff117224ULL, 0x000fe200010e0609ULL, 0x0000000a2f127210ULL, 0x000fe20007f5e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e002dULL, 0x0000002b200a7212ULL, 0x000fc600078e3cffULL,
0x0000000129167824ULL, 0x000fe200078e0220ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL,
0x000000ffff137224ULL, 0x000fe200010e060bULL, 0x000000082f087210ULL, 0x000fe20007f5e0ffULL,
0x00005e00160a7625ULL, 0x000fc800078e002dULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000000a2f0a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001007077824ULL, 0x100fe400078e021cULL,
0x0000001015157824ULL, 0x100fe400078e021cULL, 0x0000001017177824ULL, 0x100fe200078e021cULL,
0x000000000c077faeULL, 0x0003e2000f101c46ULL, 0x0000001019197824ULL, 0x100fe400078e021cULL,
0x000000101b1b7824ULL, 0x100fe200078e021cULL, 0x000000000e157faeULL, 0x0003e2000e901c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e021cULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000010177faeULL, 0x0003e8000e101c46ULL, 0x0000000012197faeULL, 0x0003e8000d901c46ULL,
0x00000000081b7faeULL, 0x0003e8000c901c46ULL, 0x000000000a1d7faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x00000100ff267424ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x002fc80000011607ULL,
0x00000004080c7810ULL, 0x040fe40007ffe0ffULL, 0x00000008080e7810ULL, 0x000fe40007ffe0ffULL,
0x000000070c097212ULL, 0x0c0fe200078e3cffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x0000000c08147810ULL, 0x000fe20007ffe0ffULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x00000014081c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff810107812ULL, 0x000fe200078ee209ULL,
0x00000008140d7824ULL, 0x000fe200078e00ffULL, 0x000000070e097212ULL, 0x080fe200078e3cffULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0x0000001008187810ULL, 0x000fe20007ffe0ffULL,
0x00000001290f7824ULL, 0x040fe200078e0214ULL, 0x00000007140a7212ULL, 0x080fe200078e3cffULL,
0x0000000129137824ULL, 0x040fe200078e021cULL, 0x0000001808207810ULL, 0x000fe20007ffe0ffULL,
0x00000008181a7824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee209ULL,
0x0000000129117824ULL, 0x040fe200078e0218ULL, 0x00000020082a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129157824ULL, 0x000fe200078e0220ULL, 0x000000071c097212ULL, 0x000fc400078e3cffULL,
0xfffffff80d167812ULL, 0x000fe200078ee20aULL, 0x00000008200d7824ULL, 0x000fe200078e00ffULL,
0x0000001c08247810ULL, 0x000fe20007ffe0ffULL, 0x000000082a2c7824ULL, 0x000fe200078e00ffULL,
0x00000007180b7212ULL, 0x080fe200078e3cffULL, 0x0000000129197824ULL, 0x040fe200078e022aULL,
0x00000007200a7212ULL, 0x000fe200078e3cffULL, 0x0000000824287824ULL, 0x000fe200078e00ffULL,
0x00000024082e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129177824ULL, 0x000fe200078e0224ULL,
0xfffffff81e1e7812ULL, 0x000fc400078ee209ULL, 0x0000002c08367810ULL, 0x000fe20007ffe0ffULL,
0x00000001291b7824ULL, 0x000fe200078e022eULL, 0x000000072a097212ULL, 0x080fe400078e3cffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL, 0x00000008363a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d227812ULL, 0x000fe200078ee20aULL, 0x000000082e0d7824ULL, 0x000fe200078e00ffULL,
0x0000002808327810ULL, 0x000fe20007ffe0ffULL, 0x00000001291f7824ULL, 0x000fe200078e0236ULL,
0x00000007240b7212ULL, 0x000fc400078e3cffULL, 0x000000072e0a7212ULL, 0x080fe200078e3cffULL,
0x0000000832347824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee209ULL,
0x00000001291d7824ULL, 0x000fe200078e0232ULL, 0x00000030083c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000736097212ULL, 0x080fe200078e3cffULL, 0x00005e001d1c7625ULL, 0x000fe200078e0026ULL,
0xfffffff828287812ULL, 0x000fe400078ee20bULL, 0x0000003408407810ULL, 0x000fe20007ffe0ffULL,
0x0000000129217824ULL, 0x000fe200078e023cULL, 0x00000007320b7212ULL, 0x000fc400078e3cffULL,
0xfffffff80d307812ULL, 0x000fe200078ee20aULL, 0x000000083c0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee209ULL, 0x0000001007097824ULL, 0x000fe200078e00ffULL,
0x000000073c0a7212ULL, 0x080fe200078e3cffULL, 0x0000000840427824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee20bULL, 0x0000000129237824ULL, 0x000fe200078e0240ULL,
0x00000007400b7212ULL, 0x000fe200078e3cffULL, 0x00005e0021207625ULL, 0x000fe200078e0026ULL,
0x0000003808447810ULL, 0x000fc40007ffe0ffULL, 0x0000003c08467810ULL, 0x040fe40007ffe0ffULL,
0xfffffff80d3e7812ULL, 0x000fe200078ee20aULL, 0x00000001290d7824ULL, 0x000fe200078e020eULL,
0x00000070092b7812ULL, 0x000fe200078ec0ffULL, 0x0000000108097824ULL, 0x040fe200078e0229ULL,
0x00000007080a7812ULL, 0x000fe200078e4807ULL, 0x0000000129257824ULL, 0x040fe200078e0244ULL,
0xfffffff842427812ULL, 0x000fe200078ee20bULL, 0x00000001290b7824ULL, 0x040fe200078e020cULL,
0x0ffffff80a0a7812ULL, 0x000fe200078ef807ULL, 0x0000000129277824ULL, 0x000fe200078e0246ULL,
0x00000007440c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000844297824ULL, 0x000fe200078e00ffULL,
0x00000007460e7212ULL, 0x000fe200078e3cffULL, 0x00005e0009087625ULL, 0x000fe200078e0026ULL,
0x0000200000077811ULL, 0x000fc400078e70ffULL, 0xfffffff829147812ULL, 0x000fe200078ee20cULL,
0x00000008462d7824ULL, 0x000fe200078e00ffULL, 0x000000082b087210ULL, 0x000fe20007f1e0ffULL,
0x000000100a297824ULL, 0x000fe400078e0207ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0026ULL,
0xfffffff82d187812ULL, 0x000fc600078ee20eULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x0000000a2b0a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010102d7824ULL, 0x000fe400078e0207ULL,
0x00005e0011107625ULL, 0x080fe200078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008297faeULL, 0x0003e6000b901c46ULL, 0x00005e000d0c7625ULL, 0x000fc800078e0026ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x000000102b107210ULL, 0x040fe20007f1e0ffULL,
0x0000001014477824ULL, 0x100fe200078e0207ULL, 0x0000000c2b0c7210ULL, 0x000fe20007f3e0ffULL,
0x00000010122f7824ULL, 0x000fe200078e0207ULL, 0x000000000a2d7faeULL, 0x0003e2000b901c46ULL,
0x00005e0015147625ULL, 0x000fc800078e0026ULL, 0x00005e0013127625ULL, 0x000fc800078e0026ULL,
0x0000001016317824ULL, 0x100fe400078e0207ULL, 0x000000101a337824ULL, 0x100fe400078e0207ULL,
0x000000101e357824ULL, 0x100fe400078e0207ULL, 0x0000001022377824ULL, 0x100fe400078e0207ULL,
0x0000001028397824ULL, 0x100fe400078e0207ULL, 0x000000102c3b7824ULL, 0x000fc400078e0207ULL,
0x00000010303d7824ULL, 0x100fe400078e0207ULL, 0x00000010343f7824ULL, 0x100fe400078e0207ULL,
0x000000103a417824ULL, 0x100fe400078e0207ULL, 0x000000103e437824ULL, 0x100fe400078e0207ULL,
0x0000001042457824ULL, 0x000fe400078e0207ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x000000142b147210ULL, 0x000fe20007f1e0ffULL, 0x0000001018077824ULL, 0x000fc400078e0207ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000122b127210ULL, 0x000fe20007f3e0ffULL,
0x00005e0019187625ULL, 0x000fc600078e0026ULL, 0x000000000c2f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0017167625ULL, 0x000fc800078e0026ULL, 0x00005e000f0e7625ULL, 0x000fc800078e0026ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x000000182b187210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x000000162b167210ULL, 0x000fe20007f3e0ffULL,
0x00005e001f1e7625ULL, 0x000fe200078e0026ULL, 0x0000000e2b0e7210ULL, 0x000fc60007f5e0ffULL,
0x00005e001b1a7625ULL, 0x000fc800078e0026ULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000001e2b1e7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x0000001a2b1a7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x0000001c2b1c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0023227625ULL, 0x000fc600078e0026ULL,
0x000000000e317faeULL, 0x0003e2000b901c46ULL, 0x00005e0025247625ULL, 0x000fc600078e0026ULL,
0x0000000010337faeULL, 0x0003e2000b901c46ULL, 0x00005e0027267625ULL, 0x000fc600078e0026ULL,
0x0000000012357faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x000000202b207210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e061bULL,
0x000000222b227210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x000000242b247210ULL, 0x040fe20007f5e0ffULL, 0x0000000014377faeULL, 0x0003e2000b901c46ULL,
0x000000262b267210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff217224ULL, 0x000fe400000e0621ULL,
0x0000000016397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc400008e0623ULL,
0x000000ffff257224ULL, 0x000fe200010e0625ULL, 0x00000000183b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff277224ULL, 0x000fc600018e0627ULL, 0x000000001a3d7faeULL, 0x0003e8000b901c46ULL,
0x000000001c3f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e417faeULL, 0x0003e8000b901c46ULL,
0x0000000020437faeULL, 0x0003e8000b901c46ULL, 0x0000000022457faeULL, 0x0003e8000b901c46ULL,
0x0000000024477faeULL, 0x0003e8000b901c46ULL, 0x0000000026077faeULL, 0x0003e4000b901c46ULL,
0x01c60400ff077984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000007ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff077424ULL, 0x000fc800078e00ffULL,
0x0000000700087305ULL, 0x0002a4000021f000ULL, 0x3fa0000007077823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe40003800000ULL, 0x01c60400ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000030000780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e640000000000ULL,
0x0000002000077824ULL, 0x002fc800078e0207ULL, 0x0000002007097824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fc80000011607ULL, 0x1ffffffe08087812ULL, 0x000fe400078ec0ffULL,
0x000001e009097812ULL, 0x000fe400078ec0ffULL, 0x00000001080c7812ULL, 0x040fe400078efcffULL,
0x00000007080a7812ULL, 0x100fe400078e7807ULL, 0x000000070c0c7812ULL, 0x100fe400078e7807ULL,
0x00000010080e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x040fe200078e020aULL,
0x0000001108087810ULL, 0x000fe20007ffe0ffULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0x000000070e0e7812ULL, 0x000fc400078e7807ULL, 0x000000000a147984ULL, 0x000e62000000cc00ULL,
0x0000000708087812ULL, 0x000fe400078e7807ULL, 0x00000001090e7824ULL, 0x040fe200078e020eULL,
0x000000000c107984ULL, 0x000ea4000000cc00ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fc400078e0016ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0017ULL,
0x000000180a007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1f7224ULL, 0x000fca00078e0013ULL, 0x0000001c0c007388ULL, 0x000fe8000000cc00ULL,
0x0000000008107984ULL, 0x000e68000000cc00ULL, 0x000000000e147984ULL, 0x000ea2000000cc00ULL,
0x000000ffff237224ULL, 0x002fe400078e0012ULL, 0x000000ffff227224ULL, 0x000fc400078e0010ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff207224ULL, 0x004fe400078e0014ULL,
0x000000ffff217224ULL, 0x000fe400078e0016ULL, 0x000000ffff107224ULL, 0x000fe400078e0015ULL,
0x000000ffff117224ULL, 0x000fe200078e0017ULL, 0x000000200e007388ULL, 0x0003e8000000cc00ULL,
0x0000001008007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01c60400ff077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff077424ULL, 0x000fc800078e00ffULL,
0x0000000700087305ULL, 0x0022a4000021f000ULL, 0x3fa0000007077823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe40003800000ULL, 0x01c60400ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000040300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x3d80000038387820ULL, 0x020fe20000410000ULL, 0xffffffff043a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001000397824ULL, 0x000fe200078e00ffULL, 0x00007610ff3c7816ULL, 0x000fe2000000003cULL,
0x000000ffff3b7224ULL, 0x000fe400078e00ffULL, 0x00000100033d7824ULL, 0x000fe200078e0206ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003d0200720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x008fea0003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e003bULL,
0x0000000000107805ULL, 0x002fe2000001ff00ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fc4000001ff00ULL, 0x000000013e297810ULL, 0x000fe20007ffe0ffULL,
0x000014e000007945ULL, 0x000fe20003800000ULL, 0x000000013f3b7812ULL, 0x000fc400078e0cffULL,
0x00000001ff287819ULL, 0x000fe40000011629ULL, 0x000000022900780cULL, 0x000fc60003f06070ULL,
0x00000300282b7a24ULL, 0x000fe400078e0203ULL, 0x000000ffff287224ULL, 0x000fe400078e003eULL,
0x000000ffff3e7224ULL, 0x000fe200078e0029ULL, 0x000000012b2d7810ULL, 0x000fc80007ffe0ffULL,
0x000000042d00720cULL, 0x000fe20003f26070ULL, 0x000001002b2d7824ULL, 0x000fe200078e0206ULL,
0x00000001292b7812ULL, 0x000fc600078ec0ffULL, 0x0000620005297a24ULL, 0x000fd000078e022dULL,
0x00000aa000009947ULL, 0x000fea0003800000ULL, 0x00000003ff427819ULL, 0x004fe20000011607ULL,
0x00000100ff497424ULL, 0x000fe200078e00ffULL, 0x0000002d022a7217ULL, 0x000fe40007800000ULL,
0x0000001442447810ULL, 0x040fe40007ffe0ffULL, 0x00000004422e7810ULL, 0x000fe20007ffe0ffULL,
0x000000012a347824ULL, 0x000fe200078e0a2dULL, 0x0000000842307810ULL, 0x000fe20007ffe0ffULL,
0x0000000844467824ULL, 0x040fe200078e00ffULL, 0x00000007442f7212ULL, 0x000fe200078e3cffULL,
0x000000082e417824ULL, 0x000fe200078e00ffULL, 0x0000000c42327810ULL, 0x000fe20007ffe0ffULL,
0x0000000830437824ULL, 0x000fe200078e00ffULL, 0xfffffff8464b7812ULL, 0x000fc400078ee22fULL,
0x000000072e2c7212ULL, 0x080fe200078e3cffULL, 0x0000000832457824ULL, 0x000fe200078e00ffULL,
0x0000001042407810ULL, 0x040fe40007ffe0ffULL, 0x0000001842467810ULL, 0x000fe40007ffe0ffULL,
0x00000007302a7212ULL, 0x000fe200078e3cffULL, 0x0000000840367824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee22cULL, 0x00000008464d7824ULL, 0x000fe200078e00ffULL,
0x0000001c42487810ULL, 0x000fc40007ffe0ffULL, 0x00000007322c7212ULL, 0x080fe400078e3cffULL,
0xfffffff843437812ULL, 0x000fe200078ee22aULL, 0x00000008484f7824ULL, 0x000fe200078e00ffULL,
0x00000007402d7212ULL, 0x080fe400078e3cffULL, 0x00000020424a7810ULL, 0x000fe40007ffe0ffULL,
0x00000007462a7212ULL, 0x000fe400078e3cffULL, 0xfffffff845457812ULL, 0x000fc400078ee22cULL,
0xfffffff836477812ULL, 0x000fe200078ee22dULL, 0x000000084a367824ULL, 0x000fe200078e00ffULL,
0x00000007482c7212ULL, 0x080fe400078e3cffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee22aULL,
0x000000082b2a7824ULL, 0x000fe200078e00ffULL, 0x000000074a2d7212ULL, 0x000fe400078e3cffULL,
0x00000024424c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff84f4f7812ULL, 0x000fc400078ee22cULL,
0x00000007422c7812ULL, 0x000fe200078e4807ULL, 0x000000084c4e7824ULL, 0x000fe200078e00ffULL,
0xfffffff836517812ULL, 0x000fe200078ee22dULL, 0x0000000200367824ULL, 0x000fe200078e023bULL,
0xfffffff82a377812ULL, 0x000fe200078ee207ULL, 0x00000001422a7824ULL, 0x000fe200078e0229ULL,
0x0ffffff82c357812ULL, 0x000fe200078ef807ULL, 0x000000012e2c7824ULL, 0x000fe200078e0229ULL,
0x000000344200720cULL, 0x000fe20003f26070ULL, 0x00005e002a2a7625ULL, 0x000fe200078e0049ULL,
0x000000074c2f7212ULL, 0x000fc400078e3cffULL, 0x000000342e00720cULL, 0x080fe20003f46070ULL,
0x00000001302e7824ULL, 0x140fe200078e0229ULL, 0x000000343000720cULL, 0x080fe20003f66070ULL,
0x0000000132307824ULL, 0x000fe200078e0229ULL, 0x0000200036367811ULL, 0x000fe200078e68ffULL,
0x00005e002c2c7625ULL, 0x080fe200078e0049ULL, 0x000000343200720cULL, 0x080fe40003f86070ULL,
0xfffffff84e537812ULL, 0x000fe200078ee22fULL, 0x0000000140327824ULL, 0x040fe200078e0229ULL,
0x000000344000720cULL, 0x000fe20003fa6070ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0049ULL,
0x00005e0030307625ULL, 0x000fc800078e0049ULL, 0x0000001035357824ULL, 0x000fe400078e0236ULL,
0x00000010372a7825ULL, 0x000fc800078e002aULL, 0x00005e0032327625ULL, 0x000fe200078e0049ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a357faeULL, 0x0003e2000c901c46ULL,
0x000000344400720cULL, 0x000fe40003f26070ULL, 0x0000001041417824ULL, 0x000fe400078e0236ULL,
0x00000010372c7825ULL, 0x000fc800078e002cULL, 0x0000001043437824ULL, 0x000fe200078e0236ULL,
0x000000002c417faeULL, 0x0005e2000d101c46ULL, 0x00000010372e7825ULL, 0x000fe200078e002eULL,
0x000000344600720cULL, 0x000fc60003f46070ULL, 0x0000001045457824ULL, 0x000fe200078e0236ULL,
0x000000002e437faeULL, 0x0007e2000d901c46ULL, 0x0000001037307825ULL, 0x000fe200078e0030ULL,
0x000000344800720cULL, 0x000fc60003f66070ULL, 0x0000001047477824ULL, 0x000fe200078e0236ULL,
0x0000000030457faeULL, 0x0009e2000e101c46ULL, 0x0000001037327825ULL, 0x000fe200078e0032ULL,
0x000000344a00720cULL, 0x000fc60003f86070ULL, 0x00000001442a7824ULL, 0x102fe200078e0229ULL,
0x0000000032477faeULL, 0x0003e2000e901c46ULL, 0x00000001462c7824ULL, 0x104fe200078e0229ULL,
0x000000344c00720cULL, 0x000fe20003fa6070ULL, 0x00005e002a2a7625ULL, 0x000fe200078e0049ULL,
0x0000003042447810ULL, 0x040fe40007ffe0ffULL, 0x0000003442467810ULL, 0x000fe20007ffe0ffULL,
0x0000000148407824ULL, 0x100fe200078e0229ULL, 0x0000003842487810ULL, 0x000fe20007ffe0ffULL,
0x000000014a417824ULL, 0x000fc400078e0229ULL, 0x00005e002c2c7625ULL, 0x000fc800078e0049ULL,
0x000000014c327824ULL, 0x002fe400078e0229ULL, 0x00005e00402e7625ULL, 0x008fe200078e0049ULL,
0x0000002c42407810ULL, 0x000fc60007ffe0ffULL, 0x00005e0041307625ULL, 0x010fc800078e0049ULL,
0x000000104b357824ULL, 0x000fe400078e0236ULL, 0x00000010372a7825ULL, 0x000fc800078e002aULL,
0x00005e0032327625ULL, 0x000fe200078e0049ULL, 0x000000002a357faeULL, 0x0003e6000c901c46ULL,
0x000000104d417824ULL, 0x000fe400078e0236ULL, 0x00000010372c7825ULL, 0x000fc800078e002cULL,
0x000000104f437824ULL, 0x000fe200078e0236ULL, 0x000000002c417faeULL, 0x0005e2000d101c46ULL,
0x00000010372e7825ULL, 0x000fe200078e002eULL, 0x00000028422a7810ULL, 0x042fe40007ffe0ffULL,
0x0000003c42427810ULL, 0x000fe20007ffe0ffULL, 0x0000001051457824ULL, 0x000fe200078e0236ULL,
0x000000002e437faeULL, 0x0003e2000d901c46ULL, 0x0000001037307825ULL, 0x000fe200078e0030ULL,
0x000000342a00720cULL, 0x080fe40003f26070ULL, 0x000000344000720cULL, 0x000fe20003f46070ULL,
0x00000010532b7824ULL, 0x000fe200078e0236ULL, 0x0000000030457faeULL, 0x0007e2000e101c46ULL,
0x0000001037327825ULL, 0x000fe200078e0032ULL, 0x000000072a2c7212ULL, 0x004fc400078e3cffULL,
0x000000344400720cULL, 0x080fe20003f66070ULL, 0x000000082a417824ULL, 0x000fe200078e00ffULL,
0x00000000322b7faeULL, 0x0005e2000e901c46ULL, 0x00000008402e7824ULL, 0x002fe200078e00ffULL,
0x000000344600720cULL, 0x080fe20003f86070ULL, 0x000000012a2a7824ULL, 0x100fe200078e0229ULL,
0x000000344800720cULL, 0x080fe40003fa6070ULL, 0x000000344200720cULL, 0x000fe20003fc6070ULL,
0x0000000146307824ULL, 0x148fe200078e0229ULL, 0x00000007462d7212ULL, 0x080fe200078e3cffULL,
0x0000000142347824ULL, 0x140fe200078e0229ULL, 0x00000007422f7212ULL, 0x080fe200078e3cffULL,
0x0000000846467824ULL, 0x000fe200078e00ffULL, 0x00000007402b7212ULL, 0x084fe200078e3cffULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee22cULL,
0x00000001402c7824ULL, 0x000fe200078e0229ULL, 0xfffffff82e437812ULL, 0x000fe200078ee22bULL,
0x00000001442e7824ULL, 0x040fe200078e0229ULL, 0x00000007442b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000844447824ULL, 0x000fe200078e00ffULL, 0xfffffff846477812ULL, 0x000fe200078ee22dULL,
0x0000000148327824ULL, 0x040fe200078e0229ULL, 0x0000000748297212ULL, 0x040fe200078e3cffULL,
0x0000000848487824ULL, 0x000fe200078e00ffULL, 0xfffffff844457812ULL, 0x000fe200078ee22bULL,
0x00005e002a2a7625ULL, 0x000fe200078e0049ULL, 0xfffffff8424d7812ULL, 0x000fc400078ee22fULL,
0xfffffff8484b7812ULL, 0x000fe200078ee229ULL, 0x00005e002c2c7625ULL, 0x000fc800078e0049ULL,
0x00005e002e2e7625ULL, 0x000fc800078e0049ULL, 0x00005e0030307625ULL, 0x000fc800078e0049ULL,
0x00005e0032327625ULL, 0x000fc800078e0049ULL, 0x00005e0034347625ULL, 0x000fc800078e0049ULL,
0x00000010372a7825ULL, 0x000fc800078e002aULL, 0x00000010372c7825ULL, 0x000fc800078e002cULL,
0x00000010372e7825ULL, 0x000fc800078e002eULL, 0x0000001037307825ULL, 0x000fc800078e0030ULL,
0x0000001037327825ULL, 0x000fc800078e0032ULL, 0x0000001037347825ULL, 0x000fc800078e0034ULL,
0x0000001041297824ULL, 0x100fe400078e0236ULL, 0x0000001043377824ULL, 0x100fe400078e0236ULL,
0x0000001045417824ULL, 0x100fe200078e0236ULL, 0x000000002a297faeULL, 0x0003e2000c901c46ULL,
0x0000001047437824ULL, 0x100fe400078e0236ULL, 0x000000104b457824ULL, 0x100fe200078e0236ULL,
0x000000002c377faeULL, 0x0003e2000d101c46ULL, 0x000000104d477824ULL, 0x000fc600078e0236ULL,
0x000000002e417faeULL, 0x0003e8000d901c46ULL, 0x0000000030437faeULL, 0x0003e8000e101c46ULL,
0x0000000032457faeULL, 0x0003e8000e901c46ULL, 0x0000000034477faeULL, 0x0003e2000f101c46ULL,
0x0000097000007947ULL, 0x000fea0003800000ULL, 0x00000003ff2a7819ULL, 0x004fe20000011607ULL,
0x000000082b4c7824ULL, 0x000fc400078e00ffULL, 0x00000002002b7824ULL, 0x000fe200078e023bULL,
0x000000042a2e7810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff4e7424ULL, 0x000fe200078e00ffULL,
0x0000000c2a327810ULL, 0x040fe40007ffe0ffULL, 0x000000142a367810ULL, 0x000fe20007ffe0ffULL,
0x000000082e2f7824ULL, 0x040fe200078e00ffULL, 0x000000072e2c7212ULL, 0x080fe200078e3cffULL,
0x0000000832317824ULL, 0x000fe200078e00ffULL, 0x000000202a447810ULL, 0x000fe20007ffe0ffULL,
0x0000000836587824ULL, 0x040fe200078e00ffULL, 0xfffffff82f507812ULL, 0x000fe200078ee22cULL,
0x0000000136357824ULL, 0x100fe200078e0229ULL, 0x00000007322c7212ULL, 0x080fe200078e3cffULL,
0x00000008445e7824ULL, 0x000fe200078e00ffULL, 0x00000007362f7212ULL, 0x000fe200078e3cffULL,
0x0000000144437824ULL, 0x000fe200078e0229ULL, 0x000000182a407810ULL, 0x000fc40007ffe0ffULL,
0x000000082a307810ULL, 0x000fe40007ffe0ffULL, 0xfffffff831547812ULL, 0x000fe200078ee22cULL,
0x0000000840317824ULL, 0x000fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fe200078ee22fULL,
0x0000000830527824ULL, 0x000fe200078e00ffULL, 0x00000007442f7212ULL, 0x080fe200078e3cffULL,
0x0000000140377824ULL, 0x000fe200078e0229ULL, 0x000000242a467810ULL, 0x000fe40007ffe0ffULL,
0x00000007402c7212ULL, 0x000fe200078e3cffULL, 0x00005e0037367625ULL, 0x000fe200078e004eULL,
0x000000102a347810ULL, 0x000fc40007ffe0ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee22fULL,
0x00000008462f7824ULL, 0x000fe200078e00ffULL, 0x00000007302d7212ULL, 0x080fe200078e3cffULL,
0x0000000834567824ULL, 0x000fe200078e00ffULL, 0xfffffff8315a7812ULL, 0x000fe200078ee22cULL,
0x0000000132317824ULL, 0x100fe200078e0229ULL, 0x00000007462c7212ULL, 0x000fe200078e3cffULL,
0x0000000134337824ULL, 0x100fe200078e0229ULL, 0x0000002c2a4a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000146457824ULL, 0x000fe200078e0229ULL, 0xfffffff852527812ULL, 0x000fc400078ee22dULL,
0x0000001c2a427810ULL, 0x000fe20007ffe0ffULL, 0x000000014a497824ULL, 0x000fe200078e0229ULL,
0x00000007342d7212ULL, 0x080fe200078e3cffULL, 0x00005e0045447625ULL, 0x080fe200078e004eULL,
0xfffffff82f607812ULL, 0x000fe400078ee22cULL, 0x000000074a2c7212ULL, 0x0c0fe200078e3cffULL,
0x000000084a2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff856567812ULL, 0x000fe200078ee22dULL,
0x00000008425c7824ULL, 0x000fe200078e00ffULL, 0x000000282a487810ULL, 0x000fe20007ffe0ffULL,
0x0000000142417824ULL, 0x040fe200078e0229ULL, 0x00000007422d7212ULL, 0x000fe200078e3cffULL,
0x00005e0043427625ULL, 0x000fe200078e004eULL, 0x000020002b537811ULL, 0x000fc400078e68ffULL,
0xfffffff82f647812ULL, 0x000fe200078ee22cULL, 0x000000012a2b7824ULL, 0x040fe200078e0229ULL,
0x000000072a2c7812ULL, 0x100fe200078e4807ULL, 0x0000000848627824ULL, 0x000fe200078e00ffULL,
0xfffffff84c517812ULL, 0x000fe200078ee207ULL, 0x00000001302f7824ULL, 0x000fe200078e0229ULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee22dULL, 0x0000000148477824ULL, 0x000fe200078e0229ULL,
0x000000302a4c7810ULL, 0x040fe20007ffe0ffULL, 0x00005e0041407625ULL, 0x000fe200078e004eULL,
0x000000342a667810ULL, 0x000fc40007ffe0ffULL, 0x000000382a687810ULL, 0x000fe20007ffe0ffULL,
0x000000014c4b7824ULL, 0x000fe200078e0229ULL, 0x0000003c2a6a7810ULL, 0x000fe20007ffe0ffULL,
0x00005e002b2a7625ULL, 0x000fe200078e004eULL, 0x00000007482d7212ULL, 0x080fe400078e3cffULL,
0x0ffffff82c2c7812ULL, 0x000fe200078ef807ULL, 0x00000001664d7824ULL, 0x000fe200078e0229ULL,
0xfffffff862627812ULL, 0x000fe200078ee22dULL, 0x000000012e2d7824ULL, 0x100fe200078e0229ULL,
0x000000074c2e7212ULL, 0x080fe200078e3cffULL, 0x00000001684f7824ULL, 0x100fe200078e0229ULL,
0x0000000766307212ULL, 0x080fe200078e3cffULL, 0x000000016a557824ULL, 0x000fe200078e0229ULL,
0x0000000768327212ULL, 0x080fe200078e3cffULL, 0x000000102c297824ULL, 0x000fe200078e0253ULL,
0x000000076a347212ULL, 0x000fe200078e3cffULL, 0x00000010512a7825ULL, 0x000fc800078e002aULL,
0x000000084c577824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a297faeULL, 0x0003e2000b901c46ULL, 0x0000000866597824ULL, 0x000fe400078e00ffULL,
0x00000008685b7824ULL, 0x000fe200078e00ffULL, 0xfffffff857667812ULL, 0x000fe200078ee22eULL,
0x000000086a5d7824ULL, 0x000fe200078e00ffULL, 0xfffffff859687812ULL, 0x000fe200078ee230ULL,
0x00005e002d2c7625ULL, 0x080fe200078e004eULL, 0xfffffff85b6a7812ULL, 0x000fe400078ee232ULL,
0xfffffff85d6c7812ULL, 0x000fe200078ee234ULL, 0x00005e002f2e7625ULL, 0x000fc800078e004eULL,
0x00005e00492a7625ULL, 0x002fc800078e004eULL, 0x00005e004b487625ULL, 0x000fc800078e004eULL,
0x00005e004d4a7625ULL, 0x000fc800078e004eULL, 0x00005e0031307625ULL, 0x000fc800078e004eULL,
0x00005e0033327625ULL, 0x000fc800078e004eULL, 0x00005e0035347625ULL, 0x000fc800078e004eULL,
0x00005e0047467625ULL, 0x000fc800078e004eULL, 0x00005e004f4c7625ULL, 0x000fc800078e004eULL,
0x00005e00554e7625ULL, 0x000fc800078e004eULL, 0x00000010512c7825ULL, 0x000fc800078e002cULL,
0x00000010512e7825ULL, 0x000fc800078e002eULL, 0x0000001051307825ULL, 0x000fc800078e0030ULL,
0x0000001051327825ULL, 0x000fc800078e0032ULL, 0x0000001051347825ULL, 0x000fc800078e0034ULL,
0x0000001051367825ULL, 0x000fc800078e0036ULL, 0x0000001051407825ULL, 0x000fc800078e0040ULL,
0x0000001051427825ULL, 0x000fc800078e0042ULL, 0x0000001051447825ULL, 0x000fc800078e0044ULL,
0x0000001051467825ULL, 0x000fc800078e0046ULL, 0x00000010512a7825ULL, 0x000fc800078e002aULL,
0x0000001051487825ULL, 0x000fc800078e0048ULL, 0x00000010514a7825ULL, 0x000fc800078e004aULL,
0x00000010514c7825ULL, 0x000fc800078e004cULL, 0x00000010514e7825ULL, 0x000fc800078e004eULL,
0x0000001050297824ULL, 0x100fe400078e0253ULL, 0x0000001052517824ULL, 0x100fe400078e0253ULL,
0x0000001054557824ULL, 0x100fe200078e0253ULL, 0x000000002c297faeULL, 0x0003e2000b901c46ULL,
0x0000001056577824ULL, 0x100fe400078e0253ULL, 0x0000001058597824ULL, 0x100fe200078e0253ULL,
0x000000002e517faeULL, 0x0003e2000b901c46ULL, 0x000000105a5b7824ULL, 0x000fc400078e0253ULL,
0x000000105c5d7824ULL, 0x100fe200078e0253ULL, 0x0000000030557faeULL, 0x0003e2000b901c46ULL,
0x000000105e5f7824ULL, 0x100fe400078e0253ULL, 0x0000001060617824ULL, 0x100fe200078e0253ULL,
0x0000000032577faeULL, 0x0003e2000b901c46ULL, 0x0000001062637824ULL, 0x100fe400078e0253ULL,
0x0000001064657824ULL, 0x100fe200078e0253ULL, 0x0000000034597faeULL, 0x0003e2000b901c46ULL,
0x0000001066677824ULL, 0x000fc400078e0253ULL, 0x0000001068697824ULL, 0x100fe200078e0253ULL,
0x00000000365b7faeULL, 0x0003e2000b901c46ULL, 0x000000106a6b7824ULL, 0x100fe400078e0253ULL,
0x000000106c537824ULL, 0x000fe200078e0253ULL, 0x00000000405d7faeULL, 0x0003e8000b901c46ULL,
0x00000000425f7faeULL, 0x0003e8000b901c46ULL, 0x0000000044617faeULL, 0x0003e8000b901c46ULL,
0x0000000046637faeULL, 0x0003e8000b901c46ULL, 0x000000002a657faeULL, 0x0003e8000b901c46ULL,
0x0000000048677faeULL, 0x0003e8000b901c46ULL, 0x000000004a697faeULL, 0x0003e8000b901c46ULL,
0x000000004c6b7faeULL, 0x0003e8000b901c46ULL, 0x000000004e537faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001028487824ULL, 0x002fc400078e00ffULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff807287812ULL, 0x040fe200078ec0ffULL,
0x00000002002d7824ULL, 0x000fe200078e023fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000020072b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000728297812ULL, 0x000fe400078ef807ULL,
0x000020002d2d7811ULL, 0x000fe400078e68ffULL, 0x0000000746287812ULL, 0x000fc400078e7829ULL,
0x00000001462c7810ULL, 0x000fc60007ffe0ffULL, 0x0000000829287824ULL, 0x000fe200078e0228ULL,
0x000000072c2a7812ULL, 0x000fc600078e7829ULL, 0x0000001028287824ULL, 0x000fe400078e022dULL,
0x00000008292a7824ULL, 0x000fc600078e022aULL, 0x000000002834783bULL, 0x000e620000000200ULL,
0x000000102a2a7824ULL, 0x000fca00078e022dULL, 0x000000002a30783bULL, 0x0004e20000000200ULL,
0x00000018ff287819ULL, 0x002fe20000011434ULL, 0x0001000034537824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011435ULL, 0x00000035009e7306ULL, 0x000fe20000009400ULL,
0x00000018ff2a7819ULL, 0x004fe20000011436ULL, 0x0001000035547824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x00000018ff407819ULL, 0x000fe40000011437ULL,
0x00000018ff447819ULL, 0x008fe20000011432ULL, 0x00000028009c7306ULL, 0x000fe20000209400ULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00000018ff437819ULL, 0x000fe40000011431ULL,
0x00000018ff417819ULL, 0x000fe40000011430ULL, 0x00000018ff457819ULL, 0x000fe20000011433ULL,
0x0000002800a37306ULL, 0x000e700000205400ULL, 0x0000002800797306ULL, 0x0004f0000020d400ULL,
0x0000002900a67306ULL, 0x000fe20000209400ULL, 0xfffffff82b287812ULL, 0x004fc400078ec0ffULL,
0x000000a39c00720bULL, 0x002fe40003fdd000ULL, 0x00000007282f7812ULL, 0x000fc600078ef807ULL,
0x0000002900a77306ULL, 0x000fe20000205400ULL, 0x0000000746287812ULL, 0x100fe400078e782fULL,
0x000000072c2c7812ULL, 0x000fe400078e782fULL, 0x0000000246467810ULL, 0x000fe20007ffe0ffULL,
0x000000082f287824ULL, 0x040fe400078e0228ULL, 0x0000002900757306ULL, 0x000fe2000020d400ULL,
0x000000082f2c7824ULL, 0x000fe200078e022cULL, 0x0000000179796812ULL, 0x008fe200078efcffULL,
0x0000001028287824ULL, 0x000fc400078e022dULL, 0x000000102c2c7824ULL, 0x000fc600078e022dULL,
0x0000002a00a57306ULL, 0x000fe60000209400ULL, 0x000000002c2c783bULL, 0x000e6a0000000200ULL,
0x0000002a00a27306ULL, 0x000ff00000205400ULL, 0x0000002a006e7306ULL, 0x0005f0000020d400ULL,
0x00000053006b7306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x004eae0000000200ULL,
0x0000005300b27306ULL, 0x000ef00000205400ULL, 0x0000003500a17306ULL, 0x000f220000005400ULL,
0x00000018ff857819ULL, 0x002fc4000001142dULL, 0x00000018ff897819ULL, 0x000fe4000001142eULL,
0x00000018ff5a7819ULL, 0x000fc6000001142cULL, 0x0000003500747306ULL, 0x000362000000d400ULL,
0x000000b26b00720bULL, 0x008fe40003f9d000ULL, 0x00000018ff8b7819ULL, 0x000fca000001142fULL,
0x00000034009a7306ULL, 0x000fe20000009400ULL, 0x0000010035357824ULL, 0x002fe200078e00ffULL,
0x000000a19e00720bULL, 0x010fc80003fbd000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000034009d7306ULL, 0x000e620000005400ULL, 0x0001000028847824ULL, 0x004fe400078e00ffULL,
0x000100002bdc7824ULL, 0x000fc600078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x0000003400767306ULL, 0x0004e2000000d400ULL, 0x0000000174745812ULL, 0x020fe400078efcffULL,
0x000000a2a500720bULL, 0x000fe40003fbd000ULL, 0x00000018ffdc7819ULL, 0x000fc600000114dcULL,
0x0000003500c27306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x004fe200078e00ffULL,
0x0000009d9a00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500c37306ULL, 0x000fe20000205400ULL, 0x000000016e6e5812ULL, 0x000fcc00078efcffULL,
0x0000000176762812ULL, 0x008fe200078efcffULL, 0x00000035008c7306ULL, 0x0003f0000020d400ULL,
0x0000005300957306ULL, 0x0004e2000020d400ULL, 0x00000018ff357819ULL, 0x002fce0000011428ULL,
0x0000003500cd7306ULL, 0x000fe20000209400ULL, 0x0001000036537824ULL, 0x004fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000003500cc7306ULL, 0x000fe20000205400ULL,
0x0000000195954812ULL, 0x008fe400078efcffULL, 0x000000c3c200720bULL, 0x000fca0003f9d000ULL,
0x0000003500867306ULL, 0x0003f0000020d400ULL, 0x0000003400b67306ULL, 0x000fe20000209400ULL,
0x0001000030357824ULL, 0x002fe200078e00ffULL, 0x000000018c8c4812ULL, 0x000fc800078efcffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400b77306ULL, 0x000e700000205400ULL,
0x0000003400947306ULL, 0x0004f0000020d400ULL, 0x0000003700967306ULL, 0x000fe20000009400ULL,
0x0001000037347824ULL, 0x004fe200078e00ffULL, 0x000000b7b600720bULL, 0x002fc80003f7d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000037009b7306ULL, 0x000e6e0000005400ULL,
0x0000000194943812ULL, 0x008fe200078efcffULL, 0x00000037006d7306ULL, 0x0004e2000000d400ULL,
0x000000a7a600720bULL, 0x000fce0003f7d000ULL, 0x0000003500be7306ULL, 0x000fe20000209400ULL,
0x0000010037377824ULL, 0x004fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003500bf7306ULL, 0x000fe20000205400ULL, 0x0000000175753812ULL, 0x000fe400078efcffULL,
0x0000009b9600720bULL, 0x002fca0003f7d000ULL, 0x00000035005c7306ULL, 0x0003f0000020d400ULL,
0x00000032007e7306ULL, 0x000fe20000009400ULL, 0x0001000032357824ULL, 0x002fe200078e00ffULL,
0x000000016d6d3812ULL, 0x008fcc00078efcffULL, 0x00000032007f7306ULL, 0x000ff00000005400ULL,
0x00000032004c7306ULL, 0x0003f0000000d400ULL, 0x0000005300c47306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x002fce00078e00ffULL, 0x0000005300c57306ULL, 0x000e700000205400ULL,
0x0000003400c87306ULL, 0x000ff00000209400ULL, 0x0000003400c97306ULL, 0x000ea20000205400ULL,
0x000000c5c400720bULL, 0x002fce0003fdd000ULL, 0x0000003400927306ULL, 0x0002f0000020d400ULL,
0x0000005400b87306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x002fe4000001142aULL,
0x000000c9c800720bULL, 0x004fca0003f9d000ULL, 0x0000005400b97306ULL, 0x000e700000205400ULL,
0x0000005400937306ULL, 0x000522000020d400ULL, 0x0000000192924812ULL, 0x008fce00078efcffULL,
0x0000003700ce7306ULL, 0x000fe20000209400ULL, 0x00000018ff547819ULL, 0x004fe20000011432ULL,
0x0001000033327824ULL, 0x000fe200078e00ffULL, 0x000000b9b800720bULL, 0x002fc80003f3d000ULL,
0x00000018ff557819ULL, 0x000fe20000011432ULL, 0x0000003700cf7306ULL, 0x000ff00000205400ULL,
0x00000037008d7306ULL, 0x0003e2000020d400ULL, 0x0000000193931812ULL, 0x010fce00078efcffULL,
0x0000003400bb7306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x002fce000001142bULL,
0x0000003400ba7306ULL, 0x000ff00000205400ULL, 0x0000003400637306ULL, 0x0003f0000020d400ULL,
0x00000031007d7306ULL, 0x000fe20000009400ULL, 0x0001000031347824ULL, 0x002fce00078e00ffULL,
0x0000003100787306ULL, 0x000ff00000005400ULL, 0x00000031004d7306ULL, 0x0003f0000000d400ULL,
0x0000003700c07306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x002fce00078e00ffULL,
0x0000003700c17306ULL, 0x000ff00000205400ULL, 0x00000037005d7306ULL, 0x0003f0000020d400ULL,
0x0000005300987306ULL, 0x0004e2000020d400ULL, 0x00000018ff377819ULL, 0x002fce0000011434ULL,
0x0000003600a07306ULL, 0x000fe20000009400ULL, 0x00000018ff537819ULL, 0x004fce0000011431ULL,
0x00000036009f7306ULL, 0x000e620000005400ULL, 0x0000000198986812ULL, 0x008fe400078efcffULL,
0x000000cfce00720bULL, 0x000fca0003fdd000ULL, 0x0000003600717306ULL, 0x0004f0000000d400ULL,
0x0000008400d07306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x000000018d8d6812ULL, 0x000fc400078efcffULL, 0x0000009fa000720bULL, 0x002fe40003f5d000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000008400d17306ULL, 0x000e700000205400ULL,
0x0000003700b57306ULL, 0x000fe20000209400ULL, 0x0000000171712812ULL, 0x008fce00078efcffULL,
0x0000003700b47306ULL, 0x000fe20000205400ULL, 0x000000d1d000720bULL, 0x002fce0003f9d000ULL,
0x0000003700347306ULL, 0x000ff0000020d400ULL, 0x0000005300b07306ULL, 0x000ff00000209400ULL,
0x0000005300b37306ULL, 0x000ff00000205400ULL, 0x0000005300317306ULL, 0x000ff0000020d400ULL,
0x00000054008e7306ULL, 0x000ff00000209400ULL, 0x0000005400977306ULL, 0x000ff00000205400ULL,
0x0000005400377306ULL, 0x000ff0000020d400ULL, 0x0000005500837306ULL, 0x000ff00000209400ULL,
0x0000005500827306ULL, 0x000ff00000205400ULL, 0x0000005500327306ULL, 0x000ff0000020d400ULL,
0x0000002800b17306ULL, 0x000ff00000009400ULL, 0x0000002800ae7306ULL, 0x000ff00000005400ULL,
0x0000002800697306ULL, 0x0003f0000000d400ULL, 0x0000008500537306ULL, 0x000fe20000209400ULL,
0x0000010028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000008500547306ULL, 0x000ff00000205400ULL, 0x0000008500557306ULL, 0x0003f0000020d400ULL,
0x0000003000807306ULL, 0x000fe20000009400ULL, 0x0001000029857824ULL, 0x002fca00078e00ffULL,
0x00000018ffd47819ULL, 0x000fe40000011485ULL, 0x0000003000817306ULL, 0x000ff00000005400ULL,
0x00000030004f7306ULL, 0x0003f0000000d400ULL, 0x0000003600c77306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fce00078e00ffULL, 0x0000003600c67306ULL, 0x000e700000205400ULL,
0x0000003600917306ULL, 0x0005f0000020d400ULL, 0x0000008400907306ULL, 0x000722000020d400ULL,
0x00000018ff367819ULL, 0x004fc40000011429ULL, 0x000000c6c700720bULL, 0x002fca0003f3d000ULL,
0x0000003600cb7306ULL, 0x000fe20000209400ULL, 0x000100002a847824ULL, 0x008fce00078e00ffULL,
0x0000003600ca7306ULL, 0x000e620000205400ULL, 0x0000000190904812ULL, 0x010fe400078efcffULL,
0x0000000191911812ULL, 0x000fe400078efcffULL, 0x000000aeb100720bULL, 0x000fc60003f3d000ULL,
0x00000036006a7306ULL, 0x0004f0000020d400ULL, 0x00000033007a7306ULL, 0x000fe20000009400ULL,
0x00000018ff367819ULL, 0x004fe40000011430ULL, 0x0000000169691812ULL, 0x000fc400078efcffULL,
0x000000cacb00720bULL, 0x002fe40003f3d000ULL, 0x000000699090723eULL, 0x000fe200000010ffULL,
0x00000033007b7306ULL, 0x000ff00000005400ULL, 0x00000033004b7306ULL, 0x0003e4000000d400ULL,
0x000000016a6a1812ULL, 0x008fcc00078efcffULL, 0x0000002800d27306ULL, 0x000fe20000209400ULL,
0x0000010033337824ULL, 0x002fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011433ULL,
0x0000002800d37306ULL, 0x000e700000205400ULL, 0x000000d400d57306ULL, 0x000ff00000209400ULL,
0x000000d400d67306ULL, 0x000ea20000205400ULL, 0x000000d3d200720bULL, 0x002fce0003fdd000ULL,
0x0000002900ac7306ULL, 0x000ff00000009400ULL, 0x0000002900af7306ULL, 0x000e620000005400ULL,
0x000000d6d500720bULL, 0x004fce0003f9d000ULL, 0x0000002900647306ULL, 0x0004f0000000d400ULL,
0x0000002a00ad7306ULL, 0x000fe20000009400ULL, 0x0000010029297824ULL, 0x004fe200078e00ffULL,
0x000000afac00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00aa7306ULL, 0x000e6e0000005400ULL, 0x0000000164645812ULL, 0x008fe200078efcffULL,
0x0000002a005e7306ULL, 0x0004e2000000d400ULL, 0x000000babb00720bULL, 0x000fce0003fbd000ULL,
0x0000003600bc7306ULL, 0x000fe20000209400ULL, 0x000001002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000aaad00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000003600bd7306ULL, 0x000e620000205400ULL, 0x0000000163635812ULL, 0x000fe400078efcffULL,
0x000000bfbe00720bULL, 0x000fc80003fbd000ULL, 0x000000015e5e3812ULL, 0x008fe200078efcffULL,
0x0000003600307306ULL, 0x0004e2000020d400ULL, 0x000000818000720bULL, 0x000fce0003f7d000ULL,
0x0000005700677306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x004fe40000011435ULL,
0x000000015c5c5812ULL, 0x000fe400078efcffULL, 0x000000bdbc00720bULL, 0x002fe40003fbd000ULL,
0x000000014f4f3812ULL, 0x000fe200078efcffULL, 0x0000003600a87306ULL, 0x000fe20000209400ULL,
0x000000b4b500720bULL, 0x000fe40003f7d000ULL, 0x0000004f5c5c723eULL, 0x000fca00000010ffULL,
0x0000003600a97306ULL, 0x000fe40000205400ULL, 0x0000000130305812ULL, 0x008fc800078efcffULL,
0x0000000134343812ULL, 0x000fe400078efcffULL, 0x0000003600357306ULL, 0x000ff0000020d400ULL,
0x0000005700687306ULL, 0x000ff00000205400ULL, 0x0000005700367306ULL, 0x000ff0000020d400ULL,
0x0000008900567306ULL, 0x000ff00000209400ULL, 0x0000008900577306ULL, 0x000ff00000205400ULL,
0x0000008900587306ULL, 0x000ff0000020d400ULL, 0x0000002800997306ULL, 0x0002b0000020d400ULL,
0x000000d400897306ULL, 0x000ee2000020d400ULL, 0x00000018ff287819ULL, 0x002fce0000011484ULL,
0x0000002900d77306ULL, 0x000fe20000209400ULL, 0x0000000199996812ULL, 0x004fce00078efcffULL,
0x0000002900d87306ULL, 0x000e620000205400ULL, 0x0000000189894812ULL, 0x008fc800078efcffULL,
0x000000648964723eULL, 0x000fc600000010ffULL, 0x0000002a00d47306ULL, 0x000ff00000209400ULL,
0x0000002a00db7306ULL, 0x000ea20000205400ULL, 0x000000d8d700720bULL, 0x002fce0003fdd000ULL,
0x0000004000a47306ULL, 0x000ff00000209400ULL, 0x0000004000ab7306ULL, 0x000e620000205400ULL,
0x000000dbd400720bULL, 0x004fce0003f9d000ULL, 0x0000005a00607306ULL, 0x000ff00000209400ULL,
0x0000005a005f7306ULL, 0x000fe20000205400ULL, 0x000000aba400720bULL, 0x002fce0003f5d000ULL,
0x0000005a00337306ULL, 0x000ff0000020d400ULL, 0x0000008b00597306ULL, 0x000ff00000209400ULL,
0x0000008b005a7306ULL, 0x000ff00000205400ULL, 0x0000008b005b7306ULL, 0x000ff0000020d400ULL,
0x00000029008b7306ULL, 0x000e70000020d400ULL, 0x0000002a00847306ULL, 0x0004f0000020d400ULL,
0x000000dc00dd7306ULL, 0x000fe20000209400ULL, 0x00000007072a7812ULL, 0x004fc400078ec0ffULL,
0x000000018b8b6812ULL, 0x002fe400078efcffULL, 0x000000082aa17812ULL, 0x000fe200078ef807ULL,
0x000100002d2a7824ULL, 0x000fe400078e00ffULL, 0x000000dc00de7306ULL, 0x000e620000205400ULL,
0x0000000184844812ULL, 0x008fe400078efcffULL, 0x000000c1c000720bULL, 0x000fe40003f9d000ULL,
0x00000018ffa47819ULL, 0x000fc4000001142aULL, 0x000000846363723eULL, 0x000fe200000010ffULL,
0x0000002800d97306ULL, 0x000ff00000209400ULL, 0x0000002800da7306ULL, 0x000fe20000205400ULL,
0x000000dedd00720bULL, 0x002fc40003fdd000ULL, 0x000000015d5d4812ULL, 0x000fca00078efcffULL,
0x0000002800857306ULL, 0x0003f0000020d400ULL, 0x00000040006c7306ULL, 0x000ea2000020d400ULL,
0x000100002c287824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011428ULL,
0x0000004807287211ULL, 0x000fe200078fe0ffULL, 0x000000dc006b7306ULL, 0x000e62000020d400ULL,
0x0000000448487810ULL, 0x000fe40007ffe0ffULL, 0x000000016c6c2812ULL, 0x004fca00078efcffULL,
0x00000029009c7306ULL, 0x000fe20000209400ULL, 0x000000cccd00720bULL, 0x000fe40003f5d000ULL,
0x0000008d6c8d723eULL, 0x000fca00000010ffULL, 0x00000029009d7306ULL, 0x000fe20000205400ULL,
0x000000016b6b6812ULL, 0x002fe400078efcffULL, 0x000000787d00720bULL, 0x000fe20003fdd000ULL,
0x000100002f7d7824ULL, 0x000fe400078e00ffULL, 0x0000000186862812ULL, 0x000fe400078efcffULL,
0x00000029009b7306ULL, 0x0003e2000020d400ULL, 0x000000dad900720bULL, 0x000fe40003f5d000ULL,
0x00000018ff7d7819ULL, 0x000fca000001147dULL, 0x0000004100877306ULL, 0x000fe20000209400ULL,
0x0000000728297812ULL, 0x042fe400078e78a1ULL, 0x0000000228287810ULL, 0x000fe40007ffe0ffULL,
0x000000014d4d6812ULL, 0x000fe200078efcffULL, 0x00000020a1297824ULL, 0x000fe200078e0229ULL,
0x000000a9a800720bULL, 0x000fe20003fdd000ULL, 0x0000004100887306ULL, 0x000e620000205400ULL,
0x0000000185852812ULL, 0x000fe200078efcffULL, 0x0000001029297824ULL, 0x000fcc00078e00ffULL,
0x0000002b008a7306ULL, 0x000fe80000009400ULL, 0x0000000135356812ULL, 0x000fc800078efcffULL,
0x0000002b008f7306ULL, 0x000ea20000005400ULL, 0x000000888700720bULL, 0x002fce0003f9d000ULL,
0x0000002b00527306ULL, 0x0002f0000000d400ULL, 0x0000002c00657306ULL, 0x000fe20000009400ULL,
0x000001002b2b7824ULL, 0x002fe200078e00ffULL, 0x0000008f8a00720bULL, 0x004fc80003f3d000ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000002c00667306ULL, 0x000e6e0000005400ULL,
0x0000000152521812ULL, 0x008fe200078efcffULL, 0x0000002c004a7306ULL, 0x0004e2000000d400ULL,
0x0000007f7e00720bULL, 0x000fe20003f3d000ULL, 0x000001002f7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000002b00a37306ULL, 0x000fe20000209400ULL,
0x000001002c2c7824ULL, 0x004fe200078e00ffULL, 0x000000666500720bULL, 0x002fe40003fdd000ULL,
0x0000008b6a65723eULL, 0x000fe400000010ffULL, 0x00000018ffa27819ULL, 0x000fe4000001142cULL,
0x0000002b00b27306ULL, 0x000e620000205400ULL, 0x00000007282c7812ULL, 0x000fc400078e78a1ULL,
0x000000014c4c1812ULL, 0x000fe400078efcffULL, 0x000000828300720bULL, 0x000fe20003f3d000ULL,
0x00000020a1a17824ULL, 0x000fe200078e022cULL, 0x00000076952c723eULL, 0x000fe200000010ffULL,
0x0000002b009a7306ULL, 0x000522000020d400ULL, 0x000100002e767824ULL, 0x000fe200078e00ffULL,
0x000000014a4a6812ULL, 0x008fe400078efcffULL, 0x0000004c354c723eULL, 0x000fe400000010ffULL,
0x00000018ff767819ULL, 0x000fc40000011476ULL, 0x0000004100477306ULL, 0x000ee2000020d400ULL,
0x000000002928783bULL, 0x004ea20000000200ULL, 0x000000b2a300720bULL, 0x002fe40003f5d000ULL,
0x0000000132321812ULL, 0x000fc800078efcffULL, 0x0000004400737306ULL, 0x000fee0000209400ULL,
0x000000019a9a2812ULL, 0x010fe200078efcffULL, 0x0000004400727306ULL, 0x000e620000205400ULL,
0x0000000147474812ULL, 0x008fe400078efcffULL, 0x000000b3b000720bULL, 0x000fc40003f9d000ULL,
0x0000007b7a00720bULL, 0x000fe20003f5d000ULL, 0x000001002e7b7824ULL, 0x000fe400078e00ffULL,
0x00000043007c7306ULL, 0x000fe60000209400ULL, 0x00000018ff7b7819ULL, 0x000fca000001147bULL,
0x0000004300777306ULL, 0x000ee20000205400ULL, 0x000000727300720bULL, 0x002fe40003f7d000ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x000000014b4b2812ULL, 0x000fe400078efcffULL,
0x0000009d9c00720bULL, 0x000fe20003f5d000ULL, 0x0000004400407306ULL, 0x000e62000020d400ULL,
0x00000064281c723cULL, 0x004fee000004181cULL, 0x0000004300427306ULL, 0x000ea2000020d400ULL,
0x000000777c00720bULL, 0x008fc60003fbd000ULL, 0x000000019b9b2812ULL, 0x000fc800078efcffULL,
0x0000004500707306ULL, 0x000fe20000209400ULL, 0x0000000140403812ULL, 0x002fe400078efcffULL,
0x000000686700720bULL, 0x000fca0003f7d000ULL, 0x00000045006f7306ULL, 0x000e620000205400ULL,
0x0000000142425812ULL, 0x004fe400078efcffULL, 0x000000978e00720bULL, 0x000fe40003fbd000ULL,
0x000000314231723eULL, 0x000fc600000010ffULL, 0x0000002d00627306ULL, 0x000fe20000009400ULL,
0x0000000136363812ULL, 0x000fe400078efcffULL, 0x0000005f6000720bULL, 0x000fca0003f7d000ULL,
0x0000002d00617306ULL, 0x000ea20000005400ULL, 0x0000006f7000720bULL, 0x002fe40003f9d000ULL,
0x0000000137375812ULL, 0x000fca00078efcffULL, 0x0000002d00497306ULL, 0x0002e2000000d400ULL,
0x0000000133333812ULL, 0x000fe400078efcffULL, 0x000000545300720bULL, 0x000fca0003f7d000ULL,
0x0000004500417306ULL, 0x000f22000020d400ULL, 0x000001002d2d7824ULL, 0x002fe200078e00ffULL,
0x000000616200720bULL, 0x004fe40003fbd000ULL, 0x0000005e8562723eULL, 0x000fe400000010ffULL,
0x00000018ff787819ULL, 0x000fe4000001142dULL, 0x000000a2009e7306ULL, 0x000fe20000209400ULL,
0x00000094792d723eULL, 0x000fe400000010ffULL, 0x000000622818723cULL, 0x000fe20000041818ULL,
0x0000000155553812ULL, 0x000fc600078efcffULL, 0x0000000149495812ULL, 0x008fe200078efcffULL,
0x000000a2009f7306ULL, 0x000e620000205400ULL, 0x0000000141414812ULL, 0x010fe400078efcffULL,
0x0000002c2810723cULL, 0x000fe20000041810ULL, 0x000000575600720bULL, 0x000fe40003fbd000ULL,
0x000000364141723eULL, 0x000fe400000010ffULL, 0x000000a400a07306ULL, 0x000fe40000209400ULL,
0x0000008c752d723eULL, 0x000fc400000010ffULL, 0x0000006d928c723eULL, 0x000fe400000010ffULL,
0x00000074932c723eULL, 0x000fe400000010ffULL, 0x000000a4008f7306ULL, 0x000ea20000205400ULL,
0x0000009f9e00720bULL, 0x002fe40003f9d000ULL, 0x0000008c2824723cULL, 0x000fe20000041824ULL,
0x0000000158585812ULL, 0x000fc800078efcffULL, 0x0000002e00517306ULL, 0x000fe60000009400ULL,
0x0000002c280c723cULL, 0x000fea000004180cULL, 0x0000002e00507306ULL, 0x000e620000005400ULL,
0x0000008fa000720bULL, 0x004fe20003fdd000ULL, 0x00000010a12c7824ULL, 0x000fcc00078e00ffULL,
0x0000002f00457306ULL, 0x000ff00000009400ULL, 0x0000002f004e7306ULL, 0x000ea20000005400ULL,
0x000000505100720bULL, 0x002fe40003f3d000ULL, 0x000000526b50723eULL, 0x000fc400000010ffULL,
0x0000009a5d51723eULL, 0x000fe400000010ffULL, 0x00000030475d723eULL, 0x000fe200000010ffULL,
0x0000002f00447306ULL, 0x0003e2000000d400ULL, 0x0000004d3430723eULL, 0x000fe400000010ffULL,
0x00000037404d723eULL, 0x000fe200000010ffULL, 0x000000502814723cULL, 0x000fe20000041814ULL,
0x0000004b3240723eULL, 0x000fe400000010ffULL, 0x0000004a9b32723eULL, 0x000fe200000010ffULL,
0x000000a200967306ULL, 0x000ee2000020d400ULL, 0x000000916e2f723eULL, 0x002fc400000010ffULL,
0x000000998691723eULL, 0x000fe400000010ffULL, 0x0000004e4500720bULL, 0x004fc60003f5d000ULL,
0x000000a400807306ULL, 0x000e64000020d400ULL, 0x000000902820723cULL, 0x000fec0000041820ULL,
0x00000078007a7306ULL, 0x000fe20000209400ULL, 0x0000000196964812ULL, 0x008fe400078efcffULL,
0x0000000144442812ULL, 0x000fc400078efcffULL, 0x000000963333723eULL, 0x000fc600000010ffULL,
0x0000007800797306ULL, 0x000ea20000205400ULL, 0x0000000180806812ULL, 0x002fc800078efcffULL,
0x000000498054723eULL, 0x000fc600000010ffULL, 0x00000076006e7306ULL, 0x000ff00000209400ULL,
0x00000076006d7306ULL, 0x000e620000205400ULL, 0x000000797a00720bULL, 0x004fce0003f9d000ULL,
0x0000002e00437306ULL, 0x0004f0000000d400ULL, 0x0000007800747306ULL, 0x000f22000020d400ULL,
0x00000071982e723eULL, 0x004fe400000010ffULL, 0x0000006d6e00720bULL, 0x002fca0003fdd000ULL,
0x0000002e2808723cULL, 0x000fe20000041808ULL, 0x0000007e00287306ULL, 0x000fe20000209400ULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0x0000000143431812ULL, 0x008fe400078efcffULL,
0x0000000174744812ULL, 0x010fc800078efcffULL, 0x0000007e002b7306ULL, 0x000ea20000205400ULL,
0x0000005a5900720bULL, 0x000fe40003f9d000ULL, 0x000000745555723eULL, 0x000fca00000010ffULL,
0x00000076006c7306ULL, 0x000eec000020d400ULL, 0x000000015b5b4812ULL, 0x000fe400078efcffULL,
0x0000007b00667306ULL, 0x000fe20000209400ULL, 0x0000002b2800720bULL, 0x004fce0003f3d000ULL,
0x0000007b00617306ULL, 0x000ea20000205400ULL, 0x000000016c6c6812ULL, 0x008fc800078efcffULL,
0x000000436c6c723eULL, 0x000fc600000010ffULL, 0x0000007d00527306ULL, 0x000fe20000209400ULL,
0x0000005c2c10723cULL, 0x042fee0000041810ULL, 0x0000007d00297306ULL, 0x000e620000205400ULL,
0x000000616600720bULL, 0x004fe20003f7d000ULL, 0x000000302c0c723cULL, 0x040fec000004180cULL,
0x0000007e007e7306ULL, 0x000ea4000020d400ULL, 0x0000004c2c08723cULL, 0x040fec0000041808ULL,
0x0000007b00657306ULL, 0x000ee2000020d400ULL, 0x000000295200720bULL, 0x002fe20003fdd000ULL,
0x000000402c24723cULL, 0x040fec0000041824ULL, 0x0000007d007d7306ULL, 0x000e62000020d400ULL,
0x000000017e7e1812ULL, 0x004fe200078efcffULL, 0x000000322c20723cULL, 0x000fe20000041820ULL,
0x000000084600780cULL, 0x000fc40003f25270ULL, 0x0000007e5b45723eULL, 0x000fe400000010ffULL,
0x0000000165653812ULL, 0x008fc600078efcffULL, 0x000000542c1c723cULL, 0x000fe2000004181cULL,
0x00000065586d723eULL, 0x000fe400000010ffULL, 0x000000017d7d6812ULL, 0x002fca00078efcffULL,
0x0000006c2c18723cULL, 0x000fe20000041818ULL, 0x000000447d44723eULL, 0x000fce00000010ffULL,
0x000000442c14723cULL, 0x000fe20000041814ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe16000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003bULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffcbe000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x01c6140039297984ULL, 0x000e620000000800ULL, 0x0000001238287220ULL, 0x040fe40000410000ULL,
0x0000000838127220ULL, 0x000fe20000410000ULL, 0x0000ffff3c087812ULL, 0x000fe200078ec0ffULL,
0x00000013382a7220ULL, 0x040fe40000410000ULL, 0x0000002438247220ULL, 0x000fe20000410000ULL,
0x0000888008367816ULL, 0x000fe200000000ffULL, 0x0000002038207220ULL, 0x000fc40000410000ULL,
0x0000002138217220ULL, 0x000fe40000410000ULL, 0x8000000036087824ULL, 0x000fe400078e00ffULL,
0x0000001038107220ULL, 0x040fe40000410000ULL, 0x0000001138117220ULL, 0x040fe40000410000ULL,
0x0000000e382b7220ULL, 0x040fe40000410000ULL, 0x0000000f382c7220ULL, 0x000fc40000410000ULL,
0x0000000938137220ULL, 0x040fe40000410000ULL, 0x0000000a382d7220ULL, 0x040fe40000410000ULL,
0x0000002538257220ULL, 0x040fe40000410000ULL, 0x0000000c380c7220ULL, 0x040fe40000410000ULL,
0x0000000d380d7220ULL, 0x040fe40000410000ULL, 0x0000000b380b7220ULL, 0x000fc40000410000ULL,
0x00000022382e7220ULL, 0x040fe40000410000ULL, 0x00000023382f7220ULL, 0x040fe40000410000ULL,
0x0000001c381c7220ULL, 0x040fe20000410000ULL, 0x8000000029ff7812ULL, 0x002fe20007804808ULL,
0x0000001d381d7220ULL, 0x040fe40000410000ULL, 0x0000001e38307220ULL, 0x040fe40000410000ULL,
0x0000001f38317220ULL, 0x000fc40000410000ULL, 0x0000001838097220ULL, 0x040fe40000410000ULL,
0x00000019380a7220ULL, 0x040fe40000410000ULL, 0x0000001a38327220ULL, 0x040fe40000410000ULL,
0x0000001b38337220ULL, 0x040fe40000410000ULL, 0x00000014381e7220ULL, 0x040fe40000410000ULL,
0x0000001638347220ULL, 0x000fc40000410000ULL, 0x0000001738357220ULL, 0x040fe40000410000ULL,
0x00000015381f7220ULL, 0x000fe40000410000ULL, 0x000000ffff147224ULL, 0x000fe400078e0024ULL,
0x000000ffff167224ULL, 0x000fe400078e0020ULL, 0x000000ffff177224ULL, 0x000fe400078e0021ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0010ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0025ULL, 0x000000ffff207224ULL, 0x000fe400078e0028ULL,
0x000000ffff217224ULL, 0x000fe400078e002aULL, 0x000000ffff227224ULL, 0x000fe400078e002bULL,
0x000000ffff237224ULL, 0x000fc400078e002cULL, 0x000000ffff247224ULL, 0x000fe400078e002dULL,
0x0000002638267220ULL, 0x040fe40000410000ULL, 0x0000002738277220ULL, 0x000fe40000410000ULL,
0x000000ffff107224ULL, 0x000fe400078e000cULL, 0x000000ffff117224ULL, 0x000fe400078e000dULL,
0x000000ffff187224ULL, 0x000fc400078e001cULL, 0x000000ffff197224ULL, 0x000fe400078e001dULL,
0x000000ffff1a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1b7224ULL, 0x000fe400078e000aULL,
0x000000ffff257224ULL, 0x000fe400078e000bULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fc400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0031ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0033ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0034ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0035ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000036367824ULL, 0x000fe400078e00ffULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x01c6140039097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804836ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004071d7824ULL, 0x000fe200078e00ffULL, 0x0000003a0300720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff01d097812ULL, 0x000fca00078ec0ffULL,
0x00000080001c7824ULL, 0x000fca00078e0209ULL, 0x01c400001c087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002070c7824ULL, 0x000fe400078e00ffULL,
0x00000001023d7824ULL, 0x000fc600078e0a3dULL, 0x000000060c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c307812ULL, 0x040fe400078efcffULL, 0x000000080c327812ULL, 0x000fe400078efcffULL,
0x0000003d3000720cULL, 0x080fe40003f26070ULL, 0x000000100c307812ULL, 0x000fe400078efcffULL,
0x0000003d3200720cULL, 0x080fe40003f06070ULL, 0x0000003d3000720cULL, 0x000fc40003fc6070ULL,
0x000000110c327812ULL, 0x040fe400078efcffULL, 0x000000180c307812ULL, 0x040fe400078efcffULL,
0x0000003d0c00720cULL, 0x080fe40003f46070ULL, 0x0000003d3200720cULL, 0x080fe40003fa6070ULL,
0x0000003d3000720cULL, 0x000fe40003f66070ULL, 0x000000090c347812ULL, 0x000fc400078efcffULL,
0x000000190c327812ULL, 0x040fe400078efcffULL, 0x000000200c307812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x0000003d3400720cULL, 0x080fe40003f86070ULL, 0x0000003d3200720cULL, 0x080fe40003f46070ULL,
0x0000003d3000720cULL, 0x000fe40003f26070ULL, 0x000000210c327812ULL, 0x040fe400078efcffULL,
0x000000280c307812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x0000003d3200720cULL, 0x080fe40003f06070ULL,
0x0000003d3000720cULL, 0x000fe40003f86070ULL, 0x000000290c327812ULL, 0x000fc400078efcffULL,
0x000000300c307812ULL, 0x000fe400078efcffULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x0000003d3200720cULL, 0x000fc40003fc6070ULL,
0x0000003d3000720cULL, 0x000fe40003fa6070ULL, 0x000000310c327812ULL, 0x040fe400078efcffULL,
0x000000380c307812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff28287808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x0000003d3200720cULL, 0x080fe40003f66070ULL, 0x0000003d3000720cULL, 0x000fc40003f46070ULL,
0x0000003d0c00720cULL, 0x000fe40003f26070ULL, 0xff7fffff29297808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff2b2b7808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff2e2e7808ULL, 0x000fc40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40004800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f080d7209ULL, 0x004fe40007810000ULL, 0x0000002009087209ULL, 0x000fe40007810000ULL,
0x0000000e0d0d7209ULL, 0x000fe40007810000ULL, 0x0000002108097209ULL, 0x000fc40007810000ULL,
0x000000100d087209ULL, 0x000fe40007810000ULL, 0x00000022090c7209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x000000230c0d7209ULL, 0x000fe40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x000000240d0c7209ULL, 0x000fc40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x000000250c0d7209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x000000260d0c7209ULL, 0x000fe40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x000000270c0d7209ULL, 0x000fc40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x000000280d0c7209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x000000290c0d7209ULL, 0x000fe40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000002a0d0c7209ULL, 0x000fc40007810000ULL,
0x0000001908097209ULL, 0x000fe40007810000ULL, 0x0000002b0c0d7209ULL, 0x000fe40007810000ULL,
0x0000001a09087209ULL, 0x000fe40007810000ULL, 0x0000002c0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001b08097209ULL, 0x000fe40007810000ULL, 0x0000002d0c0d7209ULL, 0x000fc40007810000ULL,
0x0000001e09087209ULL, 0x000fe40007810000ULL, 0x0000002e0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001f08097209ULL, 0x000fe40007810000ULL, 0x0000002f0c337209ULL, 0x000fe20007810000ULL,
0x00000dc27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009087f89ULL, 0x0004e400000e0000ULL,
0x0000000809347209ULL, 0x008fe20007810000ULL, 0x00000e127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0033087f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x004ea800000e0000ULL,
0x0c401f000b307f89ULL, 0x000f2200000e0000ULL, 0x00000008330c7209ULL, 0x008fc60007810000ULL,
0x0c201f0034087f89ULL, 0x000ee200000e0000ULL, 0x000000090a0d7209ULL, 0x004fc60007810000ULL,
0x0c201f000c097f89ULL, 0x000ea200000e0000ULL, 0x000000300b307209ULL, 0x010fc60007810000ULL,
0x0c201f000d327f89ULL, 0x002e6800000e0000ULL, 0x0c201f0030317f89ULL, 0x00092200000e0000ULL,
0x0000000834087209ULL, 0x008fe40007810000ULL, 0x000000090c097209ULL, 0x004fe40007810000ULL,
0x000000320d0a7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x00000004ff337e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x0000000f000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b12127823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b13137823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL,
0x0000000e000d7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL,
0x0000001100117308ULL, 0x000f620000000800ULL, 0x3fb8aa3b1f0b7823ULL, 0x000fe2000001080bULL,
0x0000000c0d0c723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b091f7820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001081fULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x00000010110e723eULL, 0x020fe200000010ffULL,
0x3fb8aa3b25257823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001081fULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b29297823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081fULL,
0x00000022000f7308ULL, 0x000be20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2f1f7823ULL, 0x000fe2000001081fULL, 0x0000002300327308ULL, 0x0023220000000800ULL,
0x3f8000003322783eULL, 0x020fe400000010ffULL, 0x00000020210d723eULL, 0x008fca00000010ffULL,
0x0000001300137308ULL, 0x000ee20000000800ULL, 0x000000ffff237224ULL, 0x002fe200078e0022ULL,
0x0000000f320f723eULL, 0x010fcc00000010ffULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x000000220c34723cULL, 0x000fe200000418ffULL, 0x000000121310723eULL, 0x008fcc00000010ffULL,
0x0000001500157308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ee20000000800ULL, 0x000000141512723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000242511723eULL, 0x008fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000262713723eULL, 0x002fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000221034723cULL, 0x000fee0000041834ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ee20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000181916723eULL, 0x008fe200000010ffULL, 0x0000000fff197424ULL, 0x000fe200078e00ffULL,
0xfffffffc07187812ULL, 0x000fc800078ec0ffULL, 0x0000001819247219ULL, 0x000fe200000006ffULL,
0x0000002a002a7308ULL, 0x000fe60000000800ULL, 0x00000000242173a1ULL, 0x000ee200000e8000ULL,
0x00000000240473c4ULL, 0x000f280000004000ULL, 0x0000002b002b7308ULL, 0x000f620000000800ULL,
0x000000282915723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000002a2b17723eULL, 0x020fce00000010ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000524ff7c12ULL, 0x008fe2000f804021ULL, 0x000000221434723cULL, 0x000fec0000041834ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000ee20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000010ffULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x0000001e0b1a723eULL, 0x008fe400000010ffULL,
0x00000030310b7209ULL, 0x004fca0007810000ULL, 0x0000002e002e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x0000002c2d19723eULL, 0x002fe400000010ffULL,
0x0000002e1f1b723eULL, 0x004fce00000010ffULL, 0x000000221834723cULL, 0x000fe20000041834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000a0204008947ULL, 0x010fde000b800000ULL,
0x001c1fff34207589ULL, 0x0002a400000e0000ULL, 0x00000000241f73a1ULL, 0x000ee200000e8000ULL,
0x00000000240473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000524ff7c12ULL, 0x008fda000f80401fULL, 0x00000a1204008947ULL, 0x010fea000b800000ULL,
0x001c1fff36217589ULL, 0x00072800000e0000ULL, 0x001c1fff01227589ULL, 0x00066800000e0000ULL,
0x001c1fff23237589ULL, 0x0006a400000e0000ULL, 0x00000002ff1e7819ULL, 0x000fe40000011607ULL,
0x0000000c1d3d7812ULL, 0x000fc400078ec0ffULL, 0x000000071e1f7812ULL, 0x040fe200078ec0ffULL,
0x000000081e287824ULL, 0x040fe200078e00ffULL, 0x0000001eff267212ULL, 0x002fe200078e33ffULL,
0x000000081e247824ULL, 0x048fe200078e00ffULL, 0x0000000307ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081e337824ULL, 0x040fe200078e00ffULL, 0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff828257812ULL, 0x100fe400078ee21fULL, 0x0000000124277812ULL, 0x100fe200078ef61fULL,
0x000000081e497824ULL, 0x000fe200078e00ffULL, 0x0000000224297812ULL, 0x100fe200078ef61fULL,
0x000000081e287824ULL, 0x000fe200078e00ffULL, 0x00000003242b7812ULL, 0x000fc400078ef61fULL,
0x00000004242d7812ULL, 0x140fe400078ef61fULL, 0x00000005242f7812ULL, 0x140fe400078ef61fULL,
0x0000000624317812ULL, 0x000fe200078ef61fULL, 0x000000081e247824ULL, 0x040fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe400078ee226ULL, 0x0000001eff267212ULL, 0x000fe400078e33ffULL,
0x000000071e1f7812ULL, 0x000fc400078ec0ffULL, 0x00012000001e7811ULL, 0x000fe400078e58ffULL,
0xfffffff828357812ULL, 0x100fe400078ee21fULL, 0x0000000124377812ULL, 0x140fe200078ef61fULL,
0x00000010251d7824ULL, 0x100fe200078e021eULL, 0x00000002243f7812ULL, 0x140fe200078ef61fULL,
0x000000102d287824ULL, 0x100fe200078e021eULL, 0x0000000324417812ULL, 0x040fe200078ef61fULL,
0x000000013d1d7824ULL, 0x000fe200078e021dULL, 0x0000000424437812ULL, 0x140fe200078ef61fULL,
0x000000102f2a7824ULL, 0x100fe200078e021eULL, 0x0000000524457812ULL, 0x140fe200078ef61fULL,
0x00000010312c7824ULL, 0x100fe200078e021eULL, 0x0000000624477812ULL, 0x000fe200078ef61fULL,
0x00000010271f7824ULL, 0x000fe200078e021eULL, 0xfffffff849497812ULL, 0x000fe200078ee226ULL,
0x0000001029247824ULL, 0x100fe200078e021eULL, 0x0000000c1d007388ULL, 0x0003e20000000800ULL,
0x000000102b267824ULL, 0x000fc400078e021eULL, 0x000000013d1f7824ULL, 0x040fe400078e021fULL,
0x000000013d257824ULL, 0x000fe400078e0224ULL, 0x00000010332e7824ULL, 0x000fe200078e021eULL,
0x0000000e1f007388ULL, 0x0007e20000000800ULL, 0x000000013d277824ULL, 0x000fe400078e0226ULL,
0x0000001035307824ULL, 0x000fe200078e021eULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x000000013d297824ULL, 0x000fc400078e0228ULL, 0x0000001037317824ULL, 0x000fe200078e021eULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x000000013d2b7824ULL, 0x000fe400078e022aULL,
0x000000103f327824ULL, 0x000fe200078e021eULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x000000013d2d7824ULL, 0x000fe400078e022cULL, 0x0000001041337824ULL, 0x000fe200078e021eULL,
0x000000162b007388ULL, 0x0007e20000000800ULL, 0x000000013d2f7824ULL, 0x000fc400078e022eULL,
0x0000001043347824ULL, 0x100fe200078e021eULL, 0x000000182d007388ULL, 0x0007e20000000800ULL,
0x0000001045357824ULL, 0x100fe400078e021eULL, 0x0000001047367824ULL, 0x100fe200078e021eULL,
0x0000001a2f007388ULL, 0x0007e20000000800ULL, 0x0000001049377824ULL, 0x000fe400078e021eULL,
0x000000013d307824ULL, 0x040fe400078e0230ULL, 0x000000013d1e7824ULL, 0x000fc400078e0231ULL,
0x000000013d327824ULL, 0x040fe200078e0232ULL, 0x0000000d30007388ULL, 0x0007e20000000800ULL,
0x000000013d0c7824ULL, 0x042fe400078e0233ULL, 0x000000013d347824ULL, 0x040fe200078e0234ULL,
0x0000000f1e007388ULL, 0x0007e20000000800ULL, 0x000000013d247824ULL, 0x040fe400078e0235ULL,
0x000000013d367824ULL, 0x040fe200078e0236ULL, 0x0000001132007388ULL, 0x0007e20000000800ULL,
0x000000013d267824ULL, 0x000fc600078e0237ULL, 0x000000130c007388ULL, 0x0007e80000000800ULL,
0x0000001534007388ULL, 0x0007e80000000800ULL, 0x0000001724007388ULL, 0x0007e80000000800ULL,
0x0000001936007388ULL, 0x0007e80000000800ULL, 0x0000001b26007388ULL, 0x0007e80000000800ULL,
0x01c000081c008388ULL, 0x0007e80000000c00ULL, 0x01c200201c008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030003037a10ULL, 0x000fe20007ffe0ffULL,
0x01c6080039ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff3cff7812ULL, 0x000fc4000780c0ffULL,
0x000000040300720cULL, 0x000fe40003f26070ULL, 0x00000001ff3c7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffb15000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff317224ULL, 0x000fe200078e0009ULL,
0x0001e770000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x000fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000061000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0031ULL,
0xfffff1d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x000fe200078e0033ULL,
0x0001e7f0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000059000007944ULL, 0x004fea0003c00000ULL, 0x0000003133367209ULL, 0x004fe20007810000ULL,
0x000000ffff317224ULL, 0x000fe200078e000aULL, 0x0001e860000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x000000310a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff317224ULL, 0x000fe200078e000bULL,
0x0001e8d0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000004b000007944ULL, 0x000fea0003c00000ULL, 0x000000310b307209ULL, 0x004fe20007810000ULL,
0x000000ffff317224ULL, 0x000fe200078e0034ULL, 0x0001e940000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000003134087209ULL, 0x004fe20007810000ULL, 0x000000ffff317224ULL, 0x000fe200078e0036ULL,
0x0001e9b0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x0000003136097209ULL, 0x004fe20007810000ULL,
0x000000ffff317224ULL, 0x000fe200078e000aULL, 0x0001ea20000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000310a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff317224ULL, 0x000fe200078e0030ULL,
0x0001ea90000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000002f000007944ULL, 0x000fea0003c00000ULL, 0xffffefb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e0034ULL, 0x0001eaf0001e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fe400078e00ffULL, 0x00001c1fff277424ULL, 0x000fe400078e00ffULL,
0x000002d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0023ULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x002fe200078e0036ULL,
0x0001eb60001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe400078e00ffULL,
0x00001c1fff277424ULL, 0x000fc400078e00ffULL, 0x0000026000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff267224ULL, 0x002fe200078e00ffULL, 0x0001ebb0001e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff277424ULL, 0x000fc400078e00ffULL, 0x000000ffff217224ULL, 0x004fe400078e0023ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff267224ULL, 0x002fe200078e00ffULL,
0x0001ec00001e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff277424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0023ULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xfffff52000007947ULL, 0x000fea000383ffffULL, 0x0180000007047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000000700048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff097807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000409ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007077812ULL, 0x002fe400078ec0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000409ff7212ULL, 0x000fda000780c0ffULL, 0x0080000007040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0007ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff1b7424ULL, 0x000fc800078e00ffULL, 0xfffe12801a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003e00007348ULL, 0x000fe80003800000ULL,
0x0c00003231317389ULL, 0x0002a200000e0035ULL, 0xfffe12400c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000002400007348ULL, 0x000fe80003800000ULL,
0x0000002625237389ULL, 0x0002a200000e0027ULL, 0xfffe12001e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e94ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eb8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ec8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ee8ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f58ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f70ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x000000000001ef00ULL, 0xff00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020080ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000020090ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000020090ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000020510ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f58ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001f128ULL, 0x000000000001f128ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000020080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000020510ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_80_cubin_len = 132592;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
