/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001d690ULL, 0x000000000001d210ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001b720ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001b890ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000001b8d0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000001b910ULL,
0x00000000000000f0ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001ba00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001b72000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x006c600400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8c082880808a0828ULL, 0x2880809108288080ULL, 0x8096082880809308ULL, 0x0828808098082880ULL,
0x8080a1082880809dULL, 0xa308288080a20828ULL, 0x288080b008288080ULL, 0x808408288080dc08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080849200ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001b72000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808a0828808081ULL, 0x91082880808c0828ULL, 0x2880809308288080ULL,
0x8098082880809608ULL, 0x082880809d082880ULL, 0x8080a208288080a1ULL, 0xb008288080a30828ULL,
0x288080dc08288080ULL, 0x8280162880808808ULL, 0x0000000003102880ULL, 0x8080889200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000012000000000ULL, 0x0001b89000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8c082880808a0828ULL, 0x2880809108288080ULL, 0x8096082880809308ULL, 0x0828808098082880ULL,
0x8080a1082880809dULL, 0xa308288080a20828ULL, 0x288080b008288080ULL, 0x828016288080dc08ULL,
0x0000000003102880ULL, 0x8080dc9200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x000001d000000000ULL, 0x0001b8d000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c082880808a0828ULL, 0x2880809108288080ULL,
0x8096082880809308ULL, 0x0828808098082880ULL, 0x8080a1082880809dULL, 0xa308288080a20828ULL,
0x288080dc08288080ULL, 0x828016288080b008ULL, 0x0000000003102880ULL, 0x8080b09200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL, 0x0001b91000000000ULL,
0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL, 0x00081204000000a8ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL,
0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x001c310400ff1b03ULL,
0x00019c2000000020ULL, 0x00019e7000019e60ULL, 0x00019ff000019fe0ULL, 0x01c829040001a000ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500006a0500006aULL, 0x0500006a0500006aULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000d001c82804ULL, 0x000017f0000000f0ULL, 0x0000191000001870ULL,
0x00001d3000001940ULL, 0x00001dd000001d60ULL, 0x00003d2000001e40ULL, 0x00003da000003d40ULL,
0x00005c8000003e00ULL, 0x00005db000005d00ULL, 0x0000619000005ed0ULL, 0x00006210000061b0ULL,
0x00007ef000006270ULL, 0x00007f7000007f10ULL, 0x00009dd000007fd0ULL, 0x00009f0000009e50ULL,
0x0000a2e00000a020ULL, 0x0000a3600000a300ULL, 0x0000c0400000a3c0ULL, 0x0000c0c00000c060ULL,
0x0000df200000c120ULL, 0x0000e0500000dfa0ULL, 0x0000e4300000e170ULL, 0x0000e4b00000e450ULL,
0x000101c00000e510ULL, 0x00010240000101e0ULL, 0x00011b70000102a0ULL, 0x0001230000011b80ULL,
0x00013f7000013e20ULL, 0x0001463000014600ULL, 0x0001988000014e70ULL, 0x000198c0000198b0ULL,
0x000198f0000198d0ULL, 0x0001993000019910ULL, 0x00019fd000019940ULL, 0x0001a0400001a030ULL,
0x0001a7600001a050ULL, 0x0001a8100001a7b0ULL, 0x0001a8d00001a870ULL, 0x0001a9a00001a940ULL,
0x0001aa600001aa10ULL, 0x0001ab100001aab0ULL, 0x0001abc00001ab70ULL, 0x0001ac900001ac30ULL,
0x0001ad500001ad00ULL, 0x0001ae000001ada0ULL, 0x0001aeb00001ae60ULL, 0x0001af800001af20ULL,
0x0001b0400001aff0ULL, 0x0001b0f00001b090ULL, 0x0001b1a00001b150ULL, 0x0001b2700001b210ULL,
0x0001b3400001b2e0ULL, 0x0001b3f00001b3a0ULL, 0x0001b4900001b440ULL, 0x0001b5300001b4e0ULL,
0x0001b5e00001b580ULL, 0x0001b6a00001b650ULL, 0x070039040001b6f0ULL, 0x000000ff000001e0ULL,
0x003f010000010600ULL, 0x0000000500000240ULL, 0x003f012000010608ULL, 0x00000005000002f0ULL,
0x003f012000010688ULL, 0x0000000500000390ULL, 0x003f0120000106a8ULL, 0x000000ff000003d0ULL,
0x003f0100000106b8ULL, 0x000000ff000004f0ULL, 0x003f010700010600ULL, 0x0000002700000690ULL,
0x003f01020001068cULL, 0x0000002700000740ULL, 0x003f010100010688ULL, 0x000000ff00000c70ULL,
0x003f0107000106a8ULL, 0x000000ff00000cf0ULL, 0x003f0101000106a8ULL, 0x000000ff00000d50ULL,
0x003f0101000106b8ULL, 0x000000ff00000ec0ULL, 0x003f0105000106bcULL, 0x000000ff00000f10ULL,
0x003f0105000106bcULL, 0x000000ff00000f90ULL, 0x003f0105000106bcULL, 0x000000ff00001560ULL,
0x003f0107000106b0ULL, 0x000000ff000015e0ULL, 0x003f0101000106b0ULL, 0x000000ff000015f0ULL,
0x003f0105000106acULL, 0x0000002700001660ULL, 0x003f010100010608ULL, 0x0000002700001680ULL,
0x003f01050001060cULL, 0x0000002700001710ULL, 0x003f01050001060cULL, 0x000000ff00001c10ULL,
0x003f0105000106acULL, 0x000000ff00001c90ULL, 0x003f0105000106acULL, 0x000000ff00003640ULL,
0x003f0101000106b8ULL, 0x000000ff00003650ULL, 0x003f0105000106bcULL, 0x000000ff000036a0ULL,
0x003f0105000106bcULL, 0x000000ff00003720ULL, 0x003f0105000106bcULL, 0x000000ff00003b20ULL,
0x003f0107000106a8ULL, 0x000000ff00003ba0ULL, 0x003f0101000106a8ULL, 0x000000ff00003bb0ULL,
0x003f0105000106b4ULL, 0x000000ff00003c10ULL, 0x003f0105000106b4ULL, 0x000000ff00003c90ULL,
0x003f0105000106b4ULL, 0x000000ff00005500ULL, 0x003f0101000106b8ULL, 0x000000ff00005570ULL,
0x003f010100010688ULL, 0x000000ff000055a0ULL, 0x003f0105000106bcULL, 0x000000ff000055f0ULL,
0x003f0105000106bcULL, 0x000000ff00005670ULL, 0x003f0105000106bcULL, 0x000000ff00005a40ULL,
0x003f0107000106b0ULL, 0x000000ff00005ac0ULL, 0x003f0101000106b0ULL, 0x000000ff00005ad0ULL,
0x003f0105000106acULL, 0x0000002700005b40ULL, 0x003f010100010628ULL, 0x0000002700005b60ULL,
0x003f01050001062cULL, 0x0000002700005bf0ULL, 0x003f01050001062cULL, 0x000000ff00006080ULL,
0x003f0105000106acULL, 0x000000ff00006100ULL, 0x003f0105000106acULL, 0x000000ff00007900ULL,
0x003f0101000106b8ULL, 0x000000ff00007910ULL, 0x003f0105000106bcULL, 0x000000ff00007960ULL,
0x003f0105000106bcULL, 0x000000ff000079e0ULL, 0x003f0105000106bcULL, 0x000000ff00007cf0ULL,
0x003f0107000106a8ULL, 0x000000ff00007d70ULL, 0x003f0101000106a8ULL, 0x000000ff00007d80ULL,
0x003f0105000106b4ULL, 0x000000ff00007de0ULL, 0x003f0105000106b4ULL, 0x000000ff00007e60ULL,
0x003f0105000106b4ULL, 0x000000ff00009650ULL, 0x003f0101000106b8ULL, 0x000000ff000096c0ULL,
0x003f010100010690ULL, 0x000000ff000096f0ULL, 0x003f0105000106bcULL, 0x000000ff00009740ULL,
0x003f0105000106bcULL, 0x000000ff000097c0ULL, 0x003f0105000106bcULL, 0x000000ff00009b90ULL,
0x003f0107000106b0ULL, 0x000000ff00009c10ULL, 0x003f0101000106b0ULL, 0x000000ff00009c20ULL,
0x003f0105000106acULL, 0x0000002700009c90ULL, 0x003f010100010648ULL, 0x0000002700009cb0ULL,
0x003f01050001064cULL, 0x0000002700009d40ULL, 0x003f01050001064cULL, 0x000000ff0000a1d0ULL,
0x003f0105000106acULL, 0x000000ff0000a250ULL, 0x003f0105000106acULL, 0x000000ff0000ba50ULL,
0x003f0101000106b8ULL, 0x000000ff0000ba60ULL, 0x003f0105000106bcULL, 0x000000ff0000bab0ULL,
0x003f0105000106bcULL, 0x000000ff0000bb30ULL, 0x003f0105000106bcULL, 0x000000ff0000be40ULL,
0x003f0107000106a8ULL, 0x000000ff0000bec0ULL, 0x003f0101000106a8ULL, 0x000000ff0000bed0ULL,
0x003f0105000106b4ULL, 0x000000ff0000bf30ULL, 0x003f0105000106b4ULL, 0x000000ff0000bfb0ULL,
0x003f0105000106b4ULL, 0x000000ff0000d7a0ULL, 0x003f0101000106b8ULL, 0x000000ff0000d810ULL,
0x003f010100010698ULL, 0x000000ff0000d840ULL, 0x003f0105000106bcULL, 0x000000ff0000d890ULL,
0x003f0105000106bcULL, 0x000000ff0000d910ULL, 0x003f0105000106bcULL, 0x000000ff0000dce0ULL,
0x003f0107000106b0ULL, 0x000000ff0000dd60ULL, 0x003f0101000106b0ULL, 0x000000ff0000dd70ULL,
0x003f0105000106acULL, 0x000000270000dde0ULL, 0x003f010100010668ULL, 0x000000270000de00ULL,
0x003f01050001066cULL, 0x000000270000de90ULL, 0x003f01050001066cULL, 0x000000ff0000e320ULL,
0x003f0105000106acULL, 0x000000ff0000e3a0ULL, 0x003f0105000106acULL, 0x000000ff0000fba0ULL,
0x003f0101000106b8ULL, 0x000000ff0000fbb0ULL, 0x003f0105000106bcULL, 0x000000ff0000fc00ULL,
0x003f0105000106bcULL, 0x000000ff0000fc80ULL, 0x003f0105000106bcULL, 0x000000ff0000ffc0ULL,
0x003f0107000106a8ULL, 0x000000ff00010040ULL, 0x003f0101000106a8ULL, 0x000000ff00010050ULL,
0x003f0105000106b4ULL, 0x000000ff000100b0ULL, 0x003f0105000106b4ULL, 0x000000ff00010130ULL,
0x003f0105000106b4ULL, 0x000000ff00011920ULL, 0x003f0101000106b8ULL, 0x000000ff00011980ULL,
0x003f0101000106a0ULL, 0x000000ff000151b0ULL, 0x003f010100010600ULL, 0x000000ff00015fb0ULL,
0x003f010500010604ULL, 0x000000ff00016050ULL, 0x003f010500010604ULL, 0x000000ff00016370ULL,
0x003f010100010600ULL, 0x000000ff00016380ULL, 0x003f010500010604ULL, 0x000000ff00016410ULL,
0x003f010500010604ULL, 0x0000003500018d60ULL, 0x003f010100000000ULL, 0x0000003500018da0ULL,
0x003f010500000004ULL, 0x0000003500019180ULL, 0x003f010500000004ULL, 0x000000370001a5c0ULL,
0x003f010100000000ULL, 0x000000370001a620ULL, 0x003f010100000008ULL, 0x000000370001a680ULL,
0x003f010100000010ULL, 0x000000370001a6f0ULL, 0x003f010100000018ULL, 0x00101c0400053803ULL,
0x00016470000150c0ULL, 0x0001a73000016520ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000031cULL, 0x0000001200000002ULL, 0x000000000000026cULL, 0x0000001200000002ULL,
0x00000000000001bcULL, 0x0000001200000002ULL, 0x000000000000010cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x00000000000002f4ULL, 0x0000001200000002ULL,
0x0000000000000244ULL, 0x0000001200000002ULL, 0x0000000000000194ULL, 0x0000001200000002ULL,
0x00000000000000e9ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000027919ULL, 0x000ea20000002300ULL, 0x0000000304057899ULL, 0x000fe4000800063fULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x0000000000077919ULL, 0x000f280000000000ULL, 0x00000000005b7919ULL, 0x000f680000002600ULL,
0x0000000000047919ULL, 0x000f220000002700ULL, 0x00000005ff2e7819ULL, 0x002fc60000011605ULL,
0x00000000002d7919ULL, 0x000e680000000000ULL, 0x00001fff020f7589ULL, 0x0045e200000e0000ULL,
0x0000000102007824ULL, 0x008fc600078e0203ULL, 0x00001fff2e2e7589ULL, 0x000ee200000e0000ULL,
0x0000008000057824ULL, 0x000fe400078e0205ULL, 0x0000001300007300ULL, 0x000f2600000e0000ULL,
0x000000ff0500720cULL, 0x040fe40003f25270ULL, 0x0000000f0500780cULL, 0x040fe40003f44070ULL,
0x0000007f0500780cULL, 0x040fe20003f84070ULL, 0x0000001300137309ULL, 0x000f620000000000ULL,
0x000000030500780cULL, 0x000fe20003f64070ULL, 0x000000102d0e7824ULL, 0x002fe200078e00ffULL,
0x000000070000720cULL, 0x010fca0003f02070ULL, 0x3fffff80ff029424ULL, 0x004fe400078e00ffULL,
0x000000040f007824ULL, 0x008fe400078e022eULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x0000000200007824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL,
0x01060002ff009388ULL, 0x0003e20000000a00ULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x00000008000b7817ULL, 0x040fe20007800000ULL, 0xff317217ff0cc424ULL, 0x000fe200078e00ffULL,
0x0000000100107810ULL, 0x000fe20007ffe0ffULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x010608060500a388ULL, 0x0005e20000008a00ULL, 0x000000010500780cULL, 0x000fe20003f44070ULL,
0x000000010b0a7824ULL, 0x100fe200078e0a00ULL, 0x0000000710127812ULL, 0x000fe200078ec0ffULL,
0x000000085b0b7824ULL, 0x020fe200078e00ffULL, 0x0000000700027812ULL, 0x002fe200078ec0ffULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x0104000c0500c388ULL, 0x0003e20000004800ULL,
0x00000005040b7c24ULL, 0x000fe2000f8e020bULL, 0x0000001f02037812ULL, 0x100fe200078e782dULL,
0x7fffff80ff0d9424ULL, 0x000fe200078e00ffULL, 0x010688080500b388ULL, 0x0007e20000008a00ULL,
0x000000ff0a00720cULL, 0x040fe20003f63070ULL, 0x000000010b027824ULL, 0x040fe200078e0200ULL,
0x000000010a00780cULL, 0x000fe20003f83070ULL, 0x000000010b067824ULL, 0x004fe200078e0210ULL,
0x0000001f12117812ULL, 0x000fe200078e782dULL, 0x3fffff00ff0aa424ULL, 0x000fc400078e00ffULL,
0x7fffff00ff0ba424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0c9424ULL, 0x002fe400078e00ffULL,
0x00000200ff077424ULL, 0x000fe200078e00ffULL, 0x0106a80a0500a388ULL, 0x0003e20000008a00ULL,
0x0000002000007824ULL, 0x000fe200078e0203ULL, 0x000001f00e097812ULL, 0x008fe200078ec0ffULL,
0x00005c0002027625ULL, 0x080fe200078e0007ULL, 0x0106b80cff009388ULL, 0x0005e60000000a00ULL,
0x00005c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000902087210ULL, 0x000fc40007fbe0ffULL, 0x0000002010107824ULL, 0x000fe200078e0211ULL,
0x0000000906067210ULL, 0x000fe20007f5e0ffULL, 0x0000001000117824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe400028e0603ULL, 0x000000ffff007224ULL, 0x000fe400078e0a13ULL,
0x000000ffff077224ULL, 0x000fe400010e0607ULL, 0x0000001010137824ULL, 0x000fc400078e00ffULL,
0x00000004ff057424ULL, 0x002fc800078e00ffULL, 0x0000620004027625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0005e8000d901c46ULL,
0x0000000006137faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01060400ffff038cULL, 0x0005e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006022c7981ULL, 0x000ee2000c1e1900ULL,
0x00000000000579c3ULL, 0x000e620000002500ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x00000005ff2b7e24ULL, 0x002fe2000f8e00ffULL, 0x0000003f2c2a7810ULL, 0x008fc40007ffe0ffULL,
0x000000ff2c297810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff2a7819ULL, 0x000fe4000001162aULL,
0x00000008ff297819ULL, 0x000fca0000011629ULL, 0x00014ad000008947ULL, 0x000fea0003800000ULL,
0x000000042b287824ULL, 0x000fe400078e00ffULL, 0x000000082e277824ULL, 0x000fe400078e00ffULL,
0x00000003ff067424ULL, 0x004fe200078e00ffULL, 0x0000002a2800720cULL, 0x000fe20003f06070ULL,
0xffffffffff267424ULL, 0x000fd800078e00ffULL, 0x0000640028038a10ULL, 0x000fe20007ffe0ffULL,
0x0000000204008824ULL, 0x000fc800078e00ffULL, 0x0000640000038a24ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c0627ff738cULL, 0x0003e20000000000ULL,
0x0000600003028625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000602268981ULL, 0x0004e2000c1e1900ULL, 0x00000004ff067819ULL, 0x002fe2000001162dULL,
0x000001002b057824ULL, 0x040fe200078e00ffULL, 0x000000012b007810ULL, 0x000fe20007ffe0ffULL,
0x0106880027ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000206077810ULL, 0x040fe20007ffe0ffULL,
0xff317217ff257424ULL, 0x000fe200078e00ffULL, 0x00000004060b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000000290000720cULL, 0x000fe20003f06070ULL,
0x0000000127087824ULL, 0x040fe200078e0207ULL, 0x000000052c007217ULL, 0x000fe20007800000ULL,
0x00000001270c7824ULL, 0x040fe200078e020bULL, 0x00000006060d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x00000007080a7812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x000000070c027812ULL, 0x004fe200078ec0ffULL,
0x0000000127057824ULL, 0x040fe200078e020dULL, 0x0000000f0a037812ULL, 0x000fe200078e782dULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x000000f00e117812ULL, 0x000fe200078ec0ffULL,
0x0000001008097824ULL, 0x000fe200078e0203ULL, 0x0000000f02037812ULL, 0x000fe200078e782dULL,
0x0000000127087824ULL, 0x000fe200078e0206ULL, 0x0000000705027812ULL, 0x000fe200078ec0ffULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000100c0c7824ULL, 0x000fe200078e0203ULL, 0x00000007080a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000f02107812ULL, 0x100fe200078e782dULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000f0a037812ULL, 0x000fe200078e782dULL,
0x000000ffff457224ULL, 0x000fe200078e00ffULL, 0x0000000027027217ULL, 0x000fe20007800000ULL,
0x0000001005107824ULL, 0x000fc400078e0210ULL, 0x0000001008057824ULL, 0x000fe400078e0203ULL,
0x0000000102027824ULL, 0x000fe400078e0a27ULL, 0x000000405b037824ULL, 0x000fe200078e0208ULL,
0x0000c00005057811ULL, 0x000fe400078e20ffULL, 0x000000020700720cULL, 0x080fe40003f46070ULL,
0x0000000203077810ULL, 0x000fe40007ffe0ffULL, 0x000000020b00720cULL, 0x000fc40003f06070ULL,
0x00000004030b7810ULL, 0x000fe40007ffe0ffULL, 0x000000020600720cULL, 0x000fe20003f26070ULL,
0x0000580026007a24ULL, 0x008fc800078e02ffULL, 0x0000004000007824ULL, 0x000fca00078e00ffULL,
0x0000000300137210ULL, 0x040fe40007f7e0ffULL, 0x00000007000f7210ULL, 0x000fe40007f9e0ffULL,
0x0000000603037810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078640ffULL, 0x000000ffff067224ULL, 0x000fe200020e06ffULL,
0x00005e000f077a11ULL, 0x000fe400078840ffULL, 0x00005f0013137a11ULL, 0x000fc400018f4408ULL,
0x0000000b000b7210ULL, 0x040fe40007f7e0ffULL, 0x0000000300007210ULL, 0x000fe40007fbe0ffULL,
0x00005f000f0f7a11ULL, 0x000fe200020f4406ULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x00005e000b087a11ULL, 0x000fe200078840ffULL, 0x000000ffff037224ULL, 0x000fe200028e06ffULL,
0x00005e00000a7a11ULL, 0x000fe400078a40ffULL, 0x000000020d00720cULL, 0x000fc40003f66070ULL,
0x00005f000b0b7a11ULL, 0x000fe400020f4406ULL, 0x0000001211027210ULL, 0x000fe40007f9e0ffULL,
0x00005f0000007a11ULL, 0x000fe400028f4403ULL, 0x0000001107067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff037224ULL, 0x000fe200020e0613ULL, 0x0000001108087210ULL, 0x080fe40007f9e0ffULL,
0x0000c000090d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200028e060fULL,
0x000000110a0a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200020e060bULL,
0x0000c0000c0f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c901c46ULL, 0x0000c00010117811ULL, 0x000fe200078e20ffULL,
0x000000ffff0b7224ULL, 0x000fc400028e0600ULL, 0x00000000060d7faeULL, 0x0003e8000d101c46ULL,
0x00000000080f7faeULL, 0x0003e2000c101c46ULL, 0x000000292b00720cULL, 0x000fc60003f06070ULL,
0x000000000a117faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff027f8cULL, 0x002e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00010be000000947ULL, 0x000fea0003800000ULL,
0x000000042e587824ULL, 0x000fe400078e00ffULL, 0x0000000204047824ULL, 0x000fc400078e00ffULL,
0x00006400ff237624ULL, 0x000fe200078e00ffULL, 0x0000000258597810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5a7224ULL, 0x002fe400078e0003ULL, 0x000000ffff317224ULL, 0x004fe400078e0007ULL,
0x0000640004237624ULL, 0x000fe400078e0223ULL, 0xff317217ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc400078e00ffULL, 0x000001002b037824ULL, 0x000fca00078e00ffULL,
0x0000002c0300720cULL, 0x000fda0003f06070ULL, 0x00010ae000000947ULL, 0x002fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0000000328027812ULL, 0x000fe200078ec0ffULL,
0x00000300ff007624ULL, 0x000fe400078e00ffULL, 0x0000580026047a24ULL, 0x000fe200078e02ffULL,
0x000000030200780cULL, 0x000fe20003f05270ULL, 0xfffffffd05007424ULL, 0x000fe200078e0200ULL,
0x00000004ff067819ULL, 0x000fe2000001162dULL, 0xffffffffff267424ULL, 0x000fc600078e00ffULL,
0x0000000100037807ULL, 0x000fca0004000000ULL, 0x0000000128287824ULL, 0x000fca00078e0203ULL,
0x0000002a2800720cULL, 0x000fe20003f06070ULL, 0x0000000127677824ULL, 0x000fe200078e0206ULL,
0x000000205b1c7811ULL, 0x000fe200078e30ffULL, 0x00000040040b7824ULL, 0x000fc600078e00ffULL,
0x0000000767087812ULL, 0x040fe200078ec0ffULL, 0x0000000167227824ULL, 0x000fcc00078e021cULL,
0x0000000128028824ULL, 0x000fc800078e0223ULL, 0x0000600002028625ULL, 0x000fe200078e0005ULL,
0x0000000f08087812ULL, 0x000fe400078e782dULL, 0x0000000406207810ULL, 0x000fe40007ffe0ffULL,
0x0000000602268981ULL, 0x000362000c1e1900ULL, 0x000000012b007810ULL, 0x000fe20007ffe0ffULL,
0x0000001067677824ULL, 0x000fe200078e0208ULL, 0x000000202b057811ULL, 0x000fe200078e40ffULL,
0x00000001271d7824ULL, 0x000fe200078e0220ULL, 0x000000290000720cULL, 0x000fe20003f06070ULL,
0x000000102d167824ULL, 0x000fe200078e00ffULL, 0x000000052c007217ULL, 0x000fc40007800000ULL,
0x0000000206217810ULL, 0x000fe40007ffe0ffULL, 0x000000220b037210ULL, 0x002fe20007f3e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x00000006061f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127057824ULL, 0x000fe200078e0221ULL, 0x000000f0161b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e0003087a11ULL, 0x000fe200078240ffULL,
0x00000001273d7824ULL, 0x000fe200078e021fULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x00000001051e7824ULL, 0x000fe200078e021cULL, 0x00005f0003037a11ULL, 0x000fc400008f4402ULL,
0x000000071d027812ULL, 0x000fe400078ec0ffULL, 0x0000000705047812ULL, 0x000fe400078ec0ffULL,
0x0000000f02027812ULL, 0x100fe400078e782dULL, 0x000000073d0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000027007217ULL, 0x000fe20007800000ULL, 0x000000101d3f7824ULL, 0x040fe200078e0202ULL,
0x0000000f04047812ULL, 0x100fe200078e782dULL, 0x000000011d1d7824ULL, 0x000fe200078e021cULL,
0x0000000f0a0a7812ULL, 0x000fe200078e782dULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000001e0b097210ULL, 0x000fe20007f5e0ffULL, 0x0000001005637824ULL, 0x000fe200078e0204ULL,
0x0000001d0b077210ULL, 0x000fe20007f7e0ffULL, 0x000000013d1c7824ULL, 0x040fe200078e021cULL,
0x000000000600720cULL, 0x000fe20003f26070ULL, 0x000000103d3d7824ULL, 0x000fe200078e020aULL,
0x0000e000671a7811ULL, 0x000fe200078e20ffULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x00005e00090a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff027224ULL, 0x000fe200018e06ffULL,
0x00005e0007067a11ULL, 0x000fc400078640ffULL, 0x00005f0009097a11ULL, 0x000fe400010f4404ULL,
0x0000001c0b047210ULL, 0x000fe40007f9e0ffULL, 0x00005f0007077a11ULL, 0x000fe400018f4402ULL,
0x0000001b08027210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff057224ULL, 0x000fe200020e06ffULL,
0x00005e0004087a11ULL, 0x000fe400078a40ffULL, 0x000000002000720cULL, 0x080fe20003f66070ULL,
0x000000ffff037224ULL, 0x000fe200010e0603ULL, 0x000000002100720cULL, 0x000fc40003f46070ULL,
0x000000001f00720cULL, 0x000fe40003f86070ULL, 0x00005f0004007a11ULL, 0x000fe200028f4405ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000021a7faeULL, 0x0003e2000c901c46ULL,
0x0000001b0a047210ULL, 0x080fe40007fbe0ffULL, 0x0000001b06067210ULL, 0x080fe40007f3e0ffULL,
0x0000e00063197811ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200028e0609ULL,
0x0000001b08087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000e0003f187811ULL, 0x000fc400078e20ffULL, 0x0000e0003d177811ULL, 0x000fe200078e20ffULL,
0x000000ffff097224ULL, 0x000fe200028e0600ULL, 0x0000000004197faeULL, 0x0003e8000d101c46ULL,
0x0000000006187faeULL, 0x0003e8000d901c46ULL, 0x0000000008177faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff027f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff077984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106080027047f8cULL, 0x000fe2000c80043fULL, 0x8000000007ff7812ULL, 0x004fc6000784485aULL,
0x01060c0027097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007824805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000060000735dULL, 0x008fe20003800000ULL, 0x01060c0027077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fc40007824805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff007819ULL, 0x000fe2000001162dULL, 0xffffffffff647424ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fe400078ec0ffULL, 0x0000000c00057812ULL, 0x000fca00078ec0ffULL,
0x0000000116167824ULL, 0x000fca00078e0205ULL, 0x0100000016007984ULL, 0x000ea80000000800ULL,
0x0102000016047984ULL, 0x0007220000000800ULL, 0x000000250000720bULL, 0x004fe20003f3d000ULL,
0x00018f527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000057806ULL, 0x008fc800008e0100ULL,
0x0000ffff05077812ULL, 0x000fe2000782c0ffULL, 0x000003c000007945ULL, 0x000fe20003800000ULL,
0x00000001ff057424ULL, 0x000fd600078e00ffULL, 0x0000039000009947ULL, 0x000fea0003800000ULL,
0x000000ff2e00720cULL, 0x000fe40003f65270ULL, 0x000000250000720bULL, 0x000fe20003f34000ULL,
0x00018f227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000057806ULL, 0x000fe400008e0100ULL,
0x0000000025097209ULL, 0x000fe40007810000ULL, 0x0000ffff05087812ULL, 0x000fe400078e3cffULL,
0x00000002ff6c7819ULL, 0x000fe2000001162dULL, 0x010400091600b388ULL, 0x0005e20000000800ULL,
0x8000000925067221ULL, 0x000fe20000010000ULL, 0x0000000807ff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL, 0x00000006005f7308ULL, 0x0004e20000000800ULL,
0x00018ed27f007947ULL, 0x000fea000b800000ULL, 0x00001f6c5f057589ULL, 0x0086a400000e0000ULL,
0x000000086c6c7810ULL, 0x00afe20007ffe0ffULL, 0x00018f027f007947ULL, 0x000fea000b800000ULL,
0x00001f6c5f5e7589ULL, 0x0002e400000e0000ULL, 0x8000000900001221ULL, 0x100fe20000010000ULL,
0x0000000539397220ULL, 0x084fe20000410000ULL, 0x0000000538387220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00001820ULL, 0x000fe20000410000ULL,
0x0000000534347220ULL, 0x080fe20000410000ULL, 0x0000000541417220ULL, 0x080fe20000410000ULL,
0x0000000540407220ULL, 0x080fe20000410000ULL, 0x0000000000151308ULL, 0x0004620000000800ULL,
0x0000000545457220ULL, 0x080fe20000410000ULL, 0x0000000544447220ULL, 0x080fe20000410000ULL,
0x0000000549497220ULL, 0x080fe20000410000ULL, 0x0000000548487220ULL, 0x080fe20000410000ULL,
0x000000054d4d7220ULL, 0x080fe20000410000ULL, 0x000000054c4c7220ULL, 0x080fe20000410000ULL,
0x0000000551517220ULL, 0x080fe20000410000ULL, 0x0000000550507220ULL, 0x080fe20000410000ULL,
0x00000001ff007807ULL, 0x004fe20000800000ULL, 0x0000000555557220ULL, 0x080fe20000410000ULL,
0x0000000554547220ULL, 0x000fe20000410000ULL, 0x0000005f24247220ULL, 0x000fe20000410000ULL,
0x0000005e3b3b7220ULL, 0x088fe20000410000ULL, 0x0000005e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000005e37377220ULL, 0x080fe20000410000ULL, 0x0000005e36367220ULL, 0x080fe20000410000ULL,
0x0000005e43437220ULL, 0x080fe20000410000ULL, 0x0000005e42427220ULL, 0x080fe20000410000ULL,
0x0000005e47477220ULL, 0x080fe20000410000ULL, 0x0000005e46467220ULL, 0x080fe20000410000ULL,
0x0000005e4b4b7220ULL, 0x080fe20000410000ULL, 0x0000005e4a4a7220ULL, 0x080fe20000410000ULL,
0x0000005e4f4f7220ULL, 0x080fe20000410000ULL, 0x0000005e4e4e7220ULL, 0x080fe20000410000ULL,
0x0000005e53537220ULL, 0x080fe20000410000ULL, 0x0000005e52527220ULL, 0x080fe20000410000ULL,
0x0000005e57577220ULL, 0x080fe20000410000ULL, 0x0000005e56567220ULL, 0x000fe20000410000ULL,
0x000000ffff257224ULL, 0x000fe200078e0009ULL, 0x0000761000057816ULL, 0x000fe20000000005ULL,
0x0000001504041220ULL, 0x012fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002404247221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fc4000782485aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000040000735dULL, 0x008fe20003800000ULL, 0x0106ac00ff077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe4000782485aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff00723eULL, 0x000fe400000010ffULL, 0x00000004ff897819ULL, 0x000fc4000001162dULL,
0x00000002ff047819ULL, 0x000fe4000001162dULL, 0x00005410005f7816ULL, 0x000fe20000000000ULL,
0x00018b627f007947ULL, 0x000fea000b800000ULL, 0x00001f045f697589ULL, 0x0004e400000e0000ULL,
0x00000008042f7810ULL, 0x000fe20007ffe0ffULL, 0x00018ba27f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5f007589ULL, 0x0008a400000e0000ULL, 0x0000001004667810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0066ULL,
0x00001de0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00019af000007944ULL, 0x03cfea0003c00000ULL,
0x0000001804657810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0065ULL, 0x00001e50005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00019a8000007944ULL, 0x03cfea0003c00000ULL, 0x000000082d047812ULL, 0x044fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000582d067211ULL, 0x000fe400078fe0ffULL,
0x0000000704077812ULL, 0x140fe400078ec82dULL, 0x0000000704047812ULL, 0x000fe400078ef82dULL,
0x0000000607617212ULL, 0x000fe400078e3cffULL, 0x000000592d067211ULL, 0x000fc400078fe0ffULL,
0x0000991005057816ULL, 0x000fe200000000ffULL, 0x00000010043e7824ULL, 0x000fe200078e0261ULL,
0x0000000607077212ULL, 0x000fc800078e3cffULL, 0x0000c0003e147811ULL, 0x000fe200078e20ffULL,
0x00000010043c7824ULL, 0x040fe200078e0207ULL, 0x0000010004047811ULL, 0x000fc600078e20ffULL,
0x000000001430783bULL, 0x000ea20000004200ULL, 0x0000c0003c137811ULL, 0x000fe200078e20ffULL,
0x0000000107607824ULL, 0x100fe400078e0204ULL, 0x0000000161617824ULL, 0x000fe400078e0204ULL,
0x000000ffff047224ULL, 0x000fe200078e0005ULL, 0x0000c00060117811ULL, 0x000fe200078e20ffULL,
0x00000000130c783bULL, 0x000f220000004200ULL, 0x0000c00061127811ULL, 0x000fe400078e20ffULL,
0x000000ff0400720cULL, 0x000fc40003f25270ULL, 0x000000001104783bULL, 0x000ee80000004200ULL,
0x000000001208783bULL, 0x000e620000004200ULL, 0x00000010ff907819ULL, 0x104fe40000011632ULL,
0x000000ff326b7812ULL, 0x042fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011632ULL,
0x0000ffff329f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8c7819ULL, 0x110fe4000001160eULL,
0x000000ff0e747812ULL, 0x040fe400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe4000001160eULL,
0x0000ffff0e8a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x000fe4000001160fULL,
0x000000ff0f757812ULL, 0x000fc400078ec0ffULL, 0x00000018ff0e7819ULL, 0x000fe4000001160fULL,
0x0000ffff0f887812ULL, 0x000fe400078ec0ffULL, 0x000000ff31687812ULL, 0x000fe400078ec0ffULL,
0x00000010ff327819ULL, 0x108fe40000011604ULL, 0x000000ff04997812ULL, 0x000fe400078ec0ffULL,
0x00000018ff987819ULL, 0x000fc40000011604ULL, 0x0000ffff040f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff047819ULL, 0x000fe40000011605ULL, 0x000000ff0d727812ULL, 0x000fe400078ec0ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000004ff04723eULL, 0x000fe400020006ffULL,
0x00000010ff947819ULL, 0x100fe2000001160cULL, 0x20000068ff877230ULL, 0x000fe20000004100ULL,
0x000000ff0c6f7812ULL, 0x000fe200078ec0ffULL, 0x20000004ff687230ULL, 0x000fe20000004100ULL,
0x00000018ff6e7819ULL, 0x000fc4000001160cULL, 0x0000ffff0c8d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff309d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff967819ULL, 0x100fe4000001160dULL,
0x00000018ff0c7819ULL, 0x000fe4000001160dULL, 0x0000ffff0d8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7e7819ULL, 0x000fc40000011605ULL, 0x000000ff059a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff05707812ULL, 0x000fe400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x100fe40000011606ULL, 0x000000ff069b7812ULL, 0x000fe200078ec0ffULL,
0x20000072ff7d7230ULL, 0x000fe20000004100ULL, 0x00000018ff057819ULL, 0x000fc40000011606ULL,
0x0000ffff060d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe40000011631ULL,
0x000000ff08787812ULL, 0x000fe400078ec0ffULL, 0x00000018ff067819ULL, 0x000fe40000011607ULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x00000010ff107819ULL, 0x100fe40000011630ULL, 0x000000ff305d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011630ULL, 0x00000010ff857819ULL, 0x100fe40000011609ULL,
0x000000ff09937812ULL, 0x000fe400078ec0ffULL, 0x00000018ff927819ULL, 0x000fc40000011609ULL,
0x0000ffff09827812ULL, 0x000fe400078ec0ffULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x00000008ff047819ULL, 0x000fe4000001169dULL, 0x00000010ff307819ULL, 0x100fe4000001160aULL,
0x000000ff0a957812ULL, 0x000fe400078ec0ffULL, 0x00000018ff097819ULL, 0x000fc4000001160aULL,
0x0000ffff0a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x000fe40000011633ULL,
0x00000018ff0a7819ULL, 0x000fe4000001160bULL, 0x00000078ff72723eULL, 0x000fe200020006ffULL,
0x20000075ff787230ULL, 0x000fe20000004100ULL, 0x00000006ff06723eULL, 0x000fe200020006ffULL,
0x20000073ff757230ULL, 0x000fe20000004100ULL, 0x000000ff62627812ULL, 0x000fe200078ec0ffULL,
0x2000000eff737230ULL, 0x000fe20000004100ULL, 0x00000004ff04723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000000aff0e723eULL, 0x000fe200020006ffULL,
0x20000006ff0a7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x2000000eff0e7230ULL, 0x000fe20000004100ULL,
0x00000018ff6c7819ULL, 0x000fe40000011633ULL, 0x0000000cff0c723eULL, 0x000fe400020006ffULL,
0x000000ff90067812ULL, 0x000fe200078ec0ffULL, 0x20000004ff907230ULL, 0x000fe20000004100ULL,
0x00000009ff09723eULL, 0x000fe200020006ffULL, 0x2000000cff7b7230ULL, 0x000fe20000004100ULL,
0x00000005ff05723eULL, 0x000fc400020006ffULL, 0x00000091ff04723eULL, 0x000fe200020006ffULL,
0x20000062ff917230ULL, 0x000fe20000004100ULL, 0x0000ffff319e7812ULL, 0x000fe200078ec0ffULL,
0x20000009ff0c7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000005ff097230ULL, 0x000fe20000004100ULL, 0x000000072d627812ULL, 0x000fe400078ec0ffULL,
0x000000ff10107812ULL, 0x000fe200078ec0ffULL, 0x2000006cff777230ULL, 0x000fe20000004100ULL,
0x00000008ff057819ULL, 0x000fc4000001169eULL, 0x0000000862627812ULL, 0x000fe400078ef82dULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000095ff6c723eULL, 0x000fe200020006ffULL, 0x20000004ff957230ULL, 0x000fe20000004100ULL,
0x00000018ff8f7819ULL, 0x000fe20000011608ULL, 0x2000006eff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff10723eULL, 0x000fe200020006ffULL, 0x2000006fff7c7230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000005ff05723eULL, 0x000fc400020006ffULL, 0x00000008ff047819ULL, 0x000fe2000001169fULL,
0x20000074ff797230ULL, 0x000fe20000004100ULL, 0x0000000789897812ULL, 0x000fe400078e7862ULL,
0x0000ffff33a07812ULL, 0x040fe400078ec0ffULL, 0x00000006ff06723eULL, 0x000fe400020006ffULL,
0x0000008fff6e723eULL, 0x000fe200020006ffULL, 0x20000010ff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff336d7812ULL, 0x000fe200078ec0ffULL, 0x0000000862107824ULL, 0x000fe200078e0289ULL,
0x00000092ff6f723eULL, 0x000fe200020006ffULL, 0x20000005ff927230ULL, 0x000fe20000004100ULL,
0x000000ff94947812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000004ff04723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000093ff74723eULL, 0x000fe200020006ffULL, 0x20000006ff937230ULL, 0x000fe20000004100ULL,
0x00000008ff057819ULL, 0x000fc400000116a0ULL, 0x00000010ff867819ULL, 0x000fe20000011608ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x0000ffff08837812ULL, 0x000fe400078ec0ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000094ff06723eULL, 0x000fe200020006ffULL,
0x20000004ff947230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe20000011607ULL,
0x2000006dff7f7230ULL, 0x000fe20000004100ULL, 0x000000ff079c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff07087812ULL, 0x000fe400078ec0ffULL, 0x000000ff0b977812ULL, 0x000fe400078ec0ffULL,
0x00000005ff05723eULL, 0x000fe400020006ffULL, 0x000000ff96077812ULL, 0x000fe400078ec0ffULL,
0x0000a00010047811ULL, 0x000fe200078e20ffULL, 0x20000005ff967230ULL, 0x000fe20000004100ULL,
0x00000097ff6d723eULL, 0x000fe200020006ffULL, 0x20000006ff977230ULL, 0x000fe20000004100ULL,
0x00000007ff89723eULL, 0x000fc400020006ffULL, 0x000000000404783bULL, 0x000e620000000200ULL,
0x00000018ff5f7819ULL, 0x000fe20000011631ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff8a7819ULL, 0x000fe2000001168aULL,
0x2000005fff817230ULL, 0x000fe20000004100ULL, 0x00000098ff5f723eULL, 0x000fe200020006ffULL,
0x2000005dff847230ULL, 0x000fe20000004100ULL, 0x00000008ff987819ULL, 0x000fe2000001168eULL,
0x20000089ff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff8b897812ULL, 0x000fe200078ec0ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000008cff8b723eULL, 0x000fc400020006ffULL,
0x00000089ff8c723eULL, 0x000fe400020006ffULL, 0x00000010ff317819ULL, 0x000fe2000001160bULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000008aff89723eULL, 0x000fe200020006ffULL,
0x2000008cff8a7230ULL, 0x000fe20000004100ULL, 0x0000006bff33723eULL, 0x000fe400020006ffULL,
0x00000099ff6b723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000000ff308c7812ULL, 0x000fe200078ec0ffULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x000000ff31997812ULL, 0x000fe200078ec0ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fc40000011684ULL, 0x00000010ff317819ULL, 0x000fe40000011687ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff847819ULL, 0x000fe20000011691ULL,
0x0000006904049231ULL, 0x082fe200003400ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x0000006906069231ULL, 0x000fe200003400ffULL, 0x000010548f307816ULL, 0x000fe20000000030ULL,
0x0000000005059231ULL, 0x080fe200003400ffULL, 0x0000105484317816ULL, 0x000fe20000000031ULL,
0x0000000007079231ULL, 0x000fe200003400ffULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x2000005cff807230ULL, 0x000fe20000004100ULL, 0x000000ff7e877812ULL, 0x000fc400078ec0ffULL,
0x000000ff32327812ULL, 0x000fe200078ec0ffULL, 0x2000008cff847230ULL, 0x000fe20000004100ULL,
0x000000300454723cULL, 0x000fe20000041854ULL, 0x00000087ff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x000fe40000011681ULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff317819ULL, 0x000fe20000011680ULL, 0x2000008cff807230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fc40000011690ULL, 0x00000008ff0f7819ULL, 0x000fe4000001160fULL,
0x00000032ff32723eULL, 0x000fe400020006ffULL, 0x0000105431307816ULL, 0x000fe40000000030ULL,
0x0000105487317816ULL, 0x000fe20000000092ULL, 0x20000032ff817230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000000fff87723eULL, 0x000fc400020006ffULL,
0x00000007210f7812ULL, 0x000fe200078e7862ULL, 0x2000006aff767230ULL, 0x000fe20000004100ULL,
0x00000010ff327819ULL, 0x000fe20000011633ULL, 0x000000300450723cULL, 0x000fe20000041850ULL,
0x00000010ff337819ULL, 0x000fe2000001167fULL, 0x00000008620f7824ULL, 0x000fe200078e020fULL,
0x00000010ff937819ULL, 0x000fe20000011693ULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fe40000011695ULL, 0x0000105493327816ULL, 0x000fc40000000032ULL,
0x000010548c337816ULL, 0x000fe40000000033ULL, 0x00000010ff317819ULL, 0x000fe40000011676ULL,
0x00000010ff307819ULL, 0x000fe40000011677ULL, 0x00000010ff767819ULL, 0x000fe20000011694ULL,
0x00000032044c723cULL, 0x000fe2000004184cULL, 0x00000010ff777819ULL, 0x000fe40000011696ULL,
0x0000a0000f7f7811ULL, 0x000fc400078e20ffULL, 0x0000105431767816ULL, 0x000fe40000000076ULL,
0x0000105430777816ULL, 0x000fe40000000077ULL, 0x000000007f30783bULL, 0x000e620000000200ULL,
0x00000008ff8d7819ULL, 0x000fe4000001168dULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x00000008ff887819ULL, 0x000fe20000011688ULL, 0x000000760448723cULL, 0x000fe20000041848ULL,
0x00000008ff8c7819ULL, 0x000fe20000011670ULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x000000ff718f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff707819ULL, 0x000fe4000001167cULL,
0x00000010ff717819ULL, 0x000fe4000001167dULL, 0x00000010ff977819ULL, 0x000fe40000011697ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x0000105497707816ULL, 0x000fe20000000070ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x000010548e717816ULL, 0x000fe20000000071ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff767819ULL, 0x000fe4000001167bULL, 0x00000010ff7b7819ULL, 0x000fe20000011698ULL,
0x000000700444723cULL, 0x000fe20000041844ULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff8d7819ULL, 0x000fe2000001168dULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00001054767b7816ULL, 0x000fe2000000007bULL,
0x0000000031319231ULL, 0x082fe200003400ffULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x0000000033339231ULL, 0x000fe200003400ffULL, 0x00000010ff717819ULL, 0x000fe20000011678ULL,
0x0000006930309231ULL, 0x080fe200003400ffULL, 0x00000010ff707819ULL, 0x000fe2000001168bULL,
0x0000006932329231ULL, 0x000fe200003400ffULL, 0x00000010ff8a7819ULL, 0x000fc4000001168aULL,
0x00000010ff767819ULL, 0x000fe40000011675ULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff787819ULL, 0x000fe40000011673ULL, 0x00000010ff777819ULL, 0x000fe40000011688ULL,
0x0000ffff0b0b7812ULL, 0x000fe400078ec0ffULL, 0x000010547a7a7816ULL, 0x000fc4000000008dULL,
0x0000105470707816ULL, 0x000fe40000000079ULL, 0x000010548a717816ULL, 0x000fe40000000071ULL,
0x0000105476767816ULL, 0x000fe20000000089ULL, 0x0000007a0440723cULL, 0x000fe20000041840ULL,
0x0000105478777816ULL, 0x000fe40000000077ULL, 0x00000010ff007819ULL, 0x000fe4000001166fULL,
0x00000010ff6f7819ULL, 0x000fc40000011682ULL, 0x0000009aff6a723eULL, 0x000fe200020006ffULL,
0x000000700434723cULL, 0x040fe20000041834ULL, 0x00000008ff0b7819ULL, 0x000fe4000001160bULL,
0x00001054006f7816ULL, 0x000fe2000000006fULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff007819ULL, 0x000fe20000011681ULL,
0x000000760404723cULL, 0x000fe20000041838ULL, 0x0000000bff0b723eULL, 0x000fc400020006ffULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x000fe40000011684ULL, 0x0000105400387816ULL, 0x000fe2000000006bULL,
0x2000000bff007230ULL, 0x000fe20000004100ULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x00000008ff837819ULL, 0x000fc40000011683ULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00001054396c7816ULL, 0x000fe4000000006cULL,
0x00000008ff0d7819ULL, 0x000fe4000001160dULL, 0x00000010ff397819ULL, 0x000fe4000001166aULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000008ff0b7819ULL, 0x000fe40000011608ULL,
0x0000009cff5c723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000009bff5d723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x20000099ff7e7230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff3a7819ULL, 0x000fe2000001165fULL, 0x2000005eff697230ULL, 0x000fe20000004100ULL,
0x0000000dff0d723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x0000105480397816ULL, 0x000fc40000000039ULL, 0x0000000bff5f723eULL, 0x000fe200020006ffULL,
0x2000000dff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff737819ULL, 0x000fe20000011686ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000383044723cULL, 0x000fe20000041844ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x00000010ff397819ULL, 0x000fe4000001165cULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff3b7819ULL, 0x000fe4000001168cULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff087819ULL, 0x000fe4000001168fULL, 0x00000010ff5c7819ULL, 0x000fe40000011669ULL,
0x00000010ff0b7819ULL, 0x000fe4000001160cULL, 0x00000010ff5a7819ULL, 0x000fc4000001165aULL,
0x00000010ff0d7819ULL, 0x000fe4000001160eULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x00000010ff097819ULL, 0x000fe40000011609ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff0a7819ULL, 0x000fe4000001160aULL, 0x00000010ff5f7819ULL, 0x000fc4000001165fULL,
0x0000105473727816ULL, 0x000fe40000000072ULL, 0x0000105485737816ULL, 0x000fe40000000074ULL,
0x000010546e6e7816ULL, 0x000fe40000000083ULL, 0x000010547e6d7816ULL, 0x000fe4000000006dULL,
0x000010543a3a7816ULL, 0x000fe20000000087ULL, 0x000000723054723cULL, 0x000fe20000041854ULL,
0x00001054683b7816ULL, 0x000fc4000000003bULL, 0x0000105408387816ULL, 0x000fe4000000005dULL,
0x000010545c397816ULL, 0x000fe40000000039ULL, 0x000010540b0c7816ULL, 0x000fe2000000005aULL,
0x0000006e3050723cULL, 0x000fe20000041850ULL, 0x000010540d0d7816ULL, 0x000fe40000000000ULL,
0x00001054095e7816ULL, 0x000fe4000000005eULL, 0x000010540a5f7816ULL, 0x000fc6000000005fULL,
0x0000006c304c723cULL, 0x040ff0000004184cULL, 0x0000003a3040723cULL, 0x040ff00000041840ULL,
0x000000383034723cULL, 0x040ff00000041834ULL, 0x0000000c3048723cULL, 0x040ff00000041848ULL,
0x0000005e3030723cULL, 0x000fe20000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff047f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007844805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000402b057811ULL, 0x000fe200078e40ffULL,
0x0000580026007a24ULL, 0x020fe200078e02ffULL, 0x000000272d0e7211ULL, 0x040fe400078fe0ffULL,
0x000000052c047217ULL, 0x000fe20007800000ULL, 0x0000004000097824ULL, 0x000fe200078e00ffULL,
0x000000022d387811ULL, 0x000fe200078fe0ffULL, 0x000000405b0e7824ULL, 0x000fe200078e020eULL,
0x000000042d087811ULL, 0x000fe200078fe0ffULL, 0x0000000104047824ULL, 0x000fe400078e0a05ULL,
0x0000000127007824ULL, 0x000fe200078e0238ULL, 0x0000000e09067210ULL, 0x000fe20007f5e0ffULL,
0x00000001270c7824ULL, 0x000fe200078e0208ULL, 0x0000002004047807ULL, 0x000fe20000000000ULL,
0x000000405b0d7824ULL, 0x000fe200078e0200ULL, 0x000000062d007811ULL, 0x000fe200078fe0ffULL,
0x000000ffff057224ULL, 0x000fe200010e06ffULL, 0x00005e00060a7a11ULL, 0x000fe200078440ffULL,
0x000000405b0c7824ULL, 0x000fe200078e020cULL, 0x0000000427047217ULL, 0x000fc40007800000ULL,
0x00005f0006057a11ULL, 0x000fe400010f4405ULL, 0x0000000d09397210ULL, 0x040fe20007f5e0ffULL,
0x0000000104077824ULL, 0x000fe200078e0a27ULL, 0x00000004ff067819ULL, 0x000fe4000001162dULL,
0x0000000c093b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x00005e00395c7a11ULL, 0x000fe400078440ffULL, 0x000000070600720cULL, 0x000fe20003f66070ULL,
0x0000000127067824ULL, 0x000fe200078e0200ULL, 0x00005f0039397a11ULL, 0x000fe200010f4404ULL,
0x000000ffff5a7224ULL, 0x000fe200020e06ffULL, 0x0000001b0a047210ULL, 0x000fe20007f5e0ffULL,
0x000000405b0b7824ULL, 0x000fe200078e0206ULL, 0x0000c000670a7811ULL, 0x000fc400078e20ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078840ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000000b09067210ULL, 0x000fe40007fde0ffULL, 0x000000073800720cULL, 0x000fe40003f46070ULL,
0x0000001b5c387210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040a7faeULL, 0x0003e2000d901c46ULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe400020f445aULL, 0x00005e00065c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff397224ULL, 0x000fe200028e0639ULL, 0x000000070800720cULL, 0x000fc40003f86070ULL,
0x000000070000720cULL, 0x000fe40003fa6070ULL, 0x0000001b3a3a7210ULL, 0x080fe40007fde0ffULL,
0x00005f0006007a11ULL, 0x000fe400018f4409ULL, 0x0000001b5c5c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e063bULL, 0x0000c00063097811ULL, 0x000fe400078e20ffULL,
0x0000c0003f087811ULL, 0x000fe200078e20ffULL, 0x000000ffff5d7224ULL, 0x000fe200018e0600ULL,
0x0000c0003d077811ULL, 0x000fe200078e20ffULL, 0x0000000038097faeULL, 0x0003e8000d101c46ULL,
0x000000003a087faeULL, 0x0003e8000e101c46ULL, 0x000000005c077faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff047f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fc40007844803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e0005ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007844803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x0106b400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007844803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x000fe4000001162dULL,
0x00005410005f7816ULL, 0x000fe20000000000ULL, 0x00016c527f007947ULL, 0x000fea000b800000ULL,
0x00001f6c5f677589ULL, 0x0002a400000e0000ULL, 0x00016c927f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5f687589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0066ULL, 0x00003db0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00017b2000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0065ULL, 0x00003e10005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00017ac000007944ULL, 0x01cfea0003c00000ULL, 0x0000e0003c057811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0003e067811ULL, 0x000fe400078e20ffULL,
0x0000e00061047811ULL, 0x000fe200078e20ffULL, 0x00000000053c783bULL, 0x000f620000004200ULL,
0x0000000720617812ULL, 0x100fe400078e7862ULL, 0x000000071f637812ULL, 0x000fe200078e7862ULL,
0x00000000045c783bULL, 0x00ee620000004200ULL, 0x0000e00060037811ULL, 0x000fe200078e20ffULL,
0x0000000862027824ULL, 0x000fc400078e0261ULL, 0x000000000638783bULL, 0x000ea20000004200ULL,
0x0000000862007824ULL, 0x000fc600078e0263ULL, 0x000000000360783bULL, 0x000ee20000004200ULL,
0x000000ff3d777812ULL, 0x060fe400078ec0ffULL, 0x00000010ff9a7819ULL, 0x100fe4000001163dULL,
0x00000018ff757819ULL, 0x000fe4000001163dULL, 0x0000ffff3d907812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f7b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x000fc4000001163eULL,
0x000000ff3e797812ULL, 0x040fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe4000001163eULL,
0x0000ffff3e8d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001163fULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x000000ff5c7c7812ULL, 0x002fc400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x20000077ff7f7230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000010ff8e7819ULL, 0x004fe40000011638ULL,
0x00000010ff987819ULL, 0x100fe4000001163cULL, 0x000000ff3c747812ULL, 0x000fe400078ec0ffULL,
0x00000018ff737819ULL, 0x000fc4000001163cULL, 0x0000ffff3ca47812ULL, 0x000fe400078ec0ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f8f7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff38a07812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3f7819ULL, 0x000fc4000001165cULL, 0x0000007cff77723eULL, 0x000fe200020006ffULL,
0x2000007bff7c7230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL,
0x20000078ff7b7230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x2000003eff787230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x20000074ff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff3e7819ULL, 0x000fe200000116a0ULL,
0x20000075ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe20000011639ULL,
0x2000003fff747230ULL, 0x000fe20000004100ULL, 0x0000ffff39a17812ULL, 0x000fc400078ec0ffULL,
0x00000018ff937819ULL, 0x000fe4000001165dULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x000000ff3a707812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x000fe4000001163bULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x00000010ff927819ULL, 0x000fc4000001163aULL,
0x000000ff91917812ULL, 0x000fe400078ec0ffULL, 0x0000ffff3aa27812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b727812ULL, 0x000fe400078ec0ffULL, 0x00000093ff75723eULL, 0x000fe200020006ffULL,
0x2000008eff937230ULL, 0x000fe20000004100ULL, 0x00000008ff3f7819ULL, 0x000fe400000116a1ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fc400020006ffULL, 0x000000ff948e7812ULL, 0x000fe200078ec0ffULL,
0x2000003eff947230ULL, 0x000fe20000004100ULL, 0x000000ff5d957812ULL, 0x000fe200078ec0ffULL,
0x20000079ff7d7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000070ff847230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x00000018ff967819ULL, 0x000fe4000001165eULL, 0x00000072ff72723eULL, 0x000fc400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000008ff3e7819ULL, 0x000fe200000116a2ULL,
0x20000072ff857230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000ffff3ba37812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f997812ULL, 0x000fe200078ec0ffULL,
0x20000073ff807230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fc400020006ffULL,
0x000000ff396c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e977812ULL, 0x000fe400078ec0ffULL,
0x00000095ff79723eULL, 0x000fe200020006ffULL, 0x20000091ff957230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000096ff70723eULL, 0x000fe200020006ffULL,
0x2000003fff967230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x000000ff98987812ULL, 0x000fe200078ec0ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x000000ff9a9a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff917819ULL, 0x000fe400000116a4ULL, 0x00000099ff72723eULL, 0x000fe200020006ffULL,
0x2000008eff997230ULL, 0x000fe20000004100ULL, 0x00000008ff3f7819ULL, 0x000fe400000116a3ULL,
0x00000018ff6d7819ULL, 0x000fe2000001163aULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000097ff73723eULL, 0x000fe200020006ffULL,
0x20000092ff977230ULL, 0x000fe20000004100ULL, 0x000000ff609b7812ULL, 0x008fe200078ec0ffULL,
0x2000006cff8b7230ULL, 0x000fe20000004100ULL, 0x00000098ff8e723eULL, 0x000fe200020006ffULL,
0x2000003eff987230ULL, 0x000fe20000004100ULL, 0x000000ff619c7812ULL, 0x000fe200078ec0ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x0000009aff92723eULL, 0x000fc400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000010ff8c7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x0000a000023e7811ULL, 0x000fe400078e20ffULL, 0x0000006dff5d723eULL, 0x000fe200020006ffULL,
0x2000003fff9a7230ULL, 0x000fe20000004100ULL, 0x0000009bff6d723eULL, 0x000fe200020006ffULL,
0x2000008eff9b7230ULL, 0x000fe20000004100ULL, 0x0000009cff6c723eULL, 0x000fe200020006ffULL,
0x20000092ff9c7230ULL, 0x000fe20000004100ULL, 0x000000ff3c927812ULL, 0x000fe200078ec0ffULL,
0x20000091ff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff3d917812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000003e3c783bULL, 0x000e620000000200ULL,
0x000000ff386a7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000018ff697819ULL, 0x000fe20000011638ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000018ff6b7819ULL, 0x000fc40000011639ULL, 0x00000010ff837819ULL, 0x000fe4000001165eULL,
0x0000ffff5e387812ULL, 0x000fe400078ec0ffULL, 0x00000010ff397819ULL, 0x100fe4000001165fULL,
0x00000018ff5e7819ULL, 0x000fe4000001165fULL, 0x0000ffff5f3a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fc40000011660ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000018ff717819ULL, 0x000fe2000001163bULL,
0x2000006bff897230ULL, 0x000fe20000004100ULL, 0x00000018ff9e7819ULL, 0x000fe20000011663ULL,
0x2000005fff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff887819ULL, 0x000fe4000001165cULL,
0x0000ffff5c867812ULL, 0x000fc400078ec0ffULL, 0x000000ff629d7812ULL, 0x000fe400078ec0ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000008ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff5c7819ULL, 0x000fe20000011660ULL, 0x20000071ff827230ULL, 0x000fe20000004100ULL,
0x0000ffff60767812ULL, 0x000fe200078ec0ffULL, 0x000000673c3c9231ULL, 0x082fe200003400ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x000000673e3e9231ULL, 0x000fe200003400ffULL,
0x0000009eff5f723eULL, 0x000fe200020006ffULL, 0x000000683d3d9231ULL, 0x090fe200003400ffULL,
0x00000008ff8d7819ULL, 0x000fe2000001168dULL, 0x2000005eff717230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x100fe20000011661ULL, 0x000000683f3f9231ULL, 0x000fe200003400ffULL,
0x00000018ff607819ULL, 0x000fe20000011661ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000ffff616e7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff9e7819ULL, 0x000fe4000001168fULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000018ff617819ULL, 0x000fe40000011662ULL, 0x0000009dff9d723eULL, 0x000fe200020006ffULL,
0x2000006aff8a7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000008ff867819ULL, 0x000fe40000011686ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000091ff8f7230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000009eff9e723eULL, 0x000fe200020006ffULL,
0x20000092ff917230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000008dff927230ULL, 0x000fe20000004100ULL, 0x00000061ff5e723eULL, 0x000fe200020006ffULL,
0x2000009dff617230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000090ff9d7230ULL, 0x000fe20000004100ULL, 0x000000ff39397812ULL, 0x000fe200078ec0ffULL,
0x20000088ff8d7230ULL, 0x000fe20000004100ULL, 0x00000069ff3b723eULL, 0x000fe200020006ffULL,
0x20000086ff887230ULL, 0x000fe20000004100ULL, 0x000000ff8c907812ULL, 0x000fe200078ec0ffULL,
0x2000009eff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff9e7819ULL, 0x000fe20000011638ULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000039ff86723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fc4000001168aULL,
0x00000010ff397819ULL, 0x000fe2000001168bULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe40000011695ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x000010548a397816ULL, 0x000fe40000000039ULL, 0x0000105493387816ULL, 0x000fe40000000038ULL,
0x00000008ff8a7819ULL, 0x000fc4000001163aULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x00000010ff3a7819ULL, 0x000fe20000011694ULL, 0x000000383c54723cULL, 0x000fe20000041854ULL,
0x00000010ff8b7819ULL, 0x000fe40000011689ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x000010543b3a7816ULL, 0x000fe4000000003aULL, 0x000010548b3b7816ULL, 0x000fc40000000096ULL,
0x000000ff5c8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff387819ULL, 0x000fe40000011684ULL,
0x00000010ff397819ULL, 0x000fe20000011685ULL, 0x0000003a3c50723cULL, 0x000fe20000041850ULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x00000010ff5c7819ULL, 0x000fe40000011699ULL,
0x0000105497387816ULL, 0x000fc40000000038ULL, 0x000010545c397816ULL, 0x000fe40000000039ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff3b7819ULL, 0x000fe40000011682ULL,
0x00000010ff5c7819ULL, 0x000fe20000011698ULL, 0x000000383c4c723cULL, 0x000fe2000004184cULL,
0x0000a000003a7811ULL, 0x000fe400078e20ffULL, 0x00000010ff9a7819ULL, 0x000fc4000001169aULL,
0x000010545d5c7816ULL, 0x000fe4000000005cULL, 0x000010543b5d7816ULL, 0x000fe4000000009aULL,
0x000000003a38783bULL, 0x000e620000000200ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff9b7819ULL, 0x000fe2000001169bULL,
0x0000005c3c48723cULL, 0x000fe20000041848ULL, 0x00000010ff9c7819ULL, 0x000fc4000001169cULL,
0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff767819ULL, 0x000fe40000011676ULL,
0x000010549b7e7816ULL, 0x000fe4000000007eULL, 0x000010549c7f7816ULL, 0x000fe4000000007fULL,
0x0000007aff85723eULL, 0x000fe400020006ffULL, 0x00000076ff7a723eULL, 0x000fc400020006ffULL,
0x00000010ff5d7819ULL, 0x000fe20000011680ULL, 0x0000007e3c44723cULL, 0x000fe20000041844ULL,
0x00000010ff5c7819ULL, 0x000fe2000001168eULL, 0x2000007aff807230ULL, 0x000fe20000004100ULL,
0x00000010ff767819ULL, 0x000fe20000011681ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff9d7819ULL, 0x000fe4000001169dULL, 0x000010545d5c7816ULL, 0x000fe4000000005cULL,
0x00000008ff877819ULL, 0x000fc40000011687ULL, 0x00001054765d7816ULL, 0x000fe4000000009dULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff767819ULL, 0x000fe2000001168fULL, 0x0000005c3c40723cULL, 0x000fe20000041840ULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x0000006738389231ULL, 0x082fe200003400ffULL,
0x00000010ff7f7819ULL, 0x000fe2000001167bULL, 0x000000673a3a9231ULL, 0x000fe200003400ffULL,
0x00000010ff927819ULL, 0x000fe20000011692ULL, 0x0000006839399231ULL, 0x080fe200003400ffULL,
0x00000010ff937819ULL, 0x000fe20000011678ULL, 0x000000683b3b9231ULL, 0x000fe200003400ffULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00001054767a7816ULL, 0x000fe4000000007dULL, 0x00001054917b7816ULL, 0x000fe2000000007cULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x000010547f927816ULL, 0x000fe40000000092ULL,
0x0000105493937816ULL, 0x000fe4000000008cULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x0000007a3c34723cULL, 0x000fe20000041834ULL, 0x00000010ff6f7819ULL, 0x000fc40000011662ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000ffff62697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fe20000011688ULL, 0x000000923c30723cULL, 0x000fe20000041830ULL,
0x00000010ff627819ULL, 0x000fe20000011663ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000ff639f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff3d7819ULL, 0x000fe40000011674ULL, 0x00000010ff3e7819ULL, 0x000fe40000011675ULL,
0x0000ffff63637812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000010543d3c7816ULL, 0x000fe20000000088ULL,
0x20000060ff6a7230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fe2000001166eULL,
0x2000008aff847230ULL, 0x000fe20000004100ULL, 0x000000ff6f6f7812ULL, 0x000fc400078ec0ffULL,
0x000010543e3d7816ULL, 0x000fe40000000087ULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x00000008ff697819ULL, 0x000fe40000011669ULL, 0x00000008ff637819ULL, 0x000fe20000011663ULL,
0x0000003c3850723cULL, 0x000fe20000041850ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff3f7819ULL, 0x000fc40000011672ULL, 0x00000010ff3e7819ULL, 0x000fe40000011683ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x0000009fff60723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x0000009eff9e723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x2000009eff897230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x2000008bff827230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x000010543e3e7816ULL, 0x000fe20000000073ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00001054863f7816ULL, 0x000fe2000000003fULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fc40000011671ULL,
0x00000010ff717819ULL, 0x000fe40000011684ULL, 0x00000010ff777819ULL, 0x000fe20000011677ULL,
0x0000003e384c723cULL, 0x000fe2000004184cULL, 0x000010543c717816ULL, 0x000fe40000000071ULL,
0x00000010ff5d7819ULL, 0x000fe40000011679ULL, 0x00000010ff5c7819ULL, 0x000fe4000001168dULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff837819ULL, 0x000fc40000011685ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff817819ULL, 0x000fe4000001166aULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff3c7819ULL, 0x000fc4000001166fULL, 0x00000010ff3d7819ULL, 0x000fe40000011660ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff3e7819ULL, 0x000fe4000001165fULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff5f7819ULL, 0x000fc40000011663ULL, 0x000010545c5c7816ULL, 0x000fe40000000077ULL,
0x00001054905d7816ULL, 0x000fe4000000005dULL, 0x0000105470707816ULL, 0x000fe40000000089ULL,
0x0000105482827816ULL, 0x000fe4000000006dULL, 0x0000105483837816ULL, 0x000fe2000000006cULL,
0x0000005c3854723cULL, 0x000fe20000041854ULL, 0x000010546b807816ULL, 0x000fc40000000080ULL,
0x0000105481817816ULL, 0x000fe4000000006eULL, 0x000010543c3c7816ULL, 0x000fe40000000061ULL,
0x00001054623d7816ULL, 0x000fe2000000003dULL, 0x000000703848723cULL, 0x000fe20000041848ULL,
0x000010545e5e7816ULL, 0x000fe40000000069ULL, 0x000010543e5f7816ULL, 0x000fca000000005fULL,
0x000000823844723cULL, 0x040ff00000041844ULL, 0x000000803840723cULL, 0x040ff00000041840ULL,
0x0000003c3834723cULL, 0x040ff00000041834ULL, 0x0000005e3838723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000402b337811ULL, 0x000fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000332c00720cULL, 0x000fda0003f24070ULL, 0x0000c40000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x002e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000327305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff327984ULL, 0x000e640000000800ULL,
0x8000000032ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff307424ULL, 0x000fe200078e00ffULL, 0x0000000328327812ULL, 0x000fe200078ec0ffULL,
0x00000300ff317624ULL, 0x000fc600078e00ffULL, 0x000000033200780cULL, 0x000fe20003f25270ULL,
0xfffffffd30317424ULL, 0x000fe400078e0231ULL, 0x0000580026327a24ULL, 0x000fe400078e02ffULL,
0xffffffffff267424ULL, 0x000fe200078e00ffULL, 0x0000000131317807ULL, 0x000fca0004800000ULL,
0x0000000128287824ULL, 0x000fca00078e0231ULL, 0x0000002a2800720cULL, 0x000fe20003f26070ULL,
0x00000040323d7824ULL, 0x000fe200078e00ffULL, 0x000000602b337811ULL, 0x000fd600078e40ffULL,
0x0000000128319824ULL, 0x000fc800078e0223ULL, 0x0000600031309625ULL, 0x000fe200078e0030ULL,
0x000000332c327217ULL, 0x000fc80007800000ULL, 0x0000000630269981ULL, 0x000362000c1e1900ULL,
0x000000223d3c7210ULL, 0x040fe20007f3e0ffULL, 0x0000000132327824ULL, 0x000fe200078e0a33ULL,
0x0000001d3d5d7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x00005e003c5c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff5e7224ULL, 0x000fe200010e06ffULL,
0x0000002032327807ULL, 0x000fe40000000000ULL, 0x00005f003c3f7a11ULL, 0x000fe400008f443fULL,
0x0000001e3d337210ULL, 0x000fe40007f3e0ffULL, 0x0000003227327217ULL, 0x000fe40007800000ULL,
0x00000004ff317819ULL, 0x002fe2000001162dULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x00005e00333c7a11ULL, 0x000fe200078240ffULL, 0x00000001323e7824ULL, 0x000fe200078e0a27ULL,
0x0000001c3d3d7210ULL, 0x000fc40007f7e0ffULL, 0x00005f0033337a11ULL, 0x000fe400008f4430ULL,
0x0000001b5c307210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff627224ULL, 0x000fe200018e06ffULL,
0x00005e005d607a11ULL, 0x000fe400078440ffULL, 0x0000001b3c327210ULL, 0x000fe40007fbe0ffULL,
0x0000003e3100720cULL, 0x000fe20003f26070ULL, 0x000000ffff317224ULL, 0x000fe200020e063fULL,
0x00005f005d5e7a11ULL, 0x000fe200010f445eULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x00005e003d5c7a11ULL, 0x000fc400078440ffULL, 0x0000003e2100720cULL, 0x080fe40003f86070ULL,
0x0000003e2000720cULL, 0x080fe40003fc6070ULL, 0x0000003e1f00720cULL, 0x000fe40003fa6070ULL,
0x0000001b603c7210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000301a7faeULL, 0x0003e2000c901c46ULL, 0x00005f003d627a11ULL, 0x000fe400010f4462ULL,
0x0000001b5c3e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fc400018e065eULL,
0x0000000032197faeULL, 0x0003e4000e101c46ULL, 0x000000ffff3f7224ULL, 0x000fe400010e0662ULL,
0x000000003c187faeULL, 0x0003e8000f101c46ULL, 0x000000003e177faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff687f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff317984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280027327f8cULL, 0x000fe2000c80043fULL, 0x8000000031ff7812ULL, 0x002fc6000784485aULL,
0x01062c00273d7984ULL, 0x000e640000000800ULL, 0x800000003dff7812ULL, 0x002fe40007824833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002e4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x008fe40003800000ULL, 0x01062c0027317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007824833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0100800016327984ULL, 0x000e680000000800ULL, 0x0102800016337984ULL, 0x0007220000000800ULL,
0x000000253200720bULL, 0x002fe20003f3d000ULL, 0x00014dc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x008fc800008e0100ULL, 0x0000ffff303d7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff607424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000012e00780cULL, 0x000fe40003f65270ULL,
0x000000253200720bULL, 0x000fe20003f34000ULL, 0x00014d927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000307806ULL, 0x000fe400008e0100ULL, 0x0000003225317209ULL, 0x040fe40007810000ULL,
0x0000ffff30307812ULL, 0x000fe400078e3cffULL, 0x00000002ff6c7819ULL, 0x000fe2000001162dULL,
0x80000031253c7221ULL, 0x000fe20000010000ULL, 0x010480311600b388ULL, 0x0003e20000000800ULL,
0x000000303dff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b3c3c7820ULL, 0x000fc80000410000ULL,
0x0000003c005f7308ULL, 0x000ee40000000800ULL, 0x0000005f24247220ULL, 0x008fe20000410000ULL,
0x00014d327f007947ULL, 0x000fea000b800000ULL, 0x00001f6c5f5e7589ULL, 0x0022e400000e0000ULL,
0x0000005e54547220ULL, 0x08cfe20000410000ULL, 0x0000005e55557220ULL, 0x080fe20000410000ULL,
0x0000005e50507220ULL, 0x080fe20000410000ULL, 0x0000005e51517220ULL, 0x080fe20000410000ULL,
0x0000005e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000005e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000005e48487220ULL, 0x080fe20000410000ULL, 0x0000005e49497220ULL, 0x080fe20000410000ULL,
0x0000005e44447220ULL, 0x080fe20000410000ULL, 0x0000005e45457220ULL, 0x080fe20000410000ULL,
0x0000005e40407220ULL, 0x080fe20000410000ULL, 0x0000005e41417220ULL, 0x080fe20000410000ULL,
0x0000005e34347220ULL, 0x080fe20000410000ULL, 0x0000005e35357220ULL, 0x080fe20000410000ULL,
0x0000005e38387220ULL, 0x080fe20000410000ULL, 0x0000005e39397220ULL, 0x000fe20000410000ULL,
0x00014c627f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5f5e7589ULL, 0x0004e400000e0000ULL,
0x0000003225257209ULL, 0x000fe20007810000ULL, 0x0000005e56567220ULL, 0x08cfe20000410000ULL,
0x00000001ff607807ULL, 0x000fe20000800000ULL, 0x0000005e57577220ULL, 0x080fe20000410000ULL,
0x0000005e52527220ULL, 0x080fe20000410000ULL, 0x8000002532321221ULL, 0x000fe20000010000ULL,
0x0000005e53537220ULL, 0x080fe20000410000ULL, 0x0000005e4e4e7220ULL, 0x080fe20000410000ULL,
0x0000005e4f4f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b32321820ULL, 0x000fe20000410000ULL,
0x0000005e4a4a7220ULL, 0x080fe20000410000ULL, 0x0000005e4b4b7220ULL, 0x080fe20000410000ULL,
0x0000005e46467220ULL, 0x080fe20000410000ULL, 0x0000003200151308ULL, 0x000ea20000000800ULL,
0x0000005e47477220ULL, 0x080fe20000410000ULL, 0x0000005e42427220ULL, 0x080fe20000410000ULL,
0x0000005e43437220ULL, 0x080fe20000410000ULL, 0x0000005e36367220ULL, 0x080fe20000410000ULL,
0x0000005e37377220ULL, 0x080fe20000410000ULL, 0x0000005e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000005e3b3b7220ULL, 0x000fe20000410000ULL, 0x0000003315331220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002433247221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fc4000782485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x000724000021f000ULL,
0x3fa0000030307823ULL, 0x008fe200000100ffULL, 0x000000310000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x008fe4000782485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff30723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x002fc4000001162dULL, 0x00005410305f7816ULL, 0x000fe20000000030ULL,
0x00014a027f007947ULL, 0x000fea000b800000ULL, 0x00001f6c5f677589ULL, 0x0002e400000e0000ULL,
0x00014a427f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5f5a7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0066ULL,
0x00006220005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000156b000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0065ULL,
0x00006280005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0001565000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000133c783bULL, 0x000f220000004200ULL,
0x0000991060607816ULL, 0x000fc600000000ffULL, 0x00000000125c783bULL, 0x016e620000004200ULL,
0x000000ff6000720cULL, 0x000fc60003f25270ULL, 0x000000001430783bULL, 0x000ea80000004200ULL,
0x000000001160783bULL, 0x000f220000004200ULL, 0x000000ff3d797812ULL, 0x040fe400078ec0ffULL,
0x00000010ff9b7819ULL, 0x100fe4000001163dULL, 0x00000018ff767819ULL, 0x000fe4000001163dULL,
0x0000ffff3d917812ULL, 0x000fc400078ec0ffULL, 0x000000ff3f7c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3d7819ULL, 0x100fe4000001163eULL, 0x000000ff3e7b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3e7819ULL, 0x000fc4000001163fULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x000000ff5c7d7812ULL, 0x002fe400078ec0ffULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000079ff817230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000010ff8f7819ULL, 0x004fe40000011630ULL, 0x00000010ff997819ULL, 0x000fc4000001163cULL,
0x000000ff3c757812ULL, 0x040fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe4000001163cULL,
0x0000ffff3ca57812ULL, 0x000fe400078ec0ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000010ff3c7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f907812ULL, 0x000fc400078ec0ffULL,
0x0000ffff30a17812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001165cULL,
0x0000007dff79723eULL, 0x000fe200020006ffULL, 0x2000007cff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x2000007aff7c7230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000003eff7a7230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x20000075ff807230ULL, 0x000fe20000004100ULL,
0x00000008ff3e7819ULL, 0x000fe200000116a1ULL, 0x20000076ff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x000fe20000011631ULL, 0x2000003fff757230ULL, 0x000fe20000004100ULL,
0x0000ffff31a27812ULL, 0x000fc400078ec0ffULL, 0x00000018ff947819ULL, 0x000fe4000001165dULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000010ff957819ULL, 0x100fe40000011633ULL,
0x00000018ff727819ULL, 0x000fe40000011633ULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000010ff937819ULL, 0x000fc40000011632ULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x0000ffff32a37812ULL, 0x000fe400078ec0ffULL, 0x00000094ff76723eULL, 0x000fe200020006ffULL,
0x2000008fff947230ULL, 0x000fe20000004100ULL, 0x00000008ff3f7819ULL, 0x000fe400000116a2ULL,
0x000000ff33737812ULL, 0x000fe200078ec0ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff958f7812ULL, 0x000fe200078ec0ffULL, 0x2000003eff957230ULL, 0x000fe20000004100ULL,
0x000000ff5d967812ULL, 0x000fe200078ec0ffULL, 0x2000007bff7e7230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000072ff837230ULL, 0x000fe20000004100ULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fc4000001165eULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x0000003fff3f723eULL, 0x000fe400020006ffULL,
0x00000008ff3e7819ULL, 0x000fe200000116a3ULL, 0x20000074ff827230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x000000ff316d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff33a47812ULL, 0x000fe200078ec0ffULL, 0x20000073ff867230ULL, 0x000fe20000004100ULL,
0x000000ff5f9a7812ULL, 0x000fc400078ec0ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x000000ff5e987812ULL, 0x000fe400078ec0ffULL, 0x00000096ff7b723eULL, 0x000fe200020006ffULL,
0x20000092ff967230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000097ff72723eULL, 0x000fe200020006ffULL, 0x2000003fff977230ULL, 0x000fe20000004100ULL,
0x0000003eff3e723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff99997812ULL, 0x000fe200078ec0ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x000000ff9b9b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff927819ULL, 0x000fe400000116a5ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000009aff74723eULL, 0x000fe200020006ffULL,
0x2000008fff9a7230ULL, 0x000fe20000004100ULL, 0x00000008ff3f7819ULL, 0x000fe200000116a4ULL,
0x2000006dff8c7230ULL, 0x000fe20000004100ULL, 0x00000098ff73723eULL, 0x000fe200020006ffULL,
0x20000093ff987230ULL, 0x000fe20000004100ULL, 0x00000018ff6e7819ULL, 0x000fe20000011632ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000000ff609c7812ULL, 0x010fe200078ec0ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000099ff8f723eULL, 0x000fe200020006ffULL,
0x2000003eff997230ULL, 0x000fe20000004100ULL, 0x000000ff619d7812ULL, 0x000fc400078ec0ffULL,
0x0000009bff93723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x0000a800103e7811ULL, 0x000fe400078e20ffULL,
0x00000010ff8d7819ULL, 0x000fe2000001165dULL, 0x2000003fff9b7230ULL, 0x000fe20000004100ULL,
0x0000ffff5d887812ULL, 0x000fc400078ec0ffULL, 0x0000006eff5d723eULL, 0x000fe400020006ffULL,
0x0000009cff6d723eULL, 0x000fe200020006ffULL, 0x2000008fff9c7230ULL, 0x000fe20000004100ULL,
0x0000009dff6e723eULL, 0x000fe200020006ffULL, 0x20000093ff9d7230ULL, 0x000fe20000004100ULL,
0x000000ff3c937812ULL, 0x000fe200078ec0ffULL, 0x20000092ff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff3d927812ULL, 0x000fe200078ec0ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000003e3c783bULL, 0x000e620000000200ULL, 0x000000ff306b7812ULL, 0x000fe200078ec0ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000018ff6a7819ULL, 0x000fe20000011630ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff32717812ULL, 0x000fc400078ec0ffULL,
0x00000010ff847819ULL, 0x000fe4000001165eULL, 0x0000ffff5e307812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001165fULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011631ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000071ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x000fc4000001165fULL,
0x0000ffff5f327812ULL, 0x000fe200078ec0ffULL, 0x2000005eff717230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe4000001165cULL, 0x00000018ff5f7819ULL, 0x000fe40000011660ULL,
0x00000018ff9f7819ULL, 0x000fe40000011663ULL, 0x0000ffff5c877812ULL, 0x000fe400078ec0ffULL,
0x000000ff629e7812ULL, 0x000fc400078ec0ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff917819ULL, 0x000fe40000011691ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168eULL,
0x2000006bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fe20000011660ULL,
0x000000673c3c9231ULL, 0x08afe200003400ffULL, 0x0000ffff60787812ULL, 0x000fe200078ec0ffULL,
0x000000673e3e9231ULL, 0x000fe200003400ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x0000005a3d3d9231ULL, 0x080fe200003400ffULL, 0x0000009fff5e723eULL, 0x000fe200020006ffULL,
0x0000005a3f3f9231ULL, 0x000fe200003400ffULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x2000005fff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff777819ULL, 0x100fe20000011661ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000018ff607819ULL, 0x000fc40000011661ULL,
0x0000ffff616f7812ULL, 0x000fe400078ec0ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000008ff9f7819ULL, 0x000fe40000011690ULL, 0x00000008ff877819ULL, 0x000fe20000011687ULL,
0x20000092ff907230ULL, 0x000fe20000004100ULL, 0x00000018ff617819ULL, 0x000fe40000011662ULL,
0x0000009eff9e723eULL, 0x000fc400020006ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x20000093ff927230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000009fff9f723eULL, 0x000fe200020006ffULL, 0x2000008eff937230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000089ff8e7230ULL, 0x000fe20000004100ULL,
0x00000061ff5f723eULL, 0x000fe200020006ffULL, 0x2000009eff617230ULL, 0x000fe20000004100ULL,
0x000000ff31317812ULL, 0x000fe200078ec0ffULL, 0x20000091ff9e7230ULL, 0x000fe20000004100ULL,
0x0000006aff33723eULL, 0x000fe200020006ffULL, 0x20000087ff897230ULL, 0x000fe20000004100ULL,
0x000000ff8d917812ULL, 0x000fe200078ec0ffULL, 0x2000009fff8d7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x00000031ff87723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff9f7819ULL, 0x000fe20000011630ULL, 0x2000006cff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fe2000001168bULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff317819ULL, 0x000fc40000011694ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff8b7819ULL, 0x000fe40000011696ULL, 0x0000105431307816ULL, 0x000fe40000000030ULL,
0x000010548b317816ULL, 0x000fe4000000008cULL, 0x00000008ff8b7819ULL, 0x000fe40000011632ULL,
0x00000010ff337819ULL, 0x000fc40000011633ULL, 0x00000010ff327819ULL, 0x000fe20000011695ULL,
0x000000303c54723cULL, 0x000fe20000041854ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168aULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x0000105433327816ULL, 0x000fe40000000032ULL,
0x000010548c337816ULL, 0x000fe40000000097ULL, 0x0000008bff94723eULL, 0x000fc400020006ffULL,
0x00000010ff307819ULL, 0x000fe40000011685ULL, 0x00000010ff317819ULL, 0x000fe20000011698ULL,
0x000000323c50723cULL, 0x000fe20000041850ULL, 0x00000010ff867819ULL, 0x000fe20000011686ULL,
0x20000094ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe4000001169aULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000105431307816ULL, 0x000fc40000000030ULL,
0x000010548b317816ULL, 0x000fe40000000086ULL, 0x0000005cff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff327819ULL, 0x000fe20000011683ULL,
0x000000303c4c723cULL, 0x000fe2000004184cULL, 0x00000010ff5c7819ULL, 0x000fe20000011699ULL,
0x2000008cff837230ULL, 0x000fe20000004100ULL, 0x0000a8000f337811ULL, 0x000fc400078e20ffULL,
0x00000010ff9b7819ULL, 0x000fe4000001169bULL, 0x000010545d5c7816ULL, 0x000fe4000000005cULL,
0x00001054325d7816ULL, 0x000fe4000000009bULL, 0x000000003330783bULL, 0x000e620000000200ULL,
0x000000ff778b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x0000005c3c48723cULL, 0x000fe20000041848ULL, 0x00000010ff777819ULL, 0x000fc4000001169cULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff9e7819ULL, 0x000fe4000001169eULL,
0x00000010ff5d7819ULL, 0x000fe40000011682ULL, 0x00000010ff5c7819ULL, 0x000fe4000001168fULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff927819ULL, 0x000fc40000011692ULL,
0x000010545d5c7816ULL, 0x000fe4000000005cULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x00000008ff867819ULL, 0x000fe40000011678ULL, 0x0000105477807816ULL, 0x000fe40000000080ULL,
0x000010547f5d7816ULL, 0x000fe4000000009eULL, 0x00000010ff817819ULL, 0x000fc40000011681ULL,
0x00000010ff787819ULL, 0x000fe4000001169dULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x0000005c3c40723cULL, 0x000fe20000041840ULL, 0x00000010ff777819ULL, 0x000fe40000011690ULL,
0x00001054927f7816ULL, 0x000fe4000000007dULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x0000006730309231ULL, 0x082fe200003400ffULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x0000006732329231ULL, 0x000fe200003400ffULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x0000005a31319231ULL, 0x080fe200003400ffULL, 0x00000010ff7d7819ULL, 0x000fe2000001168dULL,
0x0000005a33339231ULL, 0x000fe200003400ffULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x0000105478817816ULL, 0x000fe40000000081ULL, 0x00001054777e7816ULL, 0x000fe2000000007eULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x000010547c7c7816ULL, 0x000fe40000000093ULL,
0x000010547a7d7816ULL, 0x000fe2000000007dULL, 0x000000803c44723cULL, 0x000fe20000041844ULL,
0x00000010ff707819ULL, 0x000fe40000011662ULL, 0x0000ffff626a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff627819ULL, 0x000fe40000011663ULL, 0x000000ff63a07812ULL, 0x040fe200078ec0ffULL,
0x0000007e3c34723cULL, 0x040fe20000041834ULL, 0x0000ffff63637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x0000007c3c3c723cULL, 0x000fe20000041838ULL,
0x0000009fff9f723eULL, 0x000fc400020006ffULL, 0x000000ff84847812ULL, 0x000fe200078ec0ffULL,
0x20000060ff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff6f7819ULL, 0x000fe2000001166fULL,
0x2000009fff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe40000011675ULL,
0x00000010ff397819ULL, 0x000fe40000011688ULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x000000ff62627812ULL, 0x000fc400078ec0ffULL, 0x00000008ff6a7819ULL, 0x000fe4000001166aULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x0000105438387816ULL, 0x000fe40000000089ULL,
0x0000105476397816ULL, 0x000fe40000000039ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x000000a0ff60723eULL, 0x000fc400020006ffULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x000000383050723cULL, 0x000fe20000041850ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000008bff787230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe20000011672ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe20000011671ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168aULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff857819ULL, 0x000fc40000011685ULL,
0x00001054398a7816ULL, 0x000fe4000000008aULL, 0x00001054388b7816ULL, 0x000fe40000000085ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x0000008a3048723cULL, 0x000fe20000041848ULL,
0x00000010ff7b7819ULL, 0x000fc4000001167bULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff5c7819ULL, 0x000fe40000011691ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff3b7819ULL, 0x000fe40000011674ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff5a7819ULL, 0x000fc40000011687ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff397819ULL, 0x000fe4000001166eULL, 0x00000010ff387819ULL, 0x000fe40000011683ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff6f7819ULL, 0x000fc4000001166fULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff717819ULL, 0x000fe40000011662ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x000010546b867816ULL, 0x000fe40000000086ULL,
0x000010548e8e7816ULL, 0x000fe40000000079ULL, 0x000010545c8f7816ULL, 0x000fe4000000007bULL,
0x00001054843a7816ULL, 0x000fc40000000073ULL, 0x000010545a3b7816ULL, 0x000fe4000000003bULL,
0x0000105438387816ULL, 0x000fe2000000006dULL, 0x0000008e3054723cULL, 0x040fe20000041854ULL,
0x0000105478397816ULL, 0x000fe40000000039ULL, 0x000010546c877816ULL, 0x000fe4000000006fULL,
0x0000105470707816ULL, 0x000fe40000000061ULL, 0x0000105471717816ULL, 0x000fe20000000060ULL,
0x0000003a304c723cULL, 0x000fe2000004184cULL, 0x000010545f6a7816ULL, 0x000fc4000000006aULL,
0x000010545e6b7816ULL, 0x000fca0000000063ULL, 0x000000383044723cULL, 0x040ff00000041844ULL,
0x000000863040723cULL, 0x040ff00000041840ULL, 0x000000703034723cULL, 0x040ff00000041834ULL,
0x0000006a303c723cULL, 0x000fe2000004183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff327f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844833ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580026307a24ULL, 0x020fe200078e02ffULL,
0x000000802b317811ULL, 0x000fc600078e40ffULL, 0x0000004030327824ULL, 0x000fe200078e00ffULL,
0x000000312c307217ULL, 0x000fc80007800000ULL, 0x0000000e32337210ULL, 0x000fe20007f5e0ffULL,
0x0000000130307824ULL, 0x000fe200078e0a31ULL, 0x0000000d32397210ULL, 0x000fe40007f7e0ffULL,
0x00000004ff317819ULL, 0x000fe2000001162dULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x00005e00335a7a11ULL, 0x000fe200078440ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005e00395c7a11ULL, 0x000fe400078640ffULL, 0x00005f0033337a11ULL, 0x000fc400010f4438ULL,
0x0000000c32387210ULL, 0x040fe40007f5e0ffULL, 0x00005f0039397a11ULL, 0x000fe400018f443aULL,
0x0000000b32327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200010e06ffULL,
0x0000002030307807ULL, 0x000fe40000000000ULL, 0x00005e00385e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff5d7224ULL, 0x000fe200018e06ffULL, 0x0000003027307217ULL, 0x000fc40007800000ULL,
0x00005e0032607a11ULL, 0x000fe400078640ffULL, 0x00005f00383b7a11ULL, 0x000fe200010f443bULL,
0x00000001303a7824ULL, 0x000fe200078e0a27ULL, 0x00005f00325d7a11ULL, 0x000fe400018f445dULL,
0x0000001b5a307210ULL, 0x080fe40007f7e0ffULL, 0x0000001b5c327210ULL, 0x080fe40007f9e0ffULL,
0x0000001b5e387210ULL, 0x000fc40007fbe0ffULL, 0x0000003a3100720cULL, 0x080fe20003f46070ULL,
0x000000ffff317224ULL, 0x000fe200018e0633ULL, 0x0000003a2100720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200020e0639ULL, 0x0000003a2000720cULL, 0x080fe20003f86070ULL,
0x000000ffff397224ULL, 0x000fe200028e063bULL, 0x0000003a1f00720cULL, 0x000fe40003fa6070ULL,
0x0000001b603a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e065dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000300a7faeULL, 0x0003e8000d101c46ULL,
0x0000000032097faeULL, 0x0003e8000d901c46ULL, 0x0000000038087faeULL, 0x0003e8000e101c46ULL,
0x000000003a077faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5a7224ULL, 0x000fe200078e0031ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff30723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x000fe4000001162dULL, 0x00005410305f7816ULL, 0x000fe20000000030ULL,
0x00012d727f007947ULL, 0x000fea000b800000ULL, 0x00001f6c5f677589ULL, 0x0002a400000e0000ULL,
0x00012db27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5f687589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0066ULL,
0x00007f80005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0001395000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0065ULL,
0x00007fe0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000138f000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000630783bULL, 0x000f680000004200ULL,
0x000000000538783bULL, 0x000e680000004200ULL, 0x00000000045c783bULL, 0x00ee680000004200ULL,
0x000000000360783bULL, 0x000ea20000004200ULL, 0x00000010ff947819ULL, 0x020fc40000011631ULL,
0x000000ff316c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011631ULL,
0x0000ffff31a27812ULL, 0x000fe400078ec0ffULL, 0x00000018ff317819ULL, 0x000fe40000011632ULL,
0x0000ffff30a17812ULL, 0x000fe400078ec0ffULL, 0x00000031ff31723eULL, 0x000fc400020006ffULL,
0x00000010ff957819ULL, 0x000fe40000011632ULL, 0x000000ff326e7812ULL, 0x040fe200078ec0ffULL,
0x20000031ff737230ULL, 0x000fe20000004100ULL, 0x0000ffff32a37812ULL, 0x000fe400078ec0ffULL,
0x00000018ff747819ULL, 0x000fe40000011639ULL, 0x00000010ff327819ULL, 0x000fe40000011633ULL,
0x000000ff33707812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011633ULL,
0x0000ffff33a47812ULL, 0x000fe400078ec0ffULL, 0x00000018ff337819ULL, 0x000fe40000011638ULL,
0x00000008ff317819ULL, 0x000fe400000116a1ULL, 0x000000ff3a797812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x00000018ff937819ULL, 0x002fe4000001165cULL,
0x00000033ff33723eULL, 0x000fe200020006ffULL, 0x20000074ff7e7230ULL, 0x000fe20000004100ULL,
0x00000031ff31723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000033ff7f7230ULL, 0x000fe20000004100ULL, 0x00000018ff7a7819ULL, 0x000fe4000001163bULL,
0x00000093ff74723eULL, 0x000fe200020006ffULL, 0x20000031ff937230ULL, 0x000fe20000004100ULL,
0x000000ff5d977812ULL, 0x000fe200078ec0ffULL, 0x20000079ff7d7230ULL, 0x000fe20000004100ULL,
0x00000008ff317819ULL, 0x000fe200000116a2ULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x000000ff32337812ULL, 0x000fc400078ec0ffULL, 0x000000ff3b7b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff38717812ULL, 0x000fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe4000001163aULL,
0x0000007aff79723eULL, 0x000fe400020006ffULL, 0x000000ff5c967812ULL, 0x000fe400078ec0ffULL,
0x00000097ff7a723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x000000ff95957812ULL, 0x000fc400078ec0ffULL, 0x00000031ff31723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000033ff97723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000008ff337819ULL, 0x000fe400000116a3ULL,
0x00000010ff9a7819ULL, 0x000fe20000011639ULL, 0x2000007bff7c7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000010ff997819ULL, 0x000fe20000011638ULL, 0x20000071ff807230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000078ff7b7230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x000000ff5e987812ULL, 0x000fe200078ec0ffULL,
0x20000070ff857230ULL, 0x000fe20000004100ULL, 0x00000095ff32723eULL, 0x000fe200020006ffULL,
0x20000031ff957230ULL, 0x000fe20000004100ULL, 0x000000ff5f9b7812ULL, 0x000fe200078ec0ffULL,
0x20000096ff787230ULL, 0x000fe20000004100ULL, 0x00000033ff33723eULL, 0x000fe200020006ffULL,
0x20000032ff967230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fc40000011630ULL,
0x000000ff306a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe40000011630ULL,
0x00000008ff317819ULL, 0x000fe400000116a4ULL, 0x000000ff9a9a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff38307812ULL, 0x000fe400078ec0ffULL, 0x000000ff99997812ULL, 0x000fc400078ec0ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000098ff71723eULL, 0x000fe200020006ffULL,
0x20000097ff987230ULL, 0x000fe20000004100ULL, 0x0000009bff70723eULL, 0x000fe200020006ffULL,
0x20000033ff977230ULL, 0x000fe20000004100ULL, 0x000000ff609c7812ULL, 0x004fe200078ec0ffULL,
0x2000006bff877230ULL, 0x000fe20000004100ULL, 0x00000031ff32723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000009aff9b723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000099ff33723eULL, 0x000fe200020006ffULL,
0x20000032ff997230ULL, 0x000fe20000004100ULL, 0x0000a80002317811ULL, 0x000fc400078e20ffULL,
0x00000008ff307819ULL, 0x000fe20000011630ULL, 0x20000033ff9a7230ULL, 0x000fe20000004100ULL,
0x0000009cff6b723eULL, 0x000fe200020006ffULL, 0x2000009bff9c7230ULL, 0x000fe20000004100ULL,
0x00000030ff9b723eULL, 0x000fe400020006ffULL, 0x000000003130783bULL, 0x000e620000000200ULL,
0x00000010ff897819ULL, 0x000fe2000001165cULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x0000ffff5c867812ULL, 0x000fe200078ec0ffULL, 0x2000009bff9b7230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fc4000001165dULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d887812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001165eULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000ffff39917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff907819ULL, 0x000fe2000001163aULL, 0x2000006eff847230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x0000ffff3a8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x000fe2000001163bULL, 0x2000005dff6e7230ULL, 0x000fe20000004100ULL,
0x00000018ff9e7819ULL, 0x000fe40000011662ULL, 0x0000ffff3b8e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x00000008ff917819ULL, 0x000fc40000011691ULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x000000ff94947812ULL, 0x000fe400078ec0ffULL,
0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8d7819ULL, 0x000fe2000001168dULL,
0x0000006730309231ULL, 0x082fe200003400ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x0000006732329231ULL, 0x000fe200003400ffULL, 0x0000009eff5d723eULL, 0x000fe200020006ffULL,
0x0000006831319231ULL, 0x090fe200003400ffULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x2000006aff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff9e7819ULL, 0x000fe2000001168eULL,
0x0000006833339231ULL, 0x000fe200003400ffULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff39757812ULL, 0x000fc400078ec0ffULL,
0x000000ff619d7812ULL, 0x000fe400078ec0ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe4000001165fULL,
0x0000006cff8b723eULL, 0x000fe200020006ffULL, 0x20000090ff8e7230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fc400020006ffULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x2000008fff907230ULL, 0x000fe20000004100ULL, 0x0000009eff9e723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000009dff6a723eULL, 0x000fe200020006ffULL,
0x20000091ff9d7230ULL, 0x000fe20000004100ULL, 0x0000ffff5e387812ULL, 0x000fe200078ec0ffULL,
0x2000008dff917230ULL, 0x000fe20000004100ULL, 0x000000ff39397812ULL, 0x000fe200078ec0ffULL,
0x20000089ff8d7230ULL, 0x000fe20000004100ULL, 0x00000069ff3b723eULL, 0x000fe200020006ffULL,
0x20000086ff897230ULL, 0x000fe20000004100ULL, 0x000000ff8c8f7812ULL, 0x000fe200078ec0ffULL,
0x2000009eff8c7230ULL, 0x000fe20000004100ULL, 0x00000039ff86723eULL, 0x000fe200020006ffULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000008ff9e7819ULL, 0x000fe20000011638ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe2000001168aULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fc40000011692ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x0000ffff5f3a7812ULL, 0x000fe400078ec0ffULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x0000105494397816ULL, 0x000fe4000000008bULL, 0x00000008ff8b7819ULL, 0x000fc4000001163aULL,
0x00000010ff3b7819ULL, 0x000fe4000001163bULL, 0x00000010ff3a7819ULL, 0x000fe20000011693ULL,
0x000000383054723cULL, 0x000fe20000041854ULL, 0x00000010ff8a7819ULL, 0x000fe40000011687ULL,
0x00000010ff957819ULL, 0x000fe40000011695ULL, 0x00000010ff727819ULL, 0x000fe40000011660ULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x000010543b3a7816ULL, 0x000fe4000000003aULL,
0x000010548a3b7816ULL, 0x000fe20000000095ULL, 0x2000006fff827230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe40000011684ULL, 0x00000010ff397819ULL, 0x000fe40000011696ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x0000003a3050723cULL, 0x000fe20000041850ULL,
0x00000010ff857819ULL, 0x000fc40000011685ULL, 0x00000010ff987819ULL, 0x000fe40000011698ULL,
0x0000105439387816ULL, 0x000fe40000000038ULL, 0x00000072ff8a723eULL, 0x000fe400020006ffULL,
0x0000105498397816ULL, 0x000fe40000000085ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff727819ULL, 0x000fc40000011697ULL, 0x00000010ff3a7819ULL, 0x000fe20000011682ULL,
0x00000038304c723cULL, 0x000fe2000004184cULL, 0x00000010ff997819ULL, 0x000fe20000011699ULL,
0x2000008aff827230ULL, 0x000fe20000004100ULL, 0x0000a800003b7811ULL, 0x000fe400078e20ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x0000105473727816ULL, 0x000fe40000000072ULL,
0x000010543a737816ULL, 0x000fe20000000099ULL, 0x20000075ff817230ULL, 0x000fe20000004100ULL,
0x0000ffff60777812ULL, 0x000fe200078ec0ffULL, 0x000000003b38783bULL, 0x000e620000000200ULL,
0x00000010ff767819ULL, 0x000fc40000011661ULL, 0x00000008ff857819ULL, 0x000fe20000011677ULL,
0x000000723048723cULL, 0x000fe20000041848ULL, 0x000000ff768a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x000fe40000011680ULL, 0x00000010ff777819ULL, 0x000fe4000001169aULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff9c7819ULL, 0x000fc4000001169cULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff727819ULL, 0x000fe4000001169bULL, 0x00000010ff737819ULL, 0x000fe4000001169dULL,
0x0000105477767816ULL, 0x000fe40000000076ULL, 0x000010549c777816ULL, 0x000fc40000000081ULL,
0x000010547f727816ULL, 0x000fe40000000072ULL, 0x000010547e737816ULL, 0x000fe40000000073ULL,
0x00000010ff7d7819ULL, 0x000fe2000001167dULL, 0x000000763044723cULL, 0x000fe20000041844ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff837819ULL, 0x000fc4000001165eULL, 0x00000010ff777819ULL, 0x000fe2000001167cULL,
0x000000723040723cULL, 0x000fe20000041840ULL, 0x000010548e767816ULL, 0x000fe2000000007dULL,
0x0000006738389231ULL, 0x082fe200003400ffULL, 0x00000010ff907819ULL, 0x000fe20000011690ULL,
0x000000673a3a9231ULL, 0x000fe200003400ffULL, 0x00000010ff7c7819ULL, 0x000fe2000001167bULL,
0x0000006839399231ULL, 0x080fe200003400ffULL, 0x00000010ff917819ULL, 0x000fe20000011691ULL,
0x000000683b3b9231ULL, 0x000fe200003400ffULL, 0x00000010ff727819ULL, 0x000fc40000011679ULL,
0x00000010ff7d7819ULL, 0x000fe4000001168cULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x2000005cff757230ULL, 0x000fe20000004100ULL, 0x0000105490777816ULL, 0x000fe20000000077ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x000010547c7c7816ULL, 0x000fc40000000091ULL,
0x00001054727d7816ULL, 0x000fe4000000007dULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x000000763034723cULL, 0x040fe20000041834ULL, 0x0000ffff616c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001165fULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fe40000011660ULL, 0x00000018ff607819ULL, 0x000fe20000011661ULL,
0x0000007c303c723cULL, 0x000fe2000004183cULL, 0x00000008ff6c7819ULL, 0x000fc4000001166cULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff307819ULL, 0x000fe20000011675ULL, 0x2000005eff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff757819ULL, 0x000fe40000011688ULL, 0x00000010ff317819ULL, 0x000fe40000011670ULL,
0x0000105430757816ULL, 0x000fc40000000075ULL, 0x00000010ff307819ULL, 0x000fe40000011683ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x000000ff62617812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe20000011662ULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x0000ffff62697812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000105430307816ULL, 0x000fe40000000071ULL,
0x0000105486317816ULL, 0x000fe40000000031ULL, 0x00000010ff627819ULL, 0x000fc40000011663ULL,
0x000000ff63a07812ULL, 0x040fe400078ec0ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011663ULL,
0x00000030384c723cULL, 0x000fe2000004184cULL, 0x0000ffff63637812ULL, 0x000fe400078ec0ffULL,
0x00000061ff5e723eULL, 0x000fe200020006ffULL, 0x2000005fff617230ULL, 0x000fe20000004100ULL,
0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff62627812ULL, 0x000fe200078ec0ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff697819ULL, 0x000fc40000011669ULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff307819ULL, 0x000fe40000011661ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff317819ULL, 0x000fe4000001166cULL, 0x000000a0ff5f723eULL, 0x000fc400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x0000009eff9e723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000009eff877230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000008bff847230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x0000009fff5c723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000105430307816ULL, 0x000fe20000000085ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x0000105460317816ULL, 0x000fe20000000031ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fc4000001167aULL,
0x00000010ff327819ULL, 0x000fe4000001166fULL, 0x00000010ff787819ULL, 0x000fe20000011678ULL,
0x000000303840723cULL, 0x000fe20000041840ULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff7a7819ULL, 0x000fe4000001168fULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff897819ULL, 0x000fc40000011689ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff6f7819ULL, 0x000fe40000011684ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff827819ULL, 0x000fc40000011682ULL, 0x00000010ff837819ULL, 0x000fe4000001168aULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff307819ULL, 0x000fc4000001165dULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff317819ULL, 0x000fe40000011663ULL,
0x000010548d787816ULL, 0x000fe40000000078ULL, 0x000010547a797816ULL, 0x000fe40000000079ULL,
0x0000105474747816ULL, 0x000fc40000000089ULL, 0x000010546e6e7816ULL, 0x000fe40000000087ULL,
0x00001054326f7816ULL, 0x000fe2000000006fULL, 0x000000783854723cULL, 0x040fe20000041854ULL,
0x0000105482827816ULL, 0x000fe4000000006bULL, 0x0000105483837816ULL, 0x000fe4000000006aULL,
0x000010546d5e7816ULL, 0x000fe4000000005eULL, 0x00001054625f7816ULL, 0x000fe2000000005fULL,
0x000000743850723cULL, 0x000fe20000041850ULL, 0x0000105430307816ULL, 0x000fc40000000069ULL,
0x000010545c317816ULL, 0x000fca0000000031ULL, 0x0000006e3848723cULL, 0x040ff00000041848ULL,
0x000000823844723cULL, 0x040ff00000041844ULL, 0x0000005e3834723cULL, 0x040ff00000041834ULL,
0x000000303838723cULL, 0x000fe2000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff307f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000802b337811ULL, 0x000fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000332c00720cULL, 0x000fda0003f24070ULL,
0x000082b000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x002e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000327305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000320000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff327984ULL, 0x000e640000000800ULL, 0x8000000032ff7812ULL, 0x002fc40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff307424ULL, 0x000fe200078e00ffULL,
0x0000000328327812ULL, 0x000fe200078ec0ffULL, 0x00000300ff317624ULL, 0x000fc600078e00ffULL,
0x000000033200780cULL, 0x000fe20003f25270ULL, 0xfffffffd30317424ULL, 0x000fe400078e0231ULL,
0x0000580026327a24ULL, 0x000fe400078e02ffULL, 0xffffffffff267424ULL, 0x000fe200078e00ffULL,
0x0000000131317807ULL, 0x000fca0004800000ULL, 0x0000000128287824ULL, 0x000fca00078e0231ULL,
0x0000002a2800720cULL, 0x000fe20003f26070ULL, 0x00000040323d7824ULL, 0x000fe200078e00ffULL,
0x000000a02b337811ULL, 0x000fd600078e40ffULL, 0x0000000128319824ULL, 0x000fc800078e0223ULL,
0x0000600031309625ULL, 0x000fe200078e0030ULL, 0x000000332c327217ULL, 0x000fc80007800000ULL,
0x0000000630269981ULL, 0x000362000c1e1900ULL, 0x000000223d3c7210ULL, 0x040fe20007f3e0ffULL,
0x0000000132327824ULL, 0x000fe200078e0a33ULL, 0x0000001d3d5d7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e06ffULL, 0x00005e003c5c7a11ULL, 0x000fe200078240ffULL,
0x000000ffff5e7224ULL, 0x000fe200010e06ffULL, 0x0000002032327807ULL, 0x000fe40000000000ULL,
0x00005f003c3f7a11ULL, 0x000fe400008f443fULL, 0x0000001e3d337210ULL, 0x000fe40007f3e0ffULL,
0x0000003227327217ULL, 0x000fe40007800000ULL, 0x00000004ff317819ULL, 0x002fe2000001162dULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x00005e00333c7a11ULL, 0x000fe200078240ffULL,
0x00000001323e7824ULL, 0x000fe200078e0a27ULL, 0x0000001c3d3d7210ULL, 0x000fc40007f7e0ffULL,
0x00005f0033337a11ULL, 0x000fe400008f4430ULL, 0x0000001b5c307210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff627224ULL, 0x000fe200018e06ffULL, 0x00005e005d607a11ULL, 0x000fe400078440ffULL,
0x0000001b3c327210ULL, 0x000fe40007fbe0ffULL, 0x0000003e3100720cULL, 0x000fe20003f26070ULL,
0x000000ffff317224ULL, 0x000fe200020e063fULL, 0x00005f005d5e7a11ULL, 0x000fe200010f445eULL,
0x000000ffff337224ULL, 0x000fe200028e0633ULL, 0x00005e003d5c7a11ULL, 0x000fc400078440ffULL,
0x0000003e2100720cULL, 0x080fe40003f86070ULL, 0x0000003e2000720cULL, 0x080fe40003fc6070ULL,
0x0000003e1f00720cULL, 0x000fe40003fa6070ULL, 0x0000001b603c7210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000301a7faeULL, 0x0003e2000c901c46ULL,
0x00005f003d627a11ULL, 0x000fe400010f4462ULL, 0x0000001b5c3e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3d7224ULL, 0x000fc400018e065eULL, 0x0000000032197faeULL, 0x0003e4000e101c46ULL,
0x000000ffff3f7224ULL, 0x000fe400010e0662ULL, 0x000000003c187faeULL, 0x0003e8000f101c46ULL,
0x000000003e177faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff687f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff317984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106480027327f8cULL, 0x000fe2000c80043fULL,
0x8000000031ff7812ULL, 0x002fc6000784485aULL, 0x01064c00273d7984ULL, 0x000e640000000800ULL,
0x800000003dff7812ULL, 0x002fe40007824833ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002e4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x008fe40003800000ULL,
0x01064c0027317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101000016327984ULL, 0x000e680000000800ULL,
0x0103000016337984ULL, 0x0007220000000800ULL, 0x000000253200720bULL, 0x002fe20003f3d000ULL,
0x00010f627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000307806ULL, 0x008fc800008e0100ULL,
0x0000ffff303d7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff607424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000022e00780cULL, 0x000fe40003f65270ULL, 0x000000253200720bULL, 0x000fe20003f34000ULL,
0x00010f327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000307806ULL, 0x000fe400008e0100ULL,
0x0000003225317209ULL, 0x040fe40007810000ULL, 0x0000ffff30307812ULL, 0x000fe400078e3cffULL,
0x00000002ff6c7819ULL, 0x000fe2000001162dULL, 0x80000031253c7221ULL, 0x000fe20000010000ULL,
0x010500311600b388ULL, 0x0003e20000000800ULL, 0x000000303dff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b3c3c7820ULL, 0x000fc80000410000ULL, 0x0000003c005f7308ULL, 0x000ee40000000800ULL,
0x0000005f24247220ULL, 0x008fe20000410000ULL, 0x00010ed27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c5f5e7589ULL, 0x0022e400000e0000ULL, 0x0000005e54547220ULL, 0x08cfe20000410000ULL,
0x0000005e55557220ULL, 0x080fe20000410000ULL, 0x0000005e50507220ULL, 0x080fe20000410000ULL,
0x0000005e51517220ULL, 0x080fe20000410000ULL, 0x0000005e4c4c7220ULL, 0x080fe20000410000ULL,
0x0000005e4d4d7220ULL, 0x080fe20000410000ULL, 0x0000005e48487220ULL, 0x080fe20000410000ULL,
0x0000005e49497220ULL, 0x080fe20000410000ULL, 0x0000005e44447220ULL, 0x080fe20000410000ULL,
0x0000005e45457220ULL, 0x080fe20000410000ULL, 0x0000005e40407220ULL, 0x080fe20000410000ULL,
0x0000005e41417220ULL, 0x080fe20000410000ULL, 0x0000005e34347220ULL, 0x080fe20000410000ULL,
0x0000005e35357220ULL, 0x080fe20000410000ULL, 0x0000005e38387220ULL, 0x080fe20000410000ULL,
0x0000005e39397220ULL, 0x000fe20000410000ULL, 0x00010e027f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5f5e7589ULL, 0x0004e400000e0000ULL, 0x0000003225257209ULL, 0x000fe20007810000ULL,
0x0000005e56567220ULL, 0x08cfe20000410000ULL, 0x00000001ff607807ULL, 0x000fe20000800000ULL,
0x0000005e57577220ULL, 0x080fe20000410000ULL, 0x0000005e52527220ULL, 0x080fe20000410000ULL,
0x8000002532321221ULL, 0x000fe20000010000ULL, 0x0000005e53537220ULL, 0x080fe20000410000ULL,
0x0000005e4e4e7220ULL, 0x080fe20000410000ULL, 0x0000005e4f4f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b32321820ULL, 0x000fe20000410000ULL, 0x0000005e4a4a7220ULL, 0x080fe20000410000ULL,
0x0000005e4b4b7220ULL, 0x080fe20000410000ULL, 0x0000005e46467220ULL, 0x080fe20000410000ULL,
0x0000003200151308ULL, 0x000ea20000000800ULL, 0x0000005e47477220ULL, 0x080fe20000410000ULL,
0x0000005e42427220ULL, 0x080fe20000410000ULL, 0x0000005e43437220ULL, 0x080fe20000410000ULL,
0x0000005e36367220ULL, 0x080fe20000410000ULL, 0x0000005e37377220ULL, 0x080fe20000410000ULL,
0x0000005e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005e3b3b7220ULL, 0x000fe20000410000ULL,
0x0000003315331220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002433247221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff317984ULL, 0x000ee40000000800ULL,
0x8000000031ff7812ULL, 0x008fc4000782485aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x000724000021f000ULL, 0x3fa0000030307823ULL, 0x008fe200000100ffULL,
0x000000310000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff317984ULL, 0x000ee40000000800ULL,
0x8000000031ff7812ULL, 0x008fe4000782485aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff30723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x002fc4000001162dULL,
0x00005410305f7816ULL, 0x000fe20000000030ULL, 0x00010ba27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c5f677589ULL, 0x0002e400000e0000ULL, 0x00010be27f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5f5a7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0066ULL, 0x0000a370005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0001156000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0065ULL, 0x0000a3d0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0001150000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001430783bULL, 0x000f220000004200ULL, 0x0000991060607816ULL, 0x000fc600000000ffULL,
0x00000000133c783bULL, 0x000ee20000004200ULL, 0x000000ff6000720cULL, 0x000fc60003f25270ULL,
0x00000000125c783bULL, 0x016e680000004200ULL, 0x000000001160783bULL, 0x000ea20000004200ULL,
0x00000010ff937819ULL, 0x100fe40000011633ULL, 0x000000ff33737812ULL, 0x040fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe40000011633ULL, 0x0000ffff33a47812ULL, 0x000fc400078ec0ffULL,
0x00000018ff337819ULL, 0x008fe4000001163cULL, 0x000000ff3f7c7812ULL, 0x000fe400078ec0ffULL,
0x00000033ff33723eULL, 0x000fe400020006ffULL, 0x00000018ff797819ULL, 0x000fe4000001163eULL,
0x00000010ff8f7819ULL, 0x000fe20000011630ULL, 0x20000033ff827230ULL, 0x000fe20000004100ULL,
0x000000ff5c7d7812ULL, 0x002fc400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe4000001163dULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x0000007dff33723eULL, 0x000fe200020006ffULL, 0x2000007cff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x20000079ff7c7230ULL, 0x000fe20000004100ULL,
0x0000ffff30a17812ULL, 0x000fe200078ec0ffULL, 0x20000033ff797230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fc400020006ffULL, 0x000000ff3d767812ULL, 0x000fe400078ec0ffULL,
0x00000018ff947819ULL, 0x000fe2000001165cULL, 0x20000075ff7f7230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x0000ffff31a27812ULL, 0x000fe400078ec0ffULL,
0x00000008ff337819ULL, 0x000fe400000116a1ULL, 0x00000010ff927819ULL, 0x000fc40000011632ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000094ff75723eULL, 0x000fe200020006ffULL,
0x2000008fff947230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe20000011631ULL,
0x20000076ff817230ULL, 0x000fe20000004100ULL, 0x00000018ff957819ULL, 0x000fe2000001165dULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x00000033ff33723eULL, 0x000fe400020006ffULL,
0x00000008ff8f7819ULL, 0x000fc400000116a2ULL, 0x000000ff3e7a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x0000ffff32a37812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x000000ff3c747812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000072ff837230ULL, 0x000fe20000004100ULL,
0x00000018ff977819ULL, 0x000fc4000001165eULL, 0x00000095ff76723eULL, 0x000fe200020006ffULL,
0x20000033ff957230ULL, 0x000fe20000004100ULL, 0x000000ff91917812ULL, 0x000fe200078ec0ffULL,
0x20000073ff867230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x000000ff5e987812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x000000ff93937812ULL, 0x000fc400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x2000007aff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff997819ULL, 0x000fe4000001163cULL, 0x00000008ff337819ULL, 0x000fe400000116a3ULL,
0x0000ffff3ca57812ULL, 0x000fe400078ec0ffULL, 0x00000010ff9b7819ULL, 0x000fe4000001163dULL,
0x00000018ff7b7819ULL, 0x000fc4000001163fULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x000000ff5d967812ULL, 0x000fe400078ec0ffULL, 0x00000097ff72723eULL, 0x000fe200020006ffULL,
0x2000008fff977230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000074ff807230ULL, 0x000fe20000004100ULL, 0x000000ff316d7812ULL, 0x000fe200078ec0ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x000000ff5f9a7812ULL, 0x000fc400078ec0ffULL,
0x00000098ff73723eULL, 0x000fe200020006ffULL, 0x20000092ff987230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000008ff8f7819ULL, 0x000fe200000116a4ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000033ff33723eULL, 0x000fe400020006ffULL,
0x000000ff99997812ULL, 0x000fe400078ec0ffULL, 0x0000007bff7a723eULL, 0x000fc400020006ffULL,
0x000000ff9b9b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff927819ULL, 0x000fe200000116a5ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000096ff7b723eULL, 0x000fe200020006ffULL,
0x20000091ff967230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x0000009aff74723eULL, 0x000fe200020006ffULL, 0x20000093ff9a7230ULL, 0x000fe20000004100ULL,
0x00000018ff6e7819ULL, 0x000fe20000011632ULL, 0x2000006dff8c7230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000099ff91723eULL, 0x000fe200020006ffULL, 0x20000033ff997230ULL, 0x000fe20000004100ULL,
0x000000ff306b7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000018ff6a7819ULL, 0x000fc40000011630ULL, 0x00000018ff6c7819ULL, 0x000fe40000011631ULL,
0x000000ff32717812ULL, 0x000fe400078ec0ffULL, 0x000000ff609c7812ULL, 0x004fe400078ec0ffULL,
0x000000ff619d7812ULL, 0x000fe400078ec0ffULL, 0x0000009bff93723eULL, 0x000fe200020006ffULL,
0x2000008fff9b7230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fc400020006ffULL,
0x0000ffff3d327812ULL, 0x000fe400078ec0ffULL, 0x00000010ff317819ULL, 0x000fe2000001163eULL,
0x20000092ff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fe4000001163fULL,
0x0000b00010337811ULL, 0x000fe400078e20ffULL, 0x00000010ff8d7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d887812ULL, 0x000fc400078ec0ffULL, 0x0000006eff5d723eULL, 0x000fe400020006ffULL,
0x0000009cff6d723eULL, 0x000fe200020006ffULL, 0x20000091ff9c7230ULL, 0x000fe20000004100ULL,
0x0000009dff6e723eULL, 0x000fe200020006ffULL, 0x20000093ff9d7230ULL, 0x000fe20000004100ULL,
0x00000008ff917819ULL, 0x000fe20000011632ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff31927812ULL, 0x000fe200078ec0ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff30937812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x000000003330783bULL, 0x000e620000000200ULL, 0x00000010ff847819ULL, 0x000fc4000001165eULL,
0x0000ffff5e3c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x100fe4000001165fULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x0000ffff3e8e7812ULL, 0x000fe400078ec0ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000071ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fc4000001165fULL, 0x0000ffff5f3e7812ULL, 0x000fe200078ec0ffULL,
0x2000005eff717230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fe4000001165cULL,
0x00000018ff5f7819ULL, 0x000fe40000011660ULL, 0x00000018ff9f7819ULL, 0x000fe40000011663ULL,
0x0000ffff3f907812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5c877812ULL, 0x000fc400078ec0ffULL,
0x000000ff629e7812ULL, 0x000fe400078ec0ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff5c7819ULL, 0x000fe20000011660ULL,
0x2000006bff8b7230ULL, 0x000fe20000004100ULL, 0x0000ffff60787812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fc400020006ffULL, 0x0000009fff5e723eULL, 0x000fe200020006ffULL,
0x0000006730309231ULL, 0x082fe200003400ffULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x2000005fff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff777819ULL, 0x100fe20000011661ULL,
0x0000006732329231ULL, 0x000fe200003400ffULL, 0x00000018ff607819ULL, 0x000fe20000011661ULL,
0x0000005a31319231ULL, 0x080fe200003400ffULL, 0x0000ffff616f7812ULL, 0x000fe200078ec0ffULL,
0x0000005a33339231ULL, 0x000fe200003400ffULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff9f7819ULL, 0x000fc40000011690ULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x20000092ff907230ULL, 0x000fe20000004100ULL,
0x00000018ff617819ULL, 0x000fe40000011662ULL, 0x0000009eff9e723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x20000093ff927230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x0000009fff9f723eULL, 0x000fe200020006ffULL,
0x2000008eff937230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000089ff8e7230ULL, 0x000fe20000004100ULL, 0x00000061ff5f723eULL, 0x000fe200020006ffULL,
0x2000009eff617230ULL, 0x000fe20000004100ULL, 0x000000ff3d3d7812ULL, 0x000fe200078ec0ffULL,
0x20000091ff9e7230ULL, 0x000fe20000004100ULL, 0x0000006aff3f723eULL, 0x000fe200020006ffULL,
0x20000087ff897230ULL, 0x000fe20000004100ULL, 0x000000ff8d917812ULL, 0x000fe200078ec0ffULL,
0x2000009fff8d7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x0000003dff87723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff9f7819ULL, 0x000fe2000001163cULL,
0x2000006cff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe2000001168bULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fc40000011694ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff8b7819ULL, 0x000fe40000011696ULL,
0x000010543d3c7816ULL, 0x000fe4000000003cULL, 0x000010548b3d7816ULL, 0x000fe4000000008cULL,
0x00000008ff8b7819ULL, 0x000fe4000001163eULL, 0x00000010ff3f7819ULL, 0x000fc4000001163fULL,
0x00000010ff3e7819ULL, 0x000fe20000011695ULL, 0x0000003c3054723cULL, 0x000fe20000041854ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168aULL, 0x00000010ff977819ULL, 0x000fe40000011697ULL,
0x000010543f3e7816ULL, 0x000fe4000000003eULL, 0x000010548c3f7816ULL, 0x000fe40000000097ULL,
0x0000008bff94723eULL, 0x000fc400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe40000011685ULL,
0x00000010ff3d7819ULL, 0x000fe20000011698ULL, 0x0000003e3050723cULL, 0x000fe20000041850ULL,
0x00000010ff867819ULL, 0x000fe20000011686ULL, 0x20000094ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe4000001169aULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000010543d3c7816ULL, 0x000fc4000000003cULL, 0x000010548b3d7816ULL, 0x000fe40000000086ULL,
0x0000005cff8c723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff3e7819ULL, 0x000fe20000011683ULL, 0x0000003c304c723cULL, 0x000fe2000004184cULL,
0x00000010ff5c7819ULL, 0x000fe20000011699ULL, 0x2000008cff837230ULL, 0x000fe20000004100ULL,
0x0000b0000f3f7811ULL, 0x000fc400078e20ffULL, 0x00000010ff9b7819ULL, 0x000fe4000001169bULL,
0x000010545d5c7816ULL, 0x000fe4000000005cULL, 0x000010543e5d7816ULL, 0x000fe4000000009bULL,
0x000000003f3c783bULL, 0x000e620000000200ULL, 0x000000ff778b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x0000005c3048723cULL, 0x000fe20000041848ULL,
0x00000010ff777819ULL, 0x000fc4000001169cULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff9e7819ULL, 0x000fe4000001169eULL, 0x00000010ff5d7819ULL, 0x000fe40000011682ULL,
0x00000010ff5c7819ULL, 0x000fe4000001168fULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff927819ULL, 0x000fc40000011692ULL, 0x000010545d5c7816ULL, 0x000fe4000000005cULL,
0x00000008ff887819ULL, 0x000fe40000011688ULL, 0x00000008ff867819ULL, 0x000fe40000011678ULL,
0x0000105477807816ULL, 0x000fe40000000080ULL, 0x000010547f5d7816ULL, 0x000fe4000000009eULL,
0x00000010ff817819ULL, 0x000fc40000011681ULL, 0x00000010ff787819ULL, 0x000fe4000001169dULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x0000005c3040723cULL, 0x000fe20000041840ULL,
0x00000010ff777819ULL, 0x000fe40000011690ULL, 0x00001054927f7816ULL, 0x000fe4000000007dULL,
0x00000010ff7c7819ULL, 0x000fe2000001167cULL, 0x000000673c3c9231ULL, 0x082fe200003400ffULL,
0x00000010ff937819ULL, 0x000fe20000011693ULL, 0x000000673e3e9231ULL, 0x000fe200003400ffULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x0000005a3d3d9231ULL, 0x080fe200003400ffULL,
0x00000010ff7d7819ULL, 0x000fe2000001168dULL, 0x0000005a3f3f9231ULL, 0x000fe200003400ffULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x0000105478817816ULL, 0x000fe40000000081ULL,
0x00001054777e7816ULL, 0x000fe2000000007eULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000010547c7c7816ULL, 0x000fe40000000093ULL, 0x000010547a7d7816ULL, 0x000fe2000000007dULL,
0x000000803044723cULL, 0x000fe20000041844ULL, 0x00000010ff707819ULL, 0x000fe40000011662ULL,
0x0000ffff626a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe40000011663ULL,
0x000000ff63a07812ULL, 0x040fe200078ec0ffULL, 0x0000007e3034723cULL, 0x040fe20000041834ULL,
0x0000ffff63637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x0000007c3030723cULL, 0x000fe20000041838ULL, 0x0000009fff9f723eULL, 0x000fc400020006ffULL,
0x000000ff84847812ULL, 0x000fe200078ec0ffULL, 0x20000060ff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x2000009fff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe40000011675ULL, 0x00000010ff397819ULL, 0x000fe40000011688ULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x000000ff62627812ULL, 0x000fc400078ec0ffULL,
0x0000105438387816ULL, 0x000fe40000000089ULL, 0x0000105476397816ULL, 0x000fe40000000039ULL,
0x00000008ff6a7819ULL, 0x000fe4000001166aULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x000000a0ff60723eULL, 0x000fe200020006ffULL, 0x000000383c50723cULL, 0x000fe20000041850ULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x2000008bff787230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe20000011672ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe20000011671ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fc4000001168aULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00001054398a7816ULL, 0x000fe4000000008aULL,
0x00001054388b7816ULL, 0x000fe40000000085ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff8e7819ULL, 0x000fe2000001168eULL,
0x0000008a3c48723cULL, 0x000fe20000041848ULL, 0x00000010ff5c7819ULL, 0x000fc40000011691ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff3b7819ULL, 0x000fe40000011674ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff5a7819ULL, 0x000fe40000011687ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff397819ULL, 0x000fc4000001166eULL,
0x00000010ff387819ULL, 0x000fe40000011683ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6f7819ULL, 0x000fc4000001166fULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff717819ULL, 0x000fe40000011662ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x000010548e8e7816ULL, 0x000fe40000000079ULL, 0x000010545c8f7816ULL, 0x000fe4000000007bULL,
0x00001054843a7816ULL, 0x000fe40000000073ULL, 0x000010545a3b7816ULL, 0x000fc4000000003bULL,
0x0000105438387816ULL, 0x000fe2000000006dULL, 0x0000008e3c54723cULL, 0x040fe20000041854ULL,
0x0000105478397816ULL, 0x000fe40000000039ULL, 0x000010546b867816ULL, 0x000fe40000000086ULL,
0x000010546c877816ULL, 0x000fe4000000006fULL, 0x0000105470707816ULL, 0x000fe20000000061ULL,
0x0000003a3c4c723cULL, 0x000fe2000004184cULL, 0x0000105471717816ULL, 0x000fc40000000060ULL,
0x000010545f6a7816ULL, 0x000fe4000000006aULL, 0x000010545e6b7816ULL, 0x000fc60000000063ULL,
0x000000383c44723cULL, 0x040ff00000041844ULL, 0x000000863c40723cULL, 0x040ff00000041840ULL,
0x000000703c34723cULL, 0x040ff00000041834ULL, 0x0000006a3c3c723cULL, 0x000fe20000041830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff327f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844833ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000580026307a24ULL, 0x020fe200078e02ffULL, 0x000000c02b317811ULL, 0x000fc600078e40ffULL,
0x0000004030327824ULL, 0x000fe200078e00ffULL, 0x000000312c307217ULL, 0x000fc80007800000ULL,
0x0000000e32337210ULL, 0x000fe20007f5e0ffULL, 0x0000000130307824ULL, 0x000fe200078e0a31ULL,
0x0000000d32397210ULL, 0x000fe40007f7e0ffULL, 0x00000004ff317819ULL, 0x000fe2000001162dULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x00005e00335a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e00395c7a11ULL, 0x000fe400078640ffULL,
0x00005f0033337a11ULL, 0x000fc400010f4438ULL, 0x0000000c32387210ULL, 0x040fe40007f5e0ffULL,
0x00005f0039397a11ULL, 0x000fe400018f443aULL, 0x0000000b32327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x0000002030307807ULL, 0x000fe40000000000ULL,
0x00005e00385e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff5d7224ULL, 0x000fe200018e06ffULL,
0x0000003027307217ULL, 0x000fc40007800000ULL, 0x00005e0032607a11ULL, 0x000fe400078640ffULL,
0x00005f00383b7a11ULL, 0x000fe200010f443bULL, 0x00000001303a7824ULL, 0x000fe200078e0a27ULL,
0x00005f00325d7a11ULL, 0x000fe400018f445dULL, 0x0000001b5a307210ULL, 0x080fe40007f7e0ffULL,
0x0000001b5c327210ULL, 0x080fe40007f9e0ffULL, 0x0000001b5e387210ULL, 0x000fc40007fbe0ffULL,
0x0000003a3100720cULL, 0x080fe20003f46070ULL, 0x000000ffff317224ULL, 0x000fe200018e0633ULL,
0x0000003a2100720cULL, 0x080fe20003f66070ULL, 0x000000ffff337224ULL, 0x000fe200020e0639ULL,
0x0000003a2000720cULL, 0x080fe20003f86070ULL, 0x000000ffff397224ULL, 0x000fe200028e063bULL,
0x0000003a1f00720cULL, 0x000fe40003fa6070ULL, 0x0000001b603a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e065dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000300a7faeULL, 0x0003e8000d101c46ULL, 0x0000000032097faeULL, 0x0003e8000d901c46ULL,
0x0000000038087faeULL, 0x0003e8000e101c46ULL, 0x000000003a077faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e0031ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff30723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x000fe4000001162dULL,
0x00005410305f7816ULL, 0x000fe20000000030ULL, 0x0000ef127f007947ULL, 0x000fea000b800000ULL,
0x00001f6c5f677589ULL, 0x0002a400000e0000ULL, 0x0000ef527f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5f687589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0066ULL, 0x0000c0d0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0000f80000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0065ULL, 0x0000c130005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0000f7a000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000630783bULL, 0x000f680000004200ULL, 0x000000000538783bULL, 0x000e680000004200ULL,
0x00000000045c783bULL, 0x00ee680000004200ULL, 0x000000000360783bULL, 0x000ea20000004200ULL,
0x00000010ff947819ULL, 0x020fc40000011631ULL, 0x000000ff316c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe40000011631ULL, 0x0000ffff31a27812ULL, 0x000fe400078ec0ffULL,
0x00000018ff317819ULL, 0x000fe40000011632ULL, 0x0000ffff30a17812ULL, 0x000fe400078ec0ffULL,
0x00000031ff31723eULL, 0x000fc400020006ffULL, 0x00000010ff957819ULL, 0x000fe40000011632ULL,
0x000000ff326e7812ULL, 0x040fe200078ec0ffULL, 0x20000031ff737230ULL, 0x000fe20000004100ULL,
0x0000ffff32a37812ULL, 0x000fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe40000011639ULL,
0x00000010ff327819ULL, 0x000fe40000011633ULL, 0x000000ff33707812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011633ULL, 0x0000ffff33a47812ULL, 0x000fe400078ec0ffULL,
0x00000018ff337819ULL, 0x000fe40000011638ULL, 0x00000008ff317819ULL, 0x000fe400000116a1ULL,
0x000000ff3a797812ULL, 0x000fe400078ec0ffULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x00000018ff937819ULL, 0x002fe4000001165cULL, 0x00000033ff33723eULL, 0x000fe200020006ffULL,
0x20000074ff7e7230ULL, 0x000fe20000004100ULL, 0x00000031ff31723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000033ff7f7230ULL, 0x000fe20000004100ULL,
0x00000018ff7a7819ULL, 0x000fe4000001163bULL, 0x00000093ff74723eULL, 0x000fe200020006ffULL,
0x20000031ff937230ULL, 0x000fe20000004100ULL, 0x000000ff5d977812ULL, 0x000fe200078ec0ffULL,
0x20000079ff7d7230ULL, 0x000fe20000004100ULL, 0x00000008ff317819ULL, 0x000fe200000116a2ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000000ff32337812ULL, 0x000fc400078ec0ffULL,
0x000000ff3b7b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff38717812ULL, 0x000fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe4000001163aULL, 0x0000007aff79723eULL, 0x000fe400020006ffULL,
0x000000ff5c967812ULL, 0x000fe400078ec0ffULL, 0x00000097ff7a723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x000000ff95957812ULL, 0x000fc400078ec0ffULL,
0x00000031ff31723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000033ff97723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000008ff337819ULL, 0x000fe400000116a3ULL, 0x00000010ff9a7819ULL, 0x000fe20000011639ULL,
0x2000007bff7c7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000010ff997819ULL, 0x000fe20000011638ULL,
0x20000071ff807230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000078ff7b7230ULL, 0x000fe20000004100ULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x000000ff5e987812ULL, 0x000fe200078ec0ffULL, 0x20000070ff857230ULL, 0x000fe20000004100ULL,
0x00000095ff32723eULL, 0x000fe200020006ffULL, 0x20000031ff957230ULL, 0x000fe20000004100ULL,
0x000000ff5f9b7812ULL, 0x000fe200078ec0ffULL, 0x20000096ff787230ULL, 0x000fe20000004100ULL,
0x00000033ff33723eULL, 0x000fe200020006ffULL, 0x20000032ff967230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x000fc40000011630ULL, 0x000000ff306a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff697819ULL, 0x000fe40000011630ULL, 0x00000008ff317819ULL, 0x000fe400000116a4ULL,
0x000000ff9a9a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff38307812ULL, 0x000fe400078ec0ffULL,
0x000000ff99997812ULL, 0x000fc400078ec0ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000098ff71723eULL, 0x000fe200020006ffULL, 0x20000097ff987230ULL, 0x000fe20000004100ULL,
0x0000009bff70723eULL, 0x000fe200020006ffULL, 0x20000033ff977230ULL, 0x000fe20000004100ULL,
0x000000ff609c7812ULL, 0x004fe200078ec0ffULL, 0x2000006bff877230ULL, 0x000fe20000004100ULL,
0x00000031ff32723eULL, 0x000fe200020006ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x0000009aff9b723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000099ff33723eULL, 0x000fe200020006ffULL, 0x20000032ff997230ULL, 0x000fe20000004100ULL,
0x0000b00002317811ULL, 0x000fc400078e20ffULL, 0x00000008ff307819ULL, 0x000fe20000011630ULL,
0x20000033ff9a7230ULL, 0x000fe20000004100ULL, 0x0000009cff6b723eULL, 0x000fe200020006ffULL,
0x2000009bff9c7230ULL, 0x000fe20000004100ULL, 0x00000030ff9b723eULL, 0x000fe400020006ffULL,
0x000000003130783bULL, 0x000e620000000200ULL, 0x00000010ff897819ULL, 0x000fe2000001165cULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x0000ffff5c867812ULL, 0x000fe200078ec0ffULL,
0x2000009bff9b7230ULL, 0x000fe20000004100ULL, 0x00000010ff8c7819ULL, 0x000fc4000001165dULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d887812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000ffff39917812ULL, 0x000fe400078ec0ffULL, 0x00000010ff907819ULL, 0x000fe2000001163aULL,
0x2000006eff847230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x0000ffff3a8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8f7819ULL, 0x000fe2000001163bULL,
0x2000005dff6e7230ULL, 0x000fe20000004100ULL, 0x00000018ff9e7819ULL, 0x000fe40000011662ULL,
0x0000ffff3b8e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x00000008ff917819ULL, 0x000fc40000011691ULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8d7819ULL, 0x000fe2000001168dULL, 0x0000006730309231ULL, 0x082fe200003400ffULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x0000006732329231ULL, 0x000fe200003400ffULL,
0x0000009eff5d723eULL, 0x000fe200020006ffULL, 0x0000006831319231ULL, 0x090fe200003400ffULL,
0x000000ff89897812ULL, 0x000fe200078ec0ffULL, 0x2000006aff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff9e7819ULL, 0x000fe2000001168eULL, 0x0000006833339231ULL, 0x000fe200003400ffULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff39757812ULL, 0x000fc400078ec0ffULL, 0x000000ff619d7812ULL, 0x000fe400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe4000001165fULL, 0x0000006cff8b723eULL, 0x000fe200020006ffULL,
0x20000090ff8e7230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fc400020006ffULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000008fff907230ULL, 0x000fe20000004100ULL,
0x0000009eff9e723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000009dff6a723eULL, 0x000fe200020006ffULL, 0x20000091ff9d7230ULL, 0x000fe20000004100ULL,
0x0000ffff5e387812ULL, 0x000fe200078ec0ffULL, 0x2000008dff917230ULL, 0x000fe20000004100ULL,
0x000000ff39397812ULL, 0x000fe200078ec0ffULL, 0x20000089ff8d7230ULL, 0x000fe20000004100ULL,
0x00000069ff3b723eULL, 0x000fe200020006ffULL, 0x20000086ff897230ULL, 0x000fe20000004100ULL,
0x000000ff8c8f7812ULL, 0x000fe200078ec0ffULL, 0x2000009eff8c7230ULL, 0x000fe20000004100ULL,
0x00000039ff86723eULL, 0x000fe200020006ffULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000008ff9e7819ULL, 0x000fe20000011638ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe2000001168aULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fc40000011692ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x0000ffff5f3a7812ULL, 0x000fe400078ec0ffULL,
0x0000105439387816ULL, 0x000fe40000000038ULL, 0x0000105494397816ULL, 0x000fe4000000008bULL,
0x00000008ff8b7819ULL, 0x000fc4000001163aULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x00000010ff3a7819ULL, 0x000fe20000011693ULL, 0x000000383054723cULL, 0x000fe20000041854ULL,
0x00000010ff8a7819ULL, 0x000fe40000011687ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff727819ULL, 0x000fe40000011660ULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x000010543b3a7816ULL, 0x000fe4000000003aULL, 0x000010548a3b7816ULL, 0x000fe20000000095ULL,
0x2000006fff827230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe40000011684ULL,
0x00000010ff397819ULL, 0x000fe40000011696ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x0000003a3050723cULL, 0x000fe20000041850ULL, 0x00000010ff857819ULL, 0x000fc40000011685ULL,
0x00000010ff987819ULL, 0x000fe40000011698ULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x00000072ff8a723eULL, 0x000fe400020006ffULL, 0x0000105498397816ULL, 0x000fe40000000085ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff727819ULL, 0x000fc40000011697ULL,
0x00000010ff3a7819ULL, 0x000fe20000011682ULL, 0x00000038304c723cULL, 0x000fe2000004184cULL,
0x00000010ff997819ULL, 0x000fe20000011699ULL, 0x2000008aff827230ULL, 0x000fe20000004100ULL,
0x0000b000003b7811ULL, 0x000fe400078e20ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x0000105473727816ULL, 0x000fe40000000072ULL, 0x000010543a737816ULL, 0x000fe20000000099ULL,
0x20000075ff817230ULL, 0x000fe20000004100ULL, 0x0000ffff60777812ULL, 0x000fe200078ec0ffULL,
0x000000003b38783bULL, 0x000e620000000200ULL, 0x00000010ff767819ULL, 0x000fc40000011661ULL,
0x00000008ff857819ULL, 0x000fe20000011677ULL, 0x000000723048723cULL, 0x000fe20000041848ULL,
0x000000ff768a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x000fe40000011680ULL,
0x00000010ff777819ULL, 0x000fe4000001169aULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff9c7819ULL, 0x000fc4000001169cULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff727819ULL, 0x000fe4000001169bULL,
0x00000010ff737819ULL, 0x000fe4000001169dULL, 0x0000105477767816ULL, 0x000fe40000000076ULL,
0x000010549c777816ULL, 0x000fc40000000081ULL, 0x000010547f727816ULL, 0x000fe40000000072ULL,
0x000010547e737816ULL, 0x000fe40000000073ULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x000000763044723cULL, 0x000fe20000041844ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000008ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff837819ULL, 0x000fc4000001165eULL,
0x00000010ff777819ULL, 0x000fe2000001167cULL, 0x000000723040723cULL, 0x000fe20000041840ULL,
0x000010548e767816ULL, 0x000fe2000000007dULL, 0x0000006738389231ULL, 0x082fe200003400ffULL,
0x00000010ff907819ULL, 0x000fe20000011690ULL, 0x000000673a3a9231ULL, 0x000fe200003400ffULL,
0x00000010ff7c7819ULL, 0x000fe2000001167bULL, 0x0000006839399231ULL, 0x080fe200003400ffULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x000000683b3b9231ULL, 0x000fe200003400ffULL,
0x00000010ff727819ULL, 0x000fc40000011679ULL, 0x00000010ff7d7819ULL, 0x000fe4000001168cULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000000ff83837812ULL, 0x000fe200078ec0ffULL, 0x2000005cff757230ULL, 0x000fe20000004100ULL,
0x0000105490777816ULL, 0x000fe20000000077ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000010547c7c7816ULL, 0x000fc40000000091ULL, 0x00001054727d7816ULL, 0x000fe4000000007dULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x000000763034723cULL, 0x040fe20000041834ULL,
0x0000ffff616c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001165fULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000018ff5f7819ULL, 0x000fe40000011660ULL,
0x00000018ff607819ULL, 0x000fe20000011661ULL, 0x0000007c303c723cULL, 0x000fe2000004183cULL,
0x00000008ff6c7819ULL, 0x000fc4000001166cULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff307819ULL, 0x000fe20000011675ULL,
0x2000005eff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe40000011688ULL,
0x00000010ff317819ULL, 0x000fe40000011670ULL, 0x0000105430757816ULL, 0x000fc40000000075ULL,
0x00000010ff307819ULL, 0x000fe40000011683ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x000000ff62617812ULL, 0x000fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fe20000011662ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x0000ffff62697812ULL, 0x000fe200078ec0ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000105430307816ULL, 0x000fe40000000071ULL, 0x0000105486317816ULL, 0x000fe40000000031ULL,
0x00000010ff627819ULL, 0x000fc40000011663ULL, 0x000000ff63a07812ULL, 0x040fe400078ec0ffULL,
0x00000018ff9f7819ULL, 0x000fe20000011663ULL, 0x00000030384c723cULL, 0x000fe2000004184cULL,
0x0000ffff63637812ULL, 0x000fe400078ec0ffULL, 0x00000061ff5e723eULL, 0x000fe200020006ffULL,
0x2000005fff617230ULL, 0x000fe20000004100ULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fc40000011669ULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff307819ULL, 0x000fe40000011661ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff317819ULL, 0x000fe4000001166cULL,
0x000000a0ff5f723eULL, 0x000fc400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x0000009eff9e723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000009eff877230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000008bff847230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x0000009fff5c723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000105430307816ULL, 0x000fe20000000085ULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x0000105460317816ULL, 0x000fe20000000031ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fc4000001167aULL, 0x00000010ff327819ULL, 0x000fe4000001166fULL,
0x00000010ff787819ULL, 0x000fe20000011678ULL, 0x000000303840723cULL, 0x000fe20000041840ULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff7a7819ULL, 0x000fe4000001168fULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff6f7819ULL, 0x000fe40000011684ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff837819ULL, 0x000fe4000001168aULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff307819ULL, 0x000fc4000001165dULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff317819ULL, 0x000fe40000011663ULL, 0x000010548d787816ULL, 0x000fe40000000078ULL,
0x000010547a797816ULL, 0x000fe40000000079ULL, 0x0000105474747816ULL, 0x000fc40000000089ULL,
0x000010546e6e7816ULL, 0x000fe40000000087ULL, 0x00001054326f7816ULL, 0x000fe2000000006fULL,
0x000000783854723cULL, 0x040fe20000041854ULL, 0x0000105482827816ULL, 0x000fe4000000006bULL,
0x0000105483837816ULL, 0x000fe4000000006aULL, 0x000010546d5e7816ULL, 0x000fe4000000005eULL,
0x00001054625f7816ULL, 0x000fe2000000005fULL, 0x000000743850723cULL, 0x000fe20000041850ULL,
0x0000105430307816ULL, 0x000fc40000000069ULL, 0x000010545c317816ULL, 0x000fca0000000031ULL,
0x0000006e3848723cULL, 0x040ff00000041848ULL, 0x000000823844723cULL, 0x040ff00000041844ULL,
0x0000005e3834723cULL, 0x040ff00000041834ULL, 0x000000303838723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff307f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c02b337811ULL, 0x000fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000332c00720cULL, 0x000fda0003f24070ULL, 0x0000416000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff307984ULL, 0x002e640000000800ULL, 0x8000000030ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff307984ULL, 0x000e640000000800ULL,
0x8000000030ff7812ULL, 0x002fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000327305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000320000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff327984ULL, 0x000e640000000800ULL,
0x8000000032ff7812ULL, 0x002fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff307424ULL, 0x000fe200078e00ffULL, 0x0000000328327812ULL, 0x000fe200078ec0ffULL,
0x00000300ff317624ULL, 0x000fe400078e00ffULL, 0x00005800263c7a24ULL, 0x000fe200078e02ffULL,
0x000000033200780cULL, 0x000fe20003f25270ULL, 0xfffffffd30317424ULL, 0x000fe200078e0231ULL,
0x000000e02b337811ULL, 0x000fe200078e40ffULL, 0xffffffffff267424ULL, 0x000fc600078e00ffULL,
0x0000000131317807ULL, 0x000fca0004800000ULL, 0x0000000128287824ULL, 0x000fca00078e0231ULL,
0x0000002a2800720cULL, 0x000fe40003f26070ULL, 0x000000332c327217ULL, 0x000fe20007800000ULL,
0x000000403c3d7824ULL, 0x000fc800078e00ffULL, 0x0000000132327824ULL, 0x000fe200078e0a33ULL,
0x000000223d227210ULL, 0x000fca0007f5e0ffULL, 0x0000000128319824ULL, 0x000fe200078e0223ULL,
0x0000002032327807ULL, 0x000fc60000000000ULL, 0x0000600031309625ULL, 0x000fe200078e0030ULL,
0x0000001e3d1e7210ULL, 0x040fe40007f7e0ffULL, 0x0000001d3d3c7210ULL, 0x000fe40007f9e0ffULL,
0x0000003227327217ULL, 0x000fe20007800000ULL, 0x0000000630269981ULL, 0x000362000c1e1900ULL,
0x0000001c3d3f7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x00005e00221c7a11ULL, 0x000fe200078040ffULL, 0x000000ffff3d7224ULL, 0x000fe200020e06ffULL,
0x00000004ff1d7819ULL, 0x000fe2000001162dULL, 0x0000000132327824ULL, 0x000fe200078e0a27ULL,
0x00005e003c3e7a11ULL, 0x000fc400078640ffULL, 0x0000001b1c1c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x002fe200010e06ffULL, 0x00005e001e307a11ULL, 0x000fe400078440ffULL,
0x00005f003c3d7a11ULL, 0x000fe400018f443dULL, 0x00005f0022317a11ULL, 0x000fe400000f4431ULL,
0x00005f001e337a11ULL, 0x000fe200010f4433ULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x000000321d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff1d7224ULL, 0x000fe200020e0631ULL,
0x00005e003f3c7a11ULL, 0x000fc400078240ffULL, 0x000000322100720cULL, 0x080fe40003f66070ULL,
0x000000322000720cULL, 0x080fe40003fa6070ULL, 0x000000321f00720cULL, 0x000fe40003f86070ULL,
0x0000001b30307210ULL, 0x080fe40007f5e0ffULL, 0x0000001b3e327210ULL, 0x080fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1a7faeULL, 0x0003e2000c101c46ULL,
0x00005f003f1e7a11ULL, 0x000fe200008f441eULL, 0x000000ffff317224ULL, 0x000fe200010e0633ULL,
0x0000001b3c3c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x000fc600030e063dULL,
0x0000000030197faeULL, 0x0003e2000d901c46ULL, 0x000000ffff3d7224ULL, 0x000fc600008e061eULL,
0x0000000032187faeULL, 0x0003e8000e901c46ULL, 0x000000003c177faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff187f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff177984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01066800271c7f8cULL, 0x000fe2000c80043fULL, 0x8000000017ff7812ULL, 0x004fc6000780485aULL,
0x01066c0027317984ULL, 0x000ea40000000800ULL, 0x8000000031ff7812ULL, 0x004fe4000782481dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff177424ULL, 0x000fc800078e00ffULL,
0x00000017001a7305ULL, 0x0004e4000021f000ULL, 0x3fa0000017177823ULL, 0x004fe200000100ffULL,
0x0000001a0000735dULL, 0x008fe20003800000ULL, 0x01066c0027317984ULL, 0x000ea40000000800ULL,
0x8000000031ff7812ULL, 0x004fc4000782481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01018000161a7984ULL, 0x000ea80000000800ULL, 0x0103800016177984ULL, 0x0007220000000800ULL,
0x000000251a00720bULL, 0x004fe20003f3d000ULL, 0x0000d1027f007947ULL, 0x000fd8000b800000ULL,
0x00000000001c7806ULL, 0x008fc800008e0100ULL, 0x0000ffff1c1e7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000032e00780cULL, 0x000fe40003f45270ULL,
0x000000251a00720bULL, 0x000fe20003f34000ULL, 0x0000d0d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001c7806ULL, 0x000fe400008e0100ULL, 0x0000001a25317209ULL, 0x000fe40007810000ULL,
0x00000002ff6c7819ULL, 0x000fc6000001162dULL, 0x80000031251d7221ULL, 0x000fe20000010000ULL,
0x010580311600a388ULL, 0x0005e20000000800ULL, 0x0000ffff1c257812ULL, 0x000fe400078e3cffULL,
0x3fb8aa3b1d1d7820ULL, 0x000fe40000410000ULL, 0x000000251eff7212ULL, 0x000fe4000782c0ffULL,
0x0000001d005f7308ULL, 0x000ee40000000800ULL, 0x0000005f24247220ULL, 0x008fe20000410000ULL,
0x0000d0727f007947ULL, 0x000fec000b800000ULL, 0x00001f6c5f5e7589ULL, 0x0044e400000e0000ULL,
0x0000005e54547220ULL, 0x08cfe20000410000ULL, 0x0000005e55557220ULL, 0x080fe20000410000ULL,
0x0000005e50507220ULL, 0x080fe20000410000ULL, 0x0000005e51517220ULL, 0x080fe20000410000ULL,
0x0000005e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000005e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000005e48487220ULL, 0x080fe20000410000ULL, 0x0000005e49497220ULL, 0x080fe20000410000ULL,
0x0000005e44447220ULL, 0x080fe20000410000ULL, 0x0000005e45457220ULL, 0x080fe20000410000ULL,
0x0000005e40407220ULL, 0x080fe20000410000ULL, 0x0000005e41417220ULL, 0x080fe20000410000ULL,
0x0000005e34347220ULL, 0x080fe20000410000ULL, 0x0000005e35357220ULL, 0x080fe20000410000ULL,
0x0000005e38387220ULL, 0x080fe20000410000ULL, 0x0000005e39397220ULL, 0x000fe20000410000ULL,
0x0000cfa27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5f5e7589ULL, 0x0004e400000e0000ULL,
0x800000311a1a1221ULL, 0x100fe20000010000ULL, 0x00000001ff1c7807ULL, 0x000fe20000800000ULL,
0x0000005e56567220ULL, 0x08cfe20000410000ULL, 0x0000005e57577220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b1a1a1820ULL, 0x000fe20000410000ULL, 0x0000005e52527220ULL, 0x080fe20000410000ULL,
0x0000005e53537220ULL, 0x080fe20000410000ULL, 0x0000005e4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001a00151308ULL, 0x000ea20000000800ULL, 0x0000005e4f4f7220ULL, 0x080fe20000410000ULL,
0x0000005e4a4a7220ULL, 0x080fe20000410000ULL, 0x0000005e4b4b7220ULL, 0x080fe20000410000ULL,
0x0000005e46467220ULL, 0x080fe20000410000ULL, 0x0000005e47477220ULL, 0x080fe20000410000ULL,
0x0000005e42427220ULL, 0x080fe20000410000ULL, 0x0000005e43437220ULL, 0x080fe20000410000ULL,
0x0000005e36367220ULL, 0x080fe20000410000ULL, 0x0000005e37377220ULL, 0x080fe20000410000ULL,
0x0000005e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005e3b3b7220ULL, 0x000fe20000410000ULL,
0x000000ffff257224ULL, 0x000fe200078e0031ULL, 0x0000001715171220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002417247221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fc4000780485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff167424ULL, 0x000fc800078e00ffULL, 0x0000001600177305ULL, 0x0004e4000021f000ULL,
0x3fa0000016167823ULL, 0x004fe200000100ffULL, 0x000000170000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fe4000780485aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000015ff16723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x002fc4000001162dULL, 0x00005410165f7816ULL, 0x000fe20000000016ULL,
0x0000cd427f007947ULL, 0x000fea000b800000ULL, 0x00001f6c5f177589ULL, 0x0002a400000e0000ULL,
0x0000cd827f007947ULL, 0x000fea000b800000ULL, 0x00001f2f5f167589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0066ULL,
0x0000e4c0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0000d41000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e0065ULL,
0x0000e520005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0000d3b000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001460783bULL, 0x000e620000004200ULL,
0x000099101c1a7816ULL, 0x000fc400000000ffULL, 0x0000b80010107811ULL, 0x000fe200078e20ffULL,
0x00000000135c783bULL, 0x00ee620000004200ULL, 0x000000ff1a00720cULL, 0x000fe40003f05270ULL,
0x0000b8000f0f7811ULL, 0x000fe200078e20ffULL, 0x00000000123c783bULL, 0x000ea80000004200ULL,
0x000000001130783bULL, 0x0007220000004200ULL, 0x000000ff601c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff827819ULL, 0x100fe40000011662ULL, 0x000000ff625a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff227819ULL, 0x000fe40000011662ULL, 0x0000ffff62957812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x000fe40000011663ULL, 0x000000ff63647812ULL, 0x000fc400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011663ULL, 0x0000ffff63967812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x102fe4000001165cULL, 0x000000ff5c677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe4000001165cULL, 0x0000ffff5c977812ULL, 0x000fc400078ec0ffULL,
0x00000010ff897819ULL, 0x100fe4000001165dULL, 0x000000ff5d687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d987812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x000fe4000001165eULL, 0x000000ff5e697812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x0000ffff5e7f7812ULL, 0x000fe400078ec0ffULL,
0x0000001cff11723eULL, 0x008fe400020006ffULL, 0x00000018ff5e7819ULL, 0x100fe4000001165fULL,
0x000000ff3d6f7812ULL, 0x004fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fc4000001165fULL,
0x000000ff5f6a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f807812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x100fe4000001163cULL, 0x000000ff3c6c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c7b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1d7819ULL, 0x000fe40000011660ULL, 0x00000010ff3c7819ULL, 0x110fe40000011630ULL,
0x000000ff308a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff877819ULL, 0x000fe40000011630ULL,
0x0000ffff305f7812ULL, 0x000fe200078ec0ffULL, 0x20000011ff307230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x0000006fff11723eULL, 0x000fe200020006ffULL, 0x2000005dff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5d7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000011ff5e7230ULL, 0x000fe20000004100ULL,
0x00000018ff137819ULL, 0x000fe40000011661ULL, 0x00000018ff817819ULL, 0x000fe2000001163eULL,
0x20000069ff707230ULL, 0x000fe20000004100ULL, 0x0000001dff11723eULL, 0x000fc400020006ffULL,
0x000000ff61147812ULL, 0x040fe400078ec0ffULL, 0x0000ffff61947812ULL, 0x000fe400078ec0ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x000000ff3f867812ULL, 0x000fe400078ec0ffULL,
0x00000013ff13723eULL, 0x000fe200020006ffULL, 0x2000006aff717230ULL, 0x000fe20000004100ULL,
0x00000081ff69723eULL, 0x000fe200020006ffULL, 0x20000011ff817230ULL, 0x000fe20000004100ULL,
0x000000ff3e847812ULL, 0x000fe200078ec0ffULL, 0x20000013ff797230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fc40000011661ULL, 0x00000014ff12723eULL, 0x000fe200020006ffULL,
0x2000005cff737230ULL, 0x000fe20000004100ULL, 0x00000008ff117819ULL, 0x000fe40000011694ULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x0000ffff60937812ULL, 0x000fe400078ec0ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000018ff1a7819ULL, 0x000fc40000011660ULL,
0x00000084ff6a723eULL, 0x000fe400020006ffULL, 0x00000010ff6e7819ULL, 0x100fe40000011631ULL,
0x000000ff318c7812ULL, 0x040fe200078ec0ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000018ff8b7819ULL, 0x000fe40000011631ULL, 0x0000ffff31607812ULL, 0x000fe200078ec0ffULL,
0x20000012ff317230ULL, 0x000fe20000004100ULL, 0x000000ff1e137812ULL, 0x000fc400078ec0ffULL,
0x000000ff83847812ULL, 0x000fe400078ec0ffULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x0000006cff5c723eULL, 0x000fe200020006ffULL, 0x2000006bff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff127819ULL, 0x000fe20000011693ULL, 0x20000086ff6b7230ULL, 0x000fe20000004100ULL,
0x00000013ff13723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000084ff86723eULL, 0x000fe200020006ffULL, 0x20000011ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe2000001163eULL, 0x20000013ff837230ULL, 0x000fe20000004100ULL,
0x0000ffff3e767812ULL, 0x000fc400078ec0ffULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x000000ff82827812ULL, 0x000fe400078ec0ffULL, 0x00000008ff117819ULL, 0x000fe40000011695ULL,
0x00000062ff3e723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000087ff62723eULL, 0x000fe200020006ffULL, 0x20000086ff877230ULL, 0x000fe20000004100ULL,
0x00000018ff857819ULL, 0x000fe2000001163fULL, 0x20000068ff757230ULL, 0x000fe20000004100ULL,
0x0000001aff77723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000082ff13723eULL, 0x000fe200020006ffULL, 0x20000012ff827230ULL, 0x000fe20000004100ULL,
0x00000011ff11723eULL, 0x000fe200020006ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x000000ff89867812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff1a7819ULL, 0x000fc40000011633ULL, 0x000000ff33927812ULL, 0x040fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fe40000011633ULL, 0x0000ffff33147812ULL, 0x000fe400078ec0ffULL,
0x00000064ff33723eULL, 0x000fe400020006ffULL, 0x00000008ff127819ULL, 0x000fe40000011696ULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fc40000011697ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000008aff64723eULL, 0x000fe400020006ffULL, 0x00000085ff68723eULL, 0x000fe200020006ffULL,
0x20000013ff857230ULL, 0x000fe20000004100ULL, 0x00000086ff8a723eULL, 0x000fe200020006ffULL,
0x20000011ff867230ULL, 0x000fe20000004100ULL, 0x00000012ff12723eULL, 0x000fe200020006ffULL,
0x20000063ff727230ULL, 0x000fe20000004100ULL, 0x00000088ff13723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000089ff11723eULL, 0x000fe200020006ffULL,
0x20000012ff887230ULL, 0x000fe20000004100ULL, 0x0000008bff63723eULL, 0x000fe200020006ffULL,
0x2000008aff8b7230ULL, 0x000fe20000004100ULL, 0x00000018ff8f7819ULL, 0x000fe20000011632ULL,
0x20000013ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe2000001163dULL,
0x20000011ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000ffff3d7c7812ULL, 0x000fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x2000008fff1d7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x00000008ff7b7819ULL, 0x000fe4000001167bULL, 0x000000ff32907812ULL, 0x000fe400078ec0ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001167cULL,
0x000000ff7d8f7812ULL, 0x000fe200078ec0ffULL, 0x2000007fff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x000fc4000001163fULL, 0x00000010ff617819ULL, 0x000fe40000011632ULL,
0x0000ffff321c7812ULL, 0x000fe400078ec0ffULL, 0x0000005aff32723eULL, 0x000fe400020006ffULL,
0x000000ff7a7f7812ULL, 0x000fe400078ec0ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000090ff5a723eULL, 0x000fe200020006ffULL,
0x2000007eff907230ULL, 0x000fe20000004100ULL, 0x0000007cff7a723eULL, 0x000fe200020006ffULL,
0x2000007bff7c7230ULL, 0x000fe20000004100ULL, 0x000000ff787e7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000007aff7b7230ULL, 0x000fe20000004100ULL, 0x0000007eff7a723eULL, 0x000fe200020006ffULL,
0x0000001710108231ULL, 0x082fe200003400ffULL, 0x00000008ff7e7819ULL, 0x000fe20000011676ULL,
0x0000001712128231ULL, 0x000fe200003400ffULL, 0x00000010ff307819ULL, 0x000fe20000011630ULL,
0x0000001611118231ULL, 0x080fe200003400ffULL, 0x00000010ff317819ULL, 0x000fe20000011631ULL,
0x0000001613138231ULL, 0x000fe200003400ffULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x2000007fff787230ULL, 0x000fe20000004100ULL, 0x00000010ff767819ULL, 0x000fe20000011683ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x0000ffff3f3f7812ULL, 0x000fc400078ec0ffULL,
0x0000105481307816ULL, 0x000fe40000000030ULL, 0x0000105476317816ULL, 0x000fe40000000031ULL,
0x00000008ff7f7819ULL, 0x000fe4000001163fULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x000000301054723cULL, 0x000fe20000041854ULL,
0x00000010ff767819ULL, 0x000fc40000011682ULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000010ff3f7819ULL, 0x000fe40000011679ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x2000007eff797230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001163dULL, 0x20000022ff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff327819ULL, 0x000fe20000011632ULL, 0x2000007fff817230ULL, 0x000fe20000004100ULL,
0x00000010ff337819ULL, 0x000fc40000011633ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff307819ULL, 0x000fe40000011687ULL, 0x0000105477767816ULL, 0x000fe40000000076ULL,
0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x000010543f777816ULL, 0x000fe40000000084ULL,
0x00001054857e7816ULL, 0x000fc40000000032ULL, 0x00001054307f7816ULL, 0x000fe40000000033ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x000000761030723cULL, 0x000fe20000041850ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff877819ULL, 0x000fe20000011688ULL,
0x2000003cff767230ULL, 0x000fe20000004100ULL, 0x000010543d867816ULL, 0x000fc40000000086ULL,
0x000010543e877816ULL, 0x000fe40000000087ULL, 0x0000007e103c723cULL, 0x040fe2000004184cULL,
0x000000000f4c783bULL, 0x000e620000000200ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL,
0x20000067ff747230ULL, 0x000fe20000004100ULL, 0x0000008cff67723eULL, 0x000fe200020006ffULL,
0x000000861048723cULL, 0x000fe20000041848ULL, 0x00000008ff8c7819ULL, 0x000fc40000011698ULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000008ff807819ULL, 0x000fe20000011680ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff507819ULL, 0x000fe2000001168bULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x0000105450757816ULL, 0x000fe40000000075ULL,
0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fe40000011673ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168cULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff8d7819ULL, 0x000fc4000001168dULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x000000174c4c8231ULL, 0x082fe200003400ffULL, 0x00001054508b7816ULL, 0x000fe2000000008bULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011671ULL,
0x2000006eff737230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe2000001168eULL,
0x000000174e4e8231ULL, 0x000fe200003400ffULL, 0x00000010ff527819ULL, 0x000fe2000001166fULL,
0x000000164d4d8231ULL, 0x080fe200003400ffULL, 0x000010548d507816ULL, 0x000fe20000000070ULL,
0x000000164f4f8231ULL, 0x000fe200003400ffULL, 0x00000010ff747819ULL, 0x000fc40000011674ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff0f7819ULL, 0x000fe40000011672ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff707819ULL, 0x000fe4000001165dULL, 0x00000010ff6f7819ULL, 0x000fc40000011680ULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x000010548e517816ULL, 0x000fe40000000051ULL, 0x0000105489747816ULL, 0x000fe20000000074ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x000010540f8a7816ULL, 0x000fe4000000008aULL,
0x00001054526e7816ULL, 0x000fc4000000007dULL, 0x00001054706f7816ULL, 0x000fe2000000006fULL,
0x000000501050723cULL, 0x040fe20000041834ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x2000005fff727230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x000000741044723cULL, 0x000fe20000041844ULL, 0x00000010ff0f7819ULL, 0x000fc40000011690ULL,
0x000010548f347816ULL, 0x000fe4000000005cULL, 0x000010540f357816ULL, 0x000fe4000000005eULL,
0x00000010ff7b7819ULL, 0x000fe2000001167bULL, 0x0000008a1040723cULL, 0x000fe20000041840ULL,
0x00000010ff0f7819ULL, 0x000fe4000001166cULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x000010540f7c7816ULL, 0x000fe2000000007cULL,
0x0000006e105c723cULL, 0x000fe20000041838ULL, 0x00000010ff0f7819ULL, 0x000fe40000011678ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff167819ULL, 0x000fe40000011669ULL,
0x00000010ff107819ULL, 0x000fe4000001166dULL, 0x00000010ff797819ULL, 0x000fc40000011679ULL,
0x00001054107d7816ULL, 0x000fe4000000007bULL, 0x000000344c10723cULL, 0x040fe20000041854ULL,
0x00000008ff607819ULL, 0x000fe40000011660ULL, 0x000000ff61617812ULL, 0x000fe400078ec0ffULL,
0x000000ff1a1a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff357819ULL, 0x000fe2000001166bULL,
0x0000007c4c30723cULL, 0x000fe20000041830ULL, 0x000010540f347816ULL, 0x000fc4000000006aULL,
0x000010547a357816ULL, 0x000fe40000000035ULL, 0x00000008ff1c7819ULL, 0x000fe4000001161cULL,
0x00000008ff147819ULL, 0x000fe40000011614ULL, 0x0000105416387816ULL, 0x000fe20000000079ULL,
0x000000344c34723cULL, 0x000fe2000004183cULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff397819ULL, 0x000fc40000011681ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff3d7819ULL, 0x000fe40000011667ULL, 0x00000010ff0f7819ULL, 0x000fe40000011676ULL,
0x00000010ff167819ULL, 0x000fe40000011673ULL, 0x00000092ff22723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000091ff1e7230ULL, 0x000fe20000004100ULL, 0x0000001aff1a723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000001cff1c723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x0000105468397816ULL, 0x000fe20000000039ULL,
0x2000001cff1c7230ULL, 0x000fe20000004100ULL, 0x000010540f3c7816ULL, 0x000fe20000000064ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00001054163d7816ULL, 0x000fc4000000003dULL,
0x00000010ff0f7819ULL, 0x000fe20000011662ULL, 0x000000384c38723cULL, 0x040fe20000041848ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff5a7819ULL, 0x000fe2000001165aULL,
0x0000003c4c3c723cULL, 0x000fe20000041844ULL, 0x00000010ff617819ULL, 0x000fc40000011661ULL,
0x00000010ff227819ULL, 0x000fe40000011622ULL, 0x00000010ff1d7819ULL, 0x000fe4000001161dULL,
0x00000010ff457819ULL, 0x000fe4000001161aULL, 0x00000010ff1c7819ULL, 0x000fe4000001161cULL,
0x00000010ff497819ULL, 0x000fe4000001161eULL, 0x00000010ff147819ULL, 0x000fc40000011614ULL,
0x000010540f727816ULL, 0x000fe40000000072ULL, 0x0000105463737816ULL, 0x000fe40000000060ULL,
0x0000105461447816ULL, 0x000fe4000000005aULL, 0x0000105445457816ULL, 0x000fe40000000022ULL,
0x000010541d487816ULL, 0x000fe2000000001cULL, 0x000000724c40723cULL, 0x000fe20000041840ULL,
0x0000105449497816ULL, 0x000fce0000000014ULL, 0x000000444c44723cULL, 0x040ff00000041850ULL,
0x000000484c48723cULL, 0x000fe2000004185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff167f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007824817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007824817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00147305ULL, 0x0002a4000021f000ULL,
0x3fa000000f0f7823ULL, 0x002fe200000100ffULL, 0x000000140000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc40007824817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000003002b0f7a10ULL, 0x000fe20007ffe0ffULL,
0x0000580026147a24ULL, 0x020fc800078e02ffULL, 0x000001000f177824ULL, 0x040fe400078e00ffULL,
0x00000040141a7824ULL, 0x000fe200078e00ffULL, 0x000000010f147810ULL, 0x000fe40007ffe0ffULL,
0x000000172c167217ULL, 0x000fe40007800000ULL, 0x0000000e1a0e7210ULL, 0x000fe40007f3e0ffULL,
0x000000291400720cULL, 0x000fe20003f46070ULL, 0x0000000116167824ULL, 0x000fe200078e0a17ULL,
0x0000000d1a0d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x00005e000e1c7a11ULL, 0x000fc400078640ffULL, 0x0000002016167807ULL, 0x000fe40001000000ULL,
0x0000000c1a1d7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x0000000b1a227210ULL, 0x000fe40007f3e0ffULL, 0x00005f000e0f7a11ULL, 0x000fe200018f440fULL,
0x000000ffff1a7224ULL, 0x000fe200028e06ffULL, 0x0000001627167217ULL, 0x000fe20007800000ULL,
0x000000ffff4d7224ULL, 0x000fe200008e06ffULL, 0x00005e000d0e7a11ULL, 0x000fc400078440ffULL,
0x00005e001d1e7a11ULL, 0x000fe200078640ffULL, 0x0000000116147824ULL, 0x000fe200078e0a27ULL,
0x00005f000d177a11ULL, 0x000fe400010f440cULL, 0x00000004ff0b7819ULL, 0x000fe4000001162dULL,
0x00005e00224c7a11ULL, 0x000fe400078240ffULL, 0x0000001b1c0c7210ULL, 0x080fe40007f9e0ffULL,
0x0000001b0e0e7210ULL, 0x000fc40007fbe0ffULL, 0x00005f001d1a7a11ULL, 0x000fe200018f441aULL,
0x000000ffff0d7224ULL, 0x000fe200020e060fULL, 0x00005f00224d7a11ULL, 0x000fe200008f444dULL,
0x000000ffff0f7224ULL, 0x000fe200028e0617ULL, 0x000000140b00720cULL, 0x080fe40003f46070ULL,
0x0000001b1e167210ULL, 0x000fe40007f7e0ffULL, 0x000000142100720cULL, 0x080fe40003f26070ULL,
0x000000142000720cULL, 0x080fe20003f86070ULL, 0x000000ffff177224ULL, 0x000fe200018e061aULL,
0x000000141f00720cULL, 0x000fc40003fa6070ULL, 0x0000001b4c1a7210ULL, 0x000fc60007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0a7faeULL, 0x0003e4000d101c46ULL,
0x000000ffff1b7224ULL, 0x000fe400018e064dULL, 0x000000000e097faeULL, 0x0003e8000c901c46ULL,
0x0000000016087faeULL, 0x0003e8000e101c46ULL, 0x000000001a077faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff087f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007824819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e0009ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007824819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff077424ULL, 0x000fc800078e00ffULL,
0x0000000700087305ULL, 0x0002a4000021f000ULL, 0x3fa0000007077823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x0106b400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007824819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000015ff07723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x000fe4000001162dULL,
0x00005410075f7816ULL, 0x000fe20000000007ULL, 0x0000b0827f007947ULL, 0x000fea000b800000ULL,
0x00001f6c5f0d7589ULL, 0x0002a400000e0000ULL, 0x0000b0c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2f5f0c7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0066ULL, 0x00010250005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0000b68000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e0065ULL, 0x000102b0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0000b62000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000064c783bULL, 0x000f620000004200ULL, 0x0000b80002027811ULL, 0x000fe400078e20ffULL,
0x0000b80000007811ULL, 0x000fe200078e20ffULL, 0x00000000051c783bULL, 0x000e680000004200ULL,
0x000000000418783bULL, 0x000ee80000004200ULL, 0x000000000308783bULL, 0x000f220000004200ULL,
0x00000010ff177819ULL, 0x020fc4000001164cULL, 0x000000ff4c0f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff0e7819ULL, 0x000fe4000001164cULL, 0x0000ffff4c717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x100fe4000001164fULL, 0x000000ff4f2f7812ULL, 0x008fe400078ec0ffULL,
0x00000018ff227819ULL, 0x000fc4000001164fULL, 0x0000ffff4f797812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6a7819ULL, 0x102fe4000001161cULL, 0x000000ff1c4f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001161cULL, 0x0000ffff1c7a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6b7819ULL, 0x000fc4000001161dULL, 0x000000ff1d507812ULL, 0x040fe400078ec0ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001161dULL, 0x0000ffff1d7b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x100fe4000001161eULL, 0x000000ff1e517812ULL, 0x000fe400078ec0ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001161eULL, 0x0000ffff1e7c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x100fe4000001161fULL, 0x000000ff1f527812ULL, 0x040fe400078ec0ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001161fULL, 0x0000ffff1f7d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff747819ULL, 0x000fc40000011618ULL, 0x000000ff18547812ULL, 0x040fe400078ec0ffULL,
0x00000018ff1f7819ULL, 0x000fe40000011618ULL, 0x0000ffff187e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe40000011619ULL, 0x000000ff19667812ULL, 0x000fe400078ec0ffULL,
0x00000018ff187819ULL, 0x000fc40000011619ULL, 0x0000ffff197f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff777819ULL, 0x100fe4000001161aULL, 0x000000ff1a687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff197819ULL, 0x000fe4000001161aULL, 0x0000ffff1a5f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff637819ULL, 0x000fc4000001164dULL, 0x000000ff4d167812ULL, 0x040fe400078ec0ffULL,
0x00000018ff147819ULL, 0x000fe4000001164dULL, 0x0000ffff4d737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff787819ULL, 0x100fe4000001161bULL, 0x000000ff1b697812ULL, 0x000fe400078ec0ffULL,
0x00000018ff1a7819ULL, 0x000fc4000001161bULL, 0x0000ffff1b077812ULL, 0x000fe400078ec0ffULL,
0x00000010ff047819ULL, 0x110fe40000011608ULL, 0x000000ff086c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff1b7819ULL, 0x000fe40000011608ULL, 0x0000ffff084d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff087819ULL, 0x000fc40000011609ULL, 0x0000000fff05723eULL, 0x000fe400020006ffULL,
0x0000002fff2f723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x100fe2000001164eULL,
0x20000005ff627230ULL, 0x000fe20000004100ULL, 0x000000ff4e217812ULL, 0x040fe200078ec0ffULL,
0x2000002fff5e7230ULL, 0x004fe20000004100ULL, 0x00000018ff207819ULL, 0x000fe4000001164eULL,
0x0000ffff4e757812ULL, 0x000fc400078ec0ffULL, 0x00000014ff61723eULL, 0x000fe400020006ffULL,
0x00000018ff18723eULL, 0x000fe400020006ffULL, 0x0000001aff1a723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff4e7819ULL, 0x000fe20000011609ULL,
0x20000018ff2f7230ULL, 0x000fe20000004100ULL, 0x000000ff096d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff09147812ULL, 0x000fc400078ec0ffULL, 0x00000008ff08723eULL, 0x000fe400020006ffULL,
0x00000018ff097819ULL, 0x100fe4000001160aULL, 0x000000ff17177812ULL, 0x000fe400078ec0ffULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x00000020ff05723eULL, 0x000fe200020006ffULL,
0x2000001aff207230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000008ff1a7230ULL, 0x000fe20000004100ULL, 0x00000009ff18723eULL, 0x000fe200020006ffULL,
0x20000005ff057230ULL, 0x000fe20000004100ULL, 0x00000017ff08723eULL, 0x000fe200020006ffULL,
0x20000051ff537230ULL, 0x000fe20000004100ULL, 0x00000063ff09723eULL, 0x000fe200020006ffULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x00000016ff06723eULL, 0x000fe200020006ffULL,
0x20000008ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fc4000001160aULL,
0x000000ff0a6f7812ULL, 0x040fe200078ec0ffULL, 0x20000006ff657230ULL, 0x000fe20000004100ULL,
0x0000ffff0a0f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0a7819ULL, 0x000fe4000001160bULL,
0x00000066ff51723eULL, 0x000fe200020006ffULL, 0x20000009ff667230ULL, 0x000fe20000004100ULL,
0x00000008ff087819ULL, 0x000fe40000011671ULL, 0x00000008ff097819ULL, 0x000fe20000011673ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fc400020006ffULL,
0x0000000eff60723eULL, 0x000fe400020006ffULL, 0x0000000aff0a723eULL, 0x000fe200020006ffULL,
0x20000021ff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff0e7819ULL, 0x000fe2000001160bULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x000000ff0b707812ULL, 0x040fe200078ec0ffULL,
0x2000000aff177230ULL, 0x000fe20000004100ULL, 0x0000ffff0b037812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fc400078ec0ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x00000008ff08723eULL, 0x000fe400020006ffULL, 0x00000009ff09723eULL, 0x000fe400020006ffULL,
0x00000008ff0b7819ULL, 0x000fe40000011675ULL, 0x00000069ff21723eULL, 0x000fe400020006ffULL,
0x00000064ff0a723eULL, 0x000fe200020006ffULL, 0x20000008ff647230ULL, 0x000fe20000004100ULL,
0x00000067ff69723eULL, 0x000fe200020006ffULL, 0x20000009ff677230ULL, 0x000fe20000004100ULL,
0x0000000bff0b723eULL, 0x000fe200020006ffULL, 0x20000021ff217230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fc400020006ffULL, 0x00000008ff087819ULL, 0x000fe20000011679ULL,
0x2000004fff577230ULL, 0x000fe20000004100ULL, 0x000000ff6a097812ULL, 0x000fe200078ec0ffULL,
0x2000000bff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL,
0x2000004cff557230ULL, 0x000fe20000004100ULL, 0x00000022ff06723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000001fff1f723eULL, 0x000fe200020006ffULL,
0x20000006ff067230ULL, 0x000fe20000004100ULL, 0x0000001dff1d723eULL, 0x000fe200020006ffULL,
0x20000050ff5c7230ULL, 0x000fe20000004100ULL, 0x0000001eff1e723eULL, 0x000fe200020006ffULL,
0x2000001fff4c7230ULL, 0x000fe20000004100ULL, 0x00000068ff22723eULL, 0x000fe200020006ffULL,
0x2000000aff687230ULL, 0x000fe20000004100ULL, 0x00000019ff19723eULL, 0x000fe200020006ffULL,
0x2000001eff507230ULL, 0x000fe20000004100ULL, 0x00000008ff08723eULL, 0x000fe200020006ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000009ff09723eULL, 0x000fe200020006ffULL,
0x20000019ff1f7230ULL, 0x000fe20000004100ULL, 0x0000006bff0b723eULL, 0x000fe200020006ffULL,
0x20000008ff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff0a7819ULL, 0x000fc4000001167aULL,
0x00000054ff4f723eULL, 0x000fe200020006ffULL, 0x2000001dff547230ULL, 0x000fe20000004100ULL,
0x0000006cff1e723eULL, 0x000fe200020006ffULL, 0x20000009ff6c7230ULL, 0x000fe20000004100ULL,
0x0000006dff1d723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000006fff19723eULL, 0x000fe200020006ffULL, 0x2000000bff6f7230ULL, 0x000fe20000004100ULL,
0x0000000aff6d723eULL, 0x000fe200020006ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x000000000208783bULL, 0x0002a20000000200ULL, 0x00000008ff737819ULL, 0x000fe2000001167dULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x000000ff74757812ULL, 0x000fe200078ec0ffULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x000000ff76767812ULL, 0x000fc400078ec0ffULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000073ff02723eULL, 0x002fe400020006ffULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x20000002ff747230ULL, 0x000fe20000004100ULL, 0x00000008ff027819ULL, 0x000fe4000001167eULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x000000ff6e717812ULL, 0x000fe200078ec0ffULL,
0x2000006dff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff04047812ULL, 0x000fe400078ec0ffULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x000000ff77777812ULL, 0x000fe400078ec0ffULL, 0x0000105463627816ULL, 0x000fc40000000062ULL,
0x00000008ff6d7819ULL, 0x000fe4000001167cULL, 0x00000002ff02723eULL, 0x000fe400020006ffULL,
0x0000105466637816ULL, 0x000fe40000000065ULL, 0x00000008ff667819ULL, 0x000fe40000011607ULL,
0x00000010ff077819ULL, 0x000fe20000011660ULL, 0x0000000d08088231ULL, 0x084fe200003400ffULL,
0x00000004ff04723eULL, 0x000fe200020006ffULL, 0x0000000d0a0a8231ULL, 0x000fe200003400ffULL,
0x00000010ff057819ULL, 0x000fe20000011605ULL, 0x0000000c09098231ULL, 0x080fe200003400ffULL,
0x00000010ff067819ULL, 0x000fe20000011606ULL, 0x0000000c0b0b8231ULL, 0x000fe200003400ffULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x00000077ff79723eULL, 0x000fe200020006ffULL,
0x20000076ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x20000002ff767230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe2000001166aULL,
0x20000072ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000620810723cULL, 0x000fe20000041810ULL, 0x0000001cff1c723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x0000001bff1b723eULL, 0x000fe200020006ffULL, 0x2000001cff567230ULL, 0x000fe20000004100ULL,
0x00000010ff027819ULL, 0x000fe20000011661ULL, 0x20000004ff617230ULL, 0x000fe20000004100ULL,
0x0000105407647816ULL, 0x000fe20000000064ULL, 0x2000006dff727230ULL, 0x000fe20000004100ULL,
0x00001054056a7816ULL, 0x000fe2000000006aULL, 0x2000001bff1c7230ULL, 0x000fe20000004100ULL,
0x00001054066b7816ULL, 0x000fe4000000006bULL, 0x000000000004783bULL, 0x0002a20000000200ULL,
0x00000008ff6d7819ULL, 0x000fc4000001167fULL, 0x00000070ff1b723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x0000006a0838723cULL, 0x000fe20000041838ULL,
0x00000008ff707819ULL, 0x000fe2000001167bULL, 0x2000001bff1b7230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fc400020006ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000008ff4d7819ULL, 0x000fe2000001164dULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000000ff787a7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff787230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x000fe2000001165cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166fULL, 0x00000008ff5f7819ULL, 0x000fc4000001165fULL,
0x00000010ff657819ULL, 0x000fe40000011667ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff007819ULL, 0x002fe20000011671ULL,
0x2000004dff627230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x0000000d04048231ULL, 0x084fe200003400ffULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x0000000d06068231ULL, 0x000fe200003400ffULL, 0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x0000000c05058231ULL, 0x080fe200003400ffULL, 0x000010546d6d7816ULL, 0x000fe2000000005cULL,
0x0000000c07078231ULL, 0x000fe200003400ffULL, 0x0000005fff5f723eULL, 0x000fc400020006ffULL,
0x0000105402657816ULL, 0x000fe40000000065ULL, 0x0000105468687816ULL, 0x000fe2000000005dULL,
0x2000005fff607230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff6e7819ULL, 0x000fe2000001166eULL, 0x000000640830723cULL, 0x000fe20000041830ULL,
0x00001054005c7816ULL, 0x000fe40000000053ULL, 0x0000105469697816ULL, 0x000fc4000000005eULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x000000680834723cULL, 0x000fe20000041834ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff6f7819ULL, 0x000fe20000011670ULL,
0x2000004eff637230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fc40000011652ULL,
0x00000010ff5d7819ULL, 0x000fe40000011673ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff007819ULL, 0x000fe40000011675ULL,
0x00000010ff027819ULL, 0x000fe40000011677ULL, 0x00000010ff4d7819ULL, 0x000fc40000011654ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff737819ULL, 0x000fe40000011674ULL, 0x00001054556e7816ULL, 0x000fe4000000006eULL,
0x000010546c6c7816ULL, 0x000fe40000000057ULL, 0x00001054566f7816ULL, 0x000fc4000000006fULL,
0x000010545d5d7816ULL, 0x000fe40000000052ULL, 0x0000105400547816ULL, 0x000fe2000000004fULL,
0x0000006c083c723cULL, 0x040fe2000004183cULL, 0x0000105402557816ULL, 0x000fe40000000051ULL,
0x000010544d727816ULL, 0x000fe40000000072ULL, 0x0000105450737816ULL, 0x000fe40000000073ULL,
0x00000010ff007819ULL, 0x000fe2000001162fULL, 0x0000006e0840723cULL, 0x000fe20000041840ULL,
0x00000010ff517819ULL, 0x000fc40000011678ULL, 0x00000010ff1f7819ULL, 0x000fe4000001161fULL,
0x0000105400517816ULL, 0x000fe40000000051ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x0000005c085c723cULL, 0x040fe20000041844ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000010ff1d7819ULL, 0x000fe4000001161dULL, 0x00000010ff007819ULL, 0x000fe20000011663ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff16167812ULL, 0x000fe200078ec0ffULL,
0x000000720808723cULL, 0x000fe20000041848ULL, 0x00000008ff147819ULL, 0x000fc40000011614ULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff0f7819ULL, 0x000fe4000001160fULL,
0x000010541f487816ULL, 0x000fe20000000060ULL, 0x000000540454723cULL, 0x000fe20000041810ULL,
0x00001054001f7816ULL, 0x000fe4000000001dULL, 0x00000008ff007819ULL, 0x000fe40000011603ULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x00000016ff16723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000000eff0e723eULL, 0x000fe200020006ffULL, 0x20000016ff167230ULL, 0x000fe20000004100ULL,
0x0000000fff0f723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x2000000eff0e7230ULL, 0x000fe20000004100ULL,
0x00000010ff227819ULL, 0x000fe20000011622ULL, 0x2000000fff0f7230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe20000011621ULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff0d7819ULL, 0x000fe4000001164cULL, 0x00001054794c7816ULL, 0x000fe40000000022ULL,
0x000010547a4d7816ULL, 0x000fe40000000021ULL, 0x00000010ff207819ULL, 0x000fe40000011620ULL,
0x00000010ff497819ULL, 0x000fc40000011666ULL, 0x00000010ff197819ULL, 0x000fe20000011619ULL,
0x0000004c044c723cULL, 0x000fe20000041834ULL, 0x00000010ff167819ULL, 0x000fe40000011616ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff1e7819ULL, 0x000fe4000001161eULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff037819ULL, 0x000fc4000001161cULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff637819ULL, 0x000fe4000001161aULL,
0x00000010ff147819ULL, 0x000fe40000011614ULL, 0x00000010ff1b7819ULL, 0x000fe4000001161bULL,
0x00000010ff0e7819ULL, 0x000fe4000001160eULL, 0x00000010ff187819ULL, 0x000fc40000011618ULL,
0x00000010ff0f7819ULL, 0x000fe4000001160fULL, 0x00000010ff177819ULL, 0x000fe40000011617ULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x0000105420497816ULL, 0x000fe40000000049ULL,
0x0000105416347816ULL, 0x000fe40000000019ULL, 0x000010540d507816ULL, 0x000fc40000000076ULL,
0x00001054611e7816ULL, 0x000fe2000000001eULL, 0x000000480448723cULL, 0x040fe20000041838ULL,
0x0000105403627816ULL, 0x000fe40000000062ULL, 0x0000105463637816ULL, 0x000fe40000000014ULL,
0x000010540e357816ULL, 0x000fe4000000001bULL, 0x0000105418187816ULL, 0x000fe2000000000fULL,
0x000000500450723cULL, 0x000fe20000041830ULL, 0x0000105417197816ULL, 0x000fce0000000000ULL,
0x0000001e0444723cULL, 0x040ff0000004183cULL, 0x000000620440723cULL, 0x040ff00000041840ULL,
0x000000340434723cULL, 0x040ff0000004185cULL, 0x000000180438723cULL, 0x000fe20000041808ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff027f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff317224ULL, 0x002fc600078e0003ULL,
0x000003002b2b7a10ULL, 0x000fc80007ffe0ffULL, 0x000000292b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffef4b000007947ULL, 0x000fea000383ffffULL,
0x00000000000e7919ULL, 0x000ee40000002500ULL, 0x000000290e00720cULL, 0x008fda0003f06070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000024007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff337224ULL, 0x000fe200078e0024ULL, 0x00011a9000047802ULL, 0x000fe40000000f00ULL,
0x00009c9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002400037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000024ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ee8000c1e9900ULL, 0x0000000000057919ULL, 0x000f240000000000ULL,
0x00000002ff077819ULL, 0x014fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x008fca0000410000ULL, 0x00001f0700047589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000005404547220ULL, 0x044fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004404447220ULL, 0x040fe20000410000ULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x0000004004407220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003804387220ULL, 0x040fe20000410000ULL,
0x0000003904397220ULL, 0x000fe20000410000ULL, 0x0000005605567220ULL, 0x048fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000004e054e7220ULL, 0x040fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000004a054a7220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004605467220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x000fe20000410000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x00000300ff127624ULL, 0x000fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x000000011200780cULL, 0x000fe40003f05270ULL, 0x0000000203007812ULL, 0x002fe400078ec0ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011603ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000200047811ULL, 0x000fc400078ff8ffULL, 0x0000000400067811ULL, 0x044fe400078ff8ffULL,
0x00000006000a7811ULL, 0x000fe400078ff8ffULL, 0x0000000803177811ULL, 0x000fe400078ff0ffULL,
0x0000000702007812ULL, 0x100fe400078e780fULL, 0x0000000706087812ULL, 0x040fe400078e780fULL,
0x0000000706067812ULL, 0x100fe200078e7817ULL, 0x000000080f077824ULL, 0x000fe200078e0200ULL,
0x0000000702027812ULL, 0x000fe200078e7817ULL, 0x000008002e007824ULL, 0x000fe200078e00ffULL,
0x0000000704057812ULL, 0x100fe200078e780fULL, 0x0000000817157824ULL, 0x040fe200078e0206ULL,
0x000000070a0c7812ULL, 0x000fe200078e780fULL, 0x0000000817117824ULL, 0x000fe200078e0202ULL,
0x0000000704047812ULL, 0x100fe200078e7817ULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x000000070a0a7812ULL, 0x000fe200078e7817ULL, 0x000000080f097824ULL, 0x040fe200078e0205ULL,
0x0000a00000027810ULL, 0x000fe20007ffe0ffULL, 0x000000080f0b7824ULL, 0x000fe200078e0208ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x0000000817137824ULL, 0x000fe200078e0204ULL,
0x000000545504723eULL, 0x000fe200000010ffULL, 0x000000080f0f7824ULL, 0x000fe200078e020cULL,
0x000000505105723eULL, 0x000fe200000010ffULL, 0x0000000817177824ULL, 0x000fe200078e020aULL,
0x000000565708723eULL, 0x000fe200000010ffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x0000541004187816ULL, 0x140fe20000000005ULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x0000763204197816ULL, 0x000fe20000000005ULL, 0x000000100b0d7824ULL, 0x100fe200078e0202ULL,
0x000000444504723eULL, 0x000fe200000010ffULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x000000404105723eULL, 0x000fe200000010ffULL, 0x0000001013137824ULL, 0x000fc400078e0202ULL,
0x000000100f0f7824ULL, 0x100fe400078e0202ULL, 0x0000001015157824ULL, 0x100fe400078e0202ULL,
0x0000001017177824ULL, 0x000fe400078e0202ULL, 0x00000001070a7824ULL, 0x000fe200078e0206ULL,
0x000000484907723eULL, 0x000fe200000010ffULL, 0x00000001060b7824ULL, 0x040fe200078e0209ULL,
0x000000525309723eULL, 0x000fe200000010ffULL, 0x00000001060d7824ULL, 0x040fe200078e020dULL,
0x000000180a007388ULL, 0x0003e20000000a00ULL, 0x0000000106117824ULL, 0x000fc400078e0211ULL,
0x0000000106137824ULL, 0x040fe400078e0213ULL, 0x00000001060f7824ULL, 0x040fe400078e020fULL,
0x0000000106157824ULL, 0x040fe400078e0215ULL, 0x0000000106177824ULL, 0x000fe200078e0217ULL,
0x0000004c4d06723eULL, 0x000fe400000010ffULL, 0x00005410040a7816ULL, 0x002fe40000000005ULL,
0x0000541006187816ULL, 0x000fc40000000007ULL, 0x0000763206197816ULL, 0x000fe40000000007ULL,
0x000000343506723eULL, 0x000fe400000010ffULL, 0x000000383907723eULL, 0x000fe200000010ffULL,
0x000000180b007388ULL, 0x0003e40000000a00ULL, 0x00007632040b7816ULL, 0x002fe40000000005ULL,
0x0000004e4f04723eULL, 0x000fe400000010ffULL, 0x0000004a4b05723eULL, 0x000fe200000010ffULL,
0x0000000a0d007388ULL, 0x0003e40000000a00ULL, 0x00005410060a7816ULL, 0x002fc40000000007ULL,
0x00007632060b7816ULL, 0x000fe40000000007ULL, 0x000000464706723eULL, 0x000fe400000010ffULL,
0x000000424307723eULL, 0x000fe200000010ffULL, 0x0000000a0f007388ULL, 0x0003e40000000a00ULL,
0x00005410080a7816ULL, 0x142fe40000000009ULL, 0x00007632080b7816ULL, 0x000fe40000000009ULL,
0x000000363708723eULL, 0x000fc400000010ffULL, 0x0000003a3b09723eULL, 0x000fe200000010ffULL,
0x0000000a11007388ULL, 0x0003e40000000a00ULL, 0x00005410040a7816ULL, 0x142fe40000000005ULL,
0x00007632040b7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000a13007388ULL, 0x0003e20000000a00ULL,
0x0000541008067816ULL, 0x000fc40000000009ULL, 0x0000763208077816ULL, 0x000fe20000000009ULL,
0x0000000415007388ULL, 0x0003e80000000a00ULL, 0x0000000617007388ULL, 0x0003e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b6000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ea20000002700ULL, 0x0000001003097824ULL, 0x040fe200078e0200ULL,
0x000000ff2e00720cULL, 0x000fe20003f05270ULL, 0x0000580012047a24ULL, 0x002fe200078e02ffULL,
0x0000000000057919ULL, 0x000ea20000002600ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x00000020030f7810ULL, 0x040fe20007ffe0ffULL, 0x0000660004087a24ULL, 0x000fe200078e02ffULL,
0x00a0000009147984ULL, 0x0002e20000000c00ULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x00a2000009187984ULL, 0x0003220000000c00ULL, 0x0000580010107a24ULL, 0x004fe200078e0205ULL,
0x00000fff08057811ULL, 0x000fc600078e40ffULL, 0x0000030010047a24ULL, 0x000fc800078e02ffULL,
0x00000001040a7824ULL, 0x000fca00078e020eULL, 0x0000000a05067211ULL, 0x000fca00078fa0ffULL,
0x00006c0006067625ULL, 0x000fcc00078e0007ULL, 0x000004002e067825ULL, 0x000fcc00078e0006ULL,
0x000000100f0e7825ULL, 0x000fc800078e0006ULL, 0x00000010030c7825ULL, 0x000fe200078e0006ULL,
0x01ffffff08077812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003087824ULL, 0x01afe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011603ULL,
0x00000080ff067424ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0207ULL,
0x0000007008117812ULL, 0x000fe400078ec0ffULL, 0x0000000c09137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a087625ULL, 0x000fc800078e0006ULL, 0x00006c000b0a7625ULL, 0x000fe200078e0006ULL,
0x0000000813087210ULL, 0x000fc80007b5e011ULL, 0x0000000a130a7210ULL, 0x000fe40007d9e011ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000002508007986ULL, 0x0003e8000c101906ULL, 0x000000240a007986ULL, 0x0003e4000c101906ULL,
0x000000140c007986ULL, 0x01a3e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000180e007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0xffffffff120b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a0010087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff067807ULL, 0x000fca0000800000ULL,
0x00000006ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x004ea40000000000ULL,
0x000000ff0600720cULL, 0x004fda0003f25270ULL, 0x000027a000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011603ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001040a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff177424ULL, 0x002fe200078e00ffULL, 0x0000000c080c7812ULL, 0x000fe400078ec0ffULL,
0x0000007006197812ULL, 0x000fe200078ec0ffULL, 0x00006c0004087625ULL, 0x000fc800078e0017ULL,
0x00006c000a0a7625ULL, 0x000fe200078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x0000000a0c0a7210ULL, 0x000fe40007b5e019ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608067981ULL, 0x000368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x000000021200780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608137981ULL, 0x000362000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608157981ULL, 0x000362000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081200780cULL, 0x002fe40003f06070ULL,
0x0000000604087810ULL, 0x000fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fe40007a3e019ULL, 0x00000007040a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006c000a0a0625ULL, 0x000fe400078e0017ULL,
0x0000000608177981ULL, 0x000366000c1e1900ULL, 0x0000000a0c0a0210ULL, 0x000fc80007c7e019ULL,
0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL, 0x000000060a0b0981ULL, 0x000366000c1e1900ULL,
0x0000000712087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e0006ULL,
0x00000008190c7824ULL, 0x040fe200078e00ffULL, 0x0000000119197810ULL, 0x000fc80007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x0000000a1900720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080c097810ULL, 0x040fe40007ffe0ffULL,
0x000000010c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001b06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e1b7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e01bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006081b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090c097810ULL, 0x042fe40007ffe0ffULL, 0x000000020c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000030c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000040c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000050c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000060c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e015ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000070c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e017ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0c097810ULL, 0x002fe40007ffe0ffULL, 0x0000000b06067209ULL, 0x000fe40007810000ULL,
0x0000030009007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080c087210ULL, 0x000fc80007a3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080b7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003087824ULL, 0x006fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011603ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108097824ULL, 0x000fca00078e0209ULL, 0x0000000609007388ULL, 0x0203e40000000800ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000405087211ULL, 0x000fe200078fa0ffULL, 0x00001000ff097424ULL, 0x002fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011603ULL, 0x000004002e3d7824ULL, 0x000fe200078e00ffULL,
0x00000016ff3f7819ULL, 0x000fe2000001162eULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000020030d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x0000003d08087210ULL, 0x000fe20007f3e0ffULL, 0x00000001040e8824ULL, 0x000fe200078e0207ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000109097824ULL, 0x000fe200008e063fULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x000010002e207824ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00006c000e0e8625ULL, 0x000fe200078e000fULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000102e158824ULL, 0x000fc400078e0203ULL,
0x00006c0004108625ULL, 0x000fc600078e0011ULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x0000000106177824ULL, 0x000fe400078e020bULL, 0x000000102e198824ULL, 0x000fe400078e0203ULL,
0x0000001003137824ULL, 0x040fe400078e0220ULL, 0x00000010030a7825ULL, 0x100fe200078e0008ULL,
0x0000418019198811ULL, 0x000fe200078e20ffULL, 0x0000000017177984ULL, 0x000e640000000800ULL,
0x000000100d0c7825ULL, 0x000fc400078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a137faeULL, 0x0005e2000b901c46ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000010030e8825ULL, 0x040fe400078e000eULL, 0x003800000c137faeULL, 0x0007e4000b901c46ULL,
0x0000001003108825ULL, 0x000fe400078e0010ULL, 0x000000000e158faeULL, 0x0009e4000b901c46ULL,
0x000000ffff067224ULL, 0x000fc400078e00ffULL, 0x0000000010198faeULL, 0x000be2000b901c46ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff2f7224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x020fe2000001ff00ULL, 0x00000d0000009947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134357810ULL, 0x000fc80007ffe0ffULL, 0x0000030035007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x0000000104367824ULL, 0x000fe200078e0235ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x00001000ff197424ULL, 0x000fe200078e00ffULL,
0x00000001351f7812ULL, 0x040fe200078ec0ffULL, 0x00000800351a7824ULL, 0x000fe200078e00ffULL,
0x0000003605187211ULL, 0x000fe400078fa0ffULL, 0x00000020033b7810ULL, 0x000fe40007ffe0ffULL,
0x000008001a1d7812ULL, 0x000fe200078ec0ffULL, 0x00006c0018187625ULL, 0x000fc800078e0019ULL,
0x00000001071b9824ULL, 0x000fe200078e0236ULL, 0x0000003d18187210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff1c9424ULL, 0x000fe400078e00ffULL, 0x000000022e1e9824ULL, 0x140fe400078e021fULL,
0x000000022e389824ULL, 0x000fe400078e021fULL, 0x00006c001b1a9625ULL, 0x000fc800078e001cULL,
0x00000080ff1f9424ULL, 0x000fe400078e00ffULL, 0x00000001201c7824ULL, 0x000fe400078e021dULL,
0x0000000119197824ULL, 0x000fe400000e063fULL, 0x000000081e399824ULL, 0x000fe400078e0203ULL,
0x00006c00361e9625ULL, 0x000fc600078e001fULL, 0x0000458039399811ULL, 0x000fe200078e20ffULL,
0x0000001003377824ULL, 0x040fe400078e021cULL, 0x0000000838389824ULL, 0x000fe400078e0203ULL,
0x00000010031c9825ULL, 0x000fc800078e001aULL, 0x000000103b1a7825ULL, 0x000fe200078e0018ULL,
0x00004180383b9811ULL, 0x000fc600078e20ffULL, 0x0000001003187825ULL, 0x000fc800078e0018ULL,
0x00000010031e9825ULL, 0x000fe200078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000018377faeULL, 0x0005e8000b901c46ULL, 0x003800001a377faeULL, 0x0005e8000b901c46ULL,
0x000000001c399faeULL, 0x0005e8000b901c46ULL, 0x000000001e3b9faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0034ULL,
0x00000001ff1c7819ULL, 0x100fe20000011603ULL, 0x00000010031a7824ULL, 0x000fe200078e00ffULL,
0x00000002ff377819ULL, 0x000fe20000011603ULL, 0x000000801b187824ULL, 0x000fe200078e00ffULL,
0x0000000c1c1c7812ULL, 0x000fc400078ec0ffULL, 0x000000701a1a7812ULL, 0x000fe200078ec0ffULL,
0x00000008371f7824ULL, 0x040fe200078e00ffULL, 0x0000008018197812ULL, 0x000fe200078ec0ffULL,
0x00000008371d7824ULL, 0x040fe200078e00ffULL, 0x00000007373e7812ULL, 0x000fe400078ec0ffULL,
0x00000037ff3c7212ULL, 0x000fe200078e33ffULL, 0x000001002e197824ULL, 0x000fe200078e0219ULL,
0xfffffff81d187812ULL, 0x000fe400078ee23eULL, 0xfffffff81f3c7812ULL, 0x000fc400078ee23cULL,
0x000000191c1a7210ULL, 0x000fe20007ffe01aULL, 0x0000000837197824ULL, 0x040fe200078e00ffULL,
0x0000000837397810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001a3a7984ULL, 0x000ea20000000800ULL, 0x00000001191c7812ULL, 0x100fe200078ef63eULL,
0x00000008391d7824ULL, 0x000fe200078e00ffULL, 0x00000002191e7812ULL, 0x140fe200078ef63eULL,
0x004580001a4c7984ULL, 0x0004e20000000800ULL, 0x0000000319347812ULL, 0x100fe200078ef63eULL,
0x0000000839407824ULL, 0x000fe200078e00ffULL, 0x0000000419367812ULL, 0x140fe400078ef63eULL,
0x0000000519387812ULL, 0x000fe400078ef63eULL, 0x00000039ff4a7212ULL, 0x000fc800078e33ffULL,
0xfffffff81d4a7812ULL, 0x000fe400078ee24aULL, 0x00000007391d7812ULL, 0x000fe200078ec0ffULL,
0x0000003a171a7221ULL, 0x006fe20000010100ULL, 0x00000006193a7812ULL, 0x000fe200078ef63eULL,
0x000008001b197824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b1a1f7820ULL, 0x000fe20000410000ULL,
0x00000004031a7824ULL, 0x000fe400078e00ffULL, 0x0000080019197812ULL, 0x000fe200078ec0ffULL,
0x00000008393e7824ULL, 0x000fc400078e00ffULL, 0x0000000c1a1b7812ULL, 0x000fe200078ec0ffULL,
0x0000001f001f7308ULL, 0x000ee20000000800ULL, 0x0000018020197810ULL, 0x000fe40007ffe019ULL,
0xfffffff8401a7812ULL, 0x100fe400078ee21dULL, 0x000000013e407812ULL, 0x000fe200078ef61dULL,
0x0000001018187824ULL, 0x000fe200078e0219ULL, 0x000000023e427812ULL, 0x000fe200078ef61dULL,
0x000000103c3c7824ULL, 0x000fe200078e0219ULL, 0x000000033e447812ULL, 0x000fe200078ef61dULL,
0x0000000118187824ULL, 0x000fe200078e021bULL, 0x000000043e467812ULL, 0x140fe200078ef61dULL,
0x000000011b3c7824ULL, 0x000fe200078e023cULL, 0x000000053e487812ULL, 0x000fe200078ef61dULL,
0x000000101c1c7824ULL, 0x000fe200078e0219ULL, 0x000000063e3e7812ULL, 0x000fe200078ef61dULL,
0x0000000018187984ULL, 0x000e620000000800ULL, 0x000000101e1e7824ULL, 0x000fe200078e0219ULL,
0x0000004c1f4c7220ULL, 0x008fe20000410000ULL, 0x000000011b1c7824ULL, 0x040fe200078e021cULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x000000011b1e7824ULL, 0x000fe200078e021eULL,
0x000000334c337221ULL, 0x000fe20000010000ULL, 0x0000001034347824ULL, 0x100fe200078e0219ULL,
0x00001f374c1d7589ULL, 0x000ea200000e0000ULL, 0x0000001036367824ULL, 0x000fc400078e0219ULL,
0x000000011b347824ULL, 0x040fe200078e0234ULL, 0x000000001c1c7984ULL, 0x000ee20000000800ULL,
0x000000011b367824ULL, 0x040fe400078e0236ULL, 0x0000001038387824ULL, 0x100fe200078e0219ULL,
0x000000001e1e7984ULL, 0x000f220000000800ULL, 0x000000103a3a7824ULL, 0x000fe400078e0219ULL,
0x000000011b387824ULL, 0x040fe200078e0238ULL, 0x0000000034347984ULL, 0x000f620000000800ULL,
0x000000011b3a7824ULL, 0x000fc400078e023aULL, 0x000000101a1a7824ULL, 0x100fe200078e0219ULL,
0x0000000036367984ULL, 0x000f620000000800ULL, 0x0000001040407824ULL, 0x100fe400078e0219ULL,
0x0000001042427824ULL, 0x100fe200078e0219ULL, 0x0000000038387984ULL, 0x000f620000000800ULL,
0x0000001044447824ULL, 0x100fe400078e0219ULL, 0x0000001046467824ULL, 0x100fe200078e0219ULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x0000001048487824ULL, 0x000fc400078e0219ULL,
0x000000103e3e7824ULL, 0x100fe200078e0219ULL, 0x00001f394c4c7589ULL, 0x000fe200000e0000ULL,
0x000000104a4a7824ULL, 0x000fe400078e0219ULL, 0x000000011b1a7824ULL, 0x040fe200078e021aULL,
0x00005410ff197816ULL, 0x002fe20000000018ULL, 0x000000011b407824ULL, 0x040fe200078e0240ULL,
0x00007610ff187816ULL, 0x000fe20000000018ULL, 0x000000011b427824ULL, 0x000fe400078e0242ULL,
0x0000001d19327223ULL, 0x084fe20000010032ULL, 0x00005410ff197816ULL, 0x100fe2000000003cULL,
0x000000001a1a7984ULL, 0x000e620000000800ULL, 0x0000001d18317223ULL, 0x080fe20000010031ULL,
0x00007610ff187816ULL, 0x000fe2000000003cULL, 0x000000011b447824ULL, 0x000fe200078e0244ULL,
0x0000001d19227223ULL, 0x080fe20000010022ULL, 0x00005410ff197816ULL, 0x108fe2000000001cULL,
0x0000000040407984ULL, 0x000ea20000000800ULL, 0x0000001d18217223ULL, 0x080fe20000010021ULL,
0x00007610ff187816ULL, 0x000fe2000000001cULL, 0x000000011b467824ULL, 0x000fe200078e0246ULL,
0x0000001d19307223ULL, 0x080fe20000010030ULL, 0x00007610ff197816ULL, 0x110fe2000000001eULL,
0x0000000042427984ULL, 0x000ee20000000800ULL, 0x0000001d182f7223ULL, 0x080fe2000001002fULL,
0x00005410ff187816ULL, 0x000fe2000000001eULL, 0x000000011b487824ULL, 0x000fe200078e0248ULL,
0x0000001d192c7223ULL, 0x080fe2000001002cULL, 0x00007610ff197816ULL, 0x120fe20000000034ULL,
0x0000000044447984ULL, 0x000f220000000800ULL, 0x0000001d182d7223ULL, 0x080fe2000001002dULL,
0x00005410ff187816ULL, 0x000fe20000000034ULL, 0x000000011b3e7824ULL, 0x000fe200078e023eULL,
0x0000001d192a7223ULL, 0x080fe2000001002aULL, 0x00007610ff197816ULL, 0x100fe20000000036ULL,
0x0000000046467984ULL, 0x000f620000000800ULL, 0x0000001d182b7223ULL, 0x080fe2000001002bULL,
0x00005410ff187816ULL, 0x000fe20000000036ULL, 0x000000011b4a7824ULL, 0x000fe200078e024aULL,
0x0000001d19287223ULL, 0x080fe20000010028ULL, 0x00005410ff197816ULL, 0x100fe20000000038ULL,
0x0000000048487984ULL, 0x000f620000000800ULL, 0x0000001d18297223ULL, 0x080fe20000010029ULL,
0x00007610ff187816ULL, 0x000fe20000000038ULL, 0x000000ffff347224ULL, 0x000fe200078e0035ULL,
0x0000001d19267223ULL, 0x080fe20000010026ULL, 0x00005410ff197816ULL, 0x100fe2000000003aULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x0000001d18257223ULL, 0x000fe20000010025ULL,
0x00007610ff187816ULL, 0x000fc4000000003aULL, 0x0000001d19247223ULL, 0x080fe20000010024ULL,
0x00005410ff197816ULL, 0x102fe2000000001aULL, 0x000000004a4a7984ULL, 0x000e620000000800ULL,
0x0000001d18237223ULL, 0x000fe20000010023ULL, 0x00007610ff187816ULL, 0x000fe4000000001aULL,
0x0000004c19167223ULL, 0x080fe20000010016ULL, 0x00005410ff197816ULL, 0x104fe40000000040ULL,
0x0000004c18157223ULL, 0x000fe20000010015ULL, 0x00007610ff187816ULL, 0x000fc40000000040ULL,
0x0000004c19147223ULL, 0x080fe20000010014ULL, 0x00005410ff197816ULL, 0x108fe40000000042ULL,
0x0000004c18137223ULL, 0x080fe20000010013ULL, 0x00007610ff187816ULL, 0x000fe40000000042ULL,
0x0000004c19127223ULL, 0x080fe20000010012ULL, 0x00005410ff197816ULL, 0x110fe40000000044ULL,
0x0000004c18117223ULL, 0x000fe20000010011ULL, 0x00007610ff187816ULL, 0x000fc40000000044ULL,
0x0000004c19107223ULL, 0x080fe20000010010ULL, 0x00005410ff197816ULL, 0x120fe40000000046ULL,
0x0000004c180f7223ULL, 0x080fe2000001000fULL, 0x00007610ff187816ULL, 0x000fe40000000046ULL,
0x0000004c190e7223ULL, 0x080fe2000001000eULL, 0x00005410ff197816ULL, 0x100fe40000000048ULL,
0x0000030034007a0cULL, 0x000fe20003f06070ULL, 0x0000004c180d7223ULL, 0x080fe2000001000dULL,
0x00007610ff187816ULL, 0x000fe20000000048ULL, 0x0000004c190c7223ULL, 0x000fe2000001000cULL,
0x00005410ff197816ULL, 0x000fc6000000003eULL, 0x0000004c180b7223ULL, 0x080fe2000001000bULL,
0x00007610ff187816ULL, 0x000fe2000000003eULL, 0x0000004c190a7223ULL, 0x000fe2000001000aULL,
0x00005410ff197816ULL, 0x002fc6000000004aULL, 0x0000004c18097223ULL, 0x080fe40000010009ULL,
0x0000004c19087223ULL, 0x000fe20000010008ULL, 0x00007610ff197816ULL, 0x000fca000000004aULL,
0x0000004c19067223ULL, 0x000fe20000010006ULL, 0xfffff32000008947ULL, 0x000fea000383ffffULL,
0x0180000033037810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000003037812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0001454000047802ULL, 0x000fe40000000f00ULL, 0x000071e000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300047308ULL, 0x000ea40000001000ULL, 0xbf80000004037423ULL, 0x004fc80000000033ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008033b7811ULL, 0x004fe400078ff0ffULL,
0x00000002ff337819ULL, 0x002fe40000011603ULL, 0x0000003bff3d7212ULL, 0x000fe200078e33ffULL,
0x00001f3b04077589ULL, 0x000e6200000e0000ULL, 0x000000083b187824ULL, 0x000fc400078e00ffULL,
0x00000008333f7824ULL, 0x000fe200078e00ffULL, 0x00001f3304057589ULL, 0x0004e400000e0000ULL,
0xfffffff8183d7812ULL, 0x000fca00078ee23dULL, 0x000000103d3d7824ULL, 0x000fe200078e0202ULL,
0x00000033ff047212ULL, 0x004fc800078e33ffULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee204ULL,
0x0000000733047812ULL, 0x000fe200078ec0ffULL, 0x0000001607167220ULL, 0x042fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000000d070d7220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000000b070b7220ULL, 0x040fe20000410000ULL, 0x0000000a070a7220ULL, 0x040fe20000410000ULL,
0x0000000907097220ULL, 0x040fe20000410000ULL, 0x0000000807087220ULL, 0x040fe20000410000ULL,
0x0000000607077220ULL, 0x000fe20000410000ULL, 0x0000000833067824ULL, 0x000fe200078e00ffULL,
0x0000000e0d0d723eULL, 0x000fe200000010ffULL, 0x0000002905297220ULL, 0x008fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x0000002805287220ULL, 0x000fe20000410000ULL,
0x0000000a0909723eULL, 0x000fe200000010ffULL, 0x0000003205327220ULL, 0x000fe20000410000ULL,
0x000000080707723eULL, 0x000fe200000010ffULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0xfffffff806177812ULL, 0x000fe200078ee233ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000000104067812ULL, 0x040fe200078e3cffULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000000204087812ULL, 0x040fe200078e3cffULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x00000003040a7812ULL, 0x040fe200078e3cffULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x00000004040c7812ULL, 0x040fe200078e3cffULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x00000005040e7812ULL, 0x040fe200078e3cffULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000000604047812ULL, 0x000fe200078e3cffULL, 0x0000002605267220ULL, 0x000fe20000410000ULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000002505257220ULL, 0x000fe20000410000ULL,
0x000000073b127812ULL, 0x000fe200078ec0ffULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x0000002105057220ULL, 0x000fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000000833197824ULL, 0x000fe200078e0206ULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x00000008331b7824ULL, 0x040fe200078e0208ULL,
0x0000000212067812ULL, 0x040fe200078e3cffULL, 0x00000008331d7824ULL, 0x040fe200078e020aULL,
0x0000000312087812ULL, 0x040fe200078e3cffULL, 0x00000008331f7824ULL, 0x040fe200078e020cULL,
0x00000004120a7812ULL, 0x040fe200078e3cffULL, 0x0000000833297824ULL, 0x000fe200078e0204ULL,
0x0000000112047812ULL, 0x040fe200078e3cffULL, 0x000000083b147824ULL, 0x000fe200078e00ffULL,
0x00000005120c7812ULL, 0x040fe200078e3cffULL, 0x0000000833217824ULL, 0x000fe200078e020eULL,
0x00000006120e7812ULL, 0x000fe200078e3cffULL, 0x0000000403107824ULL, 0x000fe200078e00ffULL,
0x0000002d2c2c723eULL, 0x000fe200000010ffULL, 0x000000083b2d7824ULL, 0x040fe200078e0204ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x000000083b337824ULL, 0x000fe200078e0206ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x000000083b357824ULL, 0x040fe200078e0208ULL,
0xfffffff8142b7812ULL, 0x000fe200078ee23bULL, 0x000000083b377824ULL, 0x040fe200078e020aULL,
0x0000000c10167812ULL, 0x000fe200078ec0ffULL, 0x000000083b397824ULL, 0x000fe200078e020cULL,
0x000000323131723eULL, 0x000fe200000010ffULL, 0x000000083b3b7824ULL, 0x000fe200078e020eULL,
0x000000302f2f723eULL, 0x000fe200000010ffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x000000220505723eULL, 0x000fe200000010ffULL, 0x000000101d1d7824ULL, 0x000fc400078e0202ULL,
0x000000103f067824ULL, 0x100fe400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe400078e0202ULL,
0x0000000116047824ULL, 0x000fe400078e0217ULL, 0x000000101f1f7824ULL, 0x100fe400078e0202ULL,
0x0000001021217824ULL, 0x100fe200078e0202ULL, 0x0000003104007388ULL, 0x0003e20000000800ULL,
0x0000001029297824ULL, 0x000fc400078e0202ULL, 0x000000102d2d7824ULL, 0x100fe400078e0202ULL,
0x0000001033337824ULL, 0x100fe400078e0202ULL, 0x0000001035357824ULL, 0x100fe400078e0202ULL,
0x0000001037377824ULL, 0x100fe400078e0202ULL, 0x0000001039397824ULL, 0x100fe400078e0202ULL,
0x000000103b3b7824ULL, 0x000fc400078e0202ULL, 0x0000000116027824ULL, 0x040fe400078e0219ULL,
0x00000001161b7824ULL, 0x040fe400078e021bULL, 0x00000001161d7824ULL, 0x040fe200078e021dULL,
0x0000002f02007388ULL, 0x0005e20000000800ULL, 0x00000001160a7824ULL, 0x040fe400078e0206ULL,
0x00000001161f7824ULL, 0x040fe200078e021fULL, 0x0000002c1b007388ULL, 0x0005e20000000800ULL,
0x0000000116067824ULL, 0x000fc400078e0221ULL, 0x0000000116087824ULL, 0x040fe200078e0229ULL,
0x0000002a1d007388ULL, 0x0005e20000000800ULL, 0x00000001160c7824ULL, 0x040fe400078e022bULL,
0x00000001160e7824ULL, 0x040fe200078e022dULL, 0x000000281f007388ULL, 0x0005e20000000800ULL,
0x0000000116047824ULL, 0x042fe400078e0233ULL, 0x0000000116107824ULL, 0x040fe200078e0235ULL,
0x0000002506007388ULL, 0x0005e20000000800ULL, 0x0000000116127824ULL, 0x000fc400078e0237ULL,
0x0000000116187824ULL, 0x040fe200078e023dULL, 0x0000002308007388ULL, 0x0005e20000000800ULL,
0x0000000116147824ULL, 0x040fe400078e0239ULL, 0x0000000116167824ULL, 0x000fe200078e023bULL,
0x000000050a007388ULL, 0x0005e80000000800ULL, 0x000000150c007388ULL, 0x0005e80000000800ULL,
0x000000130e007388ULL, 0x0005e80000000800ULL, 0x0000001104007388ULL, 0x0005e80000000800ULL,
0x0000000f10007388ULL, 0x0005e80000000800ULL, 0x0000000d12007388ULL, 0x0005e80000000800ULL,
0x0000000b14007388ULL, 0x0005e80000000800ULL, 0x0000000916007388ULL, 0x0005e80000000800ULL,
0x0000000718007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002003117810ULL, 0x004fe20007ffe0ffULL, 0x0000000000107919ULL, 0x000ea20000002600ULL,
0x00000003ff027819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff067819ULL, 0x002fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000702047812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000706077812ULL, 0x000fc400078e4811ULL, 0x0ffffff804057812ULL, 0x000fe400078ef803ULL,
0x0ffffff807077812ULL, 0x000fe400078ef811ULL, 0x0000000703127812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x100fe400078e0200ULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x0000000711007812ULL, 0x000fe400078ec0ffULL, 0x00a0000005087984ULL, 0x000e680000000c00ULL,
0x00a00000070c7984ULL, 0x0009620000000c00ULL, 0x0000000810137824ULL, 0x004fc400078e00ffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff813027812ULL, 0x000fe400078ee202ULL, 0xfffffff815067812ULL, 0x000fe400078ee206ULL,
0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL,
0x1ffffff812077812ULL, 0x010fe200078ef827ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0010027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0006047a11ULL, 0x000fc400078248ffULL, 0x00005b0010037a11ULL, 0x000fe400000f4c03ULL,
0x00005b0006057a11ULL, 0x000fe400008f4c05ULL, 0x1ffffff800277812ULL, 0x000fe200078ef827ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001027047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x002fe8000c101d06ULL, 0x0000000c04007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000042b037824ULL, 0x000fe400078e022eULL,
0xffffffffff027424ULL, 0x000fc600078e00ffULL, 0x0000002a0300720cULL, 0x000fda0003f06070ULL,
0x0000000204088824ULL, 0x004fc800078e00ffULL, 0x0000640008088a24ULL, 0x000fc800078e0203ULL,
0x0000600008088625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff0a7624ULL, 0x000fe200078e00ffULL, 0x0000000608028981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff0b7624ULL, 0x000fc600078e00ffULL, 0x01060000ff067f8cULL, 0x000e68000c80043fULL,
0x000000060a2f7981ULL, 0x000762000c1e9900ULL, 0x000000012b007810ULL, 0x000fe20007ffe0ffULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000402e287824ULL, 0x000fe400078e00ffULL,
0x000000290000720cULL, 0x000fe20003f06070ULL, 0x000000405b347824ULL, 0x000fc400078e00ffULL,
0x0000000402157c24ULL, 0x004fd4000f8e02ffULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x000001002b057824ULL, 0x00afe200078e0228ULL, 0x00000002ff197819ULL, 0x100fe4000001162dULL,
0x00000003ff107819ULL, 0x000fe4000001162dULL, 0x000000052c007217ULL, 0x000fe20007800000ULL,
0x000000405b5b7824ULL, 0x000fe200078e0219ULL, 0x0000000310107812ULL, 0x000fe400078e482dULL,
0x000000300e1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a05ULL,
0x000000105b087810ULL, 0x000fc40007ffe0ffULL, 0x000000085b057810ULL, 0x000fe40007ffe0ffULL,
0x0000005b15147210ULL, 0x040fe40007f1e0ffULL, 0x0000000815087210ULL, 0x040fe40007f5e0ffULL,
0x0000000515057210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e00140c7a11ULL, 0x000fe200078040ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x00005e00080d7a11ULL, 0x000fe200078440ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0005117a11ULL, 0x000fc400078240ffULL, 0x000000001900720cULL, 0x000fe40003f66070ULL,
0x00005f0014147a11ULL, 0x000fe400000f4409ULL, 0x00005f00080f7a11ULL, 0x000fe400010f440fULL,
0x00005f0005137a11ULL, 0x000fe400008f440aULL, 0x000020002e127811ULL, 0x000fe400078e68ffULL,
0x0ffffffc102d7812ULL, 0x000fc400078ef82dULL, 0x000000205b097810ULL, 0x000fe40007ffe0ffULL,
0x0000000c1b087210ULL, 0x000fe20007f1e0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0212ULL,
0x000000185b057810ULL, 0x000fe40007ffe0ffULL, 0x0000000915187210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0614ULL, 0x0000000515057210ULL, 0x000fe40007f3e0ffULL,
0x000000285b0a7810ULL, 0x000fc40007ffe0ffULL, 0x000000305b0b7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x000000385b5b7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082d7faeULL, 0x0003e2000d901c46ULL,
0x0000000a15167210ULL, 0x000fe40007fde0ffULL, 0x00005e00050e7a11ULL, 0x000fe400078840ffULL,
0x0000001b110a7210ULL, 0x000fe40007f7e0ffULL, 0x0000000b15147210ULL, 0x000fc40007f1e0ffULL,
0x0000005b155b7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e0613ULL,
0x0000000819157810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00005f0005057a11ULL, 0x000fe400020f440cULL, 0x0000001b0d0c7210ULL, 0x080fe40007f9e0ffULL,
0x0000001019117810ULL, 0x000fe40007ffe0ffULL, 0x000000001500720cULL, 0x0c0fe20003f66070ULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0x0000001b0e0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e060fULL, 0x0000001819177810ULL, 0x000fe20007ffe0ffULL,
0x0000000411097824ULL, 0x042fe200078e00ffULL, 0x000000001100720cULL, 0x080fe20003f86070ULL,
0x000000ffff0f7224ULL, 0x000fe200028e0605ULL, 0xfffffffc15057812ULL, 0x000fe200078ee210ULL,
0x0000000417117824ULL, 0x040fe200078e00ffULL, 0x000000001700720cULL, 0x000fc40003fa6070ULL,
0x00005e0018087a11ULL, 0x040fe200078440ffULL, 0x0000001005057824ULL, 0x000fe200078e0212ULL,
0xfffffffc09097812ULL, 0x100fe400078ee210ULL, 0xfffffffc11117812ULL, 0x000fe400078ee210ULL,
0x0000003019177810ULL, 0x000fe20007ffe0ffULL, 0x0000001009097824ULL, 0x100fe200078e0212ULL,
0x00005f0018187a11ULL, 0x000fe200010f4413ULL, 0x000000000a057faeULL, 0x0003e2000d901c46ULL,
0x0000002019137810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e0212ULL,
0x0000002819157810ULL, 0x040fe20007ffe0ffULL, 0x000000000c097faeULL, 0x0005e2000e101c46ULL,
0x0000003819197810ULL, 0x000fc40007ffe0ffULL, 0x000000001300720cULL, 0x080fe20003f46070ULL,
0x000000000e117faeULL, 0x0007e2000e901c46ULL, 0x000000001500720cULL, 0x080fe40003f66070ULL,
0x000000001700720cULL, 0x0c0fe20003f86070ULL, 0x00000004170b7824ULL, 0x002fe200078e00ffULL,
0x000000001900720cULL, 0x000fe20003fa6070ULL, 0x0000000413057824ULL, 0x000fe400078e00ffULL,
0x00000004190d7824ULL, 0x004fe200078e00ffULL, 0xfffffffc0b0b7812ULL, 0x100fe200078ee210ULL,
0x0000000415097824ULL, 0x000fe200078e00ffULL, 0xfffffffc05057812ULL, 0x000fe200078ee210ULL,
0x000000ffff0f7224ULL, 0x008fe200030e06ffULL, 0x00005e00160a7a11ULL, 0x040fe200078c40ffULL,
0x000000100b137824ULL, 0x000fe200078e0212ULL, 0xfffffffc0d0d7812ULL, 0x100fe200078ee210ULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0xfffffffc09097812ULL, 0x000fe200078ee210ULL,
0x0000001005057824ULL, 0x100fe200078e0212ULL, 0x00005f00160b7a11ULL, 0x000fe200030f440fULL,
0x000000100d157824ULL, 0x100fe200078e0212ULL, 0x0000001b08087210ULL, 0x080fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e00140c7a11ULL, 0x000fe200078040ffULL,
0x0000001009117824ULL, 0x000fe200078e0212ULL, 0x0000001b0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200030e0618ULL, 0x00005e005b0e7a11ULL, 0x000fc400078c40ffULL,
0x00005f00140d7a11ULL, 0x000fe200000f440dULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001b0c0c7210ULL, 0x080fe20007f1e0ffULL, 0x0000000008057faeULL, 0x0003e2000d101c46ULL,
0x00005f005b007a11ULL, 0x000fe400030f4400ULL, 0x0000001b0e0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000000a117faeULL, 0x0003e6000d901c46ULL,
0x000000ffff0f7224ULL, 0x000fe200008e0600ULL, 0x000000000c137faeULL, 0x0003e8000e101c46ULL,
0x000000000e157faeULL, 0x0003e2000e901c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x000000342d007211ULL, 0x04afe400078ff0ffULL, 0x000000082d197811ULL, 0x000fc400078ff0ffULL,
0x0000000015007210ULL, 0x000fe40007f1e0ffULL, 0x000000182d097811ULL, 0x040fe400078ff0ffULL,
0x000000202d0b7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x00005e0000177a11ULL, 0x000fe200078040ffULL, 0x00000001340a7824ULL, 0x040fe200078e0209ULL,
0x000000282d0d7811ULL, 0x000fe200078ff0ffULL, 0x00000001340c7824ULL, 0x000fe200078e020bULL,
0x00005f0000207a11ULL, 0x000fe200000f4405ULL, 0x0000000119007824ULL, 0x000fe200078e0234ULL,
0x000000302d117811ULL, 0x040fe200078ff0ffULL, 0x00000001340f7824ULL, 0x040fe200078e020dULL,
0x000000102d057811ULL, 0x000fe200078ff0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe2000001162dULL, 0x0000000134107824ULL, 0x000fe200078e0211ULL,
0x000000382d137811ULL, 0x000fe200078ff0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x0000000316167812ULL, 0x000fe200078e482dULL, 0x0000000134087824ULL, 0x000fe200078e0205ULL,
0x00000000151e7210ULL, 0x000fe20007fde0ffULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0x0000000a151a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x0000000c15187210ULL, 0x000fe20007f3e0ffULL, 0x0000000405057824ULL, 0x000fe200078e00ffULL,
0x000020002e237811ULL, 0x000fe200078e68ffULL, 0x0000000134127824ULL, 0x000fe200078e0213ULL,
0xfffffffc09097812ULL, 0x100fe200078ee216ULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b0a7812ULL, 0x100fe200078ee216ULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0000000815147210ULL, 0x000fe20007fbe0ffULL, 0x00000010091b7824ULL, 0x100fe200078e0223ULL,
0xfffffffc0d0b7812ULL, 0x100fe200078ee216ULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0xfffffffc110c7812ULL, 0x100fe200078ee216ULL, 0x000000100a1d7824ULL, 0x000fe200078e0223ULL,
0xfffffffc05087812ULL, 0x100fe200078ee216ULL, 0x000000ffff057224ULL, 0x000fe200030e06ffULL,
0x0ffffffc162d7812ULL, 0x000fe200078ef82dULL, 0x000000100b1f7824ULL, 0x100fe200078e0223ULL,
0xfffffffc19007812ULL, 0x000fe200078ee216ULL, 0x000000100c217824ULL, 0x100fe200078e0223ULL,
0x00005e001e1c7a11ULL, 0x000fe200078c40ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0223ULL,
0x0000000f150f7210ULL, 0x040fe20007f5e0ffULL, 0x0000001008197824ULL, 0x000fe200078e0223ULL,
0x0000001015107210ULL, 0x000fc40007f7e0ffULL, 0x0000001215127210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e06ffULL, 0xfffffffc130d7812ULL, 0x000fe200078ee216ULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x00005e00140c7a11ULL, 0x000fe400078a40ffULL,
0x00005e001a0b7a11ULL, 0x000fe400078040ffULL, 0x00005e0018117a11ULL, 0x000fe400078240ffULL,
0x00005f001e1e7a11ULL, 0x000fe200030f4405ULL, 0x0000001000057824ULL, 0x100fe200078e0223ULL,
0x000000300e227812ULL, 0x000fe200078ec0ffULL, 0x000000100d237824ULL, 0x000fe200078e0223ULL,
0x00005f00140d7a11ULL, 0x000fe200028f4415ULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005f001a1a7a11ULL, 0x000fe200000f4413ULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x00005f0018187a11ULL, 0x000fe200008f4409ULL, 0x000000ffff097224ULL, 0x000fe200020e06ffULL,
0x00005e000f137a11ULL, 0x000fc400078240ffULL, 0x00005e0012167a11ULL, 0x000fe400078640ffULL,
0x0000001722087210ULL, 0x000fe40007f1e0ffULL, 0x00005e0010147a11ULL, 0x000fe400078440ffULL,
0x00005f000f177a11ULL, 0x000fe400008f4400ULL, 0x00005f0012007a11ULL, 0x000fe200018f4409ULL,
0x000000ffff097224ULL, 0x000fe200000e0620ULL, 0x0000001c220a7210ULL, 0x000fc40007f1e0ffULL,
0x00005f0010157a11ULL, 0x000fe400010f4415ULL, 0x0000000c220c7210ULL, 0x040fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b220e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e061eULL,
0x0000001122107210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x0000001322127210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e061aULL,
0x0000001422147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0618ULL,
0x0000001622167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0617ULL,
0x000000000a057faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc400028e0615ULL,
0x000000ffff177224ULL, 0x000fe200000e0600ULL, 0x000000000c197faeULL, 0x0003e8000b901c46ULL,
0x000000000e1b7faeULL, 0x0003e8000b901c46ULL, 0x00000000101d7faeULL, 0x0003e8000b901c46ULL,
0x00000000121f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e4000b901c46ULL, 0x01060400ff057984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000005ff7812ULL, 0x002fc60007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000057305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01060400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x000000202e007824ULL, 0x002fc800078e0205ULL,
0x0000002000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc80000011600ULL,
0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL, 0x000001e006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105097812ULL, 0x040fe400078efcffULL, 0x0000000705077812ULL, 0x100fe400078e7800ULL,
0x0000000709097812ULL, 0x100fe400078e7800ULL, 0x00000010050b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x040fe200078e0207ULL, 0x0000001105057810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0x000000070b0b7812ULL, 0x000fc400078e7800ULL,
0x0000000007107984ULL, 0x000e62000000cc00ULL, 0x0000000705057812ULL, 0x000fe400078e7800ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x00000000090c7984ULL, 0x000ea4000000cc00ULL,
0x0000000106057824ULL, 0x000fe400078e0205ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fe200078e0013ULL, 0x0000001407007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fca00078e000fULL,
0x0000001809007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x000000000b107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c0b007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff067f8cULL, 0x000fe8000c80043fULL,
0x01060400ff057984ULL, 0x002e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000057305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01060400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000292b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000002d7919ULL, 0x000e620000000000ULL, 0x3d8000002f2f7820ULL, 0x020fe20000410000ULL,
0x0000640004367a24ULL, 0x000fe200078e02ffULL, 0x000106882e357811ULL, 0x040fe200078e18ffULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0xffffffff29387810ULL, 0x000fe40007ffe0ffULL,
0x000106082e377811ULL, 0x000fe400078e28ffULL, 0x000001002b3b7824ULL, 0x000fe200078e0228ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003b2c00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x03cfea0003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0039ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fc4000001ff00ULL, 0x0000000100247810ULL, 0x000fe20007ffe0ffULL,
0x00000d7000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0000ULL,
0x000000013d397812ULL, 0x000fe200078e0cffULL, 0x0000000402457c24ULL, 0x020fe2000f8e02ffULL,
0x00000002ff267819ULL, 0x100fe20000011624ULL, 0x000000ffff007224ULL, 0x000fe200078e0024ULL,
0x000000042400780cULL, 0x000fc40003f06070ULL, 0x0000000324547812ULL, 0x000fe200078ec0ffULL,
0x0000030026257a24ULL, 0x000fca00078e022bULL, 0x0000000125267810ULL, 0x000fc80007ffe0ffULL,
0x000000292600720cULL, 0x000fda0003f26070ULL, 0x000006c000009947ULL, 0x000fea0003800000ULL,
0x00000002ff417819ULL, 0x002fe2000001162dULL, 0x0000010025257824ULL, 0x000fc600078e0228ULL,
0x0000000841477810ULL, 0x040fe20007ffe0ffULL, 0x0000000141247824ULL, 0x140fe200078e0234ULL,
0x00000010414d7810ULL, 0x000fe40007ffe0ffULL, 0x000000252c327217ULL, 0x000fe20007800000ULL,
0x0000000147267824ULL, 0x100fe200078e0234ULL, 0x00000024453f7210ULL, 0x000fe20007f3e0ffULL,
0x000000014d277824ULL, 0x100fe200078e0234ULL, 0x00000018414f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001323a7824ULL, 0x000fe200078e0a25ULL, 0x0000002645337210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x0000002745317210ULL, 0x000fe20007f7e0ffULL,
0x000000014f327824ULL, 0x000fe200078e0234ULL, 0x0000002041517810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x00005e0033267a11ULL, 0x000fe200078440ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x00005e003f247a11ULL, 0x000fe200078240ffULL,
0x00000004474b7824ULL, 0x000fe200078e00ffULL, 0x0000003041557810ULL, 0x000fc40007ffe0ffULL,
0x00005f0033277a11ULL, 0x000fe200010f443eULL, 0x0000000134337824ULL, 0x040fe200078e0251ULL,
0x00005f003f257a11ULL, 0x000fe200008f4440ULL, 0x00000001343e7824ULL, 0x040fe200078e0255ULL,
0x00005e0031307a11ULL, 0x000fe400078640ffULL, 0x0000002841537810ULL, 0x000fe40007ffe0ffULL,
0x0000003245427210ULL, 0x000fe40007f3e0ffULL, 0x00005f0031317a11ULL, 0x000fe200018f443cULL,
0x00000001343c7824ULL, 0x000fe200078e0253ULL, 0x0000003345407210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff337224ULL, 0x000fe200008e06ffULL, 0x00005e0042327a11ULL, 0x000fc400078240ffULL,
0x0000003e45437210ULL, 0x000fe40007f9e0ffULL, 0x00000003ff3e7819ULL, 0x000fe4000001162dULL,
0x0000003a4100720cULL, 0x040fe20003f46070ULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x0000003841577810ULL, 0x000fe40007ffe0ffULL, 0x0000003c45417210ULL, 0x000fe20007fde0ffULL,
0x000000022e3c7824ULL, 0x000fe200078e0239ULL, 0x00005f0042337a11ULL, 0x000fe200008f4433ULL,
0x0000000454427824ULL, 0x000fe200078e00ffULL, 0x000000033e4e7812ULL, 0x000fe200078e482dULL,
0x00000001343f7824ULL, 0x000fe200078e0257ULL, 0x0000003a4700720cULL, 0x000fe20003f26070ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x000020003c3c7811ULL, 0x000fc400078e60ffULL,
0x0ffffffc4e497812ULL, 0x100fe400078ef82dULL, 0xfffffffc42477812ULL, 0x000fe400078ee22dULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e023cULL,
0x0000003f45457210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200028e06ffULL,
0x00005e00403e7a11ULL, 0x000fe200078a40ffULL, 0x0000001047247825ULL, 0x000fe200078e0024ULL,
0x00005e0043427a11ULL, 0x000fc400078840ffULL, 0x00005f00403f7a11ULL, 0x000fe200028f443fULL,
0x000000104b4b7824ULL, 0x000fe200078e023cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024497faeULL, 0x0003e2000d101c46ULL, 0x0000001047267825ULL, 0x000fe200078e0026ULL,
0x00005e0041407a11ULL, 0x000fe400078a40ffULL, 0x0000003a4f00720cULL, 0x080fe20003f46070ULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x00005e0045447a11ULL, 0x000fe200078640ffULL,
0x00000000264b7faeULL, 0x0005e2000c901c46ULL, 0x0000003a4d00720cULL, 0x0c0fe20003f26070ULL,
0x000000044d4d7824ULL, 0x000fe200078e00ffULL, 0x00005f0045457a11ULL, 0x000fe200018f4446ULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x00005f0043437a11ULL, 0x000fe200020f4448ULL,
0x0000001047247825ULL, 0x002fe200078e0030ULL, 0x0000003a5100720cULL, 0x000fc40003f66070ULL,
0x00005f0041417a11ULL, 0x000fe200028f444aULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x0000003a5300720cULL, 0x0c0fe20003f86070ULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0x0000003a5500720cULL, 0x0c0fe20003fa6070ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0x0000003a5700720cULL, 0x040fe20003fc6070ULL, 0x0000000457577824ULL, 0x000fe200078e00ffULL,
0xfffffffc4d497812ULL, 0x000fe200078ee24eULL, 0x0000001047267825ULL, 0x004fe200078e0032ULL,
0xfffffffc4f4b7812ULL, 0x000fc400078ee24eULL, 0xfffffffc514d7812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e023cULL, 0xfffffffc534f7812ULL, 0x000fe200078ee24eULL,
0x000000104b4b7824ULL, 0x000fe200078e023cULL, 0xfffffffc55517812ULL, 0x000fe200078ee24eULL,
0x000000104d4d7824ULL, 0x000fe200078e023cULL, 0xfffffffc57537812ULL, 0x000fe200078ee24eULL,
0x0000001047307825ULL, 0x000fe200078e003eULL, 0x0000000024497faeULL, 0x0003e6000c901c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e023cULL, 0x00000000264b7faeULL, 0x0003e2000d101c46ULL,
0x0000001047327825ULL, 0x000fc600078e0040ULL, 0x00000000304d7faeULL, 0x0003e2000d901c46ULL,
0x0000001051517824ULL, 0x000fe400078e023cULL, 0x00000010473e7825ULL, 0x000fe200078e0042ULL,
0x00000000324f7faeULL, 0x0003e6000e101c46ULL, 0x0000001053537824ULL, 0x000fe200078e023cULL,
0x000000003e517faeULL, 0x0003e2000e901c46ULL, 0x0000001047407825ULL, 0x000fca00078e0044ULL,
0x0000000040537faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x000000082d437811ULL, 0x042fe200078ff0ffULL, 0x0000000454527824ULL, 0x000fe200078e00ffULL,
0x000000342d247211ULL, 0x040fe400078ff0ffULL, 0x000000102d477811ULL, 0x000fe200078ff0ffULL,
0x0000000143267824ULL, 0x040fe200078e0234ULL, 0x0000004524257210ULL, 0x080fe20007f3e0ffULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0x000000202d4b7811ULL, 0x000fe200078ff0ffULL,
0x00000001343a7824ULL, 0x000fe200078e0247ULL, 0x0000004526277210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078240ffULL,
0x00000001343e7824ULL, 0x040fe200078e024bULL, 0x000000182d497811ULL, 0x000fe200078ff0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078440ffULL,
0x0000000447477824ULL, 0x000fe200078e00ffULL, 0x000000282d4d7811ULL, 0x040fe200078ff0ffULL,
0x00000001343c7824ULL, 0x040fe200078e0249ULL, 0x000000302d4f7811ULL, 0x000fe200078ff0ffULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x000000382d517811ULL, 0x000fe200078ff0ffULL,
0x0000000134407824ULL, 0x040fe200078e024dULL, 0x00005f0025257a11ULL, 0x000fe200008f4432ULL,
0x0000000134427824ULL, 0x000fe200078e024fULL, 0x00005f0027277a11ULL, 0x000fe200010f4430ULL,
0x000000022e307824ULL, 0x000fe200078e0239ULL, 0x00000003ff327819ULL, 0x000fe2000001162dULL,
0x0000000134447824ULL, 0x000fe200078e0251ULL, 0x000000453a317210ULL, 0x080fe20007fde0ffULL,
0x000000044b4b7824ULL, 0x000fe200078e00ffULL, 0x000000453e3f7210ULL, 0x080fe20007f9e0ffULL,
0x000000044d4d7824ULL, 0x000fe200078e00ffULL, 0x00000003323e7812ULL, 0x000fe200078e482dULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x000000453c337210ULL, 0x000fe20007fbe0ffULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x0000200030537811ULL, 0x000fe200078e60ffULL,
0x000000ffff327224ULL, 0x000fe200030e06ffULL, 0x00005e0031307a11ULL, 0x000fc400078c40ffULL,
0x0000004540417210ULL, 0x080fe40007f3e0ffULL, 0x00000045423c7210ULL, 0x080fe40007f5e0ffULL,
0x00000045443a7210ULL, 0x000fe40007f7e0ffULL, 0xfffffffc43427812ULL, 0x100fe200078ee23eULL,
0x000000ffff437224ULL, 0x000fe200010e06ffULL, 0xfffffffc47447812ULL, 0x100fe200078ee23eULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0xfffffffc49467812ULL, 0x100fe200078ee23eULL,
0x0000001042477824ULL, 0x100fe200078e0253ULL, 0xfffffffc4b487812ULL, 0x100fe200078ee23eULL,
0x0000001044497824ULL, 0x100fe200078e0253ULL, 0xfffffffc4d4a7812ULL, 0x100fe200078ee23eULL,
0x00000010464b7824ULL, 0x100fe200078e0253ULL, 0xfffffffc4f4e7812ULL, 0x100fe200078ee23eULL,
0x00000010484d7824ULL, 0x000fe200078e0253ULL, 0x0ffffffc3e407812ULL, 0x000fe200078ef82dULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0xfffffffc51507812ULL, 0x000fe200078ee23eULL,
0x000000ffff3e7224ULL, 0x000fe200028e06ffULL, 0x00005f0031317a11ULL, 0x000fe200030f4432ULL,
0x0000001040577824ULL, 0x000fe200078e0253ULL, 0x00005e0033327a11ULL, 0x040fe200078a40ffULL,
0x000000ffff467224ULL, 0x000fe200008e06ffULL, 0xfffffffc52557812ULL, 0x000fe200078ee22dULL,
0x000000104a4f7824ULL, 0x100fe200078e0253ULL, 0x00005f0033337a11ULL, 0x000fe200028f443eULL,
0x000000104e517824ULL, 0x000fe200078e0253ULL, 0x00005e003f3e7a11ULL, 0x000fe200078840ffULL,
0x0000001055247825ULL, 0x000fe200078e0024ULL, 0x00005e0041407a11ULL, 0x000fc400078240ffULL,
0x00005e003c427a11ULL, 0x000fe200078440ffULL, 0x0000001055267825ULL, 0x000fe200078e0026ULL,
0x00005e003a447a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024577faeULL, 0x0003e2000b901c46ULL, 0x00005f003f3f7a11ULL, 0x000fe200020f4448ULL,
0x0000001055307825ULL, 0x000fe200078e0030ULL, 0x00005f0041417a11ULL, 0x000fe200008f4446ULL,
0x0000000026477faeULL, 0x0003e2000b901c46ULL, 0x00005f003c437a11ULL, 0x000fe200010f4443ULL,
0x0000001055327825ULL, 0x040fe200078e0032ULL, 0x00005f003a457a11ULL, 0x000fe200018f4445ULL,
0x0000000030497faeULL, 0x0003e4000b901c46ULL, 0x00000010553e7825ULL, 0x000fc400078e003eULL,
0x00000000324b7faeULL, 0x0003e4000b901c46ULL, 0x0000001055407825ULL, 0x040fe400078e0040ULL,
0x000000003e4d7faeULL, 0x0003e4000b901c46ULL, 0x0000001055427825ULL, 0x000fe400078e0042ULL,
0x00000000404f7faeULL, 0x0003e4000b901c46ULL, 0x0000001050537824ULL, 0x000fc400078e0253ULL,
0x0000001055447825ULL, 0x000fe200078e0044ULL, 0x0000000042517faeULL, 0x0003e8000b901c46ULL,
0x0000000044537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035400780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x00000004ff257424ULL, 0x002fe400078e00ffULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x0000030025037a24ULL, 0x000fca00078e0203ULL,
0x0000002a0300720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x0000000236247824ULL, 0x000fc800078e0203ULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x0000000624027981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000084c3c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff82d247812ULL, 0x042fe200078ec0ffULL, 0x000000022e267824ULL, 0x000fe200078e023dULL,
0x000000202d307810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000724247812ULL, 0x000fe400078ef82dULL, 0xfffffff830307812ULL, 0x000fc400078ec0ffULL,
0x00000001ff257819ULL, 0x000fe40000011624ULL, 0x00000007303e7812ULL, 0x000fe400078ef82dULL,
0x0000000325257812ULL, 0x000fe400078ec0ffULL, 0x00000001ff307819ULL, 0x000fe4000001163eULL,
0x000000013a407810ULL, 0x000fe40007ffe0ffULL, 0x0000003a25277212ULL, 0x000fc400078e3cffULL,
0x00000003303f7812ULL, 0x000fe400078ec0ffULL, 0x0000004025257212ULL, 0x000fe200078e3cffULL,
0x0000000424277824ULL, 0x000fe200078e0227ULL, 0x0000200026267811ULL, 0x000fe400078e60ffULL,
0x0000003a3f317212ULL, 0x000fe200078e3cffULL, 0x0000000424257824ULL, 0x000fe200078e0225ULL,
0x000000072d427812ULL, 0x000fe200078ec0ffULL, 0x0000001027277824ULL, 0x100fe200078e0226ULL,
0x000000403f3f7212ULL, 0x000fe200078e3cffULL, 0x000000043e317824ULL, 0x000fe200078e0231ULL,
0x0000003c2d247211ULL, 0x000fe200078fe0ffULL, 0x0000001025417824ULL, 0x100fe200078e0226ULL,
0x0000000842457812ULL, 0x000fe200078ef82dULL, 0x000000043e3f7824ULL, 0x000fe200078e023fULL,
0x0000000224257810ULL, 0x040fe20007ffe0ffULL, 0x0000001031317824ULL, 0x100fe200078e0226ULL,
0x0000000724247812ULL, 0x100fe200078e7845ULL, 0x000000103f267824ULL, 0x000fe200078e0226ULL,
0x0000000725257812ULL, 0x000fe200078e7845ULL, 0x000000002748783bULL, 0x000e620000000200ULL,
0x000000023a3a7810ULL, 0x000fe20007ffe0ffULL, 0x00000020454e7824ULL, 0x040fe200078e0224ULL,
0x000000043c3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000003130783bULL, 0x000ea20000000200ULL,
0x0000002045457824ULL, 0x000fe200078e0225ULL, 0x000000043a00780cULL, 0x000fc40003f25270ULL,
0x000000002624783bULL, 0x000ee80000000200ULL, 0x000000004140783bULL, 0x000f220000000200ULL,
0x00000010ff4f7819ULL, 0x102fe40000011648ULL, 0x00000018ff3e7819ULL, 0x000fe40000011648ULL,
0x000000ff48467812ULL, 0x040fe400078ec0ffULL, 0x0000ffff48707812ULL, 0x000fc400078ec0ffULL,
0x00000010ff507819ULL, 0x100fe40000011649ULL, 0x00000018ff477819ULL, 0x000fe40000011649ULL,
0x000000ff49487812ULL, 0x040fe400078ec0ffULL, 0x0000ffff49717812ULL, 0x000fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x00000010ff577819ULL, 0x004fc40000011630ULL,
0x00000018ff537819ULL, 0x000fe40000011630ULL, 0x000000ff30547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff30837812ULL, 0x000fe400078ec0ffULL, 0x00000010ff307819ULL, 0x108fe40000011624ULL,
0x00000018ff7b7819ULL, 0x000fe40000011624ULL, 0x000000ff247c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff24447812ULL, 0x000fe400078ec0ffULL, 0x00000008ff247819ULL, 0x000fe40000011670ULL,
0x00000010ff517819ULL, 0x000fe4000001164aULL, 0x000000ff4a4c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4a727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff527819ULL, 0x000fc4000001164bULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x000000ff4b4d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4b737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x100fe40000011632ULL,
0x00000018ff587819ULL, 0x000fe40000011632ULL, 0x000000ff32597812ULL, 0x000fc400078ec0ffULL,
0x0000ffff32617812ULL, 0x000fe400078ec0ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000018ff4b7819ULL, 0x010fe40000011640ULL, 0x00000010ff777819ULL, 0x100fe20000011643ULL,
0x20000049ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x000fe40000011643ULL,
0x000000ff436f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff43877812ULL, 0x000fe400078ec0ffULL,
0x0000003eff32723eULL, 0x000fe400020006ffULL, 0x000000ff426c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff437819ULL, 0x100fe20000011625ULL, 0x20000032ff6e7230ULL, 0x000fe20000004100ULL,
0x00000018ff7d7819ULL, 0x000fe40000011625ULL, 0x000000ff257e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff253e7812ULL, 0x000fe400078ec0ffULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000008ff257819ULL, 0x000fe40000011671ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x0000006cff49723eULL, 0x000fe200020006ffULL,
0x20000024ff6c7230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x2000004cff637230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe20000011672ULL,
0x2000004bff4c7230ULL, 0x000fe20000004100ULL, 0x0000006fff4b723eULL, 0x000fe200020006ffULL,
0x20000025ff6f7230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe200020006ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000008ff257819ULL, 0x000fe20000011673ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000ffff40847812ULL, 0x000fe200078ec0ffULL,
0x20000024ff717230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x00000008ff247819ULL, 0x000fe40000011684ULL, 0x0000ffff41857812ULL, 0x000fe200078ec0ffULL,
0x20000025ff737230ULL, 0x000fe20000004100ULL, 0x000000ff31567812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011633ULL, 0x000000ff405d7812ULL, 0x000fe400078ec0ffULL,
0x00000024ff24723eULL, 0x000fc400020006ffULL, 0x00000008ff257819ULL, 0x000fe40000011685ULL,
0x0000ffff42867812ULL, 0x000fe400078ec0ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x0000004dff32723eULL, 0x000fe400020006ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011641ULL,
0x20000046ff6b7230ULL, 0x000fe20000004100ULL, 0x0000005dff4d723eULL, 0x000fe200020006ffULL,
0x20000024ff5d7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x20000056ff797230ULL, 0x000fe20000004100ULL, 0x00000018ff557819ULL, 0x000fc40000011631ULL,
0x00000008ff247819ULL, 0x000fe20000011686ULL, 0x20000025ff567230ULL, 0x000fe20000004100ULL,
0x0000005eff46723eULL, 0x000fe200020006ffULL, 0x2000005aff5e7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000024ff5a723eULL, 0x000fe200020006ffULL,
0x000000104e247824ULL, 0x000fe200078e00ffULL, 0x00000008ff257819ULL, 0x000fe20000011687ULL,
0x20000055ff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fe20000011640ULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe20000011641ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff41657812ULL, 0x000fc400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe40000011642ULL, 0x00000018ff667819ULL, 0x000fe40000011642ULL,
0x00000010ff3f7819ULL, 0x100fe40000011626ULL, 0x00000018ff7f7819ULL, 0x000fe40000011626ULL,
0x000000ff26807812ULL, 0x040fe400078ec0ffULL, 0x0000ffff26407812ULL, 0x000fc400078ec0ffULL,
0x00000010ff417819ULL, 0x100fe40000011627ULL, 0x00000018ff817819ULL, 0x000fe40000011627ULL,
0x000000ff27827812ULL, 0x040fe400078ec0ffULL, 0x0000ffff27427812ULL, 0x000fe400078ec0ffULL,
0x00000025ff55723eULL, 0x000fe400020006ffULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x000000ff4f4f7812ULL, 0x000fc400078ec0ffULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x0000ffff31687812ULL, 0x000fe200078ec0ffULL, 0x2000004aff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff50507812ULL, 0x000fe400078ec0ffULL, 0x0000006dff4a723eULL, 0x000fe200020006ffULL,
0x2000004fff6d7230ULL, 0x000fe20000004100ULL, 0x00000008ff687819ULL, 0x000fc40000011668ULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000047ff697230ULL, 0x000fe20000004100ULL, 0x000010546c6c7816ULL, 0x000fe2000000006bULL,
0x20000050ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x000000ff626b7812ULL, 0x000fe400078ec0ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000008ff627819ULL, 0x000fe20000011661ULL,
0x20000068ff617230ULL, 0x000fe20000004100ULL, 0x000000ff52527812ULL, 0x000fe200078ec0ffULL,
0x20000048ff6a7230ULL, 0x000fe20000004100ULL, 0x000010546e6d7816ULL, 0x000fc4000000006dULL,
0x0000006bff6e723eULL, 0x000fe400020006ffULL, 0x00000062ff68723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x0000006c240c723cULL, 0x002fe2000004180cULL,
0x00000010ff627819ULL, 0x000fe20000011669ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fe20000011670ULL, 0x20000052ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fc40000011631ULL, 0x00000010ff317819ULL, 0x000fe20000011633ULL,
0x20000068ff6c7230ULL, 0x000fe20000004100ULL, 0x00001054626b7816ULL, 0x000fe4000000006bULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fc40000011671ULL,
0x000000ff31317812ULL, 0x000fe400078ec0ffULL, 0x000010546f6a7816ULL, 0x000fe4000000006aULL,
0x0000105462687816ULL, 0x000fe40000000063ULL, 0x00000010ff627819ULL, 0x000fe4000001165fULL,
0x00000010ff637819ULL, 0x000fe20000011674ULL, 0x0000006a2408723cULL, 0x000fe20000041808ULL,
0x00000010ff327819ULL, 0x000fc40000011632ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000031ff31723eULL, 0x000fe400020006ffULL, 0x000000ff335b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff33337812ULL, 0x000fe200078ec0ffULL, 0x20000031ff6a7230ULL, 0x000fe20000004100ULL,
0x0000105462637816ULL, 0x000fe20000000063ULL, 0x0000001045317824ULL, 0x000fe200078e00ffULL,
0x0000105473627816ULL, 0x000fc40000000032ULL, 0x000000ff30327812ULL, 0x000fe400078ec0ffULL,
0x00000008ff337819ULL, 0x000fe40000011633ULL, 0x00000010ff307819ULL, 0x000fe20000011661ULL,
0x000000622420723cULL, 0x000fe20000041820ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x000000ff51517812ULL, 0x000fe400078ec0ffULL, 0x00000058ff58723eULL, 0x000fc400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x00000033ff5f723eULL, 0x000fe400020006ffULL,
0x00000032ff61723eULL, 0x000fe200020006ffULL, 0x20000054ff757230ULL, 0x000fe20000004100ULL,
0x0000105430627816ULL, 0x000fe20000000079ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000065ff47723eULL, 0x000fe200020006ffULL, 0x000000003130783bULL, 0x000e620000000200ULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x20000058ff657230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000051ff727230ULL, 0x000fe20000004100ULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x20000053ff787230ULL, 0x000fe20000004100ULL,
0x000000ff76767812ULL, 0x000fc400078ec0ffULL, 0x000000ff77777812ULL, 0x000fe400078ec0ffULL,
0x000000ff57587812ULL, 0x000fe400078ec0ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x00000008ff577819ULL, 0x000fe40000011683ULL, 0x00000060ff54723eULL, 0x000fe200020006ffULL,
0x2000005bff607230ULL, 0x000fe20000004100ULL, 0x00000076ff5b723eULL, 0x000fc400020006ffULL,
0x00000077ff53723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000058ff77723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000057ff76723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe20000011672ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000066ff48723eULL, 0x000fe200020006ffULL,
0x20000059ff667230ULL, 0x000fe20000004100ULL, 0x0000105464697816ULL, 0x000fc40000000069ULL,
0x00000010ff647819ULL, 0x000fe20000011665ULL, 0x20000061ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe20000011667ULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x000fe20000011678ULL, 0x000000682404723cULL, 0x000fe20000041804ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff767819ULL, 0x000fc40000011676ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff677819ULL, 0x000fe4000001166eULL,
0x00000010ff457819ULL, 0x000fe4000001166cULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff607819ULL, 0x000fc40000011660ULL, 0x00000010ff617819ULL, 0x000fe4000001166aULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x0000105478777816ULL, 0x000fe40000000077ULL,
0x0000105476767816ULL, 0x000fe40000000075ULL, 0x000010547a637816ULL, 0x000fe40000000063ULL,
0x0000105464677816ULL, 0x000fc40000000067ULL, 0x0000105445667816ULL, 0x000fe20000000066ULL,
0x00000076241c723cULL, 0x040fe2000004181cULL, 0x000010545e617816ULL, 0x000fe40000000061ULL,
0x000010545f607816ULL, 0x000fe40000000060ULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x000000622414723cULL, 0x000fe20000041814ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff567819ULL, 0x000fe20000011656ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff447819ULL, 0x000fe20000011644ULL, 0x000000662418723cULL, 0x000fe20000041818ULL,
0x000000ff43457812ULL, 0x000fe400078ec0ffULL, 0x00000044ff43723eULL, 0x000fe400020006ffULL,
0x00000045ff62723eULL, 0x000fc400020006ffULL, 0x00000010ff4c7819ULL, 0x000fe2000001164cULL,
0x000000602410723cULL, 0x000fe20000041810ULL, 0x00000010ff4d7819ULL, 0x000fe2000001164dULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x000fe2000001165cULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fe4000001165dULL,
0x00000010ff257819ULL, 0x000fe40000011654ULL, 0x0000105456247816ULL, 0x000fc40000000047ULL,
0x0000105446257816ULL, 0x000fe40000000025ULL, 0x00000008ff3e7819ULL, 0x000fe4000001163eULL,
0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff407819ULL, 0x000fe20000011640ULL,
0x000000243008723cULL, 0x002fe20000041808ULL, 0x000000ff41417812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fc40000011642ULL, 0x000010544c457816ULL, 0x000fe40000000045ULL,
0x0000105444447816ULL, 0x000fe4000000004dULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff257819ULL, 0x000fe20000011653ULL,
0x00000044300c723cULL, 0x000fe2000004180cULL, 0x00000010ff247819ULL, 0x000fc40000011655ULL,
0x0000007bff4e723eULL, 0x000fe400020006ffULL, 0x0000007cff4f723eULL, 0x000fe400020006ffULL,
0x0000007dff50723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x0000007eff51723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000007fff52723eULL, 0x000fe200020006ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000081ff59723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000080ff577230ULL, 0x000fe20000004100ULL,
0x0000003eff3e723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x20000082ff587230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x2000003fff447230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x000010544a257816ULL, 0x000fc40000000025ULL, 0x0000105424247816ULL, 0x000fe2000000004bULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe20000011643ULL,
0x20000041ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff497819ULL, 0x000fe20000011649ULL, 0x000000243020723cULL, 0x000fe20000041820ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff5a7819ULL, 0x000fc4000001165aULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff277819ULL, 0x000fe40000011665ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff3f7819ULL, 0x000fe40000011662ULL, 0x00000010ff517819ULL, 0x000fc40000011651ULL,
0x00000010ff3e7819ULL, 0x000fe4000001163eULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff417819ULL, 0x000fe40000011644ULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff247819ULL, 0x000fc40000011659ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff257819ULL, 0x000fe40000011642ULL, 0x00001054485b7816ULL, 0x000fe4000000005bULL,
0x000010545a5a7816ULL, 0x000fe40000000049ULL, 0x000010544e277816ULL, 0x000fc40000000027ULL,
0x0000105426267816ULL, 0x000fe4000000004fULL, 0x00001054503f7816ULL, 0x000fe2000000003fULL,
0x0000005a3004723cULL, 0x040fe20000041804ULL, 0x000010543e3e7816ULL, 0x000fe40000000051ULL,
0x0000105452417816ULL, 0x000fe40000000041ULL, 0x0000105440407816ULL, 0x000fe40000000057ULL,
0x0000105424597816ULL, 0x000fe20000000043ULL, 0x00000026301c723cULL, 0x000fe2000004181cULL,
0x0000105425587816ULL, 0x000fce0000000058ULL, 0x0000003e3014723cULL, 0x040ff00000041814ULL,
0x000000403018723cULL, 0x040ff00000041818ULL, 0x000000583010723cULL, 0x000fe20000041810ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe82000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd95000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000035247f8cULL, 0x000fe2000c80043fULL, 0x000000212f217220ULL, 0x040fe20000410000ULL,
0x0000000e2f007220ULL, 0x040fe20000410000ULL, 0x0000000f2f267220ULL, 0x040fe20000410000ULL,
0x0000040035277984ULL, 0x000e620000000800ULL, 0x000000222f227220ULL, 0x040fe20000410000ULL,
0x0000001d2f1d7220ULL, 0x040fe20000410000ULL, 0x000000172f337220ULL, 0x040fe20000410000ULL,
0x0000000c2f0c7220ULL, 0x040fe20000410000ULL, 0x0000000d2f0d7220ULL, 0x040fe20000410000ULL,
0x0000000a2f307220ULL, 0x040fe20000410000ULL, 0x0000000b2f317220ULL, 0x040fe20000410000ULL,
0x000000042f0e7220ULL, 0x040fe20000410000ULL, 0x000000052f0f7220ULL, 0x040fe20000410000ULL,
0x000000202f207220ULL, 0x040fe20000410000ULL, 0x000000232f237220ULL, 0x040fe20000410000ULL,
0x000000162f327220ULL, 0x040fe20000410000ULL, 0x000000192f177220ULL, 0x040fe20000410000ULL,
0x000000082f087220ULL, 0x040fe20000410000ULL, 0x000000092f097220ULL, 0x040fe20000410000ULL,
0x000000062f067220ULL, 0x040fe20000410000ULL, 0x000000072f077220ULL, 0x040fe20000410000ULL,
0x0000001c2f1c7220ULL, 0x040fe20000410000ULL, 0x0000001e2f047220ULL, 0x040fe20000410000ULL,
0x0000001f2f057220ULL, 0x040fe20000410000ULL, 0x0000001a2f3a7220ULL, 0x040fe20000410000ULL,
0x0000001b2f3c7220ULL, 0x040fe20000410000ULL, 0x000000112f197220ULL, 0x040fe20000410000ULL,
0x000000182f167220ULL, 0x040fe20000410000ULL, 0x000000132f3e7220ULL, 0x040fe20000410000ULL,
0x000000ffff117224ULL, 0x000fe200078e0021ULL, 0x000000102f187220ULL, 0x040fe20000410000ULL,
0x000000ffff137224ULL, 0x000fe200078e001dULL, 0x000000122f3d7220ULL, 0x040fe20000410000ULL,
0x000000ffff217224ULL, 0x000fe200078e0022ULL, 0x000000142f147220ULL, 0x040fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000cULL, 0x000000152f157220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fc400078e000dULL, 0x000000ffff107224ULL, 0x000fe400078e0020ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0026ULL, 0x8000000027ff7812ULL, 0x002fe20007804825ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0030ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0031ULL,
0x000000ffff227224ULL, 0x000fe400078e0023ULL, 0x000000ffff277224ULL, 0x000fc400078e0032ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff127224ULL, 0x000fe400078e001cULL, 0x000000ffff1a7224ULL, 0x000fe400078e0000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0006ULL, 0x000000ffff207224ULL, 0x000fc400078e0007ULL,
0x000000ffff237224ULL, 0x000fe400078e0004ULL, 0x000000ffff267224ULL, 0x000fe400078e0005ULL,
0x000000ffff307224ULL, 0x000fe400078e0033ULL, 0x000000ffff317224ULL, 0x000fe400078e003aULL,
0x000000ffff327224ULL, 0x000fe200078e003cULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff337224ULL, 0x000fc400078e003dULL,
0x000000ffff3a7224ULL, 0x000fe200078e003eULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x0000040035057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000042d1c7824ULL, 0x000fe200078e00ffULL,
0x000000382b00720cULL, 0x000fc80003f05270ULL, 0xfffffff01c057812ULL, 0x000fca00078ec0ffULL,
0x000000802e007824ULL, 0x000fca00078e0205ULL, 0x0104000000047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000022d087824ULL, 0x000fe400078e00ffULL,
0x000000012c3b7824ULL, 0x000fc600078e0a3bULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108247812ULL, 0x040fe400078efcffULL, 0x00000008083c7812ULL, 0x000fe400078efcffULL,
0x0000003b2400720cULL, 0x080fe40003f26070ULL, 0x0000001008247812ULL, 0x000fe400078efcffULL,
0x0000003b3c00720cULL, 0x080fe40003f06070ULL, 0x0000003b2400720cULL, 0x000fc40003fc6070ULL,
0x00000011083c7812ULL, 0x040fe400078efcffULL, 0x0000001808247812ULL, 0x040fe400078efcffULL,
0x0000003b0800720cULL, 0x080fe40003f46070ULL, 0x0000003b3c00720cULL, 0x080fe40003fa6070ULL,
0x0000003b2400720cULL, 0x000fe40003f66070ULL, 0x00000009083e7812ULL, 0x000fc400078efcffULL,
0x00000019083c7812ULL, 0x040fe400078efcffULL, 0x0000002008247812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL,
0x0000003b3e00720cULL, 0x080fe40003f86070ULL, 0x0000003b3c00720cULL, 0x080fe40003f46070ULL,
0x0000003b2400720cULL, 0x000fe40003f26070ULL, 0x00000021083c7812ULL, 0x040fe400078efcffULL,
0x0000002808247812ULL, 0x000fe400078efcffULL, 0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000003b3c00720cULL, 0x080fe40003f06070ULL,
0x0000003b2400720cULL, 0x000fe40003f86070ULL, 0x00000029083c7812ULL, 0x000fc400078efcffULL,
0x0000003008247812ULL, 0x000fe400078efcffULL, 0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000003b3c00720cULL, 0x000fc40003fc6070ULL,
0x0000003b2400720cULL, 0x000fe40003fa6070ULL, 0x00000031083c7812ULL, 0x040fe400078efcffULL,
0x0000003808247812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff23237808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000003b3c00720cULL, 0x080fe40003f66070ULL, 0x0000003b2400720cULL, 0x000fc40003f46070ULL,
0x0000003b0800720cULL, 0x000fe40003f26070ULL, 0xff7fffff26267808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff27277808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff30307808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff31317808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff32327808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff33337808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff3a3a7808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff407424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000003005047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000003104057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000003205047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000003304057209ULL, 0x000fe40007810000ULL, 0x00000019083b7209ULL, 0x000fe40007810000ULL,
0x0000003a053d7209ULL, 0x000fe20007810000ULL, 0x00001a927f007947ULL, 0x000fea000b800000ULL,
0x0c401f003b047f89ULL, 0x0004e400000e0000ULL, 0x000000043b3b7209ULL, 0x00cfe20007810000ULL,
0x00001ac27f007947ULL, 0x000fea000b800000ULL, 0x0c401f003d047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007247f89ULL, 0x000f2200000e0000ULL,
0x000000043d087209ULL, 0x004fc60007810000ULL, 0x0c201f003b047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000002407247209ULL, 0x010fc60007810000ULL, 0x0c201f00093c7f89ULL, 0x002e6800000e0000ULL,
0x0c201f0024257f89ULL, 0x00092200000e0000ULL, 0x000000043b047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000003c09067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fc40000000000ULL,
0x00000005ff3c7e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3f8000003c3c783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL, 0x000000ffff3d7224ULL, 0x000fe200078e003cULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3a197823ULL, 0x000fe20000010819ULL,
0x0000000000087886ULL, 0x000fc400038e0100ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x000ff00000000800ULL, 0x0000001e001e7308ULL, 0x000ee20000000800ULL,
0x0000001a1b09723eULL, 0x002fce00000010ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x008fce00000010ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000003c0840723cULL, 0x000fee00000418ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000010ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000010ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000010ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000003c0c40723cULL, 0x000fee0000041840ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe200000010ffULL,
0x0000000fff157424ULL, 0x000fe200078e00ffULL, 0xfffffffc2d147812ULL, 0x000fc800078ec0ffULL,
0x00000014156a7219ULL, 0x000fe200000006ffULL, 0x0000002700277308ULL, 0x000fe60000000800ULL,
0x000000006a1b73a1ULL, 0x000ee200000e8000ULL, 0x000000006a0573c4ULL, 0x000f280000004000ULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x000000232611723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000273013723eULL, 0x004fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000086aff7c12ULL, 0x008fe2000f80401bULL,
0x0000003c1040723cULL, 0x000fec0000041840ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x004fe400000010ffULL, 0x0000002425077209ULL, 0x010fca0007810000ULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x00000019001a7308ULL, 0x000ea20000000800ULL,
0x000000313215723eULL, 0x002fe400000010ffULL, 0x000000331a17723eULL, 0x004fce00000010ffULL,
0x0000003c1440723cULL, 0x000fe20000041840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x000015d205008947ULL, 0x000fde000b800000ULL, 0x001c1fff40187589ULL, 0x0002a400000e0000ULL,
0x000000006a1973a1ULL, 0x000ee200000e8000ULL, 0x000000006a0573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x000000086aff7c12ULL, 0x008fda000f804019ULL,
0x000015e205008947ULL, 0x010fea000b800000ULL, 0x001c1fff42197589ULL, 0x00072800000e0000ULL,
0x001c1fff011a7589ULL, 0x00066800000e0000ULL, 0x001c1fff1b1b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x000fe4000001162dULL, 0x0000000c1c417812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x000000032dff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d3c7824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d4c7824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f267812ULL, 0x000fc400078ef61eULL, 0x000000041f307812ULL, 0x140fe400078ef61eULL,
0x000000051f327812ULL, 0x140fe400078ef61eULL, 0x000000061f3a7812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x0000a0002e1d7811ULL, 0x000fe400078e58ffULL, 0xfffffff8233e7812ULL, 0x100fe400078ee21eULL,
0x000000011f407812ULL, 0x142fe200078ef61eULL, 0x00000010201c7824ULL, 0x000fe200078e021dULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL, 0x0000001024207824ULL, 0x100fe200078e021dULL,
0x000000021f427812ULL, 0x148fe200078ef61eULL, 0x0000001030247824ULL, 0x100fe200078e021dULL,
0x000000031f447812ULL, 0x140fe200078ef61eULL, 0x000000103a307824ULL, 0x100fe200078e021dULL,
0x000000041f467812ULL, 0x140fe200078ef61eULL, 0x00000010403a7824ULL, 0x100fe200078e021dULL,
0x000000051f487812ULL, 0x140fe200078ef61eULL, 0x00000010423b7824ULL, 0x100fe200078e021dULL,
0x000000061f4a7812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x0000001026227824ULL, 0x100fe400078e021dULL, 0x0000001032267824ULL, 0x100fe400078e021dULL,
0x00000001411f7824ULL, 0x000fe400078e021cULL, 0x000000103c327824ULL, 0x100fe400078e021dULL,
0x000000103e1c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x00000010443c7824ULL, 0x000fc400078e021dULL, 0x00000010463d7824ULL, 0x100fe400078e021dULL,
0x00000010483e7824ULL, 0x100fe400078e021dULL, 0x000000104a3f7824ULL, 0x100fe400078e021dULL,
0x000000104c407824ULL, 0x000fe400078e021dULL, 0x00000001411d7824ULL, 0x040fe400078e021eULL,
0x0000000141217824ULL, 0x000fc400078e0220ULL, 0x0000000141237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000141257824ULL, 0x040fe400078e0224ULL,
0x0000000141277824ULL, 0x040fe200078e0226ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x0000000141317824ULL, 0x040fe400078e0230ULL, 0x0000000141337824ULL, 0x040fe200078e0232ULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x00000001411c7824ULL, 0x000fc400078e021cULL,
0x00000001413a7824ULL, 0x040fe200078e023aULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x00000001411e7824ULL, 0x040fe400078e023bULL, 0x00000001413c7824ULL, 0x040fe200078e023cULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000141087824ULL, 0x042fe400078e023dULL,
0x00000001413e7824ULL, 0x040fe200078e023eULL, 0x0000001431007388ULL, 0x0007e20000000800ULL,
0x0000000141207824ULL, 0x000fc400078e023fULL, 0x0000000141407824ULL, 0x000fe200078e0240ULL,
0x0000001633007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b3a007388ULL, 0x0007e80000000800ULL, 0x0000000d1e007388ULL, 0x0007e80000000800ULL,
0x0000000f3c007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x000000133e007388ULL, 0x0007e80000000800ULL, 0x0000001520007388ULL, 0x0007e80000000800ULL,
0x0000001740007388ULL, 0x0007e80000000800ULL, 0x0100000400008388ULL, 0x0007e80000000c00ULL,
0x0102001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000037ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080037ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100037ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000003002b2b7a10ULL, 0x000fe20007ffe0ffULL, 0x0000180037ff7f8cULL, 0x0003e6000c80043fULL,
0x000000292b00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffbdc000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff317807ULL, 0x008fe40004800000ULL, 0x0001a77000307802ULL, 0x000fe40000000f00ULL,
0x000011a000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff057224ULL, 0x000fe200078e003cULL,
0xfffe707000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x000fe40004800000ULL,
0x0001a7c000307802ULL, 0x000fe40000000f00ULL, 0x0000115000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e003cULL, 0xfffe70a000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001a820005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000010b000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e005eULL, 0xfffe70e000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001a880005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000105000007944ULL, 0x034fea0003c00000ULL,
0xfffe70c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x000fe200078e0004ULL,
0x0001a8e0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000ff000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff697224ULL, 0x004fe200078e005eULL, 0xfffe744000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001a950005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000f8000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e005eULL,
0xfffe740000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001a9b0005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000f2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff677224ULL, 0x004fe200078e005eULL,
0xfffe936000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001aa20005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000eb000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff687224ULL, 0x004fe200078e005eULL, 0xfffe931000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x008fe40004800000ULL, 0x0001aa7000307802ULL, 0x000fe40000000f00ULL,
0x00000ea000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e003cULL,
0xfffeb20000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x000fe40004800000ULL,
0x0001aac000307802ULL, 0x000fe40000000f00ULL, 0x00000e5000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e003cULL, 0xfffeb23000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x002fe200078e00ffULL, 0x0001ab20005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000db000007944ULL, 0x034fea0003c00000ULL,
0xfffeb29000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001ab80005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000d5000007944ULL, 0x030fea0003c00000ULL,
0xfffeb35000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001abd0005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000d0000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff677224ULL, 0x004fe200078e005eULL,
0xfffeb5b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001ac40005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000c9000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff5a7224ULL, 0x004fe200078e005eULL, 0xfffeb56000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001aca0005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000c3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff677224ULL, 0x004fe200078e005eULL, 0xfffed24000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001ad10005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000bc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff687224ULL, 0x004fe200078e005eULL,
0xfffed1f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x008fe40004800000ULL,
0x0001ad6000307802ULL, 0x000fe40000000f00ULL, 0x00000bb000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff307224ULL, 0x000fe200078e003cULL, 0xfffef06000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x000fe40004800000ULL, 0x0001adb000307802ULL, 0x000fe40000000f00ULL,
0x00000b6000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff307224ULL, 0x000fe200078e003cULL,
0xfffef09000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x002fe200078e00ffULL,
0x0001ae10005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000ac000007944ULL, 0x034fea0003c00000ULL, 0xfffef0f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001ae70005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x00000a6000007944ULL, 0x030fea0003c00000ULL, 0xfffef1b000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001aec0005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x00000a1000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff677224ULL, 0x004fe200078e005eULL, 0xfffef41000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001af30005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x000009a000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff5a7224ULL, 0x004fe200078e005eULL,
0xfffef3c000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001af90005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000094000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff677224ULL, 0x004fe200078e005eULL,
0xffff10a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001b000005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000008d000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff687224ULL, 0x004fe200078e005eULL, 0xffff105000007947ULL, 0x000fea000383ffffULL,
0x00000001ff317807ULL, 0x008fe40004800000ULL, 0x0001b05000307802ULL, 0x000fe40000000f00ULL,
0x000008c000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e003cULL,
0xffff2ec000007947ULL, 0x000fea000383ffffULL, 0x00000001ff317807ULL, 0x000fe40004800000ULL,
0x0001b0a000307802ULL, 0x000fe40000000f00ULL, 0x0000087000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e003cULL, 0xffff2ef000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x004fe200078e00ffULL, 0x0001b100005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000007d000007944ULL, 0x032fea0003c00000ULL,
0xffff2f5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001b160005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x0000077000007944ULL, 0x030fea0003c00000ULL,
0xffff301000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001b1b0005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x0000072000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e005eULL,
0xffff327000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6c7224ULL, 0x002fe200078e002fULL,
0x0001b220005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fe400078e00ffULL, 0x000006b000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e005eULL, 0xffff322000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001b280005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000065000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e005eULL, 0xffff4f3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6c7224ULL, 0x002fe200078e002fULL, 0x0001b2f0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fe400078e00ffULL,
0x000005e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e005eULL,
0xffff4ee000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e003bULL,
0x0001b35000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3c7424ULL, 0x000fe400078e00ffULL,
0x0000054000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0025ULL,
0xffffe52000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e003dULL,
0x0001b3b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3c7424ULL, 0x002fe400078e00ffULL,
0x000004e000007944ULL, 0x020fea0003c00000ULL, 0x000000253d3e7209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0006ULL, 0x0001b40000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3c7424ULL, 0x002fe400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000002506067209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0007ULL,
0x0001b45000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3c7424ULL, 0x002fc400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000002507247209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e003bULL, 0x0001b4a000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3c7424ULL, 0x002fc400078e00ffULL, 0x000003f000007944ULL, 0x000fea0003c00000ULL,
0x000000253b047209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e003eULL,
0x0001b4f000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3c7424ULL, 0x002fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x000000253e057209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0006ULL, 0x0001b54000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3c7424ULL, 0x002fc400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0x0000002506067209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0024ULL,
0x0001b59000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3c7424ULL, 0x002fc400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0xffffe3e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5f7224ULL, 0x000fe200078e0040ULL, 0x0001b5f0005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff6c7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff6b7424ULL, 0x000fe400078e00ffULL,
0x000002e000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e005eULL,
0xffffe9d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5f7224ULL, 0x002fe200078e0042ULL,
0x0001b660005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff6c7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff6b7424ULL, 0x000fe400078e00ffULL, 0x0000027000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x002fe200078e00ffULL, 0x0001b6b0005c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff6b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff197224ULL, 0x004fe400078e005eULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x002fe200078e00ffULL,
0x0001b700005c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff6b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e005eULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e005eULL, 0xffffe94000007947ULL, 0x000fea000383ffffULL,
0x0180000033037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003300038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff187807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000318ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff33ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000033057812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000318ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003300037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe477004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000004000007348ULL, 0x000fe80003800000ULL, 0x0c00003c25257389ULL, 0x0002a200000e003fULL,
0xfffe473008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff5d7424ULL, 0x000fe200078e00ffULL,
0x0000006a00007348ULL, 0x000fe80003800000ULL, 0x0000006c5f5e7389ULL, 0x0002a200000e006bULL,
0xfffe46f05c007950ULL, 0x000fea0003c3ffffULL, 0x000000013100780cULL, 0x000fe20003f25070ULL,
0x0000006400007348ULL, 0x000fd80003800000ULL, 0x0000000000317806ULL, 0x000fc800048e0100ULL,
0x00000064313c7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff317424ULL, 0x000fc800078e00ffULL,
0xfffe469030007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000330ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000910ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009a0ULL, 0x0000000000000b8cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000152cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001550ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001560ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001610ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001618ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001628ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x000000000001ba00ULL, 0xa800001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001d200ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001d210ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001d210ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001d690ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001610ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001bbf0ULL, 0x000000000001bbf0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001d200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001d690ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 120688;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
