/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001db10ULL, 0x000000000001d690ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001bab0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001bc20ULL, 0x0000000000000050ULL, 0x000e002200000131ULL,
0x000000000001bc70ULL, 0x0000000000000050ULL, 0x000e00220000015bULL, 0x000000000001bcc0ULL,
0x0000000000000140ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001be00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001bab000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x006d440400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0x9608288080910828ULL, 0x2880809808288080ULL, 0x80a408288080a208ULL, 0x08288080a6082880ULL,
0x8080a808288080a7ULL, 0xaa08288080a90828ULL, 0x288080ab08288080ULL, 0x80ae08288080ac08ULL,
0x08288080b0082880ULL, 0x8082801628808084ULL, 0x0000000000031028ULL, 0x2880808492000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001bab000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8e08288080880828ULL, 0x2880809008288080ULL, 0x809d082880809608ULL, 0x082880809e082880ULL,
0x8080a0082880809fULL, 0xa408288080a20828ULL, 0x288080a608288080ULL, 0x80a808288080a708ULL,
0x08288080aa082880ULL, 0x8080ac08288080abULL, 0xb008288080ae0828ULL, 0x2880808908288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808089ULL, 0x0000002cffffffffULL,
0x0000013000000000ULL, 0x0001bc2000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x8088288080890900ULL, 0x0000000000002880ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8e08288080890828ULL, 0x2880809008288080ULL, 0x809d082880809608ULL, 0x082880809e082880ULL,
0x8080a0082880809fULL, 0xa408288080a20828ULL, 0x288080a608288080ULL, 0x80a808288080a708ULL,
0x08288080aa082880ULL, 0x8080ac08288080abULL, 0xb008288080ae0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080b0920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000021000000000ULL, 0x0001bc7000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80a8288080b00900ULL, 0x0000000000002880ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8e08288080890828ULL, 0x2880809008288080ULL, 0x809d082880809608ULL, 0x082880809e082880ULL,
0x8080a0082880809fULL, 0xa608288080a20828ULL, 0x288080a708288080ULL, 0x80aa08288080a808ULL,
0x08288080ab082880ULL, 0x8080ae08288080acULL, 0xa408288080b00828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080a4920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x000002f000000000ULL, 0x0001bcc000000000ULL, 0x0000014000000000ULL, 0x0000000000000000ULL,
0x0000001200082f04ULL, 0x00081204000000a7ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x00019fd000000020ULL, 0x0001a1b00001a1a0ULL,
0x0001a3000001a2f0ULL, 0x01c829040001a310ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001f0500001fULL,
0x0500001f0500001fULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000e001c82804ULL,
0x00001730000000f0ULL, 0x00001850000017b0ULL, 0x00001c6000001880ULL, 0x00001d0000001c90ULL,
0x00003c2000001d70ULL, 0x00003ca000003c40ULL, 0x00005c0000003d00ULL, 0x00005d3000005c80ULL,
0x0000611000005e50ULL, 0x0000619000006130ULL, 0x00007f00000061f0ULL, 0x00007f8000007f20ULL,
0x00009d8000007fe0ULL, 0x00009eb000009e00ULL, 0x0000a29000009fd0ULL, 0x0000a3100000a2b0ULL,
0x0000c0500000a370ULL, 0x0000c0d00000c070ULL, 0x0000dfb00000c130ULL, 0x0000e0e00000e030ULL,
0x0000e4c00000e200ULL, 0x0000e5400000e4e0ULL, 0x000102c00000e5a0ULL, 0x00010340000102e0ULL,
0x00011e50000103a0ULL, 0x000125e000011e60ULL, 0x000142e000014130ULL, 0x00014910000148d0ULL,
0x00019b9000015130ULL, 0x00019bd000019bc0ULL, 0x00019c1000019be0ULL, 0x00019c4000019c30ULL,
0x0001a2e000019c50ULL, 0x0001a3500001a340ULL, 0x0001aa700001a360ULL, 0x0001ab100001aab0ULL,
0x0001abf00001ab80ULL, 0x0001acc00001ac60ULL, 0x0001ad800001ad30ULL, 0x0001ae300001adc0ULL,
0x0001aef00001aea0ULL, 0x0001afc00001af60ULL, 0x0001b0800001b030ULL, 0x0001b1300001b0c0ULL,
0x0001b1f00001b1a0ULL, 0x0001b2c00001b260ULL, 0x0001b3800001b330ULL, 0x0001b4300001b3c0ULL,
0x0001b4f00001b4a0ULL, 0x0001b5c00001b560ULL, 0x0001b6900001b630ULL, 0x0001b7300001b6e0ULL,
0x0001b7d00001b780ULL, 0x0001b8700001b820ULL, 0x0001b9400001b8c0ULL, 0x0001ba200001b9c0ULL,
0x070039040001ba80ULL, 0x000000ff00000210ULL, 0x003f010000010600ULL, 0x0000000000000250ULL,
0x003f012000010608ULL, 0x00000000000002c0ULL, 0x003f012000010688ULL, 0x0000000000000390ULL,
0x003f0120000106a8ULL, 0x000000ff000003c0ULL, 0x003f0100000106b8ULL, 0x000000ff000004e0ULL,
0x003f010700010600ULL, 0x0000003d00000690ULL, 0x003f01020001068cULL, 0x0000003d00000740ULL,
0x003f010100010688ULL, 0x000000ff00000c70ULL, 0x003f0107000106a8ULL, 0x000000ff00000cf0ULL,
0x003f0101000106a8ULL, 0x000000ff00000d50ULL, 0x003f0101000106b8ULL, 0x000000ff00000eb0ULL,
0x003f0105000106bcULL, 0x000000ff00000f10ULL, 0x003f0105000106bcULL, 0x000000ff00000f90ULL,
0x003f0105000106bcULL, 0x000000ff000014a0ULL, 0x003f0107000106b0ULL, 0x000000ff00001520ULL,
0x003f0101000106b0ULL, 0x000000ff00001530ULL, 0x003f0105000106acULL, 0x0000003d000015a0ULL,
0x003f010100010608ULL, 0x0000003d000015c0ULL, 0x003f01050001060cULL, 0x0000003d00001650ULL,
0x003f01050001060cULL, 0x000000ff00001b40ULL, 0x003f0105000106acULL, 0x000000ff00001bc0ULL,
0x003f0105000106acULL, 0x000000ff00003570ULL, 0x003f0101000106b8ULL, 0x000000ff00003580ULL,
0x003f0105000106bcULL, 0x000000ff000035d0ULL, 0x003f0105000106bcULL, 0x000000ff00003650ULL,
0x003f0105000106bcULL, 0x000000ff00003a10ULL, 0x003f0107000106a8ULL, 0x000000ff00003a90ULL,
0x003f0101000106a8ULL, 0x000000ff00003aa0ULL, 0x003f0105000106b4ULL, 0x000000ff00003b00ULL,
0x003f0105000106b4ULL, 0x000000ff00003b80ULL, 0x003f0105000106b4ULL, 0x000000ff00005410ULL,
0x003f0101000106b8ULL, 0x000000ff00005480ULL, 0x003f010100010688ULL, 0x000000ff000054b0ULL,
0x003f0105000106bcULL, 0x000000ff00005500ULL, 0x003f0105000106bcULL, 0x000000ff00005580ULL,
0x003f0105000106bcULL, 0x000000ff000059c0ULL, 0x003f0107000106b0ULL, 0x000000ff00005a40ULL,
0x003f0101000106b0ULL, 0x000000ff00005a50ULL, 0x003f0105000106acULL, 0x0000003d00005ac0ULL,
0x003f010100010628ULL, 0x0000003d00005ae0ULL, 0x003f01050001062cULL, 0x0000003d00005b70ULL,
0x003f01050001062cULL, 0x000000ff00006000ULL, 0x003f0105000106acULL, 0x000000ff00006080ULL,
0x003f0105000106acULL, 0x000000ff00007880ULL, 0x003f0101000106b8ULL, 0x000000ff00007890ULL,
0x003f0105000106bcULL, 0x000000ff000078e0ULL, 0x003f0105000106bcULL, 0x000000ff00007960ULL,
0x003f0105000106bcULL, 0x000000ff00007cf0ULL, 0x003f0107000106a8ULL, 0x000000ff00007d70ULL,
0x003f0101000106a8ULL, 0x000000ff00007d80ULL, 0x003f0105000106b4ULL, 0x000000ff00007df0ULL,
0x003f0105000106b4ULL, 0x000000ff00007e70ULL, 0x003f0105000106b4ULL, 0x000000ff00009660ULL,
0x003f0101000106b8ULL, 0x000000ff000096d0ULL, 0x003f010100010690ULL, 0x000000ff00009700ULL,
0x003f0105000106bcULL, 0x000000ff00009750ULL, 0x003f0105000106bcULL, 0x000000ff000097d0ULL,
0x003f0105000106bcULL, 0x000000ff00009b40ULL, 0x003f0107000106b0ULL, 0x000000ff00009bc0ULL,
0x003f0101000106b0ULL, 0x000000ff00009bd0ULL, 0x003f0105000106acULL, 0x0000003d00009c40ULL,
0x003f010100010648ULL, 0x0000003d00009c60ULL, 0x003f01050001064cULL, 0x0000003d00009cf0ULL,
0x003f01050001064cULL, 0x000000ff0000a180ULL, 0x003f0105000106acULL, 0x000000ff0000a200ULL,
0x003f0105000106acULL, 0x000000ff0000ba00ULL, 0x003f0101000106b8ULL, 0x000000ff0000ba10ULL,
0x003f0105000106bcULL, 0x000000ff0000ba60ULL, 0x003f0105000106bcULL, 0x000000ff0000bae0ULL,
0x003f0105000106bcULL, 0x000000ff0000be50ULL, 0x003f0107000106a8ULL, 0x000000ff0000bed0ULL,
0x003f0101000106a8ULL, 0x000000ff0000bee0ULL, 0x003f0105000106b4ULL, 0x000000ff0000bf40ULL,
0x003f0105000106b4ULL, 0x000000ff0000bfc0ULL, 0x003f0105000106b4ULL, 0x000000ff0000d7b0ULL,
0x003f0101000106b8ULL, 0x000000ff0000d820ULL, 0x003f010100010698ULL, 0x000000ff0000d850ULL,
0x003f0105000106bcULL, 0x000000ff0000d8a0ULL, 0x003f0105000106bcULL, 0x000000ff0000d920ULL,
0x003f0105000106bcULL, 0x000000ff0000dd70ULL, 0x003f0107000106b0ULL, 0x000000ff0000ddf0ULL,
0x003f0101000106b0ULL, 0x000000ff0000de00ULL, 0x003f0105000106acULL, 0x0000003d0000de70ULL,
0x003f010100010668ULL, 0x0000003d0000de90ULL, 0x003f01050001066cULL, 0x0000003d0000df20ULL,
0x003f01050001066cULL, 0x000000ff0000e3b0ULL, 0x003f0105000106acULL, 0x000000ff0000e430ULL,
0x003f0105000106acULL, 0x000000ff0000fc30ULL, 0x003f0101000106b8ULL, 0x000000ff0000fc40ULL,
0x003f0105000106bcULL, 0x000000ff0000fc90ULL, 0x003f0105000106bcULL, 0x000000ff0000fd10ULL,
0x003f0105000106bcULL, 0x000000ff000100c0ULL, 0x003f0107000106a8ULL, 0x000000ff00010140ULL,
0x003f0101000106a8ULL, 0x000000ff00010150ULL, 0x003f0105000106b4ULL, 0x000000ff000101b0ULL,
0x003f0105000106b4ULL, 0x000000ff00010230ULL, 0x003f0105000106b4ULL, 0x000000ff00011a20ULL,
0x003f0101000106b8ULL, 0x000000ff00011a80ULL, 0x003f0101000106a0ULL, 0x000000ff00015500ULL,
0x003f010100010600ULL, 0x000000ff00016290ULL, 0x003f010500010604ULL, 0x000000ff00016330ULL,
0x003f010500010604ULL, 0x000000ff00016650ULL, 0x003f010100010600ULL, 0x000000ff00016660ULL,
0x003f010500010604ULL, 0x000000ff000166f0ULL, 0x003f010500010604ULL, 0x0000003400019070ULL,
0x003f010100000000ULL, 0x00000034000190b0ULL, 0x003f010500000004ULL, 0x0000003400019490ULL,
0x003f010500000004ULL, 0x000000360001a8d0ULL, 0x003f010100000000ULL, 0x000000360001a930ULL,
0x003f010100000008ULL, 0x000000360001a990ULL, 0x003f010100000010ULL, 0x000000360001aa00ULL,
0x003f010100000018ULL, 0x00101c0400053803ULL, 0x0001675000015380ULL, 0x0001aa4000016800ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000003acULL, 0x0000001200000002ULL,
0x00000000000002ccULL, 0x0000001200000002ULL, 0x00000000000001ecULL, 0x0000001200000002ULL,
0x000000000000011cULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x0000000000000382ULL, 0x0000001200000002ULL, 0x00000000000002a2ULL, 0x0000001200000002ULL,
0x00000000000001c7ULL, 0x0000001200000002ULL, 0x00000000000000f3ULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x00005800ff2f7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000007919ULL, 0x000ea20000002300ULL,
0x0000000e00057300ULL, 0x000ee600000e0000ULL, 0x0000000000027919ULL, 0x000f280000002200ULL,
0x00000000003b7919ULL, 0x000f620000002600ULL, 0x0000000e00107309ULL, 0x0002a60000000000ULL,
0x0000000000337919ULL, 0x000ee80000002700ULL, 0x0000000000067919ULL, 0x000ee20000000000ULL,
0x00000005ff3a7819ULL, 0x002fc60000011603ULL, 0x00000000003c7919ULL, 0x000e680000000000ULL,
0x00001fff000a7589ULL, 0x0049e800000e0000ULL, 0x00001fff3a3a7589ULL, 0x000ea200000e0000ULL,
0x0000000100007824ULL, 0x010fe400078e0202ULL, 0x000000083b027824ULL, 0x020fc400078e00ffULL,
0x0000008000007824ULL, 0x000fe400078e0203ULL, 0x000000082f037824ULL, 0x000fe200078e00ffULL,
0x000000060500720cULL, 0x008fe40003f02070ULL, 0x000000ff0000720cULL, 0x040fe20003f25270ULL,
0x0000003303087224ULL, 0x000fe200078e0202ULL, 0x0000000f0000780cULL, 0x040fe40003f44070ULL,
0x0000007f0000780cULL, 0x040fe40003f84070ULL, 0x000000030000780cULL, 0x000fe20003f64070ULL,
0x000000040a047824ULL, 0x004fcc00078e023aULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x0000000204097824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x00000008090b7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL, 0x01060002ff009388ULL, 0x0005e20000000a00ULL,
0xff317217ff0cc424ULL, 0x000fe200078e00ffULL, 0x00000001090d7810ULL, 0x000fe20007ffe0ffULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x010608040000a388ULL, 0x0007e20000008a00ULL,
0x000000010000780cULL, 0x000fe20003f44070ULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x000000070d0e7812ULL, 0x000fe200078ec0ffULL, 0x0104000c0000c388ULL, 0x0009e20000004800ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a09ULL, 0x0000000709027812ULL, 0x004fc400078ec0ffULL,
0x010688060000b388ULL, 0x0005e20000008a00ULL, 0x0000001f0e0e7812ULL, 0x102fe400078e783cULL,
0x0000001f02037812ULL, 0x000fe200078e783cULL, 0x0000000108027824ULL, 0x040fe200078e0209ULL,
0x000000ff0b00720cULL, 0x040fe20003f63070ULL, 0x0000000108047824ULL, 0x008fe200078e020dULL,
0x000000010b00780cULL, 0x000fe20003f83070ULL, 0x00000020090c7824ULL, 0x010fe400078e0203ULL,
0x3fffff80ff089424ULL, 0x000fc400078e00ffULL, 0x3fffff00ff06a424ULL, 0x004fe400078e00ffULL,
0x7fffff00ff07a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff099424ULL, 0x000fe400078e00ffULL,
0x00000200ff057424ULL, 0x000fe200078e00ffULL, 0x0106a8060000a388ULL, 0x0003e20000008a00ULL,
0x000000103c0b7824ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x080fe200078e0005ULL,
0x0106b808ff009388ULL, 0x0005e40000000a00ULL, 0x000001f00b0f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0004047625ULL, 0x000fe200078e0005ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000f02027210ULL, 0x080fe20007fbe0ffULL, 0x000000200d0e7824ULL, 0x000fe200078e020eULL,
0x0000000f04047210ULL, 0x000fe20007f5e0ffULL, 0x000000100c0c7824ULL, 0x000fc400078e00ffULL,
0x000000ffff037224ULL, 0x000fe400028e0603ULL, 0x000000ffff057224ULL, 0x000fe400010e0605ULL,
0x000000100e0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x002fe400078e0a10ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020c7faeULL, 0x0003e8000d901c46ULL, 0x00000000040e7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x01060400ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000620033027625ULL, 0x000fc600078e0006ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000602397981ULL, 0x004ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x00000004ff387e24ULL, 0x002fe2000f8e00ffULL, 0x0000007f39037810ULL, 0x044fe40007ffe0ffULL,
0x000000ff39027810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff037819ULL, 0x000fe40000011603ULL,
0x00000008ff027819ULL, 0x000fca0000011602ULL, 0x00014d9000008947ULL, 0x000fea0003800000ULL,
0x0000000238447824ULL, 0x000fe400078e00ffULL, 0x000000083a3d7824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x000000034400720cULL, 0x000fe20003f06070ULL,
0xffffffffff657424ULL, 0x000fd800078e00ffULL, 0x0000640044048a10ULL, 0x000fe20007ffe0ffULL,
0x0000000233008824ULL, 0x000fc800078e00ffULL, 0x0000640000048a24ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c053dff738cULL, 0x0003e40000000000ULL,
0x0000600004048625ULL, 0x002fe400078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604658981ULL, 0x0002a2000c1e1900ULL, 0x0000000138007810ULL, 0x000fe20007ffe0ffULL,
0xff317217ff3e7424ULL, 0x000fe200078e00ffULL, 0x000000f00b0b7812ULL, 0x000fe200078ec0ffULL,
0x010688003dff7f8cULL, 0x0007e2000c80043fULL, 0x000000020000720cULL, 0x000fe20003f06070ULL,
0x000000ffff3f7224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000004ff057819ULL, 0x002fe2000001163cULL, 0x0000010038047824ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000205087810ULL, 0x040fe20007ffe0ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000004050a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000439007217ULL, 0x000fe20007800000ULL, 0x000000013d067824ULL, 0x000fe200078e0208ULL,
0x00000006050d7810ULL, 0x000fe20007ffe0ffULL, 0x000000013d0c7824ULL, 0x000fc400078e020aULL,
0x0000000100007824ULL, 0x000fe200078e0a04ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x000000013d0e7824ULL, 0x000fe200078e020dULL, 0x000000070c047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000f07077812ULL, 0x100fe400078e783cULL,
0x0000000f04047812ULL, 0x000fe400078e783cULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x0000001006097824ULL, 0x000fe200078e0207ULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x000000013d067824ULL, 0x000fc400078e0205ULL, 0x000000100c0c7824ULL, 0x000fe200078e0204ULL,
0x000000003d047217ULL, 0x000fe40007800000ULL, 0x0000000706077812ULL, 0x000fe400078ec0ffULL,
0x0000000f0f0f7812ULL, 0x100fe200078e783cULL, 0x0000000104047824ULL, 0x000fe200078e0a3dULL,
0x0000000f07077812ULL, 0x000fe400078e783cULL, 0x0000c0000c0c7811ULL, 0x000fe200078e20ffULL,
0x000000100e0f7824ULL, 0x000fe200078e020fULL, 0x000000040500720cULL, 0x080fe20003f26070ULL,
0x0000001006077824ULL, 0x000fe200078e0207ULL, 0x000000040a00720cULL, 0x080fe20003f06070ULL,
0x000000803b067824ULL, 0x000fe200078e0206ULL, 0x000000040800720cULL, 0x000fc40003f46070ULL,
0x0000c0000f0f7811ULL, 0x000fe400078e20ffULL, 0x0000000206057810ULL, 0x040fe40007ffe0ffULL,
0x0000000406087810ULL, 0x000fe20007ffe0ffULL, 0x0000580065007a24ULL, 0x004fc800078e02ffULL,
0x0000008000007824ULL, 0x000fca00078e00ffULL, 0x0000000600137210ULL, 0x040fe40007f7e0ffULL,
0x0000000500057210ULL, 0x000fe40007f9e0ffULL, 0x0000000606067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078640ffULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x00005e0005107a11ULL, 0x000fe400078840ffULL,
0x00005f0013137a11ULL, 0x000fc400018f440aULL, 0x00000008000e7210ULL, 0x040fe40007f7e0ffULL,
0x0000000600067210ULL, 0x000fe40007fbe0ffULL, 0x00005f0005117a11ULL, 0x000fe200020f4411ULL,
0x000000ffff057224ULL, 0x000fe200018e06ffULL, 0x00005e000e087a11ULL, 0x000fe200078840ffULL,
0x000000ffff007224ULL, 0x000fe200028e06ffULL, 0x00005e00060a7a11ULL, 0x000fe400078a40ffULL,
0x000000040d00720cULL, 0x000fc40003f66070ULL, 0x00005f000e0e7a11ULL, 0x000fe400020f4405ULL,
0x00005f00060d7a11ULL, 0x000fe400028f4400ULL, 0x000000120b047210ULL, 0x000fe40007f9e0ffULL,
0x0000000b10067210ULL, 0x080fe40007fbe0ffULL, 0x0000c00007007811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200020e0613ULL, 0x0000000b08087210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff077224ULL, 0x000fe200028e0611ULL, 0x0000000b0a0a7210ULL, 0x000fc40007fbe0ffULL,
0x0000c000090b7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004007faeULL, 0x0003e2000c901c46ULL, 0x000000ffff097224ULL, 0x000fc600020e060eULL,
0x00000000060b7faeULL, 0x0005e8000d101c46ULL, 0x00000000080c7faeULL, 0x0007e2000c101c46ULL,
0x000000023800720cULL, 0x000fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x004fca00028e060dULL,
0x000000000a0f7faeULL, 0x0007e8000d901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff667f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff247f8cULL, 0x000ea2000c80043fULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x008fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00010cd000000947ULL, 0x000fea0003800000ULL,
0x000000043a407824ULL, 0x000fe400078e00ffULL, 0x0000000233337824ULL, 0x000fc400078e00ffULL,
0x00006400ff417624ULL, 0x000fe200078e00ffULL, 0x0000000240427810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff667224ULL, 0x002fe400078e0067ULL, 0x0000640033417624ULL, 0x000fe400078e0241ULL,
0xff317217ff3e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe400078e00ffULL,
0x0000010038007824ULL, 0x000fca00078e00ffULL, 0x000000390000720cULL, 0x000fda0003f06070ULL,
0x00010be000000947ULL, 0x006fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x006fe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff497224ULL, 0x000fe200078e0044ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff277819ULL, 0x000fe2000001163cULL, 0x0000580065357a24ULL, 0x000fe200078e02ffULL,
0x000000203b257811ULL, 0x000fe200078e38ffULL, 0x000000103c5b7824ULL, 0x000fe200078e00ffULL,
0x0000000138007810ULL, 0x040fe20007ffe0ffULL, 0x000000013d537824ULL, 0x000fe200078e0227ULL,
0x0000002038247811ULL, 0x000fe200078e40ffULL, 0x0000008035357824ULL, 0x000fe200078e00ffULL,
0x000000020000720cULL, 0x000fe20003f06070ULL, 0x0000000153267824ULL, 0x040fe200078e0225ULL,
0x0000000753287812ULL, 0x000fc400078ec0ffULL, 0x0000002439007217ULL, 0x000fe40007800000ULL,
0x0000000227347810ULL, 0x000fe40007ffe0ffULL, 0x0000000f28287812ULL, 0x000fe200078e783cULL,
0x0000000100007824ULL, 0x000fe200078e0a24ULL, 0x0000002635267210ULL, 0x000fe20007f3e0ffULL,
0x000000013d247824ULL, 0x000fe200078e0234ULL, 0x00000004272e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001053537824ULL, 0x000fe200078e0228ULL, 0x00000006272f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e06ffULL, 0x00005e0026287a11ULL, 0x000fe200078240ffULL,
0x000000013d2a7824ULL, 0x040fe200078e022eULL, 0x0000000724297812ULL, 0x000fe200078ec0ffULL,
0x000000013d507824ULL, 0x000fe200078e022fULL, 0x00005f00262d7a11ULL, 0x000fc400008f442dULL,
0x000000072a267812ULL, 0x000fe400078ec0ffULL, 0x0000000f29297812ULL, 0x100fe400078e783cULL,
0x0000000f26267812ULL, 0x000fe400078e783cULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x0000001024527824ULL, 0x000fe200078e0229ULL, 0x0000000750297812ULL, 0x000fe200078ec0ffULL,
0x0000000124247824ULL, 0x100fe200078e0225ULL, 0x000000003d007217ULL, 0x000fe20007800000ULL,
0x000000102a517824ULL, 0x040fe200078e0226ULL, 0x0000000f29297812ULL, 0x000fe200078e783cULL,
0x000000012a267824ULL, 0x000fe200078e0225ULL, 0x0000002435247210ULL, 0x000fe20007f3e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a3dULL, 0x000000f05b457812ULL, 0x000fe200078ec0ffULL,
0x0000000150257824ULL, 0x000fe200078e0225ULL, 0x00000026352a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200008e06ffULL, 0x00005e00242b7a11ULL, 0x000fe200078440ffULL,
0x0000001050507824ULL, 0x000fe200078e0229ULL, 0x000000002700720cULL, 0x000fe20003f26070ULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x00005e002a297a11ULL, 0x000fc400078a40ffULL,
0x0000002535267210ULL, 0x000fe40007fde0ffULL, 0x00005f00242c7a11ULL, 0x000fe400010f442cULL,
0x0000004528247210ULL, 0x000fe40007f9e0ffULL, 0x00005f002a2a7a11ULL, 0x000fe200028f4427ULL,
0x000000ffff277224ULL, 0x000fe200030e06ffULL, 0x00005e0026287a11ULL, 0x000fe200078a40ffULL,
0x000000ffff257224ULL, 0x000fe200020e062dULL, 0x000000002e00720cULL, 0x000fc40003f46070ULL,
0x000000002f00720cULL, 0x080fe40003f66070ULL, 0x000000003400720cULL, 0x000fe40003f86070ULL,
0x0000e000535f7811ULL, 0x000fe400078e20ffULL, 0x00005f0026007a11ULL, 0x000fe400028f4427ULL,
0x000000452b267210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245f7faeULL, 0x0003e2000c901c46ULL, 0x0000e000525e7811ULL, 0x000fc400078e20ffULL,
0x0000e000515d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff277224ULL, 0x000fe200028e062cULL,
0x0000004528287210ULL, 0x080fe40007fbe0ffULL, 0x0000e000505c7811ULL, 0x000fe400078e20ffULL,
0x00000000265e7faeULL, 0x0005e2000e101c46ULL, 0x0000004529247210ULL, 0x002fe20007f3e0ffULL,
0x000000ffff297224ULL, 0x000fc800028e0600ULL, 0x000000ffff257224ULL, 0x000fca00008e062aULL,
0x00000000245d7faeULL, 0x0005e8000d101c46ULL, 0x00000000285c7faeULL, 0x0005e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff2c7f8cULL, 0x000e68000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010608003d247f8cULL, 0x004fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc60007844866ULL,
0x01060c003d267984ULL, 0x000ea40000000800ULL, 0x8000000026ff7812ULL, 0x004fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x01060c003d267984ULL, 0x000ea40000000800ULL,
0x8000000026ff7812ULL, 0x004fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff007819ULL, 0x000fe2000001163cULL, 0xffffffffff5a7424ULL, 0x000fe200078e00ffULL,
0x000000705b5b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c00007812ULL, 0x000fca00078ec0ffULL,
0x000000015b5b7824ULL, 0x000fca00078e0200ULL, 0x010000005b267984ULL, 0x000ea80000000800ULL,
0x010200005b277984ULL, 0x0007220000000800ULL, 0x0000003e2600720bULL, 0x004fe20003f3d000ULL,
0x000193227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff00287812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff3a00720cULL, 0x000fe40003f65270ULL, 0x0000003e2600720bULL, 0x000fe20003f34000ULL,
0x000192e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x000000263e2e7209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fc600078e3cffULL,
0x0104002e5b00b388ULL, 0x0005e20000000800ULL, 0x8000002e3e247221ULL, 0x000fe20000010000ULL,
0x0000000028ff7212ULL, 0x000fc6000782c0ffULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024002a7308ULL, 0x0007240000000800ULL, 0x00000002ff247819ULL, 0x008fe2000001163cULL,
0x000192827f007947ULL, 0x000fea000b800000ULL, 0x00001f242a257589ULL, 0x0144e400000e0000ULL,
0x0000000824247810ULL, 0x004fe20007ffe0ffULL, 0x000192c27f007947ULL, 0x000fea000b800000ULL,
0x00001f242a247589ULL, 0x00052400000e0000ULL, 0x8000002e26261221ULL, 0x100fe20000010000ULL,
0x0000002423237220ULL, 0x090fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x0000002600431308ULL, 0x000f220000000800ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x000fe20000410000ULL,
0x0000002a3f3f7220ULL, 0x000fe20000410000ULL, 0x00000001ff247807ULL, 0x000fe20000800000ULL,
0x0000002521217220ULL, 0x088fe20000410000ULL, 0x0000002520207220ULL, 0x080fe20000410000ULL,
0x000000251d1d7220ULL, 0x080fe20000410000ULL, 0x000000251c1c7220ULL, 0x080fe20000410000ULL,
0x0000002519197220ULL, 0x080fe20000410000ULL, 0x0000002518187220ULL, 0x080fe20000410000ULL,
0x0000002515157220ULL, 0x080fe20000410000ULL, 0x0000002514147220ULL, 0x080fe20000410000ULL,
0x0000002505057220ULL, 0x080fe20000410000ULL, 0x0000002504047220ULL, 0x080fe20000410000ULL,
0x0000002511117220ULL, 0x080fe20000410000ULL, 0x0000002510107220ULL, 0x080fe20000410000ULL,
0x000000250d0d7220ULL, 0x080fe20000410000ULL, 0x000000250c0c7220ULL, 0x080fe20000410000ULL,
0x0000002509097220ULL, 0x080fe20000410000ULL, 0x0000002508087220ULL, 0x000fe20000410000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e002eULL, 0x0000004327271220ULL, 0x010fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003f273f7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc40007824866ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000250000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe40007824866ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000043ff00723eULL, 0x000fe400000010ffULL,
0x00000004ff557819ULL, 0x000fc4000001163cULL, 0x00000002ff487819ULL, 0x000fe4000001163cULL,
0x00005410002a7816ULL, 0x004fe20000000000ULL, 0x00018f527f007947ULL, 0x000fea000b800000ULL,
0x00001f482a607589ULL, 0x0004e400000e0000ULL, 0x0000000848467810ULL, 0x000fe20007ffe0ffULL,
0x00018f927f007947ULL, 0x000fea000b800000ULL, 0x00001f462a4b7589ULL, 0x0008a400000e0000ULL,
0x0000001048477810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0047ULL, 0x00001d1000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00019f6000007944ULL, 0x01efea0003c00000ULL, 0x0000001848487810ULL, 0x004fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0048ULL,
0x00001d8000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00019ef000007944ULL, 0x01afea0003c00000ULL,
0x000000083c007812ULL, 0x044fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000403c257211ULL, 0x000fe400078fe0ffULL, 0x0000000700267812ULL, 0x100fe400078ec83cULL,
0x000000423c277211ULL, 0x000fe400078fe0ffULL, 0x0000000700007812ULL, 0x000fe400078ef83cULL,
0x0000002526257212ULL, 0x000fc400078e3cffULL, 0x0000002726277212ULL, 0x000fe400078e3cffULL,
0x0000991024247816ULL, 0x000fe200000000ffULL, 0x0000001000377824ULL, 0x040fe400078e0225ULL,
0x0000001000367824ULL, 0x040fe200078e0227ULL, 0x0000010000007811ULL, 0x000fe400078e20ffULL,
0x0000c00037597811ULL, 0x000fe400078e20ffULL, 0x0000c00036587811ULL, 0x000fe200078e20ffULL,
0x00000001252f7824ULL, 0x000fc400078e0200ULL, 0x00000001272e7824ULL, 0x000fe200078e0200ULL,
0x00000000594c783bULL, 0x000ea20000004200ULL, 0x000000ffff007224ULL, 0x000fe200078e0024ULL,
0x0000c0002f577811ULL, 0x000fe400078e20ffULL, 0x0000c0002e567811ULL, 0x000fe200078e20ffULL,
0x000000005830783bULL, 0x000f620000004200ULL, 0x000000ff0000720cULL, 0x000fc60003f25270ULL,
0x000000005728783bULL, 0x010f280000004200ULL, 0x000000005624783bULL, 0x000ee20000004200ULL,
0x000000ff4c547812ULL, 0x044fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x000fe4000001164cULL,
0x0000ffff4c967812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f677812ULL, 0x000fc400078ec0ffULL,
0x000000ff316c7812ULL, 0x020fe400078ec0ffULL, 0x00000010ff837819ULL, 0x110fe40000011628ULL,
0x000000ff28717812ULL, 0x040fe400078ec0ffULL, 0x00000018ff707819ULL, 0x000fe40000011628ULL,
0x0000ffff28817812ULL, 0x000fe400078ec0ffULL, 0x00000054ff28723eULL, 0x000fc400020006ffULL,
0x00000010ff7d7819ULL, 0x100fe4000001162aULL, 0x000000ff2a8b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe4000001162aULL, 0x0000ffff2a667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7e7819ULL, 0x000fe4000001162bULL, 0x000000ff2b8c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001162bULL, 0x0000ffff2b617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7a7819ULL, 0x108fe40000011624ULL, 0x000000ff248e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff2b7819ULL, 0x000fe40000011624ULL, 0x0000ffff24547812ULL, 0x000fe200078ec0ffULL,
0x20000028ff247230ULL, 0x000fe20000004100ULL, 0x000000ff4a4a7812ULL, 0x000fc400078ec0ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000008ff287819ULL, 0x000fe40000011696ULL,
0x00000018ff007819ULL, 0x000fe2000001164cULL, 0x20000067ff7c7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff697819ULL, 0x100fe4000001164dULL,
0x000000ff4d627812ULL, 0x000fe200078ec0ffULL, 0x2000006cff767230ULL, 0x000fe20000004100ULL,
0x00000018ff4c7819ULL, 0x000fc4000001164dULL, 0x0000ffff4d977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8a7819ULL, 0x000fe4000001164fULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000018ff4d7819ULL, 0x100fe2000001164eULL,
0x2000002bff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fc4000001164eULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000010ff827819ULL, 0x100fe40000011629ULL,
0x000000ff29737812ULL, 0x040fe400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe40000011629ULL,
0x0000ffff29807812ULL, 0x000fe400078ec0ffULL, 0x00000000ff29723eULL, 0x000fc400020006ffULL,
0x00000088ff67723eULL, 0x000fe200020006ffULL, 0x2000004aff887230ULL, 0x000fe20000004100ULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x000000ff4e647812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e987812ULL, 0x000fe200078ec0ffULL, 0x2000004dff787230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fc400020006ffULL, 0x000000ff892b7812ULL, 0x000fe200078ec0ffULL,
0x20000028ff897230ULL, 0x000fe20000004100ULL, 0x000000073c4a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001164fULL, 0x00000018ff6f7819ULL, 0x000fe40000011633ULL,
0x00000010ff687819ULL, 0x000fe40000011627ULL, 0x000000ff27957812ULL, 0x000fc400078ec0ffULL,
0x00000018ff947819ULL, 0x000fe40000011627ULL, 0x0000ffff27007812ULL, 0x000fe200078ec0ffULL,
0x20000029ff277230ULL, 0x000fe20000004100ULL, 0x0000008aff28723eULL, 0x000fe400020006ffULL,
0x000000ff69297812ULL, 0x000fe200078ec0ffULL, 0x2000002aff697230ULL, 0x000fe20000004100ULL,
0x000000084a4a7812ULL, 0x000fe400078ef83cULL, 0x0000004eff4e723eULL, 0x000fc400020006ffULL,
0x0000006fff4d723eULL, 0x000fe400020006ffULL, 0x0000008eff6f723eULL, 0x000fe200020006ffULL,
0x20000028ff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff2a7819ULL, 0x000fe20000011697ULL,
0x2000004eff797230ULL, 0x000fe20000004100ULL, 0x00000010ff8d7819ULL, 0x000fe20000011630ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fc400020006ffULL,
0x00000008ff287819ULL, 0x000fe40000011698ULL, 0x0000000755557812ULL, 0x000fe200078e784aULL,
0x20000029ff8a7230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x000000084a557824ULL, 0x000fe200078e0255ULL,
0x0000ffff4f997812ULL, 0x000fe200078ec0ffULL, 0x2000004cff7f7230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fc400020006ffULL, 0x00000073ff4e723eULL, 0x000fe400020006ffULL,
0x00000072ff73723eULL, 0x000fe200020006ffULL, 0x20000070ff727230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x2000008bff707230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x2000002aff8b7230ULL, 0x000fe20000004100ULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fe20000011631ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fc40000011699ULL, 0x00000010ff877819ULL, 0x100fe40000011632ULL,
0x000000ff326e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011632ULL,
0x0000ffff32857812ULL, 0x000fe400078ec0ffULL, 0x00000071ff4c723eULL, 0x000fe400020006ffULL,
0x000000ff33327812ULL, 0x000fc400078ec0ffULL, 0x0000008cff71723eULL, 0x000fe200020006ffULL,
0x2000002bff8c7230ULL, 0x000fe20000004100ULL, 0x0000008dff2a723eULL, 0x000fe200020006ffULL,
0x20000028ff8d7230ULL, 0x000fe20000004100ULL, 0x00000018ff907819ULL, 0x000fe20000011625ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000018ff927819ULL, 0x000fe20000011626ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x000000ff8f2b7812ULL, 0x000fc400078ec0ffULL, 0x0000a00055287811ULL, 0x000fe200078e20ffULL,
0x20000029ff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff306a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011630ULL, 0x0000ffff309a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fe40000011633ULL, 0x0000ffff33847812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7b7819ULL, 0x000fe40000011625ULL, 0x000000ff25917812ULL, 0x040fe400078ec0ffULL,
0x0000ffff25307812ULL, 0x000fe400078ec0ffULL, 0x00000032ff33723eULL, 0x000fe400020006ffULL,
0x00000062ff25723eULL, 0x000fe400020006ffULL, 0x0000006dff32723eULL, 0x000fe200020006ffULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x00000090ff6d723eULL, 0x000fe200020006ffULL,
0x2000002aff907230ULL, 0x000fe20000004100ULL, 0x00000092ff62723eULL, 0x000fe200020006ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x0000002bff92723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x00000010ff247819ULL, 0x000fe20000011624ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011625ULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe20000011688ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x0000105488247816ULL, 0x000fe40000000024ULL,
0x000010548a257816ULL, 0x000fe40000000025ULL, 0x00000018ff6b7819ULL, 0x000fe40000011631ULL,
0x0000ffff319b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff317819ULL, 0x000fe40000011626ULL,
0x000000ff26937812ULL, 0x000fc400078ec0ffULL, 0x0000ffff26637812ULL, 0x000fe400078ec0ffULL,
0x00000064ff26723eULL, 0x000fe400020006ffULL, 0x00000010ff277819ULL, 0x000fe40000011627ULL,
0x00000008ff547819ULL, 0x000fe20000011654ULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff8c7819ULL, 0x000fc4000001168cULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x000010548c267816ULL, 0x000fe40000000026ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x0000006028289231ULL, 0x084fe200003400ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x000000602a2a9231ULL, 0x000fe200003400ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x0000004b29299231ULL, 0x080fe200003400ffULL, 0x2000004fff747230ULL, 0x000fe20000004100ULL,
0x0000004b2b2b9231ULL, 0x000fe200003400ffULL, 0x2000006bff757230ULL, 0x000fe20000004100ULL,
0x00000093ff6b723eULL, 0x000fe200020006ffULL, 0x2000006eff4f7230ULL, 0x000fe20000004100ULL,
0x00000091ff6e723eULL, 0x000fc400020006ffULL, 0x00000008ff917819ULL, 0x000fe2000001169aULL,
0x000000242808723cULL, 0x000fe20000041808ULL, 0x00000008ff937819ULL, 0x000fe2000001169bULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000010ff247819ULL, 0x000fe40000011689ULL, 0x00000010ff257819ULL, 0x000fe2000001168bULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x0000105427247816ULL, 0x000fc40000000024ULL,
0x00000010ff277819ULL, 0x000fe4000001167cULL, 0x00000054ff7c723eULL, 0x000fe400020006ffULL,
0x0000000734547812ULL, 0x000fe400078e784aULL, 0x000010547f257816ULL, 0x000fe20000000025ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x000010548e277816ULL, 0x000fe20000000027ULL,
0x000000084a547824ULL, 0x000fe200078e0254ULL, 0x0000006aff6a723eULL, 0x000fc400020006ffULL,
0x00000094ff64723eULL, 0x000fe200020006ffULL, 0x00000024280c723cULL, 0x040fe2000004180cULL,
0x0000a00054347811ULL, 0x000fe200078e20ffULL, 0x2000006aff777230ULL, 0x000fe20000004100ULL,
0x000000ff87877812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x000000ff86947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff247819ULL, 0x000fe20000011678ULL,
0x000000262810723cULL, 0x000fe20000041810ULL, 0x00000010ff257819ULL, 0x000fc40000011679ULL,
0x00000010ff787819ULL, 0x000fe4000001168dULL, 0x00000010ff797819ULL, 0x000fe4000001168fULL,
0x0000105424787816ULL, 0x000fe40000000078ULL, 0x0000105425797816ULL, 0x000fe40000000079ULL,
0x000000003424783bULL, 0x0004e20000000200ULL, 0x00000008ff867819ULL, 0x000fe20000011685ULL,
0x20000091ff857230ULL, 0x000fe20000004100ULL, 0x00000008ff307819ULL, 0x000fc40000011630ULL,
0x000000ff31317812ULL, 0x000fe200078ec0ffULL, 0x000000782804723cULL, 0x000fe20000041804ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x000000ff83837812ULL, 0x000fe200078ec0ffULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x000000ff82827812ULL, 0x000fc400078ec0ffULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff917819ULL, 0x000fe40000011692ULL, 0x00000030ff30723eULL, 0x000fe400020006ffULL,
0x00000031ff34723eULL, 0x004fe400020006ffULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff757819ULL, 0x000fc40000011675ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff317819ULL, 0x000fe40000011693ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000010ff777819ULL, 0x000fe20000011677ULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe20000011690ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x0000006024249231ULL, 0x088fe200003400ffULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x0000006026269231ULL, 0x000fe200003400ffULL, 0x0000105491917816ULL, 0x000fe20000000076ULL,
0x20000030ff767230ULL, 0x000fe20000004100ULL, 0x0000105474307816ULL, 0x000fe20000000085ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x0000105475317816ULL, 0x000fe20000000031ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL,
0x0000004b25259231ULL, 0x080fe200003400ffULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x0000004b27279231ULL, 0x000fe200003400ffULL, 0x0000105490907816ULL, 0x000fe20000000077ULL,
0x20000034ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff4f7819ULL, 0x000fc4000001164fULL,
0x00000010ff337819ULL, 0x000fe40000011633ULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x000000902814723cULL, 0x000fe20000041814ULL, 0x00000010ff757819ULL, 0x000fe40000011694ULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000010ff347819ULL, 0x000fc40000011632ULL, 0x0000105487747816ULL, 0x000fe4000000004fULL,
0x0000105475757816ULL, 0x000fe40000000033ULL, 0x000000ff7a887812ULL, 0x000fe200078ec0ffULL,
0x000000302830723cULL, 0x000fe20000041818ULL, 0x000000ff7b8a7812ULL, 0x000fe200078ec0ffULL,
0x2000007dff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe20000011686ULL,
0x2000007eff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff877819ULL, 0x000fc4000001164dULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000008ff817819ULL, 0x000fe40000011681ULL,
0x00000008ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff187819ULL, 0x000fe4000001164cULL,
0x00000010ff197819ULL, 0x000fe4000001164eULL, 0x00000010ff837819ULL, 0x000fe20000011683ULL,
0x00000074284c723cULL, 0x000fe2000004181cULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000088ff7e723eULL, 0x000fe400020006ffULL, 0x0000008aff7d723eULL, 0x000fe400020006ffULL,
0x0000105434867816ULL, 0x000fe20000000086ULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x0000105487877816ULL, 0x000fe20000000084ULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x0000105483187816ULL, 0x000fe20000000018ULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x0000105482197816ULL, 0x000fe20000000019ULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x000000862828723cULL, 0x000fe20000041820ULL, 0x00000008ff667819ULL, 0x000fe40000011666ULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x000000182420723cULL, 0x000fe20000041808ULL,
0x00000010ff707819ULL, 0x000fc40000011670ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff197819ULL, 0x000fe40000011671ULL,
0x00000008ff007819ULL, 0x000fe40000011600ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff6e7819ULL, 0x000fc4000001166eULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff1d7819ULL, 0x000fc40000011680ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000095ff6a723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x000010547a187816ULL, 0x000fe20000000070ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x000010547b197816ULL, 0x000fe20000000019ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fc400020006ffULL,
0x000010547e7e7816ULL, 0x000fe4000000006fULL, 0x000010547d7f7816ULL, 0x000fe2000000006eULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00001054721c7816ULL, 0x000fe20000000081ULL,
0x000000182418723cULL, 0x000fe20000041810ULL, 0x00001054731d7816ULL, 0x000fe4000000001dULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x0000007e2410723cULL, 0x040fe20000041814ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff157819ULL, 0x000fe20000011661ULL,
0x0000001c241c723cULL, 0x000fe2000004180cULL, 0x00000010ff6d7819ULL, 0x000fc4000001166dULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff0d7819ULL, 0x000fe40000011676ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff097819ULL, 0x000fe4000001166aULL, 0x00000010ff687819ULL, 0x000fc40000011668ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x0000105467147816ULL, 0x000fe40000000066ULL, 0x0000105469157816ULL, 0x000fe40000000015ULL,
0x0000105462627816ULL, 0x000fe40000000063ULL, 0x000010546c0c7816ULL, 0x000fc4000000007cULL,
0x000010546d0d7816ULL, 0x000fe2000000000dULL, 0x000000142414723cULL, 0x000fe20000041804ULL,
0x0000105477087816ULL, 0x000fe4000000006bULL, 0x0000105468097816ULL, 0x000fe40000000009ULL,
0x0000105464637816ULL, 0x000fc60000000000ULL, 0x0000000c240c723cULL, 0x040ff00000041830ULL,
0x000000082408723cULL, 0x040ff0000004184cULL, 0x000000622404723cULL, 0x000fe20000041828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff247f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007844825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x0106bc00ff267984ULL, 0x000ea40000000800ULL,
0x8000000026ff7812ULL, 0x004fc40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004038007811ULL, 0x000fe400078e40ffULL, 0x00000004ff2a7819ULL, 0x000fe4000001163cULL,
0x0000000039247217ULL, 0x000fe40007800000ULL, 0x000000403b267811ULL, 0x000fe400078e38ffULL,
0x000000022a2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000124247824ULL, 0x000fe200078e0a00ULL,
0x0000003d26007210ULL, 0x000fc40007ffe02aULL, 0x0000003d26257210ULL, 0x000fe40007ffe02bULL,
0x0000002024247807ULL, 0x000fe40000000000ULL, 0x0000000035297210ULL, 0x000fe40007f5e0ffULL,
0x000000243d247217ULL, 0x000fe40007800000ULL, 0x0000002535257210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200010e06ffULL, 0x000000042a327810ULL, 0x000fe20007ffe0ffULL,
0x0000000124007824ULL, 0x000fe200078e0a3dULL, 0x00005e0029247a11ULL, 0x000fe200078440ffULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x00005e0025287a11ULL, 0x000fe200078840ffULL,
0x000000013d347824ULL, 0x000fe200078e0232ULL, 0x000000002a00720cULL, 0x000fc40003f66070ULL,
0x00005f0029297a11ULL, 0x000fe200010f4427ULL, 0x0000000134277824ULL, 0x000fe200078e0226ULL,
0x0000004524247210ULL, 0x000fe40007f5e0ffULL, 0x00005f0025307a11ULL, 0x000fe400020f4430ULL,
0x000000062a317810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200010e0629ULL,
0x0000c00053537811ULL, 0x000fe400078e20ffULL, 0x000000002b00720cULL, 0x000fc40003f46070ULL,
0x00000027352b7210ULL, 0x040fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024537faeULL, 0x0005e2000d901c46ULL, 0x0000003d26267210ULL, 0x000fe40007ffe031ULL,
0x000000003200720cULL, 0x000fe40003f66070ULL, 0x0000002635277210ULL, 0x000fe40007fde0ffULL,
0x0000c00052527811ULL, 0x000fe400078e20ffULL, 0x0000c00051517811ULL, 0x000fe200078e20ffULL,
0x000000ffff297224ULL, 0x000fe200030e06ffULL, 0x0000c00050507811ULL, 0x000fe200078e20ffULL,
0x000000ffff257224ULL, 0x004fe200020e06ffULL, 0x00005e002b2a7a11ULL, 0x000fc400078840ffULL,
0x0000004528247210ULL, 0x080fe40007fbe0ffULL, 0x00005f002b2b7a11ULL, 0x000fe400020f4425ULL,
0x00005e0027287a11ULL, 0x000fe200078840ffULL, 0x000000ffff257224ULL, 0x000fe200028e0630ULL,
0x000000003100720cULL, 0x000fe40003fa6070ULL, 0x000000452a267210ULL, 0x080fe40007fde0ffULL,
0x00005f0027007a11ULL, 0x000fe200020f4429ULL, 0x0000000024527faeULL, 0x0005e2000d101c46ULL,
0x0000004528287210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff277224ULL, 0x000fc800030e062bULL,
0x000000ffff297224ULL, 0x000fe200020e0600ULL, 0x0000000026517faeULL, 0x0005e8000d901c46ULL,
0x0000000028507faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff667f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x00afc4000784482dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff667224ULL, 0x000fe200078e0067ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000784482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0042a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0106b400ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc4000784482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000043ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff2b7819ULL, 0x000fe4000001163cULL, 0x000000043c2c7811ULL, 0x000fe400078fe0ffULL,
0x00005410002a7816ULL, 0x000fe20000000000ULL, 0x000170727f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a647589ULL, 0x0002e400000e0000ULL, 0x000170b27f007947ULL, 0x000fea000b800000ULL,
0x00001f462a677589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0047ULL, 0x00003cb000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x004fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x00017fc000007944ULL, 0x018fea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0048ULL, 0x00003d1000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x004fc400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00017f6000007944ULL, 0x018fea0003c00000ULL, 0x0000e000374f7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0002f4d7811ULL, 0x000fe400078e20ffULL,
0x0000e000364e7811ULL, 0x000fe200078e20ffULL, 0x000000004f24783bULL, 0x004ea20000004200ULL,
0x000000072c2c7812ULL, 0x000fe400078e784aULL, 0x0000e0002e4c7811ULL, 0x000fe200078e20ffULL,
0x000000004d30783bULL, 0x000f620000004200ULL, 0x000000063c007811ULL, 0x000fe200078fe0ffULL,
0x000000084a4b7824ULL, 0x000fc400078e022cULL, 0x000000004e28783bULL, 0x012e620000004200ULL,
0x0000000700007812ULL, 0x000fc600078e784aULL, 0x000000004c2c783bULL, 0x000f240000004200ULL,
0x000000084a4a7824ULL, 0x000fe200078e0200ULL, 0x00000010ff8a7819ULL, 0x104fe40000011626ULL,
0x000000ff266b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011626ULL,
0x0000ffff269b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff267819ULL, 0x000fc40000011627ULL,
0x000000ff30777812ULL, 0x020fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe40000011630ULL,
0x00000010ff367819ULL, 0x100fe40000011624ULL, 0x00000018ff887819ULL, 0x000fe40000011631ULL,
0x000000ff24377812ULL, 0x000fe400078ec0ffULL, 0x00000018ff007819ULL, 0x000fc40000011624ULL,
0x000000ff31787812ULL, 0x000fe400078ec0ffULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000018ff727819ULL, 0x002fe4000001162aULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000010ff847819ULL, 0x000fc40000011631ULL,
0x0000ffff31827812ULL, 0x000fe400078ec0ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000000ff36367812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fe40000011627ULL,
0x000000ff276e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff279c7812ULL, 0x000fc400078ec0ffULL,
0x00000037ff61723eULL, 0x000fe400020006ffULL, 0x00000000ff31723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x000fe20000011625ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000018ff277819ULL, 0x000fe20000011628ULL, 0x20000031ff317230ULL, 0x000fe20000004100ULL,
0x000000ff2b757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff377819ULL, 0x010fc4000001162fULL,
0x000000ff2f987812ULL, 0x040fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fe4000001162fULL,
0x0000ffff2f007812ULL, 0x000fe200078ec0ffULL, 0x20000026ff2f7230ULL, 0x000fe20000004100ULL,
0x00000078ff7a723eULL, 0x000fe200020006ffULL, 0x20000077ff787230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000076ff777230ULL, 0x000fe20000004100ULL,
0x00000036ff26723eULL, 0x000fe200020006ffULL, 0x20000088ff767230ULL, 0x000fe20000004100ULL,
0x00000018ff897819ULL, 0x000fe20000011632ULL, 0x20000072ff7b7230ULL, 0x000fe20000004100ULL,
0x0000ffff259a7812ULL, 0x000fe200078ec0ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fc400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x000000ff87887812ULL, 0x000fe200078ec0ffULL, 0x20000026ff877230ULL, 0x000fe20000004100ULL,
0x0000ffff24997812ULL, 0x000fe200078ec0ffULL, 0x20000027ff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff2a737812ULL, 0x000fe200078ec0ffULL, 0x20000075ff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff328b7812ULL, 0x000fe400078ec0ffULL, 0x00000089ff72723eULL, 0x000fc400020006ffULL,
0x00000008ff897819ULL, 0x000fe4000001169aULL, 0x00000088ff26723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000008bff75723eULL, 0x000fe400020006ffULL,
0x00000008ff277819ULL, 0x000fe20000011699ULL, 0x20000073ff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff8a8b7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000018ff8d7819ULL, 0x000fc40000011633ULL, 0x00000089ff8a723eULL, 0x000fe200020006ffULL,
0x20000026ff897230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff8f7819ULL, 0x000fe20000011629ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x00000008ff267819ULL, 0x000fe4000001169bULL,
0x000000ff286f7812ULL, 0x000fe200078ec0ffULL, 0x20000027ff887230ULL, 0x000fe20000004100ULL,
0x0000008dff73723eULL, 0x000fe200020006ffULL, 0x2000008cff8d7230ULL, 0x000fe20000004100ULL,
0x00000018ff917819ULL, 0x000fc4000001162cULL, 0x00000018ff707819ULL, 0x000fe20000011629ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x000000ff8f8c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff247819ULL, 0x000fe4000001162aULL,
0x0000ffff2a857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fc40000011628ULL,
0x0000006fff2a723eULL, 0x000fe400020006ffULL, 0x00000008ff277819ULL, 0x000fe4000001169cULL,
0x00000091ff6f723eULL, 0x000fe200020006ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000008cff91723eULL, 0x000fe200020006ffULL,
0x20000026ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff25687812ULL, 0x000fe200078ec0ffULL,
0x20000070ff7f7230ULL, 0x000fe20000004100ULL, 0x00000018ff627819ULL, 0x000fe20000011625ULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe2000001162bULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff2d947812ULL, 0x000fc400078ec0ffULL,
0x00000018ff937819ULL, 0x000fe4000001162dULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x0000a0004b267811ULL, 0x000fe400078e20ffULL,
0x000000ff29717812ULL, 0x040fe400078ec0ffULL, 0x0000ffff299e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff297819ULL, 0x000fe4000001162dULL, 0x0000ffff2d6c7812ULL, 0x000fe400078ec0ffULL,
0x0000006eff2d723eULL, 0x000fe400020006ffULL, 0x00000094ff70723eULL, 0x000fe400020006ffULL,
0x00000093ff6e723eULL, 0x000fe200020006ffULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x0000008eff8f723eULL, 0x000fe200020006ffULL, 0x20000027ff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff24937812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000000ff25947812ULL, 0x000fe200078ec0ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x000000002624783bULL, 0x000e620000000200ULL, 0x0000ffff2b867812ULL, 0x000fe200078ec0ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fc40000011630ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x0000ffff30807812ULL, 0x000fe400078ec0ffULL,
0x00000018ff957819ULL, 0x000fe2000001162eULL, 0x20000068ff817230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff637819ULL, 0x000fe40000011632ULL,
0x00000008ff867819ULL, 0x000fc40000011686ULL, 0x000000ff83837812ULL, 0x000fe400078ec0ffULL,
0x00000095ff68723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000086ff95723eULL, 0x000fe200020006ffULL, 0x20000085ff867230ULL, 0x000fe20000004100ULL,
0x000000ff63637812ULL, 0x000fc400078ec0ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000095ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe40000011633ULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x20000083ff957230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x000000ff84847812ULL, 0x000fe200078ec0ffULL, 0x0000006424249231ULL, 0x08afe200003400ffULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x0000006426269231ULL, 0x000fe200003400ffULL,
0x00000082ff83723eULL, 0x000fe200020006ffULL, 0x20000080ff827230ULL, 0x000fe20000004100ULL,
0x0000ffff32307812ULL, 0x000fe200078ec0ffULL, 0x20000063ff807230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x0000006725259231ULL, 0x080fe200003400ffULL,
0x000000ff2e967812ULL, 0x000fe200078ec0ffULL, 0x0000006727279231ULL, 0x000fe200003400ffULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000060ff63723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x0000ffff289d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff607819ULL, 0x000fe40000011661ULL,
0x00000010ff327819ULL, 0x000fe4000001162cULL, 0x000000ff2c927812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2c287812ULL, 0x000fe400078ec0ffULL, 0x00000008ff307819ULL, 0x000fe40000011630ULL,
0x00000010ff617819ULL, 0x000fe20000011681ULL, 0x20000063ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff877819ULL, 0x000fc40000011687ULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x0000006bff2c723eULL, 0x000fe400020006ffULL, 0x00000096ff6b723eULL, 0x000fe200020006ffULL,
0x20000084ff967230ULL, 0x000fe20000004100ULL, 0x00000030ff84723eULL, 0x000fe200020006ffULL,
0x2000002cff2c7230ULL, 0x000fe20000004100ULL, 0x0000105487607816ULL, 0x000fe20000000060ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x0000105489617816ULL, 0x000fe20000000061ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x000fc40000011631ULL,
0x00000010ff307819ULL, 0x000fe40000011688ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x000000ff32327812ULL, 0x000fe400078ec0ffULL,
0x0000105431307816ULL, 0x000fe40000000030ULL, 0x0000105462317816ULL, 0x000fc4000000008aULL,
0x000000602460723cULL, 0x000fe20000041820ULL, 0x000000ff33907812ULL, 0x040fe400078ec0ffULL,
0x0000ffff33337812ULL, 0x000fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe4000001162bULL,
0x00000032ff20723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000010ff6d7819ULL, 0x000fe2000001162eULL, 0x20000020ff897230ULL, 0x000fe20000004100ULL,
0x0000a0004a207811ULL, 0x000fe200078e20ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x0000ffff2e697812ULL, 0x000fc400078ec0ffULL, 0x00000008ff337819ULL, 0x000fe40000011633ULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x0000006aff2e723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000033ff33723eULL, 0x000fe200020006ffULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x00000071ff2b723eULL, 0x000fe200020006ffULL,
0x20000074ff797230ULL, 0x000fe20000004100ULL, 0x00000090ff74723eULL, 0x000fe200020006ffULL,
0x20000033ff887230ULL, 0x000fe20000004100ULL, 0x00000092ff71723eULL, 0x000fe200020006ffULL,
0x000000302430723cULL, 0x000fe2000004181cULL, 0x00000008ff907819ULL, 0x000fe2000001169dULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000008ff927819ULL, 0x000fe2000001169eULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x000fe2000001162cULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff2d7819ULL, 0x000fc4000001162dULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff2f7819ULL, 0x000fe4000001162fULL,
0x00000010ff1c7819ULL, 0x000fe4000001168cULL, 0x00000010ff1d7819ULL, 0x000fc4000001168eULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x000010548b2c7816ULL, 0x000fe2000000002cULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x000010548d2d7816ULL, 0x000fe2000000002dULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x000010542e1c7816ULL, 0x000fe2000000001cULL, 0x0000006420209231ULL, 0x082fe200003400ffULL,
0x000010542f1d7816ULL, 0x000fe2000000001dULL, 0x0000006422229231ULL, 0x000fe200003400ffULL,
0x000000ff29297812ULL, 0x000fe200078ec0ffULL, 0x0000002c242c723cULL, 0x000fe20000041818ULL,
0x00000008ff287819ULL, 0x000fe20000011628ULL, 0x0000006721219231ULL, 0x080fe200003400ffULL,
0x00000010ff2a7819ULL, 0x000fe2000001162aULL, 0x0000006723239231ULL, 0x000fe200003400ffULL,
0x00000010ff8f7819ULL, 0x000fc4000001168fULL, 0x00000010ff197819ULL, 0x000fe4000001162bULL,
0x00000029ff1e723eULL, 0x000fe400020006ffULL, 0x00000028ff1a723eULL, 0x000fe400020006ffULL,
0x000010548f187816ULL, 0x000fe2000000002aULL, 0x2000001eff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x0000001c2428723cULL, 0x000fe20000041814ULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x2000001aff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fc4000001167fULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff1b7819ULL, 0x000fe40000011692ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff1d7819ULL, 0x000fe4000001167dULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff947819ULL, 0x000fc40000011694ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x0000105491197816ULL, 0x000fe40000000019ULL,
0x000010547e1a7816ULL, 0x000fc40000000090ULL, 0x000010547f1b7816ULL, 0x000fe4000000001bULL,
0x00001054931c7816ULL, 0x000fe2000000007cULL, 0x000000182414723cULL, 0x040fe20000041810ULL,
0x00001054941d7816ULL, 0x000fe4000000001dULL, 0x000010547b867816ULL, 0x000fe40000000086ULL,
0x0000105479877816ULL, 0x000fe40000000085ULL, 0x00000008ff6c7819ULL, 0x000fe2000001166cULL,
0x0000001a2418723cULL, 0x000fe2000004180cULL, 0x000000ff6d6d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff37377812ULL, 0x000fe400078ec0ffULL, 0x00000008ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff757819ULL, 0x000fe20000011675ULL, 0x0000001c241c723cULL, 0x000fe20000041808ULL,
0x00000010ff117819ULL, 0x000fe40000011674ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff817819ULL, 0x000fc40000011681ULL, 0x00000008ff007819ULL, 0x000fe20000011600ULL,
0x000000862424723cULL, 0x000fe20000041804ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff057819ULL, 0x000fe40000011688ULL, 0x00000098ff6a723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x0000105480107816ULL, 0x000fe20000000075ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x0000105481117816ULL, 0x000fe20000000011ULL,
0x20000097ff367230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fc400020006ffULL,
0x0000105472047816ULL, 0x000fe40000000084ULL, 0x0000105473057816ULL, 0x000fe20000000005ULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x000000102010723cULL, 0x040fe2000004182cULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff2d7819ULL, 0x000fe20000011670ULL,
0x000000042004723cULL, 0x000fe20000041828ULL, 0x00000010ff957819ULL, 0x000fc40000011695ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff0d7819ULL, 0x000fe40000011683ULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6b7819ULL, 0x000fc4000001166bULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff297819ULL, 0x000fe4000001166aULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff367819ULL, 0x000fc40000011636ULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x000010548b2d7816ULL, 0x000fe4000000002dULL,
0x0000105495087816ULL, 0x000fe40000000078ULL, 0x0000105496097816ULL, 0x000fe4000000007aULL,
0x00001054770c7816ULL, 0x000fe40000000082ULL, 0x00001054760d7816ULL, 0x000fc4000000000dULL,
0x00001054892c7816ULL, 0x000fe20000000071ULL, 0x000000082008723cULL, 0x040fe20000041860ULL,
0x000010546f8a7816ULL, 0x000fe4000000008aULL, 0x000010546e8b7816ULL, 0x000fe4000000006cULL,
0x000010546d287816ULL, 0x000fe4000000006bULL, 0x0000105437297816ULL, 0x000fe20000000029ULL,
0x0000000c200c723cULL, 0x000fe20000041830ULL, 0x0000105468687816ULL, 0x000fc40000000069ULL,
0x0000105436697816ULL, 0x000fca0000000000ULL, 0x0000002c2014723cULL, 0x040ff00000041814ULL,
0x0000008a2018723cULL, 0x040ff00000041818ULL, 0x00000028201c723cULL, 0x040ff0000004181cULL,
0x000000682020723cULL, 0x000fe20000041824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004038007811ULL, 0x000fe200078e40ffULL,
0x01068800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000003900720cULL, 0x000fda0003f24070ULL,
0x0000c5e000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x006fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300ff627624ULL, 0x000fe200078e00ffULL,
0x0000000144007812ULL, 0x000fe200078ec0ffULL, 0xffffffffff657424ULL, 0x000fc600078e00ffULL,
0x000000010000780cULL, 0x000fe40003f25070ULL, 0xffffffff62627811ULL, 0x000fc800078e08ffULL,
0x0000000162627807ULL, 0x000fca0004800000ULL, 0x0000000144447824ULL, 0x000fca00078e0262ULL,
0x000000034400720cULL, 0x000fe40003f26070ULL, 0x00000004ff307819ULL, 0x000fd6000001163cULL,
0x0000006241249210ULL, 0x000fe20007ffe049ULL, 0x00000004ff259424ULL, 0x000fc800078e00ffULL,
0x0000600024249625ULL, 0x000fca00078e0025ULL, 0x0000000624659981ULL, 0x000362000c1e1900ULL,
0x0000006038007811ULL, 0x000fe400078e40ffULL, 0x000000043c2f7811ULL, 0x000fe400078fe0ffULL,
0x0000000230317810ULL, 0x000fe40007ffe0ffULL, 0x000000063c2e7811ULL, 0x000fe400078fe0ffULL,
0x000000603b257811ULL, 0x002fe200078e38ffULL, 0x000000013d617824ULL, 0x000fe200078e0231ULL,
0x0000000039247217ULL, 0x000fc40007800000ULL, 0x0000003d25267210ULL, 0x000fc60007ffe030ULL,
0x0000000124247824ULL, 0x000fe200078e0a00ULL, 0x00000026352d7210ULL, 0x000fe40007f3e0ffULL,
0x0000002f25007210ULL, 0x140fe40007ffe03dULL, 0x0000002e25267210ULL, 0x000fe20007ffe03dULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x00005e002d297a11ULL, 0x000fe200078240ffULL,
0x0000000161257824ULL, 0x000fe200078e0225ULL, 0x0000002635267210ULL, 0x000fe40007f7e0ffULL,
0x00005f002d2d7a11ULL, 0x000fc400008f4427ULL, 0x0000000035007210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e06ffULL, 0x0000002024247807ULL, 0x000fe40000000000ULL,
0x00005e0000287a11ULL, 0x000fe200078440ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x000000243d247217ULL, 0x000fe40007800000ULL, 0x0000002535257210ULL, 0x000fe40007f3e0ffULL,
0x00005e00262a7a11ULL, 0x000fc400078640ffULL, 0x00005f0000277a11ULL, 0x000fe200010f4427ULL,
0x0000000124007824ULL, 0x000fe200078e0a3dULL, 0x00005f00262b7a11ULL, 0x000fe200018f442bULL,
0x000000ffff2c7224ULL, 0x000fe200008e06ffULL, 0x00005e0025267a11ULL, 0x000fe400078640ffULL,
0x0000004529247210ULL, 0x080fe40007f9e0ffULL, 0x0000004528287210ULL, 0x000fe40007fde0ffULL,
0x000000003000720cULL, 0x000fc40003f46070ULL, 0x00005f00252c7a11ULL, 0x000fe200018f442cULL,
0x000000ffff257224ULL, 0x000fe200020e062dULL, 0x0000004526267210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe200030e0627ULL, 0x000000003100720cULL, 0x080fe40003f26070ULL,
0x000000002f00720cULL, 0x080fe20003f66070ULL, 0x000000ffff277224ULL, 0x000fe200028e062cULL,
0x000000002e00720cULL, 0x000fe40003f86070ULL, 0x000000452a2a7210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000245f7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff2b7224ULL, 0x000fc400028e062bULL, 0x00000000265e7faeULL, 0x0003e8000c901c46ULL,
0x00000000285d7faeULL, 0x0003e8000d901c46ULL, 0x000000002a5c7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff2c7f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010628003d247f8cULL, 0x002fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc60007844866ULL,
0x01062c003d267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x01062c003d267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010080005b267984ULL, 0x000e680000000800ULL, 0x010280005b277984ULL, 0x0007220000000800ULL,
0x0000003e2600720bULL, 0x002fe20003f3d000ULL, 0x000151627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00287812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000013a00780cULL, 0x000fe40003f65270ULL,
0x0000003e2600720bULL, 0x000fe20003f34000ULL, 0x000151227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x000000263e247209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x800000243e257221ULL, 0x000fe20000010000ULL,
0x010480245b00b388ULL, 0x0003e20000000800ULL, 0x0000000028ff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fca000001163cULL,
0x0000002500257308ULL, 0x000ee40000000800ULL, 0x000000253f3f7220ULL, 0x008fe20000410000ULL,
0x000150b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0025007589ULL, 0x0022e400000e0000ULL,
0x0000000008087220ULL, 0x08cfe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000004047220ULL, 0x080fe20000410000ULL, 0x0000000005057220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x000fe20000410000ULL,
0x000150027f007947ULL, 0x000fea000b800000ULL, 0x00001f4625007589ULL, 0x0004e400000e0000ULL,
0x000000263e3e7209ULL, 0x000fe20007810000ULL, 0x000000000a0a7220ULL, 0x08cfe20000410000ULL,
0x00000001ff247807ULL, 0x000fe20000800000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x8000003e26261221ULL, 0x000fe20000010000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000002600431308ULL, 0x000ea20000000800ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x000fe20000410000ULL, 0x0000002743271220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003f273f7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc40007824866ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x0022e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007824866ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000043ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff2b7819ULL, 0x000fc4000001163cULL, 0x00005410002a7816ULL, 0x000fe20000000000ULL,
0x00014db27f007947ULL, 0x000fea000b800000ULL, 0x00001f2b2a2e7589ULL, 0x00072400000e0000ULL,
0x00014df27f007947ULL, 0x000fea000b800000ULL, 0x00001f462a2f7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x008fe200078e0047ULL,
0x000061a000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00015ad000007944ULL, 0x036fea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x008fe200078e0048ULL,
0x0000620000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00015a7000007944ULL, 0x036fea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005968783bULL, 0x000e620000004200ULL,
0x0000991024007816ULL, 0x004fc600000000ffULL, 0x000000005728783bULL, 0x00ae620000004200ULL,
0x000000ff0000720cULL, 0x000fc60003f25270ULL, 0x000000005830783bULL, 0x000ea80000004200ULL,
0x000000005624783bULL, 0x000ee20000004200ULL, 0x00000018ff007819ULL, 0x100fe40000011668ULL,
0x00000010ff357819ULL, 0x000fe40000011668ULL, 0x00000010ff857819ULL, 0x002fe40000011628ULL,
0x000000ff28737812ULL, 0x000fc400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe40000011628ULL,
0x0000ffff28837812ULL, 0x000fe400078ec0ffULL, 0x000000ff33717812ULL, 0x004fe400078ec0ffULL,
0x00000000ff28723eULL, 0x000fe400020006ffULL, 0x00000018ff707819ULL, 0x100fe40000011633ULL,
0x00000010ff8a7819ULL, 0x000fc40000011633ULL, 0x0000ffff33887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x108fe40000011626ULL, 0x000000ff26997812ULL, 0x040fe400078ec0ffULL,
0x00000018ff987819ULL, 0x000fe40000011626ULL, 0x0000ffff26337812ULL, 0x000fe200078ec0ffULL,
0x20000028ff267230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000073ff28723eULL, 0x000fe200020006ffULL,
0x20000071ff747230ULL, 0x000fe20000004100ULL, 0x000000ff68367812ULL, 0x040fe200078ec0ffULL,
0x20000070ff717230ULL, 0x000fe20000004100ULL, 0x0000ffff689c7812ULL, 0x000fe200078ec0ffULL,
0x20000028ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe40000011629ULL,
0x000000ff29907812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8f7819ULL, 0x000fe40000011629ULL,
0x0000ffff29847812ULL, 0x000fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001166bULL,
0x00000010ff827819ULL, 0x100fe4000001162aULL, 0x000000ff2a927812ULL, 0x000fe400078ec0ffULL,
0x00000018ff297819ULL, 0x000fc4000001162aULL, 0x0000ffff2a7f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x100fe40000011669ULL, 0x000000ff69607812ULL, 0x040fe400078ec0ffULL,
0x00000018ff377819ULL, 0x000fe40000011669ULL, 0x0000ffff699d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fc4000001162bULL, 0x000000ff6b697812ULL, 0x000fe400078ec0ffULL,
0x000000ff35287812ULL, 0x000fe400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000068ff7c7230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x2000002aff687230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fe200020006ffULL,
0x20000069ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe2000001162bULL,
0x20000029ff697230ULL, 0x000fe20000004100ULL, 0x000000ff2b947812ULL, 0x000fc400078ec0ffULL,
0x0000ffff2b7d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2b7819ULL, 0x000fe40000011624ULL,
0x000000ff326d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c2a7812ULL, 0x000fe200078ec0ffULL,
0x20000028ff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff8d7819ULL, 0x000fe4000001166aULL,
0x000000ff6a677812ULL, 0x000fc400078ec0ffULL, 0x00000018ff667819ULL, 0x000fe4000001166aULL,
0x0000ffff6a9e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fe4000001166bULL,
0x0000ffff6b9f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x000fe40000011630ULL,
0x000000ff306b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011630ULL,
0x0000ffff30a07812ULL, 0x000fe400078ec0ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000008ff297819ULL, 0x000fe4000001169cULL, 0x00000008ff287819ULL, 0x000fe4000001169dULL,
0x00000010ff937819ULL, 0x000fc40000011631ULL, 0x000000ff316c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff307819ULL, 0x000fe40000011631ULL, 0x0000ffff318b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x100fe40000011632ULL, 0x00000018ff317819ULL, 0x000fe40000011632ULL,
0x0000ffff32877812ULL, 0x000fc400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000010ff327819ULL, 0x100fe40000011627ULL, 0x000000ff279b7812ULL, 0x040fe200078ec0ffULL,
0x2000006dff757230ULL, 0x000fe20000004100ULL, 0x00000018ff9a7819ULL, 0x000fe40000011627ULL,
0x0000ffff27007812ULL, 0x000fe400078ec0ffULL, 0x00000037ff27723eULL, 0x000fe200020006ffULL,
0x2000002bff377230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fc400020006ffULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x000000ff8d2b7812ULL, 0x000fe200078ec0ffULL, 0x20000029ff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000008fff6d723eULL, 0x000fe200020006ffULL,
0x20000028ff8f7230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x2000006cff7b7230ULL, 0x000fe20000004100ULL, 0x0000002bff2b723eULL, 0x000fe200020006ffULL,
0x2000006aff767230ULL, 0x000fe20000004100ULL, 0x0000008eff29723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fc4000001169eULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x00000072ff6c723eULL, 0x000fe200020006ffULL, 0x20000090ff727230ULL, 0x000fe20000004100ULL,
0x000000ff24957812ULL, 0x000fe200078ec0ffULL, 0x2000002bff907230ULL, 0x000fe20000004100ULL,
0x00000092ff6a723eULL, 0x000fe200020006ffULL, 0x20000029ff927230ULL, 0x000fe20000004100ULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x20000066ff797230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x2000002aff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff93937812ULL, 0x000fe200078ec0ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fe2000001169fULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000008ff2b7819ULL, 0x000fc400000116a0ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000095ff66723eULL, 0x000fe400020006ffULL,
0x00000091ff2a723eULL, 0x000fe200020006ffULL, 0x20000028ff917230ULL, 0x000fe20000004100ULL,
0x00000018ff967819ULL, 0x000fe20000011625ULL, 0x2000006bff7a7230ULL, 0x000fe20000004100ULL,
0x00000093ff95723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fc400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x0000a80055287811ULL, 0x000fe200078e20ffULL, 0x20000029ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fe40000011625ULL, 0x000000ff25977812ULL, 0x040fe400078ec0ffULL,
0x0000ffff25637812ULL, 0x000fe200078ec0ffULL, 0x20000060ff257230ULL, 0x000fe20000004100ULL,
0x00000096ff60723eULL, 0x000fe200020006ffULL, 0x20000095ff967230ULL, 0x000fe20000004100ULL,
0x00000094ff6b723eULL, 0x000fe200020006ffULL, 0x2000002aff947230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000002bff957230ULL, 0x000fe20000004100ULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x00000008ff887819ULL, 0x000fe20000011688ULL, 0x20000067ff807230ULL, 0x000fe20000004100ULL,
0x00000031ff31723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000097ff67723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000031ff737230ULL, 0x000fe20000004100ULL,
0x00000088ff97723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x000000ff86867812ULL, 0x000fe200078ec0ffULL, 0x20000087ff887230ULL, 0x000fe20000004100ULL,
0x00000098ff31723eULL, 0x000fc400020006ffULL, 0x000000ff85987812ULL, 0x000fe200078ec0ffULL,
0x20000097ff857230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe20000011684ULL,
0x20000031ff317230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x000000ff82977812ULL, 0x000fe400078ec0ffULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000087ff82723eULL, 0x000fc400020006ffULL, 0x00000097ff87723eULL, 0x000fe200020006ffULL,
0x20000086ff977230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fe20000011624ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000ffff246f7812ULL, 0x000fe200078ec0ffULL,
0x20000036ff247230ULL, 0x000fe20000004100ULL, 0x000000ff7e867812ULL, 0x000fe200078ec0ffULL,
0x20000087ff7e7230ULL, 0x000fe20000004100ULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x00000086ff87723eULL, 0x000fc400020006ffULL, 0x00000008ff867819ULL, 0x000fe2000001167fULL,
0x20000098ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe20000011624ULL,
0x20000087ff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe20000011625ULL,
0x0000002e28289231ULL, 0x092fe200003400ffULL, 0x00000010ff8c7819ULL, 0x000fe2000001168cULL,
0x0000002e2a2a9231ULL, 0x000fe200003400ffULL, 0x00000010ff8e7819ULL, 0x000fe2000001168eULL,
0x0000002f29299231ULL, 0x080fe200003400ffULL, 0x00000086ff98723eULL, 0x000fe200020006ffULL,
0x0000002f2b2b9231ULL, 0x000fe200003400ffULL, 0x000010548c247816ULL, 0x000fc40000000024ULL,
0x000010548e257816ULL, 0x000fe40000000025ULL, 0x00000010ff867819ULL, 0x000fe40000011626ULL,
0x00000010ff877819ULL, 0x000fe40000011627ULL, 0x00000010ff267819ULL, 0x000fe2000001168dULL,
0x000000242808723cULL, 0x000fe20000041808ULL, 0x00000010ff277819ULL, 0x000fe4000001168fULL,
0x0000105486267816ULL, 0x000fc40000000026ULL, 0x0000105487277816ULL, 0x000fe40000000027ULL,
0x00000010ff247819ULL, 0x000fe40000011680ULL, 0x00000010ff257819ULL, 0x000fe40000011681ULL,
0x00000010ff907819ULL, 0x000fe20000011690ULL, 0x00000026280c723cULL, 0x000fe2000004180cULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x0000105490247816ULL, 0x000fc40000000024ULL,
0x0000105492257816ULL, 0x000fe40000000025ULL, 0x0000a80054267811ULL, 0x000fe400078e20ffULL,
0x000000ff78787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x000000242810723cULL, 0x000fe20000041810ULL, 0x000000002624783bULL, 0x000e620000000200ULL,
0x00000078ff81723eULL, 0x000fe400020006ffULL, 0x00000010ff787819ULL, 0x000fc40000011691ULL,
0x00000010ff7c7819ULL, 0x000fe2000001167cULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x0000105479787816ULL, 0x000fe40000000078ULL, 0x00000008ff8b7819ULL, 0x000fe4000001168bULL,
0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL, 0x000010547c797816ULL, 0x000fe40000000093ULL,
0x000000ff6e867812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001166fULL,
0x00000010ff6e7819ULL, 0x000fe2000001167aULL, 0x000000782804723cULL, 0x000fe20000041804ULL,
0x00000010ff6f7819ULL, 0x000fe4000001167bULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000030ff30723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000030ff777230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00001054946e7816ULL, 0x000fe2000000006eULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00001054966f7816ULL, 0x000fe2000000006fULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fe20000011677ULL,
0x0000002e24249231ULL, 0x082fe200003400ffULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x0000002e26269231ULL, 0x000fe200003400ffULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x0000006e2814723cULL, 0x000fe20000041814ULL, 0x00000008ff8c7819ULL, 0x000fe2000001167dULL,
0x20000098ff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x0000002f25259231ULL, 0x080fe200003400ffULL, 0x00000010ff957819ULL, 0x000fe20000011695ULL,
0x0000002f27279231ULL, 0x000fe200003400ffULL, 0x00000010ff777819ULL, 0x000fc4000001168bULL,
0x00000010ff6f7819ULL, 0x000fe40000011674ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff857819ULL, 0x000fc40000011685ULL,
0x00001054896e7816ULL, 0x000fe40000000075ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000105476767816ULL, 0x000fe40000000095ULL, 0x0000105478777816ULL, 0x000fe20000000077ULL,
0x2000008cff807230ULL, 0x000fe20000004100ULL, 0x000010548a6f7816ULL, 0x000fe4000000006fULL,
0x0000105473887816ULL, 0x000fc40000000088ULL, 0x0000105471897816ULL, 0x000fe20000000085ULL,
0x000000762818723cULL, 0x040fe20000041818ULL, 0x00000008ff837819ULL, 0x000fe40000011683ULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x000000ff32327812ULL, 0x000fe200078ec0ffULL, 0x0000006e281c723cULL, 0x000fe2000004181cULL,
0x00000008ff337819ULL, 0x000fc40000011633ULL, 0x00000008ff007819ULL, 0x000fe40000011600ULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x000000882820723cULL, 0x000fe20000041820ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000099ff36723eULL, 0x000fc400020006ffULL, 0x00000010ff287819ULL, 0x000fe4000001166dULL,
0x00000010ff6d7819ULL, 0x000fe20000011682ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe40000011680ULL, 0x0000009bff9b723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x2000009bff357230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000009aff30723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000033ff33723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x20000030ff307230ULL, 0x000fe20000004100ULL, 0x00001054286d7816ULL, 0x000fe2000000006dULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x0000105469287816ULL, 0x000fe2000000007dULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x0000105468297816ULL, 0x000fc40000000029ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x000000282404723cULL, 0x000fe20000041804ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff977819ULL, 0x000fc40000011697ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff7f7819ULL, 0x000fc4000001167fULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff367819ULL, 0x000fe40000011636ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00000010ff327819ULL, 0x000fe40000011632ULL, 0x00000010ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff337819ULL, 0x000fc40000011633ULL, 0x00000010ff297819ULL, 0x000fe40000011630ULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x00001054377c7816ULL, 0x000fe4000000007cULL,
0x0000105484707816ULL, 0x000fe40000000070ULL, 0x0000105497717816ULL, 0x000fe40000000072ULL,
0x000010546c6c7816ULL, 0x000fc40000000083ULL, 0x000010547e6a7816ULL, 0x000fe4000000006aULL,
0x000010547f6b7816ULL, 0x000fe2000000006bULL, 0x000000702408723cULL, 0x040fe20000041808ULL,
0x0000105481667816ULL, 0x000fe40000000066ULL, 0x0000105486677816ULL, 0x000fe40000000067ULL,
0x00001054607d7816ULL, 0x000fe40000000063ULL, 0x0000105464367816ULL, 0x000fe20000000036ULL,
0x0000006c240c723cULL, 0x000fe2000004180cULL, 0x0000105432377816ULL, 0x000fc40000000035ULL,
0x0000105431287816ULL, 0x000fe40000000033ULL, 0x0000105429297816ULL, 0x000fc60000000000ULL,
0x0000006a2410723cULL, 0x040ff00000041810ULL, 0x000000662414723cULL, 0x040ff00000041814ULL,
0x0000007c2418723cULL, 0x040ff00000041818ULL, 0x00000036241c723cULL, 0x040ff0000004181cULL,
0x000000282424723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff207f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844821ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000227305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000220000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fc40007844821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff2f7819ULL, 0x000fe2000001163cULL,
0x0000580065647a24ULL, 0x020fe200078e02ffULL, 0x0000008038007811ULL, 0x000fe400078e40ffULL,
0x000000022f2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000013d637824ULL, 0x000fe200078e022fULL,
0x0000000039207217ULL, 0x000fe20007800000ULL, 0x0000008064647824ULL, 0x000fe400078e00ffULL,
0x000000803b307824ULL, 0x000fe400078e0263ULL, 0x0000000120207824ULL, 0x000fc600078e0a00ULL,
0x00000064302e7210ULL, 0x000fe40007f5e0ffULL, 0x0000002020207807ULL, 0x000fe40000000000ULL,
0x0000000430297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005e002e2a7a11ULL, 0x000fe400078440ffULL, 0x000000203d207217ULL, 0x000fe40007800000ULL,
0x0000000230237810ULL, 0x000fc40007ffe0ffULL, 0x0000006429297210ULL, 0x080fe40007f9e0ffULL,
0x00005f002e2e7a11ULL, 0x000fe200010f4400ULL, 0x0000000120007824ULL, 0x000fe200078e0a3dULL,
0x0000006423237210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x00005e0029287a11ULL, 0x000fe400078840ffULL, 0x00005e0023227a11ULL, 0x000fe200078640ffULL,
0x000000ffff217224ULL, 0x000fe200010e06ffULL, 0x000000002b00720cULL, 0x000fc40003f46070ULL,
0x00005f0029297a11ULL, 0x000fe400020f4420ULL, 0x00000006302b7810ULL, 0x000fe40007ffe0ffULL,
0x000000452a207210ULL, 0x080fe40007fbe0ffULL, 0x00005f0023237a11ULL, 0x000fe400018f4421ULL,
0x000000642b2b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff217224ULL, 0x000fe200028e062eULL,
0x0000004522227210ULL, 0x000fc40007fde0ffULL, 0x0000004528287210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200020e06ffULL, 0x000000042f307810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x000fe200030e0623ULL, 0x000000002f00720cULL, 0x0c0fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x000000062f2f7810ULL, 0x000fe40007ffe0ffULL,
0x00005e002b2a7a11ULL, 0x000fe400078840ffULL, 0x000000003000720cULL, 0x000fc40003fc6070ULL,
0x000000002f00720cULL, 0x000fe40003fa6070ULL, 0x00005f002b007a11ULL, 0x000fe400020f442eULL,
0x000000452a2a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020537faeULL, 0x0003e8000d901c46ULL, 0x000000ffff2b7224ULL, 0x000fe200020e0600ULL,
0x0000000022527faeULL, 0x0003e8000d101c46ULL, 0x0000000028517faeULL, 0x0003e8000f101c46ULL,
0x000000002a507faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff667f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc4000784482dULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000ffff667224ULL, 0x000fe400078e0067ULL, 0x000000013d607824ULL, 0x000fe200078e022fULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe4000784482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000207305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000200000735dULL, 0x004fe40003800000ULL, 0x0106b400ff207984ULL, 0x000e640000000800ULL,
0x8000000020ff7812ULL, 0x002fc4000784482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000043ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff2b7819ULL, 0x002fe4000001163cULL,
0x00005410002a7816ULL, 0x000fe20000000000ULL, 0x000130927f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a357589ULL, 0x0002a400000e0000ULL, 0x000130d27f007947ULL, 0x000fea000b800000ULL,
0x00001f462a367589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0047ULL, 0x00007f9000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00013ce000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0048ULL, 0x00007ff000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fc400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00013c8000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004e28783bULL, 0x00ae680000004200ULL, 0x000000004f20783bULL, 0x000ee80000004200ULL,
0x000000004d2c783bULL, 0x000f680000004200ULL, 0x000000004c30783bULL, 0x000f220000004200ULL,
0x00000010ff937819ULL, 0x002fc40000011628ULL, 0x000000ff286f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011628ULL, 0x0000ffff28a07812ULL, 0x000fe400078ec0ffULL,
0x00000018ff287819ULL, 0x000fe40000011629ULL, 0x00000010ff007819ULL, 0x00cfe40000011620ULL,
0x000000ff29747812ULL, 0x000fc400078ec0ffULL, 0x00000010ff957819ULL, 0x000fe40000011629ULL,
0x0000ffff298d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff297819ULL, 0x000fe4000001162aULL,
0x000000ff2b767812ULL, 0x000fe400078ec0ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x000000ff00007812ULL, 0x000fe200078ec0ffULL,
0x20000028ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff2c777812ULL, 0x020fe200078ec0ffULL,
0x20000074ff7d7230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x00000010ff8c7819ULL, 0x000fe2000001162aULL,
0x20000076ff787230ULL, 0x000fe20000004100ULL, 0x000000ff2a757812ULL, 0x000fc400078ec0ffULL,
0x0000ffff2a897812ULL, 0x000fe400078ec0ffULL, 0x0000ffff209c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x100fe4000001162bULL, 0x00000018ff2a7819ULL, 0x000fe4000001162bULL,
0x0000ffff2b8a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2d8e7812ULL, 0x000fc400078ec0ffULL,
0x00000000ff28723eULL, 0x000fe400020006ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001162cULL,
0x0000ffff219d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011622ULL,
0x00000077ff74723eULL, 0x000fe200020006ffULL, 0x20000029ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x000fc40000011623ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x0000008eff76723eULL, 0x000fe200020006ffULL, 0x20000028ff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fe2000001169cULL, 0x2000006fff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff236d7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff797230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fc400020006ffULL, 0x00000010ff917819ULL, 0x000fe20000011622ULL,
0x2000002aff757230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000002bff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fe4000001169dULL,
0x0000ffff229e7812ULL, 0x000fe200078ec0ffULL, 0x2000006aff717230ULL, 0x000fe20000004100ULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8f7819ULL, 0x000fc4000001162eULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x000000ff21697812ULL, 0x000fe400078ec0ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x000000ff91917812ULL, 0x000fe400078ec0ffULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x2000006dff817230ULL, 0x000fe20000004100ULL,
0x000000ff2e947812ULL, 0x000fc400078ec0ffULL, 0x00000092ff2b723eULL, 0x000fe400020006ffULL,
0x00000008ff2a7819ULL, 0x000fe4000001169eULL, 0x0000ffff239f7812ULL, 0x000fe400078ec0ffULL,
0x0000008fff6a723eULL, 0x000fe200020006ffULL, 0x20000029ff8f7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000018ff687819ULL, 0x000fe20000011621ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000091ff29723eULL, 0x000fe200020006ffULL,
0x20000028ff917230ULL, 0x000fe20000004100ULL, 0x00000018ff6c7819ULL, 0x000fe20000011623ULL,
0x20000069ff867230ULL, 0x000fe20000004100ULL, 0x000000ff30977812ULL, 0x010fe200078ec0ffULL,
0x20000029ff927230ULL, 0x000fe20000004100ULL, 0x00000094ff6d723eULL, 0x000fe200020006ffULL,
0x2000002bff947230ULL, 0x000fe20000004100ULL, 0x0000002aff2a723eULL, 0x000fc400020006ffULL,
0x00000008ff287819ULL, 0x000fe2000001169fULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff95957812ULL, 0x000fe400078ec0ffULL, 0x000000ff932b7812ULL, 0x000fe200078ec0ffULL,
0x2000002aff937230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000097ff69723eULL, 0x000fe200020006ffULL,
0x20000068ff827230ULL, 0x000fe20000004100ULL, 0x000000ff31987812ULL, 0x000fe200078ec0ffULL,
0x2000006cff7e7230ULL, 0x000fe20000004100ULL, 0x00000028ff29723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000095ff97723eULL, 0x000fc400020006ffULL,
0x000000ff2f967812ULL, 0x000fe200078ec0ffULL, 0x20000029ff957230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x0000a8004b287811ULL, 0x000fe400078e20ffULL,
0x00000008ff2a7819ULL, 0x000fe400000116a0ULL, 0x00000098ff68723eULL, 0x000fe200020006ffULL,
0x20000097ff987230ULL, 0x000fe20000004100ULL, 0x00000096ff6c723eULL, 0x000fe200020006ffULL,
0x2000002bff967230ULL, 0x000fe20000004100ULL, 0x0000002aff97723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x00000010ff877819ULL, 0x000fe2000001162cULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000ffff2c837812ULL, 0x000fe200078ec0ffULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x00000018ff2c7819ULL, 0x000fc4000001162dULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000010ff907819ULL, 0x000fe40000011621ULL, 0x0000002cff2c723eULL, 0x000fe200020006ffULL,
0x2000006eff7a7230ULL, 0x000fe20000004100ULL, 0x00000018ff997819ULL, 0x000fe40000011632ULL,
0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL, 0x2000002cff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff8b8b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff20677812ULL, 0x000fe400078ec0ffULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x00000018ff9a7819ULL, 0x000fe40000011633ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x00000099ff2c723eULL, 0x000fc400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000ffff2d847812ULL, 0x000fe200078ec0ffULL, 0x2000002cff2c7230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000008ff997819ULL, 0x000fe2000001168aULL,
0x2000008cff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff837819ULL, 0x000fe20000011683ULL,
0x2000008bff8c7230ULL, 0x000fe20000004100ULL, 0x00000067ff85723eULL, 0x000fe200020006ffULL,
0x0000003528289231ULL, 0x082fe200003400ffULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x000000352a2a9231ULL, 0x000fe200003400ffULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000018ff377819ULL, 0x000fe20000011620ULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe2000001162fULL,
0x20000089ff8b7230ULL, 0x000fe20000004100ULL, 0x0000009aff9a723eULL, 0x000fe200020006ffULL,
0x0000003629299231ULL, 0x080fe200003400ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x000000362b2b9231ULL, 0x000fe200003400ffULL, 0x00000010ff887819ULL, 0x000fe2000001162dULL,
0x2000009aff007230ULL, 0x000fe20000004100ULL, 0x00000099ff99723eULL, 0x000fe200020006ffULL,
0x20000087ff897230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fc40000011684ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000ffff2e207812ULL, 0x000fe400078ec0ffULL,
0x00000037ff23723eULL, 0x000fe400020006ffULL, 0x000000ff21217812ULL, 0x000fe400078ec0ffULL,
0x000000ff889a7812ULL, 0x000fe200078ec0ffULL, 0x20000099ff887230ULL, 0x000fe20000004100ULL,
0x00000084ff87723eULL, 0x000fe200020006ffULL, 0x20000083ff847230ULL, 0x000fe20000004100ULL,
0x000000ff226b7812ULL, 0x000fe200078ec0ffULL, 0x20000023ff237230ULL, 0x000fe20000004100ULL,
0x00000021ff83723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff997819ULL, 0x000fc40000011620ULL, 0x0000ffff2f227812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fe40000011685ULL,
0x00000010ff217819ULL, 0x000fe40000011686ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x000010548e207816ULL, 0x000fe40000000020ULL, 0x0000105490217816ULL, 0x000fe20000000021ULL,
0x2000006bff807230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe40000011622ULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x00000010ff227819ULL, 0x000fe2000001168fULL,
0x000000202808723cULL, 0x000fe20000041808ULL, 0x00000010ff857819ULL, 0x000fc40000011682ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x0000105423227816ULL, 0x000fe40000000022ULL,
0x0000105485237816ULL, 0x000fe40000000091ULL, 0x00000010ff207819ULL, 0x000fe40000011680ULL,
0x00000010ff217819ULL, 0x000fe40000011681ULL, 0x00000010ff927819ULL, 0x000fe20000011692ULL,
0x00000022280c723cULL, 0x000fe2000004180cULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x0000105492207816ULL, 0x000fe40000000020ULL, 0x0000105494217816ULL, 0x000fe40000000021ULL,
0x0000a8004a227811ULL, 0x000fe400078e20ffULL, 0x00000010ff707819ULL, 0x000fe40000011630ULL,
0x00000008ff8d7819ULL, 0x000fe2000001168dULL, 0x000000202810723cULL, 0x000fe20000041810ULL,
0x000000ff70707812ULL, 0x000fe200078ec0ffULL, 0x000000002220783bULL, 0x000e620000000200ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x00000070ff81723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe40000011693ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000105471707816ULL, 0x000fc40000000070ULL,
0x000010547e717816ULL, 0x000fe20000000095ULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fe4000001162eULL, 0x0000ffff30737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x000fe20000011631ULL, 0x000000702804723cULL, 0x000fe20000041804ULL,
0x00000018ff2e7819ULL, 0x000fe4000001162fULL, 0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff72857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff707819ULL, 0x000fe4000001167bULL,
0x00000010ff7b7819ULL, 0x000fe4000001168dULL, 0x00000008ff7e7819ULL, 0x000fe40000011673ULL,
0x00001054707b7816ULL, 0x000fe4000000007bULL, 0x00000018ff2f7819ULL, 0x000fc40000011630ULL,
0x00000010ff727819ULL, 0x000fe2000001167cULL, 0x0000003520209231ULL, 0x082fe200003400ffULL,
0x00000010ff737819ULL, 0x000fe2000001167dULL, 0x0000003522229231ULL, 0x000fe200003400ffULL,
0x00000010ff967819ULL, 0x000fe20000011696ULL, 0x0000003621219231ULL, 0x080fe200003400ffULL,
0x00000010ff987819ULL, 0x000fe20000011698ULL, 0x0000003623239231ULL, 0x000fe200003400ffULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff977819ULL, 0x000fc40000011697ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff707819ULL, 0x000fc4000001168bULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff717819ULL, 0x000fe40000011688ULL,
0x00000010ff2d7819ULL, 0x000fe40000011633ULL, 0x0000002eff2e723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000018ff307819ULL, 0x000fe20000011631ULL,
0x2000002eff6b7230ULL, 0x000fe20000004100ULL, 0x0000ffff31377812ULL, 0x000fe200078ec0ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x000000ff32317812ULL, 0x000fc400078ec0ffULL,
0x0000002fff2f723eULL, 0x000fe400020006ffULL, 0x0000105496727816ULL, 0x000fe40000000072ULL,
0x0000105498737816ULL, 0x000fe40000000073ULL, 0x000010547a7a7816ULL, 0x000fe40000000097ULL,
0x000010548a8a7816ULL, 0x000fe40000000079ULL, 0x000010548c8b7816ULL, 0x000fe20000000078ULL,
0x000000722814723cULL, 0x000fe20000041814ULL, 0x0000105477707816ULL, 0x000fc40000000070ULL,
0x0000105475717816ULL, 0x000fe40000000071ULL, 0x00000010ff677819ULL, 0x000fe40000011632ULL,
0x000000ff339b7812ULL, 0x000fe200078ec0ffULL, 0x0000007a2818723cULL, 0x000fe20000041818ULL,
0x000000ff2d2d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff32327812ULL, 0x000fe400078ec0ffULL,
0x0000ffff33337812ULL, 0x000fc400078ec0ffULL, 0x00000031ff2e723eULL, 0x000fe200020006ffULL,
0x2000002fff317230ULL, 0x000fe20000004100ULL, 0x0000009bff2f723eULL, 0x000fe200020006ffULL,
0x0000008a281c723cULL, 0x040fe2000004181cULL, 0x00000008ff377819ULL, 0x000fe20000011637ULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x000000ff67677812ULL, 0x000fe200078ec0ffULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x0000002dff2d723eULL, 0x000fe400020006ffULL,
0x00000008ff327819ULL, 0x000fe20000011632ULL, 0x000000702824723cULL, 0x000fe20000041824ULL,
0x00000008ff337819ULL, 0x000fe20000011633ULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166dULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff297819ULL, 0x000fe4000001166cULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000030ff30723eULL, 0x000fe400020006ffULL, 0x0000009aff9a723eULL, 0x000fe400020006ffULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x20000030ff307230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x2000009aff9a7230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000099ff827230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x20000086ff807230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x20000085ff7c7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000032ff32723eULL, 0x000fe200020006ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x00000033ff33723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x000010547f287816ULL, 0x000fe2000000006dULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x0000105483297816ULL, 0x000fe20000000029ULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x00000010ff2f7819ULL, 0x000fc4000001162fULL, 0x00000010ff2d7819ULL, 0x000fe4000001162dULL,
0x00000010ff2a7819ULL, 0x000fe2000001166bULL, 0x000000282010723cULL, 0x000fe20000041810ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff9a7819ULL, 0x000fc4000001169aULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff857819ULL, 0x000fe40000011687ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff6b7819ULL, 0x000fe40000011680ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff297819ULL, 0x000fe40000011668ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff317819ULL, 0x000fc40000011631ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff307819ULL, 0x000fe40000011630ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff2e7819ULL, 0x000fe4000001162eULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x000010542d2f7816ULL, 0x000fc4000000002fULL,
0x00000010ff2c7819ULL, 0x000fe4000001162cULL, 0x00000010ff327819ULL, 0x000fe40000011632ULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x00000010ff2d7819ULL, 0x000fe40000011633ULL,
0x0000105489747816ULL, 0x000fe40000000074ULL, 0x000010549a757816ULL, 0x000fc40000000076ULL,
0x000010546f847816ULL, 0x000fe40000000084ULL, 0x000010546e857816ULL, 0x000fe40000000085ULL,
0x000010546a6a7816ULL, 0x000fe20000000082ULL, 0x000000742008723cULL, 0x000fe20000041808ULL,
0x000010542a6b7816ULL, 0x000fe4000000006bULL, 0x0000105481287816ULL, 0x000fe40000000069ULL,
0x000010547c297816ULL, 0x000fc40000000029ULL, 0x00001054317e7816ULL, 0x000fe2000000007eULL,
0x00000084200c723cULL, 0x040fe2000004180cULL, 0x00001054307f7816ULL, 0x000fe40000000037ULL,
0x00001054672e7816ULL, 0x000fe4000000002eULL, 0x000010542c2c7816ULL, 0x000fe40000000032ULL,
0x00001054002d7816ULL, 0x000fe2000000002dULL, 0x0000006a2004723cULL, 0x040ff00000041804ULL,
0x000000282014723cULL, 0x040ff00000041814ULL, 0x0000007e2018723cULL, 0x040ff00000041818ULL,
0x0000002e201c723cULL, 0x040ff0000004181cULL, 0x0000002c2020723cULL, 0x000fe20000041824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff247f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008038007811ULL, 0x000fe200078e40ffULL, 0x01069000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000003900720cULL, 0x000fda0003f24070ULL, 0x0000839000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x006fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff2f7819ULL, 0x000fe4000001163cULL, 0x000000203b277811ULL, 0x000fe400078e38ffULL,
0x000000a038247811ULL, 0x000fe400078e40ffULL, 0x0000002f27007210ULL, 0x000fe40007ffe03dULL,
0x0000002439257217ULL, 0x000fe40007800000ULL, 0x0000000064007210ULL, 0x000fc40007f3e0ffULL,
0x000000022f327810ULL, 0x000fe20007ffe0ffULL, 0x0000000125267824ULL, 0x000fe200078e0a24ULL,
0x000000062f307810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e00002d7a11ULL, 0x040fe400078240ffULL, 0x0000003227257210ULL, 0x000fe40007ffe03dULL,
0x00005f00002e7a11ULL, 0x000fe400008f442eULL, 0x000000042f317810ULL, 0x000fc40007ffe0ffULL,
0x0000003027007210ULL, 0x140fe40007ffe03dULL, 0x00000025642c7210ULL, 0x040fe40007f3e0ffULL,
0x0000003127247210ULL, 0x000fe40007ffe03dULL, 0x00000000642b7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x0000002026267807ULL, 0x000fe40000000000ULL,
0x0000002464297210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x000000263d267217ULL, 0x000fc40007800000ULL, 0x00005e002c277a11ULL, 0x040fe200078240ffULL,
0x000000ffff257224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe400078640ffULL,
0x00005f002c2c7a11ULL, 0x000fe200008f4400ULL, 0x0000000126007824ULL, 0x000fe200078e0a3dULL,
0x00005e0029287a11ULL, 0x000fe400078440ffULL, 0x00005f002b2b7a11ULL, 0x000fe400018f4424ULL,
0x000000452d247210ULL, 0x000fc40007f7e0ffULL, 0x0000004527267210ULL, 0x080fe40007f9e0ffULL,
0x00005f0029297a11ULL, 0x000fe200010f4425ULL, 0x000000ffff257224ULL, 0x000fe200018e062eULL,
0x000000002f00720cULL, 0x080fe20003f46070ULL, 0x000000ffff277224ULL, 0x000fe200020e062cULL,
0x0000004528287210ULL, 0x000fe40007fbe0ffULL, 0x000000003200720cULL, 0x080fe40003f26070ULL,
0x000000003100720cULL, 0x080fe20003f66070ULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x000000003000720cULL, 0x000fc40003f86070ULL, 0x000000452a2a7210ULL, 0x000fc60007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000245f7faeULL, 0x0003e4000d101c46ULL,
0x000000ffff2b7224ULL, 0x000fe400028e062bULL, 0x00000000265e7faeULL, 0x0003e8000c901c46ULL,
0x00000000285d7faeULL, 0x0003e8000d901c46ULL, 0x000000002a5c7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff367f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010648003d247f8cULL, 0x002fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc60007844866ULL,
0x01064c003d267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x01064c003d267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010100005b267984ULL, 0x000e680000000800ULL, 0x010300005b277984ULL, 0x0007220000000800ULL,
0x0000003e2600720bULL, 0x002fe20003f3d000ULL, 0x000112e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00287812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000023a00780cULL, 0x000fe40003f65270ULL,
0x0000003e2600720bULL, 0x000fe20003f34000ULL, 0x000112a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x000000263e247209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x800000243e257221ULL, 0x000fe20000010000ULL,
0x010500245b00b388ULL, 0x0003e20000000800ULL, 0x0000000028ff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fca000001163cULL,
0x0000002500257308ULL, 0x000ee40000000800ULL, 0x000000253f3f7220ULL, 0x008fe20000410000ULL,
0x000112327f007947ULL, 0x000fea000b800000ULL, 0x00001f0025007589ULL, 0x0022e400000e0000ULL,
0x0000000008087220ULL, 0x08cfe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000004047220ULL, 0x080fe20000410000ULL, 0x0000000005057220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x000fe20000410000ULL,
0x000111827f007947ULL, 0x000fea000b800000ULL, 0x00001f4625007589ULL, 0x0004e400000e0000ULL,
0x000000263e3e7209ULL, 0x000fe20007810000ULL, 0x000000000a0a7220ULL, 0x08cfe20000410000ULL,
0x00000001ff2c7807ULL, 0x000fe20000800000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x8000003e26261221ULL, 0x000fe20000010000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL,
0x0000000006067220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000002600431308ULL, 0x000ea20000000800ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x000fe20000410000ULL, 0x0000002743271220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003f273f7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc40007824866ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000240000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff247984ULL, 0x000ee40000000800ULL, 0x8000000024ff7812ULL, 0x008fe40007824866ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000043ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff2b7819ULL, 0x000fc4000001163cULL, 0x00005410002a7816ULL, 0x000fe20000000000ULL,
0x00010f327f007947ULL, 0x000fea000b800000ULL, 0x00001f2b2a357589ULL, 0x00072400000e0000ULL,
0x00010f727f007947ULL, 0x000fea000b800000ULL, 0x00001f462a667589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x008fe200078e0047ULL,
0x0000a32000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0001195000007944ULL, 0x016fea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x008fe200078e0048ULL,
0x0000a38000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x000118f000007944ULL, 0x016fea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005924783bULL, 0x002e620000004200ULL,
0x000099102c007816ULL, 0x004fc600000000ffULL, 0x000000005828783bULL, 0x008ea20000004200ULL,
0x000000ff0000720cULL, 0x000fc60003f25270ULL, 0x00000000572c783bULL, 0x000ee80000004200ULL,
0x000000005630783bULL, 0x000f620000004200ULL, 0x00000010ff917819ULL, 0x102fe40000011627ULL,
0x000000ff27727812ULL, 0x040fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fe40000011627ULL,
0x0000ffff27a37812ULL, 0x000fc400078ec0ffULL, 0x00000018ff277819ULL, 0x004fe40000011628ULL,
0x00000010ff677819ULL, 0x000fe40000011624ULL, 0x000000ff2a777812ULL, 0x000fe400078ec0ffULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000027ff7b7230ULL, 0x000fe20000004100ULL,
0x00000018ff8b7819ULL, 0x008fc4000001162cULL, 0x0000ffff24a07812ULL, 0x000fe200078ec0ffULL,
0x20000077ff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff2c8e7812ULL, 0x000fe400078ec0ffULL,
0x00000067ff27723eULL, 0x000fe400020006ffULL, 0x00000010ff957819ULL, 0x000fe40000011628ULL,
0x000000ff28737812ULL, 0x040fe400078ec0ffULL, 0x0000ffff28a47812ULL, 0x000fc400078ec0ffULL,
0x0000ffff25a17812ULL, 0x000fe400078ec0ffULL, 0x00000010ff827819ULL, 0x100fe4000001162eULL,
0x000000ff2e947812ULL, 0x040fe400078ec0ffULL, 0x00000018ff937819ULL, 0x000fe4000001162eULL,
0x0000ffff2e287812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2e7819ULL, 0x020fc40000011631ULL,
0x000000ff319b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff9a7819ULL, 0x000fe40000011631ULL,
0x0000ffff316f7812ULL, 0x000fe400078ec0ffULL, 0x0000008bff77723eULL, 0x000fe400020006ffULL,
0x00000018ff787819ULL, 0x000fe4000001162bULL, 0x0000008eff31723eULL, 0x000fe200020006ffULL,
0x20000027ff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff8b7819ULL, 0x000fe200000116a0ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000018ff907819ULL, 0x000fe2000001162dULL,
0x20000031ff317230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fc40000011626ULL,
0x00000008ff277819ULL, 0x000fe400000116a1ULL, 0x00000010ff707819ULL, 0x100fe40000011632ULL,
0x000000ff329d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff9c7819ULL, 0x000fe40000011632ULL,
0x0000ffff326b7812ULL, 0x000fe400078ec0ffULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x000000ff29757812ULL, 0x000fe400078ec0ffULL, 0x00000078ff32723eULL, 0x000fe200020006ffULL,
0x20000073ff7d7230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000090ff78723eULL, 0x000fe200020006ffULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x000000ff8f907812ULL, 0x000fe200078ec0ffULL, 0x2000008bff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fc400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe40000011625ULL,
0x00000018ff007819ULL, 0x000fe40000011624ULL, 0x0000ffff26a27812ULL, 0x000fe400078ec0ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000093ff73723eULL, 0x000fe400020006ffULL,
0x000000ff24687812ULL, 0x000fe200078ec0ffULL, 0x20000075ff7e7230ULL, 0x000fe20000004100ULL,
0x00000018ff747819ULL, 0x000fe20000011629ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff2d927812ULL, 0x000fc400078ec0ffULL, 0x00000090ff8b723eULL, 0x000fe400020006ffULL,
0x00000091ff93723eULL, 0x000fe200020006ffULL, 0x20000027ff917230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe4000001162bULL, 0x000000ff2b797812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2b8c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff967819ULL, 0x000fe40000011629ULL, 0x00000000ff2b723eULL, 0x000fe400020006ffULL,
0x00000008ff277819ULL, 0x000fe400000116a2ULL, 0x00000010ff6c7819ULL, 0x100fe20000011633ULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x000000ff339f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff9e7819ULL, 0x000fc40000011633ULL, 0x0000ffff33007812ULL, 0x000fe400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe4000001162aULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000092ff33723eULL, 0x000fe200020006ffULL, 0x2000008bff927230ULL, 0x000fe20000004100ULL,
0x00000094ff75723eULL, 0x000fe200020006ffULL, 0x20000093ff947230ULL, 0x000fe20000004100ULL,
0x000000ff256a7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff7c7230ULL, 0x000fe20000004100ULL,
0x00000018ff697819ULL, 0x000fe20000011625ULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x000000ff266e7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000018ff6d7819ULL, 0x000fc40000011626ULL, 0x000000ff2f987812ULL, 0x000fe400078ec0ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000ffff29267812ULL, 0x000fe400078ec0ffULL,
0x00000010ff257819ULL, 0x000fe2000001162aULL, 0x2000008dff907230ULL, 0x000fe20000004100ULL,
0x0000ffff2a8a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fc4000001162fULL,
0x00000008ff8b7819ULL, 0x000fe400000116a3ULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x000000ff96937812ULL, 0x000fe400078ec0ffULL, 0x00000010ff297819ULL, 0x000fe4000001162fULL,
0x0000ffff2f2a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff95957812ULL, 0x000fc400078ec0ffULL,
0x00000008ff967819ULL, 0x000fe400000116a4ULL, 0x00000076ff2f723eULL, 0x000fe400020006ffULL,
0x00000098ff76723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x00000097ff74723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x2000006eff837230ULL, 0x000fe20000004100ULL, 0x00000093ff98723eULL, 0x000fe200020006ffULL,
0x20000027ff937230ULL, 0x000fe20000004100ULL, 0x00000095ff8d723eULL, 0x000fe200020006ffULL,
0x2000008bff957230ULL, 0x000fe20000004100ULL, 0x00000096ff97723eULL, 0x000fe200020006ffULL,
0x20000098ff987230ULL, 0x000fe20000004100ULL, 0x0000b00055277811ULL, 0x000fe200078e20ffULL,
0x2000008dff967230ULL, 0x000fe20000004100ULL, 0x0000009aff6e723eULL, 0x000fe200020006ffULL,
0x20000097ff8b7230ULL, 0x000fe20000004100ULL, 0x00000008ff8d7819ULL, 0x000fe20000011626ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000000ff25977812ULL, 0x000fe200078ec0ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff249a7812ULL, 0x000fc400078ec0ffULL,
0x000000002724783bULL, 0x000e620000000200ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff887819ULL, 0x000fe2000001162cULL,
0x20000072ff847230ULL, 0x000fe20000004100ULL, 0x000000ff30997812ULL, 0x000fe200078ec0ffULL,
0x20000071ff817230ULL, 0x000fe20000004100ULL, 0x0000ffff2c857812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fc4000001168aULL, 0x0000009bff72723eULL, 0x000fe400020006ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff897819ULL, 0x000fe2000001162dULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000ffff2d867812ULL, 0x000fe400078ec0ffULL,
0x00000099ff71723eULL, 0x000fe400020006ffULL, 0x00000008ff9b7819ULL, 0x000fc4000001168cULL,
0x00000068ff2d723eULL, 0x000fe200020006ffULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000097ff99723eULL, 0x000fe400020006ffULL, 0x00000008ff857819ULL, 0x000fe20000011685ULL,
0x2000002dff2d7230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000099ff8c7230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000006aff877230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x2000008dff977230ULL, 0x000fe20000004100ULL,
0x0000009bff9b723eULL, 0x000fe200020006ffULL, 0x2000008aff997230ULL, 0x000fe20000004100ULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000088ff8a7230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x0000003524249231ULL, 0x092fe200003400ffULL,
0x00000069ff2c723eULL, 0x000fe200020006ffULL, 0x0000003526269231ULL, 0x000fe200003400ffULL,
0x000000ff29297812ULL, 0x000fe200078ec0ffULL, 0x0000006625259231ULL, 0x080fe200003400ffULL,
0x000000ff898d7812ULL, 0x000fe200078ec0ffULL, 0x2000009bff897230ULL, 0x000fe20000004100ULL,
0x00000086ff88723eULL, 0x000fe200020006ffULL, 0x20000085ff867230ULL, 0x000fe20000004100ULL,
0x00000008ff9b7819ULL, 0x000fe20000011628ULL, 0x2000002cff2c7230ULL, 0x000fe20000004100ULL,
0x00000029ff85723eULL, 0x000fe200020006ffULL, 0x0000006627279231ULL, 0x000fe200003400ffULL,
0x00000010ff287819ULL, 0x000fe2000001162dULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe2000001168eULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fc40000011687ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x000010548e287816ULL, 0x000fe40000000028ULL, 0x0000105490297816ULL, 0x000fe40000000029ULL,
0x00000008ff8e7819ULL, 0x000fe4000001162aULL, 0x00000010ff2a7819ULL, 0x000fe4000001162cULL,
0x00000010ff2b7819ULL, 0x000fc4000001162bULL, 0x00000010ff2c7819ULL, 0x000fe4000001168fULL,
0x00000010ff2d7819ULL, 0x000fe40000011691ULL, 0x000010542b2c7816ULL, 0x000fe4000000002cULL,
0x000010542a2d7816ULL, 0x000fe4000000002dULL, 0x000000282428723cULL, 0x000fe20000041808ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000010ff087819ULL, 0x000fe20000011683ULL,
0x0000002c240c723cULL, 0x000fe2000004180cULL, 0x00000010ff097819ULL, 0x000fe20000011684ULL,
0x2000006dff807230ULL, 0x000fe20000004100ULL, 0x0000105492087816ULL, 0x000fe40000000008ULL,
0x0000105494097816ULL, 0x000fe40000000009ULL, 0x0000b000540a7811ULL, 0x000fc400078e20ffULL,
0x00000010ff7f7819ULL, 0x000fe40000011630ULL, 0x00000010ff807819ULL, 0x000fe20000011680ULL,
0x000000082410723cULL, 0x000fe20000041810ULL, 0x000000000a08783bULL, 0x000e620000000200ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff2c7819ULL, 0x000fe40000011693ULL,
0x00000010ff2d7819ULL, 0x000fe40000011695ULL, 0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x0000009aff9a723eULL, 0x000fe400020006ffULL,
0x00001054802c7816ULL, 0x000fe2000000002cULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00001054812d7816ULL, 0x000fe2000000002dULL, 0x2000009aff9a7230ULL, 0x000fe20000004100ULL,
0x00000018ff687819ULL, 0x000fe40000011630ULL, 0x0000ffff30307812ULL, 0x000fc400078ec0ffULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x0000002c2404723cULL, 0x000fe20000041804ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff8b7819ULL, 0x000fe2000001168bULL,
0x2000007fff847230ULL, 0x000fe20000004100ULL, 0x00000008ff307819ULL, 0x000fe40000011630ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff2d7819ULL, 0x000fc40000011697ULL,
0x000000ff2e2e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x000fe4000001167eULL,
0x000010547b2c7816ULL, 0x000fe4000000008bULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x0000003508089231ULL, 0x082fe200003400ffULL, 0x00000010ff7e7819ULL, 0x000fe20000011696ULL,
0x000000350a0a9231ULL, 0x000fe200003400ffULL, 0x00000030ff30723eULL, 0x000fe200020006ffULL,
0x0000006609099231ULL, 0x080fe200003400ffULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x000000660b0b9231ULL, 0x000fe200003400ffULL, 0x00000010ff797819ULL, 0x000fc40000011679ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff7b7819ULL, 0x000fe4000001169aULL,
0x00000010ff987819ULL, 0x000fe40000011698ULL, 0x000010547c2d7816ULL, 0x000fe4000000002dULL,
0x0000002eff2e723eULL, 0x000fe400020006ffULL, 0x000010547e7e7816ULL, 0x000fe2000000007dULL,
0x20000030ff7d7230ULL, 0x000fe20000004100ULL, 0x000010548c7a7816ULL, 0x000fe2000000007aULL,
0x2000002eff807230ULL, 0x000fe20000004100ULL, 0x000010547b7b7816ULL, 0x000fc40000000079ULL,
0x00001054987f7816ULL, 0x000fe4000000007fULL, 0x00000010ff307819ULL, 0x000fe4000001162fULL,
0x00000010ff997819ULL, 0x000fe20000011699ULL, 0x0000002c242c723cULL, 0x000fe20000041818ULL,
0x00000010ff797819ULL, 0x000fe40000011633ULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff777819ULL, 0x000fc40000011677ULL, 0x0000105430187816ULL, 0x000fe20000000099ULL,
0x0000007e2414723cULL, 0x040fe20000041814ULL, 0x00000010ff1a7819ULL, 0x000fe40000011632ULL,
0x00000010ff1b7819ULL, 0x000fe40000011631ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff867819ULL, 0x000fe20000011686ULL, 0x0000007a2430723cULL, 0x000fe2000004181cULL,
0x00000010ff197819ULL, 0x000fc40000011689ULL, 0x0000009bff87723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000010ff1d7819ULL, 0x000fe20000011688ULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000008eff837230ULL, 0x000fe20000004100ULL, 0x00001054771c7816ULL, 0x000fe40000000086ULL,
0x00001054781d7816ULL, 0x000fe2000000001dULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x000010541a197816ULL, 0x000fc40000000019ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x0000001c081c723cULL, 0x000fe2000004180cULL,
0x000000ff70707812ULL, 0x000fe200078ec0ffULL, 0x20000068ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff737819ULL, 0x000fe20000011673ULL, 0x000000182424723cULL, 0x000fe20000041820ULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff0d7819ULL, 0x000fe40000011683ULL, 0x00000008ff007819ULL, 0x000fe40000011600ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff217819ULL, 0x000fe40000011676ULL,
0x00000010ff827819ULL, 0x000fc40000011682ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff0f7819ULL, 0x000fe40000011672ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x0000009dff69723eULL, 0x000fc400020006ffULL, 0x0000009fff6a723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000009cff68723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000009eff9e723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00001054730c7816ULL, 0x000fe20000000087ULL, 0x2000009eff677230ULL, 0x000fe20000004100ULL,
0x00001054740d7816ULL, 0x000fe2000000000dULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000000ff00723eULL, 0x000fc400020006ffULL, 0x0000105482207816ULL, 0x000fe40000000075ULL,
0x0000105485217816ULL, 0x000fe20000000021ULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x00001054840e7816ULL, 0x000fe20000000071ULL, 0x0000000c0804723cULL, 0x000fe20000041804ULL,
0x00001054800f7816ULL, 0x000fe4000000000fULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff8d7819ULL, 0x000fc4000001168dULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x000000200820723cULL, 0x040fe20000041810ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff117819ULL, 0x000fe2000001166fULL, 0x0000000e080c723cULL, 0x000fe20000041814ULL,
0x00000010ff707819ULL, 0x000fc40000011670ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff157819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff007819ULL, 0x000fc40000011600ULL, 0x000010548a1a7816ULL, 0x000fe4000000001bULL,
0x000010548d1b7816ULL, 0x000fe40000000079ULL, 0x000010546d107816ULL, 0x000fe4000000007dULL,
0x000010546e117816ULL, 0x000fe40000000011ULL, 0x0000105470147816ULL, 0x000fe20000000069ULL,
0x0000001a0818723cULL, 0x000fe20000041828ULL, 0x000010546c157816ULL, 0x000fc40000000015ULL,
0x0000105468687816ULL, 0x000fe4000000006bULL, 0x0000105467697816ULL, 0x000fc60000000000ULL,
0x000000100810723cULL, 0x040ff0000004182cULL, 0x000000140814723cULL, 0x040ff00000041830ULL,
0x000000680808723cULL, 0x000fe20000041824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff247f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fc40007844825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000403b287811ULL, 0x000fe400078e38ffULL,
0x000000c038007811ULL, 0x000fe400078e40ffULL, 0x00000004ff2f7819ULL, 0x000fe2000001163cULL,
0x00000001612c7824ULL, 0x100fe200078e0228ULL, 0x0000000039247217ULL, 0x000fe20007800000ULL,
0x00000001632e7824ULL, 0x100fe200078e0228ULL, 0x000000022f307810ULL, 0x000fe20007ffe0ffULL,
0x00000001602b7824ULL, 0x000fe200078e0228ULL, 0x000000642c2c7210ULL, 0x080fe20007f7e0ffULL,
0x0000000124247824ULL, 0x000fe200078e0a00ULL, 0x000000642e2e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000134297824ULL, 0x000fc400078e0228ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x00005e002c277a11ULL, 0x000fe200078640ffULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x00005e002e2d7a11ULL, 0x000fe400078440ffULL, 0x00005f002c2c7a11ULL, 0x000fe400018f4425ULL,
0x000000642b2b7210ULL, 0x080fe40007f7e0ffULL, 0x0000002024247807ULL, 0x000fe40000000000ULL,
0x00005f002e2e7a11ULL, 0x000fe200010f4426ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x0000006429297210ULL, 0x000fc40007f5e0ffULL, 0x000000243d247217ULL, 0x000fe40007800000ULL,
0x00005e002b2a7a11ULL, 0x000fe200078640ffULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078440ffULL, 0x0000000124007824ULL, 0x000fe200078e0a3dULL,
0x00005f002b2b7a11ULL, 0x000fe400018f4425ULL, 0x000000452d247210ULL, 0x000fe40007f7e0ffULL,
0x00005f0029297a11ULL, 0x000fc400010f4426ULL, 0x0000004527267210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff257224ULL, 0x000fe200018e062eULL, 0x0000004528287210ULL, 0x000fe40007fbe0ffULL,
0x000000042f2d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe200020e062cULL,
0x000000002f00720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x000000062f2f7810ULL, 0x000fe40007ffe0ffULL, 0x000000003000720cULL, 0x000fc40003f46070ULL,
0x000000002d00720cULL, 0x080fe40003f86070ULL, 0x000000002f00720cULL, 0x000fe40003fa6070ULL,
0x000000452a2a7210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024537faeULL, 0x0003e4000d901c46ULL, 0x000000ffff2b7224ULL, 0x000fe400030e062bULL,
0x0000000026527faeULL, 0x0003e8000d101c46ULL, 0x0000000028517faeULL, 0x0003e8000e101c46ULL,
0x000000002a507faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff667f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007844837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff667224ULL, 0x000fe200078e0067ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007844837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0106b400ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007844837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000043ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff2b7819ULL, 0x002fe4000001163cULL, 0x00005410002a7816ULL, 0x000fe20000000000ULL,
0x0000f2427f007947ULL, 0x000fea000b800000ULL, 0x00001f2b2a677589ULL, 0x0002a400000e0000ULL,
0x0000f2827f007947ULL, 0x000fea000b800000ULL, 0x00001f462a687589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e0047ULL,
0x0000c0e000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000fb9000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e0048ULL,
0x0000c14000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000fb3000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004f24783bULL, 0x000f680000004200ULL,
0x000000004d2c783bULL, 0x000e680000004200ULL, 0x000000004e28783bULL, 0x00ae680000004200ULL,
0x000000004c30783bULL, 0x000ee20000004200ULL, 0x00000010ff697819ULL, 0x020fc40000011624ULL,
0x000000ff24347812ULL, 0x040fe400078ec0ffULL, 0x00000018ff007819ULL, 0x004fe40000011624ULL,
0x0000ffff249c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff247819ULL, 0x100fe40000011625ULL,
0x00000010ff8f7819ULL, 0x000fe40000011625ULL, 0x000000ff25357812ULL, 0x000fc400078ec0ffULL,
0x0000ffff259d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff257819ULL, 0x000fe40000011626ULL,
0x00000018ff787819ULL, 0x000fe4000001162dULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x000000ff2e8d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe200078ec0ffULL,
0x20000024ff817230ULL, 0x000fe20000004100ULL, 0x000000ff2b757812ULL, 0x002fc400078ec0ffULL,
0x00000010ff907819ULL, 0x000fe40000011626ULL, 0x000000ff26367812ULL, 0x040fe400078ec0ffULL,
0x0000ffff269e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001162eULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fc400020006ffULL,
0x00000010ff267819ULL, 0x100fe40000011627ULL, 0x000000ff276a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff377819ULL, 0x000fe40000011627ULL, 0x0000ffff279f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fe4000001162cULL, 0x000000ff2c777812ULL, 0x000fc400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe4000001162cULL, 0x0000ffff2c827812ULL, 0x000fe400078ec0ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000018ff277819ULL, 0x000fe40000011628ULL,
0x00000010ff2c7819ULL, 0x008fe40000011631ULL, 0x000000ff31977812ULL, 0x000fc400078ec0ffULL,
0x00000018ff967819ULL, 0x000fe40000011631ULL, 0x0000ffff31717812ULL, 0x000fe400078ec0ffULL,
0x00000069ff24723eULL, 0x000fe400020006ffULL, 0x00000010ff947819ULL, 0x100fe40000011629ULL,
0x000000ff296f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fc40000011629ULL,
0x0000ffff298c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe4000001162aULL,
0x000000ff2a737812ULL, 0x040fe400078ec0ffULL, 0x00000018ff707819ULL, 0x000fe4000001162aULL,
0x0000ffff2a887812ULL, 0x000fe400078ec0ffULL, 0x00000075ff31723eULL, 0x000fc400020006ffULL,
0x00000010ff297819ULL, 0x100fe4000001162fULL, 0x000000ff2f917812ULL, 0x040fe200078ec0ffULL,
0x20000031ff317230ULL, 0x000fe20000004100ULL, 0x00000018ff8e7819ULL, 0x000fe4000001162fULL,
0x0000ffff2f2a7812ULL, 0x000fe200078ec0ffULL, 0x20000025ff2f7230ULL, 0x000fe20000004100ULL,
0x0000007aff75723eULL, 0x000fe200020006ffULL, 0x20000078ff7a7230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x2000008dff787230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fe200020006ffULL, 0x20000024ff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff257819ULL, 0x000fe2000001169cULL, 0x20000036ff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff2d797812ULL, 0x000fe200078ec0ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fc400020006ffULL, 0x00000008ff247819ULL, 0x000fe4000001169dULL,
0x000000ff26267812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe4000001162dULL,
0x0000ffff2d847812ULL, 0x000fe200078ec0ffULL, 0x20000027ff2d7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x00000079ff36723eULL, 0x000fe200020006ffULL,
0x20000076ff797230ULL, 0x000fe20000004100ULL, 0x000000ff90907812ULL, 0x000fc400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe200020006ffULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000026ff27723eULL, 0x000fe400020006ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000018ff937819ULL, 0x000fe40000011630ULL, 0x00000008ff267819ULL, 0x000fe2000001169eULL,
0x20000034ff837230ULL, 0x000fe20000004100ULL, 0x0000008eff76723eULL, 0x000fe200020006ffULL,
0x20000025ff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fc40000011628ULL,
0x00000010ff727819ULL, 0x100fe20000011632ULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x000000ff32997812ULL, 0x040fe400078ec0ffULL, 0x00000018ff987819ULL, 0x000fe40000011632ULL,
0x0000ffff326d7812ULL, 0x000fe400078ec0ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000070ff32723eULL, 0x000fc400020006ffULL, 0x00000090ff25723eULL, 0x000fe200020006ffULL,
0x20000024ff907230ULL, 0x000fe20000004100ULL, 0x00000093ff70723eULL, 0x000fe200020006ffULL,
0x20000027ff937230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x2000006fff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe2000001169fULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x000000ff94947812ULL, 0x000fe200078ec0ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000ffff28a07812ULL, 0x000fc400078ec0ffULL,
0x00000077ff34723eULL, 0x000fe400020006ffULL, 0x000000ff92277812ULL, 0x000fe200078ec0ffULL,
0x20000026ff927230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000091ff77723eULL, 0x000fe200020006ffULL,
0x20000025ff917230ULL, 0x000fe20000004100ULL, 0x00000096ff6f723eULL, 0x000fe200020006ffULL,
0x20000035ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x100fe2000001162bULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000018ff747819ULL, 0x000fe2000001162bULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x0000ffff2b897812ULL, 0x000fc400078ec0ffULL,
0x00000024ff25723eULL, 0x000fe400020006ffULL, 0x00000094ff96723eULL, 0x000fe400020006ffULL,
0x00000000ff2b723eULL, 0x000fe200020006ffULL, 0x20000025ff947230ULL, 0x000fe20000004100ULL,
0x000000ff30957812ULL, 0x000fe400078ec0ffULL, 0x00000027ff27723eULL, 0x000fe200020006ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x0000b0004b247811ULL, 0x000fc400078e20ffULL,
0x00000008ff267819ULL, 0x000fe400000116a0ULL, 0x00000010ff6b7819ULL, 0x100fe40000011633ULL,
0x000000ff339b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff9a7819ULL, 0x000fe40000011633ULL,
0x0000ffff33007812ULL, 0x000fe400078ec0ffULL, 0x00000073ff33723eULL, 0x000fc400020006ffULL,
0x00000074ff35723eULL, 0x000fe400020006ffULL, 0x00000097ff73723eULL, 0x000fe200020006ffULL,
0x20000096ff977230ULL, 0x000fe20000004100ULL, 0x00000095ff74723eULL, 0x000fe200020006ffULL,
0x20000027ff957230ULL, 0x000fe20000004100ULL, 0x00000026ff96723eULL, 0x000fe200020006ffULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x000000ff286c7812ULL, 0x000fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011688ULL, 0x2000006aff807230ULL, 0x000fe20000004100ULL,
0x000000ff86867812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fc40000011689ULL, 0x00000008ff827819ULL, 0x000fe40000011682ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x2000006cff7b7230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000098ff6a723eULL, 0x000fc400020006ffULL, 0x00000089ff98723eULL, 0x000fe200020006ffULL,
0x20000088ff897230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe20000011684ULL,
0x20000086ff887230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000ffff2e287812ULL, 0x000fe400078ec0ffULL,
0x000000ff29297812ULL, 0x000fe400078ec0ffULL, 0x00000099ff6c723eULL, 0x000fc400020006ffULL,
0x000000ff87997812ULL, 0x000fe200078ec0ffULL, 0x20000098ff877230ULL, 0x000fe20000004100ULL,
0x00000084ff86723eULL, 0x000fe200020006ffULL, 0x20000082ff847230ULL, 0x000fe20000004100ULL,
0x00000029ff82723eULL, 0x000fe200020006ffULL, 0x0000006724249231ULL, 0x082fe200003400ffULL,
0x00000008ff987819ULL, 0x000fe20000011628ULL, 0x0000006726269231ULL, 0x000fe200003400ffULL,
0x00000010ff287819ULL, 0x000fe20000011683ULL, 0x0000006825259231ULL, 0x090fe200003400ffULL,
0x00000010ff297819ULL, 0x000fe20000011685ULL, 0x0000006827279231ULL, 0x000fe200003400ffULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fe2000001168fULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x000010548d287816ULL, 0x000fe20000000028ULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x000010548f297816ULL, 0x000fc40000000029ULL, 0x00000008ff857819ULL, 0x000fe4000001162aULL,
0x00000010ff2b7819ULL, 0x000fe4000001162bULL, 0x00000010ff2a7819ULL, 0x000fe2000001168eULL,
0x000000282418723cULL, 0x000fe20000041818ULL, 0x00000010ff837819ULL, 0x000fe40000011681ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff917819ULL, 0x000fc40000011691ULL,
0x00000010ff287819ULL, 0x000fe4000001167fULL, 0x00000010ff297819ULL, 0x000fe40000011680ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x000010542b2a7816ULL, 0x000fe4000000002aULL,
0x00001054832b7816ULL, 0x000fe40000000090ULL, 0x0000105491287816ULL, 0x000fc40000000028ULL,
0x0000105493297816ULL, 0x000fe40000000029ULL, 0x00000010ff7e7819ULL, 0x000fe2000001162eULL,
0x0000002a241c723cULL, 0x040fe2000004181cULL, 0x00000010ff2e7819ULL, 0x000fe40000011630ULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x0000b0004a807811ULL, 0x000fe400078e20ffULL,
0x00000008ff8c7819ULL, 0x000fe2000001168cULL, 0x000000282428723cULL, 0x000fe20000041820ULL,
0x000000ff2e2e7812ULL, 0x000fe200078ec0ffULL, 0x20000037ff7d7230ULL, 0x000fe20000004100ULL,
0x000000008020783bULL, 0x000e620000000200ULL, 0x0000006eff37723eULL, 0x000fc400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000002eff83723eULL, 0x000fe200020006ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000010ff2f7819ULL, 0x000fe2000001162fULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff2e7819ULL, 0x000fe20000011692ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x000010542f2e7816ULL, 0x000fe4000000002eULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x000010547d2f7816ULL, 0x000fe40000000094ULL, 0x0000ffff30307812ULL, 0x000fe200078ec0ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7d7819ULL, 0x000fe2000001167cULL, 0x0000002e2404723cULL, 0x000fe20000041804ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7c7819ULL, 0x000fe40000011695ULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x000000ff2c2c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2d7819ULL, 0x000fc4000001162dULL, 0x00000010ff377819ULL, 0x000fe20000011637ULL,
0x0000006720209231ULL, 0x082fe200003400ffULL, 0x00000010ff967819ULL, 0x000fe20000011696ULL,
0x0000006722229231ULL, 0x000fe200003400ffULL, 0x00000010ff8c7819ULL, 0x000fe2000001168cULL,
0x0000006821219231ULL, 0x080fe200003400ffULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x0000006823239231ULL, 0x000fe200003400ffULL, 0x00000008ff307819ULL, 0x000fe40000011630ULL,
0x000010547c7c7816ULL, 0x000fe2000000007bULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00001054977d7816ULL, 0x000fc4000000007dULL, 0x0000002cff2c723eULL, 0x000fe400020006ffULL,
0x000010542d967816ULL, 0x000fe40000000096ULL, 0x0000105437977816ULL, 0x000fe2000000008cULL,
0x2000002cff807230ULL, 0x000fe20000004100ULL, 0x00000030ff30723eULL, 0x000fe200020006ffULL,
0x0000007c242c723cULL, 0x000fe2000004180cULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff8b7819ULL, 0x000fe2000001168bULL, 0x20000030ff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x00000010ff0d7819ULL, 0x000fe40000011631ULL,
0x00000010ff0e7819ULL, 0x000fe40000011632ULL, 0x000010548b0c7816ULL, 0x000fe40000000033ULL,
0x000000962430723cULL, 0x000fe20000041810ULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff0f7819ULL, 0x000fe40000011687ULL, 0x00000099ff99723eULL, 0x000fc400020006ffULL,
0x00000010ff107819ULL, 0x000fe40000011635ULL, 0x000010548a0d7816ULL, 0x000fe2000000000dULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x000010540e0e7816ULL, 0x000fe40000000089ULL,
0x00001054100f7816ULL, 0x000fe4000000000fULL, 0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff117819ULL, 0x000fc40000011634ULL, 0x00000010ff897819ULL, 0x000fe40000011636ULL,
0x00000008ff717819ULL, 0x000fe20000011671ULL, 0x0000000c2434723cULL, 0x040fe20000041814ULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff007819ULL, 0x000fe20000011600ULL,
0x0000000e2424723cULL, 0x000fe20000041808ULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x00000010ff997819ULL, 0x000fe40000011699ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff0d7819ULL, 0x000fe40000011686ULL, 0x00000098ff98723eULL, 0x000fc400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x0000009bff6e723eULL, 0x000fe200020006ffULL,
0x20000098ff817230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000085ff7f7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000009aff9a723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x2000009aff697230ULL, 0x000fe20000004100ULL, 0x0000105488887816ULL, 0x000fe20000000011ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000105499897816ULL, 0x000fe20000000089ULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00001054790c7816ULL, 0x000fc40000000084ULL,
0x000010547a0d7816ULL, 0x000fe4000000000dULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x000000882008723cULL, 0x040fe20000041818ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff157819ULL, 0x000fe4000001167fULL,
0x00000010ff787819ULL, 0x000fe20000011678ULL, 0x0000000c200c723cULL, 0x000fe2000004181cULL,
0x00000010ff117819ULL, 0x000fc40000011677ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff177819ULL, 0x000fe40000011673ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff197819ULL, 0x000fe40000011671ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff1d7819ULL, 0x000fe4000001166eULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff007819ULL, 0x000fc40000011600ULL, 0x0000105475147816ULL, 0x000fe40000000081ULL,
0x0000105476157816ULL, 0x000fe40000000015ULL, 0x000010547e107816ULL, 0x000fe40000000078ULL,
0x0000105482117816ULL, 0x000fe40000000011ULL, 0x0000105483167816ULL, 0x000fe20000000074ULL,
0x000000142004723cULL, 0x000fe20000041804ULL, 0x0000105480177816ULL, 0x000fc40000000017ULL,
0x0000105470187816ULL, 0x000fe4000000007bULL, 0x000010546f197816ULL, 0x000fe40000000019ULL,
0x00001054721c7816ULL, 0x000fe2000000006cULL, 0x000000102010723cULL, 0x000fe20000041828ULL,
0x000010546b1d7816ULL, 0x000fe4000000001dULL, 0x000010546a6a7816ULL, 0x000fe4000000006dULL,
0x00001054696b7816ULL, 0x000fc60000000000ULL, 0x000000162014723cULL, 0x040ff0000004182cULL,
0x000000182018723cULL, 0x040ff00000041830ULL, 0x0000001c201c723cULL, 0x040ff00000041834ULL,
0x0000006a2020723cULL, 0x000fe20000041824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c038007811ULL, 0x000fe200078e40ffULL,
0x01069800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000003900720cULL, 0x000fda0003f24070ULL,
0x0000424000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x006fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000149447824ULL, 0x000fe400078e0262ULL,
0x00000002ff007424ULL, 0x000fe400078e00ffULL, 0x00000001ff247424ULL, 0x000fe200078e00ffULL,
0x0000000144257812ULL, 0x000fe200078ec0ffULL, 0xffffffffff657424ULL, 0x000fe400078e00ffULL,
0x0000030000007a24ULL, 0x000fe200078e0a24ULL, 0x000000012500780cULL, 0x000fc80003f25070ULL,
0x0000000100007807ULL, 0x000fca0004800000ULL, 0x0000000144447824ULL, 0x000fca00078e0200ULL,
0x000000034400720cULL, 0x000fe40003f26070ULL, 0x000000e038007811ULL, 0x000fd600078e40ffULL,
0x0000000144249824ULL, 0x000fe400078e0241ULL, 0x00000004ff259424ULL, 0x000fc800078e00ffULL,
0x0000600024249625ULL, 0x000fca00078e0025ULL, 0x0000000624659981ULL, 0x000362000c1e1900ULL,
0x000000043c2f7811ULL, 0x040fe400078fe0ffULL, 0x000000063c307811ULL, 0x000fe400078fe0ffULL,
0x00000004ff317819ULL, 0x000fe4000001163cULL, 0x000000603b257811ULL, 0x002fe400078e38ffULL,
0x0000000039247217ULL, 0x000fe40007800000ULL, 0x0000002f25297210ULL, 0x000fe20007ffe03dULL,
0x00000001612c7824ULL, 0x000fe200078e0225ULL, 0x00000030252b7210ULL, 0x000fe20007ffe03dULL,
0x0000000124247824ULL, 0x000fe200078e0a00ULL, 0x0000006429297210ULL, 0x080fe20007f7e0ffULL,
0x00000001632e7824ULL, 0x000fe200078e0225ULL, 0x000000642c2c7210ULL, 0x000fc40007f5e0ffULL,
0x0000002024247807ULL, 0x000fe20000000000ULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x000000642e2e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005e002c277a11ULL, 0x000fe400078440ffULL, 0x000000243d247217ULL, 0x000fe20007800000ULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005e002e2d7a11ULL, 0x000fe400078240ffULL,
0x000000642b2b7210ULL, 0x000fc40007f9e0ffULL, 0x00005f002c2c7a11ULL, 0x000fe200010f4400ULL,
0x0000000124007824ULL, 0x000fe200078e0a3dULL, 0x0000000231247810ULL, 0x000fe40007ffe0ffULL,
0x00005f002e2e7a11ULL, 0x000fe200008f4425ULL, 0x000000ffff257224ULL, 0x000fe200020e06ffULL,
0x00005e0029287a11ULL, 0x000fe400078040ffULL, 0x00005e002b2a7a11ULL, 0x000fe400078240ffULL,
0x000000002400720cULL, 0x000fc40003f46070ULL, 0x00005f0029297a11ULL, 0x000fe400000f4426ULL,
0x000000452d247210ULL, 0x080fe40007f9e0ffULL, 0x000000003100720cULL, 0x080fe40003f66070ULL,
0x0000004527267210ULL, 0x000fe40007fbe0ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4425ULL,
0x000000ffff257224ULL, 0x000fe200020e062eULL, 0x000000002f00720cULL, 0x080fe20003f26070ULL,
0x000000ffff277224ULL, 0x000fe200028e062cULL, 0x000000003000720cULL, 0x000fc40003f06070ULL,
0x0000004528287210ULL, 0x080fe40007f9e0ffULL, 0x000000452a2a7210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000245f7faeULL, 0x0003e4000d901c46ULL,
0x000000ffff297224ULL, 0x000fe400020e0629ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x00000000265e7faeULL, 0x0003e8000d101c46ULL, 0x00000000285d7faeULL, 0x0003e8000c901c46ULL,
0x000000002a5c7faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff2c7f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010668003d247f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007804866ULL, 0x01066c003d267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x01066c003d267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010180005b267984ULL, 0x000e680000000800ULL,
0x010380005b277984ULL, 0x0007220000000800ULL, 0x0000003e2600720bULL, 0x002fe20003f3d000ULL,
0x0000d3b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff00287812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000033a00780cULL, 0x000fe40003f45270ULL, 0x0000003e2600720bULL, 0x000fe20003f34000ULL,
0x0000d3727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x000000263e257209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fc600078e3cffULL,
0x800000253e247221ULL, 0x000fe20000010000ULL, 0x010580255b00a388ULL, 0x0003e20000000800ULL,
0x0000000028ff7212ULL, 0x000fe4000782c0ffULL, 0x3fb8aa3b24247820ULL, 0x000fe20000410000ULL,
0x00000002ff007819ULL, 0x000fca000001163cULL, 0x0000002400247308ULL, 0x000ee40000000800ULL,
0x000000243f3f7220ULL, 0x008fe20000410000ULL, 0x0000d3027f007947ULL, 0x000fea000b800000ULL,
0x00001f0024007589ULL, 0x0022e400000e0000ULL, 0x0000000008087220ULL, 0x08cfe20000410000ULL,
0x0000000009097220ULL, 0x080fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000d0d7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000004047220ULL, 0x080fe20000410000ULL,
0x0000000005057220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000020207220ULL, 0x080fe20000410000ULL,
0x0000000021217220ULL, 0x000fe20000410000ULL, 0x0000d2527f007947ULL, 0x000fea000b800000ULL,
0x00001f4624007589ULL, 0x0004e400000e0000ULL, 0x8000002526261221ULL, 0x100fe20000010000ULL,
0x00000001ff247807ULL, 0x006fe20000800000ULL, 0x000000000a0a7220ULL, 0x088fe20000410000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000002600431308ULL, 0x000e620000000800ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000006067220ULL, 0x080fe20000410000ULL,
0x0000000007077220ULL, 0x080fe20000410000ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x000fe20000410000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e0025ULL,
0x0000002743271220ULL, 0x012fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000003f273f7221ULL, 0x010fe20000010000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804866ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804866ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000043ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff2b7819ULL, 0x000fc4000001163cULL,
0x00005410002a7816ULL, 0x000fe20000000000ULL, 0x0000d0027f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a2e7589ULL, 0x0002e400000e0000ULL, 0x0000d0427f007947ULL, 0x000fea000b800000ULL,
0x00001f462a2f7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0047ULL, 0x0000e55000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000d72000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0048ULL, 0x0000e5b000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000d6c000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005930783bULL, 0x000f220000004200ULL, 0x0000991024007816ULL, 0x004fc400000000ffULL,
0x0000b80054547811ULL, 0x000fe200078e20ffULL, 0x000000005858783bULL, 0x000ea20000004200ULL,
0x000000ff0000720cULL, 0x000fc60003f05270ULL, 0x000000005728783bULL, 0x012e680000004200ULL,
0x000000005624783bULL, 0x000f220000004200ULL, 0x000000ff30347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x000fe40000011630ULL, 0x00000010ff857819ULL, 0x004fe4000001165aULL,
0x000000ff5a647812ULL, 0x000fc400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe4000001165aULL,
0x0000ffff5a907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x100fe4000001165bULL,
0x000000ff5b667812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001165bULL,
0x0000ffff5b917812ULL, 0x000fc400078ec0ffULL, 0x00000010ff787819ULL, 0x102fe40000011628ULL,
0x000000ff28677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011628ULL,
0x0000ffff28767812ULL, 0x000fe400078ec0ffULL, 0x000000ff29687812ULL, 0x000fe400078ec0ffULL,
0x00000018ff287819ULL, 0x000fc40000011629ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000010ff797819ULL, 0x000fe20000011629ULL,
0x20000068ff6b7230ULL, 0x000fe20000004100ULL, 0x0000ffff29777812ULL, 0x000fe200078ec0ffULL,
0x20000028ff687230ULL, 0x000fe20000004100ULL, 0x000000ff59627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff757819ULL, 0x000fc4000001162aULL, 0x000000ff2a7d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff297819ULL, 0x000fe4000001162aULL, 0x0000ffff2a6f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001162bULL, 0x00000010ff7b7819ULL, 0x000fe40000011632ULL,
0x000000ff325e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011632ULL,
0x0000ffff328c7812ULL, 0x000fe400078ec0ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000010ff7c7819ULL, 0x100fe40000011633ULL, 0x000000ff335f7812ULL, 0x000fe200078ec0ffULL,
0x20000034ff737230ULL, 0x000fe20000004100ULL, 0x00000018ff327819ULL, 0x000fc40000011633ULL,
0x0000ffff338d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c287812ULL, 0x000fe400078ec0ffULL,
0x00000018ff337819ULL, 0x000fe40000011658ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x00000010ff7a7819ULL, 0x000fc40000011631ULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe4000001162bULL,
0x000000ff2b7e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2b377812ULL, 0x000fe400078ec0ffULL,
0x00000033ff34723eULL, 0x000fe200020006ffULL, 0x20000062ff337230ULL, 0x000fe20000004100ULL,
0x0000ffff318b7812ULL, 0x000fe200078ec0ffULL, 0x2000002aff627230ULL, 0x000fe20000004100ULL,
0x00000018ff2b7819ULL, 0x010fe20000011624ULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x000000ff7a2a7812ULL, 0x000fe200078ec0ffULL, 0x20000028ff7a7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x20000063ff6d7230ULL, 0x000fe20000004100ULL,
0x00000008ff287819ULL, 0x000fe2000001168bULL, 0x20000029ff637230ULL, 0x000fe20000004100ULL,
0x00000018ff007819ULL, 0x000fe40000011630ULL, 0x0000ffff308a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff31307812ULL, 0x000fc400078ec0ffULL, 0x00000018ff357819ULL, 0x000fe40000011631ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x000fe40000011624ULL,
0x000000ff24807812ULL, 0x040fe200078ec0ffULL, 0x20000064ff6c7230ULL, 0x000fe20000004100ULL,
0x0000ffff24317812ULL, 0x000fe400078ec0ffULL, 0x0000005dff24723eULL, 0x000fe200020006ffULL,
0x2000002bff5d7230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fc400020006ffULL,
0x00000008ff297819ULL, 0x000fe2000001168aULL, 0x20000024ff247230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x000000ff7b2b7812ULL, 0x000fe400078ec0ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000002aff7b7230ULL, 0x000fe20000004100ULL,
0x0000007dff64723eULL, 0x000fe200020006ffULL, 0x20000028ff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL, 0x20000066ff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fe20000011658ULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fc400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000008ff287819ULL, 0x000fe4000001168cULL, 0x0000ffff588e7812ULL, 0x000fe400078ec0ffULL,
0x0000007cff2a723eULL, 0x000fe200020006ffULL, 0x20000029ff7c7230ULL, 0x000fe20000004100ULL,
0x00000000ff70723eULL, 0x000fe400020006ffULL, 0x00000010ff497819ULL, 0x000fc40000011627ULL,
0x000000ff27897812ULL, 0x040fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000018ff887819ULL, 0x000fe40000011627ULL, 0x0000ffff27007812ULL, 0x000fe400078ec0ffULL,
0x0000007eff66723eULL, 0x000fe200020006ffULL, 0x2000002bff7e7230ULL, 0x000fe20000004100ULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000005fff27723eULL, 0x000fc400020006ffULL,
0x00000010ff817819ULL, 0x000fe40000011659ULL, 0x00000080ff5f723eULL, 0x000fe200020006ffULL,
0x2000002aff807230ULL, 0x000fe20000004100ULL, 0x00000008ff297819ULL, 0x000fe2000001168dULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x00000008ff2b7819ULL, 0x000fe2000001168eULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe400020006ffULL,
0x000000ff58617812ULL, 0x000fc400078ec0ffULL, 0x0000007fff2a723eULL, 0x000fe200020006ffULL,
0x20000028ff7f7230ULL, 0x000fe20000004100ULL, 0x00000018ff587819ULL, 0x000fe20000011659ULL,
0x20000035ff727230ULL, 0x000fe20000004100ULL, 0x00000030ff74723eULL, 0x000fe400020006ffULL,
0x000000ff25837812ULL, 0x000fe400078ec0ffULL, 0x00000010ff307819ULL, 0x100fe20000011625ULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000018ff827819ULL, 0x000fc40000011625ULL,
0x0000ffff25577812ULL, 0x000fe400078ec0ffULL, 0x00000018ff847819ULL, 0x000fe40000011626ULL,
0x000000ff81817812ULL, 0x000fe400078ec0ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x0000b80055287811ULL, 0x000fc400078e20ffULL,
0x0000ffff598f7812ULL, 0x000fe400078ec0ffULL, 0x00000032ff25723eULL, 0x000fe400020006ffULL,
0x00000010ff597819ULL, 0x000fe40000011626ULL, 0x000000ff26877812ULL, 0x040fe200078ec0ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x0000ffff26567812ULL, 0x000fe400078ec0ffULL,
0x00000061ff32723eULL, 0x000fc400020006ffULL, 0x0000005eff26723eULL, 0x000fe400020006ffULL,
0x00000058ff35723eULL, 0x000fe200020006ffULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x00000083ff61723eULL, 0x000fe200020006ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x00000082ff5e723eULL, 0x000fe200020006ffULL, 0x2000002aff827230ULL, 0x000fe20000004100ULL,
0x00000084ff58723eULL, 0x000fe200020006ffULL, 0x2000002bff847230ULL, 0x000fe20000004100ULL,
0x00000081ff83723eULL, 0x000fe200020006ffULL, 0x20000029ff817230ULL, 0x000fe20000004100ULL,
0x00000008ff557819ULL, 0x000fe2000001168fULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000ff85857812ULL, 0x000fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x20000087ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff75757812ULL, 0x000fe200078ec0ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x000000ff86877812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fe200078ec0ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000085ff86723eULL, 0x000fe200020006ffULL, 0x20000055ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000075ff55723eULL, 0x000fe400020006ffULL,
0x00000071ff75723eULL, 0x000fe400020006ffULL, 0x00000008ff717819ULL, 0x000fe2000001166fULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x000010547a7a7816ULL, 0x000fe20000000073ULL,
0x20000075ff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fc40000011626ULL,
0x00000010ff277819ULL, 0x000fe40000011627ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000008ff737819ULL, 0x000fe40000011637ULL,
0x000000ff36367812ULL, 0x000fe400078ec0ffULL, 0x00000010ff377819ULL, 0x000fe20000011670ULL,
0x0000002e28288231ULL, 0x08afe200003400ffULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x0000002e2a2a8231ULL, 0x000fe200003400ffULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x0000002f29298231ULL, 0x080fe200003400ffULL, 0x000010547e267816ULL, 0x000fe20000000026ULL,
0x0000002f2b2b8231ULL, 0x000fe200003400ffULL, 0x0000105480277816ULL, 0x000fe20000000027ULL,
0x20000071ff707230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fc400020006ffULL,
0x00001054377c7816ULL, 0x000fe4000000007cULL, 0x00000010ff247819ULL, 0x000fe20000011624ULL,
0x20000036ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe20000011625ULL,
0x000000262810723cULL, 0x000fe20000041810ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff377819ULL, 0x000fe40000011681ULL, 0x0000105424367816ULL, 0x000fc4000000007fULL,
0x0000105425377816ULL, 0x000fe40000000037ULL, 0x000000005424783bULL, 0x000e620000000200ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000005aff6a7230ULL, 0x000fe20000004100ULL,
0x00000088ff5a723eULL, 0x000fe200020006ffULL, 0x20000067ff697230ULL, 0x000fe20000004100ULL,
0x00000087ff88723eULL, 0x000fe200020006ffULL, 0x2000005bff677230ULL, 0x000fe20000004100ULL,
0x00000089ff5b723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000008ff877819ULL, 0x000fe20000011690ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011691ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00001054727d7816ULL, 0x000fe2000000007dULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x000000ff30307812ULL, 0x000fe200078ec0ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000008ff317819ULL, 0x000fc40000011631ULL, 0x00000010ff327819ULL, 0x000fe20000011632ULL,
0x0000007c280c723cULL, 0x040fe2000004180cULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000008ff767819ULL, 0x000fe20000011676ULL, 0x0000002e24248231ULL, 0x082fe200003400ffULL,
0x00000008ff777819ULL, 0x000fe20000011677ULL, 0x0000002e26268231ULL, 0x000fe200003400ffULL,
0x00000030ff72723eULL, 0x000fe200020006ffULL, 0x0000002f25258231ULL, 0x080fe200003400ffULL,
0x00000031ff54723eULL, 0x000fe200020006ffULL, 0x0000002f27278231ULL, 0x000fe200003400ffULL,
0x0000105482827816ULL, 0x000fe20000000032ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000105483837816ULL, 0x000fe20000000033ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x000000362830723cULL, 0x000fe20000041804ULL, 0x00000010ff747819ULL, 0x000fc40000011674ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff347819ULL, 0x000fe40000011634ULL,
0x00000010ff357819ULL, 0x000fe40000011635ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff047819ULL, 0x000fe4000001166dULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff057819ULL, 0x000fe40000011689ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x000010547b7b7816ULL, 0x000fe20000000074ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000105434847816ULL, 0x000fe20000000084ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x0000105435857816ULL, 0x000fc40000000085ULL,
0x00001054866c7816ULL, 0x000fe2000000006cULL, 0x0000007a2808723cULL, 0x040fe20000041808ULL,
0x00001054886d7816ULL, 0x000fe4000000006eULL, 0x0000105404047816ULL, 0x000fe40000000087ULL,
0x000010546a057816ULL, 0x000fe40000000005ULL, 0x00000008ff577819ULL, 0x000fe20000011657ULL,
0x000000822834723cULL, 0x000fe20000041814ULL, 0x000000ff78787812ULL, 0x000fc400078ec0ffULL,
0x000000ff79797812ULL, 0x000fe400078ec0ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x000000ff49497812ULL, 0x000fe200078ec0ffULL, 0x000000842818723cULL, 0x000fe20000041818ULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000008ff007819ULL, 0x000fe40000011600ULL,
0x00000010ff677819ULL, 0x000fc40000011667ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x0000006c281c723cULL, 0x040fe2000004181cULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff157819ULL, 0x000fe40000011666ULL,
0x00000010ff557819ULL, 0x000fe20000011655ULL, 0x000000042820723cULL, 0x000fe20000041820ULL,
0x00000010ff6f7819ULL, 0x000fc4000001166fULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000010ff057819ULL, 0x000fe20000011677ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x0000105467047816ULL, 0x000fe20000000076ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x0000105468057816ULL, 0x000fe20000000005ULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x0000105455147816ULL, 0x000fc40000000064ULL, 0x000010546f157816ULL, 0x000fe40000000015ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x000000042404723cULL, 0x040fe2000004180cULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff557819ULL, 0x000fe40000011657ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000142414723cULL, 0x000fe20000041810ULL, 0x00000010ff787819ULL, 0x000fc40000011678ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff0d7819ULL, 0x000fe40000011673ULL, 0x00000010ff5f7819ULL, 0x000fc4000001165fULL,
0x00000010ff117819ULL, 0x000fe40000011661ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff577819ULL, 0x000fe4000001165aULL, 0x00000010ff007819ULL, 0x000fc40000011600ULL,
0x000010545d547816ULL, 0x000fe40000000054ULL, 0x0000105478787816ULL, 0x000fe40000000069ULL,
0x0000105479797816ULL, 0x000fe4000000006bULL, 0x00001054630c7816ULL, 0x000fe40000000070ULL,
0x00001054620d7816ULL, 0x000fe4000000000dULL, 0x0000105471107816ULL, 0x000fe2000000005fULL,
0x000000782408723cULL, 0x000fe20000041808ULL, 0x0000105472117816ULL, 0x000fc40000000011ULL,
0x000010545e557816ULL, 0x000fe40000000055ULL, 0x00001054595c7816ULL, 0x000fe4000000005cULL,
0x00001054495d7816ULL, 0x000fe2000000005bULL, 0x0000000c240c723cULL, 0x000fe20000041830ULL,
0x0000105458567816ULL, 0x000fe40000000056ULL, 0x0000105457577816ULL, 0x000fca0000000000ULL,
0x000000102410723cULL, 0x040ff00000041834ULL, 0x000000542418723cULL, 0x040ff00000041818ULL,
0x0000005c241c723cULL, 0x040ff0000004181cULL, 0x000000562420723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff247f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000030038007a10ULL, 0x000fe20007ffe0ffULL, 0x0000580065267a24ULL, 0x020fe200078e02ffULL,
0x00000004ff327819ULL, 0x000fe2000001163cULL, 0x000000803b607824ULL, 0x000fe200078e0260ULL,
0x0000000100257810ULL, 0x040fe20007ffe0ffULL, 0x0000010000247824ULL, 0x000fe200078e00ffULL,
0x0000000232337810ULL, 0x000fe20007ffe0ffULL, 0x00000080262b7824ULL, 0x000fe200078e00ffULL,
0xfffffffa60007810ULL, 0x000fe40007ffe0ffULL, 0x0000002439267217ULL, 0x000fc40007800000ULL,
0x000000022500720cULL, 0x000fe40003f46070ULL, 0x000000002b317210ULL, 0x040fe20007f3e0ffULL,
0x0000000126267824ULL, 0x000fe200078e0a24ULL, 0xfffffffc60247810ULL, 0x040fe40007ffe0ffULL,
0xfffffffe60007810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0x0000002026267807ULL, 0x000fe40001000000ULL, 0x000000242b2e7210ULL, 0x000fc40007f9e0ffULL,
0x000000002b297210ULL, 0x040fe40007fbe0ffULL, 0x000000602b2b7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200020e06ffULL, 0x000000263d267217ULL, 0x000fe40007800000ULL,
0x00005e0031307a11ULL, 0x000fe200078640ffULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078240ffULL, 0x0000000126007824ULL, 0x000fe200078e0a3dULL,
0x00005e002e277a11ULL, 0x000fc400078440ffULL, 0x00005f0031317a11ULL, 0x000fe200018f4425ULL,
0x000000ffff257224ULL, 0x000fe200028e06ffULL, 0x00005e0029287a11ULL, 0x000fe400078640ffULL,
0x00005f002b2b7a11ULL, 0x000fe400008f4424ULL, 0x00005f002e2e7a11ULL, 0x000fe400010f442fULL,
0x0000004530247210ULL, 0x000fe40007f9e0ffULL, 0x00000006322f7810ULL, 0x000fc40007ffe0ffULL,
0x000000003200720cULL, 0x0c0fe40003f46070ULL, 0x0000004527267210ULL, 0x080fe40007fbe0ffULL,
0x0000000432327810ULL, 0x000fe40007ffe0ffULL, 0x00005f0029297a11ULL, 0x000fe200018f4425ULL,
0x000000ffff257224ULL, 0x000fe200020e0631ULL, 0x0000004528287210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200028e062eULL, 0x000000003300720cULL, 0x000fc40003f26070ULL,
0x000000003200720cULL, 0x080fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x000000002f00720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024537faeULL, 0x0003e2000d101c46ULL, 0x000000452a2a7210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe400018e062bULL, 0x0000000026527faeULL, 0x0003e8000c901c46ULL,
0x0000000028517faeULL, 0x0003e8000e101c46ULL, 0x000000002a507faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff667f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc4000782482dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff667224ULL, 0x000fe200078e0067ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe4000782482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x0106b400ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc4000782482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000043ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff2b7819ULL, 0x002fe4000001163cULL,
0x00005410002a7816ULL, 0x000fe20000000000ULL, 0x0000b2d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a317589ULL, 0x0002a400000e0000ULL, 0x0000b3127f007947ULL, 0x000fea000b800000ULL,
0x00001f462a467589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0047ULL, 0x0001035000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000b92000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0048ULL, 0x000103b000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fc400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000b8c000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004f2c783bULL, 0x000f680000004200ULL, 0x000000004e28783bULL, 0x00ae680000004200ULL,
0x000000004d24783bULL, 0x000ee80000004200ULL, 0x000000004c4c783bULL, 0x000f220000004200ULL,
0x00000010ff627819ULL, 0x020fc4000001162eULL, 0x000000ff2e367812ULL, 0x040fe400078ec0ffULL,
0x00000018ff357819ULL, 0x000fe4000001162eULL, 0x0000ffff2e767812ULL, 0x000fe400078ec0ffULL,
0x000000ff2c307812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x000fe4000001162fULL,
0x000000ff2f377812ULL, 0x000fc400078ec0ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001162fULL,
0x0000ffff2f797812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x102fe40000011628ULL,
0x000000ff28457812ULL, 0x040fe400078ec0ffULL, 0x00000018ff2f7819ULL, 0x000fe40000011628ULL,
0x0000ffff287a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff287819ULL, 0x000fe40000011629ULL,
0x00000010ff747819ULL, 0x108fe40000011625ULL, 0x000000ff25527812ULL, 0x040fe400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe40000011625ULL, 0x0000ffff257f7812ULL, 0x000fe400078ec0ffULL,
0x00000030ff25723eULL, 0x000fc400020006ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000018ff537819ULL, 0x000fe20000011626ULL, 0x20000025ff607230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000010ff327819ULL, 0x000fe4000001162cULL,
0x00000035ff25723eULL, 0x000fe200020006ffULL, 0x20000028ff357230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe20000011629ULL, 0x20000052ff597230ULL, 0x000fe20000004100ULL,
0x000000ff29477812ULL, 0x040fe200078ec0ffULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x0000ffff297b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe40000011627ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000018ff297819ULL, 0x000fe4000001162aULL,
0x00000053ff28723eULL, 0x000fe400020006ffULL, 0x000000ff27617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff337819ULL, 0x000fc4000001162dULL, 0x000000ff32327812ULL, 0x000fe400078ec0ffULL,
0x00000055ff52723eULL, 0x000fe200020006ffULL, 0x20000051ff557230ULL, 0x000fe20000004100ULL,
0x000000ff2b497812ULL, 0x000fe200078ec0ffULL, 0x20000028ff517230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x000000ff33337812ULL, 0x000fe200078ec0ffULL,
0x20000029ff5c7230ULL, 0x000fe20000004100ULL, 0x00000032ff28723eULL, 0x000fe200020006ffULL,
0x20000061ff537230ULL, 0x000fe20000004100ULL, 0x0000ffff2c727812ULL, 0x000fc400078ec0ffULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000028ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fe4000001162aULL, 0x000000ff2a487812ULL, 0x040fe200078ec0ffULL,
0x20000049ff5a7230ULL, 0x000fe20000004100ULL, 0x0000ffff2a7c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff2d347812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2a7819ULL, 0x000fc4000001162bULL,
0x00000018ff647819ULL, 0x010fe4000001164cULL, 0x00000033ff29723eULL, 0x000fe400020006ffULL,
0x00000018ff007819ULL, 0x004fe4000001162cULL, 0x00000018ff2c7819ULL, 0x000fe4000001162dULL,
0x0000ffff2d757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff707819ULL, 0x000fc4000001162bULL,
0x0000ffff2b7d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff287819ULL, 0x000fe40000011672ULL,
0x00000018ff2b7819ULL, 0x100fe40000011624ULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x000000ff4d697812ULL, 0x000fe400078ec0ffULL, 0x0000002aff2a723eULL, 0x000fe200020006ffULL,
0x20000034ff637230ULL, 0x000fe20000004100ULL, 0x00000064ff49723eULL, 0x000fe200020006ffULL,
0x20000029ff647230ULL, 0x000fe20000004100ULL, 0x000000ff24507812ULL, 0x040fe200078ec0ffULL,
0x2000002aff587230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011624ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x0000ffff247e7812ULL, 0x000fc400078ec0ffULL,
0x0000002cff5f723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000008ff297819ULL, 0x000fe20000011675ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000010ff247819ULL, 0x000fc4000001164cULL, 0x000000ff4c687812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4c2c7812ULL, 0x000fe400078ec0ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001164dULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000002bff567230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x0000002fff34723eULL, 0x000fe200020006ffULL, 0x20000047ff2f7230ULL, 0x000fe20000004100ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000050ff577230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fe200020006ffULL, 0x20000034ff347230ULL, 0x000fe20000004100ULL,
0x00000062ff2a723eULL, 0x000fe200020006ffULL, 0x20000028ff627230ULL, 0x000fe20000004100ULL,
0x00000018ff6a7819ULL, 0x000fe4000001164eULL, 0x0000004cff47723eULL, 0x000fe200020006ffULL,
0x20000069ff4c7230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fc40000011679ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000008ff2b7819ULL, 0x000fe40000011676ULL, 0x00000067ff69723eULL, 0x000fe200020006ffULL,
0x20000029ff677230ULL, 0x000fe20000004100ULL, 0x00000068ff50723eULL, 0x000fe200020006ffULL,
0x2000002aff687230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x000000ff4e6d7812ULL, 0x000fe200078ec0ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000028ff29723eULL, 0x000fe200020006ffULL, 0x2000006aff337230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000069ff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fc40000011626ULL, 0x000000ff26547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff265d7812ULL, 0x000fe400078ec0ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x0000b8004b287811ULL, 0x000fe200078e20ffULL, 0x20000029ff4b7230ULL, 0x000fe20000004100ULL,
0x00000008ff2a7819ULL, 0x000fe2000001167aULL, 0x2000002bff697230ULL, 0x000fe20000004100ULL,
0x0000002eff26723eULL, 0x000fc400020006ffULL, 0x00000045ff2e723eULL, 0x000fe400020006ffULL,
0x0000006dff45723eULL, 0x000fe200020006ffULL, 0x2000006cff6d7230ULL, 0x000fe20000004100ULL,
0x0000002aff6c723eULL, 0x000fe200020006ffULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x00000000ff5e723eULL, 0x000fe200020006ffULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fe20000011627ULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fc40000011663ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x0000ffff27277812ULL, 0x000fe400078ec0ffULL,
0x0000105461607816ULL, 0x000fe40000000060ULL, 0x0000105464617816ULL, 0x000fe40000000063ULL,
0x00000008ff647819ULL, 0x000fe40000011627ULL, 0x00000010ff277819ULL, 0x000fc4000001165fULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff5f7819ULL, 0x000fe40000011667ULL, 0x000000ff24247812ULL, 0x000fe400078ec0ffULL,
0x000010545e5e7816ULL, 0x000fe40000000062ULL, 0x00001054275f7816ULL, 0x000fc4000000005fULL,
0x00000024ff27723eULL, 0x000fe400020006ffULL, 0x00000010ff257819ULL, 0x000fe40000011625ULL,
0x00000010ff267819ULL, 0x000fe20000011626ULL, 0x0000003128288231ULL, 0x082fe200003400ffULL,
0x0000b8004a247811ULL, 0x000fe200078e20ffULL, 0x000000312a2a8231ULL, 0x000fe200003400ffULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x0000004629298231ULL, 0x080fe200003400ffULL,
0x00000010ff4b7819ULL, 0x000fe2000001164bULL, 0x000000462b2b8231ULL, 0x000fe200003400ffULL,
0x00000036ff36723eULL, 0x000fc400020006ffULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x00001054254a7816ULL, 0x000fe20000000069ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x0000005e2804723cULL, 0x040fe20000041804ULL, 0x00001054264b7816ULL, 0x000fe2000000004bULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000018ff6e7819ULL, 0x000fe4000001164fULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x20000027ff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x000000ff4f717812ULL, 0x000fe200078ec0ffULL, 0x20000048ff5b7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x000000602808723cULL, 0x000fe20000041808ULL,
0x000000ff70707812ULL, 0x000fc400078ec0ffULL, 0x00000010ff367819ULL, 0x000fe20000011636ULL,
0x2000006eff327230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe40000011637ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000071ff48723eULL, 0x000fc400020006ffULL,
0x00000008ff5d7819ULL, 0x000fe2000001165dULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000070ff71723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x0000105468367816ULL, 0x000fe40000000036ULL, 0x000010546a377816ULL, 0x000fe20000000037ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fe4000001167bULL,
0x000000ff6f6f7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff707819ULL, 0x000fe2000001167cULL,
0x000000362814723cULL, 0x000fe20000041814ULL, 0x00000008ff727819ULL, 0x000fe4000001167dULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000010ff2d7819ULL, 0x000fe4000001164dULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000005dff637230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x0000003124248231ULL, 0x082fe200003400ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff2c7819ULL, 0x000fe2000001162cULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000000ff74747812ULL, 0x000fe200078ec0ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x000000ff2d2d7812ULL, 0x000fe200078ec0ffULL, 0x0000003126268231ULL, 0x000fe200003400ffULL,
0x00000010ff2e7819ULL, 0x000fe2000001162eULL, 0x0000004625258231ULL, 0x080fe200003400ffULL,
0x00000010ff2f7819ULL, 0x000fe2000001162fULL, 0x0000004627278231ULL, 0x000fe200003400ffULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff377819ULL, 0x000fe4000001166dULL,
0x0000002cff5d723eULL, 0x000fe400020006ffULL, 0x000000ff73737812ULL, 0x000fe400078ec0ffULL,
0x00000074ff75723eULL, 0x000fe400020006ffULL, 0x0000002dff5f723eULL, 0x000fe400020006ffULL,
0x000010546b367816ULL, 0x000fe2000000002eULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x0000105437377816ULL, 0x000fe2000000002fULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fe2000001167eULL, 0x0000004a282c723cULL, 0x000fe2000004180cULL,
0x00000008ff767819ULL, 0x000fc4000001167fULL, 0x000000ff77777812ULL, 0x000fe400078ec0ffULL,
0x000000ff78787812ULL, 0x000fe400078ec0ffULL, 0x2000005dff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe40000011634ULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6d7819ULL, 0x000fc4000001166eULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff0d7819ULL, 0x000fe4000001165aULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff707819ULL, 0x000fc40000011670ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff5d7819ULL, 0x000fe40000011672ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00001054346c7816ULL, 0x000fe2000000006cULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00001054356d7816ULL, 0x000fe2000000006dULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x000010546f0c7816ULL, 0x000fe2000000005bULL, 0x000000362834723cULL, 0x000fe20000041810ULL,
0x00001054710d7816ULL, 0x000fc4000000000dULL, 0x000010545c5c7816ULL, 0x000fe40000000070ULL,
0x00001054585d7816ULL, 0x000fe4000000005dULL, 0x00000010ff307819ULL, 0x000fe2000001164eULL,
0x0000006c2818723cULL, 0x000fe20000041818ULL, 0x00000010ff007819ULL, 0x000fe4000001164fULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4e4e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x0000000c281c723cULL, 0x040fe2000004181cULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x000000ff30307812ULL, 0x000fe400078ec0ffULL,
0x000000ff00007812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4e7819ULL, 0x000fe2000001164eULL,
0x0000005c2820723cULL, 0x000fe20000041820ULL, 0x00000008ff4f7819ULL, 0x000fc4000001164fULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff557819ULL, 0x000fc40000011655ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff0f7819ULL, 0x000fe40000011676ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff117819ULL, 0x000fe40000011653ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff787819ULL, 0x000fc40000011678ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000030ff30723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x20000030ff307230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x00001054730c7816ULL, 0x000fe20000000057ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00001054750d7816ULL, 0x000fe20000000059ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00001054560e7816ULL, 0x000fc40000000074ULL, 0x00001054550f7816ULL, 0x000fe4000000000fULL,
0x0000105477107816ULL, 0x000fe20000000054ULL, 0x0000000c2408723cULL, 0x040fe20000041808ULL,
0x0000105478117816ULL, 0x000fe40000000011ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x0000000e240c723cULL, 0x000fe20000041804ULL, 0x00000010ff507819ULL, 0x000fc40000011650ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff057819ULL, 0x000fe20000011664ULL, 0x000000102410723cULL, 0x000fe20000041814ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff477819ULL, 0x000fc40000011647ULL, 0x00000010ff157819ULL, 0x000fe4000001164cULL,
0x00000010ff4b7819ULL, 0x000fe4000001164dULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff307819ULL, 0x000fe40000011630ULL, 0x00000010ff317819ULL, 0x000fe40000011648ULL,
0x00000010ff007819ULL, 0x000fc40000011600ULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff327819ULL, 0x000fe40000011632ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x0000105451047816ULL, 0x000fe40000000063ULL,
0x0000105452057816ULL, 0x000fc40000000005ULL, 0x000010545e147816ULL, 0x000fe40000000050ULL,
0x000010545f157816ULL, 0x000fe40000000015ULL, 0x00001054494a7816ULL, 0x000fe2000000004aULL,
0x000000042404723cULL, 0x000fe2000004182cULL, 0x00001054474b7816ULL, 0x000fe4000000004bULL,
0x0000105430307816ULL, 0x000fe40000000045ULL, 0x0000105400317816ULL, 0x000fc40000000031ULL,
0x00001054334e7816ULL, 0x000fe2000000004eULL, 0x000000142414723cULL, 0x000fe20000041834ULL,
0x00001054324f7816ULL, 0x000fce000000004fULL, 0x0000004a2418723cULL, 0x040ff00000041818ULL,
0x00000030241c723cULL, 0x040ff0000004181cULL, 0x0000004e2420723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff247f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030038387a10ULL, 0x000fc80007ffe0ffULL,
0x000000023800720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffef3b000007947ULL, 0x000fea000383ffffULL, 0x0000000000307919ULL, 0x000ee20000002500ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0023ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0022ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0021ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0020ULL,
0x000000ffff277224ULL, 0x000fe400078e001bULL, 0x000000ffff267224ULL, 0x000fc400078e001aULL,
0x000000ffff257224ULL, 0x006fe400078e0019ULL, 0x000000ffff247224ULL, 0x000fe400078e0018ULL,
0x000000ffff2b7224ULL, 0x000fe400078e001fULL, 0x000000ffff2a7224ULL, 0x000fe400078e001eULL,
0x000000ffff297224ULL, 0x000fe400078e001dULL, 0x000000ffff287224ULL, 0x000fe200078e001cULL,
0x000000023000720cULL, 0x008fe20003f06070ULL, 0x000000ffff237224ULL, 0x000fc400078e0017ULL,
0x000000ffff227224ULL, 0x000fe400078e0016ULL, 0x000000ffff217224ULL, 0x000fe400078e0015ULL,
0x000000ffff207224ULL, 0x000fe400078e0014ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0013ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0012ULL, 0x000000ffff197224ULL, 0x000fc400078e0011ULL,
0x000000ffff187224ULL, 0x000fe400078e0010ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0007ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0005ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0004ULL, 0x000000ffff177224ULL, 0x000fc400078e000fULL,
0x000000ffff167224ULL, 0x000fe400078e000eULL, 0x000000ffff157224ULL, 0x000fe400078e000dULL,
0x000000ffff147224ULL, 0x000fe400078e000cULL, 0x000000ffff137224ULL, 0x000fe400078e000bULL,
0x000000ffff127224ULL, 0x000fe400078e000aULL, 0x000000ffff117224ULL, 0x000fc400078e0009ULL,
0x000000ffff107224ULL, 0x000fe200078e0008ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x018000003f007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff317224ULL, 0x000fe200078e003fULL,
0x00011d8000047802ULL, 0x000fe40000000f00ULL, 0x00009d3000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003f00007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc8000000003fULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000200007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff027624ULL, 0x000fe400078e00ffULL, 0x00006900ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x000968000c1e9900ULL, 0x0000000000037919ULL, 0x010f240000000000ULL,
0x00000002ff047819ULL, 0x010fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000002007220ULL, 0x02cfca0000410000ULL, 0x00001f0400027589ULL, 0x000ea800000e0000ULL,
0x00001f0300037589ULL, 0x000ee200000e0000ULL, 0x0000001002107220ULL, 0x044fe20000410000ULL,
0x0000001102117220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000001802187220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002502257220ULL, 0x040fe20000410000ULL, 0x0000002802287220ULL, 0x040fe20000410000ULL,
0x0000002902297220ULL, 0x040fe20000410000ULL, 0x0000002c022c7220ULL, 0x040fe20000410000ULL,
0x0000002d022d7220ULL, 0x000fe20000410000ULL, 0x0000001203127220ULL, 0x048fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x000fe20000410000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200027812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011600ULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x0000000202047811ULL, 0x040fe400078ff8ffULL, 0x0000000402077811ULL, 0x040fe400078ff8ffULL,
0x00000006020b7811ULL, 0x000fe400078ff8ffULL, 0x00000008000f7811ULL, 0x000fc400078ff0ffULL,
0x0000000703027812ULL, 0x100fe400078e780dULL, 0x0000000704057812ULL, 0x100fe400078e780dULL,
0x0000000707097812ULL, 0x000fe200078e780dULL, 0x000000080d067824ULL, 0x000fe200078e0202ULL,
0x0000000707077812ULL, 0x000fe200078e780fULL, 0x000000080d087824ULL, 0x000fe200078e0205ULL,
0x000000070b0c7812ULL, 0x000fe200078e780dULL, 0x000008003a027824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe200078e780fULL, 0x000000080f0e7824ULL, 0x000fe200078e0207ULL,
0x0000000704047812ULL, 0x000fe200078e780fULL, 0x000000080d0a7824ULL, 0x000fe200078e0209ULL,
0x000000070b057812ULL, 0x000fe200078e780fULL, 0x000000080d0c7824ULL, 0x000fc400078e020cULL,
0x000000080f0b7824ULL, 0x040fe200078e0203ULL, 0x0000a00002037810ULL, 0x000fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x000000080f0d7824ULL, 0x000fe200078e0204ULL,
0x000000101104723eULL, 0x000fe200000010ffULL, 0x000000080f0f7824ULL, 0x000fe200078e0205ULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x000000141505723eULL, 0x000fe200000010ffULL, 0x0000001008097824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0x0000541004107816ULL, 0x040fe20000000005ULL,
0x000000100b0b7824ULL, 0x000fe200078e0203ULL, 0x0000763204117816ULL, 0x000fe20000000005ULL,
0x000000100d0d7824ULL, 0x100fe400078e0203ULL, 0x000000100c0c7824ULL, 0x100fe400078e0203ULL,
0x000000100e0e7824ULL, 0x100fe400078e0203ULL, 0x000000100f0f7824ULL, 0x000fc400078e0203ULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000181906723eULL, 0x000fe200000010ffULL,
0x0000000107097824ULL, 0x040fe400078e0209ULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000001008007388ULL, 0x0005e20000000a00ULL, 0x00000001070b7824ULL, 0x040fe400078e020bULL,
0x00000001070d7824ULL, 0x040fe400078e020dULL, 0x00000001070c7824ULL, 0x000fc400078e020cULL,
0x00000001070e7824ULL, 0x040fe400078e020eULL, 0x00000001070f7824ULL, 0x000fe200078e020fULL,
0x0000001c1d07723eULL, 0x000fe400000010ffULL, 0x000000121308723eULL, 0x004fe200000010ffULL,
0x00000300ff127624ULL, 0x000fe200078e00ffULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe40000000007ULL, 0x000000282906723eULL, 0x000fc400000010ffULL,
0x0000002c2d07723eULL, 0x000fe200000010ffULL, 0x0000000409007388ULL, 0x0005e20000000a00ULL,
0x000000011200780cULL, 0x000fe40003f05270ULL, 0x000000202104723eULL, 0x004fe400000010ffULL,
0x000000242505723eULL, 0x000fe400000010ffULL, 0x000000161709723eULL, 0x000fe400000010ffULL,
0x0000541004107816ULL, 0x000fc40000000005ULL, 0x0000763204117816ULL, 0x000fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x000000100a007388ULL, 0x000fe20000000a00ULL, 0x000000222306723eULL, 0x000fe400000010ffULL,
0x000000262707723eULL, 0x000fe200000010ffULL, 0x000000040c007388ULL, 0x0005e40000000a00ULL,
0x0000541008047816ULL, 0x004fc40000000009ULL, 0x0000763208057816ULL, 0x000fe40000000009ULL,
0x0000002a2b08723eULL, 0x000fe400000010ffULL, 0x0000002e2f09723eULL, 0x000fe200000010ffULL,
0x000000040b007388ULL, 0x0005e40000000a00ULL, 0x0000001a1b04723eULL, 0x004fe400000010ffULL,
0x0000001e1f05723eULL, 0x000fc800000010ffULL, 0x00005410040a7816ULL, 0x140fe40000000005ULL,
0x00007632040b7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000a0d007388ULL, 0x0005e20000000a00ULL,
0x0000541008067816ULL, 0x140fe40000000009ULL, 0x0000763208077816ULL, 0x000fe20000000009ULL,
0x000000040e007388ULL, 0x0005e80000000a00ULL, 0x000000060f007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b4000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ee20000002700ULL, 0x0000001000047824ULL, 0x004fe200078e0202ULL,
0x000000ff3a00720cULL, 0x000fe20003f05270ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x0000000000057919ULL, 0x000ee20000002600ULL, 0x00000020000e7810ULL, 0x040fe40007ffe0ffULL,
0x000000ff0000720cULL, 0x000fe20000725670ULL, 0x00a0000004147984ULL, 0x000ea80000000c00ULL,
0x00a2000004187984ULL, 0x0008640000000c00ULL, 0x0000580012047a24ULL, 0x010fc800078e02ffULL,
0x0000660004087a24ULL, 0x000fe400078e02ffULL, 0x0000580010107a24ULL, 0x008fc600078e0205ULL,
0x00000fff08057811ULL, 0x000fe200078e40ffULL, 0x0000030010047a24ULL, 0x000fc800078e02ffULL,
0x0000000104097824ULL, 0x000fca00078e0230ULL, 0x0000000905067211ULL, 0x000fca00078fa0ffULL,
0x00006c0006067625ULL, 0x000fcc00078e0007ULL, 0x000004003a067825ULL, 0x000fcc00078e0006ULL,
0x000000100e0e7825ULL, 0x000fc800078e0006ULL, 0x00000010000c7825ULL, 0x000fe200078e0006ULL,
0x01ffffff08067812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000001ff087819ULL, 0x006fe20000011600ULL, 0x0000001000077824ULL, 0x000fe400078e00ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c08117812ULL, 0x000fe200078ec0ffULL,
0x00000001090a7824ULL, 0x000fe200078e0206ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x00006c0009087625ULL, 0x000fc800078e000bULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000811087210ULL, 0x000fc80007b5e007ULL, 0x0000000a110a7210ULL, 0x000fe40007d9e007ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000003e08007986ULL, 0x0003e8000c101906ULL, 0x0000003f0a007986ULL, 0x0003e4000c101906ULL,
0x000000140c007986ULL, 0x0063e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000180e007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff087424ULL, 0x000fe200078e00ffULL,
0xffffffff12077810ULL, 0x000fc60007ffe0ffULL, 0x00006a0010087625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000007080879a8ULL, 0x000ea400099ee1c6ULL, 0x000000070800720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff077807ULL, 0x000fca0000800000ULL,
0x00000007ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff077984ULL, 0x004ea40000000000ULL,
0x000000ff0700720cULL, 0x004fda0003f25270ULL, 0x0000278000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011600ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x00000001040a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x0000000c08147812ULL, 0x002fe400078ec0ffULL,
0x0000007007137812ULL, 0x000fe200078ec0ffULL, 0x00006c0004087625ULL, 0x000fc800078e0011ULL,
0x00006c000a0a7625ULL, 0x000fe200078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x0000000a140a7210ULL, 0x000fe40007b5e013ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608077981ULL, 0x000368000c1e1900ULL,
0x000000060a0c7981ULL, 0x000362000c1e1900ULL, 0x000000021200780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080d7981ULL, 0x000362000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080e7981ULL, 0x000362000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608107981ULL, 0x000362000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081200780cULL, 0x002fe40003f06070ULL,
0x0000000604087810ULL, 0x000fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fe40007a3e013ULL, 0x00000007040a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006c000a0a0625ULL, 0x000fe400078e0011ULL,
0x0000000608117981ULL, 0x000366000c1e1900ULL, 0x0000000a140a0210ULL, 0x000fc80007c7e013ULL,
0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL, 0x000000060a0a0981ULL, 0x000368000c1e1900ULL,
0x0000000712087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0b7819ULL, 0x000fc80000011608ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff127224ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x020fe400078e0007ULL,
0x0000000812147824ULL, 0x040fe200078e00ffULL, 0x0000000112127810ULL, 0x000fc80007ffe0ffULL,
0x0000030014007a0cULL, 0x000fe40003f26070ULL, 0x0000000b1200720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000814087810ULL, 0x040fe40007ffe0ffULL,
0x0000000114097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001307077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000914087810ULL, 0x042fe40007ffe0ffULL, 0x0000000214097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000c07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e00cULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080c7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000314097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000d07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000414097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000e07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e00eULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080e7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000514097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000f07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000f7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000614097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010107812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e010ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608107981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000714097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001107077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f14087810ULL, 0x002fe40007ffe0ffULL, 0x0000000a07077209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700a0a7812ULL, 0x000fc800078ec0ffULL, 0x0000000814087210ULL, 0x000fc80007a3e00aULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080a7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000087824ULL, 0x006fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108087824ULL, 0x000fca00078e0209ULL, 0x0000000708007388ULL, 0x0203e40000000800ULL,
0x0000000405087211ULL, 0x002fe200078fa0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011600ULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x00000016ff437819ULL, 0x000fe2000001163aULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x000004003a427824ULL, 0x000fe200078e00ffULL, 0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL,
0x000010003a207824ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000004208087210ULL, 0x000fe20007f3e0ffULL,
0x0000000107177824ULL, 0x000fe200078e020aULL, 0x00000020000a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001040c8824ULL, 0x000fe200078e0206ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200008e0643ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0d8424ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0e8424ULL, 0x000fe200078e00ffULL, 0x0000000017177984ULL, 0x000e620000000800ULL,
0x00006c000c0c8625ULL, 0x000fe200078e000dULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000100a0a7825ULL, 0x000fe200078e0008ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001000077824ULL, 0x000fc400078e0220ULL, 0x000000103a108824ULL, 0x000fe400078e0200ULL,
0x0000001000087825ULL, 0x000fc600078e0008ULL, 0x0000458010108811ULL, 0x000fe200078e20ffULL,
0x00006c00040e8625ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008077faeULL, 0x0005e6000b901c46ULL, 0x000000103a118824ULL, 0x000fe200078e0200ULL,
0x003800000a077faeULL, 0x0007e2000b901c46ULL, 0x00000010000c8825ULL, 0x000fc600078e000cULL,
0x0000418011118811ULL, 0x000fe200078e20ffULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000000000c108faeULL, 0x0009e2000b901c46ULL, 0x0000001000088825ULL, 0x004fe400078e000eULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x000000ffff077224ULL, 0x008fe200078e00ffULL,
0x0000000008118faeULL, 0x0005e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x010fe2000001ff00ULL,
0x0000000000087805ULL, 0x004fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000cf000009947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x002fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fca00078e00ffULL, 0x0000000132337810ULL, 0x000fc80007ffe0ffULL,
0x0000030033007a0cULL, 0x000fda0003f06070ULL, 0x0000023000000947ULL, 0x000fea0003800000ULL,
0x00000001041f7824ULL, 0x000fe200078e0233ULL, 0x000000070000780cULL, 0x040fe20003f24070ULL,
0x00001000ff197424ULL, 0x000fe200078e00ffULL, 0x00000001331e7812ULL, 0x040fe200078ec0ffULL,
0x00000800331a7824ULL, 0x000fe200078e00ffULL, 0x0000001f05187211ULL, 0x000fe400078fa0ffULL,
0x0000002000367810ULL, 0x000fe40007ffe0ffULL, 0x000008001a1c7812ULL, 0x000fe200078ec0ffULL,
0x00006c0018187625ULL, 0x000fc800078e0019ULL, 0x00000001061b9824ULL, 0x000fe200078e021fULL,
0x0000004218187210ULL, 0x000fe20007f1e0ffULL, 0x00000080ff349424ULL, 0x000fe400078e00ffULL,
0x000000023a1d9824ULL, 0x140fe400078e021eULL, 0x000000023a379824ULL, 0x000fe400078e021eULL,
0x00006c001b1a9625ULL, 0x000fc800078e0034ULL, 0x00000080ff1e9424ULL, 0x000fe400078e00ffULL,
0x00000001201c7824ULL, 0x000fe400078e021cULL, 0x0000000119197824ULL, 0x000fe400000e0643ULL,
0x000000081d359824ULL, 0x000fe400078e0200ULL, 0x00006c001f1e9625ULL, 0x000fc600078e001eULL,
0x0000458035359811ULL, 0x000fe200078e20ffULL, 0x0000001000347824ULL, 0x040fe400078e021cULL,
0x0000000837379824ULL, 0x000fe400078e0200ULL, 0x00000010001c9825ULL, 0x000fc800078e001aULL,
0x00000010361a7825ULL, 0x000fe200078e0018ULL, 0x0000418037369811ULL, 0x000fc600078e20ffULL,
0x0000001000187825ULL, 0x000fc800078e0018ULL, 0x00000010001e9825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000018347faeULL, 0x0003e8000b901c46ULL,
0x003800001a347faeULL, 0x0003e8000b901c46ULL, 0x000000001c359faeULL, 0x0003e8000b901c46ULL,
0x000000001e369faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff357224ULL, 0x002fe200078e0032ULL, 0x00000001ff1a7819ULL, 0x100fe20000011600ULL,
0x0000001000197824ULL, 0x000fe200078e00ffULL, 0x00000002ff447819ULL, 0x000fe20000011600ULL,
0x0000008035187824ULL, 0x000fe200078e00ffULL, 0x0000000c1a1a7812ULL, 0x000fc400078ec0ffULL,
0x0000007019197812ULL, 0x000fe200078ec0ffULL, 0x00000008441b7824ULL, 0x000fe200078e00ffULL,
0x0000008018187812ULL, 0x000fe400078ec0ffULL, 0x00000044ff347212ULL, 0x000fe400078e33ffULL,
0x0000000744327812ULL, 0x000fe200078ec0ffULL, 0x000001003a187824ULL, 0x000fe200078e0218ULL,
0xfffffff81b347812ULL, 0x000fe400078ee234ULL, 0x0000000844457810ULL, 0x000fc40007ffe0ffULL,
0x000000181a187210ULL, 0x000fe20007ffe019ULL, 0x0000000844197824ULL, 0x000fe200078e00ffULL,
0x00000045ff3f7212ULL, 0x000fe200078e33ffULL, 0x0000000845367824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000181a7984ULL, 0x000e620000000800ULL,
0x00000001191b7812ULL, 0x100fe200078ef632ULL, 0x0000000845377824ULL, 0x000fe200078e00ffULL,
0x00000002191c7812ULL, 0x140fe200078ef632ULL, 0x0045800018417984ULL, 0x0004e20000000800ULL,
0x00000003191d7812ULL, 0x140fe400078ef632ULL, 0x00000004191e7812ULL, 0x140fe400078ef632ULL,
0x00000005191f7812ULL, 0x000fe400078ef632ULL, 0xfffffff8363f7812ULL, 0x000fe200078ee23fULL,
0x0000000844187824ULL, 0x004fca00078e00ffULL, 0xfffffff818187812ULL, 0x100fe400078ee232ULL,
0x0000000619327812ULL, 0x000fe200078ef632ULL, 0x0000080035197824ULL, 0x000fca00078e00ffULL,
0x0000080019197812ULL, 0x000fc800078ec0ffULL, 0x0000018020197810ULL, 0x000fca0007ffe019ULL,
0x0000001018187824ULL, 0x100fe400078e0219ULL, 0x0000001034347824ULL, 0x100fe400078e0219ULL,
0x000000101b1b7824ULL, 0x100fe200078e0219ULL, 0x0000001a171a7221ULL, 0x002fe20000010100ULL,
0x000000101c1c7824ULL, 0x100fe400078e0219ULL, 0x000000101d1d7824ULL, 0x000fe200078e0219ULL,
0x3fb8aa3b1a357820ULL, 0x000fe20000410000ULL, 0x00000004001a7824ULL, 0x000fc400078e00ffULL,
0x000000101e1e7824ULL, 0x100fe200078e0219ULL, 0x0000003500407308ULL, 0x0002e20000000800ULL,
0x000000101f1f7824ULL, 0x100fe200078e0219ULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000001032327824ULL, 0x100fe400078e0219ULL, 0x000000103f3f7824ULL, 0x000fe400078e0219ULL,
0x0000000118187824ULL, 0x000fe200078e021aULL, 0x0000000745357812ULL, 0x002fe200078ec0ffULL,
0x000000011a347824ULL, 0x000fc400078e0234ULL, 0x000000011a1b7824ULL, 0x000fe200078e021bULL,
0xfffffff836367812ULL, 0x100fe200078ee235ULL, 0x000000011a1c7824ULL, 0x000fe200078e021cULL,
0x0000000137387812ULL, 0x140fe200078ef635ULL, 0x0000004140407220ULL, 0x008fe20000410000ULL,
0x0000000237397812ULL, 0x140fe200078ef635ULL, 0x0000000034417984ULL, 0x000fe20000000800ULL,
0x00000003373b7812ULL, 0x040fe200078ef635ULL, 0x000000011a1d7824ULL, 0x040fe200078e021dULL,
0x00000004373c7812ULL, 0x140fe200078ef635ULL, 0x000000001b347984ULL, 0x000fe20000000800ULL,
0x00000005373e7812ULL, 0x140fe200078ef635ULL, 0x000000011a1e7824ULL, 0x040fe200078e021eULL,
0x0000000637357812ULL, 0x000fe200078ef635ULL, 0x00001f44401b7589ULL, 0x000fe200000e0000ULL,
0x000000011a1f7824ULL, 0x000fe200078e021fULL, 0x0000003140317221ULL, 0x000fe20000010000ULL,
0x000000011a327824ULL, 0x000fe200078e0232ULL, 0x0000000018377984ULL, 0x000e620000000800ULL,
0x0000001036367824ULL, 0x000fc400078e0219ULL, 0x0000001038387824ULL, 0x100fe200078e0219ULL,
0x000000001c1c7984ULL, 0x000ea20000000800ULL, 0x000000011a367824ULL, 0x040fe400078e0236ULL,
0x000000011a387824ULL, 0x040fe200078e0238ULL, 0x000000001d1d7984ULL, 0x000ee20000000800ULL,
0x0000001039397824ULL, 0x100fe400078e0219ULL, 0x000000103b3b7824ULL, 0x000fe200078e0219ULL,
0x000000001e1e7984ULL, 0x000f220000000800ULL, 0x000000011a397824ULL, 0x000fc400078e0239ULL,
0x000000011a3b7824ULL, 0x000fe200078e023bULL, 0x000000001f1f7984ULL, 0x000f620000000800ULL,
0x000000103c3c7824ULL, 0x100fe400078e0219ULL, 0x000000103e3e7824ULL, 0x100fe200078e0219ULL,
0x0000000032327984ULL, 0x000ea20000000800ULL, 0x000000011a3c7824ULL, 0x040fe400078e023cULL,
0x000000011a3e7824ULL, 0x000fe200078e023eULL, 0x0000000036367984ULL, 0x000ea20000000800ULL,
0x0000001035357824ULL, 0x000fc400078e0219ULL, 0x000000011a3f7824ULL, 0x040fe200078e023fULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x000000011a357824ULL, 0x000fc600078e0235ULL,
0x00001f4540407589ULL, 0x000ea800000e0000ULL, 0x0000000039397984ULL, 0x000ea20000000800ULL,
0x00005410ff187816ULL, 0x002fc60000000037ULL, 0x000000003b3b7984ULL, 0x000e640000000800ULL,
0x0000001b18307223ULL, 0x080fe20000010030ULL, 0x00007610ff187816ULL, 0x000fe20000000037ULL,
0x000000003c3c7984ULL, 0x000e680000000800ULL, 0x0000001b182f7223ULL, 0x080fe2000001002fULL,
0x00005410ff187816ULL, 0x100fe20000000041ULL, 0x000000003e3e7984ULL, 0x000e680000000800ULL,
0x0000001b18227223ULL, 0x080fe20000010022ULL, 0x00007610ff187816ULL, 0x000fe20000000041ULL,
0x0000000035357984ULL, 0x000e680000000800ULL, 0x0000001b18217223ULL, 0x080fe20000010021ULL,
0x00005410ff187816ULL, 0x000fe20000000034ULL, 0x000000003f3f7984ULL, 0x000e680000000800ULL,
0x0000001b182e7223ULL, 0x000fe2000001002eULL, 0x00007610ff187816ULL, 0x000fca0000000034ULL,
0x0000001b182d7223ULL, 0x000fe2000001002dULL, 0x00005410ff187816ULL, 0x004fca000000001cULL,
0x0000001b182c7223ULL, 0x000fe2000001002cULL, 0x00007610ff187816ULL, 0x000fca000000001cULL,
0x0000001b182b7223ULL, 0x000fe2000001002bULL, 0x00005410ff187816ULL, 0x008fca000000001dULL,
0x0000001b182a7223ULL, 0x000fe2000001002aULL, 0x00007610ff187816ULL, 0x000fca000000001dULL,
0x0000001b18297223ULL, 0x000fe20000010029ULL, 0x00005410ff187816ULL, 0x010fca000000001eULL,
0x0000001b18287223ULL, 0x000fe20000010028ULL, 0x00007610ff187816ULL, 0x000fca000000001eULL,
0x0000001b18277223ULL, 0x000fe20000010027ULL, 0x00005410ff187816ULL, 0x020fca000000001fULL,
0x0000001b18267223ULL, 0x000fe20000010026ULL, 0x00007610ff187816ULL, 0x000fca000000001fULL,
0x0000001b18257223ULL, 0x000fe20000010025ULL, 0x00005410ff187816ULL, 0x000fca0000000032ULL,
0x0000001b18247223ULL, 0x000fe20000010024ULL, 0x00007610ff187816ULL, 0x000fe20000000032ULL,
0x000000ffff327224ULL, 0x000fc800078e0033ULL, 0x0000001b18237223ULL, 0x000fe20000010023ULL,
0x00005410ff187816ULL, 0x000fe40000000036ULL, 0x0000030032007a0cULL, 0x000fc60003f06070ULL,
0x0000004018167223ULL, 0x000fe20000010016ULL, 0x00007610ff187816ULL, 0x000fca0000000036ULL,
0x0000004018157223ULL, 0x000fe20000010015ULL, 0x00005410ff187816ULL, 0x000fca0000000038ULL,
0x0000004018147223ULL, 0x000fe20000010014ULL, 0x00007610ff187816ULL, 0x000fca0000000038ULL,
0x0000004018137223ULL, 0x000fe20000010013ULL, 0x00005410ff187816ULL, 0x000fca0000000039ULL,
0x0000004018127223ULL, 0x000fe20000010012ULL, 0x00007610ff187816ULL, 0x000fca0000000039ULL,
0x0000004018117223ULL, 0x000fe20000010011ULL, 0x00005410ff187816ULL, 0x002fca000000003bULL,
0x0000004018107223ULL, 0x000fe20000010010ULL, 0x00007610ff187816ULL, 0x000fca000000003bULL,
0x00000040180f7223ULL, 0x000fe2000001000fULL, 0x00005410ff187816ULL, 0x000fca000000003cULL,
0x00000040180e7223ULL, 0x000fe2000001000eULL, 0x00007610ff187816ULL, 0x000fca000000003cULL,
0x00000040180d7223ULL, 0x000fe2000001000dULL, 0x00005410ff187816ULL, 0x000fca000000003eULL,
0x00000040180c7223ULL, 0x000fe2000001000cULL, 0x00007610ff187816ULL, 0x000fca000000003eULL,
0x00000040180b7223ULL, 0x000fe2000001000bULL, 0x00005410ff187816ULL, 0x000fca0000000035ULL,
0x00000040180a7223ULL, 0x000fe2000001000aULL, 0x00007610ff187816ULL, 0x000fca0000000035ULL,
0x0000004018097223ULL, 0x000fe20000010009ULL, 0x00005410ff187816ULL, 0x000fca000000003fULL,
0x0000004018087223ULL, 0x000fe20000010008ULL, 0x00007610ff187816ULL, 0x000fca000000003fULL,
0x0000004018077223ULL, 0x000fe20000010007ULL, 0xfffff33000008947ULL, 0x000fea000383ffffULL,
0x0180000031007810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000000007812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0001480000047802ULL, 0x000fe40000000f00ULL, 0x000072b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003100047308ULL, 0x000e640000001000ULL, 0xbf80000004317423ULL, 0x002fc80000000031ULL,
0x800000ff31317221ULL, 0x000fc80000010100ULL, 0x0000003104047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff177819ULL, 0x004fe20000011600ULL,
0x00000004001e7824ULL, 0x040fe200078e00ffULL, 0x00000008001d7811ULL, 0x000fe400078ff0ffULL,
0x00000017ff067212ULL, 0x000fe200078e33ffULL, 0x00001f1704057589ULL, 0x000ea200000e0000ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000071d1b7812ULL, 0x040fe200078ec0ffULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0x00001f1d04047589ULL, 0x000ee200000e0000ULL,
0x0000001dff1c7212ULL, 0x000fc400078e33ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x0000000817067824ULL, 0x000fe200078e00ffULL, 0x0000000c1e1e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8181c7812ULL, 0x000fe400078ee21cULL, 0xfffffff806067812ULL, 0x000fe400078ee217ULL,
0x000000031b187812ULL, 0x040fe200078e3cffULL, 0x000000101c1c7824ULL, 0x100fe200078e0203ULL,
0x000000041b197812ULL, 0x040fe200078e3cffULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x000000051b1a7812ULL, 0x000fe200078e3cffULL, 0x000000081d187824ULL, 0x000fc400078e0218ULL,
0x000000011e067824ULL, 0x000fe200078e0206ULL, 0x0000003005307220ULL, 0x044fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002d052d7220ULL, 0x000fe20000410000ULL, 0x0000001604167220ULL, 0x048fe20000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000000d040d7220ULL, 0x040fe20000410000ULL, 0x0000000c040c7220ULL, 0x040fe20000410000ULL,
0x0000000b040b7220ULL, 0x040fe20000410000ULL, 0x0000000a040a7220ULL, 0x040fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000000804087220ULL, 0x040fe20000410000ULL,
0x0000000704047220ULL, 0x000fe20000410000ULL, 0x0000000717077812ULL, 0x000fe200078ec0ffULL,
0x0000002c052c7220ULL, 0x000fe20000410000ULL, 0x0000000a0909723eULL, 0x000fe200000010ffULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x000000080404723eULL, 0x000fe200000010ffULL,
0x0000002a052a7220ULL, 0x000fe20000410000ULL, 0x0000000107087812ULL, 0x000fe200078e3cffULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x0000000c0b0b723eULL, 0x000fe200000010ffULL,
0x0000002805287220ULL, 0x000fe20000410000ULL, 0x00000002070a7812ULL, 0x000fe200078e3cffULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fe200000010ffULL,
0x0000002605267220ULL, 0x000fe20000410000ULL, 0x00000003070c7812ULL, 0x000fe200078e3cffULL,
0x0000002505257220ULL, 0x000fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000002405247220ULL, 0x000fe20000410000ULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x0000002305237220ULL, 0x000fe20000410000ULL, 0x00000004070e7812ULL, 0x000fe200078e3cffULL,
0x0000002205227220ULL, 0x000fe20000410000ULL, 0x0000000507107812ULL, 0x000fe200078e3cffULL,
0x0000002105057220ULL, 0x000fe20000410000ULL, 0x0000000607127812ULL, 0x000fe200078e3cffULL,
0x0000000817077824ULL, 0x000fe200078e0208ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000000817087824ULL, 0x000fe200078e020aULL, 0x000000302f2f723eULL, 0x000fe200000010ffULL,
0x00000008170a7824ULL, 0x000fe200078e020cULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x00000008170c7824ULL, 0x000fe200078e020eULL, 0x0000002e2d2d723eULL, 0x000fe200000010ffULL,
0x000000081d147824ULL, 0x000fe200078e00ffULL, 0x0000002c2b2b723eULL, 0x000fe200000010ffULL,
0x00000008170e7824ULL, 0x000fe200078e0210ULL, 0x0000002a2929723eULL, 0x000fe200000010ffULL,
0x0000000817107824ULL, 0x000fe200078e0212ULL, 0x000000011b127812ULL, 0x000fe200078e3cffULL,
0x0000001007077824ULL, 0x100fe200078e0203ULL, 0x000000021b177812ULL, 0x040fe200078e3cffULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0xfffffff814147812ULL, 0x000fe200078ee21dULL,
0x000000100a0a7824ULL, 0x100fe200078e0203ULL, 0x000000061b1b7812ULL, 0x000fe200078e3cffULL,
0x000000100c0c7824ULL, 0x100fe200078e0203ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x000000081d167824ULL, 0x000fe200078e0212ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0203ULL, 0x0000002f06007388ULL, 0x0005e20000000800ULL,
0x000000011e077824ULL, 0x000fe200078e0207ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x000000081d177824ULL, 0x000fe200078e0217ULL, 0x000000220505723eULL, 0x000fe200000010ffULL,
0x0000001010107824ULL, 0x000fe200078e0203ULL, 0x0000002d07007388ULL, 0x0005e20000000800ULL,
0x000000011e087824ULL, 0x000fc400078e0208ULL, 0x000000101f127824ULL, 0x000fe400078e0203ULL,
0x000000011e0a7824ULL, 0x000fe200078e020aULL, 0x0000002b08007388ULL, 0x0005e20000000800ULL,
0x000000081d197824ULL, 0x040fe400078e0219ULL, 0x0000001014147824ULL, 0x000fe200078e0203ULL,
0x000000290a007388ULL, 0x0005e20000000800ULL, 0x000000011e0c7824ULL, 0x000fe400078e020cULL,
0x000000081d1a7824ULL, 0x000fc400078e021aULL, 0x0000001016167824ULL, 0x000fe200078e0203ULL,
0x000000270c007388ULL, 0x0005e20000000800ULL, 0x000000011e0e7824ULL, 0x040fe400078e020eULL,
0x000000081d1b7824ULL, 0x000fe400078e021bULL, 0x0000001017177824ULL, 0x100fe200078e0203ULL,
0x000000250e007388ULL, 0x0005e20000000800ULL, 0x000000011e107824ULL, 0x000fe400078e0210ULL,
0x0000001018187824ULL, 0x000fc400078e0203ULL, 0x000000011e127824ULL, 0x040fe200078e0212ULL,
0x0000002310007388ULL, 0x0005e20000000800ULL, 0x0000001019197824ULL, 0x100fe400078e0203ULL,
0x000000011e147824ULL, 0x000fe200078e0214ULL, 0x0000000512007388ULL, 0x0005e20000000800ULL,
0x000000101a1a7824ULL, 0x100fe400078e0203ULL, 0x000000011e167824ULL, 0x000fe200078e0216ULL,
0x0000001514007388ULL, 0x0005e20000000800ULL, 0x000000101b1b7824ULL, 0x000fc400078e0203ULL,
0x000000011e177824ULL, 0x040fe200078e0217ULL, 0x0000001316007388ULL, 0x0005e20000000800ULL,
0x000000011e187824ULL, 0x040fe400078e0218ULL, 0x000000011e197824ULL, 0x040fe200078e0219ULL,
0x0000001117007388ULL, 0x0005e20000000800ULL, 0x000000011e1a7824ULL, 0x040fe400078e021aULL,
0x000000011e1b7824ULL, 0x040fe200078e021bULL, 0x0000000f18007388ULL, 0x0005e20000000800ULL,
0x000000011e1c7824ULL, 0x000fc600078e021cULL, 0x0000000d19007388ULL, 0x0005e80000000800ULL,
0x0000000b1a007388ULL, 0x0005e80000000800ULL, 0x000000091b007388ULL, 0x0005e80000000800ULL,
0x000000041c007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002000117810ULL, 0x004fe20007ffe0ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x00000003ff037819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff057819ULL, 0x100fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000703047812ULL, 0x000fe200078e4800ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000705067812ULL, 0x000fc400078e4811ULL, 0x0ffffff804047812ULL, 0x000fe400078ef800ULL,
0x0ffffff806067812ULL, 0x000fe400078ef811ULL, 0x0000000700107812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x100fe400078e0202ULL, 0x0000001006067824ULL, 0x000fc600078e0202ULL,
0x00a0000004087984ULL, 0x000f280000000c00ULL, 0x00a00000060c7984ULL, 0x0023620000000c00ULL,
0x0000000807027824ULL, 0x044fe400078e00ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe4000f8e023fULL, 0xfffffff802037812ULL, 0x000fc400078ee203ULL,
0xfffffff807057812ULL, 0x000fe400078ee205ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000711067812ULL, 0x002fe200078ec0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fe200078048ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078248ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff810007812ULL, 0x000fe400078ef83dULL,
0x00005b0005057a11ULL, 0x000fe400008f4c07ULL, 0x1ffffff806067812ULL, 0x000fe200078ef83dULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001006047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x010fe8000c101d06ULL, 0x0000000c04007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff2c7819ULL, 0x000fe2000001163aULL,
0xffffffffff2d7424ULL, 0x000fc800078e00ffULL, 0x00000002382c7824ULL, 0x000fca00078e022cULL,
0x000000032c00720cULL, 0x000fda0003f06070ULL, 0x0000000233048824ULL, 0x000fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e022cULL, 0x0000600004048625ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006042d8981ULL, 0x0002a2000c1e1900ULL,
0x0000000138007810ULL, 0x000fc80007ffe0ffULL, 0x000000020000720cULL, 0x000fe20003f06070ULL,
0x000000403a2e7824ULL, 0x000fe400078e00ffULL, 0x00006800ff047624ULL, 0x002fe400078e00ffULL,
0x00006900ff057624ULL, 0x000fe400078e00ffULL, 0x000000803b3b7824ULL, 0x000fe400078e00ffULL,
0x0000010038077824ULL, 0x000fe200078e022eULL, 0x0000000604327981ULL, 0x000362000c1e9900ULL,
0x000000802f2f7824ULL, 0x000fc600078e00ffULL, 0x000000403b177812ULL, 0x000fe200078ef807ULL,
0x01060000ff047f8cULL, 0x002e62000c80043fULL, 0x0000002f2d187224ULL, 0x004fe200078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fe4000001163cULL,
0x0000000739007217ULL, 0x000fe40007800000ULL, 0x0000001014197810ULL, 0x040fe20007ffe0ffULL,
0x0000000114067824ULL, 0x040fe200078e0217ULL, 0x0000000814157810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a07ULL, 0x00000018141a7810ULL, 0x000fc40007ffe0ffULL,
0x00000006180f7210ULL, 0x000fe20007f1e0ffULL, 0x0000000115067824ULL, 0x100fe200078e0217ULL,
0x000000300b167812ULL, 0x000fe200078ec0ffULL, 0x000000011a087824ULL, 0x000fe200078e0217ULL,
0x00000003ff0c7819ULL, 0x000fe2000001163cULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e000f097a11ULL, 0x040fe400078040ffULL, 0x0000000818087210ULL, 0x040fe40007f5e0ffULL,
0x00005f000f0f7a11ULL, 0x000fe200000f4407ULL, 0x0000000119077824ULL, 0x000fe200078e0217ULL,
0x0000000618067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x00005e0008107a11ULL, 0x000fc400078440ffULL, 0x0000000718077210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x00005e00060e7a11ULL, 0x000fe400078040ffULL,
0x000000030c0c7812ULL, 0x000fe200078e483cULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00005e00070a7a11ULL, 0x040fe400078240ffULL, 0x00005f0006137a11ULL, 0x000fe400000f4413ULL,
0x00005f0007127a11ULL, 0x000fc400008f4412ULL, 0x000000001500720cULL, 0x0c0fe20003f26070ULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0x0000000916067210ULL, 0x000fe40007f7e0ffULL,
0x000000001400720cULL, 0x000fe40003f06070ULL, 0x00005f0008117a11ULL, 0x000fe200010f4411ULL,
0x000000ffff077224ULL, 0x000fe200018e060fULL, 0x000020003a0d7811ULL, 0x000fe400078e68ffULL,
0x0ffffffc0c3c7812ULL, 0x000fc400078ef83cULL, 0xfffffffc15097812ULL, 0x000fe400078ee20cULL,
0x000000160e087210ULL, 0x000fe20007f7e0ffULL, 0x000000103c3c7824ULL, 0x100fe200078e020dULL,
0x000000001900720cULL, 0x000fe20003f46070ULL, 0x00000010090e7824ULL, 0x000fe200078e020dULL,
0x000000160a0a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200018e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000063c7faeULL, 0x0003e2000c101c46ULL,
0x0000000419197824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0612ULL,
0x00000000080e7faeULL, 0x0005e2000c901c46ULL, 0x000000001a00720cULL, 0x000fc40003f86070ULL,
0xfffffffc190f7812ULL, 0x000fca00078ee20cULL, 0x000000100f0f7824ULL, 0x000fe200078e020dULL,
0x0000002014097810ULL, 0x004fe20007ffe0ffULL, 0x000000041a087824ULL, 0x000fc600078e00ffULL,
0x000000000a0f7faeULL, 0x0005e2000d101c46ULL, 0x000000000900720cULL, 0x000fe20003f66070ULL,
0x0000000117067824ULL, 0x002fe200078e0209ULL, 0xfffffffc08087812ULL, 0x000fc800078ee20cULL,
0x0000000618157210ULL, 0x000fe20007f1e0ffULL, 0x0000001008087824ULL, 0x000fe200078e020dULL,
0x0000001610067210ULL, 0x000fe40007fbe0ffULL, 0x00000028140a7810ULL, 0x044fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00000030140b7810ULL, 0x040fe40007ffe0ffULL,
0x00000038140f7810ULL, 0x000fe40007ffe0ffULL, 0x00005e0015147a11ULL, 0x000fe200078c40ffULL,
0x00000001170e7824ULL, 0x040fe200078e020bULL, 0x000000000a00720cULL, 0x080fe20003f46070ULL,
0x0000000117107824ULL, 0x000fe200078e020fULL, 0x00005f0015157a11ULL, 0x000fe200030f4407ULL,
0x000000ffff077224ULL, 0x000fe200028e0611ULL, 0x000000000b00720cULL, 0x000fc40003f26070ULL,
0x000000000f00720cULL, 0x000fe20003f06070ULL, 0x0000000117007824ULL, 0x000fe200078e020aULL,
0x0000000006087faeULL, 0x0003e2000e101c46ULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000e18127210ULL, 0x040fe40007f9e0ffULL, 0x0000000018137210ULL, 0x040fe20007fbe0ffULL,
0x0000000409007824ULL, 0x000fe200078e00ffULL, 0x0000001018117210ULL, 0x000fc60007fde0ffULL,
0x000000ffff097224ULL, 0x000fe200028e06ffULL, 0xfffffffc00007812ULL, 0x100fe200078ee20cULL,
0x000000040a067824ULL, 0x002fe200078e00ffULL, 0x00005e0013087a11ULL, 0x000fe200078a40ffULL,
0x000000040b077824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e06ffULL,
0xfffffffc06067812ULL, 0x100fe200078ee20cULL, 0x0000001000007824ULL, 0x000fe200078e020dULL,
0xfffffffc07077812ULL, 0x000fe400078ee20cULL, 0x00005f0013097a11ULL, 0x000fe200028f4409ULL,
0x00000010060e7824ULL, 0x000fe200078e020dULL, 0x0000001614067210ULL, 0x000fc40007fbe0ffULL,
0xfffffffc0f0c7812ULL, 0x000fe200078ee20cULL, 0x00000010070f7824ULL, 0x000fe200078e020dULL,
0x00005e00120a7a11ULL, 0x000fe200078840ffULL, 0x000000ffff077224ULL, 0x000fe200028e0615ULL,
0x0000001608087210ULL, 0x080fe20007fbe0ffULL, 0x000000100c107824ULL, 0x000fe200078e020dULL,
0x00005f00120b7a11ULL, 0x000fe200020f440bULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x00005e00110c7a11ULL, 0x040fe200078c40ffULL, 0x000000ffff097224ULL, 0x000fe200028e0609ULL,
0x000000160a0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000006007faeULL, 0x0003e2000d901c46ULL,
0x00005f00110d7a11ULL, 0x000fc400030f440dULL, 0x000000160c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x00000000080e7faeULL, 0x0003e6000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x000000000a0f7faeULL, 0x0003e8000c901c46ULL,
0x000000000c107faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x000000173c007211ULL, 0x042fe400078ff0ffULL, 0x000000103c067811ULL, 0x000fc400078ff0ffULL,
0x0000000018007210ULL, 0x000fe40007f1e0ffULL, 0x000000083c147811ULL, 0x040fe200078ff0ffULL,
0x0000000117077824ULL, 0x040fe200078e0206ULL, 0x000000183c087811ULL, 0x000fe200078ff0ffULL,
0x000000ffff237224ULL, 0x000fe200000e06ffULL, 0x00005e0000227a11ULL, 0x000fe200078040ffULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x000000203c0a7811ULL, 0x000fe200078ff0ffULL,
0x0000000117097824ULL, 0x040fe200078e0208ULL, 0x00005f0000237a11ULL, 0x000fe200000f4423ULL,
0x0000000114007824ULL, 0x000fe200078e0217ULL, 0x00000003ff137819ULL, 0x000fe2000001163cULL,
0x00000001170c7824ULL, 0x000fe200078e020aULL, 0x00000007181f7210ULL, 0x000fe20007fbe0ffULL,
0x0000000408077824ULL, 0x000fe200078e00ffULL, 0x000000283c0d7811ULL, 0x000fe200078ff0ffULL,
0x000000040a087824ULL, 0x000fe200078e00ffULL, 0x0000000018217210ULL, 0x000fe20007fde0ffULL,
0x0000000414007824ULL, 0x000fe200078e00ffULL, 0x0000000313137812ULL, 0x000fe200078e483cULL,
0x00000001170e7824ULL, 0x000fe200078e020dULL, 0x000000303c0f7811ULL, 0x000fc400078ff0ffULL,
0x000000383c117811ULL, 0x000fe400078ff0ffULL, 0x00000009181e7210ULL, 0x000fe20007f1e0ffULL,
0x000000040d097824ULL, 0x000fe200078e00ffULL, 0x000020003a197811ULL, 0x000fe200078e68ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee213ULL,
0x000000040f0a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc07077812ULL, 0x000fe200078ee213ULL,
0x0000000117107824ULL, 0x040fe200078e020fULL, 0x0000000c181c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000117127824ULL, 0x000fe200078e0211ULL, 0x00005e0021207a11ULL, 0x000fe200078c40ffULL,
0x00000004110c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc08087812ULL, 0x000fe200078ee213ULL,
0x00000010060f7824ULL, 0x000fe200078e0219ULL, 0x00005f0021217a11ULL, 0x000fe200030f440dULL,
0x0000001007117824ULL, 0x000fe200078e0219ULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee213ULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00005e001e1d7a11ULL, 0x000fe200078040ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e001c0d7a11ULL, 0x000fe200078240ffULL,
0x0000001008167824ULL, 0x000fe200078e0219ULL, 0x000000300b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fe200028e06ffULL, 0x0000000e180e7210ULL, 0x000fc40007f5e0ffULL,
0xfffffffc09097812ULL, 0x000fe400078ee213ULL, 0x0000001018107210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e06ffULL, 0x0000001218127210ULL, 0x000fe20007f9e0ffULL,
0x000000100a187824ULL, 0x000fe200078e0219ULL, 0x00005f001e1e7a11ULL, 0x000fe200000f4407ULL,
0x0000001009177824ULL, 0x000fe200078e0219ULL, 0x00005f001c1c7a11ULL, 0x000fe200008f4406ULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x000000220b067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x00005e001f0a7a11ULL, 0x000fc400078a40ffULL,
0x0ffffffc133c7812ULL, 0x000fe200078ef83cULL, 0x000000ffff077224ULL, 0x000fe200000e0623ULL,
0xfffffffc00007812ULL, 0x100fe400078ee213ULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee213ULL,
0x000000103c3c7824ULL, 0x100fe200078e0219ULL, 0x00005e000e097a11ULL, 0x000fe200078240ffULL,
0x0000001000007824ULL, 0x100fe200078e0219ULL, 0x00005e0010137a11ULL, 0x000fe200078440ffULL,
0x000000100c197824ULL, 0x000fe200078e0219ULL, 0x00005f001f1f7a11ULL, 0x000fe200028f4408ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000063c7faeULL, 0x0003e2000b901c46ULL,
0x000000200b087210ULL, 0x000fc40007f1e0ffULL, 0x00005e0012147a11ULL, 0x000fe400078640ffULL,
0x00005f000e1b7a11ULL, 0x000fe400008f441bULL, 0x00005f00101a7a11ULL, 0x000fe400010f441aULL,
0x0000000a0b0a7210ULL, 0x040fe40007f3e0ffULL, 0x0000001d0b0c7210ULL, 0x040fe40007f5e0ffULL,
0x000000090b107210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0621ULL,
0x00005f0012157a11ULL, 0x000fc400018f4415ULL, 0x0000000d0b0e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061eULL, 0x000000130b127210ULL, 0x040fe20007fbe0ffULL,
0x0000000008007faeULL, 0x0003e2000b901c46ULL, 0x000000140b147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe400008e061fULL, 0x000000ffff137224ULL, 0x000fe400028e061aULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x000000000a0f7faeULL, 0x0005e8000b901c46ULL,
0x000000000c117faeULL, 0x0007e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x004fc400018e061cULL,
0x000000ffff117224ULL, 0x008fc600020e061bULL, 0x000000000e167faeULL, 0x0003e8000b901c46ULL,
0x0000000010177faeULL, 0x0003e8000b901c46ULL, 0x0000000012187faeULL, 0x0003e8000b901c46ULL,
0x0000000014197faeULL, 0x0003e4000b901c46ULL, 0x01060400ff007984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x01060400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x000000203a007824ULL, 0x002fc800078e0200ULL,
0x0000002000057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x000001e005057812ULL, 0x000fe400078ec0ffULL,
0x0000000104077812ULL, 0x040fe400078efcffULL, 0x0000000704067812ULL, 0x140fe400078e7800ULL,
0x0000000707077812ULL, 0x000fe400078e7800ULL, 0x0000001004107810ULL, 0x040fe20007ffe0ffULL,
0x0000000105067824ULL, 0x040fe200078e0206ULL, 0x0000001104047810ULL, 0x000fe20007ffe0ffULL,
0x0000000105077824ULL, 0x000fe200078e0207ULL, 0x0000000710107812ULL, 0x000fc400078e7800ULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000000704047812ULL, 0x000fe400078e7800ULL,
0x0000000105107824ULL, 0x040fe200078e0210ULL, 0x0000000007087984ULL, 0x000ea4000000cc00ULL,
0x0000000105047824ULL, 0x000fe400078e0204ULL, 0x000000ffff147224ULL, 0x002fe400078e000cULL,
0x000000ffff157224ULL, 0x000fc400078e000eULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff187224ULL, 0x000fe400078e000dULL,
0x000000ffff197224ULL, 0x000fe200078e000fULL, 0x0000001406007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1b7224ULL, 0x000fca00078e000bULL,
0x0000001807007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x00000000100c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000aULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1c7224ULL, 0x004fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000001c10007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff047f8cULL, 0x002fe8000c80043fULL,
0x01060400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x01060400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000023800720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000317919ULL, 0x000e620000000000ULL, 0x3d80000032327820ULL, 0x020fe20000410000ULL,
0x0000640033337a24ULL, 0x000fe200078e02ffULL, 0x000106883a347811ULL, 0x000fe200078e18ffULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0xffffffff02357810ULL, 0x000fe40007ffe0ffULL,
0x000106083a367811ULL, 0x000fe400078e28ffULL, 0x0000010038307824ULL, 0x000fe200078e022eULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000303900720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x03cfea0003800000ULL, 0x000000ffff007224ULL, 0x000fe200078e0037ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fc4000001ff00ULL, 0x000000013c257810ULL, 0x000fe20007ffe0ffULL,
0x00000d9000007945ULL, 0x000fe20003800000ULL, 0x0000000100377812ULL, 0x000fe200078e0cffULL,
0x0000002f2d477224ULL, 0x020fe200078e02ffULL, 0x00000002ff247819ULL, 0x000fc40000011625ULL,
0x000000042500780cULL, 0x040fe40003f06070ULL, 0x0000000325557812ULL, 0x000fe200078ec0ffULL,
0x0000030024267a24ULL, 0x000fe400078e0238ULL, 0x000000ffff247224ULL, 0x000fe400078e003cULL,
0x0000010026407824ULL, 0x040fe200078e022eULL, 0x0000000126277810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3c7224ULL, 0x000fc600078e0025ULL, 0x000000022700720cULL, 0x000fe40003f26070ULL,
0x0000004040267812ULL, 0x000fca00078ec0ffULL, 0x000000013b417824ULL, 0x000fcc00078e0226ULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff427819ULL, 0x002fe20000011631ULL,
0x000000023a487824ULL, 0x000fc600078e0237ULL, 0x00000010424f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000142257824ULL, 0x140fe200078e0241ULL, 0x0000000842447810ULL, 0x040fe40007ffe0ffULL,
0x0000001842507810ULL, 0x000fe20007ffe0ffULL, 0x000000014f277824ULL, 0x100fe200078e0241ULL,
0x00000025473f7210ULL, 0x000fe20007f3e0ffULL, 0x0000000144267824ULL, 0x040fe200078e0241ULL,
0x0000004039257217ULL, 0x000fe20007800000ULL, 0x00000004444a7824ULL, 0x000fe200078e00ffULL,
0x00000027472b7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x0000002647297210ULL, 0x000fe20007f5e0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a40ULL,
0x00005e003f267a11ULL, 0x000fe200078240ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078640ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x00005e0029287a11ULL, 0x000fc400078440ffULL, 0x00005f002b2b7a11ULL, 0x000fe200018f443dULL,
0x00000001503d7824ULL, 0x100fe200078e0241ULL, 0x0000002042517810ULL, 0x040fe40007ffe0ffULL,
0x0000002842527810ULL, 0x040fe40007ffe0ffULL, 0x0000003042537810ULL, 0x040fe40007ffe0ffULL,
0x0000003842547810ULL, 0x000fe40007ffe0ffULL, 0x00005f0029297a11ULL, 0x000fe200010f443eULL,
0x00000001513e7824ULL, 0x000fe200078e0241ULL, 0x00005f003f277a11ULL, 0x000fe200008f4427ULL,
0x00000001523f7824ULL, 0x100fe200078e0241ULL, 0x000000254200720cULL, 0x000fe20003f46070ULL,
0x0000000153407824ULL, 0x100fe200078e0241ULL, 0x0000003d47427210ULL, 0x040fe20007f3e0ffULL,
0x00000001543d7824ULL, 0x000fe200078e0241ULL, 0x0000003e47417210ULL, 0x000fc40007fbe0ffULL,
0x0000003f47437210ULL, 0x040fe20007fde0ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x0000004047457210ULL, 0x040fe40007f9e0ffULL, 0x0000003d47477210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200030e06ffULL, 0x00000003ff3d7819ULL, 0x100fe20000011631ULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x00005e00423e7a11ULL, 0x040fe200078240ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x000000033d4e7812ULL, 0x000fe200078e4831ULL,
0x000000ffff3d7224ULL, 0x000fe200028e06ffULL, 0x00005f00423f7a11ULL, 0x000fe200008f443fULL,
0x0000000455427824ULL, 0x000fe200078e00ffULL, 0x00005e0041407a11ULL, 0x000fc400078a40ffULL,
0x000000254400720cULL, 0x000fe40003f26070ULL, 0x00005f0041417a11ULL, 0x000fe400028f443dULL,
0x0000200048487811ULL, 0x000fe400078e60ffULL, 0x0ffffffc4e497812ULL, 0x100fe400078ef831ULL,
0xfffffffc423d7812ULL, 0x000fe400078ee231ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0x00005e0043427a11ULL, 0x000fe200078a40ffULL,
0x000000103d267825ULL, 0x000fe200078e0026ULL, 0x00005e0045447a11ULL, 0x000fc400078640ffULL,
0x00005e0047467a11ULL, 0x000fe200078840ffULL, 0x000000104a4a7824ULL, 0x000fe200078e0248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026497faeULL, 0x0003e2000d101c46ULL,
0x000000103d287825ULL, 0x000fe200078e0028ULL, 0x00005f0043437a11ULL, 0x000fe400028f444dULL,
0x00005f0045457a11ULL, 0x000fe200018f444cULL, 0x00000004534c7824ULL, 0x000fe200078e00ffULL,
0x00005f0047477a11ULL, 0x000fe200020f444bULL, 0x00000000284a7faeULL, 0x0005e2000c901c46ULL,
0x000000254f00720cULL, 0x080fe20003f26070ULL, 0x00000004524b7824ULL, 0x000fe200078e00ffULL,
0x000000255000720cULL, 0x000fc40003f46070ULL, 0x000000255100720cULL, 0x080fe20003f66070ULL,
0x0000000450497824ULL, 0x002fe200078e00ffULL, 0x000000255200720cULL, 0x080fe20003f86070ULL,
0x000000103d267825ULL, 0x000fe200078e002aULL, 0x000000255300720cULL, 0x080fe40003fa6070ULL,
0x000000255400720cULL, 0x040fe20003fc6070ULL, 0x000000044f257824ULL, 0x000fe200078e00ffULL,
0xfffffffc49497812ULL, 0x100fe200078ee24eULL, 0x00000004514a7824ULL, 0x004fe200078e00ffULL,
0xfffffffc4b4b7812ULL, 0x100fe200078ee24eULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0xfffffffc25257812ULL, 0x000fe200078ee24eULL, 0x0000001049497824ULL, 0x000fe200078e0248ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee24eULL, 0x000000103d287825ULL, 0x000fe200078e003eULL,
0xfffffffc4c4c7812ULL, 0x000fc400078ee24eULL, 0xfffffffc544e7812ULL, 0x000fe200078ee24eULL,
0x0000001025257824ULL, 0x100fe400078e0248ULL, 0x000000104a4a7824ULL, 0x000fe400078e0248ULL,
0x000000103d2a7825ULL, 0x000fe200078e0040ULL, 0x0000000026257faeULL, 0x0003e6000c901c46ULL,
0x000000104b4b7824ULL, 0x000fe200078e0248ULL, 0x0000000028497faeULL, 0x0003e2000d101c46ULL,
0x000000103d3e7825ULL, 0x000fc600078e0042ULL, 0x000000002a4a7faeULL, 0x0003e2000d901c46ULL,
0x000000104c4c7824ULL, 0x000fe400078e0248ULL, 0x000000103d407825ULL, 0x040fe200078e0044ULL,
0x000000003e4b7faeULL, 0x0003e6000e101c46ULL, 0x000000104e487824ULL, 0x000fe200078e0248ULL,
0x00000000404c7faeULL, 0x0003e2000e901c46ULL, 0x000000103d427825ULL, 0x000fca00078e0046ULL,
0x0000000042487faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008312b7811ULL, 0x002fe200078ff0ffULL, 0x0000000455517824ULL, 0x000fe200078e00ffULL,
0x0000004131257211ULL, 0x040fe400078ff0ffULL, 0x00000010313d7811ULL, 0x000fe200078ff0ffULL,
0x000000012b267824ULL, 0x000fe200078e0241ULL, 0x0000002547277210ULL, 0x000fe20007f3e0ffULL,
0x000000042b457824ULL, 0x000fe200078e00ffULL, 0x00000018313e7811ULL, 0x000fe200078ff0ffULL,
0x000000043d467824ULL, 0x000fe200078e00ffULL, 0x0000002647257210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078240ffULL,
0x000000043e487824ULL, 0x000fe200078e00ffULL, 0x00000020313f7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x00005e0025287a11ULL, 0x000fc400078440ffULL,
0x00005f0027277a11ULL, 0x000fe200008f442aULL, 0x000000043f497824ULL, 0x000fe200078e00ffULL,
0x00005f0025297a11ULL, 0x000fe200010f4429ULL, 0x000000023a257824ULL, 0x000fe200078e0237ULL,
0x0000002831427811ULL, 0x000fe200078ff0ffULL, 0x000000013f2b7824ULL, 0x000fe200078e0241ULL,
0x0000003031437811ULL, 0x040fe400078ff0ffULL, 0x0000003831447811ULL, 0x000fe200078ff0ffULL,
0x00000004424a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff2a7819ULL, 0x000fe20000011631ULL,
0x00000004434b7824ULL, 0x000fe200078e00ffULL, 0x00002000254c7811ULL, 0x000fe200078e60ffULL,
0x000000013d257824ULL, 0x000fe200078e0241ULL, 0x000000032a407812ULL, 0x100fe200078e4831ULL,
0x00000004444d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc51517812ULL, 0x000fe200078ee231ULL,
0x000000013e2a7824ULL, 0x100fe200078e0241ULL, 0x0000002547257210ULL, 0x000fe20007f7e0ffULL,
0x00000001423d7824ULL, 0x100fe200078e0241ULL, 0xfffffffc46467812ULL, 0x100fe200078ee240ULL,
0x00000001433e7824ULL, 0x100fe200078e0241ULL, 0xfffffffc48487812ULL, 0x100fe200078ee240ULL,
0x00000001443f7824ULL, 0x000fe200078e0241ULL, 0xfffffffc45447812ULL, 0x000fe200078ee240ULL,
0x0000001051267825ULL, 0x000fe200078e0026ULL, 0xfffffffc49497812ULL, 0x000fc400078ee240ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee240ULL, 0x0000001048487824ULL, 0x000fe200078e024cULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee240ULL, 0x0000001049497824ULL, 0x000fe200078e024cULL,
0xfffffffc4d4d7812ULL, 0x000fe200078ee240ULL, 0x000000104a4a7824ULL, 0x100fe200078e024cULL,
0x0ffffffc40427812ULL, 0x000fe200078ef831ULL, 0x000000104b4b7824ULL, 0x100fe200078e024cULL,
0x0000002a47407210ULL, 0x040fe40007f5e0ffULL, 0x0000002b47417210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e06ffULL, 0x0000003d47437210ULL, 0x040fe20007f7e0ffULL,
0x0000001042527824ULL, 0x100fe200078e024cULL, 0x0000003e47457210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff507224ULL, 0x000fe200008e06ffULL, 0x0000003f47477210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e06ffULL, 0x00005e00252a7a11ULL, 0x040fe200078c40ffULL,
0x00000010463d7824ULL, 0x100fe200078e024cULL, 0x00005e00403e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff4f7224ULL, 0x000fe200018e06ffULL, 0x00005f00252b7a11ULL, 0x000fe200030f442bULL,
0x0000001044257824ULL, 0x100fe200078e024cULL, 0x00005f00403f7a11ULL, 0x000fe200010f443fULL,
0x000000104d4c7824ULL, 0x000fe200078e024cULL, 0x00005e0041407a11ULL, 0x000fe200078240ffULL,
0x000000ffff4e7224ULL, 0x000fe200020e06ffULL, 0x00005e0043427a11ULL, 0x000fe200078440ffULL,
0x000000ffff4d7224ULL, 0x000fe200028e06ffULL, 0x00005e0045447a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026527faeULL, 0x0003e2000b901c46ULL,
0x00005e0047467a11ULL, 0x000fc400078840ffULL, 0x00005f0041417a11ULL, 0x000fe400008f4450ULL,
0x00005f0043437a11ULL, 0x000fe400010f444fULL, 0x00005f0045457a11ULL, 0x000fe400018f444eULL,
0x00005f0047477a11ULL, 0x000fe200020f444dULL, 0x0000001051267825ULL, 0x002fc800078e0028ULL,
0x0000001051287825ULL, 0x040fe200078e002aULL, 0x0000000026257faeULL, 0x0003e6000b901c46ULL,
0x00000010512a7825ULL, 0x040fe200078e003eULL, 0x00000000283d7faeULL, 0x0003e6000b901c46ULL,
0x00000010513e7825ULL, 0x040fe200078e0040ULL, 0x000000002a487faeULL, 0x0003e6000b901c46ULL,
0x0000001051407825ULL, 0x040fe200078e0042ULL, 0x000000003e497faeULL, 0x0003e6000b901c46ULL,
0x0000001051427825ULL, 0x040fe200078e0044ULL, 0x00000000404a7faeULL, 0x0003e6000b901c46ULL,
0x0000001051447825ULL, 0x000fe200078e0046ULL, 0x00000000424b7faeULL, 0x0003e8000b901c46ULL,
0x00000000444c7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035500780cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x00000300ff257624ULL, 0x002fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000002252c7824ULL, 0x000fca00078e022cULL,
0x000000032c00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000233267824ULL, 0x000fe400078e022cULL, 0x00000004ff277424ULL, 0x000fc800078e00ffULL,
0x0000600026267625ULL, 0x000fca00078e0027ULL, 0x00000006262d7981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008243e7824ULL, 0x002fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff831247812ULL, 0x040fe200078ec0ffULL,
0x000000023a277824ULL, 0x000fe200078e0200ULL, 0x0000002031287810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000724247812ULL, 0x000fe400078ef831ULL,
0xfffffff828287812ULL, 0x000fc400078ec0ffULL, 0x00000001ff257819ULL, 0x000fe40000011624ULL,
0x00000007283f7812ULL, 0x000fe400078ef831ULL, 0x0000000325257812ULL, 0x000fe400078ec0ffULL,
0x0000200027277811ULL, 0x000fe400078e60ffULL, 0x0000003d25267212ULL, 0x000fe400078e3cffULL,
0x00000001ff287819ULL, 0x000fc4000001163fULL, 0x000000013d417810ULL, 0x000fe20007ffe0ffULL,
0x0000000424267824ULL, 0x000fe200078e0226ULL, 0x0000000328407812ULL, 0x000fe400078ec0ffULL,
0x0000004125257212ULL, 0x000fe200078e3cffULL, 0x0000001026267824ULL, 0x000fc800078e0227ULL,
0x0000000424257824ULL, 0x000fe200078e0225ULL, 0x000000002648783bULL, 0x0002a20000000200ULL,
0x0000003e31247211ULL, 0x000fe400078fe0ffULL, 0x0000001025427824ULL, 0x000fe200078e0227ULL,
0x000000043e3e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000224257810ULL, 0x000fe40007ffe0ffULL,
0x0000003d40267212ULL, 0x002fe400078e3cffULL, 0x000000023d3d7810ULL, 0x000fc60007ffe0ffULL,
0x000000043f267824ULL, 0x000fe200078e0226ULL, 0x000000043d00780cULL, 0x000fc60003f25270ULL,
0x0000001026267824ULL, 0x000fca00078e0227ULL, 0x000000002628783bULL, 0x0002e40000000200ULL,
0x0000000731267812ULL, 0x002fc800078ec0ffULL, 0x0000000826467812ULL, 0x000fe400078ef831ULL,
0x0000004140267212ULL, 0x000fe400078e3cffULL, 0x0000000724247812ULL, 0x100fe200078e7846ULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x0000000725257812ULL, 0x000fe200078e7846ULL,
0x000000043f267824ULL, 0x000fe200078e0226ULL, 0x00000010ff507819ULL, 0x004fe20000011648ULL,
0x00000020464f7824ULL, 0x000fe200078e0224ULL, 0x00000018ff3f7819ULL, 0x000fe20000011648ULL,
0x0000001026267824ULL, 0x000fe200078e0227ULL, 0x000000ff48477812ULL, 0x000fe200078ec0ffULL,
0x0000002046467824ULL, 0x000fe200078e0225ULL, 0x0000ffff48717812ULL, 0x000fc400078ec0ffULL,
0x00000010ff517819ULL, 0x100fe20000011649ULL, 0x000000002624783bULL, 0x000ea20000000200ULL,
0x00000018ff487819ULL, 0x000fe40000011649ULL, 0x000000ff494c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff49727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff527819ULL, 0x100fe4000001164aULL,
0x00000018ff497819ULL, 0x000fc4000001164aULL, 0x000000ff4a4d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4a737812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001164bULL,
0x00000010ff587819ULL, 0x108fe40000011628ULL, 0x00000018ff547819ULL, 0x000fe40000011628ULL,
0x000000ff28557812ULL, 0x000fc400078ec0ffULL, 0x0000ffff28847812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x000fe4000001164bULL, 0x000000ff4b4e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4b747812ULL, 0x000fe400078ec0ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x002fc40000011640ULL, 0x00000018ff4b7819ULL, 0x000fe20000011640ULL,
0x2000004aff607230ULL, 0x000fe20000004100ULL, 0x000000ff405e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff287819ULL, 0x104fe40000011624ULL,
0x00000018ff7b7819ULL, 0x000fe40000011624ULL, 0x000000ff247d7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff24457812ULL, 0x000fe400078ec0ffULL, 0x00000008ff247819ULL, 0x000fe40000011671ULL,
0x000000ff426d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff447819ULL, 0x100fe40000011625ULL,
0x00000018ff7e7819ULL, 0x000fe40000011625ULL, 0x000000ff257f7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff25407812ULL, 0x000fe400078ec0ffULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000008ff257819ULL, 0x000fe40000011672ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000006dff4a723eULL, 0x000fe200020006ffULL, 0x20000024ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff43707812ULL, 0x000fe200078ec0ffULL, 0x2000004cff6b7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fc40000011673ULL, 0x00000070ff4c723eULL, 0x000fe200020006ffULL,
0x20000025ff707230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000008ff257819ULL, 0x000fe20000011674ULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x100fe2000001162aULL, 0x20000024ff727230ULL, 0x000fe20000004100ULL,
0x00000018ff597819ULL, 0x000fe4000001162aULL, 0x000000ff2a5a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff2a627812ULL, 0x000fe400078ec0ffULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x0000003fff2a723eULL, 0x000fe200020006ffULL,
0x20000025ff747230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe40000011685ULL,
0x0000ffff41867812ULL, 0x000fe200078ec0ffULL, 0x2000002aff6f7230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x000000ff29577812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001162bULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000008ff257819ULL, 0x000fe40000011686ULL, 0x0000ffff42877812ULL, 0x000fe400078ec0ffULL,
0x00000047ff47723eULL, 0x000fc400020006ffULL, 0x0000004eff2a723eULL, 0x000fe400020006ffULL,
0x0000005eff4e723eULL, 0x000fe200020006ffULL, 0x2000005dff5e7230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fe20000011641ULL, 0x20000024ff5d7230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x20000047ff6c7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x20000057ff7a7230ULL, 0x000fe20000004100ULL,
0x00000018ff567819ULL, 0x000fe20000011629ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe20000011687ULL, 0x20000025ff577230ULL, 0x000fe20000004100ULL,
0x0000ffff43887812ULL, 0x000fc400078ec0ffULL, 0x0000005fff47723eULL, 0x000fe200020006ffULL,
0x2000005bff5f7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000024ff5b723eULL, 0x000fe200020006ffULL, 0x000000104f247824ULL, 0x000fe200078e00ffULL,
0x00000008ff257819ULL, 0x000fe20000011688ULL, 0x20000056ff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff617819ULL, 0x000fe20000011641ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x000000ff41667812ULL, 0x000fe200078ec0ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fc40000011642ULL, 0x00000018ff677819ULL, 0x000fe40000011642ULL,
0x00000010ff787819ULL, 0x100fe40000011643ULL, 0x00000018ff6e7819ULL, 0x000fe40000011643ULL,
0x00000010ff3f7819ULL, 0x100fe40000011626ULL, 0x00000018ff807819ULL, 0x000fe40000011626ULL,
0x000000ff26817812ULL, 0x000fc400078ec0ffULL, 0x0000ffff26417812ULL, 0x000fe400078ec0ffULL,
0x00000010ff427819ULL, 0x100fe40000011627ULL, 0x00000018ff827819ULL, 0x000fe40000011627ULL,
0x000000ff27837812ULL, 0x040fe400078ec0ffULL, 0x0000ffff27437812ULL, 0x000fe400078ec0ffULL,
0x00000025ff56723eULL, 0x000fc400020006ffULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x000000ff50507812ULL, 0x000fe400078ec0ffULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x2000004dff647230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fe20000011629ULL, 0x2000004bff4d7230ULL, 0x000fe20000004100ULL,
0x0000006eff4b723eULL, 0x000fe200020006ffULL, 0x20000050ff6e7230ULL, 0x000fe20000004100ULL,
0x0000ffff29697812ULL, 0x000fc400078ec0ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000007bff4f723eULL, 0x000fe400020006ffULL,
0x000000ff687b7812ULL, 0x000fe200078ec0ffULL, 0x20000048ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff2b5c7812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000008ff687819ULL, 0x000fc40000011669ULL,
0x000000ff52527812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff697819ULL, 0x000fe4000001166eULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000055ff55723eULL, 0x000fc400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000066ff48723eULL, 0x000fe200020006ffULL,
0x20000059ff667230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x20000055ff767230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000049ff657230ULL, 0x000fe20000004100ULL, 0x000000ff61617812ULL, 0x000fe200078ec0ffULL,
0x20000054ff797230ULL, 0x000fe20000004100ULL, 0x00000068ff6e723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fc400020006ffULL,
0x000010546f697816ULL, 0x000fe20000000069ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x000010546d687816ULL, 0x000fe2000000006cULL, 0x20000052ff737230ULL, 0x000fe20000004100ULL,
0x000000ff53537812ULL, 0x000fe400078ec0ffULL, 0x000000ff77777812ULL, 0x000fe400078ec0ffULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x00000068240c723cULL, 0x002fe2000004180cULL,
0x000000ff58597812ULL, 0x000fc400078ec0ffULL, 0x00000008ff587819ULL, 0x000fe40000011684ULL,
0x00000061ff55723eULL, 0x000fe200020006ffULL, 0x2000005cff617230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe4000001162bULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000077ff5c723eULL, 0x000fe400020006ffULL,
0x00000078ff54723eULL, 0x000fe200020006ffULL, 0x20000053ff757230ULL, 0x000fe20000004100ULL,
0x00000059ff78723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000058ff77723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x000000ff29687812ULL, 0x000fe200078ec0ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe20000011665ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011673ULL, 0x0000ffff2b2b7812ULL, 0x000fe400078ec0ffULL,
0x0000105429657816ULL, 0x000fe40000000065ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000008ff297819ULL, 0x000fe4000001162bULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff2b7819ULL, 0x000fe40000011678ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x000000ff51517812ULL, 0x000fc400078ec0ffULL, 0x0000105460757816ULL, 0x000fe40000000075ULL,
0x0000105474747816ULL, 0x000fe4000000002aULL, 0x00000029ff60723eULL, 0x000fe400020006ffULL,
0x00001054792b7816ULL, 0x000fe4000000002bULL, 0x00001054772a7816ULL, 0x000fe20000000076ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x000000ff28297812ULL, 0x000fe200078ec0ffULL,
0x0000001046287824ULL, 0x000fe200078e00ffULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x000000742420723cULL, 0x000fe20000041820ULL, 0x00000029ff46723eULL, 0x000fc400020006ffULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x20000051ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x0000002a241c723cULL, 0x000fe2000004181cULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000105472647816ULL, 0x000fe20000000064ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x000010546a717816ULL, 0x000fe20000000071ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x0000105470707816ULL, 0x000fc4000000006bULL, 0x00000067ff49723eULL, 0x000fe200020006ffULL,
0x2000005aff677230ULL, 0x000fe20000004100ULL, 0x000000642404723cULL, 0x040fe20000041804ULL,
0x000000ff44447812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x20000046ff647230ULL, 0x000fe20000004100ULL, 0x000000702408723cULL, 0x000fe20000041808ULL,
0x00000008ff467819ULL, 0x000fc40000011645ULL, 0x00000010ff6f7819ULL, 0x000fe4000001167bULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff457819ULL, 0x000fe40000011668ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000044ff65723eULL, 0x000fe400020006ffULL,
0x000010547c6f7816ULL, 0x000fc4000000006fULL, 0x000010546e6e7816ULL, 0x000fe2000000007aULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000105466637816ULL, 0x000fe40000000063ULL,
0x0000105462627816ULL, 0x000fe40000000067ULL, 0x000010545f457816ULL, 0x000fe20000000045ULL,
0x0000006e2414723cULL, 0x000fe20000041814ULL, 0x0000105460447816ULL, 0x000fe40000000061ULL,
0x00000010ff477819ULL, 0x000fc40000011647ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff577819ULL, 0x000fe20000011657ULL, 0x000000622418723cULL, 0x040fe20000041818ULL,
0x00000008ff407819ULL, 0x000fe40000011640ULL, 0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x000000ff42427812ULL, 0x000fe200078ec0ffULL,
0x000000442410723cULL, 0x000fe20000041810ULL, 0x00000008ff437819ULL, 0x000fc40000011643ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff257819ULL, 0x000fe40000011655ULL, 0x0000105457247816ULL, 0x000fe40000000048ULL,
0x0000105447257816ULL, 0x000fe40000000025ULL, 0x00000010ff277819ULL, 0x000fc4000001165cULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x0000007dff50723eULL, 0x000fe200020006ffULL,
0x000000242808723cULL, 0x002fe20000041808ULL, 0x0000007eff51723eULL, 0x000fe400020006ffULL,
0x0000007fff52723eULL, 0x000fe200020006ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000080ff53723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000082ff5a723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000081ff587230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000083ff597230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000041ff247230ULL, 0x000fe20000004100ULL,
0x0000105449277816ULL, 0x000fe20000000027ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000010545b267816ULL, 0x000fe2000000004aULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fc4000001164dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff4e7819ULL, 0x000fe2000001164eULL, 0x000000262804723cULL, 0x000fe20000041804ULL,
0x000010544d5f7816ULL, 0x000fe4000000005eULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff4c7819ULL, 0x000fc4000001164cULL,
0x00000010ff4d7819ULL, 0x000fe40000011654ULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff477819ULL, 0x000fe40000011664ULL, 0x00000010ff467819ULL, 0x000fc40000011646ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff417819ULL, 0x000fe40000011665ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff257819ULL, 0x000fc4000001163fULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff247819ULL, 0x000fe40000011624ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff277819ULL, 0x000fe40000011642ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff437819ULL, 0x000fc40000011643ULL,
0x000010545d5e7816ULL, 0x000fe4000000004eULL, 0x000010544b4d7816ULL, 0x000fe4000000004dULL,
0x00001054564c7816ULL, 0x000fe4000000004cULL, 0x000010544f477816ULL, 0x000fe20000000047ULL,
0x0000005e280c723cULL, 0x000fe2000004180cULL, 0x0000105446467816ULL, 0x000fe40000000050ULL,
0x0000105451417816ULL, 0x000fc40000000041ULL, 0x0000105440407816ULL, 0x000fe40000000052ULL,
0x0000105453257816ULL, 0x000fe20000000025ULL, 0x0000004c2820723cULL, 0x000fe20000041820ULL,
0x0000105424247816ULL, 0x000fe40000000058ULL, 0x000010545a277816ULL, 0x000fe40000000027ULL,
0x0000105443267816ULL, 0x000fc60000000059ULL, 0x00000046281c723cULL, 0x040ff0000004181cULL,
0x000000402814723cULL, 0x040ff00000041814ULL, 0x000000242818723cULL, 0x040ff00000041818ULL,
0x000000262810723cULL, 0x000fe20000041810ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe82000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff007224ULL, 0x000fe200078e0037ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd92000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000034247f8cULL, 0x000fe2000c80043fULL,
0x0000001c321c7220ULL, 0x040fe20000410000ULL, 0x0000001d321d7220ULL, 0x040fe20000410000ULL,
0x0000000e32267220ULL, 0x040fe20000410000ULL, 0x0000040034007984ULL, 0x000e620000000800ULL,
0x0000000f32277220ULL, 0x040fe20000410000ULL, 0x00000016323c7220ULL, 0x040fe20000410000ULL,
0x00000017323d7220ULL, 0x040fe20000410000ULL, 0x0000000c320c7220ULL, 0x040fe20000410000ULL,
0x0000000d320d7220ULL, 0x040fe20000410000ULL, 0x0000000a32287220ULL, 0x040fe20000410000ULL,
0x0000000b32297220ULL, 0x040fe20000410000ULL, 0x0000002032207220ULL, 0x040fe20000410000ULL,
0x0000002132217220ULL, 0x040fe20000410000ULL, 0x0000001e322a7220ULL, 0x040fe20000410000ULL,
0x0000001f322b7220ULL, 0x040fe20000410000ULL, 0x0000001832167220ULL, 0x040fe20000410000ULL,
0x0000001932177220ULL, 0x040fe20000410000ULL, 0x0000000832087220ULL, 0x040fe20000410000ULL,
0x0000000932097220ULL, 0x040fe20000410000ULL, 0x0000000432047220ULL, 0x040fe20000410000ULL,
0x0000000532057220ULL, 0x040fe20000410000ULL, 0x0000000632067220ULL, 0x040fe20000410000ULL,
0x0000000732077220ULL, 0x040fe20000410000ULL, 0x0000001a32187220ULL, 0x040fe20000410000ULL,
0x0000001b32197220ULL, 0x040fe20000410000ULL, 0x00000012323e7220ULL, 0x040fe20000410000ULL,
0x00000013323f7220ULL, 0x040fe20000410000ULL, 0x000000ffff127224ULL, 0x000fe200078e001cULL,
0x00000010321a7220ULL, 0x040fe20000410000ULL, 0x000000ffff137224ULL, 0x000fe200078e001dULL,
0x00000011321b7220ULL, 0x040fe20000410000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0026ULL,
0x0000002232227220ULL, 0x040fe20000410000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0027ULL,
0x0000002332237220ULL, 0x040fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000cULL,
0x0000001432147220ULL, 0x040fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e000dULL,
0x0000001532157220ULL, 0x000fe20000410000ULL, 0x000000ffff107224ULL, 0x000fc400078e0020ULL,
0x000000ffff117224ULL, 0x000fe400078e0021ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0028ULL,
0x8000000000ff7812ULL, 0x002fe20007804825ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0029ULL,
0x000000ffff267224ULL, 0x000fe400078e002aULL, 0x000000ffff277224ULL, 0x000fe400078e002bULL,
0x000000ffff0c7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0004ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0005ULL,
0x000000ffff207224ULL, 0x000fe400078e0006ULL, 0x000000ffff217224ULL, 0x000fe400078e0007ULL,
0x000000ffff287224ULL, 0x000fc400078e003cULL, 0x000000ffff297224ULL, 0x000fe400078e003dULL,
0x000000ffff2a7224ULL, 0x000fe400078e0018ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0019ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe400078e003eULL, 0x000000ffff3d7224ULL, 0x000fe200078e003fULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x0000040034047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000431197824ULL, 0x000fe200078e00ffULL, 0x000000353800720cULL, 0x000fc80003f05270ULL,
0xfffffff019187812ULL, 0x000fca00078ec0ffULL, 0x000000803a187824ULL, 0x000fca00078e0218ULL,
0x0104000018047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000231007824ULL, 0x000fe400078e00ffULL, 0x0000000139307824ULL, 0x000fc600078e0a30ULL,
0x0000000600007812ULL, 0x000fc800078ec0ffULL, 0x0000000100087812ULL, 0x040fe400078efcffULL,
0x0000000800097812ULL, 0x000fe400078efcffULL, 0x000000300800720cULL, 0x080fe40003f26070ULL,
0x0000001000087812ULL, 0x000fe400078efcffULL, 0x000000300900720cULL, 0x080fe40003f06070ULL,
0x000000300800720cULL, 0x000fc40003fc6070ULL, 0x0000001100097812ULL, 0x040fe400078efcffULL,
0x0000001800087812ULL, 0x040fe400078efcffULL, 0x000000300000720cULL, 0x080fe40003f46070ULL,
0x000000300900720cULL, 0x080fe40003fa6070ULL, 0x000000300800720cULL, 0x000fe40003f66070ULL,
0x0000000900247812ULL, 0x000fc400078efcffULL, 0x0000001900097812ULL, 0x040fe400078efcffULL,
0x0000002000087812ULL, 0x000fe400078efcffULL, 0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL,
0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff0b0b7808ULL, 0x000fc40004800000ULL, 0x000000302400720cULL, 0x080fe40003f86070ULL,
0x000000300900720cULL, 0x080fe40003f46070ULL, 0x000000300800720cULL, 0x000fe40003f26070ULL,
0x0000002100097812ULL, 0x040fe400078efcffULL, 0x0000002800087812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000300900720cULL, 0x080fe40003f06070ULL, 0x000000300800720cULL, 0x000fe40003f86070ULL,
0x0000002900097812ULL, 0x000fc400078efcffULL, 0x0000003000087812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000300900720cULL, 0x000fc40003fc6070ULL, 0x000000300800720cULL, 0x000fe40003fa6070ULL,
0x0000003100097812ULL, 0x040fe400078efcffULL, 0x0000003800087812ULL, 0x040fe400078efcffULL,
0x0000003900007812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff23237808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff26267808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000300900720cULL, 0x080fe40003f66070ULL,
0x000000300800720cULL, 0x000fc40003f46070ULL, 0x000000300000720cULL, 0x000fe40003f26070ULL,
0xff7fffff27277808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff28287808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff29297808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff3c3c7808ULL, 0x000fc40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff3d3d7808ULL, 0x000fe40004800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0x0000000a04047209ULL, 0x004fe20007810000ULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x0000001c05057209ULL, 0x000fe20007810000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x0000000b04047209ULL, 0x000fe40007810000ULL, 0x0000001d05057209ULL, 0x000fc40007810000ULL,
0x0000000c04047209ULL, 0x000fe40007810000ULL, 0x0000001e05057209ULL, 0x000fe40007810000ULL,
0x0000000d04047209ULL, 0x000fe40007810000ULL, 0x0000001f05057209ULL, 0x000fe40007810000ULL,
0x0000000e04047209ULL, 0x000fe40007810000ULL, 0x0000002005057209ULL, 0x000fc40007810000ULL,
0x0000000f04047209ULL, 0x000fe40007810000ULL, 0x0000002105057209ULL, 0x000fe40007810000ULL,
0x0000001004047209ULL, 0x000fe40007810000ULL, 0x0000002205057209ULL, 0x000fe40007810000ULL,
0x0000001104047209ULL, 0x000fe40007810000ULL, 0x0000002305057209ULL, 0x000fc40007810000ULL,
0x0000001204047209ULL, 0x000fe40007810000ULL, 0x0000002605057209ULL, 0x000fe40007810000ULL,
0x0000001304047209ULL, 0x000fe40007810000ULL, 0x0000002705057209ULL, 0x000fe40007810000ULL,
0x0000001404047209ULL, 0x000fe40007810000ULL, 0x0000002805057209ULL, 0x000fc40007810000ULL,
0x0000001504047209ULL, 0x000fe40007810000ULL, 0x0000002905057209ULL, 0x000fe40007810000ULL,
0x0000001604047209ULL, 0x000fe40007810000ULL, 0x0000002a05057209ULL, 0x000fe40007810000ULL,
0x0000001704047209ULL, 0x000fe40007810000ULL, 0x0000002b05057209ULL, 0x000fc40007810000ULL,
0x0000001a04047209ULL, 0x000fe40007810000ULL, 0x0000003c05057209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fe40007810000ULL, 0x0000003d05247209ULL, 0x000fe20007810000ULL,
0x00001ad27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0004007f89ULL, 0x0004e400000e0000ULL,
0x0000000004257209ULL, 0x00cfe20007810000ULL, 0x00001af27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0024007f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007057f89ULL, 0x000f2200000e0000ULL, 0x0000000024007209ULL, 0x004fc40007810000ULL,
0x0000000406067209ULL, 0x008fc60007810000ULL, 0x0c201f0000087f89ULL, 0x000ea200000e0000ULL,
0x0000000507077209ULL, 0x010fc60007810000ULL, 0x0c201f0025047f89ULL, 0x000ee800000e0000ULL,
0x0c201f0006097f89ULL, 0x000f2800000e0000ULL, 0x0c201f0007247f89ULL, 0x00026200000e0000ULL,
0x0000000800057209ULL, 0x004fe40007810000ULL, 0x0000000425047209ULL, 0x008fc40007810000ULL,
0x0000000906067209ULL, 0x010fc60007810000ULL, 0x3fb8aa3b04007820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000724077209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010800ULL, 0x0000000a00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010800ULL, 0x0000000c000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b1b007823ULL, 0x000fc80000010800ULL,
0x0000000e000c7308ULL, 0x000ff00000000800ULL, 0x00000010000e7308ULL, 0x000ff00000000800ULL,
0x0000001200107308ULL, 0x000ff00000000800ULL, 0x0000001400127308ULL, 0x000ff00000000800ULL,
0x0000001600147308ULL, 0x000ff00000000800ULL, 0x0000001a00167308ULL, 0x0003f00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b051a7820ULL, 0x002fc80000410000ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081aULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081aULL, 0x000000080b08723eULL, 0x004fe200000010ffULL,
0x0000001c00097308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b3d1a7823ULL, 0x000fc4000001081aULL, 0x0000001d001d7308ULL, 0x000ee20000000800ULL,
0x00000004ff1c7e24ULL, 0x004fe2000f8e00ffULL, 0x0000000a0d0a723eULL, 0x002fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x3f8000001c1c783eULL, 0x000fe400000010ffULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x000000091d09723eULL, 0x008fe200000010ffULL,
0x000000ffff1d7224ULL, 0x000fcc00078e001cULL, 0x0000000f000f7308ULL, 0x000ea20000000800ULL,
0x0000001e1f0b723eULL, 0x002fce00000010ffULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x0000000fff1f7424ULL, 0x000fe200078e00ffULL, 0x0000001c0840723cULL, 0x000fe200000418ffULL,
0x0000000c0f0c723eULL, 0x004fca00000010ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x0000000e110e723eULL, 0x002fce00000010ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x00000020210d723eULL, 0x004fce00000010ffULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x00000022230f723eULL, 0x002fce00000010ffULL, 0x0000001500157308ULL, 0x000e620000000800ULL,
0x0000001c0c40723cULL, 0x000fe20000041840ULL, 0x000000101310723eULL, 0x004fcc00000010ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000121512723eULL, 0x002fe400000010ffULL, 0xfffffffc31157812ULL, 0x000fc800078ec0ffULL,
0x000000151f1f7219ULL, 0x000fe200000006ffULL, 0x0000002800287308ULL, 0x000fe60000000800ULL,
0x000000001f1b73a1ULL, 0x000e6200000e8000ULL, 0x000000001f0473c4ULL, 0x000ee80000004000ULL,
0x0000002900297308ULL, 0x000f220000000800ULL, 0x000000262711723eULL, 0x004fce00000010ffULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000282913723eULL, 0x010fce00000010ffULL,
0x0000000000007308ULL, 0x000f220000000800ULL, 0x000000051fff7c12ULL, 0x002fe2000f80401bULL,
0x0000001c1040723cULL, 0x000fe20000041840ULL, 0x000000141714723eULL, 0x004fca00000010ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x000000160016723eULL, 0x010fce00000010ffULL, 0x0000003c003c7308ULL, 0x000ff00000000800ULL,
0x0000001a001a7308ULL, 0x000ea20000000800ULL, 0x0000002a2b15723eULL, 0x002fe400000010ffULL,
0x0000003c1a17723eULL, 0x004fce00000010ffULL, 0x0000001c1440723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000161204008947ULL, 0x008fde000b800000ULL,
0x001c1fff401c7589ULL, 0x0002a400000e0000ULL, 0x000000001f0073a1ULL, 0x000ee200000e8000ULL,
0x000000001f0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051fff7c12ULL, 0x008fda000f804000ULL, 0x0000163204008947ULL, 0x010fea000b800000ULL,
0x001c1fff421d7589ULL, 0x00072800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x002e6400000e0000ULL, 0x00000002ff007819ULL, 0x000fe40000011631ULL,
0x0000000c19307812ULL, 0x000fc400078ec0ffULL, 0x00000007001a7812ULL, 0x040fe200078ec0ffULL,
0x00000008001b7824ULL, 0x040fe200078e00ffULL, 0x00000000ff277212ULL, 0x000fe200078e33ffULL,
0x0000000800207824ULL, 0x040fe200078e00ffULL, 0x0000000331ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000800287824ULL, 0x040fe200078e00ffULL, 0x0000000800007810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81b1b7812ULL, 0x100fe400078ee21aULL, 0x0000000120217812ULL, 0x100fe200078ef61aULL,
0x00000008003f7824ULL, 0x000fe200078e00ffULL, 0x0000000220227812ULL, 0x100fe200078ef61aULL,
0x0000000800297824ULL, 0x000fe200078e00ffULL, 0x0000000320237812ULL, 0x000fc400078ef61aULL,
0x0000000420247812ULL, 0x140fe400078ef61aULL, 0x0000000520257812ULL, 0x140fe400078ef61aULL,
0x0000000620267812ULL, 0x000fe200078ef61aULL, 0x0000000800207824ULL, 0x000fe200078e00ffULL,
0xfffffff828277812ULL, 0x000fe400078ee227ULL, 0x00000000ff287212ULL, 0x000fe400078e33ffULL,
0x00000007001a7812ULL, 0x000fc400078ec0ffULL, 0x0000a0003a007811ULL, 0x000fe400078e58ffULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee228ULL, 0xfffffff829287812ULL, 0x000fe200078ee21aULL,
0x000000101b197824ULL, 0x000fe200078e0200ULL, 0x0000000120297812ULL, 0x000fe200078ef61aULL,
0x00000010221b7824ULL, 0x000fe200078e0200ULL, 0x00000002202a7812ULL, 0x100fe200078ef61aULL,
0x0000000130197824ULL, 0x000fe200078e0219ULL, 0x00000003202b7812ULL, 0x040fe200078ef61aULL,
0x0000001025227824ULL, 0x000fe200078e0200ULL, 0x00000004203c7812ULL, 0x100fe200078ef61aULL,
0x00000001301b7824ULL, 0x000fe200078e021bULL, 0x00000005203d7812ULL, 0x000fe200078ef61aULL,
0x0000001028257824ULL, 0x000fe200078e0200ULL, 0x00000006203e7812ULL, 0x000fe200078ef61aULL,
0x00000010211a7824ULL, 0x100fe200078e0200ULL, 0x0000000819007388ULL, 0x0007e20000000800ULL,
0x0000001023207824ULL, 0x000fc400078e0200ULL, 0x0000001024217824ULL, 0x000fe400078e0200ULL,
0x00000001301a7824ULL, 0x000fe400078e021aULL, 0x0000001026237824ULL, 0x100fe400078e0200ULL,
0x0000001027247824ULL, 0x000fe200078e0200ULL, 0x0000000a1a007388ULL, 0x0007e20000000800ULL,
0x0000000130207824ULL, 0x040fe400078e0220ULL, 0x0000000130217824ULL, 0x000fe200078e0221ULL,
0x0000000c1b007388ULL, 0x0007e20000000800ULL, 0x0000001029267824ULL, 0x000fc400078e0200ULL,
0x0000000130227824ULL, 0x000fe200078e0222ULL, 0x0000000e20007388ULL, 0x0007e20000000800ULL,
0x000000102a277824ULL, 0x100fe400078e0200ULL, 0x0000000130237824ULL, 0x040fe200078e0223ULL,
0x0000001021007388ULL, 0x0007e20000000800ULL, 0x000000102b287824ULL, 0x000fe400078e0200ULL,
0x0000000130247824ULL, 0x000fe200078e0224ULL, 0x0000001222007388ULL, 0x0007e20000000800ULL,
0x000000103c297824ULL, 0x000fc400078e0200ULL, 0x0000000130257824ULL, 0x040fe200078e0225ULL,
0x0000001423007388ULL, 0x0007e20000000800ULL, 0x000000103d2a7824ULL, 0x000fe400078e0200ULL,
0x0000000130267824ULL, 0x000fe200078e0226ULL, 0x0000001624007388ULL, 0x0007e20000000800ULL,
0x000000103e2b7824ULL, 0x100fe400078e0200ULL, 0x0000000130277824ULL, 0x000fe200078e0227ULL,
0x0000000925007388ULL, 0x0007e20000000800ULL, 0x000000103f007824ULL, 0x000fc400078e0200ULL,
0x0000000130287824ULL, 0x040fe200078e0228ULL, 0x0000000b26007388ULL, 0x0007e20000000800ULL,
0x0000000130297824ULL, 0x040fe400078e0229ULL, 0x00000001302a7824ULL, 0x040fe200078e022aULL,
0x0000000d27007388ULL, 0x0007e20000000800ULL, 0x00000001302b7824ULL, 0x040fe400078e022bULL,
0x0000000130007824ULL, 0x000fe200078e0200ULL, 0x0000000f28007388ULL, 0x0007e80000000800ULL,
0x0000001129007388ULL, 0x0007e80000000800ULL, 0x000000132a007388ULL, 0x0007e80000000800ULL,
0x000000152b007388ULL, 0x0007e80000000800ULL, 0x0000001700007388ULL, 0x0007e80000000800ULL,
0x0100000418008388ULL, 0x0007e80000000c00ULL, 0x0102001c18008388ULL, 0x0167e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000036ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080036ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100036ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030038387a10ULL, 0x000fe20007ffe0ffULL,
0x0000180036ff7f8cULL, 0x0003e6000c80043fULL, 0x000000023800720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffbd9000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x0001aa8000247802ULL, 0x000fe40000000f00ULL, 0x0000124000007944ULL, 0x012fea0003c00000ULL,
0xfffe6cb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001aac000247802ULL, 0x000fe40000000f00ULL, 0x0000120000007944ULL, 0x012fea0003c00000ULL,
0xfffe6cf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x004fe200078e0024ULL,
0x0001ab2000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000115000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e0000ULL, 0xfffe6d2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e0024ULL, 0x0001ab9000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fc400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x000010e000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0000ULL,
0xfffe6ce000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e0048ULL,
0x0001ac0000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000107000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff607224ULL, 0x004fe200078e0000ULL, 0xfffe705000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e0046ULL, 0x0001ac7000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x0000100000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff4b7224ULL, 0x004fe200078e0000ULL,
0xfffe701000007947ULL, 0x000fea000383ffffULL, 0x0000001fff297424ULL, 0x004fe200078e00ffULL,
0x0001acd000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x00000fa000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0000ULL,
0xfffe8f4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0046ULL,
0x0001ad4000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x004fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000f3000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff677224ULL, 0x004fe200078e0000ULL, 0xfffe8ef000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x0001ad9000247802ULL, 0x000fe40000000f00ULL,
0x00000f3000007944ULL, 0x034fea0003c00000ULL, 0xfffeae7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x0001add000247802ULL, 0x000fe40000000f00ULL,
0x00000ef000007944ULL, 0x034fea0003c00000ULL, 0xfffeaeb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x0001ae4000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0025ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x034fea0003c00000ULL,
0xfffeaef000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0025ULL,
0x0001aeb000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fc400078e0046ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00000dc000007944ULL, 0x032fea0003c00000ULL, 0xfffeafa000007947ULL, 0x000fea000383ffffULL,
0x0000001fff297424ULL, 0x000fe200078e00ffULL, 0x0001af0000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000d7000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff2e7224ULL, 0x004fe200078e0000ULL, 0xfffeb20000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x008fe200078e0046ULL, 0x0001af7000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00000d0000007944ULL, 0x036fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0000ULL,
0xfffeb1b000007947ULL, 0x000fea000383ffffULL, 0x0000001fff297424ULL, 0x000fe200078e00ffULL,
0x0001afd000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x00000ca000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff357224ULL, 0x004fe200078e0000ULL,
0xfffecf2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0046ULL,
0x0001b04000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000c3000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff367224ULL, 0x004fe200078e0000ULL, 0xfffeced000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x0001b09000247802ULL, 0x000fe40000000f00ULL,
0x00000c3000007944ULL, 0x014fea0003c00000ULL, 0xfffeecf000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x0001b0d000247802ULL, 0x000fe40000000f00ULL,
0x00000bf000007944ULL, 0x014fea0003c00000ULL, 0xfffeed3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x0001b14000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0025ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fc400078e00ffULL, 0x00000b3000007944ULL, 0x014fea0003c00000ULL,
0xfffeed7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0025ULL,
0x0001b1b000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fc400078e0046ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00000ac000007944ULL, 0x012fea0003c00000ULL, 0xfffeee2000007947ULL, 0x000fea000383ffffULL,
0x0000001fff297424ULL, 0x000fe200078e00ffULL, 0x0001b20000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x00000a7000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e0000ULL, 0xfffef08000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x008fe200078e0046ULL, 0x0001b27000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x00000a0000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff667224ULL, 0x004fe200078e0000ULL,
0xfffef03000007947ULL, 0x000fea000383ffffULL, 0x0000001fff297424ULL, 0x000fe200078e00ffULL,
0x0001b2d000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff677224ULL, 0x004fe200078e0000ULL,
0xffff0d7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0046ULL,
0x0001b34000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000093000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff687224ULL, 0x004fe200078e0000ULL, 0xffff0d2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x0001b39000247802ULL, 0x000fe40000000f00ULL,
0x0000093000007944ULL, 0x034fea0003c00000ULL, 0xffff2c2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x0001b3d000247802ULL, 0x000fe40000000f00ULL,
0x000008f000007944ULL, 0x034fea0003c00000ULL, 0xffff2c6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x0001b44000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0024ULL, 0x0000001fff297424ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x034fea0003c00000ULL,
0xffff2ca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x0001b4b000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fc400078e0046ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x000007c000007944ULL, 0x032fea0003c00000ULL, 0xffff2d5000007947ULL, 0x000fea000383ffffULL,
0x0000001fff297424ULL, 0x000fe200078e00ffULL, 0x0001b50000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000077000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff2e7224ULL, 0x004fe200078e0000ULL, 0xffff2fb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0046ULL, 0x0001b57000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff297424ULL, 0x000fe400078e00ffULL, 0xffffffffff287424ULL, 0x000fe400078e00ffULL,
0x0000070000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0000ULL,
0xffff2f6000007947ULL, 0x000fea000383ffffULL, 0x0000001fff297424ULL, 0x000fe200078e00ffULL,
0x0001b5d000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff287424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff317224ULL, 0x004fe200078e0000ULL,
0xffff4ce000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0046ULL,
0x0001b64000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff297424ULL, 0x000fc400078e00ffULL,
0xffffffffff287424ULL, 0x000fe400078e00ffULL, 0x0000063000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff467224ULL, 0x004fe200078e0000ULL, 0xffff4c9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0004ULL, 0x0001b6a000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fe400078e00ffULL, 0x0000058000007944ULL, 0x022fea0003c00000ULL,
0xffffe4f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff007224ULL, 0x000fe200078e0024ULL,
0x0001b6f000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fe400078e00ffULL,
0x0000053000007944ULL, 0x022fea0003c00000ULL, 0x0000000024057209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0006ULL, 0x0001b74000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fe400078e00ffULL, 0x000004e000007944ULL, 0x000fea0003c00000ULL,
0x0000000006067209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0007ULL,
0x0001b79000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000000007077209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0x0001b7e000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000000025047209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0005ULL,
0x0001b83000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000000005057209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0006ULL, 0x0001b88000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000000006067209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0007ULL,
0x0001b8d000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0000ULL,
0xffffe3a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0040ULL,
0x0001b95000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff297424ULL, 0x000fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fe400078e001fULL,
0x0000032000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0000ULL,
0xffffe98000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0042ULL,
0x0001b9d000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff297424ULL, 0x000fe400078e00ffULL, 0x000000ffff287224ULL, 0x000fe400078e001fULL,
0x000002a000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x0001ba3000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff297424ULL, 0x000fc400078e00ffULL,
0x000000ffff287224ULL, 0x000fe400078e001fULL, 0x000000ffff1d7224ULL, 0x004fe400078e0000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e001fULL,
0x0001ba9000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff297424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e0000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e0000ULL,
0xffffe8c000007947ULL, 0x000fea000383ffffULL, 0x0180000031007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff31ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000005ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000031057812ULL, 0x000fd600078ec0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe43e004007950ULL, 0x000fea0003c3ffffULL,
0x0000003e00007348ULL, 0x000fe80003800000ULL, 0x0c00000800007389ULL, 0x0002a400000e0030ULL,
0x000000ffff087224ULL, 0x002fe400078e0009ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe439008007950ULL, 0x000fea0003c3ffffULL, 0x0000002800007348ULL, 0x000fe80003800000ULL,
0x0000002b2a007389ULL, 0x0002a400000e0029ULL, 0x000000ffff287224ULL, 0x002fe400078e0030ULL,
0x00000000ff297424ULL, 0x000fc800078e00ffULL, 0xfffe434028007950ULL, 0x000fea0003c3ffffULL,
0x000000010000780cULL, 0x000fe20003f25070ULL, 0x00000000ff257424ULL, 0x000fe200078e00ffULL,
0x0000005a00007348ULL, 0x000ff60003800000ULL, 0x0000000000007806ULL, 0x000fc800048e0100ULL,
0x0000005a00007212ULL, 0x000fe200078ec0ffULL, 0xfffe42e024007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000003c0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009a0ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a30ULL, 0x0000000000000b8cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015bcULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015e0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001610ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016a0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016a8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000016b8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x000000000001be00ULL, 0xa700001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001d680ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001d690ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001d690ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001db10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000016a0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001bfe0ULL, 0x000000000001bfe0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001d680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001db10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 121840;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
