/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001b390ULL, 0x000000000001af10ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x00000000000198d0ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000019a40ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000019a80ULL, 0x0000000000000100ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000019b80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000198d000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0065900400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x000198d000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080930828808081ULL, 0x8016288080ae0828ULL, 0x0000000310288082ULL, 0x80ae920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x00019a4000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080930828808081ULL,
0x8e08288080ae0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808e920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x00019a8000000000ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000a7ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL, 0x0058190300580160ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0018310400ff1b03ULL, 0x00018de000018a80ULL, 0x00018e6000018df0ULL, 0x00018e8000018e70ULL,
0xffffffff01082904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002bffffffffULL, 0x0500002b0500002bULL, 0xffffffff0500002bULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01082804ffffffffULL, 0x000000f0000000c0ULL, 0x0000171000001680ULL,
0x000017c000001790ULL, 0x00002810000027d0ULL, 0x0000445000004410ULL, 0x00005720000056a0ULL,
0x000057c000005790ULL, 0x00006610000065d0ULL, 0x0000816000008120ULL, 0x000093d000009350ULL,
0x0000947000009440ULL, 0x0000a1e00000a1a0ULL, 0x0000be100000bdd0ULL, 0x0000d1300000d0b0ULL,
0x0000d1d00000d1a0ULL, 0x0000e0800000e050ULL, 0x0000f5000000f4d0ULL, 0x00010a3000010a20ULL,
0x00012f10000111b0ULL, 0x0001360000013070ULL, 0x00013e7000013610ULL, 0x00018700000186d0ULL,
0x0001872000018710ULL, 0x0001876000018740ULL, 0x0001879000018780ULL, 0x00018eb000018e50ULL,
0x00018ed000018ec0ULL, 0x00019550000194f0ULL, 0x000195f0000195a0ULL, 0x0001969000019640ULL,
0x00019730000196e0ULL, 0x00019810000197a0ULL, 0x000198b000019860ULL, 0x0000017005e03904ULL,
0x00010600000000ffULL, 0x000001a0003f0100ULL, 0x000106080000000bULL, 0x000001d0003f0130ULL,
0x000106100000000bULL, 0x00000230003f0130ULL, 0x000106480000000bULL, 0x00000240003f0120ULL,
0x00010658000000ffULL, 0x000005a0003f0100ULL, 0x00010600000000ffULL, 0x00000770003f0107ULL,
0x000000040000000bULL, 0x00000870003f0102ULL, 0x000000000000000bULL, 0x00000ce0003f0101ULL,
0x00010648000000ffULL, 0x00000d60003f0107ULL, 0x00010658000000ffULL, 0x00000ed0003f0101ULL,
0x0001065c000000ffULL, 0x00000f30003f0106ULL, 0x0001065c000000ffULL, 0x00000fb0003f0106ULL,
0x0001065c000000ffULL, 0x00001430003f0106ULL, 0x00010650000000ffULL, 0x000014a0003f0107ULL,
0x0001064c000000ffULL, 0x000014c0003f0106ULL, 0x0001060c000000ffULL, 0x000015c0003f0106ULL,
0x0001060c000000ffULL, 0x00001a20003f0106ULL, 0x0001064c000000ffULL, 0x00001ac0003f0106ULL,
0x0001064c000000ffULL, 0x00003350003f0106ULL, 0x00010658000000ffULL, 0x00003360003f0101ULL,
0x0001065c000000ffULL, 0x000033a0003f0106ULL, 0x0001065c000000ffULL, 0x00003420003f0106ULL,
0x0001065c000000ffULL, 0x000036f0003f0106ULL, 0x00010648000000ffULL, 0x00003760003f0107ULL,
0x00010654000000ffULL, 0x000037d0003f0106ULL, 0x00010654000000ffULL, 0x00003870003f0106ULL,
0x00010654000000ffULL, 0x00004fe0003f0106ULL, 0x00010658000000ffULL, 0x00005050003f0101ULL,
0x00010610000000ffULL, 0x000050a0003f0101ULL, 0x0001065c000000ffULL, 0x000050e0003f0106ULL,
0x0001065c000000ffULL, 0x00005160003f0106ULL, 0x0001065c000000ffULL, 0x000054b0003f0106ULL,
0x00010650000000ffULL, 0x00005520003f0107ULL, 0x0001064c000000ffULL, 0x00005540003f0106ULL,
0x0001061c000000ffULL, 0x00005620003f0106ULL, 0x0001061c000000ffULL, 0x00005a30003f0106ULL,
0x0001064c000000ffULL, 0x00005ad0003f0106ULL, 0x0001064c000000ffULL, 0x000071d0003f0106ULL,
0x00010658000000ffULL, 0x000071e0003f0101ULL, 0x0001065c000000ffULL, 0x00007220003f0106ULL,
0x0001065c000000ffULL, 0x000072a0003f0106ULL, 0x0001065c000000ffULL, 0x00007520003f0106ULL,
0x00010648000000ffULL, 0x00007590003f0107ULL, 0x00010654000000ffULL, 0x000075e0003f0106ULL,
0x00010654000000ffULL, 0x00007670003f0106ULL, 0x00010654000000ffULL, 0x00008d60003f0106ULL,
0x00010658000000ffULL, 0x00008dd0003f0101ULL, 0x00010620000000ffULL, 0x00008e20003f0101ULL,
0x0001065c000000ffULL, 0x00008e60003f0106ULL, 0x0001065c000000ffULL, 0x00008ee0003f0106ULL,
0x0001065c000000ffULL, 0x00009160003f0106ULL, 0x00010650000000ffULL, 0x000091d0003f0107ULL,
0x0001064c000000ffULL, 0x000091f0003f0106ULL, 0x0001062c000000ffULL, 0x000092d0003f0106ULL,
0x0001062c000000ffULL, 0x000096e0003f0106ULL, 0x0001064c000000ffULL, 0x00009780003f0106ULL,
0x0001064c000000ffULL, 0x0000ae80003f0106ULL, 0x00010658000000ffULL, 0x0000ae90003f0101ULL,
0x0001065c000000ffULL, 0x0000aed0003f0106ULL, 0x0001065c000000ffULL, 0x0000af50003f0106ULL,
0x0001065c000000ffULL, 0x0000b1d0003f0106ULL, 0x00010648000000ffULL, 0x0000b240003f0107ULL,
0x00010654000000ffULL, 0x0000b290003f0106ULL, 0x00010654000000ffULL, 0x0000b320003f0106ULL,
0x00010654000000ffULL, 0x0000ca10003f0106ULL, 0x00010658000000ffULL, 0x0000ca80003f0101ULL,
0x00010630000000ffULL, 0x0000cad0003f0101ULL, 0x0001065c000000ffULL, 0x0000cb10003f0106ULL,
0x0001065c000000ffULL, 0x0000cb90003f0106ULL, 0x0001065c000000ffULL, 0x0000cee0003f0106ULL,
0x00010650000000ffULL, 0x0000cf50003f0107ULL, 0x0001064c000000ffULL, 0x0000cf70003f0106ULL,
0x0001063c000000ffULL, 0x0000d030003f0106ULL, 0x0001063c000000ffULL, 0x0000d440003f0106ULL,
0x0001064c000000ffULL, 0x0000d4e0003f0106ULL, 0x0001064c000000ffULL, 0x0000ebf0003f0106ULL,
0x00010658000000ffULL, 0x0000ec00003f0101ULL, 0x0001065c000000ffULL, 0x0000ec40003f0106ULL,
0x0001065c000000ffULL, 0x0000ecc0003f0106ULL, 0x0001065c000000ffULL, 0x0000ef70003f0106ULL,
0x00010648000000ffULL, 0x0000efe0003f0107ULL, 0x00010654000000ffULL, 0x0000f030003f0106ULL,
0x00010654000000ffULL, 0x0000f0c0003f0106ULL, 0x00010654000000ffULL, 0x000107b0003f0106ULL,
0x00010658000000ffULL, 0x00010810003f0101ULL, 0x00010640000000ffULL, 0x00015010003f0101ULL,
0x00010604000000ffULL, 0x000150a0003f0106ULL, 0x00010604000000ffULL, 0x000153d0003f0106ULL,
0x00010600000000ffULL, 0x000153e0003f0101ULL, 0x00010604000000ffULL, 0x00015460003f0106ULL,
0x00010604000000ffULL, 0x00017be0003f0106ULL, 0x0001061400000035ULL, 0x00017fb0003f0106ULL,
0x0001061400000035ULL, 0x00019450003f0106ULL, 0x0001060800000035ULL, 0x00053803003f0101ULL,
0x000142d000101c04ULL, 0x00015580000154b0ULL, 0x00000401000194b0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001c4ULL, 0x0000001100000002ULL, 0x0000000000000144ULL, 0x0000001100000002ULL,
0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x000000000000019aULL, 0x0000001100000002ULL, 0x000000000000011dULL, 0x0000001100000002ULL,
0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff177424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e620000002200ULL, 0x0000580000047ab9ULL, 0x000fc60000000800ULL,
0x0000000000097919ULL, 0x000ea80000002100ULL, 0x00000000000a7919ULL, 0x000ee80000002700ULL,
0x0000000000327919ULL, 0x000f220000002600ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x00000080000b7824ULL, 0x104fe200078e0209ULL, 0x00000005ff1a7819ULL, 0x000fe20000011609ULL,
0x00001fff08007589ULL, 0x00066600000e0000ULL, 0x000000ff0b00720cULL, 0x040fe40003f65270ULL,
0x000000030b00780cULL, 0x040fe20003f04070ULL, 0x00001fff1a1a7589ULL, 0x000ea200000e0000ULL,
0x0000007f0b00780cULL, 0x040fe20003f24070ULL, 0x000062000a087625ULL, 0x008fe200078e0017ULL,
0x000000010b00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01060002ff00b388ULL, 0x0007e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x010608040b008388ULL, 0x0007e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff0ca424ULL, 0x000fe200078e00ffULL, 0x010610060b008388ULL, 0x0007e2000000ca00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff0da424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0eb424ULL, 0x000fe200078e00ffULL, 0x010400100b009388ULL, 0x0007e20000004800ULL,
0x7fffff80ff0fb424ULL, 0x000fc600078e00ffULL, 0x0106480c0b00a388ULL, 0x0007e80000008a00ULL,
0x0106580eff00b388ULL, 0x0007e80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003a000000947ULL, 0x000fea0003800000ULL, 0x0000000000137919ULL, 0x01ce620000000000ULL,
0x000000041a027824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x0000001032037824ULL, 0x000fc400078e00ffULL, 0x00000200ff167424ULL, 0x000fc600078e00ffULL,
0x000000050a047c24ULL, 0x000fe2000f8e0203ULL, 0x0000000213057211ULL, 0x042fe200078fd8ffULL,
0x0000001013027824ULL, 0x000fc600078e00ffULL, 0x0000000705037812ULL, 0x040fe400078ec0ffULL,
0x000001f002157812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x000fe200078e0205ULL,
0x00000002050f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03067812ULL, 0x000fe200078e7813ULL,
0x00005c0002027625ULL, 0x000fe200078e0016ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0000000305117810ULL, 0x040fe20007ffe0ffULL, 0x00000020050b7824ULL, 0x000fe200078e0206ULL,
0x000000070f0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x040fe200078e0207ULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x0000000104107824ULL, 0x000fe200078e020fULL,
0x00000007110d7812ULL, 0x000fe200078ec0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x0000001f0c127812ULL, 0x000fc400078e7813ULL, 0x00000015020c7210ULL, 0x000fe40007f1e0ffULL,
0x0000001f06067812ULL, 0x100fe200078e7813ULL, 0x000000200f127824ULL, 0x000fe200078e0212ULL,
0x0000001f0d147812ULL, 0x000fe200078e7813ULL, 0x0000000104137824ULL, 0x000fe400078e0211ULL,
0x000000ffff0d7224ULL, 0x000fe400000e0603ULL, 0x00005c0005027625ULL, 0x000fc600078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c46ULL,
0x00000020070e7824ULL, 0x000fe200078e0206ULL, 0x0000001502027210ULL, 0x000fe20007f1e0ffULL,
0x00005c0010047625ULL, 0x000fc800078e0016ULL, 0x00005c0013067625ULL, 0x000fe200078e0016ULL,
0x0000001504047210ULL, 0x000fc60007f3e0ffULL, 0x0000002011147824ULL, 0x000fe200078e0214ULL,
0x0000001506067210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100e0f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001012117824ULL, 0x000fe200078e00ffULL, 0x00000000020f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400010e0607ULL, 0x0000001014137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000608197981ULL, 0x01cea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000005ff1b7e24ULL, 0x008fe2000f8e00ffULL, 0x0000007f19007810ULL, 0x004fc40007ffe0ffULL,
0x000000ff19027810ULL, 0x002fe40007ffe0ffULL, 0x00000007ff007819ULL, 0x000fe40000011600ULL,
0x00000008ff027819ULL, 0x000fca0000011602ULL, 0x00013c4000008947ULL, 0x000fea0003800000ULL,
0x000000021b037824ULL, 0x000fe200078e00ffULL, 0x000106101a0b7811ULL, 0x000fe200078e20ffULL,
0x00000003ff067424ULL, 0x000fc600078e00ffULL, 0x000000000300720cULL, 0x000fda0003f06070ULL,
0x0000640003058a10ULL, 0x000fe20007ffe0ffULL, 0x000000020a048824ULL, 0x000fc800078e00ffULL,
0x0000640004058a24ULL, 0x000fe400078e0205ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000004060bff738cULL, 0x0003e20000000000ULL,
0x0000600005088625ULL, 0x000fe200078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000608048981ULL, 0x0004e2000c1e1900ULL, 0x000001001b067824ULL, 0x042fe200078e00ffULL,
0x000000011b077810ULL, 0x000fe20007ffe0ffULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00000100ff1e7424ULL, 0x000fe200078e00ffULL,
0x00000006190d7217ULL, 0x000fe20007800000ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000020700720cULL, 0x000fe20003f06070ULL, 0x000000000bff7f8cULL, 0x0009e2000c80043fULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000010d0d7824ULL, 0x000fe200078e0a06ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000081a067824ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000200d0d7807ULL, 0x000fe20000000000ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fc400078e00ffULL, 0x000000060d0d7217ULL, 0x000fca0007800000ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a06ULL, 0x00000004ff077819ULL, 0x002fe20000011605ULL,
0x0000001005157824ULL, 0x000fc600078e00ffULL, 0x00000002070c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106097824ULL, 0x004fe200078e0207ULL, 0x00000004070e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000607107810ULL, 0x040fe40007ffe0ffULL, 0x0000000d0700720cULL, 0x080fe20003f66070ULL,
0x0000008032077824ULL, 0x000fe200078e00ffULL, 0x0000000d0c00720cULL, 0x080fe20003f46070ULL,
0x00000001060f7824ULL, 0x000fe200078e020eULL, 0x0000000d0e00720cULL, 0x080fe20003f26070ULL,
0x0000000106117824ULL, 0x000fe200078e0210ULL, 0x0000000d1000720cULL, 0x000fe20003f06070ULL,
0x00000001060d7824ULL, 0x000fe200078e020cULL, 0x0000000709087812ULL, 0x000fe200078ec0ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000070f107812ULL, 0x000fc400078ec0ffULL,
0x0000000f08087812ULL, 0x100fe400078e7805ULL, 0x000000070d0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000711127812ULL, 0x000fe200078ec0ffULL, 0x0000001009147824ULL, 0x000fe200078e0208ULL,
0x0000000f0e0e7812ULL, 0x100fe400078e7805ULL, 0x0000000f10107812ULL, 0x100fe400078e7805ULL,
0x0000000f12127812ULL, 0x000fe200078e7805ULL, 0x000000100d167824ULL, 0x000fe200078e020eULL,
0x000000f015157812ULL, 0x000fe200078ec0ffULL, 0x000000100f187824ULL, 0x000fc400078e0210ULL,
0x00000010111c7824ULL, 0x000fe200078e0212ULL, 0x0000c00016177811ULL, 0x000fe400078e20ffULL,
0x0000c000180b7811ULL, 0x010fe400078e20ffULL, 0x0000c0001c1d7811ULL, 0x000fe200078e20ffULL,
0x00000004040c7c24ULL, 0x008fca000f8e0207ULL, 0x0000007f0c097812ULL, 0x040fe400078ef809ULL,
0x0000007f0c0d7812ULL, 0x040fe400078ef80dULL, 0x0000007f0c0f7812ULL, 0x040fe200078ef80fULL,
0x00005e0009087625ULL, 0x000fe200078e001eULL, 0x0000007f0c107812ULL, 0x000fc600078ef811ULL,
0x00005e000d0c7625ULL, 0x000fe200078e001eULL, 0x0000001508127210ULL, 0x000fc60007fbe0ffULL,
0x00005e000f0e7625ULL, 0x000fe200078e001eULL, 0x000000150c0c7210ULL, 0x000fc60007f9e0ffULL,
0x00005e0010107625ULL, 0x000fc800078e001eULL, 0x000000ffff137224ULL, 0x000fe200028e0609ULL,
0x000000150e0e7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x0000001510107210ULL, 0x000fe20007fde0ffULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x0000c00014157811ULL, 0x000fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fe400028e060fULL,
0x000000ffff117224ULL, 0x000fe400030e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000d901c46ULL, 0x000000ffff097224ULL, 0x000fc600078e00ffULL,
0x000000000c177faeULL, 0x0003e8000d101c46ULL, 0x000000000e0b7faeULL, 0x0003e2000c901c46ULL,
0x000000021b00720cULL, 0x000fc60003f26070ULL, 0x00000000101d7faeULL, 0x0003e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000fa9000001947ULL, 0x000fea0003800000ULL, 0x000000020a0b7824ULL, 0x002fe200078e00ffULL,
0x00007610ff6a7816ULL, 0x000fe2000000006aULL, 0x00006400ff0c7624ULL, 0x000fc400078e00ffULL,
0x000000041a0a7824ULL, 0x000fe400078e00ffULL, 0x000064000b0c7624ULL, 0x000fe200078e020cULL,
0x00007610ff0b7816ULL, 0x000fe2000000000bULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x000000020a0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0x000001001b107824ULL, 0x000fca00078e00ffULL, 0x000000191000720cULL, 0x000fda0003f06070ULL,
0x0000f97000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000ffff677224ULL, 0x000fe200078e0003ULL, 0x000076106a0d7816ULL, 0x000fe2000000000dULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL,
0x0000000f00107305ULL, 0x0002a4000021f000ULL, 0x3fa000000f0f7823ULL, 0x002fe200000100ffULL,
0x000000100000735dULL, 0x004fe40003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000201b107811ULL, 0x000fe200078e40ffULL,
0x0000000404287c24ULL, 0x000fe2000f8e0207ULL, 0x00000004ff457819ULL, 0x000fe20000011605ULL,
0x00000100ff477424ULL, 0x000fe200078e00ffULL, 0x0000001019117217ULL, 0x000fe20007800000ULL,
0x0000001005617824ULL, 0x000fe200078e00ffULL, 0x000000011b0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000002028287810ULL, 0x000fe20007ffe0ffULL, 0x0000000111187824ULL, 0x000fe200078e0a10ULL,
0x0000000245117810ULL, 0x000fc40007ffe0ffULL, 0x000000020f00720cULL, 0x000fe20003f06070ULL,
0x00000001060f7824ULL, 0x040fe200078e0245ULL, 0x0000000445137810ULL, 0x000fe20007ffe0ffULL,
0x0000000106127824ULL, 0x000fe200078e0211ULL, 0x00000020181f7807ULL, 0x000fe40000000000ULL,
0x0000007f0f5d7812ULL, 0x000fe200078ec0ffULL, 0x0000000106147824ULL, 0x000fe200078e0213ULL,
0x0000007f125c7812ULL, 0x000fe400078ec0ffULL, 0x0000000645157810ULL, 0x000fe20007ffe0ffULL,
0x000000015d1c7824ULL, 0x100fe200078e0228ULL, 0x0000001f06297217ULL, 0x000fe20007800000ULL,
0x000000015c1e7824ULL, 0x000fe200078e0228ULL, 0x000000f061107812ULL, 0x000fe200078ec0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0047ULL, 0x0000007f145b7812ULL, 0x000fc400078ec0ffULL,
0x0000000712447812ULL, 0x000fe200078ec0ffULL, 0x00005e001e1e7625ULL, 0x080fe200078e0047ULL,
0x000000101c2a7210ULL, 0x080fe40007f3e0ffULL, 0x0000000714467812ULL, 0x000fe200078ec0ffULL,
0x0000000106167824ULL, 0x000fe200078e0215ULL, 0x000000101e1e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000129187824ULL, 0x000fe200078e0a06ULL, 0x0000000f464d7812ULL, 0x000fe200078e7805ULL,
0x000000ffff2b7224ULL, 0x000fe200008e061dULL, 0x0000007f165a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x000000184500720cULL, 0x080fe20003f26070ULL,
0x000000015b1c7824ULL, 0x100fe200078e0228ULL, 0x000000181100720cULL, 0x080fe20003f46070ULL,
0x000000015a287824ULL, 0x000fe200078e0228ULL, 0x000000181300720cULL, 0x080fe20003f66070ULL,
0x00005e001c1c7625ULL, 0x000fe200078e0047ULL, 0x000000181500720cULL, 0x000fc40003f86070ULL,
0x000000070f187812ULL, 0x040fe200078ec0ffULL, 0x00005e0028287625ULL, 0x000fe200078e0047ULL,
0x0000000716487812ULL, 0x000fe400078ec0ffULL, 0x0000000f18187812ULL, 0x000fe200078e7805ULL,
0x00000010144d7824ULL, 0x000fe200078e024dULL, 0x0000000f44457812ULL, 0x100fe400078e7805ULL,
0x0000000f48477812ULL, 0x000fe200078e7805ULL, 0x000000100f4f7824ULL, 0x000fe200078e0218ULL,
0x000000101c1c7210ULL, 0x080fe20007fbe0ffULL, 0x00000010124e7824ULL, 0x000fe200078e0245ULL,
0x0000001028287210ULL, 0x000fe20007fde0ffULL, 0x00000010164c7824ULL, 0x000fe200078e0247ULL,
0x0000e0004f657811ULL, 0x000fe200078e20ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x0000e0004e647811ULL, 0x000fe200078e20ffULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x0000e0004d637811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a657faeULL, 0x0003e2000c901c46ULL, 0x0000e0004c627811ULL, 0x000fc600078e20ffULL,
0x000000001e647faeULL, 0x0003e8000d101c46ULL, 0x000000001c637faeULL, 0x0003e8000d901c46ULL,
0x0000000028627faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1d7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff1f7984ULL, 0x000ea20000000800ULL, 0x0000ffff6a187812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0b1c7812ULL, 0x000fe400078ec0ffULL, 0x0000888018287816ULL, 0x000fe400000000ffULL,
0x000088801c5e7816ULL, 0x000fc600000000ffULL, 0x8000000028187824ULL, 0x000fe400078e00ffULL,
0x800000005e1c7824ULL, 0x000fc600078e00ffULL, 0x800000001dff7812ULL, 0x002fe40007824818ULL,
0x800000001fff7812ULL, 0x004fe2000784481cULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fe400078e00ffULL,
0x800000005e1d7824ULL, 0x000fe400078e00ffULL, 0x00000018001c7305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x0000001c0000735dULL, 0x004fe40003800000ULL,
0x01060c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fc4000784481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff187819ULL, 0x000fe20000011605ULL, 0x00000001ff447424ULL, 0x000fe200078e00ffULL,
0x0000007061617812ULL, 0x000fe400078ec0ffULL, 0x0000000c18187812ULL, 0x000fca00078ec0ffULL,
0x0000000161617824ULL, 0x000fca00078e0218ULL, 0x01000000611d7984ULL, 0x000e680000000800ULL,
0x0102000061187984ULL, 0x0004e20000000800ULL, 0x000000081d00720bULL, 0x002fda0003f5d000ULL,
0x00000000001c7806ULL, 0x000fc800010e0100ULL, 0x0000ffff1c297812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x000000081d00720bULL, 0x00cfe40003f54000ULL,
0x0000001d082a7209ULL, 0x000fe40007810000ULL, 0x00000002ff1e7819ULL, 0x000fc60000011605ULL,
0x8000002a081c7221ULL, 0x000fe20000010000ULL, 0x000000081e1f7810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b1c1c7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x000000ff1a00720cULL, 0x000fe40003f45270ULL, 0x0000ffff08087812ULL, 0x000fe200078e3cffULL,
0x0000001c001c7308ULL, 0x000e660000000800ULL, 0x0000000829ff7212ULL, 0x000fe2000786c0ffULL,
0x000000ffff087224ULL, 0x000fc600078e002aULL, 0x00000001ff447807ULL, 0x000fc60001800000ULL,
0x0104002a6100a388ULL, 0x000fe80000000800ULL, 0x00001f1f1c1f7589ULL, 0x002e6400000e0000ULL,
0x8000002a1d1d3221ULL, 0x000fe20000010000ULL, 0x0000001c09097220ULL, 0x000fe20000410000ULL,
0x00001f1e1c1e7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b1d1d3820ULL, 0x000fc80000410000ULL,
0x0000001d00173308ULL, 0x000ee20000000800ULL, 0x0000001f27277220ULL, 0x082fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f23237220ULL, 0x080fe20000410000ULL,
0x0000001f22227220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f42427220ULL, 0x000fe20000410000ULL, 0x0000001e25257220ULL, 0x084fe20000410000ULL,
0x0000001e24247220ULL, 0x080fe20000410000ULL, 0x0000001e21217220ULL, 0x080fe20000410000ULL,
0x0000001e20207220ULL, 0x080fe20000410000ULL, 0x0000001e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001e31317220ULL, 0x080fe20000410000ULL,
0x0000001e30307220ULL, 0x080fe20000410000ULL, 0x0000001e35357220ULL, 0x080fe20000410000ULL,
0x0000001e34347220ULL, 0x080fe20000410000ULL, 0x0000001e39397220ULL, 0x080fe20000410000ULL,
0x0000001e38387220ULL, 0x080fe20000410000ULL, 0x0000001e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001e41417220ULL, 0x080fe20000410000ULL,
0x0000001e40407220ULL, 0x000fe20000410000ULL, 0x0000001718183220ULL, 0x008fc80000410000ULL,
0x0000000918097221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff187984ULL, 0x000e620000000800ULL, 0x80000000281d7824ULL, 0x000fca00078e00ffULL,
0x8000000018ff7812ULL, 0x002fe2000782481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x80000000281d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x00000018001c7305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x0000001c0000735dULL, 0x004fe40003800000ULL,
0x01064c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fc4000782481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000805187812ULL, 0x040fe400078ec0ffULL, 0x0000000a051c7211ULL, 0x040fe400078fe0ffULL,
0x0000000718297812ULL, 0x140fe400078ec805ULL, 0x0000000e05287211ULL, 0x000fe400078fe0ffULL,
0x0000000718187812ULL, 0x000fe400078ef805ULL, 0x0000001c29517212ULL, 0x000fc400078e3cffULL,
0x0000002829457212ULL, 0x000fe400078e3cffULL, 0x0000991044487816ULL, 0x000fe200000000ffULL,
0x0000001018547824ULL, 0x040fe200078e0251ULL, 0x00000017ff9d723eULL, 0x000fe200000010ffULL,
0x0000001018537824ULL, 0x040fe200078e0245ULL, 0x0000010018187811ULL, 0x000fe400078e20ffULL,
0x0000c000545f7811ULL, 0x000fe400078e20ffULL, 0x0000c00053597811ULL, 0x000fe200078e20ffULL,
0x0000000151517824ULL, 0x100fe200078e0218ULL, 0x00000002ff9e7819ULL, 0x000fe20000011605ULL,
0x0000000145507824ULL, 0x000fe200078e0218ULL, 0x000000005f1c783bULL, 0x000e620000004200ULL,
0x000000ffff187224ULL, 0x000fe200078e0048ULL, 0x0000c00051587811ULL, 0x000fc400078e20ffULL,
0x0000c00050577811ULL, 0x000fe200078e20ffULL, 0x000000005928783bULL, 0x000ea20000004200ULL,
0x000000ff1800720cULL, 0x000fe40003f25270ULL, 0x000054109d9d7816ULL, 0x000fe2000000009dULL,
0x000000005844783bULL, 0x000ee80000004200ULL, 0x000000005748783bULL, 0x000f220000004200ULL,
0x000000ff1d687812ULL, 0x002fc400078ec0ffULL, 0x000000ff1f947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe4000001161dULL, 0x00000018ff8c7819ULL, 0x000fe4000001161dULL,
0x0000ffff1d8a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff957819ULL, 0x000fe4000001161fULL,
0x00000010ff7f7819ULL, 0x004fc4000001162bULL, 0x000000ff2b767812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001162bULL, 0x0000ffff2b187812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1d7819ULL, 0x108fe40000011647ULL, 0x000000ff47747812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2b7819ULL, 0x000fc40000011647ULL, 0x0000ffff476c7812ULL, 0x000fe400078ec0ffULL,
0x00000068ff99723eULL, 0x000fe400020006ffULL, 0x00000010ff7b7819ULL, 0x100fe40000011644ULL,
0x000000ff44817812ULL, 0x040fe200078ec0ffULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x00000018ff667819ULL, 0x000fe40000011644ULL, 0x0000ffff447d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff757819ULL, 0x110fe40000011649ULL, 0x000000ff49477812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe40000011649ULL, 0x0000ffff498f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff907819ULL, 0x000fe4000001164aULL, 0x000000ff4a6b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe4000001164aULL, 0x0000ffff4a6d7812ULL, 0x000fe400078ec0ffULL,
0x00000094ff49723eULL, 0x000fe400020006ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001162aULL,
0x00000095ff4a723eULL, 0x000fe200020006ffULL, 0x20000049ff957230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fc40000011628ULL, 0x000000ff28797812ULL, 0x040fe200078ec0ffULL,
0x2000004aff497230ULL, 0x000fe20000004100ULL, 0x00000018ff807819ULL, 0x000fe40000011628ULL,
0x0000ffff28867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x100fe4000001161cULL,
0x000000ff1c567812ULL, 0x000fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fc4000001161cULL,
0x0000ffff1c8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff287819ULL, 0x000fe4000001162aULL,
0x000000ff2a887812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2a7e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1c7819ULL, 0x000fe40000011646ULL, 0x000000ff466e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe40000011646ULL, 0x0000ffff46777812ULL, 0x000fe400078ec0ffULL,
0x00000018ff877819ULL, 0x000fe40000011629ULL, 0x00000018ff467819ULL, 0x000fe40000011648ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x000000ff487c7812ULL, 0x000fc400078ec0ffULL,
0x00000079ff4a723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000080ff79723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000087ff80723eULL, 0x000fe200020006ffULL, 0x2000006fff877230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff8d7819ULL, 0x000fc4000001161fULL, 0x0000ffff1f717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff827819ULL, 0x100fe40000011645ULL, 0x000000ff45847812ULL, 0x040fe400078ec0ffULL,
0x00000018ff697819ULL, 0x000fe40000011645ULL, 0x0000ffff45837812ULL, 0x000fe400078ec0ffULL,
0x00000047ff47723eULL, 0x000fc400020006ffULL, 0x00000018ff457819ULL, 0x000fe4000001164bULL,
0x0000008cff1f723eULL, 0x000fe200020006ffULL, 0x20000088ff8c7230ULL, 0x000fe20000004100ULL,
0x0000007cff6f723eULL, 0x000fe200020006ffULL, 0x20000066ff7c7230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x20000076ff887230ULL, 0x000fe20000004100ULL,
0x0000006bff66723eULL, 0x000fe200020006ffULL, 0x2000006eff767230ULL, 0x000fe20000004100ULL,
0x00000044ff44723eULL, 0x000fe200020006ffULL, 0x20000046ff6b7230ULL, 0x000fe20000004100ULL,
0x00000045ff46723eULL, 0x000fe200020006ffULL, 0x20000047ff6e7230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x2000002aff477230ULL, 0x000fe20000004100ULL,
0x000000ff702a7812ULL, 0x000fe200078ec0ffULL, 0x20000044ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe2000001161eULL, 0x20000046ff447230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x2000002bff467230ULL, 0x000fe20000004100ULL,
0x000000ff722b7812ULL, 0x000fe200078ec0ffULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x0000ffff1e527812ULL, 0x000fe200078ec0ffULL, 0x2000002aff9b7230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff2a7819ULL, 0x000fc40000011652ULL, 0x0000000705527812ULL, 0x000fe200078ec0ffULL,
0x2000002bff967230ULL, 0x000fe20000004100ULL, 0x000000ff29857812ULL, 0x000fe400078ec0ffULL,
0x000000ff4b917812ULL, 0x000fe400078ec0ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x000000ff1e927812ULL, 0x000fe400078ec0ffULL, 0x00000018ff937819ULL, 0x000fc4000001161eULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000055ff1e723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000004ff2b7819ULL, 0x100fe20000011605ULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x0000000852527812ULL, 0x000fe400078ef805ULL,
0x00000010ff787819ULL, 0x000fc4000001164bULL, 0x0000ffff4b557812ULL, 0x000fe400078ec0ffULL,
0x00000085ff4b723eULL, 0x000fe200020006ffULL, 0x2000007aff857230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000069ff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x20000068ff697230ULL, 0x000fe20000004100ULL,
0x000000072b2b7812ULL, 0x000fe200078e7852ULL, 0x20000066ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011629ULL, 0x20000091ff667230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000008ff717819ULL, 0x000fc40000011671ULL, 0x0000002aff2a723eULL, 0x000fe200020006ffULL,
0x20000092ff947230ULL, 0x000fe20000004100ULL, 0x00000056ff98723eULL, 0x000fe400020006ffULL,
0x00000060ff91723eULL, 0x000fe200020006ffULL, 0x0000000852607824ULL, 0x000fe200078e022bULL,
0x0000ffff29297812ULL, 0x000fe200078ec0ffULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe20000011648ULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x0000ffff48567812ULL, 0x000fc400078ec0ffULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x00000093ff48723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000071ff93723eULL, 0x000fe200020006ffULL,
0x2000002aff717230ULL, 0x000fe20000004100ULL, 0x00000084ff92723eULL, 0x000fe200020006ffULL,
0x20000081ff847230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000092ff817230ULL, 0x000fe20000004100ULL, 0x00000008ff2a7819ULL, 0x000fe20000011629ULL,
0x2000008eff9a7230ULL, 0x000fe20000004100ULL, 0x0000a00060297811ULL, 0x000fe200078e20ffULL,
0x20000089ff927230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x0000002aff8e723eULL, 0x000fc400020006ffULL,
0x000000ff28897812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x000000002928783bULL, 0x000fe20000000200ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x2000008dff977230ULL, 0x000fe20000004100ULL,
0x00000008ff7e7819ULL, 0x000fe2000001167eULL, 0x20000086ff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff8b7819ULL, 0x000fc4000001168bULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000008ff867819ULL, 0x000fe40000011618ULL,
0x000000089e187810ULL, 0x000fc40007ffe0ffULL, 0x0000008bff70723eULL, 0x000fe200020006ffULL,
0x20000089ff8b7230ULL, 0x000fe20000004100ULL, 0x0000008aff72723eULL, 0x000fe200020006ffULL,
0x2000007fff897230ULL, 0x000fe20000004100ULL, 0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL,
0x2000007eff8a7230ULL, 0x000fe20000004100ULL, 0x00001f9e9d7f7589ULL, 0x000e6200000e0000ULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x00001f189d7e7589ULL, 0x0004e200000e0000ULL,
0x00000083ff9c723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff997819ULL, 0x000fe20000011699ULL, 0x2000007bff837230ULL, 0x000fe20000004100ULL,
0x00000010ff957819ULL, 0x000fe20000011695ULL, 0x2000009cff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff1c9c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1c7819ULL, 0x000fe40000011698ULL,
0x000000ff1d9d7812ULL, 0x004fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x000fe4000001169aULL,
0x00000010ff987819ULL, 0x000fe4000001169bULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x00001054981d7816ULL, 0x000fe20000000099ULL, 0x0000007f28289231ULL, 0x082fe200003400ffULL,
0x000000ff73987812ULL, 0x000fe200078ec0ffULL, 0x0000007f2a2a9231ULL, 0x000fe200003400ffULL,
0x00000010ff4a7819ULL, 0x000fe2000001164aULL, 0x0000007e29299231ULL, 0x088fe200003400ffULL,
0x00000098ff98723eULL, 0x000fe200020006ffULL, 0x0000007e2b2b9231ULL, 0x000fe200003400ffULL,
0x00000010ff4b7819ULL, 0x000fc4000001164bULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x0000001c2840723cULL, 0x000fe20000041840ULL,
0x00000008ff8f7819ULL, 0x000fe4000001168fULL, 0x00001054914a7816ULL, 0x000fe4000000004aULL,
0x00001054924b7816ULL, 0x000fe4000000004bULL, 0x00000010ff1d7819ULL, 0x000fc4000001161eULL,
0x00000010ff1c7819ULL, 0x000fe4000001161fULL, 0x00000010ff1e7819ULL, 0x000fe20000011670ULL,
0x0000004a2830723cULL, 0x000fe20000041830ULL, 0x00000010ff1f7819ULL, 0x000fe20000011672ULL,
0x20000098ff727230ULL, 0x000fe20000004100ULL, 0x000010541d1e7816ULL, 0x000fe4000000001eULL,
0x000010541c1f7816ULL, 0x000fe4000000001fULL, 0x00000008ff987819ULL, 0x000fc40000011656ULL,
0x00000010ff1c7819ULL, 0x000fe40000011694ULL, 0x00000010ff1d7819ULL, 0x000fe20000011696ULL,
0x0000001e283c723cULL, 0x000fe2000004183cULL, 0x00000010ff567819ULL, 0x000fe40000011697ULL,
0x0000000711977812ULL, 0x000fe400078e7852ULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x00001054561d7816ULL, 0x000fe20000000095ULL, 0x0000000852567824ULL, 0x000fe200078e0297ULL,
0x00000010ff1e7819ULL, 0x000fc40000011649ULL, 0x00000010ff1f7819ULL, 0x000fe40000011648ULL,
0x00000010ff497819ULL, 0x000fe20000011693ULL, 0x0000001c2838723cULL, 0x000fe20000041838ULL,
0x00000010ff487819ULL, 0x000fe40000011671ULL, 0x0000a00056937811ULL, 0x000fe400078e20ffULL,
0x000010541f487816ULL, 0x000fe40000000048ULL, 0x000010541e497816ULL, 0x000fc40000000049ULL,
0x00000000931c783bULL, 0x000e620000000200ULL, 0x000000ff90947812ULL, 0x000fe400078ec0ffULL,
0x0000008fff90723eULL, 0x000fe400020006ffULL, 0x000000482834723cULL, 0x000fe20000041834ULL,
0x00000010ff8f7819ULL, 0x000fe40000011680ULL, 0x00000010ff8e7819ULL, 0x000fe2000001168eULL,
0x20000090ff807230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fc400020006ffULL,
0x00000010ff497819ULL, 0x000fe40000011679ULL, 0x00000010ff487819ULL, 0x000fe2000001168dULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fe40000011688ULL,
0x0000105449487816ULL, 0x000fe40000000048ULL, 0x000010548f497816ULL, 0x000fe4000000008eULL,
0x00000010ff887819ULL, 0x000fc40000011689ULL, 0x00000008ff7d7819ULL, 0x000fe4000001167dULL,
0x00001054884b7816ULL, 0x000fe2000000004bULL, 0x00000048282c723cULL, 0x000fe2000004182cULL,
0x00000010ff4a7819ULL, 0x000fe4000001168cULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff8a7819ULL, 0x000fc4000001168aULL,
0x00000010ff887819ULL, 0x000fe40000011685ULL, 0x00000010ff497819ULL, 0x000fe40000011686ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x0000007f1c1c9231ULL, 0x082fe200003400ffULL,
0x000010548b4a7816ULL, 0x000fe2000000004aULL, 0x0000007f1e1e9231ULL, 0x000fe200003400ffULL,
0x0000105487487816ULL, 0x000fe2000000008aULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x0000105488497816ULL, 0x000fe20000000049ULL, 0x0000007e1d1d9231ULL, 0x080fe200003400ffULL,
0x000000ff75997812ULL, 0x000fe200078ec0ffULL, 0x0000004a2820723cULL, 0x000fe20000041820ULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x0000007e1f1f9231ULL, 0x000fe200003400ffULL,
0x00000010ff7b7819ULL, 0x000fc4000001167bULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x0000009cff9c723eULL, 0x000fe200020006ffULL, 0x000000482824723cULL, 0x000fe20000041824ULL,
0x0000009dff9d723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x2000009cff757230ULL, 0x000fe20000004100ULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x2000009dff737230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe2000001167cULL, 0x20000099ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff287819ULL, 0x000fc4000001167dULL, 0x00000010ff2a7819ULL, 0x000fe40000011676ULL,
0x0000105429287816ULL, 0x000fe40000000028ULL, 0x000010547a297816ULL, 0x000fe4000000007bULL,
0x00000010ff2b7819ULL, 0x000fe40000011674ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff487819ULL, 0x000fe20000011673ULL, 0x000000281c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff6e7819ULL, 0x000fc4000001166eULL, 0x00000010ff497819ULL, 0x000fe40000011670ULL,
0x00000098ff98723eULL, 0x000fe400020006ffULL, 0x00000010ff287819ULL, 0x000fe4000001166fULL,
0x00000010ff297819ULL, 0x000fe20000011672ULL, 0x20000098ff717230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fc400020006ffULL,
0x00001054752a7816ULL, 0x000fe2000000002aULL, 0x20000094ff797230ULL, 0x000fe20000004100ULL,
0x00001054482b7816ULL, 0x000fe2000000002bULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000105429287816ULL, 0x000fe40000000028ULL, 0x0000105449297816ULL, 0x000fe4000000006eULL,
0x000000ff82827812ULL, 0x000fe200078ec0ffULL, 0x0000002a1c38723cULL, 0x000fe20000041838ULL,
0x00000008ff777819ULL, 0x000fc40000011677ULL, 0x00000008ff6c7819ULL, 0x000fe4000001166cULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff557819ULL, 0x000fe20000011655ULL,
0x000000281c30723cULL, 0x000fe20000041830ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff487819ULL, 0x000fe40000011669ULL, 0x00000010ff2a7819ULL, 0x000fc40000011671ULL,
0x00000010ff2b7819ULL, 0x000fe40000011680ULL, 0x00000010ff287819ULL, 0x000fe40000011668ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff297819ULL, 0x000fe40000011666ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x000010546b2a7816ULL, 0x000fe2000000002aULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00001054482b7816ULL, 0x000fe2000000002bULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x0000105479287816ULL, 0x000fc40000000028ULL,
0x0000105478297816ULL, 0x000fe40000000029ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x0000002a1c2c723cULL, 0x040fe2000004182cULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff477819ULL, 0x000fe20000011647ULL, 0x000000281c20723cULL, 0x000fe20000041820ULL,
0x00000010ff2a7819ULL, 0x000fc40000011677ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff2b7819ULL, 0x000fe4000001166cULL, 0x00000010ff287819ULL, 0x000fe40000011645ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff297819ULL, 0x000fc40000011655ULL, 0x00001054834a7816ULL, 0x000fe40000000084ULL,
0x00001054824b7816ULL, 0x000fe40000000081ULL, 0x00001054472a7816ULL, 0x000fe4000000002aULL,
0x00001054462b7816ULL, 0x000fe4000000002bULL, 0x0000105428287816ULL, 0x000fe2000000006dULL,
0x0000004a1c40723cULL, 0x000fe20000041840ULL, 0x0000105444297816ULL, 0x000fce0000000029ULL,
0x0000002a1c34723cULL, 0x040ff00000041834ULL, 0x000000281c1c723cULL, 0x000fe20000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x01065c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400257305ULL, 0x0002a4000021f000ULL,
0x3fa0000024247823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x01065c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000401b247811ULL, 0x000fe200078e40ffULL, 0x00000004042a7c24ULL, 0x000fe2000f8e0207ULL,
0x00000004ff2b7819ULL, 0x000fe20000011605ULL, 0x00000100ff457424ULL, 0x000fe200078e00ffULL,
0x0000002419257217ULL, 0x000fe40007800000ULL, 0x000000402a2a7810ULL, 0x000fe40007ffe0ffULL,
0x0000c0004f477811ULL, 0x000fe200078e20ffULL, 0x0000000125257824ULL, 0x000fe200078e0a24ULL,
0x0000c0004e467811ULL, 0x000fe200078e20ffULL, 0x000000015d247824ULL, 0x000fc400078e022aULL,
0x000000015c267824ULL, 0x100fe200078e022aULL, 0x0000002025257807ULL, 0x000fe20000000000ULL,
0x000000015b287824ULL, 0x100fe400078e022aULL, 0x000000015a2a7824ULL, 0x000fe200078e022aULL,
0x0000002506277217ULL, 0x000fe20007800000ULL, 0x00005e0024247625ULL, 0x000fc800078e0045ULL,
0x0000000127447824ULL, 0x000fe200078e0a06ULL, 0x0000001024487210ULL, 0x000fe20007f7e0ffULL,
0x00005e0026267625ULL, 0x000fc600078e0045ULL, 0x000000442b00720cULL, 0x000fe20003f46070ULL,
0x00005e0028287625ULL, 0x000fe200078e0045ULL, 0x0000001026247210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff497224ULL, 0x000fe200018e0625ULL, 0x0000001028267210ULL, 0x000fe20007fbe0ffULL,
0x00005e002a2a7625ULL, 0x000fe200078e0045ULL, 0x000000441100720cULL, 0x080fe40003f66070ULL,
0x0000c0004d457811ULL, 0x000fe200078e20ffULL, 0x000000ffff257224ULL, 0x000fe200020e0627ULL,
0x000000441300720cULL, 0x080fe20003f86070ULL, 0x000000ffff277224ULL, 0x000fe200028e0629ULL,
0x000000441500720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000048477faeULL, 0x0003e2000d101c46ULL, 0x000000102a287210ULL, 0x000fc40007fde0ffULL,
0x0000c0004c447811ULL, 0x000fc600078e20ffULL, 0x000000ffff297224ULL, 0x000fe200030e062bULL,
0x0000000024467faeULL, 0x0003e8000d901c46ULL, 0x0000000026457faeULL, 0x0003e8000e101c46ULL,
0x0000000028447faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff257984ULL, 0x002e620000000800ULL, 0x0000ffff6a247812ULL, 0x000fc800078ec0ffULL,
0x0000888024267816ULL, 0x000fca00000000ffULL, 0x8000000026247824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x002fe20007844824ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x01065400ff257984ULL, 0x000e620000000800ULL,
0x8000000026247824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x002fe20007844824ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000026257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff247424ULL, 0x000fc800078e00ffULL,
0x0000002400267305ULL, 0x0002a4000021f000ULL, 0x3fa0000024247823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x004fe40003800000ULL, 0x01065400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fc40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000e00054547811ULL, 0x000fe400078e20ffULL,
0x0000000713557812ULL, 0x100fe400078e7852ULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000005424783bULL, 0x000e620000004200ULL, 0x00000007154d7812ULL, 0x000fe200078e7852ULL,
0x0000000852557824ULL, 0x000fe200078e0255ULL, 0x0000e00050507811ULL, 0x000fe200078e20ffULL,
0x000000005148783bULL, 0x000ea20000004200ULL, 0x0000e00053537811ULL, 0x000fe200078e20ffULL,
0x0000000852527824ULL, 0x000fe200078e024dULL, 0x00000017ff9f723eULL, 0x000fe200000010ffULL,
0x00000000504c783bULL, 0x000ee20000004200ULL, 0x00000002ffa27819ULL, 0x000fc40000011605ULL,
0x000054109f9f7816ULL, 0x000fe2000000009fULL, 0x000000005328783bULL, 0x000f220000004200ULL,
0x000000ff25957812ULL, 0x042fe400078ec0ffULL, 0x000000ff269c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff947819ULL, 0x100fe40000011625ULL, 0x00000018ff717819ULL, 0x000fe40000011625ULL,
0x0000ffff25917812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7e7819ULL, 0x104fe40000011648ULL,
0x000000ff48777812ULL, 0x040fe400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe40000011648ULL,
0x0000ffff48257812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x008fe4000001164cULL,
0x000000ff4c6f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe4000001164cULL,
0x0000ffff4c907812ULL, 0x000fe400078ec0ffULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x0000009cff4c723eULL, 0x000fe400020006ffULL, 0x00000018ff8a7819ULL, 0x000fe20000011626ULL,
0x20000095ff9c7230ULL, 0x000fe20000004100ULL, 0x00000018ff977819ULL, 0x010fe20000011628ULL,
0x2000004cff957230ULL, 0x000fe20000004100ULL, 0x00000018ff7a7819ULL, 0x000fc40000011629ULL,
0x00000018ff857819ULL, 0x000fe4000001162aULL, 0x00000018ff8d7819ULL, 0x000fe40000011627ULL,
0x0000008aff4c723eULL, 0x000fe400020006ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x000000ff2a817812ULL, 0x000fe200078ec0ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff497b7812ULL, 0x000fc400078ec0ffULL, 0x0000007aff8a723eULL, 0x000fe200020006ffULL,
0x20000097ff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x100fe40000011649ULL,
0x00000018ff7d7819ULL, 0x000fe40000011649ULL, 0x0000ffff49767812ULL, 0x000fe400078ec0ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000010ff937819ULL, 0x000fc4000001164dULL,
0x000000ff4d707812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164dULL,
0x0000ffff4d787812ULL, 0x000fe400078ec0ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x0000008dff4d723eULL, 0x000fe400020006ffULL, 0x000000ff4a837812ULL, 0x000fc400078ec0ffULL,
0x00000081ff8d723eULL, 0x000fe200020006ffULL, 0x2000008aff817230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x20000085ff8a7230ULL, 0x000fe20000004100ULL,
0x0000007dff97723eULL, 0x000fe200020006ffULL, 0x20000077ff857230ULL, 0x000fe20000004100ULL,
0x000000ff4b6c7812ULL, 0x000fe200078ec0ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000083ff77723eULL, 0x000fe200020006ffULL, 0x2000007bff837230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000097ff7b7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x0000006fff97723eULL, 0x000fe200020006ffULL, 0x20000075ff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x100fe20000011624ULL, 0x2000006cff757230ULL, 0x000fe20000004100ULL,
0x000000ff24667812ULL, 0x040fe200078ec0ffULL, 0x20000097ff6c7230ULL, 0x000fe20000004100ULL,
0x00000018ff967819ULL, 0x000fe20000011624ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x0000ffff248f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe40000011628ULL,
0x000000ff28987812ULL, 0x040fe400078ec0ffULL, 0x0000ffff28847812ULL, 0x000fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001164aULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x00000048ff48723eULL, 0x000fc400020006ffULL, 0x00000010ff287819ULL, 0x000fe4000001162aULL,
0x0000ffff2a7f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7c7819ULL, 0x000fe4000001164aULL,
0x0000ffff4a247812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2a7819ULL, 0x000fe4000001162bULL,
0x000000ff2b887812ULL, 0x000fc400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe4000001162bULL,
0x0000ffff2b827812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001164eULL,
0x00000018ff2b7819ULL, 0x000fe4000001164fULL, 0x00000010ff927819ULL, 0x000fe40000011626ULL,
0x0000ffff26897812ULL, 0x000fc400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000069ff97723eULL, 0x000fe200020006ffULL, 0x20000048ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fe40000011629ULL, 0x00000010ff747819ULL, 0x100fe4000001164bULL,
0x00000018ff6b7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b267812ULL, 0x000fc400078ec0ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000010ff797819ULL, 0x000fe4000001164eULL,
0x000000ff4e4b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e6d7812ULL, 0x000fe400078ec0ffULL,
0x0000004aff48723eULL, 0x000fe200020006ffULL, 0x20000097ff4a7230ULL, 0x000fe20000004100ULL,
0x00000098ff4e723eULL, 0x000fc400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x000000ff94947812ULL, 0x000fe200078ec0ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff29997812ULL, 0x000fe400078ec0ffULL, 0x00000070ff98723eULL, 0x000fe200020006ffULL,
0x20000068ff707230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x20000049ff687230ULL, 0x000fe20000004100ULL, 0x0000ffff27727812ULL, 0x000fe200078ec0ffULL,
0x20000048ff497230ULL, 0x000fe20000004100ULL, 0x0000ffff29297812ULL, 0x000fe200078ec0ffULL,
0x2000002bff487230ULL, 0x000fe20000004100ULL, 0x00000008ff8f7819ULL, 0x000fc4000001168fULL,
0x00000008ff897819ULL, 0x000fe40000011689ULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x20000094ff9e7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000092ff977230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fc40000011672ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000008ff2b7819ULL, 0x000fe40000011629ULL, 0x0000a00055297811ULL, 0x000fe200078e20ffULL,
0x2000008cff927230ULL, 0x000fe20000004100ULL, 0x000000ff28287812ULL, 0x000fe400078ec0ffULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x00000066ff9b723eULL, 0x000fc400020006ffULL,
0x00000010ff6e7819ULL, 0x000fe4000001164fULL, 0x0000ffff4f667812ULL, 0x000fe200078ec0ffULL,
0x2000009bff9b7230ULL, 0x000fe20000004100ULL, 0x00000099ff4f723eULL, 0x000fe200020006ffULL,
0x2000008fff997230ULL, 0x000fe20000004100ULL, 0x00000072ff94723eULL, 0x000fe200020006ffULL,
0x20000089ff727230ULL, 0x000fe20000004100ULL, 0x0000002bff8f723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000028ff8c723eULL, 0x000fe200020006ffULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x0000002aff89723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x000000002928783bULL, 0x000fe20000000200ULL,
0x00000010ff8b7819ULL, 0x000fe20000011627ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff917819ULL, 0x000fe20000011691ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000000ff87877812ULL, 0x000fc400078ec0ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff827819ULL, 0x000fe40000011682ULL, 0x00000008ff7f7819ULL, 0x000fe4000001167fULL,
0x000000ff279a7812ULL, 0x000fe400078ec0ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000006bff6f7230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000098ff6b7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000096ff27723eULL, 0x000fe200020006ffULL, 0x2000008bff987230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x000000ff80807812ULL, 0x000fe200078ec0ffULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x0000009aff96723eULL, 0x000fe200020006ffULL,
0x20000091ff9a7230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL,
0x20000087ff917230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe20000011684ULL,
0x20000082ff877230ULL, 0x000fe20000004100ULL, 0x00000080ff82723eULL, 0x000fe200020006ffULL,
0x2000007fff8b7230ULL, 0x000fe20000004100ULL, 0x00001f189f807589ULL, 0x000e6200000e0000ULL,
0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x00001fa29f7f7589ULL, 0x0004e200000e0000ULL,
0x00000008ff257819ULL, 0x000fe20000011625ULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x2000008eff9d7230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x20000084ff8e7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000007eff847230ULL, 0x000fe20000004100ULL, 0x00000008ff9f7819ULL, 0x004fe20000011624ULL,
0x20000025ff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe2000001169bULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe4000001169cULL,
0x00000010ff9d7819ULL, 0x000fc4000001169dULL, 0x00000010ff9e7819ULL, 0x000fe2000001169eULL,
0x0000008029299231ULL, 0x082fe200003400ffULL, 0x00000008ff9c7819ULL, 0x000fe20000011626ULL,
0x000000802b2b9231ULL, 0x000fe200003400ffULL, 0x000010549d247816ULL, 0x000fe20000000024ULL,
0x0000007f28289231ULL, 0x088fe200003400ffULL, 0x000010549e257816ULL, 0x000fe20000000025ULL,
0x0000007f2a2a9231ULL, 0x000fe200003400ffULL, 0x00000010ff277819ULL, 0x000fe40000011627ULL,
0x00000010ff267819ULL, 0x000fc40000011699ULL, 0x00000010ff9b7819ULL, 0x000fe40000011671ULL,
0x00000010ff9a7819ULL, 0x000fe2000001169aULL, 0x000000242840723cULL, 0x000fe20000041840ULL,
0x0000105427267816ULL, 0x000fe40000000026ULL, 0x000010549b277816ULL, 0x000fe4000000009aULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x00000010ff247819ULL, 0x000fc40000011695ULL,
0x00000010ff257819ULL, 0x000fe20000011696ULL, 0x00000026283c723cULL, 0x000fe2000004183cULL,
0x00000010ff987819ULL, 0x000fe40000011698ULL, 0x0000105497247816ULL, 0x000fe40000000024ULL,
0x0000105498257816ULL, 0x000fe40000000025ULL, 0x00000010ff267819ULL, 0x000fe4000001164dULL,
0x00000010ff277819ULL, 0x000fc4000001164cULL, 0x00000010ff4d7819ULL, 0x000fe20000011694ULL,
0x000000242838723cULL, 0x000fe20000041838ULL, 0x00000010ff4c7819ULL, 0x000fe40000011672ULL,
0x0000a00052947811ULL, 0x000fe400078e20ffULL, 0x00001054274c7816ULL, 0x000fe4000000004cULL,
0x00001054264d7816ULL, 0x000fe4000000004dULL, 0x000000009424783bULL, 0x000e620000000200ULL,
0x000000ff93937812ULL, 0x000fc400078ec0ffULL, 0x00000008ff907819ULL, 0x000fe40000011690ULL,
0x00000093ff95723eULL, 0x000fe200020006ffULL, 0x0000004c2834723cULL, 0x000fe20000041834ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff927819ULL, 0x000fc40000011692ULL,
0x00000090ff93723eULL, 0x000fe400020006ffULL, 0x00000010ff4d7819ULL, 0x000fe4000001167aULL,
0x00000010ff4c7819ULL, 0x000fe2000001168eULL, 0x20000093ff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fe20000011681ULL, 0x20000095ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00001054914e7816ULL, 0x000fe2000000004eULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00001054924f7816ULL, 0x000fe2000000004fULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x000010544d4c7816ULL, 0x000fe4000000004cULL,
0x00001054904d7816ULL, 0x000fe4000000008fULL, 0x00000008ff767819ULL, 0x000fe20000011676ULL,
0x0000004e2830723cULL, 0x040fe20000041830ULL, 0x00000010ff887819ULL, 0x000fe20000011688ULL,
0x0000007f24249231ULL, 0x082fe200003400ffULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x0000007f26269231ULL, 0x000fe200003400ffULL, 0x00000010ff8a7819ULL, 0x000fe2000001168aULL,
0x0000008025259231ULL, 0x080fe200003400ffULL, 0x00000010ff4e7819ULL, 0x000fe2000001168dULL,
0x0000004c282c723cULL, 0x000fe2000004182cULL, 0x00000010ff4f7819ULL, 0x000fe2000001168cULL,
0x0000008027279231ULL, 0x000fe200003400ffULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff4d7819ULL, 0x000fe40000011687ULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x000010544f4e7816ULL, 0x000fe4000000004eULL, 0x00001054894f7816ULL, 0x000fc40000000088ULL,
0x000010548a4c7816ULL, 0x000fe4000000008bULL, 0x00001054864d7816ULL, 0x000fe4000000004dULL,
0x0000007cffa0723eULL, 0x000fe200020006ffULL, 0x20000076ff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff74747812ULL, 0x000fe200078ec0ffULL, 0x0000004e2820723cULL, 0x000fe20000041820ULL,
0x00000010ff7d7819ULL, 0x000fe2000001167dULL, 0x200000a0ff767230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x0000009fff9f723eULL, 0x000fe400020006ffULL,
0x0000009cff99723eULL, 0x000fe200020006ffULL, 0x0000004c281c723cULL, 0x000fe2000004181cULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000000ff739a7812ULL, 0x000fe200078ec0ffULL,
0x2000009fff717230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fe20000011678ULL,
0x20000099ff737230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff2a7819ULL, 0x000fc4000001167bULL, 0x00000010ff287819ULL, 0x000fe4000001167eULL,
0x00000010ff297819ULL, 0x000fe4000001167cULL, 0x000010547d287816ULL, 0x000fe40000000028ULL,
0x000010542a297816ULL, 0x000fe40000000029ULL, 0x00000010ff2a7819ULL, 0x000fe40000011677ULL,
0x00000010ff2b7819ULL, 0x000fc40000011676ULL, 0x00000010ff747819ULL, 0x000fe20000011674ULL,
0x00000028243c723cULL, 0x000fe2000004183cULL, 0x0000009aff9a723eULL, 0x000fe400020006ffULL,
0x00000010ff4c7819ULL, 0x000fe4000001166fULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x2000009aff727230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe40000011670ULL,
0x00000010ff287819ULL, 0x000fc40000011671ULL, 0x000010542b2a7816ULL, 0x000fe4000000002aULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00001054742b7816ULL, 0x000fe40000000075ULL,
0x0000105429287816ULL, 0x000fe20000000028ULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x000010544c297816ULL, 0x000fe40000000073ULL, 0x000000ff79797812ULL, 0x000fe200078ec0ffULL,
0x0000002a2438723cULL, 0x000fe20000041838ULL, 0x000000ff6e6e7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff2a7819ULL, 0x000fe2000001166cULL, 0x000000282434723cULL, 0x000fe20000041834ULL,
0x00000010ff2b7819ULL, 0x000fe40000011672ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff4c7819ULL, 0x000fc40000011681ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff287819ULL, 0x000fe4000001167aULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff297819ULL, 0x000fe40000011678ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x000010542b2a7816ULL, 0x000fe2000000002aULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x000010544c2b7816ULL, 0x000fe4000000006bULL,
0x0000105469287816ULL, 0x000fe20000000028ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000105468297816ULL, 0x000fc40000000029ULL, 0x00000010ff857819ULL, 0x000fe20000011685ULL,
0x0000002a2430723cULL, 0x040fe20000041830ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff2a7819ULL, 0x000fe2000001164bULL, 0x00000028242c723cULL, 0x000fe2000004182cULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff2b7819ULL, 0x000fe4000001164aULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff287819ULL, 0x000fe40000011649ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff297819ULL, 0x000fc40000011666ULL, 0x00001054844e7816ULL, 0x000fe40000000085ULL,
0x00001054824f7816ULL, 0x000fe40000000083ULL, 0x00001054792a7816ULL, 0x000fe4000000002aULL,
0x000010546e2b7816ULL, 0x000fe4000000002bULL, 0x0000105428287816ULL, 0x000fe2000000006dULL,
0x0000004e2440723cULL, 0x000fe20000041840ULL, 0x0000105448297816ULL, 0x000fce0000000029ULL,
0x0000002a2420723cULL, 0x040ff00000041820ULL, 0x000000282424723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000401b1c7811ULL, 0x000fe200078e40ffULL, 0x01061000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff6aff7812ULL, 0x000fc4000782c0ffULL, 0x0000001c1900720cULL, 0x000fe40003f44070ULL,
0x00000001ff6a7807ULL, 0x000fd60000800000ULL, 0x0000b7a00000a947ULL, 0x000fea0003800000ULL,
0x01065c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01065c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000300ff687624ULL, 0x000fe200078e00ffULL, 0x00000001031c7812ULL, 0x000fe200078ec0ffULL,
0x0000000404287c24ULL, 0x000fe4000f8e0207ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x000000011c00780cULL, 0x000fe40003f25070ULL, 0xffffffff68687811ULL, 0x000fc800078e08ffULL,
0x0000000168687807ULL, 0x000fca0004800000ULL, 0x0000000103037824ULL, 0x000fe200078e0268ULL,
0x000000601b1c7811ULL, 0x000fc800078e40ffULL, 0x000000000300720cULL, 0x000fe40003f26070ULL,
0x0000001c191d7217ULL, 0x000fca0007800000ULL, 0x000000011d1d7824ULL, 0x000fe200078e0a1cULL,
0x0000006028287810ULL, 0x000fca0007ffe0ffULL, 0x000000680c1e9210ULL, 0x000fe20007ffe067ULL,
0x00000004ff1f9424ULL, 0x000fe200078e00ffULL, 0x000000201d297807ULL, 0x000fe20000000000ULL,
0x00000100ff4b7424ULL, 0x000fe400078e00ffULL, 0x000060001e1e9625ULL, 0x000fe200078e001fULL,
0x0000002906297217ULL, 0x000fc60007800000ULL, 0x000000015d1c7824ULL, 0x100fe200078e0228ULL,
0x000000061e049981ULL, 0x000362000c1e1900ULL, 0x000000015c2a7824ULL, 0x100fe200078e0228ULL,
0x00000004ff497819ULL, 0x000fe20000011605ULL, 0x000000015b2b7824ULL, 0x000fe400078e0228ULL,
0x00005e001c1c7625ULL, 0x000fc800078e004bULL, 0x0000000129487824ULL, 0x000fe200078e0a06ULL,
0x000000101c1c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e002a1e7625ULL, 0x002fc600078e004bULL,
0x000000484900720cULL, 0x000fe20003f46070ULL, 0x000000015a2a7824ULL, 0x000fe200078e0228ULL,
0x000000101e1e7210ULL, 0x000fe20007f7e0ffULL, 0x00005e002b287625ULL, 0x000fc800078e004bULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000001028287210ULL, 0x000fe20007f9e0ffULL,
0x00005e002a2a7625ULL, 0x000fe200078e004bULL, 0x000000481100720cULL, 0x000fc60003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200018e061fULL, 0x000000481300720cULL, 0x080fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200020e0629ULL, 0x000000481500720cULL, 0x000fe20003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000d101c46ULL,
0x000000102a2a7210ULL, 0x000fca0007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x000000001e647faeULL, 0x0003e8000c901c46ULL, 0x0000000028637faeULL, 0x0003e8000d901c46ULL,
0x000000002a627faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1d7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01061c00ff1e7984ULL, 0x000ea20000000800ULL, 0x000000ff0dff7812ULL, 0x000fe2000782c0ffULL,
0x800000005e1f7824ULL, 0x000fc600078e00ffULL, 0x00000001ff667807ULL, 0x000fca0000800000ULL,
0x80000000661c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x002fe4000782481cULL,
0x800000001eff7812ULL, 0x004fe2000784481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x800000005e1e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01061c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01008000611d7984ULL, 0x000e620000000800ULL, 0x00000001ff697424ULL, 0x000fc600078e00ffULL,
0x01028000611c7984ULL, 0x0004e20000000800ULL, 0x000000081d00720bULL, 0x002fda0003f5d000ULL,
0x00000000001e7806ULL, 0x000fc800010e0100ULL, 0x0000ffff1e287812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000081d00720bULL, 0x00cfe40003f54000ULL,
0x0000001d081e7209ULL, 0x000fe40007810000ULL, 0x00000002ff2a7819ULL, 0x000fc60000011605ULL,
0x8000001e081f7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400010e0100ULL, 0x000000011a00780cULL, 0x000fe40003f45270ULL,
0x0000ffff08297812ULL, 0x000fe200078e3cffULL, 0x0000001f001f7308ULL, 0x000e660000000800ULL,
0x0000002928ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff697807ULL, 0x000fc60001800000ULL,
0x0104801e6100a388ULL, 0x000fe80000000800ULL, 0x00001f2a1f087589ULL, 0x002e6400000e0000ULL,
0x8000001e1d283221ULL, 0x000fe20000010000ULL, 0x0000001f09097220ULL, 0x000fe20000410000ULL,
0x00001f181f1d7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b28283820ULL, 0x000fc80000410000ULL,
0x0000002800173308ULL, 0x000ee20000000800ULL, 0x0000000840407220ULL, 0x082fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x000fe20000410000ULL, 0x0000001d42427220ULL, 0x084fe20000410000ULL,
0x0000001d43437220ULL, 0x080fe20000410000ULL, 0x0000001d3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001d3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001d36367220ULL, 0x080fe20000410000ULL,
0x0000001d37377220ULL, 0x080fe20000410000ULL, 0x0000001d32327220ULL, 0x080fe20000410000ULL,
0x0000001d33337220ULL, 0x080fe20000410000ULL, 0x0000001d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001d22227220ULL, 0x080fe20000410000ULL,
0x0000001d23237220ULL, 0x080fe20000410000ULL, 0x0000001d26267220ULL, 0x080fe20000410000ULL,
0x0000001d27277220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fe200078e001eULL,
0x0000001c171c3220ULL, 0x008fc80000410000ULL, 0x000000091c097221ULL, 0x00cfe20000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x01064c00ff1c7984ULL, 0x000e620000000800ULL,
0x80000000661d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x002fe2000782481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x80000000661e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01064c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000005f1c783bULL, 0x000e620000004200ULL,
0x00000017ffa1723eULL, 0x000fe400000010ffULL, 0x00000002ffa27819ULL, 0x000fe20000011605ULL,
0x000000005848783bULL, 0x000ea20000004200ULL, 0x00005410a1a17816ULL, 0x000fc600000000a1ULL,
0x000000005928783bULL, 0x000ee80000004200ULL, 0x00000000574c783bULL, 0x000f220000004200ULL,
0x000000ff1d727812ULL, 0x002fe400078ec0ffULL, 0x00000018ff967819ULL, 0x000fe4000001161dULL,
0x000000ff1e9d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8f7819ULL, 0x000fc4000001161cULL,
0x000000ff1c6a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fe4000001161cULL,
0x0000ffff1c907812ULL, 0x000fe400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff7d7819ULL, 0x004fe4000001164aULL, 0x000000ff4a847812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a1c7812ULL, 0x000fe400078ec0ffULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x0000009dff4a723eULL, 0x000fe200020006ffULL,
0x20000072ff9d7230ULL, 0x000fe20000004100ULL, 0x00000018ff8b7819ULL, 0x000fe2000001161eULL,
0x20000096ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff887819ULL, 0x008fe20000011628ULL,
0x2000004aff967230ULL, 0x000fe20000004100ULL, 0x000000ff28997812ULL, 0x000fc400078ec0ffULL,
0x00000018ff947819ULL, 0x000fe40000011628ULL, 0x0000ffff28857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x100fe4000001161fULL, 0x000000ff1f9b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001161fULL, 0x0000ffff1f737812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011629ULL, 0x00000010ff287819ULL, 0x100fe4000001162aULL,
0x000000ff2a827812ULL, 0x040fe400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe4000001162aULL,
0x0000ffff2a807812ULL, 0x000fe400078ec0ffULL, 0x0000006aff9c723eULL, 0x000fc400020006ffULL,
0x00000010ff2a7819ULL, 0x100fe4000001162bULL, 0x000000ff2b8a7812ULL, 0x040fe200078ec0ffULL,
0x2000009cff9c7230ULL, 0x000fe20000004100ULL, 0x00000018ff877819ULL, 0x000fe4000001162bULL,
0x0000ffff2b837812ULL, 0x000fe400078ec0ffULL, 0x00009910691f7816ULL, 0x000fe400000000ffULL,
0x00000010ff7a7819ULL, 0x010fc4000001164eULL, 0x000000ff4e6b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001164eULL, 0x0000ffff4e6e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff48787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fe4000001164fULL,
0x000000ff4f4e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001164fULL,
0x0000ffff4f697812ULL, 0x000fe400078ec0ffULL, 0x0000008bff4a723eULL, 0x000fe400020006ffULL,
0x00000094ff4f723eULL, 0x000fe400020006ffULL, 0x000000ff497c7812ULL, 0x000fe200078ec0ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000007bff8b723eULL, 0x000fe200020006ffULL,
0x2000004fff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fc4000001161eULL,
0x0000ffff1e897812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011649ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000010ff757819ULL, 0x100fe4000001164bULL,
0x000000ff4b707812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001164bULL,
0x0000ffff4b1e7812ULL, 0x000fe400078ec0ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x0000008eff4b723eULL, 0x000fe400020006ffULL, 0x00000018ff767819ULL, 0x000fe40000011648ULL,
0x00000082ff8e723eULL, 0x000fe200020006ffULL, 0x2000008bff827230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000086ff8b7230ULL, 0x000fe20000004100ULL,
0x0000007eff4f723eULL, 0x000fe200020006ffULL, 0x20000078ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff957819ULL, 0x000fe2000001161dULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x0000ffff1d927812ULL, 0x000fe200078ec0ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff4c717812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7f7819ULL, 0x000fe40000011648ULL,
0x0000ffff481d7812ULL, 0x000fe400078ec0ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000084ff78723eULL, 0x000fe200020006ffULL, 0x2000007cff847230ULL, 0x000fe20000004100ULL,
0x00000018ff487819ULL, 0x000fe2000001164cULL, 0x2000004fff7c7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000076ff7e7230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000071ff4f723eULL, 0x000fe200020006ffULL, 0x20000070ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fe20000011649ULL, 0x2000006dff707230ULL, 0x000fe20000004100ULL,
0x0000ffff49777812ULL, 0x000fe200078ec0ffULL, 0x2000004fff6d7230ULL, 0x000fe20000004100ULL,
0x00000048ff48723eULL, 0x000fc400020006ffULL, 0x00000018ff497819ULL, 0x000fe4000001164dULL,
0x0000006bff4f723eULL, 0x000fe200020006ffULL, 0x20000048ff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff8d7819ULL, 0x000fe40000011629ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000006aff48723eULL, 0x000fe400020006ffULL,
0x000000ff4d987812ULL, 0x000fe200078ec0ffULL, 0x20000049ff6a7230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x20000048ff497230ULL, 0x000fe20000004100ULL,
0x000000ff95957812ULL, 0x000fc400078ec0ffULL, 0x000000ff299a7812ULL, 0x000fe200078ec0ffULL,
0x2000002bff487230ULL, 0x000fe20000004100ULL, 0x000000ff93937812ULL, 0x000fe400078ec0ffULL,
0x0000ffff29297812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff897819ULL, 0x000fe40000011689ULL, 0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x2000006cff717230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000098ff6c7230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x20000095ff9f7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000093ff987230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x2000008fff9e7230ULL, 0x000fe20000004100ULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x00000008ff2b7819ULL, 0x000fe40000011629ULL,
0x0000a80060297811ULL, 0x000fe200078e20ffULL, 0x2000008dff937230ULL, 0x000fe20000004100ULL,
0x000000ff28287812ULL, 0x000fe400078ec0ffULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x00000073ff95723eULL, 0x000fe200020006ffULL, 0x20000089ff737230ULL, 0x000fe20000004100ULL,
0x0000002bff8f723eULL, 0x000fc400020006ffULL, 0x00000028ff8d723eULL, 0x000fe200020006ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x0000002aff89723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x000000002928783bULL, 0x000fe20000000200ULL,
0x00000008ff927819ULL, 0x000fe20000011692ULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff837819ULL, 0x000fc40000011683ULL,
0x00000008ff807819ULL, 0x000fe40000011680ULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000000ff1f00720cULL, 0x000fe20003f25270ULL, 0x20000099ff947230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000097ff1f723eULL, 0x000fe200020006ffULL, 0x2000008cff997230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x000000ff81817812ULL, 0x000fe200078ec0ffULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x0000009bff97723eULL, 0x000fe200020006ffULL,
0x20000092ff9b7230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe20000011690ULL,
0x20000088ff927230ULL, 0x000fe20000004100ULL, 0x00000008ff857819ULL, 0x000fe20000011685ULL,
0x20000083ff887230ULL, 0x000fe20000004100ULL, 0x00000081ff83723eULL, 0x000fe200020006ffULL,
0x20000080ff8c7230ULL, 0x000fe20000004100ULL, 0x00001fa2a1817589ULL, 0x000e6200000e0000ULL,
0x00000008ff777819ULL, 0x000fe20000011677ULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x00001f18a1807589ULL, 0x000ea200000e0000ULL,
0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000008ff1d7819ULL, 0x000fc4000001161dULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000010ff747819ULL, 0x000fe4000001164cULL, 0x0000ffff4c917812ULL, 0x000fe400078ec0ffULL,
0x0000007fff7f723eULL, 0x000fc400020006ffULL, 0x0000007dffa0723eULL, 0x000fe200020006ffULL,
0x20000077ff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff4c7819ULL, 0x000fe2000001164dULL,
0x0000008128289231ULL, 0x082fe200003400ffULL, 0x0000ffff4d797812ULL, 0x000fe200078ec0ffULL,
0x200000a0ff777230ULL, 0x000fe20000004100ULL, 0x0000001dff1d723eULL, 0x000fe200020006ffULL,
0x000000812a2a9231ULL, 0x000fe200003400ffULL, 0x0000009aff4d723eULL, 0x000fe200020006ffULL,
0x20000090ff9a7230ULL, 0x000fe20000004100ULL, 0x00000008ffa07819ULL, 0x000fe2000001161cULL,
0x20000085ff907230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe2000001169cULL,
0x2000007fff857230ULL, 0x000fe20000004100ULL, 0x00000010ff9d7819ULL, 0x000fe2000001169dULL,
0x2000001dff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x000fe2000001169eULL,
0x0000008029299231ULL, 0x084fe200003400ffULL, 0x00000010ff9c7819ULL, 0x000fe2000001169fULL,
0x000000802b2b9231ULL, 0x000fe200003400ffULL, 0x000010541d1c7816ULL, 0x000fe2000000001cULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x000010549c1d7816ULL, 0x000fc4000000009dULL,
0x00000008ff9d7819ULL, 0x000fe4000001161eULL, 0x00000010ff1f7819ULL, 0x000fe4000001161fULL,
0x00000010ff1e7819ULL, 0x000fe2000001169aULL, 0x0000001c2840723cULL, 0x000fe20000041840ULL,
0x00000010ff9c7819ULL, 0x000fe40000011672ULL, 0x00000010ff9b7819ULL, 0x000fe4000001169bULL,
0x000010541f1e7816ULL, 0x000fc4000000001eULL, 0x000010549c1f7816ULL, 0x000fe4000000009bULL,
0x00000010ff1c7819ULL, 0x000fe40000011696ULL, 0x00000010ff1d7819ULL, 0x000fe40000011698ULL,
0x00000010ff977819ULL, 0x000fe20000011697ULL, 0x0000001e283c723cULL, 0x000fe2000004183cULL,
0x00000010ff967819ULL, 0x000fe40000011699ULL, 0x000010541d1c7816ULL, 0x000fc4000000001cULL,
0x00001054961d7816ULL, 0x000fe40000000097ULL, 0x00000010ff1e7819ULL, 0x000fe4000001164bULL,
0x00000010ff1f7819ULL, 0x000fe4000001164aULL, 0x00000010ff4b7819ULL, 0x000fe20000011695ULL,
0x0000001c2838723cULL, 0x000fe20000041838ULL, 0x00000010ff4a7819ULL, 0x000fe40000011673ULL,
0x0000a80056957811ULL, 0x000fc400078e20ffULL, 0x000010541f4a7816ULL, 0x000fe4000000004aULL,
0x000010541e4b7816ULL, 0x000fe4000000004bULL, 0x00000000951c783bULL, 0x000e620000000200ULL,
0x00000008ff967819ULL, 0x000fe40000011691ULL, 0x000000ff4c977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff917819ULL, 0x000fe2000001164dULL, 0x0000004a2834723cULL, 0x000fe20000041834ULL,
0x00000010ff4c7819ULL, 0x000fc40000011694ULL, 0x00000010ff4d7819ULL, 0x000fe40000011692ULL,
0x00000010ff927819ULL, 0x000fe40000011693ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000010544d4c7816ULL, 0x000fe4000000004cULL, 0x00001054924d7816ULL, 0x000fe20000000091ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fc4000001167bULL,
0x00000010ff4a7819ULL, 0x000fe40000011690ULL, 0x00000010ff927819ULL, 0x000fe20000011682ULL,
0x0000004c2830723cULL, 0x000fe20000041830ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x000010544b4a7816ULL, 0x000fe4000000004aULL,
0x00001054924b7816ULL, 0x000fe2000000008fULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fc4000001168aULL, 0x00000010ff8a7819ULL, 0x000fe40000011689ULL,
0x000000ff75757812ULL, 0x000fe200078ec0ffULL, 0x0000004a282c723cULL, 0x000fe2000004182cULL,
0x00000010ff4c7819ULL, 0x000fe2000001168eULL, 0x000000811c1c9231ULL, 0x082fe200003400ffULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x000000811e1e9231ULL, 0x000fe200003400ffULL,
0x000010548a4d7816ULL, 0x000fe2000000004dULL, 0x000000801d1d9231ULL, 0x080fe200003400ffULL,
0x00000010ff8b7819ULL, 0x000fe2000001168bULL, 0x000000801f1f9231ULL, 0x000fe200003400ffULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x00000010ff8a7819ULL, 0x000fe40000011687ULL,
0x00000010ff4b7819ULL, 0x000fe40000011688ULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x000010548d4c7816ULL, 0x000fe4000000004cULL, 0x000010548b4a7816ULL, 0x000fe2000000008cULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x000010548a4b7816ULL, 0x000fc4000000004bULL,
0x000000ff749b7812ULL, 0x000fe200078ec0ffULL, 0x0000004c2820723cULL, 0x040fe20000041820ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x0000009bff9b723eULL, 0x000fe400020006ffULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x0000004a2828723cULL, 0x000fe20000041824ULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x2000009bff737230ULL, 0x000fe20000004100ULL, 0x000000a0ffa0723eULL, 0x000fe200020006ffULL,
0x20000097ff827230ULL, 0x000fe20000004100ULL, 0x0000009dff9a723eULL, 0x000fc400020006ffULL,
0x00000010ff267819ULL, 0x000fe20000011678ULL, 0x200000a0ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff277819ULL, 0x000fe20000011676ULL, 0x2000009aff747230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe40000011675ULL, 0x00000010ff257819ULL, 0x000fe4000001167eULL,
0x00000010ff247819ULL, 0x000fe4000001167fULL, 0x0000105477267816ULL, 0x000fc40000000026ULL,
0x000010544a277816ULL, 0x000fe40000000027ULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x000010547c257816ULL, 0x000fe4000000007dULL, 0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL,
0x000000261c38723cULL, 0x000fe20000041838ULL, 0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff797819ULL, 0x000fc40000011679ULL, 0x00000008ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff267819ULL, 0x000fe2000001166dULL, 0x000000241c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff277819ULL, 0x000fe4000001166cULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000008ff697819ULL, 0x000fc40000011669ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe40000011672ULL, 0x00000010ff257819ULL, 0x000fe40000011674ULL,
0x0000004eff4e723eULL, 0x000fc400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000096ff96723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000096ff7b7230ULL, 0x000fe20000004100ULL,
0x0000105473267816ULL, 0x000fe20000000026ULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x0000105482277816ULL, 0x000fe20000000027ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fc400020006ffULL, 0x0000105471247816ULL, 0x000fe40000000024ULL,
0x0000105470257816ULL, 0x000fe20000000025ULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x000000261c30723cULL, 0x040fe20000041830ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff267819ULL, 0x000fe2000001164fULL, 0x000000241c34723cULL, 0x000fe20000041834ULL,
0x00000010ff277819ULL, 0x000fc4000001167aULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff247819ULL, 0x000fe4000001167bULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x00000010ff257819ULL, 0x000fe40000011679ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x0000105427267816ULL, 0x000fc40000000026ULL, 0x000010546f277816ULL, 0x000fe4000000004eULL,
0x00001054854c7816ULL, 0x000fe40000000086ULL, 0x00001054834d7816ULL, 0x000fe40000000084ULL,
0x000010546b247816ULL, 0x000fe20000000024ULL, 0x000000261c20723cULL, 0x000fe20000041820ULL,
0x000010546a257816ULL, 0x000fe40000000025ULL, 0x00001054496e7816ULL, 0x000fc4000000006eULL,
0x00001054486f7816ULL, 0x000fc60000000069ULL, 0x0000004c1c40723cULL, 0x040ff00000041840ULL,
0x000000241c2c723cULL, 0x040ff0000004182cULL, 0x0000006e1c28723cULL, 0x000fe20000041828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x01065c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01065c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000801b1c7811ULL, 0x000fe200078e40ffULL, 0x0000000404697c24ULL, 0x020fe2000f8e0207ULL,
0x00000004ff277819ULL, 0x000fe20000011605ULL, 0x00000100ff497424ULL, 0x000fe200078e00ffULL,
0x0000001c191d7217ULL, 0x000fe40007800000ULL, 0x0000007f691e7812ULL, 0x040fe400078ef812ULL,
0x0000007f69247812ULL, 0x000fe200078ef814ULL, 0x000000011d1d7824ULL, 0x000fe200078e0a1cULL,
0x0000007f691c7812ULL, 0x000fc400078ef80fULL, 0x0000007f69267812ULL, 0x000fe400078ef816ULL,
0x000000201d1f7807ULL, 0x000fe20000000000ULL, 0x00005e001c1c7625ULL, 0x000fc600078e0049ULL,
0x0000001f06257217ULL, 0x000fe20007800000ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0049ULL,
0x000000101c1c7210ULL, 0x000fc60007f5e0ffULL, 0x0000000125487824ULL, 0x000fe200078e0a06ULL,
0x000000101e1e7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0024247625ULL, 0x000fc600078e0049ULL,
0x000000481100720cULL, 0x000fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x0000001024247210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200020e061fULL,
0x000000482700720cULL, 0x080fe20003f46070ULL, 0x00005e0026267625ULL, 0x000fe200078e0049ULL,
0x000000481300720cULL, 0x000fc60003f86070ULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x000000481500720cULL, 0x000fe40003fa6070ULL, 0x0000001026267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c477faeULL, 0x0003e8000d101c46ULL, 0x000000001e467faeULL, 0x0003e8000d901c46ULL,
0x0000000024457faeULL, 0x0003e8000e101c46ULL, 0x0000000026447faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff1c7984ULL, 0x002e620000000800ULL,
0x80000000661d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x002fe2000784481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x01065400ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000784481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x80000000661e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01065400ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000784481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x00000000541c783bULL, 0x000e620000004200ULL,
0x00000017ffa1723eULL, 0x000fe400000010ffULL, 0x00000002ffa47819ULL, 0x000fe20000011605ULL,
0x000000005324783bULL, 0x000ea20000004200ULL, 0x00005410a1a17816ULL, 0x000fc600000000a1ULL,
0x000000005148783bULL, 0x000ee80000004200ULL, 0x00000000504c783bULL, 0x000f220000004200ULL,
0x000000ff1c6a7812ULL, 0x002fe400078ec0ffULL, 0x000000ff1d737812ULL, 0x000fe400078ec0ffULL,
0x000000ff278c7812ULL, 0x004fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fc4000001161dULL,
0x00000018ff887819ULL, 0x000fe40000011626ULL, 0x00000010ff8d7819ULL, 0x100fe4000001161cULL,
0x00000018ff987819ULL, 0x000fe4000001161cULL, 0x0000ffff1c917812ULL, 0x000fe400078ec0ffULL,
0x000000ff1e9e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fc40000011627ULL,
0x00000010ff897819ULL, 0x100fe4000001161fULL, 0x000000ff1f9c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff907819ULL, 0x000fe4000001161fULL, 0x0000ffff1f837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8a7819ULL, 0x000fe40000011625ULL, 0x000000ff259b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fe40000011625ULL, 0x0000ffff251c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff747819ULL, 0x100fe40000011624ULL, 0x000000ff249a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff957819ULL, 0x000fe40000011624ULL, 0x0000ffff241f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff26877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x108fe40000011648ULL,
0x000000ff48797812ULL, 0x040fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe40000011648ULL,
0x0000ffff48257812ULL, 0x000fe400078ec0ffULL, 0x0000006aff9d723eULL, 0x000fc400020006ffULL,
0x00000010ff7b7819ULL, 0x110fe4000001164eULL, 0x000000ff4e6c7812ULL, 0x040fe200078ec0ffULL,
0x2000009dff9d7230ULL, 0x000fe20000004100ULL, 0x00000018ff967819ULL, 0x000fe4000001164eULL,
0x0000ffff4e6f7812ULL, 0x000fe400078ec0ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x00000010ff7e7819ULL, 0x100fe4000001164aULL,
0x000000ff4a857812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001164aULL,
0x0000ffff4a247812ULL, 0x000fe400078ec0ffULL, 0x00000010ff707819ULL, 0x000fe4000001164fULL,
0x000000ff4f4e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe4000001164fULL,
0x0000ffff4f6a7812ULL, 0x000fe400078ec0ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x0000009eff4a723eULL, 0x000fe200020006ffULL,
0x20000073ff9e7230ULL, 0x000fe20000004100ULL, 0x0000008bff4f723eULL, 0x000fe200020006ffULL,
0x2000008cff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff497d7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff737230ULL, 0x000fe20000004100ULL, 0x00000018ff8f7819ULL, 0x000fe2000001161eULL,
0x20000088ff8c7230ULL, 0x000fe20000004100ULL, 0x00000018ff7f7819ULL, 0x000fe20000011649ULL,
0x2000004aff977230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000004fff887230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fc400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x000000ff4b717812ULL, 0x000fe400078ec0ffULL,
0x0000008fff4a723eULL, 0x000fe200020006ffULL, 0x20000087ff8f7230ULL, 0x000fe20000004100ULL,
0x0000007fff4f723eULL, 0x000fe200020006ffULL, 0x20000079ff877230ULL, 0x000fe20000004100ULL,
0x00000018ff6e7819ULL, 0x000fe2000001164bULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff4c727812ULL, 0x000fc400078ec0ffULL, 0x00000010ff827819ULL, 0x000fe40000011649ULL,
0x0000ffff49787812ULL, 0x000fe400078ec0ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000085ff79723eULL, 0x000fe200020006ffULL, 0x2000007dff857230ULL, 0x000fe20000004100ULL,
0x00000018ff497819ULL, 0x000fe2000001164cULL, 0x2000004fff7d7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000077ff7f7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000072ff4f723eULL, 0x000fe200020006ffULL, 0x20000071ff777230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x2000006eff717230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fe2000001161eULL, 0x2000004fff6e7230ULL, 0x000fe20000004100ULL,
0x0000ffff1d8e7812ULL, 0x000fc400078ec0ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x000000ff4d997812ULL, 0x000fe400078ec0ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x000fe4000001161dULL,
0x0000ffff1e867812ULL, 0x000fc400078ec0ffULL, 0x0000006cff4f723eULL, 0x000fe200020006ffULL,
0x20000049ff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff917819ULL, 0x000fe40000011691ULL,
0x00000008ff8e7819ULL, 0x000fe2000001168eULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x000fe40000011626ULL,
0x00000010ff1e7819ULL, 0x000fc40000011627ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000008ff1f7819ULL, 0x000fe4000001161fULL, 0x00000099ff99723eULL, 0x000fe200020006ffULL,
0x2000006dff727230ULL, 0x000fe20000004100ULL, 0x00000096ff49723eULL, 0x000fe200020006ffULL,
0x20000083ff967230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000099ff6d7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x20000093ff997230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000008ff837819ULL, 0x000fe4000001161cULL, 0x0000001fff1f723eULL, 0x000fe200020006ffULL,
0x2000008aff937230ULL, 0x000fe20000004100ULL, 0x0000a800551c7811ULL, 0x000fe400078e20ffULL,
0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff27847812ULL, 0x000fc400078ec0ffULL, 0x00000010ff927819ULL, 0x100fe4000001164dULL,
0x00000018ff6b7819ULL, 0x000fe4000001164dULL, 0x0000ffff4d7a7812ULL, 0x000fe400078ec0ffULL,
0x00000098ff27723eULL, 0x000fe400020006ffULL, 0x0000009cff98723eULL, 0x000fe200020006ffULL,
0x2000008eff9c7230ULL, 0x000fe20000004100ULL, 0x0000009bff4d723eULL, 0x000fe200020006ffULL,
0x20000091ff9b7230ULL, 0x000fe20000004100ULL, 0x0000001dff8e723eULL, 0x000fe200020006ffULL,
0x2000001fff917230ULL, 0x000fe20000004100ULL, 0x0000001eff8a723eULL, 0x000fe200020006ffULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x000000001c1c783bULL, 0x000fe20000000200ULL,
0x0000ffff26817812ULL, 0x000fe200078ec0ffULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x000000ff89897812ULL, 0x000fe200078ec0ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff817819ULL, 0x000fc40000011681ULL, 0x0000009aff9a723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000010ff767819ULL, 0x000fe4000001164bULL,
0x0000ffff4b267812ULL, 0x000fe400078ec0ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x00000090ff4b723eULL, 0x000fe200020006ffULL,
0x2000008dff9f7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x000000ff82827812ULL, 0x000fe200078ec0ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000095ff90723eULL, 0x000fe200020006ffULL, 0x2000009aff957230ULL, 0x000fe20000004100ULL,
0x000000ff94947812ULL, 0x000fe200078ec0ffULL, 0x20000089ff9a7230ULL, 0x000fe20000004100ULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000084ff897230ULL, 0x000fe20000004100ULL,
0x00000082ff84723eULL, 0x000fe200020006ffULL, 0x20000081ff8d7230ULL, 0x000fe20000004100ULL,
0x00001f18a1827589ULL, 0x000e6200000e0000ULL, 0x000000ff80807812ULL, 0x000fe200078ec0ffULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x00001fa4a1817589ULL, 0x0004e200000e0000ULL, 0x00000008ff257819ULL, 0x000fe20000011625ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000094ffa07230ULL, 0x000fe20000004100ULL, 0x000000ff74747812ULL, 0x000fc400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x00000074ff94723eULL, 0x000fe200020006ffULL, 0x20000086ff747230ULL, 0x000fe20000004100ULL,
0x00000008ffa17819ULL, 0x004fe20000011624ULL, 0x20000080ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe2000001169dULL, 0x20000025ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe2000001169eULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000010ff9f7819ULL, 0x000fe2000001169fULL, 0x000000821d1d9231ULL, 0x082fe200003400ffULL,
0x00000010ffa07819ULL, 0x000fe200000116a0ULL, 0x000000821f1f9231ULL, 0x000fe200003400ffULL,
0x00000008ff9e7819ULL, 0x000fe20000011626ULL, 0x000000811c1c9231ULL, 0x088fe200003400ffULL,
0x000010549f247816ULL, 0x000fe20000000024ULL, 0x000000811e1e9231ULL, 0x000fe200003400ffULL,
0x00001054a0257816ULL, 0x000fc40000000025ULL, 0x00000010ff277819ULL, 0x000fe40000011627ULL,
0x00000010ff267819ULL, 0x000fe4000001169bULL, 0x00000010ff9f7819ULL, 0x000fe20000011673ULL,
0x000000241c40723cULL, 0x000fe20000041840ULL, 0x00000010ff9c7819ULL, 0x000fe4000001169cULL,
0x0000105427267816ULL, 0x000fe40000000026ULL, 0x000010549f277816ULL, 0x000fc4000000009cULL,
0x00000010ff247819ULL, 0x000fe40000011697ULL, 0x00000010ff257819ULL, 0x000fe40000011698ULL,
0x00000010ff997819ULL, 0x000fe20000011699ULL, 0x000000261c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff9a7819ULL, 0x000fe4000001169aULL, 0x0000105499247816ULL, 0x000fe40000000024ULL,
0x000010549a257816ULL, 0x000fc40000000025ULL, 0x00000010ff267819ULL, 0x000fe4000001164bULL,
0x00000010ff277819ULL, 0x000fe4000001164aULL, 0x00000010ff4b7819ULL, 0x000fe20000011696ULL,
0x000000241c38723cULL, 0x000fe20000041838ULL, 0x00000010ff4a7819ULL, 0x000fe40000011674ULL,
0x0000a80052967811ULL, 0x000fe400078e20ffULL, 0x00001054274a7816ULL, 0x000fc4000000004aULL,
0x00001054264b7816ULL, 0x000fe4000000004bULL, 0x00000010ff757819ULL, 0x000fe2000001164cULL,
0x000000009624783bULL, 0x000e620000000200ULL, 0x0000ffff4c4c7812ULL, 0x000fe400078ec0ffULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x0000004a1c34723cULL, 0x000fe20000041834ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x000000ff92987812ULL, 0x000fe200078ec0ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff977819ULL, 0x000fe2000001164cULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fc4000001164dULL,
0x00000010ff4c7819ULL, 0x000fe40000011695ULL, 0x00000010ff4d7819ULL, 0x000fe40000011694ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x000010544d4c7816ULL, 0x000fe4000000004cULL,
0x00001054934d7816ULL, 0x000fe40000000092ULL, 0x00000010ff4b7819ULL, 0x000fc40000011690ULL,
0x00000010ff4a7819ULL, 0x000fe40000011691ULL, 0x00000010ff937819ULL, 0x000fe2000001167cULL,
0x0000004c1c30723cULL, 0x000fe20000041830ULL, 0x00000010ff907819ULL, 0x000fe40000011683ULL,
0x000010544b4a7816ULL, 0x000fe4000000004aULL, 0x00001054934b7816ULL, 0x000fe40000000090ULL,
0x00000008ff787819ULL, 0x000fc40000011678ULL, 0x00000010ff4c7819ULL, 0x000fe4000001168fULL,
0x00000010ff4d7819ULL, 0x000fe2000001168eULL, 0x0000004a1c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff8b7819ULL, 0x000fe2000001168bULL, 0x0000008124249231ULL, 0x082fe200003400ffULL,
0x00000010ff8a7819ULL, 0x000fe2000001168aULL, 0x0000008126269231ULL, 0x000fe200003400ffULL,
0x00000010ff8c7819ULL, 0x000fe2000001168cULL, 0x0000008225259231ULL, 0x080fe200003400ffULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x0000008227279231ULL, 0x000fe200003400ffULL,
0x00000010ff887819ULL, 0x000fc40000011688ULL, 0x00000010ff4b7819ULL, 0x000fe40000011689ULL,
0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x000010544d4c7816ULL, 0x000fe4000000004cULL, 0x000010548a4d7816ULL, 0x000fe4000000008bULL,
0x000010548c4a7816ULL, 0x000fc4000000008dULL, 0x00001054884b7816ULL, 0x000fe4000000004bULL,
0x0000007effa2723eULL, 0x000fe200020006ffULL, 0x20000078ff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff76767812ULL, 0x000fe200078ec0ffULL, 0x0000004c1c20723cULL, 0x000fe20000041820ULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x200000a2ff787230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x000000a1ff9d723eULL, 0x000fc400020006ffULL,
0x0000009eff9b723eULL, 0x000fe200020006ffULL, 0x0000004a1c28723cULL, 0x000fe20000041828ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x000000ff759c7812ULL, 0x000fe200078ec0ffULL,
0x2000009dff737230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe2000001167aULL,
0x2000009bff757230ULL, 0x000fe20000004100ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff1e7819ULL, 0x000fe4000001167dULL, 0x00000010ff1c7819ULL, 0x000fc40000011680ULL,
0x00000010ff1d7819ULL, 0x000fe4000001167eULL, 0x000010547f1c7816ULL, 0x000fe4000000001cULL,
0x000010541e1d7816ULL, 0x000fe4000000001dULL, 0x00000010ff1e7819ULL, 0x000fe40000011679ULL,
0x00000010ff1f7819ULL, 0x000fe40000011678ULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x0000001c243c723cULL, 0x000fe2000004183cULL, 0x00000010ff4a7819ULL, 0x000fc40000011671ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x0000009cff9c723eULL, 0x000fe400020006ffULL,
0x00000010ff1d7819ULL, 0x000fe40000011672ULL, 0x00000010ff1c7819ULL, 0x000fe20000011673ULL,
0x2000009cff747230ULL, 0x000fe20000004100ULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x00000097ff97723eULL, 0x000fc400020006ffULL, 0x000010541f1e7816ULL, 0x000fe2000000001eULL,
0x20000098ff837230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000097ff7c7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00001054761f7816ULL, 0x000fe20000000077ULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x000010541d1c7816ULL, 0x000fe2000000001cULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x000010544a1d7816ULL, 0x000fc40000000075ULL, 0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL,
0x0000001e2438723cULL, 0x040fe20000041838ULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x00000008ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff1e7819ULL, 0x000fe2000001166eULL, 0x0000001c2434723cULL, 0x000fe20000041834ULL,
0x00000010ff1f7819ULL, 0x000fc40000011674ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff4a7819ULL, 0x000fe40000011683ULL, 0x00000010ff1d7819ULL, 0x000fe4000001166cULL,
0x00000010ff1c7819ULL, 0x000fe4000001167cULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff7a7819ULL, 0x000fc4000001167aULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x000010541f1e7816ULL, 0x000fe2000000001eULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x000010544a1f7816ULL, 0x000fc4000000006dULL,
0x000010541d1c7816ULL, 0x000fe2000000001cULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x000010546b1d7816ULL, 0x000fe4000000007aULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x0000001e2430723cULL, 0x000fe20000041830ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff847819ULL, 0x000fc40000011684ULL,
0x00000010ff1e7819ULL, 0x000fe2000001164fULL, 0x0000001c242c723cULL, 0x000fe2000004182cULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff1f7819ULL, 0x000fe4000001164eULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff1c7819ULL, 0x000fe40000011649ULL,
0x00000010ff6f7819ULL, 0x000fc4000001166fULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff1d7819ULL, 0x000fe4000001166aULL, 0x00001054864c7816ULL, 0x000fe40000000087ULL,
0x00001054844d7816ULL, 0x000fe40000000085ULL, 0x000010547b1e7816ULL, 0x000fe4000000001eULL,
0x00001054701f7816ULL, 0x000fc4000000001fULL, 0x000010541c1c7816ULL, 0x000fe2000000006fULL,
0x0000004c2440723cULL, 0x000fe20000041840ULL, 0x00001054481d7816ULL, 0x000fce000000001dULL,
0x0000001e2420723cULL, 0x040ff00000041820ULL, 0x0000001c2424723cULL, 0x000fe20000041828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000801b1c7811ULL, 0x000fe200078e40ffULL, 0x01062000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff0dff7812ULL, 0x000fc4000784c0ffULL, 0x0000001c1900720cULL, 0x000fe40003f24070ULL,
0x00000001ff6a7807ULL, 0x000fd60005000000ULL, 0x00007a2000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01065c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000a01b1c7811ULL, 0x000fe200078e40ffULL, 0x00000100ff497424ULL, 0x000fe200078e00ffULL,
0x0000002069287810ULL, 0x000fe40007ffe0ffULL, 0x0000001c191d7217ULL, 0x000fe40007800000ULL,
0x00000004ff2b7819ULL, 0x000fe20000011605ULL, 0x000000015c1e7824ULL, 0x000fe400078e0228ULL,
0x000000011d1d7824ULL, 0x000fe400078e0a1cULL, 0x000000015d1c7824ULL, 0x000fc400078e0228ULL,
0x000000015a2a7824ULL, 0x000fe200078e0228ULL, 0x000000201d1f7807ULL, 0x000fe20000000000ULL,
0x00005e001c1c7625ULL, 0x000fc600078e0049ULL, 0x0000001f06297217ULL, 0x000fe20007800000ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0049ULL, 0x000000101c1c7210ULL, 0x000fc60007f3e0ffULL,
0x0000000129487824ULL, 0x000fe200078e0a06ULL, 0x000000101e1e7210ULL, 0x000fe20007f7e0ffULL,
0x000000015b297824ULL, 0x000fe400078e0228ULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x000000482b00720cULL, 0x080fe20003f46070ULL, 0x00005e0029287625ULL, 0x080fe200078e0049ULL,
0x000000481100720cULL, 0x080fe40003f26070ULL, 0x000000481500720cULL, 0x000fe20003f86070ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0049ULL, 0x0000001028287210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200018e061fULL, 0x000000481300720cULL, 0x000fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x000000102a2a7210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e8000d101c46ULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0x000000001e647faeULL, 0x0003ea000c901c46ULL,
0x0000000028637faeULL, 0x0003e8000d901c46ULL, 0x000000002a627faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff1d7984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01062c00ff1e7984ULL, 0x000ea20000000800ULL,
0x000000ff0dff7812ULL, 0x000fe2000782c0ffULL, 0x800000005e1f7824ULL, 0x000fc600078e00ffULL,
0x00000001ff6a7807ULL, 0x000fca0004800000ULL, 0x800000006a1c7824ULL, 0x000fca00078e00ffULL,
0x800000001dff7812ULL, 0x002fe4000782481cULL, 0x800000001eff7812ULL, 0x004fe2000784481fULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x800000005e1e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01062c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000784481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x01010000611d7984ULL, 0x000e620000000800ULL,
0x00000001ff6b7424ULL, 0x000fc600078e00ffULL, 0x01030000611c7984ULL, 0x0004e20000000800ULL,
0x000000081d00720bULL, 0x002fda0003f5d000ULL, 0x00000000001e7806ULL, 0x000fc800010e0100ULL,
0x0000ffff1e287812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x000000081d00720bULL, 0x00cfe40003f54000ULL, 0x0000001d081e7209ULL, 0x000fe40007810000ULL,
0x00000002ff2a7819ULL, 0x000fc60000011605ULL, 0x8000001e081f7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1f1f7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x000000021a00780cULL, 0x000fe40003f45270ULL, 0x0000ffff08297812ULL, 0x000fe200078e3cffULL,
0x0000001f001f7308ULL, 0x000e660000000800ULL, 0x0000002928ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff6b7807ULL, 0x000fc60001800000ULL, 0x0105001e6100a388ULL, 0x000fe80000000800ULL,
0x00001f2a1f087589ULL, 0x002e6400000e0000ULL, 0x8000001e1d283221ULL, 0x000fe20000010000ULL,
0x0000001f09097220ULL, 0x000fe20000410000ULL, 0x00001f181f1d7589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b28283820ULL, 0x000fc80000410000ULL, 0x0000002800173308ULL, 0x000ee20000000800ULL,
0x0000000840407220ULL, 0x082fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x000000083c3c7220ULL, 0x080fe20000410000ULL, 0x000000083d3d7220ULL, 0x080fe20000410000ULL,
0x0000000838387220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000824247220ULL, 0x080fe20000410000ULL, 0x0000000825257220ULL, 0x000fe20000410000ULL,
0x0000001d42427220ULL, 0x084fe20000410000ULL, 0x0000001d43437220ULL, 0x080fe20000410000ULL,
0x0000001d3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001d3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001d36367220ULL, 0x080fe20000410000ULL, 0x0000001d37377220ULL, 0x080fe20000410000ULL,
0x0000001d32327220ULL, 0x080fe20000410000ULL, 0x0000001d33337220ULL, 0x080fe20000410000ULL,
0x0000001d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001d22227220ULL, 0x080fe20000410000ULL, 0x0000001d23237220ULL, 0x080fe20000410000ULL,
0x0000001d26267220ULL, 0x080fe20000410000ULL, 0x0000001d27277220ULL, 0x000fe20000410000ULL,
0x000000ffff087224ULL, 0x000fe200078e001eULL, 0x0000001c171c3220ULL, 0x008fc80000410000ULL,
0x000000091c097221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff1c7984ULL, 0x000e620000000800ULL, 0x800000006a1d7824ULL, 0x000fca00078e00ffULL,
0x800000001cff7812ULL, 0x002fe2000782481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x800000006a1e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01064c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000782481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000005f1c783bULL, 0x000e620000004200ULL, 0x00000017ffa3723eULL, 0x000fe400000010ffULL,
0x00000002ffa27819ULL, 0x000fe20000011605ULL, 0x000000005928783bULL, 0x000ea20000004200ULL,
0x00005410a3a37816ULL, 0x000fc600000000a3ULL, 0x000000005848783bULL, 0x000ee80000004200ULL,
0x00000000574c783bULL, 0x000f220000004200ULL, 0x00000010ff957819ULL, 0x002fe4000001161dULL,
0x0000ffff1c927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff847819ULL, 0x004fe40000011628ULL,
0x000000ff95957812ULL, 0x000fc400078ec0ffULL, 0x000000ff84847812ULL, 0x000fe400078ec0ffULL,
0x0000ffff1d8f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe4000001161fULL,
0x000000ff1f9c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fe4000001161fULL,
0x0000ffff1f757812ULL, 0x000fc400078ec0ffULL, 0x000000ff1d747812ULL, 0x000fe400078ec0ffULL,
0x0000ffff281f7812ULL, 0x000fe400078ec0ffULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x00000018ff987819ULL, 0x000fe4000001161dULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000095ffa17230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fc4000001161cULL,
0x000000ff1c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000084ff957230ULL, 0x000fe20000004100ULL,
0x00000018ff997819ULL, 0x000fe4000001161cULL, 0x000000ff1e9d7812ULL, 0x040fe400078ec0ffULL,
0x00000010ff937819ULL, 0x100fe4000001161eULL, 0x00000018ff947819ULL, 0x000fe4000001161eULL,
0x0000ffff1e877812ULL, 0x000fc400078ec0ffULL, 0x0000ffff291c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff927819ULL, 0x000fe40000011692ULL, 0x00000008ff8f7819ULL, 0x000fe4000001168fULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x000fe4000001162aULL,
0x00000010ff1e7819ULL, 0x000fc4000001162bULL, 0x000000ff2b8d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8c7819ULL, 0x000fe4000001162bULL, 0x0000ffff2b857812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x000099106b2b7816ULL, 0x000fe200000000ffULL, 0x20000074ff9f7230ULL, 0x000fe20000004100ULL,
0x00000098ff98723eULL, 0x000fc400020006ffULL, 0x000000ff2a887812ULL, 0x040fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe2000001162aULL, 0x20000098ff747230ULL, 0x000fe20000004100ULL,
0x0000ffff2a827812ULL, 0x000fe400078ec0ffULL, 0x0000009dff9d723eULL, 0x000fe400020006ffULL,
0x000000ff28967812ULL, 0x000fe400078ec0ffULL, 0x00000018ff917819ULL, 0x000fe20000011628ULL,
0x2000009dff987230ULL, 0x000fe20000004100ULL, 0x000000ff299b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff777819ULL, 0x108fe4000001164bULL, 0x000000ff4b727812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b2a7812ULL, 0x000fe400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fc400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000008ff847819ULL, 0x000fe2000001161cULL,
0x2000008fff9d7230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x100fe40000011629ULL,
0x00000018ff7d7819ULL, 0x000fe40000011629ULL, 0x00000010ff7f7819ULL, 0x000fe4000001164aULL,
0x000000ff4a867812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001164aULL,
0x0000ffff4a287812ULL, 0x000fe400078ec0ffULL, 0x0000006cff9e723eULL, 0x000fe400020006ffULL,
0x00000010ff4b7819ULL, 0x110fe4000001164dULL, 0x000000ff4d9a7812ULL, 0x000fe200078ec0ffULL,
0x2000009eff9e7230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x000fc4000001164dULL,
0x0000ffff4d7b7812ULL, 0x000fe400078ec0ffULL, 0x0000001fff1f723eULL, 0x000fe400020006ffULL,
0x0000b000601c7811ULL, 0x000fe400078e20ffULL, 0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff817819ULL, 0x000fc40000011648ULL,
0x000000ff487a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe40000011648ULL,
0x0000ffff48297812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x100fe4000001164cULL,
0x000000ff4c737812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fc4000001164cULL,
0x0000ffff4c4a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7c7819ULL, 0x100fe4000001164eULL,
0x000000ff4e977812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001164eULL,
0x0000ffff4e707812ULL, 0x000fe400078ec0ffULL, 0x000000ff2b00720cULL, 0x000fc40003f25270ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x100fe4000001164fULL,
0x000000ff4f4e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001164fULL,
0x0000ffff4f6b7812ULL, 0x000fe400078ec0ffULL, 0x00000099ff2b723eULL, 0x000fc400020006ffULL,
0x00000094ff48723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x0000009cff99723eULL, 0x000fe200020006ffULL,
0x20000092ff9c7230ULL, 0x000fe20000004100ULL, 0x0000009bff94723eULL, 0x000fe200020006ffULL,
0x2000008bff9b7230ULL, 0x000fe20000004100ULL, 0x0000008cff4f723eULL, 0x000fe200020006ffULL,
0x2000001fff927230ULL, 0x000fe20000004100ULL, 0x000000ff497e7812ULL, 0x040fe200078ec0ffULL,
0x2000008dff8c7230ULL, 0x000fe20000004100ULL, 0x00000018ff807819ULL, 0x100fe20000011649ULL,
0x20000089ff8d7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000004fff897230ULL, 0x000fe20000004100ULL, 0x0000001dff8f723eULL, 0x000fe200020006ffULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x0000001eff8b723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x00000010ff837819ULL, 0x000fe20000011649ULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x0000ffff49797812ULL, 0x000fe200078ec0ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000090ff49723eULL, 0x000fe200020006ffULL,
0x20000088ff907230ULL, 0x000fe20000004100ULL, 0x00000080ff4f723eULL, 0x000fe200020006ffULL,
0x2000007aff887230ULL, 0x000fe20000004100ULL, 0x000000ff93937812ULL, 0x000fe200078ec0ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff857819ULL, 0x000fe40000011685ULL, 0x00000086ff7a723eULL, 0x000fe200020006ffULL,
0x2000007eff867230ULL, 0x000fe20000004100ULL, 0x0000009aff9a723eULL, 0x000fe200020006ffULL,
0x2000004fff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fc400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000073ff4f723eULL, 0x000fe200020006ffULL,
0x2000006eff737230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000009aff6e7230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000093ff9a7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000008aff937230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x2000008effa07230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000085ff8a7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x20000082ff8e7230ULL, 0x000fe20000004100ULL, 0x00000083ff85723eULL, 0x000fe200020006ffULL,
0x00001f18a3827589ULL, 0x000e6200000e0000ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000078ff807230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x00001fa2a3837589ULL, 0x0004e200000e0000ULL, 0x20000072ff787230ULL, 0x000fe20000004100ULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x2000006fff727230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fe200020006ffULL, 0x2000004fff6f7230ULL, 0x000fe20000004100ULL,
0x0000006dff4f723eULL, 0x000fe200020006ffULL, 0x2000006cff6d7230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fe20000011629ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x2000004fff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff757819ULL, 0x000fe20000011675ULL, 0x20000097ff4f7230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fc400020006ffULL, 0x00000075ff97723eULL, 0x000fe200020006ffULL,
0x20000087ff757230ULL, 0x000fe20000004100ULL, 0x000000ff81877812ULL, 0x000fe200078ec0ffULL,
0x20000029ff817230ULL, 0x000fe20000004100ULL, 0x00000008ffa27819ULL, 0x004fe20000011628ULL,
0x000000821d1d9231ULL, 0x082fe200003400ffULL, 0x00000010ff287819ULL, 0x000fe2000001169eULL,
0x000000821f1f9231ULL, 0x000fe200003400ffULL, 0x00000010ff297819ULL, 0x000fe200000116a0ULL,
0x000000831c1c9231ULL, 0x088fe200003400ffULL, 0x00000010ff9f7819ULL, 0x000fe2000001169fULL,
0x000000831e1e9231ULL, 0x000fe200003400ffULL, 0x00000010ffa07819ULL, 0x000fe200000116a1ULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x0000105429287816ULL, 0x000fc40000000028ULL,
0x00001054a0297816ULL, 0x000fe4000000009fULL, 0x00000008ff9f7819ULL, 0x000fe4000001162aULL,
0x00000010ff2b7819ULL, 0x000fe4000001162bULL, 0x00000010ff2a7819ULL, 0x000fe2000001169cULL,
0x000000281c40723cULL, 0x000fe20000041840ULL, 0x00000010ffa07819ULL, 0x000fe40000011674ULL,
0x00000010ff9d7819ULL, 0x000fc4000001169dULL, 0x000010542b2a7816ULL, 0x000fe4000000002aULL,
0x00001054a02b7816ULL, 0x000fe4000000009dULL, 0x00000010ff287819ULL, 0x000fe40000011698ULL,
0x00000010ff297819ULL, 0x000fe4000001169aULL, 0x00000010ff997819ULL, 0x000fe20000011699ULL,
0x0000002a1c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff987819ULL, 0x000fc4000001169bULL,
0x0000105429287816ULL, 0x000fe40000000028ULL, 0x0000105498297816ULL, 0x000fe40000000099ULL,
0x00000010ff2a7819ULL, 0x000fe40000011649ULL, 0x00000010ff2b7819ULL, 0x000fe40000011648ULL,
0x00000010ff497819ULL, 0x000fe20000011697ULL, 0x000000281c38723cULL, 0x000fe20000041838ULL,
0x00000010ff487819ULL, 0x000fc40000011675ULL, 0x0000b00056977811ULL, 0x000fe400078e20ffULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x000010542b487816ULL, 0x000fe40000000048ULL,
0x000010542a497816ULL, 0x000fe20000000049ULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x000000009728783bULL, 0x000e620000000200ULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fc400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x000000ff4b997812ULL, 0x000fe200078ec0ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000008ff987819ULL, 0x000fe2000001164aULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fe20000011694ULL,
0x000000481c34723cULL, 0x000fe20000041834ULL, 0x00000010ff4a7819ULL, 0x000fe40000011696ULL,
0x00000010ff957819ULL, 0x000fc40000011695ULL, 0x00000010ff947819ULL, 0x000fe40000011693ULL,
0x00001054954a7816ULL, 0x000fe4000000004aULL, 0x00001054944b7816ULL, 0x000fe4000000004bULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff947819ULL, 0x000fe4000001167dULL,
0x00000010ff487819ULL, 0x000fe20000011692ULL, 0x0000004a1c30723cULL, 0x000fe20000041830ULL,
0x00000010ff497819ULL, 0x000fc40000011684ULL, 0x0000105491487816ULL, 0x000fe40000000048ULL,
0x0000105494497816ULL, 0x000fe40000000049ULL, 0x00000010ff4b7819ULL, 0x000fe4000001168cULL,
0x00000010ff8c7819ULL, 0x000fe4000001168bULL, 0x00000008ff797819ULL, 0x000fe20000011679ULL,
0x000000481c2c723cULL, 0x000fe2000004182cULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x0000008328289231ULL, 0x082fe200003400ffULL, 0x000000ff77777812ULL, 0x000fe200078ec0ffULL,
0x000000832a2a9231ULL, 0x000fe200003400ffULL, 0x00000010ff4a7819ULL, 0x000fe20000011690ULL,
0x0000008229299231ULL, 0x080fe200003400ffULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x000000822b2b9231ULL, 0x000fe200003400ffULL, 0x000010548c4b7816ULL, 0x000fc4000000004bULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8c7819ULL, 0x000fe40000011689ULL, 0x00000010ff497819ULL, 0x000fe4000001168aULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x0000007fffa4723eULL, 0x000fc400020006ffULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000079ff7f7230ULL, 0x000fe20000004100ULL,
0x000010548f4a7816ULL, 0x000fe2000000004aULL, 0x200000a4ff797230ULL, 0x000fe20000004100ULL,
0x000010548d487816ULL, 0x000fe2000000008eULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x000010548c497816ULL, 0x000fe40000000049ULL, 0x000000ff769d7812ULL, 0x000fe200078ec0ffULL,
0x0000004a1c20723cULL, 0x000fe20000041820ULL, 0x00000010ff797819ULL, 0x000fc40000011679ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x0000009dff9d723eULL, 0x000fe200020006ffULL, 0x000000481c1c723cULL, 0x000fe20000041824ULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x000000a2ff9e723eULL, 0x000fe200020006ffULL,
0x2000009dff757230ULL, 0x000fe20000004100ULL, 0x0000009fff9c723eULL, 0x000fe200020006ffULL,
0x20000099ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe20000011680ULL,
0x2000009eff747230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe20000011681ULL,
0x2000009cff767230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fc4000001167aULL,
0x00000010ff277819ULL, 0x000fe40000011678ULL, 0x00000010ff487819ULL, 0x000fe40000011677ULL,
0x0000105425247816ULL, 0x000fe40000000024ULL, 0x0000105479267816ULL, 0x000fe40000000026ULL,
0x0000105448277816ULL, 0x000fe40000000027ULL, 0x000010547e257816ULL, 0x000fc4000000007fULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7b7819ULL, 0x000fe2000001167bULL,
0x000000262838723cULL, 0x040fe20000041838ULL, 0x000000ff71717812ULL, 0x000fe400078ec0ffULL,
0x00000008ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff267819ULL, 0x000fe2000001166fULL, 0x00000024283c723cULL, 0x000fe2000004183cULL,
0x00000010ff277819ULL, 0x000fc4000001166eULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000008ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff247819ULL, 0x000fe40000011674ULL,
0x00000010ff257819ULL, 0x000fc40000011676ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000098ff98723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000098ff7d7230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x0000105475267816ULL, 0x000fe20000000026ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000105484277816ULL, 0x000fe20000000027ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x0000105473247816ULL, 0x000fe40000000024ULL, 0x0000105472257816ULL, 0x000fe20000000025ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000000262830723cULL, 0x040fe20000041830ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff267819ULL, 0x000fe2000001164fULL,
0x000000242834723cULL, 0x000fe20000041834ULL, 0x00000010ff277819ULL, 0x000fc4000001167cULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff247819ULL, 0x000fe4000001167dULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff257819ULL, 0x000fe4000001167bULL, 0x00000010ff4e7819ULL, 0x000fc4000001164eULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x0000105427267816ULL, 0x000fc40000000026ULL,
0x00001054874a7816ULL, 0x000fe40000000088ULL, 0x00001054854b7816ULL, 0x000fe40000000086ULL,
0x000010546d247816ULL, 0x000fe40000000024ULL, 0x000010546c257816ULL, 0x000fe40000000025ULL,
0x0000105471277816ULL, 0x000fe2000000004eULL, 0x0000004a2840723cULL, 0x000fe20000041840ULL,
0x000010544d707816ULL, 0x000fc40000000070ULL, 0x000010544c717816ULL, 0x000fca000000006bULL,
0x00000024282c723cULL, 0x040ff0000004182cULL, 0x000000262820723cULL, 0x040ff00000041820ULL,
0x000000702828723cULL, 0x000fe2000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000c01b1c7811ULL, 0x000fe200078e40ffULL,
0x00000100ff497424ULL, 0x000fe200078e00ffULL, 0x0000004069267810ULL, 0x000fe40007ffe0ffULL,
0x0000001c191d7217ULL, 0x000fe40007800000ULL, 0x00000004ff277819ULL, 0x000fe20000011605ULL,
0x000000015c1e7824ULL, 0x000fe400078e0226ULL, 0x000000011d1d7824ULL, 0x000fe400078e0a1cULL,
0x000000015d1c7824ULL, 0x000fc400078e0226ULL, 0x000000015b247824ULL, 0x000fe200078e0226ULL,
0x000000201d1f7807ULL, 0x000fe20000000000ULL, 0x00005e001c1c7625ULL, 0x000fc600078e0049ULL,
0x0000001f06257217ULL, 0x000fe20007800000ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0049ULL,
0x000000101c1c7210ULL, 0x000fc60007f5e0ffULL, 0x0000000125487824ULL, 0x000fe200078e0a06ULL,
0x000000101e1e7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0024247625ULL, 0x000fc600078e0049ULL,
0x000000481100720cULL, 0x000fe20003f66070ULL, 0x000000015a267824ULL, 0x000fe200078e0226ULL,
0x0000001024247210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x000000482700720cULL, 0x000fe20003f46070ULL, 0x00005e0026267625ULL, 0x000fc800078e0049ULL,
0x000000ffff1f7224ULL, 0x000fe200020e061fULL, 0x000000481300720cULL, 0x080fe20003f86070ULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x000000481500720cULL, 0x000fe40003fa6070ULL,
0x0000001026267210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c477faeULL, 0x0003e4000d101c46ULL, 0x000000ffff277224ULL, 0x000fe400030e0627ULL,
0x000000001e467faeULL, 0x0003e8000d901c46ULL, 0x0000000024457faeULL, 0x0003e8000e101c46ULL,
0x0000000026447faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff1c7984ULL, 0x002e620000000800ULL, 0x800000006a1d7824ULL, 0x000fca00078e00ffULL,
0x800000001cff7812ULL, 0x002fe2000784481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x01065400ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000784481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000006a6a7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01065400ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784486aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000000541c783bULL, 0x000e620000004200ULL, 0x00000017ffa1723eULL, 0x000fe400000010ffULL,
0x00000002ffa47819ULL, 0x000fe20000011605ULL, 0x000000005324783bULL, 0x000ea20000004200ULL,
0x00005410a1a17816ULL, 0x000fc600000000a1ULL, 0x000000005148783bULL, 0x000ee80000004200ULL,
0x00000000504c783bULL, 0x000f220000004200ULL, 0x000000ff1c6a7812ULL, 0x002fe400078ec0ffULL,
0x000000ff1d737812ULL, 0x000fe400078ec0ffULL, 0x000000ff278c7812ULL, 0x004fe400078ec0ffULL,
0x00000018ff977819ULL, 0x000fc4000001161dULL, 0x00000018ff887819ULL, 0x000fe40000011626ULL,
0x00000010ff8d7819ULL, 0x100fe4000001161cULL, 0x00000018ff987819ULL, 0x000fe4000001161cULL,
0x0000ffff1c917812ULL, 0x000fe400078ec0ffULL, 0x000000ff1e9e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8b7819ULL, 0x000fc40000011627ULL, 0x00000010ff897819ULL, 0x100fe4000001161fULL,
0x000000ff1f9c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fe4000001161fULL,
0x0000ffff1f837812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fe40000011625ULL,
0x000000ff259b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011625ULL,
0x0000ffff251c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x100fe40000011624ULL,
0x000000ff249a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff957819ULL, 0x000fe40000011624ULL,
0x0000ffff241f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff26877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x108fe40000011648ULL, 0x000000ff48797812ULL, 0x040fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fe40000011648ULL, 0x0000ffff48257812ULL, 0x000fe400078ec0ffULL,
0x0000006aff9d723eULL, 0x000fc400020006ffULL, 0x00000010ff7b7819ULL, 0x110fe4000001164eULL,
0x000000ff4e6c7812ULL, 0x040fe200078ec0ffULL, 0x2000009dff9d7230ULL, 0x000fe20000004100ULL,
0x00000018ff967819ULL, 0x000fe4000001164eULL, 0x0000ffff4e6f7812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x00000010ff7e7819ULL, 0x100fe4000001164aULL, 0x000000ff4a857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a247812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x000fe4000001164fULL, 0x000000ff4f4e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe4000001164fULL, 0x0000ffff4f6a7812ULL, 0x000fe400078ec0ffULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x0000009eff4a723eULL, 0x000fe200020006ffULL, 0x20000073ff9e7230ULL, 0x000fe20000004100ULL,
0x0000008bff4f723eULL, 0x000fe200020006ffULL, 0x2000008cff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff497d7812ULL, 0x000fe200078ec0ffULL, 0x20000097ff737230ULL, 0x000fe20000004100ULL,
0x00000018ff8f7819ULL, 0x000fe2000001161eULL, 0x20000088ff8c7230ULL, 0x000fe20000004100ULL,
0x00000018ff7f7819ULL, 0x000fe20000011649ULL, 0x2000004aff977230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x2000004fff887230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x000000ff4b717812ULL, 0x000fe400078ec0ffULL, 0x0000008fff4a723eULL, 0x000fe200020006ffULL,
0x20000087ff8f7230ULL, 0x000fe20000004100ULL, 0x0000007fff4f723eULL, 0x000fe200020006ffULL,
0x20000079ff877230ULL, 0x000fe20000004100ULL, 0x00000018ff6e7819ULL, 0x000fe2000001164bULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff4c727812ULL, 0x000fc400078ec0ffULL,
0x00000010ff827819ULL, 0x000fe40000011649ULL, 0x0000ffff49787812ULL, 0x000fe400078ec0ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000085ff79723eULL, 0x000fe200020006ffULL,
0x2000007dff857230ULL, 0x000fe20000004100ULL, 0x00000018ff497819ULL, 0x000fe2000001164cULL,
0x2000004fff7d7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000077ff7f7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000072ff4f723eULL, 0x000fe200020006ffULL,
0x20000071ff777230ULL, 0x000fe20000004100ULL, 0x00000008ff837819ULL, 0x000fe20000011683ULL,
0x2000006eff717230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fe2000001161eULL,
0x2000004fff6e7230ULL, 0x000fe20000004100ULL, 0x0000ffff1d8e7812ULL, 0x000fc400078ec0ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x000000ff4d997812ULL, 0x000fe400078ec0ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x000000ff93937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff947819ULL, 0x000fe4000001161dULL, 0x0000ffff1e867812ULL, 0x000fc400078ec0ffULL,
0x0000006cff4f723eULL, 0x000fe200020006ffULL, 0x20000049ff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff917819ULL, 0x000fe40000011691ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168eULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1d7819ULL, 0x000fe40000011626ULL, 0x00000010ff1e7819ULL, 0x000fc40000011627ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x2000006dff727230ULL, 0x000fe20000004100ULL,
0x00000096ff49723eULL, 0x000fe200020006ffULL, 0x20000083ff967230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000099ff6d7230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x20000093ff997230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fc400020006ffULL, 0x00000008ff837819ULL, 0x000fe4000001161cULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x2000008aff937230ULL, 0x000fe20000004100ULL,
0x0000b000551c7811ULL, 0x000fe400078e20ffULL, 0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff27847812ULL, 0x000fc400078ec0ffULL,
0x00000010ff927819ULL, 0x100fe4000001164dULL, 0x00000018ff6b7819ULL, 0x000fe4000001164dULL,
0x0000ffff4d7a7812ULL, 0x000fe400078ec0ffULL, 0x00000098ff27723eULL, 0x000fe400020006ffULL,
0x0000009cff98723eULL, 0x000fe200020006ffULL, 0x2000008eff9c7230ULL, 0x000fe20000004100ULL,
0x0000009bff4d723eULL, 0x000fe200020006ffULL, 0x20000091ff9b7230ULL, 0x000fe20000004100ULL,
0x0000001dff8e723eULL, 0x000fe200020006ffULL, 0x2000001fff917230ULL, 0x000fe20000004100ULL,
0x0000001eff8a723eULL, 0x000fe200020006ffULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x0000ffff26817812ULL, 0x000fe200078ec0ffULL,
0x20000098ff987230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe20000011684ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff817819ULL, 0x000fc40000011681ULL,
0x0000009aff9a723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000010ff767819ULL, 0x000fe4000001164bULL, 0x0000ffff4b267812ULL, 0x000fe400078ec0ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x00000090ff4b723eULL, 0x000fe200020006ffULL, 0x2000008dff9f7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x000000ff82827812ULL, 0x000fe200078ec0ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000095ff90723eULL, 0x000fe200020006ffULL,
0x2000009aff957230ULL, 0x000fe20000004100ULL, 0x000000ff94947812ULL, 0x000fe200078ec0ffULL,
0x20000089ff9a7230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x20000084ff897230ULL, 0x000fe20000004100ULL, 0x00000082ff84723eULL, 0x000fe200020006ffULL,
0x20000081ff8d7230ULL, 0x000fe20000004100ULL, 0x00001f18a1827589ULL, 0x000e6200000e0000ULL,
0x000000ff80807812ULL, 0x000fe200078ec0ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x00001fa4a1817589ULL, 0x0004e200000e0000ULL,
0x00000008ff257819ULL, 0x000fe20000011625ULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000094ffa07230ULL, 0x000fe20000004100ULL,
0x000000ff74747812ULL, 0x000fc400078ec0ffULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x00000074ff94723eULL, 0x000fe200020006ffULL,
0x20000086ff747230ULL, 0x000fe20000004100ULL, 0x00000008ffa17819ULL, 0x004fe20000011624ULL,
0x20000080ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe2000001169dULL,
0x20000025ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe2000001169eULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000010ff9f7819ULL, 0x000fe2000001169fULL,
0x000000821d1d9231ULL, 0x082fe200003400ffULL, 0x00000010ffa07819ULL, 0x000fe200000116a0ULL,
0x000000821f1f9231ULL, 0x000fe200003400ffULL, 0x00000008ff9e7819ULL, 0x000fe20000011626ULL,
0x000000811c1c9231ULL, 0x088fe200003400ffULL, 0x000010549f247816ULL, 0x000fe20000000024ULL,
0x000000811e1e9231ULL, 0x000fe200003400ffULL, 0x00001054a0257816ULL, 0x000fc40000000025ULL,
0x00000010ff277819ULL, 0x000fe40000011627ULL, 0x00000010ff267819ULL, 0x000fe4000001169bULL,
0x00000010ff9f7819ULL, 0x000fe20000011673ULL, 0x000000241c40723cULL, 0x000fe20000041840ULL,
0x00000010ff9c7819ULL, 0x000fe4000001169cULL, 0x0000105427267816ULL, 0x000fe40000000026ULL,
0x000010549f277816ULL, 0x000fc4000000009cULL, 0x00000010ff247819ULL, 0x000fe40000011697ULL,
0x00000010ff257819ULL, 0x000fe40000011698ULL, 0x00000010ff997819ULL, 0x000fe20000011699ULL,
0x000000261c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff9a7819ULL, 0x000fe4000001169aULL,
0x0000105499247816ULL, 0x000fe40000000024ULL, 0x000010549a257816ULL, 0x000fc40000000025ULL,
0x00000010ff267819ULL, 0x000fe4000001164bULL, 0x00000010ff277819ULL, 0x000fe4000001164aULL,
0x00000010ff4b7819ULL, 0x000fe20000011696ULL, 0x000000241c38723cULL, 0x000fe20000041838ULL,
0x00000010ff4a7819ULL, 0x000fe40000011674ULL, 0x0000b00052967811ULL, 0x000fe400078e20ffULL,
0x00001054274a7816ULL, 0x000fc4000000004aULL, 0x00001054264b7816ULL, 0x000fe4000000004bULL,
0x00000010ff757819ULL, 0x000fe2000001164cULL, 0x000000009624783bULL, 0x000e620000000200ULL,
0x0000ffff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x0000004a1c34723cULL, 0x000fe20000041834ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x000000ff92987812ULL, 0x000fe200078ec0ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000008ff977819ULL, 0x000fe2000001164cULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x000fc4000001164dULL, 0x00000010ff4c7819ULL, 0x000fe40000011695ULL,
0x00000010ff4d7819ULL, 0x000fe40000011694ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x000010544d4c7816ULL, 0x000fe4000000004cULL, 0x00001054934d7816ULL, 0x000fe40000000092ULL,
0x00000010ff4b7819ULL, 0x000fc40000011690ULL, 0x00000010ff4a7819ULL, 0x000fe40000011691ULL,
0x00000010ff937819ULL, 0x000fe2000001167cULL, 0x0000004c1c30723cULL, 0x000fe20000041830ULL,
0x00000010ff907819ULL, 0x000fe40000011683ULL, 0x000010544b4a7816ULL, 0x000fe4000000004aULL,
0x00001054934b7816ULL, 0x000fe40000000090ULL, 0x00000008ff787819ULL, 0x000fc40000011678ULL,
0x00000010ff4c7819ULL, 0x000fe4000001168fULL, 0x00000010ff4d7819ULL, 0x000fe2000001168eULL,
0x0000004a1c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff8b7819ULL, 0x000fe2000001168bULL,
0x0000008124249231ULL, 0x082fe200003400ffULL, 0x00000010ff8a7819ULL, 0x000fe2000001168aULL,
0x0000008126269231ULL, 0x000fe200003400ffULL, 0x00000010ff8c7819ULL, 0x000fe2000001168cULL,
0x0000008225259231ULL, 0x080fe200003400ffULL, 0x00000010ff8d7819ULL, 0x000fe2000001168dULL,
0x0000008227279231ULL, 0x000fe200003400ffULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x00000010ff4b7819ULL, 0x000fe40000011689ULL, 0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x000010544d4c7816ULL, 0x000fe4000000004cULL,
0x000010548a4d7816ULL, 0x000fe4000000008bULL, 0x000010548c4a7816ULL, 0x000fc4000000008dULL,
0x00001054884b7816ULL, 0x000fe4000000004bULL, 0x0000007effa2723eULL, 0x000fe200020006ffULL,
0x20000078ff7e7230ULL, 0x000fe20000004100ULL, 0x000000ff76767812ULL, 0x000fe200078ec0ffULL,
0x0000004c1c20723cULL, 0x000fe20000041820ULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x200000a2ff787230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x000000a1ff9d723eULL, 0x000fc400020006ffULL, 0x0000009eff9b723eULL, 0x000fe200020006ffULL,
0x0000004a1c28723cULL, 0x000fe20000041828ULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x000000ff759c7812ULL, 0x000fe200078ec0ffULL, 0x2000009dff737230ULL, 0x000fe20000004100ULL,
0x00000008ff7a7819ULL, 0x000fe2000001167aULL, 0x2000009bff757230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff1e7819ULL, 0x000fe4000001167dULL,
0x00000010ff1c7819ULL, 0x000fc40000011680ULL, 0x00000010ff1d7819ULL, 0x000fe4000001167eULL,
0x000010547f1c7816ULL, 0x000fe4000000001cULL, 0x000010541e1d7816ULL, 0x000fe4000000001dULL,
0x00000010ff1e7819ULL, 0x000fe40000011679ULL, 0x00000010ff1f7819ULL, 0x000fe40000011678ULL,
0x00000010ff767819ULL, 0x000fe20000011676ULL, 0x0000001c243c723cULL, 0x000fe2000004183cULL,
0x00000010ff4a7819ULL, 0x000fc40000011671ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x0000009cff9c723eULL, 0x000fe400020006ffULL, 0x00000010ff1d7819ULL, 0x000fe40000011672ULL,
0x00000010ff1c7819ULL, 0x000fe20000011673ULL, 0x2000009cff747230ULL, 0x000fe20000004100ULL,
0x00000098ff98723eULL, 0x000fe400020006ffULL, 0x00000097ff97723eULL, 0x000fc400020006ffULL,
0x000010541f1e7816ULL, 0x000fe2000000001eULL, 0x20000098ff837230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000097ff7c7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00001054761f7816ULL, 0x000fe20000000077ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000010541d1c7816ULL, 0x000fe2000000001cULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x000010544a1d7816ULL, 0x000fc40000000075ULL,
0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL, 0x0000001e2438723cULL, 0x040fe20000041838ULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6f7819ULL, 0x000fe4000001166fULL,
0x00000008ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff1e7819ULL, 0x000fe2000001166eULL,
0x0000001c2434723cULL, 0x000fe20000041834ULL, 0x00000010ff1f7819ULL, 0x000fc40000011674ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff4a7819ULL, 0x000fe40000011683ULL,
0x00000010ff1d7819ULL, 0x000fe4000001166cULL, 0x00000010ff1c7819ULL, 0x000fe4000001167cULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff7a7819ULL, 0x000fc4000001167aULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000010541f1e7816ULL, 0x000fe2000000001eULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x000010544a1f7816ULL, 0x000fc4000000006dULL, 0x000010541d1c7816ULL, 0x000fe2000000001cULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x000010546b1d7816ULL, 0x000fe4000000007aULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x0000001e2430723cULL, 0x000fe20000041830ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x00000010ff1e7819ULL, 0x000fe2000001164fULL,
0x0000001c242c723cULL, 0x000fe2000004182cULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff1f7819ULL, 0x000fe4000001164eULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff1c7819ULL, 0x000fe40000011649ULL, 0x00000010ff6f7819ULL, 0x000fc4000001166fULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff1d7819ULL, 0x000fe4000001166aULL,
0x00001054864c7816ULL, 0x000fe40000000087ULL, 0x00001054844d7816ULL, 0x000fe40000000085ULL,
0x000010547b1e7816ULL, 0x000fe4000000001eULL, 0x00001054701f7816ULL, 0x000fc4000000001fULL,
0x000010541c1c7816ULL, 0x000fe2000000006fULL, 0x0000004c2440723cULL, 0x000fe20000041840ULL,
0x00001054481d7816ULL, 0x000fce000000001dULL, 0x0000001e2420723cULL, 0x040ff00000041820ULL,
0x0000001c2424723cULL, 0x000fe20000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c01b1c7811ULL, 0x000fe200078e40ffULL,
0x01063000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff0dff7812ULL, 0x000fc4000784c0ffULL,
0x0000001c1900720cULL, 0x000fe40003f24070ULL, 0x00000001ff6a7807ULL, 0x000fd60001000000ULL,
0x00003d7000009947ULL, 0x000fea0003800000ULL, 0x01065c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x01065c00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000167687824ULL, 0x000fe400078e0268ULL,
0x00000300ff037624ULL, 0x000fc600078e00ffULL, 0x0000000168047812ULL, 0x000fe400078ec0ffULL,
0xffffffff03037811ULL, 0x000fe400078e08ffULL, 0x000000010400780cULL, 0x000fe20003f25070ULL,
0xffffffffff047424ULL, 0x000fc600078e00ffULL, 0x0000000103037807ULL, 0x000fca0004800000ULL,
0x0000000168037824ULL, 0x000fe200078e0203ULL, 0x000000e01b1c7811ULL, 0x000fc800078e40ffULL,
0x000000000300720cULL, 0x000fe40003f26070ULL, 0x0000001c191d7217ULL, 0x000fe40007800000ULL,
0x0000006069697810ULL, 0x000fc60007ffe0ffULL, 0x000000011d1d7824ULL, 0x000fe400078e0a1cULL,
0x00000100ff4b7424ULL, 0x000fc800078e00ffULL, 0x00000001031e9824ULL, 0x000fe400078e020cULL,
0x00000004ff1f9424ULL, 0x000fe200078e00ffULL, 0x000000201d297807ULL, 0x000fe20000000000ULL,
0x000000015d1c7824ULL, 0x000fe400078e0269ULL, 0x000060001e1e9625ULL, 0x000fe200078e001fULL,
0x0000002906297217ULL, 0x000fc60007800000ULL, 0x000000015c5c7824ULL, 0x000fe200078e0269ULL,
0x000000061e049981ULL, 0x000362000c1e1900ULL, 0x00005e001c1c7625ULL, 0x000fe200078e004bULL,
0x00000004ff497819ULL, 0x000fc60000011605ULL, 0x0000000129487824ULL, 0x000fe200078e0a06ULL,
0x000000101c2a7210ULL, 0x000fe20007f1e0ffULL, 0x000000015b1c7824ULL, 0x100fe400078e0269ULL,
0x000000015a287824ULL, 0x000fe200078e0269ULL, 0x000000481100720cULL, 0x080fe20003f26070ULL,
0x00005e005c1e7625ULL, 0x002fe200078e004bULL, 0x000000481500720cULL, 0x000fc60003f66070ULL,
0x000000ffff2b7224ULL, 0x000fe200000e061dULL, 0x000000101e1e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e004bULL, 0x000000484900720cULL, 0x000fc60003f06070ULL,
0x00005e0028287625ULL, 0x000fe200078e004bULL, 0x000000101c1c7210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x000000481300720cULL, 0x000fe20003f46070ULL,
0x000000ffff1d7224ULL, 0x000fe200020e061dULL, 0x0000001028287210ULL, 0x000fc60007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a657faeULL, 0x0003e4000c101c46ULL,
0x000000ffff297224ULL, 0x000fe400028e0629ULL, 0x000000001e647faeULL, 0x0003e8000c901c46ULL,
0x000000001c637faeULL, 0x0003e8000d101c46ULL, 0x0000000028627faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff1c7984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01063c00ff1d7984ULL, 0x000ea20000000800ULL,
0x80000000661f7824ULL, 0x000fc400078e00ffULL, 0x800000005e1e7824ULL, 0x000fc600078e00ffULL,
0x800000001cff7812ULL, 0x002fe4000780481fULL, 0x800000001dff7812ULL, 0x004fe2000782481eULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x800000005e5e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01063c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782485eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x01018000611d7984ULL, 0x000e620000000800ULL,
0x00000001ff5b7424ULL, 0x000fc600078e00ffULL, 0x01038000611c7984ULL, 0x0004e20000000800ULL,
0x000000081d00720bULL, 0x002fda0003f3d000ULL, 0x00000000001e7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1e1f7812ULL, 0x000fda000782c0ffULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x000000081d00720bULL, 0x00cfe40003f34000ULL, 0x0000001d082a7209ULL, 0x000fe40007810000ULL,
0x00000002ff297819ULL, 0x000fc60000011605ULL, 0x8000002a081e7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400008e0100ULL,
0x000000031a00780cULL, 0x000fe40003f25270ULL, 0x0000ffff08287812ULL, 0x000fe200078e3cffULL,
0x0000001e001e7308ULL, 0x000e660000000800ULL, 0x000000281fff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff5b7807ULL, 0x000fc60001000000ULL, 0x0105802a61009388ULL, 0x000fe80000000800ULL,
0x00001f291e087589ULL, 0x002e6400000e0000ULL, 0x8000002a1d1f2221ULL, 0x000fe20000010000ULL,
0x0000001e09097220ULL, 0x000fe20000410000ULL, 0x00001f181e1d7589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b1f1f2820ULL, 0x000fc80000410000ULL, 0x0000001f00172308ULL, 0x000ee20000000800ULL,
0x0000000840407220ULL, 0x082fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x000000083c3c7220ULL, 0x080fe20000410000ULL, 0x000000083d3d7220ULL, 0x080fe20000410000ULL,
0x0000000838387220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000824247220ULL, 0x080fe20000410000ULL, 0x0000000825257220ULL, 0x000fe20000410000ULL,
0x0000001d42427220ULL, 0x084fe20000410000ULL, 0x0000001d43437220ULL, 0x080fe20000410000ULL,
0x0000001d3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001d3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001d36367220ULL, 0x080fe20000410000ULL, 0x0000001d37377220ULL, 0x080fe20000410000ULL,
0x0000001d32327220ULL, 0x080fe20000410000ULL, 0x0000001d33337220ULL, 0x080fe20000410000ULL,
0x0000001d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001d22227220ULL, 0x080fe20000410000ULL, 0x0000001d23237220ULL, 0x080fe20000410000ULL,
0x0000001d26267220ULL, 0x080fe20000410000ULL, 0x0000001d27277220ULL, 0x000fe20000410000ULL,
0x000000ffff087224ULL, 0x000fe200078e002aULL, 0x0000001c171c2220ULL, 0x008fc80000410000ULL,
0x000000091c097221ULL, 0x00cfe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x01064c00ff1c7984ULL, 0x000e620000000800ULL, 0x80000000661d7824ULL, 0x000fca00078e00ffULL,
0x800000001cff7812ULL, 0x002fe2000780481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x80000000661e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01064c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000780481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000005f1c783bULL, 0x000e620000004200ULL, 0x000099105b5b7816ULL, 0x000fe400000000ffULL,
0x00000017ff8b723eULL, 0x000fe200000010ffULL, 0x000000005928783bULL, 0x000ea20000004200ULL,
0x00000002ff927819ULL, 0x000fe40000011605ULL, 0x000054108b8b7816ULL, 0x000fe2000000008bULL,
0x000000005848783bULL, 0x000ee80000004200ULL, 0x00000000574c783bULL, 0x0008e20000004200ULL,
0x00000010ff7d7819ULL, 0x002fc4000001161cULL, 0x000000ff1c5c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe4000001161cULL, 0x0000ffff1c837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff787819ULL, 0x104fe40000011629ULL, 0x000000ff297c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fc40000011629ULL, 0x0000ffff291c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x108fe40000011649ULL, 0x000000ff49697812ULL, 0x040fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe40000011649ULL, 0x0000ffff49637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7e7819ULL, 0x000fc4000001161dULL, 0x000000ff1d857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff847819ULL, 0x000fe4000001161dULL, 0x0000ffff1d817812ULL, 0x000fe400078ec0ffULL,
0x00000010ff797819ULL, 0x100fe4000001161fULL, 0x000000ff1f8c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fc4000001161fULL, 0x0000ffff1f737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6a7819ULL, 0x100fe4000001164aULL, 0x000000ff4a687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x0000ffff4a297812ULL, 0x000fe400078ec0ffULL,
0x00000010ff747819ULL, 0x000fc40000011628ULL, 0x000000ff28577812ULL, 0x050fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011628ULL, 0x0000ffff281f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1d7819ULL, 0x100fe4000001162aULL, 0x000000ff2a757812ULL, 0x000fe400078ec0ffULL,
0x00000018ff717819ULL, 0x000fc4000001162aULL, 0x0000ffff2a6d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x100fe4000001164cULL, 0x000000ff4c627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164cULL, 0x0000ffff4c587812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x000fc4000001164bULL, 0x000000ff4b5d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b287812ULL, 0x000fe400078ec0ffULL,
0x0000005cff88723eULL, 0x000fe400020006ffULL, 0x00000010ff597819ULL, 0x100fe4000001164dULL,
0x000000ff4d8a7812ULL, 0x000fe200078ec0ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000018ff4c7819ULL, 0x000fc4000001164dULL, 0x0000ffff4d647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff657819ULL, 0x100fe4000001164eULL, 0x000000ff4e4d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001164eULL, 0x0000ffff4e5c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e005bULL, 0x000000ff1e877812ULL, 0x000fc400078ec0ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x000000ff4e00720cULL, 0x000fe40003f05270ULL,
0x00000087ff4e723eULL, 0x000fe200020006ffULL, 0x20000084ff877230ULL, 0x000fe20000004100ULL,
0x00000018ff7f7819ULL, 0x000fe4000001161eULL, 0x00000080ff5f723eULL, 0x000fe200020006ffULL,
0x2000004eff847230ULL, 0x000fe20000004100ULL, 0x000000ff2b777812ULL, 0x000fc400078ec0ffULL,
0x000000ff48617812ULL, 0x000fe200078ec0ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000007cff80723eULL, 0x000fe400020006ffULL, 0x00000057ff4e723eULL, 0x000fe200020006ffULL,
0x2000007fff577230ULL, 0x000fe20000004100ULL, 0x0000006cff7c723eULL, 0x000fe200020006ffULL,
0x2000007bff6c7230ULL, 0x000fe20000004100ULL, 0x00000018ff5e7819ULL, 0x000fe20000011648ULL,
0x2000004eff7f7230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x2000007cff7b7230ULL, 0x000fe20000004100ULL, 0x00000018ff767819ULL, 0x000fe2000001162bULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x2000006fff7c7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000070ff4e723eULL, 0x000fe200020006ffULL, 0x20000061ff707230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000085ff897230ULL, 0x000fe20000004100ULL,
0x00000076ff6f723eULL, 0x000fe200020006ffULL, 0x20000077ff767230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000071ff777230ULL, 0x000fe20000004100ULL,
0x000000ff4f867812ULL, 0x000fe200078ec0ffULL, 0x20000069ff717230ULL, 0x000fe20000004100ULL,
0x00000068ff61723eULL, 0x000fe200020006ffULL, 0x2000005eff687230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x2000004eff697230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000049ff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fe2000001161eULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000ffff1e7a7812ULL, 0x000fe200078ec0ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff1e7819ULL, 0x000fe4000001162bULL,
0x0000ffff2b727812ULL, 0x000fe400078ec0ffULL, 0x0000008cff85723eULL, 0x000fe400020006ffULL,
0x00000062ff4e723eULL, 0x000fe200020006ffULL, 0x2000005dff627230ULL, 0x000fe20000004100ULL,
0x0000004cff49723eULL, 0x000fe200020006ffULL, 0x2000005aff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fe20000011648ULL, 0x2000008aff5a7230ULL, 0x000fe20000004100ULL,
0x0000ffff482b7812ULL, 0x000fe200078ec0ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000086ff8c723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000018ff487819ULL, 0x000fc4000001164fULL, 0x0000004bff86723eULL, 0x000fe200020006ffULL,
0x2000008cff4b7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000004dff8a723eULL, 0x000fe200020006ffULL, 0x20000049ff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff82827812ULL, 0x000fe400078ec0ffULL, 0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff79797812ULL, 0x000fc400078ec0ffULL, 0x000000ff78787812ULL, 0x000fe400078ec0ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000048ff49723eULL, 0x000fe200020006ffULL,
0x20000086ff487230ULL, 0x000fe20000004100ULL, 0x00000008ff1f7819ULL, 0x000fe2000001161fULL,
0x20000073ff867230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000004aff4c7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000008aff4a7230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000082ff8a7230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x2000007dff907230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe2000001161cULL,
0x20000079ff8c7230ULL, 0x000fe20000004100ULL, 0x0000001fff1f723eULL, 0x000fe200020006ffULL,
0x20000078ff827230ULL, 0x000fe20000004100ULL, 0x0000b800601c7811ULL, 0x000fe200078e20ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL,
0x2000001fff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff1e1e7812ULL, 0x000fc400078ec0ffULL,
0x0000001dff78723eULL, 0x000fe400020006ffULL, 0x0000001eff79723eULL, 0x000fe400020006ffULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x00000008ff837819ULL, 0x000fe20000011683ULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000008ff817819ULL, 0x000fe20000011681ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe4000001167aULL,
0x000000ff74747812ULL, 0x000fc400078ec0ffULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000083ff8d7230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000081ff8e7230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000007aff837230ULL, 0x000fe20000004100ULL,
0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff817230ULL, 0x000fe20000004100ULL,
0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff7a7230ULL, 0x000fe20000004100ULL,
0x0000006eff74723eULL, 0x000fe200020006ffULL, 0x00001f928b6d7589ULL, 0x000e6200000e0000ULL,
0x000000ff6b6b7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff637819ULL, 0x000fe20000011663ULL,
0x00001f188b6e7589ULL, 0x0004e200000e0000ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000008ff2b7819ULL, 0x000fe2000001162bULL, 0x2000007eff8f7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000073ff7e7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x000000ff6a6a7812ULL, 0x000fe200078ec0ffULL,
0x2000006bff737230ULL, 0x000fe20000004100ULL, 0x0000002bff2b723eULL, 0x000fe200020006ffULL,
0x20000063ff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x0000006aff60723eULL, 0x000fe200020006ffULL, 0x2000002bff6a7230ULL, 0x000fe20000004100ULL,
0x0000002aff63723eULL, 0x000fe200020006ffULL, 0x0000006d1c1c8231ULL, 0x082fe200003400ffULL,
0x00000008ff8b7819ULL, 0x004fe20000011629ULL, 0x0000006d1e1e8231ULL, 0x000fe200003400ffULL,
0x00000010ff2a7819ULL, 0x000fe20000011688ULL, 0x0000006e1d1d8231ULL, 0x088fe200003400ffULL,
0x00000010ff2b7819ULL, 0x000fe20000011689ULL, 0x0000006e1f1f8231ULL, 0x000fe200003400ffULL,
0x00000010ff297819ULL, 0x000fe20000011690ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe2000001168fULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00001054292a7816ULL, 0x000fc4000000002aULL, 0x00001054882b7816ULL, 0x000fe4000000002bULL,
0x00000008ff887819ULL, 0x000fe40000011628ULL, 0x00000010ff297819ULL, 0x000fe4000001165fULL,
0x00000010ff287819ULL, 0x000fe2000001168dULL, 0x0000002a1c40723cULL, 0x000fe20000041840ULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff8e7819ULL, 0x000fc4000001168eULL,
0x0000105429287816ULL, 0x000fe40000000028ULL, 0x0000105487297816ULL, 0x000fe4000000008eULL,
0x00000010ff2a7819ULL, 0x000fe40000011684ULL, 0x00000010ff2b7819ULL, 0x000fe4000001168aULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x000000281c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x000010542b2a7816ULL, 0x000fe4000000002aULL,
0x000010548c2b7816ULL, 0x000fe40000000085ULL, 0x00000010ff287819ULL, 0x000fe40000011657ULL,
0x0000b80056297811ULL, 0x000fe400078e20ffULL, 0x00000010ff837819ULL, 0x000fe20000011683ULL,
0x0000002a1c38723cULL, 0x000fe20000041838ULL, 0x00000010ff847819ULL, 0x000fc4000001166cULL,
0x00000010ff577819ULL, 0x000fe40000011686ULL, 0x0000105428567816ULL, 0x000fe40000000083ULL,
0x000000002928783bULL, 0x000e620000000200ULL, 0x0000105484577816ULL, 0x000fe40000000057ULL,
0x000000ff59847812ULL, 0x000fe400078ec0ffULL, 0x00000008ff837819ULL, 0x000fe40000011658ULL,
0x00000010ff587819ULL, 0x000fe2000001167fULL, 0x000000561c34723cULL, 0x000fe20000041834ULL,
0x00000010ff597819ULL, 0x000fc40000011680ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000008ff727819ULL, 0x000fe40000011672ULL, 0x0000105481587816ULL, 0x000fe20000000058ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000105482597816ULL, 0x000fc40000000059ULL,
0x00000010ff577819ULL, 0x000fe4000001167bULL, 0x00000010ff567819ULL, 0x000fe4000001167dULL,
0x00000010ff7f7819ULL, 0x000fe2000001167cULL, 0x000000581c30723cULL, 0x000fe20000041830ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x0000105457567816ULL, 0x000fc40000000056ULL, 0x000010547f577816ULL, 0x000fe2000000007eULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x000fe40000011675ULL,
0x00000010ff597819ULL, 0x000fe20000011678ULL, 0x0000006d28288231ULL, 0x082fe200003400ffULL,
0x00000010ff767819ULL, 0x000fe20000011676ULL, 0x000000561c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x0000006d2a2a8231ULL, 0x000fe200003400ffULL,
0x0000105459587816ULL, 0x000fe20000000058ULL, 0x0000006e29298231ULL, 0x080fe200003400ffULL,
0x0000105479597816ULL, 0x000fe20000000076ULL, 0x0000006e2b2b8231ULL, 0x000fe200003400ffULL,
0x00000010ff777819ULL, 0x000fc40000011677ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff767819ULL, 0x000fe2000001166fULL, 0x000000581c20723cULL, 0x000fe20000041820ULL,
0x00000010ff577819ULL, 0x000fe40000011672ULL, 0x0000105477567816ULL, 0x000fe4000000007aULL,
0x0000105476577816ULL, 0x000fe40000000057ULL, 0x00000010ff6b7819ULL, 0x000fc4000001166bULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x000000561c1c723cULL, 0x000fe20000041824ULL, 0x000000ff67877812ULL, 0x000fe200078ec0ffULL,
0x2000008bff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff647819ULL, 0x000fe20000011664ULL,
0x20000088ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe4000001164fULL,
0x00000010ff257819ULL, 0x000fc40000011668ULL, 0x00000010ff247819ULL, 0x000fe4000001166aULL,
0x00000010ff267819ULL, 0x000fe40000011669ULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x0000105426257816ULL, 0x000fe4000000006bULL, 0x00000010ff567819ULL, 0x000fe4000001165dULL,
0x00000010ff677819ULL, 0x000fc40000011667ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x00000024283c723cULL, 0x000fe2000004183cULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000010ff257819ULL, 0x000fe4000001165eULL,
0x00000010ff247819ULL, 0x000fe2000001165fULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff65657812ULL, 0x000fc400078ec0ffULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x0000105456257816ULL, 0x000fe40000000067ULL, 0x00000010ff267819ULL, 0x000fe40000011661ULL,
0x00000010ff277819ULL, 0x000fe40000011660ULL, 0x00000008ff5c7819ULL, 0x000fe2000001165cULL,
0x000000242834723cULL, 0x000fe20000041834ULL, 0x00000008ff4f7819ULL, 0x000fc4000001164fULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000010ff247819ULL, 0x000fe4000001164dULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000087ff6c7230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000084ff7c7230ULL, 0x000fe20000004100ULL, 0x0000105427267816ULL, 0x000fe20000000026ULL,
0x20000083ff7b7230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fe40000011664ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000105463277816ULL, 0x000fc40000000062ULL, 0x00001054244d7816ULL, 0x000fe2000000004dULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff247819ULL, 0x000fe2000001165bULL, 0x000000262838723cULL, 0x000fe20000041838ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00001054244b7816ULL, 0x000fe4000000004bULL,
0x00000010ff707819ULL, 0x000fc40000011670ULL, 0x00000010ff277819ULL, 0x000fe4000001166cULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff577819ULL, 0x000fc4000001167cULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff257819ULL, 0x000fe40000011648ULL,
0x00000010ff5c7819ULL, 0x000fc4000001165cULL, 0x00000010ff247819ULL, 0x000fe40000011649ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x0000105427267816ULL, 0x000fe4000000004eULL,
0x0000105473587816ULL, 0x000fe40000000070ULL, 0x0000105474597816ULL, 0x000fe40000000071ULL,
0x0000105457277816ULL, 0x000fc4000000005aULL, 0x000010544c4c7816ULL, 0x000fe4000000007bULL,
0x00001054654a7816ULL, 0x000fe2000000004aULL, 0x000000582840723cULL, 0x000fe20000041840ULL,
0x00001054255c7816ULL, 0x000fe4000000005cULL, 0x00001054245d7816ULL, 0x000fca000000004fULL,
0x000000262830723cULL, 0x040ff00000041830ULL, 0x0000004c282c723cULL, 0x040ff0000004182cULL,
0x0000004a2820723cULL, 0x040ff00000041820ULL, 0x0000005c281c723cULL, 0x000fe2000004181cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400257305ULL, 0x0002a4000021f000ULL,
0x3fa0000024247823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x01065c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000003001b247a10ULL, 0x000fe20007ffe0ffULL, 0x00000004042b7c24ULL, 0x020fe2000f8e0207ULL,
0x00000004ff297819ULL, 0x000fe20000011605ULL, 0x00000100ff497424ULL, 0x000fe200078e00ffULL,
0x0000000124257810ULL, 0x040fe20007ffe0ffULL, 0x0000010024267824ULL, 0x000fe200078e00ffULL,
0x0000007f2b247812ULL, 0x000fe400078ef80fULL, 0x000000022500720cULL, 0x000fe40003f26070ULL,
0x0000002619277217ULL, 0x000fe20007800000ULL, 0x00005e0024247625ULL, 0x000fe200078e0049ULL,
0x0000007f2b287812ULL, 0x000fc400078ef814ULL, 0x0000007f2b2a7812ULL, 0x000fe200078ef816ULL,
0x0000000127277824ULL, 0x000fe200078e0a26ULL, 0x0000007f2b267812ULL, 0x000fc600078ef812ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0049ULL, 0x0000002027277807ULL, 0x000fe40000800000ULL,
0x0000001024247210ULL, 0x000fe40007f3e0ffULL, 0x00000027060f7217ULL, 0x000fe20007800000ULL,
0x00005e0026267625ULL, 0x000fc800078e0049ULL, 0x000000010f127824ULL, 0x000fe200078e0a06ULL,
0x0000001026267210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fc600008e0625ULL,
0x000000122900720cULL, 0x080fe20003f46070ULL, 0x00005e0028287625ULL, 0x000fe200078e0049ULL,
0x000000121100720cULL, 0x080fe40003f26070ULL, 0x000000121500720cULL, 0x080fe20003f86070ULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x000000121300720cULL, 0x000fe40003f66070ULL,
0x0000001028127210ULL, 0x080fe40007fbe0ffULL, 0x000000102a107210ULL, 0x000fc60007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024477faeULL, 0x0003e2000d101c46ULL, 0x000000ffff117224ULL, 0x000fc600030e062bULL,
0x0000000026467faeULL, 0x0003e8000c901c46ULL, 0x0000000012457faeULL, 0x0003e8000d901c46ULL,
0x0000000010447faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff0f7984ULL, 0x000ea20000000800ULL, 0x8000000066107824ULL, 0x002fca00078e00ffULL,
0x800000000fff7812ULL, 0x004fe20007824810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01065400ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007824810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000066117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000f0f7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01065400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000005124783bULL, 0x000e680000004200ULL, 0x000000005444783bULL, 0x000ea80000004200ULL,
0x000000005328783bULL, 0x0007280000004200ULL, 0x000000005010783bULL, 0x000aa20000004200ULL,
0x00000002ff537819ULL, 0x008fc40000011605ULL, 0x00000010ff5f7819ULL, 0x102fe40000011624ULL,
0x000000ff247f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011624ULL,
0x0000ffff245e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fe40000011625ULL,
0x000000ff25807812ULL, 0x000fc400078ec0ffULL, 0x00000018ff507819ULL, 0x020fe40000011625ULL,
0x0000ffff25607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff257819ULL, 0x100fe40000011627ULL,
0x000000ff274c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff167819ULL, 0x000fe40000011627ULL,
0x0000ffff27247812ULL, 0x000fc400078ec0ffULL, 0x00000010ff147819ULL, 0x104fe40000011644ULL,
0x000000ff44577812ULL, 0x040fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe40000011644ULL,
0x0000ffff44787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fe40000011647ULL,
0x000000ff475c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011647ULL,
0x0000ffff476d7812ULL, 0x000fe400078ec0ffULL, 0x00000017ff27723eULL, 0x000fe400000010ffULL,
0x00000010ff0f7819ULL, 0x100fe40000011645ULL, 0x000000ff45597812ULL, 0x000fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fc40000011645ULL, 0x0000ffff45777812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe40000011646ULL, 0x000000ff465a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe40000011646ULL, 0x0000ffff46717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6a7819ULL, 0x010fc4000001162bULL, 0x000000ff2b7d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001162bULL, 0x0000ffff2b667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x100fe40000011611ULL, 0x000000ff114b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff477819ULL, 0x000fc40000011611ULL, 0x0000ffff114e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff687819ULL, 0x100fe4000001162aULL, 0x000000ff2a7b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001162aULL, 0x0000ffff2a657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff697819ULL, 0x000fc40000011610ULL, 0x000000ff102b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe40000011610ULL, 0x0000ffff10457812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe40000011612ULL, 0x000000ff12157812ULL, 0x000fe400078ec0ffULL,
0x00000018ff117819ULL, 0x000fc40000011612ULL, 0x0000ffff12487812ULL, 0x000fe400078ec0ffULL,
0x00000010ff497819ULL, 0x100fe40000011613ULL, 0x000000ff13127812ULL, 0x040fe400078ec0ffULL,
0x00000018ff107819ULL, 0x000fe40000011613ULL, 0x0000ffff132a7812ULL, 0x000fe400078ec0ffULL,
0x0000541027137816ULL, 0x000fc40000000027ULL, 0x000000ff264d7812ULL, 0x000fe400078ec0ffULL,
0x00000016ff16723eULL, 0x000fe200020006ffULL, 0x00001f5313537589ULL, 0x000fe200000e0000ULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x000000ff14147812ULL, 0x000fe200078ec0ffULL,
0x00001f1813547589ULL, 0x0003e200000e0000ULL, 0x00000010ff707819ULL, 0x000fe40000011628ULL,
0x00000010ff747819ULL, 0x000fc40000011629ULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x0000004cff13723eULL, 0x002fe200020006ffULL, 0x2000004dff4c7230ULL, 0x000fe20000004100ULL,
0x00000015ff15723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe200078ec0ffULL,
0x20000013ff4d7230ULL, 0x000fe20000004100ULL, 0x0000004bff13723eULL, 0x000fe200020006ffULL,
0x20000016ff4b7230ULL, 0x000fe20000004100ULL, 0x00000047ff16723eULL, 0x000fc400020006ffULL,
0x00000012ff12723eULL, 0x000fe200020006ffULL, 0x20000013ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff13723eULL, 0x000fe400020006ffULL, 0x00000014ff10723eULL, 0x000fe200020006ffULL,
0x20000011ff147230ULL, 0x000fe20000004100ULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x00000046ff18723eULL, 0x000fe200020006ffULL, 0x2000002bff467230ULL, 0x000fe20000004100ULL,
0x00000008ff117819ULL, 0x000fe20000011678ULL, 0x20000016ff2b7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000010ff787230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000015ff167230ULL, 0x000fe20000004100ULL,
0x00000074ff10723eULL, 0x000fe200020006ffULL, 0x20000012ff157230ULL, 0x000fe20000004100ULL,
0x000000ff0f127812ULL, 0x000fe200078ec0ffULL, 0x20000071ff747230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000070ff717230ULL, 0x000fe20000004100ULL,
0x00000012ff12723eULL, 0x000fe200020006ffULL, 0x20000010ff707230ULL, 0x000fe20000004100ULL,
0x00000011ff11723eULL, 0x000fe200020006ffULL, 0x20000059ff727230ULL, 0x000fe20000004100ULL,
0x0000b80055107811ULL, 0x000fe200078e20ffULL, 0x20000013ff0f7230ULL, 0x000fe20000004100ULL,
0x000000ff29797812ULL, 0x000fe200078ec0ffULL, 0x20000018ff187230ULL, 0x000fe20000004100ULL,
0x00000018ff637819ULL, 0x000fc40000011629ULL, 0x0000ffff29677812ULL, 0x000fe400078ec0ffULL,
0x0000005bff29723eULL, 0x000fe400020006ffULL, 0x0000007bff59723eULL, 0x000fe200020006ffULL,
0x20000012ff7b7230ULL, 0x000fe20000004100ULL, 0x0000007aff5b723eULL, 0x000fe200020006ffULL,
0x20000011ff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff28627812ULL, 0x040fe200078ec0ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x0000ffff28737812ULL, 0x000fe200078ec0ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000008ff777819ULL, 0x000fe20000011677ULL,
0x2000005cff6c7230ULL, 0x000fe20000004100ULL, 0x00000018ff5d7819ULL, 0x000fe20000011628ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x000000ff76767812ULL, 0x000fc400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x000000ff75757812ULL, 0x000fe400078ec0ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000008ff737819ULL, 0x000fc40000011673ULL,
0x0000005dff5c723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000008ff677819ULL, 0x000fe20000011667ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000063ff5d723eULL, 0x000fe200020006ffULL, 0x20000062ff637230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000079ff627230ULL, 0x000fe20000004100ULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x20000077ff797230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000076ff777230ULL, 0x000fe20000004100ULL,
0x000000ff6a6a7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff767230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x2000006dff757230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x0000005310108231ULL, 0x082fe200003400ffULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x20000073ff6d7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x0000005312128231ULL, 0x000fe200003400ffULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000067ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x20000068ff677230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000006aff687230ULL, 0x000fe20000004100ULL,
0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL, 0x0000005411118231ULL, 0x080fe200003400ffULL,
0x00000010ff617819ULL, 0x000fe20000011626ULL, 0x20000065ff6a7230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x0000005413138231ULL, 0x000fe200003400ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff64557812ULL, 0x000fe200078ec0ffULL, 0x20000066ff647230ULL, 0x000fe20000004100ULL,
0x000000ff61657812ULL, 0x000fe200078ec0ffULL, 0x2000005fff667230ULL, 0x000fe20000004100ULL,
0x00000057ff27723eULL, 0x000fc400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000065ff5f723eULL, 0x000fe200020006ffULL, 0x20000056ff6e7230ULL, 0x000fe20000004100ULL,
0x00000018ff4a7819ULL, 0x000fe20000011626ULL, 0x20000055ff657230ULL, 0x000fe20000004100ULL,
0x0000ffff26267812ULL, 0x000fe200078ec0ffULL, 0x2000005fff557230ULL, 0x000fe20000004100ULL,
0x000000ff25257812ULL, 0x000fc400078ec0ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000007cff56723eULL, 0x000fe400020006ffULL, 0x00000025ff5f723eULL, 0x000fe200020006ffULL,
0x20000058ff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe20000011626ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe20000011627ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fc40000011678ULL,
0x00000010ff277819ULL, 0x000fe40000011672ULL, 0x0000105425267816ULL, 0x000fe40000000026ULL,
0x00000008ff727819ULL, 0x000fe40000011624ULL, 0x00000010ff257819ULL, 0x000fe4000001166eULL,
0x00000010ff247819ULL, 0x000fe4000001167aULL, 0x00000008ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff6e7819ULL, 0x000fe4000001166fULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000051ff28723eULL, 0x000fe400020006ffULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x00000008ff607819ULL, 0x000fe20000011660ULL, 0x20000028ff287230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x000010546e257816ULL, 0x000fe40000000079ULL,
0x00000060ff61723eULL, 0x000fe200020006ffULL, 0x2000005eff607230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fe4000001167bULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x00000024103c723cULL, 0x000fe2000004183cULL, 0x000010545e277816ULL, 0x000fe20000000027ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x000000ff696e7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff777819ULL, 0x000fc40000011677ULL,
0x00000010ff257819ULL, 0x000fe20000011628ULL, 0x000000261040723cULL, 0x000fe20000041840ULL,
0x00000010ff247819ULL, 0x000fe40000011629ULL, 0x00000010ff287819ULL, 0x000fe40000011674ULL,
0x00000010ff297819ULL, 0x000fe40000011675ULL, 0x0000105425287816ULL, 0x000fe40000000028ULL,
0x0000105424297816ULL, 0x000fc40000000029ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000010ff267819ULL, 0x000fe4000001166bULL, 0x00000010ff277819ULL, 0x000fe2000001166cULL,
0x000000281034723cULL, 0x000fe20000041834ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x0000b800526b7811ULL, 0x000fe200078e20ffULL, 0x2000006eff527230ULL, 0x000fe20000004100ULL,
0x00000008ff6c7819ULL, 0x000fc40000011645ULL, 0x000000ff446e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff457819ULL, 0x000fe40000011662ULL, 0x00000010ff297819ULL, 0x000fe4000001165cULL,
0x00000010ff287819ULL, 0x000fe4000001166dULL, 0x0000105477267816ULL, 0x000fe40000000026ULL,
0x0000105476277816ULL, 0x000fc40000000027ULL, 0x00000010ff447819ULL, 0x000fe40000011663ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff707819ULL, 0x000fe20000011670ULL,
0x000000261038723cULL, 0x000fe20000041838ULL, 0x00000010ff627819ULL, 0x000fe2000001165dULL,
0x000000006b24783bULL, 0x000e620000000200ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x0000007dff5a723eULL, 0x000fc400020006ffULL, 0x0000105429287816ULL, 0x000fe40000000028ULL,
0x0000105471447816ULL, 0x000fe20000000044ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x0000105470457816ULL, 0x000fe40000000045ULL, 0x0000105462297816ULL, 0x000fe40000000073ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x000000441030723cULL, 0x000fe20000041830ULL, 0x00000010ff5b7819ULL, 0x000fc4000001165bULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff447819ULL, 0x000fe20000011659ULL, 0x00000028102c723cULL, 0x000fe2000004182cULL,
0x00000010ff457819ULL, 0x000fe4000001165aULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000105467447816ULL, 0x000fc40000000044ULL, 0x00000010ff297819ULL, 0x000fe40000011664ULL,
0x0000105468457816ULL, 0x000fe40000000045ULL, 0x000010545b287816ULL, 0x000fe4000000006aULL,
0x0000105456297816ULL, 0x000fe40000000029ULL, 0x00000050ff51723eULL, 0x000fe200020006ffULL,
0x2000007eff507230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x000000441020723cULL, 0x040fe20000041820ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000007cff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x00000028101c723cULL, 0x000fe2000004181cULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000072ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x0000005324248231ULL, 0x082fe200003400ffULL, 0x00000008ff4e7819ULL, 0x000fe2000001164eULL,
0x2000006cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff117819ULL, 0x000fe20000011650ULL,
0x0000005326268231ULL, 0x000fe200003400ffULL, 0x00000010ff107819ULL, 0x000fe20000011651ULL,
0x0000005425258231ULL, 0x080fe200003400ffULL, 0x0000105411607816ULL, 0x000fe20000000060ULL,
0x0000005427278231ULL, 0x000fe200003400ffULL, 0x00000010ff117819ULL, 0x000fc4000001164aULL,
0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff49497812ULL, 0x000fe400078ec0ffULL,
0x00000008ff487819ULL, 0x000fe40000011648ULL, 0x00000008ff2a7819ULL, 0x000fe4000001162aULL,
0x0000105410617816ULL, 0x000fe40000000061ULL, 0x0000006eff6e723eULL, 0x000fc400020006ffULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff107819ULL, 0x000fe2000001165fULL,
0x2000006eff5d7230ULL, 0x000fe20000004100ULL, 0x00001054115e7816ULL, 0x000fe2000000005eULL,
0x00000060243c723cULL, 0x000fe2000004183cULL, 0x0000007fff57723eULL, 0x000fe400020006ffULL,
0x00000080ff58723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x000fe20000011646ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff117819ULL, 0x000fe20000011652ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fc400020006ffULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x00001054104d7816ULL, 0x000fe2000000004dULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000010ff107819ULL, 0x000fe2000001164bULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe40000011669ULL,
0x0000105411467816ULL, 0x000fe40000000046ULL, 0x00000010ff117819ULL, 0x000fc40000011618ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00001054105f7816ULL, 0x000fe4000000005fULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff107819ULL, 0x000fe4000001165dULL,
0x00001054115c7816ULL, 0x000fe2000000005cULL, 0x0000005e2434723cULL, 0x000fe20000041834ULL,
0x00000010ff577819ULL, 0x000fc40000011657ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff2b7819ULL, 0x000fc4000001162bULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff167819ULL, 0x000fe40000011616ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff117819ULL, 0x000fe40000011615ULL, 0x00000010ff127819ULL, 0x000fe40000011649ULL,
0x00000010ff137819ULL, 0x000fc40000011614ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff0f7819ULL, 0x000fe4000001160fULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x0000105410477816ULL, 0x000fe40000000047ULL, 0x0000105466447816ULL, 0x000fe40000000057ULL,
0x0000105465457816ULL, 0x000fc40000000058ULL, 0x00001054554c7816ULL, 0x000fe2000000004cULL,
0x000000462430723cULL, 0x040fe20000041830ULL, 0x000010542b5d7816ULL, 0x000fe4000000004eULL,
0x000010544f107816ULL, 0x000fe40000000016ULL, 0x0000105412117816ULL, 0x000fe40000000011ULL,
0x0000105413487816ULL, 0x000fe20000000048ULL, 0x000000442440723cULL, 0x000fe20000041840ULL,
0x000010540f497816ULL, 0x000fce000000002aULL, 0x0000004c2438723cULL, 0x040ff00000041838ULL,
0x0000005c242c723cULL, 0x040ff0000004182cULL, 0x000000102420723cULL, 0x040ff00000041820ULL,
0x000000482424723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01064000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff0dff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff6a7807ULL, 0x000fe40004000000ULL,
0x000003001b1b7a10ULL, 0x000fe40007ffe0ffULL, 0x000000ff0bff7812ULL, 0x000fe4000780c0ffULL,
0x000000021b00720cULL, 0x000fe40003f26070ULL, 0x00000001ff0b7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff060000007947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x000ea40000002500ULL, 0x000000020700720cULL, 0x004fda0003f06070ULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x0180000009007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0001094000047802ULL, 0x000fe40000000f00ULL, 0x00008f9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x000ea40000001000ULL, 0xbf80000000027423ULL, 0x004fc80000000009ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x00000002ff0b7819ULL, 0x00afe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x004fca0000410000ULL,
0x00001f0b00047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000004004407220ULL, 0x042fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000004205427220ULL, 0x044fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000000000107919ULL, 0x002e620000000000ULL, 0x00000300ff297624ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x000000012900780cULL, 0x000fe40003f05270ULL,
0x0000000210007812ULL, 0x002fe400078ec0ffULL, 0x00000002ff117819ULL, 0x000fe40000011610ULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000200037811ULL, 0x000fc400078ff8ffULL,
0x00000004000a7811ULL, 0x040fe400078ff8ffULL, 0x00000006000e7811ULL, 0x000fe400078ff8ffULL,
0x0000000810197811ULL, 0x000fe400078ff0ffULL, 0x0000000702007812ULL, 0x100fe400078e7811ULL,
0x0000000703047812ULL, 0x100fe400078e7811ULL, 0x000000070a0c7812ULL, 0x100fe200078e7811ULL,
0x0000000811057824ULL, 0x040fe200078e0200ULL, 0x000000070e0f7812ULL, 0x000fe200078e7811ULL,
0x000008001a007824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7812ULL, 0x100fe200078e7819ULL,
0x00000008110b7824ULL, 0x040fe200078e0204ULL, 0x0000000702027812ULL, 0x100fe200078e7819ULL,
0x00000008110d7824ULL, 0x000fe200078e020cULL, 0x0000000703037812ULL, 0x000fe200078e7819ULL,
0x0000000811117824ULL, 0x000fe200078e020fULL, 0x000000070e0e7812ULL, 0x000fe200078e7819ULL,
0x0000000819177824ULL, 0x000fe200078e020aULL, 0x0000003c3d04723eULL, 0x000fe200000010ffULL,
0x00000008190f7824ULL, 0x000fe200078e0202ULL, 0x0000a00000027810ULL, 0x000fe20007ffe0ffULL,
0x00000008100a7824ULL, 0x000fe200078e00ffULL, 0x0000003e3f0c723eULL, 0x000fe200000010ffULL,
0x0000000819157824ULL, 0x000fe200078e0203ULL, 0x000000404103723eULL, 0x000fe200000010ffULL,
0x0000000819197824ULL, 0x000fe200078e020eULL, 0x000000080a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x00005410031c7816ULL, 0x000fe20000000004ULL,
0x000000100f137824ULL, 0x000fe200078e0202ULL, 0x00007632031d7816ULL, 0x000fe20000000004ULL,
0x000000100b0b7824ULL, 0x100fe200078e0202ULL, 0x000000303103723eULL, 0x000fe200000010ffULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x0000002c2d04723eULL, 0x000fe200000010ffULL,
0x000000100d0f7824ULL, 0x000fc400078e0202ULL, 0x0000001011117824ULL, 0x100fe400078e0202ULL,
0x0000001017177824ULL, 0x100fe400078e0202ULL, 0x0000001019197824ULL, 0x000fe400078e0202ULL,
0x00000001050d7824ULL, 0x000fe200078e020aULL, 0x000000383905723eULL, 0x000fe200000010ffULL,
0x000000010a137824ULL, 0x040fe400078e0213ULL, 0x000000010a0e7824ULL, 0x040fe200078e020bULL,
0x0000001c0d007388ULL, 0x0003e20000000a00ULL, 0x000000010a157824ULL, 0x040fe200078e0215ULL,
0x00000042430b723eULL, 0x000fe200000010ffULL, 0x000000010a0f7824ULL, 0x000fc400078e020fULL,
0x000000010a117824ULL, 0x040fe400078e0211ULL, 0x000000010a177824ULL, 0x040fe400078e0217ULL,
0x000000010a197824ULL, 0x000fe200078e0219ULL, 0x00000034350a723eULL, 0x000fc800000010ffULL,
0x00005410051c7816ULL, 0x142fe4000000000aULL, 0x00007632051d7816ULL, 0x000fe4000000000aULL,
0x000000202105723eULL, 0x000fe400000010ffULL, 0x00000024250a723eULL, 0x000fe200000010ffULL,
0x0000001c0e007388ULL, 0x0003e40000000a00ULL, 0x00005410031c7816ULL, 0x142fe40000000004ULL,
0x00007632031d7816ULL, 0x000fc40000000004ULL, 0x00005410050e7816ULL, 0x100fe4000000000aULL,
0x0000003a3b03723eULL, 0x000fe200000010ffULL, 0x0000001c0f007388ULL, 0x0003e20000000a00ULL,
0x000000363704723eULL, 0x000fe400000010ffULL, 0x00007632050f7816ULL, 0x002fe4000000000aULL,
0x000000323305723eULL, 0x000fe400000010ffULL, 0x0000002e2f0a723eULL, 0x000fe200000010ffULL,
0x0000000e11007388ULL, 0x0003e40000000a00ULL, 0x000054100b0e7816ULL, 0x002fc4000000000cULL,
0x000076320b0f7816ULL, 0x000fe4000000000cULL, 0x00000022230b723eULL, 0x000fe400000010ffULL,
0x00000026270c723eULL, 0x000fe200000010ffULL, 0x0000000e13007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x000fc4000000000aULL, 0x0000763205057816ULL, 0x000fe2000000000aULL,
0x0000000e15007388ULL, 0x0003e20000000a00ULL, 0x000054100b0a7816ULL, 0x140fe4000000000cULL,
0x000076320b0b7816ULL, 0x000fe2000000000cULL, 0x0000000417007388ULL, 0x0003e80000000a00ULL,
0x0000000a19007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002cb000008947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000580029047a24ULL, 0x002fe200078e02ffULL, 0x000000ff1a00720cULL, 0x000fe20003f25270ULL,
0x00002000ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000000001b7919ULL, 0x000e620000002700ULL,
0x0000660004187a24ULL, 0x000fc600078e02ffULL, 0x00000000000a7919ULL, 0x000e640000002600ULL,
0x00001fff18057811ULL, 0x000fe200078e40ffULL, 0x0000001003197824ULL, 0x044fe200078e0200ULL,
0x0000002003237810ULL, 0x040fe40007ffe0ffULL, 0x0000004003257810ULL, 0x040fe40007ffe0ffULL,
0x00a00000190c7984ULL, 0x0004e20000000c00ULL, 0x0000006003277810ULL, 0x000fe20007ffe0ffULL,
0x000058001b1b7a24ULL, 0x002fc400078e020aULL, 0x00a2000019107984ULL, 0x0004620000000c00ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x000003001b047a24ULL, 0x000fe400078e02ffULL,
0x00a4000019147984ULL, 0x0005220000000c00ULL, 0x000000ff1a00720cULL, 0x000fe20000705670ULL,
0x0000000104287824ULL, 0x000fe400078e0207ULL, 0x00a60000191c7984ULL, 0x0004620000000c00ULL,
0x01ffffff18077812ULL, 0x000fe400078ec0ffULL, 0x00000028050a7211ULL, 0x000fca00078f98ffULL,
0x00006c000a0a7625ULL, 0x000fcc00078e000bULL, 0x000008001a0a7825ULL, 0x000fcc00078e000aULL,
0x0000001023227825ULL, 0x000fc800078e000aULL, 0x0000001025247825ULL, 0x000fc800078e000aULL,
0x0000001027267825ULL, 0x000fc800078e000aULL, 0x0000001003207825ULL, 0x000fe200078e000aULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x00cea20000000000ULL,
0x00000080ff197424ULL, 0x000fe400078e00ffULL, 0x0000000128187824ULL, 0x000fe400078e0207ULL,
0x000000100a2a7824ULL, 0x004fe200078e00ffULL, 0x00000001ff2c7819ULL, 0x000fe2000001160aULL,
0x00006c00280a7625ULL, 0x000fc600078e0019ULL, 0x000000702a2b7812ULL, 0x000fe200078ec0ffULL,
0x00006c0018187625ULL, 0x000fe200078e0019ULL, 0x0000000c2c2c7812ULL, 0x000fc800078ec0ffULL,
0x0000000a2c0a7210ULL, 0x140fe40007b5e02bULL, 0x000000182c187210ULL, 0x000fe40007d9e02bULL,
0x0000000bff0b7210ULL, 0x000fe400017e64ffULL, 0x00000019ff197210ULL, 0x000fc600027ea4ffULL,
0x000000080a007986ULL, 0x0005e8000c101906ULL, 0x0000000918007986ULL, 0x0005e4000c101906ULL,
0x0000000c20007986ULL, 0x00c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000001022007986ULL, 0x0025e8000c101d06ULL, 0x0000001424007986ULL, 0x0105e8000c101d06ULL,
0x0000001c26007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff087424ULL, 0x000fe200078e00ffULL,
0xffffffff290b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a001b087625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ee400099ee1c6ULL, 0x0000000b0800720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x000ee40000000000ULL,
0x000000ff0800720cULL, 0x008fda0003f05270ULL, 0x0000284000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x004fe200078e00ffULL,
0x00000001040a7810ULL, 0x002fe40007ffe0ffULL, 0x0000007008177812ULL, 0x000fe400078ec0ffULL,
0x0000000c090e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0004087625ULL, 0x000fc800078e000dULL,
0x00006c000a0a7625ULL, 0x000fe200078e000dULL, 0x000000080e087210ULL, 0x000fc8000791e017ULL,
0x0000000a0e0a7210ULL, 0x000fe40007b5e017ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608087981ULL, 0x000368000c1e1900ULL,
0x000000060a0f7981ULL, 0x000362000c1e1900ULL, 0x000000022900780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002040a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a097981ULL, 0x000362000c1e1900ULL,
0x000000042900780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003040a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000042900780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004040a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000062900780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005040a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000062900780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082900780cULL, 0x002fe40003f06070ULL,
0x00000006040a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fe40007a3e017ULL, 0x00000007040c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000c0c0625ULL, 0x000fca00078e000dULL,
0x0000000c0e0c0210ULL, 0x000fe40007c7e017ULL, 0x000000060a177981ULL, 0x000364000c1e1900ULL,
0x0000000dff0d0210ULL, 0x000fcc0001fe84ffULL, 0x000000060c0d0981ULL, 0x000366000c1e1900ULL,
0x00000007290a7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0c7819ULL, 0x004fc8000001160aULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e0008ULL,
0x00000008190e7824ULL, 0x040fe200078e00ffULL, 0x0000000119197810ULL, 0x000fc80007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x0000000c1900720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080e0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000010e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001b08087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x00000070101b7812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e01bULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000020e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000000f08087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0f7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000030e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000908087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003097824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e009ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a097981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000040e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001108087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000050e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000060e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001508087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010157812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000070e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001708087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010177812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e0b7810ULL, 0x002fe40007ffe0ffULL, 0x0000000d08087209ULL, 0x000fe40007810000ULL,
0x000003000b007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007a3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a0d7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003097824ULL, 0x024fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x002fc80000011603ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL,
0x0000000109097824ULL, 0x000fca00078e020aULL, 0x0000000809007388ULL, 0x0003e40000000800ULL,
0x00000004050a7211ULL, 0x002fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x00000010030c7824ULL, 0x044fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x00000015ff097819ULL, 0x000fe2000001161aULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000700c0d7812ULL, 0x000fe200078ec0ffULL,
0x000008001a087824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000020030f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000080a0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010d147824ULL, 0x000fe200078e020eULL, 0x0000004003137810ULL, 0x040fe20007ffe0ffULL,
0x0000000104108824ULL, 0x000fe200078e0207ULL, 0x0000006003197810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000010b0d7824ULL, 0x000fe200008e0609ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff1f8424ULL, 0x000fe200078e00ffULL, 0x00000000140b7984ULL, 0x0002a20000000800ULL,
0x000010001a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00006c0010108625ULL, 0x000fe200078e0011ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x000000100f0e7825ULL, 0x000fc800078e000cULL,
0x0000001013127825ULL, 0x000fc800078e000cULL, 0x0000001019187825ULL, 0x000fc800078e000cULL,
0x000000101a178824ULL, 0x000fe400078e0203ULL, 0x00006c00041e8625ULL, 0x000fc600078e001fULL,
0x0000458017178811ULL, 0x000fe200078e20ffULL, 0x0000001003157824ULL, 0x040fe400078e020aULL,
0x00000010030c7825ULL, 0x000fc800078e000cULL, 0x000000101a1b8824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c157faeULL, 0x0007e2000b901c46ULL,
0x00000010031c8825ULL, 0x000fe400078e0010ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x000041801b1b8811ULL, 0x000fe200078e20ffULL, 0x00000010031e8825ULL, 0x000fe200078e001eULL,
0x003800000e157faeULL, 0x0009e8000b901c46ULL, 0x0058000012157faeULL, 0x000be2000b901c46ULL,
0x00000000000c7805ULL, 0x008fc6000001ff00ULL, 0x0078000018157faeULL, 0x0003e8000b901c46ULL,
0x000000001c178faeULL, 0x0007e2000b901c46ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x000000001e1b8faeULL, 0x0009e2000b901c46ULL, 0x0000000000127805ULL, 0x020fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000147805ULL, 0x002fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x008fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1b7224ULL, 0x010fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000d6000009947ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x004fe400078e00ffULL, 0x000000ffff2e7224ULL, 0x000fca00078e00ffULL,
0x000000012e2f7810ULL, 0x000fc80007ffe0ffULL, 0x000003002f007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x00000001043c7824ULL, 0x000fe200078e022fULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x00002000ff317424ULL, 0x000fe200078e00ffULL,
0x000000012f357812ULL, 0x040fe200078ec0ffULL, 0x000008002f327824ULL, 0x000fe200078e00ffULL,
0x0000003c05307211ULL, 0x000fe400078f98ffULL, 0x0000002003377810ULL, 0x040fe40007ffe0ffULL,
0x0000080032337812ULL, 0x000fe200078ec0ffULL, 0x00006c0030307625ULL, 0x000fe200078e0031ULL,
0x00000040033b7810ULL, 0x000fc40007ffe0ffULL, 0x00000060033f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a327824ULL, 0x000fe200078e0233ULL, 0x0000000830307210ULL, 0x000fe20007f1e0ffULL,
0x0000000107389824ULL, 0x000fe400078e023cULL, 0x00000080ff399424ULL, 0x000fe400078e00ffULL,
0x0000000131317824ULL, 0x000fe400000e0609ULL, 0x000000021a3a9824ULL, 0x140fe400078e0235ULL,
0x000000021a3e9824ULL, 0x000fc400078e0235ULL, 0x00000080ff419424ULL, 0x000fe400078e00ffULL,
0x00000010033d7824ULL, 0x000fe400078e0232ULL, 0x0000001037347825ULL, 0x000fc800078e0030ULL,
0x000000103b367825ULL, 0x000fc800078e0030ULL, 0x0000001003327825ULL, 0x000fc800078e0030ULL,
0x000000103f307825ULL, 0x000fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000323d7faeULL, 0x0003e6000b901c46ULL, 0x00006c0038389625ULL, 0x000fe200078e0039ULL,
0x00380000343d7faeULL, 0x0003e6000b901c46ULL, 0x000000083a3f9824ULL, 0x000fe200078e0203ULL,
0x00580000363d7faeULL, 0x0003e2000b901c46ULL, 0x00006c003c3a9625ULL, 0x000fc600078e0041ULL,
0x000045803f3f9811ULL, 0x000fe200078e20ffULL, 0x000000083e3e9824ULL, 0x000fe200078e0203ULL,
0x00780000303d7faeULL, 0x0003e2000b901c46ULL, 0x0000001003389825ULL, 0x000fc600078e0038ULL,
0x000041803e419811ULL, 0x000fe200078e20ffULL, 0x00000010033a9825ULL, 0x000fe200078e003aULL,
0x00000000383f9faeULL, 0x0003e8000b901c46ULL, 0x000000003a419faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff337224ULL, 0x002fe200078e002eULL,
0x00000001ff327819ULL, 0x100fe20000011603ULL, 0x0000001003307824ULL, 0x000fe200078e00ffULL,
0x00000002ff397819ULL, 0x000fe20000011603ULL, 0x00000080332e7824ULL, 0x000fe200078e00ffULL,
0x0000000c32327812ULL, 0x000fc400078ec0ffULL, 0x0000007030307812ULL, 0x000fe200078ec0ffULL,
0x0000000839377824ULL, 0x040fe200078e00ffULL, 0x000000802e317812ULL, 0x000fe200078ec0ffULL,
0x00000008392e7824ULL, 0x040fe200078e00ffULL, 0x00000008393b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000739357812ULL, 0x000fe200078ec0ffULL, 0x000001001a317824ULL, 0x000fe200078e0231ULL,
0x0000003bff4c7212ULL, 0x000fe200078e33ffULL, 0x000000083b3d7824ULL, 0x000fe200078e00ffULL,
0x00000039ff407212ULL, 0x000fc400078e33ffULL, 0x0000003132317210ULL, 0x000fe20007ffe030ULL,
0x0000000839307824ULL, 0x000fe200078e00ffULL, 0xfffffff837407812ULL, 0x000fe200078ee240ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800031327984ULL, 0x000e620000000800ULL,
0x0000000130347812ULL, 0x140fe400078ef635ULL, 0x0000000230367812ULL, 0x140fe200078ef635ULL,
0x00458000314e7984ULL, 0x0004e20000000800ULL, 0x0000000330387812ULL, 0x140fe400078ef635ULL,
0x00000004303a7812ULL, 0x140fe400078ef635ULL, 0x00000005303c7812ULL, 0x140fe400078ef635ULL,
0x00000006303e7812ULL, 0x100fe200078ef635ULL, 0x000000083b317824ULL, 0x004fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee235ULL, 0x0000080033307824ULL, 0x000fc400078e00ffULL,
0x000000083b357824ULL, 0x000fe200078e00ffULL, 0xfffffff8314c7812ULL, 0x000fe400078ee24cULL,
0x0000080030317812ULL, 0x000fe400078ec0ffULL, 0x000000073b307812ULL, 0x000fe400078ec0ffULL,
0x000001800a317810ULL, 0x000fe40007ffe031ULL, 0x0000000135427812ULL, 0x140fe400078ef630ULL,
0x0000000235447812ULL, 0x140fe200078ef630ULL, 0x000000102e2e7824ULL, 0x100fe200078e0231ULL,
0x0000000335467812ULL, 0x140fe200078ef630ULL, 0x0000001040407824ULL, 0x100fe200078e0231ULL,
0x0000000435487812ULL, 0x140fe200078ef630ULL, 0x0000001036367824ULL, 0x100fe200078e0231ULL,
0x00000005354a7812ULL, 0x000fe200078ef630ULL, 0x0000001038387824ULL, 0x000fc400078e0231ULL,
0x000000103a3a7824ULL, 0x100fe400078e0231ULL, 0x000000103c3c7824ULL, 0x100fe200078e0231ULL,
0x000000320b327221ULL, 0x002fe20000010100ULL, 0x000000103e3e7824ULL, 0x100fe400078e0231ULL,
0x0000001034347824ULL, 0x100fe200078e0231ULL, 0x3fb8aa3b32377820ULL, 0x000fe20000410000ULL,
0x0000000403327824ULL, 0x000fe400078e00ffULL, 0x0000001042427824ULL, 0x000fc400078e0231ULL,
0x0000001044447824ULL, 0x100fe200078e0231ULL, 0x0000000c32337812ULL, 0x000fe200078ec0ffULL,
0x0000003700377308ULL, 0x000ee20000000800ULL, 0xfffffff83d327812ULL, 0x100fe200078ee230ULL,
0x0000001046467824ULL, 0x000fe200078e0231ULL, 0x0000000635307812ULL, 0x000fe200078ef630ULL,
0x000000012e2e7824ULL, 0x000fe400078e0233ULL, 0x0000000133407824ULL, 0x040fe400078e0240ULL,
0x0000000133367824ULL, 0x000fc400078e0236ULL, 0x000000002e2e7984ULL, 0x000e620000000800ULL,
0x0000000133387824ULL, 0x040fe400078e0238ULL, 0x00000001333a7824ULL, 0x040fe200078e023aULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x00000001333c7824ULL, 0x000fe200078e023cULL,
0x0000004e374e7220ULL, 0x008fe20000410000ULL, 0x00000001333e7824ULL, 0x040fe200078e023eULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x0000001032327824ULL, 0x000fe200078e0231ULL,
0x0000002d4e2d7221ULL, 0x000fe20000010000ULL, 0x0000001048487824ULL, 0x000fe200078e0231ULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x0000000133327824ULL, 0x000fc400078e0232ULL,
0x000000104a4a7824ULL, 0x100fe200078e0231ULL, 0x00001f394e357589ULL, 0x000ea200000e0000ULL,
0x0000001030307824ULL, 0x100fe400078e0231ULL, 0x000000104c4c7824ULL, 0x000fe200078e0231ULL,
0x000000003a3a7984ULL, 0x000ee20000000800ULL, 0x0000000133427824ULL, 0x040fe400078e0242ULL,
0x0000000133347824ULL, 0x040fe200078e0234ULL, 0x000000003c3c7984ULL, 0x000f220000000800ULL,
0x0000000133447824ULL, 0x000fc400078e0244ULL, 0x0000000133467824ULL, 0x040fe200078e0246ULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x0000000133487824ULL, 0x040fe400078e0248ULL,
0x00000001334a7824ULL, 0x040fe200078e024aULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x0000000133307824ULL, 0x040fe400078e0230ULL, 0x00000001334c7824ULL, 0x000fe200078e024cULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x00005410ff317816ULL, 0x002fc6000000002eULL,
0x0000000034347984ULL, 0x000e640000000800ULL, 0x0000003531287223ULL, 0x004fe20000010028ULL,
0x00007610ff317816ULL, 0x000fe2000000002eULL, 0x0000000044447984ULL, 0x000fe20000000800ULL,
0x00005410ff2e7816ULL, 0x000fc60000000040ULL, 0x00001f3b4e4e7589ULL, 0x000ea200000e0000ULL,
0x0000003531227223ULL, 0x080fe20000010022ULL, 0x000000352e297223ULL, 0x000fe20000010029ULL,
0x00007610ff2e7816ULL, 0x000fe20000000036ULL, 0x0000000046467984ULL, 0x000ea20000000800ULL,
0x00007610ff317816ULL, 0x000fc60000000040ULL, 0x000000352e0f7223ULL, 0x080fe2000001000fULL,
0x00005410ff2e7816ULL, 0x000fe20000000038ULL, 0x0000000048487984ULL, 0x000ea20000000800ULL,
0x0000003531167223ULL, 0x000fc60000010016ULL, 0x000000352e217223ULL, 0x080fe20000010021ULL,
0x00005410ff2e7816ULL, 0x008fe2000000003aULL, 0x000000004a4a7984ULL, 0x000ee80000000800ULL,
0x000000352e1d7223ULL, 0x080fe2000001001dULL, 0x00005410ff2e7816ULL, 0x010fe2000000003cULL,
0x0000000030307984ULL, 0x000f280000000800ULL, 0x000000352e197223ULL, 0x000fe20000010019ULL,
0x00005410ff2e7816ULL, 0x020fe2000000003eULL, 0x000000004c4c7984ULL, 0x000f620000000800ULL,
0x00005410ff317816ULL, 0x002fc60000000034ULL, 0x000000352e157223ULL, 0x080fe20000010015ULL,
0x00005410ff2e7816ULL, 0x000fe20000000032ULL, 0x00000035311c7223ULL, 0x000fe2000001001cULL,
0x00007610ff317816ULL, 0x000fc60000000034ULL, 0x0000004e2e137223ULL, 0x004fe20000010013ULL,
0x00005410ff2e7816ULL, 0x000fe20000000042ULL, 0x00000035312a7223ULL, 0x000fe2000001002aULL,
0x00005410ff317816ULL, 0x000fc60000000036ULL, 0x0000004e2e277223ULL, 0x000fe20000010027ULL,
0x00005410ff2e7816ULL, 0x000fe20000000044ULL, 0x0000003531187223ULL, 0x000fe20000010018ULL,
0x00007610ff317816ULL, 0x000fc60000000038ULL, 0x0000004e2e237223ULL, 0x000fe20000010023ULL,
0x00007610ff2e7816ULL, 0x000fe20000000044ULL, 0x0000003531107223ULL, 0x000fe20000010010ULL,
0x00007610ff317816ULL, 0x000fc6000000003aULL, 0x0000004e2e2b7223ULL, 0x000fe2000001002bULL,
0x00005410ff2e7816ULL, 0x000fe20000000046ULL, 0x00000035310e7223ULL, 0x000fe2000001000eULL,
0x00007610ff317816ULL, 0x000fc6000000003cULL, 0x0000004e2e1f7223ULL, 0x000fe2000001001fULL,
0x00007610ff2e7816ULL, 0x000fe20000000046ULL, 0x0000003531207223ULL, 0x000fe20000010020ULL,
0x00007610ff317816ULL, 0x000fc6000000003eULL, 0x0000004e2e257223ULL, 0x000fe20000010025ULL,
0x00005410ff2e7816ULL, 0x000fe20000000048ULL, 0x00000035312c7223ULL, 0x000fe2000001002cULL,
0x00007610ff317816ULL, 0x000fc60000000032ULL, 0x0000004e2e1b7223ULL, 0x080fe2000001001bULL,
0x00005410ff2e7816ULL, 0x008fe2000000004aULL, 0x0000004e31247223ULL, 0x000fe20000010024ULL,
0x00007610ff317816ULL, 0x000fc60000000042ULL, 0x0000004e2e177223ULL, 0x080fe20000010017ULL,
0x000000ffff2e7224ULL, 0x000fe200078e002fULL, 0x00007610ff2f7816ULL, 0x000fe2000000004aULL,
0x0000004e311e7223ULL, 0x080fe2000001001eULL, 0x00007610ff317816ULL, 0x000fe40000000048ULL,
0x000003002e007a0cULL, 0x000fe20003f06070ULL, 0x0000004e2f267223ULL, 0x080fe20000010026ULL,
0x00005410ff2f7816ULL, 0x010fe20000000030ULL, 0x0000004e31127223ULL, 0x000fe20000010012ULL,
0x00007610ff307816ULL, 0x000fc60000000030ULL, 0x0000004e2f147223ULL, 0x080fe20000010014ULL,
0x00007610ff2f7816ULL, 0x120fe2000000004cULL, 0x0000004e300d7223ULL, 0x000fe2000001000dULL,
0x00005410ff307816ULL, 0x000fc6000000004cULL, 0x0000004e2f0c7223ULL, 0x080fe4000001000cULL,
0x0000004e30117223ULL, 0x000fe20000010011ULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x018000002d037810ULL, 0x004fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000003037812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e002dULL, 0x0001355000047802ULL, 0x000fe40000000f00ULL,
0x0000638000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002d00047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc8000000002dULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000001a7919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000081a2d7811ULL, 0x010fe400078ff0ffULL,
0x00000002ff2e7819ULL, 0x000fe4000001161aULL, 0x0000002dff2f7212ULL, 0x000fe200078e33ffULL,
0x00001f2d03047589ULL, 0x00cea800000e0000ULL, 0x00001f2e03057589ULL, 0x00072400000e0000ULL,
0x0000002eff037212ULL, 0x008fe200078e33ffULL, 0x0000001304137220ULL, 0x044fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002b04087220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x00000025040a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000000d040d7220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000002805287220ULL, 0x050fe20000410000ULL, 0x0000002205077220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000002a05097220ULL, 0x042fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000000f050f7220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000000e050e7220ULL, 0x040fe20000410000ULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002905297220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x000fe20000410000ULL,
0x0000000c04047220ULL, 0x000fe20000410000ULL, 0x000000072e057812ULL, 0x040fe200078ec0ffULL,
0x000000082e227824ULL, 0x000fe200078e00ffULL, 0x0000001b1212723eULL, 0x000fe200000010ffULL,
0x000000082d0c7824ULL, 0x040fe200078e00ffULL, 0x000000110404723eULL, 0x000fe200000010ffULL,
0x000000082d2a7824ULL, 0x000fe200078e00ffULL, 0x00000001050b7812ULL, 0x000fc400078e3cffULL,
0x0000000205117812ULL, 0x040fe400078e3cffULL, 0x0000001d0e0e723eULL, 0x000fe400000010ffULL,
0x00000003051b7812ULL, 0x040fe400078e3cffULL, 0x000000211010723eULL, 0x000fe400000010ffULL,
0x0000001f0a0a723eULL, 0x000fe400000010ffULL, 0x00000004051d7812ULL, 0x000fc400078e3cffULL,
0x00000005051f7812ULL, 0x040fe400078e3cffULL, 0x0000000605217812ULL, 0x000fe200078e3cffULL,
0x000000082e057824ULL, 0x000fe200078e020bULL, 0xfffffff822317812ULL, 0x000fe200078ee203ULL,
0x000000082e0b7824ULL, 0x000fe200078e0211ULL, 0x000000192019723eULL, 0x000fe200000010ffULL,
0x000000082e117824ULL, 0x040fe200078e021bULL, 0x000000072d207812ULL, 0x000fe200078ec0ffULL,
0x000000082e037824ULL, 0x040fe200078e00ffULL, 0x0000001c0909723eULL, 0x000fe200000010ffULL,
0x000000082e1b7824ULL, 0x040fe200078e021dULL, 0x000000180f0f723eULL, 0x000fe200000010ffULL,
0x000000082e1d7824ULL, 0x040fe200078e021fULL, 0x000000140d0d723eULL, 0x000fe200000010ffULL,
0x000000082e1f7824ULL, 0x000fe200078e0221ULL, 0xfffffff80c217812ULL, 0x000fe200078ee22dULL,
0x000000041a227824ULL, 0x000fe200078e00ffULL, 0x00000001200c7812ULL, 0x040fe200078e3cffULL,
0x0000001005057824ULL, 0x100fe200078e0202ULL, 0x0000000220147812ULL, 0x040fe200078e3cffULL,
0x000000100b0b7824ULL, 0x100fe200078e0202ULL, 0x0000000320187812ULL, 0x040fe200078e3cffULL,
0x0000001011117824ULL, 0x000fe200078e0202ULL, 0x00000004201a7812ULL, 0x040fe200078e3cffULL,
0x000000082d257824ULL, 0x000fe200078e0214ULL, 0x00000005201c7812ULL, 0x040fe200078e3cffULL,
0x0000001031147824ULL, 0x000fe200078e0202ULL, 0xfffffff803037812ULL, 0x000fe200078ee22eULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x0000000620207812ULL, 0x000fe200078e3cffULL,
0x000000082d2b7824ULL, 0x040fe200078e021cULL, 0x000000291616723eULL, 0x000fe200000010ffULL,
0x000000082d297824ULL, 0x040fe200078e021aULL, 0x000000271e1e723eULL, 0x000fe200000010ffULL,
0x000000082d277824ULL, 0x040fe200078e0218ULL, 0x000000230808723eULL, 0x000fe200000010ffULL,
0x000000082d237824ULL, 0x040fe200078e020cULL, 0xfffffff82a2f7812ULL, 0x000fe200078ee22fULL,
0x000000082d2d7824ULL, 0x000fe200078e0220ULL, 0x0000000c22227812ULL, 0x000fe200078ec0ffULL,
0x0000001003037824ULL, 0x100fe200078e0202ULL, 0x000000280707723eULL, 0x000fe200000010ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0202ULL, 0x000000152c15723eULL, 0x000fe200000010ffULL,
0x00000001220c7824ULL, 0x000fe200078e0203ULL, 0x000000132413723eULL, 0x000fe200000010ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x000000172617723eULL, 0x000fe200000010ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0202ULL, 0x000000070c007388ULL, 0x0003e20000000800ULL,
0x000000101f1f7824ULL, 0x000fc400078e0202ULL, 0x0000001023237824ULL, 0x100fe400078e0202ULL,
0x0000001025257824ULL, 0x100fe400078e0202ULL, 0x0000001027277824ULL, 0x100fe400078e0202ULL,
0x0000001029297824ULL, 0x100fe400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe400078e0202ULL,
0x000000102d2d7824ULL, 0x000fc400078e0202ULL, 0x0000000122037824ULL, 0x040fe400078e0214ULL,
0x0000000122027824ULL, 0x040fe400078e0205ULL, 0x0000000122147824ULL, 0x040fe400078e020bULL,
0x0000000122117824ULL, 0x040fe200078e0211ULL, 0x0000000902007388ULL, 0x0005e20000000800ULL,
0x00000001221b7824ULL, 0x040fe400078e021bULL, 0x0000000122187824ULL, 0x040fe200078e021dULL,
0x0000000f14007388ULL, 0x0005e20000000800ULL, 0x00000001221a7824ULL, 0x000fc400078e021fULL,
0x00000001221c7824ULL, 0x040fe200078e0221ULL, 0x0000001011007388ULL, 0x0005e20000000800ULL,
0x0000000122237824ULL, 0x040fe400078e0223ULL, 0x0000000122257824ULL, 0x040fe200078e0225ULL,
0x0000000e1b007388ULL, 0x0005e20000000800ULL, 0x0000000122277824ULL, 0x040fe400078e0227ULL,
0x0000000122297824ULL, 0x040fe200078e0229ULL, 0x0000001918007388ULL, 0x0005e20000000800ULL,
0x00000001220c7824ULL, 0x002fc400078e022bULL, 0x0000000122207824ULL, 0x040fe200078e022dULL,
0x000000151a007388ULL, 0x0005e20000000800ULL, 0x00000001222f7824ULL, 0x000fc600078e022fULL,
0x0000001603007388ULL, 0x0005e80000000800ULL, 0x000000131c007388ULL, 0x0005e80000000800ULL,
0x0000001e23007388ULL, 0x0005e80000000800ULL, 0x0000000825007388ULL, 0x0005e80000000800ULL,
0x0000000a27007388ULL, 0x0005e80000000800ULL, 0x0000001229007388ULL, 0x0005e80000000800ULL,
0x000000170c007388ULL, 0x0005e80000000800ULL, 0x0000000d20007388ULL, 0x0005e80000000800ULL,
0x000000042f007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000001a7919ULL, 0x004ea20000002600ULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000580000057ab9ULL, 0x000fc40000000800ULL, 0x00000000001b7919ULL, 0x000f220000000000ULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x000000101a037824ULL, 0x004fc600078e00ffULL,
0x00000004050472a4ULL, 0x008fe2000f8e023fULL, 0x000000101a187824ULL, 0x000fe200078e00ffULL,
0x00000003ff027819ULL, 0x010fe4000001161bULL, 0x000000201b1c7810ULL, 0x040fe40007ffe0ffULL,
0x000000401b1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000601b1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff003047812ULL, 0x002fc400078ee202ULL, 0x00000003ff037819ULL, 0x000fe4000001161cULL,
0x00000003ff077819ULL, 0x000fe4000001161dULL, 0x00000003ff197819ULL, 0x000fe4000001161eULL,
0x0000000702027812ULL, 0x000fe400078e481bULL, 0x0000000703057812ULL, 0x000fe400078e481cULL,
0x0000000707087812ULL, 0x000fc400078e481dULL, 0xfffffff018187812ULL, 0x000fe400078ee203ULL,
0x00000007190a7812ULL, 0x000fe400078e481eULL, 0x0ffffff802037812ULL, 0x000fe400078ef81bULL,
0x0ffffff805057812ULL, 0x000fe400078ef81cULL, 0x0ffffff808097812ULL, 0x000fe200078ef81dULL,
0x0000001003087824ULL, 0x000fe200078e0200ULL, 0x0ffffff80a0b7812ULL, 0x000fe200078ef81eULL,
0x0000001005057824ULL, 0x100fe200078e0200ULL, 0x0000000404037c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001009107824ULL, 0x000fc400078e0200ULL, 0x000000100b147824ULL, 0x000fe200078e0200ULL,
0x00a00000050c7984ULL, 0x0003e20000000c00ULL, 0x000000101a047824ULL, 0x040fe400078e00ffULL,
0x000000101a007824ULL, 0x000fe200078e00ffULL, 0x00a0000008087984ULL, 0x000ea20000000c00ULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fe400078048ffULL,
0x00a0000010107984ULL, 0x000ee20000000c00ULL, 0xfffffff004047812ULL, 0x000fc400078ee219ULL,
0x000000071c057812ULL, 0x002fe200078ec0ffULL, 0x00a0000014147984ULL, 0x000e620000000c00ULL,
0x000000071d197812ULL, 0x000fe400078ec0ffULL, 0xfffffff000007812ULL, 0x000fe400078ee207ULL,
0x00005b0003037a11ULL, 0x000fe400000f4c1aULL, 0x1ffffff8051d7812ULL, 0x000fe400078ef806ULL,
0x0000000418057c10ULL, 0x000fc4000ff1e0ffULL, 0x1ffffff8191f7812ULL, 0x000fe400078ef806ULL,
0x0000000400197c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000404007c10ULL, 0x000fe4000ff5e0ffULL,
0x000000071b077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x000000071e1b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x00005a0019187a11ULL, 0x000fc400078248ffULL, 0x00005a00001a7a11ULL, 0x040fe400078448ffULL,
0x1ffffff807077812ULL, 0x000fe400078ef806ULL, 0x00005b0005057a11ULL, 0x000fe400000f4c1eULL,
0x1ffffff81b217812ULL, 0x000fe200078ef806ULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x00005b0019197a11ULL, 0x000fe400008f4c1cULL, 0x00005b00001b7a11ULL, 0x000fe200010f4c23ULL,
0x000000101d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x004fe6000c101d06ULL,
0x000000101f067825ULL, 0x000fe200078e0018ULL, 0x0000000c04007986ULL, 0x000fe6000c101d06ULL,
0x0000001021187825ULL, 0x000fe200078e001aULL, 0x0000001006007986ULL, 0x008fe8000c101d06ULL,
0x0000001418007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff347624ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe2000001161aULL,
0x00006900ff357624ULL, 0x000fc400078e00ffULL, 0xffffffffff187424ULL, 0x000fe200078e00ffULL,
0x01ffffff03047812ULL, 0x000fe400078ec0ffULL, 0x0000000634347981ULL, 0x000366000c1e9900ULL,
0x000000021b317824ULL, 0x000fca00078e0204ULL, 0x000000003100720cULL, 0x000fe40003f06070ULL,
0x000000011b037810ULL, 0x000fd60007ffe0ffULL, 0x000000020a048824ULL, 0x000fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e0231ULL, 0x0000600004048625ULL, 0x000fca00078e0017ULL,
0x0000000604188981ULL, 0x000362000c1e1900ULL, 0x000000020300720cULL, 0x000fe20003f06070ULL,
0x000000401a307824ULL, 0x000fe400078e00ffULL, 0x0000008032327824ULL, 0x000fe400078e00ffULL,
0x000001001b0e7824ULL, 0x000fe200078e0230ULL, 0x0000000704047899ULL, 0x000fc8000800063fULL,
0x00000040320b7812ULL, 0x000fc600078ef80eULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x002e620000000000ULL, 0x00000004180b7c24ULL, 0x020fe2000f8e020bULL,
0x0000000e19037217ULL, 0x000fe20007800000ULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x000020001a157811ULL, 0x000fc600078e68ffULL, 0x0000000103037824ULL, 0x000fe200078e0a0eULL,
0x00000002ff207819ULL, 0x102fe20000011611ULL, 0x00000010111d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff147819ULL, 0x000fe40000011611ULL, 0x0000007f20047812ULL, 0x040fe400078ec0ffULL,
0x0000000820127810ULL, 0x000fe40007ffe0ffULL, 0x000000301d1d7812ULL, 0x000fe200078ec0ffULL,
0x000000010b047824ULL, 0x000fe200078e0204ULL, 0x0000007f12067812ULL, 0x040fe200078ec0ffULL,
0x0000000412137824ULL, 0x000fe200078e00ffULL, 0x0000001020227810ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001fULL, 0x0000001820247810ULL, 0x000fc40007ffe0ffULL,
0x0000007f22087812ULL, 0x000fe200078ec0ffULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0x0000001d040c7210ULL, 0x000fe40007f1e0ffULL, 0x0000007f24047812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e001fULL, 0x0000002020167810ULL, 0x000fe40007ffe0ffULL,
0x0000000314147812ULL, 0x000fe200078e4811ULL, 0x000000010b087824ULL, 0x040fe200078e0208ULL,
0x00000028201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x0000001d060e7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b047824ULL, 0x000fe200078e0204ULL,
0x0000007f16067812ULL, 0x000fe200078ec0ffULL, 0x00005e0008087625ULL, 0x000fe200078e001fULL,
0x000000032200720cULL, 0x000fc40003fa6070ULL, 0x000000032400720cULL, 0x000fe20003f86070ULL,
0x00005e0004047625ULL, 0x000fe200078e001fULL, 0x0000001d08087210ULL, 0x000fc60007f3e0ffULL,
0x000000010b067824ULL, 0x000fe200078e0206ULL, 0x0000001d04107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x0ffffffc14047812ULL, 0x000fe200078ef811ULL,
0x00005e0006067625ULL, 0x000fe200078e001fULL, 0x000000032000720cULL, 0x000fc60003f06070ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000031200720cULL, 0x000fe20003f26070ULL,
0x0000001004177824ULL, 0x000fe200078e0215ULL, 0x0000001d06127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0605ULL, 0x0000007f1c047812ULL, 0x000fe400078ec0ffULL,
0xfffffffc13067812ULL, 0x000fe200078ee214ULL, 0x000000ffff137224ULL, 0x000fe200018e0607ULL,
0x000000031600720cULL, 0x000fe20003f66070ULL, 0x000000010b047824ULL, 0x000fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c177faeULL, 0x0003e2000c101c46ULL,
0x0000001006077824ULL, 0x000fe200078e0215ULL, 0x0000003020067810ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001fULL, 0x0000003820207810ULL, 0x000fc40007ffe0ffULL,
0x0000007f061e7812ULL, 0x000fe200078ec0ffULL, 0x000000000e077faeULL, 0x0005e2000c901c46ULL,
0x000000031c00720cULL, 0x080fe20003f46070ULL, 0x0000000406217824ULL, 0x040fe200078e00ffULL,
0x000000030600720cULL, 0x000fe20003f26070ULL, 0x0000000420237824ULL, 0x000fe200078e00ffULL,
0x0000001d040c7210ULL, 0x002fe20007fde0ffULL, 0x000000010b047824ULL, 0x000fe200078e021eULL,
0x000000032000720cULL, 0x000fe20003f06070ULL, 0x0000000422037824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e0605ULL, 0x0000007f200e7812ULL, 0x004fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001fULL, 0xfffffffc21207812ULL, 0x000fc600078ee214ULL,
0x000000010b077824ULL, 0x000fe200078e020eULL, 0x0000001d04047210ULL, 0x000fe20007fde0ffULL,
0x00000004240b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc030e7812ULL, 0x100fe200078ee214ULL,
0x00000004160f7824ULL, 0x000fe400078e00ffULL, 0x000000041c177824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b167812ULL, 0x100fe200078ee214ULL, 0x00005e0007067625ULL, 0x000fe200078e001fULL,
0xfffffffc0f1c7812ULL, 0x100fe400078ee214ULL, 0xfffffffc171e7812ULL, 0x100fe200078ee214ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0xfffffffc23147812ULL, 0x000fe200078ee214ULL,
0x000000100e037824ULL, 0x100fe200078e0215ULL, 0x0000001d06067210ULL, 0x000fe20007fde0ffULL,
0x00000010160b7824ULL, 0x000fc400078e0215ULL, 0x000000101c0f7824ULL, 0x100fe200078e0215ULL,
0x0000000008037faeULL, 0x0003e2000e901c46ULL, 0x000000101e177824ULL, 0x100fe400078e0215ULL,
0x00000010201d7824ULL, 0x100fe200078e0215ULL, 0x00000000100b7faeULL, 0x0003e2000e101c46ULL,
0x0000001014157824ULL, 0x000fe400078e0215ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x00000000120f7faeULL, 0x0003e8000d901c46ULL, 0x000000000c177faeULL, 0x0003e8000d101c46ULL,
0x00000000041d7faeULL, 0x0003e8000c901c46ULL, 0x0000000006157faeULL, 0x0003e2000c101c46ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x00000004180b7c24ULL, 0x020fc4000f8e020bULL, 0x00000100ff157424ULL, 0x000fe200078e00ffULL,
0x00000002ff047819ULL, 0x102fe20000011603ULL, 0x0000001003057824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fe40000011603ULL, 0x0000007f04087812ULL, 0x040fe400078ec0ffULL,
0x0000000804097810ULL, 0x040fe40007ffe0ffULL, 0x00000010040d7810ULL, 0x040fe40007ffe0ffULL,
0x00000018040f7810ULL, 0x000fc40007ffe0ffULL, 0x0000002004117810ULL, 0x040fe40007ffe0ffULL,
0x0000002804137810ULL, 0x040fe40007ffe0ffULL, 0x0000003004167810ULL, 0x040fe40007ffe0ffULL,
0x0000003804177810ULL, 0x000fe20007ffe0ffULL, 0x000000010b047824ULL, 0x000fe200078e0208ULL,
0x0000007f09087812ULL, 0x040fe200078ec0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x0000007f0d0c7812ULL, 0x040fe200078ec0ffULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0x0000007f0f107812ULL, 0x040fe200078ec0ffULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x0000007f11127812ULL, 0x040fe200078ec0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x0000007f13147812ULL, 0x040fe200078ec0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0000000306067812ULL, 0x100fe200078e4803ULL, 0x0000000416257824ULL, 0x040fe200078e00ffULL,
0x0000007f161c7812ULL, 0x000fe200078ec0ffULL, 0x0000000417277824ULL, 0x000fe200078e00ffULL,
0x0ffffffc06077812ULL, 0x000fe200078ef803ULL, 0x000000010b0e7824ULL, 0x000fe200078e020cULL,
0x0000007f171e7812ULL, 0x000fe200078ec0ffULL, 0x000000010b107824ULL, 0x000fe200078e0210ULL,
0x0000003005037812ULL, 0x000fe200078ec0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0015ULL,
0x000020001a0c7811ULL, 0x000fc400078e68ffULL, 0xfffffffc09097812ULL, 0x000fe200078ee206ULL,
0x000000010b087824ULL, 0x000fe200078e0208ULL, 0xfffffffc0d0d7812ULL, 0x000fe200078ee206ULL,
0x000000010b127824ULL, 0x000fe200078e0212ULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee206ULL,
0x000000010b147824ULL, 0x000fe200078e0214ULL, 0xfffffffc11117812ULL, 0x000fe200078ee206ULL,
0x000000010b1c7824ULL, 0x000fe200078e021cULL, 0xfffffffc13137812ULL, 0x000fe200078ee206ULL,
0x000000010b1e7824ULL, 0x000fe200078e021eULL, 0xfffffffc25257812ULL, 0x000fe200078ee206ULL,
0x00000010070b7824ULL, 0x000fe200078e020cULL, 0xfffffffc27277812ULL, 0x000fe200078ee206ULL,
0x0000001009177824ULL, 0x100fe200078e020cULL, 0x0000000304047210ULL, 0x000fe20007f1e0ffULL,
0x000000100d1d7824ULL, 0x000fc400078e020cULL, 0x000000100f1f7824ULL, 0x100fe400078e020cULL,
0x0000001011217824ULL, 0x100fe400078e020cULL, 0x0000001013237824ULL, 0x100fe400078e020cULL,
0x0000001025257824ULL, 0x100fe400078e020cULL, 0x0000001027277824ULL, 0x000fe400078e020cULL,
0x00005e00100c7625ULL, 0x000fc800078e0015ULL, 0x00005e0008067625ULL, 0x000fc800078e0015ULL,
0x00005e000e087625ULL, 0x000fe200078e0015ULL, 0x0000000306067210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000030c0c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e00120e7625ULL, 0x000fe200078e0015ULL, 0x0000000308087210ULL, 0x000fe40007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000b901c46ULL,
0x00005e0014107625ULL, 0x000fc800078e0015ULL, 0x00005e001c127625ULL, 0x000fc800078e0015ULL,
0x00005e001e147625ULL, 0x000fc800078e0015ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x000000030e0e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000310107210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000000312127210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000000314147210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000000006177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400010e0613ULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x00000000081d7faeULL, 0x0003e8000b901c46ULL,
0x000000000c1f7faeULL, 0x0003e8000b901c46ULL, 0x000000000e217faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e8000b901c46ULL, 0x0000000012257faeULL, 0x0003e8000b901c46ULL,
0x0000000014277faeULL, 0x0003e4000b901c46ULL, 0x01060400ff037984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000003ff7812ULL, 0x002fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0002a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000031a00780cULL, 0x000fda0003f04070ULL, 0x0000028000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x000000201a037824ULL, 0x002fc800078e0203ULL,
0x0000002003057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x000001e005057812ULL, 0x000fe400078ec0ffULL,
0x0000000104087812ULL, 0x040fe400078efcffULL, 0x0000000704067812ULL, 0x100fe400078e7803ULL,
0x0000000708087812ULL, 0x100fe400078e7803ULL, 0x0000001004147810ULL, 0x040fe20007ffe0ffULL,
0x0000000105067824ULL, 0x040fe200078e0206ULL, 0x0000001104047810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x0000000714147812ULL, 0x000fc400078e7803ULL,
0x0000000006107984ULL, 0x000e62000000cc00ULL, 0x0000000704047812ULL, 0x000fe400078e7803ULL,
0x0000000105147824ULL, 0x040fe200078e0214ULL, 0x00000000080c7984ULL, 0x000ea4000000cc00ULL,
0x0000000105047824ULL, 0x000fe400078e0204ULL, 0x000000ffff1c7224ULL, 0x002fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0012ULL, 0x000000ffff1e7224ULL, 0x004fe400078e000cULL,
0x000000ffff1f7224ULL, 0x000fe400078e000eULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fe200078e0013ULL, 0x0000001c06007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff237224ULL, 0x000fca00078e000fULL,
0x0000002008007388ULL, 0x000fe8000000cc00ULL, 0x00000000040c7984ULL, 0x000e68000000cc00ULL,
0x0000000014107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002414007388ULL, 0x0003e8000000cc00ULL, 0x0000000c04007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01060400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0022a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000021b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000337919ULL, 0x000ea20000000000ULL, 0x3d80000034347820ULL, 0x000fe20000410000ULL,
0x000064000a367a24ULL, 0x000fe200078e02ffULL, 0xffffffff02387810ULL, 0x000fe20007ffe0ffULL,
0x000000101a357824ULL, 0x000fe200078e00ffULL, 0x00007610ff397816ULL, 0x000fe20000000039ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x000001001b3a7824ULL, 0x008fe200078e0230ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003a1900720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x020fea0003800000ULL, 0x000000ffff037224ULL, 0x000fe200078e0037ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x002fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x000000013b257810ULL, 0x000fe20007ffe0ffULL,
0x00000bd000007945ULL, 0x000fe20003800000ULL, 0x0000000103377812ULL, 0x000fc400078e0cffULL,
0x00000002ff247819ULL, 0x000fe40000011625ULL, 0x000000042500780cULL, 0x040fe40003f06070ULL,
0x00000003254e7812ULL, 0x000fe200078ec0ffULL, 0x0000030024277a24ULL, 0x000fe400078e021bULL,
0x000000ffff247224ULL, 0x000fe400078e003bULL, 0x0000010027267824ULL, 0x040fe200078e0230ULL,
0x00000001272d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3b7224ULL, 0x000fc600078e0025ULL,
0x000000022d00720cULL, 0x000fe40003f26070ULL, 0x0000004026277812ULL, 0x000fca00078ec0ffULL,
0x0000000132277824ULL, 0x000fcc00078e0227ULL, 0x000005d000009947ULL, 0x020fea0003800000ULL,
0x00000002ff3c7819ULL, 0x004fe20000011633ULL, 0x00000004182e7c24ULL, 0x000fe2000f8e0227ULL,
0x0000002619257217ULL, 0x000fe20007800000ULL, 0x000000044e2c7824ULL, 0x000fe200078e00ffULL,
0x000000083c3e7810ULL, 0x000fe20007ffe0ffULL, 0x000000021a2f7824ULL, 0x000fe200078e0237ULL,
0x0000007f3c277812ULL, 0x000fe200078ec0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a26ULL,
0x00000003ff267819ULL, 0x100fe20000011633ULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x0000007f3e2d7812ULL, 0x040fe200078ec0ffULL, 0x000000043e3d7824ULL, 0x000fe200078e00ffULL,
0x0000000326427812ULL, 0x100fe200078e4833ULL, 0x0000000127267824ULL, 0x100fe200078e022eULL,
0xfffffffc2c437812ULL, 0x000fe200078ee233ULL, 0x000000012d2c7824ULL, 0x000fe200078e022eULL,
0x000000253c00720cULL, 0x000fe20003f26070ULL, 0x00005e0026267625ULL, 0x000fe200078e0041ULL,
0x000000253e00720cULL, 0x000fc40003f46070ULL, 0x000020002f2f7811ULL, 0x000fe200078e60ffULL,
0x00005e002c2c7625ULL, 0x000fe200078e0041ULL, 0x0ffffffc423e7812ULL, 0x000fe400078ef833ULL,
0xfffffffc3d407812ULL, 0x000fe200078ee242ULL, 0x0000001043267825ULL, 0x040fe200078e0026ULL,
0x000000103c447810ULL, 0x040fe40007ffe0ffULL, 0x000000183c467810ULL, 0x000fe20007ffe0ffULL,
0x000000103e3d7824ULL, 0x100fe200078e022fULL, 0x000000203c487810ULL, 0x000fe20007ffe0ffULL,
0x00000010403f7824ULL, 0x000fe200078e022fULL, 0x000000283c4a7810ULL, 0x040fe20007ffe0ffULL,
0x00000010432c7825ULL, 0x000fe200078e002cULL, 0x000000303c4c7810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000263d7faeULL, 0x0003e2000c901c46ULL,
0x000000383c507810ULL, 0x000fc40007ffe0ffULL, 0x000000254400720cULL, 0x080fe20003f26070ULL,
0x000000002c3f7faeULL, 0x0005e2000d101c46ULL, 0x000000254600720cULL, 0x080fe20003f46070ULL,
0x0000000450477824ULL, 0x000fe200078e00ffULL, 0x000000254800720cULL, 0x080fe40003f66070ULL,
0x000000254a00720cULL, 0x080fe40003f86070ULL, 0x000000254c00720cULL, 0x080fe40003fa6070ULL,
0x000000255000720cULL, 0x000fc40003fc6070ULL, 0x0000007f44257812ULL, 0x000fe400078ec0ffULL,
0x0000007f46277812ULL, 0x002fe400078ec0ffULL, 0x0000007f482d7812ULL, 0x004fe200078ec0ffULL,
0x0000000125267824ULL, 0x100fe200078e022eULL, 0x0000007f4c3f7812ULL, 0x000fe200078ec0ffULL,
0x00000001272c7824ULL, 0x100fe200078e022eULL, 0x0000007f50457812ULL, 0x000fe200078ec0ffULL,
0x000000012d3c7824ULL, 0x100fe200078e022eULL, 0x0000007f4a3d7812ULL, 0x000fe200078ec0ffULL,
0x000000013f3e7824ULL, 0x000fc400078e022eULL, 0x0000000145407824ULL, 0x000fe400078e022eULL,
0x0000000444257824ULL, 0x000fe400078e00ffULL, 0x0000000446277824ULL, 0x000fe400078e00ffULL,
0x00000004482d7824ULL, 0x000fe400078e00ffULL, 0x000000044a3f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc27447812ULL, 0x100fe200078ee242ULL, 0x000000044c457824ULL, 0x000fe200078e00ffULL,
0xfffffffc2d467812ULL, 0x000fe200078ee242ULL, 0x000000013d3d7824ULL, 0x000fe200078e022eULL,
0xfffffffc252e7812ULL, 0x100fe200078ee242ULL, 0x00005e0026267625ULL, 0x000fe200078e0041ULL,
0xfffffffc3f487812ULL, 0x000fc400078ee242ULL, 0xfffffffc454a7812ULL, 0x100fe200078ee242ULL,
0x000000102e257824ULL, 0x100fe200078e022fULL, 0xfffffffc47427812ULL, 0x000fe200078ee242ULL,
0x0000001044457824ULL, 0x100fe400078e022fULL, 0x0000001046477824ULL, 0x100fe400078e022fULL,
0x0000001048497824ULL, 0x100fe400078e022fULL, 0x000000104a4b7824ULL, 0x100fe400078e022fULL,
0x00000010424d7824ULL, 0x000fc400078e022fULL, 0x00005e002c2c7625ULL, 0x000fc800078e0041ULL,
0x00005e003c2e7625ULL, 0x000fc800078e0041ULL, 0x00005e003d3c7625ULL, 0x000fc800078e0041ULL,
0x00005e003e3e7625ULL, 0x000fc800078e0041ULL, 0x00005e0040407625ULL, 0x000fc800078e0041ULL,
0x0000001043267825ULL, 0x000fc800078e0026ULL, 0x00000010432c7825ULL, 0x040fe200078e002cULL,
0x0000000026257faeULL, 0x0003e6000c901c46ULL, 0x00000010432e7825ULL, 0x040fe200078e002eULL,
0x000000002c457faeULL, 0x0003e6000d101c46ULL, 0x00000010433c7825ULL, 0x040fe200078e003cULL,
0x000000002e477faeULL, 0x0003e6000d901c46ULL, 0x00000010433e7825ULL, 0x040fe200078e003eULL,
0x000000003c497faeULL, 0x0003e6000e101c46ULL, 0x0000001043407825ULL, 0x000fe200078e0040ULL,
0x000000003e4b7faeULL, 0x0003e8000e901c46ULL, 0x00000000404d7faeULL, 0x0003e2000f101c46ULL,
0x0000052000007947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x004fe20000011633ULL,
0x0000000418277c24ULL, 0x000fc4000f8e0227ULL, 0x00000100ff457424ULL, 0x000fe200078e00ffULL,
0x0000007f25267812ULL, 0x040fe400078ec0ffULL, 0x00000008252d7810ULL, 0x040fe40007ffe0ffULL,
0x00000010252f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001262c7824ULL, 0x100fe200078e0227ULL,
0x00000018253d7810ULL, 0x040fe40007ffe0ffULL, 0x00000020253f7810ULL, 0x000fe20007ffe0ffULL,
0x000000042f497824ULL, 0x000fe200078e00ffULL, 0x0000002825417810ULL, 0x000fe20007ffe0ffULL,
0x000000043d4b7824ULL, 0x000fe200078e00ffULL, 0x0000003025437810ULL, 0x000fe20007ffe0ffULL,
0x000000043f4d7824ULL, 0x000fe200078e00ffULL, 0x0000003825477810ULL, 0x000fe20007ffe0ffULL,
0x00000004414f7824ULL, 0x000fe200078e00ffULL, 0x0000007f2d267812ULL, 0x000fe200078ec0ffULL,
0x0000000443537824ULL, 0x000fe200078e00ffULL, 0x0000007f2f2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000447557824ULL, 0x000fe200078e00ffULL, 0x0000007f3d3c7812ULL, 0x000fe200078ec0ffULL,
0x00000001263e7824ULL, 0x100fe200078e0227ULL, 0x0000007f3f447812ULL, 0x000fe200078ec0ffULL,
0x000000012e407824ULL, 0x100fe200078e0227ULL, 0x0000007f41467812ULL, 0x000fe200078ec0ffULL,
0x000000013c427824ULL, 0x100fe200078e0227ULL, 0x0000007f43487812ULL, 0x000fe200078ec0ffULL,
0x0000000144447824ULL, 0x100fe200078e0227ULL, 0x0000007f474a7812ULL, 0x000fe200078ec0ffULL,
0x0000000146467824ULL, 0x000fe200078e0227ULL, 0x00000003ff267819ULL, 0x000fe20000011633ULL,
0x0000000148487824ULL, 0x000fc400078e0227ULL, 0x000000014a4a7824ULL, 0x000fe400078e0227ULL,
0x000000044e2e7824ULL, 0x000fe400078e00ffULL, 0x000000021a277824ULL, 0x000fc600078e0237ULL,
0xfffffffc2e257812ULL, 0x100fe400078ee233ULL, 0x00002000273c7811ULL, 0x000fe200078e60ffULL,
0x000000042d277824ULL, 0x000fe200078e00ffULL, 0x00000003262e7812ULL, 0x000fc800078e4833ULL,
0x0ffffffc2e2d7812ULL, 0x000fe400078ef833ULL, 0xfffffffc272f7812ULL, 0x100fe200078ee22eULL,
0x00005e002c267625ULL, 0x080fe200078e0045ULL, 0xfffffffc493d7812ULL, 0x100fe400078ee22eULL,
0xfffffffc4b3f7812ULL, 0x000fe200078ee22eULL, 0x000000102d477824ULL, 0x000fe200078e023cULL,
0xfffffffc4d417812ULL, 0x000fe200078ee22eULL, 0x000000102f497824ULL, 0x000fe200078e023cULL,
0xfffffffc4f437812ULL, 0x100fe200078ee22eULL, 0x00005e003e2c7625ULL, 0x000fe200078e0045ULL,
0xfffffffc53537812ULL, 0x000fc400078ee22eULL, 0xfffffffc55557812ULL, 0x000fe200078ee22eULL,
0x000000103d4b7824ULL, 0x100fe400078e023cULL, 0x000000103f4d7824ULL, 0x100fe400078e023cULL,
0x00000010414f7824ULL, 0x100fe400078e023cULL, 0x0000001043517824ULL, 0x100fe400078e023cULL,
0x0000001053537824ULL, 0x100fe400078e023cULL, 0x0000001055557824ULL, 0x000fc400078e023cULL,
0x00005e00402e7625ULL, 0x000fc800078e0045ULL, 0x00005e00423c7625ULL, 0x000fc800078e0045ULL,
0x00005e00443e7625ULL, 0x000fc800078e0045ULL, 0x00005e0046407625ULL, 0x000fc800078e0045ULL,
0x0000001025267825ULL, 0x000fc800078e0026ULL, 0x00005e0048427625ULL, 0x080fe200078e0045ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026477faeULL, 0x0003e6000b901c46ULL,
0x00005e004a447625ULL, 0x000fc800078e0045ULL, 0x00000010252c7825ULL, 0x000fc800078e002cULL,
0x00000010252e7825ULL, 0x040fe200078e002eULL, 0x000000002c497faeULL, 0x0003e6000b901c46ULL,
0x00000010253c7825ULL, 0x040fe200078e003cULL, 0x000000002e4b7faeULL, 0x0003e6000b901c46ULL,
0x00000010253e7825ULL, 0x040fe200078e003eULL, 0x000000003c4d7faeULL, 0x0003e6000b901c46ULL,
0x0000001025407825ULL, 0x040fe200078e0040ULL, 0x000000003e4f7faeULL, 0x0003e6000b901c46ULL,
0x0000001025427825ULL, 0x040fe200078e0042ULL, 0x0000000040517faeULL, 0x0003e6000b901c46ULL,
0x0000001025447825ULL, 0x000fe200078e0044ULL, 0x0000000042537faeULL, 0x0003e8000b901c46ULL,
0x0000000044557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000034e00780cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x00000300ff187624ULL, 0x000fc800078e00ffULL,
0x0000000218317824ULL, 0x000fe400078e0231ULL, 0xffffffffff187424ULL, 0x000fc600078e00ffULL,
0x000000003100720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000236267824ULL, 0x002fe400078e0231ULL, 0x00000004ff277424ULL, 0x000fc800078e00ffULL,
0x0000600026267625ULL, 0x000fca00078e0027ULL, 0x0000000626187981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008243e7824ULL, 0x002fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000020332c7810ULL, 0x040fe20007ffe0ffULL,
0x000000021a267824ULL, 0x000fe200078e0203ULL, 0xfffffff833247812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffff82c2c7812ULL, 0x000fe400078ec0ffULL,
0x0000000724247812ULL, 0x000fc400078ef833ULL, 0x000000072c3d7812ULL, 0x000fe400078ef833ULL,
0x00000001ff257819ULL, 0x000fe40000011624ULL, 0x00000001ff2c7819ULL, 0x000fe4000001163dULL,
0x0000000325257812ULL, 0x000fe400078ec0ffULL, 0x000000032c2d7812ULL, 0x000fe400078ec0ffULL,
0x0000003c25277212ULL, 0x000fc400078e3cffULL, 0x0000003c2d2c7212ULL, 0x000fe400078e3cffULL,
0x0000200026267811ULL, 0x000fe200078e60ffULL, 0x0000000424277824ULL, 0x000fe200078e0227ULL,
0x00000007332e7812ULL, 0x000fe200078ec0ffULL, 0x000000043d2f7824ULL, 0x000fe200078e022cULL,
0x000000013c2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x100fe200078e0226ULL,
0x000000082e5a7812ULL, 0x000fe200078ef833ULL, 0x000000102f407824ULL, 0x000fe200078e0226ULL,
0x0000002c25257212ULL, 0x000fc400078e3cffULL, 0x0000002c2d487212ULL, 0x000fe200078e3cffULL,
0x000000002744783bULL, 0x000e620000000200ULL, 0x000000023c3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000424257824ULL, 0x000fe200078e0225ULL, 0x0000003e33247211ULL, 0x000fe200078fe0ffULL,
0x000000043d3d7824ULL, 0x000fe200078e0248ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x00000010252e7824ULL, 0x100fe200078e0226ULL, 0x0000000224257810ULL, 0x040fe20007ffe0ffULL,
0x000000103d267824ULL, 0x000fe200078e0226ULL, 0x00000007244b7812ULL, 0x000fc400078e785aULL,
0x0000000725257812ULL, 0x000fe200078e785aULL, 0x000000002e2c783bULL, 0x000fe20000000200ULL,
0x000000043c00780cULL, 0x000fe20003f25270ULL, 0x000000205a4b7824ULL, 0x000fe200078e024bULL,
0x000000043e3e7810ULL, 0x000fe20007ffe0ffULL, 0x000000205a5a7824ULL, 0x000fe400078e0225ULL,
0x000000002624783bULL, 0x000ea20000000200ULL, 0x00000010ff7a7819ULL, 0x002fe40000011644ULL,
0x0000ffff447b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff7a7a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff45757812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7b7819ULL, 0x000fe4000001167bULL,
0x00000018ff3d7819ULL, 0x000fe40000011644ULL, 0x00000010ff787819ULL, 0x000fe40000011645ULL,
0x0000ffff46737812ULL, 0x000fc400078ec0ffULL, 0x00000010ff747819ULL, 0x000fe40000011646ULL,
0x00000010ff627819ULL, 0x104fe40000011624ULL, 0x00000018ff4f7819ULL, 0x000fe40000011624ULL,
0x000000ff24507812ULL, 0x040fe400078ec0ffULL, 0x0000ffff24597812ULL, 0x000fe400078ec0ffULL,
0x0000007aff24723eULL, 0x000fc400020006ffULL, 0x00000010ff6b7819ULL, 0x100fe40000011642ULL,
0x00000018ff647819ULL, 0x000fe40000011642ULL, 0x000000ff42617812ULL, 0x040fe400078ec0ffULL,
0x0000ffff426f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x100fe40000011643ULL,
0x00000018ff657819ULL, 0x000fc40000011643ULL, 0x000000ff43497812ULL, 0x040fe400078ec0ffULL,
0x0000ffff43637812ULL, 0x000fe400078ec0ffULL, 0x00000008ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff567819ULL, 0x100fe4000001162cULL, 0x00000018ff427819ULL, 0x000fe4000001162cULL,
0x000000ff2c437812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2c577812ULL, 0x000fe400078ec0ffULL,
0x0000007bff7a723eULL, 0x000fe200020006ffULL, 0x20000024ff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe40000011647ULL, 0x0000003dff2c723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff78787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff587819ULL, 0x100fe20000011625ULL, 0x2000002cff2c7230ULL, 0x000fe20000004100ULL,
0x00000018ff517819ULL, 0x000fc40000011625ULL, 0x000000ff25527812ULL, 0x040fe400078ec0ffULL,
0x0000ffff253d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff247819ULL, 0x000fe40000011673ULL,
0x00000075ff25723eULL, 0x000fe400020006ffULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x0000ffff47717812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe40000011640ULL,
0x00000018ff667819ULL, 0x000fe40000011640ULL, 0x000000ff40677812ULL, 0x040fe400078ec0ffULL,
0x0000ffff405c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5f7819ULL, 0x100fe4000001162dULL,
0x00000018ff6a7819ULL, 0x000fc4000001162dULL, 0x000000ff2d7c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2d797812ULL, 0x000fe400078ec0ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3f7819ULL, 0x100fe20000011626ULL,
0x20000078ff757230ULL, 0x000fe20000004100ULL, 0x00000018ff537819ULL, 0x000fc40000011626ULL,
0x000000ff262d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff26407812ULL, 0x000fe400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x000000ff41607812ULL, 0x000fe400078ec0ffULL,
0x00000074ff26723eULL, 0x000fe200020006ffULL, 0x20000025ff747230ULL, 0x000fe20000004100ULL,
0x00000008ff717819ULL, 0x000fe20000011671ULL, 0x20000024ff787230ULL, 0x000fe20000004100ULL,
0x00000072ff25723eULL, 0x000fe200020006ffULL, 0x20000026ff737230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000064ff24723eULL, 0x000fe400020006ffULL,
0x00000071ff72723eULL, 0x000fe200020006ffULL, 0x20000025ff717230ULL, 0x000fe20000004100ULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff25723eULL, 0x000fe200020006ffULL,
0x20000060ff657230ULL, 0x000fe20000004100ULL, 0x00000018ff5e7819ULL, 0x000fe20000011641ULL,
0x20000024ff607230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000005fff24723eULL, 0x000fc400020006ffULL,
0x00000010ff4a7819ULL, 0x000fe2000001162eULL, 0x20000049ff5f7230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000024ff497230ULL, 0x000fe20000004100ULL,
0x000000ff4a247812ULL, 0x000fe400078ec0ffULL, 0x000000ff44487812ULL, 0x000fe200078ec0ffULL,
0x2000005eff647230ULL, 0x000fe20000004100ULL, 0x00000018ff447819ULL, 0x000fe20000011645ULL,
0x20000025ff5e7230ULL, 0x000fe20000004100ULL, 0x00000024ff25723eULL, 0x000fe200020006ffULL,
0x000000104b247824ULL, 0x000fe200078e00ffULL, 0x000000ff45547812ULL, 0x000fc400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe20000011646ULL, 0x20000025ff4b7230ULL, 0x000fe20000004100ULL,
0x000000ff46557812ULL, 0x000fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe40000011647ULL,
0x000000ff47697812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6e7819ULL, 0x000fe40000011641ULL,
0x0000ffff41707812ULL, 0x000fc400078ec0ffULL, 0x00000010ff417819ULL, 0x100fe40000011627ULL,
0x00000018ff767819ULL, 0x000fe40000011627ULL, 0x000000ff275d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff27477812ULL, 0x000fe400078ec0ffULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000008ff797819ULL, 0x000fc40000011679ULL,
0x00000008ff5c7819ULL, 0x000fe2000001165cULL, 0x20000048ff777230ULL, 0x000fe20000004100ULL,
0x0000007cff48723eULL, 0x000fe400020006ffULL, 0x00000076ff7c723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL,
0x20000079ff4a7230ULL, 0x000fe20000004100ULL, 0x0000005cff76723eULL, 0x000fe200020006ffULL,
0x2000007cff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff6e7c7812ULL, 0x000fc400078ec0ffULL,
0x0000005bff79723eULL, 0x000fe200020006ffULL, 0x2000002dff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fe2000001162cULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff2c7819ULL, 0x000fe20000011677ULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff2d7819ULL, 0x000fe4000001167bULL, 0x00000010ff777819ULL, 0x000fe4000001167aULL,
0x00000018ff7d7819ULL, 0x000fc4000001162eULL, 0x000000ff2e7e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2e4c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4d7819ULL, 0x100fe4000001162fULL,
0x00000018ff7f7819ULL, 0x000fe4000001162fULL, 0x000000ff2f807812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2f4e7812ULL, 0x000fc400078ec0ffULL, 0x00000044ff2e723eULL, 0x000fe400020006ffULL,
0x00000054ff2f723eULL, 0x000fe400020006ffULL, 0x000010546e2d7816ULL, 0x000fe2000000002dULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x00001054772c7816ULL, 0x000fe2000000002cULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fc400020006ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x0000002c2428723cULL, 0x002fe20000041828ULL, 0x20000055ff6d7230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000045ff6c7230ULL, 0x000fe20000004100ULL,
0x0000006aff44723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x20000046ff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff2c7819ULL, 0x000fe2000001162eULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fc4000001162fULL, 0x00000010ff2f7819ULL, 0x000fe40000011675ULL,
0x00000010ff2d7819ULL, 0x000fe40000011674ULL, 0x000010542c2f7816ULL, 0x000fe4000000002fULL,
0x000010542d2e7816ULL, 0x000fe4000000002eULL, 0x00000010ff2c7819ULL, 0x000fe4000001166dULL,
0x00000010ff6c7819ULL, 0x000fc4000001166cULL, 0x00000010ff2d7819ULL, 0x000fe20000011673ULL,
0x0000002e2420723cULL, 0x000fe20000041820ULL, 0x00000010ff6d7819ULL, 0x000fe40000011678ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff707819ULL, 0x000fe20000011670ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fe20000011669ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x000010546c2d7816ULL, 0x000fc4000000002dULL, 0x000010546d2c7816ULL, 0x000fe4000000002cULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff2f7819ULL, 0x000fe40000011671ULL,
0x00000010ff697819ULL, 0x000fe20000011672ULL, 0x0000002c2404723cULL, 0x000fe20000041804ULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fc400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000068ff6c7230ULL, 0x000fe20000004100ULL,
0x000010546a2f7816ULL, 0x000fe2000000002fULL, 0x2000007cff6e7230ULL, 0x000fe20000004100ULL,
0x00001054692e7816ULL, 0x000fe4000000002eULL, 0x000000ff6b777812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6b7819ULL, 0x000fe2000001166fULL, 0x20000070ff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff687819ULL, 0x000fe20000011663ULL, 0x0000002e2408723cULL, 0x000fe20000041808ULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x00000010ff2c7819ULL, 0x000fe40000011667ULL,
0x00000010ff2d7819ULL, 0x000fe40000011679ULL, 0x00000010ff637819ULL, 0x000fe20000011676ULL,
0x000000105a2e7824ULL, 0x000fe200078e00ffULL, 0x00001054662d7816ULL, 0x000fe4000000002dULL,
0x00001054632c7816ULL, 0x000fe4000000002cULL, 0x000000ff622f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff627819ULL, 0x000fe20000011665ULL,
0x0000002c240c723cULL, 0x000fe2000004180cULL, 0x00000010ff637819ULL, 0x000fe4000001166eULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fc400020006ffULL, 0x0000006bff70723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000077ff6b7230ULL, 0x000fe20000004100ULL, 0x0000105464637816ULL, 0x000fe20000000063ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x000010546f627816ULL, 0x000fe20000000062ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x0000002fff5a723eULL, 0x000fe400020006ffULL,
0x000000002e2c783bULL, 0x000e620000000200ULL, 0x00000010ff647819ULL, 0x000fc40000011660ULL,
0x000000622410723cULL, 0x000fe20000041810ULL, 0x00000010ff607819ULL, 0x000fe20000011661ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe4000001166bULL,
0x00000010ff657819ULL, 0x000fe40000011670ULL, 0x000000ff58637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fe40000011659ULL, 0x00000010ff587819ULL, 0x000fc4000001165fULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff597819ULL, 0x000fe4000001166cULL,
0x00000010ff5f7819ULL, 0x000fe40000011668ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000008ff4c7819ULL, 0x000fe4000001164cULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x20000042ff547230ULL, 0x000fe20000004100ULL, 0x0000105464617816ULL, 0x000fc40000000061ULL,
0x0000105465607816ULL, 0x000fe20000000060ULL, 0x20000043ff557230ULL, 0x000fe20000004100ULL,
0x000010545e597816ULL, 0x000fe40000000059ULL, 0x000010545f587816ULL, 0x000fe40000000058ULL,
0x0000007eff42723eULL, 0x000fe200020006ffULL, 0x000000602414723cULL, 0x040fe20000041814ULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff4e7819ULL, 0x000fe2000001164eULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000007dff43723eULL, 0x000fe200020006ffULL,
0x00000058241c723cULL, 0x000fe2000004181cULL, 0x0000007fff46723eULL, 0x000fc400020006ffULL,
0x00000080ff45723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x000fe20000011648ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe2000001164aULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fc40000011642ULL, 0x0000105425487816ULL, 0x000fe40000000048ULL,
0x00000010ff257819ULL, 0x000fe4000001164cULL, 0x00000010ff247819ULL, 0x000fe40000011643ULL,
0x00000008ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff437819ULL, 0x000fe4000001164bULL,
0x0000105425427816ULL, 0x000fc40000000042ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff257819ULL, 0x000fe4000001164dULL,
0x00000010ff4e7819ULL, 0x000fc4000001164eULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x0000105424437816ULL, 0x000fe20000000043ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000105444497816ULL, 0x000fe20000000049ULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000105446257816ULL, 0x000fc40000000025ULL,
0x000010544e247816ULL, 0x000fe20000000045ULL, 0x000000422c04723cULL, 0x042fe20000041804ULL,
0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff407819ULL, 0x000fe40000011640ULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x000000482c20723cULL, 0x000fe20000041820ULL, 0x000000ff56567812ULL, 0x000fc400078ec0ffULL,
0x00000008ff577819ULL, 0x000fe20000011657ULL, 0x2000003fff447230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000008ff477819ULL, 0x000fe20000011647ULL,
0x000000242c08723cULL, 0x000fe20000041808ULL, 0x00000041ff48723eULL, 0x000fe200020006ffULL,
0x20000040ff3f7230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe4000001164fULL,
0x00000010ff507819ULL, 0x000fe20000011650ULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fc40000011651ULL, 0x00000010ff257819ULL, 0x000fe40000011663ULL,
0x00000010ff417819ULL, 0x000fe4000001165aULL, 0x00000010ff277819ULL, 0x000fe40000011662ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000105424257816ULL, 0x000fe20000000025ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x0000105426417816ULL, 0x000fe20000000041ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x0000105427407816ULL, 0x000fc40000000050ULL, 0x000010543d247816ULL, 0x000fe40000000052ULL,
0x00000010ff5e7819ULL, 0x000fe40000011654ULL, 0x00000010ff547819ULL, 0x000fe20000011655ULL,
0x000000402c0c723cULL, 0x000fe2000004180cULL, 0x00000010ff557819ULL, 0x000fe40000011656ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff277819ULL, 0x000fc40000011644ULL,
0x00000010ff407819ULL, 0x000fe20000011653ULL, 0x000000242c10723cULL, 0x000fe20000041810ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff267819ULL, 0x000fe4000001163fULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff257819ULL, 0x000fe40000011648ULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000010ff247819ULL, 0x000fe40000011647ULL,
0x000010545e557816ULL, 0x000fe40000000055ULL, 0x0000105457547816ULL, 0x000fe40000000054ULL,
0x0000105440277816ULL, 0x000fe40000000027ULL, 0x0000105426267816ULL, 0x000fe4000000005bULL,
0x000010545c257816ULL, 0x000fe20000000025ULL, 0x000000542c28723cULL, 0x000fe20000041828ULL,
0x0000105424247816ULL, 0x000fce000000005dULL, 0x000000262c14723cULL, 0x040ff00000041814ULL,
0x000000242c1c723cULL, 0x000fe2000004181cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe82000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff037224ULL, 0x000fe200078e0037ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdae000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0106140035247984ULL, 0x000e620000000800ULL, 0x0000ffff39037812ULL, 0x000fe200078ec0ffULL,
0x00000028342d7220ULL, 0x040fe20000410000ULL, 0x00000023343b7220ULL, 0x040fe20000410000ULL,
0x0000000434287220ULL, 0x040fe20000410000ULL, 0x00008880033e7816ULL, 0x000fe200000000ffULL,
0x0000000534277220ULL, 0x040fe20000410000ULL, 0x0000000d34237220ULL, 0x040fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x000fe20000410000ULL,
0x800000003e037824ULL, 0x000fe200078e00ffULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x00000029342c7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342e7220ULL, 0x040fe20000410000ULL, 0x00000022342f7220ULL, 0x040fe20000410000ULL,
0x0000000634067220ULL, 0x040fe20000410000ULL, 0x0000000734077220ULL, 0x040fe20000410000ULL,
0x0000000b34047220ULL, 0x040fe20000410000ULL, 0x0000000c340c7220ULL, 0x040fe20000410000ULL,
0x0000000e340e7220ULL, 0x040fe20000410000ULL, 0x0000001334057220ULL, 0x040fe20000410000ULL,
0x00000017340d7220ULL, 0x040fe20000410000ULL, 0x00000020342b7220ULL, 0x040fe20000410000ULL,
0x0000002134297220ULL, 0x040fe20000410000ULL, 0x0000000834267220ULL, 0x040fe20000410000ULL,
0x0000001034227220ULL, 0x040fe20000410000ULL, 0x0000001134217220ULL, 0x040fe20000410000ULL,
0x0000001434207220ULL, 0x040fe20000410000ULL, 0x0000001e343c7220ULL, 0x040fe20000410000ULL,
0x0000001f343d7220ULL, 0x040fe20000410000ULL, 0x0000000934257220ULL, 0x040fe20000410000ULL,
0x0000000a34087220ULL, 0x040fe20000410000ULL, 0x0000001234117220ULL, 0x040fe20000410000ULL,
0x0000001634147220ULL, 0x040fe20000410000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0015ULL,
0x0000001d341d7220ULL, 0x000fe20000410000ULL, 0x000000ffff1e7224ULL, 0x000fc400078e001cULL,
0x000000ffff107224ULL, 0x000fe200078e000fULL, 0x8000000024ff7812ULL, 0x002fe20007804803ULL,
0x000000ffff247224ULL, 0x000fe400078e000cULL, 0x000000ffff1c7224ULL, 0x000fe400078e002aULL,
0x000000ffff177224ULL, 0x000fe400078e002eULL, 0x000000ffff167224ULL, 0x000fe400078e002fULL,
0x000000ffff0b7224ULL, 0x000fc400078e003bULL, 0x000000ffff0a7224ULL, 0x000fe400078e0006ULL,
0x000000ffff097224ULL, 0x000fe400078e0007ULL, 0x000000ffff137224ULL, 0x000fe400078e0004ULL,
0x000000ffff127224ULL, 0x000fe400078e000eULL, 0x000000ffff157224ULL, 0x000fe400078e0005ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000dULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fc400078e003cULL,
0x000000ffff0d7224ULL, 0x000fe200078e003dULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000003e057824ULL, 0x000fe400078e00ffULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x0106140035047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000433037824ULL, 0x000fe200078e00ffULL, 0x000000381b00720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff003057812ULL, 0x000fca00078ec0ffULL,
0x000000801a0c7824ULL, 0x000fca00078e0205ULL, 0x010400000c047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002332a7824ULL, 0x000fe400078e00ffULL,
0x00000001193a7824ULL, 0x000fc600078e0a3aULL, 0x000000062a2f7812ULL, 0x000fc800078ec0ffULL,
0x000000012f3b7812ULL, 0x040fe400078efcffULL, 0x000000082f3d7812ULL, 0x000fe400078efcffULL,
0x0000003a3b00720cULL, 0x080fe40003f26070ULL, 0x000000102f3b7812ULL, 0x000fe400078efcffULL,
0x0000003a3d00720cULL, 0x080fe40003f06070ULL, 0x0000003a3b00720cULL, 0x000fc40003fc6070ULL,
0x000000112f3d7812ULL, 0x040fe400078efcffULL, 0x000000182f3b7812ULL, 0x040fe400078efcffULL,
0x0000003a2f00720cULL, 0x080fe40003f46070ULL, 0x0000003a3d00720cULL, 0x080fe40003fa6070ULL,
0x0000003a3b00720cULL, 0x000fe40003f66070ULL, 0x000000092f3f7812ULL, 0x000fc400078efcffULL,
0x000000192f3d7812ULL, 0x040fe400078efcffULL, 0x000000202f3b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff17177808ULL, 0x000fe40004800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40004800000ULL,
0x0000003a3f00720cULL, 0x080fe40003f86070ULL, 0x0000003a3d00720cULL, 0x080fe40003f46070ULL,
0x0000003a3b00720cULL, 0x000fe40003f26070ULL, 0x000000212f3d7812ULL, 0x040fe400078efcffULL,
0x000000282f3b7812ULL, 0x000fe400078efcffULL, 0xff7fffff16167808ULL, 0x000fc40004000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL,
0xff7fffff29297808ULL, 0x000fe40006000000ULL, 0x0000003a3d00720cULL, 0x080fe40003f06070ULL,
0x0000003a3b00720cULL, 0x000fe40003f86070ULL, 0x000000292f3d7812ULL, 0x000fc400078efcffULL,
0x000000302f3b7812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL,
0xff7fffff28287808ULL, 0x000fe40007000000ULL, 0xff7fffff09097808ULL, 0x000fe40006800000ULL,
0xff7fffff27277808ULL, 0x000fe40006800000ULL, 0x0000003a3d00720cULL, 0x000fc40003fc6070ULL,
0x0000003a3b00720cULL, 0x000fe40003fa6070ULL, 0x000000312f3d7812ULL, 0x040fe400078efcffULL,
0x000000382f3b7812ULL, 0x040fe400078efcffULL, 0x000000392f2f7812ULL, 0x000fe400078efcffULL,
0xff7fffff08087808ULL, 0x000fe40005800000ULL, 0xff7fffff26267808ULL, 0x000fc40005800000ULL,
0xff7fffff13137808ULL, 0x000fe40005000000ULL, 0xff7fffff25257808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff24247808ULL, 0x000fe40004800000ULL,
0x0000003a3d00720cULL, 0x080fe40003f66070ULL, 0x0000003a3b00720cULL, 0x000fc40003f46070ULL,
0x0000003a2f00720cULL, 0x000fe40003f26070ULL, 0xff7fffff10107808ULL, 0x000fe40004000000ULL,
0xff7fffff23237808ULL, 0x000fe40004000000ULL, 0xff7fffff11117808ULL, 0x000fe40006000000ULL,
0xff7fffff22227808ULL, 0x000fe40006000000ULL, 0xff7fffff15157808ULL, 0x000fc40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40007000000ULL, 0xff7fffff14147808ULL, 0x000fe40006800000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002d042f7209ULL, 0x004fe20007810000ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x0000001c052a7209ULL, 0x000fe20007810000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x0000002c2f047209ULL, 0x000fe40007810000ULL, 0x000000172a057209ULL, 0x000fc40007810000ULL,
0x0000002b04047209ULL, 0x000fe40007810000ULL, 0x00000016052a7209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000000b2a2f7209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x0000000a2f2a7209ULL, 0x000fc40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x000000092a2f7209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x000000082f2a7209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fe40007810000ULL, 0x000000132a2f7209ULL, 0x000fc40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x000000122f2f7209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x000000102f047209ULL, 0x000fe40007810000ULL,
0x00000022052a7209ULL, 0x000fe40007810000ULL, 0x0000001104047209ULL, 0x000fc40007810000ULL,
0x000000212a057209ULL, 0x000fe40007810000ULL, 0x00000015042f7209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x000000142f2a7209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fe40007810000ULL, 0x0000000f2a2f7209ULL, 0x000fc40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e2f2a7209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d2a3d7209ULL, 0x000fe20007810000ULL,
0x00000df27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x00000004053f7209ULL, 0x008fe20007810000ULL, 0x00000e227f007947ULL, 0x000fea000b800000ULL,
0x0c401f003d047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x004ea800000e0000ULL,
0x0c401f00072a7f89ULL, 0x000f2200000e0000ULL, 0x000000043d2e7209ULL, 0x008fc60007810000ULL,
0x0c201f003f047f89ULL, 0x000ee200000e0000ULL, 0x00000005063a7209ULL, 0x004fc60007810000ULL,
0x0c201f002e057f89ULL, 0x000ea200000e0000ULL, 0x0000002a072a7209ULL, 0x010fc60007810000ULL,
0x0c201f003a3b7f89ULL, 0x002e6800000e0000ULL, 0x0c201f002a2f7f89ULL, 0x00092200000e0000ULL,
0x000000043f047209ULL, 0x008fe40007810000ULL, 0x000000052e057209ULL, 0x004fe40007810000ULL,
0x0000003b3a067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b042e7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b053d7820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fc40000000000ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001082eULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001082eULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe2000001082eULL,
0x3fb8aa3b08407823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001083dULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b0f0f7823ULL, 0x000fca000001083dULL,
0x00000029003a7308ULL, 0x000fe20000000800ULL, 0x0000002d2c08723eULL, 0x004fce00000010ffULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000eb00000000800ULL,
0x0000002000297308ULL, 0x0007f00000000800ULL, 0x0000001e003b7308ULL, 0x0023e20000000800ULL,
0x00000005ff207e24ULL, 0x008fe2000f8e00ffULL, 0x000000160b0b723eULL, 0x004fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b12167823ULL, 0x000fe2000001083dULL,
0x0000000000087886ULL, 0x000fe200038e0100ULL, 0x3f8000002020783eULL, 0x000fc400000010ffULL,
0x0000001d002e7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b0a1e7823ULL, 0x002fe2000001083dULL,
0x0000002b3a0a723eULL, 0x000fcc00000010ffULL, 0x0000002100077308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b091d7823ULL, 0x004fe2000001083dULL, 0x0000001c1709723eULL, 0x000fcc00000010ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x000000ffff217224ULL, 0x002fce00078e0020ULL,
0x0000002700277308ULL, 0x000e700000000800ULL, 0x0000001f003c7308ULL, 0x000ff00000000800ULL,
0x0000001e003e7308ULL, 0x000ff00000000800ULL, 0x0000001d003f7308ULL, 0x0004f00000000800ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x00000020081c723cULL, 0x004fee00000418ffULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b10217823ULL, 0x100fe2000001083dULL,
0x000000282710723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b11277823ULL, 0x000fe2000001083dULL,
0x0000003e3f11723eULL, 0x008fc800000010ffULL, 0x0000004000407308ULL, 0x000ff00000000800ULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000262512723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b15257823ULL, 0x000fcc000001083dULL, 0x00000021002c7308ULL, 0x0005e20000000800ULL,
0x000000401313723eULL, 0x002fe200000010ffULL, 0x000000ffff217224ULL, 0x004fcc00078e0020ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x00000020101c723cULL, 0x000fee000004181cULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x3fb8aa3b14217823ULL, 0x000fce000001083dULL,
0x0000002200227308ULL, 0x000eb00000000800ULL, 0x0000001600177308ULL, 0x0004e20000000800ULL,
0x000000242314723eULL, 0x002fe200000010ffULL, 0x000000ffff237224ULL, 0x000fcc00078e0020ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000220716723eULL, 0x004fe200000010ffULL,
0x000000ffff227224ULL, 0x000fe200078e0020ULL, 0xfffffffc33077812ULL, 0x000fca00078ec0ffULL,
0x0000002500267308ULL, 0x000e620000000800ULL, 0x000000172c15723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x000000272617723eULL, 0x002fce00000010ffULL,
0x0000000f00287308ULL, 0x000e620000000800ULL, 0x000000221424723cULL, 0x000fee000004181cULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000fff1c7424ULL, 0x000fe200078e00ffULL,
0x0000003b2e1e723eULL, 0x000fcc00000010ffULL, 0x0000000d000d7308ULL, 0x000ea20000000800ULL,
0x00000021281d723eULL, 0x002fe200000010ffULL, 0x000000ffff217224ULL, 0x000fe200078e0020ULL,
0x000000071c2b7219ULL, 0x000fe400000006ffULL, 0x000000293c1c723eULL, 0x000fe400000010ffULL,
0x000000002b2273a1ULL, 0x000e6200000e8000ULL, 0x000000002b0573c4ULL, 0x000ee20000004000ULL,
0x0000002a2f077209ULL, 0x010fe40007810000ULL, 0x0000000e0d1f723eULL, 0x004fce00000010ffULL,
0x000000201c24723cULL, 0x000fe20000041824ULL, 0x000000082bff7c12ULL, 0x002fda000f804022ULL,
0x0000091205008947ULL, 0x008ff4000b800000ULL, 0x001c1fff24207589ULL, 0x0002a400000e0000ULL,
0x000000002b0e73a1ULL, 0x000ee200000e8000ULL, 0x000000002b0573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x000000082bff7c12ULL, 0x008fda000f80400eULL,
0x0000092205008947ULL, 0x010fea000b800000ULL, 0x001c1fff26217589ULL, 0x00072800000e0000ULL,
0x001c1fff22227589ULL, 0x00066800000e0000ULL, 0x001c1fff00237589ULL, 0x0006a400000e0000ULL,
0x00000002ff0d7819ULL, 0x002fe40000011633ULL, 0x0000000c03417812ULL, 0x000fc400078ec0ffULL,
0x000000070d0e7812ULL, 0x040fe200078ec0ffULL, 0x000000080d277824ULL, 0x040fe200078e00ffULL,
0x0000000dff257212ULL, 0x000fe200078e33ffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x0000000333ff7812ULL, 0x000fe2000780c0ffULL, 0x000000080d3c7824ULL, 0x040fe200078e00ffULL,
0x000000080d0d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff827247812ULL, 0x100fe400078ee20eULL,
0x000000010f267812ULL, 0x108fe200078ef60eULL, 0x000000080d277824ULL, 0x000fe200078e00ffULL,
0x000000020f287812ULL, 0x100fe200078ef60eULL, 0x000000080d4c7824ULL, 0x000fe200078e00ffULL,
0x000000030f2a7812ULL, 0x000fc400078ef60eULL, 0x000000040f2c7812ULL, 0x140fe400078ef60eULL,
0x000000050f2e7812ULL, 0x140fe400078ef60eULL, 0x000000060f3a7812ULL, 0x000fe200078ef60eULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee225ULL,
0x0000000dff257212ULL, 0x000fe400078e33ffULL, 0x000000070d0e7812ULL, 0x000fc400078ec0ffULL,
0x0000a0001a0d7811ULL, 0x000fe400078e58ffULL, 0xfffffff8273e7812ULL, 0x100fe400078ee20eULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee225ULL, 0x0000001024037824ULL, 0x100fe200078e020dULL,
0x000000010f407812ULL, 0x140fe200078ef60eULL, 0x000000102a247824ULL, 0x100fe200078e020dULL,
0x000000020f427812ULL, 0x140fe200078ef60eULL, 0x000000103a2a7824ULL, 0x000fe200078e020dULL,
0x000000030f447812ULL, 0x100fe200078ef60eULL, 0x0000000141037824ULL, 0x000fe200078e0203ULL,
0x000000040f467812ULL, 0x140fe200078ef60eULL, 0x00000010402f7824ULL, 0x100fe200078e020dULL,
0x000000050f487812ULL, 0x140fe200078ef60eULL, 0x00000010423a7824ULL, 0x100fe200078e020dULL,
0x000000060f4a7812ULL, 0x000fe200078ef60eULL, 0x00000010260e7824ULL, 0x100fe200078e020dULL,
0x0000000803007388ULL, 0x0003e20000000800ULL, 0x00000010280f7824ULL, 0x000fc400078e020dULL,
0x000000102c267824ULL, 0x100fe400078e020dULL, 0x000000102e287824ULL, 0x100fe400078e020dULL,
0x000000103c2c7824ULL, 0x100fe400078e020dULL, 0x000000103e2e7824ULL, 0x100fe400078e020dULL,
0x00000010443b7824ULL, 0x100fe400078e020dULL, 0x00000010463c7824ULL, 0x000fc400078e020dULL,
0x00000010483d7824ULL, 0x100fe400078e020dULL, 0x000000104a3e7824ULL, 0x100fe400078e020dULL,
0x000000104c3f7824ULL, 0x000fe400078e020dULL, 0x00000001410d7824ULL, 0x040fe400078e020eULL,
0x00000001410f7824ULL, 0x040fe400078e020fULL, 0x0000000141257824ULL, 0x040fe200078e0224ULL,
0x0000000a0d007388ULL, 0x0007e20000000800ULL, 0x0000000141277824ULL, 0x000fc400078e0226ULL,
0x0000000141297824ULL, 0x040fe200078e0228ULL, 0x000000100f007388ULL, 0x0007e20000000800ULL,
0x00000001412b7824ULL, 0x040fe400078e022aULL, 0x00000001412d7824ULL, 0x040fe200078e022cULL,
0x0000001225007388ULL, 0x0007e20000000800ULL, 0x00000001412e7824ULL, 0x040fe400078e022eULL,
0x00000001410e7824ULL, 0x040fe200078e022fULL, 0x0000001427007388ULL, 0x0007e20000000800ULL,
0x00000001413a7824ULL, 0x000fc400078e023aULL, 0x0000000141087824ULL, 0x042fe200078e023bULL,
0x0000001629007388ULL, 0x0007e20000000800ULL, 0x00000001413c7824ULL, 0x040fe400078e023cULL,
0x0000000141247824ULL, 0x040fe200078e023dULL, 0x0000001c2b007388ULL, 0x0007e20000000800ULL,
0x00000001413e7824ULL, 0x040fe400078e023eULL, 0x0000000141267824ULL, 0x000fe200078e023fULL,
0x0000001e2d007388ULL, 0x0007e80000000800ULL, 0x000000092e007388ULL, 0x0007e80000000800ULL,
0x0000000b0e007388ULL, 0x0007e80000000800ULL, 0x000000113a007388ULL, 0x0007e80000000800ULL,
0x0000001308007388ULL, 0x0007e80000000800ULL, 0x000000153c007388ULL, 0x0007e80000000800ULL,
0x0000001724007388ULL, 0x0007e80000000800ULL, 0x0000001d3e007388ULL, 0x0007e80000000800ULL,
0x0000001f26007388ULL, 0x0007e80000000800ULL, 0x010000040c008388ULL, 0x0007e80000000c00ULL,
0x010200200c008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000003001b1b7a10ULL, 0x000fe20007ffe0ffULL, 0x0106080035ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff39ff7812ULL, 0x000fc4000780c0ffULL, 0x000000021b00720cULL, 0x000fe40003f26070ULL,
0x00000001ff397807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffc0a000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0005ULL, 0x00019500002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff3b7424ULL, 0x000fe400078e00ffULL, 0x0000054000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e003aULL, 0xfffff1c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x00019560002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff3b7424ULL, 0x002fe400078e00ffULL, 0x000004e000007944ULL, 0x024fea0003c00000ULL,
0x0000003a3d057209ULL, 0x004fe20007810000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0006ULL,
0x000195b0002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff3b7424ULL, 0x002fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000003a063d7209ULL, 0x004fe20007810000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0007ULL, 0x00019600002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff3b7424ULL, 0x002fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000003a072a7209ULL, 0x004fe20007810000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e003fULL,
0x00019650002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff3b7424ULL, 0x002fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000003a3f047209ULL, 0x004fe20007810000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0005ULL, 0x000196a0002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff3b7424ULL, 0x002fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000003a05057209ULL, 0x004fe20007810000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x000196f0002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff3b7424ULL, 0x002fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x0000003a3d067209ULL, 0x004fe20007810000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e002aULL, 0x00019740002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff3b7424ULL, 0x002fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e003aULL, 0xfffff07000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0d7224ULL, 0x000fe200078e0024ULL, 0x000197b0000e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fc400078e00ffULL, 0x00001c1fff257424ULL, 0x000fe400078e00ffULL,
0x000002d000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0023ULL,
0xfffff69000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0d7224ULL, 0x002fe200078e0026ULL,
0x00019820000e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fe400078e00ffULL,
0x00001c1fff257424ULL, 0x000fe400078e00ffULL, 0x0000026000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff247224ULL, 0x002fe200078e00ffULL, 0x00019870000e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x004fe400078e0023ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff247224ULL, 0x002fe200078e00ffULL,
0x000198c0000e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff257424ULL, 0x000fc400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0023ULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xfffff61000007947ULL, 0x000fea000383ffffULL, 0x0180000009037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000900038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff0a7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000030aff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff09ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000009057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000030aff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000900037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe65c004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000004100007348ULL, 0x000fe80003800000ULL,
0x0c00003b3a3a7389ULL, 0x0002a200000e003cULL, 0xfffe65802e007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000002b00007348ULL, 0x000fe80003800000ULL,
0x000000240d237389ULL, 0x0002a200000e0025ULL, 0xfffe65400e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000008e8ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001100ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001190ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001198ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011a8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001380ULL, 0x0000000000019b80ULL, 0xa700001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001af00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001af10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001af10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b390ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001190ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019d70ULL, 0x0000000000019d70ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001af00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b390ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_pagedKV_128_nqpkv_16_m_16_sm_89_cubin_len = 111728;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
