/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000008160ULL, 0x0000000000007d20ULL, 0x00380040005a0d5aULL, 0x0001001100400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL,
0x6d5f6c656e72656bULL, 0x756265642e006168ULL, 0x00656d6172665f67ULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x6f632e766e2e616cULL, 0x0034746e6174736eULL,
0x2e6c65722e000000ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x5f67756265642e61ULL,
0x6e2e00656d617266ULL, 0x72676c6c61632e76ULL, 0x2e766e2e00687061ULL, 0x7079746f746f7270ULL,
0x6f632e766e2e0065ULL, 0x2e30746e6174736eULL, 0x6d5f6c656e72656bULL, 0x0000000000006168ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x732e000000000000ULL, 0x0062617472747368ULL, 0x006261747274732eULL, 0x006261746d79732eULL,
0x5f6261746d79732eULL, 0x6e2e0078646e6873ULL, 0x2e006f666e692e76ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL, 0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL,
0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL, 0x6f632e766e2e0061ULL, 0x0033746e6174736eULL,
0x4d34456b00000000ULL, 0x6e2e0058414d5f33ULL, 0x6c61626f6c672e76ULL, 0x6d730074696e692eULL,
0x2e00657a69536d65ULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL, 0x79546c656e72656bULL,
0x0000000000006570ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7265746e695f5f24ULL,
0x5f245f305f6c616eULL, 0x6d735f616475635fULL, 0x725f7063725f3032ULL, 0x33665f7a74665f6eULL,
0x6170776f6c735f32ULL, 0x2e6c65722e006874ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e006369702e74ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x72656b0065707974ULL, 0x0061686d5f6c656eULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e000300000089ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000100000099ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0003000000a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e0001000000b3ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d0022000000d3ULL, 0x0000000000006940ULL,
0x0000000000000240ULL, 0x0004000300000131ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000700030000018cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d1012000001a8ULL,
0x0000000000000000ULL, 0x0000000000006b80ULL, 0x00100003000001b3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x0000002cffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000694000000000ULL, 0x0000140400000000ULL,
0x0428288080810c00ULL, 0x0000000000001a28ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x8a08288080880828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808a920000ULL,
0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL, 0x0000694000000000ULL,
0x0000024000000000ULL, 0x0000480400000000ULL, 0x8084288080880900ULL, 0x0900000010042880ULL,
0x288080882880808aULL, 0x0000000c00082f04ULL, 0x0008120400000038ULL, 0x0000002800000009ULL,
0x0000000900081104ULL, 0x0008120400000028ULL, 0x000000280000000cULL, 0x0000000c00081104ULL,
0x0008120400000028ULL, 0x000000280000000cULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL,
0x0021f00000f80008ULL, 0x00000000000c1704ULL, 0x0021f00000f00007ULL, 0x00000000000c1704ULL,
0x0201f00000700006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL,
0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x00381b0380005003ULL, 0x0000020000043104ULL, 0xffffffff00442904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000020000442804ULL, 0x0000211000002060ULL, 0x00004aa0000021e0ULL, 0x00004ae000004ab0ULL,
0x00004b2000004af0ULL, 0x00004dc000004b30ULL, 0x00004e5000004e00ULL, 0x00004e9000004e60ULL,
0x0000552000004ea0ULL, 0x0000037005f03904ULL, 0x0000cda0000000ffULL, 0x000003a000040100ULL,
0x0000cda8000000ffULL, 0x000003c000040100ULL, 0x0000cdb0000000ffULL, 0x0000040000040100ULL,
0x0000cdb8000000ffULL, 0x0000042000040100ULL, 0x0000cdc0000000ffULL, 0x0000044000040100ULL,
0x0000cdc8000000ffULL, 0x0000046000040100ULL, 0x0000cdd0000000ffULL, 0x0000048000040100ULL,
0x0000cdd8000000ffULL, 0x000004a000040100ULL, 0x0000cde0000000ffULL, 0x000004c000040100ULL,
0x0000cde8000000ffULL, 0x000004e000040100ULL, 0x0000cdf0000000ffULL, 0x0000050000040100ULL,
0x0000cdf8000000ffULL, 0x0000052000040100ULL, 0x0000ce00000000ffULL, 0x0000054000040100ULL,
0x0000ce08000000ffULL, 0x0000056000040100ULL, 0x0000ce10000000ffULL, 0x0000058000040100ULL,
0x0000ce18000000ffULL, 0x0000097000040100ULL, 0x0000cdd800000009ULL, 0x00000980003f0101ULL,
0x0000cdd800000009ULL, 0x00000bf0003f0109ULL, 0x0000cdb800000000ULL, 0x00000c30003f0101ULL,
0x0000cdb800000000ULL, 0x00000d60003f0109ULL, 0x0000cdc800000000ULL, 0x00000d70003f0101ULL,
0x0000cdc800000000ULL, 0x00001110003f0109ULL, 0x0000cda800000000ULL, 0x00001130003f0101ULL,
0x0000cda800000000ULL, 0x00001c30003f0109ULL, 0x0000cda000000000ULL, 0x00001cb0003f0101ULL,
0x0000cdd800000000ULL, 0x00001cd0003f0101ULL, 0x0000cde800000000ULL, 0x00001ce0003f0101ULL,
0x0000cdf800000000ULL, 0x00001cf0003f0101ULL, 0x0000ce0800000000ULL, 0x00001d20003f0101ULL,
0x0000ce1800000000ULL, 0x00001d30003f0101ULL, 0x0000ce1800000000ULL, 0x00001ed0003f0109ULL,
0x0000cdd000000007ULL, 0x00001f00003f0109ULL, 0x0000cdf00000000bULL, 0x00001f50003f0101ULL,
0x0000cdf00000000bULL, 0x00002030003f0109ULL, 0x0000ce1800000000ULL, 0x00002290003f0101ULL,
0x0000ce1800000000ULL, 0x000024d0003f0109ULL, 0x0000ce1800000000ULL, 0x000025f0003f0101ULL,
0x0000ce1800000000ULL, 0x00003030003f0109ULL, 0x0000ce1800000000ULL, 0x00003080003f0101ULL,
0x0000ce1800000000ULL, 0x00003a10003f0109ULL, 0x0000ce1800000000ULL, 0x00003ac0003f0101ULL,
0x0000ce1800000000ULL, 0x00003ba0003f0109ULL, 0x0000ce1800000000ULL, 0x00003bb0003f0101ULL,
0x0000ce1800000000ULL, 0x00003dd0003f0109ULL, 0x0000cdf800000002ULL, 0x00003de0003f0101ULL,
0x0000cdd800000002ULL, 0x00003e80003f0101ULL, 0x0000cda800000000ULL, 0x00003ea0003f0101ULL,
0x0000cdb800000000ULL, 0x00003eb0003f0101ULL, 0x0000cdc800000000ULL, 0x00003ed0003f0101ULL,
0x0000ce1000000000ULL, 0x00003ee0003f0101ULL, 0x0000ce1000000000ULL, 0x00003f00003f0109ULL,
0x0000cda000000000ULL, 0x00003f10003f0101ULL, 0x0000cda000000000ULL, 0x00004000003f0109ULL,
0x0000cdb000000000ULL, 0x000044e0003f0109ULL, 0x0000cdb800000000ULL, 0x00004500003f0101ULL,
0x0000cdc000000000ULL, 0x00004960003f0109ULL, 0x0000cdc800000000ULL, 0x00004c60003f0101ULL,
0x0000ce1000000000ULL, 0x00004ca0003f0101ULL, 0x0000ce1000000000ULL, 0x00004cd0003f0109ULL,
0x0000ce1000000000ULL, 0x00004ce0003f0101ULL, 0x0000ce1000000000ULL, 0x00004fb0003f0109ULL,
0x0000cdf800000018ULL, 0x00004fc0003f0101ULL, 0x0000cdf800000018ULL, 0x00005190003f0109ULL,
0x0000cdf000000018ULL, 0x000051c0003f0101ULL, 0x0000cda800000000ULL, 0x000052d0003f0101ULL,
0x0000cda000000000ULL, 0x000053d0003f0108ULL, 0x0000410000000000ULL, 0x00005440003f0100ULL,
0x0000410800000000ULL, 0x000054f0003f0100ULL, 0x0000410800000000ULL, 0x00005750003f0101ULL,
0x0000410800000003ULL, 0x000058500007010aULL, 0x00004100000000ffULL, 0x00005b1000080107ULL,
0x0000410000000003ULL, 0x00005ee00007010aULL, 0x00004108000000ffULL, 0x0000613000080101ULL,
0x0000410800000000ULL, 0x00006140003f0108ULL, 0x0000410000000000ULL, 0x00006160003f0108ULL,
0x0000cdd800000009ULL, 0x000061c0003f0109ULL, 0x0000cdb800000000ULL, 0x00006220003f0109ULL,
0x0000cdc800000000ULL, 0x00006280003f0109ULL, 0x0000cda800000000ULL, 0x000062e0003f0109ULL,
0x0000ce1800000000ULL, 0x00006340003f0109ULL, 0x0000cdd000000007ULL, 0x000063a0003f0109ULL,
0x0000cdf00000000bULL, 0x00006400003f0109ULL, 0x0000ce1800000000ULL, 0x00006460003f0109ULL,
0x0000ce1800000000ULL, 0x000064c0003f0109ULL, 0x0000ce1800000000ULL, 0x00006520003f0109ULL,
0x0000ce1800000000ULL, 0x00006580003f0109ULL, 0x0000ce1000000000ULL, 0x000065e0003f0109ULL,
0x0000cda000000000ULL, 0x00006640003f0109ULL, 0x0000cdb000000000ULL, 0x000066a0003f0109ULL,
0x0000cdc000000000ULL, 0x00006700003f0109ULL, 0x0000ce1000000000ULL, 0x00006760003f0109ULL,
0x0000ce1000000000ULL, 0x000067c0003f0109ULL, 0x0000cdf800000018ULL, 0x00006850003f0109ULL,
0x0000410800000005ULL, 0x000068e0003f010aULL, 0x0000410000000005ULL, 0x00123803003f010aULL,
0x0000016000141c04ULL, 0x00005340000052e0ULL, 0x0000615000006100ULL, 0x00000180000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0401001903ULL, 0x010002100000000dULL,
0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000700000002ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000500000002ULL, 0x0000000000000000ULL, 0x00000000000000d4ULL,
0x0000000c00000002ULL, 0x0000000000006940ULL, 0x0000000000000044ULL, 0x0000000c00000002ULL,
0x0000000000000000ULL, 0x00000000000000aaULL, 0x0000000c00000002ULL, 0x0000000000000000ULL,
0x0000000043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e300000000800ULL, 0x00000000001079c3ULL, 0x000e620000002700ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0xffffffd801017836ULL, 0x001fe20000000000ULL, 0x00000004100478a5ULL, 0x002fcc000f8e0004ULL,
0x00000004ff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff037e24ULL, 0x000fca000f8e00ffULL,
0x0000000e02027981ULL, 0x000ea2000c1e1900ULL, 0x00000000001279c3ULL, 0x000e220000002500ULL,
0x0000030000117ab9ULL, 0x000fe20000000800ULL, 0x00000000020472caULL, 0x004fda00000e0000ULL,
0x0000003f04047890ULL, 0x000fc8000fffe03fULL, 0x000000063f137899ULL, 0x000fe40008011604ULL,
0x0000007f0400788cULL, 0x000fe4000bf04070ULL, 0x000000111300728cULL, 0x000fe4000bf21070ULL,
0x000000011100788cULL, 0x000fe40008704070ULL, 0x0000001113067287ULL, 0x000fe40008800000ULL,
0x0000003f12147287ULL, 0x001fc40008000000ULL, 0x0000000106067887ULL, 0x000fc80008000000ULL,
0x000000061400728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e220000002300ULL,
0x0000000600007d06ULL, 0x000e620008209000ULL, 0x0000042000007945ULL, 0x000fe20003800000ULL,
0x0000000000077919ULL, 0x000e220000002200ULL, 0x00000000001c7919ULL, 0x000eaa0000002100ULL,
0x0000000000007308ULL, 0x002e620000001000ULL, 0x0000000607ff7212ULL, 0x001fc8000780fcffULL,
0x000000201c00780cULL, 0x004fda0000705670ULL, 0x00006600ff048b82ULL, 0x000e220000000a00ULL,
0x00000000003f7886ULL, 0x000fe20000020000ULL, 0x0000007004038810ULL, 0x001fc80007f3e0ffULL,
0x00000000030482caULL, 0x000fe200000e0000ULL, 0x000000ffff048224ULL, 0x000fe200008e0605ULL,
0x0000001c06ff7212ULL, 0x000fe2000782fe07ULL, 0x0ffffffe00037836ULL, 0x002fc60000000000ULL,
0x00000000040582caULL, 0x000fc600000e0000ULL, 0x0000000300037305ULL, 0x000e28000021f000ULL,
0x00000004ff047e24ULL, 0x000fca000f8e00ffULL, 0x00000000040482caULL, 0x000fe200000e0000ULL,
0x00000005ff057e24ULL, 0x000fca000f8e00ffULL, 0x00000000050582caULL, 0x000fda00000e0000ULL,
0x00000000040099b9ULL, 0x0001e40008040000ULL, 0x0000000000b41947ULL, 0x001fea0003800000ULL,
0x00000000000579c3ULL, 0x000e220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001ffe8000087882ULL, 0x000fe20000000000ULL, 0x7ffa000000097882ULL, 0x000fe20000000000ULL,
0x001fff00000a7882ULL, 0x000fe20000000000ULL, 0x7ffc0000000b7882ULL, 0x000fe20000000000ULL,
0x001ffefe000c7882ULL, 0x000fe20000000000ULL, 0x7ffbf800000d7882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x001fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e340000000000ULL, 0x00cda008043f75b2ULL, 0x000e220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cda808043f75b2ULL, 0x0002220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x001ffe0000087882ULL, 0x002fe20000000000ULL,
0x7ff8000000097882ULL, 0x000fe20000000000ULL, 0x00cdb00a043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cdb80c043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cdc00a043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cdc80c043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cdd00a043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cdd80c043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cde00a043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cde80c043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cdf008043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00cdf808043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00ce0008043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00ce0808043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00ce100a043f75b2ULL, 0x0000220008000100ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00ce180a043f75b2ULL, 0x0000240008000100ULL,
0x0000000000007918ULL, 0x001fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000030572caULL, 0x000fe200000e0000ULL, 0x800000063f087290ULL, 0x000fe2000fffe03fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000143f077292ULL, 0x000fe2000f8e333fULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000003f0600728cULL, 0x000fc6000bf65070ULL,
0x0000003f00047c82ULL, 0x000fe40008000000ULL, 0x00000000000c79c3ULL, 0x000fe60000002600ULL,
0x00000005080872a4ULL, 0x000fc8000f8e023fULL, 0x00000008050872a5ULL, 0x000fe4000f8e0004ULL,
0x0000001306047290ULL, 0x000fc8000fffe007ULL, 0x00000004090872a5ULL, 0x000fce000f8e003fULL,
0x0000000900057c82ULL, 0x000fe40008000000ULL, 0x0000003f05077290ULL, 0x000fe4000fffe13fULL,
0x00000000000879c3ULL, 0x000e240000008800ULL, 0x00000007060772a4ULL, 0x000fc8000f8e0204ULL,
0x000000060700728cULL, 0x000fd6000bf26070ULL, 0x0000000706071290ULL, 0x000fe4000fffe13fULL,
0x0000000105051890ULL, 0x000fe4000fffe03fULL, 0x000000060700728cULL, 0x000fc6000bf46070ULL,
0x0000040000077882ULL, 0x000fe40000000000ULL, 0x0000065408077896ULL, 0x001fcc0008000007ULL,
0x00000007ff007e24ULL, 0x000fe2000f8e00ffULL, 0x0000000105052890ULL, 0x000fe4000fffe03fULL,
0x000000063f05b292ULL, 0x000fe2000f8e333fULL, 0x000000041c037824ULL, 0x000fca00078e0200ULL,
0x0000000301007387ULL, 0x0003e20000100800ULL, 0x0000003400a88947ULL, 0x000fea0003800000ULL,
0x000000010600780cULL, 0x000fe20003f05270ULL, 0x0000367000007945ULL, 0x000fd80003800000ULL,
0x0000001400288947ULL, 0x000fea0003800000ULL, 0x000000401c00780cULL, 0x000fe40003f06070ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fca000001ff00ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x000000401c00780cULL, 0x000fda0003f05270ULL,
0x0000000000d08947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fc80003f0f018ULL, 0x000000601c00780cULL, 0x000fda0000705670ULL,
0x0000003400640947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e220000002700ULL,
0x0000660000087ab9ULL, 0x000fe20000000a00ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000007008077890ULL, 0x000fe2000ff3e03fULL, 0x00000001ff067424ULL, 0x000fc600078e00ffULL,
0x000000093f087290ULL, 0x000fe40008ffe43fULL, 0x00000007ff0c7e24ULL, 0x000fc8000f8e00ffULL,
0x00000008ff0d7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000104047811ULL, 0x001fce00078e08ffULL,
0x0000001005027824ULL, 0x040fe200078e00ffULL, 0x0000000105077812ULL, 0x000fe200078ec0ffULL,
0x00000014ff087e24ULL, 0x000fc6000f8e00ffULL, 0x0000001002037812ULL, 0x002fe200078ec0ffULL,
0x00000010070a7824ULL, 0x140fe400078e0200ULL, 0x0000420007077824ULL, 0x000fe400078e0200ULL,
0x0000000100097824ULL, 0x000fc800078e0203ULL, 0x00cdd806090279a7ULL, 0x000e24000850003fULL,
0x00cdd803090075a7ULL, 0x001e24000800017fULL, 0x0000005400f08947ULL, 0x001fea0003800000ULL,
0x0000000605027c24ULL, 0x000fe2000f8e0208ULL, 0x000000000a0972caULL, 0x000fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x00000000070772caULL, 0x000fe400000e0000ULL,
0x00000000020b72caULL, 0x000fe400000e0000ULL, 0x000000000c1672caULL, 0x000fe400000e0000ULL,
0x000000000d1772caULL, 0x000fe400000e0000ULL, 0x00000000040d72caULL, 0x000fc400000e0000ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000cdd009097890ULL, 0x000fe4000fffe03fULL,
0x0000420007087890ULL, 0x000fe4000fffe03fULL, 0x000000060b0b7899ULL, 0x000fd8000800063fULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x00000008160075b4ULL, 0x0001d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x001fea000393ffffULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x0000620007087890ULL, 0x000fe2000fffe03fULL, 0x00000080000a7882ULL, 0x000fd60000000000ULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x00000008160075b4ULL, 0x0001d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x001fea000393ffffULL, 0x0000000105057836ULL, 0x000fca0000000000ULL,
0x0000000505007c0cULL, 0x000fda000bf06070ULL, 0xfffffffc00688947ULL, 0x000fea000383ffffULL,
0x0000003000a47947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000003000980947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e220000002700ULL, 0x00006600ff0a7b82ULL, 0x000ea20000000a00ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x0000000206067824ULL, 0x005fce00078e00ffULL, 0x00cdb809000279a7ULL, 0x002e22000850003fULL,
0x00000014ff087e24ULL, 0x000fe2000f8e00ffULL, 0x000000700a047810ULL, 0x000fc60007f3e0ffULL,
0x0000000607087c24ULL, 0x000fe2000f8e0208ULL, 0x00cdb803000075a7ULL, 0x001e24000800017fULL,
0x00000054005c8947ULL, 0x001fee0003800000ULL, 0x000000ffff057224ULL, 0x000fe200008e060bULL,
0x00000000000872caULL, 0x000fe200000e0000ULL, 0x0000004008087824ULL, 0x000fe200078e00ffULL,
0x00000000041672caULL, 0x000fe200000e0000ULL, 0x0000000107077836ULL, 0x000fe20000000000ULL,
0x00000000051772caULL, 0x000fe200000e0000ULL, 0x0000003f000a7c82ULL, 0x000fe20008000000ULL,
0x00000000080b72caULL, 0x000fe400000e0000ULL, 0x00000000060d72caULL, 0x000fe400000e0000ULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x0000000507007c0cULL, 0x000fe2000bf26070ULL,
0x0000cdb008097890ULL, 0x000fd8000fffe03fULL, 0x00000000003f082fULL, 0x000fe20003840000ULL,
0x00000008160075b4ULL, 0x0001d80008018000ULL, 0x000000000000281cULL, 0x000fe4000170e170ULL,
0x000000000000781cULL, 0x000fd60003f4e170ULL, 0xfffffffd00ec0947ULL, 0x001fea000393ffffULL,
0x00cdc809000279a7ULL, 0x000e24000850003fULL, 0x00cdc803000075a7ULL, 0x001e24000800017fULL,
0x0000005400248947ULL, 0x001fea0003800000ULL, 0x00000000000972caULL, 0x000fe200000e0000ULL,
0x00000080000a7882ULL, 0x000fe20000000000ULL, 0x00000000041672caULL, 0x000fe400000e0000ULL,
0x00000000051772caULL, 0x000fe400000e0000ULL, 0x00000000080b72caULL, 0x000fe400000e0000ULL,
0x00000000060d72caULL, 0x000fe400000e0000ULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x0000200009087890ULL, 0x000fe4000fffe03fULL, 0x0000cdc009097890ULL, 0x000fd8000fffe03fULL,
0x00000000003f082fULL, 0x000fe20003840000ULL, 0x00000008160075b4ULL, 0x0001d80008018000ULL,
0x000000000000281cULL, 0x000fe4000170e170ULL, 0x000000000000781cULL, 0x000fd60003f4e170ULL,
0xfffffffd00ec0947ULL, 0x001fea000393ffffULL, 0xfffffffc005c9947ULL, 0x000fea000383ffffULL,
0x0000002c00dc7947ULL, 0x000fea0003800000ULL, 0x00000000001e7919ULL, 0x000e220000002100ULL,
0x00008800ff027b82ULL, 0x002e620000000a00ULL, 0x0000840000077ab9ULL, 0x000fe40000000800ULL,
0x00000007100772a4ULL, 0x000fcc000f8e020cULL, 0x00000007ff117e24ULL, 0x000fc8000f8e00ffULL,
0x0000010011117824ULL, 0x001fc800078e021eULL, 0x0000001011047825ULL, 0x002fcc00078e0002ULL,
0x0000000e04047981ULL, 0x000f62000c1e9d00ULL, 0x000000401e1c7836ULL, 0x000fe20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x00000001ff1d7424ULL, 0x000fc600078e00ffULL,
0x000000ff1c00780cULL, 0x000fda0003f04070ULL, 0x0000000000680947ULL, 0x000fea0003800000ULL,
0x0000004011097836ULL, 0x000fc80000000000ULL, 0x0000001009087825ULL, 0x000fcc00078e0002ULL,
0x0000000e08087981ULL, 0x000f62000c1e9d00ULL, 0x000000801e0c7836ULL, 0x000fca0000000000ULL,
0x000000ff0c00780cULL, 0x000fda0003f24070ULL, 0x0000000000501947ULL, 0x000fea0003800000ULL,
0x000000c01e0c7836ULL, 0x000fca0000000000ULL, 0x000000ff0c00780cULL, 0x000fda0003f24070ULL,
0x000000c0110d9836ULL, 0x000fc80000000000ULL, 0x000000100d0c9825ULL, 0x000fc800078e0002ULL,
0x0000008011117836ULL, 0x000fe40000000000ULL, 0x0000000e0c0c9981ULL, 0x000ea4000c1e9d00ULL,
0x0000001011107825ULL, 0x000fcc00078e0002ULL, 0x0000000e10107981ULL, 0x000f62000c1e9d00ULL,
0x000100000c149824ULL, 0x044fe200078e00ffULL, 0x000077320c029816ULL, 0x000fe200000000ffULL,
0x000100000d169824ULL, 0x040fe200078e00ffULL, 0x000077320d039816ULL, 0x000fe200000000ffULL,
0x000100000e189824ULL, 0x040fe200078e00ffULL, 0x000077320e0c9816ULL, 0x000fe200000000ffULL,
0x000100000f1a9824ULL, 0x040fe200078e00ffULL, 0x000077320f0d9816ULL, 0x000fe200000000ffULL,
0x0001000002159824ULL, 0x000fe400078e00ffULL, 0x0001000003179824ULL, 0x000fc400078e00ffULL,
0x000100000c199824ULL, 0x000fe400078e00ffULL, 0x000100000d1b9824ULL, 0x000fce00078e00ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00cda81d000279a7ULL, 0x000e22000850003fULL,
0x000000ff1e00780cULL, 0x000fe20003f44070ULL, 0x00cda803000075a7ULL, 0x001e24000802017fULL,
0x00000050004c9947ULL, 0x001ff40003800000ULL, 0x00000ad000017945ULL, 0x000fe80003800000ULL,
0x0000000800ac2947ULL, 0x000fea0003800000ULL, 0x0000000000207919ULL, 0x000e220000002100ULL,
0x0000773204037816ULL, 0x060fe200000000ffULL, 0x0001000004047824ULL, 0x000fe200078e00ffULL,
0x00007732051e7816ULL, 0x040fe200000000ffULL, 0x00010000050c7824ULL, 0x000fe400078e00ffULL,
0x0001000003037824ULL, 0x000fe200078e00ffULL, 0x00000004ff04723eULL, 0x000fe20004807104ULL,
0x00010000060d7824ULL, 0x000fe400078e00ffULL, 0x00010000070e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff06723eULL, 0x000fc40004807106ULL, 0x000000ff04037812ULL, 0x000fe400078ec0ffULL,
0x00007732061f7816ULL, 0x040fe400000000ffULL, 0x0000ffff06067812ULL, 0x000fe400078ec0ffULL,
0x0000773207077816ULL, 0x000fe400000000ffULL, 0x0000000eff0e723eULL, 0x000fc8000480710eULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff027819ULL, 0x101fe40000011620ULL,
0x00000005ff057819ULL, 0x000fe40000011620ULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0000000502047212ULL, 0x000fca00078e3cffULL, 0x00000008050f7824ULL, 0x000fe200078e0204ULL,
0x0000760406057816ULL, 0x000fe20000000003ULL, 0x000000ffff067224ULL, 0x100fe200078e001eULL,
0x0000000cff1e723eULL, 0x000fe2000480711eULL, 0x000000ffff0c7224ULL, 0x100fe200078e001fULL,
0x0000000dff1f723eULL, 0x000fe2000480711fULL, 0x000000ffff0d7224ULL, 0x000fe200078e0007ULL,
0x0000001020047812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff1e1e7812ULL, 0x000fe200078ec0ffULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x00000004ff077819ULL, 0x000fe20000011604ULL, 0x000100000d0d7824ULL, 0x000fe200078e00ffULL,
0x00000006ff06723eULL, 0x000fc40004807106ULL, 0x0000000cff0c723eULL, 0x000fe2000480710cULL,
0x0000040007047824ULL, 0x000fe200078e0200ULL, 0x0000000dff0d723eULL, 0x000fe4000480710dULL,
0x000000ff1f1f7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff06077812ULL, 0x000fe200078ec0ffULL,
0x000000100f067824ULL, 0x000fe200078e0204ULL, 0x0000ffff0c0c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0d0d7812ULL, 0x000fc400078ec0ffULL, 0x0000000120037812ULL, 0x000fe400078ec0ffULL,
0x00007604071e7816ULL, 0x000fe4000000001eULL, 0x000076040c0c7816ULL, 0x000fe2000000001fULL,
0x0000000803067824ULL, 0x000fe200078e0206ULL, 0x000076040d0d7816ULL, 0x000fe4000000000eULL,
0x00005410051e7816ULL, 0x000fe4000000001eULL, 0x000054100c1f7816ULL, 0x000fca000000000dULL,
0x00c4001e06007388ULL, 0x0001e20000000a00ULL, 0x0000000400e00947ULL, 0x000fea0003800000ULL,
0x0000773208057816ULL, 0x040fe200000000ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x00007732090d7816ULL, 0x040fe200000000ffULL, 0x0001000009067824ULL, 0x001fe200078e00ffULL,
0x00000005ff097819ULL, 0x000fe2000001161cULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x000100000a077824ULL, 0x040fe200078e00ffULL,
0x000077320a0f7816ULL, 0x000fe400000000ffULL, 0x00000005ff0c723eULL, 0x000fc4000480710cULL,
0x00000009020a7212ULL, 0x000fe400078e3cffULL, 0x000000ff08057812ULL, 0x000fe200078ec0ffULL,
0x000100000b087824ULL, 0x000fe200078e00ffULL, 0x0000ffff0c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000809097824ULL, 0x100fe200078e020aULL, 0x000077320b1c7816ULL, 0x000fe400000000ffULL,
0x000076040c0e7816ULL, 0x000fe20000000005ULL, 0x000000ffff057224ULL, 0x000fe200078e000dULL,
0x00000006ff0a723eULL, 0x000fe2000480710aULL, 0x000000ffff067224ULL, 0x000fe200078e000fULL,
0x00000007ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff077224ULL, 0x000fe200078e001cULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x000000ff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fc40004807105ULL, 0x00000006ff06723eULL, 0x000fe40004807106ULL,
0x00000007ff07723eULL, 0x000fe40004807107ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000ffff060c7812ULL, 0x000fe200078ec0ffULL,
0x0000001009067824ULL, 0x000fe200078e0204ULL, 0x0000ffff07077812ULL, 0x000fe200078ec0ffULL,
0x0000008020097836ULL, 0x000fe20000000000ULL, 0x0000760405057816ULL, 0x000fe2000000000aULL,
0x0000000803067824ULL, 0x000fe200078e0206ULL, 0x000076040c0c7816ULL, 0x000fc4000000000bULL,
0x0000760407077816ULL, 0x000fe40000000008ULL, 0x000054100e0e7816ULL, 0x000fe40000000005ULL,
0x000054100c0f7816ULL, 0x000fe40000000007ULL, 0x000000ff0900780cULL, 0x000fc60003f04070ULL,
0x00c4000e06007388ULL, 0x0001f40000000a00ULL, 0x0000000400280947ULL, 0x000fea0003800000ULL,
0x0000773210057816ULL, 0x040fe200000000ffULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x00000005ff097819ULL, 0x000fe20000011609ULL, 0x0001000011067824ULL, 0x041fe200078e00ffULL,
0x0000773211117816ULL, 0x000fe200000000ffULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000010ff10723eULL, 0x000fe20004807110ULL, 0x0001000012077824ULL, 0x000fe200078e00ffULL,
0x00000009020a7212ULL, 0x000fe200078e3cffULL, 0x0001000013087824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fc40004807105ULL, 0x0000773212127816ULL, 0x000fe200000000ffULL,
0x0000000809097824ULL, 0x000fe200078e020aULL, 0x000000ff10107812ULL, 0x000fe400078ec0ffULL,
0x0000ffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000773213137816ULL, 0x000fe400000000ffULL,
0x0000760405107816ULL, 0x000fe20000000010ULL, 0x000000ffff057224ULL, 0x000fe200078e0011ULL,
0x00000006ff0a723eULL, 0x000fe2000480710aULL, 0x000000ffff067224ULL, 0x000fe200078e0012ULL,
0x00000007ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff077224ULL, 0x000fe200078e0013ULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x000000ff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fc40004807105ULL, 0x00000006ff06723eULL, 0x000fe40004807106ULL,
0x00000007ff07723eULL, 0x000fe40004807107ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000ffff060c7812ULL, 0x000fe200078ec0ffULL,
0x0000001009067824ULL, 0x000fe200078e0204ULL, 0x0000ffff07077812ULL, 0x000fc400078ec0ffULL,
0x0000760405057816ULL, 0x000fe2000000000aULL, 0x0000000803067824ULL, 0x000fe200078e0206ULL,
0x000076040c0c7816ULL, 0x000fe4000000000bULL, 0x0000760407077816ULL, 0x000fe40000000008ULL,
0x0000541010107816ULL, 0x000fe20000000005ULL, 0x000000c020057836ULL, 0x000fe20000000000ULL,
0x000054100c117816ULL, 0x000fc80000000007ULL, 0x000000ff0500780cULL, 0x000fe20003f04070ULL,
0x00c4001006007388ULL, 0x0001d80000000a00ULL, 0x0000000000700947ULL, 0x001fea0003800000ULL,
0x00000005ff057819ULL, 0x000fe40000011605ULL, 0x0000001aff1a723eULL, 0x000fe4000480711aULL,
0x0000000502027212ULL, 0x000fe400078e3cffULL, 0x0000001bff1b723eULL, 0x000fe4000480711bULL,
0x00000014ff14723eULL, 0x000fe20004807114ULL, 0x0000000805057824ULL, 0x000fe200078e0202ULL,
0x00000015ff15723eULL, 0x000fc40004807115ULL, 0x00000016ff16723eULL, 0x000fe20004807116ULL,
0x0000001005047824ULL, 0x000fe200078e0204ULL, 0x00000017ff17723eULL, 0x000fe40004807117ULL,
0x00000018ff18723eULL, 0x000fe20004807118ULL, 0x0000000803047824ULL, 0x000fe200078e0204ULL,
0x00000019ff19723eULL, 0x000fe40004807119ULL, 0x000000ff1a1a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff1b1b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff14147812ULL, 0x000fe400078ec0ffULL,
0x000000ff16167812ULL, 0x000fe400078ec0ffULL, 0x000000ff18187812ULL, 0x000fe400078ec0ffULL,
0x0000ffff17177812ULL, 0x000fe400078ec0ffULL, 0x0000ffff15157812ULL, 0x000fe400078ec0ffULL,
0x0000ffff19197812ULL, 0x000fc400078ec0ffULL, 0x000076041b1a7816ULL, 0x000fe4000000001aULL,
0x0000760417167816ULL, 0x000fe40000000016ULL, 0x0000760415157816ULL, 0x000fe40000000014ULL,
0x0000760419197816ULL, 0x000fe40000000018ULL, 0x0000541015167816ULL, 0x000fe40000000016ULL,
0x0000541019177816ULL, 0x000fca000000001aULL, 0x00c4001604007388ULL, 0x0001e40000000a00ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00cda01d00ff79a7ULL, 0x0003e2000850003fULL,
0x00000020006c7947ULL, 0x000fea0003800000ULL, 0x0000000001027983ULL, 0x000ea20000100800ULL,
0x00009200ff047b82ULL, 0x000e220000000a00ULL, 0x0000000000037919ULL, 0x002e640000002100ULL,
0x0000000e04047981ULL, 0x001162000c1e9900ULL, 0x000000070300780cULL, 0x002fe20003f04070ULL,
0x00000001ff037424ULL, 0x000fc800078e00ffULL, 0x00cdd80300ff79a7ULL, 0x0001f0000850003fULL,
0xff800000ff068424ULL, 0x000fe200078e00ffULL, 0x00cde80300ff79a7ULL, 0x0001e2000850003fULL,
0x00cdf80300ff79a7ULL, 0x0001e2000850003fULL, 0x00ce080300ff79a7ULL, 0x0001e4000850003fULL,
0x00cd600602008388ULL, 0x004fe80000000800ULL, 0x00cd80ff02008388ULL, 0x0003e40000000800ULL,
0x00ce1803000279a7ULL, 0x002e64000850003fULL, 0x00ce1803000075a7ULL, 0x002e64000800017fULL,
0x0000004400648947ULL, 0x003fea0003800000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000040600728cULL, 0x000fcc000bf24070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000020001c0947ULL, 0x000fea0003800000ULL, 0x3b12492504027820ULL, 0x020fe20000410000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000040201007387ULL, 0x0001e20000100800ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fc4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fce000001ff00ULL,
0x0000001034027824ULL, 0x041fe200078e00ffULL, 0x0000000134357812ULL, 0x000fe200078ec0ffULL,
0x0000009000017945ULL, 0x000fe20003800000ULL, 0x00000001ff057424ULL, 0x000fe400078e00ffULL,
0x0000001002037812ULL, 0x000fe200078ec0ffULL, 0x00000080ff027424ULL, 0x000fe400078e00ffULL,
0x00000010350b7824ULL, 0x000fe400078e0200ULL, 0x0000000100077824ULL, 0x000fc800078e0203ULL,
0x00cdd002070279a7ULL, 0x000e24000800003fULL, 0x00cdd003070075a7ULL, 0x001e24000800017fULL,
0x0000004400148947ULL, 0x001fea0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00cdf0050b0279a7ULL, 0x000e22000850003fULL, 0x0000000000087919ULL, 0x000e620000000000ULL,
0x0000009000017945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00cdf0030b0075a7ULL, 0x001e22000802017fULL,
0x000000070800780cULL, 0x002fda0003f04070ULL, 0x0000002035048824ULL, 0x100fe400078e0200ULL,
0x00000004080c8824ULL, 0x040fe400078e0200ULL, 0x0000000408088824ULL, 0x000fe200078e0204ULL,
0x0000004000fc9947ULL, 0x001fec0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00cc000008068984ULL, 0x000fe20000000800ULL, 0x000000ffff047224ULL, 0x000fc600078e00ffULL,
0x00cd60000c098984ULL, 0x000e220000000800ULL, 0x00000000000d7919ULL, 0x000e640000000000ULL,
0x000000040d078824ULL, 0x002fe200078e0200ULL, 0x000000060900720bULL, 0x001fc80003f3e000ULL,
0x00cd800007048984ULL, 0x0000620000000800ULL, 0x00ce1805000279a7ULL, 0x000022000850003fULL,
0x000080000000791aULL, 0x000fce0000000000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000000000a7806ULL, 0x000fc800048e0100ULL, 0x000000ff0a00720cULL, 0x000fda0003f25270ULL,
0x00000000007c9947ULL, 0x000fea0003800000ULL, 0x8000000609097221ULL, 0x000fe20000010000ULL,
0x000000550aff7812ULL, 0x040fe4000782c0ffULL, 0x000000aa0aff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009000c7308ULL, 0x0000ac0000000800ULL,
0x00000000002c9947ULL, 0x000fea0003800000ULL, 0x000000020d077824ULL, 0x000fca00078e00ffULL,
0x0000000607077812ULL, 0x000fcc00078ec0ffULL, 0x00001f070c077589ULL, 0x004ea400000e0000ULL,
0x0000000724247220ULL, 0x084fe20000410000ULL, 0x0000000726267220ULL, 0x080fe20000410000ULL,
0x0000000720207220ULL, 0x080fe20000410000ULL, 0x0000000722227220ULL, 0x080fe20000410000ULL,
0x000000071c1c7220ULL, 0x080fe20000410000ULL, 0x000000071e1e7220ULL, 0x080fe20000410000ULL,
0x0000000718187220ULL, 0x080fe20000410000ULL, 0x000000071a1a7220ULL, 0x000fce0000410000ULL,
0x000000000030a947ULL, 0x000fea0003800000ULL, 0x000000020d077824ULL, 0x000fca00078e00ffULL,
0x0000000607077812ULL, 0x000fca00078ec0ffULL, 0x0000000107077836ULL, 0x000fca0000000000ULL,
0x00001f070c087589ULL, 0x004ea400000e0000ULL, 0x0000000825257220ULL, 0x084fe20000410000ULL,
0x0000000827277220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000823237220ULL, 0x080fe20000410000ULL, 0x000000081d1d7220ULL, 0x080fe20000410000ULL,
0x000000081f1f7220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x000000081b1b7220ULL, 0x000fce0000410000ULL, 0x0000000c04047220ULL, 0x006fce0000410000ULL,
0x0000006000017945ULL, 0x000fe20003800000ULL, 0x00ce1803000075a7ULL, 0x0004a2000802017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00ce1803000095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000ea20000002100ULL,
0x000001c000017945ULL, 0x000fe20003800000ULL, 0x00000000000e7919ULL, 0x000ee20000000000ULL,
0x00000005ff127819ULL, 0x004fc8000001160fULL, 0x000000031200780cULL, 0x000fda0003f25270ULL,
0x00000000005c1947ULL, 0x008fea0003800000ULL, 0x000000ff0a00720cULL, 0x000fe20000722670ULL,
0x0000008035028824ULL, 0x140fe400078e0200ULL, 0x0000008035088824ULL, 0x040fe400078e0200ULL,
0x000000040e078824ULL, 0x040fe200078e0202ULL, 0x0000000000027805ULL, 0x000fe2000001ff00ULL,
0x00000080350c8824ULL, 0x040fe400078e0200ULL, 0x000000040e0a8824ULL, 0x000fe200078e0208ULL,
0x0000000000087805ULL, 0x001fe2000001ff00ULL, 0x00000080350d8824ULL, 0x000fc400078e0200ULL,
0x000000040e0b9824ULL, 0x040fe400078e0200ULL, 0x000000040e0c8824ULL, 0x040fe400078e020cULL,
0x000000040e0d8824ULL, 0x000fe200078e020dULL, 0x00cd60060b009388ULL, 0x000fe80000000800ULL,
0x00cc400007038984ULL, 0x000e280000000800ULL, 0x00cc60000a028984ULL, 0x000ea80000000800ULL,
0x00cc80000c098984ULL, 0x000ee80000000800ULL, 0x00cca0000d088984ULL, 0x000f220000000800ULL,
0x0000000304037221ULL, 0x003fc80000010000ULL, 0x0000000203027221ULL, 0x004fe20000010000ULL,
0x000000040e038824ULL, 0x000fc600078e0200ULL, 0x0000000902097221ULL, 0x008fc80000010000ULL,
0x0000000809087221ULL, 0x010fca0000010000ULL, 0x00cd800803008388ULL, 0x0001e40000000800ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00ce1805000479a7ULL, 0x002e62000850003fULL,
0x0000000412107836ULL, 0x040fe20000000000ULL, 0x0000021000017945ULL, 0x000fe20003800000ULL,
0x000000200f027824ULL, 0x000fe400078e00ffULL, 0x00000008120b7836ULL, 0x000fe40000000000ULL,
0x0000420035357824ULL, 0x000fe200078e0200ULL, 0xffffe00002037812ULL, 0x001fe200078ec0ffULL,
0x0000040010067824ULL, 0x000fe400078e00ffULL, 0x000004000b087824ULL, 0x000fc400078e00ffULL,
0x00004200350a7836ULL, 0x000fe20000000000ULL, 0xffffe00006077812ULL, 0x000fe200078ec0ffULL,
0x0000000c120c7836ULL, 0x000fe20000000000ULL, 0xffffe00008097812ULL, 0x000fe200078ec0ffULL,
0x000000010a037824ULL, 0x040fe400078e0203ULL, 0x000000010a087824ULL, 0x000fe400078e0207ULL,
0x000004000c077824ULL, 0x000fe200078e00ffULL, 0x0000000e03027211ULL, 0x080fe200078fc8ffULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0x00ce1805000075a7ULL, 0x002e22000800017fULL,
0x000000080e0d7824ULL, 0x040fe200078e00ffULL, 0xffffe00007077812ULL, 0x000fe200078ec0ffULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0x0000000e08067211ULL, 0x000fe200078fc8ffULL,
0x000000080e117824ULL, 0x000fe200078e00ffULL, 0x0000001202027212ULL, 0x000fe200078e3cffULL,
0x000000010a0a7824ULL, 0x000fe200078e0207ULL, 0x0000000e090c7211ULL, 0x000fc400078fc8ffULL,
0x0000001006067212ULL, 0x000fe400078e3cffULL, 0xfffffff80d027812ULL, 0x000fe400078ee202ULL,
0x0000000b0c0c7212ULL, 0x000fe400078e3cffULL, 0xfffffff80f077812ULL, 0x000fe200078ee206ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0xfffffff8110c7812ULL, 0x000fe400078ee20cULL,
0x0000000e0a067211ULL, 0x000fe200078fc8ffULL, 0x0000003c00408947ULL, 0x001fec0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x000e220000002100ULL,
0x0000001007107824ULL, 0x000fe400078e0208ULL, 0x000000100c0c7824ULL, 0x000fe200078e0209ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000000214783bULL, 0x0004e80000004200ULL, 0x000000001010783bULL, 0x000f220000004200ULL,
0x0000400035027836ULL, 0x004fc60000000000ULL, 0x0000201a01007387ULL, 0x000fe40000100a00ULL,
0x000001f002ff7812ULL, 0x000fe4000780c0ffULL, 0x0000181801007387ULL, 0x0007e20000100a00ULL,
0x00000005ff0d7819ULL, 0x001fe2000001160dULL, 0x000000080e057824ULL, 0x002fc800078e00ffULL,
0x0000000c0d0d7836ULL, 0x000fca0000000000ULL, 0x0000000d06067212ULL, 0x000fe400078e3cffULL,
0x000000000c0c783bULL, 0x000e240000004200ULL, 0xfffffff805057812ULL, 0x000fe400078ee206ULL,
0x0000624014187816ULL, 0x148fe40000000015ULL, 0x0000735114197816ULL, 0x000fe20000000015ULL,
0x0000001005057824ULL, 0x000fe200078e020aULL, 0x00006240161a7816ULL, 0x000fc40000000017ULL,
0x00007351161b7816ULL, 0x000fe40000000017ULL, 0x0000624010307816ULL, 0x150fe20000000011ULL,
0x000000000504783bULL, 0x000e620000004200ULL, 0x0000735110317816ULL, 0x000fe40000000011ULL,
0x0000624012327816ULL, 0x140fe40000000013ULL, 0x0000735112337816ULL, 0x000fe40000000013ULL,
0x000062400c2c7816ULL, 0x001fc4000000000dULL, 0x000073510c2d7816ULL, 0x000fe4000000000dULL,
0x000062400e2e7816ULL, 0x140fe4000000000fULL, 0x000073510e2f7816ULL, 0x000fe4000000000fULL,
0x0000624004287816ULL, 0x142fe40000000005ULL, 0x0000735104297816ULL, 0x000fe40000000005ULL,
0x0003fff002047812ULL, 0x000fe200078ec0ffULL, 0x0000000000177919ULL, 0x000e220000000000ULL,
0x00006240062a7816ULL, 0x000fc40000000007ULL, 0x00000004ff047819ULL, 0x000fe20000011604ULL,
0x0000000000147919ULL, 0x000e620000002100ULL, 0x00007351062b7816ULL, 0x000fe40000000007ULL,
0x00003f0004057812ULL, 0x000fc800078ec0ffULL, 0x000000ff05047812ULL, 0x000fe200078ef804ULL,
0x0000040002057824ULL, 0x000fc600078e00ffULL, 0x00000000040a72caULL, 0x000fe400000e0000ULL,
0x000e000005057812ULL, 0x000fc800078ec0ffULL, 0x8000002005057812ULL, 0x000fc800078efcffULL,
0x8000002005057807ULL, 0x000fc80000000000ULL, 0x00000000050b72caULL, 0x000fe200000e0000ULL,
0x00000000000079c5ULL, 0x000fd80000000000ULL, 0x0000000818247df3ULL, 0x000fe60008000824ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00002000011a7983ULL, 0x000ea80000300a00ULL,
0x0000180001187983ULL, 0x000ea20000300a00ULL, 0x00000000040a72caULL, 0x000fe200000e0000ULL,
0x0000402035357836ULL, 0x000fe20000000000ULL, 0x00000000050b72caULL, 0x000fe200000e0000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000005ff157819ULL, 0x002fc40000011614ULL,
0x00000005ff147819ULL, 0x000fe40000011614ULL, 0x0003fff035357812ULL, 0x000fc600078ec0ffULL,
0x0000000414147836ULL, 0x000fe20000000000ULL, 0x00000004ff357819ULL, 0x000fc60000011635ULL,
0x0000000830207df3ULL, 0x000fe60008000820ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00000000040a72caULL, 0x000fe200000e0000ULL, 0x0000102201007387ULL, 0x000fe20000100a00ULL,
0x00000000050b72caULL, 0x000fe200000e0000ULL, 0x00000000000079c5ULL, 0x000fe40000000000ULL,
0x0000082001007387ULL, 0x000ff40000100a00ULL, 0x000000082c1c7df3ULL, 0x000fe6000800081cULL,
0x00008000000079c5ULL, 0x000fc40000010000ULL, 0x00000000040a72caULL, 0x000fe200000e0000ULL,
0x0000002017047836ULL, 0x001fe20000000000ULL, 0x00000000050b72caULL, 0x000fc600000e0000ULL,
0x00000008040d7824ULL, 0x040fe200078e00ffULL, 0x0000000403067211ULL, 0x080fe200078fc8ffULL,
0x00000008040e7824ULL, 0x000fe200078e00ffULL, 0x00000004090c7211ULL, 0x080fe400078fc8ffULL,
0x0000001506067212ULL, 0x000fe200078e3cffULL, 0x0000000c15157836ULL, 0x000fe20000000000ULL,
0x0000000b0c0c7212ULL, 0x000fe400078e3cffULL, 0xfffffff80d067812ULL, 0x000fe200078ee206ULL,
0x00000008040d7824ULL, 0x000fe200078e00ffULL, 0x0000000408077211ULL, 0x000fc400078fc8ffULL,
0x000000040a0b7211ULL, 0x000fe200078fc8ffULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x0000001407077212ULL, 0x000fe200078e3cffULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0x000000150b0b7212ULL, 0x000fe400078e3cffULL, 0xfffffff80e077812ULL, 0x000fe400078ee207ULL,
0xfffffff80d0c7812ULL, 0x000fe400078ee20cULL, 0xfffffff8040b7812ULL, 0x000fe200078ee20bULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x00003f0035047812ULL, 0x000fe200078ec0ffULL,
0x000000100c0c7824ULL, 0x000fc400078e0209ULL, 0x000000100b0b7824ULL, 0x000fe200078e020aULL,
0x000000ff04047812ULL, 0x000fe200078ef835ULL, 0x00000000000079c5ULL, 0x004fcc0000000000ULL,
0x0000000828187df3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x000000000614783bULL, 0x000e280000004200ULL, 0x000000000710783bULL, 0x000e680000004200ULL,
0x000000000c0c783bULL, 0x000ea80000004200ULL, 0x000000000b08783bULL, 0x000ee20000004200ULL,
0x00000000040a72caULL, 0x000fc400000e0000ULL, 0x00000000050b72caULL, 0x000fe400000e0000ULL,
0x0000624014207816ULL, 0x141fe40000000015ULL, 0x0000735114217816ULL, 0x000fe40000000015ULL,
0x0000624016227816ULL, 0x140fe40000000017ULL, 0x0000735116237816ULL, 0x000fe40000000017ULL,
0x0000624010307816ULL, 0x002fc40000000011ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x0000735110317816ULL, 0x000fe40000000011ULL, 0x0000624012327816ULL, 0x140fe40000000013ULL,
0x0000735112337816ULL, 0x000fe20000000013ULL, 0x0000000820247df3ULL, 0x000fe20008000824ULL,
0x000062400c2c7816ULL, 0x144fe4000000000dULL, 0x000073510c2d7816ULL, 0x000fe4000000000dULL,
0x000062400e2e7816ULL, 0x000fc4000000000fULL, 0x000073510e2f7816ULL, 0x000fe4000000000fULL,
0x0000624008287816ULL, 0x148fe40000000009ULL, 0x0000735108297816ULL, 0x000fe40000000009ULL,
0x000062400a2a7816ULL, 0x140fe4000000000bULL, 0x000073510a2b7816ULL, 0x000fe2000000000bULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x0000100001227983ULL, 0x000ea80000300a00ULL,
0x0000080001207983ULL, 0x000ea20000300a00ULL, 0x00000000040a72caULL, 0x000fe200000e0000ULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x00000000050b72caULL, 0x000fe200000e0000ULL,
0x00000000000079c5ULL, 0x004fd80000000000ULL, 0x0000000830207df3ULL, 0x000fe60008000820ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00000000040a72caULL, 0x000fe400000e0000ULL,
0x00000000050b72caULL, 0x000fe200000e0000ULL, 0x00000000000079c5ULL, 0x000fd80000000000ULL,
0x000000082c1c7df3ULL, 0x000fe6000800081cULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00000000040a72caULL, 0x000fe400000e0000ULL, 0x00000000050b72caULL, 0x000fe200000e0000ULL,
0x00000000000079c5ULL, 0x000fd80000000000ULL, 0x0000000828187df3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0xffffffff05077890ULL, 0x000fe2000fffe03fULL,
0x00000d8000017945ULL, 0x000fea0003800000ULL, 0x0000000734007c0cULL, 0x000fda000bf05270ULL,
0x0000000c00540947ULL, 0x000fea0003800000ULL, 0x00ce1803000479a7ULL, 0x000e22000850003fULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000008000027945ULL, 0x000fe20003800000ULL, 0x0000000000067919ULL, 0x000ea20000002100ULL,
0x00ce1805000075a7ULL, 0x001e22000804017fULL, 0x0000000807077824ULL, 0x002fe200078e00ffULL,
0x000000070600780cULL, 0x004fc80004724470ULL, 0x0000001807077812ULL, 0x000fca00078ec0ffULL,
0x0000000100067824ULL, 0x000fe200078e0207ULL, 0x0000003000e0a947ULL, 0x001fec0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000001087983ULL, 0x000ea20000100800ULL,
0x0000840000077ab9ULL, 0x000fe20000000800ULL, 0x0000c20000087ab9ULL, 0x000fe20000000a00ULL,
0x00000007100d72a4ULL, 0x000fe2000f8e020cULL, 0x00cd800006047984ULL, 0x000e220000000a00ULL,
0x00000007110772a4ULL, 0x000fe2000f8e023fULL, 0x00000009ff097e24ULL, 0x000fe2000f8e00ffULL,
0x000000110d0a72a4ULL, 0x000fe2000f8e0212ULL, 0x00000000000a7919ULL, 0x000e620000002100ULL,
0x0000000607077899ULL, 0x000fe2000800063fULL, 0x0000028000027945ULL, 0x000fe20003800000ULL,
0x00009000000b7ab9ULL, 0x000fe20000000800ULL, 0x000000030d0d7899ULL, 0x000fe2000800063fULL,
0x0000000aff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000fff070774a4ULL, 0x000fc8000f8e020bULL,
0x0000000a07077291ULL, 0x000fc6000f8fa03fULL, 0x00008600000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000307077899ULL, 0x000fe4000800063fULL, 0x000002000d0a78a5ULL, 0x000fe2000f8e000aULL,
0x000000080b0b9824ULL, 0x002fe400078e020aULL, 0x0180000004067836ULL, 0x001fca0000000000ULL,
0x7f80000006067812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0600780cULL, 0x000fe20003f44070ULL,
0x00cd6000080f9984ULL, 0x004fe80000000800ULL, 0x00cd8000080e9984ULL, 0x0000640000000800ULL,
0x00000008ff087e24ULL, 0x001fe2000f8e00ffULL, 0x00000200070878a5ULL, 0x000fc6000f8e0008ULL,
0x000000080b089825ULL, 0x000fe200078e0008ULL, 0x0000000a08077287ULL, 0x000fe40008000000ULL,
0x0000000b090a7287ULL, 0x000fe40008000000ULL, 0x00000009ff0d7e24ULL, 0x000fe4000f8e00ffULL,
0x00000009ff0b7e24ULL, 0x000fe4000f8e00ffULL, 0x00000008ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x0000000aff0b7e24ULL, 0x000fc4000f8e00ffULL, 0x00000008ff0c7e24ULL, 0x000fe4000f8e00ffULL,
0x000000ffff0b9224ULL, 0x000fe400078e000dULL, 0x00000007ff0c7e24ULL, 0x000fe4000f8e00ffULL,
0x000000ffff0c9224ULL, 0x000fe400078e000aULL, 0x000000ffff0d7224ULL, 0x000fe200078e000bULL,
0x0000000e08009986ULL, 0x0021e2000c101b0eULL, 0x0000000000142947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x001fe200078e0004ULL, 0x000033b0000a7802ULL, 0x000fce0000000f00ULL,
0x0000003400647944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0004ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000400097308ULL, 0x001e240000001000ULL,
0xbf80000004067423ULL, 0x001fc80000000009ULL, 0x800000ff06067221ULL, 0x000fc80000010100ULL,
0x0000000609067223ULL, 0x000fce0000000009ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0180000005047836ULL, 0x000fe20000000000ULL, 0x000000c000027945ULL, 0x000fe80003800000ULL,
0x7f80000004047812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0400780cULL, 0x000fda0003f24070ULL,
0x0000000000101947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x000034a0000a7802ULL, 0x000fce0000000f00ULL, 0x0000003400287944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000500047308ULL, 0x000e240000001000ULL,
0xbf80000005087423ULL, 0x001fc80000000004ULL, 0x800000ff08097221ULL, 0x000fc80000010100ULL,
0x0000000904047223ULL, 0x000fce0000000004ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000040001087983ULL, 0x000ee20000100800ULL, 0x0000000000097919ULL, 0x000e220000002100ULL,
0x0000000000167919ULL, 0x000e620000002100ULL, 0x00000005ff097819ULL, 0x001fe20000011609ULL,
0x0000000608057220ULL, 0x048fe20000410000ULL, 0x0000000408067220ULL, 0x004fe40000410000ULL,
0x0000000000087919ULL, 0x000e220000000000ULL, 0x0000000524247220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x0000000526267220ULL, 0x080fe20000410000ULL,
0x0000000627277220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000522227220ULL, 0x080fe20000410000ULL, 0x000000051c1c7220ULL, 0x080fe20000410000ULL,
0x000000051e1e7220ULL, 0x080fe20000410000ULL, 0x0000000518187220ULL, 0x080fe20000410000ULL,
0x000000051a1a7220ULL, 0x000fe20000410000ULL, 0x0000000621217220ULL, 0x080fe20000410000ULL,
0x0000000623237220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x000000061f1f7220ULL, 0x080fe20000410000ULL, 0x0000000619197220ULL, 0x080fe20000410000ULL,
0x000000061b1b7220ULL, 0x000fe20000410000ULL, 0x000000242505723eULL, 0x000fc400000010ffULL,
0x00000026270a723eULL, 0x000fe400000010ffULL, 0x0000001e1f0b723eULL, 0x000fe200000010ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000000505723aULL, 0x000fe20000000000ULL,
0x00000018190e723eULL, 0x000fe400000010ffULL, 0x0000001a1b0f723eULL, 0x000fe200000010ffULL,
0x000000000a0a723aULL, 0x000ea20000000000ULL, 0x00000002ff047819ULL, 0x001fe20000011608ULL,
0x0000001009087824ULL, 0x000fc600078e00ffULL, 0x0000000309117812ULL, 0x000fe200078e7804ULL,
0x0000004008067836ULL, 0x040fe40000000000ULL, 0x0000008008097836ULL, 0x040fe40000000000ULL,
0x000000c008107836ULL, 0x000fe20000000000ULL, 0x00000004ff137819ULL, 0x000fe20000011606ULL,
0x0000001004117824ULL, 0x000fe200078e0211ULL, 0x00000004ff157819ULL, 0x000fe40000011609ULL,
0x000000202106723eULL, 0x000fc400000010ffULL, 0x000000222309723eULL, 0x000fe400000010ffULL,
0x0000001c1d08723eULL, 0x000fe400000010ffULL, 0x000000000606723aULL, 0x000fe20000000000ULL,
0x00000004ff177819ULL, 0x000fe20000011610ULL, 0x0000002011107824ULL, 0x000fe200078e0202ULL,
0x0000000313137812ULL, 0x000fe200078e7804ULL, 0x000000000909723aULL, 0x000e220000000000ULL,
0x0000000315157812ULL, 0x000fe200078e7804ULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x0000000317177812ULL, 0x000fe200078e7804ULL, 0x000000000808723aULL, 0x000fe20000000000ULL,
0x0000001004137824ULL, 0x000fc400078e0213ULL, 0x0000001004157824ULL, 0x040fe200078e0215ULL,
0x000000000b0b723aULL, 0x000ee20000000000ULL, 0x0000001004177824ULL, 0x000fe200078e0217ULL,
0x0000541005047816ULL, 0x004fe2000000000aULL, 0x0000002015127824ULL, 0x000fe200078e0202ULL,
0x000000000e0e723aULL, 0x000fe20000000000ULL, 0x0000763205057816ULL, 0x000fe2000000000aULL,
0x00000020130a7824ULL, 0x000fe400078e0202ULL, 0x000000000f0f723aULL, 0x000ea20000000000ULL,
0x0000000107127824ULL, 0x040fe200078e0212ULL, 0x000001f000027945ULL, 0x000fe20003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x0000000410007388ULL, 0x0001e20000000a00ULL,
0x0000002017147824ULL, 0x000fc800078e0202ULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x0000541006047816ULL, 0x141fe40000000009ULL, 0x0000763206057816ULL, 0x000fca0000000009ULL,
0x000000040a007388ULL, 0x0007e40000000a00ULL, 0x00005410080a7816ULL, 0x148fe4000000000bULL,
0x00007632080b7816ULL, 0x000fe4000000000bULL, 0x0000001f16087812ULL, 0x002fc600078ec0ffULL,
0x0000000a12007388ULL, 0x0005e20000000a00ULL, 0x00000001ff087819ULL, 0x000fe40000011608ULL,
0x000054100e0a7816ULL, 0x144fe4000000000fULL, 0x000076320e0b7816ULL, 0x000fe2000000000fULL,
0x00000010160e7824ULL, 0x000fe200078e00ffULL, 0x00000005ff0f7819ULL, 0x000fc60000011616ULL,
0x0000000a14007388ULL, 0x0001e20000000a00ULL, 0x00ce1803000679a7ULL, 0x000e62000850003fULL,
0x000000040f097836ULL, 0x000fe20000000000ULL, 0x0000000308047812ULL, 0x000fc800078e780fULL,
0x0000000308087812ULL, 0x000fe200078e7809ULL, 0x000000100f057824ULL, 0x000fe200078e0204ULL,
0x000000100e047812ULL, 0x000fc600078ec0ffULL, 0x0000001009097824ULL, 0x000fe400078e0208ULL,
0x0000002005057824ULL, 0x100fe400078e0202ULL, 0x0000002009097824ULL, 0x000fe400078e0202ULL,
0x0000000105057824ULL, 0x000fe400078e0204ULL, 0x0000000104097824ULL, 0x000fe200078e0209ULL,
0x00ce1807000075a7ULL, 0x002e64000802017fULL, 0x0000002800789947ULL, 0x003fea0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000005047984ULL, 0x000e220000000c00ULL,
0x000002000f0c7825ULL, 0x000fe200078e000cULL, 0x000001f00e0f7812ULL, 0x000fe200078ec0ffULL,
0x000000b000027945ULL, 0x000fe20003800000ULL, 0x0000000009087984ULL, 0x000e640000000c00ULL,
0x0000000f0c0c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000000027919ULL, 0x000ea80000002100ULL,
0x000000ffff0d7224ULL, 0x000fca00008e060dULL, 0x000000040c007986ULL, 0x0011e2000c101d0eULL,
0x000000ff0200720cULL, 0x004fc60004705670ULL, 0x000800080c007986ULL, 0x0021e2000c101d0eULL,
0x00ce1803000e79a7ULL, 0x000e64000850003fULL, 0x00ce180f000075a7ULL, 0x002e64000802017fULL,
0x0000002800549947ULL, 0x003fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000000640947ULL, 0x000fea0003800000ULL, 0x0000840000077ab9ULL, 0x000fe20000000800ULL,
0x0000c00000087ab9ULL, 0x000fe20000000a00ULL, 0x00000007100772a4ULL, 0x000fe4000f8e020cULL,
0xffffffff060a7890ULL, 0x000fe4000fffe03fULL, 0x00000004070878a5ULL, 0x000fc8000f8e0008ULL,
0x0000000aff097e24ULL, 0x000fe4000f8e00ffULL, 0x00000008ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000009ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0001ec0000008000ULL,
0x0000000000007992ULL, 0x001fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000009040479a8ULL, 0x000ea800099ee1ceULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000879c3ULL, 0x000e220000008800ULL,
0x0000040000077882ULL, 0x000fc40000000000ULL, 0x0000065408077896ULL, 0x001fcc0008000007ULL,
0x00000007ff007e24ULL, 0x000fe2000f8e00ffULL, 0x0000000a04007c0cULL, 0x000fc8000bf05270ULL,
0x00000001ff077807ULL, 0x000fca0000000000ULL, 0x00ce200700007388ULL, 0x0001e80000000000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000134057812ULL, 0x040fe200078ec0ffULL,
0x0000000134347836ULL, 0x000fc80000000000ULL, 0x0000001005027824ULL, 0x000fe200078e0200ULL,
0x0000000534007c0cULL, 0x000fc6000bf06070ULL, 0x00cdf80302ff79a7ULL, 0x0003e2000850003fULL,
0x00cdd80302ff79a7ULL, 0x0003f2000850003fULL, 0xffffffe000108947ULL, 0x003fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000ec7947ULL, 0x000fea0003800000ULL,
0x0000000001047983ULL, 0x000ea20000300800ULL, 0x00009200ff067b82ULL, 0x000e220000000a00ULL,
0x0000000000037919ULL, 0x002e640000002100ULL, 0x0000000e06067981ULL, 0x001162000c1e9900ULL,
0x000000070300780cULL, 0x002fe20003f04070ULL, 0x00000001ff037424ULL, 0x000fc800078e00ffULL,
0x00cda80300ff79a7ULL, 0x0001f0000850003fULL, 0xff317217ff088424ULL, 0x000fe200078e00ffULL,
0x00cdb80300ff79a7ULL, 0x0001e2000850003fULL, 0x00cdc80300ff79a7ULL, 0x0001e6000850003fULL,
0x00cd400804008388ULL, 0x0043e40000000800ULL, 0x00ce1003000479a7ULL, 0x002e64000850003fULL,
0x00ce1005000075a7ULL, 0x002e64000800017fULL, 0x0000002400a08947ULL, 0x003fea0003800000ULL,
0x00cda003000479a7ULL, 0x000e24000850003fULL, 0x00cda005000075a7ULL, 0x001e24000800017fULL,
0x0000002400ac8947ULL, 0x001fea0003800000ULL, 0x0000000000077919ULL, 0x000e220000002100ULL,
0x000000040600728cULL, 0x000fcc000bf24070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x00000005ff047819ULL, 0x001fd60000011607ULL, 0x0000001000900947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e220000000000ULL, 0x0000001004087824ULL, 0x000fe400078e00ffULL,
0x3d80000006067820ULL, 0x020fe20000410000ULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x0000000805087211ULL, 0x001fce00078ff0ffULL, 0x00000040ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00cdb00d000a79a7ULL, 0x000e24000800003fULL,
0x00cdb00b000075a7ULL, 0x001e24000800017fULL, 0x0000002400888947ULL, 0x001fea0003800000ULL,
0x00000000000d72caULL, 0x040fe200000e0000ULL, 0x00000400000a7824ULL, 0x040fe200078e00ffULL,
0x0003fff000097812ULL, 0x040fe200078ec0ffULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x000003ff00ff7812ULL, 0x000fe4000780c0ffULL, 0x00000004ff097819ULL, 0x000fe40000011609ULL,
0x000e00000a0b7812ULL, 0x000fe400078ec0ffULL, 0x00003f00090a7812ULL, 0x000fc400078ec0ffULL,
0x000000ff0b0b7207ULL, 0x000fe20000000000ULL, 0x0000c4000d077890ULL, 0x000fe2000fffe03fULL,
0x000000ff0a0a7812ULL, 0x000fe400078ef809ULL, 0x400000400b097812ULL, 0x000fe200078efcffULL,
0x000003ff073f7892ULL, 0x000fe2000f82c03fULL, 0x000000000a0b72caULL, 0x000fe200000e0000ULL,
0x0000000a07087899ULL, 0x000fe2000800063fULL, 0x00000000090972caULL, 0x000fe200000e0000ULL,
0x0003fff007077892ULL, 0x000fe2000f8ec03fULL, 0x0000002000097836ULL, 0x000fe20000000000ULL,
0x000e0000080a7892ULL, 0x000fc4000f8ec03fULL, 0x000000043f087899ULL, 0x000fe40008011607ULL,
0x0000003f0a077287ULL, 0x000fe20008800000ULL, 0x0003fff009097812ULL, 0x000fe200078ec0ffULL,
0x00003f00080a7892ULL, 0x000fe4000f8ec03fULL, 0x4000004007077892ULL, 0x000fe2000f8efc3fULL,
0x00000004ff097819ULL, 0x000fe20000011609ULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00003f00090a7812ULL, 0x000fe200078ec0ffULL,
0x00000007000b7c82ULL, 0x000fc60008000000ULL, 0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL,
0x00000000081879f3ULL, 0x000fe2000c0008ffULL, 0x0000c4200d087890ULL, 0x000fe2000fffe03fULL,
0x0000004000097836ULL, 0x000fe20000000000ULL, 0x000000000a0b72caULL, 0x000fe400000e0000ULL,
0x0003fff008087892ULL, 0x000fe4000f8ec03fULL, 0x0003fff009097812ULL, 0x000fe400078ec0ffULL,
0x000000043f087899ULL, 0x000fc40008011608ULL, 0x00000004ff097819ULL, 0x000fe40000011609ULL,
0x00003f00080a7892ULL, 0x000fe4000f8ec03fULL, 0x00003f00090a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff0a0a7892ULL, 0x000fe4000f8ef808ULL, 0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fe20008000000ULL,
0x0000006000097836ULL, 0x000fca0000000000ULL, 0x0003fff009097812ULL, 0x000fc800078ec0ffULL,
0x00000004ff097819ULL, 0x000fe20000011609ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00000000000079c5ULL, 0x000fcc0000000000ULL, 0x00000000081879f3ULL, 0x000fe20008000818ULL,
0x0000c4400d087890ULL, 0x000fe2000fffe03fULL, 0x000000000a0b72caULL, 0x000fe400000e0000ULL,
0x00003f00090a7812ULL, 0x000fe200078ec0ffULL, 0x0003fff008087892ULL, 0x000fc6000f8ec03fULL,
0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL, 0x000000043f087899ULL, 0x000fe20008011608ULL,
0x0000200000097836ULL, 0x000fc60000000000ULL, 0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00000000000079c5ULL, 0x000fcc0000000000ULL, 0x00000000081879f3ULL, 0x000fe20008000818ULL,
0x0000c4600d087890ULL, 0x000fe2000fffe03fULL, 0x000000000a0b72caULL, 0x000fc600000e0000ULL,
0x0003fff008087892ULL, 0x000fc8000f8ec03fULL, 0x000000043f087899ULL, 0x000fc80008011608ULL,
0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fe20008000000ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00000000000079c5ULL, 0x000fcc0000000000ULL,
0x00000000081879f3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00cdb80300ff79a7ULL, 0x0001e2000850003fULL, 0x00cdc00d000a79a7ULL, 0x000e64000800003fULL,
0x00cdc00b000075a7ULL, 0x002e64000800017fULL, 0x0000002000608947ULL, 0x003fea0003800000ULL,
0x00000000000d72caULL, 0x000fe200000e0000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x0003fff009097812ULL, 0x000fc800078ec0ffULL, 0x00000004ff097819ULL, 0x000fc80000011609ULL,
0x00003f00090a7812ULL, 0x000fc600078ec0ffULL, 0x0000c8000d087890ULL, 0x000fe2000fffe03fULL,
0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL, 0x0000202000097836ULL, 0x000fe40000000000ULL,
0x0003fff008087892ULL, 0x000fe2000f8ec03fULL, 0x000000000a0b72caULL, 0x000fe400000e0000ULL,
0x0003fff009097812ULL, 0x000fe200078ec0ffULL, 0x000000043f087899ULL, 0x000fc60008011608ULL,
0x00000004ff097819ULL, 0x000fe20000011609ULL, 0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL,
0x00003f00090a7812ULL, 0x000fe200078ec0ffULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fe20008000000ULL,
0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL, 0x0000204000097836ULL, 0x000fc60000000000ULL,
0x00000000081879f3ULL, 0x000fe20008000818ULL, 0x0000c8200d087890ULL, 0x000fe2000fffe03fULL,
0x000000000a0b72caULL, 0x000fe400000e0000ULL, 0x0003fff009097812ULL, 0x000fe200078ec0ffULL,
0x0003fff008087892ULL, 0x000fc6000f8ec03fULL, 0x00000004ff097819ULL, 0x000fe20000011609ULL,
0x000000043f087899ULL, 0x000fc60008011608ULL, 0x00003f00090a7812ULL, 0x000fe200078ec0ffULL,
0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL, 0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL,
0x000000ff0a0a7892ULL, 0x000fe2000f8ef808ULL, 0x0000206000097836ULL, 0x000fe40000000000ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fe40008000000ULL,
0x0003fff009097812ULL, 0x000fc800078ec0ffULL, 0x00000004ff097819ULL, 0x000fe20000011609ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00000000000079c5ULL, 0x000fcc0000000000ULL,
0x00000000081879f3ULL, 0x000fe20008000818ULL, 0x0000c8400d087890ULL, 0x000fe2000fffe03fULL,
0x000000000a0b72caULL, 0x000fe400000e0000ULL, 0x00003f00090a7812ULL, 0x000fe200078ec0ffULL,
0x0003fff008087892ULL, 0x000fc6000f8ec03fULL, 0x000000ff0a0a7812ULL, 0x000fe200078ef809ULL,
0x000000043f087899ULL, 0x000fc80008011608ULL, 0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00000000000079c5ULL, 0x000fcc0000000000ULL, 0x00000000081879f3ULL, 0x000fe20008000818ULL,
0x0000c8600d087890ULL, 0x000fe2000fffe03fULL, 0x000000000a0b72caULL, 0x000fe200000e0000ULL,
0x00000014ff0a7e24ULL, 0x000fe4000f8e00ffULL, 0x0003fff008087892ULL, 0x000fe4000f8ec03fULL,
0x0000000607097c24ULL, 0x000fe4000f8e020aULL, 0x000000043f087899ULL, 0x000fe40008011608ULL,
0x00000001090a7836ULL, 0x000fc40000000000ULL, 0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL,
0x000000130a007c0cULL, 0x000fe2000bf05270ULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fe20008000000ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00000000000079c5ULL, 0x000fcc0000000000ULL,
0x00000000081879f3ULL, 0x000fe60008000818ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00cdc80300ff79a7ULL, 0x0001e2000850003fULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061a0f7220ULL, 0x080fe20000410000ULL,
0x000000061b107220ULL, 0x000fe20000410000ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x0000004009097824ULL, 0x000fca00078e00ffULL, 0x00000009020a7248ULL, 0x000fca0007fe0000ULL,
0x000000010a097824ULL, 0x000fe400078e0a09ULL, 0x00000008080a7836ULL, 0x000fc60000000000ULL,
0x000000090800720cULL, 0x080fe40003f06070ULL, 0x000000090a00720cULL, 0x000fe40003f26070ULL,
0xff80000018187808ULL, 0x000fe40004000000ULL, 0xff80000019197808ULL, 0x000fe40004000000ULL,
0xff8000000f0f7808ULL, 0x000fe40004800000ULL, 0xff80000010107808ULL, 0x000fce0004800000ULL,
0x000000180f097209ULL, 0x000fe40007810000ULL, 0x00000019100b7209ULL, 0x000fe40007810000ULL,
0x000000030500780cULL, 0x000fe20003f04070ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0e001f00090a7f89ULL, 0x000e6800000e0000ULL, 0x0e001f000b0c7f89ULL, 0x000ea200000e0000ULL,
0x0000000a090a7209ULL, 0x002fc40007810000ULL, 0x0000000c0b0c7209ULL, 0x004fc60007810000ULL,
0x0d001f000a0d7f89ULL, 0x000e6800000e0000ULL, 0x0d001f000c117f89ULL, 0x000ea200000e0000ULL,
0x0000000d0a0d7209ULL, 0x002fe40007810000ULL, 0x000000110c117209ULL, 0x004fc60007810000ULL,
0x0c801f000d0e7f89ULL, 0x000e6800000e0000ULL, 0x0c801f0011127f89ULL, 0x000ea200000e0000ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000000e0d0e7209ULL, 0x002fe40007810000ULL,
0x0000001211127209ULL, 0x004fe20007810000ULL, 0x0000000000340947ULL, 0x000fec0003800000ULL,
0x000000ff0e00720bULL, 0x000fe20003f36000ULL, 0x0000006000017945ULL, 0x000fe20003800000ULL,
0x0000000805097824ULL, 0x000fd600078e0200ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x00cd400e09ff738cULL, 0x0003e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x00cd400e09ff738cULL, 0x0003e40000800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff1200720bULL, 0x000fda0003f36000ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x00cd441209ff738cULL, 0x0005e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x00cd441209ff738cULL, 0x0005e40000800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00ce1003000a79a7ULL, 0x000ee2000850003fULL, 0x0000000805097824ULL, 0x006fca00078e00ffULL,
0x00000018090d7812ULL, 0x000fca00078ec0ffULL, 0x0000000100127824ULL, 0x000fe200078e020dULL,
0x00ce100b000075a7ULL, 0x008e64000802017fULL, 0x0000001800909947ULL, 0x002fea0003800000ULL,
0x00cd4000120a7984ULL, 0x000e620000000a00ULL, 0x00ce1003000c79a7ULL, 0x000ea4000850003fULL,
0x00ce100d000075a7ULL, 0x004ea2000802017fULL, 0x3fb8aa3b0a117820ULL, 0x002fc80000410000ULL,
0x3fb8aa3b180e7823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fe20000010811ULL,
0x3fb8aa3b0b117820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b10107823ULL, 0x000fe20000010811ULL, 0x0000000e000e7308ULL, 0x000ff00000000800ULL,
0x0000000f000f7308ULL, 0x000e700000000800ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x0000000f0e117221ULL, 0x002fce0000010000ULL, 0x0000001000107308ULL, 0x000e640000000800ULL,
0x0000001019127221ULL, 0x002fc20000010000ULL, 0x0000001800689947ULL, 0x004fec0003800000ULL,
0x0e001f00110c7f89ULL, 0x000e6200000e0000ULL, 0x000000070500780cULL, 0x000fe20003f24070ULL,
0x000001c000007945ULL, 0x000fe20003800000ULL, 0x00000001071b7812ULL, 0x000fe200078ec0ffULL,
0x0e001f00120d7f89ULL, 0x000ea200000e0000ULL, 0x000000ffff157224ULL, 0x000fc600078e00ffULL,
0x000000101b187824ULL, 0x000fe400078e0200ULL, 0x0000000c110c7221ULL, 0x002fc20000010000ULL,
0x0000000d120d7221ULL, 0x004fc80000010000ULL, 0x0d001f000c137f89ULL, 0x000e6800000e0000ULL,
0x0d001f000d147f89ULL, 0x000ea200000e0000ULL, 0x000000130c137221ULL, 0x002fc20000010000ULL,
0x000000140d147221ULL, 0x004fc80000010000ULL, 0x0c801f0013127f89ULL, 0x0002a800000e0000ULL,
0x0c801f0014117f89ULL, 0x0002e200000e0000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000779c3ULL, 0x000f220000003000ULL, 0x00000001ff0d7819ULL, 0x000fe20000011605ULL,
0x0000000405157824ULL, 0x040fe200078e00ffULL, 0x00000006050c7812ULL, 0x000fe400078ec0ffULL,
0x7ffffffc0d0d7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff0c7819ULL, 0x000fe4000001160cULL,
0x0000001c15167812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x000fca00078e0204ULL,
0x0000000c0d0d7212ULL, 0x000fca00078e3cffULL, 0x000000010d0d7824ULL, 0x000fe400078e0216ULL,
0x0000000700177c36ULL, 0x010fc80008000000ULL, 0x000042001b0c7824ULL, 0x000fc800078e0217ULL,
0x000000100d0c7824ULL, 0x000fc800078e020cULL, 0x000040000c157836ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00cdf803180c79a7ULL, 0x000f24000850003fULL,
0x00cdf80d180075a7ULL, 0x010f24000802017fULL, 0x0000001400f89947ULL, 0x010fea0003800000ULL,
0x00000000000779c3ULL, 0x000f220000003000ULL, 0x43e000000e0e7820ULL, 0x000fe20000410000ULL,
0x43e000000f0f7820ULL, 0x000fe20000410000ULL, 0x43e0000019197820ULL, 0x000fe20000410000ULL,
0x43e0000010107820ULL, 0x000fe20000410000ULL, 0x0000001213127221ULL, 0x004fc20000010000ULL,
0x0000001114117221ULL, 0x008fe20000010000ULL, 0x0000000e0f0e723eULL, 0x000fe4000480710eULL,
0x000000191010723eULL, 0x000fc80004807110ULL, 0x000054100e0e7816ULL, 0x000fe20000000010ULL,
0x80000007150c7c36ULL, 0x010fe20008000000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000e0c007844ULL, 0x0007e20000004000ULL, 0x000000c000007945ULL, 0x000fe80003800000ULL,
0x0000000000280947ULL, 0x008fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe20003f05270ULL,
0x000000801b0d7824ULL, 0x140fe400078e0200ULL, 0x000000201b0c7824ULL, 0x004fe400078e0200ULL,
0x00000020040e7824ULL, 0x000fe400078e020dULL, 0x00000001090c7824ULL, 0x000fe400078e020cULL,
0x00000008050e7824ULL, 0x000fc800078e020eULL, 0x00cc000a0c008388ULL, 0x0005e80000000800ULL,
0x00cc40120e007388ULL, 0x0005e80000000800ULL, 0x00cc040b0c008388ULL, 0x0005e80000000800ULL,
0x00cc44110e007388ULL, 0x0005e40000000800ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000107077836ULL, 0x000fe20000000000ULL, 0x00cdf00318ff79a7ULL, 0x0007e8000850003fULL,
0x0000000507007c0cULL, 0x000fda000bf06070ULL, 0xffffffec00848947ULL, 0x00ffea000383ffffULL,
0x00cda80300ff79a7ULL, 0x0001e4000850003fULL, 0x0000000000047919ULL, 0x021e220000002300ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000783f077890ULL, 0x000fe2000ff3e03fULL, 0x000000000000781cULL, 0x000fc60003f2f008ULL,
0x0000003f3f087290ULL, 0x000fe20008ffe43fULL, 0x0000010000097ab9ULL, 0x000fe20000000800ULL,
0x0000000000057919ULL, 0x000e240000002200ULL, 0x0000000307077899ULL, 0x000fe20008001208ULL,
0x0000000000067919ULL, 0x000ea40000002100ULL, 0x0000000000087ab9ULL, 0x000fe20000000800ULL,
0x0000000107077890ULL, 0x000fe2000fffe03fULL, 0x0000000904027c24ULL, 0x001fc8000f8e0205ULL,
0x0000000802037c24ULL, 0x006fca000f8e0206ULL, 0x0000000703007c0cULL, 0x000fda000bf06070ULL,
0x0000000803008824ULL, 0x000fc800078e0200ULL, 0x00cda000000089b1ULL, 0x000064000800003fULL,
0x000000000000994dULL, 0x002fea0003800000ULL, 0x00000000000879c3ULL, 0x000ea20000008800ULL,
0x0000040000077882ULL, 0x000fe40000000000ULL, 0x0000065408077896ULL, 0x004fd20008000007ULL,
0x00ce2007ff007984ULL, 0x003e240008000000ULL, 0x000000ff0000720cULL, 0x001fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000405ff7212ULL, 0x000fc8000784fcffULL, 0x000000040600780cULL, 0x000fda0005741070ULL,
0x00000000005ca947ULL, 0x000fea0003800000ULL, 0x0000000706007c11ULL, 0x000fe2000f8e20ffULL,
0x001ffffe00047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x7ffff80000057882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x00000000000812caULL, 0x001fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x00410004083f75b2ULL, 0x0020b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001ffe0000047882ULL, 0x001fe20000000000ULL, 0x7ff8000000057882ULL, 0x000fd60000000000ULL,
0x00000000000812caULL, 0x001fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x00410804083f75b2ULL, 0x0020b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x00000100ff057424ULL, 0x000fc800078e00ffULL, 0x0041080500ff79a7ULL, 0x0023e6000850003fULL,
0x00000005ff037819ULL, 0x000fe20000011603ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001fff03037589ULL, 0x000ea400000e0000ULL, 0x00000000030572caULL, 0x005fe200000e0000ULL,
0x0000000000007b1dULL, 0x000fd80000010000ULL, 0x000000080500788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000400108947ULL, 0x000fea0003800000ULL,
0x0000000b05067890ULL, 0x000fc8000fffe106ULL, 0x000000023f067899ULL, 0x000fcc0008011606ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800cc8947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e220000000000ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000900000097ab9ULL, 0x000fe20000000800ULL, 0x00000004110872a4ULL, 0x000fe4000f8e023fULL,
0x00000004100472a4ULL, 0x000fe4000f8e020cULL, 0x0000000608087899ULL, 0x000fe4000800063fULL,
0xfffffff8050a7890ULL, 0x000fe4000fffe03fULL, 0x00000011040572a4ULL, 0x000fc4000f8e023fULL,
0x00000fff081274a4ULL, 0x000fe2000f8e0209ULL, 0x0000003f00047c82ULL, 0x000fd60008000000ULL,
0x0000000a04087291ULL, 0x000fe2000f8e103fULL, 0x000000070700780cULL, 0x041fe20003f24070ULL,
0x0000000104047890ULL, 0x000fe2000fffe03fULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000000408097892ULL, 0x000fe4000f8ec03fULL, 0x00000004080b7899ULL, 0x000fe4000800063fULL,
0x000000023f097899ULL, 0x000fe40008011609ULL, 0x000000300b0b7892ULL, 0x000fc4000f8ec03fULL,
0x0000001f09097899ULL, 0x000fe4000800063fULL, 0x000000060400728cULL, 0x000fe4000bf06070ULL,
0x0000000bff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000805137290ULL, 0x000fe2000fffe03fULL,
0x00000009ff007e24ULL, 0x002fe2000f8e00ffULL, 0x00000003080d7892ULL, 0x000fe4000f8ec03fULL,
0x0000000b070b7290ULL, 0x000fe4000fffe03fULL, 0x00410800030075a7ULL, 0x000e240008060147ULL,
0x00000010002cb947ULL, 0x001ff00003800000ULL, 0x0000013000007945ULL, 0x000fe80003800000ULL,
0x0000000000441947ULL, 0x000fea0003800000ULL, 0x0000c20000087ab9ULL, 0x000fe20000000a00ULL,
0x000000070d0b7291ULL, 0x000fe4000f8e303fULL, 0x00000040130878a5ULL, 0x000fc8000f8e0008ULL,
0x0000000b07057c11ULL, 0x040fe4000f8e18ffULL, 0x00000008ff027e24ULL, 0x000fe2000f8e00ffULL,
0x000000070d087291ULL, 0x000fe2000f8e203fULL, 0x00000009ff037e24ULL, 0x000fe4000f8e00ffULL,
0x0000000807027825ULL, 0x000fca00078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0400000002057faeULL, 0x0001e2000b921a4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000410008087890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200408ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a88ULL, 0x0000000000007918ULL, 0x001fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x00000000002c0947ULL, 0x000fea0003800000ULL, 0x00000013120b7291ULL, 0x000fe2000f8fa03fULL,
0x00001000ff007424ULL, 0x000fe200078e00ffULL, 0x000000070d167291ULL, 0x000fe2000f8e203fULL,
0x0000c20000087ab9ULL, 0x000fe20000000a00ULL, 0x000000070d147291ULL, 0x000fe4000f8e603fULL,
0x000010000b0878a5ULL, 0x000fe4000f8e0008ULL, 0x0000410016157890ULL, 0x000fe2000fffe03fULL,
0x00000100000b7882ULL, 0x000fd00000000000ULL, 0x00000014080073baULL, 0x0001e2000800020bULL,
0x00410000ffff79a7ULL, 0x0001e40008000016ULL, 0x0000000000007918ULL, 0x001fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0xfffffffc002c8947ULL, 0x000fea000383ffffULL, 0x0000000400cc7947ULL, 0x000fea0003800000ULL,
0x0000000000187919ULL, 0x000e220000000000ULL, 0x00000006ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000400488947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0xff317217ff107424ULL, 0x000fe200078e00ffULL, 0x0000000000087805ULL, 0x000fe4000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x002fe200078e00ffULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000003f00047c82ULL, 0x000fcc0008000000ULL,
0x0000000404087892ULL, 0x000fe4000f8ec03fULL, 0x0000000404097899ULL, 0x000fe4000800063fULL,
0x000000023f087899ULL, 0x000fe40008011608ULL, 0x0000003009097892ULL, 0x000fe4000f8ec03fULL,
0x0000001f080b7899ULL, 0x000fe4000800063fULL, 0x00000003040d7892ULL, 0x000fc4000f8ec03fULL,
0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000907097290ULL, 0x000fe2000fffe03fULL,
0x0000000bff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000070d0a7291ULL, 0x000fe4000f8e603fULL,
0x000000070d087291ULL, 0x000fe4000f8e303fULL, 0x00410002030075a7ULL, 0x000e620008000147ULL,
0x0000000a050a7291ULL, 0x000fe4000f8e483fULL, 0x0000000805087291ULL, 0x000fc8000f8e183fULL,
0x0000000a18047c11ULL, 0x001fe2000f8e20ffULL, 0x0000000c00548947ULL, 0x002fee0003800000ULL,
0x00400008ff027984ULL, 0x000e220008000a00ULL, 0x0000000104047890ULL, 0x000fc6000fffe03fULL,
0x0000000004047984ULL, 0x000e620000000c00ULL, 0x000000060400728cULL, 0x000fe2000bf06070ULL,
0x000000100300720bULL, 0x001fe40003f14000ULL, 0x0000763205127816ULL, 0x042fe20000000012ULL,
0x0001000005157824ULL, 0x000fe200078e00ffULL, 0x0000763206057816ULL, 0x040fe20000000005ULL,
0x0001000006167824ULL, 0x000fe200078e00ffULL, 0x0000763204117816ULL, 0x000fe20000000011ULL,
0x0001000012177824ULL, 0x000fe200078e00ffULL, 0x0000763207067816ULL, 0x000fe20000000006ULL,
0x0001000004137824ULL, 0x000fc400078e00ffULL, 0x00010000071b7824ULL, 0x000fe400078e00ffULL,
0x0001000011147824ULL, 0x000fe400078e00ffULL, 0x0001000005197824ULL, 0x000fe400078e00ffULL,
0x0001000006127824ULL, 0x000fe200078e00ffULL, 0x0000000000380947ULL, 0x000fec0003800000ULL,
0x0000000310037221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b03037820ULL, 0x000fcc0000410000ULL,
0x0000000300037308ULL, 0x000e240000000800ULL, 0x0000000302057220ULL, 0x001fc80000410000ULL,
0x00000005130e7223ULL, 0x080fe2000001000eULL, 0x00000005140d7223ULL, 0x080fe2000001000dULL,
0x00000005150c7223ULL, 0x080fe2000001000cULL, 0x0000000517007223ULL, 0x080fe20000010000ULL,
0x00000005160b7223ULL, 0x080fe2000001000bULL, 0x0000000519087223ULL, 0x080fe20000010008ULL,
0x000000051b0a7223ULL, 0x080fe2000001000aULL, 0x0000000512097223ULL, 0x000fe20000010009ULL,
0x0000000f050f7221ULL, 0x000fe20000010000ULL, 0x0000000000547947ULL, 0x000fec0003800000ULL,
0x8000000310047221ULL, 0x000fe20000010000ULL, 0x0000001302077220ULL, 0x040fe20000410000ULL,
0x0000001502117220ULL, 0x040fe20000410000ULL, 0x0000001702137220ULL, 0x000fe20000410000ULL,
0x3fb8aa3b04047820ULL, 0x000fe20000410000ULL, 0x0000001602107220ULL, 0x040fe20000410000ULL,
0x0000001402067220ULL, 0x040fe20000410000ULL, 0x0000001902157220ULL, 0x040fe20000410000ULL,
0x0000000400057308ULL, 0x000e220000000800ULL, 0x0000001b02177220ULL, 0x040fe20000410000ULL,
0x0000001202127220ULL, 0x000fe20000410000ULL, 0x0000000b050b7223ULL, 0x041fe20000010010ULL,
0x0000000f050f7223ULL, 0x040fe20000010002ULL, 0x0000000e050e7223ULL, 0x040fe20000010007ULL,
0x0000000d050d7223ULL, 0x040fe20000010006ULL, 0x0000000c050c7223ULL, 0x040fe20000010011ULL,
0x0000000005007223ULL, 0x040fe20000010013ULL, 0x0000000805087223ULL, 0x040fe20000010015ULL,
0x0000000a050a7223ULL, 0x040fe20000010017ULL, 0x0000000905097223ULL, 0x000fe20000010012ULL,
0x000000ffff107224ULL, 0x000fce00078e0003ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000070d087291ULL, 0x000fe2000f8e203fULL, 0x00000001ff027424ULL, 0x000fd000078e00ffULL,
0x00410802ffff79a7ULL, 0x0001e60008500008ULL, 0xfffffff800d88947ULL, 0x001fea000383ffffULL,
0x0000000000147947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000087805ULL, 0x000fe4000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x002fe200078e00ffULL, 0x00000000000c7805ULL, 0x000fce000001ff00ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000f000f7308ULL, 0x000e620000001000ULL,
0x00000004100472a4ULL, 0x000fe2000f8e020cULL, 0x0000000818057824ULL, 0x001fe200078e00ffULL,
0x0000860000087ab9ULL, 0x000fe40000000a00ULL, 0x0000000504057291ULL, 0x000fc8000f80183fULL,
0x0000003f3f067290ULL, 0x000fe400087fe43fULL, 0x0000000805047291ULL, 0x000fc8000f80483fULL,
0x0000000905057291ULL, 0x000fe200080f4c06ULL, 0x0000000e0f0e7220ULL, 0x042fe20000410000ULL,
0x0000000d0f0d7220ULL, 0x040fe20000410000ULL, 0x0000000c0f0c7220ULL, 0x040fe20000410000ULL,
0x0000000b0f0b7220ULL, 0x040fe20000410000ULL, 0x0000000a0f0a7220ULL, 0x040fe20000410000ULL,
0x000000090f097220ULL, 0x040fe20000410000ULL, 0x000000080f087220ULL, 0x040fe20000410000ULL,
0x00000004ff027e24ULL, 0x000fe4000f8e00ffULL, 0x000000000f0f7220ULL, 0x000fe20000410000ULL,
0x00000005ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000a0907723eULL, 0x000fc400000010ffULL,
0x0000000b0806723eULL, 0x000fe200000010ffULL, 0x0000000205027825ULL, 0x000fe200078e0002ULL,
0x0000000c0f05723eULL, 0x000fe400000010ffULL, 0x0000000e0d04723eULL, 0x000fca00000010ffULL,
0x0000000402007986ULL, 0x0001e4000c101d0eULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000000a94dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e240000002100ULL,
0x0000000700007c11ULL, 0x001fc8000f8e20ffULL, 0x00410800000079b1ULL, 0x000e24000800003fULL,
0x00410000000079b1ULL, 0x001fe2000800003fULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00cdd803090075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdd803090085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffa400f87947ULL, 0x000fea000383ffffULL,
0x00cdb803000075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdb803000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffa8008c7947ULL, 0x000fea000383ffffULL,
0x00cdc803000075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdc803000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffa800c47947ULL, 0x000fea000383ffffULL,
0x00cda803000075a7ULL, 0x000022000802017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00cda803000095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffac009c7947ULL, 0x020fea000383ffffULL,
0x00ce1803000075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00ce1803000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffb800847947ULL, 0x020fea000383ffffULL,
0x00cdd003070075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdd003070085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffb800d47947ULL, 0x000fea000383ffffULL,
0x00cdf0030b0075a7ULL, 0x000022000802017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00cdf0030b0095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffb800ec7947ULL, 0x000fea000383ffffULL,
0x00ce1805000075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00ce1805000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffc000a87947ULL, 0x000fea000383ffffULL,
0x00ce1805000075a7ULL, 0x000022000804017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00ce18050000a5a7ULL, 0x000e24000804007fULL,
0xfffffffc00eca947ULL, 0x001fea000383ffffULL, 0xffffffcc00087947ULL, 0x000fea000383ffffULL,
0x00ce1807000075a7ULL, 0x000022000802017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00ce1807000095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffd400707947ULL, 0x000fea000383ffffULL,
0x00ce180f000075a7ULL, 0x000022000802017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00ce180f000095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffd400947947ULL, 0x000fea000383ffffULL,
0x00ce1005000075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00ce1005000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd800487947ULL, 0x020fea000383ffffULL,
0x00cda005000075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cda005000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd8003c7947ULL, 0x020fea000383ffffULL,
0x00cdb00b000075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdb00b000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffd800607947ULL, 0x000fea000383ffffULL,
0x00cdc00b000075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00cdc00b000085a7ULL, 0x000e24000800007fULL,
0xfffffffc00ec8947ULL, 0x001fea000383ffffULL, 0xffffffdc00887947ULL, 0x000fea000383ffffULL,
0x00ce100b000075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00ce100b000095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe400587947ULL, 0x001fea000383ffffULL,
0x00ce100d000075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00ce100d000095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe400807947ULL, 0x001fea000383ffffULL,
0x00cdf80d180075a7ULL, 0x000922000802017fULL, 0x0000c0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00cdf80d180095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0xffffffe400f07947ULL, 0x00ffea000383ffffULL,
0x00000009ff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000009ff037e24ULL, 0x000fce000f8e00ffULL,
0x0000000bff057e24ULL, 0x000fc8000f8e00ffULL, 0x00410803050075a7ULL, 0x000022000806017fULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x009896800000b95dULL, 0x000fea0003900000ULL,
0x004108030500b5a7ULL, 0x000e24000806007fULL, 0xfffffffc00e8b947ULL, 0x001fea000383ffffULL,
0xffffffec00b07947ULL, 0x000fea000383ffffULL, 0x0000000bff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fce000f8e00ffULL, 0x00000009ff057e24ULL, 0x000fc8000f8e00ffULL,
0x00410003050075a7ULL, 0x000022000800017fULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00410003050085a7ULL, 0x000e24000800007fULL,
0xfffffffc00e88947ULL, 0x001fea000383ffffULL, 0xfffffff000887947ULL, 0x000fea000383ffffULL,
0x0180000008047836ULL, 0x000fe20000000000ULL, 0x0000013000037945ULL, 0x000fe80003800000ULL,
0x7f80000004097812ULL, 0x000fc800078ec0ffULL, 0x018000000900780cULL, 0x000fda0003f25070ULL,
0x0000000800049308ULL, 0x0000620000001000ULL, 0x0000000000389947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x040fe40003f45070ULL, 0x008000000900780cULL, 0x000fe40003f22070ULL,
0x00000001ff097807ULL, 0x000fe40001000000ULL, 0x00000001ff047807ULL, 0x002fc80004800000ULL,
0x0000000409ff7212ULL, 0x000fda000782fcffULL, 0x00000000001c9947ULL, 0x000fea0003800000ULL,
0x007fffff08ff7812ULL, 0x040fe4000782c0ffULL, 0x8000000008087812ULL, 0x001fe400078ec0ffULL,
0x00000001ff047807ULL, 0x000fc80000800000ULL, 0x0000000409ff7212ULL, 0x000fda000782c0ffULL,
0x0080000008041812ULL, 0x000fe200078efcffULL, 0x000000ffff049224ULL, 0x000fe200078e0008ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000800047308ULL, 0x0002a40000001000ULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x003fe400078e000aULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xffffff9408507950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000010000ce80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000015bULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001c5ULL,
0x00000000000001ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000398ULL,
0x0000000000000150ULL, 0x0000000c00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000cbULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000004e8ULL,
0x0000000000000100ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000029ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005e8ULL,
0x0000000000000048ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000043ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000630ULL,
0x0000000000000778ULL, 0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000100000126ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000da8ULL,
0x0000000000000020ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x00000004000000b5ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000dc8ULL,
0x0000000000000000ULL, 0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000edULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000dc8ULL,
0x0000000000000030ULL, 0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x0000000400000114ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000df8ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000006dULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e40ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x000000010000008fULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e48ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000100000032ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL,
0x0000000000006b80ULL, 0x0000000c00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007fULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000007a00ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000057ULL, 0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000007a10ULL,
0x0000000000000400ULL, 0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000100000142ULL, 0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000007a10ULL,
0x0000000000000310ULL, 0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x0000000000008160ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000008160ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e40ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000006b80ULL, 0x0000000000006b80ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000007a00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000410ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000007a10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000310ULL,
0x0000000000000310ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_90_cubin_len = 33456;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
