/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001ca10ULL, 0x000000000001c590ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001a9d0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001ab40ULL, 0x0000000000000050ULL, 0x000e002200000131ULL,
0x000000000001ab90ULL, 0x0000000000000050ULL, 0x000e00220000015bULL, 0x000000000001abe0ULL,
0x0000000000000120ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001ad00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001a9d000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x00690c0400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080930828808081ULL,
0x9d08288080960828ULL, 0x2880809e08288080ULL, 0x80ac08288080a308ULL, 0x08288080ae082880ULL,
0x8080b108288080afULL, 0xb408288080b20828ULL, 0x288080b708288080ULL, 0x80d008288080c708ULL,
0x08288080d4082880ULL, 0x80808608288080dcULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001a9d000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9108288080900828ULL, 0x2880809608288080ULL, 0x809e082880809d08ULL, 0x08288080a0082880ULL,
0x8080a308288080a1ULL, 0xb108288080ac0828ULL, 0x288080b208288080ULL, 0x80c708288080b408ULL,
0x08288080d0082880ULL, 0x8080dc08288080d4ULL, 0x8016288080890828ULL, 0x0000000310288082ULL,
0x8089920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000013000000000ULL,
0x0001ab4000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8088288080890900ULL,
0x0000000000002880ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9008288080890828ULL,
0x2880809108288080ULL, 0x809d082880809608ULL, 0x082880809e082880ULL, 0x8080a108288080a0ULL,
0xac08288080a30828ULL, 0x288080b108288080ULL, 0x80b408288080b208ULL, 0x08288080c7082880ULL,
0x8080d408288080d0ULL, 0x8016288080dc0828ULL, 0x0000000310288082ULL, 0x80dc920000000000ULL,
0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000020800000000ULL, 0x0001ab9000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80d4288080dc0900ULL, 0x0000000000002880ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9008288080890828ULL, 0x2880809108288080ULL,
0x809d082880809608ULL, 0x082880809e082880ULL, 0x8080a108288080a0ULL, 0xac08288080a30828ULL,
0x288080b108288080ULL, 0x80b408288080b208ULL, 0x08288080c7082880ULL, 0x8080dc08288080d4ULL,
0x8016288080d00828ULL, 0x0000000310288082ULL, 0x80d0920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x000002e000000000ULL, 0x0001abe000000000ULL, 0x0000012000000000ULL,
0x0000000000000000ULL, 0x0000001200082f04ULL, 0x00081204000000a1ULL, 0x000000000000000dULL,
0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL,
0x0000000e00080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480007ULL,
0x00000000000c1704ULL, 0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL,
0x00000000000c1704ULL, 0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x00018e9000000020ULL,
0x0001907000019060ULL, 0x000191c0000191b0ULL, 0x01c82904000191d0ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500001f0500001fULL, 0x0500001f0500001fULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000d001c82804ULL, 0x00001500000000e0ULL, 0x0000162000001580ULL, 0x00001a3000001650ULL,
0x00001ad000001a60ULL, 0x000038f000001b40ULL, 0x0000397000003910ULL, 0x00005720000039d0ULL,
0x00005850000057a0ULL, 0x00005c3000005970ULL, 0x00005cb000005c50ULL, 0x0000791000005d10ULL,
0x0000799000007930ULL, 0x000096c0000079f0ULL, 0x000097f000009740ULL, 0x00009bd000009910ULL,
0x00009c5000009bf0ULL, 0x0000b8b000009cb0ULL, 0x0000b9300000b8d0ULL, 0x0000d6600000b990ULL,
0x0000d7900000d6e0ULL, 0x0000db700000d8b0ULL, 0x0000dbf00000db90ULL, 0x0000f8800000dc50ULL,
0x0000f9000000f8a0ULL, 0x000114200000f960ULL, 0x00011bb000011430ULL, 0x000138a0000136f0ULL,
0x00013ee000013ea0ULL, 0x00018a5000014700ULL, 0x00018a9000018a80ULL, 0x00018ad000018aa0ULL,
0x00018b0000018af0ULL, 0x000191a000018b10ULL, 0x0001921000019200ULL, 0x0001993000019220ULL,
0x000199e000019970ULL, 0x00019ad000019a60ULL, 0x00019ba000019b40ULL, 0x00019c6000019c10ULL,
0x00019d1000019ca0ULL, 0x00019de000019d80ULL, 0x00019eb000019e50ULL, 0x00019f7000019f20ULL,
0x0001a02000019fb0ULL, 0x0001a0f00001a090ULL, 0x0001a1c00001a160ULL, 0x0001a2800001a230ULL,
0x0001a3300001a2c0ULL, 0x0001a4000001a3a0ULL, 0x0001a4e00001a470ULL, 0x0001a5b00001a550ULL,
0x0001a6500001a600ULL, 0x0001a6f00001a6a0ULL, 0x0001a7900001a740ULL, 0x0001a8600001a7e0ULL,
0x0001a9400001a8e0ULL, 0x070039040001a9a0ULL, 0x000000ff00000210ULL, 0x003f010000010600ULL,
0x0000000000000250ULL, 0x003f012000010608ULL, 0x00000000000002b0ULL, 0x003f012000010688ULL,
0x0000000000000380ULL, 0x003f0120000106a8ULL, 0x000000ff000003c0ULL, 0x003f0100000106b8ULL,
0x000000ff000004e0ULL, 0x003f010700010600ULL, 0x0000002700000670ULL, 0x003f01020001068cULL,
0x00000027000009f0ULL, 0x003f010100010688ULL, 0x000000ff00000b40ULL, 0x003f0107000106a8ULL,
0x000000ff00000bc0ULL, 0x003f0101000106a8ULL, 0x000000ff00000c20ULL, 0x003f0101000106b8ULL,
0x000000ff00000d60ULL, 0x003f0105000106bcULL, 0x000000ff00000db0ULL, 0x003f0105000106bcULL,
0x000000ff00000e30ULL, 0x003f0105000106bcULL, 0x000000ff00001270ULL, 0x003f0107000106b0ULL,
0x000000ff000012f0ULL, 0x003f0101000106b0ULL, 0x000000ff00001300ULL, 0x003f0105000106acULL,
0x0000002700001370ULL, 0x003f010100010608ULL, 0x0000002700001390ULL, 0x003f01050001060cULL,
0x0000002700001420ULL, 0x003f01050001060cULL, 0x000000ff00001910ULL, 0x003f0105000106acULL,
0x000000ff00001990ULL, 0x003f0105000106acULL, 0x000000ff00003340ULL, 0x003f0101000106b8ULL,
0x000000ff00003350ULL, 0x003f0105000106bcULL, 0x000000ff000033a0ULL, 0x003f0105000106bcULL,
0x000000ff00003420ULL, 0x003f0105000106bcULL, 0x000000ff000036f0ULL, 0x003f0107000106a8ULL,
0x000000ff00003770ULL, 0x003f0101000106a8ULL, 0x000000ff00003780ULL, 0x003f0105000106b4ULL,
0x000000ff000037e0ULL, 0x003f0105000106b4ULL, 0x000000ff00003860ULL, 0x003f0105000106b4ULL,
0x000000ff000050d0ULL, 0x003f0101000106b8ULL, 0x000000ff00005140ULL, 0x003f010100010688ULL,
0x000000ff00005180ULL, 0x003f0105000106bcULL, 0x000000ff000051d0ULL, 0x003f0105000106bcULL,
0x000000ff00005250ULL, 0x003f0105000106bcULL, 0x000000ff000054e0ULL, 0x003f0107000106b0ULL,
0x000000ff00005560ULL, 0x003f0101000106b0ULL, 0x000000ff00005570ULL, 0x003f0105000106acULL,
0x00000027000055e0ULL, 0x003f010100010628ULL, 0x0000002700005600ULL, 0x003f01050001062cULL,
0x0000002700005690ULL, 0x003f01050001062cULL, 0x000000ff00005b20ULL, 0x003f0105000106acULL,
0x000000ff00005ba0ULL, 0x003f0105000106acULL, 0x000000ff000073a0ULL, 0x003f0101000106b8ULL,
0x000000ff000073b0ULL, 0x003f0105000106bcULL, 0x000000ff00007400ULL, 0x003f0105000106bcULL,
0x000000ff00007480ULL, 0x003f0105000106bcULL, 0x000000ff00007710ULL, 0x003f0107000106a8ULL,
0x000000ff00007790ULL, 0x003f0101000106a8ULL, 0x000000ff000077a0ULL, 0x003f0105000106b4ULL,
0x000000ff00007800ULL, 0x003f0105000106b4ULL, 0x000000ff00007880ULL, 0x003f0105000106b4ULL,
0x000000ff00009070ULL, 0x003f0101000106b8ULL, 0x000000ff000090e0ULL, 0x003f010100010690ULL,
0x000000ff00009120ULL, 0x003f0105000106bcULL, 0x000000ff00009170ULL, 0x003f0105000106bcULL,
0x000000ff000091f0ULL, 0x003f0105000106bcULL, 0x000000ff00009480ULL, 0x003f0107000106b0ULL,
0x000000ff00009500ULL, 0x003f0101000106b0ULL, 0x000000ff00009510ULL, 0x003f0105000106acULL,
0x0000002700009580ULL, 0x003f010100010648ULL, 0x00000027000095a0ULL, 0x003f01050001064cULL,
0x0000002700009630ULL, 0x003f01050001064cULL, 0x000000ff00009ac0ULL, 0x003f0105000106acULL,
0x000000ff00009b40ULL, 0x003f0105000106acULL, 0x000000ff0000b340ULL, 0x003f0101000106b8ULL,
0x000000ff0000b350ULL, 0x003f0105000106bcULL, 0x000000ff0000b3a0ULL, 0x003f0105000106bcULL,
0x000000ff0000b420ULL, 0x003f0105000106bcULL, 0x000000ff0000b6b0ULL, 0x003f0107000106a8ULL,
0x000000ff0000b730ULL, 0x003f0101000106a8ULL, 0x000000ff0000b740ULL, 0x003f0105000106b4ULL,
0x000000ff0000b7a0ULL, 0x003f0105000106b4ULL, 0x000000ff0000b820ULL, 0x003f0105000106b4ULL,
0x000000ff0000d010ULL, 0x003f0101000106b8ULL, 0x000000ff0000d080ULL, 0x003f010100010698ULL,
0x000000ff0000d0c0ULL, 0x003f0105000106bcULL, 0x000000ff0000d110ULL, 0x003f0105000106bcULL,
0x000000ff0000d190ULL, 0x003f0105000106bcULL, 0x000000ff0000d420ULL, 0x003f0107000106b0ULL,
0x000000ff0000d4a0ULL, 0x003f0101000106b0ULL, 0x000000ff0000d4b0ULL, 0x003f0105000106acULL,
0x000000270000d520ULL, 0x003f010100010668ULL, 0x000000270000d540ULL, 0x003f01050001066cULL,
0x000000270000d5d0ULL, 0x003f01050001066cULL, 0x000000ff0000da60ULL, 0x003f0105000106acULL,
0x000000ff0000dae0ULL, 0x003f0105000106acULL, 0x000000ff0000f2e0ULL, 0x003f0101000106b8ULL,
0x000000ff0000f2f0ULL, 0x003f0105000106bcULL, 0x000000ff0000f340ULL, 0x003f0105000106bcULL,
0x000000ff0000f3c0ULL, 0x003f0105000106bcULL, 0x000000ff0000f680ULL, 0x003f0107000106a8ULL,
0x000000ff0000f700ULL, 0x003f0101000106a8ULL, 0x000000ff0000f710ULL, 0x003f0105000106b4ULL,
0x000000ff0000f770ULL, 0x003f0105000106b4ULL, 0x000000ff0000f7f0ULL, 0x003f0105000106b4ULL,
0x000000ff00010fe0ULL, 0x003f0101000106b8ULL, 0x000000ff00011040ULL, 0x003f0101000106a0ULL,
0x000000ff00014a00ULL, 0x003f010100010600ULL, 0x000000ff000154f0ULL, 0x003f010500010604ULL,
0x000000ff00015590ULL, 0x003f010500010604ULL, 0x000000ff000158b0ULL, 0x003f010100010600ULL,
0x000000ff000158c0ULL, 0x003f010500010604ULL, 0x000000ff00015950ULL, 0x003f010500010604ULL,
0x0000003200017ef0ULL, 0x003f010100000000ULL, 0x0000003200017f30ULL, 0x003f010500000004ULL,
0x0000003200018350ULL, 0x003f010500000004ULL, 0x0000003400019790ULL, 0x003f010100000000ULL,
0x00000034000197f0ULL, 0x003f010100000008ULL, 0x0000003400019850ULL, 0x003f010100000010ULL,
0x00000034000198c0ULL, 0x003f010100000018ULL, 0x00101c0400053803ULL, 0x000159b000014950ULL,
0x0001990000015a50ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000394ULL,
0x0000001200000002ULL, 0x00000000000002bcULL, 0x0000001200000002ULL, 0x00000000000001e4ULL,
0x0000001200000002ULL, 0x000000000000011cULL, 0x0000001200000002ULL, 0x0000000000000044ULL,
0x0000001200000002ULL, 0x000000000000036dULL, 0x0000001200000002ULL, 0x0000000000000295ULL,
0x0000001200000002ULL, 0x00000000000001bdULL, 0x0000001200000002ULL, 0x00000000000000f8ULL,
0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000007919ULL, 0x000ea20000002300ULL, 0x0000001000067300ULL, 0x000ee600000e0000ULL,
0x0000000000037919ULL, 0x000f280000002200ULL, 0x0000000000307919ULL, 0x000f620000002600ULL,
0x0000001000117309ULL, 0x0002a60000000000ULL, 0x0000000000287919ULL, 0x000ee80000002700ULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x00000005ff027819ULL, 0x002fc60000011604ULL,
0x0000000000267919ULL, 0x000e680000000000ULL, 0x00001fff000c7589ULL, 0x0049e800000e0000ULL,
0x00001fff02027589ULL, 0x000ea200000e0000ULL, 0x0000000100007824ULL, 0x010fe400078e0203ULL,
0x0000000830037824ULL, 0x020fc400078e00ffULL, 0x0000008000007824ULL, 0x000fe400078e0204ULL,
0x00005800ff047624ULL, 0x000fe200078e00ffULL, 0x000000070600720cULL, 0x008fe40003f02070ULL,
0x000000ff0000720cULL, 0x000fe20003f25270ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0x0000000f0000780cULL, 0x040fe40003f44070ULL, 0x0000007f0000780cULL, 0x000fe20003f84070ULL,
0x0000002804037224ULL, 0x000fe200078e0203ULL, 0x000000030000780cULL, 0x000fe20003f64070ULL,
0x000000040c057824ULL, 0x004fcc00078e0202ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x00000002050a7824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x000000080a0b7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0005e20000000a00ULL,
0xff317217ff0dc424ULL, 0x000fe200078e00ffULL, 0x000000010a0f7810ULL, 0x000fe20007ffe0ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x010608060000a388ULL, 0x0007e20000008a00ULL,
0x000000010000780cULL, 0x000fe20003f44070ULL, 0x7fffff60ff09b424ULL, 0x000fc400078e00ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0aULL, 0x0104000d0000c388ULL, 0x000fe20000004800ULL,
0x000000070a047812ULL, 0x004fc600078ec0ffULL, 0x010688080000b388ULL, 0x0005e20000008a00ULL,
0x0000001f04057812ULL, 0x002fe200078e7826ULL, 0x0000000103047824ULL, 0x000fe200078e020aULL,
0x000000ff0b00720cULL, 0x040fe20003f63070ULL, 0x00000200ff077424ULL, 0x008fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f83070ULL, 0x000000200a0e7824ULL, 0x000fe400078e0205ULL,
0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fc400078e00ffULL,
0x3fffff00ff08a424ULL, 0x004fe400078e00ffULL, 0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL,
0x00000010260d7824ULL, 0x000fe400078e00ffULL, 0x0000000103067824ULL, 0x000fe200078e020fULL,
0x0106a8080000a388ULL, 0x0003e20000008a00ULL, 0x000000070f037812ULL, 0x000fe200078ec0ffULL,
0x00005c0004047625ULL, 0x080fe200078e0007ULL, 0x000001f00d107812ULL, 0x000fe200078ec0ffULL,
0x0106b80aff009388ULL, 0x0005e20000000a00ULL, 0x0000001f03037812ULL, 0x000fe200078e7826ULL,
0x00005c0006067625ULL, 0x000fc400078e0007ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001004047210ULL, 0x080fe20007fbe0ffULL, 0x000000200f037824ULL, 0x000fe200078e0203ULL,
0x0000001006067210ULL, 0x000fe20007f5e0ffULL, 0x000000100e0e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x000000ffff077224ULL, 0x000fe400010e0607ULL,
0x0000001003037824ULL, 0x000fc400078e00ffULL, 0x000000ffff007224ULL, 0x002fe200078e0a11ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040e7faeULL, 0x0003e8000d901c46ULL,
0x0000000006037faeULL, 0x0007e2000e101c46ULL, 0x00000004ff047424ULL, 0x002fc600078e00ffULL,
0x0000000000007918ULL, 0x008fe20000000000ULL, 0x0000600028047625ULL, 0x000fc600078e0004ULL,
0x01060400ffff038cULL, 0x0005e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000604037981ULL, 0x000ee2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x00000004ff247e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff03257810ULL, 0x008fc80007ffe0ffULL,
0x00000008ff257819ULL, 0x000fce0000011625ULL, 0x0001438000008947ULL, 0x000fea0003800000ULL,
0x0000580030007a10ULL, 0x004fe20007ffe0ffULL, 0x0000000228287824ULL, 0x000fe200078e00ffULL,
0x0000000124047810ULL, 0x000fe20007ffe0ffULL, 0x0000000802277824ULL, 0x000fe400078e00ffULL,
0x0000580028287a24ULL, 0x000fe200078e0200ULL, 0x000000250400720cULL, 0x000fe20003f06070ULL,
0x00000003ff007424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff077819ULL, 0x000fe20000011626ULL, 0x01068c0027ff738cULL, 0x0003e20000000000ULL,
0x000000f00d147812ULL, 0x000fe200078ec0ffULL, 0x00000100ff157424ULL, 0x000fe200078e00ffULL,
0x00000002070e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127057824ULL, 0x000fe200078e0207ULL,
0x0000000407107810ULL, 0x000fc40007ffe0ffULL, 0x0000000607127810ULL, 0x000fe20007ffe0ffULL,
0x0000000127087824ULL, 0x000fe200078e020eULL, 0x0000000705067812ULL, 0x000fe200078ec0ffULL,
0x0000010024007824ULL, 0x002fe400078e00ffULL, 0x00000001270a7824ULL, 0x040fe200078e0210ULL,
0x0000000f06067812ULL, 0x000fe200078e7826ULL, 0x0000000127137824ULL, 0x000fe200078e0212ULL,
0x0000000003047217ULL, 0x000fe40007800000ULL, 0x0000000708097812ULL, 0x000fe200078ec0ffULL,
0x00000010050d7824ULL, 0x000fe200078e0206ULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a00ULL, 0x0000000f09097812ULL, 0x000fe200078e7826ULL,
0x0000620028007a24ULL, 0x000fe200078e0200ULL, 0x0000000f0b0b7812ULL, 0x000fc400078e7826ULL,
0x0000002004067807ULL, 0x000fe20000000000ULL, 0x0000000100057824ULL, 0x000fe200078e0205ULL,
0x00000007130c7812ULL, 0x000fe200078ec0ffULL, 0x00000010080f7824ULL, 0x000fe200078e0209ULL,
0x0000000627067217ULL, 0x000fe20007800000ULL, 0x00005e0005047625ULL, 0x000fe200078e0015ULL,
0x0000c0000d0d7811ULL, 0x000fc600078e20ffULL, 0x000000100a117824ULL, 0x000fe200078e020bULL,
0x0000000f0c0b7812ULL, 0x000fe200078e7826ULL, 0x0000000100097824ULL, 0x000fe200078e020aULL,
0x00000014040a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001060c7824ULL, 0x000fe400078e0a27ULL,
0x0000000100087824ULL, 0x040fe400078e0208ULL, 0x0000000100007824ULL, 0x000fe200078e0213ULL,
0x0000000c0700720cULL, 0x080fe20003f26070ULL, 0x0000001013137824ULL, 0x000fe200078e020bULL,
0x0000000c0e00720cULL, 0x080fe20003f46070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000000c1000720cULL, 0x080fe20003f66070ULL, 0x00005e0008047625ULL, 0x000fe200078e0015ULL,
0x0000000c1200720cULL, 0x000fc60003f06070ULL, 0x00005e0009067625ULL, 0x000fe200078e0015ULL,
0x0000001404047210ULL, 0x000fc60007f9e0ffULL, 0x00005e0000087625ULL, 0x000fe200078e0015ULL,
0x0000001406067210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000001408087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff077224ULL, 0x000fc800028e0607ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000c0000f0f7811ULL, 0x000fe200078e20ffULL, 0x0106880027ff7f8cULL, 0x0003e2000c80043fULL,
0x0000c00011117811ULL, 0x000fe200078e20ffULL, 0xff317217ff297424ULL, 0x000fe200078e00ffULL,
0x0000c00013137811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c901c46ULL, 0x000000252400720cULL, 0x000fe20003f26070ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000040f7faeULL, 0x0003e2000d101c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x000000ffff157224ULL, 0x000fc600078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff2c7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff2e7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x002fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x000103d000001947ULL, 0x000fea0003800000ULL, 0x00000004022b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff4f7224ULL, 0x004fc400078e002dULL, 0x000000ffff507224ULL, 0x008fe200078e002fULL,
0x000000022b2c7810ULL, 0x000fe20007ffe0ffULL, 0xff317217ff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fe400078e00ffULL, 0x0000010024007824ULL, 0x000fca00078e00ffULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0001030000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804850ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804850ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x00000000002e7305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x0000002e0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff2e7984ULL, 0x000e640000000800ULL,
0x800000002eff7812ULL, 0x002fc40007804850ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x00000004ff3f7819ULL, 0x000fe20000011626ULL, 0x0000001026427824ULL, 0x000fe200078e00ffULL,
0x00000000032f7217ULL, 0x000fe40007800000ULL, 0x00000001242e7810ULL, 0x000fe40007ffe0ffULL,
0x000000023f307810ULL, 0x000fe20007ffe0ffULL, 0x000000012f357824ULL, 0x100fe200078e0a00ULL,
0x000000043f317810ULL, 0x000fe20007ffe0ffULL, 0x0000620028007a24ULL, 0x000fe200078e0200ULL,
0x000000252e00720cULL, 0x000fe20003f06070ULL, 0x00000001272e7824ULL, 0x000fe200078e023fULL,
0x000000063f327810ULL, 0x000fe20007ffe0ffULL, 0x0000000127337824ULL, 0x000fe200078e0230ULL,
0x0000002035387807ULL, 0x000fe20000000000ULL, 0x0000000127347824ULL, 0x040fe200078e0231ULL,
0x000000f0422f7812ULL, 0x000fe200078ec0ffULL, 0x000000012e367824ULL, 0x100fe200078e0200ULL,
0x00000038273e7217ULL, 0x000fe20007800000ULL, 0x0000000133397824ULL, 0x000fc400078e0200ULL,
0x00000001343a7824ULL, 0x000fe400078e0200ULL, 0x00005e0036367625ULL, 0x000fc800078e0041ULL,
0x0000000127357824ULL, 0x000fe200078e0232ULL, 0x0000002f363c7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0039387625ULL, 0x000fc800078e0041ULL, 0x00005e003a3a7625ULL, 0x000fc800078e0041ULL,
0x0000000135367824ULL, 0x000fe200078e0200ULL, 0x0000002f3a407210ULL, 0x080fe20007f7e0ffULL,
0x000000013e007824ULL, 0x000fe200078e0a27ULL, 0x0000002f383e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e0637ULL, 0x000000072e387812ULL, 0x000fe200078ec0ffULL,
0x00005e0036367625ULL, 0x000fe200078e0041ULL, 0x000000003f00720cULL, 0x080fe40003f26070ULL,
0x000000003200720cULL, 0x080fe20003f86070ULL, 0x000000ffff3f7224ULL, 0x000fe200010e0639ULL,
0x000000003000720cULL, 0x080fe20003f46070ULL, 0x000000ffff417224ULL, 0x000fe200018e063bULL,
0x000000003100720cULL, 0x000fc40003f66070ULL, 0x0000000733007812ULL, 0x000fe400078ec0ffULL,
0x0000000f38387812ULL, 0x000fe400078e7826ULL, 0x0000000734397812ULL, 0x000fe400078ec0ffULL,
0x00000007353a7812ULL, 0x000fe200078ec0ffULL, 0x000000102e607824ULL, 0x000fe200078e0238ULL,
0x0000000f00007812ULL, 0x100fe400078e7826ULL, 0x0000000f395e7812ULL, 0x000fc400078e7826ULL,
0x0000000f3a3a7812ULL, 0x000fe200078e7826ULL, 0x00000010335f7824ULL, 0x000fe200078e0200ULL,
0x0000e00060397811ULL, 0x000fe200078e20ffULL, 0x00000010345e7824ULL, 0x000fe200078e025eULL,
0x0000002f36367210ULL, 0x000fe20007fbe0ffULL, 0x00000010355d7824ULL, 0x000fe200078e023aULL,
0x0000e0005f3a7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c397faeULL, 0x0003e2000c901c46ULL, 0x0000e0005e3b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff377224ULL, 0x000fe400028e0637ULL, 0x000000003e3a7faeULL, 0x0005e8000d101c46ULL,
0x00000000403b7faeULL, 0x0005e2000d901c46ULL, 0x0000e0005d3c7811ULL, 0x002fca00078e20ffULL,
0x00000000363c7faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff467f8cULL, 0x000e68000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106080027367f8cULL, 0x004fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc6000784484fULL, 0x01060c0027387984ULL, 0x000ea40000000800ULL,
0x8000000038ff7812ULL, 0x004fe40007824837ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000387305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000380000735dULL, 0x008fe40003800000ULL,
0x01060c0027387984ULL, 0x000ea40000000800ULL, 0x8000000038ff7812ULL, 0x004fc40007824837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe20000011626ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x00000070423d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x000000013d3d7824ULL, 0x000fca00078e0200ULL,
0x010000003d367984ULL, 0x000ea80000000800ULL, 0x010200003d377984ULL, 0x0007220000000800ULL,
0x000000293600720bULL, 0x004fe20003f3d000ULL, 0x000184127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00387812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff427424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fe40003f65270ULL,
0x000000293600720bULL, 0x000fe20003f34000ULL, 0x000183d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x00000036293f7209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x0104003f3d00b388ULL, 0x0005e20000000800ULL,
0x8000003f29297221ULL, 0x000fe20000010000ULL, 0x0000000038ff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b29297820ULL, 0x000fc80000410000ULL, 0x0000002900407308ULL, 0x0007240000000800ULL,
0x00000002ff297819ULL, 0x008fe20000011626ULL, 0x000183727f007947ULL, 0x000fea000b800000ULL,
0x00001f2940387589ULL, 0x0144e400000e0000ULL, 0x0000000829297810ULL, 0x004fe20007ffe0ffULL,
0x000183c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2940297589ULL, 0x00052400000e0000ULL,
0x8000003f36361221ULL, 0x100fe20000010000ULL, 0x0000002923237220ULL, 0x090fe20000410000ULL,
0x0000002922227220ULL, 0x080fe20000410000ULL, 0x000000291f1f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b36361820ULL, 0x000fe20000410000ULL, 0x000000291e1e7220ULL, 0x080fe20000410000ULL,
0x000000291b1b7220ULL, 0x080fe20000410000ULL, 0x000000291a1a7220ULL, 0x080fe20000410000ULL,
0x00000036002d1308ULL, 0x000f220000000800ULL, 0x0000002917177220ULL, 0x080fe20000410000ULL,
0x0000002916167220ULL, 0x080fe20000410000ULL, 0x0000002913137220ULL, 0x080fe20000410000ULL,
0x0000002912127220ULL, 0x080fe20000410000ULL, 0x000000290f0f7220ULL, 0x080fe20000410000ULL,
0x000000290e0e7220ULL, 0x080fe20000410000ULL, 0x000000290b0b7220ULL, 0x080fe20000410000ULL,
0x000000290a0a7220ULL, 0x080fe20000410000ULL, 0x0000002907077220ULL, 0x080fe20000410000ULL,
0x0000002906067220ULL, 0x000fe20000410000ULL, 0x000000402a2a7220ULL, 0x000fe20000410000ULL,
0x00000001ff427807ULL, 0x000fe20000800000ULL, 0x0000003821217220ULL, 0x088fe20000410000ULL,
0x0000003820207220ULL, 0x080fe20000410000ULL, 0x000000381d1d7220ULL, 0x080fe20000410000ULL,
0x000000381c1c7220ULL, 0x080fe20000410000ULL, 0x0000003819197220ULL, 0x080fe20000410000ULL,
0x0000003818187220ULL, 0x080fe20000410000ULL, 0x0000003815157220ULL, 0x080fe20000410000ULL,
0x0000003814147220ULL, 0x080fe20000410000ULL, 0x0000003811117220ULL, 0x080fe20000410000ULL,
0x0000003810107220ULL, 0x080fe20000410000ULL, 0x000000380d0d7220ULL, 0x080fe20000410000ULL,
0x000000380c0c7220ULL, 0x080fe20000410000ULL, 0x0000003809097220ULL, 0x080fe20000410000ULL,
0x0000003808087220ULL, 0x080fe20000410000ULL, 0x0000003805057220ULL, 0x080fe20000410000ULL,
0x0000003804047220ULL, 0x000fe20000410000ULL, 0x000000ffff297224ULL, 0x000fe200078e003fULL,
0x0000002d37371220ULL, 0x010fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000002a372a7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ee40000000800ULL,
0x8000000000ff7812ULL, 0x008fc4000782484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000367305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000360000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff367984ULL, 0x000ee40000000800ULL,
0x8000000036ff7812ULL, 0x008fe4000782484fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002dff00723eULL, 0x000fe400000010ffULL, 0x00000004ff437819ULL, 0x000fc40000011626ULL,
0x00000002ff387819ULL, 0x000fe40000011626ULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x000180627f007947ULL, 0x000fea000b800000ULL, 0x00001f385a627589ULL, 0x00072400000e0000ULL,
0x0000000838367810ULL, 0x000fe20007ffe0ffULL, 0x000180a27f007947ULL, 0x000fea000b800000ULL,
0x00001f365a617589ULL, 0x0004e400000e0000ULL, 0x0000001038377810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0037ULL,
0x00001ae0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x000190b000007944ULL, 0x01efea0003c00000ULL,
0x0000001838387810ULL, 0x008fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0038ULL, 0x00001b50005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0001904000007944ULL, 0x016fea0003c00000ULL, 0x0000000826007812ULL, 0x044fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000002b263f7211ULL, 0x000fe400078fe0ffULL,
0x0000000700407812ULL, 0x100fe400078ec826ULL, 0x0000002c26417211ULL, 0x000fe400078fe0ffULL,
0x0000000700007812ULL, 0x000fe400078ef826ULL, 0x0000003f40567212ULL, 0x000fc400078e3cffULL,
0x0000004140457212ULL, 0x000fe400078e3cffULL, 0x0000991042427816ULL, 0x000fe200000000ffULL,
0x0000001000597824ULL, 0x040fe400078e0256ULL, 0x0000001000577824ULL, 0x040fe200078e0245ULL,
0x0000010000007811ULL, 0x000fe400078e20ffULL, 0x0000c000593f7811ULL, 0x000fe400078e20ffULL,
0x0000c00057407811ULL, 0x000fe200078e20ffULL, 0x0000000145457824ULL, 0x000fc400078e0200ULL,
0x0000000156567824ULL, 0x000fe200078e0200ULL, 0x000000003f64783bULL, 0x000ea20000004200ULL,
0x000000ffff007224ULL, 0x000fe200078e0042ULL, 0x0000c00045427811ULL, 0x000fe400078e20ffULL,
0x0000c00056417811ULL, 0x000fe200078e20ffULL, 0x000000004050783bULL, 0x000ee20000004200ULL,
0x000000ff0000720cULL, 0x000fc60003f25270ULL, 0x000000004248783bULL, 0x000f680000004200ULL,
0x00000000414c783bULL, 0x000f220000004200ULL, 0x000000ff64447812ULL, 0x004fe400078ec0ffULL,
0x000000ff67697812ULL, 0x000fe400078ec0ffULL, 0x00000044ff7e723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x008fc40000011652ULL, 0x000000ff526e7812ULL, 0x040fe200078ec0ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x000fe40000011652ULL,
0x0000ffff52857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff527819ULL, 0x120fe40000011648ULL,
0x000000ff48947812ULL, 0x000fe400078ec0ffULL, 0x00000018ff937819ULL, 0x000fc40000011648ULL,
0x0000ffff48447812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x100fe40000011653ULL,
0x000000ff53707812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011653ULL,
0x0000ffff53847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff827819ULL, 0x010fc4000001164cULL,
0x000000ff4c717812ULL, 0x040fe400078ec0ffULL, 0x00000018ff887819ULL, 0x000fe4000001164cULL,
0x0000ffff4c807812ULL, 0x000fe400078ec0ffULL, 0x00000018ff487819ULL, 0x100fe40000011649ULL,
0x00000010ff537819ULL, 0x000fe40000011649ULL, 0x000000ff49957812ULL, 0x000fc400078ec0ffULL,
0x0000ffff494c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164aULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000010ff557819ULL, 0x000fe20000011664ULL, 0x20000069ff7c7230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000048ff697230ULL, 0x000fe20000004100ULL,
0x0000ffff64987812ULL, 0x000fc400078ec0ffULL, 0x00000010ff817819ULL, 0x100fe4000001164dULL,
0x000000ff4d8c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001164dULL,
0x0000ffff4d7f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011665ULL,
0x00000010ff4d7819ULL, 0x000fc4000001164aULL, 0x000000ff4a967812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff587819ULL, 0x000fe40000011665ULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x000000ff55487812ULL, 0x000fe200078ec0ffULL,
0x20000049ff557230ULL, 0x000fe20000004100ULL, 0x00000008ff497819ULL, 0x000fc40000011698ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000010ff8a7819ULL, 0x000fe40000011667ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000005bff7d7230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x000000ff58587812ULL, 0x000fe200078ec0ffULL,
0x2000006eff737230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fe20000011666ULL,
0x2000004aff5b7230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fc400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x0000ffff65997812ULL, 0x000fe400078ec0ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff6e723eULL, 0x000fe200020006ffULL, 0x20000048ff887230ULL, 0x000fe20000004100ULL,
0x000000ff894a7812ULL, 0x000fe200078ec0ffULL, 0x20000049ff897230ULL, 0x000fe20000004100ULL,
0x00000008ff487819ULL, 0x000fe20000011699ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x0000008aff49723eULL, 0x000fe200020006ffULL, 0x20000058ff8a7230ULL, 0x000fe20000004100ULL,
0x0000000726587812ULL, 0x000fc400078ec0ffULL, 0x000000ff65637812ULL, 0x000fe400078ec0ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000010ff8f7819ULL, 0x100fe40000011651ULL,
0x000000ff516c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011651ULL,
0x0000ffff519d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff669a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x100fe4000001164fULL, 0x000000ff4f927812ULL, 0x040fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fe4000001164fULL, 0x0000ffff4f547812ULL, 0x000fe400078ec0ffULL,
0x0000000858587812ULL, 0x000fc400078ef826ULL, 0x0000006fff4f723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000008bff6f723eULL, 0x000fe200020006ffULL,
0x20000048ff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff8d7819ULL, 0x000fe20000011650ULL,
0x20000063ff837230ULL, 0x000fe20000004100ULL, 0x00000018ff8e7819ULL, 0x000fe2000001164eULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000008ff487819ULL, 0x000fc4000001169aULL,
0x0000000743437812ULL, 0x000fe200078e7858ULL, 0x20000070ff727230ULL, 0x000fe20000004100ULL,
0x0000ffff679b7812ULL, 0x000fe400078ec0ffULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x0000000858437824ULL, 0x000fe200078e0243ULL, 0x00000018ff007819ULL, 0x000fe40000011664ULL,
0x0000008eff63723eULL, 0x000fe200020006ffULL, 0x20000049ff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000008cff70723eULL, 0x000fe200020006ffULL,
0x2000004aff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff497819ULL, 0x000fe4000001169bULL,
0x000000ff66687812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000018ff657819ULL, 0x000fe40000011666ULL, 0x00000000ff7b723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000008dff4a723eULL, 0x000fe200020006ffULL,
0x20000048ff8d7230ULL, 0x000fe20000004100ULL, 0x00000018ff667819ULL, 0x000fe20000011667ULL,
0x2000006cff767230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe4000001164bULL,
0x000000ff4b977812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4b007812ULL, 0x000fe400078ec0ffULL,
0x000000ff506a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe40000011650ULL,
0x0000ffff509c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e907812ULL, 0x000fe400078ec0ffULL,
0x00000049ff49723eULL, 0x000fc400020006ffULL, 0x000000ff8f4b7812ULL, 0x000fe400078ec0ffULL,
0x0000a00043487811ULL, 0x000fe200078e20ffULL, 0x20000049ff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fe4000001164eULL, 0x0000ffff4e5c7812ULL, 0x000fe400078ec0ffULL,
0x00000071ff4e723eULL, 0x000fe200020006ffULL, 0x2000006dff717230ULL, 0x000fe20000004100ULL,
0x00000090ff6c723eULL, 0x000fe200020006ffULL, 0x2000004aff907230ULL, 0x000fe20000004100ULL,
0x00000092ff6d723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x0000004bff92723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x000000004848783bULL, 0x000ea20000000200ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fe200078ec0ffULL,
0x20000065ff787230ULL, 0x000fe20000004100ULL, 0x00000091ff65723eULL, 0x000fe200020006ffULL,
0x2000006bff757230ULL, 0x000fe20000004100ULL, 0x00000008ff917819ULL, 0x000fc4000001169cULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x2000006aff777230ULL, 0x000fe20000004100ULL, 0x00000094ff6b723eULL, 0x000fe400020006ffULL,
0x000000ff86947812ULL, 0x000fe400078ec0ffULL, 0x00000095ff6a723eULL, 0x000fe200020006ffULL,
0x20000081ff957230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe20000011685ULL,
0x20000091ff857230ULL, 0x000fe20000004100ULL, 0x000000ff50817812ULL, 0x000fe200078ec0ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff51917812ULL, 0x000fe200078ec0ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fc4000001167eULL,
0x00000010ff517819ULL, 0x000fe40000011683ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x0000105488507816ULL, 0x000fe40000000050ULL,
0x000010548a517816ULL, 0x000fe20000000051ULL, 0x0000006248489231ULL, 0x084fe200003400ffULL,
0x000000ff52527812ULL, 0x000fe200078ec0ffULL, 0x000000624a4a9231ULL, 0x000fe200003400ffULL,
0x000000ff53537812ULL, 0x000fe200078ec0ffULL, 0x0000006149499231ULL, 0x080fe200003400ffULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x000000614b4b9231ULL, 0x000fe200003400ffULL,
0x00000052ff83723eULL, 0x000fc400020006ffULL, 0x00000053ff88723eULL, 0x000fe200020006ffULL,
0x20000068ff7a7230ULL, 0x000fe20000004100ULL, 0x00000008ff447819ULL, 0x000fe40000011644ULL,
0x000000504850723cULL, 0x000fe20000041804ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff057819ULL, 0x000fe2000001167bULL, 0x20000066ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff047819ULL, 0x000fe20000011689ULL, 0x20000088ff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff067819ULL, 0x000fe2000001167dULL, 0x20000083ff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff077819ULL, 0x000fc4000001167cULL, 0x00000044ff7c723eULL, 0x000fe400020006ffULL,
0x0000105405047816ULL, 0x000fe40000000004ULL, 0x0000000730447812ULL, 0x000fe200078e7858ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x0000105406057816ULL, 0x000fe4000000008bULL,
0x00000010ff067819ULL, 0x000fe2000001167aULL, 0x0000000858447824ULL, 0x000fe200078e0244ULL,
0x00000010ff8e7819ULL, 0x000fc4000001168eULL, 0x000010548c067816ULL, 0x000fe20000000006ULL,
0x000000044808723cULL, 0x040fe20000041808ULL, 0x000010548e077816ULL, 0x000fe40000000007ULL,
0x0000a000447a7811ULL, 0x000fe400078e20ffULL, 0x00000093ff68723eULL, 0x000fe400020006ffULL,
0x00000010ff047819ULL, 0x000fe20000011678ULL, 0x00000006480c723cULL, 0x000fe2000004180cULL,
0x00000010ff057819ULL, 0x000fe20000011679ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x000fc4000001168dULL, 0x00000010ff797819ULL, 0x000fe4000001168fULL,
0x0000105404787816ULL, 0x000fe40000000078ULL, 0x0000105405797816ULL, 0x000fe40000000079ULL,
0x000000007a04783bULL, 0x0004e20000000200ULL, 0x00000008ff937819ULL, 0x000fe4000001169dULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x000000784810723cULL, 0x000fe20000041810ULL, 0x00000087ff87723eULL, 0x000fc400020006ffULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000008ff4c7819ULL, 0x000fe2000001164cULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000067ff747230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000081ff7e723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000000ff4d7a7812ULL, 0x004fe200078ec0ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000091ff81723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x0000004cff4d723eULL, 0x000fc400020006ffULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe40000011692ULL,
0x00000010ff4c7819ULL, 0x000fe40000011675ULL, 0x00000010ff757819ULL, 0x000fe40000011693ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x0000006204049231ULL, 0x088fe200003400ffULL, 0x0000105491917816ULL, 0x000fe20000000076ULL,
0x2000004dff767230ULL, 0x000fe20000004100ULL, 0x00000008ff807819ULL, 0x000fe20000011680ULL,
0x0000006206069231ULL, 0x000fe200003400ffULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x0000006105059231ULL, 0x080fe200003400ffULL, 0x000010544c757816ULL, 0x000fe20000000075ULL,
0x0000006107079231ULL, 0x000fe200003400ffULL, 0x00000010ff777819ULL, 0x000fc40000011677ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff4d7819ULL, 0x000fe40000011672ULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x00001054874c7816ULL, 0x000fc40000000073ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff877819ULL, 0x000fe4000001164fULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x0000105490907816ULL, 0x000fe20000000077ULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x0000105474747816ULL, 0x000fe20000000085ULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00001054944d7816ULL, 0x000fe4000000004dULL, 0x0000105471867816ULL, 0x000fe20000000086ULL,
0x000000904814723cULL, 0x000fe20000041814ULL, 0x0000105487877816ULL, 0x000fe40000000084ULL,
0x00000010ff717819ULL, 0x000fc4000001164eULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6f7819ULL, 0x000fe2000001166fULL, 0x000000744818723cULL, 0x040fe20000041818ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x0000004c484c723cULL, 0x000fe2000004181cULL, 0x000000ff82827812ULL, 0x000fc400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff1d7819ULL, 0x000fe2000001166dULL, 0x000000864848723cULL, 0x000fe20000041820ULL,
0x000010547e1c7816ULL, 0x000fe4000000006cULL, 0x00001054811d7816ULL, 0x000fe4000000001dULL,
0x00000008ff547819ULL, 0x000fc40000011654ULL, 0x00000010ff217819ULL, 0x000fe4000001167fULL,
0x000010546e207816ULL, 0x000fe20000000080ULL, 0x0000001c041c723cULL, 0x040fe2000004180cULL,
0x000010546f217816ULL, 0x000fe40000000021ULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00000008ff007819ULL, 0x000fe40000011600ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000200420723cULL, 0x000fe20000041808ULL, 0x00000010ff7d7819ULL, 0x000fc4000001167dULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff097819ULL, 0x000fe4000001166aULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff0d7819ULL, 0x000fc40000011676ULL,
0x00000096ff67723eULL, 0x000fe400020006ffULL, 0x00000097ff66723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x000010547d087816ULL, 0x000fe2000000006bULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000010547b097816ULL, 0x000fe20000000009ULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x00001054680c7816ULL, 0x000fc4000000007cULL, 0x00001054690d7816ULL, 0x000fe4000000000dULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x000000080414723cULL, 0x040fe20000041814ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff837819ULL, 0x000fe40000011695ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x0000000c040c723cULL, 0x000fe20000041818ULL, 0x00000010ff097819ULL, 0x000fc40000011666ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff197819ULL, 0x000fe40000011654ULL, 0x00000010ff557819ULL, 0x000fc40000011655ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x0000105482827816ULL, 0x000fe40000000071ULL,
0x0000105483837816ULL, 0x000fe40000000070ULL, 0x000010547a087816ULL, 0x000fc40000000067ULL,
0x0000105464097816ULL, 0x000fe40000000009ULL, 0x0000105463187816ULL, 0x000fe2000000005cULL,
0x000000820450723cULL, 0x000fe20000041850ULL, 0x0000105465197816ULL, 0x000fe40000000019ULL,
0x00001054555a7816ULL, 0x000fe4000000005aULL, 0x000010545b5b7816ULL, 0x000fc60000000000ULL,
0x000000080408723cULL, 0x040ff0000004184cULL, 0x000000180418723cULL, 0x040ff00000041810ULL,
0x0000005a0404723cULL, 0x000fe20000041848ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff107f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007844811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000127305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000120000735dULL, 0x008fe40003800000ULL,
0x0106bc00ff127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004024007811ULL, 0x000fe200078e40ffULL,
0x00000100ff4d7424ULL, 0x000fe200078e00ffULL, 0x00000004ff4b7819ULL, 0x000fe40000011626ULL,
0x0000000003107217ULL, 0x000fe40007800000ULL, 0x0000c000604e7811ULL, 0x000fc600078e20ffULL,
0x0000000110107824ULL, 0x100fe400078e0a00ULL, 0x0000620028007a24ULL, 0x000fc600078e0200ULL,
0x0000002010107807ULL, 0x000fe20000000000ULL, 0x000000012e117824ULL, 0x100fe400078e0200ULL,
0x0000000133137824ULL, 0x100fe200078e0200ULL, 0x0000001027127217ULL, 0x000fe20007800000ULL,
0x0000000134487824ULL, 0x000fe400078e0200ULL, 0x00005e0011107625ULL, 0x000fc800078e004dULL,
0x00000001124c7824ULL, 0x000fe200078e0a27ULL, 0x0000002f10107210ULL, 0x000fe20007f7e0ffULL,
0x00005e0013127625ULL, 0x000fc600078e004dULL, 0x0000004c4b00720cULL, 0x000fe20003f46070ULL,
0x00005e0048487625ULL, 0x000fe200078e004dULL, 0x0000002f12127210ULL, 0x000fc60007f9e0ffULL,
0x00000001354a7824ULL, 0x000fe200078e0200ULL, 0x0000002f48487210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x0000004c3000720cULL, 0x000fe20003f66070ULL,
0x00005e004a4a7625ULL, 0x000fe200078e004dULL, 0x0000c0005f4d7811ULL, 0x000fc600078e20ffULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x0000004c3100720cULL, 0x080fe20003f86070ULL,
0x000000ffff497224ULL, 0x000fe200028e0649ULL, 0x0000004c3200720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000104e7faeULL, 0x0005e2000d101c46ULL,
0x0000002f4a547210ULL, 0x000fe40007fde0ffULL, 0x0000c0005e4c7811ULL, 0x000fe200078e20ffULL,
0x00000000124d7faeULL, 0x0005e4000d901c46ULL, 0x000000ffff557224ULL, 0x000fe200030e064bULL,
0x0000c0005d4b7811ULL, 0x000fc600078e20ffULL, 0x00000000484c7faeULL, 0x0005e8000e101c46ULL,
0x00000000544b7faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff107f8cULL, 0x004fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x006fc40007844847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4f7224ULL, 0x000fe200078e0011ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000107305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x0106b400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007844847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002dff00723eULL, 0x000fe400000010ffULL,
0x00000002ff5b7819ULL, 0x000fe40000011626ULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x000162827f007947ULL, 0x000fea000b800000ULL, 0x00001f5b5a647589ULL, 0x0002a400000e0000ULL,
0x000162c27f007947ULL, 0x000fea000b800000ULL, 0x00001f365a657589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x002fe200078e0037ULL,
0x00003980005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0001721000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x002fe200078e0038ULL,
0x000039e0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x000171b000007944ULL, 0x01cfea0003c00000ULL,
0x0000e000594a7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000e00056487811ULL, 0x000fe400078e20ffULL, 0x0000e00057497811ULL, 0x000fe200078e20ffULL,
0x000000004a10783bULL, 0x000f620000004200ULL, 0x0000e00045477811ULL, 0x000fe400078e20ffULL,
0x0000000731467812ULL, 0x100fe200078e7858ULL, 0x000000004860783bULL, 0x000e620000004200ULL,
0x0000000732457812ULL, 0x000fc600078e7858ULL, 0x00000000495c783bULL, 0x000ee20000004200ULL,
0x0000000858467824ULL, 0x040fe400078e0246ULL, 0x0000000858457824ULL, 0x000fe200078e0245ULL,
0x000000004754783bULL, 0x000f220000004200ULL, 0x00000010ff8a7819ULL, 0x120fe40000011612ULL,
0x000000ff126b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011612ULL,
0x0000ffff129b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff127819ULL, 0x000fe40000011613ULL,
0x00000018ff767819ULL, 0x002fe40000011660ULL, 0x00000010ff667819ULL, 0x100fe40000011610ULL,
0x00000018ff887819ULL, 0x000fe40000011661ULL, 0x00000018ff007819ULL, 0x004fe40000011610ULL,
0x000000ff11677812ULL, 0x000fc400078ec0ffULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x00000018ff727819ULL, 0x008fe4000001165eULL, 0x000000ff60777812ULL, 0x000fe400078ec0ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000000ff66667812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fe40000011613ULL,
0x000000ff136e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff139c7812ULL, 0x000fe400078ec0ffULL,
0x00000000ff5b723eULL, 0x000fe400020006ffULL, 0x00000067ff81723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x000fe20000011611ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000018ff137819ULL, 0x000fe2000001165cULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x000000ff5f757812ULL, 0x000fc400078ec0ffULL, 0x00000010ff847819ULL, 0x000fe40000011661ULL,
0x000000ff61797812ULL, 0x040fe400078ec0ffULL, 0x0000ffff61827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x110fe40000011657ULL, 0x000000ff57987812ULL, 0x000fe400078ec0ffULL,
0x00000018ff977819ULL, 0x000fc40000011657ULL, 0x0000ffff57007812ULL, 0x000fe200078ec0ffULL,
0x20000012ff577230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000077ff61723eULL, 0x000fe200020006ffULL, 0x20000076ff777230ULL, 0x000fe20000004100ULL,
0x00000066ff12723eULL, 0x000fe200020006ffULL, 0x20000088ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe2000001165cULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x000000ff5c6f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff5c9d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe40000011662ULL, 0x0000ffff119a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x100fe40000011663ULL, 0x000000ff63907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fc40000011663ULL, 0x0000ffff63587812ULL, 0x000fe400078ec0ffULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x000000ff87887812ULL, 0x000fe200078ec0ffULL, 0x20000012ff877230ULL, 0x000fe20000004100ULL,
0x00000079ff63723eULL, 0x000fe200020006ffULL, 0x20000072ff797230ULL, 0x000fe20000004100ULL,
0x0000ffff10997812ULL, 0x000fe200078ec0ffULL, 0x20000013ff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff5e737812ULL, 0x000fe200078ec0ffULL, 0x20000075ff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff628b7812ULL, 0x000fe200078ec0ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000089ff72723eULL, 0x000fc400020006ffULL, 0x00000008ff897819ULL, 0x000fe4000001169aULL,
0x00000088ff12723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000008bff75723eULL, 0x000fe400020006ffULL, 0x00000008ff137819ULL, 0x000fe20000011699ULL,
0x20000073ff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff8a8b7812ULL, 0x000fe200078ec0ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x00000089ff8a723eULL, 0x000fe200020006ffULL,
0x20000012ff897230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x00000010ff8f7819ULL, 0x000fe2000001165dULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000013ff13723eULL, 0x000fe400020006ffULL, 0x00000008ff127819ULL, 0x000fe4000001169bULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000013ff887230ULL, 0x000fe20000004100ULL,
0x0000008dff73723eULL, 0x000fe200020006ffULL, 0x2000008cff8d7230ULL, 0x000fe20000004100ULL,
0x00000018ff917819ULL, 0x000fe20000011654ULL, 0x2000006fff7e7230ULL, 0x000fe20000004100ULL,
0x00000018ff707819ULL, 0x000fe2000001165dULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000012ff12723eULL, 0x000fc400020006ffULL, 0x000000ff8f8c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff137819ULL, 0x000fe4000001169cULL, 0x00000091ff6f723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000008cff91723eULL, 0x000fe200020006ffULL,
0x20000012ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff105a7812ULL, 0x000fe200078ec0ffULL,
0x20000070ff7d7230ULL, 0x000fe20000004100ULL, 0x00000018ff687819ULL, 0x000fe20000011611ULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff107819ULL, 0x000fe2000001165eULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff117819ULL, 0x000fc4000001165fULL,
0x000000ff55947812ULL, 0x000fe400078ec0ffULL, 0x00000018ff937819ULL, 0x100fe40000011655ULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000013ff13723eULL, 0x000fe400020006ffULL,
0x0000a00046127811ULL, 0x000fe400078e20ffULL, 0x00000010ff787819ULL, 0x000fc40000011655ULL,
0x0000ffff556c7812ULL, 0x000fe400078ec0ffULL, 0x0000006eff55723eULL, 0x000fe400020006ffULL,
0x00000094ff70723eULL, 0x000fe400020006ffULL, 0x00000093ff6e723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x0000008eff8f723eULL, 0x000fe200020006ffULL,
0x20000013ff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff10937812ULL, 0x000fe200078ec0ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x000000ff11947812ULL, 0x000fe200078ec0ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x000000001210783bULL, 0x000e620000000200ULL,
0x0000ffff5e857812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x0000ffff5f867812ULL, 0x000fc400078ec0ffULL, 0x00000010ff837819ULL, 0x000fe40000011660ULL,
0x00000018ff747819ULL, 0x000fe4000001165fULL, 0x0000ffff60807812ULL, 0x000fe400078ec0ffULL,
0x00000018ff957819ULL, 0x000fe40000011656ULL, 0x00000008ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff5f7819ULL, 0x000fc40000011662ULL, 0x00000008ff867819ULL, 0x000fe40000011686ULL,
0x000000ff83837812ULL, 0x000fe400078ec0ffULL, 0x00000068ff5e723eULL, 0x000fe400020006ffULL,
0x00000095ff68723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff807819ULL, 0x000fe20000011680ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000086ff95723eULL, 0x000fe200020006ffULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fc400078ec0ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000095ff857230ULL, 0x000fe20000004100ULL,
0x000000ff5d717812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5d9e7812ULL, 0x000fe200078ec0ffULL,
0x20000083ff957230ULL, 0x000fe20000004100ULL, 0x0000005aff5d723eULL, 0x000fe200020006ffULL,
0x0000006410109231ULL, 0x082fe200003400ffULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x0000006412129231ULL, 0x000fe200003400ffULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x0000006511119231ULL, 0x080fe200003400ffULL, 0x000000ff84847812ULL, 0x000fe200078ec0ffULL,
0x0000006513139231ULL, 0x000fe200003400ffULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x00000082ff83723eULL, 0x000fe200020006ffULL, 0x20000080ff827230ULL, 0x000fe20000004100ULL,
0x0000ffff62597812ULL, 0x000fe200078ec0ffULL, 0x2000005fff807230ULL, 0x000fe20000004100ULL,
0x000000ff56967812ULL, 0x000fe200078ec0ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x0000005cff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff5a7819ULL, 0x000fc40000011654ULL, 0x000000ff54927812ULL, 0x040fe400078ec0ffULL,
0x0000ffff54607812ULL, 0x000fe400078ec0ffULL, 0x00000008ff597819ULL, 0x000fe40000011659ULL,
0x0000006bff54723eULL, 0x000fe400020006ffULL, 0x00000010ff5c7819ULL, 0x000fe4000001165dULL,
0x00000096ff6b723eULL, 0x000fe200020006ffULL, 0x20000084ff967230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fe20000011681ULL, 0x2000005fff817230ULL, 0x000fe20000004100ULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000059ff84723eULL, 0x000fc400020006ffULL, 0x00000008ff5f7819ULL, 0x000fe40000011658ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff587819ULL, 0x000fe40000011688ULL,
0x00000010ff597819ULL, 0x000fe4000001168aULL, 0x00001054875c7816ULL, 0x000fc4000000005cULL,
0x00001054895d7816ULL, 0x000fe4000000005dULL, 0x000010545b587816ULL, 0x000fe40000000058ULL,
0x000010545e597816ULL, 0x000fe40000000059ULL, 0x00000010ff6d7819ULL, 0x000fe40000011656ULL,
0x0000ffff56697812ULL, 0x000fe400078ec0ffULL, 0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL,
0x0000006aff56723eULL, 0x000fe400020006ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x0000005fff87723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x0000005c105c723cULL, 0x000fe20000041850ULL, 0x20000071ff7f7230ULL, 0x000fe20000004100ULL,
0x00000074ff62723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000090ff74723eULL, 0x000fc400020006ffULL, 0x00000092ff71723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000005aff52723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000000581058723cULL, 0x000fe20000041820ULL,
0x00000008ff907819ULL, 0x000fe2000001169dULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff927819ULL, 0x000fe2000001169eULL, 0x20000052ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x0000a00045207811ULL, 0x000fc400078e20ffULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff507819ULL, 0x000fe4000001168cULL,
0x00000010ff517819ULL, 0x000fe2000001168eULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x0000105456507816ULL, 0x000fe20000000050ULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x0000105457517816ULL, 0x000fe20000000051ULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fc4000001167cULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff907819ULL, 0x000fe20000011690ULL, 0x000000501050723cULL, 0x000fe20000041818ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff197819ULL, 0x000fc40000011692ULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x000010547c187816ULL, 0x000fe20000000090ULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x000010547d197816ULL, 0x000fe20000000019ULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x000010548b547816ULL, 0x000fc40000000054ULL,
0x000010548d557816ULL, 0x000fe40000000055ULL, 0x000000ff78787812ULL, 0x000fe200078ec0ffULL,
0x000000181018723cULL, 0x040fe2000004180cULL, 0x00000008ff607819ULL, 0x000fe20000011660ULL,
0x0000006420209231ULL, 0x082fe200003400ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x0000006422229231ULL, 0x000fe200003400ffULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x0000006521219231ULL, 0x080fe200003400ffULL, 0x00000010ff0c7819ULL, 0x000fe20000011661ULL,
0x000000541054723cULL, 0x000fe2000004181cULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x20000078ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x20000060ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x0000006523239231ULL, 0x000fe200003400ffULL, 0x00000010ff917819ULL, 0x000fc40000011691ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff1d7819ULL, 0x000fe4000001167bULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff867819ULL, 0x000fc40000011686ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff617819ULL, 0x000fe40000011685ULL,
0x000010548f7e7816ULL, 0x000fe4000000007eULL, 0x00001054917f7816ULL, 0x000fe4000000007fULL,
0x00001054931c7816ULL, 0x000fe4000000007aULL, 0x00001054941d7816ULL, 0x000fc4000000001dULL,
0x0000105479607816ULL, 0x000fe20000000086ULL, 0x0000007e1014723cULL, 0x040fe20000041814ULL,
0x0000105462617816ULL, 0x000fe40000000061ULL, 0x00000010ff0d7819ULL, 0x000fe40000011663ULL,
0x00000008ff6c7819ULL, 0x000fe4000001166cULL, 0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL,
0x0000001c101c723cULL, 0x000fe20000041808ULL, 0x000000ff67677812ULL, 0x000fc400078ec0ffULL,
0x00000008ff697819ULL, 0x000fe40000011669ULL, 0x00000008ff007819ULL, 0x000fe40000011600ULL,
0x00000010ff957819ULL, 0x000fe20000011695ULL, 0x000000601060723cULL, 0x000fe20000041804ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff117819ULL, 0x000fe40000011687ULL, 0x00000098ff6a723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00001054950c7816ULL, 0x000fe2000000000cULL,
0x20000097ff667230ULL, 0x000fe20000004100ULL, 0x00001054960d7816ULL, 0x000fe2000000000dULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x0000105472107816ULL, 0x000fc40000000084ULL,
0x0000105473117816ULL, 0x000fe40000000011ULL, 0x00000010ff777819ULL, 0x000fe20000011677ULL,
0x0000000c2004723cULL, 0x040fe2000004185cULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff097819ULL, 0x000fe40000011683ULL,
0x00000010ff757819ULL, 0x000fe20000011675ULL, 0x000000102010723cULL, 0x000fe20000041850ULL,
0x00000010ff0d7819ULL, 0x000fc40000011674ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff897819ULL, 0x000fc40000011689ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff6d7819ULL, 0x000fc4000001166dULL, 0x00000010ff517819ULL, 0x000fe4000001166aULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff007819ULL, 0x000fc40000011600ULL, 0x0000105477087816ULL, 0x000fe40000000082ULL,
0x0000105476097816ULL, 0x000fe40000000009ULL, 0x00001054800c7816ULL, 0x000fe40000000075ULL,
0x00001054810d7816ULL, 0x000fe4000000000dULL, 0x0000105488887816ULL, 0x000fe20000000071ULL,
0x000000082008723cULL, 0x000fe20000041858ULL, 0x0000105489897816ULL, 0x000fc40000000070ULL,
0x000010546f787816ULL, 0x000fe40000000078ULL, 0x000010546e797816ULL, 0x000fe4000000006cULL,
0x000010546d507816ULL, 0x000fe2000000006bULL, 0x0000000c200c723cULL, 0x000fe20000041854ULL,
0x0000105467517816ULL, 0x000fe40000000051ULL, 0x0000105468687816ULL, 0x000fe40000000069ULL,
0x0000105466697816ULL, 0x000fc60000000000ULL, 0x000000882014723cULL, 0x040ff00000041814ULL,
0x000000782018723cULL, 0x040ff00000041818ULL, 0x00000050201c723cULL, 0x040ff0000004181cULL,
0x000000682020723cULL, 0x000fe20000041860ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff507f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004024007811ULL, 0x000fe200078e40ffULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff507224ULL, 0x002fc400078e0051ULL,
0x000000000300720cULL, 0x000fda0003f24070ULL, 0x0000bee000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824850ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824850ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000517305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000510000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff517984ULL, 0x000e640000000800ULL,
0x8000000051ff7812ULL, 0x002fc40007824850ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000006024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff587424ULL, 0x000fe200078e00ffULL,
0x00000004ff557819ULL, 0x000fe40000011626ULL, 0x0000000003507217ULL, 0x000fe20007800000ULL,
0x0000620028547a24ULL, 0x000fc800078e0200ULL, 0x0000000150507824ULL, 0x000fe400078e0a00ULL,
0x000000012e517824ULL, 0x100fe400078e0254ULL, 0x0000000133527824ULL, 0x000fe200078e0254ULL,
0x0000002050007807ULL, 0x000fe20000000000ULL, 0x00005e0051507625ULL, 0x000fc600078e0058ULL,
0x0000000027007217ULL, 0x000fe20007800000ULL, 0x00005e0052527625ULL, 0x000fe200078e0058ULL,
0x0000002f50567210ULL, 0x000fc60007f3e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000002f52527210ULL, 0x000fe20007f7e0ffULL, 0x0000000134507824ULL, 0x100fe400078e0254ULL,
0x0000000135547824ULL, 0x000fe200078e0254ULL, 0x000000005500720cULL, 0x080fe20003f46070ULL,
0x000000ffff577224ULL, 0x000fe200008e0651ULL, 0x000000003000720cULL, 0x000fe20003f26070ULL,
0x00005e0050507625ULL, 0x000fe200078e0058ULL, 0x000000003200720cULL, 0x000fc60003f86070ULL,
0x00005e0054547625ULL, 0x000fe200078e0058ULL, 0x0000002f50507210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff537224ULL, 0x000fe200018e0653ULL, 0x000000003100720cULL, 0x000fe20003f66070ULL,
0x000000ffff517224ULL, 0x000fe200028e0651ULL, 0x0000002f54547210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000056397faeULL, 0x0003e8000d101c46ULL,
0x000000ffff557224ULL, 0x000fe200030e0655ULL, 0x00000000523a7faeULL, 0x0003ea000c901c46ULL,
0x00000000503b7faeULL, 0x0003e8000d901c46ULL, 0x00000000543c7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff687f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280027507f8cULL, 0x002fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc6000784484fULL,
0x01062c0027527984ULL, 0x000e640000000800ULL, 0x8000000052ff7812ULL, 0x002fe40007824851ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000527305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000520000735dULL, 0x008fe40003800000ULL, 0x01062c0027527984ULL, 0x000e640000000800ULL,
0x8000000052ff7812ULL, 0x002fc40007824851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010080003d527984ULL, 0x000e680000000800ULL, 0x010280003d537984ULL, 0x0007220000000800ULL,
0x000000295200720bULL, 0x002fe20003f3d000ULL, 0x000145227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00547812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff507424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000010200780cULL, 0x000fe40003f65270ULL,
0x000000295200720bULL, 0x000fe20003f34000ULL, 0x000144e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x0000005229507209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x8000005029517221ULL, 0x000fe20000010000ULL,
0x010480503d00b388ULL, 0x0003e20000000800ULL, 0x0000000054ff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b51517820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fca0000011626ULL,
0x0000005100517308ULL, 0x000ee40000000800ULL, 0x000000512a2a7220ULL, 0x008fe20000410000ULL,
0x000144727f007947ULL, 0x000fea000b800000ULL, 0x00001f0051007589ULL, 0x0022e400000e0000ULL,
0x0000000004047220ULL, 0x08cfe20000410000ULL, 0x0000000005057220ULL, 0x080fe20000410000ULL,
0x0000000008087220ULL, 0x080fe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x000fe20000410000ULL,
0x000143c27f007947ULL, 0x000fea000b800000ULL, 0x00001f3651007589ULL, 0x0004e400000e0000ULL,
0x0000005229297209ULL, 0x000fe20007810000ULL, 0x0000000006067220ULL, 0x08cfe20000410000ULL,
0x00000001ff507807ULL, 0x000fe20000800000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x8000002952521221ULL, 0x000fe20000010000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b52521820ULL, 0x000fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x00000052002d1308ULL, 0x000ea20000000800ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x000fe20000410000ULL, 0x000000532d531220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002a532a7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc4000782484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000517305ULL, 0x0022e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000510000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff517984ULL, 0x000e640000000800ULL, 0x8000000051ff7812ULL, 0x002fe4000782484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002dff00723eULL, 0x000fe400000010ffULL,
0x00000002ff4f7819ULL, 0x000fc40000011626ULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x000141727f007947ULL, 0x000fea000b800000ULL, 0x00001f4f5a4f7589ULL, 0x00072400000e0000ULL,
0x000141c27f007947ULL, 0x000fea000b800000ULL, 0x00001f365a6a7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0037ULL,
0x00005cc0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00014ed000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0038ULL,
0x00005d20005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00014e7000007944ULL, 0x01efea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004058783bULL, 0x00ae620000004200ULL,
0x0000991050007816ULL, 0x004fc600000000ffULL, 0x000000003f5c783bULL, 0x000ea20000004200ULL,
0x000000ff0000720cULL, 0x000fc60003f25270ULL, 0x000000004154783bULL, 0x000ee80000004200ULL,
0x000000004250783bULL, 0x000f620000004200ULL, 0x000000ff58667812ULL, 0x002fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fe4000001165aULL, 0x000000ff5d617812ULL, 0x004fe400078ec0ffULL,
0x000000ff5c607812ULL, 0x000fc400078ec0ffULL, 0x000000ff567a7812ULL, 0x008fe400078ec0ffULL,
0x000000ff577b7812ULL, 0x000fe400078ec0ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000010ff857819ULL, 0x100fe40000011655ULL, 0x000000ff55787812ULL, 0x000fe200078ec0ffULL,
0x20000066ff7f7230ULL, 0x000fe20000004100ULL, 0x00000018ff777819ULL, 0x000fc40000011655ULL,
0x0000ffff55837812ULL, 0x000fe400078ec0ffULL, 0x00000061ff82723eULL, 0x000fe400020006ffULL,
0x00000010ff6b7819ULL, 0x000fe4000001165cULL, 0x000000ff5a707812ULL, 0x040fe200078ec0ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000018ff6f7819ULL, 0x000fe4000001165aULL,
0x0000ffff5a867812ULL, 0x000fc400078ec0ffULL, 0x00000060ff55723eULL, 0x000fe400020006ffULL,
0x00000010ff617819ULL, 0x120fe40000011651ULL, 0x000000ff51947812ULL, 0x040fe200078ec0ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000018ff937819ULL, 0x000fe40000011651ULL,
0x0000ffff51717812ULL, 0x000fe400078ec0ffULL, 0x00000018ff797819ULL, 0x000fc40000011656ULL,
0x00000010ff5a7819ULL, 0x100fe40000011650ULL, 0x000000ff50917812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8f7819ULL, 0x000fe40000011650ULL, 0x0000ffff50607812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x000fe40000011652ULL, 0x000000ff52957812ULL, 0x000fc400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe40000011652ULL, 0x0000ffff526e7812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000018ff527819ULL, 0x000fe40000011653ULL,
0x0000007bff50723eULL, 0x000fe400020006ffULL, 0x000000ff596c7812ULL, 0x000fc400078ec0ffULL,
0x00000078ff66723eULL, 0x000fe400020006ffULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x00000079ff78723eULL, 0x000fe200020006ffULL, 0x2000007aff797230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x20000050ff7a7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe2000001165dULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x2000006cff807230ULL, 0x000fe20000004100ULL,
0x0000006bff50723eULL, 0x000fe200020006ffULL, 0x20000052ff6b7230ULL, 0x000fe20000004100ULL,
0x0000ffff5c977812ULL, 0x000fe200078ec0ffULL, 0x20000051ff6c7230ULL, 0x000fe20000004100ULL,
0x0000ffff5d987812ULL, 0x000fc400078ec0ffULL, 0x000000ff8b527812ULL, 0x000fe200078ec0ffULL,
0x20000050ff8b7230ULL, 0x000fe20000004100ULL, 0x00000018ff007819ULL, 0x000fe4000001165cULL,
0x00000008ff517819ULL, 0x000fe40000011697ULL, 0x00000008ff507819ULL, 0x000fe40000011698ULL,
0x00000010ff8c7819ULL, 0x000fe4000001165eULL, 0x00000010ff8d7819ULL, 0x000fc4000001165fULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000010ff907819ULL, 0x100fe40000011658ULL,
0x00000018ff657819ULL, 0x000fe20000011658ULL, 0x20000077ff7c7230ULL, 0x000fe20000004100ULL,
0x0000ffff589b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe40000011654ULL,
0x00000018ff8e7819ULL, 0x000fc40000011657ULL, 0x00000000ff58723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe40000011653ULL,
0x000000ff53967812ULL, 0x040fe400078ec0ffULL, 0x0000ffff53007812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5e997812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c537812ULL, 0x000fe200078ec0ffULL,
0x20000051ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x0000008eff77723eULL, 0x000fe200020006ffULL, 0x20000050ff8e7230ULL, 0x000fe20000004100ULL,
0x00000018ff737819ULL, 0x000fe2000001165bULL, 0x20000065ff7d7230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000075ff7b7230ULL, 0x000fe20000004100ULL,
0x0000008dff51723eULL, 0x000fe200020006ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000008ff507819ULL, 0x000fc40000011699ULL, 0x00000010ff927819ULL, 0x000fe40000011659ULL,
0x00000018ff647819ULL, 0x000fe4000001165fULL, 0x0000ffff5f9a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe40000011659ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x000000ff54767812ULL, 0x000fc400078ec0ffULL, 0x00000073ff65723eULL, 0x000fe200020006ffULL,
0x20000052ff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff5e637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe2000001165eULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000091ff75723eULL, 0x000fe200020006ffULL, 0x20000051ff917230ULL, 0x000fe20000004100ULL,
0x0000008fff73723eULL, 0x000fe200020006ffULL, 0x20000053ff8f7230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x000000ff90907812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff5f5e7812ULL, 0x000fc400078ec0ffULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x00000064ff5f723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff517819ULL, 0x000fe2000001169aULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff537819ULL, 0x000fe2000001169bULL, 0x20000067ff7e7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fc400020006ffULL, 0x00000076ff64723eULL, 0x000fe400020006ffULL,
0x00000094ff76723eULL, 0x000fe200020006ffULL, 0x20000070ff677230ULL, 0x000fe20000004100ULL,
0x00000090ff52723eULL, 0x000fe200020006ffULL, 0x20000050ff907230ULL, 0x000fe20000004100ULL,
0x000000ff5b747812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000092ff94723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fc400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000a80043507811ULL, 0x000fe200078e20ffULL, 0x20000051ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe4000001165bULL, 0x0000ffff5b877812ULL, 0x000fe400078ec0ffULL,
0x00000063ff5b723eULL, 0x000fe400020006ffULL, 0x00000074ff63723eULL, 0x000fc400020006ffULL,
0x00000095ff70723eULL, 0x000fe200020006ffULL, 0x20000094ff957230ULL, 0x000fe20000004100ULL,
0x00000093ff74723eULL, 0x000fe200020006ffULL, 0x20000052ff937230ULL, 0x000fe20000004100ULL,
0x00000018ff5c7819ULL, 0x000fe2000001165dULL, 0x20000053ff947230ULL, 0x000fe20000004100ULL,
0x0000ffff54817812ULL, 0x000fe200078ec0ffULL, 0x000000005050783bULL, 0x000e620000000200ULL,
0x00000010ff5d7819ULL, 0x000fe20000011656ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff85857812ULL, 0x000fe200078ec0ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff817819ULL, 0x000fe20000011681ULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fc40000011654ULL, 0x00000010ff547819ULL, 0x000fe40000011657ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000085ff987230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fe200078ec0ffULL, 0x20000081ff857230ULL, 0x000fe20000004100ULL,
0x0000ffff598a7812ULL, 0x000fe200078ec0ffULL, 0x2000005dff817230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fc40000011683ULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x0000005cff59723eULL, 0x000fe400020006ffULL, 0x0000ffff56567812ULL, 0x000fe400078ec0ffULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000054ff5d723eULL, 0x000fe200020006ffULL,
0x20000084ff977230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe20000011655ULL,
0x20000083ff847230ULL, 0x000fe20000004100ULL, 0x0000ffff57577812ULL, 0x000fe200078ec0ffULL,
0x0000004f50509231ULL, 0x092fe200003400ffULL, 0x00000008ff567819ULL, 0x000fe20000011656ULL,
0x0000004f52529231ULL, 0x000fe200003400ffULL, 0x00000010ff557819ULL, 0x000fe20000011682ULL,
0x2000005dff827230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe2000001168bULL,
0x0000006a51519231ULL, 0x080fe200003400ffULL, 0x00000010ff8d7819ULL, 0x000fe2000001168dULL,
0x0000006a53539231ULL, 0x000fe200003400ffULL, 0x00000056ff83723eULL, 0x000fc400020006ffULL,
0x000010548b547816ULL, 0x000fe40000000054ULL, 0x000010548d557816ULL, 0x000fe20000000055ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff5d7819ULL, 0x000fe40000011657ULL,
0x00000010ff567819ULL, 0x000fe40000011658ULL, 0x00000010ff577819ULL, 0x000fe40000011659ULL,
0x00000010ff587819ULL, 0x000fc4000001168cULL, 0x00000010ff597819ULL, 0x000fe4000001168eULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fe40000011686ULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x0000005eff5c723eULL, 0x000fc400020006ffULL, 0x0000105456587816ULL, 0x000fe40000000058ULL,
0x0000105457597816ULL, 0x000fe20000000059ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x000000545054723cULL, 0x000fe20000041804ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000062ff5e723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x0000005aff05723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000a80044047811ULL, 0x000fe400078e20ffULL,
0x0000006fff62723eULL, 0x000fe200020006ffULL, 0x20000005ff8b7230ULL, 0x000fe20000004100ULL,
0x00000096ff6f723eULL, 0x000fe200020006ffULL, 0x20000089ff967230ULL, 0x000fe20000004100ULL,
0x000000000404783bULL, 0x000e620000000200ULL, 0x20000086ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x20000087ff867230ULL, 0x000fe20000004100ULL,
0x0000005dff87723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165cULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x000fe2000001168fULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x000010545c5c7816ULL, 0x000fe4000000005bULL,
0x000000585058723cULL, 0x000fe20000041808ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff087819ULL, 0x000fe40000011690ULL, 0x00000010ff097819ULL, 0x000fc40000011692ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x000010545e087816ULL, 0x000fe40000000008ULL,
0x000010545f097816ULL, 0x000fe40000000009ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff0b7819ULL, 0x000fe20000011680ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x000000085010723cULL, 0x040fe20000041810ULL, 0x00000010ff957819ULL, 0x000fe20000011695ULL,
0x0000004f04049231ULL, 0x082fe200003400ffULL, 0x00001054915d7816ULL, 0x000fe2000000005dULL,
0x0000004f06069231ULL, 0x000fe200003400ffULL, 0x00000008ff607819ULL, 0x000fe20000011660ULL,
0x0000006a05059231ULL, 0x080fe200003400ffULL, 0x00001054930a7816ULL, 0x000fe2000000007fULL,
0x0000006a07079231ULL, 0x000fe200003400ffULL, 0x00001054950b7816ULL, 0x000fe2000000000bULL,
0x0000005c505c723cULL, 0x000fe2000004180cULL, 0x000000ff61617812ULL, 0x000fc400078ec0ffULL,
0x00000010ff097819ULL, 0x000fe40000011662ULL, 0x00000010ff087819ULL, 0x000fe40000011689ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x0000000a5014723cULL, 0x000fe20000041814ULL,
0x00000061ff0c723eULL, 0x000fe400020006ffULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x20000060ff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x2000000cff807230ULL, 0x000fe20000004100ULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x00000010ff617819ULL, 0x000fe4000001168aULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x0000105409087816ULL, 0x000fc40000000008ULL,
0x00000010ff0a7819ULL, 0x000fe40000011665ULL, 0x00000010ff097819ULL, 0x000fe40000011686ULL,
0x000010547d607816ULL, 0x000fe40000000094ULL, 0x000010547e617816ULL, 0x000fe40000000061ULL,
0x0000105488887816ULL, 0x000fe40000000067ULL, 0x0000105496897816ULL, 0x000fc40000000063ULL,
0x000010540a097816ULL, 0x000fe20000000009ULL, 0x000000605060723cULL, 0x040fe20000041818ULL,
0x00000010ff0b7819ULL, 0x000fe40000011664ULL, 0x00000010ff0c7819ULL, 0x000fe40000011666ULL,
0x00000008ff717819ULL, 0x000fe40000011671ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x000000885064723cULL, 0x000fe2000004181cULL, 0x000000ff6d6d7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x000000085050723cULL, 0x000fe20000041820ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff1d7819ULL, 0x000fe40000011687ULL,
0x00000008ff007819ULL, 0x000fc40000011600ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00001054781c7816ULL, 0x000fe20000000083ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00001054771d7816ULL, 0x000fe2000000001dULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fc400020006ffULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00000010ff197819ULL, 0x000fe20000011676ULL,
0x0000001c041c723cULL, 0x000fe20000041810ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff987819ULL, 0x000fc40000011698ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff117819ULL, 0x000fe40000011671ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff0d7819ULL, 0x000fe40000011684ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff217819ULL, 0x000fe4000001167aULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff137819ULL, 0x000fe4000001166fULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x00001054970a7816ULL, 0x000fe4000000000bULL, 0x000010548b187816ULL, 0x000fe40000000075ULL,
0x0000105480197816ULL, 0x000fe40000000019ULL, 0x00001054980b7816ULL, 0x000fc4000000000cULL,
0x0000105473107816ULL, 0x000fe4000000007fULL, 0x0000105474117816ULL, 0x000fe20000000011ULL,
0x000000180418723cULL, 0x040fe20000041814ULL, 0x000010547b0c7816ULL, 0x000fe40000000085ULL,
0x000010547c0d7816ULL, 0x000fe4000000000dULL, 0x0000105481207816ULL, 0x000fe40000000079ULL,
0x0000105482217816ULL, 0x000fe20000000021ULL, 0x000000100414723cULL, 0x000fe20000041860ULL,
0x0000105472127816ULL, 0x000fc40000000070ULL, 0x000010546d137816ULL, 0x000fe40000000013ULL,
0x000010546c6c7816ULL, 0x000fe4000000006eULL, 0x000010546b6d7816ULL, 0x000fe20000000000ULL,
0x0000000a0408723cULL, 0x040ff00000041854ULL, 0x0000000c040c723cULL, 0x040ff00000041858ULL,
0x000000200420723cULL, 0x040ff0000004185cULL, 0x000000120410723cULL, 0x040ff00000041864ULL,
0x0000006c0404723cULL, 0x000fe20000041850ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff507f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844851ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x00000000004f7305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x0000004f0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff4f7984ULL, 0x000e640000000800ULL, 0x800000004fff7812ULL, 0x002fc40007844851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008024007811ULL, 0x000fe200078e40ffULL,
0x00000100ff597424ULL, 0x000fe200078e00ffULL, 0x00000004ff587819ULL, 0x000fe40000011626ULL,
0x0000000003507217ULL, 0x000fe20007800000ULL, 0x00006200284f7a24ULL, 0x000fc800078e0200ULL,
0x0000000150507824ULL, 0x000fe400078e0a00ULL, 0x000000012e517824ULL, 0x100fe400078e024fULL,
0x0000000133527824ULL, 0x100fe200078e024fULL, 0x0000002050007807ULL, 0x000fe20000000000ULL,
0x0000000134547824ULL, 0x000fe400078e024fULL, 0x00005e0051507625ULL, 0x000fe200078e0059ULL,
0x0000000027007217ULL, 0x000fc60007800000ULL, 0x00005e0052527625ULL, 0x000fe200078e0059ULL,
0x0000002f50567210ULL, 0x000fc60007f5e0ffULL, 0x00005e0054547625ULL, 0x000fe200078e0059ULL,
0x0000002f52527210ULL, 0x000fc60007f9e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000002f54547210ULL, 0x000fe20007fbe0ffULL, 0x0000000135507824ULL, 0x000fe400078e024fULL,
0x000000ffff577224ULL, 0x000fe200010e0651ULL, 0x000000005800720cULL, 0x080fe20003f46070ULL,
0x00005e0050507625ULL, 0x000fe200078e0059ULL, 0x000000003000720cULL, 0x000fc60003f66070ULL,
0x000000ffff537224ULL, 0x000fe200020e0653ULL, 0x000000003100720cULL, 0x080fe20003f86070ULL,
0x000000ffff557224ULL, 0x000fe200028e0655ULL, 0x000000003200720cULL, 0x000fe40003fa6070ULL,
0x0000002f50507210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000564e7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff517224ULL, 0x000fe400030e0651ULL,
0x00000000524d7faeULL, 0x0003e8000d901c46ULL, 0x00000000544c7faeULL, 0x0003e8000e101c46ULL,
0x00000000504b7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff507f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4f7224ULL, 0x000fe200078e0051ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000507305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000500000735dULL, 0x004fe40003800000ULL,
0x0106b400ff507984ULL, 0x000e640000000800ULL, 0x8000000050ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002dff00723eULL, 0x000fe400000010ffULL,
0x00000002ff5b7819ULL, 0x000fe40000011626ULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x000125727f007947ULL, 0x000fea000b800000ULL, 0x00001f5b5a607589ULL, 0x0002a400000e0000ULL,
0x000125b27f007947ULL, 0x000fea000b800000ULL, 0x00001f365a617589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x002fe200078e0037ULL,
0x000079a0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x000131f000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x002fe200078e0038ULL,
0x00007a00005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0001319000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004a5c783bULL, 0x000f680000004200ULL,
0x000000004958783bULL, 0x00ae680000004200ULL, 0x000000004854783bULL, 0x000ee80000004200ULL,
0x000000004750783bULL, 0x000f220000004200ULL, 0x00000018ff647819ULL, 0x020fc4000001165dULL,
0x00000010ff627819ULL, 0x100fe4000001165cULL, 0x000000ff5b737812ULL, 0x002fe400078ec0ffULL,
0x000000ff5c637812ULL, 0x000fe400078ec0ffULL, 0x000000ff54757812ULL, 0x008fe400078ec0ffULL,
0x00000018ff007819ULL, 0x004fe4000001165cULL, 0x0000ffff5c997812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8e7819ULL, 0x100fe4000001165fULL, 0x000000ff5f6b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001165fULL, 0x0000ffff5f9c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x100fe40000011654ULL, 0x00000018ff747819ULL, 0x000fc40000011654ULL,
0x0000ffff54817812ULL, 0x000fe400078ec0ffULL, 0x00000010ff847819ULL, 0x100fe40000011655ULL,
0x000000ff55767812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8a7819ULL, 0x000fe40000011655ULL,
0x0000ffff55827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8f7819ULL, 0x000fc40000011658ULL,
0x000000ff586d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011658ULL,
0x0000ffff589d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe40000011656ULL,
0x000000ff56907812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fc40000011656ULL,
0x0000ffff56557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe40000011657ULL,
0x000000ff57937812ULL, 0x040fe400078ec0ffULL, 0x00000018ff927819ULL, 0x000fe40000011657ULL,
0x0000ffff57547812ULL, 0x000fe400078ec0ffULL, 0x00000064ff5f723eULL, 0x000fc400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000018ff667819ULL, 0x000fe2000001165eULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x110fe20000011650ULL,
0x20000073ff787230ULL, 0x000fe20000004100ULL, 0x000000ff50947812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011650ULL, 0x0000ffff50577812ULL, 0x000fc400078ec0ffULL,
0x00000010ff567819ULL, 0x100fe40000011651ULL, 0x000000ff51967812ULL, 0x040fe400078ec0ffULL,
0x00000018ff957819ULL, 0x000fe40000011651ULL, 0x0000ffff51687812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe4000001165bULL, 0x000000ff52517812ULL, 0x000fc400078ec0ffULL,
0x00000075ff50723eULL, 0x000fe400020006ffULL, 0x000000ff5d657812ULL, 0x000fe400078ec0ffULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000074ff73723eULL, 0x000fe200020006ffULL,
0x20000050ff747230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000066ff7c7230ULL, 0x000fe20000004100ULL, 0x00000065ff80723eULL, 0x000fe200020006ffULL,
0x20000072ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x100fe20000011652ULL,
0x20000051ff667230ULL, 0x000fe20000004100ULL, 0x00000018ff977819ULL, 0x000fe20000011652ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000ffff52657812ULL, 0x000fe200078ec0ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000062ff50723eULL, 0x000fc400020006ffULL,
0x00000018ff527819ULL, 0x000fe40000011653ULL, 0x0000ffff5d9a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011659ULL, 0x0000008aff72723eULL, 0x000fe200020006ffULL,
0x20000050ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff517819ULL, 0x000fe40000011699ULL,
0x000000ff5a717812ULL, 0x000fe200078ec0ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fc400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe4000001165eULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000052ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff507819ULL, 0x000fe4000001169aULL, 0x0000ffff5e9b7812ULL, 0x000fe200078ec0ffULL,
0x2000006eff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fc4000001165dULL, 0x000000ff5e677812ULL, 0x000fe400078ec0ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000018ff707819ULL, 0x000fe4000001165aULL,
0x00000063ff5d723eULL, 0x000fe400020006ffULL, 0x00000000ff5e723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe20000011653ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff53987812ULL, 0x040fe200078ec0ffULL, 0x20000071ff797230ULL, 0x000fe20000004100ULL,
0x0000ffff53007812ULL, 0x000fc400078ec0ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000008eff53723eULL, 0x000fe400020006ffULL,
0x00000008ff527819ULL, 0x000fe4000001169bULL, 0x00000010ff917819ULL, 0x000fe40000011659ULL,
0x0000008bff6e723eULL, 0x000fe200020006ffULL, 0x20000051ff8b7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fc400020006ffULL, 0x0000008dff51723eULL, 0x000fe200020006ffULL,
0x20000050ff8d7230ULL, 0x000fe20000004100ULL, 0x00000090ff71723eULL, 0x000fe200020006ffULL,
0x20000053ff907230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x20000070ff777230ULL, 0x000fe20000004100ULL, 0x00000008ff507819ULL, 0x000fe2000001169cULL,
0x20000051ff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff91917812ULL, 0x000fe200078ec0ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000000ff8f537812ULL, 0x000fe200078ec0ffULL,
0x20000052ff8f7230ULL, 0x000fe20000004100ULL, 0x00000093ff70723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff596f7812ULL, 0x000fc400078ec0ffULL,
0x00000050ff51723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000091ff93723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000051ff917230ULL, 0x000fe20000004100ULL, 0x0000a80046507811ULL, 0x000fe400078e20ffULL,
0x00000008ff527819ULL, 0x000fe4000001169dULL, 0x00000010ff877819ULL, 0x000fc4000001165aULL,
0x0000ffff5a857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff887819ULL, 0x000fe4000001165bULL,
0x0000ffff5b867812ULL, 0x000fe400078ec0ffULL, 0x0000006dff5a723eULL, 0x000fe400020006ffULL,
0x0000006fff5b723eULL, 0x000fe400020006ffULL, 0x00000094ff6d723eULL, 0x000fe200020006ffULL,
0x20000093ff947230ULL, 0x000fe20000004100ULL, 0x00000092ff6f723eULL, 0x000fe200020006ffULL,
0x20000053ff927230ULL, 0x000fe20000004100ULL, 0x00000052ff93723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x000000005050783bULL, 0x000e620000000200ULL,
0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff83837812ULL, 0x000fe200078ec0ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x2000006aff7d7230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fc400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000095ff6a723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff84957812ULL, 0x000fe200078ec0ffULL,
0x20000086ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168aULL,
0x20000083ff867230ULL, 0x000fe20000004100ULL, 0x0000005cff83723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165dULL,
0x00000010ff5d7819ULL, 0x000fe20000011680ULL, 0x20000083ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000008ff557819ULL, 0x000fe40000011655ULL,
0x0000ffff59897812ULL, 0x000fe400078ec0ffULL, 0x00000067ff59723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fc400020006ffULL, 0x000010548a5c7816ULL, 0x000fe2000000005cULL,
0x0000006050509231ULL, 0x082fe200003400ffULL, 0x000010548c5d7816ULL, 0x000fe2000000005dULL,
0x0000006052529231ULL, 0x000fe200003400ffULL, 0x00000055ff83723eULL, 0x000fe200020006ffULL,
0x0000006151519231ULL, 0x080fe200003400ffULL, 0x00000008ff8a7819ULL, 0x000fe20000011654ULL,
0x0000006153539231ULL, 0x000fe200003400ffULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x2000006bff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe2000001168bULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fc4000001168dULL,
0x000010545e547816ULL, 0x000fe40000000054ULL, 0x000010545f557816ULL, 0x000fe40000000055ULL,
0x0000005c505c723cULL, 0x000fe20000041808ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x000000ff58087812ULL, 0x000fc400078ec0ffULL, 0x00000010ff587819ULL, 0x000fe40000011659ULL,
0x00000010ff597819ULL, 0x000fe4000001167eULL, 0x000010548e587816ULL, 0x000fe40000000058ULL,
0x0000105490597816ULL, 0x000fe40000000059ULL, 0x0000a800457e7811ULL, 0x000fe400078e20ffULL,
0x00000008ff8b723eULL, 0x000fc400020006ffULL, 0x000000545008723cULL, 0x040fe2000004180cULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff547819ULL, 0x000fe2000001168fULL, 0x00000058500c723cULL, 0x000fe20000041820ULL,
0x00000010ff557819ULL, 0x000fe20000011691ULL, 0x000000007e20783bULL, 0x000e620000000200ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000006cff7a7230ULL, 0x000fe20000004100ULL,
0x000010547c547816ULL, 0x000fc40000000054ULL, 0x000010547d557816ULL, 0x000fe20000000055ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x000000ff56587812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe40000011657ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000056ff7c723eULL, 0x000fc400020006ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x000000ff88887812ULL, 0x000fe200078ec0ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fe4000001165bULL,
0x00000058ff7d723eULL, 0x000fe400020006ffULL, 0x0000105492567816ULL, 0x000fe4000000005aULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x000000545058723cULL, 0x000fe2000004181cULL,
0x00000010ff947819ULL, 0x000fe20000011694ULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fc4000001167aULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff1c7819ULL, 0x000fe4000001167bULL, 0x00000010ff7b7819ULL, 0x000fe40000011689ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x0000006020209231ULL, 0x082fe200003400ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x0000006022229231ULL, 0x000fe200003400ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x0000105494577816ULL, 0x000fe20000000057ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000010547a7a7816ULL, 0x000fe20000000093ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x000010541c7b7816ULL, 0x000fe2000000007bULL, 0x0000006121219231ULL, 0x080fe200003400ffULL,
0x00000008ff817819ULL, 0x000fe20000011681ULL, 0x000000565054723cULL, 0x000fe20000041818ULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x0000006123239231ULL, 0x000fe200003400ffULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff1d7819ULL, 0x000fe40000011678ULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x0000007a5018723cULL, 0x000fe20000041814ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff757819ULL, 0x000fc40000011675ULL,
0x00000010ff157819ULL, 0x000fe40000011684ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00001054871c7816ULL, 0x000fe20000000079ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00001054881d7816ULL, 0x000fe2000000001dULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000105477147816ULL, 0x000fc40000000085ULL,
0x0000105475157816ULL, 0x000fe40000000015ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x0000001c501c723cULL, 0x040fe20000041810ULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff687819ULL, 0x000fe20000011668ULL, 0x20000064ff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff69697812ULL, 0x000fe400078ec0ffULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x000000145050723cULL, 0x000fe20000041804ULL, 0x00000008ff657819ULL, 0x000fc40000011665ULL,
0x00000008ff007819ULL, 0x000fe40000011600ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff117819ULL, 0x000fe40000011682ULL, 0x00000096ff6c723eULL, 0x000fc400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000098ff67723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000097ff64723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000105473107816ULL, 0x000fe20000000081ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000105472117816ULL, 0x000fe20000000011ULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x00000010ff137819ULL, 0x000fe40000011670ULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x000000102008723cULL, 0x000fe20000041808ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff157819ULL, 0x000fe4000001166cULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff837819ULL, 0x000fc40000011683ULL, 0x00000010ff117819ULL, 0x000fe4000001168aULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x000010547f127816ULL, 0x000fe40000000071ULL, 0x0000105480137816ULL, 0x000fe40000000013ULL,
0x000010547d157816ULL, 0x000fc40000000015ULL, 0x0000105486747816ULL, 0x000fe40000000074ULL,
0x0000105495757816ULL, 0x000fe20000000076ULL, 0x00000012200c723cULL, 0x040fe2000004180cULL,
0x000010546e107816ULL, 0x000fe40000000083ULL, 0x000010546f117816ULL, 0x000fe40000000011ULL,
0x000010548b147816ULL, 0x000fe4000000006dULL, 0x000010546b7c7816ULL, 0x000fe2000000007cULL,
0x000000742004723cULL, 0x000fe2000004185cULL, 0x000010546a7d7816ULL, 0x000fc40000000068ULL,
0x0000105469667816ULL, 0x000fe40000000066ULL, 0x0000105463677816ULL, 0x000fe40000000067ULL,
0x0000105464647816ULL, 0x000fe20000000065ULL, 0x000000102010723cULL, 0x000fe20000041858ULL,
0x0000105462657816ULL, 0x000fce0000000000ULL, 0x000000142014723cULL, 0x040ff00000041854ULL,
0x0000007c2018723cULL, 0x040ff00000041818ULL, 0x00000066201c723cULL, 0x040ff0000004181cULL,
0x000000642020723cULL, 0x000fe20000041850ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff507f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008024007811ULL, 0x000fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff507224ULL, 0x002fc400078e0051ULL,
0x000000000300720cULL, 0x000fda0003f24070ULL, 0x00007f4000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824850ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824850ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000517305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000510000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff517984ULL, 0x000e640000000800ULL,
0x8000000051ff7812ULL, 0x002fc40007824850ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000a024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff587424ULL, 0x000fe200078e00ffULL,
0x00000004ff557819ULL, 0x000fe40000011626ULL, 0x0000000003507217ULL, 0x000fe20007800000ULL,
0x0000620028547a24ULL, 0x000fc800078e0200ULL, 0x0000000150507824ULL, 0x000fe400078e0a00ULL,
0x000000012e517824ULL, 0x100fe400078e0254ULL, 0x0000000133527824ULL, 0x000fe200078e0254ULL,
0x0000002050007807ULL, 0x000fe20000000000ULL, 0x00005e0051507625ULL, 0x000fc600078e0058ULL,
0x0000000027007217ULL, 0x000fe20007800000ULL, 0x00005e0052527625ULL, 0x000fe200078e0058ULL,
0x0000002f50567210ULL, 0x000fc60007f3e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000002f52527210ULL, 0x000fe20007f7e0ffULL, 0x0000000134507824ULL, 0x100fe400078e0254ULL,
0x0000000135547824ULL, 0x000fe200078e0254ULL, 0x000000005500720cULL, 0x080fe20003f46070ULL,
0x000000ffff577224ULL, 0x000fe200008e0651ULL, 0x000000003000720cULL, 0x000fe20003f26070ULL,
0x00005e0050507625ULL, 0x000fe200078e0058ULL, 0x000000003200720cULL, 0x000fc60003f86070ULL,
0x00005e0054547625ULL, 0x000fe200078e0058ULL, 0x0000002f50507210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff537224ULL, 0x000fe200018e0653ULL, 0x000000003100720cULL, 0x000fe20003f66070ULL,
0x000000ffff517224ULL, 0x000fe200028e0651ULL, 0x0000002f54547210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000056397faeULL, 0x0003e8000d101c46ULL,
0x000000ffff557224ULL, 0x000fe200030e0655ULL, 0x00000000523a7faeULL, 0x0003ea000c901c46ULL,
0x00000000503b7faeULL, 0x0003e8000d901c46ULL, 0x00000000543c7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff687f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106480027507f8cULL, 0x002fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc6000784484fULL,
0x01064c0027527984ULL, 0x000e640000000800ULL, 0x8000000052ff7812ULL, 0x002fe40007824851ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000527305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000520000735dULL, 0x008fe40003800000ULL, 0x01064c0027527984ULL, 0x000e640000000800ULL,
0x8000000052ff7812ULL, 0x002fc40007824851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010100003d527984ULL, 0x000e680000000800ULL, 0x010300003d537984ULL, 0x0007220000000800ULL,
0x000000295200720bULL, 0x002fe20003f3d000ULL, 0x000108927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00547812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff507424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000020200780cULL, 0x000fe40003f65270ULL,
0x000000295200720bULL, 0x000fe20003f34000ULL, 0x000108527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x0000005229507209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x8000005029517221ULL, 0x000fe20000010000ULL,
0x010500503d00b388ULL, 0x0003e20000000800ULL, 0x0000000054ff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b51517820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fca0000011626ULL,
0x0000005100517308ULL, 0x000ee40000000800ULL, 0x000000512a2a7220ULL, 0x008fe20000410000ULL,
0x000107e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0051007589ULL, 0x0022e400000e0000ULL,
0x0000000004047220ULL, 0x08cfe20000410000ULL, 0x0000000005057220ULL, 0x080fe20000410000ULL,
0x0000000008087220ULL, 0x080fe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x000fe20000410000ULL,
0x000107327f007947ULL, 0x000fea000b800000ULL, 0x00001f3651007589ULL, 0x0004e400000e0000ULL,
0x0000005229297209ULL, 0x000fe20007810000ULL, 0x0000000006067220ULL, 0x08cfe20000410000ULL,
0x00000001ff507807ULL, 0x000fe20000800000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x8000002952521221ULL, 0x000fe20000010000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b52521820ULL, 0x000fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x00000052002d1308ULL, 0x000ea20000000800ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x000fe20000410000ULL, 0x000000532d531220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002a532a7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc4000782484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000517305ULL, 0x0022e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000510000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff517984ULL, 0x000e640000000800ULL, 0x8000000051ff7812ULL, 0x002fe4000782484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002dff00723eULL, 0x000fe400000010ffULL,
0x00000002ff4f7819ULL, 0x000fc40000011626ULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x000104e27f007947ULL, 0x000fea000b800000ULL, 0x00001f4f5a4f7589ULL, 0x00072400000e0000ULL,
0x000105327f007947ULL, 0x000fea000b800000ULL, 0x00001f365a6a7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0037ULL,
0x00009c60005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00010f3000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0038ULL,
0x00009cc0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00010ed000007944ULL, 0x01efea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004058783bULL, 0x00ae620000004200ULL,
0x0000991050007816ULL, 0x004fc600000000ffULL, 0x000000003f5c783bULL, 0x000ea20000004200ULL,
0x000000ff0000720cULL, 0x000fc60003f25270ULL, 0x000000004154783bULL, 0x000ee80000004200ULL,
0x000000004250783bULL, 0x000f620000004200ULL, 0x000000ff58667812ULL, 0x002fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fe4000001165aULL, 0x000000ff5d617812ULL, 0x004fe400078ec0ffULL,
0x000000ff5c607812ULL, 0x000fc400078ec0ffULL, 0x000000ff567a7812ULL, 0x008fe400078ec0ffULL,
0x000000ff577b7812ULL, 0x000fe400078ec0ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000010ff857819ULL, 0x100fe40000011655ULL, 0x000000ff55787812ULL, 0x000fe200078ec0ffULL,
0x20000066ff7f7230ULL, 0x000fe20000004100ULL, 0x00000018ff777819ULL, 0x000fc40000011655ULL,
0x0000ffff55837812ULL, 0x000fe400078ec0ffULL, 0x00000061ff82723eULL, 0x000fe400020006ffULL,
0x00000010ff6b7819ULL, 0x000fe4000001165cULL, 0x000000ff5a707812ULL, 0x040fe200078ec0ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000018ff6f7819ULL, 0x000fe4000001165aULL,
0x0000ffff5a867812ULL, 0x000fc400078ec0ffULL, 0x00000060ff55723eULL, 0x000fe400020006ffULL,
0x00000010ff617819ULL, 0x120fe40000011651ULL, 0x000000ff51947812ULL, 0x040fe200078ec0ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000018ff937819ULL, 0x000fe40000011651ULL,
0x0000ffff51717812ULL, 0x000fe400078ec0ffULL, 0x00000018ff797819ULL, 0x000fc40000011656ULL,
0x00000010ff5a7819ULL, 0x100fe40000011650ULL, 0x000000ff50917812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8f7819ULL, 0x000fe40000011650ULL, 0x0000ffff50607812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x000fe40000011652ULL, 0x000000ff52957812ULL, 0x000fc400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe40000011652ULL, 0x0000ffff526e7812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000018ff527819ULL, 0x000fe40000011653ULL,
0x0000007bff50723eULL, 0x000fe400020006ffULL, 0x000000ff596c7812ULL, 0x000fc400078ec0ffULL,
0x00000078ff66723eULL, 0x000fe400020006ffULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x00000079ff78723eULL, 0x000fe200020006ffULL, 0x2000007aff797230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x20000050ff7a7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe2000001165dULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x2000006cff807230ULL, 0x000fe20000004100ULL,
0x0000006bff50723eULL, 0x000fe200020006ffULL, 0x20000052ff6b7230ULL, 0x000fe20000004100ULL,
0x0000ffff5c977812ULL, 0x000fe200078ec0ffULL, 0x20000051ff6c7230ULL, 0x000fe20000004100ULL,
0x0000ffff5d987812ULL, 0x000fc400078ec0ffULL, 0x000000ff8b527812ULL, 0x000fe200078ec0ffULL,
0x20000050ff8b7230ULL, 0x000fe20000004100ULL, 0x00000018ff007819ULL, 0x000fe4000001165cULL,
0x00000008ff517819ULL, 0x000fe40000011697ULL, 0x00000008ff507819ULL, 0x000fe40000011698ULL,
0x00000010ff8c7819ULL, 0x000fe4000001165eULL, 0x00000010ff8d7819ULL, 0x000fc4000001165fULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000010ff907819ULL, 0x100fe40000011658ULL,
0x00000018ff657819ULL, 0x000fe20000011658ULL, 0x20000077ff7c7230ULL, 0x000fe20000004100ULL,
0x0000ffff589b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe40000011654ULL,
0x00000018ff8e7819ULL, 0x000fc40000011657ULL, 0x00000000ff58723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe40000011653ULL,
0x000000ff53967812ULL, 0x040fe400078ec0ffULL, 0x0000ffff53007812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5e997812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c537812ULL, 0x000fe200078ec0ffULL,
0x20000051ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x0000008eff77723eULL, 0x000fe200020006ffULL, 0x20000050ff8e7230ULL, 0x000fe20000004100ULL,
0x00000018ff737819ULL, 0x000fe2000001165bULL, 0x20000065ff7d7230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000075ff7b7230ULL, 0x000fe20000004100ULL,
0x0000008dff51723eULL, 0x000fe200020006ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000008ff507819ULL, 0x000fc40000011699ULL, 0x00000010ff927819ULL, 0x000fe40000011659ULL,
0x00000018ff647819ULL, 0x000fe4000001165fULL, 0x0000ffff5f9a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe40000011659ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x000000ff54767812ULL, 0x000fc400078ec0ffULL, 0x00000073ff65723eULL, 0x000fe200020006ffULL,
0x20000052ff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff5e637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe2000001165eULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000091ff75723eULL, 0x000fe200020006ffULL, 0x20000051ff917230ULL, 0x000fe20000004100ULL,
0x0000008fff73723eULL, 0x000fe200020006ffULL, 0x20000053ff8f7230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x000000ff90907812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff5f5e7812ULL, 0x000fc400078ec0ffULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x00000064ff5f723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff517819ULL, 0x000fe2000001169aULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff537819ULL, 0x000fe2000001169bULL, 0x20000067ff7e7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fc400020006ffULL, 0x00000076ff64723eULL, 0x000fe400020006ffULL,
0x00000094ff76723eULL, 0x000fe200020006ffULL, 0x20000070ff677230ULL, 0x000fe20000004100ULL,
0x00000090ff52723eULL, 0x000fe200020006ffULL, 0x20000050ff907230ULL, 0x000fe20000004100ULL,
0x000000ff5b747812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000092ff94723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fc400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000b00043507811ULL, 0x000fe200078e20ffULL, 0x20000051ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe4000001165bULL, 0x0000ffff5b877812ULL, 0x000fe400078ec0ffULL,
0x00000063ff5b723eULL, 0x000fe400020006ffULL, 0x00000074ff63723eULL, 0x000fc400020006ffULL,
0x00000095ff70723eULL, 0x000fe200020006ffULL, 0x20000094ff957230ULL, 0x000fe20000004100ULL,
0x00000093ff74723eULL, 0x000fe200020006ffULL, 0x20000052ff937230ULL, 0x000fe20000004100ULL,
0x00000018ff5c7819ULL, 0x000fe2000001165dULL, 0x20000053ff947230ULL, 0x000fe20000004100ULL,
0x0000ffff54817812ULL, 0x000fe200078ec0ffULL, 0x000000005050783bULL, 0x000e620000000200ULL,
0x00000010ff5d7819ULL, 0x000fe20000011656ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff85857812ULL, 0x000fe200078ec0ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff817819ULL, 0x000fe20000011681ULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fc40000011654ULL, 0x00000010ff547819ULL, 0x000fe40000011657ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000085ff987230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fe200078ec0ffULL, 0x20000081ff857230ULL, 0x000fe20000004100ULL,
0x0000ffff598a7812ULL, 0x000fe200078ec0ffULL, 0x2000005dff817230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fc40000011683ULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x0000005cff59723eULL, 0x000fe400020006ffULL, 0x0000ffff56567812ULL, 0x000fe400078ec0ffULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000054ff5d723eULL, 0x000fe200020006ffULL,
0x20000084ff977230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe20000011655ULL,
0x20000083ff847230ULL, 0x000fe20000004100ULL, 0x0000ffff57577812ULL, 0x000fe200078ec0ffULL,
0x0000004f50509231ULL, 0x092fe200003400ffULL, 0x00000008ff567819ULL, 0x000fe20000011656ULL,
0x0000004f52529231ULL, 0x000fe200003400ffULL, 0x00000010ff557819ULL, 0x000fe20000011682ULL,
0x2000005dff827230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe2000001168bULL,
0x0000006a51519231ULL, 0x080fe200003400ffULL, 0x00000010ff8d7819ULL, 0x000fe2000001168dULL,
0x0000006a53539231ULL, 0x000fe200003400ffULL, 0x00000056ff83723eULL, 0x000fc400020006ffULL,
0x000010548b547816ULL, 0x000fe40000000054ULL, 0x000010548d557816ULL, 0x000fe20000000055ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff5d7819ULL, 0x000fe40000011657ULL,
0x00000010ff567819ULL, 0x000fe40000011658ULL, 0x00000010ff577819ULL, 0x000fe40000011659ULL,
0x00000010ff587819ULL, 0x000fc4000001168cULL, 0x00000010ff597819ULL, 0x000fe4000001168eULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fe40000011686ULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x0000005eff5c723eULL, 0x000fc400020006ffULL, 0x0000105456587816ULL, 0x000fe40000000058ULL,
0x0000105457597816ULL, 0x000fe20000000059ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x000000545054723cULL, 0x000fe20000041804ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000062ff5e723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x0000005aff05723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000b00044047811ULL, 0x000fe400078e20ffULL,
0x0000006fff62723eULL, 0x000fe200020006ffULL, 0x20000005ff8b7230ULL, 0x000fe20000004100ULL,
0x00000096ff6f723eULL, 0x000fe200020006ffULL, 0x20000089ff967230ULL, 0x000fe20000004100ULL,
0x000000000404783bULL, 0x000e620000000200ULL, 0x20000086ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x20000087ff867230ULL, 0x000fe20000004100ULL,
0x0000005dff87723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165cULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x000fe2000001168fULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x000010545c5c7816ULL, 0x000fe4000000005bULL,
0x000000585058723cULL, 0x000fe20000041808ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff087819ULL, 0x000fe40000011690ULL, 0x00000010ff097819ULL, 0x000fc40000011692ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x000010545e087816ULL, 0x000fe40000000008ULL,
0x000010545f097816ULL, 0x000fe40000000009ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff0b7819ULL, 0x000fe20000011680ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x000000085010723cULL, 0x040fe20000041810ULL, 0x00000010ff957819ULL, 0x000fe20000011695ULL,
0x0000004f04049231ULL, 0x082fe200003400ffULL, 0x00001054915d7816ULL, 0x000fe2000000005dULL,
0x0000004f06069231ULL, 0x000fe200003400ffULL, 0x00000008ff607819ULL, 0x000fe20000011660ULL,
0x0000006a05059231ULL, 0x080fe200003400ffULL, 0x00001054930a7816ULL, 0x000fe2000000007fULL,
0x0000006a07079231ULL, 0x000fe200003400ffULL, 0x00001054950b7816ULL, 0x000fe2000000000bULL,
0x0000005c505c723cULL, 0x000fe2000004180cULL, 0x000000ff61617812ULL, 0x000fc400078ec0ffULL,
0x00000010ff097819ULL, 0x000fe40000011662ULL, 0x00000010ff087819ULL, 0x000fe40000011689ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x0000000a5014723cULL, 0x000fe20000041814ULL,
0x00000061ff0c723eULL, 0x000fe400020006ffULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x20000060ff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x2000000cff807230ULL, 0x000fe20000004100ULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x00000010ff617819ULL, 0x000fe4000001168aULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x0000105409087816ULL, 0x000fc40000000008ULL,
0x00000010ff0a7819ULL, 0x000fe40000011665ULL, 0x00000010ff097819ULL, 0x000fe40000011686ULL,
0x000010547d607816ULL, 0x000fe40000000094ULL, 0x000010547e617816ULL, 0x000fe40000000061ULL,
0x0000105488887816ULL, 0x000fe40000000067ULL, 0x0000105496897816ULL, 0x000fc40000000063ULL,
0x000010540a097816ULL, 0x000fe20000000009ULL, 0x000000605060723cULL, 0x040fe20000041818ULL,
0x00000010ff0b7819ULL, 0x000fe40000011664ULL, 0x00000010ff0c7819ULL, 0x000fe40000011666ULL,
0x00000008ff717819ULL, 0x000fe40000011671ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x000000885064723cULL, 0x000fe2000004181cULL, 0x000000ff6d6d7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x000000085050723cULL, 0x000fe20000041820ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff1d7819ULL, 0x000fe40000011687ULL,
0x00000008ff007819ULL, 0x000fc40000011600ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00001054781c7816ULL, 0x000fe20000000083ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00001054771d7816ULL, 0x000fe2000000001dULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fc400020006ffULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00000010ff197819ULL, 0x000fe20000011676ULL,
0x0000001c041c723cULL, 0x000fe20000041810ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff987819ULL, 0x000fc40000011698ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff117819ULL, 0x000fe40000011671ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff0d7819ULL, 0x000fe40000011684ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff217819ULL, 0x000fe4000001167aULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff137819ULL, 0x000fe4000001166fULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x00001054970a7816ULL, 0x000fe4000000000bULL, 0x000010548b187816ULL, 0x000fe40000000075ULL,
0x0000105480197816ULL, 0x000fe40000000019ULL, 0x00001054980b7816ULL, 0x000fc4000000000cULL,
0x0000105473107816ULL, 0x000fe4000000007fULL, 0x0000105474117816ULL, 0x000fe20000000011ULL,
0x000000180418723cULL, 0x040fe20000041814ULL, 0x000010547b0c7816ULL, 0x000fe40000000085ULL,
0x000010547c0d7816ULL, 0x000fe4000000000dULL, 0x0000105481207816ULL, 0x000fe40000000079ULL,
0x0000105482217816ULL, 0x000fe20000000021ULL, 0x000000100414723cULL, 0x000fe20000041860ULL,
0x0000105472127816ULL, 0x000fc40000000070ULL, 0x000010546d137816ULL, 0x000fe40000000013ULL,
0x000010546c6c7816ULL, 0x000fe4000000006eULL, 0x000010546b6d7816ULL, 0x000fe20000000000ULL,
0x0000000a0408723cULL, 0x040ff00000041854ULL, 0x0000000c040c723cULL, 0x040ff00000041858ULL,
0x000000200420723cULL, 0x040ff0000004185cULL, 0x000000120410723cULL, 0x040ff00000041864ULL,
0x0000006c0404723cULL, 0x000fe20000041850ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff507f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844851ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x00000000004f7305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x0000004f0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff4f7984ULL, 0x000e640000000800ULL, 0x800000004fff7812ULL, 0x002fc40007844851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c024007811ULL, 0x000fe200078e40ffULL,
0x00000100ff597424ULL, 0x000fe200078e00ffULL, 0x00000004ff587819ULL, 0x000fe40000011626ULL,
0x0000000003507217ULL, 0x000fe20007800000ULL, 0x00006200284f7a24ULL, 0x000fc800078e0200ULL,
0x0000000150507824ULL, 0x000fe400078e0a00ULL, 0x000000012e517824ULL, 0x100fe400078e024fULL,
0x0000000133527824ULL, 0x100fe200078e024fULL, 0x0000002050007807ULL, 0x000fe20000000000ULL,
0x0000000134547824ULL, 0x000fe400078e024fULL, 0x00005e0051507625ULL, 0x000fe200078e0059ULL,
0x0000000027007217ULL, 0x000fc60007800000ULL, 0x00005e0052527625ULL, 0x000fe200078e0059ULL,
0x0000002f50567210ULL, 0x000fc60007f5e0ffULL, 0x00005e0054547625ULL, 0x000fe200078e0059ULL,
0x0000002f52527210ULL, 0x000fc60007f9e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000002f54547210ULL, 0x000fe20007fbe0ffULL, 0x0000000135507824ULL, 0x000fe400078e024fULL,
0x000000ffff577224ULL, 0x000fe200010e0651ULL, 0x000000005800720cULL, 0x080fe20003f46070ULL,
0x00005e0050507625ULL, 0x000fe200078e0059ULL, 0x000000003000720cULL, 0x000fc60003f66070ULL,
0x000000ffff537224ULL, 0x000fe200020e0653ULL, 0x000000003100720cULL, 0x080fe20003f86070ULL,
0x000000ffff557224ULL, 0x000fe200028e0655ULL, 0x000000003200720cULL, 0x000fe40003fa6070ULL,
0x0000002f50507210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000564e7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff517224ULL, 0x000fe400030e0651ULL,
0x00000000524d7faeULL, 0x0003e8000d901c46ULL, 0x00000000544c7faeULL, 0x0003e8000e101c46ULL,
0x00000000504b7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff507f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4f7224ULL, 0x000fe200078e0051ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000507305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000500000735dULL, 0x004fe40003800000ULL,
0x0106b400ff507984ULL, 0x000e640000000800ULL, 0x8000000050ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002dff00723eULL, 0x000fe400000010ffULL,
0x00000002ff5b7819ULL, 0x000fe40000011626ULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x0000e8e27f007947ULL, 0x000fea000b800000ULL, 0x00001f5b5a607589ULL, 0x0002a400000e0000ULL,
0x0000e9227f007947ULL, 0x000fea000b800000ULL, 0x00001f365a617589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x002fe200078e0037ULL,
0x0000b940005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000f25000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x002fe200078e0038ULL,
0x0000b9a0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000f1f000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004a5c783bULL, 0x000f680000004200ULL,
0x000000004958783bULL, 0x00ae680000004200ULL, 0x000000004854783bULL, 0x000ee80000004200ULL,
0x000000004750783bULL, 0x000f220000004200ULL, 0x00000018ff647819ULL, 0x020fc4000001165dULL,
0x00000010ff627819ULL, 0x100fe4000001165cULL, 0x000000ff5b737812ULL, 0x002fe400078ec0ffULL,
0x000000ff5c637812ULL, 0x000fe400078ec0ffULL, 0x000000ff54757812ULL, 0x008fe400078ec0ffULL,
0x00000018ff007819ULL, 0x004fe4000001165cULL, 0x0000ffff5c997812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8e7819ULL, 0x100fe4000001165fULL, 0x000000ff5f6b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001165fULL, 0x0000ffff5f9c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x100fe40000011654ULL, 0x00000018ff747819ULL, 0x000fc40000011654ULL,
0x0000ffff54817812ULL, 0x000fe400078ec0ffULL, 0x00000010ff847819ULL, 0x100fe40000011655ULL,
0x000000ff55767812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8a7819ULL, 0x000fe40000011655ULL,
0x0000ffff55827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8f7819ULL, 0x000fc40000011658ULL,
0x000000ff586d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011658ULL,
0x0000ffff589d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe40000011656ULL,
0x000000ff56907812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fc40000011656ULL,
0x0000ffff56557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe40000011657ULL,
0x000000ff57937812ULL, 0x040fe400078ec0ffULL, 0x00000018ff927819ULL, 0x000fe40000011657ULL,
0x0000ffff57547812ULL, 0x000fe400078ec0ffULL, 0x00000064ff5f723eULL, 0x000fc400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000018ff667819ULL, 0x000fe2000001165eULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x110fe20000011650ULL,
0x20000073ff787230ULL, 0x000fe20000004100ULL, 0x000000ff50947812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011650ULL, 0x0000ffff50577812ULL, 0x000fc400078ec0ffULL,
0x00000010ff567819ULL, 0x100fe40000011651ULL, 0x000000ff51967812ULL, 0x040fe400078ec0ffULL,
0x00000018ff957819ULL, 0x000fe40000011651ULL, 0x0000ffff51687812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe4000001165bULL, 0x000000ff52517812ULL, 0x000fc400078ec0ffULL,
0x00000075ff50723eULL, 0x000fe400020006ffULL, 0x000000ff5d657812ULL, 0x000fe400078ec0ffULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000074ff73723eULL, 0x000fe200020006ffULL,
0x20000050ff747230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000066ff7c7230ULL, 0x000fe20000004100ULL, 0x00000065ff80723eULL, 0x000fe200020006ffULL,
0x20000072ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x100fe20000011652ULL,
0x20000051ff667230ULL, 0x000fe20000004100ULL, 0x00000018ff977819ULL, 0x000fe20000011652ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000ffff52657812ULL, 0x000fe200078ec0ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000062ff50723eULL, 0x000fc400020006ffULL,
0x00000018ff527819ULL, 0x000fe40000011653ULL, 0x0000ffff5d9a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011659ULL, 0x0000008aff72723eULL, 0x000fe200020006ffULL,
0x20000050ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff517819ULL, 0x000fe40000011699ULL,
0x000000ff5a717812ULL, 0x000fe200078ec0ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fc400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe4000001165eULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000052ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff507819ULL, 0x000fe4000001169aULL, 0x0000ffff5e9b7812ULL, 0x000fe200078ec0ffULL,
0x2000006eff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fc4000001165dULL, 0x000000ff5e677812ULL, 0x000fe400078ec0ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000018ff707819ULL, 0x000fe4000001165aULL,
0x00000063ff5d723eULL, 0x000fe400020006ffULL, 0x00000000ff5e723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe20000011653ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff53987812ULL, 0x040fe200078ec0ffULL, 0x20000071ff797230ULL, 0x000fe20000004100ULL,
0x0000ffff53007812ULL, 0x000fc400078ec0ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000008eff53723eULL, 0x000fe400020006ffULL,
0x00000008ff527819ULL, 0x000fe4000001169bULL, 0x00000010ff917819ULL, 0x000fe40000011659ULL,
0x0000008bff6e723eULL, 0x000fe200020006ffULL, 0x20000051ff8b7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fc400020006ffULL, 0x0000008dff51723eULL, 0x000fe200020006ffULL,
0x20000050ff8d7230ULL, 0x000fe20000004100ULL, 0x00000090ff71723eULL, 0x000fe200020006ffULL,
0x20000053ff907230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x20000070ff777230ULL, 0x000fe20000004100ULL, 0x00000008ff507819ULL, 0x000fe2000001169cULL,
0x20000051ff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff91917812ULL, 0x000fe200078ec0ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000000ff8f537812ULL, 0x000fe200078ec0ffULL,
0x20000052ff8f7230ULL, 0x000fe20000004100ULL, 0x00000093ff70723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff596f7812ULL, 0x000fc400078ec0ffULL,
0x00000050ff51723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000091ff93723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000051ff917230ULL, 0x000fe20000004100ULL, 0x0000b00046507811ULL, 0x000fe400078e20ffULL,
0x00000008ff527819ULL, 0x000fe4000001169dULL, 0x00000010ff877819ULL, 0x000fc4000001165aULL,
0x0000ffff5a857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff887819ULL, 0x000fe4000001165bULL,
0x0000ffff5b867812ULL, 0x000fe400078ec0ffULL, 0x0000006dff5a723eULL, 0x000fe400020006ffULL,
0x0000006fff5b723eULL, 0x000fe400020006ffULL, 0x00000094ff6d723eULL, 0x000fe200020006ffULL,
0x20000093ff947230ULL, 0x000fe20000004100ULL, 0x00000092ff6f723eULL, 0x000fe200020006ffULL,
0x20000053ff927230ULL, 0x000fe20000004100ULL, 0x00000052ff93723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x000000005050783bULL, 0x000e620000000200ULL,
0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff83837812ULL, 0x000fe200078ec0ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x2000006aff7d7230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fc400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000095ff6a723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff84957812ULL, 0x000fe200078ec0ffULL,
0x20000086ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168aULL,
0x20000083ff867230ULL, 0x000fe20000004100ULL, 0x0000005cff83723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165dULL,
0x00000010ff5d7819ULL, 0x000fe20000011680ULL, 0x20000083ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000008ff557819ULL, 0x000fe40000011655ULL,
0x0000ffff59897812ULL, 0x000fe400078ec0ffULL, 0x00000067ff59723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fc400020006ffULL, 0x000010548a5c7816ULL, 0x000fe2000000005cULL,
0x0000006050509231ULL, 0x082fe200003400ffULL, 0x000010548c5d7816ULL, 0x000fe2000000005dULL,
0x0000006052529231ULL, 0x000fe200003400ffULL, 0x00000055ff83723eULL, 0x000fe200020006ffULL,
0x0000006151519231ULL, 0x080fe200003400ffULL, 0x00000008ff8a7819ULL, 0x000fe20000011654ULL,
0x0000006153539231ULL, 0x000fe200003400ffULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x2000006bff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe2000001168bULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fc4000001168dULL,
0x000010545e547816ULL, 0x000fe40000000054ULL, 0x000010545f557816ULL, 0x000fe40000000055ULL,
0x0000005c505c723cULL, 0x000fe20000041808ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x000000ff58087812ULL, 0x000fc400078ec0ffULL, 0x00000010ff587819ULL, 0x000fe40000011659ULL,
0x00000010ff597819ULL, 0x000fe4000001167eULL, 0x000010548e587816ULL, 0x000fe40000000058ULL,
0x0000105490597816ULL, 0x000fe40000000059ULL, 0x0000b000457e7811ULL, 0x000fe400078e20ffULL,
0x00000008ff8b723eULL, 0x000fc400020006ffULL, 0x000000545008723cULL, 0x040fe2000004180cULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff547819ULL, 0x000fe2000001168fULL, 0x00000058500c723cULL, 0x000fe20000041820ULL,
0x00000010ff557819ULL, 0x000fe20000011691ULL, 0x000000007e20783bULL, 0x000e620000000200ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000006cff7a7230ULL, 0x000fe20000004100ULL,
0x000010547c547816ULL, 0x000fc40000000054ULL, 0x000010547d557816ULL, 0x000fe20000000055ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x000000ff56587812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe40000011657ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000056ff7c723eULL, 0x000fc400020006ffULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x000000ff88887812ULL, 0x000fe200078ec0ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fe4000001165bULL,
0x00000058ff7d723eULL, 0x000fe400020006ffULL, 0x0000105492567816ULL, 0x000fe4000000005aULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x000000545058723cULL, 0x000fe2000004181cULL,
0x00000010ff947819ULL, 0x000fe20000011694ULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fc4000001167aULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff1c7819ULL, 0x000fe4000001167bULL, 0x00000010ff7b7819ULL, 0x000fe40000011689ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x0000006020209231ULL, 0x082fe200003400ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x0000006022229231ULL, 0x000fe200003400ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x0000105494577816ULL, 0x000fe20000000057ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000010547a7a7816ULL, 0x000fe20000000093ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x000010541c7b7816ULL, 0x000fe2000000007bULL, 0x0000006121219231ULL, 0x080fe200003400ffULL,
0x00000008ff817819ULL, 0x000fe20000011681ULL, 0x000000565054723cULL, 0x000fe20000041818ULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x0000006123239231ULL, 0x000fe200003400ffULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff1d7819ULL, 0x000fe40000011678ULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x0000007a5018723cULL, 0x000fe20000041814ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff757819ULL, 0x000fc40000011675ULL,
0x00000010ff157819ULL, 0x000fe40000011684ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00001054871c7816ULL, 0x000fe20000000079ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00001054881d7816ULL, 0x000fe2000000001dULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000105477147816ULL, 0x000fc40000000085ULL,
0x0000105475157816ULL, 0x000fe40000000015ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x0000001c501c723cULL, 0x040fe20000041810ULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff687819ULL, 0x000fe20000011668ULL, 0x20000064ff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff69697812ULL, 0x000fe400078ec0ffULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x000000145050723cULL, 0x000fe20000041804ULL, 0x00000008ff657819ULL, 0x000fc40000011665ULL,
0x00000008ff007819ULL, 0x000fe40000011600ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff117819ULL, 0x000fe40000011682ULL, 0x00000096ff6c723eULL, 0x000fc400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000098ff67723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000097ff64723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000105473107816ULL, 0x000fe20000000081ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000105472117816ULL, 0x000fe20000000011ULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x00000010ff137819ULL, 0x000fe40000011670ULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x000000102008723cULL, 0x000fe20000041808ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff157819ULL, 0x000fe4000001166cULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff837819ULL, 0x000fc40000011683ULL, 0x00000010ff117819ULL, 0x000fe4000001168aULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x000010547f127816ULL, 0x000fe40000000071ULL, 0x0000105480137816ULL, 0x000fe40000000013ULL,
0x000010547d157816ULL, 0x000fc40000000015ULL, 0x0000105486747816ULL, 0x000fe40000000074ULL,
0x0000105495757816ULL, 0x000fe20000000076ULL, 0x00000012200c723cULL, 0x040fe2000004180cULL,
0x000010546e107816ULL, 0x000fe40000000083ULL, 0x000010546f117816ULL, 0x000fe40000000011ULL,
0x000010548b147816ULL, 0x000fe4000000006dULL, 0x000010546b7c7816ULL, 0x000fe2000000007cULL,
0x000000742004723cULL, 0x000fe2000004185cULL, 0x000010546a7d7816ULL, 0x000fc40000000068ULL,
0x0000105469667816ULL, 0x000fe40000000066ULL, 0x0000105463677816ULL, 0x000fe40000000067ULL,
0x0000105464647816ULL, 0x000fe20000000065ULL, 0x000000102010723cULL, 0x000fe20000041858ULL,
0x0000105462657816ULL, 0x000fce0000000000ULL, 0x000000142014723cULL, 0x040ff00000041854ULL,
0x0000007c2018723cULL, 0x040ff00000041818ULL, 0x00000066201c723cULL, 0x040ff0000004181cULL,
0x000000642020723cULL, 0x000fe20000041850ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff507f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c024007811ULL, 0x000fe200078e40ffULL,
0x01069800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff507224ULL, 0x002fc400078e0051ULL,
0x000000000300720cULL, 0x000fda0003f24070ULL, 0x00003fa000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824850ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824850ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000517305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000510000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff517984ULL, 0x000e640000000800ULL,
0x8000000051ff7812ULL, 0x002fc40007824850ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000e024007811ULL, 0x000fe200078e40ffULL, 0x00000100ff597424ULL, 0x000fe200078e00ffULL,
0x00000004ff587819ULL, 0x000fe40000011626ULL, 0x0000000003507217ULL, 0x000fe20007800000ULL,
0x0000620028527a24ULL, 0x000fc800078e0200ULL, 0x0000000150507824ULL, 0x000fe400078e0a00ULL,
0x000000012e517824ULL, 0x100fe400078e0252ULL, 0x0000000133537824ULL, 0x000fe200078e0252ULL,
0x0000002050007807ULL, 0x000fe20000000000ULL, 0x00005e0051507625ULL, 0x000fc600078e0059ULL,
0x0000000027007217ULL, 0x000fe20007800000ULL, 0x0000000134547824ULL, 0x100fe200078e0252ULL,
0x0000002f50567210ULL, 0x000fe20007f1e0ffULL, 0x0000000135557824ULL, 0x000fe400078e0252ULL,
0x0000000100007824ULL, 0x000fe400078e0a27ULL, 0x000000ffff577224ULL, 0x000fe400000e0651ULL,
0x00005e0053507625ULL, 0x000fe200078e0059ULL, 0x000000005800720cULL, 0x000fc40003f06070ULL,
0x000000003000720cULL, 0x080fe20003f26070ULL, 0x00005e0054527625ULL, 0x080fe200078e0059ULL,
0x000000003100720cULL, 0x080fe40003f46070ULL, 0x000000003200720cULL, 0x000fe20003f66070ULL,
0x00005e0055547625ULL, 0x000fe200078e0059ULL, 0x0000002f50507210ULL, 0x080fe40007f9e0ffULL,
0x0000002f52527210ULL, 0x080fe40007fbe0ffULL, 0x0000002f54547210ULL, 0x000fe20007fde0ffULL,
0x000000ffff517224ULL, 0x000fe200020e0651ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000056397faeULL, 0x0003e2000c101c46ULL, 0x000000ffff537224ULL, 0x000fc400028e0653ULL,
0x000000ffff557224ULL, 0x000fe200030e0655ULL, 0x00000000503a7faeULL, 0x0003e8000c901c46ULL,
0x00000000523b7faeULL, 0x0003e8000d101c46ULL, 0x00000000543c7faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff3a7f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff007984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106680027507f8cULL, 0x000fe2000c80043fULL, 0x8000000000ff7812ULL, 0x004fc6000780484fULL,
0x01066c0027397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x004fe40007824851ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000397305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000390000735dULL, 0x008fe40003800000ULL, 0x01066c0027397984ULL, 0x000ea40000000800ULL,
0x8000000039ff7812ULL, 0x004fc40007824851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010180003d397984ULL, 0x000ea80000000800ULL, 0x010380003d3c7984ULL, 0x0007220000000800ULL,
0x000000293900720bULL, 0x004fe20003f3d000ULL, 0x0000cc027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00527812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff507424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x000fe40003f45270ULL,
0x000000293900720bULL, 0x000fe20003f34000ULL, 0x0000cbc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x00000039293e7209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x8000003e29297221ULL, 0x000fe20000010000ULL,
0x0105803e3d00a388ULL, 0x0005e20000000800ULL, 0x0000000052ff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b29297820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fca0000011626ULL,
0x0000002900297308ULL, 0x000ee40000000800ULL, 0x000000292a2a7220ULL, 0x008fe20000410000ULL,
0x0000cb527f007947ULL, 0x000fea000b800000ULL, 0x00001f0029007589ULL, 0x0044e400000e0000ULL,
0x0000000004047220ULL, 0x08cfe20000410000ULL, 0x0000000005057220ULL, 0x080fe20000410000ULL,
0x0000000008087220ULL, 0x080fe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x000fe20000410000ULL,
0x0000caa27f007947ULL, 0x000fea000b800000ULL, 0x00001f3629007589ULL, 0x0004e400000e0000ULL,
0x8000003e39391221ULL, 0x100fe20000010000ULL, 0x00000001ff507807ULL, 0x000fe20000800000ULL,
0x0000000006067220ULL, 0x08cfe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b39391820ULL, 0x000fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x00000039002d1308ULL, 0x000ea20000000800ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x000fe20000410000ULL,
0x000000ffff297224ULL, 0x000fe200078e003eULL, 0x0000003c2d3c1220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000002a3c2a7221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc4000780484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000397305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000390000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x004fe4000780484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002dff00723eULL, 0x000fe400000010ffULL,
0x00000002ff397819ULL, 0x000fc40000011626ULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x0000c8527f007947ULL, 0x000fea000b800000ULL, 0x00001f395a397589ULL, 0x0004e400000e0000ULL,
0x0000c8a27f007947ULL, 0x000fea000b800000ULL, 0x00001f365a4f7589ULL, 0x0008a400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0037ULL,
0x0000dc00005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000cf9000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0038ULL,
0x0000dc60005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000cf3000007944ULL, 0x01efea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003f54783bULL, 0x000f620000004200ULL,
0x0000991050007816ULL, 0x004fc400000000ffULL, 0x0000b80043437811ULL, 0x000fe200078e20ffULL,
0x000000004058783bULL, 0x010aa20000004200ULL, 0x000000ff0000720cULL, 0x000fc60003f05270ULL,
0x000000004150783bULL, 0x0008e80000004200ULL, 0x00000000423c783bULL, 0x0002620000004200ULL,
0x00000010ff407819ULL, 0x020fe40000011654ULL, 0x000000ff54417812ULL, 0x010fe400078ec0ffULL,
0x000000ff5a657812ULL, 0x004fe400078ec0ffULL, 0x000000ff40407812ULL, 0x000fc400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x000000ff5b667812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x008fe20000011652ULL, 0x20000065ff6d7230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x0000ffff558e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff50687812ULL, 0x000fc400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe40000011650ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x000000ff53807812ULL, 0x000fe400078ec0ffULL,
0x0000007bff65723eULL, 0x000fe200020006ffULL, 0x20000040ff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff527e7812ULL, 0x000fe200078ec0ffULL, 0x20000066ff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x002fe20000011655ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff7d7819ULL, 0x000fc40000011657ULL, 0x000000ff516a7812ULL, 0x000fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000008ff407819ULL, 0x000fe2000001168eULL, 0x20000041ff737230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000ffff548d7812ULL, 0x000fc400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000007eff66723eULL, 0x000fe400020006ffULL,
0x0000006aff6c723eULL, 0x000fe200020006ffULL, 0x20000068ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff42427812ULL, 0x000fe200078ec0ffULL, 0x20000067ff687230ULL, 0x000fe20000004100ULL,
0x000000ff7d7e7812ULL, 0x000fe200078ec0ffULL, 0x20000080ff677230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000018ff007819ULL, 0x000fe20000011654ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fc40000011656ULL, 0x0000ffff568f7812ULL, 0x040fe400078ec0ffULL,
0x00000008ff417819ULL, 0x000fe4000001168dULL, 0x000000ff565f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe40000011656ULL, 0x000000ff57607812ULL, 0x000fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fc40000011659ULL, 0x00000018ff567819ULL, 0x000fe40000011657ULL,
0x0000ffff57907812ULL, 0x000fe400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe4000001165aULL,
0x00000010ff7a7819ULL, 0x100fe40000011651ULL, 0x00000018ff697819ULL, 0x000fe40000011651ULL,
0x0000ffff51787812ULL, 0x000fc400078ec0ffULL, 0x00000018ff817819ULL, 0x000fe4000001163cULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x0000007eff80723eULL, 0x000fe200020006ffULL,
0x20000040ff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff827819ULL, 0x100fe20000011658ULL,
0x20000042ff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff58617812ULL, 0x000fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fc40000011658ULL, 0x0000ffff58917812ULL, 0x000fe400078ec0ffULL,
0x00000000ff51723eULL, 0x000fe400020006ffULL, 0x00000010ff837819ULL, 0x000fe40000011659ULL,
0x00000010ff587819ULL, 0x100fe2000001163fULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x000000ff3f8c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fc4000001163fULL,
0x0000ffff3f007812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff407819ULL, 0x000fe4000001168fULL,
0x00000060ff3f723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000081ff60723eULL, 0x000fe200020006ffULL, 0x20000080ff817230ULL, 0x000fe20000004100ULL,
0x000000ff3c847812ULL, 0x000fe200078ec0ffULL, 0x20000062ff717230ULL, 0x000fe20000004100ULL,
0x00000018ff7f7819ULL, 0x000fe20000011653ULL, 0x20000064ff6e7230ULL, 0x000fe20000004100ULL,
0x0000007cff42723eULL, 0x000fe200020006ffULL, 0x20000041ff7c7230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x000000ff83807812ULL, 0x000fc400078ec0ffULL, 0x000000ff55547812ULL, 0x000fe400078ec0ffULL,
0x00000008ff417819ULL, 0x000fe40000011690ULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x00000008ff837819ULL, 0x000fe40000011691ULL, 0x00000084ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x000fc4000001165aULL, 0x0000ffff5a937812ULL, 0x000fe200078ec0ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000007fff64723eULL, 0x000fe200020006ffULL,
0x20000042ff7f7230ULL, 0x000fe20000004100ULL, 0x00000080ff84723eULL, 0x000fe200020006ffULL,
0x20000040ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff887819ULL, 0x100fe2000001165bULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff5a7819ULL, 0x000fe4000001165bULL,
0x0000ffff5b947812ULL, 0x000fc400078ec0ffULL, 0x00000054ff75723eULL, 0x000fe400020006ffULL,
0x00000018ff857819ULL, 0x100fe4000001163dULL, 0x00000010ff547819ULL, 0x000fe2000001163dULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x000000ff3d867812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3d5b7812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x00000082ff42723eULL, 0x000fe400020006ffULL, 0x00000083ff40723eULL, 0x000fe200020006ffULL,
0x20000041ff827230ULL, 0x000fe20000004100ULL, 0x00000056ff3d723eULL, 0x000fe200020006ffULL,
0x20000042ff837230ULL, 0x000fe20000004100ULL, 0x00000061ff56723eULL, 0x000fe400020006ffULL,
0x00000085ff61723eULL, 0x000fe200020006ffULL, 0x20000084ff857230ULL, 0x000fe20000004100ULL,
0x00000018ff5d7819ULL, 0x000fe20000011655ULL, 0x20000040ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011653ULL, 0x000000004340783bULL, 0x000e620000000200ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x000000ff59637812ULL, 0x040fe200078ec0ffULL, 0x2000005dff767230ULL, 0x000fe20000004100ULL,
0x0000ffff59927812ULL, 0x000fe200078ec0ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fc40000011652ULL, 0x0000ffff52527812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x100fe4000001163eULL, 0x000000ff3e8a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe4000001163eULL, 0x0000ffff3e597812ULL, 0x000fe400078ec0ffULL,
0x0000005fff3e723eULL, 0x000fc400020006ffULL, 0x0000008bff5d723eULL, 0x000fe400020006ffULL,
0x00000072ff8b723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011673ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fe40000011650ULL, 0x0000ffff50777812ULL, 0x000fe400078ec0ffULL,
0x00000008ff527819ULL, 0x000fc40000011652ULL, 0x00000010ff737819ULL, 0x000fe20000011675ULL,
0x2000008bff757230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff507819ULL, 0x000fe2000001163cULL, 0x0000003940408231ULL, 0x082fe200003400ffULL,
0x0000ffff3c557812ULL, 0x000fe200078ec0ffULL, 0x0000003942428231ULL, 0x000fe200003400ffULL,
0x0000005eff3c723eULL, 0x000fe200020006ffULL, 0x0000004f41418231ULL, 0x080fe200003400ffULL,
0x00000052ff8b723eULL, 0x000fe200020006ffULL, 0x0000004f43438231ULL, 0x000fe200003400ffULL,
0x000010547d737816ULL, 0x000fe20000000073ULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe20000011676ULL, 0x2000008bff767230ULL, 0x000fe20000004100ULL,
0x00000010ff7d7819ULL, 0x000fc4000001167eULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff3e7819ULL, 0x000fe4000001163eULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00001054527d7816ULL, 0x000fc4000000007dULL, 0x00000050ff52723eULL, 0x000fe400020006ffULL,
0x00001054517c7816ULL, 0x000fe4000000007cULL, 0x000010547f507816ULL, 0x000fe4000000003eULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff517819ULL, 0x000fe20000011681ULL,
0x0000007c4008723cULL, 0x000fe20000041808ULL, 0x00000010ff3c7819ULL, 0x000fc4000001163cULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x0000b800443e7811ULL, 0x000fe200078e20ffULL,
0x20000052ff447230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff817819ULL, 0x000fe40000011682ULL, 0x0000ffff53537812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7b7819ULL, 0x000fc4000001167bULL, 0x0000105451517816ULL, 0x000fe4000000003fULL,
0x000010543c807816ULL, 0x000fe40000000080ULL, 0x000010543d817816ULL, 0x000fe40000000081ULL,
0x00000008ff537819ULL, 0x000fe20000011653ULL, 0x000000003e3c783bULL, 0x000e620000000200ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x000010547b727816ULL, 0x000fc40000000072ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000057ff70723eULL, 0x000fe200020006ffULL, 0x20000063ff577230ULL, 0x000fe20000004100ULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x2000005aff6b7230ULL, 0x000fe20000004100ULL,
0x00000089ff5a723eULL, 0x000fe200020006ffULL, 0x000000724004723cULL, 0x040fe20000041804ULL,
0x00000086ff63723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000008aff5f723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000088ff89723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff867819ULL, 0x000fe20000011692ULL, 0x20000053ff727230ULL, 0x000fe20000004100ULL,
0x000000ff87877812ULL, 0x000fe200078ec0ffULL, 0x000000504050723cULL, 0x000fe2000004180cULL,
0x00000008ff887819ULL, 0x000fe20000011693ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fe20000011694ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fc40000011656ULL, 0x00000010ff0d7819ULL, 0x000fe40000011657ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x000000393c3c8231ULL, 0x082fe200003400ffULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00001054830c7816ULL, 0x000fe20000000056ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00001054850d7816ULL, 0x000fe2000000000dULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff79797812ULL, 0x000fe200078ec0ffULL,
0x000000393e3e8231ULL, 0x000fe200003400ffULL, 0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL,
0x0000004f3d3d8231ULL, 0x080fe200003400ffULL, 0x00000010ff0e7819ULL, 0x000fe20000011671ULL,
0x0000000c4014723cULL, 0x000fe20000041814ULL, 0x00000010ff707819ULL, 0x000fe20000011670ULL,
0x0000004f3f3f8231ULL, 0x000fe200003400ffULL, 0x00000010ff847819ULL, 0x000fc40000011684ULL,
0x00000010ff717819ULL, 0x000fe40000011686ULL, 0x00000010ff0d7819ULL, 0x000fe4000001166fULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff6f7819ULL, 0x000fe4000001168aULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x0000105470707816ULL, 0x000fe20000000084ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x000010540e717816ULL, 0x000fe20000000071ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00001054870c7816ULL, 0x000fc4000000006dULL,
0x00001054890d7816ULL, 0x000fe4000000000dULL, 0x000010546e6e7816ULL, 0x000fe20000000088ULL,
0x000000704018723cULL, 0x040fe20000041818ULL, 0x000010546b6f7816ULL, 0x000fe4000000006fULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x00000008ff557819ULL, 0x000fe20000011655ULL, 0x0000000c401c723cULL, 0x000fe2000004181cULL,
0x00000008ff777819ULL, 0x000fc40000011677ULL, 0x00000008ff787819ULL, 0x000fe40000011678ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x000000ff74747812ULL, 0x000fe200078ec0ffULL,
0x0000006e4020723cULL, 0x040fe20000041820ULL, 0x00000054ff73723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000055ff0f723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff58587812ULL, 0x000fe200078ec0ffULL, 0x000000804054723cULL, 0x000fe20000041810ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x2000000fff737230ULL, 0x000fe20000004100ULL,
0x00000008ff007819ULL, 0x000fc40000011600ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff117819ULL, 0x000fe4000001166cULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fc400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x0000008cff5e723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x0000105479107816ULL, 0x000fe2000000006aULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x000010547a117816ULL, 0x000fe20000000011ULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fc40000011661ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x000000103c10723cULL, 0x000fe20000041804ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff0d7819ULL, 0x000fe40000011678ULL,
0x0000105461617816ULL, 0x000fc4000000005bULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff057819ULL, 0x000fe40000011672ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff7b7819ULL, 0x000fc4000001167bULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff417819ULL, 0x000fe4000001165eULL,
0x00000010ff587819ULL, 0x000fc40000011658ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165dULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x00001054680c7816ULL, 0x000fe40000000077ULL,
0x00001054690d7816ULL, 0x000fc4000000000dULL, 0x0000105474667816ULL, 0x000fe40000000066ULL,
0x0000105475677816ULL, 0x000fe40000000067ULL, 0x0000105465047816ULL, 0x000fe20000000076ULL,
0x0000000c3c0c723cULL, 0x000fe20000041808ULL, 0x0000105464057816ULL, 0x000fe40000000005ULL,
0x0000105444627816ULL, 0x000fe40000000062ULL, 0x000010547b637816ULL, 0x000fc40000000063ULL,
0x0000105460607816ULL, 0x000fe20000000073ULL, 0x000000663c08723cULL, 0x040fe20000041850ULL,
0x000010545c407816ULL, 0x000fe4000000005fULL, 0x0000105458417816ULL, 0x000fe40000000041ULL,
0x000010545a5a7816ULL, 0x000fe40000000059ULL, 0x000010545b5b7816ULL, 0x000fe20000000000ULL,
0x000000043c04723cULL, 0x040ff00000041854ULL, 0x000000623c14723cULL, 0x040ff00000041814ULL,
0x000000603c18723cULL, 0x040ff00000041818ULL, 0x000000403c1c723cULL, 0x040ff0000004181cULL,
0x0000005a3c20723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff3c7f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc4000782483dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000782483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000397305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000390000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fc4000782483dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000030024007a10ULL, 0x000fc80007ffe0ffULL,
0x00000001003c7810ULL, 0x040fe20007ffe0ffULL, 0x0000010000397824ULL, 0x000fc600078e00ffULL,
0x000000253c00720cULL, 0x000fe20003f26070ULL, 0x0000620028007a24ULL, 0x000fe200078e0239ULL,
0x00000039033d7217ULL, 0x000fc60007800000ULL, 0x000000012e3c7824ULL, 0x100fe400078e0200ULL,
0x000000013d3d7824ULL, 0x000fe400078e0a39ULL, 0x00000100ff397424ULL, 0x000fe400078e00ffULL,
0x00000001333e7824ULL, 0x000fe200078e0200ULL, 0x000000203d2e7807ULL, 0x000fe20000800000ULL,
0x00005e003c3c7625ULL, 0x080fe200078e0039ULL, 0x00000004ff337819ULL, 0x000fe40000011626ULL,
0x0000002e272e7217ULL, 0x000fe20007800000ULL, 0x00005e003e3e7625ULL, 0x000fe200078e0039ULL,
0x0000002f3c407210ULL, 0x000fc60007f3e0ffULL, 0x000000012e2e7824ULL, 0x000fe200078e0a27ULL,
0x0000002f3e3e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000134347824ULL, 0x100fe400078e0200ULL,
0x00000001353c7824ULL, 0x000fe200078e0200ULL, 0x0000002e3300720cULL, 0x080fe20003f46070ULL,
0x000000ffff417224ULL, 0x000fe200008e063dULL, 0x0000002e3000720cULL, 0x080fe20003f26070ULL,
0x00005e0034347625ULL, 0x000fe200078e0039ULL, 0x0000002e3200720cULL, 0x000fc60003f86070ULL,
0x00005e003c3c7625ULL, 0x000fc800078e0039ULL, 0x000000ffff3f7224ULL, 0x000fe200018e063fULL,
0x0000002e3100720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000404e7faeULL, 0x0003e2000d101c46ULL, 0x0000002f342e7210ULL, 0x080fe40007fbe0ffULL,
0x0000002f3c307210ULL, 0x000fe20007fde0ffULL, 0x000000003e4d7faeULL, 0x0003e4000c901c46ULL,
0x000000ffff2f7224ULL, 0x000fe400028e0635ULL, 0x000000ffff317224ULL, 0x000fc800030e063dULL,
0x000000002e4c7faeULL, 0x0003e8000d901c46ULL, 0x00000000304b7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff2e7f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc4000782483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4f7224ULL, 0x000fe200078e002fULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe4000782483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x00000000002e7305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x0000002e0000735dULL, 0x004fe40003800000ULL, 0x0106b400ff2e7984ULL, 0x000e640000000800ULL,
0x800000002eff7812ULL, 0x002fc4000782483bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002dff00723eULL, 0x000fe400000010ffULL, 0x00000002ff2e7819ULL, 0x000fe40000011626ULL,
0x00005410005a7816ULL, 0x000fe20000000000ULL, 0x0000ac227f007947ULL, 0x000fea000b800000ULL,
0x00001f2e5a2e7589ULL, 0x0002a400000e0000ULL, 0x0000ac727f007947ULL, 0x000fea000b800000ULL,
0x00001f365a2f7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0037ULL, 0x0000f910005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000b28000007944ULL, 0x01efea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0038ULL, 0x0000f970005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000b22000007944ULL, 0x01efea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004a34783bULL, 0x008ee80000004200ULL, 0x000000004938783bULL, 0x000f680000004200ULL,
0x000000004848783bULL, 0x000e680000004200ULL, 0x000000004730783bULL, 0x0008a20000004200ULL,
0x000000ff343c7812ULL, 0x008fc400078ec0ffULL, 0x00000010ff447819ULL, 0x100fe40000011634ULL,
0x00000018ff007819ULL, 0x004fe40000011634ULL, 0x0000ffff34717812ULL, 0x000fe400078ec0ffULL,
0x000000ff3b567812ULL, 0x020fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe4000001163bULL,
0x0000003cff34723eULL, 0x000fc400020006ffULL, 0x000000ff48577812ULL, 0x002fe400078ec0ffULL,
0x000000ff495a7812ULL, 0x000fe400078ec0ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000010ff687819ULL, 0x100fe4000001163aULL, 0x000000ff3a547812ULL, 0x000fe200078ec0ffULL,
0x20000056ff597230ULL, 0x000fe20000004100ULL, 0x00000018ff537819ULL, 0x000fc4000001163aULL,
0x0000ffff3a797812ULL, 0x000fe200078ec0ffULL, 0x20000034ff3a7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000010ff6c7819ULL, 0x000fe2000001163bULL, 0x20000055ff567230ULL, 0x000fe20000004100ULL,
0x0000ffff3b7a7812ULL, 0x000fe200078ec0ffULL, 0x20000057ff557230ULL, 0x000fe20000004100ULL,
0x0000005aff34723eULL, 0x000fc400020006ffULL, 0x00000018ff3b7819ULL, 0x000fe40000011648ULL,
0x00000010ff477819ULL, 0x110fe20000011635ULL, 0x20000034ff577230ULL, 0x000fe20000004100ULL,
0x000000ff44447812ULL, 0x000fe400078ec0ffULL, 0x000000ff353e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011635ULL, 0x0000ffff35737812ULL, 0x000fc400078ec0ffULL,
0x00000000ff35723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fe200020006ffULL, 0x20000035ff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff47477812ULL, 0x000fe200078ec0ffULL, 0x20000054ff587230ULL, 0x000fe20000004100ULL,
0x00000044ff34723eULL, 0x000fe200020006ffULL, 0x2000003bff547230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fc40000011648ULL, 0x0000ffff487b7812ULL, 0x000fe200078ec0ffULL,
0x20000034ff3b7230ULL, 0x000fe20000004100ULL, 0x00000018ff3f7819ULL, 0x100fe40000011636ULL,
0x00000010ff707819ULL, 0x100fe40000011649ULL, 0x00000018ff487819ULL, 0x000fe40000011649ULL,
0x0000ffff497c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x000fc40000011636ULL,
0x000000ff364c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff36757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x100fe40000011637ULL, 0x000000ff374e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011637ULL, 0x0000ffff37767812ULL, 0x000fc400078ec0ffULL,
0x00000010ff677819ULL, 0x100fe40000011639ULL, 0x000000ff39527812ULL, 0x040fe400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe40000011639ULL, 0x0000ffff39787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x000fe4000001164aULL, 0x000000ff4a607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x0000ffff4a7d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x100fe40000011638ULL, 0x000000ff38507812ULL, 0x040fe400078ec0ffULL,
0x00000018ff377819ULL, 0x000fe40000011638ULL, 0x0000ffff38777812ULL, 0x000fc400078ec0ffULL,
0x00000010ff747819ULL, 0x100fe4000001164bULL, 0x000000ff4b637812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b397812ULL, 0x000fe400078ec0ffULL,
0x0000003dff36723eULL, 0x000fe400020006ffULL, 0x00000047ff35723eULL, 0x000fc400020006ffULL,
0x00000010ff387819ULL, 0x100fe20000011630ULL, 0x20000036ff627230ULL, 0x000fe20000004100ULL,
0x000000ff30647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe40000011630ULL,
0x0000ffff303d7812ULL, 0x000fe400078ec0ffULL, 0x0000003fff30723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fc40000011671ULL, 0x00000052ff3f723eULL, 0x000fe200020006ffULL,
0x20000030ff307230ULL, 0x000fe20000004100ULL, 0x00000060ff52723eULL, 0x000fe200020006ffULL,
0x20000035ff607230ULL, 0x000fe20000004100ULL, 0x00000008ff357819ULL, 0x000fe20000011673ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000037ff37723eULL, 0x000fc400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x000000ff61617812ULL, 0x000fe200078ec0ffULL, 0x20000037ff5b7230ULL, 0x000fe20000004100ULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x20000051ff5c7230ULL, 0x000fe20000004100ULL,
0x0000005dff36723eULL, 0x000fe200020006ffULL, 0x20000034ff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe40000011631ULL, 0x000000ff31697812ULL, 0x000fc400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011631ULL, 0x0000ffff31427812ULL, 0x000fe400078ec0ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000004dff31723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fe20000011676ULL, 0x2000003eff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000031ff317230ULL, 0x000fe20000004100ULL,
0x00000064ff4d723eULL, 0x000fc400020006ffULL, 0x00000008ff377819ULL, 0x000fe40000011675ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000061ff64723eULL, 0x000fe200020006ffULL, 0x20000035ff617230ULL, 0x000fe20000004100ULL,
0x00000063ff51723eULL, 0x000fe200020006ffULL, 0x20000036ff637230ULL, 0x000fe20000004100ULL,
0x00000034ff35723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fc400020006ffULL,
0x0000b80046347811ULL, 0x000fe200078e20ffULL, 0x20000035ff467230ULL, 0x000fe20000004100ULL,
0x00000008ff367819ULL, 0x000fe40000011677ULL, 0x00000010ff437819ULL, 0x100fe40000011632ULL,
0x000000ff326b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011632ULL,
0x0000ffff32417812ULL, 0x000fc400078ec0ffULL, 0x00000050ff3e723eULL, 0x000fe200020006ffULL,
0x2000004aff507230ULL, 0x000fe20000004100ULL, 0x0000004cff32723eULL, 0x000fe400020006ffULL,
0x00000069ff4c723eULL, 0x000fe200020006ffULL, 0x20000067ff697230ULL, 0x000fe20000004100ULL,
0x00000065ff4a723eULL, 0x000fe200020006ffULL, 0x20000064ff657230ULL, 0x000fe20000004100ULL,
0x00000036ff67723eULL, 0x000fe200020006ffULL, 0x20000037ff647230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x00000010ff3a7819ULL, 0x000fe2000001163aULL, 0x20000053ff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff3b7819ULL, 0x000fe2000001163bULL, 0x20000048ff537230ULL, 0x000fe20000004100ULL,
0x00000018ff6d7819ULL, 0x000fe20000011633ULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fc40000011633ULL, 0x000000ff336e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff33007812ULL, 0x000fe400078ec0ffULL, 0x000010543b3a7816ULL, 0x000fe4000000003aULL,
0x0000004eff33723eULL, 0x000fe400020006ffULL, 0x0000006bff48723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x00001054603b7816ULL, 0x000fe2000000005fULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x000000ff686b7812ULL, 0x000fe200078ec0ffULL, 0x20000067ff687230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x2000006dff447230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff677819ULL, 0x000fe20000011679ULL,
0x20000049ff4e7230ULL, 0x000fe20000004100ULL, 0x000000ff38387812ULL, 0x000fe400078ec0ffULL,
0x00000010ff327819ULL, 0x000fe20000011632ULL, 0x0000002e34348231ULL, 0x082fe200003400ffULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x0000002e36368231ULL, 0x000fe200003400ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x0000002f35358231ULL, 0x080fe200003400ffULL,
0x00000008ff6d7819ULL, 0x000fe2000001167aULL, 0x0000002f37378231ULL, 0x000fe200003400ffULL,
0x00000008ff397819ULL, 0x000fc40000011639ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000004bff49723eULL, 0x000fe400020006ffULL, 0x0000003a3410723cULL, 0x000fe20000041810ULL,
0x0000006eff4b723eULL, 0x000fe400020006ffULL, 0x00000010ff5f7819ULL, 0x000fe20000011661ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x0000006dff6e723eULL, 0x000fe200020006ffULL,
0x2000006cff6d7230ULL, 0x000fe20000004100ULL, 0x00000038ff3a723eULL, 0x000fe200020006ffULL,
0x20000067ff6c7230ULL, 0x000fe20000004100ULL, 0x0000105463387816ULL, 0x000fe20000000032ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000039ff61723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff337819ULL, 0x000fc40000011633ULL,
0x00000010ff307819ULL, 0x000fe20000011630ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff317819ULL, 0x000fe40000011631ULL, 0x0000b80045327811ULL, 0x000fe200078e20ffULL,
0x2000003aff457230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe40000011665ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff467819ULL, 0x000fc40000011646ULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000008ff677819ULL, 0x000fe4000001167bULL,
0x0000105439397816ULL, 0x000fe40000000033ULL, 0x0000105430647816ULL, 0x000fe40000000064ULL,
0x0000105431657816ULL, 0x000fe40000000046ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x000000003230783bULL, 0x000e620000000200ULL, 0x00000008ff717819ULL, 0x000fe2000001167cULL,
0x000000383438723cULL, 0x000fe20000041808ULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x000000ff72737812ULL, 0x000fe400078ec0ffULL,
0x00000071ff72723eULL, 0x000fe200020006ffULL, 0x20000070ff717230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x20000067ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff677819ULL, 0x000fe2000001167dULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x00000010ff3e7819ULL, 0x000fe2000001163eULL,
0x2000006aff477230ULL, 0x000fe20000004100ULL, 0x00000008ff6a7819ULL, 0x000fe20000011678ULL,
0x20000067ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff677819ULL, 0x000fe40000011669ULL,
0x0000006aff6a723eULL, 0x000fc400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000105466667816ULL, 0x000fe2000000003eULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000105467677816ULL, 0x000fe2000000003fULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x0000002f31318231ULL, 0x082fe200003400ffULL, 0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL,
0x000000663414723cULL, 0x000fe20000041814ULL, 0x000000ff3c3c7812ULL, 0x000fe200078ec0ffULL,
0x0000002f33338231ULL, 0x000fe200003400ffULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x0000002e30308231ULL, 0x080fe200003400ffULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x0000002e32328231ULL, 0x000fe200003400ffULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x000010545b687816ULL, 0x000fe40000000068ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff697819ULL, 0x000fe4000001166aULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff6b7819ULL, 0x000fc4000001166bULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff5b7819ULL, 0x000fe4000001166eULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x0000003cff09723eULL, 0x000fe400020006ffULL, 0x000010545e5e7816ULL, 0x000fe2000000005dULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00001054625f7816ULL, 0x000fe2000000005fULL,
0x20000009ff5d7230ULL, 0x000fe20000004100ULL, 0x000010545c697816ULL, 0x000fe40000000069ULL,
0x000010546b587816ULL, 0x000fe40000000058ULL, 0x000010546d597816ULL, 0x000fe20000000059ULL,
0x0000005e340c723cULL, 0x000fe2000004180cULL, 0x000010545a5a7816ULL, 0x000fc4000000006cULL,
0x00001054565b7816ULL, 0x000fe4000000005bULL, 0x00000008ff3d7819ULL, 0x000fe4000001163dULL,
0x000000ff74747812ULL, 0x000fe200078ec0ffULL, 0x000000683418723cULL, 0x040fe20000041818ULL,
0x0000003dff08723eULL, 0x000fe400020006ffULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x000000ff43437812ULL, 0x000fe200078ec0ffULL, 0x20000008ff467230ULL, 0x000fe20000004100ULL,
0x000000ff40407812ULL, 0x000fe200078ec0ffULL, 0x00000064343c723cULL, 0x000fe20000041804ULL,
0x00000008ff417819ULL, 0x000fc40000011641ULL, 0x00000008ff007819ULL, 0x000fe40000011600ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff057819ULL, 0x000fe20000011657ULL,
0x00000058341c723cULL, 0x000fe2000004181cULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff4d7819ULL, 0x000fc4000001164dULL,
0x00000010ff2f7819ULL, 0x000fe2000001164cULL, 0x0000005a3420723cULL, 0x000fe20000041820ULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000000ff00723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x000010546f047816ULL, 0x000fe20000000055ULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x0000105471057816ULL, 0x000fe20000000005ULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x00001054452e7816ULL, 0x000fc4000000004dULL, 0x000010545d2f7816ULL, 0x000fe4000000002fULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x000000043004723cULL, 0x040fe20000041810ULL,
0x00000010ff097819ULL, 0x000fe40000011672ULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff547819ULL, 0x000fe20000011654ULL,
0x0000002e3014723cULL, 0x000fe20000041814ULL, 0x00000010ff707819ULL, 0x000fc40000011670ULL,
0x0000105453097816ULL, 0x000fe40000000009ULL, 0x0000105449347816ULL, 0x000fe40000000046ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff537819ULL, 0x000fc40000011674ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff117819ULL, 0x000fe40000011661ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff357819ULL, 0x000fc40000011642ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff497819ULL, 0x000fe4000001164bULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff417819ULL, 0x000fc40000011641ULL,
0x00000010ff2f7819ULL, 0x000fe40000011644ULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x0000105454087816ULL, 0x000fe40000000070ULL, 0x0000105473527816ULL, 0x000fe40000000052ULL,
0x0000105453537816ULL, 0x000fe40000000051ULL, 0x000010544e107816ULL, 0x000fe20000000060ULL,
0x000000083008723cULL, 0x000fe2000004180cULL, 0x0000105450117816ULL, 0x000fc40000000011ULL,
0x000010544a357816ULL, 0x000fe40000000035ULL, 0x0000105443487816ULL, 0x000fe40000000048ULL,
0x0000105440497816ULL, 0x000fe20000000049ULL, 0x00000052300c723cULL, 0x000fe20000041838ULL,
0x00001054472e7816ULL, 0x000fe40000000041ULL, 0x000010542f2f7816ULL, 0x000fca0000000000ULL,
0x000000103010723cULL, 0x040ff0000004183cULL, 0x000000343018723cULL, 0x040ff00000041818ULL,
0x00000048301c723cULL, 0x040ff0000004181cULL, 0x0000002e3020723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff2e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff507224ULL, 0x002fc600078e002fULL,
0x0000030024247a10ULL, 0x000fc80007ffe0ffULL, 0x000000252400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffefc9000007947ULL, 0x000fea000383ffffULL,
0x0000000000357919ULL, 0x000e620000002500ULL, 0x000000ffff347224ULL, 0x000fe400078e0023ULL,
0x000000ffff337224ULL, 0x000fe400078e0022ULL, 0x000000ffff327224ULL, 0x000fe400078e0021ULL,
0x000000ffff317224ULL, 0x000fe400078e0020ULL, 0x000000ffff307224ULL, 0x000fe400078e001fULL,
0x000000ffff2f7224ULL, 0x008fc400078e001eULL, 0x000000ffff2e7224ULL, 0x000fe400078e001dULL,
0x000000ffff2d7224ULL, 0x004fe400078e001cULL, 0x000000ffff2c7224ULL, 0x000fe400078e001bULL,
0x000000ffff2b7224ULL, 0x000fe400078e001aULL, 0x000000ffff287224ULL, 0x000fe400078e0019ULL,
0x000000ffff267224ULL, 0x000fe200078e0018ULL, 0x000000253500720cULL, 0x002fe20003f06070ULL,
0x000000ffff247224ULL, 0x000fc400078e0017ULL, 0x000000ffff237224ULL, 0x000fe400078e0016ULL,
0x000000ffff227224ULL, 0x000fe400078e0015ULL, 0x000000ffff217224ULL, 0x000fe400078e0014ULL,
0x000000ffff207224ULL, 0x000fe400078e0013ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0012ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0011ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0010ULL,
0x000000ffff1c7224ULL, 0x000fe400078e000fULL, 0x000000ffff1b7224ULL, 0x000fe400078e000eULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fe400078e000cULL,
0x000000ffff187224ULL, 0x000fc400078e000bULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff167224ULL, 0x000fe400078e0009ULL, 0x000000ffff137224ULL, 0x000fe400078e0008ULL,
0x000000ffff157224ULL, 0x000fe400078e0007ULL, 0x000000ffff147224ULL, 0x000fe400078e0006ULL,
0x000000ffff127224ULL, 0x000fc400078e0005ULL, 0x000000ffff117224ULL, 0x000fe200078e0004ULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x018000002a007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e002aULL, 0x0001135000067802ULL, 0x000fe40000000f00ULL,
0x0000968000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002a00007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc8000000002aULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x006fca00078e00ffULL, 0x0000000604047981ULL, 0x0002a8000c1e9900ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x00000002ff037819ULL, 0x002fe20000011605ULL,
0x0000000004007220ULL, 0x00cfe20000410000ULL, 0x0000000805047811ULL, 0x000fc800078ff0ffULL,
0x00001f0300037589ULL, 0x000e6800000e0000ULL, 0x00001f0400047589ULL, 0x000ea200000e0000ULL,
0x0000001103117220ULL, 0x042fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002803287220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x000fe20000410000ULL,
0x0000001404147220ULL, 0x044fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x000fe20000410000ULL,
0x0000000000007919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000200037812ULL, 0x002fc400078ec0ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011600ULL,
0x00000001ff047819ULL, 0x000fe40000011603ULL, 0x0000000203057811ULL, 0x040fe400078ff8ffULL,
0x0000000403087811ULL, 0x040fe400078ff8ffULL, 0x00000006030c7811ULL, 0x000fe400078ff8ffULL,
0x0000000800107811ULL, 0x000fc400078ff0ffULL, 0x0000000704037812ULL, 0x100fe400078e780eULL,
0x0000000705067812ULL, 0x140fe400078e780eULL, 0x00000007080a7812ULL, 0x000fe200078e780eULL,
0x000000080e077824ULL, 0x000fe200078e0203ULL, 0x0000000708087812ULL, 0x000fe200078e7810ULL,
0x000000080e097824ULL, 0x000fe200078e0206ULL, 0x000000070c0d7812ULL, 0x000fe200078e780eULL,
0x0000080002037824ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x000fe200078e7810ULL,
0x00000008100f7824ULL, 0x000fe200078e0208ULL, 0x0000000705057812ULL, 0x000fe200078e7810ULL,
0x000000080e0b7824ULL, 0x000fe200078e020aULL, 0x000000070c067812ULL, 0x000fe200078e7810ULL,
0x000000080e0d7824ULL, 0x000fc400078e020dULL, 0x00000008100c7824ULL, 0x000fe200078e0204ULL,
0x0000a00003047810ULL, 0x000fe20007ffe0ffULL, 0x0000000800087824ULL, 0x000fe400078e00ffULL,
0x00000008100e7824ULL, 0x000fe200078e0205ULL, 0x000000111205723eULL, 0x000fe200000010ffULL,
0x0000000810107824ULL, 0x000fe200078e0206ULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000001007077824ULL, 0x100fe200078e0204ULL, 0x000000131606723eULL, 0x000fe200000010ffULL,
0x00000010090a7824ULL, 0x000fc400078e0204ULL, 0x000000100b0b7824ULL, 0x000fe200078e0204ULL,
0x0000541005127816ULL, 0x040fe20000000006ULL, 0x000000100c0c7824ULL, 0x000fe200078e0204ULL,
0x0000763205137816ULL, 0x000fe20000000006ULL, 0x000000100e0e7824ULL, 0x100fe200078e0204ULL,
0x000000212205723eULL, 0x000fe200000010ffULL, 0x000000100d0d7824ULL, 0x100fe400078e0204ULL,
0x000000100f0f7824ULL, 0x100fe400078e0204ULL, 0x0000001010107824ULL, 0x000fc400078e0204ULL,
0x0000000107097824ULL, 0x000fe200078e0208ULL, 0x000000191a07723eULL, 0x000fe200000010ffULL,
0x00000001080a7824ULL, 0x040fe400078e020aULL, 0x00000001080b7824ULL, 0x040fe200078e020bULL,
0x0000001209007388ULL, 0x0003e20000000a00ULL, 0x00000001080c7824ULL, 0x040fe400078e020cULL,
0x00000001080e7824ULL, 0x040fe400078e020eULL, 0x00000001080d7824ULL, 0x000fc400078e020dULL,
0x00000001080f7824ULL, 0x040fe400078e020fULL, 0x0000000108107824ULL, 0x000fe200078e0210ULL,
0x0000001d1e08723eULL, 0x000fe400000010ffULL, 0x000000141509723eULL, 0x002fe400000010ffULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe40000000008ULL,
0x000000313208723eULL, 0x000fc600000010ffULL, 0x000000060a007388ULL, 0x0003e40000000a00ULL,
0x000000262806723eULL, 0x002fe400000010ffULL, 0x0000002d2e07723eULL, 0x000fe400000010ffULL,
0x00000017180a723eULL, 0x000fe400000010ffULL, 0x0000541005127816ULL, 0x140fe40000000006ULL,
0x0000763205137816ULL, 0x000fc40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000120b007388ULL, 0x0003e20000000a00ULL,
0x0000541009087816ULL, 0x140fe4000000000aULL, 0x0000763209097816ULL, 0x000fe2000000000aULL,
0x000000060d007388ULL, 0x0005e20000000a00ULL, 0x0000001b1c05723eULL, 0x000fe400000010ffULL,
0x00000033340a723eULL, 0x000fe200000010ffULL, 0x000000080c007388ULL, 0x0007e20000000a00ULL,
0x00000300ff137624ULL, 0x002fe200078e00ffULL, 0x0000001f2006723eULL, 0x004fc400000010ffULL,
0x000000232407723eULL, 0x000fe400000010ffULL, 0x0000002b2c08723eULL, 0x008fe400000010ffULL,
0x000000011300780cULL, 0x000fe40003f05270ULL, 0x0000002f3009723eULL, 0x000fe400000010ffULL,
0x00005410050c7816ULL, 0x140fe40000000006ULL, 0x00007632050d7816ULL, 0x000fc40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000000c0e007388ULL, 0x0003e20000000a00ULL, 0x0000541009087816ULL, 0x140fe4000000000aULL,
0x0000763209097816ULL, 0x000fe2000000000aULL, 0x000000060f007388ULL, 0x0003e80000000a00ULL,
0x0000000810007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002b4000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x002e620000002700ULL,
0x0000001000057824ULL, 0x000fe200078e0203ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000067919ULL, 0x000e620000002600ULL,
0x00000020000e7810ULL, 0x040fe40007ffe0ffULL, 0x000000ff0000720cULL, 0x000fe20000725670ULL,
0x00a0000005147984ULL, 0x000ea80000000c00ULL, 0x00a2000005187984ULL, 0x0007240000000c00ULL,
0x0000580013057a24ULL, 0x008fc800078e02ffULL, 0x0000640005077a24ULL, 0x000fe400078e02ffULL,
0x0000580010107a24ULL, 0x002fc600078e0206ULL, 0x00000fff07067811ULL, 0x040fe400078e40ffULL,
0x01ffffff07077812ULL, 0x000fe200078ec0ffULL, 0x0000030010057a24ULL, 0x000fc800078e02ffULL,
0x00000001050a7824ULL, 0x000fca00078e0235ULL, 0x0000000a06087211ULL, 0x000fca00078fa0ffULL,
0x00006a0008087625ULL, 0x000fcc00078e0009ULL, 0x0000040002087825ULL, 0x000fcc00078e0008ULL,
0x000000100e0e7825ULL, 0x000fc800078e0008ULL, 0x00000010000c7825ULL, 0x000fe200078e0008ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000001000087824ULL, 0x014fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011600ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x000000010a0b7824ULL, 0x000fe200078e0207ULL, 0x0000007008127812ULL, 0x000fe400078ec0ffULL,
0x0000000c091c7812ULL, 0x000fe200078ec0ffULL, 0x00006a000a087625ULL, 0x000fc800078e0011ULL,
0x00006a000b0a7625ULL, 0x000fe200078e0011ULL, 0x000000081c087210ULL, 0x000fc80007b5e012ULL,
0x0000000a1c0a7210ULL, 0x000fe40007d9e012ULL, 0x00000009ff097210ULL, 0x000fe400017e64ffULL,
0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL, 0x0000002908007986ULL, 0x0003e8000c101906ULL,
0x0000002a0a007986ULL, 0x0003e4000c101906ULL, 0x000000140c007986ULL, 0x0145e2000c101d06ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x000000180e007986ULL, 0x0005e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff087424ULL, 0x002fe200078e00ffULL, 0xffffffff130a7810ULL, 0x000fc60007ffe0ffULL,
0x0000680010087625ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000a080879a8ULL, 0x000ee400099ee1c6ULL,
0x0000000a0800720cULL, 0x008fe20003f25270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff097807ULL, 0x000fca0000800000ULL, 0x00000009ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff087984ULL, 0x002e640000000000ULL, 0x000000ff0800720cULL, 0x002fda0003f25270ULL,
0x0000278000009947ULL, 0x000fea0003800000ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff127424ULL, 0x000fe200078e00ffULL, 0x00000001050a7810ULL, 0x000fe40007ffe0ffULL,
0x0000007008147812ULL, 0x004fe400078ec0ffULL, 0x0000000c09157812ULL, 0x000fe200078ec0ffULL,
0x00006a0005087625ULL, 0x000fc800078e0012ULL, 0x00006a000a0a7625ULL, 0x000fe200078e0012ULL,
0x0000000815087210ULL, 0x000fc8000791e014ULL, 0x0000000a150a7210ULL, 0x000fe40007b5e014ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x00000006080c7981ULL, 0x000368000c1e1900ULL, 0x000000060a0d7981ULL, 0x000362000c1e1900ULL,
0x000000021300780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000205087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000815087210ULL, 0x000fc8000791e014ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080e7981ULL, 0x000362000c1e1900ULL, 0x000000041300780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000305087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000815087210ULL, 0x000fc8000791e014ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000041300780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000405087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000815087210ULL, 0x000fc8000791e014ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608107981ULL, 0x000362000c1e1900ULL, 0x000000061300780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000505087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000815087210ULL, 0x000fc8000791e014ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000362000c1e1900ULL,
0x000000061300780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081300780cULL, 0x002fe40003f06070ULL, 0x0000000605087810ULL, 0x000fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000815087210ULL, 0x000fe40007a3e014ULL,
0x00000007050a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006a000a0a0625ULL, 0x000fe400078e0012ULL, 0x0000000608127981ULL, 0x000366000c1e1900ULL,
0x0000000a150a0210ULL, 0x000fc80007c7e014ULL, 0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL,
0x000000060a0a0981ULL, 0x000368000c1e1900ULL, 0x0000000713087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0b7819ULL, 0x000fc80000011608ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff137224ULL, 0x000fe400078e00ffULL,
0x000000ffff147224ULL, 0x024fe400078e000cULL, 0x0000000813157824ULL, 0x040fe200078e00ffULL,
0x0000000113137810ULL, 0x000fc80007ffe0ffULL, 0x0000030015007a0cULL, 0x000fe40003f26070ULL,
0x0000000b1300720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x0000000815087810ULL, 0x040fe40007ffe0ffULL, 0x0000000115097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000140c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007014147812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e014ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608147981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x0000000915087810ULL, 0x042fe40007ffe0ffULL,
0x0000000215097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000315097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000e0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e00eULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080e7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000415097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000f7824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000515097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000100c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010107812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e010ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608107981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000615097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000110c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000715097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000120c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007012127812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e012ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608127981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f15087810ULL, 0x002fe40007ffe0ffULL,
0x0000000a0c0c7209ULL, 0x000fe40007810000ULL, 0x0000030008007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007a3e00aULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080a7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x0000001000087824ULL, 0x00afe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011600ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000108087824ULL, 0x000fca00078e0209ULL,
0x0000000c08007388ULL, 0x0203e40000000800ULL, 0x0000000506087211ULL, 0x002fe200078fa0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00001000ff097424ULL, 0x000fe200078e00ffULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011600ULL, 0x00006a0008087625ULL, 0x000fe200078e0009ULL,
0x00000016ff437819ULL, 0x000fe20000011602ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000040002427824ULL, 0x040fe200078e00ffULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000100002217824ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x0000004208087210ULL, 0x000fe20007f3e0ffULL, 0x000000010a207824ULL, 0x000fe200078e020bULL,
0x00000020000a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001050c8824ULL, 0x004fe200078e0207ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000109097824ULL, 0x000fe200008e0643ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff0d8424ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0e8424ULL, 0x000fe200078e00ffULL,
0x0000000020207984ULL, 0x000e620000000800ULL, 0x00006a000c0c8625ULL, 0x000fe200078e000dULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000100a0a7825ULL, 0x000fe200078e0008ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000001000107824ULL, 0x000fc400078e0221ULL,
0x0000001002118824ULL, 0x000fe400078e0200ULL, 0x0000001000087825ULL, 0x000fc600078e0008ULL,
0x0000458011118811ULL, 0x000fe200078e20ffULL, 0x00006a00050e8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008107faeULL, 0x0005e6000b901c46ULL,
0x0000001002128824ULL, 0x000fe200078e0200ULL, 0x003800000a107faeULL, 0x0007e2000b901c46ULL,
0x00000010000c8825ULL, 0x000fc800078e000cULL, 0x00000010000e8825ULL, 0x000fe200078e000eULL,
0x000000000c118faeULL, 0x0009e2000b901c46ULL, 0x0000418012098811ULL, 0x004fe400078e20ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x008fe4000001ff00ULL,
0x000000000e098faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x004fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000cf000009947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x002fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fca00078e00ffULL, 0x0000000134357810ULL, 0x000fc80007ffe0ffULL,
0x0000030035007a0cULL, 0x000fda0003f06070ULL, 0x0000023000000947ULL, 0x000fea0003800000ULL,
0x00000001051f7824ULL, 0x000fe200078e0235ULL, 0x000000070000780cULL, 0x000fe20003f24070ULL,
0x00001000ff197424ULL, 0x000fe200078e00ffULL, 0x00000001351e7812ULL, 0x040fe200078ec0ffULL,
0x00000800351a7824ULL, 0x000fe200078e00ffULL, 0x0000001f06187211ULL, 0x000fe400078fa0ffULL,
0x0000002000387810ULL, 0x000fe40007ffe0ffULL, 0x000008001a1c7812ULL, 0x000fe200078ec0ffULL,
0x00006a0018187625ULL, 0x000fc800078e0019ULL, 0x00000001071b9824ULL, 0x000fe200078e021fULL,
0x0000004218187210ULL, 0x000fe20007f1e0ffULL, 0x00000080ff369424ULL, 0x000fe400078e00ffULL,
0x00000002021d9824ULL, 0x140fe400078e021eULL, 0x0000000202399824ULL, 0x000fe400078e021eULL,
0x00006a001b1a9625ULL, 0x000fc800078e0036ULL, 0x00000080ff1e9424ULL, 0x000fe400078e00ffULL,
0x00000001211c7824ULL, 0x000fe400078e021cULL, 0x0000000119197824ULL, 0x000fe400000e0643ULL,
0x000000081d379824ULL, 0x000fe400078e0200ULL, 0x00006a001f1e9625ULL, 0x000fc600078e001eULL,
0x0000458037379811ULL, 0x000fe200078e20ffULL, 0x0000001000367824ULL, 0x040fe400078e021cULL,
0x0000000839399824ULL, 0x000fe400078e0200ULL, 0x00000010001c9825ULL, 0x000fc800078e001aULL,
0x00000010381a7825ULL, 0x000fe200078e0018ULL, 0x0000418039389811ULL, 0x000fc600078e20ffULL,
0x0000001000187825ULL, 0x000fc800078e0018ULL, 0x00000010001e9825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000018367faeULL, 0x0003e8000b901c46ULL,
0x003800001a367faeULL, 0x0003e8000b901c46ULL, 0x000000001c379faeULL, 0x0003e8000b901c46ULL,
0x000000001e389faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff377224ULL, 0x002fe200078e0034ULL, 0x00000001ff1a7819ULL, 0x100fe20000011600ULL,
0x0000001000197824ULL, 0x000fe200078e00ffULL, 0x00000002ff447819ULL, 0x000fe20000011600ULL,
0x0000008037187824ULL, 0x000fe200078e00ffULL, 0x0000000c1a1a7812ULL, 0x000fc400078ec0ffULL,
0x0000007019197812ULL, 0x000fe200078ec0ffULL, 0x00000008441b7824ULL, 0x000fe200078e00ffULL,
0x0000008018187812ULL, 0x000fe400078ec0ffULL, 0x00000044ff367212ULL, 0x000fe400078e33ffULL,
0x0000000744347812ULL, 0x000fe200078ec0ffULL, 0x0000010002187824ULL, 0x000fe200078e0218ULL,
0xfffffff81b367812ULL, 0x000fe400078ee236ULL, 0x0000000844457810ULL, 0x000fc40007ffe0ffULL,
0x000000181a187210ULL, 0x000fe20007ffe019ULL, 0x0000000844197824ULL, 0x000fe200078e00ffULL,
0x00000045ff3f7212ULL, 0x000fe200078e33ffULL, 0x0000000845387824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000181a7984ULL, 0x000e620000000800ULL,
0x00000001191b7812ULL, 0x100fe200078ef634ULL, 0x0000000845397824ULL, 0x000fe200078e00ffULL,
0x00000002191c7812ULL, 0x140fe200078ef634ULL, 0x0045800018417984ULL, 0x0004e20000000800ULL,
0x00000003191d7812ULL, 0x140fe400078ef634ULL, 0x00000004191e7812ULL, 0x140fe400078ef634ULL,
0x00000005191f7812ULL, 0x000fe400078ef634ULL, 0xfffffff8383f7812ULL, 0x000fe200078ee23fULL,
0x0000000844187824ULL, 0x004fca00078e00ffULL, 0xfffffff818187812ULL, 0x100fe400078ee234ULL,
0x0000000619347812ULL, 0x000fe200078ef634ULL, 0x0000080037197824ULL, 0x000fca00078e00ffULL,
0x0000080019197812ULL, 0x000fc800078ec0ffULL, 0x0000018021197810ULL, 0x000fca0007ffe019ULL,
0x0000001018187824ULL, 0x100fe400078e0219ULL, 0x0000001036367824ULL, 0x100fe400078e0219ULL,
0x000000101b1b7824ULL, 0x100fe200078e0219ULL, 0x0000001a201a7221ULL, 0x002fe20000010100ULL,
0x000000101c1c7824ULL, 0x100fe400078e0219ULL, 0x000000101d1d7824ULL, 0x000fe200078e0219ULL,
0x3fb8aa3b1a377820ULL, 0x000fe20000410000ULL, 0x00000004001a7824ULL, 0x000fc400078e00ffULL,
0x000000101e1e7824ULL, 0x100fe200078e0219ULL, 0x0000003700407308ULL, 0x0002e20000000800ULL,
0x000000101f1f7824ULL, 0x100fe200078e0219ULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000001034347824ULL, 0x100fe400078e0219ULL, 0x000000103f3f7824ULL, 0x000fe400078e0219ULL,
0x0000000118187824ULL, 0x000fe200078e021aULL, 0x0000000745377812ULL, 0x002fe200078ec0ffULL,
0x000000011a367824ULL, 0x000fc400078e0236ULL, 0x000000011a1b7824ULL, 0x000fe200078e021bULL,
0xfffffff838387812ULL, 0x100fe200078ee237ULL, 0x000000011a1c7824ULL, 0x000fe200078e021cULL,
0x00000001393a7812ULL, 0x140fe200078ef637ULL, 0x0000004140407220ULL, 0x008fe20000410000ULL,
0x00000002393b7812ULL, 0x140fe200078ef637ULL, 0x0000000036417984ULL, 0x000fe20000000800ULL,
0x00000003393c7812ULL, 0x040fe200078ef637ULL, 0x000000011a1d7824ULL, 0x040fe200078e021dULL,
0x00000004393d7812ULL, 0x140fe200078ef637ULL, 0x000000001b367984ULL, 0x000fe20000000800ULL,
0x00000005393e7812ULL, 0x140fe200078ef637ULL, 0x000000011a1e7824ULL, 0x040fe200078e021eULL,
0x0000000639377812ULL, 0x000fe200078ef637ULL, 0x00001f44401b7589ULL, 0x000fe200000e0000ULL,
0x000000011a1f7824ULL, 0x000fe200078e021fULL, 0x0000003340337221ULL, 0x000fe20000010000ULL,
0x000000011a347824ULL, 0x000fe200078e0234ULL, 0x0000000018397984ULL, 0x000e620000000800ULL,
0x0000001038387824ULL, 0x000fc400078e0219ULL, 0x000000103a3a7824ULL, 0x100fe200078e0219ULL,
0x000000001c1c7984ULL, 0x000ea20000000800ULL, 0x000000011a387824ULL, 0x040fe400078e0238ULL,
0x000000011a3a7824ULL, 0x000fe200078e023aULL, 0x000000001d1d7984ULL, 0x000ee20000000800ULL,
0x000000103b3b7824ULL, 0x100fe400078e0219ULL, 0x000000103c3c7824ULL, 0x000fe200078e0219ULL,
0x000000001e1e7984ULL, 0x000f220000000800ULL, 0x000000011a3b7824ULL, 0x000fc400078e023bULL,
0x000000011a3c7824ULL, 0x000fe200078e023cULL, 0x000000001f1f7984ULL, 0x000f620000000800ULL,
0x000000103d3d7824ULL, 0x100fe400078e0219ULL, 0x000000103e3e7824ULL, 0x000fe200078e0219ULL,
0x0000000034347984ULL, 0x000ea20000000800ULL, 0x000000011a3d7824ULL, 0x040fe400078e023dULL,
0x000000011a3e7824ULL, 0x000fe200078e023eULL, 0x0000000038387984ULL, 0x000ea20000000800ULL,
0x0000001037377824ULL, 0x000fc400078e0219ULL, 0x000000011a3f7824ULL, 0x040fe200078e023fULL,
0x000000003a3a7984ULL, 0x000fe20000000800ULL, 0x000000011a377824ULL, 0x000fc600078e0237ULL,
0x00001f4540407589ULL, 0x000ea800000e0000ULL, 0x000000003b3b7984ULL, 0x000ea20000000800ULL,
0x00005410ff187816ULL, 0x002fc60000000039ULL, 0x000000003c3c7984ULL, 0x000e640000000800ULL,
0x0000001b18327223ULL, 0x080fe20000010032ULL, 0x00007610ff187816ULL, 0x000fe20000000039ULL,
0x000000003d3d7984ULL, 0x000e680000000800ULL, 0x0000001b18317223ULL, 0x080fe20000010031ULL,
0x00005410ff187816ULL, 0x000fe20000000041ULL, 0x000000003e3e7984ULL, 0x000e680000000800ULL,
0x0000001b18237223ULL, 0x080fe20000010023ULL, 0x00007610ff187816ULL, 0x000fe20000000041ULL,
0x0000000037377984ULL, 0x000e680000000800ULL, 0x0000001b18227223ULL, 0x080fe20000010022ULL,
0x00005410ff187816ULL, 0x000fe20000000036ULL, 0x000000003f3f7984ULL, 0x000e680000000800ULL,
0x0000001b18307223ULL, 0x000fe20000010030ULL, 0x00007610ff187816ULL, 0x000fca0000000036ULL,
0x0000001b182f7223ULL, 0x000fe2000001002fULL, 0x00005410ff187816ULL, 0x004fca000000001cULL,
0x0000001b182e7223ULL, 0x000fe2000001002eULL, 0x00007610ff187816ULL, 0x000fca000000001cULL,
0x0000001b182d7223ULL, 0x000fe2000001002dULL, 0x00005410ff187816ULL, 0x008fca000000001dULL,
0x0000001b182c7223ULL, 0x000fe2000001002cULL, 0x00007610ff187816ULL, 0x000fca000000001dULL,
0x0000001b182b7223ULL, 0x000fe2000001002bULL, 0x00005410ff187816ULL, 0x010fca000000001eULL,
0x0000001b182a7223ULL, 0x000fe2000001002aULL, 0x00007610ff187816ULL, 0x000fca000000001eULL,
0x0000001b18297223ULL, 0x000fe20000010029ULL, 0x00005410ff187816ULL, 0x020fca000000001fULL,
0x0000001b18287223ULL, 0x000fe20000010028ULL, 0x00007610ff187816ULL, 0x000fca000000001fULL,
0x0000001b18267223ULL, 0x000fe20000010026ULL, 0x00005410ff187816ULL, 0x000fca0000000034ULL,
0x0000001b18257223ULL, 0x000fe20000010025ULL, 0x00007610ff187816ULL, 0x000fe20000000034ULL,
0x000000ffff347224ULL, 0x000fc800078e0035ULL, 0x0000001b18247223ULL, 0x000fe20000010024ULL,
0x00005410ff187816ULL, 0x000fe40000000038ULL, 0x0000030034007a0cULL, 0x000fc60003f06070ULL,
0x0000004018177223ULL, 0x000fe20000010017ULL, 0x00007610ff187816ULL, 0x000fca0000000038ULL,
0x0000004018167223ULL, 0x000fe20000010016ULL, 0x00005410ff187816ULL, 0x000fca000000003aULL,
0x0000004018157223ULL, 0x000fe20000010015ULL, 0x00007610ff187816ULL, 0x000fca000000003aULL,
0x0000004018147223ULL, 0x000fe20000010014ULL, 0x00005410ff187816ULL, 0x000fca000000003bULL,
0x0000004018137223ULL, 0x000fe20000010013ULL, 0x00007610ff187816ULL, 0x000fca000000003bULL,
0x0000004018127223ULL, 0x000fe20000010012ULL, 0x00005410ff187816ULL, 0x002fca000000003cULL,
0x0000004018117223ULL, 0x000fe20000010011ULL, 0x00007610ff187816ULL, 0x000fca000000003cULL,
0x0000004018107223ULL, 0x000fe20000010010ULL, 0x00005410ff187816ULL, 0x000fca000000003dULL,
0x00000040180f7223ULL, 0x000fe2000001000fULL, 0x00007610ff187816ULL, 0x000fca000000003dULL,
0x00000040180e7223ULL, 0x000fe2000001000eULL, 0x00005410ff187816ULL, 0x000fca000000003eULL,
0x00000040180d7223ULL, 0x000fe2000001000dULL, 0x00007610ff187816ULL, 0x000fca000000003eULL,
0x00000040180c7223ULL, 0x000fe2000001000cULL, 0x00005410ff187816ULL, 0x000fca0000000037ULL,
0x00000040180b7223ULL, 0x000fe2000001000bULL, 0x00007610ff187816ULL, 0x000fca0000000037ULL,
0x00000040180a7223ULL, 0x000fe2000001000aULL, 0x00005410ff187816ULL, 0x000fca000000003fULL,
0x0000004018097223ULL, 0x000fe20000010009ULL, 0x00007610ff187816ULL, 0x000fca000000003fULL,
0x0000004018087223ULL, 0x000fe20000010008ULL, 0xfffff33000008947ULL, 0x000fea000383ffffULL,
0x0180000033007810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000000007812ULL, 0x000fc600078ec0ffULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0033ULL, 0x00013dd000067802ULL, 0x000fe40000000f00ULL,
0x00006c0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003300027308ULL, 0x000e640000001000ULL,
0xbf80000002337423ULL, 0x002fc80000000033ULL, 0x800000ff33337221ULL, 0x000fc80000010100ULL,
0x0000003302027223ULL, 0x000fe40000000002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff187819ULL, 0x004fe20000011600ULL, 0x00000004001e7824ULL, 0x040fe200078e00ffULL,
0x00000008001d7811ULL, 0x000fe400078ff0ffULL, 0x00000018ff067212ULL, 0x000fe200078e33ffULL,
0x00001f1802057589ULL, 0x002e6200000e0000ULL, 0x0000001dff1c7212ULL, 0x000fe200078e33ffULL,
0x000000081d077824ULL, 0x040fe200078e00ffULL, 0x000000071d1b7812ULL, 0x000fe200078ec0ffULL,
0x00001f1d02027589ULL, 0x000ea200000e0000ULL, 0x00000008181f7824ULL, 0x000fe200078e00ffULL,
0x0000000c1e1e7812ULL, 0x000fc400078ec0ffULL, 0xfffffff8071c7812ULL, 0x000fe400078ee21cULL,
0x0000000718077812ULL, 0x040fe400078ec0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x0000000818067824ULL, 0x000fe200078e00ffULL, 0x000000041b197812ULL, 0x040fe200078e3cffULL,
0x000000101c1c7824ULL, 0x000fe200078e0204ULL, 0x000000051b1a7812ULL, 0x000fe400078e3cffULL,
0xfffffff806067812ULL, 0x000fe200078ee218ULL, 0x000000081d197824ULL, 0x000fc400078e0219ULL,
0x000000081d1a7824ULL, 0x000fe400078e021aULL, 0x0000001006067824ULL, 0x000fe200078e0204ULL,
0x0000003205327220ULL, 0x042fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x000fe20000410000ULL,
0x0000001702177220ULL, 0x044fe20000410000ULL, 0x0000001602167220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001302137220ULL, 0x040fe20000410000ULL, 0x0000001202127220ULL, 0x040fe20000410000ULL,
0x0000001102117220ULL, 0x040fe20000410000ULL, 0x0000001002107220ULL, 0x040fe20000410000ULL,
0x0000000f020f7220ULL, 0x040fe20000410000ULL, 0x0000000e020e7220ULL, 0x040fe20000410000ULL,
0x0000000d020d7220ULL, 0x040fe20000410000ULL, 0x0000000c020c7220ULL, 0x040fe20000410000ULL,
0x0000000b020b7220ULL, 0x040fe20000410000ULL, 0x0000000a020a7220ULL, 0x040fe20000410000ULL,
0x0000000902097220ULL, 0x040fe20000410000ULL, 0x0000000802027220ULL, 0x000fe20000410000ULL,
0x0000000107087812ULL, 0x000fe200078e3cffULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000000b0a0a723eULL, 0x000fe200000010ffULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x000000090202723eULL, 0x000fe200000010ffULL, 0x0000002c052c7220ULL, 0x000fe20000410000ULL,
0x0000000207097812ULL, 0x000fe200078e3cffULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000000d0c0c723eULL, 0x000fe200000010ffULL, 0x0000002a052a7220ULL, 0x000fe20000410000ULL,
0x00000003070b7812ULL, 0x000fe200078e3cffULL, 0x0000002905297220ULL, 0x040fe20000410000ULL,
0x000000111010723eULL, 0x000fe200000010ffULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000000f0e0e723eULL, 0x000fe200000010ffULL, 0x0000002605267220ULL, 0x000fe20000410000ULL,
0x00000004070d7812ULL, 0x040fe200078e3cffULL, 0x000000011e067824ULL, 0x000fe200078e0206ULL,
0x00000005070f7812ULL, 0x000fe200078e3cffULL, 0x0000002505257220ULL, 0x000fe20000410000ULL,
0x0000000607117812ULL, 0x000fe200078e3cffULL, 0x0000000818077824ULL, 0x000fe200078e0208ULL,
0x000000131212723eULL, 0x000fe200000010ffULL, 0x0000000818087824ULL, 0x000fe200078e0209ULL,
0x000000171616723eULL, 0x000fe200000010ffULL, 0x0000000818097824ULL, 0x040fe200078e020bULL,
0x000000021b177812ULL, 0x000fe200078e3cffULL, 0x00000008180b7824ULL, 0x000fe200078e020dULL,
0x000000323131723eULL, 0x000fe200000010ffULL, 0x000000081d137824ULL, 0x000fe200078e00ffULL,
0x000000151414723eULL, 0x000fe200000010ffULL, 0x00000008180d7824ULL, 0x040fe200078e020fULL,
0x0000002405247220ULL, 0x000fe20000410000ULL, 0x00000008180f7824ULL, 0x000fe200078e0211ULL,
0x000000011b117812ULL, 0x000fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x000000031b187812ULL, 0x000fe200078e3cffULL, 0x0000001008087824ULL, 0x100fe200078e0204ULL,
0xfffffff813137812ULL, 0x000fe200078ee21dULL, 0x0000001009097824ULL, 0x100fe200078e0204ULL,
0x0000002305237220ULL, 0x000fe20000410000ULL, 0x000000100b0b7824ULL, 0x100fe200078e0204ULL,
0x000000302f2f723eULL, 0x000fe200000010ffULL, 0x000000081d157824ULL, 0x000fe200078e0211ULL,
0x000000061b1b7812ULL, 0x000fe200078e3cffULL, 0x000000100d0d7824ULL, 0x100fe200078e0204ULL,
0x0000002205057220ULL, 0x000fe20000410000ULL, 0x000000011e077824ULL, 0x040fe200078e0207ULL,
0x0000002e2d2d723eULL, 0x000fe200000010ffULL, 0x000000081d177824ULL, 0x000fe200078e0217ULL,
0x0000002c2b2b723eULL, 0x000fe200000010ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0204ULL,
0x0000002a2929723eULL, 0x000fe200000010ffULL, 0x000000011e087824ULL, 0x000fe200078e0208ULL,
0x000000282626723eULL, 0x000fe200000010ffULL, 0x000000081d187824ULL, 0x000fe200078e0218ULL,
0x0000003106007388ULL, 0x0003e20000000800ULL, 0x000000101f117824ULL, 0x100fe200078e0204ULL,
0x000000252424723eULL, 0x000fe200000010ffULL, 0x000000011e097824ULL, 0x040fe200078e0209ULL,
0x0000002f07007388ULL, 0x0003e20000000800ULL, 0x0000001013137824ULL, 0x100fe200078e0204ULL,
0x000000230505723eULL, 0x000fe200000010ffULL, 0x000000011e0b7824ULL, 0x000fe200078e020bULL,
0x0000002d08007388ULL, 0x0003e20000000800ULL, 0x0000001015157824ULL, 0x000fc400078e0204ULL,
0x000000011e0d7824ULL, 0x040fe200078e020dULL, 0x0000002b09007388ULL, 0x0003e20000000800ULL,
0x000000081d1b7824ULL, 0x000fe400078e021bULL, 0x0000001017177824ULL, 0x100fe200078e0204ULL,
0x000000290b007388ULL, 0x0003e20000000800ULL, 0x000000011e0f7824ULL, 0x000fe400078e020fULL,
0x0000001018187824ULL, 0x000fe200078e0204ULL, 0x000000260d007388ULL, 0x0003e20000000800ULL,
0x000000011e117824ULL, 0x000fc400078e0211ULL, 0x0000001019197824ULL, 0x100fe200078e0204ULL,
0x000000240f007388ULL, 0x0003e20000000800ULL, 0x000000011e137824ULL, 0x000fe400078e0213ULL,
0x000000101a1a7824ULL, 0x100fe200078e0204ULL, 0x0000000511007388ULL, 0x0003e20000000800ULL,
0x000000011e157824ULL, 0x040fe400078e0215ULL, 0x000000101b1b7824ULL, 0x000fe200078e0204ULL,
0x0000001613007388ULL, 0x0003e20000000800ULL, 0x000000011e177824ULL, 0x000fc400078e0217ULL,
0x000000011e187824ULL, 0x040fe200078e0218ULL, 0x0000001415007388ULL, 0x0003e20000000800ULL,
0x000000011e197824ULL, 0x040fe400078e0219ULL, 0x000000011e1a7824ULL, 0x040fe200078e021aULL,
0x0000001217007388ULL, 0x0003e20000000800ULL, 0x000000011e1b7824ULL, 0x040fe400078e021bULL,
0x000000011e1c7824ULL, 0x000fe200078e021cULL, 0x0000001018007388ULL, 0x0003e80000000800ULL,
0x0000000e19007388ULL, 0x0003e80000000800ULL, 0x0000000c1a007388ULL, 0x0003e80000000800ULL,
0x0000000a1b007388ULL, 0x0003e80000000800ULL, 0x000000021c007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000002000117810ULL, 0x002fe20007ffe0ffULL,
0x0000000000077919ULL, 0x000e620000002600ULL, 0x00000003ff027819ULL, 0x100fe20000011600ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff057819ULL, 0x100fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000702047812ULL, 0x000fe200078e4800ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000705067812ULL, 0x000fc400078e4811ULL,
0x0ffffff804047812ULL, 0x000fe400078ef800ULL, 0x0ffffff806067812ULL, 0x000fe400078ef811ULL,
0x0000000700107812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x100fe400078e0203ULL,
0x0000001006067824ULL, 0x000fc600078e0203ULL, 0x00a0000004087984ULL, 0x000f280000000c00ULL,
0x00a00000060c7984ULL, 0x0045620000000c00ULL, 0x0000000807037824ULL, 0x042fe400078e00ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff803027812ULL, 0x000fc400078ee202ULL, 0xfffffff807057812ULL, 0x000fe400078ee205ULL,
0x0000000402037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000711067812ULL, 0x004fe200078ec0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x000fe200078048ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005a0005047a11ULL, 0x000fc400078248ffULL, 0x00005b0003037a11ULL, 0x000fe400000f4c00ULL,
0x1ffffff810007812ULL, 0x000fe400078ef827ULL, 0x00005b0005057a11ULL, 0x000fe400008f4c07ULL,
0x1ffffff806067812ULL, 0x000fe200078ef827ULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x0000001006047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604317981ULL, 0x000362000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000124007810ULL, 0x004fe20007ffe0ffULL, 0x0000000228287824ULL, 0x000fe200078e00ffULL,
0x01060000ff047f8cULL, 0x002e62000c80043fULL, 0x0000004002277824ULL, 0x000fe200078e00ffULL,
0x000000250000720cULL, 0x000fe20003f06070ULL, 0x0000580028307a24ULL, 0x000fe400078e0230ULL,
0x00000100240b7824ULL, 0x000fc800078e0227ULL, 0x00006200301d7a24ULL, 0x000fcc00078e020bULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff167819ULL, 0x000fe20000011626ULL,
0x00000100ff197424ULL, 0x000fe200078e00ffULL, 0x0000000b03007217ULL, 0x000fe40007800000ULL,
0x0000000816107810ULL, 0x040fe20007ffe0ffULL, 0x0000000116067824ULL, 0x040fe200078e021dULL,
0x0000001016177810ULL, 0x000fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x00000018161a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110087824ULL, 0x000fe200078e021dULL,
0x000000300d187812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0019ULL,
0x0000002016147810ULL, 0x000fc40007ffe0ffULL, 0x00000003ff127819ULL, 0x100fe20000011626ULL,
0x00005e0008087625ULL, 0x080fe200078e0019ULL, 0x00000018060e7210ULL, 0x080fe40007f1e0ffULL,
0x0000000312127812ULL, 0x100fe200078e4826ULL, 0x00000001170a7824ULL, 0x100fe200078e021dULL,
0x0000001808087210ULL, 0x000fe20007f3e0ffULL, 0x000000011a0c7824ULL, 0x000fe200078e021dULL,
0x0000200002137811ULL, 0x000fe200078e68ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0019ULL,
0x0ffffffc12267812ULL, 0x000fc400078ef826ULL, 0x0000002816157810ULL, 0x000fe20007ffe0ffULL,
0x00005e000c0c7625ULL, 0x080fe200078e0019ULL, 0x000000001700720cULL, 0x080fe40003fa6070ULL,
0x000000001a00720cULL, 0x000fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0607ULL,
0x000000180a0a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x000000180c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000011d067824ULL, 0x000fe200078e0214ULL,
0x000000001400720cULL, 0x080fe20003f66070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000001600720cULL, 0x000fe20003f06070ULL, 0x00005e0006067625ULL, 0x000fc800078e0019ULL,
0x0000000410117824ULL, 0x040fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000001000720cULL, 0x000fe20003f26070ULL, 0x0000001026267824ULL, 0x000fe200078e0213ULL,
0x0000001806107210ULL, 0x000fe20007f5e0ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc11067812ULL, 0x000fe400078ee212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e267faeULL, 0x0005e2000c101c46ULL, 0x000000ffff117224ULL, 0x000fe200010e0607ULL,
0x000000001500720cULL, 0x000fe20003f46070ULL, 0x0000001006067824ULL, 0x000fc400078e0213ULL,
0x000000011d077824ULL, 0x000fc600078e0215ULL, 0x0000000008067faeULL, 0x0007e4000c901c46ULL,
0x00005e0007067625ULL, 0x088fe200078e0019ULL, 0x0000003016087810ULL, 0x040fe40007ffe0ffULL,
0x0000003816097810ULL, 0x000fe20007ffe0ffULL, 0x0000000414167824ULL, 0x000fe200078e00ffULL,
0x00000018060e7210ULL, 0x004fe20007fde0ffULL, 0x000000011d067824ULL, 0x000fe200078e0208ULL,
0x000000000800720cULL, 0x0c0fe20003f26070ULL, 0x00000004081b7824ULL, 0x000fe200078e00ffULL,
0x000000000900720cULL, 0x000fe20003f06070ULL, 0x0000000417007824ULL, 0x000fe200078e00ffULL,
0xfffffffc1a147812ULL, 0x100fe200078ee212ULL, 0x0000000415177824ULL, 0x000fe200078e00ffULL,
0xfffffffc16157812ULL, 0x100fe200078ee212ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0607ULL,
0xfffffffc00007812ULL, 0x100fe200078ee212ULL, 0x000000011d087824ULL, 0x000fe200078e0209ULL,
0xfffffffc17167812ULL, 0x100fe200078ee212ULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b177812ULL, 0x000fe200078ee212ULL, 0x00005e0006067625ULL, 0x000fc600078e0019ULL,
0xfffffffc09127812ULL, 0x000fe200078ee212ULL, 0x00005e0008087625ULL, 0x000fe200078e0019ULL,
0x0000001806067210ULL, 0x000fc60007fde0ffULL, 0x0000001000007824ULL, 0x000fe400078e0213ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000001808087210ULL, 0x000fe20007fde0ffULL,
0x0000001014147824ULL, 0x100fe200078e0213ULL, 0x000000000a007faeULL, 0x0005e2000e901c46ULL,
0x0000001015157824ULL, 0x100fe400078e0213ULL, 0x0000001016167824ULL, 0x100fe200078e0213ULL,
0x000000000c147faeULL, 0x0005e2000e101c46ULL, 0x0000001017177824ULL, 0x000fc400078e0213ULL,
0x0000001012127824ULL, 0x000fe200078e0213ULL, 0x0000000010157faeULL, 0x0005e2000d901c46ULL,
0x000000ffff097224ULL, 0x000fc600030e0609ULL, 0x000000000e167faeULL, 0x0005e8000d101c46ULL,
0x0000000006177faeULL, 0x0005e8000c901c46ULL, 0x0000000008127faeULL, 0x0005e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011626ULL,
0x00000100ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000000826087811ULL, 0x000fc400078ff0ffULL,
0x0000001026077811ULL, 0x040fe400078ff0ffULL, 0x0000001d26067211ULL, 0x000fe200078ff0ffULL,
0x0000000408107824ULL, 0x000fe200078e00ffULL, 0x00000003001e7812ULL, 0x000fe200078e4826ULL,
0x0000000108007824ULL, 0x000fe200078e021dULL, 0x00000028260c7811ULL, 0x040fe200078ff0ffULL,
0x000000011d087824ULL, 0x000fe200078e0207ULL, 0x00000020260b7811ULL, 0x000fe200078ff0ffULL,
0x0000000407117824ULL, 0x000fe200078e00ffULL, 0x000000300d207812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e001fULL, 0x0000001826097811ULL, 0x000fc400078ff0ffULL,
0x00000030260d7811ULL, 0x040fe200078ff0ffULL, 0x000000011d197824ULL, 0x000fe200078e020cULL,
0x00000038260e7811ULL, 0x000fe200078ff0ffULL, 0x000000040c137824ULL, 0x000fe200078e00ffULL,
0xfffffffc100c7812ULL, 0x100fe200078ee21eULL, 0x000000040b127824ULL, 0x000fe200078e00ffULL,
0x0000002006107210ULL, 0x000fe20007f1e0ffULL, 0x000000011d0a7824ULL, 0x000fe200078e0209ULL,
0x0000200002217811ULL, 0x000fe200078e68ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0xfffffffc12127812ULL, 0x000fe200078ee21eULL, 0x000000011d1b7824ULL, 0x000fe200078e020dULL,
0x0ffffffc1e267812ULL, 0x000fe200078ef826ULL, 0x000000040d157824ULL, 0x000fe200078e00ffULL,
0xfffffffc110d7812ULL, 0x100fe200078ee21eULL, 0x000000011d0f7824ULL, 0x000fe200078e020bULL,
0xfffffffc13137812ULL, 0x100fe200078ee21eULL, 0x000000ffff117224ULL, 0x000fe200000e0607ULL,
0xfffffffc15157812ULL, 0x000fe200078ee21eULL, 0x000000011d1d7824ULL, 0x000fc400078e020eULL,
0x000000040e0b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc090e7812ULL, 0x000fe200078ee21eULL,
0x00005e0000067625ULL, 0x000fc600078e001fULL, 0xfffffffc0b1e7812ULL, 0x000fe200078ee21eULL,
0x00005e0008087625ULL, 0x000fc800078e001fULL, 0x0000001012187824ULL, 0x000fe200078e0221ULL,
0x0000002006127210ULL, 0x080fe20007f1e0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e001fULL,
0x0000002008147210ULL, 0x000fc60007f3e0ffULL, 0x00000010131a7824ULL, 0x000fe400078e0221ULL,
0x000000ffff137224ULL, 0x000fe200000e0607ULL, 0x000000200a0a7210ULL, 0x000fe20007f1e0ffULL,
0x00000010151c7824ULL, 0x000fe400078e0221ULL, 0x000000ffff157224ULL, 0x000fe400008e0609ULL,
0x00005e000f067625ULL, 0x000fc800078e001fULL, 0x000000100c007824ULL, 0x100fe400078e0221ULL,
0x000000100d167824ULL, 0x000fe400078e0221ULL, 0x00005e0019087625ULL, 0x000fc800078e001fULL,
0x000000100e177824ULL, 0x000fe200078e0221ULL, 0x0000002008087210ULL, 0x000fe20007f3e0ffULL,
0x00005e001b0c7625ULL, 0x000fc800078e001fULL, 0x00005e001d0e7625ULL, 0x000fe200078e001fULL,
0x000000200c0c7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000002006067210ULL, 0x080fe20007f1e0ffULL, 0x0000001026267824ULL, 0x000fe200078e0221ULL,
0x000000200e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe400008e0609ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010267faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0d7224ULL, 0x000fe400010e060dULL,
0x000000101e1e7824ULL, 0x000fe200078e0221ULL, 0x0000000012007faeULL, 0x0005e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x000fc600018e060fULL, 0x0000000014167faeULL, 0x0005e8000b901c46ULL,
0x000000000a177faeULL, 0x0005e8000b901c46ULL, 0x0000000006187faeULL, 0x0005e8000b901c46ULL,
0x00000000081a7faeULL, 0x0005e8000b901c46ULL, 0x000000000c1c7faeULL, 0x0005e8000b901c46ULL,
0x000000000e1e7faeULL, 0x0005e4000b901c46ULL, 0x01060400ff007984ULL, 0x004ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x006fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x01060400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000002002007824ULL, 0x002fc800078e0200ULL,
0x0000002000057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x000001e005057812ULL, 0x000fe400078ec0ffULL,
0x0000000104077812ULL, 0x040fe400078efcffULL, 0x0000000704067812ULL, 0x140fe400078e7800ULL,
0x0000000707077812ULL, 0x000fe400078e7800ULL, 0x0000001004107810ULL, 0x040fe20007ffe0ffULL,
0x0000000105067824ULL, 0x040fe200078e0206ULL, 0x0000001104047810ULL, 0x000fe20007ffe0ffULL,
0x0000000105077824ULL, 0x000fe200078e0207ULL, 0x0000000710107812ULL, 0x000fc400078e7800ULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000000704047812ULL, 0x000fe400078e7800ULL,
0x0000000105107824ULL, 0x040fe200078e0210ULL, 0x0000000007087984ULL, 0x000ea4000000cc00ULL,
0x0000000105047824ULL, 0x000fe400078e0204ULL, 0x000000ffff147224ULL, 0x002fe400078e000cULL,
0x000000ffff157224ULL, 0x000fc400078e000eULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff187224ULL, 0x000fe400078e000dULL,
0x000000ffff197224ULL, 0x000fe200078e000fULL, 0x0000001406007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1b7224ULL, 0x000fca00078e000bULL,
0x0000001807007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x00000000100c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000aULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1c7224ULL, 0x004fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000001c10007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff047f8cULL, 0x002fe8000c80043fULL,
0x01060400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x01060400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000252400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000267919ULL, 0x000e620000000000ULL, 0x3d80000031317820ULL, 0x020fe20000410000ULL,
0x0001068802327811ULL, 0x040fe200078e18ffULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0xffffffff25337810ULL, 0x000fe40007ffe0ffULL, 0x0001060802347811ULL, 0x000fe400078e28ffULL,
0x0000010024367824ULL, 0x000fe200078e0227ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000360300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff007224ULL, 0x000fe200078e0035ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fc4000001ff00ULL,
0x0000000137287810ULL, 0x000fe20007ffe0ffULL, 0x00000a9000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fe200078e0037ULL, 0x0000000100357812ULL, 0x000fc400078e0cffULL,
0x00000002ff297819ULL, 0x100fe20000011628ULL, 0x000000ffff377224ULL, 0x000fe200078e0028ULL,
0x000000042800780cULL, 0x000fc60003f06070ULL, 0x0000030029297a24ULL, 0x000fc800078e0224ULL,
0x00000100292c7824ULL, 0x040fe200078e0227ULL, 0x00000001292a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000328297812ULL, 0x000fe200078ec0ffULL, 0x00006200303e7a24ULL, 0x000fe200078e022cULL,
0x000000252a00720cULL, 0x000fda0003f26070ULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x00000004293c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff297819ULL, 0x102fe20000011626ULL,
0x00000002023d7824ULL, 0x000fe200078e0235ULL, 0x0000002c03287217ULL, 0x000fe20007800000ULL,
0x00000100ff3b7424ULL, 0x000fe200078e00ffULL, 0x00000002ff2f7819ULL, 0x100fe40000011626ULL,
0x0000000329397812ULL, 0x000fe200078e4826ULL, 0x00000001282c7824ULL, 0x000fe200078e0a2cULL,
0x000000082f297810ULL, 0x040fe20007ffe0ffULL, 0x000000012f287824ULL, 0x000fe200078e023eULL,
0xfffffffc3c3c7812ULL, 0x000fc400078ee226ULL, 0x0000002c2f00720cULL, 0x080fe20003f26070ULL,
0x00000001292a7824ULL, 0x040fe200078e023eULL, 0x0000002c2900720cULL, 0x040fe20003f46070ULL,
0x00000004292e7824ULL, 0x000fe200078e00ffULL, 0x000020003d3d7811ULL, 0x000fe200078e60ffULL,
0x00005e0028287625ULL, 0x080fe200078e003bULL, 0x0ffffffc392d7812ULL, 0x000fe400078ef826ULL,
0xfffffffc2e2e7812ULL, 0x000fe200078ee239ULL, 0x00005e002a2a7625ULL, 0x000fe200078e003bULL,
0x000000282f387810ULL, 0x000fc40007ffe0ffULL, 0x000000302f3a7810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e023dULL, 0x0000002c3800720cULL, 0x080fe20003f86070ULL,
0x000000103c287825ULL, 0x000fe200078e0028ULL, 0x0000002c3a00720cULL, 0x000fc60003fa6070ULL,
0x000000102e2e7824ULL, 0x000fe200078e023dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282d7faeULL, 0x0003e2000c901c46ULL, 0x000000103c2a7825ULL, 0x000fc800078e002aULL,
0x0000000438417824ULL, 0x000fe200078e00ffULL, 0x000000002a2e7faeULL, 0x0005e2000d101c46ULL,
0x000000043a427824ULL, 0x000fc600078e00ffULL, 0xfffffffc41417812ULL, 0x100fe400078ee239ULL,
0x000000102f297810ULL, 0x042fe40007ffe0ffULL, 0x000000182f2d7810ULL, 0x000fe40007ffe0ffULL,
0x0000002c2900720cULL, 0x0c0fe20003f26070ULL, 0x0000000129287824ULL, 0x100fe200078e023eULL,
0x000000202f2b7810ULL, 0x004fe20007ffe0ffULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0x000000382f2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000042d3f7824ULL, 0x040fe200078e00ffULL,
0x0000002c2d00720cULL, 0x080fe20003f46070ULL, 0x000000042b407824ULL, 0x040fe200078e00ffULL,
0x0000002c2b00720cULL, 0x080fe20003f66070ULL, 0x000000042f437824ULL, 0x040fe200078e00ffULL,
0x0000002c2f00720cULL, 0x000fe20003fc6070ULL, 0x00000001382e7824ULL, 0x100fe200078e023eULL,
0xfffffffc3f3f7812ULL, 0x100fe200078ee239ULL, 0x000000012d2a7824ULL, 0x100fe200078e023eULL,
0xfffffffc40407812ULL, 0x100fe200078ee239ULL, 0x000000012b2c7824ULL, 0x100fe200078e023eULL,
0xfffffffc42427812ULL, 0x100fe200078ee239ULL, 0x000000013a387824ULL, 0x100fe200078e023eULL,
0xfffffffc43437812ULL, 0x100fe200078ee239ULL, 0x000000012f3a7824ULL, 0x000fe200078e023eULL,
0xfffffffc293e7812ULL, 0x000fe200078ee239ULL, 0x00005e0028287625ULL, 0x000fc800078e003bULL,
0x00005e002a2a7625ULL, 0x000fc800078e003bULL, 0x00005e002c2c7625ULL, 0x000fc800078e003bULL,
0x00005e002e2e7625ULL, 0x000fc800078e003bULL, 0x00005e0038387625ULL, 0x000fc800078e003bULL,
0x00005e003a3a7625ULL, 0x000fc800078e003bULL, 0x000000103c287825ULL, 0x000fc800078e0028ULL,
0x000000103c2a7825ULL, 0x000fc800078e002aULL, 0x000000103c2c7825ULL, 0x000fc800078e002cULL,
0x000000103c2e7825ULL, 0x000fc800078e002eULL, 0x000000103c387825ULL, 0x000fc800078e0038ULL,
0x000000103c3a7825ULL, 0x000fc800078e003aULL, 0x000000103e3c7824ULL, 0x100fe400078e023dULL,
0x000000103f3e7824ULL, 0x100fe400078e023dULL, 0x00000010403f7824ULL, 0x100fe200078e023dULL,
0x00000000283c7faeULL, 0x0003e2000c901c46ULL, 0x0000001041407824ULL, 0x100fe400078e023dULL,
0x0000001042417824ULL, 0x100fe200078e023dULL, 0x000000002a3e7faeULL, 0x0003e2000d101c46ULL,
0x00000010433d7824ULL, 0x000fc600078e023dULL, 0x000000002c3f7faeULL, 0x0003e8000d901c46ULL,
0x000000002e407faeULL, 0x0003e8000e101c46ULL, 0x0000000038417faeULL, 0x0003e8000e901c46ULL,
0x000000003a3d7faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x00000002022a7824ULL, 0x000fe200078e0235ULL, 0x00000008262c7811ULL, 0x042fe200078ff0ffULL,
0x0000000429407824ULL, 0x000fe200078e00ffULL, 0x00000010262d7811ULL, 0x040fe200078ff0ffULL,
0x00000100ff3f7424ULL, 0x000fe200078e00ffULL, 0x00000018262f7811ULL, 0x000fe200078ff0ffULL,
0x000000042c427824ULL, 0x000fe200078e00ffULL, 0x0000002026397811ULL, 0x040fe200078ff0ffULL,
0x000000042d437824ULL, 0x000fe200078e00ffULL, 0x00000028263b7811ULL, 0x040fe200078ff0ffULL,
0x000000042f447824ULL, 0x000fe200078e00ffULL, 0x00000030263d7811ULL, 0x040fe200078ff0ffULL,
0x0000000439457824ULL, 0x000fe200078e00ffULL, 0x0000003826417811ULL, 0x000fe200078ff0ffULL,
0x000000043b497824ULL, 0x000fe200078e00ffULL, 0x00000003ff297819ULL, 0x000fe20000011626ULL,
0x000000043d4a7824ULL, 0x000fe200078e00ffULL, 0x000020002a467811ULL, 0x000fe200078e60ffULL,
0x00000004414b7824ULL, 0x000fe200078e00ffULL, 0x0000003e26287211ULL, 0x000fe200078ff0ffULL,
0x000000012c2a7824ULL, 0x000fe200078e023eULL, 0x00000003292b7812ULL, 0x000fe200078e4826ULL,
0x000000012d2c7824ULL, 0x000fe200078e023eULL, 0xfffffffc40407812ULL, 0x000fe200078ee226ULL,
0x000000012f2e7824ULL, 0x100fe200078e023eULL, 0xfffffffc42427812ULL, 0x100fe200078ee22bULL,
0x0000000139387824ULL, 0x100fe200078e023eULL, 0xfffffffc43437812ULL, 0x100fe200078ee22bULL,
0x000000013b3a7824ULL, 0x100fe200078e023eULL, 0xfffffffc44447812ULL, 0x100fe200078ee22bULL,
0x000000013d3c7824ULL, 0x100fe200078e023eULL, 0xfffffffc45457812ULL, 0x100fe200078ee22bULL,
0x00000001413e7824ULL, 0x000fe200078e023eULL, 0xfffffffc49497812ULL, 0x100fe200078ee22bULL,
0x00005e0028287625ULL, 0x000fe200078e003fULL, 0xfffffffc4a4a7812ULL, 0x000fc400078ee22bULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee22bULL, 0x00005e002c2c7625ULL, 0x000fe200078e003fULL,
0x0ffffffc2b417812ULL, 0x000fc600078ef826ULL, 0x00005e002a2a7625ULL, 0x000fc800078e003fULL,
0x00005e002e2e7625ULL, 0x000fc800078e003fULL, 0x00005e0038387625ULL, 0x000fc800078e003fULL,
0x00005e003a3a7625ULL, 0x000fc800078e003fULL, 0x00005e003c3c7625ULL, 0x000fc800078e003fULL,
0x00005e003e3e7625ULL, 0x000fc800078e003fULL, 0x0000001040287825ULL, 0x000fc800078e0028ULL,
0x00000010402a7825ULL, 0x000fc800078e002aULL, 0x00000010402c7825ULL, 0x000fc800078e002cULL,
0x00000010402e7825ULL, 0x000fc800078e002eULL, 0x0000001040387825ULL, 0x000fc800078e0038ULL,
0x00000010403a7825ULL, 0x000fc800078e003aULL, 0x00000010403c7825ULL, 0x000fc800078e003cULL,
0x00000010403e7825ULL, 0x000fc800078e003eULL, 0x0000001041487824ULL, 0x100fe400078e0246ULL,
0x0000001042407824ULL, 0x100fe400078e0246ULL, 0x0000001043417824ULL, 0x100fe200078e0246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028487faeULL, 0x0003e2000b901c46ULL,
0x0000001044427824ULL, 0x100fe400078e0246ULL, 0x0000001045437824ULL, 0x100fe200078e0246ULL,
0x000000002a407faeULL, 0x0003e2000b901c46ULL, 0x0000001049447824ULL, 0x000fc400078e0246ULL,
0x000000104a457824ULL, 0x100fe200078e0246ULL, 0x000000002c417faeULL, 0x0003e2000b901c46ULL,
0x000000104b467824ULL, 0x000fc600078e0246ULL, 0x000000002e427faeULL, 0x0003e8000b901c46ULL,
0x0000000038437faeULL, 0x0003e8000b901c46ULL, 0x000000003a447faeULL, 0x0003e8000b901c46ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x000000003e467faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000847397824ULL, 0x002fc400078e00ffULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff826287812ULL, 0x000fe200078ec0ffULL,
0x00000002022b7824ULL, 0x000fe200078e0200ULL, 0x00000020262c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000728287812ULL, 0x000fe400078ef826ULL,
0xfffffff82c2c7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff297819ULL, 0x000fe40000011628ULL,
0x000000072c2c7812ULL, 0x000fc400078ef826ULL, 0x0000000329297812ULL, 0x000fe400078ec0ffULL,
0x000020002b2b7811ULL, 0x000fe400078e60ffULL, 0x00000038292a7212ULL, 0x000fe400078e3cffULL,
0x00000001ff2d7819ULL, 0x000fe4000001162cULL, 0x00000001382e7810ULL, 0x000fe20007ffe0ffULL,
0x00000004282a7824ULL, 0x000fe200078e022aULL, 0x000000032d2d7812ULL, 0x000fc400078ec0ffULL,
0x0000002e29297212ULL, 0x000fe200078e3cffULL, 0x000000102a2a7824ULL, 0x000fc800078e022bULL,
0x0000000428297824ULL, 0x000fe200078e0229ULL, 0x000000002a44783bULL, 0x0002a20000000200ULL,
0x0000003926287211ULL, 0x000fe400078fe0ffULL, 0x0000001029407824ULL, 0x000fe200078e022bULL,
0x0000000439397810ULL, 0x000fe40007ffe0ffULL, 0x0000000228297810ULL, 0x000fe40007ffe0ffULL,
0x000000382d2a7212ULL, 0x042fe200078e3cffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000002e2d2d7212ULL, 0x000fc400078e3cffULL, 0x0000000238387810ULL, 0x000fe20007ffe0ffULL,
0x000000042c2a7824ULL, 0x040fe400078e022aULL, 0x000000042c2d7824ULL, 0x000fe200078e022dULL,
0x000000043800780cULL, 0x000fe20003f25270ULL, 0x000000102a2a7824ULL, 0x100fe400078e022bULL,
0x000000102d2b7824ULL, 0x000fc600078e022bULL, 0x000000002a3c783bULL, 0x0007e40000000200ULL,
0x00000007262a7812ULL, 0x008fc800078ec0ffULL, 0x000000082a2a7812ULL, 0x000fc800078ef826ULL,
0x0000000728287812ULL, 0x100fe400078e782aULL, 0x0000000729297812ULL, 0x000fe400078e782aULL,
0x00000010ff4a7819ULL, 0x004fe20000011644ULL, 0x000000202a497824ULL, 0x040fe200078e0228ULL,
0x00000018ff2d7819ULL, 0x000fe20000011644ULL, 0x000000202a2c7824ULL, 0x000fe200078e0229ULL,
0x000000ff44487812ULL, 0x040fe200078ec0ffULL, 0x000000002b28783bULL, 0x000ea20000000200ULL,
0x0000ffff446a7812ULL, 0x000fe200078ec0ffULL, 0x000000102c2c7824ULL, 0x000fe200078e00ffULL,
0x00000010ff4b7819ULL, 0x000fc40000011645ULL, 0x00000018ff447819ULL, 0x000fe40000011645ULL,
0x000000ff454c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff456b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4d7819ULL, 0x100fe40000011646ULL, 0x00000018ff457819ULL, 0x000fe40000011646ULL,
0x000000ff464e7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff466c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe40000011647ULL, 0x00000018ff467819ULL, 0x000fe40000011647ULL,
0x000000ff47507812ULL, 0x040fe400078ec0ffULL, 0x0000ffff476e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6f7819ULL, 0x002fc40000011641ULL, 0x00000018ff5a7819ULL, 0x000fe40000011641ULL,
0x000000ff41627812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff607819ULL, 0x100fe40000011640ULL, 0x00000018ff477819ULL, 0x000fe40000011640ULL,
0x000000ff40597812ULL, 0x000fc400078ec0ffULL, 0x0000ffff40827812ULL, 0x000fe400078ec0ffULL,
0x0000002dff41723eULL, 0x000fe400020006ffULL, 0x00000010ff2d7819ULL, 0x104fe40000011628ULL,
0x00000018ff787819ULL, 0x000fe20000011628ULL, 0x20000041ff647230ULL, 0x000fe20000004100ULL,
0x000000ff28797812ULL, 0x040fe400078ec0ffULL, 0x0000ffff28407812ULL, 0x000fc400078ec0ffULL,
0x00000008ff287819ULL, 0x000fe4000001166aULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000010ff2f7819ULL, 0x100fe2000001163fULL,
0x20000046ff5b7230ULL, 0x000fe20000004100ULL, 0x00000018ff577819ULL, 0x000fe4000001163fULL,
0x000000ff3f587812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3f2e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3f7819ULL, 0x100fe40000011629ULL, 0x00000018ff7a7819ULL, 0x000fe40000011629ULL,
0x000000ff297b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff293b7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff46723eULL, 0x000fe200020006ffULL, 0x20000028ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fc4000001166bULL, 0x00000008ff287819ULL, 0x000fe2000001166cULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x000000ff42667812ULL, 0x000fe400078ec0ffULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x20000044ff687230ULL, 0x000fe20000004100ULL, 0x000000ff43697812ULL, 0x000fe400078ec0ffULL,
0x00000028ff28723eULL, 0x000fc400020006ffULL, 0x00000066ff41723eULL, 0x000fe200020006ffULL,
0x20000029ff667230ULL, 0x000fe20000004100ULL, 0x00000069ff44723eULL, 0x000fe200020006ffULL,
0x20000028ff697230ULL, 0x000fe20000004100ULL, 0x00000008ff297819ULL, 0x000fe2000001166eULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fe20000011682ULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000029ff29723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000048ff617230ULL, 0x000fe20000004100ULL, 0x00000018ff557819ULL, 0x000fe2000001163eULL,
0x20000029ff6b7230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x0000ffff42847812ULL, 0x000fe400078ec0ffULL,
0x00000059ff48723eULL, 0x000fe200020006ffULL, 0x20000057ff597230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x20000028ff577230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x100fe2000001163cULL, 0x20000055ff767230ULL, 0x000fe20000004100ULL,
0x00000018ff517819ULL, 0x000fc4000001163cULL, 0x000000ff3c527812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3c807812ULL, 0x000fe400078ec0ffULL, 0x00000060ff29723eULL, 0x000fe200020006ffULL,
0x20000058ff607230ULL, 0x000fe20000004100ULL, 0x000000ff3d547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3a7819ULL, 0x100fe2000001162aULL, 0x20000029ff587230ULL, 0x000fe20000004100ULL,
0x00000018ff7c7819ULL, 0x000fc4000001162aULL, 0x000000ff2a7d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2a3c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff287819ULL, 0x000fe40000011684ULL,
0x0000ffff43857812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2a7819ULL, 0x000fe40000011683ULL,
0x00000052ff52723eULL, 0x000fc400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x00000028ff55723eULL, 0x000fe200020006ffULL, 0x0000001049287824ULL, 0x000fe200078e00ffULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x20000052ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fe20000011685ULL, 0x20000054ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x100fe2000001163dULL, 0x2000002aff547230ULL, 0x000fe20000004100ULL,
0x00000018ff537819ULL, 0x000fe2000001163dULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x0000ffff3d817812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5c7819ULL, 0x000fe4000001163eULL,
0x000000ff3e567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e5d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3d7819ULL, 0x100fe4000001162bULL, 0x00000018ff7e7819ULL, 0x000fe4000001162bULL,
0x000000ff2b7f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2b3e7812ULL, 0x000fe400078ec0ffULL,
0x00000029ff52723eULL, 0x000fe400020006ffULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x20000045ff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff617819ULL, 0x000fe20000011661ULL, 0x2000004dff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x2000004eff5e7230ULL, 0x000fe20000004100ULL, 0x0000105462627816ULL, 0x000fe40000000061ULL,
0x000000ff2f617812ULL, 0x000fe200078ec0ffULL, 0x2000004fff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fc40000011643ULL, 0x00000018ff677819ULL, 0x000fe40000011643ULL,
0x00000010ff2f7819ULL, 0x000fe4000001165fULL, 0x0000005aff43723eULL, 0x000fe200020006ffULL,
0x20000050ff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe4000001166aULL,
0x00000010ff5e7819ULL, 0x000fe2000001165eULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000010542f5f7816ULL, 0x000fc4000000005fULL, 0x00000010ff2f7819ULL, 0x000fe4000001165bULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff5b7819ULL, 0x000fe4000001166cULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00001054695e7816ULL, 0x000fc4000000005eULL, 0x000010542f5b7816ULL, 0x000fe4000000005bULL,
0x000010546b5a7816ULL, 0x000fe4000000005aULL, 0x00000010ff737819ULL, 0x000fe20000011642ULL,
0x0000005e2810723cULL, 0x002fe20000041810ULL, 0x00000008ff2e7819ULL, 0x000fe4000001162eULL,
0x000000ff2d2d7812ULL, 0x000fe400078ec0ffULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x0000005a280c723cULL, 0x000fe2000004180cULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000056ff757230ULL, 0x000fe20000004100ULL,
0x0000002eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL,
0x20000053ff747230ULL, 0x000fe20000004100ULL, 0x0000002dff5a723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x00000073ff56723eULL, 0x000fc400020006ffULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff71737812ULL, 0x000fe200078ec0ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe40000011680ULL, 0x00000008ff717819ULL, 0x000fc40000011681ULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x0000006fff53723eULL, 0x000fe400020006ffULL, 0x0000006dff6f723eULL, 0x000fe400020006ffULL,
0x00000018ff637819ULL, 0x000fe20000011642ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x2000004cff657230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x0000004eff6d723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000051ff707230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000063ff42723eULL, 0x000fe200020006ffULL,
0x2000004aff637230ULL, 0x000fe20000004100ULL, 0x00000067ff45723eULL, 0x000fe200020006ffULL,
0x2000004bff677230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fc40000011667ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff747819ULL, 0x000fc40000011674ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165cULL,
0x2000005aff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff5f7819ULL, 0x000fe40000011661ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x000000ff77777812ULL, 0x000fe400078ec0ffULL, 0x0000105464637816ULL, 0x000fc40000000063ULL,
0x0000105468677816ULL, 0x000fe40000000067ULL, 0x0000105466667816ULL, 0x000fe40000000065ULL,
0x00001054706f7816ULL, 0x000fe2000000006fULL, 0x000000622818723cULL, 0x000fe20000041818ULL,
0x000010546d6e7816ULL, 0x000fe4000000006eULL, 0x0000105474737816ULL, 0x000fe40000000073ULL,
0x0000105471727816ULL, 0x000fc40000000072ULL, 0x00001054765b7816ULL, 0x000fe2000000005bULL,
0x000000662814723cULL, 0x040fe20000041814ULL, 0x000010545d5a7816ULL, 0x000fe40000000075ULL,
0x00001054595f7816ULL, 0x000fe4000000005fULL, 0x000010545e5e7816ULL, 0x000fe40000000060ULL,
0x00000077ff4d723eULL, 0x000fe200020006ffULL, 0x0000006e2808723cULL, 0x000fe20000041808ULL,
0x00000047ff47723eULL, 0x000fc400020006ffULL, 0x000000ff3f3f7812ULL, 0x000fe200078ec0ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000008ff407819ULL, 0x000fe20000011640ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000008ff3b7819ULL, 0x000fe2000001163bULL,
0x000000722804723cULL, 0x000fe20000041804ULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3c7819ULL, 0x000fe4000001163cULL, 0x000000ff3d3d7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff3e7819ULL, 0x000fe2000001163eULL, 0x0000005a2820723cULL, 0x040fe20000041820ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x0000005e281c723cULL, 0x000fe2000004181cULL, 0x00000078ff49723eULL, 0x000fc400020006ffULL,
0x00000079ff51723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x0000007aff4a723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe20000011656ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff2a7819ULL, 0x000fe20000011645ULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000007bff4b723eULL, 0x000fe400020006ffULL, 0x0000007cff4c723eULL, 0x000fc400020006ffULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x0000007eff50723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x0000007fff4f723eULL, 0x000fe200020006ffULL, 0x2000007dff4e7230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff457819ULL, 0x000fe2000001164dULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000003dff3d723eULL, 0x000fc400020006ffULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000105442297816ULL, 0x000fe40000000029ULL,
0x0000105455287816ULL, 0x000fe20000000041ULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x000010542a457816ULL, 0x000fe20000000045ULL, 0x2000003dff2a7230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff587819ULL, 0x000fe20000011658ULL,
0x000000282c10723cULL, 0x002fe20000041810ULL, 0x00000010ff487819ULL, 0x000fc40000011648ULL,
0x0000105447597816ULL, 0x000fe40000000058ULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff297819ULL, 0x000fe4000001163fULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff477819ULL, 0x000fc40000011653ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff417819ULL, 0x000fc4000001165cULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff3b7819ULL, 0x000fe4000001163bULL,
0x00000010ff3d7819ULL, 0x000fe4000001164cULL, 0x00000010ff3a7819ULL, 0x000fc4000001163aULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff3f7819ULL, 0x000fe40000011650ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff3e7819ULL, 0x000fc4000001163eULL,
0x0000105457587816ULL, 0x000fe40000000048ULL, 0x0000105443477816ULL, 0x000fe40000000047ULL,
0x0000105454467816ULL, 0x000fe40000000046ULL, 0x0000105452447816ULL, 0x000fe20000000044ULL,
0x000000582c18723cULL, 0x000fe20000041818ULL, 0x0000105449417816ULL, 0x000fe40000000041ULL,
0x0000105440407816ULL, 0x000fc40000000051ULL, 0x000010544a297816ULL, 0x000fe40000000029ULL,
0x000010543b287816ULL, 0x000fe2000000004bULL, 0x000000462c14723cULL, 0x040fe20000041814ULL,
0x000010543d3d7816ULL, 0x000fe4000000003aULL, 0x000010543c3c7816ULL, 0x000fe4000000004eULL,
0x000010543f3f7816ULL, 0x000fe4000000002aULL, 0x000010543e3e7816ULL, 0x000fe2000000004fULL,
0x000000442c0c723cULL, 0x040ff0000004180cULL, 0x000000402c08723cULL, 0x040ff00000041808ULL,
0x000000282c04723cULL, 0x040ff00000041804ULL, 0x0000003c2c20723cULL, 0x040ff00000041820ULL,
0x0000003e2c1c723cULL, 0x000fe2000004181cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe82000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff007224ULL, 0x000fe200078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdcf000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000032287f8cULL, 0x000fe2000c80043fULL,
0x0000001031107220ULL, 0x040fe20000410000ULL, 0x0000001131117220ULL, 0x040fe20000410000ULL,
0x00000012312e7220ULL, 0x040fe20000410000ULL, 0x0000040032007984ULL, 0x000e620000000800ULL,
0x00000013312f7220ULL, 0x040fe20000410000ULL, 0x0000001a312a7220ULL, 0x040fe20000410000ULL,
0x0000001b312b7220ULL, 0x040fe20000410000ULL, 0x0000001431147220ULL, 0x040fe20000410000ULL,
0x0000001531157220ULL, 0x040fe20000410000ULL, 0x00000016312c7220ULL, 0x040fe20000410000ULL,
0x00000017312d7220ULL, 0x040fe20000410000ULL, 0x0000000c31127220ULL, 0x040fe20000410000ULL,
0x0000000d31137220ULL, 0x040fe20000410000ULL, 0x0000001831187220ULL, 0x040fe20000410000ULL,
0x0000001931197220ULL, 0x040fe20000410000ULL, 0x0000000e31377220ULL, 0x040fe20000410000ULL,
0x0000000f31387220ULL, 0x040fe20000410000ULL, 0x0000000831087220ULL, 0x040fe20000410000ULL,
0x0000000931097220ULL, 0x040fe20000410000ULL, 0x0000000a31397220ULL, 0x040fe20000410000ULL,
0x0000000b313a7220ULL, 0x040fe20000410000ULL, 0x0000000431047220ULL, 0x040fe20000410000ULL,
0x0000000531057220ULL, 0x040fe20000410000ULL, 0x0000000631067220ULL, 0x040fe20000410000ULL,
0x0000000731077220ULL, 0x040fe20000410000ULL, 0x00000022313b7220ULL, 0x040fe20000410000ULL,
0x00000023313c7220ULL, 0x040fe20000410000ULL, 0x0000002031167220ULL, 0x040fe20000410000ULL,
0x0000002131177220ULL, 0x040fe20000410000ULL, 0x0000001c311a7220ULL, 0x040fe20000410000ULL,
0x0000001d311b7220ULL, 0x040fe20000410000ULL, 0x0000001e313d7220ULL, 0x040fe20000410000ULL,
0x0000001f313e7220ULL, 0x000fe20000410000ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0010ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0014ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0015ULL, 0x000000ffff107224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe200078e0013ULL, 0x8000000000ff7812ULL, 0x002fe20007804829ULL,
0x000000ffff1c7224ULL, 0x000fc400078e002aULL, 0x000000ffff1d7224ULL, 0x000fe400078e002bULL,
0x000000ffff1e7224ULL, 0x000fe400078e002cULL, 0x000000ffff1f7224ULL, 0x000fe400078e002dULL,
0x000000ffff207224ULL, 0x000fe400078e002eULL, 0x000000ffff217224ULL, 0x000fe400078e002fULL,
0x000000ffff0a7224ULL, 0x000fc400078e0018ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0019ULL,
0x000000ffff127224ULL, 0x000fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e0009ULL,
0x000000ffff147224ULL, 0x000fe400078e0004ULL, 0x000000ffff157224ULL, 0x000fe400078e0005ULL,
0x000000ffff227224ULL, 0x000fc400078e0037ULL, 0x000000ffff237224ULL, 0x000fe400078e0038ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0039ULL, 0x000000ffff2b7224ULL, 0x000fe400078e003aULL,
0x000000ffff2c7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0007ULL,
0x000000ffff2e7224ULL, 0x000fc400078e003bULL, 0x000000ffff2f7224ULL, 0x000fe200078e003cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff377224ULL, 0x000fe400078e003dULL, 0x000000ffff387224ULL, 0x000fe200078e003eULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x0000040032047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000426197824ULL, 0x000fe200078e00ffULL, 0x000000332400720cULL, 0x000fc80003f05270ULL,
0xfffffff019187812ULL, 0x000fca00078ec0ffULL, 0x0000008002187824ULL, 0x000fca00078e0218ULL,
0x0104000018047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000226007824ULL, 0x000fe400078e00ffULL, 0x0000000103367824ULL, 0x000fc600078e0a36ULL,
0x0000000600007812ULL, 0x000fc800078ec0ffULL, 0x0000000100087812ULL, 0x040fe400078efcffULL,
0x0000000800097812ULL, 0x000fe400078efcffULL, 0x000000360800720cULL, 0x080fe40003f26070ULL,
0x0000001000087812ULL, 0x000fe400078efcffULL, 0x000000360900720cULL, 0x080fe40003f06070ULL,
0x000000360800720cULL, 0x000fc40003fc6070ULL, 0x0000001100097812ULL, 0x040fe400078efcffULL,
0x0000001800087812ULL, 0x040fe400078efcffULL, 0x000000360000720cULL, 0x080fe40003f46070ULL,
0x000000360900720cULL, 0x080fe40003fa6070ULL, 0x000000360800720cULL, 0x000fe40003f66070ULL,
0x0000000900287812ULL, 0x000fc400078efcffULL, 0x0000001900097812ULL, 0x040fe400078efcffULL,
0x0000002000087812ULL, 0x000fe400078efcffULL, 0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL,
0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff0b0b7808ULL, 0x000fc40004800000ULL, 0x000000362800720cULL, 0x080fe40003f86070ULL,
0x000000360900720cULL, 0x080fe40003f46070ULL, 0x000000360800720cULL, 0x000fe40003f26070ULL,
0x0000002100097812ULL, 0x040fe400078efcffULL, 0x0000002800087812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000360900720cULL, 0x080fe40003f06070ULL, 0x000000360800720cULL, 0x000fe40003f86070ULL,
0x0000002900097812ULL, 0x000fc400078efcffULL, 0x0000003000087812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000360900720cULL, 0x000fc40003fc6070ULL, 0x000000360800720cULL, 0x000fe40003fa6070ULL,
0x0000003100097812ULL, 0x040fe400078efcffULL, 0x0000003800087812ULL, 0x040fe400078efcffULL,
0x0000003900007812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff23237808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000360900720cULL, 0x080fe40003f66070ULL,
0x000000360800720cULL, 0x000fc40003f46070ULL, 0x000000360000720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff37377808ULL, 0x000fc40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff38387808ULL, 0x000fe40004800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0x0000000a04047209ULL, 0x004fe20007810000ULL, 0x0000001fff367424ULL, 0x000fe200078e00ffULL,
0x0000001c05057209ULL, 0x000fe20007810000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x0000000b04047209ULL, 0x000fe40007810000ULL, 0x0000001d05057209ULL, 0x000fc40007810000ULL,
0x0000000c04047209ULL, 0x000fe40007810000ULL, 0x0000001e05057209ULL, 0x000fe40007810000ULL,
0x0000000d04047209ULL, 0x000fe40007810000ULL, 0x0000001f05057209ULL, 0x000fe40007810000ULL,
0x0000000e04047209ULL, 0x000fe40007810000ULL, 0x0000002005057209ULL, 0x000fc40007810000ULL,
0x0000000f04047209ULL, 0x000fe40007810000ULL, 0x0000002105057209ULL, 0x000fe40007810000ULL,
0x0000001004047209ULL, 0x000fe40007810000ULL, 0x0000002205057209ULL, 0x000fe40007810000ULL,
0x0000001104047209ULL, 0x000fe40007810000ULL, 0x0000002305057209ULL, 0x000fc40007810000ULL,
0x0000001204047209ULL, 0x000fe40007810000ULL, 0x0000002a05057209ULL, 0x000fe40007810000ULL,
0x0000001304047209ULL, 0x000fe40007810000ULL, 0x0000002b05057209ULL, 0x000fe40007810000ULL,
0x0000001404047209ULL, 0x000fe40007810000ULL, 0x0000002c05057209ULL, 0x000fc40007810000ULL,
0x0000001504047209ULL, 0x000fe40007810000ULL, 0x0000002d05057209ULL, 0x000fe40007810000ULL,
0x0000001604047209ULL, 0x000fe40007810000ULL, 0x0000002e05057209ULL, 0x000fe40007810000ULL,
0x0000001704047209ULL, 0x000fe40007810000ULL, 0x0000002f05057209ULL, 0x000fc40007810000ULL,
0x0000001a04047209ULL, 0x000fe40007810000ULL, 0x0000003705057209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fe40007810000ULL, 0x0000003805287209ULL, 0x000fe20007810000ULL,
0x00001b327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0004007f89ULL, 0x0004e400000e0000ULL,
0x0000000004297209ULL, 0x00cfe20007810000ULL, 0x00001b527f007947ULL, 0x000fea000b800000ULL,
0x0c401f0028007f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007057f89ULL, 0x000f2200000e0000ULL, 0x0000000028007209ULL, 0x004fc40007810000ULL,
0x0000000406067209ULL, 0x008fc60007810000ULL, 0x0c201f0000087f89ULL, 0x000ea200000e0000ULL,
0x0000000507077209ULL, 0x010fc60007810000ULL, 0x0c201f0029047f89ULL, 0x000ee800000e0000ULL,
0x0c201f0006097f89ULL, 0x000f2800000e0000ULL, 0x0c201f0007287f89ULL, 0x00026200000e0000ULL,
0x0000000800057209ULL, 0x004fe40007810000ULL, 0x0000000429047209ULL, 0x008fc40007810000ULL,
0x0000000906067209ULL, 0x010fc60007810000ULL, 0x3fb8aa3b04007820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000728077209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010800ULL, 0x0000000a00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010800ULL, 0x0000000c000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b1b007823ULL, 0x000fc80000010800ULL,
0x0000000e000c7308ULL, 0x000ff00000000800ULL, 0x00000010000e7308ULL, 0x000ff00000000800ULL,
0x0000001200107308ULL, 0x000ff00000000800ULL, 0x0000001400127308ULL, 0x000ff00000000800ULL,
0x0000001600147308ULL, 0x000ff00000000800ULL, 0x0000001a00167308ULL, 0x0003f00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b051a7820ULL, 0x002fc80000410000ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081aULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081aULL, 0x000000080b08723eULL, 0x004fe200000010ffULL,
0x0000001c00097308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b381a7823ULL, 0x000fc4000001081aULL, 0x0000001d001d7308ULL, 0x000ee20000000800ULL,
0x00000004ff1c7e24ULL, 0x004fe2000f8e00ffULL, 0x0000000a0d0a723eULL, 0x002fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x3f8000001c1c783eULL, 0x000fe400000010ffULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x000000091d09723eULL, 0x008fe200000010ffULL,
0x000000ffff1d7224ULL, 0x000fcc00078e001cULL, 0x0000000f000f7308ULL, 0x000ea20000000800ULL,
0x0000001e1f0b723eULL, 0x002fce00000010ffULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x0000000fff1f7424ULL, 0x000fe200078e00ffULL, 0x0000001c083c723cULL, 0x000fe200000418ffULL,
0x0000000c0f0c723eULL, 0x004fca00000010ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x0000000e110e723eULL, 0x002fce00000010ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x00000020210d723eULL, 0x004fce00000010ffULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x00000022230f723eULL, 0x002fce00000010ffULL, 0x0000001500157308ULL, 0x000e620000000800ULL,
0x0000001c0c3c723cULL, 0x000fe2000004183cULL, 0x000000101310723eULL, 0x004fcc00000010ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x000000121512723eULL, 0x002fe400000010ffULL, 0xfffffffc26157812ULL, 0x000fc800078ec0ffULL,
0x000000151f1f7219ULL, 0x000fe200000006ffULL, 0x0000002c002c7308ULL, 0x000fe60000000800ULL,
0x000000001f1b73a1ULL, 0x000e6200000e8000ULL, 0x000000001f0473c4ULL, 0x000ee80000004000ULL,
0x0000002d002d7308ULL, 0x000f220000000800ULL, 0x0000002a2b11723eULL, 0x004fce00000010ffULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x0000002c2d13723eULL, 0x010fce00000010ffULL,
0x0000000000007308ULL, 0x000f220000000800ULL, 0x000000051fff7c12ULL, 0x002fe2000f80401bULL,
0x0000001c103c723cULL, 0x000fe2000004183cULL, 0x000000141714723eULL, 0x004fca00000010ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x000000160016723eULL, 0x010fce00000010ffULL, 0x0000003700377308ULL, 0x000ff00000000800ULL,
0x0000001a001a7308ULL, 0x000ea20000000800ULL, 0x0000002e2f15723eULL, 0x002fe400000010ffULL,
0x000000371a17723eULL, 0x004fce00000010ffULL, 0x0000001c143c723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000167204008947ULL, 0x008fde000b800000ULL,
0x001c1fff3c1c7589ULL, 0x0002a400000e0000ULL, 0x000000001f0073a1ULL, 0x000ee200000e8000ULL,
0x000000001f0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051fff7c12ULL, 0x008fda000f804000ULL, 0x0000169204008947ULL, 0x010fea000b800000ULL,
0x001c1fff3e1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x002e6400000e0000ULL, 0x00000002ff007819ULL, 0x000fe40000011626ULL,
0x0000000c19367812ULL, 0x000fc400078ec0ffULL, 0x00000007001a7812ULL, 0x040fe200078ec0ffULL,
0x00000008001b7824ULL, 0x040fe200078e00ffULL, 0x00000000ff2b7212ULL, 0x000fe200078e33ffULL,
0x0000000800207824ULL, 0x000fe200078e00ffULL, 0x0000000326ff7812ULL, 0x000fe2000780c0ffULL,
0x00000008002c7824ULL, 0x040fe200078e00ffULL, 0x0000000800007810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81b1b7812ULL, 0x100fe400078ee21aULL, 0x0000000120217812ULL, 0x100fe200078ef61aULL,
0x00000008003a7824ULL, 0x000fe200078e00ffULL, 0x0000000220227812ULL, 0x100fe200078ef61aULL,
0x00000008002d7824ULL, 0x000fe200078e00ffULL, 0x0000000320237812ULL, 0x000fc400078ef61aULL,
0x0000000420287812ULL, 0x140fe400078ef61aULL, 0x0000000520297812ULL, 0x140fe400078ef61aULL,
0x00000006202a7812ULL, 0x000fe200078ef61aULL, 0x0000000800207824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2b7812ULL, 0x000fe400078ee22bULL, 0x00000000ff2c7212ULL, 0x000fe400078e33ffULL,
0x00000007001a7812ULL, 0x000fc400078ec0ffULL, 0x0000a00002007811ULL, 0x000fe400078e58ffULL,
0xfffffff83a3a7812ULL, 0x000fe400078ee22cULL, 0xfffffff82d2c7812ULL, 0x000fe200078ee21aULL,
0x000000101b197824ULL, 0x000fe200078e0200ULL, 0x00000001202d7812ULL, 0x000fe200078ef61aULL,
0x00000010221b7824ULL, 0x000fe200078e0200ULL, 0x00000002202e7812ULL, 0x100fe200078ef61aULL,
0x0000000136197824ULL, 0x000fe200078e0219ULL, 0x00000003202f7812ULL, 0x040fe200078ef61aULL,
0x0000001029227824ULL, 0x000fe200078e0200ULL, 0x0000000420377812ULL, 0x100fe200078ef61aULL,
0x00000001361b7824ULL, 0x000fe200078e021bULL, 0x0000000520387812ULL, 0x000fe200078ef61aULL,
0x000000102c297824ULL, 0x000fe200078e0200ULL, 0x0000000620397812ULL, 0x000fe200078ef61aULL,
0x00000010211a7824ULL, 0x100fe200078e0200ULL, 0x0000000819007388ULL, 0x0007e20000000800ULL,
0x0000001023207824ULL, 0x000fc400078e0200ULL, 0x0000001028217824ULL, 0x000fe400078e0200ULL,
0x00000001361a7824ULL, 0x000fe400078e021aULL, 0x000000102a237824ULL, 0x100fe400078e0200ULL,
0x000000102b287824ULL, 0x000fe200078e0200ULL, 0x0000000a1a007388ULL, 0x0007e20000000800ULL,
0x0000000136207824ULL, 0x040fe400078e0220ULL, 0x0000000136217824ULL, 0x000fe200078e0221ULL,
0x0000000c1b007388ULL, 0x0007e20000000800ULL, 0x000000102d2a7824ULL, 0x000fc400078e0200ULL,
0x0000000136227824ULL, 0x000fe200078e0222ULL, 0x0000000e20007388ULL, 0x0007e20000000800ULL,
0x000000102e2b7824ULL, 0x100fe400078e0200ULL, 0x0000000136237824ULL, 0x040fe200078e0223ULL,
0x0000001021007388ULL, 0x0007e20000000800ULL, 0x000000102f2c7824ULL, 0x000fe400078e0200ULL,
0x0000000136287824ULL, 0x000fe200078e0228ULL, 0x0000001222007388ULL, 0x0007e20000000800ULL,
0x00000010372d7824ULL, 0x000fc400078e0200ULL, 0x0000000136297824ULL, 0x000fe200078e0229ULL,
0x0000001423007388ULL, 0x0007e20000000800ULL, 0x00000010382e7824ULL, 0x000fe400078e0200ULL,
0x00000001362a7824ULL, 0x040fe200078e022aULL, 0x0000001628007388ULL, 0x0007e20000000800ULL,
0x00000010392f7824ULL, 0x100fe400078e0200ULL, 0x00000001362b7824ULL, 0x000fe200078e022bULL,
0x0000000929007388ULL, 0x0007e20000000800ULL, 0x000000103a007824ULL, 0x000fc400078e0200ULL,
0x00000001362c7824ULL, 0x040fe200078e022cULL, 0x0000000b2a007388ULL, 0x0007e20000000800ULL,
0x00000001362d7824ULL, 0x040fe400078e022dULL, 0x00000001362e7824ULL, 0x040fe200078e022eULL,
0x0000000d2b007388ULL, 0x0007e20000000800ULL, 0x00000001362f7824ULL, 0x040fe400078e022fULL,
0x0000000136007824ULL, 0x000fe200078e0200ULL, 0x0000000f2c007388ULL, 0x0007e80000000800ULL,
0x000000112d007388ULL, 0x0007e80000000800ULL, 0x000000132e007388ULL, 0x0007e80000000800ULL,
0x000000152f007388ULL, 0x0007e80000000800ULL, 0x0000001700007388ULL, 0x0007e80000000800ULL,
0x0100000418008388ULL, 0x0007e80000000c00ULL, 0x0102001c18008388ULL, 0x0167e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000034ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080034ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100034ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030024247a10ULL, 0x000fe20007ffe0ffULL,
0x0000180034ff7f8cULL, 0x0003e6000c80043fULL, 0x000000252400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc12000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x0001994000507802ULL, 0x000fe40000000f00ULL, 0x000012a000007944ULL, 0x012fea0003c00000ULL,
0xfffe7bc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001998000507802ULL, 0x000fe40000000f00ULL, 0x0000126000007944ULL, 0x012fea0003c00000ULL,
0xfffe7c0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x014fe200078e0040ULL,
0x000199f0005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0029ULL,
0x0000001fff557424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fc400078e00ffULL,
0x000011a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e0000ULL,
0xfffe7c2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0029ULL,
0x00019a70005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e0040ULL,
0x0000001fff557424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000112000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e0000ULL,
0xfffe7bd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0038ULL,
0x00019ae0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x000010b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff627224ULL, 0x004fe200078e0000ULL, 0xfffe7f4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0036ULL, 0x00019b50005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000104000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff617224ULL, 0x004fe200078e0000ULL,
0xfffe7f0000007947ULL, 0x000fea000383ffffULL, 0x0000001fff557424ULL, 0x000fe200078e00ffULL,
0x00019bb0005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x00000fe000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0000ULL,
0xfffe9d3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x002fe200078e0036ULL,
0x00019c20005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00000f7000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff657224ULL, 0x004fe200078e0000ULL, 0xfffe9ce000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x00019c7000507802ULL, 0x000fc40000000f00ULL,
0x00000f7000007944ULL, 0x014fea0003c00000ULL, 0xfffebab000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x00019cb000507802ULL, 0x000fc40000000f00ULL,
0x00000f3000007944ULL, 0x014fea0003c00000ULL, 0xfffebaf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x002fe200078e0000ULL, 0x00019d20005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0051ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00000e7000007944ULL, 0x014fea0003c00000ULL,
0xfffebb3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0051ULL,
0x00019d90005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0036ULL,
0x0000001fff557424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x00000e0000007944ULL, 0x012fea0003c00000ULL, 0xfffebbe000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e004fULL, 0x00019df0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x00000da000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff4f7224ULL, 0x004fe200078e0000ULL,
0xfffebe3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0036ULL,
0x00019e60005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00000d3000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff6a7224ULL, 0x004fe200078e0000ULL, 0xfffebde000007947ULL, 0x000fea000383ffffULL,
0x0000001fff557424ULL, 0x000fe200078e00ffULL, 0x00019ec0005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00000cd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff607224ULL, 0x004fe200078e0000ULL, 0xfffeda4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x002fe200078e0036ULL, 0x00019f30005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x00000c6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff617224ULL, 0x004fe200078e0000ULL,
0xfffed9f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x00019f8000507802ULL, 0x000fe40000000f00ULL, 0x00000c6000007944ULL, 0x014fea0003c00000ULL,
0xfffef74000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x00019fc000507802ULL, 0x000fe40000000f00ULL, 0x00000c2000007944ULL, 0x014fea0003c00000ULL,
0xfffef78000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x002fe200078e0000ULL,
0x0001a030005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0051ULL,
0x0000001fff557424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x014fea0003c00000ULL, 0xfffef7c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0051ULL, 0x0001a0a0005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e0036ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00000af000007944ULL, 0x012fea0003c00000ULL,
0xfffef87000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e004fULL,
0x0001a100005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00000a9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff4f7224ULL, 0x004fe200078e0000ULL, 0xfffefac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0036ULL, 0x0001a170005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fc400078e00ffULL,
0x00000a2000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff6a7224ULL, 0x004fe200078e0000ULL,
0xfffefa7000007947ULL, 0x000fea000383ffffULL, 0x0000001fff557424ULL, 0x000fe200078e00ffULL,
0x0001a1d0005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff547424ULL, 0x000fc400078e00ffULL,
0x000009c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff607224ULL, 0x004fe200078e0000ULL,
0xffff16d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x002fe200078e0036ULL,
0x0001a240005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000095000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff617224ULL, 0x004fe200078e0000ULL, 0xffff168000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x0001a29000507802ULL, 0x000fe40000000f00ULL,
0x0000095000007944ULL, 0x012fea0003c00000ULL, 0xffff33d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x0001a2d000507802ULL, 0x000fe40000000f00ULL,
0x0000091000007944ULL, 0x012fea0003c00000ULL, 0xffff341000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x004fe200078e0000ULL, 0x0001a340005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fe400078e0029ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fc400078e00ffULL, 0x0000085000007944ULL, 0x012fea0003c00000ULL,
0xffff345000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0029ULL,
0x0001a3b0005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e0036ULL,
0x0000001fff557424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x000007e000007944ULL, 0x012fea0003c00000ULL, 0xffff350000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e0039ULL, 0x0001a410005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000078000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff397224ULL, 0x004fe200078e0000ULL,
0xffff375000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0036ULL,
0x0001a480005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff4f7224ULL, 0x004fe200078e0000ULL, 0xffff370000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e002eULL, 0x0001a4f0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff557424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x000006a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0000ULL,
0xffff538000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0036ULL,
0x0001a560005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000063000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e0000ULL, 0xffff533000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e0004ULL, 0x0001a5c000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fe400078e00ffULL, 0x0000058000007944ULL, 0x002fea0003c00000ULL,
0xffffe49000007947ULL, 0x000fea000383ffffULL, 0x000000ffff007224ULL, 0x000fe200078e0028ULL,
0x0001a61000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fc400078e00ffULL,
0x0000053000007944ULL, 0x002fea0003c00000ULL, 0x0000000028057209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0006ULL, 0x0001a66000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fc400078e00ffULL, 0x000004e000007944ULL, 0x000fea0003c00000ULL,
0x0000000006067209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0007ULL,
0x0001a6b000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000000007077209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0029ULL, 0x0001a70000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000000029047209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0005ULL,
0x0001a75000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000000005057209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0006ULL, 0x0001a7a000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000000006067209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0007ULL,
0x0001a7f000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e0000ULL,
0xffffe34000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e003cULL,
0x0001a870005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff557424ULL, 0x000fe400078e00ffULL, 0x000000ffff547224ULL, 0x000fe400078e001fULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0000ULL,
0xffffe92000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e003eULL,
0x0001a8f0005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff557424ULL, 0x000fe400078e00ffULL, 0x000000ffff547224ULL, 0x000fe400078e001fULL,
0x000002a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e00ffULL,
0x0001a950005c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff557424ULL, 0x000fc400078e00ffULL,
0x000000ffff547224ULL, 0x000fe400078e001fULL, 0x000000ffff1d7224ULL, 0x004fe400078e0000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff547224ULL, 0x000fe200078e001fULL,
0x0001a9b0005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff557424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e0000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e0000ULL,
0xffffe86000007947ULL, 0x000fea000383ffffULL, 0x0180000005007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000500008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000007ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000005057812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe54c006007950ULL, 0x000fea0003c3ffffULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x0c00000800007389ULL, 0x0002a400000e0036ULL,
0x000000ffff087224ULL, 0x002fe400078e0009ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe547008007950ULL, 0x000fea0003c3ffffULL, 0x0000005400007348ULL, 0x000fe80003800000ULL,
0x0000005b5a007389ULL, 0x0002a400000e0055ULL, 0x000000ffff547224ULL, 0x002fe400078e005cULL,
0x00000000ff557424ULL, 0x000fc800078e00ffULL, 0xfffe542054007950ULL, 0x000fea0003c3ffffULL,
0x000000010000780cULL, 0x000fe20003f25070ULL, 0x00000000ff517424ULL, 0x000fe200078e00ffULL,
0x0000003e00007348ULL, 0x000ff60003800000ULL, 0x0000000000007806ULL, 0x000fc800048e0100ULL,
0x0000003e00007212ULL, 0x000fe200078ec0ffULL, 0xfffe53c050007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000003a8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000988ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a18ULL, 0x0000000000000b8cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015a4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015c8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015d8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015f8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001688ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001690ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000016a0ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x000000000001ad00ULL, 0xa100001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001c580ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001c590ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001c590ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001ca10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001688ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001aef8ULL, 0x000000000001aef8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001c580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001ca10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin_len = 117488;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
