/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000009de0ULL, 0x00000000000099a0ULL, 0x00380040005a0d5aULL, 0x0001001100400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL,
0x6d5f6c656e72656bULL, 0x756265642e006168ULL, 0x00656d6172665f67ULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x6f632e766e2e616cULL, 0x0034746e6174736eULL,
0x2e6c65722e000000ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x5f67756265642e61ULL,
0x6e2e00656d617266ULL, 0x72676c6c61632e76ULL, 0x2e766e2e00687061ULL, 0x7079746f746f7270ULL,
0x6f632e766e2e0065ULL, 0x2e30746e6174736eULL, 0x6d5f6c656e72656bULL, 0x0000000000006168ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x732e000000000000ULL, 0x0062617472747368ULL, 0x006261747274732eULL, 0x006261746d79732eULL,
0x5f6261746d79732eULL, 0x6e2e0078646e6873ULL, 0x2e006f666e692e76ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL, 0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL,
0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL, 0x6f632e766e2e0061ULL, 0x0033746e6174736eULL,
0x4d34456b00000000ULL, 0x6e2e0058414d5f33ULL, 0x6c61626f6c672e76ULL, 0x6d730074696e692eULL,
0x2e00657a69536d65ULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL, 0x79546c656e72656bULL,
0x0000000000006570ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7265746e695f5f24ULL,
0x5f245f305f6c616eULL, 0x6d735f616475635fULL, 0x725f7063725f3032ULL, 0x33665f7a74665f6eULL,
0x6170776f6c735f32ULL, 0x2e6c65722e006874ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e006369702e74ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x72656b0065707974ULL, 0x0061686d5f6c656eULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e000300000089ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000100000099ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0003000000a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e0001000000b3ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d0022000000d3ULL, 0x0000000000008550ULL,
0x0000000000000230ULL, 0x0004000300000131ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000700030000018cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d1012000001a8ULL,
0x0000000000000000ULL, 0x0000000000008780ULL, 0x00100003000001b3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x0000002cffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000855000000000ULL, 0x0000580400000000ULL,
0x0400288080810c00ULL, 0x00000000000020e8ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808e0828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808e92ULL, 0x0000001cffffffffULL,
0x0000006800000000ULL, 0x0000855000000000ULL, 0x0000023000000000ULL, 0x0000000000000000ULL,
0x0000000c00082f04ULL, 0x0008120400000050ULL, 0x0000000000000009ULL, 0x0000000900081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL, 0x0021f00000f80008ULL,
0x00000000000c1704ULL, 0x0021f00000f00007ULL, 0x00000000000c1704ULL, 0x0201f00000700006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00501b0380005003ULL, 0x000001f000043104ULL, 0xffffffff007c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000001f0007c2804ULL, 0x00002f5000002e80ULL,
0x000030b000003000ULL, 0x00005d7000003160ULL, 0x00005db000005da0ULL, 0x00005df000005dc0ULL,
0x00005e3000005e10ULL, 0x00005e7000005e40ULL, 0x00005eb000005e90ULL, 0x0000632000005ec0ULL,
0x0000638000006360ULL, 0x000063d0000063a0ULL, 0x00006410000063f0ULL, 0x0000645000006420ULL,
0x0000649000006470ULL, 0x00006bd0000064a0ULL, 0x0000036005f03904ULL, 0x0000db40000000ffULL,
0x0000039000040100ULL, 0x0000db48000000ffULL, 0x000003b000040100ULL, 0x0000db50000000ffULL,
0x000003f000040100ULL, 0x0000db58000000ffULL, 0x0000041000040100ULL, 0x0000db60000000ffULL,
0x0000043000040100ULL, 0x0000db68000000ffULL, 0x0000045000040100ULL, 0x0000db70000000ffULL,
0x0000047000040100ULL, 0x0000db78000000ffULL, 0x0000049000040100ULL, 0x0000db80000000ffULL,
0x000004b000040100ULL, 0x0000db88000000ffULL, 0x000004d000040100ULL, 0x0000db90000000ffULL,
0x000004f000040100ULL, 0x0000db98000000ffULL, 0x0000051000040100ULL, 0x0000dba0000000ffULL,
0x0000053000040100ULL, 0x0000dba8000000ffULL, 0x0000055000040100ULL, 0x0000dbb0000000ffULL,
0x0000057000040100ULL, 0x0000dbb8000000ffULL, 0x0000095000040100ULL, 0x0000db7800000009ULL,
0x00000960003f0101ULL, 0x0000db7800000009ULL, 0x00000bd0003f0109ULL, 0x0000db5800000000ULL,
0x00000c10003f0101ULL, 0x0000db5800000000ULL, 0x00000d40003f0109ULL, 0x0000db6800000000ULL,
0x00000d50003f0101ULL, 0x0000db6800000000ULL, 0x00001270003f0109ULL, 0x0000db4800000000ULL,
0x00001280003f0101ULL, 0x0000db4800000000ULL, 0x000029d0003f0109ULL, 0x0000db4000000000ULL,
0x00002a30003f0101ULL, 0x0000db7800000000ULL, 0x00002a50003f0101ULL, 0x0000db8800000000ULL,
0x00002a60003f0101ULL, 0x0000db9800000000ULL, 0x00002a70003f0101ULL, 0x0000dba800000000ULL,
0x00002aa0003f0101ULL, 0x0000dbb800000000ULL, 0x00002ab0003f0101ULL, 0x0000dbb800000000ULL,
0x00002cd0003f0109ULL, 0x0000db7000000009ULL, 0x00002d40003f0109ULL, 0x0000db900000000dULL,
0x00002d60003f0101ULL, 0x0000db900000000dULL, 0x00002e50003f0109ULL, 0x0000dbb800000000ULL,
0x00003210003f0101ULL, 0x0000dbb800000000ULL, 0x00003480003f0109ULL, 0x0000dbb800000000ULL,
0x00003590003f0101ULL, 0x0000dbb800000000ULL, 0x00003e00003f0109ULL, 0x0000dbb800000000ULL,
0x00003e20003f0101ULL, 0x0000dbb800000000ULL, 0x00004d30003f0109ULL, 0x0000dbb800000000ULL,
0x00004db0003f0101ULL, 0x0000dbb800000000ULL, 0x00004ed0003f0109ULL, 0x0000dbb800000000ULL,
0x00004ee0003f0101ULL, 0x0000dbb800000000ULL, 0x00005100003f0109ULL, 0x0000db9800000003ULL,
0x00005110003f0101ULL, 0x0000db7800000003ULL, 0x00005190003f0101ULL, 0x0000db4800000000ULL,
0x000051b0003f0101ULL, 0x0000db5800000000ULL, 0x000051c0003f0101ULL, 0x0000db6800000000ULL,
0x000051e0003f0101ULL, 0x0000dbb000000000ULL, 0x000051f0003f0101ULL, 0x0000dbb000000000ULL,
0x00005210003f0109ULL, 0x0000db4000000000ULL, 0x00005220003f0101ULL, 0x0000db4000000000ULL,
0x00005310003f0109ULL, 0x0000db5000000000ULL, 0x00005790003f0109ULL, 0x0000db5800000000ULL,
0x000057b0003f0101ULL, 0x0000db6000000000ULL, 0x00005bb0003f0109ULL, 0x0000db6800000000ULL,
0x000060f0003f0101ULL, 0x0000dbb000000000ULL, 0x00006130003f0101ULL, 0x0000dbb000000000ULL,
0x00006170003f0109ULL, 0x0000dbb000000000ULL, 0x00006180003f0101ULL, 0x0000dbb000000000ULL,
0x00006590003f0109ULL, 0x0000db9800000024ULL, 0x000065b0003f0101ULL, 0x0000db9800000024ULL,
0x00006850003f0109ULL, 0x0000db9000000024ULL, 0x00006880003f0101ULL, 0x0000db4800000000ULL,
0x00006980003f0101ULL, 0x0000db4000000000ULL, 0x00006a80003f0108ULL, 0x0000820000000000ULL,
0x00006af0003f0100ULL, 0x0000820800000000ULL, 0x00006ba0003f0100ULL, 0x0000820800000000ULL,
0x00006e00003f0101ULL, 0x0000820800000003ULL, 0x00006f000007010aULL, 0x00008200000000ffULL,
0x0000723000080107ULL, 0x0000820000000003ULL, 0x000079300007010aULL, 0x00008208000000ffULL,
0x00007d4000080101ULL, 0x000082080000004aULL, 0x00007d50003f0108ULL, 0x000082000000004aULL,
0x00007d70003f0108ULL, 0x0000db7800000009ULL, 0x00007dd0003f0109ULL, 0x0000db5800000000ULL,
0x00007e30003f0109ULL, 0x0000db6800000000ULL, 0x00007e90003f0109ULL, 0x0000db4800000000ULL,
0x00007ef0003f0109ULL, 0x0000dbb800000000ULL, 0x00007f50003f0109ULL, 0x0000db7000000009ULL,
0x00007fb0003f0109ULL, 0x0000db900000000dULL, 0x00008010003f0109ULL, 0x0000dbb800000000ULL,
0x00008070003f0109ULL, 0x0000dbb800000000ULL, 0x000080d0003f0109ULL, 0x0000dbb800000000ULL,
0x00008130003f0109ULL, 0x0000dbb800000000ULL, 0x00008190003f0109ULL, 0x0000dbb000000000ULL,
0x000081f0003f0109ULL, 0x0000db4000000000ULL, 0x00008250003f0109ULL, 0x0000db5000000000ULL,
0x000082b0003f0109ULL, 0x0000db6000000000ULL, 0x00008310003f0109ULL, 0x0000dbb000000000ULL,
0x00008370003f0109ULL, 0x0000dbb000000000ULL, 0x000083d0003f0109ULL, 0x0000db9800000024ULL,
0x00008460003f0109ULL, 0x0000820800000005ULL, 0x000084f0003f010aULL, 0x0000820000000005ULL,
0x00123803003f010aULL, 0x0000015000141c04ULL, 0x000069f000006990ULL, 0x00007d6000007d20ULL,
0x00000180000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0401001903ULL,
0x010002100000000dULL, 0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000700000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000500000002ULL, 0x0000000000000000ULL,
0x00000000000000c4ULL, 0x0000000c00000002ULL, 0x0000000000008550ULL, 0x0000000000000044ULL,
0x0000000c00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL, 0x0000000c00000002ULL,
0x0000000000000000ULL, 0x0000000043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e240000000800ULL, 0x00000000001079c3ULL, 0x000e620000002700ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0x00000004100478a5ULL, 0x002fcc000f8e0004ULL, 0x00000004ff027e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000e02027981ULL, 0x000ea2000c1e1900ULL,
0x00000000001279c3ULL, 0x000e620000002500ULL, 0x0000030000117ab9ULL, 0x000fe20000000800ULL,
0x00000000020472caULL, 0x004fda00000e0000ULL, 0x0000003f04047890ULL, 0x000fc8000fffe03fULL,
0x000000063f137899ULL, 0x000fe40008011604ULL, 0x0000007f0400788cULL, 0x000fe4000bf04070ULL,
0x000000111300728cULL, 0x000fe4000bf21070ULL, 0x000000011100788cULL, 0x000fe40008704070ULL,
0x0000001113067287ULL, 0x000fe40008800000ULL, 0x0000003f12147287ULL, 0x002fc40008000000ULL,
0x0000000106067887ULL, 0x000fc80008000000ULL, 0x000000061400728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000002300ULL, 0x0000000600007d06ULL, 0x000ea20008209000ULL,
0x0000042000007945ULL, 0x000fe20003800000ULL, 0x0000000000067919ULL, 0x000e620000002200ULL,
0x00000000004a7919ULL, 0x000eea0000002100ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x0000000706ff7212ULL, 0x002fc8000780fcffULL, 0x000000204a00780cULL, 0x008fda0000705670ULL,
0x00006600ff048b82ULL, 0x000e620000000a00ULL, 0x00000000003f7886ULL, 0x000fe20000020000ULL,
0x0000007004038810ULL, 0x002fc80007f3e0ffULL, 0x00000000030482caULL, 0x000fe200000e0000ULL,
0x000000ffff048224ULL, 0x000fe200008e0605ULL, 0x0000004a07ff7212ULL, 0x000fe2000782fe06ULL,
0x0ffffffe00037836ULL, 0x004fc60000000000ULL, 0x00000000040582caULL, 0x000fc600000e0000ULL,
0x0000000300037305ULL, 0x000e68000021f000ULL, 0x00000004ff047e24ULL, 0x000fca000f8e00ffULL,
0x00000000040482caULL, 0x000fe200000e0000ULL, 0x00000005ff057e24ULL, 0x000fca000f8e00ffULL,
0x00000000050582caULL, 0x000fda00000e0000ULL, 0x00000000040099b9ULL, 0x0003e40008040000ULL,
0x0000000000b41947ULL, 0x002fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001ffe8000087882ULL, 0x000fe20000000000ULL,
0x7ffa000000097882ULL, 0x000fe20000000000ULL, 0x001fff00000a7882ULL, 0x000fe20000000000ULL,
0x7ffc0000000b7882ULL, 0x000fe20000000000ULL, 0x001ffefe000c7882ULL, 0x000fe20000000000ULL,
0x7ffbf800000d7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x00db4008043f75b2ULL, 0x000e620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db4808043f75b2ULL, 0x0004620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x001ffe0000087882ULL, 0x004fe20000000000ULL, 0x7ff8000000097882ULL, 0x000fe20000000000ULL,
0x00db500a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db580c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db600a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db680c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db700a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db780c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db800a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db880c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db9008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00db9808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00dba008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00dba808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00dbb00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00dbb80a043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000030572caULL, 0x000fe200000e0000ULL,
0x800000063f087290ULL, 0x000fe2000fffe03fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000143f077292ULL, 0x000fe2000f8e333fULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000003f0600728cULL, 0x000fc6000bf65070ULL, 0x0000003f00047c82ULL, 0x000fe40008000000ULL,
0x00000000000c79c3ULL, 0x000fe60000002600ULL, 0x00000005080872a4ULL, 0x000fc8000f8e023fULL,
0x00000008050872a5ULL, 0x000fe4000f8e0004ULL, 0x0000001306047290ULL, 0x000fc8000fffe007ULL,
0x00000004090872a5ULL, 0x000fce000f8e003fULL, 0x0000000900057c82ULL, 0x000fe40008000000ULL,
0x0000003f05077290ULL, 0x000fe4000fffe13fULL, 0x00000000000879c3ULL, 0x000e640000008800ULL,
0x00000007060772a4ULL, 0x000fc8000f8e0204ULL, 0x000000060700728cULL, 0x000fd6000bf26070ULL,
0x0000000706071290ULL, 0x000fe4000fffe13fULL, 0x0000000105051890ULL, 0x000fe4000fffe03fULL,
0x000000060700728cULL, 0x000fc6000bf46070ULL, 0x0000040000077882ULL, 0x000fe40000000000ULL,
0x0000065408077896ULL, 0x002fcc0008000007ULL, 0x0000000105052890ULL, 0x000fe2000fffe03fULL,
0x00000007ff007e24ULL, 0x000fe2000f8e00ffULL, 0x000000063f05b292ULL, 0x000fc6000f8e333fULL,
0x000000044a4b7824ULL, 0x000fe200078e0200ULL, 0x00000048007c8947ULL, 0x000ff00003800000ULL,
0x000000010700780cULL, 0x000fe20003f05270ULL, 0x000049c000007945ULL, 0x000fd80003800000ULL,
0x0000002000988947ULL, 0x000fea0003800000ULL, 0x000000404a00780cULL, 0x000fe40003f06070ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fca000001ff00ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x000000404a00780cULL, 0x000fda0003f05270ULL,
0x0000000000d08947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fc80003f0f018ULL, 0x000000604a00780cULL, 0x000fda0000705670ULL,
0x0000004800380947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x0000660000087ab9ULL, 0x000fe20000000a00ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000007008077890ULL, 0x000fe2000ff3e03fULL, 0x00000001ff067424ULL, 0x000fc600078e00ffULL,
0x000000093f087290ULL, 0x000fe40008ffe43fULL, 0x00000007ff0c7e24ULL, 0x000fc8000f8e00ffULL,
0x00000008ff0d7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000104047811ULL, 0x002fce00078e08ffULL,
0x0000001005027824ULL, 0x040fe200078e00ffULL, 0x0000000105077812ULL, 0x000fe200078ec0ffULL,
0x00000014ff087e24ULL, 0x000fc6000f8e00ffULL, 0x0000001002037812ULL, 0x000fe200078ec0ffULL,
0x00000010070a7824ULL, 0x140fe400078e0200ULL, 0x0000440007077824ULL, 0x000fe400078e0200ULL,
0x0000000100097824ULL, 0x000fc800078e0203ULL, 0x00db7806090279a7ULL, 0x000e64000850003fULL,
0x00db7803090075a7ULL, 0x002e64000800017fULL, 0x0000007000fc8947ULL, 0x002fea0003800000ULL,
0x0000000605027c24ULL, 0x000fe2000f8e0208ULL, 0x000000000a0972caULL, 0x000fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x00000000070772caULL, 0x000fe400000e0000ULL,
0x00000000020b72caULL, 0x000fe400000e0000ULL, 0x000000000c1672caULL, 0x000fe400000e0000ULL,
0x000000000d1772caULL, 0x000fe400000e0000ULL, 0x00000000040d72caULL, 0x000fc400000e0000ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000db7009097890ULL, 0x000fe4000fffe03fULL,
0x0000440007087890ULL, 0x000fe4000fffe03fULL, 0x000000060b0b7899ULL, 0x000fd8000800063fULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x00000008160075b4ULL, 0x0003d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x0000640007087890ULL, 0x000fe2000fffe03fULL, 0x00000080000a7882ULL, 0x000fd60000000000ULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x00000008160075b4ULL, 0x0003d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x0000000105057836ULL, 0x000fca0000000000ULL,
0x0000000505007c0cULL, 0x000fda000bf06070ULL, 0xfffffffc00688947ULL, 0x001fea000383ffffULL,
0x0000004400787947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x00000044006c0947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000002700ULL, 0x00006600ff0a7b82ULL, 0x000ea20000000a00ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x0000000206067824ULL, 0x006fce00078e00ffULL, 0x00db5809000279a7ULL, 0x000e62000850003fULL,
0x00000014ff087e24ULL, 0x000fe2000f8e00ffULL, 0x000000700a047810ULL, 0x000fc60007f3e0ffULL,
0x0000000607087c24ULL, 0x000fe2000f8e0208ULL, 0x00db5803000075a7ULL, 0x002e64000800017fULL,
0x0000007000688947ULL, 0x002fee0003800000ULL, 0x000000ffff057224ULL, 0x000fe200008e060bULL,
0x00000000000872caULL, 0x000fe200000e0000ULL, 0x0000004008087824ULL, 0x000fe200078e00ffULL,
0x00000000041672caULL, 0x000fe200000e0000ULL, 0x0000000107077836ULL, 0x000fe20000000000ULL,
0x00000000051772caULL, 0x000fe200000e0000ULL, 0x0000003f000a7c82ULL, 0x000fe20008000000ULL,
0x00000000080b72caULL, 0x000fe400000e0000ULL, 0x00000000060d72caULL, 0x000fe400000e0000ULL,
0x000000000000781cULL, 0x000fc40003f0f070ULL, 0x0000000507007c0cULL, 0x000fe2000bf26070ULL,
0x0000db5008097890ULL, 0x000fd8000fffe03fULL, 0x00000000003f082fULL, 0x000fe20003840000ULL,
0x00000008160075b4ULL, 0x0003d80008018000ULL, 0x000000000000281cULL, 0x000fe4000170e170ULL,
0x000000000000781cULL, 0x000fd60003f4e170ULL, 0xfffffffd00ec0947ULL, 0x002fea000393ffffULL,
0x00db6809000279a7ULL, 0x000e64000850003fULL, 0x00db6803000075a7ULL, 0x002e64000800017fULL,
0x0000007000308947ULL, 0x002fea0003800000ULL, 0x00000000000972caULL, 0x000fe200000e0000ULL,
0x00000080000a7882ULL, 0x000fe20000000000ULL, 0x00000000041672caULL, 0x000fe400000e0000ULL,
0x00000000051772caULL, 0x000fe400000e0000ULL, 0x00000000080b72caULL, 0x000fe400000e0000ULL,
0x00000000060d72caULL, 0x000fe400000e0000ULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x0000200009087890ULL, 0x000fe4000fffe03fULL, 0x0000db6009097890ULL, 0x000fd8000fffe03fULL,
0x00000000003f082fULL, 0x000fe20003840000ULL, 0x00000008160075b4ULL, 0x0003d80008018000ULL,
0x000000000000281cULL, 0x000fe4000170e170ULL, 0x000000000000781cULL, 0x000fd60003f4e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0xfffffffc005c9947ULL, 0x001fea000383ffffULL,
0x0000004000b07947ULL, 0x000fea0003800000ULL, 0x00008800ff027b82ULL, 0x000e620000000a00ULL,
0x0000840000077ab9ULL, 0x000fe40000000800ULL, 0x00000007100772a4ULL, 0x000fcc000f8e020cULL,
0x00000007ff217e24ULL, 0x000fc8000f8e00ffULL, 0x0000020021217824ULL, 0x000fc800078e024aULL,
0x0000001021047825ULL, 0x002fcc00078e0002ULL, 0x0000000e04047981ULL, 0x000f62000c1e9d00ULL,
0x000000404a2c7836ULL, 0x000fe20000000000ULL, 0x0000035000017945ULL, 0x000fe80003800000ULL,
0x000001ff2c00780cULL, 0x000fda0003f04070ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x0000004021097836ULL, 0x000fc80000000000ULL, 0x0000001009087825ULL, 0x000fcc00078e0002ULL,
0x0000000e08087981ULL, 0x000f62000c1e9d00ULL, 0x000000804a0c7836ULL, 0x000fca0000000000ULL,
0x000001ff0c00780cULL, 0x000fda0003f24070ULL, 0x0000000000b01947ULL, 0x000fea0003800000ULL,
0x00000080210d7836ULL, 0x000fc80000000000ULL, 0x000000100d0c7825ULL, 0x000fcc00078e0002ULL,
0x0000000e0c0c7981ULL, 0x000f62000c1e9d00ULL, 0x000000c04a107836ULL, 0x000fca0000000000ULL,
0x000001ff1000780cULL, 0x000fda0003f24070ULL, 0x0000000000981947ULL, 0x000fea0003800000ULL,
0x000000c021117836ULL, 0x000fc80000000000ULL, 0x0000001011107825ULL, 0x000fcc00078e0002ULL,
0x0000000e10107981ULL, 0x000f62000c1e9d00ULL, 0x000001004a147836ULL, 0x000fca0000000000ULL,
0x000001ff1400780cULL, 0x000fda0003f24070ULL, 0x0000000000801947ULL, 0x000fea0003800000ULL,
0x0000010021157836ULL, 0x000fc80000000000ULL, 0x0000001015147825ULL, 0x000fcc00078e0002ULL,
0x0000000e14147981ULL, 0x000f62000c1e9d00ULL, 0x000001404a187836ULL, 0x000fca0000000000ULL,
0x000001ff1800780cULL, 0x000fda0003f24070ULL, 0x0000000000681947ULL, 0x000fea0003800000ULL,
0x0000014021197836ULL, 0x000fc80000000000ULL, 0x0000001019187825ULL, 0x000fcc00078e0002ULL,
0x0000000e18187981ULL, 0x000f62000c1e9d00ULL, 0x000001804a1c7836ULL, 0x000fca0000000000ULL,
0x000001ff1c00780cULL, 0x000fda0003f24070ULL, 0x0000000000501947ULL, 0x000fea0003800000ULL,
0x000001c04a1c7836ULL, 0x000fca0000000000ULL, 0x000001ff1c00780cULL, 0x000fda0003f24070ULL,
0x000001c0211d9836ULL, 0x000fc80000000000ULL, 0x000000101d1c9825ULL, 0x000fc800078e0002ULL,
0x0000018021217836ULL, 0x000fe40000000000ULL, 0x0000000e1c1c9981ULL, 0x000ea4000c1e9d00ULL,
0x0000001021207825ULL, 0x000fcc00078e0002ULL, 0x0000000e20207981ULL, 0x000f62000c1e9d00ULL,
0x000100001c249824ULL, 0x044fe200078e00ffULL, 0x000077321c029816ULL, 0x000fe200000000ffULL,
0x000100001d269824ULL, 0x040fe200078e00ffULL, 0x000077321d039816ULL, 0x000fe200000000ffULL,
0x000100001e289824ULL, 0x040fe200078e00ffULL, 0x000077321e1c9816ULL, 0x000fe200000000ffULL,
0x000100001f2a9824ULL, 0x040fe200078e00ffULL, 0x000077321f1d9816ULL, 0x000fe200000000ffULL,
0x0001000002259824ULL, 0x000fe400078e00ffULL, 0x0001000003279824ULL, 0x000fc400078e00ffULL,
0x000100001c299824ULL, 0x000fe400078e00ffULL, 0x000100001d2b9824ULL, 0x000fce00078e00ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001ff037424ULL, 0x000fe200078e00ffULL,
0x000001ff4a00780cULL, 0x000fc60003f44070ULL, 0x00db4803001c79a7ULL, 0x000e64000850003fULL,
0x00db481d000075a7ULL, 0x002e64000802017fULL, 0x0000006800fc9947ULL, 0x002fec0003800000ULL,
0x0000172000017945ULL, 0x000fe80003800000ULL, 0x0000001400c02947ULL, 0x000fea0003800000ULL,
0x0000773204027816ULL, 0x060fe200000000ffULL, 0x0001000004047824ULL, 0x000fe200078e00ffULL,
0x00000005ff1d7819ULL, 0x100fe2000001164aULL, 0x00010000051c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff1e7819ULL, 0x000fe2000001164aULL, 0x0001000002027824ULL, 0x000fe200078e00ffULL,
0x00000004ff04723eULL, 0x000fe20004807104ULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x00007732052f7816ULL, 0x000fe200000000ffULL, 0x0001000006057824ULL, 0x000fe200078e00ffULL,
0x00000002ff02723eULL, 0x000fc40004807102ULL, 0x0000001d1e1e7212ULL, 0x000fe200078e3cffULL,
0x00010000071d7824ULL, 0x040fe200078e00ffULL, 0x0000773206307816ULL, 0x000fe200000000ffULL,
0x000000ffff067224ULL, 0x000fe200078e002fULL, 0x0000773207317816ULL, 0x000fe400000000ffULL,
0x000000ff04047812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fe200078e0030ULL,
0x0000ffff022d7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee21eULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x0000001cff1e723eULL, 0x000fe2000480711eULL, 0x000000ffff1c7224ULL, 0x000fe200078e0031ULL,
0x000076042d2e7816ULL, 0x000fc40000000004ULL, 0x000000104a047812ULL, 0x000fe200078ec0ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000005ff2d723eULL, 0x000fe4000480712dULL,
0x00000004ff057819ULL, 0x000fe40000011604ULL, 0x00000006ff06723eULL, 0x000fe40004807106ULL,
0x0000001dff1d723eULL, 0x000fe2000480711dULL, 0x0000080005047824ULL, 0x000fe200078e0200ULL,
0x00000007ff07723eULL, 0x000fc40004807107ULL, 0x0000001cff1c723eULL, 0x000fe2000480711cULL,
0x000000101f1f7824ULL, 0x000fe200078e0204ULL, 0x0000ffff06057812ULL, 0x000fe400078ec0ffULL,
0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2d2d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff07067812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1c1c7812ULL, 0x000fe400078ec0ffULL, 0x000000014a027812ULL, 0x000fe400078ec0ffULL,
0x0000760405057816ULL, 0x000fe4000000001eULL, 0x00007604062d7816ULL, 0x000fe2000000002dULL,
0x00000008021f7824ULL, 0x000fe200078e021fULL, 0x000076041c1c7816ULL, 0x000fe4000000001dULL,
0x000054102e2e7816ULL, 0x000fc40000000005ULL, 0x000054102d2f7816ULL, 0x000fca000000001cULL,
0x00c8002e1f007388ULL, 0x0003e20000000a00ULL, 0x0000001000f80947ULL, 0x000fea0003800000ULL,
0x0000773208057816ULL, 0x040fe200000000ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x000077320a1e7816ULL, 0x040fe200000000ffULL, 0x000100000a077824ULL, 0x000fe200078e00ffULL,
0x00007732091d7816ULL, 0x000fe200000000ffULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000009067824ULL, 0x000fe200078e00ffULL,
0x000077320b1f7816ULL, 0x002fe400000000ffULL, 0x00000005ff0a723eULL, 0x000fc4000480710aULL,
0x000000ff08057812ULL, 0x000fe200078ec0ffULL, 0x000100000b087824ULL, 0x000fe200078e00ffULL,
0x0000ffff0a0a7812ULL, 0x000fe400078ec0ffULL, 0x00000007ff0b723eULL, 0x000fe2000480710bULL,
0x000000ffff077224ULL, 0x000fe200078e001fULL, 0x000076040a1c7816ULL, 0x000fe20000000005ULL,
0x000000ffff057224ULL, 0x000fe200078e001dULL, 0x00000006ff0a723eULL, 0x000fe2000480710aULL,
0x000000ffff067224ULL, 0x000fe200078e001eULL, 0x00000005ff097819ULL, 0x100fe2000001162cULL,
0x0001000005057824ULL, 0x000fe200078e00ffULL, 0x00000001ff2c7819ULL, 0x000fe2000001162cULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x00000008ff08723eULL, 0x000fe20004807108ULL,
0x0001000007077824ULL, 0x000fe200078e00ffULL, 0x000000092c2c7212ULL, 0x000fe200078e3cffULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x00000005ff05723eULL, 0x000fc40004807105ULL,
0x00000006ff06723eULL, 0x000fe40004807106ULL, 0x00000007ff07723eULL, 0x000fe40004807107ULL,
0xfffffff809097812ULL, 0x000fe400078ee22cULL, 0x000000ff0a0a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001009097824ULL, 0x000fe200078e0204ULL,
0x000000ff08087812ULL, 0x000fc400078ec0ffULL, 0x0000ffff05057812ULL, 0x000fe200078ec0ffULL,
0x0000000802097824ULL, 0x000fe200078e0209ULL, 0x0000ffff06067812ULL, 0x000fe400078ec0ffULL,
0x0000ffff07077812ULL, 0x000fe400078ec0ffULL, 0x0000760405057816ULL, 0x000fe4000000000aULL,
0x0000760406067816ULL, 0x000fe4000000000bULL, 0x0000760407077816ULL, 0x000fc40000000008ULL,
0x000054101c1c7816ULL, 0x000fe40000000005ULL, 0x00005410061d7816ULL, 0x000fe20000000007ULL,
0x000000804a077836ULL, 0x000fc80000000000ULL, 0x00c8001c09007388ULL, 0x0003e20000000a00ULL,
0x000001ff0700780cULL, 0x000fda0003f04070ULL, 0x0000001000380947ULL, 0x002fea0003800000ULL,
0x000077320c057816ULL, 0x040fe200000000ffULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x00000005ff087819ULL, 0x100fe20000011607ULL, 0x000100000d067824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011607ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x0000000cff0c723eULL, 0x000fe2000480710cULL, 0x00000008080a7824ULL, 0x000fe200078e00ffULL,
0x0000000809097212ULL, 0x000fe200078e3cffULL, 0x000100000e077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x000100000f087824ULL, 0x000fe200078e00ffULL,
0x000077320d0d7816ULL, 0x000fc400000000ffULL, 0x000077320e0e7816ULL, 0x000fe400000000ffULL,
0x000000ff0c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff05057812ULL, 0x000fe400078ec0ffULL,
0x000077320f0f7816ULL, 0x000fe400000000ffULL, 0xfffffff80a097812ULL, 0x000fe400078ee209ULL,
0x00007604050c7816ULL, 0x000fe2000000000cULL, 0x000000ffff057224ULL, 0x000fe200078e000dULL,
0x00000006ff0a723eULL, 0x000fe2000480710aULL, 0x000000ffff067224ULL, 0x000fe200078e000eULL,
0x00000007ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff077224ULL, 0x000fe200078e000fULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x000000ff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0000001009097824ULL, 0x000fe200078e0204ULL,
0x00000006ff06723eULL, 0x000fc40004807106ULL, 0x00000007ff07723eULL, 0x000fe20004807107ULL,
0x0000000802097824ULL, 0x000fe200078e0209ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000ffff06067812ULL, 0x000fe400078ec0ffULL,
0x0000ffff07077812ULL, 0x000fe400078ec0ffULL, 0x0000760405057816ULL, 0x000fc4000000000aULL,
0x0000760406067816ULL, 0x000fe4000000000bULL, 0x0000760407077816ULL, 0x000fe40000000008ULL,
0x000054100c0c7816ULL, 0x000fe40000000005ULL, 0x00005410060d7816ULL, 0x000fe20000000007ULL,
0x000000c04a077836ULL, 0x000fc80000000000ULL, 0x00c8000c09007388ULL, 0x0003e20000000a00ULL,
0x000001ff0700780cULL, 0x000fda0003f04070ULL, 0x0000000c00780947ULL, 0x002fea0003800000ULL,
0x0000773210057816ULL, 0x040fe200000000ffULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x00000005ff087819ULL, 0x100fe20000011607ULL, 0x0001000011067824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011607ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000010ff10723eULL, 0x000fe20004807110ULL, 0x00000008080a7824ULL, 0x000fe200078e00ffULL,
0x0000000809097212ULL, 0x000fe200078e3cffULL, 0x0001000012077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0001000013087824ULL, 0x000fe200078e00ffULL,
0x0000773211117816ULL, 0x000fc400000000ffULL, 0x0000773212127816ULL, 0x000fe400000000ffULL,
0x000000ff10107812ULL, 0x000fe400078ec0ffULL, 0x0000ffff05057812ULL, 0x000fe400078ec0ffULL,
0x0000773213137816ULL, 0x000fe400000000ffULL, 0xfffffff80a097812ULL, 0x000fe400078ee209ULL,
0x0000760405107816ULL, 0x000fe20000000010ULL, 0x000000ffff057224ULL, 0x000fe200078e0011ULL,
0x00000006ff0a723eULL, 0x000fe2000480710aULL, 0x000000ffff067224ULL, 0x000fe200078e0012ULL,
0x00000007ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff077224ULL, 0x000fe200078e0013ULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x000000ff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0000001009097824ULL, 0x000fe200078e0204ULL,
0x00000006ff06723eULL, 0x000fc40004807106ULL, 0x00000007ff07723eULL, 0x000fe20004807107ULL,
0x0000000802097824ULL, 0x000fe200078e0209ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000ffff06067812ULL, 0x000fe400078ec0ffULL,
0x0000ffff07077812ULL, 0x000fe400078ec0ffULL, 0x0000760405057816ULL, 0x000fc4000000000aULL,
0x0000760406067816ULL, 0x000fe4000000000bULL, 0x0000760407077816ULL, 0x000fe40000000008ULL,
0x0000541010107816ULL, 0x000fe40000000005ULL, 0x0000541006117816ULL, 0x000fe20000000007ULL,
0x000001004a077836ULL, 0x000fc80000000000ULL, 0x00c8001009007388ULL, 0x0003e20000000a00ULL,
0x000001ff0700780cULL, 0x000fda0003f04070ULL, 0x0000000800b80947ULL, 0x002fea0003800000ULL,
0x0000773214057816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000005ff087819ULL, 0x100fe20000011607ULL, 0x0001000015067824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011607ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000014ff14723eULL, 0x000fe20004807114ULL, 0x00000008080a7824ULL, 0x000fe200078e00ffULL,
0x0000000809097212ULL, 0x000fe200078e3cffULL, 0x0001000016077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0001000017087824ULL, 0x000fe200078e00ffULL,
0x0000773215157816ULL, 0x000fc400000000ffULL, 0x0000773216167816ULL, 0x000fe400000000ffULL,
0x000000ff14147812ULL, 0x000fe400078ec0ffULL, 0x0000ffff05057812ULL, 0x000fe400078ec0ffULL,
0x0000773217177816ULL, 0x000fe400000000ffULL, 0xfffffff80a097812ULL, 0x000fe400078ee209ULL,
0x0000760405147816ULL, 0x000fe20000000014ULL, 0x000000ffff057224ULL, 0x000fe200078e0015ULL,
0x00000006ff0a723eULL, 0x000fe2000480710aULL, 0x000000ffff067224ULL, 0x000fe200078e0016ULL,
0x00000007ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff077224ULL, 0x000fe200078e0017ULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x000000ff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0000001009097824ULL, 0x000fe200078e0204ULL,
0x00000006ff06723eULL, 0x000fc40004807106ULL, 0x00000007ff07723eULL, 0x000fe20004807107ULL,
0x0000000802097824ULL, 0x000fe200078e0209ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000ffff06067812ULL, 0x000fe400078ec0ffULL,
0x0000ffff07077812ULL, 0x000fe400078ec0ffULL, 0x0000760405057816ULL, 0x000fc4000000000aULL,
0x0000760406067816ULL, 0x000fe4000000000bULL, 0x0000760407077816ULL, 0x000fe40000000008ULL,
0x0000541014147816ULL, 0x000fe40000000005ULL, 0x0000541006157816ULL, 0x000fe20000000007ULL,
0x000001404a077836ULL, 0x000fc80000000000ULL, 0x00c8001409007388ULL, 0x0003e20000000a00ULL,
0x000001ff0700780cULL, 0x000fda0003f04070ULL, 0x0000000400f80947ULL, 0x002fea0003800000ULL,
0x0000773218057816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000005ff087819ULL, 0x100fe20000011607ULL, 0x0001000019067824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011607ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000018ff18723eULL, 0x000fe20004807118ULL, 0x00000008080a7824ULL, 0x000fe200078e00ffULL,
0x0000000809097212ULL, 0x000fe200078e3cffULL, 0x000100001a077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x000100001b087824ULL, 0x000fe200078e00ffULL,
0x0000773219197816ULL, 0x000fc400000000ffULL, 0x000077321a1a7816ULL, 0x000fe400000000ffULL,
0x000000ff18187812ULL, 0x000fe400078ec0ffULL, 0x0000ffff05057812ULL, 0x000fe400078ec0ffULL,
0x000077321b1b7816ULL, 0x000fe400000000ffULL, 0xfffffff80a097812ULL, 0x000fe400078ee209ULL,
0x0000760405187816ULL, 0x000fe20000000018ULL, 0x000000ffff057224ULL, 0x000fe200078e0019ULL,
0x00000006ff0a723eULL, 0x000fe2000480710aULL, 0x000000ffff067224ULL, 0x000fe200078e001aULL,
0x00000007ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff077224ULL, 0x000fe200078e001bULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x000000ff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0000001009097824ULL, 0x000fe200078e0204ULL,
0x00000006ff06723eULL, 0x000fc40004807106ULL, 0x00000007ff07723eULL, 0x000fe20004807107ULL,
0x0000000802097824ULL, 0x000fe200078e0209ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000ffff06067812ULL, 0x000fe400078ec0ffULL,
0x0000ffff07077812ULL, 0x000fe400078ec0ffULL, 0x0000760405057816ULL, 0x000fc4000000000aULL,
0x0000760406067816ULL, 0x000fe4000000000bULL, 0x0000760407077816ULL, 0x000fe40000000008ULL,
0x0000541018187816ULL, 0x000fe40000000005ULL, 0x0000541006197816ULL, 0x000fe20000000007ULL,
0x000001804a077836ULL, 0x000fc80000000000ULL, 0x00c8001809007388ULL, 0x0003e20000000a00ULL,
0x000001ff0700780cULL, 0x000fda0003f04070ULL, 0x0000000400380947ULL, 0x002fea0003800000ULL,
0x0000773220057816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000005ff087819ULL, 0x100fe20000011607ULL, 0x0001000021067824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011607ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000020ff20723eULL, 0x000fe20004807120ULL, 0x00000008080a7824ULL, 0x000fe200078e00ffULL,
0x0000000809097212ULL, 0x000fe200078e3cffULL, 0x0001000022077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0001000023087824ULL, 0x000fe200078e00ffULL,
0x0000773221217816ULL, 0x000fc400000000ffULL, 0x0000773222227816ULL, 0x000fe400000000ffULL,
0x000000ff20207812ULL, 0x000fe400078ec0ffULL, 0x0000ffff05057812ULL, 0x000fe400078ec0ffULL,
0x0000773223237816ULL, 0x000fe400000000ffULL, 0xfffffff80a097812ULL, 0x000fe400078ee209ULL,
0x0000760405207816ULL, 0x000fe20000000020ULL, 0x000000ffff057224ULL, 0x000fe200078e0021ULL,
0x00000006ff0a723eULL, 0x000fe2000480710aULL, 0x000000ffff067224ULL, 0x000fe200078e0022ULL,
0x00000007ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff077224ULL, 0x000fe200078e0023ULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x000000ff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0000001009097824ULL, 0x000fe200078e0204ULL,
0x00000006ff06723eULL, 0x000fc40004807106ULL, 0x00000007ff07723eULL, 0x000fe20004807107ULL,
0x0000000802097824ULL, 0x000fe200078e0209ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000ffff06067812ULL, 0x000fe400078ec0ffULL,
0x0000ffff07077812ULL, 0x000fe400078ec0ffULL, 0x0000760405057816ULL, 0x000fc4000000000aULL,
0x0000760406067816ULL, 0x000fe4000000000bULL, 0x0000760407077816ULL, 0x000fe40000000008ULL,
0x0000541020207816ULL, 0x000fe40000000005ULL, 0x0000541006217816ULL, 0x000fe20000000007ULL,
0x000001c04a067836ULL, 0x000fc80000000000ULL, 0x00c8002009007388ULL, 0x0003e20000000a00ULL,
0x000001ff0600780cULL, 0x000fda0003f04070ULL, 0x0000000000780947ULL, 0x002fea0003800000ULL,
0x00000005ff057819ULL, 0x100fe40000011606ULL, 0x00000001ff067819ULL, 0x000fe40000011606ULL,
0x0000002aff2a723eULL, 0x000fe4000480712aULL, 0x0000000506067212ULL, 0x000fe200078e3cffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x0000002bff2b723eULL, 0x000fe4000480712bULL,
0x00000024ff24723eULL, 0x000fc40004807124ULL, 0x00000025ff25723eULL, 0x000fe40004807125ULL,
0x00000026ff26723eULL, 0x000fe40004807126ULL, 0x00000027ff27723eULL, 0x000fe40004807127ULL,
0x00000028ff28723eULL, 0x000fe40004807128ULL, 0x00000029ff29723eULL, 0x000fe40004807129ULL,
0xfffffff805057812ULL, 0x000fc400078ee206ULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff2b2b7812ULL, 0x000fe200078ec0ffULL, 0x0000001005057824ULL, 0x000fe200078e0204ULL,
0x000000ff24247812ULL, 0x000fe400078ec0ffULL, 0x000000ff26267812ULL, 0x000fe200078ec0ffULL,
0x0000000802057824ULL, 0x000fe200078e0205ULL, 0x000000ff28287812ULL, 0x000fe400078ec0ffULL,
0x0000ffff27277812ULL, 0x000fc400078ec0ffULL, 0x0000ffff25257812ULL, 0x000fe400078ec0ffULL,
0x0000ffff29297812ULL, 0x000fe400078ec0ffULL, 0x000076042b2a7816ULL, 0x000fe4000000002aULL,
0x0000760427267816ULL, 0x000fe40000000026ULL, 0x0000760425257816ULL, 0x000fe40000000024ULL,
0x0000760429297816ULL, 0x000fc40000000028ULL, 0x0000541025267816ULL, 0x000fe40000000026ULL,
0x0000541029277816ULL, 0x000fca000000002aULL, 0x00c8002605007388ULL, 0x0003e40000000a00ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00db400300ff79a7ULL, 0x0005e2000850003fULL,
0x0000002400d07947ULL, 0x000fea0003800000ULL, 0x00009200ff047b82ULL, 0x000e640000000a00ULL,
0x0000000e04057981ULL, 0x002362000c1e9900ULL, 0x0000000f4a00780cULL, 0x000fe20003f04070ULL,
0x00000001ff037424ULL, 0x000fc800078e00ffULL, 0x00db780300ff79a7ULL, 0x0003f0000850003fULL,
0xff7fffffff068424ULL, 0x000fe200078e00ffULL, 0x00db880300ff79a7ULL, 0x0003e2000850003fULL,
0x00db980300ff79a7ULL, 0x0003e2000850003fULL, 0x00dba80300ff79a7ULL, 0x0003e4000850003fULL,
0x00dac0064b008388ULL, 0x0003e80000000800ULL, 0x00db00ff4b008388ULL, 0x0003e20000000800ULL,
0x00dbb803000279a7ULL, 0x000ea4000850003fULL, 0x00dbb803000075a7ULL, 0x004ea4000800017fULL,
0x0000005400088947ULL, 0x006fea0003800000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000002400840947ULL, 0x000fea0003800000ULL,
0x3b12492505057820ULL, 0x020fe20000410000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0xffffffff06157890ULL, 0x000fd8000fffe03fULL, 0x0000001002037824ULL, 0x000fe200078e00ffULL,
0x0000009000017945ULL, 0x000fe20003800000ULL, 0x00000080ff067424ULL, 0x000fc600078e00ffULL,
0x0000001003037812ULL, 0x000fca00078ec0ffULL, 0x0000000100097824ULL, 0x000fe200078e0203ULL,
0x0000000102037812ULL, 0x000fc600078ec0ffULL, 0x00db7006090679a7ULL, 0x000e64000800003fULL,
0x00000010030d7824ULL, 0x000fe200078e0200ULL, 0x00db7007090075a7ULL, 0x002e64000800017fULL,
0x0000005000988947ULL, 0x002fea0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001ff047424ULL, 0x000fe200078e00ffULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0x000000a000017945ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x00db90040d0679a7ULL, 0x0004e4000850003fULL, 0x000000ffff047224ULL, 0x004fe200078e00ffULL,
0x00db90070d0075a7ULL, 0x008ea2000802017fULL, 0x0000000f0a00780cULL, 0x002fda0003f04070ULL,
0x0000004003088824ULL, 0x100fe400078e0200ULL, 0x000000040a0e8824ULL, 0x040fe400078e0200ULL,
0x000000040a0a8824ULL, 0x000fe200078e0208ULL, 0x00000050007c9947ULL, 0x004fec0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00d800000a048984ULL, 0x000fe20000000800ULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x00dac0000e0b8984ULL, 0x000e620000000800ULL, 0x00000000000f7919ULL, 0x000ea40000000000ULL,
0x000000040f098824ULL, 0x004fe200078e0200ULL, 0x000000040b00720bULL, 0x002fc80003f3e000ULL,
0x00db000009088984ULL, 0x0002a20000000800ULL, 0x00dbb80c000679a7ULL, 0x000262000850003fULL,
0x000090000000791aULL, 0x000fce0000000000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000000000c7806ULL, 0x000fc800048e0100ULL, 0x000000ff0c00720cULL, 0x000fda0003f25270ULL,
0x0000000000d49947ULL, 0x000fea0003800000ULL, 0x800000040b0b7221ULL, 0x000fe20000010000ULL,
0x000000550cff7812ULL, 0x040fe2000782c0ffULL, 0x000000020f097824ULL, 0x000fe200078e00ffULL,
0x000000aa0cff7812ULL, 0x040fe2000784c0ffULL, 0x3fb8aa3b0b0b7820ULL, 0x000fe20000410000ULL,
0x000055000cff7812ULL, 0x040fe4000786c0ffULL, 0x0000aa000cff7812ULL, 0x000fe2000788c0ffULL,
0x0000000b000d7308ULL, 0x0002e20000000800ULL, 0x0000000609097812ULL, 0x000fca00078ec0ffULL,
0x0000000000249947ULL, 0x000fec0003800000ULL, 0x00001f090d0b7589ULL, 0x00ae6400000e0000ULL,
0x0000000b18187220ULL, 0x082fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b30307220ULL, 0x080fe20000410000ULL, 0x0000000b32327220ULL, 0x000fce0000410000ULL,
0x000000000028a947ULL, 0x000fea0003800000ULL, 0x00000001090a7836ULL, 0x000fcc0000000000ULL,
0x00001f0a0d0a7589ULL, 0x008ee400000e0000ULL, 0x0000000a19197220ULL, 0x088fe20000410000ULL,
0x0000000a1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000a21217220ULL, 0x080fe20000410000ULL,
0x0000000a23237220ULL, 0x080fe20000410000ULL, 0x0000000a29297220ULL, 0x080fe20000410000ULL,
0x0000000a2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000a31317220ULL, 0x080fe20000410000ULL,
0x0000000a33337220ULL, 0x000fce0000410000ULL, 0x000000000028b947ULL, 0x000fea0003800000ULL,
0x00000008090a7812ULL, 0x000fca00078efcffULL, 0x00001f0a0d0b7589ULL, 0x00ae6400000e0000ULL,
0x0000000b1c1c7220ULL, 0x082fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b24247220ULL, 0x080fe20000410000ULL, 0x0000000b26267220ULL, 0x080fe20000410000ULL,
0x0000000b2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000b34347220ULL, 0x080fe20000410000ULL, 0x0000000b36367220ULL, 0x000fce0000410000ULL,
0x000000000028c947ULL, 0x000fea0003800000ULL, 0x0000000909097836ULL, 0x000fca0000000000ULL,
0x00001f090d0a7589ULL, 0x008ee400000e0000ULL, 0x0000000a1d1d7220ULL, 0x088fe20000410000ULL,
0x0000000a1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000a25257220ULL, 0x080fe20000410000ULL,
0x0000000a27277220ULL, 0x080fe20000410000ULL, 0x0000000a2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000a2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000a35357220ULL, 0x080fe20000410000ULL,
0x0000000a37377220ULL, 0x000fce0000410000ULL, 0x0000000d08087220ULL, 0x00cfce0000410000ULL,
0x0000006000017945ULL, 0x000fe20003800000ULL, 0x00dbb807000075a7ULL, 0x0006e2000802017fULL,
0x0000b0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00dbb807000095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x000ee20000000000ULL,
0x00000005ff117819ULL, 0x000fe2000001164aULL, 0x000001a000017945ULL, 0x000fe60003800000ULL,
0x000000031100780cULL, 0x000fda0003f25270ULL, 0x00000000005c1947ULL, 0x000fea0003800000ULL,
0x000000ff0c00720cULL, 0x000fe20000722670ULL, 0x0000010003068824ULL, 0x140fe400078e0200ULL,
0x00000100030a8824ULL, 0x040fe400078e0200ULL, 0x0000000410098824ULL, 0x048fe200078e0206ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000100030e8824ULL, 0x040fe400078e0200ULL,
0x00000004100c8824ULL, 0x000fe200078e020aULL, 0x00000000000a7805ULL, 0x002fe2000001ff00ULL,
0x00000100030f8824ULL, 0x000fc400078e0200ULL, 0x00000004100d9824ULL, 0x040fe400078e0200ULL,
0x00000004100e8824ULL, 0x040fe400078e020eULL, 0x00000004100f8824ULL, 0x000fe200078e020fULL,
0x00dac0040d009388ULL, 0x000fe80000000800ULL, 0x00d8800009078984ULL, 0x000e680000000800ULL,
0x00d8c0000c068984ULL, 0x000ee80000000800ULL, 0x00d900000e0b8984ULL, 0x000f280000000800ULL,
0x00d940000f0a8984ULL, 0x000f620000000800ULL, 0x0000000708077221ULL, 0x006fc80000010000ULL,
0x0000000607067221ULL, 0x008fe20000010000ULL, 0x0000000410078824ULL, 0x000fc600078e0200ULL,
0x0000000b060b7221ULL, 0x010fc80000010000ULL, 0x0000000a0b0a7221ULL, 0x020fca0000010000ULL,
0x00db000a07008388ULL, 0x0003e40000000800ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001ff047424ULL, 0x000fe200078e00ffULL, 0x0000001011087212ULL, 0x0ccfe200078e3cffULL,
0x0000000810097824ULL, 0x040fe200078e00ffULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x00dbb804000679a7ULL, 0x0022a2000850003fULL, 0x00000004110f7836ULL, 0x040fe40000000000ULL,
0x00000008110e7836ULL, 0x000fe40000000000ULL, 0x00000008100d7824ULL, 0x040fe200078e00ffULL,
0x000000100f0a7212ULL, 0x080fe200078e3cffULL, 0x00000008100c7824ULL, 0x000fe200078e00ffULL,
0x000000100e0b7212ULL, 0x000fe200078e3cffULL, 0x0000440003047824ULL, 0x002fe200078e0200ULL,
0xfffffff809037812ULL, 0x000fe200078ee208ULL, 0x000000204a087824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL, 0x0000440004487836ULL, 0x000fe20000000000ULL,
0xfffffff80c0c7812ULL, 0x000fc400078ee20bULL, 0xffffe00008097812ULL, 0x000fe200078ec0ffULL,
0x000004000f087824ULL, 0x000fc800078e00ffULL, 0x00000001484c7824ULL, 0x000fe200078e0209ULL,
0xffffe000084d7812ULL, 0x000fe200078ec0ffULL, 0x00dbb807000075a7ULL, 0x004e62000800017fULL,
0x000004000e097824ULL, 0x000fe400078e00ffULL, 0x0000001003037824ULL, 0x000fe400078e024cULL,
0x00000001484d7824ULL, 0x000fe200078e024dULL, 0xffffe00009097812ULL, 0x000fe200078ec0ffULL,
0x0000004800888947ULL, 0x002fec0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00000005ff087819ULL, 0x000fe2000001164aULL,
0x0000000148497824ULL, 0x000fe400078e0209ULL, 0x000000100a107824ULL, 0x000fe200078e024dULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000000314783bULL, 0x0004e20000004200ULL,
0x0000000c08087836ULL, 0x000fc40000000000ULL, 0x000000100c0c7824ULL, 0x000fe400078e0249ULL,
0x0000040008077824ULL, 0x000fe200078e00ffULL, 0x000000001010783bULL, 0x000f220000004200ULL,
0x0000400004037836ULL, 0x004fc60000000000ULL, 0xffffe00007097812ULL, 0x000fe200078ec0ffULL,
0x0000402004047836ULL, 0x000fe20000000000ULL, 0x000001f003ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000148487824ULL, 0x000fe200078e0209ULL, 0x0003fff004047812ULL, 0x000fc800078ec0ffULL,
0x00000004ff047819ULL, 0x000fe20000011604ULL, 0x000000080d0b7824ULL, 0x002fe200078e00ffULL,
0x0000000d08067212ULL, 0x000fe400078e3cffULL, 0x000000000c0c783bULL, 0x000e640000004200ULL,
0xfffffff80b077812ULL, 0x000fe400078ee206ULL, 0x0003fff003067812ULL, 0x000fc600078ec0ffULL,
0x0000001007087824ULL, 0x000fe200078e0248ULL, 0x00000004ff067819ULL, 0x000fe40000011606ULL,
0x0000624014447816ULL, 0x108fe40000000015ULL, 0x00003f0006077812ULL, 0x000fe200078ec0ffULL,
0x000000000808783bULL, 0x000ea20000004200ULL, 0x0000735114457816ULL, 0x000fe40000000015ULL,
0x000000ff07067812ULL, 0x000fe200078ef806ULL, 0x0000040003077824ULL, 0x000fe200078e00ffULL,
0x0000624016467816ULL, 0x000fc40000000017ULL, 0x0000735116477816ULL, 0x000fe40000000017ULL,
0x000e000007077812ULL, 0x000fe200078ec0ffULL, 0x0000000000177919ULL, 0x000ee20000000000ULL,
0x0000624010407816ULL, 0x150fe40000000011ULL, 0x8000002007077812ULL, 0x000fe400078efcffULL,
0x0000735110417816ULL, 0x000fe40000000011ULL, 0x0000624012427816ULL, 0x000fc40000000013ULL,
0x0000735112437816ULL, 0x000fe40000000013ULL, 0x8000002007077807ULL, 0x000fe40000000000ULL,
0x00000005ff157819ULL, 0x100fe4000001164aULL, 0x00000005ff147819ULL, 0x000fe4000001164aULL,
0x000062400c3c7816ULL, 0x142fe4000000000dULL, 0x000073510c3d7816ULL, 0x000fc4000000000dULL,
0x000062400e3e7816ULL, 0x140fe4000000000fULL, 0x000073510e3f7816ULL, 0x000fe4000000000fULL,
0x0000624008387816ULL, 0x144fe40000000009ULL, 0x0000735108397816ULL, 0x000fe40000000009ULL,
0x000062400a3a7816ULL, 0x140fe4000000000bULL, 0x000073510a3b7816ULL, 0x000fc8000000000bULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000000060a72caULL, 0x000fe400000e0000ULL,
0x00000000070b72caULL, 0x000fda00000e0000ULL, 0x0020000844187df3ULL, 0x000fe20008700818ULL,
0x00000000060a72caULL, 0x000fe400000e0000ULL, 0x00000000070b72caULL, 0x000fda00000e0000ULL,
0x0020000840207df3ULL, 0x000fe20008700820ULL, 0x00000000060a72caULL, 0x000fe400000e0000ULL,
0x00000000070b72caULL, 0x000fda00000e0000ULL, 0x002000083c287df3ULL, 0x000fe20008700828ULL,
0x00000000060a72caULL, 0x000fe200000e0000ULL, 0x0000002017067836ULL, 0x008fe20000000000ULL,
0x00000000070b72caULL, 0x000fe200000e0000ULL, 0x0000000414177836ULL, 0x000fe40000000000ULL,
0x0000000806097824ULL, 0x000fe200078e00ffULL, 0x0000000615087212ULL, 0x0c0fe200078e3cffULL,
0x0000000814147836ULL, 0x000fe40000000000ULL, 0x0000000c15157836ULL, 0x000fe20000000000ULL,
0xfffffff809097812ULL, 0x000fe200078ee208ULL, 0x00000008060d7824ULL, 0x000fe200078e00ffULL,
0x00000006140b7212ULL, 0x080fe200078e3cffULL, 0x00000008060c7824ULL, 0x040fe200078e00ffULL,
0x0000000617087212ULL, 0x080fe200078e3cffULL, 0x0020000838307df3ULL, 0x000fe20008000830ULL,
0x0000001009147824ULL, 0x000fe200078e024cULL, 0x0000000615097212ULL, 0x000fe200078e3cffULL,
0x0000000806067824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0a7812ULL, 0x000fc400078ee208ULL,
0xfffffff80c087812ULL, 0x000fe400078ee20bULL, 0xfffffff806097812ULL, 0x000fe200078ee209ULL,
0x000000100a107824ULL, 0x000fe400078e024dULL, 0x00000010080c7824ULL, 0x000fe400078e0249ULL,
0x0000001009097824ULL, 0x000fe200078e0248ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x000000001414783bULL, 0x000e620000004200ULL, 0x00003f0004397812ULL, 0x000fc600078ec0ffULL,
0x000000001010783bULL, 0x000ea20000004200ULL, 0x000000ff39067812ULL, 0x000fc600078ef804ULL,
0x000000000c0c783bULL, 0x000ee80000004200ULL, 0x000000000908783bULL, 0x000f220000004200ULL,
0x0000624014447816ULL, 0x142fe40000000015ULL, 0x0000735114457816ULL, 0x000fe40000000015ULL,
0x0000624016467816ULL, 0x140fe40000000017ULL, 0x0000735116477816ULL, 0x000fc40000000017ULL,
0x0000624010407816ULL, 0x144fe40000000011ULL, 0x0000735110417816ULL, 0x000fe40000000011ULL,
0x0000624012427816ULL, 0x140fe40000000013ULL, 0x0000735112437816ULL, 0x000fe40000000013ULL,
0x000062400c3c7816ULL, 0x148fe4000000000dULL, 0x000073510c3d7816ULL, 0x000fc4000000000dULL,
0x000062400e3e7816ULL, 0x140fe4000000000fULL, 0x000073510e3f7816ULL, 0x000fe4000000000fULL,
0x0000624008387816ULL, 0x150fe40000000009ULL, 0x0000735108397816ULL, 0x000fe40000000009ULL,
0x000062400a3a7816ULL, 0x140fe4000000000bULL, 0x000073510a3b7816ULL, 0x000fc8000000000bULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000000060a72caULL, 0x000fe400000e0000ULL,
0x00000000070b72caULL, 0x000fda00000e0000ULL, 0x0020000844187df3ULL, 0x000fe20008700818ULL,
0x00000000060a72caULL, 0x000fe400000e0000ULL, 0x00000000070b72caULL, 0x000fda00000e0000ULL,
0x0020000840207df3ULL, 0x000fe20008700820ULL, 0x00000000060a72caULL, 0x000fe400000e0000ULL,
0x00000000070b72caULL, 0x000fda00000e0000ULL, 0x002000083c287df3ULL, 0x000fe20008700828ULL,
0x00000000060a72caULL, 0x000fe400000e0000ULL, 0x00000000070b72caULL, 0x000fda00000e0000ULL,
0x0020000838307df3ULL, 0x000fe60008000830ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0xffffffff05077890ULL, 0x000fe2000fffe03fULL, 0x0000131000017945ULL, 0x000fea0003800000ULL,
0x0000000702007c0cULL, 0x000fda000bf05270ULL, 0x0000001000b80947ULL, 0x000fea0003800000ULL,
0x00000001ff4d7424ULL, 0x000fe200078e00ffULL, 0x00000000004c7919ULL, 0x000e620000000000ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000008000027945ULL, 0x000fe20003800000ULL,
0x00dbb84d000679a7ULL, 0x000ea4000850003fULL, 0x0000000f4a00780cULL, 0x000fe20004744470ULL,
0x00dbb807000075a7ULL, 0x004ea2000802017fULL, 0x000000084c097824ULL, 0x002fca00078e00ffULL,
0x0000001809097812ULL, 0x000fca00078ec0ffULL, 0x0000000100047824ULL, 0x000fe200078e0209ULL,
0x0000004000809947ULL, 0x004fec0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00db0000040a7984ULL, 0x000e620000000a00ULL, 0x0000840000077ab9ULL, 0x000fe20000000800ULL,
0x00009000000b7ab9ULL, 0x000fe20000000800ULL, 0x00000007100d72a4ULL, 0x000fe2000f8e020cULL,
0x00dac0004b13a984ULL, 0x000fe20000000800ULL, 0x00000007110772a4ULL, 0x000fe2000f8e023fULL,
0x000002b000027945ULL, 0x000fe20003800000ULL, 0x000000110d0a72a4ULL, 0x000fe2000f8e0212ULL,
0x00db00004b12a984ULL, 0x000ea20000000800ULL, 0x0000000707077899ULL, 0x000fe4000800063fULL,
0x000000040d0d7899ULL, 0x000fe2000800063fULL, 0x00db2000040c7984ULL, 0x0002e20000000a00ULL,
0x00001fff070774a4ULL, 0x000fe2000f8e020bULL, 0x0000000aff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x0000c20000087ab9ULL, 0x000fc40000000a00ULL, 0x0000000a07077291ULL, 0x000fe2000f8f983fULL,
0x00000008ff067e24ULL, 0x000fe4000f8e00ffULL, 0x00008600000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000407077899ULL, 0x000fe2000800063fULL, 0x00000009ff077e24ULL, 0x000fe2000f8e00ffULL,
0x000002000d0a78a5ULL, 0x000fe2000f8e000aULL, 0x000000100f0fa824ULL, 0x000fe200078e024aULL,
0x00000200070878a5ULL, 0x000fc6000f8e0008ULL, 0x000000080f06a825ULL, 0x000fe200078e0006ULL,
0x0000000a08077287ULL, 0x000fe40008000000ULL, 0x0000000b090a7287ULL, 0x000fe20008000000ULL,
0x00000008ff0e7e24ULL, 0x000fe4000f8e00ffULL, 0x00000009ff117e24ULL, 0x000fe4000f8e00ffULL,
0x00000009ff0f7e24ULL, 0x000fe4000f8e00ffULL, 0x00000007ff087e24ULL, 0x000fc4000f8e00ffULL,
0x018000000a047836ULL, 0x002fe40000000000ULL, 0x0000000aff0f7e24ULL, 0x000fe4000f8e00ffULL,
0x000000ffff08a224ULL, 0x000fe200078e000eULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0fa224ULL, 0x000fe400078e0011ULL, 0x00000008ff107e24ULL, 0x000fe2000f8e00ffULL,
0x01ffffff0400780cULL, 0x000fe20003f24070ULL, 0x000000120600a986ULL, 0x0043e4000c101b0eULL,
0x000000ffff067224ULL, 0x002fc400078e0008ULL, 0x000000ffff077224ULL, 0x000fd000078e000fULL,
0x0000000000101947ULL, 0x008fea0003800000ULL, 0x00004130000e7802ULL, 0x000fce0000000f00ULL,
0x0000004400087944ULL, 0x001fea0003c00000ULL, 0x000000ffff047224ULL, 0x006fe200078e0008ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000a000f7308ULL, 0x000e640000001000ULL,
0xbf8000000a047423ULL, 0x002fc8000000000fULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x000000040f047223ULL, 0x000fce000000000fULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018000000b087836ULL, 0x000fe20000000000ULL, 0x000000d000027945ULL, 0x000fe80003800000ULL,
0x7f80000008087812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0800780cULL, 0x000fda0003f24070ULL,
0x0000000000141947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x001fe200078e000bULL,
0x00004220000e7802ULL, 0x000fce0000000f00ULL, 0x0000004000cc7944ULL, 0x000fea0003c00000ULL,
0x000000ffff3a7224ULL, 0x006fe200078e0008ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000b003a7308ULL, 0x000e640000001000ULL, 0xbf8000000b087423ULL, 0x002fc8000000003aULL,
0x800000ff080f7221ULL, 0x000fc80000010100ULL, 0x0000000f3a3a7223ULL, 0x000fce000000003aULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018000000c087836ULL, 0x000fe20000000000ULL,
0x000000d000027945ULL, 0x000fe80003800000ULL, 0x7f80000008087812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0800780cULL, 0x000fda0003f24070ULL, 0x0000000000141947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x001fe200078e000cULL, 0x00004310000e7802ULL, 0x000fce0000000f00ULL,
0x0000004000907944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x006fe200078e0008ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000c000b7308ULL, 0x000e640000001000ULL,
0xbf8000000c087423ULL, 0x002fc8000000000bULL, 0x800000ff08087221ULL, 0x000fc80000010100ULL,
0x000000080b107223ULL, 0x000fce000000000bULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018000000d087836ULL, 0x000fe20000000000ULL, 0x000000d000027945ULL, 0x000fe80003800000ULL,
0x7f80000008087812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0800780cULL, 0x000fda0003f24070ULL,
0x0000000000141947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x001fe200078e000dULL,
0x00004400000e7802ULL, 0x000fce0000000f00ULL, 0x0000004000547944ULL, 0x000fea0003c00000ULL,
0x000000ffff167224ULL, 0x006fe200078e0008ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000d00167308ULL, 0x000e640000001000ULL, 0xbf8000000d087423ULL, 0x002fc80000000016ULL,
0x800000ff080b7221ULL, 0x000fc80000010100ULL, 0x0000000b16167223ULL, 0x000fce0000000016ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000e620000000000ULL,
0x00000004050d7220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x00000005ff127819ULL, 0x000fe2000001164aULL, 0x0000001605167220ULL, 0x000fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000003a19197220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003a1b1b7220ULL, 0x000fe20000410000ULL,
0x0000001012047824ULL, 0x000fe400078e00ffULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x00000018190b723eULL, 0x000fe200000010ffULL, 0x0000000d22227220ULL, 0x000fe20000410000ULL,
0x0000001a1b3c723eULL, 0x000fe200000010ffULL, 0x00000040040c7836ULL, 0x000fc40000000000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x00000080040e7836ULL, 0x040fe20000000000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000000b0b723aULL, 0x000fe20000000000ULL,
0x000000c004047836ULL, 0x000fe20000000000ULL, 0x00000004ff117819ULL, 0x000fe2000001160cULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x000000003c3c723aULL, 0x000ea20000000000ULL,
0x00000004ff157819ULL, 0x000fe2000001160eULL, 0x0000000d30307220ULL, 0x080fe20000410000ULL,
0x00000004ff397819ULL, 0x000fe20000011604ULL, 0x0000000d32327220ULL, 0x000fe20000410000ULL,
0x00000010050d7220ULL, 0x000fe20000410000ULL, 0x000000161d1d7220ULL, 0x080fe20000410000ULL,
0x000000161f1f7220ULL, 0x000fe20000410000ULL, 0x0000003a21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x00000002ff087819ULL, 0x002fe20000011608ULL, 0x0000003a23237220ULL, 0x000fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x000fe20000410000ULL,
0x00000003120f7812ULL, 0x000fe200078e7808ULL, 0x00000008080a7836ULL, 0x041fe20000000000ULL,
0x0000000311137812ULL, 0x000fe200078e7808ULL, 0x0000001625257220ULL, 0x080fe20000410000ULL,
0x0000000315177812ULL, 0x000fe200078e7808ULL, 0x0000001008047824ULL, 0x000fe200078e020fULL,
0x00000003120f7812ULL, 0x000fe200078e780aULL, 0x0000001627277220ULL, 0x000fe20000410000ULL,
0x00000003393b7812ULL, 0x000fe200078e7808ULL, 0x0000002004047824ULL, 0x000fe200078e0203ULL,
0x0000000311117812ULL, 0x000fe200078e780aULL, 0x000000100a387824ULL, 0x040fe200078e020fULL,
0x0000000315157812ULL, 0x000fe200078e780aULL, 0x00000001090f7824ULL, 0x000fe200078e0204ULL,
0x0000000339397812ULL, 0x000fe200078e780aULL, 0x000000100a147824ULL, 0x040fe200078e0211ULL,
0x0000001e1f11723eULL, 0x000fe200000010ffULL, 0x000000100a0c7824ULL, 0x000fc400078e0215ULL,
0x0000003a29297220ULL, 0x080fe20000410000ULL, 0x000000100a047824ULL, 0x000fe200078e0239ULL,
0x000054100b0a7816ULL, 0x144fe2000000003cULL, 0x0000001008127824ULL, 0x000fe200078e0213ULL,
0x000076320b0b7816ULL, 0x000fe2000000003cULL, 0x0000003a2b2b7220ULL, 0x000fe20000410000ULL,
0x0000002038387824ULL, 0x000fe400078e0203ULL, 0x0000000d2c2c7220ULL, 0x080fe20000410000ULL,
0x000000162d2d7220ULL, 0x000fe20000410000ULL, 0x0000000a0f007388ULL, 0x0001e20000000a00ULL,
0x00000020213d723eULL, 0x000fe200000010ffULL, 0x00000010080e7824ULL, 0x000fe200078e0217ULL,
0x000000222313723eULL, 0x000fe200000010ffULL, 0x0000003a31317220ULL, 0x000fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x000000162f2f7220ULL, 0x000fe20000410000ULL,
0x00000024253e723eULL, 0x000fe200000010ffULL, 0x0000003a33337220ULL, 0x000fe20000410000ULL,
0x000000262717723eULL, 0x000fe200000010ffULL, 0x0000000d34347220ULL, 0x080fe20000410000ULL,
0x0000001635357220ULL, 0x000fe20000410000ULL, 0x0000001c1d0a723eULL, 0x001fe200000010ffULL,
0x00000001090b7824ULL, 0x000fe200078e0238ULL, 0x00000028293f723eULL, 0x000fe200000010ffULL,
0x0000002012387824ULL, 0x100fe200078e0203ULL, 0x0000002a2b39723eULL, 0x000fe200000010ffULL,
0x0000000d36367220ULL, 0x000fe20000410000ULL, 0x000000000a0a723aULL, 0x000fe20000000000ULL,
0x0000002c2d3a723eULL, 0x000fe200000010ffULL, 0x0000001637377220ULL, 0x000fe20000410000ULL,
0x000000200e3c7824ULL, 0x100fe200078e0203ULL, 0x000000001111723aULL, 0x000e220000000000ULL,
0x0000002e2f16723eULL, 0x000fe200000010ffULL, 0x000000200c407824ULL, 0x000fe200078e0203ULL,
0x000000303115723eULL, 0x000fe200000010ffULL, 0x000000003d12723aULL, 0x0003e20000000000ULL,
0x000000323310723eULL, 0x000fe200000010ffULL, 0x0000001008087824ULL, 0x000fe200078e023bULL,
0x00000034350f723eULL, 0x000fe200000010ffULL, 0x000000001313723aULL, 0x000fe20000000000ULL,
0x00000036370d723eULL, 0x000fe200000010ffULL, 0x0000002004427824ULL, 0x000fc400078e0203ULL,
0x000000003e0e723aULL, 0x000fe20000000000ULL, 0x0000002014147824ULL, 0x100fe400078e0203ULL,
0x0000002008087824ULL, 0x000fe200078e0203ULL, 0x000000001717723aULL, 0x000ea20000000000ULL,
0x0000000109387824ULL, 0x040fe400078e0238ULL, 0x0000000109147824ULL, 0x040fe200078e0214ULL,
0x000000003f0c723aULL, 0x000fe20000000000ULL, 0x00000001093c7824ULL, 0x040fe400078e023cULL,
0x0000000109407824ULL, 0x040fe200078e0240ULL, 0x000000003939723aULL, 0x000fe20000000000ULL,
0x00000001093d7824ULL, 0x042fe200078e0208ULL, 0x000054100a087816ULL, 0x141fe20000000011ULL,
0x0000000109427824ULL, 0x000fe200078e0242ULL, 0x000000003a3a723aULL, 0x000fe20000000000ULL,
0x000076320a097816ULL, 0x000fe20000000011ULL, 0x00000001ff487424ULL, 0x000fc400078e00ffULL,
0x00000000163b723aULL, 0x0004280000000000ULL, 0x000000001515723aULL, 0x000fe80000000000ULL,
0x000000001010723aULL, 0x000fe20000000000ULL, 0x000054100e167816ULL, 0x144fe40000000017ULL,
0x000076320e177816ULL, 0x000fe20000000017ULL, 0x000000000f0f723aULL, 0x000fe80000000000ULL,
0x000000000d04723aULL, 0x000e620000000000ULL, 0x000001e000027945ULL, 0x000fe60003800000ULL,
0x000000080b007388ULL, 0x0005e20000000a00ULL, 0x000054103a0a7816ULL, 0x001fc4000000003bULL,
0x0000541012087816ULL, 0x144fe40000000013ULL, 0x0000763212097816ULL, 0x000fe40000000013ULL,
0x000076323a0b7816ULL, 0x000fc6000000003bULL, 0x0000000838007388ULL, 0x0001e20000000a00ULL,
0x000054100f0e7816ULL, 0x142fe40000000004ULL, 0x000076320f0f7816ULL, 0x000fe20000000004ULL,
0x0000001614007388ULL, 0x0003e20000000a00ULL, 0x0000001f4a047812ULL, 0x000fc800078ec0ffULL,
0x00000001ff047819ULL, 0x000fe40000011604ULL, 0x000054100c387816ULL, 0x141fe40000000039ULL,
0x000076320c397816ULL, 0x000fe40000000039ULL, 0x0000541015147816ULL, 0x142fe40000000010ULL,
0x0000763215157816ULL, 0x000fe20000000010ULL, 0x000000383c007388ULL, 0x0001e80000000a00ULL,
0x0000000a40007388ULL, 0x0003e80000000a00ULL, 0x000000143d007388ULL, 0x0005e80000000a00ULL,
0x0000000e42007388ULL, 0x0005e20000000a00ULL, 0x00dbb848000879a7ULL, 0x000ee2000850003fULL,
0x00000005ff397819ULL, 0x001fe2000001164aULL, 0x000000104a387824ULL, 0x000fc600078e00ffULL,
0x0000000304047812ULL, 0x000fe400078e7839ULL, 0x00000010380b7812ULL, 0x002fc600078ec0ffULL,
0x0000001039047824ULL, 0x000fc800078e0204ULL, 0x0000002004047824ULL, 0x000fc800078e0203ULL,
0x0000000104047824ULL, 0x000fe200078e020bULL, 0x00dbb809000075a7ULL, 0x008e24000802017fULL,
0x0000003000c09947ULL, 0x005fea0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000004087984ULL, 0x000e220000000c00ULL, 0x0000020039067825ULL, 0x000fe200078e0006ULL,
0x000001f038037812ULL, 0x000fe200078ec0ffULL, 0x000000f000027945ULL, 0x000fe20003800000ULL,
0x00080000040c7984ULL, 0x000e620000000c00ULL, 0x00000001ff487424ULL, 0x000fe200078e00ffULL,
0x0000000306067210ULL, 0x000fe40007f3e0ffULL, 0x0010000004107984ULL, 0x000ea20000000c00ULL,
0x000000ff4a00720cULL, 0x000fe40004705670ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0018000004147984ULL, 0x000ee80000000c00ULL, 0x0000000806007986ULL, 0x0011e8000c101d0eULL,
0x0008000c06007986ULL, 0x0021e8000c101d0eULL, 0x0010001006007986ULL, 0x0041e8000c101d0eULL,
0x0018001406007986ULL, 0x0081e2000c101d0eULL, 0x00dbb848003879a7ULL, 0x000e64000850003fULL,
0x00dbb839000075a7ULL, 0x002e64000802017fULL, 0x00000030008c9947ULL, 0x003fea0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000000600947ULL, 0x000fea0003800000ULL,
0x0000840000077ab9ULL, 0x000fe20000000800ULL, 0x0000c00000087ab9ULL, 0x000fe20000000a00ULL,
0x00000007100772a4ULL, 0x000fe2000f8e020cULL, 0x00000015ff097e24ULL, 0x000fc6000f8e00ffULL,
0x00000004070878a5ULL, 0x000fcc000f8e0008ULL, 0x00000008ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000009ff077e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0001ec0000008000ULL,
0x0000000000007992ULL, 0x001fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000009060679a8ULL, 0x000ea800099ee1ceULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000879c3ULL, 0x000e220000008800ULL,
0x0000040000077882ULL, 0x000fc40000000000ULL, 0x0000065408077896ULL, 0x001fcc0008000007ULL,
0x00000007ff007e24ULL, 0x000fe2000f8e00ffULL, 0x0000001506007c0cULL, 0x000fc8000bf05270ULL,
0x00000001ff037807ULL, 0x000fca0000000000ULL, 0x00dbc00300007388ULL, 0x0001e80000000000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000102037812ULL, 0x041fe200078ec0ffULL,
0x0000000102027836ULL, 0x000fe40000000000ULL, 0x00000001ff047424ULL, 0x000fe400078e00ffULL,
0x0000001003037824ULL, 0x000fe200078e0200ULL, 0x0000000502007c0cULL, 0x000fc6000bf06070ULL,
0x00db980403ff79a7ULL, 0x0001e2000850003fULL, 0x00db780403ff79a7ULL, 0x0001f2000850003fULL,
0xffffffd800c88947ULL, 0x001fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001400d07947ULL, 0x000fea0003800000ULL, 0x00009200ff067b82ULL, 0x000e640000000a00ULL,
0x0000000e06067981ULL, 0x002362000c1e9900ULL, 0x0000000f4a00780cULL, 0x000fe20003f04070ULL,
0x00000001ff037424ULL, 0x000fc800078e00ffULL, 0x00db480300ff79a7ULL, 0x0003f0000850003fULL,
0xff317217ff088424ULL, 0x000fe200078e00ffULL, 0x00db580300ff79a7ULL, 0x0003e2000850003fULL,
0x00db680300ff79a7ULL, 0x0003e6000850003fULL, 0x00da80084b008388ULL, 0x0003e20000000800ULL,
0x00dbb003000479a7ULL, 0x000ea4000850003fULL, 0x00dbb005000075a7ULL, 0x004ea4000800017fULL,
0x0000002c00e08947ULL, 0x006fea0003800000ULL, 0x00db4003000479a7ULL, 0x000e64000850003fULL,
0x00db4005000075a7ULL, 0x002e64000800017fULL, 0x0000002c00ec8947ULL, 0x002fea0003800000ULL,
0x000000040600728cULL, 0x000fe2000bf24070ULL, 0x00000005ff047819ULL, 0x000fca000001164aULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000001400800947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x3d80000006067820ULL, 0x020fe20000410000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00000002ff077819ULL, 0x002fca0000011605ULL,
0x0000001004097824ULL, 0x000fce00078e0207ULL, 0x00000040ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x00db500d000a79a7ULL, 0x000e64000800003fULL, 0x00db500b000075a7ULL, 0x002e64000800017fULL,
0x0000002c00c88947ULL, 0x002fea0003800000ULL, 0x00000000000d72caULL, 0x040fe200000e0000ULL,
0x00000400000b7824ULL, 0x040fe200078e00ffULL, 0x0003fff0000a7812ULL, 0x040fe200078ec0ffULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x000003ff00ff7812ULL, 0x000fe4000780c0ffULL,
0x00000004ff0a7819ULL, 0x000fe4000001160aULL, 0x000e00000b0c7812ULL, 0x000fe400078ec0ffULL,
0x00003f000a0b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff0c0c7207ULL, 0x000fe20000000000ULL,
0x0000c8000d077890ULL, 0x000fe2000fffe03fULL, 0x000000ff0b0b7812ULL, 0x000fe400078ef80aULL,
0x400000400c0a7812ULL, 0x000fe200078efcffULL, 0x000003ff073f7892ULL, 0x000fe2000f82c03fULL,
0x000000000b0b72caULL, 0x000fe200000e0000ULL, 0x0000000a07087899ULL, 0x000fe2000800063fULL,
0x000000000a0972caULL, 0x000fe200000e0000ULL, 0x0003fff007077892ULL, 0x000fe2000f8ec03fULL,
0x00000020000a7836ULL, 0x040fe20000000000ULL, 0x000e0000080a7892ULL, 0x000fe2000f8ec03fULL,
0x00002000000c7836ULL, 0x000fe20000000000ULL, 0x000000043f087899ULL, 0x000fc40008011607ULL,
0x0000003f0a077287ULL, 0x000fe20008800000ULL, 0x0003fff00a0a7812ULL, 0x000fe200078ec0ffULL,
0x00003f00080a7892ULL, 0x000fe4000f8ec03fULL, 0x4000004007077892ULL, 0x000fe2000f8efc3fULL,
0x00000004ff0a7819ULL, 0x000fe2000001160aULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00003f000a0b7812ULL, 0x000fe200078ec0ffULL,
0x00000007000b7c82ULL, 0x000fc60008000000ULL, 0x000000ff0b0b7812ULL, 0x000fe200078ef80aULL,
0x00200000081879f3ULL, 0x000fe2000c7008ffULL, 0x0000c8200d087890ULL, 0x000fe2000fffe03fULL,
0x00000040000a7836ULL, 0x000fe20000000000ULL, 0x000000000b0b72caULL, 0x000fe400000e0000ULL,
0x0003fff008087892ULL, 0x000fe4000f8ec03fULL, 0x0003fff00a0a7812ULL, 0x000fe400078ec0ffULL,
0x000000043f087899ULL, 0x000fc40008011608ULL, 0x00000004ff0a7819ULL, 0x000fe4000001160aULL,
0x00003f00080a7892ULL, 0x000fe4000f8ec03fULL, 0x00003f000a0b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff0a0a7892ULL, 0x000fe4000f8ef808ULL, 0x000000ff0b0b7812ULL, 0x000fe200078ef80aULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fe20008000000ULL,
0x00000060000a7836ULL, 0x000fca0000000000ULL, 0x0003fff00a0a7812ULL, 0x000fc800078ec0ffULL,
0x00000004ff0a7819ULL, 0x000fe2000001160aULL, 0x00200000081879f3ULL, 0x000fe20008700818ULL,
0x0000c8400d087890ULL, 0x000fe2000fffe03fULL, 0x000000000b0b72caULL, 0x000fe400000e0000ULL,
0x00003f000a0b7812ULL, 0x000fe200078ec0ffULL, 0x0003fff008087892ULL, 0x000fc6000f8ec03fULL,
0x000000ff0b0b7812ULL, 0x000fe200078ef80aULL, 0x000000043f087899ULL, 0x000fc80008011608ULL,
0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fca0008000000ULL,
0x00200000081879f3ULL, 0x000fe20008700818ULL, 0x0000c8600d087890ULL, 0x000fe2000fffe03fULL,
0x000000000b0b72caULL, 0x000fc600000e0000ULL, 0x0003fff008087892ULL, 0x000fc8000f8ec03fULL,
0x000000043f087899ULL, 0x000fc80008011608ULL, 0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fca0008000000ULL, 0x00200000081879f3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00db580300ff79a7ULL, 0x0003e2000850003fULL,
0x00db600d000a79a7ULL, 0x000ea4000800003fULL, 0x00db600b000075a7ULL, 0x004ea4000800017fULL,
0x0000002800b88947ULL, 0x006fea0003800000ULL, 0x00000000000d72caULL, 0x000fe200000e0000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x0003fff00c0a7812ULL, 0x000fc800078ec0ffULL,
0x00000004ff0a7819ULL, 0x000fc8000001160aULL, 0x00003f000a0b7812ULL, 0x000fc600078ec0ffULL,
0x0000d0000d087890ULL, 0x000fe2000fffe03fULL, 0x000000ff0b0b7812ULL, 0x000fe200078ef80aULL,
0x00002020000a7836ULL, 0x000fe40000000000ULL, 0x0003fff008087892ULL, 0x000fe2000f8ec03fULL,
0x000000000b0b72caULL, 0x000fe400000e0000ULL, 0x0003fff00a0a7812ULL, 0x000fe200078ec0ffULL,
0x000000043f087899ULL, 0x000fc60008011608ULL, 0x00000004ff0a7819ULL, 0x000fe2000001160aULL,
0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL, 0x00003f000a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x000000ff0b0b7812ULL, 0x000fe200078ef80aULL,
0x00002040000a7836ULL, 0x000fc60000000000ULL, 0x00200000081879f3ULL, 0x000fe20008700818ULL,
0x0000d0200d087890ULL, 0x000fe2000fffe03fULL, 0x000000000b0b72caULL, 0x000fe400000e0000ULL,
0x0003fff00a0a7812ULL, 0x000fe200078ec0ffULL, 0x0003fff008087892ULL, 0x000fc6000f8ec03fULL,
0x00000004ff0a7819ULL, 0x000fe2000001160aULL, 0x000000043f087899ULL, 0x000fc60008011608ULL,
0x00003f000a0b7812ULL, 0x000fe200078ec0ffULL, 0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL,
0x000000ff0b0b7812ULL, 0x000fe200078ef80aULL, 0x000000ff0a0a7892ULL, 0x000fe2000f8ef808ULL,
0x00002060000a7836ULL, 0x000fe40000000000ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe40008000000ULL, 0x0003fff00a0a7812ULL, 0x000fc800078ec0ffULL,
0x00000004ff0a7819ULL, 0x000fe2000001160aULL, 0x00200000081879f3ULL, 0x000fe20008700818ULL,
0x0000d0400d087890ULL, 0x000fe2000fffe03fULL, 0x000000000b0b72caULL, 0x000fe400000e0000ULL,
0x00003f000a0b7812ULL, 0x000fe200078ec0ffULL, 0x0003fff008087892ULL, 0x000fc6000f8ec03fULL,
0x000000ff0b0b7812ULL, 0x000fe200078ef80aULL, 0x000000043f087899ULL, 0x000fc80008011608ULL,
0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL, 0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL,
0x0000000b00087c82ULL, 0x000fe20008000000ULL, 0x00000007000b7c82ULL, 0x000fca0008000000ULL,
0x00200000081879f3ULL, 0x000fe20008700818ULL, 0x0000d0600d087890ULL, 0x000fe2000fffe03fULL,
0x000000000b0b72caULL, 0x000fe200000e0000ULL, 0x00000014ff0b7e24ULL, 0x000fe4000f8e00ffULL,
0x0003fff008087892ULL, 0x000fe4000f8ec03fULL, 0x00000006080b7c24ULL, 0x000fe4000f8e020bULL,
0x000000043f087899ULL, 0x000fe40008011608ULL, 0x000000010b0a7836ULL, 0x000fc40000000000ULL,
0x00003f00080a7892ULL, 0x000fc6000f8ec03fULL, 0x000000130a007c0cULL, 0x000fe2000bf05270ULL,
0x000000ff0a0a7892ULL, 0x000fc6000f8ef808ULL, 0x0000000b00087c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fca0008000000ULL, 0x00200000081879f3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x00db680300ff79a7ULL, 0x0003e2000850003fULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000619197220ULL, 0x080fe20000410000ULL,
0x000000061a137220ULL, 0x080fe20000410000ULL, 0x000000061b167220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d147220ULL, 0x080fe20000410000ULL,
0x000000061e157220ULL, 0x080fe20000410000ULL, 0x000000061f1f7220ULL, 0x000fe20000410000ULL,
0x0000000000380947ULL, 0x000fec0003800000ULL, 0x000000400b0b7824ULL, 0x000fca00078e00ffULL,
0x0000000b020a7248ULL, 0x000fca0007fe0000ULL, 0x000000010a0a7824ULL, 0x000fe400078e0a0bULL,
0x00000008090b7836ULL, 0x000fc60000000000ULL, 0x0000000a0900720cULL, 0x080fe40003f06070ULL,
0x0000000a0b00720cULL, 0x000fe40003f26070ULL, 0xff7fffff14147808ULL, 0x000fe40004000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40004000000ULL, 0xff7fffff19197808ULL, 0x000fe40004000000ULL,
0xff7fffff18187808ULL, 0x000fc40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL,
0xff7fffff15157808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0xff7fffff13137808ULL, 0x000fce0004800000ULL, 0x00000018130a7209ULL, 0x000fe40007810000ULL,
0x00000019160c7209ULL, 0x000fe40007810000ULL, 0x0000001c150e7209ULL, 0x000fe20007810000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0e001f000a0b7f89ULL, 0x000ea200000e0000ULL,
0x000000141f107209ULL, 0x000fc40007810000ULL, 0x000000030500780cULL, 0x000fe20003f04070ULL,
0x0e001f000c0d7f89ULL, 0x000ee800000e0000ULL, 0x0e001f000e0f7f89ULL, 0x000f2800000e0000ULL,
0x0e001f0010117f89ULL, 0x000f6200000e0000ULL, 0x0000000b0a0b7209ULL, 0x004fc40007810000ULL,
0x0000000d0c0d7209ULL, 0x008fc60007810000ULL, 0x0d001f000b127f89ULL, 0x000ea200000e0000ULL,
0x0000000f0e0f7209ULL, 0x010fc60007810000ULL, 0x0d001f000d1a7f89ULL, 0x000ee200000e0000ULL,
0x0000001110117209ULL, 0x020fc60007810000ULL, 0x0d001f000f1e7f89ULL, 0x000f2800000e0000ULL,
0x0d001f00110a7f89ULL, 0x000f6200000e0000ULL, 0x000000120b127209ULL, 0x004fe40007810000ULL,
0x0000001a0d1a7209ULL, 0x008fc60007810000ULL, 0x0c801f0012177f89ULL, 0x000ea200000e0000ULL,
0x0000001e0f1e7209ULL, 0x010fc60007810000ULL, 0x0c801f001a1b7f89ULL, 0x000ee200000e0000ULL,
0x0000000a110a7209ULL, 0x020fc60007810000ULL, 0x0c801f001e1d7f89ULL, 0x000f2800000e0000ULL,
0x0c801f000a0b7f89ULL, 0x000f6200000e0000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x0000001712177209ULL, 0x004fe40007810000ULL, 0x0000001b1a1b7209ULL, 0x008fe40007810000ULL,
0x0000001d1e1d7209ULL, 0x010fc40007810000ULL, 0x0000000b0a0b7209ULL, 0x020fe20007810000ULL,
0x00000000006c0947ULL, 0x000fec0003800000ULL, 0x000000ff1700720bULL, 0x000fe20003f36000ULL,
0x0000006000017945ULL, 0x000fe20003800000ULL, 0x00000008050a7824ULL, 0x000fd600078e0200ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x00da80170aff738cULL, 0x0005e20001000200ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x00da80170aff738cULL, 0x0005e40000800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff1b00720bULL, 0x000fe20003f36000ULL,
0x0000005000017945ULL, 0x000fd80003800000ULL, 0x0000000000089947ULL, 0x000fea0003800000ULL,
0x00da841b0aff738cULL, 0x0007e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x00da841b0aff738cULL, 0x0007e40000800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff1d00720bULL, 0x000fe20003f36000ULL, 0x0000005000017945ULL, 0x000fd80003800000ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x00daa01d0aff738cULL, 0x0009e20001000200ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x00daa01d0aff738cULL, 0x0009e40000800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff0b00720bULL, 0x000fda0003f36000ULL,
0x0000000000089947ULL, 0x000fea0003800000ULL, 0x00daa40b0aff738cULL, 0x0003e20001000200ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x00daa40b0aff738cULL, 0x0003e40000800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00dbb003000a79a7ULL, 0x01ee62000850003fULL,
0x0000000805107824ULL, 0x000fca00078e00ffULL, 0x00000018100d7812ULL, 0x000fca00078ec0ffULL,
0x0000000100177824ULL, 0x000fe200078e020dULL, 0x00dbb00b000075a7ULL, 0x002e64000802017fULL,
0x0000002000709947ULL, 0x002fea0003800000ULL, 0x00da8000170a7984ULL, 0x000e680000000a00ULL,
0x00daa000170c7984ULL, 0x000ea20000000a00ULL, 0x00dbb003000e79a7ULL, 0x000ee4000850003fULL,
0x00dbb00f000075a7ULL, 0x008ee2000802017fULL, 0x3fb8aa3b0a127820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b0c177820ULL, 0x004fc60000410000ULL, 0x3fb8aa3b18117823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b13127823ULL, 0x000fe20000010812ULL, 0x3fb8aa3b0b137820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010817ULL, 0x3fb8aa3b15157823ULL, 0x000fe20000010817ULL,
0x3fb8aa3b0d177820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b16137823ULL, 0x000fe20000010813ULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010817ULL, 0x3fb8aa3b1f177823ULL, 0x000fcc0000010817ULL,
0x0000001200127308ULL, 0x000e700000000800ULL, 0x0000001900197308ULL, 0x000ff00000000800ULL,
0x0000001300167308ULL, 0x0002b00000000800ULL, 0x0000001c001c7308ULL, 0x000f220000000800ULL,
0x0000001211137221ULL, 0x002fc20000010000ULL, 0x0000001619187221ULL, 0x004fcc0000010000ULL,
0x0000001500157308ULL, 0x000f300000000800ULL, 0x0000001400147308ULL, 0x000eb00000000800ULL,
0x0000001700177308ULL, 0x000e220000000800ULL, 0x00000020001c9947ULL, 0x018fea0003800000ULL,
0x000000151c0e7221ULL, 0x000fe20000010000ULL, 0x00000017140f7221ULL, 0x005fc20000010000ULL,
0x0e001f00131a7f89ULL, 0x000e2200000e0000ULL, 0x0000000f0500780cULL, 0x000fe20003f24070ULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x0000000108257812ULL, 0x000fe200078ec0ffULL,
0x0e001f00181b7f89ULL, 0x000e6200000e0000ULL, 0x000000ffff217224ULL, 0x000fc600078e00ffULL,
0x0e001f000e1d7f89ULL, 0x000ea200000e0000ULL, 0x0000001025247824ULL, 0x000fc600078e0200ULL,
0x0e001f000f1e7f89ULL, 0x000ee200000e0000ULL, 0x0000001a131a7221ULL, 0x001fc20000010000ULL,
0x0000001b181b7221ULL, 0x002fc80000010000ULL, 0x0d001f001a1f7f89ULL, 0x000e2200000e0000ULL,
0x0000001d0e1d7221ULL, 0x004fc60000010000ULL, 0x0d001f001b207f89ULL, 0x000e6200000e0000ULL,
0x0000001e0f1e7221ULL, 0x008fc60000010000ULL, 0x0d001f001d227f89ULL, 0x000ea800000e0000ULL,
0x0d001f001e137f89ULL, 0x000ee200000e0000ULL, 0x0000001f1a1f7221ULL, 0x001fc20000010000ULL,
0x000000201b207221ULL, 0x002fc80000010000ULL, 0x0c801f001f187f89ULL, 0x00006200000e0000ULL,
0x000000221d227221ULL, 0x004fc60000010000ULL, 0x0c801f00201b7f89ULL, 0x0000a200000e0000ULL,
0x000000131e137221ULL, 0x008fc60000010000ULL, 0x0c801f00221d7f89ULL, 0x0000e800000e0000ULL,
0x0c801f00131a7f89ULL, 0x00012200000e0000ULL, 0x0000000000301947ULL, 0x000fea0003800000ULL,
0x00000000000779c3ULL, 0x000f620000003000ULL, 0x00000007050e7812ULL, 0x000fe400078ec0ffULL,
0x3ffffffc07217812ULL, 0x000fe400078ec0ffULL, 0x000000080e0f7812ULL, 0x000fc600078ef805ULL,
0x0000000121217824ULL, 0x000fe200078e0204ULL, 0x00000001ff0e7819ULL, 0x000fc8000001160fULL,
0x00000003211e7812ULL, 0x000fca00078e780eULL, 0x000000040f0f7824ULL, 0x000fe400078e021eULL,
0x0000000700237c36ULL, 0x020fc80008000000ULL, 0x00004400250e7824ULL, 0x000fc800078e0223ULL,
0x000000100f0e7824ULL, 0x000fc800078e020eULL, 0x000040000e217836ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00db9803240e79a7ULL, 0x000f62000850003fULL,
0x0000003000007945ULL, 0x000fe20003800000ULL, 0x00db980f240075a7ULL, 0x020f66000802017fULL,
0x0000001c00809947ULL, 0x020fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000779c3ULL, 0x000f620000003000ULL, 0x43e0000019197820ULL, 0x000fe20000410000ULL,
0x43e0000016167820ULL, 0x000fe20000410000ULL, 0x43e000001c1c7820ULL, 0x000fe20000410000ULL,
0x43e0000015157820ULL, 0x000fe20000410000ULL, 0x43e0000014147820ULL, 0x000fe20000410000ULL,
0x43e0000017177820ULL, 0x000fe20000410000ULL, 0x43e0000011117820ULL, 0x000fe20000410000ULL,
0x43e0000012127820ULL, 0x000fe20000410000ULL, 0x000000191616723eULL, 0x000fe20004807116ULL,
0x000000181f187221ULL, 0x002fc20000010000ULL, 0x0000001c1515723eULL, 0x000fe20004807115ULL,
0x0000001b201b7221ULL, 0x004fc20000010000ULL, 0x000000141717723eULL, 0x000fe20004807117ULL,
0x0000001d221d7221ULL, 0x008fc20000010000ULL, 0x000000111216723eULL, 0x000fe20004807016ULL,
0x0000001a131a7221ULL, 0x010fc20000010000ULL, 0x0000541015177816ULL, 0x000fe20000000017ULL,
0x80000007210e7c36ULL, 0x020fe20008000000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000160e007844ULL, 0x0005e20000004100ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000380947ULL, 0x004fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe20003f05270ULL,
0x0000010025117824ULL, 0x140fe400078e0200ULL, 0x00000040250f7824ULL, 0x000fe400078e0200ULL,
0x00000040040e7824ULL, 0x002fe400078e0211ULL, 0x00000001100f7824ULL, 0x000fe400078e020fULL,
0x00000008050e7824ULL, 0x000fc800078e020eULL, 0x00d8000a0f008388ULL, 0x0003e80000000800ULL,
0x00d880180e007388ULL, 0x0003e80000000800ULL, 0x00d8040b0f008388ULL, 0x0003e80000000800ULL,
0x00d8841b0e007388ULL, 0x0003e80000000800ULL, 0x00d8200c0f008388ULL, 0x0003e80000000800ULL,
0x00d8a01d0e007388ULL, 0x0003e80000000800ULL, 0x00d8240d0f008388ULL, 0x0003e80000000800ULL,
0x00d8a41a0e007388ULL, 0x0003e40000000800ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fe20000000000ULL, 0x00db900324ff79a7ULL, 0x0005e8000850003fULL,
0x0000000508007c0cULL, 0x000fda000bf06070ULL, 0xffffffe800948947ULL, 0x007fea000383ffffULL,
0x00db480300ff79a7ULL, 0x0003e4000850003fULL, 0x0000000000027919ULL, 0x000ee20000002300ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000783f077890ULL, 0x000fe2000ff3e03fULL, 0x000000000000781cULL, 0x000fc60003f2f008ULL,
0x0000003f3f087290ULL, 0x000fe20008ffe43fULL, 0x0000010000097ab9ULL, 0x000fe20000000800ULL,
0x0000000000057919ULL, 0x022ee40000002200ULL, 0x0000000307077899ULL, 0x000fc60008001208ULL,
0x0000000000087ab9ULL, 0x000fe20000000800ULL, 0x0000000107077890ULL, 0x000fe2000fffe03fULL,
0x0000000902037c24ULL, 0x00cfc8000f8e0205ULL, 0x0000000803037c24ULL, 0x000fca000f8e024aULL,
0x0000000703007c0cULL, 0x000fda000bf06070ULL, 0x0000000803008824ULL, 0x000fc800078e0200ULL,
0x00db4000000089b1ULL, 0x0002a4000800003fULL, 0x000000000000994dULL, 0x004fea0003800000ULL,
0x00000000000879c3ULL, 0x000ee20000008800ULL, 0x0000040000077882ULL, 0x000fe40000000000ULL,
0x0000065408077896ULL, 0x008fd20008000007ULL, 0x00dbc007ff007984ULL, 0x006e640008000000ULL,
0x000000ff0000720cULL, 0x002fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000205ff7212ULL, 0x000fc8000784fcffULL,
0x000000044a00780cULL, 0x000fda0005741070ULL, 0x00000000005ca947ULL, 0x000fea0003800000ULL,
0x000000074a007c11ULL, 0x000fe2000f8e20ffULL, 0x001ffffe00047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x7ffff80000057882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x00000000000812caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00820004083f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001ffe0000047882ULL, 0x002fe20000000000ULL,
0x7ff8000000057882ULL, 0x000fd60000000000ULL, 0x00000000000812caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00820804083f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x00000100ff057424ULL, 0x000fc800078e00ffULL,
0x0082080500ff79a7ULL, 0x0045e6000850003fULL, 0x00000005ff037819ULL, 0x000fe20000011603ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001fff03037589ULL, 0x000ee400000e0000ULL,
0x00000000030572caULL, 0x00afe200000e0000ULL, 0x0000000000007b1dULL, 0x000fd80000010000ULL,
0x000000080500788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000400108947ULL, 0x000fea0003800000ULL, 0x0000000b05067890ULL, 0x000fc8000fffe106ULL,
0x000000023f067899ULL, 0x000fcc0008011606ULL, 0x00000006ff007c0cULL, 0x000fda000bf05270ULL,
0x0000001000288947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000900000097ab9ULL, 0x000fe20000000800ULL,
0x00000004110872a4ULL, 0x000fe4000f8e023fULL, 0x00000004100472a4ULL, 0x000fe4000f8e020cULL,
0x0000000708087899ULL, 0x000fe4000800063fULL, 0xfffffff8050a7890ULL, 0x000fe4000fffe03fULL,
0x00000011040572a4ULL, 0x000fc4000f8e023fULL, 0x00001fff081274a4ULL, 0x000fe2000f8e0209ULL,
0x0000003f00047c82ULL, 0x000fd60008000000ULL, 0x0000000a04087291ULL, 0x000fe2000f8e103fULL,
0x0000000f0700780cULL, 0x042fe20003f64070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x000000ff0700720cULL, 0x000fe20003f25270ULL, 0x0000000408097892ULL, 0x000fe4000f8ec03fULL,
0x00000004080b7899ULL, 0x000fe4000800063fULL, 0x000000023f097899ULL, 0x000fe40008011609ULL,
0x000000300b0b7892ULL, 0x000fc4000f8ec03fULL, 0x0000001f09097899ULL, 0x000fe4000800063fULL,
0x000000060400728cULL, 0x000fe4000bf06070ULL, 0x0000000bff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000805137290ULL, 0x000fe2000fffe03fULL, 0x00000009ff007e24ULL, 0x004fe2000f8e00ffULL,
0x00000003080d7892ULL, 0x000fe4000f8ec03fULL, 0x0000000b070b7290ULL, 0x000fe4000fffe03fULL,
0x00820800030075a7ULL, 0x000e640008000147ULL, 0x0000001400848947ULL, 0x002ff00003800000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x0000000000443947ULL, 0x000fea0003800000ULL,
0x0000c20000087ab9ULL, 0x000fe20000000a00ULL, 0x000000070d0b7291ULL, 0x000fe4000f8e383fULL,
0x00000080130878a5ULL, 0x000fc8000f8e0008ULL, 0x0000000b07057c11ULL, 0x040fe4000f8e18ffULL,
0x00000008ff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000070d087291ULL, 0x000fe2000f8e203fULL,
0x00000009ff037e24ULL, 0x000fe4000f8e00ffULL, 0x0000000807027825ULL, 0x000fca00078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0800000002057faeULL, 0x0003e2000b921a4eULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000820008087890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200408ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a88ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000d000007945ULL, 0x000fe80003800000ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x00000013120b7291ULL, 0x000fe2000f8f983fULL, 0x00002000ff007424ULL, 0x000fe200078e00ffULL,
0x000000070d167291ULL, 0x000fe2000f8e203fULL, 0x0000c20000087ab9ULL, 0x000fe20000000a00ULL,
0x000000070d147291ULL, 0x000fe4000f8e683fULL, 0x000020000b0878a5ULL, 0x000fe4000f8e0008ULL,
0x0000820016157890ULL, 0x000fe2000fffe03fULL, 0x00000200000b7882ULL, 0x000fd00000000000ULL,
0x00000014080073baULL, 0x0003e2000800020bULL, 0x00820000ffff79a7ULL, 0x0003e40008000016ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0xfffffffc002c8947ULL, 0x001fea000383ffffULL,
0x0000000c00287947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000e620000000000ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800308947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0xff317217ff1a7424ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x004fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0xff317217ff187424ULL, 0x000fe200078e00ffULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fc4000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000003f00047c82ULL, 0x000fcc0008000000ULL,
0x0000000404087892ULL, 0x000fe4000f8ec03fULL, 0x0000000404097899ULL, 0x000fe4000800063fULL,
0x000000023f087899ULL, 0x000fe40008011608ULL, 0x0000003009097892ULL, 0x000fe4000f8ec03fULL,
0x0000001f080b7899ULL, 0x000fe4000800063fULL, 0x00000003040d7892ULL, 0x000fc4000f8ec03fULL,
0x00000009ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000907097290ULL, 0x000fe2000fffe03fULL,
0x0000000bff027e24ULL, 0x000fe2000f8e00ffULL, 0x000000070d0a7291ULL, 0x000fe4000f8e683fULL,
0x000000070d087291ULL, 0x000fe4000f8e383fULL, 0x00820002030075a7ULL, 0x000ea20008000147ULL,
0x0000000a050a7291ULL, 0x000fe4000f8e483fULL, 0x0000000805087291ULL, 0x000fc8000f8e183fULL,
0x0000000a0e207c11ULL, 0x002fe2000f8e20ffULL, 0x0000001000908947ULL, 0x004fee0003800000ULL,
0x00800008ff027984ULL, 0x000e620008000a00ULL, 0x0000000104047890ULL, 0x000fc6000fffe03fULL,
0x0000000020047984ULL, 0x000ea20000000c00ULL, 0x000000060400728cULL, 0x000fe2000bf06070ULL,
0x000000180300720bULL, 0x002fe40003f14000ULL, 0x00007632041c7816ULL, 0x044fe2000000001cULL,
0x00010000041e7824ULL, 0x000fe200078e00ffULL, 0x0000763205047816ULL, 0x040fe20000000004ULL,
0x0001000005227824ULL, 0x000fe200078e00ffULL, 0x0000763206057816ULL, 0x040fe20000000005ULL,
0x00010000061f7824ULL, 0x000fe200078e00ffULL, 0x0000763207067816ULL, 0x040fe20000000006ULL,
0x0001000007247824ULL, 0x000fc400078e00ffULL, 0x000100001c077824ULL, 0x000fe400078e00ffULL,
0x00010000041d7824ULL, 0x000fe400078e00ffULL, 0x00010000051c7824ULL, 0x000fe400078e00ffULL,
0x0001000006217824ULL, 0x000fe200078e00ffULL, 0x0000000000380947ULL, 0x000fec0003800000ULL,
0x0000000318037221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b03037820ULL, 0x000fcc0000410000ULL,
0x0000000300037308ULL, 0x000e640000000800ULL, 0x0000000302027220ULL, 0x002fc80000410000ULL,
0x000000021e177223ULL, 0x080fe20000010017ULL, 0x0000000207167223ULL, 0x080fe20000010016ULL,
0x0000000222157223ULL, 0x080fe20000010015ULL, 0x000000021d147223ULL, 0x080fe20000010014ULL,
0x000000021f0c7223ULL, 0x080fe2000001000cULL, 0x000000021c137223ULL, 0x080fe20000010013ULL,
0x00000002240d7223ULL, 0x080fe2000001000dULL, 0x0000000221127223ULL, 0x000fe20000010012ULL,
0x0000001b021b7221ULL, 0x000fe20000010000ULL, 0x0000000000547947ULL, 0x000fec0003800000ULL,
0x8000000318047221ULL, 0x000fe20000010000ULL, 0x0000001e02067220ULL, 0x040fe20000410000ULL,
0x0000002202187220ULL, 0x040fe20000410000ULL, 0x0000000702077220ULL, 0x000fe20000410000ULL,
0x3fb8aa3b04047820ULL, 0x000fe20000410000ULL, 0x0000001d021d7220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000000400057308ULL, 0x000e620000000800ULL, 0x00000024021e7220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x000fe20000410000ULL, 0x0000001505157223ULL, 0x042fe20000010018ULL,
0x0000001b051b7223ULL, 0x040fe20000010002ULL, 0x0000001705177223ULL, 0x040fe20000010006ULL,
0x0000001605167223ULL, 0x040fe20000010007ULL, 0x0000001405147223ULL, 0x040fe2000001001dULL,
0x0000000c050c7223ULL, 0x040fe2000001001fULL, 0x0000001305137223ULL, 0x040fe2000001001cULL,
0x0000000d050d7223ULL, 0x040fe2000001001eULL, 0x0000001205127223ULL, 0x000fe20000010021ULL,
0x000000ffff187224ULL, 0x000fce00078e0003ULL, 0x00804008ff027984ULL, 0x000e680008000a00ULL,
0x0010000020047984ULL, 0x000ea20000000c00ULL, 0x0000001a0300720bULL, 0x002fe40003f14000ULL,
0x00007632041c7816ULL, 0x044fe2000000001cULL, 0x00010000041e7824ULL, 0x000fe200078e00ffULL,
0x0000763205047816ULL, 0x040fe20000000004ULL, 0x00010000051d7824ULL, 0x000fe200078e00ffULL,
0x0000763206057816ULL, 0x040fe20000000005ULL, 0x0001000006227824ULL, 0x000fe200078e00ffULL,
0x0000763207067816ULL, 0x040fe20000000006ULL, 0x0001000007217824ULL, 0x000fc400078e00ffULL,
0x000100001c1c7824ULL, 0x000fe400078e00ffULL, 0x00010000041f7824ULL, 0x000fe400078e00ffULL,
0x0001000005207824ULL, 0x000fe400078e00ffULL, 0x0001000006237824ULL, 0x000fe200078e00ffULL,
0x0000000000380947ULL, 0x000fec0003800000ULL, 0x000000031a037221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b03037820ULL, 0x000fcc0000410000ULL, 0x0000000300037308ULL, 0x000e640000000800ULL,
0x0000000302027220ULL, 0x002fc80000410000ULL, 0x000000021e117223ULL, 0x080fe20000010011ULL,
0x000000021c0f7223ULL, 0x080fe2000001000fULL, 0x000000021d0a7223ULL, 0x080fe2000001000aULL,
0x000000021f107223ULL, 0x080fe20000010010ULL, 0x00000002220b7223ULL, 0x080fe2000001000bULL,
0x0000000220097223ULL, 0x080fe20000010009ULL, 0x0000000221087223ULL, 0x080fe20000010008ULL,
0x0000000223007223ULL, 0x000fe20000010000ULL, 0x0000001902197221ULL, 0x000fe20000010000ULL,
0x0000000000547947ULL, 0x000fec0003800000ULL, 0x800000031a047221ULL, 0x000fe20000010000ULL,
0x0000001d02077220ULL, 0x040fe20000410000ULL, 0x0000001f021d7220ULL, 0x040fe20000410000ULL,
0x0000001e02067220ULL, 0x000fe20000410000ULL, 0x3fb8aa3b04047820ULL, 0x000fe20000410000ULL,
0x0000001c021a7220ULL, 0x040fe20000410000ULL, 0x00000021021f7220ULL, 0x040fe20000410000ULL,
0x00000022021c7220ULL, 0x040fe20000410000ULL, 0x0000000400057308ULL, 0x000e620000000800ULL,
0x00000020021e7220ULL, 0x040fe20000410000ULL, 0x0000002302217220ULL, 0x000fe20000410000ULL,
0x0000000f050f7223ULL, 0x042fe2000001001aULL, 0x0000001905197223ULL, 0x040fe20000010002ULL,
0x0000001105117223ULL, 0x040fe20000010006ULL, 0x0000000a050a7223ULL, 0x040fe20000010007ULL,
0x0000001005107223ULL, 0x040fe2000001001dULL, 0x0000000b050b7223ULL, 0x040fe2000001001cULL,
0x0000000905097223ULL, 0x040fe2000001001eULL, 0x0000000805087223ULL, 0x040fe2000001001fULL,
0x0000000005007223ULL, 0x000fe20000010021ULL, 0x000000ffff1a7224ULL, 0x000fce00078e0003ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000070d087291ULL, 0x000fe2000f8e203fULL,
0x00000001ff027424ULL, 0x000fd000078e00ffULL, 0x00820802ffff79a7ULL, 0x0003e60008500008ULL,
0xfffffff8000c8947ULL, 0x003fea000383ffffULL, 0x00000000002c7947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x004fe200078e00ffULL, 0x00000000000a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fc4000001ff00ULL,
0x0000000000167805ULL, 0x000fce000001ff00ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x0000001b001b7308ULL, 0x000ea20000001000ULL, 0x00000004100472a4ULL, 0x000fe2000f8e020cULL,
0x00008600000a7ab9ULL, 0x000fc60000000a00ULL, 0x0000000404067899ULL, 0x000fe4000800063fULL,
0x0000000805047890ULL, 0x000fe2000fffe03fULL, 0x0000001900197308ULL, 0x000ee20000001000ULL,
0x0000000506087290ULL, 0x000fe4000ff1e03fULL, 0x0000000406057290ULL, 0x000fe4000ff3e03fULL,
0x0000003f3f097290ULL, 0x000fe400087fe43fULL, 0x0000003f3f067290ULL, 0x000fe20008ffe43fULL,
0x000000171b177220ULL, 0x044fe20000410000ULL, 0x0000000a05047291ULL, 0x000fe2000f82483fULL,
0x000000161b167220ULL, 0x040fe20000410000ULL, 0x0000000a080d7291ULL, 0x000fe2000f80483fULL,
0x000000151b157220ULL, 0x040fe20000410000ULL, 0x0000000b05057291ULL, 0x000fe200088f4c06ULL,
0x000000141b147220ULL, 0x040fe20000410000ULL, 0x0000000b08087291ULL, 0x000fe200080f4c09ULL,
0x0000000c1b067220ULL, 0x040fe20000410000ULL, 0x000000131b137220ULL, 0x040fe20000410000ULL,
0x0000000d1b077220ULL, 0x040fe20000410000ULL, 0x000000121b127220ULL, 0x000fe20000410000ULL,
0x000000080e1b7824ULL, 0x002fc400078e00ffULL, 0x0000000f190c7220ULL, 0x048fe20000410000ULL,
0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL, 0x0000001119117220ULL, 0x040fe20000410000ULL,
0x00000005ff057e24ULL, 0x000fe4000f8e00ffULL, 0x0000000a190a7220ULL, 0x040fe20000410000ULL,
0x00000010190d7220ULL, 0x040fe20000410000ULL, 0x0000000b190b7220ULL, 0x040fe20000410000ULL,
0x0000000dff027e24ULL, 0x000fe4000f8e00ffULL, 0x00000009190e7220ULL, 0x000fe20000410000ULL,
0x00000008ff037e24ULL, 0x000fc4000f8e00ffULL, 0x00000008190f7220ULL, 0x040fe20000410000ULL,
0x0000000019007220ULL, 0x000fe20000410000ULL, 0x000000021b087825ULL, 0x040fe200078e0004ULL,
0x000000171604723eULL, 0x000fe400000010ffULL, 0x000000151405723eULL, 0x000fe200000010ffULL,
0x000000021b027825ULL, 0x000fe200078e0002ULL, 0x000000061306723eULL, 0x000fe400000010ffULL,
0x000000071207723eULL, 0x000fe400000010ffULL, 0x0000000f000f723eULL, 0x000fc400000010ffULL,
0x0000000b0e0e723eULL, 0x000fe200000010ffULL, 0x0000000402007986ULL, 0x0003e2000c101d0eULL,
0x0000000a0d0d723eULL, 0x000fe400000010ffULL, 0x000000110c0c723eULL, 0x000fca00000010ffULL,
0x0000000c08007986ULL, 0x0003e4000c101d0eULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000000a94dULL, 0x000fea0003800000ULL, 0x000000074a4a7c11ULL, 0x000fc8000f8e20ffULL,
0x008208004a0079b1ULL, 0x000e24000800003fULL, 0x008200004a0079b1ULL, 0x001fe2000800003fULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00db7803090075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00db7803090085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffff8800ec7947ULL, 0x001fea000383ffffULL, 0x00db5803000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00db5803000085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffff8c00807947ULL, 0x001fea000383ffffULL, 0x00db6803000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00db6803000085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffff8c00b87947ULL, 0x001fea000383ffffULL, 0x00db481d000075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00db481d000095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffff9000ec7947ULL, 0x021fea000383ffffULL, 0x00dbb803000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00dbb803000085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffa800e07947ULL, 0x021fea000383ffffULL, 0x00db7007090075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00db7007090085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffac00507947ULL, 0x001fea000383ffffULL, 0x00db90070d0075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00db90070d0095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffac006c7947ULL, 0x001fea000383ffffULL, 0x00dbb807000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00dbb807000085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffb400607947ULL, 0x001fea000383ffffULL, 0x00dbb807000075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00dbb807000095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffbc00687947ULL, 0x001fea000383ffffULL, 0x00dbb809000075a7ULL, 0x000022000802017fULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00dbb809000095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffcc00287947ULL, 0x000fea000383ffffULL, 0x00dbb839000075a7ULL, 0x000022000802017fULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00dbb839000095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffcc005c7947ULL, 0x000fea000383ffffULL, 0x00dbb005000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00dbb005000085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffd000087947ULL, 0x021fea000383ffffULL, 0x00db4005000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00db4005000085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffcc00fc7947ULL, 0x021fea000383ffffULL, 0x00db500b000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00db500b000085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffd000207947ULL, 0x001fea000383ffffULL, 0x00db600b000075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00db600b000085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffd400307947ULL, 0x001fea000383ffffULL, 0x00dbb00b000075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00dbb00b000095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffdc00787947ULL, 0x001fea000383ffffULL, 0x00dbb00f000075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00dbb00f000095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffdc00cc7947ULL, 0x005fea000383ffffULL, 0x00db980f240075a7ULL, 0x000b62000802017fULL,
0x0000d0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00db980f240095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffe000687947ULL, 0x01ffea000383ffffULL, 0x00000009ff027e24ULL, 0x000fe4000f8e00ffULL,
0x00000009ff037e24ULL, 0x000fce000f8e00ffULL, 0x0000000bff057e24ULL, 0x000fc8000f8e00ffULL,
0x00820803050075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00820803050085a7ULL, 0x000e24000800007fULL,
0xfffffffc00e88947ULL, 0x001fea000383ffffULL, 0xffffffe800587947ULL, 0x001fea000383ffffULL,
0x0000000bff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff037e24ULL, 0x000fce000f8e00ffULL,
0x00000009ff057e24ULL, 0x000fc8000f8e00ffULL, 0x00820003050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00820003050085a7ULL, 0x000e24000800007fULL, 0xfffffffc00e88947ULL, 0x001fea000383ffffULL,
0xffffffec004c7947ULL, 0x001fea000383ffffULL, 0x018000000a087836ULL, 0x000fe20000000000ULL,
0x0000013000037945ULL, 0x000fe80003800000ULL, 0x7f800000080f7812ULL, 0x000fc800078ec0ffULL,
0x018000000f00780cULL, 0x000fda0003f25070ULL, 0x0000000a00089308ULL, 0x0000620000001000ULL,
0x0000000000389947ULL, 0x000fea0003800000ULL, 0x000000ff0f00720cULL, 0x040fe40003f45070ULL,
0x008000000f00780cULL, 0x000fe40003f22070ULL, 0x00000001ff0f7807ULL, 0x000fe40001000000ULL,
0x00000001ff087807ULL, 0x002fc80004800000ULL, 0x000000080fff7212ULL, 0x000fda000782fcffULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x040fe4000782c0ffULL,
0x800000000a0a7812ULL, 0x001fe400078ec0ffULL, 0x00000001ff087807ULL, 0x000fc80000800000ULL,
0x000000080fff7212ULL, 0x000fda000782c0ffULL, 0x008000000a081812ULL, 0x000fe200078efcffULL,
0x000000ffff089224ULL, 0x000fe200078e000aULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000a00087308ULL, 0x0002a40000001000ULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x00000000ff0f7424ULL, 0x000fc800078e00ffULL, 0xffffff780e507950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000010000dc00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000015bULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001c5ULL,
0x00000000000001ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000398ULL,
0x0000000000000150ULL, 0x0000000c00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000cbULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000004e8ULL,
0x00000000000000d8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000029ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005c0ULL,
0x0000000000000048ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000043ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000608ULL,
0x00000000000007e8ULL, 0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000100000126ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000df0ULL,
0x0000000000000020ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x00000004000000b5ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000e10ULL,
0x0000000000000000ULL, 0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000edULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000e10ULL,
0x0000000000000030ULL, 0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x0000000400000114ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000e40ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000006dULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e88ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x000000010000008fULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e90ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000100000032ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000f00ULL,
0x0000000000008780ULL, 0x0000000c00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007fULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000009680ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000057ULL, 0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000009690ULL,
0x0000000000000400ULL, 0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000100000142ULL, 0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000009690ULL,
0x0000000000000310ULL, 0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x0000000000009de0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000009de0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e88ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000008780ULL, 0x0000000000008780ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000009680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000410ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000009690ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000310ULL,
0x0000000000000310ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_16_m_16_sm_90_cubin_len = 40752;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
