/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001ad10ULL, 0x000000000001a890ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000019230ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x00000000000193a0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x00000000000193e0ULL, 0x0000000000000120ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000019500ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001923000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x0063ec0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001923000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a50828808081ULL, 0x8016288080a80828ULL, 0x0000000310288082ULL, 0x80a8920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x000193a000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080830828808081ULL,
0x9c08288080a50828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809c920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x000193e000000000ULL,
0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x000812040000009cULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL, 0x0050190300500160ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0018310400ff1b03ULL, 0x000186c0000183b0ULL, 0x000187d0000186f0ULL, 0x000187f0000187e0ULL,
0xffffffff01082904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001fffffffffULL, 0x0500001f0500001fULL, 0xffffffff0500001fULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01082804ffffffffULL, 0x000000d0000000a0ULL, 0x0000160000001560ULL,
0x000016a000001680ULL, 0x000026a000002670ULL, 0x0000418000004140ULL, 0x00005520000054a0ULL,
0x000055c000005590ULL, 0x0000637000006330ULL, 0x00007ee000007eb0ULL, 0x000091e000009160ULL,
0x0000928000009250ULL, 0x00009f9000009f50ULL, 0x0000bba00000bb70ULL, 0x0000ce800000ce00ULL,
0x0000cf200000cf00ULL, 0x0000dd500000dd10ULL, 0x0000f2600000f220ULL, 0x0001079000010780ULL,
0x00012c4000010f10ULL, 0x0001335000012db0ULL, 0x00013bc000013360ULL, 0x0001805000018020ULL,
0x0001807000018060ULL, 0x000180b000018090ULL, 0x000180e0000180d0ULL, 0x00018820000187c0ULL,
0x0001884000018830ULL, 0x00018ec000018e60ULL, 0x00018f6000018f10ULL, 0x0001900000018fb0ULL,
0x000190a000019050ULL, 0x0001917000019100ULL, 0x00019210000191c0ULL, 0x0000016005e03904ULL,
0x00010600000000ffULL, 0x00000190003f0100ULL, 0x000106080000000fULL, 0x000001c0003f0130ULL,
0x000106100000000fULL, 0x00000220003f0130ULL, 0x000106480000000fULL, 0x00000230003f0120ULL,
0x00010658000000ffULL, 0x000005a0003f0100ULL, 0x00010600000000ffULL, 0x00000820003f0107ULL,
0x000000040000000aULL, 0x00000a90003f0102ULL, 0x000000000000000aULL, 0x00000c50003f0101ULL,
0x00010648000000ffULL, 0x00000cd0003f0107ULL, 0x00010658000000ffULL, 0x00000e10003f0101ULL,
0x0001065c000000ffULL, 0x00000e60003f0106ULL, 0x0001065c000000ffULL, 0x00000ee0003f0106ULL,
0x0001065c000000ffULL, 0x00001310003f0106ULL, 0x00010650000000ffULL, 0x00001380003f0107ULL,
0x0001064c000000ffULL, 0x000013a0003f0106ULL, 0x0001060c000000ffULL, 0x000014a0003f0106ULL,
0x0001060c000000ffULL, 0x00001900003f0106ULL, 0x0001064c000000ffULL, 0x000019a0003f0106ULL,
0x0001064c000000ffULL, 0x00003230003f0106ULL, 0x00010658000000ffULL, 0x00003240003f0101ULL,
0x0001065c000000ffULL, 0x00003280003f0106ULL, 0x0001065c000000ffULL, 0x00003300003f0106ULL,
0x0001065c000000ffULL, 0x000035c0003f0106ULL, 0x00010648000000ffULL, 0x00003630003f0107ULL,
0x00010654000000ffULL, 0x000036a0003f0106ULL, 0x00010654000000ffULL, 0x00003740003f0106ULL,
0x00010654000000ffULL, 0x00004eb0003f0106ULL, 0x00010658000000ffULL, 0x00004f20003f0101ULL,
0x00010610000000ffULL, 0x00004f70003f0101ULL, 0x0001065c000000ffULL, 0x00004fb0003f0106ULL,
0x0001065c000000ffULL, 0x00005030003f0106ULL, 0x0001065c000000ffULL, 0x000052b0003f0106ULL,
0x00010650000000ffULL, 0x00005320003f0107ULL, 0x0001064c000000ffULL, 0x00005340003f0106ULL,
0x0001061c000000ffULL, 0x00005420003f0106ULL, 0x0001061c000000ffULL, 0x00005830003f0106ULL,
0x0001064c000000ffULL, 0x000058d0003f0106ULL, 0x0001064c000000ffULL, 0x00006fe0003f0106ULL,
0x00010658000000ffULL, 0x00006ff0003f0101ULL, 0x0001065c000000ffULL, 0x00007030003f0106ULL,
0x0001065c000000ffULL, 0x000070b0003f0106ULL, 0x0001065c000000ffULL, 0x00007330003f0106ULL,
0x00010648000000ffULL, 0x000073a0003f0107ULL, 0x00010654000000ffULL, 0x000073f0003f0106ULL,
0x00010654000000ffULL, 0x00007480003f0106ULL, 0x00010654000000ffULL, 0x00008b70003f0106ULL,
0x00010658000000ffULL, 0x00008be0003f0101ULL, 0x00010620000000ffULL, 0x00008c30003f0101ULL,
0x0001065c000000ffULL, 0x00008c70003f0106ULL, 0x0001065c000000ffULL, 0x00008cf0003f0106ULL,
0x0001065c000000ffULL, 0x00008f70003f0106ULL, 0x00010650000000ffULL, 0x00008fe0003f0107ULL,
0x0001064c000000ffULL, 0x00009000003f0106ULL, 0x0001062c000000ffULL, 0x000090e0003f0106ULL,
0x0001062c000000ffULL, 0x000094f0003f0106ULL, 0x0001064c000000ffULL, 0x00009590003f0106ULL,
0x0001064c000000ffULL, 0x0000aca0003f0106ULL, 0x00010658000000ffULL, 0x0000acb0003f0101ULL,
0x0001065c000000ffULL, 0x0000acf0003f0106ULL, 0x0001065c000000ffULL, 0x0000ad70003f0106ULL,
0x0001065c000000ffULL, 0x0000aff0003f0106ULL, 0x00010648000000ffULL, 0x0000b060003f0107ULL,
0x00010654000000ffULL, 0x0000b0b0003f0106ULL, 0x00010654000000ffULL, 0x0000b140003f0106ULL,
0x00010654000000ffULL, 0x0000c830003f0106ULL, 0x00010658000000ffULL, 0x0000c8a0003f0101ULL,
0x00010630000000ffULL, 0x0000c8f0003f0101ULL, 0x0001065c000000ffULL, 0x0000c930003f0106ULL,
0x0001065c000000ffULL, 0x0000c9b0003f0106ULL, 0x0001065c000000ffULL, 0x0000cc30003f0106ULL,
0x00010650000000ffULL, 0x0000cca0003f0107ULL, 0x0001064c000000ffULL, 0x0000ccc0003f0106ULL,
0x0001063c000000ffULL, 0x0000cd80003f0106ULL, 0x0001063c000000ffULL, 0x0000d190003f0106ULL,
0x0001064c000000ffULL, 0x0000d230003f0106ULL, 0x0001064c000000ffULL, 0x0000e940003f0106ULL,
0x00010658000000ffULL, 0x0000e950003f0101ULL, 0x0001065c000000ffULL, 0x0000e990003f0106ULL,
0x0001065c000000ffULL, 0x0000ea10003f0106ULL, 0x0001065c000000ffULL, 0x0000ecc0003f0106ULL,
0x00010648000000ffULL, 0x0000ed30003f0107ULL, 0x00010654000000ffULL, 0x0000ed80003f0106ULL,
0x00010654000000ffULL, 0x0000ee10003f0106ULL, 0x00010654000000ffULL, 0x00010500003f0106ULL,
0x00010658000000ffULL, 0x00010560003f0101ULL, 0x00010640000000ffULL, 0x00014ba0003f0101ULL,
0x00010604000000ffULL, 0x00014c30003f0106ULL, 0x00010604000000ffULL, 0x00014f60003f0106ULL,
0x00010600000000ffULL, 0x00014f70003f0101ULL, 0x00010604000000ffULL, 0x00014ff0003f0106ULL,
0x00010604000000ffULL, 0x00017530003f0106ULL, 0x0001061400000030ULL, 0x00017900003f0106ULL,
0x0001061400000030ULL, 0x00018dc0003f0106ULL, 0x0001060800000030ULL, 0x00053803003f0101ULL,
0x0001402000101c04ULL, 0x000150e000015040ULL, 0x0000040100018e20ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001c4ULL, 0x0000001100000002ULL, 0x0000000000000144ULL, 0x0000001100000002ULL,
0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x000000000000019aULL, 0x0000001100000002ULL, 0x000000000000011dULL, 0x0000001100000002ULL,
0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000a7919ULL, 0x000e620000002300ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x00000000000b7919ULL, 0x000ea80000002100ULL, 0x0000000000457919ULL, 0x000ee80000002700ULL,
0x00000000002d7919ULL, 0x000f220000002600ULL, 0x000000010a007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x104fe200078e020bULL, 0x00000005ff507819ULL, 0x000fe2000001160bULL,
0x00001fff0a007589ULL, 0x0002a600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe20003f04070ULL, 0x00001fff50507589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe20003f24070ULL, 0x00000004ff0a7424ULL, 0x002fe200078e00ffULL,
0x000000010f00780cULL, 0x000fc60003f44070ULL, 0x00006000450a7625ULL, 0x008fc800078e000aULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL,
0x01060002ff00b388ULL, 0x0003e20000000a00ULL, 0x3fffff80ff068424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff078424ULL, 0x000fe200078e00ffULL, 0x010608040f008388ULL, 0x0003e2000000ca00ULL,
0xff317217ff0e9424ULL, 0x000fc400078e00ffULL, 0x3fffff80ff08a424ULL, 0x000fe200078e00ffULL,
0x010610060f008388ULL, 0x0003e2000000ca00ULL, 0x000000ff0000720cULL, 0x004fe20003f05270ULL,
0x7fffff80ff09a424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0cb424ULL, 0x000fe200078e00ffULL,
0x0104000e0f009388ULL, 0x0003e20000004800ULL, 0x7fffff80ff0db424ULL, 0x000fc600078e00ffULL,
0x010648080f00a388ULL, 0x0003e80000008a00ULL, 0x0106580cff00b388ULL, 0x0003e80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003b000000947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x012e620000000000ULL, 0x0000000450047824ULL, 0x000fc400078e00ffULL,
0x00005800ff027624ULL, 0x000fe400078e00ffULL, 0x000000102d037824ULL, 0x000fe400078e00ffULL,
0x0000001002027824ULL, 0x000fe400078e00ffULL, 0x00000200ff137424ULL, 0x000fe200078e00ffULL,
0x000000040f057211ULL, 0x002fe200078fd8ffULL, 0x0000004502047224ULL, 0x000fc600078e0203ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x00000003050d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000705027812ULL, 0x000fe400078ec0ffULL, 0x0000000707037812ULL, 0x000fe400078ec0ffULL,
0x000000070d0c7812ULL, 0x000fe400078ec0ffULL, 0x0000001f02027812ULL, 0x000fc400078e780fULL,
0x0000000205097810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03067812ULL, 0x100fe200078e780fULL,
0x000000100f037824ULL, 0x000fe200078e00ffULL, 0x0000001f0c127812ULL, 0x000fe200078e780fULL,
0x00000020050c7824ULL, 0x000fe200078e0202ULL, 0x0000000709087812ULL, 0x000fe200078ec0ffULL,
0x0000000104027824ULL, 0x000fe200078e0205ULL, 0x000001f003117812ULL, 0x000fe200078ec0ffULL,
0x00000020070e7824ULL, 0x000fe200078e0206ULL, 0x0000001f08087812ULL, 0x000fe200078e780fULL,
0x00005c0002027625ULL, 0x000fc800078e0013ULL, 0x0000000104057824ULL, 0x000fe200078e0207ULL,
0x0000001102027210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x040fe400078e0209ULL,
0x00000001040f7824ULL, 0x000fe400078e020dULL, 0x00005c0005047625ULL, 0x000fc800078e0013ULL,
0x0000002009107824ULL, 0x000fe200078e0208ULL, 0x0000001104047210ULL, 0x000fe20007f3e0ffULL,
0x00005c0006067625ULL, 0x000fc800078e0013ULL, 0x00005c000f087625ULL, 0x000fc800078e0013ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001106067210ULL, 0x080fe20007f1e0ffULL,
0x000000200d127824ULL, 0x000fe200078e0212ULL, 0x0000001108087210ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fc400000e0607ULL,
0x0000001010117824ULL, 0x000fe200078e00ffULL, 0x00000000040f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fe400010e0609ULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x0000000006117faeULL, 0x0003e8000b901c46ULL, 0x0000000008137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000060a477981ULL, 0x012ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff517e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff47467810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff467819ULL, 0x000fce0000011646ULL, 0x000139b000008947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0000000151037810ULL, 0x040fe20007ffe0ffULL,
0x0000010051047824ULL, 0x000fe200078e00ffULL, 0x000058002d027a10ULL, 0x000fe20007ffe0ffULL,
0x0000000245457824ULL, 0x000fe200078e00ffULL, 0x000000460300720cULL, 0x000fe20003f06070ULL,
0x00000003ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000447037217ULL, 0x000fe20007800000ULL,
0x0000580045457a24ULL, 0x000fe200078e0202ULL, 0x00010610500a7811ULL, 0x040fe200078e20ffULL,
0x0000000850447824ULL, 0x000fc400078e00ffULL, 0x0000000103037824ULL, 0x000fe200078e0a04ULL,
0x00000004ff027819ULL, 0x002fe20000011600ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000144077824ULL, 0x000fe200078e0202ULL, 0x0000002003037807ULL, 0x000fe20000000000ULL,
0x0000620045047a24ULL, 0x000fe200078e0204ULL, 0x0000000202087810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff127424ULL, 0x000fe200078e00ffULL, 0x0000000707057812ULL, 0x000fe200078ec0ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000004403037217ULL, 0x000fe20007800000ULL,
0x0000040b0aff738cULL, 0x0003e20000000000ULL, 0x0000000f05067812ULL, 0x000fc400078e7800ULL,
0x0000000402097810ULL, 0x000fe20007ffe0ffULL, 0x0000000103057824ULL, 0x000fe200078e0a44ULL,
0x000000f011117812ULL, 0x000fe200078ec0ffULL, 0x0000000104037824ULL, 0x000fe400078e0207ULL,
0x00000001440d7824ULL, 0x000fe200078e0209ULL, 0x000000050200720cULL, 0x0c0fe20003f66070ULL,
0x00000010070b7824ULL, 0x002fe200078e0206ULL, 0x0000000602067810ULL, 0x000fe20007ffe0ffULL,
0x00005e0003027625ULL, 0x000fe200078e0012ULL, 0x000000050800720cULL, 0x000fc40003f46070ULL,
0x000000050900720cULL, 0x080fe20003f26070ULL, 0x0000000144077824ULL, 0x000fe200078e0208ULL,
0x000000050600720cULL, 0x000fe20003f06070ULL, 0x00000001440f7824ULL, 0x000fe200078e0206ULL,
0x0000001102087210ULL, 0x000fe40007f9e0ffULL, 0x0000000707057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0603ULL, 0x0000000f05027812ULL, 0x000fe400078e7800ULL,
0x000000070d037812ULL, 0x000fe400078ec0ffULL, 0x000000070f057812ULL, 0x000fe200078ec0ffULL,
0x00000010070c7824ULL, 0x000fe200078e0202ULL, 0x0000000f03067812ULL, 0x100fe200078e7800ULL,
0x0000000104027824ULL, 0x040fe200078e0207ULL, 0x0000000f05107812ULL, 0x000fe200078e7800ULL,
0x0000000104057824ULL, 0x000fc400078e020dULL, 0x0000000104077824ULL, 0x000fe400078e020fULL,
0x000000100d0e7824ULL, 0x000fe400078e0206ULL, 0x000000100f107824ULL, 0x000fe400078e0210ULL,
0x00005e0002027625ULL, 0x000fc800078e0012ULL, 0x00005e0005047625ULL, 0x000fc800078e0012ULL,
0x00005e0007067625ULL, 0x000fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000001102027210ULL, 0x080fe20007f9e0ffULL, 0x000000000aff7f8cULL, 0x0003e2000c80043fULL,
0x0000001104047210ULL, 0x080fe20007fbe0ffULL, 0xff317217ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000001106067210ULL, 0x000fe20007fde0ffULL, 0x000000ffff037224ULL, 0x000fe200020e0603ULL,
0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0x0000c0000c0d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000c0000e0f7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000d901c46ULL, 0x0000c00010117811ULL, 0x000fe200078e20ffULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000020d7faeULL, 0x0003e2000d101c46ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000040f7faeULL, 0x0003e2000c901c46ULL, 0x000000465100720cULL, 0x000fe20003f26070ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000006117faeULL, 0x0003e2000c101c46ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fc400078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000f87000001947ULL, 0x000fea0003800000ULL,
0x0000000450037824ULL, 0x002fe200078e00ffULL, 0x00007610ff5f7816ULL, 0x000fe2000000005fULL,
0xff317217ff1b7424ULL, 0x000fe200078e00ffULL, 0x00007610ff027816ULL, 0x000fe20000000002ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x0000000203197810ULL, 0x000fc40007ffe0ffULL,
0x0000010051047824ULL, 0x000fca00078e00ffULL, 0x000000470400720cULL, 0x000fda0003f06070ULL,
0x0000f78000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000076105f047816ULL, 0x000fe20000000004ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x01065c00ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff057424ULL, 0x000fc800078e00ffULL, 0x0000000500067305ULL, 0x0002a4000021f000ULL,
0x3fa0000005057823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01065c00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000002051067811ULL, 0x040fe200078e40ffULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000000151057810ULL, 0x000fe20007ffe0ffULL, 0x0000001000597824ULL, 0x000fe200078e00ffULL,
0x00000004ff1d7819ULL, 0x000fe20000011600ULL, 0x0000620045157a24ULL, 0x000fe200078e0206ULL,
0x000000460500720cULL, 0x000fe40003f06070ULL, 0x0000000647077217ULL, 0x000fe20007800000ULL,
0x0000000144057824ULL, 0x000fe200078e021dULL, 0x000000061d097810ULL, 0x000fc40007ffe0ffULL,
0x000000041d087810ULL, 0x000fe20007ffe0ffULL, 0x00000001050e7824ULL, 0x000fe400078e0215ULL,
0x00000001070c7824ULL, 0x000fe200078e0a06ULL, 0x000000021d077810ULL, 0x000fe20007ffe0ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e001fULL, 0x000000f059067812ULL, 0x000fe400078ec0ffULL,
0x000000200c117807ULL, 0x000fe20000000000ULL, 0x00000001440c7824ULL, 0x000fe200078e0209ULL,
0x000000060e147210ULL, 0x000fe20007f3e0ffULL, 0x00000001440a7824ULL, 0x040fe200078e0207ULL,
0x0000001144177217ULL, 0x040fe20007800000ULL, 0x00000001440b7824ULL, 0x000fe200078e0208ULL,
0x000000070c297812ULL, 0x040fe200078ec0ffULL, 0x000000010c0e7824ULL, 0x000fc400078e0215ULL,
0x000000010a107824ULL, 0x100fe200078e0215ULL, 0x0000000f29297812ULL, 0x000fe200078e7800ULL,
0x000000010b127824ULL, 0x000fe400078e0215ULL, 0x000000ffff157224ULL, 0x000fe400008e060fULL,
0x00005e000e0e7625ULL, 0x000fc800078e001fULL, 0x0000000117187824ULL, 0x000fe200078e0a44ULL,
0x000000060e167210ULL, 0x000fe20007fbe0ffULL, 0x00005e0010107625ULL, 0x000fc600078e001fULL,
0x000000181d00720cULL, 0x000fe20003f26070ULL, 0x00005e0012127625ULL, 0x000fe200078e001fULL,
0x00000007051d7812ULL, 0x000fe400078ec0ffULL, 0x0000000610107210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200028e060fULL, 0x000000070a0f7812ULL, 0x000fe200078ec0ffULL,
0x000000100c4b7824ULL, 0x000fe200078e0229ULL, 0x0000000f1d0e7812ULL, 0x000fe200078e7800ULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x0000000612127210ULL, 0x000fc40007f7e0ffULL,
0x000000070b1f7812ULL, 0x000fe400078ec0ffULL, 0x0000000f0f1d7812ULL, 0x000fe200078e7800ULL,
0x00000010050f7824ULL, 0x000fe200078e020eULL, 0x0000000f1f0e7812ULL, 0x000fe200078e7800ULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x000000180700720cULL, 0x080fe20003f46070ULL,
0x000000100a4e7824ULL, 0x000fe200078e021dULL, 0x000000180800720cULL, 0x080fe20003f66070ULL,
0x000000100b4d7824ULL, 0x000fe200078e020eULL, 0x000000180900720cULL, 0x000fc40003f86070ULL,
0x0000e0000f5d7811ULL, 0x000fe400078e20ffULL, 0x0000e0004e5c7811ULL, 0x000fe400078e20ffULL,
0x0000e0004d5b7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000145d7faeULL, 0x0003e2000c901c46ULL, 0x0000e0004b5a7811ULL, 0x000fc600078e20ffULL,
0x00000000105c7faeULL, 0x0003e8000d101c46ULL, 0x00000000125b7faeULL, 0x0003e8000d901c46ULL,
0x00000000165a7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff117984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff137984ULL, 0x000ea20000000800ULL, 0x0000ffff5f0e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff02107812ULL, 0x000fe400078ec0ffULL, 0x000088800e157816ULL, 0x000fe400000000ffULL,
0x0000888010577816ULL, 0x000fc600000000ffULL, 0x80000000150e7824ULL, 0x000fe400078e00ffULL,
0x8000000057107824ULL, 0x000fc600078e00ffULL, 0x8000000011ff7812ULL, 0x002fe4000782480eULL,
0x8000000013ff7812ULL, 0x004fe20007844810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff0e7424ULL, 0x000fe400078e00ffULL,
0x8000000057117824ULL, 0x000fe400078e00ffULL, 0x0000000e00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01060c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7819ULL, 0x000fe20000011600ULL, 0x00000001ff187424ULL, 0x000fe200078e00ffULL,
0x0000007059597812ULL, 0x000fe400078ec0ffULL, 0x0000000c0e0e7812ULL, 0x000fca00078ec0ffULL,
0x0000000159597824ULL, 0x000fca00078e020eULL, 0x01000000590e7984ULL, 0x000e680000000800ULL,
0x0102000059107984ULL, 0x0004e20000000800ULL, 0x0000001b0e00720bULL, 0x002fda0003f5d000ULL,
0x0000000000117806ULL, 0x000fc800010e0100ULL, 0x0000ffff11167812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x0000001b0e00720bULL, 0x00cfe40003f54000ULL,
0x0000000e1b1c7209ULL, 0x000fe40007810000ULL, 0x00000002ff137819ULL, 0x000fc60000011600ULL,
0x8000001c1b117221ULL, 0x100fe20000010000ULL, 0x0000000813147810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe400078e001cULL, 0x3fb8aa3b11127820ULL, 0x000fe40000410000ULL,
0x0000000000117806ULL, 0x000fe400010e0100ULL, 0x0000001200177308ULL, 0x000e620000000800ULL,
0x000000ff5000720cULL, 0x000fe40003f45270ULL, 0x0000ffff11117812ULL, 0x000fc800078e3cffULL,
0x0000001116ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff187807ULL, 0x000fc60001800000ULL,
0x0104001c5900a388ULL, 0x000fe20000000800ULL, 0x000000171a1a7220ULL, 0x002fc60000410000ULL,
0x00001f1417147589ULL, 0x000e6400000e0000ULL, 0x8000001c0e0e3221ULL, 0x000fe40000010000ULL,
0x00001f1317137589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b0e0e3820ULL, 0x000fc80000410000ULL,
0x0000000e000d3308ULL, 0x000ee20000000800ULL, 0x0000001427277220ULL, 0x082fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001437377220ULL, 0x080fe20000410000ULL,
0x0000001436367220ULL, 0x080fe20000410000ULL, 0x000000143b3b7220ULL, 0x080fe20000410000ULL,
0x000000143a3a7220ULL, 0x080fe20000410000ULL, 0x000000143f3f7220ULL, 0x080fe20000410000ULL,
0x000000143e3e7220ULL, 0x080fe20000410000ULL, 0x0000001443437220ULL, 0x080fe20000410000ULL,
0x0000001442427220ULL, 0x000fe20000410000ULL, 0x0000001325257220ULL, 0x084fe20000410000ULL,
0x0000001324247220ULL, 0x080fe20000410000ULL, 0x0000001321217220ULL, 0x080fe20000410000ULL,
0x0000001320207220ULL, 0x080fe20000410000ULL, 0x000000132d2d7220ULL, 0x080fe20000410000ULL,
0x000000132c2c7220ULL, 0x080fe20000410000ULL, 0x0000001331317220ULL, 0x080fe20000410000ULL,
0x0000001330307220ULL, 0x080fe20000410000ULL, 0x0000001335357220ULL, 0x080fe20000410000ULL,
0x0000001334347220ULL, 0x080fe20000410000ULL, 0x0000001339397220ULL, 0x080fe20000410000ULL,
0x0000001338387220ULL, 0x080fe20000410000ULL, 0x000000133d3d7220ULL, 0x080fe20000410000ULL,
0x000000133c3c7220ULL, 0x080fe20000410000ULL, 0x0000001341417220ULL, 0x080fe20000410000ULL,
0x0000001340407220ULL, 0x000fe20000410000ULL, 0x0000000d10103220ULL, 0x008fc80000410000ULL,
0x0000001a101a7221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff0e7984ULL, 0x000e620000000800ULL, 0x8000000015117824ULL, 0x000fca00078e00ffULL,
0x800000000eff7812ULL, 0x002fe20007824811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000015157824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01064c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007824815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000800117812ULL, 0x040fe400078ec0ffULL, 0x0000000300107211ULL, 0x040fe400078fe0ffULL,
0x0000000711157812ULL, 0x140fe400078ec800ULL, 0x00000007110e7812ULL, 0x000fe400078ef800ULL,
0x00000010151d7212ULL, 0x000fe400078e3cffULL, 0x0000001900147211ULL, 0x000fc400078fe0ffULL,
0x0000991018287816ULL, 0x000fe200000000ffULL, 0x000000100e4a7824ULL, 0x000fe200078e021dULL,
0x00000014151f7212ULL, 0x000fe400078e3cffULL, 0x0000000dff7d723eULL, 0x000fe400000010ffULL,
0x0000c0004a587811ULL, 0x000fe200078e20ffULL, 0x000000100e497824ULL, 0x040fe200078e021fULL,
0x000001000e0e7811ULL, 0x000fe400078e20ffULL, 0x00000002ff967819ULL, 0x000fe20000011600ULL,
0x000000005810783bULL, 0x000e620000004200ULL, 0x0000c00049567811ULL, 0x000fe200078e20ffULL,
0x000000011f187824ULL, 0x100fe200078e020eULL, 0x000054107d7d7816ULL, 0x000fe2000000007dULL,
0x000000011d487824ULL, 0x000fc400078e020eULL, 0x000000ffff0e7224ULL, 0x000fe200078e0028ULL,
0x0000c00018547811ULL, 0x000fe200078e20ffULL, 0x000000005614783bULL, 0x000fe20000004200ULL,
0x0000c00048557811ULL, 0x000fe400078e20ffULL, 0x000000ff0e00720cULL, 0x000fe20003f25270ULL,
0x000000005428783bULL, 0x000ea80000004200ULL, 0x00000000551c783bULL, 0x000ee20000004200ULL,
0x00000010ff847819ULL, 0x002fc40000011610ULL, 0x0000ffff10827812ULL, 0x000fe400078ec0ffULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe40000011611ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000008ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff6c7819ULL, 0x000fe20000011612ULL, 0x20000084ff917230ULL, 0x000fe20000004100ULL,
0x00000010ff837819ULL, 0x000fc40000011613ULL, 0x000000ff6b847812ULL, 0x000fe400078ec0ffULL,
0x0000ffff11817812ULL, 0x000fe400078ec0ffULL, 0x000000ff138d7812ULL, 0x000fe400078ec0ffULL,
0x00000082ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff6c827812ULL, 0x000fe400078ec0ffULL,
0x000000ff83837812ULL, 0x000fe200078ec0ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x0000ffff124c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8c7819ULL, 0x000fe40000011613ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000008ff817819ULL, 0x000fe40000011681ULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x0000ffff136e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6a7819ULL, 0x004fc40000011629ULL, 0x000000ff29857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011629ULL, 0x0000ffff29867812ULL, 0x000fe400078ec0ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000008cff29723eULL, 0x000fe200020006ffULL,
0x2000008dff8c7230ULL, 0x000fe20000004100ULL, 0x00000081ff6c723eULL, 0x000fe200020006ffULL,
0x20000082ff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff4c7819ULL, 0x000fe2000001164cULL,
0x20000083ff8e7230ULL, 0x000fe20000004100ULL, 0x0000000700817812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe2000001166eULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fc40000011615ULL,
0x00000018ff677819ULL, 0x000fe40000011616ULL, 0x0000004cff6e723eULL, 0x000fe400020006ffULL,
0x00000018ff707819ULL, 0x000fe40000011617ULL, 0x000000ff1e627812ULL, 0x008fe200078ec0ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000004ff837819ULL, 0x100fe40000011600ULL,
0x00000008814c7812ULL, 0x000fc400078ef800ULL, 0x000000ff10527812ULL, 0x000fe400078ec0ffULL,
0x000000ff11637812ULL, 0x000fe400078ec0ffULL, 0x000000ff1c717812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001161cULL, 0x00000018ff4f7819ULL, 0x000fe40000011610ULL,
0x00000018ff607819ULL, 0x000fc4000001161dULL, 0x00000018ff7f7819ULL, 0x000fe40000011611ULL,
0x00000018ff807819ULL, 0x000fe40000011612ULL, 0x000000ff14777812ULL, 0x000fe400078ec0ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x000000ff53817812ULL, 0x000fe400078ec0ffULL,
0x00000010ff137819ULL, 0x000fc40000011614ULL, 0x00000018ff767819ULL, 0x000fe40000011614ULL,
0x0000ffff14117812ULL, 0x000fe400078ec0ffULL, 0x000000ff157a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe40000011615ULL, 0x00000010ff727819ULL, 0x000fe4000001161cULL,
0x0000ffff1c737812ULL, 0x000fc400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000000783537812ULL, 0x000fe400078e784cULL,
0x00000010ff107819ULL, 0x000fe40000011616ULL, 0x000000ff167e7812ULL, 0x000fe200078ec0ffULL,
0x000000084c537824ULL, 0x000fe200078e0253ULL, 0x0000ffff16757812ULL, 0x000fc400078ec0ffULL,
0x000000ff1d787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1c7819ULL, 0x100fe4000001161eULL,
0x00000018ff147819ULL, 0x000fe4000001161eULL, 0x0000ffff1e6d7812ULL, 0x000fe400078ec0ffULL,
0x00000052ff90723eULL, 0x000fe400020006ffULL, 0x00000063ff8f723eULL, 0x000fc400020006ffULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe40000011617ULL, 0x000000ff17687812ULL, 0x040fe400078ec0ffULL,
0x0000ffff170e7812ULL, 0x000fe400078ec0ffULL, 0x0000004fff1e723eULL, 0x000fc400020006ffULL,
0x00000010ff697819ULL, 0x100fe40000011628ULL, 0x000000ff288a7812ULL, 0x040fe200078ec0ffULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x00000018ff637819ULL, 0x000fe40000011628ULL,
0x0000ffff28527812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe4000001162aULL,
0x000000ff2a887812ULL, 0x000fc400078ec0ffULL, 0x00000018ff167819ULL, 0x000fe4000001162aULL,
0x0000ffff2a647812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x000000ff1f667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x000fe4000001162bULL,
0x000000ff2b897812ULL, 0x000fc400078ec0ffULL, 0x00000018ff177819ULL, 0x000fe4000001162bULL,
0x0000ffff2b4f7812ULL, 0x000fe400078ec0ffULL, 0x00000080ff28723eULL, 0x000fe200020006ffULL,
0x20000067ff807230ULL, 0x000fe20000004100ULL, 0x00000077ff2a723eULL, 0x000fe200020006ffULL,
0x20000062ff677230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000028ff287230ULL, 0x000fe20000004100ULL, 0x0000007aff2b723eULL, 0x000fe200020006ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x00000079ff77723eULL, 0x000fe200020006ffULL,
0x20000070ff797230ULL, 0x000fe20000004100ULL, 0x000000ff128b7812ULL, 0x000fe200078ec0ffULL,
0x2000005eff707230ULL, 0x000fe20000004100ULL, 0x00000078ff7a723eULL, 0x000fe200020006ffULL,
0x20000071ff787230ULL, 0x000fe20000004100ULL, 0x0000ffff15127812ULL, 0x000fe200078ec0ffULL,
0x20000060ff717230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000063ff62723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x000000ff13137812ULL, 0x000fe200078ec0ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000065ff63723eULL, 0x000fe200020006ffULL,
0x20000085ff657230ULL, 0x000fe20000004100ULL, 0x00000089ff5e723eULL, 0x000fc400020006ffULL,
0x00000010ff7b7819ULL, 0x000fe2000001161dULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000ffff1d7c7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000088ff60723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x00000081ff89723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x000fc4000001161fULL,
0x00000018ff157819ULL, 0x000fe2000001161fULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x0000ffff1f617812ULL, 0x000fe400078ec0ffULL, 0x00000016ff85723eULL, 0x000fe200020006ffULL,
0x20000014ff167230ULL, 0x000fe20000004100ULL, 0x00000017ff88723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000008ff817819ULL, 0x000fe20000011611ULL,
0x20000088ff147230ULL, 0x000fe20000004100ULL, 0x0000007fff1f723eULL, 0x000fe200020006ffULL,
0x20000068ff7f7230ULL, 0x000fe20000004100ULL, 0x00000013ff13723eULL, 0x000fe200020006ffULL,
0x20000066ff687230ULL, 0x000fe20000004100ULL, 0x00000008ff127819ULL, 0x000fe20000011612ULL,
0x2000008aff667230ULL, 0x000fe20000004100ULL, 0x0000a00053117811ULL, 0x000fe200078e20ffULL,
0x20000082ff8a7230ULL, 0x000fe20000004100ULL, 0x00000015ff17723eULL, 0x000fe200020006ffULL,
0x20000085ff157230ULL, 0x000fe20000004100ULL, 0x00000012ff85723eULL, 0x000fe200020006ffULL,
0x20000013ff887230ULL, 0x000fe20000004100ULL, 0x000000ff10827812ULL, 0x000fe200078ec0ffULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x000000001110783bULL, 0x000fe20000000200ULL,
0x000000ff74747812ULL, 0x000fe200078ec0ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000008ff757819ULL, 0x000fe20000011675ULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000084ff927230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000081ff847230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe4000001160eULL, 0x00000008960e7810ULL, 0x000fe20007ffe0ffULL,
0x20000075ff837230ULL, 0x000fe20000004100ULL, 0x00000082ff81723eULL, 0x000fe200020006ffULL,
0x20000074ff827230ULL, 0x000fe20000004100ULL, 0x00001f967d757589ULL, 0x000e6200000e0000ULL,
0x000000ff7b7b7812ULL, 0x000fc400078ec0ffULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x00001f0e7d747589ULL, 0x0004e200000e0000ULL, 0x0000007bff94723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fe20000011691ULL,
0x20000093ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff1c937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1c7819ULL, 0x000fe40000011690ULL, 0x00000010ff927819ULL, 0x000fe20000011692ULL,
0x20000094ff7d7230ULL, 0x004fe20000004100ULL, 0x000000ff1d947812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1d7819ULL, 0x000fe4000001168fULL, 0x00001054911c7816ULL, 0x000fe4000000001cULL,
0x00001054921d7816ULL, 0x000fe4000000001dULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x0000007510109231ULL, 0x082fe200003400ffULL, 0x00000008ff527819ULL, 0x000fe20000011652ULL,
0x0000007512129231ULL, 0x000fe200003400ffULL, 0x00000010ff8d7819ULL, 0x000fe2000001168dULL,
0x0000007411119231ULL, 0x088fe200003400ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x0000007413139231ULL, 0x000fe200003400ffULL, 0x00000010ff8e7819ULL, 0x000fc4000001168eULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x0000001c1040723cULL, 0x000fe20000041840ULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x00000010ff1c7819ULL, 0x000fe4000001161fULL,
0x00000010ff1d7819ULL, 0x000fe2000001161eULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff1f7819ULL, 0x000fe4000001166cULL, 0x00000010ff1e7819ULL, 0x000fe4000001166bULL,
0x000010541c1f7816ULL, 0x000fe4000000001fULL, 0x000010541d1e7816ULL, 0x000fc4000000001eULL,
0x00000010ff1c7819ULL, 0x000fe4000001168bULL, 0x00000007078b7812ULL, 0x000fe400078e784cULL,
0x00000010ff1d7819ULL, 0x000fe2000001168cULL, 0x0000001e103c723cULL, 0x000fe2000004183cULL,
0x00000052ff8c723eULL, 0x000fe200020006ffULL, 0x000000084c527824ULL, 0x000fe200078e028bULL,
0x000010548d1c7816ULL, 0x000fe4000000001cULL, 0x000010548e1d7816ULL, 0x000fc4000000001dULL,
0x00000010ff1f7819ULL, 0x000fe40000011628ULL, 0x00000010ff1e7819ULL, 0x000fe40000011629ULL,
0x00000010ff287819ULL, 0x000fe2000001166eULL, 0x0000001c1038723cULL, 0x000fe20000041838ULL,
0x00000010ff297819ULL, 0x000fe2000001168aULL, 0x2000008cff6e7230ULL, 0x000fe20000004100ULL,
0x0000a000528a7811ULL, 0x000fe400078e20ffULL, 0x000010541f287816ULL, 0x000fc40000000028ULL,
0x000010541e297816ULL, 0x000fe40000000029ULL, 0x00000008ff8b7819ULL, 0x000fe20000011686ULL,
0x000000008a1c783bULL, 0x000e620000000200ULL, 0x00000010ff867819ULL, 0x000fe4000001162bULL,
0x00000010ff2b7819ULL, 0x000fe20000011688ULL, 0x000000281034723cULL, 0x000fe20000041834ULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x000010542b2a7816ULL, 0x000fc4000000002aULL,
0x00001054892b7816ULL, 0x000fe40000000086ULL, 0x00000010ff297819ULL, 0x000fe40000011676ULL,
0x00000010ff287819ULL, 0x000fe40000011684ULL, 0x00000010ff867819ULL, 0x000fe20000011677ULL,
0x0000002a1030723cULL, 0x000fe20000041830ULL, 0x0000105429287816ULL, 0x000fe40000000028ULL,
0x0000105486297816ULL, 0x000fc40000000085ULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff2a7819ULL, 0x000fe2000001167eULL,
0x00000028102c723cULL, 0x000fe2000004182cULL, 0x00000010ff2b7819ULL, 0x000fe4000001167fULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff7e7819ULL, 0x000fe40000011679ULL, 0x00000010ff297819ULL, 0x000fe2000001167bULL,
0x000000751c1c9231ULL, 0x082fe200003400ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x000000751e1e9231ULL, 0x000fe200003400ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x000000741d1d9231ULL, 0x080fe200003400ffULL, 0x0000007cff95723eULL, 0x000fe200020006ffULL,
0x20000072ff7c7230ULL, 0x000fe20000004100ULL, 0x00001054812a7816ULL, 0x000fe2000000002aULL,
0x20000073ff727230ULL, 0x000fe20000004100ULL, 0x00001054822b7816ULL, 0x000fe2000000002bULL,
0x20000095ff737230ULL, 0x000fe20000004100ULL, 0x0000105480287816ULL, 0x000fe20000000083ULL,
0x000000741f1f9231ULL, 0x000fe200003400ffULL, 0x000010547e297816ULL, 0x000fc40000000029ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x0000002a1020723cULL, 0x040fe20000041820ULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x000000ff698f7812ULL, 0x000fe200078ec0ffULL,
0x20000093ff697230ULL, 0x000fe20000004100ULL, 0x000000ff6a907812ULL, 0x000fe200078ec0ffULL,
0x20000094ff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x000000281010723cULL, 0x000fe20000041824ULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000010ff257819ULL, 0x000fe40000011670ULL, 0x00000010ff247819ULL, 0x000fe20000011672ULL,
0x2000008fff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe40000011671ULL,
0x0000105425247816ULL, 0x000fc40000000024ULL, 0x0000105426257816ULL, 0x000fe40000000073ULL,
0x00000010ff267819ULL, 0x000fe40000011667ULL, 0x00000010ff277819ULL, 0x000fe40000011668ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x000000241c3c723cULL, 0x000fe2000004183cULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x0000105469267816ULL, 0x000fe20000000026ULL,
0x20000090ff6c7230ULL, 0x000fe20000004100ULL, 0x000010546a277816ULL, 0x000fe20000000027ULL,
0x2000008bff777230ULL, 0x000fe20000004100ULL, 0x000000ff87877812ULL, 0x000fc400078ec0ffULL,
0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6d7819ULL, 0x000fe2000001166dULL,
0x000000261c38723cULL, 0x000fe20000041838ULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff247819ULL, 0x000fe40000011666ULL,
0x00000010ff277819ULL, 0x000fc40000011662ULL, 0x00000010ff267819ULL, 0x000fe4000001166eULL,
0x00000010ff257819ULL, 0x000fe40000011665ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff287819ULL, 0x000fe40000011663ULL,
0x00000010ff777819ULL, 0x000fc40000011677ULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000087ff767230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000105427267816ULL, 0x000fe20000000026ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x000010546b247816ULL, 0x000fc40000000024ULL, 0x000010546c257816ULL, 0x000fe20000000025ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000105428277816ULL, 0x000fe40000000077ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000010ff787819ULL, 0x000fe20000011678ULL,
0x000000241c30723cULL, 0x000fe20000041830ULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fc4000001167cULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff247819ULL, 0x000fe20000011660ULL,
0x000000261c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff257819ULL, 0x000fe40000011676ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff267819ULL, 0x000fc40000011617ULL, 0x00000010ff167819ULL, 0x000fe40000011616ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff177819ULL, 0x000fe40000011661ULL,
0x00000010ff157819ULL, 0x000fe40000011615ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff147819ULL, 0x000fc40000011614ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x0000105425247816ULL, 0x000fe40000000024ULL, 0x00001054792a7816ULL, 0x000fe40000000078ULL,
0x000010547d2b7816ULL, 0x000fe4000000007aULL, 0x000010546f257816ULL, 0x000fe4000000005eULL,
0x0000105416167816ULL, 0x000fc4000000006dULL, 0x0000105426177816ULL, 0x000fe20000000017ULL,
0x0000002a1c40723cULL, 0x000fe20000041840ULL, 0x0000105415647816ULL, 0x000fe40000000064ULL,
0x0000105414657816ULL, 0x000fca000000004fULL, 0x000000241c20723cULL, 0x040ff00000041820ULL,
0x000000161c34723cULL, 0x040ff00000041834ULL, 0x000000641c1c723cULL, 0x000fe20000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000004051107811ULL, 0x000fe200078e40ffULL, 0x00000100ff257424ULL, 0x000fe200078e00ffULL,
0x00000004ff177819ULL, 0x000fe40000011600ULL, 0x0000001047117217ULL, 0x000fe20007800000ULL,
0x0000620045167a24ULL, 0x000fe200078e0210ULL, 0x0000c0000f0f7811ULL, 0x000fc600078e20ffULL,
0x0000000111117824ULL, 0x000fe400078e0a10ULL, 0x0000000105107824ULL, 0x100fe400078e0216ULL,
0x000000010a127824ULL, 0x100fe200078e0216ULL, 0x0000002011117807ULL, 0x000fe20000000000ULL,
0x000000010b147824ULL, 0x100fe400078e0216ULL, 0x000000010c167824ULL, 0x000fe200078e0216ULL,
0x0000001144137217ULL, 0x000fe20007800000ULL, 0x00005e0010107625ULL, 0x000fc800078e0025ULL,
0x0000000113287824ULL, 0x000fe200078e0a44ULL, 0x0000000610247210ULL, 0x000fe20007f7e0ffULL,
0x00005e0012127625ULL, 0x080fe200078e0025ULL, 0x0000c0004e107811ULL, 0x000fe400078e20ffULL,
0x000000281700720cULL, 0x000fe20003f46070ULL, 0x00005e0014147625ULL, 0x080fe200078e0025ULL,
0x0000000612267210ULL, 0x080fe40007f9e0ffULL, 0x0000c0004b127811ULL, 0x000fe200078e20ffULL,
0x00005e0016167625ULL, 0x000fe200078e0025ULL, 0x0000000614147210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff257224ULL, 0x000fe200018e0611ULL, 0x000000280700720cULL, 0x080fe20003f66070ULL,
0x000000ffff277224ULL, 0x000fe200020e0613ULL, 0x000000280800720cULL, 0x080fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200028e0615ULL, 0x000000280900720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000240f7faeULL, 0x0003e2000d101c46ULL,
0x0000000616167210ULL, 0x000fe40007fde0ffULL, 0x0000c0004d117811ULL, 0x000fc600078e20ffULL,
0x000000ffff177224ULL, 0x000fe400030e0617ULL, 0x0000000026107faeULL, 0x0003e8000d901c46ULL,
0x0000000014117faeULL, 0x0003e8000e101c46ULL, 0x0000000016127faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff147984ULL, 0x002e620000000800ULL,
0x0000ffff5f137812ULL, 0x000fc800078ec0ffULL, 0x0000888013157816ULL, 0x000fca00000000ffULL,
0x8000000015137824ULL, 0x000fca00078e00ffULL, 0x8000000014ff7812ULL, 0x002fe20007844813ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x01065400ff147984ULL, 0x000e620000000800ULL, 0x8000000015137824ULL, 0x000fca00078e00ffULL,
0x8000000014ff7812ULL, 0x002fe20007844813ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000015147824ULL, 0x000fe400078e00ffULL,
0x3e000000ff137424ULL, 0x000fc800078e00ffULL, 0x0000001300157305ULL, 0x0002a4000021f000ULL,
0x3fa0000013137823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01065400ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007844814ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000e0004a137811ULL, 0x000fe400078e20ffULL, 0x0000e00049147811ULL, 0x000fe400078e20ffULL,
0x0000e00048157811ULL, 0x000fe200078e20ffULL, 0x000000001324783bULL, 0x000e620000004200ULL,
0x0000000708177812ULL, 0x100fe400078e784cULL, 0x00000007094d7812ULL, 0x000fe200078e784cULL,
0x000000001428783bULL, 0x000ea20000004200ULL, 0x0000e00018167811ULL, 0x000fe200078e20ffULL,
0x000000084c177824ULL, 0x040fe200078e0217ULL, 0x0000000dff95723eULL, 0x000fe200000010ffULL,
0x000000001548783bULL, 0x000ee20000004200ULL, 0x000000084c187824ULL, 0x000fe200078e024dULL,
0x00000002ff987819ULL, 0x000fc40000011600ULL, 0x00000000164c783bULL, 0x000f220000004200ULL,
0x0000541095957816ULL, 0x000fe40000000095ULL, 0x00000018ff637819ULL, 0x002fe40000011627ULL,
0x00000010ff847819ULL, 0x000fe40000011624ULL, 0x000000ff28807812ULL, 0x004fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe40000011628ULL, 0x000000ff2a797812ULL, 0x000fc400078ec0ffULL,
0x00000010ff757819ULL, 0x108fe40000011649ULL, 0x000000ff49717812ULL, 0x040fe400078ec0ffULL,
0x00000018ff747819ULL, 0x000fe40000011649ULL, 0x0000ffff496b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff486a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8a7819ULL, 0x010fc4000001164dULL,
0x000000ff4d8e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164dULL,
0x0000ffff4d6f7812ULL, 0x000fe400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000018ff777819ULL, 0x000fe40000011629ULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x00000061ff4d723eULL, 0x000fe200020006ffULL, 0x20000063ff617230ULL, 0x000fe20000004100ULL,
0x000000ff24627812ULL, 0x040fe200078ec0ffULL, 0x20000080ff637230ULL, 0x000fe20000004100ULL,
0x00000018ff687819ULL, 0x000fe40000011624ULL, 0x0000ffff24857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fe40000011625ULL, 0x000000ff258c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff877819ULL, 0x000fe40000011625ULL, 0x0000ffff25887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff827819ULL, 0x000fe40000011627ULL, 0x000000ff278f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff277d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2b7f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff6c7819ULL, 0x100fe4000001164aULL, 0x000000ff4a7b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a257812ULL, 0x000fe400078ec0ffULL,
0x00000010ff277819ULL, 0x000fe4000001164bULL, 0x000000ff4b677812ULL, 0x000fc400078ec0ffULL,
0x00000018ff667819ULL, 0x000fe4000001164bULL, 0x0000ffff4b247812ULL, 0x000fe400078ec0ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000010ff707819ULL, 0x100fe4000001164eULL,
0x000000ff4e4b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fc4000001164eULL,
0x0000ffff4e657812ULL, 0x000fe400078ec0ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000077ff4e723eULL, 0x000fe200020006ffULL, 0x2000004dff777230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000018ff697819ULL, 0x000fe40000011648ULL,
0x0000007fff80723eULL, 0x000fe200020006ffULL, 0x20000079ff7f7230ULL, 0x000fe20000004100ULL,
0x00000074ff4d723eULL, 0x000fe200020006ffULL, 0x2000006aff797230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fe20000011628ULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x0000ffff287c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff287819ULL, 0x100fe4000001162aULL,
0x00000018ff787819ULL, 0x000fe4000001162aULL, 0x0000ffff2a737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x100fe4000001162bULL, 0x00000018ff7a7819ULL, 0x000fe4000001162bULL,
0x0000ffff2b767812ULL, 0x000fc400078ec0ffULL, 0x0000007bff6a723eULL, 0x000fe200020006ffULL,
0x20000071ff7b7230ULL, 0x000fe20000004100ULL, 0x00000018ff2b7819ULL, 0x000fe2000001164fULL,
0x2000004dff717230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000ffff26837812ULL, 0x000fe200078ec0ffULL, 0x20000069ff747230ULL, 0x000fe20000004100ULL,
0x00000066ff4d723eULL, 0x000fe200020006ffULL, 0x20000067ff697230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fc400020006ffULL, 0x000000ff268d7812ULL, 0x000fe200078ec0ffULL,
0x2000004dff677230ULL, 0x000fe20000004100ULL, 0x0000002bff2b723eULL, 0x000fe200020006ffULL,
0x20000049ff4d7230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff7e7819ULL, 0x000fe20000011629ULL, 0x2000002bff497230ULL, 0x000fe20000004100ULL,
0x000000ff29817812ULL, 0x040fe400078ec0ffULL, 0x0000ffff29297812ULL, 0x000fc400078ec0ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x00000008ff837819ULL, 0x000fe40000011683ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000008cff937230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x2000008dff8c7230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000088ff947230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000008fff8d7230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000086ff967230ULL, 0x000fe20000004100ULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x20000082ff8f7230ULL, 0x000fe20000004100ULL, 0x00000008ff2b7819ULL, 0x000fc40000011629ULL,
0x0000a00017297811ULL, 0x000fe400078e20ffULL, 0x000000ff28287812ULL, 0x000fe400078ec0ffULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x0000006eff88723eULL, 0x000fe200020006ffULL,
0x20000083ff6e7230ULL, 0x000fe20000004100ULL, 0x0000002bff86723eULL, 0x000fe400020006ffULL,
0x00000028ff82723eULL, 0x000fe200020006ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000002aff83723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011626ULL, 0x000000002928783bULL, 0x000fe20000000200ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x20000087ff907230ULL, 0x000fe20000004100ULL,
0x000000ff89897812ULL, 0x000fe200078ec0ffULL, 0x20000081ff877230ULL, 0x000fe20000004100ULL,
0x000000ff7e7e7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001167cULL,
0x00000008ff767819ULL, 0x000fe40000011676ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000085ff917230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fc400020006ffULL,
0x00000078ff81723eULL, 0x000fe200020006ffULL, 0x2000004eff787230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x2000007cff857230ULL, 0x000fe20000004100ULL,
0x000000ff75757812ULL, 0x000fe200078ec0ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x0000008eff4e723eULL, 0x000fe200020006ffULL, 0x20000089ff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff4c8b7812ULL, 0x000fe200078ec0ffULL, 0x2000007eff897230ULL, 0x000fe20000004100ULL,
0x00000075ff7e723eULL, 0x000fe200020006ffULL, 0x20000076ff7c7230ULL, 0x000fe20000004100ULL,
0x00001f9895757589ULL, 0x000e6200000e0000ULL, 0x00000018ff607819ULL, 0x000fe20000011626ULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011648ULL,
0x00001f0e95767589ULL, 0x000ea200000e0000ULL, 0x0000ffff48267812ULL, 0x000fe200078ec0ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000018ff487819ULL, 0x000fc4000001164cULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000062ff92723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x2000005eff667230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fe2000001164cULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x0000ffff4c627812ULL, 0x000fe200078ec0ffULL, 0x2000008bff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fc400078ec0ffULL, 0x000000ff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x0000007528289231ULL, 0x082fe200003400ffULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x000000752a2a9231ULL, 0x000fe200003400ffULL,
0x00000008ff7d7819ULL, 0x000fe2000001167dULL, 0x0000007629299231ULL, 0x084fe200003400ffULL,
0x00000008ff6b7819ULL, 0x000fe2000001166bULL, 0x000000762b2b9231ULL, 0x000fe200003400ffULL,
0x000000ff72727812ULL, 0x000fc400078ec0ffULL, 0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000008ff267819ULL, 0x000fe40000011626ULL, 0x0000004cff8b723eULL, 0x000fe200020006ffULL,
0x20000048ff4c7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000084ff977230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fc400020006ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000073ff847230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000006bff737230ULL, 0x000fe20000004100ULL, 0x0000004aff48723eULL, 0x000fe200020006ffULL,
0x2000004bff4a7230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x2000008bff4b7230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000007dff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff27277812ULL, 0x000fe200078ec0ffULL,
0x20000072ff7d7230ULL, 0x000fe20000004100ULL, 0x00000008ff257819ULL, 0x000fe20000011625ULL,
0x2000006cff6b7230ULL, 0x000fe20000004100ULL, 0x00000027ff6c723eULL, 0x000fe200020006ffULL,
0x20000026ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe20000011692ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe20000011693ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff977819ULL, 0x000fe20000011697ULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000010ff967819ULL, 0x000fc40000011696ULL,
0x00000025ff92723eULL, 0x000fe400020006ffULL, 0x0000105497267816ULL, 0x000fe40000000026ULL,
0x0000105496277816ULL, 0x000fe40000000027ULL, 0x00000008ff957819ULL, 0x000fe40000011624ULL,
0x00000010ff257819ULL, 0x000fe20000011668ULL, 0x20000092ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe20000011691ULL, 0x000000262840723cULL, 0x000fe20000041840ULL,
0x00000010ff937819ULL, 0x000fc40000011690ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x0000105493257816ULL, 0x000fe20000000094ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff267819ULL, 0x000fe4000001168cULL, 0x00000010ff277819ULL, 0x000fc4000001168eULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x00000024283c723cULL, 0x000fe2000004183cULL,
0x00000010ff8c7819ULL, 0x000fe4000001168fULL, 0x0000105427267816ULL, 0x000fe40000000026ULL,
0x000010548c277816ULL, 0x000fe4000000008dULL, 0x00000010ff247819ULL, 0x000fe40000011661ULL,
0x00000010ff257819ULL, 0x000fc40000011660ULL, 0x00000010ff617819ULL, 0x000fe2000001168bULL,
0x000000262838723cULL, 0x000fe20000041838ULL, 0x00000010ff607819ULL, 0x000fe4000001166eULL,
0x0000a000188b7811ULL, 0x000fe400078e20ffULL, 0x0000105425607816ULL, 0x000fe40000000060ULL,
0x0000105424617816ULL, 0x000fe40000000061ULL, 0x000000008b24783bULL, 0x000e620000000200ULL,
0x000000ff8a8c7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff8a7819ULL, 0x000fe40000011662ULL,
0x00000010ff627819ULL, 0x000fe20000011663ULL, 0x000000602834723cULL, 0x000fe20000041834ULL,
0x00000010ff637819ULL, 0x000fe40000011688ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff887819ULL, 0x000fe40000011689ULL, 0x0000105463627816ULL, 0x000fc40000000062ULL,
0x0000105488637816ULL, 0x000fe40000000087ULL, 0x00000010ff617819ULL, 0x000fe40000011677ULL,
0x00000010ff607819ULL, 0x000fe40000011685ULL, 0x00000010ff877819ULL, 0x000fe20000011678ULL,
0x000000622830723cULL, 0x000fe20000041830ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x0000007aff7a723eULL, 0x000fc400020006ffULL, 0x0000105461607816ULL, 0x000fe40000000060ULL,
0x0000105487617816ULL, 0x000fe20000000086ULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe4000001167fULL, 0x00000010ff637819ULL, 0x000fe40000011682ULL,
0x00000010ff807819ULL, 0x000fe20000011680ULL, 0x00000060282c723cULL, 0x000fe2000004182cULL,
0x00000010ff837819ULL, 0x000fc40000011683ULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x0000007524249231ULL, 0x082fe200003400ffULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x0000007526269231ULL, 0x000fe200003400ffULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x0000007625259231ULL, 0x080fe200003400ffULL, 0x00000010ff617819ULL, 0x000fe2000001167cULL,
0x0000007627279231ULL, 0x000fe200003400ffULL, 0x0000105463627816ULL, 0x000fe40000000062ULL,
0x0000105483637816ULL, 0x000fc40000000080ULL, 0x0000105481607816ULL, 0x000fe40000000084ULL,
0x000010547a617816ULL, 0x000fe40000000061ULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x000000622820723cULL, 0x040fe20000041820ULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x000000ff6d907812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6f7819ULL, 0x000fe2000001166fULL,
0x20000095ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x00000060281c723cULL, 0x000fe2000004181cULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff297819ULL, 0x000fe40000011674ULL, 0x00000010ff287819ULL, 0x000fe20000011672ULL,
0x20000090ff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff2a7819ULL, 0x000fe40000011671ULL,
0x0000105429287816ULL, 0x000fc40000000028ULL, 0x000010542a297816ULL, 0x000fe40000000073ULL,
0x00000010ff2a7819ULL, 0x000fe4000001166aULL, 0x00000010ff2b7819ULL, 0x000fe40000011669ULL,
0x00000010ff607819ULL, 0x000fe20000011667ULL, 0x00000028243c723cULL, 0x000fe2000004183cULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000008aff777230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe20000011666ULL, 0x2000008cff787230ULL, 0x000fe20000004100ULL,
0x00000010ff287819ULL, 0x000fe20000011668ULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x000010546b2a7816ULL, 0x000fe4000000002aULL, 0x0000105429287816ULL, 0x000fe40000000028ULL,
0x000010546c2b7816ULL, 0x000fc4000000002bULL, 0x0000105460297816ULL, 0x000fe4000000006dULL,
0x00000010ff647819ULL, 0x000fe4000001164fULL, 0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x0000002a2438723cULL, 0x000fe20000041838ULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff2a7819ULL, 0x000fe2000001165eULL, 0x000000282434723cULL, 0x000fe20000041834ULL,
0x00000010ff2b7819ULL, 0x000fe4000001166eULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff297819ULL, 0x000fe4000001164cULL,
0x00000010ff287819ULL, 0x000fc40000011677ULL, 0x00000010ff617819ULL, 0x000fe40000011678ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164dULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000010542b2a7816ULL, 0x000fe2000000002aULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000105429287816ULL, 0x000fc40000000028ULL, 0x00001054612b7816ULL, 0x000fe2000000004eULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x000010544c297816ULL, 0x000fe4000000006fULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x0000002a2430723cULL, 0x000fe20000041830ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167dULL,
0x00000010ff7e7819ULL, 0x000fc4000001167eULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff2b7819ULL, 0x000fe20000011670ULL, 0x00000028242c723cULL, 0x000fe2000004182cULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff287819ULL, 0x000fc40000011649ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff497819ULL, 0x000fe4000001164fULL,
0x000010547c627816ULL, 0x000fe40000000079ULL, 0x000010547e637816ULL, 0x000fe4000000007bULL,
0x000010542b4a7816ULL, 0x000fe4000000004aULL, 0x00001054644b7816ULL, 0x000fc4000000004bULL,
0x0000105448487816ULL, 0x000fe20000000065ULL, 0x000000622440723cULL, 0x000fe20000041840ULL,
0x0000105428497816ULL, 0x000fce0000000049ULL, 0x0000004a2420723cULL, 0x040ff00000041820ULL,
0x000000482424723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000040511c7811ULL, 0x000fe200078e40ffULL,
0x01061000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff5fff7812ULL, 0x000fc4000782c0ffULL,
0x0000001c4700720cULL, 0x000fe40003f44070ULL, 0x00000001ff5f7807ULL, 0x000fd60000800000ULL,
0x0000b6200000a947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000060511c7811ULL, 0x000fe200078e40ffULL,
0x00000100ff4b7424ULL, 0x000fe200078e00ffULL, 0x00000004ff497819ULL, 0x000fe40000011600ULL,
0x0000001c471d7217ULL, 0x000fe20007800000ULL, 0x0000620045287a24ULL, 0x000fc800078e021cULL,
0x000000011d1d7824ULL, 0x000fe400078e0a1cULL, 0x00000001051c7824ULL, 0x100fe400078e0228ULL,
0x000000010a1e7824ULL, 0x000fe200078e0228ULL, 0x000000201d1f7807ULL, 0x000fe20000000000ULL,
0x00005e001c1c7625ULL, 0x000fc600078e004bULL, 0x0000001f44297217ULL, 0x000fe20007800000ULL,
0x00005e001e1e7625ULL, 0x000fe200078e004bULL, 0x000000061c2a7210ULL, 0x000fc60007f3e0ffULL,
0x0000000129487824ULL, 0x000fe200078e0a44ULL, 0x000000061e1e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010b1c7824ULL, 0x100fe400078e0228ULL, 0x000000010c287824ULL, 0x000fe200078e0228ULL,
0x000000484900720cULL, 0x080fe20003f46070ULL, 0x000000ffff2b7224ULL, 0x000fe200008e061dULL,
0x000000480700720cULL, 0x080fe20003f26070ULL, 0x00005e001c1c7625ULL, 0x000fe200078e004bULL,
0x000000480900720cULL, 0x000fc60003f86070ULL, 0x00005e0028287625ULL, 0x000fe200078e004bULL,
0x000000061c1c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x000000480800720cULL, 0x000fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x0000000628287210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a5d7faeULL, 0x0003e8000d101c46ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x000000001e5c7faeULL, 0x0003ea000c901c46ULL, 0x000000001c5b7faeULL, 0x0003e8000d901c46ULL,
0x00000000285a7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1d7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01061c00ff1e7984ULL, 0x000ea20000000800ULL, 0x000000ff04ff7812ULL, 0x000fe2000782c0ffULL,
0x80000000571f7824ULL, 0x000fc600078e00ffULL, 0x00000001ff5e7807ULL, 0x000fca0000800000ULL,
0x800000005e1c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x002fe4000782481cULL,
0x800000001eff7812ULL, 0x004fe2000784481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x80000000571e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01061c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01008000591c7984ULL, 0x000e620000000800ULL, 0x00000001ff627424ULL, 0x000fc600078e00ffULL,
0x01028000591d7984ULL, 0x0004e20000000800ULL, 0x0000001b1c00720bULL, 0x002fda0003f5d000ULL,
0x00000000001e7806ULL, 0x000fc800010e0100ULL, 0x0000ffff1e287812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x0000001b1c00720bULL, 0x00cfe40003f54000ULL,
0x0000001c1b1e7209ULL, 0x000fe40007810000ULL, 0x00000002ff2a7819ULL, 0x000fc60000011600ULL,
0x8000001e1b1f7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fe40000410000ULL,
0x00000000001b7806ULL, 0x000fe400010e0100ULL, 0x000000015000780cULL, 0x000fe40003f45270ULL,
0x0000ffff1b297812ULL, 0x000fe200078e3cffULL, 0x0000001f001f7308ULL, 0x000e660000000800ULL,
0x0000002928ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff627807ULL, 0x000fc60001800000ULL,
0x0104801e5900a388ULL, 0x000fe80000000800ULL, 0x00001f2a1f1b7589ULL, 0x002e6400000e0000ULL,
0x8000001e1c283221ULL, 0x000fe20000010000ULL, 0x0000001f1a1a7220ULL, 0x000fe20000410000ULL,
0x00001f0e1f1c7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b28283820ULL, 0x000fc80000410000ULL,
0x00000028000d3308ULL, 0x000ee20000000800ULL, 0x0000001b40407220ULL, 0x082fe20000410000ULL,
0x0000001b41417220ULL, 0x080fe20000410000ULL, 0x0000001b3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001b3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001b38387220ULL, 0x080fe20000410000ULL,
0x0000001b39397220ULL, 0x080fe20000410000ULL, 0x0000001b34347220ULL, 0x080fe20000410000ULL,
0x0000001b35357220ULL, 0x080fe20000410000ULL, 0x0000001b30307220ULL, 0x080fe20000410000ULL,
0x0000001b31317220ULL, 0x080fe20000410000ULL, 0x0000001b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001b20207220ULL, 0x080fe20000410000ULL,
0x0000001b21217220ULL, 0x080fe20000410000ULL, 0x0000001b24247220ULL, 0x080fe20000410000ULL,
0x0000001b25257220ULL, 0x000fe20000410000ULL, 0x0000001c42427220ULL, 0x084fe20000410000ULL,
0x0000001c43437220ULL, 0x080fe20000410000ULL, 0x0000001c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001c36367220ULL, 0x080fe20000410000ULL,
0x0000001c37377220ULL, 0x080fe20000410000ULL, 0x0000001c32327220ULL, 0x080fe20000410000ULL,
0x0000001c33337220ULL, 0x080fe20000410000ULL, 0x0000001c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001c22227220ULL, 0x080fe20000410000ULL,
0x0000001c23237220ULL, 0x080fe20000410000ULL, 0x0000001c26267220ULL, 0x080fe20000410000ULL,
0x0000001c27277220ULL, 0x000fe20000410000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e001eULL,
0x0000001d0d1d3220ULL, 0x008fc80000410000ULL, 0x0000001a1d1a7221ULL, 0x00cfe20000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x01064c00ff1c7984ULL, 0x000e620000000800ULL,
0x800000005e1d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x002fe2000782481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x800000005e1e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01064c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000005628783bULL, 0x000e620000004200ULL,
0x0000000dff95723eULL, 0x000fe400000010ffULL, 0x00000002ff987819ULL, 0x000fe20000011600ULL,
0x000000005548783bULL, 0x000ea20000004200ULL, 0x0000541095957816ULL, 0x000fc60000000095ULL,
0x00000000544c783bULL, 0x000ee80000004200ULL, 0x00000000581c783bULL, 0x000f220000004200ULL,
0x00000010ff7d7819ULL, 0x102fe40000011628ULL, 0x000000ff28877812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe40000011628ULL, 0x0000ffff287c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff287819ULL, 0x100fe4000001162aULL, 0x000000ff2a7a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe4000001162aULL, 0x0000ffff2a737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x000fe4000001162bULL, 0x000000ff2b807812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001162bULL, 0x0000ffff2b767812ULL, 0x000fe400078ec0ffULL,
0x00009910622b7816ULL, 0x000fe400000000ffULL, 0x00000010ff757819ULL, 0x104fe40000011649ULL,
0x000000ff49747812ULL, 0x000fe400078ec0ffULL, 0x00000018ff797819ULL, 0x000fc40000011649ULL,
0x0000ffff496b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x108fe4000001164dULL,
0x000000ff4d8b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164dULL,
0x0000ffff4d6f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e002bULL,
0x000000ff1e687812ULL, 0x010fc400078ec0ffULL, 0x000000ff1f8c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d00720cULL, 0x000fe40003f25270ULL, 0x00000068ff4d723eULL, 0x000fe400020006ffULL,
0x00000010ff6e7819ULL, 0x100fe4000001161cULL, 0x000000ff1c637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fc4000001161cULL, 0x0000ffff1c827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x100fe4000001161dULL, 0x000000ff1d8f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001161dULL, 0x0000ffff1d847812ULL, 0x000fe400078ec0ffULL,
0x00000010ff857819ULL, 0x000fc4000001161fULL, 0x00000018ff617819ULL, 0x000fe4000001161fULL,
0x0000ffff1f7e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe40000011629ULL,
0x00000010ff6c7819ULL, 0x100fe4000001164aULL, 0x000000ff4a7b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fc4000001164aULL, 0x0000ffff4a1d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1f7819ULL, 0x100fe4000001164bULL, 0x000000ff4b677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff667819ULL, 0x000fe4000001164bULL, 0x0000ffff4b1c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x000fc4000001164eULL, 0x000000ff4e4b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164eULL, 0x0000ffff4e657812ULL, 0x000fe400078ec0ffULL,
0x0000008cff4e723eULL, 0x000fe200020006ffULL, 0x2000004dff8c7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000077ff4d723eULL, 0x000fc400020006ffULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000081ff777230ULL, 0x000fe20000004100ULL,
0x00000078ff81723eULL, 0x000fe200020006ffULL, 0x2000004dff787230ULL, 0x000fe20000004100ULL,
0x0000007fff4d723eULL, 0x000fe200020006ffULL, 0x2000007aff7f7230ULL, 0x000fe20000004100ULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000018ff2b7819ULL, 0x000fe2000001164fULL, 0x2000004dff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe2000001161eULL, 0x2000008dff907230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x2000004eff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff837819ULL, 0x000fc40000011629ULL, 0x00000079ff4d723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x000000ff29887812ULL, 0x040fe400078ec0ffULL, 0x0000007bff4e723eULL, 0x000fe200020006ffULL,
0x20000074ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL,
0x2000004dff747230ULL, 0x000fe20000004100ULL, 0x0000ffff29297812ULL, 0x000fe200078ec0ffULL,
0x20000049ff4d7230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x2000002bff497230ULL, 0x000fe20000004100ULL, 0x000000ff86867812ULL, 0x000fc400078ec0ffULL,
0x000000ff83837812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x000000ff48717812ULL, 0x000fe400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000008eff687230ULL, 0x000fe20000004100ULL, 0x00000018ff697819ULL, 0x000fe40000011648ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x2000008aff8e7230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fc400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000082ff937230ULL, 0x000fe20000004100ULL, 0x00000008ff2b7819ULL, 0x000fe20000011629ULL,
0x20000086ff967230ULL, 0x000fe20000004100ULL, 0x0000a80053297811ULL, 0x000fe200078e20ffULL,
0x20000083ff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff28287812ULL, 0x000fe400078ec0ffULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000018ff607819ULL, 0x000fe2000001161eULL,
0x20000071ff797230ULL, 0x000fe20000004100ULL, 0x0000ffff1e897812ULL, 0x000fe200078ec0ffULL,
0x20000069ff717230ULL, 0x000fe20000004100ULL, 0x0000002bff86723eULL, 0x000fe200020006ffULL,
0x2000004eff697230ULL, 0x000fe20000004100ULL, 0x00000028ff82723eULL, 0x000fe400020006ffULL,
0x0000002aff83723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011648ULL, 0x000000002928783bULL, 0x000fe20000000200ULL,
0x0000ffff481e7812ULL, 0x000fe200078ec0ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x000000ff4c6a7812ULL, 0x000fe200078ec0ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x00000018ff487819ULL, 0x100fe4000001164cULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000063ff91723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000010ff6d7819ULL, 0x000fe2000001164cULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x0000ffff4c637812ULL, 0x000fc400078ec0ffULL,
0x000000ff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x0000006aff4e723eULL, 0x000fe200020006ffULL,
0x20000067ff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff85857812ULL, 0x000fe200078ec0ffULL,
0x2000005fff677230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x2000008bff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff7e7819ULL, 0x000fe2000001167eULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fc4000001167cULL,
0x00000008ff767819ULL, 0x000fe40000011676ULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x0000004cff8b723eULL, 0x000fe200020006ffULL,
0x20000048ff4c7230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x2000008fff927230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fc400020006ffULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000085ff8f7230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x000000ff75757812ULL, 0x000fe200078ec0ffULL,
0x2000007cff857230ULL, 0x000fe20000004100ULL, 0x0000004aff48723eULL, 0x000fe200020006ffULL,
0x2000004bff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x2000008bff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL,
0x2000007eff8b7230ULL, 0x000fe20000004100ULL, 0x00000075ff7e723eULL, 0x000fe200020006ffULL,
0x20000076ff7c7230ULL, 0x000fe20000004100ULL, 0x00001f9895757589ULL, 0x000e6200000e0000ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x00001f0e95767589ULL, 0x000ea200000e0000ULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff6b7819ULL, 0x000fe2000001166bULL, 0x2000006eff977230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fc40000011673ULL, 0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff897819ULL, 0x000fe40000011689ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000008ff1e7819ULL, 0x000fe4000001161eULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x0000007528289231ULL, 0x082fe200003400ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000084ff947230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x000000752a2a9231ULL, 0x000fe200003400ffULL, 0x00000089ff6e723eULL, 0x000fe200020006ffULL,
0x2000007dff897230ULL, 0x000fe20000004100ULL, 0x0000001eff1e723eULL, 0x000fe200020006ffULL,
0x20000072ff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff1f1f7812ULL, 0x000fe200078ec0ffULL,
0x2000006bff727230ULL, 0x000fe20000004100ULL, 0x00000008ff1d7819ULL, 0x000fe2000001161dULL,
0x20000073ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff977819ULL, 0x000fe20000011697ULL,
0x2000006cff6b7230ULL, 0x000fe20000004100ULL, 0x0000001fff6c723eULL, 0x000fe200020006ffULL,
0x2000001eff737230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe20000011691ULL,
0x0000007629299231ULL, 0x084fe200003400ffULL, 0x00000010ff1f7819ULL, 0x000fe20000011692ULL,
0x000000762b2b9231ULL, 0x000fe200003400ffULL, 0x00000010ff967819ULL, 0x000fe20000011696ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x0000001dff92723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00001054971e7816ULL, 0x000fc4000000001eULL,
0x00001054961f7816ULL, 0x000fe4000000001fULL, 0x00000008ff957819ULL, 0x000fe4000001161cULL,
0x00000010ff1d7819ULL, 0x000fe20000011668ULL, 0x20000092ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe20000011693ULL, 0x0000001e2840723cULL, 0x000fe20000041840ULL,
0x00000010ff917819ULL, 0x000fe40000011690ULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x000010541d1c7816ULL, 0x000fe2000000001cULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00001054911d7816ULL, 0x000fe20000000094ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fe4000001168cULL, 0x00000010ff1f7819ULL, 0x000fc4000001168eULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x0000001c283c723cULL, 0x000fe2000004183cULL,
0x00000010ff8c7819ULL, 0x000fe4000001168fULL, 0x000010541f1e7816ULL, 0x000fe4000000001eULL,
0x000010548c1f7816ULL, 0x000fe4000000008dULL, 0x00000010ff1c7819ULL, 0x000fe40000011661ULL,
0x00000010ff1d7819ULL, 0x000fc40000011660ULL, 0x00000010ff617819ULL, 0x000fe2000001168bULL,
0x0000001e2838723cULL, 0x000fe20000041838ULL, 0x00000010ff607819ULL, 0x000fe4000001166eULL,
0x0000a800528b7811ULL, 0x000fe400078e20ffULL, 0x000010541d607816ULL, 0x000fe40000000060ULL,
0x000010541c617816ULL, 0x000fe40000000061ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x000000008b1c783bULL, 0x000e620000000200ULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x000000ff628d7812ULL, 0x000fe200078ec0ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff8c7819ULL, 0x000fe20000011663ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x000000602834723cULL, 0x000fe20000041834ULL,
0x00000010ff627819ULL, 0x000fe40000011687ULL, 0x00000010ff637819ULL, 0x000fe40000011688ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x00000010ff617819ULL, 0x000fe40000011677ULL,
0x00000010ff607819ULL, 0x000fe40000011685ULL, 0x00000010ff877819ULL, 0x000fe40000011678ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x0000105489627816ULL, 0x000fc40000000062ULL, 0x000010548a637816ULL, 0x000fe20000000063ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000105461607816ULL, 0x000fe40000000060ULL,
0x0000105487617816ULL, 0x000fe40000000086ULL, 0x00000010ff807819ULL, 0x000fe20000011680ULL,
0x000000622830723cULL, 0x000fe20000041830ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff817819ULL, 0x000fc40000011681ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x000000751c1c9231ULL, 0x082fe200003400ffULL, 0x00000010ff627819ULL, 0x000fe2000001167fULL,
0x00000060282c723cULL, 0x000fe2000004182cULL, 0x00000010ff637819ULL, 0x000fe20000011682ULL,
0x000000751e1e9231ULL, 0x000fe200003400ffULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x000000761d1d9231ULL, 0x080fe200003400ffULL, 0x0000105463627816ULL, 0x000fe20000000062ULL,
0x000000761f1f9231ULL, 0x000fe200003400ffULL, 0x00000010ff617819ULL, 0x000fc4000001167cULL,
0x0000105483637816ULL, 0x000fe40000000080ULL, 0x0000105481607816ULL, 0x000fe40000000084ULL,
0x000010547a617816ULL, 0x000fe40000000061ULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x000000622820723cULL, 0x000fe20000041820ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x000000ff6d907812ULL, 0x000fe200078ec0ffULL, 0x000000602828723cULL, 0x000fe20000041824ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff6f7819ULL, 0x000fe2000001166fULL,
0x20000095ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff247819ULL, 0x000fc40000011673ULL,
0x00000010ff257819ULL, 0x000fe40000011672ULL, 0x0000105471247816ULL, 0x000fe40000000024ULL,
0x0000105474257816ULL, 0x000fe40000000025ULL, 0x00000010ff267819ULL, 0x000fe40000011669ULL,
0x00000010ff277819ULL, 0x000fe4000001166aULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000241c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff247819ULL, 0x000fe20000011668ULL, 0x2000008cff777230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe2000001166dULL, 0x20000090ff6e7230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x0000105467247816ULL, 0x000fe20000000024ULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x0000105466257816ULL, 0x000fe20000000025ULL, 0x2000008dff787230ULL, 0x000fe20000004100ULL,
0x000010546b267816ULL, 0x000fe40000000026ULL, 0x000010546c277816ULL, 0x000fe40000000027ULL,
0x00000010ff647819ULL, 0x000fe2000001164fULL, 0x000000241c34723cULL, 0x000fe20000041834ULL,
0x0000ffff4f4f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff657819ULL, 0x000fe20000011665ULL,
0x000000261c38723cULL, 0x000fe20000041838ULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff257819ULL, 0x000fe4000001164cULL, 0x00000010ff247819ULL, 0x000fc40000011677ULL,
0x00000010ff267819ULL, 0x000fe4000001164eULL, 0x00000010ff277819ULL, 0x000fe4000001166eULL,
0x00000010ff4c7819ULL, 0x000fe4000001164dULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff787819ULL, 0x000fc40000011678ULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000105425247816ULL, 0x000fe20000000024ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000105427267816ULL, 0x000fe20000000026ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000010544c257816ULL, 0x000fc4000000006fULL, 0x0000105478277816ULL, 0x000fe4000000005fULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x000000241c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff7c7819ULL, 0x000fe4000001167dULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff247819ULL, 0x000fe20000011649ULL, 0x000000261c30723cULL, 0x000fe20000041830ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff277819ULL, 0x000fe40000011670ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff497819ULL, 0x000fe4000001164fULL,
0x000010547c627816ULL, 0x000fe40000000079ULL, 0x000010547e637816ULL, 0x000fe4000000007bULL,
0x00001054274a7816ULL, 0x000fe4000000004aULL, 0x00001054644b7816ULL, 0x000fe4000000004bULL,
0x0000105448487816ULL, 0x000fe20000000065ULL, 0x000000621c40723cULL, 0x000fe20000041840ULL,
0x0000105424497816ULL, 0x000fce0000000049ULL, 0x0000004a1c20723cULL, 0x040ff00000041820ULL,
0x000000481c28723cULL, 0x000fe20000041828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x00000080511c7811ULL, 0x000fe200078e40ffULL,
0x00000100ff4b7424ULL, 0x000fe200078e00ffULL, 0x00000004ff497819ULL, 0x000fe40000011600ULL,
0x0000001c471d7217ULL, 0x000fe20007800000ULL, 0x0000620045277a24ULL, 0x000fc800078e021cULL,
0x000000011d1d7824ULL, 0x000fe400078e0a1cULL, 0x00000001051c7824ULL, 0x100fe400078e0227ULL,
0x000000010a1e7824ULL, 0x100fe200078e0227ULL, 0x000000201d1f7807ULL, 0x000fe20000000000ULL,
0x000000010b247824ULL, 0x000fe400078e0227ULL, 0x00005e001c1c7625ULL, 0x000fe200078e004bULL,
0x0000001f44257217ULL, 0x000fc60007800000ULL, 0x00005e001e1e7625ULL, 0x000fe200078e004bULL,
0x000000061c267210ULL, 0x000fc60007f5e0ffULL, 0x0000000125487824ULL, 0x000fe200078e0a44ULL,
0x000000061e1e7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0024247625ULL, 0x000fc600078e004bULL,
0x000000480700720cULL, 0x000fe20003f66070ULL, 0x000000010c1c7824ULL, 0x000fe200078e0227ULL,
0x0000000624247210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff277224ULL, 0x000fe200010e061dULL,
0x000000484900720cULL, 0x000fe20003f46070ULL, 0x00005e001c1c7625ULL, 0x000fc800078e004bULL,
0x000000ffff1f7224ULL, 0x000fe200020e061fULL, 0x000000480800720cULL, 0x080fe20003f86070ULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x000000480900720cULL, 0x000fe40003fa6070ULL,
0x000000061c1c7210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000260f7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff1d7224ULL, 0x000fe400030e061dULL,
0x000000001e107faeULL, 0x0003e8000d901c46ULL, 0x0000000024117faeULL, 0x0003e8000e101c46ULL,
0x000000001c127faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff1c7984ULL, 0x002e620000000800ULL, 0x800000005e1d7824ULL, 0x000fca00078e00ffULL,
0x800000001cff7812ULL, 0x002fe2000784481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x01065400ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000784481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x800000005e1e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01065400ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000000131c783bULL, 0x000e620000004200ULL, 0x0000000dff95723eULL, 0x000fe400000010ffULL,
0x00000002ff987819ULL, 0x000fe20000011600ULL, 0x000000001424783bULL, 0x000ea20000004200ULL,
0x0000541095957816ULL, 0x000fc60000000095ULL, 0x000000001548783bULL, 0x000ee80000004200ULL,
0x00000000164c783bULL, 0x000f220000004200ULL, 0x00000018ff887819ULL, 0x002fe4000001161dULL,
0x00000010ff897819ULL, 0x000fe4000001161eULL, 0x000000ff24817812ULL, 0x004fe400078ec0ffULL,
0x000000ff1e8d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe4000001161eULL,
0x0000ffff1e827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7e7819ULL, 0x100fe4000001161fULL,
0x000000ff1f8e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe4000001161fULL,
0x0000ffff1f7c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff807819ULL, 0x100fe40000011624ULL,
0x00000018ff777819ULL, 0x000fe40000011625ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000010ff6e7819ULL, 0x000fe40000011624ULL, 0x0000ffff241f7812ULL, 0x000fe200078ec0ffULL,
0x20000088ff907230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fc40000011627ULL,
0x000000ff277f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011627ULL,
0x0000ffff27767812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x108fe40000011649ULL,
0x000000ff49717812ULL, 0x000fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fc40000011649ULL,
0x0000ffff496b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff25877812ULL, 0x000fe400078ec0ffULL,
0x000000ff26797812ULL, 0x000fe400078ec0ffULL, 0x00000010ff277819ULL, 0x100fe4000001164bULL,
0x000000ff4b677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff667819ULL, 0x000fc4000001164bULL,
0x0000ffff4b247812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6d7819ULL, 0x110fe4000001164cULL,
0x000000ff4c8a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164cULL,
0x0000ffff4c637812ULL, 0x000fe400078ec0ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x000000ff486a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff707819ULL, 0x100fe4000001164eULL,
0x000000ff4e4c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001164eULL,
0x0000ffff4e657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fc40000011626ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000077ff4e723eULL, 0x000fe400020006ffULL,
0x00000087ff88723eULL, 0x000fe200020006ffULL, 0x20000081ff877230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000080ff777230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000078ff81723eULL, 0x000fe200020006ffULL, 0x2000004eff787230ULL, 0x000fe20000004100ULL,
0x000000ff4a7b7812ULL, 0x000fc400078ec0ffULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000018ff697819ULL, 0x000fe40000011648ULL,
0x0000007fff80723eULL, 0x000fe200020006ffULL, 0x20000079ff7f7230ULL, 0x000fe20000004100ULL,
0x00000074ff4e723eULL, 0x000fe200020006ffULL, 0x2000006aff797230ULL, 0x000fe20000004100ULL,
0x000000ff1c627812ULL, 0x000fe200078ec0ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x000000ff4d8b7812ULL, 0x000fc400078ec0ffULL, 0x0000007bff6a723eULL, 0x000fe200020006ffULL,
0x20000071ff7b7230ULL, 0x000fe20000004100ULL, 0x00000018ff5f7819ULL, 0x000fe2000001164aULL,
0x2000004eff717230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x100fe4000001161cULL,
0x00000018ff687819ULL, 0x000fe2000001161cULL, 0x20000069ff747230ULL, 0x000fe20000004100ULL,
0x0000ffff1c847812ULL, 0x000fc400078ec0ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000010ff7d7819ULL, 0x000fe40000011625ULL, 0x0000ffff251c7812ULL, 0x000fe200078ec0ffULL,
0x20000067ff697230ULL, 0x000fe20000004100ULL, 0x00000066ff4e723eULL, 0x000fe400020006ffULL,
0x00000010ff6c7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a257812ULL, 0x000fe200078ec0ffULL,
0x2000004eff677230ULL, 0x000fe20000004100ULL, 0x00000062ff92723eULL, 0x000fc400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x100fe2000001164dULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000018ff4a7819ULL, 0x000fe2000001164dULL,
0x2000008bff4e7230ULL, 0x000fe20000004100ULL, 0x0000ffff4d6f7812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x000000ff4f4d7812ULL, 0x000fc400078ec0ffULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000005fff667230ULL, 0x000fe20000004100ULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x000000ff1d8c7812ULL, 0x040fe200078ec0ffULL,
0x2000008aff5f7230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000ffff1d857812ULL, 0x000fe400078ec0ffULL, 0x0000004dff8b723eULL, 0x000fc400020006ffULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000004cff8a723eULL, 0x000fe200020006ffULL,
0x20000049ff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe2000001161dULL,
0x2000008cff937230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x000000ff83837812ULL, 0x000fe400078ec0ffULL, 0x00000008ff857819ULL, 0x000fe20000011685ULL,
0x2000008dff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff1d7819ULL, 0x000fe40000011626ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x0000004bff49723eULL, 0x000fe200020006ffULL, 0x2000008bff4b7230ULL, 0x000fe20000004100ULL,
0x00000008ff1f7819ULL, 0x000fe2000001161fULL, 0x2000007cff8b7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000008eff8d7230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fc400020006ffULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000089ff8e7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x20000083ff977230ULL, 0x000fe20000004100ULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x20000085ff947230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe4000001161cULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x0000a800171c7811ULL, 0x000fc400078e20ffULL,
0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL, 0x2000001fff857230ULL, 0x000fe20000004100ULL,
0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000006eff89723eULL, 0x000fe200020006ffULL,
0x20000082ff6e7230ULL, 0x000fe20000004100ULL, 0x0000001dff82723eULL, 0x000fe400020006ffULL,
0x0000001eff83723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x000000ff86867812ULL, 0x000fe200078ec0ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff767819ULL, 0x000fc40000011676ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000086ff967230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x2000007eff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff75757812ULL, 0x000fe200078ec0ffULL, 0x2000007cff867230ULL, 0x000fe20000004100ULL,
0x0000ffff26737812ULL, 0x000fe200078ec0ffULL, 0x20000076ff7c7230ULL, 0x000fe20000004100ULL,
0x00000075ff7e723eULL, 0x000fe200020006ffULL, 0x00001f0e95767589ULL, 0x000e6200000e0000ULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x00000010ff727819ULL, 0x000fe20000011648ULL,
0x00001f9895757589ULL, 0x000ea200000e0000ULL, 0x0000ffff48267812ULL, 0x000fe200078ec0ffULL,
0x2000004aff4d7230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe20000011684ULL,
0x2000008aff4a7230ULL, 0x000fe20000004100ULL, 0x00000018ff487819ULL, 0x000fe2000001164fULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x000000ff7d7d7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe4000001166bULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000008ff267819ULL, 0x000fe20000011626ULL,
0x000000761d1d9231ULL, 0x082fe200003400ffULL, 0x00000048ff8a723eULL, 0x000fe200020006ffULL,
0x20000049ff487230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000084ff917230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000008aff497230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000073ff847230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000007dff8a7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000006bff737230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x20000072ff7d7230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000006cff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff27277812ULL, 0x000fe200078ec0ffULL,
0x20000026ff727230ULL, 0x000fe20000004100ULL, 0x00000008ff257819ULL, 0x000fe20000011625ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000027ff6c723eULL, 0x000fe200020006ffULL,
0x000000751c1c9231ULL, 0x084fe200003400ffULL, 0x00000010ff267819ULL, 0x000fe20000011692ULL,
0x000000751e1e9231ULL, 0x000fe200003400ffULL, 0x00000010ff277819ULL, 0x000fe20000011693ULL,
0x000000761f1f9231ULL, 0x000fe200003400ffULL, 0x00000010ff977819ULL, 0x000fe20000011697ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff967819ULL, 0x000fc40000011696ULL,
0x00000025ff92723eULL, 0x000fe400020006ffULL, 0x0000105497267816ULL, 0x000fe40000000026ULL,
0x0000105496277816ULL, 0x000fe40000000027ULL, 0x00000008ff957819ULL, 0x000fe40000011624ULL,
0x00000010ff257819ULL, 0x000fe20000011668ULL, 0x20000092ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe20000011691ULL, 0x000000261c40723cULL, 0x000fe20000041840ULL,
0x00000010ff937819ULL, 0x000fc40000011690ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000105425247816ULL, 0x000fe20000000024ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000105493257816ULL, 0x000fe20000000094ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff267819ULL, 0x000fc4000001168cULL, 0x00000010ff277819ULL, 0x000fe4000001168eULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x000000241c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff8c7819ULL, 0x000fe4000001168fULL, 0x0000105427267816ULL, 0x000fe40000000026ULL,
0x000010548c277816ULL, 0x000fe4000000008dULL, 0x00000010ff247819ULL, 0x000fc40000011661ULL,
0x00000010ff257819ULL, 0x000fe40000011660ULL, 0x00000010ff617819ULL, 0x000fe2000001168bULL,
0x000000261c38723cULL, 0x000fe20000041838ULL, 0x00000010ff607819ULL, 0x000fe4000001166eULL,
0x0000a800188b7811ULL, 0x000fe400078e20ffULL, 0x0000105425607816ULL, 0x000fe40000000060ULL,
0x0000105424617816ULL, 0x000fc40000000061ULL, 0x000000008b24783bULL, 0x000e620000000200ULL,
0x000000ff628d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe40000011663ULL,
0x000000601c34723cULL, 0x000fe20000041834ULL, 0x00000010ff627819ULL, 0x000fe40000011687ULL,
0x00000010ff637819ULL, 0x000fe40000011688ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff617819ULL, 0x000fe40000011677ULL,
0x00000010ff607819ULL, 0x000fe40000011685ULL, 0x00000010ff877819ULL, 0x000fe40000011678ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x0000105489627816ULL, 0x000fe40000000062ULL, 0x000010548a637816ULL, 0x000fe20000000063ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x0000105461607816ULL, 0x000fe40000000060ULL,
0x0000105487617816ULL, 0x000fe40000000086ULL, 0x00000010ff807819ULL, 0x000fe20000011680ULL,
0x000000621c30723cULL, 0x000fe20000041830ULL, 0x00000010ff837819ULL, 0x000fc40000011683ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff627819ULL, 0x000fe2000001167fULL, 0x000000601c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff637819ULL, 0x000fe20000011682ULL, 0x0000007524249231ULL, 0x082fe200003400ffULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x0000007526269231ULL, 0x000fe200003400ffULL,
0x0000105463627816ULL, 0x000fe20000000062ULL, 0x0000007625259231ULL, 0x080fe200003400ffULL,
0x00000010ff617819ULL, 0x000fe2000001167cULL, 0x0000007627279231ULL, 0x000fe200003400ffULL,
0x0000105483637816ULL, 0x000fc40000000080ULL, 0x0000105481607816ULL, 0x000fe40000000084ULL,
0x000010547a617816ULL, 0x000fe40000000061ULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x000000621c20723cULL, 0x040fe20000041820ULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x000000ff6d907812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6f7819ULL, 0x000fe2000001166fULL,
0x20000095ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000601c28723cULL, 0x000fe20000041828ULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff1d7819ULL, 0x000fe40000011674ULL, 0x00000010ff1c7819ULL, 0x000fe20000011672ULL,
0x20000090ff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe40000011671ULL,
0x000010541d1c7816ULL, 0x000fc4000000001cULL, 0x000010541e1d7816ULL, 0x000fe40000000073ULL,
0x00000010ff1e7819ULL, 0x000fe4000001166aULL, 0x00000010ff1f7819ULL, 0x000fe40000011669ULL,
0x00000010ff607819ULL, 0x000fe20000011667ULL, 0x0000001c243c723cULL, 0x000fe2000004183cULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000008cff777230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fe20000011666ULL, 0x2000008dff787230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe20000011668ULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x000010546b1e7816ULL, 0x000fe4000000001eULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x000010546c1f7816ULL, 0x000fc4000000001fULL, 0x00001054601d7816ULL, 0x000fe4000000006dULL,
0x00000010ff647819ULL, 0x000fe4000001164fULL, 0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x0000001e2438723cULL, 0x000fe20000041838ULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff1e7819ULL, 0x000fe2000001165fULL, 0x0000001c2434723cULL, 0x000fe20000041834ULL,
0x00000010ff1f7819ULL, 0x000fe4000001166eULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff1d7819ULL, 0x000fe4000001164cULL,
0x00000010ff1c7819ULL, 0x000fc40000011677ULL, 0x00000010ff5f7819ULL, 0x000fe40000011678ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164dULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000010541f1e7816ULL, 0x000fe2000000001eULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010541d1c7816ULL, 0x000fc4000000001cULL, 0x000010545f1f7816ULL, 0x000fe2000000004eULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x000010544c1d7816ULL, 0x000fe4000000006fULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x0000001e2430723cULL, 0x000fe20000041830ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167dULL,
0x00000010ff7e7819ULL, 0x000fc4000001167eULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff1f7819ULL, 0x000fe20000011670ULL, 0x0000001c242c723cULL, 0x000fe2000004182cULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff1c7819ULL, 0x000fc40000011649ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff497819ULL, 0x000fe4000001164fULL,
0x000010547c627816ULL, 0x000fe40000000079ULL, 0x000010547e637816ULL, 0x000fe4000000007bULL,
0x000010541f4a7816ULL, 0x000fe4000000004aULL, 0x00001054644b7816ULL, 0x000fc4000000004bULL,
0x0000105448487816ULL, 0x000fe20000000065ULL, 0x000000622440723cULL, 0x000fe20000041840ULL,
0x000010541c497816ULL, 0x000fce0000000049ULL, 0x0000004a2420723cULL, 0x040ff00000041820ULL,
0x000000482424723cULL, 0x000fe20000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000080511c7811ULL, 0x000fe200078e40ffULL,
0x01062000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff04ff7812ULL, 0x000fc4000784c0ffULL,
0x0000001c4700720cULL, 0x000fe40003f24070ULL, 0x00000001ff5f7807ULL, 0x000fd60005000000ULL,
0x0000796000009947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000a0511c7811ULL, 0x000fe200078e40ffULL,
0x00000100ff4b7424ULL, 0x000fe200078e00ffULL, 0x00000004ff497819ULL, 0x000fe40000011600ULL,
0x0000001c471d7217ULL, 0x000fe20007800000ULL, 0x0000620045287a24ULL, 0x000fc800078e021cULL,
0x000000011d1d7824ULL, 0x000fe400078e0a1cULL, 0x00000001051c7824ULL, 0x100fe400078e0228ULL,
0x000000010a1e7824ULL, 0x000fe200078e0228ULL, 0x000000201d1f7807ULL, 0x000fe20000000000ULL,
0x00005e001c1c7625ULL, 0x000fc600078e004bULL, 0x0000001f44297217ULL, 0x000fe20007800000ULL,
0x00005e001e1e7625ULL, 0x000fe200078e004bULL, 0x000000061c2a7210ULL, 0x000fc60007f3e0ffULL,
0x0000000129487824ULL, 0x000fe200078e0a44ULL, 0x000000061e1e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010b1c7824ULL, 0x100fe400078e0228ULL, 0x000000010c287824ULL, 0x000fe200078e0228ULL,
0x000000484900720cULL, 0x080fe20003f46070ULL, 0x000000ffff2b7224ULL, 0x000fe200008e061dULL,
0x000000480700720cULL, 0x080fe20003f26070ULL, 0x00005e001c1c7625ULL, 0x000fe200078e004bULL,
0x000000480900720cULL, 0x000fc60003f86070ULL, 0x00005e0028287625ULL, 0x000fe200078e004bULL,
0x000000061c1c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x000000480800720cULL, 0x000fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x0000000628287210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a5d7faeULL, 0x0003e8000d101c46ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x000000001e5c7faeULL, 0x0003ea000c901c46ULL, 0x000000001c5b7faeULL, 0x0003e8000d901c46ULL,
0x00000000285a7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1d7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01062c00ff1e7984ULL, 0x000ea20000000800ULL, 0x000000ff04ff7812ULL, 0x000fe2000782c0ffULL,
0x80000000571f7824ULL, 0x000fc600078e00ffULL, 0x00000001ff5f7807ULL, 0x000fca0004800000ULL,
0x800000005f1c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x002fe4000782481cULL,
0x800000001eff7812ULL, 0x004fe2000784481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x80000000571e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01062c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01010000591c7984ULL, 0x000e620000000800ULL, 0x00000001ff627424ULL, 0x000fc600078e00ffULL,
0x01030000591d7984ULL, 0x0004e20000000800ULL, 0x0000001b1c00720bULL, 0x002fda0003f5d000ULL,
0x00000000001e7806ULL, 0x000fc800010e0100ULL, 0x0000ffff1e287812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x0000001b1c00720bULL, 0x00cfe40003f54000ULL,
0x0000001c1b1e7209ULL, 0x000fe40007810000ULL, 0x00000002ff2a7819ULL, 0x000fc60000011600ULL,
0x8000001e1b1f7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fe40000410000ULL,
0x00000000001b7806ULL, 0x000fe400010e0100ULL, 0x000000025000780cULL, 0x000fe40003f45270ULL,
0x0000ffff1b297812ULL, 0x000fe200078e3cffULL, 0x0000001f001f7308ULL, 0x000e660000000800ULL,
0x0000002928ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff627807ULL, 0x000fc60001800000ULL,
0x0105001e5900a388ULL, 0x000fe80000000800ULL, 0x00001f2a1f1b7589ULL, 0x002e6400000e0000ULL,
0x8000001e1c283221ULL, 0x000fe20000010000ULL, 0x0000001f1a1a7220ULL, 0x000fe20000410000ULL,
0x00001f0e1f1c7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b28283820ULL, 0x000fc80000410000ULL,
0x00000028000d3308ULL, 0x000ee20000000800ULL, 0x0000001b40407220ULL, 0x082fe20000410000ULL,
0x0000001b41417220ULL, 0x080fe20000410000ULL, 0x0000001b3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001b3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001b38387220ULL, 0x080fe20000410000ULL,
0x0000001b39397220ULL, 0x080fe20000410000ULL, 0x0000001b34347220ULL, 0x080fe20000410000ULL,
0x0000001b35357220ULL, 0x080fe20000410000ULL, 0x0000001b30307220ULL, 0x080fe20000410000ULL,
0x0000001b31317220ULL, 0x080fe20000410000ULL, 0x0000001b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001b20207220ULL, 0x080fe20000410000ULL,
0x0000001b21217220ULL, 0x080fe20000410000ULL, 0x0000001b24247220ULL, 0x080fe20000410000ULL,
0x0000001b25257220ULL, 0x000fe20000410000ULL, 0x0000001c42427220ULL, 0x084fe20000410000ULL,
0x0000001c43437220ULL, 0x080fe20000410000ULL, 0x0000001c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001c36367220ULL, 0x080fe20000410000ULL,
0x0000001c37377220ULL, 0x080fe20000410000ULL, 0x0000001c32327220ULL, 0x080fe20000410000ULL,
0x0000001c33337220ULL, 0x080fe20000410000ULL, 0x0000001c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001c22227220ULL, 0x080fe20000410000ULL,
0x0000001c23237220ULL, 0x080fe20000410000ULL, 0x0000001c26267220ULL, 0x080fe20000410000ULL,
0x0000001c27277220ULL, 0x000fe20000410000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e001eULL,
0x0000001d0d1d3220ULL, 0x008fc80000410000ULL, 0x0000001a1d1a7221ULL, 0x00cfe20000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x01064c00ff1c7984ULL, 0x000e620000000800ULL,
0x800000005f1d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x002fe2000782481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x800000005f1e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01064c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000000581c783bULL, 0x000e620000004200ULL,
0x0000000dff99723eULL, 0x000fe400000010ffULL, 0x00000002ff987819ULL, 0x000fe20000011600ULL,
0x000000005628783bULL, 0x000ea20000004200ULL, 0x0000541099997816ULL, 0x000fc60000000099ULL,
0x000000005548783bULL, 0x000ee80000004200ULL, 0x00000000544c783bULL, 0x000f220000004200ULL,
0x00000010ff877819ULL, 0x102fe4000001161dULL, 0x000000ff1d8e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001161dULL, 0x0000ffff1d867812ULL, 0x000fc400078ec0ffULL,
0x000000ff1c637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x104fe4000001162aULL,
0x000000ff2a797812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001162aULL,
0x0000ffff2a747812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x008fc40000011648ULL,
0x000000ff48727812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011648ULL,
0x0000ffff482a7812ULL, 0x000fe400078ec0ffULL, 0x0000991062487816ULL, 0x000fe400000000ffULL,
0x00000010ff8a7819ULL, 0x000fe4000001161eULL, 0x000000ff1e697812ULL, 0x000fc400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe4000001161eULL, 0x0000ffff1e837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x100fe4000001161fULL, 0x000000ff1f8c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001161fULL, 0x0000ffff1f7d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff6f7819ULL, 0x100fe40000011628ULL, 0x000000ff28887812ULL, 0x040fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe40000011628ULL, 0x0000ffff281f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1e7819ULL, 0x000fe4000001162bULL, 0x000000ff2b817812ULL, 0x000fc400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe4000001162bULL, 0x0000ffff2b777812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe40000011649ULL, 0x000000ff49757812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe40000011649ULL, 0x0000ffff496c7812ULL, 0x000fc400078ec0ffULL,
0x00000063ff94723eULL, 0x000fe400020006ffULL, 0x00000010ff2b7819ULL, 0x100fe4000001164bULL,
0x000000ff4b687812ULL, 0x040fe200078ec0ffULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000018ff677819ULL, 0x000fe4000001164bULL, 0x0000ffff4b287812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x010fc4000001164cULL, 0x000000ff4c6b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164cULL, 0x0000ffff4c637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff717819ULL, 0x100fe4000001164eULL, 0x000000ff4e4c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4b7819ULL, 0x000fc4000001164eULL, 0x0000ffff4e667812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4e7224ULL, 0x000fe200078e0048ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x000000ff29897812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e00720cULL, 0x000fe20003f25270ULL,
0x2000008dff917230ULL, 0x000fe20000004100ULL, 0x00000069ff4e723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x00000018ff787819ULL, 0x000fe20000011629ULL,
0x2000004eff8d7230ULL, 0x000fe20000004100ULL, 0x00000089ff4e723eULL, 0x000fe200020006ffULL,
0x20000088ff897230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000004eff887230ULL, 0x000fe20000004100ULL,
0x00000078ff4e723eULL, 0x000fe200020006ffULL, 0x20000082ff787230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x2000008eff957230ULL, 0x000fe20000004100ULL,
0x00000079ff82723eULL, 0x000fe200020006ffULL, 0x2000004eff797230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x2000008cff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff4a7c7812ULL, 0x000fc400078ec0ffULL, 0x00000080ff4e723eULL, 0x000fe200020006ffULL,
0x20000082ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x100fe2000001161cULL,
0x2000007bff827230ULL, 0x000fe20000004100ULL, 0x00000018ff8f7819ULL, 0x000fe2000001161cULL,
0x2000004eff7b7230ULL, 0x000fe20000004100ULL, 0x0000ffff1c857812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000010ff7e7819ULL, 0x000fc40000011629ULL,
0x0000ffff291c7812ULL, 0x000fe400078ec0ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000010ff6d7819ULL, 0x100fe4000001164aULL, 0x00000018ff647819ULL, 0x000fe4000001164aULL,
0x0000ffff4a297812ULL, 0x000fe400078ec0ffULL, 0x0000007cff8c723eULL, 0x000fc400020006ffULL,
0x00000010ff627819ULL, 0x100fe4000001164dULL, 0x000000ff4d8b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164dULL, 0x0000ffff4d707812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f4d7812ULL, 0x000fe400078ec0ffULL, 0x0000007aff4e723eULL, 0x000fe200020006ffULL,
0x20000072ff7a7230ULL, 0x000fe20000004100ULL, 0x00000008ff7d7819ULL, 0x000fe2000001167dULL,
0x2000006aff727230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x2000008cff6a7230ULL, 0x000fe20000004100ULL, 0x0000004dff8c723eULL, 0x000fc400020006ffULL,
0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4d7230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x2000008cff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x2000007dff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff837819ULL, 0x000fe40000011683ULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000008fff697230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x2000008aff8f7230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000084ff967230ULL, 0x000fe20000004100ULL, 0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL,
0x20000086ff937230ULL, 0x000fe20000004100ULL, 0x00000008ff7d7819ULL, 0x000fc4000001161cULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x0000b000531c7811ULL, 0x000fe400078e20ffULL,
0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL, 0x2000001fff867230ULL, 0x000fe20000004100ULL,
0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000006fff8a723eULL, 0x000fe200020006ffULL,
0x20000083ff6f7230ULL, 0x000fe20000004100ULL, 0x0000001dff83723eULL, 0x000fc400020006ffULL,
0x0000001eff84723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x000000ff87877812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000008ff777819ULL, 0x000fe40000011677ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000087ff977230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x2000007fff907230ULL, 0x000fe20000004100ULL,
0x000000ff76767812ULL, 0x000fe200078ec0ffULL, 0x2000007dff877230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000077ff7d7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x00001f9899777589ULL, 0x000e6200000e0000ULL,
0x00000076ff7f723eULL, 0x000fe200020006ffULL, 0x20000075ff7c7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x00001f0e99767589ULL, 0x000ea200000e0000ULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x2000004eff757230ULL, 0x000fe20000004100ULL,
0x0000006bff4e723eULL, 0x000fe200020006ffULL, 0x20000068ff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL, 0x20000064ff687230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x2000008bff647230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fc40000011674ULL, 0x00000008ff6c7819ULL, 0x000fe4000001166cULL,
0x0000004cff8b723eULL, 0x000fe200020006ffULL, 0x20000049ff4c7230ULL, 0x000fe20000004100ULL,
0x00000008ff2a7819ULL, 0x000fe2000001162aULL, 0x000000771c1c9231ULL, 0x082fe200003400ffULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000771e1e9231ULL, 0x000fe200003400ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x000000761d1d9231ULL, 0x084fe200003400ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x000000761f1f9231ULL, 0x000fe200003400ffULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000085ff927230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000004bff49723eULL, 0x000fe200020006ffULL, 0x2000008bff4b7230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x2000007eff8b7230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000073ff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff2b2b7812ULL, 0x000fe200078ec0ffULL, 0x20000074ff857230ULL, 0x000fe20000004100ULL,
0x00000008ff987819ULL, 0x000fe20000011629ULL, 0x2000006cff737230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe20000011696ULL, 0x2000002aff747230ULL, 0x000fe20000004100ULL,
0x00000010ff2a7819ULL, 0x000fe20000011694ULL, 0x2000006dff6c7230ULL, 0x000fe20000004100ULL,
0x0000002bff6d723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff2b7819ULL, 0x000fc40000011695ULL, 0x00000010ff947819ULL, 0x000fe20000011697ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00001054292a7816ULL, 0x000fe4000000002aULL,
0x00000008ff957819ULL, 0x000fe40000011628ULL, 0x00001054942b7816ULL, 0x000fe4000000002bULL,
0x00000010ff297819ULL, 0x000fe40000011669ULL, 0x00000010ff287819ULL, 0x000fc40000011692ULL,
0x00000010ff947819ULL, 0x000fe20000011691ULL, 0x0000002a1c40723cULL, 0x000fe20000041840ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x0000105429287816ULL, 0x000fe20000000028ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000105494297816ULL, 0x000fe20000000093ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff2a7819ULL, 0x000fc4000001168dULL,
0x00000010ff2b7819ULL, 0x000fe4000001168eULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x000000281c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x000010548f2a7816ULL, 0x000fe4000000002aULL, 0x00001054902b7816ULL, 0x000fe4000000002bULL,
0x00000010ff297819ULL, 0x000fc40000011660ULL, 0x00000010ff287819ULL, 0x000fe40000011661ULL,
0x00000010ff607819ULL, 0x000fe2000001166fULL, 0x0000002a1c38723cULL, 0x000fe20000041838ULL,
0x00000010ff617819ULL, 0x000fe4000001168cULL, 0x0000b000528c7811ULL, 0x000fe400078e20ffULL,
0x0000105429607816ULL, 0x000fe40000000060ULL, 0x0000105428617816ULL, 0x000fc40000000061ULL,
0x000000ff628e7812ULL, 0x000fe200078ec0ffULL, 0x000000008c28783bULL, 0x000e620000000200ULL,
0x00000008ff8d7819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fe20000011689ULL,
0x000000601c34723cULL, 0x000fe20000041834ULL, 0x00000010ff637819ULL, 0x000fe4000001168aULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x000010548b637816ULL, 0x000fe40000000088ULL,
0x00000010ff617819ULL, 0x000fe40000011678ULL, 0x00000010ff607819ULL, 0x000fe40000011686ULL,
0x00000010ff887819ULL, 0x000fe20000011679ULL, 0x000000621c30723cULL, 0x000fe20000041830ULL,
0x00000010ff877819ULL, 0x000fc40000011687ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000105461607816ULL, 0x000fe40000000060ULL, 0x0000105488617816ULL, 0x000fe20000000087ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe40000011680ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff637819ULL, 0x000fe20000011681ULL,
0x000000601c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff847819ULL, 0x000fc40000011684ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff857819ULL, 0x000fe20000011685ULL,
0x0000007728289231ULL, 0x082fe200003400ffULL, 0x00000010ff807819ULL, 0x000fe2000001167bULL,
0x000000772a2a9231ULL, 0x000fe200003400ffULL, 0x00000010ff617819ULL, 0x000fe2000001167dULL,
0x0000007629299231ULL, 0x080fe200003400ffULL, 0x0000105483627816ULL, 0x000fe20000000062ULL,
0x000000762b2b9231ULL, 0x000fe200003400ffULL, 0x0000105484637816ULL, 0x000fc40000000063ULL,
0x0000105482607816ULL, 0x000fe40000000085ULL, 0x0000105480617816ULL, 0x000fe40000000061ULL,
0x00000010ff737819ULL, 0x000fe20000011673ULL, 0x000000621c20723cULL, 0x000fe20000041820ULL,
0x000000ff6e917812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000098ff98723eULL, 0x000fc400020006ffULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x000000601c1c723cULL, 0x000fe20000041824ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000098ff697230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x20000095ff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe20000011672ULL,
0x20000091ff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe20000011674ULL,
0x2000008eff797230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fc40000011675ULL,
0x0000105425247816ULL, 0x000fe40000000024ULL, 0x0000105426257816ULL, 0x000fe40000000073ULL,
0x00000010ff267819ULL, 0x000fe4000001166aULL, 0x00000010ff277819ULL, 0x000fe4000001166cULL,
0x00000010ff607819ULL, 0x000fe2000001166dULL, 0x00000024283c723cULL, 0x000fe2000004183cULL,
0x0000105427267816ULL, 0x000fc40000000026ULL, 0x0000105460277816ULL, 0x000fe4000000006bULL,
0x00000010ff657819ULL, 0x100fe4000001164fULL, 0x00000018ff487819ULL, 0x000fe4000001164fULL,
0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x000000262838723cULL, 0x000fe20000041838ULL,
0x00000008ff707819ULL, 0x000fe40000011670ULL, 0x000000ff71717812ULL, 0x000fc400078ec0ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x00000010ff257819ULL, 0x000fe40000011668ULL,
0x00000010ff247819ULL, 0x000fe40000011669ULL, 0x00000010ff267819ULL, 0x000fe4000001164eULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff677819ULL, 0x000fc40000011667ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff277819ULL, 0x000fe40000011664ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff4e7819ULL, 0x000fe40000011679ULL,
0x00000008ff4f7819ULL, 0x000fe4000001164fULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000008dff787230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x0000105425247816ULL, 0x000fe20000000024ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x0000105467257816ULL, 0x000fe2000000006eULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x000010546f267816ULL, 0x000fe20000000026ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x000010544e277816ULL, 0x000fe40000000027ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x000000242834723cULL, 0x000fe20000041834ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff7c7819ULL, 0x000fe2000001167cULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fc4000001167eULL, 0x00000010ff257819ULL, 0x000fe2000001164cULL,
0x000000262830723cULL, 0x000fe20000041830ULL, 0x00000010ff247819ULL, 0x000fe40000011678ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff277819ULL, 0x000fe4000001164aULL, 0x00000010ff707819ULL, 0x000fc40000011670ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff267819ULL, 0x000fe40000011671ULL,
0x00000010ff4a7819ULL, 0x000fe40000011665ULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff487819ULL, 0x000fc40000011648ULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x000010547b627816ULL, 0x000fe4000000007aULL, 0x000010547f637816ULL, 0x000fe4000000007cULL,
0x000010544d257816ULL, 0x000fe40000000070ULL, 0x0000105426267816ULL, 0x000fc4000000004bULL,
0x000010544a277816ULL, 0x000fe20000000027ULL, 0x000000622840723cULL, 0x000fe20000041840ULL,
0x0000105449667816ULL, 0x000fe40000000066ULL, 0x0000105448677816ULL, 0x000fca000000004fULL,
0x00000024282c723cULL, 0x040ff0000004182cULL, 0x000000262820723cULL, 0x040ff00000041820ULL,
0x000000662828723cULL, 0x000fe2000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000c0511c7811ULL, 0x000fe200078e40ffULL,
0x00000100ff4b7424ULL, 0x000fe200078e00ffULL, 0x00000004ff497819ULL, 0x000fe40000011600ULL,
0x0000001c471d7217ULL, 0x000fe20007800000ULL, 0x0000620045277a24ULL, 0x000fc800078e021cULL,
0x000000011d1d7824ULL, 0x000fe400078e0a1cULL, 0x00000001051c7824ULL, 0x100fe400078e0227ULL,
0x000000010a1e7824ULL, 0x100fe200078e0227ULL, 0x000000201d1f7807ULL, 0x000fe20000000000ULL,
0x000000010b247824ULL, 0x000fe400078e0227ULL, 0x00005e001c1c7625ULL, 0x000fe200078e004bULL,
0x0000001f44257217ULL, 0x000fc60007800000ULL, 0x00005e001e1e7625ULL, 0x000fe200078e004bULL,
0x000000061c267210ULL, 0x000fc60007f5e0ffULL, 0x0000000125487824ULL, 0x000fe200078e0a44ULL,
0x000000061e1e7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0024247625ULL, 0x000fc600078e004bULL,
0x000000480700720cULL, 0x000fe20003f66070ULL, 0x000000010c1c7824ULL, 0x000fe200078e0227ULL,
0x0000000624247210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff277224ULL, 0x000fe200010e061dULL,
0x000000484900720cULL, 0x000fe20003f46070ULL, 0x00005e001c1c7625ULL, 0x000fc800078e004bULL,
0x000000ffff1f7224ULL, 0x000fe200020e061fULL, 0x000000480800720cULL, 0x080fe20003f86070ULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x000000480900720cULL, 0x000fe40003fa6070ULL,
0x000000061c1c7210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000260f7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff1d7224ULL, 0x000fe400030e061dULL,
0x000000001e107faeULL, 0x0003e8000d901c46ULL, 0x0000000024117faeULL, 0x0003e8000e101c46ULL,
0x000000001c127faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff1c7984ULL, 0x002e620000000800ULL, 0x800000005f1d7824ULL, 0x000fca00078e00ffULL,
0x800000001cff7812ULL, 0x002fe2000784481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x01065400ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000784481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000005f1e7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01065400ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000000131c783bULL, 0x000e620000004200ULL, 0x0000000dff95723eULL, 0x000fe400000010ffULL,
0x00000002ff987819ULL, 0x000fe20000011600ULL, 0x000000001424783bULL, 0x000ea20000004200ULL,
0x0000541095957816ULL, 0x000fc60000000095ULL, 0x000000001548783bULL, 0x000ee80000004200ULL,
0x00000000164c783bULL, 0x000f220000004200ULL, 0x00000018ff887819ULL, 0x002fe4000001161dULL,
0x00000010ff897819ULL, 0x000fe4000001161eULL, 0x000000ff24817812ULL, 0x004fe400078ec0ffULL,
0x000000ff1e8d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe4000001161eULL,
0x0000ffff1e827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7e7819ULL, 0x100fe4000001161fULL,
0x000000ff1f8e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe4000001161fULL,
0x0000ffff1f7c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff807819ULL, 0x100fe40000011624ULL,
0x00000018ff777819ULL, 0x000fe40000011625ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000010ff6e7819ULL, 0x000fe40000011624ULL, 0x0000ffff241f7812ULL, 0x000fe200078ec0ffULL,
0x20000088ff907230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fc40000011627ULL,
0x000000ff277f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011627ULL,
0x0000ffff27767812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x108fe40000011649ULL,
0x000000ff49717812ULL, 0x000fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fc40000011649ULL,
0x0000ffff496b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff25877812ULL, 0x000fe400078ec0ffULL,
0x000000ff26797812ULL, 0x000fe400078ec0ffULL, 0x00000010ff277819ULL, 0x100fe4000001164bULL,
0x000000ff4b677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff667819ULL, 0x000fc4000001164bULL,
0x0000ffff4b247812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6d7819ULL, 0x110fe4000001164cULL,
0x000000ff4c8a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164cULL,
0x0000ffff4c637812ULL, 0x000fe400078ec0ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x000000ff486a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff707819ULL, 0x100fe4000001164eULL,
0x000000ff4e4c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001164eULL,
0x0000ffff4e657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fc40000011626ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000077ff4e723eULL, 0x000fe400020006ffULL,
0x00000087ff88723eULL, 0x000fe200020006ffULL, 0x20000081ff877230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000080ff777230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000078ff81723eULL, 0x000fe200020006ffULL, 0x2000004eff787230ULL, 0x000fe20000004100ULL,
0x000000ff4a7b7812ULL, 0x000fc400078ec0ffULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000018ff697819ULL, 0x000fe40000011648ULL,
0x0000007fff80723eULL, 0x000fe200020006ffULL, 0x20000079ff7f7230ULL, 0x000fe20000004100ULL,
0x00000074ff4e723eULL, 0x000fe200020006ffULL, 0x2000006aff797230ULL, 0x000fe20000004100ULL,
0x000000ff1c627812ULL, 0x000fe200078ec0ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x000000ff4d8b7812ULL, 0x000fc400078ec0ffULL, 0x0000007bff6a723eULL, 0x000fe200020006ffULL,
0x20000071ff7b7230ULL, 0x000fe20000004100ULL, 0x00000018ff5f7819ULL, 0x000fe2000001164aULL,
0x2000004eff717230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x100fe4000001161cULL,
0x00000018ff687819ULL, 0x000fe2000001161cULL, 0x20000069ff747230ULL, 0x000fe20000004100ULL,
0x0000ffff1c847812ULL, 0x000fc400078ec0ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000010ff7d7819ULL, 0x000fe40000011625ULL, 0x0000ffff251c7812ULL, 0x000fe200078ec0ffULL,
0x20000067ff697230ULL, 0x000fe20000004100ULL, 0x00000066ff4e723eULL, 0x000fe400020006ffULL,
0x00000010ff6c7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a257812ULL, 0x000fe200078ec0ffULL,
0x2000004eff677230ULL, 0x000fe20000004100ULL, 0x00000062ff92723eULL, 0x000fc400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x100fe2000001164dULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000018ff4a7819ULL, 0x000fe2000001164dULL,
0x2000008bff4e7230ULL, 0x000fe20000004100ULL, 0x0000ffff4d6f7812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x000000ff4f4d7812ULL, 0x000fc400078ec0ffULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000005fff667230ULL, 0x000fe20000004100ULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x000000ff1d8c7812ULL, 0x040fe200078ec0ffULL,
0x2000008aff5f7230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x0000ffff1d857812ULL, 0x000fe400078ec0ffULL, 0x0000004dff8b723eULL, 0x000fc400020006ffULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000004cff8a723eULL, 0x000fe200020006ffULL,
0x20000049ff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe2000001161dULL,
0x2000008cff937230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x000000ff83837812ULL, 0x000fe400078ec0ffULL, 0x00000008ff857819ULL, 0x000fe20000011685ULL,
0x2000008dff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff1d7819ULL, 0x000fe40000011626ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x0000004bff49723eULL, 0x000fe200020006ffULL, 0x2000008bff4b7230ULL, 0x000fe20000004100ULL,
0x00000008ff1f7819ULL, 0x000fe2000001161fULL, 0x2000007cff8b7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000008eff8d7230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fc400020006ffULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000089ff8e7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x20000083ff977230ULL, 0x000fe20000004100ULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x20000085ff947230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe4000001161cULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x0000b000171c7811ULL, 0x000fc400078e20ffULL,
0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL, 0x2000001fff857230ULL, 0x000fe20000004100ULL,
0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000006eff89723eULL, 0x000fe200020006ffULL,
0x20000082ff6e7230ULL, 0x000fe20000004100ULL, 0x0000001dff82723eULL, 0x000fe400020006ffULL,
0x0000001eff83723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x000000ff86867812ULL, 0x000fe200078ec0ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff767819ULL, 0x000fc40000011676ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000086ff967230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x2000007eff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff75757812ULL, 0x000fe200078ec0ffULL, 0x2000007cff867230ULL, 0x000fe20000004100ULL,
0x0000ffff26737812ULL, 0x000fe200078ec0ffULL, 0x20000076ff7c7230ULL, 0x000fe20000004100ULL,
0x00000075ff7e723eULL, 0x000fe200020006ffULL, 0x00001f0e95767589ULL, 0x000e6200000e0000ULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x00000010ff727819ULL, 0x000fe20000011648ULL,
0x00001f9895757589ULL, 0x000ea200000e0000ULL, 0x0000ffff48267812ULL, 0x000fe200078ec0ffULL,
0x2000004aff4d7230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe20000011684ULL,
0x2000008aff4a7230ULL, 0x000fe20000004100ULL, 0x00000018ff487819ULL, 0x000fe2000001164fULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x000000ff7d7d7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe4000001166bULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000008ff267819ULL, 0x000fe20000011626ULL,
0x000000761d1d9231ULL, 0x082fe200003400ffULL, 0x00000048ff8a723eULL, 0x000fe200020006ffULL,
0x20000049ff487230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000084ff917230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000008aff497230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000073ff847230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000007dff8a7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000006bff737230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x20000072ff7d7230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000006cff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff27277812ULL, 0x000fe200078ec0ffULL,
0x20000026ff727230ULL, 0x000fe20000004100ULL, 0x00000008ff257819ULL, 0x000fe20000011625ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000027ff6c723eULL, 0x000fe200020006ffULL,
0x000000751c1c9231ULL, 0x084fe200003400ffULL, 0x00000010ff267819ULL, 0x000fe20000011692ULL,
0x000000751e1e9231ULL, 0x000fe200003400ffULL, 0x00000010ff277819ULL, 0x000fe20000011693ULL,
0x000000761f1f9231ULL, 0x000fe200003400ffULL, 0x00000010ff977819ULL, 0x000fe20000011697ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff967819ULL, 0x000fc40000011696ULL,
0x00000025ff92723eULL, 0x000fe400020006ffULL, 0x0000105497267816ULL, 0x000fe40000000026ULL,
0x0000105496277816ULL, 0x000fe40000000027ULL, 0x00000008ff957819ULL, 0x000fe40000011624ULL,
0x00000010ff257819ULL, 0x000fe20000011668ULL, 0x20000092ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe20000011691ULL, 0x000000261c40723cULL, 0x000fe20000041840ULL,
0x00000010ff937819ULL, 0x000fc40000011690ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000105425247816ULL, 0x000fe20000000024ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000105493257816ULL, 0x000fe20000000094ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff267819ULL, 0x000fc4000001168cULL, 0x00000010ff277819ULL, 0x000fe4000001168eULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x000000241c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff8c7819ULL, 0x000fe4000001168fULL, 0x0000105427267816ULL, 0x000fe40000000026ULL,
0x000010548c277816ULL, 0x000fe4000000008dULL, 0x00000010ff247819ULL, 0x000fc40000011661ULL,
0x00000010ff257819ULL, 0x000fe40000011660ULL, 0x00000010ff617819ULL, 0x000fe2000001168bULL,
0x000000261c38723cULL, 0x000fe20000041838ULL, 0x00000010ff607819ULL, 0x000fe4000001166eULL,
0x0000b000188b7811ULL, 0x000fe400078e20ffULL, 0x0000105425607816ULL, 0x000fe40000000060ULL,
0x0000105424617816ULL, 0x000fc40000000061ULL, 0x000000008b24783bULL, 0x000e620000000200ULL,
0x000000ff628d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe40000011663ULL,
0x000000601c34723cULL, 0x000fe20000041834ULL, 0x00000010ff627819ULL, 0x000fe40000011687ULL,
0x00000010ff637819ULL, 0x000fe40000011688ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff617819ULL, 0x000fe40000011677ULL,
0x00000010ff607819ULL, 0x000fe40000011685ULL, 0x00000010ff877819ULL, 0x000fe40000011678ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x0000105489627816ULL, 0x000fe40000000062ULL, 0x000010548a637816ULL, 0x000fe20000000063ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x0000105461607816ULL, 0x000fe40000000060ULL,
0x0000105487617816ULL, 0x000fe40000000086ULL, 0x00000010ff807819ULL, 0x000fe20000011680ULL,
0x000000621c30723cULL, 0x000fe20000041830ULL, 0x00000010ff837819ULL, 0x000fc40000011683ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff627819ULL, 0x000fe2000001167fULL, 0x000000601c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff637819ULL, 0x000fe20000011682ULL, 0x0000007524249231ULL, 0x082fe200003400ffULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x0000007526269231ULL, 0x000fe200003400ffULL,
0x0000105463627816ULL, 0x000fe20000000062ULL, 0x0000007625259231ULL, 0x080fe200003400ffULL,
0x00000010ff617819ULL, 0x000fe2000001167cULL, 0x0000007627279231ULL, 0x000fe200003400ffULL,
0x0000105483637816ULL, 0x000fc40000000080ULL, 0x0000105481607816ULL, 0x000fe40000000084ULL,
0x000010547a617816ULL, 0x000fe40000000061ULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x000000621c20723cULL, 0x040fe20000041820ULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x000000ff6d907812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6f7819ULL, 0x000fe2000001166fULL,
0x20000095ff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000601c28723cULL, 0x000fe20000041828ULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff1d7819ULL, 0x000fe40000011674ULL, 0x00000010ff1c7819ULL, 0x000fe20000011672ULL,
0x20000090ff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe40000011671ULL,
0x000010541d1c7816ULL, 0x000fc4000000001cULL, 0x000010541e1d7816ULL, 0x000fe40000000073ULL,
0x00000010ff1e7819ULL, 0x000fe4000001166aULL, 0x00000010ff1f7819ULL, 0x000fe40000011669ULL,
0x00000010ff607819ULL, 0x000fe20000011667ULL, 0x0000001c243c723cULL, 0x000fe2000004183cULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000008cff777230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fe20000011666ULL, 0x2000008dff787230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe20000011668ULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x000010546b1e7816ULL, 0x000fe4000000001eULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x000010546c1f7816ULL, 0x000fc4000000001fULL, 0x00001054601d7816ULL, 0x000fe4000000006dULL,
0x00000010ff647819ULL, 0x000fe4000001164fULL, 0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x0000001e2438723cULL, 0x000fe20000041838ULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000008ff657819ULL, 0x000fc40000011665ULL,
0x00000010ff1e7819ULL, 0x000fe2000001165fULL, 0x0000001c2434723cULL, 0x000fe20000041834ULL,
0x00000010ff1f7819ULL, 0x000fe4000001166eULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff1d7819ULL, 0x000fe4000001164cULL,
0x00000010ff1c7819ULL, 0x000fc40000011677ULL, 0x00000010ff5f7819ULL, 0x000fe40000011678ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164dULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000010541f1e7816ULL, 0x000fe2000000001eULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010541d1c7816ULL, 0x000fc4000000001cULL, 0x000010545f1f7816ULL, 0x000fe2000000004eULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x000010544c1d7816ULL, 0x000fe4000000006fULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x0000001e2430723cULL, 0x000fe20000041830ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167dULL,
0x00000010ff7e7819ULL, 0x000fc4000001167eULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff1f7819ULL, 0x000fe20000011670ULL, 0x0000001c242c723cULL, 0x000fe2000004182cULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff1c7819ULL, 0x000fc40000011649ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff497819ULL, 0x000fe4000001164fULL,
0x000010547c627816ULL, 0x000fe40000000079ULL, 0x000010547e637816ULL, 0x000fe4000000007bULL,
0x000010541f4a7816ULL, 0x000fe4000000004aULL, 0x00001054644b7816ULL, 0x000fc4000000004bULL,
0x0000105448487816ULL, 0x000fe20000000065ULL, 0x000000622440723cULL, 0x000fe20000041840ULL,
0x000010541c497816ULL, 0x000fce0000000049ULL, 0x0000004a2420723cULL, 0x040ff00000041820ULL,
0x000000482424723cULL, 0x000fe20000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c0511c7811ULL, 0x000fe200078e40ffULL,
0x01063000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff04ff7812ULL, 0x000fc4000784c0ffULL,
0x0000001c4700720cULL, 0x000fe40003f24070ULL, 0x00000001ff5f7807ULL, 0x000fd60001000000ULL,
0x00003ca000009947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000e0511c7811ULL, 0x000fe200078e40ffULL,
0x00000100ff4a7424ULL, 0x000fe200078e00ffULL, 0x00000004ff497819ULL, 0x000fe40000011600ULL,
0x0000001c471d7217ULL, 0x000fe20007800000ULL, 0x00006200451e7a24ULL, 0x000fc800078e021cULL,
0x000000011d1d7824ULL, 0x000fe400078e0a1cULL, 0x00000001051c7824ULL, 0x100fe400078e021eULL,
0x000000010a287824ULL, 0x000fe200078e021eULL, 0x000000201d1f7807ULL, 0x000fe20000000000ULL,
0x00005e001c1c7625ULL, 0x000fc600078e004aULL, 0x0000001f441f7217ULL, 0x000fe20007800000ULL,
0x000000010c297824ULL, 0x000fe200078e021eULL, 0x000000061c2a7210ULL, 0x000fc60007f1e0ffULL,
0x000000011f487824ULL, 0x000fe400078e0a44ULL, 0x000000010b1f7824ULL, 0x000fe400078e021eULL,
0x000000ffff2b7224ULL, 0x000fe200000e061dULL, 0x000000484900720cULL, 0x000fe20003f06070ULL,
0x00005e00281c7625ULL, 0x000fe200078e004aULL, 0x000000480700720cULL, 0x080fe40003f26070ULL,
0x000000480800720cULL, 0x000fe20003f46070ULL, 0x00005e001f1e7625ULL, 0x000fe200078e004aULL,
0x000000480900720cULL, 0x000fc40003f66070ULL, 0x000000061c1c7210ULL, 0x000fe20007f9e0ffULL,
0x00005e0029287625ULL, 0x000fe200078e004aULL, 0x000000061e1e7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e061dULL, 0x0000000628287210ULL, 0x000fe20007fde0ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e061fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a5d7faeULL, 0x0003e6000c101c46ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x000000001c5c7faeULL, 0x0003e8000c901c46ULL, 0x000000001e5b7faeULL, 0x0003e8000d101c46ULL,
0x00000000285a7faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1c7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01063c00ff1d7984ULL, 0x000ea20000000800ULL, 0x800000005e1f7824ULL, 0x000fc400078e00ffULL,
0x80000000571e7824ULL, 0x000fc600078e00ffULL, 0x800000001cff7812ULL, 0x002fe4000780481fULL,
0x800000001dff7812ULL, 0x004fe2000782481eULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x80000000571e7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01063c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000782481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x01018000591c7984ULL, 0x000e620000000800ULL, 0x00000001ff577424ULL, 0x000fc600078e00ffULL,
0x01038000591d7984ULL, 0x0004e20000000800ULL, 0x0000001b1c00720bULL, 0x002fda0003f3d000ULL,
0x00000000001e7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1e287812ULL, 0x000fda000782c0ffULL,
0x0000034000009947ULL, 0x000fea0003800000ULL, 0x0000001b1c00720bULL, 0x00cfe40003f34000ULL,
0x0000001c1b2a7209ULL, 0x000fe40007810000ULL, 0x00000002ff487819ULL, 0x000fc60000011600ULL,
0x8000002a1b1e7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fe40000410000ULL,
0x00000000001b7806ULL, 0x000fe400008e0100ULL, 0x0000001e001f7308ULL, 0x000e620000000800ULL,
0x000000035000780cULL, 0x000fe40003f25270ULL, 0x0000ffff1b297812ULL, 0x000fc800078e3cffULL,
0x0000002928ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff577807ULL, 0x000fc60001000000ULL,
0x0105802a59009388ULL, 0x000fe20000000800ULL, 0x0000001f1a1a7220ULL, 0x002fc60000410000ULL,
0x00001f481f1b7589ULL, 0x000e6400000e0000ULL, 0x8000002a1c282221ULL, 0x000fe40000010000ULL,
0x00001f0e1f1c7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b28282820ULL, 0x000fc80000410000ULL,
0x00000028000d2308ULL, 0x000ee20000000800ULL, 0x0000001b40407220ULL, 0x082fe20000410000ULL,
0x0000001b41417220ULL, 0x080fe20000410000ULL, 0x0000001b3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001b3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001b38387220ULL, 0x080fe20000410000ULL,
0x0000001b39397220ULL, 0x080fe20000410000ULL, 0x0000001b34347220ULL, 0x080fe20000410000ULL,
0x0000001b35357220ULL, 0x080fe20000410000ULL, 0x0000001b30307220ULL, 0x080fe20000410000ULL,
0x0000001b31317220ULL, 0x080fe20000410000ULL, 0x0000001b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001b20207220ULL, 0x080fe20000410000ULL,
0x0000001b21217220ULL, 0x080fe20000410000ULL, 0x0000001b24247220ULL, 0x080fe20000410000ULL,
0x0000001b25257220ULL, 0x000fe20000410000ULL, 0x0000001c42427220ULL, 0x084fe20000410000ULL,
0x0000001c43437220ULL, 0x080fe20000410000ULL, 0x0000001c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001c36367220ULL, 0x080fe20000410000ULL,
0x0000001c37377220ULL, 0x080fe20000410000ULL, 0x0000001c32327220ULL, 0x080fe20000410000ULL,
0x0000001c33337220ULL, 0x080fe20000410000ULL, 0x0000001c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001c22227220ULL, 0x080fe20000410000ULL,
0x0000001c23237220ULL, 0x080fe20000410000ULL, 0x0000001c26267220ULL, 0x080fe20000410000ULL,
0x0000001c27277220ULL, 0x000fe20000410000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e002aULL,
0x0000001d0d1d2220ULL, 0x008fc80000410000ULL, 0x0000001a1d1a7221ULL, 0x00cfe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x01064c00ff1c7984ULL, 0x000e620000000800ULL,
0x800000005e1d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x002fe2000780481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x800000005e1e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01064c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000780481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000000581c783bULL, 0x000e620000004200ULL,
0x0000991057577816ULL, 0x000fe400000000ffULL, 0x0000000dff87723eULL, 0x000fe200000010ffULL,
0x000000005628783bULL, 0x000ea20000004200ULL, 0x00000002ff8e7819ULL, 0x000fe40000011600ULL,
0x0000541087877816ULL, 0x000fe20000000087ULL, 0x000000005548783bULL, 0x000ee80000004200ULL,
0x00000000544c783bULL, 0x000f220000004200ULL, 0x000000ff1c5d7812ULL, 0x002fc400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe4000001161cULL, 0x00000018ff5b7819ULL, 0x000fe4000001161cULL,
0x0000ffff1c7e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x104fe40000011629ULL,
0x000000ff29897812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fc40000011629ULL,
0x0000ffff291c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff697819ULL, 0x108fe40000011649ULL,
0x000000ff49657812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011649ULL,
0x0000ffff495f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff797819ULL, 0x000fc4000001161dULL,
0x000000ff1d787812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001161dULL,
0x0000ffff1d7a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x100fe4000001161fULL,
0x000000ff1f807812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7f7819ULL, 0x000fc4000001161fULL,
0x0000ffff1f6e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x100fe4000001164aULL,
0x000000ff4a647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164aULL,
0x0000ffff4a297812ULL, 0x000fe400078ec0ffULL, 0x0000005dff85723eULL, 0x000fc400020006ffULL,
0x00000010ff6f7819ULL, 0x100fe40000011628ULL, 0x000000ff28887812ULL, 0x040fe200078ec0ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000018ff777819ULL, 0x000fe40000011628ULL,
0x0000ffff281f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x000fe4000001162aULL,
0x000000ff2a717812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001162aULL,
0x0000ffff2a677812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x110fe4000001164cULL,
0x000000ff4c5d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001164cULL,
0x0000ffff4c557812ULL, 0x000fc400078ec0ffULL, 0x00000010ff2a7819ULL, 0x100fe4000001164bULL,
0x000000ff4b597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe4000001164bULL,
0x0000ffff4b287812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x000fe4000001164dULL,
0x000000ff4d837812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001164dULL,
0x0000ffff4d617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x100fe4000001164eULL,
0x000000ff4e4d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001164eULL,
0x0000ffff4e587812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4e7224ULL, 0x000fe200078e0057ULL,
0x000000ff2b737812ULL, 0x000fc400078ec0ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x000000ff4e00720cULL, 0x000fe20003f05270ULL,
0x20000078ff867230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe2000001162bULL,
0x2000006bff787230ULL, 0x000fe20000004100ULL, 0x00000073ff4e723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000072ff6b723eULL, 0x000fe200020006ffULL, 0x2000004eff727230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000071ff737230ULL, 0x000fe20000004100ULL,
0x000000ff485c7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff717230ULL, 0x000fe20000004100ULL,
0x0000006cff4e723eULL, 0x000fe200020006ffULL, 0x20000065ff6d7230ULL, 0x000fe20000004100ULL,
0x00000018ff5a7819ULL, 0x000fe20000011648ULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x2000004eff657230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x2000005cff6c7230ULL, 0x000fe20000004100ULL, 0x0000005dff4e723eULL, 0x000fe200020006ffULL,
0x20000059ff5d7230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000056ff597230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fe2000001166eULL,
0x20000083ff567230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000064ff5c723eULL, 0x000fe200020006ffULL,
0x2000005aff647230ULL, 0x000fe20000004100ULL, 0x0000004dff83723eULL, 0x000fe200020006ffULL,
0x20000049ff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff1e7c7812ULL, 0x000fe200078ec0ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fc400020006ffULL,
0x00000008ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff7d7819ULL, 0x100fe4000001161eULL,
0x00000018ff7b7819ULL, 0x000fe4000001161eULL, 0x0000ffff1e707812ULL, 0x000fe400078ec0ffULL,
0x0000004cff49723eULL, 0x000fe200020006ffULL, 0x2000004aff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff79797812ULL, 0x000fe200078ec0ffULL, 0x20000083ff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff75757812ULL, 0x000fe200078ec0ffULL, 0x2000006eff837230ULL, 0x000fe20000004100ULL,
0x000000ff74747812ULL, 0x000fe200078ec0ffULL, 0x20000049ff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fc4000001162bULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000007eff8a7230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000079ff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fc4000001161cULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x20000074ff7e7230ULL, 0x000fe20000004100ULL,
0x0000b800531c7811ULL, 0x000fe400078e20ffULL, 0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL,
0x2000001fff797230ULL, 0x000fe20000004100ULL, 0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL,
0x00000080ff81723eULL, 0x000fe200020006ffULL, 0x2000007cff807230ULL, 0x000fe20000004100ULL,
0x00000089ff7c723eULL, 0x000fe200020006ffULL, 0x20000075ff897230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x0000001dff74723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x0000001eff75723eULL, 0x000fe200020006ffULL, 0x20000068ff847230ULL, 0x000fe20000004100ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x0000ffff2b6a7812ULL, 0x000fe200078ec0ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x000000ff4f827812ULL, 0x000fe200078ec0ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fc4000001167aULL,
0x0000007bff68723eULL, 0x000fe400020006ffULL, 0x00000008ff707819ULL, 0x000fe40000011670ULL,
0x00000088ff7b723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000008ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff667819ULL, 0x000fe20000011648ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000ffff482b7812ULL, 0x000fc400078ec0ffULL,
0x00000082ff88723eULL, 0x000fe400020006ffULL, 0x00000018ff487819ULL, 0x000fe4000001164fULL,
0x0000004bff82723eULL, 0x000fe200020006ffULL, 0x20000088ff4b7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000007aff8b7230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fc400020006ffULL, 0x000000ff69697812ULL, 0x000fe200078ec0ffULL,
0x2000006eff7a7230ULL, 0x000fe20000004100ULL, 0x00000048ff49723eULL, 0x000fe200020006ffULL,
0x20000082ff487230ULL, 0x000fe20000004100ULL, 0x000000ff76767812ULL, 0x000fe200078ec0ffULL,
0x20000070ff827230ULL, 0x000fe20000004100ULL, 0x00000069ff70723eULL, 0x000fe200020006ffULL,
0x2000006aff6e7230ULL, 0x000fe20000004100ULL, 0x00001f8e87697589ULL, 0x000e6200000e0000ULL,
0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000008ff677819ULL, 0x000fe20000011667ULL, 0x00001f0e876a7589ULL, 0x000ea200000e0000ULL,
0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff5f7819ULL, 0x000fc4000001165fULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000008ff2b7819ULL, 0x000fe4000001162bULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000076ff8d7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000007dff887230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000067ff767230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000006fff7d7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000005fff677230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x20000066ff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff5f7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000002bff667230ULL, 0x000fe20000004100ULL,
0x0000002aff60723eULL, 0x000fe200020006ffULL, 0x000000691c1c8231ULL, 0x082fe200003400ffULL,
0x00000010ff2a7819ULL, 0x000fe20000011685ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff2b7819ULL, 0x000fe20000011686ULL, 0x000000691e1e8231ULL, 0x000fe200003400ffULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x0000006a1d1d8231ULL, 0x084fe200003400ffULL,
0x00000010ff8c7819ULL, 0x000fe2000001168cULL, 0x0000006a1f1f8231ULL, 0x000fe200003400ffULL,
0x00000008ff297819ULL, 0x000fe20000011629ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x000010548d2a7816ULL, 0x000fc4000000002aULL, 0x000010548c2b7816ULL, 0x000fe4000000002bULL,
0x00000029ff53723eULL, 0x000fe400020006ffULL, 0x00000008ff857819ULL, 0x000fe40000011628ULL,
0x00000010ff297819ULL, 0x000fe2000001165bULL, 0x0000002a1c40723cULL, 0x000fe20000041840ULL,
0x00000010ff287819ULL, 0x000fe2000001168aULL, 0x20000053ff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x0000105429287816ULL, 0x000fe40000000028ULL,
0x0000105484297816ULL, 0x000fe2000000008bULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff2a7819ULL, 0x000fe40000011680ULL, 0x00000010ff2b7819ULL, 0x000fc40000011688ULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x000000281c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff807819ULL, 0x000fe40000011689ULL, 0x000000ff63537812ULL, 0x000fe400078ec0ffULL,
0x000010542b2a7816ULL, 0x000fe4000000002aULL, 0x00001054802b7816ULL, 0x000fe40000000081ULL,
0x00000053ff84723eULL, 0x000fc400020006ffULL, 0x00000010ff297819ULL, 0x000fe40000011668ULL,
0x00000010ff287819ULL, 0x000fe2000001167fULL, 0x0000002a1c38723cULL, 0x000fe20000041838ULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x20000084ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe40000011683ULL, 0x0000b800527f7811ULL, 0x000fe400078e20ffULL,
0x00000077ff77723eULL, 0x000fc400020006ffULL, 0x0000105429527816ULL, 0x000fe40000000082ULL,
0x0000105428537816ULL, 0x000fe20000000053ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x000000007f28783bULL, 0x000e620000000200ULL, 0x000000ff54817812ULL, 0x000fe400078ec0ffULL,
0x00000008ff807819ULL, 0x000fe40000011655ULL, 0x00000010ff547819ULL, 0x000fe2000001167bULL,
0x000000521c34723cULL, 0x000fe20000041834ULL, 0x00000010ff557819ULL, 0x000fc4000001167cULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x000010547d547816ULL, 0x000fe40000000054ULL, 0x000010547e557816ULL, 0x000fe40000000055ULL,
0x00000010ff537819ULL, 0x000fe40000011677ULL, 0x00000010ff527819ULL, 0x000fc40000011679ULL,
0x00000010ff7b7819ULL, 0x000fe20000011678ULL, 0x000000541c30723cULL, 0x000fe20000041830ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x0000105453527816ULL, 0x000fe40000000052ULL,
0x000010547b537816ULL, 0x000fe4000000007aULL, 0x00000010ff547819ULL, 0x000fe40000011673ULL,
0x00000010ff557819ULL, 0x000fc40000011674ULL, 0x00000010ff727819ULL, 0x000fe20000011672ULL,
0x000000521c2c723cULL, 0x040fe2000004182cULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x0000105455547816ULL, 0x000fe40000000054ULL, 0x0000105475557816ULL, 0x000fe20000000072ULL,
0x0000006928288231ULL, 0x082fe200003400ffULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x000000692a2a8231ULL, 0x000fe200003400ffULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x0000006a29298231ULL, 0x080fe200003400ffULL, 0x00000010ff727819ULL, 0x000fe2000001166bULL,
0x000000541c20723cULL, 0x000fe20000041820ULL, 0x00000010ff537819ULL, 0x000fe2000001166eULL,
0x0000006a2b2b8231ULL, 0x000fe200003400ffULL, 0x0000105471527816ULL, 0x000fc40000000076ULL,
0x0000105472537816ULL, 0x000fe40000000053ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x000000521c1c723cULL, 0x000fe20000041824ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x20000085ff637230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x00000010ff577819ULL, 0x000fe4000001164fULL, 0x00000010ff257819ULL, 0x000fe20000011664ULL,
0x20000081ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe40000011666ULL,
0x00000010ff267819ULL, 0x000fe40000011665ULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x0000105426257816ULL, 0x000fc40000000067ULL, 0x00000010ff267819ULL, 0x000fe4000001165cULL,
0x00000010ff277819ULL, 0x000fe4000001165dULL, 0x000010545f267816ULL, 0x000fe20000000026ULL,
0x00000024283c723cULL, 0x000fe2000004183cULL, 0x0000105460277816ULL, 0x000fe40000000027ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff5b7819ULL, 0x000fc4000001165bULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x000000262838723cULL, 0x000fe20000041838ULL,
0x000000ff57577812ULL, 0x000fe400078ec0ffULL, 0x00000010ff247819ULL, 0x000fe40000011659ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fc4000001164eULL, 0x00000010ff257819ULL, 0x000fe40000011668ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff277819ULL, 0x000fe40000011678ULL,
0x000010545a5a7816ULL, 0x000fe4000000005bULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00001054245b7816ULL, 0x000fe20000000063ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000008ff587819ULL, 0x000fe40000011658ULL,
0x0000105425247816ULL, 0x000fe2000000004eULL, 0x0000005a2834723cULL, 0x000fe20000041834ULL,
0x00000008ff4f7819ULL, 0x000fe4000001164fULL, 0x0000105427257816ULL, 0x000fc40000000056ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x000000242830723cULL, 0x000fe20000041830ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000080ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe2000001164aULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff4b7819ULL, 0x000fe2000001164bULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011662ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fc40000011657ULL, 0x00000010ff267819ULL, 0x000fe4000001164dULL,
0x00001054254a7816ULL, 0x000fe4000000004aULL, 0x00001054244b7816ULL, 0x000fe4000000004bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6f7819ULL, 0x000fe2000001166fULL, 0x0000004a2820723cULL, 0x000fe20000041820ULL,
0x00000010ff707819ULL, 0x000fc40000011670ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff4d7819ULL, 0x000fe40000011661ULL,
0x00000010ff257819ULL, 0x000fe40000011648ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff247819ULL, 0x000fc40000011649ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x000010546f547816ULL, 0x000fe4000000006cULL, 0x0000105470557816ULL, 0x000fe4000000006dULL,
0x000010544c4c7816ULL, 0x000fe40000000077ULL, 0x00001054264d7816ULL, 0x000fe4000000004dULL,
0x0000105425587816ULL, 0x000fe20000000058ULL, 0x000000542840723cULL, 0x000fe20000041840ULL,
0x0000105424597816ULL, 0x000fce000000004fULL, 0x0000004c282c723cULL, 0x040ff0000004182cULL,
0x00000058281c723cULL, 0x000fe2000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff247424ULL, 0x000fc800078e00ffULL,
0x0000002400257305ULL, 0x0002a4000021f000ULL, 0x3fa0000024247823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x004fe40003800000ULL, 0x01065c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007820cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000030051247a10ULL, 0x000fe20007ffe0ffULL,
0x00000100ff497424ULL, 0x000fe200078e00ffULL, 0x00000004ff2b7819ULL, 0x000fe40000011600ULL,
0x0000000124257810ULL, 0x040fe20007ffe0ffULL, 0x0000010024267824ULL, 0x000fc600078e00ffULL,
0x000000462500720cULL, 0x000fe20003f26070ULL, 0x0000620045297a24ULL, 0x000fe200078e0226ULL,
0x0000002647277217ULL, 0x000fc60007800000ULL, 0x0000000105247824ULL, 0x100fe400078e0229ULL,
0x0000000127277824ULL, 0x000fe400078e0a26ULL, 0x000000010a267824ULL, 0x000fe400078e0229ULL,
0x00005e0024247625ULL, 0x000fe200078e0049ULL, 0x0000002027277807ULL, 0x000fc60000800000ULL,
0x000000010b0b7824ULL, 0x000fe200078e0229ULL, 0x0000002744057217ULL, 0x000fe20007800000ULL,
0x00005e0026267625ULL, 0x000fe200078e0049ULL, 0x0000000624287210ULL, 0x000fc60007f3e0ffULL,
0x00000001052a7824ULL, 0x000fe200078e0a44ULL, 0x0000000626267210ULL, 0x000fe20007f7e0ffULL,
0x000000010c247824ULL, 0x000fe400078e0229ULL, 0x000000ffff297224ULL, 0x000fe200008e0625ULL,
0x0000002a2b00720cULL, 0x080fe20003f46070ULL, 0x00005e000b0a7625ULL, 0x080fe200078e0049ULL,
0x0000002a0700720cULL, 0x080fe40003f26070ULL, 0x0000002a0900720cULL, 0x000fe20003f86070ULL,
0x00005e0024247625ULL, 0x000fc800078e0049ULL, 0x000000ffff277224ULL, 0x000fe200018e0627ULL,
0x0000002a0800720cULL, 0x000fe40003f66070ULL, 0x000000060a087210ULL, 0x080fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000280f7faeULL, 0x0003e2000d101c46ULL,
0x0000000624067210ULL, 0x000fc60007fde0ffULL, 0x000000ffff097224ULL, 0x000fe200028e060bULL,
0x0000000026107faeULL, 0x0003e2000c901c46ULL, 0x000000ffff077224ULL, 0x000fc800030e0625ULL,
0x0000000008117faeULL, 0x0003e8000d901c46ULL, 0x0000000006127faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff057984ULL, 0x000ea20000000800ULL,
0x800000005e067824ULL, 0x002fca00078e00ffULL, 0x8000000005ff7812ULL, 0x004fe20007824806ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01065400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007824806ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x800000005e077824ULL, 0x000fe400078e00ffULL, 0x3e000000ff057424ULL, 0x000fc800078e00ffULL,
0x0000000500067305ULL, 0x0002a4000021f000ULL, 0x3fa0000005057823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x01065400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fc40007824807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000001428783bULL, 0x000e620000004200ULL,
0x00000002ff4f7819ULL, 0x000fc60000011600ULL, 0x000000001310783bULL, 0x000ea80000004200ULL,
0x000000001524783bULL, 0x000ee80000004200ULL, 0x000000001608783bULL, 0x000f220000004200ULL,
0x00000010ff657819ULL, 0x002fe4000001162aULL, 0x000000ff2a607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe4000001162aULL, 0x0000ffff2a627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff057819ULL, 0x104fe40000011611ULL, 0x000000ff114d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011611ULL, 0x0000ffff11747812ULL, 0x000fc400078ec0ffULL,
0x00000010ff667819ULL, 0x100fe4000001162bULL, 0x000000ff2b777812ULL, 0x040fe400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001162bULL, 0x0000ffff2b637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x008fe40000011624ULL, 0x000000ff24787812ULL, 0x000fc400078ec0ffULL,
0x00000018ff2b7819ULL, 0x000fe40000011624ULL, 0x0000ffff24117812ULL, 0x000fe400078ec0ffULL,
0x0000000dff24723eULL, 0x000fe400000010ffULL, 0x00000010ff727819ULL, 0x100fe40000011613ULL,
0x000000ff13557812ULL, 0x000fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fc40000011613ULL,
0x0000ffff136a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff697819ULL, 0x100fe40000011628ULL,
0x000000ff28577812ULL, 0x040fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe40000011628ULL,
0x0000ffff286d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x000fc40000011626ULL,
0x000000ff267c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fe40000011626ULL,
0x0000ffff260f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x110fe40000011609ULL,
0x000000ff09157812ULL, 0x000fe400078ec0ffULL, 0x00000018ff147819ULL, 0x000fc40000011609ULL,
0x0000ffff094a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe40000011612ULL,
0x000000ff12537812ULL, 0x040fe400078ec0ffULL, 0x00000018ff527819ULL, 0x000fe40000011612ULL,
0x0000ffff12717812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6e7819ULL, 0x000fc40000011629ULL,
0x000000ff29597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011629ULL,
0x0000ffff29647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff267819ULL, 0x100fe40000011608ULL,
0x000000ff080c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff137819ULL, 0x000fc40000011608ULL,
0x0000ffff085c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4b7819ULL, 0x100fe4000001160aULL,
0x000000ff0a097812ULL, 0x040fe400078ec0ffULL, 0x00000018ff077819ULL, 0x000fe4000001160aULL,
0x0000ffff0a287812ULL, 0x000fe400078ec0ffULL, 0x00000010ff297819ULL, 0x000fc4000001160bULL,
0x000000ff0b0a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff087819ULL, 0x000fe4000001160bULL,
0x0000ffff0b127812ULL, 0x000fe400078ec0ffULL, 0x00005410240b7816ULL, 0x000fe40000000024ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x00001f4f0b4f7589ULL, 0x000fe200000e0000ULL, 0x0000000cff0c723eULL, 0x000fe200020006ffULL,
0x20000057ff617230ULL, 0x000fe20000004100ULL, 0x00000060ff57723eULL, 0x000fe200020006ffULL,
0x00001f0e0b4e7589ULL, 0x0003e200000e0000ULL, 0x20000059ff607230ULL, 0x000fe20000004100ULL,
0x00000009ff09723eULL, 0x000fc400020006ffULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000052ff24723eULL, 0x000fe400020006ffULL,
0x00000078ff52723eULL, 0x000fe400020006ffULL, 0x00000058ff0b723eULL, 0x002fe200020006ffULL,
0x20000024ff247230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe2000001166dULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000018ff167819ULL, 0x000fe20000011627ULL,
0x2000000bff597230ULL, 0x000fe20000004100ULL, 0x00000015ff0b723eULL, 0x000fe200020006ffULL,
0x2000000cff157230ULL, 0x000fe20000004100ULL, 0x0000000aff0c723eULL, 0x000fc400020006ffULL,
0x00000007ff0a723eULL, 0x000fe200020006ffULL, 0x20000009ff077230ULL, 0x000fe20000004100ULL,
0x00000008ff09723eULL, 0x000fe200020006ffULL, 0x2000000cff0c7230ULL, 0x000fe20000004100ULL,
0x000000ff05087812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe200078ec0ffULL,
0x20000009ff057230ULL, 0x000fe20000004100ULL, 0x00000008ff08723eULL, 0x000fe400020006ffULL,
0x00000010ff067819ULL, 0x000fc40000011610ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x20000008ff787230ULL, 0x000fe20000004100ULL, 0x0000006eff08723eULL, 0x000fe400020006ffULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x2000004cff6c7230ULL, 0x000fe20000004100ULL,
0x0000006dff09723eULL, 0x000fe200020006ffULL, 0x20000008ff6d7230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fe200020006ffULL, 0x2000002bff4c7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fc400020006ffULL, 0x000000ff06067812ULL, 0x000fe200078ec0ffULL,
0x20000016ff2b7230ULL, 0x000fe20000004100ULL, 0x0000b80017087811ULL, 0x000fe200078e20ffULL,
0x20000069ff6e7230ULL, 0x000fe20000004100ULL, 0x00000006ff0e723eULL, 0x000fe200020006ffULL,
0x2000000bff167230ULL, 0x000fe20000004100ULL, 0x0000ffff10757812ULL, 0x000fe200078ec0ffULL,
0x2000000aff067230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe20000011625ULL,
0x20000009ff697230ULL, 0x000fe20000004100ULL, 0x00000008ff757819ULL, 0x000fe20000011675ULL,
0x000000000808783bULL, 0x000e620000000200ULL, 0x00000008ff747819ULL, 0x000fe20000011674ULL,
0x2000000eff0e7230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fc400078ec0ffULL,
0x000000ff10497812ULL, 0x000fe400078ec0ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6a7819ULL, 0x000fe2000001166aULL,
0x20000056ff587230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000008ff717819ULL, 0x000fc40000011671ULL, 0x00000008ff627819ULL, 0x000fe20000011662ULL,
0x20000055ff687230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe40000011610ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000049ff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff107819ULL, 0x000fe20000011627ULL,
0x0000004f08088231ULL, 0x082fe200003400ffULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x0000004f0a0a8231ULL, 0x000fe200003400ffULL, 0x000000ff65657812ULL, 0x000fe200078ec0ffULL,
0x0000004e09098231ULL, 0x080fe200003400ffULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x0000004e0b0b8231ULL, 0x000fe200003400ffULL, 0x00000077ff56723eULL, 0x000fe200020006ffULL,
0x20000075ff777230ULL, 0x000fe20000004100ULL, 0x000000ff66667812ULL, 0x000fe200078ec0ffULL,
0x20000073ff757230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000006aff737230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000062ff6a7230ULL, 0x000fe20000004100ULL, 0x00000076ff55723eULL, 0x000fe200020006ffULL,
0x20000074ff767230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000072ff747230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000071ff727230ULL, 0x000fe20000004100ULL, 0x0000ffff255d7812ULL, 0x000fe200078ec0ffULL,
0x20000064ff717230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000063ff627230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x2000005aff647230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000005fff637230ULL, 0x000fe20000004100ULL, 0x00000008ff117819ULL, 0x000fe20000011611ULL,
0x2000004dff707230ULL, 0x000fe20000004100ULL, 0x000000ff10107812ULL, 0x000fe200078ec0ffULL,
0x20000048ff6b7230ULL, 0x000fe20000004100ULL, 0x00000066ff17723eULL, 0x000fe200020006ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff5d7819ULL, 0x000fe2000001165dULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000011ff11723eULL, 0x000fe200020006ffULL,
0x20000017ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff5f723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000008ff5a7819ULL, 0x000fc4000001160fULL,
0x00000010ff107819ULL, 0x000fe2000001166fULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff0f7819ULL, 0x000fe4000001160eULL, 0x000000ff5e177812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5e723eULL, 0x000fe200020006ffULL, 0x20000011ff5d7230ULL, 0x000fe20000004100ULL,
0x000010540f107816ULL, 0x000fe40000000010ULL, 0x00000010ff117819ULL, 0x000fe20000011670ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fc40000011678ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff0e7819ULL, 0x000fe40000011677ULL, 0x00000010ff0f7819ULL, 0x000fe40000011676ULL,
0x000000ff257a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff797819ULL, 0x000fc40000011625ULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000054ff25723eULL, 0x000fe400020006ffULL,
0x0000105478117816ULL, 0x000fe20000000011ULL, 0x20000053ff677230ULL, 0x000fe20000004100ULL,
0x000010546b0e7816ULL, 0x000fe2000000000eULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x000010546c0f7816ULL, 0x000fe4000000000fULL, 0x000000ff277d7812ULL, 0x040fe200078ec0ffULL,
0x000000100840723cULL, 0x000fe20000041840ULL, 0x0000ffff27277812ULL, 0x000fc400078ec0ffULL,
0x000000ff26267812ULL, 0x000fe400078ec0ffULL, 0x00000008ff277819ULL, 0x000fe40000011627ULL,
0x00000010ff107819ULL, 0x000fe20000011667ULL, 0x0000000e083c723cULL, 0x000fe2000004183cULL,
0x00000010ff117819ULL, 0x000fe40000011668ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000010ff0f7819ULL, 0x000fe40000011624ULL,
0x00000010ff247819ULL, 0x000fe40000011625ULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x00000010ff0e7819ULL, 0x000fe20000011672ULL,
0x20000027ff677230ULL, 0x000fe20000004100ULL, 0x0000b80018257811ULL, 0x000fe200078e20ffULL,
0x20000026ff187230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fc40000011673ULL,
0x0000105475107816ULL, 0x000fe40000000010ULL, 0x0000105474117816ULL, 0x000fe40000000011ULL,
0x000010540f0e7816ULL, 0x000fe4000000000eULL, 0x00001054240f7816ULL, 0x000fe40000000073ULL,
0x000000002524783bULL, 0x000e620000000200ULL, 0x000000100838723cULL, 0x000fe20000041838ULL,
0x00000010ff607819ULL, 0x000fc40000011660ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x00000010ff107819ULL, 0x000fe20000011661ULL,
0x0000000e0834723cULL, 0x000fe20000041834ULL, 0x00000010ff117819ULL, 0x000fe2000001166eULL,
0x2000002aff537230ULL, 0x000fe20000004100ULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x0000105411107816ULL, 0x000fc40000000010ULL, 0x000010546d117816ULL, 0x000fe40000000060ULL,
0x00000008ff5c7819ULL, 0x000fe4000001165cULL, 0x0000005bff61723eULL, 0x000fe400020006ffULL,
0x0000005cff5b723eULL, 0x000fe200020006ffULL, 0x000000100830723cULL, 0x000fe20000041830ULL,
0x00000010ff0f7819ULL, 0x000fe40000011658ULL, 0x00000010ff0e7819ULL, 0x000fe20000011669ULL,
0x2000005bff587230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fe20000011659ULL,
0x20000061ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff107819ULL, 0x000fc40000011657ULL,
0x00000010ff117819ULL, 0x000fe40000011666ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff557819ULL, 0x000fe20000011655ULL, 0x0000004f24248231ULL, 0x082fe200003400ffULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x0000004f26268231ULL, 0x000fe200003400ffULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x0000004e25258231ULL, 0x080fe200003400ffULL,
0x00000010ff627819ULL, 0x000fe20000011662ULL, 0x0000004e27278231ULL, 0x000fe200003400ffULL,
0x00000079ff4d723eULL, 0x000fc400020006ffULL, 0x000010540f0e7816ULL, 0x000fe4000000000eULL,
0x0000105411107816ULL, 0x000fe20000000010ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x000010545c0f7816ULL, 0x000fe40000000071ULL, 0x0000105465117816ULL, 0x000fe40000000056ULL,
0x00001054556a7816ULL, 0x000fe4000000006aULL, 0x00001054536b7816ULL, 0x000fe20000000062ULL,
0x0000000e082c723cULL, 0x000fe2000004182cULL, 0x0000007cff49723eULL, 0x000fc400020006ffULL,
0x0000007dff48723eULL, 0x000fe400020006ffULL, 0x00000017ff17723eULL, 0x000fe200020006ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe20000011667ULL,
0x000000100820723cULL, 0x000fe20000041820ULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x000000ff4b4b7812ULL, 0x000fe200078ec0ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff157819ULL, 0x000fc40000011615ULL,
0x0000006a081c723cULL, 0x000fe2000004181cULL, 0x00000010ff187819ULL, 0x000fe40000011618ULL,
0x00000008ff4a7819ULL, 0x000fe4000001164aULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x00000010ff087819ULL, 0x000fe4000001164dULL, 0x00000010ff4d7819ULL, 0x000fe2000001165eULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff097819ULL, 0x000fc40000011648ULL,
0x00001054084d7816ULL, 0x000fe4000000004dULL, 0x00000010ff087819ULL, 0x000fe40000011617ULL,
0x00000010ff0a7819ULL, 0x000fe4000001165fULL, 0x0000105408087816ULL, 0x000fe40000000049ULL,
0x000010540a097816ULL, 0x000fe40000000009ULL, 0x00000010ff0a7819ULL, 0x000fc4000001162bULL,
0x000000ff29297812ULL, 0x000fe400078ec0ffULL, 0x000010540a5b7816ULL, 0x000fe2000000005bULL,
0x000000082438723cULL, 0x000fe20000041838ULL, 0x00000010ff0a7819ULL, 0x000fe40000011659ULL,
0x00000008ff287819ULL, 0x000fe40000011628ULL, 0x00000008ff127819ULL, 0x000fe40000011612ULL,
0x00000010ff097819ULL, 0x000fc40000011616ULL, 0x0000105418087816ULL, 0x000fe40000000015ULL,
0x000010540a097816ULL, 0x000fe40000000009ULL, 0x0000007aff54723eULL, 0x000fe400020006ffULL,
0x0000007bff2a723eULL, 0x000fe400020006ffULL, 0x00000013ff13723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000013ff137230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000012ff12723eULL, 0x000fe200020006ffULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x000000082430723cULL, 0x000fe20000041830ULL,
0x20000028ff287230ULL, 0x000fe20000004100ULL, 0x00000010ff077819ULL, 0x000fe20000011607ULL,
0x20000012ff127230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fc40000011652ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff087819ULL, 0x000fe4000001164bULL,
0x00000010ff0f7819ULL, 0x000fe40000011664ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff0b7819ULL, 0x000fe4000001162aULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff137819ULL, 0x000fe40000011613ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff597819ULL, 0x000fe40000011614ULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff097819ULL, 0x000fe4000001160cULL, 0x00000010ff0a7819ULL, 0x000fe40000011629ULL,
0x0000105408087816ULL, 0x000fe40000000007ULL, 0x00000010ff077819ULL, 0x000fe40000011606ULL,
0x00000010ff287819ULL, 0x000fe40000011628ULL, 0x00000010ff057819ULL, 0x000fc40000011605ULL,
0x00000010ff127819ULL, 0x000fe40000011612ULL, 0x000010540f527816ULL, 0x000fe40000000052ULL,
0x0000105463537816ULL, 0x000fe40000000054ULL, 0x000010544c4c7816ULL, 0x000fe4000000005dULL,
0x000010540b5a7816ULL, 0x000fe4000000005aULL, 0x0000105413587816ULL, 0x000fe20000000058ULL,
0x000000522440723cULL, 0x000fe20000041840ULL, 0x0000105459597816ULL, 0x000fc4000000004aULL,
0x000010540a097816ULL, 0x000fe40000000009ULL, 0x0000105407287816ULL, 0x000fe40000000028ULL,
0x0000105405297816ULL, 0x000fe20000000012ULL, 0x0000004c243c723cULL, 0x040ff0000004183cULL,
0x0000005a2434723cULL, 0x040ff00000041834ULL, 0x00000058242c723cULL, 0x040ff0000004182cULL,
0x000000082420723cULL, 0x040ff00000041820ULL, 0x000000282424723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01064000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff04ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff5f7807ULL, 0x000fe40004000000ULL, 0x0000030051517a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff02ff7812ULL, 0x000fe4000780c0ffULL, 0x000000465100720cULL, 0x000fe40003f26070ULL,
0x00000001ff027807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff07f000007947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x002e640000002500ULL,
0x000000460700720cULL, 0x002fda0003f06070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x018000001a007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e001aULL,
0x000106a000047802ULL, 0x000fe40000000f00ULL, 0x00008b9000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001a00037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc8000000001aULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x00000002ff097819ULL, 0x008fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x004fca0000410000ULL,
0x00001f0900047589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000004004407220ULL, 0x044fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000004205427220ULL, 0x048fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x00000000000e7919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000020e007812ULL, 0x004fc400078ec0ffULL, 0x00000002ff0f7819ULL, 0x000fe4000001160eULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000200037811ULL, 0x040fe400078ff8ffULL,
0x0000000400067811ULL, 0x040fe400078ff8ffULL, 0x00000006000a7811ULL, 0x000fe400078ff8ffULL,
0x000000080e177811ULL, 0x000fc400078ff0ffULL, 0x0000000702007812ULL, 0x100fe400078e780fULL,
0x0000000706087812ULL, 0x040fe400078e780fULL, 0x0000000706067812ULL, 0x100fe200078e7817ULL,
0x000000080f057824ULL, 0x000fe200078e0200ULL, 0x0000000702027812ULL, 0x000fe200078e7817ULL,
0x0000080050007824ULL, 0x000fe200078e00ffULL, 0x0000000703047812ULL, 0x100fe200078e780fULL,
0x0000000817157824ULL, 0x040fe200078e0206ULL, 0x000000070a0c7812ULL, 0x000fe200078e780fULL,
0x00000008170d7824ULL, 0x000fe200078e0202ULL, 0x0000000703037812ULL, 0x100fe200078e7817ULL,
0x000000080e067824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7812ULL, 0x000fe200078e7817ULL,
0x000000080f097824ULL, 0x040fe200078e0204ULL, 0x0000a00000027810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0b7824ULL, 0x000fe200078e0208ULL, 0x0000000806067812ULL, 0x000fe200078ec0ffULL,
0x0000000817137824ULL, 0x000fe200078e0203ULL, 0x000000404103723eULL, 0x000fe200000010ffULL,
0x000000080f0f7824ULL, 0x000fe200078e020cULL, 0x0000003c3d04723eULL, 0x000fe200000010ffULL,
0x0000000817177824ULL, 0x000fe200078e020aULL, 0x000000424308723eULL, 0x000fe200000010ffULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x0000541003187816ULL, 0x000fe20000000004ULL,
0x000000100d117824ULL, 0x000fe200078e0202ULL, 0x0000763203197816ULL, 0x000fe20000000004ULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0x000000303103723eULL, 0x000fe200000010ffULL,
0x0000001013137824ULL, 0x100fe200078e0202ULL, 0x0000002c2d04723eULL, 0x000fe200000010ffULL,
0x000000100b0d7824ULL, 0x000fc400078e0202ULL, 0x000000100f0f7824ULL, 0x100fe400078e0202ULL,
0x0000001015157824ULL, 0x100fe400078e0202ULL, 0x0000001017177824ULL, 0x000fe400078e0202ULL,
0x00000001050a7824ULL, 0x000fe200078e0206ULL, 0x000000383905723eULL, 0x000fe200000010ffULL,
0x0000000106117824ULL, 0x040fe400078e0211ULL, 0x00000001060b7824ULL, 0x040fe200078e0209ULL,
0x000000180a007388ULL, 0x0005e20000000a00ULL, 0x0000000106137824ULL, 0x040fe200078e0213ULL,
0x0000003e3f09723eULL, 0x000fe200000010ffULL, 0x00000001060d7824ULL, 0x000fc400078e020dULL,
0x00000001060f7824ULL, 0x040fe400078e020fULL, 0x0000000106157824ULL, 0x040fe400078e0215ULL,
0x0000000106177824ULL, 0x000fe200078e0217ULL, 0x000000343506723eULL, 0x000fe400000010ffULL,
0x00005410030a7816ULL, 0x004fe40000000004ULL, 0x0000541005187816ULL, 0x140fe40000000006ULL,
0x0000763205197816ULL, 0x000fc40000000006ULL, 0x000000202105723eULL, 0x000fe400000010ffULL,
0x000000242506723eULL, 0x000fe200000010ffULL, 0x000000180b007388ULL, 0x0005e40000000a00ULL,
0x00007632030b7816ULL, 0x004fe40000000004ULL, 0x0000003a3b03723eULL, 0x000fe400000010ffULL,
0x000000363704723eULL, 0x000fe200000010ffULL, 0x0000000a0d007388ULL, 0x0005e40000000a00ULL,
0x00005410050a7816ULL, 0x004fc40000000006ULL, 0x00007632050b7816ULL, 0x000fe40000000006ULL,
0x000000323305723eULL, 0x000fe400000010ffULL, 0x0000002e2f06723eULL, 0x000fe200000010ffULL,
0x0000000a0f007388ULL, 0x0005e40000000a00ULL, 0x00005410080a7816ULL, 0x144fe40000000009ULL,
0x00007632080b7816ULL, 0x000fe40000000009ULL, 0x000000262709723eULL, 0x000fe200000010ffULL,
0x00000300ff277624ULL, 0x000fe200078e00ffULL, 0x000000222308723eULL, 0x000fe200000010ffULL,
0x0000000a11007388ULL, 0x0005e60000000a00ULL, 0x000000012700780cULL, 0x000fc40003f05270ULL,
0x00005410030a7816ULL, 0x144fe40000000004ULL, 0x00007632030b7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000000a13007388ULL, 0x0005e80000000a00ULL, 0x0000000415007388ULL, 0x0007e20000000a00ULL,
0x00005410080a7816ULL, 0x004fc40000000009ULL, 0x00007632080b7816ULL, 0x000fca0000000009ULL,
0x0000000a17007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002ca000008947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000580027047a24ULL, 0x008fe200078e02ffULL, 0x000000ff5000720cULL, 0x000fe40003f25270ULL,
0x0000000000267919ULL, 0x000ee20000002700ULL, 0x0000640004187a24ULL, 0x000fc600078e02ffULL,
0x0000000000057919ULL, 0x000ee20000002600ULL, 0x0000001003197824ULL, 0x044fe200078e0200ULL,
0x0000002003217810ULL, 0x040fe40007ffe0ffULL, 0x0000004003237810ULL, 0x040fe40007ffe0ffULL,
0x00a0000019087984ULL, 0x0005220000000c00ULL, 0x0000006003257810ULL, 0x000fe20007ffe0ffULL,
0x0000580026267a24ULL, 0x008fe400078e0205ULL, 0x00a20000190c7984ULL, 0x0004e20000000c00ULL,
0x00001fff18057811ULL, 0x000fe200078e40ffULL, 0x0000030026047a24ULL, 0x000fc400078e02ffULL,
0x00a4000019107984ULL, 0x0004620000000c00ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x00000001041c7824ULL, 0x000fe400078e0207ULL, 0x00a6000019147984ULL, 0x0004620000000c00ULL,
0x00002000ff077424ULL, 0x000fe200078e00ffULL, 0x000000ff5000720cULL, 0x000fe40000705670ULL,
0x0000001c05067211ULL, 0x000fca00078f98ffULL, 0x00006a0006067625ULL, 0x000fcc00078e0007ULL,
0x0000080050067825ULL, 0x000fcc00078e0006ULL, 0x0000001021207825ULL, 0x000fc800078e0006ULL,
0x0000001023227825ULL, 0x000fc800078e0006ULL, 0x0000001025247825ULL, 0x000fc800078e0006ULL,
0x00000010031e7825ULL, 0x000fe200078e0006ULL, 0x01ffffff18077812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x01cea20000000000ULL,
0x00000080ff067424ULL, 0x000fe400078e00ffULL, 0x000000011c1d7824ULL, 0x000fe400078e0207ULL,
0x0000001018287824ULL, 0x004fe200078e00ffULL, 0x00000001ff2a7819ULL, 0x000fe20000011618ULL,
0x00006a001c187625ULL, 0x000fc600078e0006ULL, 0x0000007028297812ULL, 0x000fe200078ec0ffULL,
0x00006a001d1c7625ULL, 0x000fe200078e0006ULL, 0x0000000c2a2a7812ULL, 0x000fc800078ec0ffULL,
0x000000182a187210ULL, 0x140fe40007b5e029ULL, 0x0000001c2a1c7210ULL, 0x000fe40007d9e029ULL,
0x00000019ff197210ULL, 0x000fe400017e64ffULL, 0x0000001dff1d7210ULL, 0x000fc600027ea4ffULL,
0x0000001b18007986ULL, 0x0005e8000c101906ULL, 0x0000001a1c007986ULL, 0x0005e4000c101906ULL,
0x000000081e007986ULL, 0x01c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000000c20007986ULL, 0x0005e8000c101d06ULL, 0x0000001022007986ULL, 0x0025e8000c101d06ULL,
0x0000001424007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x004fe200078e00ffULL,
0xffffffff270b7810ULL, 0x000fc60007ffe0ffULL, 0x0000680026087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff067807ULL, 0x000fca0000000000ULL,
0x00000006ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x002e640000000000ULL,
0x000000ff0600720cULL, 0x002fda0003f05270ULL, 0x0000283000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x004fe20000011603ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001040a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff177424ULL, 0x000fe200078e00ffULL, 0x0000000c080c7812ULL, 0x000fe400078ec0ffULL,
0x0000007006197812ULL, 0x000fe200078ec0ffULL, 0x00006a0004087625ULL, 0x000fc800078e0017ULL,
0x00006a000a0a7625ULL, 0x000fe200078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x0000000a0c0a7210ULL, 0x000fe40007b5e019ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608067981ULL, 0x000368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x000000022700780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000042700780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000042700780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608137981ULL, 0x000362000c1e1900ULL,
0x000000062700780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608157981ULL, 0x000362000c1e1900ULL, 0x000000062700780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082700780cULL, 0x002fe40003f06070ULL,
0x0000000604087810ULL, 0x000fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fe40007a3e019ULL, 0x00000007040a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006a000a0a0625ULL, 0x000fe400078e0017ULL,
0x0000000608177981ULL, 0x000366000c1e1900ULL, 0x0000000a0c0a0210ULL, 0x000fc80007c7e019ULL,
0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL, 0x000000060a0b0981ULL, 0x000366000c1e1900ULL,
0x0000000727087810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e0006ULL,
0x00000008190c7824ULL, 0x040fe200078e00ffULL, 0x0000000119197810ULL, 0x000fc80007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x0000000a1900720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080c097810ULL, 0x040fe40007ffe0ffULL,
0x000000010c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001b06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e1b7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e01bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006081b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090c097810ULL, 0x042fe40007ffe0ffULL, 0x000000020c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000030c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000040c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000050c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000060c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e015ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000070c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e017ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0c097810ULL, 0x002fe40007ffe0ffULL, 0x0000000b06067209ULL, 0x000fe40007810000ULL,
0x0000030009007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010030b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080c087210ULL, 0x000fc80007a3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080b7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003087824ULL, 0x006fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011603ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108097824ULL, 0x000fca00078e0209ULL, 0x0000000609007388ULL, 0x0203e40000000800ULL,
0x00000004050a7211ULL, 0x004fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000080050067824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x00000015ff087819ULL, 0x000fe20000011650ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000c0c0e7812ULL, 0x000fe200078ec0ffULL,
0x0000001003097824ULL, 0x040fe200078e00ffULL, 0x000000060a0c7210ULL, 0x000fe20007f3e0ffULL,
0x00001000500a7824ULL, 0x000fe200078e00ffULL, 0x00000020030f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000007009097812ULL, 0x000fe200078ec0ffULL,
0x0000000104108824ULL, 0x000fe200078e0207ULL, 0x0000004003137810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000006003177810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0d7824ULL, 0x000fe200008e0608ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff1b8424ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200078e020eULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00006a0010108625ULL, 0x000fe200078e0011ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000100f0e7825ULL, 0x100fe200078e000cULL, 0x0000000009097984ULL, 0x000e660000000800ULL,
0x0000001013127825ULL, 0x000fc800078e000cULL, 0x0000001017167825ULL, 0x000fc800078e000cULL,
0x00000010501f8824ULL, 0x000fe400078e0203ULL, 0x00006a00041a8625ULL, 0x000fc600078e001bULL,
0x000045801f1f8811ULL, 0x000fe200078e20ffULL, 0x00000010031d7824ULL, 0x040fe400078e020aULL,
0x00000010030c7825ULL, 0x000fc800078e000cULL, 0x00000010500b8824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c1d7faeULL, 0x0005e2000b901c46ULL,
0x0000001003188825ULL, 0x000fc600078e0010ULL, 0x000041800b118811ULL, 0x000fe200078e20ffULL,
0x00000010031a8825ULL, 0x000fe200078e001aULL, 0x003800000e1d7faeULL, 0x0007e6000b901c46ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x00580000121d7faeULL, 0x0009e2000b901c46ULL,
0x00000000000c7805ULL, 0x004fc6000001ff00ULL, 0x00780000161d7faeULL, 0x0005e8000b901c46ULL,
0x00000000181f8faeULL, 0x000be2000b901c46ULL, 0x00000000000e7805ULL, 0x008fc6000001ff00ULL,
0x000000001a118faeULL, 0x0007e2000b901c46ULL, 0x0000000000127805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000167805ULL, 0x004fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x020fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x008fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000d6000009947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x002fe400078e00ffULL, 0x000000ffff2c7224ULL, 0x000fca00078e00ffULL,
0x000000012c2d7810ULL, 0x000fc80007ffe0ffULL, 0x000003002d007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x00000001043a7824ULL, 0x000fe200078e022dULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x00002000ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000012d337812ULL, 0x040fe200078ec0ffULL, 0x000008002d307824ULL, 0x000fe200078e00ffULL,
0x0000003a052e7211ULL, 0x000fe400078f98ffULL, 0x0000002003357810ULL, 0x040fe40007ffe0ffULL,
0x0000080030317812ULL, 0x000fe200078ec0ffULL, 0x00006a002e2e7625ULL, 0x000fe200078e002fULL,
0x0000004003397810ULL, 0x000fc40007ffe0ffULL, 0x00000060033d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a307824ULL, 0x000fe200078e0231ULL, 0x000000062e2e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000107369824ULL, 0x000fe400078e023aULL, 0x00000080ff379424ULL, 0x000fe400078e00ffULL,
0x000000012f2f7824ULL, 0x000fe400000e0608ULL, 0x0000000250389824ULL, 0x140fe400078e0233ULL,
0x00000002503c9824ULL, 0x000fc400078e0233ULL, 0x00000080ff3f9424ULL, 0x000fe400078e00ffULL,
0x00000010033b7824ULL, 0x000fe400078e0230ULL, 0x0000001035327825ULL, 0x000fc800078e002eULL,
0x0000001039347825ULL, 0x000fc800078e002eULL, 0x0000001003307825ULL, 0x000fc800078e002eULL,
0x000000103d2e7825ULL, 0x000fe200078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000303b7faeULL, 0x0003e6000b901c46ULL, 0x00006a0036369625ULL, 0x000fe200078e0037ULL,
0x00380000323b7faeULL, 0x0003e6000b901c46ULL, 0x00000008383d9824ULL, 0x000fe200078e0203ULL,
0x00580000343b7faeULL, 0x0003e2000b901c46ULL, 0x00006a003a389625ULL, 0x000fc600078e003fULL,
0x000045803d3d9811ULL, 0x000fe200078e20ffULL, 0x000000083c3c9824ULL, 0x000fe200078e0203ULL,
0x007800002e3b7faeULL, 0x0003e2000b901c46ULL, 0x0000001003369825ULL, 0x000fc600078e0036ULL,
0x000041803c3f9811ULL, 0x000fe200078e20ffULL, 0x0000001003389825ULL, 0x000fe200078e0038ULL,
0x00000000363d9faeULL, 0x0003e8000b901c46ULL, 0x00000000383f9faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff317224ULL, 0x002fe200078e002cULL,
0x00000001ff307819ULL, 0x100fe20000011603ULL, 0x00000010032e7824ULL, 0x000fe200078e00ffULL,
0x00000002ff377819ULL, 0x000fe20000011603ULL, 0x00000080312c7824ULL, 0x000fe200078e00ffULL,
0x0000000c30307812ULL, 0x000fc400078ec0ffULL, 0x000000702e2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000837357824ULL, 0x040fe200078e00ffULL, 0x000000802c2f7812ULL, 0x000fe200078ec0ffULL,
0x00000008372c7824ULL, 0x040fe200078e00ffULL, 0x0000000837397810ULL, 0x040fe40007ffe0ffULL,
0x0000000737337812ULL, 0x000fe200078ec0ffULL, 0x00000100502f7824ULL, 0x000fe200078e022fULL,
0x00000039ff4c7212ULL, 0x000fe200078e33ffULL, 0x00000008393b7824ULL, 0x000fe200078e00ffULL,
0x00000037ff3e7212ULL, 0x000fc400078e33ffULL, 0x0000002f302f7210ULL, 0x000fe20007ffe02eULL,
0x00000008372e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8353e7812ULL, 0x000fe200078ee23eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002f307984ULL, 0x000e620000000800ULL,
0x000000012e327812ULL, 0x140fe400078ef633ULL, 0x000000022e347812ULL, 0x140fe200078ef633ULL,
0x004580002f4e7984ULL, 0x0004e20000000800ULL, 0x000000032e367812ULL, 0x140fe400078ef633ULL,
0x000000042e387812ULL, 0x140fe400078ef633ULL, 0x000000052e3a7812ULL, 0x140fe400078ef633ULL,
0x000000062e3c7812ULL, 0x100fe200078ef633ULL, 0x00000008392f7824ULL, 0x004fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee233ULL, 0x00000800312e7824ULL, 0x000fc400078e00ffULL,
0x0000000839337824ULL, 0x000fe200078e00ffULL, 0xfffffff82f4c7812ULL, 0x000fe400078ee24cULL,
0x000008002e2f7812ULL, 0x000fe400078ec0ffULL, 0x00000007392e7812ULL, 0x000fe400078ec0ffULL,
0x000001800a2f7810ULL, 0x000fe40007ffe02fULL, 0x0000000133407812ULL, 0x140fe400078ef62eULL,
0x0000000233427812ULL, 0x140fe200078ef62eULL, 0x000000102c2c7824ULL, 0x100fe200078e022fULL,
0x0000000333467812ULL, 0x140fe200078ef62eULL, 0x000000103e3e7824ULL, 0x100fe200078e022fULL,
0x0000000433487812ULL, 0x140fe200078ef62eULL, 0x0000001034347824ULL, 0x100fe200078e022fULL,
0x00000005334a7812ULL, 0x000fe200078ef62eULL, 0x0000001036367824ULL, 0x000fc400078e022fULL,
0x0000001038387824ULL, 0x100fe400078e022fULL, 0x0000001032327824ULL, 0x100fe200078e022fULL,
0x0000003009307221ULL, 0x002fe20000010100ULL, 0x000000103a3a7824ULL, 0x100fe400078e022fULL,
0x000000103c3c7824ULL, 0x100fe200078e022fULL, 0x3fb8aa3b30357820ULL, 0x000fe20000410000ULL,
0x0000000403307824ULL, 0x000fe400078e00ffULL, 0x0000001040407824ULL, 0x000fc400078e022fULL,
0x0000001042427824ULL, 0x100fe200078e022fULL, 0x0000000c30317812ULL, 0x000fe200078ec0ffULL,
0x0000003500357308ULL, 0x000ee20000000800ULL, 0xfffffff83b307812ULL, 0x100fe200078ee22eULL,
0x0000001046467824ULL, 0x000fe200078e022fULL, 0x00000006332e7812ULL, 0x000fe200078ef62eULL,
0x000000012c2c7824ULL, 0x000fe400078e0231ULL, 0x00000001313e7824ULL, 0x040fe400078e023eULL,
0x0000000131347824ULL, 0x000fc400078e0234ULL, 0x000000002c2c7984ULL, 0x000e620000000800ULL,
0x0000000131367824ULL, 0x040fe400078e0236ULL, 0x0000000131387824ULL, 0x000fe200078e0238ULL,
0x000000003e3e7984ULL, 0x000fe20000000800ULL, 0x0000001030307824ULL, 0x100fe200078e022fULL,
0x0000004e354e7220ULL, 0x008fe20000410000ULL, 0x0000001048487824ULL, 0x100fe200078e022fULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x000000104a4a7824ULL, 0x000fe200078e022fULL,
0x0000002b4e2b7221ULL, 0x000fe20000010000ULL, 0x000000102e2e7824ULL, 0x100fe200078e022fULL,
0x00001f374e337589ULL, 0x000ea200000e0000ULL, 0x000000104c4c7824ULL, 0x000fc400078e022fULL,
0x0000000131327824ULL, 0x040fe200078e0232ULL, 0x0000000036367984ULL, 0x000fe20000000800ULL,
0x0000000131407824ULL, 0x040fe400078e0240ULL, 0x0000000131427824ULL, 0x040fe200078e0242ULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x00000001313a7824ULL, 0x040fe400078e023aULL,
0x0000000131467824ULL, 0x040fe200078e0246ULL, 0x0000000032327984ULL, 0x000ee20000000800ULL,
0x00000001313c7824ULL, 0x000fc400078e023cULL, 0x0000000131487824ULL, 0x040fe200078e0248ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x0000000131307824ULL, 0x040fe400078e0230ULL,
0x00000001314a7824ULL, 0x040fe200078e024aULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x00000001312e7824ULL, 0x040fe400078e022eULL, 0x00000001314c7824ULL, 0x000fe200078e024cULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x00005410ff2f7816ULL, 0x002fc6000000002cULL,
0x0000000046467984ULL, 0x000fe40000000800ULL, 0x000000332f267223ULL, 0x004fe20000010026ULL,
0x00007610ff2f7816ULL, 0x000fe2000000002cULL, 0x00001f394e4e7589ULL, 0x000fe200000e0000ULL,
0x00005410ff2c7816ULL, 0x000fc6000000003eULL, 0x000000003c3c7984ULL, 0x000e620000000800ULL,
0x000000332f207223ULL, 0x080fe20000010020ULL, 0x000000332c277223ULL, 0x080fe20000010027ULL,
0x00007610ff2c7816ULL, 0x000fe2000000003eULL, 0x0000000048487984ULL, 0x000fe80000000800ULL,
0x000000332c157223ULL, 0x000fe20000010015ULL, 0x00005410ff2c7816ULL, 0x000fe20000000034ULL,
0x0000000030307984ULL, 0x000ea20000000800ULL, 0x00005410ff2f7816ULL, 0x008fc60000000032ULL,
0x000000332c177223ULL, 0x080fe20000010017ULL, 0x00005410ff2c7816ULL, 0x000fe20000000036ULL,
0x000000004a4a7984ULL, 0x000fe20000000800ULL, 0x000000332f1a7223ULL, 0x080fe2000001001aULL,
0x00007610ff2f7816ULL, 0x000fe40000000032ULL, 0x000000332c1f7223ULL, 0x080fe2000001001fULL,
0x00007610ff2c7816ULL, 0x000fe20000000036ULL, 0x000000002e317984ULL, 0x000ee20000000800ULL,
0x000000332f287223ULL, 0x000fe20000010028ULL, 0x00007610ff2f7816ULL, 0x000fc40000000034ULL,
0x000000332c0f7223ULL, 0x080fe2000001000fULL, 0x00005410ff2c7816ULL, 0x000fe20000000038ULL,
0x000000004c4c7984ULL, 0x000f620000000800ULL, 0x000000332f0e7223ULL, 0x080fe2000001000eULL,
0x00005410ff2f7816ULL, 0x010fe4000000003aULL, 0x000000332c1b7223ULL, 0x080fe2000001001bULL,
0x00007610ff2c7816ULL, 0x000fe40000000038ULL, 0x000000332f187223ULL, 0x000fe20000010018ULL,
0x00007610ff2f7816ULL, 0x000fc4000000003aULL, 0x000000332c0d7223ULL, 0x080fe2000001000dULL,
0x00005410ff2c7816ULL, 0x000fe40000000040ULL, 0x000000332f1e7223ULL, 0x080fe2000001001eULL,
0x00005410ff2f7816ULL, 0x002fe4000000003cULL, 0x0000004e2c257223ULL, 0x000fe20000010025ULL,
0x00005410ff2c7816ULL, 0x000fe40000000042ULL, 0x000000332f147223ULL, 0x000fe20000010014ULL,
0x00007610ff2f7816ULL, 0x000fc4000000003cULL, 0x0000004e2c217223ULL, 0x080fe20000010021ULL,
0x00007610ff2c7816ULL, 0x000fe40000000042ULL, 0x000000332f2a7223ULL, 0x000fe2000001002aULL,
0x00005410ff2f7816ULL, 0x004fe40000000030ULL, 0x0000004e2c297223ULL, 0x080fe20000010029ULL,
0x00005410ff2c7816ULL, 0x000fe40000000046ULL, 0x0000004e2f127223ULL, 0x000fe20000010012ULL,
0x00007610ff2f7816ULL, 0x000fc40000000030ULL, 0x0000004e2c1d7223ULL, 0x080fe2000001001dULL,
0x00007610ff2c7816ULL, 0x000fe40000000046ULL, 0x00005410ff2e7816ULL, 0x008fe20000000031ULL,
0x0000004e2f227223ULL, 0x080fe20000010022ULL, 0x00007610ff2f7816ULL, 0x000fe20000000040ULL,
0x0000004e2c237223ULL, 0x080fe20000010023ULL, 0x00005410ff2c7816ULL, 0x000fe20000000048ULL,
0x0000004e2e137223ULL, 0x080fe20000010013ULL, 0x00007610ff2e7816ULL, 0x020fe2000000004cULL,
0x0000004e2f1c7223ULL, 0x080fe2000001001cULL, 0x00005410ff2f7816ULL, 0x000fe2000000004aULL,
0x0000004e2c197223ULL, 0x080fe20000010019ULL, 0x00007610ff2c7816ULL, 0x000fe20000000048ULL,
0x0000004e2e0b7223ULL, 0x000fc4000001000bULL, 0x0000004e2f167223ULL, 0x080fe40000010016ULL,
0x0000004e2c117223ULL, 0x000fe20000010011ULL, 0x000000ffff2c7224ULL, 0x000fe200078e002dULL,
0x00007610ff2d7816ULL, 0x000fc8000000004aULL, 0x000003002c007a0cULL, 0x000fe20003f06070ULL,
0x0000004e2d247223ULL, 0x000fe20000010024ULL, 0x00007610ff2d7816ULL, 0x000fca0000000031ULL,
0x0000004e2d0c7223ULL, 0x000fe2000001000cULL, 0x00005410ff2d7816ULL, 0x000fca000000004cULL,
0x0000004e2d107223ULL, 0x000fe20000010010ULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x018000002b037810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000003037812ULL, 0x000fc600078ec0ffULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x000132a000047802ULL, 0x000fe40000000f00ULL, 0x00005f9000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002b00047308ULL, 0x000e640000001000ULL,
0xbf80000004037423ULL, 0x002fc8000000002bULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000304037223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000002b7919ULL, 0x006e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000082b2f7811ULL, 0x002fe400078ff0ffULL, 0x00000002ff2c7819ULL, 0x000fe4000001162bULL,
0x0000002fff317212ULL, 0x000fe200078e33ffULL, 0x00001f2f030a7589ULL, 0x008e6800000e0000ULL,
0x00001f2c03057589ULL, 0x000ea200000e0000ULL, 0x000000100a107220ULL, 0x042fe20000410000ULL,
0x0000000b0a0b7220ULL, 0x040fe20000410000ULL, 0x000000130a137220ULL, 0x040fe20000410000ULL,
0x0000000c0a0c7220ULL, 0x040fe20000410000ULL, 0x0000000d05067220ULL, 0x044fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001e05037220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002005077220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000002805097220ULL, 0x040fe20000410000ULL,
0x0000001705177220ULL, 0x040fe20000410000ULL, 0x0000000e050e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000000f05047220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000002a050d7220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000001505087220ULL, 0x000fe20000410000ULL, 0x000000220a057220ULL, 0x000fe20000410000ULL,
0x000000082c287824ULL, 0x000fe200078e00ffULL, 0x000000120a127220ULL, 0x040fe20000410000ULL,
0x000000250a257220ULL, 0x040fe20000410000ULL, 0x0000001c0a1c7220ULL, 0x040fe20000410000ULL,
0x000000210a217220ULL, 0x040fe20000410000ULL, 0x000000290a1e7220ULL, 0x040fe20000410000ULL,
0x0000001d0a1d7220ULL, 0x040fe20000410000ULL, 0x000000230a207220ULL, 0x040fe20000410000ULL,
0x000000190a197220ULL, 0x040fe20000410000ULL, 0x000000110a227220ULL, 0x040fe20000410000ULL,
0x000000160a167220ULL, 0x040fe20000410000ULL, 0x000000240a0f7220ULL, 0x000fe20000410000ULL,
0x000000100b0b723eULL, 0x000fe200000010ffULL, 0x000000082f107824ULL, 0x040fe200078e00ffULL,
0x0000002cff157212ULL, 0x000fe200078e33ffULL, 0x000000082c117824ULL, 0x040fe200078e00ffULL,
0x000000072c0a7812ULL, 0x000fe200078ec0ffULL, 0x000000082f2a7824ULL, 0x000fe200078e00ffULL,
0x000000180303723eULL, 0x000fc400000010ffULL, 0x000000072f187812ULL, 0x000fe400078ec0ffULL,
0x000000130c0c723eULL, 0x000fe400000010ffULL, 0xfffffff828337812ULL, 0x000fe400078ee215ULL,
0x000000170e0e723eULL, 0x000fe400000010ffULL, 0x0000001f0404723eULL, 0x000fe400000010ffULL,
0x0000001b0606723eULL, 0x000fc400000010ffULL, 0x000000211e1e723eULL, 0x000fe400000010ffULL,
0x000000010a137812ULL, 0x000fe400078e3cffULL, 0x0000001a0909723eULL, 0x000fe200000010ffULL,
0x000000042b1a7824ULL, 0x000fe200078e00ffULL, 0x000000140d0d723eULL, 0x000fe200000010ffULL,
0x000000082c137824ULL, 0x000fe200078e0213ULL, 0x000000120505723eULL, 0x000fe400000010ffULL,
0x000000160f0f723eULL, 0x000fe200000010ffULL, 0x0000001013137824ULL, 0x000fe200078e0202ULL,
0x000000020a157812ULL, 0x000fc400078e3cffULL, 0x000000030a177812ULL, 0x040fe400078e3cffULL,
0x000000040a1b7812ULL, 0x000fe200078e3cffULL, 0x000000082c157824ULL, 0x000fe200078e0215ULL,
0x000000050a1f7812ULL, 0x000fe200078e3cffULL, 0x000000082c177824ULL, 0x000fe200078e0217ULL,
0x000000060a217812ULL, 0x000fe200078e3cffULL, 0x000000082c1b7824ULL, 0x000fe200078e021bULL,
0xfffffff810237812ULL, 0x000fe200078ee22fULL, 0x000000082c1f7824ULL, 0x000fe200078e021fULL,
0x00000001180a7812ULL, 0x000fe200078e3cffULL, 0x000000082c217824ULL, 0x000fe200078e0221ULL,
0x0000000218107812ULL, 0x040fe200078e3cffULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x0000000318127812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x0000000418147812ULL, 0x040fe200078e3cffULL, 0x0000001023237824ULL, 0x000fe200078e0202ULL,
0x0000000518167812ULL, 0x040fe200078e3cffULL, 0x000000082f297824ULL, 0x000fe200078e0212ULL,
0xfffffff811117812ULL, 0x000fe200078ee22cULL, 0x000000082f2b7824ULL, 0x040fe200078e0214ULL,
0x0000000618187812ULL, 0x000fe200078e3cffULL, 0x000000082f2d7824ULL, 0x040fe200078e0216ULL,
0x000000270808723eULL, 0x000fe200000010ffULL, 0x000000082f277824ULL, 0x040fe200078e0210ULL,
0x000000251c1c723eULL, 0x000fe200000010ffULL, 0x000000082f257824ULL, 0x040fe200078e020aULL,
0x0000001d201d723eULL, 0x000fe200000010ffULL, 0x000000082f2f7824ULL, 0x000fe200078e0218ULL,
0xfffffff82a317812ULL, 0x000fe200078ee231ULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x0000000c1a207812ULL, 0x000fe200078ec0ffULL, 0x0000001033107824ULL, 0x100fe200078e0202ULL,
0x000000260707723eULL, 0x000fe200000010ffULL, 0x0000001031317824ULL, 0x000fe200078e0202ULL,
0x000000192219723eULL, 0x000fe200000010ffULL, 0x00000001200a7824ULL, 0x000fc400078e0211ULL,
0x000000101b1b7824ULL, 0x100fe400078e0202ULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x000000070a007388ULL, 0x0003e20000000800ULL, 0x0000001021217824ULL, 0x100fe400078e0202ULL,
0x0000001025257824ULL, 0x100fe400078e0202ULL, 0x0000001027277824ULL, 0x100fe400078e0202ULL,
0x0000001029297824ULL, 0x000fc400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe400078e0202ULL,
0x000000102d2d7824ULL, 0x100fe400078e0202ULL, 0x000000102f2f7824ULL, 0x000fe400078e0202ULL,
0x0000000120027824ULL, 0x040fe400078e0213ULL, 0x0000000120157824ULL, 0x040fe400078e0215ULL,
0x0000000120177824ULL, 0x040fe200078e0217ULL, 0x0000000902007388ULL, 0x0005e20000000800ULL,
0x0000000120117824ULL, 0x000fc400078e0210ULL, 0x00000001201b7824ULL, 0x040fe200078e021bULL,
0x0000000e15007388ULL, 0x0005e20000000800ULL, 0x0000000120107824ULL, 0x040fe400078e021fULL,
0x0000000120127824ULL, 0x040fe200078e0221ULL, 0x0000000417007388ULL, 0x0005e20000000800ULL,
0x0000000120147824ULL, 0x040fe400078e0223ULL, 0x0000000120257824ULL, 0x040fe200078e0225ULL,
0x000000061b007388ULL, 0x0005e20000000800ULL, 0x0000000120277824ULL, 0x000fc400078e0227ULL,
0x00000001200a7824ULL, 0x042fe200078e0229ULL, 0x0000000310007388ULL, 0x0005e20000000800ULL,
0x0000000120167824ULL, 0x040fe400078e022bULL, 0x0000000120187824ULL, 0x040fe200078e022dULL,
0x0000000d12007388ULL, 0x0005e20000000800ULL, 0x00000001202f7824ULL, 0x040fe400078e022fULL,
0x00000001201a7824ULL, 0x000fe200078e0231ULL, 0x0000000811007388ULL, 0x0005e80000000800ULL,
0x0000000514007388ULL, 0x0005e80000000800ULL, 0x0000001c25007388ULL, 0x0005e80000000800ULL,
0x0000001e27007388ULL, 0x0005e80000000800ULL, 0x0000001d0a007388ULL, 0x0005e80000000800ULL,
0x0000001916007388ULL, 0x0005e80000000800ULL, 0x0000000f18007388ULL, 0x0005e80000000800ULL,
0x0000000c2f007388ULL, 0x0005e80000000800ULL, 0x0000000b1a007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000177919ULL, 0x00cea20000002600ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000580000057ab9ULL, 0x000fc40000000800ULL,
0x0000000000197919ULL, 0x000f220000000000ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000001017037824ULL, 0x004fc600078e00ffULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x0000001017147824ULL, 0x000fe200078e00ffULL, 0x00000003ff027819ULL, 0x010fe40000011619ULL,
0x00000020191a7810ULL, 0x040fe40007ffe0ffULL, 0x00000040191c7810ULL, 0x040fe40007ffe0ffULL,
0x00000060191d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff003047812ULL, 0x000fc400078ee202ULL,
0x00000003ff037819ULL, 0x000fe4000001161aULL, 0x00000003ff157819ULL, 0x000fe4000001161cULL,
0x00000003ff167819ULL, 0x000fe4000001161dULL, 0x0000000702027812ULL, 0x000fe400078e4819ULL,
0x0000000703057812ULL, 0x000fe400078e481aULL, 0x0000000715067812ULL, 0x000fc400078e481cULL,
0xfffffff014147812ULL, 0x000fe400078ee203ULL, 0x0000000716087812ULL, 0x000fe400078e481dULL,
0x0ffffff802037812ULL, 0x000fe400078ef819ULL, 0x0ffffff805057812ULL, 0x000fe400078ef81aULL,
0x0ffffff806077812ULL, 0x000fe200078ef81cULL, 0x0000001003067824ULL, 0x100fe200078e0200ULL,
0x0ffffff808097812ULL, 0x000fe200078ef81dULL, 0x0000001005087824ULL, 0x100fe200078e0200ULL,
0x0000000404037c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010070c7824ULL, 0x100fe200078e0200ULL,
0x00000007191b7812ULL, 0x000fe200078ec0ffULL, 0x0000001009107824ULL, 0x000fe200078e0200ULL,
0x00a0000006047984ULL, 0x000ea20000000c00ULL, 0x0000001017007824ULL, 0x000fe200078e00ffULL,
0x000000071d197812ULL, 0x000fe200078ec0ffULL, 0x0000001017177824ULL, 0x000fe200078e00ffULL,
0x00a0000008087984ULL, 0x000ee20000000c00ULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0xfffffff000007812ULL, 0x000fc400078ee215ULL, 0x00a000000c0c7984ULL, 0x000f220000000c00ULL,
0x00005a0003027a11ULL, 0x000fe400078048ffULL, 0xfffffff017167812ULL, 0x000fe200078ee216ULL,
0x00a0000010107984ULL, 0x000f620000000c00ULL, 0x000000071a157812ULL, 0x000fe400078ec0ffULL,
0x000000071c177812ULL, 0x000fe400078ec0ffULL, 0x00005b0003037a11ULL, 0x000fe400000f4c18ULL,
0x1ffffff8151d7812ULL, 0x000fc400078ef844ULL, 0x0000000414157c10ULL, 0x000fe4000ff1e0ffULL,
0x1ffffff8171f7812ULL, 0x000fe400078ef844ULL, 0x0000000400177c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x0000000416007c10ULL, 0x000fe4000ff5e0ffULL,
0x00005a0015147a11ULL, 0x000fe200078048ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x00005a0017167a11ULL, 0x000fe200078248ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x00005a0000187a11ULL, 0x000fc400078448ffULL, 0x1ffffff81b1b7812ULL, 0x000fe400078ef844ULL,
0x00005b0015157a11ULL, 0x000fe400000f4c1cULL, 0x1ffffff819217812ULL, 0x000fe200078ef844ULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00005b0017177a11ULL, 0x000fe400008f4c1aULL,
0x00005b0000197a11ULL, 0x000fe200010f4c23ULL, 0x000000101d147825ULL, 0x000fe200078e0014ULL,
0x0000000402007986ULL, 0x004fe6000c101d06ULL, 0x000000101f167825ULL, 0x000fe200078e0016ULL,
0x0000000814007986ULL, 0x008fe6000c101d06ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x0000000c16007986ULL, 0x010fe8000c101d06ULL, 0x0000001018007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff027624ULL, 0x000fe400078e00ffULL,
0x00006700ff037624ULL, 0x000fca00078e00ffULL, 0x00000006022f7981ULL, 0x000362000c1e9900ULL,
0x0000000151057810ULL, 0x000fe20007ffe0ffULL, 0x0000000245007824ULL, 0x000fe400078e00ffULL,
0x00000040502c7824ULL, 0x000fe200078e00ffULL, 0x000000460500720cULL, 0x000fe20003f06070ULL,
0x00005800002d7a24ULL, 0x000fe400078e022dULL, 0x00000100510a7824ULL, 0x000fc800078e022cULL,
0x000062002d167a24ULL, 0x000fcc00078e020aULL, 0x000005c000008947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x002e620000000000ULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000000a47007217ULL, 0x000fe40007800000ULL, 0x0000200050127811ULL, 0x000fc600078e68ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0aULL, 0x00000002ff1b7819ULL, 0x102fe2000001160dULL,
0x000000100d1d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fe4000001160dULL,
0x000000081b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000011b027824ULL, 0x140fe200078e0216ULL,
0x000000181b237810ULL, 0x040fe40007ffe0ffULL, 0x000000101b217810ULL, 0x000fe20007ffe0ffULL,
0x000000010f047824ULL, 0x000fe200078e0216ULL, 0x000000301d1d7812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x000000201b157810ULL, 0x000fc40007ffe0ffULL,
0x0000000310107812ULL, 0x100fe200078e480dULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0x0000001d020a7210ULL, 0x080fe40007f1e0ffULL, 0x000000281b177810ULL, 0x000fe20007ffe0ffULL,
0x0000000123087824ULL, 0x100fe200078e0216ULL, 0x0000001d04047210ULL, 0x000fe20007f3e0ffULL,
0x0000000121067824ULL, 0x000fe200078e0216ULL, 0x0ffffffc100d7812ULL, 0x000fe200078ef80dULL,
0x00005e0008087625ULL, 0x000fe200078e001fULL, 0x000000301b197810ULL, 0x000fc40007ffe0ffULL,
0x000000002100720cULL, 0x080fe20003fa6070ULL, 0x0000000116027824ULL, 0x000fe200078e0215ULL,
0x000000001500720cULL, 0x080fe20003f66070ULL, 0x00005e0006067625ULL, 0x000fe200078e001fULL,
0x000000002300720cULL, 0x000fc60003f86070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0603ULL,
0x0000001d06067210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x0000001d08087210ULL, 0x000fe20007f3e0ffULL, 0x00005e0002027625ULL, 0x000fc800078e001fULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000001d020c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000116027824ULL, 0x000fe200078e0217ULL, 0x000000000f00720cULL, 0x080fe20003f26070ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x000000001b00720cULL, 0x080fe20003f06070ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x000000381b1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000100d117824ULL, 0x000fe400078e0212ULL, 0x000000ffff0d7224ULL, 0x000fe200010e0603ULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee210ULL, 0x00005e0002027625ULL, 0x000fe200078e001fULL,
0x000000001700720cULL, 0x000fc60003f46070ULL, 0x000000100f137824ULL, 0x000fe200078e0212ULL,
0x0000001d020e7210ULL, 0x000fe20007fde0ffULL, 0x0000000116027824ULL, 0x000fe200078e0219ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0003e2000c101c46ULL,
0x000000001b00720cULL, 0x080fe40003f06070ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0603ULL,
0x0000000004137faeULL, 0x0005e2000c901c46ULL, 0x00005e0002027625ULL, 0x000fe200078e001fULL,
0x000000001900720cULL, 0x000fc80003f26070ULL, 0x0000001d02027210ULL, 0x000fe20007fde0ffULL,
0x00000004210b7824ULL, 0x002fe400078e00ffULL, 0x0000000423117824ULL, 0x000fe400078e00ffULL,
0x0000000116047824ULL, 0x004fe200078e021bULL, 0xfffffffc0b0b7812ULL, 0x100fe200078ee210ULL,
0x0000000415137824ULL, 0x000fe200078e00ffULL, 0xfffffffc11117812ULL, 0x100fe200078ee210ULL,
0x0000000417157824ULL, 0x000fe400078e00ffULL, 0x0000000419177824ULL, 0x000fe200078e00ffULL,
0xfffffffc13137812ULL, 0x100fe200078ee210ULL, 0x000000041b197824ULL, 0x000fe200078e00ffULL,
0xfffffffc15157812ULL, 0x100fe200078ee210ULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0xfffffffc17177812ULL, 0x000fc400078ee210ULL, 0xfffffffc19197812ULL, 0x000fe200078ee210ULL,
0x000000ffff037224ULL, 0x000fe200030e0603ULL, 0x0000001d04047210ULL, 0x000fe20007fde0ffULL,
0x000000100b0b7824ULL, 0x100fe400078e0212ULL, 0x0000001011117824ULL, 0x100fe400078e0212ULL,
0x0000001013137824ULL, 0x100fe200078e0212ULL, 0x00000000060b7faeULL, 0x0003e2000e901c46ULL,
0x0000001015157824ULL, 0x100fe400078e0212ULL, 0x0000001017177824ULL, 0x100fe200078e0212ULL,
0x0000000008117faeULL, 0x0003e2000e101c46ULL, 0x0000001019197824ULL, 0x000fc400078e0212ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x000000000c137faeULL, 0x0003e8000d901c46ULL,
0x000000000e157faeULL, 0x0003e8000d101c46ULL, 0x0000000002177faeULL, 0x0003e8000c901c46ULL,
0x0000000004197faeULL, 0x0003e2000c101c46ULL, 0x0000050000007947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x002e620000000000ULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x00002000501f7811ULL, 0x000fe200078e68ffULL, 0x000000100d047824ULL, 0x042fe200078e00ffULL,
0x000000100d037811ULL, 0x000fc400078ff0ffULL, 0x000000160d027211ULL, 0x000fe400078ff0ffULL,
0x00000003ff007819ULL, 0x000fe2000001160dULL, 0x0000000403117824ULL, 0x000fe200078e00ffULL,
0x000000080d0b7811ULL, 0x040fe400078ff0ffULL, 0x0000003004237812ULL, 0x000fe200078ec0ffULL,
0x0000000116047824ULL, 0x000fe200078e0203ULL, 0x000000200d077811ULL, 0x040fe200078ff0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x000000180d057811ULL, 0x000fc400078ff0ffULL,
0x0000000300187812ULL, 0x000fe200078e480dULL, 0x000000010b007824ULL, 0x000fe200078e0216ULL,
0x000000280d087811ULL, 0x000fe200078ff0ffULL, 0x000000040b0f7824ULL, 0x000fe200078e00ffULL,
0x000000300d097811ULL, 0x000fe200078ff0ffULL, 0x00000001160b7824ULL, 0x000fe200078e0207ULL,
0x00000023020c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000407077824ULL, 0x000fe200078e00ffULL,
0x000000380d0a7811ULL, 0x000fe200078ff0ffULL, 0x0000000116067824ULL, 0x000fe200078e0205ULL,
0x0ffffffc18107812ULL, 0x000fe200078ef80dULL, 0x0000000405057824ULL, 0x000fe200078e00ffULL,
0xfffffffc070e7812ULL, 0x000fe200078ee218ULL, 0x0000000116127824ULL, 0x000fc400078e0208ULL,
0x0000000408137824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f087812ULL, 0x100fe200078ee218ULL,
0x0000000116147824ULL, 0x040fe400078e0209ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0603ULL,
0xfffffffc130f7812ULL, 0x000fe200078ee218ULL, 0x0000000116167824ULL, 0x000fe400078e020aULL,
0x000000040a177824ULL, 0x000fe200078e00ffULL, 0xfffffffc050a7812ULL, 0x000fe200078ee218ULL,
0x00005e0000027625ULL, 0x000fc800078e0021ULL, 0x0000000409157824ULL, 0x000fe200078e00ffULL,
0xfffffffc11097812ULL, 0x000fe200078ee218ULL, 0x00005e0004047625ULL, 0x000fc600078e0021ULL,
0xfffffffc15117812ULL, 0x100fe200078ee218ULL, 0x000000100e197824ULL, 0x000fe200078e021fULL,
0x00000023020e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0xfffffffc17187812ULL, 0x000fc600078ee218ULL, 0x0000001010257824ULL, 0x100fe200078e021fULL,
0x0000002304107210ULL, 0x080fe20007f3e0ffULL, 0x000000100f1b7824ULL, 0x000fe400078e021fULL,
0x000000ffff0f7224ULL, 0x000fe200000e0603ULL, 0x0000002306067210ULL, 0x000fe20007f1e0ffULL,
0x00000010111d7824ULL, 0x000fe200078e021fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c257faeULL, 0x0003e2000b901c46ULL, 0x000000ffff117224ULL, 0x000fe400008e0605ULL,
0x00005e000b027625ULL, 0x000fc800078e0021ULL, 0x0000001008137824ULL, 0x100fe400078e021fULL,
0x0000001009157824ULL, 0x100fe400078e021fULL, 0x00005e0012047625ULL, 0x000fe200078e0021ULL,
0x000000000e137faeULL, 0x0003e6000b901c46ULL, 0x000000100a177824ULL, 0x000fe200078e021fULL,
0x0000002304047210ULL, 0x000fe20007f3e0ffULL, 0x00005e0014087625ULL, 0x080fe200078e0021ULL,
0x0000000010157faeULL, 0x0003e6000b901c46ULL, 0x00005e00160a7625ULL, 0x000fe200078e0021ULL,
0x0000002308087210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000002302027210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x000000230a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000000006177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x00000010181f7824ULL, 0x000fe400078e021fULL, 0x000000ffff0b7224ULL, 0x000fe200018e060bULL,
0x0000000002197faeULL, 0x0003e8000b901c46ULL, 0x00000000041b7faeULL, 0x0003e8000b901c46ULL,
0x00000000081d7faeULL, 0x0003e8000b901c46ULL, 0x000000000a1f7faeULL, 0x0003e4000b901c46ULL,
0x01060400ff007984ULL, 0x000ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x004fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x01060400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000035000780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x002e640000000000ULL,
0x0000002050007824ULL, 0x002fc800078e0203ULL, 0x0000002000047824ULL, 0x000fe200078e00ffULL,
0x00000003ff027819ULL, 0x000fc80000011600ULL, 0x1ffffffe02037812ULL, 0x000fe400078ec0ffULL,
0x000001e004047812ULL, 0x000fe400078ec0ffULL, 0x0000000103077812ULL, 0x040fe400078efcffULL,
0x0000000703057812ULL, 0x100fe400078e7800ULL, 0x0000000707077812ULL, 0x100fe400078e7800ULL,
0x0000001003117810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x040fe200078e0205ULL,
0x0000001103037810ULL, 0x000fe20007ffe0ffULL, 0x0000000104077824ULL, 0x000fe200078e0207ULL,
0x0000000711117812ULL, 0x000fc400078e7800ULL, 0x00000000050c7984ULL, 0x000e62000000cc00ULL,
0x0000000703037812ULL, 0x000fe400078e7800ULL, 0x0000000104117824ULL, 0x040fe200078e0211ULL,
0x0000000007087984ULL, 0x000ea4000000cc00ULL, 0x0000000104037824ULL, 0x000fe400078e0203ULL,
0x000000ffff147224ULL, 0x002fe400078e000cULL, 0x000000ffff157224ULL, 0x000fc400078e000eULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fe200078e000fULL,
0x0000001405007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fca00078e000bULL, 0x0000001807007388ULL, 0x000fe8000000cc00ULL,
0x0000000003087984ULL, 0x000e68000000cc00ULL, 0x00000000110c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x004fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001c11007388ULL, 0x0003e8000000cc00ULL,
0x0000000803007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01060400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x01060400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000465100720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000002e7919ULL, 0x000ea20000000000ULL,
0x3d8000002f2f7820ULL, 0x020fe20000410000ULL, 0x0000001050307824ULL, 0x000fe200078e00ffULL,
0xffffffff46327810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x00007610ff337816ULL, 0x000fe40000000033ULL, 0x0000010051347824ULL, 0x008fe200078e022cULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000344700720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e0031ULL,
0x0000000000247805ULL, 0x002fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fc4000001ff00ULL, 0x0000000100037810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x0000000135317812ULL, 0x000fc400078e0cffULL,
0x00000002ff027819ULL, 0x000fe40000011603ULL, 0x000000040300780cULL, 0x040fe40003f06070ULL,
0x0000000303207812ULL, 0x000fe200078ec0ffULL, 0x0000030002217a24ULL, 0x000fe400078e0251ULL,
0x000000ffff027224ULL, 0x000fe400078e0000ULL, 0x0000010021227824ULL, 0x040fe200078e022cULL,
0x0000000121237810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff007224ULL, 0x000fc400078e0003ULL,
0x000062002d377a24ULL, 0x000fe200078e0222ULL, 0x000000462300720cULL, 0x000fda0003f26070ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000002247037217ULL, 0x000fe20007800000ULL,
0x00000004203b7824ULL, 0x000fe200078e00ffULL, 0x00000002ff287819ULL, 0x104fe2000001162eULL,
0x00000002503a7824ULL, 0x000fe200078e0231ULL, 0x00000003ff217819ULL, 0x000fe2000001162eULL,
0x0000000103037824ULL, 0x000fe200078e0a22ULL, 0x00000008282a7810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff397424ULL, 0x000fe200078e00ffULL, 0x00000003213d7812ULL, 0x100fe200078e482eULL,
0x0000000128207824ULL, 0x100fe200078e0237ULL, 0x000000032a00720cULL, 0x0c0fe20003f46070ULL,
0x000000012a227824ULL, 0x000fe200078e0237ULL, 0x000000032800720cULL, 0x000fe20003f26070ULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3b3b7812ULL, 0x000fe200078ee22eULL,
0x00005e0020207625ULL, 0x000fe200078e0039ULL, 0x000020003a3a7811ULL, 0x000fc400078e60ffULL,
0x0ffffffc3d297812ULL, 0x000fe200078ef82eULL, 0x00005e0022227625ULL, 0x000fe200078e0039ULL,
0xfffffffc2a2b7812ULL, 0x000fe400078ee23dULL, 0x00000010282a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e023aULL, 0x0000001828367810ULL, 0x040fe20007ffe0ffULL,
0x000000103b207825ULL, 0x000fe200078e0020ULL, 0x0000002028387810ULL, 0x040fe40007ffe0ffULL,
0x00000028283c7810ULL, 0x040fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e023aULL,
0x00000030283e7810ULL, 0x040fe20007ffe0ffULL, 0x000000103b227825ULL, 0x000fe200078e0022ULL,
0x0000003828407810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020297faeULL, 0x0003e2000c901c46ULL, 0x000000032a00720cULL, 0x0c0fe20003f26070ULL,
0x000000042a427824ULL, 0x000fe200078e00ffULL, 0x000000033800720cULL, 0x080fe20003f66070ULL,
0x00000000222b7faeULL, 0x0005e2000d101c46ULL, 0x000000033600720cULL, 0x0c0fe20003f46070ULL,
0x0000000436447824ULL, 0x000fe200078e00ffULL, 0x000000033c00720cULL, 0x080fe20003f86070ULL,
0x0000000138287824ULL, 0x100fe200078e0237ULL, 0x000000033e00720cULL, 0x080fe20003fa6070ULL,
0x0000000438487824ULL, 0x000fe200078e00ffULL, 0x000000034000720cULL, 0x000fe20003fc6070ULL,
0x000000012a207824ULL, 0x002fe200078e0237ULL, 0xfffffffc42037812ULL, 0x000fe200078ee23dULL,
0x000000013c2a7824ULL, 0x000fe200078e0237ULL, 0xfffffffc443f7812ULL, 0x000fe200078ee23dULL,
0x0000000136227824ULL, 0x004fe200078e0237ULL, 0xfffffffc48417812ULL, 0x000fe200078ee23dULL,
0x000000013e367824ULL, 0x000fc400078e0237ULL, 0x0000000140387824ULL, 0x000fe400078e0237ULL,
0x000000043c3c7824ULL, 0x000fe400078e00ffULL, 0x00005e0020207625ULL, 0x000fc600078e0039ULL,
0xfffffffc3c437812ULL, 0x000fe200078ee23dULL, 0x00005e0022227625ULL, 0x000fc800078e0039ULL,
0x00005e0028287625ULL, 0x000fc800078e0039ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0039ULL,
0x00005e0036367625ULL, 0x000fc800078e0039ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x00005e0038387625ULL, 0x000fc600078e0039ULL, 0xfffffffc3e457812ULL, 0x000fe200078ee23dULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x000000103b207825ULL, 0x000fc600078e0020ULL,
0xfffffffc40497812ULL, 0x000fe200078ee23dULL, 0x000000103b227825ULL, 0x000fc800078e0022ULL,
0x000000103b287825ULL, 0x000fc800078e0028ULL, 0x000000103b2a7825ULL, 0x000fc800078e002aULL,
0x000000103b367825ULL, 0x000fc800078e0036ULL, 0x000000103b387825ULL, 0x000fc800078e0038ULL,
0x0000001003037824ULL, 0x100fe400078e023aULL, 0x000000103f3b7824ULL, 0x100fe400078e023aULL,
0x00000010413d7824ULL, 0x100fe200078e023aULL, 0x0000000020037faeULL, 0x0003e2000c901c46ULL,
0x00000010433f7824ULL, 0x100fe400078e023aULL, 0x0000001045417824ULL, 0x100fe200078e023aULL,
0x00000000223b7faeULL, 0x0003e2000d101c46ULL, 0x0000001049437824ULL, 0x000fc600078e023aULL,
0x00000000283d7faeULL, 0x0003e8000d901c46ULL, 0x000000002a3f7faeULL, 0x0003e8000e101c46ULL,
0x0000000036417faeULL, 0x0003e8000e901c46ULL, 0x0000000038437faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x0000000250227824ULL, 0x000fe200078e0231ULL,
0x000000082e287811ULL, 0x004fe200078ff0ffULL, 0x0000000420037824ULL, 0x000fe200078e00ffULL,
0x000000102e2a7811ULL, 0x040fe200078ff0ffULL, 0x00000100ff3d7424ULL, 0x000fe200078e00ffULL,
0x000000182e367811ULL, 0x000fe200078ff0ffULL, 0x0000000428407824ULL, 0x000fe200078e00ffULL,
0x000000202e387811ULL, 0x000fe200078ff0ffULL, 0x000000042a427824ULL, 0x000fe200078e00ffULL,
0x000000282e3a7811ULL, 0x000fe200078ff0ffULL, 0x0000000436447824ULL, 0x000fe200078e00ffULL,
0x000000302e3c7811ULL, 0x000fe200078ff0ffULL, 0x0000000438487824ULL, 0x000fe200078e00ffULL,
0x000000382e3e7811ULL, 0x000fe200078ff0ffULL, 0x000000043a4a7824ULL, 0x000fe200078e00ffULL,
0x00002000224b7811ULL, 0x000fe200078e60ffULL, 0x0000000128227824ULL, 0x100fe200078e0237ULL,
0x00000003ff217819ULL, 0x100fe2000001162eULL, 0x000000012a287824ULL, 0x100fe200078e0237ULL,
0x000000372e207211ULL, 0x000fe200078ff0ffULL, 0x00000001362a7824ULL, 0x100fe200078e0237ULL,
0x0000000321237812ULL, 0x100fe200078e482eULL, 0x0000000138367824ULL, 0x000fe200078e0237ULL,
0xfffffffc03037812ULL, 0x000fe200078ee22eULL, 0x000000043c4c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc40407812ULL, 0x100fe200078ee223ULL, 0x000000043e4e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc42427812ULL, 0x000fe200078ee223ULL, 0x000000013a387824ULL, 0x000fe200078e0237ULL,
0xfffffffc44447812ULL, 0x000fe200078ee223ULL, 0x000000013c3a7824ULL, 0x000fe200078e0237ULL,
0xfffffffc48487812ULL, 0x000fe200078ee223ULL, 0x000000013e3c7824ULL, 0x000fe200078e0237ULL,
0xfffffffc4a4a7812ULL, 0x100fe200078ee223ULL, 0x00005e0020207625ULL, 0x000fe200078e003dULL,
0xfffffffc4c4c7812ULL, 0x000fc400078ee223ULL, 0xfffffffc4e4e7812ULL, 0x000fe200078ee223ULL,
0x00005e0028287625ULL, 0x000fe200078e003dULL, 0x0ffffffc233e7812ULL, 0x000fc600078ef82eULL,
0x00005e0022227625ULL, 0x000fc800078e003dULL, 0x00005e002a2a7625ULL, 0x000fc800078e003dULL,
0x00005e0036367625ULL, 0x000fc800078e003dULL, 0x00005e0038387625ULL, 0x000fc800078e003dULL,
0x00005e003a3a7625ULL, 0x000fc800078e003dULL, 0x00005e003c3c7625ULL, 0x000fc800078e003dULL,
0x0000001003207825ULL, 0x000fc800078e0020ULL, 0x0000001003227825ULL, 0x000fc800078e0022ULL,
0x0000001003287825ULL, 0x000fc800078e0028ULL, 0x00000010032a7825ULL, 0x000fc800078e002aULL,
0x0000001003367825ULL, 0x000fc800078e0036ULL, 0x0000001003387825ULL, 0x000fc800078e0038ULL,
0x00000010033a7825ULL, 0x000fc800078e003aULL, 0x00000010033c7825ULL, 0x000fc800078e003cULL,
0x000000103e4d7824ULL, 0x100fe400078e024bULL, 0x0000001040037824ULL, 0x100fe400078e024bULL,
0x00000010423f7824ULL, 0x100fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000204d7faeULL, 0x0003e2000b901c46ULL, 0x0000001044417824ULL, 0x100fe400078e024bULL,
0x0000001048437824ULL, 0x100fe200078e024bULL, 0x0000000022037faeULL, 0x0003e2000b901c46ULL,
0x000000104a457824ULL, 0x000fc400078e024bULL, 0x000000104c497824ULL, 0x100fe200078e024bULL,
0x00000000283f7faeULL, 0x0003e2000b901c46ULL, 0x000000104e4b7824ULL, 0x000fc600078e024bULL,
0x000000002a417faeULL, 0x0003e8000b901c46ULL, 0x0000000036437faeULL, 0x0003e8000b901c46ULL,
0x0000000038457faeULL, 0x0003e8000b901c46ULL, 0x000000003a497faeULL, 0x0003e8000b901c46ULL,
0x000000003c4b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000802377824ULL, 0x002fc400078e00ffULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff82e037812ULL, 0x000fe200078ec0ffULL, 0x0000000250237824ULL, 0x000fe200078e0235ULL,
0x000000202e297810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000703037812ULL, 0x100fe400078ef82eULL, 0xfffffff829297812ULL, 0x000fe400078ec0ffULL,
0x00000001ff027819ULL, 0x000fe40000011603ULL, 0x0000000729297812ULL, 0x000fc400078ef82eULL,
0x0000000302217812ULL, 0x000fe400078ec0ffULL, 0x00000001ff207819ULL, 0x000fe40000011629ULL,
0x0000003621027212ULL, 0x000fe400078e3cffULL, 0x0000200023237811ULL, 0x000fe400078e60ffULL,
0x00000003202b7812ULL, 0x000fe200078ec0ffULL, 0x0000000403027824ULL, 0x000fe200078e0202ULL,
0x0000000136207810ULL, 0x000fc60007ffe0ffULL, 0x0000001002407824ULL, 0x000fe200078e0223ULL,
0x000000362b027212ULL, 0x000fe400078e3cffULL, 0x0000000236367810ULL, 0x000fc60007ffe0ffULL,
0x0000000429027824ULL, 0x000fe200078e0202ULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x000000043600780cULL, 0x000fe40003f25270ULL, 0x00000010023c7824ULL, 0x100fe200078e0223ULL,
0x0000002021027212ULL, 0x080fe400078e3cffULL, 0x000000202b207212ULL, 0x000fe400078e3cffULL,
0x000000072e217812ULL, 0x000fe200078ec0ffULL, 0x0000000403227824ULL, 0x000fe200078e0202ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0000000429207824ULL, 0x000fe200078e0220ULL,
0x00000008212a7812ULL, 0x000fe200078ef82eULL, 0x0000001022227824ULL, 0x100fe200078e0223ULL,
0x000000372e027211ULL, 0x000fe200078fe0ffULL, 0x0000001020207824ULL, 0x000fe200078e0223ULL,
0x0000000437377810ULL, 0x000fc40007ffe0ffULL, 0x000000002238783bULL, 0x000fe20000000200ULL,
0x0000000202037810ULL, 0x040fe40007ffe0ffULL, 0x0000000702457812ULL, 0x100fe200078e782aULL,
0x000000002020783bULL, 0x000ea20000000200ULL, 0x0000000703037812ULL, 0x000fc600078e782aULL,
0x000000202a457824ULL, 0x040fe400078e0245ULL, 0x000000202a2a7824ULL, 0x000fc800078e0203ULL,
0x000000102a2a7824ULL, 0x000fe200078e00ffULL, 0x0000ffff407c7812ULL, 0x002fe400078ec0ffULL,
0x000000ff42667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe40000011640ULL,
0x00000018ff4b7819ULL, 0x000fe40000011640ULL, 0x000000ff404c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff747819ULL, 0x000fc40000011641ULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x000000ff41657812ULL, 0x040fe400078ec0ffULL, 0x0000ffff417d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff717819ULL, 0x100fe40000011642ULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x00000010ff567819ULL, 0x004fc40000011620ULL, 0x00000018ff587819ULL, 0x000fe40000011620ULL,
0x000000ff20597812ULL, 0x040fe400078ec0ffULL, 0x0000ffff204f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff207819ULL, 0x000fe4000001167cULL, 0x0000ffff426e7812ULL, 0x000fe400078ec0ffULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x00000010ff6c7819ULL, 0x100fe40000011643ULL,
0x00000018ff427819ULL, 0x000fe20000011643ULL, 0x20000066ff677230ULL, 0x000fe20000004100ULL,
0x000000ff43767812ULL, 0x040fe400078ec0ffULL, 0x0000ffff436b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001163fULL, 0x00000018ff617819ULL, 0x000fc4000001163fULL,
0x000000ff3f437812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3f2b7812ULL, 0x000fe400078ec0ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x00000010ff287819ULL, 0x100fe4000001163eULL,
0x00000018ff607819ULL, 0x000fe4000001163eULL, 0x000000ff3e557812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3e297812ULL, 0x000fe400078ec0ffULL, 0x00000010ff577819ULL, 0x100fe40000011639ULL,
0x00000018ff3f7819ULL, 0x000fe40000011639ULL, 0x000000ff39777812ULL, 0x040fe400078ec0ffULL,
0x0000ffff39757812ULL, 0x000fe400078ec0ffULL, 0x000000ff383e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff527819ULL, 0x100fe40000011621ULL, 0x00000018ff5a7819ULL, 0x000fe40000011621ULL,
0x000000ff215b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff21397812ULL, 0x000fe400078ec0ffULL,
0x00000008ff217819ULL, 0x000fe4000001167dULL, 0x00000076ff66723eULL, 0x000fe200020006ffULL,
0x20000020ff767230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fc400078ec0ffULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x000000ff74747812ULL, 0x000fe400078ec0ffULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000004cff727230ULL, 0x000fe20000004100ULL, 0x00000008ff207819ULL, 0x000fe4000001166eULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x2000003eff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fc400078ec0ffULL, 0x00000010ff027819ULL, 0x100fe4000001163dULL,
0x00000018ff547819ULL, 0x000fe4000001163dULL, 0x000000ff3d537812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3d037812ULL, 0x000fe400078ec0ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000010ff4d7819ULL, 0x000fc40000011638ULL, 0x00000018ff3d7819ULL, 0x000fe40000011638ULL,
0x0000ffff384e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff447819ULL, 0x100fe4000001163aULL,
0x00000018ff787819ULL, 0x000fe4000001163aULL, 0x000000ff3a797812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3a487812ULL, 0x000fc400078ec0ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x000000ff6c6c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff387819ULL, 0x100fe40000011622ULL,
0x00000018ff5c7819ULL, 0x000fe40000011622ULL, 0x000000ff225f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff223a7812ULL, 0x000fc400078ec0ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000071ff22723eULL, 0x000fe200020006ffULL, 0x20000021ff717230ULL, 0x000fe20000004100ULL,
0x00000077ff3e723eULL, 0x000fe200020006ffULL, 0x20000073ff777230ULL, 0x000fe20000004100ULL,
0x00000008ff6b7819ULL, 0x000fe2000001166bULL, 0x20000074ff737230ULL, 0x000fe20000004100ULL,
0x0000006cff21723eULL, 0x000fe200020006ffULL, 0x20000020ff747230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000022ff6e7230ULL, 0x000fe20000004100ULL,
0x00000060ff20723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x0000006bff6c723eULL, 0x000fe200020006ffULL, 0x20000021ff6b7230ULL, 0x000fe20000004100ULL,
0x000000ff57577812ULL, 0x000fc400078ec0ffULL, 0x00000061ff21723eULL, 0x000fe200020006ffULL,
0x20000054ff617230ULL, 0x000fe20000004100ULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x20000020ff547230ULL, 0x000fe20000004100ULL, 0x00000057ff20723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000043ff577230ULL, 0x000fe20000004100ULL, 0x00000018ff637819ULL, 0x000fe2000001163cULL,
0x20000020ff437230ULL, 0x000fe20000004100ULL, 0x000000ff44207812ULL, 0x000fe200078ec0ffULL,
0x20000053ff607230ULL, 0x000fe20000004100ULL, 0x000000ff3c627812ULL, 0x000fe200078ec0ffULL,
0x20000021ff537230ULL, 0x000fe20000004100ULL, 0x00000020ff21723eULL, 0x000fe200020006ffULL,
0x0000001045207824ULL, 0x000fe200078e00ffULL, 0x00000063ff22723eULL, 0x000fc400020006ffULL,
0x00000010ff5d7819ULL, 0x000fe2000001163cULL, 0x20000021ff457230ULL, 0x000fe20000004100ULL,
0x0000ffff3c5e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff497819ULL, 0x100fe4000001163bULL,
0x00000018ff7a7819ULL, 0x000fe4000001163bULL, 0x000000ff3b7b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3b4a7812ULL, 0x000fc400078ec0ffULL, 0x00000062ff63723eULL, 0x000fe200020006ffULL,
0x20000022ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x100fe40000011623ULL,
0x00000018ff707819ULL, 0x000fe20000011623ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x000000ff236f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff233c7812ULL, 0x000fe400078ec0ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x00000008ff757819ULL, 0x000fc40000011675ULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x0000003fff3f723eULL, 0x000fe200020006ffULL, 0x2000004bff6d7230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000003dff4b7230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x2000003fff3d7230ULL, 0x000fe20000004100ULL,
0x00000078ff3f723eULL, 0x000fe200020006ffULL, 0x20000075ff447230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000040ff697230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fc4000001165eULL, 0x00000070ff78723eULL, 0x000fe400020006ffULL,
0x0000006fff75723eULL, 0x000fe400020006ffULL, 0x0000005dff70723eULL, 0x000fe200020006ffULL,
0x2000005fff5d7230ULL, 0x000fe20000004100ULL, 0x0000005eff6f723eULL, 0x000fe200020006ffULL,
0x20000078ff5f7230ULL, 0x000fe20000004100ULL, 0x00000079ff40723eULL, 0x000fe200020006ffULL,
0x20000075ff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff02797812ULL, 0x000fe200078ec0ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000008ff757819ULL, 0x000fe20000011603ULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fe2000001166dULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff027819ULL, 0x000fc40000011672ULL,
0x00000010ff037819ULL, 0x000fe40000011677ULL, 0x00000010ff6d7819ULL, 0x000fe40000011676ULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000105478037816ULL, 0x000fe40000000003ULL,
0x000010546d027816ULL, 0x000fe20000000002ULL, 0x20000065ff6a7230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fc400020006ffULL, 0x000000ff28287812ULL, 0x000fe400078ec0ffULL,
0x00000008ff297819ULL, 0x000fe20000011629ULL, 0x20000075ff6d7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x000000022024723cULL, 0x002fe20000041824ULL,
0x00000028ff76723eULL, 0x000fe400020006ffULL, 0x00000029ff75723eULL, 0x000fe200020006ffULL,
0x20000041ff687230ULL, 0x000fe20000004100ULL, 0x00000010ff287819ULL, 0x000fe2000001166aULL,
0x20000076ff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff027819ULL, 0x000fe20000011669ULL,
0x20000075ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fc40000011673ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x0000105402297816ULL, 0x000fe40000000029ULL, 0x0000105471287816ULL, 0x000fe20000000028ULL,
0x20000042ff657230ULL, 0x000fe20000004100ULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff027819ULL, 0x000fc40000011667ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x000000282004723cULL, 0x000fe20000041804ULL, 0x00000010ff037819ULL, 0x000fe4000001166eULL,
0x00000010ff677819ULL, 0x000fe40000011674ULL, 0x00000064ff6e723eULL, 0x000fe400020006ffULL,
0x0000105468037816ULL, 0x000fe40000000003ULL, 0x0000105467027816ULL, 0x000fe20000000002ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fc40000011665ULL,
0x00000010ff297819ULL, 0x000fe4000001166bULL, 0x00000010ff287819ULL, 0x000fe20000011666ULL,
0x00000002201c723cULL, 0x000fe2000004181cULL, 0x00000010ff657819ULL, 0x000fe4000001166cULL,
0x00000079ff72723eULL, 0x000fe400020006ffULL, 0x0000105464297816ULL, 0x000fe40000000029ULL,
0x0000105465287816ULL, 0x000fe20000000028ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff027819ULL, 0x000fe40000011663ULL,
0x00000010ff037819ULL, 0x000fe20000011670ULL, 0x000000282018723cULL, 0x000fe20000041818ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000008ff2b7819ULL, 0x000fe4000001162bULL, 0x0000105462037816ULL, 0x000fe20000000003ULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x000010546f027816ULL, 0x000fc40000000002ULL,
0x00000010ff287819ULL, 0x000fe40000011661ULL, 0x00000010ff617819ULL, 0x000fe40000011672ULL,
0x000000ff56567812ULL, 0x000fe200078ec0ffULL, 0x000000022014723cULL, 0x000fe20000041814ULL,
0x0000002bff63723eULL, 0x000fe400020006ffULL, 0x0000105428617816ULL, 0x000fe40000000061ULL,
0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL, 0x000000002a28783bULL, 0x000e620000000200ULL,
0x00000008ff4e7819ULL, 0x000fe2000001164eULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000056ff62723eULL, 0x000fc400020006ffULL, 0x00000010ff567819ULL, 0x000fe40000011654ULL,
0x00000010ff037819ULL, 0x000fe2000001166aULL, 0x20000062ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff027819ULL, 0x000fe40000011655ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x0000004eff4e723eULL, 0x000fc400020006ffULL,
0x0000105456037816ULL, 0x000fe20000000003ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000105469027816ULL, 0x000fe20000000002ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff52557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x000fe40000011653ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x000000022010723cULL, 0x000fe20000041810ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166dULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff537819ULL, 0x000fe4000001166eULL, 0x00000010ff527819ULL, 0x000fe40000011663ULL,
0x00000008ff487819ULL, 0x000fe40000011648ULL, 0x000010546d607816ULL, 0x000fe40000000060ULL,
0x0000105456537816ULL, 0x000fc40000000053ULL, 0x0000105452527816ULL, 0x000fe40000000057ULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x00000060200c723cULL, 0x040fe2000004180cULL,
0x00000010ff027819ULL, 0x000fe4000001164bULL, 0x00000010ff4c7819ULL, 0x000fe2000001164cULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff037819ULL, 0x000fe2000001164eULL, 0x000000522008723cULL, 0x000fe20000041808ULL,
0x000000ff49497812ULL, 0x000fc400078ec0ffULL, 0x00000008ff4a7819ULL, 0x000fe4000001164aULL,
0x00001054024d7816ULL, 0x000fe4000000004dULL, 0x00001054034c7816ULL, 0x000fe4000000004cULL,
0x0000007aff41723eULL, 0x000fe400020006ffULL, 0x0000007bff42723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff027819ULL, 0x000fe2000001163dULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff3e7819ULL, 0x000fe2000001163eULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe20000011643ULL, 0x0000004c2824723cULL, 0x002fe20000041824ULL,
0x00000010ff037819ULL, 0x000fc40000011644ULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x0000105402217816ULL, 0x000fe40000000021ULL, 0x0000105403207816ULL, 0x000fe4000000003eULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff027819ULL, 0x000fe2000001163fULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fe20000011640ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fe20000011645ULL, 0x000000202804723cULL, 0x000fe20000041804ULL,
0x00000010ff037819ULL, 0x000fc40000011648ULL, 0x0000105402237816ULL, 0x000fe40000000023ULL,
0x0000105403227816ULL, 0x000fe40000000040ULL, 0x00000010ff027819ULL, 0x000fe40000011641ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff437819ULL, 0x000fe20000011649ULL,
0x00000022281c723cULL, 0x000fe2000004181cULL, 0x00000010ff037819ULL, 0x000fc4000001164aULL,
0x00000008ff397819ULL, 0x000fe40000011639ULL, 0x000000ff38387812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3a7819ULL, 0x000fe4000001163aULL, 0x000000ff3b3b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3c7819ULL, 0x000fe4000001163cULL, 0x0000105402437816ULL, 0x000fc40000000043ULL,
0x0000105403427816ULL, 0x000fe40000000042ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff037819ULL, 0x000fe20000011654ULL,
0x000000422818723cULL, 0x000fe20000041818ULL, 0x00000010ff027819ULL, 0x000fe4000001164fULL,
0x0000005aff5a723eULL, 0x000fc400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000038ff38723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fe200020006ffULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000105458037816ULL, 0x000fe20000000003ULL, 0x2000003bff227230ULL, 0x000fe20000004100ULL,
0x0000105402027816ULL, 0x000fe20000000059ULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fc4000001165aULL, 0x00000010ff217819ULL, 0x000fe40000011655ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x000000022814723cULL, 0x000fe20000041814ULL,
0x00000010ff207819ULL, 0x000fe40000011639ULL, 0x00000010ff3b7819ULL, 0x000fe4000001165cULL,
0x00000010ff387819ULL, 0x000fe40000011638ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff3a7819ULL, 0x000fe4000001163aULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff227819ULL, 0x000fe40000011622ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff037819ULL, 0x000fe4000001163cULL, 0x000010545a217816ULL, 0x000fc40000000021ULL,
0x0000105420207816ULL, 0x000fe4000000005bULL, 0x000010543b3b7816ULL, 0x000fe40000000038ULL,
0x000010543a3a7816ULL, 0x000fe4000000005dULL, 0x000010545f5f7816ULL, 0x000fe20000000022ULL,
0x00000020280c723cULL, 0x000fe2000004180cULL, 0x00001054035e7816ULL, 0x000fce000000005eULL,
0x0000003a2810723cULL, 0x040ff00000041810ULL, 0x0000005e2808723cULL, 0x000fe20000041808ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe82000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff357224ULL, 0x000fe200078e0031ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffdcf000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0106140030037984ULL, 0x000e620000000800ULL,
0x0000ffff33007812ULL, 0x000fe200078ec0ffULL, 0x000000242f2b7220ULL, 0x040fe20000410000ULL,
0x0000001c2f237220ULL, 0x040fe20000410000ULL, 0x000000252f257220ULL, 0x040fe20000410000ULL,
0x0000888000387816ULL, 0x000fe200000000ffULL, 0x000000052f247220ULL, 0x040fe20000410000ULL,
0x0000000c2f1c7220ULL, 0x040fe20000410000ULL, 0x0000000e2f0e7220ULL, 0x040fe20000410000ULL,
0x000000262f027220ULL, 0x040fe20000410000ULL, 0x8000000038007824ULL, 0x000fe200078e00ffULL,
0x000000272f277220ULL, 0x040fe20000410000ULL, 0x000000042f047220ULL, 0x040fe20000410000ULL,
0x000000062f067220ULL, 0x040fe20000410000ULL, 0x000000072f077220ULL, 0x040fe20000410000ULL,
0x0000001e2f057220ULL, 0x040fe20000410000ULL, 0x0000001f2f227220ULL, 0x040fe20000410000ULL,
0x0000001a2f287220ULL, 0x040fe20000410000ULL, 0x0000001b2f297220ULL, 0x040fe20000410000ULL,
0x000000162f2a7220ULL, 0x040fe20000410000ULL, 0x000000172f357220ULL, 0x040fe20000410000ULL,
0x000000122f0c7220ULL, 0x040fe20000410000ULL, 0x000000192f1f7220ULL, 0x040fe20000410000ULL,
0x0000001d2f217220ULL, 0x040fe20000410000ULL, 0x000000182f207220ULL, 0x040fe20000410000ULL,
0x0000000d2f1b7220ULL, 0x040fe20000410000ULL, 0x000000112f197220ULL, 0x040fe20000410000ULL,
0x000000142f1e7220ULL, 0x040fe20000410000ULL, 0x000000152f1d7220ULL, 0x040fe20000410000ULL,
0x000000102f1a7220ULL, 0x040fe20000410000ULL, 0x000000132f0d7220ULL, 0x040fe20000410000ULL,
0x000000082f187220ULL, 0x040fe20000410000ULL, 0x000000092f177220ULL, 0x040fe20000410000ULL,
0x0000000a2f367220ULL, 0x040fe20000410000ULL, 0x0000000b2f377220ULL, 0x040fe20000410000ULL,
0x000000ffff267224ULL, 0x000fe200078e0025ULL, 0x0000000f2f0f7220ULL, 0x000fe20000410000ULL,
0x000000ffff117224ULL, 0x000fc400078e000eULL, 0x000000ffff257224ULL, 0x000fe200078e0004ULL,
0x8000000003ff7812ULL, 0x002fe20007804800ULL, 0x000000ffff167224ULL, 0x000fe400078e0002ULL,
0x000000ffff157224ULL, 0x000fe400078e0027ULL, 0x000000ffff147224ULL, 0x000fe400078e0006ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0007ULL, 0x000000ffff0a7224ULL, 0x000fc400078e0005ULL,
0x000000ffff097224ULL, 0x000fe400078e0022ULL, 0x000000ffff087224ULL, 0x000fe400078e0028ULL,
0x000000ffff137224ULL, 0x000fe400078e0029ULL, 0x000000ffff127224ULL, 0x000fe400078e002aULL,
0x000000ffff107224ULL, 0x000fe400078e0035ULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0036ULL, 0x000000ffff037224ULL, 0x000fe200078e0037ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000038057824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x0106140030027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000042e007824ULL, 0x000fe200078e00ffULL,
0x000000325100720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff000057812ULL, 0x000fca00078ec0ffULL, 0x0000008050027824ULL, 0x000fca00078e0205ULL,
0x0104000002047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000022e227824ULL, 0x000fe400078e00ffULL, 0x0000000147347824ULL, 0x000fc600078e0a34ULL,
0x0000000622277812ULL, 0x000fc800078ec0ffULL, 0x0000000127297812ULL, 0x040fe400078efcffULL,
0x0000000827357812ULL, 0x000fe400078efcffULL, 0x000000342900720cULL, 0x080fe40003f26070ULL,
0x0000001027297812ULL, 0x000fe400078efcffULL, 0x000000343500720cULL, 0x080fe40003f06070ULL,
0x000000342900720cULL, 0x000fc40003fc6070ULL, 0x0000001127357812ULL, 0x040fe400078efcffULL,
0x0000001827297812ULL, 0x040fe400078efcffULL, 0x000000342700720cULL, 0x080fe40003f46070ULL,
0x000000343500720cULL, 0x080fe40003fa6070ULL, 0x000000342900720cULL, 0x000fe40003f66070ULL,
0x0000000927377812ULL, 0x000fc400078efcffULL, 0x0000001927357812ULL, 0x040fe400078efcffULL,
0x0000002027297812ULL, 0x000fe400078efcffULL, 0xff7fffff16167808ULL, 0x000fe40005000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40004800000ULL,
0xff7fffff26267808ULL, 0x000fc40004800000ULL, 0x000000343700720cULL, 0x080fe40003f86070ULL,
0x000000343500720cULL, 0x080fe40003f46070ULL, 0x000000342900720cULL, 0x000fe40003f26070ULL,
0x0000002127357812ULL, 0x040fe400078efcffULL, 0x0000002827297812ULL, 0x000fe400078efcffULL,
0xff7fffff14147808ULL, 0x000fc40004000000ULL, 0xff7fffff25257808ULL, 0x000fe40004000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL, 0xff7fffff24247808ULL, 0x000fe40006000000ULL,
0x000000343500720cULL, 0x080fe40003f06070ULL, 0x000000342900720cULL, 0x000fe40003f86070ULL,
0x0000002927357812ULL, 0x000fc400078efcffULL, 0x0000003027297812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40007000000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0x000000343500720cULL, 0x000fc40003fc6070ULL, 0x000000342900720cULL, 0x000fe40003fa6070ULL,
0x0000003127357812ULL, 0x040fe400078efcffULL, 0x0000003827297812ULL, 0x040fe400078efcffULL,
0x0000003927277812ULL, 0x000fe400078efcffULL, 0xff7fffff08087808ULL, 0x000fe40005800000ULL,
0xff7fffff20207808ULL, 0x000fc40005800000ULL, 0xff7fffff13137808ULL, 0x000fe40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40004800000ULL, 0x000000343500720cULL, 0x080fe40003f66070ULL,
0x000000342900720cULL, 0x000fc40003f46070ULL, 0x000000342700720cULL, 0x000fe40003f26070ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL,
0xff7fffff0f0f7808ULL, 0x000fc40007000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40006800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40005800000ULL, 0xff7fffff19197808ULL, 0x000fe40005800000ULL,
0xff7fffff0c0c7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff03037808ULL, 0x000fe40004800000ULL, 0xff7fffff17177808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002b04277209ULL, 0x004fe20007810000ULL,
0x0000001fff367424ULL, 0x000fe200078e00ffULL, 0x0000001605227209ULL, 0x000fe20007810000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x0000002627047209ULL, 0x000fe40007810000ULL,
0x0000001522057209ULL, 0x000fc40007810000ULL, 0x0000002504277209ULL, 0x000fe40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x0000002427227209ULL, 0x000fe40007810000ULL,
0x0000000b04057209ULL, 0x000fe40007810000ULL, 0x0000002322227209ULL, 0x000fe40007810000ULL,
0x0000000a05047209ULL, 0x000fc40007810000ULL, 0x0000002122057209ULL, 0x000fe40007810000ULL,
0x0000000904277209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000000827227209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fe40007810000ULL,
0x0000001322277209ULL, 0x000fc40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000001227277209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000001027047209ULL, 0x000fe40007810000ULL, 0x0000001c05227209ULL, 0x000fe40007810000ULL,
0x0000001104047209ULL, 0x000fc40007810000ULL, 0x0000001b22057209ULL, 0x000fe40007810000ULL,
0x0000000f04277209ULL, 0x000fe40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000000e27227209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000000d22277209ULL, 0x000fc40007810000ULL, 0x0000001805047209ULL, 0x000fe40007810000ULL,
0x0000000c27227209ULL, 0x000fe40007810000ULL, 0x0000001704057209ULL, 0x000fe40007810000ULL,
0x0000000322347209ULL, 0x000fe20007810000ULL, 0x00000e127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x0000000405357209ULL, 0x008fe20007810000ULL,
0x00000e427f007947ULL, 0x000fea000b800000ULL, 0x0c401f0034047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0007227f89ULL, 0x000f2200000e0000ULL,
0x0000000434287209ULL, 0x008fc60007810000ULL, 0x0c201f0035047f89ULL, 0x000ee200000e0000ULL,
0x0000000506297209ULL, 0x004fc60007810000ULL, 0x0c201f0028057f89ULL, 0x000ea200000e0000ULL,
0x0000002207227209ULL, 0x010fc60007810000ULL, 0x0c201f00292a7f89ULL, 0x002e6800000e0000ULL,
0x0c201f0022277f89ULL, 0x00092200000e0000ULL, 0x0000000435047209ULL, 0x008fe40007810000ULL,
0x0000000528057209ULL, 0x004fe40007810000ULL, 0x0000002a29067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04287820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05377820ULL, 0x002fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010837ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010828ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b19197823ULL, 0x000fe20000010828ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010837ULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b03037823ULL, 0x000fca0000010837ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ff00000000800ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000e700000000800ULL,
0x0000001c00297308ULL, 0x0007f00000000800ULL, 0x00000021002a7308ULL, 0x000fe20000000800ULL,
0x00000004ff1c7e24ULL, 0x008fe2000f8e00ffULL, 0x000000140b0b723eULL, 0x002fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x3f8000001c1c783eULL, 0x000fe400000010ffULL, 0x0000001a00217308ULL, 0x0003f00000000800ULL,
0x0000001800357308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b081a7823ULL, 0x002fe20000010837ULL,
0x0000002b2608723eULL, 0x000fcc00000010ffULL, 0x0000001700287308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0a187823ULL, 0x008fe20000010837ULL, 0x00000025240a723eULL, 0x000fe200000010ffULL,
0x000000ffff257224ULL, 0x000fca00078e001cULL, 0x0000001d00077308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b09177823ULL, 0x002fe20000010837ULL, 0x000000161509723eULL, 0x000fcc00000010ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x000000ffff1d7224ULL, 0x008fce00078e001cULL,
0x0000001900367308ULL, 0x000ff00000000800ULL, 0x0000001700197308ULL, 0x0007f00000000800ULL,
0x0000001800187308ULL, 0x000f620000000800ULL, 0x0000001c0814723cULL, 0x008fee00000418ffULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b101d7823ULL, 0x100fe20000010837ULL,
0x000000232a10723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b11237823ULL, 0x000fca0000010837ULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000181911723eULL, 0x020fe200000010ffULL,
0x000000ffff187224ULL, 0x100fe400078e001cULL, 0x000000ffff197224ULL, 0x000fc800078e001cULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001300137308ULL, 0x000e700000000800ULL,
0x0000001b00347308ULL, 0x0007620000000800ULL, 0x0000001a1313723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b121b7823ULL, 0x008fe20000010837ULL, 0x000000201f12723eULL, 0x000fca00000010ffULL,
0x0000001d00247308ULL, 0x000fe20000000800ULL, 0x0000000fff1f7424ULL, 0x000fe200078e00ffULL,
0x00000029341a723eULL, 0x020fe200000010ffULL, 0x000000181014723cULL, 0x000fea0000041814ULL,
0x0000001b001b7308ULL, 0x000e700000000800ULL, 0x0000001e001e7308ULL, 0x000ef00000000800ULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x0000001b2419723eULL, 0x002fe200000010ffULL,
0x000000ffff247224ULL, 0x000fcc00078e001cULL, 0x0000000f00207308ULL, 0x000e620000000800ULL,
0x0000001e0718723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b0c077823ULL, 0x000fe20000010837ULL,
0xfffffffc2e0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c1f1f7219ULL, 0x000fe200000006ffULL,
0x0000000e001d7308ULL, 0x0007e20000000800ULL, 0x00000021360c723eULL, 0x000fe400000010ffULL,
0x000000001f0473c4ULL, 0x000f620000004000ULL, 0x00000023201b723eULL, 0x002fc800000010ffULL,
0x0000000d00267308ULL, 0x000e620000000800ULL, 0x000000001f2073a1ULL, 0x000f2200000e8000ULL,
0x00000035280e723eULL, 0x008fe200000010ffULL, 0x000000241814723cULL, 0x000fea0000041814ULL,
0x0000000700077308ULL, 0x000ff00000000800ULL, 0x00000003001e7308ULL, 0x000ee20000000800ULL,
0x0000001d260d723eULL, 0x002fe200000010ffULL, 0x000000ffff1d7224ULL, 0x000fe200078e001cULL,
0x000000051fff7c12ULL, 0x010fc4000f804020ULL, 0x000000071e0f723eULL, 0x008fe400000010ffULL,
0x0000002227077209ULL, 0x004fca0007810000ULL, 0x0000001c0c28723cULL, 0x000fe80000041814ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0000090204008947ULL, 0x020fde000b800000ULL,
0x001c1fff28147589ULL, 0x0002a400000e0000ULL, 0x000000001f1673a1ULL, 0x000ee200000e8000ULL,
0x000000001f0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051fff7c12ULL, 0x008fda000f804016ULL, 0x0000091204008947ULL, 0x010fea000b800000ULL,
0x001c1fff2a157589ULL, 0x00072800000e0000ULL, 0x001c1fff16167589ULL, 0x00066800000e0000ULL,
0x001c1fff00177589ULL, 0x0006a400000e0000ULL, 0x00000002ff037819ULL, 0x002fe4000001162eULL,
0x0000000c00397812ULL, 0x000fc400078ec0ffULL, 0x00000007031c7812ULL, 0x040fe200078ec0ffULL,
0x0000000803217824ULL, 0x040fe200078e00ffULL, 0x00000003ff1f7212ULL, 0x008fe200078e33ffULL,
0x00000008031d7824ULL, 0x040fe200078e00ffULL, 0x000000032eff7812ULL, 0x000fe2000780c0ffULL,
0x0000000803347824ULL, 0x040fe200078e00ffULL, 0x0000000803037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8211e7812ULL, 0x100fe400078ee21cULL, 0x000000011d207812ULL, 0x100fe200078ef61cULL,
0x0000000803447824ULL, 0x000fe200078e00ffULL, 0x000000021d227812ULL, 0x100fe200078ef61cULL,
0x0000000803217824ULL, 0x000fe200078e00ffULL, 0x000000031d247812ULL, 0x000fc400078ef61cULL,
0x000000041d267812ULL, 0x140fe400078ef61cULL, 0x000000051d287812ULL, 0x140fe400078ef61cULL,
0x000000061d2a7812ULL, 0x000fe200078ef61cULL, 0x00000008031d7824ULL, 0x040fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe400078ee21fULL, 0x00000003ff1f7212ULL, 0x000fe400078e33ffULL,
0x00000007031c7812ULL, 0x000fc400078ec0ffULL, 0x0000a00050037811ULL, 0x000fe400078e58ffULL,
0xfffffff821367812ULL, 0x100fe400078ee21cULL, 0x000000011d387812ULL, 0x140fe200078ef61cULL,
0x000000101e007824ULL, 0x000fe200078e0203ULL, 0xfffffff844447812ULL, 0x000fe200078ee21fULL,
0x00000010221e7824ULL, 0x100fe200078e0203ULL, 0x000000021d3a7812ULL, 0x140fe200078ef61cULL,
0x0000001026227824ULL, 0x100fe200078e0203ULL, 0x000000031d3c7812ULL, 0x140fe200078ef61cULL,
0x000000102a267824ULL, 0x100fe200078e0203ULL, 0x000000041d3e7812ULL, 0x140fe200078ef61cULL,
0x00000010382a7824ULL, 0x100fe200078e0203ULL, 0x000000051d407812ULL, 0x140fe200078ef61cULL,
0x000000103a2b7824ULL, 0x100fe200078e0203ULL, 0x000000061d427812ULL, 0x000fe200078ef61cULL,
0x00000010201c7824ULL, 0x000fc400078e0203ULL, 0x0000001024207824ULL, 0x100fe400078e0203ULL,
0x0000001028247824ULL, 0x100fe400078e0203ULL, 0x00000001391d7824ULL, 0x000fe400078e0200ULL,
0x0000001034287824ULL, 0x100fe400078e0203ULL, 0x0000001036007824ULL, 0x100fe200078e0203ULL,
0x000000081d007388ULL, 0x0003e20000000800ULL, 0x000000103c347824ULL, 0x000fc400078e0203ULL,
0x000000103e357824ULL, 0x100fe400078e0203ULL, 0x0000001040367824ULL, 0x100fe400078e0203ULL,
0x0000001042377824ULL, 0x100fe400078e0203ULL, 0x0000001044387824ULL, 0x000fe400078e0203ULL,
0x0000000139037824ULL, 0x040fe400078e021cULL, 0x00000001391f7824ULL, 0x000fc400078e021eULL,
0x0000000139217824ULL, 0x040fe200078e0220ULL, 0x0000000a03007388ULL, 0x0007e20000000800ULL,
0x0000000139237824ULL, 0x040fe400078e0222ULL, 0x0000000139257824ULL, 0x040fe200078e0224ULL,
0x000000101f007388ULL, 0x0007e20000000800ULL, 0x0000000139277824ULL, 0x040fe400078e0226ULL,
0x0000000139297824ULL, 0x040fe200078e0228ULL, 0x0000001221007388ULL, 0x0007e20000000800ULL,
0x0000000139007824ULL, 0x000fc400078e0200ULL, 0x00000001392a7824ULL, 0x040fe200078e022aULL,
0x0000001823007388ULL, 0x0007e20000000800ULL, 0x00000001391c7824ULL, 0x040fe400078e022bULL,
0x0000000139347824ULL, 0x040fe200078e0234ULL, 0x0000001a25007388ULL, 0x0007e20000000800ULL,
0x0000000139087824ULL, 0x042fe400078e0235ULL, 0x0000000139367824ULL, 0x040fe200078e0236ULL,
0x0000000c27007388ULL, 0x0007e20000000800ULL, 0x00000001391e7824ULL, 0x000fc400078e0237ULL,
0x0000000139387824ULL, 0x000fe200078e0238ULL, 0x0000000e29007388ULL, 0x0007e80000000800ULL,
0x0000000900007388ULL, 0x0007e80000000800ULL, 0x0000000b2a007388ULL, 0x0007e80000000800ULL,
0x000000111c007388ULL, 0x0007e80000000800ULL, 0x0000001334007388ULL, 0x0007e80000000800ULL,
0x0000001908007388ULL, 0x0007e80000000800ULL, 0x0000001b36007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f38007388ULL, 0x0007e80000000800ULL,
0x0100000402008388ULL, 0x0007e80000000c00ULL, 0x0102001402008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030051517a10ULL, 0x000fe20007ffe0ffULL,
0x0106080030ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff33ff7812ULL, 0x000fc4000780c0ffULL,
0x000000465100720cULL, 0x000fe40003f26070ULL, 0x00000001ff337807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffc29000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff277224ULL, 0x000fe200078e0005ULL,
0x00018e7000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2a7424ULL, 0x000fe400078e00ffULL,
0x0000053000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0027ULL,
0xfffff1a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x000fe200078e0034ULL,
0x00018ed000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2a7424ULL, 0x002fe400078e00ffULL,
0x000004d000007944ULL, 0x004fea0003c00000ULL, 0x0000002734347209ULL, 0x004fe20007810000ULL,
0x000000ffff277224ULL, 0x000fe200078e0006ULL, 0x00018f2000287802ULL, 0x000fe20000000f00ULL,
0x00000002ff2a7424ULL, 0x002fe400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002706067209ULL, 0x004fe20007810000ULL, 0x000000ffff277224ULL, 0x000fe200078e0007ULL,
0x00018f7000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2a7424ULL, 0x002fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002707227209ULL, 0x004fe20007810000ULL,
0x000000ffff277224ULL, 0x000fe200078e0035ULL, 0x00018fc000287802ULL, 0x000fe20000000f00ULL,
0x00000001ff2a7424ULL, 0x002fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000002735047209ULL, 0x004fe20007810000ULL, 0x000000ffff277224ULL, 0x000fe200078e0034ULL,
0x0001901000287802ULL, 0x000fe20000000f00ULL, 0x00000001ff2a7424ULL, 0x002fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002734057209ULL, 0x004fe20007810000ULL,
0x000000ffff277224ULL, 0x000fe200078e0006ULL, 0x0001906000287802ULL, 0x000fe20000000f00ULL,
0x00000001ff2a7424ULL, 0x002fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0x0000002706067209ULL, 0x004fe20007810000ULL, 0x000000ffff277224ULL, 0x000fe200078e0022ULL,
0x000190b000287802ULL, 0x000fe20000000f00ULL, 0x00000001ff2a7424ULL, 0x002fc400078e00ffULL,
0x000002f000007944ULL, 0x000fea0003c00000ULL, 0xfffff06000007947ULL, 0x000fea000383ffffULL,
0x000000ffff037224ULL, 0x000fe200078e0028ULL, 0x00019110001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff207424ULL, 0x000fe400078e00ffULL,
0x000002d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0017ULL,
0xfffff6a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff037224ULL, 0x002fe200078e002aULL,
0x00019180001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff207424ULL, 0x000fe400078e00ffULL, 0x0000026000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1e7224ULL, 0x002fe200078e00ffULL, 0x000191d0001c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff207424ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x004fe400078e0017ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1e7224ULL, 0x002fe200078e00ffULL,
0x00019220001c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff207424ULL, 0x000fc400078e00ffULL,
0x000000ffff167224ULL, 0x004fe400078e0017ULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xfffff62000007947ULL, 0x000fea000383ffffULL, 0x018000002b037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000002b00038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff087807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000308ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff2bff7812ULL, 0x040fe4000780c0ffULL,
0x800000002b057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000308ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002b00037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe6c6004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff297424ULL, 0x000fe200078e00ffULL, 0x0000003700007348ULL, 0x000fe80003800000ULL,
0x0c00002a27277389ULL, 0x0002a200000e0036ULL, 0xfffe6c2028007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000001f00007348ULL, 0x000fe80003800000ULL,
0x0000001e03177389ULL, 0x0002a200000e0020ULL, 0xfffe6be01c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000008e8ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001100ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001190ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001198ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011a8ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001380ULL, 0x0000000000019500ULL, 0x9c00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a880ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001a890ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a890ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001ad10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001190ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000196f0ULL, 0x00000000000196f0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001a880ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001ad10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_e4m3_nqpkv_16_m_16_sm_89_cubin_len = 110064;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
