/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001bb10ULL, 0x000000000001b690ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x000000000001a0c0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001a230ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000001a270ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000001a2b0ULL,
0x0000000000000150ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001a400ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001a0c000000000ULL, 0x0000040400000000ULL, 0x810c0000013c0400ULL,
0x0066e80400288080ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080830828ULL, 0x2880808a08288080ULL, 0x8094082880809008ULL, 0x082880809e082880ULL,
0x8080a808288080aeULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a892ULL,
0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001a0c000000000ULL, 0x0000017000000000ULL,
0x0000480400000000ULL, 0x8083288080840900ULL, 0x0000000000002880ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080830828ULL, 0x2880809008288080ULL, 0x80a8082880809e08ULL,
0x08288080ae082880ULL, 0x8082801628808094ULL, 0x0000000000031028ULL, 0x2880809492000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000011800000000ULL, 0x0001a23000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080830828ULL, 0x2880809408288080ULL, 0x80a8082880809e08ULL, 0x08288080ae082880ULL,
0x8082801628808090ULL, 0x0000000000031028ULL, 0x2880809092000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x000001b000000000ULL, 0x0001a27000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080830828ULL,
0x2880809408288080ULL, 0x80a8082880809e08ULL, 0x08288080ae082880ULL, 0x8082801628808090ULL,
0x0000000000031028ULL, 0x2880809092000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000024800000000ULL, 0x0001a2b000000000ULL, 0x0000015000000000ULL, 0x0000000000000000ULL,
0x0000001200082f04ULL, 0x000812040000007cULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000eULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x00018b30000187f0ULL,
0x00018c3000018b50ULL, 0x00018c5000018c40ULL, 0xffffffff01a82904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000013ffffffffULL,
0x0500001305000013ULL, 0xffffffff05000013ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01a82804ffffffffULL,
0x00000100000000e0ULL, 0x0000270000001670ULL, 0x0000282000002780ULL, 0x00002b5000002850ULL,
0x00002bd000002b60ULL, 0x0000311000002c40ULL, 0x0000402000004010ULL, 0x0000526000004290ULL,
0x00005390000052e0ULL, 0x00005690000054b0ULL, 0x00005700000056a0ULL, 0x00005a0000005760ULL,
0x000067c0000067b0ULL, 0x00007a6000006a90ULL, 0x00007b9000007ae0ULL, 0x00007e9000007cb0ULL,
0x00007f0000007ea0ULL, 0x0000820000007f60ULL, 0x00008fc000008fb0ULL, 0x0000a26000009290ULL,
0x0000a3900000a2e0ULL, 0x0000a6900000a4b0ULL, 0x0000a7000000a6a0ULL, 0x0000aa300000a760ULL,
0x0000b7f00000b7e0ULL, 0x0000bc500000bc40ULL, 0x0000e1b00000c540ULL, 0x0000e8a00000e240ULL,
0x0000f1000000e8e0ULL, 0x000184c000018490ULL, 0x000184e0000184d0ULL, 0x0001853000018510ULL,
0x0001855000018540ULL, 0x00018c8000018c20ULL, 0x00018ca000018c90ULL, 0x00019400000193b0ULL,
0x000194e000019470ULL, 0x000195c000019550ULL, 0x0001966000019610ULL, 0x00019730000196c0ULL,
0x000197f000019790ULL, 0x0001989000019840ULL, 0x00019960000198f0ULL, 0x00019a20000199c0ULL,
0x00019ac000019a70ULL, 0x00019b9000019b20ULL, 0x00019c5000019bf0ULL, 0x00019d1000019cb0ULL,
0x00019db000019d60ULL, 0x00019e5000019e00ULL, 0x00019ef000019ea0ULL, 0x00019fe000019f60ULL,
0x0001a0a00001a040ULL, 0x0000021002003904ULL, 0x00014600000000ffULL, 0x00000250003f0100ULL,
0x0001460800000007ULL, 0x000002a0003f0120ULL, 0x0001468800000007ULL, 0x00000480003f0120ULL,
0x00014600000000ffULL, 0x00000600003f0107ULL, 0x0001468c00000068ULL, 0x00000660003f0102ULL,
0x0001468800000068ULL, 0x00002570003f0101ULL, 0x0001460800000068ULL, 0x00002580003f0101ULL,
0x0001460c00000068ULL, 0x00002610003f0105ULL, 0x0001460c00000068ULL, 0x00004260003f0105ULL,
0x00014688000000ffULL, 0x00005130003f0101ULL, 0x0001462800000068ULL, 0x00005140003f0101ULL,
0x0001462c00000068ULL, 0x000051d0003f0105ULL, 0x0001462c00000068ULL, 0x00006a60003f0105ULL,
0x00014690000000ffULL, 0x00007930003f0101ULL, 0x0001464800000068ULL, 0x00007940003f0101ULL,
0x0001464c00000068ULL, 0x000079d0003f0105ULL, 0x0001464c00000068ULL, 0x00009260003f0105ULL,
0x00014698000000ffULL, 0x0000a130003f0101ULL, 0x0001466800000068ULL, 0x0000a140003f0101ULL,
0x0001466c00000068ULL, 0x0000a1d0003f0105ULL, 0x0001466c00000068ULL, 0x0000ba90003f0105ULL,
0x000146a0000000ffULL, 0x0000f460003f0101ULL, 0x00014600000000ffULL, 0x00010220003f0101ULL,
0x00014604000000ffULL, 0x000102c0003f0105ULL, 0x00014604000000ffULL, 0x00017ad0003f0105ULL,
0x0000000000000006ULL, 0x00017b10003f0101ULL, 0x0000000400000006ULL, 0x00017d90003f0105ULL,
0x0000000400000006ULL, 0x00019210003f0105ULL, 0x0001460800000008ULL, 0x00019270003f0101ULL,
0x0001461000000008ULL, 0x000192d0003f0101ULL, 0x0001461800000008ULL, 0x00019340003f0101ULL,
0x0001462000000008ULL, 0x00033803003f0101ULL, 0x0000f36000101c04ULL, 0x000103b000010320ULL,
0x0000040100019380ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000002ccULL, 0x0000001200000002ULL,
0x0000000000000234ULL, 0x0000001200000002ULL, 0x000000000000019cULL, 0x0000001200000002ULL,
0x00000000000000f4ULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x00000000000002a3ULL, 0x0000001200000002ULL, 0x000000000000020bULL, 0x0000001200000002ULL,
0x0000000000000173ULL, 0x0000001200000002ULL, 0x00000000000000d0ULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000077919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0x0000000000007919ULL, 0x000ea80000002200ULL, 0x00000000000b7919ULL, 0x000ee80000000000ULL,
0x0000000000057919ULL, 0x000f280000002600ULL, 0x0000000000067919ULL, 0x000f620000002700ULL,
0x00000005ff627819ULL, 0x002fc60000011607ULL, 0x0000000000047919ULL, 0x000e680000000000ULL,
0x00001fff62627589ULL, 0x000fe200000e0000ULL, 0x000000010d007824ULL, 0x004fc600078e0200ULL,
0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL, 0x0000008000077824ULL, 0x000fe400078e0207ULL,
0x0000001200007300ULL, 0x000ee200000e0000ULL, 0x00000008050f7824ULL, 0x010fe400078e00ffULL,
0x000000ff0700720cULL, 0x040fe40003f25270ULL, 0x0000000f0700780cULL, 0x040fe20003f44070ULL,
0x00000005060f7c24ULL, 0x020fe2000f8e020fULL, 0x0000007f0700780cULL, 0x040fe20003f84070ULL,
0x0000001200127309ULL, 0x000f220000000000ULL, 0x000000030700780cULL, 0x000fe20003f64070ULL,
0x00000010040e7824ULL, 0x002fe200078e00ffULL, 0x0000000b0000720cULL, 0x008fca0003f02070ULL,
0x3fffff80ff029424ULL, 0x000fe200078e00ffULL, 0x000001f00e117812ULL, 0x000fe200078ec0ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x000000040d007824ULL, 0x004fe400078e0262ULL,
0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL, 0x01460002ff009388ULL, 0x0003e20000000a00ULL,
0x7fffffc0ff09a424ULL, 0x000fe400078e00ffULL, 0xff317217ff0cc424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff0ab424ULL, 0x000fe200078e00ffULL, 0x014608080700a388ULL, 0x000fe20000008a00ULL,
0x7fffff60ff0bb424ULL, 0x000fe400078e00ffULL, 0x0000000200007824ULL, 0x000fe200078e00ffULL,
0x0144000c0700c388ULL, 0x0005e60000004800ULL, 0x000000010f027824ULL, 0x002fe200078e0200ULL,
0x0146880a0700b388ULL, 0x0003e20000008a00ULL, 0x0000000800037817ULL, 0x000fc40007800000ULL,
0x0000000100107810ULL, 0x000fc60007ffe0ffULL, 0x00000001030c7824ULL, 0x004fe400078e0a00ULL,
0x000000010f087824ULL, 0x000fe400078e0210ULL, 0x00005c0002027625ULL, 0x080fe200078e0013ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000700077812ULL, 0x002fe400078ec0ffULL,
0x00000007100b7812ULL, 0x000fe200078ec0ffULL, 0x00005c0008087625ULL, 0x000fe200078e0013ULL,
0x0000001f07077812ULL, 0x000fc400078e7804ULL, 0x000000ff0c00720cULL, 0x000fe40003f23070ULL,
0x0000001f0b0f7812ULL, 0x000fe200078e7804ULL, 0x0000002000077824ULL, 0x000fe200078e0207ULL,
0x000000010c00780cULL, 0x000fe20003f43070ULL, 0x000000ffff007224ULL, 0x010fe200078e0a12ULL,
0x00000011020a7210ULL, 0x080fe20007f7e0ffULL, 0x00000020100f7824ULL, 0x000fe200078e020fULL,
0x0000001108087210ULL, 0x000fe20007f9e0ffULL, 0x0000001007077824ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fc400018e0603ULL, 0x000000ffff097224ULL, 0x000fe400020e0609ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a077faeULL, 0x0003e2000c901c46ULL, 0x00000004ff117424ULL, 0x000fc600078e00ffULL,
0x00000000080f7faeULL, 0x0003e2000d101c46ULL, 0x0000620006027625ULL, 0x000fc600078e0011ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01460400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602607981ULL, 0x000ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000ee20000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000005ff647e24ULL, 0x008fe2000f8e00ffULL,
0x0000003f60617810ULL, 0x004fc40007ffe0ffULL, 0x000000ff60177810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff617819ULL, 0x000fe40000011661ULL, 0x00000008ff177819ULL, 0x000fca0000011617ULL,
0x0000ede000008947ULL, 0x000fea0003800000ULL, 0x0000000464667824ULL, 0x040fe200078e00ffULL,
0x0000000164007810ULL, 0x002fe20007ffe0ffULL, 0x0000000862687824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x000000170000720cULL, 0x000fe40003f26070ULL,
0x000000616600720cULL, 0x000fe20003f06070ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01468c0368ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146880068ff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff657424ULL, 0x000fe200078e00ffULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x0000640066037a10ULL, 0x002fe20007ffe0ffULL,
0x0000000206007824ULL, 0x000fc800078e00ffULL, 0x0000640000037a24ULL, 0x000fc800078e0203ULL,
0x0000600003027625ULL, 0x000fca00078e0011ULL, 0x0000000602657981ULL, 0x000364000c1e1900ULL,
0x0000580065007a24ULL, 0x020fc800078e02ffULL, 0x0000004000217824ULL, 0x000fe200078e00ffULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fe20000011604ULL,
0x0000010064037824ULL, 0x002fc600078e00ffULL, 0x00000008070f7810ULL, 0x040fe40007ffe0ffULL,
0x00000004070d7810ULL, 0x000fe40007ffe0ffULL, 0x000000040f087212ULL, 0x0c0fe200078e3cffULL,
0x000000080f0b7824ULL, 0x000fe200078e00ffULL, 0x0000001007137810ULL, 0x000fe20007ffe0ffULL,
0x000000080d097824ULL, 0x040fe200078e00ffULL, 0x000000040d027212ULL, 0x000fe400078e3cffULL,
0xfffffff80b187812ULL, 0x000fe200078ee208ULL, 0x0000004005087824ULL, 0x000fe200078e0207ULL,
0x0000001407157810ULL, 0x000fe20007ffe0ffULL, 0x00000008131c7824ULL, 0x000fe200078e00ffULL,
0xfffffff809167812ULL, 0x000fc400078ee202ULL, 0x0000000413097212ULL, 0x000fe200078e3cffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x0000000360007217ULL, 0x000fe40007800000ULL,
0x0000000c07117810ULL, 0x000fe40007ffe0ffULL, 0x00000008210b7210ULL, 0x000fe20007f1e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a03ULL, 0x00000004150a7212ULL, 0x000fe200078e3cffULL,
0x00000008111a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000000408097810ULL, 0x000fc40007ffe0ffULL,
0x0000000411037212ULL, 0x000fe400078e3cffULL, 0xfffffff8191e7812ULL, 0x000fe400078ee20aULL,
0x00005e000b027a11ULL, 0x000fe400078048ffULL, 0x00000008080a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000921097210ULL, 0x000fe40007f9e0ffULL, 0xfffffff81a1a7812ULL, 0x000fc400078ee203ULL,
0x00005f000b037a11ULL, 0x000fe400000f4c0cULL, 0x00000018071d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a21197210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000000c080b7810ULL, 0x040fe20007ffe0ffULL, 0x000000081d207824ULL, 0x000fe200078e00ffULL,
0x00000010080c7810ULL, 0x040fe40007ffe0ffULL, 0x00000014080e7810ULL, 0x000fc40007ffe0ffULL,
0x0000001808107810ULL, 0x040fe40007ffe0ffULL, 0x0000001c08127810ULL, 0x000fe40007ffe0ffULL,
0x00005e0009087a11ULL, 0x000fe400078c48ffULL, 0x0000000b211b7210ULL, 0x040fe40007f1e0ffULL,
0x0000000e21147210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x0000001c071f7810ULL, 0x000fc40007ffe0ffULL, 0x00005f0009097a11ULL, 0x000fe400030f4c0aULL,
0x000000041d0b7212ULL, 0x000fe200078e3cffULL, 0x000000081f257824ULL, 0x000fe200078e00ffULL,
0x00005e00190a7a11ULL, 0x000fe400078448ffULL, 0x0000002000007817ULL, 0x000fe40003800000ULL,
0x0000000c21247210ULL, 0x000fe40007f3e0ffULL, 0xfffffff820207812ULL, 0x000fc400078ee20bULL,
0x000000041f0c7212ULL, 0x000fe400078e3cffULL, 0x00005f00190b7a11ULL, 0x000fe400010f4c0eULL,
0x000000000700720cULL, 0x040fe40003f46070ULL, 0x0000000707077812ULL, 0x000fe400078e4804ULL,
0x0000001021237210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0xfffffff825227812ULL, 0x000fe200078ee20cULL, 0x0000000862257824ULL, 0x040fe200078e00ffULL,
0x00005e001b0c7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff267224ULL, 0x000fe200028e06ffULL,
0x0000c00062197811ULL, 0x000fc400078e68ffULL, 0x0ffffff8070e7812ULL, 0x000fe400078ef804ULL,
0x000000000d00720cULL, 0x080fe40003f06070ULL, 0x00005f001b0d7a11ULL, 0x000fe200030f4c10ULL,
0x000000100e1b7824ULL, 0x000fe200078e0219ULL, 0xfffffff825077812ULL, 0x000fe200078ee204ULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005e00240e7a11ULL, 0x040fe400078c48ffULL,
0x000000000f00720cULL, 0x000fe20003f26070ULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x00005f00240f7a11ULL, 0x000fc400030f4c25ULL, 0x0000001221217210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x00005e0014107a11ULL, 0x040fe200078c48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000021b7faeULL, 0x0003e2000d101c46ULL,
0x000000001100720cULL, 0x000fe20003f66070ULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005f0014117a11ULL, 0x000fe200030f4c25ULL, 0x0000001020257824ULL, 0x000fe200078e0219ULL,
0x00005e0023127a11ULL, 0x000fe400078a48ffULL, 0x00005e0021147a11ULL, 0x000fc400078c48ffULL,
0x000000001300720cULL, 0x080fe40003f46070ULL, 0x000000001500720cULL, 0x080fe20003f86070ULL,
0x00000010161b7824ULL, 0x002fe200078e0219ULL, 0x00005f0023137a11ULL, 0x000fe200028f4c26ULL,
0x0000001007027825ULL, 0x000fe200078e0008ULL, 0x000000001d00720cULL, 0x080fe40003fa6070ULL,
0x00005f0021157a11ULL, 0x000fe200030f4c24ULL, 0x00000010181d7824ULL, 0x000fe200078e0219ULL,
0x000000001f00720cULL, 0x000fe20003fc6070ULL, 0x0000001007087825ULL, 0x040fe200078e000aULL,
0x00000000021b7faeULL, 0x0003e6000c101c46ULL, 0x000000101a1f7824ULL, 0x000fe200078e0219ULL,
0x00000000081d7faeULL, 0x0003e2000c901c46ULL, 0x00000010070a7825ULL, 0x000fc800078e000cULL,
0x000000101c217824ULL, 0x000fe200078e0219ULL, 0x000000000a1f7faeULL, 0x0003e2000d901c46ULL,
0x00000010070c7825ULL, 0x000fc800078e000eULL, 0x000000101e237824ULL, 0x000fe200078e0219ULL,
0x000000000c217faeULL, 0x0003e2000d101c46ULL, 0x00000010070e7825ULL, 0x000fc800078e0010ULL,
0x0000001007107825ULL, 0x040fe200078e0012ULL, 0x000000000e237faeULL, 0x0003e6000e101c46ULL,
0x0000001022197824ULL, 0x000fe200078e0219ULL, 0x0000000010257faeULL, 0x0003e2000e901c46ULL,
0x0000001007127825ULL, 0x000fca00078e0014ULL, 0x0000000012197faeULL, 0x0003e2000f101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011604ULL,
0x00000008622b7824ULL, 0x000fc600078e00ffULL, 0x0000000400037810ULL, 0x042fe40007ffe0ffULL,
0x0000000800077810ULL, 0x040fe40007ffe0ffULL, 0x0000000c00097810ULL, 0x000fe20007ffe0ffULL,
0x00000008030b7824ULL, 0x040fe200078e00ffULL, 0x0000000403027212ULL, 0x080fe200078e3cffULL,
0x0000000807087824ULL, 0x040fe200078e00ffULL, 0x0000000407037212ULL, 0x080fe200078e3cffULL,
0x00000008090a7824ULL, 0x040fe200078e00ffULL, 0x0000000409077212ULL, 0x000fc400078e3cffULL,
0xfffffff8080f7812ULL, 0x000fe200078ee203ULL, 0x0000004005087824ULL, 0x000fe200078e0200ULL,
0x0000001000037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a117812ULL, 0x000fe400078ee207ULL,
0x0000000403077212ULL, 0x040fe200078e3cffULL, 0x00000008030e7824ULL, 0x000fe200078e00ffULL,
0x0000000821037210ULL, 0x000fe40007f1e0ffULL, 0x0000001400097810ULL, 0x000fc40007ffe0ffULL,
0x00000018000d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee202ULL, 0x0000000809237824ULL, 0x000fe200078e00ffULL,
0x00005e0003027a11ULL, 0x000fe200078048ffULL, 0x000000080d107824ULL, 0x000fe200078e00ffULL,
0x00000004090c7212ULL, 0x080fe400078e3cffULL, 0x000000040d097212ULL, 0x000fe400078e3cffULL,
0x00005f0003037a11ULL, 0x000fc400000f4c0aULL, 0x00000004080a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823237812ULL, 0x000fe400078ee20cULL, 0xfffffff810257812ULL, 0x000fe400078ee209ULL,
0xfffffff80e157812ULL, 0x000fe400078ee207ULL, 0x0000001c00097810ULL, 0x000fe40007ffe0ffULL,
0x00000008080c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c080e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000809277824ULL, 0x000fe200078e00ffULL, 0x0000001008127810ULL, 0x040fe40007ffe0ffULL,
0x0000001408147810ULL, 0x040fe40007ffe0ffULL, 0x0000001808187810ULL, 0x040fe40007ffe0ffULL,
0x0000000a210a7210ULL, 0x000fe40007fde0ffULL, 0x0000001c08087810ULL, 0x000fc40007ffe0ffULL,
0x0000000700077812ULL, 0x100fe400078e4804ULL, 0x0000000c210d7210ULL, 0x000fe40007fbe0ffULL,
0x00000004090c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00000008211a7210ULL, 0x000fe40007f5e0ffULL, 0x0000c00062007811ULL, 0x000fe400078e68ffULL,
0x0ffffff807077812ULL, 0x000fc400078ef804ULL, 0x0000000e21107210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200028e06ffULL, 0x00005e000a087a11ULL, 0x040fe200078c48ffULL,
0x0000001007197824ULL, 0x000fe200078e0200ULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x00005f000a097a11ULL, 0x000fe200030f4c09ULL,
0x000000100b1b7824ULL, 0x100fe200078e0200ULL, 0x0000001221137210ULL, 0x000fe20007f7e0ffULL,
0x000000100f1d7824ULL, 0x100fe200078e0200ULL, 0x00005e000d0a7a11ULL, 0x000fe200078a48ffULL,
0x00000010111f7824ULL, 0x100fe200078e0200ULL, 0x0000001421167210ULL, 0x000fe20007f1e0ffULL,
0x0000001023237824ULL, 0x100fe200078e0200ULL, 0x00005e00100c7a11ULL, 0x040fe200078848ffULL,
0x0000001025257824ULL, 0x100fe200078e0200ULL, 0x0000001821187210ULL, 0x000fe20007f3e0ffULL,
0x0000001015217824ULL, 0x000fe200078e0200ULL, 0x00005f000d0b7a11ULL, 0x000fe200028f4c0eULL,
0x0000001027297824ULL, 0x000fe200078e0200ULL, 0x00005f00100d7a11ULL, 0x000fe200020f4c07ULL,
0x000000ffff007224ULL, 0x000fe200018e06ffULL, 0xfffffff82b077812ULL, 0x000fe200078ee204ULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e00130e7a11ULL, 0x000fe200078648ffULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x00005e0016107a11ULL, 0x000fe200078048ffULL,
0x000000ffff277224ULL, 0x000fe200010e06ffULL, 0x00005e0018127a11ULL, 0x000fe200078248ffULL,
0x0000001007027825ULL, 0x000fe200078e0002ULL, 0x00005e001a147a11ULL, 0x000fc400078448ffULL,
0x00005f00130f7a11ULL, 0x000fe200018f4c00ULL, 0x0000001007087825ULL, 0x040fe200078e0008ULL,
0x00005f0016117a11ULL, 0x000fe200000f4c11ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002197faeULL, 0x0003e2000b901c46ULL, 0x00005f0018137a11ULL, 0x000fe200008f4c15ULL,
0x00000010070a7825ULL, 0x040fe200078e000aULL, 0x00005f001a157a11ULL, 0x000fe200010f4c27ULL,
0x00000000081b7faeULL, 0x0003e4000b901c46ULL, 0x00000010070c7825ULL, 0x040fe400078e000cULL,
0x000000000a1d7faeULL, 0x0003e4000b901c46ULL, 0x00000010070e7825ULL, 0x000fc400078e000eULL,
0x000000000c1f7faeULL, 0x0003e4000b901c46ULL, 0x0000001007107825ULL, 0x040fe400078e0010ULL,
0x000000000e217faeULL, 0x0003e4000b901c46ULL, 0x0000001007127825ULL, 0x040fe400078e0012ULL,
0x0000000010237faeULL, 0x0003e4000b901c46ULL, 0x0000001007147825ULL, 0x000fc400078e0014ULL,
0x0000000012257faeULL, 0x0003e8000b901c46ULL, 0x0000000014297faeULL, 0x0003e4000b901c46ULL,
0x000000176400720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff637424ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x000000ffff5f7224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000a51000000947ULL, 0x000fea0003800000ULL, 0x0000000206037824ULL, 0x000fe400078e00ffULL,
0x00006400ff5e7624ULL, 0x000fc400078e00ffULL, 0xff317217ff637424ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x00006400035e7624ULL, 0x000fe400078e025eULL,
0x0000010064037824ULL, 0x000fca00078e00ffULL, 0x000000600300720cULL, 0x000fda0003f06070ULL,
0x0000a45000000947ULL, 0x004fea0003800000ULL, 0x0000000164007810ULL, 0x000fe20007ffe0ffULL,
0x0000580065657a24ULL, 0x000fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000170000720cULL, 0x000fe20003f06070ULL, 0x0000004065657824ULL, 0x000fd800078e00ffULL,
0x0000073000008947ULL, 0x000fea0003800000ULL, 0x0000002064037811ULL, 0x000fe400078e40ffULL,
0x00000003ff0b7819ULL, 0x000fe40000011604ULL, 0x0000002005087811ULL, 0x000fe400078e30ffULL,
0x0000000360007217ULL, 0x000fe40007800000ULL, 0x000000040b157810ULL, 0x040fe20007ffe0ffULL,
0x000000010b027824ULL, 0x040fe200078e0208ULL, 0x000000080b1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a03ULL, 0x0000000415037212ULL, 0x040fe200078e3cffULL,
0x00000008150a7824ULL, 0x000fe200078e00ffULL, 0x0000000265027210ULL, 0x000fe20007f3e0ffULL,
0x000000081f0c7824ULL, 0x040fe200078e00ffULL, 0x000000041f097212ULL, 0x000fc400078e3cffULL,
0xfffffff80a1d7812ULL, 0x000fe200078ee203ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x0000000704037812ULL, 0x000fe400078ec0ffULL, 0x00005e0002067a11ULL, 0x000fe400078248ffULL,
0xfffffff80c217812ULL, 0x000fe200078ee209ULL, 0x0000000168137824ULL, 0x000fe200078e0203ULL,
0x00005f0002077a11ULL, 0x000fe200008f4c07ULL, 0x0000000115027824ULL, 0x000fe200078e0208ULL,
0x000000070b037812ULL, 0x000fc400078e4804ULL, 0x0000002000007817ULL, 0x000fe20003800000ULL,
0x0000001013067825ULL, 0x000fe200078e0006ULL, 0x0ffffff803097812ULL, 0x000fe400078ef804ULL,
0x0000000265037210ULL, 0x000fe40007f5e0ffULL, 0x000000000b00720cULL, 0x000fe40003f26070ULL,
0x0000d00062127811ULL, 0x000fe200078e68ffULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x00005e0003027a11ULL, 0x000fc400078448ffULL, 0x0000000c0b237810ULL, 0x000fe20007ffe0ffULL,
0x0000001009097824ULL, 0x000fe200078e0212ULL, 0x000000100b277810ULL, 0x040fe40007ffe0ffULL,
0x000000140b2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000823257824ULL, 0x000fe200078e00ffULL,
0x00005f0003037a11ULL, 0x000fe200010f4c0aULL, 0x000000011f0a7824ULL, 0x000fe200078e0208ULL,
0x00000004230c7212ULL, 0x080fe200078e3cffULL, 0x0000000827107824ULL, 0x040fe200078e00ffULL,
0x00000004270d7212ULL, 0x080fe200078e3cffULL, 0x000000082b2d7824ULL, 0x040fe200078e00ffULL,
0x000000042b0e7212ULL, 0x000fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c901c46ULL, 0x000000180b2f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x0000001c0b337810ULL, 0x000fc40007ffe0ffULL,
0x0000000a650a7210ULL, 0x000fe20007f5e0ffULL, 0x00000001230b7824ULL, 0x000fe200078e0208ULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x00000001270c7824ULL, 0x100fe200078e0208ULL,
0xfffffff810297812ULL, 0x000fe200078ee20dULL, 0x000000012b0d7824ULL, 0x000fe200078e0208ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x000000012f0e7824ULL, 0x100fe200078e0208ULL,
0x0000000b650b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff077224ULL, 0x002fe200010e06ffULL,
0x00005e000a067a11ULL, 0x040fe200078c48ffULL, 0x0000000133087824ULL, 0x000fe200078e0208ULL,
0x000000042f097212ULL, 0x040fe200078e3cffULL, 0x000000082f107824ULL, 0x000fe200078e00ffULL,
0x00005f000a077a11ULL, 0x000fe200030f4c07ULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x0000000865117210ULL, 0x000fe20007f5e0ffULL, 0x0000000833517824ULL, 0x000fe200078e00ffULL,
0x0000000c650c7210ULL, 0x000fc40007f3e0ffULL, 0x00005e000b087a11ULL, 0x000fe200078c48ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0xfffffff810317812ULL, 0x000fe400078ee209ULL,
0x0000000e650f7210ULL, 0x000fe40007fbe0ffULL, 0x000000001500720cULL, 0x000fe20003f66070ULL,
0x000000101d157824ULL, 0x000fe200078e0212ULL, 0x00005f000b097a11ULL, 0x000fe200030f4c0aULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x0000000d650d7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff167224ULL, 0x000fe200028e06ffULL, 0x00000004330e7212ULL, 0x000fe200078e3cffULL,
0x00000010251d7824ULL, 0x000fe200078e0212ULL, 0x00005e000c0a7a11ULL, 0x000fc400078c48ffULL,
0xfffffff851517812ULL, 0x000fe200078ee20eULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0x00005f000c0b7a11ULL, 0x000fe200030f4c0bULL, 0x0000000002157faeULL, 0x0003e2000d901c46ULL,
0x00005e000d0c7a11ULL, 0x000fe200078c48ffULL, 0x0000001051257824ULL, 0x100fe200078e0212ULL,
0x000000001f00720cULL, 0x000fe20003f26070ULL, 0x00000010291f7824ULL, 0x000fe200078e0212ULL,
0x00005f000d0d7a11ULL, 0x000fe400030f4c0eULL, 0x00005e000f0e7a11ULL, 0x000fc400078a48ffULL,
0x00005e0011107a11ULL, 0x000fe400078c48ffULL, 0x000000002300720cULL, 0x080fe20003f66070ULL,
0x0000001021157824ULL, 0x002fe200078e0212ULL, 0x000000002700720cULL, 0x080fe20003f86070ULL,
0x0000001013027825ULL, 0x000fe200078e0006ULL, 0x000000002b00720cULL, 0x080fe40003f46070ULL,
0x00005f000f0f7a11ULL, 0x000fe200028f4c16ULL, 0x0000001013067825ULL, 0x000fe200078e0008ULL,
0x000000002f00720cULL, 0x080fe20003fa6070ULL, 0x0000000002157faeULL, 0x0003e2000c901c46ULL,
0x00005f0011117a11ULL, 0x000fe200030f4c14ULL, 0x0000001013087825ULL, 0x000fe200078e000aULL,
0x000000003300720cULL, 0x000fe20003fc6070ULL, 0x00000000061d7faeULL, 0x0003e4000d901c46ULL,
0x000000102d217824ULL, 0x000fc400078e0212ULL, 0x00000010130a7825ULL, 0x000fe200078e000cULL,
0x00000000081f7faeULL, 0x0003e6000e101c46ULL, 0x0000001031237824ULL, 0x000fe200078e0212ULL,
0x000000000a217faeULL, 0x0003e2000d101c46ULL, 0x00000010130c7825ULL, 0x000fc800078e000eULL,
0x00000010130e7825ULL, 0x000fe200078e0010ULL, 0x000000000c237faeULL, 0x0003e8000e901c46ULL,
0x000000000e257faeULL, 0x0003e2000f101c46ULL, 0x0000066000007947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe40000011604ULL, 0x0000002005007811ULL, 0x000fe400078e30ffULL,
0x0000000409077810ULL, 0x000fc40007ffe0ffULL, 0x00000008090d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000407027212ULL, 0x0c0fe200078e3cffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0x0000000c090f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d0e7824ULL, 0x040fe200078e00ffULL,
0x000000040d037212ULL, 0x080fe400078e3cffULL, 0xfffffff80b0c7812ULL, 0x000fe200078ee202ULL,
0x0000000109027824ULL, 0x000fe200078e0200ULL, 0x000000040f067212ULL, 0x040fe200078e3cffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fc400078ee203ULL,
0x0000000265037210ULL, 0x000fe20007f3e0ffULL, 0x0000000107027824ULL, 0x000fe200078e0200ULL,
0xfffffff811127812ULL, 0x000fe400078ee206ULL, 0x0000001009117810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x0000001409137810ULL, 0x000fe40007ffe0ffULL,
0x00000002650a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000811167824ULL, 0x040fe200078e00ffULL,
0x0000000411077212ULL, 0x080fe200078e3cffULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0x00005e0003067a11ULL, 0x000fe200078248ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x0000000413107212ULL, 0x000fe200078e3cffULL, 0x0000000111147824ULL, 0x100fe200078e0200ULL,
0x00005e000a027a11ULL, 0x000fe200078448ffULL, 0x00000001131c7824ULL, 0x000fe200078e0200ULL,
0xfffffff816167812ULL, 0x000fc400078ee207ULL, 0x00005f0003077a11ULL, 0x000fe200008f4c08ULL,
0x000000010d087824ULL, 0x000fe200078e0200ULL, 0xfffffff8151e7812ULL, 0x000fe200078ee210ULL,
0x000000010f107824ULL, 0x100fe200078e0200ULL, 0x00005f000a037a11ULL, 0x000fe400010f4c0bULL,
0x00000018090b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c09157810ULL, 0x000fe40007ffe0ffULL,
0x00000008650a7210ULL, 0x000fe20007fde0ffULL, 0x000000010b207824ULL, 0x000fe200078e0200ULL,
0x0000000709097812ULL, 0x000fe200078e4804ULL, 0x0000000115227824ULL, 0x000fe200078e0200ULL,
0x000000040b007212ULL, 0x040fe200078e3cffULL, 0x000000080b0b7824ULL, 0x000fe200078e00ffULL,
0x0000001065107210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x0000001465147210ULL, 0x000fe20007f9e0ffULL, 0x0000000815247824ULL, 0x000fe200078e00ffULL,
0x0000001c651c7210ULL, 0x000fc40007f3e0ffULL, 0x0000002065207210ULL, 0x040fe40007f5e0ffULL,
0x00005e000a087a11ULL, 0x000fe400078c48ffULL, 0x0000002265657210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x00000004150f7212ULL, 0x000fe400078e3cffULL,
0xfffffff80b227812ULL, 0x000fe400078ee200ULL, 0x0ffffff809007812ULL, 0x000fc400078ef804ULL,
0x00005f000a097a11ULL, 0x000fe400030f4c0dULL, 0x0000d000620b7811ULL, 0x000fe400078e68ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x000000ffff0f7224ULL, 0x000fe200028e06ffULL,
0x00000007040d7812ULL, 0x000fe200078ec0ffULL, 0x00000010001d7824ULL, 0x100fe200078e020bULL,
0x00005e00100a7a11ULL, 0x000fe200078a48ffULL, 0x000000100c1f7824ULL, 0x100fe400078e020bULL,
0x000000100e217824ULL, 0x000fc400078e020bULL, 0x0000001012237824ULL, 0x100fe400078e020bULL,
0x0000001016257824ULL, 0x100fe400078e020bULL, 0x000000101e277824ULL, 0x100fe400078e020bULL,
0x0000001022297824ULL, 0x100fe400078e020bULL, 0x00000010242b7824ULL, 0x000fe200078e020bULL,
0x00005f00100b7a11ULL, 0x000fe200028f4c0fULL, 0x0000000168157824ULL, 0x000fe200078e020dULL,
0x00005e0020107a11ULL, 0x000fe200078448ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e06ffULL,
0x00005e00140c7a11ULL, 0x000fe200078848ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x00005e001c0e7a11ULL, 0x000fe200078248ffULL, 0x000000ffff007224ULL, 0x000fe200018e06ffULL,
0x00005e0065127a11ULL, 0x000fe200078648ffULL, 0x0000001015067825ULL, 0x000fe200078e0006ULL,
0x00005f00140d7a11ULL, 0x000fc400020f4c0dULL, 0x00005f001c0f7a11ULL, 0x000fe200008f4c0fULL,
0x0000001015027825ULL, 0x000fe200078e0002ULL, 0x00005f0020117a11ULL, 0x000fe200010f4c11ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000061d7faeULL, 0x0003e2000b901c46ULL,
0x00005f0065137a11ULL, 0x000fe200018f4c00ULL, 0x0000001015087825ULL, 0x040fe400078e0008ULL,
0x00000000021f7faeULL, 0x0003e4000b901c46ULL, 0x00000010150a7825ULL, 0x040fe400078e000aULL,
0x0000000008217faeULL, 0x0003e4000b901c46ULL, 0x00000010150c7825ULL, 0x000fc400078e000cULL,
0x000000000a237faeULL, 0x0003e4000b901c46ULL, 0x00000010150e7825ULL, 0x040fe400078e000eULL,
0x000000000c257faeULL, 0x0003e4000b901c46ULL, 0x0000001015107825ULL, 0x040fe400078e0010ULL,
0x000000000e277faeULL, 0x0003e4000b901c46ULL, 0x0000001015127825ULL, 0x000fc400078e0012ULL,
0x0000000010297faeULL, 0x0003e8000b901c46ULL, 0x00000000122b7faeULL, 0x0003e4000b901c46ULL,
0x00000004ff077424ULL, 0x002fe200078e00ffULL, 0x0000000366027812ULL, 0x000fe200078ec0ffULL,
0x00000300ff007624ULL, 0x000fe400078e00ffULL, 0xffffffffff657424ULL, 0x000fe200078e00ffULL,
0x000000030200780cULL, 0x000fe20003f25270ULL, 0xfffffffd07007424ULL, 0x000fca00078e0200ULL,
0x0000000100037807ULL, 0x000fca0004800000ULL, 0x0000000166667824ULL, 0x000fca00078e0203ULL,
0x000000616600720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x0000000166027824ULL, 0x000fc800078e025eULL, 0x0000600002027625ULL, 0x000fca00078e0007ULL,
0x0000000602657981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146080068027f8cULL, 0x002fe8000c80043fULL,
0x01460c0068077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007824803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x008fe20003800000ULL, 0x01460c0068077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007824803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010045d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fe20000011604ULL,
0xffffffffff0e7424ULL, 0x000fc600078e00ffULL, 0x000000705d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x000000015d5d7824ULL, 0x000fca00078e0200ULL,
0x014000005d007984ULL, 0x000e680000000800ULL, 0x014200005d027984ULL, 0x0007220000000800ULL,
0x000000630000720bULL, 0x002fe20003f3d000ULL, 0x00016c927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x008fc800008e0100ULL, 0x0000ffff03077812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff037424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000ff6200720cULL, 0x000fe40003f25270ULL,
0x000000630000720bULL, 0x000fe20003f54000ULL, 0x00016c627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x000fe400010e0100ULL, 0x00000000630a7209ULL, 0x000fe40007810000ULL,
0x0000ffff03087812ULL, 0x000fe400078e3cffULL, 0x00000002ff037819ULL, 0x000fe20000011604ULL,
0x8000000a63067221ULL, 0x000fe20000010000ULL, 0x0144000a5d009388ULL, 0x0003e20000000800ULL,
0x0000000807ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL,
0x00000006002d7308ULL, 0x0002e20000000800ULL, 0x00016c127f007947ULL, 0x000fec000b800000ULL,
0x00001f032d067589ULL, 0x00a2e400000e0000ULL, 0x0000000803037810ULL, 0x002fe20007ffe0ffULL,
0x00016c527f007947ULL, 0x000fea000b800000ULL, 0x00001f032d037589ULL, 0x0002a400000e0000ULL,
0x8000000a00001221ULL, 0x100fe20000010000ULL, 0x000000031b1b7220ULL, 0x084fe20000410000ULL,
0x000000031a1a7220ULL, 0x080fe20000410000ULL, 0x0000000337377220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b00001820ULL, 0x000fe20000410000ULL, 0x0000000336367220ULL, 0x080fe20000410000ULL,
0x000000034b4b7220ULL, 0x080fe20000410000ULL, 0x000000034a4a7220ULL, 0x080fe20000410000ULL,
0x00000000005c1308ULL, 0x000ea20000000800ULL, 0x000000034f4f7220ULL, 0x080fe20000410000ULL,
0x000000034e4e7220ULL, 0x080fe20000410000ULL, 0x0000000347477220ULL, 0x080fe20000410000ULL,
0x0000000346467220ULL, 0x080fe20000410000ULL, 0x0000000343437220ULL, 0x080fe20000410000ULL,
0x0000000342427220ULL, 0x080fe20000410000ULL, 0x000000033f3f7220ULL, 0x080fe20000410000ULL,
0x000000033e3e7220ULL, 0x080fe20000410000ULL, 0x000000033b3b7220ULL, 0x080fe20000410000ULL,
0x000000033a3a7220ULL, 0x000fe20000410000ULL, 0x0000002d5f5f7220ULL, 0x000fe20000410000ULL,
0x00000001ff037807ULL, 0x000fe20000800000ULL, 0x0000000619197220ULL, 0x088fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000649497220ULL, 0x080fe20000410000ULL,
0x0000000648487220ULL, 0x080fe20000410000ULL, 0x000000064d4d7220ULL, 0x080fe20000410000ULL,
0x000000064c4c7220ULL, 0x080fe20000410000ULL, 0x0000000645457220ULL, 0x080fe20000410000ULL,
0x0000000644447220ULL, 0x080fe20000410000ULL, 0x0000000641417220ULL, 0x080fe20000410000ULL,
0x0000000640407220ULL, 0x080fe20000410000ULL, 0x000000063d3d7220ULL, 0x080fe20000410000ULL,
0x000000063c3c7220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x000fe20000410000ULL, 0x000000ffff637224ULL, 0x000fe200078e000aULL,
0x0000005c02021220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000005cff00723eULL, 0x000fe200000010ffULL, 0x0000005f025f7221ULL, 0x010fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff147819ULL, 0x000fe40000011604ULL,
0x00005410002d7816ULL, 0x002fe20000000000ULL, 0x000169d27f007947ULL, 0x000fea000b800000ULL,
0x0000000814167810ULL, 0x000fe20007ffe0ffULL, 0x00001f142d717589ULL, 0x0002e800000e0000ULL,
0x00001f162d6a7589ULL, 0x00032400000e0000ULL, 0x0000001014157810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e0015ULL,
0x00002be000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0001769000007944ULL, 0x03cfea0003c00000ULL,
0x0000001814147810ULL, 0x002fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0014ULL, 0x00002c5000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0001762000007944ULL, 0x03cfea0003c00000ULL, 0x00000007040d7812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff077819ULL, 0x100fe40000011604ULL,
0x000000080d6c7812ULL, 0x000fe400078ef804ULL, 0x0000000804097812ULL, 0x000fc400078ec0ffULL,
0x00000007070f7812ULL, 0x000fca00078e786cULL, 0x000000086c0f7824ULL, 0x000fca00078e020fULL,
0x0000a0000f2c7811ULL, 0x000fca00078e20ffULL, 0x0000000709007812ULL, 0x140fe200078ef804ULL,
0x000000002c2c783bULL, 0x002e620000000200ULL, 0x0000000709027812ULL, 0x000fe200078ec804ULL,
0x0000580065747a24ULL, 0x020fe200078e02ffULL, 0x00000004070b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000207097810ULL, 0x040fe20007ffe0ffULL, 0x0000004074747824ULL, 0x000fe200078e00ffULL,
0x0000000607117810ULL, 0x000fe40007ffe0ffULL, 0x00000007026b7212ULL, 0x000fc400078e3cffULL,
0x0000000b02697212ULL, 0x040fe400078e3cffULL, 0x0000000902737212ULL, 0x000fe200078e3cffULL,
0x0000000800777824ULL, 0x000fe200078e026bULL, 0x0000001102677212ULL, 0x000fe200078e3cffULL,
0x0000000800757824ULL, 0x000fe200078e0269ULL, 0x0000c000620c7811ULL, 0x000fe200078e68ffULL,
0x00000008006f7824ULL, 0x040fe200078e0273ULL, 0x0000000709077812ULL, 0x000fe200078e786cULL,
0x00000008006d7824ULL, 0x040fe200078e0267ULL, 0x0000008000007811ULL, 0x000fe200078e18ffULL,
0x00000010770b7824ULL, 0x100fe200078e020cULL, 0x0000991003027816ULL, 0x000fe200000000ffULL,
0x0000001075097824ULL, 0x000fc400078e020cULL, 0x000000106f0a7824ULL, 0x100fe200078e020cULL,
0x000000000b58783bULL, 0x000f220000004200ULL, 0x000000106d087824ULL, 0x000fe200078e020cULL,
0x000000ff0200720cULL, 0x000fe20003f25270ULL, 0x000000086c077824ULL, 0x000fe200078e0207ULL,
0x000000000950783bULL, 0x000ee20000004200ULL, 0x000000016b6b7824ULL, 0x100fe400078e0200ULL,
0x0000000169697824ULL, 0x100fe200078e0200ULL, 0x000000000a54783bULL, 0x000fe20000004200ULL,
0x0000a00007107811ULL, 0x000fe200078e20ffULL, 0x0000000173737824ULL, 0x000fc400078e0200ULL,
0x000000000830783bULL, 0x000fe20000004200ULL, 0x0000000167677824ULL, 0x000fe400078e0200ULL,
0x000000106b067824ULL, 0x100fe200078e020cULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x0000001069027824ULL, 0x100fe200078e020cULL, 0x000000712c2c9231ULL, 0x08afe200003400ffULL,
0x0000001073037824ULL, 0x100fe200078e020cULL, 0x000000000628783bULL, 0x004e620000004200ULL,
0x0000001067007824ULL, 0x000fe200078e020cULL, 0x000000712e2e9231ULL, 0x000fc400003400ffULL,
0x000000000220783bULL, 0x000ea20000004200ULL, 0x0000006a2d2d9231ULL, 0x090fe400003400ffULL,
0x0000006a2f2f9231ULL, 0x000fe200003400ffULL, 0x000000000324783bULL, 0x000ee80000004200ULL,
0x00000000001c783bULL, 0x000f240000004200ULL, 0x000000582c38723cULL, 0x040ff00000041838ULL,
0x0000005a2c3c723cULL, 0x040ff0000004183cULL, 0x000000502c4c723cULL, 0x000fe2000004184cULL,
0x0000007110109231ULL, 0x000fc400003400ffULL, 0x0000007112129231ULL, 0x000fe400003400ffULL,
0x0000006a11119231ULL, 0x080fe400003400ffULL, 0x0000006a13139231ULL, 0x000fe200003400ffULL,
0x000000542c40723cULL, 0x040ff00000041840ULL, 0x000000562c44723cULL, 0x040ff00000041844ULL,
0x000000522c48723cULL, 0x040ff00000041848ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x000000281038723cULL, 0x042ff00000041838ULL,
0x0000002a103c723cULL, 0x040ff0000004183cULL, 0x00000020104c723cULL, 0x044ff0000004184cULL,
0x000000241040723cULL, 0x048ff00000041840ULL, 0x000000261044723cULL, 0x040ff00000041844ULL,
0x000000221020723cULL, 0x040ff00000041848ULL, 0x0000001c1034723cULL, 0x050ff00000041834ULL,
0x0000001e1028723cULL, 0x000fe20000041818ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1f7819ULL, 0x000fe40000011604ULL,
0x0000004064117811ULL, 0x000fe400078e40ffULL, 0x000000041f197810ULL, 0x000fe20007ffe0ffULL,
0x0000004005257824ULL, 0x000fe200078e021fULL, 0x000000081f277810ULL, 0x040fe40007ffe0ffULL,
0x000000101f4b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000819317824ULL, 0x040fe200078e00ffULL,
0x0000000419127212ULL, 0x080fe200078e3cffULL, 0x0000000827187824ULL, 0x000fe200078e00ffULL,
0x0000001160107217ULL, 0x000fe20007800000ULL, 0x000000084b517824ULL, 0x000fe200078e00ffULL,
0x0000000427137212ULL, 0x000fc400078e3cffULL, 0x0000000c1f2d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0xfffffff831317812ULL, 0x000fe400078ee212ULL,
0x000000141f537810ULL, 0x000fe40007ffe0ffULL, 0xfffffff818337812ULL, 0x000fe200078ee213ULL,
0x000000082d187824ULL, 0x000fe200078e00ffULL, 0x000000044b127212ULL, 0x080fe200078e3cffULL,
0x00000008531a7824ULL, 0x000fe200078e00ffULL, 0x000000042d117212ULL, 0x000fe200078e3cffULL,
0x0000001031317824ULL, 0x000fe200078e020cULL, 0xfffffff851517812ULL, 0x000fe200078ee212ULL,
0x0000001033337824ULL, 0x000fe200078e020cULL, 0x0000001c1f717810ULL, 0x000fc40007ffe0ffULL,
0x0000000453137212ULL, 0x000fe200078e3cffULL, 0x0000001051517824ULL, 0x100fe200078e020cULL,
0x0000007425127210ULL, 0x000fe20007f5e0ffULL, 0x00000008711c7824ULL, 0x000fe200078e00ffULL,
0xfffffff818497812ULL, 0x000fe400078ee211ULL, 0x0000000425117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81a557812ULL, 0x000fe200078ee213ULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00000004711b7212ULL, 0x000fe200078e3cffULL, 0x0000001049497824ULL, 0x100fe200078e020cULL,
0x00005e00121a7a11ULL, 0x000fe200078448ffULL, 0x0000001055557824ULL, 0x000fe200078e020cULL,
0x0000007411117210ULL, 0x000fc40007f7e0ffULL, 0xfffffff81c797812ULL, 0x000fe400078ee21bULL,
0x000000181f577810ULL, 0x000fe40007ffe0ffULL, 0x00005f00121b7a11ULL, 0x000fe200010f4c13ULL,
0x0000001079797824ULL, 0x000fe200078e020cULL, 0x0000002010267817ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x0000000825137810ULL, 0x000fe20007ffe0ffULL,
0x00000008575b7824ULL, 0x000fe200078e00ffULL, 0x00005e00111c7a11ULL, 0x000fc400078448ffULL,
0x0000000c252f7810ULL, 0x000fe40007ffe0ffULL, 0x0000007413137210ULL, 0x000fe40007f9e0ffULL,
0x0000000457187212ULL, 0x000fe400078e3cffULL, 0x00005f00111d7a11ULL, 0x000fe200010f4c10ULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x000000742f117210ULL, 0x000fe40007fbe0ffULL,
0xfffffff85b5b7812ULL, 0x000fc400078ee218ULL, 0x00005e0013187a11ULL, 0x000fe200078448ffULL,
0x000000ffff127224ULL, 0x000fe200028e06ffULL, 0x00000010252f7810ULL, 0x000fe20007ffe0ffULL,
0x000000105b5b7824ULL, 0x000fe200078e020cULL, 0x00005e0011107a11ULL, 0x000fe400078848ffULL,
0x000000261900720cULL, 0x000fe40003f66070ULL, 0x00005f0013197a11ULL, 0x000fe400010f4c1eULL,
0x000000742f137210ULL, 0x000fc40007f5e0ffULL, 0x00005f0011117a11ULL, 0x000fe400020f4c12ULL,
0x000000261f00720cULL, 0x0c0fe20003f86070ULL, 0x000000ffff1e7224ULL, 0x000fe200010e06ffULL,
0x000000071f1f7812ULL, 0x000fe400078e4804ULL, 0x000000262700720cULL, 0x080fe40003fa6070ULL,
0x00005e0013127a11ULL, 0x000fe400078c48ffULL, 0x000000262d00720cULL, 0x000fe20003f46070ULL,
0x00000001682d7824ULL, 0x000fe200078e020dULL, 0x00000014252f7810ULL, 0x000fc40007ffe0ffULL,
0x0ffffff81f277812ULL, 0x000fe200078ef804ULL, 0x000000102d1a7825ULL, 0x000fe200078e001aULL,
0x00005f0013137a11ULL, 0x000fe400030f4c1eULL, 0x000000742f1f7210ULL, 0x080fe20007fde0ffULL,
0x00000010272f7824ULL, 0x000fe200078e020cULL, 0x0000001825597810ULL, 0x000fe20007ffe0ffULL,
0x000000102d1c7825ULL, 0x000fe200078e001cULL, 0x0000001c25277810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a2f7faeULL, 0x0003e2000e101c46ULL,
0x000000ffff247224ULL, 0x000fe200030e06ffULL, 0x0000007459257210ULL, 0x080fe20007f9e0ffULL,
0x000000102d187825ULL, 0x000fe200078e0018ULL, 0x00005e001f1e7a11ULL, 0x000fe200078c48ffULL,
0x000000001c317faeULL, 0x0005e2000d901c46ULL, 0x0000007427277210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x00005f001f1f7a11ULL, 0x000fe200030f4c24ULL,
0x0000000018337faeULL, 0x0005e2000e901c46ULL, 0x00005e0025247a11ULL, 0x000fe200078c48ffULL,
0x000000102d107825ULL, 0x000fe200078e0010ULL, 0x000000264b00720cULL, 0x000fc40003f86070ULL,
0x00005f0025257a11ULL, 0x000fe200030f4c2cULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00005e00271a7a11ULL, 0x002fe200078648ffULL, 0x000000102d127825ULL, 0x000fe200078e0012ULL,
0x000000265300720cULL, 0x080fe20003fc6070ULL, 0x0000000010497faeULL, 0x0005e2000d101c46ULL,
0x000000265700720cULL, 0x080fe20003fa6070ULL, 0x000000102d1e7825ULL, 0x000fe200078e001eULL,
0x00005f00271b7a11ULL, 0x000fe400018f4c2cULL, 0x000000267100720cULL, 0x000fe20003f66070ULL,
0x000000102d247825ULL, 0x040fe200078e0024ULL, 0x0000000012517faeULL, 0x0005e6000e101c46ULL,
0x000000102d1a7825ULL, 0x000fc400078e001aULL, 0x000000001e557faeULL, 0x0005e8000f101c46ULL,
0x00000000245b7faeULL, 0x0005e8000e901c46ULL, 0x000000001a797faeULL, 0x0005e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x000fe20000011604ULL,
0x00000001682d7824ULL, 0x000fc600078e020dULL, 0x0000000413117810ULL, 0x040fe40007ffe0ffULL,
0x0000000813197810ULL, 0x000fe40007ffe0ffULL, 0x0000000411107212ULL, 0x0c0fe200078e3cffULL,
0x0000000811317824ULL, 0x000fe200078e00ffULL, 0x0000000c131b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0x00000010131d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000419117212ULL, 0x080fe200078e3cffULL, 0x000000081b497824ULL, 0x000fe200078e00ffULL,
0x000000041d187212ULL, 0x040fe200078e3cffULL, 0x000000081d4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a337812ULL, 0x000fe200078ee211ULL, 0x00000040051d7824ULL, 0x000fe200078e0213ULL,
0x0000001413117810ULL, 0x000fc40007ffe0ffULL, 0x0000001813197810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e020cULL, 0x000000041b127212ULL, 0x080fe200078e3cffULL,
0x0000000811517824ULL, 0x000fe200078e00ffULL, 0x0000001c131b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819557824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe400078ee210ULL,
0xfffffff849497812ULL, 0x000fe200078ee212ULL, 0x000000081b597824ULL, 0x000fe200078e00ffULL,
0x0000000411107212ULL, 0x080fe200078e3cffULL, 0x0000001031317824ULL, 0x000fe200078e020cULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee218ULL, 0x0000001049497824ULL, 0x000fe200078e020cULL,
0x0000000419127212ULL, 0x000fc400078e3cffULL, 0x000000741d117210ULL, 0x000fe20007f5e0ffULL,
0x000000104b4b7824ULL, 0x000fe200078e020cULL, 0x000000041b187212ULL, 0x000fe400078e3cffULL,
0x000000041d197810ULL, 0x040fe40007ffe0ffULL, 0x000000081d1b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c1d1f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff855557812ULL, 0x000fe200078ee212ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0xfffffff851517812ULL, 0x000fc400078ee210ULL,
0x0000007419197210ULL, 0x080fe20007f7e0ffULL, 0x0000001055557824ULL, 0x100fe200078e020cULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x0000001051517824ULL, 0x000fe200078e020cULL,
0x000000741b1e7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x000000741f247210ULL, 0x000fe40007fbe0ffULL, 0x00005f0011117a11ULL, 0x000fe200010f4c12ULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0xfffffff859597812ULL, 0x000fe200078ee218ULL,
0x000000ffff277224ULL, 0x000fe200028e06ffULL, 0x00005e00191a7a11ULL, 0x000fe200078448ffULL,
0x000000102d107825ULL, 0x000fe200078e0010ULL, 0x00005e001e187a11ULL, 0x000fc400078648ffULL,
0x00005e0024127a11ULL, 0x000fe200078848ffULL, 0x0000001059597824ULL, 0x000fe200078e020cULL,
0x00005f00191b7a11ULL, 0x000fe400010f4c1cULL, 0x00000007131f7812ULL, 0x000fe400078e4804ULL,
0x00005f001e197a11ULL, 0x000fe200018f4c25ULL, 0x000000102d1a7825ULL, 0x000fe200078e001aULL,
0x00005f0024137a11ULL, 0x000fe400020f4c27ULL, 0x000000101d257810ULL, 0x000fe20007ffe0ffULL,
0x000000102d187825ULL, 0x000fe200078e0018ULL, 0x000000141d277810ULL, 0x000fc40007ffe0ffULL,
0x000000181d537810ULL, 0x000fe20007ffe0ffULL, 0x000000102d127825ULL, 0x000fe200078e0012ULL,
0x0000001c1d577810ULL, 0x000fe40007ffe0ffULL, 0x0000007425257210ULL, 0x080fe40007f9e0ffULL,
0x00000074271d7210ULL, 0x080fe40007fbe0ffULL, 0x0000007453537210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x0000007457577210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x0ffffff81f1f7812ULL, 0x000fe200078ef804ULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e0025267a11ULL, 0x000fe200078848ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x00005e001d247a11ULL, 0x000fe200078a48ffULL,
0x000000101f2f7824ULL, 0x000fe200078e020cULL, 0x00005e00531e7a11ULL, 0x000fc400078448ffULL,
0x00005e00571c7a11ULL, 0x000fe400078648ffULL, 0x00005f0025277a11ULL, 0x000fe200020f4c2cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102f7faeULL, 0x0003e2000b901c46ULL,
0x00005f001d257a11ULL, 0x000fe400028f4c2eULL, 0x00005f00531f7a11ULL, 0x000fe200010f4c30ULL,
0x000000102d267825ULL, 0x000fe200078e0026ULL, 0x00005f00571d7a11ULL, 0x000fe200018f4c32ULL,
0x000000001a317faeULL, 0x0003e4000b901c46ULL, 0x000000102d247825ULL, 0x000fc400078e0024ULL,
0x0000000018337faeULL, 0x0003e4000b901c46ULL, 0x000000102d1e7825ULL, 0x040fe400078e001eULL,
0x0000000012497faeULL, 0x0003e4000b901c46ULL, 0x000000102d1c7825ULL, 0x000fe400078e001cULL,
0x00000000264b7faeULL, 0x0003e8000b901c46ULL, 0x0000000024517faeULL, 0x0003e8000b901c46ULL,
0x000000001e557faeULL, 0x0003e8000b901c46ULL, 0x000000001c597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000404117811ULL, 0x006fc400078fe0ffULL,
0x000010000c727810ULL, 0x000fe40007ffe0ffULL, 0x0000000711117812ULL, 0x000fe400078e786cULL,
0x00000002ff107819ULL, 0x000fe20000011604ULL, 0x00000010756e7824ULL, 0x100fe400078e0272ULL,
0x000000086c717824ULL, 0x000fe200078e0211ULL, 0x0000000604117811ULL, 0x000fe200078fe0ffULL,
0x0000001077707824ULL, 0x100fe400078e0272ULL, 0x000000106f6f7824ULL, 0x100fe200078e0272ULL,
0x0000a000712c7811ULL, 0x000fe200078e20ffULL, 0x000000106d6d7824ULL, 0x000fe200078e0272ULL,
0x0000000711117812ULL, 0x000fe200078e786cULL, 0x0000001069697824ULL, 0x000fc400078e0272ULL,
0x000000106b6b7824ULL, 0x000fe400078e0272ULL, 0x000000086c6c7824ULL, 0x000fe200078e0211ULL,
0x0000005cff11723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002c2c783bULL, 0x000fe20000000200ULL, 0x0000541011777816ULL, 0x000fe20000000011ULL,
0x00000010736a7824ULL, 0x100fe200078e0272ULL, 0x0000a0006c187811ULL, 0x000fe200078e20ffULL,
0x000000006e50783bULL, 0x000fe20000004200ULL, 0x0000001067677824ULL, 0x000fc600078e0272ULL,
0x000000007058783bULL, 0x000fe80000004200ULL, 0x000000006f54783bULL, 0x000fe80000004200ULL,
0x000000006d30783bULL, 0x000fe80000004200ULL, 0x00001f1077757589ULL, 0x000e6800000e0000ULL,
0x00001f1677767589ULL, 0x000ea800000e0000ULL, 0x000000001818783bULL, 0x000ee80000000200ULL,
0x000000006948783bULL, 0x000f280000004200ULL, 0x000000006b24783bULL, 0x000f680000004200ULL,
0x000000006a1c783bULL, 0x000f280000004200ULL, 0x000000006710783bULL, 0x000f220000004200ULL,
0x000000752c2c9231ULL, 0x002fc400003400ffULL, 0x000000752e2e9231ULL, 0x000fe400003400ffULL,
0x000000762d2d9231ULL, 0x084fe400003400ffULL, 0x000000762f2f9231ULL, 0x000fce00003400ffULL,
0x000000502c4c723cULL, 0x040ff0000004184cULL, 0x000000582c38723cULL, 0x000fe20000041838ULL,
0x0000007518189231ULL, 0x088fe400003400ffULL, 0x000000751a1a9231ULL, 0x000fc400003400ffULL,
0x0000007619199231ULL, 0x000fc600003400ffULL, 0x0000005a2c3c723cULL, 0x000fe2000004183cULL,
0x000000761b1b9231ULL, 0x000fce00003400ffULL, 0x000000542c40723cULL, 0x040ff00000041840ULL,
0x000000562c44723cULL, 0x040ff00000041844ULL, 0x000000522c20723cULL, 0x040ff00000041820ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c28723cULL, 0x000ff00000041828ULL,
0x00000048184c723cULL, 0x050ff0000004184cULL, 0x000000241838723cULL, 0x060ff00000041838ULL,
0x00000026183c723cULL, 0x040ff0000004183cULL, 0x0000001c1840723cULL, 0x040ff00000041840ULL,
0x0000001e1844723cULL, 0x040ff00000041844ULL, 0x0000004a1848723cULL, 0x040ff00000041820ULL,
0x000000101834723cULL, 0x040ff00000041834ULL, 0x000000121818723cULL, 0x000fe20000041828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000004064117811ULL, 0x000fe200078e40ffULL,
0x01468800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000601100720cULL, 0x000fda0003f26070ULL,
0x0000781000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1f7819ULL, 0x000fe20000011604ULL,
0x0000000168297824ULL, 0x000fe200078e020dULL, 0x00000020051e7811ULL, 0x000fe400078e30ffULL,
0x0000006064117811ULL, 0x000fe400078e40ffULL, 0x000000041f217810ULL, 0x040fe20007ffe0ffULL,
0x000000011f137824ULL, 0x000fe200078e021eULL, 0x0000001160127217ULL, 0x000fe40007800000ULL,
0x00000004211d7212ULL, 0x040fe200078e3cffULL, 0x0000000821227824ULL, 0x000fe200078e00ffULL,
0x0000007413137210ULL, 0x000fe20007f3e0ffULL, 0x0000000112127824ULL, 0x000fe200078e0a11ULL,
0x000000141f537810ULL, 0x000fc40007ffe0ffULL, 0xfffffff822277812ULL, 0x000fe200078ee21dULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x00005e0013107a11ULL, 0x000fe200078248ffULL,
0x0000000853247824ULL, 0x040fe200078e00ffULL, 0x0000002012267817ULL, 0x000fe20003800000ULL,
0x0000000153557824ULL, 0x000fe200078e021eULL, 0x00005f0013117a11ULL, 0x000fe200008f4c1cULL,
0x0000001027277824ULL, 0x000fe200078e0272ULL, 0x000000071f137812ULL, 0x040fe400078e4804ULL,
0x000000081f2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001029107825ULL, 0x000fe200078e0010ULL,
0x0ffffff8131d7812ULL, 0x000fc400078ef804ULL, 0x000000261f00720cULL, 0x000fe20003f26070ULL,
0x0000000121137824ULL, 0x000fe200078e021eULL, 0x0000000c1f2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0272ULL, 0x000000101f337810ULL, 0x000fe20007ffe0ffULL,
0x000000082b2d7824ULL, 0x000fe200078e00ffULL, 0x0000007413137210ULL, 0x000fe20007f5e0ffULL,
0x000000082f317824ULL, 0x000fe200078e00ffULL, 0x000000181f597810ULL, 0x000fe20007ffe0ffULL,
0x0000000133257824ULL, 0x100fe200078e021eULL, 0x0000001c1f657810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x0000000453237212ULL, 0x000fe200078e3cffULL,
0x000000012b1f7824ULL, 0x100fe200078e021eULL, 0x00005e0013127a11ULL, 0x000fe200078448ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0003e2000c901c46ULL,
0xfffffff824577812ULL, 0x000fe200078ee223ULL, 0x000000012f237824ULL, 0x000fe200078e021eULL,
0x00005f0013137a11ULL, 0x000fe200010f4c1cULL, 0x00000001595b7824ULL, 0x100fe200078e021eULL,
0x000000741f1c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000165737824ULL, 0x000fe200078e021eULL,
0x000000042b207212ULL, 0x000fe200078e3cffULL, 0x0000000833517824ULL, 0x000fe200078e00ffULL,
0x00000074231e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000865247824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee220ULL, 0x000000ffff117224ULL, 0x002fe200010e06ffULL,
0x00005e001c107a11ULL, 0x000fe200078c48ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x000000042f207212ULL, 0x000fc400078e3cffULL, 0x0000000433227212ULL, 0x000fe400078e3cffULL,
0x00000074251f7210ULL, 0x000fe40007f3e0ffULL, 0x00005f001c117a11ULL, 0x000fe400030f4c11ULL,
0x0000000465237212ULL, 0x000fe400078e3cffULL, 0xfffffff831317812ULL, 0x000fe200078ee220ULL,
0x0000001029107825ULL, 0x000fe200078e0010ULL, 0x00005e001e1c7a11ULL, 0x000fc400078c48ffULL,
0x0000007455207210ULL, 0x080fe20007f9e0ffULL, 0x0000000859557824ULL, 0x000fe200078e00ffULL,
0xfffffff851517812ULL, 0x000fe400078ee222ULL, 0x000000745b257210ULL, 0x000fe40007fbe0ffULL,
0x000000262100720cULL, 0x000fe40003f66070ULL, 0x0000000459227212ULL, 0x000fe200078e3cffULL,
0x000000ffff287224ULL, 0x000fe200028e06ffULL, 0xfffffff8245b7812ULL, 0x000fe200078ee223ULL,
0x000000ffff247224ULL, 0x000fe200008e06ffULL, 0x00005f001e1d7a11ULL, 0x000fc400030f4c1dULL,
0x00005e001f1e7a11ULL, 0x000fe400078c48ffULL, 0xfffffff855557812ULL, 0x000fe200078ee222ULL,
0x0000001029227825ULL, 0x000fe200078e0012ULL, 0x0000007473747210ULL, 0x000fe40007f5e0ffULL,
0x00005f001f1f7a11ULL, 0x000fe200030f4c24ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x00005e0020127a11ULL, 0x040fe200078c48ffULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078a48ffULL, 0x0000000022277faeULL, 0x0003e2000d901c46ULL,
0x00005f0020137a11ULL, 0x000fe200030f4c13ULL, 0x00000010291c7825ULL, 0x000fe200078e001cULL,
0x000000262b00720cULL, 0x000fc40003f26070ULL, 0x00005e0074207a11ULL, 0x040fe200078c48ffULL,
0x00000010291e7825ULL, 0x000fe200078e001eULL, 0x000000262f00720cULL, 0x080fe40003f66070ULL,
0x000000263300720cULL, 0x080fe20003f86070ULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x000000265300720cULL, 0x080fe40003f46070ULL, 0x00005f0025257a11ULL, 0x000fe200028f4c28ULL,
0x000000102d237824ULL, 0x102fe200078e0272ULL, 0x000000265900720cULL, 0x080fe20003fa6070ULL,
0x0000001031277824ULL, 0x000fe200078e0272ULL, 0x00005f0074217a11ULL, 0x000fe200030f4c21ULL,
0x0000001029247825ULL, 0x000fe200078e0024ULL, 0x000000266500720cULL, 0x000fe20003fc6070ULL,
0x0000000010237faeULL, 0x0003e4000c901c46ULL, 0x0000001029207825ULL, 0x000fc400078e0020ULL,
0x000000001c277faeULL, 0x0003e4000d901c46ULL, 0x0000001051297824ULL, 0x100fe400078e0272ULL,
0x00000010572b7824ULL, 0x100fe400078e0272ULL, 0x00000010552d7824ULL, 0x100fe200078e0272ULL,
0x000000001e297faeULL, 0x0003e2000e101c46ULL, 0x000000105b2f7824ULL, 0x000fc600078e0272ULL,
0x00000000122b7faeULL, 0x0003e8000d101c46ULL, 0x00000000242d7faeULL, 0x0003e8000e901c46ULL,
0x00000000202f7faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe40000011604ULL, 0x00000020051c7811ULL, 0x000fc400078e30ffULL,
0x000000081f217810ULL, 0x040fe40007ffe0ffULL, 0x000000041f137810ULL, 0x000fe40007ffe0ffULL,
0x0000000421117212ULL, 0x0c0fe200078e3cffULL, 0x00000008211e7824ULL, 0x000fe200078e00ffULL,
0x0000000c1f237810ULL, 0x000fe20007ffe0ffULL, 0x00000008132d7824ULL, 0x040fe200078e00ffULL,
0x0000000413107212ULL, 0x0c0fe200078e3cffULL, 0x0000000113137824ULL, 0x100fe200078e021cULL,
0xfffffff81e2f7812ULL, 0x000fe200078ee211ULL, 0x000000011f117824ULL, 0x100fe200078e021cULL,
0x0000000423127212ULL, 0x040fe200078e3cffULL, 0x0000000823317824ULL, 0x000fe200078e00ffULL,
0x00000074131d7210ULL, 0x080fe20007f5e0ffULL, 0x0000000121217824ULL, 0x100fe200078e021cULL,
0x0000007411117210ULL, 0x000fe20007f3e0ffULL, 0x0000000123237824ULL, 0x000fe200078e021cULL,
0xfffffff831317812ULL, 0x000fe200078ee212ULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x00005e0011127a11ULL, 0x000fe200078248ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0272ULL,
0x000000101f257810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0272ULL,
0x000000141f277810ULL, 0x000fe20007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e0272ULL,
0x00005e001d107a11ULL, 0x000fe200078448ffULL, 0x0000000825337824ULL, 0x000fe200078e00ffULL,
0x000000181f297810ULL, 0x000fe20007ffe0ffULL, 0x0000000827517824ULL, 0x000fe200078e00ffULL,
0x0000001c1f2b7810ULL, 0x000fc40007ffe0ffULL, 0x0000007421217210ULL, 0x000fe40007f7e0ffULL,
0x00005f0011137a11ULL, 0x000fe200008f4c1eULL, 0x000000012b537824ULL, 0x000fe200078e021cULL,
0x00005f001d117a11ULL, 0x000fe200010f4c20ULL, 0x00000001291d7824ULL, 0x100fe200078e021cULL,
0x0000000425227212ULL, 0x0c0fe200078e3cffULL, 0x0000000125257824ULL, 0x100fe200078e021cULL,
0x0000000427247212ULL, 0x040fe200078e3cffULL, 0x0000000127277824ULL, 0x000fe200078e021cULL,
0x00005e00211c7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0xfffffff851517812ULL, 0x000fe200078ee224ULL, 0x0000000829247824ULL, 0x000fe200078e00ffULL,
0x000000741d2c7210ULL, 0x000fe20007f9e0ffULL, 0x000000082b577824ULL, 0x000fe200078e00ffULL,
0x00005f00211d7a11ULL, 0x000fe200030f4c1eULL, 0x0000001051517824ULL, 0x000fe200078e0272ULL,
0x0000000429217212ULL, 0x000fe200078e3cffULL, 0x0000000168297824ULL, 0x000fe200078e020dULL,
0x0000007423237210ULL, 0x000fc40007f5e0ffULL, 0x000000071f1f7812ULL, 0x000fe200078e4804ULL,
0x0000001029127825ULL, 0x000fe200078e0012ULL, 0x0000007425257210ULL, 0x080fe40007f3e0ffULL,
0x00000074272a7210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x0000007453747210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0xfffffff824537812ULL, 0x000fe200078ee221ULL, 0x0000001029107825ULL, 0x000fe200078e0010ULL,
0x0ffffff81f217812ULL, 0x000fc400078ef804ULL, 0xfffffff833337812ULL, 0x000fe200078ee222ULL,
0x000000ffff557224ULL, 0x000fe200028e06ffULL, 0x00005e00231e7a11ULL, 0x000fe200078448ffULL,
0x00000010291c7825ULL, 0x000fe200078e001cULL, 0x000000042b227212ULL, 0x000fe400078e3cffULL,
0x00005f00231f7a11ULL, 0x000fe200010f4c20ULL, 0x00000010212b7824ULL, 0x000fe200078e0272ULL,
0x00005e0025267a11ULL, 0x000fe200078248ffULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0xfffffff857577812ULL, 0x000fe200078ee222ULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0x00005e002a247a11ULL, 0x000fe200078448ffULL, 0x00000010291e7825ULL, 0x000fe200078e001eULL,
0x00005e002c227a11ULL, 0x000fe200078648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000122b7faeULL, 0x0003e2000b901c46ULL, 0x00005e0074207a11ULL, 0x000fe200078848ffULL,
0x0000001033337824ULL, 0x000fe200078e0272ULL, 0x00005f0025277a11ULL, 0x000fe200008f4c28ULL,
0x00000000102d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002a257a11ULL, 0x000fe200010f4c21ULL,
0x0000001053537824ULL, 0x000fe200078e0272ULL, 0x00005f002c237a11ULL, 0x000fe200018f4c23ULL,
0x0000001029267825ULL, 0x040fe200078e0026ULL, 0x00005f0074217a11ULL, 0x000fe200020f4c55ULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x0000001029247825ULL, 0x000fc400078e0024ULL,
0x000000001e317faeULL, 0x0003e4000b901c46ULL, 0x0000001029227825ULL, 0x040fe400078e0022ULL,
0x0000000026337faeULL, 0x0003e4000b901c46ULL, 0x0000001029207825ULL, 0x000fe400078e0020ULL,
0x0000000024517faeULL, 0x0003e4000b901c46ULL, 0x0000001057577824ULL, 0x000fc400078e0272ULL,
0x0000000022537faeULL, 0x0003e8000b901c46ULL, 0x0000000020577faeULL, 0x0003e4000b901c46ULL,
0x00000300ff107624ULL, 0x002fe200078e00ffULL, 0x0000000366117812ULL, 0x000fe200078ec0ffULL,
0xffffffffff657424ULL, 0x000fc600078e00ffULL, 0x000000031100780cULL, 0x000fe40003f25270ULL,
0xfffffffd10107811ULL, 0x000fc800078e10ffULL, 0x0000000110117807ULL, 0x000fca0004800000ULL,
0x0000000166667824ULL, 0x000fca00078e0211ULL, 0x000000616600720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000166107824ULL, 0x000fe400078e025eULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610657981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146280068127f8cULL, 0x000fe8000c80043fULL,
0x01462c0068117984ULL, 0x002e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007824813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01462c0068117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x014080005d127984ULL, 0x000e680000000800ULL, 0x014280005d137984ULL, 0x0004e20000000800ULL,
0x000000631200720bULL, 0x002fe20003f3d000ULL, 0x000143927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800008e0100ULL, 0x0000ffff101d7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000016200780cULL, 0x000fe40003f25270ULL,
0x000000631200720bULL, 0x000fe20003f54000ULL, 0x000143627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x000fe400010e0100ULL, 0x00000012631c7209ULL, 0x040fe40007810000ULL,
0x0000ffff10107812ULL, 0x000fe400078e3cffULL, 0x00000002ff2e7819ULL, 0x000fe20000011604ULL,
0x8000001c63117221ULL, 0x000fe20000010000ULL, 0x0144801c5d009388ULL, 0x0003e20000000800ULL,
0x000000101dff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x00000011002d7308ULL, 0x000ea40000000800ULL, 0x0000002d5f5f7220ULL, 0x004fe20000410000ULL,
0x000143027f007947ULL, 0x000fea000b800000ULL, 0x00001f2e2d107589ULL, 0x0022a400000e0000ULL,
0x0000001038387220ULL, 0x084fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x000000103c3c7220ULL, 0x080fe20000410000ULL, 0x000000103d3d7220ULL, 0x080fe20000410000ULL,
0x0000001040407220ULL, 0x080fe20000410000ULL, 0x0000001041417220ULL, 0x080fe20000410000ULL,
0x0000001044447220ULL, 0x080fe20000410000ULL, 0x0000001045457220ULL, 0x080fe20000410000ULL,
0x000000104c4c7220ULL, 0x080fe20000410000ULL, 0x000000104d4d7220ULL, 0x080fe20000410000ULL,
0x0000001048487220ULL, 0x080fe20000410000ULL, 0x0000001049497220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fe20000410000ULL,
0x000142427f007947ULL, 0x000fea000b800000ULL, 0x00001f162d107589ULL, 0x00052400000e0000ULL,
0x0000001263637209ULL, 0x000fe20007810000ULL, 0x000000103a3a7220ULL, 0x090fe20000410000ULL,
0x00000001ff1c7807ULL, 0x000fe20000800000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000103e3e7220ULL, 0x080fe20000410000ULL, 0x8000006312121221ULL, 0x000fe20000010000ULL,
0x000000103f3f7220ULL, 0x080fe20000410000ULL, 0x0000001042427220ULL, 0x080fe20000410000ULL,
0x0000001043437220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b12121820ULL, 0x000fe20000410000ULL,
0x0000001046467220ULL, 0x080fe20000410000ULL, 0x0000001047477220ULL, 0x080fe20000410000ULL,
0x000000104e4e7220ULL, 0x080fe20000410000ULL, 0x00000012005c1308ULL, 0x000f220000000800ULL,
0x000000104f4f7220ULL, 0x080fe20000410000ULL, 0x000000104a4a7220ULL, 0x080fe20000410000ULL,
0x000000104b4b7220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fe20000410000ULL, 0x000000135c131220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000005cff10723eULL, 0x000fe200000010ffULL,
0x0000005f135f7221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff2e7819ULL, 0x002fe40000011604ULL, 0x00005410102d7816ULL, 0x004fe20000000010ULL,
0x000140d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2e2d737589ULL, 0x0002a800000e0000ULL,
0x00001f162d747589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0015ULL, 0x0000571000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00014b6000007944ULL, 0x02cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0014ULL, 0x0000577000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00014b0000007944ULL, 0x02cfea0003c00000ULL, 0x0000a8000f2c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000b58783bULL, 0x000fe20000004200ULL,
0x0000a80007107811ULL, 0x000fe400078e20ffULL, 0x000099101c1c7816ULL, 0x000fe200000000ffULL,
0x000000002c2c783bULL, 0x002e660000000200ULL, 0x000000ff1c00720cULL, 0x000fe20003f25270ULL,
0x000000000950783bULL, 0x000fe80000004200ULL, 0x000000000a54783bULL, 0x000fe80000004200ULL,
0x000000000830783bULL, 0x000fe80000004200ULL, 0x000000001010783bULL, 0x000f280000000200ULL,
0x000000000628783bULL, 0x004ea80000004200ULL, 0x000000000220783bULL, 0x000ee80000004200ULL,
0x000000000324783bULL, 0x000ea80000004200ULL, 0x00000000001c783bULL, 0x000ea20000004200ULL,
0x000000732c2c9231ULL, 0x002fc400003400ffULL, 0x000000732e2e9231ULL, 0x000fe400003400ffULL,
0x000000742d2d9231ULL, 0x088fe400003400ffULL, 0x000000742f2f9231ULL, 0x000fce00003400ffULL,
0x000000582c38723cULL, 0x000fe20000041838ULL, 0x0000007310109231ULL, 0x090fe400003400ffULL,
0x0000007312129231ULL, 0x000fe200003400ffULL, 0x0000580065737a24ULL, 0x020fe200078e02ffULL,
0x0000007411119231ULL, 0x000fc600003400ffULL, 0x0000005a2c3c723cULL, 0x000fe2000004183cULL,
0x0000007413139231ULL, 0x000fe200003400ffULL, 0x0000004073737824ULL, 0x000fcc00078e00ffULL,
0x000000502c4c723cULL, 0x040ff0000004184cULL, 0x000000542c40723cULL, 0x040ff00000041840ULL,
0x000000562c44723cULL, 0x040ff00000041844ULL, 0x000000522c48723cULL, 0x040ff00000041848ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c18723cULL, 0x000ff00000041818ULL,
0x000000281038723cULL, 0x044ff00000041838ULL, 0x0000002a103c723cULL, 0x040ff0000004183cULL,
0x00000020104c723cULL, 0x040ff0000004184cULL, 0x000000241040723cULL, 0x040ff00000041840ULL,
0x000000261044723cULL, 0x040ff00000041844ULL, 0x000000221020723cULL, 0x040ff00000041848ULL,
0x0000001c1034723cULL, 0x040ff00000041834ULL, 0x0000001e1028723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe40000011604ULL, 0x0000008064117811ULL, 0x000fe400078e40ffULL,
0x000000081f257810ULL, 0x000fe20007ffe0ffULL, 0x00000040052e7824ULL, 0x000fe200078e021fULL,
0x000000041f197810ULL, 0x000fe40007ffe0ffULL, 0x0000001160107217ULL, 0x000fe20007800000ULL,
0x0000000825187824ULL, 0x040fe200078e00ffULL, 0x0000000425137212ULL, 0x000fe200078e3cffULL,
0x0000000819277824ULL, 0x000fe200078e00ffULL, 0x0000000c1f2d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0x000000101f4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000419127212ULL, 0x080fe400078e3cffULL, 0xfffffff818337812ULL, 0x000fe200078ee213ULL,
0x000000082d187824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee212ULL,
0x000000084b517824ULL, 0x000fe200078e00ffULL, 0x000000141f537810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x100fe200078e020cULL, 0x000000181f577810ULL, 0x000fe20007ffe0ffULL,
0x0000001027317824ULL, 0x000fe200078e020cULL, 0x000000042d117212ULL, 0x080fe200078e3cffULL,
0x00000008531a7824ULL, 0x000fe200078e00ffULL, 0x000000044b127212ULL, 0x000fe200078e3cffULL,
0x00000008571c7824ULL, 0x000fe200078e00ffULL, 0xfffffff818497812ULL, 0x000fc400078ee211ULL,
0xfffffff851517812ULL, 0x000fe400078ee212ULL, 0x0000001c1f5b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001049497824ULL, 0x100fe200078e020cULL, 0x0000000453137212ULL, 0x080fe200078e3cffULL,
0x0000001051517824ULL, 0x000fe200078e020cULL, 0x000000732e127210ULL, 0x040fe20007f5e0ffULL,
0x000000085b1e7824ULL, 0x000fe200078e00ffULL, 0x0000000457117212ULL, 0x000fe400078e3cffULL,
0x000000042e187810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81a557812ULL, 0x000fe200078ee213ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0xfffffff81c597812ULL, 0x000fe400078ee211ULL,
0x000000045b1b7212ULL, 0x000fe200078e3cffULL, 0x0000001055557824ULL, 0x100fe200078e020cULL,
0x0000007318117210ULL, 0x000fe20007f7e0ffULL, 0x0000001059597824ULL, 0x000fe200078e020cULL,
0x00005e00121a7a11ULL, 0x000fe400078448ffULL, 0xfffffff81e757812ULL, 0x000fc400078ee21bULL,
0x0000002010267817ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x00005f00121b7a11ULL, 0x000fe200010f4c13ULL, 0x0000001075757824ULL, 0x000fe200078e020cULL,
0x000000082e127810ULL, 0x040fe40007ffe0ffULL, 0x00005e00111c7a11ULL, 0x000fe400078448ffULL,
0x0000000c2e187810ULL, 0x000fe40007ffe0ffULL, 0x0000007312137210ULL, 0x000fc40007f9e0ffULL,
0x00005f00111d7a11ULL, 0x000fe400010f4c10ULL, 0x0000007318117210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e0013127a11ULL, 0x000fe400078448ffULL,
0x000000102e247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200028e06ffULL,
0x00005e0011107a11ULL, 0x000fe400078848ffULL, 0x000000261900720cULL, 0x000fc40003f66070ULL,
0x00005f0013137a11ULL, 0x000fe400010f4c1eULL, 0x0000007324197210ULL, 0x000fe40007f5e0ffULL,
0x00005f0011117a11ULL, 0x000fe400020f4c18ULL, 0x000000261f00720cULL, 0x0c0fe20003f86070ULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x000000071f1f7812ULL, 0x000fe400078e4804ULL,
0x000000262500720cULL, 0x000fc40003fa6070ULL, 0x00005e0019187a11ULL, 0x000fe400078c48ffULL,
0x0ffffff81f257812ULL, 0x000fe400078ef804ULL, 0x000000262d00720cULL, 0x000fe20003f46070ULL,
0x00000001682d7824ULL, 0x000fe200078e020dULL, 0x000000142e247810ULL, 0x000fe20007ffe0ffULL,
0x00000010252f7824ULL, 0x000fe200078e020cULL, 0x00005f0019197a11ULL, 0x000fe200030f4c1eULL,
0x000000102d1c7825ULL, 0x000fe200078e001cULL, 0x00000073241f7210ULL, 0x000fc40007fde0ffULL,
0x000000182e307810ULL, 0x040fe20007ffe0ffULL, 0x000000102d247825ULL, 0x000fe200078e001aULL,
0x0000001c2e2e7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff2c7224ULL, 0x000fe200030e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000e101c46ULL,
0x00005e001f1e7a11ULL, 0x000fe200078c48ffULL, 0x000000102d127825ULL, 0x000fe200078e0012ULL,
0x00000073301b7210ULL, 0x080fe20007f9e0ffULL, 0x000000001c317faeULL, 0x0005e2000d901c46ULL,
0x00005f001f1f7a11ULL, 0x000fe200030f4c2cULL, 0x000000102d107825ULL, 0x000fe200078e0010ULL,
0x000000732e277210ULL, 0x000fe20007f7e0ffULL, 0x0000000012337faeULL, 0x0007e2000e901c46ULL,
0x00005e001b1a7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x000000264b00720cULL, 0x080fe20003f86070ULL, 0x000000102d187825ULL, 0x000fe200078e0018ULL,
0x000000265700720cULL, 0x080fe20003fa6070ULL, 0x0000000010497faeULL, 0x0007e2000d101c46ULL,
0x00005f001b1b7a11ULL, 0x000fe200030f4c2cULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00005e0027247a11ULL, 0x002fe200078648ffULL, 0x000000102d1e7825ULL, 0x000fe200078e001eULL,
0x000000265300720cULL, 0x000fc40003fc6070ULL, 0x00005f0027257a11ULL, 0x000fe200018f4c2cULL,
0x000000102d1a7825ULL, 0x000fe200078e001aULL, 0x000000265b00720cULL, 0x000fe20003f66070ULL,
0x0000000018517faeULL, 0x0007e4000e101c46ULL, 0x000000102d1c7825ULL, 0x004fcc00078e0024ULL,
0x000000001e557faeULL, 0x0007e8000f101c46ULL, 0x000000001a597faeULL, 0x0007e8000e901c46ULL,
0x000000001c757faeULL, 0x0007e2000d901c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x000fe20000011604ULL, 0x00000001682d7824ULL, 0x000fc600078e020dULL,
0x0000000413117810ULL, 0x000fe20007ffe0ffULL, 0x00000040051c7824ULL, 0x000fe200078e0213ULL,
0x0000000813197810ULL, 0x040fe40007ffe0ffULL, 0x0000000c131b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000811317824ULL, 0x000fe200078e00ffULL, 0x00000010131d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0x0000000411107212ULL, 0x080fe200078e3cffULL,
0x000000081b497824ULL, 0x000fe200078e00ffULL, 0x0000000419117212ULL, 0x080fe200078e3cffULL,
0x000000081d4b7824ULL, 0x000fe200078e00ffULL, 0x000000041b127212ULL, 0x000fc400078e3cffULL,
0x0000001c131b7810ULL, 0x000fe40007ffe0ffULL, 0x000000041d187212ULL, 0x080fe400078e3cffULL,
0xfffffff81a337812ULL, 0x000fe200078ee211ULL, 0x000000081b597824ULL, 0x000fe200078e00ffULL,
0x0000001413117810ULL, 0x040fe40007ffe0ffULL, 0x0000001813197810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e020cULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee218ULL,
0x0000000811517824ULL, 0x000fe200078e00ffULL, 0x000000041b187212ULL, 0x000fe200078e3cffULL,
0x0000000819557824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee210ULL,
0x000000104b4b7824ULL, 0x000fe200078e020cULL, 0xfffffff849497812ULL, 0x000fc400078ee212ULL,
0x0000000411107212ULL, 0x080fe200078e3cffULL, 0x0000001031317824ULL, 0x100fe200078e020cULL,
0x0000000419127212ULL, 0x000fe200078e3cffULL, 0x0000001049497824ULL, 0x000fe200078e020cULL,
0x000000731c117210ULL, 0x040fe40007f5e0ffULL, 0xfffffff859597812ULL, 0x000fe400078ee218ULL,
0x000000041c187810ULL, 0x040fe40007ffe0ffULL, 0x000000081c1a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001059597824ULL, 0x000fe200078e020cULL, 0x0000000c1c1e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff855557812ULL, 0x000fe200078ee212ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0xfffffff851517812ULL, 0x000fe400078ee210ULL, 0x0000007318197210ULL, 0x080fe20007f7e0ffULL,
0x0000001055557824ULL, 0x100fe200078e020cULL, 0x00005e0011107a11ULL, 0x000fe200078448ffULL,
0x0000001051517824ULL, 0x000fe200078e020cULL, 0x000000731a1f7210ULL, 0x080fe40007f9e0ffULL,
0x000000731e257210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00005f0011117a11ULL, 0x000fe200010f4c12ULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00000007131d7812ULL, 0x000fe200078e4804ULL, 0x000000ffff267224ULL, 0x000fe200028e06ffULL,
0x00005e00191a7a11ULL, 0x000fe200078448ffULL, 0x000000102d107825ULL, 0x000fe200078e0010ULL,
0x00005e001f187a11ULL, 0x000fc400078648ffULL, 0x00005e0025127a11ULL, 0x000fe400078848ffULL,
0x0ffffff81d1d7812ULL, 0x000fe400078ef804ULL, 0x00005f00191b7a11ULL, 0x000fe400010f4c1eULL,
0x00005f001f197a11ULL, 0x000fe200018f4c24ULL, 0x000000101d2f7824ULL, 0x000fe200078e020cULL,
0x000000101c1e7810ULL, 0x000fe20007ffe0ffULL, 0x000000102d1a7825ULL, 0x000fe200078e001aULL,
0x00005f0025137a11ULL, 0x000fc400020f4c26ULL, 0x000000141c247810ULL, 0x040fe20007ffe0ffULL,
0x000000102d187825ULL, 0x040fe200078e0018ULL, 0x000000181c267810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102f7faeULL, 0x0003e2000b901c46ULL,
0x0000001c1c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000102d127825ULL, 0x000fe200078e0012ULL,
0x000000731e1d7210ULL, 0x080fe20007f9e0ffULL, 0x000000001a317faeULL, 0x0003e2000b901c46ULL,
0x00000073241f7210ULL, 0x080fe40007fbe0ffULL, 0x0000007326307210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x000000731c327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x00005e001d267a11ULL, 0x000fe200078848ffULL,
0x000000ffff537224ULL, 0x000fe200010e06ffULL, 0x00005e001f247a11ULL, 0x000fe200078a48ffULL,
0x000000ffff577224ULL, 0x000fe200018e06ffULL, 0x00005e00301e7a11ULL, 0x000fe200078448ffULL,
0x0000000018337faeULL, 0x0003e2000b901c46ULL, 0x00005e00321c7a11ULL, 0x000fc400078648ffULL,
0x00005f001d277a11ULL, 0x000fe200020f4c2cULL, 0x0000000012497faeULL, 0x0003e2000b901c46ULL,
0x00005f001f257a11ULL, 0x000fe400028f4c2eULL, 0x00005f00301f7a11ULL, 0x000fe200010f4c53ULL,
0x000000102d267825ULL, 0x000fe200078e0026ULL, 0x00005f00321d7a11ULL, 0x000fc600018f4c57ULL,
0x000000102d247825ULL, 0x040fe200078e0024ULL, 0x00000000264b7faeULL, 0x0003e6000b901c46ULL,
0x000000102d1e7825ULL, 0x040fe200078e001eULL, 0x0000000024517faeULL, 0x0003e6000b901c46ULL,
0x000000102d1c7825ULL, 0x000fe200078e001cULL, 0x000000001e557faeULL, 0x0003e8000b901c46ULL,
0x000000001c597faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000a800712c7811ULL, 0x000fc400078e20ffULL, 0x0000005cff10723eULL, 0x00afe400000010ffULL,
0x00000002ff757819ULL, 0x000fe40000011604ULL, 0x0000541010767816ULL, 0x000fe40000000010ULL,
0x0000a8006c187811ULL, 0x000fc600078e20ffULL, 0x00001f7576757589ULL, 0x000fe800000e0000ULL,
0x00001f1676747589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002c2c783bULL, 0x000e680000000200ULL, 0x000000006e50783bULL, 0x000ea80000004200ULL,
0x000000007058783bULL, 0x000fe80000004200ULL, 0x000000006f54783bULL, 0x000fe80000004200ULL,
0x000000006d30783bULL, 0x000fe80000004200ULL, 0x000000001818783bULL, 0x000ee80000000200ULL,
0x000000006948783bULL, 0x000f280000004200ULL, 0x000000006b24783bULL, 0x000f680000004200ULL,
0x000000006a1c783bULL, 0x000f280000004200ULL, 0x000000006710783bULL, 0x000f220000004200ULL,
0x000000752c2c9231ULL, 0x002fc400003400ffULL, 0x000000752e2e9231ULL, 0x000fe400003400ffULL,
0x000000742d2d9231ULL, 0x080fe400003400ffULL, 0x000000742f2f9231ULL, 0x000fce00003400ffULL,
0x000000502c4c723cULL, 0x004fe2000004184cULL, 0x0000007518189231ULL, 0x008fce00003400ffULL,
0x000000582c38723cULL, 0x000fe20000041838ULL, 0x000000751a1a9231ULL, 0x000fe400003400ffULL,
0x0000007419199231ULL, 0x080fe400003400ffULL, 0x000000741b1b9231ULL, 0x000fc600003400ffULL,
0x0000005a2c3c723cULL, 0x040ff0000004183cULL, 0x000000542c40723cULL, 0x040ff00000041840ULL,
0x000000562c44723cULL, 0x040ff00000041844ULL, 0x000000522c20723cULL, 0x040ff00000041820ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c28723cULL, 0x000ff00000041828ULL,
0x00000048184c723cULL, 0x050ff0000004184cULL, 0x000000241838723cULL, 0x060ff00000041838ULL,
0x00000026183c723cULL, 0x040ff0000004183cULL, 0x0000001c1840723cULL, 0x040ff00000041840ULL,
0x0000001e1844723cULL, 0x040ff00000041844ULL, 0x0000004a1848723cULL, 0x040ff00000041820ULL,
0x000000101834723cULL, 0x040ff00000041834ULL, 0x000000121818723cULL, 0x000fe20000041828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008064117811ULL, 0x000fe200078e40ffULL,
0x01469000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000601100720cULL, 0x000fda0003f26070ULL,
0x0000501000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1d7819ULL, 0x000fe20000011604ULL,
0x0000000168277824ULL, 0x000fe200078e020dULL, 0x00000020051e7811ULL, 0x000fe400078e30ffULL,
0x000000a064117811ULL, 0x000fe400078e40ffULL, 0x000000041d237810ULL, 0x040fe20007ffe0ffULL,
0x000000011d127824ULL, 0x000fe200078e021eULL, 0x0000001160107217ULL, 0x000fe40007800000ULL,
0x00000004231f7212ULL, 0x040fe200078e3cffULL, 0x0000000823227824ULL, 0x000fe200078e00ffULL,
0x0000007312137210ULL, 0x000fe20007f3e0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x000000071d117812ULL, 0x000fc400078e4804ULL, 0xfffffff822257812ULL, 0x000fe200078ee21fULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x00005e0013127a11ULL, 0x000fe400078248ffULL,
0x0ffffff8111f7812ULL, 0x000fe200078ef804ULL, 0x0000001025297824ULL, 0x000fe200078e0272ULL,
0x00005f0013137a11ULL, 0x000fe200008f4c1cULL, 0x00000001231c7824ULL, 0x000fe200078e021eULL,
0x000000081d2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0272ULL,
0x0000002010267817ULL, 0x000fe20003800000ULL, 0x0000001027127825ULL, 0x000fe200078e0012ULL,
0x000000731c117210ULL, 0x000fc40007f5e0ffULL, 0x0000000c1d2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000082b2d7824ULL, 0x040fe200078e00ffULL, 0x000000042b207212ULL, 0x000fe200078e3cffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078448ffULL,
0x000000082f317824ULL, 0x000fe200078e00ffULL, 0x000000261d00720cULL, 0x040fe40003f26070ULL,
0x000000101d337810ULL, 0x040fe40007ffe0ffULL, 0x000000141d537810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee220ULL, 0x0000000833247824ULL, 0x000fe200078e00ffULL,
0x00005f0011117a11ULL, 0x000fe200010f4c1cULL, 0x000000012b1c7824ULL, 0x000fe200078e021eULL,
0x000000042f207212ULL, 0x080fe200078e3cffULL, 0x0000000853557824ULL, 0x000fe200078e00ffULL,
0x0000000433217212ULL, 0x080fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121f7faeULL, 0x0003e2000c901c46ULL, 0x0000000453227212ULL, 0x000fe200078e3cffULL,
0x000000102d2d7824ULL, 0x000fe200078e0272ULL, 0x000000181d577810ULL, 0x000fc40007ffe0ffULL,
0xfffffff831317812ULL, 0x000fe200078ee220ULL, 0x000000012f207824ULL, 0x100fe200078e021eULL,
0x0000001c1d5b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000157287824ULL, 0x140fe200078e021eULL,
0x000000731c1c7210ULL, 0x080fe20007f5e0ffULL, 0x0000000857597824ULL, 0x000fe200078e00ffULL,
0xfffffff824517812ULL, 0x000fe200078ee221ULL, 0x0000000153247824ULL, 0x000fe200078e021eULL,
0xfffffff855557812ULL, 0x000fe200078ee222ULL, 0x0000000133227824ULL, 0x100fe200078e021eULL,
0x00000073201d7210ULL, 0x080fe20007f7e0ffULL, 0x000000015b1e7824ULL, 0x040fe200078e021eULL,
0x00005e001c127a11ULL, 0x002fe200078c48ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00000073221f7210ULL, 0x080fe20007f3e0ffULL, 0x000000085b657824ULL, 0x000fe200078e00ffULL,
0x0000007324207210ULL, 0x080fe20007f9e0ffULL, 0x0000001031317824ULL, 0x100fe200078e0272ULL,
0x0000007328217210ULL, 0x080fe20007fbe0ffULL, 0x0000001051517824ULL, 0x000fe200078e0272ULL,
0x000000731e737210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00005f001c137a11ULL, 0x000fe200030f4c13ULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x000000045b247212ULL, 0x000fe200078e3cffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078c48ffULL, 0x0000001027127825ULL, 0x000fe200078e0012ULL,
0x000000262300720cULL, 0x000fc40003f66070ULL, 0x0000000457227212ULL, 0x000fe200078e3cffULL,
0x0000001055557824ULL, 0x000fe200078e0272ULL, 0xfffffff865657812ULL, 0x000fe200078ee224ULL,
0x000000ffff247224ULL, 0x000fe200008e06ffULL, 0x00005f001d1d7a11ULL, 0x000fe400030f4c1eULL,
0x00005e001f1e7a11ULL, 0x000fe200078c48ffULL, 0x0000001065657824ULL, 0x000fe200078e0272ULL,
0xfffffff859597812ULL, 0x000fe200078ee222ULL, 0x0000001027227825ULL, 0x000fe200078e0010ULL,
0x00005f001f1f7a11ULL, 0x000fc400030f4c24ULL, 0x00005e0020107a11ULL, 0x040fe200078c48ffULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x00005e0021247a11ULL, 0x000fe200078a48ffULL,
0x0000000022297faeULL, 0x0003e2000d901c46ULL, 0x000000262b00720cULL, 0x080fe20003f26070ULL,
0x00000010271c7825ULL, 0x000fe200078e001cULL, 0x00005f0020117a11ULL, 0x000fe400030f4c11ULL,
0x00005e0073207a11ULL, 0x000fe200078c48ffULL, 0x00000010271e7825ULL, 0x000fe200078e001eULL,
0x000000262f00720cULL, 0x000fc40003f66070ULL, 0x000000263300720cULL, 0x080fe20003f86070ULL,
0x0000001027107825ULL, 0x000fe200078e0010ULL, 0x000000265300720cULL, 0x080fe40003f46070ULL,
0x00005f0021257a11ULL, 0x000fe200028f4c2aULL, 0x0000001059597824ULL, 0x000fe200078e0272ULL,
0x000000265700720cULL, 0x080fe20003fa6070ULL, 0x00000000122d7faeULL, 0x0003e2000c901c46ULL,
0x00005f0073217a11ULL, 0x000fe200030f4c28ULL, 0x0000001027247825ULL, 0x000fe200078e0024ULL,
0x000000265b00720cULL, 0x000fe20003fc6070ULL, 0x000000001c317faeULL, 0x0003e4000d901c46ULL,
0x0000001027207825ULL, 0x000fc400078e0020ULL, 0x000000001e517faeULL, 0x0003e8000e101c46ULL,
0x0000000010557faeULL, 0x0003e8000d101c46ULL, 0x0000000024597faeULL, 0x0003e8000e901c46ULL,
0x0000000020657faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe40000011604ULL, 0x00000020051c7811ULL, 0x000fc400078e30ffULL,
0x000000041f137810ULL, 0x040fe40007ffe0ffULL, 0x000000081f217810ULL, 0x000fe40007ffe0ffULL,
0x0000000413107212ULL, 0x0c0fe200078e3cffULL, 0x00000008132d7824ULL, 0x000fe200078e00ffULL,
0x0000000c1f237810ULL, 0x000fe20007ffe0ffULL, 0x00000008211e7824ULL, 0x040fe200078e00ffULL,
0x0000000421117212ULL, 0x080fe400078e3cffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL,
0x000000011f107824ULL, 0x000fe200078e021cULL, 0xfffffff81e2f7812ULL, 0x000fe200078ee211ULL,
0x0000000823317824ULL, 0x000fe200078e00ffULL, 0x000000101f257810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0272ULL, 0x0000007310117210ULL, 0x000fe20007f3e0ffULL,
0x0000000113107824ULL, 0x000fe200078e021cULL, 0x0000000423127212ULL, 0x080fe200078e3cffULL,
0x0000000825247824ULL, 0x040fe200078e00ffULL, 0x0000000425137212ULL, 0x000fe200078e3cffULL,
0x000000ffff1e7224ULL, 0x000fe200008e06ffULL, 0xfffffff831317812ULL, 0x000fe200078ee212ULL,
0x000000102f2f7824ULL, 0x000fe200078e0272ULL, 0x00005e0011127a11ULL, 0x000fc400078248ffULL,
0x00000073101d7210ULL, 0x080fe20007f5e0ffULL, 0x0000001031317824ULL, 0x000fe200078e0272ULL,
0xfffffff824337812ULL, 0x000fe400078ee213ULL, 0x00005f0011137a11ULL, 0x000fe200008f4c1eULL,
0x00000001211e7824ULL, 0x000fe200078e021cULL, 0x000000141f277810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200010e06ffULL, 0x00005e001d107a11ULL, 0x000fe200078448ffULL,
0x0000001033337824ULL, 0x000fe200078e0272ULL, 0x000000731e1e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000127247824ULL, 0x000fe200078e021cULL, 0x000000181f297810ULL, 0x000fe20007ffe0ffULL,
0x0000000827517824ULL, 0x040fe200078e00ffULL, 0x0000000427227212ULL, 0x000fc400078e3cffULL,
0x00005f001d117a11ULL, 0x000fe200010f4c20ULL, 0x0000000123207824ULL, 0x000fe200078e021cULL,
0x0000001c1f2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x00000073242a7210ULL, 0x080fe20007f7e0ffULL, 0x0000000829247824ULL, 0x000fe200078e00ffULL,
0xfffffff851517812ULL, 0x000fe200078ee222ULL, 0x0000000125227824ULL, 0x100fe200078e021cULL,
0x0000000429217212ULL, 0x040fe200078e3cffULL, 0x0000000129267824ULL, 0x100fe200078e021cULL,
0x0000007320207210ULL, 0x080fe20007f5e0ffULL, 0x000000012b287824ULL, 0x000fe200078e021cULL,
0x000000071f1f7812ULL, 0x000fe200078e4804ULL, 0x000000082b557824ULL, 0x000fe200078e00ffULL,
0x00005e001e1c7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0xfffffff824537812ULL, 0x000fe200078ee221ULL, 0x0000000168297824ULL, 0x000fe200078e020dULL,
0x0000007322257210ULL, 0x000fe20007f3e0ffULL, 0x0000001051517824ULL, 0x000fe200078e0272ULL,
0x0ffffff81f217812ULL, 0x000fe200078ef804ULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x00005f001e1d7a11ULL, 0x000fc400030f4c1dULL, 0x00000073262c7210ULL, 0x080fe20007f9e0ffULL,
0x0000001029107825ULL, 0x000fe200078e0010ULL, 0x00005e00201e7a11ULL, 0x000fe400078448ffULL,
0x0000007328737210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x000000042b227212ULL, 0x000fe200078e3cffULL, 0x00000010212b7824ULL, 0x000fe200078e0272ULL,
0x00005f00201f7a11ULL, 0x000fe200010f4c23ULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0x00005e0025267a11ULL, 0x000fe200078248ffULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0xfffffff855557812ULL, 0x000fe200078ee222ULL, 0x000000ffff2e7224ULL, 0x000fe200028e06ffULL,
0x00005e002a247a11ULL, 0x000fe200078448ffULL, 0x00000010291c7825ULL, 0x000fe200078e001cULL,
0x00005e002c227a11ULL, 0x000fe200078648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000122b7faeULL, 0x0003e2000b901c46ULL, 0x00005e0073207a11ULL, 0x000fe200078848ffULL,
0x00000010291e7825ULL, 0x000fe200078e001eULL, 0x00005f0025277a11ULL, 0x000fe200008f4c28ULL,
0x00000000102d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002a257a11ULL, 0x000fe200010f4c21ULL,
0x0000001053537824ULL, 0x000fe200078e0272ULL, 0x00005f002c237a11ULL, 0x000fe200018f4c23ULL,
0x0000001029267825ULL, 0x000fe200078e0026ULL, 0x00005f0073217a11ULL, 0x000fe200020f4c2eULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x0000001029247825ULL, 0x000fc400078e0024ULL,
0x000000001e317faeULL, 0x0003e4000b901c46ULL, 0x0000001029227825ULL, 0x040fe400078e0022ULL,
0x0000000026337faeULL, 0x0003e4000b901c46ULL, 0x0000001029207825ULL, 0x000fe400078e0020ULL,
0x0000000024517faeULL, 0x0003e4000b901c46ULL, 0x0000001055557824ULL, 0x000fc400078e0272ULL,
0x0000000022537faeULL, 0x0003e8000b901c46ULL, 0x0000000020557faeULL, 0x0003e4000b901c46ULL,
0x00000300ff107624ULL, 0x002fe200078e00ffULL, 0x0000000366117812ULL, 0x000fe200078ec0ffULL,
0xffffffffff657424ULL, 0x000fc600078e00ffULL, 0x000000031100780cULL, 0x000fe40003f25270ULL,
0xfffffffd10107811ULL, 0x000fc800078e10ffULL, 0x0000000110117807ULL, 0x000fca0004800000ULL,
0x0000000166667824ULL, 0x000fca00078e0211ULL, 0x000000616600720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000166107824ULL, 0x000fe400078e025eULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610657981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146480068127f8cULL, 0x000fe8000c80043fULL,
0x01464c0068117984ULL, 0x002e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007824813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01464c0068117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x014100005d127984ULL, 0x000e680000000800ULL, 0x014300005d137984ULL, 0x0004e20000000800ULL,
0x000000631200720bULL, 0x002fe20003f3d000ULL, 0x00011dc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800008e0100ULL, 0x0000ffff101d7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000026200780cULL, 0x000fe40003f25270ULL,
0x000000631200720bULL, 0x000fe20003f54000ULL, 0x00011d927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x000fe400010e0100ULL, 0x00000012631c7209ULL, 0x040fe40007810000ULL,
0x0000ffff10107812ULL, 0x000fe400078e3cffULL, 0x00000002ff2e7819ULL, 0x000fe20000011604ULL,
0x8000001c63117221ULL, 0x000fe20000010000ULL, 0x0145001c5d009388ULL, 0x0003e20000000800ULL,
0x000000101dff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x00000011002d7308ULL, 0x000ea40000000800ULL, 0x0000002d5f5f7220ULL, 0x004fe20000410000ULL,
0x00011d327f007947ULL, 0x000fea000b800000ULL, 0x00001f2e2d107589ULL, 0x0022a400000e0000ULL,
0x0000001038387220ULL, 0x084fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x000000103c3c7220ULL, 0x080fe20000410000ULL, 0x000000103d3d7220ULL, 0x080fe20000410000ULL,
0x0000001040407220ULL, 0x080fe20000410000ULL, 0x0000001041417220ULL, 0x080fe20000410000ULL,
0x0000001044447220ULL, 0x080fe20000410000ULL, 0x0000001045457220ULL, 0x080fe20000410000ULL,
0x000000104c4c7220ULL, 0x080fe20000410000ULL, 0x000000104d4d7220ULL, 0x080fe20000410000ULL,
0x0000001048487220ULL, 0x080fe20000410000ULL, 0x0000001049497220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fe20000410000ULL,
0x00011c727f007947ULL, 0x000fea000b800000ULL, 0x00001f162d107589ULL, 0x00052400000e0000ULL,
0x0000001263637209ULL, 0x000fe20007810000ULL, 0x000000103a3a7220ULL, 0x090fe20000410000ULL,
0x00000001ff1c7807ULL, 0x000fe20000800000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000103e3e7220ULL, 0x080fe20000410000ULL, 0x8000006312121221ULL, 0x000fe20000010000ULL,
0x000000103f3f7220ULL, 0x080fe20000410000ULL, 0x0000001042427220ULL, 0x080fe20000410000ULL,
0x0000001043437220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b12121820ULL, 0x000fe20000410000ULL,
0x0000001046467220ULL, 0x080fe20000410000ULL, 0x0000001047477220ULL, 0x080fe20000410000ULL,
0x000000104e4e7220ULL, 0x080fe20000410000ULL, 0x00000012005c1308ULL, 0x000f220000000800ULL,
0x000000104f4f7220ULL, 0x080fe20000410000ULL, 0x000000104a4a7220ULL, 0x080fe20000410000ULL,
0x000000104b4b7220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fe20000410000ULL, 0x000000135c131220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000005cff10723eULL, 0x000fe200000010ffULL,
0x0000005f135f7221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff2e7819ULL, 0x002fe40000011604ULL, 0x00005410102d7816ULL, 0x004fe20000000010ULL,
0x00011b027f007947ULL, 0x000fea000b800000ULL, 0x00001f2e2d737589ULL, 0x0002a800000e0000ULL,
0x00001f162d747589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0015ULL, 0x00007f1000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0001236000007944ULL, 0x02cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0014ULL, 0x00007f7000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0001230000007944ULL, 0x02cfea0003c00000ULL, 0x0000b0000f2c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000b58783bULL, 0x000fe20000004200ULL,
0x0000b00007107811ULL, 0x000fe400078e20ffULL, 0x000099101c1c7816ULL, 0x000fe200000000ffULL,
0x000000002c2c783bULL, 0x002e660000000200ULL, 0x000000ff1c00720cULL, 0x000fe20003f25270ULL,
0x000000000950783bULL, 0x000fe80000004200ULL, 0x000000000a54783bULL, 0x000fe80000004200ULL,
0x000000000830783bULL, 0x000fe80000004200ULL, 0x000000001010783bULL, 0x000f280000000200ULL,
0x000000000628783bULL, 0x004ea80000004200ULL, 0x000000000220783bULL, 0x000ee80000004200ULL,
0x000000000324783bULL, 0x000ea80000004200ULL, 0x00000000001c783bULL, 0x000ea20000004200ULL,
0x000000732c2c9231ULL, 0x002fc400003400ffULL, 0x000000732e2e9231ULL, 0x000fe400003400ffULL,
0x000000742d2d9231ULL, 0x088fe400003400ffULL, 0x000000742f2f9231ULL, 0x000fce00003400ffULL,
0x000000582c38723cULL, 0x000fe20000041838ULL, 0x0000007310109231ULL, 0x090fe400003400ffULL,
0x0000007312129231ULL, 0x000fe200003400ffULL, 0x0000580065737a24ULL, 0x020fe200078e02ffULL,
0x0000007411119231ULL, 0x000fc600003400ffULL, 0x0000005a2c3c723cULL, 0x000fe2000004183cULL,
0x0000007413139231ULL, 0x000fe200003400ffULL, 0x0000004073737824ULL, 0x000fcc00078e00ffULL,
0x000000502c4c723cULL, 0x040ff0000004184cULL, 0x000000542c40723cULL, 0x040ff00000041840ULL,
0x000000562c44723cULL, 0x040ff00000041844ULL, 0x000000522c48723cULL, 0x040ff00000041848ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c18723cULL, 0x000ff00000041818ULL,
0x000000281038723cULL, 0x044ff00000041838ULL, 0x0000002a103c723cULL, 0x040ff0000004183cULL,
0x00000020104c723cULL, 0x040ff0000004184cULL, 0x000000241040723cULL, 0x040ff00000041840ULL,
0x000000261044723cULL, 0x040ff00000041844ULL, 0x000000221020723cULL, 0x040ff00000041848ULL,
0x0000001c1034723cULL, 0x040ff00000041834ULL, 0x0000001e1028723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe40000011604ULL, 0x000000c064117811ULL, 0x000fe400078e40ffULL,
0x000000081f257810ULL, 0x000fe20007ffe0ffULL, 0x00000040052e7824ULL, 0x000fe200078e021fULL,
0x000000041f197810ULL, 0x000fe40007ffe0ffULL, 0x0000001160107217ULL, 0x000fe20007800000ULL,
0x0000000825187824ULL, 0x040fe200078e00ffULL, 0x0000000425137212ULL, 0x000fe200078e3cffULL,
0x0000000819277824ULL, 0x000fe200078e00ffULL, 0x0000000c1f2d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0x000000101f4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000419127212ULL, 0x080fe400078e3cffULL, 0xfffffff818337812ULL, 0x000fe200078ee213ULL,
0x000000082d187824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee212ULL,
0x000000084b517824ULL, 0x000fe200078e00ffULL, 0x000000141f537810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x100fe200078e020cULL, 0x000000181f577810ULL, 0x000fe20007ffe0ffULL,
0x0000001027317824ULL, 0x000fe200078e020cULL, 0x000000042d117212ULL, 0x080fe200078e3cffULL,
0x00000008531a7824ULL, 0x000fe200078e00ffULL, 0x000000044b127212ULL, 0x000fe200078e3cffULL,
0x00000008571c7824ULL, 0x000fe200078e00ffULL, 0xfffffff818497812ULL, 0x000fc400078ee211ULL,
0xfffffff851517812ULL, 0x000fe400078ee212ULL, 0x0000001c1f5b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001049497824ULL, 0x100fe200078e020cULL, 0x0000000453137212ULL, 0x080fe200078e3cffULL,
0x0000001051517824ULL, 0x000fe200078e020cULL, 0x000000732e127210ULL, 0x040fe20007f5e0ffULL,
0x000000085b1e7824ULL, 0x000fe200078e00ffULL, 0x0000000457117212ULL, 0x000fe400078e3cffULL,
0x000000042e187810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81a557812ULL, 0x000fe200078ee213ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0xfffffff81c597812ULL, 0x000fe400078ee211ULL,
0x000000045b1b7212ULL, 0x000fe200078e3cffULL, 0x0000001055557824ULL, 0x100fe200078e020cULL,
0x0000007318117210ULL, 0x000fe20007f7e0ffULL, 0x0000001059597824ULL, 0x000fe200078e020cULL,
0x00005e00121a7a11ULL, 0x000fe400078448ffULL, 0xfffffff81e757812ULL, 0x000fc400078ee21bULL,
0x0000002010267817ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x00005f00121b7a11ULL, 0x000fe200010f4c13ULL, 0x0000001075757824ULL, 0x000fe200078e020cULL,
0x000000082e127810ULL, 0x040fe40007ffe0ffULL, 0x00005e00111c7a11ULL, 0x000fe400078448ffULL,
0x0000000c2e187810ULL, 0x000fe40007ffe0ffULL, 0x0000007312137210ULL, 0x000fc40007f9e0ffULL,
0x00005f00111d7a11ULL, 0x000fe400010f4c10ULL, 0x0000007318117210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e0013127a11ULL, 0x000fe400078448ffULL,
0x000000102e247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200028e06ffULL,
0x00005e0011107a11ULL, 0x000fe400078848ffULL, 0x000000261900720cULL, 0x000fc40003f66070ULL,
0x00005f0013137a11ULL, 0x000fe400010f4c1eULL, 0x0000007324197210ULL, 0x000fe40007f5e0ffULL,
0x00005f0011117a11ULL, 0x000fe400020f4c18ULL, 0x000000261f00720cULL, 0x0c0fe20003f86070ULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x000000071f1f7812ULL, 0x000fe400078e4804ULL,
0x000000262500720cULL, 0x000fc40003fa6070ULL, 0x00005e0019187a11ULL, 0x000fe400078c48ffULL,
0x0ffffff81f257812ULL, 0x000fe400078ef804ULL, 0x000000262d00720cULL, 0x000fe20003f46070ULL,
0x00000001682d7824ULL, 0x000fe200078e020dULL, 0x000000142e247810ULL, 0x000fe20007ffe0ffULL,
0x00000010252f7824ULL, 0x000fe200078e020cULL, 0x00005f0019197a11ULL, 0x000fe200030f4c1eULL,
0x000000102d1c7825ULL, 0x000fe200078e001cULL, 0x00000073241f7210ULL, 0x000fc40007fde0ffULL,
0x000000182e307810ULL, 0x040fe20007ffe0ffULL, 0x000000102d247825ULL, 0x000fe200078e001aULL,
0x0000001c2e2e7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff2c7224ULL, 0x000fe200030e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000e101c46ULL,
0x00005e001f1e7a11ULL, 0x000fe200078c48ffULL, 0x000000102d127825ULL, 0x000fe200078e0012ULL,
0x00000073301b7210ULL, 0x080fe20007f9e0ffULL, 0x000000001c317faeULL, 0x0005e2000d901c46ULL,
0x00005f001f1f7a11ULL, 0x000fe200030f4c2cULL, 0x000000102d107825ULL, 0x000fe200078e0010ULL,
0x000000732e277210ULL, 0x000fe20007f7e0ffULL, 0x0000000012337faeULL, 0x0007e2000e901c46ULL,
0x00005e001b1a7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x000000264b00720cULL, 0x080fe20003f86070ULL, 0x000000102d187825ULL, 0x000fe200078e0018ULL,
0x000000265700720cULL, 0x080fe20003fa6070ULL, 0x0000000010497faeULL, 0x0007e2000d101c46ULL,
0x00005f001b1b7a11ULL, 0x000fe200030f4c2cULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x00005e0027247a11ULL, 0x002fe200078648ffULL, 0x000000102d1e7825ULL, 0x000fe200078e001eULL,
0x000000265300720cULL, 0x000fc40003fc6070ULL, 0x00005f0027257a11ULL, 0x000fe200018f4c2cULL,
0x000000102d1a7825ULL, 0x000fe200078e001aULL, 0x000000265b00720cULL, 0x000fe20003f66070ULL,
0x0000000018517faeULL, 0x0007e4000e101c46ULL, 0x000000102d1c7825ULL, 0x004fcc00078e0024ULL,
0x000000001e557faeULL, 0x0007e8000f101c46ULL, 0x000000001a597faeULL, 0x0007e8000e901c46ULL,
0x000000001c757faeULL, 0x0007e2000d901c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x000fe20000011604ULL, 0x00000001682d7824ULL, 0x000fc600078e020dULL,
0x0000000413117810ULL, 0x000fe20007ffe0ffULL, 0x00000040051c7824ULL, 0x000fe200078e0213ULL,
0x0000000813197810ULL, 0x040fe40007ffe0ffULL, 0x0000000c131b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000811317824ULL, 0x000fe200078e00ffULL, 0x00000010131d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008191a7824ULL, 0x000fe200078e00ffULL, 0x0000000411107212ULL, 0x080fe200078e3cffULL,
0x000000081b497824ULL, 0x000fe200078e00ffULL, 0x0000000419117212ULL, 0x080fe200078e3cffULL,
0x000000081d4b7824ULL, 0x000fe200078e00ffULL, 0x000000041b127212ULL, 0x000fc400078e3cffULL,
0x0000001c131b7810ULL, 0x000fe40007ffe0ffULL, 0x000000041d187212ULL, 0x080fe400078e3cffULL,
0xfffffff81a337812ULL, 0x000fe200078ee211ULL, 0x000000081b597824ULL, 0x000fe200078e00ffULL,
0x0000001413117810ULL, 0x040fe40007ffe0ffULL, 0x0000001813197810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e020cULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee218ULL,
0x0000000811517824ULL, 0x000fe200078e00ffULL, 0x000000041b187212ULL, 0x000fe200078e3cffULL,
0x0000000819557824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee210ULL,
0x000000104b4b7824ULL, 0x000fe200078e020cULL, 0xfffffff849497812ULL, 0x000fc400078ee212ULL,
0x0000000411107212ULL, 0x080fe200078e3cffULL, 0x0000001031317824ULL, 0x100fe200078e020cULL,
0x0000000419127212ULL, 0x000fe200078e3cffULL, 0x0000001049497824ULL, 0x000fe200078e020cULL,
0x000000731c117210ULL, 0x040fe40007f5e0ffULL, 0xfffffff859597812ULL, 0x000fe400078ee218ULL,
0x000000041c187810ULL, 0x040fe40007ffe0ffULL, 0x000000081c1a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001059597824ULL, 0x000fe200078e020cULL, 0x0000000c1c1e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff855557812ULL, 0x000fe200078ee212ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0xfffffff851517812ULL, 0x000fe400078ee210ULL, 0x0000007318197210ULL, 0x080fe20007f7e0ffULL,
0x0000001055557824ULL, 0x100fe200078e020cULL, 0x00005e0011107a11ULL, 0x000fe200078448ffULL,
0x0000001051517824ULL, 0x000fe200078e020cULL, 0x000000731a1f7210ULL, 0x080fe40007f9e0ffULL,
0x000000731e257210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00005f0011117a11ULL, 0x000fe200010f4c12ULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00000007131d7812ULL, 0x000fe200078e4804ULL, 0x000000ffff267224ULL, 0x000fe200028e06ffULL,
0x00005e00191a7a11ULL, 0x000fe200078448ffULL, 0x000000102d107825ULL, 0x000fe200078e0010ULL,
0x00005e001f187a11ULL, 0x000fc400078648ffULL, 0x00005e0025127a11ULL, 0x000fe400078848ffULL,
0x0ffffff81d1d7812ULL, 0x000fe400078ef804ULL, 0x00005f00191b7a11ULL, 0x000fe400010f4c1eULL,
0x00005f001f197a11ULL, 0x000fe200018f4c24ULL, 0x000000101d2f7824ULL, 0x000fe200078e020cULL,
0x000000101c1e7810ULL, 0x000fe20007ffe0ffULL, 0x000000102d1a7825ULL, 0x000fe200078e001aULL,
0x00005f0025137a11ULL, 0x000fc400020f4c26ULL, 0x000000141c247810ULL, 0x040fe20007ffe0ffULL,
0x000000102d187825ULL, 0x040fe200078e0018ULL, 0x000000181c267810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102f7faeULL, 0x0003e2000b901c46ULL,
0x0000001c1c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000102d127825ULL, 0x000fe200078e0012ULL,
0x000000731e1d7210ULL, 0x080fe20007f9e0ffULL, 0x000000001a317faeULL, 0x0003e2000b901c46ULL,
0x00000073241f7210ULL, 0x080fe40007fbe0ffULL, 0x0000007326307210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x000000731c327210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x00005e001d267a11ULL, 0x000fe200078848ffULL,
0x000000ffff537224ULL, 0x000fe200010e06ffULL, 0x00005e001f247a11ULL, 0x000fe200078a48ffULL,
0x000000ffff577224ULL, 0x000fe200018e06ffULL, 0x00005e00301e7a11ULL, 0x000fe200078448ffULL,
0x0000000018337faeULL, 0x0003e2000b901c46ULL, 0x00005e00321c7a11ULL, 0x000fc400078648ffULL,
0x00005f001d277a11ULL, 0x000fe200020f4c2cULL, 0x0000000012497faeULL, 0x0003e2000b901c46ULL,
0x00005f001f257a11ULL, 0x000fe400028f4c2eULL, 0x00005f00301f7a11ULL, 0x000fe200010f4c53ULL,
0x000000102d267825ULL, 0x000fe200078e0026ULL, 0x00005f00321d7a11ULL, 0x000fc600018f4c57ULL,
0x000000102d247825ULL, 0x040fe200078e0024ULL, 0x00000000264b7faeULL, 0x0003e6000b901c46ULL,
0x000000102d1e7825ULL, 0x040fe200078e001eULL, 0x0000000024517faeULL, 0x0003e6000b901c46ULL,
0x000000102d1c7825ULL, 0x000fe200078e001cULL, 0x000000001e557faeULL, 0x0003e8000b901c46ULL,
0x000000001c597faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000b000712c7811ULL, 0x000fc400078e20ffULL, 0x0000005cff10723eULL, 0x00afe400000010ffULL,
0x00000002ff757819ULL, 0x000fe40000011604ULL, 0x0000541010767816ULL, 0x000fe40000000010ULL,
0x0000b0006c187811ULL, 0x000fc600078e20ffULL, 0x00001f7576757589ULL, 0x000fe800000e0000ULL,
0x00001f1676747589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002c2c783bULL, 0x000e680000000200ULL, 0x000000006e50783bULL, 0x000ea80000004200ULL,
0x000000007058783bULL, 0x000fe80000004200ULL, 0x000000006f54783bULL, 0x000fe80000004200ULL,
0x000000006d30783bULL, 0x000fe80000004200ULL, 0x000000001818783bULL, 0x000ee80000000200ULL,
0x000000006948783bULL, 0x000f280000004200ULL, 0x000000006b24783bULL, 0x000f680000004200ULL,
0x000000006a1c783bULL, 0x000f280000004200ULL, 0x000000006710783bULL, 0x000f220000004200ULL,
0x000000752c2c9231ULL, 0x002fc400003400ffULL, 0x000000752e2e9231ULL, 0x000fe400003400ffULL,
0x000000742d2d9231ULL, 0x080fe400003400ffULL, 0x000000742f2f9231ULL, 0x000fce00003400ffULL,
0x000000502c4c723cULL, 0x004fe2000004184cULL, 0x0000007518189231ULL, 0x008fce00003400ffULL,
0x000000582c38723cULL, 0x000fe20000041838ULL, 0x000000751a1a9231ULL, 0x000fe400003400ffULL,
0x0000007419199231ULL, 0x080fe400003400ffULL, 0x000000741b1b9231ULL, 0x000fc600003400ffULL,
0x0000005a2c3c723cULL, 0x040ff0000004183cULL, 0x000000542c40723cULL, 0x040ff00000041840ULL,
0x000000562c44723cULL, 0x040ff00000041844ULL, 0x000000522c20723cULL, 0x040ff00000041820ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c28723cULL, 0x000ff00000041828ULL,
0x00000048184c723cULL, 0x050ff0000004184cULL, 0x000000241838723cULL, 0x060ff00000041838ULL,
0x00000026183c723cULL, 0x040ff0000004183cULL, 0x0000001c1840723cULL, 0x040ff00000041840ULL,
0x0000001e1844723cULL, 0x040ff00000041844ULL, 0x0000004a1848723cULL, 0x040ff00000041820ULL,
0x000000101834723cULL, 0x040ff00000041834ULL, 0x000000121818723cULL, 0x000fe20000041828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000c064117811ULL, 0x000fe200078e40ffULL,
0x01469800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000601100720cULL, 0x000fda0003f26070ULL,
0x0000281000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x000000e064117811ULL, 0x000fe400078e40ffULL,
0x00000003ff257819ULL, 0x000fe40000011604ULL, 0x0000001160107217ULL, 0x000fe40007800000ULL,
0x0000000425297810ULL, 0x000fe40007ffe0ffULL, 0x0000002005227811ULL, 0x000fe200078e30ffULL,
0x00000001101c7824ULL, 0x000fe200078e0a11ULL, 0x0000000429107212ULL, 0x040fe200078e3cffULL,
0x00000008292d7824ULL, 0x000fe200078e00ffULL, 0x00000008252f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c25337810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL,
0x0000000125107824ULL, 0x100fe200078e0222ULL, 0x000000042f117212ULL, 0x0c0fe200078e3cffULL,
0x000000082f1e7824ULL, 0x000fe200078e00ffULL, 0x0000000433127212ULL, 0x0c0fe200078e3cffULL,
0x0000000833517824ULL, 0x000fe200078e00ffULL, 0x0000007310137210ULL, 0x080fe20007f1e0ffULL,
0x0000000129107824ULL, 0x000fe200078e0222ULL, 0xfffffff81e317812ULL, 0x000fe200078ee211ULL,
0x000000102d2d7824ULL, 0x100fe200078e0272ULL, 0x0000001425577810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200000e06ffULL, 0x0000007310117210ULL, 0x000fe20007f3e0ffULL,
0x0000001031317824ULL, 0x000fe200078e0272ULL, 0xfffffff851517812ULL, 0x000fe200078ee212ULL,
0x0000000857267824ULL, 0x000fe200078e00ffULL, 0x0000001025537810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078248ffULL,
0x0000001051517824ULL, 0x000fe200078e0272ULL, 0x00000004571f7212ULL, 0x000fe200078e3cffULL,
0x0000000853247824ULL, 0x000fe200078e00ffULL, 0x00005e00131e7a11ULL, 0x000fc400078048ffULL,
0x00005f0011117a11ULL, 0x000fe200008f4c12ULL, 0x000000012f127824ULL, 0x100fe200078e0222ULL,
0xfffffff826597812ULL, 0x000fe200078ee21fULL, 0x0000000157267824ULL, 0x000fe200078e0222ULL,
0x00005f00131f7a11ULL, 0x000fe200000f4c20ULL, 0x0000000133207824ULL, 0x000fe200078e0222ULL,
0x00000004531d7212ULL, 0x000fe200078e3cffULL, 0x0000001059597824ULL, 0x000fe200078e0272ULL,
0x00000018255b7810ULL, 0x000fe40007ffe0ffULL, 0x0000007312137210ULL, 0x000fc40007f1e0ffULL,
0xfffffff824557812ULL, 0x000fe200078ee21dULL, 0x000000015b287824ULL, 0x140fe200078e0222ULL,
0x00000073201d7210ULL, 0x080fe20007f7e0ffULL, 0x000000085b2c7824ULL, 0x040fe200078e00ffULL,
0x000000045b277212ULL, 0x000fe200078e3cffULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078048ffULL, 0x0000000153247824ULL, 0x000fe200078e0222ULL,
0x0000001c25757810ULL, 0x000fe20007ffe0ffULL, 0x0000001055557824ULL, 0x000fe200078e0272ULL,
0x0000007328237210ULL, 0x000fc40007fbe0ffULL, 0xfffffff82c657812ULL, 0x000fe200078ee227ULL,
0x00000008752e7824ULL, 0x000fe200078e00ffULL, 0x00005f0013137a11ULL, 0x000fe200000f4c20ULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0x000000201c287817ULL, 0x000fe20003800000ULL,
0x00000001752a7824ULL, 0x000fe200078e0222ULL, 0x0000000725277812ULL, 0x000fe200078e4804ULL,
0x000000ffff2c7224ULL, 0x000fe200028e06ffULL, 0x0000007324217210ULL, 0x000fe20007f3e0ffULL,
0x0000001065657824ULL, 0x000fe200078e0272ULL, 0x00005e001d1c7a11ULL, 0x000fc400078c48ffULL,
0x00000004752b7212ULL, 0x000fe200078e3cffULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0x000000282500720cULL, 0x080fe40003f66070ULL, 0x0ffffff827277812ULL, 0x000fe400078ef804ULL,
0x000000282900720cULL, 0x000fe20003f06070ULL, 0x0000000168297824ULL, 0x000fe200078e020dULL,
0x0000007326227210ULL, 0x000fe40007f9e0ffULL, 0x00005f001d1d7a11ULL, 0x000fe200030f4c20ULL,
0x0000001029107825ULL, 0x000fe200078e0010ULL, 0x00005e0021207a11ULL, 0x000fc400078c48ffULL,
0xfffffff82e777812ULL, 0x000fe200078ee22bULL, 0x00000010272b7824ULL, 0x000fe200078e0272ULL,
0x000000732a737210ULL, 0x000fe20007f5e0ffULL, 0x0000001029267825ULL, 0x000fe200078e001eULL,
0x00005f0021217a11ULL, 0x000fe400030f4c24ULL, 0x00005e00221e7a11ULL, 0x040fe200078c48ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e06ffULL, 0x00005e0023247a11ULL, 0x000fe200078a48ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x000000282f00720cULL, 0x080fe20003f26070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e2000d901c46ULL,
0x00005f00221f7a11ULL, 0x000fe200030f4c1fULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x00005e0073227a11ULL, 0x000fe200078c48ffULL, 0x00000000102d7faeULL, 0x0003e2000c101c46ULL,
0x000000283300720cULL, 0x080fe20003f66070ULL, 0x00000010291c7825ULL, 0x000fe200078e001cULL,
0x000000285300720cULL, 0x000fc40003f86070ULL, 0x000000285700720cULL, 0x080fe20003f46070ULL,
0x0000001029207825ULL, 0x000fe200078e0020ULL, 0x00005f0023257a11ULL, 0x000fe200028f4c2cULL,
0x0000000012317faeULL, 0x0003e2000c901c46ULL, 0x000000285b00720cULL, 0x080fe20003fa6070ULL,
0x00000010291e7825ULL, 0x000fe200078e001eULL, 0x00005f0073237a11ULL, 0x000fe400030f4c2aULL,
0x000000287500720cULL, 0x000fe20003fc6070ULL, 0x0000001029247825ULL, 0x000fe200078e0024ULL,
0x000000001c517faeULL, 0x0003e6000d901c46ULL, 0x0000001077777824ULL, 0x000fe200078e0272ULL,
0x0000000020557faeULL, 0x0003e2000e101c46ULL, 0x0000001029227825ULL, 0x000fc600078e0022ULL,
0x000000001e597faeULL, 0x0003e8000d101c46ULL, 0x0000000024657faeULL, 0x0003e8000e901c46ULL,
0x0000000022777faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x000fe40000011604ULL, 0x0000002005127811ULL, 0x000fc400078e30ffULL,
0x00000004131d7810ULL, 0x040fe40007ffe0ffULL, 0x00000008131f7810ULL, 0x000fe40007ffe0ffULL,
0x000000041d107212ULL, 0x0c0fe200078e3cffULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x000000041f117212ULL, 0x040fe200078e3cffULL, 0x000000081f1c7824ULL, 0x000fe200078e00ffULL,
0x0000000c13257810ULL, 0x000fe40007ffe0ffULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x0000000113107824ULL, 0x000fe200078e0212ULL, 0xfffffff81c237812ULL, 0x000fe200078ee211ULL,
0x0000000825277824ULL, 0x000fe200078e00ffULL, 0x00000014132b7810ULL, 0x000fc40007ffe0ffULL,
0x0000007310117210ULL, 0x000fe40007f1e0ffULL, 0x0000001013297810ULL, 0x000fe20007ffe0ffULL,
0x000000082b517824ULL, 0x000fe200078e00ffULL, 0x00000004251e7212ULL, 0x080fe200078e3cffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078048ffULL,
0x0000000829337824ULL, 0x000fe200078e00ffULL, 0x000000042b227212ULL, 0x000fe200078e3cffULL,
0x0000000129247824ULL, 0x000fe200078e0212ULL, 0x00005f0011117a11ULL, 0x000fe200000f4c1cULL,
0x000000011d1c7824ULL, 0x100fe200078e0212ULL, 0x00000018132d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b267824ULL, 0x000fe200078e0212ULL, 0x0000001c132f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff827277812ULL, 0x000fe200078ee21eULL, 0x000000011f1e7824ULL, 0x000fe200078e0212ULL,
0xfffffff851517812ULL, 0x000fe200078ee222ULL, 0x0000000125227824ULL, 0x100fe200078e0212ULL,
0x0000000429207212ULL, 0x080fe200078e3cffULL, 0x000000012d287824ULL, 0x000fe200078e0212ULL,
0x0000000713137812ULL, 0x000fe200078e4804ULL, 0x000000012f127824ULL, 0x000fe200078e0212ULL,
0x000000731c1c7210ULL, 0x080fe20007fde0ffULL, 0x000000082d297824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee220ULL, 0x000000082f557824ULL, 0x000fe200078e00ffULL,
0x0ffffff8131d7812ULL, 0x000fe200078ef804ULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x000000731e207210ULL, 0x080fe20007fbe0ffULL, 0x0000001027317824ULL, 0x100fe200078e0272ULL,
0x0000007322227210ULL, 0x080fe20007f9e0ffULL, 0x000000101d2b7824ULL, 0x100fe200078e0272ULL,
0x0000007324257210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e06ffULL,
0x00000073262a7210ULL, 0x080fe20007f1e0ffULL, 0x0000001033337824ULL, 0x100fe200078e0272ULL,
0x00000073282c7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x0000007312737210ULL, 0x000fe20007f5e0ffULL, 0x0000001051517824ULL, 0x100fe200078e0272ULL,
0x000000042d1e7212ULL, 0x000fe200078e3cffULL, 0x00000010212d7824ULL, 0x000fe200078e0272ULL,
0x00005e001c127a11ULL, 0x040fe200078c48ffULL, 0x000000ffff217224ULL, 0x000fe200020e06ffULL,
0xfffffff829297812ULL, 0x000fe200078ee21eULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x00005f001c137a11ULL, 0x000fc400030f4c1fULL, 0x00005e00201e7a11ULL, 0x000fe200078a48ffULL,
0x0000001029537824ULL, 0x100fe200078e0272ULL, 0x00005e00221c7a11ULL, 0x000fe200078848ffULL,
0x0000000168297824ULL, 0x000fe200078e020dULL, 0x000000042f247212ULL, 0x000fe200078e3cffULL,
0x00000010232f7824ULL, 0x000fe200078e0272ULL, 0x00005f00201f7a11ULL, 0x000fe200028f4c1dULL,
0x000000ffff237224ULL, 0x000fe200008e06ffULL, 0x00005f00221d7a11ULL, 0x000fe200020f4c21ULL,
0x000000ffff217224ULL, 0x000fe200000e06ffULL, 0xfffffff855557812ULL, 0x000fe200078ee224ULL,
0x0000001029107825ULL, 0x000fe200078e0010ULL, 0x00005e0025267a11ULL, 0x000fc400078648ffULL,
0x00005e002a247a11ULL, 0x000fe200078048ffULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x00005e002c227a11ULL, 0x000fe200078248ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102b7faeULL, 0x0003e2000b901c46ULL, 0x00005e0073207a11ULL, 0x000fe200078448ffULL,
0x00000010291e7825ULL, 0x000fe200078e001eULL, 0x00005f0025277a11ULL, 0x000fe200018f4c28ULL,
0x00000000122d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002a257a11ULL, 0x000fe200000f4c21ULL,
0x00000010291c7825ULL, 0x000fe200078e001cULL, 0x00005f002c237a11ULL, 0x000fe200008f4c23ULL,
0x000000001e2f7faeULL, 0x0003e2000b901c46ULL, 0x00005f0073217a11ULL, 0x000fe200010f4c2eULL,
0x0000001029267825ULL, 0x000fc400078e0026ULL, 0x000000001c317faeULL, 0x0003e4000b901c46ULL,
0x0000001029247825ULL, 0x040fe400078e0024ULL, 0x0000000026337faeULL, 0x0003e4000b901c46ULL,
0x0000001029227825ULL, 0x000fe400078e0022ULL, 0x0000000024517faeULL, 0x0003e4000b901c46ULL,
0x0000001055557824ULL, 0x000fc400078e0272ULL, 0x0000001029207825ULL, 0x000fe200078e0020ULL,
0x0000000022537faeULL, 0x0003e8000b901c46ULL, 0x0000000020557faeULL, 0x0003e4000b901c46ULL,
0x00000300ff107624ULL, 0x002fe200078e00ffULL, 0x0000000366117812ULL, 0x000fe200078ec0ffULL,
0xffffffffff657424ULL, 0x000fc600078e00ffULL, 0x000000031100780cULL, 0x000fe40003f05270ULL,
0xfffffffd10107811ULL, 0x000fc800078e10ffULL, 0x0000000110117807ULL, 0x000fca0004000000ULL,
0x0000000166667824ULL, 0x000fca00078e0211ULL, 0x000000616600720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000166107824ULL, 0x000fe400078e025eULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610657981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146680068127f8cULL, 0x000fe8000c80043fULL,
0x01466c0068117984ULL, 0x002e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01466c0068117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x014180005d127984ULL, 0x000e680000000800ULL, 0x014380005d137984ULL, 0x0004e20000000800ULL,
0x000000631200720bULL, 0x002fe20003f1d000ULL, 0x0000f7f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff101d7812ULL, 0x000fe2000780c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x000000036200780cULL, 0x000fe40003f05270ULL,
0x000000631200720bULL, 0x000fe20003f34000ULL, 0x0000f7c27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x000fe400008e0100ULL, 0x0000001263107209ULL, 0x040fe40007810000ULL,
0x0000ffff0e0e7812ULL, 0x000fe400078e3cffULL, 0x00000002ff2e7819ULL, 0x000fe20000011604ULL,
0x8000001063117221ULL, 0x000fe20000010000ULL, 0x014580105d008388ULL, 0x0003e20000000800ULL,
0x0000000e1dff7212ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x00000011002d7308ULL, 0x000ea40000000800ULL, 0x0000002d5f5f7220ULL, 0x004fe20000410000ULL,
0x0000f7627f007947ULL, 0x000fea000b800000ULL, 0x00001f2e2d0e7589ULL, 0x0022a400000e0000ULL,
0x0000000e38387220ULL, 0x084fe20000410000ULL, 0x0000000e39397220ULL, 0x080fe20000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000e40407220ULL, 0x080fe20000410000ULL, 0x0000000e41417220ULL, 0x080fe20000410000ULL,
0x0000000e44447220ULL, 0x080fe20000410000ULL, 0x0000000e45457220ULL, 0x080fe20000410000ULL,
0x0000000e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000000e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000000e48487220ULL, 0x080fe20000410000ULL, 0x0000000e49497220ULL, 0x080fe20000410000ULL,
0x0000000e34347220ULL, 0x080fe20000410000ULL, 0x0000000e35357220ULL, 0x080fe20000410000ULL,
0x0000000e18187220ULL, 0x080fe20000410000ULL, 0x0000000e19197220ULL, 0x000fe20000410000ULL,
0x0000f6a27f007947ULL, 0x000fea000b800000ULL, 0x00001f162d0e7589ULL, 0x00052400000e0000ULL,
0x0000001263637209ULL, 0x000fe20007810000ULL, 0x0000000e3a3a7220ULL, 0x090fe20000410000ULL,
0x00000001ff2c7807ULL, 0x000fe20000000000ULL, 0x0000000e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe20000410000ULL, 0x8000006312120221ULL, 0x000fe20000010000ULL,
0x0000000e3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000e42427220ULL, 0x080fe20000410000ULL,
0x0000000e43437220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b12120820ULL, 0x000fe20000410000ULL,
0x0000000e46467220ULL, 0x080fe20000410000ULL, 0x0000000e47477220ULL, 0x080fe20000410000ULL,
0x0000000e4e4e7220ULL, 0x080fe20000410000ULL, 0x00000012005c0308ULL, 0x000f220000000800ULL,
0x0000000e4f4f7220ULL, 0x080fe20000410000ULL, 0x0000000e4a4a7220ULL, 0x080fe20000410000ULL,
0x0000000e4b4b7220ULL, 0x080fe20000410000ULL, 0x0000000e36367220ULL, 0x080fe20000410000ULL,
0x0000000e37377220ULL, 0x080fe20000410000ULL, 0x0000000e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000e1b1b7220ULL, 0x000fe20000410000ULL, 0x000000135c130220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000005cff0e723eULL, 0x000fe200000010ffULL,
0x0000005f135f7221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff2e7819ULL, 0x002fe40000011604ULL, 0x000054100e2d7816ULL, 0x004fe2000000000eULL,
0x0000f5327f007947ULL, 0x000fea000b800000ULL, 0x00001f2e2d5d7589ULL, 0x0002a800000e0000ULL,
0x00001f162d0e7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0015ULL, 0x0000a71000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000fb6000007944ULL, 0x02cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2e7224ULL, 0x002fe200078e0014ULL, 0x0000a77000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000fb0000007944ULL, 0x02cfea0003c00000ULL, 0x0000b8000f0f7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000b1c783bULL, 0x000fe20000004200ULL,
0x0000b80007077811ULL, 0x000fe400078e20ffULL, 0x000099102c147816ULL, 0x000fe200000000ffULL,
0x000000000f10783bULL, 0x000f260000000200ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000000a20783bULL, 0x000fe80000004200ULL, 0x000000000924783bULL, 0x000fe80000004200ULL,
0x000000000828783bULL, 0x004fe80000004200ULL, 0x00000000072c783bULL, 0x002e680000000200ULL,
0x000000000630783bULL, 0x000ea80000004200ULL, 0x000000000350783bULL, 0x0006a80000004200ULL,
0x000000000254783bULL, 0x0006a80000004200ULL, 0x000000000058783bULL, 0x0008a20000004200ULL,
0x0000030064037a10ULL, 0x008fe20007ffe0ffULL, 0x0000580065027a24ULL, 0x020fe200078e02ffULL,
0x0000005d10108231ULL, 0x010fc400003400ffULL, 0x0000000103007810ULL, 0x000fe20007ffe0ffULL,
0x0000005d12128231ULL, 0x000fe400003400ffULL, 0x0000000e11118231ULL, 0x080fe200003400ffULL,
0x000000170000720cULL, 0x000fe20003f26070ULL, 0x0000000e13138231ULL, 0x000fe200003400ffULL,
0x0000004002007824ULL, 0x000fcc00078e00ffULL, 0x0000001c1038723cULL, 0x000fe20000041838ULL,
0x0000005d2c2c8231ULL, 0x082fe400003400ffULL, 0x0000005d2e2e8231ULL, 0x000fe400003400ffULL,
0x0000000e2d2d8231ULL, 0x000fc600003400ffULL, 0x000000201040723cULL, 0x000fe20000041840ULL,
0x0000000e2f2f8231ULL, 0x000fce00003400ffULL, 0x00000024104c723cULL, 0x040ff0000004184cULL,
0x0000001e101c723cULL, 0x040ff0000004183cULL, 0x000000221020723cULL, 0x040ff00000041844ULL,
0x000000261024723cULL, 0x040ff00000041848ULL, 0x000000281034723cULL, 0x040ff00000041834ULL,
0x0000002a1010723cULL, 0x000ff00000041818ULL, 0x000000302c38723cULL, 0x044ff00000041838ULL,
0x000000322c1c723cULL, 0x040ff0000004181cULL, 0x000000502c40723cULL, 0x040ff00000041840ULL,
0x000000522c20723cULL, 0x040ff00000041820ULL, 0x000000542c4c723cULL, 0x040ff0000004184cULL,
0x000000562c24723cULL, 0x040ff00000041824ULL, 0x000000582c34723cULL, 0x040ff00000041834ULL,
0x0000005a2c10723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000070000009947ULL, 0x000fea0003800000ULL, 0x00000003ff0a7819ULL, 0x000fe20000011604ULL,
0x0000010003037824ULL, 0x000fe400078e00ffULL, 0x00000001681b7824ULL, 0x000fe200078e020dULL,
0x000000040a0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000004005097824ULL, 0x000fe200078e020aULL,
0x0000000360027217ULL, 0x000fe40007800000ULL, 0x000000040e0b7212ULL, 0x040fe200078e3cffULL,
0x000000080e187824ULL, 0x000fe200078e00ffULL, 0x0000000009077210ULL, 0x000fe20007f3e0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a03ULL, 0x000000070a037812ULL, 0x000fc400078e4804ULL,
0xfffffff818197812ULL, 0x000fe200078ee20bULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x000000080a147810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff8030b7812ULL, 0x000fe400078ef804ULL,
0x0000000409037810ULL, 0x000fe20007ffe0ffULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0x00005e0007067a11ULL, 0x000fe400078248ffULL, 0x00000020020d7817ULL, 0x000fc40003800000ULL,
0x0000000003037210ULL, 0x000fe40007f5e0ffULL, 0x00000004140f7212ULL, 0x000fe400078e3cffULL,
0x00005f0007077a11ULL, 0x000fe200008f4c08ULL, 0x000000ffff087224ULL, 0x000fe200010e06ffULL,
0x0000000c0a187810ULL, 0x040fe40007ffe0ffULL, 0x0000000d0a00720cULL, 0x040fe20003f26070ULL,
0x000000101b067825ULL, 0x000fe200078e0006ULL, 0x000000140a2a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81a2b7812ULL, 0x000fe200078ee20fULL, 0x00000008182c7824ULL, 0x040fe200078e00ffULL,
0x00005e0003027a11ULL, 0x000fe200078448ffULL, 0x000000100b0f7824ULL, 0x100fe200078e020cULL,
0x0000000418157212ULL, 0x080fe200078e3cffULL, 0x000000082a2e7824ULL, 0x000fe200078e00ffULL,
0x00000008090b7810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e020cULL,
0x000000100a1a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c901c46ULL, 0x000000042a297212ULL, 0x000fc400078e3cffULL,
0x00005f0003037a11ULL, 0x000fe200010f4c08ULL, 0x000000081a2f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2d7812ULL, 0x000fe400078ee215ULL, 0x000000000b087210ULL, 0x000fe20007f5e0ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x0000000c09157810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82e337812ULL, 0x000fe200078ee229ULL, 0x000000ffff077224ULL, 0x002fe200010e06ffULL,
0x000000041a287212ULL, 0x000fe200078e3cffULL, 0x000000102d2d7824ULL, 0x100fe200078e020cULL,
0x0000001009297810ULL, 0x000fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e020cULL,
0x0000001409317810ULL, 0x000fc40007ffe0ffULL, 0x00000018093d7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c093f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000015097210ULL, 0x000fe40007f7e0ffULL,
0x00005e0008067a11ULL, 0x000fe400078c48ffULL, 0xfffffff82f2f7812ULL, 0x000fe400078ee228ULL,
0x000000180a287810ULL, 0x000fc40007ffe0ffULL, 0x0000001c0a2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x00000000290b7210ULL, 0x080fe20007f3e0ffULL,
0x0000000828307824ULL, 0x000fe200078e00ffULL, 0x00005f0008077a11ULL, 0x000fe200030f4c07ULL,
0x000000102f2f7824ULL, 0x000fe200078e020cULL, 0x00005e0009087a11ULL, 0x000fe400078c48ffULL,
0x0000000d0e00720cULL, 0x000fe20003f66070ULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00000000310f7210ULL, 0x000fe20007f9e0ffULL, 0x000000101b067825ULL, 0x000fe200078e0006ULL,
0x0000000428297212ULL, 0x000fc400078e3cffULL, 0x00005f0009097a11ULL, 0x000fe400030f4c0aULL,
0x00005e000b0a7a11ULL, 0x000fe400078c48ffULL, 0xfffffff830317812ULL, 0x000fe200078ee229ULL,
0x0000001019297824ULL, 0x000fe200078e020cULL, 0x0000000d1400720cULL, 0x000fe20003f26070ULL,
0x000000ffff147224ULL, 0x000fe200020e06ffULL, 0x000000003d157210ULL, 0x080fe20007fbe0ffULL,
0x000000082c3d7824ULL, 0x000fe200078e00ffULL, 0x00005f000b0b7a11ULL, 0x000fe200030f4c0eULL,
0x0000000002297faeULL, 0x0003e2000d901c46ULL, 0x000000003f007210ULL, 0x000fe20007f5e0ffULL,
0x000000101b087825ULL, 0x000fe200078e0008ULL, 0x00005e000f0e7a11ULL, 0x000fc400078c48ffULL,
0x0000000d1a00720cULL, 0x080fe20003f86070ULL, 0x000000ffff1a7224ULL, 0x000fe200028e06ffULL,
0x00005f000f0f7a11ULL, 0x000fe200030f4c14ULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x0000000d1800720cULL, 0x080fe20003f66070ULL, 0x0000001031317824ULL, 0x000fe200078e020cULL,
0x00005e0015147a11ULL, 0x000fe200078a48ffULL, 0x000000101b027825ULL, 0x042fe200078e000aULL,
0x00005e0000187a11ULL, 0x000fe200078c48ffULL, 0x00000000062b7faeULL, 0x0003e2000c901c46ULL,
0x000000042c2e7212ULL, 0x000fe200078e3cffULL, 0x000000101b0a7825ULL, 0x000fe200078e000eULL,
0x0000000d2a00720cULL, 0x000fc40003f46070ULL, 0x00005f0015157a11ULL, 0x000fe400028f4c1aULL,
0x0000000d2800720cULL, 0x080fe20003fa6070ULL, 0x00000000082d7faeULL, 0x0003e2000d901c46ULL,
0x00005f0000197a11ULL, 0x000fe400030f4c19ULL, 0x0000000d2c00720cULL, 0x000fe20003fc6070ULL,
0x00000000022f7faeULL, 0x0003e2000e101c46ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee22eULL,
0x000000101b0e7825ULL, 0x000fe400078e0018ULL, 0x000000000a337faeULL, 0x0003e4000d101c46ULL,
0x000000103d3d7824ULL, 0x000fc400078e020cULL, 0x000000101b0c7825ULL, 0x000fca00078e0014ULL,
0x000000000c317faeULL, 0x0003e8000e901c46ULL, 0x000000000e3d7faeULL, 0x0003e2000f101c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x000fc80000011604ULL,
0x0000000408037810ULL, 0x040fe40007ffe0ffULL, 0x0000000808077810ULL, 0x040fe40007ffe0ffULL,
0x0000000c08097810ULL, 0x040fe20007ffe0ffULL, 0x0000000803157824ULL, 0x040fe200078e00ffULL,
0x0000000403027212ULL, 0x080fe200078e3cffULL, 0x00000008070a7824ULL, 0x040fe200078e00ffULL,
0x0000000407037212ULL, 0x080fe200078e3cffULL, 0x00000008092f7824ULL, 0x040fe200078e00ffULL,
0x0000000409067212ULL, 0x000fe200078e3cffULL, 0x0000004005097824ULL, 0x000fe200078e0208ULL,
0x0000001008077810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80a197812ULL, 0x000fe400078ee203ULL,
0x0000001408037810ULL, 0x000fe20007ffe0ffULL, 0x0000000807317824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe400078ee202ULL, 0x0000000407027212ULL, 0x000fe200078e3cffULL,
0x0000000803337824ULL, 0x000fe200078e00ffULL, 0x0000000409077810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fc400078ee206ULL, 0x0000000403067212ULL, 0x000fe400078e3cffULL,
0x0000000009037210ULL, 0x080fe20007f3e0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e020cULL,
0x00000000070e7210ULL, 0x000fe40007f5e0ffULL, 0xfffffff833337812ULL, 0x000fe200078ee206ULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0xfffffff831317812ULL, 0x000fe200078ee202ULL,
0x000000ffff0f7224ULL, 0x000fe200010e06ffULL, 0x00005e0003067a11ULL, 0x000fe200078248ffULL,
0x0000001033337824ULL, 0x100fe200078e020cULL, 0x00005e000e027a11ULL, 0x000fe200078448ffULL,
0x0000001031317824ULL, 0x000fe200078e020cULL, 0x00005f0003077a11ULL, 0x000fc400008f4c0aULL,
0x00005f000e037a11ULL, 0x000fe400010f4c0fULL, 0x00000008090f7810ULL, 0x000fe40007ffe0ffULL,
0x00000018080b7810ULL, 0x040fe40007ffe0ffULL, 0x000000000f0f7210ULL, 0x000fe40007f9e0ffULL,
0x0000000c091b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b3d7824ULL, 0x040fe200078e00ffULL,
0x0000001c083f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x000000040b147212ULL, 0x000fc400078e3cffULL, 0x0000001009297810ULL, 0x040fe40007ffe0ffULL,
0x00000014092b7810ULL, 0x040fe40007ffe0ffULL, 0x00000018092d7810ULL, 0x040fe40007ffe0ffULL,
0x00000007080b7812ULL, 0x000fe400078e4804ULL, 0x0000001c09097810ULL, 0x000fe40007ffe0ffULL,
0x000000001b1b7210ULL, 0x000fc40007f5e0ffULL, 0x000000043f0e7212ULL, 0x040fe200078e3cffULL,
0x000000083f3f7824ULL, 0x000fe200078e00ffULL, 0x00005e000f087a11ULL, 0x000fe400078c48ffULL,
0x0ffffff80b0b7812ULL, 0x000fe400078ef804ULL, 0x00000000291a7210ULL, 0x080fe40007f7e0ffULL,
0x000000002b287210ULL, 0x080fe20007f3e0ffULL, 0x000000100b297824ULL, 0x100fe200078e020cULL,
0x000000002d2a7210ULL, 0x080fe20007f9e0ffULL, 0x00000010152b7824ULL, 0x000fe200078e020cULL,
0x00000000092c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005f000f097a11ULL, 0x000fe200030f4c0aULL, 0x00000010192d7824ULL, 0x000fe200078e020cULL,
0x00005e001b0a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee214ULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20eULL, 0x000000ffff197224ULL, 0x000fe200028e06ffULL,
0x00005f001b0b7a11ULL, 0x000fe200010f4c00ULL, 0x00000001681b7824ULL, 0x000fe200078e020dULL,
0x00005e00280e7a11ULL, 0x000fe200078248ffULL, 0x000000103d3d7824ULL, 0x100fe200078e020cULL,
0x00005e002c187a11ULL, 0x000fe200078848ffULL, 0x000000103f3f7824ULL, 0x000fe200078e020cULL,
0x00005e001a0c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e06ffULL,
0x00005e002a147a11ULL, 0x000fe200078648ffULL, 0x000000101b067825ULL, 0x000fe200078e0006ULL,
0x00005f00280f7a11ULL, 0x000fc400008f4c0fULL, 0x00005f001a0d7a11ULL, 0x000fe200010f4c0dULL,
0x000000101b027825ULL, 0x040fe200078e0002ULL, 0x00005f002a157a11ULL, 0x000fe200018f4c15ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006297faeULL, 0x0003e2000b901c46ULL,
0x00005f002c197a11ULL, 0x000fe200020f4c19ULL, 0x000000101b087825ULL, 0x040fe400078e0008ULL,
0x00000000022b7faeULL, 0x0003e4000b901c46ULL, 0x000000101b0a7825ULL, 0x040fe400078e000aULL,
0x00000000082d7faeULL, 0x0003e4000b901c46ULL, 0x000000101b0c7825ULL, 0x000fc400078e000cULL,
0x000000000a2f7faeULL, 0x0003e4000b901c46ULL, 0x000000101b0e7825ULL, 0x040fe400078e000eULL,
0x000000000c317faeULL, 0x0003e4000b901c46ULL, 0x000000101b147825ULL, 0x040fe400078e0014ULL,
0x000000000e337faeULL, 0x0003e4000b901c46ULL, 0x000000101b187825ULL, 0x000fc400078e0018ULL,
0x00000000143d7faeULL, 0x0003e8000b901c46ULL, 0x00000000183f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000b80071087811ULL, 0x002fe400078e20ffULL,
0x0000005cff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe40000011604ULL,
0x0000541000007816ULL, 0x000fc40000000000ULL, 0x0000b8006c187811ULL, 0x000fc600078e20ffULL,
0x00001f0300037589ULL, 0x000fe800000e0000ULL, 0x00001f1600167589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000808783bULL, 0x000e680000000200ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000006f0c783bULL, 0x000fe80000004200ULL,
0x000000006e28783bULL, 0x000fe80000004200ULL, 0x000000006d2c783bULL, 0x000fe80000004200ULL,
0x000000001818783bULL, 0x000ee80000000200ULL, 0x000000006b3c783bULL, 0x000f280000004200ULL,
0x000000006a44783bULL, 0x000f680000004200ULL, 0x000000006948783bULL, 0x000f280000004200ULL,
0x000000006730783bULL, 0x000f220000004200ULL, 0x0000000308088231ULL, 0x002fc400003400ffULL,
0x000000030a0a8231ULL, 0x000fe400003400ffULL, 0x0000001609098231ULL, 0x080fe400003400ffULL,
0x000000160b0b8231ULL, 0x000fce00003400ffULL, 0x000000700838723cULL, 0x004fe20000041838ULL,
0x0000000318188231ULL, 0x008fce00003400ffULL, 0x0000000c0840723cULL, 0x000fe20000041840ULL,
0x000000031a1a8231ULL, 0x000fe400003400ffULL, 0x0000001619198231ULL, 0x080fe400003400ffULL,
0x000000161b1b8231ULL, 0x000fc600003400ffULL, 0x00000028084c723cULL, 0x040ff0000004184cULL,
0x00000072081c723cULL, 0x040ff0000004181cULL, 0x0000000e0820723cULL, 0x040ff00000041820ULL,
0x0000002a0824723cULL, 0x040ff00000041824ULL, 0x0000002c0834723cULL, 0x040ff00000041834ULL,
0x0000002e0810723cULL, 0x000ff00000041810ULL, 0x0000003c1838723cULL, 0x050ff00000041838ULL,
0x000000441840723cULL, 0x060ff00000041840ULL, 0x00000048184c723cULL, 0x040ff0000004184cULL,
0x0000003e183c723cULL, 0x040ff0000004181cULL, 0x000000461844723cULL, 0x040ff00000041820ULL,
0x0000004a1848723cULL, 0x040ff00000041824ULL, 0x000000301834723cULL, 0x040ff00000041834ULL,
0x000000321818723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0146a000ffff7f8cULL, 0x000fe4000c80043fULL,
0x0000030064647a10ULL, 0x000fc80007ffe0ffULL, 0x000000176400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff5b4000007947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000e640000002500ULL, 0x000000170500720cULL, 0x002fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x018000005f007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff277224ULL, 0x000fe200078e005fULL, 0x0000bb9000287802ULL, 0x000fe40000000f00ULL,
0x0000e53000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000005f00007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc8000000005fULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ee80000000000ULL, 0x0000000000027919ULL, 0x000f220000000000ULL,
0x0000000803037811ULL, 0x008fe400078ff0ffULL, 0x00000002ff077819ULL, 0x010fc80000011602ULL,
0x00001f0300037589ULL, 0x000ee800000e0000ULL, 0x00001f0700027589ULL, 0x000f2200000e0000ULL,
0x0000003a033a7220ULL, 0x048fe20000410000ULL, 0x0000003b033b7220ULL, 0x040fe20000410000ULL,
0x0000003e033e7220ULL, 0x040fe20000410000ULL, 0x0000003f033f7220ULL, 0x040fe20000410000ULL,
0x0000003802387220ULL, 0x050fe20000410000ULL, 0x0000003902397220ULL, 0x040fe20000410000ULL,
0x0000003c023c7220ULL, 0x040fe20000410000ULL, 0x0000003d023d7220ULL, 0x040fe20000410000ULL,
0x0000004002407220ULL, 0x040fe20000410000ULL, 0x0000004102417220ULL, 0x040fe20000410000ULL,
0x0000004402447220ULL, 0x040fe20000410000ULL, 0x0000004502457220ULL, 0x040fe20000410000ULL,
0x0000004c024c7220ULL, 0x040fe20000410000ULL, 0x0000004d024d7220ULL, 0x040fe20000410000ULL,
0x0000004802487220ULL, 0x040fe20000410000ULL, 0x0000004902497220ULL, 0x040fe20000410000ULL,
0x0000003402347220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000001802187220ULL, 0x040fe20000410000ULL, 0x0000001902197220ULL, 0x000fe20000410000ULL,
0x0000004203427220ULL, 0x040fe20000410000ULL, 0x0000004303437220ULL, 0x040fe20000410000ULL,
0x0000004603467220ULL, 0x040fe20000410000ULL, 0x0000004703477220ULL, 0x040fe20000410000ULL,
0x0000004e034e7220ULL, 0x040fe20000410000ULL, 0x0000004f034f7220ULL, 0x040fe20000410000ULL,
0x0000004a034a7220ULL, 0x040fe20000410000ULL, 0x0000004b034b7220ULL, 0x040fe20000410000ULL,
0x0000003603367220ULL, 0x040fe20000410000ULL, 0x0000003703377220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x000fc40000410000ULL,
0x00000000001c7919ULL, 0x000ee20000000000ULL, 0x00000018190b723eULL, 0x000fc400000010ffULL,
0x0000001a1b13723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000383903723eULL, 0x000fe400000010ffULL, 0x0000003c3d04723eULL, 0x000fe400000010ffULL,
0x000000404106723eULL, 0x000fe400000010ffULL, 0x000000444507723eULL, 0x000fe400000010ffULL,
0x0000004c4d08723eULL, 0x000fc400000010ffULL, 0x000000484909723eULL, 0x000fe400000010ffULL,
0x00000034350a723eULL, 0x000fe400000010ffULL, 0x0000003a3b0c723eULL, 0x000fe400000010ffULL,
0x0000003e3f0d723eULL, 0x000fe400000010ffULL, 0x00000042430e723eULL, 0x000fe400000010ffULL,
0x00000002ff217819ULL, 0x008fc4000001161cULL, 0x000000081c2f7811ULL, 0x000fe400078ff0ffULL,
0x00000021ff237212ULL, 0x000fe200078e33ffULL, 0x0000000821147824ULL, 0x000fe200078e00ffULL,
0x0000002fff317212ULL, 0x000fe200078e33ffULL, 0x000000082f167824ULL, 0x000fe200078e00ffULL,
0x0000000721007812ULL, 0x040fe200078ec0ffULL, 0x0000000821027824ULL, 0x000fe200078e00ffULL,
0xfffffff814237812ULL, 0x000fe400078ee223ULL, 0xfffffff816317812ULL, 0x000fc400078ee231ULL,
0xfffffff802157812ULL, 0x000fe400078ee221ULL, 0x0000000100027812ULL, 0x040fe400078e3cffULL,
0x0000000200147812ULL, 0x040fe400078e3cffULL, 0x0000000300167812ULL, 0x040fe200078e3cffULL,
0x0000000821177824ULL, 0x040fe200078e0202ULL, 0x0000000400187812ULL, 0x040fe200078e3cffULL,
0x0000000821197824ULL, 0x040fe200078e0214ULL, 0x00000005001a7812ULL, 0x040fe200078e3cffULL,
0x00000008211b7824ULL, 0x040fe200078e0216ULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x00000008211d7824ULL, 0x000fe200078e0218ULL, 0x000000072f167812ULL, 0x000fe200078ec0ffULL,
0x00000008211f7824ULL, 0x000fe200078e021aULL, 0x00000046470f723eULL, 0x000fe200000010ffULL,
0x0000000821217824ULL, 0x000fe200078e0200ULL, 0x00000002161a7812ULL, 0x000fe200078e3cffULL,
0x0000080062007824ULL, 0x000fe200078e00ffULL, 0x00000004161e7812ULL, 0x000fe200078e3cffULL,
0x000000041c147824ULL, 0x000fe200078e00ffULL, 0x00000003161c7812ULL, 0x000fe200078e3cffULL,
0x000000082f187824ULL, 0x040fe200078e00ffULL, 0x0000a00000027810ULL, 0x000fe20007ffe0ffULL,
0x000000082f297824ULL, 0x040fe200078e021aULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x000000082f2b7824ULL, 0x000fe200078e021cULL, 0xfffffff818257812ULL, 0x000fe200078ee22fULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x0000000116187812ULL, 0x040fe200078e3cffULL,
0x0000001017177824ULL, 0x100fe200078e0202ULL, 0x0000000516207812ULL, 0x040fe200078e3cffULL,
0x0000001019197824ULL, 0x000fe200078e0202ULL, 0x0000000616227812ULL, 0x000fe200078e3cffULL,
0x0000000115167824ULL, 0x000fe200078e0214ULL, 0x0000004e4f10723eULL, 0x000fe200000010ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x0000004a4b11723eULL, 0x000fe200000010ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0202ULL, 0x0000000316007388ULL, 0x0007e20000000800ULL,
0x000000082f277824ULL, 0x002fe200078e0218ULL, 0x000000363712723eULL, 0x000fe200000010ffULL,
0x000000101f1f7824ULL, 0x000fc400078e0202ULL, 0x0000000114177824ULL, 0x040fe400078e0217ULL,
0x0000001021217824ULL, 0x100fe400078e0202ULL, 0x0000000114197824ULL, 0x040fe200078e0219ULL,
0x0000000417007388ULL, 0x0003e20000000800ULL, 0x0000001023237824ULL, 0x000fe400078e0202ULL,
0x0000000114167824ULL, 0x008fe200078e021bULL, 0x0000000619007388ULL, 0x0003e20000000800ULL,
0x000000082f157824ULL, 0x000fc400078e021eULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x0000000716007388ULL, 0x0003e20000000800ULL, 0x00000001141d7824ULL, 0x040fe400078e021dULL,
0x00000001ff037424ULL, 0x000fe400078e00ffULL, 0x000000082f2d7824ULL, 0x000fe200078e0220ULL,
0x000000081d007388ULL, 0x0003e20000000800ULL, 0x0000001027277824ULL, 0x000fe200078e0202ULL,
0x0000030003007a0cULL, 0x000fe20003f05270ULL, 0x0000000114187824ULL, 0x000fc400078e021fULL,
0x000000082f2f7824ULL, 0x000fe400078e0222ULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x0000000918007388ULL, 0x0003e20000000800ULL, 0x0000000114217824ULL, 0x040fe400078e0221ULL,
0x00000001141a7824ULL, 0x040fe400078e0223ULL, 0x000000102b2b7824ULL, 0x000fe200078e0202ULL,
0x0000000a21007388ULL, 0x0003e20000000800ULL, 0x0000000114257824ULL, 0x000fc400078e0225ULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x0000000b1a007388ULL, 0x0003e20000000800ULL,
0x000000102d2d7824ULL, 0x100fe400078e0202ULL, 0x00000001141c7824ULL, 0x040fe200078e0227ULL,
0x0000000c25007388ULL, 0x0003e20000000800ULL, 0x000000102f2f7824ULL, 0x100fe400078e0202ULL,
0x0000000114297824ULL, 0x000fe200078e0229ULL, 0x0000000d1c007388ULL, 0x0003e20000000800ULL,
0x0000001031317824ULL, 0x000fc400078e0202ULL, 0x00000001141e7824ULL, 0x040fe200078e022bULL,
0x0000000e29007388ULL, 0x0003e20000000800ULL, 0x0000000114157824ULL, 0x040fe400078e0215ULL,
0x0000000114207824ULL, 0x040fe200078e022dULL, 0x0000000f1e007388ULL, 0x0003e20000000800ULL,
0x00000001142f7824ULL, 0x040fe400078e022fULL, 0x0000000114227824ULL, 0x000fe200078e0231ULL,
0x0000001015007388ULL, 0x0003e80000000800ULL, 0x0000001120007388ULL, 0x0003e80000000800ULL,
0x000000122f007388ULL, 0x0003e80000000800ULL, 0x0000001322007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002bb000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ee20000000000ULL, 0x00005800ff067624ULL, 0x002fe200078e00ffULL,
0x000000ff6200720cULL, 0x000fe40003f25270ULL, 0x0000000000107919ULL, 0x000e620000002700ULL,
0x0000030006067a24ULL, 0x000fc600078e02ffULL, 0x0000000000077919ULL, 0x000e620000002600ULL,
0x0000660006087a24ULL, 0x000fe400078e02ffULL, 0x0000001003097824ULL, 0x048fe200078e0200ULL,
0x00000020030f7810ULL, 0x040fe40007ffe0ffULL, 0x000000ff0300720cULL, 0x000fe40003f05270ULL,
0x00a0000009147984ULL, 0x0007240000000c00ULL, 0x000000ff6200720cULL, 0x000fe20000705670ULL,
0x0000580010107a24ULL, 0x002fe200078e0207ULL, 0x00a2000009187984ULL, 0x0006620000000c00ULL,
0x00001000ff077424ULL, 0x000fc400078e00ffULL, 0x0000030010047a24ULL, 0x000fc800078e02ffULL,
0x00000001040a7824ULL, 0x000fe200078e0205ULL, 0x00000fff08057811ULL, 0x000fc800078e40ffULL,
0x0000000a05067211ULL, 0x000fca00078fa0ffULL, 0x00006c0006067625ULL, 0x000fcc00078e0007ULL,
0x0000040062067825ULL, 0x000fcc00078e0006ULL, 0x000000100f0e7825ULL, 0x000fc800078e0006ULL,
0x00000010030c7825ULL, 0x000fe200078e0006ULL, 0x01ffffff08077812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x008ee20000000000ULL,
0x00000080ff067424ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe400078e0207ULL,
0x0000001008117824ULL, 0x008fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011608ULL,
0x00006c000a087625ULL, 0x000fc600078e0006ULL, 0x0000007011117812ULL, 0x000fe200078ec0ffULL,
0x00006c000b0a7625ULL, 0x000fe200078e0006ULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000812087210ULL, 0x140fe40007b5e011ULL, 0x0000000a120a7210ULL, 0x000fe40007d9e011ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000006308007986ULL, 0x0007e8000c101906ULL, 0x0000005f0a007986ULL, 0x0007e4000c101906ULL,
0x000000140c007986ULL, 0x0187e2000c101d06ULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x000000180e007986ULL, 0x0027e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000004ff097424ULL, 0x000fc600078e00ffULL, 0x000003000b0b7a10ULL, 0x000fe20007ffe1ffULL,
0x00006a0010087625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000b080879a8ULL, 0x000f2400099ee1c6ULL,
0x0000000b0800720cULL, 0x010fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff067807ULL, 0x000fca0000000000ULL, 0x00000006ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x002e640000000000ULL, 0x000000ff0600720cULL, 0x002fda0003f05270ULL,
0x000027a000008947ULL, 0x000fea0003800000ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x00000001ff087819ULL, 0x000fe20000011603ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001040a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff177424ULL, 0x008fe200078e00ffULL,
0x0000000c080c7812ULL, 0x000fe400078ec0ffULL, 0x0000007006197812ULL, 0x000fe200078ec0ffULL,
0x00006c0004087625ULL, 0x000fc800078e0017ULL, 0x00006c000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x0000000a0c0a7210ULL, 0x000fe40007b5e019ULL,
0x00000009ff097210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x0000000608067981ULL, 0x000368000c1e1900ULL, 0x000000060a0d7981ULL, 0x000362000c1e1900ULL,
0x00000300ff0e7624ULL, 0x000fca00078e00ffULL, 0x000000020e00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000040e00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000040e00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608137981ULL, 0x000362000c1e1900ULL,
0x000000060e00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608157981ULL, 0x000362000c1e1900ULL, 0x000000060e00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080e00780cULL, 0x002fe40003f06070ULL,
0x0000000604087810ULL, 0x000fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fe40007a3e019ULL, 0x00000007040a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006c000a0a0625ULL, 0x000fe400078e0017ULL,
0x0000000608177981ULL, 0x000366000c1e1900ULL, 0x0000000a0c0a0210ULL, 0x000fc80007c7e019ULL,
0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL, 0x000000060a0b0981ULL, 0x000366000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x028fe400078e0006ULL,
0x000000ffff127224ULL, 0x000fc600078e00ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000112127810ULL, 0x000fc80007ffe0ffULL, 0x0000000412007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000810087810ULL, 0x040fe40007ffe0ffULL,
0x0000000110097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001906067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000080a087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c197812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e019ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608197981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000910087810ULL, 0x042fe40007ffe0ffULL, 0x0000000210097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000090a087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c0d7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a10087810ULL, 0x042fe40007ffe0ffULL,
0x0000000310097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a0a087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c0f7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000410097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b0a087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c117812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c10087810ULL, 0x042fe40007ffe0ffULL,
0x0000000510097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c0a087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c137812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000610097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d0a087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c157812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e015ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e10087810ULL, 0x042fe40007ffe0ffULL,
0x0000000710097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e0a087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c177812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e017ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f10087810ULL, 0x002fe40007ffe0ffULL, 0x0000000b06067209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f0a087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00000010030b7824ULL, 0x000fe400078e00ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080c087210ULL, 0x000fc80007a3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080b7981ULL, 0x000368000c1e1900ULL,
0x0000000810107810ULL, 0x000fe40007ffe0ffULL, 0x000000080a0a7810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x0000001003087824ULL, 0x012fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011603ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108097824ULL, 0x000fca00078e0209ULL, 0x0000000609007388ULL, 0x0203e40000000800ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000001ff087819ULL, 0x000fe20000011603ULL, 0x00001000ff0a7424ULL, 0x000fe200078e00ffULL,
0x0000000405297211ULL, 0x000fe200078fa0ffULL, 0x0000001003067824ULL, 0x042fe200078e00ffULL,
0x0000000c08057812ULL, 0x000fe200078ec0ffULL, 0x0000000104287824ULL, 0x000fe200078e0207ULL,
0x00000020030d7810ULL, 0x008fe20007ffe0ffULL, 0x00006c0029087625ULL, 0x000fe200078e000aULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff0b8424ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000040062087825ULL, 0x000fe200078e0008ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000080ff178424ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000106057824ULL, 0x000fe200078e0205ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000100062067824ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00006c00280a8625ULL, 0x000fc400078e000bULL,
0x0000000005057984ULL, 0x000e640000000800ULL, 0x0000001062118824ULL, 0x000fe400078e0203ULL,
0x00006c0004168625ULL, 0x000fc600078e0017ULL, 0x0000458011118811ULL, 0x000fe200078e20ffULL,
0x0000001062158824ULL, 0x000fe400078e0203ULL, 0x000000100d0c7825ULL, 0x000fc600078e0008ULL,
0x0000418015158811ULL, 0x000fe200078e20ffULL, 0x00000010030f7824ULL, 0x040fe400078e0206ULL,
0x0000001003087825ULL, 0x000fc800078e0008ULL, 0x0000001003128825ULL, 0x040fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000080f7faeULL, 0x0007e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000001003168825ULL, 0x000fe200078e0016ULL,
0x003800000c0f7faeULL, 0x0009e6000b901c46ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000012118faeULL, 0x000be8000b901c46ULL, 0x0000000016158faeULL, 0x0005e2000b901c46ULL,
0x0000000000087805ULL, 0x008fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x010fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x020fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x004fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000d1000009947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x002fe20007ffe0ffULL,
0x00000001ff2a7424ULL, 0x000fe200078e00ffULL, 0x0000000129297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000104047810ULL, 0x000fc40007ffe0ffULL,
0x000003002a007a0cULL, 0x000fda0003f06070ULL, 0x000001f000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x00001000ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000012a2f7812ULL, 0x040fe200078ec0ffULL, 0x000008002a2b7824ULL, 0x000fe200078e00ffULL,
0x0000002003377810ULL, 0x000fe20007ffe0ffULL, 0x00006c00292c7625ULL, 0x000fc600078e002cULL,
0x000008002b2b7812ULL, 0x000fc600078ec0ffULL, 0x00000400622c7825ULL, 0x000fc800078e002cULL,
0x0000000262308824ULL, 0x140fe400078e022fULL, 0x0000000262328824ULL, 0x000fe400078e022fULL,
0x00000080ff318424ULL, 0x000fe400078e00ffULL, 0x00000080ff338424ULL, 0x000fe400078e00ffULL,
0x00000001062e7824ULL, 0x000fe400078e022bULL, 0x0000000830358824ULL, 0x000fc400078e0203ULL,
0x0000000832348824ULL, 0x000fe400078e0203ULL, 0x00006c0028308625ULL, 0x000fe200078e0031ULL,
0x0000458035358811ULL, 0x000fc600078e20ffULL, 0x00006c0004328625ULL, 0x000fc800078e0033ULL,
0x00000010032b7824ULL, 0x000fe400078e022eULL, 0x00000010372e7825ULL, 0x000fe200078e002cULL,
0x0000418034378811ULL, 0x000fc600078e20ffULL, 0x00000010032c7825ULL, 0x000fc800078e002cULL,
0x0000001003308825ULL, 0x040fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002c2b7faeULL, 0x0003e6000b901c46ULL, 0x0000001003328825ULL, 0x000fe200078e0032ULL,
0x003800002e2b7faeULL, 0x0003e8000b901c46ULL, 0x0000000030358faeULL, 0x0003e8000b901c46ULL,
0x0000000032378faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff2a2b7810ULL, 0x002fe20007ffe0ffULL, 0x00000010032e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff2f7819ULL, 0x000fc40000011603ULL, 0x00000002ff337819ULL, 0x000fe20000011603ULL,
0x000000802b2c7824ULL, 0x040fe200078e00ffULL, 0x000000702e2e7812ULL, 0x000fe200078ec0ffULL,
0x000008002b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000c2f2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000833357824ULL, 0x040fe200078e00ffULL, 0x000000802c2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000833317824ULL, 0x040fe200078e00ffULL, 0x00000033ff2c7212ULL, 0x000fe400078e33ffULL,
0x00000007333a7812ULL, 0x040fe200078ec0ffULL, 0x00000100622d7824ULL, 0x000fe200078e022dULL,
0x0000000833377810ULL, 0x000fc40007ffe0ffULL, 0xfffffff835467812ULL, 0x000fe200078ee22cULL,
0x0000000403357824ULL, 0x000fe200078e00ffULL, 0x0000002d2f2f7210ULL, 0x000fe20007ffe02eULL,
0x00000008332d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8312c7812ULL, 0x000fe200078ee23aULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002f387984ULL, 0x000e620000000800ULL,
0x0000000837317824ULL, 0x000fe200078e00ffULL, 0x000000012d2e7812ULL, 0x100fe200078ef63aULL,
0x00000008373c7824ULL, 0x000fe200078e00ffULL, 0x004580002f4a7984ULL, 0x0002a20000000800ULL,
0x000000022d307812ULL, 0x140fe400078ef63aULL, 0x000000032d327812ULL, 0x140fe400078ef63aULL,
0x000000042d347812ULL, 0x140fe400078ef63aULL, 0x000000052d367812ULL, 0x000fc400078ef63aULL,
0x00000037ff487212ULL, 0x000fe400078e33ffULL, 0x000008002b2b7812ULL, 0x000fe400078ec0ffULL,
0xfffffff831487812ULL, 0x000fe400078ee248ULL, 0x00000180062b7810ULL, 0x000fe40007ffe02bULL,
0x0000000c35357812ULL, 0x000fe400078ec0ffULL, 0x000003002a007a0cULL, 0x000fe20003f06070ULL,
0x000000102c2c7824ULL, 0x100fe200078e022bULL, 0x000000012a2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000102e2e7824ULL, 0x100fe200078e022bULL, 0x0000000128287810ULL, 0x000fe20007ffe0ffULL,
0x00000001352c7824ULL, 0x000fe200078e022cULL, 0x0000000129297810ULL, 0x000fe20007ffe0ffULL,
0x00000001352e7824ULL, 0x000fe200078e022eULL, 0x0000000104047810ULL, 0x000fe20007ffe0ffULL,
0x0000001030307824ULL, 0x000fc400078e022bULL, 0x0000001032327824ULL, 0x100fe400078e022bULL,
0x0000000135307824ULL, 0x000fe200078e0230ULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x0000001034347824ULL, 0x000fe200078e022bULL, 0x00000038052f7221ULL, 0x002fe20000010100ULL,
0x000000062d387812ULL, 0x000fe200078ef63aULL, 0x00000008373a7824ULL, 0x000fe200078e00ffULL,
0x0000000030307984ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2f2d7820ULL, 0x000fe20000410000ULL,
0x00000007372f7812ULL, 0x000fe200078ec0ffULL, 0x0000000135327824ULL, 0x000fc400078e0232ULL,
0x0000002d00317308ULL, 0x0002a20000000800ULL, 0x000000013c3e7812ULL, 0x140fe200078ef62fULL,
0x0000000135347824ULL, 0x040fe200078e0234ULL, 0x000000023c407812ULL, 0x000fe200078ef62fULL,
0x0000001036367824ULL, 0x000fe200078e022bULL, 0x000000033c427812ULL, 0x140fe200078ef62fULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000043c447812ULL, 0x100fe200078ef62fULL,
0x0000000135367824ULL, 0x040fe200078e0236ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee22fULL,
0x00000010462d7824ULL, 0x002fe200078e022bULL, 0x000000053c467812ULL, 0x140fe200078ef62fULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x000000063c3c7812ULL, 0x000fe200078ef62fULL,
0x00000001352d7824ULL, 0x000fe200078e022dULL, 0x0000004a314a7220ULL, 0x004fe20000410000ULL,
0x000000002c2f7984ULL, 0x000e620000000800ULL, 0x0000001038387824ULL, 0x000fc400078e022bULL,
0x000000103a3a7824ULL, 0x000fe200078e022bULL, 0x000000002d317984ULL, 0x000ea20000000800ULL,
0x0000000135387824ULL, 0x000fe200078e0238ULL, 0x000000274a277221ULL, 0x000fe20000010000ULL,
0x000000103e3e7824ULL, 0x100fe200078e022bULL, 0x00001f334a2d7589ULL, 0x000ee200000e0000ULL,
0x0000001040407824ULL, 0x100fe400078e022bULL, 0x0000001042427824ULL, 0x100fe200078e022bULL,
0x0000000036367984ULL, 0x000f220000000800ULL, 0x0000001044447824ULL, 0x000fc400078e022bULL,
0x0000001046467824ULL, 0x100fe200078e022bULL, 0x0000000038387984ULL, 0x000f620000000800ULL,
0x000000103c3c7824ULL, 0x100fe400078e022bULL, 0x0000001048487824ULL, 0x000fe200078e022bULL,
0x00001f374a4a7589ULL, 0x000fe200000e0000ULL, 0x00000001353a7824ULL, 0x040fe400078e023aULL,
0x00000001353e7824ULL, 0x040fe400078e023eULL, 0x0000000135407824ULL, 0x000fc400078e0240ULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x0000000135427824ULL, 0x040fe400078e0242ULL,
0x0000000135447824ULL, 0x040fe200078e0244ULL, 0x000000003e3e7984ULL, 0x000f620000000800ULL,
0x0000000135467824ULL, 0x040fe400078e0246ULL, 0x00000001353c7824ULL, 0x040fe200078e023cULL,
0x0000000040407984ULL, 0x000f620000000800ULL, 0x0000000135487824ULL, 0x000fc600078e0248ULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x00005410ff2c7816ULL, 0x002fc6000000002fULL,
0x0000000044447984ULL, 0x000e620000000800ULL, 0x00005410ff2b7816ULL, 0x004fe20000000031ULL,
0x0000002d2c1f7223ULL, 0x088fe2000001001fULL, 0x00007610ff2c7816ULL, 0x000fe2000000002fULL,
0x0000000046467984ULL, 0x000ea40000000800ULL, 0x0000002d2b207223ULL, 0x080fe20000010020ULL,
0x00007610ff2b7816ULL, 0x000fe20000000031ULL, 0x0000002d2c237223ULL, 0x080fe20000010023ULL,
0x00007610ff2c7816ULL, 0x000fe2000000002eULL, 0x000000003c3c7984ULL, 0x000fe40000000800ULL,
0x0000002d2b107223ULL, 0x080fe20000010010ULL, 0x00005410ff2b7816ULL, 0x000fe2000000002eULL,
0x0000002d2c217223ULL, 0x080fe20000010021ULL, 0x00007610ff2c7816ULL, 0x000fe20000000030ULL,
0x0000000048487984ULL, 0x000ee40000000800ULL, 0x0000002d2b167223ULL, 0x080fe20000010016ULL,
0x00005410ff2b7816ULL, 0x000fe20000000030ULL, 0x0000002d2c097223ULL, 0x000fe20000010009ULL,
0x00007610ff2c7816ULL, 0x000fc60000000034ULL, 0x0000002d2b127223ULL, 0x080fe20000010012ULL,
0x00005410ff2b7816ULL, 0x000fe20000000032ULL, 0x0000002d2c177223ULL, 0x000fe20000010017ULL,
0x00005410ff2c7816ULL, 0x010fc60000000036ULL, 0x0000002d2b1a7223ULL, 0x080fe2000001001aULL,
0x00007610ff2b7816ULL, 0x000fe20000000032ULL, 0x0000002d2c137223ULL, 0x000fe20000010013ULL,
0x00007610ff2c7816ULL, 0x000fc60000000036ULL, 0x0000002d2b0a7223ULL, 0x080fe2000001000aULL,
0x00005410ff2b7816ULL, 0x000fe20000000034ULL, 0x0000002d2c197223ULL, 0x000fe20000010019ULL,
0x00005410ff2c7816ULL, 0x020fc60000000038ULL, 0x0000002d2b087223ULL, 0x080fe20000010008ULL,
0x00007610ff2b7816ULL, 0x000fe20000000038ULL, 0x0000002d2c0f7223ULL, 0x000fe2000001000fULL,
0x00005410ff2c7816ULL, 0x000fc6000000003aULL, 0x0000002d2b147223ULL, 0x000fe20000010014ULL,
0x00005410ff2b7816ULL, 0x000fe2000000003eULL, 0x0000004a2c0d7223ULL, 0x000fe2000001000dULL,
0x00007610ff2c7816ULL, 0x000fc6000000003aULL, 0x0000004a2b1e7223ULL, 0x080fe2000001001eULL,
0x00005410ff2b7816ULL, 0x000fe20000000040ULL, 0x0000004a2c1d7223ULL, 0x000fe2000001001dULL,
0x00007610ff2c7816ULL, 0x000fc6000000003eULL, 0x0000004a2b1c7223ULL, 0x080fe2000001001cULL,
0x00007610ff2b7816ULL, 0x000fe20000000040ULL, 0x0000004a2c1b7223ULL, 0x000fe2000001001bULL,
0x00005410ff2c7816ULL, 0x002fc60000000044ULL, 0x0000004a2b227223ULL, 0x080fe20000010022ULL,
0x00005410ff2b7816ULL, 0x000fe20000000042ULL, 0x0000004a2c157223ULL, 0x000fe20000010015ULL,
0x00005410ff2c7816ULL, 0x004fc60000000046ULL, 0x0000004a2b187223ULL, 0x080fe20000010018ULL,
0x00007610ff2b7816ULL, 0x000fe20000000042ULL, 0x0000004a2c117223ULL, 0x000fe20000010011ULL,
0x00007610ff2c7816ULL, 0x000fc60000000046ULL, 0x0000004a2b0c7223ULL, 0x080fe2000001000cULL,
0x00007610ff2b7816ULL, 0x000fe20000000044ULL, 0x0000004a2c257223ULL, 0x000fe20000010025ULL,
0x00005410ff2c7816ULL, 0x008fc60000000048ULL, 0x0000004a2b267223ULL, 0x080fe20000010026ULL,
0x00005410ff2b7816ULL, 0x000fe2000000003cULL, 0x0000004a2c0b7223ULL, 0x000fe2000001000bULL,
0x00007610ff2c7816ULL, 0x000fc60000000048ULL, 0x0000004a2b0e7223ULL, 0x080fe2000001000eULL,
0x00007610ff2b7816ULL, 0x000fe2000000003cULL, 0x0000004a2c077223ULL, 0x000fc80000010007ULL,
0x0000004a2b247223ULL, 0x000fe20000010024ULL, 0xfffff34000008947ULL, 0x000fea000383ffffULL,
0x0180000027037810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000003037812ULL, 0x000fc600078ec0ffULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000e7e000287802ULL, 0x000fe40000000f00ULL, 0x0000b8e000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002700047308ULL, 0x000e640000001000ULL,
0xbf80000004037423ULL, 0x002fc80000000027ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000304037223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000287919ULL, 0x000f280000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff2a7819ULL, 0x010fe40000011628ULL, 0x00000008282c7811ULL, 0x040fe200078ff0ffULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x0000002aff297212ULL, 0x000fe200078e33ffULL,
0x00001f2a03047589ULL, 0x00cea200000e0000ULL, 0x0000002cff2b7212ULL, 0x000fe200078e33ffULL,
0x000000082c307824ULL, 0x000fe200078e00ffULL, 0x0000000c28287812ULL, 0x000fe200078ec0ffULL,
0x00001f2c03277589ULL, 0x0022e200000e0000ULL, 0x000000082a2e7824ULL, 0x000fc400078e00ffULL,
0xfffffff830317812ULL, 0x000fc600078ee22bULL, 0xfffffff82e297812ULL, 0x000fe400078ee229ULL,
0x0000001031317824ULL, 0x000fc600078e0202ULL, 0x0000001029297824ULL, 0x000fe200078e0202ULL,
0x0000000a04057220ULL, 0x044fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000002304067220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000000804087220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x00000019040a7220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000001004037220ULL, 0x002fe20000410000ULL,
0x0000000d270d7220ULL, 0x048fe20000410000ULL, 0x0000001d27047220ULL, 0x040fe20000410000ULL,
0x0000000c271d7220ULL, 0x040fe20000410000ULL, 0x0000001127117220ULL, 0x040fe20000410000ULL,
0x00000025270c7220ULL, 0x040fe20000410000ULL, 0x0000000b270b7220ULL, 0x040fe20000410000ULL,
0x0000000727107220ULL, 0x040fe20000410000ULL, 0x0000000d0404723eULL, 0x000fe200000010ffULL,
0x0000001827187220ULL, 0x040fe20000410000ULL, 0x000000072a0d7812ULL, 0x040fe200078ec0ffULL,
0x0000000e270e7220ULL, 0x040fe20000410000ULL, 0x0000002427237220ULL, 0x040fe20000410000ULL,
0x000000082a077824ULL, 0x000fe200078e00ffULL, 0x000000110c0c723eULL, 0x000fe200000010ffULL,
0x0000001e271e7220ULL, 0x040fe20000410000ULL, 0x0000000b100b723eULL, 0x000fe200000010ffULL,
0x0000001b271b7220ULL, 0x040fe20000410000ULL, 0x000000130a0a723eULL, 0x000fe200000010ffULL,
0x0000001c271c7220ULL, 0x040fe20000410000ULL, 0x000000072c107812ULL, 0x000fe200078ec0ffULL,
0x0000002227197220ULL, 0x000fe20000410000ULL, 0x000000010d117812ULL, 0x000fe200078e3cffULL,
0x0000001527157220ULL, 0x000fe20000410000ULL, 0x000000081708723eULL, 0x000fe200000010ffULL,
0x0000002627267220ULL, 0x000fe20000410000ULL, 0x000000020d137812ULL, 0x000fe200078e3cffULL,
0x000000082a117824ULL, 0x000fe200078e0211ULL, 0x0000001f0606723eULL, 0x000fc400000010ffULL,
0x000000162116723eULL, 0x000fe200000010ffULL, 0x000000082c217824ULL, 0x000fe200078e00ffULL,
0x000000181d18723eULL, 0x000fe200000010ffULL, 0x000000082a137824ULL, 0x040fe200078e0213ULL,
0x000000030d177812ULL, 0x000fe200078e3cffULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x0000000e230e723eULL, 0x000fe200000010ffULL, 0x0000001013137824ULL, 0x000fe200078e0202ULL,
0xfffffff807077812ULL, 0x000fe200078ee22aULL, 0x000000082a177824ULL, 0x000fe200078e0217ULL,
0x000000040d1d7812ULL, 0x040fe200078e3cffULL, 0x0000000128117824ULL, 0x000fe200078e0211ULL,
0x000000050d1f7812ULL, 0x000fe200078e3cffULL, 0x0000001007077824ULL, 0x000fe200078e0202ULL,
0x000000060d0d7812ULL, 0x000fe200078e3cffULL, 0x000000082a1d7824ULL, 0x000fe200078e021dULL,
0x0000000110237812ULL, 0x000fe200078e3cffULL, 0x000000082a1f7824ULL, 0x000fe200078e021fULL,
0x0000000210257812ULL, 0x000fe200078e3cffULL, 0x000000082a0d7824ULL, 0x000fe200078e020dULL,
0x0000000310277812ULL, 0x000fe200078e3cffULL, 0x000000082c237824ULL, 0x000fe200078e0223ULL,
0x00000004102b7812ULL, 0x000fe200078e3cffULL, 0x000000082c257824ULL, 0x000fe200078e0225ULL,
0x00000005102d7812ULL, 0x000fe200078e3cffULL, 0x000000082c277824ULL, 0x000fe200078e0227ULL,
0x00000006102f7812ULL, 0x000fe200078e3cffULL, 0x000000082c2b7824ULL, 0x040fe200078e022bULL,
0xfffffff821217812ULL, 0x000fe200078ee22cULL, 0x000000082c2d7824ULL, 0x040fe200078e022dULL,
0x000000120909723eULL, 0x000fe200000010ffULL, 0x000000082c2f7824ULL, 0x000fe200078e022fULL,
0x0000001a0505723eULL, 0x000fe200000010ffULL, 0x0000001017177824ULL, 0x000fe200078e0202ULL,
0x0000000f140f723eULL, 0x000fe200000010ffULL, 0x0000000107077824ULL, 0x000fe200078e0228ULL,
0x000000200303723eULL, 0x000fe200000010ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0202ULL,
0x0000001e1b1b723eULL, 0x000fe200000010ffULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x0000000607007388ULL, 0x0003e20000000800ULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x0000001c1919723eULL, 0x000fe200000010ffULL, 0x000000100d0d7824ULL, 0x100fe200078e0202ULL,
0x0000001611007388ULL, 0x0005e20000000800ULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x000000152615723eULL, 0x000fe200000010ffULL, 0x0000001025257824ULL, 0x000fc400078e0202ULL,
0x0000001027277824ULL, 0x100fe400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe400078e0202ULL,
0x000000102d2d7824ULL, 0x100fe400078e0202ULL, 0x000000102f2f7824ULL, 0x000fe400078e0202ULL,
0x0000000128027824ULL, 0x040fe400078e0213ULL, 0x0000000128107824ULL, 0x000fc400078e0217ULL,
0x00000001281d7824ULL, 0x040fe200078e021dULL, 0x0000000902007388ULL, 0x0005e20000000800ULL,
0x00000001281f7824ULL, 0x040fe400078e021fULL, 0x0000000128127824ULL, 0x040fe200078e020dULL,
0x0000000510007388ULL, 0x0005e20000000800ULL, 0x0000000128147824ULL, 0x040fe400078e0229ULL,
0x0000000128217824ULL, 0x040fe200078e0221ULL, 0x000000081d007388ULL, 0x0005e20000000800ULL,
0x00000001281a7824ULL, 0x000fc400078e0223ULL, 0x0000000128067824ULL, 0x042fe200078e0225ULL,
0x0000000a1f007388ULL, 0x0005e20000000800ULL, 0x0000000128277824ULL, 0x040fe400078e0227ULL,
0x00000001281c7824ULL, 0x040fe200078e022bULL, 0x0000000f12007388ULL, 0x0005e20000000800ULL,
0x00000001282d7824ULL, 0x040fe400078e022dULL, 0x00000001282f7824ULL, 0x040fe200078e022fULL,
0x0000000314007388ULL, 0x0005e20000000800ULL, 0x00000001281e7824ULL, 0x000fc600078e0231ULL,
0x0000000421007388ULL, 0x0005e80000000800ULL, 0x0000001b1a007388ULL, 0x0005e80000000800ULL,
0x0000001906007388ULL, 0x0005e80000000800ULL, 0x0000001827007388ULL, 0x0005e80000000800ULL,
0x000000151c007388ULL, 0x0005e80000000800ULL, 0x0000000c2d007388ULL, 0x0005e80000000800ULL,
0x0000000e2f007388ULL, 0x0005e80000000800ULL, 0x0000000b1e007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000057919ULL, 0x004ea20000000000ULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x0000580000047ab9ULL, 0x000fc40000000800ULL,
0x0000000000047919ULL, 0x002e620000002600ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000020050d7810ULL, 0x00cfc60007ffe0ffULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x00000003ff067819ULL, 0x000fe40000011605ULL, 0x00000003ff027819ULL, 0x000fe2000001160dULL,
0x00000008040f7824ULL, 0x002fe200078e00ffULL, 0x0000000706087812ULL, 0x000fe400078e4805ULL,
0x0000000702037812ULL, 0x000fe400078e480dULL, 0x0ffffff808077812ULL, 0x000fe400078ef805ULL,
0x0ffffff803037812ULL, 0x000fc400078ef80dULL, 0xfffffff80f027812ULL, 0x000fe200078ee202ULL,
0x0000001007087824ULL, 0x100fe200078e0200ULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000001003037824ULL, 0x000fe400078e0200ULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0x1ffffff80d0d7812ULL, 0x000fe200078ef868ULL, 0x00a0000008087984ULL, 0x000e660000000c00ULL,
0xfffffff807007812ULL, 0x000fe200078ee206ULL, 0x00a0000003107984ULL, 0x0004e20000000c00ULL,
0x0000000705077812ULL, 0x000fc400078ec0ffULL, 0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000402007c10ULL, 0x000fe4000ff3e0ffULL, 0x1ffffff807077812ULL, 0x000fe200078ef868ULL,
0x000000ffff037224ULL, 0x004fe200000e06ffULL, 0x00005a0006027a11ULL, 0x000fe200078048ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005a0000047a11ULL, 0x000fe400078248ffULL,
0x00005b0006037a11ULL, 0x000fc400000f4c03ULL, 0x00005b0000057a11ULL, 0x000fc600008f4c05ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x002fe8000c101d06ULL, 0x0000001004007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000464007824ULL, 0x002fe400078e0262ULL,
0xffffffffff6b7424ULL, 0x000fc600078e00ffULL, 0x000000610000720cULL, 0x000fda0003f06070ULL,
0x0000000206038824ULL, 0x000fc800078e00ffULL, 0x00006400030a8a24ULL, 0x000fc800078e0200ULL,
0x000060000a0a8625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060a6b8981ULL, 0x000ea2000c1e1900ULL, 0x0000000164027810ULL, 0x000fe20007ffe0ffULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004005037824ULL, 0x000fe200078e00ffULL,
0x01460000ff087f8cULL, 0x000e62000c80043fULL, 0x000000170200720cULL, 0x000fe20003f06070ULL,
0x0000004062027824ULL, 0x000fe400078e00ffULL, 0x000000046b267c24ULL, 0x004fd4000f8e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000010064077824ULL, 0x002fe200078e0202ULL,
0x00000002ff207819ULL, 0x100fe40000011604ULL, 0x00000003ff117819ULL, 0x000fe40000011604ULL,
0x00000007600a7217ULL, 0x000fe20007800000ULL, 0x0000004005057824ULL, 0x000fe200078e0220ULL,
0x0000000311117812ULL, 0x000fe400078e4804ULL, 0x0000200062137811ULL, 0x000fe200078e68ffULL,
0x000000010a077824ULL, 0x000fe200078e0a07ULL, 0x00000008050a7810ULL, 0x000fc40007ffe0ffULL,
0x00000010050b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a260a7210ULL, 0x040fe40007f3e0ffULL,
0x0000000526107210ULL, 0x040fe40007f1e0ffULL, 0x0000000b260b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e06ffULL, 0x00005e000a197a11ULL, 0x000fe200078248ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x0ffffffc11047812ULL, 0x000fe200078ef804ULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005e00100f7a11ULL, 0x000fc400078048ffULL,
0x00005e000b127a11ULL, 0x000fe200078448ffULL, 0x0000001004157824ULL, 0x000fe200078e0213ULL,
0x00005f000a1b7a11ULL, 0x000fe400008f4c1bULL, 0x000000300e1e7812ULL, 0x000fe400078ec0ffULL,
0x00000018050a7810ULL, 0x000fe40007ffe0ffULL, 0x000000072000720cULL, 0x000fe40003f66070ULL,
0x00005f0010107a11ULL, 0x000fc400000f4c0dULL, 0x00005f000b147a11ULL, 0x000fe400010f4c14ULL,
0x00000020050b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000a260a7210ULL, 0x000fe40007f3e0ffULL,
0x0000000f1e047210ULL, 0x000fe40007f1e0ffULL, 0x00000028050c7810ULL, 0x040fe40007ffe0ffULL,
0x00000030050d7810ULL, 0x000fc40007ffe0ffULL, 0x00000038050e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0610ULL, 0x0000000b261c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x00005e000a0f7a11ULL, 0x000fe400078848ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004157faeULL, 0x0003e2000d901c46ULL,
0x0000000820227810ULL, 0x000fe40007ffe0ffULL, 0x00005f000a107a11ULL, 0x000fe400020f4c0bULL,
0x0000001e190a7210ULL, 0x000fc40007f7e0ffULL, 0x0000000c261a7210ULL, 0x040fe40007fde0ffULL,
0x0000000e26167210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e061bULL,
0x0000001e120c7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x002fe200010e06ffULL,
0x0000001e0f0e7210ULL, 0x000fe40007fbe0ffULL, 0x0000001020247810ULL, 0x040fe40007ffe0ffULL,
0x0000001820127810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e0610ULL,
0x000000072200720cULL, 0x040fe20003f66070ULL, 0x0000000422227824ULL, 0x000fe200078e00ffULL,
0x0000000d26187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e0614ULL,
0x000000072400720cULL, 0x0c0fe20003f86070ULL, 0x0000000424247824ULL, 0x000fe200078e00ffULL,
0x000000071200720cULL, 0x040fe20003fa6070ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0xfffffffc22047812ULL, 0x000fc400078ee211ULL, 0x00005e001c1b7a11ULL, 0x000fe400078448ffULL,
0xfffffffc24107812ULL, 0x000fe200078ee211ULL, 0x0000001004057824ULL, 0x000fe200078e0213ULL,
0xfffffffc12127812ULL, 0x000fe400078ee211ULL, 0x0000002020047810ULL, 0x000fe40007ffe0ffULL,
0x00005f001c1c7a11ULL, 0x000fe200010f4c15ULL, 0x0000001010157824ULL, 0x100fe200078e0213ULL,
0x0000002820107810ULL, 0x000fe20007ffe0ffULL, 0x0000001012197824ULL, 0x000fe200078e0213ULL,
0x0000003020127810ULL, 0x000fe20007ffe0ffULL, 0x000000000a057faeULL, 0x0003e2000d901c46ULL,
0x000000070400720cULL, 0x0c0fe20003f46070ULL, 0x0000000404047824ULL, 0x000fe200078e00ffULL,
0x0000003820147810ULL, 0x000fe20007ffe0ffULL, 0x000000000c157faeULL, 0x0005e2000e101c46ULL,
0x000000071000720cULL, 0x000fc40003f66070ULL, 0xfffffffc04047812ULL, 0x100fe200078ee211ULL,
0x000000000e197faeULL, 0x0007e2000e901c46ULL, 0x000000071200720cULL, 0x080fe40003f86070ULL,
0x000000071400720cULL, 0x000fe20003fa6070ULL, 0x00000004100a7824ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe200030e06ffULL, 0x00005e001a0b7a11ULL, 0x000fe200078c48ffULL,
0x00000004120c7824ULL, 0x004fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee211ULL,
0x0000001004077824ULL, 0x000fe200078e0213ULL, 0x00005f001a107a11ULL, 0x000fe200030f4c05ULL,
0x00000004140e7824ULL, 0x008fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x100fe200078ee211ULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x0000001e1b047210ULL, 0x080fe20007fde0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0xfffffffc0e0e7812ULL, 0x000fe200078ee211ULL,
0x000000100a117824ULL, 0x100fe200078e0213ULL, 0x0000001e0b0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000100c157824ULL, 0x100fe200078e0213ULL, 0x00005e00180c7a11ULL, 0x000fe200078048ffULL,
0x000000100e137824ULL, 0x000fc400078e0213ULL, 0x000000ffff057224ULL, 0x000fe200030e061cULL,
0x00005e00160e7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0610ULL,
0x00005f00180d7a11ULL, 0x000fe400000f4c0dULL, 0x0000001e0c0c7210ULL, 0x080fe20007f1e0ffULL,
0x0000000004077faeULL, 0x0003e2000d101c46ULL, 0x00005f00160f7a11ULL, 0x000fe400030f4c0fULL,
0x0000001e0e0e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x000000000a117faeULL, 0x0003e6000d901c46ULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000000000c157faeULL, 0x0003e8000e101c46ULL, 0x000000000e137faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000000304057211ULL, 0x042fe400078ff0ffULL,
0x0000000804187811ULL, 0x000fc400078ff0ffULL, 0x0000000526057210ULL, 0x000fe40007f1e0ffULL,
0x0000002004107811ULL, 0x040fe400078ff0ffULL, 0x0000003004147811ULL, 0x040fe200078ff0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005e0005227a11ULL, 0x000fe200078048ffULL,
0x00000001030d7824ULL, 0x040fe200078e0210ULL, 0x00000010040a7811ULL, 0x040fe200078ff0ffULL,
0x0000000103117824ULL, 0x000fe200078e0214ULL, 0x00005f0005247a11ULL, 0x000fe200000f4c24ULL,
0x0000000103057824ULL, 0x040fe200078e0218ULL, 0x00000018040c7811ULL, 0x000fe200078ff0ffULL,
0x0000000103077824ULL, 0x040fe200078e020aULL, 0x00000003ff1b7819ULL, 0x000fe20000011604ULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0x0000002804127811ULL, 0x000fe200078ff0ffULL,
0x00000001030b7824ULL, 0x000fe200078e020cULL, 0x000000031b1b7812ULL, 0x000fe200078e4804ULL,
0x00000004101e7824ULL, 0x000fe200078e00ffULL, 0x0000003804167811ULL, 0x000fe200078ff0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x0000000526207210ULL, 0x000fe20007fde0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000d261a7210ULL, 0x040fe20007f3e0ffULL,
0x00000001030f7824ULL, 0x040fe200078e0212ULL, 0x00000007261c7210ULL, 0x000fe20007fbe0ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x0000200062257811ULL, 0x000fe200078e68ffULL,
0x0000000103137824ULL, 0x000fe200078e0216ULL, 0xfffffffc140d7812ULL, 0x100fe200078ee21bULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x0000000b26157210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200030e06ffULL, 0x0ffffffc1b107812ULL, 0x000fe200078ef804ULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e0b7812ULL, 0x000fe200078ee21bULL,
0x000000100d237824ULL, 0x000fe200078e0225ULL, 0xfffffffc18047812ULL, 0x000fe200078ee21bULL,
0x000000ffff277224ULL, 0x000fe200028e06ffULL, 0x00005e00201e7a11ULL, 0x000fe200078c48ffULL,
0x000000100b1f7824ULL, 0x000fe200078e0225ULL, 0xfffffffc0a057812ULL, 0x000fe200078ee21bULL,
0x0000001010297824ULL, 0x000fe200078e0225ULL, 0xfffffffc0c0a7812ULL, 0x000fc400078ee21bULL,
0x00005e001c0d7a11ULL, 0x000fe400078a48ffULL, 0x0000000f26197210ULL, 0x000fe20007f5e0ffULL,
0x000000100a1d7824ULL, 0x000fe200078e0225ULL, 0xfffffffc120c7812ULL, 0x000fe400078ee21bULL,
0x00005f0020207a11ULL, 0x000fe200030f4c07ULL, 0x0000001004077824ULL, 0x000fe200078e0225ULL,
0xfffffffc160f7812ULL, 0x000fe200078ee21bULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000001126117210ULL, 0x000fe20007f7e0ffULL, 0x00000010051b7824ULL, 0x000fe200078e0225ULL,
0x00005e00150b7a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005f001c1c7a11ULL, 0x000fe200028f4c27ULL, 0x000000100c217824ULL, 0x100fe200078e0225ULL,
0x000000300e277812ULL, 0x000fe200078ec0ffULL, 0x000000100f257824ULL, 0x000fe200078e0225ULL,
0x00005e001a107a11ULL, 0x000fe200078248ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x0000001326137210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x00005f00150f7a11ULL, 0x000fc400000f4c04ULL, 0x0000002227047210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff167224ULL, 0x000fe200020e06ffULL, 0x00005f001a1a7a11ULL, 0x000fe400008f4c05ULL,
0x00005e0011147a11ULL, 0x000fe200078448ffULL, 0x000000ffff057224ULL, 0x000fe200000e0624ULL,
0x00005e0019127a11ULL, 0x000fe400078248ffULL, 0x00005e0013187a11ULL, 0x000fe400078648ffULL,
0x00005f0011157a11ULL, 0x000fe200010f4c0aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004297faeULL, 0x0003e2000b901c46ULL, 0x00005f0019197a11ULL, 0x000fc400008f4c0cULL,
0x0000001e270a7210ULL, 0x040fe40007f1e0ffULL, 0x0000000d270c7210ULL, 0x000fe40007f3e0ffULL,
0x00005f0013167a11ULL, 0x000fe400018f4c16ULL, 0x0000000b270e7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0620ULL, 0x0000001027107210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e061cULL, 0x0000001227127210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000001427147210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200018e061aULL, 0x0000001827187210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200020e0619ULL, 0x000000000a077faeULL, 0x0003e2000b901c46ULL,
0x000000ffff157224ULL, 0x000fc400028e0615ULL, 0x000000ffff197224ULL, 0x000fe200000e0616ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000018257faeULL, 0x0003e4000b901c46ULL,
0x01460400ff057984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000005ff7812ULL, 0x002fc60007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x01460400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000176400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000640006057a24ULL, 0x000fe200078e02ffULL, 0x0001468862067811ULL, 0x040fe200078e18ffULL,
0x0000002062087824ULL, 0x000fe200078e00ffULL, 0xffffffff17077810ULL, 0x000fe40007ffe0ffULL,
0x0000010064097824ULL, 0x000fe200078e0202ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000096000720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x00000001640a7810ULL, 0x000fe20007ffe0ffULL, 0x000000046b6b7c24ULL, 0x000fc6000f8e02ffULL,
0x000000170a00720cULL, 0x000fda0003f06070ULL, 0x000006a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1b7819ULL, 0x002fe40000011604ULL, 0x00000003046d7812ULL, 0x000fe400078ec0ffULL,
0x000000181b267810ULL, 0x000fe20007ffe0ffULL, 0x00000001030a7824ULL, 0x000fe200078e021bULL,
0x000000081b1c7810ULL, 0x040fe40007ffe0ffULL, 0x000000201b277810ULL, 0x000fe20007ffe0ffULL,
0x0000000103107824ULL, 0x000fe200078e0226ULL, 0x0000000a6b0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000041c1e7824ULL, 0x000fe200078e00ffULL, 0x000000101b247810ULL, 0x000fe20007ffe0ffULL,
0x0000000103127824ULL, 0x000fe200078e0227ULL, 0x000000106b107210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x00005e000a0c7a11ULL, 0x040fe200078248ffULL,
0x00000001030e7824ULL, 0x000fe200078e0224ULL, 0x000000281b287810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x00005f000a0d7a11ULL, 0x000fe200008f4c0bULL,
0x00000001030a7824ULL, 0x000fe200078e021cULL, 0x00005e0010147a11ULL, 0x000fc400078848ffULL,
0x0000000e6b137210ULL, 0x040fe40007f7e0ffULL, 0x0000000a6b0f7210ULL, 0x040fe40007f5e0ffULL,
0x000000126b0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00005f0010157a11ULL, 0x000fe200020f4c11ULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00000003ff117819ULL, 0x000fe20000011604ULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x00005e000a187a11ULL, 0x000fc400078248ffULL, 0x00005e000f0e7a11ULL, 0x000fe400078448ffULL,
0x00005f000a197a11ULL, 0x000fe200008f4c0bULL, 0x00000001600a7824ULL, 0x000fe200078e0a09ULL,
0x00005e0013127a11ULL, 0x000fe400078648ffULL, 0x00000004110b7212ULL, 0x000fe400078e3cffULL,
0x000000301b297810ULL, 0x040fe40007ffe0ffULL, 0x000000381b2a7810ULL, 0x000fc40007ffe0ffULL,
0x00005f000f0f7a11ULL, 0x000fe200010f4c1aULL, 0x00000001031a7824ULL, 0x000fe200078e0229ULL,
0x00005f0013137a11ULL, 0x000fe200018f4c16ULL, 0x0000000103167824ULL, 0x000fe200078e0228ULL,
0x000000030b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000a1b00720cULL, 0x080fe40003f46070ULL,
0x0000000a1c00720cULL, 0x000fe20003f26070ULL, 0x00000001031c7824ULL, 0x000fe200078e022aULL,
0x0000300062107811ULL, 0x000fc400078e68ffULL, 0x000000046d217812ULL, 0x000fe400078efcffULL,
0x0ffffffc0b6f7812ULL, 0x000fe400078ef804ULL, 0xfffffffc1e257812ULL, 0x000fe200078ee20bULL,
0x00000010210c7825ULL, 0x000fe200078e000cULL, 0x000000166b1b7210ULL, 0x040fe40007f9e0ffULL,
0x0000001a6b1d7210ULL, 0x000fe20007fbe0ffULL, 0x000000106f237824ULL, 0x100fe200078e0210ULL,
0x0000001c6b167210ULL, 0x000fe20007f7e0ffULL, 0x0000001025257824ULL, 0x000fe200078e0210ULL,
0x0000000a2a00720cULL, 0x080fe20003fc6070ULL, 0x00000010210e7825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c237faeULL, 0x0003e2000d101c46ULL,
0x0000000a2600720cULL, 0x000fc40003f46070ULL, 0x000000ffff227224ULL, 0x000fe200020e06ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078848ffULL, 0x000000ffff207224ULL, 0x000fe200028e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078a48ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e06ffULL,
0x00005e00161e7a11ULL, 0x000fe200078648ffULL, 0x000000000e257faeULL, 0x0005e2000c901c46ULL,
0x0000000a2400720cULL, 0x0c0fe20003f26070ULL, 0x0000000424247824ULL, 0x000fe200078e00ffULL,
0x00005f001b1b7a11ULL, 0x000fe200020f4c22ULL, 0x0000000426267824ULL, 0x000fe200078e00ffULL,
0x00005f001d1d7a11ULL, 0x000fe200028f4c20ULL, 0x00000004290c7824ULL, 0x002fe200078e00ffULL,
0x00005f00161f7a11ULL, 0x000fe200018f4c1fULL, 0x000000042a2a7824ULL, 0x000fe200078e00ffULL,
0x0000000a2700720cULL, 0x000fc40003f66070ULL, 0x0000000a2800720cULL, 0x0c0fe20003f86070ULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x0000000a2900720cULL, 0x000fe20003fa6070ULL,
0x00000004270a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc24237812ULL, 0x000fe200078ee20bULL,
0x00000010210e7825ULL, 0x004fe200078e0014ULL, 0xfffffffc26257812ULL, 0x100fe400078ee20bULL,
0xfffffffc0a277812ULL, 0x100fe200078ee20bULL, 0x0000001023237824ULL, 0x100fe200078e0210ULL,
0xfffffffc28297812ULL, 0x100fe200078ee20bULL, 0x0000001025257824ULL, 0x000fe200078e0210ULL,
0xfffffffc0c2b7812ULL, 0x000fe200078ee20bULL, 0x00000010210c7825ULL, 0x000fe200078e0012ULL,
0xfffffffc2a2d7812ULL, 0x000fc600078ee20bULL, 0x0000001027277824ULL, 0x000fe200078e0210ULL,
0x000000000c237faeULL, 0x0003e2000c901c46ULL, 0x0000001021127825ULL, 0x000fc600078e0018ULL,
0x000000000e257faeULL, 0x0003e2000d101c46ULL, 0x0000001029297824ULL, 0x000fe400078e0210ULL,
0x0000001021147825ULL, 0x000fe200078e001aULL, 0x0000000012277faeULL, 0x0003e6000d901c46ULL,
0x000000102b2b7824ULL, 0x000fe200078e0210ULL, 0x0000000014297faeULL, 0x0003e2000e101c46ULL,
0x0000001021187825ULL, 0x000fc800078e001cULL, 0x000000102d2d7824ULL, 0x000fe200078e0210ULL,
0x00000000182b7faeULL, 0x0003e2000e901c46ULL, 0x00000010211a7825ULL, 0x000fca00078e001eULL,
0x000000001a2d7faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000001004227811ULL, 0x042fe400078ff0ffULL, 0x0000000804207811ULL, 0x040fe400078ff0ffULL,
0x00000003040a7211ULL, 0x040fe200078ff0ffULL, 0x00000001030e7824ULL, 0x040fe200078e0222ULL,
0x0000001804247811ULL, 0x000fe200078ff0ffULL, 0x00000001030c7824ULL, 0x000fe200078e0220ULL,
0x0000006b0a0d7210ULL, 0x080fe20007f3e0ffULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0x0000006b0e0a7210ULL, 0x080fe20007f7e0ffULL, 0x0000000422227824ULL, 0x000fe200078e00ffULL,
0x0000006b0c0f7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078248ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e06ffULL,
0x00005e000a127a11ULL, 0x000fe200078648ffULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x00000030042a7811ULL, 0x000fc400078ff0ffULL, 0x00005e000f0e7a11ULL, 0x000fe400078448ffULL,
0x0000002804287811ULL, 0x000fe400078ff0ffULL, 0x00005f000a137a11ULL, 0x000fe200018f4c0bULL,
0x00000001030a7824ULL, 0x000fe200078e0224ULL, 0x00005f000d0d7a11ULL, 0x000fe200008f4c14ULL,
0x0000000103147824ULL, 0x000fe200078e022aULL, 0x00005f000f0f7a11ULL, 0x000fe200010f4c10ULL,
0x0000000103107824ULL, 0x040fe200078e0228ULL, 0x0000002004267811ULL, 0x000fe200078ff0ffULL,
0x0000000424247824ULL, 0x000fe200078e00ffULL, 0x0000006b0a157210ULL, 0x080fe20007f5e0ffULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x0000006b140a7210ULL, 0x080fe20007f3e0ffULL,
0x0000000103167824ULL, 0x000fe200078e0226ULL, 0x0000006b10107210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078448ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x0000006b16167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x00005e000a1c7a11ULL, 0x000fe200078248ffULL,
0x0000000426267824ULL, 0x000fe200078e00ffULL, 0x00005e00101a7a11ULL, 0x000fe200078848ffULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0x00005f000a1d7a11ULL, 0x000fe200008f4c0bULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0x00005e0016187a11ULL, 0x000fc400078648ffULL,
0x00005f00101b7a11ULL, 0x000fe400020f4c11ULL, 0x00000038040a7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff117819ULL, 0x000fe40000011604ULL, 0x00005f0016197a11ULL, 0x000fe200018f4c19ULL,
0x0000000103167824ULL, 0x000fe200078e020aULL, 0x00000004110b7212ULL, 0x000fe400078e3cffULL,
0x00005f0015157a11ULL, 0x000fe200010f4c1eULL, 0x000000040a1e7824ULL, 0x000fe200078e00ffULL,
0x00000003046d7812ULL, 0x000fc400078ec0ffULL, 0x000000030b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000006b160a7210ULL, 0x000fe40007f3e0ffULL, 0x0000300062107811ULL, 0x000fe400078e68ffULL,
0x000000046d2f7812ULL, 0x000fe200078efcffULL, 0x000000ffff1f7224ULL, 0x000fe200008e06ffULL,
0x0ffffffc0b6f7812ULL, 0x000fe400078ef804ULL, 0xfffffffc20217812ULL, 0x000fe200078ee20bULL,
0x000000102f0c7825ULL, 0x000fe200078e000cULL, 0xfffffffc22237812ULL, 0x000fc400078ee20bULL,
0xfffffffc1e2d7812ULL, 0x100fe200078ee20bULL, 0x000000106f317824ULL, 0x100fe200078e0210ULL,
0xfffffffc24257812ULL, 0x000fe200078ee20bULL, 0x0000001021217824ULL, 0x000fe200078e0210ULL,
0x00005e000a1e7a11ULL, 0x000fe200078248ffULL, 0x000000102f0e7825ULL, 0x000fe200078e000eULL,
0xfffffffc26277812ULL, 0x100fe200078ee20bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c317faeULL, 0x0003e2000b901c46ULL, 0xfffffffc28297812ULL, 0x100fe200078ee20bULL,
0x0000001023237824ULL, 0x000fe200078e0210ULL, 0xfffffffc2a2b7812ULL, 0x000fe200078ee20bULL,
0x000000102f127825ULL, 0x000fe200078e0012ULL, 0x00005f000a1f7a11ULL, 0x000fe200008f4c1fULL,
0x000000000e217faeULL, 0x0003e4000b901c46ULL, 0x0000001025257824ULL, 0x000fc400078e0210ULL,
0x000000102f147825ULL, 0x000fe200078e0014ULL, 0x0000000012237faeULL, 0x0003e6000b901c46ULL,
0x0000001027277824ULL, 0x000fe200078e0210ULL, 0x0000000014257faeULL, 0x0003e2000b901c46ULL,
0x000000102f187825ULL, 0x000fc800078e0018ULL, 0x0000001029297824ULL, 0x000fe200078e0210ULL,
0x0000000018277faeULL, 0x0003e2000b901c46ULL, 0x000000102f1a7825ULL, 0x000fc800078e001aULL,
0x000000102b2b7824ULL, 0x000fe200078e0210ULL, 0x000000001a297faeULL, 0x0003e2000b901c46ULL,
0x000000102f1c7825ULL, 0x000fc800078e001cULL, 0x000000102d2d7824ULL, 0x000fe200078e0210ULL,
0x000000001c2b7faeULL, 0x0003e2000b901c46ULL, 0x000000102f1e7825ULL, 0x000fca00078e001eULL,
0x000000001e2d7faeULL, 0x0003e4000b901c46ULL, 0x00000004ff0a7819ULL, 0x000fe20000011604ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000007040d7812ULL, 0x002fe200078ec0ffULL,
0x00002000626e7824ULL, 0x000fe200078e00ffULL, 0x000000020a247810ULL, 0x040fe20007ffe0ffULL,
0x000000080a0e7824ULL, 0x000fc600078e00ffULL, 0x000020006e0c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee20dULL, 0x000000080d0d7812ULL, 0x000fe400078ef804ULL,
0x00000001ff0f7819ULL, 0x000fe2000001160eULL, 0x000000040e127824ULL, 0x000fe200078e00ffULL,
0x000000070a107812ULL, 0x000fe400078e780dULL, 0x000000100e137810ULL, 0x000fc40007ffe0ffULL,
0x000000200e147810ULL, 0x040fe40007ffe0ffULL, 0x000000300e157810ULL, 0x000fe20007ffe0ffULL,
0x000000200d0e7824ULL, 0x000fe200078e0210ULL, 0x000000030f107812ULL, 0x000fe200078ec0ffULL,
0x0000000413167824ULL, 0x000fe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011613ULL,
0x00000004141e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe20000011614ULL,
0x0000000415227824ULL, 0x000fe200078e00ffULL, 0x00000001ff187819ULL, 0x000fe20000011615ULL,
0x000000100e0e7824ULL, 0x000fe200078e00ffULL, 0x000000030f147812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000003131c7812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000318207812ULL, 0x000fe400078ec0ffULL,
0x00000001100f7812ULL, 0x100fe200078e7811ULL, 0x000000000e18783bULL, 0x0003e20000000200ULL,
0x0000000114497812ULL, 0x100fe400078e7811ULL, 0x000000011c4b7812ULL, 0x100fe400078e7811ULL,
0x00000001204d7812ULL, 0x000fc400078e7811ULL, 0x000000120f0f7212ULL, 0x000fe400078efcffULL,
0x0000001649497212ULL, 0x000fe400078efcffULL, 0x0000001e4b4b7212ULL, 0x000fe200078efcffULL,
0x000000100f6c7824ULL, 0x100fe200078e020cULL, 0x000000224d4d7212ULL, 0x000fe200078efcffULL,
0x00000010496a7824ULL, 0x100fe200078e020cULL, 0x0000000111117812ULL, 0x000fe200078ec0ffULL,
0x000000104b697824ULL, 0x100fe200078e020cULL, 0x000000006c3c783bULL, 0x000ea20000000200ULL,
0x000000104d687824ULL, 0x000fe200078e020cULL, 0x0000000210757812ULL, 0x000fc400078e1e11ULL,
0x000000006a38783bULL, 0x000ee20000000200ULL, 0x0000000724247812ULL, 0x000fe400078e780dULL,
0x0000000214737812ULL, 0x100fe200078e1e11ULL, 0x000000006934783bULL, 0x000f220000000200ULL,
0x000000021c157812ULL, 0x100fe200078e1e11ULL, 0x000000200d0e7824ULL, 0x002fe200078e0224ULL,
0x0000000220717812ULL, 0x000fe200078e1e11ULL, 0x000000006840783bULL, 0x000e620000000200ULL,
0x0000001275757212ULL, 0x000fe200078efcffULL, 0x000000100e0e7824ULL, 0x000fe200078e00ffULL,
0x0000001673737212ULL, 0x000fc400078efcffULL, 0x0000001e15157212ULL, 0x000fe200078efcffULL,
0x0000001075677824ULL, 0x100fe200078e020cULL, 0x0000002271717212ULL, 0x000fe200078efcffULL,
0x0000001073667824ULL, 0x100fe200078e020cULL, 0x000000000e20783bULL, 0x000fe20000000200ULL,
0x0000001015657824ULL, 0x100fe400078e020cULL, 0x0000001071637824ULL, 0x000fe200078e020cULL,
0x000000006744783bULL, 0x000f680000000200ULL, 0x000000006630783bULL, 0x000e680000000200ULL,
0x000000006528783bULL, 0x000e680000000200ULL, 0x000000006310783bULL, 0x000e620000000200ULL,
0x0000003c182c723cULL, 0x044ff000000418ffULL, 0x000000381854723cULL, 0x048ff000000418ffULL,
0x00000034181c723cULL, 0x050ff000000418ffULL, 0x0000003e183c723cULL, 0x040ff000000418ffULL,
0x0000003a1838723cULL, 0x040ff000000418ffULL, 0x000000361834723cULL, 0x040ff000000418ffULL,
0x000000401824723cULL, 0x042ff000000418ffULL, 0x000000421818723cULL, 0x000ff000000418ffULL,
0x00000044202c723cULL, 0x060ff0000004182cULL, 0x000000302054723cULL, 0x040ff00000041854ULL,
0x00000028201c723cULL, 0x040ff0000004181cULL, 0x000000462044723cULL, 0x040ff0000004183cULL,
0x000000322030723cULL, 0x040ff00000041838ULL, 0x0000002a2028723cULL, 0x040ff00000041834ULL,
0x000000102024723cULL, 0x040ff00000041824ULL, 0x000000122020723cULL, 0x000fe20000041818ULL,
0x0000064000008947ULL, 0x000fee0003800000ULL, 0x00000002ff0e7819ULL, 0x000fe40000011604ULL,
0x000000086d3d7812ULL, 0x000fc400078efcffULL, 0x000000080e167810ULL, 0x040fe20007ffe0ffULL,
0x0000000103107824ULL, 0x040fe200078e020eULL, 0x000000100e3c7810ULL, 0x040fe40007ffe0ffULL,
0x000000180e3e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103127824ULL, 0x000fe200078e0216ULL,
0x000000106b117210ULL, 0x000fe20007f5e0ffULL, 0x0000000103147824ULL, 0x040fe200078e023cULL,
0x000000200e407810ULL, 0x000fe20007ffe0ffULL, 0x0000000103187824ULL, 0x000fe200078e023eULL,
0x000000126b137210ULL, 0x000fc40007f7e0ffULL, 0x000000146b357210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x000000186b377210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff347224ULL, 0x000fe200018e06ffULL, 0x00005e0013187a11ULL, 0x000fe200078648ffULL,
0x000000ffff367224ULL, 0x000fe200020e06ffULL, 0x00005e0035127a11ULL, 0x000fe200078848ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x000000280e427810ULL, 0x000fe40007ffe0ffULL,
0x00005e00111a7a11ULL, 0x000fc400078448ffULL, 0x00005f0013197a11ULL, 0x000fe200018f4c34ULL,
0x0000000103347824ULL, 0x000fe200078e0240ULL, 0x00005e0037107a11ULL, 0x000fe400078248ffULL,
0x000000300e437810ULL, 0x000fe20007ffe0ffULL, 0x000000103d187825ULL, 0x000fe200078e0018ULL,
0x00005f0035137a11ULL, 0x000fe400020f4c36ULL, 0x00005f00111b7a11ULL, 0x000fe200010f4c14ULL,
0x0000000103367824ULL, 0x000fe200078e0242ULL, 0x00005f0037117a11ULL, 0x000fe200008f4c38ULL,
0x0000000160147824ULL, 0x000fe200078e0a09ULL, 0x000000346b357210ULL, 0x000fe20007f5e0ffULL,
0x0000000103387824ULL, 0x000fe200078e0243ULL, 0x000000366b377210ULL, 0x000fe20007f7e0ffULL,
0x000000103d1a7825ULL, 0x000fe200078e001aULL, 0x000000140e00720cULL, 0x000fc40003f26070ULL,
0x000000380e4a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x000000386b3b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005e0035387a11ULL, 0x000fe200078448ffULL, 0x000000103d127825ULL, 0x000fe200078e0012ULL,
0x00005e0037367a11ULL, 0x000fe400078648ffULL, 0x00005f0035397a11ULL, 0x000fe200010f4c0eULL,
0x00000001030e7824ULL, 0x000fe200078e024aULL, 0x00005f0037377a11ULL, 0x000fe200018f4c3aULL,
0x00000004163a7824ULL, 0x040fe200078e00ffULL, 0x000000141600720cULL, 0x000fe20003f46070ULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x0000000e6b167210ULL, 0x000fe20007f7e0ffULL,
0x000000106f0e7824ULL, 0x000fe200078e020cULL, 0xfffffffc3a3f7812ULL, 0x000fe200078ee20bULL,
0x000000103d107825ULL, 0x000fe200078e0010ULL, 0x00005e003b347a11ULL, 0x000fc400078848ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a0e7faeULL, 0x0003e2000c901c46ULL,
0x000000103f3f7824ULL, 0x000fe200078e020cULL, 0x00005f003b357a11ULL, 0x000fe200020f4c48ULL,
0x000000ffff3b7224ULL, 0x000fe200018e06ffULL, 0x000000143c00720cULL, 0x0c0fe20003f26070ULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0x00005e00163a7a11ULL, 0x000fe200078648ffULL,
0x00000000183f7faeULL, 0x0005e2000d101c46ULL, 0x000000143e00720cULL, 0x040fe20003f46070ULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x00005f00163b7a11ULL, 0x000fe200018f4c3bULL,
0x000000103d387825ULL, 0x000fe200078e0038ULL, 0xfffffffc3c417812ULL, 0x000fc400078ee20bULL,
0x000000144000720cULL, 0x0c0fe20003f66070ULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x000000144200720cULL, 0x0c0fe20003f86070ULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x000000144300720cULL, 0x080fe20003fa6070ULL, 0x0000001041417824ULL, 0x000fe200078e020cULL,
0x000000144a00720cULL, 0x000fe20003fc6070ULL, 0x0000000443147824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e197812ULL, 0x104fe200078ee20bULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc401b7812ULL, 0x002fe200078ee20bULL, 0x000000103d367825ULL, 0x040fe200078e0036ULL,
0xfffffffc143f7812ULL, 0x100fe200078ee20bULL, 0x0000000012417faeULL, 0x0003e2000c901c46ULL,
0xfffffffc4a437812ULL, 0x000fe200078ee20bULL, 0x000000103d347825ULL, 0x000fc800078e0034ULL,
0x000000103d3a7825ULL, 0x000fe200078e003aULL, 0xfffffffc423d7812ULL, 0x000fc600078ee20bULL,
0x0000001019137824ULL, 0x102fe400078e020cULL, 0x000000101b197824ULL, 0x100fe400078e020cULL,
0x000000103d1b7824ULL, 0x100fe200078e020cULL, 0x0000000010137faeULL, 0x0003e2000d101c46ULL,
0x000000103f3d7824ULL, 0x100fe400078e020cULL, 0x00000010433f7824ULL, 0x000fe200078e020cULL,
0x0000000038197faeULL, 0x0003e8000d901c46ULL, 0x00000000361b7faeULL, 0x0003e8000e101c46ULL,
0x00000000343d7faeULL, 0x0003e8000e901c46ULL, 0x000000003a3f7faeULL, 0x0003e2000f101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000804147811ULL, 0x040fe400078ff0ffULL,
0x00000003040e7211ULL, 0x000fc400078ff0ffULL, 0x0000001004167811ULL, 0x000fe200078ff0ffULL,
0x0000000103107824ULL, 0x000fe200078e0214ULL, 0x0000006b0e0e7210ULL, 0x080fe20007f3e0ffULL,
0x00000004144a7824ULL, 0x000fe200078e00ffULL, 0x00000018043c7811ULL, 0x000fe200078ff0ffULL,
0x00000004164c7824ULL, 0x000fe200078e00ffULL, 0x0000006b10127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x00005e000e187a11ULL, 0x000fe400078248ffULL,
0x0000002804407811ULL, 0x000fe200078ff0ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00005e0012107a11ULL, 0x000fc400078448ffULL, 0x00005f000e197a11ULL, 0x000fe200008f4c11ULL,
0x00000001030e7824ULL, 0x040fe200078e0216ULL, 0x00005f0012117a11ULL, 0x000fe200010f4c13ULL,
0x0000000103127824ULL, 0x040fe200078e023cULL, 0x00000020043e7811ULL, 0x000fe200078ff0ffULL,
0x0000000103387824ULL, 0x040fe200078e0240ULL, 0x0000006b0e0e7210ULL, 0x080fe20007f3e0ffULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0x0000006b12347210ULL, 0x080fe20007f5e0ffULL,
0x0000000103367824ULL, 0x000fe200078e023eULL, 0x0000006b38387210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x00005e000e1a7a11ULL, 0x000fe200078248ffULL,
0x000000ffff357224ULL, 0x000fe200010e06ffULL, 0x00005e0034127a11ULL, 0x000fe200078448ffULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x00005f000e1b7a11ULL, 0x000fe200008f4c13ULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x00005f0034137a11ULL, 0x000fe200010f4c35ULL,
0x000000ffff357224ULL, 0x000fe200020e06ffULL, 0x0000006b36377210ULL, 0x000fc40007f7e0ffULL,
0x00005e0038347a11ULL, 0x000fe400078448ffULL, 0x0000003004427811ULL, 0x040fe200078ff0ffULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x0000003804487811ULL, 0x000fe400078ff0ffULL,
0x00005f0038357a11ULL, 0x000fe200010f4c35ULL, 0x0000000103387824ULL, 0x000fe200078e0242ULL,
0x00005e0037367a11ULL, 0x000fe200078248ffULL, 0x00000001033a7824ULL, 0x000fe200078e0248ULL,
0x000000086d417812ULL, 0x000fe200078efcffULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x00005f0037377a11ULL, 0x000fe200008f4c0eULL, 0x000000106f0e7824ULL, 0x000fe200078e020cULL,
0x0000006b38397210ULL, 0x080fe20007f3e0ffULL, 0x0000001041187825ULL, 0x000fe200078e0018ULL,
0x0000006b3a437210ULL, 0x000fc40007f5e0ffULL, 0xfffffffc4a3d7812ULL, 0x000fe200078ee20bULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x00005e00393a7a11ULL, 0x000fe200078248ffULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x00005e0043387a11ULL, 0x000fe200078448ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000180e7faeULL, 0x0003e2000b901c46ULL,
0x00005f00393b7a11ULL, 0x000fe200008f4c14ULL, 0x000000103d3d7824ULL, 0x000fe200078e020cULL,
0x00005f0043397a11ULL, 0x000fe200010f4c16ULL, 0x0000001041107825ULL, 0x000fe200078e0010ULL,
0xfffffffc4c3f7812ULL, 0x000fc400078ee20bULL, 0xfffffffc40437812ULL, 0x100fe200078ee20bULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0xfffffffc424f7812ULL, 0x000fe200078ee20bULL,
0x00000010411a7825ULL, 0x040fe200078e001aULL, 0x00000000103d7faeULL, 0x0005e2000b901c46ULL,
0xfffffffc3c197812ULL, 0x002fe400078ee20bULL, 0x0000001041127825ULL, 0x000fe200078e0012ULL,
0xfffffffc48517812ULL, 0x000fc600078ee20bULL, 0x0000001041367825ULL, 0x000fc800078e0036ULL,
0x0000001041347825ULL, 0x000fc800078e0034ULL, 0x00000010413a7825ULL, 0x000fc800078e003aULL,
0x0000001041387825ULL, 0x000fe200078e0038ULL, 0xfffffffc3e417812ULL, 0x000fc600078ee20bULL,
0x000000103f3f7824ULL, 0x100fe400078e020cULL, 0x0000001019117824ULL, 0x104fe400078e020cULL,
0x0000001041197824ULL, 0x100fe200078e020cULL, 0x000000001a3f7faeULL, 0x0003e2000b901c46ULL,
0x000000104f3d7824ULL, 0x000fc600078e020cULL, 0x0000000012117faeULL, 0x0005e8000b901c46ULL,
0x0000000036197faeULL, 0x0005e2000b901c46ULL, 0x00000010431b7824ULL, 0x102fe400078e020cULL,
0x00000010513f7824ULL, 0x000fc600078e020cULL, 0x00000000341b7faeULL, 0x0005e8000b901c46ULL,
0x000000003a3d7faeULL, 0x0005e8000b901c46ULL, 0x00000000383f7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000040a107810ULL, 0x002fe40007ffe0ffULL,
0x000030006e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000710107812ULL, 0x100fe400078e780dULL,
0x000000060a147810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e026eULL,
0x000000200d107824ULL, 0x000fe200078e0210ULL, 0x0000000714147812ULL, 0x000fe200078e780dULL,
0x000000104b117824ULL, 0x104fe400078e026eULL, 0x0000001010487824ULL, 0x000fe400078e00ffULL,
0x0000001049107824ULL, 0x000fc400078e026eULL, 0x000000104d127824ULL, 0x000fe400078e026eULL,
0x000000200d147824ULL, 0x000fe400078e0214ULL, 0x0000001075137824ULL, 0x000fe200078e026eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000f5c783bULL, 0x000fe20000000200ULL,
0x0000001014347824ULL, 0x000fe400078e00ffULL, 0x0000001073147824ULL, 0x100fe200078e026eULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x0000001015157824ULL, 0x100fe400078e026eULL,
0x0000001071167824ULL, 0x000fe200078e026eULL, 0x000000001058783bULL, 0x000ea80000000200ULL,
0x000000001150783bULL, 0x000ee80000000200ULL, 0x00000000124c783bULL, 0x000f280000000200ULL,
0x000000001340783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000f680000000200ULL,
0x00000000143c783bULL, 0x000f280000000200ULL, 0x000000001538783bULL, 0x000f280000000200ULL,
0x000000001618783bULL, 0x000f220000000200ULL, 0x0000005c482c723cULL, 0x042ff0000004182cULL,
0x000000584854723cULL, 0x044ff00000041854ULL, 0x00000050481c723cULL, 0x048ff0000004181cULL,
0x0000005e4844723cULL, 0x040ff00000041844ULL, 0x0000005a4830723cULL, 0x040ff00000041830ULL,
0x000000524828723cULL, 0x040ff00000041828ULL, 0x0000004c4824723cULL, 0x050ff00000041824ULL,
0x0000004e4820723cULL, 0x000ff00000041820ULL, 0x00000040342c723cULL, 0x060ff0000004182cULL,
0x0000003c3454723cULL, 0x040ff00000041854ULL, 0x00000038341c723cULL, 0x040ff0000004181cULL,
0x000000423440723cULL, 0x040ff00000041844ULL, 0x0000003e343c723cULL, 0x040ff00000041830ULL,
0x0000003a3438723cULL, 0x040ff00000041828ULL, 0x000000183424723cULL, 0x040ff00000041824ULL,
0x0000001a3434723cULL, 0x000fe20000041820ULL, 0x0000064000008947ULL, 0x000fee0003800000ULL,
0x00000002ff287819ULL, 0x000fe20000011604ULL, 0x000000106f6f7824ULL, 0x000fe200078e026eULL,
0x0000000c6d457812ULL, 0x000fc400078efcffULL, 0x0000001828487810ULL, 0x040fe20007ffe0ffULL,
0x0000000103187824ULL, 0x040fe200078e0228ULL, 0x0000000828327810ULL, 0x040fe40007ffe0ffULL,
0x0000001028467810ULL, 0x040fe20007ffe0ffULL, 0x0000000103227824ULL, 0x000fe200078e0248ULL,
0x000000186b197210ULL, 0x000fe20007f5e0ffULL, 0x00000001031a7824ULL, 0x040fe200078e0232ULL,
0x00000030284d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103207824ULL, 0x000fe200078e0246ULL,
0x000000226b2b7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005e0019227a11ULL, 0x000fe200078448ffULL, 0x00000001034c7824ULL, 0x000fe200078e024dULL,
0x0000001a6b1b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0x00005e002b187a11ULL, 0x000fc400078248ffULL, 0x00005f0019237a11ULL, 0x000fe200010f4c2aULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x000000206b297210ULL, 0x000fe40007f9e0ffULL,
0x00005f002b197a11ULL, 0x000fe200008f4c4aULL, 0x0000001045227825ULL, 0x000fe200078e0022ULL,
0x00000020284a7810ULL, 0x040fe40007ffe0ffULL, 0x00005e001b207a11ULL, 0x000fe200078648ffULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005e00291a7a11ULL, 0x000fe200078848ffULL,
0x00000001032a7824ULL, 0x000fe200078e024aULL, 0x00000028284b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001045187825ULL, 0x000fe200078e0018ULL, 0x00005f001b217a11ULL, 0x000fc400018f4c30ULL,
0x00005f00291b7a11ULL, 0x000fe200020f4c44ULL, 0x0000000103307824ULL, 0x000fe200078e024bULL,
0x0000002a6b297210ULL, 0x040fe20007f5e0ffULL, 0x0000000160447824ULL, 0x000fe200078e0a09ULL,
0x0000004c6b337210ULL, 0x000fe20007f9e0ffULL, 0x0000001045207825ULL, 0x000fe200078e0020ULL,
0x000000306b2b7210ULL, 0x000fe40007f7e0ffULL, 0x000000442800720cULL, 0x0c0fe20003f26070ULL,
0x000000ffff4c7224ULL, 0x000fe200010e06ffULL, 0x00005e0029307a11ULL, 0x040fe200078448ffULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x00000038284f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff507224ULL, 0x000fe200020e06ffULL, 0x00005f0029317a11ULL, 0x000fe200010f4c4cULL,
0x00000010451a7825ULL, 0x000fe200078e001aULL, 0x000000443200720cULL, 0x000fc40003f46070ULL,
0x00005e002b2a7a11ULL, 0x000fe200078648ffULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0x00005e0033287a11ULL, 0x000fe200078848ffULL, 0x00000001034c7824ULL, 0x000fe200078e024fULL,
0x00005f002b2b7a11ULL, 0x000fe200018f4c4eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000226f7faeULL, 0x0003e2000c901c46ULL, 0xfffffffc32477812ULL, 0x000fe200078ee20bULL,
0x0000001045307825ULL, 0x000fe200078e0030ULL, 0x0000004c6b4c7210ULL, 0x000fe40007f7e0ffULL,
0x00005f0033297a11ULL, 0x000fe200020f4c50ULL, 0x0000001047477824ULL, 0x000fe200078e026eULL,
0x000000444600720cULL, 0x080fe20003f26070ULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x00005e004c327a11ULL, 0x000fe200078648ffULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0x0000000020477faeULL, 0x0005e2000d101c46ULL, 0x000000444800720cULL, 0x0c0fe20003f46070ULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x00005f004c337a11ULL, 0x000fe200018f4c33ULL,
0x000000044d227824ULL, 0x002fe200078e00ffULL, 0xfffffffc46497812ULL, 0x000fe200078ee20bULL,
0x00000010452a7825ULL, 0x000fe200078e002aULL, 0x000000444a00720cULL, 0x000fc40003f66070ULL,
0x000000444b00720cULL, 0x080fe20003f86070ULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0x000000444d00720cULL, 0x080fe20003fa6070ULL, 0x000000044b207824ULL, 0x004fe200078e00ffULL,
0x000000444f00720cULL, 0x000fe20003fc6070ULL, 0x0000001049497824ULL, 0x000fe200078e026eULL,
0xfffffffc48217812ULL, 0x100fe200078ee20bULL, 0x000000044f447824ULL, 0x000fe200078e00ffULL,
0xfffffffc4a237812ULL, 0x000fe200078ee20bULL, 0x0000001045287825ULL, 0x040fe200078e0028ULL,
0xfffffffc22477812ULL, 0x100fe200078ee20bULL, 0x000000001a497faeULL, 0x0003e2000c901c46ULL,
0xfffffffc444b7812ULL, 0x000fe200078ee20bULL, 0x0000001045327825ULL, 0x000fe200078e0032ULL,
0xfffffffc20457812ULL, 0x000fc600078ee20bULL, 0x00000010211b7824ULL, 0x102fe400078e026eULL,
0x0000001023217824ULL, 0x100fe400078e026eULL, 0x0000001045237824ULL, 0x100fe200078e026eULL,
0x00000000181b7faeULL, 0x0003e2000d101c46ULL, 0x0000001047457824ULL, 0x100fe400078e026eULL,
0x000000104b477824ULL, 0x000fe200078e026eULL, 0x0000000030217faeULL, 0x0003e8000d901c46ULL,
0x000000002a237faeULL, 0x0003e8000e101c46ULL, 0x0000000028457faeULL, 0x0003e8000e901c46ULL,
0x0000000032477faeULL, 0x0003e2000f101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000804307811ULL, 0x040fe200078ff0ffULL, 0x000000106f6f7824ULL, 0x000fe200078e026eULL,
0x0000000304187211ULL, 0x000fc400078ff0ffULL, 0x0000001004327811ULL, 0x000fe200078ff0ffULL,
0x00000001031a7824ULL, 0x000fe200078e0230ULL, 0x0000006b18197210ULL, 0x080fe20007f3e0ffULL,
0x0000000430527824ULL, 0x000fe200078e00ffULL, 0x0000001804447811ULL, 0x000fe200078ff0ffULL,
0x0000000432587824ULL, 0x000fe200078e00ffULL, 0x0000006b1a1b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005e0019207a11ULL, 0x000fe400078248ffULL,
0x0000002004467811ULL, 0x000fe200078ff0ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005e001b187a11ULL, 0x000fc400078448ffULL, 0x00005f0019217a11ULL, 0x000fe200008f4c1aULL,
0x00000001031a7824ULL, 0x000fe200078e0232ULL, 0x00005f001b197a11ULL, 0x000fe200010f4c22ULL,
0x0000000103227824ULL, 0x040fe200078e0244ULL, 0x00000028044a7811ULL, 0x000fe200078ff0ffULL,
0x0000000103487824ULL, 0x040fe200078e0246ULL, 0x0000006b1a1b7210ULL, 0x080fe20007f3e0ffULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x0000006b22297210ULL, 0x080fe20007f5e0ffULL,
0x00000001034c7824ULL, 0x000fe200078e024aULL, 0x0000006b48487210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff287224ULL, 0x000fe200008e06ffULL, 0x00005e001b227a11ULL, 0x000fe200078248ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005e00291a7a11ULL, 0x000fe200078448ffULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x0000006b4c4c7210ULL, 0x000fe20007f9e0ffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x00005f001b237a11ULL, 0x000fc400008f4c28ULL,
0x00005f00291b7a11ULL, 0x000fe200010f4c2aULL, 0x000000ffff297224ULL, 0x000fe200018e06ffULL,
0x00005e00482a7a11ULL, 0x000fe200078248ffULL, 0x000000ffff317224ULL, 0x000fe200020e06ffULL,
0x00000030044e7811ULL, 0x000fe400078ff0ffULL, 0x00005e004c287a11ULL, 0x000fe400078448ffULL,
0x0000003804507811ULL, 0x000fe400078ff0ffULL, 0x00005f00482b7a11ULL, 0x000fe200008f4c29ULL,
0x0000000103487824ULL, 0x040fe200078e024eULL, 0x00005f004c297a11ULL, 0x000fe200010f4c31ULL,
0x00000001034c7824ULL, 0x000fe200078e0250ULL, 0x0000000c6d497812ULL, 0x000fe200078efcffULL,
0x000000044e4e7824ULL, 0x000fe200078e00ffULL, 0x0000006b48487210ULL, 0x080fe20007f3e0ffULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x0000006b4c4c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001049207825ULL, 0x000fe200078e0020ULL, 0xfffffffc52457812ULL, 0x000fc400078ee20bULL,
0xfffffffc58477812ULL, 0x000fe200078ee20bULL, 0x000000ffff317224ULL, 0x000fe200008e06ffULL,
0x00005e0048327a11ULL, 0x000fe200078248ffULL, 0x000000ffff4b7224ULL, 0x000fe200010e06ffULL,
0x00005e004c307a11ULL, 0x000fe200078448ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000206f7faeULL, 0x0003e2000b901c46ULL, 0x00005f0048337a11ULL, 0x000fe200008f4c31ULL,
0x0000001045457824ULL, 0x000fe200078e026eULL, 0x00005f004c317a11ULL, 0x000fe200010f4c4bULL,
0x0000001049187825ULL, 0x000fe200078e0018ULL, 0xfffffffc4a4b7812ULL, 0x000fc400078ee20bULL,
0xfffffffc4e4d7812ULL, 0x000fe200078ee20bULL, 0x0000001049227825ULL, 0x040fe200078e0022ULL,
0x0000000018457faeULL, 0x0005e2000b901c46ULL, 0xfffffffc504f7812ULL, 0x000fe400078ee20bULL,
0x00000010491a7825ULL, 0x000fe200078e001aULL, 0xfffffffc44217812ULL, 0x002fc600078ee20bULL,
0x00000010492a7825ULL, 0x000fc800078e002aULL, 0x0000001049287825ULL, 0x000fc800078e0028ULL,
0x0000001049327825ULL, 0x000fc800078e0032ULL, 0x0000001049307825ULL, 0x000fe200078e0030ULL,
0xfffffffc46497812ULL, 0x000fc600078ee20bULL, 0x0000001047477824ULL, 0x100fe400078e026eULL,
0x0000001021197824ULL, 0x104fe400078e026eULL, 0x0000001049217824ULL, 0x100fe200078e026eULL,
0x0000000022477faeULL, 0x0003e2000b901c46ULL, 0x000000104d457824ULL, 0x000fc600078e026eULL,
0x000000001a197faeULL, 0x0005e8000b901c46ULL, 0x000000002a217faeULL, 0x0005e2000b901c46ULL,
0x000000104b237824ULL, 0x102fe400078e026eULL, 0x000000104f477824ULL, 0x000fc600078e026eULL,
0x0000000028237faeULL, 0x0005e8000b901c46ULL, 0x0000000032457faeULL, 0x0005e8000b901c46ULL,
0x0000000030477faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000080a187810ULL, 0x002fc80007ffe0ffULL, 0x0000000718187812ULL, 0x000fca00078e780dULL,
0x000000200d187824ULL, 0x000fc800078e0218ULL, 0x0000001018447824ULL, 0x000fe200078e00ffULL,
0x0000000a0a187810ULL, 0x000fc80007ffe0ffULL, 0x0000000718187812ULL, 0x000fe200078e780dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006c5c783bULL, 0x000fe20000000200ULL,
0x000000200d187824ULL, 0x000fc600078e0218ULL, 0x000000004444783bULL, 0x004e620000000200ULL,
0x0000001018287824ULL, 0x000fc600078e00ffULL, 0x000000006a50783bULL, 0x000ea80000000200ULL,
0x00000000694c783bULL, 0x000ee80000000200ULL, 0x000000006848783bULL, 0x000f280000000200ULL,
0x000000006758783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000006618783bULL, 0x000f280000000200ULL, 0x000000006520783bULL, 0x000f280000000200ULL,
0x000000006330783bULL, 0x000f220000000200ULL, 0x0000005c442c723cULL, 0x042ff0000004182cULL,
0x000000504454723cULL, 0x044ff00000041854ULL, 0x0000004c441c723cULL, 0x048ff0000004181cULL,
0x0000005e4440723cULL, 0x040ff00000041840ULL, 0x00000052443c723cULL, 0x040ff0000004183cULL,
0x0000004e4438723cULL, 0x040ff00000041838ULL, 0x000000484424723cULL, 0x050ff00000041824ULL,
0x0000004a4434723cULL, 0x000ff00000041834ULL, 0x00000058282c723cULL, 0x060ff0000004182cULL,
0x000000182854723cULL, 0x040ff00000041854ULL, 0x00000020281c723cULL, 0x040ff0000004181cULL,
0x0000005a2858723cULL, 0x040ff00000041840ULL, 0x0000001a2818723cULL, 0x040ff0000004183cULL,
0x000000222820723cULL, 0x040ff00000041838ULL, 0x000000302824723cULL, 0x040ff00000041824ULL,
0x000000322828723cULL, 0x000fe20000041834ULL, 0x0000063000008947ULL, 0x000fee0003800000ULL,
0x00000002ff397819ULL, 0x000fe20000011604ULL, 0x0000000160407824ULL, 0x000fe200078e0a09ULL,
0x000000106d417812ULL, 0x000fc400078efcffULL, 0x00000008393d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103307824ULL, 0x000fe200078e0239ULL, 0x0000001039427810ULL, 0x040fe40007ffe0ffULL,
0x0000001839447810ULL, 0x000fe20007ffe0ffULL, 0x0000000103327824ULL, 0x000fe200078e023dULL,
0x000000306b317210ULL, 0x000fe20007f3e0ffULL, 0x0000000103387824ULL, 0x000fe200078e0242ULL,
0x0000002839477810ULL, 0x000fe20007ffe0ffULL, 0x00000001033a7824ULL, 0x000fe200078e0244ULL,
0x000000326b337210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00005e0031347a11ULL, 0x000fe200078248ffULL, 0x000000043d4c7824ULL, 0x000fe200078e00ffULL,
0x000000386b387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e0033307a11ULL, 0x000fc400078448ffULL, 0x0000003a6b3a7210ULL, 0x000fe40007f9e0ffULL,
0x00005f0031357a11ULL, 0x000fe400008f4c32ULL, 0x00005f0033317a11ULL, 0x000fe200010f4c36ULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x00005e0038367a11ULL, 0x000fe200078248ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e06ffULL, 0x00005e003a327a11ULL, 0x000fe200078448ffULL,
0x0000001041347825ULL, 0x000fe200078e0034ULL, 0x0000002039467810ULL, 0x000fc40007ffe0ffULL,
0x00005f0038377a11ULL, 0x000fe200008f4c33ULL, 0x0000001041307825ULL, 0x000fe200078e0030ULL,
0x00005f003a337a11ULL, 0x000fe400010f4c3bULL, 0x0000003039487810ULL, 0x000fe20007ffe0ffULL,
0x00000001033a7824ULL, 0x000fe200078e0247ULL, 0x0000003839497810ULL, 0x000fe20007ffe0ffULL,
0x0000000103387824ULL, 0x000fe200078e0246ULL, 0x000000403900720cULL, 0x000fe20003f26070ULL,
0x00000001034a7824ULL, 0x000fe200078e0248ULL, 0x0000003a6b3e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0x000000386b3b7210ULL, 0x000fc40007f5e0ffULL,
0x0000004a6b4a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e06ffULL,
0x00005e003e387a11ULL, 0x040fe200078648ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078448ffULL, 0x0000001041327825ULL, 0x000fe200078e0032ULL,
0x00005f003e397a11ULL, 0x000fe200018f4c3fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000340e7faeULL, 0x0003e2000c901c46ULL, 0x00005f003b3b7a11ULL, 0x000fe200010f4c3cULL,
0x000000ffff3f7224ULL, 0x000fe200020e06ffULL, 0x00005e004a3c7a11ULL, 0x040fe200078648ffULL,
0x00000001033e7824ULL, 0x000fe200078e0249ULL, 0x000000403d00720cULL, 0x000fe20003f46070ULL,
0x00000010413a7825ULL, 0x000fe200078e003aULL, 0x00005f004a3d7a11ULL, 0x000fc400018f4c3fULL,
0xfffffffc4c3f7812ULL, 0x000fe200078ee20bULL, 0x0000001041387825ULL, 0x000fe200078e0038ULL,
0x0000003e6b457210ULL, 0x000fe40007f9e0ffULL, 0x000000404200720cULL, 0x080fe20003f26070ULL,
0x000000103f437824ULL, 0x000fe200078e020cULL, 0x00005e00453e7a11ULL, 0x040fe200078648ffULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x000000404800720cULL, 0x080fe20003fa6070ULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000000030437faeULL, 0x0005e2000d101c46ULL,
0x000000404400720cULL, 0x0c0fe20003f46070ULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x00005f00453f7a11ULL, 0x000fe200018f4c4aULL, 0x0000000448487824ULL, 0x000fe200078e00ffULL,
0x000000404600720cULL, 0x0c0fe20003f66070ULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0xfffffffc42457812ULL, 0x000fe200078ee20bULL, 0x0000000449347824ULL, 0x002fe200078e00ffULL,
0x000000404700720cULL, 0x080fe20003f86070ULL, 0x00000010413c7825ULL, 0x000fe200078e003cULL,
0x000000404900720cULL, 0x000fc40003fc6070ULL, 0xfffffffc44317812ULL, 0x104fe200078ee20bULL,
0x0000000447307824ULL, 0x000fe200078e00ffULL, 0xfffffffc46357812ULL, 0x000fe200078ee20bULL,
0x00000010413e7825ULL, 0x000fe200078e003eULL, 0xfffffffc48437812ULL, 0x100fe400078ee20bULL,
0xfffffffc30417812ULL, 0x100fe200078ee20bULL, 0x0000001045457824ULL, 0x100fe200078e020cULL,
0xfffffffc34477812ULL, 0x000fe200078ee20bULL, 0x0000001031317824ULL, 0x100fe400078e020cULL,
0x0000001035357824ULL, 0x100fe200078e020cULL, 0x0000000036457faeULL, 0x0003e2000c901c46ULL,
0x0000001041417824ULL, 0x000fc400078e020cULL, 0x0000001043437824ULL, 0x100fe200078e020cULL,
0x0000000032317faeULL, 0x0003e2000d101c46ULL, 0x0000001047477824ULL, 0x000fc600078e020cULL,
0x000000003a357faeULL, 0x0003e8000d901c46ULL, 0x0000000038417faeULL, 0x0003e8000e101c46ULL,
0x000000003c437faeULL, 0x0003e8000e901c46ULL, 0x000000003e477faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x00000008043c7811ULL, 0x040fe400078ff0ffULL,
0x0000000304307211ULL, 0x000fc400078ff0ffULL, 0x00000010043e7811ULL, 0x000fe200078ff0ffULL,
0x0000000103327824ULL, 0x000fe200078e023cULL, 0x0000006b30317210ULL, 0x080fe20007f3e0ffULL,
0x000000043c4e7824ULL, 0x000fe200078e00ffULL, 0x0000001804407811ULL, 0x000fe200078ff0ffULL,
0x000000043e507824ULL, 0x000fe200078e00ffULL, 0x0000006b32337210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x00005e0031367a11ULL, 0x000fe400078248ffULL,
0x0000002004427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e0033307a11ULL, 0x000fc400078448ffULL, 0x00005f0031377a11ULL, 0x000fe200008f4c32ULL,
0x0000000103327824ULL, 0x000fe200078e023eULL, 0x00005f0033317a11ULL, 0x000fe200010f4c34ULL,
0x0000000103347824ULL, 0x040fe200078e0240ULL, 0x0000002804467811ULL, 0x000fe200078ff0ffULL,
0x0000000103447824ULL, 0x040fe200078e0242ULL, 0x0000006b32337210ULL, 0x080fe20007f3e0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000006b34397210ULL, 0x080fe20007f5e0ffULL,
0x0000000103487824ULL, 0x000fe200078e0246ULL, 0x00000030044a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e0033347a11ULL, 0x000fe200078248ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e0039327a11ULL, 0x000fe200078448ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x00005f0033357a11ULL, 0x000fe200008f4c38ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x0000006b44447210ULL, 0x000fc40007f3e0ffULL,
0x00005f0039337a11ULL, 0x000fe400010f4c3aULL, 0x0000006b48487210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e00443a7a11ULL, 0x000fe400078248ffULL,
0x00000038044c7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff3d7224ULL, 0x000fe200010e06ffULL,
0x00005e0048387a11ULL, 0x000fe400078448ffULL, 0x00005f00443b7a11ULL, 0x000fe200008f4c39ULL,
0x0000000103447824ULL, 0x040fe200078e024aULL, 0x00005f0048397a11ULL, 0x000fe200010f4c3dULL,
0x0000000103487824ULL, 0x000fe200078e024cULL, 0x000000106d417812ULL, 0x000fe200078efcffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x0000006b44447210ULL, 0x080fe20007f3e0ffULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0x0000006b48487210ULL, 0x000fe20007f5e0ffULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0xfffffffc4e437812ULL, 0x000fc400078ee20bULL,
0xfffffffc50457812ULL, 0x000fe200078ee20bULL, 0x000000ffff3d7224ULL, 0x000fe200008e06ffULL,
0x00005e00443e7a11ULL, 0x000fe200078248ffULL, 0x000000ffff477224ULL, 0x000fe200010e06ffULL,
0x00005e00483c7a11ULL, 0x000fe200078448ffULL, 0x0000001043437824ULL, 0x000fe200078e020cULL,
0x00005f00443f7a11ULL, 0x000fe200008f4c3dULL, 0x0000001041307825ULL, 0x040fe200078e0030ULL,
0x00005f00483d7a11ULL, 0x000fe200010f4c47ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000360e7faeULL, 0x0003e2000b901c46ULL, 0xfffffffc46477812ULL, 0x000fe200078ee20bULL,
0x0000001041347825ULL, 0x040fe200078e0034ULL, 0xfffffffc4a497812ULL, 0x000fe200078ee20bULL,
0x0000000030437faeULL, 0x0005e4000b901c46ULL, 0x0000001041327825ULL, 0x000fc800078e0032ULL,
0x00000010413a7825ULL, 0x000fe200078e003aULL, 0xfffffffc40377812ULL, 0x002fc600078ee20bULL,
0x0000001041387825ULL, 0x000fe200078e0038ULL, 0xfffffffc4c317812ULL, 0x004fc600078ee20bULL,
0x00000010413e7825ULL, 0x000fc800078e003eULL, 0x00000010413c7825ULL, 0x000fe200078e003cULL,
0xfffffffc42417812ULL, 0x000fc600078ee20bULL, 0x0000001045457824ULL, 0x100fe400078e020cULL,
0x0000001037377824ULL, 0x100fe400078e020cULL, 0x0000001041417824ULL, 0x100fe200078e020cULL,
0x0000000034457faeULL, 0x0003e2000b901c46ULL, 0x0000001047477824ULL, 0x100fe400078e020cULL,
0x0000001049497824ULL, 0x100fe200078e020cULL, 0x0000000032377faeULL, 0x0003e2000b901c46ULL,
0x0000001031317824ULL, 0x000fc600078e020cULL, 0x000000003a417faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x000000003e497faeULL, 0x0003e8000b901c46ULL,
0x000000003c317faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000c0a307810ULL, 0x000fc80007ffe0ffULL, 0x0000000730307812ULL, 0x000fca00078e780dULL,
0x000000200d307824ULL, 0x000fc800078e0230ULL, 0x0000001030447824ULL, 0x000fe200078e00ffULL,
0x0000000e0a307810ULL, 0x000fc80007ffe0ffULL, 0x0000000730307812ULL, 0x000fe200078e780dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000f5c783bULL, 0x000fe20000000200ULL,
0x000000200d307824ULL, 0x000fc600078e0230ULL, 0x000000004444783bULL, 0x002e620000000200ULL,
0x0000001030307824ULL, 0x000fc600078e00ffULL, 0x000000001050783bULL, 0x000ea80000000200ULL,
0x00000000114c783bULL, 0x000ee80000000200ULL, 0x000000001248783bULL, 0x000f280000000200ULL,
0x000000001340783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000f680000000200ULL,
0x00000000143c783bULL, 0x000ee80000000200ULL, 0x000000001538783bULL, 0x000ee80000000200ULL,
0x000000001634783bULL, 0x000ee20000000200ULL, 0x0000005c442c723cULL, 0x042ff0000004182cULL,
0x0000005e4458723cULL, 0x040ff00000041858ULL, 0x000000504454723cULL, 0x044ff00000041854ULL,
0x000000524418723cULL, 0x040ff00000041818ULL, 0x0000004c441c723cULL, 0x048ff0000004181cULL,
0x0000004e4420723cULL, 0x040ff00000041820ULL, 0x000000484424723cULL, 0x050ff00000041824ULL,
0x0000004a4428723cULL, 0x000ff00000041828ULL, 0x00000040302c723cULL, 0x060ff0000004182cULL,
0x000000423058723cULL, 0x040ff00000041858ULL, 0x0000003c3054723cULL, 0x040ff00000041854ULL,
0x0000003e3018723cULL, 0x040ff00000041818ULL, 0x00000038301c723cULL, 0x040ff0000004181cULL,
0x0000003a3020723cULL, 0x040ff00000041820ULL, 0x000000343024723cULL, 0x040ff00000041824ULL,
0x000000363030723cULL, 0x000fe20000041828ULL, 0x0000063000008947ULL, 0x000fee0003800000ULL,
0x00000002ff397819ULL, 0x000fe20000011604ULL, 0x0000000160407824ULL, 0x000fe200078e0a09ULL,
0x000000146d417812ULL, 0x000fc400078efcffULL, 0x00000008393d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103287824ULL, 0x000fe200078e0239ULL, 0x0000001039427810ULL, 0x040fe40007ffe0ffULL,
0x0000001839447810ULL, 0x000fe20007ffe0ffULL, 0x00000001032a7824ULL, 0x000fe200078e023dULL,
0x000000286b297210ULL, 0x000fe20007f3e0ffULL, 0x0000000103387824ULL, 0x000fe200078e0242ULL,
0x0000002839477810ULL, 0x000fe20007ffe0ffULL, 0x00000001033a7824ULL, 0x000fe200078e0244ULL,
0x0000002a6b2b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0029347a11ULL, 0x000fe200078248ffULL, 0x000000043d4c7824ULL, 0x000fe200078e00ffULL,
0x000000386b387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e002b287a11ULL, 0x000fc400078448ffULL, 0x0000003a6b3a7210ULL, 0x000fe40007f9e0ffULL,
0x00005f0029357a11ULL, 0x000fe400008f4c2aULL, 0x00005f002b297a11ULL, 0x000fe200010f4c36ULL,
0x000000ffff2b7224ULL, 0x000fe200018e06ffULL, 0x00005e0038367a11ULL, 0x000fe200078248ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e06ffULL, 0x00005e003a2a7a11ULL, 0x000fe200078448ffULL,
0x0000001041347825ULL, 0x000fe200078e0034ULL, 0x0000002039467810ULL, 0x000fc40007ffe0ffULL,
0x00005f0038377a11ULL, 0x000fe200008f4c2bULL, 0x0000001041287825ULL, 0x000fe200078e0028ULL,
0x00005f003a2b7a11ULL, 0x000fe400010f4c3bULL, 0x0000003039487810ULL, 0x000fe20007ffe0ffULL,
0x00000001033a7824ULL, 0x000fe200078e0247ULL, 0x0000003839497810ULL, 0x000fe20007ffe0ffULL,
0x0000000103387824ULL, 0x000fe200078e0246ULL, 0x000000403900720cULL, 0x000fe20003f26070ULL,
0x00000001034a7824ULL, 0x000fe200078e0248ULL, 0x0000003a6b3e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0x000000386b3b7210ULL, 0x000fc40007f5e0ffULL,
0x0000004a6b4a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e06ffULL,
0x00005e003e387a11ULL, 0x040fe200078648ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078448ffULL, 0x00000010412a7825ULL, 0x000fe200078e002aULL,
0x00005f003e397a11ULL, 0x000fe200018f4c3fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000346f7faeULL, 0x0003e2000c901c46ULL, 0x00005f003b3b7a11ULL, 0x000fe200010f4c3cULL,
0x000000ffff3f7224ULL, 0x000fe200020e06ffULL, 0x00005e004a3c7a11ULL, 0x040fe200078648ffULL,
0x00000001033e7824ULL, 0x000fe200078e0249ULL, 0x000000403d00720cULL, 0x000fe20003f46070ULL,
0x00000010413a7825ULL, 0x000fe200078e003aULL, 0x00005f004a3d7a11ULL, 0x000fc400018f4c3fULL,
0xfffffffc4c3f7812ULL, 0x000fe200078ee20bULL, 0x0000001041387825ULL, 0x000fe200078e0038ULL,
0x0000003e6b457210ULL, 0x000fe40007f9e0ffULL, 0x000000404200720cULL, 0x080fe20003f26070ULL,
0x000000103f437824ULL, 0x000fe200078e026eULL, 0x00005e00453e7a11ULL, 0x040fe200078648ffULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x000000404800720cULL, 0x080fe20003fa6070ULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000000028437faeULL, 0x0005e2000d101c46ULL,
0x000000404400720cULL, 0x0c0fe20003f46070ULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x00005f00453f7a11ULL, 0x000fe200018f4c4aULL, 0x0000000448487824ULL, 0x000fe200078e00ffULL,
0x000000404600720cULL, 0x0c0fe20003f66070ULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0xfffffffc42457812ULL, 0x000fe200078ee20bULL, 0x0000000449347824ULL, 0x002fe200078e00ffULL,
0x000000404700720cULL, 0x080fe20003f86070ULL, 0x00000010413c7825ULL, 0x000fe200078e003cULL,
0x000000404900720cULL, 0x000fc40003fc6070ULL, 0xfffffffc44297812ULL, 0x104fe200078ee20bULL,
0x0000000447287824ULL, 0x000fe200078e00ffULL, 0xfffffffc46357812ULL, 0x000fe200078ee20bULL,
0x00000010413e7825ULL, 0x000fe200078e003eULL, 0xfffffffc48437812ULL, 0x100fe400078ee20bULL,
0xfffffffc28417812ULL, 0x100fe200078ee20bULL, 0x0000001045457824ULL, 0x100fe200078e026eULL,
0xfffffffc34477812ULL, 0x000fe200078ee20bULL, 0x0000001029297824ULL, 0x100fe400078e026eULL,
0x0000001035357824ULL, 0x100fe200078e026eULL, 0x0000000036457faeULL, 0x0003e2000c901c46ULL,
0x0000001041417824ULL, 0x000fc400078e026eULL, 0x0000001043437824ULL, 0x100fe200078e026eULL,
0x000000002a297faeULL, 0x0003e2000d101c46ULL, 0x0000001047477824ULL, 0x000fc600078e026eULL,
0x000000003a357faeULL, 0x0003e8000d901c46ULL, 0x0000000038417faeULL, 0x0003e8000e101c46ULL,
0x000000003c437faeULL, 0x0003e8000e901c46ULL, 0x000000003e477faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x00000008043c7811ULL, 0x040fe400078ff0ffULL,
0x0000000304287211ULL, 0x000fc400078ff0ffULL, 0x00000010043e7811ULL, 0x000fe200078ff0ffULL,
0x00000001032a7824ULL, 0x000fe200078e023cULL, 0x0000006b28297210ULL, 0x080fe20007f3e0ffULL,
0x000000043c4e7824ULL, 0x000fe200078e00ffULL, 0x0000001804407811ULL, 0x000fe200078ff0ffULL,
0x000000043e507824ULL, 0x000fe200078e00ffULL, 0x0000006b2a2b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0029367a11ULL, 0x000fe400078248ffULL,
0x0000002004427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e002b287a11ULL, 0x000fc400078448ffULL, 0x00005f0029377a11ULL, 0x000fe200008f4c2aULL,
0x00000001032a7824ULL, 0x000fe200078e023eULL, 0x00005f002b297a11ULL, 0x000fe200010f4c34ULL,
0x0000000103347824ULL, 0x040fe200078e0240ULL, 0x0000002804467811ULL, 0x000fe200078ff0ffULL,
0x0000000103447824ULL, 0x040fe200078e0242ULL, 0x0000006b2a2b7210ULL, 0x080fe20007f3e0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000006b34397210ULL, 0x080fe20007f5e0ffULL,
0x0000000103487824ULL, 0x000fe200078e0246ULL, 0x00000030044a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e002b347a11ULL, 0x000fe200078248ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e00392a7a11ULL, 0x000fe200078448ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x00005f002b357a11ULL, 0x000fe200008f4c38ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x0000006b44447210ULL, 0x000fc40007f3e0ffULL,
0x00005f00392b7a11ULL, 0x000fe400010f4c3aULL, 0x0000006b48487210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e00443a7a11ULL, 0x000fe400078248ffULL,
0x00000038044c7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff3d7224ULL, 0x000fe200010e06ffULL,
0x00005e0048387a11ULL, 0x000fe400078448ffULL, 0x00005f00443b7a11ULL, 0x000fe200008f4c39ULL,
0x0000000103447824ULL, 0x040fe200078e024aULL, 0x00005f0048397a11ULL, 0x000fe200010f4c3dULL,
0x0000000103487824ULL, 0x000fe200078e024cULL, 0x000000146d417812ULL, 0x000fe200078efcffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x0000006b44447210ULL, 0x080fe20007f3e0ffULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0x0000006b48487210ULL, 0x000fe20007f5e0ffULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0xfffffffc4e437812ULL, 0x000fc400078ee20bULL,
0xfffffffc50457812ULL, 0x000fe200078ee20bULL, 0x000000ffff3d7224ULL, 0x000fe200008e06ffULL,
0x00005e00443e7a11ULL, 0x000fe200078248ffULL, 0x000000ffff477224ULL, 0x000fe200010e06ffULL,
0x00005e00483c7a11ULL, 0x000fe200078448ffULL, 0x0000001043437824ULL, 0x000fe200078e026eULL,
0x00005f00443f7a11ULL, 0x000fe200008f4c3dULL, 0x0000001041287825ULL, 0x040fe200078e0028ULL,
0x00005f00483d7a11ULL, 0x000fe200010f4c47ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000366f7faeULL, 0x0003e2000b901c46ULL, 0xfffffffc46477812ULL, 0x000fe200078ee20bULL,
0x0000001041347825ULL, 0x040fe200078e0034ULL, 0xfffffffc4a497812ULL, 0x000fe200078ee20bULL,
0x0000000028437faeULL, 0x0005e4000b901c46ULL, 0x00000010412a7825ULL, 0x000fc800078e002aULL,
0x00000010413a7825ULL, 0x000fe200078e003aULL, 0xfffffffc40377812ULL, 0x002fc600078ee20bULL,
0x0000001041387825ULL, 0x000fe200078e0038ULL, 0xfffffffc4c297812ULL, 0x004fc600078ee20bULL,
0x00000010413e7825ULL, 0x000fc800078e003eULL, 0x00000010413c7825ULL, 0x000fe200078e003cULL,
0xfffffffc42417812ULL, 0x000fc600078ee20bULL, 0x0000001045457824ULL, 0x100fe400078e026eULL,
0x0000001037377824ULL, 0x100fe400078e026eULL, 0x0000001041417824ULL, 0x100fe200078e026eULL,
0x0000000034457faeULL, 0x0003e2000b901c46ULL, 0x0000001047477824ULL, 0x100fe400078e026eULL,
0x0000001049497824ULL, 0x100fe200078e026eULL, 0x000000002a377faeULL, 0x0003e2000b901c46ULL,
0x0000001029297824ULL, 0x000fc600078e026eULL, 0x000000003a417faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x000000003e497faeULL, 0x0003e8000b901c46ULL,
0x000000003c297faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100a287810ULL, 0x000fc40007ffe0ffULL, 0x000000120a347810ULL, 0x002fe40007ffe0ffULL,
0x0000000728287812ULL, 0x100fe400078e780dULL, 0x0000000734347812ULL, 0x000fc600078e780dULL,
0x000000200d287824ULL, 0x040fe400078e0228ULL, 0x000000200d347824ULL, 0x000fe400078e0234ULL,
0x0000001028487824ULL, 0x000fe400078e00ffULL, 0x0000001034347824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006c28783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x000000006a5c783bULL, 0x000ea80000000200ULL,
0x000000006950783bULL, 0x000ee80000000200ULL, 0x00000000684c783bULL, 0x000f280000000200ULL,
0x000000006744783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000f680000000200ULL,
0x000000006640783bULL, 0x000ee80000000200ULL, 0x00000000653c783bULL, 0x000ee80000000200ULL,
0x000000006338783bULL, 0x000ee20000000200ULL, 0x00000028482c723cULL, 0x042ff0000004182cULL,
0x0000002a4858723cULL, 0x040ff00000041858ULL, 0x0000005c4854723cULL, 0x044ff00000041854ULL,
0x0000005e4818723cULL, 0x040ff00000041818ULL, 0x00000050481c723cULL, 0x048ff0000004181cULL,
0x000000524820723cULL, 0x040ff00000041820ULL, 0x0000004c4824723cULL, 0x050ff00000041824ULL,
0x0000004e4830723cULL, 0x000ff00000041830ULL, 0x00000044342c723cULL, 0x060ff0000004182cULL,
0x000000463458723cULL, 0x040ff00000041858ULL, 0x000000403454723cULL, 0x040ff00000041854ULL,
0x000000423418723cULL, 0x040ff00000041818ULL, 0x0000003c341c723cULL, 0x040ff0000004181cULL,
0x0000003e3420723cULL, 0x040ff00000041820ULL, 0x000000383424723cULL, 0x040ff00000041824ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x0000063000008947ULL, 0x000fee0003800000ULL,
0x00000002ff397819ULL, 0x000fe20000011604ULL, 0x0000000160407824ULL, 0x000fe200078e0a09ULL,
0x000000186d417812ULL, 0x000fc400078efcffULL, 0x00000008393d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103287824ULL, 0x000fe200078e0239ULL, 0x0000001039427810ULL, 0x040fe40007ffe0ffULL,
0x0000001839447810ULL, 0x000fe20007ffe0ffULL, 0x00000001032a7824ULL, 0x000fe200078e023dULL,
0x000000286b297210ULL, 0x000fe20007f3e0ffULL, 0x0000000103387824ULL, 0x000fe200078e0242ULL,
0x0000002839477810ULL, 0x000fe20007ffe0ffULL, 0x00000001033a7824ULL, 0x000fe200078e0244ULL,
0x0000002a6b2b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0029347a11ULL, 0x000fe200078248ffULL, 0x000000043d4c7824ULL, 0x000fe200078e00ffULL,
0x000000386b387210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e002b287a11ULL, 0x000fc400078448ffULL, 0x0000003a6b3a7210ULL, 0x000fe40007f9e0ffULL,
0x00005f0029357a11ULL, 0x000fe400008f4c2aULL, 0x00005f002b297a11ULL, 0x000fe200010f4c36ULL,
0x000000ffff2b7224ULL, 0x000fe200018e06ffULL, 0x00005e0038367a11ULL, 0x000fe200078248ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e06ffULL, 0x00005e003a2a7a11ULL, 0x000fe200078448ffULL,
0x0000001041347825ULL, 0x000fe200078e0034ULL, 0x0000002039467810ULL, 0x000fc40007ffe0ffULL,
0x00005f0038377a11ULL, 0x000fe200008f4c2bULL, 0x0000001041287825ULL, 0x000fe200078e0028ULL,
0x00005f003a2b7a11ULL, 0x000fe400010f4c3bULL, 0x0000003039487810ULL, 0x000fe20007ffe0ffULL,
0x00000001033a7824ULL, 0x000fe200078e0247ULL, 0x0000003839497810ULL, 0x000fe20007ffe0ffULL,
0x0000000103387824ULL, 0x000fe200078e0246ULL, 0x000000403900720cULL, 0x000fe20003f26070ULL,
0x00000001034a7824ULL, 0x000fe200078e0248ULL, 0x0000003a6b3e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0x000000386b3b7210ULL, 0x000fc40007f5e0ffULL,
0x0000004a6b4a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e06ffULL,
0x00005e003e387a11ULL, 0x040fe200078648ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078448ffULL, 0x00000010412a7825ULL, 0x000fe200078e002aULL,
0x00005f003e397a11ULL, 0x000fe200018f4c3fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000340e7faeULL, 0x0003e2000c901c46ULL, 0x00005f003b3b7a11ULL, 0x000fe200010f4c3cULL,
0x000000ffff3f7224ULL, 0x000fe200020e06ffULL, 0x00005e004a3c7a11ULL, 0x040fe200078648ffULL,
0x00000001033e7824ULL, 0x000fe200078e0249ULL, 0x000000403d00720cULL, 0x000fe20003f46070ULL,
0x00000010413a7825ULL, 0x000fe200078e003aULL, 0x00005f004a3d7a11ULL, 0x000fc400018f4c3fULL,
0xfffffffc4c3f7812ULL, 0x000fe200078ee20bULL, 0x0000001041387825ULL, 0x000fe200078e0038ULL,
0x0000003e6b457210ULL, 0x000fe40007f9e0ffULL, 0x000000404200720cULL, 0x080fe20003f26070ULL,
0x000000103f437824ULL, 0x000fe200078e020cULL, 0x00005e00453e7a11ULL, 0x040fe200078648ffULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x000000404800720cULL, 0x080fe20003fa6070ULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000000028437faeULL, 0x0005e2000d101c46ULL,
0x000000404400720cULL, 0x0c0fe20003f46070ULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x00005f00453f7a11ULL, 0x000fe200018f4c4aULL, 0x0000000448487824ULL, 0x000fe200078e00ffULL,
0x000000404600720cULL, 0x0c0fe20003f66070ULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0xfffffffc42457812ULL, 0x000fe200078ee20bULL, 0x0000000449347824ULL, 0x002fe200078e00ffULL,
0x000000404700720cULL, 0x080fe20003f86070ULL, 0x00000010413c7825ULL, 0x000fe200078e003cULL,
0x000000404900720cULL, 0x000fc40003fc6070ULL, 0xfffffffc44297812ULL, 0x104fe200078ee20bULL,
0x0000000447287824ULL, 0x000fe200078e00ffULL, 0xfffffffc46357812ULL, 0x000fe200078ee20bULL,
0x00000010413e7825ULL, 0x000fe200078e003eULL, 0xfffffffc48437812ULL, 0x100fe400078ee20bULL,
0xfffffffc28417812ULL, 0x100fe200078ee20bULL, 0x0000001045457824ULL, 0x100fe200078e020cULL,
0xfffffffc34477812ULL, 0x000fe200078ee20bULL, 0x0000001029297824ULL, 0x100fe400078e020cULL,
0x0000001035357824ULL, 0x100fe200078e020cULL, 0x0000000036457faeULL, 0x0003e2000c901c46ULL,
0x0000001041417824ULL, 0x000fc400078e020cULL, 0x0000001043437824ULL, 0x100fe200078e020cULL,
0x000000002a297faeULL, 0x0003e2000d101c46ULL, 0x0000001047477824ULL, 0x000fc600078e020cULL,
0x000000003a357faeULL, 0x0003e8000d901c46ULL, 0x0000000038417faeULL, 0x0003e8000e101c46ULL,
0x000000003c437faeULL, 0x0003e8000e901c46ULL, 0x000000003e477faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x00000008043c7811ULL, 0x040fe400078ff0ffULL,
0x0000000304287211ULL, 0x000fc400078ff0ffULL, 0x00000010043e7811ULL, 0x000fe200078ff0ffULL,
0x00000001032a7824ULL, 0x000fe200078e023cULL, 0x0000006b28297210ULL, 0x080fe20007f3e0ffULL,
0x000000043c4e7824ULL, 0x000fe200078e00ffULL, 0x0000001804407811ULL, 0x000fe200078ff0ffULL,
0x000000043e507824ULL, 0x000fe200078e00ffULL, 0x0000006b2a2b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0029367a11ULL, 0x000fe400078248ffULL,
0x0000002004427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e002b287a11ULL, 0x000fc400078448ffULL, 0x00005f0029377a11ULL, 0x000fe200008f4c2aULL,
0x00000001032a7824ULL, 0x000fe200078e023eULL, 0x00005f002b297a11ULL, 0x000fe200010f4c34ULL,
0x0000000103347824ULL, 0x040fe200078e0240ULL, 0x0000002804467811ULL, 0x000fe200078ff0ffULL,
0x0000000103447824ULL, 0x040fe200078e0242ULL, 0x0000006b2a2b7210ULL, 0x080fe20007f3e0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000006b34397210ULL, 0x080fe20007f5e0ffULL,
0x0000000103487824ULL, 0x000fe200078e0246ULL, 0x00000030044a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e002b347a11ULL, 0x000fe200078248ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e00392a7a11ULL, 0x000fe200078448ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x00005f002b357a11ULL, 0x000fe200008f4c38ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x0000006b44447210ULL, 0x000fc40007f3e0ffULL,
0x00005f00392b7a11ULL, 0x000fe400010f4c3aULL, 0x0000006b48487210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e00443a7a11ULL, 0x000fe400078248ffULL,
0x00000038044c7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff3d7224ULL, 0x000fe200010e06ffULL,
0x00005e0048387a11ULL, 0x000fe400078448ffULL, 0x00005f00443b7a11ULL, 0x000fe200008f4c39ULL,
0x0000000103447824ULL, 0x040fe200078e024aULL, 0x00005f0048397a11ULL, 0x000fe200010f4c3dULL,
0x0000000103487824ULL, 0x000fe200078e024cULL, 0x000000186d417812ULL, 0x000fe200078efcffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x0000006b44447210ULL, 0x080fe20007f3e0ffULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0x0000006b48487210ULL, 0x000fe20007f5e0ffULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0xfffffffc4e437812ULL, 0x000fc400078ee20bULL,
0xfffffffc50457812ULL, 0x000fe200078ee20bULL, 0x000000ffff3d7224ULL, 0x000fe200008e06ffULL,
0x00005e00443e7a11ULL, 0x000fe200078248ffULL, 0x000000ffff477224ULL, 0x000fe200010e06ffULL,
0x00005e00483c7a11ULL, 0x000fe200078448ffULL, 0x0000001043437824ULL, 0x000fe200078e020cULL,
0x00005f00443f7a11ULL, 0x000fe200008f4c3dULL, 0x0000001041287825ULL, 0x040fe200078e0028ULL,
0x00005f00483d7a11ULL, 0x000fe200010f4c47ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000360e7faeULL, 0x0003e2000b901c46ULL, 0xfffffffc46477812ULL, 0x000fe200078ee20bULL,
0x0000001041347825ULL, 0x040fe200078e0034ULL, 0xfffffffc4a497812ULL, 0x000fe200078ee20bULL,
0x0000000028437faeULL, 0x0005e4000b901c46ULL, 0x00000010412a7825ULL, 0x000fc800078e002aULL,
0x00000010413a7825ULL, 0x000fe200078e003aULL, 0xfffffffc40377812ULL, 0x002fc600078ee20bULL,
0x0000001041387825ULL, 0x000fe200078e0038ULL, 0xfffffffc4c297812ULL, 0x004fc600078ee20bULL,
0x00000010413e7825ULL, 0x000fc800078e003eULL, 0x00000010413c7825ULL, 0x000fe200078e003cULL,
0xfffffffc42417812ULL, 0x000fc600078ee20bULL, 0x0000001045457824ULL, 0x100fe400078e020cULL,
0x0000001037377824ULL, 0x100fe400078e020cULL, 0x0000001041417824ULL, 0x100fe200078e020cULL,
0x0000000034457faeULL, 0x0003e2000b901c46ULL, 0x0000001047477824ULL, 0x100fe400078e020cULL,
0x0000001049497824ULL, 0x100fe200078e020cULL, 0x000000002a377faeULL, 0x0003e2000b901c46ULL,
0x0000001029297824ULL, 0x000fc600078e020cULL, 0x000000003a417faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x000000003e497faeULL, 0x0003e8000b901c46ULL,
0x000000003c297faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000140a287810ULL, 0x000fc40007ffe0ffULL, 0x000000160a347810ULL, 0x002fe40007ffe0ffULL,
0x0000000728287812ULL, 0x100fe400078e780dULL, 0x0000000734347812ULL, 0x000fc600078e780dULL,
0x000000200d287824ULL, 0x040fe400078e0228ULL, 0x000000200d347824ULL, 0x000fe400078e0234ULL,
0x0000001028487824ULL, 0x000fe400078e00ffULL, 0x0000001034347824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000f28783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x00000000105c783bULL, 0x000ea80000000200ULL,
0x000000001150783bULL, 0x000ee80000000200ULL, 0x00000000124c783bULL, 0x000f280000000200ULL,
0x000000001344783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000f680000000200ULL,
0x000000001440783bULL, 0x000ee80000000200ULL, 0x00000000153c783bULL, 0x000ee80000000200ULL,
0x000000001638783bULL, 0x000ee20000000200ULL, 0x00000028482c723cULL, 0x042ff0000004182cULL,
0x0000002a4858723cULL, 0x040ff00000041858ULL, 0x0000005c4854723cULL, 0x044ff00000041854ULL,
0x0000005e4818723cULL, 0x040ff00000041818ULL, 0x00000050481c723cULL, 0x048ff0000004181cULL,
0x000000524820723cULL, 0x040ff00000041820ULL, 0x0000004c4824723cULL, 0x050ff00000041824ULL,
0x0000004e4830723cULL, 0x000ff00000041830ULL, 0x00000044342c723cULL, 0x060ff0000004182cULL,
0x000000463458723cULL, 0x040ff00000041858ULL, 0x000000403454723cULL, 0x040ff00000041854ULL,
0x000000423418723cULL, 0x040ff00000041818ULL, 0x0000003c341c723cULL, 0x040ff0000004181cULL,
0x0000003e3420723cULL, 0x040ff00000041820ULL, 0x000000383424723cULL, 0x040ff00000041824ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x0000063000008947ULL, 0x000fee0003800000ULL,
0x00000002ff347819ULL, 0x000fe20000011604ULL, 0x0000000160407824ULL, 0x000fe200078e0a09ULL,
0x0000001c6d6d7812ULL, 0x000fc400078efcffULL, 0x0000001034427810ULL, 0x040fe20007ffe0ffULL,
0x0000000103287824ULL, 0x040fe200078e0234ULL, 0x0000000834417810ULL, 0x040fe40007ffe0ffULL,
0x0000001834437810ULL, 0x040fe20007ffe0ffULL, 0x0000000103367824ULL, 0x000fe200078e0242ULL,
0x000000286b297210ULL, 0x000fe20007f1e0ffULL, 0x00000001032a7824ULL, 0x000fe200078e0241ULL,
0x0000002034447810ULL, 0x000fe40007ffe0ffULL, 0x000000366b357210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff367224ULL, 0x000fe200000e06ffULL, 0x0000002a6b2b7210ULL, 0x000fc40007f3e0ffULL,
0x00005e00293a7a11ULL, 0x000fe200078048ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e0035287a11ULL, 0x000fe200078448ffULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x00005f00293b7a11ULL, 0x000fe200000f4c36ULL, 0x0000000103367824ULL, 0x000fe200078e0243ULL,
0x00005e002b2a7a11ULL, 0x000fe400078248ffULL, 0x0000002834457810ULL, 0x040fe20007ffe0ffULL,
0x000000106d3a7825ULL, 0x000fe200078e003aULL, 0x0000003034477810ULL, 0x000fc40007ffe0ffULL,
0x00000038344b7810ULL, 0x040fe40007ffe0ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c38ULL,
0x0000000103387824ULL, 0x000fe200078e0244ULL, 0x00005f0035297a11ULL, 0x000fe200010f4c3cULL,
0x00000001033c7824ULL, 0x040fe200078e0245ULL, 0x000000403400720cULL, 0x000fe20003f06070ULL,
0x00000001033e7824ULL, 0x000fe200078e0247ULL, 0x000000366b347210ULL, 0x000fe20007f3e0ffULL,
0x0000000103467824ULL, 0x000fe200078e024bULL, 0x000000386b397210ULL, 0x000fe20007f9e0ffULL,
0x000000106d2a7825ULL, 0x000fe200078e002aULL, 0x0000003c6b3d7210ULL, 0x000fc40007fbe0ffULL,
0x0000003e6b497210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff357224ULL, 0x000fe200008e06ffULL,
0x00005e0034367a11ULL, 0x040fe200078648ffULL, 0x000000ffff487224ULL, 0x000fe200028e06ffULL,
0x000000466b6b7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x00005f0034377a11ULL, 0x000fe200018f4c35ULL, 0x000000ffff4a7224ULL, 0x000fe200010e06ffULL,
0x00005e00393e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078848ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a6f7faeULL, 0x0003e2000c101c46ULL, 0x00005e0049387a11ULL, 0x000fe200078448ffULL,
0x000000106d287825ULL, 0x000fe200078e0028ULL, 0x00005e006b347a11ULL, 0x000fc400078248ffULL,
0x00005f00393f7a11ULL, 0x000fe200018f4c46ULL, 0x0000000443467824ULL, 0x000fe200078e00ffULL,
0x00005f003d3d7a11ULL, 0x000fe200020f4c48ULL, 0x0000000447487824ULL, 0x000fe200078e00ffULL,
0x00005f0049397a11ULL, 0x000fe200010f4c4aULL, 0x000000044b4a7824ULL, 0x000fe200078e00ffULL,
0x00005f006b357a11ULL, 0x000fe200008f4c4cULL, 0x00000004453a7824ULL, 0x002fe200078e00ffULL,
0x000000404100720cULL, 0x080fe20003f06070ULL, 0x000000106d367825ULL, 0x000fe200078e0036ULL,
0x000000404200720cULL, 0x000fc40003f26070ULL, 0x000000404300720cULL, 0x080fe20003f46070ULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x000000404400720cULL, 0x0c0fe20003f66070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x000000404500720cULL, 0x080fe20003f86070ULL,
0x000000106d3e7825ULL, 0x000fe200078e003eULL, 0x000000404700720cULL, 0x080fe40003fa6070ULL,
0x000000404b00720cULL, 0x000fe20003fc6070ULL, 0x0000000441407824ULL, 0x000fe200078e00ffULL,
0xfffffffc42417812ULL, 0x000fe200078ee20bULL, 0x000000106d3c7825ULL, 0x000fe200078e003cULL,
0xfffffffc46437812ULL, 0x000fc400078ee20bULL, 0xfffffffc403b7812ULL, 0x100fe200078ee20bULL,
0x0000001041417824ULL, 0x100fe200078e026eULL, 0xfffffffc44457812ULL, 0x100fe200078ee20bULL,
0x0000001043437824ULL, 0x100fe200078e026eULL, 0xfffffffc3a477812ULL, 0x100fe200078ee20bULL,
0x000000103b3b7824ULL, 0x100fe200078e026eULL, 0xfffffffc48497812ULL, 0x100fe200078ee20bULL,
0x0000001045457824ULL, 0x100fe200078e026eULL, 0xfffffffc4a4b7812ULL, 0x000fe200078ee20bULL,
0x0000001047477824ULL, 0x100fe200078e026eULL, 0x000000002a3b7faeULL, 0x0003e2000c101c46ULL,
0x0000001049497824ULL, 0x000fc400078e026eULL, 0x000000106d387825ULL, 0x000fe200078e0038ULL,
0x0000000028417faeULL, 0x0003e6000c901c46ULL, 0x000000104b4b7824ULL, 0x000fe200078e026eULL,
0x0000000036437faeULL, 0x0003e2000d101c46ULL, 0x000000106d347825ULL, 0x000fc600078e0034ULL,
0x000000003e457faeULL, 0x0003e8000d901c46ULL, 0x000000003c477faeULL, 0x0003e8000e101c46ULL,
0x0000000038497faeULL, 0x0003e8000e901c46ULL, 0x00000000344b7faeULL, 0x0003e2000f101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000304287211ULL, 0x040fe400078ff0ffULL,
0x0000000804347811ULL, 0x000fc400078ff0ffULL, 0x0000006b28297210ULL, 0x080fe40007f1e0ffULL,
0x0000001004387811ULL, 0x040fe400078ff0ffULL, 0x00000018043a7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078048ffULL,
0x0000000103367824ULL, 0x040fe200078e0238ULL, 0x00000020043e7811ULL, 0x040fe200078ff0ffULL,
0x00000001033c7824ULL, 0x000fe200078e023aULL, 0x00005f0029297a11ULL, 0x000fe200000f4c2aULL,
0x00000001032a7824ULL, 0x040fe200078e0234ULL, 0x0000002804427811ULL, 0x000fe200078ff0ffULL,
0x0000000434347824ULL, 0x000fe200078e00ffULL, 0x00000038044a7811ULL, 0x000fe200078ff0ffULL,
0x0000000103407824ULL, 0x040fe200078e023eULL, 0x0000006b2a2b7210ULL, 0x080fe20007f7e0ffULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x0000003004467811ULL, 0x000fe200078ff0ffULL,
0x0000000103447824ULL, 0x040fe200078e0242ULL, 0xfffffffc34357812ULL, 0x100fe200078ee20bULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x0000006b36377210ULL, 0x080fe20007f3e0ffULL,
0x00000001034c7824ULL, 0x000fe200078e024aULL, 0x0000006b3c3c7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078c48ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0xfffffffc38397812ULL, 0x100fe200078ee20bULL,
0x0000000103487824ULL, 0x000fe200078e0246ULL, 0x0000006b40407210ULL, 0x080fe20007f5e0ffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3e3d7812ULL, 0x100fe200078ee20bULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x0000006b44447210ULL, 0x080fe20007f7e0ffULL,
0x0000001035417824ULL, 0x000fe200078e026eULL, 0x00005f002b2b7a11ULL, 0x000fe200030f4c36ULL,
0x000000ffff357224ULL, 0x000fe200000e06ffULL, 0xfffffffc423f7812ULL, 0x100fe200078ee20bULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e003c347a11ULL, 0x000fe200078048ffULL,
0x0000001039437824ULL, 0x100fe200078e026eULL, 0x0000006b48487210ULL, 0x080fe20007fbe0ffULL,
0x000000103d477824ULL, 0x100fe200078e026eULL, 0xfffffffc4a4d7812ULL, 0x100fe200078ee20bULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078248ffULL,
0x000000103f497824ULL, 0x100fe200078e026eULL, 0x0000006b4c4c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e06ffULL, 0xfffffffc3a3b7812ULL, 0x000fe200078ee20bULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x00005f003c357a11ULL, 0x000fe200000f4c35ULL,
0x000000104d4f7824ULL, 0x000fe200078e026eULL, 0x00005f0037377a11ULL, 0x000fe200008f4c38ULL,
0x000000ffff3f7224ULL, 0x000fe200028e06ffULL, 0x0000001c6d6d7812ULL, 0x000fe200078efcffULL,
0x000000ffff4d7224ULL, 0x000fe200020e06ffULL, 0x00005e00403a7a11ULL, 0x000fe200078048ffULL,
0x000000103b457824ULL, 0x000fe200078e026eULL, 0x00005e00443c7a11ULL, 0x000fe200078248ffULL,
0x000000106d287825ULL, 0x000fe200078e0028ULL, 0x00005e00483e7a11ULL, 0x000fc400078448ffULL,
0x00005e004c387a11ULL, 0x000fe200078648ffULL, 0x000000106d2a7825ULL, 0x040fe200078e002aULL,
0x00005f00403b7a11ULL, 0x000fe200000f4c39ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000286f7faeULL, 0x0003e2000b901c46ULL, 0x00005f00443d7a11ULL, 0x000fe200008f4c3dULL,
0x000000106d367825ULL, 0x040fe200078e0036ULL, 0xfffffffc464b7812ULL, 0x000fe200078ee20bULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x00005f00483f7a11ULL, 0x000fe200010f4c3fULL,
0x000000106d347825ULL, 0x040fe200078e0034ULL, 0x00005f004c397a11ULL, 0x000fe200018f4c4dULL,
0x0000000036437faeULL, 0x0003e4000b901c46ULL, 0x000000106d3a7825ULL, 0x000fc400078e003aULL,
0x0000000034457faeULL, 0x0003e4000b901c46ULL, 0x000000106d3c7825ULL, 0x000fe400078e003cULL,
0x000000003a477faeULL, 0x0003e4000b901c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e026eULL,
0x000000106d3e7825ULL, 0x040fe200078e003eULL, 0x000000003c497faeULL, 0x0003e6000b901c46ULL,
0x000000106d387825ULL, 0x000fe200078e0038ULL, 0x000000003e4b7faeULL, 0x0003e8000b901c46ULL,
0x00000000384f7faeULL, 0x0003e4000b901c46ULL, 0x00000004ff357424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff6b7424ULL, 0x000fc400078e00ffULL,
0x0000030035007a24ULL, 0x000fca00078e0200ULL, 0x000000610000720cULL, 0x000fda0003f06070ULL,
0x0000000205348824ULL, 0x000fe200078e0200ULL, 0x000000180a287810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600034348625ULL, 0x000fe200078e0035ULL,
0x0000000728287812ULL, 0x000fe200078e780dULL, 0x000000006a5c783bULL, 0x000fe80000000200ULL,
0x00000006346b8981ULL, 0x0002a2000c1e1900ULL, 0x000000200d287824ULL, 0x000fc600078e0228ULL,
0x000000006950783bULL, 0x000fe20000000200ULL, 0x0000001028487824ULL, 0x000fc600078e00ffULL,
0x000000006c28783bULL, 0x000fe20000000200ULL, 0x0000001a0a347810ULL, 0x002fc60007ffe0ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x0000000734347812ULL, 0x000fc600078e780dULL,
0x00000000684c783bULL, 0x000ee40000000200ULL, 0x000000200d347824ULL, 0x000fe400078e0234ULL,
0x000000006744783bULL, 0x000fe40000000200ULL, 0x0000001034347824ULL, 0x000fe400078e00ffULL,
0x000000006640783bULL, 0x000fe80000000200ULL, 0x00000000653c783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000f280000000200ULL, 0x000000006338783bULL, 0x000f620000000200ULL,
0x00000028482c723cULL, 0x042ff0000004182cULL, 0x0000002a4858723cULL, 0x040ff00000041858ULL,
0x0000005c4854723cULL, 0x040ff00000041854ULL, 0x0000005e4818723cULL, 0x040ff00000041818ULL,
0x00000050481c723cULL, 0x040ff0000004181cULL, 0x000000524820723cULL, 0x040ff00000041820ULL,
0x0000004c4824723cULL, 0x048ff00000041824ULL, 0x0000004e4830723cULL, 0x000fee0000041830ULL,
0x0000030064487a10ULL, 0x000fe20007ffe0ffULL, 0x00000044342c723cULL, 0x010fe6000004182cULL,
0x0000000148287810ULL, 0x000fc80007ffe0ffULL, 0x000000172800720cULL, 0x000fe20003f06070ULL,
0x000000463458723cULL, 0x040ff00000041858ULL, 0x000000403454723cULL, 0x040ff00000041854ULL,
0x000000423418723cULL, 0x040ff00000041818ULL, 0x0000003c341c723cULL, 0x040ff0000004181cULL,
0x0000003e3420723cULL, 0x040ff00000041820ULL, 0x000000383424723cULL, 0x060ff00000041824ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x000000046b3c7c24ULL, 0x004fe2000f8e02ffULL,
0x000006e000008947ULL, 0x000fec0003800000ULL, 0x0000010048297824ULL, 0x000fe200078e0202ULL,
0x00000002ff3d7819ULL, 0x000fe20000011604ULL, 0x00000010043e7824ULL, 0x000fc600078e00ffULL,
0x0000002960287217ULL, 0x000fe20007800000ULL, 0x00000001033b7824ULL, 0x000fe200078e023dULL,
0x000000103d407810ULL, 0x040fe40007ffe0ffULL, 0x000000183d417810ULL, 0x040fe20007ffe0ffULL,
0x0000000128367824ULL, 0x000fe200078e0a29ULL, 0x000000083d3f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103357824ULL, 0x000fe200078e0240ULL, 0x0000003c3b3b7210ULL, 0x080fe20007f1e0ffULL,
0x0000000103297824ULL, 0x040fe200078e0241ULL, 0x000000303e3e7812ULL, 0x000fe200078ec0ffULL,
0x00000001032b7824ULL, 0x000fe200078e023fULL, 0x0000003c35357210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x00005e003b397a11ULL, 0x000fc400078048ffULL,
0x0000003c293a7210ULL, 0x080fe40007f7e0ffULL, 0x0000003c2b2b7210ULL, 0x000fe40007f3e0ffULL,
0x00005f003b3b7a11ULL, 0x000fe200000f4c28ULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e003a377a11ULL, 0x000fe200078448ffULL, 0x000000ffff297224ULL, 0x000fe200018e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078048ffULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x00005e0035347a11ULL, 0x000fc400078248ffULL, 0x00005f003a3a7a11ULL, 0x000fe400010f4c29ULL,
0x00005f002b2b7a11ULL, 0x000fe200000f4c38ULL, 0x000000043f387824ULL, 0x000fe200078e00ffULL,
0x000000364000720cULL, 0x0c0fe20003f46070ULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x000000363d00720cULL, 0x080fe40003f06070ULL, 0x00005f0035357a11ULL, 0x000fe400008f4c28ULL,
0x000000363f00720cULL, 0x000fc40003f26070ULL, 0x0000003e39287210ULL, 0x080fe40007f7e0ffULL,
0xfffffffc38397812ULL, 0x100fe400078ee20bULL, 0xfffffffc403f7812ULL, 0x000fe200078ee20bULL,
0x000000ffff297224ULL, 0x000fe200018e063bULL, 0x000000203d407810ULL, 0x000fe20007ffe0ffULL,
0x00000010393b7824ULL, 0x100fe200078e020cULL, 0x0000003e2a2a7210ULL, 0x080fe20007f7e0ffULL,
0x000000103f3f7824ULL, 0x000fe200078e020cULL, 0x000000283d427810ULL, 0x000fe20007ffe0ffULL,
0x0000000103397824ULL, 0x000fe200078e0240ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000280e7faeULL, 0x0003e2000c101c46ULL, 0x000000303d437810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e062bULL, 0x000000383d447810ULL, 0x000fe20007ffe0ffULL,
0x00000001033d7824ULL, 0x000fe200078e0242ULL, 0x0000003e34347210ULL, 0x000fc40007f9e0ffULL,
0x0000003c39397210ULL, 0x080fe20007f1e0ffULL, 0x000000002a3b7faeULL, 0x0005e2000c901c46ULL,
0x0000003c3d387210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff357224ULL, 0x000fe200020e0635ULL,
0x000000364100720cULL, 0x080fe20003f86070ULL, 0x000000ffff0e7224ULL, 0x002fe200000e06ffULL,
0x000000364000720cULL, 0x000fe20003f66070ULL, 0x000000ffff297224ULL, 0x000fe200028e06ffULL,
0x00000000343f7faeULL, 0x0003e2000d101c46ULL, 0x0000003e37287210ULL, 0x000fe20007fbe0ffULL,
0x0000000103377824ULL, 0x000fe200078e0243ULL, 0x000000364200720cULL, 0x080fe20003f46070ULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x00005e00392b7a11ULL, 0x004fe200078c48ffULL,
0x00000004412a7824ULL, 0x000fe200078e00ffULL, 0x000000364300720cULL, 0x000fe20003f26070ULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x00005f0039397a11ULL, 0x000fc400030f4c0eULL,
0x000000364400720cULL, 0x000fe20003f06070ULL, 0x0000000103357824ULL, 0x002fe200078e0244ULL,
0x00005e0038347a11ULL, 0x000fe200078c48ffULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0xfffffffc403d7812ULL, 0x000fe400078ee20bULL, 0x00005f0038387a11ULL, 0x000fe200030f4c29ULL,
0x000000ffff297224ULL, 0x000fe200028e063aULL, 0x0000003c37377210ULL, 0x080fe20007fde0ffULL,
0x00000004433a7824ULL, 0x000fe200078e00ffULL, 0x0000003c350e7210ULL, 0x000fe20007fbe0ffULL,
0x000000103d3d7824ULL, 0x000fe200078e020cULL, 0xfffffffc2a357812ULL, 0x000fe200078ee20bULL,
0x000000ffff2a7224ULL, 0x000fe200030e06ffULL, 0x00005e0037367a11ULL, 0x000fc400078c48ffULL,
0xfffffffc423f7812ULL, 0x100fe200078ee20bULL, 0x00000010353b7824ULL, 0x000fe200078e020cULL,
0xfffffffc3a357812ULL, 0x100fe400078ee20bULL, 0x00005f0037377a11ULL, 0x000fe200030f4c2aULL,
0x000000103f3f7824ULL, 0x100fe200078e020cULL, 0x0000003e2b2a7210ULL, 0x080fe20007fde0ffULL,
0x0000001035417824ULL, 0x100fe200078e020cULL, 0xfffffffc44437812ULL, 0x000fe200078ee20bULL,
0x00000000283b7faeULL, 0x0003e2000e101c46ULL, 0x000000ffff357224ULL, 0x000fe200028e06ffULL,
0x00005e000e0b7a11ULL, 0x000fe200078848ffULL, 0x000000ffff2b7224ULL, 0x000fe200030e0639ULL,
0x0000003e34347210ULL, 0x080fe20007fde0ffULL, 0x0000001043437824ULL, 0x000fe200078e020cULL,
0x0000003e36367210ULL, 0x000fc40007fbe0ffULL, 0x00005f000e0c7a11ULL, 0x000fe200020f4c35ULL,
0x000000ffff357224ULL, 0x000fe200030e0638ULL, 0x000000002a3d7faeULL, 0x0005e2000d901c46ULL,
0x000000ffff377224ULL, 0x000fe200028e0637ULL, 0x0000003e0b287210ULL, 0x002fe40007f9e0ffULL,
0x00000000343f7faeULL, 0x0005e6000d101c46ULL, 0x000000ffff297224ULL, 0x000fe200020e060cULL,
0x0000000036417faeULL, 0x0005e8000c901c46ULL, 0x0000000028437faeULL, 0x0005e2000c101c46ULL,
0x0000061000007947ULL, 0x000fea0003800000ULL, 0x0000000304297211ULL, 0x040fe400078ff0ffULL,
0x0000000804287811ULL, 0x000fc400078ff0ffULL, 0x0000003c29427210ULL, 0x080fe40007f1e0ffULL,
0x00000038043e7811ULL, 0x040fe400078ff0ffULL, 0x00000010042a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff297224ULL, 0x000fe200000e06ffULL, 0x00005e0042417a11ULL, 0x000fe200078048ffULL,
0x00000001032b7824ULL, 0x040fe200078e023eULL, 0x0000001804347811ULL, 0x000fe200078ff0ffULL,
0x00000001033f7824ULL, 0x040fe200078e022aULL, 0x00005f0042427a11ULL, 0x000fe200000f4c29ULL,
0x0000000103297824ULL, 0x040fe200078e0228ULL, 0x0000002004367811ULL, 0x000fe200078ff0ffULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x0000002804387811ULL, 0x040fe200078ff0ffULL,
0x0000000103377824ULL, 0x040fe200078e0234ULL, 0x00000030043a7811ULL, 0x000fe200078ff0ffULL,
0x0000000103397824ULL, 0x000fe200078e0236ULL, 0x0000003c29407210ULL, 0x080fe20007fde0ffULL,
0x00000001033b7824ULL, 0x000fe200078e0238ULL, 0x0000003c2b297210ULL, 0x080fe20007f9e0ffULL,
0x00000001033d7824ULL, 0x000fe200078e023aULL, 0xfffffffc282b7812ULL, 0x100fe200078ee20bULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0x0000003c3f3f7210ULL, 0x080fe20007fbe0ffULL,
0x0000000434347824ULL, 0x000fe200078e00ffULL, 0x0000003c39397210ULL, 0x080fe20007f3e0ffULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0xfffffffc2a357812ULL, 0x100fe200078ee20bULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0xfffffffc34437812ULL, 0x100fe200078ee20bULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc364b7812ULL, 0x100fe200078ee20bULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc384d7812ULL, 0x100fe200078ee20bULL,
0x000000102b457824ULL, 0x100fe200078e020cULL, 0xfffffffc3a4f7812ULL, 0x100fe200078ee20bULL,
0x0000001035477824ULL, 0x100fe200078e020cULL, 0xfffffffc3e517812ULL, 0x000fe200078ee20bULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0x00005e00402b7a11ULL, 0x040fe200078c48ffULL,
0x0000001043497824ULL, 0x100fe200078e020cULL, 0x0000003c37377210ULL, 0x080fe20007f1e0ffULL,
0x000000104b4b7824ULL, 0x100fe200078e020cULL, 0x00005f0040407a11ULL, 0x000fe200030f4c0bULL,
0x00000010040b7824ULL, 0x000fe200078e00ffULL, 0x0000003c3d3d7210ULL, 0x080fe20007f7e0ffULL,
0x000000104d4d7824ULL, 0x100fe200078e020cULL, 0x0000003c3b3b7210ULL, 0x000fe20007f5e0ffULL,
0x000000104f4f7824ULL, 0x100fe200078e020cULL, 0x000000300b437812ULL, 0x000fe200078ec0ffULL,
0x0000001051517824ULL, 0x000fc400078e020cULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x00005e003f357a11ULL, 0x000fe200078a48ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0039387a11ULL, 0x000fe200078248ffULL, 0x000000ffff287224ULL, 0x000fe200000e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078048ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005f003f3f7a11ULL, 0x000fe200028f4c2aULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005f0039397a11ULL, 0x000fe200008f4c0cULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x00005f0037377a11ULL, 0x000fc400000f4c28ULL, 0x00005e00293e7a11ULL, 0x000fe400078648ffULL,
0x0000004341287210ULL, 0x000fe40007f1e0ffULL, 0x00005e003d3c7a11ULL, 0x000fe400078448ffULL,
0x00005e003b3a7a11ULL, 0x000fe400078248ffULL, 0x00005f00290b7a11ULL, 0x000fe200018f4c0cULL,
0x000000ffff297224ULL, 0x000fe200000e0642ULL, 0x00005f003d3d7a11ULL, 0x000fc400010f4c2aULL,
0x00005f003b3b7a11ULL, 0x000fe400008f4c34ULL, 0x000000432b2a7210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000280e7faeULL, 0x0003e2000b901c46ULL,
0x0000004335347210ULL, 0x080fe40007f3e0ffULL, 0x0000004336367210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e0640ULL, 0x0000004338387210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff357224ULL, 0x000fe200008e063fULL, 0x000000433a3a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff377224ULL, 0x000fe200010e0637ULL, 0x000000433c3c7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200018e0639ULL, 0x000000433e3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e063bULL, 0x000000002a457faeULL, 0x0003e2000b901c46ULL,
0x000000ffff3d7224ULL, 0x000fc400028e063dULL, 0x000000ffff3f7224ULL, 0x000fe200000e060bULL,
0x0000000034477faeULL, 0x0003e8000b901c46ULL, 0x0000000036497faeULL, 0x0003e8000b901c46ULL,
0x00000000384b7faeULL, 0x0003e8000b901c46ULL, 0x000000003a4d7faeULL, 0x0003e8000b901c46ULL,
0x000000003c4f7faeULL, 0x0003e8000b901c46ULL, 0x000000003e517faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001c0a0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000001e0a0a7810ULL, 0x000fe40007ffe0ffULL, 0x000000070c0c7812ULL, 0x100fe400078e780dULL,
0x000000070a0a7812ULL, 0x000fc600078e780dULL, 0x000000200d0c7824ULL, 0x040fe400078e020cULL,
0x000000200d0a7824ULL, 0x000fe400078e020aULL, 0x000000100c0c7824ULL, 0x000fe400078e00ffULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000c28783bULL, 0x006fe80000000200ULL, 0x000000001038783bULL, 0x000e680000000200ULL,
0x000000000f34783bULL, 0x000ea80000000200ULL, 0x00000000113c783bULL, 0x000ee80000000200ULL,
0x000000001240783bULL, 0x000f280000000200ULL, 0x000000000a44783bULL, 0x000fe80000000200ULL,
0x000000001450783bULL, 0x000f680000000200ULL, 0x00000000135c783bULL, 0x000ee80000000200ULL,
0x00000000154c783bULL, 0x000ee80000000200ULL, 0x00000000160c783bULL, 0x000ee20000000200ULL,
0x000000382854723cULL, 0x042ff00000041854ULL, 0x00000034282c723cULL, 0x044ff0000004182cULL,
0x000000362858723cULL, 0x040ff00000041858ULL, 0x0000003a2818723cULL, 0x040ff00000041818ULL,
0x0000003c2834723cULL, 0x048ff0000004181cULL, 0x000000402824723cULL, 0x050ff00000041824ULL,
0x0000003e2820723cULL, 0x040ff00000041820ULL, 0x000000422830723cULL, 0x000ff00000041830ULL,
0x00000050441c723cULL, 0x060ff00000041854ULL, 0x000000524450723cULL, 0x040ff00000041818ULL,
0x0000005c442c723cULL, 0x040ff0000004182cULL, 0x0000004c4410723cULL, 0x040ff00000041834ULL,
0x0000000c4418723cULL, 0x040ff00000041824ULL, 0x0000005e445c723cULL, 0x040ff00000041858ULL,
0x0000004e444c723cULL, 0x040ff00000041820ULL, 0x0000000e440c723cULL, 0x000fe20000041830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000000006147f8cULL, 0x000fe2000c80043fULL,
0x3d8000002e0a7820ULL, 0x000fe20000410000ULL, 0x3d8000002f0b7820ULL, 0x000fe20000410000ULL,
0x3d8000001c2e7820ULL, 0x000fe20000410000ULL, 0x0000040006357984ULL, 0x000e620000000800ULL,
0x3d8000002d317820ULL, 0x000fe20000410000ULL, 0x3d80000011297820ULL, 0x000fe20000410000ULL,
0x3d800000131c7820ULL, 0x000fe20000410000ULL, 0x3d80000018267820ULL, 0x000fe20000410000ULL,
0x3d8000002c337820ULL, 0x000fe20000410000ULL, 0x3d8000001d2d7820ULL, 0x000fe20000410000ULL,
0x3d8000001e237820ULL, 0x000fe20000410000ULL, 0x3d8000001f247820ULL, 0x000fe20000410000ULL,
0x3d800000102a7820ULL, 0x000fe20000410000ULL, 0x3d80000012207820ULL, 0x000fe20000410000ULL,
0x3d80000019187820ULL, 0x000fe20000410000ULL, 0x3d8000001a117820ULL, 0x000fe20000410000ULL,
0x3d8000001b137820ULL, 0x000fe20000410000ULL, 0x3d8000005c307820ULL, 0x000fe20000410000ULL,
0x3d8000005d2f7820ULL, 0x000fe20000410000ULL, 0x3d8000005e217820ULL, 0x000fe20000410000ULL,
0x3d8000005f227820ULL, 0x000fe20000410000ULL, 0x3d800000502c7820ULL, 0x000fe20000410000ULL,
0x3d800000512b7820ULL, 0x000fe20000410000ULL, 0x3d80000052257820ULL, 0x000fe20000410000ULL,
0x3d800000531f7820ULL, 0x000fe20000410000ULL, 0x3d8000004c287820ULL, 0x000fe20000410000ULL,
0x3d8000004d277820ULL, 0x000fe20000410000ULL, 0x3d8000004e1d7820ULL, 0x000fe20000410000ULL,
0x3d8000004f167820ULL, 0x000fe20000410000ULL, 0x3d8000000c197820ULL, 0x000fe20000410000ULL,
0x3d8000000d1a7820ULL, 0x000fe20000410000ULL, 0x3d8000000e127820ULL, 0x000fe20000410000ULL,
0x3d8000000f107820ULL, 0x000fe20000410000ULL, 0x000000ffff1e7224ULL, 0x000fc400078e000aULL,
0x000000ffff1b7224ULL, 0x000fe200078e000bULL, 0x8000000035ff7812ULL, 0x002fe20007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL,
0x0000000a000b7305ULL, 0x0002a4000021f000ULL, 0x3fa000000a0a7823ULL, 0x002fe200000100ffULL,
0x0000000b0000735dULL, 0x004fe40003800000ULL, 0x00000400060b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004040a7824ULL, 0x000fe200078e00ffULL, 0x000000076400720cULL, 0x000fc80003f05270ULL,
0xfffffff00a0b7812ULL, 0x000fca00078ec0ffULL, 0x00000080620b7824ULL, 0x000fca00078e020bULL,
0x014400000b0c7984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000204147824ULL, 0x000fe400078e00ffULL, 0x0000000160347824ULL, 0x000fc600078e0a09ULL,
0x0000000614147812ULL, 0x000fc800078ec0ffULL, 0x0000000114097812ULL, 0x040fe400078efcffULL,
0x0000000814157812ULL, 0x040fe400078efcffULL, 0x000000340900720cULL, 0x080fe40003f26070ULL,
0x0000001014097812ULL, 0x000fe400078efcffULL, 0x000000341500720cULL, 0x080fe40003f06070ULL,
0x000000340900720cULL, 0x000fc40003fc6070ULL, 0x0000001114157812ULL, 0x040fe400078efcffULL,
0x0000001814097812ULL, 0x040fe400078efcffULL, 0x000000341400720cULL, 0x0c0fe40003f46070ULL,
0x000000341500720cULL, 0x080fe40003fa6070ULL, 0x000000340900720cULL, 0x000fe40003f66070ULL,
0x0000000914327812ULL, 0x000fc400078efcffULL, 0x0000001914157812ULL, 0x040fe400078efcffULL,
0x0000002014097812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff33337808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff31317808ULL, 0x000fc40004800000ULL, 0x000000343200720cULL, 0x080fe40003f86070ULL,
0x000000341500720cULL, 0x080fe40003f46070ULL, 0x000000340900720cULL, 0x000fe40003f26070ULL,
0x0000002114157812ULL, 0x040fe400078efcffULL, 0x0000002814097812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fc40004000000ULL, 0xff7fffff30307808ULL, 0x000fe40004000000ULL,
0xff7fffff22227808ULL, 0x000fe40006000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40006000000ULL,
0x000000341500720cULL, 0x080fe40003f06070ULL, 0x000000340900720cULL, 0x000fe40003f86070ULL,
0x0000002914157812ULL, 0x000fc400078efcffULL, 0x0000003014097812ULL, 0x000fe400078efcffULL,
0xff7fffff23237808ULL, 0x000fe40007000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40007000000ULL,
0xff7fffff24247808ULL, 0x000fe40006800000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40006800000ULL,
0x000000341500720cULL, 0x000fc40003fc6070ULL, 0x000000340900720cULL, 0x000fe40003fa6070ULL,
0x0000003114157812ULL, 0x040fe400078efcffULL, 0x0000003814097812ULL, 0x040fe400078efcffULL,
0x0000003914147812ULL, 0x000fe400078efcffULL, 0xff7fffff25257808ULL, 0x000fe40005800000ULL,
0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL, 0xff7fffff20207808ULL, 0x000fe40004800000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0x000000341500720cULL, 0x080fe40003f66070ULL,
0x000000340900720cULL, 0x000fc40003f46070ULL, 0x000000341400720cULL, 0x000fe40003f26070ULL,
0xff7fffff1c1c7808ULL, 0x000fe40004000000ULL, 0xff7fffff29297808ULL, 0x000fe40004000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006000000ULL, 0xff7fffff28287808ULL, 0x000fe40006000000ULL,
0xff7fffff16167808ULL, 0x000fc40007000000ULL, 0xff7fffff27277808ULL, 0x000fe40007000000ULL,
0xff7fffff11117808ULL, 0x000fe40006800000ULL, 0xff7fffff26267808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40005800000ULL, 0xff7fffff18187808ULL, 0x000fe40005800000ULL,
0xff7fffff12127808ULL, 0x000fc40005000000ULL, 0xff7fffff19197808ULL, 0x000fe40005000000ULL,
0xff7fffff10107808ULL, 0x000fe40004800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40004800000ULL,
0x000000330c0c7209ULL, 0x004fe20007810000ULL, 0x0000001fff347424ULL, 0x000fe200078e00ffULL,
0x0000001e0d147209ULL, 0x000fe20007810000ULL, 0xffffffffff3b7424ULL, 0x000fe200078e00ffULL,
0x000000310c097209ULL, 0x000fe40007810000ULL, 0x0000001b14147209ULL, 0x000fc40007810000ULL,
0x00000030090c7209ULL, 0x000fe40007810000ULL, 0x0000002114097209ULL, 0x000fe40007810000ULL,
0x0000002f0c0d7209ULL, 0x000fe40007810000ULL, 0x00000022090c7209ULL, 0x000fe40007810000ULL,
0x0000002e0d147209ULL, 0x000fe40007810000ULL, 0x000000230c097209ULL, 0x000fc40007810000ULL,
0x0000002d140d7209ULL, 0x000fe40007810000ULL, 0x00000024090c7209ULL, 0x000fe40007810000ULL,
0x0000002c0d147209ULL, 0x000fe40007810000ULL, 0x000000250c0c7209ULL, 0x000fe40007810000ULL,
0x0000002b14097209ULL, 0x000fe40007810000ULL, 0x0000001f0c0d7209ULL, 0x000fc40007810000ULL,
0x0000002a090c7209ULL, 0x000fe40007810000ULL, 0x000000200d0d7209ULL, 0x000fe40007810000ULL,
0x000000290c097209ULL, 0x000fe40007810000ULL, 0x0000001c0d0c7209ULL, 0x000fe40007810000ULL,
0x0000002809147209ULL, 0x000fe40007810000ULL, 0x0000001d0c097209ULL, 0x000fc40007810000ULL,
0x00000027140d7209ULL, 0x000fe40007810000ULL, 0x00000016090c7209ULL, 0x000fe40007810000ULL,
0x000000260d0d7209ULL, 0x000fe40007810000ULL, 0x000000110c0c7209ULL, 0x000fe40007810000ULL,
0x000000180d147209ULL, 0x000fe40007810000ULL, 0x000000130c097209ULL, 0x000fc40007810000ULL,
0x00000019140d7209ULL, 0x000fe40007810000ULL, 0x0000001209097209ULL, 0x000fe40007810000ULL,
0x0000001a0d0c7209ULL, 0x000fe40007810000ULL, 0x0000001009367209ULL, 0x000fe20007810000ULL,
0x000017f27f007947ULL, 0x000fea000b800000ULL, 0x0c401f000c097f89ULL, 0x0004e400000e0000ULL,
0x000000090c377209ULL, 0x008fe20007810000ULL, 0x000018227f007947ULL, 0x000fea000b800000ULL,
0x0c401f0036097f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f0c7f89ULL, 0x004ea200000e0000ULL, 0x0000000936147209ULL, 0x008fc40007810000ULL,
0x0000000d0e157209ULL, 0x010fc60007810000ULL, 0x0c201f0014357f89ULL, 0x002fe200000e0000ULL,
0x0000000c0f097209ULL, 0x004fc60007810000ULL, 0x0c201f00370d7f89ULL, 0x000e6800000e0000ULL,
0x0c201f0015347f89ULL, 0x000ea800000e0000ULL, 0x0c201f0009327f89ULL, 0x00072200000e0000ULL,
0x0000000d370c7209ULL, 0x002fe40007810000ULL, 0x00000035140d7209ULL, 0x000fc40007810000ULL,
0x00000034150e7209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b0c0f7820ULL, 0x008fe20000410000ULL,
0x3fb8aa3b0d377820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b31317823ULL, 0x000fe2000001080fULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe20000010837ULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001080fULL, 0x0000003100147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b22227823ULL, 0x000fe20000010837ULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001080fULL,
0x00000005ff157e24ULL, 0x000fe2000f8e00ffULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080fULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001080fULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b1a0f7823ULL, 0x000fe2000001080fULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010837ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b10107823ULL, 0x000fe20000010837ULL, 0x0000000000087886ULL, 0x000fc400038e0100ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000ef00000000800ULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000f620000000800ULL,
0x000000302f1a723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b202f7823ULL, 0x000fcc0000010837ULL,
0x0000001800357308ULL, 0x0023f00000000800ULL, 0x0000001900367308ULL, 0x0007e20000000800ULL,
0x000000331418723eULL, 0x002fe400000010ffULL, 0x3f8000001514783eULL, 0x000fca00000010ffULL,
0x000000ffff157224ULL, 0x000fe200078e0014ULL, 0x0000001e1b19723eULL, 0x008fe200000010ffULL,
0x0000002600347308ULL, 0x000fe20000000800ULL, 0x00000021221b723eULL, 0x020fce00000010ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000e700000000800ULL,
0x0000002700317308ULL, 0x000ff00000000800ULL, 0x0000002300267308ULL, 0x0007f00000000800ULL,
0x0000002400277308ULL, 0x000f620000000800ULL, 0x000000141820723cULL, 0x008fee00000418ffULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c157823ULL, 0x100fe20000010837ULL,
0x0000002e2d1c723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1d2d7823ULL, 0x000fca0000010837ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x00000026271d723eULL, 0x020fce00000010ffULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x0000001f00247308ULL, 0x000ee20000000800ULL,
0x0000002c2b1e723eULL, 0x002fce00000010ffULL, 0x0000001500307308ULL, 0x0003e20000000800ULL,
0x00000025241f723eULL, 0x008fe200000010ffULL, 0x000000ffff157224ULL, 0x002fcc00078e0014ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000141c24723cULL, 0x000fee0000041820ULL,
0x0000002900297308ULL, 0x000e700000000800ULL, 0x0000002800287308ULL, 0x000ef00000000800ULL,
0x0000002f002f7308ULL, 0x000f620000000800ULL, 0x0000002a2920723eULL, 0x002fe200000010ffULL,
0x000000ffff297224ULL, 0x000fcc00078e0014ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x000000283122723eULL, 0x008fe200000010ffULL, 0x000000ffff287224ULL, 0x000fcc00078e0014ULL,
0x0000001600167308ULL, 0x000e620000000800ULL, 0x0000002f3021723eULL, 0x020fce00000010ffULL,
0x00000013002c7308ULL, 0x0007e20000000800ULL, 0x0000002d1623723eULL, 0x002fe200000010ffULL,
0x0000000fff167424ULL, 0x000fe200078e00ffULL, 0xfffffffc04137812ULL, 0x008fca00078ec0ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000001316137219ULL, 0x000fe200000006ffULL,
0x000000282028723cULL, 0x000fe60000041824ULL, 0x00000000131673a1ULL, 0x000e6600000e8000ULL,
0x0000001000157308ULL, 0x000ee20000000800ULL, 0x00000000130573c4ULL, 0x000f620000004000ULL,
0x000000343524723eULL, 0x000fcc00000010ffULL, 0x0000000f000f7308ULL, 0x000f300000000800ULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x000000121527723eULL, 0x008fe200000010ffULL,
0x000000ffff157224ULL, 0x000fe200078e0014ULL, 0x0000000813ff7c12ULL, 0x002fc4000f804016ULL,
0x000000360f26723eULL, 0x010fe400000010ffULL, 0x00000009320f7209ULL, 0x004fe40007810000ULL,
0x000000112c25723eULL, 0x000fce00000010ffULL, 0x000000142434723cULL, 0x000fe20000041828ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000012f205008947ULL, 0x020fde000b800000ULL,
0x001c1fff34287589ULL, 0x0002a400000e0000ULL, 0x00000000131073a1ULL, 0x000ee200000e8000ULL,
0x00000000130573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x0000000813ff7c12ULL, 0x008fda000f804010ULL, 0x0000131205008947ULL, 0x010fea000b800000ULL,
0x001c1fff36297589ULL, 0x00072800000e0000ULL, 0x001c1fff2a2a7589ULL, 0x00066800000e0000ULL,
0x001c1fff002b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff097819ULL, 0x000fe40000011604ULL,
0x0000000c0a3b7812ULL, 0x000fc400078ec0ffULL, 0x0000000709107812ULL, 0x040fe200078ec0ffULL,
0x0000000809157824ULL, 0x040fe200078e00ffULL, 0x00000009ff137212ULL, 0x00afe200078e33ffULL,
0x0000000809117824ULL, 0x040fe200078e00ffULL, 0x0000000304ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000809347824ULL, 0x040fe200078e00ffULL, 0x0000000809097810ULL, 0x000fe40007ffe0ffULL,
0xfffffff815127812ULL, 0x100fe400078ee210ULL, 0x0000000111147812ULL, 0x100fe200078ef610ULL,
0x0000000809447824ULL, 0x000fe200078e00ffULL, 0x0000000211167812ULL, 0x100fe200078ef610ULL,
0x0000000809157824ULL, 0x000fe200078e00ffULL, 0x00000003112c7812ULL, 0x000fc400078ef610ULL,
0x00000004112e7812ULL, 0x140fe400078ef610ULL, 0x0000000511307812ULL, 0x140fe400078ef610ULL,
0x0000000611327812ULL, 0x000fe200078ef610ULL, 0x0000000809117824ULL, 0x040fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe400078ee213ULL, 0x00000009ff137212ULL, 0x000fe400078e33ffULL,
0x0000000709107812ULL, 0x000fc400078ec0ffULL, 0x0000a00062097811ULL, 0x000fe400078e58ffULL,
0xfffffff815367812ULL, 0x100fe400078ee210ULL, 0x0000000111387812ULL, 0x140fe200078ef610ULL,
0x00000010120a7824ULL, 0x000fe200078e0209ULL, 0xfffffff844447812ULL, 0x000fe200078ee213ULL,
0x0000001016127824ULL, 0x100fe200078e0209ULL, 0x00000002113a7812ULL, 0x140fe200078ef610ULL,
0x000000102e167824ULL, 0x100fe200078e0209ULL, 0x00000003113c7812ULL, 0x140fe200078ef610ULL,
0x00000010322e7824ULL, 0x100fe200078e0209ULL, 0x00000004113e7812ULL, 0x140fe200078ef610ULL,
0x0000001038327824ULL, 0x100fe200078e0209ULL, 0x0000000511407812ULL, 0x140fe200078ef610ULL,
0x000000103c357824ULL, 0x100fe200078e0209ULL, 0x0000000611427812ULL, 0x000fe200078ef610ULL,
0x0000001014107824ULL, 0x000fc400078e0209ULL, 0x000000102c147824ULL, 0x100fe400078e0209ULL,
0x00000010302c7824ULL, 0x100fe400078e0209ULL, 0x000000013b117824ULL, 0x000fe400078e020aULL,
0x0000001034307824ULL, 0x100fe400078e0209ULL, 0x00000010360a7824ULL, 0x100fe200078e0209ULL,
0x0000001811007388ULL, 0x0003e20000000800ULL, 0x000000103a347824ULL, 0x000fc400078e0209ULL,
0x000000103e367824ULL, 0x100fe400078e0209ULL, 0x0000001040377824ULL, 0x100fe400078e0209ULL,
0x0000001042387824ULL, 0x100fe400078e0209ULL, 0x0000001044397824ULL, 0x000fe400078e0209ULL,
0x000000013b097824ULL, 0x040fe400078e0210ULL, 0x000000013b137824ULL, 0x000fc400078e0212ULL,
0x000000013b157824ULL, 0x040fe200078e0214ULL, 0x0000001a09007388ULL, 0x0003e20000000800ULL,
0x000000013b2d7824ULL, 0x040fe400078e0216ULL, 0x000000013b2f7824ULL, 0x040fe200078e022cULL,
0x0000001c13007388ULL, 0x0003e20000000800ULL, 0x000000013b317824ULL, 0x040fe400078e022eULL,
0x000000013b337824ULL, 0x040fe200078e0230ULL, 0x0000001e15007388ULL, 0x0003e20000000800ULL,
0x000000013b0a7824ULL, 0x000fc400078e020aULL, 0x000000013b327824ULL, 0x040fe200078e0232ULL,
0x000000202d007388ULL, 0x0003e20000000800ULL, 0x000000013b347824ULL, 0x040fe400078e0234ULL,
0x000000013b107824ULL, 0x040fe200078e0235ULL, 0x000000222f007388ULL, 0x0003e20000000800ULL,
0x000000013b367824ULL, 0x040fe400078e0236ULL, 0x000000013b127824ULL, 0x040fe200078e0237ULL,
0x0000002431007388ULL, 0x0003e20000000800ULL, 0x000000013b387824ULL, 0x000fc400078e0238ULL,
0x000000013b147824ULL, 0x000fe200078e0239ULL, 0x0000002633007388ULL, 0x0003e80000000800ULL,
0x000000190a007388ULL, 0x0003e80000000800ULL, 0x0000001b32007388ULL, 0x0003e80000000800ULL,
0x0000001d34007388ULL, 0x0003e80000000800ULL, 0x0000001f10007388ULL, 0x0003e80000000800ULL,
0x0000002136007388ULL, 0x0003e80000000800ULL, 0x0000002312007388ULL, 0x0003e80000000800ULL,
0x0000002538007388ULL, 0x0003e80000000800ULL, 0x0000002714007388ULL, 0x0003e80000000800ULL,
0x0140000c0b008388ULL, 0x0003e80000000c00ULL, 0x014200280b008388ULL, 0x0143e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146080008ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146100008ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146180008ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000174800720cULL, 0x000fe20003f06070ULL,
0x0146200008ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff647224ULL, 0x000fd600078e0048ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff700000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff117807ULL, 0x008fe40004800000ULL,
0x000193c000107802ULL, 0x000fe40000000f00ULL, 0x00000ef000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e001cULL, 0xfffe933000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40005000000ULL, 0x0001941000107802ULL, 0x000fe40000000f00ULL,
0x00000ea000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e001cULL,
0xfffe936000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0003ULL,
0x0001948000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x00000df000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e002bULL, 0xfffe939000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x000fe200078e0003ULL, 0x000194f000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00000d8000007944ULL, 0x03cfea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e002bULL,
0xfffe935000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0014ULL,
0x0001956000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000d1000007944ULL, 0x024fea0003c00000ULL,
0x0000000814167810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff717224ULL, 0x004fe200078e002bULL,
0x000195d000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x002fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x000000ffff2e7224ULL, 0x000fe400078e0016ULL,
0x00000ca000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6a7224ULL, 0x004fe200078e002bULL,
0xfffe958000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x004fe40004800000ULL,
0x0001962000107802ULL, 0x000fe40000000f00ULL, 0x00000c9000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xfffebc3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40005000000ULL, 0x0001967000107802ULL, 0x000fe40000000f00ULL,
0x00000c4000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xfffebc6000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2f7424ULL, 0x002fe200078e00ffULL,
0x000196d000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x00000ba000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e002bULL,
0xfffebcb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x002fe200078e0016ULL,
0x0001974000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000b3000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e002bULL, 0xfffebd6000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2f7424ULL, 0x000fe200078e00ffULL, 0x000197a000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000ad000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff737224ULL, 0x004fe200078e002bULL, 0x0001980000107802ULL, 0x000fe20000000f00ULL,
0x000000ffff2e7224ULL, 0x002fe400078e0016ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x00000a7000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff747224ULL, 0x004fe200078e002bULL, 0xfffebe9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x004fe40004800000ULL, 0x0001985000107802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xfffee20000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40005000000ULL,
0x000198a000107802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xfffee23000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2f7424ULL, 0x002fe200078e00ffULL, 0x0001990000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000097000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e002bULL, 0xfffee28000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x002fe200078e0016ULL, 0x0001997000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff2f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000090000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e002bULL,
0xfffee33000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2f7424ULL, 0x000fe200078e00ffULL,
0x000199d000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x000008a000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff737224ULL, 0x004fe200078e002bULL,
0x00019a3000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x002fe400078e0016ULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000084000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff747224ULL, 0x004fe200078e002bULL,
0xfffee46000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x004fe40004000000ULL,
0x00019a8000107802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xffff07d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40004800000ULL, 0x00019ad000107802ULL, 0x000fc40000000f00ULL,
0x000007e000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e001cULL,
0xffff080000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2f7424ULL, 0x002fe200078e00ffULL,
0x00019b3000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000074000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e002bULL,
0xffff085000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x002fe200078e0016ULL,
0x00019ba000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff2f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x000006d000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e002bULL, 0xffff090000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2f7424ULL, 0x000fe200078e00ffULL, 0x00019c0000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000067000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff5d7224ULL, 0x004fe200078e002bULL, 0x00019c6000107802ULL, 0x000fe20000000f00ULL,
0x000000ffff2e7224ULL, 0x002fe400078e0016ULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000061000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e002bULL, 0xffff0a3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x000fe200078e000cULL, 0x00019cc000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x0000057000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0032ULL, 0xffffe7c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x000fe200078e0036ULL, 0x00019d2000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x002fc400078e00ffULL, 0x0000051000007944ULL, 0x004fea0003c00000ULL,
0x00000032360d7209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe200078e000eULL,
0x00019d7000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x002fc400078e00ffULL,
0x000004c000007944ULL, 0x000fea0003c00000ULL, 0x000000320e397209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe200078e000fULL, 0x00019dc000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x002fc400078e00ffULL, 0x0000047000007944ULL, 0x000fea0003c00000ULL,
0x000000320f097209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe200078e0037ULL,
0x00019e1000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x002fc400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x00000032370c7209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe200078e000dULL, 0x00019e6000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x002fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000320d0d7209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe200078e0039ULL,
0x00019eb000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x002fc400078e00ffULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x00000032390e7209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe200078e0009ULL, 0x00019f0000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x002fc400078e00ffULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0xffffe68000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2d7224ULL, 0x000fe200078e0034ULL,
0x00019f7000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff2f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff307224ULL, 0x000fe400078e0013ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e002bULL,
0xffffeca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2d7224ULL, 0x002fe200078e0036ULL,
0x00019ff000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff2f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff307224ULL, 0x000fe400078e0013ULL,
0x0000028000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x002fe200078e00ffULL,
0x0001a05000107802ULL, 0x000fe20000000f00ULL, 0x00001c1fff2f7424ULL, 0x000fc400078e00ffULL,
0x000000ffff307224ULL, 0x000fe400078e0013ULL, 0x000000ffff297224ULL, 0x004fe400078e002bULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff307224ULL, 0x002fe200078e0013ULL,
0x0001a0b000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff2f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2a7224ULL, 0x004fe400078e002bULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xffffebf000007947ULL, 0x000fea000383ffffULL,
0x0180000027037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000002700038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff27ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000027047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002700037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff297424ULL, 0x000fc800078e00ffULL,
0xfffe5dd028007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000003b00007348ULL, 0x000fe80003800000ULL, 0x0c00003532327389ULL, 0x0002a200000e0034ULL,
0xfffe5d9014007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000003000007348ULL, 0x000fe80003800000ULL, 0x0000002e2d2b7389ULL, 0x0002a200000e002fULL,
0xfffe5d5010007950ULL, 0x000fea0003c3ffffULL, 0x000000011100780cULL, 0x000fe20003f45070ULL,
0x0000000e00007348ULL, 0x000fd80003800000ULL, 0x0000000000117806ULL, 0x000fc800050e0100ULL,
0x0000000e111c7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffe5cf010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000014700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000002e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000008c0ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000950ULL, 0x0000000000000650ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000fa0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000fc0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000fd0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ff0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001080ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001088ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001098ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x000000000001a400ULL, 0x7c00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b680ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001b690ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b690ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001bb10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001080ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001a600ULL, 0x000000000001a600ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001bb10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_86_cubin_len = 113648;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
