/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001a710ULL, 0x000000000001a290ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000018bf0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000018d60ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000018da0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000018de0ULL,
0x0000000000000120ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000018f00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00018bf000000000ULL, 0x0000040400000000ULL, 0x810c0000013c0400ULL,
0x0061b00400288080ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9308288080890828ULL, 0x2880809808288080ULL, 0x809c082880809908ULL, 0x082880809d082880ULL,
0x8080a108288080a0ULL, 0xa308288080a20828ULL, 0x288080b308288080ULL, 0x80bb08288080ba08ULL,
0x08288080c5082880ULL, 0x8080ca08288080c6ULL, 0xd808288080cc0828ULL, 0x288080f408288080ULL,
0x809408288080fa08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080949200ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00018bf000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c082880808a0828ULL,
0x2880809208288080ULL, 0x8096082880809408ULL, 0x0828808098082880ULL, 0x8080a0082880809cULL,
0xa208288080a10828ULL, 0x288080a308288080ULL, 0x80ba08288080b308ULL, 0x08288080bb082880ULL,
0x8080c608288080c5ULL, 0xd808288080cc0828ULL, 0x288080f408288080ULL, 0x809008288080fa08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080909200ULL, 0x0000001cffffffffULL,
0x0000014800000000ULL, 0x00018d6000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x90082880808c0828ULL, 0x2880809208288080ULL,
0x8096082880809408ULL, 0x0828808098082880ULL, 0x8080a0082880809cULL, 0xa208288080a10828ULL,
0x288080a308288080ULL, 0x80ba08288080b308ULL, 0x08288080bb082880ULL, 0x8080ca08288080c5ULL,
0xd808288080cc0828ULL, 0x288080f408288080ULL, 0x80c608288080fa08ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080c69200ULL, 0x0000001cffffffffULL, 0x0000022000000000ULL,
0x00018da000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000a4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x90082880808c0828ULL, 0x2880809208288080ULL, 0x8096082880809408ULL,
0x0828808098082880ULL, 0x8080a0082880809cULL, 0xa208288080a10828ULL, 0x288080a308288080ULL,
0x80ba08288080b308ULL, 0x08288080bb082880ULL, 0x8080c608288080c5ULL, 0xd808288080cc0828ULL,
0x288080f408288080ULL, 0x80ca08288080fa08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080ca9200ULL, 0x0000002cffffffffULL, 0x000002f800000000ULL, 0x00018de000000000ULL,
0x0000012000000000ULL, 0x0000180400000000ULL, 0x80c6288080ca0900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x00081204000000e8ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000eULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x0001748000017010ULL,
0x0001757000017490ULL, 0x0001759000017580ULL, 0xffffffff01a82904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500000affffffffULL,
0x0500000a0500000aULL, 0xffffffff0500000aULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01a82804ffffffffULL,
0x00000110000000f0ULL, 0x000026f000001670ULL, 0x0000281000002770ULL, 0x00002b4000002840ULL,
0x00002bc000002b50ULL, 0x0000310000002c30ULL, 0x0000401000004000ULL, 0x0000525000004280ULL,
0x00005380000052d0ULL, 0x00005680000054a0ULL, 0x000056f000005690ULL, 0x000059f000005750ULL,
0x000067b0000067a0ULL, 0x00007a5000006a80ULL, 0x00007b8000007ad0ULL, 0x00007e8000007ca0ULL,
0x00007ef000007e90ULL, 0x000081f000007f50ULL, 0x00008fb000008fa0ULL, 0x0000a25000009280ULL,
0x0000a3800000a2d0ULL, 0x0000a6800000a4a0ULL, 0x0000a6f00000a690ULL, 0x0000aa200000a750ULL,
0x0000b7e00000b7d0ULL, 0x0000bd900000bd80ULL, 0x0000e3700000c680ULL, 0x0000e9f00000e4a0ULL,
0x0000f2500000ea20ULL, 0x00016e4000016e10ULL, 0x00016e6000016e50ULL, 0x00016eb000016e90ULL,
0x00016ed000016ec0ULL, 0x000175c000017560ULL, 0x000175e0000175d0ULL, 0x00017d6000017d00ULL,
0x00017e4000017dd0ULL, 0x00017f2000017eb0ULL, 0x00017fe000017f80ULL, 0x000180d000018050ULL,
0x0001819000018130ULL, 0x00018250000181f0ULL, 0x00018340000182c0ULL, 0x00018400000183a0ULL,
0x000184c000018460ULL, 0x000185b000018530ULL, 0x0001867000018610ULL, 0x00018760000186f0ULL,
0x00018840000187d0ULL, 0x00018920000188b0ULL, 0x00018a0000018990ULL, 0x00018b0000018a80ULL,
0x00018bc000018b60ULL, 0x000001f002003904ULL, 0x0001c600000000ffULL, 0x00000230003f0100ULL,
0x0001c60800000009ULL, 0x00000280003f0120ULL, 0x0001c68800000009ULL, 0x00000480003f0120ULL,
0x0001c600000000ffULL, 0x00000600003f0107ULL, 0x0001c68c00000038ULL, 0x00000660003f0102ULL,
0x0001c68800000038ULL, 0x00002570003f0101ULL, 0x0001c60800000038ULL, 0x00002580003f0101ULL,
0x0001c60c00000038ULL, 0x00002610003f0105ULL, 0x0001c60c00000038ULL, 0x00004250003f0105ULL,
0x0001c688000000ffULL, 0x00005120003f0101ULL, 0x0001c62800000038ULL, 0x00005130003f0101ULL,
0x0001c62c00000038ULL, 0x000051c0003f0105ULL, 0x0001c62c00000038ULL, 0x00006a50003f0105ULL,
0x0001c690000000ffULL, 0x00007920003f0101ULL, 0x0001c64800000038ULL, 0x00007930003f0101ULL,
0x0001c64c00000038ULL, 0x000079c0003f0105ULL, 0x0001c64c00000038ULL, 0x00009250003f0105ULL,
0x0001c698000000ffULL, 0x0000a120003f0101ULL, 0x0001c66800000038ULL, 0x0000a130003f0101ULL,
0x0001c66c00000038ULL, 0x0000a1c0003f0105ULL, 0x0001c66c00000038ULL, 0x0000ba80003f0105ULL,
0x0001c6a0000000ffULL, 0x0000f5b0003f0101ULL, 0x0001c600000000ffULL, 0x000111b0003f0101ULL,
0x0001c604000000ffULL, 0x00011250003f0105ULL, 0x0001c604000000ffULL, 0x00016470003f0105ULL,
0x0000000000000007ULL, 0x000164a0003f0101ULL, 0x0000000400000007ULL, 0x00016730003f0105ULL,
0x0000000400000007ULL, 0x00017b50003f0105ULL, 0x0001c60800000009ULL, 0x00017bb0003f0101ULL,
0x0001c61000000009ULL, 0x00017c10003f0101ULL, 0x0001c61800000009ULL, 0x00017c80003f0101ULL,
0x0001c62000000009ULL, 0x00033803003f0101ULL, 0x0000f4b000101c04ULL, 0x00011340000112b0ULL,
0x0000040100017cc0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000003bcULL, 0x0000001200000002ULL,
0x00000000000002e4ULL, 0x0000001200000002ULL, 0x000000000000020cULL, 0x0000001200000002ULL,
0x0000000000000134ULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x0000000000000399ULL, 0x0000001200000002ULL, 0x00000000000002c1ULL, 0x0000001200000002ULL,
0x00000000000001e9ULL, 0x0000001200000002ULL, 0x0000000000000111ULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000097919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000200ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000000087919ULL, 0x000ea20000002300ULL,
0x0000001000067300ULL, 0x000ee200000e0000ULL, 0x0000000304057899ULL, 0x000fe4000800063fULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x0000001000107309ULL, 0x000f260000000000ULL,
0x0000000000217919ULL, 0x000f680000002700ULL, 0x0000000000207919ULL, 0x000f220000000000ULL,
0x00000005ff2d7819ULL, 0x002fcc0000011609ULL, 0x00001fff2d2d7589ULL, 0x000fe200000e0000ULL,
0x0000000108007824ULL, 0x004fc600078e0203ULL, 0x00001fff08087589ULL, 0x000e6200000e0000ULL,
0x0000008000097824ULL, 0x000fe200078e0209ULL, 0x000000070600720cULL, 0x008fe40003f02070ULL,
0x0000000000007919ULL, 0x000ea40000002600ULL, 0x000000ff0900720cULL, 0x040fe40003f25270ULL,
0x0000000f0900780cULL, 0x040fe20003f44070ULL, 0x00000010200d7824ULL, 0x010fe200078e00ffULL,
0x0000007f0900780cULL, 0x000fc40003f84070ULL, 0x000000030900780cULL, 0x000fe40003f64070ULL,
0x000001f00d117812ULL, 0x000fca00078ec0ffULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x00000004080b7824ULL, 0x002fe400078e022dULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x01c60002ff009388ULL, 0x0003e20000000a00ULL,
0x7fffffc0ff05a424ULL, 0x000fe400078e00ffULL, 0xff317217ff0cc424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x01c608040900a388ULL, 0x000fe20000008a00ULL,
0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL, 0x000000020b0b7824ULL, 0x000fe200078e00ffULL,
0x01c4000c0900c388ULL, 0x0007e20000004800ULL, 0x00000008000a7824ULL, 0x004fc600078e00ffULL,
0x01c688060900b388ULL, 0x0005e20000008a00ULL, 0x000000080b027817ULL, 0x002fe20007800000ULL,
0x00000005210a7c24ULL, 0x020fe2000f8e020aULL, 0x000000010b0f7810ULL, 0x000fc60007ffe0ffULL,
0x000000010a037824ULL, 0x100fe400078e020bULL, 0x00000001020c7824ULL, 0x008fe400078e0a0bULL,
0x000000010a047824ULL, 0x000fe200078e020fULL, 0x000000070b077812ULL, 0x004fe200078ec0ffULL,
0x00005c0003027625ULL, 0x080fe200078e000eULL, 0x000000070f097812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000ff0c00720cULL, 0x000fe20003f23070ULL,
0x00005c0004047625ULL, 0x000fe200078e000eULL, 0x000000010c00780cULL, 0x000fc40003f43070ULL,
0x0000001f070a7812ULL, 0x100fe400078e7820ULL, 0x0000001f090c7812ULL, 0x000fe400078e7820ULL,
0x0000001102027210ULL, 0x080fe20007f7e0ffULL, 0x000000200b0a7824ULL, 0x000fe200078e020aULL,
0x0000001104067210ULL, 0x000fe20007f9e0ffULL, 0x000000200f0c7824ULL, 0x000fe400078e020cULL,
0x000000ffff037224ULL, 0x000fe400018e0603ULL, 0x000000100a097824ULL, 0x000fc400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400020e0605ULL, 0x000000100c0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fe200078e0a10ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000c901c46ULL, 0x00000004ff0f7424ULL, 0x000fc600078e00ffULL,
0x00000000060b7faeULL, 0x0003e2000d101c46ULL, 0x0000620021047625ULL, 0x000fc600078e000fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01c6040affff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006042b7981ULL, 0x000ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000ee20000002500ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x00000005ff2f7e24ULL, 0x008fe2000f8e00ffULL,
0x0000003f2b787810ULL, 0x004fc40007ffe0ffULL, 0x000000ff2b027810ULL, 0x002fe40007ffe0ffULL,
0x00000006ff787819ULL, 0x000fe40000011678ULL, 0x00000008ff027819ULL, 0x000fca0000011602ULL,
0x0000ef3000008947ULL, 0x000fea0003800000ULL, 0x000000012f037810ULL, 0x040fe20007ffe0ffULL,
0x000000042f397824ULL, 0x000fe400078e00ffULL, 0x000000082d387824ULL, 0x000fe200078e00ffULL,
0x000000020300720cULL, 0x000fe20003f26070ULL, 0x00000003ff037424ULL, 0x000fe200078e00ffULL,
0x000000783900720cULL, 0x000fe20003f06070ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c68c0338ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6880038ff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x0000640039047a10ULL, 0x000fe20007ffe0ffULL,
0x0000000221037824ULL, 0x002fc800078e00ffULL, 0x0000640003047a24ULL, 0x000fc800078e0204ULL,
0x0000600004047625ULL, 0x000fca00078e000fULL, 0x0000000604377981ULL, 0x000364000c1e1900ULL,
0x0000580037037a24ULL, 0x022fc800078e02ffULL, 0x00000040031d7824ULL, 0x000fe200078e00ffULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x000fe20000011620ULL,
0x000001002f047824ULL, 0x000fc600078e00ffULL, 0x000000080b0e7810ULL, 0x040fe40007ffe0ffULL,
0x000000100b107810ULL, 0x040fe40007ffe0ffULL, 0x000000200e067212ULL, 0x0c0fe200078e3cffULL,
0x000000080e077824ULL, 0x000fe200078e00ffULL, 0x000000040b0d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008101a7824ULL, 0x000fe200078e00ffULL, 0x000000140b117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff807167812ULL, 0x000fe200078ee206ULL, 0x0000004000067824ULL, 0x000fe200078e020bULL,
0x0000002010077212ULL, 0x000fe200078e3cffULL, 0x000000080d147824ULL, 0x000fe200078e00ffULL,
0x0000000c0b0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811137824ULL, 0x000fe200078e00ffULL,
0x000000042b037217ULL, 0x000fc40007800000ULL, 0x000000200d057212ULL, 0x000fe200078e3cffULL,
0x000000080f187824ULL, 0x000fe200078e00ffULL, 0x000000061d097210ULL, 0x000fe20007f1e0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a04ULL, 0x0000002011087212ULL, 0x000fe400078e3cffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000406077810ULL, 0x000fe40007ffe0ffULL, 0xfffffff814147812ULL, 0x000fc400078ee205ULL,
0x000000200f057212ULL, 0x000fe400078e3cffULL, 0xfffffff8131c7812ULL, 0x000fe400078ee208ULL,
0x00005e0009047a11ULL, 0x000fe400078048ffULL, 0x0000000806087810ULL, 0x000fe40007ffe0ffULL,
0x000000071d077210ULL, 0x000fe40007f9e0ffULL, 0xfffffff818187812ULL, 0x000fc400078ee205ULL,
0x00005f0009057a11ULL, 0x000fe400000f4c0aULL, 0x000000180b137810ULL, 0x000fe40007ffe0ffULL,
0x000000081d177210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff087224ULL, 0x000fe200020e06ffULL,
0x0000000c06097810ULL, 0x040fe20007ffe0ffULL, 0x00000008131e7824ULL, 0x000fe200078e00ffULL,
0x00000010060a7810ULL, 0x040fe40007ffe0ffULL, 0x00000014060c7810ULL, 0x000fc40007ffe0ffULL,
0x0000001806127810ULL, 0x040fe40007ffe0ffULL, 0x0000001c06157810ULL, 0x000fe40007ffe0ffULL,
0x00005e0007067a11ULL, 0x000fe400078c48ffULL, 0x0000001c0b1b7810ULL, 0x000fe40007ffe0ffULL,
0x000000091d197210ULL, 0x040fe40007f1e0ffULL, 0x0000000c1d237210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000000a1d247210ULL, 0x000fc40007f3e0ffULL,
0x000000121d1f7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005f0007077a11ULL, 0x000fe400030f4c08ULL, 0x0000002013097212ULL, 0x000fe200078e3cffULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x000000151d1d7210ULL, 0x000fe20007f9e0ffULL,
0x000000081b157824ULL, 0x000fe200078e00ffULL, 0x00005e0017087a11ULL, 0x000fe400078448ffULL,
0x0000002003037817ULL, 0x000fc40003800000ULL, 0x000000201b0a7212ULL, 0x000fe400078e3cffULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee209ULL, 0x00005f0017097a11ULL, 0x000fe400010f4c0cULL,
0x000000030b00720cULL, 0x000fe40003f46070ULL, 0xfffffff815227812ULL, 0x000fe200078ee20aULL,
0x000000082d157824ULL, 0x000fe200078e00ffULL, 0x000000070b0b7812ULL, 0x000fc400078e4820ULL,
0x00005e00190a7a11ULL, 0x000fe400078c48ffULL, 0x000140002d177811ULL, 0x000fe400078e68ffULL,
0x0ffffff80b0c7812ULL, 0x100fe400078ef820ULL, 0xfffffff815157812ULL, 0x000fe400078ee220ULL,
0x000000030d00720cULL, 0x080fe20003f06070ULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0x00005f00190b7a11ULL, 0x000fe200030f4c12ULL, 0x000000100c197824ULL, 0x000fe200078e0217ULL,
0x00005e00240c7a11ULL, 0x000fe200078c48ffULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x000000030e00720cULL, 0x000fc40003f26070ULL, 0x00005f00240d7a11ULL, 0x000fe200030f4c0dULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x00005e00230e7a11ULL, 0x000fe200078c48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004197faeULL, 0x0003e2000d101c46ULL,
0x000000031000720cULL, 0x080fe20003f46070ULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x000000030f00720cULL, 0x000fe40003f66070ULL, 0x00005e001f107a11ULL, 0x000fe400078a48ffULL,
0x00005f00230f7a11ULL, 0x000fe200030f4c12ULL, 0x000000101e237824ULL, 0x000fe200078e0217ULL,
0x00005e001d127a11ULL, 0x000fc400078c48ffULL, 0x000000031100720cULL, 0x080fe20003f86070ULL,
0x0000001015047825ULL, 0x002fe200078e0006ULL, 0x00005f001f117a11ULL, 0x000fe400028f4c26ULL,
0x000000031300720cULL, 0x080fe20003fa6070ULL, 0x0000001016197824ULL, 0x000fe200078e0217ULL,
0x00005f001d137a11ULL, 0x000fe200030f4c24ULL, 0x0000001015067825ULL, 0x000fe200078e0008ULL,
0x000000031b00720cULL, 0x000fc60003fc6070ULL, 0x0000001014037824ULL, 0x100fe400078e0217ULL,
0x00000010181b7824ULL, 0x000fe400078e0217ULL, 0x0000001015087825ULL, 0x040fe200078e000aULL,
0x0000000004037faeULL, 0x0003e6000c101c46ULL, 0x000000101a1d7824ULL, 0x000fe200078e0217ULL,
0x0000000006197faeULL, 0x0003e2000c901c46ULL, 0x00000010150a7825ULL, 0x000fc600078e000cULL,
0x00000000081b7faeULL, 0x0003e2000d901c46ULL, 0x000000101c1f7824ULL, 0x000fe400078e0217ULL,
0x00000010150c7825ULL, 0x040fe200078e000eULL, 0x000000000a1d7faeULL, 0x0003e6000d101c46ULL,
0x00000010150e7825ULL, 0x040fe200078e0010ULL, 0x000000000c1f7faeULL, 0x0003e6000e101c46ULL,
0x0000001022177824ULL, 0x000fe200078e0217ULL, 0x000000000e237faeULL, 0x0003e2000e901c46ULL,
0x0000001015107825ULL, 0x000fca00078e0012ULL, 0x0000000010177faeULL, 0x0003e2000f101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe20000011620ULL,
0x000000082d297824ULL, 0x000fc600078e00ffULL, 0x0000000403057810ULL, 0x040fe40007ffe0ffULL,
0x0000000803077810ULL, 0x040fe40007ffe0ffULL, 0x0000000c03097810ULL, 0x000fe20007ffe0ffULL,
0x00000008050b7824ULL, 0x040fe200078e00ffULL, 0x0000002005047212ULL, 0x080fe200078e3cffULL,
0x0000000807087824ULL, 0x040fe200078e00ffULL, 0x0000002007057212ULL, 0x080fe200078e3cffULL,
0x0000000809117824ULL, 0x040fe200078e00ffULL, 0x0000002009067212ULL, 0x000fc400078e3cffULL,
0xfffffff8080d7812ULL, 0x000fe400078ee205ULL, 0xfffffff811117812ULL, 0x000fe200078ee206ULL,
0x0000004000067824ULL, 0x000fe200078e0203ULL, 0x0000001003057810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80b097812ULL, 0x000fe400078ee204ULL, 0x0000002005077212ULL, 0x040fe200078e3cffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x000000061d057210ULL, 0x000fc40007f1e0ffULL,
0x00000014030b7810ULL, 0x040fe40007ffe0ffULL, 0x00000018030f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078048ffULL,
0x000000080b237824ULL, 0x040fe200078e00ffULL, 0x000000200b0a7212ULL, 0x080fe200078e3cffULL,
0x000000080f0e7824ULL, 0x040fe200078e00ffULL, 0x000000200f0b7212ULL, 0x000fe400078e3cffULL,
0x00005f0005057a11ULL, 0x000fc400000f4c08ULL, 0x0000000406087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c1f7812ULL, 0x000fe400078ee207ULL, 0xfffffff823237812ULL, 0x000fe400078ee20aULL,
0xfffffff80e257812ULL, 0x000fe400078ee20bULL, 0x0000001c03077810ULL, 0x000fe40007ffe0ffULL,
0x00000008060a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c060c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000807277824ULL, 0x000fe200078e00ffULL, 0x00000010060e7810ULL, 0x040fe40007ffe0ffULL,
0x0000001406107810ULL, 0x040fe40007ffe0ffULL, 0x0000001806127810ULL, 0x040fe40007ffe0ffULL,
0x000000081d087210ULL, 0x000fe40007fde0ffULL, 0x0000001c06067810ULL, 0x000fc40007ffe0ffULL,
0x0000000a1d0b7210ULL, 0x040fe40007fbe0ffULL, 0x0000000c1d0f7210ULL, 0x040fe40007f9e0ffULL,
0x0000000e1d137210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x000000101d167210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x000000121d187210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x00000020070a7212ULL, 0x000fe200078e3cffULL, 0x000000ffff077224ULL, 0x000fe200030e06ffULL,
0x000000061d1d7210ULL, 0x000fc40007f5e0ffULL, 0x00005e0008067a11ULL, 0x040fe400078c48ffULL,
0x0000000703037812ULL, 0x100fe200078e4820ULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x000140002d0c7811ULL, 0x000fe400078e68ffULL, 0x00005f0008077a11ULL, 0x000fe400030f4c07ULL,
0x0ffffff803037812ULL, 0x000fe200078ef820ULL, 0x0000001009177824ULL, 0x000fe200078e020cULL,
0xfffffff827277812ULL, 0x000fe200078ee20aULL, 0x000000100d197824ULL, 0x100fe200078e020cULL,
0x00005e000b087a11ULL, 0x000fe200078a48ffULL, 0x0000001003157824ULL, 0x100fe200078e020cULL,
0x00005e000f0a7a11ULL, 0x000fe200078848ffULL, 0x00000010111b7824ULL, 0x000fe200078e020cULL,
0x00005f000b097a11ULL, 0x000fe200028f4c0eULL, 0x000000101f1f7824ULL, 0x000fe200078e020cULL,
0x00005f000f0b7a11ULL, 0x000fe200020f4c10ULL, 0x0000001023237824ULL, 0x000fe200078e020cULL,
0xfffffff829037812ULL, 0x000fe200078ee220ULL, 0x0000001025257824ULL, 0x100fe200078e020cULL,
0x00005e001d127a11ULL, 0x000fe200078448ffULL, 0x0000001027277824ULL, 0x000fe200078e020cULL,
0x00005e00130c7a11ULL, 0x000fe200078648ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e00160e7a11ULL, 0x000fe200078048ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x00005e0018107a11ULL, 0x000fe200078248ffULL, 0x0000001003047825ULL, 0x000fe200078e0004ULL,
0x00005f00130d7a11ULL, 0x000fc400018f4c14ULL, 0x00005f00160f7a11ULL, 0x000fe200000f4c0fULL,
0x0000001003067825ULL, 0x000fe200078e0006ULL, 0x00005f0018117a11ULL, 0x000fe200008f4c11ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004157faeULL, 0x0003e2000b901c46ULL,
0x00005f001d137a11ULL, 0x000fe200010f4c1aULL, 0x0000001003087825ULL, 0x040fe400078e0008ULL,
0x0000000006177faeULL, 0x0003e4000b901c46ULL, 0x00000010030a7825ULL, 0x040fe400078e000aULL,
0x0000000008197faeULL, 0x0003e4000b901c46ULL, 0x00000010030c7825ULL, 0x000fc400078e000cULL,
0x000000000a1b7faeULL, 0x0003e4000b901c46ULL, 0x00000010030e7825ULL, 0x040fe400078e000eULL,
0x000000000c1f7faeULL, 0x0003e4000b901c46ULL, 0x0000001003107825ULL, 0x040fe400078e0010ULL,
0x000000000e237faeULL, 0x0003e4000b901c46ULL, 0x0000001003127825ULL, 0x000fc400078e0012ULL,
0x0000000010257faeULL, 0x0003e8000b901c46ULL, 0x0000000012277faeULL, 0x0003e4000b901c46ULL,
0x000000022f00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff367424ULL, 0x000fe200078e00ffULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x002fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000a50000000947ULL, 0x000fea0003800000ULL, 0x0000000221217824ULL, 0x000fe400078e00ffULL,
0x00006400ff347624ULL, 0x000fc400078e00ffULL, 0xff317217ff367424ULL, 0x000fe400078e00ffULL,
0x000000ffff577224ULL, 0x000fe400078e00ffULL, 0x0000640021347624ULL, 0x000fe400078e0234ULL,
0x000001002f227824ULL, 0x000fca00078e00ffULL, 0x0000002b2200720cULL, 0x000fda0003f06070ULL,
0x0000a44000000947ULL, 0x004fea0003800000ULL, 0x000000012f037810ULL, 0x000fe20007ffe0ffULL,
0x0000580037377a24ULL, 0x000fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000020300720cULL, 0x000fe20003f06070ULL, 0x00000040373b7824ULL, 0x000fd800078e00ffULL,
0x0000073000008947ULL, 0x000fea0003800000ULL, 0x00000003ff297819ULL, 0x000fe40000011620ULL,
0x0000002000267811ULL, 0x000fe400078e30ffULL, 0x000000202f227811ULL, 0x000fe400078e40ffULL,
0x0000000829417810ULL, 0x040fe20007ffe0ffULL, 0x0000000129217824ULL, 0x000fe200078e0226ULL,
0x000000222b037217ULL, 0x000fe40007800000ULL, 0x00000004293d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008412a7824ULL, 0x000fe200078e00ffULL, 0x000000213b237210ULL, 0x000fe20007f3e0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a22ULL, 0x0000002041257212ULL, 0x080fe200078e3cffULL,
0x000000083d287824ULL, 0x040fe200078e00ffULL, 0x000000203d217212ULL, 0x000fe200078e3cffULL,
0x000000ffff247224ULL, 0x000fe200008e06ffULL, 0x00005e0023227a11ULL, 0x000fc400078248ffULL,
0xfffffff82a437812ULL, 0x000fe400078ee225ULL, 0x00005f0023237a11ULL, 0x000fe200008f4c24ULL,
0x000000013d247824ULL, 0x000fe200078e0226ULL, 0x0000000729257812ULL, 0x100fe400078e4820ULL,
0x0000002003037817ULL, 0x000fe40003800000ULL, 0x0ffffff825277812ULL, 0x000fe400078ef820ULL,
0x000000243b257210ULL, 0x000fc40007f5e0ffULL, 0xfffffff8283f7812ULL, 0x000fe400078ee221ULL,
0x0000000720217812ULL, 0x000fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e0025247a11ULL, 0x000fe400078448ffULL, 0x000000032900720cULL, 0x000fe20003f26070ULL,
0x0000000138217824ULL, 0x000fe200078e0221ULL, 0x000150002d2a7811ULL, 0x000fe400078e68ffULL,
0x0000000c29457810ULL, 0x000fe20007ffe0ffULL, 0x0000001021227825ULL, 0x000fe200078e0022ULL,
0x0000001029497810ULL, 0x000fc40007ffe0ffULL, 0x00000014294d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000845477824ULL, 0x000fe200078e00ffULL, 0x00005f0025257a11ULL, 0x000fe200010f4c28ULL,
0x0000000141287824ULL, 0x000fe200078e0226ULL, 0x00000020452c7212ULL, 0x080fe200078e3cffULL,
0x00000008494b7824ULL, 0x040fe200078e00ffULL, 0x00000020492e7212ULL, 0x080fe200078e3cffULL,
0x000000084d4f7824ULL, 0x040fe200078e00ffULL, 0x000000204d307212ULL, 0x000fe200078e3cffULL,
0x0000001027277824ULL, 0x000fe200078e022aULL, 0x0000001829517810ULL, 0x000fc40007ffe0ffULL,
0x0000001c29597810ULL, 0x000fe20007ffe0ffULL, 0x0000000145297824ULL, 0x000fe200078e0226ULL,
0x000000283b337210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022277faeULL, 0x0003e2000c901c46ULL, 0xfffffff847477812ULL, 0x000fe200078ee22cULL,
0x00000001492c7824ULL, 0x000fe200078e0226ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee22eULL,
0x000000014d2e7824ULL, 0x000fe200078e0226ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee230ULL,
0x0000000151307824ULL, 0x100fe200078e0226ULL, 0x000000293b297210ULL, 0x000fe20007f7e0ffULL,
0x0000000159287824ULL, 0x000fe200078e0226ULL, 0x00005e0033267a11ULL, 0x000fe200078c48ffULL,
0x00000008513a7824ULL, 0x000fe200078e00ffULL, 0x0000002c3b317210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff227224ULL, 0x002fe200010e06ffULL, 0x0000002e3b377210ULL, 0x000fe20007f9e0ffULL,
0x00000008595b7824ULL, 0x000fe200078e00ffULL, 0x000000303b2e7210ULL, 0x000fc40007fbe0ffULL,
0x00005f0033277a11ULL, 0x000fe200030f4c22ULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x000000283b2c7210ULL, 0x000fe20007f5e0ffULL, 0x000000103f337824ULL, 0x000fe200078e022aULL,
0x0000002051237212ULL, 0x080fe400078e3cffULL, 0x0000002059307212ULL, 0x000fe400078e3cffULL,
0x00005e0029287a11ULL, 0x000fe400078c48ffULL, 0xfffffff83a537812ULL, 0x000fe200078ee223ULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x000000033d00720cULL, 0x000fc40003f66070ULL,
0xfffffff85b5b7812ULL, 0x000fe400078ee230ULL, 0x00005f0029297a11ULL, 0x000fe200030f4c22ULL,
0x0000001021227825ULL, 0x000fe200078e0024ULL, 0x00005e0031307a11ULL, 0x000fe400078c48ffULL,
0x000000034100720cULL, 0x080fe20003f26070ULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005f0031317a11ULL, 0x000fe200030f4c3aULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x00005e00373a7a11ULL, 0x000fe200078c48ffULL, 0x0000000022337faeULL, 0x0003e2000d901c46ULL,
0x000000034500720cULL, 0x000fe20003f66070ULL, 0x000000104f417824ULL, 0x000fe200078e022aULL,
0x00005f00373b7a11ULL, 0x000fe200030f4c24ULL, 0x000000ffff377224ULL, 0x000fe200028e06ffULL,
0x00005e002e3c7a11ULL, 0x000fe200078a48ffULL, 0x000000105b457824ULL, 0x000fe200078e022aULL,
0x00005e002c3e7a11ULL, 0x000fc400078c48ffULL, 0x000000034900720cULL, 0x080fe40003f86070ULL,
0x000000034d00720cULL, 0x080fe20003f46070ULL, 0x0000001021227825ULL, 0x002fe200078e0026ULL,
0x00005f002e3d7a11ULL, 0x000fe400028f4c37ULL, 0x000000035100720cULL, 0x080fe20003fa6070ULL,
0x0000001047337824ULL, 0x000fe200078e022aULL, 0x00005f002c3f7a11ULL, 0x000fe200030f4c25ULL,
0x0000001021247825ULL, 0x000fe200078e0028ULL, 0x000000035900720cULL, 0x000fc60003fc6070ULL,
0x0000001043037824ULL, 0x100fe400078e022aULL, 0x000000104b377824ULL, 0x000fe400078e022aULL,
0x0000001021267825ULL, 0x040fe200078e0030ULL, 0x0000000022037faeULL, 0x0003e6000c901c46ULL,
0x0000001021287825ULL, 0x000fe200078e003aULL, 0x0000000024337faeULL, 0x0003e6000d901c46ULL,
0x0000001053437824ULL, 0x000fe200078e022aULL, 0x0000000026377faeULL, 0x0003e2000e101c46ULL,
0x0000001021307825ULL, 0x000fc600078e003cULL, 0x0000000028417faeULL, 0x0003e2000d101c46ULL,
0x00000010213a7825ULL, 0x000fc600078e003eULL, 0x0000000030437faeULL, 0x0003e8000e901c46ULL,
0x000000003a457faeULL, 0x0003e2000f101c46ULL, 0x0000066000007947ULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x000fe40000011620ULL, 0x0000002000267811ULL, 0x000fe400078e30ffULL,
0x0000000803277810ULL, 0x040fe40007ffe0ffULL, 0x0000000403237810ULL, 0x000fc40007ffe0ffULL,
0x0000002027227212ULL, 0x0c0fe200078e3cffULL, 0x0000000827317824ULL, 0x000fe200078e00ffULL,
0x0000002023217212ULL, 0x040fe200078e3cffULL, 0x0000000823287824ULL, 0x000fe200078e00ffULL,
0x0000001003377810ULL, 0x000fe40007ffe0ffULL, 0xfffffff831317812ULL, 0x000fe200078ee222ULL,
0x0000000103227824ULL, 0x000fe200078e0226ULL, 0xfffffff828297812ULL, 0x000fe200078ee221ULL,
0x00000008372e7824ULL, 0x000fe200078e00ffULL, 0x0000000c03337810ULL, 0x000fc40007ffe0ffULL,
0x000000223b217210ULL, 0x000fe20007f3e0ffULL, 0x0000000123227824ULL, 0x000fe200078e0226ULL,
0x0000002037237212ULL, 0x080fe200078e3cffULL, 0x00000008333d7824ULL, 0x040fe200078e00ffULL,
0x0000002033247212ULL, 0x000fe200078e3cffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x000000223b257210ULL, 0x000fe40007f5e0ffULL, 0x00005e0021227a11ULL, 0x000fe400078248ffULL,
0xfffffff82e3f7812ULL, 0x000fe200078ee223ULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee224ULL, 0x00000001372e7824ULL, 0x000fe200078e0226ULL,
0x0000001403417810ULL, 0x000fc40007ffe0ffULL, 0x00005f0021237a11ULL, 0x000fe200008f4c28ULL,
0x0000000127287824ULL, 0x100fe200078e0226ULL, 0x00005e0025247a11ULL, 0x000fe200078448ffULL,
0x0000000841457824ULL, 0x000fe200078e00ffULL, 0x0000001803217810ULL, 0x000fe20007ffe0ffULL,
0x0000000141307824ULL, 0x000fe200078e0226ULL, 0x0000001c03437810ULL, 0x000fe40007ffe0ffULL,
0x00005f0025257a11ULL, 0x000fe200010f4c2aULL, 0x00000001332a7824ULL, 0x100fe200078e0226ULL,
0x00000020412c7212ULL, 0x000fe200078e3cffULL, 0x00000001213a7824ULL, 0x100fe200078e0226ULL,
0x000000283b287210ULL, 0x000fe20007fde0ffULL, 0x00000001433c7824ULL, 0x000fe200078e0226ULL,
0x0000002021267212ULL, 0x040fe200078e3cffULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee22cULL, 0x000000ffff277224ULL, 0x000fe200030e06ffULL,
0x0000002a3b2c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000843497824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fc400078e4820ULL, 0x0000002e3b2e7210ULL, 0x040fe40007f9e0ffULL,
0x000000303b407210ULL, 0x040fe40007f3e0ffULL, 0x0000003a3b427210ULL, 0x040fe40007f5e0ffULL,
0x0000003c3b447210ULL, 0x000fe40007f7e0ffULL, 0x000150002d2a7811ULL, 0x000fe400078e68ffULL,
0xfffffff8213b7812ULL, 0x000fc400078ee226ULL, 0x00005e0028267a11ULL, 0x000fe200078c48ffULL,
0x0000001029337824ULL, 0x100fe200078e022aULL, 0x0000002043307212ULL, 0x000fe200078e3cffULL,
0x0000001031377824ULL, 0x000fe200078e022aULL, 0x0ffffff803217812ULL, 0x000fe200078ef820ULL,
0x000000ffff297224ULL, 0x000fe200028e06ffULL, 0x0000000720037812ULL, 0x000fe200078ec0ffULL,
0x000000103b477824ULL, 0x000fe200078e022aULL, 0x00005f0028277a11ULL, 0x000fe200030f4c27ULL,
0x000000ffff317224ULL, 0x000fe200020e06ffULL, 0xfffffff849497812ULL, 0x000fe200078ee230ULL,
0x000000103d417824ULL, 0x100fe200078e022aULL, 0x00005e002c287a11ULL, 0x000fe200078a48ffULL,
0x000000ffff3b7224ULL, 0x000fe200008e06ffULL, 0x00005e002e307a11ULL, 0x000fe200078848ffULL,
0x000000103f437824ULL, 0x100fe200078e022aULL, 0x00005e00403a7a11ULL, 0x000fe200078248ffULL,
0x0000000138037824ULL, 0x000fe200078e0203ULL, 0x00005f002c297a11ULL, 0x000fe200028f4c29ULL,
0x000000ffff3d7224ULL, 0x000fe200010e06ffULL, 0x00005e00423c7a11ULL, 0x000fe200078448ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x00005e00443e7a11ULL, 0x000fe200078648ffULL,
0x0000001021217824ULL, 0x000fe200078e022aULL, 0x00005f002e317a11ULL, 0x000fe200020f4c31ULL,
0x0000001003227825ULL, 0x000fe200078e0022ULL, 0x00005f00403b7a11ULL, 0x000fc400008f4c3bULL,
0x00005f00423d7a11ULL, 0x000fe200010f4c3dULL, 0x0000001003247825ULL, 0x040fe200078e0024ULL,
0x00005f00443f7a11ULL, 0x000fe200018f4c3fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022217faeULL, 0x0003e4000b901c46ULL, 0x0000001003267825ULL, 0x040fe400078e0026ULL,
0x0000000024337faeULL, 0x0003e4000b901c46ULL, 0x0000001003287825ULL, 0x040fe400078e0028ULL,
0x0000000026377faeULL, 0x0003e4000b901c46ULL, 0x0000001003307825ULL, 0x000fc400078e0030ULL,
0x0000000028417faeULL, 0x0003e4000b901c46ULL, 0x0000001045457824ULL, 0x000fe400078e022aULL,
0x00000010033a7825ULL, 0x040fe200078e003aULL, 0x0000000030437faeULL, 0x0003e6000b901c46ULL,
0x00000010033c7825ULL, 0x000fe200078e003cULL, 0x000000003a457faeULL, 0x0003e6000b901c46ULL,
0x0000001049497824ULL, 0x000fe200078e022aULL, 0x000000003c477faeULL, 0x0003e2000b901c46ULL,
0x00000010033e7825ULL, 0x000fca00078e003eULL, 0x000000003e497faeULL, 0x0003e4000b901c46ULL,
0x00000004ff237424ULL, 0x002fe200078e00ffULL, 0x0000000339217812ULL, 0x000fe200078ec0ffULL,
0x00000300ff037624ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x000000032100780cULL, 0x000fe20003f25270ULL, 0xfffffffd23037424ULL, 0x000fca00078e0203ULL,
0x0000000103227807ULL, 0x000fca0004800000ULL, 0x0000000139397824ULL, 0x000fca00078e0222ULL,
0x000000783900720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x0000000139227824ULL, 0x000fc800078e0234ULL, 0x0000600022227625ULL, 0x000fca00078e0023ULL,
0x0000000622377981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6080038227f8cULL, 0x002fe8000c80043fULL,
0x01c60c0038037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007824823ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300217305ULL, 0x0002e4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000210000735dULL, 0x008fe40003800000ULL, 0x01c60c0038217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fc40007824823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001020337824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011620ULL,
0x0000007033337812ULL, 0x000fe400078ec0ffULL, 0x0000000c03227812ULL, 0x000fca00078ec0ffULL,
0x0000000133337824ULL, 0x000fca00078e0222ULL, 0x01c0000033037984ULL, 0x000e680000000800ULL,
0x01c2000033217984ULL, 0x0007220000000800ULL, 0x000000360300720bULL, 0x002fe20003f3d000ULL,
0x000155e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000227806ULL, 0x008fc800008e0100ULL,
0x0000ffff22247812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff227424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff2d00720cULL, 0x000fe40003f25270ULL, 0x000000360300720bULL, 0x000fe20003f54000ULL,
0x000155c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000227806ULL, 0x000fe400010e0100ULL,
0x0000000336267209ULL, 0x000fe40007810000ULL, 0x0000ffff22257812ULL, 0x000fe400078e3cffULL,
0x00000002ff227819ULL, 0x000fe20000011620ULL, 0x8000002636237221ULL, 0x000fe20000010000ULL,
0x01c4002633009388ULL, 0x0003e20000000800ULL, 0x0000002524ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b23237820ULL, 0x000fc80000410000ULL, 0x00000023004b7308ULL, 0x0002e20000000800ULL,
0x000155827f007947ULL, 0x000fec000b800000ULL, 0x00001f224b237589ULL, 0x00a2e400000e0000ULL,
0x0000000822227810ULL, 0x002fe20007ffe0ffULL, 0x000155c27f007947ULL, 0x000fea000b800000ULL,
0x00001f224b227589ULL, 0x0002a400000e0000ULL, 0x8000002603031221ULL, 0x000fe40000010000ULL,
0x0000002257577220ULL, 0x084fe40000410000ULL, 0x3fb8aa3b03031820ULL, 0x000fe40000410000ULL,
0x0000002256567220ULL, 0x080fe40000410000ULL, 0x0000000300321308ULL, 0x000ea20000000800ULL,
0x000000221b1b7220ULL, 0x000fc40000410000ULL, 0x000000221a1a7220ULL, 0x080fe40000410000ULL,
0x000000221f1f7220ULL, 0x080fe40000410000ULL, 0x000000221e1e7220ULL, 0x080fe40000410000ULL,
0x0000002217177220ULL, 0x080fe40000410000ULL, 0x0000002216167220ULL, 0x080fe40000410000ULL,
0x0000002213137220ULL, 0x000fc40000410000ULL, 0x0000002212127220ULL, 0x080fe40000410000ULL,
0x000000220b0b7220ULL, 0x080fe40000410000ULL, 0x000000220a0a7220ULL, 0x080fe40000410000ULL,
0x000000220f0f7220ULL, 0x080fe40000410000ULL, 0x000000220e0e7220ULL, 0x080fe40000410000ULL,
0x0000002207077220ULL, 0x000fc40000410000ULL, 0x0000002206067220ULL, 0x000fe20000410000ULL,
0x00000001ff227807ULL, 0x000fe20000800000ULL, 0x0000004b35357220ULL, 0x000fe40000410000ULL,
0x0000002355557220ULL, 0x088fe40000410000ULL, 0x0000002354547220ULL, 0x080fe40000410000ULL,
0x0000002319197220ULL, 0x080fe40000410000ULL, 0x0000002318187220ULL, 0x000fc40000410000ULL,
0x000000231d1d7220ULL, 0x080fe40000410000ULL, 0x000000231c1c7220ULL, 0x080fe40000410000ULL,
0x0000002315157220ULL, 0x080fe40000410000ULL, 0x0000002314147220ULL, 0x080fe40000410000ULL,
0x0000002311117220ULL, 0x080fe40000410000ULL, 0x0000002310107220ULL, 0x000fc40000410000ULL,
0x0000002309097220ULL, 0x080fe40000410000ULL, 0x0000002308087220ULL, 0x080fe40000410000ULL,
0x000000230d0d7220ULL, 0x080fe40000410000ULL, 0x000000230c0c7220ULL, 0x080fe40000410000ULL,
0x0000002305057220ULL, 0x080fe40000410000ULL, 0x0000002304047220ULL, 0x000fc40000410000ULL,
0x000000ffff367224ULL, 0x000fe400078e0026ULL, 0x0000003221211220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000032ff03723eULL, 0x000fe200000010ffULL,
0x0000003521357221ULL, 0x010fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff2c7819ULL, 0x000fe40000011620ULL, 0x00005410034b7816ULL, 0x002fe20000000003ULL,
0x000153427f007947ULL, 0x000fea000b800000ULL, 0x000000082c307810ULL, 0x000fe20007ffe0ffULL,
0x00001f2c4b3b7589ULL, 0x0002e800000e0000ULL, 0x00001f304b3a7589ULL, 0x00032400000e0000ULL,
0x000000102c2e7810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff4c7224ULL, 0x002fe200078e002eULL, 0x00002bd000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff4d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x000161d000007944ULL, 0x03cfea0003c00000ULL, 0x000000182c2c7810ULL, 0x002fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e002cULL,
0x00002c4000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x0001616000007944ULL, 0x03cfea0003c00000ULL,
0x0000000720317812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff247819ULL, 0x100fe40000011620ULL, 0x00000008316d7812ULL, 0x000fe400078ef820ULL,
0x0000000820037812ULL, 0x000fc400078ec0ffULL, 0x00000007242a7812ULL, 0x000fca00078e786dULL,
0x000000086d2a7824ULL, 0x000fca00078e022aULL, 0x000120002a487811ULL, 0x000fca00078e20ffULL,
0x0000000703217812ULL, 0x140fe200078ef820ULL, 0x000000004848783bULL, 0x006e620000000200ULL,
0x0000000703037812ULL, 0x000fe400078ec820ULL, 0x0000000224267810ULL, 0x040fe40007ffe0ffULL,
0x0000000424287810ULL, 0x040fe40007ffe0ffULL, 0x00000006243c7810ULL, 0x000fe40007ffe0ffULL,
0x00000024037a7212ULL, 0x000fc400078e3cffULL, 0x00000026037c7212ULL, 0x040fe400078e3cffULL,
0x0000002803747212ULL, 0x000fe200078e3cffULL, 0x0000000821727824ULL, 0x000fe200078e027aULL,
0x000140002d297811ULL, 0x000fe200078e68ffULL, 0x0000000821707824ULL, 0x000fe200078e027cULL,
0x0000003c03767212ULL, 0x000fe200078e3cffULL, 0x00000008216e7824ULL, 0x040fe200078e0274ULL,
0x0000000726247812ULL, 0x000fe200078e786dULL, 0x0000001072287824ULL, 0x100fe200078e0229ULL,
0x0000991022037816ULL, 0x000fe200000000ffULL, 0x00000008216c7824ULL, 0x040fe200078e0276ULL,
0x0000008021217811ULL, 0x000fe200078e18ffULL, 0x0000001070277824ULL, 0x100fe200078e0229ULL,
0x000000002860783bULL, 0x000ea20000004200ULL, 0x000000106e267824ULL, 0x100fe200078e0229ULL,
0x000000ff0300720cULL, 0x000fe20003f25270ULL, 0x000000106c257824ULL, 0x000fe200078e0229ULL,
0x00000000275c783bULL, 0x000f220000004200ULL, 0x000000086d247824ULL, 0x000fc400078e0224ULL,
0x0000000174747824ULL, 0x100fe200078e0221ULL, 0x000000002650783bULL, 0x000fe20000004200ULL,
0x000000017a7a7824ULL, 0x100fe200078e0221ULL, 0x00012000243c7811ULL, 0x000fe200078e20ffULL,
0x000000017c7c7824ULL, 0x100fe200078e0221ULL, 0x00000000254c783bULL, 0x000fe20000004200ULL,
0x0000000176767824ULL, 0x000fe400078e0221ULL, 0x0000001074217824ULL, 0x100fe200078e0229ULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0x000000107a237824ULL, 0x100fe200078e0229ULL,
0x0000003b48489231ULL, 0x08afe200003400ffULL, 0x000000107c227824ULL, 0x100fe200078e0229ULL,
0x000000002144783bULL, 0x000e620000004200ULL, 0x0000001076037824ULL, 0x000fe200078e0229ULL,
0x0000003b4a4a9231ULL, 0x000fc400003400ffULL, 0x000000002364783bULL, 0x000ee20000004200ULL,
0x0000003a49499231ULL, 0x090fe400003400ffULL, 0x0000003a4b4b9231ULL, 0x000fe200003400ffULL,
0x000000002268783bULL, 0x000f280000004200ULL, 0x000000000340783bULL, 0x000e640000004200ULL,
0x000000604858723cULL, 0x044ff00000041804ULL, 0x00000062480c723cULL, 0x040ff0000004180cULL,
0x0000005c4860723cULL, 0x000fe20000041808ULL, 0x0000003b3c3c9231ULL, 0x000fc400003400ffULL,
0x0000003b3e3e9231ULL, 0x000fe400003400ffULL, 0x0000003a3d3d9231ULL, 0x080fe400003400ffULL,
0x0000003a3f3f9231ULL, 0x000fe200003400ffULL, 0x0000005e4810723cULL, 0x040ff00000041810ULL,
0x00000050485c723cULL, 0x040ff00000041814ULL, 0x00000052481c723cULL, 0x040ff0000004181cULL,
0x0000004c4814723cULL, 0x040ff00000041818ULL, 0x0000004e4808723cULL, 0x000ff00000041854ULL,
0x000000443c5c723cULL, 0x042fee000004185cULL, 0x0000580037457a24ULL, 0x020fe200078e02ffULL,
0x000000643c58723cULL, 0x008fe60000041858ULL, 0x0000004045457824ULL, 0x000fca00078e00ffULL,
0x000000683c60723cULL, 0x050ff00000041860ULL, 0x000000663c64723cULL, 0x040ff0000004180cULL,
0x0000006a3c68723cULL, 0x040ff00000041810ULL, 0x000000463c18723cULL, 0x040ff0000004181cULL,
0x000000403c14723cULL, 0x040ff00000041814ULL, 0x000000423c08723cULL, 0x000fe20000041808ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x000fe20000011620ULL, 0x00000001383b7824ULL, 0x000fe200078e0231ULL,
0x000000402f047811ULL, 0x000fe400078e40ffULL, 0x00000004130f7810ULL, 0x040fe20007ffe0ffULL,
0x00000040001e7824ULL, 0x000fe200078e0213ULL, 0x00000008131d7810ULL, 0x000fe40007ffe0ffULL,
0x000000042b057217ULL, 0x000fe20007800000ULL, 0x000000080f1c7824ULL, 0x000fe200078e00ffULL,
0x0000001013437810ULL, 0x000fe20007ffe0ffULL, 0x000000081d0d7824ULL, 0x000fe200078e00ffULL,
0x0000001413477810ULL, 0x000fe20007ffe0ffULL, 0x0000000105067824ULL, 0x000fe200078e0a04ULL,
0x000000200f077212ULL, 0x080fe200078e3cffULL, 0x0000000843427824ULL, 0x000fe200078e00ffULL,
0x000000201d0c7212ULL, 0x000fe200078e3cffULL, 0x0000000847447824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fc400078ee207ULL, 0x0000000c131f7810ULL, 0x000fe40007ffe0ffULL,
0x0000002043057212ULL, 0x080fe200078e3cffULL, 0x000000101c3f7824ULL, 0x000fe200078e0229ULL,
0x0000001813497810ULL, 0x000fe40007ffe0ffULL, 0x0000002047077212ULL, 0x000fe400078e3cffULL,
0xfffffff80d3c7812ULL, 0x000fe200078ee20cULL, 0x000000081f0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee205ULL, 0x0000000849467824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee207ULL, 0x000000103c417824ULL, 0x000fe200078e0229ULL,
0x0000001c134b7810ULL, 0x000fc40007ffe0ffULL, 0x000000451e057210ULL, 0x040fe40007f5e0ffULL,
0x000000201f047212ULL, 0x080fe200078e3cffULL, 0x000000084b487824ULL, 0x000fe200078e00ffULL,
0x0000002049077212ULL, 0x000fe200078e3cffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x000000041e0e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80d3e7812ULL, 0x000fe400078ee204ULL,
0xfffffff846467812ULL, 0x000fc400078ee207ULL, 0x000000204b0d7212ULL, 0x000fe400078e3cffULL,
0x00005e0005047a11ULL, 0x040fe400078448ffULL, 0x000000450e077210ULL, 0x000fe40007f7e0ffULL,
0x000000081e0e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff848487812ULL, 0x000fe400078ee20dULL,
0x00005f0005057a11ULL, 0x000fe200010f4c0cULL, 0x000000ffff0c7224ULL, 0x000fe200018e06ffULL,
0x00000020063a7817ULL, 0x000fc40003800000ULL, 0x000000450e0d7210ULL, 0x080fe20007f9e0ffULL,
0x000000103b047825ULL, 0x000fe200078e0004ULL, 0x00005e0007067a11ULL, 0x000fe400078448ffULL,
0x0000000c1e107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x0000003a0f00720cULL, 0x000fe40003f66070ULL, 0x00005f0007077a11ULL, 0x000fe400010f4c0cULL,
0x00000045100f7210ULL, 0x000fc40007fbe0ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078448ffULL,
0x000000103b067825ULL, 0x000fe200078e0006ULL, 0x000000101e407810ULL, 0x000fe40007ffe0ffULL,
0x00005f000d0d7a11ULL, 0x000fe200010f4c12ULL, 0x000000ffff107224ULL, 0x000fe200028e06ffULL,
0x0000004540117210ULL, 0x000fe40007f5e0ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078848ffULL,
0x000000103b0c7825ULL, 0x000fe200078e000cULL, 0x000000141e407810ULL, 0x000fc40007ffe0ffULL,
0x00005f000f0f7a11ULL, 0x000fe200020f4c10ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x0000003a1300720cULL, 0x000fe40003f86070ULL, 0x00005e0011107a11ULL, 0x000fe400078c48ffULL,
0x0000000713137812ULL, 0x000fe400078e4820ULL, 0x00005f0011117a11ULL, 0x000fe400030f4c12ULL,
0x0ffffff813127812ULL, 0x000fc400078ef820ULL, 0x0000004540137210ULL, 0x080fe40007fde0ffULL,
0x000000181e407810ULL, 0x000fe20007ffe0ffULL, 0x00000010123d7824ULL, 0x000fe200078e0229ULL,
0x0000003a1d00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0000001c1e1e7810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000043d7faeULL, 0x0003e2000e101c46ULL, 0x00000045401d7210ULL, 0x000fe40007f9e0ffULL,
0x00005e0013127a11ULL, 0x000fe200078c48ffULL, 0x00000000063f7faeULL, 0x0005e2000d901c46ULL,
0x0000003a1f00720cULL, 0x000fc40003f46070ULL, 0x000000451e1f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005f0013137a11ULL, 0x000fe200030f4c1cULL,
0x000000000c417faeULL, 0x0007e2000e901c46ULL, 0x00005e001d1c7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x0000003a4300720cULL, 0x080fe20003f86070ULL,
0x000000103b047825ULL, 0x002fe200078e000eULL, 0x00005f001d1d7a11ULL, 0x000fe400030f4c1eULL,
0x00005e001f1e7a11ULL, 0x000fe200078648ffULL, 0x000000103b067825ULL, 0x004fe200078e0010ULL,
0x0000003a4700720cULL, 0x000fc40003fc6070ULL, 0x0000003a4900720cULL, 0x080fe20003fa6070ULL,
0x000000103b107825ULL, 0x000fe200078e001cULL, 0x00005f001f1f7a11ULL, 0x000fe400018f4c3cULL,
0x0000003a4b00720cULL, 0x000fe20003f66070ULL, 0x000000103b0e7825ULL, 0x000fc800078e0012ULL,
0x000000103e1d7824ULL, 0x000fe400078e0229ULL, 0x000000103b127825ULL, 0x000fc600078e001eULL,
0x00000000041d7faeULL, 0x0003e2000d101c46ULL, 0x00000010420d7824ULL, 0x108fe400078e0229ULL,
0x00000010441f7824ULL, 0x100fe400078e0229ULL, 0x00000010463b7824ULL, 0x100fe200078e0229ULL,
0x00000000060d7faeULL, 0x0003e2000e101c46ULL, 0x00000010483d7824ULL, 0x000fc600078e0229ULL,
0x000000000e1f7faeULL, 0x0003e8000f101c46ULL, 0x00000000103b7faeULL, 0x0003e8000e901c46ULL,
0x00000000123d7faeULL, 0x0003e2000d901c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x00000003ff0d7819ULL, 0x000fe20000011620ULL, 0x00000001383b7824ULL, 0x000fc600078e0231ULL,
0x000000040d057810ULL, 0x040fe20007ffe0ffULL, 0x0000004000107824ULL, 0x000fe200078e020dULL,
0x000000080d077810ULL, 0x040fe40007ffe0ffULL, 0x0000000c0d0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000805137824ULL, 0x000fe200078e00ffULL, 0x000000100d117810ULL, 0x000fe20007ffe0ffULL,
0x00000008073c7824ULL, 0x000fe200078e00ffULL, 0x0000002005047212ULL, 0x080fe400078e3cffULL,
0x000000200f067212ULL, 0x0c0fe200078e3cffULL, 0x000000080f0f7824ULL, 0x000fe200078e00ffULL,
0x0000002007057212ULL, 0x080fe200078e3cffULL, 0x0000000811427824ULL, 0x040fe200078e00ffULL,
0x0000002011077212ULL, 0x000fc400078e3cffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee205ULL,
0xfffffff80f3e7812ULL, 0x000fe400078ee206ULL, 0xfffffff842427812ULL, 0x000fe200078ee207ULL,
0x000000103c417824ULL, 0x000fe200078e0229ULL, 0x000000140d057810ULL, 0x040fe40007ffe0ffULL,
0x000000180d077810ULL, 0x040fe40007ffe0ffULL, 0x0000001c0d0f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8133a7812ULL, 0x000fe200078ee204ULL, 0x0000000807117824ULL, 0x000fe200078e00ffULL,
0x0000002005047212ULL, 0x0c0fe200078e3cffULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0x0000002007067212ULL, 0x080fe200078e3cffULL, 0x000000080f4e7824ULL, 0x040fe200078e00ffULL,
0x000000200f077212ULL, 0x000fe200078e3cffULL, 0x000000103a3f7824ULL, 0x000fe200078e0229ULL,
0x00000004100c7810ULL, 0x040fe40007ffe0ffULL, 0x00000008100e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c10127810ULL, 0x000fe40007ffe0ffULL, 0xfffffff805467812ULL, 0x000fe400078ee204ULL,
0xfffffff84e4e7812ULL, 0x000fe400078ee207ULL, 0x0000004510057210ULL, 0x080fe40007f5e0ffULL,
0x000000450c077210ULL, 0x080fe20007f7e0ffULL, 0x000000104e477824ULL, 0x000fe200078e0229ULL,
0x000000450e0f7210ULL, 0x000fc40007f9e0ffULL, 0x0000004512137210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0xfffffff8114a7812ULL, 0x000fe200078ee206ULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078448ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x00005e000f0c7a11ULL, 0x000fe200078648ffULL,
0x000000ffff1e7224ULL, 0x000fe200028e06ffULL, 0x00005e00130e7a11ULL, 0x000fe200078848ffULL,
0x000000104a437824ULL, 0x000fe200078e0229ULL, 0x000000070d117812ULL, 0x000fc400078e4820ULL,
0x00005f0005057a11ULL, 0x000fe400010f4c06ULL, 0x00005f000f0d7a11ULL, 0x000fe400018f4c1cULL,
0x00005e0007067a11ULL, 0x000fe200078448ffULL, 0x000000103b047825ULL, 0x000fe200078e0004ULL,
0x00005f00130f7a11ULL, 0x000fe400020f4c1eULL, 0x00000010101c7810ULL, 0x040fe20007ffe0ffULL,
0x000000103b0c7825ULL, 0x000fe200078e000cULL, 0x00000014101e7810ULL, 0x000fc40007ffe0ffULL,
0x0000001810407810ULL, 0x040fe20007ffe0ffULL, 0x000000103b0e7825ULL, 0x000fe200078e000eULL,
0x0000001c10107810ULL, 0x000fe40007ffe0ffULL, 0x00005f0007077a11ULL, 0x000fe400010f4c12ULL,
0x0ffffff811127812ULL, 0x000fe400078ef820ULL, 0x000000451c117210ULL, 0x080fe20007f9e0ffULL,
0x000000103b067825ULL, 0x000fe200078e0006ULL, 0x000000451e137210ULL, 0x000fc40007fbe0ffULL,
0x00000045401d7210ULL, 0x080fe20007f5e0ffULL, 0x00000010123d7824ULL, 0x000fe200078e0229ULL,
0x00000045101f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078848ffULL, 0x000000ffff447224ULL, 0x000fe200028e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078a48ffULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000043d7faeULL, 0x0003e2000b901c46ULL, 0x00005f0011117a11ULL, 0x000fc400020f4c40ULL,
0x00005f0013137a11ULL, 0x000fe200028f4c44ULL, 0x00000000063f7faeULL, 0x0005e2000b901c46ULL,
0x00005f001d1d7a11ULL, 0x000fe200010f4c48ULL, 0x000000103b107825ULL, 0x000fe200078e0010ULL,
0x00005f001f1f7a11ULL, 0x000fe200018f4c4cULL, 0x000000000c417faeULL, 0x0005e4000b901c46ULL,
0x000000103b127825ULL, 0x000fc800078e0012ULL, 0x000000103b1c7825ULL, 0x000fc800078e001cULL,
0x000000103b1e7825ULL, 0x000fc800078e001eULL, 0x000000103e057824ULL, 0x102fe400078e0229ULL,
0x00000010423b7824ULL, 0x100fe400078e0229ULL, 0x00000010463d7824ULL, 0x000fe200078e0229ULL,
0x000000000e057faeULL, 0x0005e8000b901c46ULL, 0x00000000103b7faeULL, 0x0005e8000b901c46ULL,
0x00000000123d7faeULL, 0x0005e8000b901c46ULL, 0x000000001c437faeULL, 0x0005e8000b901c46ULL,
0x000000001e477faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000420047811ULL, 0x002fc400078fe0ffULL, 0x00001000293b7810ULL, 0x004fe40007ffe0ffULL,
0x0000000704047812ULL, 0x000fe400078e786dULL, 0x00000006200c7811ULL, 0x000fe200078fe0ffULL,
0x000000106e3f7824ULL, 0x000fe200078e023bULL, 0x00000002ff477819ULL, 0x000fe20000011620ULL,
0x000000086d3a7824ULL, 0x000fe200078e0204ULL, 0x000000070c0c7812ULL, 0x000fe200078e786dULL,
0x00000010723c7824ULL, 0x100fe400078e023bULL, 0x00000010703e7824ULL, 0x100fe200078e023bULL,
0x000120003a047811ULL, 0x000fe200078e20ffULL, 0x000000106c407824ULL, 0x000fc400078e023bULL,
0x000000086d3d7824ULL, 0x000fe200078e020cULL, 0x00000032ff0c723eULL, 0x000fe200000010ffULL,
0x0000001074437824ULL, 0x100fe400078e023bULL, 0x000000107a417824ULL, 0x000fe200078e023bULL,
0x000054100c757816ULL, 0x000fe2000000000cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000404783bULL, 0x000fe20000000200ULL, 0x000120003d487811ULL, 0x000fe200078e20ffULL,
0x000000107c427824ULL, 0x100fe400078e023bULL, 0x000000003f50783bULL, 0x000fe20000004200ULL,
0x0000001076447824ULL, 0x000fc600078e023bULL, 0x000000003c70783bULL, 0x000fe80000004200ULL,
0x000000003e6c783bULL, 0x000fe80000004200ULL, 0x000000004054783bULL, 0x000fe80000004200ULL,
0x00001f4775477589ULL, 0x000e6800000e0000ULL, 0x00001f3075467589ULL, 0x000ea800000e0000ULL,
0x000000004848783bULL, 0x000ee80000000200ULL, 0x00000000431c783bULL, 0x000f280000004200ULL,
0x00000000410c783bULL, 0x000f680000004200ULL, 0x000000004210783bULL, 0x000f280000004200ULL,
0x00000000444c783bULL, 0x000f220000004200ULL, 0x0000004704049231ULL, 0x002fc400003400ffULL,
0x0000004706069231ULL, 0x000fe400003400ffULL, 0x0000004605059231ULL, 0x084fe400003400ffULL,
0x0000004607079231ULL, 0x000fce00003400ffULL, 0x00000050045c723cULL, 0x040ff0000004185cULL,
0x000000520418723cULL, 0x000fe20000041818ULL, 0x0000004748489231ULL, 0x088fe400003400ffULL,
0x000000474a4a9231ULL, 0x000fc400003400ffULL, 0x0000004649499231ULL, 0x000fc600003400ffULL,
0x000000700458723cULL, 0x000fe20000041858ULL, 0x000000464b4b9231ULL, 0x000fce00003400ffULL,
0x0000006c0460723cULL, 0x040ff00000041860ULL, 0x000000540450723cULL, 0x040ff00000041814ULL,
0x000000720464723cULL, 0x040ff00000041864ULL, 0x0000006e0468723cULL, 0x040ff00000041868ULL,
0x000000560454723cULL, 0x000ff00000041808ULL, 0x0000001c4814723cULL, 0x050ff0000004185cULL,
0x0000000c4804723cULL, 0x060ff00000041858ULL, 0x000000104808723cULL, 0x040ff00000041860ULL,
0x0000001e481c723cULL, 0x040ff00000041818ULL, 0x0000000e480c723cULL, 0x040ff00000041864ULL,
0x000000124810723cULL, 0x040ff00000041868ULL, 0x0000004c4818723cULL, 0x040ff00000041850ULL,
0x0000004e4854723cULL, 0x000fe20000041854ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000402f467811ULL, 0x000fe200078e40ffULL, 0x01c68800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000002b4600720cULL, 0x000fda0003f26070ULL, 0x0000781000001947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000003ff4c7819ULL, 0x000fe20000011620ULL, 0x00000001385b7824ULL, 0x000fe200078e0231ULL,
0x00000020004d7811ULL, 0x000fe400078e30ffULL, 0x000000602f487811ULL, 0x000fe400078e40ffULL,
0x000000044c4e7810ULL, 0x040fe20007ffe0ffULL, 0x000000014c467824ULL, 0x000fe200078e024dULL,
0x000000482b377217ULL, 0x000fe40007800000ULL, 0x000000204e497212ULL, 0x040fe200078e3cffULL,
0x000000084e507824ULL, 0x000fe200078e00ffULL, 0x0000004546477210ULL, 0x000fe20007f3e0ffULL,
0x0000000137377824ULL, 0x000fe200078e0a48ULL, 0x000000084c527810ULL, 0x000fc40007ffe0ffULL,
0xfffffff850507812ULL, 0x000fe200078ee249ULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0x00005e0047467a11ULL, 0x040fe200078248ffULL, 0x00000008525c7824ULL, 0x000fe200078e00ffULL,
0x000000074c497812ULL, 0x000fe400078e4820ULL, 0x00005f0047477a11ULL, 0x000fe200008f4c4aULL,
0x000000014e4a7824ULL, 0x000fe200078e024dULL, 0x0000002037377817ULL, 0x000fe40003800000ULL,
0x0ffffff849487812ULL, 0x000fe200078ef820ULL, 0x000000105b467825ULL, 0x000fe200078e0046ULL,
0x00000020524b7212ULL, 0x000fc400078e3cffULL, 0x000000454a497210ULL, 0x000fe40007f5e0ffULL,
0x000000374c00720cULL, 0x000fe40003f26070ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee24bULL,
0x00000010484b7824ULL, 0x000fe200078e023bULL, 0x0000000c4c587810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fe200010e06ffULL, 0x000000104c5a7810ULL, 0x040fe40007ffe0ffULL,
0x000000144c647810ULL, 0x000fe20007ffe0ffULL, 0x00000008585e7824ULL, 0x000fe200078e00ffULL,
0x000000184c6a7810ULL, 0x000fe20007ffe0ffULL, 0x000000085a627824ULL, 0x000fe200078e00ffULL,
0x0000001c4c6e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001524c7824ULL, 0x100fe200078e024dULL,
0x00005e0049487a11ULL, 0x040fe200078448ffULL, 0x0000000864687824ULL, 0x000fe200078e00ffULL,
0x00000020584f7212ULL, 0x080fe200078e3cffULL, 0x000000015a607824ULL, 0x100fe200078e024dULL,
0x00005f0049497a11ULL, 0x000fe200010f4c4aULL, 0x00000001584a7824ULL, 0x100fe200078e024dULL,
0x000000454c4c7210ULL, 0x080fe20007f5e0ffULL, 0x0000000164667824ULL, 0x100fe200078e024dULL,
0x000000205a517212ULL, 0x080fe200078e3cffULL, 0x000000016a6c7824ULL, 0x100fe200078e024dULL,
0x0000002064537212ULL, 0x000fe200078e3cffULL, 0x000000016e707824ULL, 0x000fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000464b7faeULL, 0x0003e2000c901c46ULL,
0x000000454a4d7210ULL, 0x000fc40007f7e0ffULL, 0xfffffff85e5e7812ULL, 0x000fe400078ee24fULL,
0x00005e004c4a7a11ULL, 0x000fe400078c48ffULL, 0xfffffff862627812ULL, 0x000fe400078ee251ULL,
0xfffffff868687812ULL, 0x000fe400078ee253ULL, 0x00000045604f7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff477224ULL, 0x002fe200010e06ffULL, 0x0000004566517210ULL, 0x080fe20007f9e0ffULL,
0x000000086a607824ULL, 0x000fe200078e00ffULL, 0x000000456c537210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x0000004570597210ULL, 0x000fe20007f5e0ffULL,
0x000000086e667824ULL, 0x000fe200078e00ffULL, 0x000000206a457212ULL, 0x000fc400078e3cffULL,
0x00005f004c4b7a11ULL, 0x000fe400030f4c47ULL, 0x00005e004d4c7a11ULL, 0x040fe400078c48ffULL,
0x000000374e00720cULL, 0x000fe40003f66070ULL, 0xfffffff860607812ULL, 0x000fe200078ee245ULL,
0x0000001050457824ULL, 0x000fe200078e023bULL, 0x000000206e477212ULL, 0x000fe200078e3cffULL,
0x000000ffff507224ULL, 0x000fe200008e06ffULL, 0x00005f004d4d7a11ULL, 0x000fc400030f4c46ULL,
0x00005e004f4e7a11ULL, 0x000fe400078c48ffULL, 0xfffffff866667812ULL, 0x000fe200078ee247ULL,
0x000000105b467825ULL, 0x000fe200078e0048ULL, 0x00005f004f4f7a11ULL, 0x000fe400030f4c50ULL,
0x00005e0051507a11ULL, 0x040fe200078c48ffULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x000000375a00720cULL, 0x080fe20003f86070ULL, 0x0000000046457faeULL, 0x0003e2000d901c46ULL,
0x000000375200720cULL, 0x080fe20003f26070ULL, 0x000000ffff5a7224ULL, 0x000fe200028e06ffULL,
0x00005f0051517a11ULL, 0x000fe200030f4c48ULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x000000375800720cULL, 0x000fe20003f66070ULL, 0x00000010665d7824ULL, 0x000fe200078e023bULL,
0x00005e0053527a11ULL, 0x000fc400078a48ffULL, 0x00005e0059587a11ULL, 0x000fe400078c48ffULL,
0x000000376400720cULL, 0x080fe20003f46070ULL, 0x000000105b467825ULL, 0x002fe200078e004aULL,
0x00005f0053537a11ULL, 0x000fe400028f4c5aULL, 0x000000376a00720cULL, 0x080fe20003fa6070ULL,
0x000000105b4a7825ULL, 0x000fe200078e004eULL, 0x00005f0059597a11ULL, 0x000fe400030f4c48ULL,
0x000000376e00720cULL, 0x000fe20003fc6070ULL, 0x000000105c377824ULL, 0x000fc400078e023bULL,
0x000000105b487825ULL, 0x000fc600078e004cULL, 0x0000000046377faeULL, 0x0003e2000c901c46ULL,
0x000000105b4c7825ULL, 0x000fc800078e0050ULL, 0x000000105b4e7825ULL, 0x000fc800078e0052ULL,
0x000000105e457824ULL, 0x000fe400078e023bULL, 0x000000105b507825ULL, 0x000fc600078e0058ULL,
0x0000000048457faeULL, 0x0003e2000d901c46ULL, 0x0000001062537824ULL, 0x100fe400078e023bULL,
0x0000001068597824ULL, 0x100fe400078e023bULL, 0x00000010605b7824ULL, 0x000fe200078e023bULL,
0x000000004a537faeULL, 0x0003e8000e101c46ULL, 0x000000004c597faeULL, 0x0003e8000d101c46ULL,
0x000000004e5b7faeULL, 0x0003e8000e901c46ULL, 0x00000000505d7faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff377819ULL, 0x000fe40000011620ULL,
0x00000020004a7811ULL, 0x000fc400078e30ffULL, 0x0000000437497810ULL, 0x040fe40007ffe0ffULL,
0x00000008374b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002049467212ULL, 0x0c0fe200078e3cffULL,
0x00000008494f7824ULL, 0x000fe200078e00ffULL, 0x000000204b477212ULL, 0x0c0fe200078e3cffULL,
0x000000084b5c7824ULL, 0x000fe200078e00ffULL, 0x0000000c374d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84f5a7812ULL, 0x000fe200078ee246ULL, 0x0000000137467824ULL, 0x000fe200078e024aULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee247ULL, 0x000000084d517824ULL, 0x040fe200078e00ffULL,
0x000000204d487212ULL, 0x000fc400078e3cffULL, 0x0000004546477210ULL, 0x080fe20007f3e0ffULL,
0x0000000149467824ULL, 0x000fe200078e024aULL, 0x00000010374f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8515e7812ULL, 0x000fe200078ee248ULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x0000004546497210ULL, 0x000fe20007f5e0ffULL, 0x000000084f537824ULL, 0x000fe200078e00ffULL,
0x00005e0047467a11ULL, 0x000fe400078248ffULL, 0x0000001437517810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200010e06ffULL, 0x000000204f507212ULL, 0x000fc400078e3cffULL,
0x00005f0047477a11ULL, 0x000fe200008f4c4cULL, 0x000000014b4c7824ULL, 0x000fe200078e024aULL,
0x00005e0049487a11ULL, 0x000fe200078448ffULL, 0x0000000851597824ULL, 0x040fe200078e00ffULL,
0x0000002051527212ULL, 0x000fe400078e3cffULL, 0xfffffff853627812ULL, 0x000fe200078ee250ULL,
0x000000014f507824ULL, 0x000fe200078e024aULL, 0x00005f0049497a11ULL, 0x000fe200010f4c4eULL,
0x000000014d4e7824ULL, 0x000fe200078e024aULL, 0x0000001837537810ULL, 0x000fc40007ffe0ffULL,
0x0000001c375b7810ULL, 0x000fe40007ffe0ffULL, 0x000000454c4c7210ULL, 0x080fe20007f7e0ffULL,
0x0000000153587824ULL, 0x000fe200078e024aULL, 0xfffffff859667812ULL, 0x000fe200078ee252ULL,
0x0000000151527824ULL, 0x100fe200078e024aULL, 0x000000454e4d7210ULL, 0x080fe20007f5e0ffULL,
0x000000015b607824ULL, 0x000fe200078e024aULL, 0x00005e004c4a7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x0000000737377812ULL, 0x000fe200078e4820ULL,
0x00000008536a7824ULL, 0x000fe200078e00ffULL, 0x0000004552517210ULL, 0x000fc40007f7e0ffULL,
0x000000205b527212ULL, 0x0c0fe200078e3cffULL, 0x000000085b5b7824ULL, 0x000fe200078e00ffULL,
0x00000045504f7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff507224ULL, 0x000fe200010e06ffULL,
0x0000004558597210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff647224ULL, 0x000fe200018e06ffULL,
0x00000045605d7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff607224ULL, 0x000fe200008e06ffULL,
0x00005f004c4b7a11ULL, 0x000fe200030f4c4bULL, 0x000000ffff687224ULL, 0x000fe200020e06ffULL,
0x0000002053457212ULL, 0x000fe200078e3cffULL, 0x000000ffff6c7224ULL, 0x000fe200028e06ffULL,
0x0ffffff8374e7812ULL, 0x000fe200078ef820ULL, 0x0000000138377824ULL, 0x000fe200078e0231ULL,
0x00005e004d4c7a11ULL, 0x000fc400078448ffULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee245ULL,
0x000000104e457824ULL, 0x000fe200078e023bULL, 0xfffffff85b6e7812ULL, 0x000fe200078ee252ULL,
0x0000001037467825ULL, 0x000fe200078e0046ULL, 0x00005f004d4d7a11ULL, 0x000fe400010f4c50ULL,
0x00005e0059527a11ULL, 0x000fe200078648ffULL, 0x000000105a5b7824ULL, 0x000fe200078e023bULL,
0x00005e004f4e7a11ULL, 0x000fe200078248ffULL, 0x0000001037487825ULL, 0x000fe200078e0048ULL,
0x00005e0051507a11ULL, 0x000fe200078448ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046457faeULL, 0x0003e2000b901c46ULL, 0x00005e005d587a11ULL, 0x000fe200078848ffULL,
0x00000010374a7825ULL, 0x000fe200078e004aULL, 0x00005f0059537a11ULL, 0x000fe200018f4c68ULL,
0x00000000485b7faeULL, 0x0005e2000b901c46ULL, 0x00005f004f4f7a11ULL, 0x000fe200008f4c60ULL,
0x00000010374c7825ULL, 0x000fe200078e004cULL, 0x00005f0051517a11ULL, 0x000fc400010f4c64ULL,
0x00005f005d597a11ULL, 0x000fe200020f4c6cULL, 0x000000105c5d7824ULL, 0x000fe400078e023bULL,
0x00000010374e7825ULL, 0x000fc600078e004eULL, 0x000000004a5d7faeULL, 0x0005e2000b901c46ULL,
0x0000001037507825ULL, 0x000fc800078e0050ULL, 0x0000001037527825ULL, 0x000fc800078e0052ULL,
0x0000001037587825ULL, 0x000fc800078e0058ULL, 0x000000105e377824ULL, 0x100fe400078e023bULL,
0x0000001062457824ULL, 0x102fe400078e023bULL, 0x0000001066477824ULL, 0x100fe200078e023bULL,
0x000000004c377faeULL, 0x0005e2000b901c46ULL, 0x000000106a5f7824ULL, 0x100fe400078e023bULL,
0x000000106e617824ULL, 0x000fe200078e023bULL, 0x000000004e457faeULL, 0x0005e8000b901c46ULL,
0x0000000050477faeULL, 0x0005e8000b901c46ULL, 0x00000000525f7faeULL, 0x0005e8000b901c46ULL,
0x0000000058617faeULL, 0x0005e4000b901c46ULL, 0x00000300ff377624ULL, 0x006fe200078e00ffULL,
0x0000000339457812ULL, 0x000fc800078ec0ffULL, 0x000000034500780cULL, 0x000fe40003f25270ULL,
0xfffffffd37377811ULL, 0x000fc800078e10ffULL, 0x0000000137467807ULL, 0x000fe20004800000ULL,
0xffffffffff377424ULL, 0x000fc800078e00ffULL, 0x0000000139397824ULL, 0x000fca00078e0246ULL,
0x000000783900720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000139467824ULL, 0x000fe400078e0234ULL, 0x00000004ff477424ULL, 0x000fc800078e00ffULL,
0x0000600046467625ULL, 0x000fca00078e0047ULL, 0x0000000646377981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6280038467f8cULL, 0x002fe8000c80043fULL, 0x01c62c0038457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe40007824847ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff457424ULL, 0x000fc800078e00ffULL, 0x0000004500487305ULL, 0x0002a4000021f000ULL,
0x3fa0000045457823ULL, 0x002fe200000100ffULL, 0x000000480000735dULL, 0x004fe20003800000ULL,
0x01c62c0038497984ULL, 0x000e640000000800ULL, 0x8000000049ff7812ULL, 0x002fc40007824847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c0800033457984ULL, 0x000e680000000800ULL,
0x01c2800033487984ULL, 0x0004e20000000800ULL, 0x000000364500720bULL, 0x002fe20003f3d000ULL,
0x00012d027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x004fc800008e0100ULL,
0x0000ffff464b7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff497424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000012d00780cULL, 0x000fe40003f25270ULL, 0x000000364500720bULL, 0x000fe20003f54000ULL,
0x00012ce27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x000fe400010e0100ULL,
0x0000004536477209ULL, 0x000fe40007810000ULL, 0x0000ffff46467812ULL, 0x000fe400078e3cffULL,
0x00000002ff4c7819ULL, 0x000fe20000011620ULL, 0x8000004736497221ULL, 0x000fe20000010000ULL,
0x01c4804733009388ULL, 0x0003e20000000800ULL, 0x000000464bff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b49497820ULL, 0x000fcc0000410000ULL, 0x0000004900497308ULL, 0x000ea40000000800ULL,
0x0000004935357220ULL, 0x004fe20000410000ULL, 0x00012c927f007947ULL, 0x000fea000b800000ULL,
0x00001f4c49467589ULL, 0x0022a400000e0000ULL, 0x0000004604047220ULL, 0x084fe40000410000ULL,
0x0000004605057220ULL, 0x080fe40000410000ULL, 0x000000460c0c7220ULL, 0x080fe40000410000ULL,
0x000000460d0d7220ULL, 0x080fe40000410000ULL, 0x0000004608087220ULL, 0x000fc40000410000ULL,
0x0000004609097220ULL, 0x080fe40000410000ULL, 0x0000004610107220ULL, 0x080fe40000410000ULL,
0x0000004611117220ULL, 0x080fe40000410000ULL, 0x0000004614147220ULL, 0x080fe40000410000ULL,
0x0000004615157220ULL, 0x080fe40000410000ULL, 0x000000461c1c7220ULL, 0x000fc40000410000ULL,
0x000000461d1d7220ULL, 0x080fe40000410000ULL, 0x0000004618187220ULL, 0x080fe40000410000ULL,
0x0000004619197220ULL, 0x080fe40000410000ULL, 0x0000004654547220ULL, 0x080fe40000410000ULL,
0x0000004655557220ULL, 0x000fe20000410000ULL, 0x00012be27f007947ULL, 0x000fea000b800000ULL,
0x00001f3049467589ULL, 0x00052400000e0000ULL, 0x0000004536367209ULL, 0x000fe20007810000ULL,
0x0000004606067220ULL, 0x090fe20000410000ULL, 0x00000001ff497807ULL, 0x006fe20000800000ULL,
0x0000004607077220ULL, 0x000fc40000410000ULL, 0x8000003645451221ULL, 0x000fe40000010000ULL,
0x000000460e0e7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b45451820ULL, 0x000fe40000410000ULL,
0x000000460f0f7220ULL, 0x080fe40000410000ULL, 0x0000004500321308ULL, 0x000e620000000800ULL,
0x000000460a0a7220ULL, 0x080fe40000410000ULL, 0x000000460b0b7220ULL, 0x000fc40000410000ULL,
0x0000004612127220ULL, 0x080fe40000410000ULL, 0x0000004613137220ULL, 0x080fe40000410000ULL,
0x0000004616167220ULL, 0x080fe40000410000ULL, 0x0000004617177220ULL, 0x080fe40000410000ULL,
0x000000461e1e7220ULL, 0x080fe40000410000ULL, 0x000000461f1f7220ULL, 0x000fc40000410000ULL,
0x000000461a1a7220ULL, 0x080fe40000410000ULL, 0x000000461b1b7220ULL, 0x080fe40000410000ULL,
0x0000004656567220ULL, 0x080fe40000410000ULL, 0x0000004657577220ULL, 0x000fe40000410000ULL,
0x0000004832481220ULL, 0x00afe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000032ff45723eULL, 0x000fe200000010ffULL, 0x0000003548357221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff4c7819ULL, 0x000fe40000011620ULL,
0x00005410454b7816ULL, 0x000fe20000000045ULL, 0x00012a827f007947ULL, 0x000fea000b800000ULL,
0x00001f4c4b457589ULL, 0x0002a800000e0000ULL, 0x00001f304b7a7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002eULL,
0x0000570000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x000136a000007944ULL, 0x02cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002cULL,
0x0000576000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x0001364000007944ULL, 0x02cfea0003c00000ULL,
0x000128002a607811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002874783bULL, 0x000fe20000004200ULL, 0x0001280024487811ULL, 0x000fe400078e20ffULL,
0x0000991049467816ULL, 0x000fe200000000ffULL, 0x000000006060783bULL, 0x000f260000000200ULL,
0x000000ff4600720cULL, 0x000fe20003f25270ULL, 0x00000000266c783bULL, 0x000fe80000004200ULL,
0x000000002770783bULL, 0x000fe80000004200ULL, 0x000000002564783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x006e680000000200ULL, 0x00000000235c783bULL, 0x000ea80000004200ULL,
0x000000002258783bULL, 0x000ee80000004200ULL, 0x000000002150783bULL, 0x000ea80000004200ULL,
0x00000000034c783bULL, 0x000ea20000004200ULL, 0x0000004560609231ULL, 0x010fc400003400ffULL,
0x0000004562629231ULL, 0x000fe400003400ffULL, 0x0000007a61619231ULL, 0x088fe400003400ffULL,
0x0000007a63639231ULL, 0x000fce00003400ffULL, 0x000000746068723cULL, 0x000fe20000041804ULL,
0x0000004548489231ULL, 0x082fe400003400ffULL, 0x000000454a4a9231ULL, 0x000fe200003400ffULL,
0x0000580037457a24ULL, 0x020fe200078e02ffULL, 0x0000007a49499231ULL, 0x000fc600003400ffULL,
0x00000076600c723cULL, 0x000fe2000004180cULL, 0x0000007a4b4b9231ULL, 0x000fe200003400ffULL,
0x0000004045457824ULL, 0x000fcc00078e00ffULL, 0x0000006c6004723cULL, 0x040ff00000041814ULL,
0x0000006e601c723cULL, 0x040ff0000004181cULL, 0x000000706008723cULL, 0x040ff00000041808ULL,
0x000000726010723cULL, 0x040ff00000041810ULL, 0x00000064606c723cULL, 0x040ff00000041818ULL,
0x000000666060723cULL, 0x000ff00000041854ULL, 0x0000005e4854723cULL, 0x044ff0000004180cULL,
0x0000005c4814723cULL, 0x040ff00000041868ULL, 0x000000584818723cULL, 0x040ff00000041808ULL,
0x00000050480c723cULL, 0x040ff00000041804ULL, 0x0000005a4858723cULL, 0x040ff00000041810ULL,
0x000000524808723cULL, 0x040ff0000004181cULL, 0x0000004c4804723cULL, 0x040ff0000004186cULL,
0x0000004e485c723cULL, 0x000fe20000041860ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x00000003ff497819ULL, 0x000fe20000011620ULL,
0x00000001384f7824ULL, 0x000fe200078e0231ULL, 0x000000802f107811ULL, 0x000fe400078e40ffULL,
0x00000004491f7810ULL, 0x040fe20007ffe0ffULL, 0x00000040004c7824ULL, 0x000fe200078e0249ULL,
0x00000008494b7810ULL, 0x000fe40007ffe0ffULL, 0x000000102b117217ULL, 0x000fe20007800000ULL,
0x000000081f4a7824ULL, 0x000fe200078e00ffULL, 0x0000001049637810ULL, 0x000fe20007ffe0ffULL,
0x000000084b1d7824ULL, 0x000fe200078e00ffULL, 0x0000001449657810ULL, 0x000fe20007ffe0ffULL,
0x0000000111127824ULL, 0x000fe200078e0a10ULL, 0x000000201f137212ULL, 0x080fe200078e3cffULL,
0x0000000863627824ULL, 0x000fe200078e00ffULL, 0x000000204b1c7212ULL, 0x000fe200078e3cffULL,
0x0000000865647824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fc400078ee213ULL,
0x0000000c494d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002063117212ULL, 0x080fe200078e3cffULL,
0x000000104a537824ULL, 0x000fe200078e0229ULL, 0x0000001849677810ULL, 0x000fe40007ffe0ffULL,
0x0000002065137212ULL, 0x000fe400078e3cffULL, 0xfffffff81d507812ULL, 0x000fe200078ee21cULL,
0x000000084d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ee211ULL,
0x0000000867667824ULL, 0x000fe200078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee213ULL,
0x0000001050617824ULL, 0x000fe200078e0229ULL, 0x0000001c49697810ULL, 0x000fc40007ffe0ffULL,
0x000000454c117210ULL, 0x040fe40007f5e0ffULL, 0x000000204d107212ULL, 0x080fe200078e3cffULL,
0x0000000869687824ULL, 0x000fe200078e00ffULL, 0x0000002067137212ULL, 0x000fe200078e3cffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x000000044c1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81d527812ULL, 0x000fe400078ee210ULL, 0xfffffff866667812ULL, 0x000fc400078ee213ULL,
0x00000020691d7212ULL, 0x000fe400078e3cffULL, 0x00005e0011107a11ULL, 0x040fe400078448ffULL,
0x000000451e137210ULL, 0x000fe40007f7e0ffULL, 0x000000084c1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff868687812ULL, 0x000fe400078ee21dULL, 0x00005f0011117a11ULL, 0x000fe200010f4c1cULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00000020124e7817ULL, 0x000fc40003800000ULL,
0x000000451e1d7210ULL, 0x080fe20007f9e0ffULL, 0x000000104f107825ULL, 0x000fe200078e0010ULL,
0x00005e0013127a11ULL, 0x000fe400078448ffULL, 0x0000000c4c467810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x0000004e1f00720cULL, 0x000fe40003f66070ULL,
0x00005f0013137a11ULL, 0x000fe400010f4c1cULL, 0x00000045461f7210ULL, 0x000fc40007fbe0ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078448ffULL, 0x000000104f127825ULL, 0x000fe200078e0012ULL,
0x000000104c607810ULL, 0x000fe40007ffe0ffULL, 0x00005f001d1d7a11ULL, 0x000fe200010f4c48ULL,
0x000000ffff467224ULL, 0x000fe200028e06ffULL, 0x0000004560477210ULL, 0x000fe40007f5e0ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078848ffULL, 0x000000104f1c7825ULL, 0x000fe200078e001cULL,
0x000000144c607810ULL, 0x000fc40007ffe0ffULL, 0x00005f001f1f7a11ULL, 0x000fe200020f4c46ULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x0000004e4900720cULL, 0x000fe40003f86070ULL,
0x00005e0047467a11ULL, 0x000fe400078c48ffULL, 0x0000000749497812ULL, 0x000fe400078e4820ULL,
0x00005f0047477a11ULL, 0x000fe400030f4c48ULL, 0x0ffffff849487812ULL, 0x000fc400078ef820ULL,
0x0000004560497210ULL, 0x080fe40007fde0ffULL, 0x000000184c607810ULL, 0x000fe20007ffe0ffULL,
0x0000001048517824ULL, 0x000fe200078e0229ULL, 0x0000004e4b00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x0000001c4c4c7810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010517faeULL, 0x0003e2000e101c46ULL,
0x00000045604b7210ULL, 0x000fe40007f9e0ffULL, 0x00005e0049487a11ULL, 0x000fe200078c48ffULL,
0x0000000012537faeULL, 0x0005e2000d901c46ULL, 0x0000004e4d00720cULL, 0x000fc40003f46070ULL,
0x000000454c4d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005f0049497a11ULL, 0x000fe200030f4c4aULL, 0x000000001c617faeULL, 0x0007e2000e901c46ULL,
0x00005e004b4a7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff507224ULL, 0x000fe200018e06ffULL,
0x0000004e6300720cULL, 0x080fe20003f86070ULL, 0x000000104f107825ULL, 0x002fe200078e001eULL,
0x00005f004b4b7a11ULL, 0x000fe400030f4c4cULL, 0x00005e004d4c7a11ULL, 0x000fe200078648ffULL,
0x000000104f127825ULL, 0x004fe200078e0046ULL, 0x0000004e6500720cULL, 0x000fc40003fc6070ULL,
0x0000004e6700720cULL, 0x080fe20003fa6070ULL, 0x000000104f467825ULL, 0x000fe200078e004aULL,
0x00005f004d4d7a11ULL, 0x000fe400018f4c50ULL, 0x0000004e6900720cULL, 0x000fe20003f66070ULL,
0x000000104f1e7825ULL, 0x000fc800078e0048ULL, 0x00000010524b7824ULL, 0x000fe400078e0229ULL,
0x000000104f487825ULL, 0x000fc600078e004cULL, 0x00000000104b7faeULL, 0x0003e2000d101c46ULL,
0x00000010621d7824ULL, 0x108fe400078e0229ULL, 0x00000010644d7824ULL, 0x100fe400078e0229ULL,
0x00000010664f7824ULL, 0x100fe200078e0229ULL, 0x00000000121d7faeULL, 0x0003e2000e101c46ULL,
0x0000001068517824ULL, 0x000fc600078e0229ULL, 0x000000001e4d7faeULL, 0x0003e8000f101c46ULL,
0x00000000464f7faeULL, 0x0003e8000e901c46ULL, 0x0000000048517faeULL, 0x0003e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x00000003ff1d7819ULL, 0x000fe20000011620ULL,
0x00000001384f7824ULL, 0x000fc600078e0231ULL, 0x000000041d117810ULL, 0x040fe20007ffe0ffULL,
0x0000004000467824ULL, 0x000fe200078e021dULL, 0x000000081d137810ULL, 0x040fe40007ffe0ffULL,
0x0000000c1d1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811497824ULL, 0x000fe200078e00ffULL,
0x000000101d477810ULL, 0x000fe20007ffe0ffULL, 0x0000000813507824ULL, 0x000fe200078e00ffULL,
0x0000002011107212ULL, 0x080fe400078e3cffULL, 0x000000201f127212ULL, 0x0c0fe200078e3cffULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x0000002013117212ULL, 0x080fe200078e3cffULL,
0x0000000847627824ULL, 0x040fe200078e00ffULL, 0x0000002047137212ULL, 0x000fc400078e3cffULL,
0xfffffff850507812ULL, 0x000fe400078ee211ULL, 0xfffffff81f527812ULL, 0x000fe400078ee212ULL,
0xfffffff862627812ULL, 0x000fe200078ee213ULL, 0x0000001050617824ULL, 0x000fe200078e0229ULL,
0x000000141d117810ULL, 0x040fe40007ffe0ffULL, 0x000000181d137810ULL, 0x040fe40007ffe0ffULL,
0x0000001c1d1f7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8494e7812ULL, 0x000fe200078ee210ULL,
0x0000000813477824ULL, 0x000fe200078e00ffULL, 0x0000002011107212ULL, 0x0c0fe200078e3cffULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x0000002013127212ULL, 0x080fe200078e3cffULL,
0x000000081f6e7824ULL, 0x040fe200078e00ffULL, 0x000000201f137212ULL, 0x000fe200078e3cffULL,
0x000000104e537824ULL, 0x000fe200078e0229ULL, 0x00000004461c7810ULL, 0x040fe40007ffe0ffULL,
0x00000008461e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c46487810ULL, 0x000fe40007ffe0ffULL,
0xfffffff811667812ULL, 0x000fe400078ee210ULL, 0xfffffff86e6e7812ULL, 0x000fe400078ee213ULL,
0x0000004546117210ULL, 0x080fe40007f5e0ffULL, 0x000000451c137210ULL, 0x080fe20007f7e0ffULL,
0x000000106e657824ULL, 0x000fe200078e0229ULL, 0x000000451e1f7210ULL, 0x000fc40007f9e0ffULL,
0x0000004548497210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0xfffffff8476a7812ULL, 0x000fe200078ee212ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005e001f1c7a11ULL, 0x000fe200078648ffULL, 0x000000ffff4c7224ULL, 0x000fe200028e06ffULL,
0x00005e00491e7a11ULL, 0x000fe200078848ffULL, 0x000000106a637824ULL, 0x000fe200078e0229ULL,
0x000000071d477812ULL, 0x000fc400078e4820ULL, 0x00005f0011117a11ULL, 0x000fe400010f4c12ULL,
0x00005f001f1d7a11ULL, 0x000fe400018f4c4aULL, 0x00005e0013127a11ULL, 0x000fe200078448ffULL,
0x000000104f107825ULL, 0x000fe200078e0010ULL, 0x00005f00491f7a11ULL, 0x000fe400020f4c4cULL,
0x00000010464a7810ULL, 0x040fe20007ffe0ffULL, 0x000000104f1c7825ULL, 0x000fe200078e001cULL,
0x00000014464c7810ULL, 0x000fc40007ffe0ffULL, 0x0000001846607810ULL, 0x040fe20007ffe0ffULL,
0x000000104f1e7825ULL, 0x000fe200078e001eULL, 0x0000001c46467810ULL, 0x000fe40007ffe0ffULL,
0x00005f0013137a11ULL, 0x000fe400010f4c48ULL, 0x0ffffff847487812ULL, 0x000fe400078ef820ULL,
0x000000454a477210ULL, 0x080fe20007f9e0ffULL, 0x000000104f127825ULL, 0x000fe200078e0012ULL,
0x000000454c497210ULL, 0x000fc40007fbe0ffULL, 0x00000045604b7210ULL, 0x080fe20007f5e0ffULL,
0x0000001048517824ULL, 0x000fe200078e0229ULL, 0x00000045464d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff607224ULL, 0x000fe200020e06ffULL, 0x00005e0047467a11ULL, 0x000fe200078848ffULL,
0x000000ffff647224ULL, 0x000fe200028e06ffULL, 0x00005e0049487a11ULL, 0x000fe200078a48ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x00005e004b4a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff6c7224ULL, 0x000fe200018e06ffULL, 0x00005e004d4c7a11ULL, 0x000fe200078648ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010517faeULL, 0x0003e2000b901c46ULL,
0x00005f0047477a11ULL, 0x000fc400020f4c60ULL, 0x00005f0049497a11ULL, 0x000fe200028f4c64ULL,
0x0000000012537faeULL, 0x0005e2000b901c46ULL, 0x00005f004b4b7a11ULL, 0x000fe200010f4c68ULL,
0x000000104f467825ULL, 0x000fe200078e0046ULL, 0x00005f004d4d7a11ULL, 0x000fe200018f4c6cULL,
0x000000001c617faeULL, 0x0005e4000b901c46ULL, 0x000000104f487825ULL, 0x000fc800078e0048ULL,
0x000000104f4a7825ULL, 0x000fc800078e004aULL, 0x000000104f4c7825ULL, 0x000fc800078e004cULL,
0x0000001052117824ULL, 0x102fe400078e0229ULL, 0x00000010624f7824ULL, 0x100fe400078e0229ULL,
0x0000001066517824ULL, 0x000fe200078e0229ULL, 0x000000001e117faeULL, 0x0005e8000b901c46ULL,
0x00000000464f7faeULL, 0x0005e8000b901c46ULL, 0x0000000048517faeULL, 0x0005e8000b901c46ULL,
0x000000004a637faeULL, 0x0005e8000b901c46ULL, 0x000000004c657faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000128003a607811ULL, 0x000fc400078e20ffULL,
0x00000032ff10723eULL, 0x002fe400000010ffULL, 0x00000002ff477819ULL, 0x004fe40000011620ULL,
0x0000541010687816ULL, 0x000fe40000000010ULL, 0x000128003d487811ULL, 0x000fc600078e20ffULL,
0x00001f4768477589ULL, 0x000fe800000e0000ULL, 0x00001f3068467589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006060783bULL, 0x000e680000000200ULL,
0x000000003c74783bULL, 0x000ea80000004200ULL, 0x000000003e70783bULL, 0x000fe80000004200ULL,
0x000000003f6c783bULL, 0x000fe80000004200ULL, 0x000000004064783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000ee80000000200ULL, 0x000000004150783bULL, 0x000f280000004200ULL,
0x000000004210783bULL, 0x000f680000004200ULL, 0x00000000431c783bULL, 0x000f280000004200ULL,
0x00000000444c783bULL, 0x000f220000004200ULL, 0x0000004760609231ULL, 0x002fc400003400ffULL,
0x0000004762629231ULL, 0x000fe400003400ffULL, 0x0000004661619231ULL, 0x080fe400003400ffULL,
0x0000004663639231ULL, 0x000fce00003400ffULL, 0x000000746068723cULL, 0x004fe20000041814ULL,
0x0000004748489231ULL, 0x008fce00003400ffULL, 0x000000766054723cULL, 0x000fe20000041854ULL,
0x000000474a4a9231ULL, 0x000fe400003400ffULL, 0x0000004649499231ULL, 0x080fe400003400ffULL,
0x000000464b4b9231ULL, 0x000fc600003400ffULL, 0x000000706018723cULL, 0x040ff00000041818ULL,
0x000000726058723cULL, 0x040ff00000041858ULL, 0x0000006c6014723cULL, 0x040ff0000004180cULL,
0x0000006e606c723cULL, 0x040ff00000041808ULL, 0x000000646070723cULL, 0x040ff00000041804ULL,
0x00000066605c723cULL, 0x000ff0000004185cULL, 0x00000052480c723cULL, 0x050ff00000041854ULL,
0x000000104808723cULL, 0x060ff00000041818ULL, 0x0000001c4814723cULL, 0x040ff00000041814ULL,
0x000000504804723cULL, 0x040ff00000041868ULL, 0x000000124810723cULL, 0x040ff00000041858ULL,
0x0000001e481c723cULL, 0x040ff0000004186cULL, 0x0000004c4818723cULL, 0x040ff00000041870ULL,
0x0000004e4854723cULL, 0x000fe2000004185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000802f467811ULL, 0x000fe200078e40ffULL, 0x01c69000ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000002b4600720cULL, 0x000fda0003f26070ULL, 0x0000501000001947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000003ff4b7819ULL, 0x000fe20000011620ULL, 0x00000001385b7824ULL, 0x000fe200078e0231ULL,
0x00000020004c7811ULL, 0x000fe400078e30ffULL, 0x000000044b597810ULL, 0x000fe40007ffe0ffULL,
0x000000a02f487811ULL, 0x000fe200078e40ffULL, 0x000000014b467824ULL, 0x000fe200078e024cULL,
0x0000002059497212ULL, 0x040fe200078e3cffULL, 0x00000008594e7824ULL, 0x000fe200078e00ffULL,
0x000000482b377217ULL, 0x000fc40007800000ULL, 0x0000004546477210ULL, 0x080fe40007f3e0ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee249ULL, 0x0000000137377824ULL, 0x000fe200078e0a48ULL,
0x000000074b497812ULL, 0x100fe200078e4820ULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0x00005e0047467a11ULL, 0x000fe400078248ffULL, 0x0ffffff849487812ULL, 0x000fe400078ef820ULL,
0x00005f0047477a11ULL, 0x000fe200008f4c4aULL, 0x00000001594a7824ULL, 0x000fe200078e024cULL,
0x0000002037377817ULL, 0x000fe20003800000ULL, 0x00000010484f7824ULL, 0x000fe200078e023bULL,
0x000000084b5f7810ULL, 0x000fe20007ffe0ffULL, 0x000000105b467825ULL, 0x000fe200078e0046ULL,
0x000000454a497210ULL, 0x000fc40007f5e0ffULL, 0x000000104b637810ULL, 0x000fe20007ffe0ffULL,
0x000000085f5c7824ULL, 0x000fe200078e00ffULL, 0x000000374b00720cULL, 0x000fe20003f26070ULL,
0x000000ffff4a7224ULL, 0x000fe200010e06ffULL, 0x00005e0049487a11ULL, 0x000fe200078448ffULL,
0x0000000863537824ULL, 0x000fe200078e00ffULL, 0x0000000c4b617810ULL, 0x000fe20007ffe0ffULL,
0x0000000163527824ULL, 0x000fe200078e024cULL, 0x00005f0049497a11ULL, 0x000fe200010f4c4aULL,
0x000000015f4a7824ULL, 0x040fe200078e024cULL, 0x000000205f4d7212ULL, 0x080fe200078e3cffULL,
0x00000008615e7824ULL, 0x000fe200078e00ffULL, 0x0000002063507212ULL, 0x000fc400078e3cffULL,
0x000000144b657810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000464f7faeULL, 0x0003e2000c901c46ULL, 0x000000184b677810ULL, 0x040fe40007ffe0ffULL,
0x0000001c4b697810ULL, 0x000fe20007ffe0ffULL, 0x0000000865627824ULL, 0x040fe200078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee24dULL, 0x0000000165587824ULL, 0x000fe200078e024cULL,
0xfffffff853607812ULL, 0x000fe200078ee250ULL, 0x0000000161507824ULL, 0x100fe200078e024cULL,
0x000000454a4b7210ULL, 0x080fe20007f5e0ffULL, 0x00000001675a7824ULL, 0x100fe200078e024cULL,
0x00000020614d7212ULL, 0x080fe200078e3cffULL, 0x00000001694c7824ULL, 0x000fe200078e024cULL,
0x0000002065517212ULL, 0x000fe200078e3cffULL, 0x000000ffff467224ULL, 0x002fe200010e06ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee24dULL, 0x00000008695d7824ULL, 0x000fe200078e00ffULL,
0x00000045504d7210ULL, 0x000fe20007f7e0ffULL, 0x0000000867647824ULL, 0x000fe200078e00ffULL,
0x00005e004b4a7a11ULL, 0x000fc400078c48ffULL, 0xfffffff862627812ULL, 0x000fe400078ee251ULL,
0x00000045524f7210ULL, 0x080fe40007f3e0ffULL, 0x0000004558517210ULL, 0x080fe40007f9e0ffULL,
0x000000455a537210ULL, 0x080fe40007fbe0ffULL, 0x00005f004b4b7a11ULL, 0x000fe200030f4c46ULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x000000454c457210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff5a7224ULL, 0x000fe200028e06ffULL, 0x0000002069507212ULL, 0x000fc400078e3cffULL,
0x00005e004d4c7a11ULL, 0x000fe400078c48ffULL, 0x0000002067477212ULL, 0x000fe400078e3cffULL,
0x000000375900720cULL, 0x000fe40003f66070ULL, 0xfffffff85d667812ULL, 0x000fe200078ee250ULL,
0x000000104e5d7824ULL, 0x000fe200078e023bULL, 0x00005f004d4d7a11ULL, 0x000fe200030f4c46ULL,
0x000000ffff507224ULL, 0x000fe200008e06ffULL, 0x00005e004f4e7a11ULL, 0x000fc400078c48ffULL,
0xfffffff864647812ULL, 0x000fe200078ee247ULL, 0x000000105b467825ULL, 0x000fe200078e0048ULL,
0x00005f004f4f7a11ULL, 0x000fe400030f4c50ULL, 0x00005e0051507a11ULL, 0x000fe200078c48ffULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x00005e0053527a11ULL, 0x000fe200078a48ffULL,
0x00000000465d7faeULL, 0x0003e2000d901c46ULL, 0x000000375f00720cULL, 0x000fe40003f26070ULL,
0x00005f0051517a11ULL, 0x000fe200030f4c48ULL, 0x000000ffff487224ULL, 0x000fe200010e06ffULL,
0x00005e0045587a11ULL, 0x000fc400078c48ffULL, 0x000000376100720cULL, 0x080fe40003f66070ULL,
0x000000376300720cULL, 0x080fe40003f86070ULL, 0x000000376500720cULL, 0x080fe20003f46070ULL,
0x000000105b467825ULL, 0x002fe200078e004aULL, 0x00005f0053537a11ULL, 0x000fe400028f4c5aULL,
0x000000376700720cULL, 0x000fe20003fa6070ULL, 0x000000105b4a7825ULL, 0x000fe200078e004eULL,
0x00005f0045597a11ULL, 0x000fc400030f4c48ULL, 0x000000376900720cULL, 0x000fe20003fc6070ULL,
0x000000105c377824ULL, 0x000fe400078e023bULL, 0x000000105b487825ULL, 0x000fc600078e004cULL,
0x0000000046377faeULL, 0x0003e2000c901c46ULL, 0x000000105b4c7825ULL, 0x000fc800078e0050ULL,
0x000000105b4e7825ULL, 0x000fc800078e0052ULL, 0x000000105e457824ULL, 0x000fe400078e023bULL,
0x000000105b507825ULL, 0x000fc600078e0058ULL, 0x0000000048457faeULL, 0x0003e2000d901c46ULL,
0x0000001060537824ULL, 0x100fe400078e023bULL, 0x0000001062597824ULL, 0x100fe400078e023bULL,
0x00000010645b7824ULL, 0x100fe200078e023bULL, 0x000000004a537faeULL, 0x0003e2000e101c46ULL,
0x00000010665d7824ULL, 0x000fc600078e023bULL, 0x000000004c597faeULL, 0x0003e8000d101c46ULL,
0x000000004e5b7faeULL, 0x0003e8000e901c46ULL, 0x00000000505d7faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff377819ULL, 0x000fe40000011620ULL,
0x00000020004a7811ULL, 0x000fc400078e30ffULL, 0x0000000437497810ULL, 0x040fe40007ffe0ffULL,
0x00000008374b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002049467212ULL, 0x0c0fe200078e3cffULL,
0x00000008494f7824ULL, 0x000fe200078e00ffULL, 0x000000204b477212ULL, 0x0c0fe200078e3cffULL,
0x000000084b5c7824ULL, 0x000fe200078e00ffULL, 0x0000000c374d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84f5a7812ULL, 0x000fe200078ee246ULL, 0x0000000137467824ULL, 0x000fe200078e024aULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee247ULL, 0x000000084d517824ULL, 0x040fe200078e00ffULL,
0x000000204d487212ULL, 0x000fc400078e3cffULL, 0x0000004546477210ULL, 0x080fe20007f3e0ffULL,
0x0000000149467824ULL, 0x000fe200078e024aULL, 0x00000010374f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8515e7812ULL, 0x000fe200078ee248ULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x0000004546497210ULL, 0x000fe20007f5e0ffULL, 0x000000084f537824ULL, 0x000fe200078e00ffULL,
0x00005e0047467a11ULL, 0x000fe400078248ffULL, 0x0000001437517810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4e7224ULL, 0x000fe200010e06ffULL, 0x000000204f507212ULL, 0x000fc400078e3cffULL,
0x00005f0047477a11ULL, 0x000fe200008f4c4cULL, 0x000000014b4c7824ULL, 0x000fe200078e024aULL,
0x00005e0049487a11ULL, 0x000fe200078448ffULL, 0x0000000851597824ULL, 0x040fe200078e00ffULL,
0x0000002051527212ULL, 0x000fe400078e3cffULL, 0xfffffff853627812ULL, 0x000fe200078ee250ULL,
0x000000014f507824ULL, 0x000fe200078e024aULL, 0x00005f0049497a11ULL, 0x000fe200010f4c4eULL,
0x000000014d4e7824ULL, 0x000fe200078e024aULL, 0x0000001837537810ULL, 0x000fc40007ffe0ffULL,
0x0000001c375b7810ULL, 0x000fe40007ffe0ffULL, 0x000000454c4c7210ULL, 0x080fe20007f7e0ffULL,
0x0000000153587824ULL, 0x000fe200078e024aULL, 0xfffffff859667812ULL, 0x000fe200078ee252ULL,
0x0000000151527824ULL, 0x100fe200078e024aULL, 0x000000454e4d7210ULL, 0x080fe20007f5e0ffULL,
0x000000015b607824ULL, 0x000fe200078e024aULL, 0x00005e004c4a7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff4b7224ULL, 0x000fe200018e06ffULL, 0x0000000737377812ULL, 0x000fe200078e4820ULL,
0x00000008536a7824ULL, 0x000fe200078e00ffULL, 0x0000004552517210ULL, 0x000fc40007f7e0ffULL,
0x000000205b527212ULL, 0x0c0fe200078e3cffULL, 0x000000085b5b7824ULL, 0x000fe200078e00ffULL,
0x00000045504f7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff507224ULL, 0x000fe200010e06ffULL,
0x0000004558597210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff647224ULL, 0x000fe200018e06ffULL,
0x00000045605d7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff607224ULL, 0x000fe200008e06ffULL,
0x00005f004c4b7a11ULL, 0x000fe200030f4c4bULL, 0x000000ffff687224ULL, 0x000fe200020e06ffULL,
0x0000002053457212ULL, 0x000fe200078e3cffULL, 0x000000ffff6c7224ULL, 0x000fe200028e06ffULL,
0x0ffffff8374e7812ULL, 0x000fe200078ef820ULL, 0x0000000138377824ULL, 0x000fe200078e0231ULL,
0x00005e004d4c7a11ULL, 0x000fc400078448ffULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee245ULL,
0x000000104e457824ULL, 0x000fe200078e023bULL, 0xfffffff85b6e7812ULL, 0x000fe200078ee252ULL,
0x0000001037467825ULL, 0x000fe200078e0046ULL, 0x00005f004d4d7a11ULL, 0x000fe400010f4c50ULL,
0x00005e0059527a11ULL, 0x000fe200078648ffULL, 0x000000105a5b7824ULL, 0x000fe200078e023bULL,
0x00005e004f4e7a11ULL, 0x000fe200078248ffULL, 0x0000001037487825ULL, 0x000fe200078e0048ULL,
0x00005e0051507a11ULL, 0x000fe200078448ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046457faeULL, 0x0003e2000b901c46ULL, 0x00005e005d587a11ULL, 0x000fe200078848ffULL,
0x00000010374a7825ULL, 0x000fe200078e004aULL, 0x00005f0059537a11ULL, 0x000fe200018f4c68ULL,
0x00000000485b7faeULL, 0x0005e2000b901c46ULL, 0x00005f004f4f7a11ULL, 0x000fe200008f4c60ULL,
0x00000010374c7825ULL, 0x000fe200078e004cULL, 0x00005f0051517a11ULL, 0x000fc400010f4c64ULL,
0x00005f005d597a11ULL, 0x000fe200020f4c6cULL, 0x000000105c5d7824ULL, 0x000fe400078e023bULL,
0x00000010374e7825ULL, 0x000fc600078e004eULL, 0x000000004a5d7faeULL, 0x0005e2000b901c46ULL,
0x0000001037507825ULL, 0x000fc800078e0050ULL, 0x0000001037527825ULL, 0x000fc800078e0052ULL,
0x0000001037587825ULL, 0x000fc800078e0058ULL, 0x000000105e377824ULL, 0x100fe400078e023bULL,
0x0000001062457824ULL, 0x102fe400078e023bULL, 0x0000001066477824ULL, 0x100fe200078e023bULL,
0x000000004c377faeULL, 0x0005e2000b901c46ULL, 0x000000106a5f7824ULL, 0x100fe400078e023bULL,
0x000000106e617824ULL, 0x000fe200078e023bULL, 0x000000004e457faeULL, 0x0005e8000b901c46ULL,
0x0000000050477faeULL, 0x0005e8000b901c46ULL, 0x00000000525f7faeULL, 0x0005e8000b901c46ULL,
0x0000000058617faeULL, 0x0005e4000b901c46ULL, 0x00000300ff377624ULL, 0x006fe200078e00ffULL,
0x0000000339457812ULL, 0x000fc800078ec0ffULL, 0x000000034500780cULL, 0x000fe40003f25270ULL,
0xfffffffd37377811ULL, 0x000fc800078e10ffULL, 0x0000000137467807ULL, 0x000fe20004800000ULL,
0xffffffffff377424ULL, 0x000fc800078e00ffULL, 0x0000000139397824ULL, 0x000fca00078e0246ULL,
0x000000783900720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000139467824ULL, 0x000fe400078e0234ULL, 0x00000004ff477424ULL, 0x000fc800078e00ffULL,
0x0000600046467625ULL, 0x000fca00078e0047ULL, 0x0000000646377981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6480038467f8cULL, 0x002fe8000c80043fULL, 0x01c64c0038457984ULL, 0x000e640000000800ULL,
0x8000000045ff7812ULL, 0x002fe40007824847ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff457424ULL, 0x000fc800078e00ffULL, 0x0000004500487305ULL, 0x0002a4000021f000ULL,
0x3fa0000045457823ULL, 0x002fe200000100ffULL, 0x000000480000735dULL, 0x004fe20003800000ULL,
0x01c64c0038497984ULL, 0x000e640000000800ULL, 0x8000000049ff7812ULL, 0x002fc40007824847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c1000033457984ULL, 0x000e680000000800ULL,
0x01c3000033487984ULL, 0x0004e20000000800ULL, 0x000000364500720bULL, 0x002fe20003f3d000ULL,
0x000107727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x004fc800008e0100ULL,
0x0000ffff464b7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff497424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000022d00780cULL, 0x000fe40003f25270ULL, 0x000000364500720bULL, 0x000fe20003f54000ULL,
0x000107527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x000fe400010e0100ULL,
0x0000004536477209ULL, 0x000fe40007810000ULL, 0x0000ffff46467812ULL, 0x000fe400078e3cffULL,
0x00000002ff4c7819ULL, 0x000fe20000011620ULL, 0x8000004736497221ULL, 0x000fe20000010000ULL,
0x01c5004733009388ULL, 0x0003e20000000800ULL, 0x000000464bff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b49497820ULL, 0x000fcc0000410000ULL, 0x0000004900497308ULL, 0x000ea40000000800ULL,
0x0000004935357220ULL, 0x004fe20000410000ULL, 0x000107027f007947ULL, 0x000fea000b800000ULL,
0x00001f4c49467589ULL, 0x0022a400000e0000ULL, 0x0000004604047220ULL, 0x084fe40000410000ULL,
0x0000004605057220ULL, 0x080fe40000410000ULL, 0x000000460c0c7220ULL, 0x080fe40000410000ULL,
0x000000460d0d7220ULL, 0x080fe40000410000ULL, 0x0000004608087220ULL, 0x000fc40000410000ULL,
0x0000004609097220ULL, 0x080fe40000410000ULL, 0x0000004610107220ULL, 0x080fe40000410000ULL,
0x0000004611117220ULL, 0x080fe40000410000ULL, 0x0000004614147220ULL, 0x080fe40000410000ULL,
0x0000004615157220ULL, 0x080fe40000410000ULL, 0x000000461c1c7220ULL, 0x000fc40000410000ULL,
0x000000461d1d7220ULL, 0x080fe40000410000ULL, 0x0000004618187220ULL, 0x080fe40000410000ULL,
0x0000004619197220ULL, 0x080fe40000410000ULL, 0x0000004654547220ULL, 0x080fe40000410000ULL,
0x0000004655557220ULL, 0x000fe20000410000ULL, 0x000106527f007947ULL, 0x000fea000b800000ULL,
0x00001f3049467589ULL, 0x00052400000e0000ULL, 0x0000004536367209ULL, 0x000fe20007810000ULL,
0x0000004606067220ULL, 0x090fe20000410000ULL, 0x00000001ff497807ULL, 0x006fe20000800000ULL,
0x0000004607077220ULL, 0x000fc40000410000ULL, 0x8000003645451221ULL, 0x000fe40000010000ULL,
0x000000460e0e7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b45451820ULL, 0x000fe40000410000ULL,
0x000000460f0f7220ULL, 0x080fe40000410000ULL, 0x0000004500321308ULL, 0x000e620000000800ULL,
0x000000460a0a7220ULL, 0x080fe40000410000ULL, 0x000000460b0b7220ULL, 0x000fc40000410000ULL,
0x0000004612127220ULL, 0x080fe40000410000ULL, 0x0000004613137220ULL, 0x080fe40000410000ULL,
0x0000004616167220ULL, 0x080fe40000410000ULL, 0x0000004617177220ULL, 0x080fe40000410000ULL,
0x000000461e1e7220ULL, 0x080fe40000410000ULL, 0x000000461f1f7220ULL, 0x000fc40000410000ULL,
0x000000461a1a7220ULL, 0x080fe40000410000ULL, 0x000000461b1b7220ULL, 0x080fe40000410000ULL,
0x0000004656567220ULL, 0x080fe40000410000ULL, 0x0000004657577220ULL, 0x000fe40000410000ULL,
0x0000004832481220ULL, 0x00afe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000032ff45723eULL, 0x000fe200000010ffULL, 0x0000003548357221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff4c7819ULL, 0x000fe40000011620ULL,
0x00005410454b7816ULL, 0x000fe20000000045ULL, 0x000104f27f007947ULL, 0x000fea000b800000ULL,
0x00001f4c4b457589ULL, 0x0002a800000e0000ULL, 0x00001f304b747589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002eULL,
0x00007f0000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x00010ea000007944ULL, 0x02cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002cULL,
0x00007f6000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x00010e4000007944ULL, 0x02cfea0003c00000ULL,
0x000130002a607811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002868783bULL, 0x000fe20000004200ULL, 0x0001300024487811ULL, 0x000fe400078e20ffULL,
0x0000991049467816ULL, 0x000fe200000000ffULL, 0x000000006060783bULL, 0x000f260000000200ULL,
0x000000ff4600720cULL, 0x000fe20003f25270ULL, 0x000000002770783bULL, 0x000fe80000004200ULL,
0x00000000266c783bULL, 0x000fe80000004200ULL, 0x000000002564783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x006e680000000200ULL, 0x00000000235c783bULL, 0x000ea80000004200ULL,
0x000000002258783bULL, 0x000ee80000004200ULL, 0x000000002150783bULL, 0x000ea80000004200ULL,
0x00000000034c783bULL, 0x000ea20000004200ULL, 0x0000004560609231ULL, 0x010fc400003400ffULL,
0x0000004562629231ULL, 0x000fe400003400ffULL, 0x0000007461619231ULL, 0x088fe400003400ffULL,
0x0000007463639231ULL, 0x000fce00003400ffULL, 0x000000686004723cULL, 0x000fe20000041804ULL,
0x0000004548489231ULL, 0x082fe400003400ffULL, 0x000000454a4a9231ULL, 0x000fe200003400ffULL,
0x0000580037457a24ULL, 0x020fe200078e02ffULL, 0x0000007449499231ULL, 0x000fc600003400ffULL,
0x0000006a600c723cULL, 0x000fe2000004180cULL, 0x000000744b4b9231ULL, 0x000fe200003400ffULL,
0x0000004045457824ULL, 0x000fcc00078e00ffULL, 0x000000706068723cULL, 0x040ff00000041808ULL,
0x0000006c6014723cULL, 0x040ff00000041814ULL, 0x0000006e601c723cULL, 0x040ff0000004181cULL,
0x000000726010723cULL, 0x040ff00000041810ULL, 0x00000064606c723cULL, 0x040ff00000041818ULL,
0x000000666054723cULL, 0x000ff00000041854ULL, 0x0000005e4808723cULL, 0x044ff0000004180cULL,
0x0000005c4804723cULL, 0x040ff00000041804ULL, 0x00000058480c723cULL, 0x040ff00000041868ULL,
0x000000504818723cULL, 0x040ff00000041814ULL, 0x0000005a4858723cULL, 0x040ff00000041810ULL,
0x000000524850723cULL, 0x040ff0000004181cULL, 0x0000004c4814723cULL, 0x040ff0000004186cULL,
0x0000004e485c723cULL, 0x000fe20000041854ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x00000003ff497819ULL, 0x000fe20000011620ULL,
0x00000001384f7824ULL, 0x000fe200078e0231ULL, 0x000000c02f107811ULL, 0x000fe400078e40ffULL,
0x00000004491f7810ULL, 0x040fe20007ffe0ffULL, 0x00000040004c7824ULL, 0x000fe200078e0249ULL,
0x00000008494b7810ULL, 0x000fe40007ffe0ffULL, 0x000000102b117217ULL, 0x000fe20007800000ULL,
0x000000081f4a7824ULL, 0x000fe200078e00ffULL, 0x0000001049637810ULL, 0x000fe20007ffe0ffULL,
0x000000084b1d7824ULL, 0x000fe200078e00ffULL, 0x0000001449657810ULL, 0x000fe20007ffe0ffULL,
0x0000000111127824ULL, 0x000fe200078e0a10ULL, 0x000000201f137212ULL, 0x080fe200078e3cffULL,
0x0000000863627824ULL, 0x000fe200078e00ffULL, 0x000000204b1c7212ULL, 0x000fe200078e3cffULL,
0x0000000865647824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fc400078ee213ULL,
0x0000000c494d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002063117212ULL, 0x080fe200078e3cffULL,
0x000000104a577824ULL, 0x000fe200078e0229ULL, 0x0000001849677810ULL, 0x000fe40007ffe0ffULL,
0x0000002065137212ULL, 0x000fe400078e3cffULL, 0xfffffff81d547812ULL, 0x000fe200078ee21cULL,
0x000000084d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ee211ULL,
0x0000000867667824ULL, 0x000fe200078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee213ULL,
0x0000001054617824ULL, 0x000fe200078e0229ULL, 0x0000001c49697810ULL, 0x000fc40007ffe0ffULL,
0x000000454c117210ULL, 0x040fe40007f5e0ffULL, 0x000000204d107212ULL, 0x080fe200078e3cffULL,
0x0000000869687824ULL, 0x000fe200078e00ffULL, 0x0000002067137212ULL, 0x000fe200078e3cffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x000000044c1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81d567812ULL, 0x000fe400078ee210ULL, 0xfffffff866667812ULL, 0x000fc400078ee213ULL,
0x00000020691d7212ULL, 0x000fe400078e3cffULL, 0x00005e0011107a11ULL, 0x040fe400078448ffULL,
0x000000451e137210ULL, 0x000fe40007f7e0ffULL, 0x000000084c1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff868687812ULL, 0x000fe400078ee21dULL, 0x00005f0011117a11ULL, 0x000fe200010f4c1cULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00000020124e7817ULL, 0x000fc40003800000ULL,
0x000000451e1d7210ULL, 0x080fe20007f9e0ffULL, 0x000000104f107825ULL, 0x000fe200078e0010ULL,
0x00005e0013127a11ULL, 0x000fe400078448ffULL, 0x0000000c4c467810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x0000004e1f00720cULL, 0x000fe40003f66070ULL,
0x00005f0013137a11ULL, 0x000fe400010f4c1cULL, 0x00000045461f7210ULL, 0x000fc40007fbe0ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078448ffULL, 0x000000104f127825ULL, 0x000fe200078e0012ULL,
0x000000104c607810ULL, 0x000fe40007ffe0ffULL, 0x00005f001d1d7a11ULL, 0x000fe200010f4c48ULL,
0x000000ffff467224ULL, 0x000fe200028e06ffULL, 0x0000004560477210ULL, 0x000fe40007f5e0ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078848ffULL, 0x000000104f1c7825ULL, 0x000fe200078e001cULL,
0x000000144c607810ULL, 0x000fc40007ffe0ffULL, 0x00005f001f1f7a11ULL, 0x000fe200020f4c46ULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x0000004e4900720cULL, 0x000fe40003f86070ULL,
0x00005e0047467a11ULL, 0x000fe400078c48ffULL, 0x0000000749497812ULL, 0x000fe400078e4820ULL,
0x00005f0047477a11ULL, 0x000fe400030f4c48ULL, 0x0ffffff849487812ULL, 0x000fc400078ef820ULL,
0x0000004560497210ULL, 0x080fe40007fde0ffULL, 0x000000184c607810ULL, 0x000fe20007ffe0ffULL,
0x0000001048557824ULL, 0x000fe200078e0229ULL, 0x0000004e4b00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x0000001c4c4c7810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010557faeULL, 0x0003e2000e101c46ULL,
0x00000045604b7210ULL, 0x000fe40007f9e0ffULL, 0x00005e0049487a11ULL, 0x000fe200078c48ffULL,
0x0000000012577faeULL, 0x0005e2000d901c46ULL, 0x0000004e4d00720cULL, 0x000fc40003f46070ULL,
0x000000454c4d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005f0049497a11ULL, 0x000fe200030f4c4aULL, 0x000000001c617faeULL, 0x0007e2000e901c46ULL,
0x00005e004b4a7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff547224ULL, 0x000fe200018e06ffULL,
0x0000004e6300720cULL, 0x080fe20003f86070ULL, 0x000000104f107825ULL, 0x002fe200078e001eULL,
0x00005f004b4b7a11ULL, 0x000fe400030f4c4cULL, 0x00005e004d4c7a11ULL, 0x000fe200078648ffULL,
0x000000104f127825ULL, 0x004fe200078e0046ULL, 0x0000004e6500720cULL, 0x000fc40003fc6070ULL,
0x0000004e6700720cULL, 0x080fe20003fa6070ULL, 0x000000104f467825ULL, 0x000fe200078e004aULL,
0x00005f004d4d7a11ULL, 0x000fe400018f4c54ULL, 0x0000004e6900720cULL, 0x000fe20003f66070ULL,
0x000000104f1e7825ULL, 0x000fc800078e0048ULL, 0x00000010564b7824ULL, 0x000fe400078e0229ULL,
0x000000104f487825ULL, 0x000fc600078e004cULL, 0x00000000104b7faeULL, 0x0003e2000d101c46ULL,
0x00000010621d7824ULL, 0x108fe400078e0229ULL, 0x00000010644d7824ULL, 0x100fe400078e0229ULL,
0x00000010664f7824ULL, 0x100fe200078e0229ULL, 0x00000000121d7faeULL, 0x0003e2000e101c46ULL,
0x0000001068557824ULL, 0x000fc600078e0229ULL, 0x000000001e4d7faeULL, 0x0003e8000f101c46ULL,
0x00000000464f7faeULL, 0x0003e8000e901c46ULL, 0x0000000048557faeULL, 0x0003e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x00000003ff1d7819ULL, 0x000fe20000011620ULL,
0x00000001384f7824ULL, 0x000fc600078e0231ULL, 0x000000041d117810ULL, 0x040fe20007ffe0ffULL,
0x0000004000467824ULL, 0x000fe200078e021dULL, 0x000000081d137810ULL, 0x040fe40007ffe0ffULL,
0x0000000c1d1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811497824ULL, 0x000fe200078e00ffULL,
0x000000101d477810ULL, 0x000fe20007ffe0ffULL, 0x0000000813547824ULL, 0x000fe200078e00ffULL,
0x0000002011107212ULL, 0x080fe400078e3cffULL, 0x000000201f127212ULL, 0x0c0fe200078e3cffULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x0000002013117212ULL, 0x080fe200078e3cffULL,
0x0000000847627824ULL, 0x040fe200078e00ffULL, 0x0000002047137212ULL, 0x000fc400078e3cffULL,
0xfffffff854547812ULL, 0x000fe400078ee211ULL, 0xfffffff81f567812ULL, 0x000fe400078ee212ULL,
0xfffffff862627812ULL, 0x000fe200078ee213ULL, 0x0000001054617824ULL, 0x000fe200078e0229ULL,
0x000000141d117810ULL, 0x040fe40007ffe0ffULL, 0x000000181d137810ULL, 0x040fe40007ffe0ffULL,
0x0000001c1d1f7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8494e7812ULL, 0x000fe200078ee210ULL,
0x0000000813477824ULL, 0x000fe200078e00ffULL, 0x0000002011107212ULL, 0x0c0fe200078e3cffULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x0000002013127212ULL, 0x080fe200078e3cffULL,
0x000000081f6e7824ULL, 0x040fe200078e00ffULL, 0x000000201f137212ULL, 0x000fe200078e3cffULL,
0x000000104e577824ULL, 0x000fe200078e0229ULL, 0x00000004461c7810ULL, 0x040fe40007ffe0ffULL,
0x00000008461e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c46487810ULL, 0x000fe40007ffe0ffULL,
0xfffffff811667812ULL, 0x000fe400078ee210ULL, 0xfffffff86e6e7812ULL, 0x000fe400078ee213ULL,
0x0000004546117210ULL, 0x080fe40007f5e0ffULL, 0x000000451c137210ULL, 0x080fe20007f7e0ffULL,
0x000000106e657824ULL, 0x000fe200078e0229ULL, 0x000000451e1f7210ULL, 0x000fc40007f9e0ffULL,
0x0000004548497210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0xfffffff8476a7812ULL, 0x000fe200078ee212ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005e001f1c7a11ULL, 0x000fe200078648ffULL, 0x000000ffff4c7224ULL, 0x000fe200028e06ffULL,
0x00005e00491e7a11ULL, 0x000fe200078848ffULL, 0x000000106a637824ULL, 0x000fe200078e0229ULL,
0x000000071d477812ULL, 0x000fc400078e4820ULL, 0x00005f0011117a11ULL, 0x000fe400010f4c12ULL,
0x00005f001f1d7a11ULL, 0x000fe400018f4c4aULL, 0x00005e0013127a11ULL, 0x000fe200078448ffULL,
0x000000104f107825ULL, 0x000fe200078e0010ULL, 0x00005f00491f7a11ULL, 0x000fe400020f4c4cULL,
0x00000010464a7810ULL, 0x040fe20007ffe0ffULL, 0x000000104f1c7825ULL, 0x000fe200078e001cULL,
0x00000014464c7810ULL, 0x000fc40007ffe0ffULL, 0x0000001846607810ULL, 0x040fe20007ffe0ffULL,
0x000000104f1e7825ULL, 0x000fe200078e001eULL, 0x0000001c46467810ULL, 0x000fe40007ffe0ffULL,
0x00005f0013137a11ULL, 0x000fe400010f4c48ULL, 0x0ffffff847487812ULL, 0x000fe400078ef820ULL,
0x000000454a477210ULL, 0x080fe20007f9e0ffULL, 0x000000104f127825ULL, 0x000fe200078e0012ULL,
0x000000454c497210ULL, 0x000fc40007fbe0ffULL, 0x00000045604b7210ULL, 0x080fe20007f5e0ffULL,
0x0000001048557824ULL, 0x000fe200078e0229ULL, 0x00000045464d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff607224ULL, 0x000fe200020e06ffULL, 0x00005e0047467a11ULL, 0x000fe200078848ffULL,
0x000000ffff647224ULL, 0x000fe200028e06ffULL, 0x00005e0049487a11ULL, 0x000fe200078a48ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x00005e004b4a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff6c7224ULL, 0x000fe200018e06ffULL, 0x00005e004d4c7a11ULL, 0x000fe200078648ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010557faeULL, 0x0003e2000b901c46ULL,
0x00005f0047477a11ULL, 0x000fc400020f4c60ULL, 0x00005f0049497a11ULL, 0x000fe200028f4c64ULL,
0x0000000012577faeULL, 0x0005e2000b901c46ULL, 0x00005f004b4b7a11ULL, 0x000fe200010f4c68ULL,
0x000000104f467825ULL, 0x000fe200078e0046ULL, 0x00005f004d4d7a11ULL, 0x000fe200018f4c6cULL,
0x000000001c617faeULL, 0x0005e4000b901c46ULL, 0x000000104f487825ULL, 0x000fc800078e0048ULL,
0x000000104f4a7825ULL, 0x000fc800078e004aULL, 0x000000104f4c7825ULL, 0x000fc800078e004cULL,
0x0000001056117824ULL, 0x102fe400078e0229ULL, 0x00000010624f7824ULL, 0x100fe400078e0229ULL,
0x0000001066557824ULL, 0x000fe200078e0229ULL, 0x000000001e117faeULL, 0x0005e8000b901c46ULL,
0x00000000464f7faeULL, 0x0005e8000b901c46ULL, 0x0000000048557faeULL, 0x0005e8000b901c46ULL,
0x000000004a637faeULL, 0x0005e8000b901c46ULL, 0x000000004c657faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000130003a607811ULL, 0x000fc400078e20ffULL,
0x00000032ff10723eULL, 0x002fe400000010ffULL, 0x00000002ff477819ULL, 0x004fe40000011620ULL,
0x0000541010747816ULL, 0x000fe40000000010ULL, 0x000130003d547811ULL, 0x000fc600078e20ffULL,
0x00001f4774477589ULL, 0x000fe800000e0000ULL, 0x00001f3074467589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006060783bULL, 0x000e680000000200ULL,
0x000000003c68783bULL, 0x000ea80000004200ULL, 0x000000003e70783bULL, 0x000fe80000004200ULL,
0x000000003f6c783bULL, 0x000fe80000004200ULL, 0x000000004064783bULL, 0x000fe80000004200ULL,
0x000000005454783bULL, 0x000ee80000000200ULL, 0x000000004210783bULL, 0x000f280000004200ULL,
0x00000000431c783bULL, 0x000f680000004200ULL, 0x00000000414c783bULL, 0x000f280000004200ULL,
0x000000004448783bULL, 0x000f220000004200ULL, 0x0000004760609231ULL, 0x002fc400003400ffULL,
0x0000004762629231ULL, 0x000fe400003400ffULL, 0x0000004661619231ULL, 0x080fe400003400ffULL,
0x0000004663639231ULL, 0x000fce00003400ffULL, 0x000000686004723cULL, 0x004fe20000041804ULL,
0x0000004754549231ULL, 0x008fce00003400ffULL, 0x0000006a6068723cULL, 0x000fe20000041808ULL,
0x0000004756569231ULL, 0x000fe400003400ffULL, 0x0000004655559231ULL, 0x080fe400003400ffULL,
0x0000004657579231ULL, 0x000fc600003400ffULL, 0x000000706008723cULL, 0x040ff0000004180cULL,
0x0000006c6018723cULL, 0x040ff00000041818ULL, 0x0000006e6050723cULL, 0x040ff00000041850ULL,
0x000000726058723cULL, 0x040ff00000041858ULL, 0x00000064606c723cULL, 0x040ff00000041814ULL,
0x00000066605c723cULL, 0x000ff0000004185cULL, 0x000000105408723cULL, 0x050ff00000041808ULL,
0x0000001c5414723cULL, 0x060ff00000041818ULL, 0x0000004c5404723cULL, 0x040ff00000041804ULL,
0x0000004e540c723cULL, 0x040ff00000041868ULL, 0x000000125410723cULL, 0x040ff00000041858ULL,
0x0000001e541c723cULL, 0x040ff00000041850ULL, 0x000000485418723cULL, 0x040ff0000004186cULL,
0x0000004a5454723cULL, 0x000fe2000004185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000c02f467811ULL, 0x000fe200078e40ffULL, 0x01c69800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000002b4600720cULL, 0x000fda0003f26070ULL, 0x0000281000001947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x000000e02f467811ULL, 0x000fe400078e40ffULL, 0x00000003ff507819ULL, 0x000fe40000011620ULL,
0x000000462b377217ULL, 0x000fe40007800000ULL, 0x0000000450527810ULL, 0x040fe40007ffe0ffULL,
0x0000000850587810ULL, 0x000fe20007ffe0ffULL, 0x0000000137377824ULL, 0x000fe200078e0a46ULL,
0x00000020004b7811ULL, 0x000fe200078e30ffULL, 0x0000000852497824ULL, 0x040fe200078e00ffULL,
0x0000002052467212ULL, 0x080fe200078e3cffULL, 0x0000000858607824ULL, 0x040fe200078e00ffULL,
0x0000002058477212ULL, 0x000fc400078e3cffULL, 0xfffffff8495e7812ULL, 0x000fe200078ee246ULL,
0x0000000150467824ULL, 0x000fe200078e024bULL, 0xfffffff860607812ULL, 0x000fe400078ee247ULL,
0x0000000c505a7810ULL, 0x000fe40007ffe0ffULL, 0x0000004546477210ULL, 0x080fe20007f1e0ffULL,
0x0000000152467824ULL, 0x000fe200078e024bULL, 0x000000205a487212ULL, 0x040fe200078e3cffULL,
0x000000085a4d7824ULL, 0x000fe200078e00ffULL, 0x0000001450667810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200000e06ffULL, 0x0000004546497210ULL, 0x000fc40007f3e0ffULL,
0xfffffff84d627812ULL, 0x000fe200078ee248ULL, 0x00000008664f7824ULL, 0x000fe200078e00ffULL,
0x00000010505c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0x00005e0049487a11ULL, 0x000fe200078248ffULL, 0x0000000166687824ULL, 0x100fe200078e024bULL,
0x00005e0047467a11ULL, 0x000fe200078048ffULL, 0x000000085c647824ULL, 0x000fe200078e00ffULL,
0x00000020664e7212ULL, 0x000fe400078e3cffULL, 0x00005f0049497a11ULL, 0x000fe200008f4c4aULL,
0x00000001584a7824ULL, 0x000fe200078e024bULL, 0x00000018506c7810ULL, 0x000fc40007ffe0ffULL,
0x0000001c50707810ULL, 0x000fe40007ffe0ffULL, 0x00005f0047477a11ULL, 0x000fe200000f4c4cULL,
0x000000015a4c7824ULL, 0x100fe200078e024bULL, 0x000000205c4d7212ULL, 0x080fe200078e3cffULL,
0x000000016c6e7824ULL, 0x100fe200078e024bULL, 0xfffffff84f6a7812ULL, 0x000fe200078ee24eULL,
0x000000015c4e7824ULL, 0x100fe200078e024bULL, 0x000000206c597212ULL, 0x000fe200078e3cffULL,
0x0000000170727824ULL, 0x000fe200078e024bULL, 0x000000454a4b7210ULL, 0x080fe20007f1e0ffULL,
0x000000086c747824ULL, 0x000fe200078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee24dULL,
0x0000000870767824ULL, 0x000fe200078e00ffULL, 0x000000454c4d7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200000e06ffULL, 0x0000004568517210ULL, 0x000fe20007f9e0ffULL,
0x00000010645f7824ULL, 0x000fe200078e023bULL, 0xfffffff874687812ULL, 0x000fe200078ee259ULL,
0x000000106a617824ULL, 0x000fe200078e023bULL, 0x0000002037377817ULL, 0x000fc40003800000ULL,
0x0000000750597812ULL, 0x100fe200078e4820ULL, 0x0000001068637824ULL, 0x000fe200078e023bULL,
0x000000454e4f7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff4e7224ULL, 0x000fe200018e06ffULL,
0x00005e004b4a7a11ULL, 0x000fe400078048ffULL, 0x000000375000720cULL, 0x000fe40003f66070ULL,
0x0ffffff859507812ULL, 0x000fe400078ef820ULL, 0x00000020705b7212ULL, 0x000fc400078e3cffULL,
0x00005f004b4b7a11ULL, 0x000fe200000f4c4cULL, 0x00000010505d7824ULL, 0x000fe200078e023bULL,
0x00005e004d4c7a11ULL, 0x040fe200078c48ffULL, 0x000000ffff507224ULL, 0x000fe200008e06ffULL,
0x000000456e537210ULL, 0x000fe40007fbe0ffULL, 0xfffffff8766e7812ULL, 0x000fe200078ee25bULL,
0x00000001385b7824ULL, 0x000fe200078e0231ULL, 0x00005f004d4d7a11ULL, 0x000fe400030f4c4eULL,
0x00005e004f4e7a11ULL, 0x000fe200078c48ffULL, 0x000000105b467825ULL, 0x000fe200078e0046ULL,
0x000000375200720cULL, 0x000fc40003f06070ULL, 0x00005f004f4f7a11ULL, 0x000fe200030f4c50ULL,
0x000000ffff527224ULL, 0x000fe200020e06ffULL, 0x0000004572457210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000465d7faeULL, 0x0003e2000d901c46ULL,
0x00005e0051507a11ULL, 0x040fe400078c48ffULL, 0x000000375c00720cULL, 0x080fe20003f86070ULL,
0x000000ffff5c7224ULL, 0x000fe200028e06ffULL, 0x000000375a00720cULL, 0x000fe20003f66070ULL,
0x000000ffff5a7224ULL, 0x000fe200010e06ffULL, 0x00005f0051517a11ULL, 0x000fc400030f4c52ULL,
0x000000375800720cULL, 0x080fe40003f26070ULL, 0x00005e0053527a11ULL, 0x000fe200078a48ffULL,
0x000000105b467825ULL, 0x002fe200078e0048ULL, 0x00005e0045587a11ULL, 0x000fe400078c48ffULL,
0x000000376600720cULL, 0x080fe20003f46070ULL, 0x000000105b487825ULL, 0x000fe200078e004aULL,
0x00005f0053537a11ULL, 0x000fe400028f4c5cULL, 0x000000376c00720cULL, 0x080fe20003fa6070ULL,
0x00000010625d7824ULL, 0x100fe200078e023bULL, 0x00005f0045597a11ULL, 0x000fe200030f4c5aULL,
0x0000001060457824ULL, 0x100fe200078e023bULL, 0x000000377000720cULL, 0x000fe20003fc6070ULL,
0x000000105e377824ULL, 0x000fc400078e023bULL, 0x000000105b4a7825ULL, 0x000fc600078e004cULL,
0x0000000046377faeULL, 0x0003e2000c101c46ULL, 0x000000105b4c7825ULL, 0x000fc600078e004eULL,
0x0000000048457faeULL, 0x0003e2000c901c46ULL, 0x000000105b4e7825ULL, 0x000fc600078e0050ULL,
0x000000004a5d7faeULL, 0x0003e2000d901c46ULL, 0x000000105b507825ULL, 0x000fc600078e0052ULL,
0x000000004c5f7faeULL, 0x0003e2000e101c46ULL, 0x000000106e3b7824ULL, 0x000fe400078e023bULL,
0x000000105b527825ULL, 0x000fe200078e0058ULL, 0x000000004e617faeULL, 0x0003e8000d101c46ULL,
0x0000000050637faeULL, 0x0003e8000e901c46ULL, 0x00000000523b7faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff377819ULL, 0x000fe40000011620ULL,
0x0000002000487811ULL, 0x000fc400078e30ffULL, 0x0000000437497810ULL, 0x040fe40007ffe0ffULL,
0x00000008374b7810ULL, 0x000fe40007ffe0ffULL, 0x0000002049467212ULL, 0x0c0fe200078e3cffULL,
0x00000008494d7824ULL, 0x000fe200078e00ffULL, 0x000000204b477212ULL, 0x0c0fe200078e3cffULL,
0x000000084b507824ULL, 0x000fe200078e00ffULL, 0x00000010374f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84d4e7812ULL, 0x000fe200078ee246ULL, 0x0000000137467824ULL, 0x140fe200078e0248ULL,
0x0000000c374d7810ULL, 0x000fe20007ffe0ffULL, 0x000000084f5c7824ULL, 0x040fe200078e00ffULL,
0xfffffff850507812ULL, 0x000fe200078ee247ULL, 0x000000014f5a7824ULL, 0x100fe200078e0248ULL,
0x0000004546477210ULL, 0x000fe20007f1e0ffULL, 0x000000084d597824ULL, 0x000fe200078e00ffULL,
0x0000001437537810ULL, 0x000fe20007ffe0ffULL, 0x00000010505d7824ULL, 0x000fe200078e023bULL,
0x000000204f517212ULL, 0x080fe200078e3cffULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0x000000204d4c7212ULL, 0x000fe200078e3cffULL, 0x00000008535b7824ULL, 0x000fe200078e00ffULL,
0x00005e0047467a11ULL, 0x000fe200078048ffULL, 0x00000001535e7824ULL, 0x000fe200078e0248ULL,
0xfffffff85c5c7812ULL, 0x000fc400078ee251ULL, 0x0000002053527212ULL, 0x080fe400078e3cffULL,
0xfffffff859587812ULL, 0x000fe200078ee24cULL, 0x000000014b4c7824ULL, 0x000fe200078e0248ULL,
0x0000001837517810ULL, 0x040fe20007ffe0ffULL, 0x000000105c617824ULL, 0x100fe200078e023bULL,
0x0000001c37597810ULL, 0x000fe20007ffe0ffULL, 0x00000010585f7824ULL, 0x100fe200078e023bULL,
0x00005f0047477a11ULL, 0x000fe200000f4c4aULL, 0x00000001494a7824ULL, 0x000fe200078e0248ULL,
0xfffffff85b607812ULL, 0x000fe200078ee252ULL, 0x000000014d527824ULL, 0x000fe200078e0248ULL,
0x0000000737377812ULL, 0x000fe200078e4820ULL, 0x0000000151627824ULL, 0x100fe200078e0248ULL,
0x000000454a497210ULL, 0x080fe20007fde0ffULL, 0x0000000159487824ULL, 0x000fe200078e0248ULL,
0x000000454c4b7210ULL, 0x080fe20007fbe0ffULL, 0x0000000851647824ULL, 0x000fe200078e00ffULL,
0x0000004552527210ULL, 0x080fe20007f9e0ffULL, 0x0000000859687824ULL, 0x000fe200078e00ffULL,
0x000000455a5a7210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff4c7224ULL, 0x000fe200030e06ffULL,
0x000000455e5e7210ULL, 0x080fe20007f1e0ffULL, 0x000000104e5b7824ULL, 0x100fe200078e023bULL,
0x0000004562627210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff4e7224ULL, 0x000fe200028e06ffULL,
0x0000004548667210ULL, 0x000fe20007f5e0ffULL, 0x0000001060637824ULL, 0x000fe200078e023bULL,
0x0000002051457212ULL, 0x080fe200078e3cffULL, 0x000000ffff517224ULL, 0x000fe200000e06ffULL,
0x00000020594d7212ULL, 0x000fe200078e3cffULL, 0x000000ffff537224ULL, 0x000fe200008e06ffULL,
0x0ffffff8374a7812ULL, 0x000fe200078ef820ULL, 0x000000ffff377224ULL, 0x000fe200020e06ffULL,
0x00005e0049487a11ULL, 0x000fe200078c48ffULL, 0x000000ffff597224ULL, 0x000fe200010e06ffULL,
0xfffffff864647812ULL, 0x000fe200078ee245ULL, 0x000000104a457824ULL, 0x000fe200078e023bULL,
0xfffffff868687812ULL, 0x000fc400078ee24dULL, 0x00005f0049497a11ULL, 0x000fe200030f4c4cULL,
0x0000001064657824ULL, 0x100fe200078e023bULL, 0x00005e004b4a7a11ULL, 0x040fe200078a48ffULL,
0x0000001068677824ULL, 0x000fe200078e023bULL, 0x00005e00524c7a11ULL, 0x040fe200078848ffULL,
0x000000ffff3b7224ULL, 0x000fe200018e06ffULL, 0x00005f004b4b7a11ULL, 0x000fe400028f4c4eULL,
0x00005f00524d7a11ULL, 0x000fe200020f4c37ULL, 0x0000000138377824ULL, 0x000fe200078e0231ULL,
0x00005e005a4e7a11ULL, 0x000fc400078648ffULL, 0x00005e005e507a11ULL, 0x000fe200078048ffULL,
0x0000001037467825ULL, 0x040fe200078e0046ULL, 0x00005e0062527a11ULL, 0x000fe400078248ffULL,
0x00005e0066587a11ULL, 0x000fe200078448ffULL, 0x0000001037487825ULL, 0x040fe200078e0048ULL,
0x00005f005a4f7a11ULL, 0x000fe200018f4c3bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046457faeULL, 0x0003e2000b901c46ULL, 0x00005f005e517a11ULL, 0x000fe200000f4c51ULL,
0x00000010374a7825ULL, 0x040fe200078e004aULL, 0x00005f0062537a11ULL, 0x000fe200008f4c53ULL,
0x00000000485b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0066597a11ULL, 0x000fe200010f4c59ULL,
0x00000010374c7825ULL, 0x000fc400078e004cULL, 0x000000004a5d7faeULL, 0x0003e4000b901c46ULL,
0x00000010374e7825ULL, 0x040fe400078e004eULL, 0x000000004c5f7faeULL, 0x0003e4000b901c46ULL,
0x0000001037507825ULL, 0x040fe400078e0050ULL, 0x000000004e617faeULL, 0x0003e4000b901c46ULL,
0x0000001037527825ULL, 0x000fc400078e0052ULL, 0x0000000050637faeULL, 0x0003e4000b901c46ULL,
0x0000001037587825ULL, 0x000fe400078e0058ULL, 0x0000000052657faeULL, 0x0003e8000b901c46ULL,
0x0000000058677faeULL, 0x0003e4000b901c46ULL, 0x00000300ff377624ULL, 0x002fe200078e00ffULL,
0x00000003393b7812ULL, 0x000fc800078ec0ffULL, 0x000000033b00780cULL, 0x000fe40003f05270ULL,
0xfffffffd37377811ULL, 0x000fc800078e10ffULL, 0x0000000137467807ULL, 0x000fe20004000000ULL,
0xffffffffff377424ULL, 0x000fc800078e00ffULL, 0x0000000139397824ULL, 0x000fca00078e0246ULL,
0x000000783900720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000139467824ULL, 0x000fe400078e0234ULL, 0x00000004ff477424ULL, 0x000fc800078e00ffULL,
0x0000600046467625ULL, 0x000fca00078e0047ULL, 0x0000000646377981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6680038467f8cULL, 0x002fe8000c80043fULL, 0x01c66c00383b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x002fe40007804847ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff3b7424ULL, 0x000fc800078e00ffULL, 0x0000003b00457305ULL, 0x0002a4000021f000ULL,
0x3fa000003b3b7823ULL, 0x002fe200000100ffULL, 0x000000450000735dULL, 0x004fe40003800000ULL,
0x01c66c0038457984ULL, 0x000e640000000800ULL, 0x8000000045ff7812ULL, 0x002fc40007804847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c18000333b7984ULL, 0x000e680000000800ULL,
0x01c3800033457984ULL, 0x0004e20000000800ULL, 0x000000363b00720bULL, 0x002fe20003f1d000ULL,
0x0000e1e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x004fc800000e0100ULL,
0x0000ffff464b7812ULL, 0x000fe2000780c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff487424ULL, 0x000fd600078e00ffULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x000000032d00780cULL, 0x000fe40003f05270ULL, 0x000000363b00720bULL, 0x000fe20003f34000ULL,
0x0000e1c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000467806ULL, 0x000fe400008e0100ULL,
0x0000003b36477209ULL, 0x000fe40007810000ULL, 0x0000ffff46467812ULL, 0x000fe400078e3cffULL,
0x00000002ff4c7819ULL, 0x000fe20000011620ULL, 0x8000004736487221ULL, 0x000fe20000010000ULL,
0x01c5804733008388ULL, 0x0003e20000000800ULL, 0x000000464bff7212ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b48487820ULL, 0x000fcc0000410000ULL, 0x0000004800487308ULL, 0x000ea40000000800ULL,
0x0000004835357220ULL, 0x004fe20000410000ULL, 0x0000e1727f007947ULL, 0x000fea000b800000ULL,
0x00001f4c48337589ULL, 0x0022a400000e0000ULL, 0x0000003304047220ULL, 0x084fe40000410000ULL,
0x0000003305057220ULL, 0x080fe40000410000ULL, 0x000000330c0c7220ULL, 0x080fe40000410000ULL,
0x000000330d0d7220ULL, 0x080fe40000410000ULL, 0x0000003308087220ULL, 0x000fc40000410000ULL,
0x0000003309097220ULL, 0x080fe40000410000ULL, 0x0000003310107220ULL, 0x080fe40000410000ULL,
0x0000003311117220ULL, 0x080fe40000410000ULL, 0x0000003314147220ULL, 0x080fe40000410000ULL,
0x0000003315157220ULL, 0x080fe40000410000ULL, 0x000000331c1c7220ULL, 0x000fc40000410000ULL,
0x000000331d1d7220ULL, 0x080fe40000410000ULL, 0x0000003318187220ULL, 0x080fe40000410000ULL,
0x0000003319197220ULL, 0x080fe40000410000ULL, 0x0000003354547220ULL, 0x080fe40000410000ULL,
0x0000003355557220ULL, 0x000fe20000410000ULL, 0x0000e0c27f007947ULL, 0x000fea000b800000ULL,
0x00001f3048337589ULL, 0x00052400000e0000ULL, 0x0000003b36367209ULL, 0x000fe20007810000ULL,
0x0000003306067220ULL, 0x090fe20000410000ULL, 0x00000001ff487807ULL, 0x006fe20000000000ULL,
0x0000003307077220ULL, 0x000fc40000410000ULL, 0x800000363b3b0221ULL, 0x000fe40000010000ULL,
0x000000330e0e7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b3b3b0820ULL, 0x000fe40000410000ULL,
0x000000330f0f7220ULL, 0x080fe40000410000ULL, 0x0000003b00320308ULL, 0x000e620000000800ULL,
0x000000330a0a7220ULL, 0x080fe40000410000ULL, 0x000000330b0b7220ULL, 0x000fc40000410000ULL,
0x0000003312127220ULL, 0x080fe40000410000ULL, 0x0000003313137220ULL, 0x080fe40000410000ULL,
0x0000003316167220ULL, 0x080fe40000410000ULL, 0x0000003317177220ULL, 0x080fe40000410000ULL,
0x000000331e1e7220ULL, 0x080fe40000410000ULL, 0x000000331f1f7220ULL, 0x000fc40000410000ULL,
0x000000331a1a7220ULL, 0x080fe40000410000ULL, 0x000000331b1b7220ULL, 0x080fe40000410000ULL,
0x0000003356567220ULL, 0x080fe40000410000ULL, 0x0000003357577220ULL, 0x000fe40000410000ULL,
0x0000004532450220ULL, 0x00afe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000032ff33723eULL, 0x000fe200000010ffULL, 0x0000003545357221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff4c7819ULL, 0x000fe40000011620ULL,
0x00005410334b7816ULL, 0x000fe20000000033ULL, 0x0000df627f007947ULL, 0x000fea000b800000ULL,
0x00001f4c4b337589ULL, 0x0002a800000e0000ULL, 0x00001f304b587589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002eULL,
0x0000a70000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x0000e6a000007944ULL, 0x02cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002cULL,
0x0000a76000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x0000e64000007944ULL, 0x02cfea0003c00000ULL,
0x000138002a2a7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000285c783bULL, 0x0009e20000004200ULL, 0x0001380024247811ULL, 0x000fe400078e20ffULL,
0x00009910482c7816ULL, 0x000fe200000000ffULL, 0x000000002a4c783bULL, 0x002e660000000200ULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x000000002760783bULL, 0x000fe20000004200ULL,
0x000003002f287a10ULL, 0x010fc60007ffe0ffULL, 0x000000002664783bULL, 0x000fe80000004200ULL,
0x000000002550783bULL, 0x000fe80000004200ULL, 0x000000002448783bULL, 0x004ea80000000200ULL,
0x000000002368783bULL, 0x000f280000004200ULL, 0x00000000226c783bULL, 0x000ee80000004200ULL,
0x000000002170783bULL, 0x0002e80000004200ULL, 0x000000000374783bULL, 0x0002e40000004200ULL,
0x0000580037217a24ULL, 0x022fe200078e02ffULL, 0x000000334c4c8231ULL, 0x080fe200003400ffULL,
0x0000000128037810ULL, 0x000fe20007ffe0ffULL, 0x000000334e4e8231ULL, 0x000fc400003400ffULL,
0x000000584d4d8231ULL, 0x088fe200003400ffULL, 0x000000020300720cULL, 0x000fe20003f26070ULL,
0x000000584f4f8231ULL, 0x000fce00003400ffULL, 0x0000005c4c04723cULL, 0x000fe20000041804ULL,
0x0000003348488231ULL, 0x084fe400003400ffULL, 0x000000334a4a8231ULL, 0x000fe200003400ffULL,
0x0000004021337824ULL, 0x000fe200078e00ffULL, 0x0000005849498231ULL, 0x000fc600003400ffULL,
0x0000005e4c0c723cULL, 0x000fe2000004180cULL, 0x000000584b4b8231ULL, 0x000fce00003400ffULL,
0x000000604c24723cULL, 0x040ff00000041808ULL, 0x000000624c10723cULL, 0x040ff00000041810ULL,
0x000000644c14723cULL, 0x040ff00000041814ULL, 0x000000664c1c723cULL, 0x040ff0000004181cULL,
0x000000504c5c723cULL, 0x040ff00000041818ULL, 0x000000524c4c723cULL, 0x000ff00000041854ULL,
0x0000006a4808723cULL, 0x050ff0000004180cULL, 0x0000006c480c723cULL, 0x040ff00000041824ULL,
0x000000724818723cULL, 0x040ff0000004181cULL, 0x000000684804723cULL, 0x040ff00000041804ULL,
0x0000006e4810723cULL, 0x040ff00000041810ULL, 0x000000704814723cULL, 0x040ff00000041814ULL,
0x00000074481c723cULL, 0x040ff0000004185cULL, 0x000000764824723cULL, 0x000fe2000004184cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000070000009947ULL, 0x000fea0003800000ULL,
0x00000003ff3b7819ULL, 0x000fe20000011620ULL, 0x0000010028287824ULL, 0x000fc600078e00ffULL,
0x000000043b4b7810ULL, 0x000fe20007ffe0ffULL, 0x00000040002c7824ULL, 0x000fe200078e023bULL,
0x000000282b037217ULL, 0x000fe40007800000ULL, 0x000000204b237212ULL, 0x040fe200078e3cffULL,
0x000000084b4c7824ULL, 0x000fe200078e00ffULL, 0x000000332c217210ULL, 0x000fe20007f3e0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a28ULL, 0x000000083b4d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee223ULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0021227a11ULL, 0x000fe200078248ffULL, 0x000000084d457824ULL, 0x000fe200078e00ffULL,
0x0000000c3b4f7810ULL, 0x000fc40007ffe0ffULL, 0x00005f0021237a11ULL, 0x000fe400008f4c2aULL,
0x000000073b217812ULL, 0x100fe200078e4820ULL, 0x000000084f477824ULL, 0x000fe200078e00ffULL,
0x000000042c2a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff821287812ULL, 0x000fe400078ef820ULL,
0x000000204d2e7212ULL, 0x000fe400078e3cffULL, 0x000000332a217210ULL, 0x000fe20007f5e0ffULL,
0x0000001028497824ULL, 0x000fe200078e0229ULL, 0x0000002003037817ULL, 0x000fc40003800000ULL,
0xfffffff845547812ULL, 0x000fe200078ee22eULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x000000103b507810ULL, 0x000fe20007ffe0ffULL, 0x0000000138457824ULL, 0x000fe200078e0231ULL,
0x000000204f2e7212ULL, 0x000fe400078e3cffULL, 0x000000033b00720cULL, 0x000fe20003f26070ULL,
0x0000000850587824ULL, 0x000fe200078e00ffULL, 0x00005e0021467a11ULL, 0x000fe200078448ffULL,
0x0000001045227825ULL, 0x000fe200078e0022ULL, 0x000000143b517810ULL, 0x000fc40007ffe0ffULL,
0xfffffff847567812ULL, 0x000fe400078ee22eULL, 0x0000002050317212ULL, 0x080fe200078e3cffULL,
0x0000000851537824ULL, 0x000fe200078e00ffULL, 0x00005f0021477a11ULL, 0x000fe400010f4c28ULL,
0x000000082c287810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022497faeULL, 0x0003e2000c901c46ULL, 0x00000020512a7212ULL, 0x000fe400078e3cffULL,
0xfffffff858587812ULL, 0x000fc400078ee231ULL, 0x0000003328317210ULL, 0x000fe40007f5e0ffULL,
0x000000142c487810ULL, 0x040fe40007ffe0ffULL, 0x0000000c2c2e7810ULL, 0x040fe40007ffe0ffULL,
0xfffffff8535a7812ULL, 0x000fe200078ee22aULL, 0x000000ffff227224ULL, 0x002fe200010e06ffULL,
0x000000183b537810ULL, 0x000fe40007ffe0ffULL, 0x000000102c2a7810ULL, 0x000fc40007ffe0ffULL,
0x000000182c4a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c2c4e7810ULL, 0x000fe40007ffe0ffULL,
0x0000003348287210ULL, 0x080fe40007f9e0ffULL, 0x0000001c3b3b7810ULL, 0x000fe40007ffe0ffULL,
0x000000332e2e7210ULL, 0x080fe40007f7e0ffULL, 0x00005e0031487a11ULL, 0x000fe200078c48ffULL,
0x000000083b5e7824ULL, 0x000fe200078e00ffULL, 0x000000332a2c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200018e06ffULL, 0x000000334a2a7210ULL, 0x000fc40007fbe0ffULL,
0x000000334e217210ULL, 0x000fe20007f5e0ffULL, 0x0000000853337824ULL, 0x000fe200078e00ffULL,
0x00005f0031497a11ULL, 0x000fe400030f4c22ULL, 0x0000002053227212ULL, 0x080fe400078e3cffULL,
0x000000203b317212ULL, 0x000fe400078e3cffULL, 0x00005e002e4a7a11ULL, 0x000fe400078c48ffULL,
0x000000034b00720cULL, 0x000fc40003f66070ULL, 0xfffffff8335c7812ULL, 0x000fe200078ee222ULL,
0x000000104c337824ULL, 0x000fe200078e0229ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee231ULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x00005f002e4b7a11ULL, 0x000fe200030f4c23ULL,
0x0000001045227825ULL, 0x000fe200078e0046ULL, 0x00005e002c4c7a11ULL, 0x000fe400078c48ffULL,
0x000000034d00720cULL, 0x080fe20003f26070ULL, 0x000000105e557824ULL, 0x000fe200078e0229ULL,
0x00005f002c4d7a11ULL, 0x000fe200030f4c31ULL, 0x000000ffff317224ULL, 0x000fe200020e06ffULL,
0x00005e00284e7a11ULL, 0x040fe200078c48ffULL, 0x0000000022337faeULL, 0x0003e2000d901c46ULL,
0x000000034f00720cULL, 0x000fe20003f66070ULL, 0x0000001045467825ULL, 0x000fe200078e004cULL,
0x00005f00284f7a11ULL, 0x000fc400030f4c31ULL, 0x000000035000720cULL, 0x080fe20003f86070ULL,
0x000000ffff317224ULL, 0x000fe200028e06ffULL, 0x00005e002a507a11ULL, 0x000fe200078a48ffULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x00005e0021527a11ULL, 0x000fe400078c48ffULL,
0x000000035100720cULL, 0x080fe20003f46070ULL, 0x000000105a337824ULL, 0x002fe200078e0229ULL,
0x00005f002a517a11ULL, 0x000fe200028f4c31ULL, 0x0000001058317824ULL, 0x000fe200078e0229ULL,
0x000000035300720cULL, 0x000fe20003fa6070ULL, 0x0000001045227825ULL, 0x000fe200078e0048ULL,
0x00005f0021537a11ULL, 0x000fc400030f4c28ULL, 0x000000033b00720cULL, 0x000fe20003fc6070ULL,
0x0000001054037824ULL, 0x100fe400078e0229ULL, 0x0000001056217824ULL, 0x100fe400078e0229ULL,
0x000000105c3b7824ULL, 0x000fe200078e0229ULL, 0x0000000022037faeULL, 0x0003e2000c901c46ULL,
0x0000001045287825ULL, 0x000fc800078e004aULL, 0x0000001045487825ULL, 0x040fe200078e004eULL,
0x0000000028217faeULL, 0x0003e6000d901c46ULL, 0x00000010454a7825ULL, 0x040fe200078e0050ULL,
0x0000000046317faeULL, 0x0003e6000e101c46ULL, 0x00000010454c7825ULL, 0x000fe200078e0052ULL,
0x0000000048337faeULL, 0x0003e8000d101c46ULL, 0x000000004a3b7faeULL, 0x0003e8000e901c46ULL,
0x000000004c557faeULL, 0x0003e2000f101c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x000fe20000011620ULL, 0x0000000138317824ULL, 0x000fc600078e0231ULL,
0x0000000403217810ULL, 0x040fe20007ffe0ffULL, 0x0000004000287824ULL, 0x000fe200078e0203ULL,
0x0000000803237810ULL, 0x040fe40007ffe0ffULL, 0x0000000c033b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000821457824ULL, 0x040fe200078e00ffULL, 0x0000002021227212ULL, 0x080fe200078e3cffULL,
0x00000008234a7824ULL, 0x040fe200078e00ffULL, 0x0000002023217212ULL, 0x080fe200078e3cffULL,
0x000000083b4c7824ULL, 0x040fe200078e00ffULL, 0x000000203b237212ULL, 0x000fc400078e3cffULL,
0xfffffff8452e7812ULL, 0x000fe400078ee222ULL, 0x00000010033b7810ULL, 0x040fe40007ffe0ffULL,
0xfffffff84c4c7812ULL, 0x000fe400078ee223ULL, 0x0000001403237810ULL, 0x000fe20007ffe0ffULL,
0x000000083b507824ULL, 0x000fe200078e00ffULL, 0x0000000428227810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84a4a7812ULL, 0x000fc400078ee221ULL, 0x000000203b217212ULL, 0x080fe200078e3cffULL,
0x00000008233b7824ULL, 0x040fe200078e00ffULL, 0x00000033222c7210ULL, 0x000fe40007f5e0ffULL,
0x00000020232a7212ULL, 0x000fe400078e3cffULL, 0x0000001803237810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff457224ULL, 0x000fe200010e06ffULL, 0x00005e002c467a11ULL, 0x000fe400078448ffULL,
0xfffffff850507812ULL, 0x000fe200078ee221ULL, 0x0000000823587824ULL, 0x000fe200078e00ffULL,
0xfffffff83b547812ULL, 0x000fc400078ee22aULL, 0x0000003328217210ULL, 0x000fe20007f3e0ffULL,
0x0000001050537824ULL, 0x100fe200078e0229ULL, 0x00000020233b7212ULL, 0x000fe200078e3cffULL,
0x0000001054557824ULL, 0x000fe200078e0229ULL, 0x00005f002c477a11ULL, 0x000fe200010f4c45ULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00000008282c7810ULL, 0x000fe20007ffe0ffULL,
0x000000104c457824ULL, 0x000fe200078e0229ULL, 0xfffffff858587812ULL, 0x000fe200078ee23bULL,
0x0000001031467825ULL, 0x000fe200078e0046ULL, 0x00000007033b7812ULL, 0x000fc400078e4820ULL,
0x00005e0021227a11ULL, 0x000fe200078248ffULL, 0x0000001058577824ULL, 0x000fe200078e0229ULL,
0x0000001c03037810ULL, 0x000fe40007ffe0ffULL, 0x000000332c2c7210ULL, 0x000fe40007f9e0ffULL,
0x0000000c28487810ULL, 0x000fe20007ffe0ffULL, 0x00000008035a7824ULL, 0x000fe200078e00ffULL,
0x00005f0021237a11ULL, 0x000fe400008f4c2aULL, 0x0ffffff83b2a7812ULL, 0x000fc400078ef820ULL,
0x0000002003217212ULL, 0x000fe200078e3cffULL, 0x000000ffff037224ULL, 0x000fe200020e06ffULL,
0x00000033483b7210ULL, 0x000fe20007f5e0ffULL, 0x0000001031227825ULL, 0x000fe200078e0022ULL,
0x00000010284e7810ULL, 0x000fe40007ffe0ffULL, 0x00005e002c487a11ULL, 0x000fe400078c48ffULL,
0x0000001428527810ULL, 0x040fe40007ffe0ffULL, 0x0000001828567810ULL, 0x000fc40007ffe0ffULL,
0x0000001c28287810ULL, 0x000fe40007ffe0ffULL, 0x000000334e4b7210ULL, 0x080fe40007f7e0ffULL,
0x00005f002c497a11ULL, 0x000fe200030f4c03ULL, 0x000000102a037824ULL, 0x000fe200078e0229ULL,
0xfffffff85a4e7812ULL, 0x000fe200078ee221ULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x0000003328517210ULL, 0x080fe20007fbe0ffULL, 0x000000102e217824ULL, 0x100fe200078e0229ULL,
0x00005e003b287a11ULL, 0x040fe200078448ffULL, 0x000000104e597824ULL, 0x100fe200078e0229ULL,
0x0000003352527210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200028e06ffULL,
0x0000003356567210ULL, 0x000fe20007f9e0ffULL, 0x000000104a337824ULL, 0x000fe200078e0229ULL,
0x00005f003b297a11ULL, 0x000fe200010f4c2aULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005e004b4a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e06ffULL,
0x00005e00524c7a11ULL, 0x000fe200078248ffULL, 0x000000ffff4f7224ULL, 0x000fe200020e06ffULL,
0x00005e00564e7a11ULL, 0x000fe200078648ffULL, 0x0000001031487825ULL, 0x000fe200078e0048ULL,
0x00005e0051507a11ULL, 0x000fe200078848ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022037faeULL, 0x0003e2000b901c46ULL, 0x00005f004b4b7a11ULL, 0x000fe200010f4c2aULL,
0x0000001031287825ULL, 0x040fe200078e0028ULL, 0x00005f00524d7a11ULL, 0x000fe200008f4c3bULL,
0x0000000046217faeULL, 0x0003e2000b901c46ULL, 0x00005f00564f7a11ULL, 0x000fe200018f4c4fULL,
0x00000010314a7825ULL, 0x000fe200078e004aULL, 0x00005f0051517a11ULL, 0x000fe200020f4c2cULL,
0x0000000048337faeULL, 0x0003e4000b901c46ULL, 0x00000010314c7825ULL, 0x000fc400078e004cULL,
0x0000000028457faeULL, 0x0003e4000b901c46ULL, 0x00000010314e7825ULL, 0x040fe400078e004eULL,
0x000000004a537faeULL, 0x0003e4000b901c46ULL, 0x0000001031507825ULL, 0x000fe400078e0050ULL,
0x000000004c557faeULL, 0x0003e8000b901c46ULL, 0x000000004e577faeULL, 0x0003e8000b901c46ULL,
0x0000000050597faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000138003a3a7811ULL, 0x000fc400078e20ffULL, 0x00000032ff21723eULL, 0x002fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe40000011620ULL, 0x0000541021217816ULL, 0x000fe40000000021ULL,
0x000138003d3d7811ULL, 0x000fc600078e20ffULL, 0x00001f0321037589ULL, 0x000fe800000e0000ULL,
0x00001f3021307589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000003a48783bULL, 0x000e680000000200ULL, 0x000000003c4c783bULL, 0x000ea80000004200ULL,
0x000000003f54783bULL, 0x000fe80000004200ULL, 0x000000003e50783bULL, 0x000fe80000004200ULL,
0x000000004058783bULL, 0x000fe80000004200ULL, 0x000000003d5c783bULL, 0x000ee80000000200ULL,
0x000000004160783bULL, 0x000f280000004200ULL, 0x000000004368783bULL, 0x000f680000004200ULL,
0x000000004264783bULL, 0x0003280000004200ULL, 0x000000004444783bULL, 0x000f220000004200ULL,
0x0000000348488231ULL, 0x002fc400003400ffULL, 0x000000034a4a8231ULL, 0x000fe400003400ffULL,
0x0000003049498231ULL, 0x080fe400003400ffULL, 0x000000304b4b8231ULL, 0x000fce00003400ffULL,
0x0000004e4808723cULL, 0x004fe20000041808ULL, 0x000000035c5c8231ULL, 0x008fce00003400ffULL,
0x000000564818723cULL, 0x000fe20000041818ULL, 0x000000035e5e8231ULL, 0x000fe400003400ffULL,
0x000000305d5d8231ULL, 0x080fe400003400ffULL, 0x000000305f5f8231ULL, 0x000fc600003400ffULL,
0x0000004c4804723cULL, 0x040ff00000041804ULL, 0x00000050483c723cULL, 0x040ff0000004180cULL,
0x000000524810723cULL, 0x040ff00000041810ULL, 0x000000544814723cULL, 0x040ff00000041814ULL,
0x000000584840723cULL, 0x040ff0000004181cULL, 0x0000005a4824723cULL, 0x000ff00000041824ULL,
0x000000625c0c723cULL, 0x050ff00000041808ULL, 0x0000006a5c1c723cULL, 0x060ff00000041818ULL,
0x000000605c04723cULL, 0x040ff00000041804ULL, 0x000000645c08723cULL, 0x040ff0000004183cULL,
0x000000665c10723cULL, 0x040ff00000041810ULL, 0x000000685c14723cULL, 0x040ff00000041814ULL,
0x000000445c18723cULL, 0x040ff00000041840ULL, 0x000000465c54723cULL, 0x000fe20000041824ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c6a000ffff7f8cULL, 0x000fe4000c80043fULL, 0x000003002f2f7a10ULL, 0x000fc80007ffe0ffULL,
0x000000022f00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff5b5000007947ULL, 0x000fea000383ffffULL, 0x0000000000267919ULL, 0x000e620000002500ULL,
0x000000ffff207224ULL, 0x000fe400078e001eULL, 0x000000ffff1e7224ULL, 0x000fe400078e001dULL,
0x000000ffff1d7224ULL, 0x000fe400078e001cULL, 0x000000ffff237224ULL, 0x000fe400078e001bULL,
0x000000ffff1c7224ULL, 0x000fe400078e0016ULL, 0x000000ffff217224ULL, 0x000fc400078e0018ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0017ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe400078e0013ULL, 0x000000ffff187224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0009ULL, 0x000000ffff247224ULL, 0x000fe200078e001aULL,
0x000000022600720cULL, 0x002fe20003f06070ULL, 0x000000ffff227224ULL, 0x000fc400078e0019ULL,
0x000000ffff137224ULL, 0x000fe400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e000bULL,
0x000000ffff097224ULL, 0x000fe400078e000cULL, 0x000000ffff1a7224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0014ULL, 0x000000ffff107224ULL, 0x000fc400078e000aULL,
0x000000ffff0b7224ULL, 0x000fe400078e0007ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0006ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x0180000035007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e0035ULL, 0x0000bcd000147802ULL, 0x000fe40000000f00ULL,
0x0000cf2000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003500007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000035ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ee80000000000ULL, 0x0000000000027919ULL, 0x000f220000000000ULL,
0x0000000803037811ULL, 0x008fe400078ff0ffULL, 0x00000002ff077819ULL, 0x010fc80000011602ULL,
0x00001f0300037589ULL, 0x000ee800000e0000ULL, 0x00001f0700027589ULL, 0x000f2200000e0000ULL,
0x0000000c030c7220ULL, 0x048fe40000410000ULL, 0x0000000b030b7220ULL, 0x000fe40000410000ULL,
0x0000000402047220ULL, 0x050fe40000410000ULL, 0x0000000502057220ULL, 0x000fc40000410000ULL,
0x0000000902097220ULL, 0x040fe40000410000ULL, 0x0000000d020d7220ULL, 0x040fe40000410000ULL,
0x0000000802087220ULL, 0x040fe40000410000ULL, 0x0000001102117220ULL, 0x040fe40000410000ULL,
0x0000001302137220ULL, 0x040fe40000410000ULL, 0x0000001602167220ULL, 0x000fc40000410000ULL,
0x0000001902197220ULL, 0x040fe40000410000ULL, 0x0000001a021a7220ULL, 0x040fe40000410000ULL,
0x0000001d021d7220ULL, 0x040fe40000410000ULL, 0x0000001e021e7220ULL, 0x040fe40000410000ULL,
0x0000002102217220ULL, 0x040fe40000410000ULL, 0x0000002202227220ULL, 0x000fc40000410000ULL,
0x0000005402547220ULL, 0x040fe40000410000ULL, 0x0000005502557220ULL, 0x000fe40000410000ULL,
0x0000000e030e7220ULL, 0x040fe40000410000ULL, 0x0000000f030f7220ULL, 0x040fe40000410000ULL,
0x0000001003107220ULL, 0x040fe40000410000ULL, 0x0000001203127220ULL, 0x000fc40000410000ULL,
0x0000001803187220ULL, 0x040fe40000410000ULL, 0x0000001703177220ULL, 0x040fe40000410000ULL,
0x0000001c031c7220ULL, 0x040fe40000410000ULL, 0x0000001b031b7220ULL, 0x040fe40000410000ULL,
0x0000002003207220ULL, 0x040fe40000410000ULL, 0x0000001f031f7220ULL, 0x000fc40000410000ULL,
0x0000002403247220ULL, 0x040fe40000410000ULL, 0x0000002303237220ULL, 0x040fe40000410000ULL,
0x0000005603567220ULL, 0x040fe40000410000ULL, 0x0000005703577220ULL, 0x000fe40000410000ULL,
0x0000000000257919ULL, 0x000ee20000000000ULL, 0x000000040503723eULL, 0x000fe400000010ffULL,
0x000000090d04723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000010120d723eULL, 0x000fc400000010ffULL, 0x000000201f10723eULL, 0x000fe400000010ffULL,
0x000000131606723eULL, 0x000fe400000010ffULL, 0x000000212209723eULL, 0x000fe400000010ffULL,
0x0000000c0b0b723eULL, 0x000fe400000010ffULL, 0x0000000e0f0c723eULL, 0x000fe400000010ffULL,
0x000000191a07723eULL, 0x000fc400000010ffULL, 0x00000018170e723eULL, 0x000fe400000010ffULL,
0x000000081105723eULL, 0x000fe400000010ffULL, 0x0000001d1e08723eULL, 0x000fe400000010ffULL,
0x00000002ff1f7819ULL, 0x008fe40000011625ULL, 0x00000008252f7811ULL, 0x000fe400078ff0ffULL,
0x0000001fff217212ULL, 0x000fe200078e33ffULL, 0x000000081f147824ULL, 0x000fe200078e00ffULL,
0x0000002fff317212ULL, 0x000fe200078e33ffULL, 0x000000082f167824ULL, 0x000fe200078e00ffULL,
0x000000071f007812ULL, 0x040fe200078ec0ffULL, 0x000000081f027824ULL, 0x000fe200078e00ffULL,
0xfffffff814217812ULL, 0x000fc400078ee221ULL, 0xfffffff816317812ULL, 0x000fe400078ee231ULL,
0xfffffff802137812ULL, 0x000fe400078ee21fULL, 0x0000000100027812ULL, 0x040fe400078e3cffULL,
0x0000000200147812ULL, 0x040fe400078e3cffULL, 0x0000000300167812ULL, 0x040fe200078e3cffULL,
0x000000081f157824ULL, 0x040fe200078e0202ULL, 0x0000000400187812ULL, 0x040fe200078e3cffULL,
0x000000081f177824ULL, 0x040fe200078e0214ULL, 0x00000005001a7812ULL, 0x040fe200078e3cffULL,
0x000000081f197824ULL, 0x000fe200078e0216ULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x0000000425147824ULL, 0x000fe200078e00ffULL, 0x0000001c1b0f723eULL, 0x000fe200000010ffULL,
0x000000081f1b7824ULL, 0x000fe200078e0218ULL, 0x000000072f167812ULL, 0x000fe200078ec0ffULL,
0x000000081f1d7824ULL, 0x040fe200078e021aULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x000000081f1f7824ULL, 0x000fe200078e0200ULL, 0x000000242311723eULL, 0x000fe200000010ffULL,
0x000008002d007824ULL, 0x000fe200078e00ffULL, 0x00000002161a7812ULL, 0x040fe200078e3cffULL,
0x000000082f187824ULL, 0x000fe200078e00ffULL, 0x00000003161c7812ULL, 0x000fc400078e3cffULL,
0x0001200000027810ULL, 0x000fe20007ffe0ffULL, 0x000000082f277824ULL, 0x040fe200078e021aULL,
0xfffffff818237812ULL, 0x000fe200078ee22fULL, 0x000000082f297824ULL, 0x000fe200078e021cULL,
0x0000000116187812ULL, 0x040fe200078e3cffULL, 0x0000001013137824ULL, 0x100fe200078e0202ULL,
0x00000004161e7812ULL, 0x040fe200078e3cffULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x0000000516207812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x000fe200078e0202ULL,
0x0000000616227812ULL, 0x000fe200078e3cffULL, 0x0000000113167824ULL, 0x000fe200078e0214ULL,
0x00000054550a723eULL, 0x000fe200000010ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x000000565712723eULL, 0x000fe200000010ffULL, 0x000000101b1b7824ULL, 0x000fe200078e0202ULL,
0x0000000316007388ULL, 0x0007e20000000800ULL, 0x000000082f257824ULL, 0x000fc400078e0218ULL,
0x000000101d1d7824ULL, 0x100fe400078e0202ULL, 0x0000000114157824ULL, 0x040fe400078e0215ULL,
0x000000101f1f7824ULL, 0x100fe400078e0202ULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x0000000415007388ULL, 0x0009e20000000800ULL, 0x0000000114167824ULL, 0x048fe400078e0217ULL,
0x0000000114197824ULL, 0x000fc400078e0219ULL, 0x000000082f137824ULL, 0x000fe200078e021eULL,
0x0000000516007388ULL, 0x0009e20000000800ULL, 0x0000001023237824ULL, 0x000fe400078e0202ULL,
0x0000000114187824ULL, 0x040fe200078e021bULL, 0x0000000619007388ULL, 0x0009e20000000800ULL,
0x00000001ff037424ULL, 0x000fe400078e00ffULL, 0x000000082f2b7824ULL, 0x000fe200078e0220ULL,
0x0000000718007388ULL, 0x0009e20000000800ULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x0000030003007a0cULL, 0x000fe20003f05270ULL, 0x00000001141d7824ULL, 0x000fc400078e021dULL,
0x000000082f2f7824ULL, 0x000fe400078e0222ULL, 0x0000001027277824ULL, 0x100fe200078e0202ULL,
0x000000081d007388ULL, 0x0009e20000000800ULL, 0x00000001141a7824ULL, 0x040fe400078e021fULL,
0x0000000114217824ULL, 0x040fe400078e0221ULL, 0x0000001029297824ULL, 0x000fe200078e0202ULL,
0x000000091a007388ULL, 0x0009e20000000800ULL, 0x00000001141c7824ULL, 0x000fc400078e0223ULL,
0x0000001013137824ULL, 0x100fe200078e0202ULL, 0x0000000a21007388ULL, 0x0009e20000000800ULL,
0x0000001031317824ULL, 0x100fe400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0x0000000b1c007388ULL, 0x0009e20000000800ULL, 0x0000000114257824ULL, 0x040fe400078e0225ULL,
0x000000102f2f7824ULL, 0x000fe400078e0202ULL, 0x00000001141e7824ULL, 0x040fe200078e0227ULL,
0x0000000c25007388ULL, 0x0009e20000000800ULL, 0x0000000114297824ULL, 0x000fc400078e0229ULL,
0x0000000114207824ULL, 0x040fe200078e0213ULL, 0x0000000d1e007388ULL, 0x0009e20000000800ULL,
0x0000000114317824ULL, 0x040fe400078e0231ULL, 0x00000001142b7824ULL, 0x040fe200078e022bULL,
0x0000000e29007388ULL, 0x0009e20000000800ULL, 0x0000000114147824ULL, 0x000fc600078e022fULL,
0x0000000f20007388ULL, 0x0009e80000000800ULL, 0x000000102b007388ULL, 0x0009e80000000800ULL,
0x0000001114007388ULL, 0x0009e80000000800ULL, 0x0000001231007388ULL, 0x0009e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002bc000008947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x010ee20000000000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x000000ff2d00720cULL, 0x000fe20003f25270ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x00000000000e7919ULL, 0x000f220000002700ULL, 0x0000030005057a24ULL, 0x000fc600078e02ffULL,
0x0000000000037919ULL, 0x000f220000002600ULL, 0x0000660005057a24ULL, 0x000fca00078e02ffULL,
0x00000fff050f7811ULL, 0x040fe400078e40ffULL, 0x01ffffff05057812ULL, 0x000fe200078ec0ffULL,
0x0000001004097824ULL, 0x048fe200078e0200ULL, 0x00000020040d7810ULL, 0x040fe40007ffe0ffULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x0120000009107984ULL, 0x0006640000000c00ULL,
0x000000ff2d00720cULL, 0x000fe20000705670ULL, 0x000058000e0e7a24ULL, 0x010fe200078e0203ULL,
0x0122000009147984ULL, 0x0007260000000c00ULL, 0x000003000e037a24ULL, 0x000fc800078e02ffULL,
0x0000000103087824ULL, 0x000fca00078e0226ULL, 0x000000080f067211ULL, 0x000fca00078fa0ffULL,
0x00006c0006067625ULL, 0x000fcc00078e0007ULL, 0x000004002d067825ULL, 0x000fcc00078e0006ULL,
0x000000100d0c7825ULL, 0x000fc800078e0006ULL, 0x00000010040a7825ULL, 0x000fe200078e0006ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x008ee20000000000ULL,
0x00000080ff187424ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x000fe400078e0205ULL,
0x0000001006197824ULL, 0x008fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011606ULL,
0x00006c0008067625ULL, 0x000fc600078e0018ULL, 0x0000007019197812ULL, 0x000fe200078ec0ffULL,
0x00006c0009087625ULL, 0x000fe200078e0018ULL, 0x0000000c1a1a7812ULL, 0x000fc800078ec0ffULL,
0x000000061a067210ULL, 0x140fe40007b5e019ULL, 0x000000081a087210ULL, 0x000fe40007d9e019ULL,
0x00000007ff077210ULL, 0x000fe400017e64ffULL, 0x00000009ff097210ULL, 0x000fc600027ea4ffULL,
0x0000003606007986ULL, 0x0007e8000c101906ULL, 0x0000003508007986ULL, 0x0007e4000c101906ULL,
0x000000100a007986ULL, 0x00a3e2000c101d06ULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x000000140c007986ULL, 0x0103e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x00000004ff077424ULL, 0x000fc600078e00ffULL, 0x0000030009097a10ULL, 0x000fe20007ffe1ffULL,
0x00006a000e067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000009060679a8ULL, 0x000ee400099ee1c6ULL,
0x000000090600720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x00000008ff007388ULL, 0x0007e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x000f240000000000ULL, 0x000000ff0600720cULL, 0x010fda0003f05270ULL,
0x000027b000008947ULL, 0x000fea0003800000ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x0000001004067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe20000011604ULL,
0x00000080ff157424ULL, 0x002fe200078e00ffULL, 0x0000000103087810ULL, 0x008fe40007ffe0ffULL,
0x0000007006197812ULL, 0x000fe400078ec0ffULL, 0x0000000c070c7812ULL, 0x000fe200078ec0ffULL,
0x00006c0003067625ULL, 0x000fc800078e0015ULL, 0x00006c0008087625ULL, 0x000fe200078e0015ULL,
0x000000060c067210ULL, 0x000fc8000791e019ULL, 0x000000080c087210ULL, 0x000fe40007b5e019ULL,
0x00000007ff077210ULL, 0x000fe400007e24ffULL, 0x00000009ff097210ULL, 0x000fc600017e64ffULL,
0x00000006060a7981ULL, 0x000368000c1e1900ULL, 0x00000006080b7981ULL, 0x000362000c1e1900ULL,
0x00000300ff0e7624ULL, 0x000fca00078e00ffULL, 0x000000020e00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000203067810ULL, 0x002fca0007ffe0ffULL,
0x00006c0006067625ULL, 0x000fca00078e0015ULL, 0x000000060c067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x00000006060d7981ULL, 0x000362000c1e1900ULL,
0x000000040e00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000303067810ULL, 0x002fca0007ffe0ffULL, 0x00006c0006067625ULL, 0x000fca00078e0015ULL,
0x000000060c067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606117981ULL, 0x000362000c1e1900ULL, 0x000000040e00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000403067810ULL, 0x002fca0007ffe0ffULL,
0x00006c0006067625ULL, 0x000fca00078e0015ULL, 0x000000060c067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000606137981ULL, 0x000362000c1e1900ULL,
0x000000060e00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000503067810ULL, 0x002fca0007ffe0ffULL, 0x00006c0006067625ULL, 0x000fca00078e0015ULL,
0x000000060c067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606177981ULL, 0x000362000c1e1900ULL, 0x000000060e00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080e00780cULL, 0x002fe40003f06070ULL,
0x0000000603067810ULL, 0x000fca0007ffe0ffULL, 0x00006c0006067625ULL, 0x000fca00078e0015ULL,
0x000000060c067210ULL, 0x000fe40007a3e019ULL, 0x0000000703080810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff077210ULL, 0x000fc60000fe44ffULL, 0x00006c0008080625ULL, 0x000fca00078e0015ULL,
0x000000080c080210ULL, 0x000fe40007c7e019ULL, 0x0000000606197981ULL, 0x000364000c1e1900ULL,
0x00000009ff090210ULL, 0x000fca0001fe84ffULL, 0x00000006081b0981ULL, 0x000368000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x008fe400078e0003ULL, 0x000000ffff097224ULL, 0x020fe400078e000aULL,
0x000000ffff127224ULL, 0x000fc600078e00ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000112127810ULL, 0x000fc80007ffe0ffULL, 0x0000000412007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000810067810ULL, 0x040fe40007ffe0ffULL,
0x0000000110077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000090a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000808067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011604ULL,
0x0000001004097824ULL, 0x000fe400078e00ffULL, 0x00006c0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x000000060c067210ULL, 0x000fc80007b3e009ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606097981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000910067810ULL, 0x042fe40007ffe0ffULL, 0x0000000210077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000b0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000908067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011604ULL, 0x00000010040b7824ULL, 0x000fe400078e00ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000060c067210ULL, 0x000fc80007b3e00bULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x00000006060b7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000310077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011604ULL,
0x00000010040c7824ULL, 0x000fe400078e00ffULL, 0x00006c0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c0d7812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e00dULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x00000006060d7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000410077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x000000110a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011604ULL, 0x00000010040c7824ULL, 0x000fe400078e00ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c117812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007b3e011ULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x0000000606117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000510077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000130a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011604ULL,
0x00000010040c7824ULL, 0x000fe400078e00ffULL, 0x00006c0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c137812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e013ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000610077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x000000170a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011604ULL, 0x00000010040c7824ULL, 0x000fe400078e00ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c157812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007b3e015ULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x0000000606177981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000710077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011604ULL,
0x00000010040c7824ULL, 0x000fe400078e00ffULL, 0x00006c0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c157812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e015ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f10067810ULL, 0x002fe40007ffe0ffULL, 0x0000001b0a0a7209ULL, 0x000fe40007810000ULL,
0x0000030006007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011604ULL, 0x00000010040c7824ULL, 0x000fe400078e00ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c157812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007a3e015ULL,
0x00000007ff077210ULL, 0x000fca0000fe44ffULL, 0x00000006061b7981ULL, 0x000368000c1e1900ULL,
0x0000000810107810ULL, 0x000fe40007ffe0ffULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000047919ULL, 0x000f240000000000ULL,
0x0000001004067824ULL, 0x012fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011604ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000106077824ULL, 0x000fca00078e0207ULL, 0x0000000a07007388ULL, 0x0203e40000000800ULL,
0x000000070400780cULL, 0x040fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001004067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x002fe20000011604ULL,
0x00001000ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000030f147211ULL, 0x000fe200078fa0ffULL,
0x0000000103157824ULL, 0x000fe200078e0205ULL, 0x0000007006087812ULL, 0x008fe200078ec0ffULL,
0x000010002d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000c07097812ULL, 0x000fe200078ec0ffULL,
0x00006c0014067625ULL, 0x000fe200078e000bULL, 0x00000020040b7810ULL, 0x000fe20007ffe0ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0c8424ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0e8424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000004002d067825ULL, 0x000fe200078e0006ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00006c00150c8625ULL, 0x000fe200078e000cULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x000000102d138824ULL, 0x000fe400078e0204ULL,
0x00006c00030e8625ULL, 0x000fc600078e000eULL, 0x0000458013138811ULL, 0x000fe200078e20ffULL,
0x00000001081c7824ULL, 0x000fe400078e0209ULL, 0x000000102d178824ULL, 0x000fe400078e0204ULL,
0x0000001004117824ULL, 0x040fe400078e021dULL, 0x0000001004087825ULL, 0x100fe200078e0006ULL,
0x0000418017178811ULL, 0x000fe200078e20ffULL, 0x000000001c1c7984ULL, 0x000e640000000800ULL,
0x000000100b0a7825ULL, 0x000fc400078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008117faeULL, 0x0007e2000b901c46ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x00000010040c8825ULL, 0x040fe400078e000cULL, 0x003800000a117faeULL, 0x0009e4000b901c46ULL,
0x00000010040e8825ULL, 0x000fe400078e000eULL, 0x000000000c138faeULL, 0x000be4000b901c46ULL,
0x000000ffff057224ULL, 0x000fc400078e00ffULL, 0x000000000e178faeULL, 0x0005e2000b901c46ULL,
0x0000000000087805ULL, 0x008fe2000001ff00ULL, 0x000000ffff2c7224ULL, 0x000fe400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000a7805ULL, 0x010fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x020fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x004fe2000001ff00ULL, 0x00000d1000009947ULL, 0x000fea0003800000ULL,
0x0000000103337810ULL, 0x000fe20007ffe0ffULL, 0x00000001ff037424ULL, 0x000fe200078e00ffULL,
0x0000000115317810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000114327810ULL, 0x000fc40007ffe0ffULL, 0x0000030003007a0cULL, 0x000fda0003f06070ULL,
0x000001f000000947ULL, 0x000fea0003800000ULL, 0x000000070400780cULL, 0x040fe20003f04070ULL,
0x0000080003147824ULL, 0x040fe200078e00ffULL, 0x0000000103187812ULL, 0x000fe200078ec0ffULL,
0x00001000ff157424ULL, 0x000fe200078e00ffULL, 0x0000002004397810ULL, 0x000fe40007ffe0ffULL,
0x0000080014167812ULL, 0x000fe200078ec0ffULL, 0x00006c0032147625ULL, 0x000fc800078e0015ULL,
0x000000011d177824ULL, 0x000fe400078e0216ULL, 0x000000022d198824ULL, 0x140fe400078e0218ULL,
0x000000022d1b8824ULL, 0x040fe400078e0218ULL, 0x00000080ff188424ULL, 0x000fe400078e00ffULL,
0x00000080ff1a8424ULL, 0x000fe400078e00ffULL, 0x000004002d147825ULL, 0x000fc800078e0014ULL,
0x0000000819378824ULL, 0x100fe400078e0204ULL, 0x000000081b348824ULL, 0x000fe400078e0204ULL,
0x00006c0031188625ULL, 0x000fe200078e0018ULL, 0x0000458037378811ULL, 0x000fc600078e20ffULL,
0x00006c00331a8625ULL, 0x000fc800078e001aULL, 0x0000001004357824ULL, 0x000fe400078e0217ULL,
0x0000001039167825ULL, 0x000fe200078e0014ULL, 0x0000418034398811ULL, 0x000fc600078e20ffULL,
0x0000001004147825ULL, 0x000fc800078e0014ULL, 0x0000001004188825ULL, 0x040fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000014357faeULL, 0x0005e6000b901c46ULL,
0x00000010041a8825ULL, 0x000fe200078e001aULL, 0x0038000016357faeULL, 0x0005e8000b901c46ULL,
0x0000000018378faeULL, 0x0005e8000b901c46ULL, 0x000000001a398faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff03147810ULL, 0x004fe20007ffe0ffULL,
0x0000001004177824ULL, 0x000fe200078e00ffULL, 0x00000001ff187819ULL, 0x000fc40000011604ULL,
0x00000002ff347819ULL, 0x000fe20000011604ULL, 0x0000008014157824ULL, 0x040fe200078e00ffULL,
0x0000007017177812ULL, 0x000fe200078ec0ffULL, 0x0000080014147824ULL, 0x000fe200078e00ffULL,
0x0000000c18187812ULL, 0x000fe200078ec0ffULL, 0x0000000834367824ULL, 0x040fe200078e00ffULL,
0x0000008015167812ULL, 0x000fe200078ec0ffULL, 0x00000008341a7824ULL, 0x040fe200078e00ffULL,
0x00000034ff157212ULL, 0x000fe400078e33ffULL, 0x00000007343b7812ULL, 0x000fe200078ec0ffULL,
0x000001002d167824ULL, 0x000fe200078e0216ULL, 0x0000080014147812ULL, 0x000fc400078ec0ffULL,
0xfffffff836477812ULL, 0x000fe200078ee215ULL, 0x0000000404367824ULL, 0x000fe200078e00ffULL,
0x0000001618187210ULL, 0x000fe20007ffe017ULL, 0x0000000834167824ULL, 0x000fe200078e00ffULL,
0xfffffff81a157812ULL, 0x000fe200078ee23bULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800018397984ULL, 0x000ea20000000800ULL, 0x000001801d147810ULL, 0x000fe40007ffe014ULL,
0x00000008343a7810ULL, 0x000fe20007ffe0ffULL, 0x00458000184b7984ULL, 0x0004e20000000800ULL,
0x0000000c36367812ULL, 0x000fe200078ec0ffULL, 0x0000001015157824ULL, 0x100fe200078e0214ULL,
0x0000000116177812ULL, 0x100fe200078ef63bULL, 0x000000083a1a7824ULL, 0x000fe200078e00ffULL,
0x0000000216197812ULL, 0x000fe200078ef63bULL, 0x0000000136157824ULL, 0x000fe200078e0215ULL,
0x00000003161b7812ULL, 0x100fe200078ef63bULL, 0x000000083a3d7824ULL, 0x000fe200078e00ffULL,
0x0000000416357812ULL, 0x140fe200078ef63bULL, 0x0000001017177824ULL, 0x100fe200078e0214ULL,
0x0000000516377812ULL, 0x000fe200078ef63bULL, 0x0000000015157984ULL, 0x000f220000000800ULL,
0x0000003aff497212ULL, 0x000fe200078e33ffULL, 0x0000000136177824ULL, 0x000fe200078e0217ULL,
0x0000030003007a0cULL, 0x000fe20003f06070ULL, 0x0000001019197824ULL, 0x100fe200078e0214ULL,
0xfffffff81a497812ULL, 0x000fe200078ee249ULL, 0x000000101b1b7824ULL, 0x100fe200078e0214ULL,
0x0000000103037810ULL, 0x000fe20007ffe0ffULL, 0x0000000136197824ULL, 0x040fe200078e0219ULL,
0x0000000017177984ULL, 0x000fe20000000800ULL, 0x00000001361b7824ULL, 0x000fe200078e021bULL,
0x0000000131317810ULL, 0x000fe20007ffe0ffULL, 0x0000001035357824ULL, 0x100fe200078e0214ULL,
0x0000000132327810ULL, 0x000fe20007ffe0ffULL, 0x0000000019197984ULL, 0x000fe20000000800ULL,
0x0000001037377824ULL, 0x000fe200078e0214ULL, 0x0000000133337810ULL, 0x000fe20007ffe0ffULL,
0x0000000136357824ULL, 0x040fe200078e0235ULL, 0x000000001b1b7984ULL, 0x000fe20000000800ULL,
0x0000000136377824ULL, 0x000fc400078e0237ULL, 0x0000001049497824ULL, 0x100fe400078e0214ULL,
0x0000000035357984ULL, 0x000fe20000000800ULL, 0x000000391c187221ULL, 0x006fe20000010100ULL,
0x0000000616397812ULL, 0x000fe200078ef63bULL, 0x000000083a3b7824ULL, 0x000fe200078e00ffULL,
0x0000000037377984ULL, 0x000fe20000000800ULL, 0x3fb8aa3b18167820ULL, 0x000fe20000410000ULL,
0x000000073a187812ULL, 0x000fe200078ec0ffULL, 0x0000001039397824ULL, 0x000fe400078e0214ULL,
0x00000016001a7308ULL, 0x0002e20000000800ULL, 0x000000013d3f7812ULL, 0x140fe200078ef618ULL,
0x0000000136397824ULL, 0x040fe200078e0239ULL, 0x000000023d417812ULL, 0x140fe200078ef618ULL,
0x0000000136497824ULL, 0x040fe200078e0249ULL, 0x000000033d437812ULL, 0x000fe200078ef618ULL,
0x000000103f3f7824ULL, 0x000fe200078e0214ULL, 0x000000043d457812ULL, 0x000fe200078ef618ULL,
0x0000001041417824ULL, 0x000fe200078e0214ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee218ULL,
0x0000001047167824ULL, 0x002fe200078e0214ULL, 0x000000053d477812ULL, 0x000fe200078ef618ULL,
0x0000001043437824ULL, 0x000fe200078e0214ULL, 0x000000063d3d7812ULL, 0x000fe200078ef618ULL,
0x0000000136167824ULL, 0x000fe200078e0216ULL, 0x0000000039397984ULL, 0x000fe20000000800ULL,
0x0000004b1a4b7220ULL, 0x008fc40000410000ULL, 0x000000103b3b7824ULL, 0x100fe200078e0214ULL,
0x0000000016187984ULL, 0x000fe20000000800ULL, 0x0000001045457824ULL, 0x100fe400078e0214ULL,
0x0000001047477824ULL, 0x100fe200078e0214ULL, 0x00001f344b167589ULL, 0x000e6200000e0000ULL,
0x000000103d3d7824ULL, 0x000fe200078e0214ULL, 0x00005410ff147816ULL, 0x010fe20000000015ULL,
0x00000001363b7824ULL, 0x040fe200078e023bULL, 0x00007610ff157816ULL, 0x000fe20000000015ULL,
0x00000001363f7824ULL, 0x040fe200078e023fULL, 0x0000000049497984ULL, 0x000fe20000000800ULL,
0x0000000136417824ULL, 0x000fc400078e0241ULL, 0x0000000136437824ULL, 0x040fe200078e0243ULL,
0x000000003b3b7984ULL, 0x000ea20000000800ULL, 0x0000000136457824ULL, 0x040fe400078e0245ULL,
0x000000304b307221ULL, 0x000fe20000010000ULL, 0x000000003f3f7984ULL, 0x000fe20000000800ULL,
0x0000000136477824ULL, 0x040fe400078e0247ULL, 0x00000001363d7824ULL, 0x000fe200078e023dULL,
0x0000000041417984ULL, 0x000fe80000000800ULL, 0x0000000043437984ULL, 0x000fe20000000800ULL,
0x00000016142f7223ULL, 0x002fc4000001002fULL, 0x00000016152e7223ULL, 0x000fe2000001002eULL,
0x00001f3a4b4b7589ULL, 0x000e6800000e0000ULL, 0x0000000045457984ULL, 0x000ee80000000800ULL,
0x0000000047477984ULL, 0x000f220000000800ULL, 0x00005410ff147816ULL, 0x000fc40000000018ULL,
0x00007610ff157816ULL, 0x000fe20000000018ULL, 0x000000003d3d7984ULL, 0x000f640000000800ULL,
0x00000016141f7223ULL, 0x080fe2000001001fULL, 0x00005410ff147816ULL, 0x100fe20000000017ULL,
0x00000016151e7223ULL, 0x000fe2000001001eULL, 0x00007610ff157816ULL, 0x000fc60000000017ULL,
0x00000016142b7223ULL, 0x080fe2000001002bULL, 0x00005410ff147816ULL, 0x100fe20000000019ULL,
0x00000016152a7223ULL, 0x000fe2000001002aULL, 0x00007610ff157816ULL, 0x000fc60000000019ULL,
0x0000001614297223ULL, 0x080fe20000010029ULL, 0x00005410ff147816ULL, 0x100fe2000000001bULL,
0x0000001615287223ULL, 0x000fe20000010028ULL, 0x00007610ff157816ULL, 0x000fc6000000001bULL,
0x0000001614277223ULL, 0x080fe20000010027ULL, 0x00005410ff147816ULL, 0x100fe20000000035ULL,
0x0000001615267223ULL, 0x000fe20000010026ULL, 0x00007610ff157816ULL, 0x000fc60000000035ULL,
0x0000001614257223ULL, 0x080fe20000010025ULL, 0x00005410ff147816ULL, 0x100fe20000000037ULL,
0x0000001615247223ULL, 0x000fe20000010024ULL, 0x00007610ff157816ULL, 0x000fc60000000037ULL,
0x0000001614237223ULL, 0x080fe20000010023ULL, 0x00005410ff147816ULL, 0x100fe20000000039ULL,
0x0000001615227223ULL, 0x000fe20000010022ULL, 0x00007610ff157816ULL, 0x000fc60000000039ULL,
0x0000001614217223ULL, 0x080fe20000010021ULL, 0x00007610ff147816ULL, 0x104fe2000000003bULL,
0x0000001615207223ULL, 0x000fe20000010020ULL, 0x00005410ff157816ULL, 0x000fc6000000003bULL,
0x0000004b14137223ULL, 0x082fe20000010013ULL, 0x00007610ff147816ULL, 0x100fe2000000003fULL,
0x0000004b152c7223ULL, 0x000fe2000001002cULL, 0x00005410ff157816ULL, 0x000fc6000000003fULL,
0x0000004b14117223ULL, 0x080fe20000010011ULL, 0x00007610ff147816ULL, 0x100fe20000000041ULL,
0x0000004b15127223ULL, 0x000fe20000010012ULL, 0x00005410ff157816ULL, 0x000fc60000000041ULL,
0x0000004b140f7223ULL, 0x080fe2000001000fULL, 0x00007610ff147816ULL, 0x100fe20000000043ULL,
0x0000004b15107223ULL, 0x000fe20000010010ULL, 0x00005410ff157816ULL, 0x000fc60000000043ULL,
0x0000004b140d7223ULL, 0x080fe2000001000dULL, 0x00007610ff147816ULL, 0x108fe20000000045ULL,
0x0000004b150e7223ULL, 0x000fe2000001000eULL, 0x00005410ff157816ULL, 0x000fc60000000045ULL,
0x0000004b140b7223ULL, 0x080fe2000001000bULL, 0x00007610ff147816ULL, 0x110fe20000000047ULL,
0x0000004b150c7223ULL, 0x000fe2000001000cULL, 0x00005410ff157816ULL, 0x000fc60000000047ULL,
0x0000004b14097223ULL, 0x080fe20000010009ULL, 0x00007610ff147816ULL, 0x120fe2000000003dULL,
0x0000004b150a7223ULL, 0x000fe2000001000aULL, 0x00005410ff157816ULL, 0x000fc6000000003dULL,
0x0000004b14077223ULL, 0x080fe20000010007ULL, 0x00007610ff147816ULL, 0x100fe20000000049ULL,
0x0000004b15087223ULL, 0x000fe20000010008ULL, 0x00005410ff157816ULL, 0x000fc60000000049ULL,
0x0000004b14057223ULL, 0x080fe40000010005ULL, 0x0000004b15067223ULL, 0x000fe20000010006ULL,
0xfffff34000008947ULL, 0x000fea000383ffffULL, 0x0180000030037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000e93000147802ULL, 0x000fe40000000f00ULL,
0x0000a2c000007944ULL, 0x002fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003000037308ULL, 0x000ea40000001000ULL, 0xbf80000003047423ULL, 0x004fc80000000030ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403037223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000157919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000815187811ULL, 0x050fe400078ff0ffULL,
0x00000002ff167819ULL, 0x000fe20000011615ULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x00000018ff177212ULL, 0x000fe200078e33ffULL, 0x00001f1803147589ULL, 0x00cea200000e0000ULL,
0x00000008181c7824ULL, 0x002fc400078e00ffULL, 0x00000008161a7824ULL, 0x000fe200078e00ffULL,
0x00001f1603047589ULL, 0x0002e400000e0000ULL, 0xfffffff81c337812ULL, 0x000fca00078ee217ULL,
0x0000001033337824ULL, 0x000fe200078e0202ULL, 0x00000016ff037212ULL, 0x002fc800078e33ffULL,
0xfffffff81a2d7812ULL, 0x000fe200078ee203ULL, 0x0000000816037824ULL, 0x000fc800078e00ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0202ULL, 0xfffffff803037812ULL, 0x000fe200078ee216ULL,
0x0000000614067220ULL, 0x044fe40000410000ULL, 0x0000000514057220ULL, 0x000fe40000410000ULL,
0x0000002f042f7220ULL, 0x048fe40000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x000000060505723eULL, 0x000fe200000010ffULL, 0x0000002b042b7220ULL, 0x000fe20000410000ULL,
0x0000000716067812ULL, 0x000fe200078ec0ffULL, 0x0000002a042a7220ULL, 0x000fe20000410000ULL,
0x0000002f2e2e723eULL, 0x000fe200000010ffULL, 0x0000002904297220ULL, 0x000fe20000410000ULL,
0x0000000106177812ULL, 0x000fe200078e3cffULL, 0x0000002804287220ULL, 0x000fe20000410000ULL,
0x0000000206197812ULL, 0x000fe200078e3cffULL, 0x0000002704277220ULL, 0x000fe20000410000ULL,
0x00000003061b7812ULL, 0x000fe200078e3cffULL, 0x0000002604267220ULL, 0x000fe20000410000ULL,
0x00000004061d7812ULL, 0x000fe200078e3cffULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x0000002404247220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000010ffULL, 0x0000002304237220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x0000002204227220ULL, 0x000fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000010ffULL, 0x0000002104217220ULL, 0x000fc40000410000ULL,
0x0000002004207220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000001e04047220ULL, 0x000fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000010ffULL, 0x0000000814087220ULL, 0x000fe20000410000ULL,
0x0000000606217812ULL, 0x000fe200078e3cffULL, 0x0000000714077220ULL, 0x000fe20000410000ULL,
0x0000001f0404723eULL, 0x000fe200000010ffULL, 0x0000000816177824ULL, 0x000fe200078e0217ULL,
0x00000005061f7812ULL, 0x000fe200078e3cffULL, 0x0000000818237824ULL, 0x000fe200078e00ffULL,
0x000000080707723eULL, 0x000fe200000010ffULL, 0x0000000816197824ULL, 0x000fe200078e0219ULL,
0x0000000718087812ULL, 0x000fe200078ec0ffULL, 0x00000008161b7824ULL, 0x040fe200078e021bULL,
0x0000000c15067812ULL, 0x000fe200078ec0ffULL, 0x00000008161d7824ULL, 0x000fe200078e021dULL,
0x0000000108257812ULL, 0x040fe200078e3cffULL, 0x0000001003037824ULL, 0x100fe200078e0202ULL,
0x0000000208277812ULL, 0x000fe200078e3cffULL, 0x00000008161f7824ULL, 0x000fe200078e021fULL,
0x0000000308297812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x00000004082b7812ULL, 0x000fe200078e3cffULL, 0x0000000816217824ULL, 0x000fe200078e0221ULL,
0x00000005082f7812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x0000000608317812ULL, 0x000fe200078e3cffULL, 0x000000101b1b7824ULL, 0x000fe200078e0202ULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x0000000103037824ULL, 0x000fc400078e0206ULL,
0x000000101d1d7824ULL, 0x100fe400078e0202ULL, 0x0000000818257824ULL, 0x000fe200078e0225ULL,
0x0000002e03007388ULL, 0x0003e20000000800ULL, 0x000000101f1f7824ULL, 0x100fe400078e0202ULL,
0x0000000106177824ULL, 0x000fe400078e0217ULL, 0x0000000818277824ULL, 0x000fe400078e0227ULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x0000002a17007388ULL, 0x0003e20000000800ULL,
0x0000000106197824ULL, 0x000fc400078e0219ULL, 0x0000002c142c7220ULL, 0x040fe40000410000ULL,
0x0000001314137220ULL, 0x000fe20000410000ULL, 0x0000002819007388ULL, 0x0003e20000000800ULL,
0x0000000818297824ULL, 0x040fe400078e0229ULL, 0x00000008182b7824ULL, 0x040fe200078e022bULL,
0x0000002c1313723eULL, 0x000fe200000010ffULL, 0x00000008182f7824ULL, 0x040fe400078e022fULL,
0x0000000818317824ULL, 0x000fc400078e0231ULL, 0x00000001061b7824ULL, 0x000fe400078e021bULL,
0x0000001214127220ULL, 0x040fe40000410000ULL, 0x0000001114117220ULL, 0x040fe20000410000ULL,
0x000000261b007388ULL, 0x0003e20000000800ULL, 0x0000000a140a7220ULL, 0x040fe40000410000ULL,
0x0000000914097220ULL, 0x000fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000001023237824ULL, 0x000fc400078e0202ULL, 0x00000001061d7824ULL, 0x000fe200078e021dULL,
0x0000000a0909723eULL, 0x000fe200000010ffULL, 0x0000001014107220ULL, 0x040fe40000410000ULL,
0x0000000f140f7220ULL, 0x040fe20000410000ULL, 0x000000241d007388ULL, 0x0003e20000000800ULL,
0x0000000c140c7220ULL, 0x040fe40000410000ULL, 0x0000000b140b7220ULL, 0x000fe20000410000ULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x0000001025257824ULL, 0x000fc400078e0202ULL,
0x00000001061f7824ULL, 0x000fe200078e021fULL, 0x0000000c0b0b723eULL, 0x000fe200000010ffULL,
0x0000000e140e7220ULL, 0x040fe40000410000ULL, 0x0000000d140d7220ULL, 0x000fe20000410000ULL,
0x000000221f007388ULL, 0x0003e20000000800ULL, 0x0000001027277824ULL, 0x100fe400078e0202ULL,
0x0000000106217824ULL, 0x000fe200078e0221ULL, 0x0000000e0d0d723eULL, 0x000fe200000010ffULL,
0x0000001029297824ULL, 0x000fc400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0x0000002021007388ULL, 0x0003e20000000800ULL, 0x000000102f2f7824ULL, 0x100fe400078e0202ULL,
0x0000001031317824ULL, 0x000fe400078e0202ULL, 0x00000001062d7824ULL, 0x040fe400078e022dULL,
0x0000000106027824ULL, 0x040fe400078e0223ULL, 0x0000000106087824ULL, 0x040fe200078e0225ULL,
0x000000042d007388ULL, 0x0003e20000000800ULL, 0x00000001060a7824ULL, 0x000fc400078e0227ULL,
0x00000001060c7824ULL, 0x040fe200078e0229ULL, 0x0000001302007388ULL, 0x0003e20000000800ULL,
0x00000001060e7824ULL, 0x040fe400078e022bULL, 0x0000000106127824ULL, 0x040fe200078e0233ULL,
0x0000001108007388ULL, 0x0003e20000000800ULL, 0x0000000106107824ULL, 0x040fe400078e022fULL,
0x0000000106067824ULL, 0x000fe200078e0231ULL, 0x0000000f0a007388ULL, 0x0003e80000000800ULL,
0x0000000d0c007388ULL, 0x0003e80000000800ULL, 0x0000000b0e007388ULL, 0x0003e80000000800ULL,
0x0000000910007388ULL, 0x0003e80000000800ULL, 0x0000000706007388ULL, 0x0003e80000000800ULL,
0x0000000512007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000057919ULL, 0x012e620000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000047919ULL, 0x000f620000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020050d7810ULL, 0x002fc60007ffe0ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x00000003ff067819ULL, 0x000fe40000011605ULL,
0x00000003ff027819ULL, 0x000fe2000001160dULL, 0x00000008040f7824ULL, 0x020fe200078e00ffULL,
0x0000000706087812ULL, 0x008fe400078e4805ULL, 0x0000000702037812ULL, 0x000fe400078e480dULL,
0x0ffffff808077812ULL, 0x000fe400078ef805ULL, 0x0ffffff803037812ULL, 0x000fc400078ef80dULL,
0xfffffff80f027812ULL, 0x000fe200078ee202ULL, 0x0000001007087824ULL, 0x100fe200078e0200ULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x000fe400078e0200ULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x1ffffff80d0d7812ULL, 0x000fe200078ef838ULL,
0x0120000008087984ULL, 0x000e660000000c00ULL, 0xfffffff807007812ULL, 0x000fe200078ee206ULL,
0x0120000003107984ULL, 0x0007220000000c00ULL, 0x0000000705077812ULL, 0x000fc400078ec0ffULL,
0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402007c10ULL, 0x000fe4000ff3e0ffULL,
0x1ffffff807077812ULL, 0x000fe200078ef838ULL, 0x000000ffff037224ULL, 0x008fe200000e06ffULL,
0x00005a0006027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fe400078248ffULL, 0x00005b0006037a11ULL, 0x000fc400000f4c03ULL,
0x00005b0000057a11ULL, 0x000fc600008f4c05ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000042f037824ULL, 0x000fe400078e022dULL, 0xffffffffff9f7424ULL, 0x000fc600078e00ffULL,
0x000000780300720cULL, 0x000fda0003f06070ULL, 0x0000000221088824ULL, 0x000fc800078e00ffULL,
0x0000640008088a24ULL, 0x000fc800078e0203ULL, 0x0000600008088625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006089f8981ULL, 0x000ea2000c1e1900ULL,
0x000000012f057810ULL, 0x000fe20007ffe0ffULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000402d047824ULL, 0x000fe200078e00ffULL, 0x01c60000ff067f8cULL, 0x000e62000c80043fULL,
0x000000020500720cULL, 0x000fc60003f06070ULL, 0x000000049f057c24ULL, 0x004fd4000f8e02ffULL,
0x00000e8000008947ULL, 0x000fea0003800000ULL, 0x000001002f087824ULL, 0x002fe200078e0204ULL,
0x00000003ff1d7819ULL, 0x100fe40000011620ULL, 0x000000700d1f7812ULL, 0x000fe400078ec0ffULL,
0x000000082b097217ULL, 0x000fe20007800000ULL, 0x00000040001e7824ULL, 0x000fe200078e021dULL,
0x000000041d0b7810ULL, 0x040fe40007ffe0ffULL, 0x000000071d0d7812ULL, 0x000fe200078e4820ULL,
0x00000001090e7824ULL, 0x000fe200078e0a08ULL, 0x000000081d097810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0f7824ULL, 0x040fe200078e00ffULL, 0x000000200b087212ULL, 0x000fc400078e3cffULL,
0x00000020090a7212ULL, 0x040fe200078e3cffULL, 0x0000000809117824ULL, 0x000fe200078e00ffULL,
0x0000000e0b00720cULL, 0x000fe40003f86070ULL, 0x0000000c1d0b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80f147812ULL, 0x000fe400078ee208ULL, 0xfffffff811167812ULL, 0x000fe200078ee20aULL,
0x000000080b187824ULL, 0x000fe200078e00ffULL, 0x000000101d117810ULL, 0x000fc40007ffe0ffULL,
0x000000041e087810ULL, 0x000fe40007ffe0ffULL, 0x0000000e0900720cULL, 0x000fe20003f66070ULL,
0x0000000811137824ULL, 0x000fe200078e00ffULL, 0x000000200b097212ULL, 0x040fe400078e3cffULL,
0x0000000e0b00720cULL, 0x000fe40003f46070ULL, 0x0000001e050c7210ULL, 0x040fe40007f1e0ffULL,
0x00000008050b7210ULL, 0x000fc40007fbe0ffULL, 0x0000002011107212ULL, 0x000fe200078e3cffULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x000000ffff087224ULL, 0x000fe200028e06ffULL, 0x00005e000c097a11ULL, 0x000fe400078248ffULL,
0x00005e000b0a7a11ULL, 0x000fe400078a48ffULL, 0xfffffff8131a7812ULL, 0x000fe400078ee210ULL,
0x000000081e107810ULL, 0x000fc40007ffe0ffULL, 0x00005f000c0c7a11ULL, 0x000fe400008f4c0fULL,
0x00005f000b0b7a11ULL, 0x000fe400028f4c08ULL, 0x0ffffff80d127812ULL, 0x000fe400078ef820ULL,
0x000000091f087210ULL, 0x000fe40007f3e0ffULL, 0x00000010050d7210ULL, 0x000fe40007fde0ffULL,
0x0000000e1100720cULL, 0x080fe20003f06070ULL, 0x000000ffff097224ULL, 0x000fe200008e060cULL,
0x000000141d117810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200030e06ffULL,
0x0000000e1d00720cULL, 0x000fc40003fa6070ULL, 0x00005e000d0c7a11ULL, 0x000fe200078c48ffULL,
0x00000008111c7824ULL, 0x000fe200078e00ffULL, 0x0000000a1f0a7210ULL, 0x000fe40007f3e0ffULL,
0x000020002d0f7811ULL, 0x000fe400078e70ffULL, 0x00005f000d0d7a11ULL, 0x000fe200030f4c10ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000002011137212ULL, 0x000fe400078e3cffULL,
0x0000000c1e107810ULL, 0x000fc40007ffe0ffULL, 0x0000000e1100720cULL, 0x000fe20003f26070ULL,
0x0000001012117824ULL, 0x000fe200078e020fULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee213ULL,
0x0000001014137824ULL, 0x000fe200078e020fULL, 0x0000001005107210ULL, 0x000fe40007fde0ffULL,
0x000000181d157810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e2000e901c46ULL, 0x0000001c1d177810ULL, 0x000fe40007ffe0ffULL,
0x0000000c1f0c7210ULL, 0x000fe20007fbe0ffULL, 0x000000000a137faeULL, 0x0005e2000e101c46ULL,
0x0000002015127212ULL, 0x000fc400078e3cffULL, 0x0000000e1500720cULL, 0x040fe20003f86070ULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0x0000002017147212ULL, 0x040fe200078e3cffULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000000e1700720cULL, 0x040fe20003fa6070ULL,
0x000000ffff097224ULL, 0x002fe200030e06ffULL, 0x00005e0010087a11ULL, 0x000fe200078c48ffULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0xfffffff815227812ULL, 0x000fe200078ee212ULL,
0x00000010160b7824ULL, 0x004fe200078e020fULL, 0x00005f0010097a11ULL, 0x000fc400030f4c09ULL,
0x000000081f087210ULL, 0x000fe40007fde0ffULL, 0x000000101e107810ULL, 0x040fe20007ffe0ffULL,
0x000000000c0b7faeULL, 0x0003e2000d901c46ULL, 0x000000141e127810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0xfffffff811247812ULL, 0x000fe200078ee214ULL,
0x0000001018117824ULL, 0x000fe200078e020fULL, 0x0000001005107210ULL, 0x000fe40007f7e0ffULL,
0x000000201d137810ULL, 0x000fc40007ffe0ffULL, 0x0000001205127210ULL, 0x000fe20007fde0ffULL,
0x0000000008117faeULL, 0x0005e2000d101c46ULL, 0x00000020130a7212ULL, 0x040fe200078e3cffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x0000000e1300720cULL, 0x040fe20003f46070ULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x00005e0010147a11ULL, 0x000fe200078648ffULL,
0x000000ffff0d7224ULL, 0x002fe200030e06ffULL, 0x00005e00120b7a11ULL, 0x000fe400078c48ffULL,
0x00005f00100c7a11ULL, 0x000fc400018f4c15ULL, 0xfffffff813107812ULL, 0x000fe400078ee20aULL,
0x000000141f087210ULL, 0x004fe40007f7e0ffULL, 0x00005f0012117a11ULL, 0x000fe400030f4c0dULL,
0x000000181e0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200018e060cULL,
0x000000241d0d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a05197210ULL, 0x000fc40007fde0ffULL,
0x0000000b1f0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000080d137824ULL, 0x040fe200078e00ffULL,
0x000000200d0c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff147224ULL, 0x000fe200030e06ffULL,
0x00005e0019167a11ULL, 0x000fe200078c48ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e0611ULL,
0xfffffff813127812ULL, 0x000fe200078ee20cULL, 0x000000101a117824ULL, 0x100fe200078e020fULL,
0x0000001c1e0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101c137824ULL, 0x000fe200078e020fULL,
0x00005f0019197a11ULL, 0x000fc400030f4c14ULL, 0x0000002c1d157810ULL, 0x000fe20007ffe0ffULL,
0x0000000008117faeULL, 0x0003e2000c101c46ULL, 0x0000000e0d00720cULL, 0x000fe40003f66070ULL,
0x0000000c05177210ULL, 0x000fe20007fde0ffULL, 0x000000000a137faeULL, 0x0005e2000c901c46ULL,
0x000000281d0d7810ULL, 0x000fe40007ffe0ffULL, 0x000000161f0c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x0000002015167212ULL, 0x080fe200078e3cffULL,
0x000000080d1b7824ULL, 0x040fe200078e00ffULL, 0x000000200d147212ULL, 0x000fe200078e3cffULL,
0x0000000815097824ULL, 0x002fe200078e00ffULL, 0x0000000e0d00720cULL, 0x000fe20003f26070ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0619ULL, 0x00005e0017087a11ULL, 0x000fe200078c48ffULL,
0x00000010220b7824ULL, 0x104fe200078e020fULL, 0xfffffff809167812ULL, 0x000fe200078ee216ULL,
0x0000001024117824ULL, 0x000fe200078e020fULL, 0x000000201e0a7810ULL, 0x000fc40007ffe0ffULL,
0x00005f0017097a11ULL, 0x000fe200030f4c18ULL, 0x000000000c0b7faeULL, 0x0003e2000e101c46ULL,
0x000000081f087210ULL, 0x000fe40007fde0ffULL, 0x0000000a05187210ULL, 0x000fe40007f9e0ffULL,
0x000000301d137810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x000000241e0a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81b147812ULL, 0x000fe200078ee214ULL,
0x000000ffff1b7224ULL, 0x000fe200020e06ffULL, 0x00005e0018197a11ULL, 0x000fe200078848ffULL,
0x0000000008117faeULL, 0x0005e2000e901c46ULL, 0x0000000a05177210ULL, 0x000fe20007fde0ffULL,
0x00000008130a7824ULL, 0x000fe200078e00ffULL, 0x0000000e1500720cULL, 0x000fc40003f06070ULL,
0x0000002013157212ULL, 0x040fe200078e3cffULL, 0x000000ffff0c7224ULL, 0x002fe200030e06ffULL,
0x0000000e1300720cULL, 0x000fe40003fa6070ULL, 0x00005f0018137a11ULL, 0x000fe400020f4c1bULL,
0x00005e00170b7a11ULL, 0x000fe400078c48ffULL, 0x000000191f087210ULL, 0x004fe40007f9e0ffULL,
0xfffffff80a187812ULL, 0x000fc400078ee215ULL, 0x000000281e0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0613ULL, 0x00005f0017117a11ULL, 0x000fe400030f4c0cULL,
0x0000000a05137210ULL, 0x000fe40007fde0ffULL, 0x000000341d0d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000b1f0a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x00005e0013157a11ULL, 0x000fe200078c48ffULL, 0x000000080d177824ULL, 0x040fe200078e00ffULL,
0x000000200d0c7212ULL, 0x040fe200078e3cffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0611ULL,
0x0000000e0d00720cULL, 0x000fe20003f86070ULL, 0x0000001010117824ULL, 0x100fe200078e020fULL,
0x00005f00130d7a11ULL, 0x000fe200030f4c1cULL, 0x0000001012137824ULL, 0x000fe200078e020fULL,
0xfffffff8171a7812ULL, 0x000fc400078ee20cULL, 0x0000002c1e0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000008117faeULL, 0x0003e2000d101c46ULL, 0x000000381d177810ULL, 0x040fe40007ffe0ffULL,
0x0000003c1d197810ULL, 0x000fe20007ffe0ffULL, 0x000000000a137faeULL, 0x0005e2000d901c46ULL,
0x0000000c05127210ULL, 0x000fe40007f7e0ffULL, 0x000000151f0c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001014157824ULL, 0x000fe200078e020fULL, 0x00005e0012107a11ULL, 0x000fe200078c48ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x0000000e1700720cULL, 0x000fe20003f66070ULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000301e087810ULL, 0x002fe20007ffe0ffULL,
0x0000000819117824ULL, 0x000fe200078e00ffULL, 0x0000002017097212ULL, 0x000fc400078e3cffULL,
0x000000000c157faeULL, 0x0003e2000c901c46ULL, 0x00000008050a7210ULL, 0x004fe40007f3e0ffULL,
0x0000000e1900720cULL, 0x000fe20003f46070ULL, 0x00000008170e7824ULL, 0x000fe200078e00ffULL,
0x0000002019207212ULL, 0x000fe200078e3cffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x00005f00120b7a11ULL, 0x000fe400030f4c1bULL, 0x00005e000a127a11ULL, 0x000fe400078c48ffULL,
0x000000101f087210ULL, 0x000fc40007f3e0ffULL, 0x00005f000a197a11ULL, 0x000fe400030f4c19ULL,
0x000000341e0a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x000000ffff097224ULL, 0x000fe200008e060bULL, 0x0000000a05147210ULL, 0x040fe20007f3e0ffULL,
0x00000010160b7824ULL, 0x100fe200078e020fULL, 0x000000381e0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000100e137824ULL, 0x000fe200078e020fULL, 0x0000003c1e107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x00005e00140a7a11ULL, 0x000fe200078248ffULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x0000000c050d7210ULL, 0x000fc40007f1e0ffULL,
0x00005f0014147a11ULL, 0x000fe400008f4c17ULL, 0xfffffff811207812ULL, 0x000fe200078ee220ULL,
0x000000101a117824ULL, 0x100fe200078e020fULL, 0x0000001005107210ULL, 0x000fe20007fde0ffULL,
0x0000001018057824ULL, 0x100fe400078e020fULL, 0x0000001020157824ULL, 0x000fe200078e020fULL,
0x000000121f087210ULL, 0x002fe20007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078048ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x00005e00100e7a11ULL, 0x000fe200078c48ffULL, 0x000000ffff097224ULL, 0x000fe200008e0619ULL,
0x0000000a1f0a7210ULL, 0x000fc40007f3e0ffULL, 0x00005f000d0d7a11ULL, 0x000fe400000f4c12ULL,
0x0000000c1f0c7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0614ULL,
0x00005f00100f7a11ULL, 0x000fe200030f4c0fULL, 0x0000000008057faeULL, 0x0003e2000e901c46ULL,
0x0000000e1f0e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe400000e060dULL,
0x000000000a117faeULL, 0x0003e4000e101c46ULL, 0x000000ffff0f7224ULL, 0x000fc400008e060fULL,
0x000000000c137faeULL, 0x0003e8000d901c46ULL, 0x000000000e157faeULL, 0x0003e2000d101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x002fc80000011620ULL,
0x00000004090b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c09117810ULL, 0x040fe40007ffe0ffULL,
0x00000008090f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b157824ULL, 0x000fe200078e00ffULL,
0x0000001009137810ULL, 0x000fe20007ffe0ffULL, 0x0000000811187824ULL, 0x000fe200078e00ffULL,
0x000000200b087212ULL, 0x080fe400078e3cffULL, 0x000000200f0a7212ULL, 0x0c0fe200078e3cffULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x00000020110b7212ULL, 0x000fc400078e3cffULL,
0x00000020130c7212ULL, 0x040fe200078e3cffULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe400078ee20bULL, 0xfffffff80f147812ULL, 0x000fe400078ee20aULL,
0x00000014090b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c09117810ULL, 0x040fe40007ffe0ffULL,
0x00000018090f7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8131c7812ULL, 0x000fe200078ee20cULL,
0x0000000811287824ULL, 0x000fe200078e00ffULL, 0xfffffff815107812ULL, 0x000fe200078ee208ULL,
0x000000080b157824ULL, 0x000fe200078e00ffULL, 0x0000002009137810ULL, 0x000fe40007ffe0ffULL,
0x000000200b087212ULL, 0x080fe400078e3cffULL, 0x000000200f0a7212ULL, 0x0c0fe200078e3cffULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x00000020110b7212ULL, 0x000fc400078e3cffULL,
0x00000020130c7212ULL, 0x040fe200078e3cffULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe400078ee20bULL, 0xfffffff80f247812ULL, 0x000fe400078ee20aULL,
0x00000024090b7810ULL, 0x040fe40007ffe0ffULL, 0x00000028090f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8132c7812ULL, 0x000fc400078ee20cULL, 0xfffffff815227812ULL, 0x000fe200078ee208ULL,
0x000000080b157824ULL, 0x000fe200078e00ffULL, 0x0000002c09117810ULL, 0x040fe40007ffe0ffULL,
0x0000003009137810ULL, 0x000fe40007ffe0ffULL, 0x000000200f0a7212ULL, 0x0c0fe200078e3cffULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x000000200b087212ULL, 0x080fe200078e3cffULL,
0x0000000811347824ULL, 0x000fe200078e00ffULL, 0x00000020130c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x00000020110b7212ULL, 0x000fc400078e3cffULL,
0xfffffff815307812ULL, 0x000fe200078ee208ULL, 0x0000004000087824ULL, 0x000fe200078e0209ULL,
0xfffffff80f327812ULL, 0x000fe400078ee20aULL, 0x00000034090f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff834347812ULL, 0x000fe400078ee20bULL, 0xfffffff813367812ULL, 0x000fe200078ee20cULL,
0x000000080f157824ULL, 0x000fe200078e00ffULL, 0x00000007090b7812ULL, 0x000fc400078e4820ULL,
0x0000003809117810ULL, 0x040fe40007ffe0ffULL, 0x0000003c09137810ULL, 0x000fe40007ffe0ffULL,
0x0000000805097210ULL, 0x000fe20007f1e0ffULL, 0x00000008113e7824ULL, 0x000fe200078e00ffULL,
0x000000200f0e7212ULL, 0x000fe400078e3cffULL, 0x0ffffff80b0c7812ULL, 0x000fe200078ef820ULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005e00090b7a11ULL, 0x000fc400078048ffULL,
0xfffffff8153a7812ULL, 0x000fe400078ee20eULL, 0x00000004080e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c08167810ULL, 0x040fe40007ffe0ffULL, 0x00000010081a7810ULL, 0x040fe40007ffe0ffULL,
0x00005f00090a7a11ULL, 0x000fe400000f4c0aULL, 0x0000000808127810ULL, 0x000fc40007ffe0ffULL,
0x0000000e050e7210ULL, 0x000fe40007f1e0ffULL, 0x00000020110f7212ULL, 0x080fe400078e3cffULL,
0x0000002013207212ULL, 0x040fe200078e3cffULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0x0000001605167210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x0000001a051a7210ULL, 0x040fe40007f7e0ffULL, 0x0000001205127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20fULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x00005e000e0f7a11ULL, 0x000fc400078048ffULL,
0xfffffff813427812ULL, 0x000fe200078ee220ULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x00005e0016197a11ULL, 0x000fe400078448ffULL, 0x00005e001a1d7a11ULL, 0x000fe400078648ffULL,
0x00005e0012157a11ULL, 0x000fe400078248ffULL, 0x00005f000e117a11ULL, 0x000fe400000f4c09ULL,
0x00000014080e7810ULL, 0x000fc40007ffe0ffULL, 0x00005f0016177a11ULL, 0x000fe400010f4c17ULL,
0x00005f001a1b7a11ULL, 0x000fe400018f4c1bULL, 0x0000001c08167810ULL, 0x040fe40007ffe0ffULL,
0x00000020081a7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0012137a11ULL, 0x000fe400008f4c13ULL,
0x0000001808127810ULL, 0x000fc40007ffe0ffULL, 0x0000000e050e7210ULL, 0x040fe40007f1e0ffULL,
0x0000001605167210ULL, 0x040fe40007f5e0ffULL, 0x0000001a051a7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000001205127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff257224ULL, 0x000fe200010e06ffULL, 0x00005e000e1f7a11ULL, 0x000fe200078048ffULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x00005e0016377a11ULL, 0x000fe200078448ffULL,
0x000000ffff237224ULL, 0x000fe200008e06ffULL, 0x00005e001a3b7a11ULL, 0x000fc400078648ffULL,
0x00005e0012337a11ULL, 0x000fe400078248ffULL, 0x00005f000e1e7a11ULL, 0x000fe400000f4c09ULL,
0x00000024080e7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0016267a11ULL, 0x000fe400010f4c25ULL,
0x00005f001a2a7a11ULL, 0x000fe400018f4c27ULL, 0x0000002c08167810ULL, 0x000fc40007ffe0ffULL,
0x00000030081a7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0012207a11ULL, 0x000fe400008f4c23ULL,
0x0000002808127810ULL, 0x040fe40007ffe0ffULL, 0x0000000e050e7210ULL, 0x040fe40007f7e0ffULL,
0x0000001605167210ULL, 0x040fe40007f1e0ffULL, 0x0000001a051a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200018e06ffULL, 0x000020002d097811ULL, 0x000fe200078e70ffULL,
0x000000ffff497224ULL, 0x000fe200000e06ffULL, 0x00000034082e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4f7224ULL, 0x000fe200008e06ffULL, 0x0000001205127210ULL, 0x040fe20007f5e0ffULL,
0x0000001028397824ULL, 0x100fe200078e0209ULL, 0x00000038083c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001014257824ULL, 0x100fe200078e0209ULL, 0x0000003c08087810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200010e06ffULL, 0x00005e000e3f7a11ULL, 0x000fe200078c48ffULL,
0x0000001018277824ULL, 0x100fe200078e0209ULL, 0x0000002e05387210ULL, 0x040fe20007f7e0ffULL,
0x000000101c297824ULL, 0x100fe200078e0209ULL, 0x00005e00164b7a11ULL, 0x000fe200078048ffULL,
0x0000001022317824ULL, 0x100fe200078e0209ULL, 0x00005e001a517a11ULL, 0x000fe200078248ffULL,
0x0000001024357824ULL, 0x100fe200078e0209ULL, 0x0000003c053c7210ULL, 0x000fe20007f9e0ffULL,
0x000000102c3d7824ULL, 0x100fe200078e0209ULL, 0x000000700d287812ULL, 0x000fe200078ec0ffULL,
0x0000001030417824ULL, 0x100fe200078e0209ULL, 0x0000000805407210ULL, 0x000fe20007fbe0ffULL,
0x000000100c057824ULL, 0x000fe200078e0209ULL, 0x00005f000e2e7a11ULL, 0x000fe200030f4c23ULL,
0x0000001010237824ULL, 0x100fe200078e0209ULL, 0x00005e0012457a11ULL, 0x000fe200078448ffULL,
0x0000001032477824ULL, 0x000fe200078e0209ULL, 0x00005f0016497a11ULL, 0x000fe200000f4c49ULL,
0x00000010344d7824ULL, 0x000fe200078e0209ULL, 0x00005f001a4f7a11ULL, 0x000fe200008f4c4fULL,
0x0000001036537824ULL, 0x100fe200078e0209ULL, 0x00005e0038557a11ULL, 0x000fe200078248ffULL,
0x000000103a577824ULL, 0x100fe200078e0209ULL, 0x0000000b28087210ULL, 0x000fe20007f1e0ffULL,
0x000000103e5b7824ULL, 0x000fe200078e0209ULL, 0x00005f0012437a11ULL, 0x000fe200010f4c43ULL,
0x0000001042617824ULL, 0x000fe200078e0209ULL, 0x00005e003c597a11ULL, 0x000fe200078448ffULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x00005e00405f7a11ULL, 0x000fe200078648ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0x0000001f28127210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff5d7224ULL, 0x000fe200028e06ffULL, 0x00005f0038387a11ULL, 0x000fe200008f4c09ULL,
0x000000ffff097224ULL, 0x000fe200000e060aULL, 0x00005f003c3c7a11ULL, 0x000fc400010f4c0dULL,
0x0000000f280a7210ULL, 0x000fe40007f3e0ffULL, 0x00005f00405d7a11ULL, 0x000fe200018f4c5dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000b901c46ULL,
0x00000015280c7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e0611ULL,
0x00000019280e7210ULL, 0x040fe40007f7e0ffULL, 0x0000001d28107210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0613ULL, 0x0000003328147210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0617ULL, 0x0000003728167210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e061bULL, 0x0000003b28187210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200020e061eULL, 0x0000003f281a7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e0620ULL, 0x00000045281c7210ULL, 0x040fe20007fbe0ffULL,
0x000000000a237faeULL, 0x0005e2000b901c46ULL, 0x0000004b281e7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0626ULL, 0x0000005128227210ULL, 0x040fe20007f1e0ffULL,
0x000000000c257faeULL, 0x0007e2000b901c46ULL, 0x0000005528247210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e062aULL, 0x0000005928267210ULL, 0x040fe20007f5e0ffULL,
0x000000000e277faeULL, 0x0009e2000b901c46ULL, 0x000000ffff1b7224ULL, 0x000fe200018e062eULL,
0x0000005f28287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e0643ULL,
0x0000000010297faeULL, 0x000be2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fc400020e0649ULL,
0x000000ffff237224ULL, 0x004fe200000e064fULL, 0x0000000012317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff257224ULL, 0x008fc600008e0638ULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff277224ULL, 0x010fc600010e063cULL, 0x0000000016397faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x020fc600018e065dULL, 0x00000000183d7faeULL, 0x0003e8000b901c46ULL,
0x000000001a417faeULL, 0x0003e8000b901c46ULL, 0x000000001c477faeULL, 0x0003e8000b901c46ULL,
0x000000001e4d7faeULL, 0x0003e8000b901c46ULL, 0x0000000022537faeULL, 0x0003e8000b901c46ULL,
0x0000000024577faeULL, 0x0003e8000b901c46ULL, 0x00000000265b7faeULL, 0x0003e8000b901c46ULL,
0x0000000028617faeULL, 0x0003e4000b901c46ULL, 0x01c60400ff057984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000005ff7812ULL, 0x002fc60007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff057424ULL, 0x000fc800078e00ffULL,
0x0000000500087305ULL, 0x0002a4000021f000ULL, 0x3fa0000005057823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x01c60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000022f00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x0000640021067a24ULL, 0x000fe200078e02ffULL,
0x0001c6882d077811ULL, 0x040fe200078e18ffULL, 0x000000202d097824ULL, 0x000fe200078e00ffULL,
0xffffffff02087810ULL, 0x000fe40007ffe0ffULL, 0x000001002f0a7824ULL, 0x000fe200078e0204ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000000a2b00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x014fea0003800000ULL, 0x000000012f0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000049f3a7c24ULL, 0x000fc6000f8e02ffULL, 0x000000020b00720cULL, 0x000fda0003f06070ULL,
0x00000d8000008947ULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x002fe20000011605ULL,
0x000000012b3b7824ULL, 0x000fe200078e0a0aULL, 0x0000000705b07812ULL, 0x000fe400078ec0ffULL,
0x000000040b0c7810ULL, 0x040fe40007ffe0ffULL, 0x000000080b0e7810ULL, 0x040fe40007ffe0ffULL,
0x000000050cad7212ULL, 0x0c0fe200078e3cffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x000000050eac7212ULL, 0x040fe200078e3cffULL, 0x000000080e0d7824ULL, 0x000fe200078e00ffULL,
0x000000100b127810ULL, 0x000fc40007ffe0ffULL, 0xfffffff810ad7812ULL, 0x000fe400078ee2adULL,
0x0000000c0b107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80dac7812ULL, 0x000fe200078ee2acULL,
0x00000008120d7824ULL, 0x000fe200078e00ffULL, 0x0000000510ab7212ULL, 0x0c0fe200078e3cffULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0x0000000512aa7212ULL, 0x000fe400078e3cffULL,
0x000000200b1a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff816ab7812ULL, 0x000fe400078ee2abULL,
0x000000180b167810ULL, 0x000fe20007ffe0ffULL, 0x000000081a0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80daa7812ULL, 0x000fe400078ee2aaULL, 0x0000000516a87212ULL, 0x0c0fe200078e3cffULL,
0x00000008160d7824ULL, 0x000fe200078e00ffULL, 0x000000051aa67212ULL, 0x000fe400078e3cffULL,
0x000000140b147810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80da87812ULL, 0x000fe200078ee2a8ULL,
0x00000040000d7824ULL, 0x000fe200078e020bULL, 0xfffffff80fa67812ULL, 0x000fe200078ee2a6ULL,
0x0000000814187824ULL, 0x040fe200078e00ffULL, 0x0000000514a97212ULL, 0x000fe400078e3cffULL,
0x000000040d0f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff818a97812ULL, 0x000fe400078ee2a9ULL,
0x0000003a0f117210ULL, 0x000fc40007f5e0ffULL, 0x0000001c0b187810ULL, 0x000fe40007ffe0ffULL,
0x0000003a0d137210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x00005e0011e27a11ULL, 0x000fe200078448ffULL, 0x00000008181c7824ULL, 0x040fe200078e00ffULL,
0x0000000518a77212ULL, 0x000fe200078e3cffULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0x000000280b1e7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0011e37a11ULL, 0x000fc400010f4c20ULL,
0x00005e0013e47a11ULL, 0x000fe200078248ffULL, 0x000000081e157824ULL, 0x000fe200078e00ffULL,
0x000000080d117810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81ca77812ULL, 0x000fe400078ee2a7ULL,
0x000000240b1c7810ULL, 0x000fe40007ffe0ffULL, 0x000000051ea47212ULL, 0x000fe400078e3cffULL,
0x00005f0013e57a11ULL, 0x000fe200008f4c22ULL, 0x000000081c247824ULL, 0x000fe200078e00ffULL,
0x000000140d177810ULL, 0x000fc40007ffe0ffULL, 0x0000003a111f7210ULL, 0x080fe40007f5e0ffULL,
0x0000000c0d137810ULL, 0x000fe40007ffe0ffULL, 0xfffffff815a47812ULL, 0x000fe200078ee2a4ULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x0000003a17197210ULL, 0x080fe40007f3e0ffULL,
0x000000051ca57212ULL, 0x000fe400078e3cffULL, 0x000000100d157810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200008e06ffULL, 0x0000003a131d7210ULL, 0x000fc40007f7e0ffULL,
0x00005e001fe07a11ULL, 0x000fe400078448ffULL, 0xfffffff824a57812ULL, 0x000fe200078ee2a5ULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x0000003a151b7210ULL, 0x000fe40007f9e0ffULL,
0x00005e0019da7a11ULL, 0x000fe400078248ffULL, 0x00005f001fe17a11ULL, 0x000fe200010f4c26ULL,
0x000000ffff227224ULL, 0x000fe200020e06ffULL, 0x00005e001dde7a11ULL, 0x000fc400078648ffULL,
0x000000240d1f7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0019db7a11ULL, 0x000fe400008f4c20ULL,
0x00005e001bdc7a11ULL, 0x000fe400078848ffULL, 0x00005f001ddf7a11ULL, 0x000fe400018f4c24ULL,
0x0000003a1f207210ULL, 0x000fe40007f3e0ffULL, 0x000000200d1d7810ULL, 0x000fc40007ffe0ffULL,
0x00005f001bdd7a11ULL, 0x000fe200020f4c22ULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x000000180d197810ULL, 0x000fe40007ffe0ffULL, 0x0000003a1d227210ULL, 0x080fe40007f9e0ffULL,
0x00005e0020d07a11ULL, 0x000fe400078248ffULL, 0x0000001c0d1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff237224ULL, 0x000fe200020e06ffULL, 0x0000003a19267210ULL, 0x000fc40007f5e0ffULL,
0x00005f0020d17a11ULL, 0x000fe400008f4c21ULL, 0x0000003a1b247210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200010e06ffULL, 0x00005e0022d47a11ULL, 0x000fe400078848ffULL,
0x000000050b207212ULL, 0x000fe200078e3cffULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x00005e0026d87a11ULL, 0x000fe400078448ffULL, 0x00005f0022d57a11ULL, 0x000fc400020f4c23ULL,
0x0000000720ae7812ULL, 0x000fe400078ec0ffULL, 0x0000003b0b00720cULL, 0x000fe40003f26070ULL,
0x000000300d227810ULL, 0x040fe40007ffe0ffULL, 0x00005e0024d67a11ULL, 0x000fe400078648ffULL,
0x000000340d237810ULL, 0x000fe40007ffe0ffULL, 0x00005f0026d97a11ULL, 0x000fc400010f4c27ULL,
0x000040002d2e7811ULL, 0x000fe400078e70ffULL, 0x00000008b03d7812ULL, 0x000fe400078efcffULL,
0x000000280d207810ULL, 0x000fe20007ffe0ffULL, 0x00000010ac377824ULL, 0x100fe200078e022eULL,
0x0ffffff8aeae7812ULL, 0x000fe200078ef805ULL, 0x00000010ab397824ULL, 0x100fe200078e022eULL,
0x0000002c0d217810ULL, 0x000fe20007ffe0ffULL, 0x00000010aa3f7824ULL, 0x100fe200078e022eULL,
0x0000003a22287210ULL, 0x080fe20007f5e0ffULL, 0x00000010ae277824ULL, 0x000fe200078e022eULL,
0x00005f0024d77a11ULL, 0x000fe200018f4c25ULL, 0x000000103d247825ULL, 0x000fe200078e00e4ULL,
0x0000003a23267210ULL, 0x000fc40007f7e0ffULL, 0x0000003a202c7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x0000003a212a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe200018e06ffULL, 0x00005e0028ca7a11ULL, 0x000fe200078448ffULL,
0x000000ffff357224ULL, 0x000fe200020e06ffULL, 0x00005e0026c67a11ULL, 0x000fe200078648ffULL,
0x000000ffff337224ULL, 0x000fe200028e06ffULL, 0x00005e002cce7a11ULL, 0x000fe200078848ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e2000c901c46ULL,
0x00005e002acc7a11ULL, 0x000fe200078a48ffULL, 0x00000010a9417824ULL, 0x000fe200078e022eULL,
0x00005f0028cb7a11ULL, 0x000fe200010f4c31ULL, 0x000000103d307825ULL, 0x000fe200078e00dcULL,
0x0000003b0c00720cULL, 0x000fc40003f26070ULL, 0x0000003b0e00720cULL, 0x080fe20003f46070ULL,
0x00000010a8437824ULL, 0x000fe200078e022eULL, 0x00005f0026c77a11ULL, 0x000fe200018f4c29ULL,
0x000000103d287825ULL, 0x000fe200078e00deULL, 0x00005f002ccf7a11ULL, 0x000fe400020f4c35ULL,
0x0000003b1000720cULL, 0x080fe20003f66070ULL, 0x00000010ad357824ULL, 0x000fe200078e022eULL,
0x00005f002acd7a11ULL, 0x000fe200028f4c33ULL, 0x000000103d247825ULL, 0x002fe200078e00e2ULL,
0x0000003b1200720cULL, 0x000fc40003f86070ULL, 0x0000003b1400720cULL, 0x080fe20003fa6070ULL,
0x000000103d267825ULL, 0x040fe200078e00e0ULL, 0x0000000024357faeULL, 0x0003e2000c901c46ULL,
0x0000003b1600720cULL, 0x080fe40003f26070ULL, 0x000000103d327825ULL, 0x000fe200078e00daULL,
0x0000000026377faeULL, 0x0005e2000d101c46ULL, 0x0000003b1800720cULL, 0x080fe40003f46070ULL,
0x000000380b2a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000028397faeULL, 0x0007e2000d901c46ULL,
0x0000003b1a00720cULL, 0x000fc40003f66070ULL, 0x0000003c0b2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000303f7faeULL, 0x0009e2000e101c46ULL, 0x0000003b1c00720cULL, 0x080fe20003f86070ULL,
0x00000010a7257824ULL, 0x102fe200078e022eULL, 0x0000002c0b247810ULL, 0x040fe20007ffe0ffULL,
0x0000000032417faeULL, 0x0003e2000e901c46ULL, 0x0000003b1e00720cULL, 0x000fe20003fa6070ULL,
0x00000010a6277824ULL, 0x004fe200078e022eULL, 0x000000300b267810ULL, 0x000fe20007ffe0ffULL,
0x000000103d347825ULL, 0x000fe200078e00d4ULL, 0x000000340b287810ULL, 0x008fc40007ffe0ffULL,
0x0000000526a27212ULL, 0x080fe200078e3cffULL, 0x000000103d307825ULL, 0x050fe200078e00d8ULL,
0x0000000524a37212ULL, 0x080fe400078e3cffULL, 0x0000000528a17212ULL, 0x080fe200078e3cffULL,
0x000000103d327825ULL, 0x002fe200078e00d6ULL, 0x0000000030437faeULL, 0x0003e2000c901c46ULL,
0x000000052aa07212ULL, 0x000fe400078e3cffULL, 0x00000010a5297824ULL, 0x000fe200078e022eULL,
0x0000000032257faeULL, 0x0005e2000d101c46ULL, 0x000000103d367825ULL, 0x000fe200078e00d0ULL,
0x0000003b2800720cULL, 0x000fc40003f46070ULL, 0x0000000034277faeULL, 0x0007e2000d901c46ULL,
0x00000010a43f7824ULL, 0x000fe200078e022eULL, 0x0000003b2600720cULL, 0x080fe20003f66070ULL,
0x000000103d387825ULL, 0x000fe200078e00ceULL, 0x0000000036297faeULL, 0x0009e2000e101c46ULL,
0x0000003b2400720cULL, 0x080fe40003f86070ULL, 0x000000082a317824ULL, 0x002fe200078e00ffULL,
0x000000380d257810ULL, 0x004fe20007ffe0ffULL, 0x00000000383f7faeULL, 0x0003e2000e901c46ULL,
0x0000000824327824ULL, 0x000fe200078e00ffULL, 0x0000003b2a00720cULL, 0x000fe20003f26070ULL,
0x000000082c347824ULL, 0x008fe200078e00ffULL, 0x0000003a25277210ULL, 0x000fc40007fbe0ffULL,
0xfffffff832a37812ULL, 0x000fe200078ee2a3ULL, 0x0000000826297824ULL, 0x010fe200078e00ffULL,
0x00005e0027c47a11ULL, 0x000fe200078c48ffULL, 0x000000ffff307224ULL, 0x000fe200028e06ffULL,
0x000000052c9f7212ULL, 0x000fe200078e3cffULL, 0x0000000828327824ULL, 0x000fe200078e00ffULL,
0xfffffff829a27812ULL, 0x000fe400078ee2a2ULL, 0x00005f0027c57a11ULL, 0x000fe400030f4c30ULL,
0x0000003c0d277810ULL, 0x000fc40007ffe0ffULL, 0x0000003b2c00720cULL, 0x000fe20003fa6070ULL,
0x00000010a23b7824ULL, 0x000fe200078e022eULL, 0x0000003a27297210ULL, 0x000fe20007fde0ffULL,
0x000000103d367825ULL, 0x000fe200078e00c4ULL, 0xfffffff832a17812ULL, 0x000fe400078ee2a1ULL,
0xfffffff831a07812ULL, 0x000fe200078ee2a0ULL, 0x000000ffff307224ULL, 0x000fe200030e06ffULL,
0x00005e0029c27a11ULL, 0x000fe200078c48ffULL, 0x000000103d327825ULL, 0x000fe200078e00caULL,
0xfffffff8349f7812ULL, 0x000fc400078ee29fULL, 0x00005f0029c37a11ULL, 0x000fe200030f4c30ULL,
0x00000010a3297824ULL, 0x000fe400078e022eULL, 0x000000103d307825ULL, 0x000fc800078e00ccULL,
0x00000010a13f7824ULL, 0x002fe200078e022eULL, 0x0000000030297faeULL, 0x0003e2000e101c46ULL,
0x000000103d347825ULL, 0x000fc600078e00c6ULL, 0x00000000323b7faeULL, 0x0003e2000d901c46ULL,
0x00000010a0417824ULL, 0x100fe400078e022eULL, 0x000000109f437824ULL, 0x000fe200078e022eULL,
0x00000000343f7faeULL, 0x0003e2000d101c46ULL, 0x000000103d387825ULL, 0x000fc600078e00c2ULL,
0x0000000036417faeULL, 0x0003e8000c901c46ULL, 0x0000000038437faeULL, 0x0003e2000e901c46ULL,
0x00000c6000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x002fe40000011605ULL,
0x0000000705b07812ULL, 0x000fe400078ec0ffULL, 0x000000040b0c7810ULL, 0x040fe40007ffe0ffULL,
0x000000080b0e7810ULL, 0x000fc40007ffe0ffULL, 0x000000050cad7212ULL, 0x0c0fe200078e3cffULL,
0x000000080c127824ULL, 0x000fe200078e00ffULL, 0x0000000c0b107810ULL, 0x040fe20007ffe0ffULL,
0x000000080e0d7824ULL, 0x040fe200078e00ffULL, 0x000000050eac7212ULL, 0x080fe400078e3cffULL,
0xfffffff812ad7812ULL, 0x000fe200078ee2adULL, 0x0000000810167824ULL, 0x040fe200078e00ffULL,
0x000000100b127810ULL, 0x000fe40007ffe0ffULL, 0x0000000510ab7212ULL, 0x000fc400078e3cffULL,
0x000000140b147810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80dac7812ULL, 0x000fe200078ee2acULL,
0x00000008120d7824ULL, 0x000fe200078e00ffULL, 0xfffffff816ab7812ULL, 0x000fe200078ee2abULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0x0000000512aa7212ULL, 0x080fe400078e3cffULL,
0x000000180b167810ULL, 0x000fe40007ffe0ffULL, 0x0000000514a97212ULL, 0x000fc400078e3cffULL,
0x0000001c0b187810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80daa7812ULL, 0x000fe200078ee2aaULL,
0x00000008160d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81aa97812ULL, 0x000fe200078ee2a9ULL,
0x00000008181e7824ULL, 0x000fe200078e00ffULL, 0x0000000516a87212ULL, 0x080fe400078e3cffULL,
0x000000200b1a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000518a77212ULL, 0x000fc400078e3cffULL,
0xfffffff80da87812ULL, 0x000fe200078ee2a8ULL, 0x000000081a0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81ea77812ULL, 0x000fe400078ee2a7ULL, 0x000000051aa67212ULL, 0x080fe400078e3cffULL,
0x000000280b1e7810ULL, 0x040fe40007ffe0ffULL, 0x000000240b1c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80da67812ULL, 0x000fe200078ee2a6ULL, 0x000000081e0d7824ULL, 0x040fe200078e00ffULL,
0x000000051ea47212ULL, 0x000fe200078e3cffULL, 0x000000081c207824ULL, 0x000fe200078e00ffULL,
0x000000300b267810ULL, 0x000fc40007ffe0ffULL, 0x000000051ca57212ULL, 0x080fe400078e3cffULL,
0x0000002c0b247810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80da47812ULL, 0x000fe200078ee2a4ULL,
0x00000008260d7824ULL, 0x040fe200078e00ffULL, 0x0000000526a27212ULL, 0x080fe400078e3cffULL,
0x000000380b2a7810ULL, 0x040fe40007ffe0ffULL, 0xfffffff820a57812ULL, 0x000fe200078ee2a5ULL,
0x0000000824207824ULL, 0x040fe200078e00ffULL, 0x0000000524a37212ULL, 0x000fe200078e3cffULL,
0x000000082a0f7824ULL, 0x000fe200078e00ffULL, 0x000000340b287810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80da27812ULL, 0x000fe200078ee2a2ULL, 0x00000040000d7824ULL, 0x000fe200078e020bULL,
0x000000052aa07212ULL, 0x080fe400078e3cffULL, 0xfffffff820a37812ULL, 0x000fe200078ee2a3ULL,
0x0000000828207824ULL, 0x040fe200078e00ffULL, 0x0000000528a17212ULL, 0x000fe400078e3cffULL,
0x0000003c0b2c7810ULL, 0x000fe40007ffe0ffULL, 0x0000003a0d137210ULL, 0x000fc40007f3e0ffULL,
0xfffffff80fa07812ULL, 0x000fe200078ee2a0ULL, 0x000000082c227824ULL, 0x000fe200078e00ffULL,
0x000000040d0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000080d117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff820a17812ULL, 0x000fe200078ee2a1ULL, 0x000000ffff207224ULL, 0x000fe200008e06ffULL,
0x000000052c9f7212ULL, 0x000fe400078e3cffULL, 0x00005e0013e47a11ULL, 0x000fc400078248ffULL,
0x0000003a0f177210ULL, 0x080fe40007f5e0ffULL, 0x0000003a11197210ULL, 0x000fe40007f7e0ffULL,
0xfffffff8229f7812ULL, 0x000fe400078ee29fULL, 0x00005f0013e57a11ULL, 0x000fe200008f4c20ULL,
0x000000ffff207224ULL, 0x000fe200010e06ffULL, 0x00005e0019e07a11ULL, 0x000fe200078448ffULL,
0x000000ffff227224ULL, 0x000fe200018e06ffULL, 0x00005e0017e27a11ULL, 0x000fc400078248ffULL,
0x000000100d157810ULL, 0x040fe40007ffe0ffULL, 0x0000000c0d137810ULL, 0x000fe40007ffe0ffULL,
0x00005f0019e17a11ULL, 0x000fe400010f4c22ULL, 0x00005f0017e37a11ULL, 0x000fe400008f4c20ULL,
0x0000003a151d7210ULL, 0x080fe40007f5e0ffULL, 0x0000003a131b7210ULL, 0x000fc40007f3e0ffULL,
0x000000180d197810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005e001ddc7a11ULL, 0x000fe200078448ffULL, 0x000000ffff207224ULL, 0x000fe200008e06ffULL,
0x00005e001bde7a11ULL, 0x000fe400078248ffULL, 0x000000140d177810ULL, 0x000fe40007ffe0ffULL,
0x00005f001ddd7a11ULL, 0x000fe400010f4c22ULL, 0x00005f001bdf7a11ULL, 0x000fc400008f4c20ULL,
0x0000003a19217210ULL, 0x080fe40007f5e0ffULL, 0x0000003a171f7210ULL, 0x000fe40007f3e0ffULL,
0x0000001c0d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005e0021d87a11ULL, 0x000fe200078448ffULL, 0x000000ffff207224ULL, 0x000fe200008e06ffULL,
0x00005e001fda7a11ULL, 0x000fe400078248ffULL, 0x000000200d1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000003a1b237210ULL, 0x080fe40007f7e0ffULL, 0x00005f0021d97a11ULL, 0x000fe400010f4c22ULL,
0x00005f001fdb7a11ULL, 0x000fe200008f4c20ULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x0000003a1d217210ULL, 0x000fe40007f5e0ffULL, 0x00005e0023d67a11ULL, 0x000fe400078248ffULL,
0x000000240d1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005e0021d47a11ULL, 0x000fc400078448ffULL, 0x00005f0023d77a11ULL, 0x000fe400008f4c20ULL,
0x0000003a1f237210ULL, 0x000fe40007f3e0ffULL, 0x000000280d207810ULL, 0x000fe40007ffe0ffULL,
0x00005f0021d57a11ULL, 0x000fe200010f4c22ULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0x0000002c0d217810ULL, 0x000fe40007ffe0ffULL, 0x00005e0023d07a11ULL, 0x000fc400078248ffULL,
0x0000003a20257210ULL, 0x080fe40007f5e0ffULL, 0x0000003a21277210ULL, 0x000fe40007f7e0ffULL,
0x00005f0023d17a11ULL, 0x000fe200008f4c22ULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x000000050b227212ULL, 0x000fe200078e3cffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005e0025ce7a11ULL, 0x000fe400078448ffULL, 0x00005e0027cc7a11ULL, 0x000fc400078248ffULL,
0x0000000722ae7812ULL, 0x000fe400078ec0ffULL, 0x000000300d227810ULL, 0x000fe40007ffe0ffULL,
0x00005f0025cf7a11ULL, 0x000fe400010f4c2eULL, 0x000000340d237810ULL, 0x000fe40007ffe0ffULL,
0x00005f0027cd7a11ULL, 0x000fe400008f4c30ULL, 0x000000380d257810ULL, 0x000fc40007ffe0ffULL,
0x0000003c0d277810ULL, 0x000fe40007ffe0ffULL, 0x0000003a22327210ULL, 0x080fe40007f5e0ffULL,
0x0000003a23347210ULL, 0x080fe40007f7e0ffULL, 0x0000003a25367210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff337224ULL, 0x000fe200010e06ffULL, 0x0000003a273a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff357224ULL, 0x000fe200018e06ffULL, 0x000040002d2e7811ULL, 0x000fe200078e70ffULL,
0x000000ffff377224ULL, 0x000fe200020e06ffULL, 0x00000008b0297812ULL, 0x000fe200078efcffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x0ffffff8aeae7812ULL, 0x000fe200078ef805ULL,
0x00000010ad3f7824ULL, 0x000fe200078e022eULL, 0x00005e0032ca7a11ULL, 0x000fe200078448ffULL,
0x0000001029307825ULL, 0x000fe200078e00e4ULL, 0x00005e0034c67a11ULL, 0x000fc400078648ffULL,
0x00005e0036c47a11ULL, 0x000fe200078848ffULL, 0x00000010ae3d7824ULL, 0x100fe200078e022eULL,
0x00005e003ac27a11ULL, 0x000fe200078248ffULL, 0x00000010ac417824ULL, 0x000fe200078e022eULL,
0x00005f0032cb7a11ULL, 0x000fe200010f4c33ULL, 0x0000001029327825ULL, 0x040fe200078e00e2ULL,
0x00005f0034c77a11ULL, 0x000fe200018f4c35ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303d7faeULL, 0x0003e2000b901c46ULL, 0x00005f0036c57a11ULL, 0x000fe200020f4c37ULL,
0x0000001029347825ULL, 0x000fe200078e00e0ULL, 0x00005f003ac37a11ULL, 0x000fe200008f4c39ULL,
0x00000000323f7faeULL, 0x0005e4000b901c46ULL, 0x00000010ab437824ULL, 0x000fc400078e022eULL,
0x0000001029367825ULL, 0x040fe200078e00deULL, 0x0000000034417faeULL, 0x0007e6000b901c46ULL,
0x00000010aa457824ULL, 0x000fe200078e022eULL, 0x0000000036437faeULL, 0x0009e2000b901c46ULL,
0x0000001029387825ULL, 0x000fc800078e00dcULL, 0x00000010a9477824ULL, 0x000fe200078e022eULL,
0x0000000038457faeULL, 0x000be2000b901c46ULL, 0x00000010293a7825ULL, 0x000fc800078e00daULL,
0x00000010a83d7824ULL, 0x002fe200078e022eULL, 0x000000003a477faeULL, 0x0003e2000b901c46ULL,
0x0000001029307825ULL, 0x000fc800078e00d8ULL, 0x00000010a7497824ULL, 0x000fe200078e022eULL,
0x00000000303d7faeULL, 0x0003e2000b901c46ULL, 0x0000001029327825ULL, 0x004fc800078e00d6ULL,
0x00000010a64b7824ULL, 0x000fe200078e022eULL, 0x0000000032497faeULL, 0x0005e2000b901c46ULL,
0x0000001029347825ULL, 0x008fc800078e00d4ULL, 0x00000010a54d7824ULL, 0x000fe200078e022eULL,
0x00000000344b7faeULL, 0x0007e2000b901c46ULL, 0x0000001029367825ULL, 0x010fc800078e00d0ULL,
0x00000010a44f7824ULL, 0x000fe200078e022eULL, 0x00000000364d7faeULL, 0x0009e2000b901c46ULL,
0x0000001029387825ULL, 0x020fc800078e00ceULL, 0x00000010a33f7824ULL, 0x000fe200078e022eULL,
0x00000000384f7faeULL, 0x0005e2000b901c46ULL, 0x00000010293a7825ULL, 0x002fc800078e00ccULL,
0x00000010a2417824ULL, 0x000fe200078e022eULL, 0x000000003a3f7faeULL, 0x0003e2000b901c46ULL,
0x0000001029307825ULL, 0x000fc800078e00caULL, 0x00000010a1437824ULL, 0x000fe200078e022eULL,
0x0000000030417faeULL, 0x0003e2000b901c46ULL, 0x0000001029327825ULL, 0x004fc800078e00c6ULL,
0x00000010a0457824ULL, 0x000fe200078e022eULL, 0x0000000032437faeULL, 0x0003e2000b901c46ULL,
0x0000001029347825ULL, 0x008fc800078e00c4ULL, 0x000000109f477824ULL, 0x000fe200078e022eULL,
0x0000000034457faeULL, 0x0003e2000b901c46ULL, 0x0000001029367825ULL, 0x010fca00078e00c2ULL,
0x0000000036477faeULL, 0x0003e4000b901c46ULL, 0x00000004ff297819ULL, 0x102fe20000011605ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008b02e7812ULL, 0x000fe200078ef805ULL,
0x000040002dba7824ULL, 0x000fe200078e00ffULL, 0x0000000229397810ULL, 0x040fe20007ffe0ffULL,
0x0000000829317824ULL, 0x000fe200078e00ffULL, 0x000000010b507812ULL, 0x000fe400078ec0ffULL,
0x00002000ba867810ULL, 0x000fe40007ffe0ffULL, 0xfffffff831387812ULL, 0x000fc400078ee2b0ULL,
0x0000000729317812ULL, 0x000fe400078e782eULL, 0x0000000738577812ULL, 0x040fe200078ec0ffULL,
0x0000000838b67824ULL, 0x040fe200078e00ffULL, 0x0000001038b97810ULL, 0x000fe20007ffe0ffULL,
0x000000202e307824ULL, 0x000fe200078e0231ULL, 0x0000000157857812ULL, 0x000fe400078e780bULL,
0x00000007b9517812ULL, 0x000fe200078ec0ffULL, 0x0000001030307824ULL, 0x000fe200078e00ffULL,
0x000000b685857212ULL, 0x000fe200078efcffULL, 0x00000008b9b97824ULL, 0x000fe200078e00ffULL,
0x0000002038b87810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001085af7824ULL, 0x000fe200078e0286ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003030783bULL, 0x000fe20000000200ULL, 0x0000000739397812ULL, 0x000fe400078e782eULL,
0x0000000257817812ULL, 0x000fe200078e1e50ULL, 0x00000000af34783bULL, 0x000e620000000200ULL,
0x0000003038387810ULL, 0x000fe20007ffe0ffULL, 0x000000202e397824ULL, 0x000fe200078e0239ULL,
0x00000001513a7812ULL, 0x100fe400078e780bULL, 0x00000007b8537812ULL, 0x040fe200078ec0ffULL,
0x00000008b8b87824ULL, 0x000fe200078e00ffULL, 0x000000b681817212ULL, 0x000fe200078efcffULL,
0x0000000838b77824ULL, 0x040fe200078e00ffULL, 0x0000000738557812ULL, 0x000fe200078ec0ffULL,
0x0000001039397824ULL, 0x000fe200078e00ffULL, 0x000000b93ad37212ULL, 0x000fe200078efcffULL,
0x00000010819b7824ULL, 0x000fe200078e0286ULL, 0x0000000153837812ULL, 0x000fc400078e780bULL,
0x0000000155387812ULL, 0x000fe200078e780bULL, 0x00000010d39e7824ULL, 0x000fe200078e0286ULL,
0x000000b883837212ULL, 0x000fe200078efcffULL, 0x000000003964783bULL, 0x000fe20000000200ULL,
0x000000b738c97212ULL, 0x000fe400078efcffULL, 0x00000002513c7812ULL, 0x000fe200078e1e50ULL,
0x000000009b5c783bULL, 0x000ea20000000200ULL, 0x00000010839d7824ULL, 0x000fe200078e0286ULL,
0x0000000253bf7812ULL, 0x000fe200078e1e50ULL, 0x00000010c99c7824ULL, 0x000fe200078e0286ULL,
0x000000009e4c783bULL, 0x000ee20000000200ULL, 0x000000b93cc17212ULL, 0x000fc400078efcffULL,
0x000000b8bfbf7212ULL, 0x000fe200078efcffULL, 0x000000009d40783bULL, 0x000f220000000200ULL,
0x0000000457bd7812ULL, 0x000fe200078e1e50ULL, 0x00000010c19a7824ULL, 0x000fe200078e0286ULL,
0x0000000453bb7812ULL, 0x000fe200078e1e50ULL, 0x000000009c38783bULL, 0x000f620000000200ULL,
0x00000010bf997824ULL, 0x100fe200078e0286ULL, 0x000000b6bdbd7212ULL, 0x000fe400078efcffULL,
0x000000009a58783bULL, 0x000ee20000000200ULL, 0x000000b8bbbb7212ULL, 0x000fe200078efcffULL,
0x000000343074723cULL, 0x042fe200000418ffULL, 0x00000010bd807824ULL, 0x000fe200078e0286ULL,
0x000000009948783bULL, 0x000e620000000200ULL, 0x0000000657577812ULL, 0x000fe200078e1e50ULL,
0x00000010bb7e7824ULL, 0x000fe200078e0286ULL, 0x0000000653537812ULL, 0x000fe200078e1e50ULL,
0x000000008070783bULL, 0x000fe20000000200ULL, 0x000000b657b67212ULL, 0x000fe200078efcffULL,
0x000000363034723cULL, 0x000fe200000418ffULL, 0x000000b853b87212ULL, 0x000fe200078efcffULL,
0x000000007e68783bULL, 0x000fe40000000200ULL, 0x00000010b67b7824ULL, 0x000fc400078e0286ULL,
0x00000010b87a7824ULL, 0x000fd400078e0286ULL, 0x0000005c6474723cULL, 0x044ff00000041874ULL,
0x0000005e645c723cULL, 0x000ff00000041834ULL, 0x0000004c3034723cULL, 0x048ff000000418ffULL,
0x0000004e304c723cULL, 0x040ff000000418ffULL, 0x00000040303c723cULL, 0x050ff000000418ffULL,
0x000000383044723cULL, 0x060fee00000418ffULL, 0x0000000255387812ULL, 0x000fe200078e1e50ULL,
0x000000423040723cULL, 0x000fe600000418ffULL, 0x000000b738b17212ULL, 0x000fca00078efcffULL,
0x00000010b1977824ULL, 0x000fe200078e0286ULL, 0x0000003a3030723cULL, 0x000fe800000418ffULL,
0x000000009738783bULL, 0x000ea80000000200ULL, 0x000000586434723cULL, 0x040ff00000041834ULL,
0x0000005a6458723cULL, 0x040fee000004184cULL, 0x00000004294d7810ULL, 0x000fe20007ffe0ffULL,
0x00000048643c723cULL, 0x002fee000004183cULL, 0x000000074d497812ULL, 0x000fc400078e782eULL,
0x00000006294d7810ULL, 0x000fc60007ffe0ffULL, 0x000000202e4c7824ULL, 0x040fe200078e0249ULL,
0x000000074d4d7812ULL, 0x000fe200078e782eULL, 0x0000004a6448723cULL, 0x000fe80000041840ULL,
0x000000202e4d7824ULL, 0x000fc600078e024dULL, 0x000000104c407824ULL, 0x000fe200078e00ffULL,
0x0000000451427812ULL, 0x100fe200078e1e50ULL, 0x000000386444723cULL, 0x044fe20000041844ULL,
0x00000004554c7812ULL, 0x100fe200078e1e50ULL, 0x000000104d4d7824ULL, 0x000fe200078e00ffULL,
0x000000b942b57212ULL, 0x000fe400078efcffULL, 0x000000b74cb37212ULL, 0x000fe200078efcffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x0000000651387812ULL, 0x000fe200078e1e50ULL,
0x00000010b57f7824ULL, 0x000fe200078e0286ULL, 0x0000000655507812ULL, 0x000fe200078e1e50ULL,
0x00000010b37d7824ULL, 0x000fe200078e0286ULL, 0x000000b938b97212ULL, 0x000fe200078efcffULL,
0x0000003a6464723cULL, 0x000fe20000041830ULL, 0x000000007f6c783bULL, 0x000ea20000000200ULL,
0x000000b750b77212ULL, 0x000fc400078efcffULL, 0x00000010b97c7824ULL, 0x100fe200078e0286ULL,
0x000000007d60783bULL, 0x000ee40000000200ULL, 0x00000010b7797824ULL, 0x000fe400078e0286ULL,
0x000000004d4c783bULL, 0x000fe80000000200ULL, 0x000000007b50783bULL, 0x000f280000000200ULL,
0x000000007c30783bULL, 0x000f680000000200ULL, 0x000000007a54783bULL, 0x000ee80000000200ULL,
0x000000007938783bULL, 0x000ee20000000200ULL, 0x000000704074723cULL, 0x042ff00000041874ULL,
0x0000006c4034723cULL, 0x044ff00000041834ULL, 0x00000068403c723cULL, 0x040ff0000004183cULL,
0x00000072405c723cULL, 0x040ff0000004185cULL, 0x0000006e4058723cULL, 0x040ff00000041858ULL,
0x0000006a4048723cULL, 0x040ff00000041848ULL, 0x000000604044723cULL, 0x048ff00000041844ULL,
0x000000624040723cULL, 0x000ff00000041864ULL, 0x000000504c74723cULL, 0x050ff00000041874ULL,
0x000000304c34723cULL, 0x060ff00000041834ULL, 0x000000544c3c723cULL, 0x040ff0000004183cULL,
0x000000524c50723cULL, 0x040ff0000004185cULL, 0x000000324c30723cULL, 0x040ff00000041858ULL,
0x000000564c54723cULL, 0x040ff00000041848ULL, 0x000000384c44723cULL, 0x040ff00000041844ULL,
0x0000003a4c4c723cULL, 0x000fe20000041840ULL, 0x0000046000008947ULL, 0x000fee0003800000ULL,
0x000000012b5b7824ULL, 0x000fe200078e0a0aULL, 0x00000010b0597812ULL, 0x000fe200078efcffULL,
0x00000010ae957824ULL, 0x000fc400078e0286ULL, 0x00000010ad947824ULL, 0x000fe200078e0286ULL,
0x0000005b0b00720cULL, 0x080fe20003f26070ULL, 0x0000001059387825ULL, 0x040fe200078e00e4ULL,
0x0000005b0c00720cULL, 0x080fe40003f46070ULL, 0x0000005b0e00720cULL, 0x080fe20003f66070ULL,
0x0000001059487825ULL, 0x040fe200078e00e2ULL, 0x0000005b1200720cULL, 0x080fe40003f86070ULL,
0x0000005b1c00720cULL, 0x080fe20003fa6070ULL, 0x00000010ac937824ULL, 0x000fe200078e0286ULL,
0x0000005b2c00720cULL, 0x000fe20003fc6070ULL, 0x0000001059427825ULL, 0x000fc400078e00e0ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038957faeULL, 0x0003e2000c901c46ULL,
0x0000005b1000720cULL, 0x080fe20003f26070ULL, 0x00000010ab927824ULL, 0x000fe400078e0286ULL,
0x0000000048947faeULL, 0x0005e2000d101c46ULL, 0x0000005b1400720cULL, 0x080fe20003f46070ULL,
0x0000001059407825ULL, 0x000fe400078e00deULL, 0x0000000042937faeULL, 0x0007e2000d901c46ULL,
0x0000005b1600720cULL, 0x000fe20003f66070ULL, 0x00000010aa917824ULL, 0x000fc400078e0286ULL,
0x00000010593a7825ULL, 0x000fe400078e00dcULL, 0x0000000040927faeULL, 0x0009e2000c901c46ULL,
0x0000005b1e00720cULL, 0x080fe20003f26070ULL, 0x00000010a9907824ULL, 0x000fe400078e0286ULL,
0x0000001059387825ULL, 0x042fe200078e00daULL, 0x000000003a917faeULL, 0x0003e2000e101c46ULL,
0x0000005b1800720cULL, 0x080fe40003f86070ULL, 0x00000010a88f7824ULL, 0x000fe200078e0286ULL,
0x0000000038907faeULL, 0x000be2000d101c46ULL, 0x0000005b1a00720cULL, 0x000fe20003f46070ULL,
0x0000001059427825ULL, 0x008fc800078e00d8ULL, 0x00000010a78e7824ULL, 0x000fe200078e0286ULL,
0x00000000428f7faeULL, 0x0007e2000d901c46ULL, 0x0000001059407825ULL, 0x010fe200078e00d6ULL,
0x0000005b2600720cULL, 0x000fc60003f66070ULL, 0x00000010a68d7824ULL, 0x000fe200078e0286ULL,
0x00000000408e7faeULL, 0x0009e2000e101c46ULL, 0x00000010593a7825ULL, 0x002fe200078e00d4ULL,
0x0000005b2800720cULL, 0x000fc60003f86070ULL, 0x00000010a58c7824ULL, 0x000fe200078e0286ULL,
0x000000003a8d7faeULL, 0x0003e2000d101c46ULL, 0x0000001059387825ULL, 0x020fe200078e00d0ULL,
0x0000005b2400720cULL, 0x000fc60003f46070ULL, 0x00000010a48b7824ULL, 0x000fe200078e0286ULL,
0x00000000388c7faeULL, 0x000be2000e901c46ULL, 0x0000005b2a00720cULL, 0x000fe20003fa6070ULL,
0x00000010594a7825ULL, 0x000fc800078e00ceULL, 0x00000010a38a7824ULL, 0x000fe200078e0286ULL,
0x000000004a8b7faeULL, 0x0003e2000c901c46ULL, 0x0000001059487825ULL, 0x004fc800078e00ccULL,
0x00000010a2897824ULL, 0x000fe200078e0286ULL, 0x00000000488a7faeULL, 0x0005e2000d101c46ULL,
0x0000001059427825ULL, 0x008fc800078e00caULL, 0x00000010a1887824ULL, 0x000fe200078e0286ULL,
0x0000000042897faeULL, 0x0005e2000d901c46ULL, 0x0000001059407825ULL, 0x010fc800078e00c6ULL,
0x00000010a0877824ULL, 0x000fe200078e0286ULL, 0x0000000040887faeULL, 0x0005e2000e101c46ULL,
0x00000010593a7825ULL, 0x002fc800078e00c4ULL, 0x000000109f867824ULL, 0x000fe200078e0286ULL,
0x000000003a877faeULL, 0x0005e2000e901c46ULL, 0x0000001059387825ULL, 0x020fca00078e00c2ULL,
0x0000000038867faeULL, 0x0005e2000f101c46ULL, 0x0000034000007947ULL, 0x000fea0003800000ULL,
0x00000010b0597812ULL, 0x000fe200078efcffULL, 0x00000010ae957824ULL, 0x100fe400078e0286ULL,
0x00000010ad947824ULL, 0x000fe400078e0286ULL, 0x0000001059427825ULL, 0x000fc800078e00e4ULL,
0x0000001059407825ULL, 0x040fe200078e00e2ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042957faeULL, 0x0003e6000b901c46ULL, 0x00000010ac937824ULL, 0x000fe200078e0286ULL,
0x0000000040947faeULL, 0x0005e2000b901c46ULL, 0x00000010593a7825ULL, 0x000fc800078e00e0ULL,
0x00000010ab927824ULL, 0x000fe200078e0286ULL, 0x000000003a937faeULL, 0x0007e2000b901c46ULL,
0x0000001059387825ULL, 0x000fc800078e00deULL, 0x00000010aa917824ULL, 0x000fe200078e0286ULL,
0x0000000038927faeULL, 0x0009e2000b901c46ULL, 0x00000010594a7825ULL, 0x000fc800078e00dcULL,
0x00000010a9907824ULL, 0x000fe200078e0286ULL, 0x000000004a917faeULL, 0x000be2000b901c46ULL,
0x0000001059487825ULL, 0x000fc800078e00daULL, 0x00000010a88f7824ULL, 0x000fe200078e0286ULL,
0x0000000048907faeULL, 0x0007e2000b901c46ULL, 0x0000001059427825ULL, 0x002fc800078e00d8ULL,
0x00000010a78e7824ULL, 0x000fe200078e0286ULL, 0x00000000428f7faeULL, 0x0003e2000b901c46ULL,
0x0000001059407825ULL, 0x004fc800078e00d6ULL, 0x00000010a68d7824ULL, 0x000fe200078e0286ULL,
0x00000000408e7faeULL, 0x0005e2000b901c46ULL, 0x00000010593a7825ULL, 0x008fc800078e00d4ULL,
0x00000010a58c7824ULL, 0x000fe200078e0286ULL, 0x000000003a8d7faeULL, 0x0007e2000b901c46ULL,
0x0000001059387825ULL, 0x010fc800078e00d0ULL, 0x00000010a48b7824ULL, 0x000fe200078e0286ULL,
0x00000000388c7faeULL, 0x0009e2000b901c46ULL, 0x00000010594a7825ULL, 0x020fc800078e00ceULL,
0x00000010a38a7824ULL, 0x000fe200078e0286ULL, 0x000000004a8b7faeULL, 0x0005e2000b901c46ULL,
0x0000001059487825ULL, 0x000fc800078e00ccULL, 0x00000010a2897824ULL, 0x000fe200078e0286ULL,
0x00000000488a7faeULL, 0x0007e2000b901c46ULL, 0x0000001059427825ULL, 0x002fc800078e00caULL,
0x00000010a1887824ULL, 0x000fe200078e0286ULL, 0x0000000042897faeULL, 0x0003e2000b901c46ULL,
0x0000001059407825ULL, 0x004fc800078e00c6ULL, 0x00000010a0877824ULL, 0x000fe200078e0286ULL,
0x0000000040887faeULL, 0x0003e2000b901c46ULL, 0x00000010593a7825ULL, 0x008fc800078e00c4ULL,
0x000000109f867824ULL, 0x000fe200078e0286ULL, 0x000000003a877faeULL, 0x0003e2000b901c46ULL,
0x0000001059387825ULL, 0x010fca00078e00c2ULL, 0x0000000038867faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000829397810ULL, 0x006fe40007ffe0ffULL,
0x00004000baba7810ULL, 0x000fe40007ffe0ffULL, 0x0000000739397812ULL, 0x000fe400078e782eULL,
0x0000000a29497810ULL, 0x000fe20007ffe0ffULL, 0x0000001085857824ULL, 0x000fe400078e02baULL,
0x000000202e397824ULL, 0x000fe200078e0239ULL, 0x0000000749497812ULL, 0x000fe200078e782eULL,
0x00000010d3847824ULL, 0x000fc400078e02baULL, 0x0000001039587824ULL, 0x000fe400078e00ffULL,
0x000000202e497824ULL, 0x000fe400078e0249ULL, 0x0000001081817824ULL, 0x100fe400078e02baULL,
0x0000001049497824ULL, 0x000fe400078e00ffULL, 0x0000001083837824ULL, 0x000fe200078e02baULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000008538783bULL, 0x000fe20000000200ULL,
0x00000010c1967824ULL, 0x100fe400078e02baULL, 0x00000010c9827824ULL, 0x100fe200078e02baULL,
0x000000005858783bULL, 0x000e620000000200ULL, 0x00000010bf987824ULL, 0x100fe400078e02baULL,
0x00000010b1b17824ULL, 0x100fe200078e02baULL, 0x000000008440783bULL, 0x000ea20000000200ULL,
0x00000010bdb27824ULL, 0x100fe400078e02baULL, 0x00000010b5b57824ULL, 0x100fe200078e02baULL,
0x000000008170783bULL, 0x000fe20000000200ULL, 0x00000010bbb47824ULL, 0x000fc400078e02baULL,
0x00000010b3b37824ULL, 0x100fe200078e02baULL, 0x000000004948783bULL, 0x000ee20000000200ULL,
0x00000010b6b67824ULL, 0x100fe400078e02baULL, 0x00000010b9b97824ULL, 0x100fe200078e02baULL,
0x000000008360783bULL, 0x000f220000000200ULL, 0x00000010b8b87824ULL, 0x100fe400078e02baULL,
0x00000010b7b77824ULL, 0x000fe200078e02baULL, 0x00000000825c783bULL, 0x000fe80000000200ULL,
0x00000000b56c783bULL, 0x000fe80000000200ULL, 0x00000000b468783bULL, 0x000fe80000000200ULL,
0x00000000b364783bULL, 0x000fe20000000200ULL, 0x000000385874723cULL, 0x042ff00000041874ULL,
0x0000003a5850723cULL, 0x040fe20000041850ULL, 0x000000009638783bULL, 0x000e6e0000000200ULL,
0x000000405834723cULL, 0x044ff00000041834ULL, 0x000000425830723cULL, 0x000fe20000041830ULL,
0x000000009840783bULL, 0x000eae0000000200ULL, 0x000000704874723cULL, 0x048ff00000041874ULL,
0x000000724870723cULL, 0x000fe20000041850ULL, 0x00000000b150783bULL, 0x000eee0000000200ULL,
0x00000060583c723cULL, 0x050ff0000004183cULL, 0x000000625854723cULL, 0x000ff00000041854ULL,
0x000000384834723cULL, 0x002fee0000041834ULL, 0x0000000c29397810ULL, 0x000fe20007ffe0ffULL,
0x0000005c5844723cULL, 0x040ff00000041844ULL, 0x0000005e584c723cULL, 0x000fe2000004184cULL,
0x00000000b65c783bULL, 0x000fec0000000200ULL, 0x0000000739597812ULL, 0x000fe200078e782eULL,
0x00000040483c723cULL, 0x004fe8000004183cULL, 0x000000202e597824ULL, 0x000fc800078e0259ULL,
0x0000001059597824ULL, 0x000fe200078e00ffULL, 0x0000003a4838723cULL, 0x040fe20000041830ULL,
0x00000000b230783bULL, 0x000fe80000000200ULL, 0x000000005960783bULL, 0x000e660000000200ULL,
0x000000424840723cULL, 0x040fe20000041854ULL, 0x00000000b958783bULL, 0x000fec0000000200ULL,
0x0000000e29557810ULL, 0x000fe20007ffe0ffULL, 0x000000504844723cULL, 0x008fe60000041844ULL,
0x0000000755557812ULL, 0x000fca00078e782eULL, 0x000000202e557824ULL, 0x000fe200078e0255ULL,
0x000000524848723cULL, 0x000fe2000004184cULL, 0x00000000b750783bULL, 0x000fe40000000200ULL,
0x0000001055bb7824ULL, 0x000fe400078e00ffULL, 0x00000000b854783bULL, 0x000fe80000000200ULL,
0x00000000bb4c783bULL, 0x000ea20000000200ULL, 0x000000306074723cULL, 0x042ff00000041874ULL,
0x000000326070723cULL, 0x040ff00000041870ULL, 0x0000006c6034723cULL, 0x040ff00000041834ULL,
0x0000006e6038723cULL, 0x040ff00000041838ULL, 0x00000068603c723cULL, 0x040ff0000004183cULL,
0x0000006a6040723cULL, 0x040ff00000041840ULL, 0x000000646044723cULL, 0x040ff00000041844ULL,
0x000000666048723cULL, 0x000ff00000041848ULL, 0x0000005c4c74723cULL, 0x044ff00000041874ULL,
0x0000005e4c70723cULL, 0x040ff00000041870ULL, 0x000000584c34723cULL, 0x040ff00000041834ULL,
0x0000005a4c38723cULL, 0x040ff00000041838ULL, 0x000000544c3c723cULL, 0x040ff0000004183cULL,
0x000000564c40723cULL, 0x040ff00000041840ULL, 0x000000504c44723cULL, 0x040ff00000041844ULL,
0x000000524c48723cULL, 0x000fe20000041848ULL, 0x0000046000008947ULL, 0x000fee0003800000ULL,
0x000000012b597824ULL, 0x000fe200078e0a0aULL, 0x00000018b0317812ULL, 0x000fe200078efcffULL,
0x00000010ae337824ULL, 0x000fc400078e02baULL, 0x00000010adad7824ULL, 0x000fe200078e02baULL,
0x000000590b00720cULL, 0x080fe20003f06070ULL, 0x0000001031e47825ULL, 0x040fe200078e00e4ULL,
0x000000590c00720cULL, 0x080fe40003f26070ULL, 0x000000591200720cULL, 0x080fe20003f46070ULL,
0x0000001031e27825ULL, 0x040fe200078e00e2ULL, 0x000000591400720cULL, 0x080fe40003f66070ULL,
0x000000591600720cULL, 0x080fe20003f86070ULL, 0x00000010ac4d7824ULL, 0x000fe200078e02baULL,
0x000000591800720cULL, 0x080fe20003fa6070ULL, 0x0000001031e07825ULL, 0x000fe200078e00e0ULL,
0x000000591a00720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000e4337faeULL, 0x0003e2000c101c46ULL, 0x000000590e00720cULL, 0x000fe20003f06070ULL,
0x00000010abab7824ULL, 0x000fc400078e02baULL, 0x00000000e2ad7faeULL, 0x0005e2000c901c46ULL,
0x000000591000720cULL, 0x000fe20003f26070ULL, 0x0000001031de7825ULL, 0x000fc800078e00deULL,
0x00000010aa4f7824ULL, 0x000fe400078e02baULL, 0x0000001031dc7825ULL, 0x000fe400078e00dcULL,
0x00000000e04d7faeULL, 0x0005e2000c101c46ULL, 0x000000591c00720cULL, 0x080fe20003f06070ULL,
0x00000010a9a97824ULL, 0x000fe400078e02baULL, 0x0000001031da7825ULL, 0x000fe200078e00daULL,
0x00000000deab7faeULL, 0x0005e2000c901c46ULL, 0x000000591e00720cULL, 0x000fc40003f26070ULL,
0x00000010a8517824ULL, 0x000fe200078e02baULL, 0x00000000dc4f7faeULL, 0x0005e2000d101c46ULL,
0x0000001031d87825ULL, 0x000fe200078e00d8ULL, 0x000000592400720cULL, 0x080fe40003f46070ULL,
0x00000000daa97faeULL, 0x0005e2000d901c46ULL, 0x00000010a7a77824ULL, 0x000fe200078e02baULL,
0x000000592600720cULL, 0x080fe20003f66070ULL, 0x0000001031d67825ULL, 0x000fe200078e00d6ULL,
0x00000000d8517faeULL, 0x0005e2000e101c46ULL, 0x000000592800720cULL, 0x000fc40003f86070ULL,
0x00000010a6537824ULL, 0x000fe200078e02baULL, 0x00000000d6a77faeULL, 0x0005e2000e901c46ULL,
0x0000001031d47825ULL, 0x000fe200078e00d4ULL, 0x000000592a00720cULL, 0x000fc60003fa6070ULL,
0x00000010a5a57824ULL, 0x000fe200078e02baULL, 0x00000000d4537faeULL, 0x0005e2000f101c46ULL,
0x000000592c00720cULL, 0x000fe20003fc6070ULL, 0x0000001031d07825ULL, 0x000fc800078e00d0ULL,
0x00000010a4557824ULL, 0x000fe200078e02baULL, 0x00000000d0a57faeULL, 0x0005e2000c101c46ULL,
0x0000001031ce7825ULL, 0x000fc800078e00ceULL, 0x00000010a3a37824ULL, 0x000fe200078e02baULL,
0x00000000ce557faeULL, 0x0005e2000c901c46ULL, 0x0000001031cc7825ULL, 0x000fc800078e00ccULL,
0x00000010a2337824ULL, 0x002fe200078e02baULL, 0x00000000cca37faeULL, 0x0005e2000d101c46ULL,
0x0000001031ca7825ULL, 0x000fc800078e00caULL, 0x00000010a1a17824ULL, 0x000fe200078e02baULL,
0x00000000ca337faeULL, 0x0005e2000d901c46ULL, 0x0000001031c67825ULL, 0x000fc800078e00c6ULL,
0x00000010a0577824ULL, 0x000fe200078e02baULL, 0x00000000c6a17faeULL, 0x0005e2000e101c46ULL,
0x0000001031c47825ULL, 0x000fc800078e00c4ULL, 0x000000109f9f7824ULL, 0x000fe200078e02baULL,
0x00000000c4577faeULL, 0x0005e2000e901c46ULL, 0x0000001031c27825ULL, 0x000fca00078e00c2ULL,
0x00000000c29f7faeULL, 0x0005e2000f101c46ULL, 0x0000034000007947ULL, 0x000fea0003800000ULL,
0x00000018b0317812ULL, 0x000fe200078efcffULL, 0x00000010ae337824ULL, 0x100fe400078e02baULL,
0x00000010adad7824ULL, 0x000fe400078e02baULL, 0x0000001031e47825ULL, 0x000fc800078e00e4ULL,
0x0000001031e27825ULL, 0x040fe200078e00e2ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000e4337faeULL, 0x0003e6000b901c46ULL, 0x00000010ac4d7824ULL, 0x000fe200078e02baULL,
0x00000000e2ad7faeULL, 0x0003e2000b901c46ULL, 0x0000001031e07825ULL, 0x000fc800078e00e0ULL,
0x00000010abab7824ULL, 0x000fe200078e02baULL, 0x00000000e04d7faeULL, 0x0003e2000b901c46ULL,
0x0000001031de7825ULL, 0x000fc800078e00deULL, 0x00000010aa4f7824ULL, 0x000fe200078e02baULL,
0x00000000deab7faeULL, 0x0003e2000b901c46ULL, 0x0000001031dc7825ULL, 0x000fc800078e00dcULL,
0x00000010a9a97824ULL, 0x000fe200078e02baULL, 0x00000000dc4f7faeULL, 0x0003e2000b901c46ULL,
0x0000001031da7825ULL, 0x000fc800078e00daULL, 0x00000010a8517824ULL, 0x000fe200078e02baULL,
0x00000000daa97faeULL, 0x0003e2000b901c46ULL, 0x0000001031d87825ULL, 0x000fc800078e00d8ULL,
0x00000010a7a77824ULL, 0x000fe200078e02baULL, 0x00000000d8517faeULL, 0x0003e2000b901c46ULL,
0x0000001031d67825ULL, 0x000fc800078e00d6ULL, 0x00000010a6537824ULL, 0x000fe200078e02baULL,
0x00000000d6a77faeULL, 0x0003e2000b901c46ULL, 0x0000001031d47825ULL, 0x000fc800078e00d4ULL,
0x00000010a5a57824ULL, 0x000fe200078e02baULL, 0x00000000d4537faeULL, 0x0003e2000b901c46ULL,
0x0000001031d07825ULL, 0x000fc800078e00d0ULL, 0x00000010a4557824ULL, 0x000fe200078e02baULL,
0x00000000d0a57faeULL, 0x0003e2000b901c46ULL, 0x0000001031ce7825ULL, 0x000fc800078e00ceULL,
0x00000010a3a37824ULL, 0x000fe200078e02baULL, 0x00000000ce557faeULL, 0x0003e2000b901c46ULL,
0x0000001031cc7825ULL, 0x000fc800078e00ccULL, 0x00000010a2577824ULL, 0x000fe200078e02baULL,
0x00000000cca37faeULL, 0x0003e2000b901c46ULL, 0x0000001031ca7825ULL, 0x000fc800078e00caULL,
0x00000010a1a17824ULL, 0x000fe200078e02baULL, 0x00000000ca577faeULL, 0x0003e2000b901c46ULL,
0x0000001031c67825ULL, 0x000fc800078e00c6ULL, 0x00000010a0597824ULL, 0x000fe200078e02baULL,
0x00000000c6a17faeULL, 0x0003e2000b901c46ULL, 0x0000001031c47825ULL, 0x000fc800078e00c4ULL,
0x000000109f9f7824ULL, 0x000fe200078e02baULL, 0x00000000c4597faeULL, 0x0003e2000b901c46ULL,
0x0000001031c27825ULL, 0x000fca00078e00c2ULL, 0x00000000c29f7faeULL, 0x0003e4000b901c46ULL,
0x00000004ff4d7424ULL, 0x006fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff9f7424ULL, 0x000fe400078e00ffULL, 0x000003004d037a24ULL, 0x000fca00078e0203ULL,
0x000000780300720cULL, 0x000fda0003f06070ULL, 0x00000002064c8824ULL, 0x000fe200078e0203ULL,
0x0000001029317810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000060004c4c8625ULL, 0x000fe200078e004dULL, 0x0000000731317812ULL, 0x100fe200078e782eULL,
0x00000000af64783bULL, 0x000fe80000000200ULL, 0x000000064c9f8981ULL, 0x0002a2000c1e1900ULL,
0x000000202e317824ULL, 0x000fe200078e0231ULL, 0x00000012294f7810ULL, 0x000fe40007ffe0ffULL,
0x000000009d5c783bULL, 0x000fe20000000200ULL, 0x0000001031547824ULL, 0x000fe200078e00ffULL,
0x000000074f4f7812ULL, 0x000fc400078e782eULL, 0x000000009e30783bULL, 0x000fe60000000200ULL,
0x000000202e4f7824ULL, 0x000fe200078e024fULL, 0x000000005454783bULL, 0x000ee60000000200ULL,
0x000000104f4f7824ULL, 0x000fe200078e00ffULL, 0x000000009b50783bULL, 0x000fe80000000200ULL,
0x000000009c58783bULL, 0x000fe80000000200ULL, 0x000000004f4c783bULL, 0x002e680000000200ULL,
0x000000009a60783bULL, 0x000f280000000200ULL, 0x000000007b6c783bULL, 0x000fe80000000200ULL,
0x000000007c68783bULL, 0x000fe20000000200ULL, 0x000000645474723cULL, 0x048ff00000041874ULL,
0x000000665470723cULL, 0x040fe20000041870ULL, 0x000000009964783bULL, 0x000eee0000000200ULL,
0x000000305434723cULL, 0x040ff00000041834ULL, 0x000000325438723cULL, 0x040fe20000041838ULL,
0x000000009730783bULL, 0x000f6e0000000200ULL, 0x0000005c543c723cULL, 0x000ff0000004183cULL,
0x000000504c74723cULL, 0x002fee0000041874ULL, 0x0000001429517810ULL, 0x000fe20007ffe0ffULL,
0x0000005e5440723cULL, 0x000fe60000041840ULL, 0x0000000751517812ULL, 0x000fca00078e782eULL,
0x000000202e517824ULL, 0x000fe200078e0251ULL, 0x000000585444723cULL, 0x000fe60000041844ULL,
0x00000010515c7824ULL, 0x000fca00078e00ffULL, 0x0000005a5448723cULL, 0x000fe20000041848ULL,
0x000000005c5c783bULL, 0x000fe80000000200ULL, 0x000000007f54783bULL, 0x000fe60000000200ULL,
0x000000524c70723cULL, 0x040fe20000041870ULL, 0x000000008050783bULL, 0x000e680000000200ULL,
0x000000007e58783bULL, 0x000e660000000200ULL, 0x000000604c34723cULL, 0x050ff00000041834ULL,
0x000000624c38723cULL, 0x040fe20000041838ULL, 0x000000007d60783bULL, 0x000f2e0000000200ULL,
0x000000644c3c723cULL, 0x048fee000004183cULL, 0x0000001629657810ULL, 0x000fe20007ffe0ffULL,
0x000000664c40723cULL, 0x000fe60000041840ULL, 0x0000000765657812ULL, 0x000fca00078e782eULL,
0x000000202e657824ULL, 0x000fe200078e0265ULL, 0x000000304c44723cULL, 0x060fee0000041844ULL,
0x0000001065307824ULL, 0x000fe200078e00ffULL, 0x000000324c48723cULL, 0x000fe20000041848ULL,
0x000000007a64783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000ee60000000200ULL,
0x000000505c74723cULL, 0x042fe20000041874ULL, 0x00000000794c783bULL, 0x000e6e0000000200ULL,
0x000000525c70723cULL, 0x040ff00000041870ULL, 0x000000545c34723cULL, 0x040ff00000041834ULL,
0x000000565c38723cULL, 0x040ff00000041838ULL, 0x000000585c3c723cULL, 0x040ff0000004183cULL,
0x0000005a5c40723cULL, 0x040ff00000041840ULL, 0x000000605c44723cULL, 0x050ff00000041844ULL,
0x000000625c48723cULL, 0x000ff00000041848ULL, 0x0000006c3074723cULL, 0x048ff00000041874ULL,
0x0000006e3070723cULL, 0x040ff00000041870ULL, 0x000000683034723cULL, 0x040ff00000041834ULL,
0x0000006a3038723cULL, 0x040ff00000041838ULL, 0x00000064303c723cULL, 0x040ff0000004183cULL,
0x000000663040723cULL, 0x040ff00000041840ULL, 0x0000004c3044723cULL, 0x002fe20000041844ULL,
0x000000049f627c24ULL, 0x004fce000f8e02ffULL, 0x0000004e3048723cULL, 0x000fee0000041848ULL,
0x000003002f317a10ULL, 0x000fc80007ffe0ffULL, 0x0000000131337810ULL, 0x000fc80007ffe0ffULL,
0x000000023300720cULL, 0x000fda0003f06070ULL, 0x0000089000008947ULL, 0x000fea0003800000ULL,
0x000000620d0d7210ULL, 0x080fe40007f1e0ffULL, 0x000000620f0f7210ULL, 0x080fe40007f3e0ffULL,
0x0000006211117210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff607224ULL, 0x000fe200000e06ffULL,
0x0000006213137210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff5e7224ULL, 0x000fe200008e06ffULL,
0x0000006215157210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff5c7224ULL, 0x000fe200010e06ffULL,
0x00005e000d5f7a11ULL, 0x000fe200078048ffULL, 0x000000ffff5a7224ULL, 0x000fe200018e06ffULL,
0x00005e00115b7a11ULL, 0x000fe200078248ffULL, 0x000000ffff587224ULL, 0x000fe200020e06ffULL,
0x00005f000d607a11ULL, 0x000fc400000f4c60ULL, 0x00005e000f5d7a11ULL, 0x000fe400078048ffULL,
0x00005e0013597a11ULL, 0x000fe400078448ffULL, 0x00005e0015577a11ULL, 0x000fe400078648ffULL,
0x00005f000f5e7a11ULL, 0x000fe400000f4c5eULL, 0x00005f00115c7a11ULL, 0x000fe400008f4c5cULL,
0x00005f00135a7a11ULL, 0x000fc400010f4c5aULL, 0x00005f0015587a11ULL, 0x000fe400018f4c58ULL,
0x0000006217567210ULL, 0x080fe40007f1e0ffULL, 0x0000006219197210ULL, 0x080fe40007f3e0ffULL,
0x000000621b1b7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x000000621d1d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x00005e0056157a11ULL, 0x000fe200078048ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x00005e0019547a11ULL, 0x000fe200078248ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x00005e001b527a11ULL, 0x000fc400078448ffULL, 0x00005e001d177a11ULL, 0x000fe400078648ffULL,
0x00005f0056567a11ULL, 0x000fe400000f4c0dULL, 0x00005f0019557a11ULL, 0x000fe400008f4c4cULL,
0x00005f001b537a11ULL, 0x000fe400010f4c32ULL, 0x00005f001d517a11ULL, 0x000fe400018f4c30ULL,
0x00000062204e7210ULL, 0x080fe20007f7e0ffULL, 0x0000010031207824ULL, 0x000fe200078e0204ULL,
0x0000006221217210ULL, 0x000fc40007f1e0ffULL, 0x0000006222327210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x000000621f1f7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200000e06ffULL, 0x00000062230f7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x00000062271d7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff507224ULL, 0x000fe200020e06ffULL, 0x000000202b0d7217ULL, 0x000fe20007800000ULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e0021337a11ULL, 0x000fc400078048ffULL,
0x00005e0032277a11ULL, 0x040fe200078248ffULL, 0x000000010d197824ULL, 0x000fe200078e0a20ULL,
0x0000006225227210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff207224ULL, 0x000fe200028e06ffULL,
0x00005e001f4f7a11ULL, 0x000fe400078c48ffULL, 0x00005f00214c7a11ULL, 0x000fe200000f4c4cULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0x00005f0032327a11ULL, 0x000fe200008f4c11ULL,
0x0000001005117824ULL, 0x000fe200078e00ffULL, 0x00005e000f237a11ULL, 0x000fc400078048ffULL,
0x00005f001f507a11ULL, 0x000fe400030f4c50ULL, 0x00005e00221f7a11ULL, 0x000fe400078248ffULL,
0x00005e004e4d7a11ULL, 0x000fe400078648ffULL, 0x00005e001d1b7a11ULL, 0x000fe400078448ffULL,
0x00005f000f257a11ULL, 0x000fe400000f4c30ULL, 0x0000007011307812ULL, 0x000fc400078ec0ffULL,
0x00005f0022227a11ULL, 0x000fe400008f4c0dULL, 0x000000190b00720cULL, 0x080fe40003f06070ULL,
0x000000190c00720cULL, 0x000fe40003f26070ULL, 0x00005f004e4e7a11ULL, 0x000fe400018f4c13ULL,
0x00005f001d1d7a11ULL, 0x000fe400010f4c20ULL, 0x0000005f300c7210ULL, 0x000fc40007f7e0ffULL,
0x000000190e00720cULL, 0x000fe40003f46070ULL, 0x0000005d300e7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e0660ULL, 0x0000005b30207210ULL, 0x000fe40007fbe0ffULL,
0x000000191000720cULL, 0x080fe20003f66070ULL, 0x000000ffff0f7224ULL, 0x000fe200020e065eULL,
0x000000191200720cULL, 0x000fe20003f86070ULL, 0x000000ffff217224ULL, 0x000fe200028e065cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c957faeULL, 0x0003e2000c101c46ULL,
0x0000005930107210ULL, 0x000fc40007f1e0ffULL, 0x000000191400720cULL, 0x000fe20003fa6070ULL,
0x000000000e947faeULL, 0x0005e2000c901c46ULL, 0x0000005730127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e065aULL, 0x000000191600720cULL, 0x000fe20003f06070ULL,
0x0000000020937faeULL, 0x0007e2000d101c46ULL, 0x0000001530147210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0658ULL, 0x000000191800720cULL, 0x000fe20003f26070ULL,
0x0000000010927faeULL, 0x0009e2000d901c46ULL, 0x0000001730167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0656ULL, 0x000000191a00720cULL, 0x080fe20003f46070ULL,
0x0000000012917faeULL, 0x000be2000e101c46ULL, 0x00000054300c7210ULL, 0x002fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0651ULL, 0x000000192400720cULL, 0x080fe20003f66070ULL,
0x0000000014907faeULL, 0x0003e2000e901c46ULL, 0x00000052300e7210ULL, 0x004fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e0655ULL, 0x000000191c00720cULL, 0x000fc60003f86070ULL,
0x000000ffff0f7224ULL, 0x000fe200028e0653ULL, 0x000000191e00720cULL, 0x000fe20003fa6070ULL,
0x000000000c8f7faeULL, 0x0005e2000c101c46ULL, 0x0000004f30107210ULL, 0x050fe40007f1e0ffULL,
0x0000004d30127210ULL, 0x020fe20007fde0ffULL, 0x000000000e8e7faeULL, 0x0009e2000c901c46ULL,
0x000000192600720cULL, 0x080fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200000e0650ULL,
0x000000192800720cULL, 0x000fe20003f06070ULL, 0x00000000168d7faeULL, 0x000be2000d101c46ULL,
0x0000003330147210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fc400030e064eULL,
0x00000000108c7faeULL, 0x0007e2000e101c46ULL, 0x00000027300c7210ULL, 0x004fe20007f9e0ffULL,
0x000000ffff157224ULL, 0x000fe200010e064cULL, 0x000000192a00720cULL, 0x000fe20003f46070ULL,
0x00000000128b7faeULL, 0x0007e2000e901c46ULL, 0x00000023300e7210ULL, 0x010fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe400020e0632ULL, 0x00000000148a7faeULL, 0x0007e2000d901c46ULL,
0x000000192c00720cULL, 0x000fe20003f66070ULL, 0x000000ffff0f7224ULL, 0x000fe200028e0625ULL,
0x0000001f30167210ULL, 0x060fe20007f9e0ffULL, 0x000000000c897faeULL, 0x0007e2000c901c46ULL,
0x0000001b30187210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200020e0622ULL,
0x000000000e887faeULL, 0x0007e2000c101c46ULL, 0x000000ffff197224ULL, 0x000fc600028e061dULL,
0x0000000016877faeULL, 0x0007e8000d101c46ULL, 0x0000000018867faeULL, 0x0007e2000d901c46ULL,
0x0000075000007947ULL, 0x000fea0003800000ULL, 0x000000620d0d7210ULL, 0x080fe40007f1e0ffULL,
0x000000620f0f7210ULL, 0x080fe40007f3e0ffULL, 0x0000006217127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005e000d0b7a11ULL, 0x000fe200078048ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e000f337a11ULL, 0x000fe200078248ffULL,
0x000000ffff517224ULL, 0x000fe200018e06ffULL, 0x00005f000d0d7a11ULL, 0x000fc400000f4c0cULL,
0x0000006211117210ULL, 0x080fe40007f1e0ffULL, 0x00005f000f0f7a11ULL, 0x000fe400008f4c0eULL,
0x00000062130e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000006215107210ULL, 0x000fe40007f5e0ffULL, 0x00005e0011137a11ULL, 0x000fe200078048ffULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x00005e0012537a11ULL, 0x000fe200078648ffULL,
0x000000ffff4d7224ULL, 0x000fe200010e06ffULL, 0x00005e000e177a11ULL, 0x000fc400078248ffULL,
0x00005e00104f7a11ULL, 0x000fe400078448ffULL, 0x00005f0011117a11ULL, 0x000fe400000f4c0cULL,
0x00005f0012517a11ULL, 0x000fe400018f4c51ULL, 0x0000006219197210ULL, 0x080fe40007f1e0ffULL,
0x000000621f127210ULL, 0x080fe40007f7e0ffULL, 0x00005f000e157a11ULL, 0x000fe200008f4c15ULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005f00104d7a11ULL, 0x000fe200010f4c4dULL,
0x000000ffff597224ULL, 0x000fe200018e06ffULL, 0x000000621b0e7210ULL, 0x000fc40007f3e0ffULL,
0x000000621d107210ULL, 0x000fe40007f5e0ffULL, 0x00005e00191b7a11ULL, 0x040fe200078048ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x00005e00125b7a11ULL, 0x000fe200078648ffULL,
0x000000ffff557224ULL, 0x000fe200010e06ffULL, 0x00005e000e1f7a11ULL, 0x000fe400078248ffULL,
0x00005e0010577a11ULL, 0x000fe400078448ffULL, 0x00005f0019197a11ULL, 0x000fc400000f4c0cULL,
0x00005f0012597a11ULL, 0x000fe400018f4c59ULL, 0x00000062210c7210ULL, 0x080fe40007f7e0ffULL,
0x00005f000e1d7a11ULL, 0x000fe400008f4c1dULL, 0x00005f0010557a11ULL, 0x000fe400010f4c55ULL,
0x0000006220207210ULL, 0x080fe40007f5e0ffULL, 0x0000006225107210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x00005e000c5d7a11ULL, 0x000fe200078848ffULL,
0x000000ffff217224ULL, 0x000fe200010e06ffULL, 0x0000006222227210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff657224ULL, 0x000fe200008e06ffULL, 0x00000062230e7210ULL, 0x000fc40007f1e0ffULL,
0x0000006227627210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff5f7224ULL, 0x000fe200028e06ffULL,
0x00005e0020237a11ULL, 0x000fe200078448ffULL, 0x000000ffff277224ULL, 0x000fe200000e06ffULL,
0x00005f000c257a11ULL, 0x000fe200020f4c25ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00005f0020217a11ULL, 0x000fe200010f4c21ULL, 0x000000ffff697224ULL, 0x000fe200018e06ffULL,
0x00005e00626b7a11ULL, 0x000fe400078448ffULL, 0x00005e000e637a11ULL, 0x000fc400078048ffULL,
0x000000700c4c7812ULL, 0x000fe400078ec0ffULL, 0x00005e0010677a11ULL, 0x000fe400078248ffULL,
0x00005e0022617a11ULL, 0x000fe400078a48ffULL, 0x00005f0062697a11ULL, 0x000fe400010f4c69ULL,
0x00005f000e277a11ULL, 0x000fe400000f4c27ULL, 0x0000000b4c0c7210ULL, 0x000fc40007f5e0ffULL,
0x00005f0010657a11ULL, 0x000fe400008f4c65ULL, 0x000000334c0e7210ULL, 0x040fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000134c107210ULL, 0x000fe40007f3e0ffULL,
0x00005f00225f7a11ULL, 0x000fe200028f4c5fULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x000000174c127210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000004f4c147210ULL, 0x040fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c957faeULL, 0x0003e2000b901c46ULL, 0x000000534c167210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0615ULL, 0x0000001b4c187210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e064dULL, 0x0000001f4c1a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200020e0651ULL, 0x000000574c1c7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200018e0619ULL, 0x0000005b4c1e7210ULL, 0x040fe20007f1e0ffULL,
0x000000000e947faeULL, 0x0003e2000b901c46ULL, 0x000000234c207210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061dULL, 0x0000005d4c227210ULL, 0x040fe20007f9e0ffULL,
0x0000000010937faeULL, 0x0003e2000b901c46ULL, 0x000000614c247210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e0655ULL, 0x000000634c267210ULL, 0x040fe20007f5e0ffULL,
0x0000000012927faeULL, 0x0003e2000b901c46ULL, 0x000000674c327210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0659ULL, 0x0000006b4c4c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000014917faeULL, 0x0003e2000b901c46ULL, 0x000000ffff217224ULL, 0x000fc400028e0621ULL,
0x000000ffff237224ULL, 0x000fe200020e0625ULL, 0x0000000016907faeULL, 0x0003e2000b901c46ULL,
0x000000ffff257224ULL, 0x000fe400018e065fULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x00000000188f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff337224ULL, 0x000fe400008e0665ULL,
0x000000ffff4d7224ULL, 0x000fe200000e0669ULL, 0x000000001a8e7faeULL, 0x0003e8000b901c46ULL,
0x000000001c8d7faeULL, 0x0003e8000b901c46ULL, 0x000000001e8c7faeULL, 0x0003e8000b901c46ULL,
0x00000000208b7faeULL, 0x0003e8000b901c46ULL, 0x00000000228a7faeULL, 0x0003e8000b901c46ULL,
0x0000000024897faeULL, 0x0003e8000b901c46ULL, 0x0000000026887faeULL, 0x0003e8000b901c46ULL,
0x0000000032877faeULL, 0x0003e8000b901c46ULL, 0x000000004c867faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000018290b7810ULL, 0x000fc40007ffe0ffULL,
0x0000001a290d7810ULL, 0x00afe40007ffe0ffULL, 0x000000070b0b7812ULL, 0x100fe400078e782eULL,
0x000000070d0d7812ULL, 0x000fc600078e782eULL, 0x000000202e0b7824ULL, 0x040fe400078e020bULL,
0x000000202e0d7824ULL, 0x000fe400078e020dULL, 0x000000100b0b7824ULL, 0x000fe400078e00ffULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000008514783bULL, 0x000fe80000000200ULL, 0x000000000b10783bULL, 0x0002a80000000200ULL,
0x000000008418783bULL, 0x000ee80000000200ULL, 0x00000000831c783bULL, 0x000f220000000200ULL,
0x0000001c290b7810ULL, 0x002fc40007ffe0ffULL, 0x0000001e29297810ULL, 0x000fe20007ffe0ffULL,
0x000000008220783bULL, 0x000e620000000200ULL, 0x000000070b0b7812ULL, 0x100fe400078e782eULL,
0x0000000729297812ULL, 0x000fe200078e782eULL, 0x000000008124783bULL, 0x000fe40000000200ULL,
0x000000202e0b7824ULL, 0x040fe400078e020bULL, 0x000000000d0c783bULL, 0x000f620000000200ULL,
0x000000202e297824ULL, 0x000fc400078e0229ULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x000000009694783bULL, 0x000e620000000200ULL, 0x0000001029297824ULL, 0x000fc600078e00ffULL,
0x000000009898783bULL, 0x000e680000000200ULL, 0x00000000b44c783bULL, 0x000fe80000000200ULL,
0x00000000b350783bULL, 0x000fe20000000200ULL, 0x000000141074723cULL, 0x044fe60000041874ULL,
0x00000000b954783bULL, 0x000fe80000000200ULL, 0x00000000b858783bULL, 0x000fe20000000200ULL,
0x000000161014723cULL, 0x040fe60000041870ULL, 0x00000000b75c783bULL, 0x000fea0000000200ULL,
0x000000181034723cULL, 0x048ff00000041834ULL, 0x0000001c103c723cULL, 0x050ff0000004183cULL,
0x0000001e1040723cULL, 0x040fe20000041840ULL, 0x00000000b11c783bULL, 0x000eae0000000200ULL,
0x0000001a1038723cULL, 0x040ff00000041838ULL, 0x000000201044723cULL, 0x042ff00000041844ULL,
0x000000221048723cULL, 0x000fe20000041848ULL, 0x000000000b20783bULL, 0x000fee0000000200ULL,
0x000000240c10723cULL, 0x060ff00000041874ULL, 0x000000260c14723cULL, 0x040fe20000041814ULL,
0x00000000b224783bULL, 0x000e6e0000000200ULL, 0x000000940c18723cULL, 0x040fe20000041834ULL,
0x00000000b534783bULL, 0x000eee0000000200ULL, 0x000000960c38723cULL, 0x040ff00000041838ULL,
0x000000980c3c723cULL, 0x040ff0000004183cULL, 0x0000009a0c40723cULL, 0x040ff00000041840ULL,
0x0000001c0c44723cULL, 0x044ff00000041844ULL, 0x0000001e0c48723cULL, 0x000fe20000041848ULL,
0x00000000b61c783bULL, 0x000fe80000000200ULL, 0x00000000290c783bULL, 0x000ea60000000200ULL,
0x000000242010723cULL, 0x042ff00000041810ULL, 0x000000262014723cULL, 0x040ff00000041814ULL,
0x000000342018723cULL, 0x048ff00000041818ULL, 0x000000362038723cULL, 0x040ff00000041838ULL,
0x0000004c203c723cULL, 0x040ff0000004183cULL, 0x0000004e2040723cULL, 0x040ff00000041840ULL,
0x000000502044723cULL, 0x040ff00000041844ULL, 0x000000522048723cULL, 0x000ff00000041848ULL,
0x0000001c0c10723cULL, 0x044ff00000041810ULL, 0x0000001e0c14723cULL, 0x040ff00000041814ULL,
0x000000540c18723cULL, 0x040ff00000041818ULL, 0x000000560c38723cULL, 0x040ff00000041838ULL,
0x000000580c3c723cULL, 0x040ff0000004183cULL, 0x0000005a0c40723cULL, 0x040ff00000041840ULL,
0x0000005c0c44723cULL, 0x040ff00000041844ULL, 0x0000005e0c48723cULL, 0x000fe20000041848ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x00000000070c7f8cULL, 0x000fe2000c80043fULL,
0x3d80000010107820ULL, 0x000fc40000410000ULL, 0x3d80000011117820ULL, 0x000fe20000410000ULL,
0x00000400070b7984ULL, 0x000e620000000800ULL, 0x3d80000012127820ULL, 0x000fe40000410000ULL,
0x3d80000013137820ULL, 0x000fe40000410000ULL, 0x3d80000014147820ULL, 0x000fe40000410000ULL,
0x3d80000015157820ULL, 0x000fe40000410000ULL, 0x3d80000016167820ULL, 0x000fc40000410000ULL,
0x3d80000017177820ULL, 0x000fe40000410000ULL, 0x3d80000018187820ULL, 0x000fe40000410000ULL,
0x3d80000019197820ULL, 0x000fe40000410000ULL, 0x3d8000001a1a7820ULL, 0x000fe40000410000ULL,
0x3d8000001b1b7820ULL, 0x000fe40000410000ULL, 0x3d80000038387820ULL, 0x000fc40000410000ULL,
0x3d80000039397820ULL, 0x000fe40000410000ULL, 0x3d8000003a3a7820ULL, 0x000fe40000410000ULL,
0x3d8000003b3b7820ULL, 0x000fe40000410000ULL, 0x3d8000003c3c7820ULL, 0x000fe40000410000ULL,
0x3d8000003d3d7820ULL, 0x000fe40000410000ULL, 0x3d8000003e3e7820ULL, 0x000fc40000410000ULL,
0x3d8000003f3f7820ULL, 0x000fe40000410000ULL, 0x3d80000040407820ULL, 0x000fe40000410000ULL,
0x3d80000041417820ULL, 0x000fe20000410000ULL, 0x800000000bff7812ULL, 0x002fe2000780480dULL,
0x3d80000042427820ULL, 0x000fe40000410000ULL, 0x3d80000043437820ULL, 0x000fe40000410000ULL,
0x3d80000044447820ULL, 0x000fc40000410000ULL, 0x3d80000045457820ULL, 0x000fe40000410000ULL,
0x3d80000046467820ULL, 0x000fe40000410000ULL, 0x3d80000047477820ULL, 0x000fe40000410000ULL,
0x3d80000048487820ULL, 0x000fe40000410000ULL, 0x3d80000049497820ULL, 0x000fe40000410000ULL,
0x3d8000004a4a7820ULL, 0x000fc40000410000ULL, 0x3d8000004b4b7820ULL, 0x000fe40000410000ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0011ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b000e7305ULL, 0x0002a4000021f000ULL, 0x3fa000000b0b7823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe20003800000ULL, 0x00000400070f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000405247824ULL, 0x000fe200078e00ffULL, 0x000000082f00720cULL, 0x000fc80003f05270ULL,
0xfffffff0240c7812ULL, 0x000fca00078ec0ffULL, 0x000000802d0b7824ULL, 0x000fca00078e020cULL,
0x01c400000b0c7984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000205107824ULL, 0x000fe400078e00ffULL, 0x000000012b1f7824ULL, 0x000fc600078e0a0aULL,
0x0000000610107812ULL, 0x000fc800078ec0ffULL, 0x00000001100a7812ULL, 0x040fe400078efcffULL,
0x0000000810117812ULL, 0x000fe400078efcffULL, 0x0000001f0a00720cULL, 0x080fe40003f26070ULL,
0x00000010100a7812ULL, 0x000fe400078efcffULL, 0x0000001f1100720cULL, 0x080fe40003f06070ULL,
0x0000001f0a00720cULL, 0x000fc40003fc6070ULL, 0x0000001110117812ULL, 0x040fe400078efcffULL,
0x00000018100a7812ULL, 0x040fe400078efcffULL, 0x0000001f1000720cULL, 0x080fe40003f46070ULL,
0x0000001f1100720cULL, 0x080fe40003fa6070ULL, 0x0000001f0a00720cULL, 0x000fe40003f66070ULL,
0x00000009101e7812ULL, 0x000fc400078efcffULL, 0x0000001910117812ULL, 0x040fe400078efcffULL,
0x00000020100a7812ULL, 0x000fe400078efcffULL, 0xff7fffff12127808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40005000000ULL, 0xff7fffff13137808ULL, 0x000fe40004800000ULL,
0xff7fffff1c1c7808ULL, 0x000fc40004800000ULL, 0x0000001f1e00720cULL, 0x080fe40003f86070ULL,
0x0000001f1100720cULL, 0x080fe40003f46070ULL, 0x0000001f0a00720cULL, 0x000fe40003f26070ULL,
0x0000002110117812ULL, 0x040fe400078efcffULL, 0x00000028100a7812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fc40004000000ULL, 0xff7fffff14147808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40006000000ULL, 0xff7fffff15157808ULL, 0x000fe40006000000ULL,
0x0000001f1100720cULL, 0x080fe40003f06070ULL, 0x0000001f0a00720cULL, 0x000fe40003f86070ULL,
0x0000002910117812ULL, 0x000fc400078efcffULL, 0x00000030100a7812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40007000000ULL, 0xff7fffff18187808ULL, 0x000fe40007000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40006800000ULL, 0xff7fffff19197808ULL, 0x000fe40006800000ULL,
0x0000001f1100720cULL, 0x000fc40003fc6070ULL, 0x0000001f0a00720cULL, 0x000fe40003fa6070ULL,
0x0000003110117812ULL, 0x040fe400078efcffULL, 0x00000038100a7812ULL, 0x040fe400078efcffULL,
0x0000003910107812ULL, 0x000fe400078efcffULL, 0xff7fffff3a3a7808ULL, 0x000fe40005800000ULL,
0xff7fffff38387808ULL, 0x000fc40005800000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40005000000ULL,
0xff7fffff39397808ULL, 0x000fe40005000000ULL, 0xff7fffff3e3e7808ULL, 0x000fe40004800000ULL,
0xff7fffff3c3c7808ULL, 0x000fe40004800000ULL, 0x0000001f1100720cULL, 0x080fe40003f66070ULL,
0x0000001f0a00720cULL, 0x000fc40003f46070ULL, 0x0000001f1000720cULL, 0x000fe40003f26070ULL,
0xff7fffff3f3f7808ULL, 0x000fe40004000000ULL, 0xff7fffff3d3d7808ULL, 0x000fe40004000000ULL,
0xff7fffff42427808ULL, 0x000fe40006000000ULL, 0xff7fffff40407808ULL, 0x000fe40006000000ULL,
0xff7fffff43437808ULL, 0x000fc40007000000ULL, 0xff7fffff41417808ULL, 0x000fe40007000000ULL,
0xff7fffff46467808ULL, 0x000fe40006800000ULL, 0xff7fffff44447808ULL, 0x000fe40006800000ULL,
0xff7fffff47477808ULL, 0x000fe40005800000ULL, 0xff7fffff45457808ULL, 0x000fe40005800000ULL,
0xff7fffff4a4a7808ULL, 0x000fc40005000000ULL, 0xff7fffff48487808ULL, 0x000fe40005000000ULL,
0xff7fffff4b4b7808ULL, 0x000fe40004800000ULL, 0xff7fffff49497808ULL, 0x000fe40004800000ULL,
0x0000001d0c117209ULL, 0x004fe40007810000ULL, 0x000000120d0a7209ULL, 0x000fe40007810000ULL,
0x0000001c11117209ULL, 0x000fe40007810000ULL, 0x000000130a0d7209ULL, 0x000fc40007810000ULL,
0x00000014110a7209ULL, 0x000fe40007810000ULL, 0x000000160d0c7209ULL, 0x000fe40007810000ULL,
0x000000150a0d7209ULL, 0x000fe40007810000ULL, 0x000000170c117209ULL, 0x000fe40007810000ULL,
0x000000180d0a7209ULL, 0x000fe40007810000ULL, 0x0000001a110c7209ULL, 0x000fc40007810000ULL,
0x000000190a0d7209ULL, 0x000fe40007810000ULL, 0x0000001b0c117209ULL, 0x000fe40007810000ULL,
0x000000380d0a7209ULL, 0x000fe40007810000ULL, 0x0000003a110c7209ULL, 0x000fe40007810000ULL,
0x000000390a0d7209ULL, 0x000fe40007810000ULL, 0x0000003b0c117209ULL, 0x000fc40007810000ULL,
0x0000003c0d0a7209ULL, 0x000fe40007810000ULL, 0x0000003e110c7209ULL, 0x000fe40007810000ULL,
0x0000003d0a0d7209ULL, 0x000fe40007810000ULL, 0x0000003f0c117209ULL, 0x000fe40007810000ULL,
0x000000400d0a7209ULL, 0x000fe40007810000ULL, 0x00000042110c7209ULL, 0x000fc40007810000ULL,
0x000000410a0d7209ULL, 0x000fe40007810000ULL, 0x000000430c117209ULL, 0x000fe40007810000ULL,
0x000000440d0a7209ULL, 0x000fe40007810000ULL, 0x00000046110c7209ULL, 0x000fe40007810000ULL,
0x000000450a0d7209ULL, 0x000fe40007810000ULL, 0x000000470c117209ULL, 0x000fc40007810000ULL,
0x000000480d0a7209ULL, 0x000fe40007810000ULL, 0x0000004a110c7209ULL, 0x000fe40007810000ULL,
0x000000490a0d7209ULL, 0x000fe40007810000ULL, 0x0000004b0c237209ULL, 0x000fe20007810000ULL,
0x000018927f007947ULL, 0x000fea000b800000ULL, 0x0c401f000d0a7f89ULL, 0x0004e400000e0000ULL,
0x0000000a0d1e7209ULL, 0x00cfe20007810000ULL, 0x000018d27f007947ULL, 0x000fea000b800000ULL,
0x0c401f00230a7f89ULL, 0x000ea800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000ee800000e0000ULL,
0x0c401f000f0c7f89ULL, 0x000f2200000e0000ULL, 0x0000000a230a7209ULL, 0x004fc40007810000ULL,
0x0000000d0e107209ULL, 0x008fc60007810000ULL, 0x0c201f000a117f89ULL, 0x000fe200000e0000ULL,
0x0000000c0f207209ULL, 0x010fc60007810000ULL, 0x0c201f001e0d7f89ULL, 0x000ea800000e0000ULL,
0x0c201f00101f7f89ULL, 0x002e6800000e0000ULL, 0x0c201f0020217f89ULL, 0x00072200000e0000ULL,
0x0000000d1e0c7209ULL, 0x004fe40007810000ULL, 0x000000110a0d7209ULL, 0x000fc40007810000ULL,
0x0000001f100e7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b0c0a7820ULL, 0x008fe20000410000ULL,
0x3f80000000057882ULL, 0x000fe20000000000ULL, 0x3fb8aa3b0d1f7820ULL, 0x002fe40000410000ULL,
0x3fb8aa3b14147823ULL, 0x100fe4000001080aULL, 0x3fb8aa3b15157823ULL, 0x100fe4000001080aULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b17177823ULL, 0x000fe2000001081fULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fc4000001080aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe4000001080aULL, 0x3fb8aa3b12127823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b13137823ULL, 0x000fe2000001081fULL, 0x0000001d00107308ULL, 0x000fe20000000800ULL,
0x00000005ff267e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080aULL, 0x0000000000087886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001080aULL, 0x3f8000002626783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001080aULL, 0x0000001c000f7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b39397823ULL, 0x000fc4000001080aULL, 0x000000ffff277224ULL, 0x000fe400078e0026ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001081fULL,
0x0000001500157308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe4000001081fULL, 0x3fb8aa3b3c3c7823ULL, 0x000fc4000001080aULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080aULL, 0x0000001200117308ULL, 0x0005e20000000800ULL,
0x000000100f10723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b40407823ULL, 0x100fe4000001080aULL,
0x3fb8aa3b41417823ULL, 0x100fe4000001080aULL, 0x3fb8aa3b44447823ULL, 0x100fe4000001080aULL,
0x0000001300227308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b45457823ULL, 0x000fc4000001080aULL, 0x3fb8aa3b48487823ULL, 0x100fe4000001080aULL,
0x3fb8aa3b490a7823ULL, 0x000fe4000001080aULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b42427823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b43437823ULL, 0x000fe2000001081fULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000112211723eULL, 0x002fe200000010ffULL,
0x0000000fff0f7424ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b46467823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b47477823ULL, 0x100fe4000001081fULL, 0x0000001800187308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b4b4b7823ULL, 0x000fe2000001081fULL,
0x000000161713723eULL, 0x004fc800000010ffULL, 0x0000001900197308ULL, 0x000e660000000800ULL,
0x000000261034723cULL, 0x000fea00000418ffULL, 0x0000003800387308ULL, 0x000ff00000000800ULL,
0x0000003900397308ULL, 0x000ea20000000800ULL, 0x000000181914723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x000000383916723eULL, 0x004fce00000010ffULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003b00177308ULL, 0x000ea20000000800ULL, 0x0000001a1b15723eULL, 0x002fce00000010ffULL,
0x0000000a001d7308ULL, 0x000fe20000000800ULL, 0x0000003a1717723eULL, 0x004fce00000010ffULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000261434723cULL, 0x000fee0000041834ULL,
0x0000003d003d7308ULL, 0x000e700000000800ULL, 0x0000004000407308ULL, 0x000ff00000000800ULL,
0x0000004100417308ULL, 0x000ea20000000800ULL, 0x0000003c3d18723eULL, 0x002fce00000010ffULL,
0x0000003e003e7308ULL, 0x000ff00000000800ULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x00000040411a723eULL, 0x004fce00000010ffULL, 0x00000042001b7308ULL, 0x000ff00000000800ULL,
0x00000043000a7308ULL, 0x000ea20000000800ULL, 0x0000003e3f19723eULL, 0x002fce00000010ffULL,
0x00000048001e7308ULL, 0x000e620000000800ULL, 0x0000001b0a1b723eULL, 0x004fce00000010ffULL,
0x00000044001c7308ULL, 0x000fe20000000800ULL, 0xfffffffc050a7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0f0a7219ULL, 0x000fe200000006ffULL, 0x000000261834723cULL, 0x000fe20000041834ULL,
0x0000001e1d1e723eULL, 0x002fe200000010ffULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0x000000000a0f73a1ULL, 0x000ea200000e8000ULL, 0x000000000a0573c4ULL, 0x000eec0000004000ULL,
0x0000004600467308ULL, 0x000ff00000000800ULL, 0x0000004700477308ULL, 0x000f620000000800ULL,
0x0000001c451c723eULL, 0x002fce00000010ffULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x000000080aff7c12ULL, 0x004fe4000f80400fULL, 0x00000020210f7209ULL, 0x010fca0007810000ULL,
0x0000004b001f7308ULL, 0x000e620000000800ULL, 0x00000046471d723eULL, 0x020fe400000010ffULL,
0x0000004a1f1f723eULL, 0x002fce00000010ffULL, 0x000000261c34723cULL, 0x000fe20000041834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000014d205008947ULL, 0x008fde000b800000ULL,
0x001c1fff34207589ULL, 0x0002a400000e0000ULL, 0x000000000a2173a1ULL, 0x000ee200000e8000ULL,
0x000000000a0573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x000000080aff7c12ULL, 0x008fda000f804021ULL, 0x000014f205008947ULL, 0x010fea000b800000ULL,
0x001c1fff36217589ULL, 0x00072800000e0000ULL, 0x001c1fff01227589ULL, 0x00066800000e0000ULL,
0x001c1fff23237589ULL, 0x0006a400000e0000ULL, 0x00000002ff0a7819ULL, 0x00afe40000011605ULL,
0x0000000c243f7812ULL, 0x000fc400078ec0ffULL, 0x000000070a257812ULL, 0x040fe200078ec0ffULL,
0x000000080a2a7824ULL, 0x040fe200078e00ffULL, 0x0000000aff287212ULL, 0x000fe200078e33ffULL,
0x000000080a267824ULL, 0x040fe200078e00ffULL, 0x0000000305ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080a397824ULL, 0x040fe200078e00ffULL, 0x000000080a0a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82a277812ULL, 0x100fe400078ee225ULL, 0x0000000126297812ULL, 0x100fe200078ef625ULL,
0x000000080a4b7824ULL, 0x000fe200078e00ffULL, 0x00000002262f7812ULL, 0x100fe200078ef625ULL,
0x000000080a3b7824ULL, 0x000fe200078e00ffULL, 0x0000000326337812ULL, 0x100fe200078ef625ULL,
0x000000080a3d7824ULL, 0x000fe200078e00ffULL, 0x0000000426357812ULL, 0x000fc400078ef625ULL,
0x0000000526377812ULL, 0x140fe400078ef625ULL, 0x0000000626257812ULL, 0x000fe400078ef625ULL,
0xfffffff839397812ULL, 0x000fe400078ee228ULL, 0x0000000aff287212ULL, 0x000fe400078e33ffULL,
0x000000070a267812ULL, 0x000fe400078ec0ffULL, 0x000120002d0a7811ULL, 0x000fc400078e58ffULL,
0x000000013d417812ULL, 0x140fe400078ef626ULL, 0x000000023d437812ULL, 0x000fe200078ef626ULL,
0x0000001027247824ULL, 0x000fe200078e020aULL, 0x000000033d457812ULL, 0x000fe200078ef626ULL,
0x00000010332a7824ULL, 0x000fe200078e020aULL, 0x000000043d477812ULL, 0x000fe200078ef626ULL,
0x0000001025307824ULL, 0x000fe200078e020aULL, 0x000000053d497812ULL, 0x000fe200078ef626ULL,
0x00000010352c7824ULL, 0x000fe200078e020aULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee226ULL,
0x000000013f257824ULL, 0x000fe200078e0224ULL, 0x000000063d3d7812ULL, 0x000fe200078ef626ULL,
0x0000001029267824ULL, 0x000fe200078e020aULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee228ULL,
0x000000102f287824ULL, 0x100fe200078e020aULL, 0x0000001025007388ULL, 0x0003e20000000800ULL,
0x00000010372e7824ULL, 0x000fc400078e020aULL, 0x000000013f277824ULL, 0x040fe400078e0226ULL,
0x000000013f297824ULL, 0x000fe400078e0228ULL, 0x0000001039327824ULL, 0x000fe200078e020aULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x000000013f2f7824ULL, 0x000fe400078e022aULL,
0x000000103b247824ULL, 0x000fe200078e020aULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x000000013f337824ULL, 0x000fc400078e022cULL, 0x0000001041347824ULL, 0x000fe200078e020aULL,
0x000000162f007388ULL, 0x0007e20000000800ULL, 0x000000013f357824ULL, 0x000fe400078e022eULL,
0x0000001043367824ULL, 0x000fe200078e020aULL, 0x0000001833007388ULL, 0x0007e20000000800ULL,
0x000000013f377824ULL, 0x000fe400078e0230ULL, 0x0000001045387824ULL, 0x000fe200078e020aULL,
0x0000001a35007388ULL, 0x0007e20000000800ULL, 0x000000013f397824ULL, 0x000fc400078e0232ULL,
0x00000010473a7824ULL, 0x000fe200078e020aULL, 0x0000001c37007388ULL, 0x0007e20000000800ULL,
0x000000013f247824ULL, 0x000fe400078e0224ULL, 0x00000010493b7824ULL, 0x000fe200078e020aULL,
0x0000001e39007388ULL, 0x0007e20000000800ULL, 0x000000013f347824ULL, 0x000fe400078e0234ULL,
0x000000103d3c7824ULL, 0x000fe200078e020aULL, 0x0000001124007388ULL, 0x0007e20000000800ULL,
0x000000013f367824ULL, 0x000fc400078e0236ULL, 0x000000104b3d7824ULL, 0x000fe200078e020aULL,
0x0000001334007388ULL, 0x0007e20000000800ULL, 0x000000013f387824ULL, 0x040fe400078e0238ULL,
0x000000013f3a7824ULL, 0x040fe200078e023aULL, 0x0000001536007388ULL, 0x0007e20000000800ULL,
0x000000013f0a7824ULL, 0x040fe400078e023bULL, 0x000000013f3c7824ULL, 0x040fe200078e023cULL,
0x0000001738007388ULL, 0x0007e20000000800ULL, 0x000000013f107824ULL, 0x002fc600078e023dULL,
0x000000193a007388ULL, 0x0007e80000000800ULL, 0x0000001b0a007388ULL, 0x0007e80000000800ULL,
0x0000001d3c007388ULL, 0x0007e80000000800ULL, 0x0000001f10007388ULL, 0x0007e80000000800ULL,
0x01c0000c0b008388ULL, 0x0007e80000000c00ULL, 0x01c200200b008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6080009ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6100009ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6180009ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000023100720cULL, 0x000fe20003f06070ULL,
0x01c6200009ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff2f7224ULL, 0x008fd600078e0031ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff965000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff467807ULL, 0x008fe20004800000ULL,
0xffffffffff497424ULL, 0x000fe200078e00ffULL, 0x00017d10004a7802ULL, 0x000fe40000000f00ULL,
0x000010d000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0049ULL,
0xfffea9d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff467807ULL, 0x000fe20005000000ULL,
0xffffffffff497424ULL, 0x000fe200078e00ffULL, 0x00017d70004a7802ULL, 0x000fe40000000f00ULL,
0x0000107000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0049ULL,
0xfffea9f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0022ULL,
0x00017de000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x00000fc000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e004aULL, 0xfffeaa2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0022ULL, 0x00017e5000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff4d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x00000f5000007944ULL, 0x03cfea0003c00000ULL, 0x000000ffff227224ULL, 0x004fe200078e004aULL,
0xfffea9e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e002cULL,
0x00017ec000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x00000ee000007944ULL, 0x024fea0003c00000ULL,
0x000000082c307810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff3b7224ULL, 0x004fe200078e004aULL,
0x00017f3000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x002fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x000000ffff4c7224ULL, 0x000fe400078e0030ULL,
0x00000e7000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e004aULL,
0xfffeac1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff467807ULL, 0x004fe20004800000ULL,
0xffffffffff497424ULL, 0x000fe200078e00ffULL, 0x00017f90004a7802ULL, 0x000fe40000000f00ULL,
0x00000e5000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff467224ULL, 0x000fe200078e0049ULL,
0xfffed2b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff467807ULL, 0x000fe20005000000ULL,
0xffffffffff497424ULL, 0x000fe200078e00ffULL, 0x00017ff0004a7802ULL, 0x000fe40000000f00ULL,
0x00000df000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff467224ULL, 0x000fe200078e0049ULL,
0xfffed2d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4b7224ULL, 0x002fe200078e0049ULL,
0x0001806000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x00000d4000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff467224ULL, 0x004fe200078e004aULL, 0xfffed31000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x002fe200078e0049ULL, 0x000180e000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0030ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x00000cc000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff467224ULL, 0x004fe200078e004aULL, 0xfffed3b000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4d7424ULL, 0x000fe200078e00ffULL, 0x0001814000467802ULL, 0x000fe20000000f00ULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x00000c6000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff457224ULL, 0x004fe200078e004aULL, 0x000181a000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x002fe400078e0030ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x00000c0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff7a7224ULL, 0x004fe200078e004aULL, 0xfffed4e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff467807ULL, 0x004fe20004800000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x00018200004a7802ULL, 0x000fc40000000f00ULL, 0x00000be000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff467224ULL, 0x000fe200078e0049ULL, 0xfffef84000007947ULL, 0x000fea000383ffffULL,
0x00000001ff467807ULL, 0x000fe20005000000ULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x00018260004a7802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff467224ULL, 0x000fe200078e0049ULL, 0xfffef86000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x002fe200078e0049ULL, 0x000182d000467802ULL, 0x000fe20000000f00ULL,
0x0000001fff4d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x00000ad000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff467224ULL, 0x004fe200078e004aULL,
0xfffef8a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4b7224ULL, 0x002fe200078e0049ULL,
0x0001835000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x000fe400078e0030ULL,
0x0000001fff4d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x00000a5000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff467224ULL, 0x004fe200078e004aULL,
0xfffef94000007947ULL, 0x000fea000383ffffULL, 0x0000001fff4d7424ULL, 0x000fe200078e00ffULL,
0x000183b000467802ULL, 0x000fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fc400078e00ffULL,
0x000009f000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff457224ULL, 0x004fe200078e004aULL,
0x0001841000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x002fc400078e0030ULL,
0x0000001fff4d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x0000099000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff747224ULL, 0x004fe200078e004aULL,
0xfffefa7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff467807ULL, 0x004fe20004000000ULL,
0xffffffffff497424ULL, 0x000fe200078e00ffULL, 0x00018470004a7802ULL, 0x000fe40000000f00ULL,
0x0000097000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff467224ULL, 0x000fe200078e0049ULL,
0xffff1dd000007947ULL, 0x000fea000383ffffULL, 0x00000001ff467807ULL, 0x000fe20004800000ULL,
0xffffffffff497424ULL, 0x000fe200078e00ffULL, 0x000184d0004a7802ULL, 0x000fe40000000f00ULL,
0x0000091000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff467224ULL, 0x000fe200078e0049ULL,
0xffff1df000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4b7224ULL, 0x002fe200078e0048ULL,
0x0001854000467802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x0000086000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e004aULL, 0xffff1e3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x002fe200078e0048ULL, 0x000185c000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fe400078e0030ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x000007e000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e004aULL, 0xffff1ed000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4d7424ULL, 0x000fe200078e00ffULL, 0x0001862000467802ULL, 0x000fe20000000f00ULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x0000078000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e004aULL, 0x0001868000467802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x002fc400078e0030ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x0000072000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff587224ULL, 0x004fe200078e004aULL, 0xffff200000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0a7224ULL, 0x000fe200078e000dULL, 0x0001870000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff1f7424ULL, 0x000fe400078e00ffULL, 0x0000001fff227424ULL, 0x000fe400078e00ffULL,
0xffffffffff257424ULL, 0x000fe400078e00ffULL, 0x0000066000007944ULL, 0x002fea0003c00000ULL,
0xffffe71000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0023ULL,
0x0001877000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff1f7424ULL, 0x002fc400078e00ffULL,
0x0000001fff227424ULL, 0x000fe400078e00ffULL, 0xffffffffff257424ULL, 0x000fe400078e00ffULL,
0x000005f000007944ULL, 0x000fea0003c00000ULL, 0x0000000a230d7209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e000eULL, 0x000187e000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff1f7424ULL, 0x002fe400078e00ffULL, 0x0000001fff227424ULL, 0x000fe400078e00ffULL,
0xffffffffff257424ULL, 0x000fe400078e00ffULL, 0x0000058000007944ULL, 0x000fea0003c00000ULL,
0x0000000a0e217209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000fULL,
0x0001885000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff1f7424ULL, 0x002fc400078e00ffULL,
0x0000001fff227424ULL, 0x000fe400078e00ffULL, 0xffffffffff257424ULL, 0x000fe400078e00ffULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x0000000a0f207209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e001eULL, 0x000188c000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff1f7424ULL, 0x002fe400078e00ffULL, 0x0000001fff227424ULL, 0x000fe400078e00ffULL,
0xffffffffff257424ULL, 0x000fe400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x0000000a1e0c7209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000dULL,
0x0001893000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff1f7424ULL, 0x002fc400078e00ffULL,
0x0000001fff227424ULL, 0x000fe400078e00ffULL, 0xffffffffff257424ULL, 0x000fe400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000000a0d0d7209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0021ULL, 0x000189a000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff1f7424ULL, 0x002fe400078e00ffULL, 0x0000001fff227424ULL, 0x000fe400078e00ffULL,
0xffffffffff257424ULL, 0x000fe400078e00ffULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x0000000a210e7209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0020ULL,
0x00018a1000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff1f7424ULL, 0x002fc400078e00ffULL,
0x0000001fff227424ULL, 0x000fe400078e00ffULL, 0xffffffffff257424ULL, 0x000fe400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff217224ULL, 0x004fe200078e000aULL,
0xffffe4e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4b7224ULL, 0x000fe200078e0034ULL,
0x00018a9000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff4d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff4e7224ULL, 0x000fe400078e000aULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e004aULL,
0xffffeac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4b7224ULL, 0x002fe200078e0036ULL,
0x00018b1000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff4d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff4e7224ULL, 0x000fe400078e000aULL,
0x0000029000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e00ffULL,
0x00018b7000467802ULL, 0x000fe20000000f00ULL, 0x00001c1fff4d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff4e7224ULL, 0x000fe400078e000aULL, 0x000000ffff217224ULL, 0x004fe400078e004aULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff4e7224ULL, 0x002fe200078e000aULL,
0x00018bd000467802ULL, 0x000fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff4d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e004aULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e004aULL,
0xffffea0000007947ULL, 0x000fea000383ffffULL, 0x0180000030037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003157812ULL, 0x000fc800078ec0ffULL,
0x018000001500780cULL, 0x000fda0003f05070ULL, 0x0000003000038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff1500720cULL, 0x040fe40003f25070ULL,
0x008000001500780cULL, 0x000fe40003f02070ULL, 0x00000001ff327807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000332ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff30ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000030157812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000332ff7212ULL, 0x000fda000780c0ffULL, 0x0080000015030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0015ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003000037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffe72a014007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff117424ULL, 0x000fe200078e00ffULL, 0x0000002500007348ULL, 0x000fe80003800000ULL,
0x0c00001f0a0a7389ULL, 0x0002a200000e0022ULL, 0xfffe726010007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff477424ULL, 0x000fe200078e00ffULL, 0x0000004e00007348ULL, 0x000fe80003800000ULL,
0x0000004c4b4a7389ULL, 0x0002a200000e004dULL, 0xfffe722046007950ULL, 0x000fea0003c3ffffULL,
0x000000014600780cULL, 0x000fe20003f45070ULL, 0x0000004900007348ULL, 0x000fe80003800000ULL,
0x00000000ff477424ULL, 0x000fd000078e00ffULL, 0x0000000000467806ULL, 0x000fc800050e0100ULL,
0x0000004946497212ULL, 0x000fe200078ec0ffULL, 0x000000ffff467224ULL, 0x000fc800078e004aULL,
0xfffe71b046007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000003e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c0ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a50ULL, 0x0000000000000650ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010a0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000010d0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001188ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001198ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001380ULL, 0x0000000000018f00ULL, 0xe800001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a280ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001a290ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a290ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001a710ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019100ULL, 0x0000000000019100ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001a280ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001a710ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 108528;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
