/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016678ULL, 0x00000000000161f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x00000000000151a0ULL, 0x0000000000000260ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000015400ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000151a000000000ULL, 0x0000100400000000ULL, 0x01e0288080810c00ULL, 0x0000000000544c04ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808292ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x000151a000000000ULL,
0x0000026000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000e00000000bULL, 0x0000000b00081104ULL, 0x00081204000000e0ULL, 0x000000e00000000eULL,
0x0000000e00081104ULL, 0x00081204000000e0ULL, 0x000000e00000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x0000ae8000183104ULL, 0x000145a00000b470ULL, 0x000145c0000145b0ULL,
0x01042904000145d0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500000605000005ULL, 0x0500000505000006ULL, 0x0500000505000005ULL,
0x0500002905000029ULL, 0x0500002905000029ULL, 0x0500002905000029ULL, 0x0500002905000029ULL,
0x0500002905000029ULL, 0x0104280405000029ULL, 0x000000c0000000a0ULL, 0x00003e0000002470ULL,
0x00003f2000003e90ULL, 0x000042f000003f40ULL, 0x00004b2000004370ULL, 0x000059e000005950ULL,
0x00005a8000005a40ULL, 0x00005dd000005dc0ULL, 0x000071e000006460ULL, 0x0000731000007240ULL,
0x0000762000007320ULL, 0x00007c3000007640ULL, 0x00008a60000089b0ULL, 0x00008ae000008ab0ULL,
0x00008eb000008e90ULL, 0x0000954000009530ULL, 0x0000ae8000009a20ULL, 0x0000b9500000b470ULL,
0x0000be900000b980ULL, 0x0000c3200000beb0ULL, 0x00013e9000013e80ULL, 0x00013eb000013ea0ULL,
0x00013f0000013ee0ULL, 0x00013f3000013f20ULL, 0x000145b000014590ULL, 0x00014600000145c0ULL,
0x0001462000014610ULL, 0x00014d3000014ca0ULL, 0x00014df000014d90ULL, 0x00014ec000014e60ULL,
0x00014f8000014f20ULL, 0x000150c000015020ULL, 0x0160390400015160ULL, 0x000000ff00000190ULL,
0x0005010000024600ULL, 0x0000000200000280ULL, 0x003f010000024608ULL, 0x00000002000002f0ULL,
0x003f010000024610ULL, 0x000000ff00000800ULL, 0x0005010700024600ULL, 0x000000ff000009e0ULL,
0x0009010100024610ULL, 0x000000ff00003d40ULL, 0x0007010a00024608ULL, 0x000000ff00004aa0ULL,
0x0007010100024610ULL, 0x000000ff000058d0ULL, 0x0007010a00024618ULL, 0x000000ff000063d0ULL,
0x0007010100024620ULL, 0x000000ff00007160ULL, 0x0007010a00024628ULL, 0x000000ff00007b60ULL,
0x0007010100024630ULL, 0x000000ff00008940ULL, 0x0007010a00024638ULL, 0x000000ff000092c0ULL,
0x0007010100024640ULL, 0x000000ff0000e200ULL, 0x000e010a00024600ULL, 0x000000ff00013770ULL,
0x0011010a00024610ULL, 0x000000ff00014930ULL, 0x0011010100024608ULL, 0x000000ff00014980ULL,
0x0007010a00024608ULL, 0x000000ff00014a00ULL, 0x0007010a00024618ULL, 0x000000ff00014a80ULL,
0x0007010a00024628ULL, 0x000000ff00014b00ULL, 0x0007010a00024638ULL, 0x000000ff00014b60ULL,
0x000e010a00024600ULL, 0x000000ff00014be0ULL, 0x0011010a00024610ULL, 0x00101c0400033803ULL,
0x0000e2300000c790ULL, 0x000149500000e2e0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x00080a0400581903ULL, 0x005802100000000fULL, 0x0000000800043604ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000000ULL, 0x00000000000000c4ULL, 0x0000000e00000002ULL,
0x00000000000151a0ULL, 0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL,
0x00000000000000a0ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000004043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000057919ULL, 0x000eae0000002100ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0xffffff2001017836ULL, 0x002fe20000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000000000c7919ULL, 0x000e620000002300ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000479c3ULL, 0x000f300000002700ULL,
0x00000000000879c3ULL, 0x000f220000002600ULL, 0x00000005ff027819ULL, 0x004fcc0000011605ULL,
0x00001fff02027589ULL, 0x000ea200000e0000ULL, 0x000000010c007824ULL, 0x002fc600078e0203ULL,
0x00001fff0c0c7589ULL, 0x000f2200000e0000ULL, 0x0000008000007824ULL, 0x000fca00078e0205ULL,
0x000000ff0000720cULL, 0x040fe40003f05270ULL, 0x000000030000780cULL, 0x000fe40003f24070ULL,
0x00000000021672caULL, 0x004fe200000e0000ULL, 0x00000005ff027e24ULL, 0x008fca000f8e00ffULL,
0x0000900201007387ULL, 0x0005e60000100800ULL, 0x0000000000240947ULL, 0x010fec0003800000ULL,
0x00000000000679c3ULL, 0x000e620000008800ULL, 0x0000040000057882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065406057896ULL, 0x002fc60008000005ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x00000000000073c6ULL, 0x000e6e0000000000ULL, 0x02460006053f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000030000177ab9ULL, 0x000fe20000000800ULL, 0x000001a000007945ULL, 0x000fe80003800000ULL,
0x0000000000601947ULL, 0x000fea0003800000ULL, 0x00000000000679c3ULL, 0x000e620000008800ULL,
0x0000040000057882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x7fff000000077882ULL, 0x000fe20000000000ULL, 0x0000065406057896ULL, 0x002fc60008000005ULL,
0x001fffc000067882ULL, 0x000fc60000000000ULL, 0x0000000500027c11ULL, 0x004fe2000f8e20ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000020512caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x02460806053f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001fff0000067882ULL, 0x002fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fd60000000000ULL, 0x00000000020512caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x02461006053f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000007f0000780cULL, 0x000fe20003f04070ULL, 0x00008e0000067ab9ULL, 0x002fe20000000a00ULL,
0x000000ff0c00720cULL, 0x000fe20003f25270ULL, 0x00000004040678a5ULL, 0x000fe2000f8e0006ULL,
0x0000820000147ab9ULL, 0x000fe20000000a00ULL, 0x00008400000c7ab9ULL, 0x000fc80000000800ULL,
0x00000006ff0a7e24ULL, 0x000fe4000f8e00ffULL, 0x00000007ff0b7e24ULL, 0x000fe4000f8e00ffULL,
0x0000000000038919ULL, 0x000e620000008800ULL, 0x0000040000028802ULL, 0x004fc80000000f00ULL,
0x0000065403058816ULL, 0x002fe20000000002ULL, 0xff317217ff038424ULL, 0x000fc800078e00ffULL,
0x0000000400008824ULL, 0x000fca00078e0205ULL, 0x0244000300008388ULL, 0x0003e20000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000e81947ULL, 0x002fea0003800000ULL,
0x0000000000107919ULL, 0x000e620000000000ULL, 0x0000000216077899ULL, 0x000fe2000800063fULL,
0x00008800ff087b82ULL, 0x000ea20000000a00ULL, 0x000000040c057899ULL, 0x000fe4000800063fULL,
0x0000000408067899ULL, 0x000fc8000800063fULL, 0x00000004050572a4ULL, 0x000fe2000f8e0206ULL,
0x0000000710007c11ULL, 0x042fe4000f8fd8ffULL, 0x00000000000779c3ULL, 0x000e620000008800ULL,
0x0000001010027824ULL, 0x000fe200078e00ffULL, 0x0000000700037812ULL, 0x040fe200078ec0ffULL,
0x0000000100047836ULL, 0x040fe40000000000ULL, 0x0000000200067836ULL, 0x040fe20000000000ULL,
0x0000001f03037812ULL, 0x000fe200078e7810ULL, 0x00000003000f7836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc400078ec0ffULL, 0x0000000706077812ULL, 0x000fe400078ec0ffULL,
0x000000070f0d7812ULL, 0x000fe400078ec0ffULL, 0x0000001f05057812ULL, 0x000fe400078e7810ULL,
0x0000001f07077812ULL, 0x000fe400078e7810ULL, 0x0000001f0d107812ULL, 0x000fe200078e7810ULL,
0x00000020000d7824ULL, 0x000fe200078e0203ULL, 0x000001f002117812ULL, 0x000fe200078ec0ffULL,
0x0000000500037c36ULL, 0x000fc40008000000ULL, 0x0000002004007824ULL, 0x000fe400078e0205ULL,
0x0000020003027825ULL, 0x004fc800078e0008ULL, 0x0000000504057c36ULL, 0x000fe20008000000ULL,
0x0000001102027210ULL, 0x000fe20007f1e0ffULL, 0x00000020060e7824ULL, 0x040fe400078e0207ULL,
0x0000000506077c36ULL, 0x000fe40008000000ULL, 0x000000200f107824ULL, 0x040fe400078e0210ULL,
0x000000050f0f7c36ULL, 0x000fe20008000000ULL, 0x0000040000057882ULL, 0x000fe20000000000ULL,
0x0000020005047825ULL, 0x000fe200078e0008ULL, 0x0000065407057896ULL, 0x002fc60008000005ULL,
0x0000020007067825ULL, 0x100fe200078e0008ULL, 0x0000001104047210ULL, 0x000fe40007f3e0ffULL,
0x000000050d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000002000f087825ULL, 0x000fe200078e0008ULL,
0x00000005000f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000510137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001106067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x0000001108087210ULL, 0x000fc40007f5e0ffULL,
0x000000050e117c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000b901c54ULL,
0x000000ffff097224ULL, 0x000fc600010e0609ULL, 0x00000000040f7faeULL, 0x0003e8000b901c54ULL,
0x0000000006117faeULL, 0x0003e8000b901c54ULL, 0x0000000008137faeULL, 0x0003e2000b901c54ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0002460005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x000000140a0a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fe40003f05270ULL,
0x000000000a1872caULL, 0x004fda00000e0000ULL, 0x0000003f18057890ULL, 0x000fe4000fffe03fULL,
0x000000ff18067890ULL, 0x000fe4000fffe03fULL, 0x000000063f057899ULL, 0x000fe40008011605ULL,
0x000000083f067899ULL, 0x000fe20008011606ULL, 0x000000bc00b88947ULL, 0x000ff60003800000ULL,
0x0000900001347983ULL, 0x000ea20000100800ULL, 0x00000000000e79c3ULL, 0x000e620000008800ULL,
0x0000040000077882ULL, 0x000fe20000000000ULL, 0x00000004ff007424ULL, 0x000fe200078e00ffULL,
0x000006540e077896ULL, 0x002fe20008000007ULL, 0x00000000340d72caULL, 0x004fda00000e0000ULL,
0x000000020d0d7899ULL, 0x000fc8000800063fULL, 0x000000050d00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x00009000000b8ab9ULL, 0x000fe20000000800ULL,
0x0000000104098899ULL, 0x000fe4000800063fULL, 0x0000000b0d0a8290ULL, 0x000fc8000fffe03fULL,
0x0000000b090982a4ULL, 0x000fc6000f8e020aULL, 0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL,
0x00000004090a88a5ULL, 0x000fe4000f8e000aULL, 0x0000000716097291ULL, 0x000fc8000f8e203fULL,
0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff037e24ULL, 0x000fc6000f8e00ffULL,
0x02461000ffff79a7ULL, 0x0003e40008500009ULL, 0x0000001402028981ULL, 0x000ea2000c1e1900ULL,
0xffffffff00097882ULL, 0x000fe20000000000ULL, 0x0000000608087899ULL, 0x000fe4000800063fULL,
0x000000060c0a7899ULL, 0x000fe2000800063fULL, 0x0000000134007836ULL, 0x002fe20000000000ULL,
0x00000000020b82caULL, 0x004fc800000e0000ULL, 0x0000000600007c0cULL, 0x000fd2000bf06070ULL,
0x0000000b00098c82ULL, 0x000fc80008000000ULL, 0x0000000c00008947ULL, 0x000fea0003800000ULL,
0x0000000000717919ULL, 0x000e620000000000ULL, 0x0000010034007824ULL, 0x000fe200078e00ffULL,
0x000000090a0972a4ULL, 0x000fe4000f8e0208ULL, 0x00000003160b7899ULL, 0x000fe2000800063fULL,
0x000000ffff057224ULL, 0x000fe200078e0a00ULL, 0x0000001800027c48ULL, 0x000fe2000ffe0000ULL,
0x00000007160a7291ULL, 0x000fc6000f8e703fULL, 0x00000040020e7446ULL, 0x000fe20003800005ULL,
0x000140000a0a7890ULL, 0x000fe2000fffe03fULL, 0x0000000bff1e7e24ULL, 0x000fe2000f8e00ffULL,
0x00000003ff0f7819ULL, 0x002fe40000011671ULL, 0x0ffffff871037812ULL, 0x000fe400078ec0ffULL,
0x000000710f007212ULL, 0x0c0fe200078e3cffULL, 0x000000040f077836ULL, 0x040fe20000000000ULL,
0x0000000e0f00720cULL, 0x040fe20003f06070ULL, 0x000000080f097836ULL, 0x000fe20000000000ULL,
0x0000000703067812ULL, 0x000fe200078ef800ULL, 0x00000008070b7824ULL, 0x040fe200078e00ffULL,
0x0000007107047212ULL, 0x080fe200078e3cffULL, 0x000000100f0d7836ULL, 0x000fe20000000000ULL,
0x0000007109007212ULL, 0x0c0fe200078e3cffULL, 0x0000000809057824ULL, 0x000fe200078e00ffULL,
0xfffffff80b087812ULL, 0x000fe200078ee204ULL, 0x0000000c0f0b7836ULL, 0x000fe20000000000ULL,
0x000000710d037212ULL, 0x0c0fe200078e3cffULL, 0x000000080d107824ULL, 0x000fe200078e00ffULL,
0xfffffff8050a7812ULL, 0x000fe200078ee200ULL, 0x000000080b117824ULL, 0x040fe200078e00ffULL,
0x000000710b027212ULL, 0x080fe200078e3cffULL, 0x000000180f167836ULL, 0x040fe20000000000ULL,
0xfffffff810107812ULL, 0x000fe200078ee203ULL, 0x000000140f127836ULL, 0x040fe20000000000ULL,
0xfffffff8110c7812ULL, 0x000fe200078ee202ULL, 0x0000000816057824ULL, 0x040fe200078e00ffULL,
0x0000007116027212ULL, 0x080fe200078e3cffULL, 0x0000000812037824ULL, 0x040fe200078e00ffULL,
0x0000007112007212ULL, 0x080fe200078e3cffULL, 0x0000001c0f1a7836ULL, 0x040fe20000000000ULL,
0xfffffff805187812ULL, 0x000fe200078ee202ULL, 0x000000200f1c7836ULL, 0x040fe20000000000ULL,
0xfffffff803147812ULL, 0x000fe200078ee200ULL, 0x000000081a1b7824ULL, 0x040fe200078e00ffULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x000000711a007212ULL, 0x000fe200078e3cffULL,
0x000000081c1d7824ULL, 0x000fe200078e00ffULL, 0x0000003f0f047812ULL, 0x000fc400078ec0ffULL,
0x0000000e0700720cULL, 0x0c0fe40003f26070ULL, 0x0000003f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000904057c36ULL, 0x000fe20008000000ULL, 0x0000000e0900720cULL, 0x040fe40003f46070ULL,
0x0000003f09097812ULL, 0x000fe200078ec0ffULL, 0x0000000907077c36ULL, 0x000fe20008000000ULL,
0xfffffff81b1b7812ULL, 0x000fe400078ee200ULL, 0x000000711c007212ULL, 0x000fe200078e3cffULL,
0x0000000909097c36ULL, 0x000fe20008000000ULL, 0x0000000a06117c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff81d1d7812ULL, 0x000fe400078ee200ULL, 0xfffffff81e007812ULL, 0x000fe400078ee271ULL,
0x0000000e0b00720cULL, 0x080fe20003f66070ULL, 0x0000020005047825ULL, 0x102fe200078e0002ULL,
0x0000000a08137c11ULL, 0x000fe4000f8e20ffULL, 0x0000003f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000020007067825ULL, 0x000fe200078e0002ULL, 0x0000000e0d00720cULL, 0x000fc40003f86070ULL,
0x0000003f0d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000020009087825ULL, 0x000fe200078e0002ULL,
0x0000000a0a157c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a0c177c11ULL, 0x000fe2000f8e20ffULL,
0x0000001000047825ULL, 0x000fe200078e0004ULL, 0x0000000a10197c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a1b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000090b0b7c36ULL, 0x000fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004117faeULL, 0x0003e2000c101c54ULL,
0x0000001000067825ULL, 0x000fe200078e0006ULL, 0x0000000e1200720cULL, 0x000fc40003f06070ULL,
0x0000003f12127812ULL, 0x000fe200078ec0ffULL, 0x0000001000087825ULL, 0x000fe200078e0008ULL,
0x0000000006137faeULL, 0x0005e2000c901c54ULL, 0x0000000e1600720cULL, 0x0c0fe40003f26070ULL,
0x000002000b0a7825ULL, 0x000fe200078e0002ULL, 0x0000000008157faeULL, 0x0007e2000d101c54ULL,
0x0000003f16167812ULL, 0x000fe400078ec0ffULL, 0x000000090d0d7c36ULL, 0x000fe20008000000ULL,
0x0000000e1a00720cULL, 0x000fe20003f46070ULL, 0x00000010000a7825ULL, 0x000fe200078e000aULL,
0x0000003f1a1a7812ULL, 0x000fc400078ec0ffULL, 0x0000000a18117c11ULL, 0x002fe2000f8e20ffULL,
0x000002000d0c7825ULL, 0x000fe200078e0002ULL, 0x000000000a177faeULL, 0x000fe2000d901c54ULL,
0x0000000e1c00720cULL, 0x000fe40003f66070ULL, 0x0000000912057c36ULL, 0x000fe20008000000ULL,
0x0000003f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000916077c36ULL, 0x004fe20008000000ULL,
0x0000000a1d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000091a097c36ULL, 0x008fe40008000000ULL,
0x00000010000c7825ULL, 0x000fc800078e000cULL, 0x0000020005047825ULL, 0x100fe200078e0002ULL,
0x000000000c197faeULL, 0x0003e6000e101c54ULL, 0x0000020007067825ULL, 0x000fc800078e0002ULL,
0x0000020009087825ULL, 0x000fc800078e0002ULL, 0x0000001000047825ULL, 0x000fe200078e0004ULL,
0x0000000a140d7c11ULL, 0x002fc6000f8e20ffULL, 0x000000091c0b7c36ULL, 0x000fe40008000000ULL,
0x0000001000067825ULL, 0x040fe200078e0006ULL, 0x00000000040d7faeULL, 0x0003e6000c101c54ULL,
0x0000001000087825ULL, 0x000fe200078e0008ULL, 0x0000000006117faeULL, 0x0005e6000c901c54ULL,
0x000000240f0c7836ULL, 0x040fe20000000000ULL, 0x00000000081b7faeULL, 0x0007e2000d101c54ULL,
0x000000280f127836ULL, 0x000fc40000000000ULL, 0x0000002c0f147836ULL, 0x000fe20000000000ULL,
0x000000710c047212ULL, 0x082fe200078e3cffULL, 0x000002000b0a7825ULL, 0x000fe200078e0002ULL,
0x0000007112057212ULL, 0x080fe400078e3cffULL, 0x0000007114067212ULL, 0x084fe200078e3cffULL,
0x000000080c077824ULL, 0x040fe200078e00ffULL, 0x0000000e0c00720cULL, 0x080fe20003f06070ULL,
0x000000300f167836ULL, 0x040fe20000000000ULL, 0x0000000e1200720cULL, 0x040fe20003f26070ULL,
0x0000000812087824ULL, 0x008fe200078e00ffULL, 0xfffffff807107812ULL, 0x000fe200078ee204ULL,
0x0000000814157824ULL, 0x000fe200078e00ffULL, 0x0000007116047212ULL, 0x080fe200078e3cffULL,
0x000000380f0d7836ULL, 0x040fe20000000000ULL, 0xfffffff808137812ULL, 0x000fe200078ee205ULL,
0x000000340f187836ULL, 0x000fe20000000000ULL, 0xfffffff815157812ULL, 0x000fe200078ee206ULL,
0x00000010000a7825ULL, 0x000fe200078e000aULL, 0x000000710d067212ULL, 0x000fc400078e3cffULL,
0x0000007118057212ULL, 0x080fe200078e3cffULL, 0x0000003c0f0f7836ULL, 0x000fe20000000000ULL,
0x0000003f0c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0x000000000a1d7faeULL, 0x0003e2000d901c54ULL, 0x000000080d097824ULL, 0x000fe200078e00ffULL,
0x0000000e1400720cULL, 0x000fe20003f46070ULL, 0x0000000818087824ULL, 0x000fe200078e00ffULL,
0x000000710f077212ULL, 0x040fe200078e3cffULL, 0x000000080f1c7824ULL, 0x000fe200078e00ffULL,
0x0000003f12127812ULL, 0x000fc400078ec0ffULL, 0x0000000e1600720cULL, 0x080fe40003f66070ULL,
0xfffffff817177812ULL, 0x000fe400078ee204ULL, 0x0000003f14147812ULL, 0x000fe400078ec0ffULL,
0x0000000e1800720cULL, 0x000fe40003f86070ULL, 0xfffffff8091a7812ULL, 0x000fe200078ee206ULL,
0x0000000914097c36ULL, 0x000fe20008000000ULL, 0x0000003f16167812ULL, 0x000fc400078ec0ffULL,
0x0000003f0d047812ULL, 0x000fe400078ec0ffULL, 0xfffffff808197812ULL, 0x000fe200078ee205ULL,
0x000000090c057c36ULL, 0x000fe20008000000ULL, 0x0000003f18187812ULL, 0x000fe200078ec0ffULL,
0x00000009160b7c36ULL, 0x002fe20008000000ULL, 0x0000003f0f067812ULL, 0x000fe200078ec0ffULL,
0x0000020009087825ULL, 0x100fe200078e0002ULL, 0xfffffff81c1c7812ULL, 0x000fe400078ee207ULL,
0x0000000e0f00720cULL, 0x080fe20003fc6070ULL, 0x0000000912077c36ULL, 0x000fe20008000000ULL,
0x0000000e0d00720cULL, 0x000fe20003fa6070ULL, 0x00000009040f7c36ULL, 0x000fe20008000000ULL,
0x0000000a13137c11ULL, 0x000fe2000f8e20ffULL, 0x00000009180d7c36ULL, 0x000fe20008000000ULL,
0x0000000a15157c11ULL, 0x000fe2000f8e20ffULL, 0x0000000906117c36ULL, 0x000fe20008000000ULL,
0x0000000a17177c11ULL, 0x000fe2000f8e20ffULL, 0x0000020005047825ULL, 0x000fe200078e0002ULL,
0x0000000a19197c11ULL, 0x000fc4000f8e20ffULL, 0x0000000a1a1b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020007067825ULL, 0x000fe200078e0002ULL, 0x0000000a1c1d7c11ULL, 0x000fc6000f8e20ffULL,
0x000002000b0a7825ULL, 0x000fc800078e0002ULL, 0x000002000d0c7825ULL, 0x000fc800078e0002ULL,
0x000002000f0e7825ULL, 0x000fc800078e0002ULL, 0x0000020011027825ULL, 0x000fe200078e0002ULL,
0x0000000a10117c11ULL, 0x000fc6000f8e20ffULL, 0x0000001000047825ULL, 0x000fc800078e0004ULL,
0x0000001000067825ULL, 0x040fe200078e0006ULL, 0x0000000004117faeULL, 0x0003e6000c101c54ULL,
0x0000001000087825ULL, 0x040fe200078e0008ULL, 0x0000000006137faeULL, 0x0003e6000c901c54ULL,
0x00000010000a7825ULL, 0x040fe200078e000aULL, 0x0000000008157faeULL, 0x0003e6000d101c54ULL,
0x00000010000c7825ULL, 0x040fe200078e000cULL, 0x000000000a177faeULL, 0x0003e6000d901c54ULL,
0x00000010000e7825ULL, 0x040fe200078e000eULL, 0x000000000c197faeULL, 0x0003e6000e101c54ULL,
0x0000001000027825ULL, 0x000fe200078e0002ULL, 0x000000000e1b7faeULL, 0x0003e8000e901c54ULL,
0x00000000021d7faeULL, 0x0003e2000f101c54ULL, 0x0000000800ac7947ULL, 0x000fea0003800000ULL,
0x0000000000717919ULL, 0x000e620000000000ULL, 0x000000090a0972a4ULL, 0x000fe4000f8e0208ULL,
0x00000007160a7291ULL, 0x000fe4000f8e703fULL, 0x00000003160b7899ULL, 0x000fe4000800063fULL,
0x000140000a0a7890ULL, 0x000fe2000fffe03fULL, 0x00000003ff027819ULL, 0x002fe40000011671ULL,
0x0ffffff871037812ULL, 0x000fc400078ec0ffULL, 0x0000007102007212ULL, 0x0c0fe200078e3cffULL,
0x0000000802187836ULL, 0x040fe40000000000ULL, 0x0000000c021a7836ULL, 0x000fe20000000000ULL,
0x0000000703147812ULL, 0x000fe200078ef800ULL, 0x0000000818047824ULL, 0x040fe200078e00ffULL,
0x0000007118117212ULL, 0x080fe200078e3cffULL, 0x000000081a037824ULL, 0x040fe200078e00ffULL,
0x000000711a107212ULL, 0x080fe200078e3cffULL, 0x00000014021e7836ULL, 0x040fe20000000000ULL,
0xfffffff804117812ULL, 0x000fe200078ee211ULL, 0x0000002002247836ULL, 0x040fe20000000000ULL,
0xfffffff803107812ULL, 0x000fe200078ee210ULL, 0x00000010021c7836ULL, 0x000fe20000000000ULL,
0x000000711e0e7212ULL, 0x080fe200078e3cffULL, 0x0000001c02227836ULL, 0x000fe20000000000ULL,
0x00000071240b7212ULL, 0x080fe200078e3cffULL, 0x000000081e037824ULL, 0x000fe200078e00ffULL,
0x000000711c0f7212ULL, 0x080fe200078e3cffULL, 0x0000000824047824ULL, 0x000fe200078e00ffULL,
0x00000071220c7212ULL, 0x080fe200078e3cffULL, 0x000000081c067824ULL, 0x000fe200078e00ffULL,
0xfffffff8030e7812ULL, 0x000fe200078ee20eULL, 0x0000002c022a7836ULL, 0x000fe20000000000ULL,
0xfffffff8040b7812ULL, 0x000fe200078ee20bULL, 0x0000000822057824ULL, 0x000fe200078e00ffULL,
0xfffffff8060f7812ULL, 0x000fe200078ee20fULL, 0x0000002402267836ULL, 0x000fe20000000000ULL,
0x000000712a047212ULL, 0x080fe200078e3cffULL, 0x00000030022c7836ULL, 0x000fe20000000000ULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x000000082a137824ULL, 0x000fe200078e00ffULL,
0x00000071260a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000826037824ULL, 0x000fe200078e00ffULL,
0x000000712c057212ULL, 0x0c0fe200078e3cffULL, 0x000000082c067824ULL, 0x000fe200078e00ffULL,
0xfffffff813047812ULL, 0x000fe200078ee204ULL, 0x0000003c02327836ULL, 0x040fe20000000000ULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x00000034022e7836ULL, 0x000fe20000000000ULL,
0xfffffff806057812ULL, 0x000fe200078ee205ULL, 0x0000000832137824ULL, 0x040fe200078e00ffULL,
0x0000007132087212ULL, 0x080fe200078e3cffULL, 0x0000000402167836ULL, 0x000fe20000000000ULL,
0x000000712e067212ULL, 0x0c0fe200078e3cffULL, 0x000000082e037824ULL, 0x000fe200078e00ffULL,
0xfffffff813087812ULL, 0x000fe200078ee208ULL, 0x0000000816007824ULL, 0x040fe200078e00ffULL,
0x0000007116097212ULL, 0x080fe200078e3cffULL, 0x0000001802207836ULL, 0x040fe20000000000ULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x0000002802287836ULL, 0x040fe20000000000ULL,
0x0000003f02137812ULL, 0x040fe200078ec0ffULL, 0x0000003802307836ULL, 0x000fe20000000000ULL,
0xfffffff800097812ULL, 0x000fe200078ee209ULL, 0x00008a00ff027b82ULL, 0x000e620000000a00ULL,
0x0000000820007824ULL, 0x040fe200078e00ffULL, 0x00000071200d7212ULL, 0x080fe200078e3cffULL,
0x0000000828077824ULL, 0x000fe200078e00ffULL, 0x0000003f16167812ULL, 0x000fe200078ec0ffULL,
0x0000000830127824ULL, 0x000fe200078e00ffULL, 0xfffffff8000d7812ULL, 0x000fe200078ee20dULL,
0x0000000913137c36ULL, 0x000fe20008000000ULL, 0x0000007128007212ULL, 0x000fe200078e3cffULL,
0x0000000916177c36ULL, 0x000fe20008000000ULL, 0x0000003f18187812ULL, 0x000fc400078ec0ffULL,
0xfffffff807007812ULL, 0x000fe400078ee200ULL, 0x0000007130077212ULL, 0x000fe200078e3cffULL,
0x0000000918197c36ULL, 0x000fe20008000000ULL, 0x0000003f1a1a7812ULL, 0x000fe400078ec0ffULL,
0xfffffff812077812ULL, 0x000fe200078ee207ULL, 0x0000000bff127e24ULL, 0x000fe2000f8e00ffULL,
0x0000003f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x000000091a1b7c36ULL, 0x000fe20008000000ULL,
0x0000003f1e1e7812ULL, 0x000fc400078ec0ffULL, 0x0000003f20207812ULL, 0x000fe200078ec0ffULL,
0x000000091c1d7c36ULL, 0x000fe20008000000ULL, 0x0000003f22227812ULL, 0x000fe200078ec0ffULL,
0x000000091e1f7c36ULL, 0x000fe20008000000ULL, 0x0000003f24247812ULL, 0x000fe200078ec0ffULL,
0x0000020017167825ULL, 0x102fe200078e0002ULL, 0x0000003f26267812ULL, 0x000fe400078ec0ffULL,
0x0000003f28287812ULL, 0x000fe200078ec0ffULL, 0x0000000920217c36ULL, 0x000fe20008000000ULL,
0x0000003f2a2a7812ULL, 0x000fe200078ec0ffULL, 0x0000020019187825ULL, 0x000fe200078e0002ULL,
0x0000003f2c2c7812ULL, 0x000fc400078ec0ffULL, 0x0000003f2e2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000922237c36ULL, 0x000fe20008000000ULL, 0x0000003f30307812ULL, 0x000fe200078ec0ffULL,
0x0000000924257c36ULL, 0x000fe20008000000ULL, 0x0000000a14337c11ULL, 0x000fe2000f8e20ffULL,
0x0000020013147825ULL, 0x100fe200078e0002ULL, 0x0000003f32327812ULL, 0x000fe400078ec0ffULL,
0xfffffff812127812ULL, 0x000fe200078ee271ULL, 0x0000000926277c36ULL, 0x000fe20008000000ULL,
0x0000000a09097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000928297c36ULL, 0x000fe20008000000ULL,
0x0000000a11117c11ULL, 0x000fe2000f8e20ffULL, 0x000000092a2b7c36ULL, 0x000fe20008000000ULL,
0x0000000a0f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000092c2d7c36ULL, 0x000fe20008000000ULL,
0x0000000a0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000092e2f7c36ULL, 0x000fe20008000000ULL,
0x0000000a0b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000930317c36ULL, 0x000fe20008000000ULL,
0x0000000a0a357c11ULL, 0x000fe2000f8e20ffULL, 0x000002001b1a7825ULL, 0x000fe200078e0002ULL,
0x0000000a00377c11ULL, 0x000fc4000f8e20ffULL, 0x0000000a05057c11ULL, 0x000fe2000f8e20ffULL,
0x0000000932137c36ULL, 0x000fe20008000000ULL, 0x0000000a07077c11ULL, 0x000fe2000f8e20ffULL,
0x000002001d1c7825ULL, 0x000fc800078e0002ULL, 0x0000001012147825ULL, 0x000fc800078e0014ULL,
0x000002001f1e7825ULL, 0x100fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014337faeULL, 0x0003e6000b901c54ULL, 0x0000020021207825ULL, 0x000fc800078e0002ULL,
0x0000020023227825ULL, 0x000fc800078e0002ULL, 0x0000020025247825ULL, 0x100fe200078e0002ULL,
0x0000000a0e157c11ULL, 0x002fe4000f8e20ffULL, 0x0000000a0c337c11ULL, 0x000fe2000f8e20ffULL,
0x0000020027267825ULL, 0x000fc800078e0002ULL, 0x0000020029287825ULL, 0x000fc800078e0002ULL,
0x000002002b2a7825ULL, 0x000fc800078e0002ULL, 0x000002002d2c7825ULL, 0x000fc800078e0002ULL,
0x000002002f2e7825ULL, 0x000fc800078e0002ULL, 0x0000020031307825ULL, 0x000fc800078e0002ULL,
0x0000001012167825ULL, 0x000fc800078e0016ULL, 0x0000020013027825ULL, 0x000fe200078e0002ULL,
0x0000000a10137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000016097faeULL, 0x0003e4000b901c54ULL,
0x0000001012187825ULL, 0x000fc800078e0018ULL, 0x00000010121a7825ULL, 0x040fe200078e001aULL,
0x0000000018117faeULL, 0x0005e6000b901c54ULL, 0x00000010121c7825ULL, 0x000fe200078e001cULL,
0x000000001a137faeULL, 0x000fe2000b901c54ULL, 0x0000000a04097c11ULL, 0x002fe4000f8e20ffULL,
0x00000010121e7825ULL, 0x040fe200078e001eULL, 0x000000001c0f7faeULL, 0x0003e6000b901c54ULL,
0x0000001012207825ULL, 0x000fe200078e0020ULL, 0x000000001e157faeULL, 0x0007e2000b901c54ULL,
0x0000000a08117c11ULL, 0x004fc4000f8e20ffULL, 0x0000001012227825ULL, 0x040fe200078e0022ULL,
0x00000000200d7faeULL, 0x0007e6000b901c54ULL, 0x0000001012247825ULL, 0x000fe200078e0024ULL,
0x0000000022337faeULL, 0x0007e2000b901c54ULL, 0x0000000a060f7c11ULL, 0x002fe4000f8e20ffULL,
0x0000001012267825ULL, 0x040fe200078e0026ULL, 0x00000000240b7faeULL, 0x0007e6000b901c54ULL,
0x0000001012287825ULL, 0x040fe200078e0028ULL, 0x0000000026357faeULL, 0x0007e6000b901c54ULL,
0x00000010122a7825ULL, 0x040fe200078e002aULL, 0x0000000028377faeULL, 0x0007e6000b901c54ULL,
0x00000010122c7825ULL, 0x040fe200078e002cULL, 0x000000002a097faeULL, 0x0007e6000b901c54ULL,
0x00000010122e7825ULL, 0x040fe200078e002eULL, 0x000000002c057faeULL, 0x0007e6000b901c54ULL,
0x0000001012307825ULL, 0x040fe200078e0030ULL, 0x000000002e0f7faeULL, 0x0007e6000b901c54ULL,
0x0000001012027825ULL, 0x000fe200078e0002ULL, 0x0000000030077faeULL, 0x0007e8000b901c54ULL,
0x0000000002117faeULL, 0x0007e4000b901c54ULL, 0x000000010d097890ULL, 0x000fe2000fffe03fULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000050900728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x00009000000b8ab9ULL, 0x000fe20000000800ULL,
0x00000001040c8899ULL, 0x000fe4000800063fULL, 0x0000000b090a8290ULL, 0x000fc8000fffe03fULL,
0x0000000b0c0c82a4ULL, 0x000fc6000f8e020aULL, 0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL,
0x000000040c0a88a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff027e24ULL, 0x00afe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fca000f8e00ffULL, 0x0000001402028981ULL, 0x000ea2000c1e1900ULL,
0xffffffff00127882ULL, 0x000fe20000000000ULL, 0xff317217ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000020a82caULL, 0x004fc400000e0000ULL,
0x0000000634007c0cULL, 0x000fd6000bf06070ULL, 0x0000000a00128c82ULL, 0x000fe40008000000ULL,
0x0000007000180947ULL, 0x000fea0003800000ULL, 0x00007610ff007816ULL, 0x000fe20000000000ULL,
0x00000001040a7899ULL, 0x000fe2000800063fULL, 0xff317217ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000900000047ab9ULL, 0x000fe20000000800ULL, 0x0000500001007387ULL, 0x0003e20000100600ULL,
0x000000ffff2f7224ULL, 0x000fe200078e00ffULL, 0x000000040a0a72a4ULL, 0x000fc6000f8e0204ULL,
0x0000003f00047c82ULL, 0x000fd20008000000ULL, 0x0000900001007983ULL, 0x002ea40000100800ULL,
0x00000000000c72caULL, 0x004fda00000e0000ULL, 0x000000080c0c7899ULL, 0x000fc8000800063fULL,
0x000000180c00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000006c00bc0947ULL, 0x000fea0003800000ULL, 0x0000000100007836ULL, 0x000fe20000000000ULL,
0x00000001040b7892ULL, 0x000fe2000f8e0c3fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000600007c0cULL, 0x000fe2000bf06070ULL, 0x000000400c1b7890ULL, 0x000fe2000fffe03fULL,
0x0000000400107c82ULL, 0x000fd60008000000ULL, 0x0000000c00148947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe20000011671ULL, 0x0000001b1800728cULL, 0x000fe4000bf01070ULL,
0x8000001bff027e24ULL, 0x000fe2000f8e02ffULL, 0x0000000316137899ULL, 0x000fe2000800063fULL,
0x0000003f09627812ULL, 0x040fe200078ec0ffULL, 0x00000004093e7836ULL, 0x040fe20000000000ULL,
0x0000001b180d7287ULL, 0x000fe2000c000000ULL, 0x00000008093d7836ULL, 0x040fe20000000000ULL,
0x00000007161a7291ULL, 0x000fe2000f8e703fULL, 0x000000083e007824ULL, 0x040fe200078e00ffULL,
0x000000713e5f7212ULL, 0x080fe200078e3cffULL, 0x0000001409077836ULL, 0x000fe20000000000ULL,
0x000000713d5b7212ULL, 0x0c0fe200078e3cffULL, 0x0000000dff037e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff8005f7812ULL, 0x000fe200078ee25fULL, 0x000000083d007824ULL, 0x000fe200078e00ffULL,
0x0000007107577212ULL, 0x0c0fe200078e3cffULL, 0x0000000807067824ULL, 0x000fe200078e00ffULL,
0x0000004003027446ULL, 0x000fe20003800002ULL, 0x0000001009087836ULL, 0x040fe20000000000ULL,
0xfffffff8005b7812ULL, 0x000fe200078ee25bULL, 0x0000001c09057836ULL, 0x040fe20000000000ULL,
0xfffffff806577812ULL, 0x000fe200078ee257ULL, 0x0000000c093c7836ULL, 0x000fe20000000000ULL,
0x0000007108587212ULL, 0x0c0fe200078e3cffULL, 0x0000000808037824ULL, 0x000fe200078e00ffULL,
0x0000007105557212ULL, 0x080fe200078e3cffULL, 0x0000001809067836ULL, 0x000fe20000000000ULL,
0x000000713c597212ULL, 0x0c0fe200078e3cffULL, 0x0000000805007824ULL, 0x000fe200078e00ffULL,
0xfffffff803587812ULL, 0x000fe200078ee258ULL, 0x000000083c047824ULL, 0x000fe200078e00ffULL,
0x0000007106567212ULL, 0x0c0fe200078e3cffULL, 0x0000002c094a7836ULL, 0x040fe20000000000ULL,
0xfffffff800557812ULL, 0x000fe200078ee255ULL, 0x00000008060d7824ULL, 0x000fe200078e00ffULL,
0xfffffff804597812ULL, 0x000fe200078ee259ULL, 0x0000002409037836ULL, 0x040fe20000000000ULL,
0x000000714a517212ULL, 0x0c0fe200078e3cffULL, 0x00000028094b7836ULL, 0x040fe20000000000ULL,
0xfffffff80d567812ULL, 0x000fe200078ee256ULL, 0x000000084a007824ULL, 0x000fe200078e00ffULL,
0x00008400000d7ab9ULL, 0x000fe20000000800ULL, 0x0000002009047836ULL, 0x000fe20000000000ULL,
0x0000007103537212ULL, 0x080fe200078e3cffULL, 0x0000003c094c7836ULL, 0x000fe20000000000ULL,
0x000000714b527212ULL, 0x080fe200078e3cffULL, 0x00000008030c7824ULL, 0x000fe200078e00ffULL,
0xfffffff800517812ULL, 0x000fe200078ee251ULL, 0x000000084b0d7824ULL, 0x000fe200078e00ffULL,
0x0000007104547212ULL, 0x0c0fe200078e3cffULL, 0x00000008040f7824ULL, 0x000fe200078e00ffULL,
0x000000060d0d7899ULL, 0x000fe2000800063fULL, 0x0000003409487836ULL, 0x040fe20000000000ULL,
0x000000714c6f7212ULL, 0x0c0fe200078e3cffULL, 0x00000038093f7836ULL, 0x040fe20000000000ULL,
0xfffffff80c537812ULL, 0x000fe200078ee253ULL, 0x000000084c007824ULL, 0x000fe200078e00ffULL,
0xfffffff80d527812ULL, 0x000fe200078ee252ULL, 0x0000003009497836ULL, 0x000fe20000000000ULL,
0xfffffff80f547812ULL, 0x000fe200078ee254ULL, 0x00000008480c7824ULL, 0x040fe200078e00ffULL,
0x000000120d1272a4ULL, 0x000fe2000f8e0208ULL, 0x000000083f0d7824ULL, 0x000fe200078e00ffULL,
0x00000071484f7212ULL, 0x080fe200078e3cffULL, 0x00000008490f7824ULL, 0x000fe200078e00ffULL,
0x000000713f4e7212ULL, 0x080fe200078e3cffULL, 0x00008a00000e7ab9ULL, 0x000fe20000000a00ULL,
0xfffffff8006f7812ULL, 0x000fe200078ee26fULL, 0x0000001a0b117291ULL, 0x000fe2000f8e683fULL,
0x0000007149507212ULL, 0x080fe200078e3cffULL, 0x00000013ff307e24ULL, 0x000fe2000f8e00ffULL,
0x0000007109007212ULL, 0x000fe200078e3cffULL, 0x0000000eff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x0000003f3e607812ULL, 0x000fe200078ec0ffULL, 0x0001400011117890ULL, 0x000fe2000fffe03fULL,
0x0000003f3d5e7812ULL, 0x000fc400078ec0ffULL, 0xfffffff80c4f7812ULL, 0x000fe400078ee24fULL,
0xfffffff80d4e7812ULL, 0x000fe400078ee24eULL, 0x0000003f3c5a7812ULL, 0x000fe400078ec0ffULL,
0xfffffff80f507812ULL, 0x000fe200078ee250ULL, 0x0000000fff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x00000007000c7812ULL, 0x000fe400078ec0ffULL, 0x00000012620d7c12ULL, 0x000fc4000f8efcffULL,
0x0000001260337c12ULL, 0x000fe4000f8efcffULL, 0x000000125e377c12ULL, 0x000fe4000f8efcffULL,
0x0000003f086d7812ULL, 0x000fe200078ec0ffULL, 0x0000020033327825ULL, 0x100fe200078e000eULL,
0x000000125a357c12ULL, 0x000fe4000f8efcffULL, 0x000000020900720cULL, 0x000fe20003f26070ULL,
0x0000020037367825ULL, 0x000fe200078e000eULL, 0x0ffffff80c617812ULL, 0x000fc400078ef871ULL,
0x000000023e00720cULL, 0x080fe20003f46070ULL, 0x000002000d0c7825ULL, 0x100fe200078e000eULL,
0x000000023d00720cULL, 0x080fe40003f66070ULL, 0xfffffff830007812ULL, 0x000fe200078ee271ULL,
0x0000020035347825ULL, 0x000fe200078e000eULL, 0x000000023c00720cULL, 0x080fe40003f86070ULL,
0x000000126d317c12ULL, 0x000fe2000f8efcffULL, 0x00000010000c7825ULL, 0x000fe200078e000cULL,
0x000000020800720cULL, 0x000fc40003fa6070ULL, 0x0000003f076c7812ULL, 0x000fe200078ec0ffULL,
0x0000020031307825ULL, 0x000fe200078e000eULL, 0x0000001161397c11ULL, 0x000fe4000f8e20ffULL,
0x0000003f066b7812ULL, 0x000fe200078ec0ffULL, 0x0000001000327825ULL, 0x040fe200078e0032ULL,
0x000000115f3b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c397faeULL, 0x0003e2000c901c54ULL, 0x0000003f056a7812ULL, 0x000fe200078ec0ffULL,
0x0000001000367825ULL, 0x000fe200078e0036ULL, 0x000000115b417c11ULL, 0x000fe2000f8e20ffULL,
0x00000000323b7faeULL, 0x0005e2000d101c54ULL, 0x0000003f04647812ULL, 0x000fe200078ec0ffULL,
0x0000001000347825ULL, 0x000fe200078e0034ULL, 0x0000001159437c11ULL, 0x000fe2000f8e20ffULL,
0x0000000036417faeULL, 0x0007e2000d901c54ULL, 0x000000126c477c12ULL, 0x000fe2000f8efcffULL,
0x0000001000307825ULL, 0x000fe200078e0030ULL, 0x000000126b5d7c12ULL, 0x000fe2000f8efcffULL,
0x0000000034437faeULL, 0x0009e2000e101c54ULL, 0x000000126a657c12ULL, 0x000fe2000f8efcffULL,
0x00000200470c7825ULL, 0x002fe200078e000eULL, 0x0000003f03637812ULL, 0x000fc400078ec0ffULL,
0x0000001264677c12ULL, 0x000fe2000f8efcffULL, 0x000002005d327825ULL, 0x104fe200078e000eULL,
0x000000020700720cULL, 0x080fe40003f26070ULL, 0x0000001158457c11ULL, 0x000fe2000f8e20ffULL,
0x0000020065367825ULL, 0x108fe200078e000eULL, 0x000000020600720cULL, 0x080fe40003f46070ULL,
0x000000020500720cULL, 0x080fe20003f66070ULL, 0x0000020067347825ULL, 0x010fe200078e000eULL,
0x000000020400720cULL, 0x080fe20003f86070ULL, 0x0000000030457faeULL, 0x0003e2000e901c54ULL,
0x0000001263697c12ULL, 0x000fe2000f8efcffULL, 0x00000010000c7825ULL, 0x000fe200078e000cULL,
0x000000020300720cULL, 0x000fc40003fa6070ULL, 0x0000001157397c11ULL, 0x000fe2000f8e20ffULL,
0x0000001000327825ULL, 0x000fe200078e0032ULL, 0x00000011563b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001155417c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000367825ULL, 0x000fe200078e0036ULL,
0x0000001154437c11ULL, 0x000fe2000f8e20ffULL, 0x000000000c397faeULL, 0x0005e2000c901c54ULL,
0x0000003f4a687812ULL, 0x000fe200078ec0ffULL, 0x0000020069307825ULL, 0x002fe200078e000eULL,
0x0000003f4b697812ULL, 0x000fe200078ec0ffULL, 0x00000000323b7faeULL, 0x000fe2000d101c54ULL,
0x0000001153457c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000347825ULL, 0x000fe200078e0034ULL,
0x0000003f49677812ULL, 0x000fe200078ec0ffULL, 0x0000000036417faeULL, 0x0003e2000d901c54ULL,
0x0000003f48667812ULL, 0x000fe200078ec0ffULL, 0x0000001000307825ULL, 0x000fe200078e0030ULL,
0x0000003f3f657812ULL, 0x000fe200078ec0ffULL, 0x0000000034437faeULL, 0x0007e2000e101c54ULL,
0x0000003f4c6e7812ULL, 0x000fc400078ec0ffULL, 0x0000001267397c12ULL, 0x004fe2000f8efcffULL,
0x0000000030457faeULL, 0x0005e2000e901c54ULL, 0x000000024b00720cULL, 0x080fe40003f26070ULL,
0x00000012660d7c12ULL, 0x000fe2000f8efcffULL, 0x0000020039387825ULL, 0x100fe200078e000eULL,
0x0000001268377c12ULL, 0x002fe4000f8efcffULL, 0x000000024a00720cULL, 0x000fe20003f46070ULL,
0x000002000d0c7825ULL, 0x000fe200078e000eULL, 0x0000001269357c12ULL, 0x008fc4000f8efcffULL,
0x000000024900720cULL, 0x080fe20003f66070ULL, 0x0000020037367825ULL, 0x100fe200078e000eULL,
0x0000001265317c12ULL, 0x004fe4000f8efcffULL, 0x000000126e337c12ULL, 0x000fe2000f8efcffULL,
0x0000020035347825ULL, 0x100fe200078e000eULL, 0x000000024800720cULL, 0x080fe40003f86070ULL,
0x000000023f00720cULL, 0x080fe20003fa6070ULL, 0x0000020031307825ULL, 0x000fe200078e000eULL,
0x000000024c00720cULL, 0x000fc40003fc6070ULL, 0x00000011523b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020033327825ULL, 0x000fe200078e000eULL, 0x0000001151417c11ULL, 0x000fe4000f8e20ffULL,
0x0000001150437c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000347825ULL, 0x000fe200078e0034ULL,
0x000000114f457c11ULL, 0x000fe4000f8e20ffULL, 0x000000114e477c11ULL, 0x000fe2000f8e20ffULL,
0x0000001000367825ULL, 0x000fe200078e0036ULL, 0x00000000343b7faeULL, 0x0003e2000c901c54ULL,
0x000000116f5d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001000387825ULL, 0x040fe200078e0038ULL,
0x0000000036417faeULL, 0x0003e6000d101c54ULL, 0x00000010000c7825ULL, 0x040fe200078e000cULL,
0x0000000038437faeULL, 0x0003e6000d901c54ULL, 0x0000001000307825ULL, 0x040fe200078e0030ULL,
0x000000000c457faeULL, 0x0003e6000e101c54ULL, 0x0000001000327825ULL, 0x000fe200078e0032ULL,
0x0000000030477faeULL, 0x0003e8000e901c54ULL, 0x00000000325d7faeULL, 0x0003e2000f101c54ULL,
0x0000000800b47947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe20000011671ULL,
0x00008400000d7ab9ULL, 0x000fe20000000800ULL, 0x00000003160e7899ULL, 0x000fe4000800063fULL,
0x000000060d0d7899ULL, 0x000fe2000800063fULL, 0x00000004093e7836ULL, 0x040fe20000000000ULL,
0x0000003f09627812ULL, 0x040fe200078ec0ffULL, 0x0000001009087836ULL, 0x040fe20000000000ULL,
0x000000120d1272a4ULL, 0x000fe2000f8e0208ULL, 0x000000083e007824ULL, 0x040fe200078e00ffULL,
0x000000713e5f7212ULL, 0x080fe200078e3cffULL, 0x00000008093d7836ULL, 0x040fe20000000000ULL,
0x0000007108587212ULL, 0x0c0fe200078e3cffULL, 0x0000000808037824ULL, 0x000fe200078e00ffULL,
0xfffffff8005f7812ULL, 0x000fe200078ee25fULL, 0x00000028094b7836ULL, 0x000fe20000000000ULL,
0x000000713d5b7212ULL, 0x080fe200078e3cffULL, 0x0000001809067836ULL, 0x000fe20000000000ULL,
0xfffffff803587812ULL, 0x000fe200078ee258ULL, 0x000000083d007824ULL, 0x000fe200078e00ffULL,
0x000000714b527212ULL, 0x0c0fe200078e3cffULL, 0x000000084b0f7824ULL, 0x000fe200078e00ffULL,
0x0000007106567212ULL, 0x0c0fe200078e3cffULL, 0x0000001409077836ULL, 0x040fe20000000000ULL,
0xfffffff8005b7812ULL, 0x000fe200078ee25bULL, 0x0000000806037824ULL, 0x000fe200078e00ffULL,
0xfffffff80f527812ULL, 0x000fe200078ee252ULL, 0x0000002009047836ULL, 0x040fe20000000000ULL,
0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL, 0x0000000c093c7836ULL, 0x000fe20000000000ULL,
0x0000007107577212ULL, 0x0c0fe200078e3cffULL, 0x0000000807007824ULL, 0x000fe200078e00ffULL,
0xfffffff803567812ULL, 0x000fe200078ee256ULL, 0x00000008040d7824ULL, 0x040fe200078e00ffULL,
0x0000007104547212ULL, 0x080fe200078e3cffULL, 0x000000083c027824ULL, 0x040fe200078e00ffULL,
0x000000713c597212ULL, 0x080fe200078e3cffULL, 0x0000002409037836ULL, 0x040fe20000000000ULL,
0xfffffff800577812ULL, 0x000fe200078ee257ULL, 0x0000003009497836ULL, 0x040fe20000000000ULL,
0xfffffff80d547812ULL, 0x000fe200078ee254ULL, 0x0000001c09057836ULL, 0x000fe20000000000ULL,
0xfffffff802597812ULL, 0x000fe200078ee259ULL, 0x0000000803007824ULL, 0x040fe200078e00ffULL,
0x0000007103537212ULL, 0x080fe200078e3cffULL, 0x00000008490d7824ULL, 0x040fe200078e00ffULL,
0x0000007149507212ULL, 0x080fe200078e3cffULL, 0x0000000805027824ULL, 0x040fe200078e00ffULL,
0x0000007105557212ULL, 0x080fe200078e3cffULL, 0x0000002c094a7836ULL, 0x040fe20000000000ULL,
0xfffffff800537812ULL, 0x000fe200078ee253ULL, 0x00000038093f7836ULL, 0x040fe20000000000ULL,
0xfffffff80d507812ULL, 0x000fe200078ee250ULL, 0x0000003409487836ULL, 0x000fe20000000000ULL,
0xfffffff802557812ULL, 0x000fe200078ee255ULL, 0x000000084a007824ULL, 0x040fe200078e00ffULL,
0x000000714a517212ULL, 0x080fe200078e3cffULL, 0x000000083f0d7824ULL, 0x040fe200078e00ffULL,
0x000000713f4e7212ULL, 0x080fe200078e3cffULL, 0x0000000848027824ULL, 0x040fe200078e00ffULL,
0x00000071484f7212ULL, 0x080fe200078e3cffULL, 0x00000007161a7291ULL, 0x000fe2000f8e703fULL,
0x0000003f3e607812ULL, 0x000fe200078ec0ffULL, 0x0000003c094c7836ULL, 0x000fe20000000000ULL,
0xfffffff800517812ULL, 0x000fe200078ee251ULL, 0x0000001a0b117291ULL, 0x000fe2000f8e683fULL,
0x0000003f3d5e7812ULL, 0x000fe200078ec0ffULL, 0x000000084c367824ULL, 0x000fe200078e00ffULL,
0xfffffff80d4e7812ULL, 0x000fe200078ee24eULL, 0x0001400011117890ULL, 0x000fe2000fffe03fULL,
0x0000007109007212ULL, 0x000fc400078e3cffULL, 0x0000003f3c5a7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8024f7812ULL, 0x000fe200078ee24fULL, 0x0000000eff027e24ULL, 0x000fe2000f8e00ffULL,
0x00000012620d7c12ULL, 0x000fe4000f8efcffULL, 0x0000001260317c12ULL, 0x000fe4000f8efcffULL,
0x000000125e337c12ULL, 0x000fe2000f8efcffULL, 0x000002000d0c7825ULL, 0x002fe200078e000eULL,
0x0000000700007812ULL, 0x000fc400078ec0ffULL, 0x000000125a357c12ULL, 0x000fe2000f8efcffULL,
0x0000020031307825ULL, 0x100fe200078e000eULL, 0xfffffff802027812ULL, 0x000fe400078ee271ULL,
0x0ffffff800617812ULL, 0x000fe200078ef871ULL, 0x0000020033327825ULL, 0x100fe200078e000eULL,
0x000000115f397c11ULL, 0x000fe4000f8e20ffULL, 0x0000001161377c11ULL, 0x000fe2000f8e20ffULL,
0x0000020035347825ULL, 0x000fe200078e000eULL, 0x000000115b3b7c11ULL, 0x000fc4000f8e20ffULL,
0x0000001159417c11ULL, 0x000fe2000f8e20ffULL, 0x00000010020c7825ULL, 0x000fe200078e000cULL,
0x0000003f086d7812ULL, 0x000fe400078ec0ffULL, 0x0000003f076c7812ULL, 0x000fe200078ec0ffULL,
0x0000001002307825ULL, 0x000fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c377faeULL, 0x000fe2000b901c54ULL, 0x0000003f066b7812ULL, 0x000fe400078ec0ffULL,
0x0000001002327825ULL, 0x000fe200078e0032ULL, 0x0000000030397faeULL, 0x000fe2000b901c54ULL,
0x0000003f056a7812ULL, 0x000fc400078ec0ffULL, 0x0000001002347825ULL, 0x000fe200078e0034ULL,
0x00000000323b7faeULL, 0x0003e2000b901c54ULL, 0x0000003f04647812ULL, 0x000fe400078ec0ffULL,
0x0000003f03637812ULL, 0x000fe200078ec0ffULL, 0x0000000034417faeULL, 0x0005e2000b901c54ULL,
0x0000003f4b697812ULL, 0x000fe400078ec0ffULL, 0x000000126b437c12ULL, 0x000fe4000f8efcffULL,
0x0000003f4a687812ULL, 0x000fc400078ec0ffULL, 0x000000126a457c12ULL, 0x000fe2000f8efcffULL,
0x0000020043427825ULL, 0x100fe200078e000eULL, 0x000000126d3b7c12ULL, 0x002fe4000f8efcffULL,
0x0000003f49677812ULL, 0x000fe200078ec0ffULL, 0x0000020045447825ULL, 0x100fe200078e000eULL,
0x000000126c417c12ULL, 0x004fe4000f8efcffULL, 0x0000001264477c12ULL, 0x000fe2000f8efcffULL,
0x000002003b3a7825ULL, 0x000fe200078e000eULL, 0x0000003f48667812ULL, 0x000fc400078ec0ffULL,
0x00000012635d7c12ULL, 0x000fe2000f8efcffULL, 0x0000020041407825ULL, 0x100fe200078e000eULL,
0x0000003f3f657812ULL, 0x000fe400078ec0ffULL, 0x0000003f4c6e7812ULL, 0x000fe200078ec0ffULL,
0x0000020047467825ULL, 0x100fe200078e000eULL, 0x00000012690d7c12ULL, 0x000fe4000f8efcffULL,
0x0000001268317c12ULL, 0x000fe2000f8efcffULL, 0x000002005d5c7825ULL, 0x000fe200078e000eULL,
0x0000001267337c12ULL, 0x000fc4000f8efcffULL, 0x0000001266357c12ULL, 0x000fe2000f8efcffULL,
0x000002000d0c7825ULL, 0x000fe200078e000eULL, 0x000000714c6f7212ULL, 0x000fe400078e3cffULL,
0x0000001265377c12ULL, 0x000fe2000f8efcffULL, 0x00000010023a7825ULL, 0x000fe200078e003aULL,
0x000000126e397c12ULL, 0x000fe4000f8efcffULL, 0x0000001158007c11ULL, 0x000fe2000f8e20ffULL,
0x0000020031307825ULL, 0x000fe200078e000eULL, 0x0000001157737c11ULL, 0x000fc4000f8e20ffULL,
0x0000001156757c11ULL, 0x000fe2000f8e20ffULL, 0x0000001002407825ULL, 0x000fe200078e0040ULL,
0xfffffff8366f7812ULL, 0x000fe200078ee26fULL, 0x000000003a007faeULL, 0x0003e2000b901c54ULL,
0x0000001155777c11ULL, 0x000fe2000f8e20ffULL, 0x0000020033327825ULL, 0x000fe200078e000eULL,
0x0000001154797c11ULL, 0x000fe2000f8e20ffULL, 0x0000000040737faeULL, 0x0005e2000b901c54ULL,
0x00000011537b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001002427825ULL, 0x000fe200078e0042ULL,
0x00000011527d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020035347825ULL, 0x000fe200078e000eULL,
0x0000000042757faeULL, 0x0007e2000b901c54ULL, 0x00000011513b7c11ULL, 0x002fe4000f8e20ffULL,
0x0000001002447825ULL, 0x000fe200078e0044ULL, 0x000000114e007c11ULL, 0x000fe4000f8e20ffULL,
0x0000001150417c11ULL, 0x004fe2000f8e20ffULL, 0x0000020037367825ULL, 0x000fe200078e000eULL,
0x0000000044777faeULL, 0x0007e2000b901c54ULL, 0x000000114f737c11ULL, 0x000fc4000f8e20ffULL,
0x0000020039387825ULL, 0x000fc800078e000eULL, 0x0000001002467825ULL, 0x000fc800078e0046ULL,
0x00000010025c7825ULL, 0x040fe200078e005cULL, 0x0000000046797faeULL, 0x0007e6000b901c54ULL,
0x00000010020c7825ULL, 0x040fe200078e000cULL, 0x000000005c7b7faeULL, 0x0007e6000b901c54ULL,
0x0000001002307825ULL, 0x040fe200078e0030ULL, 0x000000000c7d7faeULL, 0x0007e6000b901c54ULL,
0x0000001002327825ULL, 0x040fe200078e0032ULL, 0x00000000303b7faeULL, 0x0007e6000b901c54ULL,
0x0000001002347825ULL, 0x040fe200078e0034ULL, 0x0000000032417faeULL, 0x0007e6000b901c54ULL,
0x0000001002367825ULL, 0x040fe200078e0036ULL, 0x0000000034737faeULL, 0x0007e6000b901c54ULL,
0x0000001002387825ULL, 0x000fe200078e0038ULL, 0x000000116f027c11ULL, 0x000fe2000f8e20ffULL,
0x0000000036007faeULL, 0x0007e8000b901c54ULL, 0x0000000038027faeULL, 0x0007e4000b901c54ULL,
0x0000500001007983ULL, 0x008ea20000100800ULL, 0x00000003090e7892ULL, 0x000fe4000f8ec03fULL,
0xfffffffd170f7891ULL, 0x000fe2000f8e103fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000030e00788cULL, 0x000fc8000bf05270ULL, 0x000000010f127887ULL, 0x000fc8000c000000ULL,
0x0000001209097290ULL, 0x000fc8000fffe03fULL, 0x000000050900728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f2f008ULL, 0x0000000a09198290ULL, 0x000fe2000fffe03fULL,
0x00008c0000128ab9ULL, 0x000fc60000000a00ULL, 0x00000004191288a5ULL, 0x000fcc000f8e0012ULL,
0x00000012ff0c7e24ULL, 0x002fe4000f8e00ffULL, 0x00000013ff0d7e24ULL, 0x000fca000f8e00ffULL,
0x000000140c5d9981ULL, 0x000362000c1e1900ULL, 0x0000001071027824ULL, 0x000fca00078e00ffULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000ffff00007812ULL, 0x004fc800078ec0ffULL,
0x00000000000e72caULL, 0x000fda00000e0000ULL, 0x000088800e0e7896ULL, 0x000fc8000800003fULL,
0x0000001f0e197899ULL, 0x000fcc000800063fULL, 0x00000019ff307e24ULL, 0x000fc8000f8e00ffULL,
0x02460830ff0075a7ULL, 0x000ea20008040147ULL, 0x00000001ff007819ULL, 0x000fc80000011671ULL,
0x0000000c00317812ULL, 0x000fc800078ec0ffULL, 0x0000000731027c10ULL, 0x000fe2000fffe002ULL,
0x0000010800f4a947ULL, 0x006fec0003800000ULL, 0x0240000002007984ULL, 0x000e620000000800ULL,
0x00000007715c7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff417424ULL, 0x000fe200078e00ffULL,
0x00000004ff0d7819ULL, 0x000fe20000011671ULL, 0x0242000002447984ULL, 0x0004a20000000800ULL,
0x000000085c707812ULL, 0x000fe400078ef871ULL, 0x0000000b0000720bULL, 0x002fda0003f5d000ULL,
0x00000000000c7806ULL, 0x000fc800010e0100ULL, 0x0000ffff0c327812ULL, 0x000fda000784c0ffULL,
0x0000000000d4a947ULL, 0x004fea0003800000ULL, 0x0000000b0000720bULL, 0x000fe40003f54000ULL,
0x000000000b337209ULL, 0x000fe40007810000ULL, 0x00000002ff307819ULL, 0x000fc60000011671ULL,
0x800000330b0c7221ULL, 0x000fe40000010000ULL, 0x0000000830317836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL, 0x00000000000b7806ULL, 0x000fe400010e0100ULL,
0x0000000c00357308ULL, 0x000e620000000800ULL, 0x00000016ff007c0cULL, 0x000fe4000bf45270ULL,
0x0000ffff0b0b7812ULL, 0x000fc800078e3cffULL, 0x0000000b32ff7212ULL, 0x000fe2000786c0ffULL,
0x000000ffff0b7224ULL, 0x000fc600078e0033ULL, 0x00000001ff417807ULL, 0x000fc60001800000ULL,
0x024400330200a388ULL, 0x000fe20000000800ULL, 0x000000350a0a7220ULL, 0x002fc60000410000ULL,
0x00001f3135317589ULL, 0x000e6400000e0000ULL, 0x8000003300003221ULL, 0x000fe40000010000ULL,
0x00001f3035307589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b00003820ULL, 0x000fc80000410000ULL,
0x00000000004d3308ULL, 0x000ee20000000800ULL, 0x000000312f2f7220ULL, 0x082fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x000000312a2a7220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x0000003112127220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x000fe20000410000ULL, 0x000000302d2d7220ULL, 0x084fe20000410000ULL,
0x000000302c2c7220ULL, 0x080fe20000410000ULL, 0x0000003029297220ULL, 0x080fe20000410000ULL,
0x0000003028287220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x0000003010107220ULL, 0x080fe20000410000ULL, 0x0000003015157220ULL, 0x080fe20000410000ULL,
0x0000003014147220ULL, 0x000fe20000410000ULL, 0x0000004d44443220ULL, 0x008fce0000410000ULL,
0x0000000871477812ULL, 0x000fe200078ec0ffULL, 0x0000001a04047291ULL, 0x000fe2000f8e683fULL,
0x000000070d317812ULL, 0x000fe200078e7870ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000747407812ULL, 0x000fe200078ec85cULL, 0x0000000870317824ULL, 0x000fe200078e0231ULL,
0x0000005c47477212ULL, 0x000fe200078efcffULL, 0x0001400004047890ULL, 0x000fe2000fffe03fULL,
0x0000000d40457212ULL, 0x040fe200078e3cffULL, 0x000000020d727836ULL, 0x000fe20000000000ULL,
0x0000000731797c11ULL, 0x000fe2000f8e20ffULL, 0x000000181b00728cULL, 0x000fe2000bf26070ULL,
0x00000002ff0c7819ULL, 0x000fe20000011671ULL, 0x0000000847357824ULL, 0x000fe200078e0245ULL,
0x0000004dff00723eULL, 0x000fe200000010ffULL, 0x012000007930783bULL, 0x000fe20000000200ULL,
0x0000007240467212ULL, 0x000fe200078e3cffULL, 0x000000080c347836ULL, 0x000fe20000000000ULL,
0x0000541000427816ULL, 0x000fe20000000000ULL, 0x0000403501007387ULL, 0x000fe20000100800ULL,
0x0000000435437c11ULL, 0x000fe2000f8e20ffULL, 0x0000000847757824ULL, 0x000fe200078e0246ULL,
0x0000991041417816ULL, 0x000fe200000000ffULL, 0x00001f3442007589ULL, 0x000fe200000e0000ULL,
0x000000005d1392caULL, 0x020fe200000e0000ULL, 0xffffffff00127882ULL, 0x000fe20000000000ULL,
0x0000000475387c11ULL, 0x000fe2000f8e20ffULL, 0x000000004334783bULL, 0x000fe20000004200ULL,
0x000000ff4100720cULL, 0x000fe20003f45270ULL, 0x0000000a440a7221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fe20003f2f018ULL, 0x00001f0c420c7589ULL, 0x000e6800000e0000ULL,
0x000000003838783bULL, 0x000ea40000004200ULL, 0x0000001300128c82ULL, 0x000fc80008000000ULL,
0x0000000c3030a232ULL, 0x082fe40000200000ULL, 0x0000000c3232a232ULL, 0x000fe40000200000ULL,
0x000000003131a232ULL, 0x080fe40000200000ULL, 0x000000003333a232ULL, 0x000fce0000200000ULL,
0x000000343014723cULL, 0x000fec0000041814ULL, 0x000000363034723cULL, 0x000fec0000041810ULL,
0x000000383018723cULL, 0x004fe20000041818ULL, 0x000000040d137836ULL, 0x040fe20000000000ULL,
0x0000000772117812ULL, 0x000fe200078e7870ULL, 0x000000060d127836ULL, 0x000fc60000000000ULL,
0x00000013400d7212ULL, 0x040fe200078e3cffULL, 0x0000003a301c723cULL, 0x000fe2000004181cULL,
0x0000001240107212ULL, 0x000fe200078e3cffULL, 0x0000000870117824ULL, 0x040fe200078e0211ULL,
0x0000000713137812ULL, 0x000fe200078e7870ULL, 0x0000000847777824ULL, 0x040fe400078e020dULL,
0x0000000847737824ULL, 0x000fe200078e0210ULL, 0x0000000711747c11ULL, 0x000fe2000f8e20ffULL,
0x0000000870137824ULL, 0x000fe200078e0213ULL, 0x0000000477407c11ULL, 0x000fc4000f8e20ffULL,
0x0000000473387c11ULL, 0x000fe2000f8e20ffULL, 0x0000007301007387ULL, 0x0003e20000100800ULL,
0x0000008047117811ULL, 0x000fc600078e18ffULL, 0x000000004040783bULL, 0x000ea40000004200ULL,
0x00000001457d7824ULL, 0x100fe400078e0211ULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x00000001467b7824ULL, 0x100fe400078e0211ULL, 0x000000010d737824ULL, 0x102fe400078e0211ULL,
0x0000000110787824ULL, 0x000fe200078e0211ULL, 0x0000010047117811ULL, 0x000fc400078e18ffULL,
0x0000047301007387ULL, 0x000fe60000100800ULL, 0x00000001457a7824ULL, 0x100fe400078e0211ULL,
0x00000001467c7824ULL, 0x100fe400078e0211ULL, 0x000000010d767824ULL, 0x000fe200078e0211ULL,
0x000000403020723cULL, 0x004fec0000041820ULL, 0x000000423024723cULL, 0x000fe20000041824ULL,
0x000000047d407c11ULL, 0x000fc4000f8e20ffULL, 0x000000047b417c11ULL, 0x000fc6000f8e20ffULL,
0x000000383028723cULL, 0x008fec0000041828ULL, 0x0000003a302c723cULL, 0x000fe2000004182cULL,
0x012000007430783bULL, 0x000e680000000200ULL, 0x000000004038783bULL, 0x0004e40000004200ULL,
0x0000000473407c11ULL, 0x004fc4000f8e20ffULL, 0x0000000713737c11ULL, 0x000fe4000f8e20ffULL,
0x000000047c137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c3030a232ULL, 0x082fe40000200000ULL,
0x0000000c3232a232ULL, 0x000fe40000200000ULL, 0x000000003131a232ULL, 0x080fe40000200000ULL,
0x000000003333a232ULL, 0x000fce0000200000ULL, 0x000000383014723cULL, 0x008fec0000041814ULL,
0x0000003a3034723cULL, 0x000fe20000041834ULL, 0x000000004138783bULL, 0x000e6a0000004200ULL,
0x000000383018723cULL, 0x002fec0000041818ULL, 0x0000003a301c723cULL, 0x000fe2000004181cULL,
0x000000004038783bULL, 0x000e6a0000004200ULL, 0x000000383020723cULL, 0x002fec0000041820ULL,
0x0000003a3024723cULL, 0x000fe20000041824ULL, 0x0000000478387c11ULL, 0x000fcc000f8e20ffULL,
0x000000003838783bULL, 0x000e640000004200ULL, 0x000000383028723cULL, 0x002fec0000041828ULL,
0x0000003a302c723cULL, 0x000fee000004182cULL, 0x0000000712317812ULL, 0x000fc400078e7870ULL,
0x000000047a127c11ULL, 0x000fc6000f8e20ffULL, 0x0000000870407824ULL, 0x000fe400078e0231ULL,
0x012000007330783bULL, 0x000e660000000200ULL, 0x0000000740727c11ULL, 0x000fe2000f8e20ffULL,
0x000000001238783bULL, 0x0004e40000004200ULL, 0x0000018047127811ULL, 0x004fe200078e18ffULL,
0x0000000110477824ULL, 0x000fc800078e0211ULL, 0x0000000146427824ULL, 0x100fe400078e0212ULL,
0x000000010d467824ULL, 0x100fe200078e0212ULL, 0x00000004470d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000145437824ULL, 0x100fe400078e0212ULL, 0x0000000110417824ULL, 0x000fc600078e0212ULL,
0x0000000443407c11ULL, 0x000fe2000f8e20ffULL, 0x0000104301007387ULL, 0x000fe80000100800ULL,
0x0000084201007387ULL, 0x000fe80000100800ULL, 0x00000c4101007387ULL, 0x000fe20000100800ULL,
0x0000000c3030a232ULL, 0x002fc40000200000ULL, 0x0000000c3232a232ULL, 0x000fe40000200000ULL,
0x000000003131a232ULL, 0x080fe40000200000ULL, 0x000000003333a232ULL, 0x000fce0000200000ULL,
0x000000383014723cULL, 0x008fec0000041814ULL, 0x0000003a3034723cULL, 0x000fe20000041834ULL,
0x000000001338783bULL, 0x000e680000004200ULL, 0x000000000d10783bULL, 0x000ea20000004200ULL,
0x000000383018723cULL, 0x002fec0000041818ULL, 0x0000003a301c723cULL, 0x000fe2000004181cULL,
0x0000000476387c11ULL, 0x000fca000f8e20ffULL, 0x000000103028723cULL, 0x004fe20000041828ULL,
0x000000003838783bULL, 0x000e6a0000004200ULL, 0x000000383020723cULL, 0x002fec0000041820ULL,
0x0000003a3024723cULL, 0x000fec0000041824ULL, 0x000000123030723cULL, 0x000fe2000004182cULL,
0x01200000722c783bULL, 0x000e680000000200ULL, 0x000000004010783bULL, 0x000ea40000004200ULL,
0x000000002d2da232ULL, 0x002fc40000200000ULL, 0x000000002f2fa232ULL, 0x000fe20000200000ULL,
0x0000000442007c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c2c2ca232ULL, 0x080fe40000200000ULL,
0x0000000c2e2ea232ULL, 0x000fe40000200000ULL, 0x000000000038783bULL, 0x0002ea0000004200ULL,
0x000000102c14723cULL, 0x004fe20000041814ULL, 0x00000001ff007424ULL, 0x002fca00078e00ffULL,
0x000000122c10723cULL, 0x000fee0000041834ULL, 0x0000000446347c11ULL, 0x000fcc000f8e20ffULL,
0x000000003434783bULL, 0x000e620000004200ULL, 0x000000382c18723cULL, 0x008fec0000041818ULL,
0x0000003a2c1c723cULL, 0x000fe2000004181cULL, 0x0000000441387c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b00047c82ULL, 0x000fca0008000000ULL, 0x000000003838783bULL, 0x000ea20000004200ULL,
0x02461000ffff79a7ULL, 0x0007e20008500007ULL, 0x000000342c20723cULL, 0x002fec0000041820ULL,
0x000000362c24723cULL, 0x000fec0000041824ULL, 0x000000382c28723cULL, 0x004fec0000041828ULL,
0x0000003a2c2c723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000048000c1947ULL, 0x008fde0003800000ULL, 0x000000800c1b7890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400c08947ULL, 0x000ff40003800000ULL,
0x0000001b1800728cULL, 0x000fe4000bf01070ULL, 0x8000001bff0c7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000316137899ULL, 0x000fe4000800063fULL, 0x0000001b18047287ULL, 0x000fe4000c000000ULL,
0x000000120d1272a4ULL, 0x000fe4000f8e0208ULL, 0x00000013ff317e24ULL, 0x000fe2000f8e00ffULL,
0x0000000110107892ULL, 0x000fe2000f8ec03fULL, 0x00000004ff0d7e24ULL, 0x000fc4000f8e00ffULL,
0x0000001260337c12ULL, 0x000fe2000f8efcffULL, 0x0000001a10047291ULL, 0x000fe2000f8e683fULL,
0xfffffff831007812ULL, 0x000fe400078ee25cULL, 0x000000400d0c7446ULL, 0x000fe2000380000cULL,
0x0001400004197890ULL, 0x000fe2000fffe03fULL, 0x0000001262317c12ULL, 0x000fe4000f8efcffULL,
0x0000000c0900720cULL, 0x000fe40003f26070ULL, 0x000000125e357c12ULL, 0x000fe2000f8efcffULL,
0x0000020031307825ULL, 0x000fe200078e000eULL, 0x00000019610d7c11ULL, 0x000fc6000f8e20ffULL,
0x0000001000307825ULL, 0x000fcc00078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000300d7faeULL, 0x0003e2000c901c54ULL, 0x0000000c3e00720cULL, 0x000fe20003f26070ULL,
0x0000020033307825ULL, 0x002fe200078e000eULL, 0x000000195f337c11ULL, 0x000fe4000f8e20ffULL,
0x000000195b0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x0000000030337faeULL, 0x0003e2000c901c54ULL, 0x0000000c3d00720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x000000125a357c12ULL, 0x000fe4000f8efcffULL,
0x0000001959337c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x00000000300d7faeULL, 0x0003e2000c901c54ULL, 0x0000000c3c00720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x000000126d357c12ULL, 0x000fe4000f8efcffULL,
0x00000019580d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x0000000030337faeULL, 0x0003e2000c901c54ULL, 0x0000000c0800720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x000000126c357c12ULL, 0x000fe4000f8efcffULL,
0x0000001957337c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x00000000300d7faeULL, 0x0003e2000c901c54ULL, 0x0000000c0700720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x000000126b357c12ULL, 0x000fe4000f8efcffULL,
0x00000019560d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x0000000030337faeULL, 0x0003e2000c901c54ULL, 0x0000000c0600720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x000000126a357c12ULL, 0x000fe4000f8efcffULL,
0x0000001955337c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x00000000300d7faeULL, 0x0003e2000c901c54ULL, 0x0000000c0500720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x0000001264357c12ULL, 0x000fe4000f8efcffULL,
0x00000019540d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x0000000030337faeULL, 0x0003e2000c901c54ULL, 0x0000000c0400720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x0000001263357c12ULL, 0x000fe4000f8efcffULL,
0x0000001953337c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x00000000300d7faeULL, 0x0003e2000c901c54ULL, 0x0000000c0300720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x0000001269357c12ULL, 0x000fe4000f8efcffULL,
0x00000019520d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x0000000030337faeULL, 0x0003e2000c901c54ULL, 0x0000000c4b00720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x0000001268357c12ULL, 0x000fe4000f8efcffULL,
0x0000001951337c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x00000000300d7faeULL, 0x0003e2000c901c54ULL, 0x0000000c4a00720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x0000001267357c12ULL, 0x000fe4000f8efcffULL,
0x00000019500d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x0000000030337faeULL, 0x0003e2000c901c54ULL, 0x0000000c4900720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x0000001266357c12ULL, 0x000fe4000f8efcffULL,
0x000000194f337c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x00000000300d7faeULL, 0x0003e2000c901c54ULL, 0x0000000c4800720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x0000001265357c12ULL, 0x000fe4000f8efcffULL,
0x000000126e0d7c12ULL, 0x000fe2000f8efcffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x0000000030337faeULL, 0x0003e2000c901c54ULL, 0x0000000c3f00720cULL, 0x000fe20003f26070ULL,
0x0000020035307825ULL, 0x002fe200078e000eULL, 0x000000194e357c11ULL, 0x000fe4000f8e20ffULL,
0x000000196f337c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000307825ULL, 0x000fd000078e0030ULL,
0x0000000030357faeULL, 0x0003e2000c901c54ULL, 0x0000000c4c00720cULL, 0x000fe20003f26070ULL,
0x000002000d0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fd000078e000cULL,
0x000000000c337faeULL, 0x0003e2000c901c54ULL, 0x0000000400687947ULL, 0x000fea0003800000ULL,
0x000000120d1272a4ULL, 0x000fe4000f8e0208ULL, 0x0000000316047899ULL, 0x000fe4000800063fULL,
0x0000000110107892ULL, 0x000fe4000f8ec03fULL, 0x00000012620d7c12ULL, 0x000fe4000f8efcffULL,
0x00000004ff317e24ULL, 0x000fe2000f8e00ffULL, 0x0000001a10197291ULL, 0x000fe2000f8e683fULL,
0x0000001260337c12ULL, 0x000fe2000f8efcffULL, 0x000002000d0c7825ULL, 0x000fe200078e000eULL,
0x000000125e357c12ULL, 0x000fe2000f8efcffULL, 0x0001400019197890ULL, 0x000fe2000fffe03fULL,
0xfffffff831007812ULL, 0x000fca00078ee25cULL, 0x00000010000c7825ULL, 0x000fe200078e000cULL,
0x0000001961317c11ULL, 0x000fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c317faeULL, 0x0003e4000b901c54ULL, 0x00000200330c7825ULL, 0x002fe200078e000eULL,
0x000000195f337c11ULL, 0x000fe4000f8e20ffULL, 0x000000125a317c12ULL, 0x000fe2000f8efcffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c337faeULL, 0x0003e4000b901c54ULL,
0x00000200350c7825ULL, 0x002fe200078e000eULL, 0x000000195b357c11ULL, 0x000fe4000f8e20ffULL,
0x000000126d337c12ULL, 0x000fe2000f8efcffULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c357faeULL, 0x0003e4000b901c54ULL, 0x00000200310c7825ULL, 0x002fe200078e000eULL,
0x0000001959317c11ULL, 0x000fe4000f8e20ffULL, 0x000000126c357c12ULL, 0x000fe2000f8efcffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c317faeULL, 0x0003e4000b901c54ULL,
0x00000200330c7825ULL, 0x002fe200078e000eULL, 0x0000001958337c11ULL, 0x000fe4000f8e20ffULL,
0x000000126b317c12ULL, 0x000fe2000f8efcffULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c337faeULL, 0x0003e4000b901c54ULL, 0x00000200350c7825ULL, 0x002fe200078e000eULL,
0x0000001957357c11ULL, 0x000fe4000f8e20ffULL, 0x000000126a337c12ULL, 0x000fe2000f8efcffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c357faeULL, 0x0003e4000b901c54ULL,
0x00000200310c7825ULL, 0x002fe200078e000eULL, 0x0000001956317c11ULL, 0x000fe4000f8e20ffULL,
0x0000001264357c12ULL, 0x000fe2000f8efcffULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c317faeULL, 0x0003e4000b901c54ULL, 0x00000200330c7825ULL, 0x002fe200078e000eULL,
0x0000001955337c11ULL, 0x000fe4000f8e20ffULL, 0x0000001263317c12ULL, 0x000fe2000f8efcffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c337faeULL, 0x0003e4000b901c54ULL,
0x00000200350c7825ULL, 0x002fe200078e000eULL, 0x0000001954357c11ULL, 0x000fe4000f8e20ffULL,
0x0000001269337c12ULL, 0x000fe2000f8efcffULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c357faeULL, 0x0003e4000b901c54ULL, 0x00000200310c7825ULL, 0x002fe200078e000eULL,
0x0000001953317c11ULL, 0x000fe4000f8e20ffULL, 0x0000001268357c12ULL, 0x000fe2000f8efcffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c317faeULL, 0x0003e4000b901c54ULL,
0x00000200330c7825ULL, 0x002fe200078e000eULL, 0x0000001952337c11ULL, 0x000fe4000f8e20ffULL,
0x0000001267317c12ULL, 0x000fe2000f8efcffULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c337faeULL, 0x0003e4000b901c54ULL, 0x00000200350c7825ULL, 0x002fe200078e000eULL,
0x0000001951357c11ULL, 0x000fe4000f8e20ffULL, 0x0000001266337c12ULL, 0x000fe2000f8efcffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c357faeULL, 0x0003e4000b901c54ULL,
0x00000200310c7825ULL, 0x002fe200078e000eULL, 0x0000001950317c11ULL, 0x000fe4000f8e20ffULL,
0x0000001265357c12ULL, 0x000fe2000f8efcffULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c317faeULL, 0x0003e4000b901c54ULL, 0x00000200330c7825ULL, 0x002fe200078e000eULL,
0x000000194f337c11ULL, 0x000fe4000f8e20ffULL, 0x000000126e317c12ULL, 0x000fe2000f8efcffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c337faeULL, 0x0003e4000b901c54ULL,
0x00000200350c7825ULL, 0x002fe200078e000eULL, 0x000000194e357c11ULL, 0x000fc6000f8e20ffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c357faeULL, 0x0003e4000b901c54ULL,
0x00000200310c7825ULL, 0x002fe200078e000eULL, 0x000000196f317c11ULL, 0x000fc6000f8e20ffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c317faeULL, 0x0003e4000b901c54ULL,
0x0000000309047892ULL, 0x000fe2000f8ec03fULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000030400788cULL, 0x000fc8000bf05270ULL, 0x000000010f047887ULL, 0x000fc8000c000000ULL,
0x0000000409097290ULL, 0x000fc8000fffe03fULL, 0x000000050900728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fca0003f2f018ULL, 0x0000000a09049290ULL, 0x000fe2000fffe03fULL,
0x00008c0000129ab9ULL, 0x000fc60000000a00ULL, 0x00000004041298a5ULL, 0x000fe4000f8e0012ULL,
0x0000001f0e047899ULL, 0x000fc8000800063fULL, 0x00000012ff0c7e24ULL, 0x002fe4000f8e00ffULL,
0x00000013ff0d7e24ULL, 0x000fe4000f8e00ffULL, 0x00000004ff307e24ULL, 0x000fc6000f8e00ffULL,
0x000000140c459981ULL, 0x000362000c1e1900ULL, 0x02461830ff0075a7ULL, 0x000ea40008040147ULL,
0x000000f0003ca947ULL, 0x006fea0003800000ULL, 0x0240800002307984ULL, 0x000e620000000800ULL,
0x00000002ff367819ULL, 0x000fe20000011671ULL, 0x00000001ff407424ULL, 0x000fe400078e00ffULL,
0x0242800002447984ULL, 0x0004a40000000800ULL, 0x0000000836357836ULL, 0x000fe20000000000ULL,
0x0000000b3000720bULL, 0x002fda0003f5d000ULL, 0x00000000000c7806ULL, 0x000fc800010e0100ULL,
0x0000ffff0c317812ULL, 0x000fda000784c0ffULL, 0x0000000000d0a947ULL, 0x004fea0003800000ULL,
0x0000000b3000720bULL, 0x000fe20003f54000ULL, 0x000000011600788cULL, 0x000fe2000bf05270ULL,
0x000000300b0c7209ULL, 0x000fca0007810000ULL, 0x8000000c0b0b7221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fc60003f6f008ULL, 0x3fb8aa3b0b0d7820ULL, 0x000fe40000410000ULL,
0x00000000000b7806ULL, 0x000fc800010e0100ULL, 0x0000ffff0b327812ULL, 0x000fe200078e3cffULL,
0x0000000d000d7308ULL, 0x000e660000000800ULL, 0x0000003231ff7212ULL, 0x000fe2000784c0ffULL,
0x0244800c0200b388ULL, 0x000fe60000000800ULL, 0x00000001ff407807ULL, 0x000fe20001000000ULL,
0x00001f360d0b7589ULL, 0x002e7000000e0000ULL, 0x8000000c30302221ULL, 0x000fe20000010000ULL,
0x0000000d0a0a7220ULL, 0x000fc60000410000ULL, 0x3fb8aa3b30312820ULL, 0x000fe40000410000ULL,
0x00001f350d307589ULL, 0x000ea400000e0000ULL, 0x00000031004d2308ULL, 0x000ee20000000800ULL,
0x0000000b14147220ULL, 0x082fe20000410000ULL, 0x0000000b15157220ULL, 0x080fe20000410000ULL,
0x0000000b10107220ULL, 0x080fe20000410000ULL, 0x0000000b11117220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x080fe20000410000ULL,
0x0000000b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000b20207220ULL, 0x080fe20000410000ULL, 0x0000000b21217220ULL, 0x080fe20000410000ULL,
0x0000000b24247220ULL, 0x080fe20000410000ULL, 0x0000000b25257220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x080fe20000410000ULL,
0x0000000b2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x000fe20000410000ULL,
0x0000003016167220ULL, 0x084fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x0000003012127220ULL, 0x080fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x000000302a2a7220ULL, 0x080fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302f2f7220ULL, 0x000fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fc400078e000cULL, 0x000000444d442220ULL, 0x008fce0000410000ULL,
0x00004000010c7983ULL, 0x000ea20000100800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000001427983ULL, 0x000ee20000100800ULL, 0x0000001175347c11ULL, 0x000fe4000f8e20ffULL,
0x0000001177417c11ULL, 0x000fe2000f8e20ffULL, 0x012800007930783bULL, 0x000fe20000000200ULL,
0x0000004dff0d723eULL, 0x000fc800000010ffULL, 0x000054100d0d7816ULL, 0x000fe4000000000dULL,
0x0000991040407816ULL, 0x000fc800000000ffULL, 0x000000ff4000720cULL, 0x000fe40003f45270ULL,
0x000000110c0c7c11ULL, 0x004fca000f8e20ffULL, 0x0000280c01007387ULL, 0x000fe80000100800ULL,
0x0000383401007387ULL, 0x000fe80000100800ULL, 0x0000344101007387ULL, 0x000fe80000100800ULL,
0x00000400015c7983ULL, 0x000ea80000100800ULL, 0x000000000c38783bULL, 0x000fe80000004200ULL,
0x00001f360d0c7589ULL, 0x000e6800000e0000ULL, 0x00001f350d0d7589ULL, 0x000f2200000e0000ULL,
0x00000011425d7c11ULL, 0x008fc6000f8e20ffULL, 0x000000003434783bULL, 0x000ee80000004200ULL,
0x000000004140783bULL, 0x000ee20000004200ULL, 0x0000000c3030a232ULL, 0x082fe40000200000ULL,
0x0000000c3232a232ULL, 0x000fe40000200000ULL, 0x0000000d3131a232ULL, 0x090fe40000200000ULL,
0x0000000d3333a232ULL, 0x000fce0000200000ULL, 0x000000383014723cULL, 0x000fec0000041814ULL,
0x0000003a3010723cULL, 0x000fe20000041810ULL, 0x000000005d38783bULL, 0x000e6a0000004200ULL,
0x000000343018723cULL, 0x008fe20000041818ULL, 0x0000485d01007387ULL, 0x0007ea0000100800ULL,
0x00000036301c723cULL, 0x000fe2000004181cULL, 0x000000117d5d7c11ULL, 0x008fca000f8e20ffULL,
0x000000403020723cULL, 0x000fec0000041820ULL, 0x000000423024723cULL, 0x000fe20000041824ULL,
0x000000005d40783bULL, 0x000fea0000004200ULL, 0x000000383034723cULL, 0x002fe20000041828ULL,
0x012800007428783bULL, 0x000e6c0000000200ULL, 0x000000117b387c11ULL, 0x000fe2000f8e20ffULL,
0x0000445d01007387ULL, 0x000fe20000100800ULL, 0x0000003a302c723cULL, 0x000fe6000004182cULL,
0x0000303801007387ULL, 0x000fe80000100800ULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x0000000c2828a232ULL, 0x002fc40000200000ULL, 0x0000000c2a2aa232ULL, 0x000fe40000200000ULL,
0x0000000d2929a232ULL, 0x080fe40000200000ULL, 0x0000000d2b2ba232ULL, 0x000fce0000200000ULL,
0x000000402814723cULL, 0x000fee0000041814ULL, 0x0000001178407c11ULL, 0x000fe2000f8e20ffULL,
0x000000382818723cULL, 0x008fec0000041818ULL, 0x0000003a281c723cULL, 0x000fe2000004181cULL,
0x000000004038783bULL, 0x000e6a0000004200ULL, 0x000000382834723cULL, 0x002fe20000041834ULL,
0x000000115c5c7c11ULL, 0x004fca000f8e20ffULL, 0x00004c5c01007387ULL, 0x000fe80000100800ULL,
0x00003c4001007387ULL, 0x0003e80000100800ULL, 0x0000100001417983ULL, 0x000ea80000100800ULL,
0x000000005c30783bULL, 0x000ee80000004200ULL, 0x0000080001407983ULL, 0x002f220000100800ULL,
0x000000302820723cULL, 0x008fee0000041820ULL, 0x000000117a307c11ULL, 0x000fca000f8e20ffULL,
0x00002c3001007387ULL, 0x000fe80000100800ULL, 0x00000c0001387983ULL, 0x000ee20000100800ULL,
0x000000422810723cULL, 0x000fec0000041810ULL, 0x000000322824723cULL, 0x000fe20000041824ULL,
0x000000003030783bULL, 0x000fea0000004200ULL, 0x0000003a282c723cULL, 0x000fe2000004182cULL,
0x012800007328783bULL, 0x000e620000000200ULL, 0x000000117c397c11ULL, 0x000fca000f8e20ffULL,
0x0000000c2828a232ULL, 0x082fe40000200000ULL, 0x0000000c2a2aa232ULL, 0x000fe40000200000ULL,
0x0000000d2929a232ULL, 0x080fe40000200000ULL, 0x0000000d2b2ba232ULL, 0x000fce0000200000ULL,
0x000000302814723cULL, 0x000fec0000041814ULL, 0x000000322810723cULL, 0x000fe20000041810ULL,
0x000000003930783bULL, 0x000e680000004200ULL, 0x0000203901007387ULL, 0x0003e40000100800ULL,
0x0000001176397c11ULL, 0x002fe2000f8e20ffULL, 0x000000302818723cULL, 0x000fec0000041818ULL,
0x00000032281c723cULL, 0x000fe2000004181cULL, 0x000000003930783bULL, 0x000e680000004200ULL,
0x00001c3901007387ULL, 0x0003e40000100800ULL, 0x0000001147397c11ULL, 0x002fe2000f8e20ffULL,
0x000000302820723cULL, 0x000fec0000041820ULL, 0x000000322824723cULL, 0x000fe20000041824ULL,
0x000000003930783bULL, 0x000e680000004200ULL, 0x0000183901007387ULL, 0x0005e20000100800ULL,
0x000000302834723cULL, 0x002fec0000041834ULL, 0x000000322830723cULL, 0x000fe2000004182cULL,
0x01280000722c783bULL, 0x000e620000000200ULL, 0x0000001141397c11ULL, 0x004fca000f8e20ffULL,
0x000000003928783bULL, 0x000ea20000004200ULL, 0x0000000c2c2ca232ULL, 0x082fe40000200000ULL,
0x0000000c2e2ea232ULL, 0x000fe40000200000ULL, 0x0000000d2d2da232ULL, 0x080fe40000200000ULL,
0x0000000d2f2fa232ULL, 0x000fe20000200000ULL, 0x00000011400c7c11ULL, 0x010fcc000f8e20ffULL,
0x000000282c14723cULL, 0x004fec0000041814ULL, 0x0000002a2c10723cULL, 0x000fe20000041810ULL,
0x000000000c28783bULL, 0x000e620000004200ULL, 0x0000001146707c11ULL, 0x000fc6000f8e20ffULL,
0x0000243901007387ULL, 0x000fe20000100800ULL, 0x00000011385d7c11ULL, 0x008fca000f8e20ffULL,
0x000000005d38783bULL, 0x000fe20000004200ULL, 0x000000181b00728cULL, 0x000fe2000bf06070ULL,
0x000000282c18723cULL, 0x002fec0000041818ULL, 0x0000002a2c1c723cULL, 0x000fe2000004181cULL,
0x000000007028783bULL, 0x000e680000004200ULL, 0x0000140c01007387ULL, 0x0005e20000100800ULL,
0x00000000451392caULL, 0x020fc400000e0000ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x00000001ff407424ULL, 0x000fe200078e00ffULL, 0xffffffff00127882ULL, 0x000fe20000000000ULL,
0x0000001000047c82ULL, 0x000fe40008000000ULL, 0x02462040ffff79a7ULL, 0x0005e20008500007ULL,
0x0000000a440a7221ULL, 0x000fca0000010000ULL, 0x0000001300129c82ULL, 0x000fe20008000000ULL,
0x000000282c20723cULL, 0x002fec0000041820ULL, 0x0000002a2c24723cULL, 0x000fec0000041824ULL,
0x000000382c28723cULL, 0x000fec0000041834ULL, 0x0000003a2c2c723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000002c00b81947ULL, 0x004fde0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400ac8947ULL, 0x000fea0003800000ULL,
0x000000c00c047890ULL, 0x000fe4000fffe03fULL, 0x000000120d1272a4ULL, 0x000fe4000f8e0208ULL,
0x000000041800728cULL, 0x000fe4000bf01070ULL, 0x80000004ff0c7e24ULL, 0x000fe4000f8e02ffULL,
0x0000000418137287ULL, 0x000fe2000c000000ULL, 0x0000001262307c12ULL, 0x000fca000f8efcffULL,
0x00000013ff0d7e24ULL, 0x000fe4000f8e00ffULL, 0x0000020030307825ULL, 0x000fc600078e000eULL,
0x000000400c0c7446ULL, 0x000fe4000380000dULL, 0x00000011610d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001000307825ULL, 0x000fe200078e0030ULL, 0x0000000c0900720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c3e00720cULL, 0x000fe40003f06070ULL, 0x0000001260307c12ULL, 0x002fe4000f8efcffULL,
0x000000115f0d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c3d00720cULL, 0x000fe40003f06070ULL, 0x000000125e307c12ULL, 0x002fe4000f8efcffULL,
0x000000115b0d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c3c00720cULL, 0x000fe40003f06070ULL, 0x000000125a307c12ULL, 0x002fe4000f8efcffULL,
0x00000011590d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c0800720cULL, 0x000fe40003f06070ULL, 0x000000126d307c12ULL, 0x002fe4000f8efcffULL,
0x00000011580d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c0700720cULL, 0x000fe40003f06070ULL, 0x000000126c307c12ULL, 0x002fe4000f8efcffULL,
0x00000011570d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c0600720cULL, 0x000fe40003f06070ULL, 0x000000126b307c12ULL, 0x002fe4000f8efcffULL,
0x00000011560d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c0500720cULL, 0x000fe40003f06070ULL, 0x000000126a307c12ULL, 0x002fe4000f8efcffULL,
0x00000011550d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c0400720cULL, 0x000fe40003f06070ULL, 0x0000001264307c12ULL, 0x002fe4000f8efcffULL,
0x00000011540d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c0300720cULL, 0x000fe40003f06070ULL, 0x0000001263307c12ULL, 0x002fe4000f8efcffULL,
0x00000011530d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c4b00720cULL, 0x000fe40003f06070ULL, 0x0000001269307c12ULL, 0x002fe4000f8efcffULL,
0x00000011520d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c4a00720cULL, 0x000fe40003f06070ULL, 0x0000001268307c12ULL, 0x002fe4000f8efcffULL,
0x00000011510d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c4900720cULL, 0x000fe40003f06070ULL, 0x0000001267307c12ULL, 0x002fe4000f8efcffULL,
0x00000011500d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c4800720cULL, 0x000fe40003f06070ULL, 0x0000001266307c12ULL, 0x002fe4000f8efcffULL,
0x000000114f0d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c3f00720cULL, 0x000fe40003f06070ULL, 0x0000001265307c12ULL, 0x002fe4000f8efcffULL,
0x000000114e0d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020030307825ULL, 0x000fc800078e000eULL,
0x0000001000307825ULL, 0x000fca00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c54ULL,
0x0000000c4c00720cULL, 0x000fe40003f06070ULL, 0x000000126e0c7c12ULL, 0x000fca000f8efcffULL,
0x000002000c0c7825ULL, 0x002fe200078e000eULL, 0x000000116f307c11ULL, 0x000fc6000f8e20ffULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c307faeULL, 0x0003e2000c101c54ULL,
0x0000000400507947ULL, 0x000fea0003800000ULL, 0x000000120d1272a4ULL, 0x000fe2000f8e0208ULL,
0x0000001161307c11ULL, 0x000fca000f8e20ffULL, 0x00000012620c7c12ULL, 0x000fca000f8efcffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c307faeULL, 0x0003e4000b901c54ULL,
0x00000012600c7c12ULL, 0x002fe4000f8efcffULL, 0x000000115f307c11ULL, 0x000fc6000f8e20ffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c307faeULL, 0x0003e4000b901c54ULL, 0x000000125e0c7c12ULL, 0x002fe4000f8efcffULL,
0x000000115b307c11ULL, 0x000fc6000f8e20ffULL, 0x000002000c0c7825ULL, 0x000fc800078e000eULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c307faeULL, 0x0003e4000b901c54ULL,
0x000000125a0c7c12ULL, 0x002fe4000f8efcffULL, 0x0000001159307c11ULL, 0x000fc6000f8e20ffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c307faeULL, 0x0003e4000b901c54ULL, 0x000000126d0c7c12ULL, 0x002fe4000f8efcffULL,
0x0000001158307c11ULL, 0x000fc6000f8e20ffULL, 0x000002000c0c7825ULL, 0x000fc800078e000eULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c307faeULL, 0x0003e4000b901c54ULL,
0x000000126c0c7c12ULL, 0x002fe4000f8efcffULL, 0x0000001157307c11ULL, 0x000fc6000f8e20ffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c307faeULL, 0x0003e4000b901c54ULL, 0x000000126b0c7c12ULL, 0x002fe4000f8efcffULL,
0x0000001156307c11ULL, 0x000fc6000f8e20ffULL, 0x000002000c0c7825ULL, 0x000fc800078e000eULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c307faeULL, 0x0003e4000b901c54ULL,
0x000000126a0c7c12ULL, 0x002fe4000f8efcffULL, 0x0000001155307c11ULL, 0x000fc6000f8e20ffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c307faeULL, 0x0003e4000b901c54ULL, 0x00000012640c7c12ULL, 0x002fe4000f8efcffULL,
0x0000001154307c11ULL, 0x000fc6000f8e20ffULL, 0x000002000c0c7825ULL, 0x000fc800078e000eULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c307faeULL, 0x0003e4000b901c54ULL,
0x00000012630c7c12ULL, 0x002fe4000f8efcffULL, 0x0000001153307c11ULL, 0x000fc6000f8e20ffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c307faeULL, 0x0003e4000b901c54ULL, 0x00000012690c7c12ULL, 0x002fe4000f8efcffULL,
0x0000001152307c11ULL, 0x000fc6000f8e20ffULL, 0x000002000c0c7825ULL, 0x000fc800078e000eULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c307faeULL, 0x0003e4000b901c54ULL,
0x00000012680c7c12ULL, 0x002fe4000f8efcffULL, 0x0000001151307c11ULL, 0x000fc6000f8e20ffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c307faeULL, 0x0003e4000b901c54ULL, 0x00000012670c7c12ULL, 0x002fe4000f8efcffULL,
0x0000001150307c11ULL, 0x000fc6000f8e20ffULL, 0x000002000c0c7825ULL, 0x000fc800078e000eULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c307faeULL, 0x0003e4000b901c54ULL,
0x00000012660c7c12ULL, 0x002fe4000f8efcffULL, 0x000000114f307c11ULL, 0x000fc6000f8e20ffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c307faeULL, 0x0003e4000b901c54ULL, 0x00000012650c7c12ULL, 0x002fe4000f8efcffULL,
0x000000114e307c11ULL, 0x000fc6000f8e20ffULL, 0x000002000c0c7825ULL, 0x000fc800078e000eULL,
0x00000010000c7825ULL, 0x000fca00078e000cULL, 0x000000000c307faeULL, 0x0003e4000b901c54ULL,
0x000000126e0c7c12ULL, 0x002fe4000f8efcffULL, 0x000000116f307c11ULL, 0x000fc6000f8e20ffULL,
0x000002000c0c7825ULL, 0x000fc800078e000eULL, 0x00000010000c7825ULL, 0x000fca00078e000cULL,
0x000000000c307faeULL, 0x0003e4000b901c54ULL, 0x0000000309047892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000030400788cULL, 0x000fc8000bf05270ULL,
0x000000010f047887ULL, 0x000fc8000c000000ULL, 0x0000000409097290ULL, 0x000fc8000fffe03fULL,
0x000000050900728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fca0003f0f018ULL,
0x0000000a09049290ULL, 0x000fe2000fffe03fULL, 0x00008c0000129ab9ULL, 0x000fc60000000a00ULL,
0x00000004041298a5ULL, 0x000fe4000f8e0012ULL, 0x0000001f0e047899ULL, 0x000fc8000800063fULL,
0x00000012ff0c7e24ULL, 0x002fe4000f8e00ffULL, 0x00000013ff0d7e24ULL, 0x000fca000f8e00ffULL,
0x000000140c308981ULL, 0x000364000c1e1900ULL, 0x00000004ff0c7e24ULL, 0x002fc8000f8e00ffULL,
0x0246280cff0075a7ULL, 0x000e640008020147ULL, 0x000000d800389947ULL, 0x002fea0003800000ULL,
0x02410000020c7984ULL, 0x000e620000000800ULL, 0x00000002ff3a7819ULL, 0x000fe20000011671ULL,
0x00000001ff317424ULL, 0x000fe400078e00ffULL, 0x02430000025c7984ULL, 0x0004a40000000800ULL,
0x000000083a397836ULL, 0x000fe20000000000ULL, 0x0000000b0c00720bULL, 0x002fda0003f3d000ULL,
0x00000000000d7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0d0d7812ULL, 0x000fda000782c0ffULL,
0x0000000000d09947ULL, 0x004fea0003800000ULL, 0x0000000b0c00720bULL, 0x000fe20003f34000ULL,
0x000000021600788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fcc0003f4f008ULL,
0x0000000000317806ULL, 0x000fc800008e0100ULL, 0x0000ffff31317812ULL, 0x000fc800078e3cffULL,
0x000000310dff7212ULL, 0x000fe4000782c0ffULL, 0x0000000c0b0d7209ULL, 0x000fe40007810000ULL,
0x00000001ff317807ULL, 0x000fc60000800000ULL, 0x8000000d0b0b7221ULL, 0x100fe20000010000ULL,
0x0245000d0200a388ULL, 0x000fe60000000800ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fe40000410000ULL,
0x8000000d0c0c1221ULL, 0x000fc80000010000ULL, 0x0000000b000b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b0c0c1820ULL, 0x000fce0000410000ULL, 0x0000000c004d1308ULL, 0x0004e20000000800ULL,
0x0000000b0a0a7220ULL, 0x002fe20000410000ULL, 0x00001f3a0b0c7589ULL, 0x004e6800000e0000ULL,
0x00001f390b0b7589ULL, 0x000ea200000e0000ULL, 0x0000005c4d5c1220ULL, 0x008fe20000410000ULL,
0x0000000c14147220ULL, 0x082fe20000410000ULL, 0x0000000c15157220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x080fe20000410000ULL,
0x0000000b16167220ULL, 0x084fe20000410000ULL, 0x0000000b17177220ULL, 0x080fe20000410000ULL,
0x0000000b12127220ULL, 0x080fe20000410000ULL, 0x0000000b13137220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x080fe20000410000ULL, 0x0000000b23237220ULL, 0x080fe20000410000ULL,
0x0000000b26267220ULL, 0x080fe20000410000ULL, 0x0000000b27277220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000b2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x000fe20000410000ULL,
0x0000000c18187220ULL, 0x080fe20000410000ULL, 0x0000000c19197220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x000fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fce00078e000dULL, 0x00004000010c7983ULL, 0x000ea20000300800ULL,
0x0000991031317816ULL, 0x000fe200000000ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000001387983ULL, 0x000ee20000300800ULL, 0x00000000301182caULL, 0x020fe400000e0000ULL,
0x000000ff3100720cULL, 0x000fe20003f05270ULL, 0x0000040001407983ULL, 0x000f220000300800ULL,
0x0000004dff0d723eULL, 0x000fc600000010ffULL, 0x013000007930783bULL, 0x000fe20000000200ULL,
0x000054100d0d7816ULL, 0x000fc6000000000dULL, 0x0000100001447983ULL, 0x000f680000300800ULL,
0x0000080001457983ULL, 0x000ee20000300800ULL, 0x000000190c347c11ULL, 0x004fc6000f8e20ffULL,
0x00001f3a0d0c7589ULL, 0x000e6800000e0000ULL, 0x000000003434783bULL, 0x000fe80000004200ULL,
0x00001f390d0d7589ULL, 0x000ea200000e0000ULL, 0x0000000c30308232ULL, 0x082fe40000200000ULL,
0x0000000c32328232ULL, 0x000fc40000200000ULL, 0x0000000d31318232ULL, 0x084fe40000200000ULL,
0x0000000d33338232ULL, 0x000fce0000200000ULL, 0x000000343014723cULL, 0x000fee0000041814ULL,
0x0000001975347c11ULL, 0x000fe2000f8e20ffULL, 0x000000363010723cULL, 0x000fe20000041810ULL,
0x00000c0001757983ULL, 0x000ea80000300800ULL, 0x000000003434783bULL, 0x000e640000004200ULL,
0x000000343018723cULL, 0x002fee0000041818ULL, 0x0000001977347c11ULL, 0x000fe2000f8e20ffULL,
0x00000036301c723cULL, 0x000fea000004181cULL, 0x000000003434783bULL, 0x000e640000004200ULL,
0x000000343020723cULL, 0x002fee0000041820ULL, 0x0000001938347c11ULL, 0x008fe2000f8e20ffULL,
0x000000363024723cULL, 0x000fea0000041824ULL, 0x000000003434783bULL, 0x000e640000004200ULL,
0x000000343028723cULL, 0x002fec0000041828ULL, 0x00000036302c723cULL, 0x000fe2000004182cULL,
0x013000007434783bULL, 0x000e6c0000000200ULL, 0x000000197b307c11ULL, 0x000fcc000f8e20ffULL,
0x000000003030783bULL, 0x000ee20000004200ULL, 0x000000197d387c11ULL, 0x000fcc000f8e20ffULL,
0x000000003838783bULL, 0x000f220000004200ULL, 0x0000000c34348232ULL, 0x082fe40000200000ULL,
0x0000000c36368232ULL, 0x000fe40000200000ULL, 0x0000000d35358232ULL, 0x080fe40000200000ULL,
0x0000000d37378232ULL, 0x000fce0000200000ULL, 0x000000303418723cULL, 0x008fee0000041818ULL,
0x0000001940307c11ULL, 0x010fe2000f8e20ffULL, 0x00000032341c723cULL, 0x000fea000004181cULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x000000383414723cULL, 0x000fe20000041814ULL,
0x000000197a407c11ULL, 0x000fcc000f8e20ffULL, 0x0000001978387c11ULL, 0x000fe2000f8e20ffULL,
0x0000003a3410723cULL, 0x000fe20000041810ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x000000303420723cULL, 0x002fec0000041820ULL,
0x000000323424723cULL, 0x000fe20000041824ULL, 0x013000007330783bULL, 0x000e6a0000000200ULL,
0x000000383428723cULL, 0x008fec0000041828ULL, 0x0000003a3434723cULL, 0x000fe2000004182cULL,
0x0000001947387c11ULL, 0x000fcc000f8e20ffULL, 0x00000019762c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000003838783bULL, 0x000fea0000004200ULL, 0x000000002c2c783bULL, 0x000ee20000004200ULL,
0x0000000c30308232ULL, 0x082fe40000200000ULL, 0x0000000c32328232ULL, 0x000fe40000200000ULL,
0x0000000d31318232ULL, 0x000fc40000200000ULL, 0x0000000d33338232ULL, 0x000fce0000200000ULL,
0x000000403014723cULL, 0x000fee0000041814ULL, 0x000000197c407c11ULL, 0x000fe2000f8e20ffULL,
0x000000423010723cULL, 0x000fea0000041810ULL, 0x000000004040783bULL, 0x000e620000004200ULL,
0x0000002c3020723cULL, 0x008fec0000041820ULL, 0x0000002e3024723cULL, 0x000fe20000041824ULL,
0x01300000722c783bULL, 0x000ee20000000200ULL, 0x0000001944447c11ULL, 0x020fc8000f8e20ffULL,
0x000000383028723cULL, 0x000fee0000041828ULL, 0x0000001946387c11ULL, 0x000fe2000f8e20ffULL,
0x000000403018723cULL, 0x002fec0000041818ULL, 0x00000042301c723cULL, 0x000fe2000004181cULL,
0x0000001945407c11ULL, 0x000fc4000f8e20ffULL, 0x000000004444783bULL, 0x000e660000004200ULL,
0x0000003a3030723cULL, 0x000fe20000041834ULL, 0x000000004040783bULL, 0x000f280000004200ULL,
0x000000003838783bULL, 0x000f640000004200ULL, 0x0000001975347c11ULL, 0x004fcc000f8e20ffULL,
0x000000003434783bULL, 0x000ea20000004200ULL, 0x000000c00c0c7890ULL, 0x000fc8000fffe03fULL,
0x000000180c00728cULL, 0x000fe2000bf06070ULL, 0x0000000c2c2c8232ULL, 0x088fe40000200000ULL,
0x0000000c2e2e8232ULL, 0x000fe40000200000ULL, 0x0000000d2d2d8232ULL, 0x080fe40000200000ULL,
0x0000000d2f2f8232ULL, 0x000fe20000200000ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x00000001ff757424ULL, 0x000fe200078e00ffULL, 0xffffffff00127882ULL, 0x000fe20000000000ULL,
0x0000000b00047c82ULL, 0x000fe20008000000ULL, 0x0000001100129c82ULL, 0x000fe20008000000ULL,
0x02463075ffff79a7ULL, 0x0007e20008500007ULL, 0x0000000a5c0a7221ULL, 0x000fe20000010000ULL,
0x000000442c14723cULL, 0x002fec0000041814ULL, 0x000000462c10723cULL, 0x000fec0000041810ULL,
0x000000402c18723cULL, 0x010fec0000041818ULL, 0x000000422c1c723cULL, 0x000fec000004181cULL,
0x000000382c20723cULL, 0x020fec0000041820ULL, 0x0000003a2c24723cULL, 0x000fec0000041824ULL,
0x000000342c28723cULL, 0x004fec0000041828ULL, 0x000000362c2c723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000001400c80947ULL, 0x008fde0003800000ULL,
0x0000900001757983ULL, 0x000ea20000100800ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000017750c7c36ULL, 0x004fc80008000000ULL, 0x000000010c0d7836ULL, 0x000fca0000000000ULL,
0x000000060d007c0cULL, 0x000fda000bf06070ULL, 0x0000000400a48947ULL, 0x000fea0003800000ULL,
0x000001000c0c7824ULL, 0x000fe200078e00ffULL, 0x000000120d0d72a4ULL, 0x000fe2000f8e0208ULL,
0x0000001961617c11ULL, 0x000fe4000f8e20ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e0a0cULL,
0x000000180c327c48ULL, 0x000fe4000ffe0000ULL, 0x0000000d60317c12ULL, 0x000fe4000f8efcffULL,
0x0000004032327446ULL, 0x000fe4000380000dULL, 0x0000000d620d7c12ULL, 0x000fe2000f8efcffULL,
0x0000020031307825ULL, 0x000fe200078e000eULL, 0x000000320900720cULL, 0x000fc40003f46070ULL,
0x000000323e00720cULL, 0x080fe20003f26070ULL, 0x000002000d0c7825ULL, 0x000fe200078e000eULL,
0x0000000d5e477c12ULL, 0x000fe4000f8efcffULL, 0x000000323d00720cULL, 0x000fe20003f06070ULL,
0x0000001000307825ULL, 0x000fe200078e0030ULL, 0x0000000d5a457c12ULL, 0x000fe4000f8efcffULL,
0x000000195f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020047467825ULL, 0x000fe200078e000eULL,
0x0000000d6d437c12ULL, 0x000fc4000f8efcffULL, 0x0000000d6c417c12ULL, 0x000fe2000f8efcffULL,
0x00000010000c7825ULL, 0x000fe200078e000cULL, 0x000000323c00720cULL, 0x080fe40003f86070ULL,
0x0000000d6b3d7c12ULL, 0x000fe2000f8efcffULL, 0x0000020045447825ULL, 0x000fe200078e000eULL,
0x000000320800720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c617faeULL, 0x000fe2000d101c54ULL, 0x0000000d6a3b7c12ULL, 0x000fe2000f8efcffULL,
0x0000001000467825ULL, 0x000fe200078e0046ULL, 0x000000320700720cULL, 0x000fe20003fa6070ULL,
0x00000000305f7faeULL, 0x0003e2000c901c54ULL, 0x000000195b5b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020043427825ULL, 0x000fe200078e000eULL, 0x0000000d64397c12ULL, 0x000fc4000f8efcffULL,
0x000000320600720cULL, 0x080fe20003f66070ULL, 0x0000020041407825ULL, 0x100fe200078e000eULL,
0x000000320500720cULL, 0x000fe20003f46070ULL, 0x00000000465b7faeULL, 0x000fe2000c101c54ULL,
0x0000000d63357c12ULL, 0x000fe2000f8efcffULL, 0x000002003d3c7825ULL, 0x100fe200078e000eULL,
0x0000000d69097c12ULL, 0x000fe4000f8efcffULL, 0x0000000d68377c12ULL, 0x000fe2000f8efcffULL,
0x000002003b3a7825ULL, 0x000fe200078e000eULL, 0x0000000d67077c12ULL, 0x000fc4000f8efcffULL,
0x0000000d66317c12ULL, 0x002fe2000f8efcffULL, 0x0000020039387825ULL, 0x000fe200078e000eULL,
0x0000000d650d7c12ULL, 0x000fe4000f8efcffULL, 0x0000000d6e057c12ULL, 0x000fe2000f8efcffULL,
0x0000001000447825ULL, 0x000fe200078e0044ULL, 0x000000320400720cULL, 0x080fe40003f26070ULL,
0x000000320300720cULL, 0x000fe20003f06070ULL, 0x0000020035347825ULL, 0x000fe200078e000eULL,
0x0000001959597c11ULL, 0x000fc4000f8e20ffULL, 0x0000001958037c11ULL, 0x000fe2000f8e20ffULL,
0x0000020009087825ULL, 0x100fe200078e000eULL, 0x0000001957577c11ULL, 0x000fe2000f8e20ffULL,
0x0000000044597faeULL, 0x000fe2000e101c54ULL, 0x0000001955557c11ULL, 0x000fe2000f8e20ffULL,
0x0000020037367825ULL, 0x100fe200078e000eULL, 0x0000001954337c11ULL, 0x000fe4000f8e20ffULL,
0x000000324b00720cULL, 0x000fe20003f86070ULL, 0x0000020007067825ULL, 0x000fe200078e000eULL,
0x0000001953537c11ULL, 0x000fc4000f8e20ffULL, 0x0000001951517c11ULL, 0x000fe2000f8e20ffULL,
0x0000020031307825ULL, 0x100fe200078e000eULL, 0x000000194f4f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000196f6f7c11ULL, 0x000fe2000f8e20ffULL, 0x000002000d0c7825ULL, 0x000fc800078e000eULL,
0x0000001000427825ULL, 0x000fc800078e0042ULL, 0x00000200050e7825ULL, 0x000fe200078e000eULL,
0x0000001956057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000042037faeULL, 0x0003e2000f101c54ULL,
0x000000324a00720cULL, 0x000fe20003fc6070ULL, 0x0000001000407825ULL, 0x000fc800078e0040ULL,
0x00000010003c7825ULL, 0x040fe200078e003cULL, 0x0000000040577faeULL, 0x000fe2000e901c54ULL,
0x000000324900720cULL, 0x080fe40003fa6070ULL, 0x00000010003a7825ULL, 0x000fe200078e003aULL,
0x000000003c057faeULL, 0x0005e2000d901c54ULL, 0x000000324800720cULL, 0x080fe40003f66070ULL,
0x0000001000387825ULL, 0x000fe200078e0038ULL, 0x000000003a557faeULL, 0x000fe2000d101c54ULL,
0x000000323f00720cULL, 0x000fc40003f46070ULL, 0x0000001000347825ULL, 0x000fe200078e0034ULL,
0x0000000038337faeULL, 0x0009e2000c901c54ULL, 0x000000324c00720cULL, 0x000fe40003f26070ULL,
0x0000001952037c11ULL, 0x002fe2000f8e20ffULL, 0x0000001000087825ULL, 0x000fe200078e0008ULL,
0x0000001950057c11ULL, 0x004fe2000f8e20ffULL, 0x0000000034537faeULL, 0x0007e4000c101c54ULL,
0x0000001000367825ULL, 0x040fe400078e0036ULL, 0x0000000008037faeULL, 0x0007e4000e101c54ULL,
0x0000001000067825ULL, 0x000fe200078e0006ULL, 0x000000194e337c11ULL, 0x010fe2000f8e20ffULL,
0x0000000036517faeULL, 0x0007e4000f101c54ULL, 0x0000001000307825ULL, 0x000fc400078e0030ULL,
0x0000000006057faeULL, 0x0007e4000e901c54ULL, 0x00000010000c7825ULL, 0x040fe400078e000cULL,
0x00000000304f7faeULL, 0x0007e4000d901c54ULL, 0x00000010000e7825ULL, 0x000fe400078e000eULL,
0x000000000c337faeULL, 0x0007e8000d101c54ULL, 0x000000000e6f7faeULL, 0x0007e2000c901c54ULL,
0x0000000400507947ULL, 0x000fea0003800000ULL, 0x000000120d0d72a4ULL, 0x000fe2000f8e0208ULL,
0x0000001961617c11ULL, 0x000fe4000f8e20ffULL, 0x000000195f5f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000195b5b7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d62457c12ULL, 0x000fe4000f8efcffULL,
0x0000000d60077c12ULL, 0x000fe4000f8efcffULL, 0x0000000d5e3b7c12ULL, 0x000fe2000f8efcffULL,
0x0000020045447825ULL, 0x000fe200078e000eULL, 0x0000000d5a437c12ULL, 0x000fc4000f8efcffULL,
0x0000000d6d417c12ULL, 0x000fe2000f8efcffULL, 0x0000020007067825ULL, 0x100fe200078e000eULL,
0x0000000d6c3f7c12ULL, 0x000fe4000f8efcffULL, 0x0000000d6b3d7c12ULL, 0x000fe2000f8efcffULL,
0x000002003b3a7825ULL, 0x100fe200078e000eULL, 0x0000000d6a317c12ULL, 0x000fe4000f8efcffULL,
0x0000000d64397c12ULL, 0x000fe2000f8efcffULL, 0x0000020043427825ULL, 0x000fe200078e000eULL,
0x0000000d63377c12ULL, 0x000fc4000f8efcffULL, 0x0000000d69357c12ULL, 0x000fe2000f8efcffULL,
0x0000020041407825ULL, 0x100fe200078e000eULL, 0x0000000d68337c12ULL, 0x000fe4000f8efcffULL,
0x0000000d67057c12ULL, 0x000fe2000f8efcffULL, 0x000002003f3e7825ULL, 0x100fe200078e000eULL,
0x0000000d660d7c12ULL, 0x000fe4000f8efcffULL, 0x0000000d65097c12ULL, 0x000fe2000f8efcffULL,
0x000002003d3c7825ULL, 0x000fe200078e000eULL, 0x0000000d6e037c12ULL, 0x000fc4000f8efcffULL,
0x0000001959597c11ULL, 0x000fe2000f8e20ffULL, 0x0000001000447825ULL, 0x000fe200078e0044ULL,
0x0000001957577c11ULL, 0x000fe4000f8e20ffULL, 0x0000001955557c11ULL, 0x000fe2000f8e20ffULL,
0x0000020031307825ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044617faeULL, 0x0003e2000b901c54ULL, 0x0000001954477c11ULL, 0x000fe4000f8e20ffULL,
0x0000001000067825ULL, 0x000fe200078e0006ULL, 0x0000001953537c11ULL, 0x000fc4000f8e20ffULL,
0x0000001952497c11ULL, 0x000fe2000f8e20ffULL, 0x0000020039387825ULL, 0x100fe200078e000eULL,
0x00000000065f7faeULL, 0x0005e2000b901c54ULL, 0x0000001951517c11ULL, 0x000fe4000f8e20ffULL,
0x0000020037367825ULL, 0x100fe200078e000eULL, 0x0000001956457c11ULL, 0x002fe4000f8e20ffULL,
0x000000194f4f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020035347825ULL, 0x000fe200078e000eULL,
0x000000196f6f7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020033327825ULL, 0x000fe200078e000eULL,
0x000000194e077c11ULL, 0x004fc6000f8e20ffULL, 0x0000020005047825ULL, 0x000fc800078e000eULL,
0x000002000d0c7825ULL, 0x000fc800078e000eULL, 0x0000020009087825ULL, 0x000fc800078e000eULL,
0x00000010003a7825ULL, 0x000fc800078e003aULL, 0x00000200030e7825ULL, 0x000fe200078e000eULL,
0x0000001958037c11ULL, 0x000fe2000f8e20ffULL, 0x000000003a5b7faeULL, 0x000fe4000b901c54ULL,
0x0000001000427825ULL, 0x000fc800078e0042ULL, 0x0000001000407825ULL, 0x040fe200078e0040ULL,
0x0000000042597faeULL, 0x000fe6000b901c54ULL, 0x00000010003e7825ULL, 0x040fe200078e003eULL,
0x0000000040037faeULL, 0x0005e6000b901c54ULL, 0x00000010003c7825ULL, 0x040fe200078e003cULL,
0x000000003e577faeULL, 0x0003e6000b901c54ULL, 0x0000001000307825ULL, 0x040fe200078e0030ULL,
0x000000003c457faeULL, 0x0003e6000b901c54ULL, 0x0000001000387825ULL, 0x000fe200078e0038ULL,
0x0000000030557faeULL, 0x0003e2000b901c54ULL, 0x0000001950037c11ULL, 0x004fc4000f8e20ffULL,
0x0000001000367825ULL, 0x040fe200078e0036ULL, 0x0000000038477faeULL, 0x0003e6000b901c54ULL,
0x0000001000347825ULL, 0x040fe200078e0034ULL, 0x0000000036537faeULL, 0x0003e6000b901c54ULL,
0x0000001000327825ULL, 0x040fe200078e0032ULL, 0x0000000034497faeULL, 0x0003e6000b901c54ULL,
0x0000001000047825ULL, 0x040fe200078e0004ULL, 0x0000000032517faeULL, 0x0003e6000b901c54ULL,
0x00000010000c7825ULL, 0x040fe200078e000cULL, 0x0000000004037faeULL, 0x0003e6000b901c54ULL,
0x0000001000087825ULL, 0x040fe200078e0008ULL, 0x000000000c4f7faeULL, 0x0003e6000b901c54ULL,
0x00000010000e7825ULL, 0x000fe200078e000eULL, 0x0000000008077faeULL, 0x0003e8000b901c54ULL,
0x000000000e6f7faeULL, 0x0003e4000b901c54ULL, 0x0000000309047892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000030400788cULL, 0x000fc8000bf05270ULL,
0x000000010f0f7887ULL, 0x000fc8000c000000ULL, 0x0000000f09097290ULL, 0x000fc8000fffe03fULL,
0x000000050900728cULL, 0x000fe4000bf26070ULL, 0x0000001f0e0e7899ULL, 0x000fc8000800063fULL,
0x000000000000781cULL, 0x000fca0003f0f018ULL, 0x0000000a09049290ULL, 0x000fe2000fffe03fULL,
0x00008c00000c9ab9ULL, 0x000fc60000000a00ULL, 0x00000004040c98a5ULL, 0x000fe2000f8e000cULL,
0x0000000eff007e24ULL, 0x000fca000f8e00ffULL, 0x0000000cff047e24ULL, 0x002fe4000f8e00ffULL,
0x0000000dff057e24ULL, 0x008fca000f8e00ffULL, 0x0000001404038981ULL, 0x000362000c1e1900ULL,
0x02463800ff0075a7ULL, 0x000ea40008020147ULL, 0x000000c000609947ULL, 0x006fea0003800000ULL,
0x0241800002047984ULL, 0x000e620000000800ULL, 0x00000002ff327819ULL, 0x000fe20000011671ULL,
0x00000001ff057424ULL, 0x000fc800078e00ffULL, 0x0000000832317836ULL, 0x000fe20000000000ULL,
0x0000000b0400720bULL, 0x002fda0003f3d000ULL, 0x0000000000007806ULL, 0x000fc800008e0100ULL,
0x0000ffff00087812ULL, 0x000fe4000782c0ffULL, 0x0243800002007984ULL, 0x0002b60000000800ULL,
0x0000000000d09947ULL, 0x002fea0003800000ULL, 0x0000000b0400720bULL, 0x000fe20003f34000ULL,
0x000000031600788cULL, 0x000fe2000bf05270ULL, 0x000000040b0d7209ULL, 0x000fca0007810000ULL,
0x8000000d0b057221ULL, 0x100fe20000010000ULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x000000ffff0b7224ULL, 0x000fe400078e000dULL, 0x3fb8aa3b05067820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fe400008e0100ULL, 0x0000000600077308ULL, 0x000e640000000800ULL,
0x0000ffff05097812ULL, 0x000fc800078e3cffULL, 0x0000000908ff7212ULL, 0x000fe2000782c0ffULL,
0x0245800d0200a388ULL, 0x000fe80000000800ULL, 0x00001f3207057589ULL, 0x002e6200000e0000ULL,
0x000000070a0a7220ULL, 0x000fce0000410000ULL, 0x8000000d04081221ULL, 0x000fe40000010000ULL,
0x00001f3107047589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b08081820ULL, 0x000fc80000410000ULL,
0x00000008004d1308ULL, 0x000f220000000800ULL, 0x0000000514147220ULL, 0x082fe20000410000ULL,
0x0000000515157220ULL, 0x080fe20000410000ULL, 0x0000000510107220ULL, 0x080fe20000410000ULL,
0x0000000511117220ULL, 0x080fe20000410000ULL, 0x0000000518187220ULL, 0x080fe20000410000ULL,
0x0000000519197220ULL, 0x080fe20000410000ULL, 0x000000051c1c7220ULL, 0x080fe20000410000ULL,
0x000000051d1d7220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000521217220ULL, 0x080fe20000410000ULL, 0x0000000524247220ULL, 0x080fe20000410000ULL,
0x0000000525257220ULL, 0x080fe20000410000ULL, 0x0000000528287220ULL, 0x080fe20000410000ULL,
0x0000000529297220ULL, 0x080fe20000410000ULL, 0x000000052c2c7220ULL, 0x080fe20000410000ULL,
0x000000052d2d7220ULL, 0x000fe20000410000ULL, 0x00000001ff057807ULL, 0x000fe20000800000ULL,
0x0000000416167220ULL, 0x088fe20000410000ULL, 0x0000000417177220ULL, 0x080fe20000410000ULL,
0x0000000412127220ULL, 0x080fe20000410000ULL, 0x0000000413137220ULL, 0x080fe20000410000ULL,
0x000000041a1a7220ULL, 0x080fe20000410000ULL, 0x000000041b1b7220ULL, 0x080fe20000410000ULL,
0x000000041e1e7220ULL, 0x080fe20000410000ULL, 0x000000041f1f7220ULL, 0x080fe20000410000ULL,
0x0000000422227220ULL, 0x080fe20000410000ULL, 0x0000000423237220ULL, 0x080fe20000410000ULL,
0x0000000426267220ULL, 0x080fe20000410000ULL, 0x0000000427277220ULL, 0x080fe20000410000ULL,
0x000000042a2a7220ULL, 0x080fe20000410000ULL, 0x000000042b2b7220ULL, 0x080fe20000410000ULL,
0x000000042e2e7220ULL, 0x080fe20000410000ULL, 0x000000042f2f7220ULL, 0x000fe20000410000ULL,
0x000000004d001220ULL, 0x014fce0000410000ULL, 0x0000280001067983ULL, 0x000ee20000300800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000380001047983ULL, 0x000f280000300800ULL,
0x0000340001077983ULL, 0x004ea80000300800ULL, 0x0000480001307983ULL, 0x000ea80000300800ULL,
0x0000440001387983ULL, 0x000ea80000300800ULL, 0x0000300001427983ULL, 0x000ea80000300800ULL,
0x00004c0001417983ULL, 0x000ea80000300800ULL, 0x00003c0001407983ULL, 0x000ea20000300800ULL,
0x0000004dff02723eULL, 0x000fc400000010ffULL, 0x0000991005057816ULL, 0x000fe200000000ffULL,
0x00002c0001487983ULL, 0x000ea80000300800ULL, 0x0000200001097983ULL, 0x000ea80000300800ULL,
0x00001c0001087983ULL, 0x000ea20000300800ULL, 0x000000ff0500720cULL, 0x000fc60003f25270ULL,
0x013800007978783bULL, 0x000fe80000000200ULL, 0x013800007474783bULL, 0x000fe80000000200ULL,
0x000000005d5c783bULL, 0x000fe80000004200ULL, 0x00000000063c783bULL, 0x0083e80000004200ULL,
0x00000000040c783bULL, 0x010fe20000004200ULL, 0x0000541002067816ULL, 0x002fc60000000002ULL,
0x000000000734783bULL, 0x0043e80000004200ULL, 0x00001f3206047589ULL, 0x000ea800000e0000ULL,
0x0000180001077983ULL, 0x002ee80000300800ULL, 0x00001f3106027589ULL, 0x00032800000e0000ULL,
0x000000003030783bULL, 0x000f280000004200ULL, 0x000000003838783bULL, 0x000f280000004200ULL,
0x0000240001067983ULL, 0x002ee80000300800ULL, 0x0000140001057983ULL, 0x000ee20000300800ULL,
0x0000000478789232ULL, 0x004fc40000200000ULL, 0x000000047a7a9232ULL, 0x000fe20000200000ULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x0000000279799232ULL, 0x010fc60000200000ULL,
0x000000000950783bULL, 0x000fe20000004200ULL, 0x000000027b7b9232ULL, 0x000fce0000200000ULL,
0x0000003c7814723cULL, 0x000fec0000041814ULL, 0x0000003e7810723cULL, 0x000fec0000041810ULL,
0x0000000c783c723cULL, 0x000fe20000041818ULL, 0x000000004218783bULL, 0x000e6a0000004200ULL,
0x0000000e780c723cULL, 0x000fe2000004181cULL, 0x00000000411c783bULL, 0x000eaa0000004200ULL,
0x000000347820723cULL, 0x000fec0000041820ULL, 0x000000367824723cULL, 0x000fe20000041824ULL,
0x000000004034783bULL, 0x000f220000004200ULL, 0x0000000474749232ULL, 0x000fc40000200000ULL,
0x0000000476769232ULL, 0x000fe20000200000ULL, 0x013800007340783bULL, 0x000f220000000200ULL,
0x000000307828723cULL, 0x000fe20000041828ULL, 0x0000000275759232ULL, 0x080fe40000200000ULL,
0x0000000277779232ULL, 0x000fc60000200000ULL, 0x000000327830723cULL, 0x000fe2000004182cULL,
0x01380000722c783bULL, 0x000fea0000000200ULL, 0x000000387444723cULL, 0x000fe20000041814ULL,
0x000000000814783bULL, 0x000f2a0000004200ULL, 0x0000003a7410723cULL, 0x000fec0000041810ULL,
0x00000018743c723cULL, 0x002fec000004183cULL, 0x0000001a740c723cULL, 0x000fec000004180cULL,
0x0000001c7420723cULL, 0x004fec0000041820ULL, 0x0000001e7424723cULL, 0x000fec0000041824ULL,
0x000000347428723cULL, 0x010fec0000041828ULL, 0x000000367434723cULL, 0x000fe20000041830ULL,
0x000000007030783bULL, 0x000e620000004200ULL, 0x0000000440409232ULL, 0x000fc40000200000ULL,
0x0000000442429232ULL, 0x000fe40000200000ULL, 0x0000000241419232ULL, 0x080fe40000200000ULL,
0x0000000243439232ULL, 0x000fce0000200000ULL, 0x000000484044723cULL, 0x000fec0000041844ULL,
0x0000004a4010723cULL, 0x000fec0000041810ULL, 0x00000050403c723cULL, 0x000fec000004183cULL,
0x00000052400c723cULL, 0x000fec000004180cULL, 0x000000144020723cULL, 0x000fec0000041820ULL,
0x000000164024723cULL, 0x000fe20000041824ULL, 0x000000042c2c9232ULL, 0x000fc40000200000ULL,
0x000000042e2e9232ULL, 0x000fe40000200000ULL, 0x000000022d2d9232ULL, 0x080fe40000200000ULL,
0x000000022f2f9232ULL, 0x000fe20000200000ULL, 0x00000000030b82caULL, 0x020fd400000e0000ULL,
0x000000302c20723cULL, 0x002fec0000041820ULL, 0x000000322c24723cULL, 0x000fe20000041824ULL,
0x0000000a000a7221ULL, 0x000fe20000010000ULL, 0xffffffff00127882ULL, 0x000fe20000000000ULL,
0x0000001000047c82ULL, 0x000fe20008000000ULL, 0x0000000b00129c82ULL, 0x000fe20008000000ULL,
0x000000000738783bULL, 0x008e680000004200ULL, 0x000000000618783bULL, 0x000ea80000004200ULL,
0x00000000051c783bULL, 0x0007220000004200ULL, 0x000000384028723cULL, 0x002fec0000041828ULL,
0x0000003a4034723cULL, 0x000fe20000041834ULL, 0x00000001ff057424ULL, 0x008fc800078e00ffULL,
0x02464005ffff79a7ULL, 0x0003e20008500007ULL, 0x000000182c14723cULL, 0x004fec0000041844ULL,
0x0000001a2c10723cULL, 0x000fec0000041810ULL, 0x0000001c2c18723cULL, 0x010fec000004183cULL,
0x0000001e2c1c723cULL, 0x000fec000004180cULL, 0x0000005c2c28723cULL, 0x000fec0000041828ULL,
0x0000005e2c2c723cULL, 0x002fde0000041834ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000500001027983ULL, 0x000ea80000300800ULL, 0x0000900001007983ULL, 0x000ee20000300800ULL,
0x000000ff02ff7812ULL, 0x004fe2000780c0ffULL, 0x0000001700007c36ULL, 0x008fca0008000000ULL,
0x0000900001007387ULL, 0x0003e20000100800ULL, 0x0000000600007c0cULL, 0x000fe4000bf26070ULL,
0x00000001ff007807ULL, 0x002fca0000000000ULL, 0x0000500001007387ULL, 0x0003ec0000100600ULL,
0xffffff9000089947ULL, 0x002fea000383ffffULL, 0x00000000000e79c3ULL, 0x000e620000002500ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0019ULL, 0x000000ffff197224ULL, 0x000fe200078e0018ULL,
0x000000060e00728cULL, 0x002fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x018000000a007836ULL, 0x000fca0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e000aULL,
0x000094a000027802ULL, 0x000fce0000000f00ULL, 0x000000bc00407944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000a00037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc8000000000aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x00000002ff057819ULL, 0x010fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0500027589ULL, 0x000ea800000e0000ULL,
0x00001f0300037589ULL, 0x000ee200000e0000ULL, 0x0000001402147220ULL, 0x044fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000001002107220ULL, 0x040fe20000410000ULL,
0x0000001102117220ULL, 0x040fe20000410000ULL, 0x0000001902197220ULL, 0x040fe20000410000ULL,
0x0000000e020e7220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002502257220ULL, 0x040fe20000410000ULL, 0x0000002802287220ULL, 0x040fe20000410000ULL,
0x0000002902297220ULL, 0x040fe20000410000ULL, 0x0000002c022c7220ULL, 0x040fe20000410000ULL,
0x0000002d022d7220ULL, 0x000fe20000410000ULL, 0x0000001603167220ULL, 0x048fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001203127220ULL, 0x040fe20000410000ULL,
0x0000001303137220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000716067291ULL, 0x000fe4000f8e583fULL, 0x000000011700788cULL, 0x000fe2000bf05270ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00012000060f7890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x00000003ff037819ULL, 0x004fe40000011600ULL,
0xfffffff8ff057812ULL, 0x000fe400078ee200ULL, 0x0000000303027812ULL, 0x000fc600078ec0ffULL,
0x0000000805097836ULL, 0x040fe20000000000ULL, 0x0000000402067812ULL, 0x000fe200078efcffULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0x0000000702077812ULL, 0x000fe200078e7805ULL,
0x00000008090c7824ULL, 0x000fe200078e00ffULL, 0x0000000706057812ULL, 0x000fe400078e7805ULL,
0x00000007020d7812ULL, 0x000fe400078e7809ULL, 0x00000007060f7812ULL, 0x000fe400078e7809ULL,
0x0000000407027212ULL, 0x000fc400078efcffULL, 0x0000000405087212ULL, 0x000fe400078efcffULL,
0x0000000c0d097212ULL, 0x080fe400078efcffULL, 0x0000000c0f187212ULL, 0x000fe400078efcffULL,
0x000000141504723eULL, 0x000fe400000010ffULL, 0x000000101105723eULL, 0x000fe400000010ffULL,
0x000000190e06723eULL, 0x000fc400000010ffULL, 0x0000001c1d07723eULL, 0x000fe400000010ffULL,
0x0000000f02027c11ULL, 0x000fe4000f8e20ffULL, 0x00000020210c723eULL, 0x000fe400000010ffULL,
0x00000024250d723eULL, 0x000fe200000010ffULL, 0x0000000402007844ULL, 0x0005e20000000200ULL,
0x00000028290e723eULL, 0x000fe400000010ffULL, 0x0000002c2d0f723eULL, 0x000fc400000010ffULL,
0x000000121311723eULL, 0x000fe400000010ffULL, 0x0000000f08087c11ULL, 0x000fe4000f8e20ffULL,
0x000000161710723eULL, 0x000fe400000010ffULL, 0x0000001a1b12723eULL, 0x000fe200000010ffULL,
0x0000000c08007844ULL, 0x0005e20000000200ULL, 0x0000001e1f13723eULL, 0x000fe400000010ffULL,
0x0000000f09097c11ULL, 0x000fc4000f8e20ffULL, 0x000000222314723eULL, 0x000fe400000010ffULL,
0x000000262715723eULL, 0x000fe200000010ffULL, 0x0000001009007844ULL, 0x0005e20000000200ULL,
0x0000002a2b16723eULL, 0x000fe400000010ffULL, 0x0000002e2f17723eULL, 0x000fe400000010ffULL,
0x0000000f18187c11ULL, 0x000fca000f8e20ffULL, 0x0000001418007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000028003c8947ULL, 0x000fea0003800000ULL,
0x0000000600027c11ULL, 0x004fe2000f8e20ffULL, 0x00000000000979c3ULL, 0x000fe20000002700ULL,
0x00000016ff007c0cULL, 0x000fe2000bf05270ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x0000920000087ab9ULL, 0x000fe20000000800ULL, 0x01200000020c7984ULL, 0x0005280000000c00ULL,
0x00000000000479c3ULL, 0x000ee20000002600ULL, 0x0122000002107984ULL, 0x0004680000000c00ULL,
0x0124000002147984ULL, 0x0004680000000c00ULL, 0x01260000021c7984ULL, 0x0004620000000c00ULL,
0x00000005090972a4ULL, 0x008fc4000f8e0204ULL, 0x00000005170472a4ULL, 0x000fe4000f8e023fULL,
0x00000017090772a4ULL, 0x000fe4000f8e023fULL, 0x00000008040872a4ULL, 0x000fe4000f8e023fULL,
0x0000000e070a7290ULL, 0x000fe4000fffe03fULL, 0x01ffffff08107892ULL, 0x000fe2000f8ec03fULL,
0x0000000000380947ULL, 0x004ff60003800000ULL, 0x000000100a0b7290ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x0000980000047ab9ULL, 0x000fe20000000a00ULL,
0x00000001ff047819ULL, 0x000fe20000011600ULL, 0x000000800a0c78a5ULL, 0x000fe4000f8e0004ULL,
0x000000800b0478a5ULL, 0x000fe2000f8e0004ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c04077812ULL, 0x000fc800078ec0ffULL, 0x0000000c07047c10ULL, 0x140fe4000fa3e002ULL,
0x0000000407067c10ULL, 0x000fe4000fc7e002ULL, 0x0000000dff057c10ULL, 0x000fe40008fe44ffULL,
0x00000005ff077c10ULL, 0x000fc60009fe84ffULL, 0x0000000b04007986ULL, 0x0005e8000c101914ULL,
0x0000000a06007986ULL, 0x0005e4000c101914ULL, 0x00001fff08087891ULL, 0x000fe2000f8e403fULL,
0x0000002000077836ULL, 0x044fe20000000000ULL, 0x00009800000c7ab9ULL, 0x000fe20000000a00ULL,
0x000000ff0000720cULL, 0x040fe20000725670ULL, 0x0000000a08047291ULL, 0x000fe2000f8f983fULL,
0x0000004000097836ULL, 0x040fe20000000000ULL, 0x0000026000007945ULL, 0x000fe20003800000ULL,
0x0000006000197836ULL, 0x000fe20000000000ULL, 0x00002000040478a5ULL, 0x000fc8000f8e000cULL,
0x00000800160478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff0a7e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff0b7e24ULL, 0x000fe4000f8e00ffULL, 0x0000001000047825ULL, 0x000fc800078e000aULL,
0x0000001007067825ULL, 0x100fe200078e000aULL, 0x0000000c04007986ULL, 0x0105e6000c101d14ULL,
0x0000001009087825ULL, 0x100fe200078e000aULL, 0x0000001006007986ULL, 0x0025e6000c101d14ULL,
0x00000010190a7825ULL, 0x000fe200078e000aULL, 0x0000001408007986ULL, 0x0005e8000c101d14ULL,
0x0000001c0a007986ULL, 0x0005e2000c101d14ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff170a7890ULL, 0x000fe4000fffe03fULL, 0x00000004090478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000aff077e24ULL, 0x004fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ea800099ee1d4ULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000a04007c0cULL, 0x000fc8000bf25270ULL, 0x00000001ff027807ULL, 0x000fca0000800000ULL,
0x00000002ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ef00000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000040000097882ULL, 0x000fc40000000000ULL, 0x0000065404097896ULL, 0x008fd20008000009ULL,
0x00000009ff027984ULL, 0x002e640008000000ULL, 0x000000ff0200720cULL, 0x002fda0003f25270ULL,
0x0000002000f09947ULL, 0x000fea0003800000ULL, 0x0000000c008c0947ULL, 0x000fea0003800000ULL,
0x00000017ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000f08947ULL, 0x000fea0003800000ULL,
0x0000000107047890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x00000080070a78a5ULL, 0x000fe4000f8e000cULL,
0x00000080040478a5ULL, 0x000fe2000f8e000cULL, 0x0000007002087812ULL, 0x004fe400078ec0ffULL,
0x0000000c03117812ULL, 0x000fc800078ec0ffULL, 0x0000000a11027c10ULL, 0x140fe4000f91e008ULL,
0x0000000411047c10ULL, 0x000fe4000fb5e008ULL, 0x0000000bff037c10ULL, 0x000fe400087e24ffULL,
0x00000005ff057c10ULL, 0x000fc600097e64ffULL, 0x0000001402067981ULL, 0x000368000c1e1900ULL,
0x0000001404077981ULL, 0x000362000c1e1900ULL, 0x000000021700788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000000207047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e000cULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000001402097981ULL, 0x000362000c1e1900ULL, 0x000000041700788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000908947ULL, 0x002fea0003800000ULL,
0x0000000307047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e000cULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x00000014020b7981ULL, 0x000362000c1e1900ULL, 0x000000041700788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000708947ULL, 0x002fea0003800000ULL,
0x0000000407047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e000cULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x00000014020d7981ULL, 0x000362000c1e1900ULL, 0x000000061700788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000508947ULL, 0x002fea0003800000ULL,
0x0000000507047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e000cULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x00000014020f7981ULL, 0x000362000c1e1900ULL, 0x000000061700788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x000000081700788cULL, 0x000fe4000bf06070ULL, 0x0000000607047890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f8f008ULL, 0x00000080040478a5ULL, 0x000fc8000f8e000cULL,
0x00000007070a0890ULL, 0x000fe4000fffe03fULL, 0x0000000411027c10ULL, 0x000fe4000f91e008ULL,
0x000000800a0a08a5ULL, 0x000fe4000f8e000cULL, 0x00000005ff037c10ULL, 0x000fc800087e24ffULL,
0x0000000a11044c10ULL, 0x000fe4000fb5e008ULL, 0x0000001402117981ULL, 0x000364000c1e1900ULL,
0x0000000bff054c10ULL, 0x000fca00097e64ffULL, 0x0000001404134981ULL, 0x000368000c1e1900ULL,
0x0000000717047890ULL, 0x000fc8000fffe03fULL, 0x000000033f117899ULL, 0x000fcc0008011604ULL,
0x00000011ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800688947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x026fe200078e0006ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000000700127c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000980000187ab9ULL, 0x000fca0000000a00ULL, 0x000000170400728cULL, 0x000fe4000bf06070ULL,
0x0000000105057890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x000000110500728cULL, 0x000fd8000bf06070ULL, 0x0000000800300947ULL, 0x022fea0003800000ULL,
0x00000008040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000506067209ULL, 0x000fe20007810000ULL,
0x00000001040b7890ULL, 0x000fe4000fffe03fULL, 0x000000170a00728cULL, 0x000fe4000bf26070ULL,
0x000000170b00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x00000008120a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x0000001402057981ULL, 0x000368000c1e1900ULL, 0x0000000400e82947ULL, 0x000fea0003800000ULL,
0x00000009040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fe20007810000ULL,
0x00000002040b7890ULL, 0x000fe4000fffe03fULL, 0x000000170a00728cULL, 0x000fe4000bf26070ULL,
0x000000170b00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x00000009120a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x0000001402077981ULL, 0x000368000c1e1900ULL, 0x0000000400a02947ULL, 0x000fea0003800000ULL,
0x0000000a040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000906067209ULL, 0x000fe20007810000ULL,
0x00000003040b7890ULL, 0x000fe4000fffe03fULL, 0x000000170a00728cULL, 0x000fe4000bf26070ULL,
0x000000170b00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000a120a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x0000001402097981ULL, 0x000368000c1e1900ULL, 0x0000000400582947ULL, 0x000fea0003800000ULL,
0x0000000b040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000b06067209ULL, 0x000fe20007810000ULL,
0x00000004040b7890ULL, 0x000fe4000fffe03fULL, 0x000000170a00728cULL, 0x000fe4000bf26070ULL,
0x000000170b00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000b120a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x00000014020b7981ULL, 0x000368000c1e1900ULL, 0x0000000400102947ULL, 0x000fea0003800000ULL,
0x0000000c040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fe20007810000ULL,
0x00000005040b7890ULL, 0x000fe4000fffe03fULL, 0x000000170a00728cULL, 0x000fe4000bf26070ULL,
0x000000170b00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000c120a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x00000014020d7981ULL, 0x000368000c1e1900ULL, 0x0000000000c82947ULL, 0x000fea0003800000ULL,
0x0000000d040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000f06067209ULL, 0x000fe20007810000ULL,
0x00000006040b7890ULL, 0x000fe4000fffe03fULL, 0x000000170a00728cULL, 0x000fe4000bf26070ULL,
0x000000170b00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000d120a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x00000014020f7981ULL, 0x000368000c1e1900ULL, 0x0000000000802947ULL, 0x000fea0003800000ULL,
0x0000000e040a7890ULL, 0x000fe2000fffe03fULL, 0x0000001106067209ULL, 0x000fe20007810000ULL,
0x00000007040b7890ULL, 0x000fe4000fffe03fULL, 0x000000170a00728cULL, 0x000fe4000bf26070ULL,
0x000000170b00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000e120a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000a03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x0000001402117981ULL, 0x000368000c1e1900ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x0000000f040a7890ULL, 0x000fe2000fffe03fULL, 0x0000001306067209ULL, 0x000fc60007810000ULL,
0x000000170a00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000f120a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000bff037c10ULL, 0x000fca00087e24ffULL, 0x0000001402137981ULL, 0x000368000c1e1900ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000804047890ULL, 0x000fe4000fffe03fULL,
0x0000000812127890ULL, 0x000fd4000fffe03fULL, 0xfffffff400ac8947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x0000001000027824ULL, 0x00afe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000903037c10ULL, 0x000fca000fffe002ULL,
0x0000000603007388ULL, 0x0203e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000000708117291ULL, 0x000fe2000f8f983fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001007127290ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x040fe200078e00ffULL,
0x00000001ff037819ULL, 0x002fe20000011600ULL, 0x0000000916187291ULL, 0x000fe2000f8e603fULL,
0x0000002000077836ULL, 0x004fe20000000000ULL, 0x00009800000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x00002000110478a5ULL, 0x000fe2000f8e000aULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x0000004000097836ULL, 0x040fe20000000000ULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x00000060000b7836ULL, 0x000fe20000000000ULL,
0x00000800160478a5ULL, 0x000fe2000f8e0004ULL, 0x0000000903147c10ULL, 0x000fe2000fffe002ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000916138291ULL, 0x000fe2000f8e403fULL,
0x00000017ff007c0cULL, 0x000fc4000bf25270ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000004ff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000001800117c11ULL, 0x040fe2000f8e20ffULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000080120488a5ULL, 0x000fe2000f8e000aULL,
0x0000001300138c11ULL, 0x000fe2000f8e20ffULL, 0x00000080070a88a5ULL, 0x000fe2000f8e000aULL,
0x0000001007067825ULL, 0x100fe200078e0004ULL, 0x0000000014147984ULL, 0x000e620000000800ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000004ff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000916048291ULL, 0x000fe2000f8e403fULL,
0x0000001009087825ULL, 0x000fe200078e0004ULL, 0x00000000001c7805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000100b0a7825ULL, 0x100fe200078e0004ULL, 0x0000000400178c11ULL, 0x040fe4000f8e20ffULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000001000047825ULL, 0x000fe200078e0004ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000005ff0d7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000004117faeULL, 0x000fe2000b901c54ULL, 0x0000000aff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000bff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x0038000006117faeULL, 0x000fe2000b901c54ULL, 0x00000010000c8825ULL, 0x000fe200078e000cULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0058000008117faeULL, 0x000fe2000b901c54ULL, 0x00000010000e8825ULL, 0x000fe200078e000eULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x007800000a117faeULL, 0x000fe8000b901c54ULL,
0x045800000c138faeULL, 0x000fe8000b901c54ULL, 0x041800000e178faeULL, 0x0005e8000b901c54ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000167805ULL, 0x004fe2000001ff00ULL,
0x0000000800e89947ULL, 0x002fec0003800000ULL, 0x00000003ff047819ULL, 0x100fe20000011600ULL,
0x0000000107047890ULL, 0x000fe2000fffe03fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee200ULL,
0x0000000916057291ULL, 0x000fe2000f8e403fULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000112127890ULL, 0x000fe2000fffe03fULL, 0x00000002ff3b7819ULL, 0x000fe20000011600ULL,
0x0000000805077836ULL, 0x040fe20000000000ULL, 0x0000000404067812ULL, 0x000fe200078efcffULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000000704377812ULL, 0x000fe200078e7805ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x000fe200078e7807ULL,
0x00000004ff3c7e24ULL, 0x000fe2000f8e00ffULL, 0x00000007063a7812ULL, 0x000fe200078e7807ULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000000706057812ULL, 0x000fe200078e7805ULL,
0x00000005ff3f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000003837377212ULL, 0x080fe200078efcffULL,
0x000000083b3d7836ULL, 0x000fe20000000000ULL, 0x0000003805387212ULL, 0x000fe200078efcffULL,
0x00000012ff367e24ULL, 0x000fe2000f8e00ffULL, 0x0000000704397212ULL, 0x080fe200078efcffULL,
0x0000000111117890ULL, 0x000fe2000fffe03fULL, 0x000000073a3a7212ULL, 0x000fe200078efcffULL,
0x00000001000a7882ULL, 0x000fe20000000000ULL, 0x0000980000127ab9ULL, 0x000fd20000000a00ULL,
0x000000170a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000a80947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x00002000110478a5ULL, 0x000fe4000f8e0012ULL, 0x00000012ff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x000000010a197892ULL, 0x000fe2000f8ec03fULL, 0x00000013ff0f7e24ULL, 0x000fe2000f8e00ffULL,
0x00000800160478a5ULL, 0x000fe2000f8e0004ULL, 0x0000002000057836ULL, 0x040fe20000000000ULL,
0x0000000b0a0b7899ULL, 0x000fe2000800063fULL, 0x0000004000097836ULL, 0x040fe40000000000ULL,
0x00000019ff107e24ULL, 0x000fe2000f8e00ffULL, 0x000008000b0b7892ULL, 0x000fe2000f8ec03fULL,
0x00000004ff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x00000005ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000b180b7290ULL, 0x000fe2000fffe03fULL,
0x0000006000417836ULL, 0x000fc40000000000ULL, 0x00000009161a8291ULL, 0x000fe2000f8e403fULL,
0x00000080360c8825ULL, 0x100fe200078e000eULL, 0x0000000916048291ULL, 0x000fe2000f8e403fULL,
0x0000000b00117c11ULL, 0x000fe4000f8e20ffULL, 0x000000803c0e8825ULL, 0x000fc800078e000eULL,
0x0000001aff3f8e24ULL, 0x000fe4000f8e00ffULL, 0x0000001005047825ULL, 0x000fc800078e000aULL,
0x0000008010138824ULL, 0x000fe400078e023fULL, 0x00000004ff3f8e24ULL, 0x000fe4000f8e00ffULL,
0x0000001000067825ULL, 0x000fc800078e000aULL, 0x0000001009087825ULL, 0x100fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006117faeULL, 0x0003e6000b901c54ULL,
0x00000010410a7825ULL, 0x000fe200078e000aULL, 0x0038000004117faeULL, 0x0003e6000b901c54ULL,
0x0000008010418824ULL, 0x000fe200078e023fULL, 0x0058000008117faeULL, 0x0003e2000b901c54ULL,
0x00000010000c8825ULL, 0x000fc600078e000cULL, 0x007800000a117faeULL, 0x0003e2000b901c54ULL,
0x0000001000138824ULL, 0x040fe400078e0213ULL, 0x00000010000e8825ULL, 0x000fc600078e000eULL,
0x045800000c138faeULL, 0x0003e2000b901c54ULL, 0x0000001000418824ULL, 0x000fca00078e0241ULL,
0x041800000e418faeULL, 0x0003e4000b901c54ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff0a047890ULL, 0x000fe2000fffe03fULL, 0x0000000136367836ULL, 0x000fe20000000000ULL,
0x000000170a00728cULL, 0x000fe2000bf06070ULL, 0x000000013c3c7836ULL, 0x000fe20000000000ULL,
0x0000000704057899ULL, 0x000fe4000800063fULL, 0x0000000b04047899ULL, 0x000fe4000800063fULL,
0x0000008005057892ULL, 0x000fe2000f8ec03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000080004047892ULL, 0x000fc4000f8ec03fULL, 0x000000010a0a7890ULL, 0x000fe4000fffe03fULL,
0x0000000502047c10ULL, 0x002fe2000fffe03fULL, 0x0000018018047890ULL, 0x000fe4000fffe004ULL,
0x0000000111117890ULL, 0x000fe4000fffe03fULL, 0x00000001033e7824ULL, 0x000fe400078e0204ULL,
0x0000000437047c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003e0d7984ULL, 0x000e620000000800ULL, 0x0000000438087c11ULL, 0x000fe4000f8e20ffULL,
0x00000004390c7c11ULL, 0x000fe2000f8e20ffULL, 0x004580003e407984ULL, 0x000fe20000000800ULL,
0x000000043a107c11ULL, 0x000fc6000f8e20ffULL, 0x000000000404783bULL, 0x000ea80000000200ULL,
0x000000000808783bULL, 0x000ee20000000200ULL, 0x0000000d14117221ULL, 0x002fc60000010100ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x3fb8aa3b11457820ULL, 0x000fc60000410000ULL,
0x000000001010783bULL, 0x000f220000000200ULL, 0x00010000043e7824ULL, 0x044fe200078e00ffULL,
0x0000763204047816ULL, 0x000fe20000000004ULL, 0x0000004500457308ULL, 0x000ea20000000800ULL,
0x0001000005427824ULL, 0x000fe200078e00ffULL, 0x0000763209467816ULL, 0x048fe20000000046ULL,
0x0001000009487824ULL, 0x000fe200078e00ffULL, 0x0000763206417816ULL, 0x040fe20000000041ULL,
0x000100000b4a7824ULL, 0x040fe200078e00ffULL, 0x000076320b477816ULL, 0x000fe20000000047ULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x0000763207437816ULL, 0x040fe20000000043ULL,
0x0001000007447824ULL, 0x000fe200078e00ffULL, 0x000076320a097816ULL, 0x040fe20000000009ULL,
0x000100000a0a7824ULL, 0x000fc400078e00ffULL, 0x0001000041417824ULL, 0x000fe400078e00ffULL,
0x0000004045527220ULL, 0x004fe20000410000ULL, 0x0000763205407816ULL, 0x000fe20000000040ULL,
0x0001000004057824ULL, 0x000fe200078e00ffULL, 0x0000763208457816ULL, 0x000fe20000000045ULL,
0x0000003552357221ULL, 0x000fe20000010000ULL, 0x00001f3b52517589ULL, 0x000ea200000e0000ULL,
0x0001000008087824ULL, 0x000fe400078e00ffULL, 0x0001000040077824ULL, 0x000fe200078e00ffULL,
0x00001f3d52527589ULL, 0x000ee200000e0000ULL, 0x0001000043437824ULL, 0x000fc400078e00ffULL,
0x0001000045457824ULL, 0x000fe400078e00ffULL, 0x0001000009097824ULL, 0x000fe400078e00ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x000076320d497816ULL, 0x042fe20000000049ULL,
0x000100000d4c7824ULL, 0x000fe200078e00ffULL, 0x000076320e0d7816ULL, 0x040fe2000000000dULL,
0x000100000e4b7824ULL, 0x000fe200078e00ffULL, 0x000076320f0e7816ULL, 0x040fe2000000000eULL,
0x000100000f4e7824ULL, 0x000fe200078e00ffULL, 0x00007632100f7816ULL, 0x050fe2000000000fULL,
0x00010000104d7824ULL, 0x000fe200078e00ffULL, 0x0000763211107816ULL, 0x040fe20000000010ULL,
0x0001000011507824ULL, 0x000fe200078e00ffULL, 0x000076320c0b7816ULL, 0x040fe2000000000bULL,
0x000100000c0c7824ULL, 0x000fc400078e00ffULL, 0x0000005105287223ULL, 0x084fe20000010028ULL,
0x0000763212117816ULL, 0x000fe20000000011ULL, 0x0001000046057824ULL, 0x000fe200078e00ffULL,
0x00007632134f7816ULL, 0x000fe2000000004fULL, 0x0000005106257223ULL, 0x080fe20000010025ULL,
0x0001000012127824ULL, 0x000fe400078e00ffULL, 0x00000051051e7223ULL, 0x080fe2000001001eULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x000000513e297223ULL, 0x000fe20000010029ULL,
0x000100000b0b7824ULL, 0x000fc400078e00ffULL, 0x0000005142277223ULL, 0x080fe20000010027ULL,
0x0001000049497824ULL, 0x000fe400078e00ffULL, 0x0000005107267223ULL, 0x080fe20000010026ULL,
0x000100000d0d7824ULL, 0x000fe400078e00ffULL, 0x0000005141247223ULL, 0x080fe20000010024ULL,
0x000100000e0e7824ULL, 0x000fe400078e00ffULL, 0x0000005144237223ULL, 0x000fe20000010023ULL,
0x000100000f0f7824ULL, 0x000fc400078e00ffULL, 0x0000005143227223ULL, 0x080fe20000010022ULL,
0x0001000010057824ULL, 0x000fe400078e00ffULL, 0x0000005108217223ULL, 0x080fe20000010021ULL,
0x0001000011047824ULL, 0x000fe400078e00ffULL, 0x0000005145207223ULL, 0x080fe20000010020ULL,
0x000100004f067824ULL, 0x000fe400078e00ffULL, 0x00000051481f7223ULL, 0x080fe2000001001fULL,
0x000000510a1d7223ULL, 0x080fe2000001001dULL, 0x00000051091c7223ULL, 0x080fe2000001001cULL,
0x000000514a1b7223ULL, 0x080fe2000001001bULL, 0x00000051471a7223ULL, 0x000fe2000001001aULL,
0x000000520c197223ULL, 0x088fe20000010019ULL, 0x000000520b187223ULL, 0x080fe20000010018ULL,
0x000000524c177223ULL, 0x080fe20000010017ULL, 0x0000005249167223ULL, 0x080fe20000010016ULL,
0x000000524b347223ULL, 0x080fe20000010034ULL, 0x000000520d307223ULL, 0x080fe20000010030ULL,
0x000000524e337223ULL, 0x080fe20000010033ULL, 0x000000520e2f7223ULL, 0x080fe2000001002fULL,
0x000000524d327223ULL, 0x080fe20000010032ULL, 0x000000520f2e7223ULL, 0x080fe2000001002eULL,
0x00000052502d7223ULL, 0x080fe2000001002dULL, 0x00000052052c7223ULL, 0x080fe2000001002cULL,
0x00000052122b7223ULL, 0x080fe2000001002bULL, 0x0000005204317223ULL, 0x080fe20000010031ULL,
0x00000052132a7223ULL, 0x080fe2000001002aULL, 0x0000005206157223ULL, 0x000fe20000010015ULL,
0xfffffff400848947ULL, 0x000fec000383ffffULL, 0x0180000035007836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe80000010000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000bde000027802ULL, 0x000fce0000000f00ULL, 0x0000009000f07944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000003500027308ULL, 0x000e640000001000ULL, 0xbf80000002007423ULL, 0x002fc80000000035ULL,
0x800000ff00037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fce0000000002ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x00000002ff097819ULL, 0x104fe40000011600ULL,
0x00000008000b7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0902047589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff117812ULL, 0x000fc600078ee200ULL, 0x00001f0b020c7589ULL, 0x00072200000e0000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000002904297220ULL, 0x044fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002704057220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002504067220ULL, 0x040fe20000410000ULL,
0x0000002404077220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002104087220ULL, 0x040fe20000410000ULL,
0x0000002004097220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001d040a7220ULL, 0x040fe20000410000ULL,
0x0000001c040b7220ULL, 0x048fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x000fe20000410000ULL, 0x0000000303047812ULL, 0x000fe200078ec0ffULL,
0x00000008111d7836ULL, 0x000fc40000000000ULL, 0x000000190c197220ULL, 0x050fe20000410000ULL,
0x000000180c187220ULL, 0x000fe20000410000ULL, 0x0000000404107812ULL, 0x000fe200078efcffULL,
0x000000170c177220ULL, 0x040fe20000410000ULL, 0x000000160c167220ULL, 0x040fe20000410000ULL,
0x000000340c347220ULL, 0x040fe20000410000ULL, 0x000000300c0d7220ULL, 0x040fe20000410000ULL,
0x000000330c337220ULL, 0x040fe20000410000ULL, 0x0000002f0c027220ULL, 0x040fe20000410000ULL,
0x000000320c327220ULL, 0x040fe20000410000ULL, 0x0000002e0c0f7220ULL, 0x040fe20000410000ULL,
0x0000002d0c2d7220ULL, 0x040fe20000410000ULL, 0x0000002c0c2c7220ULL, 0x040fe20000410000ULL,
0x0000002b0c2b7220ULL, 0x040fe20000410000ULL, 0x000000310c0e7220ULL, 0x040fe20000410000ULL,
0x0000002a0c2a7220ULL, 0x040fe20000410000ULL, 0x000000150c157220ULL, 0x000fe20000410000ULL,
0x00000008110c7824ULL, 0x000fe200078e00ffULL, 0x0000000704137812ULL, 0x000fc400078e7811ULL,
0x0000000704217812ULL, 0x000fe200078e781dULL, 0x000000081d047824ULL, 0x000fe200078e00ffULL,
0x0000000710117812ULL, 0x000fe400078e7811ULL, 0x00000007101d7812ULL, 0x000fe400078e781dULL,
0x0000000c13137212ULL, 0x080fe400078efcffULL, 0x0000000c11117212ULL, 0x000fe400078efcffULL,
0x0000000421217212ULL, 0x000fc400078efcffULL, 0x000000041d1d7212ULL, 0x000fe400078efcffULL,
0x000000060706723eULL, 0x000fe400000010ffULL, 0x000000292804723eULL, 0x000fe400000010ffULL,
0x000000052605723eULL, 0x000fe400000010ffULL, 0x000000232207723eULL, 0x000fe400000010ffULL,
0x000000080908723eULL, 0x000fc400000010ffULL, 0x0000000a0b0a723eULL, 0x000fe400000010ffULL,
0x0000000f13137c11ULL, 0x000fe4000f8e20ffULL, 0x0000001f1e09723eULL, 0x000fe400000010ffULL,
0x0000001b1a0b723eULL, 0x000fe200000010ffULL, 0x0000000413007844ULL, 0x0005e20000000200ULL,
0x000000191818723eULL, 0x000fe400000010ffULL, 0x0000000f11117c11ULL, 0x000fc4000f8e20ffULL,
0x000000171619723eULL, 0x000fe400000010ffULL, 0x000000340d1a723eULL, 0x000fe200000010ffULL,
0x0000000811007844ULL, 0x0005e20000000200ULL, 0x00000033021b723eULL, 0x000fe400000010ffULL,
0x000000320f0c723eULL, 0x000fe400000010ffULL, 0x0000000f21217c11ULL, 0x000fe4000f8e20ffULL,
0x0000002d2c0d723eULL, 0x000fc400000010ffULL, 0x0000002b0e0e723eULL, 0x000fe200000010ffULL,
0x0000001821007844ULL, 0x0005e20000000200ULL, 0x0000002a150f723eULL, 0x000fe400000010ffULL,
0x0000000f1d1d7c11ULL, 0x000fca000f8e20ffULL, 0x0000000c1d007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000067919ULL, 0x004e620000002600ULL,
0x00000020001a7836ULL, 0x040fe20000000000ULL, 0x00000000000979c3ULL, 0x000ea20000002700ULL,
0x00000040001f7836ULL, 0x040fe20000000000ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x0000006000217836ULL, 0x000fe20000000000ULL, 0x0000000316047899ULL, 0x000fe4000800063fULL,
0x00000003ff157819ULL, 0x000fe2000001161fULL, 0x00000004050a7899ULL, 0x000fe2000800063fULL,
0x00000003ff167819ULL, 0x000fe20000011621ULL, 0x1ffffff804057892ULL, 0x000fe2000f8ec03fULL,
0x0000000715047812ULL, 0x000fc400078e481fULL, 0x0000000716057812ULL, 0x000fe400078e4821ULL,
0x0ffffff804047812ULL, 0x000fe200078ef81fULL, 0x00000005ff1c7e24ULL, 0x000fe2000f8e00ffULL,
0x0ffffff805057812ULL, 0x000fe200078ef821ULL, 0x00000005ff1b7e24ULL, 0x000fe2000f8e00ffULL,
0x00000006040c7c11ULL, 0x000fe2000f8e20ffULL, 0x00000005ff1d7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000605107c11ULL, 0x000fe2000f8e20ffULL, 0x00000005ff1e7e24ULL, 0x000fe2000f8e00ffULL,
0x000000071c1f7812ULL, 0x000fc400078ef81fULL, 0x012000000c0c7984ULL, 0x000fe20000000c00ULL,
0x000000090a0472a4ULL, 0x004fe2000f8e023fULL, 0x000000071b1b7812ULL, 0x000fe400078ef800ULL,
0x0120000010107984ULL, 0x000fe20000000c00ULL, 0x00008600000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000001006027824ULL, 0x042fe200078e00ffULL, 0x000000071d1d7812ULL, 0x000fe200078ef81aULL,
0x0000001006147824ULL, 0x040fe200078e00ffULL, 0x000000071e217812ULL, 0x000fe200078ef821ULL,
0x0000001006187824ULL, 0x040fe200078e00ffULL, 0xfffffff002027812ULL, 0x000fe200078ee203ULL,
0x0000001006177824ULL, 0x000fe200078e00ffULL, 0x0000000703037812ULL, 0x000fc400078e4800ULL,
0xfffffff018157812ULL, 0x000fe400078ee215ULL, 0x0ffffff803077812ULL, 0x000fe400078ef800ULL,
0x00000003ff037819ULL, 0x000fe4000001161aULL, 0x0000000607067c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff014147812ULL, 0x000fe400078ee203ULL, 0x0000000703037812ULL, 0x000fc400078e481aULL,
0x0120000006047984ULL, 0x000e620000000c00ULL, 0xfffffff017167812ULL, 0x000fe400078ee216ULL,
0x0ffffff803037812ULL, 0x000fe400078ef81aULL, 0x0000000402177c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000603037c11ULL, 0x000fe4000f8e20ffULL, 0x0000000416007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x0000000a17027c11ULL, 0x040fe2000f8048ffULL,
0x0120000003087984ULL, 0x0004e40000000c00ULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x0000000b17037c11ULL, 0x004fc400080f4c18ULL, 0x00000004141c7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000415177c10ULL, 0x000fe2000ff3e0ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x0000000a00187c11ULL, 0x000fc6000f8448ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0000000a1c147c11ULL, 0x040fe2000f8048ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000000a17167c11ULL, 0x040fe4000f8248ffULL, 0x0000000b1c157c11ULL, 0x000fe400080f4c15ULL,
0x0000000b17177c11ULL, 0x000fe400088f4c1aULL, 0x0000000b00197c11ULL, 0x000fe200090f4c19ULL,
0x000000101d147825ULL, 0x000fe200078e0014ULL, 0x0000000402007986ULL, 0x002fe6000c101d14ULL,
0x000000101f167825ULL, 0x000fc800078e0016ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x0000000814007986ULL, 0x008fe8000c101d14ULL, 0x0000000c16007986ULL, 0x000fe8000c101d14ULL,
0x0000001018007986ULL, 0x000fe2000c101d14ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000900001347983ULL, 0x000ea20000100800ULL, 0x03ffffff16077892ULL, 0x000fe2000f8ec03fULL,
0x00000000340972caULL, 0x004fda00000e0000ULL, 0x0000000709077291ULL, 0x000fc8000f8e103fULL,
0x000000050700728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x0000000104098899ULL, 0x000fe2000800063fULL, 0x00009000000a8ab9ULL, 0x000fc60000000800ULL,
0x0000000a090982a4ULL, 0x000fc6000f8e0207ULL, 0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL,
0x00000004090a88a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff037e24ULL, 0x000fca000f8e00ffULL, 0x0000001402028981ULL, 0x000ea2000c1e1900ULL,
0x0000000134007836ULL, 0x000fe20000000000ULL, 0x00000006080d7899ULL, 0x000fe4000800063fULL,
0x00000006160f7899ULL, 0x000fe2000800063fULL, 0xffffffff00087882ULL, 0x000fe20000000000ULL,
0x000000060c0c7899ULL, 0x000fe2000800063fULL, 0x00000000020982caULL, 0x004fe400000e0000ULL,
0x0000000600007c0cULL, 0x000fd6000bf06070ULL, 0x0000000900088c82ULL, 0x000fe40008000000ULL,
0x0000000c00448947ULL, 0x000fea0003800000ULL, 0x0000000000227919ULL, 0x000e620000000000ULL,
0x0000000f34047c11ULL, 0x000fe2000f8e40ffULL, 0x00008a00ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000c080b72a4ULL, 0x000fe4000f8e020dULL, 0x0000001804077c48ULL, 0x000fe2000ffe0000ULL,
0x0000040000097882ULL, 0x000fc80000000000ULL, 0x0000000107047824ULL, 0x000fe200078e0a04ULL,
0x00000000000a79c3ULL, 0x000ee20000008800ULL, 0x00000003ff057819ULL, 0x002fe40000011622ULL,
0x0ffffff822077812ULL, 0x040fe200078ec0ffULL, 0x000006540a0e7896ULL, 0x008fe20008000009ULL,
0x0000002205007212ULL, 0x0c0fe200078e3cffULL, 0x00000008050b7836ULL, 0x040fe40000000000ULL,
0x0000000405097836ULL, 0x000fe20000000000ULL, 0x0000000707157812ULL, 0x000fe200078ef800ULL,
0x000000080b087824ULL, 0x040fe200078e00ffULL, 0x000000220b077212ULL, 0x080fe200078e3cffULL,
0x00000008091b7824ULL, 0x040fe200078e00ffULL, 0x0000002209067212ULL, 0x000fe200078e3cffULL,
0x0000001022007824ULL, 0x000fe200078e00ffULL, 0xfffffff8081d7812ULL, 0x000fe200078ee207ULL,
0x0000000c050d7836ULL, 0x040fe20000000000ULL, 0x0000003f05077812ULL, 0x040fe200078ec0ffULL,
0x0000001405177836ULL, 0x000fe20000000000ULL, 0x000000040900720cULL, 0x080fe20003fa6070ULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0x0000003f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000b07077c36ULL, 0x000fe20008000000ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL,
0x0000001805197836ULL, 0x000fe20000000000ULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000000b09097c36ULL, 0x000fe20008000000ULL, 0x0000003f0d0c7812ULL, 0x000fe200078ec0ffULL,
0x0000020007067825ULL, 0x104fe200078e0002ULL, 0x000000040d00720cULL, 0x040fe20003f06070ULL,
0x0000000e16097291ULL, 0x000fe2000f8e703fULL, 0x000000220d0e7212ULL, 0x000fe200078e3cffULL,
0x0000020009087825ULL, 0x000fe200078e0002ULL, 0x0000000600107210ULL, 0x000fe20007f5e0ffULL,
0x0000200009097890ULL, 0x000fe2000fffe03fULL, 0x000000040b00720cULL, 0x040fe20003f26070ULL,
0x0000000b0c0d7c36ULL, 0x000fe20008000000ULL, 0x0000000800127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0607ULL, 0x0000003f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x000002000d067825ULL, 0x000fe200078e0002ULL, 0xfffffff80f1a7812ULL, 0x000fc400078ee20eULL,
0x0000003f170f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0609ULL,
0x00000006000c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001005097836ULL, 0x000fe20000000000ULL,
0x000000041700720cULL, 0x080fe20003f66070ULL, 0x0000000b0b0b7c36ULL, 0x000fe20008000000ULL,
0x0000000915157c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0607ULL,
0x0000003f09067812ULL, 0x000fe200078ec0ffULL, 0x000002000b0a7825ULL, 0x000fe200078e0002ULL,
0x000000040900720cULL, 0x000fc40003f46070ULL, 0x0000002209147212ULL, 0x0c0fe200078e3cffULL,
0x0000000b06077c36ULL, 0x000fe20008000000ULL, 0x0000000a000a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x0000002219167212ULL, 0x080fe200078e3cffULL,
0x0000020007067825ULL, 0x000fe200078e0002ULL, 0x000000091b1b7c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff8091c7812ULL, 0x000fe200078ee214ULL, 0x0000000b0f0f7c36ULL, 0x000fe20008000000ULL,
0x0000000600087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e060bULL,
0x0000002217067212ULL, 0x040fe200078e3cffULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0x000000040500720cULL, 0x000fe20003f86070ULL, 0x000000ffff097224ULL, 0x000fe200030e0607ULL,
0x0000003f19077812ULL, 0x000fe200078ec0ffULL, 0x0000001c05217836ULL, 0x000fe20000000000ULL,
0xfffffff8171e7812ULL, 0x000fe200078ee206ULL, 0x000002000f0e7825ULL, 0x000fe200078e0002ULL,
0x000000091d1d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000003f21177812ULL, 0x000fe200078ec0ffULL,
0x0000000b07077c36ULL, 0x000fe20008000000ULL, 0x0000000e000e7210ULL, 0x000fe20007fde0ffULL,
0x0000002005237836ULL, 0x000fe40000000000ULL, 0x0000020007067825ULL, 0x000fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010157faeULL, 0x0003e2000e101c54ULL,
0x000000041900720cULL, 0x080fe40003f86070ULL, 0x0000000b17177c36ULL, 0x000fe20008000000ULL,
0x0000003f23187812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x0000000600147210ULL, 0x000fe20007fde0ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x00000000121b7faeULL, 0x0005e2000e901c54ULL, 0x0000002405257836ULL, 0x000fe20000000000ULL,
0x000000042100720cULL, 0x0c0fe20003fa6070ULL, 0x0000000821277824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL, 0x0000020017107825ULL, 0x002fe200078e0002ULL,
0x0000003f25197812ULL, 0x040fe200078ec0ffULL, 0x000000000a1d7faeULL, 0x0003e2000c901c54ULL,
0x000000042500720cULL, 0x000fe20003f26070ULL, 0x0000000b18177c36ULL, 0x000fc40008000000ULL,
0x000000ffff157224ULL, 0x000fe200030e0607ULL, 0x0000001000167210ULL, 0x000fe20007fde0ffULL,
0x0000020017067825ULL, 0x000fe200078e0002ULL, 0x000000091a137c11ULL, 0x004fe4000f8e20ffULL,
0x0000002223127212ULL, 0x080fe200078e3cffULL, 0x000000ffff177224ULL, 0x000fe200030e0611ULL,
0x0000000600187210ULL, 0x000fe20007fde0ffULL, 0x000000000c137faeULL, 0x0005e2000c101c54ULL,
0x0000000b19197c36ULL, 0x000fe20008000000ULL, 0x0000002221067212ULL, 0x000fe200078e3cffULL,
0x0000002805217836ULL, 0x000fe20000000000ULL, 0x000000042300720cULL, 0x040fe20003f06070ULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x00000022251a7212ULL, 0x000fe200078e3cffULL,
0x0000020019107825ULL, 0x000fe200078e0002ULL, 0x000000091c0b7c11ULL, 0x002fc4000f8e20ffULL,
0xfffffff823127812ULL, 0x000fe200078ee212ULL, 0x000000ffff197224ULL, 0x000fe200030e0607ULL,
0x0000003f21077812ULL, 0x000fe200078ec0ffULL, 0x0000002c05237836ULL, 0x000fe20000000000ULL,
0x000000091e0d7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x0000001000107210ULL, 0x000fe20007fde0ffULL, 0x0000000b07077c36ULL, 0x000fe20008000000ULL,
0x0000003f230a7812ULL, 0x000fe200078ec0ffULL, 0x00000000080b7faeULL, 0x0003e2000d101c54ULL,
0xfffffff827207812ULL, 0x000fe200078ee206ULL, 0x0000020007067825ULL, 0x000fe200078e0002ULL,
0x000000091f137c11ULL, 0x000fe2000f8e20ffULL, 0x000000000e0d7faeULL, 0x000fe2000d901c54ULL,
0xfffffff8251a7812ULL, 0x000fe200078ee21aULL, 0x0000003005257836ULL, 0x040fe20000000000ULL,
0x00000009201b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000000014137faeULL, 0x0005e2000e101c54ULL, 0x0000000600067210ULL, 0x000fe20007fde0ffULL,
0x0000003405277836ULL, 0x000fe20000000000ULL, 0x00000009121d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b0a097c36ULL, 0x002fe20008000000ULL, 0x000000091a1f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x00000000161b7faeULL, 0x0003e2000e901c54ULL,
0x0000020009087825ULL, 0x000fe200078e0002ULL, 0x000000042100720cULL, 0x000fc40003fa6070ULL,
0x00000000181d7faeULL, 0x000fe2000c101c54ULL, 0x0000003805137836ULL, 0x044fe20000000000ULL,
0x00000008000a7210ULL, 0x000fe20007fde0ffULL, 0x0000003c05157836ULL, 0x000fe20000000000ULL,
0x0000003f25057812ULL, 0x000fe200078ec0ffULL, 0x00000000101f7faeULL, 0x0005e2000c901c54ULL,
0x000000042300720cULL, 0x080fe20003f86070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0609ULL,
0x000000042500720cULL, 0x080fe20003f66070ULL, 0x0000000b05057c36ULL, 0x000fe20008000000ULL,
0x000000042700720cULL, 0x080fe20003f46070ULL, 0x0000000815167824ULL, 0x002fe200078e00ffULL,
0x000000041300720cULL, 0x000fc40003f26070ULL, 0x000000041500720cULL, 0x000fe20003f06070ULL,
0x0000020005047825ULL, 0x000fe200078e0002ULL, 0x0000003f27097812ULL, 0x000fe400078ec0ffULL,
0x00000022230d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000823107824ULL, 0x004fe200078e00ffULL,
0x00000004000c7210ULL, 0x000fe20007fde0ffULL, 0x0000000b09097c36ULL, 0x000fe20008000000ULL,
0x0000003f130f7812ULL, 0x000fe400078ec0ffULL, 0xfffffff810117812ULL, 0x000fe200078ee20dULL,
0x000000ffff0d7224ULL, 0x000fe200030e0605ULL, 0x0000002221087212ULL, 0x0c0fe200078e3cffULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0x0000003f15147812ULL, 0x000fe200078ec0ffULL,
0x0000020009047825ULL, 0x000fe200078e0002ULL, 0x0000002225107212ULL, 0x000fc400078e3cffULL,
0xfffffff8210e7812ULL, 0x000fe200078ee208ULL, 0x0000000b0f0f7c36ULL, 0x000fe20008000000ULL,
0x0000000400047210ULL, 0x000fe20007fde0ffULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x0000002227127212ULL, 0x000fe200078e3cffULL, 0x000002000f087825ULL, 0x000fe200078e0002ULL,
0x0000000911117c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff825107812ULL, 0x000fe200078ee210ULL,
0x0000000b140f7c36ULL, 0x000fe40008000000ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000000800087210ULL, 0x000fe20007fde0ffULL, 0x0000000827277824ULL, 0x000fc400078e00ffULL,
0x000002000f027825ULL, 0x000fe200078e0002ULL, 0x00000022130f7212ULL, 0x0c0fe400078e3cffULL,
0xfffffff827127812ULL, 0x000fe200078ee212ULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0x0000002215137212ULL, 0x000fe200078e3cffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000000200027210ULL, 0x000fe40007fde0ffULL, 0xfffffff814177812ULL, 0x000fe400078ee20fULL,
0x000000090e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0xfffffff816197812ULL, 0x000fc400078ee213ULL, 0x0000000910137c11ULL, 0x000fe2000f8e20ffULL,
0x00000000060f7faeULL, 0x0003e2000e901c54ULL, 0x0000000912157c11ULL, 0x000fe4000f8e20ffULL,
0x0000000917177c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a117faeULL, 0x0003e2000e101c54ULL,
0x0000000919197c11ULL, 0x000fc6000f8e20ffULL, 0x000000000c137faeULL, 0x0003e8000d901c54ULL,
0x0000000004157faeULL, 0x0003e8000d101c54ULL, 0x0000000008177faeULL, 0x0003e8000c901c54ULL,
0x0000000002197faeULL, 0x0003e2000c101c54ULL, 0x0000000800f47947ULL, 0x000fea0003800000ULL,
0x00000000001a7919ULL, 0x000e620000000000ULL, 0x0000000c080a72a4ULL, 0x000fe2000f8e020dULL,
0x00000000000979c3ULL, 0x000ea20000008800ULL, 0x00000400000e7882ULL, 0x000fe40000000000ULL,
0x00000654090e7896ULL, 0x004fc8000800000eULL, 0x0000000e16097291ULL, 0x000fe2000f8e703fULL,
0x00000003ff027819ULL, 0x002fe4000001161aULL, 0x0ffffff81a007812ULL, 0x000fe200078ec0ffULL,
0x0000200009097890ULL, 0x000fe2000fffe03fULL, 0x0000001a020b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000402167836ULL, 0x040fe40000000000ULL, 0x0000000802177836ULL, 0x000fe20000000000ULL,
0x00000007000b7812ULL, 0x000fe200078ef80bULL, 0x0000000816037824ULL, 0x040fe200078e00ffULL,
0x0000001a160a7212ULL, 0x080fe200078e3cffULL, 0x0000000817057824ULL, 0x040fe200078e00ffULL,
0x0000001a170c7212ULL, 0x080fe200078e3cffULL, 0x00000018021d7836ULL, 0x040fe20000000000ULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x0000001c021f7836ULL, 0x040fe20000000000ULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x000000081d037824ULL, 0x040fe200078e00ffULL,
0x0000001a1d107212ULL, 0x080fe200078e3cffULL, 0x000000081f057824ULL, 0x040fe200078e00ffULL,
0x0000001a1f0e7212ULL, 0x080fe200078e3cffULL, 0x0000002402237836ULL, 0x040fe20000000000ULL,
0xfffffff803107812ULL, 0x000fe200078ee210ULL, 0x0000002802257836ULL, 0x040fe20000000000ULL,
0xfffffff8050e7812ULL, 0x000fe200078ee20eULL, 0x0000000823037824ULL, 0x040fe200078e00ffULL,
0x0000001a23127212ULL, 0x080fe200078e3cffULL, 0x0000000825057824ULL, 0x040fe200078e00ffULL,
0x0000001a25087212ULL, 0x080fe200078e3cffULL, 0x00000034022b7836ULL, 0x040fe20000000000ULL,
0xfffffff803127812ULL, 0x000fe200078ee212ULL, 0x0000003002297836ULL, 0x040fe20000000000ULL,
0xfffffff805087812ULL, 0x000fe200078ee208ULL, 0x0000000c02187836ULL, 0x000fe20000000000ULL,
0x0000001a2b057212ULL, 0x0c0fe200078e3cffULL, 0x000000082b147824ULL, 0x000fe200078e00ffULL,
0x0000001a29067212ULL, 0x0c0fe200078e3cffULL, 0x0000000829037824ULL, 0x000fe200078e00ffULL,
0x0000001a18097212ULL, 0x080fe200078e3cffULL, 0x0000001002197836ULL, 0x000fe20000000000ULL,
0xfffffff814057812ULL, 0x000fe200078ee205ULL, 0x0000000818047824ULL, 0x000fe200078e00ffULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x00000014021b7836ULL, 0x040fe20000000000ULL,
0x0000003f02147812ULL, 0x040fe200078ec0ffULL, 0x0000002002217836ULL, 0x040fe20000000000ULL,
0x0000001a190d7212ULL, 0x080fe200078e3cffULL, 0x0000002c02277836ULL, 0x040fe20000000000ULL,
0xfffffff804097812ULL, 0x000fe200078ee209ULL, 0x00000038022d7836ULL, 0x040fe20000000000ULL,
0x0000001a1b0f7212ULL, 0x080fe200078e3cffULL, 0x0000003c022f7836ULL, 0x000fe20000000000ULL,
0x0000001a21117212ULL, 0x080fe200078e3cffULL, 0x0000000819007824ULL, 0x000fe200078e00ffULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x000000081b047824ULL, 0x000fe200078e00ffULL,
0x0000001a27077212ULL, 0x000fe200078e3cffULL, 0x000000082f157824ULL, 0x000fe200078e00ffULL,
0xfffffff8000d7812ULL, 0x000fe200078ee20dULL, 0x0000000821007824ULL, 0x000fe200078e00ffULL,
0xfffffff8040f7812ULL, 0x000fe200078ee20fULL, 0x0000000827047824ULL, 0x000fe200078e00ffULL,
0x0000003f16167812ULL, 0x000fe200078ec0ffULL, 0x000000082d137824ULL, 0x000fe200078e00ffULL,
0xfffffff800117812ULL, 0x000fc400078ee211ULL, 0x0000001a2f007212ULL, 0x080fe400078e3cffULL,
0xfffffff804077812ULL, 0x000fe400078ee207ULL, 0x0000001a2d047212ULL, 0x000fe400078e3cffULL,
0xfffffff815007812ULL, 0x000fe200078ee200ULL, 0x0000000a14157c36ULL, 0x000fe20008000000ULL,
0x0000003f17147812ULL, 0x000fe200078ec0ffULL, 0x0000000a16177c36ULL, 0x000fe20008000000ULL,
0xfffffff813047812ULL, 0x000fe200078ee204ULL, 0x000000101a137824ULL, 0x000fe200078e00ffULL,
0x0000003f18187812ULL, 0x000fe200078ec0ffULL, 0x0000020017167825ULL, 0x002fe200078e0002ULL,
0x0000003f191a7812ULL, 0x000fc400078ec0ffULL, 0x0000003f1b1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000a14197c36ULL, 0x000fe20008000000ULL, 0x0000003f1d1e7812ULL, 0x000fe200078ec0ffULL,
0x0000020015147825ULL, 0x100fe200078e0002ULL, 0x0000003f1f207812ULL, 0x000fe400078ec0ffULL,
0x0000003f21227812ULL, 0x000fe200078ec0ffULL, 0x0000000a181b7c36ULL, 0x000fe20008000000ULL,
0x0000003f23247812ULL, 0x000fe200078ec0ffULL, 0x0000000a1a1d7c36ULL, 0x000fe20008000000ULL,
0x0000003f25267812ULL, 0x000fe200078ec0ffULL, 0x0000000a1c1f7c36ULL, 0x000fe20008000000ULL,
0x0000003f27287812ULL, 0x000fe200078ec0ffULL, 0x0000000a1e217c36ULL, 0x000fe20008000000ULL,
0x0000003f292a7812ULL, 0x000fe200078ec0ffULL, 0x0000000a20237c36ULL, 0x000fe20008000000ULL,
0x0000003f2b2c7812ULL, 0x000fe200078ec0ffULL, 0x0000000a22257c36ULL, 0x000fe20008000000ULL,
0x0000003f2d2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000a24277c36ULL, 0x000fe20008000000ULL,
0x0000003f2f307812ULL, 0x000fe200078ec0ffULL, 0x0000000a26297c36ULL, 0x000fe20008000000ULL,
0x0000007013137812ULL, 0x000fe200078ec0ffULL, 0x0000000a282b7c36ULL, 0x000fe20008000000ULL,
0x000000090b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a2a2d7c36ULL, 0x000fe20008000000ULL,
0x0000001413147210ULL, 0x000fe20007f1e0ffULL, 0x0000000a2c2f7c36ULL, 0x000fe20008000000ULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a2e317c36ULL, 0x000fe20008000000ULL,
0x000000090d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000a30337c36ULL, 0x000fe20008000000ULL,
0x000000090f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020019187825ULL, 0x000fe200078e0002ULL,
0x0000000910357c11ULL, 0x000fc4000f8e20ffULL, 0x0000000911117c11ULL, 0x000fe2000f8e20ffULL,
0x000002001b1a7825ULL, 0x100fe200078e0002ULL, 0x0000000907077c11ULL, 0x000fe4000f8e20ffULL,
0x0000000905057c11ULL, 0x000fe2000f8e20ffULL, 0x000002001d1c7825ULL, 0x000fc800078e0002ULL,
0x000002001f1e7825ULL, 0x000fc800078e0002ULL, 0x0000020021207825ULL, 0x000fc800078e0002ULL,
0x0000020023227825ULL, 0x000fc800078e0002ULL, 0x0000020025247825ULL, 0x000fc800078e0002ULL,
0x0000020027267825ULL, 0x000fc800078e0002ULL, 0x0000020029287825ULL, 0x000fc800078e0002ULL,
0x000002002b2a7825ULL, 0x000fc800078e0002ULL, 0x000002002d2c7825ULL, 0x000fc800078e0002ULL,
0x000002002f2e7825ULL, 0x000fc800078e0002ULL, 0x0000020031307825ULL, 0x000fc800078e0002ULL,
0x0000020033327825ULL, 0x000fe200078e0002ULL, 0x0000001613027210ULL, 0x000fe40007f3e0ffULL,
0x0000001813167210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000001a13187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e0617ULL,
0x0000001c131a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140b7faeULL, 0x0003e2000b901c54ULL,
0x000000ffff197224ULL, 0x000fe200000e061bULL, 0x0000001e131c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e061dULL, 0x00000020131e7210ULL, 0x000fc40007f5e0ffULL,
0x0000002213207210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061fULL,
0x0000002413227210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe400010e0621ULL,
0x000000ffff217224ULL, 0x000fe200008e0623ULL, 0x0000002613247210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200000e0625ULL, 0x0000002813267210ULL, 0x000fe40007f1e0ffULL,
0x000000090e0b7c11ULL, 0x002fe2000f8e20ffULL, 0x000000ffff257224ULL, 0x000fe200008e0627ULL,
0x0000002a13287210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0629ULL,
0x0000002c132a7210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff297224ULL, 0x000fe200008e062bULL,
0x0000002e132c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e062dULL,
0x00000030132e7210ULL, 0x000fe40007f1e0ffULL, 0x0000003213307210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062fULL, 0x000000090a137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2f7224ULL, 0x000fe400000e0631ULL, 0x000000ffff317224ULL, 0x000fe200010e0633ULL,
0x000000090c337c11ULL, 0x000fe2000f8e20ffULL, 0x0000000002137faeULL, 0x0003e8000b901c54ULL,
0x0000000016337faeULL, 0x000fe8000b901c54ULL, 0x0000000018097faeULL, 0x0007e8000b901c54ULL,
0x000000001a0d7faeULL, 0x0009e2000b901c54ULL, 0x0000000912037c11ULL, 0x002fc6000f8e20ffULL,
0x000000001c0f7faeULL, 0x0003e2000b901c54ULL, 0x0000000908097c11ULL, 0x008fc6000f8e20ffULL,
0x000000001e357faeULL, 0x000fe2000b901c54ULL, 0x00000009060d7c11ULL, 0x010fc6000f8e20ffULL,
0x00000000200b7faeULL, 0x0007e2000b901c54ULL, 0x00000009000f7c11ULL, 0x002fc6000f8e20ffULL,
0x0000000022117faeULL, 0x0005e8000b901c54ULL, 0x0000000024037faeULL, 0x0005e2000b901c54ULL,
0x00000009040b7c11ULL, 0x008fc6000f8e20ffULL, 0x0000000026097faeULL, 0x0005e8000b901c54ULL,
0x0000000028077faeULL, 0x0005e8000b901c54ULL, 0x000000002a0d7faeULL, 0x0005e8000b901c54ULL,
0x000000002c057faeULL, 0x0005e8000b901c54ULL, 0x000000002e0b7faeULL, 0x0005e8000b901c54ULL,
0x00000000300f7faeULL, 0x0005e4000b901c54ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x024600ffff0075a7ULL, 0x000ee2000800014eULL, 0x0000000634007c0cULL, 0x000fe2000bf26070ULL,
0x00000068004c8947ULL, 0x008fd80003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00007610ff007816ULL, 0x000fe20000000000ULL, 0x00009000000a7ab9ULL, 0x000fe20000000800ULL,
0x0000000e16117291ULL, 0x000fe4000f8e203fULL, 0x0000000a040a72a4ULL, 0x000fe2000f8e023fULL,
0x0000dc0001007387ULL, 0x0007f60000100600ULL, 0x0000900001007983ULL, 0x008ee40000100800ULL,
0x00000000000b72caULL, 0x008fda00000e0000ULL, 0x0000000f0b0b7291ULL, 0x000fc8000f8e403fULL,
0x0000000b1800728cULL, 0x000fcc000bf04070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000100007836ULL, 0x000fe20000000000ULL,
0x00000000002e7919ULL, 0x004ea80000000000ULL, 0x0000000600007c0cULL, 0x000fda000bf06070ULL,
0x0000000c00648947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x004fe2000001162eULL,
0x000000080c0872a4ULL, 0x000fe4000f8e020dULL, 0x8000000b18097290ULL, 0x000fe2000fffe03fULL,
0x0000003f00067812ULL, 0x042fe200078ec0ffULL, 0x0000000400597836ULL, 0x040fe20000000000ULL,
0x00008a0000127ab9ULL, 0x000fe20000000a00ULL, 0x0000000c00577836ULL, 0x040fe20000000000ULL,
0x0000000e16047291ULL, 0x000fe2000f8e703fULL, 0x0000000859037824ULL, 0x040fe200078e00ffULL,
0x0000002e596c7212ULL, 0x080fe200078e3cffULL, 0x0000000800587836ULL, 0x040fe20000000000ULL,
0x0000002e576e7212ULL, 0x0c0fe200078e3cffULL, 0x0000001000567836ULL, 0x000fe20000000000ULL,
0xfffffff8036c7812ULL, 0x000fe200078ee26cULL, 0x0000000857037824ULL, 0x000fe200078e00ffULL,
0x0000002e586d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000858027824ULL, 0x000fe200078e00ffULL,
0x0000002e566a7212ULL, 0x080fe200078e3cffULL, 0x0000001400557836ULL, 0x000fe20000000000ULL,
0xfffffff8036e7812ULL, 0x000fe200078ee26eULL, 0x0000000856037824ULL, 0x000fe200078e00ffULL,
0xfffffff8026d7812ULL, 0x000fe200078ee26dULL, 0x0000001800547836ULL, 0x040fe20000000000ULL,
0x0000002e55697212ULL, 0x0c0fe200078e3cffULL, 0x0000000855027824ULL, 0x000fe200078e00ffULL,
0xfffffff8036a7812ULL, 0x000fe200078ee26aULL, 0x0000001c00537836ULL, 0x000fe20000000000ULL,
0x0000002e54687212ULL, 0x0c0fe200078e3cffULL, 0x0000000854037824ULL, 0x000fe200078e00ffULL,
0xfffffff802697812ULL, 0x000fe200078ee269ULL, 0x0000002000527836ULL, 0x040fe20000000000ULL,
0x0000002e53677212ULL, 0x0c0fe200078e3cffULL, 0x0000000853027824ULL, 0x000fe200078e00ffULL,
0xfffffff803687812ULL, 0x000fe200078ee268ULL, 0x00000024005b7836ULL, 0x000fe20000000000ULL,
0x0000002e52667212ULL, 0x0c0fe200078e3cffULL, 0x0000000852037824ULL, 0x000fe200078e00ffULL,
0xfffffff802677812ULL, 0x000fe200078ee267ULL, 0x00000028005a7836ULL, 0x040fe20000000000ULL,
0x0000002e5b657212ULL, 0x0c0fe200078e3cffULL, 0x000000085b027824ULL, 0x000fe200078e00ffULL,
0xfffffff803667812ULL, 0x000fe200078ee266ULL, 0x0000002c006f7836ULL, 0x000fe20000000000ULL,
0x0000002e5a647212ULL, 0x0c0fe200078e3cffULL, 0x000000085a037824ULL, 0x000fe200078e00ffULL,
0xfffffff802657812ULL, 0x000fe200078ee265ULL, 0x000000086f027824ULL, 0x040fe200078e00ffULL,
0x0000002e6f637212ULL, 0x080fe200078e3cffULL, 0x00000012ff047e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff803647812ULL, 0x000fe200078ee264ULL, 0x00000013ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000002e00037212ULL, 0x000fe200078e3cffULL, 0x0000000806077c36ULL, 0x000fe20008000000ULL,
0xfffffff802637812ULL, 0x000fe200078ee263ULL, 0x0000600601007387ULL, 0x0003e20000100800ULL,
0x000000072e027812ULL, 0x000fe200078ec0ffULL, 0x0000400004107890ULL, 0x000fe2000fffe03fULL,
0x0000000900007c0cULL, 0x040fe2000bf26070ULL, 0x00000030005e7836ULL, 0x040fe20000000000ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x00000034005d7836ULL, 0x000fe20000000000ULL,
0x00000008022d7812ULL, 0x000fe200078efcffULL, 0x000000085e0b7824ULL, 0x000fe200078e00ffULL,
0x0ffffff8036b7812ULL, 0x000fe200078ef82eULL, 0x0000020007067825ULL, 0x002fe200078e0004ULL,
0x0000003f59117812ULL, 0x000fc400078ec0ffULL, 0x000000106b7a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000003c00707836ULL, 0x000fe20000000000ULL, 0x0000002e5e627212ULL, 0x080fe200078e3cffULL,
0x000000102d087825ULL, 0x000fe200078e0006ULL, 0x0000003f58107812ULL, 0x000fe200078ec0ffULL,
0x00006c1101007387ULL, 0x000fe20000100800ULL, 0x0000003f570d7812ULL, 0x000fe200078ec0ffULL,
0x000000085d0a7824ULL, 0x040fe200078e00ffULL, 0x0000002e5d617212ULL, 0x080fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000087a7faeULL, 0x0003e2000c901c54ULL,
0xfffffff80b627812ULL, 0x000fe200078ee262ULL, 0x00000008100b7c36ULL, 0x000fe20008000000ULL,
0x0000003f560f7812ULL, 0x000fe200078ec0ffULL, 0x00000008700c7824ULL, 0x000fe200078e00ffULL,
0x0000000959007c0cULL, 0x000fe2000bf26070ULL, 0x0000681001007387ULL, 0x000fe20000100800ULL,
0x0000000958007c0cULL, 0x000fe2000bf46070ULL, 0x00000038005c7836ULL, 0x000fe20000000000ULL,
0x0000002e705f7212ULL, 0x000fe200078e3cffULL, 0x0000640d01007387ULL, 0x0005e20000100800ULL,
0xfffffff80a617812ULL, 0x000fe200078ee261ULL, 0x0000000811097c36ULL, 0x002fe20008000000ULL,
0x0000003f550e7812ULL, 0x000fe200078ec0ffULL, 0x00005c0f01007387ULL, 0x0003e20000100800ULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000957007c0cULL, 0x000fc4000bf66070ULL,
0xfffffff80c5f7812ULL, 0x000fe200078ee25fULL, 0x0000020009087825ULL, 0x100fe200078e0004ULL,
0x0000000956007c0cULL, 0x000fe2000bf86070ULL, 0x0000580e01007387ULL, 0x0007e20000100800ULL,
0x0000002e5c607212ULL, 0x000fe200078e3cffULL, 0x000000080d0d7c36ULL, 0x004fe20008000000ULL,
0x000000106c7c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000080f0f7c36ULL, 0x002fe20008000000ULL,
0x000000106d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000085c037824ULL, 0x000fe200078e00ffULL,
0x0000000955007c0cULL, 0x000fe2000bfa6070ULL, 0x000000080e117c36ULL, 0x000fe20008000000ULL,
0x000000106e1c7c11ULL, 0x000fe2000f8e20ffULL, 0x000002000d0c7825ULL, 0x100fe200078e0004ULL,
0xfffffff803607812ULL, 0x000fe200078ee260ULL, 0x0000001d01007387ULL, 0x000fe20000100800ULL,
0x000000106a037c11ULL, 0x000fe2000f8e20ffULL, 0x000002000f0e7825ULL, 0x008fe200078e0004ULL,
0x00000010697d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000081c01007387ULL, 0x000fe20000100800ULL,
0x0000001068297c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d127825ULL, 0x000fe200078e0008ULL,
0x0000001067287c11ULL, 0x000fe2000f8e20ffULL, 0x0000040301007387ULL, 0x0003e20000100800ULL,
0x0000001066277c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d147825ULL, 0x000fe200078e000aULL,
0x0000001065267c11ULL, 0x000fe2000f8e20ffULL, 0x00000000127c7faeULL, 0x0005e2000c901c54ULL,
0x0000000954007c0cULL, 0x000fe2000bf26070ULL, 0x0000020011107825ULL, 0x000fe200078e0004ULL,
0x0000001063317c11ULL, 0x000fe2000f8e20ffULL, 0x00000000141d7faeULL, 0x0007e2000d101c54ULL,
0x0000000953007c0cULL, 0x000fe2000bf46070ULL, 0x000000102d167825ULL, 0x000fe200078e000cULL,
0x0000001062307c11ULL, 0x000fc4000f8e20ffULL, 0x00000010612f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102d187825ULL, 0x000fe200078e000eULL, 0x00000000161c7faeULL, 0x0009e2000d901c54ULL,
0x0000003f54137812ULL, 0x004fe400078ec0ffULL, 0x0000003f5b127812ULL, 0x000fe200078ec0ffULL,
0x000000102d1a7825ULL, 0x000fe200078e0010ULL, 0x0000003f53157812ULL, 0x008fe200078ec0ffULL,
0x0000000018037faeULL, 0x0003e2000e101c54ULL, 0x0000003f52147812ULL, 0x040fe400078ec0ffULL,
0x0000000952007c0cULL, 0x000fe2000bf66070ULL, 0x0000541301007387ULL, 0x0005e20000100800ULL,
0x000000095b007c0cULL, 0x000fe2000bf86070ULL, 0x0000000814177c36ULL, 0x010fe20008000000ULL,
0x000000105f7b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000501501007387ULL, 0x0007e40000100800ULL,
0x0000020017167825ULL, 0x000fe200078e0004ULL, 0x0000003f5a037812ULL, 0x002fe200078ec0ffULL,
0x00004c1401007387ULL, 0x0003e40000100800ULL, 0x0000000813137c36ULL, 0x004fc40008000000ULL,
0x0000000812197c36ULL, 0x000fe20008000000ULL, 0x0000481201007387ULL, 0x0005e20000100800ULL,
0x0000000815157c36ULL, 0x008fe40008000000ULL, 0x0000020019187825ULL, 0x100fe200078e0004ULL,
0x000000001a7d7faeULL, 0x0007e2000e901c54ULL, 0x000000095a007c0cULL, 0x000fe4000bfa6070ULL,
0x0000020015147825ULL, 0x102fe200078e0004ULL, 0x0000400301007387ULL, 0x0003e60000100800ULL,
0x0000020013127825ULL, 0x004fe200078e0004ULL, 0x0000142901007387ULL, 0x000fe60000100800ULL,
0x000000102d1e7825ULL, 0x000fe200078e0014ULL, 0x0000102801007387ULL, 0x0005e60000100800ULL,
0x00000008031b7c36ULL, 0x008fe20008000000ULL, 0x0000001064037c11ULL, 0x002fe2000f8e20ffULL,
0x000000102d1c7825ULL, 0x000fe200078e0012ULL, 0x00001c2701007387ULL, 0x000fe60000100800ULL,
0x000002001b1a7825ULL, 0x000fe200078e0004ULL, 0x000000001c297faeULL, 0x0003e2000c901c54ULL,
0x000000096f007c0cULL, 0x000fc4000bf26070ULL, 0x000000102d207825ULL, 0x040fe200078e0016ULL,
0x000000001e287faeULL, 0x0007e2000d101c54ULL, 0x000000095e007c0cULL, 0x000fe4000bf46070ULL,
0x000000102d227825ULL, 0x000fe200078e0018ULL, 0x0000000020277faeULL, 0x0009e2000d901c54ULL,
0x000000095d007c0cULL, 0x000fe4000bf66070ULL, 0x000000102d247825ULL, 0x000fe200078e001aULL,
0x0000003f6f1d7812ULL, 0x002fe200078ec0ffULL, 0x00002c2601007387ULL, 0x000fe20000100800ULL,
0x0000003f5c1c7812ULL, 0x000fc400078ec0ffULL, 0x0000003f5e1f7812ULL, 0x008fe200078ec0ffULL,
0x0000000022267faeULL, 0x0003e2000e101c54ULL, 0x0000003f5d1e7812ULL, 0x000fe400078ec0ffULL,
0x000000095c007c0cULL, 0x000fe2000bf86070ULL, 0x0000280301007387ULL, 0x0007e40000100800ULL,
0x000000081e217c36ULL, 0x010fe40008000000ULL, 0x0000000024037faeULL, 0x0007e2000e901c54ULL,
0x0000000970007c0cULL, 0x000fe2000bfa6070ULL, 0x0000020021207825ULL, 0x000fc400078e0004ULL,
0x0000841d01007387ULL, 0x0009e40000100800ULL, 0x000000081c237c36ULL, 0x002fe40008000000ULL,
0x0000801f01007387ULL, 0x0003e20000100800ULL, 0x000000102d287825ULL, 0x004fe200078e0020ULL,
0x0000003f70037812ULL, 0x008fe400078ec0ffULL, 0x0000781e01007387ULL, 0x0005e20000100800ULL,
0x000000081d1d7c36ULL, 0x010fe40008000000ULL, 0x0000020023227825ULL, 0x000fe200078e0004ULL,
0x0000741c01007387ULL, 0x0007e60000100800ULL, 0x000000081f1f7c36ULL, 0x002fe20008000000ULL,
0x0000700301007387ULL, 0x0003e20000100800ULL, 0x0000000803517c36ULL, 0x000fc40008000000ULL,
0x000002001f1e7825ULL, 0x104fe200078e0004ULL, 0x0000243101007387ULL, 0x0005e60000100800ULL,
0x000002001d1c7825ULL, 0x108fe200078e0004ULL, 0x0000203001007387ULL, 0x0005e20000100800ULL,
0x0000001060037c11ULL, 0x002fe4000f8e20ffULL, 0x0000020051507825ULL, 0x000fe200078e0004ULL,
0x0000182f01007387ULL, 0x0005e60000100800ULL, 0x000000102d247825ULL, 0x040fe200078e001cULL,
0x00000c0301007387ULL, 0x0005e60000100800ULL, 0x000000102d267825ULL, 0x040fe200078e001eULL,
0x0000000024317faeULL, 0x0005e6000c901c54ULL, 0x000000102d2a7825ULL, 0x040fe200078e0022ULL,
0x0000000026307faeULL, 0x0005e6000d101c54ULL, 0x000000102d2c7825ULL, 0x000fe200078e0050ULL,
0x00000000282f7faeULL, 0x0005e8000d901c54ULL, 0x000000002a037faeULL, 0x0005e8000e101c54ULL,
0x000000002c7b7faeULL, 0x0005e2000e901c54ULL, 0x0000000c00147947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x004fe2000001162eULL, 0x000000080c0872a4ULL, 0x000fe4000f8e020dULL,
0x0000000e16047291ULL, 0x000fe2000f8e703fULL, 0x0000003f00077812ULL, 0x042fe200078ec0ffULL,
0x0000000c00577836ULL, 0x040fe40000000000ULL, 0x0000000400597836ULL, 0x040fe20000000000ULL,
0x0000400004107890ULL, 0x000fe2000fffe03fULL, 0x0000000857057824ULL, 0x040fe200078e00ffULL,
0x0000002e576e7212ULL, 0x080fe200078e3cffULL, 0x0000001800547836ULL, 0x040fe20000000000ULL,
0x0000002e596c7212ULL, 0x0c0fe200078e3cffULL, 0x00000024005b7836ULL, 0x000fe20000000000ULL,
0xfffffff8056e7812ULL, 0x000fe200078ee26eULL, 0x0000000859037824ULL, 0x000fe200078e00ffULL,
0x0000002e54687212ULL, 0x0c0fe200078e3cffULL, 0x0000000854057824ULL, 0x000fe200078e00ffULL,
0x0000002e5b657212ULL, 0x0c0fe200078e3cffULL, 0x000000085b047824ULL, 0x000fe200078e00ffULL,
0xfffffff8036c7812ULL, 0x000fe200078ee26cULL, 0x0000001000567836ULL, 0x040fe20000000000ULL,
0xfffffff805687812ULL, 0x000fe200078ee268ULL, 0x0000000800587836ULL, 0x000fe20000000000ULL,
0xfffffff804657812ULL, 0x000fe200078ee265ULL, 0x0000000856037824ULL, 0x040fe200078e00ffULL,
0x0000002e566a7212ULL, 0x080fe200078e3cffULL, 0x00008a00ff047b82ULL, 0x000e620000000a00ULL,
0x0000002000527836ULL, 0x000fe20000000000ULL, 0x0000002e586d7212ULL, 0x0c0fe200078e3cffULL,
0x0000000858027824ULL, 0x000fe200078e00ffULL, 0xfffffff8036a7812ULL, 0x000fe200078ee26aULL,
0x0000001400557836ULL, 0x000fe20000000000ULL, 0x0000002e52667212ULL, 0x0c0fe200078e3cffULL,
0x0000000852037824ULL, 0x000fe200078e00ffULL, 0xfffffff8026d7812ULL, 0x000fe200078ee26dULL,
0x00000028005a7836ULL, 0x040fe20000000000ULL, 0x0000002e55697212ULL, 0x0c0fe200078e3cffULL,
0x0000000855027824ULL, 0x000fe200078e00ffULL, 0xfffffff803667812ULL, 0x000fe200078ee266ULL,
0x0000001c00537836ULL, 0x000fe20000000000ULL, 0x0000002e5a647212ULL, 0x0c0fe200078e3cffULL,
0x000000085a037824ULL, 0x000fe200078e00ffULL, 0xfffffff802697812ULL, 0x000fe200078ee269ULL,
0x0000002c006f7836ULL, 0x040fe20000000000ULL, 0x0000002e53677212ULL, 0x0c0fe200078e3cffULL,
0x0000000853027824ULL, 0x000fe200078e00ffULL, 0xfffffff803647812ULL, 0x000fe200078ee264ULL,
0x000000086f067824ULL, 0x040fe200078e00ffULL, 0x0000002e00037212ULL, 0x0c0fe200078e3cffULL,
0x0000600701007387ULL, 0x0005e20000100800ULL, 0x0000002e6f637212ULL, 0x080fe200078e3cffULL,
0x00000038005c7836ULL, 0x040fe20000000000ULL, 0xfffffff802677812ULL, 0x000fe200078ee267ULL,
0x00000030005e7836ULL, 0x000fe20000000000ULL, 0x000000072e027812ULL, 0x000fe200078ec0ffULL,
0x00000034005d7836ULL, 0x000fe20000000000ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x000000085e0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff806637812ULL, 0x000fe200078ee263ULL,
0x0000000807077c36ULL, 0x004fe20008000000ULL, 0x00000008022d7812ULL, 0x000fe200078efcffULL,
0x000000085d0a7824ULL, 0x000fe200078e00ffULL, 0x0ffffff8036b7812ULL, 0x000fe200078ef82eULL,
0x0000020007067825ULL, 0x002fe200078e0004ULL, 0x0000002e5c607212ULL, 0x000fc400078e3cffULL,
0x0000003f59117812ULL, 0x000fe200078ec0ffULL, 0x000000085c037824ULL, 0x000fe200078e00ffULL,
0x0000002e5e627212ULL, 0x080fe200078e3cffULL, 0x000000102d087825ULL, 0x000fe200078e0006ULL,
0x0000003f58107812ULL, 0x000fe200078ec0ffULL, 0x00006c1101007387ULL, 0x000fe20000100800ULL,
0x000000106b7a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000003c00707836ULL, 0x000fe20000000000ULL,
0xfffffff803607812ULL, 0x000fe200078ee260ULL, 0x0000000811037c36ULL, 0x000fe20008000000ULL,
0x0000002e5d617212ULL, 0x080fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000087a7faeULL, 0x0003e2000b901c54ULL, 0xfffffff80b627812ULL, 0x000fe200078ee262ULL,
0x00000008100b7c36ULL, 0x000fe20008000000ULL, 0x0000003f570d7812ULL, 0x000fe200078ec0ffULL,
0x00000008700c7824ULL, 0x040fe200078e00ffULL, 0xfffffff80a617812ULL, 0x000fe200078ee261ULL,
0x0000681001007387ULL, 0x000fe20000100800ULL, 0x000002000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000002e705f7212ULL, 0x000fc400078e3cffULL, 0x0000640d01007387ULL, 0x0005e20000100800ULL,
0x0000003f560f7812ULL, 0x000fe200078ec0ffULL, 0x0000020003087825ULL, 0x002fe200078e0004ULL,
0xfffffff80c5f7812ULL, 0x000fe400078ee25fULL, 0x000000106c7c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102d147825ULL, 0x000fe200078e000aULL, 0x000000106d1e7c11ULL, 0x000fe2000f8e20ffULL,
0x00005c0f01007387ULL, 0x0003e20000100800ULL, 0x0000003f550e7812ULL, 0x000fe200078ec0ffULL,
0x000000080d0d7c36ULL, 0x004fe20008000000ULL, 0x000000106e1d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102d127825ULL, 0x000fe200078e0008ULL, 0x000000106a1c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000580e01007387ULL, 0x0005e20000100800ULL, 0x0000003f54037812ULL, 0x000fe200078ec0ffULL,
0x000002000d0c7825ULL, 0x000fe200078e0004ULL, 0x00000010697d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000127c7faeULL, 0x0007e2000b901c54ULL, 0x00000010682a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000080f0f7c36ULL, 0x002fe20008000000ULL, 0x0000001067297c11ULL, 0x000fe2000f8e20ffULL,
0x00000000141e7faeULL, 0x0003e2000b901c54ULL, 0x000000102d167825ULL, 0x000fe200078e000cULL,
0x0000001066287c11ULL, 0x000fc4000f8e20ffULL, 0x0000001e01007387ULL, 0x000fe20000100800ULL,
0x000000080e117c36ULL, 0x000fe20008000000ULL, 0x0000001065277c11ULL, 0x000fe2000f8e20ffULL,
0x000002000f0e7825ULL, 0x104fe200078e0004ULL, 0x0000081d01007387ULL, 0x000fe20000100800ULL,
0x0000003f5b137812ULL, 0x008fe400078ec0ffULL, 0x0000003f5a127812ULL, 0x000fe200078ec0ffULL,
0x0000041c01007387ULL, 0x000fe20000100800ULL, 0x0000003f53157812ULL, 0x002fe200078ec0ffULL,
0x0000020011107825ULL, 0x000fe200078e0004ULL, 0x0000003f52147812ULL, 0x000fe200078ec0ffULL,
0x0000540301007387ULL, 0x0003e20000100800ULL, 0x0000001064267c11ULL, 0x000fe2000f8e20ffULL,
0x0000000813217c36ULL, 0x000fe20008000000ULL, 0x0000001063327c11ULL, 0x000fe2000f8e20ffULL,
0x00000000161d7faeULL, 0x0005e2000b901c54ULL, 0x0000000812237c36ULL, 0x000fe20008000000ULL,
0x0000001062317c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d187825ULL, 0x000fe200078e000eULL,
0x0000501501007387ULL, 0x000fe20000100800ULL, 0x0000001061307c11ULL, 0x000fc4000f8e20ffULL,
0x0000000803037c36ULL, 0x002fe20008000000ULL, 0x00004c1401007387ULL, 0x0003e20000100800ULL,
0x00000008141f7c36ULL, 0x000fe20008000000ULL, 0x00000010602f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102d1a7825ULL, 0x000fe200078e0010ULL, 0x0000481301007387ULL, 0x000fe20000100800ULL,
0x000000105f7b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000008151d7c36ULL, 0x004fe20008000000ULL,
0x0000401201007387ULL, 0x0005e20000100800ULL, 0x000002001f167825ULL, 0x000fc600078e0004ULL,
0x00000000181c7faeULL, 0x0007e2000b901c54ULL, 0x000002001d147825ULL, 0x002fc600078e0004ULL,
0x000000001a7d7faeULL, 0x0003e2000b901c54ULL, 0x0000020003127825ULL, 0x004fe200078e0004ULL,
0x0000003f6f037812ULL, 0x000fe400078ec0ffULL, 0x0000142a01007387ULL, 0x000fe20000100800ULL,
0x000000102d1e7825ULL, 0x000fc600078e0014ULL, 0x0000102901007387ULL, 0x0005e20000100800ULL,
0x000000102d1c7825ULL, 0x008fc600078e0012ULL, 0x00001c2801007387ULL, 0x000fe20000100800ULL,
0x0000020021187825ULL, 0x000fc600078e0004ULL, 0x000000001c2a7faeULL, 0x0007e2000b901c54ULL,
0x00000200231a7825ULL, 0x002fc600078e0004ULL, 0x000000001e297faeULL, 0x0003e2000b901c54ULL,
0x000000102d207825ULL, 0x000fc600078e0016ULL, 0x00002c2701007387ULL, 0x000fe20000100800ULL,
0x000000102d227825ULL, 0x040fe200078e0018ULL, 0x0000003f5c1d7812ULL, 0x008fe400078ec0ffULL,
0x0000282601007387ULL, 0x000fe20000100800ULL, 0x0000003f701c7812ULL, 0x000fe200078ec0ffULL,
0x000000102d247825ULL, 0x000fe200078e001aULL, 0x0000003f5e1f7812ULL, 0x002fe200078ec0ffULL,
0x0000000020287faeULL, 0x0003e2000b901c54ULL, 0x0000003f5d1e7812ULL, 0x000fe200078ec0ffULL,
0x000000081d2b7c36ULL, 0x000fc40008000000ULL, 0x0000840301007387ULL, 0x0007e20000100800ULL,
0x000000081c517c36ULL, 0x000fe40008000000ULL, 0x000000081e297c36ULL, 0x004fe20008000000ULL,
0x0000000022277faeULL, 0x0005e2000b901c54ULL, 0x0000020051507825ULL, 0x000fc600078e0004ULL,
0x0000801f01007387ULL, 0x000fe20000100800ULL, 0x0000020029207825ULL, 0x002fc600078e0004ULL,
0x0000781e01007387ULL, 0x0003e20000100800ULL, 0x0000000803037c36ULL, 0x008fe40008000000ULL,
0x000000102d287825ULL, 0x000fe200078e0020ULL, 0x0000741d01007387ULL, 0x000fe60000100800ULL,
0x000000081f277c36ULL, 0x004fe20008000000ULL, 0x0000701c01007387ULL, 0x0005e20000100800ULL,
0x000002002b227825ULL, 0x000fc600078e0004ULL, 0x0000000024267faeULL, 0x0007e2000b901c54ULL,
0x00000200271e7825ULL, 0x002fc600078e0004ULL, 0x0000243201007387ULL, 0x0003e20000100800ULL,
0x000000102d2a7825ULL, 0x000fc600078e0022ULL, 0x0000203101007387ULL, 0x0003e20000100800ULL,
0x00000200031c7825ULL, 0x004fc600078e0004ULL, 0x0000183001007387ULL, 0x0003e20000100800ULL,
0x000000102d267825ULL, 0x008fc600078e001eULL, 0x00000c2f01007387ULL, 0x0003e20000100800ULL,
0x000000102d247825ULL, 0x000fc800078e001cULL, 0x000000102d2c7825ULL, 0x000fe200078e0050ULL,
0x0000000024327faeULL, 0x0003e8000b901c54ULL, 0x0000000026317faeULL, 0x0003e8000b901c54ULL,
0x0000000028307faeULL, 0x0003e8000b901c54ULL, 0x000000002a2f7faeULL, 0x0003e8000b901c54ULL,
0x000000002c7b7faeULL, 0x0003e4000b901c54ULL, 0x00000004ff257819ULL, 0x006fe2000001162eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000200004047890ULL, 0x000fe2000fffe03fULL,
0x0000000100797812ULL, 0x000fe400078ec0ffULL, 0x0000000825037824ULL, 0x040fe400078e00ffULL,
0x0000000225287836ULL, 0x000fc60000000000ULL, 0xfffffff803787812ULL, 0x000fe400078ee202ULL,
0x0000000802037812ULL, 0x000fe400078ef82eULL, 0x0000000778767812ULL, 0x040fe200078ec0ffULL,
0x0000001078747836ULL, 0x040fe20000000000ULL, 0x0000000725247812ULL, 0x000fe200078e7803ULL,
0x0000000878757824ULL, 0x040fe200078e00ffULL, 0x0000000176267812ULL, 0x000fe200078e7800ULL,
0x0000002078777836ULL, 0x000fe20000000000ULL, 0x0000000774737812ULL, 0x000fe200078ec0ffULL,
0x0000002003247824ULL, 0x000fe200078e0224ULL, 0x0000007526267212ULL, 0x000fe200078efcffULL,
0x0000000874747824ULL, 0x000fe200078e00ffULL, 0x0000000173257812ULL, 0x000fe200078e7800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000e24247c11ULL, 0x000fe2000f8e20ffULL,
0x0000302601007387ULL, 0x0003e20000100800ULL, 0x0000007425257212ULL, 0x000fe200078efcffULL,
0x0000003078787836ULL, 0x000fe20000000000ULL, 0x0000000426277c11ULL, 0x000fe2000f8e20ffULL,
0x000000002440783bULL, 0x0005e20000000200ULL, 0x0000000777727812ULL, 0x040fe200078ec0ffULL,
0x0000000877777824ULL, 0x000fe200078e00ffULL, 0x0000000778717812ULL, 0x040fe200078ec0ffULL,
0x00009c2701007387ULL, 0x000fe20000100800ULL, 0x0000000878787824ULL, 0x000fe200078e00ffULL,
0x0000000172267812ULL, 0x002fc400078e7800ULL, 0x0000000425247c11ULL, 0x004fe2000f8e20ffULL,
0x0000342501007387ULL, 0x0003e20000100800ULL, 0x0000000728287812ULL, 0x000fe400078e7803ULL,
0x0000007726297212ULL, 0x000fe200078efcffULL, 0x000000002444783bULL, 0x000fe40000000200ULL,
0x0000002003287824ULL, 0x000fe200078e0228ULL, 0x0000000429267c11ULL, 0x000fe2000f8e20ffULL,
0x0000b02401007387ULL, 0x0005e20000100800ULL, 0x0000000171257812ULL, 0x002fc600078e7800ULL,
0x000000002734783bULL, 0x0002e20000000200ULL, 0x0000000e28287c11ULL, 0x000fe4000f8e20ffULL,
0x00000078252c7212ULL, 0x000fe200078efcffULL, 0x000000002638783bULL, 0x000fe20000000200ULL,
0x0000000276247812ULL, 0x004fe400078e1e79ULL, 0x000000042c257c11ULL, 0x000fe4000f8e20ffULL,
0x0000007524277212ULL, 0x002fe400078efcffULL, 0x0000000273247812ULL, 0x000fe200078e1e79ULL,
0x00000000254c783bULL, 0x000e660000000200ULL, 0x0000007424247212ULL, 0x000fe200078efcffULL,
0x0000882701007387ULL, 0x0005e80000100800ULL, 0x0000382901007387ULL, 0x000fe80000100800ULL,
0x0000442c01007387ULL, 0x0007e20000100800ULL, 0x0000000427277c11ULL, 0x004fc6000f8e20ffULL,
0x000000002828783bULL, 0x000fe80000000200ULL, 0x0000d42701007387ULL, 0x000fe80000100800ULL,
0x00008c2401007387ULL, 0x0005e20000100800ULL, 0x00000034402c723cULL, 0x008fe600000418ffULL,
0x0000b42601007387ULL, 0x000fe80000100800ULL, 0x0000c42501007387ULL, 0x000fe20000100800ULL,
0x000000364034723cULL, 0x000fe200000418ffULL, 0x0000000424247c11ULL, 0x004fc4000f8e20ffULL,
0x000000002730783bULL, 0x000ea80000000200ULL, 0x000000002448783bULL, 0x000ee20000000200ULL,
0x0000004c403c723cULL, 0x002fe600000418ffULL, 0x0000d82401007387ULL, 0x0003e60000100800ULL,
0x000000444024723cULL, 0x002fec00000418ffULL, 0x000000464044723cULL, 0x000fec00000418ffULL,
0x00000030282c723cULL, 0x004fd8000004182cULL, 0x000000482824723cULL, 0x008fec0000041824ULL,
0x0000004a2848723cULL, 0x000fec0000041844ULL, 0x000000322830723cULL, 0x000fe20000041834ULL,
0x0000000272447812ULL, 0x000fc400078e1e79ULL, 0x0000000271457812ULL, 0x000fe400078e1e79ULL,
0x00000077444c7212ULL, 0x000fe200078efcffULL, 0x000000384034723cULL, 0x000fe200000418ffULL,
0x00000078454d7212ULL, 0x000fe400078efcffULL, 0x000000044c467c11ULL, 0x000fe2000f8e20ffULL,
0x00003c4c01007387ULL, 0x0003e40000100800ULL, 0x0000003a4038723cULL, 0x000fe400000418ffULL,
0x00007c4d01007387ULL, 0x000fe80000100800ULL, 0x0000bc4601007387ULL, 0x000fe20000100800ULL,
0x0000004e4040723cULL, 0x000fe200000418ffULL, 0x000000044d4c7c11ULL, 0x002fc4000f8e20ffULL,
0x000000004644783bULL, 0x000e680000000200ULL, 0x0000cc4c01007387ULL, 0x000fe80000100800ULL,
0x000000004c4c783bULL, 0x000ea20000000200ULL, 0x000000442834723cULL, 0x002fe20000041834ULL,
0x0000000000457919ULL, 0x000e6a0000000000ULL, 0x000000462838723cULL, 0x000fec0000041838ULL,
0x0000004c283c723cULL, 0x004fec000004183cULL, 0x0000004e2840723cULL, 0x000fe20000041840ULL,
0x00000004724d7812ULL, 0x000fc400078e1e79ULL, 0x00000004714c7812ULL, 0x000fe400078e1e79ULL,
0x000000774d4d7212ULL, 0x000fe400078efcffULL, 0x0000000476287812ULL, 0x000fe400078e1e79ULL,
0x0000000676767812ULL, 0x000fe400078e1e79ULL, 0x00000075284f7212ULL, 0x080fe400078efcffULL,
0x0000007576767212ULL, 0x000fc400078efcffULL, 0x00000004ff457819ULL, 0x002fe40000011645ULL,
0x000000044f2a7c11ULL, 0x000fe4000f8e20ffULL, 0x000000044d757c11ULL, 0x000fe2000f8e20ffULL,
0x0000000445297836ULL, 0x000fe20000000000ULL, 0x000000784c4c7212ULL, 0x000fe200078efcffULL,
0x0000b82a01007387ULL, 0x000fe20000100800ULL, 0x0000000672727812ULL, 0x000fe400078e1e79ULL,
0x0000000729297812ULL, 0x000fc400078e7803ULL, 0x0000007772727212ULL, 0x000fe400078efcffULL,
0x0000000671717812ULL, 0x000fe200078e1e79ULL, 0x0000002003297824ULL, 0x000fc600078e0229ULL,
0x0000007871717212ULL, 0x000fe400078efcffULL, 0x0000000e29297c11ULL, 0x000fca000f8e20ffULL,
0x000000002944783bULL, 0x000fe80000000200ULL, 0x000000002a28783bULL, 0x000e640000000200ULL,
0x00000028442c723cULL, 0x002fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x0000000473287812ULL, 0x000fc400078e1e79ULL, 0x0000000673737812ULL, 0x000fe400078e1e79ULL,
0x00000074284e7212ULL, 0x080fe400078efcffULL, 0x0000007473737212ULL, 0x000fe400078efcffULL,
0x000000044e297c11ULL, 0x000fe4000f8e20ffULL, 0x000000044c747c11ULL, 0x000fe4000f8e20ffULL,
0x0000000471797c11ULL, 0x000fe2000f8e20ffULL, 0x0000ac2901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e680000000200ULL, 0x0000a47501007387ULL, 0x000fe80000100800ULL,
0x0000a87401007387ULL, 0x000fe20000100800ULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007528783bULL, 0x0002a40000000200ULL,
0x0000000000757919ULL, 0x002e660000000000ULL, 0x000000284434723cULL, 0x004fe20000041834ULL,
0x00000004ff757819ULL, 0x002fca0000011675ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x000000007428783bULL, 0x0002a40000000200ULL, 0x0000000476747c11ULL, 0x002fca000f8e20ffULL,
0x0000987401007387ULL, 0x000fe20000100800ULL, 0x00000028443c723cULL, 0x004fec000004183cULL,
0x0000002a4440723cULL, 0x000fe20000041840ULL, 0x0000000675287836ULL, 0x000fca0000000000ULL,
0x0000000728287812ULL, 0x000fca00078e7803ULL, 0x0000002003287824ULL, 0x000fca00078e0228ULL,
0x0000000e28287c11ULL, 0x000fca000f8e20ffULL, 0x000000002844783bULL, 0x000fe80000000200ULL,
0x000000007428783bULL, 0x0002a40000000200ULL, 0x0000000473747c11ULL, 0x002fca000f8e20ffULL,
0x0000a07401007387ULL, 0x000fe20000100800ULL, 0x00000028442c723cULL, 0x004fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000007428783bULL, 0x0002a40000000200ULL,
0x0000000472747c11ULL, 0x002fca000f8e20ffULL, 0x0000947401007387ULL, 0x000fe20000100800ULL,
0x000000284424723cULL, 0x004fec0000041824ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x000000007428783bULL, 0x000e6a0000000200ULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000007928783bULL, 0x000e6a0000000200ULL,
0x00000028443c723cULL, 0x002fec000004183cULL, 0x0000002a4440723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000400188947ULL, 0x000fde0003800000ULL,
0x8000000b18087290ULL, 0x000fe2000fffe03fULL, 0x00000010022a7812ULL, 0x000fe400078efcffULL,
0x000000046b6b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000046c6c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x000fe200078e0006ULL, 0x0000000800007c0cULL, 0x000fe4000bf26070ULL,
0x000000046d6d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000046e6e7c11ULL, 0x000fc4000f8e20ffULL,
0x000000046a6a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000469697c11ULL, 0x000fe4000f8e20ffULL,
0x0000000468687c11ULL, 0x000fe4000f8e20ffULL, 0x0000000467677c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000286b7faeULL, 0x0003e2000c901c54ULL,
0x0000000859007c0cULL, 0x000fe4000bf26070ULL, 0x0000000466667c11ULL, 0x000fc4000f8e20ffULL,
0x0000000465657c11ULL, 0x000fe4000f8e20ffULL, 0x0000000464647c11ULL, 0x000fe4000f8e20ffULL,
0x0000000463637c11ULL, 0x000fe4000f8e20ffULL, 0x0000000462627c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x002fe200078e0008ULL, 0x0000000461617c11ULL, 0x000fe4000f8e20ffULL,
0x0000000460607c11ULL, 0x000fc4000f8e20ffULL, 0x00000000286c7faeULL, 0x0003e2000c901c54ULL,
0x0000000858007c0cULL, 0x000fe4000bf26070ULL, 0x000000045f5f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x002fd400078e000aULL, 0x00000000286d7faeULL, 0x0003e2000c901c54ULL,
0x0000000857007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e000cULL,
0x00000000286e7faeULL, 0x0003e2000c901c54ULL, 0x0000000856007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e000eULL, 0x00000000286a7faeULL, 0x0003e2000c901c54ULL,
0x0000000855007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0010ULL,
0x0000000028697faeULL, 0x0003e2000c901c54ULL, 0x0000000854007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0012ULL, 0x0000000028687faeULL, 0x0003e2000c901c54ULL,
0x0000000853007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0014ULL,
0x0000000028677faeULL, 0x0003e2000c901c54ULL, 0x0000000852007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0016ULL, 0x0000000028667faeULL, 0x0003e2000c901c54ULL,
0x000000085b007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0018ULL,
0x0000000028657faeULL, 0x0003e2000c901c54ULL, 0x000000085a007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e001aULL, 0x0000000028647faeULL, 0x0003e2000c901c54ULL,
0x000000086f007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e001cULL,
0x0000000028637faeULL, 0x0003e2000c901c54ULL, 0x000000085e007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e001eULL, 0x0000000028627faeULL, 0x0003e2000c901c54ULL,
0x000000085d007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0020ULL,
0x0000000028617faeULL, 0x0003e2000c901c54ULL, 0x000000085c007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fc800078e0022ULL, 0x000000102a2a7825ULL, 0x000fd000078e0050ULL,
0x0000000028607faeULL, 0x0003e2000c901c54ULL, 0x0000000870007c0cULL, 0x000fda000bf26070ULL,
0x000000002a5f7faeULL, 0x0003e2000c901c54ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x00000010022a7812ULL, 0x000fe400078efcffULL, 0x000000046b6b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000046c6c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x000fe200078e0006ULL,
0x000000046d6d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000046e6e7c11ULL, 0x000fe4000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000286b7faeULL, 0x0003e2000b901c54ULL,
0x000000046a6a7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000469697c11ULL, 0x000fe4000f8e20ffULL,
0x0000000468687c11ULL, 0x000fe4000f8e20ffULL, 0x0000000467677c11ULL, 0x000fe4000f8e20ffULL,
0x0000000466667c11ULL, 0x000fe4000f8e20ffULL, 0x0000000465657c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x002fe200078e0008ULL, 0x0000000464647c11ULL, 0x000fc4000f8e20ffULL,
0x0000000463637c11ULL, 0x000fe4000f8e20ffULL, 0x00000000286c7faeULL, 0x0003e2000b901c54ULL,
0x0000000462627c11ULL, 0x000fe4000f8e20ffULL, 0x0000000461617c11ULL, 0x000fe4000f8e20ffULL,
0x0000000460607c11ULL, 0x000fe4000f8e20ffULL, 0x000000045f5f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x002fca00078e000aULL, 0x00000000286d7faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e000cULL, 0x00000000286e7faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e000eULL, 0x00000000286a7faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e0010ULL, 0x0000000028697faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e0012ULL, 0x0000000028687faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e0014ULL, 0x0000000028677faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e0016ULL, 0x0000000028667faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e0018ULL, 0x0000000028657faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e001aULL, 0x0000000028647faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e001cULL, 0x0000000028637faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e001eULL, 0x0000000028627faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fca00078e0020ULL, 0x0000000028617faeULL, 0x0003e4000b901c54ULL,
0x000000102a287825ULL, 0x002fc800078e0022ULL, 0x000000102a2a7825ULL, 0x000fe200078e0050ULL,
0x0000000028607faeULL, 0x0003e8000b901c54ULL, 0x000000002a5f7faeULL, 0x0003e4000b901c54ULL,
0x0000300001297983ULL, 0x002ea80000300800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000875287836ULL, 0x000fc60000000000ULL, 0x00008c0001787983ULL, 0x000ee40000300800ULL,
0x0000000728287812ULL, 0x000fe400078e7803ULL, 0x00003c0001777983ULL, 0x000f260000300800ULL,
0x0000002003287824ULL, 0x000fca00078e0228ULL, 0x0000000e28287c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002844783bULL, 0x000fe20000000200ULL,
0x0000001029297c11ULL, 0x004fca000f8e20ffULL, 0x0000d02901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e680000000200ULL, 0x00007c0001747983ULL, 0x000ea20000300800ULL,
0x00000028442c723cULL, 0x002fe6000004182cULL, 0x0000340001297983ULL, 0x000f660000300800ULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x0000001029297c11ULL, 0x020fca000f8e20ffULL,
0x0000c82901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x000000284424723cULL, 0x002fe40000041824ULL, 0x0000380001297983ULL, 0x000f680000300800ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x0000001029297c11ULL, 0x020fca000f8e20ffULL,
0x0000c02901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x000000284434723cULL, 0x002fe40000041834ULL, 0x0000440001297983ULL, 0x000f680000300800ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x0000001029297c11ULL, 0x020fca000f8e20ffULL,
0x0000382901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x00000028443c723cULL, 0x002fe4000004183cULL, 0x0000880001297983ULL, 0x000f6a0000300800ULL,
0x0000000a75287836ULL, 0x000fca0000000000ULL, 0x0000000728287812ULL, 0x000fca00078e7803ULL,
0x0000002003287824ULL, 0x000fe200078e0228ULL, 0x0000002a4440723cULL, 0x000fe80000041840ULL,
0x0000000e28287c11ULL, 0x000fca000f8e20ffULL, 0x000000002844783bULL, 0x000fe20000000200ULL,
0x0000001078787c11ULL, 0x008fe4000f8e20ffULL, 0x0000001029297c11ULL, 0x020fca000f8e20ffULL,
0x0000342901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e680000000200ULL,
0x0000307801007387ULL, 0x000fe20000100800ULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000007828783bULL, 0x0008640000000200ULL,
0x0000001077787c11ULL, 0x010fc6000f8e20ffULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007828783bULL, 0x000e620000000200ULL,
0x0000001074777c11ULL, 0x004fc8000f8e20ffULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000007728783bULL, 0x000e6a0000000200ULL,
0x00000028443c723cULL, 0x002fee000004183cULL, 0x0000000c75287836ULL, 0x000fca0000000000ULL,
0x0000000728287812ULL, 0x000fca00078e7803ULL, 0x0000002003287824ULL, 0x000fe200078e0228ULL,
0x000000104f757c11ULL, 0x000fc8000f8e20ffULL, 0x0000000e28287c11ULL, 0x000fe2000f8e20ffULL,
0x0000002a4440723cULL, 0x000fe80000041840ULL, 0x000000002844783bULL, 0x000fe80000000200ULL,
0x000000007528783bULL, 0x000e620000000200ULL, 0x000000104e747c11ULL, 0x000fc4000f8e20ffULL,
0x000000104d4f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000007428783bULL, 0x000e620000000200ULL,
0x000000104c4e7c11ULL, 0x000fc8000f8e20ffULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000004f28783bULL, 0x000e620000000200ULL,
0x00000000004d7919ULL, 0x000ea80000000000ULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000004e28783bULL, 0x000e620000000200ULL,
0x00000004ff4d7819ULL, 0x004fc4000001164dULL, 0x00000010714c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000180001717983ULL, 0x0005620000100800ULL, 0x00000028443c723cULL, 0x002fee000004183cULL,
0x0000000e4d287836ULL, 0x000fe20000000000ULL, 0x00000010724d7c11ULL, 0x000fc4000f8e20ffULL,
0x00000c0001727983ULL, 0x0005640000100800ULL, 0x0000000728287812ULL, 0x000fca00078e7803ULL,
0x0000002003287824ULL, 0x000fe200078e0228ULL, 0x0000001076767c11ULL, 0x000fc8000f8e20ffULL,
0x0000000e28287c11ULL, 0x000fe2000f8e20ffULL, 0x0000002a4440723cULL, 0x000fe80000041840ULL,
0x000000002844783bULL, 0x000fe80000000200ULL, 0x000000007628783bULL, 0x000e620000000200ULL,
0x0000001073737c11ULL, 0x000fe2000f8e20ffULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000007328783bULL, 0x000e6a0000000200ULL,
0x000000284424723cULL, 0x002fec0000041824ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x000000004d28783bULL, 0x000e6a0000000200ULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000004c28783bULL, 0x000e6a0000000200ULL,
0x00000028443c723cULL, 0x002fec000004183cULL, 0x0000002a4440723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000400008947ULL, 0x004fde0003800000ULL,
0x00000000012a7983ULL, 0x000ea80000300800ULL, 0x00000800012b7983ULL, 0x000ee20000300800ULL,
0x8000000b18047290ULL, 0x000fe2000fffe03fULL, 0x0000001802287812ULL, 0x000fe400078efcffULL,
0x0000140001447983ULL, 0x000f260000300800ULL, 0x0000000400007c0cULL, 0x000fe2000bf06070ULL,
0x0000001028067825ULL, 0x040fe200078e0006ULL, 0x0000100001457983ULL, 0x000f280000300800ULL,
0x00001c0001297983ULL, 0x000f2e0000300800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000067a7faeULL, 0x000fe2000c101c54ULL, 0x0000000459007c0cULL, 0x000fe2000bf06070ULL,
0x0000001028087825ULL, 0x000fc400078e0008ULL, 0x0000040001077983ULL, 0x000f220000300800ULL,
0x0000000458007c0cULL, 0x000fe2000bf26070ULL, 0x00000010280a7825ULL, 0x000fd000078e000aULL,
0x00000000087c7faeULL, 0x000fe2000c101c54ULL, 0x0000000457007c0cULL, 0x000fe2000bf06070ULL,
0x00000010280c7825ULL, 0x000fe400078e000cULL, 0x00002c0001467983ULL, 0x000f280000300800ULL,
0x0000280001477983ULL, 0x000f280000300800ULL, 0x000000000a2a7faeULL, 0x004fe2000c901c54ULL,
0x0000000456007c0cULL, 0x000fc6000bf26070ULL, 0x000000000c2b7faeULL, 0x008fe8000c101c54ULL,
0x00002400012a7983ULL, 0x000ea80000300800ULL, 0x00002000012b7983ULL, 0x000ee20000300800ULL,
0x00000010280e7825ULL, 0x000fe200078e000eULL, 0x0000000455007c0cULL, 0x000fc4000bf06070ULL,
0x0000000453007c0cULL, 0x000fe4000bf46070ULL, 0x0000000452007c0cULL, 0x000fe2000bf66070ULL,
0x0000001028107825ULL, 0x000fc800078e0010ULL, 0x0000001028127825ULL, 0x000fe200078e0012ULL,
0x000000000e077faeULL, 0x010fe2000c901c54ULL, 0x0000000454007c0cULL, 0x000fe4000bf26070ULL,
0x0000001028147825ULL, 0x040fe200078e0014ULL, 0x00000000107d7faeULL, 0x000fe6000c101c54ULL,
0x0000001028167825ULL, 0x000fe200078e0016ULL, 0x000000045b007c0cULL, 0x000fe4000bf06070ULL,
0x000000045d007c0cULL, 0x000fc8000bf86070ULL, 0x0000000012447faeULL, 0x000fe2000c901c54ULL,
0x000000045a007c0cULL, 0x000fc6000bf26070ULL, 0x0000000014457faeULL, 0x000fe2000d101c54ULL,
0x000000046f007c0cULL, 0x000fc6000bf46070ULL, 0x0000000016297faeULL, 0x0009e2000d901c54ULL,
0x000000045e007c0cULL, 0x000fe4000bf66070ULL, 0x000000045c007c0cULL, 0x000fe4000bfa6070ULL,
0x0000000470007c0cULL, 0x000fe2000bfc6070ULL, 0x0000001028187825ULL, 0x000fc800078e0018ULL,
0x00000010281a7825ULL, 0x040fe200078e001aULL, 0x0000000018467faeULL, 0x0003e6000c101c54ULL,
0x00000010281c7825ULL, 0x040fe200078e001cULL, 0x000000001a477faeULL, 0x0003e6000c901c54ULL,
0x00000010281e7825ULL, 0x000fc800078e001eULL, 0x0000001028207825ULL, 0x000fc800078e0020ULL,
0x0000001028227825ULL, 0x000fc800078e0022ULL, 0x0000001028287825ULL, 0x010fe200078e0050ULL,
0x000000001c2a7faeULL, 0x0043e8000d101c54ULL, 0x000000001e2b7faeULL, 0x0083e8000d901c54ULL,
0x0000000020717faeULL, 0x0203e8000e101c54ULL, 0x0000000022727faeULL, 0x0003e8000e901c54ULL,
0x00000000287b7faeULL, 0x0003e2000f101c54ULL, 0x0000000000b87947ULL, 0x000fea0003800000ULL,
0x0000001802287812ULL, 0x000fe200078efcffULL, 0x0000040001297983ULL, 0x000ea80000300800ULL,
0x0000100001477983ULL, 0x000ee20000300800ULL, 0x0000001028067825ULL, 0x000fc600078e0006ULL,
0x00001c0001467983ULL, 0x000f280000300800ULL, 0x00002c0001457983ULL, 0x000ea80000300800ULL,
0x0000280001447983ULL, 0x000ea80000300800ULL, 0x00002400012b7983ULL, 0x000ea80000300800ULL,
0x00002000012a7983ULL, 0x000ea80000300800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000067a7faeULL, 0x000fe8000b901c54ULL, 0x00000000017a7983ULL, 0x000ea80000300800ULL,
0x0000080001067983ULL, 0x000ee80000300800ULL, 0x0000140001077983ULL, 0x000f220000300800ULL,
0x0000001028087825ULL, 0x000fc800078e0008ULL, 0x00000010280a7825ULL, 0x040fe200078e000aULL,
0x00000000087c7faeULL, 0x000fe6000b901c54ULL, 0x00000010280c7825ULL, 0x000fc800078e000cULL,
0x00000010280e7825ULL, 0x000fc800078e000eULL, 0x0000001028107825ULL, 0x000fc800078e0010ULL,
0x0000001028127825ULL, 0x000fc800078e0012ULL, 0x0000001028147825ULL, 0x000fc800078e0014ULL,
0x0000001028167825ULL, 0x000fc800078e0016ULL, 0x0000001028187825ULL, 0x000fc800078e0018ULL,
0x00000010281a7825ULL, 0x000fc800078e001aULL, 0x00000010281c7825ULL, 0x000fc800078e001cULL,
0x00000010281e7825ULL, 0x000fc800078e001eULL, 0x0000001028207825ULL, 0x000fc800078e0020ULL,
0x0000001028227825ULL, 0x040fe200078e0022ULL, 0x000000000a7a7faeULL, 0x004fe8000b901c54ULL,
0x000000000c067faeULL, 0x008fe8000b901c54ULL, 0x000000000e297faeULL, 0x0005e8000b901c54ULL,
0x00000000107d7faeULL, 0x0003e8000b901c54ULL, 0x0000000012077faeULL, 0x0103e8000b901c54ULL,
0x0000000014477faeULL, 0x0003e2000b901c54ULL, 0x0000001028287825ULL, 0x004fc600078e0050ULL,
0x0000000016467faeULL, 0x0003e8000b901c54ULL, 0x0000000018457faeULL, 0x0003e8000b901c54ULL,
0x000000001a447faeULL, 0x0003e8000b901c54ULL, 0x000000001c2b7faeULL, 0x0003e8000b901c54ULL,
0x000000001e2a7faeULL, 0x0003e8000b901c54ULL, 0x0000000020717faeULL, 0x0203e8000b901c54ULL,
0x0000000022727faeULL, 0x0003e8000b901c54ULL, 0x00000000287b7faeULL, 0x0003e4000b901c54ULL,
0x00009c0001087983ULL, 0x002ea80000300800ULL, 0x0000b00001137983ULL, 0x000ee80000300800ULL,
0x0000b40001127983ULL, 0x000f280000300800ULL, 0x0000c40001117983ULL, 0x000f680000300800ULL,
0x0000d40001107983ULL, 0x000ee80000300800ULL, 0x0000d80001077983ULL, 0x000ee80000300800ULL,
0x0000bc0001187983ULL, 0x000ee20000300800ULL, 0x0000000000067919ULL, 0x000e660000000000ULL,
0x00000000000079afULL, 0x000e280000000000ULL, 0x0000cc0001177983ULL, 0x000ee80000300800ULL,
0x0000b80001167983ULL, 0x000ee80000300800ULL, 0x0000ac0001157983ULL, 0x000ee80000300800ULL,
0x0000a40001147983ULL, 0x000ee80000300800ULL, 0x0000a800011b7983ULL, 0x000ee20000300800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000004ff2a7819ULL, 0x002fe20000011606ULL,
0x00009800011a7983ULL, 0x000f280000300800ULL, 0x000000102a067836ULL, 0x000fe20000000000ULL,
0x0000a00001197983ULL, 0x000f280000300800ULL, 0x0000000706067812ULL, 0x000fca00078e7803ULL,
0x0000002003067824ULL, 0x000fca00078e0206ULL, 0x0000000e06067c11ULL, 0x000fe2000f8e20ffULL,
0x00000000080c783bULL, 0x004fe80000000200ULL, 0x000000000608783bULL, 0x000e640000000200ULL,
0x0000000c082c723cULL, 0x002fec000004182cULL, 0x0000000e0830723cULL, 0x000fe20000041830ULL,
0x00000000130c783bULL, 0x008e6a0000000200ULL, 0x0000000c0824723cULL, 0x002fec0000041824ULL,
0x0000000e0848723cULL, 0x000fe20000041848ULL, 0x00000000120c783bULL, 0x010e620000000200ULL,
0x000000122a067836ULL, 0x000fca0000000000ULL, 0x0000000706067812ULL, 0x000fe200078e7803ULL,
0x0000000c0834723cULL, 0x002fec0000041834ULL, 0x0000000e0838723cULL, 0x000fe20000041838ULL,
0x00000000110c783bULL, 0x020e620000000200ULL, 0x0000002003067824ULL, 0x000fc600078e0206ULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x0000000c083c723cULL, 0x002fec000004183cULL,
0x0000000e0840723cULL, 0x000fe20000041840ULL, 0x00000000070c783bULL, 0x000fec0000000200ULL,
0x0000000e06087c11ULL, 0x000fcc000f8e20ffULL, 0x000000000808783bULL, 0x000e640000000200ULL,
0x00000010082c723cULL, 0x002fec000004182cULL, 0x000000120830723cULL, 0x000fe20000041830ULL,
0x000000001810783bULL, 0x0002a80000000200ULL, 0x0000940001187983ULL, 0x002ee20000300800ULL,
0x0000000c0824723cULL, 0x000fe20000041824ULL, 0x0000000717077291ULL, 0x000fc4000f8e103fULL,
0x00009000011c7983ULL, 0x000f260000100800ULL, 0x0000000e0848723cULL, 0x000fe20000041848ULL,
0x00000000170c783bULL, 0x000e680000000200ULL, 0x00005800017d7983ULL, 0x000f680000100800ULL,
0x00005400017c7983ULL, 0x000f680000100800ULL, 0x00005000017b7983ULL, 0x000f680000100800ULL,
0x00004c00017a7983ULL, 0x000f680000100800ULL, 0x0000480001727983ULL, 0x000f620000100800ULL,
0x000000100834723cULL, 0x004fe60000041834ULL, 0x0000400001717983ULL, 0x000f680000100800ULL,
0x0000840001517983ULL, 0x000f620000100800ULL, 0x000000120838723cULL, 0x000fe60000041838ULL,
0x000000001510783bULL, 0x000fe80000000200ULL, 0x0000800001507983ULL, 0x000f620000100800ULL,
0x0000000c083c723cULL, 0x002fe6000004183cULL, 0x0000780001477983ULL, 0x000f680000100800ULL,
0x0000740001467983ULL, 0x000f620000100800ULL, 0x0000000e0840723cULL, 0x000fe60000041840ULL,
0x00000000160c783bULL, 0x000fe80000000200ULL, 0x000000142a087836ULL, 0x000fe20000000000ULL,
0x000000001414783bULL, 0x000fe80000000200ULL, 0x0000000708087812ULL, 0x000fe200078e7803ULL,
0x0000700001457983ULL, 0x000f680000100800ULL, 0x0000002003087824ULL, 0x000fca00078e0208ULL,
0x0000000e08087c11ULL, 0x000fcc000f8e20ffULL, 0x000000000808783bULL, 0x000e620000000200ULL,
0x000000050700728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x000000070a048291ULL, 0x000fe2000f8e083fULL, 0x00008c0000088ab9ULL, 0x000fc60000000a00ULL,
0x00000004040888a5ULL, 0x000fcc000f8e0008ULL, 0x00000008ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000009ff077e24ULL, 0x000fca000f8e00ffULL, 0x0000001406068981ULL, 0x0008a2000c1e1900ULL,
0x000000140834723cULL, 0x002fec0000041834ULL, 0x000000160838723cULL, 0x000fe20000041838ULL,
0x000000001b14783bULL, 0x000e6a0000000200ULL, 0x0000000c082c723cULL, 0x000fec000004182cULL,
0x0000000e0830723cULL, 0x000fec0000041830ULL, 0x000000100824723cULL, 0x000fec0000041824ULL,
0x000000120848723cULL, 0x000fe20000041848ULL, 0x000000001a10783bULL, 0x000fea0000000200ULL,
0x00000014083c723cULL, 0x002fec000004183cULL, 0x000000160840723cULL, 0x000fe20000041840ULL,
0x000000001908783bULL, 0x000fe80000000200ULL, 0x000000001814783bULL, 0x008fe80000000200ULL,
0x000000007918783bULL, 0x0003e80000000200ULL, 0x00005c0001797983ULL, 0x0023620000100800ULL,
0x000000162a0c7836ULL, 0x000fca0000000000ULL, 0x000000070c0c7812ULL, 0x000fca00078e7803ULL,
0x00000020030c7824ULL, 0x000fca00078e020cULL, 0x0000000e0c0c7c11ULL, 0x000fcc000f8e20ffULL,
0x000000000c0c783bULL, 0x000ee20000000200ULL, 0x000000171c077c36ULL, 0x010fe20008000000ULL,
0x0000000000447919ULL, 0x000e620000000000ULL, 0xffffffff00087882ULL, 0x000fe20000000000ULL,
0x000000100c2c723cULL, 0x008fec000004182cULL, 0x000000120c30723cULL, 0x000fec0000041830ULL,
0x000000080c24723cULL, 0x000fec0000041824ULL, 0x0000000a0c48723cULL, 0x000fe20000041848ULL,
0x00000000060482caULL, 0x004fe200000e0000ULL, 0x0000000107067836ULL, 0x000fca0000000000ULL,
0x0000000606007c0cULL, 0x000fe2000bf06070ULL, 0x000000140c34723cULL, 0x000fec0000041834ULL,
0x000000160c38723cULL, 0x000fe20000041838ULL, 0x0000000400088c82ULL, 0x000fca0008000000ULL,
0x000000180c3c723cULL, 0x000fec000004183cULL, 0x0000001a0c40723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000400b88947ULL, 0x002fde0003800000ULL,
0x00006000011f7983ULL, 0x000ea80000300800ULL, 0x00006c00011e7983ULL, 0x000ee80000300800ULL,
0x00006800011d7983ULL, 0x000f280000300800ULL, 0x00006400011c7983ULL, 0x000f220000300800ULL,
0x0000000f07067c11ULL, 0x000fe2000f8e40ffULL, 0x0000000c080472a4ULL, 0x000fe2000f8e020dULL,
0x0000001044287824ULL, 0x000fc400078e00ffULL, 0x0000001806097c48ULL, 0x000fc6000ffe0000ULL,
0x0000007028287812ULL, 0x000fe200078ec0ffULL, 0x0000000479117c36ULL, 0x020fe40008000000ULL,
0x0000000109067824ULL, 0x000fe400078e0a06ULL, 0x000000047d177c36ULL, 0x000fe40008000000ULL,
0x000000047c217c36ULL, 0x000fe20008000000ULL, 0x000000060000720cULL, 0x080fe20003f26070ULL,
0x0000020017167825ULL, 0x000fe200078e0004ULL, 0x000000065900720cULL, 0x000fc40003f06070ULL,
0x000000065800720cULL, 0x080fe20003f66070ULL, 0x0000020021207825ULL, 0x100fe200078e0004ULL,
0x000000065600720cULL, 0x080fe40003f86070ULL, 0x000000065500720cULL, 0x000fe20003fa6070ULL,
0x000000047a1b7c36ULL, 0x000fe40008000000ULL, 0x0000000472197c36ULL, 0x000fe40008000000ULL,
0x000002001b1a7825ULL, 0x000fc800078e0004ULL, 0x0000020019187825ULL, 0x000fc800078e0004ULL,
0x0000000471157c36ULL, 0x000fe40008000000ULL, 0x0000000451137c36ULL, 0x000fe40008000000ULL,
0x00000004502b7c36ULL, 0x000fe40008000000ULL, 0x0000020015147825ULL, 0x000fc800078e0004ULL,
0x0000020013127825ULL, 0x000fc800078e0004ULL, 0x00000004470f7c36ULL, 0x000fe40008000000ULL,
0x0000000445297c36ULL, 0x000fe40008000000ULL, 0x000002000f0e7825ULL, 0x000fc800078e0004ULL,
0x000000041f0b7c36ULL, 0x004fe40008000000ULL, 0x000000047b1f7c36ULL, 0x000fe40008000000ULL,
0x000002000b087825ULL, 0x000fc800078e0004ULL, 0x000000041e237c36ULL, 0x008fe20008000000ULL,
0x0000000828087210ULL, 0x000fe20007f5e0ffULL, 0x000000041d0d7c36ULL, 0x010fe40008000000ULL,
0x0000020023227825ULL, 0x000fc800078e0004ULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x000000065700720cULL, 0x000fe20003f46070ULL, 0x000002000d0c7825ULL, 0x000fc600078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000086b7faeULL, 0x0003e2000c901c54ULL,
0x0000002228227210ULL, 0x000fe20007f3e0ffULL, 0x000000041c1d7c36ULL, 0x000fe40008000000ULL,
0x000002001f1e7825ULL, 0x000fc800078e0004ULL, 0x000000ffff237224ULL, 0x000fe200008e0623ULL,
0x0000000c280c7210ULL, 0x000fe20007f3e0ffULL, 0x000002001d1c7825ULL, 0x000fc600078e0004ULL,
0x00000000226c7faeULL, 0x000fe2000c101c54ULL, 0x0000020011087825ULL, 0x002fe200078e0004ULL,
0x0000001c281c7210ULL, 0x000fe40007fde0ffULL, 0x000000065400720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000000828087210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200030e061dULL, 0x0000001628167210ULL, 0x000fe20007fde0ffULL,
0x00000004460b7c36ULL, 0x000fe20008000000ULL, 0x000000000c6d7faeULL, 0x0003e2000d901c54ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000002028207210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001e281e7210ULL, 0x000fe20007fde0ffULL,
0x000000001c6e7faeULL, 0x000fe2000d101c54ULL, 0x000000065200720cULL, 0x080fe20003f46070ULL,
0x000000ffff217224ULL, 0x000fe200008e0621ULL, 0x000000065300720cULL, 0x000fe20003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200030e061fULL, 0x0000001828187210ULL, 0x000fe20007fde0ffULL,
0x000002002b107825ULL, 0x100fe200078e0004ULL, 0x0000001a280c7210ULL, 0x002fe20007f7e0ffULL,
0x00000000086a7faeULL, 0x0003e4000e101c54ULL, 0x000002000b0a7825ULL, 0x000fc400078e0004ULL,
0x0000000016697faeULL, 0x0005e2000e901c54ULL, 0x000000065a00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff0d7224ULL, 0x000fe200018e061bULL, 0x000000065b00720cULL, 0x080fe20003f66070ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000001228127210ULL, 0x000fe20007fde0ffULL,
0x0000000020687faeULL, 0x0005e2000c101c54ULL, 0x0000001028107210ULL, 0x000fe20007f1e0ffULL,
0x0000020029047825ULL, 0x000fe200078e0004ULL, 0x0000001428087210ULL, 0x002fe20007f9e0ffULL,
0x000000001e677faeULL, 0x0005e2000c901c54ULL, 0x000000065e00720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x0000000e280e7210ULL, 0x000fe20007fde0ffULL,
0x000000000c667faeULL, 0x0005e2000d101c54ULL, 0x0000000a280a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0615ULL, 0x000000066f00720cULL, 0x080fe20003f86070ULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x000000065d00720cULL, 0x080fe20003f06070ULL,
0x0000000018657faeULL, 0x0005e2000d901c54ULL, 0x000000065c00720cULL, 0x080fe20003f66070ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x000000067000720cULL, 0x000fe20003f46070ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x0000000428287210ULL, 0x000fe20007fde0ffULL,
0x0000000008647faeULL, 0x0005e8000e901c54ULL, 0x000000ffff297224ULL, 0x000fe200030e0605ULL,
0x0000000012637faeULL, 0x0005e8000e101c54ULL, 0x0000000010627faeULL, 0x0005e8000c901c54ULL,
0x000000000e617faeULL, 0x0005e8000c101c54ULL, 0x000000000a607faeULL, 0x0005e8000d901c54ULL,
0x00000000285f7faeULL, 0x0005e2000d101c54ULL, 0x0000000400687947ULL, 0x000fea0003800000ULL,
0x00006000010b7983ULL, 0x000ea80000300800ULL, 0x00006c00010a7983ULL, 0x000ee80000300800ULL,
0x0000680001097983ULL, 0x000f280000300800ULL, 0x0000640001087983ULL, 0x000f220000300800ULL,
0x0000000c080472a4ULL, 0x000fe2000f8e020dULL, 0x0000001044067824ULL, 0x000fca00078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000000479177c36ULL, 0x020fe40008000000ULL,
0x000000047d197c36ULL, 0x000fe40008000000ULL, 0x000000047c1b7c36ULL, 0x000fe40008000000ULL,
0x000000047b1d7c36ULL, 0x000fe40008000000ULL, 0x0000020017167825ULL, 0x000fc800078e0004ULL,
0x0000020019187825ULL, 0x000fc800078e0004ULL, 0x000000047a0f7c36ULL, 0x000fe40008000000ULL,
0x000002001b1a7825ULL, 0x000fc800078e0004ULL, 0x0000000472117c36ULL, 0x000fe40008000000ULL,
0x000002001d1c7825ULL, 0x000fc800078e0004ULL, 0x0000000471137c36ULL, 0x000fe40008000000ULL,
0x0000000451157c36ULL, 0x000fe40008000000ULL, 0x000002000f0e7825ULL, 0x000fc800078e0004ULL,
0x0000020011107825ULL, 0x000fc800078e0004ULL, 0x0000020013127825ULL, 0x000fc800078e0004ULL,
0x0000020015147825ULL, 0x000fc800078e0004ULL, 0x00000004460d7c36ULL, 0x000fe40008000000ULL,
0x00000004452b7c36ULL, 0x000fe40008000000ULL, 0x000002000d0c7825ULL, 0x000fc800078e0004ULL,
0x000000040b1f7c36ULL, 0x004fe40008000000ULL, 0x00000004470b7c36ULL, 0x000fe40008000000ULL,
0x000000040a217c36ULL, 0x008fe40008000000ULL, 0x000002001f1e7825ULL, 0x000fc800078e0004ULL,
0x0000000409237c36ULL, 0x010fe20008000000ULL, 0x0000001e061e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000408297c36ULL, 0x000fe40008000000ULL, 0x0000020021207825ULL, 0x000fc800078e0004ULL,
0x0000020023227825ULL, 0x000fe200078e0004ULL, 0x0000002006207210ULL, 0x000fc60007f3e0ffULL,
0x0000020029287825ULL, 0x000fe200078e0004ULL, 0x0000002206227210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x0000002806287210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e0621ULL, 0x0000001606167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff237224ULL, 0x000fe200010e0623ULL, 0x0000001806187210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff297224ULL, 0x000fe200018e0629ULL, 0x0000001a061a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000450097c36ULL, 0x000fe20008000000ULL, 0x0000001c061c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x0000000e060e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x0000001006107210ULL, 0x000fe20007f3e0ffULL,
0x0000020009087825ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e6b7faeULL, 0x0003e6000b901c54ULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x0000001206127210ULL, 0x000fe20007f5e0ffULL, 0x000002000b0a7825ULL, 0x000fe200078e0004ULL,
0x00000000206c7faeULL, 0x0003e6000b901c54ULL, 0x000000ffff1d7224ULL, 0x000fe200018e061dULL,
0x0000001406147210ULL, 0x000fe20007f7e0ffULL, 0x000002002b047825ULL, 0x000fe200078e0004ULL,
0x00000000226d7faeULL, 0x0003e6000b901c54ULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000000806087210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000000a060a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x00000000286e7faeULL, 0x0003e2000b901c54ULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x0000000c060c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x00000000166a7faeULL, 0x0003e2000b901c54ULL, 0x0000000406047210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fc400008e060bULL, 0x0000000018697faeULL, 0x0003e2000b901c54ULL,
0x000000ffff0d7224ULL, 0x000fe400010e060dULL, 0x000000ffff057224ULL, 0x000fe200018e0605ULL,
0x000000001a687faeULL, 0x0003e8000b901c54ULL, 0x000000001c677faeULL, 0x0003e8000b901c54ULL,
0x000000000e667faeULL, 0x0003e8000b901c54ULL, 0x0000000010657faeULL, 0x0003e8000b901c54ULL,
0x0000000012647faeULL, 0x0003e8000b901c54ULL, 0x0000000014637faeULL, 0x0003e8000b901c54ULL,
0x0000000008627faeULL, 0x0003e8000b901c54ULL, 0x000000000a617faeULL, 0x0003e8000b901c54ULL,
0x000000000c607faeULL, 0x0003e8000b901c54ULL, 0x00000000045f7faeULL, 0x0003e4000b901c54ULL,
0x0000d00001087983ULL, 0x006ea80000300800ULL, 0x0000c800010d7983ULL, 0x000ee80000300800ULL,
0x0000c00001067983ULL, 0x000f280000300800ULL, 0x00003800010c7983ULL, 0x000f680000300800ULL,
0x0000340001107983ULL, 0x000f680000300800ULL, 0x0000300001057983ULL, 0x000f620000300800ULL,
0x000000182a047836ULL, 0x000fc60000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000704047812ULL, 0x000fca00078e7803ULL, 0x0000002003047824ULL, 0x000fca00078e0204ULL,
0x0000000e04047c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000041c783bULL, 0x000fe80000000200ULL, 0x000000007878783bULL, 0x000fe80000000200ULL,
0x000000007370783bULL, 0x000fe80000000200ULL, 0x000000000808783bULL, 0x004e680000000200ULL,
0x000000000d14783bULL, 0x008ea80000000200ULL, 0x000000000620783bULL, 0x0107280000000200ULL,
0x000000000c0c783bULL, 0x020f620000000200ULL, 0x0000001a2a067836ULL, 0x008fc60000000000ULL,
0x000000001018783bULL, 0x000fe40000000200ULL, 0x0000000706067812ULL, 0x000fca00078e7803ULL,
0x0000002003067824ULL, 0x000fca00078e0206ULL, 0x0000000e06067c11ULL, 0x000fca000f8e20ffULL,
0x000000000610783bULL, 0x000fe20000000200ULL, 0x000000081c2c723cULL, 0x002fec000004182cULL,
0x0000000a1c30723cULL, 0x000fe20000041830ULL, 0x000000000508783bULL, 0x0002e80000000200ULL,
0x0000dc0001057983ULL, 0x002ee20000100800ULL, 0x000000141c24723cULL, 0x004fe20000041824ULL,
0x0000001c2a047836ULL, 0x040fe20000000000ULL, 0x0000000e16047291ULL, 0x000fe2000f8e383fULL,
0x0000001e2a067836ULL, 0x000fc40000000000ULL, 0x000000004e28783bULL, 0x000fe20000000200ULL,
0x000000161c48723cULL, 0x000fe20000041848ULL, 0x0000000704047812ULL, 0x000fe400078e7803ULL,
0x000000007714783bULL, 0x000e620000000200ULL, 0x0000000706067812ULL, 0x000fe400078e7803ULL,
0x0000002003047824ULL, 0x040fe200078e0204ULL, 0x000000201c34723cULL, 0x010fe40000041834ULL,
0x0000002003067824ULL, 0x000fc400078e0206ULL, 0x0000000e04047c11ULL, 0x000fe4000f8e20ffULL,
0x000000221c38723cULL, 0x000fe20000041838ULL, 0x0000000e06067c11ULL, 0x000fca000f8e20ffULL,
0x0000000c1c3c723cULL, 0x020fe2000004183cULL, 0x000000000620783bULL, 0x000fea0000000200ULL,
0x0000000e1c40723cULL, 0x000fe20000041840ULL, 0x00000000750c783bULL, 0x000fe80000000200ULL,
0x00000000041c783bULL, 0x000ea20000000200ULL, 0x000000081024723cULL, 0x008fec0000041824ULL,
0x0000000a1048723cULL, 0x000fe20000041848ULL, 0x000000004f08783bULL, 0x000eea0000000200ULL,
0x00000018102c723cULL, 0x000fec000004182cULL, 0x0000001a1030723cULL, 0x000fe20000041830ULL,
0x000000007418783bULL, 0x000f280000000200ULL, 0x000000007674783bULL, 0x000fe20000000200ULL,
0x000000781034723cULL, 0x000fec0000041834ULL, 0x0000007a1038723cULL, 0x000fec0000041838ULL,
0x00000014103c723cULL, 0x002fec000004183cULL, 0x000000161040723cULL, 0x000fe20000041840ULL,
0x000000004d10783bULL, 0x000e680000000200ULL, 0x000000004c14783bULL, 0x000f620000000200ULL,
0x0000000c1c2c723cULL, 0x004fec000004182cULL, 0x0000000e1c30723cULL, 0x000fec0000041830ULL,
0x000000081c0c723cULL, 0x008fec0000041834ULL, 0x0000000a1c38723cULL, 0x000fec0000041838ULL,
0x000000181c24723cULL, 0x010fec0000041824ULL, 0x0000001a1c48723cULL, 0x000fec0000041848ULL,
0x000000281c08723cULL, 0x000fec000004183cULL, 0x0000002a1c40723cULL, 0x000fec0000041840ULL,
0x000000702018723cULL, 0x000fec0000041824ULL, 0x00000010200c723cULL, 0x002fec000004180cULL,
0x00000074202c723cULL, 0x000fec000004182cULL, 0x000000762030723cULL, 0x000fec0000041830ULL,
0x000000722070723cULL, 0x000fe20000041848ULL, 0x3d80000018187820ULL, 0x000fe20000410000ULL,
0x3d80000019197820ULL, 0x000fe20000410000ULL, 0x3d8000001a1a7820ULL, 0x000fe20000410000ULL,
0x3d8000001b1b7820ULL, 0x000fc40000410000ULL, 0x000000122010723cULL, 0x000fe20000041838ULL,
0x3d8000000e0e7820ULL, 0x000fe20000410000ULL, 0x3d8000000f0f7820ULL, 0x000fc80000410000ULL,
0x000000142008723cULL, 0x020fe20000041808ULL, 0x3d8000002d047820ULL, 0x000fe20000410000ULL,
0x3d8000002e067820ULL, 0x000fc80000410000ULL, 0x000000162020723cULL, 0x000fe20000041840ULL,
0x3d8000000c157820ULL, 0x000fe20000410000ULL, 0x3d8000002f147820ULL, 0x000fe20000410000ULL,
0x3d80000030307820ULL, 0x000fe20000410000ULL, 0x3d80000031317820ULL, 0x000fe20000410000ULL,
0x3d80000032327820ULL, 0x000fe20000410000ULL, 0x3d80000033337820ULL, 0x000fe20000410000ULL,
0x3d8000000d167820ULL, 0x000fe20000410000ULL, 0x3d80000070707820ULL, 0x000fe20000410000ULL,
0x3d80000071717820ULL, 0x000fe20000410000ULL, 0x3d80000072727820ULL, 0x000fe20000410000ULL,
0x3d80000073737820ULL, 0x000fe20000410000ULL, 0x3d80000010107820ULL, 0x000fe20000410000ULL,
0x3d80000011117820ULL, 0x000fe20000410000ULL, 0x3d80000012127820ULL, 0x000fe20000410000ULL,
0x3d80000013137820ULL, 0x000fc60000410000ULL, 0x3d80000008177820ULL, 0x000fe20000410000ULL,
0x3d800000091c7820ULL, 0x000fe20000410000ULL, 0x3d8000000a0c7820ULL, 0x000fe20000410000ULL,
0x3d8000000b0d7820ULL, 0x000fc60000410000ULL, 0x3d80000020207820ULL, 0x000fe20000410000ULL,
0x3d80000021217820ULL, 0x000fe20000410000ULL, 0x3d80000022227820ULL, 0x000fe20000410000ULL,
0x3d80000023237820ULL, 0x000fe20000410000ULL, 0x0000ffff05037812ULL, 0x000fe200078ec0ffULL,
0x3d8000002c057820ULL, 0x000fc60000410000ULL, 0x00008880031d7816ULL, 0x000fe200000000ffULL,
0x0000000444037824ULL, 0x000fc800078e00ffULL, 0x800000001d1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff003037812ULL, 0x000fc600078ec0ffULL, 0x0246101dff0075a7ULL, 0x000e640008000151ULL,
0x00000014000c8947ULL, 0x002fea0003800000ULL, 0x00009000011d7983ULL, 0x000ea20000300800ULL,
0xffffffff06097890ULL, 0x000fc6000fffe03fULL, 0x0244000403087984ULL, 0x0002620008000c00ULL,
0x00000000002f7919ULL, 0x000e640000000000ULL, 0x000000091d007c0cULL, 0x004fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x000000022f1d7824ULL, 0x000fe200078e00ffULL,
0x8000000b180b7290ULL, 0x000fc8000fffe03fULL, 0x000000061d1d7812ULL, 0x000fc800078ec0ffULL,
0x000000011d1e7812ULL, 0x040fe400078efcffULL, 0x000000081d1f7812ULL, 0x040fe400078efcffULL,
0x0000000b1e007c0cULL, 0x000fe4000bf26070ULL, 0x000000101d1e7812ULL, 0x000fe400078efcffULL,
0x0000000b1f007c0cULL, 0x000fe4000bf06070ULL, 0x0000000b1e007c0cULL, 0x000fc4000bfc6070ULL,
0x000000111d1f7812ULL, 0x040fe400078efcffULL, 0x000000181d1e7812ULL, 0x040fe400078efcffULL,
0x0000000b1d007c0cULL, 0x000fe4000bf46070ULL, 0x0000000b1f007c0cULL, 0x000fe4000bfa6070ULL,
0x0000000b1e007c0cULL, 0x000fe4000bf66070ULL, 0x000000091d247812ULL, 0x000fc400078efcffULL,
0x000000191d1f7812ULL, 0x040fe400078efcffULL, 0x000000201d1e7812ULL, 0x000fe400078efcffULL,
0xff7fffff06067808ULL, 0x000fe40005000000ULL, 0xff7fffff05057808ULL, 0x000fe40005000000ULL,
0xff7fffff14147808ULL, 0x000fe40004800000ULL, 0xff7fffff04047808ULL, 0x000fc40004800000ULL,
0x0000000b24007c0cULL, 0x000fe4000bf86070ULL, 0x0000000b1f007c0cULL, 0x000fe4000bf46070ULL,
0x0000000b1e007c0cULL, 0x000fe4000bf26070ULL, 0x000000211d1f7812ULL, 0x040fe400078efcffULL,
0x000000281d1e7812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fc40004000000ULL,
0xff7fffff30307808ULL, 0x000fe40004000000ULL, 0xff7fffff33337808ULL, 0x000fe40006000000ULL,
0xff7fffff31317808ULL, 0x000fe40006000000ULL, 0x0000000b1f007c0cULL, 0x000fe4000bf06070ULL,
0x0000000b1e007c0cULL, 0x000fe4000bf86070ULL, 0x000000291d1f7812ULL, 0x000fc400078efcffULL,
0x000000301d1e7812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40007000000ULL,
0xff7fffff18187808ULL, 0x000fe40007000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40006800000ULL,
0xff7fffff19197808ULL, 0x000fe40006800000ULL, 0x0000000b1f007c0cULL, 0x000fc4000bfc6070ULL,
0x0000000b1e007c0cULL, 0x000fe4000bfa6070ULL, 0x000000311d1f7812ULL, 0x040fe400078efcffULL,
0x000000381d1e7812ULL, 0x040fe400078efcffULL, 0x000000391d1d7812ULL, 0x000fe400078efcffULL,
0xff7fffff72727808ULL, 0x000fe40005800000ULL, 0xff7fffff70707808ULL, 0x000fc40005800000ULL,
0xff7fffff73737808ULL, 0x000fe40005000000ULL, 0xff7fffff71717808ULL, 0x000fe40005000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL, 0xff7fffff15157808ULL, 0x000fe40004800000ULL,
0x0000000b1f007c0cULL, 0x000fe4000bf66070ULL, 0x0000000b1e007c0cULL, 0x000fc4000bf46070ULL,
0x0000000b1d007c0cULL, 0x000fe4000bf26070ULL, 0xff7fffff0f0f7808ULL, 0x000fe40004000000ULL,
0xff7fffff16167808ULL, 0x000fe40004000000ULL, 0xff7fffff12127808ULL, 0x000fe40006000000ULL,
0xff7fffff10107808ULL, 0x000fe40006000000ULL, 0xff7fffff13137808ULL, 0x000fc40007000000ULL,
0xff7fffff11117808ULL, 0x000fe40007000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40006800000ULL,
0xff7fffff17177808ULL, 0x000fe40006800000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40005800000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40005800000ULL, 0xff7fffff22227808ULL, 0x000fc40005000000ULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff21217808ULL, 0x000fce0004800000ULL, 0x0000dc00011f7983ULL, 0x000ea20000300800ULL,
0x00000005081d7209ULL, 0x000fe20007810000ULL, 0xffffffff00097882ULL, 0x000fe20000000000ULL,
0x0000000609097209ULL, 0x000fe40007810000ULL, 0x000000041d1d7209ULL, 0x000fe40007810000ULL,
0x0000001409097209ULL, 0x000fe40007810000ULL, 0x000000301d087209ULL, 0x000fe40007810000ULL,
0x00000032091e7209ULL, 0x000fc40007810000ULL, 0x0000003108097209ULL, 0x000fe40007810000ULL,
0x000000331e1d7209ULL, 0x000fe40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000001a1d1e7209ULL, 0x000fe40007810000ULL, 0x0000001908097209ULL, 0x000fe40007810000ULL,
0x0000001b1e1d7209ULL, 0x000fc40007810000ULL, 0x0000007009087209ULL, 0x000fe40007810000ULL,
0x000000721d1e7209ULL, 0x000fe40007810000ULL, 0x0000007108087209ULL, 0x000fe40007810000ULL,
0x000000731e097209ULL, 0x000fe40007810000ULL, 0x00000015081d7209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fc40007810000ULL, 0x000000161d1d7209ULL, 0x000fe40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x000000101d087209ULL, 0x000fe40007810000ULL,
0x00000012091e7209ULL, 0x000fe40007810000ULL, 0x0000001108087209ULL, 0x000fe40007810000ULL,
0x000000131e097209ULL, 0x000fc40007810000ULL, 0x00000017081d7209ULL, 0x000fe40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001c1d1d7209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x000000201d1e7209ULL, 0x000fe40007810000ULL,
0x0000002209247209ULL, 0x000fc40007810000ULL, 0x000000211e1e7209ULL, 0x000fe40007810000ULL,
0x000000ff1fff7812ULL, 0x004fc8000780c0ffULL, 0x00000001ff087807ULL, 0x000fc80000000000ULL,
0x0000761008097816ULL, 0x000fe40000000009ULL, 0x0000002324087209ULL, 0x000fc60007810000ULL,
0x0000dc0901007387ULL, 0x0003e20000100600ULL, 0x0000000e09707947ULL, 0x000fea000b800000ULL,
0x0c401f001e097f89ULL, 0x002e6800000e0000ULL, 0x0c401f00081f7f89ULL, 0x000ea800000e0000ULL,
0x0c401f000a257f89ULL, 0x000ee800000e0000ULL, 0x0c401f000b247f89ULL, 0x000f2200000e0000ULL,
0x000000091e1d7209ULL, 0x002fc40007810000ULL, 0x0000001f081f7209ULL, 0x004fc60007810000ULL,
0x0c201f001d287f89ULL, 0x000e6200000e0000ULL, 0x000000250a267209ULL, 0x008fc60007810000ULL,
0x0c201f001f2a7f89ULL, 0x000ea200000e0000ULL, 0x000000240b247209ULL, 0x010fc60007810000ULL,
0x0c201f0026277f89ULL, 0x000ee800000e0000ULL, 0x0c201f0024257f89ULL, 0x00092200000e0000ULL,
0x000000281d087209ULL, 0x002fe40007810000ULL, 0x0000002a1f097209ULL, 0x004fe40007810000ULL,
0x00000027260a7209ULL, 0x008fce0007810000ULL, 0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL,
0x3f80000000097882ULL, 0x000fe40000000000ULL, 0x00000009ff1d7e24ULL, 0x000fe4000f8e00ffULL,
0x3fb8aa3b05057823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b04047823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b70707823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b71717823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b210b7823ULL, 0x000fe2000001080bULL,
0x3fb8aa3b09217820ULL, 0x000fe20000410000ULL, 0x0000000500057308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b06067823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010821ULL, 0x0000000400047308ULL, 0x000e620000000800ULL,
0x3fb8aa3b72727823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b73737823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010821ULL, 0x0000001500267308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b22227823ULL, 0x000fce0000010821ULL, 0x0000001700287308ULL, 0x000ff00000000800ULL,
0x0000001c00297308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x0000000600067308ULL, 0x000ff00000000800ULL,
0x0000001400157308ULL, 0x0002b00000000800ULL, 0x0000003200177308ULL, 0x000fe20000000800ULL,
0x000000050414723eULL, 0x002fc400000010ffULL, 0x3f8000001d04783eULL, 0x000fe400000010ffULL,
0x000000061515723eULL, 0x004fc600000010ffULL, 0x00000033001c7308ULL, 0x000e620000000800ULL,
0x000000ffff057224ULL, 0x100fe400078e0004ULL, 0x000000ffff2b7224ULL, 0x000fca00078e0004ULL,
0x0000001600277308ULL, 0x0005e20000000800ULL, 0x000000171c17723eULL, 0x002fce00000010ffULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x000000303116723eULL, 0x004fce00000010ffULL,
0x0000001900197308ULL, 0x000e620000000800ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000004141c723cULL, 0x000fe400000418ffULL, 0x0000001a002a7308ULL, 0x000fe20000000800ULL,
0x000000181918723eULL, 0x002fce00000010ffULL, 0x0000001b001b7308ULL, 0x000e700000000800ULL,
0x0000007000707308ULL, 0x000fe20000000800ULL, 0x0000002a1b19723eULL, 0x002fce00000010ffULL,
0x0000007100717308ULL, 0x000e620000000800ULL, 0x000000ffff2a7224ULL, 0x000fce00078e0004ULL,
0x0000007200727308ULL, 0x000fe20000000800ULL, 0x00000070711a723eULL, 0x002fce00000010ffULL,
0x0000007300737308ULL, 0x000e700000000800ULL, 0x0000000e00057308ULL, 0x000fe20000000800ULL,
0x00000072731b723eULL, 0x002fce00000010ffULL, 0x0000000f00067308ULL, 0x000e620000000800ULL,
0x0000002a181c723cULL, 0x000fee000004181cULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0d2b7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b0c2a7823ULL, 0x000fe20000010821ULL,
0x00000005060d723eULL, 0x002fca00000010ffULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x00000026270c723eULL, 0x000fe200000010ffULL, 0x000000ffff057224ULL, 0x000fe400078e0004ULL,
0x3fb8aa3b23217823ULL, 0x000fc80000010821ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000010110e723eULL, 0x002fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000282910723eULL, 0x000fce00000010ffULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000012130f723eULL, 0x002fce00000010ffULL, 0x0000000b000b7308ULL, 0x000e620000000800ULL,
0x000000040c1c723cULL, 0x000fee000004181cULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000200b12723eULL, 0x002fce00000010ffULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x00000025240b7209ULL, 0x010fce0007810000ULL, 0x0000002200137308ULL, 0x000fe20000000800ULL,
0x0000002a2b11723eULL, 0x002fce00000010ffULL, 0x0000002100067308ULL, 0x000e640000000800ULL,
0x000000130613723eULL, 0x002fce00000010ffULL, 0x000000041028723cULL, 0x000fee000004181cULL,
0x0000000fff057424ULL, 0x000fe200078e00ffULL, 0xfffffffc2f047812ULL, 0x000fc800078ec0ffULL,
0x0000000405057219ULL, 0x000fd600000006ffULL, 0x001c1fff281c7589ULL, 0x00026200000e0000ULL,
0x0000000000067806ULL, 0x000fe200038e0100ULL, 0x00000000050473a1ULL, 0x000eb000000e8000ULL,
0x00000000050973c4ULL, 0x000ee20000004000ULL, 0x00000000000b7886ULL, 0x000fc400038e0100ULL,
0x0000000b05ff7c12ULL, 0x004fda000f804004ULL, 0x0000000a09748947ULL, 0x00afea000b800000ULL,
0x001c1fff2a1d7589ULL, 0x0002a800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x000ee800000e0000ULL,
0x001c1fff001f7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff027812ULL, 0x000fe200078ee202ULL,
0x0000000e16097291ULL, 0x000fe2000f8e583fULL, 0x0000000300237812ULL, 0x000fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e0014ULL, 0x000000032fff7812ULL, 0x000fe2000780c0ffULL,
0x0000000802047836ULL, 0x040fe20000000000ULL, 0x0000000423257812ULL, 0x000fe200078efcffULL,
0x0000000802007824ULL, 0x002fe200078e00ffULL, 0x0000000723057812ULL, 0x000fe200078e7802ULL,
0x00000009ff067e24ULL, 0x000fe2000f8e00ffULL, 0x0000000725217812ULL, 0x000fe200078e7802ULL,
0x000000ffff297224ULL, 0x000fe200078e0016ULL, 0x0000000723237812ULL, 0x000fe200078e7804ULL,
0x0001200006027836ULL, 0x000fe20000000000ULL, 0x0000000725257812ULL, 0x000fe200078e7804ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x0000000005057212ULL, 0x080fe200078efcffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0018ULL, 0x0000000021217212ULL, 0x000fe200078efcffULL,
0x000000ffff2b7224ULL, 0x000fe200078e001aULL, 0x0000000423237212ULL, 0x080fe200078efcffULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x0000000425257212ULL, 0x000fe200078efcffULL,
0x000000ffff2c7224ULL, 0x000fe200078e000cULL, 0x0000900701007387ULL, 0x0003e20000100800ULL,
0x000000ffff147224ULL, 0x000fc400078e0015ULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000002805007844ULL, 0x0003e20000000200ULL,
0x000000ffff2d7224ULL, 0x000fe400078e000eULL, 0x000000ffff2e7224ULL, 0x000fe400078e0010ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0012ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000dULL, 0x0000002c21007844ULL, 0x0003e20000000200ULL,
0x0000001023237824ULL, 0x000fe400078e0202ULL, 0x000000ffff167224ULL, 0x000fe400078e0019ULL,
0x000000ffff177224ULL, 0x000fe400078e001bULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x0000001025257824ULL, 0x000fe200078e0202ULL, 0x0000001423007844ULL, 0x0003e20000000200ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0013ULL,
0x00000001ff007424ULL, 0x000fc600078e00ffULL, 0x0000000c25007844ULL, 0x0003e80000000200ULL,
0x0240000803008988ULL, 0x0003e80008000c04ULL, 0x0242001c03008988ULL, 0x01c3e20008000c04ULL,
0x0000000607007c0cULL, 0x000fe2000bf06070ULL, 0x02460800ffff79a7ULL, 0x0003d80008500011ULL,
0xffffff9800508947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000019ff0c7e24ULL, 0x000fe4000f8e00ffULL, 0x00000019ff0d7e24ULL, 0x000fce000f8e00ffULL,
0x0246080dff0075a7ULL, 0x0002620008040147ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0246080dff00a5a7ULL, 0x000e640008040047ULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xfffffef000ec7947ULL, 0x020fea000383ffffULL,
0x00000004ff0c7e24ULL, 0x000fe4000f8e00ffULL, 0x00000004ff0d7e24ULL, 0x000fce000f8e00ffULL,
0x0246180dff0075a7ULL, 0x0002620008040147ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0246180dff00a5a7ULL, 0x000e640008040047ULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff0c00a47947ULL, 0x020fea000383ffffULL,
0x00000004ff0c7e24ULL, 0x000fe4000f8e00ffULL, 0x00000004ff0d7e24ULL, 0x000fce000f8e00ffULL,
0x0246280dff0075a7ULL, 0x0002620008020147ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x0246280dff0095a7ULL, 0x000e640008020047ULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff2400a87947ULL, 0x020fea000383ffffULL,
0x0000000eff047e24ULL, 0x000fe4000f8e00ffULL, 0x0000000eff057e24ULL, 0x000fce000f8e00ffULL,
0x02463805ff0075a7ULL, 0x0002620008020147ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x02463805ff0095a7ULL, 0x000e640008020047ULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff3c00807947ULL, 0x020fea000383ffffULL,
0x024600ffff0075a7ULL, 0x000ee2000800014eULL, 0x0000b0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x024600ffff0085a7ULL, 0x000e64000800004eULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff94009c7947ULL, 0x006fea000383ffffULL,
0x000000ffff087224ULL, 0x100fe400078e001dULL, 0x000000ffff097224ULL, 0x000fce00078e001dULL,
0x02461009ff0075a7ULL, 0x0002620008000151ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x02461009ff0085a7ULL, 0x000e640008000051ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffe800d47947ULL, 0x000fea000383ffffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe400078e001eULL,
0x00000002ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff2e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fce00078e00ffULL, 0x0000000029087348ULL, 0x000fea0003c00000ULL,
0x0c00002d2c2b7389ULL, 0x000924000000002eULL, 0x000000000000791bULL, 0x010fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff2c7224ULL, 0x004fe400078e0008ULL,
0x00000002ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000001fff2e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x00afce00078e002bULL,
0x0000000029087348ULL, 0x000fea0003c00000ULL, 0x0c00002d2c2b7389ULL, 0x000264000000002eULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000091e1d7209ULL, 0x000fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe400078e000aULL, 0x000000ffff1f7224ULL, 0x000fce00078e002bULL,
0x0000000029087348ULL, 0x000fea0003c00000ULL, 0x0c00002d2c2b7389ULL, 0x000264000000002eULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001f081f7209ULL, 0x000fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe400078e000bULL, 0x000000ffff257224ULL, 0x000fce00078e002bULL,
0x0000000029087348ULL, 0x000fea0003c00000ULL, 0x0c00002d2c2b7389ULL, 0x000264000000002eULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000250a267209ULL, 0x000fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe400078e001dULL, 0x00000001ff2d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fce00078e002bULL, 0x0000000029087348ULL, 0x000fea0003c00000ULL,
0x0c00002d2c2b7389ULL, 0x000264000000002eULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000240b247209ULL, 0x000fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe400078e001fULL,
0x000000ffff287224ULL, 0x000fce00078e002bULL, 0x0000000029087348ULL, 0x000fea0003c00000ULL,
0x0c00002d2c2b7389ULL, 0x000264000000002eULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000281d087209ULL, 0x000fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0026ULL,
0x000000ffff2a7224ULL, 0x000fce00078e002bULL, 0x0000000029087348ULL, 0x000fea0003c00000ULL,
0x0c00002d2c2b7389ULL, 0x000264000000002eULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002a1f097209ULL, 0x000fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0024ULL,
0x000000ffff277224ULL, 0x000fce00078e002bULL, 0x0000000029087348ULL, 0x000fea0003c00000ULL,
0x0c00002d2c2b7389ULL, 0x000264000000002eULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x00000027260a7209ULL, 0x000fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e002bULL,
0xffffffec00e87947ULL, 0x000fec000383ffffULL, 0x0000007000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff047424ULL, 0x000fe400078e00ffULL,
0x000000ffff297224ULL, 0x000fce00078e0005ULL, 0x0000000029087348ULL, 0x000fea0003c00000ULL,
0x0000001f2a1f7389ULL, 0x0006e40000000004ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1d7224ULL, 0x004fe400078e001fULL, 0x000000ffff2a7224ULL, 0x002fe400078e001eULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff047424ULL, 0x000fe400078e00ffULL,
0x000000ffff297224ULL, 0x000fce00078e0005ULL, 0x0000000029087348ULL, 0x000fea0003c00000ULL,
0x0000001f2a1f7389ULL, 0x0006e40000000004ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x004fe400078e001fULL, 0x000000ffff2a7224ULL, 0x002fe400078e0000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff047424ULL, 0x000fe400078e00ffULL,
0x000000ffff297224ULL, 0x000fce00078e0005ULL, 0x0000000029087348ULL, 0x000fea0003c00000ULL,
0x0000001f2a1f7389ULL, 0x0006e40000000004ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff400247947ULL, 0x006fea000383ffffULL,
0x0180000035007836ULL, 0x000fe20000000000ULL, 0x0000016000007945ULL, 0x000fe80003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003500008308ULL, 0x0002a20000001000ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x008000000300780cULL, 0x040fe40003f22070ULL, 0x000000ff0300720cULL, 0x000fe40003f05070ULL,
0xffffffffff007807ULL, 0x004fe40004800000ULL, 0x00000001ff037807ULL, 0x000fc60000000000ULL,
0x000000ffff007224ULL, 0x000fca00078e0a00ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000000000248947ULL, 0x000fea0003800000ULL, 0x007fffff35007812ULL, 0x000fc800078ec0ffULL,
0x000000ff0000720cULL, 0x000fc80003f02070ULL, 0xffffffffff007807ULL, 0x000fca0004000000ULL,
0x000000ffff007224ULL, 0x000fca00078e0a00ULL, 0x0000000003ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000035037812ULL, 0x000fd600078ec0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000003500007308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffeac02307950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000024680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000658ULL, 0x0000000000000468ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ac0ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000ae0ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000ae0ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b10ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000b58ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000b60ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000b80ULL, 0x0000000000015400ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015f80ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000015f90ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015f90ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000015f90ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000016678ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016678ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000b58ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000b80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000015400ULL, 0x0000000000015400ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000015f80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015f90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_16_m_16_sm_90_cubin_len = 92104;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
