/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017990ULL, 0x0000000000017510ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000016360ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x00000000000164d0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000016510ULL, 0x00000000000000f0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000016600ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001636000000000ULL, 0x0000040400000000ULL, 0x810c0000007c0400ULL, 0x0058500400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080960828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880809692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001636000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080890828808081ULL, 0x9008288080960828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808090920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x000164d000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080900828808081ULL, 0xa108288080960828ULL, 0x288080a408288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080a4ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0001651000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000eaULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000dULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x000152b000183104ULL, 0x000156c0000156b0ULL,
0x0001581000015800ULL, 0x00f8290400015820ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002705000027ULL, 0x0500002705000027ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000c000f82804ULL, 0x000020d000000100ULL, 0x0000390000003860ULL,
0x000039b000003980ULL, 0x00003e3000003d90ULL, 0x00005bc0000044f0ULL, 0x00005cc000005c60ULL,
0x0000605000005cf0ULL, 0x0000661000006090ULL, 0x00007d5000007cb0ULL, 0x00007df000007dc0ULL,
0x0000817000008140ULL, 0x00009d70000086f0ULL, 0x00009e6000009e00ULL, 0x0000a1c000009e90ULL,
0x0000a8200000a1e0ULL, 0x0000b1200000a830ULL, 0x0000d0300000cf30ULL, 0x0000d6000000d5c0ULL,
0x000150a00000de30ULL, 0x000150e0000150d0ULL, 0x00015120000150f0ULL, 0x0001515000015140ULL,
0x000157f000015160ULL, 0x0001586000015850ULL, 0x00015eb000015870ULL, 0x00015f9000015f20ULL,
0x0001607000016000ULL, 0x00016150000160e0ULL, 0x00016230000161c0ULL, 0x000162f0000162a0ULL,
0x0170390400016340ULL, 0x000000ff00000160ULL, 0x003f010000024600ULL, 0x00000009000001a0ULL,
0x003f013000024608ULL, 0x00000009000001d0ULL, 0x003f013000024610ULL, 0x000000ff00000530ULL,
0x003f010700024600ULL, 0x0000000000000700ULL, 0x003f010200000004ULL, 0x00000000000007c0ULL,
0x003f010100000000ULL, 0x000000ff000035d0ULL, 0x003f01060002460cULL, 0x000000ff00003740ULL,
0x003f01060002460cULL, 0x000000ff000044b0ULL, 0x003f010100024610ULL, 0x000000ff000059e0ULL,
0x003f01060002461cULL, 0x000000ff00005b30ULL, 0x003f01060002461cULL, 0x000000ff000065b0ULL,
0x003f010100024620ULL, 0x000000ff00007ab0ULL, 0x003f01060002462cULL, 0x000000ff00007c00ULL,
0x003f01060002462cULL, 0x000000ff00008690ULL, 0x003f010100024630ULL, 0x000000ff00009bd0ULL,
0x003f01060002463cULL, 0x000000ff00009cf0ULL, 0x003f01060002463cULL, 0x000000ff0000a630ULL,
0x003f010100024640ULL, 0x000000ff0000fba0ULL, 0x003f010600024604ULL, 0x000000ff0000fc30ULL,
0x003f010600024604ULL, 0x00000004000144c0ULL, 0x003f010600024614ULL, 0x00000004000149a0ULL,
0x003f010600024614ULL, 0x0000000400015df0ULL, 0x003f010100024608ULL, 0x00101c0400033803ULL,
0x0000fc800000e270ULL, 0x00015e500000fd30ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001ccULL, 0x0000001100000002ULL, 0x000000000000014cULL, 0x0000001100000002ULL,
0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001a7ULL, 0x0000001100000002ULL, 0x0000000000000122ULL, 0x0000001100000002ULL,
0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000027919ULL, 0x000e620000002300ULL,
0x00000000000479c3ULL, 0x000ea20000002600ULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0x0000580000167a02ULL, 0x000fe20000000f00ULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x00000000000d7919ULL, 0x000ee80000002100ULL, 0x0000000000087919ULL, 0x000f220000002700ULL,
0x0000000102007824ULL, 0x002fc400078e0203ULL, 0x00000004ff037424ULL, 0x000fe400078e00ffULL,
0x0000008000097824ULL, 0x108fe200078e020dULL, 0x00000005ff787819ULL, 0x000fe2000001160dULL,
0x00001fff02007589ULL, 0x000e6200000e0000ULL, 0x00006200080c7625ULL, 0x010fe400078e0003ULL,
0x000000ff0900720cULL, 0x040fe40003f05270ULL, 0x000000030900780cULL, 0x040fe20003f24070ULL,
0x00001fff78787589ULL, 0x000ee200000e0000ULL, 0x0000007f0900780cULL, 0x000fd20003f44070ULL,
0x3fffff80ff048424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff058424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff069424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff079424ULL, 0x000fe200078e00ffULL,
0x02460004ff008388ULL, 0x0009e20000000a00ULL, 0x000000ff0000720cULL, 0x002fe20003f05270ULL,
0xff317217ff0ea424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0a9424ULL, 0x000fe200078e00ffULL,
0x0246080609009388ULL, 0x0009e2000000ca00ULL, 0x7fffff80ff0b9424ULL, 0x000fc600078e00ffULL,
0x0244000e0900a388ULL, 0x0009e80000004800ULL, 0x0246100a09009388ULL, 0x0009e8000000ca00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003a000000947ULL, 0x004fea0003800000ULL,
0x0000000000147919ULL, 0x008e620000000000ULL, 0x0000000478027824ULL, 0x000fe200078e00ffULL,
0x0000000404057899ULL, 0x000fe2000800063fULL, 0x0000001016057824ULL, 0x010fc400078e00ffULL,
0x00000200ff177424ULL, 0x000fe200078e00ffULL, 0x0000000214077211ULL, 0x042fe200078fd8ffULL,
0x0000001014047824ULL, 0x000fe400078e00ffULL, 0x0000000505027e24ULL, 0x000fe2000f8e0208ULL,
0x0000000707057812ULL, 0x040fe400078ec0ffULL, 0x000001f004157812ULL, 0x000fe200078ec0ffULL,
0x0000000102047824ULL, 0x000fe200078e0207ULL, 0x0000000207117810ULL, 0x000fe40007ffe0ffULL,
0x0000001f05067812ULL, 0x000fe200078e7814ULL, 0x00005c0004047625ULL, 0x000fe200078e0017ULL,
0x00000001070b7810ULL, 0x000fc40007ffe0ffULL, 0x00000007110e7812ULL, 0x000fe200078ec0ffULL,
0x0000002007097824ULL, 0x040fe200078e0206ULL, 0x0000000307137810ULL, 0x000fe20007ffe0ffULL,
0x0000000102067824ULL, 0x000fe200078e020bULL, 0x000000070b077812ULL, 0x000fe200078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0x0000001f0e107812ULL, 0x000fe200078e7814ULL,
0x0000000102127824ULL, 0x000fe200078e0213ULL, 0x00000007130f7812ULL, 0x000fe400078ec0ffULL,
0x00000015040e7210ULL, 0x000fc40007f1e0ffULL, 0x0000001f070a7812ULL, 0x100fe200078e7814ULL,
0x0000000102077824ULL, 0x000fe200078e0211ULL, 0x0000001f0f147812ULL, 0x000fe200078e7814ULL,
0x000000ffff0f7224ULL, 0x000fe200000e0605ULL, 0x0000001011107211ULL, 0x000fe200078e28ffULL,
0x00005c0006047625ULL, 0x000fc600078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000b901c46ULL, 0x000000200b027824ULL, 0x000fe200078e020aULL,
0x0000001504047210ULL, 0x000fe20007f1e0ffULL, 0x00005c0007067625ULL, 0x000fc800078e0017ULL,
0x00005c00120a7625ULL, 0x000fe200078e0017ULL, 0x0000001506067210ULL, 0x000fc60007f3e0ffULL,
0x0000002013147824ULL, 0x000fe200078e0214ULL, 0x000000150a0a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe400000e0605ULL, 0x0000001002117824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400008e0607ULL, 0x0000001010137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0b7224ULL, 0x000fc400010e060bULL,
0x0000001014157824ULL, 0x000fe200078e00ffULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x000000000a157faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x02460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060c2e7981ULL, 0x008ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000ee20000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000005ff797e24ULL, 0x008fe2000f8e00ffULL,
0x0000003f2e2f7810ULL, 0x004fc40007ffe0ffULL, 0x000000ff2e2d7810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff2f7819ULL, 0x000fe4000001162fULL, 0x00000008ff2d7819ULL, 0x000fca000001162dULL,
0x0000dc5000008947ULL, 0x000fea0003800000ULL, 0x0000000479767824ULL, 0x000fe200078e00ffULL,
0x0002461078007811ULL, 0x000fe400078e20ffULL, 0x0000000300077802ULL, 0x012fe40000000f00ULL,
0x0000002f7600720cULL, 0x000fda0003f06070ULL, 0x0000640076058a10ULL, 0x000fe20007ffe0ffULL,
0x0000000208028824ULL, 0x000fc800078e00ffULL, 0x0000640002048a24ULL, 0x000fe400078e0205ULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040700ff738cULL, 0x0003e20000000000ULL, 0x0000600004048625ULL, 0x000fe200078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000179067810ULL, 0x000fe20007ffe0ffULL,
0x0000000604028981ULL, 0x000562000c1e1900ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000004016077824ULL, 0x002fe200078e00ffULL, 0x0000002d0600720cULL, 0x000fe20003f06070ULL,
0x0000000000ff7f8cULL, 0x0005d8000c80043fULL, 0x00000be000008947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x004e620000000000ULL, 0x0000010079057824ULL, 0x000fe400078e00ffULL,
0x0000000407027e24ULL, 0x020fe4000f8e0202ULL, 0x00000200ff357424ULL, 0x000fe200078e00ffULL,
0x000000052e007217ULL, 0x000fca0007800000ULL, 0x0000000100007824ULL, 0x000fca00078e0a05ULL,
0x0000004000007817ULL, 0x000fe40003800000ULL, 0x00000003ff097819ULL, 0x002fe40000011604ULL,
0x0ffffff8040b7812ULL, 0x000fe400078ec0ffULL, 0x00000004090d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000409067212ULL, 0x080fe400078e3cffULL, 0x000000040d0a7212ULL, 0x040fe200078e3cffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0x0000001009117810ULL, 0x000fc40007ffe0ffULL,
0x000000070b067812ULL, 0x000fe400078ef806ULL, 0xfffffff80f0c7812ULL, 0x000fe200078ee20aULL,
0x0000000811137824ULL, 0x000fe200078e00ffULL, 0x0000000c090f7810ULL, 0x040fe40007ffe0ffULL,
0x00000008090b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c09237810ULL, 0x000fe20007ffe0ffULL,
0x000000080f127824ULL, 0x000fe200078e00ffULL, 0x00000014091f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x000000040f077212ULL, 0x080fe200078e3cffULL,
0x00000008231a7824ULL, 0x000fe200078e00ffULL, 0x00000004110a7212ULL, 0x000fe200078e3cffULL,
0x000000081f157824ULL, 0x000fe200078e00ffULL, 0x0000002009257810ULL, 0x000fc40007ffe0ffULL,
0xfffffff812127812ULL, 0x000fe400078ee207ULL, 0x0000001809217810ULL, 0x040fe40007ffe0ffULL,
0x0000002c092b7810ULL, 0x000fe40007ffe0ffULL, 0x000000040b057212ULL, 0x080fe200078e3cffULL,
0x0000000821187824ULL, 0x000fe200078e00ffULL, 0x0000000423077212ULL, 0x080fe200078e3cffULL,
0x000000082b227824ULL, 0x000fe200078e00ffULL, 0x000000041f107212ULL, 0x000fc400078e3cffULL,
0xfffffff813147812ULL, 0x000fe400078ee20aULL, 0x0000002409277810ULL, 0x000fe40007ffe0ffULL,
0x00000004250a7212ULL, 0x040fe400078e3cffULL, 0x0000000325137819ULL, 0x000fe400000006ffULL,
0x0000003009317810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fc400078ee205ULL,
0xfffffff81a1a7812ULL, 0x000fe400078ee207ULL, 0x0000002809297810ULL, 0x000fe40007ffe0ffULL,
0xfffffff815167812ULL, 0x000fe200078ee210ULL, 0x0000000827157824ULL, 0x000fe200078e00ffULL,
0x0000000421057212ULL, 0x080fe200078e3cffULL, 0x0000000829207824ULL, 0x000fe200078e00ffULL,
0x000000042b077212ULL, 0x080fe400078e3cffULL, 0xfffffff8131c7812ULL, 0x000fe200078ee20aULL,
0x0000000831137824ULL, 0x000fe200078e00ffULL, 0x0000000427107212ULL, 0x000fc400078e3cffULL,
0x0000003409337810ULL, 0x000fe40007ffe0ffULL, 0x00000004310a7212ULL, 0x080fe400078e3cffULL,
0xfffffff818187812ULL, 0x000fe400078ee205ULL, 0xfffffff822227812ULL, 0x000fe400078ee207ULL,
0x0000000429057212ULL, 0x000fe400078e3cffULL, 0x0000003f09077812ULL, 0x000fc400078ec0ffULL,
0x000000000d00720cULL, 0x080fe40003f26070ULL, 0xfffffff8151e7812ULL, 0x000fe200078ee210ULL,
0x0000000833157824ULL, 0x000fe200078e00ffULL, 0x0000003f0d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000102077824ULL, 0x040fe200078e0207ULL, 0x000000000b00720cULL, 0x000fe40003f46070ULL,
0xfffffff813247812ULL, 0x000fe200078ee20aULL, 0x00000001020a7824ULL, 0x000fe200078e020dULL,
0x0000003f0b0b7812ULL, 0x000fc400078ec0ffULL, 0x000000000f00720cULL, 0x000fe40003f66070ULL,
0x0000000433107212ULL, 0x000fe200078e3cffULL, 0x00000001020d7824ULL, 0x000fe200078e020bULL,
0x0001400078137811ULL, 0x000fe200078e70ffULL, 0x00005e000a0a7625ULL, 0x080fe200078e0035ULL,
0x0000003f0f0f7812ULL, 0x000fe400078ec0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee205ULL,
0x0000000878057824ULL, 0x000fe200078e00ffULL, 0xfffffff815267812ULL, 0x000fe200078ee210ULL,
0x0000001006157824ULL, 0x000fe200078e0213ULL, 0x000000000900720cULL, 0x000fe20003f06070ULL,
0x00005e0007067625ULL, 0x000fe200078e0035ULL, 0x0000000f020f7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff805057812ULL, 0x000fe200078ee204ULL, 0x000000100c177824ULL, 0x100fe200078e0213ULL,
0x000000001100720cULL, 0x040fe20003f86070ULL, 0x000000100e197824ULL, 0x000fe200078e0213ULL,
0x0000003f11117812ULL, 0x000fe200078ec0ffULL, 0x00005e000d0c7625ULL, 0x000fc800078e0035ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0035ULL, 0x0000001005067825ULL, 0x000fc800078e0006ULL,
0x00000010050a7825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006157faeULL, 0x0003e2000c101c46ULL, 0x000000001f00720cULL, 0x080fe40003f06070ULL,
0x00000010050c7825ULL, 0x000fe200078e000cULL, 0x000000000a177faeULL, 0x0005e2000c901c46ULL,
0x0000003f1f1f7812ULL, 0x000fe400078ec0ffULL, 0x00000010121b7824ULL, 0x000fe200078e0213ULL,
0x000000000c197faeULL, 0x0007e2000d101c46ULL, 0x00000010050e7825ULL, 0x000fe200078e000eULL,
0x000000002100720cULL, 0x000fc40003f26070ULL, 0x0000003f21217812ULL, 0x000fe200078ec0ffULL,
0x0000000102117824ULL, 0x040fe200078e0211ULL, 0x000000000e1b7faeULL, 0x0009e2000d901c46ULL,
0x000000002300720cULL, 0x0c0fe20003f46070ULL, 0x0000000102067824ULL, 0x042fe200078e021fULL,
0x0000003f23237812ULL, 0x000fe200078ec0ffULL, 0x00005e0011107625ULL, 0x000fe200078e0035ULL,
0x000000002500720cULL, 0x040fe40003f66070ULL, 0x0000003f25257812ULL, 0x000fe200078ec0ffULL,
0x00000001020a7824ULL, 0x004fe200078e0221ULL, 0x000000131a177211ULL, 0x000fe200078e20ffULL,
0x00000001020c7824ULL, 0x008fc400078e0223ULL, 0x00000001020e7824ULL, 0x010fe200078e0225ULL,
0x00000038091b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010141d7824ULL, 0x000fe400078e0213ULL,
0x0000001005107825ULL, 0x000fe200078e0010ULL, 0x000000001b00720cULL, 0x000fc60003fa6070ULL,
0x00005e0006067625ULL, 0x080fe200078e0035ULL, 0x00000000101d7faeULL, 0x0003e2000e101c46ULL,
0x000000003300720cULL, 0x040fe40003f86070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0035ULL,
0x0000003f33337812ULL, 0x000fc600078ec0ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e0035ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0035ULL, 0x0000003c091d7810ULL, 0x002fe40007ffe0ffULL,
0x000000041b097212ULL, 0x000fe200078e3cffULL, 0x0000001016117824ULL, 0x000fe200078e0213ULL,
0x000000001d00720cULL, 0x000fe20003fc6070ULL, 0x0000001005067825ULL, 0x000fc800078e0006ULL,
0x0000001018157824ULL, 0x000fe200078e0213ULL, 0x0000000006117faeULL, 0x0003e2000c101c46ULL,
0x00000010050a7825ULL, 0x000fe200078e000aULL, 0x000000002700720cULL, 0x0c0fe40003f06070ULL,
0x0000003f27277812ULL, 0x000fe200078ec0ffULL, 0x00000010050c7825ULL, 0x000fe200078e000cULL,
0x000000000a157faeULL, 0x0005e2000c901c46ULL, 0x000000002900720cULL, 0x080fe40003f26070ULL,
0x000000101c197824ULL, 0x000fe200078e0213ULL, 0x000000000c177faeULL, 0x0007e2000d101c46ULL,
0x00000010050e7825ULL, 0x000fe200078e000eULL, 0x000000002b00720cULL, 0x000fc40003f46070ULL,
0x0000003f29297812ULL, 0x000fe200078ec0ffULL, 0x000000081b107824ULL, 0x000fe200078e00ffULL,
0x000000000e197faeULL, 0x0009e2000d901c46ULL, 0x000000003100720cULL, 0x000fe20003f66070ULL,
0x000000081d167824ULL, 0x000fe200078e00ffULL, 0x0000003f2b2b7812ULL, 0x000fe200078ec0ffULL,
0x0000000102067824ULL, 0x042fe200078e0227ULL, 0x0000003f31317812ULL, 0x000fe200078ec0ffULL,
0x00000001020a7824ULL, 0x044fe200078e0229ULL, 0x0000003f1b1b7812ULL, 0x000fe200078ec0ffULL,
0x00000001020c7824ULL, 0x008fe200078e022bULL, 0x0000003f1d077812ULL, 0x000fe200078ec0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0035ULL, 0xfffffff810007812ULL, 0x000fc400078ee209ULL,
0x000000041d097212ULL, 0x000fe200078e3cffULL, 0x00000001020e7824ULL, 0x010fe200078e0231ULL,
0x0000001320177211ULL, 0x000fe200078e20ffULL, 0x0000000102107824ULL, 0x040fe400078e0233ULL,
0x0000000102127824ULL, 0x040fe400078e021bULL, 0x0000000102147824ULL, 0x000fe200078e0207ULL,
0xfffffff816027812ULL, 0x000fe200078ee209ULL, 0x00005e0006067625ULL, 0x000fc800078e0035ULL,
0x00005e000c0c7625ULL, 0x000fc800078e0035ULL, 0x00005e000e0e7625ULL, 0x000fc800078e0035ULL,
0x000000101e097824ULL, 0x100fe400078e0213ULL, 0x0000001022197824ULL, 0x100fe400078e0213ULL,
0x00000010241b7824ULL, 0x100fe400078e0213ULL, 0x00000010261d7824ULL, 0x100fe400078e0213ULL,
0x00000010001f7824ULL, 0x100fe400078e0213ULL, 0x0000001002217824ULL, 0x000fc400078e0213ULL,
0x00005e0010107625ULL, 0x000fc800078e0035ULL, 0x00005e0012127625ULL, 0x000fc800078e0035ULL,
0x00005e0014147625ULL, 0x000fc800078e0035ULL, 0x0000001005067825ULL, 0x000fc800078e0006ULL,
0x00000010050a7825ULL, 0x040fe200078e000aULL, 0x0000000006097faeULL, 0x0003e6000c101c46ULL,
0x00000010050c7825ULL, 0x040fe200078e000cULL, 0x000000000a177faeULL, 0x0003e6000c901c46ULL,
0x00000010050e7825ULL, 0x040fe200078e000eULL, 0x000000000c197faeULL, 0x0003e6000d101c46ULL,
0x0000001005107825ULL, 0x040fe200078e0010ULL, 0x000000000e1b7faeULL, 0x0003e6000d901c46ULL,
0x0000001005127825ULL, 0x040fe200078e0012ULL, 0x00000000101d7faeULL, 0x0003e6000e101c46ULL,
0x0000001005147825ULL, 0x000fe200078e0014ULL, 0x00000000121f7faeULL, 0x0003e8000e901c46ULL,
0x0000000014217faeULL, 0x0003e2000f101c46ULL, 0x00000a9000007947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x004e620000000000ULL, 0x0000000407027e24ULL, 0x020fc4000f8e0202ULL,
0x00000200ff247424ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x002fe40000011604ULL,
0x0ffffff804097812ULL, 0x000fe400078ec0ffULL, 0x00000004050d7810ULL, 0x040fe40007ffe0ffULL,
0x0000001005137810ULL, 0x000fe40007ffe0ffULL, 0x000000040d067212ULL, 0x040fe200078e3cffULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0x00000020051b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x00000008050f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8110a7812ULL, 0x000fe200078ee206ULL, 0x000000081b187824ULL, 0x000fe200078e00ffULL,
0x0000000c05117810ULL, 0x000fe20007ffe0ffULL, 0x000000080f0c7824ULL, 0x000fe200078e00ffULL,
0x0000000413077212ULL, 0x080fe400078e3cffULL, 0x0000000411067212ULL, 0x040fe200078e3cffULL,
0x0000000811197824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe400078ee207ULL,
0x0000003005237810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8190e7812ULL, 0x000fe400078ee206ULL,
0x0000001c05197810ULL, 0x000fe20007ffe0ffULL, 0x0000000823207824ULL, 0x000fe200078e00ffULL,
0x0000001405157810ULL, 0x000fe40007ffe0ffULL, 0x0000000419067212ULL, 0x040fe400078e3cffULL,
0x0000000319217819ULL, 0x000fe200000006ffULL, 0x0000000815127824ULL, 0x000fe200078e00ffULL,
0x0000001805177810ULL, 0x000fc40007ffe0ffULL, 0x000000041b077212ULL, 0x080fe400078e3cffULL,
0x0000000405007212ULL, 0x080fe200078e3cffULL, 0x0000000817147824ULL, 0x000fe200078e00ffULL,
0x000000040f0b7212ULL, 0x000fe400078e3cffULL, 0xfffffff821167812ULL, 0x000fe400078ee206ULL,
0xfffffff818187812ULL, 0x000fe400078ee207ULL, 0x0000002c05217810ULL, 0x000fc40007ffe0ffULL,
0x0000000709007812ULL, 0x000fe400078ef800ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL,
0x0000000821297824ULL, 0x000fe200078e00ffULL, 0x00000024051d7810ULL, 0x040fe40007ffe0ffULL,
0x00000028051f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000423077212ULL, 0x080fe200078e3cffULL,
0x000000081d1a7824ULL, 0x000fe200078e00ffULL, 0x0000000415097212ULL, 0x080fe200078e3cffULL,
0x000000081f1c7824ULL, 0x000fe200078e00ffULL, 0x00000004170b7212ULL, 0x000fc400078e3cffULL,
0xfffffff820207812ULL, 0x000fe400078ee207ULL, 0xfffffff812127812ULL, 0x000fe400078ee209ULL,
0xfffffff814147812ULL, 0x000fe400078ee20bULL, 0x0000003405257810ULL, 0x040fe40007ffe0ffULL,
0x0000003805277810ULL, 0x000fe40007ffe0ffULL, 0x0000000421067212ULL, 0x080fe200078e3cffULL,
0x0000000825227824ULL, 0x000fe200078e00ffULL, 0x0000003f05077812ULL, 0x000fe200078ec0ffULL,
0x0000000827267824ULL, 0x000fe200078e00ffULL, 0x000000041d097212ULL, 0x000fc400078e3cffULL,
0x000000041f0b7212ULL, 0x000fe200078e3cffULL, 0x0000000102077824ULL, 0x000fe200078e0207ULL,
0x0000003c05057810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8291e7812ULL, 0x000fe200078ee206ULL,
0x00005e0007067625ULL, 0x000fe200078e0024ULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee209ULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee20bULL, 0x0000003f05297812ULL, 0x000fc400078ec0ffULL,
0x0000000405287212ULL, 0x0c0fe200078e3cffULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0x0000000425097212ULL, 0x080fe200078e3cffULL, 0x0000000102497824ULL, 0x000fe200078e0229ULL,
0x00000004270b7212ULL, 0x000fe400078e3cffULL, 0x0000003f0d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000003f0f0f7812ULL, 0x000fe400078ec0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee209ULL,
0x0000000878097824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20bULL,
0x00000001020f7824ULL, 0x000fe200078e020fULL, 0x0000003f11117812ULL, 0x000fc400078ec0ffULL,
0x0000003f27277812ULL, 0x000fe400078ec0ffULL, 0x00014000780b7811ULL, 0x000fe200078e70ffULL,
0x0000000102117824ULL, 0x040fe200078e0211ULL, 0x0000003f13137812ULL, 0x000fe200078ec0ffULL,
0x0000000102457824ULL, 0x000fe200078e0227ULL, 0xfffffff805287812ULL, 0x000fe200078ee228ULL,
0x0000001000057824ULL, 0x000fe200078e020bULL, 0x0000003f15157812ULL, 0x000fe200078ec0ffULL,
0x0000000102137824ULL, 0x040fe200078e0213ULL, 0x0000000d020d7210ULL, 0x000fe20007ffe0ffULL,
0x000000100a277824ULL, 0x100fe200078e020bULL, 0x0000003f17177812ULL, 0x000fe200078ec0ffULL,
0x000000100c297824ULL, 0x100fe200078e020bULL, 0x0000003f19197812ULL, 0x000fe200078ec0ffULL,
0x000000100e2b7824ULL, 0x100fe200078e020bULL, 0x0000003f1b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000001010317824ULL, 0x100fe200078e020bULL, 0xfffffff809097812ULL, 0x000fe200078ee204ULL,
0x0000001012337824ULL, 0x100fe200078e020bULL, 0x0000003f1d1d7812ULL, 0x000fe200078ec0ffULL,
0x0000001014357824ULL, 0x100fe200078e020bULL, 0x0000000b1a3b7211ULL, 0x000fe200078e20ffULL,
0x0000001016377824ULL, 0x100fe200078e020bULL, 0x0000003f1f1f7812ULL, 0x000fe200078ec0ffULL,
0x0000001018397824ULL, 0x100fe200078e020bULL, 0x0000003f21217812ULL, 0x000fe200078ec0ffULL,
0x000000101c3d7824ULL, 0x100fe200078e020bULL, 0x0000003f23237812ULL, 0x000fe200078ec0ffULL,
0x000000101e3f7824ULL, 0x100fe200078e020bULL, 0x0000003f25257812ULL, 0x000fe200078ec0ffULL,
0x0000001020417824ULL, 0x000fc400078e020bULL, 0x0000001022437824ULL, 0x100fe200078e020bULL,
0x0000002502257210ULL, 0x000fe20007ffe0ffULL, 0x0000001026477824ULL, 0x100fe400078e020bULL,
0x00000010284b7824ULL, 0x000fe400078e020bULL, 0x0000000102157824ULL, 0x000fe400078e0215ULL,
0x00005e000d0a7625ULL, 0x000fc800078e0024ULL, 0x0000000102177824ULL, 0x000fe400078e0217ULL,
0x00005e000f0c7625ULL, 0x000fc800078e0024ULL, 0x0000000102197824ULL, 0x000fe400078e0219ULL,
0x00005e00110e7625ULL, 0x000fc800078e0024ULL, 0x00000001021b7824ULL, 0x000fe400078e021bULL,
0x00005e0013107625ULL, 0x000fc800078e0024ULL, 0x00000001021d7824ULL, 0x000fe400078e021dULL,
0x0000001009067825ULL, 0x000fc800078e0006ULL, 0x00005e0015127625ULL, 0x080fe200078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e6000b901c46ULL,
0x00000001021f7824ULL, 0x000fe400078e021fULL, 0x00005e0017147625ULL, 0x000fc800078e0024ULL,
0x0000000102217824ULL, 0x000fe400078e0221ULL, 0x00005e0019167625ULL, 0x000fc800078e0024ULL,
0x00000010090a7825ULL, 0x000fc800078e000aULL, 0x0000000102237824ULL, 0x000fe200078e0223ULL,
0x000000000a277faeULL, 0x0005e2000b901c46ULL, 0x00005e001b187625ULL, 0x000fc800078e0024ULL,
0x00000010090c7825ULL, 0x000fc800078e000cULL, 0x00005e001d1a7625ULL, 0x000fe200078e0024ULL,
0x000000000c297faeULL, 0x0005e6000b901c46ULL, 0x00000010090e7825ULL, 0x000fc800078e000eULL,
0x00005e001f1c7625ULL, 0x000fe200078e0024ULL, 0x000000000e2b7faeULL, 0x0005e6000b901c46ULL,
0x0000001009107825ULL, 0x000fc800078e0010ULL, 0x00005e0021067625ULL, 0x002fe200078e0024ULL,
0x0000000010317faeULL, 0x0005e6000b901c46ULL, 0x0000001009127825ULL, 0x000fc800078e0012ULL,
0x00005e00231e7625ULL, 0x000fe200078e0024ULL, 0x0000000012337faeULL, 0x0005e6000b901c46ULL,
0x0000001009147825ULL, 0x000fc800078e0014ULL, 0x00005e0025207625ULL, 0x000fe200078e0024ULL,
0x0000000014357faeULL, 0x0005e6000b901c46ULL, 0x0000001009167825ULL, 0x000fc800078e0016ULL,
0x00005e0045227625ULL, 0x000fe200078e0024ULL, 0x0000000016377faeULL, 0x0005e6000b901c46ULL,
0x0000001009187825ULL, 0x000fc800078e0018ULL, 0x00005e0049247625ULL, 0x000fe200078e0024ULL,
0x0000000018397faeULL, 0x0005e6000b901c46ULL, 0x00000010091a7825ULL, 0x000fc800078e001aULL,
0x00000010091c7825ULL, 0x040fe200078e001cULL, 0x000000001a3b7faeULL, 0x0005e6000b901c46ULL,
0x0000001009067825ULL, 0x040fe200078e0006ULL, 0x000000001c3d7faeULL, 0x0005e6000b901c46ULL,
0x00000010091e7825ULL, 0x040fe200078e001eULL, 0x00000000063f7faeULL, 0x0005e6000b901c46ULL,
0x0000001009207825ULL, 0x040fe200078e0020ULL, 0x000000001e417faeULL, 0x0005e6000b901c46ULL,
0x0000001009227825ULL, 0x040fe200078e0022ULL, 0x0000000020437faeULL, 0x0005e6000b901c46ULL,
0x0000001009247825ULL, 0x000fe200078e0024ULL, 0x0000000022477faeULL, 0x0005e8000b901c46ULL,
0x00000000244b7faeULL, 0x0005e4000b901c46ULL, 0x0000000176767810ULL, 0x000fe20007ffe0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x0000002f7600720cULL, 0x000fda0003f06070ULL,
0x0000640076008a10ULL, 0x000fe20007ffe0ffULL, 0x0000000208058824ULL, 0x000fc800078e00ffULL,
0x0000640005008a24ULL, 0x000fe400078e0200ULL, 0xffffffffff057424ULL, 0x000fe400078e00ffULL,
0x0000600000028625ULL, 0x000fca00078e0003ULL, 0x0000000602058981ULL, 0x000762000c1e1900ULL,
0x0000002d7900720cULL, 0x000fe20003f06070ULL, 0xff317217ff067424ULL, 0x006fe200078e00ffULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x000086a000000947ULL, 0x000fea0003800000ULL,
0x0000000208037824ULL, 0x008fe200078e00ffULL, 0x0000640000087a02ULL, 0x000fe20000000f00ULL,
0xff317217ff067424ULL, 0x000fe200078e00ffULL, 0x00007610ff097816ULL, 0x000fe20000000009ULL,
0x000000ffff317224ULL, 0x000fc400078e00ffULL, 0x0000640003087624ULL, 0x000fe400078e0208ULL,
0x000000ffff637224ULL, 0x000fe400078e00ffULL, 0x00000100790b7824ULL, 0x000fca00078e00ffULL,
0x0000002e0b00720cULL, 0x000fda0003f06070ULL, 0x000085a000000947ULL, 0x000fea0003800000ULL,
0x0000000179007810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002d0000720cULL, 0x000fe20003f06070ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0031ULL,
0x00000001310d7812ULL, 0x000fe400078e0cffULL, 0x000000400b037810ULL, 0x000fd20007ffe0ffULL,
0x00000ae000008947ULL, 0x000fea0003800000ULL, 0x00000003ff237819ULL, 0x000fe20000011604ULL,
0x00005800ff007624ULL, 0x000fe200078e00ffULL, 0x0000020000277802ULL, 0x000fe20000000f00ULL,
0x0000000878257824ULL, 0x000fe200078e00ffULL, 0x0000000423137810ULL, 0x040fe20007ffe0ffULL,
0x0000004000007824ULL, 0x000fe200078e00ffULL, 0x0000000823157810ULL, 0x040fe40007ffe0ffULL,
0x0000000c23177810ULL, 0x000fe20007ffe0ffULL, 0x00000008131b7824ULL, 0x040fe200078e00ffULL,
0x0000000413027212ULL, 0x080fe200078e3cffULL, 0x0000000400057e24ULL, 0x020fe2000f8e0205ULL,
0x0000000415007212ULL, 0x040fe200078e3cffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0x0000001423337810ULL, 0x000fe20007ffe0ffULL, 0x00000008171f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fc400078ee202ULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee200ULL,
0x0000001823377810ULL, 0x040fe40007ffe0ffULL, 0x0000002023437810ULL, 0x000fe40007ffe0ffULL,
0x0000000417027212ULL, 0x080fe200078e3cffULL, 0x00000008373d7824ULL, 0x000fe200078e00ffULL,
0x0000000433007212ULL, 0x000fe200078e3cffULL, 0x0000000843457824ULL, 0x000fe200078e00ffULL,
0x0000000333357819ULL, 0x000fc400000006ffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee202ULL,
0xfffffff835357812ULL, 0x000fe400078ee200ULL, 0x0000002423477810ULL, 0x040fe40007ffe0ffULL,
0x0000002c235b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000437027212ULL, 0x080fe200078e3cffULL,
0x0000000847497824ULL, 0x000fe200078e00ffULL, 0x0000000443007212ULL, 0x000fe200078e3cffULL,
0x000000085b697824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fc400078ee202ULL,
0xfffffff845457812ULL, 0x000fe400078ee200ULL, 0x00000030236b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000447027212ULL, 0x080fe400078e3cffULL, 0x000000045b007212ULL, 0x000fe200078e3cffULL,
0x000000086b6d7824ULL, 0x000fe200078e00ffULL, 0x0000001023197810ULL, 0x000fe40007ffe0ffULL,
0xfffffff849497812ULL, 0x000fc400078ee202ULL, 0xfffffff869697812ULL, 0x000fe200078ee200ULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0x000000046b027212ULL, 0x080fe400078e3cffULL,
0x000000032e007217ULL, 0x000fe40007800000ULL, 0x0000001c233f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee202ULL, 0x0000000278027824ULL, 0x000fe200078e020dULL,
0x00000004190c7212ULL, 0x000fe200078e3cffULL, 0x0000000100007824ULL, 0x000fe200078e0a03ULL,
0x00000007230f7812ULL, 0x000fe200078e4804ULL, 0x000000083f417824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fc400078ee20cULL, 0x00000028234b7810ULL, 0x000fe40007ffe0ffULL,
0x000000043f0c7212ULL, 0x000fe400078e3cffULL, 0x0001400002027811ULL, 0x000fe200078e68ffULL,
0x000000084b597824ULL, 0x000fe200078e00ffULL, 0x0ffffff80f0f7812ULL, 0x000fe400078ef804ULL,
0x0000004000007817ULL, 0x000fe20003800000ULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x0000003f050e7812ULL, 0x000fe200078ef823ULL, 0x000000100f117824ULL, 0x100fe200078e0202ULL,
0x0000003f05127812ULL, 0x000fe200078ef813ULL, 0x000000101d1d7824ULL, 0x000fe200078e0202ULL,
0x0000003f05147812ULL, 0x000fe200078ef815ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0027ULL,
0xfffffff841417812ULL, 0x000fc400078ee20cULL, 0x00000034236f7810ULL, 0x000fe20007ffe0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x000000002300720cULL, 0x000fe20003f26070ULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x0000003f05167812ULL, 0x000fe200078ef817ULL,
0x000000086f717824ULL, 0x000fe200078e00ffULL, 0x000000044b0c7212ULL, 0x000fe400078e3cffULL,
0x000000001300720cULL, 0x000fe20003f46070ULL, 0x00005e0012127625ULL, 0x000fe200078e0027ULL,
0x0000003f05187812ULL, 0x000fc400078ef819ULL, 0x000000001500720cULL, 0x080fe20003f66070ULL,
0x00005e0014147625ULL, 0x080fe200078e0027ULL, 0xfffffff825257812ULL, 0x000fe400078ee204ULL,
0x000000001700720cULL, 0x080fe20003f86070ULL, 0x00005e0016167625ULL, 0x080fe200078e0027ULL,
0x000000001900720cULL, 0x000fe40003fa6070ULL, 0xfffffff859597812ULL, 0x000fe200078ee20cULL,
0x00005e0018187625ULL, 0x000fe200078e0027ULL, 0x000000046f0c7212ULL, 0x000fc400078e3cffULL,
0x0000003f051a7812ULL, 0x000fe200078ef837ULL, 0x00000010250e7825ULL, 0x000fe200078e000eULL,
0xfffffff871717812ULL, 0x000fe400078ee20cULL, 0x0000003f050c7812ULL, 0x000fe200078ef833ULL,
0x0000001025127825ULL, 0x000fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e2000c901c46ULL, 0x0000003f051c7812ULL, 0x000fe400078ef83fULL,
0x0000001025147825ULL, 0x000fe200078e0014ULL, 0x00000000121b7faeULL, 0x0005e2000d101c46ULL,
0x000000003300720cULL, 0x000fc40003f26070ULL, 0x0000001025167825ULL, 0x000fe200078e0016ULL,
0x0000003f051e7812ULL, 0x000fe200078ef843ULL, 0x00000000141d7faeULL, 0x0007e2000d901c46ULL,
0x000000003700720cULL, 0x080fe20003f46070ULL, 0x0000001025187825ULL, 0x000fe200078e0018ULL,
0x0000003f05207812ULL, 0x000fe200078ef847ULL, 0x00000000161f7faeULL, 0x0009e2000e101c46ULL,
0x000000003f00720cULL, 0x080fe20003f66070ULL, 0x00005e000c0e7625ULL, 0x082fe200078e0027ULL,
0x000000004300720cULL, 0x080fe20003f86070ULL, 0x0000000018217faeULL, 0x0003e2000e901c46ULL,
0x000000004700720cULL, 0x000fe20003fa6070ULL, 0x00005e001a127625ULL, 0x004fe200078e0027ULL,
0x0000003823337810ULL, 0x000fc40007ffe0ffULL, 0x0000003c23237810ULL, 0x000fe20007ffe0ffULL,
0x00005e001c147625ULL, 0x008fc600078e0027ULL, 0x000000002300720cULL, 0x000fe20003fc6070ULL,
0x00005e001e167625ULL, 0x090fe200078e0027ULL, 0x0000003f051a7812ULL, 0x000fe400078ef823ULL,
0x00000004230c7212ULL, 0x000fe200078e3cffULL, 0x00005e0020187625ULL, 0x002fc800078e0027ULL,
0x0000001035117824ULL, 0x000fe400078e0202ULL, 0x00000010250e7825ULL, 0x000fc800078e000eULL,
0x000000103d1b7824ULL, 0x000fe200078e0202ULL, 0x000000000e117faeULL, 0x0003e2000c901c46ULL,
0x0000001025127825ULL, 0x000fe200078e0012ULL, 0x000000004b00720cULL, 0x000fc60003f26070ULL,
0x00000010411d7824ULL, 0x000fe200078e0202ULL, 0x00000000121b7faeULL, 0x0005e2000d101c46ULL,
0x0000001025147825ULL, 0x000fe200078e0014ULL, 0x000000005b00720cULL, 0x000fc60003f46070ULL,
0x00000010451f7824ULL, 0x000fe200078e0202ULL, 0x00000000141d7faeULL, 0x0007e2000d901c46ULL,
0x0000001025167825ULL, 0x000fe200078e0016ULL, 0x000000006b00720cULL, 0x080fe40003f66070ULL,
0x0000003f050e7812ULL, 0x002fe200078ef84bULL, 0x0000001049217824ULL, 0x000fe200078e0202ULL,
0x00000000161f7faeULL, 0x0003e2000e101c46ULL, 0x0000001025187825ULL, 0x000fe200078e0018ULL,
0x000000006f00720cULL, 0x080fe40003f86070ULL, 0x0000003f05127812ULL, 0x004fe200078ef85bULL,
0x00000008330f7824ULL, 0x040fe200078e00ffULL, 0x0000000018217faeULL, 0x0005e2000e901c46ULL,
0x000000003300720cULL, 0x040fe20003fa6070ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0027ULL,
0x0000000433007212ULL, 0x000fc400078e3cffULL, 0x0000003f05147812ULL, 0x048fe200078ef86bULL,
0x00005e0012127625ULL, 0x080fe200078e0027ULL, 0x0000003f05167812ULL, 0x002fe400078ef86fULL,
0x0000000323117819ULL, 0x000fe200000006ffULL, 0x00005e0014147625ULL, 0x080fe200078e0027ULL,
0x0000003f05187812ULL, 0x004fe400078ef833ULL, 0xfffffff80f217812ULL, 0x000fe200078ee200ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0027ULL, 0xfffffff811237812ULL, 0x000fc600078ee20cULL,
0x00005e0016167625ULL, 0x000fc800078e0027ULL, 0x00005e0018187625ULL, 0x000fc800078e0027ULL,
0x0000001059057824ULL, 0x000fe400078e0202ULL, 0x00000010250e7825ULL, 0x000fc800078e000eULL,
0x0000001069117824ULL, 0x000fe200078e0202ULL, 0x000000000e057faeULL, 0x0003e2000c901c46ULL,
0x0000001025127825ULL, 0x000fc800078e0012ULL, 0x000000106d1d7824ULL, 0x000fe200078e0202ULL,
0x0000000012117faeULL, 0x0003e2000d101c46ULL, 0x0000001025147825ULL, 0x000fc800078e0014ULL,
0x00000010711f7824ULL, 0x000fe200078e0202ULL, 0x00000000141d7faeULL, 0x0003e2000d901c46ULL,
0x0000001025167825ULL, 0x000fc800078e0016ULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x00000000161f7faeULL, 0x0003e2000e101c46ULL, 0x0000001025187825ULL, 0x000fc800078e0018ULL,
0x0000001023237824ULL, 0x000fe200078e0202ULL, 0x0000000018217faeULL, 0x0003e2000e901c46ULL,
0x00000010251a7825ULL, 0x000fca00078e001aULL, 0x000000001a237faeULL, 0x0003e2000f101c46ULL,
0x000009a000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0f7819ULL, 0x000fe20000011604ULL,
0x00005800ff007624ULL, 0x000fe400078e00ffULL, 0x0000000878857824ULL, 0x000fe200078e00ffULL,
0x000000040f117810ULL, 0x040fe20007ffe0ffULL, 0x0000004000007824ULL, 0x000fe200078e00ffULL,
0x0000000c0f1b7810ULL, 0x040fe20007ffe0ffULL, 0x00000200ff3c7424ULL, 0x000fe200078e00ffULL,
0x000000080f177810ULL, 0x000fe20007ffe0ffULL, 0x0000000811157824ULL, 0x040fe200078e00ffULL,
0x0000000411027212ULL, 0x080fe200078e3cffULL, 0x0000000400007e24ULL, 0x020fe2000f8e0205ULL,
0x000000140f237810ULL, 0x000fe20007ffe0ffULL, 0x000000081b127824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee202ULL, 0x0000000817197824ULL, 0x000fe200078e00ffULL,
0x000000041b057212ULL, 0x000fe200078e3cffULL, 0x0000000823257824ULL, 0x000fe200078e00ffULL,
0x000000180f277810ULL, 0x000fc40007ffe0ffULL, 0x0000001c0f357810ULL, 0x000fe40007ffe0ffULL,
0x0000000417027212ULL, 0x000fe200078e3cffULL, 0x0000000827337824ULL, 0x000fe200078e00ffULL,
0xfffffff8121d7812ULL, 0x000fe200078ee205ULL, 0x0000000835127824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe400078ee202ULL, 0x000000240f3f7810ULL, 0x040fe40007ffe0ffULL,
0x000000280f417810ULL, 0x000fc40007ffe0ffULL, 0x00000004230e7212ULL, 0x080fe200078e3cffULL,
0x000000083f697824ULL, 0x000fe200078e00ffULL, 0x0000000427027212ULL, 0x080fe200078e3cffULL,
0x00000008416d7824ULL, 0x000fe200078e00ffULL, 0x0000000435057212ULL, 0x000fe400078e3cffULL,
0x0000002c0f437810ULL, 0x000fe40007ffe0ffULL, 0xfffffff825257812ULL, 0x000fe400078ee20eULL,
0xfffffff833337812ULL, 0x000fc400078ee202ULL, 0xfffffff812377812ULL, 0x000fe200078ee205ULL,
0x0000000843127824ULL, 0x000fe200078e00ffULL, 0x000000340f477810ULL, 0x000fe40007ffe0ffULL,
0x000000043f0e7212ULL, 0x080fe400078e3cffULL, 0x0000000441027212ULL, 0x080fe200078e3cffULL,
0x00000008477b7824ULL, 0x000fe200078e00ffULL, 0x0000000443057212ULL, 0x000fe400078e3cffULL,
0xfffffff869697812ULL, 0x000fc400078ee20eULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee202ULL,
0x0000000278027824ULL, 0x000fe200078e020dULL, 0x00000004470e7212ULL, 0x000fe400078e3cffULL,
0xfffffff812717812ULL, 0x000fe400078ee205ULL, 0x000000100f1f7810ULL, 0x040fe40007ffe0ffULL,
0x0000003c0f4b7810ULL, 0x040fe40007ffe0ffULL, 0x000000070f057812ULL, 0x000fc400078e4804ULL,
0x000000200f3d7810ULL, 0x040fe40007ffe0ffULL, 0x000000300f457810ULL, 0x000fe40007ffe0ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee20eULL, 0x000000083d597824ULL, 0x000fe200078e00ffULL,
0x000000380f497810ULL, 0x000fe20007ffe0ffULL, 0x0000000845757824ULL, 0x000fe200078e00ffULL,
0x000000041f0c7212ULL, 0x0c0fe400078e3cffULL, 0x000000031f217819ULL, 0x000fe200000006ffULL,
0x00000008497f7824ULL, 0x000fe200078e00ffULL, 0x000000044b0e7212ULL, 0x000fc400078e3cffULL,
0x0000003f000f7812ULL, 0x000fe400078ef80fULL, 0x000000034b837819ULL, 0x000fe400000006ffULL,
0x0001400002027811ULL, 0x000fe400078e68ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef804ULL,
0x0000003f00137812ULL, 0x040fe200078ef811ULL, 0x000000106d6d7824ULL, 0x100fe200078e0202ULL,
0x0000003f00177812ULL, 0x040fe200078ef817ULL, 0x0000001005117824ULL, 0x000fe200078e0202ULL,
0x0000003f001b7812ULL, 0x000fe200078ef81bULL, 0x00005e0013127625ULL, 0x000fe200078e003cULL,
0xfffffff821217812ULL, 0x000fc400078ee20cULL, 0x0000003f001f7812ULL, 0x040fe200078ef81fULL,
0x0000001071717824ULL, 0x000fe200078e0202ULL, 0xfffffff883837812ULL, 0x000fe200078ee20eULL,
0x00005e000f0e7625ULL, 0x000fe200078e003cULL, 0x000000043d0c7212ULL, 0x000fe400078e3cffULL,
0x0000003f00237812ULL, 0x040fe200078ef823ULL, 0x000000107b7b7824ULL, 0x100fe200078e0202ULL,
0x0000003f005b7812ULL, 0x040fe200078ef83fULL, 0x00000010153f7824ULL, 0x000fe200078e0202ULL,
0x0000003f00277812ULL, 0x000fe200078ef827ULL, 0x00005e0017147625ULL, 0x000fe200078e003cULL,
0xfffffff885057812ULL, 0x000fc400078ee204ULL, 0x0000003f00357812ULL, 0x040fe200078ef835ULL,
0x00005e001b167625ULL, 0x080fe200078e003cULL, 0x0000003f006b7812ULL, 0x040fe400078ef841ULL,
0x0000003f003d7812ULL, 0x040fe200078ef83dULL, 0x0000001019417824ULL, 0x000fe200078e0202ULL,
0xfffffff859597812ULL, 0x000fe200078ee20cULL, 0x00005e001f187625ULL, 0x000fe200078e003cULL,
0x0000003f006f7812ULL, 0x040fe400078ef843ULL, 0x00000004450c7212ULL, 0x000fe200078e3cffULL,
0x000000101d437824ULL, 0x000fe200078e0202ULL, 0x0000003f00737812ULL, 0x040fe200078ef845ULL,
0x00005e00231a7625ULL, 0x000fe200078e003cULL, 0x0000003f00777812ULL, 0x000fc400078ef847ULL,
0xfffffff875757812ULL, 0x000fe200078ee20cULL, 0x00005e00271c7625ULL, 0x000fe200078e003cULL,
0x0000003f007d7812ULL, 0x040fe400078ef849ULL, 0x00000004490c7212ULL, 0x000fe200078e3cffULL,
0x00000010050e7825ULL, 0x000fe200078e000eULL, 0x0000003f00817812ULL, 0x000fe400078ef84bULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee20cULL, 0x0000001021457824ULL, 0x000fe200078e0202ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e2000b901c46ULL,
0x00005e00351e7625ULL, 0x000fe200078e003cULL, 0x0000000269697211ULL, 0x000fc600078e20ffULL,
0x0000001005127825ULL, 0x000fc800078e0012ULL, 0x00005e003d207625ULL, 0x000fe200078e003cULL,
0x00000000123f7faeULL, 0x0003e6000b901c46ULL, 0x0000001005147825ULL, 0x000fc800078e0014ULL,
0x0000001025477824ULL, 0x000fe200078e0202ULL, 0x0000000014417faeULL, 0x0003e2000b901c46ULL,
0x00005e005b227625ULL, 0x000fc800078e003cULL, 0x0000001005167825ULL, 0x000fc800078e0016ULL,
0x00005e006b247625ULL, 0x000fe200078e003cULL, 0x0000000016437faeULL, 0x0003e6000b901c46ULL,
0x0000001005187825ULL, 0x000fc800078e0018ULL, 0x0000001033497824ULL, 0x000fe200078e0202ULL,
0x0000000018457faeULL, 0x0003e2000b901c46ULL, 0x00005e006f267625ULL, 0x000fc800078e003cULL,
0x00000010051a7825ULL, 0x000fc800078e001aULL, 0x00005e0073327625ULL, 0x000fe200078e003cULL,
0x000000001a477faeULL, 0x0003e6000b901c46ULL, 0x00000010051c7825ULL, 0x000fc800078e001cULL,
0x00000010374b7824ULL, 0x000fe200078e0202ULL, 0x000000001c497faeULL, 0x0003e2000b901c46ULL,
0x00005e0077347625ULL, 0x000fc800078e003cULL, 0x00000010051e7825ULL, 0x000fc800078e001eULL,
0x0000001059597824ULL, 0x000fe200078e0202ULL, 0x000000001e4b7faeULL, 0x0003e2000b901c46ULL,
0x00005e007d367625ULL, 0x000fc800078e003cULL, 0x0000001005207825ULL, 0x000fc800078e0020ULL,
0x00005e00813c7625ULL, 0x000fe200078e003cULL, 0x0000000020597faeULL, 0x0003e6000b901c46ULL,
0x0000001005227825ULL, 0x000fc800078e0022ULL, 0x0000001005247825ULL, 0x040fe200078e0024ULL,
0x0000000022697faeULL, 0x0003e6000b901c46ULL, 0x0000001005267825ULL, 0x000fe200078e0026ULL,
0x00000000246d7faeULL, 0x0003e6000b901c46ULL, 0x0000001075757824ULL, 0x000fe200078e0202ULL,
0x0000000026717faeULL, 0x0003e2000b901c46ULL, 0x0000001005327825ULL, 0x000fc800078e0032ULL,
0x0000001005347825ULL, 0x000fe200078e0034ULL, 0x0000000032757faeULL, 0x0003e6000b901c46ULL,
0x000000107f7f7824ULL, 0x000fe200078e0202ULL, 0x00000000347b7faeULL, 0x0003e2000b901c46ULL,
0x0000001005367825ULL, 0x000fc800078e0036ULL, 0x0000001083837824ULL, 0x000fe200078e0202ULL,
0x00000000367f7faeULL, 0x0003e2000b901c46ULL, 0x00000010053c7825ULL, 0x000fca00078e003cULL,
0x000000003c837faeULL, 0x0003e4000b901c46ULL, 0x00000300ff007624ULL, 0x000fe200078e00ffULL,
0x0000000376027812ULL, 0x000fe200078ec0ffULL, 0x02460c00ff117984ULL, 0x002e660000000800ULL,
0x000000030200780cULL, 0x000fe20003f25270ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd00007811ULL, 0x000fc800078e10ffULL, 0x0000000100057807ULL, 0x000fca0004800000ULL,
0x0000000176767824ULL, 0x000fe400078e0205ULL, 0xffffffffff057424ULL, 0x000fc600078e00ffULL,
0x0000002f7600720cULL, 0x000fda0003f26070ULL, 0x00000001760e9824ULL, 0x000fe400078e0208ULL,
0x00000004ff0f9424ULL, 0x000fc800078e00ffULL, 0x000060000e0e9625ULL, 0x000fca00078e000fULL,
0x000000060e059981ULL, 0x000562000c1e1900ULL, 0x0000ffff09007812ULL, 0x000fc800078ec0ffULL,
0x00008880000c7816ULL, 0x000fc800000000ffULL, 0x0000001f0c007819ULL, 0x000fc800000006ffULL,
0x8000000011ff7812ULL, 0x002fe20007824800ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x004fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x800000000c0f7824ULL, 0x000fe400078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x02460c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc4000782480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000010040e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff007819ULL, 0x100fe20000011604ULL,
0x00000001ff157424ULL, 0x000fe200078e00ffULL, 0x00000004ff167819ULL, 0x000fe40000011604ULL,
0x000000700e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000c000f7812ULL, 0x000fe400078ec0ffULL,
0x0000000804187812ULL, 0x000fc600078ec0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e020fULL,
0x00000007040f7812ULL, 0x000fc800078ec0ffULL, 0x024000000e117984ULL, 0x000e620000000800ULL,
0x000000080f417812ULL, 0x000fc600078ef804ULL, 0x024200000e027984ULL, 0x0004e20000000800ULL,
0x00000007161a7812ULL, 0x000fe400078e7841ULL, 0x000000061100720bULL, 0x002fda0003f3d000ULL,
0x0000000000007806ULL, 0x000fc800008e0100ULL, 0x0000ffff00177812ULL, 0x000fe2000782c0ffULL,
0x0000400078007824ULL, 0x000fd800078e00ffULL, 0x0000035000009947ULL, 0x000fea0003800000ULL,
0x000000061100720bULL, 0x00cfe40003f34000ULL, 0x0000001106197209ULL, 0x000fe40007810000ULL,
0x00000002ff137819ULL, 0x000fc60000011604ULL, 0x8000001906127221ULL, 0x000fe20000010000ULL,
0x0000000813147810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b12127820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400008e0100ULL, 0x000000ff7800720cULL, 0x000fe40003f25270ULL,
0x0000ffff06067812ULL, 0x000fe200078e3cffULL, 0x0000001200127308ULL, 0x000e660000000800ULL,
0x0000000617ff7212ULL, 0x000fe2000784c0ffULL, 0x000000ffff067224ULL, 0x000fc600078e0019ULL,
0x00000001ff157807ULL, 0x000fc60001000000ULL, 0x024400190e009388ULL, 0x000fe80000000800ULL,
0x00001f1412147589ULL, 0x002e6400000e0000ULL, 0x8000001911112221ULL, 0x000fe40000010000ULL,
0x0000001207077220ULL, 0x000fe20000410000ULL, 0x00001f1312137589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b11112820ULL, 0x000fc80000410000ULL, 0x0000001100102308ULL, 0x000ee20000000800ULL,
0x0000001463637220ULL, 0x082fe40000410000ULL, 0x0000001462627220ULL, 0x080fe40000410000ULL,
0x000000144f4f7220ULL, 0x080fe40000410000ULL, 0x000000144e4e7220ULL, 0x080fe40000410000ULL,
0x0000001467677220ULL, 0x080fe40000410000ULL, 0x0000001466667220ULL, 0x000fc40000410000ULL,
0x000000143b3b7220ULL, 0x080fe40000410000ULL, 0x000000143a3a7220ULL, 0x080fe40000410000ULL,
0x000000142b2b7220ULL, 0x080fe40000410000ULL, 0x000000142a2a7220ULL, 0x080fe40000410000ULL,
0x0000001453537220ULL, 0x080fe40000410000ULL, 0x0000001452527220ULL, 0x000fc40000410000ULL,
0x0000001457577220ULL, 0x080fe40000410000ULL, 0x0000001456567220ULL, 0x080fe40000410000ULL,
0x000000145f5f7220ULL, 0x080fe40000410000ULL, 0x000000145e5e7220ULL, 0x000fe40000410000ULL,
0x0000001361617220ULL, 0x084fe40000410000ULL, 0x0000001360607220ULL, 0x000fc40000410000ULL,
0x000000134d4d7220ULL, 0x080fe40000410000ULL, 0x000000134c4c7220ULL, 0x080fe40000410000ULL,
0x0000001365657220ULL, 0x080fe40000410000ULL, 0x0000001364647220ULL, 0x080fe40000410000ULL,
0x0000001339397220ULL, 0x080fe40000410000ULL, 0x0000001338387220ULL, 0x000fc40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x0000001328287220ULL, 0x080fe40000410000ULL,
0x0000001351517220ULL, 0x080fe40000410000ULL, 0x0000001350507220ULL, 0x080fe40000410000ULL,
0x0000001355557220ULL, 0x080fe40000410000ULL, 0x0000001354547220ULL, 0x000fc40000410000ULL,
0x000000135d5d7220ULL, 0x080fe40000410000ULL, 0x000000135c5c7220ULL, 0x000fe40000410000ULL,
0x0000001002022220ULL, 0x008fe40000410000ULL, 0x0000000718177812ULL, 0x04cfe200078ec80fULL,
0x0000000841117824ULL, 0x000fe200078e021aULL, 0x0000000f18747212ULL, 0x000fe200078efcffULL,
0x0000200031127824ULL, 0x000fe200078e0200ULL, 0x0000000216187810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000010ff14723eULL, 0x000fe400000010ffULL,
0x00000018177b7212ULL, 0x000fe400078e3cffULL, 0x00012000111c7811ULL, 0x000fe400078e20ffULL,
0x00005410141a7816ULL, 0x000fe40000000014ULL, 0x0001400012817810ULL, 0x000fe40007ffe0ffULL,
0x0000007b74147211ULL, 0x000fe200078e18ffULL, 0x000000001c1c783bULL, 0x000fe20000000200ULL,
0x0000000616407810ULL, 0x000fc40007ffe0ffULL, 0x0000001617777212ULL, 0x040fe200078e3cffULL,
0x0000001014687824ULL, 0x000fe200078e0281ULL, 0x00000040177f7212ULL, 0x000fe400078e3cffULL,
0x0000000416347810ULL, 0x000fe20007ffe0ffULL, 0x0000000874127824ULL, 0x040fe200078e0277ULL,
0x00000002ff757819ULL, 0x000fe20000011604ULL, 0x0000000874167824ULL, 0x000fe200078e027fULL,
0x000000006868783bULL, 0x000fe20000004200ULL, 0x0000001012587824ULL, 0x100fe200078e0281ULL,
0x0000000875137810ULL, 0x000fe20007ffe0ffULL, 0x0000001016207824ULL, 0x000fe200078e0281ULL,
0x0000000718187812ULL, 0x000fe200078e7841ULL, 0x00001f751a757589ULL, 0x000e6200000e0000ULL,
0x00000034177d7212ULL, 0x000fc400078e3cffULL, 0x0000991015157816ULL, 0x000fe200000000ffULL,
0x000000005858783bULL, 0x000fe20000004200ULL, 0x0000000841177824ULL, 0x000fe200078e0218ULL,
0x0000008074367811ULL, 0x040fe400078e18ffULL, 0x000000002020783bULL, 0x000fe20000004200ULL,
0x000000ff1500720cULL, 0x000fe20003f25270ULL, 0x0000000874157824ULL, 0x000fe200078e027dULL,
0x0001200017307811ULL, 0x000fe200078e20ffULL, 0x00001f131a2c7589ULL, 0x0004e200000e0000ULL,
0x0000000177187824ULL, 0x000fc400078e0236ULL, 0x00000010153c7824ULL, 0x100fe400078e0281ULL,
0x000000003030783bULL, 0x000f220000000200ULL, 0x0000001018247824ULL, 0x000fe400078e0281ULL,
0x000000017b197824ULL, 0x100fe200078e0236ULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0x000000367d1a7210ULL, 0x004fe20007ffe0ffULL, 0x000000017f1b7824ULL, 0x000fe200078e0236ULL,
0x000000751c1c9231ULL, 0x082fe200003400ffULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x000000751e1e9231ULL, 0x000fc400003400ffULL, 0x0000002c1d1d9231ULL, 0x088fe400003400ffULL,
0x0000002c1f1f9231ULL, 0x000fce00003400ffULL, 0x000000681c50723cULL, 0x040ff00000041850ULL,
0x0000006a1c68723cULL, 0x000fe20000041828ULL, 0x0000007530309231ULL, 0x090fe400003400ffULL,
0x0000007532329231ULL, 0x000fc800003400ffULL, 0x0000001019287824ULL, 0x100fe200078e0281ULL,
0x000000581c5c723cULL, 0x040fe2000004185cULL, 0x0000002c31319231ULL, 0x080fe400003400ffULL,
0x0000002c33339231ULL, 0x000fe400003400ffULL, 0x000000002828783bULL, 0x000ea60000004200ULL,
0x000000201c44723cULL, 0x040fee000004184cULL, 0x000000101a207824ULL, 0x100fe200078e0281ULL,
0x0000005a1c58723cULL, 0x040ff00000041854ULL, 0x000000221c4c723cULL, 0x040fe20000041860ULL,
0x000000002020783bULL, 0x000eee0000004200ULL, 0x0000003c1c48723cULL, 0x000ff00000041838ULL,
0x00000024305c723cULL, 0x042fee000004185cULL, 0x000000101b247824ULL, 0x000fe200078e0281ULL,
0x000000263058723cULL, 0x000fea0000041858ULL, 0x000000002424783bULL, 0x000e660000004200ULL,
0x0000003e1c3c723cULL, 0x000fee0000041864ULL, 0x00000007341c7812ULL, 0x000fe200078e7841ULL,
0x000000283050723cULL, 0x004fe80000041850ULL, 0x00000008411c7824ULL, 0x000fc600078e021cULL,
0x0000010074287811ULL, 0x000fe200078e18ffULL, 0x000000203048723cULL, 0x048fe20000041848ULL,
0x000120001c347811ULL, 0x000fe400078e20ffULL, 0x0000018074747811ULL, 0x000fe200078e18ffULL,
0x000000017d1f7824ULL, 0x100fe400078e0228ULL, 0x00000001771d7824ULL, 0x100fe200078e0228ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x000000017b1e7824ULL, 0x100fe200078e0228ULL,
0x000000811f387211ULL, 0x000fe200078e20ffULL, 0x000000017f207824ULL, 0x000fe200078e0228ULL,
0x0000000740287812ULL, 0x000fe200078e7841ULL, 0x000000101d707824ULL, 0x100fe200078e0281ULL,
0x00000022303c723cULL, 0x000fe2000004183cULL, 0x000000101e6c7824ULL, 0x100fe200078e0281ULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x0000001020407824ULL, 0x000fc400078e0281ULL,
0x0000000841217824ULL, 0x000fe200078e0228ULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x0000000177227824ULL, 0x100fe200078e0274ULL, 0x000000243044723cULL, 0x042fe20000041844ULL,
0x000000017b237824ULL, 0x100fe200078e0274ULL, 0x000000006c6c783bULL, 0x000e620000004200ULL,
0x0001200021607811ULL, 0x000fe200078e20ffULL, 0x0000001022547824ULL, 0x100fe400078e0281ULL,
0x000000004040783bULL, 0x000fe20000004200ULL, 0x000000017d247824ULL, 0x100fe200078e0274ULL,
0x0000002a3068723cULL, 0x000fe20000041868ULL, 0x000000017f257824ULL, 0x000fe200078e0274ULL,
0x000000006060783bULL, 0x000f220000000200ULL, 0x0000001023287824ULL, 0x000fc400078e0281ULL,
0x0000001024647824ULL, 0x100fe200078e0281ULL, 0x000000005454783bULL, 0x000f240000004200ULL,
0x00000026304c723cULL, 0x000fe4000004184cULL, 0x000000002828783bULL, 0x000f280000004200ULL,
0x000000006464783bULL, 0x000f220000004200ULL, 0x0000001025307824ULL, 0x000fe200078e0281ULL,
0x0000007534349231ULL, 0x004fc400003400ffULL, 0x0000007536369231ULL, 0x000fc600003400ffULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x0000002c35359231ULL, 0x080fe400003400ffULL,
0x0000002c37379231ULL, 0x000fce00003400ffULL, 0x00000070345c723cULL, 0x048ff0000004185cULL,
0x0000006c3450723cULL, 0x002fe20000041850ULL, 0x0000007560609231ULL, 0x090fe400003400ffULL,
0x0000007562629231ULL, 0x000fc400003400ffULL, 0x0000002c61619231ULL, 0x000fc600003400ffULL,
0x000000383448723cULL, 0x000fe20000041848ULL, 0x0000002c63639231ULL, 0x000fce00003400ffULL,
0x000000723458723cULL, 0x040ff00000041858ULL, 0x0000006e3468723cULL, 0x040ff00000041868ULL,
0x0000003a343c723cULL, 0x040ff0000004183cULL, 0x000000403444723cULL, 0x040ff00000041844ULL,
0x000000423434723cULL, 0x000ff0000004184cULL, 0x00000054605c723cULL, 0x040ff0000004185cULL,
0x000000286050723cULL, 0x040ff00000041850ULL, 0x000000646038723cULL, 0x040ff00000041848ULL,
0x000000566054723cULL, 0x040ff00000041858ULL, 0x0000002a6028723cULL, 0x040ff00000041868ULL,
0x000000666064723cULL, 0x040ff0000004183cULL, 0x00000030604c723cULL, 0x044ff00000041844ULL,
0x000000326060723cULL, 0x000fe20000041834ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000002e0300720cULL, 0x000fe20003f26070ULL, 0x02461000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000000702077221ULL, 0x000fe20000010000ULL, 0x0000000d00317202ULL, 0x000fd40000000f00ULL,
0x0000617000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000b0000008947ULL, 0x000fea0003800000ULL, 0x00000003ff267819ULL, 0x000fe20000011604ULL,
0x00005800ff277624ULL, 0x000fe200078e00ffULL, 0x000000800b037810ULL, 0x000fe20007ffe0ffULL,
0x00000200ff597424ULL, 0x000fe200078e00ffULL, 0x0000000826327810ULL, 0x000fe20007ffe0ffULL,
0x00000040272c7824ULL, 0x000fe200078e00ffULL, 0x000000032e027217ULL, 0x000fe40007800000ULL,
0x0000000426307810ULL, 0x000fe20007ffe0ffULL, 0x0000000832367824ULL, 0x040fe200078e00ffULL,
0x0000000432277212ULL, 0x080fe200078e3cffULL, 0x0000000102027824ULL, 0x000fe200078e0a03ULL,
0x00000014263c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000830347824ULL, 0x000fe200078e00ffULL,
0xfffffff8363d7812ULL, 0x000fe200078ee227ULL, 0x000000042c477e24ULL, 0x020fe2000f8e0205ULL,
0x0000000430037212ULL, 0x000fe200078e3cffULL, 0x000000083c407824ULL, 0x000fe200078e00ffULL,
0x0000001026367810ULL, 0x000fc40007ffe0ffULL, 0x000000043c277212ULL, 0x080fe400078e3cffULL,
0x0000002026427810ULL, 0x000fe20007ffe0ffULL, 0x00000008363e7824ULL, 0x000fe200078e00ffULL,
0xfffffff834377812ULL, 0x000fe400078ee203ULL, 0x0000000c26347810ULL, 0x000fe40007ffe0ffULL,
0xfffffff840457812ULL, 0x000fe400078ee227ULL, 0x0000000436057212ULL, 0x000fe200078e3cffULL,
0x00000008342c7824ULL, 0x000fe200078e00ffULL, 0x0000001c26407810ULL, 0x000fc40007ffe0ffULL,
0x0000000442277212ULL, 0x0c0fe400078e3cffULL, 0x0000000342467819ULL, 0x000fe200000006ffULL,
0x0000000840447824ULL, 0x000fe200078e00ffULL, 0x0000002c26487810ULL, 0x000fe40007ffe0ffULL,
0xfffffff83e437812ULL, 0x000fe400078ee205ULL, 0x0000000434037212ULL, 0x000fe200078e3cffULL,
0x0000000848587824ULL, 0x000fe200078e00ffULL, 0x00000018263e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8465b7812ULL, 0x000fe400078ee227ULL, 0x0000000440057212ULL, 0x080fe400078e3cffULL,
0x0000002826467810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82c417812ULL, 0x000fe200078ee203ULL,
0x000000083e2c7824ULL, 0x000fe200078e00ffULL, 0x0000000448277212ULL, 0x000fe200078e3cffULL,
0x00000008464a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8444b7812ULL, 0x000fc400078ee205ULL,
0x000000043e037212ULL, 0x080fe400078e3cffULL, 0x0000002426447810ULL, 0x000fe40007ffe0ffULL,
0x0000000446057212ULL, 0x080fe400078e3cffULL, 0xfffffff8586d7812ULL, 0x000fe400078ee227ULL,
0x0000003426587810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82c497812ULL, 0x000fe200078ee203ULL,
0x00000008442c7824ULL, 0x000fe200078e00ffULL, 0xfffffff84a6b7812ULL, 0x000fe200078ee205ULL,
0x0000000858687824ULL, 0x000fe200078e00ffULL, 0x0000000444037212ULL, 0x000fc400078e3cffULL,
0x00000030264a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000458057212ULL, 0x080fe400078e3cffULL,
0xfffffff82c697812ULL, 0x000fe200078ee203ULL, 0x000000084a2c7824ULL, 0x040fe200078e00ffULL,
0x000000044a037212ULL, 0x000fe400078e3cffULL, 0xfffffff868717812ULL, 0x000fe400078ee205ULL,
0x0000000726057812ULL, 0x000fc400078e4804ULL, 0xfffffff82c6f7812ULL, 0x000fe200078ee203ULL,
0x00000008782c7824ULL, 0x000fe200078e00ffULL, 0x000000010a037812ULL, 0x000fe400078ec0ffULL,
0x00000038265a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff805357812ULL, 0x000fe200078ef804ULL,
0x0000200003037824ULL, 0x000fe200078e0200ULL, 0x0000004002057817ULL, 0x000fe20003800000ULL,
0x000000085a6a7824ULL, 0x000fe200078e00ffULL, 0x0000003c26687810ULL, 0x000fc40007ffe0ffULL,
0x000000052600720cULL, 0x080fe40003f06070ULL, 0x0000003f47027812ULL, 0x040fe200078ef826ULL,
0x0000000868757824ULL, 0x000fe200078e00ffULL, 0x000000045a277212ULL, 0x000fe400078e3cffULL,
0x000000053000720cULL, 0x080fe40003f26070ULL, 0x0000003f47267812ULL, 0x000fe400078ef830ULL,
0x000000053200720cULL, 0x000fc40003f46070ULL, 0x0000003f47307812ULL, 0x040fe400078ef832ULL,
0xfffffff82c3f7812ULL, 0x000fe400078ee20fULL, 0x0000003f47327812ULL, 0x000fe200078ef834ULL,
0x00005e0030307625ULL, 0x080fe200078e0059ULL, 0x00014000032c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff86a737812ULL, 0x000fe200078ee227ULL, 0x00005e0002027625ULL, 0x000fe200078e0059ULL,
0x000000053400720cULL, 0x000fc40003f66070ULL, 0x0000002c35357211ULL, 0x000fe200078e20ffULL,
0x00005e0026267625ULL, 0x000fe200078e0059ULL, 0x0000003f47347812ULL, 0x000fe400078ef842ULL,
0x000000054200720cULL, 0x000fe20003f86070ULL, 0x00005e0032327625ULL, 0x000fe200078e0059ULL,
0x00000004686a7212ULL, 0x000fe400078e3cffULL, 0x000000055a00720cULL, 0x080fe20003fa6070ULL,
0x000000103f027825ULL, 0x000fe200078e0002ULL, 0x000000056800720cULL, 0x000fc40003fc6070ULL,
0xfffffff875757812ULL, 0x000fe200078ee26aULL, 0x0000001037377824ULL, 0x000fe200078e022cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002357faeULL, 0x0003e2000c101c46ULL,
0x000000103f267825ULL, 0x000fe200078e0026ULL, 0x000000053600720cULL, 0x080fe40003f06070ULL,
0x0000003f47367812ULL, 0x000fe200078ef836ULL, 0x000000103d3d7824ULL, 0x000fe200078e022cULL,
0x0000000026377faeULL, 0x0005e2000c901c46ULL, 0x000000103f307825ULL, 0x000fe200078e0030ULL,
0x000000053c00720cULL, 0x000fc40003f26070ULL, 0x0000003f473c7812ULL, 0x000fe200078ef83cULL,
0x0000001041417824ULL, 0x000fe200078e022cULL, 0x00000000303d7faeULL, 0x0007e2000d101c46ULL,
0x000000103f327825ULL, 0x000fe200078e0032ULL, 0x000000053e00720cULL, 0x000fe40003f46070ULL,
0x0000003f473e7812ULL, 0x040fe200078ef83eULL, 0x00005e0036027625ULL, 0x002fe200078e0059ULL,
0x0000000032417faeULL, 0x0003e2000d901c46ULL, 0x000000054000720cULL, 0x000fe40003f66070ULL,
0x0000003f47407812ULL, 0x040fe200078ef840ULL, 0x00005e003c267625ULL, 0x004fe200078e0059ULL,
0x0000003f47367812ULL, 0x000fc400078ef85aULL, 0x0000003f473c7812ULL, 0x000fe200078ef868ULL,
0x00005e003e307625ULL, 0x008fc800078e0059ULL, 0x00005e0040327625ULL, 0x002fc800078e0059ULL,
0x00005e0034347625ULL, 0x000fc800078e0059ULL, 0x0000001043377824ULL, 0x000fe400078e022cULL,
0x000000103f027825ULL, 0x000fc800078e0002ULL, 0x00000010453d7824ULL, 0x000fe200078e022cULL,
0x0000000002377faeULL, 0x0003e2000c101c46ULL, 0x000000103f267825ULL, 0x000fe200078e0026ULL,
0x000000054400720cULL, 0x080fe40003f06070ULL, 0x0000003f47447812ULL, 0x000fe200078ef844ULL,
0x0000001049417824ULL, 0x000fe200078e022cULL, 0x00000000263d7faeULL, 0x0005e2000c901c46ULL,
0x000000103f307825ULL, 0x000fe200078e0030ULL, 0x000000054600720cULL, 0x080fe40003f26070ULL,
0x0000003f47467812ULL, 0x000fe200078ef846ULL, 0x000000104b437824ULL, 0x000fe200078e022cULL,
0x0000000030417faeULL, 0x0007e2000d101c46ULL, 0x000000103f327825ULL, 0x000fe200078e0032ULL,
0x000000054800720cULL, 0x000fc40003f46070ULL, 0x0000003f47487812ULL, 0x000fe200078ef848ULL,
0x000000105b457824ULL, 0x000fe200078e022cULL, 0x0000000032437faeULL, 0x0009e2000d901c46ULL,
0x000000103f347825ULL, 0x000fe200078e0034ULL, 0x000000054a00720cULL, 0x000fe40003f66070ULL,
0x0000003f474a7812ULL, 0x040fe200078ef84aULL, 0x00005e0044027625ULL, 0x002fe200078e0059ULL,
0x0000000034457faeULL, 0x0003e2000e101c46ULL, 0x000000055800720cULL, 0x000fe40003f86070ULL,
0x0000003f47587812ULL, 0x000fe200078ef858ULL, 0x00005e0046267625ULL, 0x004fe200078e0059ULL,
0x0000002c6d437211ULL, 0x010fc600078e20ffULL, 0x00005e0048307625ULL, 0x008fc800078e0059ULL,
0x00005e004a327625ULL, 0x000fc800078e0059ULL, 0x00005e0058347625ULL, 0x002fc800078e0059ULL,
0x00005e0036367625ULL, 0x000fc800078e0059ULL, 0x0000001069057824ULL, 0x000fe400078e022cULL,
0x00005e003c3c7625ULL, 0x000fc800078e0059ULL, 0x000000103f027825ULL, 0x000fc800078e0002ULL,
0x000000106b417824ULL, 0x000fe200078e022cULL, 0x0000000002057faeULL, 0x0003e2000c101c46ULL,
0x000000103f267825ULL, 0x000fc800078e0026ULL, 0x000000103f307825ULL, 0x000fe200078e0030ULL,
0x0000000026417faeULL, 0x0003e6000c901c46ULL, 0x000000106f457824ULL, 0x000fe200078e022cULL,
0x0000000030437faeULL, 0x0003e2000d101c46ULL, 0x000000103f327825ULL, 0x000fc800078e0032ULL,
0x0000001071477824ULL, 0x000fe200078e022cULL, 0x0000000032457faeULL, 0x0003e2000d901c46ULL,
0x000000103f347825ULL, 0x000fc800078e0034ULL, 0x0000001073497824ULL, 0x000fe200078e022cULL,
0x0000000034477faeULL, 0x0003e2000e101c46ULL, 0x000000103f367825ULL, 0x000fc800078e0036ULL,
0x00000010754b7824ULL, 0x000fe200078e022cULL, 0x0000000036497faeULL, 0x0003e2000e901c46ULL,
0x000000103f3c7825ULL, 0x000fca00078e003cULL, 0x000000003c4b7faeULL, 0x0003e2000f101c46ULL,
0x000009b000007947ULL, 0x000fea0003800000ULL, 0x00000003ff277819ULL, 0x000fe20000011604ULL,
0x00005800ff027624ULL, 0x000fe400078e00ffULL, 0x00000200ff5a7424ULL, 0x000fe200078e00ffULL,
0x0000000427317810ULL, 0x040fe20007ffe0ffULL, 0x0000004002027824ULL, 0x000fe200078e00ffULL,
0x0000000827357810ULL, 0x000fe40007ffe0ffULL, 0x0000000431037212ULL, 0x0c0fe200078e3cffULL,
0x0000000831267824ULL, 0x000fe200078e00ffULL, 0x0000000c273d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008352c7824ULL, 0x000fe200078e00ffULL, 0x0000001027417810ULL, 0x000fe20007ffe0ffULL,
0x0000000402027e24ULL, 0x020fe2000f8e0205ULL, 0xfffffff826337812ULL, 0x000fe200078ee203ULL,
0x000000083d307824ULL, 0x000fe200078e00ffULL, 0x0000000435037212ULL, 0x000fe200078e3cffULL,
0x0000000841437824ULL, 0x000fe200078e00ffULL, 0x0000001427457810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82c377812ULL, 0x000fe400078ee203ULL, 0x000000043d057212ULL, 0x080fe400078e3cffULL,
0x0000001827497810ULL, 0x000fe40007ffe0ffULL, 0x0000000445037212ULL, 0x040fe400078e3cffULL,
0x00000003452c7819ULL, 0x000fe400000006ffULL, 0x0000002027697810ULL, 0x000fc40007ffe0ffULL,
0x0000001c27597810ULL, 0x000fe40007ffe0ffULL, 0x0000000441267212ULL, 0x080fe400078e3cffULL,
0xfffffff8303f7812ULL, 0x000fe200078ee205ULL, 0x0000000849307824ULL, 0x000fe200078e00ffULL,
0xfffffff82c477812ULL, 0x000fe200078ee203ULL, 0x00000008692c7824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee226ULL, 0x00000008595b7824ULL, 0x000fe200078e00ffULL,
0x0000000449057212ULL, 0x000fc400078e3cffULL, 0x00000024276b7810ULL, 0x040fe40007ffe0ffULL,
0x00000028276d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000469037212ULL, 0x080fe400078e3cffULL,
0x0000002c276f7810ULL, 0x000fe20007ffe0ffULL, 0x000000086d837824ULL, 0x000fe200078e00ffULL,
0x0000000459267212ULL, 0x000fe400078e3cffULL, 0xfffffff8304b7812ULL, 0x000fe200078ee205ULL,
0x000000086b307824ULL, 0x000fe200078e00ffULL, 0xfffffff82c7b7812ULL, 0x000fe200078ee203ULL,
0x000000086f2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fc400078ee226ULL,
0x0000003427737810ULL, 0x000fe40007ffe0ffULL, 0x000000046b057212ULL, 0x080fe400078e3cffULL,
0x000000046d267212ULL, 0x080fe200078e3cffULL, 0x00000008738f7824ULL, 0x000fe200078e00ffULL,
0x0000003027717810ULL, 0x000fe40007ffe0ffULL, 0x000000046f037212ULL, 0x000fe400078e3cffULL,
0xfffffff8307f7812ULL, 0x000fe200078ee205ULL, 0x0000000871307824ULL, 0x000fe200078e00ffULL,
0xfffffff883837812ULL, 0x000fc400078ee226ULL, 0xfffffff82c877812ULL, 0x000fe400078ee203ULL,
0x0000000473267212ULL, 0x080fe400078e3cffULL, 0x000000010a037812ULL, 0x000fe400078ec0ffULL,
0x0000000471057212ULL, 0x000fe400078e3cffULL, 0x0000003827757810ULL, 0x000fe40007ffe0ffULL,
0xfffffff88f8f7812ULL, 0x000fe200078ee226ULL, 0x0000200003267824ULL, 0x000fe200078e0200ULL,
0x0000003c27777810ULL, 0x000fe20007ffe0ffULL, 0x0000000875937824ULL, 0x000fe200078e00ffULL,
0xfffffff8308b7812ULL, 0x000fc400078ee205ULL, 0x0000000727057812ULL, 0x000fe400078e4804ULL,
0x0000003f02037812ULL, 0x040fe400078ef827ULL, 0x0000003f02277812ULL, 0x040fe400078ef831ULL,
0x00000004752c7212ULL, 0x080fe400078e3cffULL, 0x0000000477307212ULL, 0x000fe400078e3cffULL,
0x0000003f02317812ULL, 0x000fc400078ef835ULL, 0x0000000377977819ULL, 0x000fe400000006ffULL,
0x0000003f02357812ULL, 0x040fe400078ef841ULL, 0x0000003f023d7812ULL, 0x040fe400078ef83dULL,
0x0000003f02457812ULL, 0x040fe200078ef845ULL, 0x00005e0035347625ULL, 0x000fe200078e005aULL,
0x0000003f02497812ULL, 0x040fe400078ef849ULL, 0x0000003f02597812ULL, 0x000fc400078ef859ULL,
0x0000003f02417812ULL, 0x040fe400078ef869ULL, 0x0000003f027d7812ULL, 0x040fe400078ef86bULL,
0x0000003f02817812ULL, 0x040fe200078ef86dULL, 0x00005e0041407625ULL, 0x000fe200078e005aULL,
0x0000003f02857812ULL, 0x040fe400078ef86fULL, 0x0000003f02897812ULL, 0x040fe400078ef871ULL,
0x0000003f028d7812ULL, 0x000fc400078ef873ULL, 0x0000003f02917812ULL, 0x040fe400078ef875ULL,
0x0000003f02957812ULL, 0x000fe200078ef877ULL, 0x0000000878027824ULL, 0x000fe200078e00ffULL,
0x0001400026267810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef804ULL,
0xfffffff893937812ULL, 0x000fe200078ee22cULL, 0x00000010336b7824ULL, 0x000fe200078e0226ULL,
0xfffffff897977812ULL, 0x000fe200078ee230ULL, 0x0000001005697824ULL, 0x100fe200078e0226ULL,
0xfffffff802057812ULL, 0x000fe200078ee20fULL, 0x00000010376d7824ULL, 0x100fe200078e0226ULL,
0x000000267b7b7211ULL, 0x000fe200078e20ffULL, 0x000000103f6f7824ULL, 0x000fc400078e0226ULL,
0x0000001043717824ULL, 0x100fe400078e0226ULL, 0x0000001047737824ULL, 0x100fe400078e0226ULL,
0x000000104b757824ULL, 0x100fe400078e0226ULL, 0x000000105b777824ULL, 0x100fe400078e0226ULL,
0x000000107f7f7824ULL, 0x100fe400078e0226ULL, 0x0000001083837824ULL, 0x000fc400078e0226ULL,
0x0000001087877824ULL, 0x100fe400078e0226ULL, 0x000000108b8b7824ULL, 0x100fe400078e0226ULL,
0x000000108f8f7824ULL, 0x100fe400078e0226ULL, 0x0000001093937824ULL, 0x100fe400078e0226ULL,
0x0000001097977824ULL, 0x000fe400078e0226ULL, 0x00005e0003027625ULL, 0x000fc800078e005aULL,
0x00005e0027267625ULL, 0x000fc800078e005aULL, 0x00005e0031307625ULL, 0x000fc800078e005aULL,
0x00005e003d327625ULL, 0x000fc800078e005aULL, 0x00005e0045367625ULL, 0x000fc800078e005aULL,
0x00005e00493c7625ULL, 0x000fc800078e005aULL, 0x0000001005027825ULL, 0x000fc800078e0002ULL,
0x00005e00593e7625ULL, 0x000fe200078e005aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002697faeULL, 0x0003e6000b901c46ULL, 0x0000001005267825ULL, 0x000fc800078e0026ULL,
0x0000001005307825ULL, 0x000fe200078e0030ULL, 0x00000000266b7faeULL, 0x0003e6000b901c46ULL,
0x00005e007d427625ULL, 0x000fe200078e005aULL, 0x00000000306d7faeULL, 0x0003e6000b901c46ULL,
0x0000001005327825ULL, 0x000fc800078e0032ULL, 0x00005e0081447625ULL, 0x000fe200078e005aULL,
0x00000000326f7faeULL, 0x0003e6000b901c46ULL, 0x0000001005347825ULL, 0x000fc800078e0034ULL,
0x00005e0085467625ULL, 0x000fe200078e005aULL, 0x0000000034717faeULL, 0x0003e6000b901c46ULL,
0x0000001005367825ULL, 0x000fc800078e0036ULL, 0x00005e0089487625ULL, 0x000fe200078e005aULL,
0x0000000036737faeULL, 0x0003e6000b901c46ULL, 0x00000010053c7825ULL, 0x000fc800078e003cULL,
0x00005e008d4a7625ULL, 0x000fe200078e005aULL, 0x000000003c757faeULL, 0x0003e6000b901c46ULL,
0x00000010053e7825ULL, 0x000fc800078e003eULL, 0x00005e0091587625ULL, 0x000fe200078e005aULL,
0x000000003e777faeULL, 0x0003e6000b901c46ULL, 0x0000001005407825ULL, 0x000fc800078e0040ULL,
0x00005e00955a7625ULL, 0x000fe200078e005aULL, 0x00000000407b7faeULL, 0x0003e6000b901c46ULL,
0x0000001005427825ULL, 0x000fc800078e0042ULL, 0x0000001005447825ULL, 0x040fe200078e0044ULL,
0x00000000427f7faeULL, 0x0003e6000b901c46ULL, 0x0000001005467825ULL, 0x040fe200078e0046ULL,
0x0000000044837faeULL, 0x0003e6000b901c46ULL, 0x0000001005487825ULL, 0x040fe200078e0048ULL,
0x0000000046877faeULL, 0x0003e6000b901c46ULL, 0x00000010054a7825ULL, 0x040fe200078e004aULL,
0x00000000488b7faeULL, 0x0003e6000b901c46ULL, 0x0000001005587825ULL, 0x040fe200078e0058ULL,
0x000000004a8f7faeULL, 0x0003e6000b901c46ULL, 0x00000010055a7825ULL, 0x000fe200078e005aULL,
0x0000000058937faeULL, 0x0003e8000b901c46ULL, 0x000000005a977faeULL, 0x0003e4000b901c46ULL,
0x00000300ff027624ULL, 0x002fe200078e00ffULL, 0x0000000376037812ULL, 0x000fe200078ec0ffULL,
0x02461c00ff267984ULL, 0x000e620000000800ULL, 0xffffffffff057424ULL, 0x000fc400078e00ffULL,
0x000000030300780cULL, 0x000fe20003f05270ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd02027811ULL, 0x000fc800078e10ffULL, 0x0000000102037807ULL, 0x000fca0004000000ULL,
0x0000000176767824ULL, 0x000fca00078e0203ULL, 0x0000002f7600720cULL, 0x000fda0003f06070ULL,
0x0000000400038802ULL, 0x000fe20000000f00ULL, 0x0000000176028824ULL, 0x000fc800078e0208ULL,
0x0000600002028625ULL, 0x000fca00078e0003ULL, 0x0000000602058981ULL, 0x000562000c1e1900ULL,
0x800000000c277824ULL, 0x000fca00078e00ffULL, 0x8000000026ff7812ULL, 0x002fe20007804827ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x004fe400078e00ffULL, 0x800000000c267824ULL, 0x000fe400078e00ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000030000735dULL, 0x004fe40003800000ULL, 0x02461c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fc40007804826ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x024080000e037984ULL, 0x004e620000000800ULL,
0x000020000d277824ULL, 0x000fe200078e0200ULL, 0x0001280011407811ULL, 0x000fe400078e20ffULL,
0x024280000e267984ULL, 0x0004e20000000800ULL, 0x000000060300720bULL, 0x002fda0003f1d000ULL,
0x0000000000027806ULL, 0x000fc800000e0100ULL, 0x0000ffff022c7812ULL, 0x000fe2000780c0ffULL,
0x00000001ff027424ULL, 0x000fca00078e00ffULL, 0x0000761002007816ULL, 0x000fce0000000000ULL,
0x0000034000008947ULL, 0x000fea0003800000ULL, 0x000000060300720bULL, 0x00cfe40003f14000ULL,
0x0000000306337209ULL, 0x000fe40007810000ULL, 0x00000002ff357819ULL, 0x000fc60000011604ULL,
0x8000003306007221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b00027820ULL, 0x000fe40000410000ULL,
0x0000000000007806ULL, 0x000fe400000e0100ULL, 0x000000017800780cULL, 0x000fe40003f05270ULL,
0x0000ffff00317812ULL, 0x000fe200078e3cffULL, 0x0000000200027308ULL, 0x000e660000000800ULL,
0x000000312cff7212ULL, 0x000fce000782c0ffULL, 0x024480330e008388ULL, 0x000fe80000000800ULL,
0x00001f3502007589ULL, 0x002e6400000e0000ULL, 0x8000003303061221ULL, 0x000fe40000010000ULL,
0x0000000207077220ULL, 0x000fe20000410000ULL, 0x00001f1302037589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b06061820ULL, 0x000fc80000410000ULL, 0x0000000600101308ULL, 0x0007240000000800ULL,
0x000000ffff067224ULL, 0x008fe400078e0033ULL, 0x000000005c5c7220ULL, 0x082fe40000410000ULL,
0x000000005d5d7220ULL, 0x080fe40000410000ULL, 0x0000000054547220ULL, 0x080fe40000410000ULL,
0x0000000055557220ULL, 0x000fc40000410000ULL, 0x0000000050507220ULL, 0x080fe40000410000ULL,
0x0000000051517220ULL, 0x080fe40000410000ULL, 0x0000000028287220ULL, 0x080fe40000410000ULL,
0x0000000029297220ULL, 0x080fe40000410000ULL, 0x0000000038387220ULL, 0x080fe40000410000ULL,
0x0000000039397220ULL, 0x000fc40000410000ULL, 0x0000000064647220ULL, 0x080fe40000410000ULL,
0x0000000065657220ULL, 0x080fe40000410000ULL, 0x000000004c4c7220ULL, 0x080fe40000410000ULL,
0x000000004d4d7220ULL, 0x080fe40000410000ULL, 0x0000000060607220ULL, 0x080fe40000410000ULL,
0x0000000061617220ULL, 0x000fe20000410000ULL, 0x00000001ff007807ULL, 0x000fe20000800000ULL,
0x000000035e5e7220ULL, 0x004fc40000410000ULL, 0x000000035f5f7220ULL, 0x080fe40000410000ULL,
0x0000000356567220ULL, 0x080fe40000410000ULL, 0x0000000357577220ULL, 0x080fe40000410000ULL,
0x0000000352527220ULL, 0x080fe40000410000ULL, 0x0000000353537220ULL, 0x080fe40000410000ULL,
0x000000032a2a7220ULL, 0x000fc40000410000ULL, 0x000000032b2b7220ULL, 0x080fe40000410000ULL,
0x000000033a3a7220ULL, 0x080fe40000410000ULL, 0x000000033b3b7220ULL, 0x080fe40000410000ULL,
0x0000000366667220ULL, 0x080fe40000410000ULL, 0x0000000367677220ULL, 0x080fe40000410000ULL,
0x000000034e4e7220ULL, 0x000fc40000410000ULL, 0x000000034f4f7220ULL, 0x080fe40000410000ULL,
0x0000000362627220ULL, 0x080fe40000410000ULL, 0x0000000363637220ULL, 0x000fe40000410000ULL,
0x0000002610261220ULL, 0x010fe40000410000ULL, 0x0001400027277810ULL, 0x00cfe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x00000010122c7824ULL, 0x100fe200078e0227ULL, 0x00000010ff02723eULL, 0x000fe200000010ffULL,
0x0000001014037824ULL, 0x100fe200078e0227ULL, 0x00000002ff757819ULL, 0x000fe20000011604ULL,
0x0000001019777824ULL, 0x100fe200078e0227ULL, 0x000000002c34783bULL, 0x000fe20000004200ULL,
0x00005410023c7816ULL, 0x000fe20000000002ULL, 0x0000001015027824ULL, 0x100fe200078e0227ULL,
0x0000991000007816ULL, 0x000fe200000000ffULL, 0x000000000344783bULL, 0x000fe20000004200ULL,
0x0001280017687811ULL, 0x000fe200078e20ffULL, 0x00000010187a7824ULL, 0x100fe200078e0227ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00001f753c757589ULL, 0x000e6200000e0000ULL,
0x0000002716007211ULL, 0x080fe200078e20ffULL, 0x000000101a7b7824ULL, 0x100fe200078e0227ULL,
0x000128001c6c7811ULL, 0x000fe200078e20ffULL, 0x00001f133c747589ULL, 0x000ea200000e0000ULL,
0x000000101b7c7824ULL, 0x100fe200078e0227ULL, 0x0000002724827211ULL, 0x000fe200078e20ffULL,
0x000000101f7f7824ULL, 0x100fe200078e0227ULL, 0x000000000230783bULL, 0x000fe20000004200ULL,
0x0000001020807824ULL, 0x000fc400078e0227ULL, 0x000000101d7d7824ULL, 0x100fe200078e0227ULL,
0x000000006868783bULL, 0x000ee20000000200ULL, 0x000000101e7e7824ULL, 0x100fe400078e0227ULL,
0x0000001025837824ULL, 0x100fe200078e0227ULL, 0x000000000048783bULL, 0x000f220000004200ULL,
0x0000001022817824ULL, 0x100fe400078e0227ULL, 0x0000001023847824ULL, 0x000fe200078e0227ULL,
0x000000007a3c783bULL, 0x000fe80000004200ULL, 0x000000007d58783bULL, 0x000fe20000004200ULL,
0x0000007540408231ULL, 0x002fc400003400ffULL, 0x0000007542428231ULL, 0x000fe200003400ffULL,
0x000000008170783bULL, 0x000fe20000004200ULL, 0x0000007441418231ULL, 0x084fe400003400ffULL,
0x0000007443438231ULL, 0x000fce00003400ffULL, 0x00000034405c723cULL, 0x040ff0000004185cULL,
0x000000364054723cULL, 0x000fe20000041854ULL, 0x000000007734783bULL, 0x000e620000004200ULL,
0x0000007568688231ULL, 0x008fc400003400ffULL, 0x000000756a6a8231ULL, 0x000fc800003400ffULL,
0x000000444050723cULL, 0x000fe20000041850ULL, 0x0000007469698231ULL, 0x080fe400003400ffULL,
0x000000746b6b8231ULL, 0x000fca00003400ffULL, 0x000000464028723cULL, 0x040fe20000041828ULL,
0x000000007b44783bULL, 0x000eae0000004200ULL, 0x000000304038723cULL, 0x040ff00000041838ULL,
0x000000324030723cULL, 0x040fe20000041864ULL, 0x000000007c64783bULL, 0x000fee0000004200ULL,
0x00000048404c723cULL, 0x010ff0000004184cULL, 0x000000346850723cULL, 0x042ff00000041850ULL,
0x000000366834723cULL, 0x000fe20000041828ULL, 0x000000006c28783bULL, 0x000e680000000200ULL,
0x00000000846c783bULL, 0x000fe60000004200ULL, 0x0000004a4060723cULL, 0x000fe20000041860ULL,
0x000000007f40783bULL, 0x000ee80000004200ULL, 0x000000008048783bULL, 0x000f260000004200ULL,
0x0000003c685c723cULL, 0x040ff0000004185cULL, 0x0000003e6854723cULL, 0x040fe20000041854ULL,
0x000000007e3c783bULL, 0x000fee0000004200ULL, 0x000000446838723cULL, 0x044ff00000041838ULL,
0x000000466844723cULL, 0x000fe20000041830ULL, 0x0000007528288231ULL, 0x002fc400003400ffULL,
0x000000752a2a8231ULL, 0x000fe400003400ffULL, 0x0000007429298231ULL, 0x080fe400003400ffULL,
0x0001280021307811ULL, 0x000fe200078e20ffULL, 0x00000064684c723cULL, 0x000fe2000004184cULL,
0x000000742b2b8231ULL, 0x000fc800003400ffULL, 0x000000003030783bULL, 0x000e660000000200ULL,
0x000000666868723cULL, 0x000fe20000041860ULL, 0x000000008264783bULL, 0x000ea80000004200ULL,
0x000000008360783bULL, 0x000ea60000004200ULL, 0x000000402838723cULL, 0x048ff00000041838ULL,
0x00000048284c723cULL, 0x050ff0000004184cULL, 0x00000058285c723cULL, 0x040ff0000004185cULL,
0x0000005a2854723cULL, 0x000fe20000041854ULL, 0x0000007530308231ULL, 0x002fc400003400ffULL,
0x0000007532328231ULL, 0x000fca00003400ffULL, 0x0000003c2850723cULL, 0x000fe20000041850ULL,
0x0000007431318231ULL, 0x080fe400003400ffULL, 0x0000007433338231ULL, 0x000fca00003400ffULL,
0x0000003e2834723cULL, 0x040ff00000041834ULL, 0x000000422844723cULL, 0x040ff00000041844ULL,
0x0000004a2868723cULL, 0x000ff00000041868ULL, 0x000000643038723cULL, 0x044ff00000041838ULL,
0x00000060304c723cULL, 0x040ff0000004184cULL, 0x00000070305c723cULL, 0x040ff0000004185cULL,
0x000000723054723cULL, 0x040ff00000041854ULL, 0x0000006c3050723cULL, 0x040ff00000041850ULL,
0x0000006e3028723cULL, 0x040ff00000041834ULL, 0x000000663064723cULL, 0x040ff00000041844ULL,
0x000000623060723cULL, 0x000fe20000041868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000800b317810ULL, 0x000fe20007ffe0ffULL, 0x02462000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000000726077221ULL, 0x000fc40000010000ULL, 0x0000002e3100720cULL, 0x000fe40003f06070ULL,
0x000000010a317812ULL, 0x000fd600078ec0ffULL, 0x0000406000000947ULL, 0x000fea0003800000ULL,
0x0000000179267810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002d2600720cULL, 0x000fda0003f06070ULL, 0x00000ad000008947ULL, 0x000fea0003800000ULL,
0x00000003ff337819ULL, 0x000fe20000011604ULL, 0x00005800ff267624ULL, 0x000fe200078e00ffULL,
0x000000c00b317810ULL, 0x000fe20007ffe0ffULL, 0x00000200ff5b7424ULL, 0x000fe200078e00ffULL,
0x0000000433357810ULL, 0x000fe20007ffe0ffULL, 0x0000004026307824ULL, 0x000fe200078e00ffULL,
0x000000312e267217ULL, 0x000fe40007800000ULL, 0x0000000435327212ULL, 0x0c0fe200078e3cffULL,
0x00000008353d7824ULL, 0x000fe200078e00ffULL, 0x0000001033437810ULL, 0x040fe20007ffe0ffULL,
0x0000000126267824ULL, 0x000fe200078e0a31ULL, 0x0000000c33317810ULL, 0x000fe20007ffe0ffULL,
0x00000004303e7e24ULL, 0x020fe2000f8e0205ULL, 0xfffffff83d347812ULL, 0x000fe200078ee232ULL,
0x00000008433d7824ULL, 0x000fe200078e00ffULL, 0x0000000833377810ULL, 0x000fe20007ffe0ffULL,
0x0000000831427824ULL, 0x000fe200078e00ffULL, 0x0000000443307212ULL, 0x000fc400078e3cffULL,
0x00000020334b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008373f7824ULL, 0x000fe200078e00ffULL,
0x0000000431057212ULL, 0x080fe400078e3cffULL, 0xfffffff83d447812ULL, 0x000fe200078ee230ULL,
0x000000084b3d7824ULL, 0x000fe200078e00ffULL, 0x0000001c33497810ULL, 0x000fe40007ffe0ffULL,
0x0000000437367212ULL, 0x000fe400078e3cffULL, 0x0000001433457810ULL, 0x000fc40007ffe0ffULL,
0x000000044b307212ULL, 0x080fe400078e3cffULL, 0x00000030336f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001833477810ULL, 0x040fe40007ffe0ffULL, 0xfffffff842427812ULL, 0x000fe400078ee205ULL,
0x0000002c336d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000847417824ULL, 0x000fe200078e00ffULL,
0x0000000449057212ULL, 0x000fc400078e3cffULL, 0x0000000349587819ULL, 0x000fe200000006ffULL,
0x000000086d6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3c7812ULL, 0x000fe200078ee236ULL,
0x00000008453f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d687812ULL, 0x000fe200078ee230ULL,
0x000000086f3d7824ULL, 0x000fe200078e00ffULL, 0x0000000445327212ULL, 0x080fe400078e3cffULL,
0x0000002433697810ULL, 0x000fe40007ffe0ffULL, 0x000000046f307212ULL, 0x000fc400078e3cffULL,
0x0000000447367212ULL, 0x080fe400078e3cffULL, 0x00000028336b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff858587812ULL, 0x000fe400078ee205ULL, 0x000000046d057212ULL, 0x080fe400078e3cffULL,
0xfffffff83f467812ULL, 0x000fe200078ee232ULL, 0x00000008693f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d707812ULL, 0x000fe200078ee230ULL, 0x0000000878307824ULL, 0x000fe200078e00ffULL,
0xfffffff841487812ULL, 0x000fe200078ee236ULL, 0x000000086b417824ULL, 0x000fe200078e00ffULL,
0x0000000469327212ULL, 0x000fe200078e3cffULL, 0x00000010343d7824ULL, 0x000fe200078e0227ULL,
0x0000003433717810ULL, 0x000fc40007ffe0ffULL, 0xfffffff86e6e7812ULL, 0x000fe400078ee205ULL,
0x000000046b367212ULL, 0x000fe400078e3cffULL, 0x0000003833737810ULL, 0x040fe40007ffe0ffULL,
0x0000000733057812ULL, 0x000fe400078e4804ULL, 0xfffffff83f6a7812ULL, 0x000fe200078ee232ULL,
0x00000008713f7824ULL, 0x000fe200078e00ffULL, 0xfffffff830597812ULL, 0x000fc400078ee20fULL,
0xfffffff8416c7812ULL, 0x000fe200078ee236ULL, 0x0000000873417824ULL, 0x000fe200078e00ffULL,
0x0ffffff805307812ULL, 0x000fe400078ef804ULL, 0x0000000471327212ULL, 0x080fe400078e3cffULL,
0x0000000473367212ULL, 0x000fe400078e3cffULL, 0x0000004026267817ULL, 0x000fe40003800000ULL,
0x0000002730057211ULL, 0x000fc400078e20ffULL, 0xfffffff83f727812ULL, 0x000fe200078ee232ULL,
0x000000103c3f7824ULL, 0x000fe200078e0227ULL, 0x0000003f3e307812ULL, 0x000fe400078ef833ULL,
0xfffffff841747812ULL, 0x000fe200078ee236ULL, 0x0000001042417824ULL, 0x000fe200078e0227ULL,
0x0000003f3e327812ULL, 0x040fe400078ef835ULL, 0x0000003f3e367812ULL, 0x000fe400078ef837ULL,
0x000000263300720cULL, 0x000fc40003f06070ULL, 0x0000003f3e407812ULL, 0x000fe400078ef831ULL,
0x000000263500720cULL, 0x080fe20003f26070ULL, 0x00005e0036347625ULL, 0x080fe200078e005bULL,
0x000000263100720cULL, 0x080fe40003f66070ULL, 0x0000003c33757810ULL, 0x000fe20007ffe0ffULL,
0x00005e0030307625ULL, 0x080fe200078e005bULL, 0x000000263700720cULL, 0x000fe40003f46070ULL,
0x00000004754a7212ULL, 0x000fe200078e3cffULL, 0x00005e0032327625ULL, 0x000fe200078e005bULL,
0x0000003f3e3c7812ULL, 0x000fc400078ef843ULL, 0x0000003f3e427812ULL, 0x000fe200078ef847ULL,
0x00005e0040367625ULL, 0x000fe200078e005bULL, 0x0000003f3e407812ULL, 0x040fe400078ef845ULL,
0x0000003f3e5a7812ULL, 0x000fe200078ef84bULL, 0x0000000875857824ULL, 0x000fe200078e00ffULL,
0x000000264b00720cULL, 0x080fe20003f86070ULL, 0x0000001059307825ULL, 0x000fe200078e0030ULL,
0x000000267300720cULL, 0x080fe40003fa6070ULL, 0xfffffff885867812ULL, 0x000fe200078ee24aULL,
0x0000001059327825ULL, 0x000fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030057faeULL, 0x0003e2000c101c46ULL, 0x000000264300720cULL, 0x000fc40003f06070ULL,
0x0000001059347825ULL, 0x040fe200078e0034ULL, 0x00000000323d7faeULL, 0x0005e2000c901c46ULL,
0x0000003f3e4a7812ULL, 0x000fe400078ef849ULL, 0x0000001059367825ULL, 0x000fe200078e0036ULL,
0x00000000343f7faeULL, 0x0007e2000d101c46ULL, 0x000000264500720cULL, 0x080fe40003f26070ULL,
0x000000264700720cULL, 0x080fe20003f46070ULL, 0x0000000036417faeULL, 0x0009e2000d901c46ULL,
0x00005e003c307625ULL, 0x002fe200078e005bULL, 0x000000264900720cULL, 0x000fc40003f66070ULL,
0x000000267500720cULL, 0x000fe20003fc6070ULL, 0x00005e0040327625ULL, 0x004fe200078e005bULL,
0x0000003f3e407812ULL, 0x000fc600078ef869ULL, 0x00005e0042347625ULL, 0x008fe200078e005bULL,
0x0000003f3e427812ULL, 0x000fc600078ef86bULL, 0x00005e004a367625ULL, 0x010fc800078e005bULL,
0x00005e005a3c7625ULL, 0x000fc800078e005bULL, 0x0000001044057824ULL, 0x000fe200078e0227ULL,
0x0000003f3e447812ULL, 0x000fe200078ef86dULL, 0x0000001059307825ULL, 0x000fc800078e0030ULL,
0x00000010463f7824ULL, 0x000fe200078e0227ULL, 0x0000000030057faeULL, 0x0003e2000c101c46ULL,
0x0000001059327825ULL, 0x000fe200078e0032ULL, 0x000000266900720cULL, 0x080fe40003f06070ULL,
0x0000003f3e467812ULL, 0x000fe200078ef86fULL, 0x0000001048417824ULL, 0x000fe200078e0227ULL,
0x00000000323f7faeULL, 0x0005e2000c901c46ULL, 0x0000001059347825ULL, 0x000fe200078e0034ULL,
0x000000266b00720cULL, 0x000fc60003f26070ULL, 0x0000001058437824ULL, 0x000fe200078e0227ULL,
0x0000000034417faeULL, 0x0007e2000d101c46ULL, 0x0000001059367825ULL, 0x000fe200078e0036ULL,
0x000000266d00720cULL, 0x000fc60003f46070ULL, 0x0000001068457824ULL, 0x000fe200078e0227ULL,
0x0000000036437faeULL, 0x0009e2000d901c46ULL, 0x00000010593c7825ULL, 0x000fe200078e003cULL,
0x000000266f00720cULL, 0x000fc60003f66070ULL, 0x000000106a057824ULL, 0x102fe200078e0227ULL,
0x000000003c457faeULL, 0x0003e2000e101c46ULL, 0x000000267100720cULL, 0x000fe20003f86070ULL,
0x000000106c417824ULL, 0x108fe400078e0227ULL, 0x0000001072477824ULL, 0x000fe200078e0227ULL,
0x0000003f3e367812ULL, 0x010fe200078ef871ULL, 0x0000001074497824ULL, 0x100fe200078e0227ULL,
0x000000276e437211ULL, 0x000fe200078e20ffULL, 0x00000010864b7824ULL, 0x000fe400078e0227ULL,
0x00005e0042307625ULL, 0x000fe200078e005bULL, 0x0000003f3e3c7812ULL, 0x002fc400078ef873ULL,
0x0000003f3e3e7812ULL, 0x000fe200078ef875ULL, 0x0000001070457824ULL, 0x000fe400078e0227ULL,
0x00005e0040267625ULL, 0x000fc800078e005bULL, 0x00005e0044327625ULL, 0x004fc800078e005bULL,
0x00005e0046347625ULL, 0x000fc800078e005bULL, 0x00005e0036367625ULL, 0x000fc800078e005bULL,
0x00005e003c3c7625ULL, 0x000fc800078e005bULL, 0x00005e003e3e7625ULL, 0x000fc800078e005bULL,
0x0000001059267825ULL, 0x000fc800078e0026ULL, 0x0000001059307825ULL, 0x040fe200078e0030ULL,
0x0000000026057faeULL, 0x0003e6000c101c46ULL, 0x0000001059327825ULL, 0x040fe200078e0032ULL,
0x0000000030417faeULL, 0x0003e6000c901c46ULL, 0x0000001059347825ULL, 0x040fe200078e0034ULL,
0x0000000032437faeULL, 0x0003e6000d101c46ULL, 0x0000001059367825ULL, 0x040fe200078e0036ULL,
0x0000000034457faeULL, 0x0003e6000d901c46ULL, 0x00000010593c7825ULL, 0x040fe200078e003cULL,
0x0000000036477faeULL, 0x0003e6000e101c46ULL, 0x00000010593e7825ULL, 0x000fe200078e003eULL,
0x000000003c497faeULL, 0x0003e8000e901c46ULL, 0x000000003e4b7faeULL, 0x0003e2000f101c46ULL,
0x0000098000007947ULL, 0x000fea0003800000ULL, 0x00000003ff317819ULL, 0x000fe20000011604ULL,
0x00005800ff267624ULL, 0x000fe200078e00ffULL, 0x00000003786c7819ULL, 0x000fc400000006ffULL,
0x0000000431337810ULL, 0x040fe20007ffe0ffULL, 0x0000004026267824ULL, 0x000fe200078e00ffULL,
0x00000010313d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000433307212ULL, 0x0c0fe200078e3cffULL,
0x0000000833377824ULL, 0x000fe200078e00ffULL, 0x0000001c31437810ULL, 0x000fe20007ffe0ffULL,
0x000000083d417824ULL, 0x040fe200078e00ffULL, 0x000000043d367212ULL, 0x000fe200078e3cffULL,
0x0000000426267e24ULL, 0x020fe2000f8e0205ULL, 0xfffffff837307812ULL, 0x000fe200078ee230ULL,
0x0000000843477824ULL, 0x000fe200078e00ffULL, 0x0000000c31377810ULL, 0x000fc40007ffe0ffULL,
0xfffffff841367812ULL, 0x000fe400078ee236ULL, 0x0000002831497810ULL, 0x000fe20007ffe0ffULL,
0x00000008373f7824ULL, 0x000fe200078e00ffULL, 0x0000001831417810ULL, 0x000fe20007ffe0ffULL,
0x0000001036737824ULL, 0x000fe200078e0227ULL, 0x0000000443407212ULL, 0x080fe200078e3cffULL,
0x0000000849597824ULL, 0x000fe200078e00ffULL, 0x0000000831357810ULL, 0x000fe20007ffe0ffULL,
0x0000000841457824ULL, 0x000fe200078e00ffULL, 0x0000000437347212ULL, 0x000fc400078e3cffULL,
0xfffffff847407812ULL, 0x000fe200078ee240ULL, 0x0000000835327824ULL, 0x000fe200078e00ffULL,
0x0000002431477810ULL, 0x000fe40007ffe0ffULL, 0x0000000449467212ULL, 0x080fe200078e3cffULL,
0x0000001040877824ULL, 0x000fe200078e0227ULL, 0x00000004413e7212ULL, 0x080fe200078e3cffULL,
0x00000008474b7824ULL, 0x000fe200078e00ffULL, 0x0000000435057212ULL, 0x000fe400078e3cffULL,
0xfffffff83f347812ULL, 0x000fc400078ee234ULL, 0x00000014313f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff859467812ULL, 0x000fe200078ee246ULL, 0x0000001034717824ULL, 0x100fe200078e0227ULL,
0xfffffff8453e7812ULL, 0x000fe400078ee23eULL, 0x0000003031597810ULL, 0x040fe20007ffe0ffULL,
0x00000010468d7824ULL, 0x100fe200078e0227ULL, 0x00000034315b7810ULL, 0x000fe20007ffe0ffULL,
0x000000103e857824ULL, 0x000fe200078e0227ULL, 0xfffffff832327812ULL, 0x000fe200078ee205ULL,
0x0000000859697824ULL, 0x000fe200078e00ffULL, 0x0000002031457810ULL, 0x000fe20007ffe0ffULL,
0x000000085b6b7824ULL, 0x000fe200078e00ffULL, 0x0000000447447212ULL, 0x000fc400078e3cffULL,
0x000000043f057212ULL, 0x080fe200078e3cffULL, 0x0000000845427824ULL, 0x000fe200078e00ffULL,
0x000000033f3c7819ULL, 0x000fe400000006ffULL, 0xfffffff84b447812ULL, 0x000fe400078ee244ULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee205ULL, 0x0000002c314b7810ULL, 0x000fe40007ffe0ffULL,
0x00000004594a7212ULL, 0x080fe200078e3cffULL, 0x000000103c757824ULL, 0x000fe200078e0227ULL,
0x000000045b587212ULL, 0x080fe200078e3cffULL, 0x000000084b487824ULL, 0x000fe200078e00ffULL,
0x0000000445057212ULL, 0x000fc400078e3cffULL, 0xfffffff8694a7812ULL, 0x000fe400078ee24aULL,
0xfffffff86b587812ULL, 0x000fe400078ee258ULL, 0xfffffff842427812ULL, 0x000fe200078ee205ULL,
0x000000104a917824ULL, 0x100fe200078e0227ULL, 0x0000003831697810ULL, 0x040fe20007ffe0ffULL,
0x0000001058937824ULL, 0x100fe200078e0227ULL, 0x0000003c316b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001042897824ULL, 0x000fe200078e0227ULL, 0x000000044b057212ULL, 0x080fe200078e3cffULL,
0x00000008696d7824ULL, 0x040fe200078e00ffULL, 0x00000004695a7212ULL, 0x000fe200078e3cffULL,
0x000000086b6f7824ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fc400078ee205ULL,
0x0000000731057812ULL, 0x000fe400078e4804ULL, 0x000000046b687212ULL, 0x000fe200078e3cffULL,
0x00000010488f7824ULL, 0x000fe200078e0227ULL, 0x0000003f26317812ULL, 0x040fe400078ef831ULL,
0x0000003f26337812ULL, 0x040fe400078ef833ULL, 0x0000003f26357812ULL, 0x040fe400078ef835ULL,
0x0000003f26377812ULL, 0x000fc400078ef837ULL, 0x0000003f263d7812ULL, 0x040fe400078ef83dULL,
0x0000003f263f7812ULL, 0x040fe400078ef83fULL, 0x0000003f26417812ULL, 0x040fe400078ef841ULL,
0x0000003f26437812ULL, 0x040fe400078ef843ULL, 0x0000003f26457812ULL, 0x040fe400078ef845ULL,
0x0000003f26477812ULL, 0x000fc400078ef847ULL, 0x0000003f26497812ULL, 0x040fe400078ef849ULL,
0x0000003f264b7812ULL, 0x040fe400078ef84bULL, 0x0000003f26597812ULL, 0x040fe400078ef859ULL,
0x0000003f265b7812ULL, 0x040fe400078ef85bULL, 0x0000003f26697812ULL, 0x040fe400078ef869ULL,
0x0000003f26977812ULL, 0x000fc400078ef86bULL, 0xfffffff86d5a7812ULL, 0x000fe200078ee25aULL,
0x00000010306d7824ULL, 0x100fe200078e0227ULL, 0x0ffffff805267812ULL, 0x000fe400078ef804ULL,
0xfffffff86f6a7812ULL, 0x000fe200078ee268ULL, 0x00000200ff687424ULL, 0x000fe200078e00ffULL,
0x00000027448b7211ULL, 0x000fe200078e20ffULL, 0x00000010266b7824ULL, 0x000fe200078e0227ULL,
0xfffffff86c057812ULL, 0x000fe200078ee20fULL, 0x00000010326f7824ULL, 0x100fe400078e0227ULL,
0x000000105a957824ULL, 0x000fc400078e0227ULL, 0x000000106a997824ULL, 0x000fe400078e0227ULL,
0x00005e0031267625ULL, 0x000fc800078e0068ULL, 0x00005e0033307625ULL, 0x000fc800078e0068ULL,
0x00005e0035327625ULL, 0x000fc800078e0068ULL, 0x00005e0037347625ULL, 0x000fc800078e0068ULL,
0x00005e003d367625ULL, 0x000fc800078e0068ULL, 0x00005e003f3c7625ULL, 0x000fc800078e0068ULL,
0x00005e00413e7625ULL, 0x000fc800078e0068ULL, 0x0000001005267825ULL, 0x000fc800078e0026ULL,
0x00005e0043407625ULL, 0x000fe200078e0068ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000266b7faeULL, 0x0003e6000b901c46ULL, 0x0000001005307825ULL, 0x000fc800078e0030ULL,
0x00005e0045427625ULL, 0x000fe200078e0068ULL, 0x00000000306d7faeULL, 0x0003e6000b901c46ULL,
0x0000001005327825ULL, 0x000fc800078e0032ULL, 0x00005e0047447625ULL, 0x000fe200078e0068ULL,
0x00000000326f7faeULL, 0x0003e6000b901c46ULL, 0x0000001005347825ULL, 0x000fc800078e0034ULL,
0x00005e0049467625ULL, 0x000fe200078e0068ULL, 0x0000000034717faeULL, 0x0003e6000b901c46ULL,
0x0000001005367825ULL, 0x000fc800078e0036ULL, 0x00005e004b487625ULL, 0x000fe200078e0068ULL,
0x0000000036737faeULL, 0x0003e6000b901c46ULL, 0x00000010053c7825ULL, 0x000fc800078e003cULL,
0x00005e00594a7625ULL, 0x000fe200078e0068ULL, 0x000000003c757faeULL, 0x0003e6000b901c46ULL,
0x00000010053e7825ULL, 0x000fc800078e003eULL, 0x00005e005b587625ULL, 0x000fe200078e0068ULL,
0x000000003e857faeULL, 0x0003e6000b901c46ULL, 0x0000001005407825ULL, 0x000fc800078e0040ULL,
0x00005e00695a7625ULL, 0x000fe200078e0068ULL, 0x0000000040877faeULL, 0x0003e6000b901c46ULL,
0x0000001005427825ULL, 0x000fc800078e0042ULL, 0x00005e0097687625ULL, 0x000fe200078e0068ULL,
0x0000000042897faeULL, 0x0003e6000b901c46ULL, 0x0000001005447825ULL, 0x000fc800078e0044ULL,
0x0000001005467825ULL, 0x040fe200078e0046ULL, 0x00000000448b7faeULL, 0x0003e6000b901c46ULL,
0x0000001005487825ULL, 0x040fe200078e0048ULL, 0x00000000468d7faeULL, 0x0003e6000b901c46ULL,
0x00000010054a7825ULL, 0x040fe200078e004aULL, 0x00000000488f7faeULL, 0x0003e6000b901c46ULL,
0x0000001005587825ULL, 0x040fe200078e0058ULL, 0x000000004a917faeULL, 0x0003e6000b901c46ULL,
0x00000010055a7825ULL, 0x040fe200078e005aULL, 0x0000000058937faeULL, 0x0003e6000b901c46ULL,
0x0000001005687825ULL, 0x000fe200078e0068ULL, 0x000000005a957faeULL, 0x0003e8000b901c46ULL,
0x0000000068997faeULL, 0x0003e4000b901c46ULL, 0x00000300ff057624ULL, 0x002fe200078e00ffULL,
0x0000000376267812ULL, 0x000fe200078ec0ffULL, 0x02462c00ff307984ULL, 0x000e660000000800ULL,
0x000000032600780cULL, 0x000fe20003f05270ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd05057811ULL, 0x000fc800078e10ffULL, 0x0000000105057807ULL, 0x000fca0004000000ULL,
0x0000000176767824ULL, 0x000fe200078e0205ULL, 0xffffffff00057802ULL, 0x000fc80000000f00ULL,
0x0000002f7600720cULL, 0x000fda0003f06070ULL, 0x0000000176268824ULL, 0x000fe400078e0208ULL,
0x00000004ff278424ULL, 0x000fc800078e00ffULL, 0x0000600026268625ULL, 0x000fca00078e0027ULL,
0x0000000626058981ULL, 0x000562000c1e1900ULL, 0x800000000c317824ULL, 0x000fca00078e00ffULL,
0x8000000030ff7812ULL, 0x002fe20007804831ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff267424ULL, 0x004fe400078e00ffULL,
0x800000000c307824ULL, 0x000fe400078e00ffULL, 0x0000002600277305ULL, 0x0002a4000021f000ULL,
0x3fa0000026267823ULL, 0x002fe200000100ffULL, 0x000000270000735dULL, 0x004fe40003800000ULL,
0x02462c00ff277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007804830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x024100000e277984ULL, 0x004e620000000800ULL, 0x000020000a317824ULL, 0x000fe200078e00ffULL,
0x00013000113d7811ULL, 0x000fe200078e20ffULL, 0x00000001ff3c7424ULL, 0x000fc600078e00ffULL,
0x0000200031317812ULL, 0x000fca00078ee2ffULL, 0x0000400078357824ULL, 0x000fe200078e0231ULL,
0x000000062700720bULL, 0x002fda0003f1d000ULL, 0x0000000000267806ULL, 0x000fc800000e0100ULL,
0x0000ffff26337812ULL, 0x000fe4000780c0ffULL, 0x024300000e267984ULL, 0x0002b60000000800ULL,
0x0000034000008947ULL, 0x000fea0003800000ULL, 0x000000062700720bULL, 0x002fe40003f14000ULL,
0x0000002706317209ULL, 0x000fc40007810000ULL, 0x00000002ff377819ULL, 0x000fc60000011604ULL,
0x8000003106307221ULL, 0x040fe20000010000ULL, 0x0000002706067209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b30327820ULL, 0x000fe40000410000ULL, 0x0000000000307806ULL, 0x000fe400000e0100ULL,
0x000000027800780cULL, 0x000fe40003f05270ULL, 0x0000ffff30347812ULL, 0x000fe200078e3cffULL,
0x0000003200327308ULL, 0x000e660000000800ULL, 0x0000003433ff7212ULL, 0x000fc8000782c0ffULL,
0x00000001ff3c7807ULL, 0x000fc60000800000ULL, 0x024500310e008388ULL, 0x000fe80000000800ULL,
0x00001f3732307589ULL, 0x002e6400000e0000ULL, 0x8000003127341221ULL, 0x000fe40000010000ULL,
0x0000003207077220ULL, 0x000fe20000410000ULL, 0x00001f1332337589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b34341820ULL, 0x000fc80000410000ULL, 0x0000003400101308ULL, 0x000f220000000800ULL,
0x000000305c5c7220ULL, 0x082fe40000410000ULL, 0x000000305d5d7220ULL, 0x080fe40000410000ULL,
0x0000003054547220ULL, 0x080fe40000410000ULL, 0x0000003055557220ULL, 0x080fe40000410000ULL,
0x0000003050507220ULL, 0x080fe40000410000ULL, 0x0000003051517220ULL, 0x000fc40000410000ULL,
0x0000003028287220ULL, 0x080fe40000410000ULL, 0x0000003029297220ULL, 0x080fe40000410000ULL,
0x0000003038387220ULL, 0x080fe40000410000ULL, 0x0000003039397220ULL, 0x080fe40000410000ULL,
0x0000003064647220ULL, 0x080fe40000410000ULL, 0x0000003065657220ULL, 0x000fc40000410000ULL,
0x000000304c4c7220ULL, 0x080fe40000410000ULL, 0x000000304d4d7220ULL, 0x080fe40000410000ULL,
0x0000003060607220ULL, 0x080fe40000410000ULL, 0x0000003061617220ULL, 0x000fe40000410000ULL,
0x000000335e5e7220ULL, 0x088fe40000410000ULL, 0x000000335f5f7220ULL, 0x000fc40000410000ULL,
0x0000003356567220ULL, 0x080fe40000410000ULL, 0x0000003357577220ULL, 0x080fe40000410000ULL,
0x0000003352527220ULL, 0x080fe40000410000ULL, 0x0000003353537220ULL, 0x080fe40000410000ULL,
0x000000332a2a7220ULL, 0x080fe40000410000ULL, 0x000000332b2b7220ULL, 0x000fc40000410000ULL,
0x000000333a3a7220ULL, 0x080fe40000410000ULL, 0x000000333b3b7220ULL, 0x080fe40000410000ULL,
0x0000003366667220ULL, 0x080fe40000410000ULL, 0x0000003367677220ULL, 0x080fe40000410000ULL,
0x000000334e4e7220ULL, 0x080fe40000410000ULL, 0x000000334f4f7220ULL, 0x000fc40000410000ULL,
0x0000003362627220ULL, 0x080fe40000410000ULL, 0x0000003363637220ULL, 0x000fe40000410000ULL,
0x0000002610261220ULL, 0x014fe40000410000ULL, 0x0001400035277810ULL, 0x002fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003d30783bULL, 0x000fe20000000200ULL,
0x0000001012347824ULL, 0x100fe200078e0227ULL, 0x00000010ff12723eULL, 0x000fe200000010ffULL,
0x00000010143e7824ULL, 0x100fe200078e0227ULL, 0x000099103c147816ULL, 0x000fe200000000ffULL,
0x0000001015407824ULL, 0x100fe200078e0227ULL, 0x00000002ff717819ULL, 0x000fe20000011604ULL,
0x000000003434783bULL, 0x000fe20000004200ULL, 0x0000541012467816ULL, 0x000fe20000000012ULL,
0x0000001019587824ULL, 0x100fe200078e0227ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000003e3c783bULL, 0x000fe20000004200ULL, 0x0001300017487811ULL, 0x000fe200078e20ffULL,
0x0000001016447824ULL, 0x100fe200078e0227ULL, 0x000130001c147811ULL, 0x000fe200078e20ffULL,
0x00001f7146717589ULL, 0x000e6200000e0000ULL, 0x000000101b1b7824ULL, 0x000fc400078e0227ULL,
0x00000010226c7824ULL, 0x100fe200078e0227ULL, 0x00001f1346127589ULL, 0x000ee200000e0000ULL,
0x0000001023687824ULL, 0x000fc600078e0227ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000f280000000200ULL, 0x000000005858783bULL, 0x000ea80000004200ULL,
0x000000004444783bULL, 0x000ea80000004200ULL, 0x000000006c6c783bULL, 0x000fe20000004200ULL,
0x0000007130308231ULL, 0x002fc400003400ffULL, 0x0000007132328231ULL, 0x000fe200003400ffULL,
0x000000006868783bULL, 0x000fe20000004200ULL, 0x0000001231318231ULL, 0x088fe400003400ffULL,
0x0000001233338231ULL, 0x000fce00003400ffULL, 0x00000034305c723cULL, 0x040ff0000004185cULL,
0x000000363034723cULL, 0x000fe20000041854ULL, 0x0000007148488231ULL, 0x010fcc00003400ffULL,
0x0000002718547211ULL, 0x000fe200078e20ffULL, 0x0000003c3050723cULL, 0x040fe20000041850ULL,
0x000000714a4a8231ULL, 0x080fe400003400ffULL, 0x0000001249498231ULL, 0x080fe400003400ffULL,
0x000000005454783bULL, 0x000e620000004200ULL, 0x000000124b4b8231ULL, 0x000fe200003400ffULL,
0x000000101a3c7824ULL, 0x100fe200078e0227ULL, 0x0000003e3028723cULL, 0x040fe20000041828ULL,
0x000000001b18783bULL, 0x000fe80000004200ULL, 0x000000003c3c783bULL, 0x000ee60000004200ULL,
0x000000403038723cULL, 0x040ff00000041838ULL, 0x000000423040723cULL, 0x000fee0000041864ULL,
0x000000101e647824ULL, 0x100fe200078e0227ULL, 0x000000584850723cULL, 0x004fea0000041850ULL,
0x000000006464783bULL, 0x000fe60000004200ULL, 0x00000044304c723cULL, 0x000fee000004184cULL,
0x000000101d447824ULL, 0x100fe200078e0227ULL, 0x0000005a4858723cULL, 0x000fe20000041828ULL,
0x000000001428783bULL, 0x000eae0000000200ULL, 0x000000463030723cULL, 0x000fe20000041860ULL,
0x000000004444783bULL, 0x000fec0000004200ULL, 0x0001300021607811ULL, 0x000fe200078e20ffULL,
0x00000054485c723cULL, 0x042fea000004185cULL, 0x000000006060783bULL, 0x000e640000000200ULL,
0x000000101f547824ULL, 0x100fe200078e0227ULL, 0x0000003c4838723cULL, 0x048fee0000041838ULL,
0x00000010203c7824ULL, 0x000fe200078e0227ULL, 0x000000564834723cULL, 0x040fe20000041834ULL,
0x000000005454783bULL, 0x000eee0000004200ULL, 0x0000003e4840723cULL, 0x000fe20000041840ULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0x0000007128288231ULL, 0x004fc400003400ffULL,
0x000000712a2a8231ULL, 0x000fe400003400ffULL, 0x0000001229298231ULL, 0x080fe400003400ffULL,
0x00000018484c723cULL, 0x000fe2000004184cULL, 0x000000122b2b8231ULL, 0x000fcc00003400ffULL,
0x0000002725187211ULL, 0x000fe200078e20ffULL, 0x0000001a4848723cULL, 0x000fea0000041830ULL,
0x000000001818783bULL, 0x000fe20000004200ULL, 0x0000007160608231ULL, 0x082fe200003400ffULL,
0x0000001024307824ULL, 0x000fe200078e0227ULL, 0x00000044285c723cULL, 0x000fe2000004185cULL,
0x0000007162628231ULL, 0x000fc400003400ffULL, 0x0000001261618231ULL, 0x080fe400003400ffULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x0000001263638231ULL, 0x000fe400003400ffULL,
0x000000462834723cULL, 0x040ff00000041834ULL, 0x000000642850723cULL, 0x040ff00000041850ULL,
0x000000662858723cULL, 0x040ff00000041858ULL, 0x000000542838723cULL, 0x048ff00000041838ULL,
0x000000562840723cULL, 0x040ff00000041840ULL, 0x0000003c284c723cULL, 0x050ff0000004184cULL,
0x0000003e2848723cULL, 0x000ff00000041848ULL, 0x0000006c605c723cULL, 0x040ff0000004185cULL,
0x0000006e6054723cULL, 0x040ff00000041834ULL, 0x000000686050723cULL, 0x040ff00000041850ULL,
0x0000006a6028723cULL, 0x040ff00000041858ULL, 0x000000306038723cULL, 0x042ff00000041838ULL,
0x000000326064723cULL, 0x040ff00000041840ULL, 0x00000018604c723cULL, 0x040ff0000004184cULL,
0x0000001a6060723cULL, 0x000fe20000041848ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000c00b0b7810ULL, 0x000fe20007ffe0ffULL, 0x02463000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000000726077221ULL, 0x000fc40000010000ULL, 0x0000002e0b00720cULL, 0x000fe20003f06070ULL,
0x000000ffff317224ULL, 0x000fd800078e000dULL, 0x00001f8000000947ULL, 0x000fea0003800000ULL,
0x00000300790b7a10ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000010b127810ULL, 0x000fc80007ffe0ffULL, 0x0000002d1200720cULL, 0x000fda0003f06070ULL,
0x00000ad000008947ULL, 0x000fea0003800000ULL, 0x000001000b0b7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fe20000011604ULL, 0x0000000878147824ULL, 0x000fe400078e00ffULL,
0x00000200ff377424ULL, 0x000fe200078e00ffULL, 0x0000000b2e127217ULL, 0x000fe40007800000ULL,
0x000000040d157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff814357812ULL, 0x000fe200078ee20fULL,
0x0000000112127824ULL, 0x000fe200078e0a0bULL, 0x00000004150b7212ULL, 0x040fe200078e3cffULL,
0x00000008151a7824ULL, 0x000fe200078e00ffULL, 0x000000140d237810ULL, 0x040fe20007ffe0ffULL,
0x00005800ff0f7624ULL, 0x000fe200078e00ffULL, 0x000000180d257810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL, 0x000000400f147824ULL, 0x000fe200078e00ffULL,
0x0000000c0d0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000825327824ULL, 0x000fe200078e00ffULL,
0x00000003231b7819ULL, 0x000fe200000006ffULL, 0x0000000414167e24ULL, 0x020fe2000f8e0205ULL,
0x000000040b057212ULL, 0x0c0fe200078e3cffULL, 0x000000080b247824ULL, 0x000fe200078e00ffULL,
0x0000000423147212ULL, 0x000fe400078e3cffULL, 0x000000200d337810ULL, 0x000fc40007ffe0ffULL,
0xfffffff824247812ULL, 0x000fe400078ee205ULL, 0x000000240d3d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81b307812ULL, 0x000fe200078ee214ULL, 0x00000008331b7824ULL, 0x000fe200078e00ffULL,
0x0000000425057212ULL, 0x080fe200078e3cffULL, 0x000000083d407824ULL, 0x000fe200078e00ffULL,
0x0000000433147212ULL, 0x000fe400078e3cffULL, 0x0000002c0d417810ULL, 0x000fc40007ffe0ffULL,
0xfffffff832327812ULL, 0x000fe400078ee205ULL, 0x000000300d437810ULL, 0x000fe40007ffe0ffULL,
0x000000043d057212ULL, 0x080fe400078e3cffULL, 0xfffffff81b3e7812ULL, 0x000fe200078ee214ULL,
0x00000008411b7824ULL, 0x000fe200078e00ffULL, 0x000000080d197810ULL, 0x000fe20007ffe0ffULL,
0x0000000843467824ULL, 0x000fe200078e00ffULL, 0x0000000441147212ULL, 0x000fc400078e3cffULL,
0x000000380d477810ULL, 0x000fe20007ffe0ffULL, 0x0000000819207824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe400078ee205ULL, 0x0000000443057212ULL, 0x080fe400078e3cffULL,
0xfffffff81b447812ULL, 0x000fe200078ee214ULL, 0x00000008471b7824ULL, 0x000fe200078e00ffULL,
0x000000100d1d7810ULL, 0x000fe40007ffe0ffULL, 0x00000004190f7212ULL, 0x000fc400078e3cffULL,
0x0000000447147212ULL, 0x000fe200078e3cffULL, 0x000000081d267824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe400078ee205ULL, 0x000000070d057812ULL, 0x040fe400078e4804ULL,
0xfffffff820207812ULL, 0x000fe400078ee20fULL, 0x0000001c0d317810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81b4a7812ULL, 0x000fc400078ee214ULL, 0x000000041d0f7212ULL, 0x080fe200078e3cffULL,
0x0000000831367824ULL, 0x000fe200078e00ffULL, 0x0ffffff805147812ULL, 0x000fe400078ef804ULL,
0xfffffff826267812ULL, 0x000fe400078ee20fULL, 0x000000280d3f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001014057824ULL, 0x000fe200078e0227ULL, 0x00000004310f7212ULL, 0x000fe400078e3cffULL,
0x0000004012127817ULL, 0x000fe20003800000ULL, 0x000000083f427824ULL, 0x000fe200078e00ffULL,
0x0000003f16147812ULL, 0x000fc400078ef80dULL, 0x0000003f16187812ULL, 0x040fe400078ef815ULL,
0x0000003f161e7812ULL, 0x000fe400078ef819ULL, 0xfffffff836367812ULL, 0x000fe400078ee20fULL,
0x000000340d457810ULL, 0x040fe40007ffe0ffULL, 0x000000120d00720cULL, 0x000fe40003f06070ULL,
0x0000003f16227812ULL, 0x000fe200078ef80bULL, 0x0000000845487824ULL, 0x000fe200078e00ffULL,
0x000000043f0f7212ULL, 0x000fc400078e3cffULL, 0x000000121500720cULL, 0x080fe20003f26070ULL,
0x00005e0014147625ULL, 0x080fe200078e0037ULL, 0x000000121900720cULL, 0x080fe40003f46070ULL,
0x000000120b00720cULL, 0x000fe20003f66070ULL, 0x000000101a0b7824ULL, 0x000fe200078e0227ULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x00005e0018187625ULL, 0x080fe200078e0037ULL,
0x0000003c0d497810ULL, 0x000fe40007ffe0ffULL, 0x00000004450f7212ULL, 0x080fe200078e3cffULL,
0x00005e001e1a7625ULL, 0x000fe200078e0037ULL, 0x0000000449347212ULL, 0x000fc400078e3cffULL,
0x00000003494b7819ULL, 0x000fe200000006ffULL, 0x00005e00221e7625ULL, 0x000fe200078e0037ULL,
0xfffffff848487812ULL, 0x000fe400078ee20fULL, 0x0000003f16227812ULL, 0x040fe200078ef823ULL,
0x0000001035147825ULL, 0x000fe200078e0014ULL, 0xfffffff84b587812ULL, 0x000fe400078ee234ULL,
0x0000003f16347812ULL, 0x000fe200078ef831ULL, 0x0000001035187825ULL, 0x000fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014057faeULL, 0x0003e2000c101c46ULL,
0x000000121d00720cULL, 0x000fc40003f06070ULL, 0x00000010200d7824ULL, 0x000fe200078e0227ULL,
0x0000003f16207812ULL, 0x000fe200078ef81dULL, 0x00000010351a7825ULL, 0x000fe200078e001aULL,
0x00000000180b7faeULL, 0x0005e2000c901c46ULL, 0x000000122300720cULL, 0x000fe40003f26070ULL,
0x00000010240f7824ULL, 0x000fe200078e0227ULL, 0x0000003f16247812ULL, 0x040fe200078ef825ULL,
0x00000010351e7825ULL, 0x000fe200078e001eULL, 0x000000001a0d7faeULL, 0x0007e2000d101c46ULL,
0x0000003f163c7812ULL, 0x000fc400078ef833ULL, 0x000000122500720cULL, 0x080fe20003f46070ULL,
0x000000001e0f7faeULL, 0x0009e2000d901c46ULL, 0x00005e0020147625ULL, 0x082fe200078e0037ULL,
0x000000123100720cULL, 0x080fe40003f66070ULL, 0x000000123300720cULL, 0x080fe20003f86070ULL,
0x00005e0022187625ULL, 0x084fe200078e0037ULL, 0x0000003f16207812ULL, 0x000fe400078ef83dULL,
0x000000124700720cULL, 0x000fe20003fa6070ULL, 0x00005e00241a7625ULL, 0x008fe200078e0037ULL,
0x0000003f16247812ULL, 0x000fc400078ef83fULL, 0x000000124900720cULL, 0x000fe20003fc6070ULL,
0x00005e00341e7625ULL, 0x010fe200078e0037ULL, 0x0000003f16347812ULL, 0x000fc600078ef847ULL,
0x00005e003c227625ULL, 0x000fc800078e0037ULL, 0x0000001026057824ULL, 0x000fe200078e0227ULL,
0x0000003f16267812ULL, 0x000fe200078ef841ULL, 0x0000001035147825ULL, 0x000fc800078e0014ULL,
0x00000010300b7824ULL, 0x000fe200078e0227ULL, 0x0000000014057faeULL, 0x0003e2000c101c46ULL,
0x0000001035187825ULL, 0x000fe200078e0018ULL, 0x000000123d00720cULL, 0x080fe40003f06070ULL,
0x0000003f16307812ULL, 0x000fe200078ef843ULL, 0x00000010320d7824ULL, 0x000fe200078e0227ULL,
0x00000000180b7faeULL, 0x0005e2000c901c46ULL, 0x00000010351a7825ULL, 0x000fe200078e001aULL,
0x000000123f00720cULL, 0x080fe40003f26070ULL, 0x0000003f16327812ULL, 0x000fe200078ef845ULL,
0x00000010360f7824ULL, 0x000fe200078e0227ULL, 0x000000001a0d7faeULL, 0x0007e2000d101c46ULL,
0x00000010351e7825ULL, 0x000fe200078e001eULL, 0x000000124100720cULL, 0x000fc40003f46070ULL,
0x0000003f16167812ULL, 0x000fe200078ef849ULL, 0x000000103e1d7824ULL, 0x000fe200078e0227ULL,
0x000000001e0f7faeULL, 0x0009e2000d901c46ULL, 0x0000001035227825ULL, 0x000fe200078e0022ULL,
0x000000124300720cULL, 0x080fe40003f66070ULL, 0x00000027420b7211ULL, 0x004fe200078e20ffULL,
0x00005e0020147625ULL, 0x082fe200078e0037ULL, 0x00000000221d7faeULL, 0x0003e2000e101c46ULL,
0x000000124500720cULL, 0x000fe40003f86070ULL, 0x00005e0024187625ULL, 0x000fc800078e0037ULL,
0x00005e00261a7625ULL, 0x008fc800078e0037ULL, 0x00005e00301e7625ULL, 0x010fc800078e0037ULL,
0x00005e0032227625ULL, 0x002fc800078e0037ULL, 0x0000001040057824ULL, 0x100fe400078e0227ULL,
0x00000010440d7824ULL, 0x100fe400078e0227ULL, 0x00000010460f7824ULL, 0x100fe400078e0227ULL,
0x00000010481d7824ULL, 0x100fe400078e0227ULL, 0x000000104a317824ULL, 0x100fe400078e0227ULL,
0x0000001058337824ULL, 0x000fc400078e0227ULL, 0x00005e0034247625ULL, 0x000fc800078e0037ULL,
0x00005e0016267625ULL, 0x000fc800078e0037ULL, 0x0000001035147825ULL, 0x000fc800078e0014ULL,
0x0000001035187825ULL, 0x040fe200078e0018ULL, 0x0000000014057faeULL, 0x0003e6000c101c46ULL,
0x00000010351a7825ULL, 0x040fe200078e001aULL, 0x00000000180b7faeULL, 0x0003e6000c901c46ULL,
0x00000010351e7825ULL, 0x040fe200078e001eULL, 0x000000001a0d7faeULL, 0x0003e6000d101c46ULL,
0x0000001035227825ULL, 0x040fe200078e0022ULL, 0x000000001e0f7faeULL, 0x0003e6000d901c46ULL,
0x0000001035247825ULL, 0x040fe200078e0024ULL, 0x00000000221d7faeULL, 0x0003e6000e101c46ULL,
0x0000001035267825ULL, 0x000fe200078e0026ULL, 0x0000000024317faeULL, 0x0003e8000e901c46ULL,
0x0000000026337faeULL, 0x0003e2000f101c46ULL, 0x0000098000007947ULL, 0x000fea0003800000ULL,
0x00000003ff0b7819ULL, 0x000fe20000011604ULL, 0x00005800ff0d7624ULL, 0x000fc400078e00ffULL,
0x0000000878147824ULL, 0x000fe200078e00ffULL, 0x000000040b157810ULL, 0x000fe20007ffe0ffULL,
0x000000400d127824ULL, 0x000fe200078e00ffULL, 0x000000100b1b7810ULL, 0x000fe40007ffe0ffULL,
0x00000004150d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0x0000001c0b237810ULL, 0x000fe20007ffe0ffULL, 0x000000081b1f7824ULL, 0x040fe200078e00ffULL,
0x000000041b187212ULL, 0x000fe200078e3cffULL, 0x0000000412127e24ULL, 0x020fe2000f8e0205ULL,
0xfffffff816167812ULL, 0x000fe200078ee20dULL, 0x0000000823317824ULL, 0x000fe200078e00ffULL,
0x0000000c0b0d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81f267812ULL, 0x000fe400078ee218ULL,
0xfffffff8140f7812ULL, 0x000fe400078ee20fULL, 0x000000180b1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001026477824ULL, 0x000fe200078e0227ULL, 0x0000000423187212ULL, 0x080fe400078e3cffULL,
0x000000080b197810ULL, 0x000fe20007ffe0ffULL, 0x000000081f257824ULL, 0x000fe200078e00ffULL,
0x000000040d147212ULL, 0x000fc400078e3cffULL, 0x000000030d1d7819ULL, 0x000fe200000006ffULL,
0x00000008191e7824ULL, 0x000fe200078e00ffULL, 0x000000280b337810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8313e7812ULL, 0x000fe400078ee218ULL, 0xfffffff81d227812ULL, 0x000fe200078ee214ULL,
0x0000000833377824ULL, 0x000fe200078e00ffULL, 0x000000240b317810ULL, 0x040fe20007ffe0ffULL,
0x000000103e597824ULL, 0x000fe200078e0227ULL, 0x000000140b1d7810ULL, 0x000fc40007ffe0ffULL,
0x000000041f147212ULL, 0x080fe200078e3cffULL, 0x0000000831357824ULL, 0x000fe200078e00ffULL,
0x0000000419057212ULL, 0x080fe200078e3cffULL, 0x000000081d327824ULL, 0x000fe200078e00ffULL,
0x0000000433187212ULL, 0x080fe400078e3cffULL, 0xfffffff825367812ULL, 0x000fe400078ee214ULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee205ULL, 0x000000200b257810ULL, 0x000fe20007ffe0ffULL,
0x00000010364b7824ULL, 0x000fe200078e0227ULL, 0x0000000431147212ULL, 0x000fc400078e3cffULL,
0xfffffff8374a7812ULL, 0x000fe200078ee218ULL, 0x0000000825427824ULL, 0x000fe200078e00ffULL,
0x000000041d057212ULL, 0x080fe400078e3cffULL, 0x000000300b377810ULL, 0x000fe20007ffe0ffULL,
0x000000104a6b7824ULL, 0x000fe200078e0227ULL, 0xfffffff835467812ULL, 0x000fe400078ee214ULL,
0xfffffff832327812ULL, 0x000fe200078ee205ULL, 0x00000008373f7824ULL, 0x000fe200078e00ffULL,
0x0000002c0b357810ULL, 0x040fe20007ffe0ffULL, 0x0000001046697824ULL, 0x100fe200078e0227ULL,
0x000000340b3d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001032497824ULL, 0x000fe200078e0227ULL,
0x0000003c0b437810ULL, 0x000fe20007ffe0ffULL, 0x00000008355a7824ULL, 0x000fe200078e00ffULL,
0x0000000425057212ULL, 0x080fe200078e3cffULL, 0x000000083d417824ULL, 0x000fe200078e00ffULL,
0x0000000437147212ULL, 0x000fe200078e3cffULL, 0x0000000843867824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fc400078ee205ULL, 0x0000000435057212ULL, 0x080fe400078e3cffULL,
0x000000043d187212ULL, 0x080fe400078e3cffULL, 0xfffffff83f6a7812ULL, 0x000fe400078ee214ULL,
0x0000000443457212ULL, 0x000fe400078e3cffULL, 0x000000380b3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000106a6f7824ULL, 0x000fe200078e0227ULL, 0xfffffff85a5a7812ULL, 0x000fc400078ee205ULL,
0xfffffff8416e7812ULL, 0x000fe400078ee218ULL, 0x0000003f12147812ULL, 0x000fe200078ef80bULL,
0x000000105a6d7824ULL, 0x000fe200078e0227ULL, 0xfffffff886867812ULL, 0x000fe200078ee245ULL,
0x00000200ff457424ULL, 0x000fe200078e00ffULL, 0x000000070b057812ULL, 0x000fe200078e4804ULL,
0x00000010160b7824ULL, 0x100fe200078e0227ULL, 0x000000043f417212ULL, 0x040fe200078e3cffULL,
0x000000106e717824ULL, 0x100fe200078e0227ULL, 0x000000033f727819ULL, 0x000fe200000006ffULL,
0x0000001086757824ULL, 0x000fe200078e0227ULL, 0x0000003f12187812ULL, 0x000fe200078ef815ULL,
0x00005e0014147625ULL, 0x000fe200078e0045ULL, 0x0000003f121a7812ULL, 0x000fc400078ef819ULL,
0x0000003f12207812ULL, 0x000fe200078ef80dULL, 0x00005e0018187625ULL, 0x080fe200078e0045ULL,
0x0000003f12247812ULL, 0x040fe400078ef81bULL, 0x0000003f12307812ULL, 0x000fe200078ef81dULL,
0x000000101e0d7824ULL, 0x000fe200078e0227ULL, 0x0000003f12347812ULL, 0x000fe200078ef81fULL,
0x00005e001a1a7625ULL, 0x080fe200078e0045ULL, 0x0000003f123c7812ULL, 0x040fe400078ef823ULL,
0x0000003f12407812ULL, 0x000fe200078ef825ULL, 0x00000010221d7824ULL, 0x000fe200078e0227ULL,
0x0000003f12447812ULL, 0x000fe200078ef831ULL, 0x00005e00201e7625ULL, 0x000fe200078e0045ULL,
0x0000003f12487812ULL, 0x000fc400078ef833ULL, 0x0000003f12587812ULL, 0x000fe200078ef835ULL,
0x00005e0024227625ULL, 0x080fe200078e0045ULL, 0x0000003f12687812ULL, 0x040fe400078ef837ULL,
0x0000003f126c7812ULL, 0x000fe200078ef83dULL, 0x00005e0030247625ULL, 0x000fe200078e0045ULL,
0x0000003f12707812ULL, 0x040fe400078ef83fULL, 0x0000003f12747812ULL, 0x000fe200078ef843ULL,
0x000000100f147825ULL, 0x000fe200078e0014ULL, 0x0ffffff805127812ULL, 0x000fc400078ef804ULL,
0xfffffff872727812ULL, 0x000fe200078ee241ULL, 0x00005e003c307625ULL, 0x000fe200078e0045ULL,
0x00000027425b7211ULL, 0x000fc600078e20ffULL, 0x0000001012057824ULL, 0x100fe400078e0227ULL,
0x0000001072737824ULL, 0x000fe400078e0227ULL, 0x00005e0034267625ULL, 0x000fe200078e0045ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014057faeULL, 0x0003e6000b901c46ULL,
0x000000100f187825ULL, 0x000fc800078e0018ULL, 0x00005e0040327625ULL, 0x000fe200078e0045ULL,
0x00000000180b7faeULL, 0x0003e6000b901c46ULL, 0x000000100f1a7825ULL, 0x000fc800078e001aULL,
0x00005e0044347625ULL, 0x000fe200078e0045ULL, 0x000000001a0d7faeULL, 0x0003e6000b901c46ULL,
0x000000100f1e7825ULL, 0x000fc800078e001eULL, 0x00005e0048367625ULL, 0x000fe200078e0045ULL,
0x000000001e1d7faeULL, 0x0003e6000b901c46ULL, 0x000000100f227825ULL, 0x000fc800078e0022ULL,
0x00005e00583c7625ULL, 0x000fe200078e0045ULL, 0x0000000022477faeULL, 0x0003e6000b901c46ULL,
0x000000100f247825ULL, 0x000fc800078e0024ULL, 0x00005e00683e7625ULL, 0x000fe200078e0045ULL,
0x0000000024497faeULL, 0x0003e6000b901c46ULL, 0x000000100f267825ULL, 0x000fc800078e0026ULL,
0x00005e006c407625ULL, 0x000fe200078e0045ULL, 0x00000000264b7faeULL, 0x0003e6000b901c46ULL,
0x000000100f307825ULL, 0x000fc800078e0030ULL, 0x00005e0070427625ULL, 0x000fe200078e0045ULL,
0x0000000030597faeULL, 0x0003e6000b901c46ULL, 0x000000100f327825ULL, 0x000fc800078e0032ULL,
0x00005e0074447625ULL, 0x000fe200078e0045ULL, 0x00000000325b7faeULL, 0x0003e6000b901c46ULL,
0x000000100f347825ULL, 0x000fc800078e0034ULL, 0x000000100f367825ULL, 0x040fe200078e0036ULL,
0x0000000034697faeULL, 0x0003e6000b901c46ULL, 0x000000100f3c7825ULL, 0x040fe200078e003cULL,
0x00000000366b7faeULL, 0x0003e6000b901c46ULL, 0x000000100f3e7825ULL, 0x040fe200078e003eULL,
0x000000003c6d7faeULL, 0x0003e6000b901c46ULL, 0x000000100f407825ULL, 0x040fe200078e0040ULL,
0x000000003e6f7faeULL, 0x0003e6000b901c46ULL, 0x000000100f427825ULL, 0x040fe200078e0042ULL,
0x0000000040717faeULL, 0x0003e6000b901c46ULL, 0x000000100f447825ULL, 0x000fe200078e0044ULL,
0x0000000042737faeULL, 0x0003e8000b901c46ULL, 0x0000000044757faeULL, 0x0003e4000b901c46ULL,
0x00000300ff057624ULL, 0x002fe200078e00ffULL, 0x00000003760b7812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000030b00780cULL, 0x000fc40003f05270ULL,
0xfffffffd05057811ULL, 0x000fe200078e10ffULL, 0x02463c00ff0b7984ULL, 0x000e660000000800ULL,
0x0000000105057807ULL, 0x000fca0004000000ULL, 0x0000000176767824ULL, 0x000fe400078e0205ULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x0000002f7600720cULL, 0x000fda0003f06070ULL,
0x0000000400158802ULL, 0x000fe20000000f00ULL, 0x0000000176148824ULL, 0x000fc800078e0208ULL,
0x0000600014148625ULL, 0x000fca00078e0015ULL, 0x0000000614058981ULL, 0x000562000c1e1900ULL,
0x800000000c127824ULL, 0x000fca00078e00ffULL, 0x800000000bff7812ULL, 0x002fe20007804812ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000c0d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b000c7305ULL, 0x0002e4000021f000ULL, 0x3fa000000b0b7823ULL, 0x002fe200000100ffULL,
0x0000000c0000735dULL, 0x008fe40003800000ULL, 0x02463c00ff0c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fc4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x024180000e0d7984ULL, 0x000e620000000800ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0001380011187811ULL, 0x000fe400078e20ffULL,
0x000000060d00720bULL, 0x002fda0003f1d000ULL, 0x00000000000b7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0b0f7812ULL, 0x000fe4000780c0ffULL, 0x024380000e0b7984ULL, 0x0002f60000000800ULL,
0x0000034000008947ULL, 0x000fea0003800000ULL, 0x000000060d00720bULL, 0x002fe40003f14000ULL,
0x0000000d06117209ULL, 0x000fc40007810000ULL, 0x00000002ff157819ULL, 0x004fc60000011604ULL,
0x80000011060c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400000e0100ULL, 0x000000037800780cULL, 0x000fe40003f05270ULL,
0x0000ffff06127812ULL, 0x000fe200078e3cffULL, 0x0000000c000c7308ULL, 0x000e660000000800ULL,
0x000000120fff7212ULL, 0x000fce000782c0ffULL, 0x024580110e008388ULL, 0x000fe80000000800ULL,
0x00001f150c067589ULL, 0x002e6400000e0000ULL, 0x800000110d0f1221ULL, 0x000fe40000010000ULL,
0x0000000c07077220ULL, 0x000fe20000410000ULL, 0x00001f130c0d7589ULL, 0x00052200000e0000ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL, 0x0000000f00101308ULL, 0x000ee20000000800ULL,
0x00000001ff0c7807ULL, 0x004fe20000800000ULL, 0x000000065c5c7220ULL, 0x082fe40000410000ULL,
0x000000065d5d7220ULL, 0x080fe40000410000ULL, 0x0000000654547220ULL, 0x080fe40000410000ULL,
0x0000000655557220ULL, 0x080fe40000410000ULL, 0x0000000650507220ULL, 0x000fc40000410000ULL,
0x0000000651517220ULL, 0x080fe40000410000ULL, 0x0000000628287220ULL, 0x080fe40000410000ULL,
0x0000000629297220ULL, 0x080fe40000410000ULL, 0x0000000638387220ULL, 0x080fe40000410000ULL,
0x0000000639397220ULL, 0x080fe40000410000ULL, 0x0000000664647220ULL, 0x000fc40000410000ULL,
0x0000000665657220ULL, 0x080fe40000410000ULL, 0x000000064c4c7220ULL, 0x080fe40000410000ULL,
0x000000064d4d7220ULL, 0x080fe40000410000ULL, 0x0000000660607220ULL, 0x080fe40000410000ULL,
0x0000000661617220ULL, 0x000fe40000410000ULL, 0x0000000d5e5e7220ULL, 0x010fc40000410000ULL,
0x0000000d5f5f7220ULL, 0x080fe40000410000ULL, 0x0000000d56567220ULL, 0x080fe40000410000ULL,
0x0000000d57577220ULL, 0x080fe40000410000ULL, 0x0000000d52527220ULL, 0x080fe40000410000ULL,
0x0000000d53537220ULL, 0x080fe40000410000ULL, 0x0000000d2a2a7220ULL, 0x000fc40000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000d3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000d3b3b7220ULL, 0x080fe40000410000ULL, 0x0000000d66667220ULL, 0x080fe40000410000ULL,
0x0000000d67677220ULL, 0x080fe40000410000ULL, 0x0000000d4e4e7220ULL, 0x000fc40000410000ULL,
0x0000000d4f4f7220ULL, 0x080fe40000410000ULL, 0x0000000d62627220ULL, 0x080fe40000410000ULL,
0x0000000d63637220ULL, 0x000fe40000410000ULL, 0x000000ffff067224ULL, 0x000fe400078e0011ULL,
0x0000000b100b1220ULL, 0x008fe40000410000ULL, 0x000080400000791aULL, 0x002fc80000000000ULL,
0x000000001818783bULL, 0x000fe20000000200ULL, 0x00000010ff0d723eULL, 0x000fe400000010ffULL,
0x00000002ff117819ULL, 0x000fe20000011604ULL, 0x000000002c24783bULL, 0x000fe20000004200ULL,
0x000138001c1c7811ULL, 0x000fe400078e20ffULL, 0x0001380021217811ULL, 0x000fe200078e20ffULL,
0x000000000234783bULL, 0x0003e80000004200ULL, 0x000000000330783bULL, 0x000fe20000004200ULL,
0x000054100d027816ULL, 0x002fc6000000000dULL, 0x00000000003c783bULL, 0x000fe20000004200ULL,
0x000099100c0d7816ULL, 0x000fe400000000ffULL, 0x00013800170c7811ULL, 0x000fe200078e20ffULL,
0x00001f1102117589ULL, 0x000e6200000e0000ULL, 0x000000ff0d00720cULL, 0x000fc60003f05270ULL,
0x00001f1302127589ULL, 0x000f2800000e0000ULL, 0x000000000c0c783bULL, 0x000ea80000000200ULL,
0x000000007a14783bULL, 0x004fe80000004200ULL, 0x000000001c1c783bULL, 0x000ea20000000200ULL,
0x0000001118188231ULL, 0x002fc400003400ffULL, 0x000000111a1a8231ULL, 0x000fe400003400ffULL,
0x0000001219198231ULL, 0x090fe400003400ffULL, 0x000000121b1b8231ULL, 0x000fce00003400ffULL,
0x00000024185c723cULL, 0x040ff0000004185cULL, 0x000000261854723cULL, 0x000fe20000041854ULL,
0x000000007724783bULL, 0x000e620000004200ULL, 0x000000110c0c8231ULL, 0x000fc400003400ffULL,
0x000000110e0e8231ULL, 0x080fe400003400ffULL, 0x000000120d0d8231ULL, 0x080fe400003400ffULL,
0x000000301850723cULL, 0x040fe20000041850ULL, 0x000000120f0f8231ULL, 0x080fe400003400ffULL,
0x000000111c1c8231ULL, 0x084fe400003400ffULL, 0x000000111e1e8231ULL, 0x000fe400003400ffULL,
0x000000121d1d8231ULL, 0x080fe200003400ffULL, 0x000000321830723cULL, 0x000fe20000041828ULL,
0x000000007b28783bULL, 0x000ea20000004200ULL, 0x000000121f1f8231ULL, 0x000fcc00003400ffULL,
0x0000003c184c723cULL, 0x040ff0000004184cULL, 0x000000341838723cULL, 0x040ff00000041838ULL,
0x000000361864723cULL, 0x040fe20000041864ULL, 0x000000008034783bULL, 0x000fee0000004200ULL,
0x0000003e183c723cULL, 0x000fe20000041860ULL, 0x000000007c18783bULL, 0x000fe80000004200ULL,
0x000000002160783bULL, 0x000f260000000200ULL, 0x000000140c5c723cULL, 0x040ff0000004185cULL,
0x000000160c40723cULL, 0x040fe20000041854ULL, 0x000000007d14783bULL, 0x000ee80000004200ULL,
0x000000008154783bULL, 0x000fe60000004200ULL, 0x000000240c50723cULL, 0x042ff00000041850ULL,
0x000000260c44723cULL, 0x040fe20000041830ULL, 0x000000007e24783bULL, 0x000e680000004200ULL,
0x000000007f30783bULL, 0x000e660000004200ULL, 0x000000280c38723cULL, 0x004fe20000041838ULL,
0x0000001160608231ULL, 0x010fc400003400ffULL, 0x0000001162628231ULL, 0x000fca00003400ffULL,
0x0000002a0c48723cULL, 0x040fe20000041864ULL, 0x000000008428783bULL, 0x000ea20000004200ULL,
0x0000001261618231ULL, 0x080fe400003400ffULL, 0x0000001263638231ULL, 0x000fe200003400ffULL,
0x000000008264783bULL, 0x000f260000004200ULL, 0x000000180c4c723cULL, 0x040ff0000004184cULL,
0x0000001a0c3c723cULL, 0x000fe2000004183cULL, 0x00000000830c783bULL, 0x000eae0000004200ULL,
0x000000141c5c723cULL, 0x048ff0000004185cULL, 0x000000241c50723cULL, 0x042ff00000041850ULL,
0x000000301c38723cULL, 0x040ff00000041838ULL, 0x000000161c40723cULL, 0x040ff00000041840ULL,
0x000000261c44723cULL, 0x040ff00000041844ULL, 0x000000321c48723cULL, 0x040ff00000041848ULL,
0x000000341c4c723cULL, 0x040ff0000004184cULL, 0x000000361c3c723cULL, 0x000ff0000004183cULL,
0x00000054605c723cULL, 0x040ff0000004185cULL, 0x000000286050723cULL, 0x044ff00000041850ULL,
0x000000646038723cULL, 0x050ff00000041838ULL, 0x000000566054723cULL, 0x040ff00000041840ULL,
0x0000002a6028723cULL, 0x040ff00000041844ULL, 0x000000666064723cULL, 0x040ff00000041848ULL,
0x0000000c604c723cULL, 0x040ff0000004184cULL, 0x0000000e6060723cULL, 0x000fe2000004183cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fdc0000008000ULL, 0x02464000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000070b077221ULL, 0x000fe20000010000ULL, 0x000000010a317812ULL, 0x000fce00078ec0ffULL,
0x0000030079797a10ULL, 0x000fe40007ffe0ffULL, 0x000000ff09ff7812ULL, 0x000fc4000780c0ffULL,
0x0000002d7900720cULL, 0x000fe40003f26070ULL, 0x00000001ff097807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff79d000007947ULL, 0x000fea000383ffffULL,
0x00000000002c7919ULL, 0x008e640000002500ULL, 0x0000002d2c00720cULL, 0x002fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff337224ULL, 0x000fe200078e0007ULL, 0x0000a77000167802ULL, 0x000fe40000000f00ULL,
0x0000bbf000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000007ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000803037811ULL, 0x004fe400078ff0ffULL, 0x00000002ff057819ULL, 0x028fc80000011602ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0500027589ULL, 0x000ee200000e0000ULL,
0x0000005e035e7220ULL, 0x044fe40000410000ULL, 0x0000005f035f7220ULL, 0x000fe40000410000ULL,
0x0000005c025c7220ULL, 0x048fe40000410000ULL, 0x0000005d025d7220ULL, 0x000fc40000410000ULL,
0x0000005402547220ULL, 0x040fe40000410000ULL, 0x0000005502557220ULL, 0x040fe40000410000ULL,
0x0000005002507220ULL, 0x040fe40000410000ULL, 0x0000005102517220ULL, 0x040fe40000410000ULL,
0x0000002802287220ULL, 0x040fe40000410000ULL, 0x0000002902297220ULL, 0x000fc40000410000ULL,
0x0000003802387220ULL, 0x040fe40000410000ULL, 0x0000003902397220ULL, 0x040fe40000410000ULL,
0x0000006402647220ULL, 0x040fe40000410000ULL, 0x0000006502657220ULL, 0x040fe40000410000ULL,
0x0000004c024c7220ULL, 0x040fe40000410000ULL, 0x0000004d024d7220ULL, 0x000fc40000410000ULL,
0x0000006002607220ULL, 0x040fe40000410000ULL, 0x0000006102617220ULL, 0x000fe40000410000ULL,
0x0000005603567220ULL, 0x040fe40000410000ULL, 0x0000005703577220ULL, 0x040fe40000410000ULL,
0x0000005203527220ULL, 0x040fe40000410000ULL, 0x0000005303537220ULL, 0x000fc40000410000ULL,
0x0000002a032a7220ULL, 0x040fe40000410000ULL, 0x0000002b032b7220ULL, 0x040fe40000410000ULL,
0x0000003a033a7220ULL, 0x040fe40000410000ULL, 0x0000003b033b7220ULL, 0x040fe40000410000ULL,
0x0000006603667220ULL, 0x040fe40000410000ULL, 0x0000006703677220ULL, 0x000fc40000410000ULL,
0x0000004e034e7220ULL, 0x040fe40000410000ULL, 0x0000004f034f7220ULL, 0x040fe40000410000ULL,
0x0000006203627220ULL, 0x040fe40000410000ULL, 0x0000006303637220ULL, 0x000fe40000410000ULL,
0x00000000001e7919ULL, 0x000ea20000000000ULL, 0x0000005c5d03723eULL, 0x000fe400000010ffULL,
0x000000545504723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000282908723eULL, 0x000fc400000010ffULL, 0x0000002a2b10723eULL, 0x000fe400000010ffULL,
0x000000505105723eULL, 0x020fe400000010ffULL, 0x000000383909723eULL, 0x000fe400000010ffULL,
0x00000064650a723eULL, 0x000fe400000010ffULL, 0x0000004c4d0b723eULL, 0x000fe400000010ffULL,
0x00000060610c723eULL, 0x000fc400000010ffULL, 0x0000005e5f0d723eULL, 0x000fe400000010ffULL,
0x00000056570e723eULL, 0x000fe400000010ffULL, 0x00000052530f723eULL, 0x000fe400000010ffULL,
0x00000002ff217819ULL, 0x004fe4000001161eULL, 0x000000081e2f7811ULL, 0x000fe400078ff0ffULL,
0x0000000321027819ULL, 0x040fe200000006ffULL, 0x0000000821167824ULL, 0x040fe200078e00ffULL,
0x0000000721007812ULL, 0x000fe200078ec0ffULL, 0x000000082f187824ULL, 0x000fe200078e00ffULL,
0x00000021ff237212ULL, 0x000fc400078e33ffULL, 0x0000002fff317212ULL, 0x000fe400078e33ffULL,
0xfffffff802157812ULL, 0x000fe400078ee221ULL, 0x0000000100027812ULL, 0x000fe400078e3cffULL,
0xfffffff816237812ULL, 0x000fe400078ee223ULL, 0xfffffff818317812ULL, 0x000fe200078ee231ULL,
0x0000000821177824ULL, 0x000fe200078e0202ULL, 0x0000000200167812ULL, 0x000fe200078e3cffULL,
0x0000080078027824ULL, 0x000fe200078e00ffULL, 0x0000000300187812ULL, 0x000fc400078e3cffULL,
0x00000004001a7812ULL, 0x040fe200078e3cffULL, 0x0000000821197824ULL, 0x040fe200078e0216ULL,
0x00000005001c7812ULL, 0x040fe200078e3cffULL, 0x00000008211b7824ULL, 0x040fe200078e0218ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x00000008211d7824ULL, 0x000fe200078e021aULL,
0x000000072f187812ULL, 0x000fe200078ec0ffULL, 0x00000008211f7824ULL, 0x000fe200078e021cULL,
0x0000003a3b11723eULL, 0x000fe200000010ffULL, 0x0000000821217824ULL, 0x000fe200078e0200ULL,
0x0001200002007810ULL, 0x000fe20007ffe0ffULL, 0x000000041e167824ULL, 0x000fe200078e00ffULL,
0x00000002181c7812ULL, 0x040fe200078e3cffULL, 0x000000082f1a7824ULL, 0x000fe200078e00ffULL,
0x00000003181e7812ULL, 0x000fe200078e3cffULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x0000001017177824ULL, 0x100fe200078e0200ULL,
0xfffffff81a257812ULL, 0x000fe200078ee22fULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0x00000001181a7812ULL, 0x040fe200078e3cffULL, 0x000000101d1d7824ULL, 0x100fe200078e0200ULL,
0x0000000418207812ULL, 0x040fe200078e3cffULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0x0000000518227812ULL, 0x000fe200078e3cffULL, 0x0000000116177824ULL, 0x000fe200078e0217ULL,
0x0000000618247812ULL, 0x000fe200078e3cffULL, 0x0000000115187824ULL, 0x000fe200078e0216ULL,
0x0000000019197211ULL, 0x000fe200078e20ffULL, 0x000000082f297824ULL, 0x040fe200078e021cULL,
0x0000001a2f277211ULL, 0x040fe200078e18ffULL, 0x000000082f2b7824ULL, 0x000fe200078e021eULL,
0x0000000318007388ULL, 0x0005e20000000800ULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x000000666712723eULL, 0x000fe200000010ffULL, 0x000000082f2d7824ULL, 0x000fe200078e0222ULL,
0x0000000417007388ULL, 0x0007e20000000800ULL, 0x0000001023237824ULL, 0x000fe200078e0200ULL,
0x0000004e4f13723eULL, 0x000fe200000010ffULL, 0x00000001161b7824ULL, 0x040fe200078e021bULL,
0x000000002d2d7211ULL, 0x000fe200078e20ffULL, 0x000000082f157824ULL, 0x000fe200078e0220ULL,
0x000000626314723eULL, 0x000fe200000010ffULL, 0x0000000116187824ULL, 0x004fc400078e0219ULL,
0x0000001025257824ULL, 0x100fe400078e0200ULL, 0x00000001161a7824ULL, 0x040fe200078e021dULL,
0x0000000518007388ULL, 0x0007e20000000800ULL, 0x00000001ff037424ULL, 0x000fe400078e00ffULL,
0x0000001027277824ULL, 0x000fe200078e0200ULL, 0x000000081b007388ULL, 0x0007e20000000800ULL,
0x00000001161f7824ULL, 0x000fe200078e021fULL, 0x0000030003007a0cULL, 0x000fe20003f05270ULL,
0x000000082f2f7824ULL, 0x000fe200078e0224ULL, 0x000000091a007388ULL, 0x0007e20000000800ULL,
0x0000001029297824ULL, 0x000fc400078e0200ULL, 0x000000102b2b7824ULL, 0x100fe200078e0200ULL,
0x0000000a1f007388ULL, 0x0007e20000000800ULL, 0x00000001161c7824ULL, 0x040fe400078e0221ULL,
0x0000000116237824ULL, 0x040fe200078e0223ULL, 0x0000002b162b7210ULL, 0x040fe20007ffe0ffULL,
0x00000001161e7824ULL, 0x040fe200078e0225ULL, 0x0000000b1c007388ULL, 0x0007e20000000800ULL,
0x0000001015157824ULL, 0x100fe400078e0200ULL, 0x0000001031317824ULL, 0x000fe200078e0200ULL,
0x0000000c23007388ULL, 0x0007e20000000800ULL, 0x0000000116277824ULL, 0x000fc400078e0227ULL,
0x000000102f2f7824ULL, 0x000fe200078e0200ULL, 0x0000000d1e007388ULL, 0x0007e20000000800ULL,
0x0000000116207824ULL, 0x040fe400078e0229ULL, 0x0000000116227824ULL, 0x040fe200078e0215ULL,
0x0000000e27007388ULL, 0x0007e20000000800ULL, 0x0000000116317824ULL, 0x040fe400078e0231ULL,
0x00000001162d7824ULL, 0x040fe200078e022dULL, 0x0000000f20007388ULL, 0x0007e20000000800ULL,
0x0000000116167824ULL, 0x000fc600078e022fULL, 0x000000102b007388ULL, 0x0007e80000000800ULL,
0x0000001122007388ULL, 0x0007e80000000800ULL, 0x000000122d007388ULL, 0x0007e80000000800ULL,
0x0000001316007388ULL, 0x0007e80000000800ULL, 0x0000001431007388ULL, 0x0007e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002d0000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x00005800ff047624ULL, 0x008fe200078e00ffULL,
0x000000ff7800720cULL, 0x000fe20003f25270ULL, 0x00002000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000147919ULL, 0x000ee80000002700ULL, 0x0000000000057919ULL, 0x000ee20000002600ULL,
0x00000010030b7824ULL, 0x044fe200078e0202ULL, 0x00000020030f7810ULL, 0x000fc40007ffe0ffULL,
0x0000004003117810ULL, 0x040fe40007ffe0ffULL, 0x012000000b187984ULL, 0x0005220000000c00ULL,
0x0000006003137810ULL, 0x040fe20007ffe0ffULL, 0x0000580014147a24ULL, 0x008fe400078e0205ULL,
0x012200000b1c7984ULL, 0x0004e20000000c00ULL, 0x0000030004057a24ULL, 0x000fe200078e02ffULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000030014047a24ULL, 0x000fe200078e02ffULL,
0x012400000b207984ULL, 0x0004620000000c00ULL, 0x0000660005057a24ULL, 0x000fe200078e02ffULL,
0x000000ff7800720cULL, 0x000fe20000705670ULL, 0x00000001040a7824ULL, 0x000fe200078e022cULL,
0x012600000b247984ULL, 0x0004640000000c00ULL, 0x00001fff05157811ULL, 0x000fc400078e40ffULL,
0x01ffffff05057812ULL, 0x000fe400078ec0ffULL, 0x0000000a15087211ULL, 0x000fca00078f98ffULL,
0x00006c0008087625ULL, 0x000fcc00078e0009ULL, 0x0000080078087825ULL, 0x000fcc00078e0008ULL,
0x000000100f0e7825ULL, 0x000fc800078e0008ULL, 0x0000001011107825ULL, 0x000fc800078e0008ULL,
0x0000001013127825ULL, 0x000fc800078e0008ULL, 0x00000010030c7825ULL, 0x000fe200078e0008ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x01cea20000000000ULL,
0x00000080ff167424ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0205ULL,
0x0000000408177819ULL, 0x004fe400000006ffULL, 0x00000001ff287819ULL, 0x000fe20000011608ULL,
0x00006c000a087625ULL, 0x080fe200078e0016ULL, 0x0000007017177812ULL, 0x000fe400078ec0ffULL,
0x0000000c28287812ULL, 0x000fe200078ec0ffULL, 0x00006c000b0a7625ULL, 0x000fc600078e0016ULL,
0x0000000828087210ULL, 0x140fe40007b5e017ULL, 0x0000000a280a7210ULL, 0x000fe40007d9e017ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000000608007986ULL, 0x0005e8000c101906ULL, 0x000000070a007986ULL, 0x0005e4000c101906ULL,
0x000000180c007986ULL, 0x01c5e2000c101d06ULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x0000001c0e007986ULL, 0x0005e8000c101d06ULL, 0x0000002010007986ULL, 0x0025e8000c101d06ULL,
0x0000002412007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x00000001ff097424ULL, 0x000fe400078e00ffULL,
0x00000004ff077424ULL, 0x000fc600078e00ffULL, 0x0000030009097a10ULL, 0x000fe20007ffe1ffULL,
0x00006a0014067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000009060679a8ULL, 0x000ee400099ee1c6ULL,
0x000000090600720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x00000008ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x000ee40000000000ULL, 0x000000ff0600720cULL, 0x008fda0003f05270ULL,
0x0000287000008947ULL, 0x000fea0003800000ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe20000011603ULL,
0x00000080ff177424ULL, 0x000fe200078e00ffULL, 0x0000000104087810ULL, 0x002fe40007ffe0ffULL,
0x0000007006197812ULL, 0x004fe400078ec0ffULL, 0x0000000c070c7812ULL, 0x000fe200078ec0ffULL,
0x00006c0004067625ULL, 0x000fc800078e0017ULL, 0x00006c0008087625ULL, 0x000fe200078e0017ULL,
0x000000060c067210ULL, 0x000fc8000791e019ULL, 0x000000080c087210ULL, 0x000fe40007b5e019ULL,
0x00000007ff077210ULL, 0x000fe400007e24ffULL, 0x00000009ff097210ULL, 0x000fc600017e64ffULL,
0x00000006060a7981ULL, 0x000368000c1e1900ULL, 0x00000006080b7981ULL, 0x000362000c1e1900ULL,
0x00000300ff0e7624ULL, 0x000fca00078e00ffULL, 0x000000020e00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204067810ULL, 0x002fca0007ffe0ffULL,
0x00006c0006067625ULL, 0x000fca00078e0017ULL, 0x000000060c067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x00000006060d7981ULL, 0x000362000c1e1900ULL,
0x000000040e00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304067810ULL, 0x002fca0007ffe0ffULL, 0x00006c0006067625ULL, 0x000fca00078e0017ULL,
0x000000060c067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x00000006060f7981ULL, 0x000362000c1e1900ULL, 0x000000040e00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404067810ULL, 0x002fca0007ffe0ffULL,
0x00006c0006067625ULL, 0x000fca00078e0017ULL, 0x000000060c067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000606117981ULL, 0x000362000c1e1900ULL,
0x000000060e00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504067810ULL, 0x002fca0007ffe0ffULL, 0x00006c0006067625ULL, 0x000fca00078e0017ULL,
0x000000060c067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606137981ULL, 0x000362000c1e1900ULL, 0x000000060e00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080e00780cULL, 0x002fe40003f06070ULL,
0x0000000604067810ULL, 0x000fca0007ffe0ffULL, 0x00006c0006067625ULL, 0x000fca00078e0017ULL,
0x000000060c067210ULL, 0x000fe40007a3e019ULL, 0x0000000704080810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff077210ULL, 0x000fc60000fe44ffULL, 0x00006c0008080625ULL, 0x000fca00078e0017ULL,
0x000000080c080210ULL, 0x000fe40007c7e019ULL, 0x0000000606197981ULL, 0x000364000c1e1900ULL,
0x00000009ff090210ULL, 0x000fca0001fe84ffULL, 0x00000006081b0981ULL, 0x000368000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x004fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fe400078e0004ULL, 0x000000ffff097224ULL, 0x020fe400078e000aULL,
0x000000ffff127224ULL, 0x000fc600078e00ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000112127810ULL, 0x000fc80007ffe0ffULL, 0x0000000412007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000810067810ULL, 0x040fe40007ffe0ffULL,
0x0000000110077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000090a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000808067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x0000000403097819ULL, 0x000fe400000006ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00006c0006067625ULL, 0x000fe200078e0007ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000060c067210ULL, 0x000fc80007b3e009ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606097981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000910067810ULL, 0x042fe40007ffe0ffULL, 0x0000000210077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000b0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000908067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00000010030b7824ULL, 0x000fe400078e00ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000060c067210ULL, 0x000fc80007b3e00bULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x00000006060b7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000310077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006c0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c0d7812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e00dULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x00000006060d7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000410077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c0f7812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007b3e00fULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x00000006060f7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000510077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000110a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006c0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c117812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e011ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606117981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000610077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x000000130a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c137812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007b3e013ULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x0000000606137981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000710077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e08067810ULL, 0x000fe20007ffe0ffULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x0000008000077802ULL, 0x000fe40000000f00ULL,
0x00000001ff0e7819ULL, 0x000fe40000011603ULL, 0x000000700c177812ULL, 0x000fe200078ec0ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e017ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f10067810ULL, 0x002fe40007ffe0ffULL, 0x0000001b0a0a7209ULL, 0x000fe40007810000ULL,
0x0000030006007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c177812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007a3e017ULL,
0x00000007ff077210ULL, 0x000fca0000fe44ffULL, 0x00000006061b7981ULL, 0x000368000c1e1900ULL,
0x0000000810107810ULL, 0x000fe40007ffe0ffULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000001003067824ULL, 0x00afe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000106077824ULL, 0x000fca00078e0207ULL, 0x0000000a07007388ULL, 0x0203e40000000800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001003067824ULL, 0x040fe200078e00ffULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x00002000ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000415167211ULL, 0x000fe200078f98ffULL, 0x0000000104177824ULL, 0x000fe200078e0205ULL,
0x00000001ff077819ULL, 0x002fe20000011603ULL, 0x0000100078227824ULL, 0x004fe200078e00ffULL,
0x0000007006087812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000c07097812ULL, 0x000fe200078ec0ffULL, 0x00006c0016067625ULL, 0x000fe200078e000bULL,
0x00000040030b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000060030d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108157824ULL, 0x000fe200078e0209ULL,
0x0000002003097810ULL, 0x040fe20007ffe0ffULL, 0x0000080078067825ULL, 0x000fe200078e0006ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000002203137211ULL, 0x000fe200078e20ffULL, 0x00000080ff0e8424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000015157984ULL, 0x000e620000000800ULL, 0x00006c00170e8625ULL, 0x000fe200078e000eULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000001009087825ULL, 0x000fe200078e0006ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x000000100b0a7825ULL, 0x000fc800078e0006ULL, 0x000000100d0c7825ULL, 0x000fc800078e0006ULL,
0x0000001078198824ULL, 0x000fe400078e0203ULL, 0x00006c0004108625ULL, 0x000fc600078e0011ULL,
0x0000458019198811ULL, 0x000fe200078e20ffULL, 0x0000001003067825ULL, 0x000fc800078e0006ULL,
0x00000010781b8824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000006137faeULL, 0x0005e2000b901c46ULL, 0x00000010030e8825ULL, 0x000fc600078e000eULL,
0x000041801b1b8811ULL, 0x000fe200078e20ffULL, 0x0000001003108825ULL, 0x000fe200078e0010ULL,
0x0038000008137faeULL, 0x0007e6000b901c46ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x005800000a137faeULL, 0x0009e2000b901c46ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x004fe4000001ff00ULL, 0x007800000c137faeULL, 0x0005e8000b901c46ULL,
0x000000000e198faeULL, 0x000be2000b901c46ULL, 0x0000000000087805ULL, 0x008fc6000001ff00ULL,
0x00000000101b8faeULL, 0x0007e2000b901c46ULL, 0x00000000000a7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x004fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x020fe2000001ff00ULL,
0x0000000000107805ULL, 0x008fe2000001ff00ULL, 0x00000d7000009947ULL, 0x000fea0003800000ULL,
0x0000000104367810ULL, 0x002fe20007ffe0ffULL, 0x00000001ff047424ULL, 0x000fe200078e00ffULL,
0x0000000117347810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000116357810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fda0003f06070ULL,
0x0000025000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x00002000ff167424ULL, 0x000fe200078e00ffULL, 0x0000000b04187819ULL, 0x040fe400000006ffULL,
0x00000001041b7812ULL, 0x000fe200078ec0ffULL, 0x00006c0035167625ULL, 0x000fe200078e0016ULL,
0x0000080018197812ULL, 0x000fe400078ec0ffULL, 0x00000040031f7810ULL, 0x040fe40007ffe0ffULL,
0x00000020031d7810ULL, 0x040fe20007ffe0ffULL, 0x0000080078167825ULL, 0x000fe200078e0016ULL,
0x0000006003217810ULL, 0x000fc60007ffe0ffULL, 0x0000000122187824ULL, 0x000fe400078e0219ULL,
0x00000080ff398424ULL, 0x000fe400078e00ffULL, 0x0000000278208824ULL, 0x140fe400078e021bULL,
0x0000000278388824ULL, 0x000fe400078e021bULL, 0x00000080ff3b8424ULL, 0x000fe400078e00ffULL,
0x0000001003377824ULL, 0x000fc400078e0218ULL, 0x000000101f1a7825ULL, 0x000fc800078e0016ULL,
0x000000101d187825ULL, 0x000fc800078e0016ULL, 0x00006c00341e8625ULL, 0x000fc800078e0039ULL,
0x00000010211c7825ULL, 0x000fc800078e0016ULL, 0x0000000820398824ULL, 0x000fe400078e0203ULL,
0x00006c0036208625ULL, 0x000fc600078e003bULL, 0x0000458039398811ULL, 0x000fe200078e20ffULL,
0x0000001003167825ULL, 0x000fc800078e0016ULL, 0x0000000838388824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000016377faeULL, 0x0003e2000b901c46ULL,
0x00000010031e8825ULL, 0x000fc600078e001eULL, 0x00004180383b8811ULL, 0x000fe200078e20ffULL,
0x0000001003208825ULL, 0x000fe200078e0020ULL, 0x0038000018377faeULL, 0x0003e8000b901c46ULL,
0x005800001a377faeULL, 0x0003e8000b901c46ULL, 0x007800001c377faeULL, 0x0003e8000b901c46ULL,
0x000000001e398faeULL, 0x0003e8000b901c46ULL, 0x00000000203b8faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff04167810ULL, 0x002fe20007ffe0ffULL,
0x0000001003187824ULL, 0x000fe200078e00ffULL, 0x00000001ff197819ULL, 0x000fc40000011603ULL,
0x00000002ff4b7819ULL, 0x000fe20000011603ULL, 0x0000008016177824ULL, 0x000fe200078e00ffULL,
0x0000007018187812ULL, 0x000fe200078ec0ffULL, 0x0000080016167824ULL, 0x000fe200078e00ffULL,
0x0000000c19197812ULL, 0x000fe200078ec0ffULL, 0x000000084b1e7824ULL, 0x000fe200078e00ffULL,
0x0000008017177812ULL, 0x000fe200078ec0ffULL, 0x000000084b1c7824ULL, 0x040fe200078e00ffULL,
0x000000074b397812ULL, 0x000fe400078ec0ffULL, 0x0000001778177211ULL, 0x000fc400078e40ffULL,
0x000000084b4d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001719197210ULL, 0x000fe20007ffe018ULL,
0x000000084b187824ULL, 0x000fe200078e00ffULL, 0x0000004bff177212ULL, 0x000fe200078e33ffULL,
0x000000084d3d7824ULL, 0x000fe200078e00ffULL, 0x0000004dff477212ULL, 0x000fe200078e33ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000191a7984ULL, 0x000e620000000800ULL,
0xfffffff81e457812ULL, 0x000fe200078ee217ULL, 0x00000004031e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c177812ULL, 0x100fe200078ee239ULL, 0x0045800019497984ULL, 0x0004e20000000800ULL,
0x00000001181b7812ULL, 0x140fe200078ef639ULL, 0x000000084d1c7824ULL, 0x040fe200078e00ffULL,
0x00000002181d7812ULL, 0x140fe200078ef639ULL, 0x000000084d3b7824ULL, 0x000fe200078e00ffULL,
0x00000003181f7812ULL, 0x140fe400078ef639ULL, 0x0000000418217812ULL, 0x000fc400078ef639ULL,
0x0000080016197812ULL, 0x004fe400078ec0ffULL, 0x0000000518377812ULL, 0x000fe400078ef639ULL,
0x0000018022167810ULL, 0x000fe40007ffe019ULL, 0x0000000618397812ULL, 0x000fe400078ef639ULL,
0x0000000c1e207812ULL, 0x000fe200078ec0ffULL, 0x0000001017177824ULL, 0x100fe200078e0216ULL,
0xfffffff81c477812ULL, 0x000fe200078ee247ULL, 0x000000101b1b7824ULL, 0x100fe200078e0216ULL,
0x0000030004007a0cULL, 0x000fe20003f06070ULL, 0x000000101d1d7824ULL, 0x100fe200078e0216ULL,
0x0000001720177210ULL, 0x040fe20007ffe0ffULL, 0x00000001201b7824ULL, 0x000fe200078e021bULL,
0x0000000104047810ULL, 0x000fe20007ffe0ffULL, 0x00000001201d7824ULL, 0x000fe200078e021dULL,
0x0000000134347810ULL, 0x000fe20007ffe0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0216ULL,
0x0000000135357810ULL, 0x000fe20007ffe0ffULL, 0x000000001b1b7984ULL, 0x000fe20000000800ULL,
0x0000001021217824ULL, 0x000fe200078e0216ULL, 0x0000000136367810ULL, 0x000fe20007ffe0ffULL,
0x00000001201f7824ULL, 0x040fe200078e021fULL, 0x000000001d1d7984ULL, 0x000fe20000000800ULL,
0x0000000120217824ULL, 0x000fc400078e0221ULL, 0x0000001a151a7221ULL, 0x002fe40000010100ULL,
0x000000001f1f7984ULL, 0x000fe20000000800ULL, 0x0000001037377824ULL, 0x000fe400078e0216ULL,
0x3fb8aa3b1a187820ULL, 0x000fe20000410000ULL, 0x000000074d1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000120377824ULL, 0x040fe200078e0237ULL, 0x0000000021217984ULL, 0x000fe20000000800ULL,
0x00000018001c7308ULL, 0x0002e20000000800ULL, 0xfffffff83d197812ULL, 0x000fe200078ee21aULL,
0x0000001039397824ULL, 0x000fe200078e0216ULL, 0x000000013b3d7812ULL, 0x140fe200078ef61aULL,
0x0000000037377984ULL, 0x000fe20000000800ULL, 0x000000023b3f7812ULL, 0x140fe200078ef61aULL,
0x0000000120397824ULL, 0x040fe200078e0239ULL, 0x000000033b417812ULL, 0x000fe200078ef61aULL,
0x0000001019197824ULL, 0x000fe200078e0216ULL, 0x000000043b437812ULL, 0x000fe200078ef61aULL,
0x0000001045187824ULL, 0x002fe200078e0216ULL, 0x000000053b457812ULL, 0x000fe200078ef61aULL,
0x000000103f3f7824ULL, 0x000fe200078e0216ULL, 0x000000063b3b7812ULL, 0x000fe200078ef61aULL,
0x0000000120187824ULL, 0x000fe200078e0218ULL, 0x00000000171a7984ULL, 0x000e620000000800ULL,
0x000000491c1c7220ULL, 0x008fe20000410000ULL, 0x000000163d3d7211ULL, 0x000fe200078e20ffULL,
0x0000001041417824ULL, 0x100fe200078e0216ULL, 0x00000000181e7984ULL, 0x000fe20000000800ULL,
0x0000001043437824ULL, 0x100fe200078e0216ULL, 0x0000001920197210ULL, 0x000fe20007ffe0ffULL,
0x0000001045457824ULL, 0x100fe200078e0216ULL, 0x00001f4b1c187589ULL, 0x000ea200000e0000ULL,
0x000000103b3b7824ULL, 0x000fc400078e0216ULL, 0x0000001047477824ULL, 0x000fe200078e0216ULL,
0x0000000039397984ULL, 0x000ee20000000800ULL, 0x00000001203d7824ULL, 0x040fe400078e023dULL,
0x00000001203f7824ULL, 0x040fe200078e023fULL, 0x0000000019197984ULL, 0x000f220000000800ULL,
0x0000000120417824ULL, 0x040fe400078e0241ULL, 0x0000000120437824ULL, 0x000fe200078e0243ULL,
0x000000003d3d7984ULL, 0x000fe20000000800ULL, 0x000000331c337221ULL, 0x000fc40000010000ULL,
0x0000000120457824ULL, 0x040fe200078e0245ULL, 0x000000003f3f7984ULL, 0x000fe20000000800ULL,
0x00000001203b7824ULL, 0x040fe400078e023bULL, 0x0000000120477824ULL, 0x000fe200078e0247ULL,
0x0000000041417984ULL, 0x000fe80000000800ULL, 0x00001f4d1c1c7589ULL, 0x000f6800000e0000ULL,
0x0000000043437984ULL, 0x000ee20000000800ULL, 0x00005410ff177816ULL, 0x002fc6000000001aULL,
0x0000000045457984ULL, 0x000e620000000800ULL, 0x00007610ff167816ULL, 0x000fe2000000001aULL,
0x0000001817327223ULL, 0x004fe20000010032ULL, 0x00005410ff177816ULL, 0x000fc6000000001eULL,
0x0000001816317223ULL, 0x080fe20000010031ULL, 0x00007610ff167816ULL, 0x000fe2000000001eULL,
0x000000003b3b7984ULL, 0x000ea20000000800ULL, 0x0000001817247223ULL, 0x080fe20000010024ULL,
0x00005410ff177816ULL, 0x000fe4000000001bULL, 0x0000001816237223ULL, 0x080fe20000010023ULL,
0x00007610ff167816ULL, 0x000fe2000000001bULL, 0x0000000047477984ULL, 0x000e620000000800ULL,
0x0000001817307223ULL, 0x000fe20000010030ULL, 0x00005410ff177816ULL, 0x000fc4000000001dULL,
0x00000018162f7223ULL, 0x080fe2000001002fULL, 0x00007610ff167816ULL, 0x000fe4000000001dULL,
0x00000018172e7223ULL, 0x080fe2000001002eULL, 0x00005410ff177816ULL, 0x000fe4000000001fULL,
0x00000018162d7223ULL, 0x080fe2000001002dULL, 0x00007610ff167816ULL, 0x000fe4000000001fULL,
0x00000018172c7223ULL, 0x000fe2000001002cULL, 0x00005410ff177816ULL, 0x000fc40000000021ULL,
0x00000018162b7223ULL, 0x080fe2000001002bULL, 0x00007610ff167816ULL, 0x000fe40000000021ULL,
0x00000018172a7223ULL, 0x080fe2000001002aULL, 0x00005410ff177816ULL, 0x000fe40000000037ULL,
0x0000001816297223ULL, 0x080fe20000010029ULL, 0x00007610ff167816ULL, 0x000fe40000000037ULL,
0x0000001817287223ULL, 0x000fe20000010028ULL, 0x00005410ff177816ULL, 0x008fc40000000039ULL,
0x0000001816277223ULL, 0x080fe20000010027ULL, 0x00007610ff167816ULL, 0x000fe40000000039ULL,
0x0000001817267223ULL, 0x080fe20000010026ULL, 0x00005410ff177816ULL, 0x010fe40000000019ULL,
0x0000001816257223ULL, 0x000fe20000010025ULL, 0x00007610ff167816ULL, 0x000fe40000000019ULL,
0x0000001c17147223ULL, 0x020fe20000010014ULL, 0x00005410ff177816ULL, 0x000fc4000000003dULL,
0x0000001c16137223ULL, 0x080fe20000010013ULL, 0x00007610ff167816ULL, 0x000fe4000000003dULL,
0x0000001c17127223ULL, 0x080fe20000010012ULL, 0x00005410ff177816ULL, 0x000fe4000000003fULL,
0x0000001c16117223ULL, 0x080fe20000010011ULL, 0x00007610ff167816ULL, 0x000fe4000000003fULL,
0x0000001c17107223ULL, 0x000fe20000010010ULL, 0x00005410ff177816ULL, 0x000fc40000000041ULL,
0x0000001c160f7223ULL, 0x080fe2000001000fULL, 0x00007610ff167816ULL, 0x000fe40000000041ULL,
0x0000001c170e7223ULL, 0x080fe2000001000eULL, 0x00005410ff177816ULL, 0x000fe40000000043ULL,
0x0000001c160d7223ULL, 0x080fe2000001000dULL, 0x00007610ff167816ULL, 0x000fe40000000043ULL,
0x0000001c170c7223ULL, 0x000fe2000001000cULL, 0x00005410ff177816ULL, 0x002fc40000000045ULL,
0x0000001c160b7223ULL, 0x080fe2000001000bULL, 0x00007610ff167816ULL, 0x000fe40000000045ULL,
0x0000001c170a7223ULL, 0x080fe2000001000aULL, 0x00005410ff177816ULL, 0x004fe4000000003bULL,
0x0000001c16097223ULL, 0x080fe20000010009ULL, 0x00007610ff167816ULL, 0x000fe4000000003bULL,
0x0000001c17087223ULL, 0x000fe20000010008ULL, 0x00005410ff177816ULL, 0x000fc40000000047ULL,
0x0000001c16077223ULL, 0x080fe20000010007ULL, 0x00007610ff167816ULL, 0x000fe40000000047ULL,
0x0000001c17067223ULL, 0x000fc60000010006ULL, 0x0000001c16057223ULL, 0x000fe20000010005ULL,
0xfffff2e000008947ULL, 0x000fea000383ffffULL, 0x0180000033037810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000d51000167802ULL, 0x000fe40000000f00ULL,
0x00008e5000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc80000000033ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000167919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff187819ULL, 0x010fe40000011616ULL,
0x00000008161a7811ULL, 0x040fe200078ff0ffULL, 0x0000000416167824ULL, 0x000fe400078e00ffULL,
0x00001f1803047589ULL, 0x00cea200000e0000ULL, 0x00000008181c7824ULL, 0x000fe200078e00ffULL,
0x000000031a337819ULL, 0x042fe200000006ffULL, 0x000000081a417824ULL, 0x000fe200078e00ffULL,
0x00001f1a03157589ULL, 0x0002e200000e0000ULL, 0x0000000c16167812ULL, 0x000fc400078ec0ffULL,
0xfffffff833337812ULL, 0x000fca00078ee21aULL, 0x0000001033337824ULL, 0x000fe200078e0200ULL,
0x00000018ff037212ULL, 0x002fc800078e33ffULL, 0xfffffff81c217812ULL, 0x000fe200078ee203ULL,
0x0000000818037824ULL, 0x000fc800078e00ffULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0xfffffff803037812ULL, 0x000fe200078ee218ULL, 0x0000003204327220ULL, 0x044fe40000410000ULL,
0x0000003104317220ULL, 0x040fe40000410000ULL, 0x0000003004307220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x000000323131723eULL, 0x000fe200000010ffULL,
0x0000002e042e7220ULL, 0x000fc40000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000010ffULL, 0x0000002c042c7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e2d2d723eULL, 0x000fe200000010ffULL,
0x0000002a042a7220ULL, 0x040fe40000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000010ffULL, 0x0000002804287220ULL, 0x000fc40000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000010ffULL,
0x0000002604267220ULL, 0x040fe40000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x0000002404247220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fe20000410000ULL, 0x0000001aff047212ULL, 0x000fe200078e33ffULL,
0x0000000615067220ULL, 0x008fe20000410000ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x0000000515057220ULL, 0x000fe20000410000ULL, 0xfffffff841417812ULL, 0x000fe200078ee204ULL,
0x0000001415147220ULL, 0x040fe20000410000ULL, 0x0000000718047812ULL, 0x000fe200078ec0ffULL,
0x0000001315137220ULL, 0x000fe20000410000ULL, 0x000000060505723eULL, 0x000fe200000010ffULL,
0x0000001215127220ULL, 0x040fe20000410000ULL, 0x000000071a067812ULL, 0x000fe200078ec0ffULL,
0x0000001115117220ULL, 0x040fe20000410000ULL, 0x0000000204177812ULL, 0x040fe200078e3cffULL,
0x0000001015107220ULL, 0x040fe20000410000ULL, 0x00000004041b7812ULL, 0x040fe200078e3cffULL,
0x0000000f150f7220ULL, 0x040fe20000410000ULL, 0x0000000304197812ULL, 0x040fe200078e3cffULL,
0x0000000e150e7220ULL, 0x040fe20000410000ULL, 0x00000005041d7812ULL, 0x040fe200078e3cffULL,
0x0000000d150d7220ULL, 0x040fe20000410000ULL, 0x00000006041f7812ULL, 0x000fe200078e3cffULL,
0x0000000c150c7220ULL, 0x040fe20000410000ULL, 0x0000000106357812ULL, 0x040fe200078e3cffULL,
0x0000000b150b7220ULL, 0x040fe20000410000ULL, 0x0000000206377812ULL, 0x040fe200078e3cffULL,
0x0000000a150a7220ULL, 0x040fe20000410000ULL, 0x0000000306397812ULL, 0x040fe200078e3cffULL,
0x0000000915097220ULL, 0x040fe20000410000ULL, 0x00000004063b7812ULL, 0x040fe200078e3cffULL,
0x0000000815087220ULL, 0x040fe20000410000ULL, 0x00000005063d7812ULL, 0x000fe200078e3cffULL,
0x0000000715077220ULL, 0x000fe20000410000ULL, 0x0000000104157812ULL, 0x000fe200078e3cffULL,
0x0000000818177824ULL, 0x000fe200078e0217ULL, 0x00000006063f7812ULL, 0x000fe200078e3cffULL,
0x00000008181b7824ULL, 0x000fe200078e021bULL, 0x0000003b1a3b7211ULL, 0x000fe200078e18ffULL,
0x0000000818157824ULL, 0x040fe200078e0215ULL, 0x000000080707723eULL, 0x000fe200000010ffULL,
0x0000000818197824ULL, 0x040fe200078e0219ULL, 0x000000001b1b7211ULL, 0x000fe200078e20ffULL,
0x00000008181d7824ULL, 0x040fe200078e021dULL, 0x0000000a0909723eULL, 0x000fe200000010ffULL,
0x00000008181f7824ULL, 0x000fe200078e021fULL, 0x0000000c0b0b723eULL, 0x000fe200000010ffULL,
0x000000081a357824ULL, 0x040fe200078e0235ULL, 0x0000000e0d0d723eULL, 0x000fe200000010ffULL,
0x000000081a377824ULL, 0x040fe200078e0237ULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x000000081a397824ULL, 0x040fe200078e0239ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x000000081a3d7824ULL, 0x040fe200078e023dULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x000000081a3f7824ULL, 0x000fe200078e023fULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000001003037824ULL, 0x000fc400078e0200ULL, 0x0000001015157824ULL, 0x100fe400078e0200ULL,
0x0000001017177824ULL, 0x100fe400078e0200ULL, 0x0000001019197824ULL, 0x100fe400078e0200ULL,
0x0000001041417824ULL, 0x000fe400078e0200ULL, 0x0000000103047824ULL, 0x000fe400078e0216ULL,
0x000000101d1d7824ULL, 0x100fe200078e0200ULL, 0x00000041161e7210ULL, 0x000fe20007ffe0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x0000003104007388ULL, 0x0003e20000000800ULL,
0x0000001035357824ULL, 0x000fc400078e0200ULL, 0x0000001037377824ULL, 0x100fe400078e0200ULL,
0x0000001039397824ULL, 0x100fe400078e0200ULL, 0x000000103b3b7824ULL, 0x100fe400078e0200ULL,
0x000000103d3d7824ULL, 0x100fe400078e0200ULL, 0x000000103f3f7824ULL, 0x000fe400078e0200ULL,
0x0000000116007824ULL, 0x040fe200078e0215ULL, 0x0000003d161c7210ULL, 0x040fe20007ffe0ffULL,
0x0000000116067824ULL, 0x000fc400078e0217ULL, 0x0000000116087824ULL, 0x040fe200078e0219ULL,
0x0000002f00007388ULL, 0x0005e20000000800ULL, 0x00000001160a7824ULL, 0x040fe400078e021bULL,
0x00000001160c7824ULL, 0x040fe200078e021dULL, 0x0000002d06007388ULL, 0x0005e20000000800ULL,
0x00000001160e7824ULL, 0x040fe400078e021fULL, 0x0000000116107824ULL, 0x040fe200078e0221ULL,
0x0000002b08007388ULL, 0x0005e20000000800ULL, 0x0000000116127824ULL, 0x000fc400078e0233ULL,
0x0000000116147824ULL, 0x040fe200078e0235ULL, 0x000000290a007388ULL, 0x0005e20000000800ULL,
0x0000000116047824ULL, 0x042fe400078e0237ULL, 0x0000000116187824ULL, 0x040fe200078e0239ULL,
0x000000270c007388ULL, 0x0005e20000000800ULL, 0x00000001161a7824ULL, 0x040fe400078e023bULL,
0x0000000116167824ULL, 0x000fe200078e023fULL, 0x000000250e007388ULL, 0x0005e80000000800ULL,
0x0000002310007388ULL, 0x0005e80000000800ULL, 0x0000001312007388ULL, 0x0005e80000000800ULL,
0x0000001114007388ULL, 0x0005e80000000800ULL, 0x0000000f04007388ULL, 0x0005e80000000800ULL,
0x0000000d18007388ULL, 0x0005e80000000800ULL, 0x0000000b1a007388ULL, 0x0005e80000000800ULL,
0x000000091c007388ULL, 0x0005e80000000800ULL, 0x0000000716007388ULL, 0x0005e80000000800ULL,
0x000000051e007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000a7919ULL, 0x00cea20000002600ULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x0000000878787824ULL, 0x000fe200078e00ffULL,
0x00000000000b7919ULL, 0x000f220000000000ULL, 0x0000000405057899ULL, 0x000fc6000800063fULL,
0x1ffffff878787812ULL, 0x000fe200078ec0ffULL, 0x000000100a037824ULL, 0x044fe200078e00ffULL,
0x00000004050472a4ULL, 0x008fe2000f8e023fULL, 0x000000100a237824ULL, 0x040fe200078e00ffULL,
0x00000003ff047819ULL, 0x010fe2000001160bULL, 0x000000100a257824ULL, 0x000fe200078e00ffULL,
0x000000200b157810ULL, 0x040fe40007ffe0ffULL, 0x000000400b177810ULL, 0x040fe40007ffe0ffULL,
0x000000600b217810ULL, 0x000fc40007ffe0ffULL, 0xfffffff003007812ULL, 0x000fe400078ee204ULL,
0x00000003ff037819ULL, 0x000fe40000011615ULL, 0x00000003ff067819ULL, 0x000fe40000011617ULL,
0x00000003ff087819ULL, 0x002fe40000011621ULL, 0x00000007040c7812ULL, 0x000fe400078e480bULL,
0x0000000703047812ULL, 0x000fc400078e4815ULL, 0x0000000706077812ULL, 0x000fe400078e4817ULL,
0x0000000708097812ULL, 0x000fe400078e4821ULL, 0x0ffffff80c0d7812ULL, 0x000fe400078ef80bULL,
0x0ffffff804057812ULL, 0x000fe200078ef815ULL, 0x000000100a047824ULL, 0x000fe200078e00ffULL,
0x0ffffff807077812ULL, 0x000fe200078ef817ULL, 0x000000100d0c7824ULL, 0x100fe200078e0202ULL,
0x0ffffff809097812ULL, 0x000fe200078ef821ULL, 0x0000001005057824ULL, 0x100fe200078e0202ULL,
0x0000000400007c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0xfffffff004047812ULL, 0x000fe200078ee203ULL, 0x0000001009097824ULL, 0x000fe200078e0202ULL,
0x012000000c0c7984ULL, 0x000e620000000c00ULL, 0x000000ffff037210ULL, 0x000fc400007fe4ffULL,
0x00005a0000027a11ULL, 0x040fe200078048ffULL, 0x0120000005107984ULL, 0x0004e20000000c00ULL,
0xfffffff023067812ULL, 0x000fe400078ee206ULL, 0xfffffff025087812ULL, 0x000fe200078ee208ULL,
0x0120000007187984ULL, 0x0009620000000c00ULL, 0x00005b0000037a11ULL, 0x000fe400000f4c03ULL,
0x0000000408007c10ULL, 0x000fe2000ff5e0ffULL, 0x01200000091c7984ULL, 0x0009620000000c00ULL,
0x0000000404057c10ULL, 0x004fc4000ff1e0ffULL, 0x00000007780b7812ULL, 0x000fe400078ef80bULL,
0x0000000406077c10ULL, 0x010fe2000ff3e0ffULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00005a0000087a11ULL, 0x000fe200078448ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005a0007067a11ULL, 0x000fe200078248ffULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x0000000778157812ULL, 0x000fc400078ef815ULL, 0x00005b0005057a11ULL, 0x000fe400000f4c14ULL,
0x0000000778177812ULL, 0x040fe400078ef817ULL, 0x00005b0007077a11ULL, 0x000fe200008f4c0aULL,
0x0000001015047825ULL, 0x000fe200078e0004ULL, 0x0000000778217812ULL, 0x000fe400078ef821ULL,
0x00005b0000097a11ULL, 0x000fe200010f4c09ULL, 0x0000001017067825ULL, 0x000fc800078e0006ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000000c02007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe8000c101d06ULL, 0x0000001806007986ULL, 0x020fe8000c101d06ULL,
0x0000001c08007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x03ffffff78007812ULL, 0x000fe200078ec0ffULL, 0xffffffffffa17424ULL, 0x000fc800078e00ffULL,
0x0000000479007824ULL, 0x000fca00078e0200ULL, 0x0000002f0000720cULL, 0x000fe40003f06070ULL,
0x0000000179027810ULL, 0x000fd60007ffe0ffULL, 0x0000000208058824ULL, 0x012fc800078e00ffULL,
0x0000640005048a24ULL, 0x000fc800078e0200ULL, 0x0000600004048625ULL, 0x000fca00078e0003ULL,
0x0000000604a18981ULL, 0x000362000c1e1900ULL, 0x0000002d0200720cULL, 0x000fe20003f06070ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004016167824ULL, 0x000fe400078e00ffULL,
0x0000004078027824ULL, 0x000fd200078e00ffULL, 0x00000cc000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7919ULL, 0x002e620000000000ULL, 0x0000010079037824ULL, 0x000fe200078e0202ULL,
0x00002000781a7811ULL, 0x000fe200078e70ffULL, 0x00000200ff217424ULL, 0x000fc600078e00ffULL,
0x000000032e047217ULL, 0x000fc80007800000ULL, 0x0000000403037210ULL, 0x000fe40007ffe1ffULL,
0x00000003ff1e7819ULL, 0x002fc8000001161cULL, 0x000000041e067810ULL, 0x040fe40007ffe0ffULL,
0x000000081e077810ULL, 0x000fe40007ffe0ffULL, 0x0000001c06057212ULL, 0x0c0fe200078e3cffULL,
0x00000008060a7824ULL, 0x000fe200078e00ffULL, 0x0000000c1e0b7810ULL, 0x040fe20007ffe0ffULL,
0x00000008071f7824ULL, 0x000fe200078e00ffULL, 0x000000101e0d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80a1d7812ULL, 0x000fe200078ee205ULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x000000141e137810ULL, 0x000fe20007ffe0ffULL, 0x000000080d0c7824ULL, 0x000fe200078e00ffULL,
0x0000001c07047212ULL, 0x080fe200078e3cffULL, 0x000000101d1d7824ULL, 0x000fe200078e021aULL,
0x0000001c0b057212ULL, 0x080fe200078e3cffULL, 0x0000000813297824ULL, 0x000fe200078e00ffULL,
0x0000001c0d097212ULL, 0x000fc400078e3cffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee204ULL,
0xfffffff80a257812ULL, 0x000fe200078ee205ULL, 0x000000101c057824ULL, 0x000fe200078e00ffULL,
0xfffffff80c277812ULL, 0x000fe200078ee209ULL, 0x00000004a1097e24ULL, 0x020fe2000f8e0216ULL,
0x0000001c130a7212ULL, 0x000fe400078e3cffULL, 0x0000003f1e047812ULL, 0x000fe400078ec0ffULL,
0xfffffff829297812ULL, 0x000fc400078ee20aULL, 0x0000003f070a7812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x100fe200078e0209ULL, 0x0000007005237812ULL, 0x000fe400078ec0ffULL,
0x0000003f0b0c7812ULL, 0x040fe200078ec0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x000000030600720cULL, 0x0c0fe40003f86070ULL, 0x0000003f06067812ULL, 0x000fe200078ec0ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0209ULL, 0x000000030b00720cULL, 0x000fc40003f06070ULL,
0x00000004230e7210ULL, 0x000fe20007f3e0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0021ULL,
0x0000003f0d107812ULL, 0x000fe400078ec0ffULL, 0x000000030700720cULL, 0x000fe20003fa6070ULL,
0x000000010c047824ULL, 0x100fe200078e0209ULL, 0x0000000a230a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000106067824ULL, 0x000fe200078e0209ULL, 0x00000009100c7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e0605ULL, 0x000000030d00720cULL, 0x000fe20003f46070ULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x000000181e197810ULL, 0x000fc40007ffe0ffULL,
0x0000001c1e207810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x080fe200078e0021ULL,
0x000000071e157812ULL, 0x100fe400078e481cULL, 0x0000003f20167812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e060bULL, 0x0000000423127210ULL, 0x000fe20007f7e0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0021ULL, 0x0000003f13047812ULL, 0x000fe400078ec0ffULL,
0x0000000623107210ULL, 0x000fe20007f3e0ffULL, 0x00000008192b7824ULL, 0x040fe200078e00ffULL,
0x0000003f19067812ULL, 0x000fe200078ec0ffULL, 0x0000000104047824ULL, 0x000fe200078e0209ULL,
0x0000000c230c7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0607ULL,
0x000000031300720cULL, 0x000fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200018e0605ULL,
0x000000201e227810ULL, 0x000fe20007ffe0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x0ffffff8151b7812ULL, 0x000fc400078ef81cULL, 0x0000003f22187812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0209ULL, 0x000000031e00720cULL, 0x000fe20003f66070ULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x0000000423147210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x000000241e247810ULL, 0x000fc60007ffe0ffULL,
0x0000000116047824ULL, 0x000fe400078e0209ULL, 0x000000ffff157224ULL, 0x000fe200030e0605ULL,
0x0000000623167210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x0000000918067210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200030e0607ULL,
0x0000000423187210ULL, 0x000fe20007fde0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e021aULL,
0x0000001c19047212ULL, 0x000fe200078e3cffULL, 0x00005e0006067625ULL, 0x000fc600078e0021ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e1b7faeULL, 0x0003e2000d901c46ULL, 0x0000003f24047812ULL, 0x000fe400078ec0ffULL,
0x000000031900720cULL, 0x080fe20003f66070ULL, 0x000000ffff197224ULL, 0x000fe200030e0605ULL,
0x0000000623067210ULL, 0x000fe20007fde0ffULL, 0x0000000104047824ULL, 0x000fe200078e0209ULL,
0x00000000101d7faeULL, 0x0005e2000e101c46ULL, 0x000000032000720cULL, 0x000fe40003f86070ULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x0000001c200f7212ULL, 0x002fc600078e3cffULL,
0x000000101f1b7824ULL, 0x100fe200078e021aULL, 0x0000001c221f7212ULL, 0x000fe200078e3cffULL,
0x0000000820207824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x000000000a1b7faeULL, 0x0003e2000e901c46ULL, 0x000000032200720cULL, 0x040fe20003fa6070ULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x00000004230e7210ULL, 0x000fe20007fde0ffULL,
0x0000001025117824ULL, 0x004fe200078e021aULL, 0xfffffff8201d7812ULL, 0x000fc400078ee20fULL,
0xfffffff8221f7812ULL, 0x000fe400078ee21fULL, 0x00000005ff0f7210ULL, 0x000fe200037fe4ffULL,
0x0000001027057824ULL, 0x100fe200078e021aULL, 0x0000000012117faeULL, 0x0005e2000c101c46ULL,
0x00000010290b7824ULL, 0x102fe200078e021aULL, 0x000000281e0a7810ULL, 0x040fe20007ffe0ffULL,
0x000000102b1b7824ULL, 0x100fe200078e021aULL, 0x000000000c057faeULL, 0x0003e2000d101c46ULL,
0x000000101d1d7824ULL, 0x100fe200078e021aULL, 0x0000002c1e107810ULL, 0x000fe20007ffe0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0x00000000140b7faeULL, 0x0007e2000c901c46ULL,
0x0000001c24047212ULL, 0x000fc400078e3cffULL, 0x000000032400720cULL, 0x000fe20003fc6070ULL,
0x00000000161b7faeULL, 0x0009e2000d901c46ULL, 0x000000301e117810ULL, 0x044fe40007ffe0ffULL,
0x000000381e127810ULL, 0x040fe20007ffe0ffULL, 0x00000000181d7faeULL, 0x0005e2000e101c46ULL,
0x000000341e0d7810ULL, 0x002fe20007ffe0ffULL, 0x00000008100c7824ULL, 0x000fe200078e00ffULL,
0x0000003c1e1e7810ULL, 0x000fe20007ffe0ffULL, 0x00000000061f7faeULL, 0x0003e2000e901c46ULL,
0x00000008240b7824ULL, 0x008fe200078e00ffULL, 0x0000001c0a057212ULL, 0x000fc400078e3cffULL,
0x000000030a00720cULL, 0x080fe20003fa6070ULL, 0x0000000811177824ULL, 0x050fe200078e00ffULL,
0x000000031000720cULL, 0x080fe40003f86070ULL, 0x000000031100720cULL, 0x080fe40003f66070ULL,
0x000000030d00720cULL, 0x080fe20003f46070ULL, 0x000000080a067824ULL, 0x002fe200078e00ffULL,
0x000000031200720cULL, 0x080fe40003f26070ULL, 0x000000031e00720cULL, 0x000fc40003f06070ULL,
0xfffffff80b037812ULL, 0x000fe400078ee204ULL, 0xfffffff806137812ULL, 0x000fe400078ee205ULL,
0x0000003f0a047812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x000fe200078e021aULL,
0x0000001c11067212ULL, 0x080fe400078e3cffULL, 0x0000001c10057212ULL, 0x000fe400078e3cffULL,
0x0000000904047210ULL, 0x000fe20007ffe0ffULL, 0x000000000e037faeULL, 0x0003e2000f101c46ULL,
0xfffffff817177812ULL, 0x000fc400078ee206ULL, 0x0000003f10067812ULL, 0x000fe200078ec0ffULL,
0x000000080d107824ULL, 0x000fe200078e00ffULL, 0xfffffff80c157812ULL, 0x000fe200078ee205ULL,
0x00005e0004047625ULL, 0x080fe200078e0021ULL, 0x0000003f110c7812ULL, 0x000fe400078ec0ffULL,
0x0000001c0d0b7212ULL, 0x000fe200078e3cffULL, 0x0000000106067824ULL, 0x100fe200078e0209ULL,
0x00000004230a7210ULL, 0x000fe20007fde0ffULL, 0x000000010c047824ULL, 0x000fe200078e0209ULL,
0xfffffff810197812ULL, 0x004fe200078ee20bULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000003f0d0e7812ULL, 0x002fc400078ec0ffULL, 0x0000003f12107812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e0605ULL, 0x00000006230c7210ULL, 0x040fe20007fde0ffULL,
0x00005e0004047625ULL, 0x080fe200078e0021ULL, 0x0000003f1e147812ULL, 0x000fe400078ec0ffULL,
0x0000001c12037212ULL, 0x080fe200078e3cffULL, 0x000000010e067824ULL, 0x000fe200078e0209ULL,
0x0000001c1e1c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff0d7224ULL, 0x000fe200030e0607ULL,
0x00000004230e7210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x000000031e1d7819ULL, 0x000fc600000006ffULL, 0x0000000110047824ULL, 0x000fe200078e0209ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee21cULL, 0x000000ffff0f7224ULL, 0x000fe200030e0605ULL,
0x0000000623107210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x000fc800078e0021ULL,
0x0000000114097824ULL, 0x000fe400078e0209ULL, 0x000000ffff117224ULL, 0x000fe200030e0607ULL,
0x0000000423047210ULL, 0x000fe20007fde0ffULL, 0x0000000812127824ULL, 0x000fe400078e00ffULL,
0x00005e0009067625ULL, 0x000fc600078e0021ULL, 0xfffffff8121b7812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000000623067210ULL, 0x000fe20007fde0ffULL,
0x0000001013037824ULL, 0x100fe400078e021aULL, 0x0000001015097824ULL, 0x100fe400078e021aULL,
0x0000001017137824ULL, 0x100fe200078e021aULL, 0x000000000a037faeULL, 0x0003e2000e901c46ULL,
0x0000001019157824ULL, 0x100fe400078e021aULL, 0x000000101b177824ULL, 0x100fe200078e021aULL,
0x000000000c097faeULL, 0x0003e2000e101c46ULL, 0x000000101d197824ULL, 0x000fc400078e021aULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x000000000e137faeULL, 0x0003e8000d901c46ULL,
0x0000000010157faeULL, 0x0003e8000d101c46ULL, 0x0000000004177faeULL, 0x0003e8000c901c46ULL,
0x0000000006197faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x00000004a1167e24ULL, 0x020fc4000f8e0216ULL,
0x00000200ff247424ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x002fc80000011603ULL,
0x00000004040c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000804107810ULL, 0x040fe40007ffe0ffULL,
0x0000000c04147810ULL, 0x000fe20007ffe0ffULL, 0x000000080c0e7824ULL, 0x040fe200078e00ffULL,
0x000000030c057212ULL, 0x080fe400078e3cffULL, 0x00000010041a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0x0000000310067212ULL, 0x000fc400078e3cffULL,
0x0000000310077819ULL, 0x000fe200000006ffULL, 0x000000081a0b7824ULL, 0x000fe200078e00ffULL,
0x0000001804227810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee205ULL,
0x0000001c04287810ULL, 0x000fe20007ffe0ffULL, 0x0000000822267824ULL, 0x000fe200078e00ffULL,
0x0000000314057212ULL, 0x080fe400078e3cffULL, 0xfffffff807127812ULL, 0x000fe200078ee206ULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x000000031a067212ULL, 0x000fc400078e3cffULL,
0x00000020042c7810ULL, 0x040fe40007ffe0ffULL, 0x0000002804367810ULL, 0x040fe40007ffe0ffULL,
0x00000014041e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000322097212ULL, 0x000fe200078e3cffULL,
0x0000000836387824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee205ULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0x0000002c043a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000328057212ULL, 0x080fe400078e3cffULL, 0xfffffff80b1c7812ULL, 0x000fe200078ee206ULL,
0x000000082c0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee209ULL,
0x000000083a3c7824ULL, 0x000fe200078e00ffULL, 0x0000003804467810ULL, 0x040fe40007ffe0ffULL,
0x0000002404327810ULL, 0x000fe40007ffe0ffULL, 0x000000032c067212ULL, 0x080fe200078e3cffULL,
0x0000000846487824ULL, 0x000fe200078e00ffULL, 0x0000000336097212ULL, 0x000fe200078e3cffULL,
0x0000000832347824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fc400078ee205ULL,
0x00000030043e7810ULL, 0x000fe40007ffe0ffULL, 0x000000031e077212ULL, 0x080fe400078e3cffULL,
0x000000033a057212ULL, 0x000fe400078e3cffULL, 0xfffffff80b307812ULL, 0x000fe200078ee206ULL,
0x000000083e0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe400078ee209ULL,
0xfffffff820207812ULL, 0x000fc400078ee207ULL, 0x0000000346097212ULL, 0x080fe400078e3cffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee205ULL, 0x0000000332077212ULL, 0x080fe400078e3cffULL,
0x0000003404427810ULL, 0x000fe40007ffe0ffULL, 0x000000033e067212ULL, 0x000fe400078e3cffULL,
0x0000003f04057812ULL, 0x000fc400078ec0ffULL, 0x00000007040a7812ULL, 0x040fe400078e4803ULL,
0x0000003c04047810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0216ULL,
0xfffffff848487812ULL, 0x000fe400078ee209ULL, 0xfffffff834347812ULL, 0x000fe200078ee207ULL,
0x0000000804277824ULL, 0x000fe200078e00ffULL, 0xfffffff80b407812ULL, 0x000fe200078ee206ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x0000003f0c097812ULL, 0x000fc400078ec0ffULL,
0x0000000342077212ULL, 0x080fe400078e3cffULL, 0x0ffffff80a0a7812ULL, 0x000fe200078ef803ULL,
0x00000001090b7824ULL, 0x000fe200078e0216ULL, 0x00000003040c7212ULL, 0x000fe400078e3cffULL,
0x0000000342447819ULL, 0x000fe400000006ffULL, 0x0000003f04037812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x000fe200078e0024ULL, 0xfffffff844447812ULL, 0x000fc400078ee207ULL,
0x0000200078077811ULL, 0x000fe200078e70ffULL, 0x0000000103477824ULL, 0x000fe200078e0216ULL,
0xfffffff8270c7812ULL, 0x000fe400078ee20cULL, 0x0000003f100d7812ULL, 0x000fe200078ec0ffULL,
0x000000100a097824ULL, 0x100fe200078e0207ULL, 0x0000007006037812ULL, 0x000fe200078ec0ffULL,
0x0000001012297824ULL, 0x100fe200078e0207ULL, 0x0000003f140f7812ULL, 0x000fe200078ec0ffULL,
0x00000010182b7824ULL, 0x100fe200078e0207ULL, 0x0000003f1a117812ULL, 0x000fe200078ec0ffULL,
0x000000101c317824ULL, 0x100fe200078e0207ULL, 0x000000070e277211ULL, 0x080fe200078e20ffULL,
0x0000001020337824ULL, 0x100fe200078e0207ULL, 0x0000000740417211ULL, 0x000fe200078e20ffULL,
0x0000001026357824ULL, 0x100fe200078e0207ULL, 0x0000000403047210ULL, 0x000fe20007f1e0ffULL,
0x000000102a377824ULL, 0x100fe200078e0207ULL, 0x0000003f1e137812ULL, 0x000fe200078ec0ffULL,
0x0000001030397824ULL, 0x100fe200078e0207ULL, 0x0000003f22157812ULL, 0x000fe200078ec0ffULL,
0x00000010343b7824ULL, 0x100fe200078e0207ULL, 0x0000003f28177812ULL, 0x000fe200078ec0ffULL,
0x00000010383d7824ULL, 0x100fe200078e0207ULL, 0x0000001615157210ULL, 0x000fe20007ffe0ffULL,
0x000000103c3f7824ULL, 0x100fe200078e0207ULL, 0x0000003f2c197812ULL, 0x000fe200078ec0ffULL,
0x0000001044437824ULL, 0x100fe200078e0207ULL, 0x0000003f321b7812ULL, 0x000fe200078ec0ffULL,
0x0000001048457824ULL, 0x100fe200078e0207ULL, 0x0000003f361d7812ULL, 0x000fe200078ec0ffULL,
0x000000100c497824ULL, 0x000fe200078e0207ULL, 0x0000003f3a1f7812ULL, 0x000fe200078ec0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0216ULL, 0x0000003f3e217812ULL, 0x000fe200078ec0ffULL,
0x00005e000b067625ULL, 0x000fe200078e0024ULL, 0x0000003f42237812ULL, 0x000fc400078ec0ffULL,
0x0000003f46257812ULL, 0x000fe200078ec0ffULL, 0x000000010f0f7824ULL, 0x100fe400078e0216ULL,
0x0000000111117824ULL, 0x000fe400078e0216ULL, 0x00005e000d0a7625ULL, 0x000fc800078e0024ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000000603067210ULL, 0x000fe20007f1e0ffULL,
0x00005e000f0c7625ULL, 0x000fe200078e0024ULL, 0x0000000a030a7210ULL, 0x000fe40007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e2000b901c46ULL,
0x00005e00110e7625ULL, 0x000fe200078e0024ULL, 0x0000000c030c7210ULL, 0x000fc60007f5e0ffULL,
0x0000000113137824ULL, 0x000fe400078e0216ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000000e030e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0013107625ULL, 0x000fc600078e0024ULL,
0x0000000006277faeULL, 0x0003e2000b901c46ULL, 0x00005e0015127625ULL, 0x000fc800078e0024ULL,
0x0000000117177824ULL, 0x100fe400078e0216ULL, 0x0000000119197824ULL, 0x100fe400078e0216ULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000001203127210ULL, 0x000fe20007f1e0ffULL,
0x000000011b1b7824ULL, 0x100fe400078e0216ULL, 0x000000011d1d7824ULL, 0x100fe400078e0216ULL,
0x000000011f1f7824ULL, 0x000fc400078e0216ULL, 0x0000000121217824ULL, 0x100fe400078e0216ULL,
0x0000000123237824ULL, 0x100fe400078e0216ULL, 0x0000000125257824ULL, 0x000fe400078e0216ULL,
0x00005e0017147625ULL, 0x000fc800078e0024ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001003107210ULL, 0x000fe20007f3e0ffULL, 0x00005e0019167625ULL, 0x000fc600078e0024ULL,
0x000000000a297faeULL, 0x0003e2000b901c46ULL, 0x00005e001b187625ULL, 0x000fc800078e0024ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000001603167210ULL, 0x000fe20007f1e0ffULL,
0x00005e001d1a7625ULL, 0x000fc800078e0024ULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000001403147210ULL, 0x000fe20007f3e0ffULL, 0x00005e001f1c7625ULL, 0x000fc600078e0024ULL,
0x00000015ff157210ULL, 0x000fe20000ffe4ffULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000001c031c7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x0000001803187210ULL, 0x000fe20007f3e0ffULL, 0x00005e00211e7625ULL, 0x000fe200078e0024ULL,
0x0000001a031a7210ULL, 0x000fe40007f5e0ffULL, 0x000000000c2b7faeULL, 0x0003e2000b901c46ULL,
0x00005e0023207625ULL, 0x000fc600078e0024ULL, 0x000000000e317faeULL, 0x0003e2000b901c46ULL,
0x00005e0025227625ULL, 0x000fc600078e0024ULL, 0x0000000010337faeULL, 0x0003e2000b901c46ULL,
0x00005e0047247625ULL, 0x000fc600078e0024ULL, 0x0000000012357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000001e031e7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x0000002003207210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x0000002203227210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x0000002403247210ULL, 0x000fe20007f7e0ffULL,
0x0000000014377faeULL, 0x0003e2000b901c46ULL, 0x000000ffff217224ULL, 0x000fc400008e0621ULL,
0x000000ffff237224ULL, 0x000fe200010e0623ULL, 0x0000000016397faeULL, 0x0003e2000b901c46ULL,
0x000000ffff257224ULL, 0x000fc600018e0625ULL, 0x00000000183b7faeULL, 0x0003e8000b901c46ULL,
0x000000001a3d7faeULL, 0x0003e8000b901c46ULL, 0x000000001c3f7faeULL, 0x0003e8000b901c46ULL,
0x000000001e417faeULL, 0x0003e8000b901c46ULL, 0x0000000020437faeULL, 0x0003e8000b901c46ULL,
0x0000000022457faeULL, 0x0003e8000b901c46ULL, 0x0000000024497faeULL, 0x0003e4000b901c46ULL,
0x02460400ff037984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000003ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x02460400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000002d7900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000640008057a24ULL, 0x000fe200078e02ffULL, 0x0000000478047819ULL, 0x000fe200000006ffULL,
0x00005800ff087624ULL, 0x000fe200078e00ffULL, 0xffffffff2d067810ULL, 0x000fe40007ffe0ffULL,
0x00007610ff077816ULL, 0x000fe20000000007ULL, 0x0000004008087824ULL, 0x000fe400078e00ffULL,
0x0000010079097824ULL, 0x002fe200078e0202ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000092e00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00000001790a7810ULL, 0x000fe20007ffe0ffULL, 0x0000165000007945ULL, 0x000fe60003800000ULL,
0x0000002d0a00720cULL, 0x000fda0003f06070ULL, 0x00000ba000008947ULL, 0x000fea0003800000ULL,
0x00000003ff0a7819ULL, 0x002fe20000011603ULL, 0x00000004082c7e24ULL, 0x000fe2000f8e02a1ULL,
0x0000000703b07812ULL, 0x000fe200078ec0ffULL, 0x000000012e297824ULL, 0x000fe200078e0a09ULL,
0x000000040a0c7810ULL, 0x040fe40007ffe0ffULL, 0x000000140a147810ULL, 0x040fe40007ffe0ffULL,
0x000000100a127810ULL, 0x000fe20007ffe0ffULL, 0x000000080c0b7824ULL, 0x040fe200078e00ffULL,
0x000000030cae7212ULL, 0x080fe200078e3cffULL, 0x00000008140d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0a107810ULL, 0x000fe20007ffe0ffULL, 0x0000000812187824ULL, 0x000fe200078e00ffULL,
0x0000000314aa7212ULL, 0x000fc400078e3cffULL, 0xfffffff80bae7812ULL, 0x000fe200078ee2aeULL,
0x00000008100b7824ULL, 0x000fe200078e00ffULL, 0x0000000312ab7212ULL, 0x080fe400078e3cffULL,
0xfffffff80daa7812ULL, 0x000fe400078ee2aaULL, 0x0000000310ac7212ULL, 0x000fe400078e3cffULL,
0x0000003f0a0d7812ULL, 0x000fe400078ec0ffULL, 0xfffffff818ab7812ULL, 0x000fc400078ee2abULL,
0x000000030a0f7212ULL, 0x040fe200078e3cffULL, 0x000000010de67824ULL, 0x000fe200078e022cULL,
0x0000001c0a187810ULL, 0x040fe40007ffe0ffULL, 0xfffffff80bac7812ULL, 0x000fe200078ee2acULL,
0x00000200ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000240a1c7810ULL, 0x000fe40007ffe0ffULL,
0x000000070f1e7812ULL, 0x000fe200078ec0ffULL, 0x00000008180f7824ULL, 0x000fe200078e00ffULL,
0x000000290a00720cULL, 0x000fe20003f26070ULL, 0x00005e00e6e67625ULL, 0x000fe200078e000bULL,
0x0000000318a87212ULL, 0x000fc400078e3cffULL, 0x000000080a0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000081c117824ULL, 0x000fe200078e00ffULL, 0x0000400078367811ULL, 0x000fe400078e70ffULL,
0x00000008b0397812ULL, 0x000fe200078efcffULL, 0x000000080e167824ULL, 0x000fe200078e00ffULL,
0x0ffffff81eaf7812ULL, 0x000fe200078ef803ULL, 0x00000010ae2b7824ULL, 0x000fe200078e0236ULL,
0x000000031ca67212ULL, 0x000fe200078e3cffULL, 0x00000010391e7825ULL, 0x000fe200078e00e6ULL,
0xfffffff80fa87812ULL, 0x000fc400078ee2a8ULL, 0xfffffff811a67812ULL, 0x000fe200078ee2a6ULL,
0x00000010af197824ULL, 0x100fe200078e0236ULL, 0x0000003f0c0f7812ULL, 0x000fe200078ec0ffULL,
0x00000010ac337824ULL, 0x100fe200078e0236ULL, 0x0000003f0e117812ULL, 0x040fe200078ec0ffULL,
0x00000010ab357824ULL, 0x000fe200078e0236ULL, 0x000000030ead7212ULL, 0x000fe200078e3cffULL,
0x000000010fe47824ULL, 0x100fe200078e022cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e197faeULL, 0x0003e2000c901c46ULL, 0x0000000111e27824ULL, 0x000fe200078e022cULL,
0xfffffff816ad7812ULL, 0x000fe200078ee2adULL, 0x00005e00e4e47625ULL, 0x000fe200078e000bULL,
0x000000180a167810ULL, 0x000fc40007ffe0ffULL, 0x000000290c00720cULL, 0x000fe20003f26070ULL,
0x00005e00e2e27625ULL, 0x000fe200078e000bULL, 0x000000290e00720cULL, 0x000fe40003f46070ULL,
0x0000003f10137812ULL, 0x000fe200078ec0ffULL, 0x00000010aa377824ULL, 0x000fe200078e0236ULL,
0x0000000316a97212ULL, 0x040fe200078e3cffULL, 0x00000010391e7825ULL, 0x002fe200078e00e4ULL,
0x0000000316207819ULL, 0x000fe400000006ffULL, 0x000000200a1a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113e07824ULL, 0x100fe200078e022cULL, 0x0000003f12157812ULL, 0x000fe200078ec0ffULL,
0x000000001e2b7faeULL, 0x0003e2000c901c46ULL, 0x0000003f14177812ULL, 0x000fe200078ec0ffULL,
0x000000081a227824ULL, 0x000fe200078e00ffULL, 0x0000003f16197812ULL, 0x000fe200078ec0ffULL,
0x0000000115de7824ULL, 0x000fe200078e022cULL, 0xfffffff820a97812ULL, 0x000fe200078ee2a9ULL,
0x0000001039207825ULL, 0x000fe200078e00e2ULL, 0x000000291000720cULL, 0x000fc40003f66070ULL,
0x0000003f181b7812ULL, 0x000fe200078ec0ffULL, 0x00005e00e0e07625ULL, 0x000fe200078e000bULL,
0x00000036ad317211ULL, 0x000fe400078e20ffULL, 0x000000031aa77212ULL, 0x000fe200078e3cffULL,
0x0000000117dc7824ULL, 0x100fe200078e022cULL, 0x000000291200720cULL, 0x080fe20003f86070ULL,
0x0000000119da7824ULL, 0x100fe200078e022cULL, 0x000000291400720cULL, 0x000fe20003fa6070ULL,
0x000000011bd87824ULL, 0x000fe200078e022cULL, 0x0000000020317faeULL, 0x0005e2000d101c46ULL,
0x00005e00dede7625ULL, 0x000fe200078e000bULL, 0x000000291600720cULL, 0x000fc40003f26070ULL,
0xfffffff822a77812ULL, 0x000fe200078ee2a7ULL, 0x00005e00dcdc7625ULL, 0x000fe200078e000bULL,
0x000000291800720cULL, 0x000fe40003f46070ULL, 0x0000003f1a1d7812ULL, 0x000fe200078ec0ffULL,
0x0000001039227825ULL, 0x000fe200078e00e0ULL, 0x0000003f1c1e7812ULL, 0x002fe400078ec0ffULL,
0x000000280a207810ULL, 0x004fe20007ffe0ffULL, 0x00005e00dada7625ULL, 0x000fe200078e000bULL,
0x0000000022337faeULL, 0x0003e2000d901c46ULL, 0x000000291a00720cULL, 0x000fc40003f66070ULL,
0x00005e00d8d87625ULL, 0x000fe200078e000bULL, 0x000000380a287810ULL, 0x000fe40007ffe0ffULL,
0x0000000320a57212ULL, 0x080fe200078e3cffULL, 0x0000001039247825ULL, 0x000fe200078e00deULL,
0x0000000328a17212ULL, 0x000fc600078e3cffULL, 0x000000011dd67824ULL, 0x000fe200078e022cULL,
0x0000002c0a227810ULL, 0x002fe20007ffe0ffULL, 0x0000001039267825ULL, 0x000fe200078e00dcULL,
0x0000000024357faeULL, 0x0003e2000e101c46ULL, 0x000000291c00720cULL, 0x000fe40003f86070ULL,
0x00000010a91f7824ULL, 0x000fe200078e0236ULL, 0x0000000026377faeULL, 0x0005e2000e901c46ULL,
0x00000010392a7825ULL, 0x040fe200078e00daULL, 0x0000000322a47212ULL, 0x000fe400078e3cffULL,
0x000000292800720cULL, 0x000fe20003fa6070ULL, 0x00000010a8217824ULL, 0x000fe200078e0236ULL,
0x000000002a1f7faeULL, 0x0007e2000c901c46ULL, 0x0000001039307825ULL, 0x000fe200078e00d8ULL,
0x00000036a6257211ULL, 0x002fc400078e20ffULL, 0x000000300a247810ULL, 0x000fe20007ffe0ffULL,
0x00005e00d6d67625ULL, 0x000fe200078e000bULL, 0x0000000030217faeULL, 0x0003e2000d101c46ULL,
0x000000340a267810ULL, 0x004fe40007ffe0ffULL, 0x000000011ed47824ULL, 0x000fe200078e022cULL,
0x000000292000720cULL, 0x000fe20003f26070ULL, 0x00000010a7237824ULL, 0x000fe200078e0236ULL,
0x0000003c0a2a7810ULL, 0x008fe20007ffe0ffULL, 0x0000001039327825ULL, 0x000fe200078e00d6ULL,
0x0000003f201f7812ULL, 0x000fc400078ec0ffULL, 0x0000000326a27212ULL, 0x000fe200078e3cffULL,
0x00005e00d4d47625ULL, 0x000fe200078e000bULL, 0x0000000032237faeULL, 0x0005e2000d901c46ULL,
0x000000032aa07212ULL, 0x000fe400078e3cffULL, 0x0000000822217824ULL, 0x042fe200078e00ffULL,
0x000000292200720cULL, 0x080fe20003f46070ULL, 0x0000001039347825ULL, 0x000fe200078e00d4ULL,
0x000000292400720cULL, 0x080fe40003f66070ULL, 0xfffffff821a47812ULL, 0x000fe200078ee2a4ULL,
0x0000000826217824ULL, 0x000fe200078e00ffULL, 0x0000000034257faeULL, 0x0003e2000e101c46ULL,
0x0000000820307824ULL, 0x000fe200078e00ffULL, 0x000000292600720cULL, 0x000fe20003f86070ULL,
0x000000082a237824ULL, 0x004fe200078e00ffULL, 0xfffffff821a27812ULL, 0x000fe200078ee2a2ULL,
0x000000011fd07824ULL, 0x000fe200078e022cULL, 0x0000003f22217812ULL, 0x000fe200078ec0ffULL,
0x0000000824327824ULL, 0x000fe200078e00ffULL, 0xfffffff823a07812ULL, 0x000fe200078ee2a0ULL,
0x00005e00d0d07625ULL, 0x000fe200078e000bULL, 0x0000003f24237812ULL, 0x000fc400078ec0ffULL,
0x0000003f26257812ULL, 0x002fe200078ec0ffULL, 0x0000000121ce7824ULL, 0x100fe200078e022cULL,
0x000000292a00720cULL, 0x000fe20003fc6070ULL, 0x0000000123cc7824ULL, 0x000fe200078e022cULL,
0x0000003f28277812ULL, 0x040fe200078ec0ffULL, 0x0000000828347824ULL, 0x000fe200078e00ffULL,
0xfffffff830a57812ULL, 0x000fe200078ee2a5ULL, 0x0000001039307825ULL, 0x000fe200078e00d0ULL,
0x0000003f2a297812ULL, 0x000fe400078ec0ffULL, 0x0000002c25ca7210ULL, 0x000fe20007ffe0ffULL,
0x0000000127c67824ULL, 0x000fe200078e022cULL, 0x0000000324a37212ULL, 0x000fe200078e3cffULL,
0x00000010a52b7824ULL, 0x000fe200078e0236ULL, 0xfffffff834a17812ULL, 0x000fe200078ee2a1ULL,
0x00000001292c7824ULL, 0x000fe200078e022cULL, 0xfffffff832a37812ULL, 0x000fe200078ee2a3ULL,
0x00005e00cece7625ULL, 0x080fe200078e000bULL, 0x00000000302b7faeULL, 0x0003e6000c901c46ULL,
0x00005e00cccc7625ULL, 0x000fc800078e000bULL, 0x00005e00caca7625ULL, 0x000fc800078e000bULL,
0x00005e00c6c67625ULL, 0x000fc800078e000bULL, 0x00005e002cc47625ULL, 0x000fc800078e000bULL,
0x00000010a42b7824ULL, 0x002fe400078e0236ULL, 0x0000001039307825ULL, 0x000fc800078e00ceULL,
0x00000010a33b7824ULL, 0x000fe200078e0236ULL, 0x00000000302b7faeULL, 0x0003e2000d101c46ULL,
0x0000001039327825ULL, 0x000fc800078e00ccULL, 0x00000010a23d7824ULL, 0x100fe200078e0236ULL,
0x00000000323b7faeULL, 0x0003e2000d901c46ULL, 0x00000010a13f7824ULL, 0x100fe400078e0236ULL,
0x00000010a0417824ULL, 0x000fe400078e0236ULL, 0x0000001039347825ULL, 0x000fc800078e00caULL,
0x0000001039367825ULL, 0x040fe200078e00c6ULL, 0x00000000343d7faeULL, 0x0003e6000e101c46ULL,
0x0000001039387825ULL, 0x000fe200078e00c4ULL, 0x00000000363f7faeULL, 0x0003e8000e901c46ULL,
0x0000000038417faeULL, 0x0003e2000f101c46ULL, 0x00000a8000007947ULL, 0x000fea0003800000ULL,
0x00000003ff0a7819ULL, 0x002fe20000011603ULL, 0x00000004082c7e24ULL, 0x000fe2000f8e02a1ULL,
0x0000000703b07812ULL, 0x000fc400078ec0ffULL, 0x000000080a0e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c0a107810ULL, 0x000fe40007ffe0ffULL, 0x000000030ead7212ULL, 0x0c0fe200078e3cffULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0x000000040a0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008100d7824ULL, 0x040fe200078e00ffULL, 0x0000000310ac7212ULL, 0x000fe400078e3cffULL,
0xfffffff812ad7812ULL, 0x000fe200078ee2adULL, 0x000000080c0b7824ULL, 0x000fe200078e00ffULL,
0x000000100a127810ULL, 0x000fc40007ffe0ffULL, 0x000000180a167810ULL, 0x040fe40007ffe0ffULL,
0x0000001c0a187810ULL, 0x000fe40007ffe0ffULL, 0x0000000312ab7212ULL, 0x080fe200078e3cffULL,
0x00000008161c7824ULL, 0x000fe200078e00ffULL, 0x00000003121a7819ULL, 0x000fe400000006ffULL,
0xfffffff80dac7812ULL, 0x000fe200078ee2acULL, 0x00000008180d7824ULL, 0x000fe200078e00ffULL,
0x000000030cae7212ULL, 0x000fc400078e3cffULL, 0x000000140a147810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81aab7812ULL, 0x000fe400078ee2abULL, 0x0000000316a97212ULL, 0x080fe400078e3cffULL,
0x0000000318a87212ULL, 0x000fe400078e3cffULL, 0x000000200a1a7810ULL, 0x040fe40007ffe0ffULL,
0x0000002c0a227810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80bae7812ULL, 0x000fe200078ee2aeULL,
0x00000008140b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81ca97812ULL, 0x000fe200078ee2a9ULL,
0x000000081a1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80da87812ULL, 0x000fe200078ee2a8ULL,
0x00000008220d7824ULL, 0x000fe200078e00ffULL, 0x0000000314aa7212ULL, 0x080fe400078e3cffULL,
0x000000240a1c7810ULL, 0x000fe40007ffe0ffULL, 0x000000031aa77212ULL, 0x000fc400078e3cffULL,
0x0000000322a47212ULL, 0x080fe400078e3cffULL, 0x000000030a0f7212ULL, 0x040fe400078e3cffULL,
0x0000003c0a2a7810ULL, 0x040fe40007ffe0ffULL, 0x000000340a267810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80baa7812ULL, 0x000fe200078ee2aaULL, 0x000000081c0b7824ULL, 0x000fe200078e00ffULL,
0x000000280a207810ULL, 0x000fe20007ffe0ffULL, 0x000000082a117824ULL, 0x000fe200078e00ffULL,
0xfffffff81ea77812ULL, 0x000fc400078ee2a7ULL, 0xfffffff80da47812ULL, 0x000fe200078ee2a4ULL,
0x0000000820247824ULL, 0x000fe200078e00ffULL, 0x000000031ca67212ULL, 0x080fe400078e3cffULL,
0x0000003f0a0d7812ULL, 0x000fe400078ec0ffULL, 0x000000070f1e7812ULL, 0x000fe400078ec0ffULL,
0x0000000326a27212ULL, 0x040fe200078e3cffULL, 0x000000010de67824ULL, 0x000fe200078e022cULL,
0x00000003260f7819ULL, 0x000fc400000006ffULL, 0x000000032aa07212ULL, 0x080fe400078e3cffULL,
0xfffffff80ba67812ULL, 0x000fe200078ee2a6ULL, 0x00000200ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000320a57212ULL, 0x000fe400078e3cffULL, 0xfffffff80fa27812ULL, 0x000fe200078ee2a2ULL,
0x00005e00e6e67625ULL, 0x000fe200078e000bULL, 0xfffffff811a07812ULL, 0x000fe400078ee2a0ULL,
0x0000003f0c0f7812ULL, 0x000fc400078ec0ffULL, 0x0000003f0e117812ULL, 0x000fe400078ec0ffULL,
0x0000003f10137812ULL, 0x000fe200078ec0ffULL, 0x000000010fe47824ULL, 0x100fe200078e022cULL,
0xfffffff824a57812ULL, 0x000fe200078ee2a5ULL, 0x0000000111e27824ULL, 0x100fe200078e022cULL,
0x0000003f12157812ULL, 0x000fe200078ec0ffULL, 0x0000000113e07824ULL, 0x000fe200078e022cULL,
0x00004000783a7811ULL, 0x000fe200078e70ffULL, 0x00005e00e4e47625ULL, 0x000fe200078e000bULL,
0x00000008b02b7812ULL, 0x000fc400078efcffULL, 0x000000300a247810ULL, 0x000fe20007ffe0ffULL,
0x0000000115de7824ULL, 0x000fe200078e022cULL, 0x0ffffff81eaf7812ULL, 0x000fe200078ef803ULL,
0x000000102b1e7825ULL, 0x000fe200078e00e6ULL, 0x0000003f14177812ULL, 0x000fe400078ec0ffULL,
0x000000380a287810ULL, 0x000fe20007ffe0ffULL, 0x0000000824307824ULL, 0x040fe200078e00ffULL,
0x0000000324a37212ULL, 0x080fe200078e3cffULL, 0x00000010af197824ULL, 0x000fe200078e023aULL,
0x0000000328a17212ULL, 0x000fe200078e3cffULL, 0x0000000117dc7824ULL, 0x000fe200078e022cULL,
0xfffffff830a37812ULL, 0x000fe200078ee2a3ULL, 0x0000000828327824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e197faeULL, 0x0003e2000b901c46ULL,
0x00005e00e2e27625ULL, 0x000fe200078e000bULL, 0x0000003f181b7812ULL, 0x000fc400078ec0ffULL,
0xfffffff832a17812ULL, 0x000fe200078ee2a1ULL, 0x00005e00e0e07625ULL, 0x080fe200078e000bULL,
0x0000003aac257211ULL, 0x080fe400078e20ffULL, 0x0000003f1a1d7812ULL, 0x000fe200078ec0ffULL,
0x00005e00dede7625ULL, 0x080fe200078e000bULL, 0x0000003aa6417211ULL, 0x000fe400078e20ffULL,
0x0000003f16197812ULL, 0x002fe200078ec0ffULL, 0x00005e00dcdc7625ULL, 0x000fe200078e000bULL,
0x0000003f1c1e7812ULL, 0x000fc400078ec0ffULL, 0x0000003f201f7812ULL, 0x000fe200078ec0ffULL,
0x00000010ae217824ULL, 0x000fe400078e023aULL, 0x000000102b307825ULL, 0x000fc800078e00e4ULL,
0x00000010ad237824ULL, 0x000fe200078e023aULL, 0x0000000030217faeULL, 0x0003e2000b901c46ULL,
0x000000102b327825ULL, 0x000fc800078e00e2ULL, 0x000000102b347825ULL, 0x000fe200078e00e0ULL,
0x0000000032237faeULL, 0x0005e6000b901c46ULL, 0x00000010ab277824ULL, 0x000fe200078e023aULL,
0x0000000034257faeULL, 0x0007e2000b901c46ULL, 0x000000102b367825ULL, 0x000fe200078e00deULL,
0x0000003f22217812ULL, 0x002fc600078ec0ffULL, 0x00000010aa297824ULL, 0x000fe200078e023aULL,
0x0000000036277faeULL, 0x0003e2000b901c46ULL, 0x000000102b387825ULL, 0x000fe200078e00dcULL,
0x0000003f24237812ULL, 0x004fc600078ec0ffULL, 0x0000000119da7824ULL, 0x100fe200078e022cULL,
0x0000003f26257812ULL, 0x008fe200078ec0ffULL, 0x000000011bd87824ULL, 0x100fe200078e022cULL,
0x0000000038297faeULL, 0x0005e2000b901c46ULL, 0x000000011dd67824ULL, 0x100fe400078e022cULL,
0x000000011ed47824ULL, 0x100fe200078e022cULL, 0x0000003f28277812ULL, 0x002fe200078ec0ffULL,
0x000000011fd07824ULL, 0x000fe400078e022cULL, 0x00005e00dada7625ULL, 0x000fc800078e000bULL,
0x00005e00d8d87625ULL, 0x000fe200078e000bULL, 0x0000003f2a297812ULL, 0x004fc600078ec0ffULL,
0x00005e00d6d67625ULL, 0x000fc800078e000bULL, 0x0000000121ce7824ULL, 0x000fe400078e022cULL,
0x00005e00d4d47625ULL, 0x000fc800078e000bULL, 0x0000000123cc7824ULL, 0x000fe400078e022cULL,
0x00005e00d0d07625ULL, 0x000fc800078e000bULL, 0x0000000125ca7824ULL, 0x100fe400078e022cULL,
0x0000000127c67824ULL, 0x000fe400078e022cULL, 0x00000010a93b7824ULL, 0x000fe400078e023aULL,
0x000000102b307825ULL, 0x000fc800078e00daULL, 0x00000001292c7824ULL, 0x000fe200078e022cULL,
0x00000000303b7faeULL, 0x0003e2000b901c46ULL, 0x00005e00cece7625ULL, 0x000fc800078e000bULL,
0x00000010a83d7824ULL, 0x000fe400078e023aULL, 0x000000102b327825ULL, 0x000fc800078e00d8ULL,
0x00005e00cccc7625ULL, 0x000fe200078e000bULL, 0x00000000323d7faeULL, 0x0005e6000b901c46ULL,
0x00000010a73f7824ULL, 0x000fe400078e023aULL, 0x000000102b347825ULL, 0x000fc800078e00d6ULL,
0x00005e00caca7625ULL, 0x000fe200078e000bULL, 0x00000000343f7faeULL, 0x0007e6000b901c46ULL,
0x000000102b367825ULL, 0x000fc800078e00d4ULL, 0x00005e00c6c67625ULL, 0x000fe200078e000bULL,
0x0000000036417faeULL, 0x0009e6000b901c46ULL, 0x00000010a5437824ULL, 0x000fe400078e023aULL,
0x000000102b387825ULL, 0x000fc800078e00d0ULL, 0x00005e002cc47625ULL, 0x000fe200078e000bULL,
0x0000000038437faeULL, 0x000be6000b901c46ULL, 0x00000010a43b7824ULL, 0x002fe400078e023aULL,
0x000000102b307825ULL, 0x000fc800078e00ceULL, 0x00000010a33d7824ULL, 0x004fe200078e023aULL,
0x00000000303b7faeULL, 0x0003e2000b901c46ULL, 0x000000102b327825ULL, 0x000fe200078e00ccULL,
0x0000003aa0437211ULL, 0x020fc600078e20ffULL, 0x00000010a23f7824ULL, 0x008fe200078e023aULL,
0x00000000323d7faeULL, 0x0003e2000b901c46ULL, 0x000000102b347825ULL, 0x000fc800078e00caULL,
0x00000010a1417824ULL, 0x010fe200078e023aULL, 0x00000000343f7faeULL, 0x0003e2000b901c46ULL,
0x000000102b367825ULL, 0x000fc800078e00c6ULL, 0x000000102b387825ULL, 0x000fe200078e00c4ULL,
0x0000000036417faeULL, 0x0003e8000b901c46ULL, 0x0000000038437faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004ff2b7819ULL, 0x102fe40000011603ULL, 0x00000008b02c7812ULL, 0x000fc800078ef803ULL,
0x000000072b317812ULL, 0x000fca00078e782cULL, 0x000000202c307824ULL, 0x000fc800078e0231ULL,
0x0000001030307824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000082b317824ULL, 0x040fe200078e00ffULL,
0x000000022b397810ULL, 0x000fe20007ffe0ffULL, 0x0000400078bb7824ULL, 0x000fe200078e00ffULL,
0x000000010a507812ULL, 0x000fe200078ec0ffULL, 0x00000f8000007945ULL, 0x000fe20003800000ULL,
0xfffffff831387812ULL, 0x000fe400078ee2b0ULL, 0x00002000bb877810ULL, 0x000fe20007ffe0ffULL,
0x000000003030783bULL, 0x000fe20000000200ULL, 0x0000000738577812ULL, 0x040fe200078ec0ffULL,
0x0000000838b77824ULL, 0x000fe200078e00ffULL, 0x0000000739397812ULL, 0x000fc400078e782cULL,
0x0000000157867812ULL, 0x000fe400078e780aULL, 0x0000001038ba7810ULL, 0x000fe20007ffe0ffULL,
0x000000202c397824ULL, 0x000fe200078e0239ULL, 0x000000b786867212ULL, 0x080fe400078efcffULL,
0x00000007ba517812ULL, 0x000fe200078ec0ffULL, 0x0000001039647824ULL, 0x000fe200078e00ffULL,
0x0000002038b97810ULL, 0x000fe20007ffe0ffULL, 0x0000001086b17824ULL, 0x000fe200078e0287ULL,
0x0000003038387810ULL, 0x000fe20007ffe0ffULL, 0x00000008baba7824ULL, 0x000fe200078e00ffULL,
0x0000000257827812ULL, 0x000fe200078e1e50ULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0x0000000151397812ULL, 0x000fe200078e780aULL, 0x0000000838b87824ULL, 0x040fe200078e00ffULL,
0x0000000738557812ULL, 0x000fe200078ec0ffULL, 0x00000000b134783bULL, 0x000e620000000200ULL,
0x000000b782827212ULL, 0x000fc400078efcffULL, 0x00000007b9537812ULL, 0x000fe400078ec0ffULL,
0x000000ba39d27212ULL, 0x000fe200078efcffULL, 0x00000010829c7824ULL, 0x100fe200078e0287ULL,
0x0000000155397812ULL, 0x100fe400078e780aULL, 0x00000003b9b97819ULL, 0x000fe200000006ffULL,
0x00000010d29f7824ULL, 0x000fe200078e0287ULL, 0x0000000153847812ULL, 0x000fe200078e780aULL,
0x000000009c5c783bULL, 0x000fe20000000200ULL, 0x000000b839c87212ULL, 0x000fc400078efcffULL,
0x000000b984847212ULL, 0x080fe200078efcffULL, 0x000000009f4c783bULL, 0x000fe20000000200ULL,
0x00000002513d7812ULL, 0x100fe200078e1e50ULL, 0x00000010c89d7824ULL, 0x100fe200078e0287ULL,
0x0000000253c07812ULL, 0x100fe200078e1e50ULL, 0x00000010849e7824ULL, 0x100fe200078e0287ULL,
0x000000ba3dc27212ULL, 0x000fe400078efcffULL, 0x000000009d38783bULL, 0x000ea20000000200ULL,
0x000000b9c0c07212ULL, 0x000fe400078efcffULL, 0x00000010c29b7824ULL, 0x100fe200078e0287ULL,
0x000000009e40783bULL, 0x000ee20000000200ULL, 0x0000000457be7812ULL, 0x100fe200078e1e50ULL,
0x00000010c09a7824ULL, 0x000fe200078e0287ULL, 0x0000000453bc7812ULL, 0x000fe200078e1e50ULL,
0x000000009b58783bULL, 0x000f220000000200ULL, 0x000000b7bebe7212ULL, 0x000fc400078efcffULL,
0x000000b9bcbc7212ULL, 0x000fe200078efcffULL, 0x000000009a48783bULL, 0x000f640000000200ULL,
0x00000010be817824ULL, 0x100fe400078e0287ULL, 0x00000010bc7f7824ULL, 0x000fe200078e0287ULL,
0x000000343074723cULL, 0x042fe400000418ffULL, 0x000000008170783bULL, 0x000fe80000000200ULL,
0x000000007f68783bULL, 0x000fe40000000200ULL, 0x000000363034723cULL, 0x040ff000000418ffULL,
0x000000383044723cULL, 0x004fee00000418ffULL, 0x0000000255397812ULL, 0x000fe200078e1e50ULL,
0x0000005c6474723cULL, 0x000fe60000041874ULL, 0x000000b839b27212ULL, 0x000fca00078efcffULL,
0x0000005e645c723cULL, 0x000fe20000041834ULL, 0x00000010b2987824ULL, 0x000fce00078e0287ULL,
0x0000004c3034723cULL, 0x040ff000000418ffULL, 0x0000004e304c723cULL, 0x040ff000000418ffULL,
0x00000040303c723cULL, 0x048ff000000418ffULL, 0x000000423040723cULL, 0x040ff000000418ffULL,
0x0000003a3030723cULL, 0x000fe200000418ffULL, 0x000000009838783bULL, 0x000e6e0000000200ULL,
0x000000586434723cULL, 0x050ff00000041834ULL, 0x0000005a6458723cULL, 0x040fee000004184cULL,
0x000000042b4d7810ULL, 0x000fe20007ffe0ffULL, 0x00000048643c723cULL, 0x020fe6000004183cULL,
0x000000074d4d7812ULL, 0x000fca00078e782cULL, 0x0000004a6448723cULL, 0x000fe20000041840ULL,
0x000000202c4c7824ULL, 0x000fe200078e024dULL, 0x000000062b4d7810ULL, 0x000fc80007ffe0ffULL,
0x000000074d4d7812ULL, 0x000fe200078e782cULL, 0x000000104c407824ULL, 0x000fe200078e00ffULL,
0x0000000451417812ULL, 0x100fe200078e1e50ULL, 0x000000386444723cULL, 0x042fe20000041844ULL,
0x0000000455437812ULL, 0x100fe400078e1e50ULL, 0x000000ba41b67212ULL, 0x000fe400078efcffULL,
0x000000b843b47212ULL, 0x000fe400078efcffULL, 0x00000087b6807211ULL, 0x000fe200078e20ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x00000006574c7812ULL, 0x100fe200078e1e50ULL,
0x00000010b47e7824ULL, 0x000fe200078e0287ULL, 0x0000000651517812ULL, 0x100fe200078e1e50ULL,
0x00000000806c783bULL, 0x000ea20000000200ULL, 0x000000b74cb77212ULL, 0x000fe200078efcffULL,
0x000000202c387824ULL, 0x000fe200078e024dULL, 0x00000006534c7812ULL, 0x100fe200078e1e50ULL,
0x000000007e60783bULL, 0x000ee20000000200ULL, 0x0000000655557812ULL, 0x000fe200078e1e50ULL,
0x0000003a6464723cULL, 0x000fe20000041830ULL, 0x000000ba51ba7212ULL, 0x000fe200078efcffULL,
0x00000010b77c7824ULL, 0x100fe200078e0287ULL, 0x000000b94cb97212ULL, 0x000fe200078efcffULL,
0x00000010384c7824ULL, 0x000fe200078e00ffULL, 0x000000b855b87212ULL, 0x000fe200078efcffULL,
0x00000010ba7d7824ULL, 0x100fe200078e0287ULL, 0x000000007c50783bULL, 0x000fe20000000200ULL,
0x00000010b97b7824ULL, 0x000fc400078e0287ULL, 0x00000010b87a7824ULL, 0x000fe200078e0287ULL,
0x000000004c4c783bULL, 0x000f280000000200ULL, 0x000000007d30783bULL, 0x000f680000000200ULL,
0x000000007b54783bULL, 0x000ee80000000200ULL, 0x000000007a38783bULL, 0x000ee20000000200ULL,
0x000000704074723cULL, 0x042ff00000041874ULL, 0x0000006c4034723cULL, 0x044ff00000041834ULL,
0x00000068403c723cULL, 0x040ff0000004183cULL, 0x00000072405c723cULL, 0x040ff0000004185cULL,
0x0000006e4058723cULL, 0x040ff00000041858ULL, 0x0000006a4048723cULL, 0x040ff00000041848ULL,
0x000000604044723cULL, 0x048ff00000041844ULL, 0x000000624040723cULL, 0x000ff00000041864ULL,
0x000000504c74723cULL, 0x050ff00000041874ULL, 0x000000304c34723cULL, 0x060ff00000041834ULL,
0x000000544c3c723cULL, 0x040ff0000004183cULL, 0x000000524c50723cULL, 0x040ff0000004185cULL,
0x000000324c30723cULL, 0x040ff00000041858ULL, 0x000000564c54723cULL, 0x040ff00000041848ULL,
0x000000384c44723cULL, 0x040ff00000041844ULL, 0x0000003a4c4c723cULL, 0x000fe20000041840ULL,
0x0000046000008947ULL, 0x000fee0003800000ULL, 0x000000012e5b7824ULL, 0x000fe200078e0a09ULL,
0x00000010b0597812ULL, 0x000fe200078efcffULL, 0x00000010af967824ULL, 0x100fe200078e0287ULL,
0x00000087ae957211ULL, 0x000fe200078e20ffULL, 0x00000010ad947824ULL, 0x000fe200078e0287ULL,
0x0000005b0a00720cULL, 0x080fe20003f26070ULL, 0x0000001059387825ULL, 0x000fe200078e00e6ULL,
0x0000005b0c00720cULL, 0x000fc40003f46070ULL, 0x0000005b0e00720cULL, 0x080fe20003f66070ULL,
0x0000001059487825ULL, 0x040fe200078e00e4ULL, 0x0000005b1200720cULL, 0x080fe40003f86070ULL,
0x0000005b1c00720cULL, 0x080fe20003fa6070ULL, 0x0000001059427825ULL, 0x000fe200078e00e2ULL,
0x0000005b2a00720cULL, 0x000fe40003fc6070ULL, 0x00000087a38a7211ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038967faeULL, 0x0003e2000c901c46ULL,
0x0000005b1000720cULL, 0x000fe20003f26070ULL, 0x00000010ac937824ULL, 0x000fc400078e0287ULL,
0x0000000048957faeULL, 0x0005e2000d101c46ULL, 0x0000005b1400720cULL, 0x080fe20003f46070ULL,
0x0000001059407825ULL, 0x000fe400078e00e0ULL, 0x0000000042947faeULL, 0x0007e2000d901c46ULL,
0x0000005b1600720cULL, 0x080fe20003f66070ULL, 0x00000010ab927824ULL, 0x000fe400078e0287ULL,
0x00000010593a7825ULL, 0x000fe400078e00deULL, 0x0000000040937faeULL, 0x0009e2000c901c46ULL,
0x0000005b2000720cULL, 0x000fe20003f26070ULL, 0x00000010aa917824ULL, 0x000fc400078e0287ULL,
0x0000001059387825ULL, 0x002fe200078e00dcULL, 0x000000003a927faeULL, 0x0003e2000e101c46ULL,
0x0000005b1800720cULL, 0x080fe40003f86070ULL, 0x00000010a9907824ULL, 0x000fe200078e0287ULL,
0x0000000038917faeULL, 0x000be2000d101c46ULL, 0x0000005b1a00720cULL, 0x000fe20003f46070ULL,
0x0000001059427825ULL, 0x008fc800078e00daULL, 0x00000010a88f7824ULL, 0x000fe200078e0287ULL,
0x0000000042907faeULL, 0x0007e2000d901c46ULL, 0x0000001059407825ULL, 0x010fe200078e00d8ULL,
0x0000005b2400720cULL, 0x000fc60003f66070ULL, 0x00000010a78e7824ULL, 0x000fe200078e0287ULL,
0x00000000408f7faeULL, 0x0009e2000e101c46ULL, 0x00000010593a7825ULL, 0x002fe200078e00d6ULL,
0x0000005b2600720cULL, 0x000fc60003f86070ULL, 0x00000010a68d7824ULL, 0x000fe200078e0287ULL,
0x000000003a8e7faeULL, 0x0003e2000d101c46ULL, 0x0000001059387825ULL, 0x020fe200078e00d4ULL,
0x0000005b2200720cULL, 0x000fc60003f46070ULL, 0x00000010a58c7824ULL, 0x000fe200078e0287ULL,
0x00000000388d7faeULL, 0x000be2000e901c46ULL, 0x0000005b2800720cULL, 0x000fe20003fa6070ULL,
0x00000010594a7825ULL, 0x000fc800078e00d0ULL, 0x00000010a48b7824ULL, 0x000fe200078e0287ULL,
0x000000004a8c7faeULL, 0x0003e2000c901c46ULL, 0x0000001059487825ULL, 0x004fc800078e00ceULL,
0x0000001059427825ULL, 0x048fe200078e00ccULL, 0x00000000488b7faeULL, 0x0005e6000d101c46ULL,
0x00000010a2897824ULL, 0x000fe200078e0287ULL, 0x00000000428a7faeULL, 0x0005e2000d901c46ULL,
0x0000001059407825ULL, 0x010fc800078e00caULL, 0x00000010a1887824ULL, 0x000fe200078e0287ULL,
0x0000000040897faeULL, 0x0005e2000e101c46ULL, 0x00000010593a7825ULL, 0x002fc800078e00c6ULL,
0x00000010a0877824ULL, 0x000fe200078e0287ULL, 0x000000003a887faeULL, 0x0005e2000e901c46ULL,
0x0000001059387825ULL, 0x020fca00078e00c4ULL, 0x0000000038877faeULL, 0x0005e2000f101c46ULL,
0x0000034000007947ULL, 0x000fea0003800000ULL, 0x00000010b0597812ULL, 0x000fe200078efcffULL,
0x00000010af967824ULL, 0x100fe200078e0287ULL, 0x00000087a88f7211ULL, 0x000fe200078e20ffULL,
0x00000010ae957824ULL, 0x000fe400078e0287ULL, 0x0000001059427825ULL, 0x000fc800078e00e6ULL,
0x0000001059407825ULL, 0x000fe200078e00e4ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042967faeULL, 0x0003e6000b901c46ULL, 0x00000010ad947824ULL, 0x000fe200078e0287ULL,
0x0000000040957faeULL, 0x0005e2000b901c46ULL, 0x00000010593a7825ULL, 0x000fc800078e00e2ULL,
0x00000010ac937824ULL, 0x000fe200078e0287ULL, 0x000000003a947faeULL, 0x0007e2000b901c46ULL,
0x0000001059387825ULL, 0x000fc800078e00e0ULL, 0x00000010ab927824ULL, 0x000fe200078e0287ULL,
0x0000000038937faeULL, 0x0009e2000b901c46ULL, 0x00000010594a7825ULL, 0x000fc800078e00deULL,
0x00000010aa917824ULL, 0x000fe200078e0287ULL, 0x000000004a927faeULL, 0x000be2000b901c46ULL,
0x0000001059487825ULL, 0x000fc800078e00dcULL, 0x00000010a9907824ULL, 0x000fe200078e0287ULL,
0x0000000048917faeULL, 0x0009e2000b901c46ULL, 0x0000001059427825ULL, 0x002fc800078e00daULL,
0x0000001059407825ULL, 0x004fe200078e00d8ULL, 0x0000000042907faeULL, 0x0003e6000b901c46ULL,
0x00000010a78e7824ULL, 0x000fe200078e0287ULL, 0x00000000408f7faeULL, 0x0005e2000b901c46ULL,
0x00000010593a7825ULL, 0x008fc800078e00d6ULL, 0x00000010a68d7824ULL, 0x000fe200078e0287ULL,
0x000000003a8e7faeULL, 0x0007e2000b901c46ULL, 0x0000001059387825ULL, 0x010fc800078e00d4ULL,
0x00000010a58c7824ULL, 0x000fe200078e0287ULL, 0x00000000388d7faeULL, 0x0009e2000b901c46ULL,
0x00000010594a7825ULL, 0x020fc800078e00d0ULL, 0x00000010a48b7824ULL, 0x000fe200078e0287ULL,
0x000000004a8c7faeULL, 0x0005e2000b901c46ULL, 0x0000001059487825ULL, 0x000fc800078e00ceULL,
0x00000010a38a7824ULL, 0x000fe200078e0287ULL, 0x00000000488b7faeULL, 0x0007e2000b901c46ULL,
0x0000001059427825ULL, 0x002fc800078e00ccULL, 0x00000010a2897824ULL, 0x000fe200078e0287ULL,
0x00000000428a7faeULL, 0x0003e2000b901c46ULL, 0x0000001059407825ULL, 0x004fc800078e00caULL,
0x00000010a1887824ULL, 0x000fe200078e0287ULL, 0x0000000040897faeULL, 0x0003e2000b901c46ULL,
0x00000010593a7825ULL, 0x008fc800078e00c6ULL, 0x00000010a0877824ULL, 0x000fe200078e0287ULL,
0x000000003a887faeULL, 0x0003e2000b901c46ULL, 0x0000001059387825ULL, 0x010fca00078e00c4ULL,
0x0000000038877faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000082b397810ULL, 0x006fe20007ffe0ffULL,
0x00000d1000007945ULL, 0x000fe20003800000ULL, 0x00004000bbbb7810ULL, 0x000fe40007ffe0ffULL,
0x0000000739397812ULL, 0x100fe400078e782cULL, 0x0000000a2b497810ULL, 0x000fe20007ffe0ffULL,
0x0000001086867824ULL, 0x000fe200078e02bbULL, 0x000000bbbeb37211ULL, 0x000fe200078e20ffULL,
0x000000202c397824ULL, 0x000fe200078e0239ULL, 0x0000000749497812ULL, 0x000fe200078e782cULL,
0x00000010d2857824ULL, 0x000fc400078e02bbULL, 0x0000001082827824ULL, 0x000fe200078e02bbULL,
0x0000000439587819ULL, 0x000fe200000006ffULL, 0x000000202c497824ULL, 0x000fe400078e0249ULL,
0x0000001084847824ULL, 0x100fe400078e02bbULL, 0x0000001049497824ULL, 0x000fe400078e00ffULL,
0x00000010c2977824ULL, 0x000fe200078e02bbULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000008638783bULL, 0x000fe20000000200ULL, 0x00000010c8837824ULL, 0x100fe400078e02bbULL,
0x00000010c0997824ULL, 0x100fe200078e02bbULL, 0x000000005858783bULL, 0x000e620000000200ULL,
0x00000010b2b27824ULL, 0x100fe400078e02bbULL, 0x00000010b6b67824ULL, 0x100fe200078e02bbULL,
0x000000008540783bULL, 0x000ea20000000200ULL, 0x00000010bcb57824ULL, 0x100fe400078e02bbULL,
0x00000010b4b47824ULL, 0x100fe200078e02bbULL, 0x000000008270783bULL, 0x000fe20000000200ULL,
0x00000010b7b77824ULL, 0x000fc400078e02bbULL, 0x00000010baba7824ULL, 0x100fe200078e02bbULL,
0x000000004948783bULL, 0x000ee20000000200ULL, 0x00000010b9b97824ULL, 0x100fe400078e02bbULL,
0x00000010b8b87824ULL, 0x000fe200078e02bbULL, 0x000000008460783bULL, 0x000f280000000200ULL,
0x00000000835c783bULL, 0x000fe80000000200ULL, 0x00000000b66c783bULL, 0x000fe80000000200ULL,
0x00000000b568783bULL, 0x000fe80000000200ULL, 0x00000000b464783bULL, 0x000fe20000000200ULL,
0x000000385874723cULL, 0x042ff00000041874ULL, 0x0000003a5850723cULL, 0x040fe20000041850ULL,
0x000000009738783bULL, 0x000e6e0000000200ULL, 0x000000405834723cULL, 0x044ff00000041834ULL,
0x000000425830723cULL, 0x000fe20000041830ULL, 0x000000009940783bULL, 0x000eae0000000200ULL,
0x000000704874723cULL, 0x048ff00000041874ULL, 0x000000724870723cULL, 0x000fe20000041850ULL,
0x00000000b250783bULL, 0x000eee0000000200ULL, 0x00000060583c723cULL, 0x050ff0000004183cULL,
0x000000625854723cULL, 0x000ff00000041854ULL, 0x000000384834723cULL, 0x002fee0000041834ULL,
0x0000000c2b397810ULL, 0x000fe20007ffe0ffULL, 0x0000005c5844723cULL, 0x040ff00000041844ULL,
0x0000005e584c723cULL, 0x000fe2000004184cULL, 0x00000000b75c783bULL, 0x000fec0000000200ULL,
0x0000000739597812ULL, 0x000fe200078e782cULL, 0x00000040483c723cULL, 0x004fe8000004183cULL,
0x000000202c597824ULL, 0x000fc800078e0259ULL, 0x0000001059597824ULL, 0x000fe200078e00ffULL,
0x0000003a4838723cULL, 0x040fe20000041830ULL, 0x00000000b330783bULL, 0x000fe80000000200ULL,
0x000000005960783bULL, 0x000e660000000200ULL, 0x000000424840723cULL, 0x040fe20000041854ULL,
0x00000000ba58783bULL, 0x000fec0000000200ULL, 0x0000000e2b557810ULL, 0x000fe20007ffe0ffULL,
0x000000504844723cULL, 0x008fe60000041844ULL, 0x0000000755557812ULL, 0x000fca00078e782cULL,
0x000000202c557824ULL, 0x000fe200078e0255ULL, 0x000000524848723cULL, 0x000fe2000004184cULL,
0x00000000b850783bULL, 0x000fe40000000200ULL, 0x0000001055bc7824ULL, 0x000fe400078e00ffULL,
0x00000000b954783bULL, 0x000fe80000000200ULL, 0x00000000bc4c783bULL, 0x000ea20000000200ULL,
0x000000306074723cULL, 0x042ff00000041874ULL, 0x000000326070723cULL, 0x040ff00000041870ULL,
0x0000006c6034723cULL, 0x040ff00000041834ULL, 0x0000006e6038723cULL, 0x040ff00000041838ULL,
0x00000068603c723cULL, 0x040ff0000004183cULL, 0x0000006a6040723cULL, 0x040ff00000041840ULL,
0x000000646044723cULL, 0x040ff00000041844ULL, 0x000000666048723cULL, 0x000ff00000041848ULL,
0x0000005c4c74723cULL, 0x044ff00000041874ULL, 0x0000005e4c70723cULL, 0x040ff00000041870ULL,
0x000000584c34723cULL, 0x040ff00000041834ULL, 0x0000005a4c38723cULL, 0x040ff00000041838ULL,
0x000000544c3c723cULL, 0x040ff0000004183cULL, 0x000000564c40723cULL, 0x040ff00000041840ULL,
0x000000504c44723cULL, 0x040ff00000041844ULL, 0x000000524c48723cULL, 0x000fe20000041848ULL,
0x0000046000008947ULL, 0x000fee0003800000ULL, 0x800000092e577210ULL, 0x000fe20007ffe0ffULL,
0x00000010afaf7824ULL, 0x100fe200078e02bbULL, 0x00000018b0317812ULL, 0x000fe200078efcffULL,
0x00000010ae337824ULL, 0x100fe200078e02bbULL, 0x000000570a00720cULL, 0x080fe20003f06070ULL,
0x00000010adad7824ULL, 0x000fe200078e02bbULL, 0x000000570c00720cULL, 0x080fe20003f26070ULL,
0x0000001031e67825ULL, 0x000fe200078e00e6ULL, 0x000000571200720cULL, 0x000fc40003f46070ULL,
0x000000571400720cULL, 0x080fe20003f66070ULL, 0x0000001031e47825ULL, 0x040fe200078e00e4ULL,
0x000000571600720cULL, 0x080fe40003f86070ULL, 0x000000571800720cULL, 0x080fe20003fa6070ULL,
0x0000001031e27825ULL, 0x000fe200078e00e2ULL, 0x000000571a00720cULL, 0x080fe20003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000e6af7faeULL, 0x0003e2000c101c46ULL,
0x000000570e00720cULL, 0x000fe20003f06070ULL, 0x00000010ac4d7824ULL, 0x000fe200078e02bbULL,
0x000000bba5a57211ULL, 0x000fe200078e20ffULL, 0x00000000e4337faeULL, 0x0005e2000c901c46ULL,
0x000000571000720cULL, 0x000fe20003f26070ULL, 0x0000001031e07825ULL, 0x000fc800078e00e0ULL,
0x00000010abab7824ULL, 0x000fe400078e02bbULL, 0x0000001031de7825ULL, 0x040fe400078e00deULL,
0x00000000e2ad7faeULL, 0x0003e2000c101c46ULL, 0x000000571c00720cULL, 0x080fe20003f06070ULL,
0x00000010aa4f7824ULL, 0x000fe400078e02bbULL, 0x0000001031dc7825ULL, 0x000fe200078e00dcULL,
0x00000000e04d7faeULL, 0x0003e2000c901c46ULL, 0x000000572000720cULL, 0x000fc40003f26070ULL,
0x00000010a9a97824ULL, 0x000fe200078e02bbULL, 0x00000000deab7faeULL, 0x0003e2000d101c46ULL,
0x0000001031da7825ULL, 0x040fe200078e00daULL, 0x000000572200720cULL, 0x080fe40003f46070ULL,
0x00000000dc4f7faeULL, 0x0003e2000d901c46ULL, 0x00000010a8517824ULL, 0x000fe200078e02bbULL,
0x000000572400720cULL, 0x080fe20003f66070ULL, 0x0000001031d87825ULL, 0x000fe200078e00d8ULL,
0x00000000daa97faeULL, 0x0003e2000e101c46ULL, 0x000000572600720cULL, 0x000fc40003f86070ULL,
0x00000010a7a77824ULL, 0x000fe200078e02bbULL, 0x00000000d8517faeULL, 0x0003e2000e901c46ULL,
0x0000001031d67825ULL, 0x000fe200078e00d6ULL, 0x000000572800720cULL, 0x000fc60003fa6070ULL,
0x00000010a6537824ULL, 0x000fe200078e02bbULL, 0x00000000d6a77faeULL, 0x0003e2000f101c46ULL,
0x000000572a00720cULL, 0x000fe20003fc6070ULL, 0x0000001031d47825ULL, 0x000fc800078e00d4ULL,
0x0000001031d07825ULL, 0x040fe200078e00d0ULL, 0x00000000d4537faeULL, 0x0003e6000c101c46ULL,
0x00000010a4557824ULL, 0x000fe200078e02bbULL, 0x00000000d0a57faeULL, 0x0003e2000c901c46ULL,
0x0000001031ce7825ULL, 0x000fc800078e00ceULL, 0x00000010a3a37824ULL, 0x000fe200078e02bbULL,
0x00000000ce557faeULL, 0x0003e2000d101c46ULL, 0x0000001031cc7825ULL, 0x000fc800078e00ccULL,
0x00000010a2337824ULL, 0x004fe200078e02bbULL, 0x00000000cca37faeULL, 0x0003e2000d901c46ULL,
0x0000001031ca7825ULL, 0x000fc800078e00caULL, 0x00000010a1a17824ULL, 0x000fe200078e02bbULL,
0x00000000ca337faeULL, 0x0003e2000e101c46ULL, 0x0000001031c67825ULL, 0x000fc800078e00c6ULL,
0x00000010a0bb7824ULL, 0x000fe200078e02bbULL, 0x00000000c6a17faeULL, 0x0003e2000e901c46ULL,
0x0000001031c47825ULL, 0x000fca00078e00c4ULL, 0x00000000c4bb7faeULL, 0x0003e2000f101c46ULL,
0x0000034000007947ULL, 0x000fea0003800000ULL, 0x00000018b0317812ULL, 0x000fe200078efcffULL,
0x00000010afaf7824ULL, 0x100fe200078e02bbULL, 0x000000bbaa4f7211ULL, 0x000fe200078e20ffULL,
0x00000010ae337824ULL, 0x000fe400078e02bbULL, 0x0000001031e67825ULL, 0x000fc800078e00e6ULL,
0x0000001031e47825ULL, 0x000fe200078e00e4ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000e6af7faeULL, 0x0003e6000b901c46ULL, 0x00000010adad7824ULL, 0x000fe200078e02bbULL,
0x00000000e4337faeULL, 0x0003e2000b901c46ULL, 0x0000001031e27825ULL, 0x000fc800078e00e2ULL,
0x00000010ac4d7824ULL, 0x000fe200078e02bbULL, 0x00000000e2ad7faeULL, 0x0003e2000b901c46ULL,
0x0000001031e07825ULL, 0x000fc800078e00e0ULL, 0x00000010abab7824ULL, 0x000fe200078e02bbULL,
0x00000000e04d7faeULL, 0x0003e2000b901c46ULL, 0x0000001031de7825ULL, 0x000fc800078e00deULL,
0x0000001031dc7825ULL, 0x000fe200078e00dcULL, 0x00000000deab7faeULL, 0x0003e6000b901c46ULL,
0x00000010a9a97824ULL, 0x000fe200078e02bbULL, 0x00000000dc4f7faeULL, 0x0003e2000b901c46ULL,
0x0000001031da7825ULL, 0x000fc800078e00daULL, 0x00000010a8517824ULL, 0x000fe200078e02bbULL,
0x00000000daa97faeULL, 0x0003e2000b901c46ULL, 0x0000001031d87825ULL, 0x000fc800078e00d8ULL,
0x00000010a7a77824ULL, 0x000fe200078e02bbULL, 0x00000000d8517faeULL, 0x0003e2000b901c46ULL,
0x0000001031d67825ULL, 0x000fc800078e00d6ULL, 0x00000010a6537824ULL, 0x000fe200078e02bbULL,
0x00000000d6a77faeULL, 0x0003e2000b901c46ULL, 0x0000001031d47825ULL, 0x000fc800078e00d4ULL,
0x00000010a5a57824ULL, 0x000fe200078e02bbULL, 0x00000000d4537faeULL, 0x0003e2000b901c46ULL,
0x0000001031d07825ULL, 0x000fc800078e00d0ULL, 0x00000010a4557824ULL, 0x000fe200078e02bbULL,
0x00000000d0a57faeULL, 0x0003e2000b901c46ULL, 0x0000001031ce7825ULL, 0x000fc800078e00ceULL,
0x00000010a3a37824ULL, 0x000fe200078e02bbULL, 0x00000000ce557faeULL, 0x0003e2000b901c46ULL,
0x0000001031cc7825ULL, 0x000fc800078e00ccULL, 0x00000010a2577824ULL, 0x000fe200078e02bbULL,
0x00000000cca37faeULL, 0x0003e2000b901c46ULL, 0x0000001031ca7825ULL, 0x000fc800078e00caULL,
0x00000010a1a17824ULL, 0x000fe200078e02bbULL, 0x00000000ca577faeULL, 0x0003e2000b901c46ULL,
0x0000001031c67825ULL, 0x000fc800078e00c6ULL, 0x00000010a0bb7824ULL, 0x000fe200078e02bbULL,
0x00000000c6a17faeULL, 0x0003e2000b901c46ULL, 0x0000001031c47825ULL, 0x000fca00078e00c4ULL,
0x00000000c4bb7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000102b317810ULL, 0x000fe20007ffe0ffULL,
0xffffffffffa17424ULL, 0x002fe200078e00ffULL, 0x00000004004d7802ULL, 0x000fe40000000f00ULL,
0x0000000731317812ULL, 0x000fc600078e782cULL, 0x000003004d007a24ULL, 0x000fe400078e0200ULL,
0x000000202c317824ULL, 0x000fc600078e0231ULL, 0x0000002f0000720cULL, 0x000fe20003f06070ULL,
0x0000001031547824ULL, 0x000fe200078e00ffULL, 0x000000122b4f7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000000b164783bULL, 0x000fec0000000200ULL,
0x00000002054c8824ULL, 0x000fe200078e0200ULL, 0x000000005454783bULL, 0x000e620000000200ULL,
0x000000074f4f7812ULL, 0x100fe400078e782cULL, 0x000060004c4c8625ULL, 0x000fe200078e004dULL,
0x000000009f30783bULL, 0x000ea60000000200ULL, 0x000000202c4f7824ULL, 0x000fe200078e024fULL,
0x000000064ca18981ULL, 0x000762000c1e1900ULL, 0x00000ff000007945ULL, 0x000fe40003800000ULL,
0x000000104f4f7824ULL, 0x000fe200078e00ffULL, 0x000000009e5c783bULL, 0x000f280000000200ULL,
0x000000009c50783bULL, 0x000fe80000000200ULL, 0x000000004f4c783bULL, 0x008ee80000000200ULL,
0x000000009d58783bULL, 0x000ee80000000200ULL, 0x000000009b60783bULL, 0x000ee80000000200ULL,
0x000000007c6c783bULL, 0x000fe80000000200ULL, 0x000000007d68783bULL, 0x000fe20000000200ULL,
0x000000645474723cULL, 0x042ff00000041874ULL, 0x000000665470723cULL, 0x040fe20000041870ULL,
0x000000009a64783bULL, 0x000e6e0000000200ULL, 0x000000305434723cULL, 0x044ff00000041834ULL,
0x000000325438723cULL, 0x040fe20000041838ULL, 0x000000009830783bULL, 0x000eae0000000200ULL,
0x0000005c543c723cULL, 0x010ff0000004183cULL, 0x000000504c74723cULL, 0x008fee0000041874ULL,
0x000000142b517810ULL, 0x000fe20007ffe0ffULL, 0x0000005e5440723cULL, 0x000fe60000041840ULL,
0x0000000751517812ULL, 0x000fca00078e782cULL, 0x000000202c517824ULL, 0x000fe200078e0251ULL,
0x000000585444723cULL, 0x000fe60000041844ULL, 0x00000010515c7824ULL, 0x000fca00078e00ffULL,
0x0000005a5448723cULL, 0x000fe20000041848ULL, 0x000000005c5c783bULL, 0x000fe80000000200ULL,
0x000000008054783bULL, 0x000fe60000000200ULL, 0x000000524c70723cULL, 0x040fe20000041870ULL,
0x000000008150783bULL, 0x000ee80000000200ULL, 0x000000007f58783bULL, 0x000f260000000200ULL,
0x000000604c34723cULL, 0x040ff00000041834ULL, 0x000000624c38723cULL, 0x040fe20000041838ULL,
0x000000007e60783bULL, 0x000eee0000000200ULL, 0x000000644c3c723cULL, 0x042fee000004183cULL,
0x000000162b657810ULL, 0x000fe20007ffe0ffULL, 0x000000664c40723cULL, 0x000fe60000041840ULL,
0x0000000765657812ULL, 0x000fca00078e782cULL, 0x000000202c657824ULL, 0x000fe200078e0265ULL,
0x000000304c44723cULL, 0x044fee0000041844ULL, 0x0000001065307824ULL, 0x000fe200078e00ffULL,
0x000000324c48723cULL, 0x000fe20000041848ULL, 0x000000007b64783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000e660000000200ULL, 0x000000505c74723cULL, 0x048fe20000041874ULL,
0x000000007a4c783bULL, 0x000eae0000000200ULL, 0x000000525c70723cULL, 0x040ff00000041870ULL,
0x000000545c34723cULL, 0x040ff00000041834ULL, 0x000000565c38723cULL, 0x040ff00000041838ULL,
0x000000585c3c723cULL, 0x050ff0000004183cULL, 0x0000005a5c40723cULL, 0x040ff00000041840ULL,
0x000000605c44723cULL, 0x040ff00000041844ULL, 0x000000625c48723cULL, 0x000ff00000041848ULL,
0x0000006c3074723cULL, 0x042ff00000041874ULL, 0x0000006e3070723cULL, 0x040ff00000041870ULL,
0x000000683034723cULL, 0x040ff00000041834ULL, 0x0000006a3038723cULL, 0x040ff00000041838ULL,
0x00000064303c723cULL, 0x040ff0000004183cULL, 0x000000663040723cULL, 0x040ff00000041840ULL,
0x0000004c3044723cULL, 0x044ff00000041844ULL, 0x0000004e3048723cULL, 0x000fee0000041848ULL,
0x0000030079307a10ULL, 0x000fc80007ffe0ffULL, 0x0000000130327810ULL, 0x000fc80007ffe0ffULL,
0x0000002d3200720cULL, 0x000fda0003f06070ULL, 0x000006a000008947ULL, 0x000fea0003800000ULL,
0x0000000230317211ULL, 0x000fe200078e40ffULL, 0x00000004a14c7e24ULL, 0x020fc6000f8e0208ULL,
0x000000312e327217ULL, 0x000fe20007800000ULL, 0x000000010f507824ULL, 0x100fe200078e024cULL,
0x0000004c1e5e7210ULL, 0x000fe20007ffe0ffULL, 0x000000010d4e7824ULL, 0x100fe400078e024cULL,
0x0000000132317824ULL, 0x000fe400078e0a31ULL, 0x00000010030f7824ULL, 0x000fe400078e00ffULL,
0x0000000121627824ULL, 0x000fe200078e024cULL, 0x000000310c00720cULL, 0x000fe20003f66070ULL,
0x00005e004e0c7625ULL, 0x000fe200078e000bULL, 0x000000700f217812ULL, 0x000fc400078ec0ffULL,
0x000000310a00720cULL, 0x080fe20003f46070ULL, 0x0000000111327824ULL, 0x100fe200078e024cULL,
0x0000000c210c7210ULL, 0x000fe20007f9e0ffULL, 0x000000011f607824ULL, 0x000fe200078e024cULL,
0x000000311000720cULL, 0x000fe20003f06070ULL, 0x00005e00321e7625ULL, 0x000fe200078e000bULL,
0x000000310e00720cULL, 0x080fe40003f26070ULL, 0x000000311200720cULL, 0x000fe20003fa6070ULL,
0x000000ffff0d7224ULL, 0x000fe200020e060dULL, 0x0000001e21107210ULL, 0x000fe20007f9e0ffULL,
0x00005e00500e7625ULL, 0x000fc600078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c967faeULL, 0x0003e2000d101c46ULL, 0x0000000113527824ULL, 0x100fe200078e024cULL,
0x0000000e210e7210ULL, 0x000fe20007fde0ffULL, 0x0000000115547824ULL, 0x000fe400078e024cULL,
0x000000ffff117224ULL, 0x000fe200020e061fULL, 0x000000311400720cULL, 0x000fe20003f86070ULL,
0x00005e0052327625ULL, 0x000fc800078e000bULL, 0x00005e0054147625ULL, 0x000fc800078e000bULL,
0x0000000117567824ULL, 0x000fe200078e024cULL, 0x0000001421147210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x0000003221127210ULL, 0x000fe20007fde0ffULL,
0x00005e00561e7625ULL, 0x000fc600078e000bULL, 0x00000033ff137210ULL, 0x000fe200037fe4ffULL,
0x0000000119587824ULL, 0x100fe200078e024cULL, 0x000000000e957faeULL, 0x0005e2000d901c46ULL,
0x000000011b5a7824ULL, 0x000fe200078e024cULL, 0x0000001e211e7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x000000311600720cULL, 0x000fe20003f66070ULL,
0x00005e0058167625ULL, 0x000fe200078e000bULL, 0x000000311800720cULL, 0x080fe20003f46070ULL,
0x0000000010947faeULL, 0x0007e2000c901c46ULL, 0x000000311a00720cULL, 0x000fe20003f26070ULL,
0x00005e005a187625ULL, 0x000fc400078e000bULL, 0x0000000012937faeULL, 0x0009e4000c101c46ULL,
0x000000011d5c7824ULL, 0x000fe200078e024cULL, 0x00000018210e7210ULL, 0x044fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200030e061fULL, 0x00000016210c7210ULL, 0x042fe20007fde0ffULL,
0x00005e005c327625ULL, 0x080fe200078e000bULL, 0x0000000014927faeULL, 0x0003e6000e901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200030e0617ULL, 0x0000003221167210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0619ULL, 0x000000001e917faeULL, 0x0005e2000e101c46ULL,
0x00005e0060187625ULL, 0x000fe200078e000bULL, 0x000000311c00720cULL, 0x000fc40003f06070ULL,
0x000000000c907faeULL, 0x0003e2000d901c46ULL, 0x000000ffff177224ULL, 0x000fe200030e0633ULL,
0x0000001821127210ULL, 0x010fe20007fde0ffULL, 0x0000000123647824ULL, 0x100fe200078e024cULL,
0x000000000e8f7faeULL, 0x0005e2000d101c46ULL, 0x0000000125667824ULL, 0x000fe200078e024cULL,
0x000000312000720cULL, 0x000fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200030e0619ULL,
0x00000000168e7faeULL, 0x0005e2000c901c46ULL, 0x00005e0062187625ULL, 0x000fe200078e000bULL,
0x000000312400720cULL, 0x000fc60003f46070ULL, 0x00005e005e107625ULL, 0x008fe200078e000bULL,
0x0000001821147210ULL, 0x002fc60007f7e0ffULL, 0x0000000127687824ULL, 0x000fe200078e024cULL,
0x0000001021107210ULL, 0x000fe20007fbe0ffULL, 0x00005e00641a7625ULL, 0x000fc800078e000bULL,
0x00005e00661c7625ULL, 0x000fe200078e000bULL, 0x0000001a21187210ULL, 0x000fc60007fde0ffULL,
0x00005e00680c7625ULL, 0x000fc800078e000bULL, 0x000000ffff157224ULL, 0x000fe200018e0619ULL,
0x0000001c211a7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x0000000c210a7210ULL, 0x000fe20007f3e0ffULL, 0x00000001294c7824ULL, 0x000fe200078e024cULL,
0x000000312200720cULL, 0x080fe20003fa6070ULL, 0x000000ffff197224ULL, 0x000fe200030e061bULL,
0x000000312600720cULL, 0x000fe20003fc6070ULL, 0x000000ffff1b7224ULL, 0x000fe200018e061dULL,
0x00000000108d7faeULL, 0x0005e2000c101c46ULL, 0x00005e004c1c7625ULL, 0x000fe200078e000bULL,
0x000000312800720cULL, 0x000fc40003f06070ULL, 0x0000000dff0b7210ULL, 0x000fe20000ffe4ffULL,
0x00000000128c7faeULL, 0x0005e2000e101c46ULL, 0x000000312a00720cULL, 0x000fe40003f26070ULL,
0x0000001c210c7210ULL, 0x000fe20007f7e0ffULL, 0x00000000148b7faeULL, 0x0005e8000e901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200018e061dULL, 0x00000000188a7faeULL, 0x0005e8000d101c46ULL,
0x000000001a897faeULL, 0x0005e8000f101c46ULL, 0x000000000a887faeULL, 0x0005e8000c101c46ULL,
0x000000000c877faeULL, 0x0005e2000c901c46ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x00000004a10a7e24ULL, 0x020fe4000f8e0208ULL, 0x00000010030e7824ULL, 0x000fc400078e00ffULL,
0x000000010d0c7824ULL, 0x100fe200078e020aULL, 0x0000000a1d1c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000115147824ULL, 0x000fe200078e020aULL, 0x000000700e317812ULL, 0x000fe200078ec0ffULL,
0x00005e000c0c7625ULL, 0x000fc800078e000bULL, 0x000000010f0e7824ULL, 0x100fe200078e020aULL,
0x0000000c310c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000111107824ULL, 0x000fe400078e020aULL,
0x00005e000e0e7625ULL, 0x000fc800078e000bULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000e310e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0014147625ULL, 0x000fc600078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c967faeULL, 0x0003e2000b901c46ULL,
0x00005e0010107625ULL, 0x000fc800078e000bULL, 0x0000000119187824ULL, 0x100fe200078e020aULL,
0x0000001031107210ULL, 0x000fe20007f3e0ffULL, 0x0000000117167824ULL, 0x000fe400078e020aULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000001431147210ULL, 0x000fe20007f1e0ffULL,
0x00005e0018187625ULL, 0x000fc600078e000bULL, 0x000000000e957faeULL, 0x0003e2000b901c46ULL,
0x00005e0016167625ULL, 0x000fc800078e000bULL, 0x000000011b1a7824ULL, 0x100fe400078e020aULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000001831187210ULL, 0x000fe20007f1e0ffULL,
0x0000000113127824ULL, 0x000fe400078e020aULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000001631167210ULL, 0x000fe20007f3e0ffULL, 0x00005e001c1c7625ULL, 0x000fc600078e000bULL,
0x0000000010947faeULL, 0x0003e2000b901c46ULL, 0x00005e001a1a7625ULL, 0x000fc800078e000bULL,
0x0000000121227824ULL, 0x100fe400078e020aULL, 0x000000011e1e7824ULL, 0x000fe400078e020aULL,
0x00005e0012127625ULL, 0x000fc800078e000bULL, 0x000000011f207824ULL, 0x100fe200078e020aULL,
0x0000001231127210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000001c311c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000123247824ULL, 0x000fe200078e020aULL,
0x00000013ff137210ULL, 0x000fe200017fe4ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x0000001a311a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0022227625ULL, 0x080fe400078e000bULL,
0x0000000012937faeULL, 0x0003e4000b901c46ULL, 0x00005e001e1e7625ULL, 0x000fc400078e000bULL,
0x0000000014927faeULL, 0x0003e4000b901c46ULL, 0x00005e0020207625ULL, 0x000fe400078e000bULL,
0x0000000016917faeULL, 0x0003e4000b901c46ULL, 0x0000000125267824ULL, 0x100fe200078e020aULL,
0x0000002031207210ULL, 0x000fe20007f5e0ffULL, 0x0000000127287824ULL, 0x100fe200078e020aULL,
0x0000000018907faeULL, 0x0003e2000b901c46ULL, 0x0000000129327824ULL, 0x000fc400078e020aULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x00000022310a7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e061bULL, 0x0000001e311e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0024247625ULL, 0x000fc600078e000bULL, 0x000000001a8f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0026267625ULL, 0x000fc600078e000bULL, 0x000000001c8e7faeULL, 0x0003e2000b901c46ULL,
0x00005e0028287625ULL, 0x000fc800078e000bULL, 0x00005e0032327625ULL, 0x000fc800078e000bULL,
0x000000ffff0b7224ULL, 0x000fe200000e0623ULL, 0x0000002431227210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e061fULL, 0x0000002631247210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e0621ULL, 0x0000002831267210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x000fe200000e0625ULL, 0x0000003231287210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff257224ULL, 0x000fe200008e0627ULL, 0x00000029ff277210ULL, 0x000fe200017fe4ffULL,
0x000000001e8d7faeULL, 0x0003e4000b901c46ULL, 0x000000ffff297224ULL, 0x000fc400018e0633ULL,
0x00000000208c7faeULL, 0x0003e8000b901c46ULL, 0x000000000a8b7faeULL, 0x0003e8000b901c46ULL,
0x00000000228a7faeULL, 0x0003e8000b901c46ULL, 0x0000000024897faeULL, 0x0003e8000b901c46ULL,
0x0000000026887faeULL, 0x0003e8000b901c46ULL, 0x0000000028877faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000182b0b7810ULL, 0x006fc40007ffe0ffULL, 0x0000ffff070a7812ULL, 0x000fe400078ec0ffULL,
0x000000070b0b7812ULL, 0x000fca00078e782cULL, 0x000000202c0b7824ULL, 0x000fc800078e020bULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000008610783bULL, 0x000fe80000000200ULL, 0x000000000b0c783bULL, 0x0002a80000000200ULL,
0x000000008514783bULL, 0x000ee80000000200ULL, 0x00000000841c783bULL, 0x000f220000000200ULL,
0x0000001c2b0b7810ULL, 0x002fc60007ffe0ffULL, 0x000000008320783bULL, 0x000e620000000200ULL,
0x000000070b0b7812ULL, 0x000fc600078e782cULL, 0x000000008224783bULL, 0x000fe40000000200ULL,
0x000000202c0b7824ULL, 0x000fe400078e020bULL, 0x000000009794783bULL, 0x000fe40000000200ULL,
0x000000100b0b7824ULL, 0x000fe400078e00ffULL, 0x000000009998783bULL, 0x000fe80000000200ULL,
0x00000000b218783bULL, 0x000fe80000000200ULL, 0x00000000b84c783bULL, 0x000fe20000000200ULL,
0x000000100c74723cULL, 0x044fee0000041874ULL, 0x0000001a2b117810ULL, 0x040fe20007ffe0ffULL,
0x000000120c70723cULL, 0x000fe20000041870ULL, 0x0000001e2b2b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000711117812ULL, 0x100fe400078e782cULL, 0x000000072b2b7812ULL, 0x000fc600078e782cULL,
0x000000202c117824ULL, 0x040fe200078e0211ULL, 0x000000140c34723cULL, 0x008fe20000041834ULL,
0x000000202c2b7824ULL, 0x000fe400078e022bULL, 0x0000001011117824ULL, 0x000fe400078e00ffULL,
0x000000102b2b7824ULL, 0x000fc600078e00ffULL, 0x000000160c38723cULL, 0x040fe20000041838ULL,
0x000000001110783bULL, 0x000ea80000000200ULL, 0x000000000b14783bULL, 0x000fe60000000200ULL,
0x0000001c0c3c723cULL, 0x050fe2000004183cULL, 0x000000002b28783bULL, 0x000fe80000000200ULL,
0x02461400040b7984ULL, 0x000fe60000000800ULL, 0x0000001e0c40723cULL, 0x040fe20000041840ULL,
0x00000000b31c783bULL, 0x000eee0000000200ULL, 0x000000200c44723cULL, 0x042ff00000041844ULL,
0x000000220c48723cULL, 0x000fe20000041848ULL, 0x00000000b60c783bULL, 0x000e680000000200ULL,
0x00000000b520783bULL, 0x000f260000000200ULL, 0x000000241074723cULL, 0x044ff00000041874ULL,
0x000000261070723cULL, 0x040fe20000041870ULL, 0x00000000b424783bULL, 0x000eae0000000200ULL,
0x000000941034723cULL, 0x040ff00000041834ULL, 0x000000961038723cULL, 0x040ff00000041838ULL,
0x00000098103c723cULL, 0x040ff0000004183cULL, 0x0000009a1040723cULL, 0x040ff00000041840ULL,
0x000000181044723cULL, 0x040ff00000041844ULL, 0x0000001a1048723cULL, 0x000fe20000041848ULL,
0x00000000b710783bULL, 0x000f680000000200ULL, 0x00000000ba18783bULL, 0x000ea60000000200ULL,
0x0000001c1474723cULL, 0x048ff00000041874ULL, 0x0000001e1470723cULL, 0x040fe20000041870ULL,
0x00000000b91c783bULL, 0x000eee0000000200ULL, 0x0000000c1434723cULL, 0x042fee0000041834ULL,
0x000088800a0c7816ULL, 0x000fe200000000ffULL, 0x0000000e1438723cULL, 0x000fe80000041838ULL,
0x800000000c0a7824ULL, 0x000fc800078e00ffULL, 0x00000020143c723cULL, 0x010fe2000004183cULL,
0x800000000bff7812ULL, 0x000fce000780480aULL, 0x000000221440723cULL, 0x040ff00000041840ULL,
0x000000241444723cULL, 0x044ff00000041844ULL, 0x000000261448723cULL, 0x000ff00000041848ULL,
0x000000102874723cULL, 0x060ff00000041874ULL, 0x000000122870723cULL, 0x040ff00000041870ULL,
0x000000182834723cULL, 0x040ff00000041834ULL, 0x0000001a2838723cULL, 0x000fe20000041838ULL,
0x3d80000074747820ULL, 0x000fc40000410000ULL, 0x3d80000075757820ULL, 0x000fe40000410000ULL,
0x3d80000076767820ULL, 0x000fe40000410000ULL, 0x3d80000077777820ULL, 0x000fe20000410000ULL,
0x0000001c283c723cULL, 0x008fe2000004183cULL, 0x3d80000070707820ULL, 0x000fe40000410000ULL,
0x3d80000071717820ULL, 0x000fe40000410000ULL, 0x3d80000072727820ULL, 0x000fc40000410000ULL,
0x3d80000073737820ULL, 0x000fe20000410000ULL, 0x0000001e2840723cULL, 0x040fe20000041840ULL,
0x3d80000034347820ULL, 0x000fe40000410000ULL, 0x3d80000035357820ULL, 0x000fe40000410000ULL,
0x3d80000036367820ULL, 0x000fe40000410000ULL, 0x3d80000037377820ULL, 0x000fe20000410000ULL,
0x0000004c2844723cULL, 0x000fe20000041844ULL, 0x3d80000038387820ULL, 0x000fc40000410000ULL,
0x3d80000039397820ULL, 0x000fe40000410000ULL, 0x3d8000003a3a7820ULL, 0x000fe40000410000ULL,
0x3d8000003b3b7820ULL, 0x000fe20000410000ULL, 0x0000004e2848723cULL, 0x000fe20000041848ULL,
0x3d8000003c3c7820ULL, 0x000fe40000410000ULL, 0x3d8000003d3d7820ULL, 0x000fe40000410000ULL,
0x3d8000003e3e7820ULL, 0x000fc40000410000ULL, 0x3d8000003f3f7820ULL, 0x000fe40000410000ULL,
0x3d80000040407820ULL, 0x000fe40000410000ULL, 0x3d80000041417820ULL, 0x000fe40000410000ULL,
0x3d80000042427820ULL, 0x000fe40000410000ULL, 0x3d80000043437820ULL, 0x000fe40000410000ULL,
0x3d80000044447820ULL, 0x000fc40000410000ULL, 0x3d80000045457820ULL, 0x000fe40000410000ULL,
0x3d80000046467820ULL, 0x000fe40000410000ULL, 0x3d80000047477820ULL, 0x000fe40000410000ULL,
0x3d80000048487820ULL, 0x000fe40000410000ULL, 0x3d80000049497820ULL, 0x000fe40000410000ULL,
0x3d8000004a4a7820ULL, 0x000fc40000410000ULL, 0x3d8000004b4b7820ULL, 0x000fe20000410000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x0000001f0c0c7819ULL, 0x000fe200000006ffULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a000b7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x02461400040b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc4000780480cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004030b7824ULL, 0x000fe200078e00ffULL,
0x000000067900720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff00b0d7812ULL, 0x000fca00078ec0ffULL, 0x00000080780a7824ULL, 0x000fca00078e020dULL,
0x024400000a0c7984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000203107824ULL, 0x000fe400078e00ffULL, 0x000000012e147824ULL, 0x000fc600078e0a09ULL,
0x0000000610107812ULL, 0x000fc800078ec0ffULL, 0x0000000110097812ULL, 0x040fe400078efcffULL,
0x0000000810117812ULL, 0x040fe400078efcffULL, 0x000000140900720cULL, 0x080fe40003f26070ULL,
0x0000001010097812ULL, 0x000fe400078efcffULL, 0x000000141100720cULL, 0x080fe40003f06070ULL,
0x000000140900720cULL, 0x000fc40003fc6070ULL, 0x0000001110117812ULL, 0x040fe400078efcffULL,
0x0000001810097812ULL, 0x040fe400078efcffULL, 0x000000141000720cULL, 0x0c0fe40003f46070ULL,
0x000000141100720cULL, 0x080fe40003fa6070ULL, 0x000000140900720cULL, 0x000fe40003f66070ULL,
0x0000000910127812ULL, 0x000fc400078efcffULL, 0x0000001910117812ULL, 0x040fe400078efcffULL,
0x0000002010097812ULL, 0x000fe400078efcffULL, 0xff7fffff76767808ULL, 0x000fe40005000000ULL,
0xff7fffff74747808ULL, 0x000fe40005000000ULL, 0xff7fffff77777808ULL, 0x000fe40004800000ULL,
0xff7fffff75757808ULL, 0x000fc40004800000ULL, 0x000000141200720cULL, 0x080fe40003f86070ULL,
0x000000141100720cULL, 0x080fe40003f46070ULL, 0x000000140900720cULL, 0x000fe40003f26070ULL,
0x0000002110117812ULL, 0x040fe400078efcffULL, 0x0000002810097812ULL, 0x000fe400078efcffULL,
0xff7fffff72727808ULL, 0x000fc40004000000ULL, 0xff7fffff70707808ULL, 0x000fe40004000000ULL,
0xff7fffff73737808ULL, 0x000fe40006000000ULL, 0xff7fffff71717808ULL, 0x000fe40006000000ULL,
0x000000141100720cULL, 0x080fe40003f06070ULL, 0x000000140900720cULL, 0x000fe40003f86070ULL,
0x0000002910117812ULL, 0x000fc400078efcffULL, 0x0000003010097812ULL, 0x000fe400078efcffULL,
0xff7fffff36367808ULL, 0x000fe40007000000ULL, 0xff7fffff34347808ULL, 0x000fe40007000000ULL,
0xff7fffff37377808ULL, 0x000fe40006800000ULL, 0xff7fffff35357808ULL, 0x000fe40006800000ULL,
0x000000141100720cULL, 0x000fc40003fc6070ULL, 0x000000140900720cULL, 0x000fe40003fa6070ULL,
0x0000003110117812ULL, 0x040fe400078efcffULL, 0x0000003810097812ULL, 0x040fe400078efcffULL,
0x0000003910107812ULL, 0x000fe400078efcffULL, 0xff7fffff3a3a7808ULL, 0x000fe40005800000ULL,
0xff7fffff38387808ULL, 0x000fc40005800000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40005000000ULL,
0xff7fffff39397808ULL, 0x000fe40005000000ULL, 0xff7fffff3e3e7808ULL, 0x000fe40004800000ULL,
0xff7fffff3c3c7808ULL, 0x000fe40004800000ULL, 0x000000141100720cULL, 0x080fe40003f66070ULL,
0x000000140900720cULL, 0x000fc40003f46070ULL, 0x000000141000720cULL, 0x000fe40003f26070ULL,
0xff7fffff3f3f7808ULL, 0x000fe40004000000ULL, 0xff7fffff3d3d7808ULL, 0x000fe40004000000ULL,
0xff7fffff42427808ULL, 0x000fe40006000000ULL, 0xff7fffff40407808ULL, 0x000fe40006000000ULL,
0xff7fffff43437808ULL, 0x000fc40007000000ULL, 0xff7fffff41417808ULL, 0x000fe40007000000ULL,
0xff7fffff46467808ULL, 0x000fe40006800000ULL, 0xff7fffff44447808ULL, 0x000fe40006800000ULL,
0xff7fffff47477808ULL, 0x000fe40005800000ULL, 0xff7fffff45457808ULL, 0x000fe40005800000ULL,
0xff7fffff4a4a7808ULL, 0x000fc40005000000ULL, 0xff7fffff48487808ULL, 0x000fe40005000000ULL,
0xff7fffff4b4b7808ULL, 0x000fe40004800000ULL, 0xff7fffff49497808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000740c0c7209ULL, 0x004fe40007810000ULL,
0x000000760d107209ULL, 0x000fe40007810000ULL, 0x000000750c097209ULL, 0x000fe40007810000ULL,
0x00000077100d7209ULL, 0x000fc40007810000ULL, 0x00000070090c7209ULL, 0x000fe40007810000ULL,
0x000000720d107209ULL, 0x000fe40007810000ULL, 0x000000710c097209ULL, 0x000fe40007810000ULL,
0x00000073100d7209ULL, 0x000fe40007810000ULL, 0x00000034090c7209ULL, 0x000fe40007810000ULL,
0x000000360d107209ULL, 0x000fc40007810000ULL, 0x000000350c097209ULL, 0x000fe40007810000ULL,
0x00000037100d7209ULL, 0x000fe40007810000ULL, 0x00000038090c7209ULL, 0x000fe40007810000ULL,
0x0000003a0d107209ULL, 0x000fe40007810000ULL, 0x000000390c097209ULL, 0x000fe40007810000ULL,
0x0000003b100d7209ULL, 0x000fc40007810000ULL, 0x0000003c090c7209ULL, 0x000fe40007810000ULL,
0x0000003e0d107209ULL, 0x000fe40007810000ULL, 0x0000003d0c097209ULL, 0x000fe40007810000ULL,
0x0000003f100d7209ULL, 0x000fe40007810000ULL, 0x00000040090c7209ULL, 0x000fe40007810000ULL,
0x000000420d107209ULL, 0x000fc40007810000ULL, 0x000000410c097209ULL, 0x000fe40007810000ULL,
0x00000043100d7209ULL, 0x000fe40007810000ULL, 0x00000044090c7209ULL, 0x000fe40007810000ULL,
0x000000460d107209ULL, 0x000fe40007810000ULL, 0x000000450c097209ULL, 0x000fe40007810000ULL,
0x00000047100d7209ULL, 0x000fc40007810000ULL, 0x00000048090c7209ULL, 0x000fe40007810000ULL,
0x0000004a0d107209ULL, 0x000fe40007810000ULL, 0x000000490c0c7209ULL, 0x000fe40007810000ULL,
0x0000004b10147209ULL, 0x000fe20007810000ULL, 0x00000dc27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000c097f89ULL, 0x0004e400000e0000ULL, 0x000000090c167209ULL, 0x00cfe20007810000ULL,
0x00000e027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0014097f89ULL, 0x000ea800000e0000ULL,
0x0c401f000e0d7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000f0c7f89ULL, 0x000f2200000e0000ULL,
0x0000000914097209ULL, 0x004fc40007810000ULL, 0x0000000d0e107209ULL, 0x008fc60007810000ULL,
0x0c201f0009127f89ULL, 0x002fe200000e0000ULL, 0x0000000c0f207209ULL, 0x010fc60007810000ULL,
0x0c201f00160d7f89ULL, 0x000e6800000e0000ULL, 0x0c201f0010117f89ULL, 0x000ea800000e0000ULL,
0x0c201f0020217f89ULL, 0x00072200000e0000ULL, 0x0000000d160c7209ULL, 0x002fe40007810000ULL,
0x00000012090d7209ULL, 0x000fc40007810000ULL, 0x00000011100e7209ULL, 0x004fe40007810000ULL,
0x3fb8aa3b0c097820ULL, 0x008fe20000410000ULL, 0x3f80000000057882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b0d0f7820ULL, 0x000fe20000410000ULL, 0xfffffffc03237812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b75757823ULL, 0x100fe40000010809ULL, 0x3fb8aa3b71717823ULL, 0x100fe40000010809ULL,
0x3fb8aa3b74747823ULL, 0x100fe40000010809ULL, 0x3fb8aa3b70707823ULL, 0x000fe20000010809ULL,
0x0000007500757308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b76767823ULL, 0x000fc4000001080fULL,
0x3fb8aa3b77777823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b72727823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b73737823ULL, 0x000fe2000001080fULL, 0x0000007400107308ULL, 0x000ea20000000800ULL,
0x00000005ff287e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010809ULL, 0x0000000000087886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010809ULL, 0x3f8000002828783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010809ULL, 0x0000007000127308ULL, 0x002fe20000000800ULL,
0x3fb8aa3b38387823ULL, 0x000fc40000010809ULL, 0x000000ffff297224ULL, 0x000fe400078e0028ULL,
0x3fb8aa3b36367823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001080fULL,
0x0000007100717308ULL, 0x000e620000000800ULL, 0x000000107510723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b3b3b7823ULL, 0x000fe4000001080fULL,
0x3fb8aa3b3d3d7823ULL, 0x000fc40000010809ULL, 0x0000007600117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b41417823ULL, 0x100fe40000010809ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe40000010809ULL,
0x3fb8aa3b40407823ULL, 0x000fe40000010809ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001080fULL,
0x0000007700227308ULL, 0x000ea20000000800ULL, 0x000000127112723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b3f3f7823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b42427823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b43437823ULL, 0x000fe4000001080fULL, 0x0000007200137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b44447823ULL, 0x100fe40000010809ULL, 0x3fb8aa3b45457823ULL, 0x100fe40000010809ULL,
0x3fb8aa3b48487823ULL, 0x100fe40000010809ULL, 0x3fb8aa3b49097823ULL, 0x000fe20000010809ULL,
0x0000007300247308ULL, 0x000e620000000800ULL, 0x000000112211723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b46467823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b47477823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe4000001080fULL, 0x0000003400147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4b0f7823ULL, 0x000fe2000001080fULL, 0x000000132413723eULL, 0x002fcc00000010ffULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x00000028104c723cULL, 0x000fee00000418ffULL,
0x0000003800167308ULL, 0x000ff00000000800ULL, 0x0000003900397308ULL, 0x000ea20000000800ULL,
0x000000143514723eULL, 0x002fce00000010ffULL, 0x0000003600157308ULL, 0x000ff00000000800ULL,
0x0000003700267308ULL, 0x000e620000000800ULL, 0x000000163916723eULL, 0x004fce00000010ffULL,
0x0000003a00177308ULL, 0x000ff00000000800ULL, 0x0000003b00227308ULL, 0x000ea20000000800ULL,
0x000000152615723eULL, 0x002fce00000010ffULL, 0x0000003c00187308ULL, 0x000fe20000000800ULL,
0x000000172217723eULL, 0x004fce00000010ffULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0x00000028144c723cULL, 0x000fee000004184cULL, 0x00000040001a7308ULL, 0x000ff00000000800ULL,
0x0000004100417308ULL, 0x000ea20000000800ULL, 0x000000183d18723eULL, 0x002fce00000010ffULL,
0x0000003e00197308ULL, 0x000ff00000000800ULL, 0x0000003f00247308ULL, 0x000e620000000800ULL,
0x0000001a411a723eULL, 0x004fce00000010ffULL, 0x00000042001b7308ULL, 0x000ff00000000800ULL,
0x0000004300227308ULL, 0x000ea20000000800ULL, 0x000000192419723eULL, 0x002fe200000010ffULL,
0x0000000fff247424ULL, 0x000fca00078e00ffULL, 0x0000002324277219ULL, 0x000fe200000006ffULL,
0x00000044001c7308ULL, 0x000fe60000000800ULL, 0x00000000272473a1ULL, 0x000e6200000e8000ULL,
0x00000000270573c4ULL, 0x000ee20000004000ULL, 0x0000001b221b723eULL, 0x004fc600000010ffULL,
0x0000004500457308ULL, 0x000ea80000000800ULL, 0x00000028184c723cULL, 0x000fe8000004184cULL,
0x00000048001e7308ULL, 0x000ff00000000800ULL, 0x0000000900097308ULL, 0x000f620000000800ULL,
0x0000001c451c723eULL, 0x004fc400000010ffULL, 0x0000000827ff7c12ULL, 0x002fca000f804024ULL,
0x00000046001d7308ULL, 0x000ff00000000800ULL, 0x0000004700267308ULL, 0x000e620000000800ULL,
0x0000001e091e723eULL, 0x020fce00000010ffULL, 0x0000004a001f7308ULL, 0x000ff00000000800ULL,
0x0000000f00227308ULL, 0x0005620000000800ULL, 0x0000001d261d723eULL, 0x002fe400000010ffULL,
0x00000020210f7209ULL, 0x014fc40007810000ULL, 0x0000001f221f723eULL, 0x020fce00000010ffULL,
0x000000281c4c723cULL, 0x000fe2000004184cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000a0205008947ULL, 0x008fde000b800000ULL, 0x001c1fff4c207589ULL, 0x0002a400000e0000ULL,
0x00000000272273a1ULL, 0x000ee200000e8000ULL, 0x00000000270573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x0000000827ff7c12ULL, 0x008fda000f804022ULL,
0x00000a1205008947ULL, 0x010fea000b800000ULL, 0x001c1fff4e217589ULL, 0x00072800000e0000ULL,
0x001c1fff22227589ULL, 0x00066800000e0000ULL, 0x001c1fff00237589ULL, 0x0006a400000e0000ULL,
0x00000002ff097819ULL, 0x002fe40000011603ULL, 0x0000000c0b3d7812ULL, 0x000fc400078ec0ffULL,
0x0000000709247812ULL, 0x040fe200078ec0ffULL, 0x0000000809257824ULL, 0x040fe200078e00ffULL,
0x0000000309297819ULL, 0x040fe200000006ffULL, 0x0000000809387824ULL, 0x040fe200078e00ffULL,
0x00000009ff277212ULL, 0x008fe400078e33ffULL, 0x0000000809097810ULL, 0x000fe40007ffe0ffULL,
0xfffffff829267812ULL, 0x100fe400078ee224ULL, 0x0000000125287812ULL, 0x100fe200078ef624ULL,
0x0000000809297824ULL, 0x000fe200078e00ffULL, 0x00000002252a7812ULL, 0x100fe200078ef624ULL,
0x0000000809487824ULL, 0x000fe200078e00ffULL, 0x00000003252c7812ULL, 0x000fc400078ef624ULL,
0x0000000425327812ULL, 0x140fe400078ef624ULL, 0x0000000525347812ULL, 0x140fe400078ef624ULL,
0x0000000625367812ULL, 0x000fe200078ef624ULL, 0x0000000809257824ULL, 0x040fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe400078ee227ULL, 0x00000009ff277212ULL, 0x000fe400078e33ffULL,
0x0000000709247812ULL, 0x000fc400078ec0ffULL, 0x0001200078097811ULL, 0x000fe400078e58ffULL,
0xfffffff8293a7812ULL, 0x100fe400078ee224ULL, 0x00000001253c7812ULL, 0x140fe200078ef624ULL,
0x00000010260b7824ULL, 0x100fe200078e0209ULL, 0x00000002253e7812ULL, 0x140fe200078ef624ULL,
0x000000102c267824ULL, 0x100fe200078e0209ULL, 0x0000000325407812ULL, 0x140fe200078ef624ULL,
0x00000010362c7824ULL, 0x000fe200078e0209ULL, 0x0000000425427812ULL, 0x100fe200078ef624ULL,
0x000000013d0b7824ULL, 0x000fe200078e020bULL, 0x0000000525447812ULL, 0x140fe200078ef624ULL,
0x000000103c357824ULL, 0x100fe200078e0209ULL, 0x0000000625467812ULL, 0x000fe200078ef624ULL,
0x0000001028247824ULL, 0x000fe200078e0209ULL, 0xfffffff848487812ULL, 0x000fe200078ee227ULL,
0x000000102a257824ULL, 0x100fe200078e0209ULL, 0x00000009342a7211ULL, 0x080fe200078e20ffULL,
0x0000001032287824ULL, 0x100fe200078e0209ULL, 0x00000009483b7211ULL, 0x000fe200078e20ffULL,
0x0000001038327824ULL, 0x100fe200078e0209ULL, 0x000000100b007388ULL, 0x0003e20000000800ULL,
0x000000103a347824ULL, 0x100fe200078e0209ULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x000000103e367824ULL, 0x000fc400078e0209ULL, 0x0000001040377824ULL, 0x100fe400078e0209ULL,
0x0000001042387824ULL, 0x100fe400078e0209ULL, 0x0000001044397824ULL, 0x100fe200078e0209ULL,
0x000000373d107210ULL, 0x042fe20007ffe0ffULL, 0x00000010463a7824ULL, 0x000fe400078e0209ULL,
0x000000013d097824ULL, 0x040fe400078e0224ULL, 0x000000013d257824ULL, 0x000fc400078e0225ULL,
0x000000013d277824ULL, 0x040fe200078e0226ULL, 0x0000001209007388ULL, 0x0003e20000000800ULL,
0x000000013d297824ULL, 0x040fe400078e0228ULL, 0x000000013d2b7824ULL, 0x040fe200078e022aULL,
0x0000001425007388ULL, 0x0003e20000000800ULL, 0x000000013d317824ULL, 0x040fe400078e022cULL,
0x000000013d337824ULL, 0x040fe200078e0232ULL, 0x0000001627007388ULL, 0x0003e20000000800ULL,
0x000000013d347824ULL, 0x000fc400078e0234ULL, 0x000000013d247824ULL, 0x040fe200078e0235ULL,
0x0000001829007388ULL, 0x0003e20000000800ULL, 0x000000013d367824ULL, 0x040fe400078e0236ULL,
0x000000013d387824ULL, 0x040fe200078e0238ULL, 0x0000001a2b007388ULL, 0x0003e20000000800ULL,
0x000000013d267824ULL, 0x040fe400078e0239ULL, 0x000000013d3a7824ULL, 0x040fe200078e023aULL,
0x0000001c31007388ULL, 0x0003e20000000800ULL, 0x000000013d287824ULL, 0x000fc600078e023bULL,
0x0000001e33007388ULL, 0x0003e80000000800ULL, 0x0000001134007388ULL, 0x0003e80000000800ULL,
0x0000001324007388ULL, 0x0003e80000000800ULL, 0x0000001536007388ULL, 0x0003e80000000800ULL,
0x0000001710007388ULL, 0x0003e80000000800ULL, 0x0000001938007388ULL, 0x0003e80000000800ULL,
0x0000001b26007388ULL, 0x0003e80000000800ULL, 0x0000001d3a007388ULL, 0x0003e80000000800ULL,
0x0000001f28007388ULL, 0x0003e80000000800ULL, 0x0240000c0a008388ULL, 0x0003e80000000c00ULL,
0x024200200a008388ULL, 0x0143e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000002d3000720cULL, 0x000fe20003f26070ULL, 0x0246080004ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff07ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff797224ULL, 0x000fc600078e0030ULL,
0x00000001ff077807ULL, 0x000fce0000000000ULL, 0x0000001000001944ULL, 0x004fe20003c00000ULL,
0xffff9eb000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e000cULL, 0x00015ec000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff127424ULL, 0x000fe400078e00ffULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff187424ULL, 0x000fe400078e00ffULL, 0x0000061000007944ULL, 0x002fea0003c00000ULL,
0xfffff1e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff097224ULL, 0x000fe200078e0014ULL,
0x0000000200127802ULL, 0x002fe20000000f00ULL, 0x0000001fff137424ULL, 0x000fe200078e00ffULL,
0x00015f3000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff187424ULL, 0x000fc400078e00ffULL,
0x000005a000007944ULL, 0x000fea0003c00000ULL, 0x0000000914147209ULL, 0x004fe20007810000ULL,
0x000000ffff097224ULL, 0x000fe200078e000eULL, 0x00015fa000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff127424ULL, 0x002fc400078e00ffULL, 0x0000001fff137424ULL, 0x000fe400078e00ffULL,
0xffffffffff187424ULL, 0x000fe400078e00ffULL, 0x0000053000007944ULL, 0x000fea0003c00000ULL,
0x000000090e0e7209ULL, 0x004fe20007810000ULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0001601000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff127424ULL, 0x002fe400078e00ffULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff187424ULL, 0x000fe400078e00ffULL,
0x000004c000007944ULL, 0x000fea0003c00000ULL, 0x000000090f207209ULL, 0x004fe20007810000ULL,
0x00000001ff127424ULL, 0x002fe200078e00ffULL, 0x0000001600097202ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fe200078e00ffULL, 0x0001608000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff187424ULL, 0x000fc400078e00ffULL, 0x0000045000007944ULL, 0x000fea0003c00000ULL,
0x00000009160c7209ULL, 0x004fe20007810000ULL, 0x000000ffff097224ULL, 0x000fe200078e0014ULL,
0x000160f000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff127424ULL, 0x002fc400078e00ffULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff187424ULL, 0x000fe400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x00000009140d7209ULL, 0x004fe20007810000ULL,
0x000000ffff097224ULL, 0x000fe200078e000eULL, 0xffffffff00187802ULL, 0x002fe20000000f00ULL,
0x00000001ff127424ULL, 0x000fe200078e00ffULL, 0x0001616000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000090e0e7209ULL, 0x004fe20007810000ULL, 0x000000ffff097224ULL, 0x000fe200078e0020ULL,
0x000161d000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff127424ULL, 0x002fc400078e00ffULL,
0x0000001fff137424ULL, 0x000fe400078e00ffULL, 0xffffffffff187424ULL, 0x000fe400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff217224ULL, 0x004fe200078e0009ULL,
0xffffefb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff097224ULL, 0x000fe200078e004cULL,
0x00001c1f00287802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x0001624000247802ULL, 0x000fe40000000f00ULL, 0x000002d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff207224ULL, 0x004fe200078e0023ULL, 0xfffff5a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff097224ULL, 0x002fe200078e004eULL, 0x000162b000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fe400078e00ffULL, 0x00001c1fff287424ULL, 0x000fc400078e00ffULL,
0x0000026000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff267224ULL, 0x002fe200078e00ffULL,
0x0001630000247802ULL, 0x000fe20000000f00ULL, 0x00001c1fff287424ULL, 0x000fc400078e00ffULL,
0x000000ffff217224ULL, 0x004fe400078e0023ULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff267224ULL, 0x002fe200078e00ffULL, 0x0001635000247802ULL, 0x000fe20000000f00ULL,
0x00001c1fff287424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e0023ULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xfffff52000007947ULL, 0x000fea000383ffffULL,
0x0180000033037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000003300038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff33ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000033047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003300037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff177424ULL, 0x000fc800078e00ffULL,
0xfffe9b3016007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000001800007348ULL, 0x000fe80003800000ULL, 0x0c00001209097389ULL, 0x0002a200000e0013ULL,
0xfffe9af010007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff257424ULL, 0x000fe200078e00ffULL,
0x0000002700007348ULL, 0x000fe80003800000ULL, 0x0000002609237389ULL, 0x0002a200000e0028ULL,
0xfffe9ab024007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000024680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x000000000000045cULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c4cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c70ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c80ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ca0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d10ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d18ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000d28ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000f00ULL, 0x0000000000016600ULL, 0xea00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017500ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017510ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017510ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017990ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000d10ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000167f0ULL, 0x00000000000167f0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017500ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017990ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_64_nqpkv_16_m_16_sm_80_cubin_len = 96880;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
