/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016a78ULL, 0x00000000000165f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000015470ULL, 0x0000000000000290ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000015700ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001547000000000ULL, 0x0000100400000000ULL, 0x0198288080810c00ULL, 0x0000000000550004ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808292ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x0001547000000000ULL,
0x0000029000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000980000000bULL, 0x0000000b00081104ULL, 0x0008120400000098ULL, 0x000000980000000eULL,
0x0000000e00081104ULL, 0x0008120400000098ULL, 0x000000980000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x0000ab2000183104ULL, 0x000148e00000b090ULL, 0x00014900000148f0ULL,
0x0134290400014910ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x050000160500000bULL,
0x0500000b05000016ULL, 0x0500000b0500000bULL, 0x0500002f0500002fULL, 0x0500002f0500002fULL,
0x0500002f0500002fULL, 0x0500002f0500002fULL, 0x0500002f0500002fULL, 0x013428040500002fULL,
0x000000c0000000b0ULL, 0x00002910000019e0ULL, 0x00002a40000029d0ULL, 0x00002ea000002a70ULL,
0x0000323000002ed0ULL, 0x00003d2000003d10ULL, 0x00004a1000003fc0ULL, 0x00004b0000004ab0ULL,
0x00004e7000004b30ULL, 0x0000510000004eb0ULL, 0x00005a6000005a50ULL, 0x000064f000005cc0ULL,
0x000065e000006590ULL, 0x0000696000006620ULL, 0x00006bb000006990ULL, 0x0000741000007400ULL,
0x00007f7000007650ULL, 0x0000807000008010ULL, 0x000083f0000080a0ULL, 0x0000869000008400ULL,
0x00008f1000008ef0ULL, 0x0000926000009250ULL, 0x0000ab2000009740ULL, 0x0000b5300000b090ULL,
0x0000ba700000b560ULL, 0x0000bf000000ba90ULL, 0x000141e0000141d0ULL, 0x00014200000141f0ULL,
0x0001425000014230ULL, 0x0001428000014270ULL, 0x000148f0000148d0ULL, 0x0001494000014900ULL,
0x0001496000014950ULL, 0x0001500000014f70ULL, 0x000150c000015060ULL, 0x0001519000015130ULL,
0x00015250000151f0ULL, 0x00015390000152f0ULL, 0x01f0390400015430ULL, 0x000000ff000001c0ULL,
0x000401000001c600ULL, 0x00000002000002a0ULL, 0x003f01000001c608ULL, 0x00000002000003b0ULL,
0x003f01000001c688ULL, 0x000000ff000006f0ULL, 0x000601070001c600ULL, 0x0000000300000850ULL,
0x000601010001c688ULL, 0x0000002400002840ULL, 0x000601010001c608ULL, 0x0000002700002890ULL,
0x000601090001c608ULL, 0x000000ff00003ed0ULL, 0x000601010001c688ULL, 0x0000000900004970ULL,
0x000601010001c628ULL, 0x0000000900004990ULL, 0x000601090001c628ULL, 0x000000ff00005c70ULL,
0x000601010001c690ULL, 0x0000002400006460ULL, 0x000601010001c648ULL, 0x0000001100006470ULL,
0x000601090001c648ULL, 0x000000ff00007560ULL, 0x000601010001c698ULL, 0x0000000a00007ed0ULL,
0x000601010001c668ULL, 0x0000001100007ef0ULL, 0x000601090001c668ULL, 0x000000ff00008f20ULL,
0x000601010001c6a0ULL, 0x000000ff0000c1b0ULL, 0x000601010001c600ULL, 0x000000ff0000df60ULL,
0x000601090001c600ULL, 0x000000ff000137d0ULL, 0x000c01010001c688ULL, 0x000000ff00013820ULL,
0x000c01090001c688ULL, 0x0000000300014c60ULL, 0x003f01010001c608ULL, 0x0000000300014c70ULL,
0x003f01010001c610ULL, 0x0000000300014c80ULL, 0x003f01010001c618ULL, 0x0000000300014c90ULL,
0x003f01010001c620ULL, 0x000000ff00014cc0ULL, 0x001801090001c608ULL, 0x000000ff00014d20ULL,
0x001801090001c628ULL, 0x000000ff00014d80ULL, 0x001801090001c648ULL, 0x000000ff00014de0ULL,
0x001801090001c668ULL, 0x000000ff00014e40ULL, 0x000601090001c600ULL, 0x0000000500014eb0ULL,
0x003f01090001c688ULL, 0x00101c0400033803ULL, 0x0000df900000c170ULL, 0x00014cb00000e010ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400581903ULL,
0x005802100000000fULL, 0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL,
0x00000000000000c4ULL, 0x0000000e00000002ULL, 0x0000000000015470ULL, 0x0000000000000044ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0xffffff6801017836ULL, 0x002fe20000000000ULL,
0x000001c000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000e620000002300ULL,
0x0000000000007919ULL, 0x000f280000002200ULL, 0x00008800ff047b82ULL, 0x000f700000000a00ULL,
0x00000000000879c3ULL, 0x000f700000002700ULL, 0x00000000000779c3ULL, 0x000f620000002600ULL,
0x00000005ff027819ULL, 0x004fe20000011609ULL, 0x00001fff03077589ULL, 0x002fea00000e0000ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000000103007824ULL, 0x010fc800078e0200ULL,
0x0000008000067824ULL, 0x000fca00078e0209ULL, 0x000000ff0600720cULL, 0x040fe40003f05270ULL,
0x0000000f0600780cULL, 0x040fe40003f24070ULL, 0x000000030600780cULL, 0x000fe40003f44070ULL,
0x00000000021072caULL, 0x002fe200000e0000ULL, 0x00000004ff027e24ULL, 0x008fca000f8e00ffULL,
0x0000440201007387ULL, 0x0003ee0000100800ULL, 0x0000001007007c11ULL, 0x000fe2000f8e10ffULL,
0x0000000000240947ULL, 0x022fec0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff00000a7882ULL, 0x000fe20000000000ULL,
0x7ffc0000000b7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x004fe20008000004ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01c6000a043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000406027c11ULL, 0x002fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01c60804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000406027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000020612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01c68804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000979c3ULL, 0x000ee20000008800ULL,
0x00000000001e7919ULL, 0x000f220000000000ULL, 0x0000007f0600780cULL, 0x000fe20003f04070ULL,
0x0000040000067882ULL, 0x002fe20000000000ULL, 0x00008400000d7ab9ULL, 0x000fe20000000800ULL,
0x0000000200087824ULL, 0x000fe200078e00ffULL, 0x0000000307047899ULL, 0x000fe4000800063fULL,
0x000000030d057899ULL, 0x000fe2000800063fULL, 0x00000001080a7836ULL, 0x040fe20000000000ULL,
0x0000000808037848ULL, 0x000fe20007fe0000ULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0x00000008050472a4ULL, 0x000fc6000f8e0204ULL, 0xff317217ff0f8424ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a08ULL, 0x0000000408097c36ULL, 0x000fe40008000000ULL,
0x000000040a0b7c36ULL, 0x000fe20008000000ULL, 0x000000ff0300720cULL, 0x040fe20003f23070ULL,
0x0000065409067896ULL, 0x008fe20008000006ULL, 0x000000010300780cULL, 0x000fe20003f43070ULL,
0x0000020009027825ULL, 0x000fe200078e0004ULL, 0x0000000708097812ULL, 0x000fe200078ec0ffULL,
0x0001c60006047890ULL, 0x000fc4000fffe03fULL, 0x0000000606068c11ULL, 0x000fe2000f8e10ffULL,
0x000002000b047825ULL, 0x000fe200078e0004ULL, 0x000000070a0b7812ULL, 0x000fe400078ec0ffULL,
0x0000001f09097812ULL, 0x010fe200078e781eULL, 0x01c4000f06008388ULL, 0x0003e20000000800ULL,
0x000000101e007824ULL, 0x000fe200078e00ffULL, 0x0000001f0b0b7812ULL, 0x000fe400078e781eULL,
0x0000002008097824ULL, 0x000fe400078e0209ULL, 0x000001f0000d7812ULL, 0x000fe200078ec0ffULL,
0x000000200a0b7824ULL, 0x000fc400078e020bULL, 0x0000000609097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000000007b1dULL, 0x004fe20000010000ULL, 0x0000000d02027210ULL, 0x000fe40007f7e0ffULL,
0x0000000d04047210ULL, 0x000fe40007f9e0ffULL, 0x000000060b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe400018e0603ULL, 0x000000ffff057224ULL, 0x000fc600020e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000c901c4eULL,
0x00000000040b7faeULL, 0x0003e2000d101c4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fc40000000a00ULL,
0x00000004080478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000005ff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000e02027981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000030000117ab9ULL, 0x000fe20000000800ULL,
0x00000000021472caULL, 0x004fda00000e0000ULL, 0x0000007f14047890ULL, 0x000fe4000fffe03fULL,
0x000000ff14057890ULL, 0x000fe4000fffe03fULL, 0x000000073f047899ULL, 0x000fe40008011604ULL,
0x000000083f057899ULL, 0x000fe20008011605ULL, 0x000000b800608947ULL, 0x000ff60003800000ULL,
0x0000440001207983ULL, 0x000ea20000100800ULL, 0x0000000310127899ULL, 0x000fe2000800063fULL,
0x00000004ff007424ULL, 0x000fe200078e00ffULL, 0xffffffff00197882ULL, 0x000fc80000000000ULL,
0x00000012ff037e24ULL, 0x000fc8000f8e00ffULL, 0x01c6880003ff79a7ULL, 0x0003e20008500006ULL,
0x00000000200972caULL, 0x044fe200000e0000ULL, 0x0000000120047836ULL, 0x000fd80000000000ULL,
0x0000000109097899ULL, 0x000fc8000800063fULL, 0x000000040900728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000280947ULL, 0x002fea0003800000ULL,
0x00009000000c7ab9ULL, 0x000fe20000000800ULL, 0x00000001080a7899ULL, 0x000fe4000800063fULL,
0x0000000c090b7290ULL, 0x000fc8000fffe03fULL, 0x0000000c0a0c72a4ULL, 0x000fc6000f8e020bULL,
0x00008c00000a7ab9ULL, 0x000fe40000000a00ULL, 0x000000040c0a78a5ULL, 0x000fcc000f8e000aULL,
0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff037e24ULL, 0x000fca000f8e00ffULL,
0x0000000e02027981ULL, 0x000ea4000c1e1900ULL, 0x00000000021972caULL, 0x004fde00000e0000ULL,
0x0000000504007c0cULL, 0x000fe2000bf06070ULL, 0x0000000d190a72a4ULL, 0x000fe4000f8e023fULL,
0x0000001206187290ULL, 0x000fe4000fffe03fULL, 0x000000070a0b7899ULL, 0x000fd0000800063fULL,
0x0000000400d88947ULL, 0x000fea0003800000ULL, 0x0000010020007824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe2000001161eULL, 0x00000007ff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x000000ffff057224ULL, 0x000fe200078e0a00ULL,
0x0000001400027c48ULL, 0x000fe2000ffe0000ULL, 0x0000000413037836ULL, 0x040fe20000000000ULL,
0x0000000310137899ULL, 0x000fe2000800063fULL, 0x000000800e0e7824ULL, 0x000fe200078e0213ULL,
0x0000002002007446ULL, 0x000fe20003800005ULL, 0x0000000813057836ULL, 0x000fe20000000000ULL,
0x0000001e03027212ULL, 0x040fe200078e3cffULL, 0x0000000803077824ULL, 0x040fe200078e00ffULL,
0x000000000300720cULL, 0x000fe20003f46070ULL, 0x0000000805147824ULL, 0x040fe200078e00ffULL,
0x0000001e05037212ULL, 0x040fe200078e3cffULL, 0x000000100e097836ULL, 0x040fe20000000000ULL,
0xfffffff807127812ULL, 0x000fe200078ee202ULL, 0x000000040e027836ULL, 0x040fe20000000000ULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x000000080e037836ULL, 0x040fe20000000000ULL,
0x000000000500720cULL, 0x000fe20003f26070ULL, 0x00000006100a7291ULL, 0x000fe2000f8e683fULL,
0x0000000b02057c10ULL, 0x000fe2000ff7e0ffULL, 0x00000013ff157e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b03037c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000c13117836ULL, 0x000fe20000000000ULL,
0x0000000b0e077c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x0000000c05047c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000000c03027c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000000d05057c11ULL, 0x000fe200098f4c08ULL, 0x0000000c0e087836ULL, 0x040fe20000000000ULL,
0x0000000d03037c11ULL, 0x000fe2000a0f4c0aULL, 0x000000140e0a7836ULL, 0x000fe20000000000ULL,
0x0000000c07067c11ULL, 0x000fe2000f8048ffULL, 0x000140000a0a7890ULL, 0x000fe2000fffe03fULL,
0x0000000b090b7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000008111b7824ULL, 0x000fe200078e00ffULL,
0x0000000b0a0d7c10ULL, 0x000fe2000ff9e0ffULL, 0x00000018131d7836ULL, 0x000fe20000000000ULL,
0x0000000d07077c11ULL, 0x000fe200080f4c0cULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000000b080f7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x0000000c0d0c7c11ULL, 0x000fc4000f8848ffULL, 0x0000000c0b0a7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x0000000d0d0d7c11ULL, 0x000fe2000a0f4c10ULL,
0x000000180e107836ULL, 0x040fe20000000000ULL, 0x0000000c0f087c11ULL, 0x000fe2000f8048ffULL,
0x0000001c0e0e7836ULL, 0x000fe20000000000ULL, 0x0000000d0b0b7c11ULL, 0x000fe400098f4c16ULL,
0x0000000d0f097c11ULL, 0x000fe400080f4c18ULL, 0x00000007130f7812ULL, 0x000fc400078e481eULL,
0x0000000b0e187c10ULL, 0x000fe4000ffbe0ffULL, 0x000000001300720cULL, 0x000fe40003f66070ULL,
0x0ffffff80f0f7812ULL, 0x000fe200078ef81eULL, 0x000000ffff197224ULL, 0x000fe200028e06ffULL,
0x0000000b101a7c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff815157812ULL, 0x000fe400078ee21eULL,
0x0000001e11167212ULL, 0x000fc400078e3cffULL, 0x0000000c18107c11ULL, 0x000fe2000f8a48ffULL,
0x0000001015067825ULL, 0x000fe200078e0006ULL, 0x0000000a0f177c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff81b167812ULL, 0x000fe200078ee216ULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x000000001100720cULL, 0x080fe20003f06070ULL, 0x00000014131b7836ULL, 0x040fe20000000000ULL,
0x0000000c1a0e7c11ULL, 0x000fe2000f8848ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006177faeULL, 0x0003e2000d901c4eULL, 0x0000000d18117c11ULL, 0x000fe2000a8f4c19ULL,
0x0000001013197836ULL, 0x040fe20000000000ULL, 0x0000000d1a0f7c11ULL, 0x000fe2000a0f4c0fULL,
0x0000001c13137836ULL, 0x000fe20000000000ULL, 0x000000001b00720cULL, 0x080fe20003f86070ULL,
0x000000081d1a7824ULL, 0x000fe200078e00ffULL, 0x000000001900720cULL, 0x080fe20003f66070ULL,
0x00000008131c7824ULL, 0x000fe200078e00ffULL, 0x000000001d00720cULL, 0x080fe20003fa6070ULL,
0x0000001015047825ULL, 0x000fe200078e0004ULL, 0x000000001300720cULL, 0x000fc40003fc6070ULL,
0x0000001e1b067212ULL, 0x0c2fe200078e3cffULL, 0x000000081b1b7824ULL, 0x000fe200078e00ffULL,
0x0000001e1d077212ULL, 0x080fe200078e3cffULL, 0x0000001015027825ULL, 0x000fe200078e0002ULL,
0x0000001e19007212ULL, 0x080fe400078e3cffULL, 0x0000001e13177212ULL, 0x000fe200078e3cffULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0xfffffff81b187812ULL, 0x000fe400078ee206ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL, 0x0000001015067825ULL, 0x000fe200078e0008ULL,
0xfffffff819007812ULL, 0x000fc400078ee200ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL,
0x0000001015087825ULL, 0x040fe200078e000aULL, 0x0000000a12137c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a14177c11ULL, 0x000fe2000f8e20ffULL, 0x00000010150a7825ULL, 0x040fe200078e000cULL,
0x0000000a18197c11ULL, 0x000fe2000f8e20ffULL, 0x0000000004137faeULL, 0x0003e2000d101c4eULL,
0x0000000a1a1b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010150c7825ULL, 0x040fe200078e000eULL,
0x0000000a1c1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000002177faeULL, 0x0003e4000c901c4eULL,
0x00000010150e7825ULL, 0x000fe200078e0010ULL, 0x0000000a16117c11ULL, 0x000fc4000f8e20ffULL,
0x0000000a00157c11ULL, 0x000fc6000f8e20ffULL, 0x0000000006117faeULL, 0x0003e8000c101c4eULL,
0x0000000008157faeULL, 0x0003e8000d901c4eULL, 0x000000000a197faeULL, 0x0003e8000e101c4eULL,
0x000000000c1b7faeULL, 0x0003e8000e901c4eULL, 0x000000000e1d7faeULL, 0x0003e2000f101c4eULL,
0x0000000400a47947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe2000001161eULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000310137899ULL, 0x000fe4000800063fULL,
0x00000006100a7291ULL, 0x000fe2000f8e683fULL, 0x0000000400027836ULL, 0x040fe40000000000ULL,
0x0000000c00047836ULL, 0x000fe20000000000ULL, 0x000140000a0a7890ULL, 0x000fe2000fffe03fULL,
0x0000000802127824ULL, 0x040fe200078e00ffULL, 0x0000001e02037212ULL, 0x000fe200078e3cffULL,
0x0000000800027836ULL, 0x000fc40000000000ULL, 0x0000001000057836ULL, 0x000fe20000000000ULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x0000000802147824ULL, 0x040fe200078e00ffULL,
0x0000001e02037212ULL, 0x080fe200078e3cffULL, 0x0000000804077824ULL, 0x040fe200078e00ffULL,
0x0000001e04027212ULL, 0x080fe200078e3cffULL, 0x00000013ff137e24ULL, 0x000fe2000f8e00ffULL,
0x0000001e05047212ULL, 0x040fe200078e3cffULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x0000001400037836ULL, 0x000fe20000000000ULL,
0xfffffff807167812ULL, 0x000fc400078ee202ULL, 0xfffffff805187812ULL, 0x000fe200078ee204ULL,
0x0000001800047836ULL, 0x000fe20000000000ULL, 0x0000001e03027212ULL, 0x0c0fe200078e3cffULL,
0x00000008031b7824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee21eULL,
0x00000007ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000001e04037212ULL, 0x0c0fe200078e3cffULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL,
0x0000001c00027836ULL, 0x000fe20000000000ULL, 0x0000000a12177c11ULL, 0x000fe2000f8e20ffULL,
0x00000080050a7824ULL, 0x000fe200078e0200ULL, 0xfffffff8041d7812ULL, 0x000fe200078ee203ULL,
0x0000000802087824ULL, 0x040fe200078e00ffULL, 0x0000001e02077212ULL, 0x000fe200078e3cffULL,
0x000000040a057836ULL, 0x040fe20000000000ULL, 0x0000000b0a037c10ULL, 0x000fe2000ff1e0ffULL,
0x000000080a067836ULL, 0x040fe20000000000ULL, 0xfffffff8081f7812ULL, 0x000fe200078ee207ULL,
0x0000000c0a097836ULL, 0x040fe20000000000ULL, 0x0000000b05057c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000b06077c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100a0b7836ULL, 0x040fe20000000000ULL, 0x0000000c03027c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x0000000c07067c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000000d03037c11ULL, 0x000fe200080f4c04ULL,
0x000000180a0e7836ULL, 0x000fe20000000000ULL, 0x0000000b09097c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000c05047c11ULL, 0x000fe2000f8048ffULL, 0x0000001013027825ULL, 0x000fe200078e0002ULL,
0x0000000d07077c11ULL, 0x000fe400088f4c0cULL, 0x0000000d05057c11ULL, 0x000fe200080f4c08ULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000000c09087c11ULL, 0x000fe2000f8048ffULL,
0x0000001013067825ULL, 0x000fe200078e0006ULL, 0x0000000700007812ULL, 0x000fe400078e481eULL,
0x0000000d09097c11ULL, 0x000fe200080f4c0cULL, 0x000000140a0c7836ULL, 0x040fe20000000000ULL,
0x0ffffff800007812ULL, 0x000fe200078ef81eULL, 0x0000001c0a0a7836ULL, 0x000fe20000000000ULL,
0x0000000b0b0b7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001013047825ULL, 0x000fe200078e0004ULL,
0x0000000b0c0d7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000b0e0f7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001013087825ULL, 0x000fe200078e0008ULL, 0x0000000b0a117c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000a00157c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x0000000c0b0a7c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000000c0d0c7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x0000000c0f0e7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x0000000c11107c11ULL, 0x000fe2000f8648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000b901c4eULL, 0x0000000d0b0b7c11ULL, 0x000fc400080f4c00ULL,
0x0000000d0d0d7c11ULL, 0x000fe200088f4c1aULL, 0x0000000004177faeULL, 0x0005e2000b901c4eULL,
0x0000000d0f0f7c11ULL, 0x000fe200090f4c1cULL, 0x00000010130a7825ULL, 0x000fe200078e000aULL,
0x0000000d11117c11ULL, 0x000fe400098f4c1eULL, 0x0000000a14197c11ULL, 0x000fe2000f8e20ffULL,
0x00000010130c7825ULL, 0x000fe200078e000cULL, 0x0000000a1b1b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a16037c11ULL, 0x002fe2000f8e20ffULL, 0x00000010130e7825ULL, 0x000fe200078e000eULL,
0x0000000a1d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000006197faeULL, 0x0005e2000b901c4eULL,
0x0000000a1f1f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001013107825ULL, 0x000fe200078e0010ULL,
0x0000000a18137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000008037faeULL, 0x0005e8000b901c4eULL,
0x000000000a137faeULL, 0x0005e8000b901c4eULL, 0x000000000c1b7faeULL, 0x0005e8000b901c4eULL,
0x000000000e1d7faeULL, 0x0005e8000b901c4eULL, 0x00000000101f7faeULL, 0x0005e4000b901c4eULL,
0x0000000520007c0cULL, 0x000fe2000bf06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff087424ULL, 0x006fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000007800080947ULL, 0x000fec0003800000ULL, 0x0000000108087899ULL, 0x000fe2000800063fULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x00009000000a7ab9ULL, 0x000fe20000000800ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x0000000a080872a4ULL, 0x000fd8000f8e020aULL,
0x0000440001027983ULL, 0x000ea40000100800ULL, 0x0000010002007824ULL, 0x004fca00078e00ffULL,
0x0000001400007c0cULL, 0x000fda000bf06070ULL, 0x0000007400d00947ULL, 0x000fea0003800000ULL,
0x0000000102027836ULL, 0x000fe20000000000ULL, 0x0000000000457919ULL, 0x000e620000000000ULL,
0x00008400000a7ab9ULL, 0x000fe40000000800ULL, 0x0000000a190b72a4ULL, 0x000fe2000f8e023fULL,
0x0000000502007c0cULL, 0x000fc6000bf06070ULL, 0x000000070b0b7899ULL, 0x000fe2000800063fULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000400d88947ULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x002fe20000011645ULL, 0x0000002000007836ULL, 0x000fe20000000000ULL,
0x00000020070d7891ULL, 0x000fe2000f8e383fULL, 0x0000000745597812ULL, 0x000fe200078ec0ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000000406057836ULL, 0x000fe20000000000ULL,
0x0000001400027c48ULL, 0x000fe2000ffe0000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0a00ULL,
0x00000006100c7291ULL, 0x000fe2000f8e683fULL, 0x0000001406007836ULL, 0x000fe20000000000ULL,
0x0000004505487212ULL, 0x040fe200078e3cffULL, 0x0000000805037824ULL, 0x040fe200078e00ffULL,
0x00000020020f7446ULL, 0x000fe2000380000fULL, 0x00000008000d7824ULL, 0x040fe200078e00ffULL,
0x00000045000a7212ULL, 0x080fe200078e3cffULL, 0x0000000d06667c36ULL, 0x040fe20008000000ULL,
0xfffffff803487812ULL, 0x000fe200078ee248ULL, 0x0000001006027836ULL, 0x040fe20000000000ULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL, 0x0000000d056a7c36ULL, 0x000fe20008000000ULL,
0x0000000b66107c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000c06037836ULL, 0x000fe20000000000ULL,
0x0000004502097212ULL, 0x0c0fe200078e3cffULL, 0x00000008020e7824ULL, 0x000fe200078e00ffULL,
0x0000000b6a0d7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000806047836ULL, 0x000fe20000000000ULL,
0x0000004503127212ULL, 0x0c0fe200078e3cffULL, 0x00000008030b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e097812ULL, 0x000fe200078ee209ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x0000001610367c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffff80b127812ULL, 0x000fe200078ee212ULL, 0x0000000d04657c36ULL, 0x040fe20008000000ULL,
0x000000160d347c11ULL, 0x040fe2000f8448ffULL, 0x00000008040c7824ULL, 0x040fe200078e00ffULL,
0x0000004504137212ULL, 0x080fe200078e3cffULL, 0x0000000d026b7c36ULL, 0x000fe20008000000ULL,
0x0000001710377c11ULL, 0x000fe200088f4c11ULL, 0x00000018060b7836ULL, 0x000fe20000000000ULL,
0x000000170d357c11ULL, 0x000fe200090f4c0eULL, 0x0000000d036c7c36ULL, 0x000fe20008000000ULL,
0x0000000b65247c10ULL, 0x000fe2000ff3e0ffULL, 0x000000080b257824ULL, 0x040fe200078e00ffULL,
0xfffffff80c137812ULL, 0x000fe200078ee213ULL, 0x0000000d00647c36ULL, 0x000fe20008000000ULL,
0x0000000b6b0e7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x000000450b0c7212ULL, 0x040fe200078e3cffULL, 0x0000000d0b6e7c36ULL, 0x000fe20008000000ULL,
0x0000000b6c107c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0xfffffff8250c7812ULL, 0x000fe200078ee20cULL, 0x000150000c137890ULL, 0x000fe2000fffe03fULL,
0x0000001624327c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x000000160e267c11ULL, 0x000fc4000f8648ffULL, 0x0000000b640d7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001610307c11ULL, 0x000fe4000f8448ffULL, 0x0000001724337c11ULL, 0x000fe400088f4c27ULL,
0x000000170e277c11ULL, 0x000fe200098f4c11ULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0x0000001710317c11ULL, 0x000fe400090f4c25ULL, 0x000000160d107c11ULL, 0x000fc4000f8248ffULL,
0x0000004506247212ULL, 0x040fe400078e3cffULL, 0x000000170d117c11ULL, 0x000fe200088f4c0eULL,
0x0000001c060e7836ULL, 0x000fe20000000000ULL, 0x0000000724247812ULL, 0x000fe200078ec0ffULL,
0x00000012590d7c36ULL, 0x000fe20008000000ULL, 0x0000000f0600720cULL, 0x080fe20003f26070ULL,
0x0000000d0e707c36ULL, 0x000fe20008000000ULL, 0x0000000f0500720cULL, 0x000fe20003f46070ULL,
0x000000100d367825ULL, 0x000fe200078e0036ULL, 0x0000000b6e257c10ULL, 0x000fc4000ff9e0ffULL,
0x0000000f0400720cULL, 0x080fe20003f66070ULL, 0x000000100d347825ULL, 0x000fe200078e0034ULL,
0x0ffffff8244b7812ULL, 0x000fe400078ef845ULL, 0x0000001348557c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000001625247c11ULL, 0x000fe2000f8848ffULL,
0x000000100d387825ULL, 0x000fe200078e0032ULL, 0x000000134b567c11ULL, 0x000fe4000f8e20ffULL,
0x0000001313547c11ULL, 0x000fe2000f8e20ffULL, 0x000000080e447824ULL, 0x000fe200078e00ffULL,
0x0000001725257c11ULL, 0x000fe2000a0f4c3aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036567faeULL, 0x0003e2000c901c4eULL, 0x0000000b70337c10ULL, 0x000fe2000ff9e0ffULL,
0x000000100d307825ULL, 0x000fe200078e0030ULL, 0x0000000f0300720cULL, 0x080fe20003f26070ULL,
0x0000000034557faeULL, 0x0003e2000d101c4eULL, 0x0000000f0000720cULL, 0x080fe20003f46070ULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000001633327c11ULL, 0x000fe2000f8c48ffULL,
0x0000000038547faeULL, 0x0003e2000d901c4eULL, 0x0000000f0200720cULL, 0x080fe20003f66070ULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x0000000f0b00720cULL, 0x000fc40003f86070ULL,
0x000000450e3b7212ULL, 0x040fe200078e3cffULL, 0x000000100d107825ULL, 0x000fe200078e0010ULL,
0x0000000f0e00720cULL, 0x000fe40003fa6070ULL, 0x0000001733337c11ULL, 0x000fe2000b0f4c3aULL,
0x000000100d247825ULL, 0x040fe200078e0024ULL, 0xfffffff8440f7812ULL, 0x000fe400078ee23bULL,
0x0000001312537c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d327825ULL, 0x000fe200078e0032ULL,
0x0000001309527c11ULL, 0x000fc4000f8e20ffULL, 0x000000130a517c11ULL, 0x000fe2000f8e20ffULL,
0x0000000030537faeULL, 0x0003e2000c901c4eULL, 0x000000130c4f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000130f4e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000026527faeULL, 0x0003e8000d901c4eULL,
0x0000000010517faeULL, 0x0003e8000d101c4eULL, 0x00000000244f7faeULL, 0x0003e8000e101c4eULL,
0x00000000324e7faeULL, 0x0003e2000e901c4eULL, 0x0000000400a47947ULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x002fe20000011645ULL, 0x00000020070d7891ULL, 0x000fe2000f8e383fULL,
0x0000000745597812ULL, 0x000fe200078ec0ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x00000006100c7291ULL, 0x000fe2000f8e683fULL, 0x0000000806047836ULL, 0x040fe40000000000ULL,
0x0000000406057836ULL, 0x000fe20000000000ULL, 0x000150000c137890ULL, 0x000fe2000fffe03fULL,
0x0000000804007824ULL, 0x040fe200078e00ffULL, 0x0000004504137212ULL, 0x080fe200078e3cffULL,
0x0000000c06037836ULL, 0x040fe20000000000ULL, 0x0000004505487212ULL, 0x0c0fe200078e3cffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0xfffffff800137812ULL, 0x000fe200078ee213ULL,
0x0000001406007836ULL, 0x000fe20000000000ULL, 0x0000004503127212ULL, 0x0c0fe200078e3cffULL,
0x00000008030b7824ULL, 0x000fe200078e00ffULL, 0xfffffff809487812ULL, 0x000fe200078ee248ULL,
0x00000008000d7824ULL, 0x040fe200078e00ffULL, 0x00000045000a7212ULL, 0x080fe200078e3cffULL,
0x0000000d06667c36ULL, 0x040fe20008000000ULL, 0xfffffff80b127812ULL, 0x000fe200078ee212ULL,
0x0000001006027836ULL, 0x040fe20000000000ULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL,
0x00000018060b7836ULL, 0x000fe20000000000ULL, 0x0000000b660d7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008020e7824ULL, 0x040fe200078e00ffULL, 0x0000004502097212ULL, 0x080fe200078e3cffULL,
0x0000000d056a7c36ULL, 0x000fe20008000000ULL, 0x000000450b0c7212ULL, 0x0c0fe200078e3cffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e097812ULL, 0x000fe200078ee209ULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x000000160d347c11ULL, 0x040fe2000f8248ffULL,
0x0000001c060e7836ULL, 0x000fe20000000000ULL, 0x0000000b6a117c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000d04657c36ULL, 0x000fe20008000000ULL, 0xfffffff80f0c7812ULL, 0x000fe200078ee20cULL,
0x000000080e247824ULL, 0x040fe200078e00ffULL, 0x000000170d357c11ULL, 0x000fe200088f4c10ULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x000000450e0f7212ULL, 0x000fe200078e3cffULL,
0x0000000d036c7c36ULL, 0x000fe20008000000ULL, 0x0000000b650d7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000d026b7c36ULL, 0x000fe20008000000ULL, 0x0000001611387c11ULL, 0x000fe2000f8248ffULL,
0x0000000d00647c36ULL, 0x000fe20008000000ULL, 0xfffffff8240f7812ULL, 0x000fe200078ee20fULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x000000160d367c11ULL, 0x000fe2000f8448ffULL,
0x0000000d0b6e7c36ULL, 0x000fe20008000000ULL, 0x0000001711397c11ULL, 0x000fe200088f4c10ULL,
0x0000000d0e707c36ULL, 0x000fe20008000000ULL, 0x0000000b6c107c10ULL, 0x000fc4000ff3e0ffULL,
0x000000170d377c11ULL, 0x000fe400090f4c24ULL, 0x0000000b6b117c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x0000000b64257c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001610327c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x0000001611307c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x0000001710337c11ULL, 0x000fc400088f4c0dULL, 0x0000001625107c11ULL, 0x000fe4000f8248ffULL,
0x00000045060d7212ULL, 0x000fe400078e3cffULL, 0x0000001711317c11ULL, 0x000fe400090f4c24ULL,
0x0000001725117c11ULL, 0x000fe400088f4c26ULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000b6e257c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000b70277c10ULL, 0x000fe4000ff5e0ffULL,
0x0ffffff80d4b7812ULL, 0x000fe200078ef845ULL, 0x00000012590d7c36ULL, 0x000fe20008000000ULL,
0x0000001348557c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x0000001625247c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x0000001627267c11ULL, 0x000fe2000f8448ffULL, 0x000000100d347825ULL, 0x000fe200078e0034ULL,
0x000000134b567c11ULL, 0x000fc4000f8e20ffULL, 0x0000001725257c11ULL, 0x000fe200088f4c3aULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x0000001313547c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034567faeULL, 0x0003e2000b901c4eULL,
0x0000001727277c11ULL, 0x000fe200090f4c44ULL, 0x000000100d367825ULL, 0x000fe200078e0036ULL,
0x0000001312537c11ULL, 0x000fe2000f8e20ffULL, 0x0000000038557faeULL, 0x0003e2000b901c4eULL,
0x0000001309527c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d327825ULL, 0x040fe200078e0032ULL,
0x000000130a517c11ULL, 0x000fe2000f8e20ffULL, 0x0000000036547faeULL, 0x0003e2000b901c4eULL,
0x000000130c4f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d307825ULL, 0x000fe200078e0030ULL,
0x000000130f4e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000032537faeULL, 0x0003e4000b901c4eULL,
0x000000100d107825ULL, 0x000fc400078e0010ULL, 0x0000000030527faeULL, 0x0003e4000b901c4eULL,
0x000000100d247825ULL, 0x040fe400078e0024ULL, 0x0000000010517faeULL, 0x0003e4000b901c4eULL,
0x000000100d267825ULL, 0x000fe400078e0026ULL, 0x00000000244f7faeULL, 0x0003e8000b901c4eULL,
0x00000000264e7faeULL, 0x0003e4000b901c4eULL, 0x00000012ff247e24ULL, 0x002fe2000f8e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff107424ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011645ULL, 0x00000012ff277e24ULL, 0x000fe4000f8e00ffULL,
0x01c60810242479a7ULL, 0x0002a20008500006ULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x0000001045107824ULL, 0x002fca00078e00ffULL, 0x0000007010107812ULL, 0x000fc800078ec0ffULL,
0x0000000611107c10ULL, 0x000fe2000fffe010ULL, 0x01c60825270075a7ULL, 0x004e640008020146ULL,
0x0000012400049947ULL, 0x002fea0003800000ULL, 0x01c0000010257984ULL, 0x000e620000000800ULL,
0x00000001ff247424ULL, 0x000fe200078e00ffULL, 0x0000000000697919ULL, 0x000ea40000000000ULL,
0x01c20000104d7984ULL, 0x0006e20000000800ULL, 0x00000004ff347819ULL, 0x004fe40000011669ULL,
0x000000082500720bULL, 0x002fda0003f3d000ULL, 0x0000000000117806ULL, 0x000fc800008e0100ULL,
0x0000ffff11317812ULL, 0x000fe4000782c0ffULL, 0x0000000859117812ULL, 0x000fe400078ef869ULL,
0x0000000859597812ULL, 0x000fe400078ef869ULL, 0x0000000734307812ULL, 0x000fce00078e7811ULL,
0x0000000000d49947ULL, 0x008fea0003800000ULL, 0x000000082500720bULL, 0x000fe40003f34000ULL,
0x0000002508337209ULL, 0x000fe40007810000ULL, 0x00000002ff267819ULL, 0x000fc60000011669ULL,
0x8000003308247221ULL, 0x100fe40000010000ULL, 0x0000000826277836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b24247820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400008e0100ULL,
0x00000010ff007c0cULL, 0x000fe4000bf25270ULL, 0x0000ffff08087812ULL, 0x000fe200078e3cffULL,
0x0000002400247308ULL, 0x000e660000000800ULL, 0x0000000831ff7212ULL, 0x000fe2000784c0ffULL,
0x000000ffff087224ULL, 0x000fcc00078e0033ULL, 0x01c4003310009388ULL, 0x000fe80000000800ULL,
0x00001f2724277589ULL, 0x002e6400000e0000ULL, 0x8000003325252221ULL, 0x000fe20000010000ULL,
0x0000002407077220ULL, 0x000fe20000410000ULL, 0x00001f2624267589ULL, 0x0004e400000e0000ULL,
0x3fb8aa3b25252820ULL, 0x000fc80000410000ULL, 0x0000002500582308ULL, 0x000f220000000800ULL,
0x00000001ff247807ULL, 0x004fe20001000000ULL, 0x000000272b2b7220ULL, 0x082fe20000410000ULL,
0x000000272a2a7220ULL, 0x080fe20000410000ULL, 0x000000272f2f7220ULL, 0x080fe20000410000ULL,
0x000000272e2e7220ULL, 0x080fe20000410000ULL, 0x0000002723237220ULL, 0x080fe20000410000ULL,
0x0000002722227220ULL, 0x080fe20000410000ULL, 0x000000271f1f7220ULL, 0x080fe20000410000ULL,
0x000000271e1e7220ULL, 0x080fe20000410000ULL, 0x000000271b1b7220ULL, 0x080fe20000410000ULL,
0x000000271a1a7220ULL, 0x080fe20000410000ULL, 0x000000273f3f7220ULL, 0x080fe20000410000ULL,
0x000000273e3e7220ULL, 0x080fe20000410000ULL, 0x0000002743437220ULL, 0x080fe20000410000ULL,
0x0000002742427220ULL, 0x080fe20000410000ULL, 0x0000002717177220ULL, 0x080fe20000410000ULL,
0x0000002716167220ULL, 0x000fe20000410000ULL, 0x0000002629297220ULL, 0x088fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x0000002621217220ULL, 0x080fe20000410000ULL,
0x0000002620207220ULL, 0x080fe20000410000ULL, 0x000000261d1d7220ULL, 0x080fe20000410000ULL,
0x000000261c1c7220ULL, 0x080fe20000410000ULL, 0x0000002619197220ULL, 0x080fe20000410000ULL,
0x0000002618187220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002615157220ULL, 0x080fe20000410000ULL,
0x0000002614147220ULL, 0x000fe20000410000ULL, 0x000000584d4d2220ULL, 0x010fce0000410000ULL,
0x0000000811307824ULL, 0x000fe200078e0230ULL, 0x0000000734627812ULL, 0x000fe200078e7859ULL,
0x00000002345a7836ULL, 0x040fe20000000000ULL, 0x000140000c0c7890ULL, 0x000fe2000fffe03fULL,
0x0000000434267836ULL, 0x000fe20000000000ULL, 0x0000000630257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000859507824ULL, 0x000fe200078e0262ULL, 0x000000075a5c7812ULL, 0x000fe200078e7859ULL,
0x0000000634347836ULL, 0x000fe20000000000ULL, 0x00000007265d7812ULL, 0x000fe200078e7859ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000142501007387ULL, 0x000fe20000100800ULL,
0x0000000859577824ULL, 0x040fe200078e025cULL, 0x0000000734637812ULL, 0x000fe200078e7859ULL,
0x0000000859687824ULL, 0x000fe200078e025dULL, 0x012000002530783bULL, 0x0003e20000000200ULL,
0x00000002ff6f7819ULL, 0x000fe40000011669ULL, 0x0000000c57277c11ULL, 0x000fe2000f8e20ffULL,
0x0000000859677824ULL, 0x000fe200078e0263ULL, 0x00000058ff4c723eULL, 0x000fe200000010ffULL,
0x000000086f6d7836ULL, 0x000fe20000000000ULL, 0x0000991024247816ULL, 0x000fe200000000ffULL,
0x000000002738783bULL, 0x000fe20000004200ULL, 0x0000000c50257c11ULL, 0x002fc4000f8e20ffULL,
0x000054104c4c7816ULL, 0x000fe4000000004cULL, 0x000000ff2400720cULL, 0x000fe20003f25270ULL,
0x0000182501007387ULL, 0x000fe80000100800ULL, 0x000000002544783bULL, 0x0003e80000004200ULL,
0x0000202701007387ULL, 0x000fe20000100800ULL, 0x0000000c68257c11ULL, 0x002fc6000f8e20ffULL,
0x00001f6f4c4a7589ULL, 0x000e6800000e0000ULL, 0x0000302501007387ULL, 0x000fe80000100800ULL,
0x000000002534783bULL, 0x0005e80000004200ULL, 0x00001f6d4c497589ULL, 0x000ee200000e0000ULL,
0x0000000c67257c11ULL, 0x004fca000f8e20ffULL, 0x0000382501007387ULL, 0x000fe80000100800ULL,
0x00004400015b7983ULL, 0x000ea80000100800ULL, 0x000000002524783bULL, 0x000f220000004200ULL,
0x000000075a5a7812ULL, 0x000fe400078e7811ULL, 0x0000008059597811ULL, 0x000fe200078e18ffULL,
0x0000004a30309232ULL, 0x002fc40000200000ULL, 0x0000004a32329232ULL, 0x000fe40000200000ULL,
0x00000008115a7824ULL, 0x000fe400078e025aULL, 0x0000004931319232ULL, 0x088fe40000200000ULL,
0x0000004933339232ULL, 0x000fe40000200000ULL, 0x0000000162627824ULL, 0x100fe200078e0259ULL,
0x000000065a5e7c11ULL, 0x000fe2000f8e20ffULL, 0x000000015c5c7824ULL, 0x000fc400078e0259ULL,
0x000000015d5d7824ULL, 0x100fe400078e0259ULL, 0x0000000163637824ULL, 0x000fe200078e0259ULL,
0x0000003a3018723cULL, 0x000fe20000041818ULL, 0x0000285e01007387ULL, 0x000fea0000100800ULL,
0x00000038303c723cULL, 0x000fe2000004183cULL, 0x0000000c623a7c11ULL, 0x000fca000f8e20ffULL,
0x00000034301c723cULL, 0x000fe2000004181cULL, 0x0000000c5c397c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c5d387c11ULL, 0x000fc6000f8e20ffULL, 0x000000363034723cULL, 0x000fe20000041820ULL,
0x012000005e20783bULL, 0x000e6a0000000200ULL, 0x000000443014723cULL, 0x000fe20000041814ULL,
0x00001c3a01007387ULL, 0x000fec0000100800ULL, 0x0000000c63447c11ULL, 0x000fe2000f8e20ffULL,
0x0000243901007387ULL, 0x000fe20000100800ULL, 0x000000463040723cULL, 0x000fe60000041840ULL,
0x00002c3801007387ULL, 0x000fe60000100800ULL, 0x00000024302c723cULL, 0x010fe2000004182cULL,
0x0000344401007387ULL, 0x000fe80000100800ULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x000000263028723cULL, 0x000fe60000041828ULL, 0x000000003a24783bULL, 0x000f280000004200ULL,
0x000000003930783bULL, 0x000f680000004200ULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x0000004a20209232ULL, 0x002fc40000200000ULL, 0x0000004a22229232ULL, 0x000fe40000200000ULL,
0x0000004921219232ULL, 0x080fe40000200000ULL, 0x0000004923239232ULL, 0x000fe40000200000ULL,
0x000000074d077221ULL, 0x000fca0000010000ULL, 0x00000044202c723cULL, 0x008fec000004182cULL,
0x000000242014723cULL, 0x010fec0000041814ULL, 0x000000262040723cULL, 0x000fec0000041840ULL,
0x00000030203c723cULL, 0x020fec000004183cULL, 0x000000322018723cULL, 0x000fec0000041818ULL,
0x00000038201c723cULL, 0x000fec000004181cULL, 0x0000003a2034723cULL, 0x000fec0000041834ULL,
0x000000462028723cULL, 0x000fe20000041828ULL, 0x000000005b1572caULL, 0x004fda00000e0000ULL,
0x0000004015157891ULL, 0x000fe2000f8e403fULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400488947ULL, 0x000ff40003800000ULL, 0x00000040071a7891ULL, 0x000fe2000f8e383fULL,
0x80000015ff327e24ULL, 0x000fe2000f8e02ffULL, 0x000000151400728cULL, 0x000fe2000bf01070ULL,
0x0000000c4b617c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c135f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a06717c36ULL, 0x000fe20008000000ULL, 0x00000015140d7287ULL, 0x000fe2000c000000ULL,
0x0000001a05727c36ULL, 0x000fe20008000000ULL, 0x0000000c48607c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a02767c36ULL, 0x000fe20008000000ULL, 0x0000000b71227c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001a04737c36ULL, 0x000fe20008000000ULL, 0x0000000b72207c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000dff257e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c125e7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0x0000001622247c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x0000001620267c11ULL, 0x000fe2000f8648ffULL,
0x0000001a00757c36ULL, 0x000fe20008000000ULL, 0x0000002025327446ULL, 0x000fe20003800032ULL,
0x0000001a03747c36ULL, 0x000fe20008000000ULL, 0x0000001722257c11ULL, 0x000fe200090f4c23ULL,
0x0000001a0b787c36ULL, 0x000fe20008000000ULL, 0x0000001720277c11ULL, 0x000fe200098f4c21ULL,
0x0000001a0e777c36ULL, 0x000fe20008000000ULL, 0x0000000b76237c10ULL, 0x000fe2000ff7e0ffULL,
0x000000100d247825ULL, 0x000fe200078e0024ULL, 0x0000000b73317c10ULL, 0x000fc4000ff9e0ffULL,
0x000000320600720cULL, 0x080fe20003f46070ULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x0000001623227c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff447224ULL, 0x000fe200020e06ffULL,
0x0000001631307c11ULL, 0x000fe2000f8848ffULL, 0x000000100d267825ULL, 0x000fe200078e0026ULL,
0x0000001723237c11ULL, 0x000fe400098f4c38ULL, 0x000000320500720cULL, 0x080fe40003f66070ULL,
0x0000001731317c11ULL, 0x000fe2000a0f4c44ULL, 0x000000100d227825ULL, 0x040fe200078e0022ULL,
0x0000000b75137c10ULL, 0x000fe2000ff9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024617faeULL, 0x0003e2000d101c4eULL, 0x000000320400720cULL, 0x000fe20003f46070ULL,
0x000000100d307825ULL, 0x000fe200078e0030ULL, 0x0000000b74217c10ULL, 0x000fc4000ffbe0ffULL,
0x000000320e00720cULL, 0x000fe20003fc6070ULL, 0x000000ffff387224ULL, 0x000fe200020e06ffULL,
0x0000000c095b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff3a7224ULL, 0x000fe200028e06ffULL,
0x0000001621207c11ULL, 0x000fe2000f8a48ffULL, 0x0000000026607faeULL, 0x0005e2000d901c4eULL,
0x0000000c0a5a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000001613247c11ULL, 0x002fe2000f8848ffULL,
0x00000000305f7faeULL, 0x0003e2000d101c4eULL, 0x0000001721217c11ULL, 0x000fc4000a8f4c3aULL,
0x0000001713257c11ULL, 0x000fe4000a0f4c38ULL, 0x0000000b78337c10ULL, 0x000fe2000ff9e0ffULL,
0x000000100d207825ULL, 0x000fe200078e0020ULL, 0x0000000b77137c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001633267c11ULL, 0x004fe2000f8448ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x000000320000720cULL, 0x000fe20003f86070ULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x0000001613307c11ULL, 0x002fe2000f8648ffULL, 0x000000100d247825ULL, 0x000fe200078e0024ULL,
0x0000001733277c11ULL, 0x000fc400090f4c3aULL, 0x0000001713317c11ULL, 0x000fe400098f4c38ULL,
0x000000320300720cULL, 0x080fe20003f46070ULL, 0x000000100d267825ULL, 0x000fe200078e0026ULL,
0x000000320200720cULL, 0x080fe40003f66070ULL, 0x000000320b00720cULL, 0x000fe20003fa6070ULL,
0x000000100d307825ULL, 0x000fe200078e0030ULL, 0x0000000c0c597c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c0f0f7c11ULL, 0x000fca000f8e20ffULL, 0x00000000205e7faeULL, 0x0003e8000d101c4eULL,
0x00000000225b7faeULL, 0x0003e8000d901c4eULL, 0x00000000245a7faeULL, 0x0003e8000e101c4eULL,
0x0000000026597faeULL, 0x0003e8000e901c4eULL, 0x00000000300f7faeULL, 0x0003e2000f101c4eULL,
0x0000000400107947ULL, 0x000fea0003800000ULL, 0x00000040070d7891ULL, 0x000fe2000f8e383fULL,
0x0000000c4b617c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c48607c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c135f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000d06717c36ULL, 0x000fe20008000000ULL,
0x0000000c125e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000d05727c36ULL, 0x000fe20008000000ULL,
0x0000000c095b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000d04737c36ULL, 0x000fe20008000000ULL,
0x0000000b71207c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000d03747c36ULL, 0x000fe20008000000ULL,
0x0000000b72227c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000d02767c36ULL, 0x000fe20008000000ULL,
0x0000000c0a5a7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x0000001620267c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff237224ULL, 0x000fe200018e06ffULL,
0x0000001622327c11ULL, 0x000fe2000f8648ffULL, 0x0000000d00757c36ULL, 0x000fe20008000000ULL,
0x0000001720277c11ULL, 0x000fe200090f4c21ULL, 0x0000000d0b787c36ULL, 0x000fe20008000000ULL,
0x0000001722337c11ULL, 0x000fe200098f4c23ULL, 0x0000000d0e777c36ULL, 0x000fe20008000000ULL,
0x0000000b73217c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d267825ULL, 0x000fe200078e0026ULL,
0x0000000b74237c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000b76257c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x0000001621307c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x0000001623207c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000001721317c11ULL, 0x000fe200090f4c24ULL,
0x000000100d327825ULL, 0x000fe200078e0032ULL, 0x0000001723217c11ULL, 0x000fe200098f4c38ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026617faeULL, 0x000fe2000b901c4eULL,
0x0000001625227c11ULL, 0x000fc4000f8848ffULL, 0x0000000b75387c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000032607faeULL, 0x0003e2000b901c4eULL, 0x0000001725237c11ULL, 0x000fe2000a0f4c3aULL,
0x000000100d207825ULL, 0x000fe200078e0020ULL, 0x0000000b77397c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000c0c597c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x0000001638247c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x0000000c0f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d227825ULL, 0x000fe200078e0022ULL,
0x0000001738257c11ULL, 0x000fc400090f4c25ULL, 0x0000000b78387c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100d327825ULL, 0x002fe200078e0030ULL, 0x0000001639307c11ULL, 0x000fc6000f8648ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x0000001638267c11ULL, 0x040fe2000f8448ffULL,
0x000000100d247825ULL, 0x000fe200078e0024ULL, 0x0000001739317c11ULL, 0x000fe200098f4c3aULL,
0x00000000325f7faeULL, 0x0003e2000b901c4eULL, 0x0000001738277c11ULL, 0x000fe200090f4c13ULL,
0x000000100d307825ULL, 0x040fe400078e0030ULL, 0x00000000205e7faeULL, 0x0003e4000b901c4eULL,
0x000000100d267825ULL, 0x000fc400078e0026ULL, 0x00000000225b7faeULL, 0x0003e8000b901c4eULL,
0x00000000245a7faeULL, 0x0003e8000b901c4eULL, 0x0000000026597faeULL, 0x0003e8000b901c4eULL,
0x00000000300f7faeULL, 0x0003e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004690a7811ULL, 0x000fe200078fe0ffULL, 0x000000141500728cULL, 0x000fe2000bf06070ULL,
0x0000001368127c11ULL, 0x000fe4000f8e20ffULL, 0x000000070a0a7812ULL, 0x000fe400078e7811ULL,
0x00000013670c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000135d7a7c11ULL, 0x000fe2000f8e20ffULL,
0x00000008110a7824ULL, 0x000fe200078e020aULL, 0x00000013627c7c11ULL, 0x000fc4000f8e20ffULL,
0x000000135c7b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000060a097c11ULL, 0x000fe4000f8e20ffULL,
0x00000013570a7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001ff577424ULL, 0x000fe200078e00ffULL,
0x0000001363797c11ULL, 0x000fe2000f8e20ffULL, 0x0000100901007387ULL, 0x000fe20000100800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x012000000920783bULL, 0x0023e80000000200ULL,
0x000000000a30783bULL, 0x000fe20000004200ULL, 0x0000001350097c11ULL, 0x002fc6000f8e20ffULL,
0x000000001244783bULL, 0x000fe80000004200ULL, 0x000000000924783bULL, 0x000fe80000004200ULL,
0x00000c0901007387ULL, 0x000fe80000100800ULL, 0x00001f6f4c097589ULL, 0x000e6800000e0000ULL,
0x00001f6d4c4c7589ULL, 0x000ea800000e0000ULL, 0x000000000c38783bULL, 0x000ee80000004200ULL,
0x0000080a01007387ULL, 0x0009e80000100800ULL, 0x0000041201007387ULL, 0x000fe80000100800ULL,
0x0000000c01007387ULL, 0x000fe20000100800ULL, 0x00000006690a7811ULL, 0x010fe200078fe0ffULL,
0x0000000920209232ULL, 0x002fc60000200000ULL, 0x000000070a0a7812ULL, 0x000fe200078e7811ULL,
0x0000000922229232ULL, 0x000fe40000200000ULL, 0x0000004c21219232ULL, 0x084fe40000200000ULL,
0x00000008110a7824ULL, 0x000fe400078e020aULL, 0x0000004c23239232ULL, 0x000fc60000200000ULL,
0x000000060a7d7c11ULL, 0x000fc8000f8e20ffULL, 0x000000242014723cULL, 0x000fec0000041814ULL,
0x000000262040723cULL, 0x000fe20000041840ULL, 0x012000007d24783bULL, 0x000e6a0000000200ULL,
0x00000030203c723cULL, 0x000fec000004183cULL, 0x000000322018723cULL, 0x000fe20000041818ULL,
0x000000007930783bULL, 0x000eaa0000004200ULL, 0x00000044201c723cULL, 0x000fec000004181cULL,
0x000000462034723cULL, 0x000fe20000041834ULL, 0x000000007c44783bULL, 0x000f2a0000004200ULL,
0x00000038202c723cULL, 0x008fec000004182cULL, 0x0000003a2028723cULL, 0x000fe20000041828ULL,
0x000000007a20783bULL, 0x000ee80000004200ULL, 0x000000007b38783bULL, 0x000f620000004200ULL,
0x0000000924249232ULL, 0x082fe20000200000ULL, 0x01c68857ffff79a7ULL, 0x0003e20008500006ULL,
0x0000000926269232ULL, 0x000fc40000200000ULL, 0x0000004c25259232ULL, 0x080fe40000200000ULL,
0x0000004c27279232ULL, 0x000fe20000200000ULL, 0x000000000000781cULL, 0x000fcc0003f2f008ULL,
0x00000030242c723cULL, 0x004fec000004182cULL, 0x000000322428723cULL, 0x000fec0000041828ULL,
0x000000442414723cULL, 0x010fec0000041814ULL, 0x000000462440723cULL, 0x000fec0000041840ULL,
0x00000020241c723cULL, 0x008fec000004181cULL, 0x00000038243c723cULL, 0x020fec000004183cULL,
0x0000003a2418723cULL, 0x000fec0000041818ULL, 0x000000222420723cULL, 0x000fe20000041834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000005000401947ULL, 0x002fde0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000004002c8947ULL, 0x000fea0003800000ULL,
0x0000006007137891ULL, 0x000fe4000f8e383fULL, 0x00000020150c7890ULL, 0x000fc8000fffe03fULL,
0x0000001306507c36ULL, 0x000fe20008000000ULL, 0x0000000c1400728cULL, 0x000fe2000bf01070ULL,
0x00000013054d7c36ULL, 0x000fe40008000000ULL, 0x8000000cff117e24ULL, 0x000fe2000f8e02ffULL,
0x0000000b50097c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000c140d7287ULL, 0x000fe2000c000000ULL,
0x0000000b4d0c7c10ULL, 0x000fe2000ff5e0ffULL, 0x00000013044c7c36ULL, 0x000fe40008000000ULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000001609267c11ULL, 0x000fe2000f8248ffULL,
0x0000000dff127e24ULL, 0x000fe2000f8e00ffULL, 0x000000160c247c11ULL, 0x000fe2000f8648ffULL,
0x00000013034b7c36ULL, 0x000fe20008000000ULL, 0x0000001709277c11ULL, 0x000fe200088f4c0aULL,
0x00000013024a7c36ULL, 0x000fe20008000000ULL, 0x0000002011097446ULL, 0x000fe20003800012ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000000b4c0a7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x000000090600720cULL, 0x000fc40003f46070ULL,
0x000000170c257c11ULL, 0x000fe200098f4c11ULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x000000090500720cULL, 0x080fe20003f26070ULL, 0x0000001300497c36ULL, 0x000fe20008000000ULL,
0x000000160a127c11ULL, 0x040fe2000f8648ffULL, 0x000000100d247825ULL, 0x000fe200078e0024ULL,
0x0000000b4b0c7c10ULL, 0x000fe4000ff9e0ffULL, 0x000000170a137c11ULL, 0x000fe200098f4c11ULL,
0x000000130b487c36ULL, 0x000fe20008000000ULL, 0x000000090400720cULL, 0x080fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026567faeULL, 0x000fe2000d101c4eULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x0000000b4a0a7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x0000000024557faeULL, 0x0003e2000c901c4eULL,
0x000000090300720cULL, 0x000fce0003f26070ULL, 0x0000000012547faeULL, 0x0005e2000d901c4eULL,
0x000000090000720cULL, 0x000fe40003f66070ULL, 0x000000160c247c11ULL, 0x002fc8000f8448ffULL,
0x000000170c257c11ULL, 0x000fe200090f4c11ULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x000000090200720cULL, 0x000fe40003f86070ULL, 0x000000160a127c11ULL, 0x004fe2000f8448ffULL,
0x000000100d247825ULL, 0x000fc600078e0024ULL, 0x000000170a137c11ULL, 0x000fe400090f4c11ULL,
0x0000000b490a7c10ULL, 0x000fe2000ffbe0ffULL, 0x0000000024537faeULL, 0x000fe2000c901c4eULL,
0x000000090b00720cULL, 0x080fe20003f46070ULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x000000090e00720cULL, 0x000fe40003f26070ULL, 0x0000000b48097c10ULL, 0x000fe2000ffde0ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x000000160a307c11ULL, 0x000fe2000f8a48ffULL,
0x0000000012527faeULL, 0x0003e2000e101c4eULL, 0x0000001609267c11ULL, 0x000fc4000f8848ffULL,
0x000000170a317c11ULL, 0x000fe2000a8f4c11ULL, 0x000000ffff0a7224ULL, 0x000fe400030e06ffULL,
0x000000100d307825ULL, 0x000fc600078e0030ULL, 0x0000001709277c11ULL, 0x000fe2000a0f4c0aULL,
0x000000130e137c36ULL, 0x002fe20008000000ULL, 0x0000000030517faeULL, 0x0003e2000d901c4eULL,
0x000000100d267825ULL, 0x000fc600078e0026ULL, 0x0000000b13097c10ULL, 0x000fe4000ff9e0ffULL,
0x00000000264f7faeULL, 0x0003e6000d101c4eULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000001609247c11ULL, 0x000fc8000f8848ffULL, 0x0000001709257c11ULL, 0x000fc6000a0f4c0aULL,
0x000000100d247825ULL, 0x000fca00078e0024ULL, 0x00000000244e7faeULL, 0x0003e2000c901c4eULL,
0x0000000000f07947ULL, 0x000fea0003800000ULL, 0x00000060070c7891ULL, 0x000fcc000f8e383fULL,
0x0000000c06507c36ULL, 0x000fe40008000000ULL, 0x0000000c054d7c36ULL, 0x000fe40008000000ULL,
0x0000000c044c7c36ULL, 0x000fe20008000000ULL, 0x0000000b50097c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000c034b7c36ULL, 0x000fe20008000000ULL, 0x0000000b4d0c7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000c024a7c36ULL, 0x000fe40008000000ULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000001609247c11ULL, 0x000fe2000f8248ffULL, 0x0000000c00497c36ULL, 0x000fc40008000000ULL,
0x0000000c0b487c36ULL, 0x000fe20008000000ULL, 0x0000001709257c11ULL, 0x000fe200088f4c0aULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x000000160c127c11ULL, 0x000fe2000f8248ffULL,
0x000000100d247825ULL, 0x000fc600078e0024ULL, 0x000000170c137c11ULL, 0x000fe400088f4c09ULL,
0x0000000b4c097c10ULL, 0x000fe2000ff3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024567faeULL, 0x0003e2000b901c4eULL, 0x0000000b4b0c7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100d127825ULL, 0x000fc800078e0012ULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000012557faeULL, 0x0005e2000b901c4eULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x000000160c267c11ULL, 0x040fe4000f8448ffULL, 0x0000001609247c11ULL, 0x042fe4000f8248ffULL,
0x000000170c277c11ULL, 0x000fe400090f4c11ULL, 0x0000001709257c11ULL, 0x000fe400088f4c0aULL,
0x0000000b4a097c10ULL, 0x000fe2000ff3e0ffULL, 0x000000100d267825ULL, 0x000fe200078e0026ULL,
0x0000000b480c7c10ULL, 0x000fc6000ff5e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000001609127c11ULL, 0x004fe2000f8248ffULL, 0x000000100d247825ULL, 0x000fc600078e0024ULL,
0x0000001709137c11ULL, 0x000fe200088f4c0aULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x0000000b49097c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000024547faeULL, 0x000fe2000b901c4eULL,
0x000000100d127825ULL, 0x000fc600078e0012ULL, 0x0000000026537faeULL, 0x0003e2000b901c4eULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000001609307c11ULL, 0x040fe4000f8248ffULL,
0x0000000012527faeULL, 0x0005e4000b901c4eULL, 0x0000001709317c11ULL, 0x000fe400088f4c0aULL,
0x000000160c267c11ULL, 0x002fe2000f8248ffULL, 0x000000100d307825ULL, 0x000fc600078e0030ULL,
0x000000170c277c11ULL, 0x000fe200088f4c11ULL, 0x0000000c0e137c36ULL, 0x004fe20008000000ULL,
0x0000000030517faeULL, 0x0005e2000b901c4eULL, 0x000000100d267825ULL, 0x000fc600078e0026ULL,
0x0000000b13097c10ULL, 0x000fe4000ff3e0ffULL, 0x00000000264f7faeULL, 0x0005e6000b901c4eULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000001609247c11ULL, 0x000fc8000f8248ffULL,
0x0000001709257c11ULL, 0x000fc600088f4c0aULL, 0x000000100d247825ULL, 0x000fca00078e0024ULL,
0x00000000244e7faeULL, 0x0005e4000b901c4eULL, 0x00000001090c7892ULL, 0x000fe2000f8ec03fULL,
0x00000012ff097e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff110b7891ULL, 0x000fe4000f8e083fULL,
0x000000010c00788cULL, 0x000fe2000bf05070ULL, 0xffffffff00197882ULL, 0x000fc60000000000ULL,
0x000000010b0c7887ULL, 0x000fc8000c000000ULL, 0x0000000c09137290ULL, 0x000fc8000fffe03fULL,
0x000000041300728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f2f008ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000c08097290ULL, 0x000fc6000fffe009ULL,
0x00008c00000c7ab9ULL, 0x000fe40000000a00ULL, 0x00000004090c78a5ULL, 0x000fcc000f8e000cULL,
0x0000000cff247e24ULL, 0x006fe4000f8e00ffULL, 0x0000000dff257e24ULL, 0x000fca000f8e00ffULL,
0x0000000e24247981ULL, 0x000ea4000c1e1900ULL, 0x00000000241972caULL, 0x004fde00000e0000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c62857092479a7ULL, 0x0062a40008500006ULL,
0x00000012ff097e24ULL, 0x002fc8000f8e00ffULL, 0x01c62825090075a7ULL, 0x004e640008020146ULL,
0x0000010000dc9947ULL, 0x002fea0003800000ULL, 0x01c0800010117984ULL, 0x000e620000000800ULL,
0x00000000000a7919ULL, 0x000ea40000000000ULL, 0x00000002ff397819ULL, 0x004fe2000001160aULL,
0x00000001ff0a7424ULL, 0x000fe200078e00ffULL, 0x000000081100720bULL, 0x002fc60003f3d000ULL,
0x0000000839387836ULL, 0x000fd40000000000ULL, 0x0000000000097806ULL, 0x000fc800008e0100ULL,
0x0000ffff090c7812ULL, 0x000fe4000782c0ffULL, 0x01c2800010097984ULL, 0x0002b60000000800ULL,
0x0000000000d09947ULL, 0x002fea0003800000ULL, 0x000000081100720bULL, 0x000fe20003f34000ULL,
0x000000011000788cULL, 0x000fe2000bf05270ULL, 0x0000001108257209ULL, 0x000fca0007810000ULL,
0x8000002508087221ULL, 0x000fe20000010000ULL, 0x000000000000781cULL, 0x000fc60003f4f008ULL,
0x3fb8aa3b080a7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fc800008e0100ULL,
0x0000000a000a7308ULL, 0x000e620000000800ULL, 0x0000ffff08277812ULL, 0x000fc600078e3cffULL,
0x01c480251000a388ULL, 0x000fe20000000800ULL, 0x000000270cff7212ULL, 0x000fc6000782c0ffULL,
0x00001f390a087589ULL, 0x002e6200000e0000ULL, 0x0000000a07077220ULL, 0x000fd20000410000ULL,
0x8000002511111221ULL, 0x000fe20000010000ULL, 0x00001f380a0c7589ULL, 0x00072600000e0000ULL,
0x3fb8aa3b11111820ULL, 0x000fc80000410000ULL, 0x0000001100581308ULL, 0x000f620000000800ULL,
0x00000001ff0a7807ULL, 0x008fe20000800000ULL, 0x0000000814147220ULL, 0x082fe20000410000ULL,
0x0000000815157220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x000000081c1c7220ULL, 0x080fe20000410000ULL,
0x000000081d1d7220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x000fe20000410000ULL, 0x0000000c16167220ULL, 0x090fe20000410000ULL,
0x0000000c17177220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e0025ULL,
0x0000000958091220ULL, 0x024fce0000410000ULL, 0x0000140001127983ULL, 0x000ee20000100800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000180001117983ULL, 0x000f280000100800ULL,
0x0000200001447983ULL, 0x000f680000100800ULL, 0x00003000013b7983ULL, 0x004ea80000100800ULL,
0x0000380001377983ULL, 0x000ea80000100800ULL, 0x0000280001367983ULL, 0x000ea80000100800ULL,
0x00001c0001357983ULL, 0x000ea80000100800ULL, 0x0000240001347983ULL, 0x000ea20000100800ULL,
0x000099100a0a7816ULL, 0x000fc400000000ffULL, 0x00000058ff0c723eULL, 0x000fe200000010ffULL,
0x00002c00013a7983ULL, 0x000ea20000100800ULL, 0x000000ff0a00720cULL, 0x000fe40003f25270ULL,
0x000054100c0a7816ULL, 0x000fca000000000cULL, 0x00001f390a0c7589ULL, 0x000fe800000e0000ULL,
0x012800001224783bULL, 0x0082e80000000200ULL, 0x000000001130783bULL, 0x010fe80000004200ULL,
0x0000340001127983ULL, 0x002f280000100800ULL, 0x00001f380a117589ULL, 0x000e6200000e0000ULL,
0x0000000c24249232ULL, 0x008fc40000200000ULL, 0x0000000c26269232ULL, 0x000fe40000200000ULL,
0x0000001125259232ULL, 0x082fe40000200000ULL, 0x0000001127279232ULL, 0x000fce0000200000ULL,
0x000000302414723cULL, 0x000fec0000041814ULL, 0x000000322440723cULL, 0x000fe20000041840ULL,
0x000000004430783bULL, 0x020e6a0000004200ULL, 0x00000030243c723cULL, 0x002fec000004183cULL,
0x000000322418723cULL, 0x000fe20000041818ULL, 0x000000003b30783bULL, 0x004e6a0000004200ULL,
0x00000030241c723cULL, 0x002fec000004181cULL, 0x000000322420723cULL, 0x000fe20000041820ULL,
0x000000003730783bULL, 0x000e6a0000004200ULL, 0x00000030242c723cULL, 0x002fec000004182cULL,
0x000000322428723cULL, 0x000fe20000041828ULL, 0x012800003624783bULL, 0x000e680000000200ULL,
0x000000003530783bULL, 0x000ea80000004200ULL, 0x000000003434783bULL, 0x000ee20000004200ULL,
0x0000000c24249232ULL, 0x002fc40000200000ULL, 0x0000000c26269232ULL, 0x000fe40000200000ULL,
0x0000001125259232ULL, 0x080fe40000200000ULL, 0x0000001127279232ULL, 0x000fce0000200000ULL,
0x000000302414723cULL, 0x004fec0000041814ULL, 0x000000322440723cULL, 0x000fe20000041840ULL,
0x000000003a30783bULL, 0x000e6a0000004200ULL, 0x00000034243c723cULL, 0x008fec000004183cULL,
0x000000362418723cULL, 0x000fe20000041818ULL, 0x0000000a190972a4ULL, 0x000fe2000f8e023fULL,
0x000000001234783bULL, 0x010ea80000004200ULL, 0x00000030241c723cULL, 0x002fe2000004181cULL,
0x00000007090c7899ULL, 0x000fc6000800063fULL, 0x0000001300097c82ULL, 0x000fe40008000000ULL,
0x000000322420723cULL, 0x000fe20000041820ULL, 0x0000000709077221ULL, 0x000fca0000010000ULL,
0x00000034242c723cULL, 0x004fec000004182cULL, 0x000000362424723cULL, 0x000fe20000041828ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x00000004002c8947ULL, 0x000fde0003800000ULL, 0x00000040150d7890ULL, 0x000fe2000fffe03fULL,
0x00000007ff097e24ULL, 0x000fc6000f8e00ffULL, 0x0000000d1400728cULL, 0x000fe2000bf01070ULL,
0x0000008009097824ULL, 0x000fe400078e0206ULL, 0x8000000dff0c7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000d141a7287ULL, 0x000fe2000c000000ULL, 0x00000004096f7836ULL, 0x040fe20000000000ULL,
0x0000000c09117c10ULL, 0x000fe2000ff5e0ffULL, 0x00000008096d7836ULL, 0x040fe40000000000ULL,
0x0000000c09697836ULL, 0x000fe20000000000ULL, 0x0000001611287c11ULL, 0x000fe2000f8648ffULL,
0x0000001aff297e24ULL, 0x000fc4000f8e00ffULL, 0x000000ffff127224ULL, 0x000fe400010e06ffULL,
0x0000001009687836ULL, 0x040fe20000000000ULL, 0x000000200c0c7446ULL, 0x000fe20003800029ULL,
0x0000001409677836ULL, 0x000fe20000000000ULL, 0x0000001711297c11ULL, 0x000fe200098f4c12ULL,
0x0000001809637836ULL, 0x040fe20000000000ULL, 0x0000000c0600720cULL, 0x000fe20003f46070ULL,
0x0000001c09627836ULL, 0x000fe40000000000ULL, 0x000000100d287825ULL, 0x000fd400078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028617faeULL, 0x0003e2000d101c4eULL,
0x0000000c6f117c10ULL, 0x000fca000ff5e0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00000016112a7c11ULL, 0x000fc8000f8448ffULL, 0x00000017112b7c11ULL, 0x000fe400090f4c12ULL,
0x0000000c6d117c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000c0500720cULL, 0x000fe20003f46070ULL,
0x000000100d2a7825ULL, 0x000fc800078e002aULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x0000001611287c11ULL, 0x002fc8000f8648ffULL, 0x0000001711297c11ULL, 0x000fe400098f4c12ULL,
0x0000000c0400720cULL, 0x000fe20003f66070ULL, 0x000000002a607faeULL, 0x0003e2000d101c4eULL,
0x0000000c69117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d287825ULL, 0x000fc800078e0028ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x00000016112a7c11ULL, 0x002fca000f8448ffULL,
0x00000000285f7faeULL, 0x0003e2000d901c4eULL, 0x00000017112b7c11ULL, 0x000fe400090f4c12ULL,
0x0000000c68117c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000c0300720cULL, 0x000fe20003f46070ULL,
0x000000100d2a7825ULL, 0x000fc800078e002aULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x0000001611287c11ULL, 0x002fc8000f8648ffULL, 0x0000001711297c11ULL, 0x000fe400098f4c12ULL,
0x0000000c0200720cULL, 0x000fe20003f66070ULL, 0x000000002a5e7faeULL, 0x000fe2000d101c4eULL,
0x0000000c67117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d287825ULL, 0x000fc800078e0028ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000000c0000720cULL, 0x000fca0003f46070ULL,
0x00000000285b7faeULL, 0x0005e4000d901c4eULL, 0x0000001611287c11ULL, 0x004fc8000f8648ffULL,
0x0000001711297c11ULL, 0x000fc600098f4c12ULL, 0x000000100d287825ULL, 0x000fca00078e0028ULL,
0x00000000285a7faeULL, 0x0005e2000d101c4eULL, 0x0000000c63117c10ULL, 0x000fca000ff5e0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x0000000c0b00720cULL, 0x000fe40003f46070ULL,
0x0000001611287c11ULL, 0x004fc8000f8648ffULL, 0x0000001711297c11ULL, 0x000fc600098f4c12ULL,
0x000000100d287825ULL, 0x000fca00078e0028ULL, 0x0000000028597faeULL, 0x0005e2000d101c4eULL,
0x0000000c0e00720cULL, 0x000fe40003f46070ULL, 0x0000000c620c7c10ULL, 0x000fca000ff7e0ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x000000160c287c11ULL, 0x004fc8000f8648ffULL,
0x000000170c297c11ULL, 0x000fc600098f4c11ULL, 0x000000100d287825ULL, 0x000fca00078e0028ULL,
0x00000000280f7faeULL, 0x0003e2000d101c4eULL, 0x0000000000f07947ULL, 0x000fea0003800000ULL,
0x00000007ff097e24ULL, 0x000fc8000f8e00ffULL, 0x0000008009097824ULL, 0x000fc800078e0206ULL,
0x00000004096f7836ULL, 0x040fe20000000000ULL, 0x0000000c090c7c10ULL, 0x000fe2000ff5e0ffULL,
0x00000008096d7836ULL, 0x040fe40000000000ULL, 0x0000000c09697836ULL, 0x040fe40000000000ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000160c2a7c11ULL, 0x040fe2000f8448ffULL,
0x0000001009687836ULL, 0x040fe40000000000ULL, 0x0000001409677836ULL, 0x040fe20000000000ULL,
0x000000170c2b7c11ULL, 0x000fe200090f4c11ULL, 0x0000001809637836ULL, 0x040fe20000000000ULL,
0x0000000c6f0c7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001c09627836ULL, 0x000fc40000000000ULL,
0x000000100d2a7825ULL, 0x000fc800078e002aULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x000000160c287c11ULL, 0x040fe2000f8448ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a617faeULL, 0x0003e6000b901c4eULL, 0x000000170c297c11ULL, 0x000fe400090f4c11ULL,
0x0000000c6d0c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d287825ULL, 0x000fc800078e0028ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000160c2a7c11ULL, 0x042fe2000f8448ffULL,
0x0000000028607faeULL, 0x0003e6000b901c4eULL, 0x000000170c2b7c11ULL, 0x000fe400090f4c11ULL,
0x0000000c690c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d2a7825ULL, 0x000fc800078e002aULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000160c287c11ULL, 0x042fe2000f8448ffULL,
0x000000002a5f7faeULL, 0x0003e6000b901c4eULL, 0x000000170c297c11ULL, 0x000fe400090f4c11ULL,
0x0000000c680c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d287825ULL, 0x000fc800078e0028ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000160c2a7c11ULL, 0x042fe2000f8448ffULL,
0x00000000285e7faeULL, 0x0003e6000b901c4eULL, 0x000000170c2b7c11ULL, 0x000fe400090f4c11ULL,
0x0000000c670c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d2a7825ULL, 0x000fc800078e002aULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000160c287c11ULL, 0x042fe2000f8448ffULL,
0x000000002a5b7faeULL, 0x000fe6000b901c4eULL, 0x000000170c297c11ULL, 0x000fe400090f4c11ULL,
0x0000000c630c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d287825ULL, 0x000fc800078e0028ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x00000000285a7faeULL, 0x0005e4000b901c4eULL,
0x000000160c287c11ULL, 0x004fc8000f8448ffULL, 0x000000170c297c11ULL, 0x000fe400090f4c11ULL,
0x0000000c620c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d287825ULL, 0x000fc800078e0028ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000000028597faeULL, 0x0005e4000b901c4eULL,
0x000000160c287c11ULL, 0x004fc8000f8448ffULL, 0x000000170c297c11ULL, 0x000fc600090f4c11ULL,
0x000000100d287825ULL, 0x000fca00078e0028ULL, 0x00000000280f7faeULL, 0x0003e4000b901c4eULL,
0x0000100001287983ULL, 0x002ea80000100800ULL, 0x00000c00010c7983ULL, 0x000ee80000100800ULL,
0x0000080001347983ULL, 0x000f280000100800ULL, 0x0000040001127983ULL, 0x000f680000100800ULL,
0x0000000001117983ULL, 0x000f220000100800ULL, 0x00000040150d7890ULL, 0x000fc6000fffe03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000140d00728cULL, 0x000fe2000bf06070ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x012800002828783bULL, 0x004fe80000000200ULL,
0x000000000c30783bULL, 0x008fe80000004200ULL, 0x00001f390a0c7589ULL, 0x000e6800000e0000ULL,
0x00001f380a0a7589ULL, 0x000ea200000e0000ULL, 0x0000000c28289232ULL, 0x002fc40000200000ULL,
0x0000000c2a2a9232ULL, 0x000fe40000200000ULL, 0x0000000a29299232ULL, 0x084fe40000200000ULL,
0x0000000a2b2b9232ULL, 0x000fce0000200000ULL, 0x000000302814723cULL, 0x000fec0000041814ULL,
0x000000322840723cULL, 0x000fe20000041840ULL, 0x000000003430783bULL, 0x010e6a0000004200ULL,
0x00000030283c723cULL, 0x002fec000004183cULL, 0x000000322818723cULL, 0x000fe20000041818ULL,
0x000000001230783bULL, 0x0202a40000004200ULL, 0x00000001ff127424ULL, 0x002fc600078e00ffULL,
0x00000030281c723cULL, 0x004fec000004181cULL, 0x000000322820723cULL, 0x000fe20000041820ULL,
0x000000001130783bULL, 0x000e6a0000004200ULL, 0x00000030282c723cULL, 0x002fec000004182cULL,
0x000000322824723cULL, 0x000fe20000041824ULL, 0x012800007d28783bULL, 0x000e680000000200ULL,
0x000000007c30783bULL, 0x000ea40000004200ULL, 0x0000000c28289232ULL, 0x002fc40000200000ULL,
0x0000000c2a2a9232ULL, 0x000fe40000200000ULL, 0x0000000a29299232ULL, 0x080fe40000200000ULL,
0x0000000a2b2b9232ULL, 0x000fe20000200000ULL, 0x000000000000781cULL, 0x000fcc0003f2f008ULL,
0x000000302814723cULL, 0x004fec0000041814ULL, 0x000000322840723cULL, 0x000fe20000041840ULL,
0x000000007b30783bULL, 0x000e6a0000004200ULL, 0x00000030283c723cULL, 0x002fec000004183cULL,
0x000000322818723cULL, 0x000fe20000041818ULL, 0x000000007a30783bULL, 0x000e6a0000004200ULL,
0x00000030281c723cULL, 0x002fec000004181cULL, 0x000000322820723cULL, 0x000fe20000041820ULL,
0x000000007930783bULL, 0x000e620000004200ULL, 0x01c69012ffff79a7ULL, 0x0005e80008500006ULL,
0x00000030282c723cULL, 0x002fec000004182cULL, 0x000000322828723cULL, 0x000fe20000041824ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000003400001947ULL, 0x004fde0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400088947ULL, 0x000fea0003800000ULL,
0x00000060150d7890ULL, 0x000fe2000fffe03fULL, 0x0000000c66667c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000c64647c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000d1400728cULL, 0x000fe2000bf01070ULL,
0x0000001666247c11ULL, 0x000fe2000f8448ffULL, 0x8000000dff0a7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000c6e6e7c10ULL, 0x000fe2000ffbe0ffULL, 0x0000000d141a7287ULL, 0x000fcc000c000000ULL,
0x0000001aff117e24ULL, 0x000fca000f8e00ffULL, 0x000000200a0a7446ULL, 0x000fe20003800011ULL,
0x000000ffff117224ULL, 0x000fc600008e06ffULL, 0x0000000a0600720cULL, 0x080fe40003f26070ULL,
0x0000001766257c11ULL, 0x000fe400090f4c11ULL, 0x0000000c65657c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000a0000720cULL, 0x000fe20003f66070ULL, 0x000000100d247825ULL, 0x000fc800078e0024ULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000001665267c11ULL, 0x040fe2000f8448ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024567faeULL, 0x0003e2000c901c4eULL,
0x0000000c6a6a7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001765277c11ULL, 0x000fe400090f4c0cULL,
0x0000000a0400720cULL, 0x000fe20003f46070ULL, 0x000000ffff117224ULL, 0x000fe400008e06ffULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x000000166a247c11ULL, 0x002fc8000f8248ffULL,
0x000000176a257c11ULL, 0x000fe400088f4c11ULL, 0x0000000a0500720cULL, 0x000fe20003f26070ULL,
0x000000100d247825ULL, 0x000fd800078e0024ULL, 0x0000000024557faeULL, 0x0003e2000c901c4eULL,
0x0000000c6c6c7c10ULL, 0x000fc6000ff3e0ffULL, 0x0000000026547faeULL, 0x0005e2000d101c4eULL,
0x0000000c6b6b7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff117224ULL, 0x000fc800008e06ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x000000166c247c11ULL, 0x042fe4000f8248ffULL,
0x000000166b267c11ULL, 0x004fe4000f8448ffULL, 0x000000176c257c11ULL, 0x000fe200088f4c11ULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x0000000a0300720cULL, 0x080fe40003f26070ULL,
0x000000176b277c11ULL, 0x000fe200090f4c0cULL, 0x000000100d247825ULL, 0x000fe200078e0024ULL,
0x0000000a0200720cULL, 0x000fc40003f46070ULL, 0x0000001664307c11ULL, 0x000fe2000f8848ffULL,
0x000000100d267825ULL, 0x000fc600078e0026ULL, 0x0000001764317c11ULL, 0x000fe2000a0f4c11ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x0000000c70707c10ULL, 0x000fe2000ffbe0ffULL,
0x0000000024537faeULL, 0x000fe2000c901c4eULL, 0x0000000a0e00720cULL, 0x080fe20003f26070ULL,
0x000000100d307825ULL, 0x000fe400078e0030ULL, 0x0000000026527faeULL, 0x0003e2000d101c4eULL,
0x0000000a0b00720cULL, 0x000fc60003f46070ULL, 0x0000000030517faeULL, 0x0007e2000d901c4eULL,
0x000000166e267c11ULL, 0x002fc8000f8848ffULL, 0x000000176e277c11ULL, 0x000fe2000a0f4c11ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x0000001670247c11ULL, 0x000fe2000f8848ffULL,
0x000000100d267825ULL, 0x000fc600078e0026ULL, 0x0000001770257c11ULL, 0x000fe4000a0f4c11ULL,
0x00000000264f7faeULL, 0x0007e2000d101c4eULL, 0x000000100d247825ULL, 0x000fca00078e0024ULL,
0x00000000244e7faeULL, 0x0007e2000c901c4eULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000000c66667c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000c65657c10ULL, 0x000fc6000ff5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x0000001666247c11ULL, 0x040fe2000f8248ffULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x0000000c6b6b7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001766257c11ULL, 0x000fe400088f4c11ULL, 0x0000000c6a6a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000100d247825ULL, 0x000fc800078e0024ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x000000166a267c11ULL, 0x040fe2000f8248ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024567faeULL, 0x0003e6000b901c4eULL, 0x000000176a277c11ULL, 0x000fc600088f4c11ULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x0000001665247c11ULL, 0x002fc8000f8248ffULL,
0x0000000026557faeULL, 0x0003e2000b901c4eULL, 0x0000001765257c11ULL, 0x000fe200088f4c0aULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x0000000c6c6c7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000c6e6e7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d247825ULL, 0x000fc800078e0024ULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x000000166c267c11ULL, 0x042fe2000f8248ffULL,
0x0000000024547faeULL, 0x0003e6000b901c4eULL, 0x000000176c277c11ULL, 0x000fc600088f4c11ULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x000000166b247c11ULL, 0x002fc8000f8248ffULL,
0x0000000026537faeULL, 0x0003e2000b901c4eULL, 0x000000176b257c11ULL, 0x000fe400088f4c0aULL,
0x0000000c64647c10ULL, 0x000fe2000ff3e0ffULL, 0x000000100d247825ULL, 0x000fc800078e0024ULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x0000001664307c11ULL, 0x040fe2000f8248ffULL,
0x0000000024527faeULL, 0x0005e6000b901c4eULL, 0x0000001764317c11ULL, 0x000fe200088f4c11ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000166e267c11ULL, 0x042fe4000f8248ffULL,
0x0000000c70707c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d307825ULL, 0x000fe200078e0030ULL,
0x000000176e277c11ULL, 0x000fc600088f4c11ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x0000001670247c11ULL, 0x044fe2000f8248ffULL, 0x000000100d267825ULL, 0x040fe200078e0026ULL,
0x0000000030517faeULL, 0x0003e4000b901c4eULL, 0x0000001770257c11ULL, 0x000fe400088f4c11ULL,
0x00000000264f7faeULL, 0x0003e2000b901c4eULL, 0x000000100d247825ULL, 0x000fca00078e0024ULL,
0x00000000244e7faeULL, 0x0003e4000b901c4eULL, 0x00000012ff247e24ULL, 0x00afe2000f8e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000012ff117e24ULL, 0x000fc8000f8e00ffULL,
0x01c64812242479a7ULL, 0x000e640008500006ULL, 0x01c64825110075a7ULL, 0x002e640008020146ULL,
0x000000e8003c9947ULL, 0x002fea0003800000ULL, 0x01c1000010117984ULL, 0x000e620000000800ULL,
0x00000000000c7919ULL, 0x000ea40000000000ULL, 0x00000002ff397819ULL, 0x004fe4000001160cULL,
0x01c30000100c7984ULL, 0x0004e20000000800ULL, 0x000000081100720bULL, 0x002fe40003f3d000ULL,
0x0000000839387836ULL, 0x000fd60000000000ULL, 0x00000000000a7806ULL, 0x000fc800008e0100ULL,
0x0000ffff0a127812ULL, 0x000fe2000782c0ffULL, 0x00000001ff0a7424ULL, 0x000fd800078e00ffULL,
0x0000000000d09947ULL, 0x004fea0003800000ULL, 0x000000081100720bULL, 0x000fe20003f34000ULL,
0x000000021000788cULL, 0x000fe2000bf05270ULL, 0x0000001108257209ULL, 0x000fca0007810000ULL,
0x8000002508087221ULL, 0x000fe20000010000ULL, 0x000000000000781cULL, 0x000fc60003f4f008ULL,
0x3fb8aa3b080a7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fc800008e0100ULL,
0x0000ffff08277812ULL, 0x000fe200078e3cffULL, 0x0000000a000a7308ULL, 0x000e660000000800ULL,
0x0000002712ff7212ULL, 0x000fe2000782c0ffULL, 0x01c500251000a388ULL, 0x000fe80000000800ULL,
0x00001f390a087589ULL, 0x002e7000000e0000ULL, 0x8000002511111221ULL, 0x000fe20000010000ULL,
0x0000000a07077220ULL, 0x000fc60000410000ULL, 0x3fb8aa3b11121820ULL, 0x000fe40000410000ULL,
0x00001f380a117589ULL, 0x00052400000e0000ULL, 0x0000001200581308ULL, 0x000f620000000800ULL,
0x00000001ff0a7807ULL, 0x004fe20000800000ULL, 0x0000000814147220ULL, 0x082fe20000410000ULL,
0x0000000815157220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x000000081c1c7220ULL, 0x080fe20000410000ULL,
0x000000081d1d7220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x000fe20000410000ULL, 0x0000001116167220ULL, 0x090fe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x0000001142427220ULL, 0x080fe20000410000ULL,
0x0000001143437220ULL, 0x080fe20000410000ULL, 0x000000113e3e7220ULL, 0x080fe20000410000ULL,
0x000000113f3f7220ULL, 0x080fe20000410000ULL, 0x000000111a1a7220ULL, 0x080fe20000410000ULL,
0x000000111b1b7220ULL, 0x080fe20000410000ULL, 0x000000111e1e7220ULL, 0x080fe20000410000ULL,
0x000000111f1f7220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x000000112e2e7220ULL, 0x080fe20000410000ULL,
0x000000112f2f7220ULL, 0x080fe20000410000ULL, 0x000000112a2a7220ULL, 0x080fe20000410000ULL,
0x000000112b2b7220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e0025ULL,
0x0000000c580c1220ULL, 0x028fce0000410000ULL, 0x0000140001247983ULL, 0x000ea20000100800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000180001127983ULL, 0x000f280000100800ULL,
0x0000200001457983ULL, 0x000f680000100800ULL, 0x0000300001447983ULL, 0x008ee80000100800ULL,
0x0000380001377983ULL, 0x000ee80000100800ULL, 0x0000280001367983ULL, 0x000ee80000100800ULL,
0x00001c0001357983ULL, 0x000ee80000100800ULL, 0x0000240001347983ULL, 0x000ee20000100800ULL,
0x000099100a0a7816ULL, 0x000fc400000000ffULL, 0x00000058ff11723eULL, 0x000fe200000010ffULL,
0x00002c00013b7983ULL, 0x000ee80000100800ULL, 0x00003400013a7983ULL, 0x000ee20000100800ULL,
0x000000ff0a00720cULL, 0x000fe40003f25270ULL, 0x00005410110a7816ULL, 0x000fca0000000011ULL,
0x00001f390a117589ULL, 0x000fe800000e0000ULL, 0x013000002424783bULL, 0x004e680000000200ULL,
0x000000001230783bULL, 0x010fe80000004200ULL, 0x00001f380a127589ULL, 0x000ea200000e0000ULL,
0x0000001124249232ULL, 0x002fc40000200000ULL, 0x0000001126269232ULL, 0x000fe40000200000ULL,
0x0000001225259232ULL, 0x084fe40000200000ULL, 0x0000001227279232ULL, 0x000fce0000200000ULL,
0x000000302414723cULL, 0x000fec0000041814ULL, 0x000000322440723cULL, 0x000fe20000041840ULL,
0x000000004530783bULL, 0x020e6a0000004200ULL, 0x00000030243c723cULL, 0x002fec000004183cULL,
0x000000322418723cULL, 0x000fe20000041818ULL, 0x000000004430783bULL, 0x008e6a0000004200ULL,
0x00000030241c723cULL, 0x002fec000004181cULL, 0x000000322420723cULL, 0x000fe20000041820ULL,
0x000000003730783bULL, 0x000e6a0000004200ULL, 0x00000030242c723cULL, 0x002fec000004182cULL,
0x000000322428723cULL, 0x000fe20000041828ULL, 0x013000003624783bULL, 0x000e680000000200ULL,
0x000000003530783bULL, 0x000ea80000004200ULL, 0x000000003434783bULL, 0x000ee20000004200ULL,
0x0000001124249232ULL, 0x002fc40000200000ULL, 0x0000001126269232ULL, 0x000fe40000200000ULL,
0x0000001225259232ULL, 0x080fe40000200000ULL, 0x0000001227279232ULL, 0x000fce0000200000ULL,
0x000000302414723cULL, 0x004fec0000041814ULL, 0x000000322440723cULL, 0x000fe20000041840ULL,
0x000000003b30783bULL, 0x000e6a0000004200ULL, 0x00000034243c723cULL, 0x008fec000004183cULL,
0x000000362418723cULL, 0x000fe20000041818ULL, 0x000000003a34783bULL, 0x000ea20000004200ULL,
0x000000070c077221ULL, 0x000fc80000010000ULL, 0x00000030241c723cULL, 0x002fec000004181cULL,
0x000000322420723cULL, 0x000fec0000041820ULL, 0x00000034242c723cULL, 0x004fec000004182cULL,
0x000000362424723cULL, 0x000fe20000041828ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400088947ULL, 0x000fde0003800000ULL,
0x00000080150d7890ULL, 0x000fe2000fffe03fULL, 0x0000000c71717c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000c72727c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000d1400728cULL, 0x000fe2000bf01070ULL,
0x00000016712a7c11ULL, 0x000fe2000f8648ffULL, 0x8000000dff0c7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000c73737c10ULL, 0x000fe2000ffbe0ffULL, 0x0000000d141a7287ULL, 0x000fe2000c000000ULL,
0x000000ffff127224ULL, 0x000fca00010e06ffULL, 0x0000001aff117e24ULL, 0x000fe2000f8e00ffULL,
0x00000017712b7c11ULL, 0x000fe200098f4c12ULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x0000000c75757c10ULL, 0x000fe4000ffbe0ffULL, 0x000000200c0c7446ULL, 0x000fe20003800011ULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x0000001672287c11ULL, 0x000fe2000f8848ffULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x0000000c0600720cULL, 0x080fe40003f46070ULL,
0x0000000c0500720cULL, 0x000fc40003f66070ULL, 0x0000001772297c11ULL, 0x000fe4000a0f4c11ULL,
0x0000000c74747c10ULL, 0x000fe4000ff9e0ffULL, 0x0000000c0e00720cULL, 0x000fe20003fc6070ULL,
0x000000100d287825ULL, 0x000fc800078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a617faeULL, 0x0003e2000d101c4eULL, 0x000000ffff317224ULL, 0x000fc600020e06ffULL,
0x0000000028607faeULL, 0x0005e2000d901c4eULL, 0x00000016732a7c11ULL, 0x002fc8000f8448ffULL,
0x00000017732b7c11ULL, 0x000fe200090f4c12ULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x0000000c76767c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001674287c11ULL, 0x004fe2000f8648ffULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x0000001676307c11ULL, 0x000fe4000f8848ffULL,
0x0000001774297c11ULL, 0x000fe200098f4c31ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x0000000c0400720cULL, 0x000fc40003f46070ULL, 0x0000001675347c11ULL, 0x000fe2000f8648ffULL,
0x000000100d287825ULL, 0x000fe200078e0028ULL, 0x0000001776317c11ULL, 0x000fe4000a0f4c11ULL,
0x0000000c78787c10ULL, 0x000fe4000ff9e0ffULL, 0x0000001775357c11ULL, 0x000fe200098f4c12ULL,
0x000000100d307825ULL, 0x000fe200078e0030ULL, 0x0000000c77777c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000c0b00720cULL, 0x080fe20003fa6070ULL, 0x000000002a5f7faeULL, 0x0003e2000d101c4eULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x0000001678327c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x0000000c0000720cULL, 0x000fe20003f86070ULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x0000001778337c11ULL, 0x000fc400090f4c11ULL,
0x0000000c0300720cULL, 0x000fe20003f46070ULL, 0x000000100d327825ULL, 0x000fe200078e0032ULL,
0x00000016772a7c11ULL, 0x002fc8000f8648ffULL, 0x00000017772b7c11ULL, 0x000fe400098f4c12ULL,
0x0000000c0200720cULL, 0x000fe20003f66070ULL, 0x000000100d2a7825ULL, 0x000fc800078e002aULL,
0x00000000285e7faeULL, 0x0003f0000d101c4eULL, 0x00000000305b7faeULL, 0x0003e8000d901c4eULL,
0x00000000345a7faeULL, 0x0003e8000e101c4eULL, 0x0000000032597faeULL, 0x0003e8000e901c4eULL,
0x000000002a0f7faeULL, 0x0003e2000f101c4eULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000000c71717c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000c72727c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000c74747c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x0000001671287c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x0000000c73737c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001771297c11ULL, 0x000fc400090f4c0cULL,
0x0000001672307c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff0c7224ULL, 0x000fe400018e06ffULL,
0x000000100d287825ULL, 0x000fe200078e0028ULL, 0x0000001772317c11ULL, 0x000fe400090f4c11ULL,
0x00000016732a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028617faeULL, 0x0003e2000b901c4eULL,
0x000000100d307825ULL, 0x000fe200078e0030ULL, 0x00000017732b7c11ULL, 0x000fc400090f4c0cULL,
0x0000000c76767c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000030607faeULL, 0x0005e2000b901c4eULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x0000001674287c11ULL, 0x002fc8000f8648ffULL,
0x000000002a5f7faeULL, 0x0003e2000b901c4eULL, 0x0000001774297c11ULL, 0x000fe200098f4c11ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000000c75757c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001676307c11ULL, 0x004fe2000f8448ffULL, 0x000000100d287825ULL, 0x000fc600078e0028ULL,
0x0000001776317c11ULL, 0x000fe200090f4c11ULL, 0x000000ffff0c7224ULL, 0x000fe200018e06ffULL,
0x0000001675347c11ULL, 0x000fe2000f8648ffULL, 0x00000000285e7faeULL, 0x0005e2000b901c4eULL,
0x0000000c78787c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d307825ULL, 0x000fe200078e0030ULL,
0x0000001775357c11ULL, 0x000fe400098f4c0cULL, 0x0000000c77777c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001678327c11ULL, 0x040fe2000f8448ffULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x00000000305b7faeULL, 0x0005e4000b901c4eULL,
0x0000001778337c11ULL, 0x000fe200090f4c11ULL, 0x000000ffff0c7224ULL, 0x000fe200018e06ffULL,
0x00000016772a7c11ULL, 0x002fe2000f8648ffULL, 0x00000000345a7faeULL, 0x0005e2000b901c4eULL,
0x000000100d327825ULL, 0x000fc400078e0032ULL, 0x00000017772b7c11ULL, 0x000fc600098f4c0cULL,
0x0000000032597faeULL, 0x0005e2000b901c4eULL, 0x000000100d2a7825ULL, 0x000fca00078e002aULL,
0x000000002a0f7faeULL, 0x0005e4000b901c4eULL, 0x0000100001297983ULL, 0x006ea80000100800ULL,
0x00000c0001287983ULL, 0x000ee80000100800ULL, 0x00000800010c7983ULL, 0x000f280000100800ULL,
0x0000040001127983ULL, 0x000f680000100800ULL, 0x0000000001117983ULL, 0x000f620000100800ULL,
0x00000080150d7890ULL, 0x000fe2000fffe03fULL, 0x00000001ff577424ULL, 0x000fc400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000140d00728cULL, 0x000fe2000bf06070ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x013000002930783bULL, 0x004fe80000000200ULL,
0x000000002828783bULL, 0x008fe80000004200ULL, 0x000000000c34783bULL, 0x010fe80000004200ULL,
0x00001f390a0c7589ULL, 0x000e6800000e0000ULL, 0x00001f380a0a7589ULL, 0x000ea800000e0000ULL,
0x000000001244783bULL, 0x020ee80000004200ULL, 0x000000001138783bULL, 0x000f220000004200ULL,
0x0000000c30309232ULL, 0x002fc40000200000ULL, 0x0000000c32329232ULL, 0x000fe40000200000ULL,
0x0000000a31319232ULL, 0x084fe40000200000ULL, 0x0000000a33339232ULL, 0x000fce0000200000ULL,
0x000000283014723cULL, 0x000fec0000041814ULL, 0x0000002a3040723cULL, 0x000fe20000041840ULL,
0x013000007d28783bULL, 0x000e6a0000000200ULL, 0x00000034303c723cULL, 0x000fec000004183cULL,
0x000000363018723cULL, 0x000fe20000041818ULL, 0x000000007a34783bULL, 0x000eaa0000004200ULL,
0x00000044301c723cULL, 0x008fec000004181cULL, 0x000000463020723cULL, 0x000fe20000041820ULL,
0x000000007c44783bULL, 0x000eea0000004200ULL, 0x00000038302c723cULL, 0x010fec000004182cULL,
0x0000003a3024723cULL, 0x000fe20000041824ULL, 0x000000007b38783bULL, 0x000f280000004200ULL,
0x000000007930783bULL, 0x000f620000004200ULL, 0x0000000c28289232ULL, 0x082fe20000200000ULL,
0x01c69857ffff79a7ULL, 0x0003e20008500006ULL, 0x0000000c2a2a9232ULL, 0x000fc40000200000ULL,
0x0000000a29299232ULL, 0x080fe40000200000ULL, 0x0000000a2b2b9232ULL, 0x000fe20000200000ULL,
0x000000000000781cULL, 0x000fcc0003f2f008ULL, 0x00000034281c723cULL, 0x004fec000004181cULL,
0x000000362820723cULL, 0x000fec0000041820ULL, 0x000000442814723cULL, 0x008fec0000041814ULL,
0x000000462840723cULL, 0x000fec0000041840ULL, 0x00000038283c723cULL, 0x010fec000004183cULL,
0x0000003a2818723cULL, 0x000fec0000041818ULL, 0x00000030282c723cULL, 0x020fec000004182cULL,
0x000000322828723cULL, 0x000fe20000041824ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000018009c1947ULL, 0x002fde0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400088947ULL, 0x000fea0003800000ULL, 0x0000000c50507c10ULL, 0x000fe2000ff1e0ffULL,
0x000000a015097890ULL, 0x000fe2000fffe03fULL, 0x0000000c4d4d7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000c4c4c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x0000001650247c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x000000164c267c11ULL, 0x000fe2000f8248ffULL, 0x000000091400728cULL, 0x000fe2000bf01070ULL,
0x0000001750257c11ULL, 0x000fe200080f4c11ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x000000164d307c11ULL, 0x000fe2000f8048ffULL, 0x00000009140d7287ULL, 0x000fc4000c000000ULL,
0x80000009ff0c7e24ULL, 0x000fe2000f8e02ffULL, 0x0000000c48487c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100d247825ULL, 0x000fe200078e0024ULL, 0x000000174c277c11ULL, 0x000fe400088f4c11ULL,
0x0000000c4a4a7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000dff377e24ULL, 0x000fe2000f8e00ffULL,
0x000000174d317c11ULL, 0x000fe200080f4c0aULL, 0x000000100d267825ULL, 0x000fe200078e0026ULL,
0x0000000c4b4b7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000c13137c10ULL, 0x000fe2000ffbe0ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x000000164a327c11ULL, 0x040fe2000f8248ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x000000164b347c11ULL, 0x000fe2000f8048ffULL,
0x000000100d307825ULL, 0x000fe200078e0030ULL, 0x000000174a337c11ULL, 0x000fc400088f4c11ULL,
0x000000200c117446ULL, 0x000fe20003800037ULL, 0x000000ffff377224ULL, 0x000fe200010e06ffULL,
0x000000174b357c11ULL, 0x000fe200080f4c0aULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x000000110600720cULL, 0x080fe20003f46070ULL, 0x000000100d327825ULL, 0x000fe200078e0032ULL,
0x000000110500720cULL, 0x000fe40003f66070ULL, 0x0000000c49497c10ULL, 0x000fe2000ff1e0ffULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x0000001648367c11ULL, 0x000fc4000f8848ffULL,
0x0000001649387c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000001613127c11ULL, 0x000fe4000f8a48ffULL, 0x000000110400720cULL, 0x080fe20003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024567faeULL, 0x0003e2000d101c4eULL,
0x0000001749397c11ULL, 0x000fe400088f4c0cULL, 0x000000110300720cULL, 0x080fe20003f26070ULL,
0x0000000030557faeULL, 0x0003e2000d901c4eULL, 0x000000110200720cULL, 0x000fe20003f46070ULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x0000001748377c11ULL, 0x000fc4000a0f4c37ULL,
0x000000110000720cULL, 0x080fe40003f66070ULL, 0x0000001713137c11ULL, 0x000fe2000a8f4c0aULL,
0x000000100d367825ULL, 0x000fe200078e0036ULL, 0x000000110b00720cULL, 0x080fe20003f86070ULL,
0x0000000026547faeULL, 0x0003e2000c101c4eULL, 0x000000110e00720cULL, 0x000fe20003fa6070ULL,
0x000000100d127825ULL, 0x000fe400078e0012ULL, 0x0000000034537faeULL, 0x0003e8000c901c4eULL,
0x0000000032527faeULL, 0x0003e8000d101c4eULL, 0x0000000038517faeULL, 0x0003e8000d901c4eULL,
0x00000000364f7faeULL, 0x0003e8000e101c4eULL, 0x00000000124e7faeULL, 0x0003e2000e901c4eULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000000c50507c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000c4d4d7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000c4c4c7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000001650247c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x000000164d267c11ULL, 0x000fe4000f8248ffULL,
0x0000000c4b4b7c10ULL, 0x000fc4000ff7e0ffULL, 0x0000001750257c11ULL, 0x000fe200080f4c11ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000174d277c11ULL, 0x000fe200088f4c0aULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x000000164c327c11ULL, 0x040fe2000f8048ffULL,
0x000000100d247825ULL, 0x000fe200078e0024ULL, 0x0000000c4a4a7c10ULL, 0x000fe4000ff5e0ffULL,
0x000000164b307c11ULL, 0x000fe2000f8248ffULL, 0x000000100d267825ULL, 0x000fe200078e0026ULL,
0x0000000c49497c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024567faeULL, 0x0003e2000b901c4eULL, 0x000000174c337c11ULL, 0x000fe200080f4c11ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000174b317c11ULL, 0x000fe200088f4c0aULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x000000164a347c11ULL, 0x040fe2000f8048ffULL,
0x000000100d327825ULL, 0x040fe200078e0032ULL, 0x0000000c48487c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000026557faeULL, 0x0003e2000b901c4eULL, 0x0000000c130c7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000100d307825ULL, 0x000fe200078e0030ULL, 0x0000001649127c11ULL, 0x040fe2000f8248ffULL,
0x0000000032547faeULL, 0x0003e2000b901c4eULL, 0x000000174a357c11ULL, 0x000fe200080f4c11ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001749137c11ULL, 0x000fe200088f4c0aULL,
0x000000ffff377224ULL, 0x000fe200018e06ffULL, 0x0000001648387c11ULL, 0x000fe2000f8048ffULL,
0x000000100d347825ULL, 0x040fe200078e0034ULL, 0x000000160c367c11ULL, 0x000fe2000f8248ffULL,
0x0000000030537faeULL, 0x0003e2000b901c4eULL, 0x0000001748397c11ULL, 0x000fe200080f4c11ULL,
0x000000100d127825ULL, 0x040fe200078e0012ULL, 0x000000170c377c11ULL, 0x000fe200088f4c37ULL,
0x0000000034527faeULL, 0x0003e4000b901c4eULL, 0x000000100d387825ULL, 0x000fc400078e0038ULL,
0x0000000012517faeULL, 0x0003e4000b901c4eULL, 0x000000100d367825ULL, 0x000fe400078e0036ULL,
0x00000000384f7faeULL, 0x0003e8000b901c4eULL, 0x00000000364e7faeULL, 0x0003e4000b901c4eULL,
0x0000000113097892ULL, 0x000fe2000f8ec03fULL, 0x00000012ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00197882ULL, 0x000fe40000000000ULL, 0x000000010900788cULL, 0x000fc8000bf05070ULL,
0x000000010b097887ULL, 0x000fc8000c000000ULL, 0x0000000913097290ULL, 0x000fc8000fffe03fULL,
0x000000040900728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x00000000001c0947ULL, 0x000fea0003800000ULL, 0x00000008090b7290ULL, 0x000fe2000fffe03fULL,
0x00008c00000c7ab9ULL, 0x000fc60000000a00ULL, 0x000000040b0c78a5ULL, 0x000fcc000f8e000cULL,
0x0000000cff127e24ULL, 0x002fe4000f8e00ffULL, 0x0000000dff137e24ULL, 0x000fca000f8e00ffULL,
0x0000000e12127981ULL, 0x000ea4000c1e1900ULL, 0x00000000121972caULL, 0x004fde00000e0000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c668570a1279a7ULL, 0x002e620008500006ULL,
0x00000012ff117e24ULL, 0x000fc8000f8e00ffULL, 0x01c66813110075a7ULL, 0x002e640008000146ULL,
0x000000cc00b48947ULL, 0x002fea0003800000ULL, 0x01c1800010117984ULL, 0x000e620000000800ULL,
0x00000001ff247424ULL, 0x000fe200078e00ffULL, 0x00000000000c7919ULL, 0x000ea40000000000ULL,
0x00000002ff657819ULL, 0x004fe4000001160cULL, 0x000000081100720bULL, 0x002fc60003f1d000ULL,
0x0000000865647836ULL, 0x000fd40000000000ULL, 0x00000000000a7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0a127812ULL, 0x000fe4000780c0ffULL, 0x01c38000100a7984ULL, 0x0002b60000000800ULL,
0x0000000000d08947ULL, 0x002fea0003800000ULL, 0x000000081100720bULL, 0x000fe20003f14000ULL,
0x000000031000788cULL, 0x000fe2000bf05270ULL, 0x0000001108257209ULL, 0x000fca0007810000ULL,
0x80000025080c7221ULL, 0x000fe20000010000ULL, 0x000000000000781cULL, 0x000fc60003f2f008ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fc800000e0100ULL,
0x0000ffff08137812ULL, 0x000fe200078e3cffULL, 0x0000000c000c7308ULL, 0x000e660000000800ULL,
0x0000001312ff7212ULL, 0x000fe2000780c0ffULL, 0x01c5802510009388ULL, 0x000fe60000000800ULL,
0x00000001ff247807ULL, 0x000fe20000000000ULL, 0x00001f650c087589ULL, 0x002e7000000e0000ULL,
0x8000002511120221ULL, 0x000fe20000010000ULL, 0x0000000c07077220ULL, 0x000fe20000410000ULL,
0x00001f640c117589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL,
0x0000001200580308ULL, 0x000f220000000800ULL, 0x0000000814147220ULL, 0x082fe20000410000ULL,
0x0000000815157220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x000000081c1c7220ULL, 0x080fe20000410000ULL,
0x000000081d1d7220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x000fe20000410000ULL, 0x0000001116167220ULL, 0x088fe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x0000001142427220ULL, 0x080fe20000410000ULL,
0x0000001143437220ULL, 0x080fe20000410000ULL, 0x000000113e3e7220ULL, 0x080fe20000410000ULL,
0x000000113f3f7220ULL, 0x080fe20000410000ULL, 0x000000111a1a7220ULL, 0x080fe20000410000ULL,
0x000000111b1b7220ULL, 0x080fe20000410000ULL, 0x000000111e1e7220ULL, 0x080fe20000410000ULL,
0x000000111f1f7220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x000000112e2e7220ULL, 0x080fe20000410000ULL,
0x000000112f2f7220ULL, 0x080fe20000410000ULL, 0x000000112a2a7220ULL, 0x080fe20000410000ULL,
0x000000112b2b7220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e0025ULL,
0x0000000a580a0220ULL, 0x014fce0000410000ULL, 0x0000140001117983ULL, 0x000ee20000300800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000180001107983ULL, 0x000f280000300800ULL,
0x0000200001327983ULL, 0x000f680000300800ULL, 0x0000300001277983ULL, 0x004ea80000300800ULL,
0x0000380001267983ULL, 0x000ea80000300800ULL, 0x0000280001257983ULL, 0x000ea80000300800ULL,
0x00001c0001317983ULL, 0x000ea80000300800ULL, 0x0000240001307983ULL, 0x000ea80000300800ULL,
0x00002c0001507983ULL, 0x000ea80000300800ULL, 0x0000340001547983ULL, 0x000ea20000300800ULL,
0x00000058ff0c723eULL, 0x000fc400000010ffULL, 0x0000991024247816ULL, 0x000fe200000000ffULL,
0x0000440001667983ULL, 0x000ea20000100800ULL, 0x000054100c0c7816ULL, 0x000fe4000000000cULL,
0x000000ff2400720cULL, 0x000fc60003f05270ULL, 0x00001f650c5c7589ULL, 0x000fe800000e0000ULL,
0x00001f640c5d7589ULL, 0x000fe200000e0000ULL, 0x0000000a190a72a4ULL, 0x000fe2000f8e023fULL,
0x000000070a077221ULL, 0x000fc60000010000ULL, 0x000000070a0a7899ULL, 0x000fe2000800063fULL,
0x013800001138783bULL, 0x008e680000000200ULL, 0x000000001010783bULL, 0x010ee80000004200ULL,
0x00000000324c783bULL, 0x020f280000004200ULL, 0x000000002748783bULL, 0x004ea80000004200ULL,
0x000000002644783bULL, 0x000f680000004200ULL, 0x013800002524783bULL, 0x000ea80000000200ULL,
0x000000003134783bULL, 0x000ea80000004200ULL, 0x000000003030783bULL, 0x000ea80000004200ULL,
0x000000005050783bULL, 0x000ea80000004200ULL, 0x000000005454783bULL, 0x000ea20000004200ULL,
0x0000005c38388232ULL, 0x002fc40000200000ULL, 0x0000005c3a3a8232ULL, 0x000fe40000200000ULL,
0x0000005d39398232ULL, 0x080fe40000200000ULL, 0x0000005d3b3b8232ULL, 0x000fce0000200000ULL,
0x000000103814723cULL, 0x008fec0000041814ULL, 0x000000123810723cULL, 0x000fec0000041840ULL,
0x0000004c383c723cULL, 0x010fec000004183cULL, 0x0000004e3818723cULL, 0x000fec0000041818ULL,
0x00000048381c723cULL, 0x004fec000004181cULL, 0x0000004a3820723cULL, 0x000fec0000041820ULL,
0x00000044382c723cULL, 0x020fec000004182cULL, 0x000000463828723cULL, 0x000fe20000041828ULL,
0x0000005c24248232ULL, 0x000fc40000200000ULL, 0x0000005c26268232ULL, 0x000fe40000200000ULL,
0x0000005d25258232ULL, 0x080fe40000200000ULL, 0x0000005d27278232ULL, 0x000fce0000200000ULL,
0x000000342414723cULL, 0x000fec0000041814ULL, 0x000000362410723cULL, 0x000fec0000041810ULL,
0x00000030243c723cULL, 0x000fec000004183cULL, 0x000000322418723cULL, 0x000fec0000041818ULL,
0x00000050241c723cULL, 0x000fec000004181cULL, 0x000000522420723cULL, 0x000fec0000041820ULL,
0x00000054242c723cULL, 0x000fec000004182cULL, 0x000000562428723cULL, 0x000fee0000041828ULL,
0x0000001166247c36ULL, 0x000fc80008000000ULL, 0x0000000124257836ULL, 0x000fca0000000000ULL,
0x0000000525007c0cULL, 0x000fe2000bf26070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000000400009947ULL, 0x000fea0003800000ULL, 0x0000000a09257c10ULL, 0x000fe2000ff3e0ffULL,
0x0000010024097824ULL, 0x000fe200078e00ffULL, 0x0000000a69697c10ULL, 0x000fe4000ff9e0ffULL,
0x0000000a6d6d7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff267224ULL, 0x000fe200008e06ffULL,
0x0000001625247c11ULL, 0x000fe4000f8248ffULL, 0x00000014090a7c48ULL, 0x000fe2000ffe0000ULL,
0x000000ffff097224ULL, 0x000fe200078e0a09ULL, 0x0000001725257c11ULL, 0x000fe200088f4c26ULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x0000000a68687c10ULL, 0x000fc4000ff3e0ffULL,
0x000000200a097446ULL, 0x000fe20003800009ULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000000a6f6f7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff317224ULL, 0x000fe200008e06ffULL,
0x0000001668307c11ULL, 0x040fe2000f8248ffULL, 0x000000100d247825ULL, 0x000fe200078e0024ULL,
0x0000001669267c11ULL, 0x000fe4000f8848ffULL, 0x0000001768317c11ULL, 0x000fe200088f4c31ULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x0000000a67677c10ULL, 0x000fc4000ff3e0ffULL,
0x000000166d327c11ULL, 0x000fe2000f8648ffULL, 0x000000100d307825ULL, 0x000fe200078e0030ULL,
0x0000001769277c11ULL, 0x000fe4000a0f4c0aULL, 0x000000166f347c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x000000090600720cULL, 0x000fe20003fa6070ULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x000000176d337c11ULL, 0x000fe400098f4c36ULL,
0x0000000a62627c10ULL, 0x000fc4000ff9e0ffULL, 0x000000090500720cULL, 0x000fe20003f26070ULL,
0x000000100d327825ULL, 0x000fe200078e0032ULL, 0x0000000a63637c10ULL, 0x000fe4000ff7e0ffULL,
0x000000176f357c11ULL, 0x000fe200090f4c38ULL, 0x000000ffff377224ULL, 0x000fe200020e06ffULL,
0x00000016673a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x0000001662367c11ULL, 0x000fe2000f8848ffULL, 0x000000100d347825ULL, 0x000fe200078e0034ULL,
0x0000001663387c11ULL, 0x000fe2000f8648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024617faeULL, 0x0003e2000e901c4eULL, 0x00000017673b7c11ULL, 0x000fc400090f4c0aULL,
0x0000001762377c11ULL, 0x000fe2000a0f4c37ULL, 0x0000000034607faeULL, 0x0003e2000c901c4eULL,
0x000000090400720cULL, 0x080fe20003f46070ULL, 0x000000100d3a7825ULL, 0x000fe200078e003aULL,
0x0000001763397c11ULL, 0x000fe400098f4c06ULL, 0x000000090300720cULL, 0x080fe20003f86070ULL,
0x000000100d367825ULL, 0x040fe200078e0036ULL, 0x000000090200720cULL, 0x080fe40003f66070ULL,
0x000000090000720cULL, 0x080fe20003fa6070ULL, 0x000000100d387825ULL, 0x000fe200078e0038ULL,
0x000000090b00720cULL, 0x000fc40003f26070ULL, 0x000000090e00720cULL, 0x000fe20003fc6070ULL,
0x00000000325f7faeULL, 0x0003e8000d101c4eULL, 0x00000000265e7faeULL, 0x0003e8000e101c4eULL,
0x00000000305b7faeULL, 0x0003e8000d901c4eULL, 0x000000003a5a7faeULL, 0x0003e8000e901c4eULL,
0x0000000038597faeULL, 0x0003e8000c901c4eULL, 0x00000000360f7faeULL, 0x0003e2000f101c4eULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000000a09097c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000a6f6f7c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000a6d6d7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0x0000000a69697c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff067224ULL, 0x000fe200018e06ffULL, 0x0000001609247c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x000000166f0a7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff267224ULL, 0x000fe200008e06ffULL, 0x000000166d047c11ULL, 0x000fc4000f8848ffULL,
0x0000001669027c11ULL, 0x000fe4000f8248ffULL, 0x0000001709257c11ULL, 0x000fe400090f4c00ULL,
0x000000176f0b7c11ULL, 0x000fe400098f4c06ULL, 0x0000000a68687c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100d247825ULL, 0x000fe200078e0024ULL, 0x000000176d057c11ULL, 0x000fe4000a0f4c0eULL,
0x0000000a67677c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x0000001769037c11ULL, 0x000fe200088f4c26ULL, 0x000000100d0a7825ULL, 0x000fe200078e000aULL,
0x0000000a63637c10ULL, 0x000fe2000ff9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024617faeULL, 0x0003e2000b901c4eULL, 0x0000000a62627c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200018e06ffULL, 0x0000001668347c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff067224ULL, 0x000fe200020e06ffULL, 0x0000001667327c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x0000001663307c11ULL, 0x000fe2000f8848ffULL,
0x000000100d047825ULL, 0x040fe200078e0004ULL, 0x0000001662267c11ULL, 0x000fe2000f8248ffULL,
0x000000000a607faeULL, 0x0003e2000b901c4eULL, 0x0000001768357c11ULL, 0x000fe200090f4c09ULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000001767337c11ULL, 0x000fe200098f4c00ULL,
0x00000000045f7faeULL, 0x0003e2000b901c4eULL, 0x0000001763317c11ULL, 0x000fe2000a0f4c06ULL,
0x000000100d347825ULL, 0x040fe200078e0034ULL, 0x0000001762277c11ULL, 0x000fe200088f4c27ULL,
0x00000000025e7faeULL, 0x0003e4000b901c4eULL, 0x000000100d327825ULL, 0x000fc400078e0032ULL,
0x00000000345b7faeULL, 0x0003e4000b901c4eULL, 0x000000100d307825ULL, 0x040fe400078e0030ULL,
0x00000000325a7faeULL, 0x0003e4000b901c4eULL, 0x000000100d267825ULL, 0x000fe400078e0026ULL,
0x0000000030597faeULL, 0x0003e8000b901c4eULL, 0x00000000260f7faeULL, 0x0003e4000b901c4eULL,
0x0000100001057983ULL, 0x002ea80000300800ULL, 0x00000c0001047983ULL, 0x000ee80000300800ULL,
0x0000080001037983ULL, 0x000f280000300800ULL, 0x0000040001027983ULL, 0x000f680000300800ULL,
0x0000000001007983ULL, 0x000f680000300800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x013800007d30783bULL, 0x000fe80000000200ULL,
0x000000007c54783bULL, 0x000fe80000004200ULL, 0x000000007b50783bULL, 0x000fe80000004200ULL,
0x000000007a4c783bULL, 0x000fe80000004200ULL, 0x000000007948783bULL, 0x000fe80000004200ULL,
0x013800000524783bULL, 0x004fe80000000200ULL, 0x000000000434783bULL, 0x008fe80000004200ULL,
0x000000000338783bULL, 0x010fe80000004200ULL, 0x000000000240783bULL, 0x0203e80000004200ULL,
0x000000000044783bULL, 0x000fe80000004200ULL, 0x00001f650c037589ULL, 0x000ea200000e0000ULL,
0x00000001ff027424ULL, 0x002fc600078e00ffULL, 0x00001f640c007589ULL, 0x000e6200000e0000ULL,
0x01c6a002ffff79a7ULL, 0x0007e20008500006ULL, 0x0000000324248232ULL, 0x084fe40000200000ULL,
0x0000000326268232ULL, 0x080fe40000200000ULL, 0x0000000025258232ULL, 0x082fe40000200000ULL,
0x0000000027278232ULL, 0x000fe40000200000ULL, 0x0000000330308232ULL, 0x000fc40000200000ULL,
0x0000000332328232ULL, 0x000fe40000200000ULL, 0x0000000031318232ULL, 0x080fe20000200000ULL,
0x000000342414723cULL, 0x000fe20000041814ULL, 0x0000000033338232ULL, 0x000fca0000200000ULL,
0x000000362410723cULL, 0x000fec0000041810ULL, 0x00000038243c723cULL, 0x000fec000004183cULL,
0x0000003a2418723cULL, 0x000fec0000041818ULL, 0x00000040241c723cULL, 0x000fec000004181cULL,
0x000000422420723cULL, 0x000fec0000041820ULL, 0x00000044242c723cULL, 0x000fec000004182cULL,
0x000000462428723cULL, 0x000fec0000041828ULL, 0x000000543014723cULL, 0x000fec0000041814ULL,
0x000000563040723cULL, 0x000fec0000041810ULL, 0x00000050303c723cULL, 0x000fec000004183cULL,
0x000000523018723cULL, 0x000fec0000041818ULL, 0x0000004c301c723cULL, 0x000fec000004181cULL,
0x0000004e3020723cULL, 0x000fec0000041820ULL, 0x00000048302c723cULL, 0x000fec000004182cULL,
0x0000004a3028723cULL, 0x008fde0000041828ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000440001007983ULL, 0x000ea40000300800ULL, 0x0000001100007c36ULL, 0x004fca0008000000ULL,
0x0000440001007387ULL, 0x0003e20000100800ULL, 0x0000000500007c0cULL, 0x000fda000bf06070ULL,
0xffffff88000c8947ULL, 0x002fea000383ffffULL, 0x00000000001379c3ULL, 0x000e640000002500ULL,
0x000000051300728cULL, 0x002fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x0180000007007836ULL, 0x000fca0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e0007ULL,
0x000091c000027802ULL, 0x000fce0000000f00ULL, 0x000000c000ac7944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000007ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x00000002ff057819ULL, 0x010fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0500027589ULL, 0x000ea800000e0000ULL,
0x00001f0300037589ULL, 0x000ee200000e0000ULL, 0x0000001402147220ULL, 0x044fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000004002407220ULL, 0x040fe20000410000ULL,
0x0000004102417220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x040fe20000410000ULL,
0x0000003d023d7220ULL, 0x040fe20000410000ULL, 0x0000001802187220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002c022c7220ULL, 0x040fe20000410000ULL,
0x0000002d022d7220ULL, 0x040fe20000410000ULL, 0x0000002802287220ULL, 0x040fe20000410000ULL,
0x0000002902297220ULL, 0x000fe20000410000ULL, 0x0000001603167220ULL, 0x048fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000004203427220ULL, 0x040fe20000410000ULL,
0x0000004303437220ULL, 0x040fe20000410000ULL, 0x0000003e033e7220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002b032b7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000610067291ULL, 0x000fe2000f8e583fULL, 0x00000014150c723eULL, 0x000fe200000010ffULL,
0x000000011100788cULL, 0x000fe2000bf05270ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0001200006167890ULL, 0x000fe2000fffe03fULL, 0x0000003c3d0e723eULL, 0x000fe400000010ffULL,
0x00000018190f723eULL, 0x000fe400000010ffULL, 0x000000000000781cULL, 0x000fc40003f0f008ULL,
0x0000001c1d10723eULL, 0x000fe400000010ffULL, 0x000000202111723eULL, 0x000fe400000010ffULL,
0x0000002c2d12723eULL, 0x000fe400000010ffULL, 0x000000282913723eULL, 0x000fe400000010ffULL,
0x000000161714723eULL, 0x000fe400000010ffULL, 0x000000424315723eULL, 0x000fc400000010ffULL,
0x0000003e3f16723eULL, 0x000fe400000010ffULL, 0x0000001a1b17723eULL, 0x000fe400000010ffULL,
0x0000001e1f18723eULL, 0x000fe400000010ffULL, 0x000000222319723eULL, 0x000fe400000010ffULL,
0x00000003ff037819ULL, 0x004fe40000011600ULL, 0xfffffff8ff057812ULL, 0x000fc400078ee200ULL,
0x0000000303027812ULL, 0x000fe400078ec0ffULL, 0x0000002e2f1a723eULL, 0x000fe200000010ffULL,
0x00000008050b7836ULL, 0x040fe20000000000ULL, 0x0000000402067812ULL, 0x000fe200078efcffULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0x0000000702097812ULL, 0x000fe400078e7805ULL,
0x00000007020d7812ULL, 0x000fe200078e780bULL, 0x000000080b027824ULL, 0x000fe200078e00ffULL,
0x0000000706057812ULL, 0x000fc400078e7805ULL, 0x00000007060b7812ULL, 0x000fe400078e780bULL,
0x0000000409097212ULL, 0x080fe400078efcffULL, 0x0000000405057212ULL, 0x000fe400078efcffULL,
0x000000020d047212ULL, 0x080fe400078efcffULL, 0x000000020b0b7212ULL, 0x000fe400078efcffULL,
0x00000040410d723eULL, 0x000fc400000010ffULL, 0x0000001609097c11ULL, 0x000fe4000f8e20ffULL,
0x0000001605057c11ULL, 0x000fe4000f8e20ffULL, 0x0000001604047c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c09007844ULL, 0x0005e20000000200ULL, 0x0000002a2b1b723eULL, 0x000fe400000010ffULL,
0x000000160b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001005007844ULL, 0x0005e80000000200ULL,
0x0000001404007844ULL, 0x0005e80000000200ULL, 0x000000180b007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002400ec8947ULL, 0x000fea0003800000ULL,
0x0000000600027c11ULL, 0x000fe2000f8e20ffULL, 0x00000000000979c3ULL, 0x000fe20000002700ULL,
0x00000010ff007c0cULL, 0x000fe2000bf05270ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x0000920000087ab9ULL, 0x000fe20000000800ULL, 0x01200000020c7984ULL, 0x0045280000000c00ULL,
0x00000000000479c3ULL, 0x000ee20000002600ULL, 0x0122000002107984ULL, 0x0004620000000c00ULL,
0x00000005090972a4ULL, 0x008fc4000f8e0204ULL, 0x00000005110472a4ULL, 0x000fe4000f8e023fULL,
0x00000011090772a4ULL, 0x000fe4000f8e023fULL, 0x00000008040872a4ULL, 0x000fe4000f8e023fULL,
0x00000013070a7290ULL, 0x000fe4000fffe03fULL, 0x01ffffff08177892ULL, 0x000fe2000f8ec03fULL,
0x0000000000380947ULL, 0x004ff60003800000ULL, 0x000000170a0b7290ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x0000980000047ab9ULL, 0x000fe20000000a00ULL,
0x00000001ff047819ULL, 0x000fe20000011600ULL, 0x000000800a0c78a5ULL, 0x000fe4000f8e0004ULL,
0x000000800b0478a5ULL, 0x000fe2000f8e0004ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c040b7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0b047c10ULL, 0x140fe4000fa3e002ULL,
0x000000040b0a7c10ULL, 0x000fe4000fc7e002ULL, 0x0000000dff057c10ULL, 0x000fe40008fe44ffULL,
0x00000005ff0b7c10ULL, 0x000fc60009fe84ffULL, 0x0000000804007986ULL, 0x0005e8000c10190eULL,
0x000000070a007986ULL, 0x0005e4000c10190eULL, 0x00000fff08087891ULL, 0x000fe2000f8e403fULL,
0x000000ff0000720cULL, 0x040fe20000725670ULL, 0x0000980000147ab9ULL, 0x000fe20000000a00ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0x0000000a08047291ULL, 0x000fe2000f8fa03fULL,
0x0000021000007945ULL, 0x000fe60003800000ULL, 0x00001000040478a5ULL, 0x000fc8000f8e0014ULL,
0x00000400100478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff077e24ULL, 0x004fe4000f8e00ffULL, 0x0000001000047825ULL, 0x000fc800078e0006ULL,
0x0000001009067825ULL, 0x000fe200078e0006ULL, 0x0000000c04007986ULL, 0x0105e8000c101d0eULL,
0x0000001006007986ULL, 0x0025e2000c101d0eULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff110a7890ULL, 0x000fe4000fffe03fULL, 0x00000004090478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000aff077e24ULL, 0x004fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ea800099ee1ceULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000a04007c0cULL, 0x000fc8000bf25270ULL, 0x00000001ff027807ULL, 0x000fca0000800000ULL,
0x00000002ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ef00000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000040000097882ULL, 0x000fc40000000000ULL, 0x0000065404097896ULL, 0x008fd20008000009ULL,
0x00000009ff027984ULL, 0x002e640008000000ULL, 0x000000ff0200720cULL, 0x002fda0003f25270ULL,
0x0000002000c09947ULL, 0x000fea0003800000ULL, 0x0000000c008c0947ULL, 0x000fea0003800000ULL,
0x00000011ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000f08947ULL, 0x000fea0003800000ULL,
0x0000000107047890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x00000080070a78a5ULL, 0x000fe4000f8e0014ULL,
0x00000080040478a5ULL, 0x000fe2000f8e0014ULL, 0x0000007002087812ULL, 0x000fe400078ec0ffULL,
0x0000000c03117812ULL, 0x004fc800078ec0ffULL, 0x0000000a11027c10ULL, 0x140fe4000f91e008ULL,
0x0000000411047c10ULL, 0x000fe4000fb5e008ULL, 0x0000000bff037c10ULL, 0x000fe400087e24ffULL,
0x00000005ff057c10ULL, 0x000fc600097e64ffULL, 0x0000000e02067981ULL, 0x000368000c1e1900ULL,
0x0000000e04077981ULL, 0x000362000c1e1900ULL, 0x000000021100788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000000207047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0014ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02097981ULL, 0x000362000c1e1900ULL, 0x000000041100788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000908947ULL, 0x002fea0003800000ULL,
0x0000000307047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0014ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020b7981ULL, 0x000362000c1e1900ULL, 0x000000041100788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000708947ULL, 0x002fea0003800000ULL,
0x0000000407047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0014ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020d7981ULL, 0x000362000c1e1900ULL, 0x000000061100788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000508947ULL, 0x002fea0003800000ULL,
0x0000000507047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0014ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020f7981ULL, 0x000362000c1e1900ULL, 0x000000061100788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x000000081100788cULL, 0x000fe4000bf06070ULL, 0x0000000607047890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f8f008ULL, 0x00000080040478a5ULL, 0x000fc8000f8e0014ULL,
0x00000007070a0890ULL, 0x000fe4000fffe03fULL, 0x0000000411027c10ULL, 0x000fe4000f91e008ULL,
0x000000800a0a08a5ULL, 0x000fe4000f8e0014ULL, 0x00000005ff037c10ULL, 0x000fc800087e24ffULL,
0x0000000a11044c10ULL, 0x000fe4000fb5e008ULL, 0x0000000e02117981ULL, 0x000364000c1e1900ULL,
0x0000000bff054c10ULL, 0x000fca00097e64ffULL, 0x0000000e04134981ULL, 0x000368000c1e1900ULL,
0x00000007110a7890ULL, 0x000fc8000fffe03fULL, 0x000000033f0a7899ULL, 0x000fcc000801160aULL,
0x0000000aff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800688947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x026fe200078e0006ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000980000187ab9ULL, 0x000fca0000000a00ULL, 0x000000110400728cULL, 0x000fe4000bf06070ULL,
0x0000000105057890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000a0500728cULL, 0x000fd8000bf06070ULL, 0x0000000800300947ULL, 0x022fea0003800000ULL,
0x00000008040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000506067209ULL, 0x000fe20007810000ULL,
0x00000001040d7890ULL, 0x000fe4000fffe03fULL, 0x000000110c00728cULL, 0x000fe4000bf26070ULL,
0x000000110d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x000000080b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02057981ULL, 0x000368000c1e1900ULL, 0x0000000400e82947ULL, 0x000fea0003800000ULL,
0x00000009040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fe20007810000ULL,
0x00000002040d7890ULL, 0x000fe4000fffe03fULL, 0x000000110c00728cULL, 0x000fe4000bf26070ULL,
0x000000110d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x000000090b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02077981ULL, 0x000368000c1e1900ULL, 0x0000000400a02947ULL, 0x000fea0003800000ULL,
0x0000000a040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000906067209ULL, 0x000fe20007810000ULL,
0x00000003040d7890ULL, 0x000fe4000fffe03fULL, 0x000000110c00728cULL, 0x000fe4000bf26070ULL,
0x000000110d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000a0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02097981ULL, 0x000368000c1e1900ULL, 0x0000000400582947ULL, 0x000fea0003800000ULL,
0x0000000b040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000b06067209ULL, 0x000fe20007810000ULL,
0x00000004040d7890ULL, 0x000fe4000fffe03fULL, 0x000000110c00728cULL, 0x000fe4000bf26070ULL,
0x000000110d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000b0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020b7981ULL, 0x000368000c1e1900ULL, 0x0000000400102947ULL, 0x000fea0003800000ULL,
0x0000000c040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fe20007810000ULL,
0x00000005040d7890ULL, 0x000fe4000fffe03fULL, 0x000000110c00728cULL, 0x000fe4000bf26070ULL,
0x000000110d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000c0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020d7981ULL, 0x000368000c1e1900ULL, 0x0000000000c82947ULL, 0x000fea0003800000ULL,
0x0000000d040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000f06067209ULL, 0x000fe20007810000ULL,
0x00000006040d7890ULL, 0x000fe4000fffe03fULL, 0x000000110c00728cULL, 0x000fe4000bf26070ULL,
0x000000110d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000d0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020f7981ULL, 0x000368000c1e1900ULL, 0x0000000000802947ULL, 0x000fea0003800000ULL,
0x0000000e040c7890ULL, 0x000fe2000fffe03fULL, 0x0000001106067209ULL, 0x000fe20007810000ULL,
0x00000007040d7890ULL, 0x000fe4000fffe03fULL, 0x000000110c00728cULL, 0x000fe4000bf26070ULL,
0x000000110d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000e0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02117981ULL, 0x000368000c1e1900ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x0000000f040c7890ULL, 0x000fe2000fffe03fULL, 0x0000001306067209ULL, 0x000fc60007810000ULL,
0x000000110c00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000f0b0c7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000c03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000dff037c10ULL, 0x000fca00087e24ffULL, 0x0000000e02137981ULL, 0x000368000c1e1900ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000804047890ULL, 0x000fe4000fffe03fULL,
0x000000080b0b7890ULL, 0x000fd4000fffe03fULL, 0xfffffff400ac8947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x0000001000027824ULL, 0x00afe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000903037c10ULL, 0x000fca000fffe002ULL,
0x0000000603007388ULL, 0x0203e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000007080c7291ULL, 0x000fe2000f8fa03fULL,
0x0000001000027824ULL, 0x040fe200078e00ffULL, 0x00000017070d7290ULL, 0x000fe2000fffe03fULL,
0x00000001ff037819ULL, 0x002fe20000011600ULL, 0x00000009101a7291ULL, 0x000fe2000f8e603fULL,
0x0000002000077836ULL, 0x004fe20000000000ULL, 0x00009800000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x000010000c0478a5ULL, 0x000fe2000f8e000aULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x00000011ff007c0cULL, 0x000fe2000bf25270ULL,
0x00000400100478a5ULL, 0x000fe2000f8e0004ULL, 0x0000000903147c10ULL, 0x000fc4000fffe002ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000800d1888a5ULL, 0x000fe2000f8e000aULL,
0x0000001a000d7c11ULL, 0x040fe2000f8e20ffULL, 0x00000080070a88a5ULL, 0x000fe2000f8e000aULL,
0x00000004ff047e24ULL, 0x000fe2000f8e00ffULL, 0x00000009101b8291ULL, 0x000fe2000f8e403fULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000910048291ULL, 0x000fe2000f8e403fULL,
0x00000018ff087e24ULL, 0x000fe2000f8e00ffULL, 0x0000000014147984ULL, 0x000e620000000800ULL,
0x00000019ff097e24ULL, 0x000fe2000f8e00ffULL, 0x0000001b000f8c11ULL, 0x040fe2000f8e20ffULL,
0x0000001007067825ULL, 0x000fe200078e0004ULL, 0x0000000400118c11ULL, 0x000fc4000f8e20ffULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000aff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000bff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001000047825ULL, 0x000fe200078e0004ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fc4000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000001000088825ULL, 0x040fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000040d7faeULL, 0x0005e2000b901c4eULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000010000a8825ULL, 0x000fe200078e000aULL,
0x00380000060d7faeULL, 0x0005e2000b901c4eULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x04580000080f8faeULL, 0x0005e2000b901c4eULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x041800000a118faeULL, 0x0005e8000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800d09947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x104fe20000011600ULL,
0x000000010d0d7890ULL, 0x000fe2000fffe03fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee200ULL,
0x0000000107047890ULL, 0x000fe2000fffe03fULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000910057291ULL, 0x000fe2000f8e403fULL, 0x00000002ff3b7819ULL, 0x000fe20000011600ULL,
0x0000000805077836ULL, 0x040fe20000000000ULL, 0x0000000404067812ULL, 0x000fe200078efcffULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000000704377812ULL, 0x000fe200078e7805ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x000fe200078e7807ULL,
0x0000000dff367e24ULL, 0x000fe2000f8e00ffULL, 0x00000007063a7812ULL, 0x000fe200078e7807ULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000000706057812ULL, 0x000fe200078e7805ULL,
0x00000004ff3c7e24ULL, 0x000fe2000f8e00ffULL, 0x0000003837377212ULL, 0x080fe200078efcffULL,
0x00000005ff3f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000003805387212ULL, 0x000fe200078efcffULL,
0x000000083b3d7836ULL, 0x000fe20000000000ULL, 0x0000000704397212ULL, 0x080fe200078efcffULL,
0x000000010c0c7890ULL, 0x000fe2000fffe03fULL, 0x000000073a3a7212ULL, 0x000fe200078efcffULL,
0x00000001000a7882ULL, 0x000fe20000000000ULL, 0x0000980000187ab9ULL, 0x000fd20000000a00ULL,
0x000000110a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000900947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x000000010a0d7892ULL, 0x000fe2000f8ec03fULL, 0x00000018ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x000010000c0478a5ULL, 0x000fe4000f8e0018ULL, 0x00000019ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b0a0b7899ULL, 0x000fe2000800063fULL, 0x0000002000077836ULL, 0x000fe20000000000ULL,
0x00000400100478a5ULL, 0x000fe2000f8e0004ULL, 0x0000000dff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x000008000b0b7892ULL, 0x000fc6000f8ec03fULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x0000008036048825ULL, 0x000fe200078e000aULL, 0x0000000b1a0b7290ULL, 0x000fc6000fffe03fULL,
0x00000009101b8291ULL, 0x000fe2000f8e403fULL, 0x00000004ff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x00000009100d8291ULL, 0x000fe2000f8e403fULL, 0x00000005ff0d7e24ULL, 0x000fe4000f8e00ffULL,
0x000000803c0a8825ULL, 0x000fc800078e000aULL, 0x0000001bff3f8e24ULL, 0x000fe4000f8e00ffULL,
0x0000001000088825ULL, 0x000fc800078e0004ULL, 0x000000800e0f8824ULL, 0x000fe400078e023fULL,
0x0000000dff3f8e24ULL, 0x000fe4000f8e00ffULL, 0x0000001007067825ULL, 0x000fc800078e000cULL,
0x0000001000047825ULL, 0x040fe200078e000cULL, 0x0000000b000d7c11ULL, 0x000fc6000f8e20ffULL,
0x000000800e118824ULL, 0x000fe400078e023fULL, 0x00000010000f8824ULL, 0x040fe200078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040d7faeULL, 0x0005e2000b901c4eULL,
0x00000010000a8825ULL, 0x000fc600078e000aULL, 0x00380000060d7faeULL, 0x0005e2000b901c4eULL,
0x0000001000118824ULL, 0x000fc600078e0211ULL, 0x04580000080f8faeULL, 0x0005e8000b901c4eULL,
0x041800000a118faeULL, 0x0005e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff0a047890ULL, 0x000fe2000fffe03fULL, 0x0000000136367836ULL, 0x000fe20000000000ULL,
0x000000110a00728cULL, 0x000fe2000bf06070ULL, 0x000000013c3c7836ULL, 0x000fe20000000000ULL,
0x0000000704057899ULL, 0x000fe4000800063fULL, 0x0000000b04047899ULL, 0x000fe4000800063fULL,
0x0000008005057892ULL, 0x000fe2000f8ec03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000080004047892ULL, 0x000fc4000f8ec03fULL, 0x000000010a0a7890ULL, 0x000fe4000fffe03fULL,
0x0000000502047c10ULL, 0x004fe2000fffe03fULL, 0x000001801a047890ULL, 0x000fe4000fffe004ULL,
0x000000010c0c7890ULL, 0x000fe4000fffe03fULL, 0x00000001033e7824ULL, 0x000fe400078e0204ULL,
0x0000000437047c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003e0d7984ULL, 0x000ea20000000800ULL, 0x0000000438087c11ULL, 0x000fe4000f8e20ffULL,
0x00000004390c7c11ULL, 0x000fe2000f8e20ffULL, 0x004580003e407984ULL, 0x000fe20000000800ULL,
0x000000043a107c11ULL, 0x000fc6000f8e20ffULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000808783bULL, 0x000f220000000200ULL, 0x0000000d14117221ULL, 0x006fc60000010100ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x3fb8aa3b11457820ULL, 0x000fc60000410000ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x00010000043e7824ULL, 0x048fe200078e00ffULL,
0x0000763204047816ULL, 0x000fe20000000004ULL, 0x0000004500457308ULL, 0x000ee20000000800ULL,
0x0001000005427824ULL, 0x000fe200078e00ffULL, 0x0000763209467816ULL, 0x050fe20000000046ULL,
0x0001000009487824ULL, 0x000fe200078e00ffULL, 0x0000763206417816ULL, 0x040fe20000000041ULL,
0x000100000b4a7824ULL, 0x040fe200078e00ffULL, 0x000076320b477816ULL, 0x000fe20000000047ULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x0000763207437816ULL, 0x040fe20000000043ULL,
0x0001000007447824ULL, 0x000fe200078e00ffULL, 0x000076320a097816ULL, 0x040fe20000000009ULL,
0x000100000a0a7824ULL, 0x000fc400078e00ffULL, 0x0001000041417824ULL, 0x000fe400078e00ffULL,
0x0000004045527220ULL, 0x008fe20000410000ULL, 0x0000763205407816ULL, 0x000fe20000000040ULL,
0x0001000004057824ULL, 0x000fe200078e00ffULL, 0x0000763208457816ULL, 0x000fe20000000045ULL,
0x0000003552357221ULL, 0x000fe20000010000ULL, 0x00001f3b52517589ULL, 0x000ee200000e0000ULL,
0x0001000008087824ULL, 0x000fe400078e00ffULL, 0x0001000040077824ULL, 0x000fe200078e00ffULL,
0x00001f3d52527589ULL, 0x000f2200000e0000ULL, 0x0001000043437824ULL, 0x000fc400078e00ffULL,
0x0001000045457824ULL, 0x000fe400078e00ffULL, 0x0001000009097824ULL, 0x000fe400078e00ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x000076320f4b7816ULL, 0x042fe2000000004bULL,
0x000100000f4e7824ULL, 0x000fe200078e00ffULL, 0x000076320d497816ULL, 0x040fe20000000049ULL,
0x000100000d4c7824ULL, 0x000fe200078e00ffULL, 0x00007632100f7816ULL, 0x044fe2000000000fULL,
0x00010000104d7824ULL, 0x000fe200078e00ffULL, 0x0000763211107816ULL, 0x040fe20000000010ULL,
0x0001000011507824ULL, 0x000fe200078e00ffULL, 0x000076320c0b7816ULL, 0x040fe2000000000bULL,
0x000100000c0c7824ULL, 0x000fe200078e00ffULL, 0x000076320e0d7816ULL, 0x040fe2000000000dULL,
0x000100000e0e7824ULL, 0x000fc400078e00ffULL, 0x00000051052c7223ULL, 0x088fe2000001002cULL,
0x0000763212117816ULL, 0x000fe20000000011ULL, 0x0001000046057824ULL, 0x000fe200078e00ffULL,
0x00007632134f7816ULL, 0x000fe2000000004fULL, 0x0000005106297223ULL, 0x080fe20000010029ULL,
0x0001000012127824ULL, 0x000fe400078e00ffULL, 0x0000005105227223ULL, 0x080fe20000010022ULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x000000513e2d7223ULL, 0x000fe2000001002dULL,
0x000100000b0b7824ULL, 0x000fc400078e00ffULL, 0x00000051422b7223ULL, 0x080fe2000001002bULL,
0x0001000049497824ULL, 0x000fe400078e00ffULL, 0x00000051072a7223ULL, 0x080fe2000001002aULL,
0x000100000d0d7824ULL, 0x000fe400078e00ffULL, 0x0000005141287223ULL, 0x080fe20000010028ULL,
0x000100004b4b7824ULL, 0x000fe400078e00ffULL, 0x0000005144277223ULL, 0x000fe20000010027ULL,
0x000100000f0f7824ULL, 0x000fc400078e00ffULL, 0x0000005143267223ULL, 0x080fe20000010026ULL,
0x0001000010057824ULL, 0x000fe400078e00ffULL, 0x0000005108257223ULL, 0x080fe20000010025ULL,
0x0001000011047824ULL, 0x000fe400078e00ffULL, 0x0000005145247223ULL, 0x080fe20000010024ULL,
0x000100004f067824ULL, 0x000fe400078e00ffULL, 0x0000005148237223ULL, 0x080fe20000010023ULL,
0x000000510a217223ULL, 0x080fe20000010021ULL, 0x0000005109207223ULL, 0x080fe20000010020ULL,
0x000000514a1f7223ULL, 0x080fe2000001001fULL, 0x00000051471e7223ULL, 0x000fe2000001001eULL,
0x000000520c1d7223ULL, 0x090fe2000001001dULL, 0x000000520b1c7223ULL, 0x080fe2000001001cULL,
0x000000524c1b7223ULL, 0x080fe2000001001bULL, 0x00000052491a7223ULL, 0x080fe2000001001aULL,
0x000000520e197223ULL, 0x080fe20000010019ULL, 0x000000520d187223ULL, 0x080fe20000010018ULL,
0x000000524e177223ULL, 0x080fe20000010017ULL, 0x000000524b167223ULL, 0x080fe20000010016ULL,
0x000000524d347223ULL, 0x080fe20000010034ULL, 0x000000520f327223ULL, 0x080fe20000010032ULL,
0x0000005250317223ULL, 0x080fe20000010031ULL, 0x0000005205307223ULL, 0x080fe20000010030ULL,
0x00000052122f7223ULL, 0x080fe2000001002fULL, 0x0000005204337223ULL, 0x080fe20000010033ULL,
0x00000052132e7223ULL, 0x080fe2000001002eULL, 0x0000005206157223ULL, 0x000fe20000010015ULL,
0xfffffff4009c8947ULL, 0x000fec000383ffffULL, 0x0180000035007836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe80000010000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000b9c000027802ULL, 0x000fce0000000f00ULL, 0x0000009800ac7944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000003500027308ULL, 0x000ee40000001000ULL, 0xbf80000002007423ULL, 0x008fc80000000035ULL,
0x800000ff00037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fce0000000002ULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x00000002ff097819ULL, 0x10cfe40000011600ULL,
0x00000008000b7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0902047589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff0f7812ULL, 0x000fc600078ee200ULL, 0x00001f0b020c7589ULL, 0x00072400000e0000ULL,
0x000000080f137836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000002d042d7220ULL, 0x044fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002b04057220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002904067220ULL, 0x040fe20000410000ULL, 0x0000002804077220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002504087220ULL, 0x040fe20000410000ULL, 0x0000002404097220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x00000021040a7220ULL, 0x040fe20000410000ULL, 0x00000020040b7220ULL, 0x048fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x000fe20000410000ULL,
0x0000000303047812ULL, 0x000fe200078ec0ffULL, 0x0000001d0c1d7220ULL, 0x050fe20000410000ULL,
0x0000001c0c1c7220ULL, 0x040fe20000410000ULL, 0x0000001b0c1b7220ULL, 0x000fe20000410000ULL,
0x00000004040e7812ULL, 0x000fe200078efcffULL, 0x0000001a0c1a7220ULL, 0x040fe20000410000ULL,
0x000000190c197220ULL, 0x040fe20000410000ULL, 0x000000180c187220ULL, 0x040fe20000410000ULL,
0x000000170c177220ULL, 0x040fe20000410000ULL, 0x000000160c167220ULL, 0x040fe20000410000ULL,
0x000000340c347220ULL, 0x040fe20000410000ULL, 0x000000320c0d7220ULL, 0x040fe20000410000ULL,
0x000000310c317220ULL, 0x040fe20000410000ULL, 0x000000300c307220ULL, 0x040fe20000410000ULL,
0x0000002f0c2f7220ULL, 0x040fe20000410000ULL, 0x000000330c027220ULL, 0x040fe20000410000ULL,
0x0000002e0c2e7220ULL, 0x040fe20000410000ULL, 0x000000150c157220ULL, 0x000fe20000410000ULL,
0x000000080f0c7824ULL, 0x000fe200078e00ffULL, 0x0000000704117812ULL, 0x000fc400078e780fULL,
0x0000000704217812ULL, 0x000fe200078e7813ULL, 0x0000000813047824ULL, 0x000fe200078e00ffULL,
0x000000070e0f7812ULL, 0x000fe400078e780fULL, 0x000000070e137812ULL, 0x000fe400078e7813ULL,
0x0000000c11117212ULL, 0x080fe400078efcffULL, 0x0000000c0f0f7212ULL, 0x000fe400078efcffULL,
0x0000000421217212ULL, 0x000fc400078efcffULL, 0x0000000413137212ULL, 0x000fe400078efcffULL,
0x000000060706723eULL, 0x000fe400000010ffULL, 0x0000002d2c04723eULL, 0x000fe400000010ffULL,
0x000000052a05723eULL, 0x000fe400000010ffULL, 0x000000272607723eULL, 0x000fe400000010ffULL,
0x000000080908723eULL, 0x000fc400000010ffULL, 0x0000000a0b0a723eULL, 0x000fe400000010ffULL,
0x0000001611117c11ULL, 0x000fe4000f8e20ffULL, 0x000000232209723eULL, 0x000fe400000010ffULL,
0x0000001f1e0b723eULL, 0x000fe200000010ffULL, 0x0000000411007844ULL, 0x0005e20000000200ULL,
0x0000001d1c1c723eULL, 0x000fe400000010ffULL, 0x000000160f0f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000001b1a1d723eULL, 0x000fe400000010ffULL, 0x00000019181e723eULL, 0x000fe200000010ffULL,
0x000000080f007844ULL, 0x0005e20000000200ULL, 0x00000017161f723eULL, 0x000fe400000010ffULL,
0x0000001621217c11ULL, 0x000fe4000f8e20ffULL, 0x000000340d34723eULL, 0x000fe400000010ffULL,
0x000000313035723eULL, 0x002fe200000010ffULL, 0x0000001c21007844ULL, 0x0005e20000000200ULL,
0x0000002f0236723eULL, 0x000fc400000010ffULL, 0x0000002e1537723eULL, 0x000fe400000010ffULL,
0x0000001613137c11ULL, 0x000fca000f8e20ffULL, 0x0000003413007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000057919ULL, 0x004ea20000002600ULL,
0x0000002000117836ULL, 0x000fe20000000000ULL, 0x0000000703077812ULL, 0x000fe200078e4800ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000012ff127e24ULL, 0x000fe2000f8e00ffULL, 0x00000003ff027819ULL, 0x000fe20000011611ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0ffffff807077812ULL, 0x000fe200078ef800ULL,
0x00000012ff137e24ULL, 0x000fe2000f8e00ffULL, 0x0000000702047812ULL, 0x000fc400078e4811ULL,
0x0000000607087c11ULL, 0x000fe4000f8e20ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef811ULL,
0x0000000700077812ULL, 0x000fe400078ec0ffULL, 0x0000000604047c11ULL, 0x000fe2000f8e20ffULL,
0x0120000008087984ULL, 0x000f220000000c00ULL, 0x0000000711007812ULL, 0x000fe400078ec0ffULL,
0x1ffffff807077812ULL, 0x000fe200078ef812ULL, 0x01200000040c7984ULL, 0x000b220000000c00ULL,
0x1ffffff800117812ULL, 0x000fe200078ef813ULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000805067824ULL, 0x004fc400078e00ffULL, 0x0000000805057824ULL, 0x000fc600078e00ffULL,
0xfffffff806037812ULL, 0x000fe400078ee203ULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402057c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe40000000a00ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x020fc4000f8248ffULL, 0x0000000503037c11ULL, 0x000fe400080f4c10ULL,
0x0000000505057c11ULL, 0x000fe200088f4c06ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d0eULL,
0x0000000c04007986ULL, 0x002fe2000c101d0eULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00004400013c7983ULL, 0x000ea20000100800ULL, 0x000000013f097899ULL, 0x000fe20008011610ULL,
0x00000001ff027424ULL, 0x000fcc00078e00ffULL, 0x01c60002ff0279a7ULL, 0x000e620008500006ULL,
0x000000003c1272caULL, 0x004fda00000e0000ULL, 0x0000000912097291ULL, 0x000fc8000f8e083fULL,
0x000000040900728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fca0003f0f008ULL,
0x00000001080c8899ULL, 0x000fe2000800063fULL, 0x00009000000a8ab9ULL, 0x000fc60000000800ULL,
0x0000000a0c0c82a4ULL, 0x000fc6000f8e0209ULL, 0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL,
0x000000040c0a88a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff047e24ULL, 0x000fe4000f8e00ffULL,
0x0000000bff057e24ULL, 0x000fca000f8e00ffULL, 0x0000000e04048981ULL, 0x000ea2000c1e1900ULL,
0x000000013c067836ULL, 0x000fe20000000000ULL, 0x0000000610137899ULL, 0x000fe2000800063fULL,
0x00000000003e7919ULL, 0x000e620000000000ULL, 0x0000000707077899ULL, 0x000fe4000800063fULL,
0x00000013120c7291ULL, 0x000fe4000f8e403fULL, 0x000000070d0a7899ULL, 0x000fe2000800063fULL,
0xffffffff00157882ULL, 0x000fe20000000000ULL, 0x00000040070d7892ULL, 0x000fe2000f8ef80cULL,
0x00000000040b82caULL, 0x004fc400000e0000ULL, 0x0000000506007c0cULL, 0x000fd6000bf06070ULL,
0x0000000b00158c82ULL, 0x000fe40008000000ULL, 0x0000000a151272a4ULL, 0x000fe2000f8e023fULL,
0x0000000c00a88947ULL, 0x002ff60003800000ULL, 0x00000003ff047819ULL, 0x000fe2000001163eULL,
0x0000000c1400728cULL, 0x000fe2000bf01070ULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x00008a0000167ab9ULL, 0x000fe40000000a00ULL, 0x0000000804097836ULL, 0x040fe20000000000ULL,
0x0000000c140b7287ULL, 0x000fe2000c000000ULL, 0x0000000d04057c36ULL, 0x040fe40008000000ULL,
0x00000008090b7824ULL, 0x040fe200078e00ffULL, 0x0000000b0c0b7290ULL, 0x000fe2000fffe13fULL,
0x0000003e09087212ULL, 0x0c0fe200078e3cffULL, 0x0000000404067836ULL, 0x040fe20000000000ULL,
0x00000006100c7291ULL, 0x000fe2000f8e703fULL, 0x0000000c040c7836ULL, 0x000fe20000000000ULL,
0xfffffff80b167812ULL, 0x000fe200078ee208ULL, 0x00000008060e7824ULL, 0x000fe200078e00ffULL,
0x0000001205087c10ULL, 0x000fe2000ff1e0ffULL, 0x000000080c0d7824ULL, 0x000fe200078e00ffULL,
0x0000003e06077212ULL, 0x0c0fe200078e3cffULL, 0x0000000d06057c36ULL, 0x040fe20008000000ULL,
0x0000000b06007c0cULL, 0x000fe2000bf46070ULL, 0x0000000d09067c36ULL, 0x040fe20008000000ULL,
0x0000003e0c0a7212ULL, 0x000fe200078e3cffULL, 0x0000001004107836ULL, 0x040fe20000000000ULL,
0xfffffff80e157812ULL, 0x000fe200078ee207ULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0xfffffff80d187812ULL, 0x000fe200078ee20aULL, 0x0000001404177836ULL, 0x000fe20000000000ULL,
0x00000016080d7c11ULL, 0x000fe2000f8248ffULL, 0x00000008101a7824ULL, 0x040fe200078e00ffULL,
0x0000001206147c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000d10067c36ULL, 0x000fe20008000000ULL,
0x0000001708087c11ULL, 0x000fe200088f4c07ULL, 0x000020000c0c7890ULL, 0x000fe2000fffe03fULL,
0x00000012050a7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x0000001614137c11ULL, 0x000fe2000f8848ffULL, 0x0000000d0c057c36ULL, 0x000fe20008000000ULL,
0x0000000b09007c0cULL, 0x000fe2000bf06070ULL, 0x000000ffff0b7224ULL, 0x000fe200018e06ffULL,
0x000000160a097c11ULL, 0x000fe2000f8648ffULL, 0x00000008171c7824ULL, 0x000fe200078e00ffULL,
0x0000001714147c11ULL, 0x000fe2000a0f4c07ULL, 0x0000001c041d7836ULL, 0x000fe20000000000ULL,
0x0000001206067c10ULL, 0x000fc4000ff9e0ffULL, 0x000000170a0a7c11ULL, 0x000fe400098f4c0bULL,
0x00000012050e7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff057224ULL, 0x000fe200020e06ffULL,
0x0000001606197c11ULL, 0x000fe4000f8a48ffULL, 0x0000003e100b7212ULL, 0x000fe200078e3cffULL,
0x000000ffff077224ULL, 0x000fe200018e06ffULL, 0x0000001706127c11ULL, 0x000fe2000a8f4c05ULL,
0x0000000d17057c36ULL, 0x000fe20008000000ULL, 0x000000160e0f7c11ULL, 0x000fc4000f8648ffULL,
0x0000000b10007c0cULL, 0x000fe4000bf86070ULL, 0x0000001205107c10ULL, 0x000fe4000ffde0ffULL,
0x000000170e0e7c11ULL, 0x000fe400098f4c07ULL, 0x0000000704077812ULL, 0x000fe400078e483eULL,
0x0000000d00067210ULL, 0x000fe40007fbe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0x0000000b04007c0cULL, 0x000fc4000bf66070ULL,
0x0000000b0c007c0cULL, 0x000fe4000bf26070ULL, 0x0000001610117c11ULL, 0x040fe4000f8c48ffULL,
0x0ffffff8070c7812ULL, 0x000fe200078ef83eULL, 0x000000ffff077224ULL, 0x000fe200028e0608ULL,
0x0000003e17057212ULL, 0x080fe400078e3cffULL, 0x0000000900087210ULL, 0x000fe40007fbe0ffULL,
0x0000001710107c11ULL, 0x000fe2000b0f4c0bULL, 0x00000018040b7836ULL, 0x000fe20000000000ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL, 0x000000ffff097224ULL, 0x000fe200028e060aULL,
0x0000000c0c057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000d0b0a7c36ULL, 0x000fe20008000000ULL,
0x0000000c150d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000080b1e7824ULL, 0x000fe200078e00ffULL,
0x0000000b17007c0cULL, 0x000fe2000bfa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000d901c4eULL, 0x0000003e0b1b7212ULL, 0x000fc400078e3cffULL,
0x0000000b0b007c0cULL, 0x000fe2000bf66070ULL, 0x00000000080d7faeULL, 0x0005e2000d101c4eULL,
0x000000120a177c10ULL, 0x000fe4000ff5e0ffULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee21bULL,
0x0000001617157c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x00000013000a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000d1d057c36ULL, 0x002fc60008000000ULL,
0x0000001717177c11ULL, 0x000fe2000b0f4c0cULL, 0x000000ffff0b7224ULL, 0x000fe200010e0614ULL,
0x0000001205147c10ULL, 0x000fe2000ffde0ffULL, 0x000000081d087824ULL, 0x044fe200078e00ffULL,
0x0000003e1d057212ULL, 0x000fe400078e3cffULL, 0x0000000f00067210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x0000001614137c11ULL, 0x000fe4000f8c48ffULL,
0xfffffff8081f7812ULL, 0x000fe200078ee205ULL, 0x0000002004087836ULL, 0x000fe20000000000ULL,
0x0000000c16057c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff077224ULL, 0x000fe200010e060eULL,
0x0000001714147c11ULL, 0x000fe2000b0f4c09ULL, 0x0000000d08097c36ULL, 0x000fe20008000000ULL,
0x0000000c180d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a057faeULL, 0x0003e2000c101c4eULL,
0x00000024040e7836ULL, 0x000fe20000000000ULL, 0x0000000b08007c0cULL, 0x040fe2000bf06070ULL,
0x00000008080c7824ULL, 0x000fe200078e00ffULL, 0x00000000060d7faeULL, 0x0005e2000c901c4eULL,
0x0000001209187c10ULL, 0x000fc4000ff3e0ffULL, 0x0000003e08097212ULL, 0x000fe400078e3cffULL,
0x0000000b1d007c0cULL, 0x000fe2000bf46070ULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x0000001900087210ULL, 0x000fe20007f3e0ffULL, 0x0000000d0e057c36ULL, 0x002fe20008000000ULL,
0x00000016181d7c11ULL, 0x000fe2000f8c48ffULL, 0x000000080e0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x000000ffff097224ULL, 0x000fe200008e0612ULL,
0x0000001718187c11ULL, 0x000fc4000b0f4c0fULL, 0x0000001100067210ULL, 0x004fe40007f3e0ffULL,
0x0000001205127c10ULL, 0x000fe4000ffde0ffULL, 0x0000003e0e057212ULL, 0x040fe200078e3cffULL,
0x000000ffff077224ULL, 0x000fe200008e0610ULL, 0x0000000b0e007c0cULL, 0x000fe2000bf26070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0x00000016121b7c11ULL, 0x000fe2000f8c48ffULL,
0x0000002c04107836ULL, 0x040fe20000000000ULL, 0xfffffff80a0e7812ULL, 0x000fe200078ee205ULL,
0x00000028040a7836ULL, 0x000fe20000000000ULL, 0x0000000c1a057c11ULL, 0x000fc4000f8e20ffULL,
0x0000001712127c11ULL, 0x000fe2000b0f4c0bULL, 0x0000000d0a0b7c36ULL, 0x000fe20008000000ULL,
0x0000000c1c0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000008057faeULL, 0x0003e2000e101c4eULL,
0x0000000b0a007c0cULL, 0x040fe2000bf86070ULL, 0x000000080a1a7824ULL, 0x040fe400078e00ffULL,
0x00000000060d7faeULL, 0x0005e2000e901c4eULL, 0x000000120b167c10ULL, 0x000fe4000ffbe0ffULL,
0x0000003e0a0b7212ULL, 0x000fc400078e3cffULL, 0x0000001616197c11ULL, 0x000fe2000f8c48ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00000015000a7210ULL, 0x000fe20007fbe0ffULL,
0x0000000d10057c36ULL, 0x042fe20008000000ULL, 0xfffffff81a0f7812ULL, 0x000fe200078ee20bULL,
0x0000000810087824ULL, 0x000fe200078e00ffULL, 0x0000001716167c11ULL, 0x000fe2000b0f4c11ULL,
0x000000ffff0b7224ULL, 0x000fe200028e0617ULL, 0x0000001300067210ULL, 0x004fe20007fbe0ffULL,
0x0000003404117836ULL, 0x000fe20000000000ULL, 0x00000012051a7c10ULL, 0x000fc4000ffde0ffULL,
0x0000003e10057212ULL, 0x040fe200078e3cffULL, 0x000000ffff077224ULL, 0x000fe200028e0614ULL,
0x0000000b10007c0cULL, 0x000fe2000bfa6070ULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x000000161a177c11ULL, 0x000fe4000f8c48ffULL, 0xfffffff808107812ULL, 0x000fe200078ee205ULL,
0x0000003004087836ULL, 0x000fe20000000000ULL, 0x0000000c1e057c11ULL, 0x000fe4000f8e20ffULL,
0x000000171a1a7c11ULL, 0x000fe2000b0f4c09ULL, 0x0000000d08097c36ULL, 0x040fe20008000000ULL,
0x0000000c1f0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000000a057faeULL, 0x0003e2000d901c4eULL,
0x0000000b08007c0cULL, 0x040fe2000bf66070ULL, 0x00000008081c7824ULL, 0x000fc400078e00ffULL,
0x00000000060d7faeULL, 0x0005e2000d101c4eULL, 0x0000001209147c10ULL, 0x000fe4000ff5e0ffULL,
0x0000003e08097212ULL, 0x000fe400078e3cffULL, 0x0000001614157c11ULL, 0x040fe2000f8c48ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x0000001d00087210ULL, 0x000fe20007f5e0ffULL,
0x0000000d11057c36ULL, 0x042fe20008000000ULL, 0xfffffff81c0a7812ULL, 0x000fe200078ee209ULL,
0x00000008111c7824ULL, 0x000fe200078e00ffULL, 0x0000001714147c11ULL, 0x000fe2000b0f4c13ULL,
0x000000ffff097224ULL, 0x000fe200010e0618ULL, 0x0000001205187c10ULL, 0x000fc4000ffde0ffULL,
0x0000001b00067210ULL, 0x004fe40007f5e0ffULL, 0x0000003e11057212ULL, 0x080fe200078e3cffULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x00000016181b7c11ULL, 0x000fe2000f8c48ffULL,
0x000000ffff077224ULL, 0x000fe200010e0612ULL, 0xfffffff81c127812ULL, 0x000fe200078ee205ULL,
0x0000003804057836ULL, 0x000fe20000000000ULL, 0x0000000c0c0b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000001718187c11ULL, 0x000fe2000b0f4c0dULL, 0x0000000d050c7c36ULL, 0x000fe20008000000ULL,
0x0000000c0e0d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000080b7faeULL, 0x0003e2000c101c4eULL,
0x0000000b11007c0cULL, 0x000fe2000bf46070ULL, 0x0000003c04117836ULL, 0x000fe20000000000ULL,
0x000000120c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x00000000060d7faeULL, 0x0005e2000c901c4eULL,
0x0000001900047210ULL, 0x000fe20007f3e0ffULL, 0x00000008051d7824ULL, 0x040fe200078e00ffULL,
0x0000003e050e7212ULL, 0x040fe200078e3cffULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0000000b05007c0cULL, 0x000fe2000bf06070ULL, 0x000000ffff057224ULL, 0x000fe200008e0616ULL,
0x000000160c197c11ULL, 0x000fc4000f8c48ffULL, 0x0000001700087210ULL, 0x002fe40007f3e0ffULL,
0x000000170c167c11ULL, 0x000fe2000b0f4c13ULL, 0x0000000d11067c36ULL, 0x044fe20008000000ULL,
0xfffffff81d0d7812ULL, 0x000fe200078ee20eULL, 0x000000ffff097224ULL, 0x000fe200008e061aULL,
0x0000003e110b7212ULL, 0x040fe200078e3cffULL, 0x00000008110e7824ULL, 0x000fe200078e00ffULL,
0x00000012060c7c10ULL, 0x000fe4000ffde0ffULL, 0x0000001500067210ULL, 0x000fc40007f3e0ffULL,
0x0000000c0a157c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x000000160c177c11ULL, 0x040fe2000f8c48ffULL, 0x000000ffff077224ULL, 0x000fe200008e0614ULL,
0x0000000b11007c0cULL, 0x000fe4000bf26070ULL, 0x0000000c0f117c11ULL, 0x000fe4000f8e20ffULL,
0x000000170c0f7c11ULL, 0x000fe4000b0f4c13ULL, 0x0000000c10137c11ULL, 0x000fe2000f8e20ffULL,
0x0000000004117faeULL, 0x0003e2000e101c4eULL, 0xfffffff80e147812ULL, 0x000fc400078ee20bULL,
0x00000019000c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000008137faeULL, 0x0003e2000e901c4eULL,
0x00000017000e7210ULL, 0x000fe40007fbe0ffULL, 0x0000000c12177c11ULL, 0x000fe2000f8e20ffULL,
0x0000000006157faeULL, 0x0003e2000d901c4eULL, 0x0000001b000a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200028e060fULL, 0x0000000c0d197c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e0616ULL, 0x0000000c141b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0b7224ULL, 0x000fca00018e0618ULL, 0x000000000a177faeULL, 0x0003e8000d101c4eULL,
0x000000000c197faeULL, 0x0003e8000c101c4eULL, 0x000000000e1b7faeULL, 0x0003e2000c901c4eULL,
0x0000000c00587947ULL, 0x000fea0003800000ULL, 0x00000003ff147819ULL, 0x000fe2000001163eULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x00000006100b7291ULL, 0x000fe4000f8e703fULL, 0x0000000c141b7836ULL, 0x040fe40000000000ULL,
0x0000000414127836ULL, 0x040fe20000000000ULL, 0x000020000b0b7890ULL, 0x000fe2000fffe03fULL,
0x000000081b047824ULL, 0x040fe200078e00ffULL, 0x0000003e1b0f7212ULL, 0x080fe200078e3cffULL,
0x00000014141d7836ULL, 0x000fe20000000000ULL, 0x0000003e12087212ULL, 0x080fe200078e3cffULL,
0x0000001c14227836ULL, 0x000fe20000000000ULL, 0xfffffff8040f7812ULL, 0x000fe200078ee20fULL,
0x0000000812057824ULL, 0x000fe200078e00ffULL, 0x0000003e1d0d7212ULL, 0x0c0fe200078e3cffULL,
0x000000081d067824ULL, 0x000fe200078e00ffULL, 0x0000003e220b7212ULL, 0x080fe200078e3cffULL,
0x00000008141a7836ULL, 0x000fe20000000000ULL, 0xfffffff805087812ULL, 0x000fe200078ee208ULL,
0x0000000822047824ULL, 0x000fe200078e00ffULL, 0xfffffff8060d7812ULL, 0x000fe200078ee20dULL,
0x0000002414267836ULL, 0x000fe20000000000ULL, 0x0000003e1a107212ULL, 0x080fe200078e3cffULL,
0x0000002814287836ULL, 0x000fe20000000000ULL, 0xfffffff8040b7812ULL, 0x000fe200078ee20bULL,
0x000000081a057824ULL, 0x000fe200078e00ffULL, 0x0000003e26097212ULL, 0x080fe200078e3cffULL,
0x00000010141c7836ULL, 0x000fe20000000000ULL, 0x0000003e28047212ULL, 0x080fe200078e3cffULL,
0x0000000826067824ULL, 0x000fe200078e00ffULL, 0xfffffff805107812ULL, 0x000fe200078ee210ULL,
0x0000000828117824ULL, 0x000fe200078e00ffULL, 0x0000003e1c0e7212ULL, 0x080fe200078e3cffULL,
0x0000001814207836ULL, 0x040fe20000000000ULL, 0xfffffff806097812ULL, 0x000fe200078ee209ULL,
0x0000003014327836ULL, 0x000fe20000000000ULL, 0xfffffff811047812ULL, 0x000fe200078ee204ULL,
0x000000081c077824ULL, 0x000fe200078e00ffULL, 0x0000003e200c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000820057824ULL, 0x000fe200078e00ffULL, 0x0000003e32067212ULL, 0x0c0fe200078e3cffULL,
0x0000000832137824ULL, 0x000fe200078e00ffULL, 0xfffffff8070e7812ULL, 0x000fe200078ee20eULL,
0x0000002014247836ULL, 0x040fe20000000000ULL, 0xfffffff8050c7812ULL, 0x000fe200078ee20cULL,
0x0000002c14307836ULL, 0x040fe20000000000ULL, 0xfffffff813067812ULL, 0x000fe200078ee206ULL,
0x0000000d14117c36ULL, 0x000fe20008000000ULL, 0x0000003e240a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000824077824ULL, 0x000fe200078e00ffULL, 0x0000003e30057212ULL, 0x0c0fe200078e3cffULL,
0x0000000830167824ULL, 0x000fe200078e00ffULL, 0x0000001211137c10ULL, 0x000fe2000ff1e0ffULL,
0x0000003414347836ULL, 0x000fe20000000000ULL, 0xfffffff8070a7812ULL, 0x000fe200078ee20aULL,
0x0000000d12127c36ULL, 0x000fe20008000000ULL, 0xfffffff816057812ULL, 0x000fe200078ee205ULL,
0x0000000834187824ULL, 0x040fe200078e00ffULL, 0x0000003e34077212ULL, 0x080fe200078e3cffULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x0000001212177c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000d1a1a7c36ULL, 0x000fe20008000000ULL, 0x0000001613157c11ULL, 0x040fe2000f8048ffULL,
0x0000000d1c1c7c36ULL, 0x000fe20008000000ULL, 0xfffffff818077812ULL, 0x000fe200078ee207ULL,
0x0000003814387836ULL, 0x040fe20000000000ULL, 0x0000001713167c11ULL, 0x000fe200080f4c16ULL,
0x0000003c143a7836ULL, 0x000fe20000000000ULL, 0x000000121a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x0000001617197c11ULL, 0x000fe2000f8248ffULL,
0x0000000d1b1b7c36ULL, 0x000fe20008000000ULL, 0x000000121c1c7c10ULL, 0x000fe2000ff5e0ffULL,
0x00000008382a7824ULL, 0x040fe200078e00ffULL, 0x0000003e38117212ULL, 0x080fe200078e3cffULL,
0x000000083a1f7824ULL, 0x040fe200078e00ffULL, 0x0000003e3a1e7212ULL, 0x000fe200078e3cffULL,
0x0000000d1d1d7c36ULL, 0x000fe20008000000ULL, 0x0000001717137c11ULL, 0x000fe200088f4c18ULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x000000121b187c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0x000000161a1b7c11ULL, 0x000fe2000f8048ffULL,
0x0000000d20207c36ULL, 0x000fe20008000000ULL, 0x000000161c257c11ULL, 0x000fe2000f8448ffULL,
0x0000000d24247c36ULL, 0x000fe20008000000ULL, 0xfffffff82a127812ULL, 0x000fe200078ee211ULL,
0x0000000d22227c36ULL, 0x000fe20008000000ULL, 0xfffffff81f117812ULL, 0x000fe200078ee21eULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x000000121d1e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000d26267c36ULL, 0x000fe20008000000ULL, 0x000000171a1d7c11ULL, 0x000fe200080f4c17ULL,
0x0000000d28287c36ULL, 0x000fe20008000000ULL, 0x000000171c237c11ULL, 0x000fe200090f4c23ULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x0000001618217c11ULL, 0x000fe2000f8248ffULL,
0x0000000d32327c36ULL, 0x000fe20008000000ULL, 0x0000001220207c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000d30307c36ULL, 0x000fe20008000000ULL, 0x0000001224247c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000d34347c36ULL, 0x000fe20008000000ULL, 0x000000161e297c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00000017181f7c11ULL, 0x000fe200088f4c1fULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x0000001222227c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000d38387c36ULL, 0x000fe20008000000ULL, 0x00000016202b7c11ULL, 0x000fe2000f8048ffULL,
0x0000000d3a3a7c36ULL, 0x000fe20008000000ULL, 0x0000001624317c11ULL, 0x000fc4000f8448ffULL,
0x000000171e2a7c11ULL, 0x000fe200098f4c27ULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x0000001226267c10ULL, 0x000fe4000ff7e0ffULL, 0x00000017202c7c11ULL, 0x000fe400080f4c17ULL,
0x00000017242f7c11ULL, 0x000fe200090f4c2fULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x00000016222d7c11ULL, 0x000fe4000f8248ffULL, 0x0000001228287c10ULL, 0x000fc4000ff1e0ffULL,
0x0000001232327c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001626357c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00000017222e7c11ULL, 0x000fe200088f4c27ULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x0000001230307c10ULL, 0x000fe4000ff3e0ffULL,
0x0000001628377c11ULL, 0x000fe4000f8048ffULL, 0x00000016323d7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x0000001726337c11ULL, 0x000fc400098f4c33ULL,
0x0000001234187c10ULL, 0x000fe4000ff7e0ffULL, 0x0000001728347c11ULL, 0x000fe400080f4c17ULL,
0x00000017323b7c11ULL, 0x000fe200090f4c3bULL, 0x000000ffff3f7224ULL, 0x000fe200018e06ffULL,
0x0000001630397c11ULL, 0x000fe4000f8248ffULL, 0x0000001238387c10ULL, 0x000fe4000ff1e0ffULL,
0x000000123a3a7c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000714147812ULL, 0x000fe400078e483eULL,
0x0000001730367c11ULL, 0x000fe200088f4c27ULL, 0x000000ffff277224ULL, 0x000fe200000e06ffULL,
0x0ffffff814177812ULL, 0x000fe200078ef83eULL, 0x000000ffff457224ULL, 0x000fe200010e06ffULL,
0x0000001618417c11ULL, 0x000fe4000f8648ffULL, 0x000000163a477c11ULL, 0x000fe4000f8448ffULL,
0x0000001500147210ULL, 0x000fc40007f1e0ffULL, 0x0000001638437c11ULL, 0x000fe4000f8248ffULL,
0x00000017183f7c11ULL, 0x000fe200098f4c3fULL, 0x000000ffff157224ULL, 0x000fe200000e0616ULL,
0x000000173a457c11ULL, 0x000fe400090f4c45ULL, 0x0000001738387c11ULL, 0x000fe400088f4c27ULL,
0x0000001b00187210ULL, 0x000fe40007f5e0ffULL, 0x0000001900167210ULL, 0x000fc40007f3e0ffULL,
0x00000021001a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e061dULL,
0x0000000b17277c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff177224ULL, 0x000fe200008e0613ULL,
0x00000025001c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e061fULL,
0x00000029001e7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014277faeULL, 0x0003e2000b901c4eULL, 0x0000003100247210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200028e0623ULL, 0x0000002b00207210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e062aULL, 0x0000000b08137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff257224ULL, 0x000fe200010e062fULL, 0x0000002d00227210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e062cULL, 0x0000000b102b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000016137faeULL, 0x000fe2000b901c4eULL, 0x0000000b0f0f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff237224ULL, 0x000fe200008e062eULL, 0x0000003500287210ULL, 0x000fe20007f7e0ffULL,
0x00000000182b7faeULL, 0x0005e2000b901c4eULL, 0x0000000b0e2d7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000b0d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a0f7faeULL, 0x000fe2000b901c4eULL,
0x0000003700267210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe200018e0633ULL,
0x0000000b0c2f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001c2d7faeULL, 0x0009e2000b901c4eULL,
0x00000039002a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff277224ULL, 0x002fe200028e0634ULL,
0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000001e0d7faeULL, 0x0003e2000b901c4eULL,
0x0000003d002c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2b7224ULL, 0x004fe200020e0636ULL,
0x0000000b0a137c11ULL, 0x000fe2000f8e20ffULL, 0x00000000202f7faeULL, 0x0005e2000b901c4eULL,
0x00000041002e7210ULL, 0x000fc40007f3e0ffULL, 0x0000000b09097c11ULL, 0x000fe2000f8e20ffULL,
0x00000000220b7faeULL, 0x000fe2000b901c4eULL, 0x0000004300307210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x010fe200000e063bULL, 0x0000004700327210ULL, 0x000fe20007f7e0ffULL,
0x0000000024137faeULL, 0x000fe2000b901c4eULL, 0x0000000b040f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff317224ULL, 0x000fe200010e0638ULL, 0x0000000b05057c11ULL, 0x000fe2000f8e20ffULL,
0x0000000028097faeULL, 0x0009e2000b901c4eULL, 0x0000000b060d7c11ULL, 0x002fe2000f8e20ffULL,
0x000000ffff2f7224ULL, 0x004fe200008e063fULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x00000000260f7faeULL, 0x0007e2000b901c4eULL, 0x000000ffff337224ULL, 0x000fe200018e0645ULL,
0x0000000b11117c11ULL, 0x000fc4000f8e20ffULL, 0x000000002a057faeULL, 0x0007e2000b901c4eULL,
0x0000000b12097c11ULL, 0x010fc6000f8e20ffULL, 0x000000002c0d7faeULL, 0x0007e8000b901c4eULL,
0x000000002e077faeULL, 0x0007e8000b901c4eULL, 0x0000000030097faeULL, 0x0007e8000b901c4eULL,
0x0000000032117faeULL, 0x0007e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01c60003ff0075a7ULL, 0x000ea20008000146ULL, 0x000000053c007c0cULL, 0x000fe2000bf26070ULL,
0x0000006c00ac8947ULL, 0x004fd80003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00009000000b7ab9ULL, 0x000fe40000000800ULL, 0x0000000b080b72a4ULL, 0x000fd8000f8e023fULL,
0x0000440001007983ULL, 0x000ea40000100800ULL, 0x00000000001272caULL, 0x004fda00000e0000ULL,
0x0000001312127291ULL, 0x000fc8000f8e403fULL, 0x000000121400728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000100007836ULL, 0x000fe20000000000ULL, 0x0000000000307919ULL, 0x008ea20000000000ULL,
0x0000004012087892ULL, 0x000fe4000f8ec03fULL, 0x000000150a1672a4ULL, 0x000fe2000f8e023fULL,
0x0000000500007c0cULL, 0x000fe2000bf06070ULL, 0x0000000807087290ULL, 0x000fd8000fffe03fULL,
0x0000000c00908947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x004fe20000011630ULL,
0x00008a0000187ab9ULL, 0x000fe20000000a00ULL, 0x80000012140d7290ULL, 0x000fe2000fffe03fULL,
0x0000000730687812ULL, 0x000fe200078ec0ffULL, 0x00000006100c7291ULL, 0x000fe2000f8e703fULL,
0x0000000c00567836ULL, 0x040fe40000000000ULL, 0x0000001800057836ULL, 0x002fe20000000000ULL,
0x000040000c157890ULL, 0x000fe2000fffe03fULL, 0x0000000856047824ULL, 0x040fe200078e00ffULL,
0x00000030566d7212ULL, 0x080fe200078e3cffULL, 0x0000000400587836ULL, 0x040fe20000000000ULL,
0x0000003005657212ULL, 0x0c0fe200078e3cffULL, 0x0000001400527836ULL, 0x000fe20000000000ULL,
0xfffffff8046d7812ULL, 0x000fe200078ee26dULL, 0x0000000805047824ULL, 0x000fe200078e00ffULL,
0x0000003058697212ULL, 0x0c0fe200078e3cffULL, 0x0000000858027824ULL, 0x000fe200078e00ffULL,
0x0000003052667212ULL, 0x080fe200078e3cffULL, 0x0000000800577836ULL, 0x040fe20000000000ULL,
0xfffffff804657812ULL, 0x000fe200078ee265ULL, 0x0000002400557836ULL, 0x000fe20000000000ULL,
0xfffffff802697812ULL, 0x000fe200078ee269ULL, 0x0000000852077824ULL, 0x000fe200078e00ffULL,
0x00000030576c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000857037824ULL, 0x000fe200078e00ffULL,
0x0000003055617212ULL, 0x0c0fe200078e3cffULL, 0x0000000855047824ULL, 0x000fe200078e00ffULL,
0xfffffff807667812ULL, 0x000fe200078ee266ULL, 0x0000001c00027836ULL, 0x040fe20000000000ULL,
0xfffffff8036c7812ULL, 0x000fe200078ee26cULL, 0x0000001000537836ULL, 0x040fe20000000000ULL,
0xfffffff804617812ULL, 0x000fe200078ee261ULL, 0x0000002c00597836ULL, 0x000fe20000000000ULL,
0x0000003002647212ULL, 0x0c0fe200078e3cffULL, 0x0000000802077824ULL, 0x000fe200078e00ffULL,
0x00000030536e7212ULL, 0x0c0fe200078e3cffULL, 0x0000000853037824ULL, 0x000fe200078e00ffULL,
0x00000030595f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000859047824ULL, 0x000fe200078e00ffULL,
0xfffffff807647812ULL, 0x000fe200078ee264ULL, 0x0000002800547836ULL, 0x040fe20000000000ULL,
0xfffffff8036e7812ULL, 0x000fe200078ee26eULL, 0x0000003400637836ULL, 0x040fe20000000000ULL,
0xfffffff8045f7812ULL, 0x000fe200078ee25fULL, 0x0000003c006b7836ULL, 0x000fe20000000000ULL,
0x0000003054607212ULL, 0x0c0fe200078e3cffULL, 0x0000000854077824ULL, 0x000fe200078e00ffULL,
0x00000030635d7212ULL, 0x080fe200078e3cffULL, 0x0000002000037836ULL, 0x040fe20000000000ULL,
0x000000306b5b7212ULL, 0x080fe200078e3cffULL, 0x0000000863047824ULL, 0x000fe200078e00ffULL,
0xfffffff807607812ULL, 0x000fe200078ee260ULL, 0x00000038005a7836ULL, 0x000fe20000000000ULL,
0x0000003003627212ULL, 0x080fe200078e3cffULL, 0x000000086b067824ULL, 0x000fe200078e00ffULL,
0xfffffff8045d7812ULL, 0x000fe200078ee25dULL, 0x0000000803097824ULL, 0x000fe200078e00ffULL,
0x000000305a5c7212ULL, 0x0c0fe200078e3cffULL, 0x000000085a077824ULL, 0x000fe200078e00ffULL,
0xfffffff8065b7812ULL, 0x000fe200078ee25bULL, 0x0000003000677836ULL, 0x040fe20000000000ULL,
0xfffffff809627812ULL, 0x000fe200078ee262ULL, 0x0000000800047c36ULL, 0x000fe20008000000ULL,
0xfffffff8075c7812ULL, 0x000fe200078ee25cULL, 0x0000000858067c36ULL, 0x000fe20008000000ULL,
0x00000030675e7212ULL, 0x040fe200078e3cffULL, 0x0000000867097824ULL, 0x000fe200078e00ffULL,
0x0000001604077c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000857047c36ULL, 0x000fe20008000000ULL,
0x00000016060a7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000802117c36ULL, 0x000fe20008000000ULL,
0xfffffff8095e7812ULL, 0x000fe200078ee25eULL, 0x0000000856097c36ULL, 0x000fe20008000000ULL,
0x00000016040b7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000001807067c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x000000180a087c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x00000016090d7c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000853047c36ULL, 0x000fe20008000000ULL,
0x0000001907077c11ULL, 0x000fe200088f4c0cULL, 0x0000000859197c36ULL, 0x000fe20008000000ULL,
0x000000190a097c11ULL, 0x000fe200090f4c0fULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x000000180b0a7c11ULL, 0x000fe2000f8248ffULL, 0x000000085a1f7c36ULL, 0x000fe20008000000ULL,
0x000000180d0c7c11ULL, 0x000fe2000f8448ffULL, 0x000000086b207c36ULL, 0x000fe20008000000ULL,
0x000000190b0b7c11ULL, 0x000fe200088f4c0eULL, 0x00000008520e7c36ULL, 0x000fe20008000000ULL,
0x000000190d0d7c11ULL, 0x000fc400090f4c10ULL, 0x00000016040f7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000805047c36ULL, 0x000fe20008000000ULL, 0x000000160e127c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001611157c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x0000001604137c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x000000180f0e7c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x0000001812107c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x000000190f0f7c11ULL, 0x000fe200088f4c14ULL, 0x0000000803047c36ULL, 0x000fe20008000000ULL,
0x0000001912117c11ULL, 0x000fc400090f4c17ULL, 0x0000001813127c11ULL, 0x000fe4000f8248ffULL,
0x0000001815147c11ULL, 0x000fe4000f8448ffULL, 0x0000001913137c11ULL, 0x000fe200088f4c16ULL,
0x0000000855167c36ULL, 0x000fe20008000000ULL, 0x0000001915157c11ULL, 0x000fe400090f4c18ULL,
0x0000001604177c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000854047c36ULL, 0x000fe20008000000ULL,
0x00000016161a7c10ULL, 0x000fc4000ff5e0ffULL, 0x00000008682f7812ULL, 0x000fe200078efcffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x00000016041b7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e06ffULL, 0x000000181a187c11ULL, 0x040fe2000f8448ffULL,
0x000000102f247825ULL, 0x000fe200078e0006ULL, 0x0000001619047c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001817167c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x000000191a197c11ULL, 0x000fe200090f4c1dULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x0000001917177c11ULL, 0x000fe200088f4c1cULL, 0x000000102f2c7825ULL, 0x000fe200078e0010ULL,
0x00000018041c7c11ULL, 0x000fc4000f8448ffULL, 0x000000181b1a7c11ULL, 0x040fe4000f8248ffULL,
0x00000019041d7c11ULL, 0x000fe400090f4c1dULL, 0x0000003000047212ULL, 0x000fe400078e3cffULL,
0x000000191b1b7c11ULL, 0x000fe200088f4c1eULL, 0x00000008631e7c36ULL, 0x000fe20008000000ULL,
0x00000007046a7812ULL, 0x000fe200078ec0ffULL, 0x0000000867047c36ULL, 0x000fe20008000000ULL,
0x0000000d00007c0cULL, 0x000fc4000bf26070ULL, 0x0ffffff86a6a7812ULL, 0x000fe400078ef830ULL,
0x0000001604297c10ULL, 0x000fe4000ff9e0ffULL, 0x000000161f237c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001620047c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x000000161e217c10ULL, 0x000fe2000ffbe0ffULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x000000156a797c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff277224ULL, 0x000fe200018e06ffULL,
0x0000001823227c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x0000001804507c11ULL, 0x000fe2000f8648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024797faeULL, 0x0003e2000c901c4eULL, 0x00000018291e7c11ULL, 0x000fc4000f8848ffULL,
0x0000001821207c11ULL, 0x000fe4000f8a48ffULL, 0x0000001923237c11ULL, 0x000fe400090f4c26ULL,
0x0000000d58007c0cULL, 0x000fe4000bf26070ULL, 0x0000001904517c11ULL, 0x000fe200098f4c27ULL,
0x000000102f267825ULL, 0x000fe200078e000aULL, 0x0000000d57007c0cULL, 0x000fe4000bf46070ULL,
0x00000019291f7c11ULL, 0x000fe2000a0f4c2aULL, 0x000000102f247825ULL, 0x002fe200078e0008ULL,
0x0000000d56007c0cULL, 0x000fc4000bf66070ULL, 0x0000001921217c11ULL, 0x000fe2000a8f4c28ULL,
0x000000102f287825ULL, 0x000fe200078e000cULL, 0x0000000d53007c0cULL, 0x000fe4000bf86070ULL,
0x0000000d52007c0cULL, 0x000fe2000bfa6070ULL, 0x000000102f2a7825ULL, 0x000fe200078e000eULL,
0x00000015697b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000156c7d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000156d317c11ULL, 0x000fe2000f8e20ffULL, 0x00000000247b7faeULL, 0x0003e2000c901c4eULL,
0x000000156e2e7c11ULL, 0x000fc4000f8e20ffULL, 0x00000015667c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000267d7faeULL, 0x0005e2000d101c4eULL, 0x0000000d05007c0cULL, 0x000fe4000bf26070ULL,
0x0000000d02007c0cULL, 0x000fe2000bf46070ULL, 0x0000000028317faeULL, 0x0007e2000d901c4eULL,
0x0000000d03007c0cULL, 0x000fe4000bf66070ULL, 0x0000001565337c11ULL, 0x000fe2000f8e20ffULL,
0x000000002a2e7faeULL, 0x0009e2000e101c4eULL, 0x0000000d55007c0cULL, 0x000fe2000bf86070ULL,
0x000000102f247825ULL, 0x042fe200078e0012ULL, 0x0000001564327c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c7c7faeULL, 0x0003e2000e901c4eULL, 0x0000000d54007c0cULL, 0x000fe2000bfa6070ULL,
0x000000102f267825ULL, 0x044fe200078e0014ULL, 0x0000001560047c11ULL, 0x000fe2000f8e20ffULL,
0x0000003101007387ULL, 0x0005e20000100800ULL, 0x000000155c7a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102f287825ULL, 0x008fe200078e0016ULL, 0x000000155b787c11ULL, 0x000fe2000f8e20ffULL,
0x0000042e01007387ULL, 0x0007e40000100800ULL, 0x000000102f2a7825ULL, 0x010fc400078e0018ULL,
0x0000000024337faeULL, 0x0009e2000c901c4eULL, 0x0000000d59007c0cULL, 0x000fe2000bf26070ULL,
0x000000102f2c7825ULL, 0x002fe200078e001aULL, 0x0000001562317c11ULL, 0x004fe2000f8e20ffULL,
0x0000000026327faeULL, 0x0003e2000d101c4eULL, 0x0000000d67007c0cULL, 0x000fe4000bf46070ULL,
0x00000015612e7c11ULL, 0x008fe2000f8e20ffULL, 0x0000000028317faeULL, 0x0005e2000d901c4eULL,
0x0000000d63007c0cULL, 0x000fc6000bf66070ULL, 0x000000002a2e7faeULL, 0x0007e2000e101c4eULL,
0x0000000d5a007c0cULL, 0x000fe2000bf86070ULL, 0x000000102f247825ULL, 0x010fe400078e001cULL,
0x000000002c047faeULL, 0x0009e2000e901c4eULL, 0x0000000d6b007c0cULL, 0x000fe2000bfa6070ULL,
0x000000102f267825ULL, 0x042fe400078e001eULL, 0x0000103301007387ULL, 0x000fe40000100800ULL,
0x000000102f287825ULL, 0x004fc400078e0020ULL, 0x00000c3201007387ULL, 0x000fe40000100800ULL,
0x000000102f2a7825ULL, 0x048fe400078e0022ULL, 0x00001c3101007387ULL, 0x0003e40000100800ULL,
0x000000102f2c7825ULL, 0x010fe400078e0050ULL, 0x0000242e01007387ULL, 0x0005e80000100800ULL,
0x0000200401007387ULL, 0x0007e20000100800ULL, 0x000000155f317c11ULL, 0x002fc4000f8e20ffULL,
0x000000155e2e7c11ULL, 0x004fc6000f8e20ffULL, 0x0000000024317faeULL, 0x0003e2000c901c4eULL,
0x000000155d047c11ULL, 0x008fc6000f8e20ffULL, 0x00000000262e7faeULL, 0x0003e8000d101c4eULL,
0x0000183101007387ULL, 0x0003e80000100800ULL, 0x0000000028047faeULL, 0x0003e8000d901c4eULL,
0x0000142e01007387ULL, 0x0003e80000100800ULL, 0x000000002a7a7faeULL, 0x0003e8000e101c4eULL,
0x0000080401007387ULL, 0x0003e80000100800ULL, 0x000000002c787faeULL, 0x0003e2000e901c4eULL,
0x0000000c00487947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x004fe20000011630ULL,
0x00008a0000187ab9ULL, 0x000fe20000000a00ULL, 0x00000006100c7291ULL, 0x000fe2000f8e703fULL,
0x0000000730687812ULL, 0x000fe400078ec0ffULL, 0x0000001000537836ULL, 0x040fe20000000000ULL,
0x000040000c157890ULL, 0x000fe2000fffe03fULL, 0x0000000400587836ULL, 0x000fe20000000000ULL,
0x0000000868317812ULL, 0x000fe200078efcffULL, 0x0000000853057824ULL, 0x042fe200078e00ffULL,
0x00000030536e7212ULL, 0x080fe200078e3cffULL, 0x0000000858027824ULL, 0x040fe200078e00ffULL,
0x0000003058697212ULL, 0x080fe200078e3cffULL, 0x0000000800577836ULL, 0x040fe20000000000ULL,
0xfffffff8056e7812ULL, 0x000fe200078ee26eULL, 0x0000000c00567836ULL, 0x040fe20000000000ULL,
0xfffffff802697812ULL, 0x000fe200078ee269ULL, 0x0000001800057836ULL, 0x000fe20000000000ULL,
0x00000030576c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000857037824ULL, 0x000fe200078e00ffULL,
0x00000030566d7212ULL, 0x080fe200078e3cffULL, 0x0000001400527836ULL, 0x000fe20000000000ULL,
0x0000003005657212ULL, 0x0c0fe200078e3cffULL, 0x0000000856027824ULL, 0x000fe200078e00ffULL,
0xfffffff8036c7812ULL, 0x000fe200078ee26cULL, 0x0000000805047824ULL, 0x000fe200078e00ffULL,
0x0000003052667212ULL, 0x080fe200078e3cffULL, 0x0000002c00597836ULL, 0x000fe20000000000ULL,
0xfffffff8026d7812ULL, 0x000fe200078ee26dULL, 0x0000000852077824ULL, 0x000fe200078e00ffULL,
0xfffffff804657812ULL, 0x000fe200078ee265ULL, 0x0000002000037836ULL, 0x040fe20000000000ULL,
0x00000030595f7212ULL, 0x0c0fe200078e3cffULL, 0x0000001c00027836ULL, 0x040fe20000000000ULL,
0xfffffff807667812ULL, 0x000fe200078ee266ULL, 0x0000000859047824ULL, 0x000fe200078e00ffULL,
0x0000003003627212ULL, 0x0c0fe200078e3cffULL, 0x0000002400557836ULL, 0x000fe20000000000ULL,
0x0000003002647212ULL, 0x0c0fe200078e3cffULL, 0x0000000803097824ULL, 0x000fe200078e00ffULL,
0xfffffff8045f7812ULL, 0x000fe200078ee25fULL, 0x0000000802077824ULL, 0x000fe200078e00ffULL,
0x0000003055617212ULL, 0x0c0fe200078e3cffULL, 0x0000000855067824ULL, 0x000fe200078e00ffULL,
0xfffffff809627812ULL, 0x000fe200078ee262ULL, 0x0000003000677836ULL, 0x040fe20000000000ULL,
0xfffffff807647812ULL, 0x000fe200078ee264ULL, 0x0000002800547836ULL, 0x040fe20000000000ULL,
0xfffffff806617812ULL, 0x000fe200078ee261ULL, 0x0000000800047c36ULL, 0x040fe20008000000ULL,
0x00000030675e7212ULL, 0x0c0fe200078e3cffULL, 0x0000003400637836ULL, 0x000fe20000000000ULL,
0x0000003054607212ULL, 0x080fe200078e3cffULL, 0x0000003c006b7836ULL, 0x000fe20000000000ULL,
0x0000001604047c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000867097824ULL, 0x000fe200078e00ffULL,
0x00000030635d7212ULL, 0x080fe200078e3cffULL, 0x0000000854077824ULL, 0x000fe200078e00ffULL,
0x000000306b5b7212ULL, 0x080fe200078e3cffULL, 0x0000000863067824ULL, 0x000fe200078e00ffULL,
0xfffffff8095e7812ULL, 0x000fe200078ee25eULL, 0x00000038005a7836ULL, 0x000fe20000000000ULL,
0xfffffff807607812ULL, 0x000fe200078ee260ULL, 0x000000086b087824ULL, 0x000fe200078e00ffULL,
0xfffffff8065d7812ULL, 0x000fe200078ee25dULL, 0x000000085a097824ULL, 0x040fe200078e00ffULL,
0x000000305a5c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0xfffffff8085b7812ULL, 0x000fe200078ee25bULL, 0x0000000858087c36ULL, 0x000fe20008000000ULL,
0x0000001804067c11ULL, 0x000fe2000f8248ffULL, 0x00000008560a7c36ULL, 0x000fe20008000000ULL,
0xfffffff8095c7812ULL, 0x000fe200078ee25cULL, 0x0000000857097c36ULL, 0x000fe20008000000ULL,
0x0000001904077c11ULL, 0x000fe200088f4c07ULL, 0x00000008530f7c36ULL, 0x000fe20008000000ULL,
0x0000001608047c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000805127c36ULL, 0x000fe20008000000ULL,
0x000000160a0d7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000802147c36ULL, 0x000fe20008000000ULL,
0x00000016090b7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000001804087c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x000000180d0c7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x0000001904097c11ULL, 0x000fe200088f4c09ULL, 0x0000000854177c36ULL, 0x000fe20008000000ULL,
0x000000160f0f7c10ULL, 0x000fe2000ff3e0ffULL, 0x00000008591d7c36ULL, 0x000fe20008000000ULL,
0x000000190d0d7c11ULL, 0x000fe200098f4c10ULL, 0x0000000852107c36ULL, 0x000fe20008000000ULL,
0x000000180b0a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff047224ULL, 0x000fe200008e06ffULL,
0x0000001612137c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000863207c36ULL, 0x000fe20008000000ULL,
0x000000190b0b7c11ULL, 0x000fe200090f4c0eULL, 0x000000086b247c36ULL, 0x000fe20008000000ULL,
0x000000180f0e7c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001610117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000085a227c36ULL, 0x000fe20008000000ULL,
0x000000190f0f7c11ULL, 0x000fc400088f4c04ULL, 0x0000001614157c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff047224ULL, 0x000fe200010e06ffULL, 0x0000001811107c11ULL, 0x000fe2000f8248ffULL,
0x00000010312c7825ULL, 0x000fe200078e000eULL, 0x0000001813127c11ULL, 0x000fe4000f8448ffULL,
0x0000001815147c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x0000001911117c11ULL, 0x000fe200088f4c04ULL, 0x0000000803047c36ULL, 0x000fe20008000000ULL,
0x0000001913137c11ULL, 0x000fe200090f4c16ULL, 0x0000000855167c36ULL, 0x000fe20008000000ULL,
0x0000001915157c11ULL, 0x000fe200098f4c18ULL, 0x00000010312e7825ULL, 0x000fe200078e0010ULL,
0x00000016171b7c10ULL, 0x000fc4000ff7e0ffULL, 0x0000001604047c10ULL, 0x000fe4000ff3e0ffULL,
0x0000001616197c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x000000181b1a7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x000000161d1d7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x0000001804167c11ULL, 0x000fe4000f8248ffULL, 0x0000001819187c11ULL, 0x000fc4000f8448ffULL,
0x000000191b1b7c11ULL, 0x000fe200098f4c1eULL, 0x000000ffff1e7224ULL, 0x000fe200020e06ffULL,
0x0000001904177c11ULL, 0x000fe400088f4c17ULL, 0x0000001919197c11ULL, 0x000fe400090f4c1cULL,
0x000000181d1c7c11ULL, 0x040fe4000f8248ffULL, 0x0000003000047212ULL, 0x000fe400078e3cffULL,
0x000000191d1d7c11ULL, 0x000fe200088f4c1eULL, 0x00000008671e7c36ULL, 0x000fe20008000000ULL,
0x0000001620217c10ULL, 0x000fc4000ff7e0ffULL, 0x0000001624277c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001031247825ULL, 0x000fe200078e0006ULL, 0x0000001622237c10ULL, 0x000fe4000ff9e0ffULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x0000001821207c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x0ffffff8046a7812ULL, 0x000fe200078ef830ULL, 0x000000ffff287224ULL, 0x000fe200020e06ffULL,
0x0000001827507c11ULL, 0x000fc4000f8248ffULL, 0x0000001823227c11ULL, 0x000fe4000f8848ffULL,
0x000000161e1f7c10ULL, 0x000fe4000ff5e0ffULL, 0x000000156a797c11ULL, 0x000fe4000f8e20ffULL,
0x0000001921217c11ULL, 0x000fe200098f4c26ULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x0000001927517c11ULL, 0x000fe200088f4c2aULL, 0x0000001031267825ULL, 0x000fe200078e0008ULL,
0x0000001923237c11ULL, 0x000fe2000a0f4c28ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024797faeULL, 0x0003e2000b901c4eULL, 0x00000015697b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001031287825ULL, 0x000fe200078e000aULL, 0x000000156c7d7c11ULL, 0x000fc4000f8e20ffULL,
0x000000156d337c11ULL, 0x000fe2000f8e20ffULL, 0x00000010312a7825ULL, 0x000fe200078e000cULL,
0x000000156e327c11ULL, 0x000fe2000f8e20ffULL, 0x00000000267b7faeULL, 0x0005e2000b901c4eULL,
0x000000181f1e7c11ULL, 0x000fe4000f8448ffULL, 0x00000015667c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000287d7faeULL, 0x0007e2000b901c4eULL, 0x0000001565357c11ULL, 0x000fe2000f8e20ffULL,
0x0000001031247825ULL, 0x002fe200078e0012ULL, 0x0000001564347c11ULL, 0x000fe2000f8e20ffULL,
0x0000003301007387ULL, 0x0003e20000100800ULL, 0x000000191f1f7c11ULL, 0x000fc400090f4c04ULL,
0x0000001560047c11ULL, 0x000fe2000f8e20ffULL, 0x000000002a337faeULL, 0x0003e2000b901c4eULL,
0x0000001031267825ULL, 0x044fe200078e0014ULL, 0x000000155c7a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000043201007387ULL, 0x0005e20000100800ULL, 0x0000001031287825ULL, 0x008fe200078e0016ULL,
0x000000155b787c11ULL, 0x000fe4000f8e20ffULL, 0x000000002c327faeULL, 0x0005e2000b901c4eULL,
0x0000001562337c11ULL, 0x002fe2000f8e20ffULL, 0x00000010312a7825ULL, 0x000fc400078e0018ULL,
0x000000002e7c7faeULL, 0x0003e8000b901c4eULL, 0x0000103501007387ULL, 0x000fe20000100800ULL,
0x0000001561327c11ULL, 0x004fe2000f8e20ffULL, 0x00000010312c7825ULL, 0x000fe400078e001aULL,
0x0000000024357faeULL, 0x0005e8000b901c4eULL, 0x00000c3401007387ULL, 0x000fe20000100800ULL,
0x000000155f2f7c11ULL, 0x002fc4000f8e20ffULL, 0x000000155e2e7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000026347faeULL, 0x0003e8000b901c4eULL, 0x00001c3301007387ULL, 0x000fe20000100800ULL,
0x0000001031247825ULL, 0x004fc600078e001cULL, 0x0000000028337faeULL, 0x0005e8000b901c4eULL,
0x0000243201007387ULL, 0x000fe20000100800ULL, 0x0000001031267825ULL, 0x002fc600078e001eULL,
0x000000002a327faeULL, 0x0003e8000b901c4eULL, 0x0000200401007387ULL, 0x0007e20000100800ULL,
0x0000001031287825ULL, 0x004fc600078e0020ULL, 0x000000002c047faeULL, 0x0007e2000b901c4eULL,
0x00000010312a7825ULL, 0x002fc600078e0022ULL, 0x00000000242f7faeULL, 0x0003e8000b901c4eULL,
0x00000000262e7faeULL, 0x0003e2000b901c4eULL, 0x000000155d047c11ULL, 0x008fe2000f8e20ffULL,
0x00000010312c7825ULL, 0x000fe400078e0050ULL, 0x0000182f01007387ULL, 0x0003e80000100800ULL,
0x0000000028047faeULL, 0x0003e8000b901c4eULL, 0x0000142e01007387ULL, 0x0003e80000100800ULL,
0x000000002a7a7faeULL, 0x0003e8000b901c4eULL, 0x0000080401007387ULL, 0x0003e80000100800ULL,
0x000000002c787faeULL, 0x0003e4000b901c4eULL, 0x00000004ff287819ULL, 0x002fe20000011630ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000868047812ULL, 0x000fe200078ef830ULL,
0x000020000c0c7890ULL, 0x000fe2000fffe03fULL, 0x0000000100777812ULL, 0x000fe200078ec0ffULL,
0x0000000828257824ULL, 0x040fe200078e00ffULL, 0x0000000728277812ULL, 0x000fe200078e7804ULL,
0x0000000228297836ULL, 0x000fc60000000000ULL, 0xfffffff825257812ULL, 0x000fe200078ee268ULL,
0x0000002004247824ULL, 0x000fe200078e0227ULL, 0x0000000729297812ULL, 0x000fe400078e7804ULL,
0x0000000725747812ULL, 0x040fe200078ec0ffULL, 0x0000001025727836ULL, 0x040fe20000000000ULL,
0x0000000624247c11ULL, 0x000fe2000f8e20ffULL, 0x0000000825737824ULL, 0x040fe200078e00ffULL,
0x0000000174267812ULL, 0x000fe200078e7800ULL, 0x0000002025757836ULL, 0x040fe20000000000ULL,
0x0000000772717812ULL, 0x040fe200078ec0ffULL, 0x0000000872727824ULL, 0x000fe200078e00ffULL,
0x0000007326267212ULL, 0x000fe200078efcffULL, 0x0000003025257836ULL, 0x000fe20000000000ULL,
0x0000000171277812ULL, 0x000fe200078e7800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000282601007387ULL, 0x0003e20000100800ULL, 0x0000000c26287c11ULL, 0x000fe2000f8e20ffULL,
0x0000000825767824ULL, 0x000fe200078e00ffULL, 0x0000000775707812ULL, 0x000fe200078ec0ffULL,
0x000000002440783bULL, 0x0005e20000000200ULL, 0x00000007256f7812ULL, 0x000fe200078ec0ffULL,
0x0000000875757824ULL, 0x000fe400078e00ffULL, 0x0000742801007387ULL, 0x000fe20000100800ULL,
0x000000016f257812ULL, 0x000fe400078e7800ULL, 0x0000007227267212ULL, 0x002fe200078efcffULL,
0x000000002834783bULL, 0x000fe20000000200ULL, 0x0000000271277812ULL, 0x000fc400078e1e77ULL,
0x0000000c26247c11ULL, 0x004fe2000f8e20ffULL, 0x00002c2601007387ULL, 0x0003e20000100800ULL,
0x00000076252d7212ULL, 0x000fc600078efcffULL, 0x000000002444783bULL, 0x000fe20000000200ULL,
0x0000000c2d257c11ULL, 0x000fc6000f8e20ffULL, 0x00007c2401007387ULL, 0x0005e20000100800ULL,
0x0000002004267824ULL, 0x002fc600078e0229ULL, 0x00000000254c783bULL, 0x000e640000000200ULL,
0x0000000626287c11ULL, 0x000fe4000f8e20ffULL, 0x0000000274267812ULL, 0x000fe400078e1e77ULL,
0x0000000170247812ULL, 0x004fe400078e7800ULL, 0x00000073262a7212ULL, 0x000fe400078efcffULL,
0x0000007524297212ULL, 0x000fc400078efcffULL, 0x0000000c2a2c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000402a01007387ULL, 0x000fe20000100800ULL, 0x0000007227247212ULL, 0x000fe400078efcffULL,
0x0000000c29267c11ULL, 0x000fe2000f8e20ffULL, 0x0000302901007387ULL, 0x000fe80000100800ULL,
0x0000382d01007387ULL, 0x000fe80000100800ULL, 0x0000902c01007387ULL, 0x000fe80000100800ULL,
0x0000482401007387ULL, 0x0005e80000100800ULL, 0x000000002828783bULL, 0x000fe80000000200ULL,
0x0000842601007387ULL, 0x000fe20000100800ULL, 0x0000000c24247c11ULL, 0x004fe2000f8e20ffULL,
0x0000004c403c723cULL, 0x002fe400000418ffULL, 0x00008c2501007387ULL, 0x000fe80000100800ULL,
0x000000002448783bULL, 0x000e680000000200ULL, 0x000000002638783bULL, 0x000fe80000000200ULL,
0x0000942401007387ULL, 0x0005e80000100800ULL, 0x000000002c30783bULL, 0x0007220000000200ULL,
0x000000444024723cULL, 0x004fec00000418ffULL, 0x000000464044723cULL, 0x000fec00000418ffULL,
0x00000034402c723cULL, 0x008fec00000418ffULL, 0x000000364034723cULL, 0x000fec00000418ffULL,
0x000000482824723cULL, 0x002fec0000041824ULL, 0x0000004a2848723cULL, 0x000fec0000041844ULL,
0x00000030282c723cULL, 0x010fe2000004182cULL, 0x0000000270447812ULL, 0x000fc400078e1e77ULL,
0x000000026f457812ULL, 0x000fe400078e1e77ULL, 0x00000075444c7212ULL, 0x000fe200078efcffULL,
0x000000322830723cULL, 0x000fe20000041834ULL, 0x00000076454d7212ULL, 0x000fe400078efcffULL,
0x0000000c4c467c11ULL, 0x000fe2000f8e20ffULL, 0x0000344c01007387ULL, 0x0003e40000100800ULL,
0x000000384034723cULL, 0x000fe400000418ffULL, 0x00003c4d01007387ULL, 0x000fe80000100800ULL,
0x0000804601007387ULL, 0x000fe20000100800ULL, 0x0000003a4038723cULL, 0x000fe200000418ffULL,
0x0000000c4d4c7c11ULL, 0x002fc4000f8e20ffULL, 0x000000004644783bULL, 0x000e660000000200ULL,
0x0000004e4040723cULL, 0x000fe200000418ffULL, 0x0000884c01007387ULL, 0x000fe80000100800ULL,
0x000000004c4c783bULL, 0x000eac0000000200ULL, 0x000000442834723cULL, 0x002fe20000041834ULL,
0x0000000000457919ULL, 0x000e6c0000000000ULL, 0x000000462838723cULL, 0x000fec0000041838ULL,
0x0000004c283c723cULL, 0x004fec000004183cULL, 0x0000004e2840723cULL, 0x000fe20000041840ULL,
0x00000004704d7812ULL, 0x000fc400078e1e77ULL, 0x000000046f4c7812ULL, 0x000fe400078e1e77ULL,
0x000000754d4d7212ULL, 0x000fe400078efcffULL, 0x0000000474287812ULL, 0x000fe400078e1e77ULL,
0x0000000674747812ULL, 0x000fe400078e1e77ULL, 0x00000073284f7212ULL, 0x080fe400078efcffULL,
0x0000007374747212ULL, 0x000fc400078efcffULL, 0x00000004ff457819ULL, 0x002fe40000011645ULL,
0x0000000c4f2a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c4d737c11ULL, 0x000fe2000f8e20ffULL,
0x0000000445297836ULL, 0x000fe20000000000ULL, 0x000000764c4c7212ULL, 0x000fe200078efcffULL,
0x0000782a01007387ULL, 0x000fe20000100800ULL, 0x000000066f6f7812ULL, 0x000fe400078e1e77ULL,
0x0000000729297812ULL, 0x000fc400078e7804ULL, 0x000000766f767212ULL, 0x000fe400078efcffULL,
0x0000000670707812ULL, 0x000fe200078e1e77ULL, 0x0000002004297824ULL, 0x000fc600078e0229ULL,
0x0000007570707212ULL, 0x000fe400078efcffULL, 0x0000000629297c11ULL, 0x000fca000f8e20ffULL,
0x000000002944783bULL, 0x000fe80000000200ULL, 0x000000002a28783bULL, 0x000e640000000200ULL,
0x00000028442c723cULL, 0x002fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x0000000471287812ULL, 0x000fc400078e1e77ULL, 0x0000000671717812ULL, 0x000fe400078e1e77ULL,
0x00000072284e7212ULL, 0x080fe400078efcffULL, 0x0000007271727212ULL, 0x000fe400078efcffULL,
0x0000000c4e297c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c4c717c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c726f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000682901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e680000000200ULL, 0x0000707301007387ULL, 0x000fe80000100800ULL,
0x00006c7101007387ULL, 0x000fe20000100800ULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007328783bULL, 0x0002a40000000200ULL,
0x0000000000737919ULL, 0x002e660000000000ULL, 0x000000284434723cULL, 0x004fe20000041834ULL,
0x00000004ff737819ULL, 0x002fca0000011673ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x000000007128783bULL, 0x0002a40000000200ULL, 0x0000000c74717c11ULL, 0x002fca000f8e20ffULL,
0x0000647101007387ULL, 0x000fe80000100800ULL, 0x0000606f01007387ULL, 0x000fe20000100800ULL,
0x00000028443c723cULL, 0x004fec000004183cULL, 0x0000002a4440723cULL, 0x000fe20000041840ULL,
0x0000000673287836ULL, 0x000fca0000000000ULL, 0x0000000728287812ULL, 0x000fca00078e7804ULL,
0x0000002004287824ULL, 0x000fca00078e0228ULL, 0x0000000628287c11ULL, 0x000fca000f8e20ffULL,
0x000000002844783bULL, 0x000fe80000000200ULL, 0x000000007128783bULL, 0x000e640000000200ULL,
0x00000028442c723cULL, 0x002fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x000000006f28783bULL, 0x0002a40000000200ULL, 0x0000000c706f7c11ULL, 0x002fca000f8e20ffULL,
0x00005c6f01007387ULL, 0x000fe20000100800ULL, 0x000000284424723cULL, 0x004fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000006f28783bULL, 0x0002a40000000200ULL,
0x0000000c766f7c11ULL, 0x002fca000f8e20ffULL, 0x0000586f01007387ULL, 0x000fe20000100800ULL,
0x000000284434723cULL, 0x004fec0000041834ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x000000006f28783bULL, 0x000e6a0000000200ULL, 0x00000028443c723cULL, 0x002fec000004183cULL,
0x0000002a4440723cULL, 0x000fe20000041840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000400188947ULL, 0x000fde0003800000ULL, 0x8000001214087290ULL, 0x000fe2000fffe03fULL,
0x00000010682a7812ULL, 0x000fe400078efcffULL, 0x0000000c6a6a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c69697c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x000fe200078e0006ULL,
0x0000000800007c0cULL, 0x000fe4000bf26070ULL, 0x0000000c6c6c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c6d6d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000c6e6e7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c66667c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c65657c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c64647c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000286a7faeULL, 0x0003e2000c901c4eULL, 0x0000000858007c0cULL, 0x000fe4000bf26070ULL,
0x0000000c62627c11ULL, 0x000fc4000f8e20ffULL, 0x0000000c61617c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c60607c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c5f5f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c5e5e7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fe200078e0008ULL,
0x0000000c5d5d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c5c5c7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000028697faeULL, 0x0003e2000c901c4eULL, 0x0000000857007c0cULL, 0x000fe4000bf26070ULL,
0x0000000c5b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fd400078e000aULL,
0x00000000286c7faeULL, 0x0003e2000c901c4eULL, 0x0000000856007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e000cULL, 0x00000000286d7faeULL, 0x0003e2000c901c4eULL,
0x0000000853007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e000eULL,
0x00000000286e7faeULL, 0x0003e2000c901c4eULL, 0x0000000852007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0010ULL, 0x0000000028667faeULL, 0x0003e2000c901c4eULL,
0x0000000805007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0012ULL,
0x0000000028657faeULL, 0x0003e2000c901c4eULL, 0x0000000802007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0014ULL, 0x0000000028647faeULL, 0x0003e2000c901c4eULL,
0x0000000803007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0016ULL,
0x0000000028627faeULL, 0x0003e2000c901c4eULL, 0x0000000855007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0018ULL, 0x0000000028617faeULL, 0x0003e2000c901c4eULL,
0x0000000854007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e001aULL,
0x0000000028607faeULL, 0x0003e2000c901c4eULL, 0x0000000859007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e001cULL, 0x00000000285f7faeULL, 0x0003e2000c901c4eULL,
0x0000000867007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e001eULL,
0x00000000285e7faeULL, 0x0003e2000c901c4eULL, 0x0000000863007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0020ULL, 0x00000000285d7faeULL, 0x0003e2000c901c4eULL,
0x000000085a007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fc800078e0022ULL,
0x000000102a2a7825ULL, 0x000fd000078e0050ULL, 0x00000000285c7faeULL, 0x0003e2000c901c4eULL,
0x000000086b007c0cULL, 0x000fda000bf26070ULL, 0x000000002a5b7faeULL, 0x0003e2000c901c4eULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x00000010682a7812ULL, 0x000fe400078efcffULL,
0x0000000c6a6a7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c69697c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x000fe200078e0006ULL, 0x0000000c6c6c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c6d6d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000286a7faeULL, 0x0003e2000b901c4eULL, 0x0000000c6e6e7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000c66667c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c65657c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c64647c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c62627c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c61617c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fe200078e0008ULL,
0x0000000c60607c11ULL, 0x000fc4000f8e20ffULL, 0x0000000c5f5f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000028697faeULL, 0x0003e2000b901c4eULL, 0x0000000c5e5e7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c5d5d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c5c5c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000c5b5b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fca00078e000aULL,
0x00000000286c7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e000cULL,
0x00000000286d7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e000eULL,
0x00000000286e7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0010ULL,
0x0000000028667faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0012ULL,
0x0000000028657faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0014ULL,
0x0000000028647faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0016ULL,
0x0000000028627faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0018ULL,
0x0000000028617faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e001aULL,
0x0000000028607faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e001cULL,
0x00000000285f7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e001eULL,
0x00000000285e7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0020ULL,
0x00000000285d7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fc800078e0022ULL,
0x000000102a2a7825ULL, 0x000fe200078e0050ULL, 0x00000000285c7faeULL, 0x0003e8000b901c4eULL,
0x000000002a5b7faeULL, 0x0003e4000b901c4eULL, 0x0000280001297983ULL, 0x002ea80000300800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000873287836ULL, 0x000fc60000000000ULL,
0x0000400001777983ULL, 0x000ee40000300800ULL, 0x0000000728287812ULL, 0x000fe400078e7804ULL,
0x0000480001757983ULL, 0x000f260000300800ULL, 0x0000002004287824ULL, 0x000fe200078e0228ULL,
0x0000340001717983ULL, 0x000f680000300800ULL, 0x0000000628287c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002844783bULL, 0x000fe20000000200ULL,
0x0000001529297c11ULL, 0x004fca000f8e20ffULL, 0x0000542901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e680000000200ULL, 0x00003c00016f7983ULL, 0x000ea20000300800ULL,
0x00000028442c723cULL, 0x002fe6000004182cULL, 0x00002c0001297983ULL, 0x000ea60000300800ULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x0000001529297c11ULL, 0x004fca000f8e20ffULL,
0x0000502901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x000000284424723cULL, 0x002fe40000041824ULL, 0x0000300001297983ULL, 0x000ea80000300800ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x0000001529297c11ULL, 0x004fca000f8e20ffULL,
0x00004c2901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x000000284434723cULL, 0x002fe40000041834ULL, 0x0000380001297983ULL, 0x000ea80000300800ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x0000001577777c11ULL, 0x008fc4000f8e20ffULL,
0x0000001575757c11ULL, 0x010fe4000f8e20ffULL, 0x0000001571717c11ULL, 0x020fe4000f8e20ffULL,
0x0000001529297c11ULL, 0x004fca000f8e20ffULL, 0x0000382901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e640000000200ULL, 0x00000028443c723cULL, 0x002fee000004183cULL,
0x0000000a73287836ULL, 0x000fca0000000000ULL, 0x0000000728287812ULL, 0x000fca00078e7804ULL,
0x0000002004287824ULL, 0x000fe200078e0228ULL, 0x0000002a4440723cULL, 0x000fe80000041840ULL,
0x0000000628287c11ULL, 0x000fca000f8e20ffULL, 0x000000002844783bULL, 0x000fe80000000200ULL,
0x000000007728783bULL, 0x000e640000000200ULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000007528783bULL, 0x000e680000000200ULL,
0x0000307701007387ULL, 0x0005e20000100800ULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007128783bULL, 0x000e620000000200ULL,
0x000000156f777c11ULL, 0x004fc8000f8e20ffULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000007728783bULL, 0x000e680000000200ULL,
0x00002c7501007387ULL, 0x0005e40000100800ULL, 0x000000154f757c11ULL, 0x004fe2000f8e20ffULL,
0x00000028443c723cULL, 0x002fee000004183cULL, 0x0000000c73287836ULL, 0x000fca0000000000ULL,
0x0000000728287812ULL, 0x000fe200078e7804ULL, 0x0000002a4440723cULL, 0x000fe80000041840ULL,
0x0000002004287824ULL, 0x000fca00078e0228ULL, 0x0000000628447c11ULL, 0x000fe4000f8e20ffULL,
0x000000007528783bULL, 0x000fe80000000200ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x000000154e737c11ULL, 0x000fc6000f8e20ffULL, 0x0000287101007387ULL, 0x0005e20000100800ULL,
0x00000028442c723cULL, 0x002fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x000000007328783bULL, 0x000e620000000200ULL, 0x000000154d717c11ULL, 0x004fe4000f8e20ffULL,
0x000000154c6f7c11ULL, 0x000fc4000f8e20ffULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007128783bULL, 0x000e620000000200ULL,
0x00000000004f7919ULL, 0x000ea80000000000ULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000006f28783bULL, 0x000e620000000200ULL,
0x00000004ff4f7819ULL, 0x004fc4000001164fULL, 0x00000015724e7c11ULL, 0x000fe4000f8e20ffULL,
0x00000015704d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000140001727983ULL, 0x0005620000100800ULL,
0x00000015764c7c11ULL, 0x000fc6000f8e20ffULL, 0x0000180001707983ULL, 0x0005680000100800ULL,
0x0000200001767983ULL, 0x0005620000100800ULL, 0x00000028443c723cULL, 0x002fee000004183cULL,
0x0000000e4f287836ULL, 0x000fe20000000000ULL, 0x00000015744f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000080001747983ULL, 0x0005640000100800ULL, 0x0000000728287812ULL, 0x000fe200078e7804ULL,
0x0000002a4440723cULL, 0x000fe80000041840ULL, 0x0000002004287824ULL, 0x000fca00078e0228ULL,
0x0000000628447c11ULL, 0x000fe4000f8e20ffULL, 0x000000004f28783bULL, 0x000fe80000000200ULL,
0x000000004444783bULL, 0x000e640000000200ULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000004e28783bULL, 0x000e6a0000000200ULL,
0x000000284424723cULL, 0x002fec0000041824ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x000000004d28783bULL, 0x000e6a0000000200ULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000004c28783bULL, 0x000e6a0000000200ULL,
0x00000028443c723cULL, 0x002fec000004183cULL, 0x0000002a4440723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000f08947ULL, 0x004fde0003800000ULL,
0x0000000001457983ULL, 0x000ea80000300800ULL, 0x0000040001467983ULL, 0x000ee80000300800ULL,
0x0000100001477983ULL, 0x000f280000300800ULL, 0x00000c00012a7983ULL, 0x000f280000300800ULL,
0x00001c0001297983ULL, 0x000f280000300800ULL, 0x00002400012b7983ULL, 0x000f220000300800ULL,
0x8000001214087290ULL, 0x000fe2000fffe03fULL, 0x0000001868287812ULL, 0x000fca00078efcffULL,
0x0000000800007c0cULL, 0x000fe2000bf06070ULL, 0x0000001028067825ULL, 0x000fe200078e0006ULL,
0x0000000856007c0cULL, 0x000fe4000bf26070ULL, 0x0000000805007c0cULL, 0x000fe2000bf46070ULL,
0x0000001028087825ULL, 0x000fe200078e0008ULL, 0x0000000802007c0cULL, 0x000fe4000bf66070ULL,
0x0000000803007c0cULL, 0x000fe2000bf86070ULL, 0x00000010280a7825ULL, 0x000fe200078e000aULL,
0x000000085a007c0cULL, 0x000fc4000bfa6070ULL, 0x000000086b007c0cULL, 0x000fe2000bfc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006797faeULL, 0x000fe2000c101c4eULL,
0x0000000858007c0cULL, 0x000fe2000bf06070ULL, 0x00000010280c7825ULL, 0x000fc800078e000cULL,
0x00000010280e7825ULL, 0x000fc800078e000eULL, 0x0000001028107825ULL, 0x000fc800078e0010ULL,
0x00000000087b7faeULL, 0x000fe2000c101c4eULL, 0x0000000857007c0cULL, 0x000fe2000bf06070ULL,
0x0000001028127825ULL, 0x000fc800078e0012ULL, 0x0000001028147825ULL, 0x000fc800078e0014ULL,
0x0000001028167825ULL, 0x000fc800078e0016ULL, 0x000000000a7d7faeULL, 0x000fe2000c101c4eULL,
0x0000000853007c0cULL, 0x000fe2000bf06070ULL, 0x0000001028187825ULL, 0x000fc800078e0018ULL,
0x00000010281a7825ULL, 0x000fc800078e001aULL, 0x00000010281c7825ULL, 0x000fc800078e001cULL,
0x00000010281e7825ULL, 0x000fc800078e001eULL, 0x0000001028207825ULL, 0x000fc800078e0020ULL,
0x0000001028227825ULL, 0x000fe200078e0022ULL, 0x000000000c457faeULL, 0x004fe2000c901c4eULL,
0x0000000852007c0cULL, 0x000fc6000bf26070ULL, 0x000000000e467faeULL, 0x008fe2000c101c4eULL,
0x0000000855007c0cULL, 0x000fd2000bf06070ULL, 0x00000000107c7faeULL, 0x000fe2000c901c4eULL,
0x0000000854007c0cULL, 0x000fc6000bf26070ULL, 0x0000000012477faeULL, 0x010fe2000d101c4eULL,
0x0000000859007c0cULL, 0x000fc6000bf46070ULL, 0x00000000142a7faeULL, 0x000fe2000d901c4eULL,
0x0000000867007c0cULL, 0x000fc6000bf66070ULL, 0x0000000016297faeULL, 0x0005e2000e101c4eULL,
0x0000000863007c0cULL, 0x000fc6000bf86070ULL, 0x00000000182b7faeULL, 0x0003e8000c101c4eULL,
0x000000001a767faeULL, 0x0203e2000c901c4eULL, 0x0000001028287825ULL, 0x004fc600078e0050ULL,
0x000000001c707faeULL, 0x0003e8000d101c4eULL, 0x000000001e727faeULL, 0x0003e8000d901c4eULL,
0x0000000020747faeULL, 0x0003e8000e101c4eULL, 0x00000000227a7faeULL, 0x0003e8000e901c4eULL,
0x0000000028787faeULL, 0x0003e2000f101c4eULL, 0x0000000000a87947ULL, 0x000fea0003800000ULL,
0x0000000001297983ULL, 0x000ea80000300800ULL, 0x0000040001467983ULL, 0x000ee80000300800ULL,
0x0000100001457983ULL, 0x000f280000300800ULL, 0x00000c0001447983ULL, 0x000f280000300800ULL,
0x00001c00012b7983ULL, 0x000f280000300800ULL, 0x00002400012a7983ULL, 0x000f220000300800ULL,
0x0000001868287812ULL, 0x000fca00078efcffULL, 0x0000001028067825ULL, 0x000fc800078e0006ULL,
0x0000001028087825ULL, 0x040fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006797faeULL, 0x000fe6000b901c4eULL, 0x00000010280a7825ULL, 0x040fe200078e000aULL,
0x00000000087b7faeULL, 0x000fe6000b901c4eULL, 0x00000010280c7825ULL, 0x040fe200078e000cULL,
0x000000000a7d7faeULL, 0x000fe6000b901c4eULL, 0x00000010280e7825ULL, 0x000fc800078e000eULL,
0x0000001028107825ULL, 0x000fc800078e0010ULL, 0x0000001028127825ULL, 0x000fc800078e0012ULL,
0x0000001028147825ULL, 0x000fc800078e0014ULL, 0x0000001028167825ULL, 0x000fc800078e0016ULL,
0x0000001028187825ULL, 0x000fc800078e0018ULL, 0x00000010281a7825ULL, 0x000fc800078e001aULL,
0x00000010281c7825ULL, 0x000fc800078e001cULL, 0x00000010281e7825ULL, 0x000fc800078e001eULL,
0x0000001028207825ULL, 0x000fc800078e0020ULL, 0x0000001028227825ULL, 0x040fe200078e0022ULL,
0x000000000c297faeULL, 0x0045e8000b901c4eULL, 0x000000000e467faeULL, 0x0083e8000b901c4eULL,
0x00000000107c7faeULL, 0x0003e8000b901c4eULL, 0x0000000012457faeULL, 0x0103e2000b901c4eULL,
0x0000001028287825ULL, 0x004fc600078e0050ULL, 0x0000000014447faeULL, 0x0003e8000b901c4eULL,
0x00000000162b7faeULL, 0x0003e8000b901c4eULL, 0x00000000182a7faeULL, 0x0003e8000b901c4eULL,
0x000000001a767faeULL, 0x0203e8000b901c4eULL, 0x000000001c707faeULL, 0x0003e8000b901c4eULL,
0x000000001e727faeULL, 0x0003e8000b901c4eULL, 0x0000000020747faeULL, 0x0003e8000b901c4eULL,
0x00000000227a7faeULL, 0x0003e8000b901c4eULL, 0x0000000028787faeULL, 0x0003e4000b901c4eULL,
0x0000740001087983ULL, 0x002ea80000300800ULL, 0x00007c0001137983ULL, 0x000ee80000300800ULL,
0x0000840001127983ULL, 0x000f280000300800ULL, 0x00008c0001107983ULL, 0x000f680000300800ULL,
0x0000900001117983ULL, 0x000f220000300800ULL, 0x0000000911097291ULL, 0x000fc6000f8e083fULL,
0x0000940001287983ULL, 0x000f220000300800ULL, 0x000000040900728cULL, 0x000fe2000bf06070ULL,
0x0000000000067919ULL, 0x000e6a0000000000ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x00000000000079afULL, 0x000e280000000000ULL, 0x0000800001237983ULL, 0x000f220000300800ULL,
0x000000090b088291ULL, 0x000fe2000f8e083fULL, 0x00008c00000c8ab9ULL, 0x000fc40000000a00ULL,
0x0000880001227983ULL, 0x000f220000300800ULL, 0x00000004080c88a5ULL, 0x000fc6000f8e000cULL,
0x0000780001217983ULL, 0x000f280000300800ULL, 0x0000680001207983ULL, 0x000f280000300800ULL,
0x0000700001467983ULL, 0x000f220000300800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000004ff517819ULL, 0x002fe20000011606ULL, 0x00006c00012b7983ULL, 0x000f280000300800ULL,
0x0000001051097836ULL, 0x000fe20000000000ULL, 0x00006400012a7983ULL, 0x000f280000300800ULL,
0x0000000709097812ULL, 0x000fe200078e7804ULL, 0x0000600001297983ULL, 0x000f280000300800ULL,
0x0000002004097824ULL, 0x000fca00078e0209ULL, 0x0000000609097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000cff067e24ULL, 0x000fe4000f8e00ffULL, 0x0000000dff077e24ULL, 0x000fca000f8e00ffULL,
0x0000000e06068981ULL, 0x000328000c1e1900ULL, 0x00000000080c783bULL, 0x004fe80000000200ULL,
0x000000000908783bULL, 0x000fe80000000200ULL, 0x00000000131c783bULL, 0x008fe80000000200ULL,
0x000000001014783bULL, 0x020ea80000000200ULL, 0x000000001218783bULL, 0x010ee20000000200ULL,
0x00000014083c723cULL, 0x004fec000004183cULL, 0x000000160840723cULL, 0x000fe20000041840ULL,
0x000000002814783bULL, 0x0005e80000000200ULL, 0x00005c0001287983ULL, 0x004ea80000300800ULL,
0x0000580001457983ULL, 0x000f280000300800ULL, 0x0000440001447983ULL, 0x000f620000100800ULL,
0x0000000c082c723cULL, 0x000fee000004182cULL, 0x00000012510d7836ULL, 0x000fca0000000000ULL,
0x000000070d0d7812ULL, 0x000fca00078e7804ULL, 0x00000020040d7824ULL, 0x000fe200078e020dULL,
0x0000000e0830723cULL, 0x000fe80000041830ULL, 0x000000060d107c11ULL, 0x000fe4000f8e20ffULL,
0x00000000110c783bULL, 0x000fe80000000200ULL, 0x000000001010783bULL, 0x000ee20000000200ULL,
0x0000001c0824723cULL, 0x000fe20000041824ULL, 0x0000001451077836ULL, 0x002fca0000000000ULL,
0x0000001e0848723cULL, 0x000fec0000041848ULL, 0x000000180834723cULL, 0x008fec0000041834ULL,
0x0000001a0838723cULL, 0x000fe20000041838ULL, 0x000000002308783bULL, 0x000e620000000200ULL,
0x0000000707077812ULL, 0x000fc600078e7804ULL, 0x000000002218783bULL, 0x000ee40000000200ULL,
0x0000002004077824ULL, 0x000fe400078e0207ULL, 0x00000000211c783bULL, 0x000fe60000000200ULL,
0x0000000607077c11ULL, 0x000fe2000f8e20ffULL, 0x000000002020783bULL, 0x000fe20000000200ULL,
0x0000000c102c723cULL, 0x000fec000004182cULL, 0x0000000e1030723cULL, 0x000fe20000041830ULL,
0x00000000070c783bULL, 0x000eea0000000200ULL, 0x000000141024723cULL, 0x000fec0000041824ULL,
0x000000081034723cULL, 0x002fe20000041834ULL, 0x0000001651157836ULL, 0x000fca0000000000ULL,
0x0000000a1038723cULL, 0x000fe20000041838ULL, 0x000000004608783bULL, 0x000e620000000200ULL,
0x0000000715157812ULL, 0x000fca00078e7804ULL, 0x0000002004157824ULL, 0x000fe200078e0215ULL,
0x000000161048723cULL, 0x000fe80000041848ULL, 0x0000000615157c11ULL, 0x000fe4000f8e20ffULL,
0x00000018103c723cULL, 0x008fe8000004183cULL, 0x000000001514783bULL, 0x000fe40000000200ULL,
0x0000001a1040723cULL, 0x000fe40000041840ULL, 0x000000002b10783bULL, 0x000ee80000000200ULL,
0x0000001c0c2c723cULL, 0x000fe2000004182cULL, 0x000000002918783bULL, 0x000fea0000000200ULL,
0x0000001e0c30723cULL, 0x000fe20000041830ULL, 0x000000002a1c783bULL, 0x000eea0000000200ULL,
0x000000080c34723cULL, 0x002fec0000041834ULL, 0x000000200c24723cULL, 0x000fec0000041824ULL,
0x000000220c48723cULL, 0x000fec0000041848ULL, 0x0000000a0c38723cULL, 0x000fec0000041838ULL,
0x000000100c3c723cULL, 0x008fec000004183cULL, 0x000000120c40723cULL, 0x000fe20000041840ULL,
0x00000000060882caULL, 0x000fe200000e0000ULL, 0x0000000000507919ULL, 0x000e620000000000ULL,
0xffffffff00157882ULL, 0x000fc60000000000ULL, 0x0000001c142c723cULL, 0x000fec000004182cULL,
0x0000001e1430723cULL, 0x000fe40000041830ULL, 0x0000000800158c82ULL, 0x000fe40008000000ULL,
0x0000000a150872a4ULL, 0x000fc4000f8e023fULL, 0x000000181424723cULL, 0x000fec0000041824ULL,
0x0000001a1448723cULL, 0x000fe20000041848ULL, 0x000000002828783bULL, 0x004ea80000000200ULL,
0x000000004520783bULL, 0x010ee20000000200ULL, 0x000000281434723cULL, 0x004fee0000041834ULL,
0x0000001144287c36ULL, 0x020fc80008000000ULL, 0x0000000128067836ULL, 0x000fca0000000000ULL,
0x0000000506007c0cULL, 0x000fe4000bf06070ULL, 0x0000001328077c11ULL, 0x000fe2000f8e40ffULL,
0x0000002a1438723cULL, 0x000fe60000041838ULL, 0x00000040070c7812ULL, 0x000fc600078ec0ffULL,
0x00000020143c723cULL, 0x008fe4000004183cULL, 0x000000070c0c7c36ULL, 0x000fc80008000000ULL,
0x000000221440723cULL, 0x000fe20000041840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000800608947ULL, 0x002fde0003800000ULL, 0x00000014070e7c48ULL, 0x000fe2000ffe0000ULL,
0x0000000100067824ULL, 0x100fe400078e020cULL, 0x00000010500d7824ULL, 0x000fe400078e00ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a07ULL, 0x0000000806137c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000158077824ULL, 0x100fe200078e020cULL, 0x000000700d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000e5700720cULL, 0x040fe20003fa6070ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000807077c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000157577824ULL, 0x000fe200078e020cULL,
0x00000018130a7c11ULL, 0x000fc4000f8048ffULL, 0x0000000e5600720cULL, 0x040fe20003f86070ULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000001807167c11ULL, 0x000fe2000f8248ffULL,
0x0000000156567824ULL, 0x000fe200078e020cULL, 0x0000001913137c11ULL, 0x000fe400080f4c08ULL,
0x0000000857577c10ULL, 0x000fe4000ff1e0ffULL, 0x0000001907117c11ULL, 0x000fe200088f4c06ULL,
0x0000000153067824ULL, 0x000fe200078e020cULL, 0x0000000856567c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000001857147c11ULL, 0x000fc4000f8048ffULL,
0x0000000e5800720cULL, 0x080fe20003f46070ULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x0000001856127c11ULL, 0x000fe4000f8248ffULL, 0x0000001957097c11ULL, 0x000fe200080f4c08ULL,
0x0000000152087824ULL, 0x000fe200078e020cULL, 0x00000008060f7c10ULL, 0x000fe4000ff1e0ffULL,
0x00000019560b7c11ULL, 0x000fe400088f4c0bULL, 0x0000000e0000720cULL, 0x000fc40003f26070ULL,
0x0000000a0d067210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x000000180f107c11ULL, 0x040fe4000f8048ffULL, 0x0000000808177c10ULL, 0x000fe2000ffde0ffULL,
0x000000ffff077224ULL, 0x000fe200018e0613ULL, 0x000000190f0f7c11ULL, 0x000fe200080f4c0aULL,
0x0000000105087824ULL, 0x000fe200078e020cULL, 0x00000018171a7c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff0a7224ULL, 0x000fe200030e06ffULL, 0x0000000e5300720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000066a7faeULL, 0x0003e2000c901c4eULL,
0x0000000808157c10ULL, 0x000fc4000ff3e0ffULL, 0x0000001917177c11ULL, 0x000fe400080f4c0aULL,
0x000000140d087210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000e5200720cULL, 0x000fc60003f26070ULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x0000000e0500720cULL, 0x000fe20003f06070ULL, 0x0000000102057824ULL, 0x000fe200078e020cULL,
0x000000160d067210ULL, 0x002fca0007fde0ffULL, 0x000000ffff077224ULL, 0x000fe200030e0611ULL,
0x0000001815187c11ULL, 0x000fc8000f8c48ffULL, 0x0000001915157c11ULL, 0x000fe2000b0f4c0aULL,
0x0000000006697faeULL, 0x0003e2000d101c4eULL, 0x0000000805197c10ULL, 0x000fe2000ffde0ffULL,
0x0000000103057824ULL, 0x100fe200078e020cULL, 0x000000120d0a7210ULL, 0x000fe20007f5e0ffULL,
0x00000000086c7faeULL, 0x0005e2000e901c4eULL, 0x0000001819167c11ULL, 0x000fe2000f8a48ffULL,
0x000000ffff127224ULL, 0x000fe200030e06ffULL, 0x0000000805057c10ULL, 0x000fe2000ffde0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000e0200720cULL, 0x000fe20003f46070ULL,
0x0000000155027824ULL, 0x000fe200078e020cULL, 0x0000001919197c11ULL, 0x000fe2000a8f4c12ULL,
0x000000ffff127224ULL, 0x000fe200030e06ffULL, 0x0000001805147c11ULL, 0x000fe2000f8a48ffULL,
0x000000000a6d7faeULL, 0x0007e2000e101c4eULL, 0x000000100d067210ULL, 0x002fc40007fde0ffULL,
0x0000001905137c11ULL, 0x000fe2000a8f4c12ULL, 0x0000000159057824ULL, 0x100fe200078e020cULL,
0x0000001a0d087210ULL, 0x004fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200030e060fULL,
0x0000000802117c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000154027824ULL, 0x000fe200078e020cULL,
0x0000000e5500720cULL, 0x000fe20003fc6070ULL, 0x000000ffff097224ULL, 0x000fe200028e0617ULL,
0x00000000066e7faeULL, 0x000fe2000d901c4eULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x0000000802177c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000008667faeULL, 0x0003e2000c901c4eULL,
0x000000180d027210ULL, 0x000fe40007f3e0ffULL, 0x0000001811107c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff0a7224ULL, 0x008fe200018e06ffULL, 0x0000000e0300720cULL, 0x000fe20003fa6070ULL,
0x000000ffff037224ULL, 0x000fe200008e0615ULL, 0x0000001911117c11ULL, 0x000fe4000a0f4c12ULL,
0x0000000805157c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000167057824ULL, 0x000fe200078e020cULL,
0x0000001817187c11ULL, 0x040fe2000f8648ffULL, 0x0000000002657faeULL, 0x0005e2000c101c4eULL,
0x000000160d087210ULL, 0x002fe20007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200020e06ffULL,
0x0000001917177c11ULL, 0x000fc400098f4c0aULL, 0x0000001815127c11ULL, 0x040fe2000f8648ffULL,
0x000000ffff097224ULL, 0x000fe200000e0619ULL, 0x0000000805057c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001915157c11ULL, 0x000fe400098f4c06ULL, 0x000000140d0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff067224ULL, 0x000fe200020e06ffULL, 0x0000001805167c11ULL, 0x000fe2000f8048ffULL,
0x0000000163027824ULL, 0x004fe200078e020cULL, 0x0000000008647faeULL, 0x0003e2000d101c4eULL,
0x000000ffff0b7224ULL, 0x000fe200018e0613ULL, 0x0000001905137c11ULL, 0x000fc400080f4c06ULL,
0x00000008020f7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000015a027824ULL, 0x100fe200078e020cULL,
0x000000100d067210ULL, 0x000fe20007f5e0ffULL, 0x000000000a627faeULL, 0x0005e2000e901c4eULL,
0x0000000e5400720cULL, 0x080fe20003f26070ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x000000180f147c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff077224ULL, 0x000fe200010e0611ULL,
0x0000000802117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000016b0c7824ULL, 0x000fe200078e020cULL,
0x0000000e5900720cULL, 0x000fc40003f86070ULL, 0x000000180d027210ULL, 0x000fe20007fbe0ffULL,
0x0000000006617faeULL, 0x0007e2000f101c4eULL, 0x000000190f0f7c11ULL, 0x000fe200080f4c10ULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x000000120d087210ULL, 0x002fe20007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200028e0617ULL, 0x0000001811127c11ULL, 0x000fe4000f8448ffULL,
0x0000000e6700720cULL, 0x000fe20003f66070ULL, 0x000000ffff097224ULL, 0x000fe200000e0615ULL,
0x0000001911117c11ULL, 0x000fe200090f4c10ULL, 0x0000000002607faeULL, 0x0003e2000c901c4eULL,
0x000000080c057c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000e6300720cULL, 0x080fe20003fa6070ULL,
0x00000000085f7faeULL, 0x0009e2000e101c4eULL, 0x0000000e5a00720cULL, 0x080fe20003f06070ULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x000000160d0a7210ULL, 0x004fe40007f9e0ffULL,
0x0000000e6b00720cULL, 0x000fe40003f26070ULL, 0x000000140d0e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e0613ULL, 0x00000018050c7c11ULL, 0x000fc4000f8c48ffULL,
0x000000120d067210ULL, 0x008fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x0000001905057c11ULL, 0x000fe2000b0f4c10ULL, 0x000000000a5e7faeULL, 0x0009e2000d901c4eULL,
0x0000000c0d027210ULL, 0x002fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe400020e0611ULL,
0x000000000e5d7faeULL, 0x0009e4000e901c4eULL, 0x000000ffff037224ULL, 0x000fe400010e0605ULL,
0x00000000065c7faeULL, 0x0009e8000c101c4eULL, 0x00000000025b7faeULL, 0x0009e2000c901c4eULL,
0x0000000800147947ULL, 0x000fea0003800000ULL, 0x00000001050f7824ULL, 0x100fe400078e020cULL,
0x0000000100057824ULL, 0x100fe400078e020cULL, 0x0000000156567824ULL, 0x100fe400078e020cULL,
0x0000000102127824ULL, 0x100fe200078e020cULL, 0x0000000805057c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000158587824ULL, 0x100fe200078e020cULL, 0x0000000856567c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000157577824ULL, 0x000fc400078e020cULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000001805027c11ULL, 0x000fe2000f8048ffULL, 0x0000000103147824ULL, 0x100fe200078e020cULL,
0x0000000857577c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000153537824ULL, 0x000fe200078e020cULL,
0x0000001905037c11ULL, 0x000fe200080f4c06ULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x0000000858587c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x0000000853537c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000152527824ULL, 0x100fe200078e020cULL,
0x00000018560a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x0000001858067c11ULL, 0x000fe2000f8048ffULL, 0x0000000155557824ULL, 0x100fe200078e020cULL,
0x0000001857087c11ULL, 0x000fe2000f8248ffULL, 0x0000000154547824ULL, 0x100fe200078e020cULL,
0x00000019560b7c11ULL, 0x000fe200090f4c0bULL, 0x0000000159597824ULL, 0x100fe200078e020cULL,
0x0000000812137c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000167677824ULL, 0x100fe200078e020cULL,
0x0000001958077c11ULL, 0x000fe200080f4c07ULL, 0x0000000163637824ULL, 0x000fe200078e020cULL,
0x0000001957097c11ULL, 0x000fe200088f4c0eULL, 0x000000015a5a7824ULL, 0x100fe200078e020cULL,
0x0000000852527c10ULL, 0x000fe2000ff1e0ffULL, 0x000000016b6b7824ULL, 0x000fe200078e020cULL,
0x000000080f117c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x00000018530c7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x0000001813127c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00000019530d7c11ULL, 0x000fe200098f4c10ULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x0000000814157c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001050197824ULL, 0x000fe200078e00ffULL,
0x00000018520e7c11ULL, 0x000fc4000f8048ffULL, 0x0000001811107c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x0000001913137c11ULL, 0x000fe400090f4c18ULL,
0x0000000859597c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001815147c11ULL, 0x000fe4000f8648ffULL,
0x00000019520f7c11ULL, 0x000fe200080f4c0fULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x0000001911117c11ULL, 0x000fc400088f4c16ULL, 0x0000000855557c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000854547c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001915157c11ULL, 0x000fe200098f4c1aULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x0000000867677c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00000018591a7c11ULL, 0x000fe4000f8448ffULL,
0x0000001855167c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x0000001854187c11ULL, 0x000fc4000f8248ffULL, 0x00000019591b7c11ULL, 0x000fe400090f4c20ULL,
0x000000086b6b7c10ULL, 0x000fe4000ff5e0ffULL, 0x00000018671c7c11ULL, 0x000fe4000f8648ffULL,
0x0000001955177c11ULL, 0x000fe200080f4c1eULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x0000001954057c11ULL, 0x000fe400088f4c05ULL, 0x0000000863637c10ULL, 0x000fc4000ff1e0ffULL,
0x000000085a5a7c10ULL, 0x000fe4000ff3e0ffULL, 0x00000019671d7c11ULL, 0x000fe200098f4c22ULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x000000186b227c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x0000007019197812ULL, 0x000fe400078ec0ffULL,
0x00000018631e7c11ULL, 0x000fe4000f8048ffULL, 0x000000185a207c11ULL, 0x000fc4000f8248ffULL,
0x000000196b237c11ULL, 0x000fe400090f4c44ULL, 0x0000000219027210ULL, 0x000fe40007f5e0ffULL,
0x00000019631f7c11ULL, 0x000fe400080f4c2aULL, 0x000000195a217c11ULL, 0x000fe200088f4c21ULL,
0x000000ffff037224ULL, 0x000fe200010e0603ULL, 0x0000000619067210ULL, 0x000fe40007fde0ffULL,
0x0000000819087210ULL, 0x000fc40007f3e0ffULL, 0x0000000a190a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000000c190c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000000e190e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000001019107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000001219127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e060fULL, 0x0000001419147210ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000026a7faeULL, 0x0003e2000b901c4eULL,
0x0000001619167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0611ULL,
0x0000001819187210ULL, 0x000fe20007fbe0ffULL, 0x0000000006697faeULL, 0x0003e2000b901c4eULL,
0x0000001a191a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000001c191c7210ULL, 0x000fe20007f7e0ffULL, 0x00000000086c7faeULL, 0x0003e2000b901c4eULL,
0x0000001e191e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000002019207210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x000000000a6d7faeULL, 0x0003e2000b901c4eULL, 0x0000002219227210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fc400028e0605ULL, 0x000000000c6e7faeULL, 0x0003e2000b901c4eULL,
0x000000ffff1b7224ULL, 0x000fe400020e061bULL, 0x000000ffff1d7224ULL, 0x000fe200018e061dULL,
0x000000000e667faeULL, 0x0003e2000b901c4eULL, 0x000000ffff1f7224ULL, 0x000fe400010e061fULL,
0x000000ffff217224ULL, 0x000fe200008e0621ULL, 0x0000000010657faeULL, 0x0003e2000b901c4eULL,
0x000000ffff237224ULL, 0x000fc600000e0623ULL, 0x0000000012647faeULL, 0x0003e8000b901c4eULL,
0x0000000014627faeULL, 0x0003e8000b901c4eULL, 0x0000000016617faeULL, 0x0003e8000b901c4eULL,
0x0000000018607faeULL, 0x0003e8000b901c4eULL, 0x000000001a5f7faeULL, 0x0003e8000b901c4eULL,
0x000000001c5e7faeULL, 0x0003e8000b901c4eULL, 0x000000001e5d7faeULL, 0x0003e8000b901c4eULL,
0x00000000205c7faeULL, 0x0003e8000b901c4eULL, 0x00000000225b7faeULL, 0x0003e4000b901c4eULL,
0x0000540001087983ULL, 0x012ea80000300800ULL, 0x00005000010c7983ULL, 0x000ee80000300800ULL,
0x00004c0001057983ULL, 0x000f280000300800ULL, 0x0000380001107983ULL, 0x000f680000300800ULL,
0x0000300001077983ULL, 0x000f680000300800ULL, 0x00002c0001067983ULL, 0x000f680000300800ULL,
0x0000280001027983ULL, 0x000f620000300800ULL, 0x0000001851037836ULL, 0x000fe20000000000ULL,
0x00000006100c7291ULL, 0x000fc4000f8e183fULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000610087291ULL, 0x000fe2000f8e383fULL, 0x0000000703037812ULL, 0x000fca00078e7804ULL,
0x0000002004037824ULL, 0x000fca00078e0203ULL, 0x0000000603037c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000314783bULL, 0x0003e80000000200ULL,
0x000000006f6c783bULL, 0x000fe20000000200ULL, 0x0000001c51037836ULL, 0x002fca0000000000ULL,
0x0000000703037812ULL, 0x000fca00078e7804ULL, 0x0000002004037824ULL, 0x000fca00078e0203ULL,
0x0000000603037c11ULL, 0x000fca000f8e20ffULL, 0x000000000344783bULL, 0x000fe80000000200ULL,
0x000000000808783bULL, 0x004e680000000200ULL, 0x000000000c20783bULL, 0x008ea80000000200ULL,
0x00000000050c783bULL, 0x0107280000000200ULL, 0x00000000101c783bULL, 0x020f620000000200ULL,
0x0000001a51057836ULL, 0x008fc60000000000ULL, 0x000000000710783bULL, 0x000fe40000000200ULL,
0x0000000705057812ULL, 0x000fca00078e7804ULL, 0x0000002004057824ULL, 0x000fca00078e0205ULL,
0x0000000605057c11ULL, 0x000fca000f8e20ffULL, 0x000000000518783bULL, 0x0007620000000200ULL,
0x00000008142c723cULL, 0x002fe2000004182cULL, 0x0000001e51057836ULL, 0x008fca0000000000ULL,
0x0000000a1430723cULL, 0x000fe20000041830ULL, 0x000000000608783bULL, 0x000e620000000200ULL,
0x0000000705057812ULL, 0x000fc800078e7804ULL, 0x000000201424723cULL, 0x004fe20000041824ULL,
0x0000002004057824ULL, 0x000fca00078e0205ULL, 0x000000221448723cULL, 0x000fe20000041848ULL,
0x000000000220783bULL, 0x000ea20000000200ULL, 0x0000000605057c11ULL, 0x000fc8000f8e20ffULL,
0x0000000c1434723cULL, 0x010fe40000041834ULL, 0x000000000504783bULL, 0x000fe80000000200ULL,
0x0000000e1438723cULL, 0x000fe20000041838ULL, 0x00000000770c783bULL, 0x000ee80000000200ULL,
0x000000007574783bULL, 0x000fe20000000200ULL, 0x0000001c143c723cULL, 0x020fec000004183cULL,
0x0000001e1440723cULL, 0x000fe20000041840ULL, 0x000000007314783bULL, 0x000f280000000200ULL,
0x000000004d1c783bULL, 0x000fe20000000200ULL, 0x00000010182c723cULL, 0x000fec000004182cULL,
0x000000121830723cULL, 0x000fe20000041830ULL, 0x000000007110783bULL, 0x000f6a0000000200ULL,
0x000000081824723cULL, 0x002fec0000041824ULL, 0x0000000a1848723cULL, 0x000fe20000041848ULL,
0x000000004f08783bULL, 0x000fea0000000200ULL, 0x000000221838723cULL, 0x004fec0000041838ULL,
0x0000000c183c723cULL, 0x008fec000004183cULL, 0x000000201834723cULL, 0x000fec0000041834ULL,
0x0000000e1840723cULL, 0x000fe20000041840ULL, 0x000000004e0c783bULL, 0x000e6a0000000200ULL,
0x000000144420723cULL, 0x010fe20000041824ULL, 0x00000001ff187424ULL, 0x000fe200078e00ffULL,
0x000000004c24783bULL, 0x000ea60000000200ULL, 0x01c68818ff0279a7ULL, 0x000ee2000850000cULL,
0x000000164414723cULL, 0x000fec0000041848ULL, 0x000000124438723cULL, 0x020fec0000041838ULL,
0x00000074442c723cULL, 0x000fec000004182cULL, 0x000000764430723cULL, 0x000fe20000041830ULL,
0x01c68803ff0075a7ULL, 0x008eea000800014cULL, 0x0000006c443c723cULL, 0x000fec000004183cULL,
0x000000104434723cULL, 0x000fec0000041834ULL, 0x0000006e4440723cULL, 0x000fec0000041840ULL,
0x0000000c0420723cULL, 0x002fec0000041820ULL, 0x0000000e0414723cULL, 0x000fec0000041814ULL,
0x0000001e040c723cULL, 0x000fec0000041838ULL, 0x00000008042c723cULL, 0x000fec000004182cULL,
0x0000000a0430723cULL, 0x000fe20000041830ULL, 0x3d80000020207820ULL, 0x000fe20000410000ULL,
0x3d80000021217820ULL, 0x000fe20000410000ULL, 0x3d80000022227820ULL, 0x000fe20000410000ULL,
0x3d80000023237820ULL, 0x000fc40000410000ULL, 0x000000240408723cULL, 0x004fe2000004183cULL,
0x3d80000014147820ULL, 0x000fe20000410000ULL, 0x3d80000015157820ULL, 0x000fe20000410000ULL,
0x3d80000016167820ULL, 0x000fe20000410000ULL, 0x3d80000017177820ULL, 0x000fe40000410000ULL,
0x0000001c0410723cULL, 0x000fe20000041834ULL, 0x3d8000000d0d7820ULL, 0x000fe20000410000ULL,
0x3d8000000e0e7820ULL, 0x000fe20000410000ULL, 0x3d8000000f0f7820ULL, 0x000fc60000410000ULL,
0x000000260404723cULL, 0x000fe20000041840ULL, 0x3d8000000c1d7820ULL, 0x000fe20000410000ULL,
0x00000004500c7824ULL, 0x000fe400078e00ffULL, 0x3d8000002c197820ULL, 0x000fe20000410000ULL,
0x3d8000002d1a7820ULL, 0x000fe20000410000ULL, 0x3d8000002e1c7820ULL, 0x000fe20000410000ULL,
0x3d8000002f1b7820ULL, 0x000fe20000410000ULL, 0x3d80000030307820ULL, 0x000fe20000410000ULL,
0x3d80000031317820ULL, 0x000fe20000410000ULL, 0x3d80000032327820ULL, 0x000fe20000410000ULL,
0x3d80000033337820ULL, 0x000fe20000410000ULL, 0x3d800000081e7820ULL, 0x000fe20000410000ULL,
0x3d800000091f7820ULL, 0x000fe20000410000ULL, 0xfffffff00c087812ULL, 0x000fe200078ec0ffULL,
0x3d8000000a0a7820ULL, 0x000fe20000410000ULL, 0x3d8000000b0b7820ULL, 0x000fc40000410000ULL,
0x3d80000010107820ULL, 0x000fe20000410000ULL, 0x3d80000011117820ULL, 0x000fe20000410000ULL,
0x3d80000012127820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fc60000410000ULL,
0x3d80000004247820ULL, 0x000fe20000410000ULL, 0x3d80000005257820ULL, 0x000fe20000410000ULL,
0x3d800000060c7820ULL, 0x000fe20000410000ULL, 0x3d80000007097820ULL, 0x000fe20000410000ULL,
0x0000001000e48947ULL, 0x008fec0003800000ULL, 0x0000440001267983ULL, 0x000ea20000300800ULL,
0xffffffff050c7890ULL, 0x000fc6000fffe03fULL, 0x01c4000808047984ULL, 0x0002620008000c00ULL,
0x0000000000377919ULL, 0x000e640000000000ULL, 0x0000000c26007c0cULL, 0x004fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x0000000237027824ULL, 0x000fe200078e00ffULL,
0x8000001214127290ULL, 0x000fc8000fffe03fULL, 0x0000000602027812ULL, 0x000fc800078ec0ffULL,
0x0000000102037812ULL, 0x040fe400078efcffULL, 0x0000000802267812ULL, 0x040fe400078efcffULL,
0x0000001203007c0cULL, 0x000fe4000bf26070ULL, 0x0000001002037812ULL, 0x000fe400078efcffULL,
0x0000001226007c0cULL, 0x000fe4000bf06070ULL, 0x0000001203007c0cULL, 0x000fc4000bfc6070ULL,
0x0000001102267812ULL, 0x040fe400078efcffULL, 0x0000001802037812ULL, 0x040fe400078efcffULL,
0x0000001202007c0cULL, 0x000fe4000bf46070ULL, 0x0000001226007c0cULL, 0x000fe4000bfa6070ULL,
0x0000001203007c0cULL, 0x000fe4000bf66070ULL, 0x0000000902277812ULL, 0x000fc400078efcffULL,
0x0000001902267812ULL, 0x040fe400078efcffULL, 0x0000002002037812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff19197808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff1a1a7808ULL, 0x000fc40004800000ULL,
0x0000001227007c0cULL, 0x000fe4000bf86070ULL, 0x0000001226007c0cULL, 0x000fe4000bf46070ULL,
0x0000001203007c0cULL, 0x000fe4000bf26070ULL, 0x0000002102267812ULL, 0x040fe400078efcffULL,
0x0000002802037812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fc40004000000ULL,
0xff7fffff30307808ULL, 0x000fe40004000000ULL, 0xff7fffff33337808ULL, 0x000fe40006000000ULL,
0xff7fffff31317808ULL, 0x000fe40006000000ULL, 0x0000001226007c0cULL, 0x000fe4000bf06070ULL,
0x0000001203007c0cULL, 0x000fe4000bf86070ULL, 0x0000002902267812ULL, 0x000fc400078efcffULL,
0x0000003002037812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0x0000001226007c0cULL, 0x000fc4000bfc6070ULL,
0x0000001203007c0cULL, 0x000fe4000bfa6070ULL, 0x0000003102267812ULL, 0x040fe400078efcffULL,
0x0000003802037812ULL, 0x040fe400078efcffULL, 0x0000003902027812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff10107808ULL, 0x000fe40004800000ULL,
0x0000001226007c0cULL, 0x000fe4000bf66070ULL, 0x0000001203007c0cULL, 0x000fc4000bf46070ULL,
0x0000001202007c0cULL, 0x000fe4000bf26070ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40006000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006000000ULL, 0xff7fffff0f0f7808ULL, 0x000fc40007000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40007000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40006800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL, 0xff7fffff0c0c7808ULL, 0x000fc40005000000ULL,
0xff7fffff24247808ULL, 0x000fe40005000000ULL, 0xff7fffff09097808ULL, 0x000fe40004800000ULL,
0xff7fffff25257808ULL, 0x000fce0004800000ULL, 0x0000001904037209ULL, 0x000fe20007810000ULL,
0x00000010ff267e24ULL, 0x000fe2000f8e00ffULL, 0x0000001c05027209ULL, 0x000fe20007810000ULL,
0xffffffff000c7882ULL, 0x000fe20000000000ULL, 0x0000001a03037209ULL, 0x000fe40007810000ULL,
0x0000001b02057209ULL, 0x000fe40007810000ULL, 0x0000003003027209ULL, 0x000fe40007810000ULL,
0x0000003205047209ULL, 0x000fc40007810000ULL, 0x0000003102037209ULL, 0x000fe40007810000ULL,
0x0000003304057209ULL, 0x000fe40007810000ULL, 0x0000002003027209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fe40007810000ULL, 0x0000002102037209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fc40007810000ULL, 0x0000001403027209ULL, 0x000fe40007810000ULL,
0x0000001605047209ULL, 0x000fe40007810000ULL, 0x0000001502037209ULL, 0x000fe40007810000ULL,
0x0000001704057209ULL, 0x000fe40007810000ULL, 0x0000001003027209ULL, 0x000fe40007810000ULL,
0x0000001205047209ULL, 0x000fc40007810000ULL, 0x0000001102027209ULL, 0x000fe40007810000ULL,
0x0000001304037209ULL, 0x000fe40007810000ULL, 0x0000001d02027209ULL, 0x000fe40007810000ULL,
0x0000000e03047209ULL, 0x000fe40007810000ULL, 0x0000000d02037209ULL, 0x000fe40007810000ULL,
0x0000000f04057209ULL, 0x000fc40007810000ULL, 0x0000001e03027209ULL, 0x000fe40007810000ULL,
0x0000000a05047209ULL, 0x000fe40007810000ULL, 0x0000001f02037209ULL, 0x000fe40007810000ULL,
0x0000000b04057209ULL, 0x000fe40007810000ULL, 0x0000002403027209ULL, 0x000fe40007810000ULL,
0x0000000c05047209ULL, 0x000fc40007810000ULL, 0x0000000626037c11ULL, 0x000fe4000f8e28ffULL,
0x0000002502057209ULL, 0x000fe40007810000ULL, 0x0000000904047209ULL, 0x000fe20007810000ULL,
0x0000000e0c507947ULL, 0x000fec000b800000ULL, 0x0c401f0005027f89ULL, 0x000e6800000e0000ULL,
0x0c401f0004277f89ULL, 0x000ea800000e0000ULL, 0x0c401f00062b7f89ULL, 0x000ee800000e0000ULL,
0x0c401f00072a7f89ULL, 0x000f2200000e0000ULL, 0x0000000205267209ULL, 0x002fc40007810000ULL,
0x0000002704297209ULL, 0x004fc60007810000ULL, 0x0c201f00262d7f89ULL, 0x000e6200000e0000ULL,
0x0000002b062b7209ULL, 0x008fc60007810000ULL, 0x0c201f00292c7f89ULL, 0x000ea200000e0000ULL,
0x0000002a07027209ULL, 0x010fc60007810000ULL, 0x0c201f002b2e7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0002277f89ULL, 0x00092200000e0000ULL, 0x0000002d26047209ULL, 0x002fe40007810000ULL,
0x0000002c29057209ULL, 0x004fe40007810000ULL, 0x0000002e2b067209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b04267820ULL, 0x000fe20000410000ULL, 0x3f800000000c7882ULL, 0x000fc60000000000ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b25257823ULL, 0x000fe20000010826ULL,
0x3fb8aa3b05267820ULL, 0x000fe20000410000ULL, 0x0000001900197308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010826ULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b09097823ULL, 0x000fc40000010826ULL,
0x0000001400077308ULL, 0x000ff00000000800ULL, 0x0000001000297308ULL, 0x000ff00000000800ULL,
0x0000001d002b7308ULL, 0x000ff00000000800ULL, 0x0000001f00347308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000001c001d7308ULL, 0x0003f00000000800ULL, 0x0000001b00107308ULL, 0x000ea20000000800ULL,
0x000000191a1c723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b17197823ULL, 0x000fcc0000010826ULL,
0x00000032001f7308ULL, 0x000fe20000000800ULL, 0x0000001d101d723eULL, 0x004fce00000010ffULL,
0x0000003300147308ULL, 0x000e700000000800ULL, 0x00000015002a7308ULL, 0x0005e20000000800ULL,
0x0000001f141f723eULL, 0x002fce00000010ffULL, 0x0000001e002d7308ULL, 0x0003e20000000800ULL,
0x0000000cff157e24ULL, 0x004fca000f8e00ffULL, 0x3f800000151a783eULL, 0x000fe400000010ffULL,
0x0000000d002e7308ULL, 0x0005e20000000800ULL, 0x00000030311e723eULL, 0x002fe400000010ffULL,
0x000000ffff1b7224ULL, 0x000fca00078e001aULL, 0x00000011002c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b160d7823ULL, 0x104fe20000010826ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000001a1c14723cULL, 0x000fe200000418ffULL, 0x0000002200117308ULL, 0x000fec0000000800ULL,
0x3fb8aa3b131b7823ULL, 0x000fc40000010826ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x0000002300367308ULL, 0x0004e20000000800ULL,
0x000000202110723eULL, 0x002fce00000010ffULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12237823ULL, 0x104fe20000010826ULL, 0x000000072a12723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b0c077823ULL, 0x000fe20000010826ULL, 0x000000292c20723eULL, 0x000fe400000010ffULL,
0x0000002d340c723eULL, 0x000fe400000010ffULL, 0x0000001900227308ULL, 0x000e620000000800ULL,
0x000000113611723eULL, 0x008fce00000010ffULL, 0x0000001b00307308ULL, 0x0005e20000000800ULL,
0x0000000d2213723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x000000ffff1b7224ULL, 0x004fe200078e001aULL, 0x0000002b2e22723eULL, 0x000fcc00000010ffULL,
0x0000001a1014723cULL, 0x000fe20000041814ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000233021723eULL, 0x002fce00000010ffULL, 0x0000000f000f7308ULL, 0x000e700000000800ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x0000000e0f23723eULL, 0x002fce00000010ffULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x0000001a2030723cULL, 0x000fee0000041814ULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x00000024250e723eULL, 0x002fce00000010ffULL,
0x0000000b000b7308ULL, 0x000e700000000800ULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x0000000a0b0d723eULL, 0x002fce00000010ffULL, 0x0000000900147308ULL, 0x000e620000000800ULL,
0x0000000fff0a7424ULL, 0x000fe200078e00ffULL, 0x00000007140f723eULL, 0x002fe400000010ffULL,
0xfffffffc37077812ULL, 0x000fc800078ec0ffULL, 0x000000070a0b7219ULL, 0x000fe200000006ffULL,
0x0000001a0c30723cULL, 0x000fe20000041830ULL, 0x0000002702077209ULL, 0x010fde0007810000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x001c1fff30147589ULL, 0x00026200000e0000ULL,
0x0000000000167806ULL, 0x000fe200038e0100ULL, 0x000000000b0a73a1ULL, 0x000eb000000e8000ULL,
0x000000000b0c73c4ULL, 0x000ee20000004000ULL, 0x00000000000d7886ULL, 0x000fc400038e0100ULL,
0x0000000d0bff7c12ULL, 0x004fda000f80400aULL, 0x0000000a0c588947ULL, 0x00afea000b800000ULL,
0x001c1fff32157589ULL, 0x0002a800000e0000ULL, 0x001c1fff16167589ULL, 0x000ee800000e0000ULL,
0x001c1fff00177589ULL, 0x00032400000e0000ULL, 0xfffffff8ff687812ULL, 0x000fe200078ee268ULL,
0x00000006100c7291ULL, 0x000fe2000f8e583fULL, 0x0000000300197812ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200078e001cULL, 0x0000000337ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000868027836ULL, 0x040fe20000000000ULL, 0x00000004191b7812ULL, 0x000fe200078efcffULL,
0x0000000868007824ULL, 0x002fe200078e00ffULL, 0x0000000719097812ULL, 0x000fe200078e7868ULL,
0x0000000cff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x000000071b0b7812ULL, 0x000fe200078e7868ULL,
0x000000ffff257224ULL, 0x000fe200078e001eULL, 0x0000000719197812ULL, 0x000fe200078e7802ULL,
0x000120000a0a7836ULL, 0x000fe20000000000ULL, 0x000000071b1b7812ULL, 0x000fe200078e7802ULL,
0x0000000802027824ULL, 0x000fe200078e00ffULL, 0x0000000009097212ULL, 0x080fe200078efcffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x000000000b0b7212ULL, 0x000fe200078efcffULL,
0x000000ffff277224ULL, 0x000fe200078e0012ULL, 0x0000000219197212ULL, 0x080fe200078efcffULL,
0x0000001009097824ULL, 0x100fe200078e020aULL, 0x000000021b1b7212ULL, 0x000fe200078efcffULL,
0x000000ffff1c7224ULL, 0x000fe200078e001dULL, 0x0000442801007387ULL, 0x0003e20000100800ULL,
0x000000100b0b7824ULL, 0x000fc400078e020aULL, 0x000000ffff2c7224ULL, 0x000fe200078e0020ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000002409007844ULL, 0x0003e20000000200ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0022ULL, 0x000000ffff2e7224ULL, 0x000fe400078e000cULL,
0x000000ffff2f7224ULL, 0x000fc400078e000eULL, 0x000000ffff1d7224ULL, 0x000fe400078e001fULL,
0x0000001019197824ULL, 0x100fe200078e020aULL, 0x0000002c0b007844ULL, 0x0003e20000000200ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0013ULL,
0x000000101b1b7824ULL, 0x000fe400078e020aULL, 0x000000ffff107224ULL, 0x000fe200078e0021ULL,
0x0000001c19007844ULL, 0x0003e20000000200ULL, 0x000000ffff117224ULL, 0x000fc400078e0023ULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fca00078e000fULL,
0x000000101b007844ULL, 0x0003e80000000200ULL, 0x01c0000408008988ULL, 0x0003e80008000c08ULL,
0x01c2001408008988ULL, 0x01c3e20008000c08ULL, 0x0000000528007c0cULL, 0x000fe2000bf06070ULL,
0x01c6081803ff79a7ULL, 0x0003e2000850003fULL, 0x01c6101803ff79a7ULL, 0x0003e2000850003fULL,
0x01c6181803ff79a7ULL, 0x0003e2000850003fULL, 0x01c6201803ff79a7ULL, 0x0003f2000850003fULL,
0xffffff9000c48947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x01c60825ff0075a7ULL, 0x0002620008020158ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c60825ff0095a7ULL, 0x000e640008020058ULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xfffffed800e47947ULL, 0x000fea000383ffffULL,
0x01c62825ff0075a7ULL, 0x0002620008020158ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c62825ff0095a7ULL, 0x000e640008020058ULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xfffffefc000c7947ULL, 0x000fea000383ffffULL,
0x01c64825ff0075a7ULL, 0x0002620008020158ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c64825ff0095a7ULL, 0x000e640008020058ULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff1400ac7947ULL, 0x000fea000383ffffULL,
0x01c66813ff0075a7ULL, 0x0002620008000158ULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c66813ff0085a7ULL, 0x000e640008000058ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff3000347947ULL, 0x000fea000383ffffULL,
0x01c60003ff0075a7ULL, 0x0004a20008000146ULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c60003ff0085a7ULL, 0x000e640008000046ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff90003c7947ULL, 0x00afea000383ffffULL,
0x0000000cff057e24ULL, 0x000fc8000f8e00ffULL, 0x01c68803050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c68803050085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffec00007947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe400078e0005ULL, 0x00000002ff357424ULL, 0x000fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fce00078e00ffULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003536347389ULL, 0x0006e40000000038ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff367224ULL, 0x002fe400078e0004ULL, 0x00000002ff357424ULL, 0x000fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff027224ULL, 0x004fce00078e0034ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003536347389ULL, 0x0002640000000038ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000205267209ULL, 0x000fe20007810000ULL, 0x000000ffff367224ULL, 0x000fe400078e0006ULL,
0x000000ffff277224ULL, 0x000fce00078e0034ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003536347389ULL, 0x0002640000000038ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002704297209ULL, 0x000fe20007810000ULL, 0x000000ffff367224ULL, 0x000fe400078e0007ULL,
0x000000ffff2b7224ULL, 0x000fce00078e0034ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003536347389ULL, 0x0002640000000038ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002b062b7209ULL, 0x000fe20007810000ULL, 0x000000ffff367224ULL, 0x000fe400078e0026ULL,
0x00000001ff357424ULL, 0x000fe400078e00ffULL, 0x000000ffff2a7224ULL, 0x000fce00078e0034ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003536347389ULL, 0x0002640000000038ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002a07027209ULL, 0x000fe20007810000ULL,
0x000000ffff367224ULL, 0x000fe400078e0029ULL, 0x000000ffff2d7224ULL, 0x000fce00078e0034ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003536347389ULL, 0x0002640000000038ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002d26047209ULL, 0x000fe20007810000ULL,
0x000000ffff367224ULL, 0x000fe400078e002bULL, 0x000000ffff2c7224ULL, 0x000fce00078e0034ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003536347389ULL, 0x0002640000000038ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002c29057209ULL, 0x000fe20007810000ULL,
0x000000ffff367224ULL, 0x000fe400078e0002ULL, 0x000000ffff2e7224ULL, 0x000fce00078e0034ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003536347389ULL, 0x0002640000000038ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002e2b067209ULL, 0x000fe20007810000ULL,
0x000000ffff277224ULL, 0x000fe200078e0034ULL, 0xfffffff000087947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff177224ULL, 0x000fe400078e00ffULL,
0x00001c1fff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e000bULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000001732177389ULL, 0x0006e40000000002ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x004fe400078e0017ULL,
0x000000ffff327224ULL, 0x002fe400078e0016ULL, 0x000000ffff177224ULL, 0x000fe400078e00ffULL,
0x00001c1fff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e000bULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000001732177389ULL, 0x0006e40000000002ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x004fe400078e0017ULL,
0x000000ffff327224ULL, 0x002fe400078e0000ULL, 0x000000ffff177224ULL, 0x000fe400078e00ffULL,
0x00001c1fff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e000bULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000001732177389ULL, 0x0006e40000000002ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff400407947ULL, 0x006fea000383ffffULL, 0x0180000035007836ULL, 0x000fe20000000000ULL,
0x0000016000007945ULL, 0x000fe80003800000ULL, 0x7f80000000037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000003500008308ULL, 0x0002a20000001000ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x008000000300780cULL, 0x040fe40003f22070ULL,
0x000000ff0300720cULL, 0x000fe40003f05070ULL, 0xffffffffff007807ULL, 0x004fe40004800000ULL,
0x00000001ff037807ULL, 0x000fc60000000000ULL, 0x000000ffff007224ULL, 0x000fca00078e0a00ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000000000248947ULL, 0x000fea0003800000ULL,
0x007fffff35007812ULL, 0x000fc800078ec0ffULL, 0x000000ff0000720cULL, 0x000fc80003f02070ULL,
0xffffffffff007807ULL, 0x000fca0004000000ULL, 0x000000ffff007224ULL, 0x000fca00078e0a00ULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000035037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000003500007308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffea8027c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000658ULL, 0x0000000000000558ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bb0ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000bd0ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000bd0ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000c00ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000c48ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000c50ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000c80ULL, 0x0000000000015700ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016380ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000016390ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016390ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000016390ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000016a78ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016a78ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000c48ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000c80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000015700ULL, 0x0000000000015700ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000016380ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016390ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 93128;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
