/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_128_nqpkv_16_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015f10ULL, 0x0000000000015a90ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000014850ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x00000000000149c0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000014a00ULL, 0x0000000000000100ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000014b00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001485000000000ULL, 0x0000040400000000ULL, 0x810c0000007c0400ULL, 0x00518c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080a80828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a892ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001485000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a80828808081ULL, 0x8016288080ac0828ULL, 0x0000000310288082ULL, 0x80ac920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x000149c000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080a80828808081ULL,
0x8e08288080ac0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808e920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x00014a0000000000ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000a1ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00013a8000183104ULL, 0x00013d3000013d10ULL, 0x00013e0000013df0ULL,
0x0128290400013e10ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001505000015ULL, 0x0500001505000015ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000c001282804ULL, 0x000015c000000100ULL,
0x0000241000002360ULL, 0x000024b000002490ULL, 0x00002a10000029d0ULL, 0x0000396000002c10ULL,
0x00003bd000003970ULL, 0x00004a1000004970ULL, 0x00004aa000004a70ULL, 0x00004dd000004dc0ULL,
0x00005ba000004fb0ULL, 0x00005e8000005bb0ULL, 0x00006c0000006b60ULL, 0x00006c9000006c60ULL,
0x00006fc000006fb0ULL, 0x00007db0000071a0ULL, 0x0000809000007dc0ULL, 0x00008ef000008e50ULL,
0x00008f8000008f60ULL, 0x000092b0000092a0ULL, 0x0000a0b0000094c0ULL, 0x0000a5300000a0c0ULL,
0x0000ae300000a540ULL, 0x0000cd700000cc30ULL, 0x0000d2f00000d2c0ULL, 0x000136600000db30ULL,
0x000136a000013690ULL, 0x000136e0000136b0ULL, 0x0001371000013700ULL, 0x00013de000013720ULL,
0x00013e5000013e40ULL, 0x0001448000013e60ULL, 0x00014530000144e0ULL, 0x000145d000014580ULL,
0x0001467000014620ULL, 0x00014720000146c0ULL, 0x000147e000014790ULL, 0x0170390400014830ULL,
0x000000ff00000170ULL, 0x003f010000014600ULL, 0x0000000b000001b0ULL, 0x003f013000014608ULL,
0x0000000b000001d0ULL, 0x003f013000014610ULL, 0x000000ff00000530ULL, 0x003f010700014600ULL,
0x0000000000000700ULL, 0x003f010200000004ULL, 0x00000000000007c0ULL, 0x003f010100000000ULL,
0x000000ff000021d0ULL, 0x003f01060001460cULL, 0x000000ff000022a0ULL, 0x003f01060001460cULL,
0x000000ff00003bb0ULL, 0x003f010100014610ULL, 0x000000ff000047a0ULL, 0x003f01060001461cULL,
0x000000ff000048f0ULL, 0x003f01060001461cULL, 0x000000ff00005e50ULL, 0x003f010100014620ULL,
0x000000ff00006a30ULL, 0x003f01060001462cULL, 0x000000ff00006ae0ULL, 0x003f01060001462cULL,
0x000000ff00008060ULL, 0x003f010100014630ULL, 0x000000ff00008c50ULL, 0x003f01060001463cULL,
0x000000ff00008dc0ULL, 0x003f01060001463cULL, 0x000000ff0000a360ULL, 0x003f010100014640ULL,
0x000000ff0000ec80ULL, 0x003f010600014604ULL, 0x000000ff0000ed10ULL, 0x003f010600014604ULL,
0x0000006100012b20ULL, 0x003f010600014614ULL, 0x0000006100012f40ULL, 0x003f010600014614ULL,
0x00000061000143e0ULL, 0x003f010100014608ULL, 0x00101c0400033803ULL, 0x0000ed600000df70ULL,
0x000144400000ee10ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001c4ULL,
0x0000001100000002ULL, 0x0000000000000144ULL, 0x0000001100000002ULL, 0x00000000000000ccULL,
0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL, 0x000000000000019aULL,
0x0000001100000002ULL, 0x000000000000011dULL, 0x0000001100000002ULL, 0x00000000000000a8ULL,
0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff177424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e620000002200ULL, 0x0000580000047ab9ULL, 0x000fc60000000800ULL,
0x0000000000677919ULL, 0x000ea80000002100ULL, 0x0000000000627919ULL, 0x000ee80000002700ULL,
0x00000000005f7919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x00000080000b7824ULL, 0x104fe200078e0267ULL, 0x00000005ff677819ULL, 0x000fe20000011667ULL,
0x00001fff06007589ULL, 0x000e6200000e0000ULL, 0x0000620062087625ULL, 0x008fe400078e0017ULL,
0x000000ff0b00720cULL, 0x040fe40003f05270ULL, 0x000000030b00780cULL, 0x040fe20003f24070ULL,
0x00001fff67677589ULL, 0x000ea200000e0000ULL, 0x0000007f0b00780cULL, 0x000fd20003f44070ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe200078e00ffULL,
0x7fffff8000079802ULL, 0x000fe20000000f00ULL, 0x3fffffe0ff049424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff059424ULL, 0x000fe200078e00ffULL, 0x01460002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0xff317217ff0aa424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff069424ULL, 0x000fe200078e00ffULL, 0x014608040b009388ULL, 0x0007e8000000ca00ULL,
0x0144000a0b00a388ULL, 0x0007e80000004800ULL, 0x014610060b009388ULL, 0x0007e8000000ca00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003a000000947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x014e620000000000ULL, 0x0000000467027824ULL, 0x008fe200078e00ffULL,
0x0000000404057899ULL, 0x000fe2000800063fULL, 0x000000105f037824ULL, 0x000fc400078e00ffULL,
0x00000200ff157424ULL, 0x000fc600078e00ffULL, 0x0000000562047c24ULL, 0x000fe2000f8e0203ULL,
0x000000020f057211ULL, 0x042fe200078fd8ffULL, 0x000000100f027824ULL, 0x000fc600078e00ffULL,
0x0000000705037812ULL, 0x040fe400078ec0ffULL, 0x000001f002137812ULL, 0x000fe200078ec0ffULL,
0x0000000104027824ULL, 0x000fe200078e0205ULL, 0x00000002050d7810ULL, 0x000fe40007ffe0ffULL,
0x0000001f03067812ULL, 0x000fe200078e780fULL, 0x00005c0002027625ULL, 0x000fe200078e0015ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0000000305117810ULL, 0x040fe20007ffe0ffULL,
0x00000020050c7824ULL, 0x000fe200078e0206ULL, 0x000000070d0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000104057824ULL, 0x000fe200078e0207ULL, 0x0000000707067812ULL, 0x000fc400078ec0ffULL,
0x00000007110b7812ULL, 0x000fe400078ec0ffULL, 0x0000001f0a107812ULL, 0x100fe400078e780fULL,
0x00000013020a7210ULL, 0x000fe40007f1e0ffULL, 0x0000001f06067812ULL, 0x100fe200078e780fULL,
0x000000200d107824ULL, 0x000fe200078e0210ULL, 0x0000001f0b147812ULL, 0x000fe200078e780fULL,
0x00000001040f7824ULL, 0x040fe200078e020dULL, 0x0000001104127210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fc400000e0603ULL, 0x00005c0005027625ULL, 0x000fc800078e0015ULL,
0x00000020070e7824ULL, 0x000fe200078e0206ULL, 0x0000001302027210ULL, 0x000fe20007f1e0ffULL,
0x00005c000f047625ULL, 0x000fc800078e0015ULL, 0x00005c0012067625ULL, 0x000fe200078e0015ULL,
0x0000001304047210ULL, 0x000fc60007f3e0ffULL, 0x0000002011147824ULL, 0x000fe200078e0214ULL,
0x0000001306067210ULL, 0x000fe20007f5e0ffULL, 0x000000100c0d7824ULL, 0x000fe200078e00ffULL,
0x0000000410117819ULL, 0x000fe200000006ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x00000000020f7faeULL, 0x0003e2000b901c46ULL,
0x0000001014137824ULL, 0x000fc600078e00ffULL, 0x0000000004117faeULL, 0x0003e8000b901c46ULL,
0x0000000006137faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000608687981ULL, 0x014ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000f220000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000005ff697e24ULL, 0x010fe2000f8e00ffULL,
0x0000007f68667810ULL, 0x004fc40007ffe0ffULL, 0x000000ff68647810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff667819ULL, 0x000fe40000011666ULL, 0x00000008ff647819ULL, 0x000fca0000011664ULL,
0x0000d95000008947ULL, 0x000fea0003800000ULL, 0x0000000269617824ULL, 0x000fe200078e00ffULL,
0x0001461067007811ULL, 0x000fe200078e20ffULL, 0x00000003ff057424ULL, 0x00afe400078e00ffULL,
0xffffffffff607424ULL, 0x000fe200078e00ffULL, 0x000000666100720cULL, 0x000fda0003f06070ULL,
0x0000640061038a10ULL, 0x000fe20007ffe0ffULL, 0x0000000262028824ULL, 0x000fc800078e00ffULL,
0x0000640002028a24ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040500ff738cULL, 0x0003e20000000000ULL, 0x0000600002028625ULL, 0x000fe200078e0017ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000169057810ULL, 0x002fe20007ffe0ffULL,
0x0000000602608981ULL, 0x000362000c1e1900ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x000000805f5f7824ULL, 0x000fe200078e00ffULL, 0x000000640500720cULL, 0x000fe20003f06070ULL,
0x0000000000ff7f8cULL, 0x0003d8000c80043fULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x002e620000000000ULL, 0x0000010069037824ULL, 0x000fe400078e00ffULL,
0x00000200ff237424ULL, 0x000fc600078e00ffULL, 0x0000000368007217ULL, 0x000fca0007800000ULL,
0x0000000100007824ULL, 0x000fca00078e0a03ULL, 0x0000002000007817ULL, 0x000fe40003800000ULL,
0x00000003ff047819ULL, 0x002fe4000001160fULL, 0x0ffffff80f057812ULL, 0x000fe400078ec0ffULL,
0x0000000f04027212ULL, 0x0c0fe400078e3cffULL, 0x0000000404087810ULL, 0x000fe40007ffe0ffULL,
0x0000000705067812ULL, 0x000fe200078ef802ULL, 0x0000000867027824ULL, 0x000fe200078e00ffULL,
0x0000000f08077212ULL, 0x040fe200078e3cffULL, 0x00000008080a7824ULL, 0x000fe200078e00ffULL,
0x00000008040b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000460057c24ULL, 0x020fe2000f8e025fULL,
0xfffffff802137812ULL, 0x000fc400078ee20fULL, 0x0000007f04027812ULL, 0x000fe400078ec0ffULL,
0xfffffff80a0a7812ULL, 0x000fe400078ee207ULL, 0x0000000f0b097212ULL, 0x000fe200078e3cffULL,
0x0000000105027824ULL, 0x000fe200078e0202ULL, 0x000000030b0c7819ULL, 0x000fe400000006ffULL,
0x0000c00067077811ULL, 0x000fe200078e68ffULL, 0x00005e0002027625ULL, 0x000fe200078e0023ULL,
0x0000001004107810ULL, 0x000fc40007ffe0ffULL, 0x0000001404147810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x0000000810127824ULL, 0x000fe200078e00ffULL,
0x000000000400720cULL, 0x000fe20003f06070ULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x0000000f10117212ULL, 0x080fe200078e3cffULL, 0x0000001006097824ULL, 0x000fe200078e0207ULL,
0x0000000f14157212ULL, 0x000fe200078e3cffULL, 0x0000001013027825ULL, 0x000fe200078e0002ULL,
0x0000001804067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff812127812ULL, 0x000fe400078ee211ULL,
0xfffffff816167812ULL, 0x000fe200078ee215ULL, 0x0000000806157824ULL, 0x000fe200078e00ffULL,
0x0000000c040d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000c101c46ULL, 0x0000001c04117810ULL, 0x000fe20007ffe0ffULL,
0x00000010121b7824ULL, 0x100fe200078e0207ULL, 0x0000000f06047212ULL, 0x000fe200078e3cffULL,
0x000000080d177824ULL, 0x000fe200078e00ffULL, 0x000000000800720cULL, 0x000fe20003f06070ULL,
0x00000010161d7824ULL, 0x100fe200078e0207ULL, 0xfffffff8151a7812ULL, 0x000fe200078ee204ULL,
0x000000100a157824ULL, 0x000fe200078e0207ULL, 0x0000007f0d047812ULL, 0x000fc400078ec0ffULL,
0x000000000b00720cULL, 0x080fe20003f26070ULL, 0x000000101a1f7824ULL, 0x000fe200078e0207ULL,
0x000000000d00720cULL, 0x080fe40003f46070ULL, 0x000000001000720cULL, 0x080fe40003f66070ULL,
0x000000001400720cULL, 0x080fe40003f86070ULL, 0x000000000600720cULL, 0x080fe40003fa6070ULL,
0x000000001100720cULL, 0x000fc40003fc6070ULL, 0x0000007f08087812ULL, 0x000fe400078ec0ffULL,
0x0000000f11037212ULL, 0x0c2fe400078e3cffULL, 0x00000003111e7819ULL, 0x000fe200000006ffULL,
0x0000000105027824ULL, 0x000fe200078e0208ULL, 0x0000007f0b007812ULL, 0x000fe400078ec0ffULL,
0x0000000f0d0e7212ULL, 0x000fe400078e3cffULL, 0x0000007f06187812ULL, 0x000fe200078ec0ffULL,
0x0000000105067824ULL, 0x040fe200078e0204ULL, 0x0000007f10107812ULL, 0x000fe200078ec0ffULL,
0x0000000105007824ULL, 0x040fe200078e0200ULL, 0x0000007f14147812ULL, 0x000fe200078ec0ffULL,
0x00000001050d7824ULL, 0x000fe200078e0218ULL, 0x0000007f111c7812ULL, 0x000fe200078ec0ffULL,
0x0000000105087824ULL, 0x040fe200078e0210ULL, 0xfffffff81e047812ULL, 0x000fe200078ee203ULL,
0x00000001050b7824ULL, 0x000fe200078e0214ULL, 0xfffffff8170e7812ULL, 0x000fe200078ee20eULL,
0x0000000105107824ULL, 0x000fc400078e021cULL, 0x0000001004217824ULL, 0x000fe200078e0207ULL,
0x000000070e197211ULL, 0x000fe200078e20ffULL, 0x00005e0002027625ULL, 0x000fc800078e0023ULL,
0x000000100c177824ULL, 0x000fe400078e0207ULL, 0x00005e0000047625ULL, 0x000fc800078e0023ULL,
0x00005e0006067625ULL, 0x000fc800078e0023ULL, 0x00005e0008087625ULL, 0x000fc800078e0023ULL,
0x00005e000b0a7625ULL, 0x000fc800078e0023ULL, 0x00005e000d0c7625ULL, 0x000fc800078e0023ULL,
0x00005e0010107625ULL, 0x000fc800078e0023ULL, 0x0000001013027825ULL, 0x000fc800078e0002ULL,
0x0000001013047825ULL, 0x040fe200078e0004ULL, 0x0000000002157faeULL, 0x0003e6000c101c46ULL,
0x0000001013067825ULL, 0x040fe200078e0006ULL, 0x0000000004177faeULL, 0x0003e6000c901c46ULL,
0x0000001013087825ULL, 0x040fe200078e0008ULL, 0x0000000006197faeULL, 0x0003e6000d101c46ULL,
0x00000010130a7825ULL, 0x040fe200078e000aULL, 0x00000000081b7faeULL, 0x0003e6000d901c46ULL,
0x00000010130c7825ULL, 0x040fe200078e000cULL, 0x000000000a1d7faeULL, 0x0003e6000e101c46ULL,
0x0000001013107825ULL, 0x000fe200078e0010ULL, 0x000000000c1f7faeULL, 0x0003e8000e901c46ULL,
0x0000000010217faeULL, 0x0003e2000f101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x002e640000000000ULL, 0x00000003ff007819ULL, 0x002fc4000001160fULL,
0x0ffffff80f037812ULL, 0x000fe400078ec0ffULL, 0x0000000f00027212ULL, 0x040fe400078e3cffULL,
0x0000000400087810ULL, 0x040fe40007ffe0ffULL, 0x0000000703057812ULL, 0x000fe400078ef802ULL,
0x0000000c00027810ULL, 0x000fe20007ffe0ffULL, 0x0000000808097824ULL, 0x000fe200078e00ffULL,
0x00000008000a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000f02037212ULL, 0x0c0fe200078e3cffULL,
0x0000000802127824ULL, 0x000fe200078e00ffULL, 0x00000010000c7810ULL, 0x000fe20007ffe0ffULL,
0x000000080a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000f08047212ULL, 0x080fe400078e3cffULL,
0x0000001800107810ULL, 0x000fe20007ffe0ffULL, 0x000000080c217824ULL, 0x000fe200078e00ffULL,
0x00000014000e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff812137812ULL, 0x000fe200078ee203ULL,
0x00000200ff127424ULL, 0x000fe200078e00ffULL, 0x0000000f0a067212ULL, 0x000fe200078e3cffULL,
0x000000080e257824ULL, 0x000fe200078e00ffULL, 0x0000007f00037812ULL, 0x000fc400078ec0ffULL,
0xfffffff809097812ULL, 0x000fe400078ee204ULL, 0x0000000f10077212ULL, 0x0c0fe400078e3cffULL,
0x0000000310147819ULL, 0x000fe400000006ffULL, 0x0000001c00007810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0c047212ULL, 0x080fe400078e3cffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL,
0x00000008002d7824ULL, 0x000fe200078e00ffULL, 0x0000000f0e067212ULL, 0x000fc400078e3cffULL,
0xfffffff814297812ULL, 0x000fe200078ee207ULL, 0x0000000867147824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee204ULL, 0x0000000460047c24ULL, 0x020fe2000f8e025fULL,
0x0000007f08077812ULL, 0x000fe400078ec0ffULL, 0x0000000f00087212ULL, 0x000fe200078e3cffULL,
0x0000000104037824ULL, 0x000fe200078e0203ULL, 0x0000007f0a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104077824ULL, 0x000fe200078e0207ULL, 0xfffffff825257812ULL, 0x000fc400078ee206ULL,
0x0000007f02117812ULL, 0x000fe200078ec0ffULL, 0x00000001040b7824ULL, 0x000fe200078e020bULL,
0x0000007f0c177812ULL, 0x000fe200078ec0ffULL, 0x00005e0003027625ULL, 0x000fe200078e0012ULL,
0x0000c00067067811ULL, 0x000fe400078e68ffULL, 0x0000007f0e197812ULL, 0x000fe200078ec0ffULL,
0x0000000104117824ULL, 0x000fe200078e0211ULL, 0x0000007f001d7812ULL, 0x000fe200078ec0ffULL,
0x00000001041f7824ULL, 0x000fe200078e0217ULL, 0x0000007f101b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104237824ULL, 0x040fe200078e0219ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL,
0x00000001042b7824ULL, 0x040fe200078e021dULL, 0x0000001b04277210ULL, 0x000fe20007ffe0ffULL,
0x0000001005177824ULL, 0x100fe200078e0206ULL, 0xfffffff814157812ULL, 0x000fe200078ee20fULL,
0x0000001009197824ULL, 0x000fc400078e0206ULL, 0x000000100d1b7824ULL, 0x100fe400078e0206ULL,
0x00000010131d7824ULL, 0x100fe400078e0206ULL, 0x0000001021217824ULL, 0x100fe400078e0206ULL,
0x0000001025257824ULL, 0x100fe400078e0206ULL, 0x0000001029297824ULL, 0x100fe400078e0206ULL,
0x000000102d2d7824ULL, 0x000fc400078e0206ULL, 0x00005e0007047625ULL, 0x000fc800078e0012ULL,
0x00005e000b067625ULL, 0x000fc800078e0012ULL, 0x00005e0011087625ULL, 0x000fc800078e0012ULL,
0x00005e001f0a7625ULL, 0x000fc800078e0012ULL, 0x00005e00230c7625ULL, 0x000fc800078e0012ULL,
0x0000001015027825ULL, 0x000fc800078e0002ULL, 0x00005e0027107625ULL, 0x080fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002177faeULL, 0x0003e6000b901c46ULL,
0x00005e002b127625ULL, 0x000fc800078e0012ULL, 0x0000001015047825ULL, 0x000fc800078e0004ULL,
0x0000001015067825ULL, 0x040fe200078e0006ULL, 0x0000000004197faeULL, 0x0003e6000b901c46ULL,
0x0000001015087825ULL, 0x040fe200078e0008ULL, 0x00000000061b7faeULL, 0x0003e6000b901c46ULL,
0x00000010150a7825ULL, 0x040fe200078e000aULL, 0x00000000081d7faeULL, 0x0003e6000b901c46ULL,
0x00000010150c7825ULL, 0x040fe200078e000cULL, 0x000000000a217faeULL, 0x0003e6000b901c46ULL,
0x0000001015107825ULL, 0x040fe200078e0010ULL, 0x000000000c257faeULL, 0x0003e6000b901c46ULL,
0x0000001015127825ULL, 0x000fe200078e0012ULL, 0x0000000010297faeULL, 0x0003e8000b901c46ULL,
0x00000000122d7faeULL, 0x0003e4000b901c46ULL, 0x000000646900720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217005e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5c7224ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x002fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00008eb000000947ULL, 0x000fea0003800000ULL,
0x0000000262627824ULL, 0x000fe200078e00ffULL, 0x00007610ff577816ULL, 0x000fe20000000057ULL,
0x00006400ff5d7624ULL, 0x000fc400078e00ffULL, 0xff317217ff5e7424ULL, 0x000fe400078e00ffULL,
0x00006400625d7624ULL, 0x000fe400078e025dULL, 0x000000ffff177224ULL, 0x000fe400078e00ffULL,
0x0000010069037824ULL, 0x000fca00078e00ffULL, 0x000000680300720cULL, 0x000fda0003f06070ULL,
0x00008dc000000947ULL, 0x000fea0003800000ULL, 0x0000000169037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000640300720cULL, 0x000fe20003f06070ULL,
0x000000ffff567224ULL, 0x000fd800078e0061ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fe4000001160fULL, 0x0000002069037811ULL, 0x000fe400078e40ffULL,
0x0000000405067810ULL, 0x040fe40007ffe0ffULL, 0x0000000368007217ULL, 0x000fe40007800000ULL,
0x0000000c05187810ULL, 0x040fe20007ffe0ffULL, 0x00000008060b7824ULL, 0x040fe200078e00ffULL,
0x0000000f06027212ULL, 0x000fe200078e3cffULL, 0x0000000100007824ULL, 0x000fe200078e0a03ULL,
0x0000000805127810ULL, 0x000fe20007ffe0ffULL, 0x0000000818087824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0b7812ULL, 0x000fc400078ee202ULL, 0x00000010051a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000f18037212ULL, 0x080fe400078e3cffULL, 0x00000018051e7810ULL, 0x000fe20007ffe0ffULL,
0x000000081a1b7824ULL, 0x000fe200078e00ffULL, 0x0000000f12027212ULL, 0x040fe400078e3cffULL,
0x0000000312137819ULL, 0x000fe400000006ffULL, 0xfffffff808197812ULL, 0x000fe200078ee203ULL,
0x000000081e087824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee202ULL,
0x0000000460027c24ULL, 0x000fe2000f8e025fULL, 0x00000014051c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000f1a047212ULL, 0x080fe400078e3cffULL, 0x0000000f1e077212ULL, 0x080fe200078e3cffULL,
0x000000081c1f7824ULL, 0x000fe200078e00ffULL, 0x0000001c05207810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81b1b7812ULL, 0x000fe400078ee204ULL, 0xfffffff808257812ULL, 0x000fe200078ee207ULL,
0x0000000820277824ULL, 0x000fe200078e00ffULL, 0x0000000f1c047212ULL, 0x000fc400078e3cffULL,
0x0000002002027810ULL, 0x000fe40007ffe0ffULL, 0x0000007f06077812ULL, 0x000fe400078ec0ffULL,
0x0000007f180d7812ULL, 0x000fe400078ec0ffULL, 0x0000007f05037812ULL, 0x000fe400078ec0ffULL,
0x0000007f12097812ULL, 0x000fe200078ec0ffULL, 0x000000010d087824ULL, 0x100fe200078e0202ULL,
0x0000007f1c1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0202ULL,
0x0000007f1e217812ULL, 0x000fc400078ec0ffULL, 0x0000007f20237812ULL, 0x000fe200078ec0ffULL,
0x000000011d0c7824ULL, 0x100fe200078e0202ULL, 0x0000007f1a117812ULL, 0x000fe200078ec0ffULL,
0x00000001210d7824ULL, 0x000fe200078e0202ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL,
0x0000000107047824ULL, 0x100fe200078e0202ULL, 0x0000000f20107212ULL, 0x000fe200078e3cffULL,
0x0000000109077824ULL, 0x100fe200078e0202ULL, 0x00000002110a7210ULL, 0x000fe20007ffe0ffULL,
0x00000001230e7824ULL, 0x000fe200078e0202ULL, 0x0000002000007817ULL, 0x000fe20003800000ULL,
0x00000200ff237424ULL, 0x000fe200078e00ffULL, 0x000000070f027812ULL, 0x000fc400078ec0ffULL,
0xfffffff827217812ULL, 0x000fe400078ee210ULL, 0x0000000705107812ULL, 0x100fe200078e480fULL,
0x0000000867117824ULL, 0x000fe200078e0202ULL, 0x000000000500720cULL, 0x080fe20003fc6070ULL,
0x00005e0003027625ULL, 0x080fe200078e0023ULL, 0x000000000600720cULL, 0x000fe40003f26070ULL,
0x0000d00067067811ULL, 0x000fe200078e68ffULL, 0x00005e0004047625ULL, 0x000fe200078e0023ULL,
0x0ffffff810097812ULL, 0x000fc400078ef80fULL, 0x000000001200720cULL, 0x080fe20003f46070ULL,
0x0000001011027825ULL, 0x000fe200078e0002ULL, 0x000000001800720cULL, 0x000fe40003f66070ULL,
0x000000061b1b7211ULL, 0x000fe200078e20ffULL, 0x0000001009097824ULL, 0x100fe200078e0206ULL,
0x000000001a00720cULL, 0x080fe20003f86070ULL, 0x000000100b0b7824ULL, 0x000fe200078e0206ULL,
0x000000001c00720cULL, 0x080fe20003fa6070ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e2000f101c46ULL,
0x000000001e00720cULL, 0x000fc40003fc6070ULL, 0x000000101f1d7824ULL, 0x100fe200078e0206ULL,
0x00000000040b7faeULL, 0x0005e2000c901c46ULL, 0x0000001013137824ULL, 0x100fe200078e0206ULL,
0x000000002000720cULL, 0x000fe20003f26070ULL, 0x0000001019197824ULL, 0x100fe400078e0206ULL,
0x00000010251f7824ULL, 0x100fe400078e0206ULL, 0x0000001021217824ULL, 0x000fe400078e0206ULL,
0x00005e0007067625ULL, 0x000fc800078e0023ULL, 0x00005e0008027625ULL, 0x002fc800078e0023ULL,
0x00005e000a087625ULL, 0x000fc800078e0023ULL, 0x00005e000c047625ULL, 0x004fc800078e0023ULL,
0x00005e000d0a7625ULL, 0x000fc800078e0023ULL, 0x00005e000e0c7625ULL, 0x000fc800078e0023ULL,
0x0000001011067825ULL, 0x000fc800078e0006ULL, 0x0000001011027825ULL, 0x040fe200078e0002ULL,
0x0000000006137faeULL, 0x0003e6000d101c46ULL, 0x0000001011087825ULL, 0x040fe200078e0008ULL,
0x0000000002197faeULL, 0x0003e6000d901c46ULL, 0x0000001011047825ULL, 0x040fe200078e0004ULL,
0x00000000081b7faeULL, 0x0003e6000e101c46ULL, 0x00000010110a7825ULL, 0x040fe200078e000aULL,
0x00000000041d7faeULL, 0x0003e6000e901c46ULL, 0x00000010110c7825ULL, 0x000fe200078e000cULL,
0x000000000a1f7faeULL, 0x0003e8000f101c46ULL, 0x000000000c217faeULL, 0x0003e2000c901c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe4000001160fULL,
0x0000020000127802ULL, 0x000fc40000000f00ULL, 0x00000008000c7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c00107810ULL, 0x040fe40007ffe0ffULL, 0x00000014001e7810ULL, 0x000fe20007ffe0ffULL,
0x000000080c0e7824ULL, 0x040fe200078e00ffULL, 0x0000000f0c037212ULL, 0x080fe200078e3cffULL,
0x0000000810077824ULL, 0x040fe200078e00ffULL, 0x0000000f10047212ULL, 0x000fe200078e3cffULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fc400078ee203ULL,
0x0000001800227810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1e037212ULL, 0x080fe400078e3cffULL,
0xfffffff807187812ULL, 0x000fe200078ee204ULL, 0x0000000822077824ULL, 0x000fe200078e00ffULL,
0x0000000400087810ULL, 0x000fe40007ffe0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee203ULL,
0x0000000460037c24ULL, 0x000fe2000f8e025fULL, 0x0000000f22047212ULL, 0x080fe200078e3cffULL,
0x0000000808057824ULL, 0x040fe200078e00ffULL, 0x0000000f08027212ULL, 0x000fc400078e3cffULL,
0xfffffff807247812ULL, 0x000fe400078ee204ULL, 0x00000010001a7810ULL, 0x040fe40007ffe0ffULL,
0x0000002003047810ULL, 0x000fe40007ffe0ffULL, 0x0000007f00037812ULL, 0x040fe400078ec0ffULL,
0x0000000700067812ULL, 0x040fe400078e480fULL, 0x0000001c00007810ULL, 0x000fe20007ffe0ffULL,
0x0000000103037824ULL, 0x000fe200078e0204ULL, 0xfffffff8050a7812ULL, 0x000fe200078ee202ULL,
0x000000081a057824ULL, 0x040fe200078e00ffULL, 0x0000000f1a027212ULL, 0x000fe200078e3cffULL,
0x00000008001d7824ULL, 0x000fe200078e00ffULL, 0x0000007f08077812ULL, 0x000fc400078ec0ffULL,
0x0000000f00087212ULL, 0x000fe400078e3cffULL, 0xfffffff8051c7812ULL, 0x000fe200078ee202ULL,
0x0000000107077824ULL, 0x100fe200078e0204ULL, 0x0000007f0c097812ULL, 0x000fe400078ec0ffULL,
0x000000070f027812ULL, 0x000fe400078ec0ffULL, 0x0000007f100b7812ULL, 0x000fe200078ec0ffULL,
0x0000000109097824ULL, 0x000fe200078e0204ULL, 0x0000d00067057811ULL, 0x040fe200078e68ffULL,
0x0000000867197824ULL, 0x000fe200078e0202ULL, 0x0ffffff806067812ULL, 0x000fe200078ef80fULL,
0x000000010b0b7824ULL, 0x000fe200078e0204ULL, 0x0000007f1a0d7812ULL, 0x000fe200078ec0ffULL,
0x00005e0003027625ULL, 0x000fe200078e0012ULL, 0x0000007f1e117812ULL, 0x000fc400078ec0ffULL,
0x0000007f22137812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x100fe200078e0204ULL,
0x0000007f001b7812ULL, 0x000fe200078ec0ffULL, 0x0000000111117824ULL, 0x000fe200078e0204ULL,
0xfffffff81d087812ULL, 0x000fe200078ee208ULL, 0x0000000113137824ULL, 0x000fe200078e0204ULL,
0x000000041b297210ULL, 0x000fe20007ffe0ffULL, 0x00000010061b7824ULL, 0x100fe400078e0205ULL,
0x000000100a1d7824ULL, 0x100fe400078e0205ULL, 0x000000100e1f7824ULL, 0x000fc400078e0205ULL,
0x0000001018217824ULL, 0x100fe400078e0205ULL, 0x000000101c237824ULL, 0x100fe400078e0205ULL,
0x0000001020257824ULL, 0x100fe400078e0205ULL, 0x0000001024277824ULL, 0x100fe400078e0205ULL,
0x00000010082b7824ULL, 0x000fe400078e0205ULL, 0x00005e0007047625ULL, 0x000fc800078e0012ULL,
0x00005e0009067625ULL, 0x000fc800078e0012ULL, 0x00005e000b087625ULL, 0x000fc800078e0012ULL,
0x00005e000d0a7625ULL, 0x000fc800078e0012ULL, 0x00005e00110c7625ULL, 0x000fc800078e0012ULL,
0x0000001019027825ULL, 0x000fc800078e0002ULL, 0x00005e0013107625ULL, 0x080fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000021b7faeULL, 0x0003e6000b901c46ULL,
0x00005e0029127625ULL, 0x000fc800078e0012ULL, 0x0000001019047825ULL, 0x000fc800078e0004ULL,
0x0000001019067825ULL, 0x040fe200078e0006ULL, 0x00000000041d7faeULL, 0x0003e6000b901c46ULL,
0x0000001019087825ULL, 0x040fe200078e0008ULL, 0x00000000061f7faeULL, 0x0003e6000b901c46ULL,
0x00000010190a7825ULL, 0x040fe200078e000aULL, 0x0000000008217faeULL, 0x0003e6000b901c46ULL,
0x00000010190c7825ULL, 0x040fe200078e000cULL, 0x000000000a237faeULL, 0x0003e6000b901c46ULL,
0x0000001019107825ULL, 0x040fe200078e0010ULL, 0x000000000c257faeULL, 0x0003e6000b901c46ULL,
0x0000001019127825ULL, 0x000fe200078e0012ULL, 0x0000000010277faeULL, 0x0003e8000b901c46ULL,
0x00000000122b7faeULL, 0x0003e4000b901c46ULL, 0x01460c00ff037984ULL, 0x002e620000000800ULL,
0x0000ffff57007812ULL, 0x000fc600078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00008880000d7816ULL, 0x000fca00000000ffULL, 0x800000000d007824ULL, 0x000fca00078e00ffULL,
0x8000000003ff7812ULL, 0x002fe20007824800ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e00000000007802ULL, 0x000fe20000000f00ULL,
0x800000000d037824ULL, 0x000fc600078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01460c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe40007824803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000100f557824ULL, 0x000fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc8000001160fULL,
0x0000007055557812ULL, 0x000fe400078ec0ffULL, 0x0000000c00007812ULL, 0x000fca00078ec0ffULL,
0x0000000155557824ULL, 0x000fca00078e0200ULL, 0x0140000055037984ULL, 0x000e680000000800ULL,
0x0142000055717984ULL, 0x0004e20000000800ULL, 0x0000005e0300720bULL, 0x002fda0003f3d000ULL,
0x0000000000007806ULL, 0x000fc800008e0100ULL, 0x0000ffff00067812ULL, 0x000fe2000782c0ffULL,
0x00000001ff007424ULL, 0x000fd800078e00ffULL, 0x0000035000009947ULL, 0x000fea0003800000ULL,
0x0000005e0300720bULL, 0x00cfe40003f34000ULL, 0x000000035e087209ULL, 0x000fe40007810000ULL,
0x00000002ff047819ULL, 0x000fc6000001160fULL, 0x800000085e007221ULL, 0x100fe20000010000ULL,
0x0000000804057810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5e7224ULL, 0x000fe400078e0008ULL,
0x3fb8aa3b00027820ULL, 0x000fe40000410000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x0000000200097308ULL, 0x000e620000000800ULL, 0x000000ff6700720cULL, 0x000fe40003f25270ULL,
0x0000ffff00077812ULL, 0x000fc800078e3cffULL, 0x0000000706ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff007807ULL, 0x000fc60001000000ULL, 0x0144000855009388ULL, 0x000fe20000000800ULL,
0x000000095c5c7220ULL, 0x002fc60000410000ULL, 0x00001f0509057589ULL, 0x000e6400000e0000ULL,
0x8000000803032221ULL, 0x000fe40000010000ULL, 0x00001f0409047589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b03032820ULL, 0x000fc80000410000ULL, 0x0000000300542308ULL, 0x000ee20000000800ULL,
0x0000000517177220ULL, 0x082fe20000410000ULL, 0x0000000516167220ULL, 0x080fe20000410000ULL,
0x0000000533337220ULL, 0x080fe20000410000ULL, 0x0000000532327220ULL, 0x080fe20000410000ULL,
0x0000000547477220ULL, 0x080fe20000410000ULL, 0x0000000546467220ULL, 0x080fe20000410000ULL,
0x000000054b4b7220ULL, 0x080fe20000410000ULL, 0x000000054a4a7220ULL, 0x080fe20000410000ULL,
0x0000000543437220ULL, 0x080fe20000410000ULL, 0x0000000542427220ULL, 0x080fe20000410000ULL,
0x000000053f3f7220ULL, 0x080fe20000410000ULL, 0x000000053e3e7220ULL, 0x080fe20000410000ULL,
0x000000053b3b7220ULL, 0x080fe20000410000ULL, 0x000000053a3a7220ULL, 0x080fe20000410000ULL,
0x0000000537377220ULL, 0x080fe20000410000ULL, 0x0000000536367220ULL, 0x000fe20000410000ULL,
0x0000000415157220ULL, 0x084fe20000410000ULL, 0x0000000414147220ULL, 0x080fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000430307220ULL, 0x080fe20000410000ULL,
0x0000000445457220ULL, 0x080fe20000410000ULL, 0x0000000444447220ULL, 0x080fe20000410000ULL,
0x0000000449497220ULL, 0x080fe20000410000ULL, 0x0000000448487220ULL, 0x080fe20000410000ULL,
0x0000000441417220ULL, 0x080fe20000410000ULL, 0x0000000440407220ULL, 0x080fe20000410000ULL,
0x000000043d3d7220ULL, 0x080fe20000410000ULL, 0x000000043c3c7220ULL, 0x080fe20000410000ULL,
0x0000000439397220ULL, 0x080fe20000410000ULL, 0x0000000438387220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x000fe20000410000ULL,
0x0000005471712220ULL, 0x008fe20000410000ULL, 0x00000054ff02723eULL, 0x00cfe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000070f0c7812ULL, 0x000fe200078ec0ffULL,
0x0000005c715c7221ULL, 0x000fe20000010000ULL, 0x00005410021d7816ULL, 0x000fe40000000002ULL,
0x00000004ff027819ULL, 0x100fe4000001160fULL, 0x000000080c6b7812ULL, 0x000fe400078ef80fULL,
0x000000080f037812ULL, 0x000fe400078ec0ffULL, 0x00000007020e7812ULL, 0x000fc400078e786bULL,
0x0000000c03047212ULL, 0x040fe400078efcffULL, 0x0000000703037812ULL, 0x000fe200078ec80cULL,
0x000000086b0e7824ULL, 0x000fe200078e020eULL, 0x0000000402087810ULL, 0x040fe40007ffe0ffULL,
0x0000000602107810ULL, 0x040fe40007ffe0ffULL, 0x0000000202067810ULL, 0x000fe40007ffe0ffULL,
0x0000000203197212ULL, 0x000fc400078e3cffULL, 0x0000000803637212ULL, 0x040fe400078e3cffULL,
0x00000010031b7212ULL, 0x040fe200078e3cffULL, 0x00000008046f7824ULL, 0x040fe200078e0219ULL,
0x0000000603037212ULL, 0x000fe200078e3cffULL, 0x00000008046d7824ULL, 0x000fe200078e0263ULL,
0x0000a0000e287811ULL, 0x000fe400078e20ffULL, 0x0000c000670b7811ULL, 0x000fe200078e68ffULL,
0x00000008046e7824ULL, 0x040fe200078e0203ULL, 0x0000001b046c7211ULL, 0x000fc400078e18ffULL,
0x000000002828783bULL, 0x000fe20000000200ULL, 0x000000106f097824ULL, 0x000fe200078e020bULL,
0x0000000706027812ULL, 0x000fe200078e786bULL, 0x000000106d077824ULL, 0x000fe200078e020bULL,
0x00000002ff187819ULL, 0x000fe2000001160fULL, 0x000000106e087824ULL, 0x100fe200078e020bULL,
0x000000000958783bULL, 0x000fe20000004200ULL, 0x000000106c067824ULL, 0x000fe200078e020bULL,
0x00000008180a7810ULL, 0x000fe20007ffe0ffULL, 0x000000086b057824ULL, 0x000fe200078e0202ULL,
0x00000000074c783bULL, 0x000fe20000004200ULL, 0x0000008004047811ULL, 0x000fc400078e18ffULL,
0x0000991000007816ULL, 0x000fe200000000ffULL, 0x000000000850783bULL, 0x000fe20000004200ULL,
0x0000a00005107811ULL, 0x000fe200078e20ffULL, 0x00000001196a7824ULL, 0x100fe200078e0204ULL,
0x000000ff0000720cULL, 0x000fe20003f25270ULL, 0x00000000062c783bULL, 0x000fe20000004200ULL,
0x0000000163637824ULL, 0x100fe200078e0204ULL, 0x0000004069717811ULL, 0x000fe200078e40ffULL,
0x0000000103657824ULL, 0x100fe200078e0204ULL, 0x00001f181d737589ULL, 0x000e6200000e0000ULL,
0x000000011b627824ULL, 0x000fe200078e0204ULL, 0x0000000b6a047211ULL, 0x000fe200078e20ffULL,
0x0000001063027824ULL, 0x100fe200078e020bULL, 0x00001f0a1d707589ULL, 0x000ea200000e0000ULL,
0x0000001065037824ULL, 0x000fc400078e020bULL, 0x0000001062007824ULL, 0x000fe200078e020bULL,
0x000000001010783bULL, 0x000ee80000000200ULL, 0x000000000424783bULL, 0x000f280000004200ULL,
0x00000000021c783bULL, 0x000f680000004200ULL, 0x000000000320783bULL, 0x000f280000004200ULL,
0x000000000018783bULL, 0x000f220000004200ULL, 0x0000007328289231ULL, 0x002fc400003400ffULL,
0x000000732a2a9231ULL, 0x000fe400003400ffULL, 0x0000007029299231ULL, 0x084fe400003400ffULL,
0x000000702b2b9231ULL, 0x000fce00003400ffULL, 0x000000582834723cULL, 0x040ff00000041834ULL,
0x0000005a2838723cULL, 0x000fe20000041838ULL, 0x0000007310109231ULL, 0x088fe400003400ffULL,
0x0000007312129231ULL, 0x000fc400003400ffULL, 0x0000007011119231ULL, 0x000fc600003400ffULL,
0x0000004c2848723cULL, 0x000fe20000041848ULL, 0x0000007013139231ULL, 0x000fce00003400ffULL,
0x00000050283c723cULL, 0x040ff0000004183cULL, 0x000000522840723cULL, 0x040ff00000041840ULL,
0x0000004e2844723cULL, 0x040ff00000041844ULL, 0x0000002c2830723cULL, 0x040ff00000041830ULL,
0x0000002e2814723cULL, 0x000ff00000041814ULL, 0x000000241034723cULL, 0x050ff00000041834ULL,
0x000000261038723cULL, 0x040ff00000041838ULL, 0x0000001c1048723cULL, 0x060ff00000041848ULL,
0x00000020103c723cULL, 0x040ff0000004183cULL, 0x000000221040723cULL, 0x040ff00000041840ULL,
0x0000001e101c723cULL, 0x040ff00000041844ULL, 0x000000181030723cULL, 0x040ff00000041830ULL,
0x0000001a1024723cULL, 0x000fe20000041814ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000062000008947ULL, 0x000fea0003800000ULL, 0x00000003ff187819ULL, 0x000fe2000001160fULL,
0x00000008671b7824ULL, 0x000fe200078e020cULL, 0x0000020000197802ULL, 0x000fe40000000f00ULL,
0x0000000418117810ULL, 0x040fe40007ffe0ffULL, 0x0000000818137810ULL, 0x040fe40007ffe0ffULL,
0x0000000f11107212ULL, 0x040fe200078e3cffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x0000000c182a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000f13127212ULL, 0x080fe400078e3cffULL,
0xfffffff815207812ULL, 0x000fe200078ee210ULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0x00000010182b7810ULL, 0x000fe20007ffe0ffULL, 0x000000082a177824ULL, 0x040fe200078e00ffULL,
0x0000000f2a107212ULL, 0x000fe200078e3cffULL, 0x0000001020237824ULL, 0x000fe200078e020bULL,
0xfffffff815287812ULL, 0x000fe200078ee212ULL, 0x000000082b157824ULL, 0x000fe200078e00ffULL,
0xfffffff8172c7812ULL, 0x000fe200078ee210ULL, 0x0000000460177c24ULL, 0x000fe2000f8e025fULL,
0x0000007168107217ULL, 0x000fe20007800000ULL, 0x0000001028297824ULL, 0x000fe200078e020bULL,
0x0000000f2b127212ULL, 0x000fc400078e3cffULL, 0x0000004017177810ULL, 0x000fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a71ULL, 0xfffffff8152e7812ULL, 0x000fe400078ee212ULL,
0x0000007f18127812ULL, 0x000fe400078ec0ffULL, 0x0000002010167817ULL, 0x000fe40003800000ULL,
0x0000000718147812ULL, 0x000fe200078e480fULL, 0x0000000112107824ULL, 0x000fe200078e0217ULL,
0x0000007f11127812ULL, 0x000fc400078ec0ffULL, 0x0000007f13227812ULL, 0x000fe400078ec0ffULL,
0x0ffffff8141a7812ULL, 0x000fe200078ef80fULL, 0x0000000112127824ULL, 0x100fe200078e0217ULL,
0x000000161800720cULL, 0x080fe20003f46070ULL, 0x0000000122147824ULL, 0x000fe200078e0217ULL,
0x00000014182d7810ULL, 0x000fe20007ffe0ffULL, 0x000000101a217824ULL, 0x000fe200078e020bULL,
0x000000161100720cULL, 0x080fe20003f66070ULL, 0x00005e0010107625ULL, 0x000fe200078e0019ULL,
0x000000161300720cULL, 0x000fc40003f86070ULL, 0x0000000f2d227212ULL, 0x040fe200078e3cffULL,
0x00005e0012127625ULL, 0x080fe200078e0019ULL, 0x00000018181a7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c18287810ULL, 0x000fe20007ffe0ffULL, 0x00005e0014147625ULL, 0x000fe200078e0019ULL,
0x0000000f1a187212ULL, 0x040fe400078e3cffULL, 0x000000161a00720cULL, 0x080fe20003fa6070ULL,
0x000000082d2f7824ULL, 0x000fe200078e00ffULL, 0x000000162800720cULL, 0x000fe20003fc6070ULL,
0x000000101b107825ULL, 0x000fc600078e0010ULL, 0xfffffff82f227812ULL, 0x000fe200078ee222ULL,
0x000000101b127825ULL, 0x040fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010217faeULL, 0x0003e2000d101c46ULL, 0x000000162a00720cULL, 0x080fe40003f46070ULL,
0x000000101b147825ULL, 0x000fe200078e0014ULL, 0x0000000012237faeULL, 0x0005e2000d901c46ULL,
0x000000162b00720cULL, 0x080fe40003f66070ULL, 0x000000081a2f7824ULL, 0x000fe200078e00ffULL,
0x0000000014297faeULL, 0x0007e2000e101c46ULL, 0x000000162d00720cULL, 0x000fc40003f86070ULL,
0x0000007f1a167812ULL, 0x000fe200078ec0ffULL, 0x0000000828217824ULL, 0x002fe200078e00ffULL,
0xfffffff82f207812ULL, 0x000fe400078ee218ULL, 0x0000007f2a107812ULL, 0x000fe200078ec0ffULL,
0x0000000116167824ULL, 0x000fe200078e0217ULL, 0x0000007f2b127812ULL, 0x004fe200078ec0ffULL,
0x0000001022237824ULL, 0x000fe200078e020bULL, 0x0000007f28187812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0217ULL, 0x0000007f2d147812ULL, 0x008fe200078ec0ffULL,
0x0000001020297824ULL, 0x000fe200078e020bULL, 0x0000001712127210ULL, 0x000fe20007ffe0ffULL,
0x0000000118187824ULL, 0x100fe200078e0217ULL, 0x0000000f281a7212ULL, 0x000fe200078e3cffULL,
0x0000000114147824ULL, 0x000fc400078e0217ULL, 0x00005e0010107625ULL, 0x000fe200078e0019ULL,
0xfffffff8211a7812ULL, 0x000fc600078ee21aULL, 0x00005e0012127625ULL, 0x000fc800078e0019ULL,
0x00005e0014147625ULL, 0x000fc800078e0019ULL, 0x00005e0016167625ULL, 0x000fc800078e0019ULL,
0x00005e0018187625ULL, 0x000fc800078e0019ULL, 0x000000101b107825ULL, 0x000fc800078e0010ULL,
0x000000101b127825ULL, 0x000fc800078e0012ULL, 0x000000101b147825ULL, 0x000fc800078e0014ULL,
0x000000101b167825ULL, 0x000fc800078e0016ULL, 0x000000101b187825ULL, 0x000fc800078e0018ULL,
0x000000102c1b7824ULL, 0x100fe400078e020bULL, 0x000000102e217824ULL, 0x100fe400078e020bULL,
0x000000101a2b7824ULL, 0x000fe200078e020bULL, 0x00000000101b7faeULL, 0x0003e8000d101c46ULL,
0x0000000012217faeULL, 0x0003e8000d901c46ULL, 0x0000000014237faeULL, 0x0003e8000e101c46ULL,
0x0000000016297faeULL, 0x0003e8000e901c46ULL, 0x00000000182b7faeULL, 0x0003e2000f101c46ULL,
0x0000056000007947ULL, 0x000fea0003800000ULL, 0x00000003ff107819ULL, 0x000fe2000001160fULL,
0x00000200ff227424ULL, 0x000fc400078e00ffULL, 0x0000000867297824ULL, 0x000fe200078e020cULL,
0x00000008101a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000410167810ULL, 0x040fe40007ffe0ffULL,
0x0000000c10287810ULL, 0x000fe20007ffe0ffULL, 0x000000081a157824ULL, 0x040fe200078e00ffULL,
0x0000000f1a127212ULL, 0x080fe400078e3cffULL, 0x00000010102c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x0000000f16117212ULL, 0x000fc400078e3cffULL,
0x0000000316187819ULL, 0x000fe400000006ffULL, 0x00000018104c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff815207812ULL, 0x000fe200078ee212ULL, 0x000000082c157824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee211ULL, 0x0000000460117c24ULL, 0x000fe2000f8e025fULL,
0x0000001410447810ULL, 0x000fe20007ffe0ffULL, 0x000000084c177824ULL, 0x000fe200078e00ffULL,
0x0000000f28137212ULL, 0x080fe200078e3cffULL, 0x00000010202f7824ULL, 0x000fe200078e020bULL,
0x0000000f2c127212ULL, 0x080fe200078e3cffULL, 0x0000000844467824ULL, 0x000fe200078e00ffULL,
0x0000000f4c147212ULL, 0x000fc400078e3cffULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee213ULL,
0xfffffff8152e7812ULL, 0x000fe400078ee212ULL, 0x0000000f44137212ULL, 0x000fe400078e3cffULL,
0x0000004011127810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8174e7812ULL, 0x000fe400078ee214ULL,
0x0000007f10117812ULL, 0x000fc400078ec0ffULL, 0x0000000710147812ULL, 0x000fe200078e480fULL,
0x000000104e457824ULL, 0x000fe200078e020bULL, 0x0000001c10107810ULL, 0x000fe20007ffe0ffULL,
0x0000000111117824ULL, 0x100fe200078e0212ULL, 0xfffffff846467812ULL, 0x000fe400078ee213ULL,
0x0000007f16137812ULL, 0x000fe200078ec0ffULL, 0x00000008102d7824ULL, 0x000fe200078e00ffULL,
0x0000007f1a157812ULL, 0x000fe400078ec0ffULL, 0x0000007f28177812ULL, 0x000fe200078ec0ffULL,
0x0000000113137824ULL, 0x100fe200078e0212ULL, 0x0000007f2c197812ULL, 0x000fe200078ec0ffULL,
0x0000000115157824ULL, 0x100fe200078e0212ULL, 0x0000007f441b7812ULL, 0x000fe200078ec0ffULL,
0x0000000117177824ULL, 0x100fe200078e0212ULL, 0x0000007f4c217812ULL, 0x000fe200078ec0ffULL,
0x0000000119197824ULL, 0x100fe200078e0212ULL, 0x0000007f10237812ULL, 0x040fe200078ec0ffULL,
0x000000011b1b7824ULL, 0x000fe200078e0212ULL, 0x0000000f10167212ULL, 0x000fe200078e3cffULL,
0x00005e0011107625ULL, 0x000fe200078e0022ULL, 0x0ffffff814147812ULL, 0x000fc400078ef80fULL,
0xfffffff82d287812ULL, 0x000fe200078ee216ULL, 0x0000000121217824ULL, 0x100fe200078e0212ULL,
0x0000000b142b7211ULL, 0x000fe200078e20ffULL, 0x0000000123237824ULL, 0x000fe400078e0212ULL,
0x00000010182d7824ULL, 0x000fe400078e020bULL, 0x00005e0013127625ULL, 0x000fc800078e0022ULL,
0x00005e0015147625ULL, 0x000fc800078e0022ULL, 0x00005e0017167625ULL, 0x000fc800078e0022ULL,
0x00005e0019187625ULL, 0x000fc800078e0022ULL, 0x00005e001b1a7625ULL, 0x000fc800078e0022ULL,
0x00005e0021207625ULL, 0x000fc800078e0022ULL, 0x0000001029107825ULL, 0x000fc800078e0010ULL,
0x00005e0023227625ULL, 0x000fe200078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102b7faeULL, 0x0003e6000b901c46ULL, 0x0000001029127825ULL, 0x000fc800078e0012ULL,
0x0000001029147825ULL, 0x040fe200078e0014ULL, 0x00000000122d7faeULL, 0x0005e6000b901c46ULL,
0x0000001029167825ULL, 0x040fe200078e0016ULL, 0x0000000b2a117211ULL, 0x002fe200078e20ffULL,
0x00000000142f7faeULL, 0x0005e4000b901c46ULL, 0x0000001029187825ULL, 0x040fe400078e0018ULL,
0x0000000016117faeULL, 0x0005e4000b901c46ULL, 0x00000010291a7825ULL, 0x000fc800078e001aULL,
0x0000001029207825ULL, 0x000fc800078e0020ULL, 0x0000001029227825ULL, 0x000fc800078e0022ULL,
0x000000102e297824ULL, 0x100fe400078e020bULL, 0x00000010462b7824ULL, 0x100fe400078e020bULL,
0x0000001028477824ULL, 0x000fe200078e020bULL, 0x0000000018297faeULL, 0x0005e8000b901c46ULL,
0x000000001a2b7faeULL, 0x0005e8000b901c46ULL, 0x0000000020457faeULL, 0x0005e8000b901c46ULL,
0x0000000022477faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000040f107811ULL, 0x002fc400078fe0ffULL, 0x000010000b727810ULL, 0x000fe40007ffe0ffULL,
0x0000000710107812ULL, 0x000fe400078e786bULL, 0x000000726c6c7211ULL, 0x000fe200078e20ffULL,
0x000000106d6d7824ULL, 0x000fe200078e0272ULL, 0x00000002ff737819ULL, 0x000fe2000001160fULL,
0x000000086b707824ULL, 0x000fe200078e0210ULL, 0x000000060f107811ULL, 0x000fe200078fe0ffULL,
0x000000106f6f7824ULL, 0x100fe400078e0272ULL, 0x000000106e6e7824ULL, 0x100fe200078e0272ULL,
0x0000a00070287811ULL, 0x000fe200078e20ffULL, 0x0000001063637824ULL, 0x100fe200078e0272ULL,
0x0000000710107812ULL, 0x000fe200078e786bULL, 0x000000106a6a7824ULL, 0x000fc400078e0272ULL,
0x0000001065657824ULL, 0x000fe400078e0272ULL, 0x000000086b6b7824ULL, 0x000fe200078e0210ULL,
0x00000054ff10723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002828783bULL, 0x004fe20000000200ULL, 0x0000541010757816ULL, 0x000fe20000000010ULL,
0x0000001062627824ULL, 0x000fe200078e0272ULL, 0x0000a0006b147811ULL, 0x000fe200078e20ffULL,
0x000000006d4c783bULL, 0x000fe80000004200ULL, 0x000000006f58783bULL, 0x000fe80000004200ULL,
0x000000006e50783bULL, 0x000fe80000004200ULL, 0x000000006c2c783bULL, 0x000fe80000004200ULL,
0x00001f7375737589ULL, 0x000e6800000e0000ULL, 0x00001f0a75747589ULL, 0x000ea800000e0000ULL,
0x000000001414783bULL, 0x000ee80000000200ULL, 0x000000006344783bULL, 0x000f280000004200ULL,
0x000000006a20783bULL, 0x000f680000004200ULL, 0x000000006518783bULL, 0x000f280000004200ULL,
0x000000006210783bULL, 0x000f220000004200ULL, 0x0000007328289231ULL, 0x002fc400003400ffULL,
0x000000732a2a9231ULL, 0x000fe400003400ffULL, 0x0000007429299231ULL, 0x084fe400003400ffULL,
0x000000742b2b9231ULL, 0x000fce00003400ffULL, 0x0000004c2848723cULL, 0x040ff00000041848ULL,
0x000000582834723cULL, 0x000fe20000041834ULL, 0x0000007314149231ULL, 0x088fe400003400ffULL,
0x0000007316169231ULL, 0x000fc400003400ffULL, 0x0000007415159231ULL, 0x000fc600003400ffULL,
0x0000005a2838723cULL, 0x000fe20000041838ULL, 0x0000007417179231ULL, 0x000fce00003400ffULL,
0x00000050283c723cULL, 0x040ff0000004183cULL, 0x000000522840723cULL, 0x040ff00000041840ULL,
0x0000004e281c723cULL, 0x040ff0000004181cULL, 0x0000002c2830723cULL, 0x040ff00000041830ULL,
0x0000002e2824723cULL, 0x000ff00000041824ULL, 0x000000441448723cULL, 0x050ff00000041848ULL,
0x000000201434723cULL, 0x060ff00000041834ULL, 0x000000221438723cULL, 0x040ff00000041838ULL,
0x00000018143c723cULL, 0x040ff0000004183cULL, 0x0000001a1440723cULL, 0x040ff00000041840ULL,
0x000000461444723cULL, 0x040ff0000004181cULL, 0x000000101430723cULL, 0x040ff00000041830ULL,
0x000000121414723cULL, 0x000fe20000041824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000687100720cULL, 0x000fe20003f26070ULL, 0x01461000ffff7f8cULL, 0x000fd8000c80043fULL,
0x000067a000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000063000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1b7819ULL, 0x000fe2000001160fULL,
0x00000008672b7824ULL, 0x000fe200078e020cULL, 0x0000002071117810ULL, 0x000fe40007ffe0ffULL,
0x000000081b1f7810ULL, 0x040fe40007ffe0ffULL, 0x0000001168107217ULL, 0x000fe40007800000ULL,
0x000000041b1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000081f187824ULL, 0x000fe200078e00ffULL,
0x000000101b267810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x0000000f1f117212ULL, 0x080fe200078e3cffULL, 0x000000081d277824ULL, 0x000fe200078e00ffULL,
0x0000000c1b217810ULL, 0x000fe20007ffe0ffULL, 0x00000008261a7824ULL, 0x000fe200078e00ffULL,
0x0000000f1d127212ULL, 0x000fc400078e3cffULL, 0x0000000f26137212ULL, 0x080fe200078e3cffULL,
0x00000008212d7824ULL, 0x000fe200078e00ffULL, 0x000000141b287810ULL, 0x040fe40007ffe0ffULL,
0xfffffff818297812ULL, 0x000fe200078ee211ULL, 0x0000000460117c24ULL, 0x000fe2000f8e025fULL,
0x000000181b2a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff827277812ULL, 0x000fe200078ee212ULL,
0x0000001029297824ULL, 0x100fe200078e0272ULL, 0xfffffff81a2f7812ULL, 0x000fe200078ee213ULL,
0x000000082a4f7824ULL, 0x000fe200078e00ffULL, 0x0000001c1b2c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001027277824ULL, 0x000fe200078e0272ULL, 0x0000000f21127212ULL, 0x000fc400078e3cffULL,
0x0000000f28137212ULL, 0x080fe200078e3cffULL, 0x000000082c4c7824ULL, 0x000fe200078e00ffULL,
0x00000003281a7819ULL, 0x000fe400000006ffULL, 0x0000000f2a187212ULL, 0x000fe400078e3cffULL,
0x0000006011117810ULL, 0x000fe40007ffe0ffULL, 0x0000007f1f1c7812ULL, 0x000fe400078ec0ffULL,
0xfffffff82d2d7812ULL, 0x000fc400078ee212ULL, 0xfffffff81a4d7812ULL, 0x000fe200078ee213ULL,
0x000000011c197824ULL, 0x100fe200078e0211ULL, 0x0000007f26207812ULL, 0x000fe400078ec0ffULL,
0x0000007f1b127812ULL, 0x000fe400078ec0ffULL, 0x0000007f1d1a7812ULL, 0x000fe200078ec0ffULL,
0x00000001201c7824ULL, 0x100fe200078e0211ULL, 0x0000007f2a247812ULL, 0x000fe200078ec0ffULL,
0x0000000112127824ULL, 0x100fe200078e0211ULL, 0x0000000f2c237212ULL, 0x000fe200078e3cffULL,
0x000000011a137824ULL, 0x100fe200078e0211ULL, 0x0000007f211e7812ULL, 0x000fe200078ec0ffULL,
0x0000000124207824ULL, 0x000fe200078e0211ULL, 0xfffffff84f4f7812ULL, 0x000fc400078ee218ULL,
0x0000007f28227812ULL, 0x000fe200078ec0ffULL, 0x000000011e1a7824ULL, 0x100fe200078e0211ULL,
0x0000002010187817ULL, 0x000fe40003800000ULL, 0x0000007f2c2e7812ULL, 0x000fe200078ec0ffULL,
0x00000001221e7824ULL, 0x000fe200078e0211ULL, 0xfffffff84c517812ULL, 0x000fe200078ee223ULL,
0x00000200ff237424ULL, 0x000fe200078e00ffULL, 0x000000071b247812ULL, 0x040fe400078e480fULL,
0x000000181b00720cULL, 0x000fe20003fc6070ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0023ULL,
0x000000112e227210ULL, 0x000fc40007ffe0ffULL, 0x000000181d00720cULL, 0x080fe20003f26070ULL,
0x00005e0012107625ULL, 0x080fe200078e0023ULL, 0x0ffffff824257812ULL, 0x000fe400078ef80fULL,
0x000000181f00720cULL, 0x080fe20003f46070ULL, 0x00005e0013127625ULL, 0x000fe200078e0023ULL,
0x000000182100720cULL, 0x080fe40003f66070ULL, 0x000000182600720cULL, 0x080fe20003f86070ULL,
0x0000001025257824ULL, 0x000fe200078e0272ULL, 0x000000182800720cULL, 0x000fe20003fa6070ULL,
0x000000102b107825ULL, 0x000fc800078e0010ULL, 0x000000102b127825ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010257faeULL, 0x0003e2000f101c46ULL,
0x000000182a00720cULL, 0x080fe40003fc6070ULL, 0x00005e001c1c7625ULL, 0x080fe200078e0023ULL,
0x0000000012277faeULL, 0x0005e2000c901c46ULL, 0x000000182c00720cULL, 0x000fe40003f26070ULL,
0x00005e0019187625ULL, 0x000fc800078e0023ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0023ULL,
0x00005e0020207625ULL, 0x000fc800078e0023ULL, 0x00005e0022227625ULL, 0x000fc800078e0023ULL,
0x000000102b187825ULL, 0x000fc800078e0018ULL, 0x000000102b1a7825ULL, 0x000fe200078e001aULL,
0x0000000018297faeULL, 0x0007e6000d101c46ULL, 0x000000102d117824ULL, 0x002fe400078e0272ULL,
0x000000102b1c7825ULL, 0x000fc600078e001cULL, 0x000000001a117faeULL, 0x0007e2000d901c46ULL,
0x000000102f137824ULL, 0x004fe400078e0272ULL, 0x000000102b1e7825ULL, 0x000fc600078e001eULL,
0x000000001c137faeULL, 0x0007e2000e101c46ULL, 0x000000104d257824ULL, 0x000fe400078e0272ULL,
0x000000102b207825ULL, 0x000fc600078e0020ULL, 0x000000001e257faeULL, 0x0007e2000e901c46ULL,
0x000000102b227825ULL, 0x000fe200078e0022ULL, 0x00000072512b7211ULL, 0x000fc600078e20ffULL,
0x000000104f277824ULL, 0x000fca00078e0272ULL, 0x0000000020277faeULL, 0x0007e8000f101c46ULL,
0x00000000222b7faeULL, 0x0007e2000c901c46ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x00000003ff107819ULL, 0x000fe2000001160fULL, 0x0000000460607c24ULL, 0x000fe4000f8e025fULL,
0x0000000867257824ULL, 0x000fe200078e020cULL, 0x0000000c101c7810ULL, 0x040fe40007ffe0ffULL,
0x0000000410187810ULL, 0x000fc40007ffe0ffULL, 0x00000008101a7810ULL, 0x000fe20007ffe0ffULL,
0x000000081c207824ULL, 0x040fe200078e00ffULL, 0x0000000f1c137212ULL, 0x080fe200078e3cffULL,
0x00000008181e7824ULL, 0x040fe200078e00ffULL, 0x0000000f18117212ULL, 0x080fe200078e3cffULL,
0x000000081a1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8202d7812ULL, 0x000fe400078ee213ULL,
0x0000001410207810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1a127212ULL, 0x000fe200078e3cffULL,
0x000000102d2d7824ULL, 0x000fe200078e0272ULL, 0xfffffff81e1b7812ULL, 0x000fe200078ee211ULL,
0x00000008204d7824ULL, 0x000fe200078e00ffULL, 0x00000010101e7810ULL, 0x000fc40007ffe0ffULL,
0x0000001810247810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL,
0x000000081e227824ULL, 0x000fe200078e00ffULL, 0x0000000f20127212ULL, 0x080fe200078e3cffULL,
0x0000000824267824ULL, 0x000fe200078e00ffULL, 0x0000000f1e117212ULL, 0x080fe400078e3cffULL,
0x0000000f24137212ULL, 0x000fe400078e3cffULL, 0xfffffff84d4d7812ULL, 0x000fc400078ee212ULL,
0x0000000710127812ULL, 0x000fe400078e480fULL, 0xfffffff8222f7812ULL, 0x000fe200078ee211ULL,
0x00000200ff227424ULL, 0x000fe200078e00ffULL, 0xfffffff826517812ULL, 0x000fe200078ee213ULL,
0x000000104d4d7824ULL, 0x100fe200078e0272ULL, 0x0000006060607810ULL, 0x000fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0272ULL, 0x0000007f10117812ULL, 0x000fe200078ec0ffULL,
0x0000001051517824ULL, 0x000fe200078e0272ULL, 0x0ffffff812137812ULL, 0x000fc400078ef80fULL,
0x0000001c10107810ULL, 0x000fe20007ffe0ffULL, 0x0000000111117824ULL, 0x000fe200078e0260ULL,
0x0000007f18197812ULL, 0x000fe200078ec0ffULL, 0x0000001013277824ULL, 0x000fe200078e0272ULL,
0x0000007f1a1d7812ULL, 0x000fe400078ec0ffULL, 0x0000007f1c217812ULL, 0x000fe200078ec0ffULL,
0x0000000119137824ULL, 0x100fe200078e0260ULL, 0x0000007f1e237812ULL, 0x000fe200078ec0ffULL,
0x000000011d197824ULL, 0x100fe200078e0260ULL, 0x0000007f20297812ULL, 0x000fe200078ec0ffULL,
0x0000000121217824ULL, 0x100fe200078e0260ULL, 0x0000000f10127212ULL, 0x040fe200078e3cffULL,
0x00000001231d7824ULL, 0x100fe200078e0260ULL, 0x0000000310597819ULL, 0x000fe200000006ffULL,
0x0000000129237824ULL, 0x000fe200078e0260ULL, 0x0000007f242b7812ULL, 0x000fe200078ec0ffULL,
0x000000101b297824ULL, 0x000fe200078e0272ULL, 0x0000007f10537812ULL, 0x000fe200078ec0ffULL,
0x00005e0011107625ULL, 0x000fe200078e0022ULL, 0xfffffff859597812ULL, 0x000fc600078ee212ULL,
0x00005e0013127625ULL, 0x000fc800078e0022ULL, 0x000000012b4f7824ULL, 0x000fe200078e0260ULL,
0x000000721f2b7211ULL, 0x000fe200078e20ffULL, 0x00005e0019187625ULL, 0x000fc800078e0022ULL,
0x0000000153537824ULL, 0x000fe400078e0260ULL, 0x00005e00211a7625ULL, 0x000fc800078e0022ULL,
0x00005e001d1c7625ULL, 0x000fc800078e0022ULL, 0x00005e00231e7625ULL, 0x000fc800078e0022ULL,
0x0000001025107825ULL, 0x000fc800078e0010ULL, 0x00005e004f207625ULL, 0x080fe200078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010277faeULL, 0x0003e6000b901c46ULL,
0x00005e0053227625ULL, 0x000fc800078e0022ULL, 0x0000001025127825ULL, 0x000fc800078e0012ULL,
0x0000001025187825ULL, 0x040fe200078e0018ULL, 0x0000000012297faeULL, 0x0003e6000b901c46ULL,
0x00000010251a7825ULL, 0x040fe200078e001aULL, 0x00000000182b7faeULL, 0x0003e6000b901c46ULL,
0x00000010251c7825ULL, 0x040fe200078e001cULL, 0x000000001a2d7faeULL, 0x0003e6000b901c46ULL,
0x00000010251e7825ULL, 0x040fe200078e001eULL, 0x000000001c2f7faeULL, 0x0003e6000b901c46ULL,
0x0000001025207825ULL, 0x040fe200078e0020ULL, 0x000000001e4d7faeULL, 0x0003e6000b901c46ULL,
0x0000001025227825ULL, 0x000fe200078e0022ULL, 0x0000000020517faeULL, 0x0003e6000b901c46ULL,
0x0000001059597824ULL, 0x000fca00078e0272ULL, 0x0000000022597faeULL, 0x0003e4000b901c46ULL,
0x00000300ff737624ULL, 0x000fe200078e00ffULL, 0x0000000161107812ULL, 0x002fe200078ec0ffULL,
0x01461c00ff127984ULL, 0x000e620000000800ULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x000000011000780cULL, 0x000fe20003f25070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff73737811ULL, 0x000fc800078e08ffULL, 0x0000000173737807ULL, 0x000fca0004800000ULL,
0x0000000161617824ULL, 0x000fca00078e0273ULL, 0x000000666100720cULL, 0x000fda0003f26070ULL,
0x000000735d109210ULL, 0x000fe20007ffe056ULL, 0x00000004ff119424ULL, 0x008fc800078e00ffULL,
0x0000600010109625ULL, 0x000fca00078e0011ULL, 0x0000000610609981ULL, 0x000562000c1e1900ULL,
0x0000001f0d137819ULL, 0x000fc800000006ffULL, 0x8000000012ff7812ULL, 0x002fe20007824813ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x004fe400078e00ffULL, 0x800000000d127824ULL, 0x000fe400078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01461c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0140800055117984ULL, 0x004e620000000800ULL,
0x0000a8000e287811ULL, 0x000fc600078e20ffULL, 0x0142800055757984ULL, 0x0004e20000000800ULL,
0x0000005e1100720bULL, 0x002fda0003f3d000ULL, 0x0000000000107806ULL, 0x000fc800008e0100ULL,
0x0000ffff10187812ULL, 0x000fe2000782c0ffULL, 0x00000001ff107424ULL, 0x000fd800078e00ffULL,
0x0000034000009947ULL, 0x000fea0003800000ULL, 0x0000005e1100720bULL, 0x00cfe40003f34000ULL,
0x000000115e127209ULL, 0x000fe40007810000ULL, 0x00000002ff1a7819ULL, 0x000fc6000001160fULL,
0x800000125e107221ULL, 0x040fe20000010000ULL, 0x000000115e5e7209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b10137820ULL, 0x000fe40000410000ULL, 0x0000000000107806ULL, 0x000fe400008e0100ULL,
0x000000016700780cULL, 0x000fe40003f25270ULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000ffff10197812ULL, 0x000fc800078e3cffULL, 0x0000001918ff7212ULL, 0x000fcc000784c0ffULL,
0x0144801255009388ULL, 0x000fe80000000800ULL, 0x00001f1a13107589ULL, 0x002e6200000e0000ULL,
0x000000135c5c7220ULL, 0x000fe40000410000ULL, 0x8000001211192221ULL, 0x000fe20000010000ULL,
0x00001f0a13187589ULL, 0x000ea600000e0000ULL, 0x3fb8aa3b19192820ULL, 0x000fc80000410000ULL,
0x0000001900542308ULL, 0x000ee20000000800ULL, 0x0000001034347220ULL, 0x082fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001038387220ULL, 0x080fe20000410000ULL,
0x0000001039397220ULL, 0x080fe20000410000ULL, 0x000000103c3c7220ULL, 0x080fe20000410000ULL,
0x000000103d3d7220ULL, 0x080fe20000410000ULL, 0x0000001040407220ULL, 0x080fe20000410000ULL,
0x0000001041417220ULL, 0x080fe20000410000ULL, 0x0000001048487220ULL, 0x080fe20000410000ULL,
0x0000001049497220ULL, 0x080fe20000410000ULL, 0x0000001044447220ULL, 0x080fe20000410000ULL,
0x0000001045457220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001014147220ULL, 0x080fe20000410000ULL,
0x0000001015157220ULL, 0x000fe20000410000ULL, 0x00000001ff107807ULL, 0x000fe20001000000ULL,
0x0000001836367220ULL, 0x084fe20000410000ULL, 0x0000001837377220ULL, 0x080fe20000410000ULL,
0x000000183a3a7220ULL, 0x080fe20000410000ULL, 0x000000183b3b7220ULL, 0x080fe20000410000ULL,
0x000000183e3e7220ULL, 0x080fe20000410000ULL, 0x000000183f3f7220ULL, 0x080fe20000410000ULL,
0x0000001842427220ULL, 0x080fe20000410000ULL, 0x0000001843437220ULL, 0x080fe20000410000ULL,
0x000000184a4a7220ULL, 0x080fe20000410000ULL, 0x000000184b4b7220ULL, 0x080fe20000410000ULL,
0x0000001846467220ULL, 0x080fe20000410000ULL, 0x0000001847477220ULL, 0x080fe20000410000ULL,
0x0000001832327220ULL, 0x080fe20000410000ULL, 0x0000001833337220ULL, 0x080fe20000410000ULL,
0x0000001816167220ULL, 0x080fe20000410000ULL, 0x0000001817177220ULL, 0x000fe20000410000ULL,
0x0000007554752220ULL, 0x008fe20000410000ULL, 0x000080400000791aULL, 0x00cfc80000000000ULL,
0x000000002828783bULL, 0x000fe20000000200ULL, 0x00000054ff11723eULL, 0x000fe200000010ffULL,
0x0000005c755c7221ULL, 0x000fe20000010000ULL, 0x00000002ff777819ULL, 0x000fe2000001160fULL,
0x000000000958783bULL, 0x000fe20000004200ULL, 0x0000541011767816ULL, 0x000fe40000000011ULL,
0x0000a80005117811ULL, 0x000fe200078e20ffULL, 0x00000000074c783bULL, 0x000fe20000004200ULL,
0x0000991010187816ULL, 0x000fc600000000ffULL, 0x000000000850783bULL, 0x000fe20000004200ULL,
0x000000ff1800720cULL, 0x000fc60003f25270ULL, 0x00000000062c783bULL, 0x000fe80000004200ULL,
0x00001f7776777589ULL, 0x000e6800000e0000ULL, 0x00001f0a76747589ULL, 0x000ea800000e0000ULL,
0x000000001110783bULL, 0x000ee80000000200ULL, 0x000000000424783bULL, 0x000f280000004200ULL,
0x00000000021c783bULL, 0x000f280000004200ULL, 0x000000000320783bULL, 0x000f280000004200ULL,
0x000000000018783bULL, 0x000f220000004200ULL, 0x0000007728289231ULL, 0x002fc400003400ffULL,
0x000000772a2a9231ULL, 0x000fe400003400ffULL, 0x0000007429299231ULL, 0x084fe400003400ffULL,
0x000000742b2b9231ULL, 0x000fce00003400ffULL, 0x000000582834723cULL, 0x040ff00000041834ULL,
0x0000005a2838723cULL, 0x000fe20000041838ULL, 0x0000007710109231ULL, 0x088fe400003400ffULL,
0x0000007712129231ULL, 0x000fc400003400ffULL, 0x0000007411119231ULL, 0x000fc600003400ffULL,
0x0000004c2848723cULL, 0x000fe20000041848ULL, 0x0000007413139231ULL, 0x000fce00003400ffULL,
0x00000050283c723cULL, 0x040ff0000004183cULL, 0x000000522840723cULL, 0x040ff00000041840ULL,
0x0000004e2844723cULL, 0x040ff00000041844ULL, 0x0000002c2830723cULL, 0x040ff00000041830ULL,
0x0000002e2814723cULL, 0x000ff00000041814ULL, 0x000000241034723cULL, 0x050ff00000041834ULL,
0x000000261038723cULL, 0x040ff00000041838ULL, 0x0000001c1048723cULL, 0x040ff00000041848ULL,
0x00000020103c723cULL, 0x040ff0000004183cULL, 0x000000221040723cULL, 0x040ff00000041840ULL,
0x0000001e101c723cULL, 0x040ff00000041844ULL, 0x000000181030723cULL, 0x040ff00000041830ULL,
0x0000001a1024723cULL, 0x000fe20000041814ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000062000008947ULL, 0x000fea0003800000ULL, 0x00000003ff127819ULL, 0x000fe4000001160fULL,
0x0000004071117810ULL, 0x000fe40007ffe0ffULL, 0x0000000812157810ULL, 0x040fe40007ffe0ffULL,
0x0000001012197810ULL, 0x000fe40007ffe0ffULL, 0x0000000f15147212ULL, 0x040fe200078e3cffULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x0000001168107217ULL, 0x000fe20007800000ULL,
0x0000000819237824ULL, 0x000fe200078e00ffULL, 0x0000000412137810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81b227812ULL, 0x000fe200078ee214ULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x0000000f19147212ULL, 0x080fe200078e3cffULL, 0x00000008131a7824ULL, 0x040fe200078e00ffULL,
0x00000014121b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010222f7824ULL, 0x000fe200078e020bULL,
0x0000000c12177810ULL, 0x040fe40007ffe0ffULL, 0x0000000f13117212ULL, 0x080fe400078e3cffULL,
0xfffffff823447812ULL, 0x000fe200078ee214ULL, 0x000000081b237824ULL, 0x000fe200078e00ffULL,
0x0000001c12457810ULL, 0x000fe20007ffe0ffULL, 0x00000008172c7824ULL, 0x000fe200078e00ffULL,
0x0000000f1b167212ULL, 0x000fc400078e3cffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL,
0x0000000845587824ULL, 0x000fe200078e00ffULL, 0x0000000f17117212ULL, 0x080fe400078e3cffULL,
0x0000001812217810ULL, 0x000fe20007ffe0ffULL, 0x000000101a2d7824ULL, 0x000fe200078e020bULL,
0xfffffff8234c7812ULL, 0x000fe400078ee216ULL, 0x0000000f45237212ULL, 0x000fe400078e3cffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee211ULL, 0x0000000460117c24ULL, 0x020fe2000f8e025fULL,
0x0000007f12147812ULL, 0x000fc400078ec0ffULL, 0x0000002010287817ULL, 0x000fe40003800000ULL,
0x0000000f21187212ULL, 0x000fe200078e3cffULL, 0x0000000111147824ULL, 0x000fe200078e0214ULL,
0x0000000321297819ULL, 0x000fe400000006ffULL, 0x0000007f13167812ULL, 0x000fe400078ec0ffULL,
0x0000007f15207812ULL, 0x000fe400078ec0ffULL, 0x0000007f172a7812ULL, 0x000fc400078ec0ffULL,
0x0000007f192e7812ULL, 0x000fe200078ec0ffULL, 0x0000000111207824ULL, 0x000fe200078e0220ULL,
0x0000007f1b467812ULL, 0x000fe200078ec0ffULL, 0x00000001112a7824ULL, 0x000fe200078e022aULL,
0x0000007f214e7812ULL, 0x000fe200078ec0ffULL, 0x00000001112e7824ULL, 0x000fe200078e022eULL,
0x0000007f45527812ULL, 0x000fe200078ec0ffULL, 0x0000000111467824ULL, 0x040fe200078e0246ULL,
0xfffffff858587812ULL, 0x000fe200078ee223ULL, 0x00000001114e7824ULL, 0x040fe200078e024eULL,
0x0000020000237802ULL, 0x000fe20000000f00ULL, 0x0000000111527824ULL, 0x000fe200078e0252ULL,
0x000000281200720cULL, 0x000fc40003f66070ULL, 0xfffffff829507812ULL, 0x000fe200078ee218ULL,
0x0000000111187824ULL, 0x000fe200078e0216ULL, 0x0000000712127812ULL, 0x100fe200078e480fULL,
0x00005e0014107625ULL, 0x080fe200078e0023ULL, 0x000000281300720cULL, 0x080fe40003fc6070ULL,
0x0ffffff812167812ULL, 0x000fe200078ef80fULL, 0x00005e0018127625ULL, 0x080fe200078e0023ULL,
0x000000281500720cULL, 0x080fe40003fa6070ULL, 0x000000281700720cULL, 0x080fe20003f46070ULL,
0x0000000867297824ULL, 0x000fe200078e020cULL, 0x000000281900720cULL, 0x000fe20003f86070ULL,
0x00005e0020147625ULL, 0x000fc800078e0023ULL, 0x00000010162b7824ULL, 0x000fe400078e020bULL,
0x0000001029107825ULL, 0x000fc800078e0010ULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102b7faeULL, 0x0003e2000d901c46ULL,
0x000000281b00720cULL, 0x080fe40003f66070ULL, 0x0000001029147825ULL, 0x000fe200078e0014ULL,
0x00000000122d7faeULL, 0x0005e2000f101c46ULL, 0x000000282100720cULL, 0x080fe40003fc6070ULL,
0x00005e002a167625ULL, 0x000fe200078e0023ULL, 0x00000000142f7faeULL, 0x0007e2000e901c46ULL,
0x000000284500720cULL, 0x000fc40003fa6070ULL, 0x00005e002e187625ULL, 0x000fc800078e0023ULL,
0x00005e00461a7625ULL, 0x000fc800078e0023ULL, 0x00005e004e207625ULL, 0x000fc800078e0023ULL,
0x00005e0052227625ULL, 0x000fc800078e0023ULL, 0x0000001029107825ULL, 0x002fc800078e0016ULL,
0x0000001029167825ULL, 0x000fc800078e0018ULL, 0x0000001029127825ULL, 0x004fc800078e001aULL,
0x0000001029187825ULL, 0x000fc800078e0020ULL, 0x000000102c1b7824ULL, 0x000fe400078e020bULL,
0x0000001029147825ULL, 0x008fc600078e0022ULL, 0x00000000101b7faeULL, 0x0003e2000d101c46ULL,
0x0000001044217824ULL, 0x100fe400078e020bULL, 0x000000104c237824ULL, 0x100fe400078e020bULL,
0x0000001050297824ULL, 0x100fe200078e020bULL, 0x0000000016217faeULL, 0x0003e2000e101c46ULL,
0x00000010582b7824ULL, 0x000fc600078e020bULL, 0x0000000012237faeULL, 0x0003e8000d901c46ULL,
0x0000000018297faeULL, 0x0003e8000f101c46ULL, 0x00000000142b7faeULL, 0x0003e2000e901c46ULL,
0x0000055000007947ULL, 0x000fea0003800000ULL, 0x00000003ff107819ULL, 0x000fe2000001160fULL,
0x00000200ff227424ULL, 0x000fc400078e00ffULL, 0x0000000867297824ULL, 0x000fe200078e020cULL,
0x00000008101a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000410167810ULL, 0x040fe40007ffe0ffULL,
0x0000000c10287810ULL, 0x000fe20007ffe0ffULL, 0x000000081a137824ULL, 0x000fe200078e00ffULL,
0x0000000f16117212ULL, 0x040fe400078e3cffULL, 0x0000000316187819ULL, 0x000fe200000006ffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x00000010102c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000f1a127212ULL, 0x080fe400078e3cffULL, 0x00000018104c7810ULL, 0x000fe20007ffe0ffULL,
0x000000082c157824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe400078ee211ULL,
0x0000001410447810ULL, 0x000fe20007ffe0ffULL, 0x000000084c177824ULL, 0x000fe200078e00ffULL,
0xfffffff813207812ULL, 0x000fe400078ee212ULL, 0x0000000f28117212ULL, 0x080fe200078e3cffULL,
0x0000000844467824ULL, 0x000fe200078e00ffULL, 0x0000000f2c127212ULL, 0x080fe200078e3cffULL,
0x00000010202f7824ULL, 0x000fe200078e020bULL, 0x0000000f4c147212ULL, 0x000fc400078e3cffULL,
0xfffffff82a2a7812ULL, 0x000fe400078ee211ULL, 0x0000000f44137212ULL, 0x000fe400078e3cffULL,
0xfffffff8152e7812ULL, 0x000fe200078ee212ULL, 0x0000000460127c24ULL, 0x020fe2000f8e025fULL,
0x0000007f10117812ULL, 0x040fe400078ec0ffULL, 0xfffffff8174e7812ULL, 0x000fe400078ee214ULL,
0x0000000710147812ULL, 0x000fe200078e480fULL, 0x0000000112117824ULL, 0x000fe200078e0211ULL,
0x0000001c10107810ULL, 0x000fe20007ffe0ffULL, 0x000000104e457824ULL, 0x000fe200078e020bULL,
0xfffffff846467812ULL, 0x000fc400078ee213ULL, 0x0000007f16137812ULL, 0x000fe200078ec0ffULL,
0x00000008102d7824ULL, 0x000fe200078e00ffULL, 0x0000007f1a157812ULL, 0x000fe400078ec0ffULL,
0x0000007f28177812ULL, 0x000fe200078ec0ffULL, 0x0000000112137824ULL, 0x000fe200078e0213ULL,
0x0000007f2c197812ULL, 0x000fe200078ec0ffULL, 0x0000000112157824ULL, 0x000fe200078e0215ULL,
0x0000007f441b7812ULL, 0x000fe200078ec0ffULL, 0x0000000112177824ULL, 0x000fe200078e0217ULL,
0x0000007f4c217812ULL, 0x000fe200078ec0ffULL, 0x0000000112197824ULL, 0x000fe200078e0219ULL,
0x0000007f10237812ULL, 0x000fe200078ec0ffULL, 0x00000001121b7824ULL, 0x000fe200078e021bULL,
0x0000000f10167212ULL, 0x000fe200078e3cffULL, 0x00005e0011107625ULL, 0x000fe200078e0022ULL,
0x0ffffff814147812ULL, 0x000fc400078ef80fULL, 0xfffffff82d287812ULL, 0x000fe200078ee216ULL,
0x0000000112217824ULL, 0x000fe200078e0221ULL, 0x0000000b142b7211ULL, 0x000fe200078e20ffULL,
0x0000000112237824ULL, 0x000fe400078e0223ULL, 0x00000010182d7824ULL, 0x000fe400078e020bULL,
0x00005e0013127625ULL, 0x000fc800078e0022ULL, 0x0000001029107825ULL, 0x000fc800078e0010ULL,
0x00005e0015147625ULL, 0x080fe200078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102b7faeULL, 0x0003e6000b901c46ULL, 0x00005e0017167625ULL, 0x000fc800078e0022ULL,
0x00005e0019187625ULL, 0x000fc800078e0022ULL, 0x00005e001b1a7625ULL, 0x000fc800078e0022ULL,
0x00005e0021207625ULL, 0x000fc800078e0022ULL, 0x00005e0023227625ULL, 0x000fc800078e0022ULL,
0x0000001029127825ULL, 0x000fc800078e0012ULL, 0x0000001029147825ULL, 0x040fe200078e0014ULL,
0x00000000122d7faeULL, 0x0005e6000b901c46ULL, 0x0000001029107825ULL, 0x042fe200078e0016ULL,
0x0000000b2a177211ULL, 0x000fe200078e20ffULL, 0x00000000142f7faeULL, 0x0005e4000b901c46ULL,
0x0000001029187825ULL, 0x040fe400078e0018ULL, 0x0000000010177faeULL, 0x0005e4000b901c46ULL,
0x00000010291a7825ULL, 0x000fc800078e001aULL, 0x0000001029207825ULL, 0x000fc800078e0020ULL,
0x0000001029227825ULL, 0x000fc800078e0022ULL, 0x000000102e297824ULL, 0x100fe400078e020bULL,
0x00000010462b7824ULL, 0x100fe400078e020bULL, 0x0000001028477824ULL, 0x000fe200078e020bULL,
0x0000000018297faeULL, 0x0005e8000b901c46ULL, 0x000000001a2b7faeULL, 0x0005e8000b901c46ULL,
0x0000000020457faeULL, 0x0005e8000b901c46ULL, 0x0000000022477faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000a80070287811ULL, 0x000fc400078e20ffULL,
0x00000054ff10723eULL, 0x006fe400000010ffULL, 0x00000002ff757819ULL, 0x000fe4000001160fULL,
0x0000541010767816ULL, 0x000fe40000000010ULL, 0x0000a8006b147811ULL, 0x000fc600078e20ffULL,
0x00001f7576757589ULL, 0x000fe800000e0000ULL, 0x00001f0a76747589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002828783bULL, 0x000e680000000200ULL,
0x000000006d4c783bULL, 0x000ea80000004200ULL, 0x000000006f58783bULL, 0x000fe80000004200ULL,
0x000000006e50783bULL, 0x000fe80000004200ULL, 0x000000006c2c783bULL, 0x000fe80000004200ULL,
0x000000001414783bULL, 0x000ee80000000200ULL, 0x000000006344783bULL, 0x000f280000004200ULL,
0x000000006a20783bULL, 0x000f680000004200ULL, 0x000000006518783bULL, 0x000f280000004200ULL,
0x000000006210783bULL, 0x000f220000004200ULL, 0x0000007528289231ULL, 0x002fc400003400ffULL,
0x000000752a2a9231ULL, 0x000fe400003400ffULL, 0x0000007429299231ULL, 0x080fe400003400ffULL,
0x000000742b2b9231ULL, 0x000fce00003400ffULL, 0x0000004c2848723cULL, 0x004fe20000041848ULL,
0x0000007514149231ULL, 0x008fce00003400ffULL, 0x000000582834723cULL, 0x000fe20000041834ULL,
0x0000007516169231ULL, 0x000fe400003400ffULL, 0x0000007415159231ULL, 0x080fe400003400ffULL,
0x0000007417179231ULL, 0x000fc600003400ffULL, 0x0000005a2838723cULL, 0x040ff00000041838ULL,
0x00000050283c723cULL, 0x040ff0000004183cULL, 0x000000522840723cULL, 0x040ff00000041840ULL,
0x0000004e281c723cULL, 0x040ff0000004181cULL, 0x0000002c2830723cULL, 0x040ff00000041830ULL,
0x0000002e2824723cULL, 0x000ff00000041824ULL, 0x000000441448723cULL, 0x050ff00000041848ULL,
0x000000201434723cULL, 0x060ff00000041834ULL, 0x000000221438723cULL, 0x040ff00000041838ULL,
0x00000018143c723cULL, 0x040ff0000004183cULL, 0x0000001a1440723cULL, 0x040ff00000041840ULL,
0x000000461444723cULL, 0x040ff0000004181cULL, 0x000000101430723cULL, 0x040ff00000041830ULL,
0x000000121414723cULL, 0x000fe20000041824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000004071117810ULL, 0x000fe20007ffe0ffULL, 0x01462000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000681100720cULL, 0x000fda0003f26070ULL, 0x000044f000001947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000063000008947ULL, 0x000fea0003800000ULL,
0x00000003ff127819ULL, 0x000fe4000001160fULL, 0x0000006071117810ULL, 0x000fe40007ffe0ffULL,
0x0000000412197810ULL, 0x000fe40007ffe0ffULL, 0x0000001168107217ULL, 0x000fe40007800000ULL,
0x00000008121c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000819187824ULL, 0x040fe200078e00ffULL,
0x0000000c12207810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x0000001012247810ULL, 0x000fe20007ffe0ffULL, 0x000000081c1a7824ULL, 0x000fe200078e00ffULL,
0x0000000f19137212ULL, 0x080fe200078e3cffULL, 0x00000008201e7824ULL, 0x000fe200078e00ffULL,
0x0000000f1c117212ULL, 0x000fe200078e3cffULL, 0x00000008244d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8181d7812ULL, 0x000fc400078ee213ULL, 0xfffffff81a217812ULL, 0x000fe200078ee211ULL,
0x0000000460117c24ULL, 0x000fe2000f8e025fULL, 0x0000000f20137212ULL, 0x080fe200078e3cffULL,
0x000000101d297824ULL, 0x000fe200078e0272ULL, 0x0000000f24187212ULL, 0x000fe400078e3cffULL,
0x0000001412287810ULL, 0x040fe40007ffe0ffULL, 0x00000018122b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81e2d7812ULL, 0x000fc400078ee213ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee218ULL,
0x000000082b597824ULL, 0x000fe200078e00ffULL, 0x0000000f28137212ULL, 0x0c0fe200078e3cffULL,
0x000000102d2d7824ULL, 0x100fe200078e0272ULL, 0x00000003281e7819ULL, 0x000fe200000006ffULL,
0x000000104d4d7824ULL, 0x000fe200078e0272ULL, 0x0000002011117810ULL, 0x000fe40007ffe0ffULL,
0x0000007f12187812ULL, 0x000fe400078ec0ffULL, 0x0000000f2b1a7212ULL, 0x000fc400078e3cffULL,
0xfffffff81e517812ULL, 0x000fe200078ee213ULL, 0x0000000118137824ULL, 0x100fe200078e0211ULL,
0x0000007f20227812ULL, 0x000fe400078ec0ffULL, 0xfffffff859597812ULL, 0x000fe200078ee21aULL,
0x0000001051517824ULL, 0x100fe200078e0272ULL, 0x0000001c122e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000122237824ULL, 0x100fe200078e0211ULL, 0x0000002010187817ULL, 0x000fe20003800000ULL,
0x00000200ff227424ULL, 0x000fe200078e00ffULL, 0x0000007f191a7812ULL, 0x000fe200078ec0ffULL,
0x000000082e4e7824ULL, 0x000fe200078e00ffULL, 0x0000007f1c1e7812ULL, 0x000fe200078ec0ffULL,
0x0000001059597824ULL, 0x000fe200078e0272ULL, 0x0000007f24267812ULL, 0x000fe200078ec0ffULL,
0x000000011a1b7824ULL, 0x100fe200078e0211ULL, 0x0000007f282a7812ULL, 0x000fe200078ec0ffULL,
0x000000011e1f7824ULL, 0x100fe200078e0211ULL, 0x0000007f2b2c7812ULL, 0x000fe200078ec0ffULL,
0x00000001262f7824ULL, 0x100fe200078e0211ULL, 0x0000007f2e4c7812ULL, 0x000fe200078ec0ffULL,
0x000000012a4f7824ULL, 0x100fe200078e0211ULL, 0x000000181200720cULL, 0x000fe20003fc6070ULL,
0x000000012c537824ULL, 0x000fe200078e0211ULL, 0x0000000712127812ULL, 0x000fc400078e480fULL,
0x0000000f2e257212ULL, 0x000fe400078e3cffULL, 0x000000114c5b7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0013107625ULL, 0x000fe200078e0022ULL, 0x000000181900720cULL, 0x000fe40003f26070ULL,
0x0ffffff812197812ULL, 0x000fe200078ef80fULL, 0x00005e001b127625ULL, 0x000fe200078e0022ULL,
0xfffffff84e757812ULL, 0x000fe400078ee225ULL, 0x000000181c00720cULL, 0x080fe20003f46070ULL,
0x0000000867257824ULL, 0x000fe200078e020cULL, 0x000000182000720cULL, 0x080fe20003f66070ULL,
0x0000001019277824ULL, 0x000fe200078e0272ULL, 0x000000182400720cULL, 0x080fe20003f86070ULL,
0x0000001025107825ULL, 0x000fe200078e0010ULL, 0x000000182800720cULL, 0x000fc40003fa6070ULL,
0x0000007275757211ULL, 0x000fe200078e20ffULL, 0x0000001025127825ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010277faeULL, 0x0003e2000f101c46ULL,
0x000000182b00720cULL, 0x000fe40003fc6070ULL, 0x00005e00231a7625ULL, 0x000fe200078e0022ULL,
0x0000000012297faeULL, 0x0003e2000c901c46ULL, 0x000000182e00720cULL, 0x000fe40003f26070ULL,
0x00005e001f187625ULL, 0x000fc800078e0022ULL, 0x00005e002f1c7625ULL, 0x000fc800078e0022ULL,
0x00000010212b7824ULL, 0x000fe400078e0272ULL, 0x00005e004f1e7625ULL, 0x000fc800078e0022ULL,
0x00005e0053207625ULL, 0x000fc800078e0022ULL, 0x00005e005b227625ULL, 0x000fc800078e0022ULL,
0x0000001025187825ULL, 0x000fc800078e0018ULL, 0x00000010251a7825ULL, 0x040fe200078e001aULL,
0x00000000182b7faeULL, 0x0003e6000d101c46ULL, 0x00000010251c7825ULL, 0x040fe200078e001cULL,
0x000000001a2d7faeULL, 0x0003e6000d901c46ULL, 0x00000010251e7825ULL, 0x040fe200078e001eULL,
0x000000001c4d7faeULL, 0x0003e6000e101c46ULL, 0x0000001025207825ULL, 0x040fe200078e0020ULL,
0x000000001e517faeULL, 0x0003e6000e901c46ULL, 0x0000001025227825ULL, 0x000fe200078e0022ULL,
0x0000000020597faeULL, 0x0003e8000f101c46ULL, 0x0000000022757faeULL, 0x0003e2000c901c46ULL,
0x0000056000007947ULL, 0x000fea0003800000ULL, 0x00000003ff107819ULL, 0x000fe2000001160fULL,
0x0000000867257824ULL, 0x000fc600078e020cULL, 0x00000004101a7810ULL, 0x040fe40007ffe0ffULL,
0x00000008101c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c101e7810ULL, 0x000fe20007ffe0ffULL,
0x000000081a187824ULL, 0x000fe200078e00ffULL, 0x0000001010207810ULL, 0x000fe20007ffe0ffULL,
0x000000081c1f7824ULL, 0x000fe200078e00ffULL, 0x0000001810267810ULL, 0x000fe20007ffe0ffULL,
0x000000081e227824ULL, 0x000fe200078e00ffULL, 0x0000000f1a117212ULL, 0x080fe200078e3cffULL,
0x00000008202f7824ULL, 0x000fe200078e00ffULL, 0x0000000f1c127212ULL, 0x080fe200078e3cffULL,
0x0000000826517824ULL, 0x000fe200078e00ffULL, 0x0000000f1e137212ULL, 0x000fc400078e3cffULL,
0x0000001410247810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8181b7812ULL, 0x000fe200078ee211ULL,
0x0000000460117c24ULL, 0x000fe2000f8e025fULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee212ULL,
0x0000000f20127212ULL, 0x080fe400078e3cffULL, 0x0000000f26187212ULL, 0x080fe400078e3cffULL,
0xfffffff8222d7812ULL, 0x000fe200078ee213ULL, 0x0000000824227824ULL, 0x040fe200078e00ffULL,
0x0000000f24137212ULL, 0x000fc400078e3cffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee212ULL,
0x000000102d2d7824ULL, 0x000fe200078e0272ULL, 0xfffffff851517812ULL, 0x000fe400078ee218ULL,
0x0000002011127810ULL, 0x000fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0272ULL,
0x0000000710187812ULL, 0x040fe200078e480fULL, 0x0000001051517824ULL, 0x000fe200078e0272ULL,
0x0000007f10117812ULL, 0x000fe400078ec0ffULL, 0xfffffff8224d7812ULL, 0x000fe200078ee213ULL,
0x00000200ff227424ULL, 0x000fe200078e00ffULL, 0x0000001c10107810ULL, 0x000fe20007ffe0ffULL,
0x0000000111117824ULL, 0x000fe200078e0212ULL, 0x0ffffff818137812ULL, 0x000fe200078ef80fULL,
0x000000104d4d7824ULL, 0x000fe200078e0272ULL, 0x0000007f1a197812ULL, 0x000fc400078ec0ffULL,
0x0000007f1c1d7812ULL, 0x000fe200078ec0ffULL, 0x0000001013277824ULL, 0x000fe200078e0272ULL,
0x0000007f1e217812ULL, 0x000fe200078ec0ffULL, 0x0000000119137824ULL, 0x100fe200078e0212ULL,
0x0000007f20237812ULL, 0x000fe200078ec0ffULL, 0x000000011d197824ULL, 0x100fe200078e0212ULL,
0x0000007f24297812ULL, 0x000fe200078ec0ffULL, 0x0000000121217824ULL, 0x100fe200078e0212ULL,
0x0000007f262b7812ULL, 0x000fe200078ec0ffULL, 0x00000001231d7824ULL, 0x100fe200078e0212ULL,
0x0000007f10537812ULL, 0x040fe200078ec0ffULL, 0x0000000129237824ULL, 0x100fe200078e0212ULL,
0x0000000f10187212ULL, 0x040fe200078e3cffULL, 0x000000012b4f7824ULL, 0x000fe200078e0212ULL,
0x0000000310597819ULL, 0x000fe200000006ffULL, 0x00005e0011107625ULL, 0x000fe200078e0022ULL,
0x000000721f2b7211ULL, 0x000fc400078e20ffULL, 0xfffffff859597812ULL, 0x000fe200078ee218ULL,
0x0000000153537824ULL, 0x000fe400078e0212ULL, 0x00005e0013127625ULL, 0x000fc800078e0022ULL,
0x000000101b297824ULL, 0x000fe400078e0272ULL, 0x00005e0019187625ULL, 0x000fc800078e0022ULL,
0x0000001025107825ULL, 0x000fc800078e0010ULL, 0x00005e00211a7625ULL, 0x080fe200078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010277faeULL, 0x0003e6000b901c46ULL,
0x00005e001d1c7625ULL, 0x000fc800078e0022ULL, 0x00005e00231e7625ULL, 0x000fc800078e0022ULL,
0x00005e004f207625ULL, 0x000fc800078e0022ULL, 0x00005e0053227625ULL, 0x000fc800078e0022ULL,
0x0000001025127825ULL, 0x000fc800078e0012ULL, 0x0000001025187825ULL, 0x040fe200078e0018ULL,
0x0000000012297faeULL, 0x0005e6000b901c46ULL, 0x0000001025107825ULL, 0x042fe200078e001aULL,
0x00000000182b7faeULL, 0x0005e6000b901c46ULL, 0x00000010251c7825ULL, 0x040fe200078e001cULL,
0x00000000102d7faeULL, 0x0005e6000b901c46ULL, 0x00000010251e7825ULL, 0x040fe200078e001eULL,
0x000000001c2f7faeULL, 0x0005e6000b901c46ULL, 0x0000001025207825ULL, 0x040fe200078e0020ULL,
0x000000001e4d7faeULL, 0x0005e6000b901c46ULL, 0x0000001025227825ULL, 0x000fe200078e0022ULL,
0x0000000020517faeULL, 0x0005e6000b901c46ULL, 0x0000001059597824ULL, 0x000fca00078e0272ULL,
0x0000000022597faeULL, 0x0005e4000b901c46ULL, 0x01462c00ff107984ULL, 0x006e620000000800ULL,
0x800000000d117824ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x8000000010ff7812ULL, 0x002fe40007824811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x800000000d127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01462c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007824812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0141000055117984ULL, 0x000e620000000800ULL, 0x0000b0000e287811ULL, 0x000fc600078e20ffULL,
0x0143000055757984ULL, 0x0004e20000000800ULL, 0x0000005e1100720bULL, 0x002fda0003f3d000ULL,
0x0000000000107806ULL, 0x000fc800008e0100ULL, 0x0000ffff10187812ULL, 0x000fe2000782c0ffULL,
0x00000001ff107424ULL, 0x000fd800078e00ffULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x0000005e1100720bULL, 0x00cfe40003f34000ULL, 0x000000115e127209ULL, 0x000fe40007810000ULL,
0x00000002ff1a7819ULL, 0x000fc6000001160fULL, 0x800000125e107221ULL, 0x040fe20000010000ULL,
0x000000115e5e7209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b10137820ULL, 0x000fe40000410000ULL,
0x0000000000107806ULL, 0x000fe400008e0100ULL, 0x000000026700780cULL, 0x000fe40003f25270ULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000ffff10197812ULL, 0x000fc800078e3cffULL,
0x0000001918ff7212ULL, 0x000fcc000784c0ffULL, 0x0145001255009388ULL, 0x000fe80000000800ULL,
0x00001f1a13107589ULL, 0x002e6200000e0000ULL, 0x000000135c5c7220ULL, 0x000fe40000410000ULL,
0x8000001211192221ULL, 0x000fe20000010000ULL, 0x00001f0a13187589ULL, 0x000ea600000e0000ULL,
0x3fb8aa3b19192820ULL, 0x000fc80000410000ULL, 0x0000001900542308ULL, 0x000ee20000000800ULL,
0x0000001034347220ULL, 0x082fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001038387220ULL, 0x080fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x000000103c3c7220ULL, 0x080fe20000410000ULL, 0x000000103d3d7220ULL, 0x080fe20000410000ULL,
0x0000001040407220ULL, 0x080fe20000410000ULL, 0x0000001041417220ULL, 0x080fe20000410000ULL,
0x0000001048487220ULL, 0x080fe20000410000ULL, 0x0000001049497220ULL, 0x080fe20000410000ULL,
0x0000001044447220ULL, 0x080fe20000410000ULL, 0x0000001045457220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001014147220ULL, 0x080fe20000410000ULL, 0x0000001015157220ULL, 0x000fe20000410000ULL,
0x00000001ff107807ULL, 0x000fe20001000000ULL, 0x0000001836367220ULL, 0x084fe20000410000ULL,
0x0000001837377220ULL, 0x080fe20000410000ULL, 0x000000183a3a7220ULL, 0x080fe20000410000ULL,
0x000000183b3b7220ULL, 0x080fe20000410000ULL, 0x000000183e3e7220ULL, 0x080fe20000410000ULL,
0x000000183f3f7220ULL, 0x080fe20000410000ULL, 0x0000001842427220ULL, 0x080fe20000410000ULL,
0x0000001843437220ULL, 0x080fe20000410000ULL, 0x000000184a4a7220ULL, 0x080fe20000410000ULL,
0x000000184b4b7220ULL, 0x080fe20000410000ULL, 0x0000001846467220ULL, 0x080fe20000410000ULL,
0x0000001847477220ULL, 0x080fe20000410000ULL, 0x0000001832327220ULL, 0x080fe20000410000ULL,
0x0000001833337220ULL, 0x080fe20000410000ULL, 0x0000001816167220ULL, 0x080fe20000410000ULL,
0x0000001817177220ULL, 0x000fe20000410000ULL, 0x0000007554752220ULL, 0x008fe20000410000ULL,
0x000080400000791aULL, 0x00cfc80000000000ULL, 0x000000002828783bULL, 0x000fe20000000200ULL,
0x00000054ff11723eULL, 0x000fe200000010ffULL, 0x0000005c755c7221ULL, 0x000fe20000010000ULL,
0x00000002ff777819ULL, 0x000fe2000001160fULL, 0x000000000958783bULL, 0x000fe20000004200ULL,
0x0000541011767816ULL, 0x000fe40000000011ULL, 0x0000b00005117811ULL, 0x000fe200078e20ffULL,
0x00000000074c783bULL, 0x000fe20000004200ULL, 0x0000991010187816ULL, 0x000fc600000000ffULL,
0x000000000850783bULL, 0x000fe20000004200ULL, 0x000000ff1800720cULL, 0x000fc60003f25270ULL,
0x00000000062c783bULL, 0x000fe80000004200ULL, 0x00001f7776777589ULL, 0x000e6800000e0000ULL,
0x00001f0a76747589ULL, 0x000ea800000e0000ULL, 0x000000001110783bULL, 0x000ee80000000200ULL,
0x000000000424783bULL, 0x000f280000004200ULL, 0x00000000021c783bULL, 0x000f680000004200ULL,
0x000000000320783bULL, 0x000f280000004200ULL, 0x000000000018783bULL, 0x000f220000004200ULL,
0x0000007728289231ULL, 0x002fc400003400ffULL, 0x000000772a2a9231ULL, 0x000fe400003400ffULL,
0x0000007429299231ULL, 0x084fe400003400ffULL, 0x000000742b2b9231ULL, 0x000fce00003400ffULL,
0x000000582834723cULL, 0x040ff00000041834ULL, 0x0000005a2838723cULL, 0x000fe20000041838ULL,
0x0000007710109231ULL, 0x088fe400003400ffULL, 0x0000007712129231ULL, 0x000fc400003400ffULL,
0x0000007411119231ULL, 0x000fc600003400ffULL, 0x0000004c2848723cULL, 0x000fe20000041848ULL,
0x0000007413139231ULL, 0x000fce00003400ffULL, 0x00000050283c723cULL, 0x040ff0000004183cULL,
0x000000522840723cULL, 0x040ff00000041840ULL, 0x0000004e2844723cULL, 0x040ff00000041844ULL,
0x0000002c2830723cULL, 0x040ff00000041830ULL, 0x0000002e2814723cULL, 0x000ff00000041814ULL,
0x000000241034723cULL, 0x050ff00000041834ULL, 0x000000261038723cULL, 0x040ff00000041838ULL,
0x0000001c1048723cULL, 0x060ff00000041848ULL, 0x00000020103c723cULL, 0x040ff0000004183cULL,
0x000000221040723cULL, 0x040ff00000041840ULL, 0x0000001e101c723cULL, 0x040ff00000041844ULL,
0x000000181030723cULL, 0x040ff00000041830ULL, 0x0000001a1024723cULL, 0x000fe20000041814ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000063000008947ULL, 0x000fea0003800000ULL,
0x00000003ff127819ULL, 0x000fe4000001160fULL, 0x0000008071117810ULL, 0x000fe40007ffe0ffULL,
0x0000000412137810ULL, 0x000fe40007ffe0ffULL, 0x0000001168107217ULL, 0x000fe40007800000ULL,
0x0000000f13147212ULL, 0x040fe400078e3cffULL, 0x0000000313177819ULL, 0x000fe200000006ffULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0x0000000812157810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8171a7812ULL, 0x000fe400078ee214ULL, 0x0000000c12177810ULL, 0x040fe20007ffe0ffULL,
0x0000000815227824ULL, 0x000fe200078e00ffULL, 0x0000001012197810ULL, 0x000fe40007ffe0ffULL,
0x0000000f17147212ULL, 0x0c0fe200078e3cffULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0x0000000f15117212ULL, 0x080fe200078e3cffULL, 0x0000000819217824ULL, 0x040fe200078e00ffULL,
0x0000000f19167212ULL, 0x000fc400078e3cffULL, 0xfffffff81b2c7812ULL, 0x000fe400078ee214ULL,
0x00000014121b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee211ULL,
0x0000000460117c24ULL, 0x000fe2000f8e025fULL, 0xfffffff821447812ULL, 0x000fe200078ee216ULL,
0x000000081b237824ULL, 0x000fe200078e00ffULL, 0x0000001c12457810ULL, 0x000fe20007ffe0ffULL,
0x00000010222f7824ULL, 0x000fe200078e020bULL, 0x0000001812217810ULL, 0x000fc40007ffe0ffULL,
0x0000000f1b167212ULL, 0x080fe200078e3cffULL, 0x0000000845587824ULL, 0x000fe200078e00ffULL,
0x0000004011117810ULL, 0x000fe20007ffe0ffULL, 0x0000000821297824ULL, 0x000fe200078e00ffULL,
0xfffffff8234c7812ULL, 0x000fe400078ee216ULL, 0x0000007f12147812ULL, 0x000fe400078ec0ffULL,
0x0000000f45237212ULL, 0x080fe400078e3cffULL, 0x0000002010287817ULL, 0x000fe20003800000ULL,
0x0000000114147824ULL, 0x000fe200078e0211ULL, 0x0000000f21187212ULL, 0x000fc400078e3cffULL,
0x0000007f13167812ULL, 0x000fe400078ec0ffULL, 0x0000007f15207812ULL, 0x000fe400078ec0ffULL,
0x0000007f172a7812ULL, 0x000fe400078ec0ffULL, 0x0000007f192e7812ULL, 0x000fe400078ec0ffULL,
0x0000007f1b467812ULL, 0x000fe200078ec0ffULL, 0x000000012a2a7824ULL, 0x100fe200078e0211ULL,
0x0000007f214e7812ULL, 0x000fe200078ec0ffULL, 0x000000012e2e7824ULL, 0x100fe200078e0211ULL,
0x0000007f45527812ULL, 0x000fe200078ec0ffULL, 0x0000000146467824ULL, 0x000fe200078e0211ULL,
0xfffffff858587812ULL, 0x000fe200078ee223ULL, 0x00000200ff237424ULL, 0x000fe200078e00ffULL,
0x000000281200720cULL, 0x080fe20003f66070ULL, 0x000000014e4e7824ULL, 0x100fe200078e0211ULL,
0xfffffff829507812ULL, 0x000fe200078ee218ULL, 0x0000000116187824ULL, 0x000fe200078e0211ULL,
0x0000000712127812ULL, 0x000fe200078e480fULL, 0x0000000152527824ULL, 0x000fe200078e0211ULL,
0x0000001120207210ULL, 0x000fe20007ffe0ffULL, 0x00005e0014107625ULL, 0x000fe200078e0023ULL,
0x000000281300720cULL, 0x000fc40003fc6070ULL, 0x0ffffff812167812ULL, 0x000fe200078ef80fULL,
0x00005e0018127625ULL, 0x000fe200078e0023ULL, 0x000000281500720cULL, 0x080fe40003fa6070ULL,
0x0000000b1a2d7211ULL, 0x000fe200078e20ffULL, 0x0000000867297824ULL, 0x000fe200078e020cULL,
0x000000281700720cULL, 0x080fe20003f46070ULL, 0x00005e0020147625ULL, 0x000fe200078e0023ULL,
0x000000281900720cULL, 0x000fc60003f86070ULL, 0x00000010162b7824ULL, 0x000fe400078e020bULL,
0x0000001029107825ULL, 0x000fc800078e0010ULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102b7faeULL, 0x0003e2000d901c46ULL,
0x000000281b00720cULL, 0x080fe40003f66070ULL, 0x0000001029147825ULL, 0x000fe200078e0014ULL,
0x00000000122d7faeULL, 0x0005e2000f101c46ULL, 0x000000282100720cULL, 0x080fe40003fc6070ULL,
0x00005e002a167625ULL, 0x000fe200078e0023ULL, 0x00000000142f7faeULL, 0x0007e2000e901c46ULL,
0x000000284500720cULL, 0x000fc40003fa6070ULL, 0x00005e002e187625ULL, 0x000fc800078e0023ULL,
0x00005e00461a7625ULL, 0x000fc800078e0023ULL, 0x00005e004e207625ULL, 0x000fc800078e0023ULL,
0x00005e0052227625ULL, 0x000fc800078e0023ULL, 0x0000001029167825ULL, 0x000fc800078e0016ULL,
0x000000102c117824ULL, 0x002fe400078e020bULL, 0x0000001029187825ULL, 0x000fc600078e0018ULL,
0x0000000016117faeULL, 0x0003e2000d101c46ULL, 0x0000001044137824ULL, 0x004fe400078e020bULL,
0x00000010291a7825ULL, 0x000fc600078e001aULL, 0x0000000018137faeULL, 0x0003e2000e101c46ULL,
0x0000001029207825ULL, 0x000fc800078e0020ULL, 0x0000001029227825ULL, 0x000fc800078e0022ULL,
0x000000104c157824ULL, 0x108fe400078e020bULL, 0x0000001050297824ULL, 0x100fe400078e020bULL,
0x00000010582b7824ULL, 0x000fe200078e020bULL, 0x000000001a157faeULL, 0x0003e8000d901c46ULL,
0x0000000020297faeULL, 0x0003e8000f101c46ULL, 0x00000000222b7faeULL, 0x0003e2000e901c46ULL,
0x0000056000007947ULL, 0x000fea0003800000ULL, 0x00000003ff107819ULL, 0x000fe2000001160fULL,
0x00000200ff227424ULL, 0x000fc400078e00ffULL, 0x0000000867297824ULL, 0x000fe200078e020cULL,
0x00000008101a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000410167810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1a127212ULL, 0x0c0fe200078e3cffULL, 0x000000081a157824ULL, 0x000fe200078e00ffULL,
0x00000010102c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000816187824ULL, 0x040fe200078e00ffULL,
0x0000000f16117212ULL, 0x000fe400078e3cffULL, 0x0000000c10287810ULL, 0x000fc40007ffe0ffULL,
0x00000018104c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff815207812ULL, 0x000fe200078ee212ULL,
0x000000082c157824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee211ULL,
0x0000000460117c24ULL, 0x000fe2000f8e025fULL, 0x0000001410447810ULL, 0x000fe20007ffe0ffULL,
0x000000084c177824ULL, 0x000fe200078e00ffULL, 0x0000000f2c127212ULL, 0x080fe200078e3cffULL,
0x00000010202f7824ULL, 0x000fe200078e020bULL, 0x0000000f28137212ULL, 0x000fe200078e3cffULL,
0x0000000844467824ULL, 0x000fe200078e00ffULL, 0x00000003282a7819ULL, 0x000fc400000006ffULL,
0x0000000f4c147212ULL, 0x080fe400078e3cffULL, 0xfffffff8152e7812ULL, 0x000fe400078ee212ULL,
0xfffffff82a2a7812ULL, 0x000fe400078ee213ULL, 0x0000004011127810ULL, 0x000fe40007ffe0ffULL,
0x0000000f44137212ULL, 0x000fe400078e3cffULL, 0x0000007f10117812ULL, 0x000fc400078ec0ffULL,
0xfffffff8174e7812ULL, 0x000fe400078ee214ULL, 0x0000000710147812ULL, 0x040fe200078e480fULL,
0x0000000111117824ULL, 0x000fe200078e0212ULL, 0x0000001c10107810ULL, 0x000fe20007ffe0ffULL,
0x000000104e457824ULL, 0x000fe200078e020bULL, 0xfffffff846467812ULL, 0x000fe400078ee213ULL,
0x0000007f16137812ULL, 0x000fe200078ec0ffULL, 0x00000008102d7824ULL, 0x000fe200078e00ffULL,
0x0000007f1a157812ULL, 0x000fc400078ec0ffULL, 0x0000007f28177812ULL, 0x000fe400078ec0ffULL,
0x0000007f2c197812ULL, 0x000fe200078ec0ffULL, 0x0000000115157824ULL, 0x100fe200078e0212ULL,
0x0000007f441b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x100fe200078e0212ULL,
0x0000007f4c217812ULL, 0x000fe200078ec0ffULL, 0x0000000119197824ULL, 0x100fe200078e0212ULL,
0x0000007f10237812ULL, 0x040fe200078ec0ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0212ULL,
0x0000000f10167212ULL, 0x000fe200078e3cffULL, 0x00005e0011107625ULL, 0x000fe200078e0022ULL,
0x0ffffff814147812ULL, 0x000fc400078ef80fULL, 0x0000001213137210ULL, 0x000fe20007ffe0ffULL,
0x0000000121217824ULL, 0x000fe200078e0212ULL, 0xfffffff82d287812ULL, 0x000fe200078ee216ULL,
0x0000000123237824ULL, 0x000fe400078e0212ULL, 0x00000010142b7824ULL, 0x100fe400078e020bULL,
0x00000010182d7824ULL, 0x000fe400078e020bULL, 0x00005e0013127625ULL, 0x000fc800078e0022ULL,
0x0000001029107825ULL, 0x000fc800078e0010ULL, 0x00005e0015147625ULL, 0x080fe200078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102b7faeULL, 0x0003e6000b901c46ULL,
0x00005e0017167625ULL, 0x000fc800078e0022ULL, 0x00005e0019187625ULL, 0x000fc800078e0022ULL,
0x00005e001b1a7625ULL, 0x000fc800078e0022ULL, 0x00005e0021207625ULL, 0x000fc800078e0022ULL,
0x00005e0023227625ULL, 0x000fc800078e0022ULL, 0x0000001029127825ULL, 0x000fc800078e0012ULL,
0x0000001029147825ULL, 0x040fe200078e0014ULL, 0x00000000122d7faeULL, 0x0005e6000b901c46ULL,
0x0000001029107825ULL, 0x042fe200078e0016ULL, 0x0000000b2a177211ULL, 0x000fe200078e20ffULL,
0x00000000142f7faeULL, 0x0005e4000b901c46ULL, 0x0000001029187825ULL, 0x040fe400078e0018ULL,
0x0000000010177faeULL, 0x0005e4000b901c46ULL, 0x00000010291a7825ULL, 0x000fc800078e001aULL,
0x0000001029207825ULL, 0x000fc800078e0020ULL, 0x0000001029227825ULL, 0x000fc800078e0022ULL,
0x000000102e297824ULL, 0x100fe400078e020bULL, 0x00000010462b7824ULL, 0x100fe400078e020bULL,
0x0000001028477824ULL, 0x000fe200078e020bULL, 0x0000000018297faeULL, 0x0005e8000b901c46ULL,
0x000000001a2b7faeULL, 0x0005e8000b901c46ULL, 0x0000000020457faeULL, 0x0005e8000b901c46ULL,
0x0000000022477faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000b00070287811ULL, 0x000fc400078e20ffULL, 0x00000054ff10723eULL, 0x004fe400000010ffULL,
0x00000002ff757819ULL, 0x000fe4000001160fULL, 0x0000541010767816ULL, 0x000fe40000000010ULL,
0x0000b0006b147811ULL, 0x000fc600078e20ffULL, 0x00001f7576757589ULL, 0x000fe800000e0000ULL,
0x00001f0a76747589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002828783bULL, 0x002e680000000200ULL, 0x000000006d4c783bULL, 0x000ea80000004200ULL,
0x000000006f58783bULL, 0x000fe80000004200ULL, 0x000000006e50783bULL, 0x000fe80000004200ULL,
0x000000006c2c783bULL, 0x000fe80000004200ULL, 0x000000001414783bULL, 0x000ee80000000200ULL,
0x000000006344783bULL, 0x000f280000004200ULL, 0x000000006a20783bULL, 0x000f680000004200ULL,
0x000000006518783bULL, 0x000f280000004200ULL, 0x000000006210783bULL, 0x000f220000004200ULL,
0x0000007528289231ULL, 0x002fc400003400ffULL, 0x000000752a2a9231ULL, 0x000fe400003400ffULL,
0x0000007429299231ULL, 0x080fe400003400ffULL, 0x000000742b2b9231ULL, 0x000fce00003400ffULL,
0x0000004c2848723cULL, 0x004fe20000041848ULL, 0x0000007514149231ULL, 0x008fce00003400ffULL,
0x000000582834723cULL, 0x000fe20000041834ULL, 0x0000007516169231ULL, 0x000fe400003400ffULL,
0x0000007415159231ULL, 0x080fe400003400ffULL, 0x0000007417179231ULL, 0x000fc600003400ffULL,
0x0000005a2838723cULL, 0x040ff00000041838ULL, 0x00000050283c723cULL, 0x040ff0000004183cULL,
0x000000522840723cULL, 0x040ff00000041840ULL, 0x0000004e281c723cULL, 0x040ff0000004181cULL,
0x0000002c2830723cULL, 0x040ff00000041830ULL, 0x0000002e2824723cULL, 0x000ff00000041824ULL,
0x000000441448723cULL, 0x050ff00000041848ULL, 0x000000201434723cULL, 0x060ff00000041834ULL,
0x000000221438723cULL, 0x040ff00000041838ULL, 0x00000018143c723cULL, 0x040ff0000004183cULL,
0x0000001a1440723cULL, 0x040ff00000041840ULL, 0x000000461444723cULL, 0x040ff0000004181cULL,
0x000000101430723cULL, 0x040ff00000041830ULL, 0x000000121414723cULL, 0x000fe20000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008071117810ULL, 0x000fe20007ffe0ffULL,
0x01463000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000681100720cULL, 0x000fda0003f26070ULL,
0x000022e000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000063000008947ULL, 0x000fea0003800000ULL, 0x00000003ff117819ULL, 0x000fe2000001160fULL,
0x0000000460607c24ULL, 0x000fe2000f8e025fULL, 0x000000a071717810ULL, 0x000fe40007ffe0ffULL,
0x0000000411197810ULL, 0x040fe40007ffe0ffULL, 0x00000008111a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f19127212ULL, 0x040fe200078e3cffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x0000000c111c7810ULL, 0x040fe20007ffe0ffULL, 0x000000081a277824ULL, 0x000fe200078e00ffULL,
0x00000010111e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0x0000001411227810ULL, 0x040fe40007ffe0ffULL,
0x0000007168107217ULL, 0x000fe40007800000ULL, 0x0000000f1a127212ULL, 0x080fe200078e3cffULL,
0x00000008224f7824ULL, 0x000fe200078e00ffULL, 0x0000000f1c137212ULL, 0x000fe200078e3cffULL,
0x0000000110107824ULL, 0x000fe200078e0a71ULL, 0x0000001811247810ULL, 0x000fc40007ffe0ffULL,
0x0000000f1e187212ULL, 0x0c0fe400078e3cffULL, 0x000000031e2f7819ULL, 0x000fe200000006ffULL,
0x0000000824537824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe400078ee212ULL,
0x0000000f22127212ULL, 0x000fe400078e3cffULL, 0xfffffff8202b7812ULL, 0x000fe200078ee213ULL,
0x00000200ff207424ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee218ULL,
0x0000001027277824ULL, 0x100fe200078e0272ULL, 0x0000006060607810ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0272ULL, 0x0000007f11137812ULL, 0x000fc400078ec0ffULL,
0x0000000f24187212ULL, 0x080fe400078e3cffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee212ULL,
0x0000000113137824ULL, 0x000fe200078e0260ULL, 0x0000002010127817ULL, 0x000fe40003800000ULL,
0x0000001c11267810ULL, 0x000fe20007ffe0ffULL, 0x000000104f4f7824ULL, 0x000fe200078e0272ULL,
0x0000007f191b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff853537812ULL, 0x000fe200078ee218ULL,
0x0000000826287824ULL, 0x000fe200078e00ffULL, 0x0000007f1c237812ULL, 0x000fe200078ec0ffULL,
0x000000011b1d7824ULL, 0x000fe200078e0260ULL, 0x0000000711187812ULL, 0x000fe200078e480fULL,
0x0000001053537824ULL, 0x000fe200078e0272ULL, 0x000000121100720cULL, 0x000fe20003fc6070ULL,
0x00005e0013107625ULL, 0x000fe200078e0020ULL, 0x0000000f261b7212ULL, 0x000fc400078e3cffULL,
0x0ffffff818137812ULL, 0x000fe200078ef80fULL, 0x0000000123297824ULL, 0x000fe200078e0260ULL,
0x0000007f1a217812ULL, 0x000fe200078ec0ffULL, 0x0000000867237824ULL, 0x000fe200078e020cULL,
0xfffffff8285b7812ULL, 0x000fe200078ee21bULL, 0x00000010131b7824ULL, 0x000fe200078e0272ULL,
0x0000007f1e257812ULL, 0x000fe200078ec0ffULL, 0x0000001023107825ULL, 0x000fe200078e0010ULL,
0x0000007f224d7812ULL, 0x000fe400078ec0ffULL, 0x0000007f24517812ULL, 0x000fe200078ec0ffULL,
0x0000000121217824ULL, 0x100fe200078e0260ULL, 0x0000007f26597812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101b7faeULL, 0x0003e2000f101c46ULL,
0x000000121900720cULL, 0x080fe20003fa6070ULL, 0x00000001252d7824ULL, 0x100fe200078e0260ULL,
0x000000121a00720cULL, 0x080fe20003f86070ULL, 0x000000014d4d7824ULL, 0x000fe200078e0260ULL,
0x000000121c00720cULL, 0x000fe20003f66070ULL, 0x00005e0021187625ULL, 0x000fe200078e0020ULL,
0x000000121e00720cULL, 0x000fc40003f46070ULL, 0x000000122200720cULL, 0x080fe20003f26070ULL,
0x0000000159597824ULL, 0x000fe200078e0260ULL, 0x000000122400720cULL, 0x000fe20003f06070ULL,
0x00005e0029107625ULL, 0x002fe200078e0020ULL, 0x000000122600720cULL, 0x000fe40003fc6070ULL,
0x0000006051517210ULL, 0x000fe20007ffe0ffULL, 0x00005e001d127625ULL, 0x000fe200078e0020ULL,
0x000000722f2f7211ULL, 0x000fc600078e20ffULL, 0x00005e002d1a7625ULL, 0x000fc800078e0020ULL,
0x000000101f257824ULL, 0x000fe400078e0272ULL, 0x00005e004d1c7625ULL, 0x000fc800078e0020ULL,
0x00005e00511e7625ULL, 0x000fc800078e0020ULL, 0x00005e0059207625ULL, 0x000fc800078e0020ULL,
0x0000001023127825ULL, 0x000fc800078e0012ULL, 0x0000001023187825ULL, 0x040fe200078e0018ULL,
0x0000000012257faeULL, 0x0003e6000e901c46ULL, 0x0000001023107825ULL, 0x040fe200078e0010ULL,
0x0000000018277faeULL, 0x0003e6000e101c46ULL, 0x00000010231a7825ULL, 0x040fe200078e001aULL,
0x00000000102b7faeULL, 0x0003e6000d901c46ULL, 0x00000010231c7825ULL, 0x040fe200078e001cULL,
0x000000001a2f7faeULL, 0x0003e6000d101c46ULL, 0x00000010231e7825ULL, 0x000fe200078e001eULL,
0x000000001c4f7faeULL, 0x0003e6000c901c46ULL, 0x000000105b5b7824ULL, 0x000fe200078e0272ULL,
0x000000001e537faeULL, 0x0003e2000c101c46ULL, 0x0000001023207825ULL, 0x000fca00078e0020ULL,
0x00000000205b7faeULL, 0x0003e2000f101c46ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x00000003ff107819ULL, 0x000fe2000001160fULL, 0x0000000460607c24ULL, 0x000fe4000f8e025fULL,
0x0000000867257824ULL, 0x000fe200078e020cULL, 0x0000000410187810ULL, 0x040fe40007ffe0ffULL,
0x0000000c101c7810ULL, 0x040fe40007ffe0ffULL, 0x00000008101a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008181e7824ULL, 0x040fe200078e00ffULL, 0x0000000f18117212ULL, 0x080fe200078e3cffULL,
0x000000081c207824ULL, 0x040fe200078e00ffULL, 0x0000000f1c137212ULL, 0x000fe200078e3cffULL,
0x000000081a1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1b7812ULL, 0x000fc400078ee211ULL,
0xfffffff820237812ULL, 0x000fe400078ee213ULL, 0x00000010101e7810ULL, 0x040fe40007ffe0ffULL,
0x0000001410207810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1a127212ULL, 0x080fe200078e3cffULL,
0x000000081e227824ULL, 0x040fe200078e00ffULL, 0x0000000f1e117212ULL, 0x000fe200078e3cffULL,
0x0000000820517824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fc400078ee212ULL,
0x0000000f20127212ULL, 0x080fe400078e3cffULL, 0x0000001810247810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8224d7812ULL, 0x000fe200078ee211ULL, 0x00000200ff227424ULL, 0x000fe200078e00ffULL,
0xfffffff851517812ULL, 0x000fe400078ee212ULL, 0x0000000710127812ULL, 0x040fe200078e480fULL,
0x000000104d4d7824ULL, 0x100fe200078e0272ULL, 0x0000007f10117812ULL, 0x000fe200078ec0ffULL,
0x0000001051517824ULL, 0x000fe200078e0272ULL, 0x0000000f24137212ULL, 0x000fc400078e3cffULL,
0x0000000324267819ULL, 0x000fe400000006ffULL, 0x0000001c10107810ULL, 0x000fe40007ffe0ffULL,
0x0000006060607810ULL, 0x000fe40007ffe0ffULL, 0x0000007f18197812ULL, 0x000fe200078ec0ffULL,
0x0000000810617824ULL, 0x000fe200078e00ffULL, 0x0000007f1a1d7812ULL, 0x000fe200078ec0ffULL,
0x0000000111117824ULL, 0x100fe200078e0260ULL, 0xfffffff826597812ULL, 0x000fe200078ee213ULL,
0x0000000119197824ULL, 0x100fe200078e0260ULL, 0x0000007f1c217812ULL, 0x000fe200078ec0ffULL,
0x000000011d1d7824ULL, 0x000fe200078e0260ULL, 0x0000007f1e277812ULL, 0x000fc400078ec0ffULL,
0x0ffffff812137812ULL, 0x000fe200078ef80fULL, 0x0000000121217824ULL, 0x100fe200078e0260ULL,
0x0000007f20297812ULL, 0x000fe200078ec0ffULL, 0x00000001272f7824ULL, 0x000fe200078e0260ULL,
0x0000000f10127212ULL, 0x000fe200078e3cffULL, 0x0000001013277824ULL, 0x000fe200078e0272ULL,
0x0000007f242b7812ULL, 0x000fe400078ec0ffULL, 0x0000007f102d7812ULL, 0x000fe200078ec0ffULL,
0x00005e0011107625ULL, 0x000fe200078e0022ULL, 0x00000060294f7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff861617812ULL, 0x000fe200078ee212ULL, 0x00005e0019127625ULL, 0x000fe200078e0022ULL,
0x0000007259597211ULL, 0x000fc600078e20ffULL, 0x000000012b537824ULL, 0x000fe400078e0260ULL,
0x000000101b297824ULL, 0x000fe400078e0272ULL, 0x00005e001d187625ULL, 0x000fc800078e0022ULL,
0x000000012d5b7824ULL, 0x000fe400078e0260ULL, 0x00005e00211a7625ULL, 0x000fc800078e0022ULL,
0x000000101f2b7824ULL, 0x000fe400078e0272ULL, 0x00005e002f1c7625ULL, 0x000fc800078e0022ULL,
0x00005e004f1e7625ULL, 0x000fc800078e0022ULL, 0x0000001025107825ULL, 0x000fc800078e0010ULL,
0x00000010232d7824ULL, 0x000fe200078e0272ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010277faeULL, 0x0003e2000b901c46ULL, 0x00005e0053207625ULL, 0x000fc800078e0022ULL,
0x00005e005b227625ULL, 0x000fc800078e0022ULL, 0x0000001025127825ULL, 0x000fc800078e0012ULL,
0x0000001025187825ULL, 0x040fe200078e0018ULL, 0x0000000012297faeULL, 0x0003e6000b901c46ULL,
0x00000010251a7825ULL, 0x040fe200078e001aULL, 0x00000000182b7faeULL, 0x0003e6000b901c46ULL,
0x00000010251c7825ULL, 0x040fe200078e001cULL, 0x000000001a2d7faeULL, 0x0003e6000b901c46ULL,
0x00000010251e7825ULL, 0x040fe200078e001eULL, 0x000000001c4d7faeULL, 0x0003e6000b901c46ULL,
0x0000001025207825ULL, 0x000fe200078e0020ULL, 0x000000001e517faeULL, 0x0003e6000b901c46ULL,
0x0000001061617824ULL, 0x000fe200078e0272ULL, 0x0000000020597faeULL, 0x0003e2000b901c46ULL,
0x0000001025227825ULL, 0x000fca00078e0022ULL, 0x0000000022617faeULL, 0x0003e4000b901c46ULL,
0x0000000156567824ULL, 0x000fe200078e0273ULL, 0x01463c00ff127984ULL, 0x002e620000000800ULL,
0x00000300ff107624ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe200078e00ffULL,
0x0000000156117812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff10107811ULL, 0x000fe400078e08ffULL, 0x000000011100780cULL, 0x000fc80003f05070ULL,
0x0000000110617807ULL, 0x000fca0004000000ULL, 0x0000000156617824ULL, 0x000fca00078e0261ULL,
0x000000666100720cULL, 0x000fda0003f06070ULL, 0x0000000161108824ULL, 0x000fe400078e025dULL,
0x00000004ff118424ULL, 0x000fc800078e00ffULL, 0x0000600010108625ULL, 0x000fca00078e0011ULL,
0x0000000610608981ULL, 0x000562000c1e1900ULL, 0x800000000d137824ULL, 0x000fca00078e00ffULL,
0x8000000012ff7812ULL, 0x002fe20007804813ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x0000001f0d117819ULL, 0x004fe200000006ffULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01463c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0141800055117984ULL, 0x004e620000000800ULL, 0x00000001ff107424ULL, 0x000fe200078e00ffULL,
0x0000b8000e287811ULL, 0x000fc800078e20ffULL, 0x00007610100e7816ULL, 0x000fe4000000000eULL,
0x0000005e1100720bULL, 0x002fda0003f1d000ULL, 0x00000000000d7806ULL, 0x000fc800000e0100ULL,
0x0000ffff0d137812ULL, 0x000fe4000780c0ffULL, 0x01438000550d7984ULL, 0x0002b60000000800ULL,
0x0000034000008947ULL, 0x000fea0003800000ULL, 0x0000005e1100720bULL, 0x002fe40003f14000ULL,
0x000000115e107209ULL, 0x000fc40007810000ULL, 0x00000002ff1a7819ULL, 0x000fc6000001160fULL,
0x800000105e0e7221ULL, 0x040fe20000010000ULL, 0x000000115e5e7209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b0e127820ULL, 0x000fe40000410000ULL, 0x00000000000e7806ULL, 0x000fe400000e0100ULL,
0x0000001200197308ULL, 0x000e620000000800ULL, 0x000000036700780cULL, 0x000fe40003f05270ULL,
0x0000ffff0e187812ULL, 0x000fc800078e3cffULL, 0x0000001813ff7212ULL, 0x000fce000782c0ffULL,
0x0145801055008388ULL, 0x000fe20000000800ULL, 0x000000195c5c7220ULL, 0x002fc60000410000ULL,
0x00001f1a190e7589ULL, 0x000e6400000e0000ULL, 0x8000001011181221ULL, 0x000fe40000010000ULL,
0x00001f0a19137589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b18181820ULL, 0x000fc80000410000ULL,
0x0000001800541308ULL, 0x000f220000000800ULL, 0x0000000e34347220ULL, 0x082fe20000410000ULL,
0x0000000e35357220ULL, 0x080fe20000410000ULL, 0x0000000e38387220ULL, 0x080fe20000410000ULL,
0x0000000e39397220ULL, 0x080fe20000410000ULL, 0x0000000e3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000e3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000e40407220ULL, 0x080fe20000410000ULL,
0x0000000e41417220ULL, 0x080fe20000410000ULL, 0x0000000e48487220ULL, 0x080fe20000410000ULL,
0x0000000e49497220ULL, 0x080fe20000410000ULL, 0x0000000e44447220ULL, 0x080fe20000410000ULL,
0x0000000e45457220ULL, 0x080fe20000410000ULL, 0x0000000e30307220ULL, 0x080fe20000410000ULL,
0x0000000e31317220ULL, 0x080fe20000410000ULL, 0x0000000e14147220ULL, 0x080fe20000410000ULL,
0x0000000e15157220ULL, 0x000fe20000410000ULL, 0x00000001ff0e7807ULL, 0x000fe20000800000ULL,
0x0000001336367220ULL, 0x088fe20000410000ULL, 0x0000001337377220ULL, 0x080fe20000410000ULL,
0x000000133a3a7220ULL, 0x080fe20000410000ULL, 0x000000133b3b7220ULL, 0x080fe20000410000ULL,
0x000000133e3e7220ULL, 0x080fe20000410000ULL, 0x000000133f3f7220ULL, 0x080fe20000410000ULL,
0x0000001342427220ULL, 0x080fe20000410000ULL, 0x0000001343437220ULL, 0x080fe20000410000ULL,
0x000000134a4a7220ULL, 0x080fe20000410000ULL, 0x000000134b4b7220ULL, 0x080fe20000410000ULL,
0x0000001346467220ULL, 0x080fe20000410000ULL, 0x0000001347477220ULL, 0x080fe20000410000ULL,
0x0000001332327220ULL, 0x080fe20000410000ULL, 0x0000001333337220ULL, 0x080fe20000410000ULL,
0x0000001316167220ULL, 0x080fe20000410000ULL, 0x0000001317177220ULL, 0x000fe20000410000ULL,
0x0000000d540d1220ULL, 0x014fe20000410000ULL, 0x000080400000791aULL, 0x002fc80000000000ULL,
0x000000002810783bULL, 0x000fe20000000200ULL, 0x00000054ff20723eULL, 0x000fe200000010ffULL,
0x0000005c0d5c7221ULL, 0x004fe20000010000ULL, 0x00000002ff557819ULL, 0x000fe2000001160fULL,
0x00000000081c783bULL, 0x0003e20000004200ULL, 0x0000b80005057811ULL, 0x000fe400078e20ffULL,
0x000099100e0e7816ULL, 0x000fe200000000ffULL, 0x000000000918783bULL, 0x000fe60000004200ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x000000000624783bULL, 0x000fe20000004200ULL,
0x0000541020087816ULL, 0x002fc60000000020ULL, 0x000000000720783bULL, 0x000fe80000004200ULL,
0x00001f5508557589ULL, 0x000e6800000e0000ULL, 0x00001f0a08567589ULL, 0x000ea800000e0000ULL,
0x000000000528783bULL, 0x000ee80000000200ULL, 0x00000000042c783bULL, 0x000f280000004200ULL,
0x00000000034c783bULL, 0x000f280000004200ULL, 0x000000000250783bULL, 0x000f280000004200ULL,
0x000000000058783bULL, 0x0005220000004200ULL, 0x0000005510108231ULL, 0x002fc400003400ffULL,
0x0000005512128231ULL, 0x000fe400003400ffULL, 0x0000005611118231ULL, 0x084fe400003400ffULL,
0x0000005613138231ULL, 0x000fe200003400ffULL, 0x0000030069007a10ULL, 0x000fc80007ffe0ffULL,
0x0000000100037810ULL, 0x000fe40007ffe0ffULL, 0x000000181034723cULL, 0x000fe40000041834ULL,
0x000000640300720cULL, 0x000fcc0003f26070ULL, 0x0000001c103c723cULL, 0x000fe2000004183cULL,
0x0000005528288231ULL, 0x088fe400003400ffULL, 0x000000552a2a8231ULL, 0x000fe400003400ffULL,
0x0000005629298231ULL, 0x000fc600003400ffULL, 0x000000201048723cULL, 0x000fe20000041848ULL,
0x000000562b2b8231ULL, 0x000fce00003400ffULL, 0x0000001a1018723cULL, 0x040ff00000041838ULL,
0x0000001e101c723cULL, 0x040ff00000041840ULL, 0x000000221020723cULL, 0x040ff00000041844ULL,
0x000000241030723cULL, 0x040ff00000041830ULL, 0x000000261010723cULL, 0x000ff00000041814ULL,
0x0000002c2834723cULL, 0x050ff00000041834ULL, 0x0000002e2818723cULL, 0x040ff00000041818ULL,
0x0000004c283c723cULL, 0x040ff0000004183cULL, 0x0000004e281c723cULL, 0x040ff0000004181cULL,
0x000000502848723cULL, 0x040ff00000041848ULL, 0x000000522820723cULL, 0x040ff00000041820ULL,
0x000000582830723cULL, 0x040ff00000041830ULL, 0x0000005a2810723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000062000009947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fe2000001160fULL, 0x0000010000037824ULL, 0x000fe400078e00ffULL,
0x0000000867177824ULL, 0x000fe200078e020cULL, 0x0000000802077810ULL, 0x040fe40007ffe0ffULL,
0x0000001002257810ULL, 0x000fe40007ffe0ffULL, 0x0000000f07047212ULL, 0x040fe200078e3cffULL,
0x00000008070d7824ULL, 0x000fe200078e00ffULL, 0x0000000368007217ULL, 0x000fc40007800000ULL,
0x0000000402057810ULL, 0x040fe40007ffe0ffULL, 0xfffffff80d167812ULL, 0x000fe200078ee204ULL,
0x00000008250d7824ULL, 0x040fe200078e00ffULL, 0x0000000c02097810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a03ULL, 0x0000000f25047212ULL, 0x080fe200078e3cffULL,
0x00000008050e7824ULL, 0x040fe200078e00ffULL, 0x0000000f05037212ULL, 0x000fe200078e3cffULL,
0x0000000809267824ULL, 0x000fe200078e00ffULL, 0x0000001402277810ULL, 0x000fc40007ffe0ffULL,
0x0000001802297810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80d2a7812ULL, 0x000fe400078ee204ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000000829157824ULL, 0x000fe200078e00ffULL,
0x0000000f27067212ULL, 0x0c0fe400078e3cffULL, 0x00000003270d7819ULL, 0x000fe400000006ffULL,
0x0000000f09037212ULL, 0x000fc400078e3cffULL, 0xfffffff80d2e7812ULL, 0x000fe400078ee206ULL,
0x0000001c022b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff826267812ULL, 0x000fe200078ee203ULL,
0x0000000460037c24ULL, 0x020fe2000f8e025fULL, 0x0000000f29087212ULL, 0x000fe200078e3cffULL,
0x000000082b427824ULL, 0x000fe200078e00ffULL, 0x0000007f02047812ULL, 0x000fe400078ec0ffULL,
0x0000007f05067812ULL, 0x000fc400078ec0ffULL, 0x0000007f07147812ULL, 0x000fe200078ec0ffULL,
0x0000000103047824ULL, 0x000fe200078e0204ULL, 0x0000007f09247812ULL, 0x000fe400078ec0ffULL,
0x0000007f25287812ULL, 0x000fe200078ec0ffULL, 0x0000000103147824ULL, 0x000fe200078e0214ULL,
0x0000007f272c7812ULL, 0x000fe200078ec0ffULL, 0x0000000103247824ULL, 0x000fe200078e0224ULL,
0x0000007f2b407812ULL, 0x000fe200078ec0ffULL, 0x0000000103287824ULL, 0x040fe200078e0228ULL,
0x0000002000007817ULL, 0x000fe20003800000ULL, 0x00000001032c7824ULL, 0x000fe200078e022cULL,
0xfffffff8153a7812ULL, 0x000fe200078ee208ULL, 0x0000000103087824ULL, 0x000fe200078e0206ULL,
0x0000007f29387812ULL, 0x000fe200078ec0ffULL, 0x00000200ff157424ULL, 0x000fe200078e00ffULL,
0x0000000702067812ULL, 0x040fe200078e480fULL, 0x0000000103407824ULL, 0x040fe200078e0240ULL,
0x000000000200720cULL, 0x000fe20003fc6070ULL, 0x000000103a2d7824ULL, 0x000fe200078e020bULL,
0x0000003803387210ULL, 0x000fe20007ffe0ffULL, 0x00005e0004027625ULL, 0x000fe200078e0015ULL,
0x000000000500720cULL, 0x000fc40003f26070ULL, 0x0ffffff806067812ULL, 0x000fe200078ef80fULL,
0x00005e0008047625ULL, 0x000fe200078e0015ULL, 0x0000000f2b0d7212ULL, 0x000fe400078e3cffULL,
0x000000000900720cULL, 0x080fe20003f66070ULL, 0x0000001006097824ULL, 0x000fe200078e020bULL,
0xfffffff842427812ULL, 0x000fe200078ee20dULL, 0x0000001017027825ULL, 0x000fe200078e0002ULL,
0x000000000700720cULL, 0x080fe40003f46070ULL, 0x000000002500720cULL, 0x080fe20003f86070ULL,
0x000000100e0d7824ULL, 0x000fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000f101c46ULL, 0x0000001017047825ULL, 0x000fe200078e0004ULL,
0x000000002700720cULL, 0x000fc40003fa6070ULL, 0x000000002900720cULL, 0x080fe20003fc6070ULL,
0x00005e0014067625ULL, 0x000fe200078e0015ULL, 0x00000000040d7faeULL, 0x0005e2000c901c46ULL,
0x000000002b00720cULL, 0x000fe40003f26070ULL, 0x0000001016257824ULL, 0x000fe200078e020bULL,
0x0000000b2e2b7211ULL, 0x000fe200078e20ffULL, 0x0000001017067825ULL, 0x000fc800078e0006ULL,
0x00005e0024027625ULL, 0x082fe200078e0015ULL, 0x0000000006257faeULL, 0x0003e6000d101c46ULL,
0x00005e0028087625ULL, 0x000fc800078e0015ULL, 0x00005e002c047625ULL, 0x004fc800078e0015ULL,
0x00005e00380c7625ULL, 0x000fc800078e0015ULL, 0x00005e0040147625ULL, 0x000fc800078e0015ULL,
0x0000001026277824ULL, 0x000fe400078e020bULL, 0x0000001017027825ULL, 0x000fc800078e0002ULL,
0x000000102a297824ULL, 0x000fe200078e020bULL, 0x0000000002277faeULL, 0x0003e2000d901c46ULL,
0x0000001017087825ULL, 0x000fc800078e0008ULL, 0x0000001017047825ULL, 0x040fe200078e0004ULL,
0x0000000008297faeULL, 0x0003e6000e101c46ULL, 0x00000010170c7825ULL, 0x040fe200078e000cULL,
0x00000000042b7faeULL, 0x0003e6000e901c46ULL, 0x00000010420b7824ULL, 0x000fe200078e020bULL,
0x000000000c2d7faeULL, 0x0003e2000f101c46ULL, 0x0000001017147825ULL, 0x000fca00078e0014ULL,
0x00000000140b7faeULL, 0x0003e2000c901c46ULL, 0x0000055000007947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001160fULL, 0x00000200ff247424ULL, 0x000fe200078e00ffULL,
0x0000000c67277211ULL, 0x000fe400078e18ffULL, 0x0000000400067810ULL, 0x040fe40007ffe0ffULL,
0x00000008000e7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c00167810ULL, 0x000fe20007ffe0ffULL,
0x0000000806057824ULL, 0x000fe200078e00ffULL, 0x0000001000287810ULL, 0x000fe20007ffe0ffULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0x0000000f06027212ULL, 0x080fe200078e3cffULL,
0x0000000816077824ULL, 0x000fe200078e00ffULL, 0x0000000f0e037212ULL, 0x000fe200078e3cffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x00000014002c7810ULL, 0x000fc40007ffe0ffULL,
0x0000001800387810ULL, 0x000fe40007ffe0ffULL, 0xfffffff805087812ULL, 0x000fe200078ee202ULL,
0x000000082c097824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee203ULL,
0x00000008383a7824ULL, 0x000fe200078e00ffULL, 0x0000000f16027212ULL, 0x080fe200078e3cffULL,
0x00000010082b7824ULL, 0x100fe200078e020bULL, 0x0000000f28037212ULL, 0x080fe200078e3cffULL,
0x00000010142d7824ULL, 0x000fe200078e020bULL, 0x0000000f2c047212ULL, 0x000fc400078e3cffULL,
0x0000000f38057212ULL, 0x080fe400078e3cffULL, 0x0000001c000c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff807267812ULL, 0x000fe400078ee202ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee203ULL,
0x000000080c297824ULL, 0x000fe200078e00ffULL, 0xfffffff8092e7812ULL, 0x000fe200078ee204ULL,
0x0000000460047c24ULL, 0x020fe2000f8e025fULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL,
0x00000010262f7824ULL, 0x000fe200078e020bULL, 0x0000000700027812ULL, 0x000fe200078e480fULL,
0x000000102a397824ULL, 0x100fe200078e020bULL, 0x0000007f00037812ULL, 0x000fe200078ec0ffULL,
0x000000102e3b7824ULL, 0x100fe200078e020bULL, 0x0000007f06057812ULL, 0x000fe200078ec0ffULL,
0x000000103a417824ULL, 0x000fe200078e020bULL, 0x0000007f0e077812ULL, 0x000fe200078ec0ffULL,
0x0000000104037824ULL, 0x000fe200078e0203ULL, 0x0000000f0c067212ULL, 0x000fe200078e3cffULL,
0x0000000104057824ULL, 0x000fe200078e0205ULL, 0x0000007f16097812ULL, 0x000fe200078ec0ffULL,
0x0000000104077824ULL, 0x000fe200078e0207ULL, 0x0ffffff802007812ULL, 0x000fe200078ef80fULL,
0x00005e0003027625ULL, 0x000fe200078e0024ULL, 0x0000007f280d7812ULL, 0x000fc400078ec0ffULL,
0x0000007f2c157812ULL, 0x000fe200078ec0ffULL, 0x0000000104097824ULL, 0x000fe200078e0209ULL,
0x0000007f0c257812ULL, 0x000fe200078ec0ffULL, 0x00000001040d7824ULL, 0x000fe200078e020dULL,
0x0000007f38177812ULL, 0x000fe200078ec0ffULL, 0x0000000104157824ULL, 0x040fe200078e0215ULL,
0xfffffff829067812ULL, 0x000fe200078ee206ULL, 0x0000000104257824ULL, 0x040fe200078e0225ULL,
0x0000001704177210ULL, 0x000fe20007ffe0ffULL, 0x0000001000297824ULL, 0x000fe200078e020bULL,
0x0000000b060b7211ULL, 0x000fe200078e20ffULL, 0x00005e0005047625ULL, 0x000fc800078e0024ULL,
0x00005e0007067625ULL, 0x000fc800078e0024ULL, 0x00005e0009087625ULL, 0x000fc800078e0024ULL,
0x00005e000d0c7625ULL, 0x000fc800078e0024ULL, 0x00005e0015147625ULL, 0x000fc800078e0024ULL,
0x0000001027027825ULL, 0x000fc800078e0002ULL, 0x00005e0017167625ULL, 0x080fe200078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002297faeULL, 0x0003e6000b901c46ULL,
0x00005e0025247625ULL, 0x000fc800078e0024ULL, 0x0000001027047825ULL, 0x000fc800078e0004ULL,
0x0000001027067825ULL, 0x040fe200078e0006ULL, 0x00000000042b7faeULL, 0x0003e6000b901c46ULL,
0x0000001027087825ULL, 0x040fe200078e0008ULL, 0x00000000062d7faeULL, 0x0003e6000b901c46ULL,
0x00000010270c7825ULL, 0x040fe200078e000cULL, 0x00000000082f7faeULL, 0x0003e6000b901c46ULL,
0x0000001027147825ULL, 0x040fe200078e0014ULL, 0x000000000c397faeULL, 0x0003e6000b901c46ULL,
0x0000001027167825ULL, 0x040fe200078e0016ULL, 0x00000000143b7faeULL, 0x0003e6000b901c46ULL,
0x0000001027247825ULL, 0x000fe200078e0024ULL, 0x0000000016417faeULL, 0x0003e8000b901c46ULL,
0x00000000240b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000b80070047811ULL, 0x002fc400078e20ffULL, 0x00000054ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe4000001160fULL, 0x0000541000007816ULL, 0x000fe40000000000ULL,
0x0000b8006b147811ULL, 0x000fc600078e20ffULL, 0x00001f0300037589ULL, 0x000fe800000e0000ULL,
0x00001f0a000a7589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000404783bULL, 0x000e680000000200ULL, 0x000000006e28783bULL, 0x000ea80000004200ULL,
0x000000006d2c783bULL, 0x000fe80000004200ULL, 0x000000006f24783bULL, 0x000fe80000004200ULL,
0x000000006c38783bULL, 0x000fe80000004200ULL, 0x000000001414783bULL, 0x000ee80000000200ULL,
0x000000006540783bULL, 0x000f280000004200ULL, 0x000000006344783bULL, 0x000f680000004200ULL,
0x000000006a50783bULL, 0x000f280000004200ULL, 0x00000000624c783bULL, 0x000f220000004200ULL,
0x0000000304048231ULL, 0x002fc400003400ffULL, 0x0000000306068231ULL, 0x000fe400003400ffULL,
0x0000000a05058231ULL, 0x080fe400003400ffULL, 0x0000000a07078231ULL, 0x000fce00003400ffULL,
0x00000028043c723cULL, 0x004fe2000004183cULL, 0x0000000314148231ULL, 0x008fce00003400ffULL,
0x0000002c0448723cULL, 0x000fe20000041848ULL, 0x0000000316168231ULL, 0x000fe400003400ffULL,
0x0000000a15158231ULL, 0x080fe400003400ffULL, 0x0000000a17178231ULL, 0x000fc600003400ffULL,
0x000000240434723cULL, 0x040ff00000041834ULL, 0x000000260418723cULL, 0x040ff00000041818ULL,
0x0000002a041c723cULL, 0x040ff0000004181cULL, 0x0000002e0420723cULL, 0x040ff00000041820ULL,
0x000000380430723cULL, 0x040ff00000041830ULL, 0x0000003a0410723cULL, 0x000ff00000041810ULL,
0x00000040143c723cULL, 0x050ff0000004183cULL, 0x000000441448723cULL, 0x060ff00000041848ULL,
0x000000501434723cULL, 0x040ff00000041834ULL, 0x000000521438723cULL, 0x040ff00000041818ULL,
0x000000421440723cULL, 0x040ff0000004181cULL, 0x000000461444723cULL, 0x040ff00000041820ULL,
0x0000004c1430723cULL, 0x040ff00000041830ULL, 0x0000004e1414723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01464000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030069697a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff57ff7812ULL, 0x000fc4000780c0ffULL, 0x000000646900720cULL, 0x000fe40003f26070ULL,
0x00000001ff577807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff71b000007947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x000e640000002500ULL,
0x000000640500720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x018000005c007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff277224ULL, 0x000fe200078e005cULL,
0x0000a48000287802ULL, 0x000fe40000000f00ULL, 0x0000a3d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000005c00037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc8000000005cULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000027919ULL, 0x000ee20000000000ULL, 0x0000000803037811ULL, 0x004fe400078ff0ffULL,
0x00000002ff077819ULL, 0x008fc80000011602ULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0700027589ULL, 0x000ee200000e0000ULL, 0x0000003603367220ULL, 0x044fe20000410000ULL,
0x0000003703377220ULL, 0x040fe20000410000ULL, 0x0000003a033a7220ULL, 0x040fe20000410000ULL,
0x0000003b033b7220ULL, 0x040fe20000410000ULL, 0x0000003402347220ULL, 0x048fe20000410000ULL,
0x0000003502357220ULL, 0x040fe20000410000ULL, 0x0000003802387220ULL, 0x040fe20000410000ULL,
0x0000003902397220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x040fe20000410000ULL,
0x0000003d023d7220ULL, 0x040fe20000410000ULL, 0x0000004002407220ULL, 0x040fe20000410000ULL,
0x0000004102417220ULL, 0x040fe20000410000ULL, 0x0000004802487220ULL, 0x040fe20000410000ULL,
0x0000004902497220ULL, 0x040fe20000410000ULL, 0x0000004402447220ULL, 0x040fe20000410000ULL,
0x0000004502457220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x000fe20000410000ULL, 0x0000003e033e7220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000004203427220ULL, 0x040fe20000410000ULL,
0x0000004303437220ULL, 0x040fe20000410000ULL, 0x0000004a034a7220ULL, 0x040fe20000410000ULL,
0x0000004b034b7220ULL, 0x040fe20000410000ULL, 0x0000004603467220ULL, 0x040fe20000410000ULL,
0x0000004703477220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x000fc40000410000ULL, 0x00000000001c7919ULL, 0x000ea20000000000ULL,
0x00000014150b723eULL, 0x000fc400000010ffULL, 0x000000161713723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000030310a723eULL, 0x000fe400000010ffULL,
0x000000343503723eULL, 0x000fe400000010ffULL, 0x000000383904723eULL, 0x000fe400000010ffULL,
0x0000003c3d06723eULL, 0x000fe400000010ffULL, 0x000000404107723eULL, 0x000fc400000010ffULL,
0x000000484908723eULL, 0x000fe400000010ffULL, 0x000000444509723eULL, 0x000fe400000010ffULL,
0x00000036370c723eULL, 0x000fe400000010ffULL, 0x0000003a3b0d723eULL, 0x000fe400000010ffULL,
0x0000003e3f0e723eULL, 0x000fe400000010ffULL, 0x00000002ff217819ULL, 0x004fc4000001161cULL,
0x000000081c2f7811ULL, 0x000fe400078ff0ffULL, 0x00000021ff237212ULL, 0x000fe200078e33ffULL,
0x0000000821147824ULL, 0x000fe200078e00ffULL, 0x0000002fff317212ULL, 0x000fe200078e33ffULL,
0x000000082f167824ULL, 0x000fe200078e00ffULL, 0x0000000721007812ULL, 0x040fe200078ec0ffULL,
0x0000000821027824ULL, 0x000fe200078e00ffULL, 0xfffffff814237812ULL, 0x000fe400078ee223ULL,
0xfffffff816317812ULL, 0x000fc400078ee231ULL, 0xfffffff802157812ULL, 0x000fe400078ee221ULL,
0x0000000100027812ULL, 0x040fe400078e3cffULL, 0x0000000200147812ULL, 0x040fe400078e3cffULL,
0x0000000300167812ULL, 0x040fe200078e3cffULL, 0x0000000821177824ULL, 0x040fe200078e0202ULL,
0x0000000400187812ULL, 0x040fe200078e3cffULL, 0x0000000821197824ULL, 0x040fe200078e0214ULL,
0x00000005001a7812ULL, 0x040fe200078e3cffULL, 0x00000008211b7824ULL, 0x040fe200078e0216ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x000000041c147824ULL, 0x000fe200078e00ffULL,
0x00000018211d7211ULL, 0x040fe200078e18ffULL, 0x00000008211f7824ULL, 0x000fe200078e021aULL,
0x000000072f167812ULL, 0x000fe200078ec0ffULL, 0x0000000821217824ULL, 0x000fe200078e0200ULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x0000080067007824ULL, 0x000fe200078e00ffULL,
0x00000002161a7812ULL, 0x040fe200078e3cffULL, 0x000000082f187824ULL, 0x000fe200078e00ffULL,
0x00000003161c7812ULL, 0x000fc400078e3cffULL, 0x0000a00000027810ULL, 0x000fe20007ffe0ffULL,
0x000000082f297824ULL, 0x000fe200078e021aULL, 0xfffffff818257812ULL, 0x000fe400078ee22fULL,
0x0000000116187812ULL, 0x040fe200078e3cffULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x00000004161e7812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x0000000516207812ULL, 0x040fe200078e3cffULL, 0x000000101b1b7824ULL, 0x000fe200078e0202ULL,
0x0000000616227812ULL, 0x000fe200078e3cffULL, 0x0000000115167824ULL, 0x000fe200078e0214ULL,
0x0000000219197211ULL, 0x000fe200078e20ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0202ULL,
0x0000001c2f2b7211ULL, 0x000fe200078e18ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0202ULL,
0x0000000316007388ULL, 0x0005e20000000800ULL, 0x000000082f277824ULL, 0x002fe200078e0218ULL,
0x000000022b2b7211ULL, 0x000fe200078e20ffULL, 0x0000000114177824ULL, 0x040fe200078e0217ULL,
0x0000001f14187210ULL, 0x040fe20007ffe0ffULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x00000042430f723eULL, 0x000fe200000010ffULL, 0x0000000114197824ULL, 0x040fe200078e0219ULL,
0x0000000417007388ULL, 0x0003e20000000800ULL, 0x0000001023237824ULL, 0x000fe200078e0202ULL,
0x0000004a4b10723eULL, 0x000fe200000010ffULL, 0x0000000114167824ULL, 0x044fe200078e021bULL,
0x0000000619007388ULL, 0x0003e20000000800ULL, 0x000000082f157824ULL, 0x000fe200078e021eULL,
0x000000464711723eULL, 0x000fe200000010ffULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x0000000716007388ULL, 0x0003e20000000800ULL, 0x00000001141d7824ULL, 0x000fe200078e021dULL,
0x000000323312723eULL, 0x000fe200000010ffULL, 0x00000001ff037424ULL, 0x000fc400078e00ffULL,
0x000000082f2d7824ULL, 0x000fe200078e0220ULL, 0x000000081d007388ULL, 0x0003e20000000800ULL,
0x0000001027277824ULL, 0x000fe200078e0202ULL, 0x0000030003007a0cULL, 0x000fe20003f05270ULL,
0x000000082f2f7824ULL, 0x000fe200078e0222ULL, 0x0000000918007388ULL, 0x0003e20000000800ULL,
0x0000001029297824ULL, 0x000fe400078e0202ULL, 0x0000000114217824ULL, 0x040fe400078e0221ULL,
0x00000001141a7824ULL, 0x000fc400078e0223ULL, 0x0000000114257824ULL, 0x040fe200078e0225ULL,
0x0000000a21007388ULL, 0x0003e20000000800ULL, 0x0000001015157824ULL, 0x100fe400078e0202ULL,
0x000000102d2d7824ULL, 0x100fe200078e0202ULL, 0x0000000b1a007388ULL, 0x0003e20000000800ULL,
0x00000001141c7824ULL, 0x040fe400078e0227ULL, 0x000000102f2f7824ULL, 0x000fe200078e0202ULL,
0x0000000c25007388ULL, 0x0003e20000000800ULL, 0x0000000114297824ULL, 0x000fc400078e0229ULL,
0x0000001031317824ULL, 0x000fe200078e0202ULL, 0x0000000d1c007388ULL, 0x0003e20000000800ULL,
0x00000001141e7824ULL, 0x040fe400078e022bULL, 0x0000000114157824ULL, 0x040fe200078e0215ULL,
0x0000000e29007388ULL, 0x0003e20000000800ULL, 0x0000000114207824ULL, 0x040fe400078e022dULL,
0x00000001142f7824ULL, 0x040fe200078e022fULL, 0x0000000f1e007388ULL, 0x0003e20000000800ULL,
0x0000000114227824ULL, 0x000fc600078e0231ULL, 0x0000001015007388ULL, 0x0003e80000000800ULL,
0x0000001120007388ULL, 0x0003e80000000800ULL, 0x000000122f007388ULL, 0x0003e80000000800ULL,
0x0000001322007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002cf000008947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x002e620000000000ULL,
0x0000580000067a02ULL, 0x000fe20000000f00ULL, 0x00002000ff157424ULL, 0x000fe200078e00ffULL,
0x000000ff6700720cULL, 0x000fe20003f25270ULL, 0x0000000000227919ULL, 0x000ea40000002700ULL,
0x0000030006067a24ULL, 0x000fe400078e02ffULL, 0x0000000000037919ULL, 0x000ea40000002600ULL,
0x0000660006077a24ULL, 0x000fca00078e02ffULL, 0x00001fff07067811ULL, 0x000fe200078e40ffULL,
0x0000001004167824ULL, 0x042fe200078e0200ULL, 0x00000020041d7810ULL, 0x040fe40007ffe0ffULL,
0x00000040041f7810ULL, 0x040fe40007ffe0ffULL, 0x00a0000016087984ULL, 0x0002e20000000c00ULL,
0x0000006004217810ULL, 0x000fe20007ffe0ffULL, 0x0000580022227a24ULL, 0x004fe400078e0203ULL,
0x00a20000160c7984ULL, 0x0002a20000000c00ULL, 0x000000ff0400720cULL, 0x000fe20003f05270ULL,
0x0000030022037a24ULL, 0x000fc400078e02ffULL, 0x00a4000016107984ULL, 0x0003220000000c00ULL,
0x000000ff6700720cULL, 0x000fe20000705670ULL, 0x0000000103057824ULL, 0x000fe400078e0205ULL,
0x00a6000016247984ULL, 0x0002660000000c00ULL, 0x0000000506147211ULL, 0x000fca00078f98ffULL,
0x00006c0014147625ULL, 0x000fcc00078e0015ULL, 0x0000080067147825ULL, 0x000fcc00078e0014ULL,
0x000000101d1c7825ULL, 0x000fc800078e0014ULL, 0x000000101f1e7825ULL, 0x000fc800078e0014ULL,
0x0000001021207825ULL, 0x000fc800078e0014ULL, 0x00000010041a7825ULL, 0x000fe200078e0014ULL,
0x01ffffff07147812ULL, 0x000fe200078ec0ffULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x00cea20000000000ULL, 0x00000080ff197424ULL, 0x000fe400078e00ffULL,
0x0000000105187824ULL, 0x040fe400078e0214ULL, 0x00006c0005167625ULL, 0x002fc800078e0019ULL,
0x00006c0018187625ULL, 0x000fc800078e0019ULL, 0x0000001007157824ULL, 0x004fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011607ULL, 0x0000007015157812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fc800078ec0ffULL, 0x0000001607167210ULL, 0x140fe40007b5e015ULL,
0x0000001807187210ULL, 0x000fe40007d9e015ULL, 0x00000017ff177210ULL, 0x000fe400017e64ffULL,
0x00000019ff197210ULL, 0x000fc600027ea4ffULL, 0x0000005e16007986ULL, 0x0003e8000c101906ULL,
0x0000005c18007986ULL, 0x0003e4000c101906ULL, 0x000000081a007986ULL, 0x00c5e2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000000c1c007986ULL, 0x0005e8000c101d06ULL,
0x000000101e007986ULL, 0x0105e8000c101d06ULL, 0x0000002420007986ULL, 0x0025e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000000947ULL, 0x000fea0003800000ULL,
0x00000001ff057424ULL, 0x000fe400078e00ffULL, 0x00000004ff097424ULL, 0x004fc600078e00ffULL,
0x0000030005057a10ULL, 0x000fe20007ffe1ffULL, 0x00006a0022087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000005080879a8ULL, 0x000ea400099ee1c6ULL, 0x000000050800720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff077807ULL, 0x000fca0000000000ULL,
0x00000007ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff057984ULL, 0x000ee40000000000ULL,
0x000000ff0500720cULL, 0x008fda0003f05270ULL, 0x0000286000008947ULL, 0x000fea0003800000ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x004fe20000011604ULL,
0x00000080ff077424ULL, 0x002fe200078e00ffULL, 0x00000001030a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000404057819ULL, 0x000fe400000006ffULL, 0x0000000c080f7812ULL, 0x000fe200078ec0ffULL,
0x00006c0003087625ULL, 0x000fe200078e0007ULL, 0x00000070050d7812ULL, 0x000fc600078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e0007ULL, 0x000000080f087210ULL, 0x000fc8000791e00dULL,
0x0000000a0f0a7210ULL, 0x000fe40007b5e00dULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608057981ULL, 0x000368000c1e1900ULL,
0x000000060a0c7981ULL, 0x000362000c1e1900ULL, 0x00000300ff117624ULL, 0x000fca00078e00ffULL,
0x000000021100780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000203087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0007ULL,
0x000000080f087210ULL, 0x000fc8000791e00dULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080e7981ULL, 0x000362000c1e1900ULL, 0x000000041100780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000303087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0007ULL, 0x000000080f087210ULL, 0x000fc8000791e00dULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608107981ULL, 0x000362000c1e1900ULL,
0x000000041100780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000403087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0007ULL,
0x000000080f087210ULL, 0x000fc8000791e00dULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608127981ULL, 0x000362000c1e1900ULL, 0x000000061100780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000503087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0007ULL, 0x000000080f087210ULL, 0x000fc8000791e00dULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608167981ULL, 0x000362000c1e1900ULL,
0x000000061100780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081100780cULL, 0x002fe40003f06070ULL, 0x0000000603087810ULL, 0x000fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0007ULL, 0x000000080f087210ULL, 0x000fe40007a3e00dULL,
0x00000007030a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006c000a0a0625ULL, 0x000fe400078e0007ULL, 0x0000000608187981ULL, 0x000366000c1e1900ULL,
0x0000000a0f0a0210ULL, 0x000fc80007c7e00dULL, 0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL,
0x000000060a0a0981ULL, 0x000368000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0f7224ULL, 0x004fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0003ULL,
0x000000ffff1a7224ULL, 0x020fe400078e0005ULL, 0x000000ffff117224ULL, 0x000fc600078e00ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000000111117810ULL, 0x000fc80007ffe0ffULL,
0x0000000411007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080f087810ULL, 0x040fe40007ffe0ffULL, 0x000000010f097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001a05057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000807087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x00000010040b7824ULL, 0x000fe400078e00ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080d087210ULL, 0x000fc80007b3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006081a7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090f087810ULL, 0x042fe40007ffe0ffULL,
0x000000020f097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000c05057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000907087810ULL, 0x000fe20007ffe0ffULL,
0x00000010040b7824ULL, 0x000fe200078e00ffULL, 0x0000008000097802ULL, 0x000fe40000000f00ULL,
0x00000001ff0c7819ULL, 0x000fe40000011604ULL, 0x000000700b0b7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000080c087210ULL, 0x000fc80007b3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080c7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f087810ULL, 0x042fe40007ffe0ffULL, 0x000000030f097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000e05057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a07087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x00000010040b7824ULL, 0x000fe400078e00ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080d087210ULL, 0x000fc80007b3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080e7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0f087810ULL, 0x042fe40007ffe0ffULL,
0x000000040f097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001005057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b07087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011604ULL,
0x00000010040b7824ULL, 0x000fe400078e00ffULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000080d087210ULL, 0x000fc80007b3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608107981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f087810ULL, 0x042fe40007ffe0ffULL, 0x000000050f097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001205057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c07087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x00000010040b7824ULL, 0x000fe400078e00ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080d087210ULL, 0x000fc80007b3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608127981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0f087810ULL, 0x042fe40007ffe0ffULL,
0x000000060f097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001605057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d07087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000004040b7819ULL, 0x000fe400000006ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x000000700b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000080d087210ULL, 0x000fc80007b3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608167981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f087810ULL, 0x042fe40007ffe0ffULL, 0x000000070f097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001805057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e07087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x00000010040b7824ULL, 0x000fe400078e00ffULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080d087210ULL, 0x000fc80007b3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608187981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0f087810ULL, 0x002fe40007ffe0ffULL,
0x0000000a05057209ULL, 0x000fe40007810000ULL, 0x0000030008007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f07087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011604ULL,
0x00000010040a7824ULL, 0x000fe400078e00ffULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL, 0x000000700a0b7812ULL, 0x000fc800078ec0ffULL,
0x000000080d087210ULL, 0x000fc80007a3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080a7981ULL, 0x000368000c1e1900ULL, 0x000000080f0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000807077810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000047919ULL, 0x000ee40000000000ULL, 0x0000001004077824ULL, 0x008fe200078e00ffULL,
0x00000001ff087819ULL, 0x006fc80000011604ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fca00078ec0ffULL, 0x0000000107087824ULL, 0x000fca00078e0208ULL,
0x0000000508007388ULL, 0x0203e40000000800ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000070400780cULL, 0x000fe20003f04070ULL, 0x00002000ff0a7424ULL, 0x004fe200078e00ffULL,
0x0000000306297211ULL, 0x000fe200078f98ffULL, 0x0000001004057824ULL, 0x042fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fe20000011604ULL, 0x0000000103287824ULL, 0x000fe200078e0214ULL,
0x00000020040b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000c06087812ULL, 0x000fe200078ec0ffULL, 0x00006c0029067625ULL, 0x000fe200078e000aULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000040040d7810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000000805167210ULL, 0x000fe20007ffe0ffULL, 0x0000080067067825ULL, 0x040fe200078e0006ULL,
0x0000006004117810ULL, 0x000fe20007ffe0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff148424ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000100067057824ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00006c00280e8625ULL, 0x000fe200078e000fULL,
0x0000000000207805ULL, 0x000fc6000001ff00ULL, 0x00000010671b8824ULL, 0x000fe400078e0204ULL,
0x00006c0003148625ULL, 0x000fc600078e0014ULL, 0x000045801b1b8811ULL, 0x000fe200078e20ffULL,
0x0000001004177824ULL, 0x040fe400078e0205ULL, 0x0000001004087825ULL, 0x000fc800078e0006ULL,
0x00000010671f8824ULL, 0x000fe400078e0204ULL, 0x000000100b0a7825ULL, 0x000fc600078e0006ULL,
0x000041801f1f8811ULL, 0x000fe200078e20ffULL, 0x000000100d0c7825ULL, 0x000fc800078e0006ULL,
0x0000001011107825ULL, 0x000fe400078e0006ULL, 0x0000000016067984ULL, 0x0002a40000000800ULL,
0x0000001004128825ULL, 0x040fe400078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008177faeULL, 0x0007e2000b901c46ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000001004148825ULL, 0x000fe400078e0014ULL, 0x003800000a177faeULL, 0x0009e4000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400078e00ffULL, 0x005800000c177faeULL, 0x000be8000b901c46ULL,
0x0078000010177faeULL, 0x0003e2000b901c46ULL, 0x0000000000087805ULL, 0x008fc6000001ff00ULL,
0x00000000121b8faeULL, 0x0007e2000b901c46ULL, 0x00000000000a7805ULL, 0x010fc6000001ff00ULL,
0x00000000141f8faeULL, 0x0009e2000b901c46ULL, 0x00000000000c7805ULL, 0x020fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x008fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000d7000009947ULL, 0x000fea0003800000ULL,
0x00000001032a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000128287810ULL, 0x000fe40007ffe0ffULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000100037802ULL, 0x000fc80000000f00ULL, 0x0000030003007a0cULL, 0x000fda0003f06070ULL,
0x0000025000000947ULL, 0x000fea0003800000ULL, 0x000000070400780cULL, 0x040fe20003f04070ULL,
0x00002000ff2c7424ULL, 0x000fe200078e00ffULL, 0x0000000103307812ULL, 0x040fe200078ec0ffULL,
0x00000800032b7824ULL, 0x000fe200078e00ffULL, 0x00000020042f7810ULL, 0x040fe20007ffe0ffULL,
0x00006c00292c7625ULL, 0x000fe200078e002cULL, 0x0000004004317810ULL, 0x040fe40007ffe0ffULL,
0x000008002b2e7812ULL, 0x000fe400078ec0ffULL, 0x0000006004337810ULL, 0x000fe20007ffe0ffULL,
0x00000800672c7825ULL, 0x000fc800078e002cULL, 0x0000000267378824ULL, 0x000fe400078e0230ULL,
0x00000080ff358424ULL, 0x000fe400078e00ffULL, 0x00000001052b7824ULL, 0x000fe400078e022eULL,
0x00000080ff3b8424ULL, 0x000fe400078e00ffULL, 0x00000002673d8824ULL, 0x000fe200078e0230ULL,
0x0000002b042b7211ULL, 0x000fe200078e20ffULL, 0x00006c0028348625ULL, 0x000fc800078e0035ULL,
0x0000000837398824ULL, 0x000fe400078e0204ULL, 0x000000102f2e7825ULL, 0x000fc600078e002cULL,
0x0000458039398811ULL, 0x000fe200078e20ffULL, 0x0000001031307825ULL, 0x000fc800078e002cULL,
0x0000001033327825ULL, 0x000fc800078e002cULL, 0x00006c002a368625ULL, 0x000fc800078e003bULL,
0x00000010042c7825ULL, 0x000fc800078e002cULL, 0x000000083d3b8824ULL, 0x000fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c2b7faeULL, 0x0003e2000b901c46ULL,
0x0000001004348825ULL, 0x000fc600078e0034ULL, 0x000041803b3b8811ULL, 0x000fe200078e20ffULL,
0x0000001004368825ULL, 0x000fe200078e0036ULL, 0x003800002e2b7faeULL, 0x0003e8000b901c46ULL,
0x00580000302b7faeULL, 0x0003e8000b901c46ULL, 0x00780000322b7faeULL, 0x0003e8000b901c46ULL,
0x0000000034398faeULL, 0x0003e8000b901c46ULL, 0x00000000363b8faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff032b7810ULL, 0x002fe20007ffe0ffULL,
0x00000010042d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff2e7819ULL, 0x000fc40000011604ULL,
0x00000002ff337819ULL, 0x000fe20000011604ULL, 0x000000802b2c7824ULL, 0x000fe200078e00ffULL,
0x000000702d2d7812ULL, 0x000fe200078ec0ffULL, 0x000008002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c2e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000833357824ULL, 0x040fe200078e00ffULL,
0x000000802c2c7812ULL, 0x000fe200078ec0ffULL, 0x0000000833317824ULL, 0x040fe200078e00ffULL,
0x00000007333a7812ULL, 0x040fe400078ec0ffULL, 0x0000000833377810ULL, 0x000fe20007ffe0ffULL,
0x00000100672c7824ULL, 0x000fe200078e022cULL, 0x0000030003007a0cULL, 0x000fc40003f06070ULL,
0x00000037ff487212ULL, 0x000fe200078e33ffULL, 0x00000008373e7824ULL, 0x000fe200078e00ffULL,
0x0000002c2e2e7210ULL, 0x000fe20007ffe02dULL, 0x00000008332d7824ULL, 0x000fe200078e00ffULL,
0x00000033ff2c7212ULL, 0x000fe200078e33ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002e2f7984ULL, 0x000e620000000800ULL, 0xfffffff835467812ULL, 0x000fe200078ee22cULL,
0x0000000404357824ULL, 0x000fe200078e00ffULL, 0xfffffff8312c7812ULL, 0x100fe200078ee23aULL,
0x004580002e4a7984ULL, 0x0007220000000800ULL, 0x000000012d307812ULL, 0x100fe200078ef63aULL,
0x00000008373c7824ULL, 0x000fe200078e00ffULL, 0x0000000c35357812ULL, 0x000fe400078ec0ffULL,
0x000000022d327812ULL, 0x140fe400078ef63aULL, 0x000000032d347812ULL, 0x000fc400078ef63aULL,
0x000008002b2e7812ULL, 0x008fe400078ec0ffULL, 0x000000042d367812ULL, 0x000fe400078ef63aULL,
0x00000180052b7810ULL, 0x000fe40007ffe02eULL, 0x000000052d387812ULL, 0x100fe400078ef63aULL,
0x0000000337317819ULL, 0x000fe200000006ffULL, 0x000000102c2c7824ULL, 0x100fe200078e022bULL,
0x000000062d3a7812ULL, 0x000fe200078ef63aULL, 0x0000001032327824ULL, 0x100fe200078e022bULL,
0xfffffff831487812ULL, 0x000fe200078ee248ULL, 0x00000001352c7824ULL, 0x040fe200078e022cULL,
0x0000002b30307211ULL, 0x000fe200078e20ffULL, 0x0000000135327824ULL, 0x000fe200078e0232ULL,
0x0000000103037810ULL, 0x000fe20007ffe0ffULL, 0x0000001034347824ULL, 0x100fe200078e022bULL,
0x0000000128287810ULL, 0x000fe20007ffe0ffULL, 0x000000002c2c7984ULL, 0x000ee20000000800ULL,
0x0000000135307824ULL, 0x000fe200078e0230ULL, 0x0000000129297810ULL, 0x000fe20007ffe0ffULL,
0x0000000135347824ULL, 0x040fe200078e0234ULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x0000001036367824ULL, 0x100fe200078e022bULL, 0x000000012a2a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001038387824ULL, 0x000fe200078e022bULL, 0x0000002f062f7221ULL, 0x006fe20000010100ULL,
0x0000000030307984ULL, 0x000fe20000000800ULL, 0x0000000135367824ULL, 0x000fc400078e0236ULL,
0x3fb8aa3b2f2d7820ULL, 0x000fe20000410000ULL, 0x00000007372f7812ULL, 0x000fe200078ec0ffULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x0000003835387210ULL, 0x040fe20007ffe0ffULL,
0x0000002d00317308ULL, 0x0003220000000800ULL, 0xfffffff83e2e7812ULL, 0x100fe200078ee22fULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x000000013c3e7812ULL, 0x000fe200078ef62fULL,
0x000000103a3a7824ULL, 0x000fe200078e022bULL, 0x000000023c407812ULL, 0x000fe200078ef62fULL,
0x000000102e2e7824ULL, 0x000fe200078e022bULL, 0x000000033c427812ULL, 0x140fe200078ef62fULL,
0x00000001353a7824ULL, 0x040fe200078e023aULL, 0x000000043c447812ULL, 0x000fe200078ef62fULL,
0x00000010462d7824ULL, 0x002fe200078e022bULL, 0x000000053c467812ULL, 0x140fe200078ef62fULL,
0x00000001352e7824ULL, 0x040fe200078e022eULL, 0x000000063c3c7812ULL, 0x000fe200078ef62fULL,
0x00000001352d7824ULL, 0x000fe200078e022dULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x0000004a314a7220ULL, 0x010fe20000410000ULL, 0x0000002b3e3e7211ULL, 0x000fe200078e20ffULL,
0x0000001040407824ULL, 0x100fe200078e022bULL, 0x000000002d2f7984ULL, 0x000fe20000000800ULL,
0x0000001042427824ULL, 0x000fe200078e022bULL, 0x000000274a277221ULL, 0x000fe20000010000ULL,
0x0000001044447824ULL, 0x100fe200078e022bULL, 0x00001f334a2d7589ULL, 0x000e6200000e0000ULL,
0x0000001046467824ULL, 0x000fc400078e022bULL, 0x000000103c3c7824ULL, 0x100fe200078e022bULL,
0x000000003a3a7984ULL, 0x000ea20000000800ULL, 0x0000001048487824ULL, 0x000fe200078e022bULL,
0x00005410ff2b7816ULL, 0x008fe2000000002cULL, 0x0000000135407824ULL, 0x040fe200078e0240ULL,
0x00007610ff2c7816ULL, 0x000fe2000000002cULL, 0x000000002e2e7984ULL, 0x000ee20000000800ULL,
0x00000001353e7824ULL, 0x040fe200078e023eULL, 0x0000004835487210ULL, 0x040fe20007ffe0ffULL,
0x0000000135427824ULL, 0x040fe200078e0242ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x0000000135447824ULL, 0x000fc400078e0244ULL, 0x0000000135467824ULL, 0x040fe200078e0246ULL,
0x000000003e3e7984ULL, 0x000fe20000000800ULL, 0x00000001353c7824ULL, 0x000fc600078e023cULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x0000002d2b187223ULL, 0x082fe20000010018ULL,
0x0000002d2c1b7223ULL, 0x000fe4000001001bULL, 0x00001f374a4a7589ULL, 0x000e6800000e0000ULL,
0x0000000044447984ULL, 0x000f280000000800ULL, 0x0000000046467984ULL, 0x000f620000000800ULL,
0x00005410ff2c7816ULL, 0x000fc4000000002fULL, 0x00007610ff2b7816ULL, 0x000fe2000000002fULL,
0x000000003c3c7984ULL, 0x000e640000000800ULL, 0x0000002d2c197223ULL, 0x080fe20000010019ULL,
0x00005410ff2c7816ULL, 0x000fe20000000030ULL, 0x0000002d2b0e7223ULL, 0x080fe2000001000eULL,
0x00007610ff2b7816ULL, 0x000fe20000000030ULL, 0x0000000048487984ULL, 0x000f240000000800ULL,
0x0000002d2c137223ULL, 0x080fe20000010013ULL, 0x00007610ff2c7816ULL, 0x000fe20000000032ULL,
0x0000002d2b1a7223ULL, 0x000fe2000001001aULL, 0x00005410ff2b7816ULL, 0x000fc60000000032ULL,
0x0000002d2c097223ULL, 0x080fe20000010009ULL, 0x00005410ff2c7816ULL, 0x000fe20000000034ULL,
0x0000002d2b107223ULL, 0x000fe20000010010ULL, 0x00007610ff2b7816ULL, 0x000fc60000000034ULL,
0x0000002d2c157223ULL, 0x080fe20000010015ULL, 0x00007610ff2c7816ULL, 0x000fe20000000036ULL,
0x0000002d2b267223ULL, 0x000fe20000010026ULL, 0x00005410ff2b7816ULL, 0x000fc60000000036ULL,
0x0000002d2c257223ULL, 0x080fe20000010025ULL, 0x00005410ff2c7816ULL, 0x000fe20000000038ULL,
0x0000002d2b087223ULL, 0x000fe20000010008ULL, 0x00007610ff2b7816ULL, 0x000fc60000000038ULL,
0x0000002d2c117223ULL, 0x080fe20000010011ULL, 0x00005410ff2c7816ULL, 0x004fe2000000003aULL,
0x0000002d2b247223ULL, 0x000fe20000010024ULL, 0x00007610ff2b7816ULL, 0x008fc6000000002eULL,
0x0000002d2c0d7223ULL, 0x000fe2000001000dULL, 0x00007610ff2c7816ULL, 0x000fe2000000003aULL,
0x0000004a2b227223ULL, 0x002fe20000010022ULL, 0x00005410ff2b7816ULL, 0x000fc60000000040ULL,
0x0000002d2c237223ULL, 0x000fe20000010023ULL, 0x00005410ff2c7816ULL, 0x000fe2000000002eULL,
0x0000004a2b167223ULL, 0x000fe20000010016ULL, 0x00007610ff2b7816ULL, 0x000fc60000000040ULL,
0x0000004a2c0b7223ULL, 0x080fe2000001000bULL, 0x00005410ff2c7816ULL, 0x000fe2000000003eULL,
0x0000004a2b207223ULL, 0x000fe20000010020ULL, 0x00005410ff2b7816ULL, 0x000fc60000000042ULL,
0x0000004a2c177223ULL, 0x080fe20000010017ULL, 0x00007610ff2c7816ULL, 0x000fe2000000003eULL,
0x0000004a2b147223ULL, 0x000fe20000010014ULL, 0x00005410ff2b7816ULL, 0x010fc60000000044ULL,
0x0000004a2c217223ULL, 0x080fe20000010021ULL, 0x00007610ff2c7816ULL, 0x000fe20000000042ULL,
0x0000004a2b127223ULL, 0x000fe20000010012ULL, 0x00007610ff2b7816ULL, 0x000fc60000000044ULL,
0x0000004a2c1f7223ULL, 0x080fe2000001001fULL, 0x00005410ff2c7816ULL, 0x020fe20000000046ULL,
0x0000004a2b1e7223ULL, 0x000fe2000001001eULL, 0x00005410ff2b7816ULL, 0x000fc6000000003cULL,
0x0000004a2c0f7223ULL, 0x080fe2000001000fULL, 0x00007610ff2c7816ULL, 0x000fe20000000046ULL,
0x0000004a2b0c7223ULL, 0x000fe2000001000cULL, 0x00007610ff2b7816ULL, 0x000fc6000000003cULL,
0x0000004a2c1d7223ULL, 0x080fe2000001001dULL, 0x00007610ff2c7816ULL, 0x000fe20000000048ULL,
0x0000004a2b1c7223ULL, 0x000fe2000001001cULL, 0x00005410ff2b7816ULL, 0x000fc60000000048ULL,
0x0000004a2c077223ULL, 0x080fe40000010007ULL, 0x0000004a2b0a7223ULL, 0x000fe2000001000aULL,
0xfffff2e000008947ULL, 0x000fea000383ffffULL, 0x0180000027037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000d21000287802ULL, 0x000fe40000000f00ULL,
0x0000764000007944ULL, 0x004fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002700047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc80000000027ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000277919ULL, 0x006e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff287819ULL, 0x002fe40000011627ULL,
0x00000008272a7811ULL, 0x040fe200078ff0ffULL, 0x0000000427277824ULL, 0x000fe400078e00ffULL,
0x00001f2803047589ULL, 0x008e6200000e0000ULL, 0x0000002aff297212ULL, 0x000fe200078e33ffULL,
0x000000082a2e7824ULL, 0x000fc400078e00ffULL, 0x00001f2a03057589ULL, 0x000ea200000e0000ULL,
0x00000008282c7824ULL, 0x000fe400078e00ffULL, 0xfffffff82e337812ULL, 0x000fca00078ee229ULL,
0x0000001033337824ULL, 0x000fe200078e0202ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001304137220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000000804087220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000002304067220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000000e04047220ULL, 0x000fe20000410000ULL, 0x00000021050e7220ULL, 0x044fe20000410000ULL,
0x0000001e05217220ULL, 0x040fe20000410000ULL, 0x0000001d051e7220ULL, 0x040fe20000410000ULL,
0x0000000b050b7220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000001705177220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000002005037220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000000f050f7220ULL, 0x040fe20000410000ULL, 0x0000000c050c7220ULL, 0x040fe20000410000ULL,
0x0000001c051d7220ULL, 0x040fe20000410000ULL, 0x0000000a050a7220ULL, 0x040fe20000410000ULL,
0x0000000705057220ULL, 0x000fe20000410000ULL, 0x000000100909723eULL, 0x000fe200000010ffULL,
0x0000000828077824ULL, 0x000fe200078e00ffULL, 0x0000000d0606723eULL, 0x000fc400000010ffULL,
0x0000000a0505723eULL, 0x000fe400000010ffULL, 0x00000007280a7812ULL, 0x000fe400078ec0ffULL,
0x000000072a107812ULL, 0x000fe400078ec0ffULL, 0x000000170e0e723eULL, 0x000fe400000010ffULL,
0x000000010a0d7812ULL, 0x000fe400078e3cffULL, 0x000000190404723eULL, 0x000fc400000010ffULL,
0x000000122112723eULL, 0x000fe200000010ffULL, 0x000000082a217824ULL, 0x000fe200078e00ffULL,
0x000000020a177812ULL, 0x000fe200078e3cffULL, 0x00000008280d7824ULL, 0x040fe200078e020dULL,
0x000000181b18723eULL, 0x000fe400000010ffULL, 0x000000082508723eULL, 0x000fe200000010ffULL,
0x0000000828177824ULL, 0x000fe200078e0217ULL, 0x000000141f14723eULL, 0x000fe200000010ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0202ULL, 0x000000030a197812ULL, 0x000fe200078e3cffULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0x00000028ff237212ULL, 0x000fc400078e33ffULL,
0x0000000c1d0c723eULL, 0x000fe200000010ffULL, 0x0000000828197824ULL, 0x000fe200078e0219ULL,
0xfffffff807077812ULL, 0x000fe400078ee228ULL, 0x000000040a1b7812ULL, 0x040fe200078e3cffULL,
0x0000001019197824ULL, 0x000fe200078e0202ULL, 0x000000060a1f7812ULL, 0x000fe400078e3cffULL,
0x0000000110257812ULL, 0x000fe200078e3cffULL, 0x00000008281b7824ULL, 0x000fe200078e021bULL,
0x0000000210297812ULL, 0x000fe200078e3cffULL, 0x00000008281f7824ULL, 0x000fe200078e021fULL,
0x00000003102b7812ULL, 0x000fe200078e3cffULL, 0x000000082a257824ULL, 0x000fe200078e0225ULL,
0x00000004102d7812ULL, 0x000fe200078e3cffULL, 0x000000082a297824ULL, 0x000fe200078e0229ULL,
0x00000005102f7812ULL, 0x000fe200078e3cffULL, 0x000000082a2b7824ULL, 0x000fe200078e022bULL,
0x0000000610317812ULL, 0x000fe200078e3cffULL, 0x000000082a2d7824ULL, 0x000fe200078e022dULL,
0x000000050a1d7812ULL, 0x000fe200078e3cffULL, 0x000000082a2f7824ULL, 0x000fe200078e022fULL,
0xfffffff82c237812ULL, 0x000fe200078ee223ULL, 0x000000082a317824ULL, 0x000fe200078e0231ULL,
0xfffffff821217812ULL, 0x000fe200078ee22aULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x0000000c270a7812ULL, 0x000fe200078ec0ffULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x0000000207077211ULL, 0x080fe200078e20ffULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x0000001d281d7211ULL, 0x000fe200078e18ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0202ULL,
0x000000131a13723eULL, 0x000fe200000010ffULL, 0x0000000107077824ULL, 0x000fe200078e020aULL,
0x000000021d1d7211ULL, 0x000fe200078e20ffULL, 0x0000001025257824ULL, 0x100fe200078e0202ULL,
0x000000160303723eULL, 0x000fe200000010ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x000000152615723eULL, 0x000fe200000010ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0x000000112411723eULL, 0x000fe200000010ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0x0000001807007388ULL, 0x0003e20000000800ULL, 0x000000102f2f7824ULL, 0x100fe200078e0202ULL,
0x0000000b220b723eULL, 0x000fe200000010ffULL, 0x0000001031317824ULL, 0x000fe200078e0202ULL,
0x000000210a1c7210ULL, 0x040fe20007ffe0ffULL, 0x000000010a027824ULL, 0x000fe200078e020dULL,
0x0000000f1e0f723eULL, 0x000fe200000010ffULL, 0x000000010a107824ULL, 0x000fc400078e0217ULL,
0x000000010a167824ULL, 0x040fe200078e0219ULL, 0x0000001302007388ULL, 0x0005e20000000800ULL,
0x000000010a1b7824ULL, 0x040fe200078e021bULL, 0x000000290a187210ULL, 0x042fe20007ffe0ffULL,
0x000000010a1a7824ULL, 0x040fe200078e021dULL, 0x0000000910007388ULL, 0x0005e20000000800ULL,
0x000000010a1f7824ULL, 0x040fe400078e021fULL, 0x000000010a237824ULL, 0x040fe200078e0223ULL,
0x0000001516007388ULL, 0x0005e20000000800ULL, 0x000000010a257824ULL, 0x000fc400078e0225ULL,
0x000000010a2b7824ULL, 0x040fe200078e022bULL, 0x000000081b007388ULL, 0x0005e20000000800ULL,
0x000000010a2d7824ULL, 0x040fe400078e022dULL, 0x000000010a1e7824ULL, 0x040fe200078e022fULL,
0x000000111a007388ULL, 0x0005e20000000800ULL, 0x000000010a317824ULL, 0x040fe400078e0231ULL,
0x000000010a207824ULL, 0x000fe200078e0233ULL, 0x000000061f007388ULL, 0x0005e80000000800ULL,
0x0000000423007388ULL, 0x0005e80000000800ULL, 0x0000000b1c007388ULL, 0x0005e80000000800ULL,
0x0000000e25007388ULL, 0x0005e80000000800ULL, 0x0000000318007388ULL, 0x0005e80000000800ULL,
0x000000142b007388ULL, 0x0005e80000000800ULL, 0x000000122d007388ULL, 0x0005e80000000800ULL,
0x0000000f1e007388ULL, 0x0005e80000000800ULL, 0x0000000c31007388ULL, 0x0005e80000000800ULL,
0x0000000520007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000187919ULL, 0x006e620000000000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x0000000867677824ULL, 0x000fe200078e00ffULL,
0x0000000000167919ULL, 0x000ee20000002600ULL, 0x0000000405057899ULL, 0x000fc6000800063fULL,
0x1ffffff867677812ULL, 0x000fe400078ec0ffULL, 0x00000020181a7810ULL, 0x042fe20007ffe0ffULL,
0x00000004050472a4ULL, 0x004fe2000f8e023fULL, 0x00000040181f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001016027824ULL, 0x048fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fe20000011618ULL,
0x0000001016177824ULL, 0x000fe200078e00ffULL, 0x00000060181e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010161c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff037819ULL, 0x000fc4000001161aULL,
0x00000003ff147819ULL, 0x000fe4000001161fULL, 0xfffffff002027812ULL, 0x000fe400078ee205ULL,
0x00000003ff157819ULL, 0x000fe4000001161eULL, 0x0000000705057812ULL, 0x000fe400078e4818ULL,
0x0000000703047812ULL, 0x000fe400078e481aULL, 0x0000000714067812ULL, 0x000fc400078e481fULL,
0x0000000715087812ULL, 0x000fe400078e481eULL, 0x0ffffff8050b7812ULL, 0x000fe400078ef818ULL,
0x0ffffff804057812ULL, 0x000fe400078ef81aULL, 0x0ffffff806077812ULL, 0x000fe200078ef81fULL,
0x000000100b047824ULL, 0x000fe200078e0200ULL, 0x0ffffff808097812ULL, 0x000fe200078ef81eULL,
0x0000001005087824ULL, 0x000fe200078e0200ULL, 0xfffffff017147812ULL, 0x000fe200078ee214ULL,
0x00000010070c7824ULL, 0x000fe200078e0200ULL, 0x0000000009107211ULL, 0x000fe200078e20ffULL,
0x00a0000004047984ULL, 0x000e620000000c00ULL, 0x0000001016007824ULL, 0x000fe200078e00ffULL,
0xfffffff01c157812ULL, 0x000fc400078ee215ULL, 0x00a0000008087984ULL, 0x000ea20000000c00ULL,
0x0000000414177c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff000007812ULL, 0x000fe200078ee203ULL,
0x00a000000c0c7984ULL, 0x000ee20000000c00ULL, 0x0000000402037c10ULL, 0x000fe4000ff1e0ffULL,
0x00000007671d7812ULL, 0x040fe200078ef81aULL, 0x00a0000010107984ULL, 0x000f220000000c00ULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00000007671b7812ULL, 0x000fe200078ef818ULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fc400078048ffULL,
0x00000007671f7812ULL, 0x000fe400078ef81fULL, 0x00005b0003037a11ULL, 0x000fe400000f4c16ULL,
0x00000004001c7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000415007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x00005a0017167a11ULL, 0x000fe400078248ffULL,
0x0000000767677812ULL, 0x000fe200078ef81eULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005a001c147a11ULL, 0x000fe200078048ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005a0000187a11ULL, 0x000fc400078448ffULL, 0x00005b001c157a11ULL, 0x000fe400000f4c15ULL,
0x00005b0017177a11ULL, 0x000fe400008f4c1aULL, 0x00005b0000197a11ULL, 0x000fe200010f4c19ULL,
0x000000101d147825ULL, 0x000fe200078e0014ULL, 0x0000000402007986ULL, 0x002fe6000c101d06ULL,
0x000000101f167825ULL, 0x000fe200078e0016ULL, 0x0000000814007986ULL, 0x004fe6000c101d06ULL,
0x0000001067187825ULL, 0x000fe200078e0018ULL, 0x0000000c16007986ULL, 0x008fe8000c101d06ULL,
0x0000001018007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff007819ULL, 0x000fe20000011667ULL, 0xffffffffff827424ULL, 0x000fc600078e00ffULL,
0x01ffffff00007812ULL, 0x000fc800078ec0ffULL, 0x0000000069657211ULL, 0x000fc800078e08ffULL,
0x000000666500720cULL, 0x000fe40003f06070ULL, 0x0000000169057810ULL, 0x00afd60007ffe0ffULL,
0x0000000262028824ULL, 0x000fc800078e00ffULL, 0x0000640002028a24ULL, 0x000fc800078e0265ULL,
0x0000600002028625ULL, 0x000fca00078e0017ULL, 0x0000000602828981ULL, 0x000362000c1e1900ULL,
0x000000640500720cULL, 0x000fe20003f06070ULL, 0x0000004067637824ULL, 0x000fe200078e00ffULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000805f007824ULL, 0x000fe400078e00ffULL,
0x0000010069097824ULL, 0x000fca00078e0263ULL, 0x0000004000117812ULL, 0x000fc600078ef809ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x002e620000000000ULL,
0x0000000482117c24ULL, 0x020fe2000f8e0211ULL, 0x0000000968067217ULL, 0x000fe20007800000ULL,
0x00000200ff217424ULL, 0x000fe200078e00ffULL, 0x0000200067137811ULL, 0x000fc600078e68ffULL,
0x0000000106107824ULL, 0x000fe200078e0a09ULL, 0x00000002ff1d7819ULL, 0x102fe2000001160dULL,
0x000000100d1f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fe4000001160dULL,
0x0000007f1d027812ULL, 0x040fe400078ec0ffULL, 0x000000101d237810ULL, 0x040fe40007ffe0ffULL,
0x000000081d0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111027824ULL, 0x000fe200078e0202ULL,
0x0000007f23087812ULL, 0x000fc400078ec0ffULL, 0x000000301f1f7812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x0000007f0f047812ULL, 0x000fe400078ec0ffULL,
0x000000181d257810ULL, 0x000fe20007ffe0ffULL, 0x0000000111077824ULL, 0x040fe200078e0208ULL,
0x0000001f02087210ULL, 0x000fe40007f1e0ffULL, 0x0000000411047210ULL, 0x000fe20007ffe0ffULL,
0x00005e0007067625ULL, 0x000fe200078e0021ULL, 0x0000007f25027812ULL, 0x000fc400078ec0ffULL,
0x000000201d177810ULL, 0x000fe20007ffe0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x0000000312127812ULL, 0x000fe400078e480dULL, 0x0000001f06067210ULL, 0x080fe20007f3e0ffULL,
0x0000000111027824ULL, 0x000fe200078e0202ULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0603ULL, 0x0000001f040a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x0000007f17047812ULL, 0x000fc400078ec0ffULL,
0x000000301d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000001f020c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000111047824ULL, 0x000fe200078e0204ULL,
0x0ffffffc12027812ULL, 0x000fe200078ef80dULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000100f00720cULL, 0x080fe20003f26070ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x000000101d00720cULL, 0x000fe40003f06070ULL, 0x00000003ff0d7210ULL, 0x000fe200017fe4ffULL,
0x0000001002157824ULL, 0x000fe200078e0213ULL, 0x0000007f19027812ULL, 0x000fe200078ec0ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000001f040e7210ULL, 0x000fc40007f7e0ffULL,
0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111027824ULL, 0x000fe200078e0202ULL,
0xfffffffc0f047812ULL, 0x000fe200078ee212ULL, 0x000000ffff0f7224ULL, 0x000fe200018e0605ULL,
0x000000102300720cULL, 0x080fe20003fa6070ULL, 0x00005e0002027625ULL, 0x000fe200078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008157faeULL, 0x0003e2000c101c46ULL,
0x000000102500720cULL, 0x080fe40003f86070ULL, 0x0000001004057824ULL, 0x000fe200078e0213ULL,
0x0000007f1b047812ULL, 0x000fe200078ec0ffULL, 0x0000000423237824ULL, 0x000fe200078e00ffULL,
0x000000101700720cULL, 0x040fe20003f66070ULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x000000000a057faeULL, 0x0005e2000c901c46ULL, 0x0000000225257819ULL, 0x000fc400000006ffULL,
0x000000101900720cULL, 0x0c0fe20003f46070ULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0x0000001f02087210ULL, 0x002fe20007fde0ffULL, 0x0000000111027824ULL, 0x000fe200078e0204ULL,
0x000000101b00720cULL, 0x0c0fe20003f26070ULL, 0x000000041b1b7824ULL, 0x000fe200078e00ffULL,
0x000000101d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff097224ULL, 0x000fe200030e0603ULL,
0xfffffffc25107812ULL, 0x000fe200078ee212ULL, 0x00005e0002027625ULL, 0x000fe200078e0021ULL,
0x0000007f1d0a7812ULL, 0x004fc400078ec0ffULL, 0xfffffffc17147812ULL, 0x000fe200078ee212ULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x0000001f02027210ULL, 0x000fe20007fde0ffULL,
0x0000000111047824ULL, 0x000fe200078e020aULL, 0xfffffffc230a7812ULL, 0x100fe200078ee212ULL,
0x0000001010117824ULL, 0x000fe200078e0213ULL, 0xfffffffc19167812ULL, 0x100fe200078ee212ULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0xfffffffc1b187812ULL, 0x100fe400078ee212ULL,
0xfffffffc1d127812ULL, 0x000fe200078ee212ULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0x0000001f04047210ULL, 0x000fe20007fde0ffULL, 0x000000100a0b7824ULL, 0x100fe200078e0213ULL,
0x0000001316177211ULL, 0x000fe200078e20ffULL, 0x0000001014157824ULL, 0x000fc400078e0213ULL,
0x0000001018197824ULL, 0x100fe200078e0213ULL, 0x00000000060b7faeULL, 0x0003e2000e901c46ULL,
0x0000001012137824ULL, 0x000fe400078e0213ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x000000000c117faeULL, 0x0003e8000e101c46ULL, 0x000000000e157faeULL, 0x0003e8000d901c46ULL,
0x0000000008177faeULL, 0x0003e8000d101c46ULL, 0x0000000002197faeULL, 0x0003e8000c901c46ULL,
0x0000000004137faeULL, 0x0003e2000c101c46ULL, 0x000005a000007947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x002e620000000000ULL, 0x0000000482117c24ULL, 0x020fe2000f8e0211ULL,
0x0000200067097811ULL, 0x000fc400078e68ffULL, 0x00000002ff037819ULL, 0x102fe40000011602ULL,
0x00000003ff057819ULL, 0x000fe40000011602ULL, 0x0000007f03047812ULL, 0x040fe400078ec0ffULL,
0x0000000803067810ULL, 0x040fe40007ffe0ffULL, 0x0000001003087810ULL, 0x040fe40007ffe0ffULL,
0x00000018030c7810ULL, 0x000fc40007ffe0ffULL, 0x00000020030f7810ULL, 0x040fe40007ffe0ffULL,
0x0000002803127810ULL, 0x040fe40007ffe0ffULL, 0x0000003003137810ULL, 0x040fe40007ffe0ffULL,
0x0000003803157810ULL, 0x000fe20007ffe0ffULL, 0x0000000111037824ULL, 0x040fe200078e0204ULL,
0x0000007f06047812ULL, 0x040fe200078ec0ffULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x0000007f080a7812ULL, 0x040fe200078ec0ffULL, 0x0000000408087824ULL, 0x000fe200078e00ffULL,
0x0000007f0c0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000111077824ULL, 0x000fe200078e0204ULL,
0x0000007f0f107812ULL, 0x000fe200078ec0ffULL, 0x00000001110b7824ULL, 0x000fe200078e020aULL,
0x0000007f12147812ULL, 0x000fe200078ec0ffULL, 0x0000001002047824ULL, 0x000fe200078e00ffULL,
0x0000000305057812ULL, 0x000fe200078e4802ULL, 0x00000001110d7824ULL, 0x040fe200078e020eULL,
0x0000001411217210ULL, 0x000fe20007ffe0ffULL, 0x000000040c0a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc05027812ULL, 0x000fe200078ef802ULL, 0x00000001111d7824ULL, 0x000fe200078e0210ULL,
0x00000002120e7819ULL, 0x000fe200000006ffULL, 0x000000040f0c7824ULL, 0x000fe200078e00ffULL,
0x0000007f15187812ULL, 0x040fe200078ec0ffULL, 0x0000000415147824ULL, 0x000fe200078e00ffULL,
0x0000007f13167812ULL, 0x040fe200078ec0ffULL, 0x00000200ff107424ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x100fe200078ee205ULL, 0x0000000413127824ULL, 0x000fe200078e00ffULL,
0xfffffffc08087812ULL, 0x000fe200078ee205ULL, 0x0000001002157824ULL, 0x000fe200078e0209ULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee205ULL, 0x00005e0003027625ULL, 0x000fe200078e0010ULL,
0xfffffffc0c0c7812ULL, 0x000fc400078ee205ULL, 0xfffffffc0e0e7812ULL, 0x000fe200078ee205ULL,
0x0000001006177824ULL, 0x000fe200078e0209ULL, 0xfffffffc14147812ULL, 0x000fe200078ee205ULL,
0x0000001008197824ULL, 0x000fe200078e0209ULL, 0xfffffffc12127812ULL, 0x000fe200078ee205ULL,
0x000000100a1b7824ULL, 0x100fe200078e0209ULL, 0x0000003004137812ULL, 0x000fe200078ec0ffULL,
0x000000100c1f7824ULL, 0x100fe200078e0209ULL, 0x0000000912277211ULL, 0x000fe200078e20ffULL,
0x000000100e237824ULL, 0x100fe200078e0209ULL, 0x0000001302027210ULL, 0x000fe20007f1e0ffULL,
0x0000001014297824ULL, 0x000fc400078e0209ULL, 0x00005e000d087625ULL, 0x000fc800078e0010ULL,
0x00005e0007047625ULL, 0x000fc800078e0010ULL, 0x00005e000b067625ULL, 0x000fe200078e0010ULL,
0x0000001304047210ULL, 0x000fc60007f3e0ffULL, 0x0000000111257824ULL, 0x040fe200078e0216ULL,
0x0000001306067210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000001308087210ULL, 0x000fe20007f1e0ffULL, 0x0000000111117824ULL, 0x000fe400078e0218ULL,
0x00005e001d0a7625ULL, 0x080fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e6000b901c46ULL, 0x00005e00210c7625ULL, 0x000fc800078e0010ULL,
0x00005e00250e7625ULL, 0x000fc800078e0010ULL, 0x00005e0011107625ULL, 0x000fc800078e0010ULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000130a0a7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x000000130c0c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x000000130e0e7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000001310107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000000004177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x00000011ff117210ULL, 0x000fc40001ffe4ffULL,
0x0000000006197faeULL, 0x0003e8000b901c46ULL, 0x00000000081b7faeULL, 0x0003e8000b901c46ULL,
0x000000000a1f7faeULL, 0x0003e8000b901c46ULL, 0x000000000c237faeULL, 0x0003e8000b901c46ULL,
0x000000000e277faeULL, 0x0003e8000b901c46ULL, 0x0000000010297faeULL, 0x0003e4000b901c46ULL,
0x01460400ff027984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000002ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000030000735dULL, 0x004fe40003800000ULL, 0x01460400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000646900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000640062627a24ULL, 0x000fe200078e02ffULL, 0xffffffff64607810ULL, 0x000fe20007ffe0ffULL,
0x0000001067617824ULL, 0x000fe200078e00ffULL, 0x00007610ff177816ULL, 0x000fe20000000017ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000704047899ULL, 0x000fe4000800063fULL,
0x0000010069037824ULL, 0x008fe200078e0263ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000036800720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000169057810ULL, 0x000fe20007ffe0ffULL, 0x00000b2000007945ULL, 0x000fe20003800000ULL,
0x00000200ff047424ULL, 0x000fe400078e00ffULL, 0x000000640500720cULL, 0x000fe40003f06070ULL,
0x0000004003057812ULL, 0x000fca00078ec0ffULL, 0x0000000100057824ULL, 0x000fcc00078e0205ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0000000482157c24ULL, 0x000fe2000f8e0205ULL,
0x00000002ff057819ULL, 0x102fe20000011602ULL, 0x0000000168147824ULL, 0x000fe200078e0a03ULL,
0x00000003ff197819ULL, 0x000fe40000011602ULL, 0x0000000805067810ULL, 0x040fe40007ffe0ffULL,
0x0000007f05077812ULL, 0x000fe400078ec0ffULL, 0x0000000219097212ULL, 0x000fe400078e3cffULL,
0x0000007f06087812ULL, 0x000fe200078ec0ffULL, 0x00000001079b7824ULL, 0x000fe200078e0215ULL,
0x0000000302827812ULL, 0x000fc400078ec0ffULL, 0x0000000309837812ULL, 0x000fe200078ec0ffULL,
0x0000000108997824ULL, 0x000fe200078e0215ULL, 0x000000140500720cULL, 0x000fe20003f26070ULL,
0x00005e009b9a7625ULL, 0x000fe200078e0004ULL, 0x00000002060a7819ULL, 0x040fe400000006ffULL,
0x000000140600720cULL, 0x000fe20003f46070ULL, 0x00005e0099987625ULL, 0x000fe200078e0004ULL,
0x0000300067167811ULL, 0x000fe400078e68ffULL, 0x0000000482237812ULL, 0x000fc400078efcffULL,
0x0ffffffc838a7812ULL, 0x000fe400078ef802ULL, 0xfffffffc0a897812ULL, 0x000fe200078ee283ULL,
0x0000001023107825ULL, 0x000fe200078e009aULL, 0x00000018050a7810ULL, 0x040fe40007ffe0ffULL,
0x0000001005097810ULL, 0x040fe20007ffe0ffULL, 0x000000108a0f7824ULL, 0x100fe200078e0216ULL,
0x00000028050c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010891b7824ULL, 0x000fe200078e0216ULL,
0x00000020050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001023127825ULL, 0x000fe200078e0098ULL,
0x00000030050d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e2000c901c46ULL, 0x00000038050e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000409887824ULL, 0x040fe200078e00ffULL, 0x000000140900720cULL, 0x080fe20003f26070ULL,
0x00000000121b7faeULL, 0x0005e2000d101c46ULL, 0x000000040b867824ULL, 0x000fe200078e00ffULL,
0x000000140a00720cULL, 0x080fe20003f46070ULL, 0x000000040d847824ULL, 0x000fe200078e00ffULL,
0x000000140b00720cULL, 0x000fc40003f66070ULL, 0x000000140c00720cULL, 0x080fe40003f86070ULL,
0x0000007f090f7812ULL, 0x002fe200078ec0ffULL, 0x000000040a107824ULL, 0x000fe200078e00ffULL,
0x000000140d00720cULL, 0x080fe20003fa6070ULL, 0x000000040c127824ULL, 0x004fe200078e00ffULL,
0x000000140e00720cULL, 0x040fe20003fc6070ULL, 0x000000010f977824ULL, 0x000fe200078e0215ULL,
0x000000020e147819ULL, 0x000fe400000006ffULL, 0xfffffffc10877812ULL, 0x000fe200078ee283ULL,
0x00005e0097967625ULL, 0x000fe200078e0004ULL, 0x0000007f0a107812ULL, 0x000fc400078ec0ffULL,
0xfffffffc12857812ULL, 0x000fe400078ee283ULL, 0x0000007f0b117812ULL, 0x000fe200078ec0ffULL,
0x0000000110957824ULL, 0x000fe200078e0215ULL, 0xfffffffc88887812ULL, 0x000fe200078ee283ULL,
0x00000010231a7825ULL, 0x000fe200078e0096ULL, 0xfffffffc86867812ULL, 0x100fe400078ee283ULL,
0xfffffffc84847812ULL, 0x000fe200078ee283ULL, 0x0000000111937824ULL, 0x000fe200078e0215ULL,
0x0000007f0c127812ULL, 0x000fe200078ec0ffULL, 0x00000010881d7824ULL, 0x000fe200078e0216ULL,
0xfffffffc14837812ULL, 0x000fe200078ee283ULL, 0x00005e0095947625ULL, 0x000fe200078e0004ULL,
0x0000007f0d137812ULL, 0x000fc400078ec0ffULL, 0x0000007f0e147812ULL, 0x000fe200078ec0ffULL,
0x0000000112917824ULL, 0x100fe200078e0215ULL, 0x000000001a1d7faeULL, 0x0003e2000c901c46ULL,
0x00000001138f7824ULL, 0x100fe200078e0215ULL, 0x0000001685277211ULL, 0x000fe200078e20ffULL,
0x00000001148d7824ULL, 0x000fe400078e0215ULL, 0x00005e0093927625ULL, 0x000fc800078e0004ULL,
0x00005e0091907625ULL, 0x000fc800078e0004ULL, 0x00005e008f8e7625ULL, 0x000fc800078e0004ULL,
0x00005e008d8c7625ULL, 0x000fc800078e0004ULL, 0x0000001087157824ULL, 0x000fe400078e0216ULL,
0x00000010231a7825ULL, 0x002fc800078e0094ULL, 0x0000001086257824ULL, 0x000fe200078e0216ULL,
0x000000001a157faeULL, 0x0003e2000d101c46ULL, 0x00000010231c7825ULL, 0x000fc800078e0092ULL,
0x00000010231e7825ULL, 0x040fe200078e0090ULL, 0x000000001c257faeULL, 0x0003e6000d901c46ULL,
0x0000001084297824ULL, 0x000fe200078e0216ULL, 0x000000001e277faeULL, 0x0003e2000e101c46ULL,
0x0000001023207825ULL, 0x000fc800078e008eULL, 0x00000010832b7824ULL, 0x000fe200078e0216ULL,
0x0000000020297faeULL, 0x0003e2000e901c46ULL, 0x0000001023227825ULL, 0x000fca00078e008cULL,
0x00000000222b7faeULL, 0x0003e2000f101c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000000482157c24ULL, 0x000fe2000f8e0205ULL, 0x00000002ff057819ULL, 0x102fe40000011602ULL,
0x00000003ff197819ULL, 0x000fe40000011602ULL, 0x0000000805067810ULL, 0x000fe40007ffe0ffULL,
0x0000000219087212ULL, 0x000fe400078e3cffULL, 0x00000018050a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000406107824ULL, 0x000fe200078e00ffULL, 0x0000001005097810ULL, 0x000fc40007ffe0ffULL,
0x00000028050c7810ULL, 0x040fe20007ffe0ffULL, 0x000000040a127824ULL, 0x000fe200078e00ffULL,
0x0000007f05077812ULL, 0x000fe200078ec0ffULL, 0x0000000409887824ULL, 0x000fe200078e00ffULL,
0x0000000308837812ULL, 0x000fe200078ec0ffULL, 0x000000040c147824ULL, 0x000fe200078e00ffULL,
0x0000007f06087812ULL, 0x000fe200078ec0ffULL, 0x00000001079b7824ULL, 0x100fe200078e0215ULL,
0x0000007f090f7812ULL, 0x000fe400078ec0ffULL, 0x00000020050b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000108997824ULL, 0x100fe200078e0215ULL, 0x00000030050d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f977824ULL, 0x000fe200078e0215ULL, 0xfffffffc10897812ULL, 0x000fe200078ee283ULL,
0x00005e009b9a7625ULL, 0x000fe200078e0004ULL, 0x0000000302827812ULL, 0x000fc400078ec0ffULL,
0x00000038050e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0099987625ULL, 0x080fe200078e0004ULL,
0x0000007f0a107812ULL, 0x000fe400078ec0ffULL, 0xfffffffc12877812ULL, 0x000fe200078ee283ULL,
0x00005e0097967625ULL, 0x080fe200078e0004ULL, 0x0000007f0b117812ULL, 0x040fe400078ec0ffULL,
0x0000007f0c127812ULL, 0x000fe200078ec0ffULL, 0x0000000110957824ULL, 0x000fe200078e0215ULL,
0xfffffffc14857812ULL, 0x000fe200078ee283ULL, 0x000000040b867824ULL, 0x000fe200078e00ffULL,
0x0000007f0d137812ULL, 0x000fe200078ec0ffULL, 0x0000000111937824ULL, 0x100fe200078e0215ULL,
0x0000300067167811ULL, 0x000fe200078e68ffULL, 0x000000040e187824ULL, 0x000fe200078e00ffULL,
0x0000000482237812ULL, 0x000fe200078efcffULL, 0x00000001138f7824ULL, 0x000fe200078e0215ULL,
0x0ffffffc838a7812ULL, 0x000fe200078ef802ULL, 0x00005e0095947625ULL, 0x000fe200078e0004ULL,
0x0000007f0e147812ULL, 0x000fc400078ec0ffULL, 0xfffffffc88887812ULL, 0x000fe200078ee283ULL,
0x000000108a217824ULL, 0x000fe200078e0216ULL, 0x0000001512917210ULL, 0x000fe20007ffe0ffULL,
0x00000010231a7825ULL, 0x000fe200078e009aULL, 0x000000020d847819ULL, 0x000fe400000006ffULL,
0xfffffffc86867812ULL, 0x000fe200078ee283ULL, 0x00000001148d7824ULL, 0x000fe200078e0215ULL,
0xfffffffc84847812ULL, 0x100fe200078ee283ULL, 0x0000001089257824ULL, 0x000fe200078e0216ULL,
0xfffffffc18837812ULL, 0x000fe200078ee283ULL, 0x00000010231c7825ULL, 0x000fe200078e0098ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a217faeULL, 0x0003e6000b901c46ULL,
0x00005e0093927625ULL, 0x000fe200078e0004ULL, 0x000000001c257faeULL, 0x0005e6000b901c46ULL,
0x0000001088277824ULL, 0x000fc400078e0216ULL, 0x00000010231e7825ULL, 0x000fc800078e0096ULL,
0x00005e0091907625ULL, 0x080fe200078e0004ULL, 0x000000001e277faeULL, 0x0007e6000b901c46ULL,
0x00005e008f8e7625ULL, 0x000fc800078e0004ULL, 0x00005e008d8c7625ULL, 0x000fc800078e0004ULL,
0x0000001087157824ULL, 0x000fe400078e0216ULL, 0x00000010231a7825ULL, 0x002fc800078e0094ULL,
0x0000001086257824ULL, 0x004fe200078e0216ULL, 0x000000001a157faeULL, 0x0003e2000b901c46ULL,
0x00000010231c7825ULL, 0x000fc800078e0092ULL, 0x0000001085277824ULL, 0x008fe200078e0216ULL,
0x000000001c257faeULL, 0x0003e2000b901c46ULL, 0x00000010231e7825ULL, 0x000fc800078e0090ULL,
0x0000001084297824ULL, 0x000fe200078e0216ULL, 0x000000001e277faeULL, 0x0003e2000b901c46ULL,
0x0000001023207825ULL, 0x000fc800078e008eULL, 0x00000010832b7824ULL, 0x000fe200078e0216ULL,
0x0000000020297faeULL, 0x0003e2000b901c46ULL, 0x0000001023227825ULL, 0x000fca00078e008cULL,
0x00000000222b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000007021b7812ULL, 0x002fe400078ec0ffULL,
0x00000004ff157819ULL, 0x100fe40000011602ULL, 0x000000081b167812ULL, 0x000fc800078ef802ULL,
0x00000007151d7812ULL, 0x000fca00078e7816ULL, 0x0000002016187824ULL, 0x000fca00078e021dULL,
0x0000000418187819ULL, 0x000fe200000006ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000008151a7824ULL, 0x000fe200078e00ffULL,
0x000000001834783bULL, 0x0003e20000000200ULL, 0x00002000678b7824ULL, 0x000fe200078e00ffULL,
0x000008b000007945ULL, 0x000fe40003800000ULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee21bULL,
0x000020008b737810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff1b7819ULL, 0x000fe2000001161aULL,
0x000000041a1d7824ULL, 0x040fe200078e00ffULL, 0x000000201a1e7810ULL, 0x000fc40007ffe0ffULL,
0x000000101a1c7810ULL, 0x040fe40007ffe0ffULL, 0x000000301a227810ULL, 0x000fe20007ffe0ffULL,
0x000000041e217824ULL, 0x000fe200078e00ffULL, 0x000000031b1a7812ULL, 0x000fe200078ec0ffULL,
0x000000041c1f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff1b7819ULL, 0x000fe2000001161cULL,
0x0000000422237824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fe4000001161eULL,
0x00000001ff1e7819ULL, 0x000fc40000011622ULL, 0x000000031b1c7812ULL, 0x000fe400078ec0ffULL,
0x0000000320207812ULL, 0x000fe400078ec0ffULL, 0x000000031e1e7812ULL, 0x000fe400078ec0ffULL,
0x000000011a727812ULL, 0x100fe400078e7819ULL, 0x000000011c4e7812ULL, 0x100fe400078e7819ULL,
0x0000000120707812ULL, 0x000fc400078e7819ULL, 0x000000011e4c7812ULL, 0x000fe400078e7819ULL,
0x0000001d72727212ULL, 0x000fe400078efcffULL, 0x0000001f4e4e7212ULL, 0x000fe400078efcffULL,
0x0000002170707212ULL, 0x000fe200078efcffULL, 0x0000001072817824ULL, 0x100fe200078e0273ULL,
0x000000234c4c7212ULL, 0x000fe200078efcffULL, 0x000000104e807824ULL, 0x000fe200078e0273ULL,
0x00000073707f7211ULL, 0x000fc400078e20ffULL, 0x000000008140783bULL, 0x000ea20000000200ULL,
0x000000104c7e7824ULL, 0x000fe200078e0273ULL, 0x00000002151b7810ULL, 0x000fe40007ffe0ffULL,
0x00000000803c783bULL, 0x000ee20000000200ULL, 0x0000000119197812ULL, 0x000fe400078ec0ffULL,
0x000000071b1b7812ULL, 0x000fe200078e7816ULL, 0x000000007f38783bULL, 0x000f220000000200ULL,
0x000000021a6e7812ULL, 0x100fe400078e1e19ULL, 0x000000021c9e7812ULL, 0x100fe200078e1e19ULL,
0x000000007e48783bULL, 0x000f620000000200ULL, 0x00000002206c7812ULL, 0x000fe200078e1e19ULL,
0x0000002016187824ULL, 0x002fe200078e021bULL, 0x000000021e9c7812ULL, 0x000fc400078e1e19ULL,
0x0000001d6e6e7212ULL, 0x000fe200078efcffULL, 0x0000001018207824ULL, 0x000fe200078e00ffULL,
0x0000001f9e9e7212ULL, 0x000fe400078efcffULL, 0x000000216c6c7212ULL, 0x000fe200078efcffULL,
0x000000106e7d7824ULL, 0x100fe200078e0273ULL, 0x000000239c9c7212ULL, 0x000fe200078efcffULL,
0x000000109e7c7824ULL, 0x100fe200078e0273ULL, 0x000000002020783bULL, 0x000fe20000000200ULL,
0x000000106c7b7824ULL, 0x100fe400078e0273ULL, 0x000000109c6a7824ULL, 0x000fe200078e0273ULL,
0x000000007d44783bULL, 0x000e680000000200ULL, 0x000000007c30783bULL, 0x000e680000000200ULL,
0x000000007b28783bULL, 0x000e620000000200ULL, 0x00000040342c723cULL, 0x044fe600000418ffULL,
0x000000006a18783bULL, 0x000eaa0000000200ULL, 0x0000003c3454723cULL, 0x048ff000000418ffULL,
0x00000038341c723cULL, 0x050ff000000418ffULL, 0x000000423440723cULL, 0x040ff000000418ffULL,
0x0000003e343c723cULL, 0x040ff000000418ffULL, 0x0000003a3438723cULL, 0x040ff000000418ffULL,
0x000000483424723cULL, 0x060ff000000418ffULL, 0x0000004a3434723cULL, 0x000ff000000418ffULL,
0x00000044202c723cULL, 0x042ff0000004182cULL, 0x000000302054723cULL, 0x040ff00000041854ULL,
0x00000028201c723cULL, 0x040ff0000004181cULL, 0x000000462044723cULL, 0x040ff00000041840ULL,
0x000000322030723cULL, 0x040ff0000004183cULL, 0x0000002a2028723cULL, 0x040ff00000041838ULL,
0x000000182024723cULL, 0x044ff00000041824ULL, 0x0000001a2020723cULL, 0x000fe20000041834ULL,
0x0000026000008947ULL, 0x000fee0003800000ULL, 0x0000000168347824ULL, 0x000fe200078e0a03ULL,
0x00000008823d7812ULL, 0x000fe200078efcffULL, 0x0000001089797824ULL, 0x100fe200078e0273ULL,
0x000000738a7a7211ULL, 0x000fe200078e20ffULL, 0x0000001088787824ULL, 0x000fe200078e0273ULL,
0x000000340500720cULL, 0x080fe20003f46070ULL, 0x000000103d1a7825ULL, 0x000fe200078e009aULL,
0x000000340600720cULL, 0x000fc40003f66070ULL, 0x000000340900720cULL, 0x080fe20003f26070ULL,
0x000000103d187825ULL, 0x000fe200078e0098ULL, 0x000000340c00720cULL, 0x080fe40003f86070ULL,
0x000000340d00720cULL, 0x080fe20003fa6070ULL, 0x000000103d3a7825ULL, 0x000fe200078e0096ULL,
0x000000340e00720cULL, 0x000fc60003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a7a7faeULL, 0x0003e2000d101c46ULL, 0x000000340a00720cULL, 0x080fe20003f46070ULL,
0x0000001087777824ULL, 0x000fe400078e0273ULL, 0x0000000018797faeULL, 0x0005e2000d901c46ULL,
0x000000340b00720cULL, 0x000fe20003f66070ULL, 0x000000103d387825ULL, 0x000fe400078e0094ULL,
0x000000003a787faeULL, 0x0007e4000c901c46ULL, 0x0000001086767824ULL, 0x000fc400078e0273ULL,
0x000000103d367825ULL, 0x000fe400078e0092ULL, 0x0000000038777faeULL, 0x0007e4000d101c46ULL,
0x0000001085757824ULL, 0x000fe400078e0273ULL, 0x000000103d347825ULL, 0x040fe200078e0090ULL,
0x0000000036767faeULL, 0x0007e6000d901c46ULL, 0x0000001084747824ULL, 0x000fe200078e0273ULL,
0x0000000034757faeULL, 0x0007e2000e101c46ULL, 0x000000103d1a7825ULL, 0x002fc800078e008eULL,
0x0000001083737824ULL, 0x000fe200078e0273ULL, 0x000000001a747faeULL, 0x0007e2000e901c46ULL,
0x000000103d187825ULL, 0x004fca00078e008cULL, 0x0000000018737faeULL, 0x0007e2000f101c46ULL,
0x000001c000007947ULL, 0x000fea0003800000ULL, 0x00000008823d7812ULL, 0x000fe200078efcffULL,
0x000000108a7a7824ULL, 0x100fe200078e0273ULL, 0x0000007389797211ULL, 0x000fe200078e20ffULL,
0x0000001088787824ULL, 0x000fe400078e0273ULL, 0x000000103d1a7825ULL, 0x000fc800078e009aULL,
0x000000103d187825ULL, 0x040fe200078e0098ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a7a7faeULL, 0x0003e6000b901c46ULL, 0x000000103d3a7825ULL, 0x000fe200078e0096ULL,
0x0000000018797faeULL, 0x0005e6000b901c46ULL, 0x0000001087777824ULL, 0x000fe200078e0273ULL,
0x000000003a787faeULL, 0x0007e2000b901c46ULL, 0x000000103d387825ULL, 0x000fc800078e0094ULL,
0x0000001086767824ULL, 0x000fe200078e0273ULL, 0x0000000038777faeULL, 0x0007e2000b901c46ULL,
0x000000103d367825ULL, 0x000fc800078e0092ULL, 0x0000001085757824ULL, 0x000fe200078e0273ULL,
0x0000000036767faeULL, 0x0007e2000b901c46ULL, 0x000000103d347825ULL, 0x000fc800078e0090ULL,
0x0000001084747824ULL, 0x000fe200078e0273ULL, 0x0000000034757faeULL, 0x0007e2000b901c46ULL,
0x000000103d1a7825ULL, 0x002fc800078e008eULL, 0x0000001083737824ULL, 0x000fe200078e0273ULL,
0x000000001a747faeULL, 0x0007e2000b901c46ULL, 0x000000103d187825ULL, 0x004fca00078e008cULL,
0x0000000018737faeULL, 0x0007e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000415197810ULL, 0x008fe20007ffe0ffULL,
0x000006f000007945ULL, 0x000fe20003800000ULL, 0x000030008b8b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000719197812ULL, 0x100fe400078e7816ULL, 0x00000006151b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001072727824ULL, 0x000fe200078e028bULL, 0x0000008b9c6b7211ULL, 0x000fe200078e20ffULL,
0x0000002016197824ULL, 0x000fe200078e0219ULL, 0x000000071b1b7812ULL, 0x000fe200078e7816ULL,
0x000000104e717824ULL, 0x000fc400078e028bULL, 0x0000001070707824ULL, 0x100fe200078e028bULL,
0x0000000419197819ULL, 0x000fe200000006ffULL, 0x000000104c6f7824ULL, 0x000fe400078e028bULL,
0x00000020161b7824ULL, 0x000fe400078e021bULL, 0x000000106e6e7824ULL, 0x000fe400078e028bULL,
0x000000101b347824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000725c783bULL, 0x000fe20000000200ULL, 0x000000109e6d7824ULL, 0x100fe400078e028bULL,
0x000000106c6c7824ULL, 0x000fe200078e028bULL, 0x000000001948783bULL, 0x000e680000000200ULL,
0x000000007158783bULL, 0x000ea80000000200ULL, 0x000000007050783bULL, 0x000ee80000000200ULL,
0x000000006f4c783bULL, 0x000f280000000200ULL, 0x000000006e40783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000f680000000200ULL, 0x000000006d3c783bULL, 0x000f280000000200ULL,
0x000000006c38783bULL, 0x000f280000000200ULL, 0x000000006b18783bULL, 0x000f220000000200ULL,
0x0000005c482c723cULL, 0x042ff0000004182cULL, 0x000000584854723cULL, 0x044ff00000041854ULL,
0x00000050481c723cULL, 0x048ff0000004181cULL, 0x0000005e4844723cULL, 0x040ff00000041844ULL,
0x0000005a4830723cULL, 0x040ff00000041830ULL, 0x000000524828723cULL, 0x040ff00000041828ULL,
0x0000004c4824723cULL, 0x050ff00000041824ULL, 0x0000004e4820723cULL, 0x000ff00000041820ULL,
0x00000040342c723cULL, 0x060ff0000004182cULL, 0x0000003c3454723cULL, 0x040ff00000041854ULL,
0x00000038341c723cULL, 0x040ff0000004181cULL, 0x000000423440723cULL, 0x040ff00000041844ULL,
0x0000003e343c723cULL, 0x040ff00000041830ULL, 0x0000003a3438723cULL, 0x040ff00000041828ULL,
0x000000183424723cULL, 0x040ff00000041824ULL, 0x0000001a3434723cULL, 0x000fe20000041820ULL,
0x0000026000008947ULL, 0x000fee0003800000ULL, 0x0000000168187824ULL, 0x000fe200078e0a03ULL,
0x0000000c82317812ULL, 0x000fe200078efcffULL, 0x000000108a8a7824ULL, 0x100fe200078e028bULL,
0x0000008b83837211ULL, 0x000fe200078e20ffULL, 0x0000001089897824ULL, 0x000fe200078e028bULL,
0x000000180500720cULL, 0x080fe20003f26070ULL, 0x00000010311a7825ULL, 0x000fe200078e009aULL,
0x000000180600720cULL, 0x000fc40003f66070ULL, 0x000000180900720cULL, 0x080fe20003f46070ULL,
0x0000001031207825ULL, 0x000fe200078e0098ULL, 0x000000180c00720cULL, 0x080fe40003f86070ULL,
0x000000180d00720cULL, 0x080fe20003fa6070ULL, 0x0000001088887824ULL, 0x100fe200078e028bULL,
0x000000180e00720cULL, 0x080fe20003fc6070ULL, 0x0000001087877824ULL, 0x000fe400078e028bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a8a7faeULL, 0x0003e2000c901c46ULL,
0x000000180a00720cULL, 0x000fe20003f26070ULL, 0x00000010312a7825ULL, 0x000fc400078e0094ULL,
0x0000000020897faeULL, 0x0005e2000d901c46ULL, 0x000000180b00720cULL, 0x000fe20003f66070ULL,
0x0000001031187825ULL, 0x000fc800078e0096ULL, 0x0000001086867824ULL, 0x000fe200078e028bULL,
0x0000000018887faeULL, 0x0007e2000d101c46ULL, 0x0000001031287825ULL, 0x000fc600078e0092ULL,
0x000000002a877faeULL, 0x0007e2000c901c46ULL, 0x0000001085857824ULL, 0x000fe400078e028bULL,
0x0000001031227825ULL, 0x040fe200078e0090ULL, 0x0000000028867faeULL, 0x0007e6000d901c46ULL,
0x0000001084847824ULL, 0x000fe200078e028bULL, 0x0000000022857faeULL, 0x0007e2000e101c46ULL,
0x0000001031207825ULL, 0x004fc800078e008eULL, 0x00000010311a7825ULL, 0x002fe200078e008cULL,
0x0000000020847faeULL, 0x0007e8000e901c46ULL, 0x000000001a837faeULL, 0x0007e2000f101c46ULL,
0x000001c000007947ULL, 0x000fea0003800000ULL, 0x0000000c82237812ULL, 0x000fe200078efcffULL,
0x000000108a8a7824ULL, 0x100fe400078e028bULL, 0x0000001089897824ULL, 0x000fe400078e028bULL,
0x0000001023207825ULL, 0x000fc800078e009aULL, 0x00000010231a7825ULL, 0x040fe200078e0098ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000208a7faeULL, 0x0003e6000b901c46ULL,
0x0000001088887824ULL, 0x000fe200078e028bULL, 0x000000001a897faeULL, 0x0003e2000b901c46ULL,
0x0000001023187825ULL, 0x000fc800078e0096ULL, 0x0000001087877824ULL, 0x000fe200078e028bULL,
0x0000000018887faeULL, 0x0003e2000b901c46ULL, 0x0000001023327825ULL, 0x000fc800078e0094ULL,
0x0000001086867824ULL, 0x000fe200078e028bULL, 0x0000000032877faeULL, 0x0003e2000b901c46ULL,
0x0000001023307825ULL, 0x000fc800078e0092ULL, 0x0000001085857824ULL, 0x000fe200078e028bULL,
0x0000000030867faeULL, 0x0003e2000b901c46ULL, 0x00000010232a7825ULL, 0x000fc800078e0090ULL,
0x0000001084847824ULL, 0x000fe200078e028bULL, 0x000000002a857faeULL, 0x0003e2000b901c46ULL,
0x0000001023287825ULL, 0x000fc800078e008eULL, 0x0000001083837824ULL, 0x000fe200078e028bULL,
0x0000000028847faeULL, 0x0003e2000b901c46ULL, 0x0000001023227825ULL, 0x000fca00078e008cULL,
0x0000000022837faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000815197810ULL, 0x00afe20007ffe0ffULL,
0x0000056000007945ULL, 0x000fe60003800000ULL, 0x0000000719197812ULL, 0x000fc800078e7816ULL,
0x0000001916197211ULL, 0x000fca00078e28ffULL, 0x0000001019447824ULL, 0x000fe200078e00ffULL,
0x0000000a15197810ULL, 0x000fc80007ffe0ffULL, 0x0000000719197812ULL, 0x000fe200078e7816ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000000815c783bULL, 0x000fe20000000200ULL,
0x0000002016197824ULL, 0x000fc600078e0219ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000001019287824ULL, 0x000fc600078e00ffULL, 0x000000008050783bULL, 0x000ea80000000200ULL,
0x000000007f4c783bULL, 0x000ee80000000200ULL, 0x000000007e48783bULL, 0x000f280000000200ULL,
0x000000007d58783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000007c18783bULL, 0x000f280000000200ULL, 0x000000007b20783bULL, 0x000f280000000200ULL,
0x000000006a30783bULL, 0x000f220000000200ULL, 0x0000005c442c723cULL, 0x042ff0000004182cULL,
0x000000504454723cULL, 0x044ff00000041854ULL, 0x0000004c441c723cULL, 0x048ff0000004181cULL,
0x0000005e4440723cULL, 0x040ff00000041840ULL, 0x00000052443c723cULL, 0x040ff0000004183cULL,
0x0000004e4438723cULL, 0x040ff00000041838ULL, 0x000000484424723cULL, 0x050ff00000041824ULL,
0x0000004a4434723cULL, 0x000ff00000041834ULL, 0x00000058282c723cULL, 0x060ff0000004182cULL,
0x000000182854723cULL, 0x040ff00000041854ULL, 0x00000020281c723cULL, 0x040ff0000004181cULL,
0x0000005a2858723cULL, 0x040ff00000041840ULL, 0x0000001a2818723cULL, 0x040ff0000004183cULL,
0x000000222820723cULL, 0x040ff00000041838ULL, 0x000000302824723cULL, 0x040ff00000041824ULL,
0x000000322828723cULL, 0x000fe20000041834ULL, 0x000001e000008947ULL, 0x000fee0003800000ULL,
0x0000000168347824ULL, 0x000fe200078e0a03ULL, 0x00000010823d7812ULL, 0x000fc800078efcffULL,
0x000000340500720cULL, 0x080fe20003f46070ULL, 0x000000103d327825ULL, 0x000fe200078e009aULL,
0x000000340600720cULL, 0x080fe40003f66070ULL, 0x000000340900720cULL, 0x080fe20003f26070ULL,
0x000000103d307825ULL, 0x000fe200078e0098ULL, 0x000000340c00720cULL, 0x080fe40003f86070ULL,
0x000000340d00720cULL, 0x080fe20003fa6070ULL, 0x000000103d3a7825ULL, 0x000fe200078e0096ULL,
0x000000340e00720cULL, 0x000fc60003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000327a7faeULL, 0x0003e2000d101c46ULL, 0x000000340a00720cULL, 0x080fe20003f46070ULL,
0x000000103d387825ULL, 0x000fe400078e0094ULL, 0x0000000030797faeULL, 0x0005e2000d901c46ULL,
0x000000340b00720cULL, 0x000fe20003f66070ULL, 0x000000103d367825ULL, 0x040fe400078e0092ULL,
0x000000003a787faeULL, 0x0007e4000c901c46ULL, 0x000000103d347825ULL, 0x000fc800078e0090ULL,
0x000000103d327825ULL, 0x042fe200078e008eULL, 0x0000000038777faeULL, 0x0007e6000d101c46ULL,
0x000000103d307825ULL, 0x004fe200078e008cULL, 0x0000000036767faeULL, 0x0007e8000d901c46ULL,
0x0000000034757faeULL, 0x0007e8000e101c46ULL, 0x0000000032747faeULL, 0x0007e8000e901c46ULL,
0x0000000030737faeULL, 0x0007e2000f101c46ULL, 0x0000014000007947ULL, 0x000fea0003800000ULL,
0x0000001082317812ULL, 0x000fca00078efcffULL, 0x00000010313e7825ULL, 0x000fc800078e009aULL,
0x00000010313c7825ULL, 0x040fe200078e0098ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e7a7faeULL, 0x0003e6000b901c46ULL, 0x00000010313a7825ULL, 0x040fe200078e0096ULL,
0x000000003c797faeULL, 0x0003e6000b901c46ULL, 0x0000001031387825ULL, 0x040fe200078e0094ULL,
0x000000003a787faeULL, 0x0003e6000b901c46ULL, 0x0000001031367825ULL, 0x040fe200078e0092ULL,
0x0000000038777faeULL, 0x0003e6000b901c46ULL, 0x0000001031347825ULL, 0x040fe200078e0090ULL,
0x0000000036767faeULL, 0x0003e6000b901c46ULL, 0x0000001031327825ULL, 0x040fe200078e008eULL,
0x0000000034757faeULL, 0x0003e6000b901c46ULL, 0x0000001031307825ULL, 0x000fe200078e008cULL,
0x0000000032747faeULL, 0x0003e8000b901c46ULL, 0x0000000030737faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000c15317810ULL, 0x00afe20007ffe0ffULL, 0x0000056000007945ULL, 0x000fe60003800000ULL,
0x0000000731317812ULL, 0x000fca00078e7816ULL, 0x0000002016317824ULL, 0x000fc800078e0231ULL,
0x0000001031447824ULL, 0x000fe200078e00ffULL, 0x0000000e15317810ULL, 0x000fc80007ffe0ffULL,
0x0000000731317812ULL, 0x000fe200078e7816ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000725c783bULL, 0x000fe20000000200ULL, 0x0000002016317824ULL, 0x000fc600078e0231ULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x0000001031317824ULL, 0x000fc600078e00ffULL,
0x000000007150783bULL, 0x000ea80000000200ULL, 0x00000000704c783bULL, 0x000ee80000000200ULL,
0x000000006f48783bULL, 0x000f280000000200ULL, 0x000000006e40783bULL, 0x000fe80000000200ULL,
0x000000003130783bULL, 0x000f680000000200ULL, 0x000000006d3c783bULL, 0x000ee80000000200ULL,
0x000000006c38783bULL, 0x000ee80000000200ULL, 0x000000006b34783bULL, 0x000ee20000000200ULL,
0x0000005c442c723cULL, 0x042ff0000004182cULL, 0x0000005e4458723cULL, 0x040ff00000041858ULL,
0x000000504454723cULL, 0x044ff00000041854ULL, 0x000000524418723cULL, 0x040ff00000041818ULL,
0x0000004c441c723cULL, 0x048ff0000004181cULL, 0x0000004e4420723cULL, 0x040ff00000041820ULL,
0x000000484424723cULL, 0x050ff00000041824ULL, 0x0000004a4428723cULL, 0x000ff00000041828ULL,
0x00000040302c723cULL, 0x060ff0000004182cULL, 0x000000423058723cULL, 0x040ff00000041858ULL,
0x0000003c3054723cULL, 0x040ff00000041854ULL, 0x0000003e3018723cULL, 0x040ff00000041818ULL,
0x00000038301c723cULL, 0x040ff0000004181cULL, 0x0000003a3020723cULL, 0x040ff00000041820ULL,
0x000000343024723cULL, 0x040ff00000041824ULL, 0x000000363030723cULL, 0x000fe20000041828ULL,
0x000001e000008947ULL, 0x000fee0003800000ULL, 0x8000000368347210ULL, 0x000fe40007ffe0ffULL,
0x00000014823d7812ULL, 0x000fc400078efcffULL, 0x000000340500720cULL, 0x080fe40003f46070ULL,
0x000000340600720cULL, 0x080fe20003f66070ULL, 0x000000103d2a7825ULL, 0x000fe200078e009aULL,
0x000000340900720cULL, 0x080fe40003f26070ULL, 0x000000340c00720cULL, 0x080fe20003f86070ULL,
0x000000103d287825ULL, 0x000fe200078e0098ULL, 0x000000340d00720cULL, 0x080fe40003fa6070ULL,
0x000000340e00720cULL, 0x000fe20003fc6070ULL, 0x000000103d3a7825ULL, 0x000fc400078e0096ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a8a7faeULL, 0x0003e2000d101c46ULL,
0x000000340a00720cULL, 0x080fe20003f46070ULL, 0x000000103d387825ULL, 0x000fe400078e0094ULL,
0x0000000028897faeULL, 0x0005e2000d901c46ULL, 0x000000340b00720cULL, 0x000fe20003f66070ULL,
0x000000103d367825ULL, 0x040fe400078e0092ULL, 0x000000003a887faeULL, 0x0007e4000c901c46ULL,
0x000000103d347825ULL, 0x000fc800078e0090ULL, 0x000000103d2a7825ULL, 0x042fe200078e008eULL,
0x0000000038877faeULL, 0x0007e6000d101c46ULL, 0x000000103d287825ULL, 0x004fe200078e008cULL,
0x0000000036867faeULL, 0x0007e8000d901c46ULL, 0x0000000034857faeULL, 0x0007e8000e101c46ULL,
0x000000002a847faeULL, 0x0007e8000e901c46ULL, 0x0000000028837faeULL, 0x0007e2000f101c46ULL,
0x0000014000007947ULL, 0x000fea0003800000ULL, 0x0000001482297812ULL, 0x000fca00078efcffULL,
0x00000010293e7825ULL, 0x000fc800078e009aULL, 0x00000010293c7825ULL, 0x040fe200078e0098ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e8a7faeULL, 0x0003e6000b901c46ULL,
0x00000010293a7825ULL, 0x040fe200078e0096ULL, 0x000000003c897faeULL, 0x0003e6000b901c46ULL,
0x0000001029387825ULL, 0x040fe200078e0094ULL, 0x000000003a887faeULL, 0x0003e6000b901c46ULL,
0x0000001029367825ULL, 0x040fe200078e0092ULL, 0x0000000038877faeULL, 0x0003e6000b901c46ULL,
0x0000001029347825ULL, 0x040fe200078e0090ULL, 0x0000000036867faeULL, 0x0003e6000b901c46ULL,
0x00000010292a7825ULL, 0x040fe200078e008eULL, 0x0000000034857faeULL, 0x0003e6000b901c46ULL,
0x0000001029287825ULL, 0x000fe200078e008cULL, 0x000000002a847faeULL, 0x0003e8000b901c46ULL,
0x0000000028837faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001015297810ULL, 0x04afe20007ffe0ffULL,
0x0000056000007945ULL, 0x000fe20003800000ULL, 0x0000001215357810ULL, 0x000fc40007ffe0ffULL,
0x0000000729297812ULL, 0x100fe400078e7816ULL, 0x0000000735357812ULL, 0x000fc600078e7816ULL,
0x0000002016297824ULL, 0x040fe400078e0229ULL, 0x0000002016357824ULL, 0x000fe400078e0235ULL,
0x0000001029487824ULL, 0x000fe400078e00ffULL, 0x0000001035357824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000008128783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x00000000805c783bULL, 0x000ea80000000200ULL,
0x000000007f50783bULL, 0x000ee80000000200ULL, 0x000000007e4c783bULL, 0x000f280000000200ULL,
0x000000007d44783bULL, 0x000fe80000000200ULL, 0x000000003534783bULL, 0x000f680000000200ULL,
0x000000007c40783bULL, 0x000ee80000000200ULL, 0x000000007b3c783bULL, 0x000ee80000000200ULL,
0x000000006a38783bULL, 0x000ee20000000200ULL, 0x00000028482c723cULL, 0x042ff0000004182cULL,
0x0000002a4858723cULL, 0x040ff00000041858ULL, 0x0000005c4854723cULL, 0x044ff00000041854ULL,
0x0000005e4818723cULL, 0x040ff00000041818ULL, 0x00000050481c723cULL, 0x048ff0000004181cULL,
0x000000524820723cULL, 0x040ff00000041820ULL, 0x0000004c4824723cULL, 0x050ff00000041824ULL,
0x0000004e4830723cULL, 0x000ff00000041830ULL, 0x00000044342c723cULL, 0x060ff0000004182cULL,
0x000000463458723cULL, 0x040ff00000041858ULL, 0x000000403454723cULL, 0x040ff00000041854ULL,
0x000000423418723cULL, 0x040ff00000041818ULL, 0x0000003c341c723cULL, 0x040ff0000004181cULL,
0x0000003e3420723cULL, 0x040ff00000041820ULL, 0x000000383424723cULL, 0x040ff00000041824ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x000001e000008947ULL, 0x000fee0003800000ULL,
0x0000000168347824ULL, 0x000fe200078e0a03ULL, 0x00000018823d7812ULL, 0x000fc800078efcffULL,
0x000000340500720cULL, 0x080fe20003f46070ULL, 0x000000103d2a7825ULL, 0x000fe200078e009aULL,
0x000000340600720cULL, 0x080fe40003f66070ULL, 0x000000340900720cULL, 0x080fe20003f26070ULL,
0x000000103d287825ULL, 0x000fe200078e0098ULL, 0x000000340c00720cULL, 0x080fe40003f86070ULL,
0x000000340d00720cULL, 0x080fe20003fa6070ULL, 0x000000103d3a7825ULL, 0x000fe200078e0096ULL,
0x000000340e00720cULL, 0x000fc60003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a7a7faeULL, 0x0003e2000d101c46ULL, 0x000000340a00720cULL, 0x080fe20003f46070ULL,
0x000000103d387825ULL, 0x000fe400078e0094ULL, 0x0000000028797faeULL, 0x0005e2000d901c46ULL,
0x000000340b00720cULL, 0x000fe20003f66070ULL, 0x000000103d367825ULL, 0x040fe400078e0092ULL,
0x000000003a787faeULL, 0x0007e4000c901c46ULL, 0x000000103d347825ULL, 0x000fc800078e0090ULL,
0x000000103d2a7825ULL, 0x042fe200078e008eULL, 0x0000000038777faeULL, 0x0007e6000d101c46ULL,
0x000000103d287825ULL, 0x004fe200078e008cULL, 0x0000000036767faeULL, 0x0007e8000d901c46ULL,
0x0000000034757faeULL, 0x0007e8000e101c46ULL, 0x000000002a747faeULL, 0x0007e8000e901c46ULL,
0x0000000028737faeULL, 0x0007e2000f101c46ULL, 0x0000014000007947ULL, 0x000fea0003800000ULL,
0x0000001882297812ULL, 0x000fca00078efcffULL, 0x00000010293e7825ULL, 0x000fc800078e009aULL,
0x00000010293c7825ULL, 0x040fe200078e0098ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e7a7faeULL, 0x0003e6000b901c46ULL, 0x00000010293a7825ULL, 0x040fe200078e0096ULL,
0x000000003c797faeULL, 0x0003e6000b901c46ULL, 0x0000001029387825ULL, 0x040fe200078e0094ULL,
0x000000003a787faeULL, 0x0003e6000b901c46ULL, 0x0000001029367825ULL, 0x040fe200078e0092ULL,
0x0000000038777faeULL, 0x0003e6000b901c46ULL, 0x0000001029347825ULL, 0x040fe200078e0090ULL,
0x0000000036767faeULL, 0x0003e6000b901c46ULL, 0x00000010292a7825ULL, 0x040fe200078e008eULL,
0x0000000034757faeULL, 0x0003e6000b901c46ULL, 0x0000001029287825ULL, 0x000fe200078e008cULL,
0x000000002a747faeULL, 0x0003e8000b901c46ULL, 0x0000000028737faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001415297810ULL, 0x04afe20007ffe0ffULL, 0x0000056000007945ULL, 0x000fe20003800000ULL,
0x0000001615357810ULL, 0x000fc40007ffe0ffULL, 0x0000000729297812ULL, 0x100fe400078e7816ULL,
0x0000000735357812ULL, 0x000fc600078e7816ULL, 0x0000002016297824ULL, 0x040fe400078e0229ULL,
0x0000002016357824ULL, 0x000fe400078e0235ULL, 0x0000001029487824ULL, 0x000fc600078e00ffULL,
0x0000000435357819ULL, 0x000fe200000006ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000007228783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000e680000000200ULL,
0x00000000715c783bULL, 0x000ea80000000200ULL, 0x000000007050783bULL, 0x000ee80000000200ULL,
0x000000006f4c783bULL, 0x000f280000000200ULL, 0x000000006e44783bULL, 0x000fe80000000200ULL,
0x000000003534783bULL, 0x000f680000000200ULL, 0x000000006d40783bULL, 0x000ee80000000200ULL,
0x000000006c3c783bULL, 0x000ee80000000200ULL, 0x000000006b38783bULL, 0x000ee20000000200ULL,
0x00000028482c723cULL, 0x042ff0000004182cULL, 0x0000002a4858723cULL, 0x040ff00000041858ULL,
0x0000005c4854723cULL, 0x044ff00000041854ULL, 0x0000005e4818723cULL, 0x040ff00000041818ULL,
0x00000050481c723cULL, 0x048ff0000004181cULL, 0x000000524820723cULL, 0x040ff00000041820ULL,
0x0000004c4824723cULL, 0x050ff00000041824ULL, 0x0000004e4830723cULL, 0x000ff00000041830ULL,
0x00000044342c723cULL, 0x060ff0000004182cULL, 0x000000463458723cULL, 0x040ff00000041858ULL,
0x000000403454723cULL, 0x040ff00000041854ULL, 0x000000423418723cULL, 0x040ff00000041818ULL,
0x0000003c341c723cULL, 0x040ff0000004181cULL, 0x0000003e3420723cULL, 0x040ff00000041820ULL,
0x000000383424723cULL, 0x040ff00000041824ULL, 0x0000003a3430723cULL, 0x000fe20000041830ULL,
0x000001e000008947ULL, 0x000fee0003800000ULL, 0x0000000168287824ULL, 0x000fe200078e0a03ULL,
0x0000001c82297812ULL, 0x000fc800078efcffULL, 0x000000280500720cULL, 0x080fe20003f46070ULL,
0x00000010299a7825ULL, 0x000fe200078e009aULL, 0x000000280600720cULL, 0x080fe40003f26070ULL,
0x000000280900720cULL, 0x080fe20003f06070ULL, 0x0000001029987825ULL, 0x000fe200078e0098ULL,
0x000000280b00720cULL, 0x080fe40003f66070ULL, 0x000000280c00720cULL, 0x080fe20003f86070ULL,
0x0000001029967825ULL, 0x000fe200078e0096ULL, 0x000000280d00720cULL, 0x000fc40003fa6070ULL,
0x000000280e00720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000009a8a7faeULL, 0x0003e2000d101c46ULL, 0x000000280a00720cULL, 0x000fe20003f46070ULL,
0x0000001029947825ULL, 0x040fe400078e0094ULL, 0x0000000098897faeULL, 0x0003e4000c901c46ULL,
0x0000001029927825ULL, 0x040fe400078e0092ULL, 0x0000000096887faeULL, 0x0003e4000c101c46ULL,
0x0000001029907825ULL, 0x000fc800078e0090ULL, 0x00000010298e7825ULL, 0x040fe200078e008eULL,
0x0000000094877faeULL, 0x0003e6000d101c46ULL, 0x00000010298c7825ULL, 0x000fe200078e008cULL,
0x0000000092867faeULL, 0x0003e8000d901c46ULL, 0x0000000090857faeULL, 0x0003e8000e101c46ULL,
0x000000008e847faeULL, 0x0003e8000e901c46ULL, 0x000000008c837faeULL, 0x0003e2000f101c46ULL,
0x0000014000007947ULL, 0x000fea0003800000ULL, 0x0000001c82297812ULL, 0x000fca00078efcffULL,
0x00000010299a7825ULL, 0x000fc800078e009aULL, 0x0000001029987825ULL, 0x040fe200078e0098ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000009a8a7faeULL, 0x0003e6000b901c46ULL,
0x0000001029967825ULL, 0x040fe200078e0096ULL, 0x0000000098897faeULL, 0x0003e6000b901c46ULL,
0x0000001029947825ULL, 0x040fe200078e0094ULL, 0x0000000096887faeULL, 0x0003e6000b901c46ULL,
0x0000001029927825ULL, 0x040fe200078e0092ULL, 0x0000000094877faeULL, 0x0003e6000b901c46ULL,
0x0000001029907825ULL, 0x040fe200078e0090ULL, 0x0000000092867faeULL, 0x0003e6000b901c46ULL,
0x00000010298e7825ULL, 0x040fe200078e008eULL, 0x0000000090857faeULL, 0x0003e6000b901c46ULL,
0x00000010298c7825ULL, 0x000fe200078e008cULL, 0x000000008e847faeULL, 0x0003e8000b901c46ULL,
0x000000008c837faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff287624ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff827424ULL, 0x000fc400078e00ffULL, 0x0000000228657824ULL, 0x000fe200078e0265ULL,
0x0000001815297810ULL, 0x000fc80007ffe0ffULL, 0x000000666500720cULL, 0x000fe40003f06070ULL,
0x0000000729297812ULL, 0x000fca00078e7816ULL, 0x0000002016297824ULL, 0x000fc800078e0229ULL,
0x0000001029487824ULL, 0x000fe400078e00ffULL, 0x0000000262348824ULL, 0x000fe400078e0265ULL,
0x00000004ff358424ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000600034348625ULL, 0x000fe200078e0035ULL, 0x000000008128783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000ea80000000200ULL, 0x00000000805c783bULL, 0x000ee80000000200ULL,
0x000000007f50783bULL, 0x000f280000000200ULL, 0x000000007e4c783bULL, 0x000e680000000200ULL,
0x0000000634828981ULL, 0x000562000c1e1900ULL, 0x0000088000007945ULL, 0x000fe60003800000ULL,
0x000000007d44783bULL, 0x000fe80000000200ULL, 0x000000007c40783bULL, 0x000fe20000000200ULL,
0x0000001a15357810ULL, 0x004fc60007ffe0ffULL, 0x000000007b3c783bULL, 0x000fe20000000200ULL,
0x0000000735357812ULL, 0x000fc600078e7816ULL, 0x000000006a38783bULL, 0x000fe20000000200ULL,
0x0000003516357211ULL, 0x000fca00078e28ffULL, 0x0000001035357824ULL, 0x000fe200078e00ffULL,
0x00000028482c723cULL, 0x040fea000004182cULL, 0x000000003534783bULL, 0x000ea60000000200ULL,
0x0000002a4858723cULL, 0x040ff00000041858ULL, 0x0000005c4854723cULL, 0x048ff00000041854ULL,
0x0000005e4818723cULL, 0x040ff00000041818ULL, 0x00000050481c723cULL, 0x050ff0000004181cULL,
0x000000524820723cULL, 0x040ff00000041820ULL, 0x0000004c4824723cULL, 0x042ff00000041824ULL,
0x0000004e4830723cULL, 0x000ff00000041830ULL, 0x00000044342c723cULL, 0x044ff0000004182cULL,
0x000000463458723cULL, 0x040ff00000041858ULL, 0x000000403454723cULL, 0x040ff00000041854ULL,
0x000000423418723cULL, 0x040ff00000041818ULL, 0x0000003c341c723cULL, 0x040ff0000004181cULL,
0x0000003e3420723cULL, 0x040ff00000041820ULL, 0x000000383424723cULL, 0x040ff00000041824ULL,
0x0000003a3430723cULL, 0x000fee0000041830ULL, 0x0000030069347a10ULL, 0x000fc80007ffe0ffULL,
0x0000000134297810ULL, 0x040fe20007ffe0ffULL, 0x0000010034357824ULL, 0x000fc600078e0263ULL,
0x000000642900720cULL, 0x000fe40003f06070ULL, 0x0000004035297812ULL, 0x000fca00078ec0ffULL,
0x0000000100297824ULL, 0x000fcc00078e0229ULL, 0x0000039000008947ULL, 0x000fea0003800000ULL,
0x0000000482297c24ULL, 0x020fe2000f8e0229ULL, 0x0000003568287217ULL, 0x000fe20007800000ULL,
0x00000010022a7824ULL, 0x000fe400078e00ffULL, 0x0000000107077824ULL, 0x000fe200078e0229ULL,
0x0000002910377210ULL, 0x000fe20007ffe0ffULL, 0x0000000128357824ULL, 0x000fe200078e0a35ULL,
0x000000302a417812ULL, 0x000fe200078ec0ffULL, 0x000000010f0f7824ULL, 0x100fe400078e0229ULL,
0x0000000111397824ULL, 0x000fe200078e0229ULL, 0x000000350900720cULL, 0x080fe20003f06070ULL,
0x00005e0007107625ULL, 0x000fe200078e0004ULL, 0x000000350500720cULL, 0x000fc40003fa6070ULL,
0x000000350600720cULL, 0x000fe20003f86070ULL, 0x00000001082b7824ULL, 0x000fe200078e0229ULL,
0x0000004110287210ULL, 0x000fe20007f3e0ffULL, 0x00005e000f087625ULL, 0x000fe200078e0004ULL,
0x000000350a00720cULL, 0x000fc60003f66070ULL, 0x00005e002b067625ULL, 0x000fe200078e0004ULL,
0x0000004108367210ULL, 0x000fc60007f5e0ffULL, 0x00000001123b7824ULL, 0x100fe400078e0229ULL,
0x00000001133d7824ULL, 0x100fe400078e0229ULL, 0x00000001143f7824ULL, 0x000fe400078e0229ULL,
0x000000ffff297224ULL, 0x000fe200008e0611ULL, 0x00000041062a7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0037107625ULL, 0x000fc600078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000287a7faeULL, 0x0003e2000e901c46ULL, 0x00005e0039127625ULL, 0x000fe200078e0004ULL,
0x00000041100a7210ULL, 0x000fc60007fde0ffULL, 0x000000ffff377224ULL, 0x000fe200010e0609ULL,
0x000000350b00720cULL, 0x000fe20003f46070ULL, 0x00005e003d087625ULL, 0x000fc800078e0004ULL,
0x000000ffff2b7224ULL, 0x000fe200008e0607ULL, 0x0000004112107210ULL, 0x080fe20007f3e0ffULL,
0x00005e003b067625ULL, 0x080fe200078e0004ULL, 0x0000004108087210ULL, 0x080fe40007fbe0ffULL,
0x000000002a797faeULL, 0x0003e2000e101c46ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0611ULL,
0x0000004106067210ULL, 0x000fe20007fde0ffULL, 0x00005e003f047625ULL, 0x000fe200078e0004ULL,
0x00000013ff117210ULL, 0x000fe20000ffe4ffULL, 0x0000000036787faeULL, 0x0003e2000c101c46ULL,
0x000000350c00720cULL, 0x080fe20003f26070ULL, 0x000000ffff097224ULL, 0x000fe200028e0609ULL,
0x000000350d00720cULL, 0x080fe20003f86070ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x000000350e00720cULL, 0x000fe20003fa6070ULL, 0x000000000a777faeULL, 0x0003e2000d901c46ULL,
0x0000004104047210ULL, 0x000fc60007fde0ffULL, 0x0000000010767faeULL, 0x0003e4000d101c46ULL,
0x000000ffff057224ULL, 0x000fe400030e0605ULL, 0x0000000006757faeULL, 0x0003e8000c901c46ULL,
0x0000000008747faeULL, 0x0003e8000e101c46ULL, 0x0000000004737faeULL, 0x0003e2000e901c46ULL,
0x000002e000007947ULL, 0x000fea0003800000ULL, 0x0000000482297c24ULL, 0x020fe4000f8e0229ULL,
0x0000001002057824ULL, 0x000fc400078e00ffULL, 0x0000000107077824ULL, 0x100fe400078e0229ULL,
0x00000001100d7824ULL, 0x000fe200078e0229ULL, 0x0000003005057812ULL, 0x000fe200078ec0ffULL,
0x00005e0007067625ULL, 0x000fc800078e0004ULL, 0x0000000108097824ULL, 0x100fe200078e0229ULL,
0x0000000506067210ULL, 0x000fe20007f1e0ffULL, 0x000000010f0b7824ULL, 0x000fe200078e0229ULL,
0x00000029110f7210ULL, 0x000fe20007ffe0ffULL, 0x00005e000d0c7625ULL, 0x000fc800078e0004ULL,
0x00005e0009087625ULL, 0x000fc800078e0004ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0004ULL,
0x0000000508087210ULL, 0x000fc60007f3e0ffULL, 0x0000000112117824ULL, 0x100fe200078e0229ULL,
0x000000050a0a7210ULL, 0x080fe20007f5e0ffULL, 0x0000000113137824ULL, 0x000fe400078e0229ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x000000050c0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000114297824ULL, 0x000fe400078e0229ULL, 0x00005e000f0e7625ULL, 0x080fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000067a7faeULL, 0x0003e6000b901c46ULL,
0x00005e0011107625ULL, 0x000fc800078e0004ULL, 0x00005e0013127625ULL, 0x000fc800078e0004ULL,
0x00005e0029287625ULL, 0x000fc800078e0004ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x000000050e047210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x00000005100e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000512107210ULL, 0x080fe40007f5e0ffULL, 0x0000000528127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e060fULL, 0x00000011ff0f7210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff117224ULL, 0x000fe200010e0613ULL, 0x0000000008797faeULL, 0x0003e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fc600018e0629ULL, 0x000000000a787faeULL, 0x0003e8000b901c46ULL,
0x000000000c777faeULL, 0x0003e8000b901c46ULL, 0x0000000004767faeULL, 0x0003e8000b901c46ULL,
0x000000000e757faeULL, 0x0003e8000b901c46ULL, 0x0000000010747faeULL, 0x0003e8000b901c46ULL,
0x0000000012737faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001c15057810ULL, 0x002fc40007ffe0ffULL,
0x0000001e15157810ULL, 0x000fe40007ffe0ffULL, 0x0000000705057812ULL, 0x100fe400078e7816ULL,
0x0000000715157812ULL, 0x000fc600078e7816ULL, 0x0000002016057824ULL, 0x040fe400078e0205ULL,
0x0000002016157824ULL, 0x000fe400078e0215ULL, 0x0000001005057824ULL, 0x000fe400078e00ffULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000007208783bULL, 0x000fe80000000200ULL, 0x000000000504783bULL, 0x000e680000000200ULL,
0x00000000710c783bULL, 0x000ea80000000200ULL, 0x000000007010783bULL, 0x000ee80000000200ULL,
0x000000006f38783bULL, 0x000f280000000200ULL, 0x000000001528783bULL, 0x000fe80000000200ULL,
0x000000006c44783bULL, 0x000fe80000000200ULL, 0x000000006e3c783bULL, 0x000fe80000000200ULL,
0x0146140061357984ULL, 0x000fe20000000800ULL, 0x000000080440723cULL, 0x042fe6000004182cULL,
0x000000006d2c783bULL, 0x000e6a0000000200ULL, 0x0000000a0458723cULL, 0x040fe20000041858ULL,
0x000000006b08783bULL, 0x000f6e0000000200ULL, 0x0000000c0454723cULL, 0x044ff00000041854ULL,
0x0000000e0418723cULL, 0x040ff00000041818ULL, 0x00000010040c723cULL, 0x048ff0000004181cULL,
0x000000380424723cULL, 0x050ff00000041824ULL, 0x0000003a0430723cULL, 0x040ff00000041830ULL,
0x000000120420723cULL, 0x000ff00000041820ULL, 0x0000002c2810723cULL, 0x042ff00000041854ULL,
0x00000044280c723cULL, 0x040ff0000004180cULL, 0x000000082804723cULL, 0x060ff00000041824ULL,
0x0000000a2808723cULL, 0x000fe20000041830ULL, 0x3d80000011257820ULL, 0x000fe20000410000ULL,
0x0000ffff17117812ULL, 0x000fe200078ec0ffULL, 0x3d80000010267820ULL, 0x000fca0000410000ULL,
0x0000003c2840723cULL, 0x000fe20000041840ULL, 0x3d8000000f107820ULL, 0x000fce0000410000ULL,
0x0000003e2858723cULL, 0x000fe20000041858ULL, 0x3d800000041e7820ULL, 0x000fe20000410000ULL,
0x3d800000051d7820ULL, 0x000fe20000410000ULL, 0x3d800000060f7820ULL, 0x000fe20000410000ULL,
0x3d80000007157820ULL, 0x000fc80000410000ULL, 0x0000002e282c723cULL, 0x000fe20000041818ULL,
0x3d800000081c7820ULL, 0x000fe20000410000ULL, 0x3d80000009087820ULL, 0x000fe20000410000ULL,
0x3d8000000a147820ULL, 0x000fc80000410000ULL, 0x3d800000131a7820ULL, 0x000fe20000410000ULL,
0x000000462844723cULL, 0x000fe20000041820ULL, 0x3d80000012197820ULL, 0x000fe20000410000ULL,
0x3d8000000e137820ULL, 0x000fe20000410000ULL, 0x3d80000042427820ULL, 0x000fe20000410000ULL,
0x3d80000043437820ULL, 0x000fe20000410000ULL, 0x3d8000000b0e7820ULL, 0x000fe40000410000ULL,
0x3d8000000c227820ULL, 0x000fe20000410000ULL, 0x00008880110c7816ULL, 0x000fe200000000ffULL,
0x3d800000402b7820ULL, 0x000fe20000410000ULL, 0x3d80000041297820ULL, 0x000fe20000410000ULL,
0x3d80000058287820ULL, 0x000fe20000410000ULL, 0x3d80000059277820ULL, 0x000fe20000410000ULL,
0x800000000c047824ULL, 0x000fe200078e00ffULL, 0x3d8000005a5a7820ULL, 0x000fe20000410000ULL,
0x3d8000005b187820ULL, 0x000fe20000410000ULL, 0x3d8000002c247820ULL, 0x000fe20000410000ULL,
0x3d8000002d237820ULL, 0x000fe20000410000ULL, 0x3d8000002e1b7820ULL, 0x000fe20000410000ULL,
0x3d8000002f127820ULL, 0x000fe20000410000ULL, 0x3d8000000d217820ULL, 0x000fe20000410000ULL,
0x8000000035ff7812ULL, 0x000fc60007804804ULL, 0x3d80000044207820ULL, 0x000fe20000410000ULL,
0x3d800000451f7820ULL, 0x000fe20000410000ULL, 0x3d80000046117820ULL, 0x000fe20000410000ULL,
0x3d80000047167820ULL, 0x000fe20000410000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0042ULL,
0x0000004300097202ULL, 0x000fe20000000f00ULL, 0x000000ffff0b7224ULL, 0x000fe200078e005aULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000000c0c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0146140061057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc4000780480cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004020c7824ULL, 0x000fe200078e00ffULL,
0x000000606900720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff00c047812ULL, 0x000fca00078ec0ffULL, 0x00000080670d7824ULL, 0x000fca00078e0204ULL,
0x014400000d047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002022a7824ULL, 0x000fe400078e00ffULL, 0x00000001682e7824ULL, 0x000fc600078e0a03ULL,
0x000000062a2a7812ULL, 0x000fc800078ec0ffULL, 0x000000012a037812ULL, 0x040fe400078efcffULL,
0x000000082a2c7812ULL, 0x040fe400078efcffULL, 0x0000002e0300720cULL, 0x080fe40003f26070ULL,
0x000000102a037812ULL, 0x000fe400078efcffULL, 0x0000002e2c00720cULL, 0x080fe40003f06070ULL,
0x0000002e0300720cULL, 0x000fc40003fc6070ULL, 0x000000112a2c7812ULL, 0x040fe400078efcffULL,
0x000000182a037812ULL, 0x040fe400078efcffULL, 0x0000002e2a00720cULL, 0x080fe40003f46070ULL,
0x0000002e2c00720cULL, 0x080fe40003fa6070ULL, 0x0000002e0300720cULL, 0x000fe40003f66070ULL,
0x000000092a2d7812ULL, 0x000fc400078efcffULL, 0x000000192a2c7812ULL, 0x040fe400078efcffULL,
0x000000202a037812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL, 0xff7fffff09097808ULL, 0x000fe40004800000ULL,
0xff7fffff29297808ULL, 0x000fc40004800000ULL, 0x0000002e2d00720cULL, 0x080fe40003f86070ULL,
0x0000002e2c00720cULL, 0x080fe40003f46070ULL, 0x0000002e0300720cULL, 0x000fe40003f26070ULL,
0x000000212a2c7812ULL, 0x040fe400078efcffULL, 0x000000282a037812ULL, 0x000fe400078efcffULL,
0xff7fffff0b0b7808ULL, 0x000fc40004000000ULL, 0xff7fffff28287808ULL, 0x000fe40004000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fe40006000000ULL,
0x0000002e2c00720cULL, 0x080fe40003f06070ULL, 0x0000002e0300720cULL, 0x000fe40003f86070ULL,
0x000000292a2c7812ULL, 0x000fc400078efcffULL, 0x000000302a037812ULL, 0x000fe400078efcffULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff26267808ULL, 0x000fe40007000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0x0000002e2c00720cULL, 0x000fc40003fc6070ULL, 0x0000002e0300720cULL, 0x000fe40003fa6070ULL,
0x000000312a2c7812ULL, 0x040fe400078efcffULL, 0x000000382a037812ULL, 0x040fe400078efcffULL,
0x000000392a2a7812ULL, 0x000fe400078efcffULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff24247808ULL, 0x000fc40005800000ULL, 0xff7fffff12127808ULL, 0x000fe40005000000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff13137808ULL, 0x000fe40004800000ULL,
0xff7fffff22227808ULL, 0x000fe40004800000ULL, 0x0000002e2c00720cULL, 0x080fe40003f66070ULL,
0x0000002e0300720cULL, 0x000fc40003f46070ULL, 0x0000002e2a00720cULL, 0x000fe40003f26070ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff21217808ULL, 0x000fe40004000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0xff7fffff20207808ULL, 0x000fe40006000000ULL,
0xff7fffff16167808ULL, 0x000fc40007000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL,
0xff7fffff15157808ULL, 0x000fe40005800000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL,
0xff7fffff14147808ULL, 0x000fc40005000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL, 0xff7fffff08087808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002b04047209ULL, 0x004fe20007810000ULL,
0x0000001fff2e7424ULL, 0x000fe200078e00ffULL, 0x0000000a052a7209ULL, 0x000fe40007810000ULL,
0x0000002904037209ULL, 0x000fe40007810000ULL, 0x000000092a2a7209ULL, 0x000fc40007810000ULL,
0x0000002803047209ULL, 0x000fe40007810000ULL, 0x0000000b2a037209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x0000001803047209ULL, 0x000fe40007810000ULL,
0x00000026052a7209ULL, 0x000fe40007810000ULL, 0x0000001904037209ULL, 0x000fc40007810000ULL,
0x000000252a057209ULL, 0x000fe40007810000ULL, 0x0000001a03047209ULL, 0x000fe40007810000ULL,
0x00000024052a7209ULL, 0x000fe40007810000ULL, 0x0000001b04037209ULL, 0x000fe40007810000ULL,
0x000000232a057209ULL, 0x000fe40007810000ULL, 0x0000001203047209ULL, 0x000fc40007810000ULL,
0x00000022052a7209ULL, 0x000fe40007810000ULL, 0x0000001304037209ULL, 0x000fe40007810000ULL,
0x000000212a057209ULL, 0x000fe40007810000ULL, 0x0000001003047209ULL, 0x000fe40007810000ULL,
0x00000020052a7209ULL, 0x000fe40007810000ULL, 0x0000001104037209ULL, 0x000fc40007810000ULL,
0x0000001f2a057209ULL, 0x000fe40007810000ULL, 0x0000001603047209ULL, 0x000fe40007810000ULL,
0x0000001e052a7209ULL, 0x000fe40007810000ULL, 0x0000000f04047209ULL, 0x000fe40007810000ULL,
0x0000001d2a037209ULL, 0x000fe40007810000ULL, 0x0000001504057209ULL, 0x000fc40007810000ULL,
0x0000001c03037209ULL, 0x000fe40007810000ULL, 0x0000001405057209ULL, 0x000fe40007810000ULL,
0xffffffff00357802ULL, 0x000fe40000000f00ULL, 0x0000000803047209ULL, 0x000fe40007810000ULL,
0x0000000e05307209ULL, 0x000fe20007810000ULL, 0x00000df27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0004037f89ULL, 0x0004e400000e0000ULL, 0x0000000304317209ULL, 0x008fe20007810000ULL,
0x00000e227f007947ULL, 0x000fea000b800000ULL, 0x0c401f0030037f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007047f89ULL, 0x004ea200000e0000ULL,
0x00000003302c7209ULL, 0x008fc40007810000ULL, 0x00000005062d7209ULL, 0x010fc60007810000ULL,
0x0c201f002c2f7f89ULL, 0x002fe200000e0000ULL, 0x0000000407037209ULL, 0x004fc60007810000ULL,
0x0c201f0031057f89ULL, 0x000e6800000e0000ULL, 0x0c201f002d2e7f89ULL, 0x000ea800000e0000ULL,
0x0c201f00032a7f89ULL, 0x00072200000e0000ULL, 0x0000000531047209ULL, 0x002fe40007810000ULL,
0x0000002f2c057209ULL, 0x000fc40007810000ULL, 0x0000002e2d067209ULL, 0x004fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x008fe20000410000ULL, 0x3fb8aa3b05337820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fe40000000000ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b18187823ULL, 0x000fe20000010833ULL,
0x3fb8aa3b29297823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b09097823ULL, 0x000fe20000010833ULL, 0x0000001f002e7308ULL, 0x002fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010807ULL, 0x0000001e002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b08077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010833ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fca0000010833ULL, 0x00000029002c7308ULL, 0x000e700000000800ULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ee20000000800ULL,
0x0000002b2c08723eULL, 0x002fce00000010ffULL, 0x0000000a001f7308ULL, 0x0007f00000000800ULL,
0x00000009001e7308ULL, 0x000e620000000800ULL, 0x00000028270a723eULL, 0x008fce00000010ffULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000001800187308ULL, 0x000ee20000000800ULL,
0x0000001f1e09723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b121e7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b131f7823ULL, 0x000fca0000010833ULL, 0x00000020002d7308ULL, 0x0003f00000000800ULL,
0x0000002100297308ULL, 0x000be20000000800ULL, 0x0000000500207c02ULL, 0x002fe20008000f00ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000b180b723eULL, 0x008fe200000010ffULL,
0x0000000000087886ULL, 0x000fe200038e0100ULL, 0x3f8000002020783eULL, 0x000fc600000010ffULL,
0x0000001d00307308ULL, 0x0003e40000000800ULL, 0x000000ffff217224ULL, 0x020fcc00078e0020ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b1d7823ULL, 0x002fce0000010833ULL,
0x0000002500257308ULL, 0x000e700000000800ULL, 0x0000001c00317308ULL, 0x000ff00000000800ULL,
0x0000000700327308ULL, 0x000ff00000000800ULL, 0x00000019001c7308ULL, 0x000ff00000000800ULL,
0x0000001a00077308ULL, 0x0007700000000800ULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x000000200818723cULL, 0x008fee00000418ffULL, 0x0000001e001e7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b10217823ULL, 0x100fe20000010833ULL, 0x000000262510723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b11257823ULL, 0x000fe20000010833ULL, 0x0000001c0711723eULL, 0x020fe200000010ffULL,
0x000000ffff1c7224ULL, 0x000fc600078e0020ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000001d1e13723eULL, 0x008fe200000010ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e0020ULL, 0x0000002d2e1e723eULL, 0x000fca00000010ffULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000242312723eULL, 0x002fce00000010ffULL,
0x0000002100287308ULL, 0x0002e20000000800ULL, 0x0000001c1018723cULL, 0x000fee0000041818ULL,
0x0000002200227308ULL, 0x000f620000000800ULL, 0x000000ffff217224ULL, 0x002fce00078e0020ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000001f281d723eULL, 0x008fce00000010ffULL,
0x0000001600167308ULL, 0x000e620000000800ULL, 0x00000022291c723eULL, 0x020fce00000010ffULL,
0x0000001500247308ULL, 0x0007e20000000800ULL, 0x00000025161f723eULL, 0x002fe200000010ffULL,
0x0000000fff167424ULL, 0x000fe200078e00ffULL, 0xfffffffc02157812ULL, 0x008fca00078ec0ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000001516157219ULL, 0x000fe200000006ffULL,
0x000000201c38723cULL, 0x000fe60000041818ULL, 0x00000000151673a1ULL, 0x000ee600000e8000ULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x00000000150573c4ULL, 0x000f620000004000ULL,
0x0000002f3018723eULL, 0x000fc400000010ffULL, 0x00000031321a723eULL, 0x000fc800000010ffULL,
0x0000000e00077308ULL, 0x000f220000000800ULL, 0x0000000f2419723eULL, 0x002fe400000010ffULL,
0x0000000815ff7c12ULL, 0x008fe4000f804016ULL, 0x00000014071b723eULL, 0x010fe400000010ffULL,
0x000000032a077209ULL, 0x004fca0007810000ULL, 0x000000201838723cULL, 0x000fe80000041838ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0000090205008947ULL, 0x020fde000b800000ULL,
0x001c1fff38207589ULL, 0x0002a400000e0000ULL, 0x00000000150e73a1ULL, 0x000ee200000e8000ULL,
0x00000000150573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x0000000815ff7c12ULL, 0x008fda000f80400eULL, 0x0000091205008947ULL, 0x010fea000b800000ULL,
0x001c1fff3a217589ULL, 0x00072800000e0000ULL, 0x001c1fff22227589ULL, 0x00066800000e0000ULL,
0x001c1fff00237589ULL, 0x0006a400000e0000ULL, 0x00000002ff037819ULL, 0x002fe40000011602ULL,
0x0000000c0c357812ULL, 0x000fc400078ec0ffULL, 0x00000007030e7812ULL, 0x040fe200078ec0ffULL,
0x0000000803257824ULL, 0x040fe200078e00ffULL, 0x00000003ff157212ULL, 0x008fe200078e33ffULL,
0x00000008030f7824ULL, 0x040fe200078e00ffULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x00000008032e7824ULL, 0x040fe200078e00ffULL, 0x0000000803037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff825147812ULL, 0x100fe400078ee20eULL, 0x000000010f167812ULL, 0x100fe200078ef60eULL,
0x0000000803407824ULL, 0x000fe200078e00ffULL, 0x000000020f247812ULL, 0x100fe200078ef60eULL,
0x0000000803257824ULL, 0x000fe200078e00ffULL, 0x000000030f267812ULL, 0x000fc400078ef60eULL,
0x000000040f287812ULL, 0x140fe400078ef60eULL, 0x000000050f2a7812ULL, 0x140fe400078ef60eULL,
0x000000060f2c7812ULL, 0x000fe200078ef60eULL, 0x00000008030f7824ULL, 0x040fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee215ULL, 0x00000003ff157212ULL, 0x000fe400078e33ffULL,
0x00000007030e7812ULL, 0x000fc400078ec0ffULL, 0x0000a00067037811ULL, 0x000fe400078e58ffULL,
0xfffffff825307812ULL, 0x100fe400078ee20eULL, 0x000000010f327812ULL, 0x140fe200078ef60eULL,
0x00000010140c7824ULL, 0x000fe200078e0203ULL, 0xfffffff840407812ULL, 0x000fe400078ee215ULL,
0x000000020f367812ULL, 0x140fe400078ef60eULL, 0x000000030f387812ULL, 0x140fe200078ef60eULL,
0x0000001040337824ULL, 0x000fe200078e0203ULL, 0x000000040f3a7812ULL, 0x000fc400078ef60eULL,
0x000000050f3c7812ULL, 0x140fe200078ef60eULL, 0x00000010382f7824ULL, 0x100fe200078e0203ULL,
0x000000060f3e7812ULL, 0x000fe200078ef60eULL, 0x00000010160e7824ULL, 0x100fe200078e0203ULL,
0x0000000324147211ULL, 0x000fe200078e20ffULL, 0x0000001026167824ULL, 0x100fe400078e0203ULL,
0x0000001028247824ULL, 0x100fe400078e0203ULL, 0x000000102a267824ULL, 0x100fe400078e0203ULL,
0x000000102c287824ULL, 0x000fe200078e0203ULL, 0x0000002435277210ULL, 0x040fe20007ffe0ffULL,
0x00000001350f7824ULL, 0x000fc400078e020cULL, 0x000000102e2a7824ULL, 0x100fe200078e0203ULL,
0x00000003362e7211ULL, 0x000fe200078e20ffULL, 0x00000010300c7824ULL, 0x100fe200078e0203ULL,
0x000000080f007388ULL, 0x0003e20000000800ULL, 0x00000010322c7824ULL, 0x100fe400078e0203ULL,
0x000000103a307824ULL, 0x100fe400078e0203ULL, 0x000000103c317824ULL, 0x100fe400078e0203ULL,
0x000000103e327824ULL, 0x000fc400078e0203ULL, 0x0000000135037824ULL, 0x040fe200078e020eULL,
0x00000031350e7210ULL, 0x040fe20007ffe0ffULL, 0x0000000135157824ULL, 0x040fe400078e0214ULL,
0x0000000135257824ULL, 0x040fe200078e0216ULL, 0x0000000a03007388ULL, 0x0007e20000000800ULL,
0x0000000135297824ULL, 0x040fe400078e0226ULL, 0x00000001352b7824ULL, 0x040fe200078e0228ULL,
0x0000001015007388ULL, 0x0007e20000000800ULL, 0x00000001352d7824ULL, 0x000fc400078e022aULL,
0x00000001350c7824ULL, 0x040fe200078e020cULL, 0x0000001225007388ULL, 0x0007e20000000800ULL,
0x00000001352c7824ULL, 0x040fe400078e022cULL, 0x00000001352e7824ULL, 0x040fe200078e022eULL,
0x0000001c27007388ULL, 0x0007e20000000800ULL, 0x0000000135087824ULL, 0x042fe400078e022fULL,
0x0000000135307824ULL, 0x040fe200078e0230ULL, 0x0000001e29007388ULL, 0x0007e20000000800ULL,
0x0000000135327824ULL, 0x000fc400078e0232ULL, 0x0000000135147824ULL, 0x000fe200078e0233ULL,
0x000000182b007388ULL, 0x0007e80000000800ULL, 0x0000001a2d007388ULL, 0x0007e80000000800ULL,
0x000000090c007388ULL, 0x0007e80000000800ULL, 0x0000000b2c007388ULL, 0x0007e80000000800ULL,
0x000000112e007388ULL, 0x0007e80000000800ULL, 0x0000001308007388ULL, 0x0007e80000000800ULL,
0x0000001d30007388ULL, 0x0007e80000000800ULL, 0x0000001f0e007388ULL, 0x0007e80000000800ULL,
0x0000001932007388ULL, 0x0007e80000000800ULL, 0x0000001b14007388ULL, 0x0007e80000000800ULL,
0x014000040d008388ULL, 0x0007e80000000c00ULL, 0x014200200d008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000643400720cULL, 0x000fe20003f26070ULL,
0x0146080061ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff17ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff697224ULL, 0x000fc600078e0034ULL, 0x00000001ff177807ULL, 0x000fce0000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffa9a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0004ULL,
0x00014490002c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000053000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e002aULL,
0xfffff1c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0030ULL,
0x000144f0002c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x002fe400078e00ffULL,
0x000004d000007944ULL, 0x004fea0003c00000ULL, 0x0000002a30057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0006ULL, 0x00014540002c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x002fe400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002a06337209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0007ULL,
0x00000002002f7802ULL, 0x002fc40000000f00ULL, 0x00014590002c7802ULL, 0x000fe40000000f00ULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002a07037209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0031ULL, 0x000145e0002c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x002fe400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000002a31047209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0005ULL,
0x00014630002c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x002fe400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002a05057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0033ULL, 0x00014680002c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x002fe400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0x0000002a33067209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x000146d0002c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x002fc400078e00ffULL,
0x000002f000007944ULL, 0x000fea0003c00000ULL, 0xfffff08000007947ULL, 0x000fea000383ffffULL,
0x000000ffff037224ULL, 0x000fe200078e0038ULL, 0x00014730000e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff147224ULL, 0x000fc400078e00ffULL, 0x00001c1fff167424ULL, 0x000fe400078e00ffULL,
0x000002d000007944ULL, 0x000fea0003c00000ULL, 0x0000002300207202ULL, 0x004fe20000000f00ULL,
0xfffff6a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff037224ULL, 0x002fe200078e003aULL,
0x000147a0000e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e00ffULL,
0x00001c1fff167424ULL, 0x000fe400078e00ffULL, 0x0000026000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff147224ULL, 0x002fe200078e00ffULL, 0x000147f0000e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff167424ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x004fe400078e0023ULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x002fe200078e00ffULL,
0x0000002300227202ULL, 0x004fe20000000f00ULL, 0x00001c1fff167424ULL, 0x000fe200078e00ffULL,
0x00014840000e7802ULL, 0x000fc40000000f00ULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xfffff62000007947ULL, 0x000fea000383ffffULL, 0x0180000027037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000002700038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000304ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff27ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000304ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000027047812ULL, 0x000fd600078ec0ffULL, 0x0080000004030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0004ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002700037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff297424ULL, 0x000fc800078e00ffULL, 0xfffeb64028007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2d7424ULL, 0x000fe200078e00ffULL, 0x0000003500007348ULL, 0x000fe80003800000ULL,
0x0c00002f2a2a7389ULL, 0x0002a200000e002eULL, 0xfffeb6002c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001500007348ULL, 0x000fe80003800000ULL,
0x0000001403237389ULL, 0x0002a200000e0016ULL, 0xfffeb5c00e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000014680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000004bcULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ca4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cc8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000cd8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000cf8ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d68ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d70ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000d80ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000014b00ULL, 0xa100001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015a80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000015a90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015a90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015f10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000d68ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014d18ULL, 0x0000000000014d18ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015a80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015f10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_pagedKV_128_nqpkv_16_m_16_sm_86_cubin_len = 90096;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
