/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x00000000000138f0ULL, 0x0000000000013470ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000012330ULL, 0x0000000000000250ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000012580ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001233000000000ULL, 0x0000100400000000ULL, 0x01a0288080810c00ULL, 0x000000000048b004ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808292ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x0001233000000000ULL,
0x0000025000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000a00000000bULL, 0x0000000b00081104ULL, 0x00081204000000a0ULL, 0x000000a00000000eULL,
0x0000000e00081104ULL, 0x00081204000000a0ULL, 0x000000a00000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x00008cc000183104ULL, 0x0001174000009230ULL, 0x0001176000011750ULL,
0x0134290400011770ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x050000160500000bULL,
0x0500000b05000016ULL, 0x0500000b0500000bULL, 0x0500002e0500002eULL, 0x0500002e0500002eULL,
0x0500002e0500002eULL, 0x0500002e0500002eULL, 0x0500002e0500002eULL, 0x013428040500002eULL,
0x000000c0000000b0ULL, 0x00002250000015c0ULL, 0x0000239000002300ULL, 0x000027e0000023b0ULL,
0x00002aa000002820ULL, 0x000032c0000032b0ULL, 0x00003ae0000034f0ULL, 0x00003bd000003b80ULL,
0x00003f3000003c00ULL, 0x0000413000003f40ULL, 0x000046e0000046d0ULL, 0x00004f6000004970ULL,
0x0000505000005000ULL, 0x000053b000005080ULL, 0x000055b0000053c0ULL, 0x00005b6000005b50ULL,
0x000063e000005df0ULL, 0x000064e000006480ULL, 0x0000682000006510ULL, 0x00006a8000006830ULL,
0x0000701000007000ULL, 0x00007400000073f0ULL, 0x00008cc0000078e0ULL, 0x000096d000009230ULL,
0x00009c2000009700ULL, 0x0000a0b000009c40ULL, 0x0001104000011030ULL, 0x0001106000011050ULL,
0x000110b000011090ULL, 0x000110e0000110d0ULL, 0x0001175000011730ULL, 0x000117a000011760ULL,
0x000117c0000117b0ULL, 0x00011ed000011e30ULL, 0x00011f8000011f20ULL, 0x0001205000011ff0ULL,
0x00012110000120b0ULL, 0x00012250000121b0ULL, 0x01f03904000122f0ULL, 0x000000ff000001c0ULL,
0x000401000001c600ULL, 0x00000003000002a0ULL, 0x003f01000001c608ULL, 0x00000003000003b0ULL,
0x003f01000001c688ULL, 0x000000ff000006f0ULL, 0x000601070001c600ULL, 0x0000000200000860ULL,
0x000601010001c688ULL, 0x0000000b00002150ULL, 0x000601010001c608ULL, 0x0000000b00002170ULL,
0x000601090001c608ULL, 0x000000ff000033c0ULL, 0x000601010001c688ULL, 0x0000000b00003a80ULL,
0x000601010001c628ULL, 0x0000000b00003a90ULL, 0x000601090001c628ULL, 0x000000ff00004890ULL,
0x000601010001c690ULL, 0x0000000b00004f00ULL, 0x000601010001c648ULL, 0x0000000b00004f10ULL,
0x000601090001c648ULL, 0x000000ff00005d10ULL, 0x000601010001c698ULL, 0x0000000b00006380ULL,
0x000601010001c668ULL, 0x0000000b00006390ULL, 0x000601090001c668ULL, 0x000000ff000070d0ULL,
0x000601010001c6a0ULL, 0x000000ff0000a390ULL, 0x000601010001c600ULL, 0x000000ff0000ba10ULL,
0x000601090001c600ULL, 0x000000ff00010660ULL, 0x000a01010001c688ULL, 0x000000ff000106b0ULL,
0x000a01090001c688ULL, 0x0000000300011ae0ULL, 0x003f01010001c608ULL, 0x0000000300011af0ULL,
0x003f01010001c610ULL, 0x0000000300011b00ULL, 0x003f01010001c618ULL, 0x0000000300011b10ULL,
0x003f01010001c620ULL, 0x0000000b00011b50ULL, 0x003f01090001c608ULL, 0x0000000b00011bc0ULL,
0x003f01090001c628ULL, 0x0000000b00011c30ULL, 0x003f01090001c648ULL, 0x0000000b00011ca0ULL,
0x003f01090001c668ULL, 0x000000ff00011d00ULL, 0x000601090001c600ULL, 0x0000000500011d70ULL,
0x003f01090001c688ULL, 0x00101c0400033803ULL, 0x0000ba400000a310ULL, 0x00011b300000baa0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400501903ULL,
0x005002100000000fULL, 0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL,
0x00000000000000c4ULL, 0x0000000e00000002ULL, 0x0000000000012330ULL, 0x0000000000000044ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000077919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0xffffff6001017836ULL, 0x002fe20000000000ULL,
0x000001c000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000e620000002300ULL,
0x0000000000007919ULL, 0x000f280000002200ULL, 0x00008800ff047b82ULL, 0x000f700000000a00ULL,
0x00000000000779c3ULL, 0x000f700000002700ULL, 0x00000000000879c3ULL, 0x000f620000002600ULL,
0x00000005ff027819ULL, 0x004fe20000011607ULL, 0x00001fff03067589ULL, 0x0027ea00000e0000ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000000103007824ULL, 0x010fc400078e0200ULL,
0x00000004ff037e24ULL, 0x008fe4000f8e00ffULL, 0x0000008000007824ULL, 0x000fc600078e0207ULL,
0x00003c0301007387ULL, 0x000be40000100800ULL, 0x000000ff0000720cULL, 0x040fe40003f05270ULL,
0x0000000f0000780cULL, 0x040fe40003f24070ULL, 0x000000030000780cULL, 0x000fe40003f44070ULL,
0x00000000021272caULL, 0x002fda00000e0000ULL, 0x0000001206027c11ULL, 0x000fe2000f8e10ffULL,
0x0000000000240947ULL, 0x020fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff00000a7882ULL, 0x000fe20000000000ULL,
0x7ffc0000000b7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01c6000a043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000400037c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000030612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01c60804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000400037c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000030612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01c68804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000a79c3ULL, 0x000ee20000008800ULL,
0x0000000000217919ULL, 0x000f220000000000ULL, 0x0000007f0000780cULL, 0x000fe20003f04070ULL,
0x0000040000067882ULL, 0x002fe20000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x0000000102077819ULL, 0x000fe200000006ffULL, 0x0000000308047899ULL, 0x000fe4000800063fULL,
0x0000000309057899ULL, 0x000fe2000800063fULL, 0x0000000807027848ULL, 0x040fe20007fe0000ULL,
0x0000000107097836ULL, 0x040fe20000000000ULL, 0x0000000707087812ULL, 0x000fe200078ec0ffULL,
0x00000007050472a4ULL, 0x000fc4000f8e0204ULL, 0x0000000102027824ULL, 0x000fe200078e0a07ULL,
0x00000007090a7812ULL, 0x000fe200078ec0ffULL, 0xff317217ff0d8424ULL, 0x000fe200078e00ffULL,
0x00008200000e7ab9ULL, 0x000fe20000000a00ULL, 0x0000000407037c36ULL, 0x000fe20008000000ULL,
0x000000ff0200720cULL, 0x040fe20003f23070ULL, 0x00000004090b7c36ULL, 0x000fe20008000000ULL,
0x000000010200780cULL, 0x000fe20003f43070ULL, 0x0000020003027825ULL, 0x000fe200078e0004ULL,
0x000006540a067896ULL, 0x008fc60008000006ULL, 0x000002000b047825ULL, 0x000fe200078e0004ULL,
0x0001c60006047890ULL, 0x000fe4000fffe03fULL, 0x0000000600008c11ULL, 0x000fe4000f8e10ffULL,
0x0000000421177819ULL, 0x010fc600000006ffULL, 0x01c4000d00008388ULL, 0x0003e20000000800ULL,
0x0000001f08087812ULL, 0x000fe400078e7821ULL, 0x000001f0170b7812ULL, 0x000fe400078ec0ffULL,
0x0000001f0a0a7812ULL, 0x000fe200078e7821ULL, 0x0000002007087824ULL, 0x000fe200078e0208ULL,
0x0000000000007b1dULL, 0x004fe20000010000ULL, 0x0000000b02027210ULL, 0x000fe40007f7e0ffULL,
0x00000020090a7824ULL, 0x000fe200078e020aULL, 0x0000000b04047210ULL, 0x000fc40007f9e0ffULL,
0x000000ffff037224ULL, 0x000fe200018e0603ULL, 0x0000000608077c11ULL, 0x000fe4000f8e20ffULL,
0x00000005ff057210ULL, 0x000fe400027fe4ffULL, 0x000000060a097c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000c901c4eULL,
0x0000000004097faeULL, 0x0003e2000d101c4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00008c0000047ab9ULL, 0x000fc40000000a00ULL,
0x00000004070478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000005ff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000e02027981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000030000157ab9ULL, 0x000fe20000000800ULL,
0x00000000020c72caULL, 0x004fda00000e0000ULL, 0x000000ff0c047890ULL, 0x000fc8000fffe03fULL,
0x000000083f047899ULL, 0x000fe20008011604ULL, 0x0000009800d08947ULL, 0x000ff60003800000ULL,
0x00003c0001207983ULL, 0x000ea20000100800ULL, 0x0000000312147899ULL, 0x000fe2000800063fULL,
0x00000004ff007424ULL, 0x000fe200078e00ffULL, 0x0000000107057899ULL, 0x000fe4000800063fULL,
0x0000000908077290ULL, 0x000fe4000fffe03fULL, 0x00000014ff027e24ULL, 0x000fe2000f8e00ffULL,
0x00008e0000087ab9ULL, 0x000fe20000000800ULL, 0x00000009050572a4ULL, 0x000fe4000f8e0207ULL,
0x01c6880002ff79a7ULL, 0x0003e20008500006ULL, 0x00000000200a72caULL, 0x004fc400000e0000ULL,
0x0000000120007810ULL, 0x002fc80007ffe0ffULL, 0x0000000400007c0cULL, 0x000fce000bf06070ULL,
0x000000080a077899ULL, 0x000fe4000800063fULL, 0x00000014060a7290ULL, 0x000fe4000fffe03fULL,
0x00000008050872a4ULL, 0x000fe4000f8e0207ULL, 0x0000000400788947ULL, 0x000ff40003800000ULL,
0x000000070c00728cULL, 0x000fe2000bf01070ULL, 0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL,
0x00000003ff037819ULL, 0x000fe20000011621ULL, 0x80000007ff007e24ULL, 0x000fe2000f8e02ffULL,
0x000000070c097287ULL, 0x000fe4000c000000ULL, 0x0000000c030b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000403077836ULL, 0x040fe20000000000ULL, 0x0000000612077291ULL, 0x000fe2000f8e683fULL,
0x0000000803097836ULL, 0x000fe40000000000ULL, 0x00000009ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000000312097899ULL, 0x000fe2000800063fULL, 0x00000008070d7824ULL, 0x040fe200078e00ffULL,
0x0000002107027212ULL, 0x080fe200078e3cffULL, 0x000000080b147824ULL, 0x000fe200078e00ffULL,
0x0000002005007446ULL, 0x000fe20003800000ULL, 0x0000000809117824ULL, 0x000fe200078e00ffULL,
0x000000210b057212ULL, 0x080fe200078e3cffULL, 0x0000001403137836ULL, 0x000fe20000000000ULL,
0x0000002109047212ULL, 0x000fe200078e3cffULL, 0x0000001803157836ULL, 0x040fe20000000000ULL,
0xfffffff80d107812ULL, 0x000fe200078ee202ULL, 0x00000010030d7836ULL, 0x040fe20000000000ULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x0000001c03177836ULL, 0x000fe20000000000ULL,
0xfffffff811127812ULL, 0x000fe200078ee204ULL, 0x00000009ff117e24ULL, 0x000fe2000f8e00ffULL,
0x0000000703027812ULL, 0x000fe200078e4821ULL, 0x0001400007077890ULL, 0x000fe2000fffe03fULL,
0x0000000803057c10ULL, 0x000fe2000fffe0ffULL, 0x00000008131b7824ULL, 0x000fe200078e00ffULL,
0x000000000300720cULL, 0x000fe20003f06070ULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0x0ffffff802047812ULL, 0x000fe200078ef821ULL, 0x0000020005027825ULL, 0x002fe200078e000eULL,
0xfffffff811117812ULL, 0x000fc400078ee221ULL, 0x0000000704057c11ULL, 0x000fe2000f8e20ffULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000000900720cULL, 0x080fe20003f26070ULL,
0x0000001011027825ULL, 0x000fe200078e0002ULL, 0x0000000809097c10ULL, 0x000fe4000fffe0ffULL,
0x000000210d067212ULL, 0x000fe400078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c4eULL, 0x000000000700720cULL, 0x040fe20003f06070ULL,
0x0000000807077c36ULL, 0x000fe20008000000ULL, 0x000000030d197819ULL, 0x000fc400000006ffULL,
0x0000002113087212ULL, 0x080fe400078e3cffULL, 0x000000000b00720cULL, 0x0c0fe20003f46070ULL,
0x000000080b0b7c36ULL, 0x000fe20008000000ULL, 0x000000000d00720cULL, 0x0c0fe20003f66070ULL,
0x000000080d0d7c36ULL, 0x000fe20008000000ULL, 0x00000021150a7212ULL, 0x080fe200078e3cffULL,
0x0000020007027825ULL, 0x102fe200078e000eULL, 0x00000021170c7212ULL, 0x000fe400078e3cffULL,
0x000000001300720cULL, 0x0c0fe20003f86070ULL, 0x0000000813137c36ULL, 0x000fe20008000000ULL,
0x000000001500720cULL, 0x0c0fe20003fa6070ULL, 0x0000000815157c36ULL, 0x000fe20008000000ULL,
0x000000001700720cULL, 0x000fe20003fc6070ULL, 0x0000020009047825ULL, 0x000fe200078e000eULL,
0x0000000817177c10ULL, 0x000fc4000fffe0ffULL, 0xfffffff819167812ULL, 0x000fe200078ee206ULL,
0x000002000b067825ULL, 0x100fe200078e000eULL, 0xfffffff81b187812ULL, 0x000fe400078ee208ULL,
0xfffffff81d1a7812ULL, 0x000fe200078ee20aULL, 0x000002000d087825ULL, 0x100fe200078e000eULL,
0xfffffff81f1c7812ULL, 0x000fe400078ee20cULL, 0x0000000718197c11ULL, 0x000fe2000f8e20ffULL,
0x00000200130a7825ULL, 0x000fe200078e000eULL, 0x0000000710137c11ULL, 0x000fc4000f8e20ffULL,
0x000000071a1b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000200150c7825ULL, 0x100fe200078e000eULL,
0x0000000712157c11ULL, 0x000fe4000f8e20ffULL, 0x000000071c1d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000200170e7825ULL, 0x000fe200078e000eULL, 0x0000000716177c11ULL, 0x000fc6000f8e20ffULL,
0x0000001011027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x040fe200078e0004ULL,
0x0000000002137faeULL, 0x0003e6000c101c4eULL, 0x0000001011067825ULL, 0x040fe200078e0006ULL,
0x0000000004157faeULL, 0x0003e6000c901c4eULL, 0x0000001011087825ULL, 0x000fc800078e0008ULL,
0x00000010110a7825ULL, 0x000fc800078e000aULL, 0x00000010110c7825ULL, 0x000fc800078e000cULL,
0x00000010110e7825ULL, 0x000fe200078e000eULL, 0x0000000714117c11ULL, 0x000fca000f8e20ffULL,
0x0000000006117faeULL, 0x0003e8000d101c4eULL, 0x0000000008177faeULL, 0x0003e8000d901c4eULL,
0x000000000a197faeULL, 0x0003e8000e101c4eULL, 0x000000000c1b7faeULL, 0x0003e8000e901c4eULL,
0x000000000e1d7faeULL, 0x0003e2000f101c4eULL, 0x0000000400407947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011621ULL, 0x0000000312097899ULL, 0x000fe4000800063fULL,
0x0000000612077291ULL, 0x000fe2000f8e683fULL, 0x0000001800107810ULL, 0x000fe20007ffe0ffULL,
0x0000000400067836ULL, 0x040fe40000000000ULL, 0x0000000800087836ULL, 0x040fe20000000000ULL,
0x0001400007077890ULL, 0x000fe2000fffe03fULL, 0x0000000c000a7836ULL, 0x000fe20000000000ULL,
0x0000002106027212ULL, 0x080fe200078e3cffULL, 0x0000000808147824ULL, 0x040fe200078e00ffULL,
0x0000002108037212ULL, 0x080fe200078e3cffULL, 0x00000010000c7836ULL, 0x000fe20000000000ULL,
0x0000000306077819ULL, 0x000fe200000006ffULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x000000080c187824ULL, 0x000fe200078e00ffULL,
0xfffffff807127812ULL, 0x000fe200078ee202ULL, 0x00000014000e7836ULL, 0x000fe20000000000ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x000000210a047212ULL, 0x080fe200078e3cffULL,
0x0000001c00157836ULL, 0x000fe20000000000ULL, 0x000000210c057212ULL, 0x080fe200078e3cffULL,
0x00000008101c7824ULL, 0x000fe200078e00ffULL, 0xfffffff809167812ULL, 0x000fe200078ee204ULL,
0x000000080e097824ULL, 0x040fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee205ULL,
0x00000009ff137e24ULL, 0x000fe2000f8e00ffULL, 0x000000210e047212ULL, 0x080fe200078e3cffULL,
0x000000080a0b7c36ULL, 0x000fe20008000000ULL, 0x0000002110057212ULL, 0x080fe200078e3cffULL,
0x000000080c0d7c36ULL, 0x000fe20008000000ULL, 0xfffffff8091a7812ULL, 0x000fe200078ee204ULL,
0x000000080e0f7c36ULL, 0x000fe20008000000ULL, 0x0000002115077212ULL, 0x040fe200078e3cffULL,
0x0000000815177c36ULL, 0x040fe20008000000ULL, 0x00000003151e7819ULL, 0x000fc400000006ffULL,
0xfffffff81c1b7812ULL, 0x000fe200078ee205ULL, 0x0000000800057c36ULL, 0x000fe20008000000ULL,
0x0000000700047812ULL, 0x000fe400078e4821ULL, 0xfffffff81e1c7812ULL, 0x000fe200078ee207ULL,
0x0000000806077c36ULL, 0x000fe20008000000ULL, 0x0ffffff804007812ULL, 0x000fe200078ef821ULL,
0x0000020005047825ULL, 0x102fe200078e0002ULL, 0x0000000808097c10ULL, 0x000fe4000fffe0ffULL,
0x0000000810117c10ULL, 0x000fe2000fffe0ffULL, 0x0000020007067825ULL, 0x000fe200078e0002ULL,
0xfffffff813137812ULL, 0x000fc400078ee221ULL, 0x0000000700157c11ULL, 0x000fe2000f8e20ffULL,
0x0000020009087825ULL, 0x100fe200078e0002ULL, 0x0000000714197c11ULL, 0x000fe4000f8e20ffULL,
0x000000071b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x000002000b0a7825ULL, 0x000fe200078e0002ULL,
0x000000071c1d7c11ULL, 0x000fc6000f8e20ffULL, 0x000002000d0c7825ULL, 0x000fc800078e0002ULL,
0x000002000f0e7825ULL, 0x000fc800078e0002ULL, 0x0000020011107825ULL, 0x000fc800078e0002ULL,
0x0000001013047825ULL, 0x000fc800078e0004ULL, 0x0000020017027825ULL, 0x000fe200078e0002ULL,
0x0000000712177c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e4000b901c4eULL, 0x0000001013067825ULL, 0x000fc800078e0006ULL,
0x0000001013087825ULL, 0x040fe200078e0008ULL, 0x0000000006177faeULL, 0x0005e6000b901c4eULL,
0x00000010130a7825ULL, 0x040fe200078e000aULL, 0x0000000008197faeULL, 0x0005e2000b901c4eULL,
0x0000000716057c11ULL, 0x002fe4000f8e20ffULL, 0x00000010130c7825ULL, 0x040fe200078e000cULL,
0x000000071a157c11ULL, 0x000fe4000f8e20ffULL, 0x000000000a057faeULL, 0x0005e2000b901c4eULL,
0x00000010130e7825ULL, 0x000fc800078e000eULL, 0x0000001013107825ULL, 0x000fc800078e0010ULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x0000000718137c11ULL, 0x000fca000f8e20ffULL,
0x000000000c137faeULL, 0x0005e8000b901c4eULL, 0x000000000e157faeULL, 0x0005e8000b901c4eULL,
0x00000000101b7faeULL, 0x0005e8000b901c4eULL, 0x00000000021d7faeULL, 0x0005e4000b901c4eULL,
0x0000000420007c0cULL, 0x000fe2000bf06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff0a7424ULL, 0x006fe200078e00ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000005c006c0947ULL, 0x000fec0003800000ULL, 0xff317217000a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff3f7224ULL, 0x000fce00078e00ffULL, 0x00003c0001007983ULL, 0x000ea40000100800ULL,
0x00000000000772caULL, 0x004fda00000e0000ULL, 0x0000000807077899ULL, 0x000fc8000800063fULL,
0x0000000c0700728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000005c00380947ULL, 0x000fea0003800000ULL, 0x0000000100007836ULL, 0x000fe20000000000ULL,
0x00000000002a7919ULL, 0x000e620000000000ULL, 0x00000020070b7890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000400007c0cULL, 0x000fe2000bf06070ULL,
0x00008e0000087ab9ULL, 0x000fe40000000800ULL, 0x00000008050d72a4ULL, 0x000fd4000f8e020bULL,
0x0000000400808947ULL, 0x000fea0003800000ULL, 0x0000000b0c00728cULL, 0x000fe2000bf01070ULL,
0x00000003ff097819ULL, 0x002fe2000001162aULL, 0x8000000bff0b7e24ULL, 0x000fe2000f8e02ffULL,
0x00008a0000107ab9ULL, 0x000fe20000000a00ULL, 0x0000000b0c097287ULL, 0x000fe2000c000000ULL,
0x0000002a090e7212ULL, 0x0c0fe200078e3cffULL, 0x0000000c09067836ULL, 0x040fe20000000000ULL,
0x00000010000c7c02ULL, 0x000fe20008000f00ULL, 0x0000000409087836ULL, 0x040fe20000000000ULL,
0x000000072a107812ULL, 0x000fe200078ec0ffULL, 0x00000008060d7824ULL, 0x040fe200078e00ffULL,
0x0000000900007c02ULL, 0x000fe20008000f00ULL, 0x0000000809077836ULL, 0x040fe20000000000ULL,
0x0000002a064e7212ULL, 0x080fe200078e3cffULL, 0x0000001009057836ULL, 0x000fe20000000000ULL,
0x00000020000b7446ULL, 0x000fe2000380000bULL, 0x0000000807007824ULL, 0x040fe200078e00ffULL,
0xfffffff80d4e7812ULL, 0x000fe200078ee24eULL, 0x0000000612097291ULL, 0x000fe2000f8e683fULL,
0x0000002a074f7212ULL, 0x080fe200078e3cffULL, 0x0000000d090f7c36ULL, 0x000fe20008000000ULL,
0x0000000d081d7c10ULL, 0x000fe2000fffe0ffULL, 0x00000011ff0d7e24ULL, 0x000fe2000f8e00ffULL,
0x0000002a08527212ULL, 0x040fe200078e3cffULL, 0x00015000090b7890ULL, 0x000fe2000fffe03fULL,
0x0000000308037819ULL, 0x000fe200000006ffULL, 0x000002001d1c7825ULL, 0x000fe200078e000cULL,
0x000000070e537812ULL, 0x000fc400078ec0ffULL, 0x0000000b0900720cULL, 0x080fe20003f26070ULL,
0x000002000f0e7825ULL, 0x000fe200078e000cULL, 0x0000000b0800720cULL, 0x000fe40003f46070ULL,
0xfffffff8004f7812ULL, 0x000fe200078ee24fULL, 0x0000001410047c36ULL, 0x000fe20008000000ULL,
0xfffffff803527812ULL, 0x000fe200078ee252ULL, 0x0000001409037836ULL, 0x000fe20000000000ULL,
0x0000002a054d7212ULL, 0x000fe200078e3cffULL, 0x0000001809027836ULL, 0x000fe20000000000ULL,
0x0000000305007819ULL, 0x000fe200000006ffULL, 0x00000008031f7824ULL, 0x000fe200078e00ffULL,
0x0ffffff853537812ULL, 0x000fe200078ef82aULL, 0x0000001004127825ULL, 0x000fe200078e000eULL,
0xfffffff8004d7812ULL, 0x000fc400078ee24dULL, 0x0000000b53627c11ULL, 0x000fe2000f8e20ffULL,
0x0000001c09007836ULL, 0x000fe20000000000ULL, 0x0000002a034c7212ULL, 0x080fe200078e3cffULL,
0x00000010041c7825ULL, 0x000fe200078e001cULL, 0x0000000b52617c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012627faeULL, 0x0003e2000c901c4eULL,
0x0000002a02117212ULL, 0x0c0fe200078e3cffULL, 0x0000000802247824ULL, 0x000fe200078e00ffULL,
0x0000002a001e7212ULL, 0x040fe200078e3cffULL, 0x0000000800257824ULL, 0x040fe200078e00ffULL,
0xfffffff81f4c7812ULL, 0x000fe200078ee24cULL, 0x000000001c617faeULL, 0x0005e2000d101c4eULL,
0x0000000d071f7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d00297c36ULL, 0x000fe20008000000ULL,
0x0000000b0700720cULL, 0x000fc40003f26070ULL, 0x0000000b0600720cULL, 0x080fe20003f46070ULL,
0x0000020029287825ULL, 0x000fe200078e000cULL, 0x0000000b0500720cULL, 0x080fe40003f66070ULL,
0x0000000b0300720cULL, 0x080fe40003f86070ULL, 0x0000000b0200720cULL, 0x080fe20003fa6070ULL,
0x0000001004287825ULL, 0x000fe200078e0028ULL, 0x0000000b0000720cULL, 0x000fe40003fc6070ULL,
0xfffffff8240f7812ULL, 0x000fe200078ee211ULL, 0x0000000d060b7c36ULL, 0x000fe20008000000ULL,
0xfffffff8250e7812ULL, 0x000fe200078ee21eULL, 0x0000000d05117c36ULL, 0x000fe20008000000ULL,
0x0000000d02277c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d03257c36ULL, 0x000fe20008000000ULL,
0x0000000b4f607c11ULL, 0x000fe2000f8e20ffULL, 0x000002001f1e7825ULL, 0x000fe200078e000cULL,
0x0000000b4e5f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000b4d5e7c11ULL, 0x000fe2000f8e20ffULL,
0x000002000b127825ULL, 0x102fe200078e000cULL, 0x0000000b4c5b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b0f5a7c11ULL, 0x000fe2000f8e20ffULL, 0x00000200111c7825ULL, 0x004fe200078e000cULL,
0x0000000b0e597c11ULL, 0x000fc6000f8e20ffULL, 0x0000020025247825ULL, 0x000fc800078e000cULL,
0x0000020027267825ULL, 0x000fc800078e000cULL, 0x00000010041e7825ULL, 0x000fc800078e001eULL,
0x0000001004127825ULL, 0x040fe200078e0012ULL, 0x000000001e607faeULL, 0x0003e6000c901c4eULL,
0x00000010041c7825ULL, 0x040fe200078e001cULL, 0x00000000125f7faeULL, 0x0003e6000d101c4eULL,
0x0000001004247825ULL, 0x040fe200078e0024ULL, 0x000000001c5e7faeULL, 0x0003e6000d901c4eULL,
0x0000001004267825ULL, 0x000fe200078e0026ULL, 0x00000000245b7faeULL, 0x0003e8000e101c4eULL,
0x00000000265a7faeULL, 0x0003e8000e901c4eULL, 0x0000000028597faeULL, 0x0003e2000f101c4eULL,
0x0000000400407947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x002fe2000001162aULL,
0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL, 0x000000072a107812ULL, 0x000fe200078ec0ffULL,
0x0000000612097291ULL, 0x000fe2000f8e683fULL, 0x0000000809077810ULL, 0x000fe20007ffe0ffULL,
0x0000000409087836ULL, 0x040fe20000000000ULL, 0x0000001009057810ULL, 0x000fe20007ffe0ffULL,
0x0000000c09067836ULL, 0x000fe20000000000ULL, 0x0000002a074f7212ULL, 0x0c0fe200078e3cffULL,
0x0000000808037824ULL, 0x040fe200078e00ffULL, 0x0000002a08527212ULL, 0x080fe200078e3cffULL,
0x0000000807007824ULL, 0x000fe200078e00ffULL, 0x0000002a064e7212ULL, 0x0c0fe200078e3cffULL,
0x00000008060b7824ULL, 0x000fe200078e00ffULL, 0xfffffff803527812ULL, 0x000fe200078ee252ULL,
0x0000001409037836ULL, 0x000fe20000000000ULL, 0xfffffff8004f7812ULL, 0x000fe200078ee24fULL,
0x0000000805007824ULL, 0x000fe200078e00ffULL, 0xfffffff80b4e7812ULL, 0x000fe200078ee24eULL,
0x00000008030b7824ULL, 0x000fe200078e00ffULL, 0x0000002a054d7212ULL, 0x080fe200078e3cffULL,
0x0000000d090f7c36ULL, 0x000fe20008000000ULL, 0x0000002a034c7212ULL, 0x080fe200078e3cffULL,
0x0000001809027836ULL, 0x040fe20000000000ULL, 0xfffffff8004d7812ULL, 0x000fe200078ee24dULL,
0x0000001c09007836ULL, 0x000fe20000000000ULL, 0xfffffff80b4c7812ULL, 0x000fe200078ee24cULL,
0x000002000f0e7825ULL, 0x102fe200078e000cULL, 0x0000002a090b7212ULL, 0x080fe200078e3cffULL,
0x00015000090b7890ULL, 0x000fe2000fffe03fULL, 0x0000000d081d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000800257824ULL, 0x000fe200078e00ffULL, 0x0000001410047c10ULL, 0x000fe2000fffe0ffULL,
0x0000000802267824ULL, 0x000fe200078e00ffULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x000002001d1c7825ULL, 0x000fe200078e000cULL, 0x0000002a00247212ULL, 0x000fc400078e3cffULL,
0x0ffffff80b537812ULL, 0x000fe200078ef82aULL, 0x0000001004127825ULL, 0x000fe200078e000eULL,
0x0000002a02117212ULL, 0x000fe400078e3cffULL, 0xfffffff8250e7812ULL, 0x000fe200078ee224ULL,
0x0000000d071f7c36ULL, 0x000fe20008000000ULL, 0x0000000d06257c10ULL, 0x000fe2000fffe0ffULL,
0x0000000d05277c36ULL, 0x000fe20008000000ULL, 0x0000000b53627c11ULL, 0x000fe2000f8e20ffULL,
0x00000010041c7825ULL, 0x000fe200078e001cULL, 0x0000000b52617c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff8260f7812ULL, 0x000fe200078ee211ULL, 0x0000000d03297c36ULL, 0x000fe20008000000ULL,
0x0000000d00117c10ULL, 0x000fe2000fffe0ffULL, 0x000002001f1e7825ULL, 0x100fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012627faeULL, 0x0003e2000b901c4eULL,
0x0000000b4f607c11ULL, 0x000fe4000f8e20ffULL, 0x0000000d020b7c36ULL, 0x000fe20008000000ULL,
0x000000001c617faeULL, 0x0005e2000b901c4eULL, 0x0000020025247825ULL, 0x000fe200078e000cULL,
0x0000000b4e5f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000b4d5e7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020027267825ULL, 0x100fe200078e000cULL, 0x0000000b4c5b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b0f5a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020029287825ULL, 0x000fe200078e000cULL,
0x0000000b0e597c11ULL, 0x000fc6000f8e20ffULL, 0x000002000b127825ULL, 0x002fc800078e000cULL,
0x00000200111c7825ULL, 0x004fc800078e000cULL, 0x00000010041e7825ULL, 0x000fc800078e001eULL,
0x0000001004247825ULL, 0x040fe200078e0024ULL, 0x000000001e607faeULL, 0x0003e6000b901c4eULL,
0x0000001004267825ULL, 0x040fe200078e0026ULL, 0x00000000245f7faeULL, 0x0003e6000b901c4eULL,
0x0000001004287825ULL, 0x040fe200078e0028ULL, 0x00000000265e7faeULL, 0x0003e6000b901c4eULL,
0x0000001004127825ULL, 0x040fe200078e0012ULL, 0x00000000285b7faeULL, 0x0003e6000b901c4eULL,
0x00000010041c7825ULL, 0x000fe200078e001cULL, 0x00000000125a7faeULL, 0x0003e8000b901c4eULL,
0x000000001c597faeULL, 0x0003e4000b901c4eULL, 0x00000014ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff117424ULL, 0x000fe400078e00ffULL,
0x000000102a577824ULL, 0x000fe400078e00ffULL, 0x01c608110b1279a7ULL, 0x002e660008500006ULL,
0x0000007057577812ULL, 0x000fe200078ec0ffULL, 0x01c608130b0075a7ULL, 0x0022a40008020146ULL,
0x00000001ff0b7819ULL, 0x002fc8000001162aULL, 0x0000000c0b1c7812ULL, 0x000fc800078ec0ffULL,
0x000000061c577c10ULL, 0x000fe2000fffe057ULL, 0x000000f800609947ULL, 0x004fec0003800000ULL,
0x01c0000057117984ULL, 0x000e620000000800ULL, 0x00000001ff137424ULL, 0x000fe200078e00ffULL,
0x0000000000247919ULL, 0x000ea40000000000ULL, 0x01c2000057567984ULL, 0x0006e20000000800ULL,
0x00000008100b7812ULL, 0x004fe400078ef824ULL, 0x00000004ff287819ULL, 0x000fe40000011624ULL,
0x0000000a1100720bULL, 0x002fe40003f3d000ULL, 0x0000000810297812ULL, 0x000fc400078ef824ULL,
0x0000761013107816ULL, 0x000fd20000000010ULL, 0x0000000000127806ULL, 0x000fc800008e0100ULL,
0x0000ffff121c7812ULL, 0x000fe4000782c0ffULL, 0x0000000728127812ULL, 0x000fca00078e780bULL,
0x000000080b727824ULL, 0x000fcc00078e0212ULL, 0x0000000000d49947ULL, 0x008fea0003800000ULL,
0x0000000a1100720bULL, 0x000fe40003f34000ULL, 0x000000110a1e7209ULL, 0x000fe40007810000ULL,
0x00000002ff127819ULL, 0x000fc60000011624ULL, 0x8000001e0a107221ULL, 0x000fe40000010000ULL,
0x0000000812137836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL,
0x00000000000a7806ULL, 0x000fe400008e0100ULL, 0x00000010001f7308ULL, 0x0002a20000000800ULL,
0x00000012ff007c0cULL, 0x000fe4000bf25270ULL, 0x0000ffff0a1d7812ULL, 0x000fc400078e3cffULL,
0x0000001e000a7202ULL, 0x000fe40000000f00ULL, 0x0000001d1cff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff107807ULL, 0x002fc60001000000ULL, 0x01c4001e57009388ULL, 0x000fe20000000800ULL,
0x0000001f54547220ULL, 0x004fc60000410000ULL, 0x00001f131f137589ULL, 0x000e6400000e0000ULL,
0x8000001e11112221ULL, 0x000fe40000010000ULL, 0x00001f121f127589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b11112820ULL, 0x000fc80000410000ULL, 0x00000011005c2308ULL, 0x000ee20000000800ULL,
0x000000133f3f7220ULL, 0x082fe20000410000ULL, 0x000000133e3e7220ULL, 0x080fe20000410000ULL,
0x000000132f2f7220ULL, 0x080fe20000410000ULL, 0x000000132e2e7220ULL, 0x080fe20000410000ULL,
0x0000001323237220ULL, 0x080fe20000410000ULL, 0x0000001322227220ULL, 0x080fe20000410000ULL,
0x000000131b1b7220ULL, 0x080fe20000410000ULL, 0x000000131a1a7220ULL, 0x080fe20000410000ULL,
0x0000001317177220ULL, 0x080fe20000410000ULL, 0x0000001316167220ULL, 0x080fe20000410000ULL,
0x0000001333337220ULL, 0x080fe20000410000ULL, 0x0000001332327220ULL, 0x080fe20000410000ULL,
0x0000001337377220ULL, 0x080fe20000410000ULL, 0x0000001336367220ULL, 0x080fe20000410000ULL,
0x000000133b3b7220ULL, 0x080fe20000410000ULL, 0x000000133a3a7220ULL, 0x000fe20000410000ULL,
0x000000123d3d7220ULL, 0x084fe20000410000ULL, 0x000000123c3c7220ULL, 0x080fe20000410000ULL,
0x000000122d2d7220ULL, 0x080fe20000410000ULL, 0x000000122c2c7220ULL, 0x080fe20000410000ULL,
0x0000001221217220ULL, 0x080fe20000410000ULL, 0x0000001220207220ULL, 0x080fe20000410000ULL,
0x0000001219197220ULL, 0x080fe20000410000ULL, 0x0000001218187220ULL, 0x080fe20000410000ULL,
0x0000001215157220ULL, 0x080fe20000410000ULL, 0x0000001214147220ULL, 0x080fe20000410000ULL,
0x0000001231317220ULL, 0x080fe20000410000ULL, 0x0000001230307220ULL, 0x080fe20000410000ULL,
0x0000001235357220ULL, 0x080fe20000410000ULL, 0x0000001234347220ULL, 0x080fe20000410000ULL,
0x0000001239397220ULL, 0x080fe20000410000ULL, 0x0000001238387220ULL, 0x000fe20000410000ULL,
0x0000005c56562220ULL, 0x008fce0000410000ULL, 0x00000002282a7836ULL, 0x000fe20000000000ULL,
0x0000000672727c11ULL, 0x000fe2000f8e20ffULL, 0x0001400009097890ULL, 0x000fe2000fffe03fULL,
0x0000000428127810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000072a6c7812ULL, 0x000fe200078e7829ULL, 0x012000007240783bULL, 0x000fe20000000200ULL,
0x00000007286a7812ULL, 0x000fe200078e7829ULL, 0x00000006286e7836ULL, 0x000fe20000000000ULL,
0x00000007126b7812ULL, 0x000fe200078e7829ULL, 0x0000000829637824ULL, 0x040fe200078e026cULL,
0x00000002ff7d7819ULL, 0x000fe20000011624ULL, 0x0000000829587824ULL, 0x040fe200078e026aULL,
0x0000991010247816ULL, 0x000fe200000000ffULL, 0x0000000829697824ULL, 0x000fe200078e026bULL,
0x0000000963747c11ULL, 0x000fe2000f8e20ffULL, 0x000000087d7c7836ULL, 0x000fe20000000000ULL,
0x0000005cff55723eULL, 0x000fe200000010ffULL, 0x00000040070d7890ULL, 0x000fe2000fffe03fULL,
0x0000000958737c11ULL, 0x000fe2000f8e20ffULL, 0x000000007410783bULL, 0x000fe20000004200ULL,
0x0000000969757c11ULL, 0x000fe2000f8e20ffULL, 0x00000008051172a4ULL, 0x000fe2000f8e020dULL,
0x0000541055557816ULL, 0x000fe20000000055ULL, 0x00000000731c783bULL, 0x000fe20000004200ULL,
0x000000ff2400720cULL, 0x000fe20003f25270ULL, 0x0000005456547221ULL, 0x000fe20000010000ULL,
0x000000076e6e7812ULL, 0x000fe200078e7829ULL, 0x000000007524783bULL, 0x000fe20000004200ULL,
0x000000072a2a7812ULL, 0x000fc400078e780bULL, 0x0000006e296d7211ULL, 0x040fe200078e18ffULL,
0x00001f7d55507589ULL, 0x000e6200000e0000ULL, 0x0000008029297811ULL, 0x000fe200078e18ffULL,
0x000000080b2a7824ULL, 0x000fe200078e022aULL, 0x000000096d767c11ULL, 0x000fe2000f8e20ffULL,
0x00001f7c55517589ULL, 0x000ea200000e0000ULL, 0x000000296b6b7210ULL, 0x000fe20007ffe0ffULL,
0x000000016a6a7824ULL, 0x100fe200078e0229ULL, 0x000000062a777c11ULL, 0x000fe2000f8e20ffULL,
0x000000007644783bULL, 0x000ee20000004200ULL, 0x000000016c6c7824ULL, 0x100fe200078e0229ULL,
0x000000096b7a7c11ULL, 0x000fe2000f8e20ffULL, 0x000000016e6e7824ULL, 0x000fe200078e0229ULL,
0x000000096a787c11ULL, 0x000fc4000f8e20ffULL, 0x000000096c797c11ULL, 0x000fe4000f8e20ffULL,
0x000000096e7b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000007848783bULL, 0x000fe80000004200ULL,
0x000000007b28783bULL, 0x000fe20000004200ULL, 0x0000005040409232ULL, 0x082fe40000200000ULL,
0x0000005042429232ULL, 0x000fc40000200000ULL, 0x0000005141419232ULL, 0x084fe40000200000ULL,
0x0000005143439232ULL, 0x000fce0000200000ULL, 0x000000104030723cULL, 0x000fec0000041830ULL,
0x000000124014723cULL, 0x000fe20000041814ULL, 0x012000007710783bULL, 0x000e6a0000000200ULL,
0x0000001c4038723cULL, 0x000fec0000041838ULL, 0x0000001e4034723cULL, 0x000fe20000041834ULL,
0x00000000791c783bULL, 0x000eaa0000004200ULL, 0x000000244018723cULL, 0x000fec0000041818ULL,
0x000000264020723cULL, 0x000fe20000041820ULL, 0x000000007a24783bULL, 0x000f2a0000004200ULL,
0x00000044402c723cULL, 0x008fec000004182cULL, 0x00000046403c723cULL, 0x000fe2000004183cULL,
0x0000005010109232ULL, 0x002fc40000200000ULL, 0x0000005012129232ULL, 0x000fe40000200000ULL,
0x0000005111119232ULL, 0x080fe40000200000ULL, 0x0000005113139232ULL, 0x000fce0000200000ULL,
0x000000481038723cULL, 0x000fec0000041838ULL, 0x0000004a1034723cULL, 0x000fec0000041834ULL,
0x0000001c1030723cULL, 0x004fec0000041830ULL, 0x0000001e1014723cULL, 0x000fec0000041814ULL,
0x000000241018723cULL, 0x010fec0000041818ULL, 0x000000261020723cULL, 0x000fec0000041820ULL,
0x00000028102c723cULL, 0x000fec000004182cULL, 0x0000002a1010723cULL, 0x000fe2000004183cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000e48947ULL, 0x000fde0003800000ULL, 0x0000000d0c00728cULL, 0x000fe4000bf01070ULL,
0x8000000dff267e24ULL, 0x000fe2000f8e02ffULL, 0x0000000953687c11ULL, 0x000fe2000f8e20ffULL,
0x00000011081f7c36ULL, 0x000fe20008000000ULL, 0x0000000d0c107287ULL, 0x000fe2000c000000ULL,
0x0000001107257c36ULL, 0x000fe20008000000ULL, 0x0000000952677c11ULL, 0x000fe2000f8e20ffULL,
0x000002001f1e7825ULL, 0x100fe200078e000cULL, 0x000000094f667c11ULL, 0x000fe4000f8e20ffULL,
0x000000090f567c11ULL, 0x000fe2000f8e20ffULL, 0x00000010ff1d7e24ULL, 0x000fe2000f8e00ffULL,
0x000000094e657c11ULL, 0x000fe2000f8e20ffULL, 0x0000020025247825ULL, 0x000fe200078e000cULL,
0x000000094d647c11ULL, 0x000fc4000f8e20ffULL, 0x000000201d267446ULL, 0x000fe20003800026ULL,
0x00000010041e7825ULL, 0x040fe200078e001eULL, 0x00000011091d7c10ULL, 0x000fe4000fffe0ffULL,
0x000000260900720cULL, 0x080fe20003f46070ULL, 0x0000001004247825ULL, 0x000fe200078e0024ULL,
0x000000260800720cULL, 0x080fe40003f66070ULL, 0x000000260700720cULL, 0x080fe20003f86070ULL,
0x000002001d1c7825ULL, 0x000fe200078e000cULL, 0x000000260200720cULL, 0x000fc40003fa6070ULL,
0x000000260000720cULL, 0x000fe20003fc6070ULL, 0x00000011030f7c36ULL, 0x000fe20008000000ULL,
0x000000094c5d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010041c7825ULL, 0x000fc800078e001cULL,
0x0000001102277c36ULL, 0x000fe20008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c687faeULL, 0x0003e2000d101c4eULL, 0x000000260500720cULL, 0x080fe20003f46070ULL,
0x0000001100297c36ULL, 0x000fe40008000000ULL, 0x000000001e677faeULL, 0x0005e2000d901c4eULL,
0x000000260600720cULL, 0x080fe20003f66070ULL, 0x0000020029287825ULL, 0x100fe400078e000cULL,
0x0000000024667faeULL, 0x0007e2000e101c4eULL, 0x000000260300720cULL, 0x000fe20003f86070ULL,
0x0000020027267825ULL, 0x000fc800078e000cULL, 0x00000011061d7c36ULL, 0x002fe20008000000ULL,
0x00000011051f7c10ULL, 0x004fe2000fffe0ffULL, 0x0000001004267825ULL, 0x000fc800078e0026ULL,
0x000002001d1c7825ULL, 0x000fc800078e000cULL, 0x000002001f1e7825ULL, 0x000fc800078e000cULL,
0x000002000f247825ULL, 0x008fe200078e000cULL, 0x000000090e0f7c11ULL, 0x000fc6000f8e20ffULL,
0x00000010041c7825ULL, 0x000fc800078e001cULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x000000001c657faeULL, 0x0003e6000d901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x000000001e647faeULL, 0x0003e6000d101c4eULL, 0x0000001004287825ULL, 0x000fe200078e0028ULL,
0x00000000245d7faeULL, 0x0003e8000e101c4eULL, 0x0000000026567faeULL, 0x0003e8000e901c4eULL,
0x00000000280f7faeULL, 0x0003e2000f101c4eULL, 0x0000000000ac7947ULL, 0x000fea0003800000ULL,
0x0000001109257c10ULL, 0x000fe2000fffe0ffULL, 0x00000011081f7c36ULL, 0x000fe20008000000ULL,
0x0000000953687c11ULL, 0x000fe2000f8e20ffULL, 0x00000011071d7c36ULL, 0x000fe20008000000ULL,
0x0000000952677c11ULL, 0x000fe2000f8e20ffULL, 0x0000020025247825ULL, 0x100fe200078e000cULL,
0x000000094f667c11ULL, 0x000fe4000f8e20ffULL, 0x000000090f567c11ULL, 0x000fe2000f8e20ffULL,
0x000002001f1e7825ULL, 0x000fe200078e000cULL, 0x0000001105277c10ULL, 0x000fc4000fffe0ffULL,
0x000000094e657c11ULL, 0x000fe2000f8e20ffULL, 0x000002001d1c7825ULL, 0x000fe200078e000cULL,
0x000000094d647c11ULL, 0x000fe4000f8e20ffULL, 0x000000094c5d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001004247825ULL, 0x000fc800078e0024ULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024687faeULL, 0x0003e6000b901c4eULL,
0x00000010041c7825ULL, 0x000fe200078e001cULL, 0x000000001e677faeULL, 0x0005e6000b901c4eULL,
0x00000011060f7c36ULL, 0x000fe20008000000ULL, 0x000000001c667faeULL, 0x0007e2000b901c4eULL,
0x0000001103297c36ULL, 0x000fc40008000000ULL, 0x00000011022b7c36ULL, 0x000fe40008000000ULL,
0x00000011003d7c36ULL, 0x000fe40008000000ULL, 0x0000020029247825ULL, 0x002fc800078e000cULL,
0x00000200271e7825ULL, 0x004fc800078e000cULL, 0x000002000f1c7825ULL, 0x008fe200078e000cULL,
0x000000090e0f7c11ULL, 0x000fc6000f8e20ffULL, 0x000002002b267825ULL, 0x000fc800078e000cULL,
0x000002003d287825ULL, 0x000fc800078e000cULL, 0x00000010041c7825ULL, 0x000fc800078e001cULL,
0x00000010041e7825ULL, 0x040fe200078e001eULL, 0x000000001c657faeULL, 0x0003e6000b901c4eULL,
0x0000001004247825ULL, 0x040fe200078e0024ULL, 0x000000001e647faeULL, 0x0003e6000b901c4eULL,
0x0000001004267825ULL, 0x040fe200078e0026ULL, 0x00000000245d7faeULL, 0x0003e6000b901c4eULL,
0x0000001004287825ULL, 0x000fe200078e0028ULL, 0x0000000026567faeULL, 0x0003e8000b901c4eULL,
0x00000000280f7faeULL, 0x0003e4000b901c4eULL, 0x0000000000407919ULL, 0x000ea20000000000ULL,
0x0000000b58707c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c0d00728cULL, 0x000fe2000bf06070ULL,
0x0000000b636f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000b69697c11ULL, 0x000fe2000f8e20ffULL, 0x00000001ff4c7424ULL, 0x000fe200078e00ffULL,
0x0000000b6d6d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b6a6a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b6c6c7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000b6b6b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b6e6e7c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000004400e7811ULL, 0x044fe200078fe0ffULL, 0x00000000703c783bULL, 0x000fe20000004200ULL,
0x0000000640407811ULL, 0x000fe400078fe0ffULL, 0x000000070e0e7812ULL, 0x000fe200078e780bULL,
0x000000006f28783bULL, 0x002fe20000004200ULL, 0x0000000740407812ULL, 0x000fe400078e780bULL,
0x0000000e0b0e7211ULL, 0x040fe200078e18ffULL, 0x000000006924783bULL, 0x000fe40000004200ULL,
0x000000080b407824ULL, 0x000fe200078e0240ULL, 0x000000060e717c11ULL, 0x000fe2000f8e20ffULL,
0x000000006d44783bULL, 0x000fe60000004200ULL, 0x0000000640637c11ULL, 0x000fe2000f8e20ffULL,
0x01200000711c783bULL, 0x000fe80000000200ULL, 0x00001f7d550e7589ULL, 0x000e6800000e0000ULL,
0x00001f7c55557589ULL, 0x000ea800000e0000ULL, 0x000000006a48783bULL, 0x000fe80000004200ULL,
0x000000006c40783bULL, 0x000fe20000004200ULL, 0x0000000e1c1c9232ULL, 0x002fc40000200000ULL,
0x0000000e1e1e9232ULL, 0x000fe40000200000ULL, 0x000000551d1d9232ULL, 0x084fe40000200000ULL,
0x000000551f1f9232ULL, 0x000fce0000200000ULL, 0x0000003c1c38723cULL, 0x000fec0000041838ULL,
0x0000003e1c34723cULL, 0x000fe20000041834ULL, 0x01200000633c783bULL, 0x000e6a0000000200ULL,
0x000000281c30723cULL, 0x000fec0000041830ULL, 0x0000002a1c14723cULL, 0x000fe20000041814ULL,
0x000000006b28783bULL, 0x000eaa0000004200ULL, 0x000000241c18723cULL, 0x000fec0000041818ULL,
0x000000261c20723cULL, 0x000fe20000041820ULL, 0x000000006e24783bULL, 0x000ee20000004200ULL,
0x01c6884cffff79a7ULL, 0x0009e80008500006ULL, 0x000000441c2c723cULL, 0x000fec000004182cULL,
0x000000461c10723cULL, 0x000fe20000041810ULL, 0x0000000e3c3c9232ULL, 0x002fc40000200000ULL,
0x0000000e3e3e9232ULL, 0x000fe40000200000ULL, 0x000000553d3d9232ULL, 0x080fe40000200000ULL,
0x000000553f3f9232ULL, 0x000fe20000200000ULL, 0x000000000000781cULL, 0x000fcc0003f2f008ULL,
0x000000483c38723cULL, 0x000fec0000041838ULL, 0x0000004a3c34723cULL, 0x000fec0000041834ULL,
0x000000403c30723cULL, 0x000fec0000041830ULL, 0x000000423c14723cULL, 0x000fec0000041814ULL,
0x000000283c18723cULL, 0x004fec0000041818ULL, 0x0000002a3c20723cULL, 0x000fec0000041820ULL,
0x000000243c2c723cULL, 0x008fec000004182cULL, 0x000000263c3c723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000003c00641947ULL, 0x010fde0003800000ULL,
0x00000060070b7890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000008050d72a4ULL, 0x000fe2000f8e020bULL, 0x0000000000c48947ULL, 0x000ff60003800000ULL,
0x0000000b0c00728cULL, 0x000fe4000bf01070ULL, 0x8000000bff0b7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000d00277c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d09137c36ULL, 0x000fe20008000000ULL,
0x0000000b0c097287ULL, 0x000fe2000c000000ULL, 0x0000000d08117c36ULL, 0x000fe40008000000ULL,
0x0000020013127825ULL, 0x000fc600078e000cULL, 0x00000009000e7c02ULL, 0x000fe20008000f00ULL,
0x0000020011107825ULL, 0x000fc600078e000cULL, 0x000000200e0b7446ULL, 0x000fe2000380000bULL,
0x0000001004127825ULL, 0x000fc600078e0012ULL, 0x0000000b0900720cULL, 0x080fe20003f26070ULL,
0x0000001004107825ULL, 0x000fe200078e0010ULL, 0x0000000b0800720cULL, 0x080fe40003f46070ULL,
0x0000000b0500720cULL, 0x080fe20003f66070ULL, 0x0000000d071d7c36ULL, 0x000fe20008000000ULL,
0x0000000b0300720cULL, 0x0c0fe20003f86070ULL, 0x0000000d031f7c36ULL, 0x000fe20008000000ULL,
0x0000000b0200720cULL, 0x0c0fe20003fa6070ULL, 0x0000000d02257c36ULL, 0x000fe20008000000ULL,
0x0000000b0000720cULL, 0x000fe20003fc6070ULL, 0x000002001f1e7825ULL, 0x000fc400078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012627faeULL, 0x0003e2000c901c4eULL,
0x0000000b0700720cULL, 0x080fe20003f26070ULL, 0x0000020025247825ULL, 0x100fe400078e000cULL,
0x0000000010617faeULL, 0x0005e2000d101c4eULL, 0x0000000b0600720cULL, 0x000fe20003f46070ULL,
0x0000020027267825ULL, 0x000fe200078e000cULL, 0x0000000d060b7c10ULL, 0x000fc6000fffe0ffULL,
0x00000010041e7825ULL, 0x000fc800078e001eULL, 0x000002001d127825ULL, 0x002fc800078e000cULL,
0x0000000d051d7c36ULL, 0x000fe40008000000ULL, 0x000002000b107825ULL, 0x004fc800078e000cULL,
0x000002001d1c7825ULL, 0x000fc800078e000cULL, 0x0000001004127825ULL, 0x000fc800078e0012ULL,
0x0000001004107825ULL, 0x040fe200078e0010ULL, 0x0000000012607faeULL, 0x0003e6000c901c4eULL,
0x00000010041c7825ULL, 0x040fe200078e001cULL, 0x00000000105f7faeULL, 0x0003e6000d101c4eULL,
0x0000001004247825ULL, 0x040fe200078e0024ULL, 0x000000001c5e7faeULL, 0x0003e6000d901c4eULL,
0x0000001004267825ULL, 0x000fe200078e0026ULL, 0x000000001e5b7faeULL, 0x0003e8000e101c4eULL,
0x00000000245a7faeULL, 0x0003e8000e901c4eULL, 0x0000000026597faeULL, 0x0003e2000f101c4eULL,
0x00000000008c7947ULL, 0x000fea0003800000ULL, 0x0000000d09137c36ULL, 0x000fe20008000000ULL,
0x0000000d061d7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d08117c36ULL, 0x000fe20008000000ULL,
0x0000000d00277c10ULL, 0x000fe2000fffe0ffULL, 0x0000020013127825ULL, 0x000fc800078e000cULL,
0x0000020011107825ULL, 0x000fc800078e000cULL, 0x0000001004127825ULL, 0x000fc800078e0012ULL,
0x0000000d070b7c36ULL, 0x000fe20008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012627faeULL, 0x0003e2000b901c4eULL, 0x0000001004107825ULL, 0x000fc800078e0010ULL,
0x0000000d031f7c36ULL, 0x000fe20008000000ULL, 0x0000000010617faeULL, 0x0005e2000b901c4eULL,
0x0000000d02257c36ULL, 0x000fe40008000000ULL, 0x000002001f1e7825ULL, 0x000fc800078e000cULL,
0x000002000b127825ULL, 0x002fc800078e000cULL, 0x0000000d050b7c36ULL, 0x000fe40008000000ULL,
0x000002001d107825ULL, 0x004fc800078e000cULL, 0x000002000b1c7825ULL, 0x000fc800078e000cULL,
0x0000020025247825ULL, 0x000fc800078e000cULL, 0x0000020027267825ULL, 0x000fc800078e000cULL,
0x0000001004127825ULL, 0x000fc800078e0012ULL, 0x0000001004107825ULL, 0x040fe200078e0010ULL,
0x0000000012607faeULL, 0x0003e6000b901c4eULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x00000000105f7faeULL, 0x0003e6000b901c4eULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x000000001c5e7faeULL, 0x0003e6000b901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x000000001e5b7faeULL, 0x0003e6000b901c4eULL, 0x0000001004267825ULL, 0x000fe200078e0026ULL,
0x00000000245a7faeULL, 0x0003e8000b901c4eULL, 0x0000000026597faeULL, 0x0003e4000b901c4eULL,
0x00000014ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x01c6284c0b1079a7ULL, 0x002e640008500006ULL, 0x01c628110b0075a7ULL, 0x002e640008020146ULL,
0x000000e000409947ULL, 0x002fea0003800000ULL, 0x01c08000570b7984ULL, 0x000e620000000800ULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000000a0b00720bULL, 0x002fda0003f3d000ULL,
0x00000000000e7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0e127812ULL, 0x000fe4000782c0ffULL,
0x01c28000570e7984ULL, 0x0002b60000000800ULL, 0x0000000000d49947ULL, 0x002fea0003800000ULL,
0x0000000a0b00720bULL, 0x000fe20003f34000ULL, 0x000000011200788cULL, 0x000fe2000bf05270ULL,
0x0000000b0a107209ULL, 0x000fca0007810000ULL, 0x800000100a117221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fc60003f4f008ULL, 0x3fb8aa3b11117820ULL, 0x000fe40000410000ULL,
0x00000000000a7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0a137812ULL, 0x000fe200078e3cffULL,
0x0000001100117308ULL, 0x000e660000000800ULL, 0x0000001312ff7212ULL, 0x000fe2000782c0ffULL,
0x01c480105700a388ULL, 0x000fe80000000800ULL, 0x00001f7d110a7589ULL, 0x002e7000000e0000ULL,
0x800000100b121221ULL, 0x000fe20000010000ULL, 0x0000001154547220ULL, 0x000fe20000410000ULL,
0x00001f7c110b7589ULL, 0x00072400000e0000ULL, 0x3fb8aa3b12121820ULL, 0x000fc80000410000ULL,
0x00000012005c1308ULL, 0x000f620000000800ULL, 0x00000001ff117807ULL, 0x008fe20000800000ULL,
0x0000000a38387220ULL, 0x082fe20000410000ULL, 0x0000000a39397220ULL, 0x080fe20000410000ULL,
0x0000000a34347220ULL, 0x080fe20000410000ULL, 0x0000000a35357220ULL, 0x080fe20000410000ULL,
0x0000000a30307220ULL, 0x080fe20000410000ULL, 0x0000000a31317220ULL, 0x080fe20000410000ULL,
0x0000000a14147220ULL, 0x080fe20000410000ULL, 0x0000000a15157220ULL, 0x080fe20000410000ULL,
0x0000000a18187220ULL, 0x080fe20000410000ULL, 0x0000000a19197220ULL, 0x080fe20000410000ULL,
0x0000000a20207220ULL, 0x080fe20000410000ULL, 0x0000000a21217220ULL, 0x080fe20000410000ULL,
0x0000000a2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000a2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000a3d3d7220ULL, 0x000fe20000410000ULL,
0x00000010000a7202ULL, 0x000fe20000000f00ULL, 0x0000000b3a3a7220ULL, 0x090fe20000410000ULL,
0x0000000b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000b36367220ULL, 0x080fe20000410000ULL,
0x0000000b37377220ULL, 0x080fe20000410000ULL, 0x0000000b32327220ULL, 0x080fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b16167220ULL, 0x080fe20000410000ULL,
0x0000000b17177220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x080fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000b3f3f7220ULL, 0x000fe20000410000ULL, 0x0000761011107816ULL, 0x000fe20000000010ULL,
0x0000000e5c0e1220ULL, 0x024fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x01280000721c783bULL, 0x000fe20000000200ULL, 0x0000005cff0b723eULL, 0x000fe200000010ffULL,
0x0000008007097890ULL, 0x000fe2000fffe03fULL, 0x0000991010447816ULL, 0x000fe200000000ffULL,
0x000000007324783bULL, 0x000fe20000004200ULL, 0x000054100b0b7816ULL, 0x000fe2000000000bULL,
0x00000008050d72a4ULL, 0x000fe2000f8e0209ULL, 0x000000ff4400720cULL, 0x000fe20003f25270ULL,
0x000000007528783bULL, 0x000fe20000004200ULL, 0x000000540e547221ULL, 0x004fc60000010000ULL,
0x000000007440783bULL, 0x000fe80000004200ULL, 0x00001f7d0b4c7589ULL, 0x000e6800000e0000ULL,
0x00001f7c0b4d7589ULL, 0x000ea800000e0000ULL, 0x000000007610783bULL, 0x000ee80000004200ULL,
0x000000007848783bULL, 0x000fe80000004200ULL, 0x000000007b44783bULL, 0x000fe20000004200ULL,
0x0000004c1c1c9232ULL, 0x002fc40000200000ULL, 0x0000004c1e1e9232ULL, 0x000fe40000200000ULL,
0x0000004d1d1d9232ULL, 0x084fe40000200000ULL, 0x0000004d1f1f9232ULL, 0x000fce0000200000ULL,
0x000000241c38723cULL, 0x000fec0000041838ULL, 0x000000261c34723cULL, 0x000fe20000041834ULL,
0x012800007724783bULL, 0x000e6a0000000200ULL, 0x000000281c18723cULL, 0x000fec0000041818ULL,
0x000000401c30723cULL, 0x000fec0000041830ULL, 0x000000421c14723cULL, 0x000fe20000041814ULL,
0x000000007a40783bULL, 0x000fea0000004200ULL, 0x0000002a1c28723cULL, 0x000fe20000041820ULL,
0x000000007920783bULL, 0x000eaa0000004200ULL, 0x000000101c2c723cULL, 0x008fec000004182cULL,
0x000000121c10723cULL, 0x000fe2000004183cULL, 0x0000004c24249232ULL, 0x002fc40000200000ULL,
0x0000004c26269232ULL, 0x000fe40000200000ULL, 0x0000004d25259232ULL, 0x080fe40000200000ULL,
0x0000004d27279232ULL, 0x000fce0000200000ULL, 0x000000482438723cULL, 0x000fec0000041838ULL,
0x0000004a2434723cULL, 0x000fec0000041834ULL, 0x000000202430723cULL, 0x004fec0000041830ULL,
0x000000222414723cULL, 0x000fec0000041814ULL, 0x000000402418723cULL, 0x000fec0000041818ULL,
0x000000422428723cULL, 0x000fec0000041828ULL, 0x00000044242c723cULL, 0x000fec000004182cULL,
0x000000462410723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000c48947ULL, 0x000fde0003800000ULL,
0x000000090c00728cULL, 0x000fe4000bf01070ULL, 0x80000009ff0e7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000d08217c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d071f7c36ULL, 0x000fe20008000000ULL,
0x000000090c0b7287ULL, 0x000fe2000c000000ULL, 0x0000000d06237c36ULL, 0x000fe20008000000ULL,
0x0000000d03277c10ULL, 0x000fe2000fffe0ffULL, 0x0000020021207825ULL, 0x000fc800078e000cULL,
0x0000000bff1d7e24ULL, 0x000fe4000f8e00ffULL, 0x000002001f1e7825ULL, 0x000fc600078e000cULL,
0x000000201d0e7446ULL, 0x000fe2000380000eULL, 0x0000000d091d7c36ULL, 0x040fe40008000000ULL,
0x0000001004207825ULL, 0x000fe200078e0020ULL, 0x0000000e0900720cULL, 0x080fe40003f46070ULL,
0x0000000e0800720cULL, 0x080fe20003f66070ULL, 0x000002001d1c7825ULL, 0x000fe200078e000cULL,
0x0000000e0700720cULL, 0x080fe40003f86070ULL, 0x0000000e0200720cULL, 0x080fe20003fa6070ULL,
0x00000010041e7825ULL, 0x000fe200078e001eULL, 0x0000000e0000720cULL, 0x000fc60003fc6070ULL,
0x00000010041c7825ULL, 0x000fc800078e001cULL, 0x0000000d05257c36ULL, 0x040fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c687faeULL, 0x0003e2000d101c4eULL,
0x0000000e0500720cULL, 0x080fe20003f46070ULL, 0x0000000d023d7c36ULL, 0x000fe40008000000ULL,
0x0000000020677faeULL, 0x0005e2000d901c4eULL, 0x0000000e0600720cULL, 0x080fe20003f66070ULL,
0x0000000d003f7c36ULL, 0x000fe40008000000ULL, 0x000000001e667faeULL, 0x0007e2000e101c4eULL,
0x0000000e0300720cULL, 0x000fe20003f86070ULL, 0x00000200231c7825ULL, 0x002fc800078e000cULL,
0x0000020025207825ULL, 0x004fc800078e000cULL, 0x0000020027247825ULL, 0x000fc800078e000cULL,
0x000002003d227825ULL, 0x000fc800078e000cULL, 0x000002003f1e7825ULL, 0x008fc800078e000cULL,
0x00000010041c7825ULL, 0x000fc800078e001cULL, 0x0000001004207825ULL, 0x040fe200078e0020ULL,
0x000000001c657faeULL, 0x0003e6000d901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x0000000020647faeULL, 0x0003e6000d101c4eULL, 0x0000001004227825ULL, 0x040fe200078e0022ULL,
0x00000000245d7faeULL, 0x0003e6000e101c4eULL, 0x00000010041e7825ULL, 0x000fe200078e001eULL,
0x0000000022567faeULL, 0x0003e8000e901c4eULL, 0x000000001e0f7faeULL, 0x0003e2000f101c4eULL,
0x00000000008c7947ULL, 0x000fea0003800000ULL, 0x0000000d091f7c36ULL, 0x000fe20008000000ULL,
0x0000000d081d7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d07217c36ULL, 0x000fe20008000000ULL,
0x0000000d03257c10ULL, 0x000fe2000fffe0ffULL, 0x000002001f1e7825ULL, 0x000fc800078e000cULL,
0x000002001d1c7825ULL, 0x000fc800078e000cULL, 0x00000010041e7825ULL, 0x000fc800078e001eULL,
0x00000010041c7825ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e687faeULL, 0x0003e6000b901c4eULL, 0x0000000d06237c36ULL, 0x000fe20008000000ULL,
0x000000001c677faeULL, 0x0005e2000b901c4eULL, 0x0000000d02277c36ULL, 0x000fe40008000000ULL,
0x0000000d003d7c36ULL, 0x000fe40008000000ULL, 0x00000200211e7825ULL, 0x002fc800078e000cULL,
0x0000000d05217c36ULL, 0x000fe40008000000ULL, 0x00000200231c7825ULL, 0x004fc800078e000cULL,
0x0000020021207825ULL, 0x000fc800078e000cULL, 0x0000020025227825ULL, 0x000fc800078e000cULL,
0x0000020027247825ULL, 0x000fc800078e000cULL, 0x000002003d267825ULL, 0x000fc800078e000cULL,
0x00000010041e7825ULL, 0x000fc800078e001eULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x000000001e667faeULL, 0x0003e6000b901c4eULL, 0x0000001004207825ULL, 0x040fe200078e0020ULL,
0x000000001c657faeULL, 0x0003e6000b901c4eULL, 0x0000001004227825ULL, 0x040fe200078e0022ULL,
0x0000000020647faeULL, 0x0003e6000b901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x00000000225d7faeULL, 0x0003e6000b901c4eULL, 0x0000001004267825ULL, 0x000fe200078e0026ULL,
0x0000000024567faeULL, 0x0003e8000b901c4eULL, 0x00000000260f7faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000c0900728cULL, 0x000fe2000bf06070ULL,
0x00000001ff4c7424ULL, 0x000fe400078e00ffULL, 0x00001f7d0b0e7589ULL, 0x000fe800000e0000ULL,
0x00001f7c0b0b7589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x01280000711c783bULL, 0x002e680000000200ULL, 0x000000007044783bULL, 0x000ea80000004200ULL,
0x000000006f40783bULL, 0x000fe80000004200ULL, 0x000000006924783bULL, 0x000fe80000004200ULL,
0x000000006d20783bULL, 0x000fe80000004200ULL, 0x01280000633c783bULL, 0x000ee80000000200ULL,
0x000000006a48783bULL, 0x000f220000004200ULL, 0x0000000e1c1c9232ULL, 0x002fc40000200000ULL,
0x0000000e1e1e9232ULL, 0x000fe40000200000ULL, 0x0000000b1d1d9232ULL, 0x080fe40000200000ULL,
0x0000000b1f1f9232ULL, 0x000fce0000200000ULL, 0x000000441c38723cULL, 0x004fec0000041838ULL,
0x000000461c34723cULL, 0x000fe20000041834ULL, 0x000000006c44783bULL, 0x000e620000004200ULL,
0x0000000e3c3c9232ULL, 0x088fe40000200000ULL, 0x0000000e3e3e9232ULL, 0x000fc40000200000ULL,
0x000000401c30723cULL, 0x000fe20000041830ULL, 0x0000000b3d3d9232ULL, 0x080fe40000200000ULL,
0x0000000b3f3f9232ULL, 0x000fe20000200000ULL, 0x000000000000781cULL, 0x000fe40003f2f008ULL,
0x000000421c14723cULL, 0x000fe20000041814ULL, 0x000000006b40783bULL, 0x000eaa0000004200ULL,
0x000000241c18723cULL, 0x000fec0000041818ULL, 0x000000261c28723cULL, 0x000fe20000041828ULL,
0x000000006e24783bULL, 0x000ee20000004200ULL, 0x01c6904cffff79a7ULL, 0x000be80008500006ULL,
0x000000201c2c723cULL, 0x000fec000004182cULL, 0x000000221c10723cULL, 0x000fec0000041810ULL,
0x000000483c38723cULL, 0x010fec0000041838ULL, 0x0000004a3c34723cULL, 0x000fec0000041834ULL,
0x000000443c30723cULL, 0x002fec0000041830ULL, 0x000000463c14723cULL, 0x000fec0000041814ULL,
0x000000403c18723cULL, 0x004fec0000041818ULL, 0x000000423c20723cULL, 0x000fec0000041828ULL,
0x000000243c2c723cULL, 0x008fec000004182cULL, 0x000000263c3c723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000002800441947ULL, 0x020fde0003800000ULL,
0x000000a0070b7890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000008050d72a4ULL, 0x000fe2000f8e020bULL, 0x0000000000c48947ULL, 0x000ff60003800000ULL,
0x0000000b0c00728cULL, 0x000fe4000bf01070ULL, 0x8000000bff0b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000d09137c36ULL, 0x000fe20008000000ULL, 0x0000000d071d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000b0c097287ULL, 0x000fe2000c000000ULL, 0x0000000d08117c36ULL, 0x000fe20008000000ULL,
0x0000000d02257c10ULL, 0x000fe2000fffe0ffULL, 0x0000020013127825ULL, 0x000fc800078e000cULL,
0x00000009ff0e7e24ULL, 0x000fe4000f8e00ffULL, 0x0000020011107825ULL, 0x000fc600078e000cULL,
0x000000200e0b7446ULL, 0x000fe2000380000bULL, 0x0000001004127825ULL, 0x000fc600078e0012ULL,
0x0000000b0900720cULL, 0x080fe20003f26070ULL, 0x0000001004107825ULL, 0x000fe200078e0010ULL,
0x0000000b0800720cULL, 0x080fe40003f46070ULL, 0x0000000b0500720cULL, 0x080fe20003f66070ULL,
0x0000000d031f7c36ULL, 0x040fe20008000000ULL, 0x0000000b0300720cULL, 0x080fe20003f86070ULL,
0x0000000d00277c36ULL, 0x000fe20008000000ULL, 0x0000000b0200720cULL, 0x080fe20003fa6070ULL,
0x000002001f1e7825ULL, 0x000fe200078e000cULL, 0x0000000b0000720cULL, 0x000fc60003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012627faeULL, 0x0003e2000c901c4eULL,
0x0000000b0700720cULL, 0x080fe20003f26070ULL, 0x0000020025247825ULL, 0x100fe400078e000cULL,
0x0000000010617faeULL, 0x0005e2000d101c4eULL, 0x0000000b0600720cULL, 0x040fe20003f46070ULL,
0x0000000d060b7c36ULL, 0x000fe40008000000ULL, 0x0000020027267825ULL, 0x000fc800078e000cULL,
0x000002001d127825ULL, 0x002fc800078e000cULL, 0x0000000d051d7c36ULL, 0x000fe40008000000ULL,
0x000002000b107825ULL, 0x004fc800078e000cULL, 0x000002001d1c7825ULL, 0x000fc800078e000cULL,
0x0000001004127825ULL, 0x000fc800078e0012ULL, 0x0000001004107825ULL, 0x040fe200078e0010ULL,
0x0000000012607faeULL, 0x0003e6000c901c4eULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x00000000105f7faeULL, 0x0003e6000d101c4eULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x000000001c5e7faeULL, 0x0003e6000d901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x000000001e5b7faeULL, 0x0003e6000e101c4eULL, 0x0000001004267825ULL, 0x000fe200078e0026ULL,
0x00000000245a7faeULL, 0x0003e8000e901c4eULL, 0x0000000026597faeULL, 0x0003e2000f101c4eULL,
0x00000000008c7947ULL, 0x000fea0003800000ULL, 0x0000000d09137c36ULL, 0x000fe20008000000ULL,
0x0000000d070b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d08117c36ULL, 0x000fe20008000000ULL,
0x0000000d02257c10ULL, 0x000fe2000fffe0ffULL, 0x0000020013127825ULL, 0x000fc800078e000cULL,
0x0000020011107825ULL, 0x000fc800078e000cULL, 0x0000001004127825ULL, 0x000fc800078e0012ULL,
0x0000001004107825ULL, 0x000fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012627faeULL, 0x0003e6000b901c4eULL, 0x0000000d061d7c36ULL, 0x000fe20008000000ULL,
0x0000000010617faeULL, 0x0005e2000b901c4eULL, 0x0000000d031f7c36ULL, 0x000fe40008000000ULL,
0x0000000d00277c36ULL, 0x000fe40008000000ULL, 0x000002001f1e7825ULL, 0x000fc800078e000cULL,
0x000002000b127825ULL, 0x002fc800078e000cULL, 0x0000000d050b7c36ULL, 0x000fe40008000000ULL,
0x000002001d107825ULL, 0x004fc800078e000cULL, 0x000002000b1c7825ULL, 0x000fc800078e000cULL,
0x0000020025247825ULL, 0x000fc800078e000cULL, 0x0000020027267825ULL, 0x000fc800078e000cULL,
0x0000001004127825ULL, 0x000fc800078e0012ULL, 0x0000001004107825ULL, 0x040fe200078e0010ULL,
0x0000000012607faeULL, 0x0003e6000b901c4eULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x00000000105f7faeULL, 0x0003e6000b901c4eULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x000000001c5e7faeULL, 0x0003e6000b901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x000000001e5b7faeULL, 0x0003e6000b901c4eULL, 0x0000001004267825ULL, 0x000fe200078e0026ULL,
0x00000000245a7faeULL, 0x0003e8000b901c4eULL, 0x0000000026597faeULL, 0x0003e4000b901c4eULL,
0x00000014ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x01c6484c0b1079a7ULL, 0x002e640008500006ULL, 0x01c648110b0075a7ULL, 0x002e640008020146ULL,
0x000000cc003c9947ULL, 0x002fea0003800000ULL, 0x01c10000570b7984ULL, 0x000e620000000800ULL,
0x0000000100107802ULL, 0x000fe40000000f00ULL, 0x0000000a0b00720bULL, 0x002fda0003f3d000ULL,
0x00000000000e7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0e127812ULL, 0x000fe4000782c0ffULL,
0x01c30000570e7984ULL, 0x0002b60000000800ULL, 0x0000000000d49947ULL, 0x002fea0003800000ULL,
0x0000000a0b00720bULL, 0x000fe20003f34000ULL, 0x000000021200788cULL, 0x000fe2000bf05270ULL,
0x0000000b0a107209ULL, 0x000fca0007810000ULL, 0x800000100a117221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fc60003f4f008ULL, 0x3fb8aa3b11117820ULL, 0x000fe40000410000ULL,
0x00000000000a7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0a137812ULL, 0x000fe200078e3cffULL,
0x0000001100117308ULL, 0x000e660000000800ULL, 0x0000001312ff7212ULL, 0x000fe2000782c0ffULL,
0x01c500105700a388ULL, 0x000fe80000000800ULL, 0x00001f7d110a7589ULL, 0x002e7000000e0000ULL,
0x800000100b121221ULL, 0x000fe20000010000ULL, 0x0000001154547220ULL, 0x000fe20000410000ULL,
0x00001f7c110b7589ULL, 0x00072400000e0000ULL, 0x3fb8aa3b12121820ULL, 0x000fc80000410000ULL,
0x00000012005c1308ULL, 0x000f620000000800ULL, 0x00000001ff117807ULL, 0x008fe20000800000ULL,
0x0000000a38387220ULL, 0x082fe20000410000ULL, 0x0000000a39397220ULL, 0x080fe20000410000ULL,
0x0000000a34347220ULL, 0x080fe20000410000ULL, 0x0000000a35357220ULL, 0x080fe20000410000ULL,
0x0000000a30307220ULL, 0x080fe20000410000ULL, 0x0000000a31317220ULL, 0x080fe20000410000ULL,
0x0000000a14147220ULL, 0x080fe20000410000ULL, 0x0000000a15157220ULL, 0x080fe20000410000ULL,
0x0000000a18187220ULL, 0x080fe20000410000ULL, 0x0000000a19197220ULL, 0x080fe20000410000ULL,
0x0000000a20207220ULL, 0x080fe20000410000ULL, 0x0000000a21217220ULL, 0x080fe20000410000ULL,
0x0000000a2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000a2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000a3d3d7220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0010ULL, 0x0000000b3a3a7220ULL, 0x090fe20000410000ULL,
0x0000000b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000b36367220ULL, 0x080fe20000410000ULL,
0x0000000b37377220ULL, 0x080fe20000410000ULL, 0x0000000b32327220ULL, 0x080fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b16167220ULL, 0x080fe20000410000ULL,
0x0000000b17177220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x080fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000b3f3f7220ULL, 0x000fe20000410000ULL, 0x0000761011107816ULL, 0x000fe20000000010ULL,
0x0000000e5c0e1220ULL, 0x024fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x01300000721c783bULL, 0x000fe20000000200ULL, 0x0000005cff0b723eULL, 0x000fe200000010ffULL,
0x000000c0070b7890ULL, 0x000fe2000fffe03fULL, 0x0000991010447816ULL, 0x000fe200000000ffULL,
0x000000007324783bULL, 0x000fe20000004200ULL, 0x000054100b0b7816ULL, 0x000fe2000000000bULL,
0x00000008050d72a4ULL, 0x000fe2000f8e020bULL, 0x000000ff4400720cULL, 0x000fe20003f25270ULL,
0x000000007528783bULL, 0x000fe20000004200ULL, 0x000000540e547221ULL, 0x004fc60000010000ULL,
0x000000007440783bULL, 0x000fe80000004200ULL, 0x00001f7d0b4c7589ULL, 0x000e6800000e0000ULL,
0x00001f7c0b4d7589ULL, 0x000ea800000e0000ULL, 0x000000007610783bULL, 0x000ee80000004200ULL,
0x000000007848783bULL, 0x000fe80000004200ULL, 0x000000007b44783bULL, 0x000fe20000004200ULL,
0x0000004c1c1c9232ULL, 0x002fc40000200000ULL, 0x0000004c1e1e9232ULL, 0x000fe40000200000ULL,
0x0000004d1d1d9232ULL, 0x084fe40000200000ULL, 0x0000004d1f1f9232ULL, 0x000fce0000200000ULL,
0x000000241c38723cULL, 0x000fec0000041838ULL, 0x000000261c34723cULL, 0x000fe20000041834ULL,
0x013000007724783bULL, 0x000e6a0000000200ULL, 0x000000281c18723cULL, 0x000fec0000041818ULL,
0x000000401c30723cULL, 0x000fec0000041830ULL, 0x000000421c14723cULL, 0x000fe20000041814ULL,
0x000000007a40783bULL, 0x000fea0000004200ULL, 0x0000002a1c28723cULL, 0x000fe20000041820ULL,
0x000000007920783bULL, 0x000eaa0000004200ULL, 0x000000101c2c723cULL, 0x008fec000004182cULL,
0x000000121c10723cULL, 0x000fe2000004183cULL, 0x0000004c24249232ULL, 0x002fc40000200000ULL,
0x0000004c26269232ULL, 0x000fe40000200000ULL, 0x0000004d25259232ULL, 0x080fe40000200000ULL,
0x0000004d27279232ULL, 0x000fce0000200000ULL, 0x000000482438723cULL, 0x000fec0000041838ULL,
0x0000004a2434723cULL, 0x000fec0000041834ULL, 0x000000202430723cULL, 0x004fec0000041830ULL,
0x000000222414723cULL, 0x000fec0000041814ULL, 0x000000402418723cULL, 0x000fec0000041818ULL,
0x000000422428723cULL, 0x000fec0000041828ULL, 0x00000044242c723cULL, 0x000fec000004182cULL,
0x000000462410723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000c48947ULL, 0x000fde0003800000ULL,
0x0000000b0c00728cULL, 0x000fe4000bf01070ULL, 0x8000000bff0e7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000d05257c10ULL, 0x000fe2000fffe0ffULL, 0x0000000d08217c36ULL, 0x000fe20008000000ULL,
0x0000000b0c097287ULL, 0x000fe2000c000000ULL, 0x0000000d071f7c36ULL, 0x000fe40008000000ULL,
0x0000020021207825ULL, 0x000fc800078e000cULL, 0x00000009ff1d7e24ULL, 0x000fe4000f8e00ffULL,
0x000002001f1e7825ULL, 0x000fc600078e000cULL, 0x000000201d0e7446ULL, 0x000fe2000380000eULL,
0x0000001004207825ULL, 0x040fe200078e0020ULL, 0x0000000d091d7c10ULL, 0x000fe4000fffe0ffULL,
0x0000000e0900720cULL, 0x080fe20003f46070ULL, 0x00000010041e7825ULL, 0x000fe200078e001eULL,
0x0000000e0800720cULL, 0x080fe40003f66070ULL, 0x0000000e0700720cULL, 0x080fe20003f86070ULL,
0x000002001d1c7825ULL, 0x000fe200078e000cULL, 0x0000000e0200720cULL, 0x000fc40003fa6070ULL,
0x0000000e0000720cULL, 0x000fe20003fc6070ULL, 0x0000000d06237c36ULL, 0x000fe40008000000ULL,
0x00000010041c7825ULL, 0x000fc800078e001cULL, 0x0000000d03277c36ULL, 0x000fe20008000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c687faeULL, 0x0003e2000d101c4eULL,
0x0000000e0500720cULL, 0x080fe20003f46070ULL, 0x0000000d023d7c36ULL, 0x000fe40008000000ULL,
0x0000000020677faeULL, 0x0005e2000d901c4eULL, 0x0000000e0600720cULL, 0x080fe20003f66070ULL,
0x0000000d003f7c36ULL, 0x000fe40008000000ULL, 0x000000001e667faeULL, 0x0007e2000e101c4eULL,
0x0000000e0300720cULL, 0x000fe20003f86070ULL, 0x00000200231c7825ULL, 0x002fc800078e000cULL,
0x0000020025207825ULL, 0x004fc800078e000cULL, 0x0000020027247825ULL, 0x000fc800078e000cULL,
0x000002003d227825ULL, 0x000fc800078e000cULL, 0x000002003f1e7825ULL, 0x008fc800078e000cULL,
0x00000010041c7825ULL, 0x000fc800078e001cULL, 0x0000001004207825ULL, 0x040fe200078e0020ULL,
0x000000001c657faeULL, 0x0003e6000d901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x0000000020647faeULL, 0x0003e6000d101c4eULL, 0x0000001004227825ULL, 0x040fe200078e0022ULL,
0x00000000245d7faeULL, 0x0003e6000e101c4eULL, 0x00000010041e7825ULL, 0x000fe200078e001eULL,
0x0000000022567faeULL, 0x0003e8000e901c4eULL, 0x000000001e0f7faeULL, 0x0003e2000f101c4eULL,
0x00000000008c7947ULL, 0x000fea0003800000ULL, 0x0000000d091f7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000d081d7c36ULL, 0x000fe40008000000ULL, 0x0000000d07217c36ULL, 0x000fe40008000000ULL,
0x000002001f1e7825ULL, 0x000fc800078e000cULL, 0x000002001d1c7825ULL, 0x000fc800078e000cULL,
0x00000010041e7825ULL, 0x000fc800078e001eULL, 0x00000010041c7825ULL, 0x000fe200078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e687faeULL, 0x0003e6000b901c4eULL,
0x0000000d06237c36ULL, 0x000fe20008000000ULL, 0x000000001c677faeULL, 0x0005e2000b901c4eULL,
0x0000000d03257c36ULL, 0x000fe40008000000ULL, 0x0000000d02277c36ULL, 0x000fe40008000000ULL,
0x0000000d003d7c36ULL, 0x000fc40008000000ULL, 0x00000200211e7825ULL, 0x002fe200078e000cULL,
0x0000000d05217c10ULL, 0x000fc6000fffe0ffULL, 0x00000200231c7825ULL, 0x004fc800078e000cULL,
0x0000020021207825ULL, 0x000fc800078e000cULL, 0x0000020025227825ULL, 0x000fc800078e000cULL,
0x0000020027247825ULL, 0x000fc800078e000cULL, 0x000002003d267825ULL, 0x000fc800078e000cULL,
0x00000010041e7825ULL, 0x000fc800078e001eULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x000000001e667faeULL, 0x0003e6000b901c4eULL, 0x0000001004207825ULL, 0x040fe200078e0020ULL,
0x000000001c657faeULL, 0x0003e6000b901c4eULL, 0x0000001004227825ULL, 0x040fe200078e0022ULL,
0x0000000020647faeULL, 0x0003e6000b901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x00000000225d7faeULL, 0x0003e6000b901c4eULL, 0x0000001004267825ULL, 0x000fe200078e0026ULL,
0x0000000024567faeULL, 0x0003e8000b901c4eULL, 0x00000000260f7faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000c0b00728cULL, 0x000fe2000bf06070ULL,
0x00000001004c7802ULL, 0x000fe40000000f00ULL, 0x00001f7d0b0e7589ULL, 0x000fe800000e0000ULL,
0x00001f7c0b0b7589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x01300000711c783bULL, 0x002e680000000200ULL, 0x000000007044783bULL, 0x000ea80000004200ULL,
0x000000006f40783bULL, 0x000fe80000004200ULL, 0x000000006924783bULL, 0x000fe80000004200ULL,
0x000000006d20783bULL, 0x000fe80000004200ULL, 0x01300000633c783bULL, 0x000ee80000000200ULL,
0x000000006a48783bULL, 0x000f220000004200ULL, 0x0000000e1c1c9232ULL, 0x002fc40000200000ULL,
0x0000000e1e1e9232ULL, 0x000fe40000200000ULL, 0x0000000b1d1d9232ULL, 0x080fe40000200000ULL,
0x0000000b1f1f9232ULL, 0x000fce0000200000ULL, 0x000000441c38723cULL, 0x004fec0000041838ULL,
0x000000461c34723cULL, 0x000fe20000041834ULL, 0x000000006c44783bULL, 0x000e620000004200ULL,
0x0000000e3c3c9232ULL, 0x088fe40000200000ULL, 0x0000000e3e3e9232ULL, 0x000fc40000200000ULL,
0x000000401c30723cULL, 0x000fe20000041830ULL, 0x0000000b3d3d9232ULL, 0x080fe40000200000ULL,
0x0000000b3f3f9232ULL, 0x000fe20000200000ULL, 0x000000000000781cULL, 0x000fe40003f2f008ULL,
0x000000421c14723cULL, 0x000fe20000041814ULL, 0x000000006b40783bULL, 0x000eaa0000004200ULL,
0x000000241c18723cULL, 0x000fec0000041818ULL, 0x000000261c28723cULL, 0x000fe20000041828ULL,
0x000000006e24783bULL, 0x000ee20000004200ULL, 0x01c6984cffff79a7ULL, 0x000be80008500006ULL,
0x000000201c2c723cULL, 0x000fec000004182cULL, 0x000000221c10723cULL, 0x000fec0000041810ULL,
0x000000483c38723cULL, 0x010fec0000041838ULL, 0x0000004a3c34723cULL, 0x000fec0000041834ULL,
0x000000443c30723cULL, 0x002fec0000041830ULL, 0x000000463c14723cULL, 0x000fec0000041814ULL,
0x000000403c18723cULL, 0x004fec0000041818ULL, 0x000000423c20723cULL, 0x000fec0000041828ULL,
0x000000243c2c723cULL, 0x008fec000004182cULL, 0x000000263c3c723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000001400241947ULL, 0x020fde0003800000ULL,
0x000000e007077890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000008050b72a4ULL, 0x000fe2000f8e0207ULL, 0x0000000000c48947ULL, 0x000ff60003800000ULL,
0x000000070c00728cULL, 0x000fe4000bf01070ULL, 0x80000007ff0b7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000b08117c10ULL, 0x000fe2000fffe0ffULL, 0x0000000b09137c36ULL, 0x000fe20008000000ULL,
0x000000070c097287ULL, 0x000fe2000c000000ULL, 0x0000000b071d7c36ULL, 0x000fe20008000000ULL,
0x0000000b031f7c10ULL, 0x000fe2000fffe0ffULL, 0x0000020013127825ULL, 0x000fc800078e000cULL,
0x00000009ff0e7e24ULL, 0x000fe4000f8e00ffULL, 0x0000020011107825ULL, 0x000fc600078e000cULL,
0x000000200e0b7446ULL, 0x000fe2000380000bULL, 0x0000001004127825ULL, 0x000fc600078e0012ULL,
0x0000000b0900720cULL, 0x080fe20003f26070ULL, 0x0000001004107825ULL, 0x000fe200078e0010ULL,
0x0000000b0800720cULL, 0x080fe40003f06070ULL, 0x0000000b0600720cULL, 0x080fe20003f46070ULL,
0x0000000b02257c36ULL, 0x000fe20008000000ULL, 0x0000000b0500720cULL, 0x080fe20003f66070ULL,
0x0000000b00277c36ULL, 0x000fe20008000000ULL, 0x0000000b0300720cULL, 0x080fe20003f86070ULL,
0x000002001f1e7825ULL, 0x000fe200078e000cULL, 0x0000000b0200720cULL, 0x000fc40003fa6070ULL,
0x0000000b0000720cULL, 0x080fe20003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012627faeULL, 0x0003e2000c901c4eULL, 0x0000000b0700720cULL, 0x000fe20003f26070ULL,
0x0000000b060b7c36ULL, 0x000fe40008000000ULL, 0x0000000010617faeULL, 0x0005e2000c101c4eULL,
0x0000020025247825ULL, 0x000fc800078e000cULL, 0x0000020027267825ULL, 0x000fc800078e000cULL,
0x000002001d127825ULL, 0x002fc800078e000cULL, 0x0000000b051d7c36ULL, 0x000fe40008000000ULL,
0x000002000b107825ULL, 0x004fc800078e000cULL, 0x000002001d1c7825ULL, 0x000fc800078e000cULL,
0x0000001004127825ULL, 0x000fc800078e0012ULL, 0x0000001004107825ULL, 0x040fe200078e0010ULL,
0x0000000012607faeULL, 0x0003e6000c901c4eULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x00000000105f7faeULL, 0x0003e6000d101c4eULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x000000001c5e7faeULL, 0x0003e6000d901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x000000001e5b7faeULL, 0x0003e6000e101c4eULL, 0x0000001004267825ULL, 0x000fe200078e0026ULL,
0x00000000245a7faeULL, 0x0003e8000e901c4eULL, 0x0000000026597faeULL, 0x0003e2000f101c4eULL,
0x00000000008c7947ULL, 0x000fea0003800000ULL, 0x0000000b09117c36ULL, 0x000fe20008000000ULL,
0x0000000b08137c10ULL, 0x000fe2000fffe0ffULL, 0x0000000b071d7c36ULL, 0x000fe20008000000ULL,
0x0000000b03257c10ULL, 0x000fe2000fffe0ffULL, 0x0000020011107825ULL, 0x000fc800078e000cULL,
0x0000020013127825ULL, 0x000fc800078e000cULL, 0x0000001004107825ULL, 0x000fc800078e0010ULL,
0x0000001004127825ULL, 0x000fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010627faeULL, 0x0003e6000b901c4eULL, 0x000002001d1c7825ULL, 0x000fe200078e000cULL,
0x0000000012617faeULL, 0x0005e6000b901c4eULL, 0x0000000b060b7c36ULL, 0x000fe40008000000ULL,
0x0000000b051f7c36ULL, 0x000fc40008000000ULL, 0x0000000b02277c36ULL, 0x000fe40008000000ULL,
0x0000000b00297c36ULL, 0x000fe40008000000ULL, 0x000002000b107825ULL, 0x002fc800078e000cULL,
0x0000001004127825ULL, 0x004fc800078e001cULL, 0x000002001f1c7825ULL, 0x100fe200078e000cULL,
0x0000000012607faeULL, 0x0003e6000b901c4eULL, 0x00000200251e7825ULL, 0x000fc800078e000cULL,
0x0000020027247825ULL, 0x000fc800078e000cULL, 0x0000020029267825ULL, 0x000fc800078e000cULL,
0x0000001004107825ULL, 0x000fc800078e0010ULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x00000000105f7faeULL, 0x0003e6000b901c4eULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x000000001c5e7faeULL, 0x0003e6000b901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x000000001e5b7faeULL, 0x0003e6000b901c4eULL, 0x0000001004267825ULL, 0x000fe200078e0026ULL,
0x00000000245a7faeULL, 0x0003e8000b901c4eULL, 0x0000000026597faeULL, 0x0003e4000b901c4eULL,
0x00000014ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x01c6684c0b1079a7ULL, 0x002e640008500006ULL, 0x01c668110b0075a7ULL, 0x002e640008000146ULL,
0x000000b800388947ULL, 0x002fea0003800000ULL, 0x01c1800057117984ULL, 0x000e620000000800ULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000000a1100720bULL, 0x002fda0003f1d000ULL,
0x00000000000b7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0b127812ULL, 0x000fe4000780c0ffULL,
0x01c38000570b7984ULL, 0x0002b60000000800ULL, 0x0000000000d08947ULL, 0x002fea0003800000ULL,
0x0000000a1100720bULL, 0x000fe20003f14000ULL, 0x000000031200788cULL, 0x000fe2000bf05270ULL,
0x000000110a0e7209ULL, 0x000fca0007810000ULL, 0x8000000e0a107221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fc60003f2f008ULL, 0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL,
0x00000000000a7806ULL, 0x000fe400000e0100ULL, 0x0000001000137308ULL, 0x000e640000000800ULL,
0x0000ffff0a1d7812ULL, 0x000fc800078e3cffULL, 0x0000001d12ff7212ULL, 0x000fe2000780c0ffULL,
0x01c5800e57009388ULL, 0x000fe60000000800ULL, 0x00000001ff1c7807ULL, 0x000fe20000000000ULL,
0x00001f7d130a7589ULL, 0x002e6200000e0000ULL, 0x0000001354547220ULL, 0x000fce0000410000ULL,
0x8000000e11120221ULL, 0x000fe40000010000ULL, 0x00001f7c13117589ULL, 0x000ee400000e0000ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x00000012005c0308ULL, 0x000f220000000800ULL,
0x0000000a38387220ULL, 0x082fe20000410000ULL, 0x0000000a39397220ULL, 0x080fe20000410000ULL,
0x0000000a34347220ULL, 0x080fe20000410000ULL, 0x0000000a35357220ULL, 0x080fe20000410000ULL,
0x0000000a30307220ULL, 0x080fe20000410000ULL, 0x0000000a31317220ULL, 0x080fe20000410000ULL,
0x0000000a14147220ULL, 0x080fe20000410000ULL, 0x0000000a15157220ULL, 0x080fe20000410000ULL,
0x0000000a18187220ULL, 0x080fe20000410000ULL, 0x0000000a19197220ULL, 0x080fe20000410000ULL,
0x0000000a20207220ULL, 0x080fe20000410000ULL, 0x0000000a21217220ULL, 0x080fe20000410000ULL,
0x0000000a2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000a2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000a3d3d7220ULL, 0x000fe20000410000ULL,
0x000000113a3a7220ULL, 0x088fe20000410000ULL, 0x000000113b3b7220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x080fe20000410000ULL,
0x0000001132327220ULL, 0x080fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x000000111a1a7220ULL, 0x080fe20000410000ULL, 0x000000111b1b7220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x000000112e2e7220ULL, 0x080fe20000410000ULL, 0x000000112f2f7220ULL, 0x080fe20000410000ULL,
0x000000113e3e7220ULL, 0x080fe20000410000ULL, 0x000000113f3f7220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fc400078e000eULL, 0x0000000b5c0b0220ULL, 0x014fce0000410000ULL,
0x00003c00015e7983ULL, 0x000ee20000100800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x013800007248783bULL, 0x000fe20000000200ULL, 0x0000005cff0e723eULL, 0x000fe200000010ffULL,
0x000000540b547221ULL, 0x004fe20000010000ULL, 0x000099101c247816ULL, 0x000fe200000000ffULL,
0x000000007310783bULL, 0x000fe20000004200ULL, 0x000054100e0e7816ULL, 0x000fe4000000000eULL,
0x000000ff2400720cULL, 0x000fe20003f05270ULL, 0x000000007458783bULL, 0x000fe80000004200ULL,
0x000000007550783bULL, 0x000fe80000004200ULL, 0x00000000764c783bULL, 0x000fe80000004200ULL,
0x00001f7d0e557589ULL, 0x000e6800000e0000ULL, 0x00001f7c0e577589ULL, 0x000ea800000e0000ULL,
0x01380000771c783bULL, 0x000f280000000200ULL, 0x000000007844783bULL, 0x000f680000004200ULL,
0x000000007940783bULL, 0x000f680000004200ULL, 0x000000007a28783bULL, 0x000f680000004200ULL,
0x000000007b24783bULL, 0x000f620000004200ULL, 0x0000005548488232ULL, 0x002fc40000200000ULL,
0x000000554a4a8232ULL, 0x000fe40000200000ULL, 0x0000005749498232ULL, 0x084fe40000200000ULL,
0x000000574b4b8232ULL, 0x000fce0000200000ULL, 0x000000104838723cULL, 0x000fec0000041838ULL,
0x000000124810723cULL, 0x000fe20000041834ULL, 0x000000551c1c8232ULL, 0x010fca0000200000ULL,
0x000000584830723cULL, 0x000fe20000041830ULL, 0x000000551e1e8232ULL, 0x000fe40000200000ULL,
0x000000571d1d8232ULL, 0x080fe40000200000ULL, 0x000000571f1f8232ULL, 0x000fe20000200000ULL,
0x0000005a4814723cULL, 0x000fec0000041814ULL, 0x000000504818723cULL, 0x000fec0000041818ULL,
0x000000524820723cULL, 0x000fec0000041820ULL, 0x0000004c482c723cULL, 0x000fec000004182cULL,
0x0000004e483c723cULL, 0x000fec000004183cULL, 0x000000441c38723cULL, 0x020fec0000041838ULL,
0x000000461c10723cULL, 0x000fec0000041810ULL, 0x000000401c30723cULL, 0x000fec0000041830ULL,
0x000000421c14723cULL, 0x000fec0000041814ULL, 0x000000281c18723cULL, 0x000fec0000041818ULL,
0x0000002a1c20723cULL, 0x000fec0000041820ULL, 0x000000241c2c723cULL, 0x000fec000004182cULL,
0x000000261c3c723cULL, 0x000fe2000004183cULL, 0x000000005e0772caULL, 0x008fda00000e0000ULL,
0x0000000715077290ULL, 0x000fc8000fffe03fULL, 0x0000000107097890ULL, 0x000fe4000fffe03fULL,
0x0000000807077899ULL, 0x000fe4000800063fULL, 0x000000040900728cULL, 0x000fe4000bf06070ULL,
0x00000008050872a4ULL, 0x000fc8000f8e0207ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000000c49947ULL, 0x000fea0003800000ULL,
0x000000070c00728cULL, 0x000fe4000bf01070ULL, 0x80000007ff0b7e24ULL, 0x000fe2000f8e02ffULL,
0x0000000800257c10ULL, 0x000fe2000fffe0ffULL, 0x00000008091d7c36ULL, 0x000fe20008000000ULL,
0x000000070c097287ULL, 0x000fe2000c000000ULL, 0x00000008081f7c36ULL, 0x000fca0008000000ULL,
0x00000009001c7c02ULL, 0x000fc80008000f00ULL, 0x000000201c0b7446ULL, 0x000fe2000380000bULL,
0x000002001d1c7825ULL, 0x000fc600078e000cULL, 0x0000000b0900720cULL, 0x080fe40003f26070ULL,
0x0000000b0800720cULL, 0x080fe20003f66070ULL, 0x000002001f087825ULL, 0x000fe200078e000cULL,
0x0000000b0700720cULL, 0x080fe40003f46070ULL, 0x0000000b0300720cULL, 0x080fe20003f86070ULL,
0x00000010041c7825ULL, 0x000fe200078e001cULL, 0x0000000b0200720cULL, 0x080fe40003fa6070ULL,
0x0000000b0000720cULL, 0x000fe20003fc6070ULL, 0x0000001004087825ULL, 0x000fc400078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c687faeULL, 0x0003e2000c901c4eULL,
0x0000000b0600720cULL, 0x080fe20003f26070ULL, 0x0000000807077c36ULL, 0x000fe40008000000ULL,
0x0000000008677faeULL, 0x0005e2000d901c4eULL, 0x0000000b0500720cULL, 0x040fe20003f66070ULL,
0x0000000805057c36ULL, 0x000fe20008000000ULL, 0x00000008060b7c10ULL, 0x000fe2000fffe0ffULL,
0x00000008021f7c36ULL, 0x000fe40008000000ULL, 0x00000008031d7c36ULL, 0x002fc40008000000ULL,
0x0000020007027825ULL, 0x000fc800078e000cULL, 0x000002000b067825ULL, 0x000fc800078e000cULL,
0x0000020005087825ULL, 0x004fc800078e000cULL, 0x000002001d1c7825ULL, 0x000fc800078e000cULL,
0x000002001f1e7825ULL, 0x000fc800078e000cULL, 0x00000200250c7825ULL, 0x000fc800078e000cULL,
0x0000001004027825ULL, 0x000fc800078e0002ULL, 0x0000001004067825ULL, 0x040fe200078e0006ULL,
0x0000000002667faeULL, 0x0003e6000d101c4eULL, 0x0000001004087825ULL, 0x040fe200078e0008ULL,
0x0000000006657faeULL, 0x0003e6000c901c4eULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x0000000008647faeULL, 0x0003e6000d901c4eULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x000000001c5d7faeULL, 0x0003e6000e101c4eULL, 0x00000010040c7825ULL, 0x000fe200078e000cULL,
0x000000001e567faeULL, 0x0003e8000e901c4eULL, 0x000000000c0f7faeULL, 0x0003e2000f101c4eULL,
0x00000000008c7947ULL, 0x000fea0003800000ULL, 0x0000000809097c36ULL, 0x000fe20008000000ULL,
0x00000008061f7c10ULL, 0x000fe2000fffe0ffULL, 0x00000008080b7c36ULL, 0x000fe20008000000ULL,
0x0000000800297c10ULL, 0x000fe2000fffe0ffULL, 0x00000008071d7c36ULL, 0x000fe40008000000ULL,
0x0000000803257c36ULL, 0x000fe40008000000ULL, 0x0000000802277c36ULL, 0x000fe40008000000ULL,
0x0000000805057c36ULL, 0x000fc40008000000ULL, 0x0000020009027825ULL, 0x000fc800078e000cULL,
0x000002000b067825ULL, 0x000fc800078e000cULL, 0x000002001d087825ULL, 0x000fc800078e000cULL,
0x000002001f1c7825ULL, 0x000fc800078e000cULL, 0x00000200051e7825ULL, 0x000fc800078e000cULL,
0x0000020025247825ULL, 0x000fc800078e000cULL, 0x0000020027267825ULL, 0x000fc800078e000cULL,
0x0000001004027825ULL, 0x000fc800078e0002ULL, 0x00000200290c7825ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002687faeULL, 0x0003e6000b901c4eULL,
0x0000001004067825ULL, 0x000fc800078e0006ULL, 0x0000001004087825ULL, 0x040fe200078e0008ULL,
0x0000000006677faeULL, 0x0003e6000b901c4eULL, 0x00000010041c7825ULL, 0x040fe200078e001cULL,
0x0000000008667faeULL, 0x0003e6000b901c4eULL, 0x00000010041e7825ULL, 0x040fe200078e001eULL,
0x000000001c657faeULL, 0x0003e6000b901c4eULL, 0x0000001004247825ULL, 0x040fe200078e0024ULL,
0x000000001e647faeULL, 0x0003e6000b901c4eULL, 0x0000001004267825ULL, 0x040fe200078e0026ULL,
0x00000000245d7faeULL, 0x0003e6000b901c4eULL, 0x00000010040c7825ULL, 0x000fe200078e000cULL,
0x0000000026567faeULL, 0x0003e8000b901c4eULL, 0x000000000c0f7faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff007424ULL, 0x000fc600078e00ffULL,
0x00001f7d0e7d7589ULL, 0x000fe800000e0000ULL, 0x00001f7c0e7c7589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x013800007104783bULL, 0x002e680000000200ULL,
0x00000000701c783bULL, 0x000ea80000004200ULL, 0x000000006f24783bULL, 0x000fe80000004200ULL,
0x000000006928783bULL, 0x000fe80000004200ULL, 0x000000006d34783bULL, 0x000fe80000004200ULL,
0x013800006360783bULL, 0x000ee80000000200ULL, 0x000000006a4c783bULL, 0x000f280000004200ULL,
0x000000006c48783bULL, 0x000f680000004200ULL, 0x000000006b44783bULL, 0x000f280000004200ULL,
0x000000006e40783bULL, 0x000f220000004200ULL, 0x01c6a000ffff79a7ULL, 0x0005e20008500006ULL,
0x0000007d04048232ULL, 0x002fc40000200000ULL, 0x0000007d06068232ULL, 0x000fe40000200000ULL,
0x0000007c05058232ULL, 0x080fe40000200000ULL, 0x0000007c07078232ULL, 0x000fce0000200000ULL,
0x0000001c0438723cULL, 0x004fec0000041838ULL, 0x0000001e0410723cULL, 0x000fe20000041810ULL,
0x0000007d60608232ULL, 0x088fe40000200000ULL, 0x0000007d62628232ULL, 0x000fe40000200000ULL,
0x0000007c61618232ULL, 0x080fe20000200000ULL, 0x000000240430723cULL, 0x000fe20000041830ULL,
0x0000007c63638232ULL, 0x000fca0000200000ULL, 0x000000260414723cULL, 0x000fec0000041814ULL,
0x000000280418723cULL, 0x000fec0000041818ULL, 0x0000002a0420723cULL, 0x000fec0000041820ULL,
0x00000034042c723cULL, 0x000fec000004182cULL, 0x00000036043c723cULL, 0x000fec000004183cULL,
0x0000004c6038723cULL, 0x010fec0000041838ULL, 0x0000004e6034723cULL, 0x000fec0000041810ULL,
0x000000486030723cULL, 0x020fec0000041830ULL, 0x0000004a6014723cULL, 0x000fec0000041814ULL,
0x000000446018723cULL, 0x000fec0000041818ULL, 0x000000466020723cULL, 0x000fec0000041820ULL,
0x00000040602c723cULL, 0x000fec000004182cULL, 0x00000042603c723cULL, 0x000fde000004183cULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00003c0001007983ULL, 0x000ea40000300800ULL,
0x0000001500007c36ULL, 0x004fca0008000000ULL, 0x00003c0001007387ULL, 0x0003e20000100800ULL,
0x0000000400007c0cULL, 0x000fda000bf06070ULL, 0xffffffa0009c8947ULL, 0x002fea000383ffffULL,
0x00000000001379c3ULL, 0x000e640000002500ULL, 0x000000041300728cULL, 0x002fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000c40947ULL, 0x000fea0003800000ULL,
0x0180000054007836ULL, 0x000fca0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000736000027802ULL, 0x000fce0000000f00ULL, 0x000000ac00f47944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000005400037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000054ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x00000002ff057819ULL, 0x010fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0500027589ULL, 0x000ea800000e0000ULL,
0x00001f0300037589ULL, 0x000ee200000e0000ULL, 0x0000003802387220ULL, 0x044fe20000410000ULL,
0x0000003902397220ULL, 0x040fe20000410000ULL, 0x0000003402347220ULL, 0x040fe20000410000ULL,
0x0000003502357220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000001802187220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x040fe20000410000ULL, 0x0000002c022c7220ULL, 0x040fe20000410000ULL,
0x0000002d022d7220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x040fe20000410000ULL,
0x0000003d023d7220ULL, 0x000fe20000410000ULL, 0x0000003a033a7220ULL, 0x048fe20000410000ULL,
0x0000003b033b7220ULL, 0x040fe20000410000ULL, 0x0000003603367220ULL, 0x040fe20000410000ULL,
0x0000003703377220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000003e033e7220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000612067291ULL, 0x000fe2000f8e583fULL, 0x00000020210d723eULL, 0x000fe200000010ffULL,
0x000000011500788cULL, 0x000fe2000bf05270ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0001200006167890ULL, 0x000fe2000fffe03fULL, 0x0000002c2d0e723eULL, 0x000fe400000010ffULL,
0x0000003c3d0f723eULL, 0x000fe400000010ffULL, 0x000000000000781cULL, 0x000fc40003f0f008ULL,
0x0000003a3b10723eULL, 0x000fe400000010ffULL, 0x000000363711723eULL, 0x000fe400000010ffULL,
0x000000323312723eULL, 0x000fe400000010ffULL, 0x000000161713723eULL, 0x000fe400000010ffULL,
0x0000002e2f16723eULL, 0x000fe400000010ffULL, 0x0000003e3f17723eULL, 0x000fc400000010ffULL,
0x00000003ff037819ULL, 0x004fe40000011600ULL, 0xfffffff8ff057812ULL, 0x000fe400078ee200ULL,
0x0000000303027812ULL, 0x000fe400078ec0ffULL, 0x0000000805097810ULL, 0x000fe20007ffe0ffULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0x0000000402067812ULL, 0x000fe400078efcffULL,
0x0000000702077812ULL, 0x000fe200078e7805ULL, 0x00000008090b7824ULL, 0x000fe200078e00ffULL,
0x0000000706057812ULL, 0x000fc400078e7805ULL, 0x00000007020c7812ULL, 0x000fe400078e7809ULL,
0x0000000706067812ULL, 0x000fe400078e7809ULL, 0x0000000407027212ULL, 0x080fe400078efcffULL,
0x0000000405087212ULL, 0x000fe400078efcffULL, 0x0000000b0c097212ULL, 0x080fe400078efcffULL,
0x0000000b060b7212ULL, 0x000fc400078efcffULL, 0x000000383904723eULL, 0x000fe400000010ffULL,
0x000000343505723eULL, 0x000fe400000010ffULL, 0x000000303106723eULL, 0x000fe400000010ffULL,
0x000000141507723eULL, 0x000fe400000010ffULL, 0x0000001602027c11ULL, 0x000fe4000f8e20ffULL,
0x00000018190c723eULL, 0x000fc400000010ffULL, 0x0000001608087c11ULL, 0x000fe2000f8e20ffULL,
0x0000000402007844ULL, 0x0005e20000000200ULL, 0x0000001609097c11ULL, 0x000fe4000f8e20ffULL,
0x0000001a1b14723eULL, 0x000fe200000010ffULL, 0x0000000c08007844ULL, 0x0005e20000000200ULL,
0x000000222315723eULL, 0x000fe400000010ffULL, 0x000000160b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001009007844ULL, 0x0005e80000000200ULL, 0x000000140b007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002400f08947ULL, 0x000fea0003800000ULL,
0x0000000600027c11ULL, 0x004fe2000f8e20ffULL, 0x00000000000979c3ULL, 0x000fe20000002700ULL,
0x00000012ff007c0cULL, 0x000fe2000bf05270ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x0000900000087ab9ULL, 0x000fe20000000800ULL, 0x01200000020c7984ULL, 0x0005280000000c00ULL,
0x00000000000479c3ULL, 0x000ee20000002600ULL, 0x0122000002107984ULL, 0x0004620000000c00ULL,
0x00000005090972a4ULL, 0x008fc4000f8e0204ULL, 0x00000005150472a4ULL, 0x000fe4000f8e023fULL,
0x00000015090772a4ULL, 0x000fe4000f8e023fULL, 0x00000008040872a4ULL, 0x000fe4000f8e023fULL,
0x00000013070a7290ULL, 0x000fe4000fffe03fULL, 0x01ffffff08177892ULL, 0x000fe2000f8ec03fULL,
0x0000000000380947ULL, 0x004ff60003800000ULL, 0x000000170a0b7290ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0x00000001ff047819ULL, 0x000fe20000011600ULL, 0x000000800a0c78a5ULL, 0x000fe4000f8e0004ULL,
0x000000800b0478a5ULL, 0x000fe2000f8e0004ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c04077812ULL, 0x000fc800078ec0ffULL, 0x0000000c07047c10ULL, 0x140fe4000fa3e002ULL,
0x0000000407067c10ULL, 0x000fe4000fc7e002ULL, 0x0000000dff057c10ULL, 0x000fe40008fe44ffULL,
0x00000005ff077c10ULL, 0x000fc60009fe84ffULL, 0x0000000a04007986ULL, 0x0005e8000c10190eULL,
0x0000005406007986ULL, 0x0005e4000c10190eULL, 0x00000fff08087891ULL, 0x000fe2000f8e403fULL,
0x000000ff0000720cULL, 0x040fe20000725670ULL, 0x0000960000107ab9ULL, 0x000fe20000000a00ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0x0000000a08047291ULL, 0x000fe2000f8fa03fULL,
0x0000021000007945ULL, 0x000fe60003800000ULL, 0x00001000040478a5ULL, 0x000fc8000f8e0010ULL,
0x00000400120478a5ULL, 0x000fcc000f8e0004ULL, 0x0000000400067c02ULL, 0x004fe20008000f00ULL,
0x00000005ff077e24ULL, 0x000fc8000f8e00ffULL, 0x0000001000047825ULL, 0x000fc800078e0006ULL,
0x0000001009067825ULL, 0x000fe200078e0006ULL, 0x0000000c04007986ULL, 0x0105e8000c101d0eULL,
0x0000001006007986ULL, 0x0025e2000c101d0eULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000940000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff150a7890ULL, 0x000fe4000fffe03fULL, 0x00000004090478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000aff077e24ULL, 0x004fe4000f8e00ffULL, 0x0000000400047c02ULL, 0x000fe20008000f00ULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ea800099ee1ceULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000a04007c0cULL, 0x000fc8000bf25270ULL, 0x00000001ff027807ULL, 0x000fca0000800000ULL,
0x00000002ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ef00000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000040000097882ULL, 0x000fc40000000000ULL, 0x0000065404097896ULL, 0x008fd20008000009ULL,
0x00000009ff027984ULL, 0x002e640008000000ULL, 0x000000ff0200720cULL, 0x002fda0003f25270ULL,
0x0000002000c49947ULL, 0x000fea0003800000ULL, 0x0000000c008c0947ULL, 0x000fea0003800000ULL,
0x00000015ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000f08947ULL, 0x000fea0003800000ULL,
0x0000000107047890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x00000080070a78a5ULL, 0x000fe4000f8e0010ULL,
0x00000080040478a5ULL, 0x000fe2000f8e0010ULL, 0x0000007002087812ULL, 0x000fe400078ec0ffULL,
0x0000000c03117812ULL, 0x004fc800078ec0ffULL, 0x0000000a11027c10ULL, 0x140fe4000f91e008ULL,
0x0000000411047c10ULL, 0x000fe4000fb5e008ULL, 0x0000000bff037c10ULL, 0x000fe400087e24ffULL,
0x00000005ff057c10ULL, 0x000fc600097e64ffULL, 0x0000000e02067981ULL, 0x000368000c1e1900ULL,
0x0000000e04077981ULL, 0x000362000c1e1900ULL, 0x000000021500788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000000207047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0010ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02097981ULL, 0x000362000c1e1900ULL, 0x000000041500788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000908947ULL, 0x002fea0003800000ULL,
0x0000000307047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0010ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020b7981ULL, 0x000362000c1e1900ULL, 0x000000041500788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000708947ULL, 0x002fea0003800000ULL,
0x0000000407047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0010ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020d7981ULL, 0x000362000c1e1900ULL, 0x000000061500788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000508947ULL, 0x002fea0003800000ULL,
0x0000000507047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0010ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020f7981ULL, 0x000362000c1e1900ULL, 0x000000061500788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x000000081500788cULL, 0x000fe4000bf06070ULL, 0x0000000607047890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f8f008ULL, 0x00000080040478a5ULL, 0x000fc8000f8e0010ULL,
0x00000007070a0890ULL, 0x000fe4000fffe03fULL, 0x0000000411027c10ULL, 0x000fe4000f91e008ULL,
0x000000800a0a08a5ULL, 0x000fe4000f8e0010ULL, 0x00000005ff037c10ULL, 0x000fc800087e24ffULL,
0x0000000a11044c10ULL, 0x000fe4000fb5e008ULL, 0x0000000e02117981ULL, 0x000364000c1e1900ULL,
0x0000000bff054c10ULL, 0x000fca00097e64ffULL, 0x0000000e04134981ULL, 0x000368000c1e1900ULL,
0x00000007150a7890ULL, 0x000fc8000fffe03fULL, 0x000000033f0a7899ULL, 0x000fcc000801160aULL,
0x0000000aff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800688947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x026fe200078e0006ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000960000187ab9ULL, 0x000fca0000000a00ULL, 0x000000150400728cULL, 0x000fe4000bf06070ULL,
0x0000000105057890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000a0500728cULL, 0x000fd8000bf06070ULL, 0x0000000800300947ULL, 0x022fea0003800000ULL,
0x00000008040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000506067209ULL, 0x000fe20007810000ULL,
0x00000001040d7890ULL, 0x000fe4000fffe03fULL, 0x000000150c00728cULL, 0x000fe4000bf26070ULL,
0x000000150d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x000000080b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000000400027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x000000800c0c78a5ULL, 0x000fe2000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02057981ULL, 0x000368000c1e1900ULL, 0x0000000400e82947ULL, 0x000fea0003800000ULL,
0x00000009040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fe20007810000ULL,
0x00000002040d7890ULL, 0x000fe4000fffe03fULL, 0x000000150c00728cULL, 0x000fe4000bf26070ULL,
0x000000150d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x000000090b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02077981ULL, 0x000368000c1e1900ULL, 0x0000000400a02947ULL, 0x000fea0003800000ULL,
0x0000000a040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000906067209ULL, 0x000fe20007810000ULL,
0x00000003040d7890ULL, 0x000fe4000fffe03fULL, 0x000000150c00728cULL, 0x000fe4000bf26070ULL,
0x000000150d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000a0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02097981ULL, 0x000368000c1e1900ULL, 0x0000000400582947ULL, 0x000fea0003800000ULL,
0x0000000b040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000b06067209ULL, 0x000fe20007810000ULL,
0x00000004040d7890ULL, 0x000fe4000fffe03fULL, 0x000000150c00728cULL, 0x000fe4000bf26070ULL,
0x000000150d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000b0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020b7981ULL, 0x000368000c1e1900ULL, 0x0000000400102947ULL, 0x000fea0003800000ULL,
0x0000000c040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fe20007810000ULL,
0x00000005040d7890ULL, 0x000fe4000fffe03fULL, 0x000000150c00728cULL, 0x000fe4000bf26070ULL,
0x000000150d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000c0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000000400027819ULL, 0x002fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x000000800c0c78a5ULL, 0x000fe2000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020d7981ULL, 0x000368000c1e1900ULL, 0x0000000000c82947ULL, 0x000fea0003800000ULL,
0x0000000d040c7890ULL, 0x000fe2000fffe03fULL, 0x0000000f06067209ULL, 0x000fe20007810000ULL,
0x00000006040d7890ULL, 0x000fe4000fffe03fULL, 0x000000150c00728cULL, 0x000fe4000bf26070ULL,
0x000000150d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000d0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020f7981ULL, 0x000368000c1e1900ULL, 0x0000000000802947ULL, 0x000fea0003800000ULL,
0x0000000e040c7890ULL, 0x000fe2000fffe03fULL, 0x0000001106067209ULL, 0x000fe20007810000ULL,
0x00000007040d7890ULL, 0x000fe4000fffe03fULL, 0x000000150c00728cULL, 0x000fe4000bf26070ULL,
0x000000150d00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000e0b0c7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000dff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02117981ULL, 0x000368000c1e1900ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x0000000f040c7890ULL, 0x000fe2000fffe03fULL, 0x0000001306067209ULL, 0x000fc60007810000ULL,
0x000000150c00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000f0b0c7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800c0c78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000c03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000dff037c10ULL, 0x000fca00087e24ffULL, 0x0000000e02137981ULL, 0x000368000c1e1900ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000804047890ULL, 0x000fe4000fffe03fULL,
0x000000080b0b7890ULL, 0x000fd4000fffe03fULL, 0xfffffff400ac8947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x0000000400027819ULL, 0x00afe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000903037c10ULL, 0x000fca000fffe002ULL,
0x0000000603007388ULL, 0x0203e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x00000007080c7291ULL, 0x000fe2000f8fa03fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000017070d7290ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x040fe200078e00ffULL,
0x00000001ff037819ULL, 0x002fe20000011600ULL, 0x00000009121a7291ULL, 0x000fe2000f8e603fULL,
0x0000002000077836ULL, 0x004fe20000000000ULL, 0x00009600000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x000010000c0478a5ULL, 0x000fe2000f8e000aULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x00000015ff007c0cULL, 0x000fe2000bf25270ULL,
0x00000400120478a5ULL, 0x000fe2000f8e0004ULL, 0x0000000903147c10ULL, 0x000fc4000fffe002ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000800d1888a5ULL, 0x000fe2000f8e000aULL,
0x0000001a000d7c11ULL, 0x040fe2000f8e20ffULL, 0x00000080070a88a5ULL, 0x000fe2000f8e000aULL,
0x0000000500057c02ULL, 0x000fe20008000f00ULL, 0x00000004ff047e24ULL, 0x000fe2000f8e00ffULL,
0x00000009121b8291ULL, 0x000fe2000f8e403fULL, 0x00000018ff087e24ULL, 0x000fe2000f8e00ffULL,
0x0000000912048291ULL, 0x000fe2000f8e403fULL, 0x00000019ff097e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b000b7c02ULL, 0x000fe20008000f00ULL, 0x0000001007067825ULL, 0x100fe200078e0004ULL,
0x0000001b000f8c11ULL, 0x040fe2000f8e20ffULL, 0x0000000014147984ULL, 0x000e620000000800ULL,
0x0000000400118c11ULL, 0x040fe2000f8e20ffULL, 0x0000000aff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000001000047825ULL, 0x000fe200078e0004ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000001000088825ULL, 0x040fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040d7faeULL, 0x0005e2000b901c4eULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000010000a8825ULL, 0x000fe200078e000aULL, 0x00380000060d7faeULL, 0x0005e2000b901c4eULL,
0x0000000000247805ULL, 0x000fc4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x04580000080f8faeULL, 0x0005e2000b901c4eULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x041800000a118faeULL, 0x0005e2000b901c4eULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800d09947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x104fe20000011600ULL,
0x000000010d0d7890ULL, 0x000fe2000fffe03fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee200ULL,
0x0000000107047890ULL, 0x000fe2000fffe03fULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000912057291ULL, 0x000fe2000f8e403fULL, 0x00000002ff3b7819ULL, 0x000fe20000011600ULL,
0x0000000805077836ULL, 0x040fe20000000000ULL, 0x0000000404067812ULL, 0x000fe200078efcffULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000000704377812ULL, 0x000fe200078e7805ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x000fe200078e7807ULL,
0x0000000dff367e24ULL, 0x000fe2000f8e00ffULL, 0x00000007063a7812ULL, 0x000fe200078e7807ULL,
0x00000004ff3c7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000706057812ULL, 0x000fe200078e7805ULL,
0x000000083b3d7836ULL, 0x000fe20000000000ULL, 0x0000000307077819ULL, 0x000fe200000006ffULL,
0x000000010c0c7890ULL, 0x000fe2000fffe03fULL, 0x0000003837377212ULL, 0x080fe200078efcffULL,
0x00000001000a7882ULL, 0x000fe20000000000ULL, 0x0000003805387212ULL, 0x000fe200078efcffULL,
0x0000960000187ab9ULL, 0x000fe20000000a00ULL, 0x0000000704397212ULL, 0x000fc400078efcffULL,
0x000000073a3a7212ULL, 0x000fe400078efcffULL, 0x00000005003f7c02ULL, 0x000fce0008000f00ULL,
0x000000150a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000900947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f04070ULL,
0x000000010a0d7892ULL, 0x000fe2000f8ec03fULL, 0x00000018ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x000010000c0478a5ULL, 0x000fe4000f8e0018ULL, 0x00000019ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b0a0b7899ULL, 0x000fe2000800063fULL, 0x0000002000077810ULL, 0x000fe20007ffe0ffULL,
0x00000400120478a5ULL, 0x000fe2000f8e0004ULL, 0x0000000dff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x000008000b0b7892ULL, 0x000fc6000f8ec03fULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x0000008036048825ULL, 0x100fe200078e000aULL, 0x00000005000d7c02ULL, 0x000fe20008000f00ULL,
0x0000000b1a0b7290ULL, 0x000fe4000fffe03fULL, 0x00000009121b8291ULL, 0x000fe2000f8e403fULL,
0x00000004ff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x00000009120d8291ULL, 0x000fe2000f8e403fULL,
0x000000803c0a8825ULL, 0x000fc800078e000aULL, 0x0000001bff3f8e24ULL, 0x000fe4000f8e00ffULL,
0x0000001000088825ULL, 0x000fc800078e0004ULL, 0x000000800e0f8824ULL, 0x000fe400078e023fULL,
0x0000000dff3f8e24ULL, 0x000fe4000f8e00ffULL, 0x0000001007067825ULL, 0x000fe200078e000cULL,
0x0000000f000f8211ULL, 0x000fc600078e20ffULL, 0x0000001000047825ULL, 0x040fe200078e000cULL,
0x0000000b000d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000800e118824ULL, 0x000fe400078e023fULL,
0x00000010000a8825ULL, 0x040fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000040d7faeULL, 0x0005e6000b901c4eULL, 0x0000001000118824ULL, 0x000fe200078e0211ULL,
0x00380000060d7faeULL, 0x0005e8000b901c4eULL, 0x04580000080f8faeULL, 0x0005e8000b901c4eULL,
0x041800000a118faeULL, 0x0005e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff0a047890ULL, 0x000fe2000fffe03fULL, 0x0000000136367836ULL, 0x000fe20000000000ULL,
0x000000150a00728cULL, 0x000fe2000bf06070ULL, 0x000000013c3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000704057899ULL, 0x000fe4000800063fULL, 0x0000000b04047899ULL, 0x000fe4000800063fULL,
0x0000008005057892ULL, 0x000fe2000f8ec03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000080004047892ULL, 0x000fc4000f8ec03fULL, 0x000000010a0a7890ULL, 0x000fe4000fffe03fULL,
0x0000000502047c10ULL, 0x004fe2000fffe03fULL, 0x000001801a047890ULL, 0x000fe4000fffe004ULL,
0x000000010c0c7890ULL, 0x000fe4000fffe03fULL, 0x00000001033e7824ULL, 0x000fe400078e0204ULL,
0x0000000437047c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003e0d7984ULL, 0x000ea20000000800ULL, 0x0000000438087c11ULL, 0x000fe4000f8e20ffULL,
0x00000004390c7c11ULL, 0x000fe2000f8e20ffULL, 0x004580003e407984ULL, 0x000fe20000000800ULL,
0x000000043a107c11ULL, 0x000fc6000f8e20ffULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000808783bULL, 0x000f220000000200ULL, 0x0000000d14117221ULL, 0x006fc60000010100ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x3fb8aa3b11457820ULL, 0x000fc60000410000ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x00010000043e7824ULL, 0x048fe200078e00ffULL,
0x0000763204047816ULL, 0x000fe20000000004ULL, 0x0000004500457308ULL, 0x000ee20000000800ULL,
0x0000001005427819ULL, 0x000fe200000006ffULL, 0x000100000b4a7824ULL, 0x010fe200078e00ffULL,
0x0000763209467816ULL, 0x000fe20000000046ULL, 0x0001000007447824ULL, 0x000fe200078e00ffULL,
0x0000763206417816ULL, 0x040fe20000000041ULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x0000001009487819ULL, 0x000fc400000006ffULL, 0x000076320b477816ULL, 0x000fe20000000047ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x0000763207437816ULL, 0x000fe40000000043ULL,
0x000076320a097816ULL, 0x040fe20000000009ULL, 0x000100000a0a7824ULL, 0x000fe400078e00ffULL,
0x0000004045527220ULL, 0x008fe20000410000ULL, 0x0000763205407816ULL, 0x000fe20000000040ULL,
0x0001000004057824ULL, 0x000fe200078e00ffULL, 0x0000763208457816ULL, 0x000fe20000000045ULL,
0x0000003552357221ULL, 0x000fe20000010000ULL, 0x00001f3b52517589ULL, 0x000ee200000e0000ULL,
0x0000001040077819ULL, 0x000fe200000006ffULL, 0x0001000008087824ULL, 0x000fc400078e00ffULL,
0x00001f3d52527589ULL, 0x000f2200000e0000ULL, 0x0001000043437824ULL, 0x000fe400078e00ffULL,
0x0001000045457824ULL, 0x000fe400078e00ffULL, 0x0001000009097824ULL, 0x000fe400078e00ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x000076320f4b7816ULL, 0x042fe2000000004bULL,
0x000100000f4e7824ULL, 0x000fe200078e00ffULL, 0x000076320d497816ULL, 0x000fc40000000049ULL,
0x00007632100f7816ULL, 0x044fe2000000000fULL, 0x00010000104d7824ULL, 0x000fe200078e00ffULL,
0x000000100d4c7819ULL, 0x000fe200000006ffULL, 0x000100004b4b7824ULL, 0x000fe200078e00ffULL,
0x0000763211107816ULL, 0x000fe20000000010ULL, 0x000100000f0f7824ULL, 0x000fe200078e00ffULL,
0x0000001011507819ULL, 0x000fe200000006ffULL, 0x00000051052c7223ULL, 0x088fe2000001002cULL,
0x0000001046057819ULL, 0x000fe200000006ffULL, 0x0000005106297223ULL, 0x080fe20000010029ULL,
0x000076320c0b7816ULL, 0x040fe2000000000bULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x000076320e0d7816ULL, 0x000fe2000000000dULL, 0x0000005105227223ULL, 0x000fe20000010022ULL,
0x0000763212117816ULL, 0x000fe20000000011ULL, 0x000100000e0e7824ULL, 0x000fe200078e00ffULL,
0x00007632134f7816ULL, 0x000fe2000000004fULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x0000001049497819ULL, 0x000fe200000006ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000001010057819ULL, 0x000fe200000006ffULL, 0x000100000b0b7824ULL, 0x000fc400078e00ffULL,
0x000000513e2d7223ULL, 0x080fe2000001002dULL, 0x000100000d0d7824ULL, 0x000fe400078e00ffULL,
0x00000051422b7223ULL, 0x080fe2000001002bULL, 0x0001000011047824ULL, 0x000fe400078e00ffULL,
0x00000051072a7223ULL, 0x080fe2000001002aULL, 0x000100004f067824ULL, 0x000fe400078e00ffULL,
0x0000005141287223ULL, 0x080fe20000010028ULL, 0x0000005144277223ULL, 0x080fe20000010027ULL,
0x0000005143267223ULL, 0x080fe20000010026ULL, 0x0000005108257223ULL, 0x080fe20000010025ULL,
0x0000005145247223ULL, 0x080fe20000010024ULL, 0x0000005148237223ULL, 0x080fe20000010023ULL,
0x000000510a217223ULL, 0x080fe20000010021ULL, 0x0000005109207223ULL, 0x080fe20000010020ULL,
0x000000514a1f7223ULL, 0x080fe2000001001fULL, 0x00000051471e7223ULL, 0x000fe2000001001eULL,
0x000000520c1d7223ULL, 0x090fe2000001001dULL, 0x000000520b1c7223ULL, 0x080fe2000001001cULL,
0x000000524c1b7223ULL, 0x080fe2000001001bULL, 0x00000052491a7223ULL, 0x080fe2000001001aULL,
0x000000520e197223ULL, 0x080fe20000010019ULL, 0x000000520d187223ULL, 0x080fe20000010018ULL,
0x000000524e177223ULL, 0x080fe20000010017ULL, 0x000000524b167223ULL, 0x080fe20000010016ULL,
0x000000524d347223ULL, 0x080fe20000010034ULL, 0x000000520f327223ULL, 0x080fe20000010032ULL,
0x0000005250317223ULL, 0x080fe20000010031ULL, 0x0000005205307223ULL, 0x080fe20000010030ULL,
0x00000052122f7223ULL, 0x080fe2000001002fULL, 0x0000005204337223ULL, 0x080fe20000010033ULL,
0x00000052132e7223ULL, 0x080fe2000001002eULL, 0x0000005206157223ULL, 0x000fe20000010015ULL,
0xfffffff4009c8947ULL, 0x000fec000383ffffULL, 0x0180000035007836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe80000010000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff547224ULL, 0x000fe200078e0035ULL, 0x00009b7000027802ULL, 0x000fce0000000f00ULL,
0x0000008400f07944ULL, 0x006fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0000ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000003500027308ULL, 0x000ee40000001000ULL,
0xbf80000002007423ULL, 0x008fc80000000035ULL, 0x800000ff00037221ULL, 0x000fc80000010100ULL,
0x0000000302027223ULL, 0x000fce0000000002ULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x00000002ff097819ULL, 0x10cfe40000011600ULL, 0x00000008000b7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff037819ULL, 0x000fe20000011600ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0902047589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff0f7812ULL, 0x000fc600078ee200ULL,
0x00001f0b020c7589ULL, 0x00072200000e0000ULL, 0x000000080f137810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000002d042d7220ULL, 0x044fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002b04057220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002904067220ULL, 0x040fe20000410000ULL,
0x0000002804077220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002504087220ULL, 0x040fe20000410000ULL,
0x0000002404097220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x00000021040a7220ULL, 0x040fe20000410000ULL,
0x00000020040b7220ULL, 0x048fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x000fe20000410000ULL, 0x0000000303047812ULL, 0x000fe200078ec0ffULL,
0x0000001d0c1d7220ULL, 0x050fe20000410000ULL, 0x0000001c0c1c7220ULL, 0x040fe20000410000ULL,
0x0000001b0c1b7220ULL, 0x000fe20000410000ULL, 0x00000004040e7812ULL, 0x000fe200078efcffULL,
0x0000001a0c1a7220ULL, 0x040fe20000410000ULL, 0x000000190c197220ULL, 0x040fe20000410000ULL,
0x000000180c187220ULL, 0x040fe20000410000ULL, 0x000000170c177220ULL, 0x040fe20000410000ULL,
0x000000160c167220ULL, 0x040fe20000410000ULL, 0x000000340c347220ULL, 0x040fe20000410000ULL,
0x000000320c0d7220ULL, 0x040fe20000410000ULL, 0x000000310c317220ULL, 0x040fe20000410000ULL,
0x000000300c307220ULL, 0x040fe20000410000ULL, 0x0000002f0c2f7220ULL, 0x040fe20000410000ULL,
0x000000330c027220ULL, 0x040fe20000410000ULL, 0x0000002e0c2e7220ULL, 0x040fe20000410000ULL,
0x000000150c157220ULL, 0x000fe20000410000ULL, 0x000000080f0c7824ULL, 0x000fe200078e00ffULL,
0x0000000704117812ULL, 0x000fc400078e780fULL, 0x0000000704217812ULL, 0x000fe200078e7813ULL,
0x0000000813047824ULL, 0x000fe200078e00ffULL, 0x000000070e0f7812ULL, 0x000fe400078e780fULL,
0x000000070e137812ULL, 0x000fe400078e7813ULL, 0x0000000c11117212ULL, 0x080fe400078efcffULL,
0x0000000c0f0f7212ULL, 0x000fe400078efcffULL, 0x0000000421217212ULL, 0x000fc400078efcffULL,
0x0000000413137212ULL, 0x000fe400078efcffULL, 0x000000060706723eULL, 0x000fe400000010ffULL,
0x0000002d2c04723eULL, 0x000fe400000010ffULL, 0x000000052a05723eULL, 0x000fe400000010ffULL,
0x000000272607723eULL, 0x000fe400000010ffULL, 0x000000080908723eULL, 0x000fc400000010ffULL,
0x0000000a0b0a723eULL, 0x000fe400000010ffULL, 0x0000001611117c11ULL, 0x000fe4000f8e20ffULL,
0x000000232209723eULL, 0x000fe400000010ffULL, 0x0000001f1e0b723eULL, 0x000fe200000010ffULL,
0x0000000411007844ULL, 0x0005e20000000200ULL, 0x0000001d1c1c723eULL, 0x000fe400000010ffULL,
0x000000160f0f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000001b1a1d723eULL, 0x000fe400000010ffULL,
0x00000019181e723eULL, 0x000fe200000010ffULL, 0x000000080f007844ULL, 0x0005e20000000200ULL,
0x00000017161f723eULL, 0x000fe400000010ffULL, 0x0000001621217c11ULL, 0x000fe4000f8e20ffULL,
0x000000340d34723eULL, 0x000fe400000010ffULL, 0x000000313035723eULL, 0x000fe200000010ffULL,
0x0000001c21007844ULL, 0x0005e20000000200ULL, 0x0000002f0236723eULL, 0x000fc400000010ffULL,
0x0000002e1537723eULL, 0x000fe400000010ffULL, 0x0000001613137c11ULL, 0x000fca000f8e20ffULL,
0x0000003413007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002000117836ULL, 0x004fe20000000000ULL, 0x0000000000057919ULL, 0x000ea20000002600ULL,
0x0000000703077812ULL, 0x000fe200078e4800ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000003ff027819ULL, 0x000fe20000011611ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0ffffff807077812ULL, 0x000fe200078ef800ULL,
0x00000014ff127e24ULL, 0x000fe2000f8e00ffULL, 0x0000000702047812ULL, 0x000fe400078e4811ULL,
0x0000000607087c11ULL, 0x000fc4000f8e20ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef811ULL,
0x0000000700077812ULL, 0x000fe400078ec0ffULL, 0x0000000604047c11ULL, 0x000fe2000f8e20ffULL,
0x0120000008087984ULL, 0x000f220000000c00ULL, 0x0000000711007812ULL, 0x000fe400078ec0ffULL,
0x1ffffff807077812ULL, 0x000fe200078ef812ULL, 0x01200000040c7984ULL, 0x000b220000000c00ULL,
0x1ffffff800117812ULL, 0x000fe200078ef812ULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000305067819ULL, 0x044fe200000006ffULL, 0x0000000805057824ULL, 0x000fc600078e00ffULL,
0xfffffff806037812ULL, 0x000fe400078ee203ULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402057c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe40000000a00ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fc4000f8048ffULL, 0x000000ffff067210ULL, 0x000fe40000ffe4ffULL,
0x0000000405047c11ULL, 0x020fe4000f8248ffULL, 0x0000000503037c11ULL, 0x000fe400080f4c10ULL,
0x0000000505057c11ULL, 0x000fe200088f4c06ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d0eULL,
0x0000000c04007986ULL, 0x002fe2000c101d0eULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00003c0001367983ULL, 0x000ea20000100800ULL, 0x0000000107057899ULL, 0x000fe2000800063fULL,
0x00000001ff027424ULL, 0x000fe200078e00ffULL, 0x00000006120d7899ULL, 0x000fe2000800063fULL,
0x0000000000377919ULL, 0x000e620000000000ULL, 0x00000009050572a4ULL, 0x000fc6000f8e0208ULL,
0x00008e0000097ab9ULL, 0x000fe20000000800ULL, 0x01c60002ff0279a7ULL, 0x000e620008500006ULL,
0x00000000360a72caULL, 0x044fe200000e0000ULL, 0x0000000136007836ULL, 0x000fca0000000000ULL,
0x0000000400007c0cULL, 0x000fce000bf06070ULL, 0x0000000d0a087291ULL, 0x000fc8000f8e403fULL,
0x00000009050972a4ULL, 0x000fe4000f8e0208ULL, 0x0000000800e88947ULL, 0x002ff40003800000ULL,
0x00000003ff067819ULL, 0x000fe20000011637ULL, 0x000000080c00728cULL, 0x000fc6000bf01070ULL,
0x00000018061d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000c060f7836ULL, 0x040fe20000000000ULL,
0x000000080c077287ULL, 0x000fe2000c000000ULL, 0x0000001006147836ULL, 0x000fe20000000000ULL,
0x00000024061b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f1f7824ULL, 0x040fe200078e00ffULL,
0x000000370f047212ULL, 0x080fe200078e3cffULL, 0x0000000814207824ULL, 0x040fe200078e00ffULL,
0x0000003714057212ULL, 0x080fe200078e3cffULL, 0x00000004060b7836ULL, 0x040fe20000000000ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL, 0x00000008060d7836ULL, 0x040fe20000000000ULL,
0xfffffff820207812ULL, 0x000fe200078ee205ULL, 0x0000001c06237836ULL, 0x040fe20000000000ULL,
0x00008a00ff047b82ULL, 0x000e620000000a00ULL, 0x000000370b007212ULL, 0x0c0fe200078e3cffULL,
0x0000001406157836ULL, 0x040fe20000000000ULL, 0x000000030b197819ULL, 0x000fe200000006ffULL,
0x0000000708077290ULL, 0x000fe2000fffe13fULL, 0x000000030d077819ULL, 0x000fe200000006ffULL,
0x0000000815217824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee200ULL,
0x000000081d227824ULL, 0x000fe200078e00ffULL, 0x000000370d007212ULL, 0x080fe200078e3cffULL,
0x0000002006187836ULL, 0x000fe20000000000ULL, 0x0000003723087212ULL, 0x0c0fe200078e3cffULL,
0x0000000612087291ULL, 0x000fe2000f8e703fULL, 0x0000000323097819ULL, 0x000fe200000006ffULL,
0x00000008181a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8071e7812ULL, 0x000fe200078ee200ULL,
0x0000200008087890ULL, 0x000fe2000fffe03fULL, 0xfffffff809247812ULL, 0x000fe200078ee208ULL,
0x0000000906097c36ULL, 0x000fe20008000000ULL, 0x0000003715007212ULL, 0x000fe200078e3cffULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0x000000070d007c0cULL, 0x000fc4000bf26070ULL,
0xfffffff821217812ULL, 0x000fe200078ee200ULL, 0x0000020009087825ULL, 0x102fe200078e0004ULL,
0x0000007017007812ULL, 0x000fe400078ec0ffULL, 0x000000090d0d7c10ULL, 0x000fe4000fffe0ffULL,
0x000000070b007c0cULL, 0x040fe2000bf46070ULL, 0x000000090b0b7c36ULL, 0x000fe20008000000ULL,
0x000000070f007c0cULL, 0x040fe2000bf06070ULL, 0x000000090f0f7c36ULL, 0x000fe20008000000ULL,
0x0000000800107210ULL, 0x000fe20007f7e0ffULL, 0x000002000d0c7825ULL, 0x000fe200078e0004ULL,
0x000000371d077212ULL, 0x000fc400078e3cffULL, 0x0000000819197c11ULL, 0x000fe2000f8e20ffULL,
0x000002000b0a7825ULL, 0x100fe200078e0004ULL, 0xfffffff822227812ULL, 0x000fe400078ee207ULL,
0x0000003718077212ULL, 0x000fe200078e3cffULL, 0x000002000f0e7825ULL, 0x000fe200078e0004ULL,
0x0000000c000c7210ULL, 0x000fe40007fbe0ffULL, 0x0000000a00127210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff117224ULL, 0x000fe200018e0609ULL, 0x0000000e000e7210ULL, 0x000fe20007fde0ffULL,
0x0000000914097c36ULL, 0x000fe20008000000ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000000706077812ULL, 0x000fe200078e4837ULL,
0x0000020009087825ULL, 0x000fe200078e0004ULL, 0x0000000706007c0cULL, 0x000fc4000bf66070ULL,
0x0000000bff137210ULL, 0x000fe200027fe4ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x0000000714007c0cULL, 0x000fe2000bfa6070ULL, 0x00000009150b7c36ULL, 0x040fe20008000000ULL,
0x0000000715007c0cULL, 0x000fe4000bf86070ULL, 0x0ffffff807077812ULL, 0x000fe200078ef837ULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x000000371b157212ULL, 0x000fe400078e3cffULL,
0x0000000800147210ULL, 0x000fc40007fde0ffULL, 0x0000000807077c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL, 0x000000ffff157224ULL, 0x000fe200030e0609ULL,
0x000000091d097c10ULL, 0x000fe2000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010077faeULL, 0x0003e2000d901c4eULL, 0x0000000a00167210ULL, 0x000fe40007fde0ffULL,
0x000000071d007c0cULL, 0x000fe2000bf66070ULL, 0x00000028061d7836ULL, 0x000fe20000000000ULL,
0x0000000012197faeULL, 0x0005e2000d101c4eULL, 0x0000020009087825ULL, 0x000fe200078e0004ULL,
0x0000000723007c0cULL, 0x000fc4000bf46070ULL, 0x000000031d267819ULL, 0x000fe200000006ffULL,
0x000000ffff177224ULL, 0x000fe400030e060bULL, 0x00000009230b7c36ULL, 0x000fe20008000000ULL,
0x000000371d117212ULL, 0x002fe400078e3cffULL, 0x0000000800107210ULL, 0x000fe20007fde0ffULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x000000081e077c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff8261e7812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200030e0609ULL,
0x0000000a00127210ULL, 0x004fe20007fde0ffULL, 0x0000000918097c36ULL, 0x040fe20008000000ULL,
0x000000000c077faeULL, 0x0003e2000c901c4eULL, 0x0000000718007c0cULL, 0x000fc4000bf26070ULL,
0x0000002c06187810ULL, 0x000fe20007ffe0ffULL, 0x0000020009087825ULL, 0x000fe200078e0004ULL,
0x000000081f197c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe400030e060bULL,
0x0000000818267824ULL, 0x040fe200078e00ffULL, 0x000000000e197faeULL, 0x0005e2000c101c4eULL,
0x000000091b0b7c36ULL, 0x000fe20008000000ULL, 0x00000037180d7212ULL, 0x002fe400078e3cffULL,
0x00000008000c7210ULL, 0x000fe20007fde0ffULL, 0x000002000b0a7825ULL, 0x000fe200078e0004ULL,
0x000000071b007c0cULL, 0x000fe4000bf06070ULL, 0x0000000820077c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff8261b7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0d7224ULL, 0x000fe200030e0609ULL,
0x000000091d097c10ULL, 0x000fe2000fffe0ffULL, 0x0000000014077faeULL, 0x0003e2000e901c4eULL,
0x0000000a000e7210ULL, 0x004fe40007fde0ffULL, 0x0000000821197c11ULL, 0x000fe2000f8e20ffULL,
0x0000020009087825ULL, 0x000fe200078e0004ULL, 0x000000071d007c0cULL, 0x000fe4000bfa6070ULL,
0x000000081b1b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000030061d7836ULL, 0x000fe20000000000ULL,
0x0000000016197faeULL, 0x0005e2000e101c4eULL, 0x000000ffff0f7224ULL, 0x000fe200030e060bULL,
0x0000000718007c0cULL, 0x040fe2000bf86070ULL, 0x00000009180b7c36ULL, 0x000fe20008000000ULL,
0x000000371d157212ULL, 0x002fc400078e3cffULL, 0x000000031d187819ULL, 0x000fe200000006ffULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000800147210ULL, 0x000fe40007fde0ffULL,
0xfffffff818187812ULL, 0x000fe400078ee215ULL, 0x0000000822077c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff157224ULL, 0x000fe200030e0609ULL, 0x0000000a000a7210ULL, 0x000fe20007fde0ffULL,
0x000000091d097c36ULL, 0x000fe20008000000ULL, 0x0000003406167810ULL, 0x004fe20007ffe0ffULL,
0x0000000010077faeULL, 0x0003e2000d901c4eULL, 0x0000000824177c11ULL, 0x000fe2000f8e20ffULL,
0x0000020009087825ULL, 0x000fe200078e0004ULL, 0x0000003716197212ULL, 0x000fc400078e3cffULL,
0x000000071d007c0cULL, 0x000fe2000bf66070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000000012177faeULL, 0x0005e2000d101c4eULL, 0x0000000816207824ULL, 0x040fe200078e00ffULL,
0x0000000716007c0cULL, 0x000fe2000bf46070ULL, 0x00000038061d7836ULL, 0x000fe20000000000ULL,
0x0000000800107210ULL, 0x002fe20007fde0ffULL, 0x0000000916077c36ULL, 0x000fe20008000000ULL,
0xfffffff820167812ULL, 0x000fe200078ee219ULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x00000009ff117210ULL, 0x000fe200037fe4ffULL, 0x0000020007087825ULL, 0x000fe200078e0004ULL,
0x000000081a197c11ULL, 0x000fc4000f8e20ffULL, 0x000000371d127212ULL, 0x044fe200078e3cffULL,
0x000000091d137c36ULL, 0x000fe20008000000ULL, 0x0000000800087210ULL, 0x000fe20007fde0ffULL,
0x0000003c06177836ULL, 0x000fe20000000000ULL, 0x000000000c197faeULL, 0x0003e2000c901c4eULL,
0x0000020013067825ULL, 0x000fe200078e0004ULL, 0x000000071d007c0cULL, 0x000fe4000bf26070ULL,
0x00000009171d7c10ULL, 0x000fe2000fffe0ffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x000000081c137c11ULL, 0x000fc4000f8e20ffULL, 0x0000000600067210ULL, 0x000fe20007fde0ffULL,
0x000002001d047825ULL, 0x000fe200078e0004ULL, 0xfffffff81f127812ULL, 0x000fe200078ee212ULL,
0x000000000e137faeULL, 0x0005e2000c101c4eULL, 0x00000037170c7212ULL, 0x042fe200078e3cffULL,
0x0000000817197824ULL, 0x040fe200078e00ffULL, 0x0000000717007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x000000081e0d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000400047210ULL, 0x000fc40007fde0ffULL, 0xfffffff8190c7812ULL, 0x000fe200078ee20cULL,
0x00000000140d7faeULL, 0x0003e2000e901c4eULL, 0x0000000818177c11ULL, 0x000fe4000f8e20ffULL,
0x00000008160f7c11ULL, 0x004fe2000f8e20ffULL, 0x000000000a1b7faeULL, 0x0003e2000e101c4eULL,
0x0000000812137c11ULL, 0x000fe4000f8e20ffULL, 0x00000005ff057210ULL, 0x000fe200037fe4ffULL,
0x0000000010177faeULL, 0x0003e2000d901c4eULL, 0x000000080c197c11ULL, 0x000fc6000f8e20ffULL,
0x00000000080f7faeULL, 0x0003e8000d101c4eULL, 0x0000000006137faeULL, 0x0003e8000c901c4eULL,
0x0000000004197faeULL, 0x0003e2000c101c4eULL, 0x0000000800987947ULL, 0x000fea0003800000ULL,
0x00000003ff167819ULL, 0x000fe20000011637ULL, 0x0000000612077291ULL, 0x000fe2000f8e703fULL,
0x0000007017177812ULL, 0x000fe400078ec0ffULL, 0x00000014161e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000c161a7836ULL, 0x040fe20000000000ULL, 0x0000002416267810ULL, 0x000fe20007ffe0ffULL,
0x0000001816207836ULL, 0x000fe20000000000ULL, 0x000000371e117212ULL, 0x080fe200078e3cffULL,
0x000000081a067824ULL, 0x040fe200078e00ffULL, 0x000000371a137212ULL, 0x080fe200078e3cffULL,
0x0000001c16227836ULL, 0x000fe20000000000ULL, 0x0000003720107212ULL, 0x0c0fe200078e3cffULL,
0x0000000820077824ULL, 0x000fe200078e00ffULL, 0xfffffff806137812ULL, 0x000fe200078ee213ULL,
0x0000000822067824ULL, 0x040fe200078e00ffULL, 0x00000037220f7212ULL, 0x080fe200078e3cffULL,
0x0000002816287836ULL, 0x040fe20000000000ULL, 0xfffffff807107812ULL, 0x000fe200078ee210ULL,
0x0000002c162a7836ULL, 0x040fe20000000000ULL, 0xfffffff8060f7812ULL, 0x000fe200078ee20fULL,
0x0000000816187836ULL, 0x000fe20000000000ULL, 0x00000037280c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000828077824ULL, 0x000fe200078e00ffULL, 0x000000372a0b7212ULL, 0x0c0fe200078e3cffULL,
0x000000082a067824ULL, 0x000fe200078e00ffULL, 0x0000003718147212ULL, 0x080fe200078e3cffULL,
0x0000000416047836ULL, 0x000fe20000000000ULL, 0xfffffff8070c7812ULL, 0x000fe200078ee20cULL,
0x0000000818057824ULL, 0x000fe200078e00ffULL, 0xfffffff8060b7812ULL, 0x000fe200078ee20bULL,
0x00000010161c7836ULL, 0x000fe20000000000ULL, 0x0000003704157212ULL, 0x0c0fe200078e3cffULL,
0x00008a00ff067b82ULL, 0x000e620000000a00ULL, 0x0000000304007819ULL, 0x000fe200000006ffULL,
0x0000002016247836ULL, 0x000fe20000000000ULL, 0xfffffff805147812ULL, 0x000fe200078ee214ULL,
0x000000081c057824ULL, 0x040fe200078e00ffULL, 0x000000371c127212ULL, 0x080fe200078e3cffULL,
0x00000030162c7836ULL, 0x040fe20000000000ULL, 0xfffffff800157812ULL, 0x000fe200078ee215ULL,
0x0000003c16327836ULL, 0x000fe20000000000ULL, 0x000000031e007819ULL, 0x000fe200000006ffULL,
0x0000003816307836ULL, 0x000fe20000000000ULL, 0xfffffff805127812ULL, 0x000fe200078ee212ULL,
0x0000000824057824ULL, 0x000fe200078e00ffULL, 0xfffffff800117812ULL, 0x000fe200078ee211ULL,
0x00000008321b7824ULL, 0x000fe200078e00ffULL, 0x00000037240e7212ULL, 0x080fe200078e3cffULL,
0x000000091a1d7c36ULL, 0x000fe20008000000ULL, 0x00000037260d7212ULL, 0x080fe200078e3cffULL,
0x0000000830347824ULL, 0x000fe200078e00ffULL, 0x0000000326007819ULL, 0x000fe200000006ffULL,
0x000000091c1f7c36ULL, 0x000fe20008000000ULL, 0xfffffff8050e7812ULL, 0x000fe200078ee20eULL,
0x000000082c057824ULL, 0x000fe200078e00ffULL, 0x00000034162e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000920237c36ULL, 0x000fe20008000000ULL, 0xfffffff8000d7812ULL, 0x000fe200078ee20dULL,
0x0000000922257c36ULL, 0x000fe20008000000ULL, 0x000000372c007212ULL, 0x080fe200078e3cffULL,
0x0000000924277c36ULL, 0x000fe20008000000ULL, 0x000000372e087212ULL, 0x080fe200078e3cffULL,
0x00000009282b7c36ULL, 0x000fe20008000000ULL, 0x000000032e197819ULL, 0x000fe200000006ffULL,
0x000000092a2d7c36ULL, 0x000fe20008000000ULL, 0xfffffff805007812ULL, 0x000fe200078ee200ULL,
0x0000000916057c36ULL, 0x000fe20008000000ULL, 0x00000037320a7212ULL, 0x080fe200078e3cffULL,
0x000000092c2f7c36ULL, 0x000fe20008000000ULL, 0xfffffff819087812ULL, 0x000fe200078ee208ULL,
0x0000000930337c36ULL, 0x040fe20008000000ULL, 0x0000000904197c10ULL, 0x000fe2000fffe0ffULL,
0x0000020005047825ULL, 0x102fe200078e0006ULL, 0xfffffff81b0a7812ULL, 0x000fe200078ee20aULL,
0x0000200007077890ULL, 0x000fe2000fffe03fULL, 0x0000003730097212ULL, 0x000fe200078e3cffULL,
0x00000009181b7c36ULL, 0x000fe20008000000ULL, 0x000000091e217c10ULL, 0x000fe2000fffe0ffULL,
0x0000020019187825ULL, 0x000fe200078e0006ULL, 0x0000000926297c10ULL, 0x000fc4000fffe0ffULL,
0x000000092e317c10ULL, 0x000fe2000fffe0ffULL, 0x0000000932357c36ULL, 0x000fe20008000000ULL,
0x0000000417047210ULL, 0x000fe20007f1e0ffULL, 0x000002001b1a7825ULL, 0x100fe200078e0006ULL,
0xfffffff834097812ULL, 0x000fe400078ee209ULL, 0x0000001817187210ULL, 0x000fe20007f3e0ffULL,
0x000002001d1c7825ULL, 0x100fe200078e0006ULL, 0x0000000715157c11ULL, 0x000fe4000f8e20ffULL,
0x00000019ff197210ULL, 0x000fe20000ffe4ffULL, 0x000002001f1e7825ULL, 0x000fe200078e0006ULL,
0x0000000713137c11ULL, 0x000fc4000f8e20ffULL, 0x0000000711117c11ULL, 0x000fe2000f8e20ffULL,
0x0000020021207825ULL, 0x100fe200078e0006ULL, 0x0000000710397c11ULL, 0x000fe4000f8e20ffULL,
0x000000070f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020023227825ULL, 0x100fe200078e0006ULL,
0x000000070d0d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000070b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020025247825ULL, 0x000fe200078e0006ULL, 0x0000000709097c11ULL, 0x000fc6000f8e20ffULL,
0x0000020027267825ULL, 0x000fc800078e0006ULL, 0x0000020029287825ULL, 0x000fc800078e0006ULL,
0x000002002b2a7825ULL, 0x000fc800078e0006ULL, 0x000002002d2c7825ULL, 0x000fc800078e0006ULL,
0x000002002f2e7825ULL, 0x000fc800078e0006ULL, 0x0000020031307825ULL, 0x000fc800078e0006ULL,
0x0000020033327825ULL, 0x000fc800078e0006ULL, 0x0000020035347825ULL, 0x000fe200078e0006ULL,
0x0000001a17067210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000001c171a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200010e061bULL,
0x0000001e171c7210ULL, 0x000fe40007f3e0ffULL, 0x00000020171e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e061dULL, 0x0000002217207210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e061fULL, 0x0000002417227210ULL, 0x000fe40007f3e0ffULL,
0x00000021ff1f7210ULL, 0x000fe200017fe4ffULL, 0x000000ffff217224ULL, 0x000fe200000e0623ULL,
0x0000002617247210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff237224ULL, 0x000fe200008e0625ULL,
0x0000002817267210ULL, 0x000fc40007f5e0ffULL, 0x0000002a17287210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0627ULL, 0x00000029ff277210ULL, 0x000fe400017fe4ffULL,
0x0000002c172a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff297224ULL, 0x000fe200008e062bULL,
0x0000002e172c7210ULL, 0x000fe40007f3e0ffULL, 0x00000007162e7812ULL, 0x000fe200078e4837ULL,
0x000000ffff2b7224ULL, 0x000fe200000e062dULL, 0x0000003017167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062fULL, 0x0ffffff82e2f7812ULL, 0x000fc400078ef837ULL,
0x00000032172e7210ULL, 0x000fe40007f3e0ffULL, 0x0000003417307210ULL, 0x000fe40007f5e0ffULL,
0x000000072f377c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e0633ULL,
0x00000031ff177210ULL, 0x000fe200007fe4ffULL, 0x000000ffff317224ULL, 0x000fe200010e0635ULL,
0x0000000714337c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004377faeULL, 0x0003e2000b901c4eULL, 0x0000000712357c11ULL, 0x000fc6000f8e20ffULL,
0x0000000018157faeULL, 0x000fe8000b901c4eULL, 0x0000000006337faeULL, 0x0007e8000b901c4eULL,
0x000000001a137faeULL, 0x0009e2000b901c4eULL, 0x000000070e057c11ULL, 0x002fc6000f8e20ffULL,
0x000000001c357faeULL, 0x000fe8000b901c4eULL, 0x000000001e117faeULL, 0x0003e2000b901c4eULL,
0x000000070c077c11ULL, 0x008fc6000f8e20ffULL, 0x0000000020397faeULL, 0x000fe2000b901c4eULL,
0x0000000708137c11ULL, 0x010fc6000f8e20ffULL, 0x00000000220f7faeULL, 0x0007e2000b901c4eULL,
0x0000000700117c11ULL, 0x002fc6000f8e20ffULL, 0x0000000024057faeULL, 0x0005e8000b901c4eULL,
0x00000000260d7faeULL, 0x0005e2000b901c4eULL, 0x000000070a0f7c11ULL, 0x008fc6000f8e20ffULL,
0x0000000028077faeULL, 0x0005e8000b901c4eULL, 0x000000002a0b7faeULL, 0x0005e8000b901c4eULL,
0x000000002c117faeULL, 0x0005e8000b901c4eULL, 0x0000000016137faeULL, 0x0005e8000b901c4eULL,
0x000000002e097faeULL, 0x0005e8000b901c4eULL, 0x00000000300f7faeULL, 0x0005e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c60003ff0075a7ULL, 0x000ee20008000146ULL,
0x0000000436007c0cULL, 0x000fe2000bf26070ULL, 0x0000006000b08947ULL, 0x008fd80003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x00003c0001007983ULL, 0x000ee40000100800ULL,
0x00000000000872caULL, 0x008fda00000e0000ULL, 0x0000000d08087291ULL, 0x000fc8000f8e403fULL,
0x000000080c00728cULL, 0x000fcc000bf04070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000100007836ULL, 0x000fe20000000000ULL,
0x00000000002e7919ULL, 0x004ea20000000000ULL, 0x00008e00000b7ab9ULL, 0x000fe40000000800ULL,
0x0000000b051072a4ULL, 0x000fe2000f8e0208ULL, 0x0000000400007c0cULL, 0x000fda000bf06070ULL,
0x0000000800e08947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x004fe2000001162eULL,
0x800000080c097290ULL, 0x000fe2000fffe03fULL, 0x000000072e5b7812ULL, 0x000fe200078ec0ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000000400547810ULL, 0x000fe20007ffe0ffULL,
0x0000001400587836ULL, 0x040fe20000000000ULL, 0x0000000612077291ULL, 0x000fe2000f8e703fULL,
0x0000000800537836ULL, 0x000fe20000000000ULL, 0x0000002e54687212ULL, 0x0c0fe200078e3cffULL,
0x0000000854037824ULL, 0x000fe200078e00ffULL, 0x0000002e58707212ULL, 0x080fe200078e3cffULL,
0x0000001800577836ULL, 0x040fe20000000000ULL, 0x0000002e536d7212ULL, 0x0c0fe200078e3cffULL,
0x0000001000027836ULL, 0x000fe20000000000ULL, 0xfffffff803687812ULL, 0x000fe200078ee268ULL,
0x0000000858037824ULL, 0x000fe200078e00ffULL, 0x0000000353047819ULL, 0x002fe200000006ffULL,
0x00000024005a7836ULL, 0x040fe20000000000ULL, 0x0000002e57667212ULL, 0x0c0fe200078e3cffULL,
0x0000002000557836ULL, 0x040fe20000000000ULL, 0xfffffff803707812ULL, 0x000fe200078ee270ULL,
0x0000002c006c7836ULL, 0x040fe20000000000ULL, 0x0000000357037819ULL, 0x000fe200000006ffULL,
0x0000002800597836ULL, 0x040fe20000000000ULL, 0xfffffff8046d7812ULL, 0x000fe200078ee26dULL,
0x0000001c00567836ULL, 0x000fe20000000000ULL, 0x0000002e026f7212ULL, 0x080fe200078e3cffULL,
0x0000000c00527836ULL, 0x000fe20000000000ULL, 0x0000000302047819ULL, 0x000fe200000006ffULL,
0x0000000856057824ULL, 0x000fe200078e00ffULL, 0xfffffff803667812ULL, 0x000fe200078ee266ULL,
0x000000085a037824ULL, 0x040fe200078e00ffULL, 0x0000002e5a627212ULL, 0x080fe200078e3cffULL,
0x0000000852067824ULL, 0x000fe200078e00ffULL, 0xfffffff8046f7812ULL, 0x000fe200078ee26fULL,
0x0000001000077c36ULL, 0x040fe20008000000ULL, 0x0000002e55637212ULL, 0x0c0fe200078e3cffULL,
0x00004000070a7890ULL, 0x000fe2000fffe03fULL, 0x0000000355047819ULL, 0x000fe200000006ffULL,
0x00000034006a7836ULL, 0x000fe20000000000ULL, 0xfffffff803627812ULL, 0x000fe200078ee262ULL,
0x000000086c037824ULL, 0x000fe200078e00ffULL, 0xfffffff804637812ULL, 0x000fe200078ee263ULL,
0x00000030006b7836ULL, 0x000fe20000000000ULL, 0x0000002e6c607212ULL, 0x080fe200078e3cffULL,
0x000000086a0b7824ULL, 0x000fe200078e00ffULL, 0x0000002e59617212ULL, 0x0c0fe200078e3cffULL,
0x0000003800657836ULL, 0x000fe20000000000ULL, 0x0000000359047819ULL, 0x000fe200000006ffULL,
0x000000086b0a7824ULL, 0x000fe200078e00ffULL, 0x0000002e56647212ULL, 0x080fe200078e3cffULL,
0x00000008650c7824ULL, 0x000fe200078e00ffULL, 0xfffffff803607812ULL, 0x000fe200078ee260ULL,
0x00000010520d7c36ULL, 0x000fe20008000000ULL, 0xfffffff804617812ULL, 0x000fe200078ee261ULL,
0x0000001058117c36ULL, 0x000fe20008000000ULL, 0x0000002e00037212ULL, 0x080fe200078e3cffULL,
0x000000105a217c36ULL, 0x000fe20008000000ULL, 0x0000002e52677212ULL, 0x000fe200078e3cffULL,
0x0000001059237c36ULL, 0x000fe20008000000ULL, 0xfffffff805647812ULL, 0x000fe200078ee264ULL,
0x00000017ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000001600047c02ULL, 0x000fe20008000f00ULL,
0x00000010652b7c36ULL, 0x000fe20008000000ULL, 0x0000000900007c0cULL, 0x000fc4000bf26070ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x0000020011107825ULL, 0x100fe200078e0004ULL,
0xfffffff806677812ULL, 0x000fe400078ee267ULL, 0x000000085b2d7812ULL, 0x000fe200078efcffULL,
0x0000020007067825ULL, 0x000fe200078e0004ULL, 0x0000003c006e7810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff803697812ULL, 0x000fe200078ef82eULL, 0x000000102d1a7825ULL, 0x000fe200078e0010ULL,
0x0000002e6e5c7212ULL, 0x000fc400078e3cffULL, 0x000000036e037819ULL, 0x000fe200000006ffULL,
0x000000102d087825ULL, 0x000fe200078e0006ULL, 0x0000002e6a5e7212ULL, 0x080fe400078e3cffULL,
0x0000000a697a7c11ULL, 0x000fe2000f8e20ffULL, 0x000000106e517c36ULL, 0x000fe20008000000ULL,
0xfffffff8035c7812ULL, 0x000fe200078ee25cULL, 0x0000001054037c36ULL, 0x040fe20008000000ULL,
0x0000002e6b5f7212ULL, 0x080fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000087a7faeULL, 0x0003e2000c901c4eULL, 0xfffffff80b5e7812ULL, 0x000fe200078ee25eULL,
0x00000010530b7c36ULL, 0x000fe20008000000ULL, 0x0000002e655d7212ULL, 0x000fe200078e3cffULL,
0x0000020051507825ULL, 0x000fe200078e0004ULL, 0x0000000954007c0cULL, 0x000fc4000bf26070ULL,
0x0000000953007c0cULL, 0x000fe4000bf46070ULL, 0xfffffff80a5f7812ULL, 0x000fe200078ee25fULL,
0x000002000b0a7825ULL, 0x100fe200078e0004ULL, 0x0000000952007c0cULL, 0x000fe4000bf66070ULL,
0xfffffff80c5d7812ULL, 0x000fe200078ee25dULL, 0x0000020003087825ULL, 0x102fe200078e0004ULL,
0x00000010020f7c10ULL, 0x000fe4000fffe0ffULL, 0x0000000902007c0cULL, 0x000fe2000bf86070ULL,
0x000002000d0c7825ULL, 0x000fe200078e0004ULL, 0x0000000a687c7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000a6d1e7c11ULL, 0x000fe2000f8e20ffULL, 0x000002000f0e7825ULL, 0x000fe200078e0004ULL,
0x0000000a671d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000958007c0cULL, 0x000fe2000bfa6070ULL,
0x000000102d127825ULL, 0x000fe200078e0008ULL, 0x0000000a6f1c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001e01007387ULL, 0x000fe20000100800ULL, 0x00000010551f7c10ULL, 0x000fe2000fffe0ffULL,
0x000000102d147825ULL, 0x000fe200078e000aULL, 0x0000000a707d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000127c7faeULL, 0x0003e2000c901c4eULL, 0x0000000957007c0cULL, 0x000fe2000bf26070ULL,
0x000000102d167825ULL, 0x040fe200078e000cULL, 0x0000000a662a7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000141e7faeULL, 0x000fe2000d101c4eULL, 0x0000000956007c0cULL, 0x000fe2000bf46070ULL,
0x000000102d187825ULL, 0x000fe200078e000eULL, 0x0000000a64297c11ULL, 0x000fe2000f8e20ffULL,
0x0000041d01007387ULL, 0x0005e20000100800ULL, 0x0000000a63287c11ULL, 0x000fe2000f8e20ffULL,
0x0000001057037c36ULL, 0x000fe20008000000ULL, 0x0000000a62277c11ULL, 0x000fe2000f8e20ffULL,
0x00000000161d7faeULL, 0x0005e2000d901c4eULL, 0x0000000955007c0cULL, 0x000fe2000bf66070ULL,
0x0000020003127825ULL, 0x002fe200078e0004ULL, 0x0000000a61267c11ULL, 0x000fe2000f8e20ffULL,
0x00000000181c7faeULL, 0x0003e2000e101c4eULL, 0x000000095a007c0cULL, 0x000fe2000bf86070ULL,
0x000000106c037c36ULL, 0x000fe20008000000ULL, 0x0000000a60327c11ULL, 0x000fe2000f8e20ffULL,
0x0000081c01007387ULL, 0x0007e20000100800ULL, 0x0000000a5f317c11ULL, 0x000fc4000f8e20ffULL,
0x0000000a5e307c11ULL, 0x000fe2000f8e20ffULL, 0x00000010561d7c36ULL, 0x004fe20008000000ULL,
0x000000001a7d7faeULL, 0x0005e2000e901c4eULL, 0x000002001f167825ULL, 0x100fe200078e0004ULL,
0x0000000959007c0cULL, 0x000fe4000bfa6070ULL, 0x0000142a01007387ULL, 0x000fe20000100800ULL,
0x000002001d147825ULL, 0x100fe200078e0004ULL, 0x0000000a5d2f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000102901007387ULL, 0x0009e20000100800ULL, 0x0000020021187825ULL, 0x002fe200078e0004ULL,
0x0000000a5c7b7c11ULL, 0x000fc4000f8e20ffULL, 0x00001c2801007387ULL, 0x000fe20000100800ULL,
0x000000102d1c7825ULL, 0x008fc600078e0012ULL, 0x00002c2701007387ULL, 0x0003e20000100800ULL,
0x000000102d1e7825ULL, 0x000fc600078e0014ULL, 0x000000001c2a7faeULL, 0x000fe2000c901c4eULL,
0x00000200231a7825ULL, 0x004fe200078e0004ULL, 0x000000096c007c0cULL, 0x000fe4000bf26070ULL,
0x000000001e297faeULL, 0x0009e2000d101c4eULL, 0x000000102d207825ULL, 0x000fe200078e0016ULL,
0x000000096b007c0cULL, 0x000fe4000bf46070ULL, 0x0000282601007387ULL, 0x0005e20000100800ULL,
0x000000102d227825ULL, 0x000fc600078e0018ULL, 0x0000000020287faeULL, 0x0007e2000d901c4eULL,
0x000000102d247825ULL, 0x000fe200078e001aULL, 0x000000096a007c0cULL, 0x040fe4000bf66070ULL,
0x0000000022277faeULL, 0x0003e2000e101c4eULL, 0x000000106a297c36ULL, 0x010fe20008000000ULL,
0x0000000965007c0cULL, 0x000fe2000bf86070ULL, 0x00000200031c7825ULL, 0x100fe200078e0004ULL,
0x0000000024267faeULL, 0x000be2000e901c4eULL, 0x000000096e007c0cULL, 0x000fe4000bfa6070ULL,
0x0000020029207825ULL, 0x008fe200078e0004ULL, 0x0000243201007387ULL, 0x0009e20000100800ULL,
0x000000106b277c10ULL, 0x002fc4000fffe0ffULL, 0x000002002b227825ULL, 0x100fe200078e0004ULL,
0x0000203101007387ULL, 0x0009e60000100800ULL, 0x00000200271e7825ULL, 0x000fe200078e0004ULL,
0x0000183001007387ULL, 0x0009e60000100800ULL, 0x000000102d247825ULL, 0x060fe200078e001cULL,
0x00000c2f01007387ULL, 0x0009e60000100800ULL, 0x000000102d267825ULL, 0x044fe200078e001eULL,
0x0000000024327faeULL, 0x0009e6000c901c4eULL, 0x000000102d287825ULL, 0x040fe200078e0020ULL,
0x0000000026317faeULL, 0x0009e6000d101c4eULL, 0x000000102d2a7825ULL, 0x040fe200078e0022ULL,
0x0000000028307faeULL, 0x0009e6000d901c4eULL, 0x000000102d2c7825ULL, 0x000fe200078e0050ULL,
0x000000002a2f7faeULL, 0x0009e8000e101c4eULL, 0x000000002c7b7faeULL, 0x0009e2000e901c4eULL,
0x0000000800907947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x004fe2000001162eULL,
0x0000000612077291ULL, 0x000fe2000f8e703fULL, 0x000000072e5b7812ULL, 0x000fe400078ec0ffULL,
0x0000000400547810ULL, 0x000fe20007ffe0ffULL, 0x0000001400587836ULL, 0x040fe20000000000ULL,
0x0000000c00527810ULL, 0x000fe20007ffe0ffULL, 0x0000001c00567836ULL, 0x000fe20000000000ULL,
0x0000002e54687212ULL, 0x0c0fe200078e3cffULL, 0x0000000854037824ULL, 0x000fe200078e00ffULL,
0x0000002e52677212ULL, 0x0c0fe200078e3cffULL, 0x0000000852047824ULL, 0x002fe200078e00ffULL,
0x0000002000557810ULL, 0x000fe20007ffe0ffULL, 0x0000000856057824ULL, 0x000fe200078e00ffULL,
0xfffffff803687812ULL, 0x000fe200078ee268ULL, 0x0000000858037824ULL, 0x040fe200078e00ffULL,
0xfffffff804677812ULL, 0x000fe200078ee267ULL, 0x0000000855047824ULL, 0x040fe200078e00ffULL,
0x0000002e58707212ULL, 0x080fe200078e3cffULL, 0x0000001800577836ULL, 0x000fe20000000000ULL,
0x0000002e56647212ULL, 0x080fe200078e3cffULL, 0x0000000800537836ULL, 0x040fe20000000000ULL,
0x0000002e55637212ULL, 0x080fe200078e3cffULL, 0x0000002c006c7836ULL, 0x040fe20000000000ULL,
0xfffffff803707812ULL, 0x000fe200078ee270ULL, 0x0000000857037824ULL, 0x000fe200078e00ffULL,
0xfffffff805647812ULL, 0x000fe200078ee264ULL, 0x0000000853027824ULL, 0x000fe200078e00ffULL,
0xfffffff804637812ULL, 0x000fe200078ee263ULL, 0x0000002800597836ULL, 0x040fe20000000000ULL,
0x00008a00ff047b82ULL, 0x000e620000000a00ULL, 0x0000002e57667212ULL, 0x080fe200078e3cffULL,
0x00000030006b7836ULL, 0x040fe20000000000ULL, 0x00000024005a7810ULL, 0x000fe20007ffe0ffULL,
0x0000003800657836ULL, 0x000fe20000000000ULL, 0x0000002e536d7212ULL, 0x080fe200078e3cffULL,
0x000000086b087824ULL, 0x000fe200078e00ffULL, 0xfffffff803667812ULL, 0x000fe200078ee266ULL,
0x000000085a037824ULL, 0x040fe200078e00ffULL, 0x0000002e5a627212ULL, 0x080fe200078e3cffULL,
0x0000001000077c36ULL, 0x040fe20008000000ULL, 0xfffffff8026d7812ULL, 0x000fe200078ee26dULL,
0x0000001000027836ULL, 0x000fe20000000000ULL, 0xfffffff803627812ULL, 0x000fe200078ee262ULL,
0x000000086c037824ULL, 0x040fe200078e00ffULL, 0x00000034006a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008650a7824ULL, 0x000fe200078e00ffULL, 0x0000002e6c607212ULL, 0x080fe200078e3cffULL,
0x00000010520d7c36ULL, 0x000fe20008000000ULL, 0x0000002e026f7212ULL, 0x0c0fe200078e3cffULL,
0x00004000070a7890ULL, 0x000fe2000fffe03fULL, 0x0000000302067819ULL, 0x000fe200000006ffULL,
0x0000003c006e7836ULL, 0x000fe20000000000ULL, 0x0000002e6a5e7212ULL, 0x040fe200078e3cffULL,
0x000002000d0c7825ULL, 0x002fe200078e0004ULL, 0x000000036a097819ULL, 0x000fc400000006ffULL,
0xfffffff803607812ULL, 0x000fe200078ee260ULL, 0x00000010020f7c36ULL, 0x000fe20008000000ULL,
0xfffffff8066f7812ULL, 0x000fe200078ee26fULL, 0x0000001058117c36ULL, 0x000fe20008000000ULL,
0x0000002e00037212ULL, 0x080fe200078e3cffULL, 0x000002000f0e7825ULL, 0x100fe200078e0004ULL,
0x0000002e59617212ULL, 0x0c0fe400078e3cffULL, 0x0000000359067819ULL, 0x000fe200000006ffULL,
0x0000020011107825ULL, 0x000fe200078e0004ULL, 0x0000002e6b5f7212ULL, 0x000fc400078e3cffULL,
0xfffffff8095e7812ULL, 0x000fe200078ee25eULL, 0x0000001054097c36ULL, 0x000fe20008000000ULL,
0x0000002e655d7212ULL, 0x000fe200078e3cffULL, 0x000000105a217c36ULL, 0x000fe20008000000ULL,
0x00000010530b7c10ULL, 0x000fe2000fffe0ffULL, 0x000000106e517c36ULL, 0x000fe20008000000ULL,
0x0000000703037812ULL, 0x000fe400078ec0ffULL, 0xfffffff806617812ULL, 0x000fe200078ee261ULL,
0x0000020007067825ULL, 0x000fe200078e0004ULL, 0xfffffff8085f7812ULL, 0x000fc400078ee25fULL,
0x000000085b2d7812ULL, 0x000fe200078efcffULL, 0x0000020009087825ULL, 0x100fe200078e0004ULL,
0xfffffff80a5d7812ULL, 0x000fe400078ee25dULL, 0x0ffffff803697812ULL, 0x000fe200078ef82eULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000a687c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a697a7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d127825ULL, 0x000fe200078e0006ULL,
0x0000000a6d207c11ULL, 0x000fc4000f8e20ffULL, 0x0000002e6e5c7212ULL, 0x040fe200078e3cffULL,
0x000000102d147825ULL, 0x000fe200078e0008ULL, 0x0000000a671f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000127a7faeULL, 0x0003e2000b901c4eULL,
0x0000000a6f1e7c11ULL, 0x000fe2000f8e20ffULL, 0x000000086e037824ULL, 0x000fe200078e00ffULL,
0x0000000a707d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d167825ULL, 0x040fe200078e000aULL,
0x00000000147c7faeULL, 0x0005e2000b901c4eULL, 0x0000001059237c10ULL, 0x000fe4000fffe0ffULL,
0x000000102d187825ULL, 0x040fe200078e000cULL, 0xfffffff8035c7812ULL, 0x000fe200078ee25cULL,
0x0000002001007387ULL, 0x000fe20000100800ULL, 0x0000000a662a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001056037c36ULL, 0x000fe20008000000ULL, 0x0000001057137c10ULL, 0x002fe2000fffe0ffULL,
0x0000000016207faeULL, 0x000fe2000b901c4eULL, 0x000000102d1a7825ULL, 0x000fe200078e000eULL,
0x0000000a64297c11ULL, 0x000fc4000f8e20ffULL, 0x0000041f01007387ULL, 0x0003e20000100800ULL,
0x000000102d1c7825ULL, 0x000fe200078e0010ULL, 0x0000000a63287c11ULL, 0x000fe4000f8e20ffULL,
0x00000000181f7faeULL, 0x0003e2000b901c4eULL, 0x0000020013127825ULL, 0x100fe200078e0004ULL,
0x0000000a62277c11ULL, 0x000fe4000f8e20ffULL, 0x000000001a1e7faeULL, 0x000fe2000b901c4eULL,
0x0000020003147825ULL, 0x004fe200078e0004ULL, 0x00000010652b7c10ULL, 0x000fc4000fffe0ffULL,
0x000000001c7d7faeULL, 0x0005e2000b901c4eULL, 0x000000106c037c36ULL, 0x000fe20008000000ULL,
0x0000000a61267c11ULL, 0x000fe2000f8e20ffULL, 0x0000020051507825ULL, 0x100fe200078e0004ULL,
0x0000081e01007387ULL, 0x0007e20000100800ULL, 0x0000000a60327c11ULL, 0x000fe4000f8e20ffULL,
0x00000010551f7c36ULL, 0x002fe20008000000ULL, 0x0000142a01007387ULL, 0x000fe20000100800ULL,
0x0000020021187825ULL, 0x000fe200078e0004ULL, 0x0000000a5f317c11ULL, 0x000fc4000f8e20ffULL,
0x0000102901007387ULL, 0x0003e20000100800ULL, 0x000002001f167825ULL, 0x000fe200078e0004ULL,
0x0000000a5e307c11ULL, 0x000fe4000f8e20ffULL, 0x00001c2801007387ULL, 0x000fe20000100800ULL,
0x000000102d1c7825ULL, 0x004fe200078e0012ULL, 0x0000000a5d2f7c11ULL, 0x000fe4000f8e20ffULL,
0x00002c2701007387ULL, 0x0005e20000100800ULL, 0x000000102d1e7825ULL, 0x008fe200078e0014ULL,
0x0000000a5c7b7c11ULL, 0x000fc4000f8e20ffULL, 0x000000001c2a7faeULL, 0x000fe2000b901c4eULL,
0x00000200231a7825ULL, 0x000fc600078e0004ULL, 0x000000001e297faeULL, 0x0003e2000b901c4eULL,
0x000000102d207825ULL, 0x000fc600078e0016ULL, 0x0000282601007387ULL, 0x0009e20000100800ULL,
0x000000102d227825ULL, 0x000fc600078e0018ULL, 0x0000000020287faeULL, 0x0007e2000b901c4eULL,
0x000000102d247825ULL, 0x000fc600078e001aULL, 0x0000000022277faeULL, 0x0005e2000b901c4eULL,
0x000000106a297c36ULL, 0x002fe40008000000ULL, 0x00000200031c7825ULL, 0x100fe200078e0004ULL,
0x0000000024267faeULL, 0x0003e6000b901c4eULL, 0x0000020029207825ULL, 0x108fe200078e0004ULL,
0x0000243201007387ULL, 0x0007e60000100800ULL, 0x000000106b277c36ULL, 0x004fe20008000000ULL,
0x0000203101007387ULL, 0x0007e20000100800ULL, 0x000002002b227825ULL, 0x000fc600078e0004ULL,
0x0000183001007387ULL, 0x0007e20000100800ULL, 0x00000200271e7825ULL, 0x000fc600078e0004ULL,
0x00000c2f01007387ULL, 0x0007e20000100800ULL, 0x000000102d247825ULL, 0x002fc800078e001cULL,
0x000000102d267825ULL, 0x050fe200078e001eULL, 0x0000000024327faeULL, 0x0007e6000b901c4eULL,
0x000000102d287825ULL, 0x040fe200078e0020ULL, 0x0000000026317faeULL, 0x0007e6000b901c4eULL,
0x000000102d2a7825ULL, 0x040fe200078e0022ULL, 0x0000000028307faeULL, 0x0007e6000b901c4eULL,
0x000000102d2c7825ULL, 0x000fe200078e0050ULL, 0x000000002a2f7faeULL, 0x0007e8000b901c4eULL,
0x000000002c7b7faeULL, 0x0007e4000b901c4eULL, 0x00000004ff277819ULL, 0x018fe2000001162eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000085b037812ULL, 0x000fe200078ef82eULL,
0x0000200007077890ULL, 0x000fe2000fffe03fULL, 0x0000000100797812ULL, 0x000fe200078ec0ffULL,
0x0000000827247824ULL, 0x040fe400078e00ffULL, 0x0000000227287836ULL, 0x000fc60000000000ULL,
0xfffffff824257812ULL, 0x000fe400078ee25bULL, 0x0000000727247812ULL, 0x000fe400078e7803ULL,
0x0000001025747810ULL, 0x000fe20007ffe0ffULL, 0x0000000825757824ULL, 0x040fe200078e00ffULL,
0x0000000725767812ULL, 0x000fe200078ec0ffULL, 0x0000002003247824ULL, 0x000fe200078e0224ULL,
0x0000000774737812ULL, 0x040fe200078ec0ffULL, 0x0000000874747824ULL, 0x000fe200078e00ffULL,
0x0000000176267812ULL, 0x000fe200078e7800ULL, 0x0000002025777836ULL, 0x040fe20000000000ULL,
0x0000000173277812ULL, 0x000fe200078e7800ULL, 0x0000003025257836ULL, 0x000fe20000000000ULL,
0x0000007526267212ULL, 0x000fe200078efcffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000624247c11ULL, 0x000fe2000f8e20ffULL, 0x0000302601007387ULL, 0x0003e20000100800ULL,
0x0000007427277212ULL, 0x000fe400078efcffULL, 0x0000000726297c11ULL, 0x000fe2000f8e20ffULL,
0x000000002440783bULL, 0x0005e20000000200ULL, 0x0000000777727812ULL, 0x040fe200078ec0ffULL,
0x0000000877777824ULL, 0x000fe200078e00ffULL, 0x0000000725717812ULL, 0x040fe200078ec0ffULL,
0x00006c2901007387ULL, 0x000fe20000100800ULL, 0x0000000325787819ULL, 0x000fc400000006ffULL,
0x0000000728267812ULL, 0x002fe200078e7803ULL, 0x0000342701007387ULL, 0x0003e20000100800ULL,
0x0000000727247c11ULL, 0x004fe4000f8e20ffULL, 0x0000002603267211ULL, 0x000fe200078e28ffULL,
0x000000002934783bULL, 0x000ea20000000200ULL, 0x0000000171257812ULL, 0x000fe400078e7800ULL,
0x0000000626287c11ULL, 0x000fe2000f8e20ffULL, 0x000000002444783bULL, 0x000fe20000000200ULL,
0x0000000276267812ULL, 0x000fc400078e1e79ULL, 0x0000000273277812ULL, 0x002fe200078e1e79ULL,
0x0000782401007387ULL, 0x0003e20000100800ULL, 0x00000075262a7212ULL, 0x000fe400078efcffULL,
0x00000078252d7212ULL, 0x000fe400078efcffULL, 0x000000072a2c7c11ULL, 0x000fe2000f8e20ffULL,
0x00004c2a01007387ULL, 0x000fe20000100800ULL, 0x000000072d257c11ULL, 0x000fe4000f8e20ffULL,
0x0000000172247812ULL, 0x002fe200078e7800ULL, 0x000000002c30783bULL, 0x000fe60000000200ULL,
0x0000007724297212ULL, 0x000fe200078efcffULL, 0x00000000254c783bULL, 0x000e620000000200ULL,
0x0000007427247212ULL, 0x000fc400078efcffULL, 0x0000000729267c11ULL, 0x000fe2000f8e20ffULL,
0x0000382901007387ULL, 0x000fe80000100800ULL, 0x0000442d01007387ULL, 0x000fe80000100800ULL,
0x0000942c01007387ULL, 0x0005e80000100800ULL, 0x0000502401007387ULL, 0x0007e80000100800ULL,
0x000000002828783bULL, 0x000f220000000200ULL, 0x00000034402c723cULL, 0x004fe600000418ffULL,
0x0000802601007387ULL, 0x000fe20000100800ULL, 0x0000000724247c11ULL, 0x008fc6000f8e20ffULL,
0x0000882501007387ULL, 0x000fe20000100800ULL, 0x000000364034723cULL, 0x000fe600000418ffULL,
0x000000002448783bULL, 0x000ea80000000200ULL, 0x000000002638783bULL, 0x000ee80000000200ULL,
0x00009c2401007387ULL, 0x000be20000100800ULL, 0x0000004c403c723cULL, 0x002fec00000418ffULL,
0x000000444024723cULL, 0x020fec00000418ffULL, 0x000000464044723cULL, 0x000fec00000418ffULL,
0x00000030282c723cULL, 0x010fec000004182cULL, 0x000000322830723cULL, 0x000fec0000041834ULL,
0x000000482824723cULL, 0x004fec0000041824ULL, 0x0000004a2848723cULL, 0x000fec0000041844ULL,
0x000000384034723cULL, 0x008fe200000418ffULL, 0x0000000272447812ULL, 0x000fc400078e1e79ULL,
0x0000000271457812ULL, 0x000fe400078e1e79ULL, 0x00000077444c7212ULL, 0x000fe200078efcffULL,
0x0000003a4038723cULL, 0x000fe200000418ffULL, 0x00000078454d7212ULL, 0x000fe400078efcffULL,
0x000000074c467c11ULL, 0x000fe2000f8e20ffULL, 0x0000404c01007387ULL, 0x0003e40000100800ULL,
0x0000004e4040723cULL, 0x000fe400000418ffULL, 0x0000484d01007387ULL, 0x000fe80000100800ULL,
0x0000844601007387ULL, 0x000fe20000100800ULL, 0x000000074d4c7c11ULL, 0x002fc6000f8e20ffULL,
0x000000004644783bULL, 0x000e680000000200ULL, 0x00008c4c01007387ULL, 0x000fe80000100800ULL,
0x000000004c4c783bULL, 0x000ea20000000200ULL, 0x000000442834723cULL, 0x002fe20000041834ULL,
0x0000000000457919ULL, 0x000e6a0000000000ULL, 0x000000462838723cULL, 0x000fec0000041838ULL,
0x0000004c283c723cULL, 0x004fec000004183cULL, 0x0000004e2840723cULL, 0x000fe20000041840ULL,
0x00000004724d7812ULL, 0x000fc400078e1e79ULL, 0x00000004714c7812ULL, 0x000fe400078e1e79ULL,
0x000000774d4d7212ULL, 0x000fe400078efcffULL, 0x0000000476287812ULL, 0x000fe400078e1e79ULL,
0x0000000676767812ULL, 0x000fe400078e1e79ULL, 0x00000075284f7212ULL, 0x080fe400078efcffULL,
0x0000007576767212ULL, 0x000fc400078efcffULL, 0x00000004ff457819ULL, 0x002fe40000011645ULL,
0x000000074f2a7c11ULL, 0x000fe4000f8e20ffULL, 0x000000074d757c11ULL, 0x000fe2000f8e20ffULL,
0x0000000445297836ULL, 0x000fe20000000000ULL, 0x000000784c4c7212ULL, 0x000fe200078efcffULL,
0x0000742a01007387ULL, 0x000fe20000100800ULL, 0x0000000672727812ULL, 0x000fe400078e1e79ULL,
0x0000000729297812ULL, 0x000fc400078e7803ULL, 0x0000007772727212ULL, 0x000fe400078efcffULL,
0x0000000671717812ULL, 0x000fe200078e1e79ULL, 0x0000002003297824ULL, 0x000fc600078e0229ULL,
0x0000007871717212ULL, 0x000fe400078efcffULL, 0x0000000629297c11ULL, 0x000fca000f8e20ffULL,
0x000000002944783bULL, 0x000fe80000000200ULL, 0x000000002a28783bULL, 0x000e640000000200ULL,
0x00000028442c723cULL, 0x002fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x0000000473287812ULL, 0x000fc400078e1e79ULL, 0x0000000673737812ULL, 0x000fe400078e1e79ULL,
0x00000074284e7212ULL, 0x080fe400078efcffULL, 0x0000007473737212ULL, 0x000fe400078efcffULL,
0x000000074e297c11ULL, 0x000fe4000f8e20ffULL, 0x000000074c747c11ULL, 0x000fc6000f8e20ffULL,
0x0000642901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e680000000200ULL,
0x0000707501007387ULL, 0x000fe80000100800ULL, 0x0000687401007387ULL, 0x000fe20000100800ULL,
0x000000284424723cULL, 0x002fec0000041824ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x000000007528783bULL, 0x0002a40000000200ULL, 0x0000000000757919ULL, 0x002e660000000000ULL,
0x000000284434723cULL, 0x004fe20000041834ULL, 0x00000004ff757819ULL, 0x002fca0000011675ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000007428783bULL, 0x0002a40000000200ULL,
0x0000000776747c11ULL, 0x002fca000f8e20ffULL, 0x0000607401007387ULL, 0x000fe20000100800ULL,
0x00000028443c723cULL, 0x004fec000004183cULL, 0x0000002a4440723cULL, 0x000fe20000041840ULL,
0x0000000675287836ULL, 0x000fca0000000000ULL, 0x0000000728287812ULL, 0x000fc800078e7803ULL,
0x0000002803287211ULL, 0x000fc800078e28ffULL, 0x0000000628287c11ULL, 0x000fca000f8e20ffULL,
0x000000002844783bULL, 0x000fe80000000200ULL, 0x000000007428783bULL, 0x0002a40000000200ULL,
0x0000000773747c11ULL, 0x002fca000f8e20ffULL, 0x00005c7401007387ULL, 0x000fe20000100800ULL,
0x00000028442c723cULL, 0x004fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x000000007428783bULL, 0x0002a40000000200ULL, 0x0000000772747c11ULL, 0x002fca000f8e20ffULL,
0x0000587401007387ULL, 0x000fe20000100800ULL, 0x000000284424723cULL, 0x004fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007428783bULL, 0x0002a40000000200ULL,
0x0000000771747c11ULL, 0x002fca000f8e20ffULL, 0x0000547401007387ULL, 0x000fe20000100800ULL,
0x000000284434723cULL, 0x004fec0000041834ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x000000007428783bULL, 0x000e6a0000000200ULL, 0x00000028443c723cULL, 0x002fec000004183cULL,
0x0000002a4440723cULL, 0x000fe20000041840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000400188947ULL, 0x000fde0003800000ULL, 0x800000080c097290ULL, 0x000fe2000fffe03fULL,
0x000000105b2a7812ULL, 0x000fe400078efcffULL, 0x0000000769697c11ULL, 0x000fe4000f8e20ffULL,
0x0000000768687c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x000fe200078e0006ULL,
0x0000000900007c0cULL, 0x000fe4000bf26070ULL, 0x000000076d6d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000767677c11ULL, 0x000fc4000f8e20ffULL, 0x000000076f6f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000770707c11ULL, 0x000fe4000f8e20ffULL, 0x0000000766667c11ULL, 0x000fe4000f8e20ffULL,
0x0000000764647c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028697faeULL, 0x0003e2000c901c4eULL, 0x0000000954007c0cULL, 0x000fe4000bf26070ULL,
0x0000000763637c11ULL, 0x000fc4000f8e20ffULL, 0x0000000762627c11ULL, 0x000fe4000f8e20ffULL,
0x0000000761617c11ULL, 0x000fe4000f8e20ffULL, 0x0000000760607c11ULL, 0x000fe4000f8e20ffULL,
0x000000075f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fe200078e0008ULL,
0x000000075e5e7c11ULL, 0x000fe4000f8e20ffULL, 0x000000075d5d7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000028687faeULL, 0x0003e2000c901c4eULL, 0x0000000953007c0cULL, 0x000fe4000bf26070ULL,
0x000000075c5c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fd400078e000aULL,
0x00000000286d7faeULL, 0x0003e2000c901c4eULL, 0x0000000952007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e000cULL, 0x0000000028677faeULL, 0x0003e2000c901c4eULL,
0x0000000902007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e000eULL,
0x00000000286f7faeULL, 0x0003e2000c901c4eULL, 0x0000000958007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0010ULL, 0x0000000028707faeULL, 0x0003e2000c901c4eULL,
0x0000000957007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0012ULL,
0x0000000028667faeULL, 0x0003e2000c901c4eULL, 0x0000000956007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0014ULL, 0x0000000028647faeULL, 0x0003e2000c901c4eULL,
0x0000000955007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0016ULL,
0x0000000028637faeULL, 0x0003e2000c901c4eULL, 0x000000095a007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0018ULL, 0x0000000028627faeULL, 0x0003e2000c901c4eULL,
0x0000000959007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e001aULL,
0x0000000028617faeULL, 0x0003e2000c901c4eULL, 0x000000096c007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e001cULL, 0x0000000028607faeULL, 0x0003e2000c901c4eULL,
0x000000096b007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e001eULL,
0x00000000285f7faeULL, 0x0003e2000c901c4eULL, 0x000000096a007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0020ULL, 0x00000000285e7faeULL, 0x0003e2000c901c4eULL,
0x0000000965007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fc800078e0022ULL,
0x000000102a2a7825ULL, 0x000fd000078e0050ULL, 0x00000000285d7faeULL, 0x0003e2000c901c4eULL,
0x000000096e007c0cULL, 0x000fda000bf26070ULL, 0x000000002a5c7faeULL, 0x0003e2000c901c4eULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x000000105b2a7812ULL, 0x000fe400078efcffULL,
0x0000000769697c11ULL, 0x000fe4000f8e20ffULL, 0x0000000768687c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x000fe200078e0006ULL, 0x000000076d6d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000767677c11ULL, 0x000fe4000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028697faeULL, 0x0003e2000b901c4eULL, 0x000000076f6f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000770707c11ULL, 0x000fe4000f8e20ffULL, 0x0000000766667c11ULL, 0x000fe4000f8e20ffULL,
0x0000000764647c11ULL, 0x000fe4000f8e20ffULL, 0x0000000763637c11ULL, 0x000fe4000f8e20ffULL,
0x0000000762627c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fe200078e0008ULL,
0x0000000761617c11ULL, 0x000fc4000f8e20ffULL, 0x0000000760607c11ULL, 0x000fe4000f8e20ffULL,
0x0000000028687faeULL, 0x0003e2000b901c4eULL, 0x000000075f5f7c11ULL, 0x000fe4000f8e20ffULL,
0x000000075e5e7c11ULL, 0x000fe4000f8e20ffULL, 0x000000075d5d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000075c5c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fca00078e000aULL,
0x00000000286d7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e000cULL,
0x0000000028677faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e000eULL,
0x00000000286f7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0010ULL,
0x0000000028707faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0012ULL,
0x0000000028667faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0014ULL,
0x0000000028647faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0016ULL,
0x0000000028637faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0018ULL,
0x0000000028627faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e001aULL,
0x0000000028617faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e001cULL,
0x0000000028607faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e001eULL,
0x00000000285f7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fca00078e0020ULL,
0x00000000285e7faeULL, 0x0003e4000b901c4eULL, 0x000000102a287825ULL, 0x002fc800078e0022ULL,
0x000000102a2a7825ULL, 0x000fe200078e0050ULL, 0x00000000285d7faeULL, 0x0003e8000b901c4eULL,
0x000000002a5c7faeULL, 0x0003e4000b901c4eULL, 0x0000300001297983ULL, 0x002ea80000300800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000875287836ULL, 0x000fc60000000000ULL,
0x00004c0001797983ULL, 0x000ee40000300800ULL, 0x0000000728287812ULL, 0x000fe400078e7803ULL,
0x0000500001787983ULL, 0x000f260000300800ULL, 0x0000002003287824ULL, 0x000fe200078e0228ULL,
0x0000400001777983ULL, 0x000f680000300800ULL, 0x0000000628287c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002844783bULL, 0x000fe20000000200ULL,
0x0000000a29297c11ULL, 0x004fca000f8e20ffULL, 0x0000982901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e680000000200ULL, 0x0000480001747983ULL, 0x000ea20000300800ULL,
0x00000028442c723cULL, 0x002fe6000004182cULL, 0x0000340001297983ULL, 0x000ea60000300800ULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x0000000a29297c11ULL, 0x004fca000f8e20ffULL,
0x0000902901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x000000284424723cULL, 0x002fe40000041824ULL, 0x0000380001297983ULL, 0x000ea80000300800ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x0000000a29297c11ULL, 0x004fca000f8e20ffULL,
0x00007c2901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x000000284434723cULL, 0x002fe40000041834ULL, 0x0000440001297983ULL, 0x000ea80000300800ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x0000000a79797c11ULL, 0x008fc4000f8e20ffULL,
0x0000000a78787c11ULL, 0x010fe4000f8e20ffULL, 0x0000000a77777c11ULL, 0x020fe4000f8e20ffULL,
0x0000000a29297c11ULL, 0x004fca000f8e20ffULL, 0x0000442901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e640000000200ULL, 0x00000028443c723cULL, 0x002fee000004183cULL,
0x0000000a75287836ULL, 0x000fca0000000000ULL, 0x0000000728287812ULL, 0x000fc800078e7803ULL,
0x0000002803287211ULL, 0x000fc800078e28ffULL, 0x0000000628287c11ULL, 0x000fe2000f8e20ffULL,
0x0000002a4440723cULL, 0x000fe80000041840ULL, 0x000000002844783bULL, 0x000fe80000000200ULL,
0x000000007928783bULL, 0x000e640000000200ULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000007828783bULL, 0x000e680000000200ULL,
0x0000387901007387ULL, 0x0005e20000100800ULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007728783bULL, 0x000e620000000200ULL,
0x0000000a74797c11ULL, 0x004fc8000f8e20ffULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000007928783bULL, 0x000e680000000200ULL,
0x0000347801007387ULL, 0x0005e40000100800ULL, 0x0000000a4f787c11ULL, 0x004fe2000f8e20ffULL,
0x00000028443c723cULL, 0x002fee000004183cULL, 0x0000000c75287836ULL, 0x000fca0000000000ULL,
0x0000000728287812ULL, 0x000fca00078e7803ULL, 0x0000002003287824ULL, 0x000fe200078e0228ULL,
0x0000002a4440723cULL, 0x000fe80000041840ULL, 0x0000000628287c11ULL, 0x000fca000f8e20ffULL,
0x000000002844783bULL, 0x000fe80000000200ULL, 0x000000007828783bULL, 0x000e680000000200ULL,
0x0000307701007387ULL, 0x0005e40000100800ULL, 0x0000000a4e777c11ULL, 0x004fe2000f8e20ffULL,
0x00000028442c723cULL, 0x002fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x000000007728783bULL, 0x000e620000000200ULL, 0x0000000a4d757c11ULL, 0x000fc4000f8e20ffULL,
0x0000000a4c747c11ULL, 0x000fe4000f8e20ffULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007528783bULL, 0x000e620000000200ULL,
0x00000000004f7919ULL, 0x000ea80000000000ULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000007428783bULL, 0x000e620000000200ULL,
0x00000004ff4f7819ULL, 0x004fc4000001164fULL, 0x0000000a734e7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a724d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000180001737983ULL, 0x0005620000100800ULL,
0x0000000a714c7c11ULL, 0x000fc6000f8e20ffULL, 0x0000200001727983ULL, 0x0005680000100800ULL,
0x0000240001717983ULL, 0x0005620000100800ULL, 0x00000028443c723cULL, 0x002fee000004183cULL,
0x0000000e4f287836ULL, 0x000fe20000000000ULL, 0x0000000a764f7c11ULL, 0x000fc4000f8e20ffULL,
0x00000c0001767983ULL, 0x0005640000100800ULL, 0x0000000728287812ULL, 0x000fe200078e7803ULL,
0x0000002a4440723cULL, 0x000fe60000041840ULL, 0x0000002803287211ULL, 0x000fc800078e28ffULL,
0x0000000628447c11ULL, 0x000fe4000f8e20ffULL, 0x000000004f28783bULL, 0x000fe80000000200ULL,
0x000000004444783bULL, 0x000e640000000200ULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000004e28783bULL, 0x000e6a0000000200ULL,
0x000000284424723cULL, 0x002fec0000041824ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x000000004d28783bULL, 0x000e6a0000000200ULL, 0x000000284434723cULL, 0x002fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000004c28783bULL, 0x000e6a0000000200ULL,
0x00000028443c723cULL, 0x002fec000004183cULL, 0x0000002a4440723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000f88947ULL, 0x004fde0003800000ULL,
0x00000000012a7983ULL, 0x000ea80000300800ULL, 0x00000400012b7983ULL, 0x000ee20000300800ULL,
0x800000080c077290ULL, 0x000fe2000fffe03fULL, 0x000000185b287812ULL, 0x000fe400078efcffULL,
0x0000080001457983ULL, 0x000f260000300800ULL, 0x0000000700007c0cULL, 0x000fe2000bf06070ULL,
0x0000001028067825ULL, 0x000fe200078e0006ULL, 0x0000000752007c0cULL, 0x000fe2000bf26070ULL,
0x0000140001467983ULL, 0x000f240000300800ULL, 0x0000001028087825ULL, 0x000fc400078e0008ULL,
0x0000100001477983ULL, 0x000f280000300800ULL, 0x00001c0001297983ULL, 0x000f220000300800ULL,
0x00000010280a7825ULL, 0x000fc600078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000067a7faeULL, 0x000fe2000c101c4eULL, 0x0000000754007c0cULL, 0x000fe2000bf06070ULL,
0x00000010280c7825ULL, 0x000fd800078e000cULL, 0x00000000087c7faeULL, 0x000fe2000c101c4eULL,
0x0000000753007c0cULL, 0x000fda000bf06070ULL, 0x000000000a2a7faeULL, 0x004fe8000c101c4eULL,
0x000000000c2b7faeULL, 0x008fe8000c901c4eULL, 0x00002c00012a7983ULL, 0x000ea80000300800ULL,
0x00002800012b7983ULL, 0x000ee20000300800ULL, 0x0000000702007c0cULL, 0x000fe2000bf06070ULL,
0x00000010280e7825ULL, 0x000fe200078e000eULL, 0x0000000758007c0cULL, 0x000fc4000bf26070ULL,
0x0000000757007c0cULL, 0x000fe2000bf46070ULL, 0x0000001028107825ULL, 0x000fe200078e0010ULL,
0x0000000756007c0cULL, 0x000fe4000bf66070ULL, 0x0000000755007c0cULL, 0x000fe2000bf86070ULL,
0x0000001028127825ULL, 0x000fe200078e0012ULL, 0x0000000765007c0cULL, 0x000fe4000bfa6070ULL,
0x000000076e007c0cULL, 0x000fe2000bfc6070ULL, 0x0000001028147825ULL, 0x000fe200078e0014ULL,
0x000000000e457faeULL, 0x010fe2000c101c4eULL, 0x000000075a007c0cULL, 0x000fc4000bf06070ULL,
0x0000001028167825ULL, 0x040fe200078e0016ULL, 0x00000000107d7faeULL, 0x000fe2000c901c4eULL,
0x0000000759007c0cULL, 0x000fe4000bf26070ULL, 0x0000001028187825ULL, 0x000fe200078e0018ULL,
0x0000000012467faeULL, 0x000fe2000d101c4eULL, 0x000000076c007c0cULL, 0x000fe4000bf46070ULL,
0x00000010281a7825ULL, 0x000fe200078e001aULL, 0x0000000014477faeULL, 0x000fe2000d901c4eULL,
0x000000076b007c0cULL, 0x000fc4000bf66070ULL, 0x00000010281c7825ULL, 0x000fe200078e001cULL,
0x0000000016297faeULL, 0x0009e2000e101c4eULL, 0x000000076a007c0cULL, 0x000fe4000bf86070ULL,
0x00000010281e7825ULL, 0x000fc800078e001eULL, 0x0000001028207825ULL, 0x000fc800078e0020ULL,
0x0000001028227825ULL, 0x000fc800078e0022ULL, 0x0000001028287825ULL, 0x010fe200078e0050ULL,
0x00000000182a7faeULL, 0x0043e8000c101c4eULL, 0x000000001a2b7faeULL, 0x0083e8000c901c4eULL,
0x000000001c717faeULL, 0x0203e8000d101c4eULL, 0x000000001e727faeULL, 0x0003e8000d901c4eULL,
0x0000000020737faeULL, 0x0003e8000e101c4eULL, 0x0000000022767faeULL, 0x0003e8000e901c4eULL,
0x00000000287b7faeULL, 0x0003e2000f101c4eULL, 0x0000000000b07947ULL, 0x000fea0003800000ULL,
0x000000185b287812ULL, 0x000fe200078efcffULL, 0x0000040001297983ULL, 0x000ea80000300800ULL,
0x0000080001477983ULL, 0x000ee20000300800ULL, 0x0000001028067825ULL, 0x000fc600078e0006ULL,
0x0000140001467983ULL, 0x000f280000300800ULL, 0x0000100001457983ULL, 0x000ea80000300800ULL,
0x00001c0001447983ULL, 0x000ea80000300800ULL, 0x00002c00012b7983ULL, 0x000ea80000300800ULL,
0x00002800012a7983ULL, 0x000ea80000300800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000067a7faeULL, 0x000fe8000b901c4eULL, 0x0000000001077983ULL, 0x000ea20000300800ULL,
0x0000001028087825ULL, 0x000fc800078e0008ULL, 0x00000010280a7825ULL, 0x040fe200078e000aULL,
0x00000000087c7faeULL, 0x000fe6000b901c4eULL, 0x00000010280c7825ULL, 0x000fc800078e000cULL,
0x00000010280e7825ULL, 0x000fc800078e000eULL, 0x0000001028107825ULL, 0x000fc800078e0010ULL,
0x0000001028127825ULL, 0x000fc800078e0012ULL, 0x0000001028147825ULL, 0x000fc800078e0014ULL,
0x0000001028167825ULL, 0x000fc800078e0016ULL, 0x0000001028187825ULL, 0x000fc800078e0018ULL,
0x00000010281a7825ULL, 0x000fc800078e001aULL, 0x00000010281c7825ULL, 0x000fc800078e001cULL,
0x00000010281e7825ULL, 0x000fc800078e001eULL, 0x0000001028207825ULL, 0x000fc800078e0020ULL,
0x0000001028227825ULL, 0x040fe200078e0022ULL, 0x000000000a077faeULL, 0x004fe8000b901c4eULL,
0x000000000c297faeULL, 0x0005e8000b901c4eULL, 0x000000000e477faeULL, 0x0083e8000b901c4eULL,
0x00000000107d7faeULL, 0x0003e8000b901c4eULL, 0x0000000012467faeULL, 0x0103e2000b901c4eULL,
0x0000001028287825ULL, 0x004fc600078e0050ULL, 0x0000000014457faeULL, 0x0003e8000b901c4eULL,
0x0000000016447faeULL, 0x0003e8000b901c4eULL, 0x00000000182b7faeULL, 0x0003e8000b901c4eULL,
0x000000001a2a7faeULL, 0x0003e8000b901c4eULL, 0x000000001c717faeULL, 0x0203e8000b901c4eULL,
0x000000001e727faeULL, 0x0003e8000b901c4eULL, 0x0000000020737faeULL, 0x0003e8000b901c4eULL,
0x0000000022767faeULL, 0x0003e8000b901c4eULL, 0x00000000287b7faeULL, 0x0003e4000b901c4eULL,
0x00006c0001077983ULL, 0x002ea80000300800ULL, 0x0000780001147983ULL, 0x000ee80000300800ULL,
0x0000800001137983ULL, 0x000f280000300800ULL, 0x0000880001127983ULL, 0x000f680000300800ULL,
0x00000000000079afULL, 0x000e280000000000ULL, 0x0000940001117983ULL, 0x000f280000300800ULL,
0x00009c0001227983ULL, 0x000f280000300800ULL, 0x0000840001217983ULL, 0x000f220000300800ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000004ff447819ULL, 0x002fe20000011606ULL, 0x00000000070c783bULL, 0x0043e80000000200ULL,
0x00000000141c783bULL, 0x008fe80000000200ULL, 0x00008c0001077983ULL, 0x002ea20000300800ULL,
0x0000001044067836ULL, 0x000fc60000000000ULL, 0x0000740001207983ULL, 0x000ee40000300800ULL,
0x0000000706067812ULL, 0x000fe400078e7803ULL, 0x0000640001477983ULL, 0x000ee60000300800ULL,
0x0000002003067824ULL, 0x000fe200078e0206ULL, 0x000000001214783bULL, 0x020fe80000000200ULL,
0x0000000606067c11ULL, 0x000fe2000f8e20ffULL, 0x00007000012b7983ULL, 0x000f680000300800ULL,
0x000000000608783bULL, 0x000e680000000200ULL, 0x00006800012a7983ULL, 0x000ee80000300800ULL,
0x0000600001297983ULL, 0x000ee80000300800ULL, 0x00005c0001287983ULL, 0x000ee80000300800ULL,
0x0000580001467983ULL, 0x000ee80000300800ULL, 0x0000540001457983ULL, 0x000ee80000300800ULL,
0x000000001318783bULL, 0x010f220000000200ULL, 0x00000014083c723cULL, 0x002fec000004183cULL,
0x000000160840723cULL, 0x000fe20000041840ULL, 0x0000001244107836ULL, 0x000fca0000000000ULL,
0x0000000710107812ULL, 0x000fc800078e7803ULL, 0x0000001003107211ULL, 0x000fc800078e28ffULL,
0x0000000610107c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c082c723cULL, 0x000fe2000004182cULL,
0x000000000714783bULL, 0x0043e80000000200ULL, 0x00003c0001077983ULL, 0x002ea20000100800ULL,
0x0000000e0830723cULL, 0x000fe60000041830ULL, 0x00000000110c783bULL, 0x000fe80000000200ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x0000001c0824723cULL, 0x000fe20000041824ULL,
0x0000001444067836ULL, 0x000fca0000000000ULL, 0x0000001e0848723cULL, 0x000fec0000041848ULL,
0x000000180834723cULL, 0x010fec0000041834ULL, 0x0000001a0838723cULL, 0x000fe20000041838ULL,
0x000000002208783bULL, 0x000f280000000200ULL, 0x000000002118783bULL, 0x000f220000000200ULL,
0x0000000706067812ULL, 0x000fc600078e7803ULL, 0x000000002020783bULL, 0x008fe40000000200ULL,
0x0000002003067824ULL, 0x000fe400078e0206ULL, 0x00000000471c783bULL, 0x000fe60000000200ULL,
0x0000000606067c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c102c723cULL, 0x002fec000004182cULL,
0x0000000e1030723cULL, 0x000fe20000041830ULL, 0x00000000060c783bULL, 0x000e6a0000000200ULL,
0x00000014103c723cULL, 0x000fec000004183cULL, 0x000000161040723cULL, 0x000fec0000041840ULL,
0x000000081024723cULL, 0x010fec0000041824ULL, 0x0000000a1048723cULL, 0x000fe20000041848ULL,
0x000000002b08783bULL, 0x020eea0000000200ULL, 0x000000181034723cULL, 0x000fec0000041834ULL,
0x0000001a1038723cULL, 0x000fe20000041838ULL, 0x000000002a10783bULL, 0x000f220000000200ULL,
0x0000001644147836ULL, 0x000fc60000000000ULL, 0x000000002918783bULL, 0x000fe40000000200ULL,
0x0000000714147812ULL, 0x000fe200078e7803ULL, 0x000000200c2c723cULL, 0x002fe2000004182cULL,
0x000000002828783bULL, 0x000fe40000000200ULL, 0x0000001403147211ULL, 0x000fc800078e28ffULL,
0x0000000614147c11ULL, 0x000fe2000f8e20ffULL, 0x000000220c30723cULL, 0x000fe20000041830ULL,
0x000000004620783bULL, 0x000fe80000000200ULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x0000001c0c24723cULL, 0x000fec0000041824ULL, 0x0000001e0c48723cULL, 0x000fe20000041848ULL,
0x00000000451c783bULL, 0x000f6a0000000200ULL, 0x000000080c34723cULL, 0x008fec0000041834ULL,
0x0000000a0c38723cULL, 0x000fec0000041838ULL, 0x000000100c3c723cULL, 0x010fec000004183cULL,
0x000000120c40723cULL, 0x000fe20000041840ULL, 0x0000000000507919ULL, 0x000eea0000000000ULL,
0x00000018142c723cULL, 0x002fec000004182cULL, 0x0000001a1430723cULL, 0x000fec0000041830ULL,
0x000000281424723cULL, 0x000fec0000041824ULL, 0x0000002a1448723cULL, 0x000fec0000041848ULL,
0x000000201434723cULL, 0x000fec0000041834ULL, 0x000000221438723cULL, 0x000fec0000041838ULL,
0x0000001c143c723cULL, 0x020fec000004183cULL, 0x0000001e1440723cULL, 0x000fe20000041840ULL,
0x00000000070972caULL, 0x004fda00000e0000ULL, 0x0000000915097290ULL, 0x000fc8000fffe03fULL,
0x0000000109077890ULL, 0x000fc8000fffe03fULL, 0x000000040700728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000d090a7291ULL, 0x000fc8000f8e403fULL,
0x0000000b050b72a4ULL, 0x000fd0000f8e020aULL, 0x0000000400a48947ULL, 0x008fea0003800000ULL,
0x0000001050287824ULL, 0x000fe200078e00ffULL, 0x0000000a0c00728cULL, 0x000fe2000bf01070ULL,
0x0000000b54097c36ULL, 0x000fe20008000000ULL, 0x0000000b530b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000b520d7c36ULL, 0x000fe20008000000ULL, 0x0000007028287812ULL, 0x000fe200078ec0ffULL,
0x0000020009087825ULL, 0x100fe200078e0004ULL, 0x0000000a0c077287ULL, 0x000fe2000c000000ULL,
0x0000000b58237c10ULL, 0x000fe4000fffe0ffULL, 0x0000000b00077c36ULL, 0x000fe20008000000ULL,
0x0000000828087210ULL, 0x000fe20007f3e0ffULL, 0x000002000d0c7825ULL, 0x000fe200078e0004ULL,
0x000000070a077290ULL, 0x000fe2000fffe13fULL, 0x0000000b5a1b7c10ULL, 0x000fc4000fffe0ffULL,
0x0000020007067825ULL, 0x100fe200078e0004ULL, 0x00000009ff097210ULL, 0x000fe40000ffe4ffULL,
0x0000000c280c7210ULL, 0x000fe20007f3e0ffULL, 0x000002000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000000628067210ULL, 0x000fe40007f1e0ffULL, 0x0000000753007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000000a280a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000b020f7c36ULL, 0x000fe20008000000ULL, 0x0000000700007c0cULL, 0x000fe2000bf26070ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000754007c0cULL, 0x000fe2000bf06070ULL,
0x000002000f0e7825ULL, 0x000fe200078e0004ULL, 0x0000000702007c0cULL, 0x000fc4000bf86070ULL,
0x0000000b6a137c10ULL, 0x000fe2000fffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000752007c0cULL, 0x000fe2000bf46070ULL, 0x0000000b57217c36ULL, 0x000fe20008000000ULL,
0x0000000e280e7210ULL, 0x000fe20007fbe0ffULL, 0x0000020023227825ULL, 0x100fe400078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006697faeULL, 0x0003e4000c901c4eULL,
0x0000000b561f7c36ULL, 0x000fe20008000000ULL, 0x0000002228227210ULL, 0x000fe20007fde0ffULL,
0x0000000b551d7c36ULL, 0x000fe20008000000ULL, 0x0000000008687faeULL, 0x0005e2000c101c4eULL,
0x0000020021207825ULL, 0x000fe200078e0004ULL, 0x0000000757007c0cULL, 0x000fc4000bf06070ULL,
0x000000000a6d7faeULL, 0x0007e2000d901c4eULL, 0x000002001f1e7825ULL, 0x100fe200078e0004ULL,
0x0000002028067210ULL, 0x002fe40007f3e0ffULL, 0x000000000c677faeULL, 0x0003e2000d101c4eULL,
0x000002001d1c7825ULL, 0x000fe200078e0004ULL, 0x0000000755007c0cULL, 0x000fe4000bf46070ULL,
0x00000021ff077210ULL, 0x000fe20000ffe4ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e060fULL,
0x0000000758007c0cULL, 0x000fe2000bfa6070ULL, 0x000000ffff237224ULL, 0x000fe200030e0623ULL,
0x0000001e28087210ULL, 0x004fe20007fde0ffULL, 0x000002001b1a7825ULL, 0x000fe200078e0004ULL,
0x0000001c280a7210ULL, 0x008fe20007f7e0ffULL, 0x000000000e6f7faeULL, 0x0005e2000e101c4eULL,
0x0000000756007c0cULL, 0x000fe2000bf26070ULL, 0x0000000b59197c36ULL, 0x000fc40008000000ULL,
0x0000000b6c177c36ULL, 0x000fe40008000000ULL, 0x0000000b6b157c36ULL, 0x000fe40008000000ULL,
0x000000ffff097224ULL, 0x000fe200030e061fULL, 0x0000001a280c7210ULL, 0x002fe20007fde0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e061dULL, 0x000000075a007c0cULL, 0x000fe2000bf66070ULL,
0x0000000b65117c36ULL, 0x000fe20008000000ULL, 0x0000000022707faeULL, 0x0003e2000e901c4eULL,
0x0000020019187825ULL, 0x000fe200078e0004ULL, 0x0000000759007c0cULL, 0x000fc4000bfa6070ULL,
0x0000000006667faeULL, 0x0003e2000c101c4eULL, 0x0000020017167825ULL, 0x100fe200078e0004ULL,
0x00000018280e7210ULL, 0x004fe40007f9e0ffULL, 0x0000000008647faeULL, 0x0003e2000c901c4eULL,
0x0000020015147825ULL, 0x100fe200078e0004ULL, 0x00000019ff0f7210ULL, 0x000fe400027fe4ffULL,
0x000000000a637faeULL, 0x0003e2000d101c4eULL, 0x0000020011107825ULL, 0x000fe200078e0004ULL,
0x0000001428147210ULL, 0x000fc40007f1e0ffULL, 0x000000076c007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff0d7224ULL, 0x000fe200030e061bULL, 0x0000001628167210ULL, 0x000fe20007fde0ffULL,
0x0000020013127825ULL, 0x000fe200078e0004ULL, 0x0000001028107210ULL, 0x000fe40007f5e0ffULL,
0x000000076b007c0cULL, 0x000fe2000bf26070ULL, 0x0000000b6e297c36ULL, 0x000fe20008000000ULL,
0x000000000c627faeULL, 0x0003e2000d901c4eULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000001228127210ULL, 0x000fe20007fde0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x000000076a007c0cULL, 0x000fe2000bf06070ULL, 0x0000020029047825ULL, 0x000fe200078e0004ULL,
0x0000000765007c0cULL, 0x000fe2000bf66070ULL, 0x000000000e617faeULL, 0x0003e2000e901c4eULL,
0x00000011ff117210ULL, 0x000fe200017fe4ffULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x000000076e007c0cULL, 0x000fe2000bf46070ULL, 0x0000000016607faeULL, 0x0003e2000e101c4eULL,
0x0000000428287210ULL, 0x000fc60007fde0ffULL, 0x00000000145f7faeULL, 0x0003e4000c901c4eULL,
0x000000ffff297224ULL, 0x000fe400030e0605ULL, 0x00000000125e7faeULL, 0x0003e8000c101c4eULL,
0x00000000105d7faeULL, 0x0003e8000d901c4eULL, 0x00000000285c7faeULL, 0x0003e2000d101c4eULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x0000000b02157c36ULL, 0x000fe20008000000ULL,
0x0000000b52237c10ULL, 0x000fe2000fffe0ffULL, 0x0000001050027824ULL, 0x000fe200078e00ffULL,
0x0000000b561b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000b001d7c36ULL, 0x000fe20008000000ULL,
0x0000000b6c137c10ULL, 0x000fe2000fffe0ffULL, 0x0000000b53217c36ULL, 0x000fe20008000000ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x000002001d1c7825ULL, 0x000fe200078e0004ULL,
0x0000000b6a097c10ULL, 0x000fc6000fffe0ffULL, 0x0000000b541f7c36ULL, 0x000fe20008000000ULL,
0x0000001c021c7210ULL, 0x000fe20007f1e0ffULL, 0x0000020021207825ULL, 0x000fc800078e0004ULL,
0x0000020023227825ULL, 0x000fe200078e0004ULL, 0x0000002002207210ULL, 0x000fc60007f5e0ffULL,
0x0000000b57197c36ULL, 0x000fe20008000000ULL, 0x0000002202227210ULL, 0x000fe20007f7e0ffULL,
0x000002001f1e7825ULL, 0x000fc800078e0004ULL, 0x0000000b58177c36ULL, 0x000fe20008000000ULL,
0x0000001e021e7210ULL, 0x000fe20007f3e0ffULL, 0x0000020015147825ULL, 0x000fc600078e0004ULL,
0x0000001fff1f7210ULL, 0x000fe20000ffe4ffULL, 0x0000000b550d7c36ULL, 0x000fe40008000000ULL,
0x0000020019187825ULL, 0x000fc800078e0004ULL, 0x000002001b1a7825ULL, 0x000fc800078e0004ULL,
0x0000000b59117c36ULL, 0x000fe40008000000ULL, 0x0000020017167825ULL, 0x000fc800078e0004ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000001402147210ULL, 0x000fe20007f1e0ffULL,
0x0000000b5a0f7c36ULL, 0x000fe20008000000ULL, 0x0000001602167210ULL, 0x000fe20007f3e0ffULL,
0x000002000d0c7825ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c697faeULL, 0x0003e4000b901c4eULL, 0x00000017ff177210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff217224ULL, 0x000fe200010e0621ULL, 0x0000001802187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x0000001a021a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000b6b077c36ULL, 0x000fe20008000000ULL, 0x000000001e687faeULL, 0x0003e2000b901c4eULL,
0x0000020011107825ULL, 0x000fc600078e0004ULL, 0x00000000206d7faeULL, 0x0003e2000b901c4eULL,
0x000002000f0e7825ULL, 0x000fc600078e0004ULL, 0x0000000022677faeULL, 0x0003e2000b901c4eULL,
0x0000020013127825ULL, 0x000fe200078e0004ULL, 0x0000000e020e7210ULL, 0x000fc60007f3e0ffULL,
0x0000000b650b7c36ULL, 0x000fe20008000000ULL, 0x0000000fff0f7210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000000c020c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000b6e297c36ULL, 0x000fe40008000000ULL, 0x0000020007067825ULL, 0x000fe200078e0004ULL,
0x00000000146f7faeULL, 0x0003e6000b901c4eULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000001002107210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x0000001202127210ULL, 0x000fe20007f7e0ffULL, 0x0000020009087825ULL, 0x100fe200078e0004ULL,
0x0000000016707faeULL, 0x0003e6000b901c4eULL, 0x000002000b0a7825ULL, 0x100fe200078e0004ULL,
0x0000000802087210ULL, 0x000fe20007f3e0ffULL, 0x0000000018667faeULL, 0x0003e4000b901c4eULL,
0x0000020029047825ULL, 0x000fe200078e0004ULL, 0x00000009ff097210ULL, 0x000fe20000ffe4ffULL,
0x000000001a647faeULL, 0x0003e4000b901c4eULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000602067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x0000000a020a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0613ULL,
0x0000000402047210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x000000000c637faeULL, 0x0003e2000b901c4eULL, 0x000000ffff0b7224ULL, 0x000fc400010e060bULL,
0x000000ffff057224ULL, 0x000fe200018e0605ULL, 0x000000000e627faeULL, 0x0003e8000b901c4eULL,
0x0000000010617faeULL, 0x0003e8000b901c4eULL, 0x0000000012607faeULL, 0x0003e8000b901c4eULL,
0x00000000065f7faeULL, 0x0003e8000b901c4eULL, 0x00000000085e7faeULL, 0x0003e8000b901c4eULL,
0x000000000a5d7faeULL, 0x0003e8000b901c4eULL, 0x00000000045c7faeULL, 0x0003e4000b901c4eULL,
0x0000980001047983ULL, 0x002ea80000300800ULL, 0x00009000010c7983ULL, 0x000ee80000300800ULL,
0x00007c0001107983ULL, 0x000f280000300800ULL, 0x0000440001157983ULL, 0x000f680000300800ULL,
0x0000380001197983ULL, 0x000f680000300800ULL, 0x0000340001217983ULL, 0x000f680000300800ULL,
0x0000300001207983ULL, 0x000f620000300800ULL, 0x0000001844027836ULL, 0x040fe20000000000ULL,
0x00000006120a7291ULL, 0x000fe2000f8e183fULL, 0x0000001a44147836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000612077291ULL, 0x000fe2000f8e383fULL,
0x0000000702027812ULL, 0x000fc400078e7803ULL, 0x0000000714187812ULL, 0x000fe400078e7803ULL,
0x0000000203027211ULL, 0x000fc600078e28ffULL, 0x0000002003187824ULL, 0x000fe200078e0218ULL,
0x0000000602027c11ULL, 0x000fc8000f8e20ffULL, 0x00000006181c7c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000208783bULL, 0x0003e80000000200ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x0000001c44027836ULL, 0x002fc60000000000ULL,
0x000000007828783bULL, 0x000fe40000000200ULL, 0x0000000702027812ULL, 0x000fc800078e7803ULL,
0x0000000203027211ULL, 0x000fc800078e28ffULL, 0x0000000602027c11ULL, 0x000fe2000f8e20ffULL,
0x000000000404783bULL, 0x004e680000000200ULL, 0x000000000c0c783bULL, 0x008fe80000000200ULL,
0x000000001010783bULL, 0x010ea80000000200ULL, 0x000000001514783bULL, 0x020ee80000000200ULL,
0x000000001918783bULL, 0x000f220000000200ULL, 0x00000004082c723cULL, 0x002fec000004182cULL,
0x000000060830723cULL, 0x000fe20000041830ULL, 0x000000002104783bULL, 0x000e6a0000000200ULL,
0x000000100834723cULL, 0x004fec0000041834ULL, 0x000000120838723cULL, 0x000fe20000041838ULL,
0x000000007910783bULL, 0x000eaa0000000200ULL, 0x00000014083c723cULL, 0x008fec000004183cULL,
0x0000000c0824723cULL, 0x000fe20000041824ULL, 0x0000001e44147836ULL, 0x000fca0000000000ULL,
0x0000000e0848723cULL, 0x000fe20000041848ULL, 0x00000000200c783bULL, 0x000ee80000000200ULL,
0x000000000220783bULL, 0x000fe20000000200ULL, 0x000000181c2c723cULL, 0x010fec000004182cULL,
0x000000160840723cULL, 0x000fe20000041840ULL, 0x0000000714187812ULL, 0x000fe200078e7803ULL,
0x000000007708783bULL, 0x000f280000000200ULL, 0x0000001a1c30723cULL, 0x000fe20000041830ULL,
0x0000002003037824ULL, 0x000fe200078e0218ULL, 0x000000007514783bULL, 0x000fe80000000200ULL,
0x000000007418783bULL, 0x000f620000000200ULL, 0x000000041c24723cULL, 0x002fe20000041824ULL,
0x0000000603037c11ULL, 0x000fca000f8e20ffULL, 0x000000061c48723cULL, 0x000fe20000041848ULL,
0x000000000304783bULL, 0x0003ea0000000200ULL, 0x000000101c3c723cULL, 0x004fec000004183cULL,
0x0000000e1c38723cULL, 0x008fec0000041838ULL, 0x0000000c1c44723cULL, 0x000fe20000041834ULL,
0x000000004e0c783bULL, 0x000ea80000000200ULL, 0x000000004f34783bULL, 0x000fe20000000200ULL,
0x000000121c40723cULL, 0x000fe60000041840ULL, 0x000000004d1c783bULL, 0x000ee60000000200ULL,
0x000000082010723cULL, 0x010fe20000041824ULL, 0x000000004c24783bULL, 0x000f2a0000000200ULL,
0x0000000a2048723cULL, 0x000fec0000041848ULL, 0x000000182008723cULL, 0x020fec000004183cULL,
0x000000162038723cULL, 0x000fe20000041838ULL, 0x00000001ff187424ULL, 0x000fc800078e00ffULL,
0x01c68818ff0279a7ULL, 0x002e62000850000aULL, 0x00000028202c723cULL, 0x000fec000004182cULL,
0x0000002a2030723cULL, 0x000fec0000041830ULL, 0x000000142044723cULL, 0x000fec0000041844ULL,
0x0000001a2040723cULL, 0x000fe20000041840ULL, 0x01c68803ff0075a7ULL, 0x002e6a000800014aULL,
0x0000000c0420723cULL, 0x004fec0000041810ULL, 0x0000000e0414723cULL, 0x000fec0000041848ULL,
0x0000001e040c723cULL, 0x008fec0000041838ULL, 0x000000240408723cULL, 0x010fec0000041808ULL,
0x00000034042c723cULL, 0x000fe2000004182cULL, 0x3d80000020207820ULL, 0x000fe20000410000ULL,
0x3d80000021217820ULL, 0x000fe20000410000ULL, 0x3d80000022227820ULL, 0x000fe20000410000ULL,
0x3d80000023237820ULL, 0x000fc40000410000ULL, 0x000000360430723cULL, 0x000fe20000041830ULL,
0x3d80000014147820ULL, 0x000fe20000410000ULL, 0x3d80000015157820ULL, 0x000fe20000410000ULL,
0x3d80000016167820ULL, 0x000fe20000410000ULL, 0x3d80000017177820ULL, 0x000fe40000410000ULL,
0x0000001c0410723cULL, 0x000fe20000041844ULL, 0x3d8000000d0d7820ULL, 0x000fe20000410000ULL,
0x3d8000000e0e7820ULL, 0x000fe20000410000ULL, 0x3d8000000f0f7820ULL, 0x000fc60000410000ULL,
0x000000260404723cULL, 0x000fe20000041840ULL, 0x3d8000000c1d7820ULL, 0x000fe20000410000ULL,
0x00000002500c7819ULL, 0x000fe200000006ffULL, 0x3d800000081e7820ULL, 0x000fe20000410000ULL,
0x3d800000091f7820ULL, 0x000fe20000410000ULL, 0x3d8000000a0a7820ULL, 0x000fe20000410000ULL,
0xfffffff00c087812ULL, 0x000fe200078ec0ffULL, 0x3d8000002c197820ULL, 0x000fe20000410000ULL,
0x3d8000002d1a7820ULL, 0x000fe20000410000ULL, 0x3d8000002e1c7820ULL, 0x000fe20000410000ULL,
0x3d8000002f1b7820ULL, 0x000fe20000410000ULL, 0x3d8000000b0b7820ULL, 0x000fe20000410000ULL,
0x3d80000030307820ULL, 0x000fe20000410000ULL, 0x3d80000031317820ULL, 0x000fe20000410000ULL,
0x3d80000032327820ULL, 0x000fe20000410000ULL, 0x3d80000033337820ULL, 0x000fc60000410000ULL,
0x3d80000010107820ULL, 0x000fe20000410000ULL, 0x3d80000011117820ULL, 0x000fe20000410000ULL,
0x3d80000012127820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fc60000410000ULL,
0x3d80000004247820ULL, 0x000fe20000410000ULL, 0x3d80000005257820ULL, 0x000fe20000410000ULL,
0x3d800000060c7820ULL, 0x000fe20000410000ULL, 0x3d80000007097820ULL, 0x000fe20000410000ULL,
0x0000001000fc8947ULL, 0x002fec0003800000ULL, 0x00003c0001267983ULL, 0x000ea20000300800ULL,
0xffffffff040a7890ULL, 0x000fc6000fffe03fULL, 0x01c4000708047984ULL, 0x0002620008000c00ULL,
0x0000000000367919ULL, 0x000e640000000000ULL, 0x0000000a26007c0cULL, 0x004fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x0000000236027824ULL, 0x000fe200078e00ffULL,
0x800000080c087290ULL, 0x000fc8000fffe03fULL, 0x0000000602027812ULL, 0x000fc800078ec0ffULL,
0x0000000102037812ULL, 0x040fe400078efcffULL, 0x0000000802267812ULL, 0x040fe400078efcffULL,
0x0000000803007c0cULL, 0x000fe4000bf26070ULL, 0x0000001002037812ULL, 0x000fe400078efcffULL,
0x0000000826007c0cULL, 0x000fe4000bf06070ULL, 0x0000000803007c0cULL, 0x000fc4000bfc6070ULL,
0x0000001102267812ULL, 0x040fe400078efcffULL, 0x0000001802037812ULL, 0x040fe400078efcffULL,
0x0000000802007c0cULL, 0x000fe4000bf46070ULL, 0x0000000826007c0cULL, 0x000fe4000bfa6070ULL,
0x0000000803007c0cULL, 0x000fe4000bf66070ULL, 0x0000000902277812ULL, 0x000fc400078efcffULL,
0x0000001902267812ULL, 0x040fe400078efcffULL, 0x0000002002037812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff19197808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff1a1a7808ULL, 0x000fc40004800000ULL,
0x0000000827007c0cULL, 0x000fe4000bf86070ULL, 0x0000000826007c0cULL, 0x000fe4000bf46070ULL,
0x0000000803007c0cULL, 0x000fe4000bf26070ULL, 0x0000002102267812ULL, 0x040fe400078efcffULL,
0x0000002802037812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fc40004000000ULL,
0xff7fffff30307808ULL, 0x000fe40004000000ULL, 0xff7fffff33337808ULL, 0x000fe40006000000ULL,
0xff7fffff31317808ULL, 0x000fe40006000000ULL, 0x0000000826007c0cULL, 0x000fe4000bf06070ULL,
0x0000000803007c0cULL, 0x000fe4000bf86070ULL, 0x0000002902267812ULL, 0x000fc400078efcffULL,
0x0000003002037812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0x0000000826007c0cULL, 0x000fc4000bfc6070ULL,
0x0000000803007c0cULL, 0x000fe4000bfa6070ULL, 0x0000003102267812ULL, 0x040fe400078efcffULL,
0x0000003802037812ULL, 0x040fe400078efcffULL, 0x0000003902027812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff10107808ULL, 0x000fe40004800000ULL,
0x0000000826007c0cULL, 0x000fe4000bf66070ULL, 0x0000000803007c0cULL, 0x000fc4000bf46070ULL,
0x0000000802007c0cULL, 0x000fe4000bf26070ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40006000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006000000ULL, 0xff7fffff0f0f7808ULL, 0x000fc40007000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40007000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40006800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL, 0xff7fffff0c0c7808ULL, 0x000fc40005000000ULL,
0xff7fffff24247808ULL, 0x000fe40005000000ULL, 0xff7fffff09097808ULL, 0x000fe40004800000ULL,
0xff7fffff25257808ULL, 0x000fce0004800000ULL, 0x0000001904037209ULL, 0x000fe20007810000ULL,
0x00000012ff267e24ULL, 0x000fe2000f8e00ffULL, 0x0000001c05027209ULL, 0x000fe20007810000ULL,
0xffffffff00087882ULL, 0x000fe20000000000ULL, 0x0000001a03037209ULL, 0x000fe40007810000ULL,
0x0000001b02057209ULL, 0x000fe40007810000ULL, 0x0000003003027209ULL, 0x000fe40007810000ULL,
0x0000003205047209ULL, 0x000fc40007810000ULL, 0x0000003102037209ULL, 0x000fe40007810000ULL,
0x0000003304057209ULL, 0x000fe40007810000ULL, 0x0000002003027209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fe40007810000ULL, 0x0000002102037209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fc40007810000ULL, 0x0000001403027209ULL, 0x000fe40007810000ULL,
0x0000001605047209ULL, 0x000fe40007810000ULL, 0x0000001502037209ULL, 0x000fe40007810000ULL,
0x0000001704057209ULL, 0x000fe40007810000ULL, 0x0000001003027209ULL, 0x000fe40007810000ULL,
0x0000001205047209ULL, 0x000fc40007810000ULL, 0x0000001102027209ULL, 0x000fe40007810000ULL,
0x0000001304037209ULL, 0x000fe40007810000ULL, 0x0000001d02027209ULL, 0x000fe40007810000ULL,
0x0000000e03047209ULL, 0x000fe40007810000ULL, 0x0000000d02037209ULL, 0x000fe40007810000ULL,
0x0000000f04057209ULL, 0x000fc40007810000ULL, 0x0000001e03027209ULL, 0x000fe40007810000ULL,
0x0000000a05047209ULL, 0x000fe40007810000ULL, 0x0000001f02037209ULL, 0x000fe40007810000ULL,
0x0000000b04057209ULL, 0x000fe40007810000ULL, 0x0000002403027209ULL, 0x000fe40007810000ULL,
0x0000000c05047209ULL, 0x000fc40007810000ULL, 0x0000000626037c11ULL, 0x000fe4000f8e28ffULL,
0x0000002502057209ULL, 0x000fe40007810000ULL, 0x0000000904047209ULL, 0x000fe20007810000ULL,
0x0000000e08687947ULL, 0x000fec000b800000ULL, 0x0c401f0005027f89ULL, 0x000e6800000e0000ULL,
0x0c401f0004277f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006297f89ULL, 0x000ee800000e0000ULL,
0x0c401f00072a7f89ULL, 0x000f2200000e0000ULL, 0x0000000205267209ULL, 0x002fc40007810000ULL,
0x0000002704287209ULL, 0x004fc60007810000ULL, 0x0c201f00262b7f89ULL, 0x000e6200000e0000ULL,
0x0000002906297209ULL, 0x008fc60007810000ULL, 0x0c201f00282d7f89ULL, 0x000ea200000e0000ULL,
0x0000002a07027209ULL, 0x010fc60007810000ULL, 0x0c201f00292c7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0002277f89ULL, 0x00092200000e0000ULL, 0x0000002b26047209ULL, 0x002fe40007810000ULL,
0x0000002d28057209ULL, 0x004fe40007810000ULL, 0x0000002c29067209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b04267820ULL, 0x000fe20000410000ULL, 0x3f80000000087882ULL, 0x000fc60000000000ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b25257823ULL, 0x000fe20000010826ULL,
0x3fb8aa3b05267820ULL, 0x000fe20000410000ULL, 0x0000001900197308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010826ULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b09097823ULL, 0x000fc40000010826ULL,
0x0000001400077308ULL, 0x000ff00000000800ULL, 0x0000001000297308ULL, 0x000ff00000000800ULL,
0x0000001d002b7308ULL, 0x000ff00000000800ULL, 0x0000001f002e7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000001c001d7308ULL, 0x0003f00000000800ULL, 0x0000001b00107308ULL, 0x000ea20000000800ULL,
0x000000191a1c723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b17197823ULL, 0x000fcc0000010826ULL,
0x00000032001f7308ULL, 0x000fe20000000800ULL, 0x0000001d101d723eULL, 0x004fce00000010ffULL,
0x0000003300147308ULL, 0x000e700000000800ULL, 0x0000001500287308ULL, 0x0005e20000000800ULL,
0x0000001f141f723eULL, 0x002fce00000010ffULL, 0x0000001e002d7308ULL, 0x0003e20000000800ULL,
0x00000008ff157e24ULL, 0x004fca000f8e00ffULL, 0x3f800000151a783eULL, 0x000fe400000010ffULL,
0x0000000d002c7308ULL, 0x0005e20000000800ULL, 0x00000030311e723eULL, 0x002fe400000010ffULL,
0x0000001a001b7202ULL, 0x000fca0000000f00ULL, 0x00000011002a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b160d7823ULL, 0x104fe20000010826ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000001a1c14723cULL, 0x000fe200000418ffULL, 0x0000002200117308ULL, 0x000fec0000000800ULL,
0x3fb8aa3b131b7823ULL, 0x000fc40000010826ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x0000002300347308ULL, 0x0004e20000000800ULL,
0x000000202110723eULL, 0x002fce00000010ffULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12237823ULL, 0x104fe20000010826ULL, 0x000000072812723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b0c077823ULL, 0x000fe20000010826ULL, 0x000000292a20723eULL, 0x000fe400000010ffULL,
0x0000002d2e0c723eULL, 0x000fe400000010ffULL, 0x0000001900227308ULL, 0x000e620000000800ULL,
0x000000113411723eULL, 0x008fce00000010ffULL, 0x0000001b00307308ULL, 0x0005e20000000800ULL,
0x0000000d2213723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x000000ffff1b7224ULL, 0x004fe200078e001aULL, 0x0000002b2c22723eULL, 0x000fcc00000010ffULL,
0x0000001a1014723cULL, 0x000fe20000041814ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000233021723eULL, 0x002fce00000010ffULL, 0x0000000f000f7308ULL, 0x000e700000000800ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x0000000e0f23723eULL, 0x002fce00000010ffULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x0000001a2028723cULL, 0x000fee0000041814ULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x00000024250e723eULL, 0x002fce00000010ffULL,
0x0000000b000b7308ULL, 0x000e700000000800ULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x0000000a0b0d723eULL, 0x002fce00000010ffULL, 0x0000000900147308ULL, 0x000e620000000800ULL,
0x0000000fff0a7424ULL, 0x000fe200078e00ffULL, 0x00000007140f723eULL, 0x002fe400000010ffULL,
0xfffffffc36077812ULL, 0x000fc800078ec0ffULL, 0x000000070a0b7219ULL, 0x000fe200000006ffULL,
0x0000001a0c28723cULL, 0x000fe20000041828ULL, 0x0000002702077209ULL, 0x010fde0007810000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x001c1fff28147589ULL, 0x00026200000e0000ULL,
0x0000000000167806ULL, 0x000fe200038e0100ULL, 0x000000000b0a73a1ULL, 0x000eb000000e8000ULL,
0x000000000b0873c4ULL, 0x000ee20000004000ULL, 0x00000000000a7886ULL, 0x000fc400038e0100ULL,
0x0000000a0bff7c12ULL, 0x004fda000f80400aULL, 0x0000000a08708947ULL, 0x00afea000b800000ULL,
0x001c1fff2a157589ULL, 0x0002a800000e0000ULL, 0x001c1fff16167589ULL, 0x000ee800000e0000ULL,
0x001c1fff00177589ULL, 0x00032400000e0000ULL, 0xfffffff8ff5b7812ULL, 0x000fe200078ee25bULL,
0x0000000612087291ULL, 0x000fe2000f8e583fULL, 0x00000003000b7812ULL, 0x002fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200078e001cULL, 0x000000035b007819ULL, 0x040fe200000006ffULL,
0x000000085b027836ULL, 0x000fe20000000000ULL, 0x000000040b197812ULL, 0x000fe200078efcffULL,
0x00000008ff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x000000070b097812ULL, 0x000fe200078e785bULL,
0x000000ffff257224ULL, 0x000fe200078e001eULL, 0x00000007195b7812ULL, 0x000fe200078e785bULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x000000070b0b7812ULL, 0x000fe200078e7802ULL,
0x000000ffff1c7224ULL, 0x000fe200078e001dULL, 0x0000000719197812ULL, 0x000fe200078e7802ULL,
0x0000000802027824ULL, 0x000fe200078e00ffULL, 0x0000000009097212ULL, 0x080fe200078efcffULL,
0x000000ffff287224ULL, 0x000fe200078e0020ULL, 0x000120000a0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200078e0022ULL, 0x000000005b5b7212ULL, 0x000fe200078efcffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000000020b0b7212ULL, 0x080fe200078efcffULL,
0x0000001009097824ULL, 0x100fe200078e020aULL, 0x0000000219197212ULL, 0x000fe200078efcffULL,
0x000000105b5b7824ULL, 0x100fe200078e020aULL, 0x0000001200277202ULL, 0x000fe20000000f00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e001fULL, 0x0000000336ff7812ULL, 0x000fe2000780c0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e020aULL, 0x0000000e002b7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0011ULL, 0x00000013001f7202ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe200078e0021ULL, 0x0000000a19197211ULL, 0x000fe200078e20ffULL,
0x000000ffff117224ULL, 0x000fe200078e0023ULL, 0x0000000f00137202ULL, 0x000fe20000000f00ULL,
0x000000ffff127224ULL, 0x000fe200078e000dULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000002409007844ULL, 0x0003e20000000200ULL, 0x00000009ff007e24ULL, 0x000fc6000f8e00ffULL,
0x000000285b007844ULL, 0x0003e80000000200ULL, 0x0000001c0b007844ULL, 0x0003e80000000200ULL,
0x0000001019007844ULL, 0x0003e20000000200ULL, 0x000000040900728cULL, 0x000fc6000bf06070ULL,
0x00003c0001007387ULL, 0x0003e80000100800ULL, 0x01c0000408008988ULL, 0x0003e80008000c07ULL,
0x01c2001408008988ULL, 0x01c3e20008000c07ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x01c6081803ff79a7ULL, 0x0003e2000850003fULL, 0x01c6101803ff79a7ULL, 0x0003e2000850003fULL,
0x01c6181803ff79a7ULL, 0x0003e2000850003fULL, 0x01c6201803ff79a7ULL, 0x0003f2000850003fULL,
0xffffff9c00c88947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000a000b7c02ULL, 0x000fc80008000f00ULL, 0x01c608130b0075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x01c608130b0095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff0400847947ULL, 0x000fea000383ffffULL, 0x0000000aff0b7e24ULL, 0x000fc8000f8e00ffULL,
0x01c628110b0075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01c628110b0095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff1c00a47947ULL, 0x000fea000383ffffULL,
0x0000000aff0b7e24ULL, 0x000fc8000f8e00ffULL, 0x01c648110b0075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x01c648110b0095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff3000a87947ULL, 0x000fea000383ffffULL, 0x0000000a000b7c02ULL, 0x000fc80008000f00ULL,
0x01c668110b0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c668110b0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffff4400ac7947ULL, 0x000fea000383ffffULL,
0x01c60003ff0075a7ULL, 0x0006e20008000146ULL, 0x0000b0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c60003ff0085a7ULL, 0x000e640008000046ULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff9c00387947ULL, 0x006fea000383ffffULL,
0x0000000aff057e24ULL, 0x000fc8000f8e00ffULL, 0x01c68803050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c68803050085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffe800e87947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x0000000500357202ULL, 0x000fe20000000f00ULL, 0x00000002ff347424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff2e7424ULL, 0x000fce00078e00ffULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x0c000034352f7389ULL, 0x0006e40000000037ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff357224ULL, 0x002fe200078e0004ULL, 0xffffffff002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff347424ULL, 0x000fe200078e00ffULL, 0x0000002f00027202ULL, 0x004fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc600078e00ffULL, 0x0000000205267209ULL, 0x000fce0007810000ULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x0c000034352f7389ULL, 0x0002640000000037ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000ffff357224ULL, 0x000fe400078e0006ULL,
0x000000ffff277224ULL, 0x000fce00078e002fULL, 0x000000002e087348ULL, 0x000fea0003c00000ULL,
0x0c000034352f7389ULL, 0x0002640000000037ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002704287209ULL, 0x000fe40007810000ULL, 0x0000000700357202ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fce00078e002fULL, 0x000000002e087348ULL, 0x000fea0003c00000ULL,
0x0c000034352f7389ULL, 0x0002640000000037ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002906297209ULL, 0x000fe20007810000ULL, 0x000000ffff357224ULL, 0x000fe400078e0026ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff2a7224ULL, 0x000fce00078e002fULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x0c000034352f7389ULL, 0x0002640000000037ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002a07027209ULL, 0x000fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe200078e0028ULL, 0x0000002f002b7202ULL, 0x000fce0000000f00ULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x0c000034352f7389ULL, 0x0002640000000037ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002b26047209ULL, 0x000fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe400078e0029ULL, 0x000000ffff2d7224ULL, 0x000fce00078e002fULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x0c000034352f7389ULL, 0x0002640000000037ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002d28057209ULL, 0x000fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe200078e0002ULL, 0x0000002f002c7202ULL, 0x000fce0000000f00ULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x0c000034352f7389ULL, 0x0002640000000037ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002c29067209ULL, 0x000fe20007810000ULL,
0x000000ffff277224ULL, 0x000fe200078e002fULL, 0xffffffec00f07947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x00001c1f00097802ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x000fce00078e000bULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x000000172a177389ULL, 0x0006e40000000009ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff157224ULL, 0x004fe200078e0017ULL,
0x000000ff00177202ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x002fe400078e0016ULL,
0x00001c1fff097424ULL, 0x000fe400078e00ffULL, 0x000000ffff2e7224ULL, 0x000fce00078e000bULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x000000172a177389ULL, 0x0006e40000000009ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x004fe200078e0017ULL,
0x00000000002a7202ULL, 0x002fe20000000f00ULL, 0x000000ffff177224ULL, 0x000fe400078e00ffULL,
0x00001c1fff097424ULL, 0x000fe400078e00ffULL, 0x000000ffff2e7224ULL, 0x000fce00078e000bULL,
0x000000002e087348ULL, 0x000fea0003c00000ULL, 0x000000172a177389ULL, 0x0006e40000000009ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff400287947ULL, 0x006fea000383ffffULL, 0x0180000054007836ULL, 0x000fe20000000000ULL,
0x0000016000007945ULL, 0x000fe80003800000ULL, 0x7f80000000037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000005400008308ULL, 0x0002a20000001000ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x008000000300780cULL, 0x040fe40003f22070ULL,
0x000000ff0300720cULL, 0x000fe40003f05070ULL, 0xffffffffff007807ULL, 0x004fe40004800000ULL,
0x00000001ff037807ULL, 0x000fc60000000000ULL, 0x000000ffff007224ULL, 0x000fca00078e0a00ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000000000248947ULL, 0x000fea0003800000ULL,
0x007fffff54007812ULL, 0x000fc800078ec0ffULL, 0x000000ff0000720cULL, 0x000fc80003f02070ULL,
0xffffffffff007807ULL, 0x000fc80004000000ULL, 0x000000ff00007210ULL, 0x000fc80007ffe1ffULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000054037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005400007308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffed802cc7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL, 0x0000000e00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000658ULL, 0x0000000000000558ULL, 0x0000000d00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000bb0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000bd0ULL, 0x0000000000000000ULL, 0x0000000d00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000bd0ULL, 0x0000000000000030ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c00ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c48ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c50ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000c80ULL, 0x0000000000012580ULL, 0x0000000e00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013200ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000013210ULL, 0x0000000000000400ULL, 0x0000000d00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000013210ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000013210ULL, 0x0000000000000260ULL, 0x0000000d00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000138f0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000138f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000c48ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000c80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000012580ULL,
0x0000000000012580ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000013200ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL, 0x0000000000000414ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000013210ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_8_m_8_sm_90_cubin_len = 80448;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
