/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015270ULL, 0x0000000000014df0ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000013d30ULL, 0x0000000000000250ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000013f80ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00013d3000000000ULL, 0x0000100400000000ULL, 0x01a8288080810c00ULL, 0x00000000004f3004ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8016288080850828ULL, 0x0000000310288082ULL,
0x8085920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL,
0x00013d3000000000ULL, 0x0000025000000000ULL, 0x00002c0400000000ULL, 0x8082288080820900ULL,
0x090000003c042880ULL, 0x2880808228808085ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000a80000000bULL, 0x0000000b00081104ULL, 0x00081204000000a8ULL, 0x000000a80000000eULL,
0x0000000e00081104ULL, 0x00081204000000a8ULL, 0x000000a80000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x0000a2b000183104ULL, 0x000131100000a8b0ULL, 0x0001313000013120ULL,
0x0104290400013140ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001c05000003ULL, 0x050000030500001cULL, 0x0500000305000003ULL,
0x0500002f0500002fULL, 0x0500002f0500002fULL, 0x0500002f0500002fULL, 0x0500002f0500002fULL,
0x0500002f0500002fULL, 0x010428040500002fULL, 0x000000c0000000a0ULL, 0x0000371000002070ULL,
0x00003800000037a0ULL, 0x00003be000003830ULL, 0x000043a000003cf0ULL, 0x0000519000005100ULL,
0x00005220000051f0ULL, 0x0000563000005520ULL, 0x000067a000005b10ULL, 0x0000689000006840ULL,
0x00006c00000068c0ULL, 0x0000717000006c80ULL, 0x00007f0000007e60ULL, 0x00007f8000007f50ULL,
0x000082f0000082e0ULL, 0x0000897000008960ULL, 0x0000a2b000008e50ULL, 0x0000ad800000a8b0ULL,
0x0000b2c00000adc0ULL, 0x0000b7500000b2e0ULL, 0x000129f0000129e0ULL, 0x00012a1000012a00ULL,
0x00012a6000012a40ULL, 0x00012a9000012a80ULL, 0x0001312000013100ULL, 0x0001317000013130ULL,
0x0001319000013180ULL, 0x000138c000013830ULL, 0x0001398000013920ULL, 0x00013a50000139f0ULL,
0x00013b1000013ab0ULL, 0x00013c5000013bb0ULL, 0x0160390400013cf0ULL, 0x000000ff00000190ULL,
0x0004010000024600ULL, 0x0000000200000280ULL, 0x003f010000024608ULL, 0x00000002000002f0ULL,
0x003f010000024610ULL, 0x000000ff00000800ULL, 0x0004010700024600ULL, 0x000000ff00000910ULL,
0x0004010100024610ULL, 0x000000ff00003660ULL, 0x0006010a00024608ULL, 0x000000ff00004290ULL,
0x0006010100024610ULL, 0x000000ff00005080ULL, 0x0006010a00024618ULL, 0x000000ff00005aa0ULL,
0x0006010100024620ULL, 0x000000ff00006730ULL, 0x0006010a00024628ULL, 0x000000ff00007060ULL,
0x0006010100024630ULL, 0x000000ff00007df0ULL, 0x0006010a00024638ULL, 0x000000ff000085f0ULL,
0x0006010100024640ULL, 0x000000ff0000d350ULL, 0x000b010a00024600ULL, 0x000000ff00012020ULL,
0x0012010a00024610ULL, 0x000000ff00013490ULL, 0x0012010100024608ULL, 0x000000ff00013510ULL,
0x0006010a00024608ULL, 0x000000ff00013590ULL, 0x0006010a00024618ULL, 0x000000ff00013610ULL,
0x0006010a00024628ULL, 0x000000ff00013690ULL, 0x0006010a00024638ULL, 0x000000ff000136f0ULL,
0x000b010a00024600ULL, 0x000000ff00013770ULL, 0x0012010a00024610ULL, 0x00101c0400033803ULL,
0x0000d3800000bbc0ULL, 0x000134e00000d410ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x00080a0400501903ULL, 0x005002100000000fULL, 0x0000000800043604ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000000ULL, 0x00000000000000ccULL, 0x0000000e00000002ULL,
0x0000000000013d30ULL, 0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL,
0x00000000000000a5ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000004043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000057919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0xffffff5801017836ULL, 0x002fe20000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000000000c7919ULL, 0x000e620000002300ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000779c3ULL, 0x000f300000002700ULL,
0x00000000000879c3ULL, 0x000f220000002600ULL, 0x00000005ff027819ULL, 0x004fcc0000011605ULL,
0x00001fff02027589ULL, 0x000ea200000e0000ULL, 0x000000010c007824ULL, 0x002fc600078e0203ULL,
0x00001fff0c0c7589ULL, 0x000f2200000e0000ULL, 0x0000008000007824ULL, 0x000fca00078e0205ULL,
0x000000ff0000720cULL, 0x040fe40003f05270ULL, 0x000000030000780cULL, 0x000fe40003f24070ULL,
0x00000000020e72caULL, 0x004fe200000e0000ULL, 0x00000004ff027e24ULL, 0x008fca000f8e00ffULL,
0x0000400201007387ULL, 0x0005e60000100800ULL, 0x0000000000240947ULL, 0x010fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff00000a7882ULL, 0x000fe20000000000ULL, 0x7ffc0000000b7882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x0246000a043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300000f7ab9ULL, 0x000fe20000000800ULL, 0x000001a000007945ULL, 0x000fe80003800000ULL,
0x0000000000601947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7fff000000057882ULL, 0x000fc60000000000ULL,
0x0000000400027c11ULL, 0x004fe2000f8e20ffULL, 0x001fffc000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x02460804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001fff0000047882ULL, 0x002fe20000000000ULL,
0x7ffc000000057882ULL, 0x000fd60000000000ULL, 0x00000000020612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x02461004063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000007f0000780cULL, 0x000fe20003f04070ULL, 0x00008c0000047ab9ULL, 0x002fe20000000a00ULL,
0x000000ff0c00720cULL, 0x000fe20003f25270ULL, 0x00000004070478a5ULL, 0x000fe2000f8e0004ULL,
0x00008200000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000840000097ab9ULL, 0x000fc80000000800ULL,
0x00000004000a7c02ULL, 0x000fe20008000f00ULL, 0x00000005ff0b7e24ULL, 0x000fc6000f8e00ffULL,
0x0000000000038919ULL, 0x000e620000008800ULL, 0x0000040000028802ULL, 0x004fc80000000f00ULL,
0x0000065403058816ULL, 0x002fe20000000002ULL, 0xff317217ff038424ULL, 0x000fc800078e00ffULL,
0x0000000400008824ULL, 0x000fca00078e0205ULL, 0x0244000300008388ULL, 0x0003e20000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000e81947ULL, 0x002fea0003800000ULL,
0x0000000000107919ULL, 0x000e620000000000ULL, 0x000000020e067899ULL, 0x000fe2000800063fULL,
0x00008800ff087b82ULL, 0x000ea20000000a00ULL, 0x0000000409047899ULL, 0x000fe4000800063fULL,
0x0000000408057899ULL, 0x000fc8000800063fULL, 0x00000007040472a4ULL, 0x000fe2000f8e0205ULL,
0x0000000610007c11ULL, 0x042fe4000f8fd8ffULL, 0x00000000000679c3ULL, 0x000e620000008800ULL,
0x0000001010027824ULL, 0x000fe200078e00ffULL, 0x0000000700037812ULL, 0x040fe200078ec0ffULL,
0x0000000100047836ULL, 0x040fe40000000000ULL, 0x0000000200067836ULL, 0x040fe20000000000ULL,
0x0000001f03037812ULL, 0x000fe200078e7810ULL, 0x00000003000f7836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc400078ec0ffULL, 0x0000000706077812ULL, 0x000fe400078ec0ffULL,
0x000000070f0d7812ULL, 0x000fe400078ec0ffULL, 0x0000001f05057812ULL, 0x000fe400078e7810ULL,
0x0000001f07077812ULL, 0x000fe400078e7810ULL, 0x0000001f0d107812ULL, 0x000fe200078e7810ULL,
0x00000020000d7824ULL, 0x000fe200078e0203ULL, 0x0000000400037c10ULL, 0x000fe2000fffe0ffULL,
0x0000002004007824ULL, 0x000fe200078e0205ULL, 0x000001f002117812ULL, 0x000fe200078ec0ffULL,
0x0000000404057c36ULL, 0x000fc40008000000ULL, 0x0000020003027825ULL, 0x004fc800078e0008ULL,
0x00000020060e7824ULL, 0x040fe200078e0207ULL, 0x0000001102027210ULL, 0x000fe20007f1e0ffULL,
0x000000200f107824ULL, 0x000fe200078e0210ULL, 0x000000040f0f7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000406077c36ULL, 0x000fe20008000000ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x0000020005047825ULL, 0x000fe200078e0008ULL, 0x0000065406047896ULL, 0x002fc60008000004ULL,
0x0000020007067825ULL, 0x100fe200078e0008ULL, 0x0000001104047210ULL, 0x000fe40007f3e0ffULL,
0x000000040d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000002000f087825ULL, 0x000fe200078e0008ULL,
0x00000004000f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000410137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001106067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x0000001108087210ULL, 0x000fc40007f5e0ffULL,
0x000000040e117c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000b901c4cULL,
0x000000ffff097224ULL, 0x000fc600010e0609ULL, 0x00000000040f7faeULL, 0x0003e8000b901c4cULL,
0x0000000006117faeULL, 0x0003e8000b901c4cULL, 0x0000000008137faeULL, 0x0003e2000b901c4cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0002460004047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x0000000c0a0a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0c00720cULL, 0x000fe40003f05270ULL,
0x000000000a1472caULL, 0x004fda00000e0000ULL, 0x000000ff14057890ULL, 0x000fc8000fffe03fULL,
0x000000083f057899ULL, 0x000fe20008011605ULL, 0x000000b000cc8947ULL, 0x000ff60003800000ULL,
0x0000400001307983ULL, 0x000ea20000100800ULL, 0x00000000000479c3ULL, 0x000e620000008800ULL,
0x0000040000067882ULL, 0x000fe20000000000ULL, 0x00000004ff007424ULL, 0x000fe200078e00ffULL,
0x0000000107077899ULL, 0x000fe4000800063fULL, 0x0000065404067896ULL, 0x002fc80008000006ULL,
0x000000060e047291ULL, 0x000fd2000f8e203fULL, 0x02461000ffff79a7ULL, 0x0003e20008500004ULL,
0x0000000908047290ULL, 0x000fc8000fffe03fULL, 0x00000009070772a4ULL, 0x000fc6000f8e0204ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x00000000300a72caULL, 0x004fe400000e0000ULL,
0x0000000130007810ULL, 0x002fc80007ffe0ffULL, 0x0000000500007c0cULL, 0x000fce000bf06070ULL,
0x000000080a087899ULL, 0x000fc8000800063fULL, 0x00000004070972a4ULL, 0x000fe4000f8e0208ULL,
0x0000000800c08947ULL, 0x000ff40003800000ULL, 0x00000000006a7919ULL, 0x000e620000000000ULL,
0x000000081400728cULL, 0x000fe4000bf01070ULL, 0x80000008ff077e24ULL, 0x000fe4000f8e02ffULL,
0x0000000814047287ULL, 0x000fe4000c000000ULL, 0x000000030e087899ULL, 0x000fc8000800063fULL,
0x00000004ff007e24ULL, 0x000fe2000f8e00ffULL, 0x000000060e047291ULL, 0x000fc8000f8e703fULL,
0x0000004000077446ULL, 0x000fe20003800007ULL, 0x0001400004047890ULL, 0x000fe2000fffe03fULL,
0x00000003ff127819ULL, 0x002fe4000001166aULL, 0x0ffffff86a037812ULL, 0x000fe400078ec0ffULL,
0x0000006a12007212ULL, 0x0c0fe200078e3cffULL, 0x0000000412087836ULL, 0x040fe20000000000ULL,
0x0000001c121f7810ULL, 0x000fe20007ffe0ffULL, 0x00000014121a7836ULL, 0x040fe20000000000ULL,
0x00000007030a7812ULL, 0x000fe200078ef800ULL, 0x00000018121d7836ULL, 0x000fe20000000000ULL,
0x0000006a08027212ULL, 0x080fe200078e3cffULL, 0x0000000c120e7836ULL, 0x000fe20000000000ULL,
0x0000000308097819ULL, 0x000fe200000006ffULL, 0x000000081d1e7824ULL, 0x040fe200078e00ffULL,
0x0000006a1d037212ULL, 0x080fe200078e3cffULL, 0x00000008120c7836ULL, 0x000fe20000000000ULL,
0xfffffff809107812ULL, 0x000fe200078ee202ULL, 0x000000081a097824ULL, 0x040fe200078e00ffULL,
0x0000006a1a027212ULL, 0x080fe200078e3cffULL, 0x000000080e147824ULL, 0x040fe200078e00ffULL,
0x0000006a0e057212ULL, 0x080fe200078e3cffULL, 0x0000001012167836ULL, 0x000fe20000000000ULL,
0xfffffff8091c7812ULL, 0x000fe200078ee202ULL, 0x000000080c117824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x0000002012217836ULL, 0x000fe20000000000ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x0000006a0c047212ULL, 0x080fe200078e3cffULL,
0x000000081f0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x0000000816057824ULL, 0x000fe200078e00ffULL, 0x0000002412237810ULL, 0x000fe20007ffe0ffULL,
0x0000002812247836ULL, 0x000fe20000000000ULL, 0x0000006a16007212ULL, 0x080fe200078e3cffULL,
0x0000002c12267836ULL, 0x000fe20000000000ULL, 0xfffffff811117812ULL, 0x000fe200078ee204ULL,
0x0000000823097824ULL, 0x000fe200078e00ffULL, 0x0000006a1f047212ULL, 0x080fe200078e3cffULL,
0x0000000824257824ULL, 0x000fe200078e00ffULL, 0xfffffff805187812ULL, 0x000fe200078ee200ULL,
0x0000000821057824ULL, 0x000fe200078e00ffULL, 0x0000006a23067212ULL, 0x080fe200078e3cffULL,
0x000000090c0d7c36ULL, 0x000fe20008000000ULL, 0x0000003012277810ULL, 0x000fe20007ffe0ffULL,
0x000000090e0f7c36ULL, 0x000fe20008000000ULL, 0x0000006a21007212ULL, 0x080fe200078e3cffULL,
0x0000003412287836ULL, 0x000fe20000000000ULL, 0xfffffff80b207812ULL, 0x000fe200078ee204ULL,
0x00000008ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x0000006a24047212ULL, 0x080fe200078e3cffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0xfffffff809067812ULL, 0x000fe200078ee206ULL,
0x0000000827097824ULL, 0x040fe200078e00ffULL, 0xfffffff805227812ULL, 0x000fe200078ee200ULL,
0x0000000826057824ULL, 0x000fe200078e00ffULL, 0x0000006a27007212ULL, 0x000fc400078e3cffULL,
0xfffffff825257812ULL, 0x000fe400078ee204ULL, 0x0000006a26047212ULL, 0x000fe400078e3cffULL,
0xfffffff809007812ULL, 0x000fe200078ee200ULL, 0x0000000912097c36ULL, 0x040fe20008000000ULL,
0xfffffff805047812ULL, 0x000fe400078ee204ULL, 0xfffffff80b057812ULL, 0x000fe400078ee26aULL,
0x000000071200720cULL, 0x000fc40003f06070ULL, 0x000000070800720cULL, 0x080fe40003f26070ULL,
0x00000009080b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000020009087825ULL, 0x102fe200078e0002ULL,
0x000000070c00720cULL, 0x080fe40003f46070ULL, 0x000000040a137c11ULL, 0x000fe2000f8e20ffULL,
0x000002000b0a7825ULL, 0x100fe200078e0002ULL, 0x000000070e00720cULL, 0x000fe40003f66070ULL,
0x0000000411177c11ULL, 0x000fe2000f8e20ffULL, 0x000002000d0c7825ULL, 0x000fe200078e0002ULL,
0x0000000410157c11ULL, 0x000fc4000f8e20ffULL, 0x0000006a281b7212ULL, 0x000fe200078e3cffULL,
0x0000001005087825ULL, 0x000fe200078e0008ULL, 0x0000000414197c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff82a147812ULL, 0x000fe200078ee21bULL, 0x000002000f0e7825ULL, 0x000fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c4cULL,
0x000000071600720cULL, 0x080fe40003f06070ULL, 0x00000010050a7825ULL, 0x000fe200078e000aULL,
0x000000072100720cULL, 0x000fc40003f86070ULL, 0x0000000425257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000916117c36ULL, 0x000fe20008000000ULL, 0x000000000a157faeULL, 0x0005e2000c901c4cULL,
0x00000010050c7825ULL, 0x000fe200078e000cULL, 0x000000071a00720cULL, 0x080fe40003f26070ULL,
0x0000000418137c11ULL, 0x002fe2000f8e20ffULL, 0x0000020011107825ULL, 0x000fe200078e0002ULL,
0x000000000c177faeULL, 0x0003e2000d101c4cULL, 0x000000071d00720cULL, 0x000fe40003f46070ULL,
0x00000010050e7825ULL, 0x000fe200078e000eULL, 0x000000091d1d7c10ULL, 0x000fc4000fffe0ffULL,
0x000000041c157c11ULL, 0x004fe2000f8e20ffULL, 0x000000091a1b7c36ULL, 0x000fe20008000000ULL,
0x000000000e197faeULL, 0x0005e2000d901c4cULL, 0x0000001005107825ULL, 0x000fe200078e0010ULL,
0x000000071f00720cULL, 0x080fe40003f66070ULL, 0x000000041e177c11ULL, 0x002fe2000f8e20ffULL,
0x000002001b087825ULL, 0x100fe200078e0002ULL, 0x0000000010137faeULL, 0x0003e2000c101c4cULL,
0x00000004221b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000091f0d7c36ULL, 0x000fe20008000000ULL,
0x000000072300720cULL, 0x000fe20003f06070ULL, 0x000002001d0a7825ULL, 0x000fe200078e0002ULL,
0x0000000420197c11ULL, 0x004fc6000f8e20ffULL, 0x00000009210f7c36ULL, 0x000fe40008000000ULL,
0x000002000d0c7825ULL, 0x000fc800078e0002ULL, 0x000002000f0e7825ULL, 0x000fc800078e0002ULL,
0x0000001005087825ULL, 0x000fc800078e0008ULL, 0x0000003812107836ULL, 0x042fe20000000000ULL,
0x0000000008157faeULL, 0x0003e2000c901c4cULL, 0x0000003c12127836ULL, 0x000fe20000000000ULL,
0x000000072400720cULL, 0x080fe20003f26070ULL, 0x00000010050a7825ULL, 0x040fe200078e000aULL,
0x0000000910137c10ULL, 0x000fe4000fffe0ffULL, 0x0000000312187819ULL, 0x000fe200000006ffULL,
0x00000010050c7825ULL, 0x000fe200078e000cULL, 0x000000000a177faeULL, 0x0005e2000d101c4cULL,
0x000000072600720cULL, 0x000fc40003f46070ULL, 0x00000010050e7825ULL, 0x000fe200078e000eULL,
0x0000006a10087212ULL, 0x082fe200078e3cffULL, 0x000000000c197faeULL, 0x0003e2000d901c4cULL,
0x0000006a12097212ULL, 0x000fe200078e3cffULL, 0x0000000810117824ULL, 0x000fe200078e00ffULL,
0x000000072700720cULL, 0x080fe20003f66070ULL, 0x000000000e1b7faeULL, 0x0007e2000e101c4cULL,
0xfffffff818187812ULL, 0x000fe200078ee209ULL, 0x0000000923097c36ULL, 0x000fe20008000000ULL,
0xfffffff811167812ULL, 0x000fe200078ee208ULL, 0x00000009240b7c36ULL, 0x004fe20008000000ULL,
0x000000072800720cULL, 0x0c0fe20003f86070ULL, 0x0000000928117c36ULL, 0x000fe20008000000ULL,
0x000000071000720cULL, 0x080fe20003fa6070ULL, 0x00000009260d7c36ULL, 0x002fe20008000000ULL,
0x000000071200720cULL, 0x040fe20003fc6070ULL, 0x0000000912077c36ULL, 0x000fe20008000000ULL,
0x0000000400157c11ULL, 0x000fe2000f8e20ffULL, 0x00000009270f7c36ULL, 0x008fe20008000000ULL,
0x0000000414177c11ULL, 0x000fe2000f8e20ffULL, 0x0000020009087825ULL, 0x000fe200078e0002ULL,
0x0000000416197c11ULL, 0x000fc4000f8e20ffULL, 0x00000004181b7c11ULL, 0x000fe2000f8e20ffULL,
0x000002000b0a7825ULL, 0x000fc800078e0002ULL, 0x000002000d0c7825ULL, 0x000fc800078e0002ULL,
0x000002000f0e7825ULL, 0x000fc800078e0002ULL, 0x0000020011107825ULL, 0x000fc800078e0002ULL,
0x0000020013127825ULL, 0x000fc800078e0002ULL, 0x0000020007027825ULL, 0x000fe200078e0002ULL,
0x0000000406077c11ULL, 0x000fc6000f8e20ffULL, 0x0000001005087825ULL, 0x000fc800078e0008ULL,
0x00000010050a7825ULL, 0x040fe200078e000aULL, 0x0000000008077faeULL, 0x0003e6000c101c4cULL,
0x00000010050c7825ULL, 0x040fe200078e000cULL, 0x000000000a257faeULL, 0x0003e6000c901c4cULL,
0x00000010050e7825ULL, 0x000fc800078e000eULL, 0x0000001005107825ULL, 0x000fc800078e0010ULL,
0x0000001005127825ULL, 0x000fc800078e0012ULL, 0x0000001005027825ULL, 0x000fe200078e0002ULL,
0x0000000404057c11ULL, 0x000fca000f8e20ffULL, 0x000000000c057faeULL, 0x0003e8000d101c4cULL,
0x000000000e157faeULL, 0x0003e8000d901c4cULL, 0x0000000010177faeULL, 0x0003e8000e101c4cULL,
0x0000000012197faeULL, 0x0003e8000e901c4cULL, 0x00000000021b7faeULL, 0x0003e2000f101c4cULL,
0x0000000800687947ULL, 0x000fea0003800000ULL, 0x00000000006a7919ULL, 0x000e620000000000ULL,
0x000000030e087899ULL, 0x000fe4000800063fULL, 0x000000060e047291ULL, 0x000fc8000f8e703fULL,
0x00000008ff377e24ULL, 0x000fe2000f8e00ffULL, 0x0001400004047890ULL, 0x000fe2000fffe03fULL,
0x00000003ff137819ULL, 0x002fe4000001166aULL, 0x0ffffff86a037812ULL, 0x000fe400078ec0ffULL,
0x0000006a13007212ULL, 0x0c0fe200078e3cffULL, 0x0000000813177836ULL, 0x040fe20000000000ULL,
0x00000010131b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000413157836ULL, 0x040fe20000000000ULL,
0x0000000703147812ULL, 0x000fe200078ef800ULL, 0x00000014131d7836ULL, 0x000fe20000000000ULL,
0x0000006a17067212ULL, 0x0c0fe200078e3cffULL, 0x0000000817037824ULL, 0x000fe200078e00ffULL,
0x0000006a15077212ULL, 0x0c0fe200078e3cffULL, 0x0000000815027824ULL, 0x000fe200078e00ffULL,
0x0000006a1d0c7212ULL, 0x0c0fe200078e3cffULL, 0x000000081d097824ULL, 0x000fe200078e00ffULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x0000001c13217836ULL, 0x040fe20000000000ULL,
0xfffffff802077812ULL, 0x000fe200078ee207ULL, 0x0000002013237836ULL, 0x000fe20000000000ULL,
0xfffffff8090c7812ULL, 0x000fe200078ee20cULL, 0x0000000821037824ULL, 0x040fe200078e00ffULL,
0x0000006a210a7212ULL, 0x080fe200078e3cffULL, 0x0000002c13297836ULL, 0x000fe20000000000ULL,
0x0000006a23097212ULL, 0x080fe200078e3cffULL, 0x00000030132b7836ULL, 0x000fe20000000000ULL,
0x0000000323027819ULL, 0x000fe200000006ffULL, 0x0000000c13197836ULL, 0x000fe20000000000ULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x0000000829037824ULL, 0x000fe200078e00ffULL,
0xfffffff802097812ULL, 0x000fe200078ee209ULL, 0x000000082b027824ULL, 0x000fe200078e00ffULL,
0x0000006a29107212ULL, 0x080fe200078e3cffULL, 0x0000000819057824ULL, 0x000fe200078e00ffULL,
0x0000006a2b117212ULL, 0x080fe200078e3cffULL, 0x000000081b007824ULL, 0x000fe200078e00ffULL,
0xfffffff803107812ULL, 0x000fe200078ee210ULL, 0x0000002413257836ULL, 0x040fe20000000000ULL,
0xfffffff802117812ULL, 0x000fe200078ee211ULL, 0x0000002813277836ULL, 0x000fe20000000000ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x0000006a190e7212ULL, 0x080fe200078e3cffULL,
0x00000034132d7836ULL, 0x000fe20000000000ULL, 0x0000006a1b0d7212ULL, 0x080fe200078e3cffULL,
0x00000038132f7836ULL, 0x000fe20000000000ULL, 0x00000018131f7810ULL, 0x000fe20007ffe0ffULL,
0x000000082d047824ULL, 0x000fe200078e00ffULL, 0xfffffff8050e7812ULL, 0x000fe200078ee20eULL,
0x0000000825057824ULL, 0x000fe200078e00ffULL, 0xfffffff8000d7812ULL, 0x000fe200078ee20dULL,
0x000000081f007824ULL, 0x040fe200078e00ffULL, 0x0000006a1f0b7212ULL, 0x080fe200078e3cffULL,
0x0000003c13337836ULL, 0x000fe20000000000ULL, 0x0000006a25087212ULL, 0x080fe200078e3cffULL,
0x0000000913137c36ULL, 0x000fe20008000000ULL, 0xfffffff8000b7812ULL, 0x000fe200078ee20bULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0xfffffff805087812ULL, 0x000fe200078ee208ULL,
0x0000000915157c36ULL, 0x000fe20008000000ULL, 0x0000006a270f7212ULL, 0x080fe200078e3cffULL,
0x0000000917177c36ULL, 0x000fe20008000000ULL, 0x0000000327007819ULL, 0x000fe200000006ffULL,
0x000000091b1b7c36ULL, 0x000fe20008000000ULL, 0x0000006a2d057212ULL, 0x000fe200078e3cffULL,
0x0000020013127825ULL, 0x002fe200078e0002ULL, 0xfffffff8000f7812ULL, 0x000fc400078ee20fULL,
0xfffffff804057812ULL, 0x000fe200078ee205ULL, 0x000000091d1d7c36ULL, 0x000fe20008000000ULL,
0x0000006a2f047212ULL, 0x080fe200078e3cffULL, 0x000000091f1f7c36ULL, 0x000fe20008000000ULL,
0x000000032f317819ULL, 0x000fe200000006ffULL, 0x0000000921217c36ULL, 0x000fe20008000000ULL,
0x0000006a33007212ULL, 0x000fe200078e3cffULL, 0x0000000923237c36ULL, 0x000fe20008000000ULL,
0xfffffff831047812ULL, 0x000fe200078ee204ULL, 0x0000000927277c36ULL, 0x000fe20008000000ULL,
0xfffffff835007812ULL, 0x000fe200078ee200ULL, 0x0000000929297c36ULL, 0x000fe20008000000ULL,
0x0000000919197c10ULL, 0x000fe2000fffe0ffULL, 0x000000092b2b7c36ULL, 0x000fe20008000000ULL,
0x0000000925257c10ULL, 0x000fe2000fffe0ffULL, 0x000000092d2d7c36ULL, 0x000fe20008000000ULL,
0xfffffff837317812ULL, 0x000fe200078ee26aULL, 0x000000092f2f7c36ULL, 0x000fe20008000000ULL,
0x0000000933357c10ULL, 0x000fe2000fffe0ffULL, 0x0000020017167825ULL, 0x000fe200078e0002ULL,
0x0000000414337c11ULL, 0x000fc4000f8e20ffULL, 0x0000000407077c11ULL, 0x000fe2000f8e20ffULL,
0x0000020015147825ULL, 0x100fe200078e0002ULL, 0x000000040d0d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000040b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020019187825ULL, 0x100fe200078e0002ULL,
0x0000000409097c11ULL, 0x000fe4000f8e20ffULL, 0x0000000408377c11ULL, 0x000fe2000f8e20ffULL,
0x000002001b1a7825ULL, 0x000fe200078e0002ULL, 0x000000040f0f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000411117c11ULL, 0x000fe2000f8e20ffULL, 0x000002001d1c7825ULL, 0x000fe200078e0002ULL,
0x0000000405057c11ULL, 0x000fc6000f8e20ffULL, 0x000002001f1e7825ULL, 0x000fc800078e0002ULL,
0x0000020021207825ULL, 0x000fc800078e0002ULL, 0x0000020023227825ULL, 0x000fc800078e0002ULL,
0x0000020025247825ULL, 0x000fc800078e0002ULL, 0x0000020027267825ULL, 0x000fc800078e0002ULL,
0x0000020029287825ULL, 0x000fc800078e0002ULL, 0x000002002b2a7825ULL, 0x000fc800078e0002ULL,
0x000002002d2c7825ULL, 0x000fc800078e0002ULL, 0x000002002f2e7825ULL, 0x000fc800078e0002ULL,
0x0000001031127825ULL, 0x000fc800078e0012ULL, 0x0000020035027825ULL, 0x000fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012337faeULL, 0x0003e2000b901c4cULL,
0x000000040a357c11ULL, 0x000fe4000f8e20ffULL, 0x0000001031147825ULL, 0x000fc800078e0014ULL,
0x0000001031167825ULL, 0x040fe200078e0016ULL, 0x0000000014077faeULL, 0x0005e6000b901c4cULL,
0x0000001031187825ULL, 0x040fe200078e0018ULL, 0x0000000406137c11ULL, 0x002fe4000f8e20ffULL,
0x000000040c337c11ULL, 0x000fe2000f8e20ffULL, 0x00000010311a7825ULL, 0x040fe400078e001aULL,
0x0000000016137faeULL, 0x0003e4000b901c4cULL, 0x00000010311c7825ULL, 0x000fe200078e001cULL,
0x0000000410077c11ULL, 0x004fc6000f8e20ffULL, 0x00000010311e7825ULL, 0x000fc800078e001eULL,
0x0000001031207825ULL, 0x000fe200078e0020ULL, 0x0000000400137c11ULL, 0x002fc6000f8e20ffULL,
0x0000001031227825ULL, 0x000fc800078e0022ULL, 0x0000001031247825ULL, 0x000fc800078e0024ULL,
0x0000001031267825ULL, 0x000fc800078e0026ULL, 0x0000001031287825ULL, 0x000fc800078e0028ULL,
0x00000010312a7825ULL, 0x000fc800078e002aULL, 0x00000010312c7825ULL, 0x000fc800078e002cULL,
0x00000010312e7825ULL, 0x000fc800078e002eULL, 0x0000001031027825ULL, 0x000fe200078e0002ULL,
0x000000040e317c11ULL, 0x000fca000f8e20ffULL, 0x0000000018317faeULL, 0x000fe8000b901c4cULL,
0x000000001a0d7faeULL, 0x0005e8000b901c4cULL, 0x000000001c337faeULL, 0x0003e8000b901c4cULL,
0x000000001e0b7faeULL, 0x0003e8000b901c4cULL, 0x0000000020357faeULL, 0x0003e2000b901c4cULL,
0x00000004040d7c11ULL, 0x004fc6000f8e20ffULL, 0x0000000022097faeULL, 0x0003e8000b901c4cULL,
0x0000000024377faeULL, 0x0003e8000b901c4cULL, 0x00000000260f7faeULL, 0x0003e8000b901c4cULL,
0x0000000028077faeULL, 0x0003e8000b901c4cULL, 0x000000002a117faeULL, 0x0003e8000b901c4cULL,
0x000000002c057faeULL, 0x0003e8000b901c4cULL, 0x000000002e0d7faeULL, 0x0003e8000b901c4cULL,
0x0000000002137faeULL, 0x0003e4000b901c4cULL, 0x0000000530007c0cULL, 0x000fe2000bf06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff007424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x002fe2000001ff00ULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000006800080947ULL, 0x000fec0003800000ULL,
0x00007610ff027816ULL, 0x000fe20000000002ULL, 0xff317217ff007424ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff2f7224ULL, 0x000fe400078e00ffULL,
0x0000180201007387ULL, 0x0003ea0000100600ULL, 0x0000400001027983ULL, 0x002ea40000100800ULL,
0x00000000020b72caULL, 0x004fda00000e0000ULL, 0x000000080b0b7899ULL, 0x000fc8000800063fULL,
0x000000140b00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000006400b80947ULL, 0x000fea0003800000ULL, 0x0000000102027836ULL, 0x000fe20000000000ULL,
0x000000400b157890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000502007c0cULL, 0x000fe2000bf06070ULL, 0x00008e0000127ab9ULL, 0x000fe20000000800ULL,
0x0000000104107892ULL, 0x000fe4000f8e0c3fULL, 0x00000012070a72a4ULL, 0x000fe2000f8e0215ULL,
0x0000000400087c82ULL, 0x000fd00008000000ULL, 0x0000000800c88947ULL, 0x000fea0003800000ULL,
0x000000151400728cULL, 0x000fe2000bf01070ULL, 0x00000003ff027819ULL, 0x000fe2000001166aULL,
0x80000015ff397e24ULL, 0x000fe2000f8e02ffULL, 0x000000030e117899ULL, 0x000fe4000800063fULL,
0x0000001514097287ULL, 0x000fe2000c000000ULL, 0x0000000402447810ULL, 0x000fe20007ffe0ffULL,
0x0000000802037836ULL, 0x040fe20000000000ULL, 0x0000001002057810ULL, 0x000fe20007ffe0ffULL,
0x0000002c02497836ULL, 0x000fe20000000000ULL, 0x0000006a44677212ULL, 0x0c0fe200078e3cffULL,
0x00000009ff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000006a03667212ULL, 0x080fe200078e3cffULL,
0x0000000844067824ULL, 0x000fe200078e00ffULL, 0x0000006a05647212ULL, 0x080fe200078e3cffULL,
0x0000000803077824ULL, 0x000fe200078e00ffULL, 0x0000004004397446ULL, 0x000fe20003800039ULL,
0x0000000c02047836ULL, 0x000fe20000000000ULL, 0xfffffff806677812ULL, 0x000fe200078ee267ULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0xfffffff807667812ULL, 0x000fe200078ee266ULL,
0x0000000804067824ULL, 0x040fe200078e00ffULL, 0x0000006a04657212ULL, 0x080fe200078e3cffULL,
0x0000001802077836ULL, 0x040fe20000000000ULL, 0x0000001c02087810ULL, 0x000fe20007ffe0ffULL,
0x0000003002487836ULL, 0x040fe20000000000ULL, 0xfffffff806657812ULL, 0x000fe200078ee265ULL,
0x0000001402067836ULL, 0x000fe20000000000ULL, 0xfffffff809647812ULL, 0x000fe200078ee264ULL,
0x00000008070a7824ULL, 0x040fe200078e00ffULL, 0x0000006a07597212ULL, 0x080fe200078e3cffULL,
0x0000000806097824ULL, 0x040fe200078e00ffULL, 0x0000006a065a7212ULL, 0x080fe200078e3cffULL,
0x00000008080b7824ULL, 0x040fe200078e00ffULL, 0x0000006a08587212ULL, 0x080fe200078e3cffULL,
0x0000003802467836ULL, 0x040fe20000000000ULL, 0xfffffff80a597812ULL, 0x000fe200078ee259ULL,
0x00000024020a7836ULL, 0x040fe20000000000ULL, 0xfffffff8095a7812ULL, 0x000fe200078ee25aULL,
0x0000002002097836ULL, 0x000fe20000000000ULL, 0xfffffff80b587812ULL, 0x000fe200078ee258ULL,
0x000000080a0b7824ULL, 0x040fe200078e00ffULL, 0x0000006a0a567212ULL, 0x080fe200078e3cffULL,
0x00000008090c7824ULL, 0x040fe200078e00ffULL, 0x0000006a09577212ULL, 0x080fe200078e3cffULL,
0x000000060e137291ULL, 0x000fe2000f8e703fULL, 0x0000002802457810ULL, 0x000fe20007ffe0ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000003402477810ULL, 0x000fe20007ffe0ffULL,
0x0000001310097291ULL, 0x000fe2000f8e683fULL, 0xfffffff80b567812ULL, 0x000fe200078ee256ULL,
0x00000008490b7824ULL, 0x040fe200078e00ffULL, 0xfffffff80c577812ULL, 0x000fe200078ee257ULL,
0x00000008480c7824ULL, 0x040fe200078e00ffULL, 0x0000006a49547212ULL, 0x080fe200078e3cffULL,
0x00000008450e7824ULL, 0x000fe200078e00ffULL, 0x0000006a48537212ULL, 0x080fe200078e3cffULL,
0x00000008470d7824ULL, 0x000fe200078e00ffULL, 0x0000006a45557212ULL, 0x080fe200078e3cffULL,
0x0000000a02357c36ULL, 0x000fe20008000000ULL, 0x0000006a47527212ULL, 0x080fe200078e3cffULL,
0x00000017ff0f7e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff80b547812ULL, 0x000fe200078ee254ULL,
0x0001400009097890ULL, 0x000fe2000fffe03fULL, 0xfffffff80c537812ULL, 0x000fe200078ee253ULL,
0x00000008460c7824ULL, 0x000fe200078e00ffULL, 0x0000006a020b7212ULL, 0x080fe200078e3cffULL,
0x0000000a03337c36ULL, 0x000fe20008000000ULL, 0xfffffff80e557812ULL, 0x000fe200078ee255ULL,
0x00000016ff0e7e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff80d527812ULL, 0x000fe200078ee252ULL,
0x00000011ff0d7e24ULL, 0x000fe2000f8e00ffULL, 0x0000006a46517212ULL, 0x000fe200078e3cffULL,
0x0000020035347825ULL, 0x000fe200078e000eULL, 0x0000003c024a7810ULL, 0x000fc40007ffe0ffULL,
0x000000070b377812ULL, 0x000fe200078ec0ffULL, 0x0000000a05437c36ULL, 0x000fe20008000000ULL,
0x000000390200720cULL, 0x000fe20003f26070ULL, 0x0000020033327825ULL, 0x000fe200078e000eULL,
0xfffffff80c517812ULL, 0x000fe400078ee251ULL, 0xfffffff80d0b7812ULL, 0x000fe200078ee26aULL,
0x000000084a0c7824ULL, 0x040fe200078e00ffULL, 0x0000006a4a697212ULL, 0x000fe200078e3cffULL,
0x0000000a040d7c36ULL, 0x000fe20008000000ULL, 0x0ffffff837687812ULL, 0x000fe200078ef86aULL,
0x000000100b347825ULL, 0x000fe200078e0034ULL, 0xfffffff80c697812ULL, 0x000fc400078ee269ULL,
0x0000000a44317c10ULL, 0x000fe2000fffe0ffULL, 0x000002000d0c7825ULL, 0x100fe200078e000eULL,
0x00000009683b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000394400720cULL, 0x080fe20003f46070ULL,
0x0000020031307825ULL, 0x000fe200078e000eULL, 0x000000390300720cULL, 0x080fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343b7faeULL, 0x0003e2000c901c4cULL,
0x000000390400720cULL, 0x080fe20003f86070ULL, 0x000000100b367825ULL, 0x000fe200078e000cULL,
0x000000390500720cULL, 0x000fc40003f26070ULL, 0x00000009673d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000200430c7825ULL, 0x000fe200078e000eULL, 0x00000009663f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000965417c11ULL, 0x000fe2000f8e20ffULL, 0x000000100b307825ULL, 0x040fe200078e0030ULL,
0x0000000964437c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a084f7c10ULL, 0x000fe2000fffe0ffULL,
0x000000100b327825ULL, 0x000fe200078e0032ULL, 0x00000000303d7faeULL, 0x0005e2000d101c4cULL,
0x000000390700720cULL, 0x000fc40003f46070ULL, 0x000000100b3a7825ULL, 0x002fe200078e000cULL,
0x00000000323f7faeULL, 0x0003e2000d901c4cULL, 0x000000390800720cULL, 0x080fe40003f66070ULL,
0x0000000a06357c36ULL, 0x040fe20008000000ULL, 0x0000000036417faeULL, 0x0007e2000e101c4cULL,
0x0000000a074d7c36ULL, 0x000fe20008000000ULL, 0x000000390900720cULL, 0x0c0fe20003f86070ULL,
0x0000000a095b7c36ULL, 0x000fe20008000000ULL, 0x000000003a437faeULL, 0x0009e2000c901c4cULL,
0x000000390600720cULL, 0x080fe20003f26070ULL, 0x0000000a0a5d7c36ULL, 0x040fe20008000000ULL,
0x000000390a00720cULL, 0x000fe20003fa6070ULL, 0x00000200350c7825ULL, 0x000fe200078e000eULL,
0x00000009593d7c11ULL, 0x004fc4000f8e20ffULL, 0x00000009583f7c11ULL, 0x002fe2000f8e20ffULL,
0x000002004d347825ULL, 0x100fe200078e000eULL, 0x0000000957417c11ULL, 0x008fe4000f8e20ffULL,
0x000000394a00720cULL, 0x000fe20003fc6070ULL, 0x000002004f367825ULL, 0x100fe200078e000eULL,
0x000000095a3b7c11ULL, 0x010fe4000f8e20ffULL, 0x0000000956437c11ULL, 0x000fe2000f8e20ffULL,
0x000002005b327825ULL, 0x000fc800078e000eULL, 0x000002005d307825ULL, 0x000fc800078e000eULL,
0x000000100b0c7825ULL, 0x000fc800078e000cULL, 0x000000100b347825ULL, 0x000fe200078e0034ULL,
0x000000000c3b7faeULL, 0x0003e2000c901c4cULL, 0x000000394500720cULL, 0x080fe40003f26070ULL,
0x000000100b367825ULL, 0x000fe200078e0036ULL, 0x00000000343d7faeULL, 0x0005e2000d101c4cULL,
0x000000394900720cULL, 0x080fe40003f46070ULL, 0x000000100b327825ULL, 0x000fe200078e0032ULL,
0x00000000363f7faeULL, 0x0007e2000d901c4cULL, 0x000000394800720cULL, 0x000fc40003f66070ULL,
0x000000100b307825ULL, 0x000fe200078e0030ULL, 0x0000000032417faeULL, 0x0009e2000e101c4cULL,
0x000000394700720cULL, 0x080fe40003f86070ULL, 0x0000000a450d7c36ULL, 0x002fe20008000000ULL,
0x0000000030437faeULL, 0x0003e2000e901c4cULL, 0x0000000a49357c36ULL, 0x004fe20008000000ULL,
0x000000394600720cULL, 0x000fe20003fa6070ULL, 0x0000000a48397c36ULL, 0x000fe20008000000ULL,
0x0000000a47377c10ULL, 0x008fe2000fffe0ffULL, 0x0000000a4a3b7c36ULL, 0x000fe20008000000ULL,
0x00000009533d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020039387825ULL, 0x000fe200078e000eULL,
0x00000009523f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000951417c11ULL, 0x010fe2000f8e20ffULL,
0x0000000a46337c36ULL, 0x000fe20008000000ULL, 0x0000000969437c11ULL, 0x002fe2000f8e20ffULL,
0x000002000d307825ULL, 0x000fc800078e000eULL, 0x00000200350c7825ULL, 0x000fc800078e000eULL,
0x0000020033347825ULL, 0x000fc800078e000eULL, 0x0000020037367825ULL, 0x000fc800078e000eULL,
0x000002003b327825ULL, 0x000fe200078e000eULL, 0x00000009553b7c11ULL, 0x000fc6000f8e20ffULL,
0x000000100b307825ULL, 0x000fc800078e0030ULL, 0x000000100b0c7825ULL, 0x040fe200078e000cULL,
0x00000000303b7faeULL, 0x0003e6000c901c4cULL, 0x000000100b387825ULL, 0x000fc800078e0038ULL,
0x000000100b367825ULL, 0x000fc800078e0036ULL, 0x000000100b347825ULL, 0x000fc800078e0034ULL,
0x000000100b327825ULL, 0x000fe200078e0032ULL, 0x00000009540b7c11ULL, 0x000fca000f8e20ffULL,
0x000000000c0b7faeULL, 0x0003e8000d101c4cULL, 0x00000000383d7faeULL, 0x0003e8000d901c4cULL,
0x00000000363f7faeULL, 0x0003e8000e101c4cULL, 0x0000000034417faeULL, 0x0003e8000e901c4cULL,
0x0000000032437faeULL, 0x0003e2000f101c4cULL, 0x0000000800687947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fe2000001166aULL, 0x000000030e117899ULL, 0x000fe4000800063fULL,
0x000000060e137291ULL, 0x000fe2000f8e703fULL, 0x0000001002057810ULL, 0x000fe20007ffe0ffULL,
0x0000000802037836ULL, 0x040fe40000000000ULL, 0x0000000402447836ULL, 0x000fe20000000000ULL,
0x0000006a05647212ULL, 0x080fe200078e3cffULL, 0x0000000803077824ULL, 0x040fe200078e00ffULL,
0x0000006a03667212ULL, 0x080fe200078e3cffULL, 0x0000000844067824ULL, 0x040fe200078e00ffULL,
0x0000006a44677212ULL, 0x080fe200078e3cffULL, 0x0000003002487836ULL, 0x040fe20000000000ULL,
0xfffffff807667812ULL, 0x000fe200078ee266ULL, 0x0000000c02047836ULL, 0x000fe20000000000ULL,
0x0000001802077810ULL, 0x000fe20007ffe0ffULL, 0x00000008480e7824ULL, 0x000fe200078e00ffULL,
0xfffffff806677812ULL, 0x000fe200078ee267ULL, 0x0000001402067836ULL, 0x000fe20000000000ULL,
0x0000006a07597212ULL, 0x0c0fe200078e3cffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0x0000006a48537212ULL, 0x080fe200078e3cffULL, 0x0000000804087824ULL, 0x040fe200078e00ffULL,
0x0000006a04657212ULL, 0x080fe200078e3cffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x0000006a065a7212ULL, 0x0c0fe200078e3cffULL, 0x00000008060b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a597812ULL, 0x000fe200078ee259ULL, 0x00000024020a7836ULL, 0x040fe20000000000ULL,
0xfffffff80e537812ULL, 0x000fe200078ee253ULL, 0x0000003402477836ULL, 0x040fe20000000000ULL,
0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL, 0xfffffff808657812ULL, 0x000fe200078ee265ULL,
0x0000001c02087836ULL, 0x040fe20000000000ULL, 0xfffffff809647812ULL, 0x000fe200078ee264ULL,
0x0000002002097836ULL, 0x000fe20000000000ULL, 0xfffffff80b5a7812ULL, 0x000fe200078ee25aULL,
0x000000080a0b7824ULL, 0x040fe200078e00ffULL, 0x0000006a0a567212ULL, 0x080fe200078e3cffULL,
0x00000008080d7824ULL, 0x040fe200078e00ffULL, 0x0000006a08587212ULL, 0x080fe200078e3cffULL,
0x0000002802457836ULL, 0x040fe20000000000ULL, 0x0000006a09577212ULL, 0x0c0fe200078e3cffULL,
0x0000002c02497836ULL, 0x040fe20000000000ULL, 0x00000003090c7819ULL, 0x000fe200000006ffULL,
0x0000003802467836ULL, 0x040fe20000000000ULL, 0xfffffff80b567812ULL, 0x000fe200078ee256ULL,
0x00000011ff337e24ULL, 0x000fe2000f8e00ffULL, 0x0000006a47527212ULL, 0x0c0fe200078e3cffULL,
0x0000003c024a7836ULL, 0x000fe20000000000ULL, 0x00000003470b7819ULL, 0x000fe200000006ffULL,
0x0000001310097291ULL, 0x000fe2000f8e683fULL, 0xfffffff80d587812ULL, 0x000fe200078ee258ULL,
0x00000008490d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c577812ULL, 0x000fe200078ee257ULL,
0x000000084a307824ULL, 0x000fe200078e00ffULL, 0x0000006a45557212ULL, 0x0c0fe200078e3cffULL,
0x0000000a02317c36ULL, 0x000fe20008000000ULL, 0x00000003450c7819ULL, 0x000fe200000006ffULL,
0x0000000a44417c36ULL, 0x000fe20008000000ULL, 0x0000006a49547212ULL, 0x080fe200078e3cffULL,
0x0000000a044d7c36ULL, 0x000fe20008000000ULL, 0xfffffff80b527812ULL, 0x000fe200078ee252ULL,
0x0000000a055d7c36ULL, 0x000fe20008000000ULL, 0x0000006a020b7212ULL, 0x080fe200078e3cffULL,
0x0000000a06437c36ULL, 0x000fe20008000000ULL, 0xfffffff80c557812ULL, 0x000fe200078ee255ULL,
0x00000008460c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d547812ULL, 0x000fe200078ee254ULL,
0x0000000a07397c36ULL, 0x000fe20008000000ULL, 0x000000070b0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000a083f7c36ULL, 0x000fe20008000000ULL, 0x0000006a46517212ULL, 0x080fe200078e3cffULL,
0x0000000a0a617c36ULL, 0x000fe20008000000ULL, 0xfffffff8330b7812ULL, 0x000fe200078ee26aULL,
0x0000000a48337c36ULL, 0x000fe20008000000ULL, 0x0000000a46357c10ULL, 0x000fe2000fffe0ffULL,
0x0000000a453d7c36ULL, 0x000fe20008000000ULL, 0x0000006a4a697212ULL, 0x040fe200078e3cffULL,
0x0000000a493b7c36ULL, 0x000fe20008000000ULL, 0x0000000a035f7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000a47377c36ULL, 0x000fe20008000000ULL, 0x0000000a09637c10ULL, 0x000fe2000fffe0ffULL,
0x0000000a4a4f7c36ULL, 0x000fe20008000000ULL, 0xfffffff80c517812ULL, 0x000fe200078ee251ULL,
0x0001400009097890ULL, 0x000fe2000fffe03fULL, 0x0ffffff80d687812ULL, 0x000fe200078ef86aULL,
0x00000200330c7825ULL, 0x002fe200078e000eULL, 0xfffffff830697812ULL, 0x000fc600078ee269ULL,
0x0000020035327825ULL, 0x100fe200078e000eULL, 0x00000009665b7c11ULL, 0x000fe4000f8e20ffULL,
0x00000009656b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000020031307825ULL, 0x100fe200078e000eULL,
0x00000009646d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000095a6f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000020041407825ULL, 0x100fe200078e000eULL, 0x0000000957717c11ULL, 0x000fe4000f8e20ffULL,
0x0000000956737c11ULL, 0x000fe2000f8e20ffULL, 0x000002005f5e7825ULL, 0x000fe200078e000eULL,
0x0000000955757c11ULL, 0x000fc6000f8e20ffULL, 0x000002004d4c7825ULL, 0x000fc800078e000eULL,
0x000002005d5c7825ULL, 0x000fc800078e000eULL, 0x0000020043427825ULL, 0x000fc800078e000eULL,
0x0000020039387825ULL, 0x000fc800078e000eULL, 0x000002003f3e7825ULL, 0x000fc800078e000eULL,
0x0000020063627825ULL, 0x000fc800078e000eULL, 0x0000020061607825ULL, 0x000fc800078e000eULL,
0x000002003d3c7825ULL, 0x000fc800078e000eULL, 0x000002003b3a7825ULL, 0x000fc800078e000eULL,
0x0000020037367825ULL, 0x000fc800078e000eULL, 0x000002004f347825ULL, 0x000fe200078e000eULL,
0x00000009684f7c11ULL, 0x000fc6000f8e20ffULL, 0x000000100b307825ULL, 0x000fc800078e0030ULL,
0x000000100b407825ULL, 0x040fe200078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000304f7faeULL, 0x0003e6000b901c4cULL, 0x000000100b5e7825ULL, 0x000fc800078e005eULL,
0x000000100b4c7825ULL, 0x000fc800078e004cULL, 0x000000100b5c7825ULL, 0x000fe200078e005cULL,
0x0000000959317c11ULL, 0x002fe4000f8e20ffULL, 0x00000009584f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100b427825ULL, 0x000fc800078e0042ULL, 0x000000100b387825ULL, 0x000fc800078e0038ULL,
0x000000100b3e7825ULL, 0x000fc800078e003eULL, 0x000000100b627825ULL, 0x000fc800078e0062ULL,
0x000000100b607825ULL, 0x000fc800078e0060ULL, 0x000000100b3c7825ULL, 0x000fc800078e003cULL,
0x000000100b3a7825ULL, 0x000fc800078e003aULL, 0x000000100b0c7825ULL, 0x000fc800078e000cULL,
0x000000100b367825ULL, 0x000fc800078e0036ULL, 0x000000100b327825ULL, 0x000fc800078e0032ULL,
0x000000100b347825ULL, 0x000fe200078e0034ULL, 0x00000009670b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000400b7faeULL, 0x0003e8000b901c4cULL, 0x000000005e5b7faeULL, 0x0005e8000b901c4cULL,
0x000000004c6b7faeULL, 0x0007e8000b901c4cULL, 0x000000005c6d7faeULL, 0x000fe2000b901c4cULL,
0x00000009540b7c11ULL, 0x002fc4000f8e20ffULL, 0x0000000953417c11ULL, 0x000fe2000f8e20ffULL,
0x00000000426f7faeULL, 0x0003e2000b901c4cULL, 0x00000009695b7c11ULL, 0x004fc6000f8e20ffULL,
0x0000000038317faeULL, 0x0009e2000b901c4cULL, 0x00000009514d7c11ULL, 0x008fc6000f8e20ffULL,
0x000000003e4f7faeULL, 0x0009e8000b901c4cULL, 0x0000000062717faeULL, 0x0009e2000b901c4cULL,
0x0000000952437c11ULL, 0x002fc6000f8e20ffULL, 0x0000000060737faeULL, 0x0009e8000b901c4cULL,
0x000000003c757faeULL, 0x0009e8000b901c4cULL, 0x000000003a0b7faeULL, 0x0009e8000b901c4cULL,
0x000000000c417faeULL, 0x0009e8000b901c4cULL, 0x0000000036437faeULL, 0x0009e8000b901c4cULL,
0x00000000324d7faeULL, 0x0009e8000b901c4cULL, 0x00000000345b7faeULL, 0x0009e4000b901c4cULL,
0x00001800010b7983ULL, 0x012ea20000100800ULL, 0x000000106a4c7824ULL, 0x000fc600078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000704c4c7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0b0b7812ULL, 0x004fc800078ec0ffULL, 0x000000000b0a72caULL, 0x000fe400000e0000ULL,
0x00000001ff0b7819ULL, 0x000fc8000001166aULL, 0x0000000c0b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000060b4c7c10ULL, 0x000fc6000fffe04cULL, 0x000088800a117896ULL, 0x000fc8000800003fULL,
0x0000001f110a7899ULL, 0x000fcc000800063fULL, 0x0000000aff0c7e24ULL, 0x000fc8000f8e00ffULL,
0x0246080cff0075a7ULL, 0x000e640008020146ULL, 0x000000fc009c9947ULL, 0x002fea0003800000ULL,
0x024000004c0b7984ULL, 0x000e620000000800ULL, 0x000000076a5d7812ULL, 0x040fe200078ec0ffULL,
0x0000001304047291ULL, 0x000fe2000f8e683fULL, 0x00000001000d7802ULL, 0x000fe20000000f00ULL,
0x024200004c5b7984ULL, 0x0004a20000000800ULL, 0x00000004ff6d7819ULL, 0x000fe4000001166aULL,
0x000000086a5c7812ULL, 0x000fe400078ec0ffULL, 0x000000085d5e7812ULL, 0x000fe400078ef86aULL,
0x000000000b00720bULL, 0x002fda0003f3d000ULL, 0x00000000000c7806ULL, 0x000fc800008e0100ULL,
0x0000ffff0c317812ULL, 0x000fda000782c0ffULL, 0x0000000000d49947ULL, 0x004fea0003800000ULL,
0x000000000b00720bULL, 0x000fe40003f34000ULL, 0x0000000b00337209ULL, 0x000fe40007810000ULL,
0x00000002ff0d7819ULL, 0x000fc6000001166aULL, 0x80000033000c7221ULL, 0x000fe40000010000ULL,
0x000000080d307836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x0000000eff007c0cULL, 0x000fe4000bf25270ULL,
0x0000000c000c7308ULL, 0x000e620000000800ULL, 0x0000ffff00007812ULL, 0x000fc800078e3cffULL,
0x0000000031ff7212ULL, 0x000fcc000784c0ffULL, 0x024400334c009388ULL, 0x000fe80000000800ULL,
0x00001f0d0c007589ULL, 0x0022a200000e0000ULL, 0x0000000c4b4b7220ULL, 0x000fe40000410000ULL,
0x800000330b0b2221ULL, 0x000fe20000010000ULL, 0x00001f300c307589ULL, 0x000ee600000e0000ULL,
0x3fb8aa3b0b0b2820ULL, 0x000fe20000410000ULL, 0x00000001ff0d7807ULL, 0x002fc60001000000ULL,
0x0000000b004e2308ULL, 0x000e620000000800ULL, 0x000000002d2d7220ULL, 0x084fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x000fe20000410000ULL, 0x000000302f2f7220ULL, 0x088fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x000000302a2a7220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x0000003012127220ULL, 0x080fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x0000003016167220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x000fc400078e0033ULL,
0x0000004e5b5b2220ULL, 0x002fce0000410000ULL, 0x000000076d0b7812ULL, 0x000fe200078e785eULL,
0x000000046d6c7836ULL, 0x040fe20000000000ULL, 0x000000075c307812ULL, 0x000fe200078ec85dULL,
0x000000026d5f7836ULL, 0x040fe20000000000ULL, 0x0000005d5c5c7212ULL, 0x000fe200078efcffULL,
0x000000085e0b7824ULL, 0x000fe200078e020bULL, 0x0000006d304d7212ULL, 0x000fe200078e3cffULL,
0x0001400004047890ULL, 0x000fe2000fffe03fULL, 0x00000002ff317819ULL, 0x000fe2000001166aULL,
0x000000066d6d7836ULL, 0x000fe20000000000ULL, 0x000000060b627c11ULL, 0x000fe2000f8e20ffULL,
0x000000085c0c7824ULL, 0x000fe200078e024dULL, 0x0000004eff0b723eULL, 0x000fe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000006c304f7212ULL, 0x040fe200078e3cffULL,
0x0000080c01007387ULL, 0x0003e20000100800ULL, 0x000054100b617816ULL, 0x000fe2000000000bULL,
0x000000141500728cULL, 0x000fe2000bf06070ULL, 0x0000005f30507212ULL, 0x000fe200078e3cffULL,
0x000000085c637824ULL, 0x000fe200078e024fULL, 0x000000040c407c11ULL, 0x000fe2000f8e20ffULL,
0x00001f31610b7589ULL, 0x0005e200000e0000ULL, 0x000000505c607211ULL, 0x000fe200078e18ffULL,
0x00000001ff777424ULL, 0x000fe200078e00ffULL, 0x00000004633c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000008310c7836ULL, 0x002fe20000000000ULL, 0x012000006234783bULL, 0x000e620000000200ULL,
0x0000000460387c11ULL, 0x000fe2000f8e20ffULL, 0x0000004b5b4b7221ULL, 0x000fe20000010000ULL,
0x000000075f5f7812ULL, 0x000fe200078e785eULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x000099100d317816ULL, 0x004fc400000000ffULL, 0x0000006d300d7212ULL, 0x000fe200078e3cffULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x000000085e5f7824ULL, 0x000fe200078e025fULL,
0x000000076d6d7812ULL, 0x000fe200078e785eULL, 0x000000ffff307224ULL, 0x000fe200078e0031ULL,
0x0000000d5c6b7211ULL, 0x000fe200078e18ffULL, 0x00001f0c610c7589ULL, 0x0004e600000e0000ULL,
0x000000ff3000720cULL, 0x000fe20003f25270ULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x000000046b307c11ULL, 0x000fc4000f8e20ffULL, 0x000000065f617c11ULL, 0x004fc8000f8e20ffULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x000000805c5f7811ULL, 0x000fca00078e18ffULL,
0x0000000150717824ULL, 0x100fe400078e025fULL, 0x000000014f767824ULL, 0x100fe400078e025fULL,
0x000000010d757824ULL, 0x100fe200078e025fULL, 0x00000004716e7c11ULL, 0x000fe2000f8e20ffULL,
0x000000014d727824ULL, 0x000fe200078e025fULL, 0x00000004766f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b34349232ULL, 0x082fe40000200000ULL, 0x0000000b36369232ULL, 0x000fc40000200000ULL,
0x0000000c35359232ULL, 0x088fe40000200000ULL, 0x0000000c37379232ULL, 0x000fce0000200000ULL,
0x000000383418723cULL, 0x000fec0000041818ULL, 0x0000003a3414723cULL, 0x000fec0000041814ULL,
0x0000003c3438723cULL, 0x000fe20000041810ULL, 0x012000006110783bULL, 0x000e6a0000000200ULL,
0x0000003e3424723cULL, 0x000fec0000041824ULL, 0x00000030343c723cULL, 0x004fe20000041828ULL,
0x000000006e28783bULL, 0x0004ea0000004200ULL, 0x000000403420723cULL, 0x000fe20000041820ULL,
0x0000000475307c11ULL, 0x000fc4000f8e20ffULL, 0x000001005c6e7811ULL, 0x004fc600078e18ffULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x0000000472407c11ULL, 0x000fe2000f8e20ffULL,
0x0000000150747824ULL, 0x100fe400078e026eULL, 0x000000014f737824ULL, 0x100fe400078e026eULL,
0x00000032342c723cULL, 0x000fe2000004182cULL, 0x000000006f34783bULL, 0x0005280000004200ULL,
0x000000003030783bULL, 0x000f680000004200ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x000000014d6f7824ULL, 0x004fc400078e026eULL, 0x0000000b10109232ULL, 0x082fe40000200000ULL,
0x000000010d6e7824ULL, 0x000fe400078e026eULL, 0x0000000b12129232ULL, 0x000fe40000200000ULL,
0x0000000c11119232ULL, 0x080fe40000200000ULL, 0x0000000c13139232ULL, 0x000fce0000200000ULL,
0x000000281018723cULL, 0x008fec0000041818ULL, 0x0000002a1014723cULL, 0x000fe20000041814ULL,
0x000000076c297812ULL, 0x000fe400078e785eULL, 0x000000046e287c11ULL, 0x000fe4000f8e20ffULL,
0x000000295e297211ULL, 0x040fe200078e18ffULL, 0x000000085e5e7824ULL, 0x000fc600078e026dULL,
0x00000006295f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000341038723cULL, 0x010fe20000041838ULL,
0x000000002828783bULL, 0x000fe20000004200ULL, 0x000000065e5e7c11ULL, 0x000fc8000f8e20ffULL,
0x000000361034723cULL, 0x000fe20000041824ULL, 0x012000005f24783bULL, 0x000e6a0000000200ULL,
0x00000030103c723cULL, 0x020fec000004183cULL, 0x000000401020723cULL, 0x000fe20000041820ULL,
0x0000000474307c11ULL, 0x000fca000f8e20ffULL, 0x00000042101c723cULL, 0x000fe2000004181cULL,
0x000000046f407c11ULL, 0x000fca000f8e20ffULL, 0x000000321010723cULL, 0x000fe2000004182cULL,
0x000000003030783bULL, 0x000ea80000004200ULL, 0x000000004040783bULL, 0x000fe40000004200ULL,
0x00000004732c7c11ULL, 0x000fcc000f8e20ffULL, 0x000000002c2c783bULL, 0x000ee20000004200ULL,
0x0000000b24249232ULL, 0x082fe40000200000ULL, 0x0000000b26269232ULL, 0x000fe40000200000ULL,
0x0000000c25259232ULL, 0x080fe40000200000ULL, 0x0000000c27279232ULL, 0x000fce0000200000ULL,
0x00000028243c723cULL, 0x000fec000004183cULL, 0x000000302418723cULL, 0x004fec0000041818ULL,
0x000000322414723cULL, 0x000fe20000041814ULL, 0x000001805c307811ULL, 0x000fc800078e18ffULL,
0x000000304d707210ULL, 0x000fe20007ffe0ffULL, 0x0000002c2438723cULL, 0x008fe20000041838ULL,
0x00000001505c7824ULL, 0x100fe400078e0230ULL, 0x000000014f6c7824ULL, 0x100fe200078e0230ULL,
0x0000000470287c11ULL, 0x000fe2000f8e20ffULL, 0x000000010d6d7824ULL, 0x000fe200078e0230ULL,
0x0000002e2434723cULL, 0x000fe20000041834ULL, 0x012000005e2c783bULL, 0x000e620000000200ULL,
0x000000045c0d7c11ULL, 0x000fc8000f8e20ffULL, 0x000000402420723cULL, 0x000fec0000041820ULL,
0x00000042241c723cULL, 0x000fe2000004181cULL, 0x000000046d407c11ULL, 0x000fca000f8e20ffULL,
0x0000002a2430723cULL, 0x000fe20000041810ULL, 0x000000000d10783bULL, 0x000ea80000004200ULL,
0x000000002828783bULL, 0x000ee40000004200ULL, 0x000000046c247c11ULL, 0x000fe2000f8e20ffULL,
0x0000001000047c82ULL, 0x000fe20008000000ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x000000002424783bULL, 0x000f220000004200ULL, 0x02461077ffff79a7ULL, 0x000be20008500006ULL,
0x0000000b2c2c9232ULL, 0x002fc40000200000ULL, 0x0000000b2e2e9232ULL, 0x000fe40000200000ULL,
0x0000000c2d2d9232ULL, 0x080fe40000200000ULL, 0x0000000c2f2f9232ULL, 0x000fe20000200000ULL,
0x000000000000781cULL, 0x000fcc0003f2f008ULL, 0x000000102c18723cULL, 0x004fec0000041818ULL,
0x000000122c14723cULL, 0x000fec0000041814ULL, 0x000000282c20723cULL, 0x008fec0000041820ULL,
0x0000002a2c1c723cULL, 0x000fec000004181cULL, 0x000000242c10723cULL, 0x010fec0000041838ULL,
0x000000262c24723cULL, 0x000fec0000041834ULL, 0x000000402c28723cULL, 0x000fec000004183cULL,
0x000000422c2c723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000004000e81947ULL, 0x020fde0003800000ULL, 0x000000800b157890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000012071672a4ULL, 0x000fe2000f8e0215ULL,
0x0000000400bc8947ULL, 0x000ff60003800000ULL, 0x000000151400728cULL, 0x000fe4000bf01070ULL,
0x80000015ff367e24ULL, 0x000fe2000f8e02ffULL, 0x000000030e0a7899ULL, 0x000fe2000800063fULL,
0x0000001602317c36ULL, 0x000fe20008000000ULL, 0x0000001514047287ULL, 0x000fe2000c000000ULL,
0x00000016440d7c36ULL, 0x000fe20008000000ULL, 0x0000000108087892ULL, 0x000fe2000f8ec03fULL,
0x0000020031307825ULL, 0x100fe200078e000eULL, 0x00000016053b7c10ULL, 0x000fe4000fffe0ffULL,
0x00000004000b7c02ULL, 0x000fe20008000f00ULL, 0x0000000aff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x0000001308047291ULL, 0x000fe2000f8e683fULL, 0x0000001603337c36ULL, 0x000fe20008000000ULL,
0x000000400b367446ULL, 0x000fe20003800036ULL, 0x0000001604357c36ULL, 0x000fe20008000000ULL,
0xfffffff80c0b7812ULL, 0x000fe200078ee25dULL, 0x00014000040a7890ULL, 0x000fe2000fffe03fULL,
0x000000360200720cULL, 0x080fe20003f26070ULL, 0x000002000d0c7825ULL, 0x000fe200078e000eULL,
0x000000364400720cULL, 0x000fc40003f46070ULL, 0x000000360500720cULL, 0x080fe20003f66070ULL,
0x000000100b307825ULL, 0x000fe200078e0030ULL, 0x0000000a68377c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a67397c11ULL, 0x000fe2000f8e20ffULL, 0x000000100b0c7825ULL, 0x000fe200078e000cULL,
0x000000360600720cULL, 0x080fe40003f86070ULL, 0x000000364600720cULL, 0x080fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030377faeULL, 0x0003e2000c901c4cULL,
0x000000360300720cULL, 0x080fe20003f26070ULL, 0x00000016063d7c36ULL, 0x000fe20008000000ULL,
0x000000364a00720cULL, 0x080fe20003fc6070ULL, 0x000000000c397faeULL, 0x0005e2000d101c4cULL,
0x000000360400720cULL, 0x000fe20003f46070ULL, 0x0000020035347825ULL, 0x000fc800078e000eULL,
0x00000016073f7c36ULL, 0x000fe40008000000ULL, 0x000002003d307825ULL, 0x102fe200078e000eULL,
0x0000000a66377c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a5a3d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000200330c7825ULL, 0x004fe200078e000eULL, 0x0000000a65397c11ULL, 0x000fc6000f8e20ffULL,
0x000002003b327825ULL, 0x000fe200078e000eULL, 0x0000000a643b7c11ULL, 0x000fc6000f8e20ffULL,
0x000000100b0c7825ULL, 0x000fc800078e000cULL, 0x000000100b347825ULL, 0x000fe200078e0034ULL,
0x000000000c377faeULL, 0x0003e2000c901c4cULL, 0x000000360700720cULL, 0x080fe40003f26070ULL,
0x000000100b327825ULL, 0x040fe200078e0032ULL, 0x0000000034397faeULL, 0x0005e2000d101c4cULL,
0x000000360800720cULL, 0x080fe40003f46070ULL, 0x000000100b307825ULL, 0x000fe200078e0030ULL,
0x00000000323b7faeULL, 0x0007e2000d901c4cULL, 0x000000360900720cULL, 0x000fc40003f66070ULL,
0x0000001608417c36ULL, 0x000fe20008000000ULL, 0x00000000303d7faeULL, 0x0009e2000e101c4cULL,
0x0000001609437c36ULL, 0x000fe20008000000ULL, 0x000000360a00720cULL, 0x040fe20003f86070ULL,
0x000000160a4d7c36ULL, 0x000fe20008000000ULL, 0x0000000a59377c11ULL, 0x002fe2000f8e20ffULL,
0x000002003f0c7825ULL, 0x100fe200078e000eULL, 0x0000000a58397c11ULL, 0x004fe4000f8e20ffULL,
0x0000000a573b7c11ULL, 0x008fe2000f8e20ffULL, 0x0000020041347825ULL, 0x000fe200078e000eULL,
0x00000016453f7c10ULL, 0x000fc4000fffe0ffULL, 0x0000000a563d7c11ULL, 0x010fe2000f8e20ffULL,
0x0000020043327825ULL, 0x100fe200078e000eULL, 0x0000000a52417c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a51437c11ULL, 0x000fe2000f8e20ffULL, 0x000002004d307825ULL, 0x000fe200078e000eULL,
0x0000000a694d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000100b0c7825ULL, 0x000fc800078e000cULL,
0x000000100b347825ULL, 0x000fe200078e0034ULL, 0x000000000c377faeULL, 0x0003e2000c901c4cULL,
0x000000364500720cULL, 0x080fe40003f26070ULL, 0x000000100b327825ULL, 0x000fe200078e0032ULL,
0x0000000034397faeULL, 0x0005e2000d101c4cULL, 0x000000364900720cULL, 0x080fe40003f46070ULL,
0x000000100b307825ULL, 0x000fe200078e0030ULL, 0x00000000323b7faeULL, 0x0007e2000d901c4cULL,
0x000000364800720cULL, 0x000fc40003f66070ULL, 0x00000016490d7c36ULL, 0x002fe20008000000ULL,
0x00000000303d7faeULL, 0x0003e2000e101c4cULL, 0x0000001646377c36ULL, 0x000fe20008000000ULL,
0x000000364700720cULL, 0x040fe20003f86070ULL, 0x0000001647357c36ULL, 0x004fe40008000000ULL,
0x000000164a397c36ULL, 0x000fe40008000000ULL, 0x0000001648337c36ULL, 0x008fe20008000000ULL,
0x0000000a553b7c11ULL, 0x000fe2000f8e20ffULL, 0x000002000d0c7825ULL, 0x000fe200078e000eULL,
0x0000000a543d7c11ULL, 0x002fc6000f8e20ffULL, 0x000002003f307825ULL, 0x000fe200078e000eULL,
0x0000000a533f7c11ULL, 0x000fc6000f8e20ffULL, 0x0000020033327825ULL, 0x000fc800078e000eULL,
0x0000020035347825ULL, 0x000fc800078e000eULL, 0x0000020037367825ULL, 0x000fc800078e000eULL,
0x0000020039387825ULL, 0x000fc800078e000eULL, 0x000000100b307825ULL, 0x000fc800078e0030ULL,
0x000000100b0c7825ULL, 0x040fe200078e000cULL, 0x00000000303b7faeULL, 0x0003e6000c901c4cULL,
0x000000100b327825ULL, 0x040fe200078e0032ULL, 0x000000000c3d7faeULL, 0x0003e6000d101c4cULL,
0x000000100b347825ULL, 0x040fe200078e0034ULL, 0x00000000323f7faeULL, 0x0003e6000d901c4cULL,
0x000000100b367825ULL, 0x040fe200078e0036ULL, 0x0000000034417faeULL, 0x0003e6000e101c4cULL,
0x000000100b387825ULL, 0x000fe200078e0038ULL, 0x0000000036437faeULL, 0x0003e8000e901c4cULL,
0x00000000384d7faeULL, 0x0003e2000f101c4cULL, 0x0000000400647947ULL, 0x000fea0003800000ULL,
0x000000030e047899ULL, 0x000fe2000800063fULL, 0x0000001602317c36ULL, 0x000fe20008000000ULL,
0x0000000108087892ULL, 0x000fe2000f8ec03fULL, 0x0000001644357c36ULL, 0x000fe20008000000ULL,
0x0000001606417c10ULL, 0x000fe2000fffe0ffULL, 0x0000001603337c36ULL, 0x000fe20008000000ULL,
0x00000013080a7291ULL, 0x000fe2000f8e683fULL, 0x00000004000c7c02ULL, 0x000fe20008000f00ULL,
0x00000016040d7c36ULL, 0x000fe40008000000ULL, 0x0000020031307825ULL, 0x000fe200078e000eULL,
0x000140000a0a7890ULL, 0x000fe2000fffe03fULL, 0xfffffff80c0b7812ULL, 0x000fc400078ee25dULL,
0x0000020035347825ULL, 0x000fc600078e000eULL, 0x0000000a68377c11ULL, 0x000fe2000f8e20ffULL,
0x0000020033327825ULL, 0x100fe200078e000eULL, 0x0000000a67397c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a663b7c11ULL, 0x000fe2000f8e20ffULL, 0x000002000d0c7825ULL, 0x000fe200078e000eULL,
0x0000000a653d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000100b307825ULL, 0x000fc800078e0030ULL,
0x000000100b347825ULL, 0x040fe200078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030377faeULL, 0x0003e6000b901c4cULL, 0x000000100b327825ULL, 0x040fe200078e0032ULL,
0x0000000034397faeULL, 0x0005e6000b901c4cULL, 0x000000100b0c7825ULL, 0x000fe200078e000cULL,
0x00000000323b7faeULL, 0x0007e6000b901c4cULL, 0x00000016053f7c36ULL, 0x000fe20008000000ULL,
0x000000000c3d7faeULL, 0x0009e2000b901c4cULL, 0x0000001607437c36ULL, 0x000fc40008000000ULL,
0x0000020041307825ULL, 0x102fe200078e000eULL, 0x0000000a64397c11ULL, 0x004fe4000f8e20ffULL,
0x0000000a57417c11ULL, 0x000fe2000f8e20ffULL, 0x0000001608357c36ULL, 0x000fe20008000000ULL,
0x0000000a5a3b7c11ULL, 0x008fe2000f8e20ffULL, 0x0000020043327825ULL, 0x100fe200078e000eULL,
0x0000000a56437c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a593d7c11ULL, 0x010fe2000f8e20ffULL,
0x000002003f0c7825ULL, 0x000fc800078e000eULL, 0x0000001609377c36ULL, 0x000fe40008000000ULL,
0x000000100b0c7825ULL, 0x000fc800078e000cULL, 0x000000160a3f7c36ULL, 0x000fe20008000000ULL,
0x000000000c397faeULL, 0x0003e2000b901c4cULL, 0x0000020035347825ULL, 0x000fc800078e000eULL,
0x0000020037367825ULL, 0x000fc800078e000eULL, 0x000000100b307825ULL, 0x000fc800078e0030ULL,
0x000002003f0c7825ULL, 0x002fe200078e000eULL, 0x0000000a583f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000303b7faeULL, 0x0003e4000b901c4cULL, 0x000000100b327825ULL, 0x000fc800078e0032ULL,
0x000000100b347825ULL, 0x040fe200078e0034ULL, 0x00000000323d7faeULL, 0x0005e6000b901c4cULL,
0x000000100b367825ULL, 0x000fe200078e0036ULL, 0x00000000343f7faeULL, 0x0007e2000b901c4cULL,
0x0000000a553b7c11ULL, 0x002fe4000f8e20ffULL, 0x00000016454d7c36ULL, 0x000fe20008000000ULL,
0x0000000036417faeULL, 0x0003e2000b901c4cULL, 0x000000100b0c7825ULL, 0x000fe200078e000cULL,
0x0000001649337c10ULL, 0x004fc6000fffe0ffULL, 0x0000001648397c36ULL, 0x000fe20008000000ULL,
0x000000000c437faeULL, 0x0005e2000b901c4cULL, 0x000002004d307825ULL, 0x000fe200078e000eULL,
0x0000000a533f7c11ULL, 0x008fc6000f8e20ffULL, 0x00000016473d7c36ULL, 0x000fe20008000000ULL,
0x0000000a52417c11ULL, 0x002fe2000f8e20ffULL, 0x00000016464d7c36ULL, 0x000fe40008000000ULL,
0x000000164a4f7c36ULL, 0x000fe40008000000ULL, 0x000002003d347825ULL, 0x100fe200078e000eULL,
0x0000000a543d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a51437c11ULL, 0x004fe2000f8e20ffULL,
0x00000200330c7825ULL, 0x000fc800078e000eULL, 0x0000020039327825ULL, 0x000fc800078e000eULL,
0x000002004d367825ULL, 0x000fe200078e000eULL, 0x0000000a694d7c11ULL, 0x000fc6000f8e20ffULL,
0x000002004f387825ULL, 0x000fc800078e000eULL, 0x000000100b307825ULL, 0x000fc800078e0030ULL,
0x000000100b0c7825ULL, 0x040fe200078e000cULL, 0x00000000303b7faeULL, 0x0003e6000b901c4cULL,
0x000000100b327825ULL, 0x040fe200078e0032ULL, 0x000000000c3d7faeULL, 0x0003e6000b901c4cULL,
0x000000100b347825ULL, 0x040fe200078e0034ULL, 0x00000000323f7faeULL, 0x0003e6000b901c4cULL,
0x000000100b367825ULL, 0x040fe200078e0036ULL, 0x0000000034417faeULL, 0x0003e6000b901c4cULL,
0x000000100b387825ULL, 0x000fe200078e0038ULL, 0x0000000036437faeULL, 0x0003e8000b901c4cULL,
0x00000000384d7faeULL, 0x0003e4000b901c4cULL, 0x0000001f11047899ULL, 0x000fe2000800063fULL,
0x00000000000079afULL, 0x000e2a0000000000ULL, 0x00000004ff0c7e24ULL, 0x002fc8000f8e00ffULL,
0x0246180cff0075a7ULL, 0x000e640008020146ULL, 0x000000e400349947ULL, 0x002fea0003800000ULL,
0x024080004c0d7984ULL, 0x000e620000000800ULL, 0x00000002ff367819ULL, 0x000fe2000001166aULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x024280004c4d7984ULL, 0x0004a40000000800ULL,
0x0000000836357836ULL, 0x000fe20000000000ULL, 0x000000000d00720bULL, 0x002fda0003f3d000ULL,
0x00000000000c7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0c307812ULL, 0x000fda000782c0ffULL,
0x0000000000d09947ULL, 0x004fea0003800000ULL, 0x000000000d00720bULL, 0x000fe20003f34000ULL,
0x000000010e00788cULL, 0x000fe2000bf05270ULL, 0x0000000d00337209ULL, 0x000fca0007810000ULL,
0x80000033000c7221ULL, 0x000fe20000010000ULL, 0x000000000000781cULL, 0x000fc60003f4f008ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL, 0x0000000000007806ULL, 0x000fc800008e0100ULL,
0x0000ffff00317812ULL, 0x000fe200078e3cffULL, 0x0000000c000c7308ULL, 0x000e660000000800ULL,
0x0000003130ff7212ULL, 0x000fe2000782c0ffULL, 0x024480334c00a388ULL, 0x000fe60000000800ULL,
0x00000001ff347807ULL, 0x000fe20000800000ULL, 0x00001f360c007589ULL, 0x002e7000000e0000ULL,
0x800000330d301221ULL, 0x000fe20000010000ULL, 0x0000000c4b4b7220ULL, 0x000fe20000410000ULL,
0x00001f350c0d7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b30301820ULL, 0x000fc80000410000ULL,
0x00000030004e1308ULL, 0x000ee20000000800ULL, 0x0000000020207220ULL, 0x082fe20000410000ULL,
0x0000000021217220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000024247220ULL, 0x080fe20000410000ULL,
0x0000000025257220ULL, 0x080fe20000410000ULL, 0x0000000028287220ULL, 0x080fe20000410000ULL,
0x0000000029297220ULL, 0x080fe20000410000ULL, 0x000000002c2c7220ULL, 0x080fe20000410000ULL,
0x000000002d2d7220ULL, 0x000fe20000410000ULL, 0x0000000d22227220ULL, 0x084fe20000410000ULL,
0x0000000d23237220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x080fe20000410000ULL, 0x0000000d12127220ULL, 0x080fe20000410000ULL,
0x0000000d13137220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x080fe20000410000ULL,
0x0000000d27277220ULL, 0x080fe20000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000d2f2f7220ULL, 0x000fe20000410000ULL, 0x000000ffff007224ULL, 0x000fc400078e0033ULL,
0x0000004d4e4d1220ULL, 0x008fce0000410000ULL, 0x00000800010d7983ULL, 0x000ea20000100800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x012800006230783bULL, 0x000fe20000000200ULL,
0x0000004eff0c723eULL, 0x000fe200000010ffULL, 0x000000141500728cULL, 0x000fe2000bf06070ULL,
0x0000991034347816ULL, 0x000fe200000000ffULL, 0x0000000800047c82ULL, 0x000fe20008000000ULL,
0x000054100c387816ULL, 0x000fe2000000000cULL, 0x0000004b4d4b7221ULL, 0x000fe20000010000ULL,
0x000000ff3400720cULL, 0x000fe40003f25270ULL, 0x0000000963397c11ULL, 0x000fe2000f8e20ffULL,
0x00001f35380c7589ULL, 0x000e6200000e0000ULL, 0x000000096b4f7c11ULL, 0x000fc4000f8e20ffULL,
0x00000009607a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000003901007387ULL, 0x000fe20000100800ULL,
0x00000009727c7c11ULL, 0x000fe4000f8e20ffULL, 0x00000009747d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000007a3c783bULL, 0x000fe20000004200ULL, 0x000000096f7b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000096e777c11ULL, 0x000fe2000f8e20ffULL, 0x0000044f01007387ULL, 0x000fe20000100800ULL,
0x0000000973787c11ULL, 0x000fc4000f8e20ffULL, 0x00000009705d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000096c507c11ULL, 0x000fe4000f8e20ffULL, 0x000000095c5b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c31319232ULL, 0x082fe40000200000ULL, 0x0000000c33339232ULL, 0x000fe20000200000ULL,
0x000000090d797c11ULL, 0x004fe4000f8e20ffULL, 0x00001f36380d7589ULL, 0x000e6800000e0000ULL,
0x000000007940783bULL, 0x000ea80000004200ULL, 0x000000003938783bULL, 0x000ee20000004200ULL,
0x0000000d30309232ULL, 0x002fc40000200000ULL, 0x0000000d32329232ULL, 0x000fce0000200000ULL,
0x0000003c3018723cULL, 0x000fec0000041818ULL, 0x0000003e3014723cULL, 0x000fe20000041814ULL,
0x00000009763c7c11ULL, 0x000fca000f8e20ffULL, 0x000000403034723cULL, 0x004fe20000041820ULL,
0x000000004f20783bULL, 0x0002aa0000004200ULL, 0x000000383010723cULL, 0x008fe20000041810ULL,
0x0000000971407c11ULL, 0x000fe4000f8e20ffULL, 0x000000096d4f7c11ULL, 0x002fc6000f8e20ffULL,
0x0000003a3024723cULL, 0x000fe20000041824ULL, 0x012800006138783bULL, 0x000e680000000200ULL,
0x0000104001007387ULL, 0x000fe20000100800ULL, 0x00000042301c723cULL, 0x000fe6000004181cULL,
0x00000c3c01007387ULL, 0x000fe80000100800ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x000000203028723cULL, 0x004fec0000041828ULL, 0x000000223020723cULL, 0x000fe2000004182cULL,
0x000000007c2c783bULL, 0x000ea80000004200ULL, 0x000000004030783bULL, 0x0009620000004200ULL,
0x0000000d38389232ULL, 0x002fc40000200000ULL, 0x0000000d3a3a9232ULL, 0x000fe40000200000ULL,
0x0000000c39399232ULL, 0x080fe40000200000ULL, 0x0000000c3b3b9232ULL, 0x000fe20000200000ULL,
0x0000000975407c11ULL, 0x010fca000f8e20ffULL, 0x0000144001007387ULL, 0x000fe20000100800ULL,
0x0000003c3810723cULL, 0x008fec0000041810ULL, 0x0000003e3824723cULL, 0x000fec0000041824ULL,
0x0000002c3834723cULL, 0x004fec0000041834ULL, 0x0000002e381c723cULL, 0x000fe2000004181cULL,
0x00000000402c783bULL, 0x0002aa0000004200ULL, 0x000000303818723cULL, 0x020fe20000041818ULL,
0x00000001ff407424ULL, 0x002fca00078e00ffULL, 0x000000323814723cULL, 0x000fe20000041814ULL,
0x000000007b30783bULL, 0x000fea0000004200ULL, 0x0000002c3828723cULL, 0x004fec0000041828ULL,
0x0000002e3838723cULL, 0x000fe20000041820ULL, 0x012800005f20783bULL, 0x000e680000000200ULL,
0x000000007d2c783bULL, 0x000ea40000004200ULL, 0x0000000d20209232ULL, 0x002fc40000200000ULL,
0x0000000d22229232ULL, 0x000fe40000200000ULL, 0x0000000c21219232ULL, 0x080fe40000200000ULL,
0x0000000c23239232ULL, 0x000fce0000200000ULL, 0x0000002c2018723cULL, 0x004fec0000041818ULL,
0x0000002e2014723cULL, 0x000fe20000041814ULL, 0x00000000772c783bULL, 0x000e6a0000004200ULL,
0x000000302034723cULL, 0x000fec0000041834ULL, 0x00000032201c723cULL, 0x000fe2000004181cULL,
0x000000007830783bULL, 0x000eaa0000004200ULL, 0x0000002c2028723cULL, 0x002fec0000041828ULL,
0x0000002e2038723cULL, 0x000fe20000041838ULL, 0x012800005e2c783bULL, 0x000e6a0000000200ULL,
0x000000302010723cULL, 0x004fec0000041810ULL, 0x000000322024723cULL, 0x000fe20000041824ULL,
0x000000005d30783bULL, 0x000ea20000004200ULL, 0x0000000d2c2c9232ULL, 0x002fc40000200000ULL,
0x0000000d2e2e9232ULL, 0x000fe40000200000ULL, 0x0000000c2d2d9232ULL, 0x080fe40000200000ULL,
0x0000000c2f2f9232ULL, 0x000fe20000200000ULL, 0x000000000000781cULL, 0x000fcc0003f2f008ULL,
0x000000302c20723cULL, 0x004fe20000041834ULL, 0x000000005b34783bULL, 0x000e6a0000004200ULL,
0x000000322c1c723cULL, 0x000fe2000004181cULL, 0x000000005030783bULL, 0x000eaa0000004200ULL,
0x000000342c18723cULL, 0x002fec0000041818ULL, 0x000000302c10723cULL, 0x004fec0000041810ULL,
0x000000322c24723cULL, 0x000fe20000041824ULL, 0x000000004f30783bULL, 0x000e620000004200ULL,
0x02462040ffff79a7ULL, 0x0005e80008500006ULL, 0x000000362c14723cULL, 0x000fec0000041814ULL,
0x000000302c28723cULL, 0x002fec0000041828ULL, 0x000000322c2c723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000002c000c1947ULL, 0x004fde0003800000ULL,
0x000000c00b047890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000012071372a4ULL, 0x000fe2000f8e0204ULL, 0x0000000400a48947ULL, 0x000ff60003800000ULL,
0x000000041400728cULL, 0x000fe4000bf01070ULL, 0x80000004ff0c7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001302317c36ULL, 0x000fe20008000000ULL, 0x00000004140b7287ULL, 0x000fe2000c000000ULL,
0x0000001344337c36ULL, 0x000fe40008000000ULL, 0x0000020031307825ULL, 0x000fc800078e000eULL,
0x0000000bff0d7e24ULL, 0x000fe4000f8e00ffULL, 0x000000100b307825ULL, 0x000fc600078e0030ULL,
0x000000400d0c7446ULL, 0x000fe2000380000cULL, 0x0000001303357c36ULL, 0x000fe20008000000ULL,
0x00000009680d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000c0200720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000300d7faeULL, 0x0003e2000c101c4cULL,
0x0000000c4400720cULL, 0x000fe20003f06070ULL, 0x0000020033307825ULL, 0x002fe200078e000eULL,
0x0000000967337c11ULL, 0x000fe4000f8e20ffULL, 0x00000009660d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100b307825ULL, 0x000fd000078e0030ULL, 0x0000000030337faeULL, 0x0003e2000c101c4cULL,
0x0000000c0300720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x0000000965337c11ULL, 0x000fc6000f8e20ffULL, 0x0000001304357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c4cULL,
0x0000000c0400720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x0000001305357c10ULL, 0x000fe4000fffe0ffULL, 0x00000009640d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100b307825ULL, 0x000fd000078e0030ULL, 0x0000000030337faeULL, 0x0003e2000c101c4cULL,
0x0000000c0500720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x000000095a337c11ULL, 0x000fc6000f8e20ffULL, 0x0000001306357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c4cULL,
0x0000000c0600720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x00000009590d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000001307357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x0000000030337faeULL, 0x0003e2000c101c4cULL,
0x0000000c0700720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x0000000958337c11ULL, 0x000fc6000f8e20ffULL, 0x0000001308357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c4cULL,
0x0000000c0800720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x00000009570d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000001309357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x0000000030337faeULL, 0x0003e2000c101c4cULL,
0x0000000c0900720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x0000000956337c11ULL, 0x000fc6000f8e20ffULL, 0x000000130a357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c4cULL,
0x0000000c0a00720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x0000001345357c10ULL, 0x000fe4000fffe0ffULL, 0x00000009550d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000100b307825ULL, 0x000fd000078e0030ULL, 0x0000000030337faeULL, 0x0003e2000c101c4cULL,
0x0000000c4500720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x0000000954337c11ULL, 0x000fc6000f8e20ffULL, 0x0000001349357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c4cULL,
0x0000000c4900720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x00000009530d7c11ULL, 0x000fc6000f8e20ffULL, 0x0000001348357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x0000000030337faeULL, 0x0003e2000c101c4cULL,
0x0000000c4800720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x0000000952337c11ULL, 0x000fc6000f8e20ffULL, 0x0000001347357c36ULL, 0x000fe40008000000ULL,
0x000000100b307825ULL, 0x000fcc00078e0030ULL, 0x00000000300d7faeULL, 0x0003e2000c101c4cULL,
0x0000000c4700720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fc800078e000eULL,
0x0000001346357c36ULL, 0x000fe40008000000ULL, 0x000000100b307825ULL, 0x000fc800078e0030ULL,
0x000000134a0d7c36ULL, 0x000fe40008000000ULL, 0x0000000030337faeULL, 0x0003e2000c101c4cULL,
0x0000000c4600720cULL, 0x000fe20003f06070ULL, 0x0000020035307825ULL, 0x002fe200078e000eULL,
0x0000000951357c11ULL, 0x000fe4000f8e20ffULL, 0x0000000969337c11ULL, 0x000fe2000f8e20ffULL,
0x000000100b307825ULL, 0x000fd000078e0030ULL, 0x0000000030357faeULL, 0x0003e2000c101c4cULL,
0x0000000c4a00720cULL, 0x000fe20003f06070ULL, 0x000002000d0c7825ULL, 0x000fc800078e000eULL,
0x000000100b0c7825ULL, 0x000fd000078e000cULL, 0x000000000c337faeULL, 0x0003e2000c101c4cULL,
0x00000004004c7947ULL, 0x000fea0003800000ULL, 0x00000013020d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001344337c36ULL, 0x000fe20008000000ULL, 0x0000000968317c11ULL, 0x000fe2000f8e20ffULL,
0x0000001303357c36ULL, 0x000fe40008000000ULL, 0x000002000d0c7825ULL, 0x000fc800078e000eULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c317faeULL, 0x0003e4000b901c4cULL, 0x00000200330c7825ULL, 0x002fe200078e000eULL,
0x0000000967337c11ULL, 0x000fc6000f8e20ffULL, 0x0000001304317c36ULL, 0x000fe40008000000ULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c337faeULL, 0x0003e4000b901c4cULL,
0x00000200350c7825ULL, 0x002fe200078e000eULL, 0x0000000966357c11ULL, 0x000fc6000f8e20ffULL,
0x0000001305337c36ULL, 0x000fe40008000000ULL, 0x000000100b0c7825ULL, 0x000fca00078e000cULL,
0x000000000c357faeULL, 0x0003e4000b901c4cULL, 0x00000200310c7825ULL, 0x002fe200078e000eULL,
0x0000000965317c11ULL, 0x000fc6000f8e20ffULL, 0x0000001306357c36ULL, 0x000fe40008000000ULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c317faeULL, 0x0003e4000b901c4cULL,
0x00000200330c7825ULL, 0x002fe200078e000eULL, 0x0000000964337c11ULL, 0x000fe4000f8e20ffULL,
0x0000001307317c10ULL, 0x000fe2000fffe0ffULL, 0x000000100b0c7825ULL, 0x000fca00078e000cULL,
0x000000000c337faeULL, 0x0003e4000b901c4cULL, 0x00000200350c7825ULL, 0x002fe200078e000eULL,
0x000000095a357c11ULL, 0x000fc6000f8e20ffULL, 0x0000001308337c36ULL, 0x000fe40008000000ULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c357faeULL, 0x0003e4000b901c4cULL,
0x00000200310c7825ULL, 0x002fe200078e000eULL, 0x0000000959317c11ULL, 0x000fc6000f8e20ffULL,
0x0000001309357c36ULL, 0x000fe40008000000ULL, 0x000000100b0c7825ULL, 0x000fca00078e000cULL,
0x000000000c317faeULL, 0x0003e4000b901c4cULL, 0x00000200330c7825ULL, 0x002fe200078e000eULL,
0x0000000958337c11ULL, 0x000fc6000f8e20ffULL, 0x000000130a317c36ULL, 0x000fe40008000000ULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c337faeULL, 0x0003e4000b901c4cULL,
0x00000200350c7825ULL, 0x002fe200078e000eULL, 0x0000000957357c11ULL, 0x000fc6000f8e20ffULL,
0x0000001345337c36ULL, 0x000fe40008000000ULL, 0x000000100b0c7825ULL, 0x000fca00078e000cULL,
0x000000000c357faeULL, 0x0003e4000b901c4cULL, 0x00000200310c7825ULL, 0x002fe200078e000eULL,
0x0000000956317c11ULL, 0x000fc6000f8e20ffULL, 0x0000001349357c36ULL, 0x000fe40008000000ULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c317faeULL, 0x0003e4000b901c4cULL,
0x00000200330c7825ULL, 0x002fe200078e000eULL, 0x0000000955337c11ULL, 0x000fe4000f8e20ffULL,
0x0000001348317c10ULL, 0x000fe2000fffe0ffULL, 0x000000100b0c7825ULL, 0x000fca00078e000cULL,
0x000000000c337faeULL, 0x0003e4000b901c4cULL, 0x00000200350c7825ULL, 0x002fe200078e000eULL,
0x0000000954357c11ULL, 0x000fc6000f8e20ffULL, 0x0000001347337c36ULL, 0x000fe40008000000ULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c357faeULL, 0x0003e4000b901c4cULL,
0x00000200310c7825ULL, 0x002fe200078e000eULL, 0x0000000953317c11ULL, 0x000fc6000f8e20ffULL,
0x0000001346357c36ULL, 0x000fe40008000000ULL, 0x000000100b0c7825ULL, 0x000fca00078e000cULL,
0x000000000c317faeULL, 0x0003e4000b901c4cULL, 0x00000200330c7825ULL, 0x002fe200078e000eULL,
0x0000000952337c11ULL, 0x000fc6000f8e20ffULL, 0x000000134a317c36ULL, 0x000fe40008000000ULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c337faeULL, 0x0003e4000b901c4cULL,
0x00000200350c7825ULL, 0x002fe200078e000eULL, 0x0000000951357c11ULL, 0x000fc6000f8e20ffULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c357faeULL, 0x0003e4000b901c4cULL,
0x00000200310c7825ULL, 0x002fe200078e000eULL, 0x0000000969317c11ULL, 0x000fc6000f8e20ffULL,
0x000000100b0c7825ULL, 0x000fca00078e000cULL, 0x000000000c317faeULL, 0x0003e4000b901c4cULL,
0x0000001f11097899ULL, 0x000fe2000800063fULL, 0x00000000000079afULL, 0x000e2a0000000000ULL,
0x00000009ff0c7e24ULL, 0x002fc8000f8e00ffULL, 0x0246280cff0075a7ULL, 0x000e640008000146ULL,
0x000000cc00a88947ULL, 0x002fea0003800000ULL, 0x024100004c317984ULL, 0x000e620000000800ULL,
0x00000002ff3b7819ULL, 0x000fc6000001166aULL, 0x024300004c4d7984ULL, 0x0004a40000000800ULL,
0x000000083b3a7836ULL, 0x000fe20000000000ULL, 0x000000003100720bULL, 0x002fda0003f1d000ULL,
0x00000000000c7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0c307812ULL, 0x000fe2000780c0ffULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x0000000000d08947ULL, 0x004fea0003800000ULL,
0x000000003100720bULL, 0x000fe20003f14000ULL, 0x000000020e00788cULL, 0x000fe2000bf05270ULL,
0x00000031000d7209ULL, 0x000fca0007810000ULL, 0x8000000d00007221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fc60003f2f008ULL, 0x3fb8aa3b000c7820ULL, 0x000fe40000410000ULL,
0x0000000000007806ULL, 0x000fc800000e0100ULL, 0x0000000c000c7308ULL, 0x000e620000000800ULL,
0x0000ffff00337812ULL, 0x000fc600078e3cffULL, 0x0245000d4c009388ULL, 0x000fe20000000800ULL,
0x0000003330ff7212ULL, 0x000fc6000780c0ffULL, 0x00001f3b0c007589ULL, 0x002e6200000e0000ULL,
0x0000000c4b4b7220ULL, 0x000fd20000410000ULL, 0x8000000d31310221ULL, 0x000fe20000010000ULL,
0x00001f3a0c307589ULL, 0x0004e600000e0000ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x00000031004e0308ULL, 0x000f220000000800ULL, 0x00000001ff0c7807ULL, 0x004fe20000000000ULL,
0x0000000020207220ULL, 0x082fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x000fe20000410000ULL,
0x0000003022227220ULL, 0x088fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x0000003016167220ULL, 0x080fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x0000003012127220ULL, 0x080fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x000000302a2a7220ULL, 0x080fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302f2f7220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x000fc400078e000dULL, 0x0000004d4e4d0220ULL, 0x010fce0000410000ULL,
0x00000800010d7983ULL, 0x000ea20000300800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x013000006230783bULL, 0x000fe20000000200ULL, 0x000099100c0c7816ULL, 0x000fe200000000ffULL,
0x000000140400728cULL, 0x000fe2000bf06070ULL, 0x0000000a60607c11ULL, 0x000fe2000f8e20ffULL,
0x0000004b4d4b7221ULL, 0x000fe20000010000ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x0000001000047c82ULL, 0x000fe20008000000ULL, 0x0000004eff0c723eULL, 0x000fe400000010ffULL,
0x0000000a6b6b7c11ULL, 0x000fe4000f8e20ffULL, 0x000054100c397816ULL, 0x000fc4000000000cULL,
0x0000000a63637c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a76767c11ULL, 0x000fe2000f8e20ffULL,
0x00001f3b390c7589ULL, 0x000e6200000e0000ULL, 0x0000000a73737c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a74407c11ULL, 0x000fe2000f8e20ffULL, 0x00000000763c783bULL, 0x000fea0000004200ULL,
0x000000004040783bULL, 0x000fe20000004200ULL, 0x0000000c30308232ULL, 0x002fc40000200000ULL,
0x0000000c32328232ULL, 0x000fe20000200000ULL, 0x0000000a0d387c11ULL, 0x004fe4000f8e20ffULL,
0x00001f3a390d7589ULL, 0x000e6800000e0000ULL, 0x000000003834783bULL, 0x000ea80000004200ULL,
0x000000006338783bULL, 0x000ee20000004200ULL, 0x0000000d31318232ULL, 0x002fc40000200000ULL,
0x0000000d33338232ULL, 0x000fce0000200000ULL, 0x000000343020723cULL, 0x004fec0000041820ULL,
0x00000036301c723cULL, 0x000fe2000004181cULL, 0x000000006034783bULL, 0x0002aa0000004200ULL,
0x000000383010723cULL, 0x008fe20000041810ULL, 0x00000001ff607424ULL, 0x002fca00078e00ffULL,
0x0000003a3024723cULL, 0x000fe20000041824ULL, 0x0000000a72387c11ULL, 0x000fcc000f8e20ffULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x000000343018723cULL, 0x004fec0000041818ULL,
0x000000363014723cULL, 0x000fe20000041814ULL, 0x000000006b34783bULL, 0x000e6a0000004200ULL,
0x000000343028723cULL, 0x002fec0000041828ULL, 0x00000036302c723cULL, 0x000fe2000004182cULL,
0x013000006134783bULL, 0x000e6c0000000200ULL, 0x0000000a71307c11ULL, 0x000fcc000f8e20ffULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x0000000c34348232ULL, 0x082fe40000200000ULL,
0x0000000c36368232ULL, 0x000fe40000200000ULL, 0x0000000d35358232ULL, 0x080fe40000200000ULL,
0x0000000d37378232ULL, 0x000fce0000200000ULL, 0x000000383420723cULL, 0x000fec0000041820ULL,
0x0000003a341c723cULL, 0x000fe2000004181cULL, 0x0000000a75397c11ULL, 0x000fca000f8e20ffULL,
0x000000303418723cULL, 0x004fe20000041818ULL, 0x000000003938783bULL, 0x000e6a0000004200ULL,
0x000000323414723cULL, 0x000fe20000041814ULL, 0x013000005f30783bULL, 0x000eaa0000000200ULL,
0x0000003c3410723cULL, 0x000fec0000041810ULL, 0x0000003e3424723cULL, 0x000fe20000041824ULL,
0x0000000a6f3c7c11ULL, 0x000fcc000f8e20ffULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x000000383428723cULL, 0x002fec0000041828ULL, 0x0000003a3434723cULL, 0x000fe2000004182cULL,
0x0000000a6e387c11ULL, 0x000fe2000f8e20ffULL, 0x00000000732c783bULL, 0x000e620000004200ULL,
0x0000000c30308232ULL, 0x004fc40000200000ULL, 0x0000000c32328232ULL, 0x000fe40000200000ULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x0000000d31318232ULL, 0x080fe40000200000ULL,
0x0000000d33338232ULL, 0x000fce0000200000ULL, 0x000000403018723cULL, 0x000fec0000041818ULL,
0x0000003c3020723cULL, 0x008fe20000041820ULL, 0x0000000a70417c11ULL, 0x000fca000f8e20ffULL,
0x0000003e301c723cULL, 0x000fe2000004181cULL, 0x0000000a5c3c7c11ULL, 0x000fca000f8e20ffULL,
0x000000423014723cULL, 0x000fe20000041814ULL, 0x000000004140783bULL, 0x000fe80000004200ULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0x0000002c3010723cULL, 0x002fec0000041810ULL,
0x0000002e3024723cULL, 0x000fe20000041824ULL, 0x013000005e2c783bULL, 0x000e6a0000000200ULL,
0x000000383028723cULL, 0x004fec0000041828ULL, 0x0000003a3030723cULL, 0x000fe20000041834ULL,
0x0000000a6c387c11ULL, 0x000fcc000f8e20ffULL, 0x0000000a6d347c11ULL, 0x000fe2000f8e20ffULL,
0x000000003838783bULL, 0x000eaa0000004200ULL, 0x000000003434783bULL, 0x000ee20000004200ULL,
0x02463060ffff79a7ULL, 0x0009e20008500006ULL, 0x0000000c2c2c8232ULL, 0x082fe40000200000ULL,
0x0000000c2e2e8232ULL, 0x000fc40000200000ULL, 0x0000000d2d2d8232ULL, 0x080fe40000200000ULL,
0x0000000d2f2f8232ULL, 0x000fe20000200000ULL, 0x000000000000781cULL, 0x000fcc0003f0f008ULL,
0x000000402c20723cULL, 0x000fec0000041820ULL, 0x000000422c1c723cULL, 0x000fec000004181cULL,
0x0000003c2c18723cULL, 0x000fec0000041818ULL, 0x0000003e2c14723cULL, 0x000fec0000041814ULL,
0x000000382c10723cULL, 0x004fec0000041810ULL, 0x0000003a2c24723cULL, 0x000fec0000041824ULL,
0x000000342c28723cULL, 0x008fec0000041828ULL, 0x000000362c2c723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000001400740947ULL, 0x010fde0003800000ULL,
0x0000400001607983ULL, 0x000ea20000100800ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000600472caULL, 0x004fda00000e0000ULL, 0x000000040f047290ULL, 0x000fc8000fffe03fULL,
0x0000000104097890ULL, 0x000fe4000fffe03fULL, 0x0000000804047899ULL, 0x000fe4000800063fULL,
0x000000050900728cULL, 0x000fe4000bf06070ULL, 0x00000012070972a4ULL, 0x000fc8000f8e0204ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000400a48947ULL, 0x000fea0003800000ULL,
0x000000041400728cULL, 0x000fe4000bf01070ULL, 0x80000004ff427e24ULL, 0x000fe2000f8e02ffULL,
0x0000000a68337c11ULL, 0x000fe2000f8e20ffULL, 0x0000000944317c36ULL, 0x000fe20008000000ULL,
0x00000004140b7287ULL, 0x000fe2000c000000ULL, 0x0000000903417c36ULL, 0x000fe20008000000ULL,
0x0000000a67677c11ULL, 0x000fe2000f8e20ffULL, 0x0000020031307825ULL, 0x000fe200078e000eULL,
0x00000009063b7c10ULL, 0x000fe4000fffe0ffULL, 0x0000000b000d7c02ULL, 0x000fe20008000f00ULL,
0x00000009043f7c36ULL, 0x000fe20008000000ULL, 0x0000000a66667c11ULL, 0x000fe2000f8e20ffULL,
0x000000100b307825ULL, 0x000fe200078e0030ULL, 0x000000400d427446ULL, 0x000fc40003800042ULL,
0x0000000a65657c11ULL, 0x000fe2000f8e20ffULL, 0x00000009020d7c36ULL, 0x040fe20008000000ULL,
0x000000420200720cULL, 0x080fe20003f06070ULL, 0x00000009053d7c36ULL, 0x000fe20008000000ULL,
0x000000424400720cULL, 0x080fe20003f26070ULL, 0x000002000d0c7825ULL, 0x100fe200078e000eULL,
0x000000420300720cULL, 0x080fe40003f86070ULL, 0x000000420400720cULL, 0x080fe20003fa6070ULL,
0x0000020041407825ULL, 0x000fe200078e000eULL, 0x000000420500720cULL, 0x000fc40003fc6070ULL,
0x000000420800720cULL, 0x080fe20003f46070ULL, 0x000000100b0c7825ULL, 0x000fe200078e000cULL,
0x000000420900720cULL, 0x080fe40003f66070ULL, 0x0000000a59597c11ULL, 0x000fe2000f8e20ffULL,
0x0000000907397c36ULL, 0x000fe20008000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c337faeULL, 0x0003e2000c101c4cULL, 0x000000420600720cULL, 0x080fe20003f06070ULL,
0x0000000908377c36ULL, 0x000fe20008000000ULL, 0x0000000a57577c11ULL, 0x000fe2000f8e20ffULL,
0x0000000030677faeULL, 0x0005e2000c901c4cULL, 0x000002003f3e7825ULL, 0x000fe200078e000eULL,
0x000000420700720cULL, 0x000fc40003f26070ULL, 0x0000000a55557c11ULL, 0x000fe2000f8e20ffULL,
0x0000000909357c36ULL, 0x000fe20008000000ULL, 0x0000000a64097c11ULL, 0x000fe2000f8e20ffULL,
0x000002003d3c7825ULL, 0x000fe200078e000eULL, 0x0000000949337c10ULL, 0x002fe4000fffe0ffULL,
0x0000000a53537c11ULL, 0x000fe2000f8e20ffULL, 0x0000000945057c36ULL, 0x000fe20008000000ULL,
0x0000000a51517c11ULL, 0x000fe2000f8e20ffULL, 0x000000090a317c36ULL, 0x004fe20008000000ULL,
0x0000000a69697c11ULL, 0x000fe2000f8e20ffULL, 0x0000000948037c36ULL, 0x000fc40008000000ULL,
0x00000009470d7c36ULL, 0x000fe40008000000ULL, 0x0000000946077c36ULL, 0x000fe40008000000ULL,
0x000002003b3a7825ULL, 0x000fc800078e000eULL, 0x000000094a437c36ULL, 0x000fe40008000000ULL,
0x0000020039387825ULL, 0x000fc800078e000eULL, 0x0000020037367825ULL, 0x000fc800078e000eULL,
0x000000100b407825ULL, 0x000fc800078e0040ULL, 0x0000020035347825ULL, 0x100fe200078e000eULL,
0x0000000040667faeULL, 0x0003e2000e101c4cULL, 0x000000420a00720cULL, 0x000fe40003f86070ULL,
0x0000020031307825ULL, 0x000fc800078e000eULL, 0x0000020005047825ULL, 0x000fc800078e000eULL,
0x0000020033327825ULL, 0x000fe200078e000eULL, 0x0000000a58417c11ULL, 0x002fc6000f8e20ffULL,
0x0000020003027825ULL, 0x000fc800078e000eULL, 0x000002000d0c7825ULL, 0x000fc800078e000eULL,
0x0000020007067825ULL, 0x000fc800078e000eULL, 0x000000100b3e7825ULL, 0x000fc800078e003eULL,
0x00000200430e7825ULL, 0x000fe200078e000eULL, 0x0000000a5a437c11ULL, 0x000fe2000f8e20ffULL,
0x000000003e657faeULL, 0x000fe2000e901c4cULL, 0x000000424500720cULL, 0x000fe20003fa6070ULL,
0x000000100b3c7825ULL, 0x000fc800078e003cULL, 0x000000100b3a7825ULL, 0x000fe200078e003aULL,
0x000000003c097faeULL, 0x0005e2000f101c4cULL, 0x000000424900720cULL, 0x080fe40003fc6070ULL,
0x000000100b387825ULL, 0x040fe200078e0038ULL, 0x000000003a437faeULL, 0x000fe2000c101c4cULL,
0x000000424800720cULL, 0x080fe40003f06070ULL, 0x000000100b367825ULL, 0x000fe200078e0036ULL,
0x0000000038597faeULL, 0x000fe2000c901c4cULL, 0x000000424700720cULL, 0x000fc40003f26070ULL,
0x000000100b347825ULL, 0x040fe200078e0034ULL, 0x0000000036417faeULL, 0x000fe2000d101c4cULL,
0x000000424600720cULL, 0x080fe40003f46070ULL, 0x0000000a56097c11ULL, 0x004fe2000f8e20ffULL,
0x0000000034577faeULL, 0x0005e2000d901c4cULL, 0x000000424a00720cULL, 0x000fe20003f66070ULL,
0x000000100b307825ULL, 0x000fc800078e0030ULL, 0x000000100b047825ULL, 0x040fe200078e0004ULL,
0x0000000030097faeULL, 0x0003e6000e101c4cULL, 0x000000100b327825ULL, 0x040fe200078e0032ULL,
0x0000000004557faeULL, 0x0003e2000e901c4cULL, 0x0000000a52357c11ULL, 0x004fe4000f8e20ffULL,
0x000000100b027825ULL, 0x000fc800078e0002ULL, 0x000000100b0c7825ULL, 0x000fc800078e000cULL,
0x000000100b067825ULL, 0x000fc800078e0006ULL, 0x000000100b0e7825ULL, 0x000fe200078e000eULL,
0x0000000a540b7c11ULL, 0x000fca000f8e20ffULL, 0x00000000320b7faeULL, 0x0003e8000f101c4cULL,
0x0000000002537faeULL, 0x0003e8000c101c4cULL, 0x000000000c357faeULL, 0x0003e8000c901c4cULL,
0x0000000006517faeULL, 0x0003e8000d101c4cULL, 0x000000000e697faeULL, 0x0003e2000d901c4cULL,
0x00000004004c7947ULL, 0x000fea0003800000ULL, 0x00000009440d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000903397c36ULL, 0x000fe20008000000ULL, 0x0000000908037c10ULL, 0x000fe2000fffe0ffULL,
0x0000000909377c36ULL, 0x000fe20008000000ULL, 0x0000000947477c10ULL, 0x000fe2000fffe0ffULL,
0x00000009073b7c36ULL, 0x000fe20008000000ULL, 0x0000000a68687c11ULL, 0x000fe2000f8e20ffULL,
0x0000000948097c36ULL, 0x000fe20008000000ULL, 0x0000000a67677c11ULL, 0x000fe2000f8e20ffULL,
0x0000000902437c36ULL, 0x000fe20008000000ULL, 0x0000000a65657c11ULL, 0x000fe2000f8e20ffULL,
0x0000000904417c36ULL, 0x000fe20008000000ULL, 0x0000000a59597c11ULL, 0x000fe2000f8e20ffULL,
0x00000009053f7c36ULL, 0x000fe20008000000ULL, 0x0000000a57577c11ULL, 0x000fe2000f8e20ffULL,
0x00000009063d7c36ULL, 0x000fe20008000000ULL, 0x0000000a55557c11ULL, 0x000fe2000f8e20ffULL,
0x000000090a357c36ULL, 0x000fe20008000000ULL, 0x0000000a53537c11ULL, 0x000fe2000f8e20ffULL,
0x0000000945337c36ULL, 0x000fe20008000000ULL, 0x0000000a51517c11ULL, 0x000fe2000f8e20ffULL,
0x0000000949317c36ULL, 0x000fe20008000000ULL, 0x0000000a56497c11ULL, 0x000fe2000f8e20ffULL,
0x0000000946077c36ULL, 0x000fe20008000000ULL, 0x0000000a69697c11ULL, 0x000fe2000f8e20ffULL,
0x000000094a457c36ULL, 0x000fc40008000000ULL, 0x000002000d047825ULL, 0x000fc800078e000eULL,
0x00000200030c7825ULL, 0x000fc800078e000eULL, 0x0000020009027825ULL, 0x000fc800078e000eULL,
0x0000020043427825ULL, 0x000fc800078e000eULL, 0x0000020039387825ULL, 0x000fc800078e000eULL,
0x0000020041407825ULL, 0x000fc800078e000eULL, 0x000002003f3e7825ULL, 0x000fc800078e000eULL,
0x000002003d3c7825ULL, 0x000fc800078e000eULL, 0x000002003b3a7825ULL, 0x000fc800078e000eULL,
0x0000020037367825ULL, 0x000fc800078e000eULL, 0x0000020035347825ULL, 0x000fc800078e000eULL,
0x0000020033327825ULL, 0x000fc800078e000eULL, 0x0000020031307825ULL, 0x000fc800078e000eULL,
0x0000020047087825ULL, 0x000fe200078e000eULL, 0x0000000a5a477c11ULL, 0x000fc6000f8e20ffULL,
0x0000020007067825ULL, 0x000fc800078e000eULL, 0x00000200450e7825ULL, 0x000fe200078e000eULL,
0x0000000a64457c11ULL, 0x000fc6000f8e20ffULL, 0x000000100b427825ULL, 0x000fc800078e0042ULL,
0x000000100b047825ULL, 0x040fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042687faeULL, 0x0003e6000b901c4cULL, 0x000000100b387825ULL, 0x040fe200078e0038ULL,
0x0000000004677faeULL, 0x0005e6000b901c4cULL, 0x000000100b407825ULL, 0x000fc800078e0040ULL,
0x000000100b3e7825ULL, 0x000fe200078e003eULL, 0x0000000a58437c11ULL, 0x002fc6000f8e20ffULL,
0x000000100b3c7825ULL, 0x000fe200078e003cULL, 0x0000000a54057c11ULL, 0x004fc6000f8e20ffULL,
0x000000100b3a7825ULL, 0x000fc800078e003aULL, 0x000000100b0c7825ULL, 0x000fc800078e000cULL,
0x000000100b367825ULL, 0x000fc800078e0036ULL, 0x000000100b347825ULL, 0x000fc800078e0034ULL,
0x000000100b327825ULL, 0x000fc800078e0032ULL, 0x000000100b307825ULL, 0x000fc800078e0030ULL,
0x000000100b027825ULL, 0x000fc800078e0002ULL, 0x000000100b087825ULL, 0x000fc800078e0008ULL,
0x000000100b067825ULL, 0x000fc800078e0006ULL, 0x000000100b0e7825ULL, 0x000fe200078e000eULL,
0x0000000a660b7c11ULL, 0x000fca000f8e20ffULL, 0x00000000380b7faeULL, 0x0003e8000b901c4cULL,
0x0000000040657faeULL, 0x0005e8000b901c4cULL, 0x000000003e457faeULL, 0x0005e8000b901c4cULL,
0x000000003c477faeULL, 0x0005e2000b901c4cULL, 0x0000000a520b7c11ULL, 0x002fc6000f8e20ffULL,
0x000000003a597faeULL, 0x0005e8000b901c4cULL, 0x000000000c437faeULL, 0x0005e8000b901c4cULL,
0x0000000036577faeULL, 0x0005e8000b901c4cULL, 0x0000000034497faeULL, 0x0005e8000b901c4cULL,
0x0000000032557faeULL, 0x0005e8000b901c4cULL, 0x0000000030057faeULL, 0x0005e8000b901c4cULL,
0x0000000002537faeULL, 0x0005e8000b901c4cULL, 0x00000000080b7faeULL, 0x0005e8000b901c4cULL,
0x0000000006517faeULL, 0x0005e8000b901c4cULL, 0x000000000e697faeULL, 0x0005e4000b901c4cULL,
0x0000001f11047899ULL, 0x000fe2000800063fULL, 0x00000000000079afULL, 0x000e2a0000000000ULL,
0x00000004ff027e24ULL, 0x006fc8000f8e00ffULL, 0x02463802ff0075a7ULL, 0x000e640008000146ULL,
0x000000b800188947ULL, 0x002fea0003800000ULL, 0x024180004c037984ULL, 0x000e620000000800ULL,
0x00000002ff0f7819ULL, 0x000fe4000001166aULL, 0x0000000100057802ULL, 0x000fc60000000f00ULL,
0x000000080f0e7836ULL, 0x000fe20000000000ULL, 0x000000000300720bULL, 0x002fda0003f1d000ULL,
0x0000000000027806ULL, 0x000fc800000e0100ULL, 0x0000ffff02067812ULL, 0x000fe4000780c0ffULL,
0x024380004c027984ULL, 0x0002b60000000800ULL, 0x0000000000d08947ULL, 0x002fea0003800000ULL,
0x000000000300720bULL, 0x000fe20003f14000ULL, 0x000000030e00788cULL, 0x000fe2000bf05270ULL,
0x0000000300077209ULL, 0x000fca0007810000ULL, 0x8000000700047221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fc60003f2f008ULL, 0x3fb8aa3b04047820ULL, 0x000fe40000410000ULL,
0x0000000000007806ULL, 0x000fc800000e0100ULL, 0x0000ffff00057812ULL, 0x000fe200078e3cffULL,
0x0000000400047308ULL, 0x000e660000000800ULL, 0x0000000506ff7212ULL, 0x000fe2000780c0ffULL,
0x024580074c009388ULL, 0x000fe80000000800ULL, 0x00001f0f04007589ULL, 0x002e7000000e0000ULL,
0x8000000703050221ULL, 0x000fe20000010000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x00001f0e04037589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x00000005004e0308ULL, 0x0009640000000800ULL, 0x00000001ff057807ULL, 0x010fe20000000000ULL,
0x0000000020207220ULL, 0x082fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x000fe20000410000ULL,
0x0000000322227220ULL, 0x088fe20000410000ULL, 0x0000000323237220ULL, 0x080fe20000410000ULL,
0x000000031e1e7220ULL, 0x080fe20000410000ULL, 0x000000031f1f7220ULL, 0x080fe20000410000ULL,
0x000000031a1a7220ULL, 0x080fe20000410000ULL, 0x000000031b1b7220ULL, 0x080fe20000410000ULL,
0x0000000316167220ULL, 0x080fe20000410000ULL, 0x0000000317177220ULL, 0x080fe20000410000ULL,
0x0000000312127220ULL, 0x080fe20000410000ULL, 0x0000000313137220ULL, 0x080fe20000410000ULL,
0x0000000326267220ULL, 0x080fe20000410000ULL, 0x0000000327277220ULL, 0x080fe20000410000ULL,
0x000000032a2a7220ULL, 0x080fe20000410000ULL, 0x000000032b2b7220ULL, 0x080fe20000410000ULL,
0x000000032e2e7220ULL, 0x080fe20000410000ULL, 0x000000032f2f7220ULL, 0x000fe20000410000ULL,
0x000000ffff007224ULL, 0x000fc400078e0007ULL, 0x000000024e020220ULL, 0x024fce0000410000ULL,
0x00000000010d7983ULL, 0x000ee20000300800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000400010c7983ULL, 0x000f280000300800ULL, 0x0000100001417983ULL, 0x000f680000300800ULL,
0x00000c0001407983ULL, 0x004ea80000300800ULL, 0x0000140001077983ULL, 0x000ea20000300800ULL,
0x0000004eff03723eULL, 0x000fe200000010ffULL, 0x0000004b024b7221ULL, 0x000fe20000010000ULL,
0x0000991005057816ULL, 0x000fe200000000ffULL, 0x013800006230783bULL, 0x000fe20000000200ULL,
0x0000541003067816ULL, 0x000fe20000000003ULL, 0x0000000800047c82ULL, 0x000fe20008000000ULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x00000000793c783bULL, 0x000fe20000004200ULL,
0x00000001ff057424ULL, 0x000fc600078e00ffULL, 0x000000007a08783bULL, 0x000fe80000004200ULL,
0x00001f0f06047589ULL, 0x000e6800000e0000ULL, 0x00001f0e06037589ULL, 0x000e6800000e0000ULL,
0x013800006160783bULL, 0x000e680000000200ULL, 0x000000007c38783bULL, 0x000e680000004200ULL,
0x000000007b44783bULL, 0x000fe80000004200ULL, 0x000000007d54783bULL, 0x000fe80000004200ULL,
0x000000005b58783bULL, 0x000fe20000004200ULL, 0x0000000430308232ULL, 0x002fc60000200000ULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x0000000432328232ULL, 0x000fe40000200000ULL,
0x0000000331318232ULL, 0x080fe40000200000ULL, 0x0000000333338232ULL, 0x000fce0000200000ULL,
0x0000003c3020723cULL, 0x000fec0000041820ULL, 0x0000003e301c723cULL, 0x000fe2000004181cULL,
0x0000000460608232ULL, 0x080fe40000200000ULL, 0x0000000462628232ULL, 0x000fe40000200000ULL,
0x0000000361618232ULL, 0x080fe20000200000ULL, 0x00000008303c723cULL, 0x000fe20000041818ULL,
0x0000000363638232ULL, 0x000fca0000200000ULL, 0x0000000a3008723cULL, 0x000fd80000041814ULL,
0x0000003a601c723cULL, 0x000fe2000004181cULL, 0x000000000d34783bULL, 0x008e680000004200ULL,
0x000000000c0c783bULL, 0x010ee80000004200ULL, 0x000000004118783bULL, 0x020f220000004200ULL,
0x000000343014723cULL, 0x002fe60000041810ULL, 0x000000004010783bULL, 0x004e680000004200ULL,
0x013800005f40783bULL, 0x000ea20000000200ULL, 0x000000363024723cULL, 0x000fe60000041824ULL,
0x000000000734783bULL, 0x000f660000004200ULL, 0x0000000c3028723cULL, 0x008fec0000041828ULL,
0x0000000e300c723cULL, 0x000fe2000004182cULL, 0x013800005e2c783bULL, 0x000ee80000000200ULL,
0x000000005d5c783bULL, 0x000fe20000004200ULL, 0x000000386030723cULL, 0x000fe60000041820ULL,
0x000000007820783bULL, 0x000ee60000004200ULL, 0x00000018603c723cULL, 0x010fe2000004183cULL,
0x000000007738783bULL, 0x000f2a0000004200ULL, 0x0000001a6008723cULL, 0x000fec0000041808ULL,
0x000000106014723cULL, 0x002fe20000041814ULL, 0x0000000440408232ULL, 0x004fc40000200000ULL,
0x0000000442428232ULL, 0x000fc60000200000ULL, 0x000000126024723cULL, 0x000fe20000041824ULL,
0x0000000341418232ULL, 0x080fe40000200000ULL, 0x0000000343438232ULL, 0x000fc60000200000ULL,
0x000000346028723cULL, 0x020fe20000041828ULL, 0x000000042c2c8232ULL, 0x008fca0000200000ULL,
0x000000366034723cULL, 0x000fe2000004180cULL, 0x000000004f0c783bULL, 0x000e620000004200ULL,
0x000000042e2e8232ULL, 0x000fe20000200000ULL, 0x02464005ffff79a7ULL, 0x0005e20008500006ULL,
0x000000032d2d8232ULL, 0x080fe40000200000ULL, 0x000000444030723cULL, 0x000fe20000041830ULL,
0x000000032f2f8232ULL, 0x000fca0000200000ULL, 0x00000046401c723cULL, 0x000fec000004181cULL,
0x00000054403c723cULL, 0x000fec000004183cULL, 0x000000564008723cULL, 0x000fec0000041808ULL,
0x000000204010723cULL, 0x000fec0000041814ULL, 0x000000224024723cULL, 0x000fec0000041824ULL,
0x000000384028723cULL, 0x010fec0000041828ULL, 0x0000003a4034723cULL, 0x000fec0000041834ULL,
0x0000005c2c20723cULL, 0x000fec0000041830ULL, 0x0000005e2c1c723cULL, 0x000fec000004181cULL,
0x000000582c18723cULL, 0x000fec000004183cULL, 0x0000005a2c14723cULL, 0x000fec0000041808ULL,
0x000000502c10723cULL, 0x000fec0000041810ULL, 0x000000522c24723cULL, 0x000fec0000041824ULL,
0x0000000c2c28723cULL, 0x002fec0000041828ULL, 0x0000000e2c2c723cULL, 0x004fde0000041834ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000180001037983ULL, 0x000ea80000300800ULL,
0x0000400001027983ULL, 0x000ee20000300800ULL, 0x000000ff03ff7812ULL, 0x004fe2000780c0ffULL,
0x0000000f02027c36ULL, 0x008fca0008000000ULL, 0x0000400201007387ULL, 0x0003e20000100800ULL,
0x0000000502007c0cULL, 0x000fe4000bf26070ULL, 0x00000001ff027807ULL, 0x002fca0000000000ULL,
0x0000180201007387ULL, 0x0003ec0000100600ULL, 0xffffff98000c9947ULL, 0x002fea000383ffffULL,
0x00000000001279c3ULL, 0x000e620000002500ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0010ULL,
0x00000017000f7202ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0016ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0015ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0014ULL,
0x000000051200728cULL, 0x002fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000cc0947ULL, 0x000fea0003800000ULL, 0x018000004b027836ULL, 0x000fca0000000000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e004bULL,
0x000088c000057802ULL, 0x000fce0000000f00ULL, 0x000000b4001c7944ULL, 0x000fea0003c00000ULL,
0x0000000400027202ULL, 0x000fe20000000f00ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000004b00027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc8000000004bULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fce0000000002ULL,
0x0000000000057919ULL, 0x000ea40000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0302037589ULL, 0x000ea800000e0000ULL, 0x00001f0502057589ULL, 0x000ee200000e0000ULL,
0x0000002003207220ULL, 0x044fe20000410000ULL, 0x0000002103217220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x040fe20000410000ULL,
0x0000001803187220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000000a030a7220ULL, 0x040fe20000410000ULL, 0x0000000c030c7220ULL, 0x040fe20000410000ULL,
0x0000000e030e7220ULL, 0x040fe20000410000ULL, 0x0000001103117220ULL, 0x040fe20000410000ULL,
0x0000002403247220ULL, 0x040fe20000410000ULL, 0x0000002503257220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000002903297220ULL, 0x040fe20000410000ULL,
0x0000002c032c7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x000fe20000410000ULL,
0x0000002205227220ULL, 0x048fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000000f050f7220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001305137220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x000fce0000410000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x000000060e067291ULL, 0x000fe2000f8e583fULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x000000010f00788cULL, 0x000fe2000bf05270ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0001200006137890ULL, 0x000fe2000fffe03fULL,
0x0000001e1f0d723eULL, 0x000fe400000010ffULL, 0x000000121310723eULL, 0x000fe400000010ffULL,
0x000000000000781cULL, 0x000fc40003f0f008ULL, 0x0000002a2b12723eULL, 0x000fe400000010ffULL,
0x0000002e2f13723eULL, 0x000fe400000010ffULL, 0x00000003ff037819ULL, 0x004fe40000011602ULL,
0xfffffff8ff057812ULL, 0x000fe400078ee202ULL, 0x0000000303047812ULL, 0x000fc600078ec0ffULL,
0x0000000805097836ULL, 0x040fe20000000000ULL, 0x0000000404087812ULL, 0x000fe200078efcffULL,
0x0000000805067824ULL, 0x000fe200078e00ffULL, 0x0000000704077812ULL, 0x000fe400078e7805ULL,
0x00000007040b7812ULL, 0x000fe200078e7809ULL, 0x0000000809047824ULL, 0x000fe200078e00ffULL,
0x0000000708057812ULL, 0x000fe400078e7805ULL, 0x0000000708097812ULL, 0x000fe400078e7809ULL,
0x0000000607147212ULL, 0x000fc400078efcffULL, 0x0000000605157212ULL, 0x000fe400078efcffULL,
0x000000040b167212ULL, 0x080fe400078efcffULL, 0x0000000409177212ULL, 0x000fe400078efcffULL,
0x000000202104723eULL, 0x000fe400000010ffULL, 0x0000001c1d05723eULL, 0x000fe400000010ffULL,
0x000000181906723eULL, 0x000fc400000010ffULL, 0x0000000a0c07723eULL, 0x000fe400000010ffULL,
0x0000001314147c11ULL, 0x000fe4000f8e20ffULL, 0x0000000e1108723eULL, 0x000fe400000010ffULL,
0x000000242509723eULL, 0x000fe200000010ffULL, 0x0000000414007844ULL, 0x0005e20000000200ULL,
0x00000028290a723eULL, 0x000fe400000010ffULL, 0x0000002c2d0b723eULL, 0x000fc400000010ffULL,
0x0000001315157c11ULL, 0x000fe4000f8e20ffULL, 0x00000022230c723eULL, 0x000fe400000010ffULL,
0x0000001a1b0e723eULL, 0x000fe200000010ffULL, 0x0000000815007844ULL, 0x0005e20000000200ULL,
0x0000001316167c11ULL, 0x000fe4000f8e20ffULL, 0x000000262711723eULL, 0x000fe400000010ffULL,
0x0000001317177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000c16007844ULL, 0x0005e80000000200ULL,
0x0000001017007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000028003c8947ULL, 0x000fea0003800000ULL, 0x0000000602047c11ULL, 0x004fe2000f8e20ffULL,
0x00000000000979c3ULL, 0x000fe20000002700ULL, 0x0000000eff007c0cULL, 0x000fe2000bf05270ULL,
0x0000840000057ab9ULL, 0x000fe20000000800ULL, 0x0000900000087ab9ULL, 0x000fe20000000800ULL,
0x01200000040c7984ULL, 0x0005280000000c00ULL, 0x00000000000479c3ULL, 0x000ee20000002600ULL,
0x0122000004107984ULL, 0x0004680000000c00ULL, 0x0124000004147984ULL, 0x0004680000000c00ULL,
0x01260000041c7984ULL, 0x0004620000000c00ULL, 0x00000005090972a4ULL, 0x008fc4000f8e0204ULL,
0x000000050f0472a4ULL, 0x000fe4000f8e023fULL, 0x0000000f090772a4ULL, 0x000fe4000f8e023fULL,
0x00000008040872a4ULL, 0x000fe4000f8e023fULL, 0x00000012070a7290ULL, 0x000fe4000fffe03fULL,
0x01ffffff08147892ULL, 0x000fe2000f8ec03fULL, 0x0000000000380947ULL, 0x004ff60003800000ULL,
0x000000140a0b7290ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x000fe200078e00ffULL,
0x0000960000047ab9ULL, 0x000fe20000000a00ULL, 0x00000001ff057819ULL, 0x000fe20000011602ULL,
0x000000800a1078a5ULL, 0x000fe4000f8e0004ULL, 0x000000800b0478a5ULL, 0x000fe2000f8e0004ULL,
0x0000007004067812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000001005047c10ULL, 0x140fe4000fa3e006ULL, 0x0000000405067c10ULL, 0x000fe4000fc7e006ULL,
0x00000011ff057c10ULL, 0x000fe40008fe44ffULL, 0x00000005ff077c10ULL, 0x000fc60009fe84ffULL,
0x0000000004007986ULL, 0x0005e8000c10190cULL, 0x0000004b06007986ULL, 0x0005e4000c10190cULL,
0x00001fff08087891ULL, 0x000fe2000f8e403fULL, 0x0000002002077836ULL, 0x044fe20000000000ULL,
0x0000960000107ab9ULL, 0x000fe20000000a00ULL, 0x000000ff0200720cULL, 0x040fe20000725670ULL,
0x0000000a08047291ULL, 0x000fe2000f8f983fULL, 0x0000004002097836ULL, 0x040fe20000000000ULL,
0x0000026000007945ULL, 0x000fe20003800000ULL, 0x0000006002197836ULL, 0x000fe20000000000ULL,
0x00002000040478a5ULL, 0x000fc8000f8e0010ULL, 0x000008000e0478a5ULL, 0x000fcc000f8e0004ULL,
0x00000005000b7c02ULL, 0x000fe20008000f00ULL, 0x00000004ff0a7e24ULL, 0x000fc8000f8e00ffULL,
0x0000001002047825ULL, 0x000fc800078e000aULL, 0x0000001007067825ULL, 0x100fe200078e000aULL,
0x0000000c04007986ULL, 0x0105e6000c101d0cULL, 0x0000001009087825ULL, 0x100fe200078e000aULL,
0x0000001006007986ULL, 0x0025e6000c101d0cULL, 0x00000010190a7825ULL, 0x000fe200078e000aULL,
0x0000001408007986ULL, 0x0005e8000c101d0cULL, 0x0000001c0a007986ULL, 0x0005e2000c101d0cULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000581947ULL, 0x000fea0003800000ULL,
0x0000940000047ab9ULL, 0x000fe20000000a00ULL, 0xffffffff0f0a7890ULL, 0x000fe4000fffe03fULL,
0x00000004090478a5ULL, 0x000fc8000f8e0004ULL, 0x0000000aff077e24ULL, 0x004fe4000f8e00ffULL,
0x00000004ff047e24ULL, 0x000fe2000f8e00ffULL, 0x0000000500057c02ULL, 0x000fe20008000f00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000007040479a8ULL, 0x000ea800099ee1ccULL, 0x00000000ff00798fULL, 0x004fe20002000000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fc40000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000a04007c0cULL, 0x000fc8000bf25270ULL,
0x00000001ff007807ULL, 0x000fca0000800000ULL, 0x00000000ff007988ULL, 0x0003e80008000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ef00000008800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000040000097882ULL, 0x000fc40000000000ULL,
0x0000065404097896ULL, 0x008fd20008000009ULL, 0x00000009ff007984ULL, 0x002e640008000000ULL,
0x000000ff0000720cULL, 0x002fda0003f25270ULL, 0x0000002000f09947ULL, 0x000fea0003800000ULL,
0x0000000c008c0947ULL, 0x000fea0003800000ULL, 0x0000000fff007c0cULL, 0x000fda000bf05270ULL,
0x0000000000f08947ULL, 0x000fea0003800000ULL, 0x0000000107047890ULL, 0x000fe2000fffe03fULL,
0x0000001002007824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x004fe20000011602ULL,
0x00000080070a78a5ULL, 0x000fe4000f8e0010ULL, 0x00000080040478a5ULL, 0x000fe2000f8e0010ULL,
0x0000007000037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04087812ULL, 0x000fc800078ec0ffULL,
0x0000000a08047c10ULL, 0x140fe4000f91e003ULL, 0x0000000408067c10ULL, 0x000fe4000fb5e003ULL,
0x0000000bff057c10ULL, 0x000fe400087e24ffULL, 0x00000005ff077c10ULL, 0x000fc600097e64ffULL,
0x0000000c04007981ULL, 0x000368000c1e1900ULL, 0x0000000c06097981ULL, 0x000362000c1e1900ULL,
0x000000020f00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x0000000207047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0010ULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c040b7981ULL, 0x000362000c1e1900ULL,
0x000000040f00788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000908947ULL, 0x002fea0003800000ULL, 0x0000000307047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0010ULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c040d7981ULL, 0x000362000c1e1900ULL,
0x000000040f00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000708947ULL, 0x002fea0003800000ULL, 0x0000000407047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0010ULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c040f7981ULL, 0x000362000c1e1900ULL,
0x000000060f00788cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000508947ULL, 0x002fea0003800000ULL, 0x0000000507047890ULL, 0x000fc8000fffe03fULL,
0x00000080040478a5ULL, 0x000fcc000f8e0010ULL, 0x0000000408047c10ULL, 0x000fc8000f91e003ULL,
0x00000005ff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c04117981ULL, 0x000362000c1e1900ULL,
0x000000060f00788cULL, 0x000fcc000bf05270ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000308947ULL, 0x002fea0003800000ULL, 0x000000080f00788cULL, 0x000fe4000bf06070ULL,
0x0000000607047890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f8f008ULL,
0x00000080040478a5ULL, 0x000fc8000f8e0010ULL, 0x00000007070a0890ULL, 0x000fe4000fffe03fULL,
0x0000000408047c10ULL, 0x000fe4000f91e003ULL, 0x000000800a0a08a5ULL, 0x000fe4000f8e0010ULL,
0x00000005ff057c10ULL, 0x000fc800087e24ffULL, 0x0000000a08064c10ULL, 0x000fe2000fb5e003ULL,
0x0000000c04137981ULL, 0x000366000c1e1900ULL, 0x0000000bff074c10ULL, 0x000fca00097e64ffULL,
0x0000000c06154981ULL, 0x000368000c1e1900ULL, 0x000000070f047890ULL, 0x000fc8000fffe03fULL,
0x000000033f157899ULL, 0x000fcc0008011604ULL, 0x00000015ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000800688947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x020fe200078e0000ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000000700167c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x0000960000187ab9ULL, 0x000fca0000000a00ULL,
0x0000000f0400728cULL, 0x000fe4000bf06070ULL, 0x0000000105057890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000150500728cULL, 0x000fd8000bf06070ULL,
0x0000000800300947ULL, 0x022fea0003800000ULL, 0x00000008040a7890ULL, 0x000fe2000fffe03fULL,
0x0000000300007209ULL, 0x000fe20007810000ULL, 0x00000001040b7890ULL, 0x000fe4000fffe03fULL,
0x0000000f0a00728cULL, 0x000fe4000bf26070ULL, 0x0000000f0b00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x00000008160a7890ULL, 0x000fe2000fffe03fULL,
0x0000001002037824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x006fe40000011602ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ec0ffULL, 0x0000000a04047c10ULL, 0x000fc8000f91e003ULL,
0x0000000bff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c04037981ULL, 0x000368000c1e1900ULL,
0x0000000400e82947ULL, 0x000fea0003800000ULL, 0x00000009040a7890ULL, 0x000fe2000fffe03fULL,
0x0000000900007209ULL, 0x000fe20007810000ULL, 0x00000002040b7890ULL, 0x000fe4000fffe03fULL,
0x0000000f0a00728cULL, 0x000fe4000bf26070ULL, 0x0000000f0b00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x00000009160a7890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000a05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000bff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c04097981ULL, 0x000368000c1e1900ULL,
0x0000000400a02947ULL, 0x000fea0003800000ULL, 0x0000000a040a7890ULL, 0x000fe2000fffe03fULL,
0x0000000b00007209ULL, 0x000fe20007810000ULL, 0x00000003040b7890ULL, 0x000fe4000fffe03fULL,
0x0000000f0a00728cULL, 0x000fe4000bf26070ULL, 0x0000000f0b00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000a160a7890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000a05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000bff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c040b7981ULL, 0x000368000c1e1900ULL,
0x0000000400582947ULL, 0x000fea0003800000ULL, 0x0000000b040a7890ULL, 0x000fe2000fffe03fULL,
0x0000000d00007209ULL, 0x000fe20007810000ULL, 0x00000004040b7890ULL, 0x000fe4000fffe03fULL,
0x0000000f0a00728cULL, 0x000fe4000bf26070ULL, 0x0000000f0b00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000b160a7890ULL, 0x000fe2000fffe03fULL,
0x0000000402047819ULL, 0x006fe400000006ffULL, 0x00000001ff057819ULL, 0x000fe20000011602ULL,
0x000000800a0a78a5ULL, 0x000fe2000f8e0018ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000a05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000bff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c040d7981ULL, 0x000368000c1e1900ULL,
0x0000000400102947ULL, 0x000fea0003800000ULL, 0x0000000c040a7890ULL, 0x000fe2000fffe03fULL,
0x0000000f00007209ULL, 0x000fe20007810000ULL, 0x00000005040b7890ULL, 0x000fe4000fffe03fULL,
0x0000000f0a00728cULL, 0x000fe4000bf26070ULL, 0x0000000f0b00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000c160a7890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000a05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000bff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c040f7981ULL, 0x000368000c1e1900ULL,
0x0000000000c82947ULL, 0x000fea0003800000ULL, 0x0000000d040a7890ULL, 0x000fe2000fffe03fULL,
0x0000001100007209ULL, 0x000fe20007810000ULL, 0x00000006040b7890ULL, 0x000fe4000fffe03fULL,
0x0000000f0a00728cULL, 0x000fe4000bf26070ULL, 0x0000000f0b00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000d160a7890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000a05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000bff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c04117981ULL, 0x000368000c1e1900ULL,
0x0000000000802947ULL, 0x000fea0003800000ULL, 0x0000000e040a7890ULL, 0x000fe2000fffe03fULL,
0x0000001300007209ULL, 0x000fe20007810000ULL, 0x00000007040b7890ULL, 0x000fe4000fffe03fULL,
0x0000000f0a00728cULL, 0x000fe4000bf26070ULL, 0x0000000f0b00728cULL, 0x000fc8000bf46070ULL,
0x000000000000781cULL, 0x000fe40003f0f018ULL, 0x000000000000781cULL, 0x000fd60003f4f028ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000e160a7890ULL, 0x000fe2000fffe03fULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000a05047c10ULL, 0x000fc8000f91e004ULL,
0x0000000bff057c10ULL, 0x000fca00087e24ffULL, 0x0000000c04137981ULL, 0x000368000c1e1900ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x0000000f040a7890ULL, 0x000fe2000fffe03fULL,
0x0000001500007209ULL, 0x000fc60007810000ULL, 0x0000000f0a00728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000f160a7890ULL, 0x000fe2000fffe03fULL, 0x0000001002047824ULL, 0x006fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000000a05047c10ULL, 0x000fc8000f91e004ULL, 0x0000000bff057c10ULL, 0x000fca00087e24ffULL,
0x0000000c04157981ULL, 0x000368000c1e1900ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000804047890ULL, 0x000fe4000fffe03fULL, 0x0000000816167890ULL, 0x000fd4000fffe03fULL,
0xfffffff400ac8947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000ee40000000000ULL,
0x0000001002037824ULL, 0x028fe200078e00ffULL, 0x00000001ff047819ULL, 0x006fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000000904037c10ULL, 0x000fca000fffe003ULL, 0x0000000003007388ULL, 0x0003e40000000800ULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x0000000708157291ULL, 0x000fe2000f8f983fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001407167290ULL, 0x000fe2000fffe03fULL,
0x0000000402007819ULL, 0x042fe200000006ffULL, 0x000000090e187291ULL, 0x000fe2000f8e603fULL,
0x00000001ff037819ULL, 0x000fe20000011602ULL, 0x0000002002077836ULL, 0x004fe20000000000ULL,
0x00009600000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x00002000150478a5ULL, 0x000fe2000f8e000aULL, 0x0000000c03037812ULL, 0x000fe200078ec0ffULL,
0x0000004002097836ULL, 0x040fe20000000000ULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x00000060020b7836ULL, 0x000fe20000000000ULL, 0x000008000e0478a5ULL, 0x000fe2000f8e0004ULL,
0x0000000903147c10ULL, 0x000fe2000fffe000ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x000000090e178291ULL, 0x000fe2000f8e403fULL, 0x0000000fff007c0cULL, 0x000fc4000bf25270ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000004ff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000001802117c11ULL, 0x040fe2000f8e20ffULL, 0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL,
0x00000080160488a5ULL, 0x000fe2000f8e000aULL, 0x0000001702138c11ULL, 0x000fe2000f8e20ffULL,
0x00000080070a88a5ULL, 0x000fe2000f8e000aULL, 0x0000001007067825ULL, 0x100fe200078e0004ULL,
0x0000000014147984ULL, 0x000e620000000800ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x00000004000c7c02ULL, 0x000fe20008000f00ULL, 0x0000001009087825ULL, 0x000fe200078e0004ULL,
0x000000090e048291ULL, 0x000fe2000f8e403fULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000100b0a7825ULL, 0x100fe200078e0004ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x0000000402178c11ULL, 0x040fe2000f8e20ffULL, 0x0000001002047825ULL, 0x000fe200078e0004ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000005ff0d7e24ULL, 0x000fe2000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004117faeULL, 0x000fe2000b901c4cULL,
0x0000000aff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000bff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x0038000006117faeULL, 0x000fe2000b901c4cULL,
0x00000010020c8825ULL, 0x040fe200078e000cULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0058000008117faeULL, 0x000fe2000b901c4cULL,
0x00000010020e8825ULL, 0x000fe200078e000eULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x007800000a117faeULL, 0x000fe2000b901c4cULL,
0x0000000000287805ULL, 0x000fc6000001ff00ULL, 0x045800000c138faeULL, 0x000fe8000b901c4cULL,
0x041800000e178faeULL, 0x0005e8000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000167805ULL, 0x004fe2000001ff00ULL, 0x0000000800e89947ULL, 0x002fec0003800000ULL,
0x00000003ff047819ULL, 0x100fe20000011602ULL, 0x0000000107047890ULL, 0x000fe2000fffe03fULL,
0xfffffff8ff057812ULL, 0x000fe200078ee202ULL, 0x000000090e057291ULL, 0x000fe2000f8e403fULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x0000000116167890ULL, 0x000fe2000fffe03fULL,
0x0000000305387819ULL, 0x040fe200000006ffULL, 0x0000000805077836ULL, 0x000fe20000000000ULL,
0x0000000404067812ULL, 0x000fe200078efcffULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000704377812ULL, 0x000fe200078e7805ULL, 0x00000004ff3c7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000704047812ULL, 0x000fe200078e7807ULL, 0x00000005ff3f7e24ULL, 0x000fe2000f8e00ffULL,
0x00000007063a7812ULL, 0x000fe200078e7807ULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x0000000706057812ULL, 0x000fe200078e7805ULL, 0x00000016ff367e24ULL, 0x000fe2000f8e00ffULL,
0x00000002ff3b7819ULL, 0x000fe20000011602ULL, 0x0000000115157890ULL, 0x000fe2000fffe03fULL,
0x0000003837377212ULL, 0x080fe200078efcffULL, 0x00000001000a7882ULL, 0x000fe20000000000ULL,
0x0000003805387212ULL, 0x000fe200078efcffULL, 0x0000960000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000704397212ULL, 0x000fc400078efcffULL, 0x000000073a3a7212ULL, 0x000fe400078efcffULL,
0x000000083b3d7810ULL, 0x000fce0007ffe0ffULL, 0x0000000f0a00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000a80947ULL, 0x000fea0003800000ULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x00002000150478a5ULL, 0x000fe2000f8e0016ULL,
0x0000002002057836ULL, 0x040fe20000000000ULL, 0x000000010a197892ULL, 0x000fe2000f8ec03fULL,
0x00000016ff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x000008000e0478a5ULL, 0x000fe2000f8e0004ULL,
0x00000017ff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000b0a0b7899ULL, 0x000fe2000800063fULL,
0x0000004002097836ULL, 0x040fe40000000000ULL, 0x00000019ff107e24ULL, 0x000fe2000f8e00ffULL,
0x00000004000a7c02ULL, 0x000fe20008000f00ULL, 0x000008000b0b7892ULL, 0x000fe2000f8ec03fULL,
0x00000005ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x0000006002417836ULL, 0x000fe20000000000ULL, 0x0000000b180b7290ULL, 0x000fe2000fffe03fULL,
0x00000080360c8825ULL, 0x000fc400078e000eULL, 0x000000090e1a8291ULL, 0x000fe4000f8e403fULL,
0x000000090e048291ULL, 0x000fe2000f8e403fULL, 0x0000001005047825ULL, 0x000fe200078e000aULL,
0x0000000b02117c11ULL, 0x000fc6000f8e20ffULL, 0x0000001aff3f8e24ULL, 0x000fe4000f8e00ffULL,
0x0000001002067825ULL, 0x000fc800078e000aULL, 0x0000008010138824ULL, 0x000fe200078e023fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006117faeULL, 0x0003e2000b901c4cULL,
0x00000004ff3f8e24ULL, 0x000fe4000f8e00ffULL, 0x0000001009087825ULL, 0x000fe200078e000aULL,
0x0038000004117faeULL, 0x0003e6000b901c4cULL, 0x000000803c0e8825ULL, 0x000fe200078e000eULL,
0x0058000008117faeULL, 0x0003e6000b901c4cULL, 0x00000010410a7825ULL, 0x000fe200078e000aULL,
0x0000003f10418211ULL, 0x000fc600078e38ffULL, 0x00000010020c8825ULL, 0x040fe200078e000cULL,
0x007800000a117faeULL, 0x0003e6000b901c4cULL, 0x0000001002138824ULL, 0x040fe400078e0213ULL,
0x00000010020e8825ULL, 0x000fc600078e000eULL, 0x045800000c138faeULL, 0x0003e2000b901c4cULL,
0x0000001002418824ULL, 0x000fca00078e0241ULL, 0x041800000e418faeULL, 0x0003e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff0a047890ULL, 0x000fe2000fffe03fULL,
0x0000000136367810ULL, 0x000fe20007ffe0ffULL, 0x0000000f0a00728cULL, 0x000fe2000bf06070ULL,
0x000000013c3c7836ULL, 0x000fe20000000000ULL, 0x0000000704057899ULL, 0x000fe4000800063fULL,
0x0000000b04047899ULL, 0x000fe4000800063fULL, 0x0000008005057892ULL, 0x000fe2000f8ec03fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000080004047892ULL, 0x000fc4000f8ec03fULL,
0x000000010a0a7890ULL, 0x000fe4000fffe03fULL, 0x0000000500047c10ULL, 0x002fe2000fffe03fULL,
0x0000018018047890ULL, 0x000fe4000fffe004ULL, 0x0000000115157890ULL, 0x000fe4000fffe03fULL,
0x00000001033e7824ULL, 0x000fe400078e0204ULL, 0x0000000437047c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003e0d7984ULL, 0x000e620000000800ULL,
0x0000000438087c11ULL, 0x000fe4000f8e20ffULL, 0x00000004390c7c11ULL, 0x000fe2000f8e20ffULL,
0x004580003e407984ULL, 0x000fe20000000800ULL, 0x000000043a107c11ULL, 0x000fc6000f8e20ffULL,
0x000000000404783bULL, 0x000ea80000000200ULL, 0x000000000808783bULL, 0x000ee20000000200ULL,
0x0000000d14117221ULL, 0x002fc60000010100ULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x3fb8aa3b11457820ULL, 0x000fc60000410000ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x00010000043e7824ULL, 0x044fe200078e00ffULL, 0x0000763204047816ULL, 0x000fe20000000004ULL,
0x0000004500457308ULL, 0x000ea20000000800ULL, 0x0001000005427824ULL, 0x000fe200078e00ffULL,
0x0000763209467816ULL, 0x048fe20000000046ULL, 0x0001000009487824ULL, 0x000fe200078e00ffULL,
0x0000763206417816ULL, 0x040fe20000000041ULL, 0x000100000b4a7824ULL, 0x000fe200078e00ffULL,
0x0000001006067819ULL, 0x000fe200000006ffULL, 0x0001000007447824ULL, 0x000fe200078e00ffULL,
0x000076320b477816ULL, 0x000fe20000000047ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x0000763207437816ULL, 0x000fc40000000043ULL, 0x000076320a097816ULL, 0x040fe20000000009ULL,
0x000100000a0a7824ULL, 0x000fe400078e00ffULL, 0x0000004045527220ULL, 0x004fe20000410000ULL,
0x0000763205407816ULL, 0x000fe20000000040ULL, 0x0001000004057824ULL, 0x000fe200078e00ffULL,
0x0000763208457816ULL, 0x000fe20000000045ULL, 0x0000003552357221ULL, 0x000fe20000010000ULL,
0x00001f3b52517589ULL, 0x000ea200000e0000ULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x0000001045457819ULL, 0x000fe200000006ffULL, 0x0001000040077824ULL, 0x000fe200078e00ffULL,
0x00001f3d52527589ULL, 0x000ee200000e0000ULL, 0x0001000043437824ULL, 0x000fc400078e00ffULL,
0x0001000009097824ULL, 0x000fe400078e00ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x000076320d497816ULL, 0x042fe20000000049ULL, 0x000100000d4c7824ULL, 0x000fe200078e00ffULL,
0x000076320e0d7816ULL, 0x040fe2000000000dULL, 0x000100000e4b7824ULL, 0x000fe200078e00ffULL,
0x000076320f0e7816ULL, 0x040fe2000000000eULL, 0x000100000f4e7824ULL, 0x000fe200078e00ffULL,
0x00007632100f7816ULL, 0x050fe2000000000fULL, 0x00010000104d7824ULL, 0x000fe200078e00ffULL,
0x0000763211107816ULL, 0x040fe20000000010ULL, 0x0001000011507824ULL, 0x000fe200078e00ffULL,
0x000076320c0b7816ULL, 0x000fe2000000000bULL, 0x0001000049497824ULL, 0x000fc400078e00ffULL,
0x0000005105287223ULL, 0x084fe20000010028ULL, 0x0000763212117816ULL, 0x000fe20000000011ULL,
0x0001000046057824ULL, 0x000fe200078e00ffULL, 0x00007632134f7816ULL, 0x000fe2000000004fULL,
0x0000005106257223ULL, 0x080fe20000010025ULL, 0x000000100c0c7819ULL, 0x000fe200000006ffULL,
0x00000051051e7223ULL, 0x000fe2000001001eULL, 0x0000001012127819ULL, 0x000fe200000006ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x000000100d0d7819ULL, 0x000fe200000006ffULL,
0x000100000b0b7824ULL, 0x000fc400078e00ffULL, 0x000000513e297223ULL, 0x080fe20000010029ULL,
0x000100000e0e7824ULL, 0x000fe400078e00ffULL, 0x0000005142277223ULL, 0x080fe20000010027ULL,
0x000100000f0f7824ULL, 0x000fe400078e00ffULL, 0x0000005107267223ULL, 0x080fe20000010026ULL,
0x0001000010057824ULL, 0x000fe400078e00ffULL, 0x0000005141247223ULL, 0x000fe20000010024ULL,
0x0001000011047824ULL, 0x000fc400078e00ffULL, 0x0000005144237223ULL, 0x080fe20000010023ULL,
0x000100004f067824ULL, 0x000fe400078e00ffULL, 0x0000005143227223ULL, 0x080fe20000010022ULL,
0x0000005108217223ULL, 0x080fe20000010021ULL, 0x0000005145207223ULL, 0x080fe20000010020ULL,
0x00000051481f7223ULL, 0x080fe2000001001fULL, 0x000000510a1d7223ULL, 0x080fe2000001001dULL,
0x00000051091c7223ULL, 0x080fe2000001001cULL, 0x000000514a1b7223ULL, 0x080fe2000001001bULL,
0x00000051471a7223ULL, 0x000fe2000001001aULL, 0x000000520c197223ULL, 0x088fe20000010019ULL,
0x000000520b187223ULL, 0x080fe20000010018ULL, 0x000000524c177223ULL, 0x080fe20000010017ULL,
0x0000005249167223ULL, 0x080fe20000010016ULL, 0x000000524b347223ULL, 0x080fe20000010034ULL,
0x000000520d307223ULL, 0x080fe20000010030ULL, 0x000000524e337223ULL, 0x080fe20000010033ULL,
0x000000520e2f7223ULL, 0x080fe2000001002fULL, 0x000000524d327223ULL, 0x080fe20000010032ULL,
0x000000520f2e7223ULL, 0x080fe2000001002eULL, 0x00000052502d7223ULL, 0x080fe2000001002dULL,
0x00000052052c7223ULL, 0x080fe2000001002cULL, 0x00000052122b7223ULL, 0x080fe2000001002bULL,
0x0000005204317223ULL, 0x080fe20000010031ULL, 0x00000052132a7223ULL, 0x080fe2000001002aULL,
0x0000005206157223ULL, 0x000fe20000010015ULL, 0xfffffff400848947ULL, 0x000fec000383ffffULL,
0x0180000035007836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe80000010000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000b21000057802ULL, 0x000fce0000000f00ULL,
0x0000008800c87944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0004ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000003500007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000035ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x00000002ff097819ULL, 0x104fe40000011602ULL, 0x00000008020b7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff037819ULL, 0x000fe20000011602ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0900047589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff117812ULL, 0x000fc600078ee202ULL,
0x00001f0b000c7589ULL, 0x00072200000e0000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000002904297220ULL, 0x044fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002704057220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002504067220ULL, 0x040fe20000410000ULL, 0x0000002404077220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002104087220ULL, 0x040fe20000410000ULL, 0x0000002004097220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001d040a7220ULL, 0x040fe20000410000ULL, 0x0000001c040b7220ULL, 0x048fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x000fe20000410000ULL,
0x0000000303047812ULL, 0x000fe200078ec0ffULL, 0x00000008111d7836ULL, 0x000fc40000000000ULL,
0x000000190c197220ULL, 0x050fe20000410000ULL, 0x000000180c187220ULL, 0x000fe20000410000ULL,
0x0000000404107812ULL, 0x000fe200078efcffULL, 0x000000170c177220ULL, 0x040fe20000410000ULL,
0x000000160c167220ULL, 0x040fe20000410000ULL, 0x000000340c347220ULL, 0x040fe20000410000ULL,
0x000000300c0d7220ULL, 0x040fe20000410000ULL, 0x000000330c337220ULL, 0x040fe20000410000ULL,
0x0000002f0c007220ULL, 0x040fe20000410000ULL, 0x000000320c327220ULL, 0x040fe20000410000ULL,
0x0000002e0c0f7220ULL, 0x040fe20000410000ULL, 0x0000002d0c2d7220ULL, 0x040fe20000410000ULL,
0x0000002c0c2c7220ULL, 0x040fe20000410000ULL, 0x0000002b0c2b7220ULL, 0x040fe20000410000ULL,
0x000000310c0e7220ULL, 0x040fe20000410000ULL, 0x0000002a0c2a7220ULL, 0x040fe20000410000ULL,
0x000000150c157220ULL, 0x000fe20000410000ULL, 0x00000008110c7824ULL, 0x000fe200078e00ffULL,
0x0000000704137812ULL, 0x000fc400078e7811ULL, 0x0000000704217812ULL, 0x000fe400078e781dULL,
0x0000000710117812ULL, 0x000fe400078e7811ULL, 0x000000031d047819ULL, 0x000fe400000006ffULL,
0x00000007101d7812ULL, 0x000fe400078e781dULL, 0x0000000c13137212ULL, 0x080fe400078efcffULL,
0x0000000c11117212ULL, 0x000fc400078efcffULL, 0x0000000421217212ULL, 0x080fe400078efcffULL,
0x000000041d1d7212ULL, 0x000fe400078efcffULL, 0x000000060706723eULL, 0x000fe400000010ffULL,
0x000000292804723eULL, 0x000fe400000010ffULL, 0x000000052605723eULL, 0x000fe400000010ffULL,
0x000000232207723eULL, 0x000fc400000010ffULL, 0x000000080908723eULL, 0x000fe400000010ffULL,
0x0000000a0b0a723eULL, 0x000fe400000010ffULL, 0x0000001313137c11ULL, 0x000fe4000f8e20ffULL,
0x0000001f1e09723eULL, 0x000fe400000010ffULL, 0x0000001b1a0b723eULL, 0x000fe200000010ffULL,
0x0000000413007844ULL, 0x0005e20000000200ULL, 0x000000191818723eULL, 0x000fc400000010ffULL,
0x0000001311117c11ULL, 0x000fe4000f8e20ffULL, 0x000000171619723eULL, 0x000fe400000010ffULL,
0x000000340d1a723eULL, 0x000fe200000010ffULL, 0x0000000811007844ULL, 0x0005e20000000200ULL,
0x00000033001b723eULL, 0x000fe400000010ffULL, 0x000000320f0c723eULL, 0x000fe400000010ffULL,
0x0000001321217c11ULL, 0x000fc4000f8e20ffULL, 0x0000002d2c0d723eULL, 0x000fe400000010ffULL,
0x0000002b0e0e723eULL, 0x000fe200000010ffULL, 0x0000001821007844ULL, 0x0005e20000000200ULL,
0x0000002a150f723eULL, 0x000fe400000010ffULL, 0x000000131d1d7c11ULL, 0x000fca000f8e20ffULL,
0x0000000c1d007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000067919ULL, 0x004e620000002600ULL, 0x00000020021a7836ULL, 0x040fe20000000000ULL,
0x00000000000979c3ULL, 0x000ea20000002700ULL, 0x00000040021f7836ULL, 0x040fe20000000000ULL,
0x0000840000057ab9ULL, 0x000fe20000000800ULL, 0x00000060021e7836ULL, 0x000fe20000000000ULL,
0x000000030e047899ULL, 0x000fe4000800063fULL, 0x00000003ff147819ULL, 0x000fe2000001161fULL,
0x00000004050a7899ULL, 0x000fe2000800063fULL, 0x00000003ff157819ULL, 0x000fe2000001161eULL,
0x1ffffff804057892ULL, 0x000fe2000f8ec03fULL, 0x0000000714047812ULL, 0x000fc400078e481fULL,
0x0000000715057812ULL, 0x000fe400078e481eULL, 0x0ffffff804047812ULL, 0x000fe200078ef81fULL,
0x00000005ff1c7e24ULL, 0x000fe2000f8e00ffULL, 0x0ffffff805057812ULL, 0x000fe200078ef81eULL,
0x00000005ff197e24ULL, 0x000fe2000f8e00ffULL, 0x00000006040c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000005ff1d7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000605107c11ULL, 0x000fe4000f8e20ffULL,
0x000000071c1f7812ULL, 0x000fc400078ef81fULL, 0x012000000c0c7984ULL, 0x000fe20000000c00ULL,
0x000000090a0472a4ULL, 0x004fe2000f8e023fULL, 0x000000071d1d7812ULL, 0x000fe400078ef81aULL,
0x0120000010107984ULL, 0x000fe20000000c00ULL, 0x00008600000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000001006007824ULL, 0x042fe200078e00ffULL, 0x0000000406177819ULL, 0x040fe200000006ffULL,
0x0000001006167824ULL, 0x040fe200078e00ffULL, 0x0000000500217c02ULL, 0x000fe20008000f00ULL,
0x0000001006187824ULL, 0x000fe200078e00ffULL, 0xfffffff000007812ULL, 0x000fc400078ee203ULL,
0x0000000703037812ULL, 0x000fe400078e4802ULL, 0x0000000400007c10ULL, 0x000fe4000ff1e0ffULL,
0x0ffffff803077812ULL, 0x000fe400078ef802ULL, 0x00000003ff037819ULL, 0x000fe4000001161aULL,
0x0000000607067c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff016167812ULL, 0x000fc400078ee203ULL,
0x0000000703037812ULL, 0x000fe400078e481aULL, 0x0120000006047984ULL, 0x000e620000000c00ULL,
0xfffffff018187812ULL, 0x000fe200078ee215ULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0ffffff803037812ULL, 0x000fe400078ef81aULL, 0xfffffff017177812ULL, 0x000fe400078ee214ULL,
0x0000000603037c11ULL, 0x000fe4000f8e20ffULL, 0x0000000a00147c11ULL, 0x000fc4000f8048ffULL,
0x0000000721217812ULL, 0x000fe200078ef81eULL, 0x0120000003087984ULL, 0x0004e20000000c00ULL,
0x0000000b00157c11ULL, 0x000fe400080f4c15ULL, 0x00000004161c7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000418007c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000719037812ULL, 0x004fe400078ef802ULL,
0x0000000417027c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x0000000a1c167c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e06ffULL,
0x0000000a001a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x0000000a02187c11ULL, 0x000fc4000f8248ffULL, 0x0000000b1c177c11ULL, 0x000fe400080f4c17ULL,
0x0000000b02197c11ULL, 0x000fe200088f4c19ULL, 0x0000001003027825ULL, 0x000fe200078e0014ULL,
0x0000000b001b7c11ULL, 0x000fc600090f4c1bULL, 0x000000101d147825ULL, 0x000fe200078e0016ULL,
0x0000000402007986ULL, 0x002fe6000c101d0cULL, 0x000000101f167825ULL, 0x000fc800078e0018ULL,
0x0000001021187825ULL, 0x000fe200078e001aULL, 0x0000000814007986ULL, 0x008fe8000c101d0cULL,
0x0000000c16007986ULL, 0x000fe8000c101d0cULL, 0x0000001018007986ULL, 0x000fe2000c101d0cULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000400001367983ULL, 0x000ea20000100800ULL,
0x0000000107047899ULL, 0x000fe4000800063fULL, 0x000000060e107899ULL, 0x000fe4000800063fULL,
0x00000009040472a4ULL, 0x000fc6000f8e0208ULL, 0x00008e0000087ab9ULL, 0x000fe20000000800ULL,
0x00000000360672caULL, 0x044fe200000e0000ULL, 0x0000000136007836ULL, 0x000fca0000000000ULL,
0x0000000500007c0cULL, 0x000fce000bf06070ULL, 0x0000001006077291ULL, 0x000fc8000f8e403fULL,
0x00000008040872a4ULL, 0x000fe4000f8e0207ULL, 0x0000000c00008947ULL, 0x000ff40003800000ULL,
0x0000000000267919ULL, 0x000e620000000000ULL, 0x00008a00ff027b82ULL, 0x000ea20000000a00ULL,
0x000000071400728cULL, 0x000fc8000bf01070ULL, 0x0000000714067287ULL, 0x000fc6000c000000ULL,
0x00000000000979c3ULL, 0x000ee20000008800ULL, 0x0000000607067290ULL, 0x000fc6000fffe13fULL,
0x0000040000077882ULL, 0x000fe20000000000ULL, 0x00000003ff107819ULL, 0x002fe20000011626ULL,
0x00000654090b7896ULL, 0x008fe20008000007ULL, 0x0ffffff826057812ULL, 0x000fe400078ec0ffULL,
0x0000002610007212ULL, 0x0c0fe200078e3cffULL, 0x0000000810097836ULL, 0x040fe20000000000ULL,
0x0000000410077810ULL, 0x000fe20007ffe0ffULL, 0x00000010101d7836ULL, 0x000fe20000000000ULL,
0x0000000705117812ULL, 0x000fe200078ef800ULL, 0x0000001026007824ULL, 0x000fe200078e00ffULL,
0x0000002607067212ULL, 0x0c0fe200078e3cffULL, 0x0000000810057c36ULL, 0x000fe20008000000ULL,
0x0000000607007c0cULL, 0x040fe2000bf46070ULL, 0x00000008071b7824ULL, 0x000fe200078e00ffULL,
0x0000007000007812ULL, 0x000fe200078ec0ffULL, 0x0000020005047825ULL, 0x004fe200078e0002ULL,
0x0000002609087212ULL, 0x080fe200078e3cffULL, 0x0000000b0e077291ULL, 0x000fe2000f8e703fULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x0000000807077c36ULL, 0x000fe20008000000ULL,
0x0000000400127210ULL, 0x000fe20007f1e0ffULL, 0x00000008090d7824ULL, 0x000fe200078e00ffULL,
0x0000200007077890ULL, 0x000fe2000fffe03fULL, 0x0000000c100b7836ULL, 0x000fe20000000000ULL,
0x000000261d1e7212ULL, 0x000fe200078e3cffULL, 0x000000ffff137224ULL, 0x000fe200000e0605ULL,
0x0000000609007c0cULL, 0x000fe2000bf06070ULL, 0x0000020007047825ULL, 0x000fe200078e0002ULL,
0xfffffff80d1a7812ULL, 0x000fc400078ee208ULL, 0x000000081d0d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000809097c36ULL, 0x000fe20008000000ULL, 0x0000000400147210ULL, 0x000fe20007f7e0ffULL,
0x00000014101f7836ULL, 0x000fe20000000000ULL, 0x000000260b0a7212ULL, 0x000fe200078e3cffULL,
0x0000020009067825ULL, 0x000fe200078e0002ULL, 0x000000030b0f7819ULL, 0x040fe400000006ffULL,
0x000000060b007c0cULL, 0x040fe2000bf26070ULL, 0x000000080b0b7c36ULL, 0x000fe20008000000ULL,
0x0000000600167210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0605ULL,
0xfffffff80f1c7812ULL, 0x000fe200078ee20aULL, 0x000002000d047825ULL, 0x000fe200078e0002ULL,
0x0000000711117c11ULL, 0x000fc4000f8e20ffULL, 0x000000071b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x000002000b087825ULL, 0x000fe200078e0002ULL, 0x0000002410237810ULL, 0x000fc60007ffe0ffULL,
0x000000081f0b7c36ULL, 0x000fe20008000000ULL, 0x0000000800187210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200020e0607ULL, 0x00000004000c7210ULL, 0x000fe20007f9e0ffULL,
0x0000001810207836ULL, 0x040fe40000000000ULL, 0x000002000b067825ULL, 0x000fe200078e0002ULL,
0x00000005ff0d7210ULL, 0x000fe400027fe4ffULL, 0x000000061d007c0cULL, 0x000fe2000bf86070ULL,
0x0000001c10217836ULL, 0x000fc40000000000ULL, 0x0000000820057c36ULL, 0x000fe40008000000ULL,
0x000000ffff197224ULL, 0x000fe200018e0609ULL, 0x00000006000e7210ULL, 0x000fe20007f7e0ffULL,
0x0000020005047825ULL, 0x000fe200078e0002ULL, 0x0000000821097c10ULL, 0x000fc6000fffe0ffULL,
0x0000002010227836ULL, 0x040fe20000000000ULL, 0x0000000400067210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0607ULL, 0x0000000610007c0cULL, 0x000fe2000bf66070ULL,
0x00000008220b7c36ULL, 0x000fe40008000000ULL, 0x0000020009087825ULL, 0x000fc800078e0002ULL,
0x000002000b0a7825ULL, 0x000fc800078e0002ULL, 0x000000ffff077224ULL, 0x000fe200028e0605ULL,
0x0000000800087210ULL, 0x000fe20007fbe0ffULL, 0x000000081d1d7824ULL, 0x000fe200078e00ffULL,
0x0000000a00047210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012117faeULL, 0x0003e2000d901c4cULL, 0x000000081f247824ULL, 0x040fe200078e00ffULL,
0x0000000620007c0cULL, 0x040fe2000bf66070ULL, 0x000000ffff097224ULL, 0x000fe200028e0609ULL,
0xfffffff81d1e7812ULL, 0x000fe200078ee21eULL, 0x000000ffff057224ULL, 0x000fe200030e060bULL,
0x000000061f007c0cULL, 0x040fe2000bfa6070ULL, 0x00000000141b7faeULL, 0x0005e2000d101c4cULL,
0x000000261f1d7212ULL, 0x080fe200078e3cffULL, 0x00000008230b7c36ULL, 0x000fe20008000000ULL,
0x00000026201f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0x0000000621007c0cULL, 0x040fe2000bf46070ULL, 0x0000000821127824ULL, 0x042fe200078e00ffULL,
0x0000002621117212ULL, 0x000fe200078e3cffULL, 0x000002000b0a7825ULL, 0x000fe200078e0002ULL,
0x0000002810217810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8201f7812ULL, 0x000fe200078ee21fULL,
0x0000000822257824ULL, 0x000fe200078e00ffULL, 0xfffffff812207812ULL, 0x000fe200078ee211ULL,
0x0000000821137c36ULL, 0x000fe20008000000ULL, 0xfffffff8241d7812ULL, 0x000fe200078ee21dULL,
0x0000002c10247836ULL, 0x000fe20000000000ULL, 0x000000071a117c11ULL, 0x000fe2000f8e20ffULL,
0x0000020013127825ULL, 0x000fe200078e0002ULL, 0x0000000a000a7210ULL, 0x000fe40007fde0ffULL,
0x000000071c1b7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000016117faeULL, 0x0003e2000c101c4cULL,
0x0000000824157c36ULL, 0x000fe20008000000ULL, 0x0000000622007c0cULL, 0x040fe2000bf06070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000001200127210ULL, 0x000fe20007fde0ffULL,
0x0000020015147825ULL, 0x000fe200078e0002ULL, 0x00000000181b7faeULL, 0x0005e2000c901c4cULL,
0x00000026221a7212ULL, 0x000fc400078e3cffULL, 0x00000013ff137210ULL, 0x000fe400037fe4ffULL,
0x0000001400147210ULL, 0x000fe40007fde0ffULL, 0x000000071e117c11ULL, 0x002fe2000f8e20ffULL,
0x00000030101e7836ULL, 0x000fe20000000000ULL, 0x0000000623007c0cULL, 0x040fe2000bf26070ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x00000026231c7212ULL, 0x000fe200078e3cffULL,
0x000000081e177c36ULL, 0x000fe20008000000ULL, 0x000000071d197c11ULL, 0x004fe2000f8e20ffULL,
0x00000034101d7836ULL, 0x000fe20000000000ULL, 0x000000000c117faeULL, 0x0003e2000e101c4cULL,
0x0000020017167825ULL, 0x000fe200078e0002ULL, 0xfffffff8251a7812ULL, 0x000fc400078ee21aULL,
0x000000000e197faeULL, 0x0005e2000e901c4cULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x0000001600167210ULL, 0x000fe40007fde0ffULL, 0x0000000621007c0cULL, 0x000fe4000bf86070ULL,
0x00000017ff177210ULL, 0x000fe200037fe4ffULL, 0x000000081d0d7c36ULL, 0x002fe20008000000ULL,
0x000000071f117c11ULL, 0x000fe2000f8e20ffULL, 0x00000038101f7836ULL, 0x000fe20000000000ULL,
0xfffffff8231c7812ULL, 0x000fe200078ee21cULL, 0x000002000d0c7825ULL, 0x000fe200078e0002ULL,
0x00000007200f7c11ULL, 0x004fe2000f8e20ffULL, 0x0000000006117faeULL, 0x0003e2000d901c4cULL,
0x000000081f197c10ULL, 0x000fe2000fffe0ffULL, 0x0000003c10207836ULL, 0x000fe20000000000ULL,
0x0000002621187212ULL, 0x040fe200078e3cffULL, 0x00000000080f7faeULL, 0x0005e2000d101c4cULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0x0000000624007c0cULL, 0x000fc4000bfa6070ULL,
0x00000026241b7212ULL, 0x0c0fe200078e3cffULL, 0x0000000824247824ULL, 0x000fe200078e00ffULL,
0xfffffff821187812ULL, 0x000fe200078ee218ULL, 0x000000081e217824ULL, 0x000fe200078e00ffULL,
0x000000061d007c0cULL, 0x000fe2000bf46070ULL, 0x0000020019067825ULL, 0x002fe200078e0002ULL,
0x000000261d107212ULL, 0x0c0fe400078e3cffULL, 0x0000000c00087210ULL, 0x004fe20007fde0ffULL,
0x00000008200f7c36ULL, 0x000fe20008000000ULL, 0x000000061e007c0cULL, 0x040fe2000bf66070ULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0x000000261e0e7212ULL, 0x000fe200078e3cffULL,
0x000000ffff097224ULL, 0x000fe200030e060dULL, 0x000000071a0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000002000f027825ULL, 0x000fe200078e0002ULL, 0x000000071c0f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000000600067210ULL, 0x000fe20007fde0ffULL, 0x00000000040d7faeULL, 0x0003e2000c101c4cULL,
0x000000061f007c0cULL, 0x040fe4000bf06070ULL, 0x000000261f0c7212ULL, 0x0c0fe200078e3cffULL,
0x000000000a0f7faeULL, 0x0005e2000c901c4cULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000620007c0cULL, 0x040fe2000bf26070ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000002620197212ULL, 0x000fe400078e3cffULL, 0xfffffff8241b7812ULL, 0x000fc400078ee21bULL,
0x0000000320207819ULL, 0x000fe400000006ffULL, 0xfffffff8210e7812ULL, 0x000fe400078ee20eULL,
0xfffffff81d107812ULL, 0x000fe400078ee210ULL, 0x0000000200027210ULL, 0x000fe40007fde0ffULL,
0xfffffff81f0c7812ULL, 0x000fe400078ee20cULL, 0x0000000718117c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200030e0603ULL, 0xfffffff820197812ULL, 0x000fc400078ee219ULL,
0x000000071b057c11ULL, 0x002fe2000f8e20ffULL, 0x0000000012117faeULL, 0x0003e2000e101c4cULL,
0x000000070e0b7c11ULL, 0x004fe4000f8e20ffULL, 0x00000007100d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000014057faeULL, 0x0003e2000e901c4cULL, 0x000000070c0f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000719197c11ULL, 0x000fe2000f8e20ffULL, 0x00000000160b7faeULL, 0x0003e8000d901c4cULL,
0x00000000080d7faeULL, 0x0003e8000d101c4cULL, 0x00000000060f7faeULL, 0x0003e8000c101c4cULL,
0x0000000002197faeULL, 0x0003e2000c901c4cULL, 0x0000000800b07947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0x00000000000679c3ULL, 0x000ea20000008800ULL,
0x00000400000b7882ULL, 0x000fe40000000000ULL, 0x00000654060b7896ULL, 0x004fc8000800000bULL,
0x0000000b0e067291ULL, 0x000fe2000f8e703fULL, 0x00000003ff027819ULL, 0x002fc60000011617ULL,
0x0000200006067890ULL, 0x000fe2000fffe03fULL, 0x0ffffff817037812ULL, 0x040fe400078ec0ffULL,
0x0000001c02227810ULL, 0x000fe20007ffe0ffULL, 0x0000000c021a7836ULL, 0x040fe20000000000ULL,
0x0000001702147212ULL, 0x0c0fe200078e3cffULL, 0x00000010021c7836ULL, 0x000fe20000000000ULL,
0x00000017220d7212ULL, 0x080fe200078e3cffULL, 0x000000081a047824ULL, 0x040fe200078e00ffULL,
0x000000171a117212ULL, 0x080fe200078e3cffULL, 0x000000081c057824ULL, 0x040fe200078e00ffULL,
0x000000171c107212ULL, 0x080fe200078e3cffULL, 0x0000002002247836ULL, 0x040fe20000000000ULL,
0xfffffff804117812ULL, 0x000fe200078ee211ULL, 0x0000000802187836ULL, 0x040fe20000000000ULL,
0xfffffff805107812ULL, 0x000fe200078ee210ULL, 0x0000000402167836ULL, 0x000fe20000000000ULL,
0x0000000703147812ULL, 0x000fe200078ef814ULL, 0x0000000822047824ULL, 0x000fe200078e00ffULL,
0x00000017240c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000824057824ULL, 0x000fe200078e00ffULL,
0x0000001718127212ULL, 0x080fe200078e3cffULL, 0x0000002c022a7836ULL, 0x000fe20000000000ULL,
0x0000001716137212ULL, 0x080fe200078e3cffULL, 0x0000000818037824ULL, 0x000fe200078e00ffULL,
0x0000000316007819ULL, 0x000fe200000006ffULL, 0x00000030022c7836ULL, 0x040fe20000000000ULL,
0xfffffff8040d7812ULL, 0x000fe200078ee20dULL, 0x0000001802207836ULL, 0x040fe20000000000ULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x00000014021e7836ULL, 0x000fe20000000000ULL,
0x000000032a047819ULL, 0x000fe200000006ffULL, 0x000000082c057824ULL, 0x000fe200078e00ffULL,
0xfffffff803127812ULL, 0x000fe200078ee212ULL, 0x0000000820037824ULL, 0x000fe200078e00ffULL,
0x000000172a097212ULL, 0x080fe200078e3cffULL, 0x0000002802287836ULL, 0x000fe20000000000ULL,
0x000000172c087212ULL, 0x080fe200078e3cffULL, 0x00000034022e7836ULL, 0x000fe20000000000ULL,
0xfffffff800137812ULL, 0x000fe200078ee213ULL, 0x000000081e007824ULL, 0x000fe200078e00ffULL,
0x00000017200e7212ULL, 0x080fe200078e3cffULL, 0x0000003802307836ULL, 0x000fe20000000000ULL,
0x000000171e0f7212ULL, 0x080fe200078e3cffULL, 0x0000003c02327836ULL, 0x000fe20000000000ULL,
0x0000002402267810ULL, 0x000fe20007ffe0ffULL, 0x0000000818197c36ULL, 0x000fe20008000000ULL,
0xfffffff804097812ULL, 0x000fe200078ee209ULL, 0x000000081c1d7c36ULL, 0x000fe20008000000ULL,
0xfffffff805087812ULL, 0x000fe200078ee208ULL, 0x000000081e1f7c36ULL, 0x000fe20008000000ULL,
0x00008a00ff047b82ULL, 0x000e620000000a00ULL, 0xfffffff8030e7812ULL, 0x000fe200078ee20eULL,
0x0000000828037824ULL, 0x000fe200078e00ffULL, 0xfffffff8000f7812ULL, 0x000fe200078ee20fULL,
0x0000000826007824ULL, 0x000fe200078e00ffULL, 0x00000017280a7212ULL, 0x080fe200078e3cffULL,
0x0000000820217c36ULL, 0x000fe20008000000ULL, 0x00000017260b7212ULL, 0x080fe200078e3cffULL,
0x0000000822237c36ULL, 0x000fe20008000000ULL, 0xfffffff8030a7812ULL, 0x000fe200078ee20aULL,
0x000000082e037824ULL, 0x000fe200078e00ffULL, 0xfffffff8000b7812ULL, 0x000fe200078ee20bULL,
0x0000000824257c36ULL, 0x000fe20008000000ULL, 0x000000172e007212ULL, 0x080fe200078e3cffULL,
0x0000000828297c36ULL, 0x000fe20008000000ULL, 0x0000001730067212ULL, 0x080fe200078e3cffULL,
0x000000082a2b7c36ULL, 0x000fe20008000000ULL, 0xfffffff803007812ULL, 0x000fe200078ee200ULL,
0x0000001017037824ULL, 0x000fe200078e00ffULL, 0x0000000330157819ULL, 0x000fe200000006ffULL,
0x000000082c2d7c36ULL, 0x000fe20008000000ULL, 0x0000001732077212ULL, 0x000fe200078e3cffULL,
0x0000000816177c36ULL, 0x000fe20008000000ULL, 0xfffffff815067812ULL, 0x000fe200078ee206ULL,
0x000000082e2f7c36ULL, 0x000fe20008000000ULL, 0x0000007003157812ULL, 0x000fe200078ec0ffULL,
0x0000000802037c36ULL, 0x000fe20008000000ULL, 0x000000081a1b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000830317c36ULL, 0x000fe20008000000ULL, 0x0000000826277c10ULL, 0x000fe2000fffe0ffULL,
0x0000020003027825ULL, 0x002fe200078e0004ULL, 0x0000000832337c10ULL, 0x000fc4000fffe0ffULL,
0x0000000613137c11ULL, 0x000fe2000f8e20ffULL, 0x0000020017167825ULL, 0x100fe200078e0004ULL,
0x0000000215027210ULL, 0x000fe40007f1e0ffULL, 0x0000000611117c11ULL, 0x000fe2000f8e20ffULL,
0x0000020019187825ULL, 0x100fe200078e0004ULL, 0x0000000610357c11ULL, 0x000fe4000f8e20ffULL,
0x000000060f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000002001b1a7825ULL, 0x000fe200078e0004ULL,
0x000000060e377c11ULL, 0x000fc4000f8e20ffULL, 0x000000060d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000832347824ULL, 0x000fe200078e00ffULL, 0x000000060b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000002001d1c7825ULL, 0x100fe200078e0004ULL, 0x0000000609097c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff834077812ULL, 0x000fe200078ee207ULL, 0x000002001f1e7825ULL, 0x000fc600078e0004ULL,
0x0000000607077c11ULL, 0x000fe2000f8e20ffULL, 0x0000020021207825ULL, 0x000fc800078e0004ULL,
0x0000020023227825ULL, 0x000fc800078e0004ULL, 0x0000020025247825ULL, 0x000fc800078e0004ULL,
0x0000020027267825ULL, 0x000fc800078e0004ULL, 0x0000020029287825ULL, 0x000fc800078e0004ULL,
0x000002002b2a7825ULL, 0x000fc800078e0004ULL, 0x000002002d2c7825ULL, 0x000fc800078e0004ULL,
0x000002002f2e7825ULL, 0x000fc800078e0004ULL, 0x0000020031307825ULL, 0x000fc800078e0004ULL,
0x0000020033327825ULL, 0x000fe200078e0004ULL, 0x0000001615047210ULL, 0x000fe40007f3e0ffULL,
0x0000001815167210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000001a15187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0617ULL,
0x0000001c151a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe400010e0619ULL,
0x000000ffff197224ULL, 0x000fe200000e061bULL, 0x0000001e151c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e061dULL, 0x00000020151e7210ULL, 0x000fc40007f5e0ffULL,
0x0000002215207210ULL, 0x000fe40007f3e0ffULL, 0x0000001fff1d7210ULL, 0x000fe200007fe4ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e0621ULL, 0x0000002415227210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e0623ULL, 0x0000002615247210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200000e0625ULL, 0x0000002815267210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200008e0627ULL, 0x0000002a15287210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0629ULL, 0x0000002c152a7210ULL, 0x000fe40007f1e0ffULL,
0x0000002bff297210ULL, 0x000fe40000ffe4ffULL, 0x0000002e152c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e062dULL, 0x00000030152e7210ULL, 0x000fe40007f1e0ffULL,
0x0000003215307210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200008e062fULL,
0x0000000614157c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff2f7224ULL, 0x000fc400000e0631ULL,
0x000000ffff317224ULL, 0x000fe200010e0633ULL, 0x0000000612337c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002157faeULL, 0x0003e8000b901c4cULL,
0x0000000004137faeULL, 0x0005e8000b901c4cULL, 0x0000000016337faeULL, 0x000fe8000b901c4cULL,
0x0000000018117faeULL, 0x0009e2000b901c4cULL, 0x000000060c037c11ULL, 0x002fc6000f8e20ffULL,
0x000000001a357faeULL, 0x000fe2000b901c4cULL, 0x000000060a057c11ULL, 0x004fc6000f8e20ffULL,
0x000000001c0f7faeULL, 0x0003e8000b901c4cULL, 0x000000001e377faeULL, 0x000fe2000b901c4cULL,
0x0000000600117c11ULL, 0x010fc6000f8e20ffULL, 0x00000000200d7faeULL, 0x0005e2000b901c4cULL,
0x00000006080f7c11ULL, 0x002fc6000f8e20ffULL, 0x0000000022037faeULL, 0x0007e8000b901c4cULL,
0x00000000240b7faeULL, 0x0007e2000b901c4cULL, 0x00000006060d7c11ULL, 0x004fc6000f8e20ffULL,
0x0000000026057faeULL, 0x0007e8000b901c4cULL, 0x0000000028097faeULL, 0x0007e8000b901c4cULL,
0x000000002a0f7faeULL, 0x0007e8000b901c4cULL, 0x000000002c117faeULL, 0x0007e8000b901c4cULL,
0x000000002e0d7faeULL, 0x0007e8000b901c4cULL, 0x0000000030077faeULL, 0x0007e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x024600ffff0075a7ULL, 0x000ea2000800014bULL,
0x0000000536007c0cULL, 0x000fe2000bf26070ULL, 0x0000006000dc8947ULL, 0x004fd80003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x00007610ff007816ULL, 0x000fe20000000000ULL,
0x0000000b0e127291ULL, 0x000fc8000f8e203fULL, 0x0000a00001007387ULL, 0x0005f00000100600ULL,
0x0000400001007983ULL, 0x004ea40000100800ULL, 0x00000000000772caULL, 0x004fda00000e0000ULL,
0x0000001007077291ULL, 0x000fc8000f8e403fULL, 0x000000071400728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000100007836ULL, 0x000fe20000000000ULL, 0x00000000002e7919ULL, 0x008ea20000000000ULL,
0x00008e00000a7ab9ULL, 0x000fe40000000800ULL, 0x0000000a041172a4ULL, 0x000fe2000f8e0207ULL,
0x0000000500007c0cULL, 0x000fda000bf06070ULL, 0x0000000800e08947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x004fe2000001162eULL, 0x8000000714087290ULL, 0x000fe2000fffe03fULL,
0x000000072e5b7812ULL, 0x000fe200078ec0ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000400547810ULL, 0x000fe20007ffe0ffULL, 0x0000000800537836ULL, 0x040fe20000000000ULL,
0x0000001000027810ULL, 0x002fe20007ffe0ffULL, 0x0000001400587836ULL, 0x000fe20000000000ULL,
0x0000002e54687212ULL, 0x0c0fe200078e3cffULL, 0x0000000854037824ULL, 0x000fe200078e00ffULL,
0x0000002e536d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000853047824ULL, 0x000fe200078e00ffULL,
0x0000002e58707212ULL, 0x080fe200078e3cffULL, 0x0000001800577836ULL, 0x000fe20000000000ULL,
0xfffffff803687812ULL, 0x000fe200078ee268ULL, 0x0000000858037824ULL, 0x000fe200078e00ffULL,
0xfffffff8046d7812ULL, 0x000fe200078ee26dULL, 0x0000000802047824ULL, 0x000fe200078e00ffULL,
0x0000002e57667212ULL, 0x0c0fe200078e3cffULL, 0x00000024005a7836ULL, 0x040fe20000000000ULL,
0xfffffff803707812ULL, 0x000fe200078ee270ULL, 0x0000002000557836ULL, 0x040fe20000000000ULL,
0x0000000357037819ULL, 0x000fe200000006ffULL, 0x0000002c006c7836ULL, 0x000fe20000000000ULL,
0x0000002e026f7212ULL, 0x080fe200078e3cffULL, 0x0000001c00567836ULL, 0x000fe20000000000ULL,
0xfffffff803667812ULL, 0x000fe200078ee266ULL, 0x000000085a037824ULL, 0x040fe200078e00ffULL,
0xfffffff8046f7812ULL, 0x000fe200078ee26fULL, 0x0000000855047824ULL, 0x040fe200078e00ffULL,
0x0000002e5a627212ULL, 0x080fe200078e3cffULL, 0x0000000c00527836ULL, 0x000fe20000000000ULL,
0x0000002e55637212ULL, 0x080fe200078e3cffULL, 0x0000000856057824ULL, 0x000fe200078e00ffULL,
0x0000002800597810ULL, 0x000fe20007ffe0ffULL, 0x0000000852067824ULL, 0x000fe200078e00ffULL,
0xfffffff803627812ULL, 0x000fe200078ee262ULL, 0x000000086c037824ULL, 0x040fe200078e00ffULL,
0xfffffff804637812ULL, 0x000fe200078ee263ULL, 0x0000000859047824ULL, 0x040fe200078e00ffULL,
0x0000002e6c607212ULL, 0x080fe200078e3cffULL, 0x0000000b0e067291ULL, 0x000fe2000f8e703fULL,
0x0000002e59617212ULL, 0x080fe200078e3cffULL, 0x0000001100077c36ULL, 0x000fe20008000000ULL,
0x0000002e56647212ULL, 0x080fe200078e3cffULL, 0x0000400006097890ULL, 0x000fe2000fffe03fULL,
0xfffffff803607812ULL, 0x000fe200078ee260ULL, 0x0000003c006e7836ULL, 0x040fe20000000000ULL,
0xfffffff804617812ULL, 0x000fe200078ee261ULL, 0x00000034006a7836ULL, 0x040fe20000000000ULL,
0x0000002e00037212ULL, 0x0c0fe200078e3cffULL, 0x00000030006b7836ULL, 0x000fe20000000000ULL,
0x0000002e52677212ULL, 0x000fe200078e3cffULL, 0x0000003800657836ULL, 0x040fe20000000000ULL,
0xfffffff805647812ULL, 0x000fe200078ee264ULL, 0x00000017ff057e24ULL, 0x000fe2000f8e00ffULL,
0x0000001600047c02ULL, 0x000fe20008000f00ULL, 0x000000086b0a7824ULL, 0x000fe200078e00ffULL,
0x0000000800007c0cULL, 0x000fe2000bf26070ULL, 0x00000008650c7824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x00000011520d7c36ULL, 0x000fe20008000000ULL,
0xfffffff806677812ULL, 0x000fe200078ee267ULL, 0x0000020007067825ULL, 0x000fe200078e0004ULL,
0x000000085b2d7812ULL, 0x000fc400078efcffULL, 0x0ffffff803697812ULL, 0x000fe200078ef82eULL,
0x000000086e037824ULL, 0x040fe200078e00ffULL, 0x0000002e6e5c7212ULL, 0x080fe200078e3cffULL,
0x000000102d087825ULL, 0x000fe200078e0006ULL, 0x0000002e6a5e7212ULL, 0x0c0fe400078e3cffULL,
0x000000036a0b7819ULL, 0x000fe200000006ffULL, 0x0000001158117c36ULL, 0x000fe20008000000ULL,
0x00000009697a7c11ULL, 0x000fe2000f8e20ffULL, 0x00000011551f7c36ULL, 0x000fe20008000000ULL,
0xfffffff8035c7812ULL, 0x000fe200078ee25cULL, 0x0000001154037c36ULL, 0x040fe20008000000ULL,
0x0000002e6b5f7212ULL, 0x080fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000087a7faeULL, 0x0003e2000c901c4cULL, 0xfffffff80b5e7812ULL, 0x000fe200078ee25eULL,
0x00000011530b7c36ULL, 0x000fe20008000000ULL, 0x0000002e655d7212ULL, 0x000fe200078e3cffULL,
0x0000020011107825ULL, 0x000fe200078e0004ULL, 0x0000000854007c0cULL, 0x000fc4000bf26070ULL,
0x0000000853007c0cULL, 0x000fe2000bf46070ULL, 0x000000115a217c36ULL, 0x000fe20008000000ULL,
0xfffffff80a5f7812ULL, 0x000fe200078ee25fULL, 0x000002000b0a7825ULL, 0x100fe200078e0004ULL,
0x0000000852007c0cULL, 0x000fe4000bf66070ULL, 0xfffffff80c5d7812ULL, 0x000fe200078ee25dULL,
0x0000020003087825ULL, 0x102fe200078e0004ULL, 0x00000011020f7c10ULL, 0x000fe4000fffe0ffULL,
0x0000000802007c0cULL, 0x000fe2000bf86070ULL, 0x000002000d0c7825ULL, 0x000fe200078e0004ULL,
0x00000009687c7c11ULL, 0x000fc4000f8e20ffULL, 0x000000096d1e7c11ULL, 0x000fe2000f8e20ffULL,
0x000002000f0e7825ULL, 0x000fe200078e0004ULL, 0x00000009671d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000858007c0cULL, 0x000fe2000bfa6070ULL, 0x000000102d127825ULL, 0x000fe200078e0008ULL,
0x000000096f1c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001e01007387ULL, 0x000fe20000100800ULL,
0x00000009707d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d147825ULL, 0x000fe200078e000aULL,
0x0000001159237c10ULL, 0x000fe2000fffe0ffULL, 0x00000000127c7faeULL, 0x0003e2000c901c4cULL,
0x0000000857007c0cULL, 0x000fe2000bf26070ULL, 0x000000102d167825ULL, 0x040fe200078e000cULL,
0x00000009662a7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000141e7faeULL, 0x000fe2000d101c4cULL,
0x0000000856007c0cULL, 0x000fe2000bf46070ULL, 0x000000102d187825ULL, 0x000fe200078e000eULL,
0x0000000964297c11ULL, 0x000fe2000f8e20ffULL, 0x0000041d01007387ULL, 0x0005e20000100800ULL,
0x0000000963287c11ULL, 0x000fe2000f8e20ffULL, 0x0000001157037c36ULL, 0x000fe20008000000ULL,
0x0000000962277c11ULL, 0x000fe2000f8e20ffULL, 0x00000000161d7faeULL, 0x0005e2000d901c4cULL,
0x000000102d1a7825ULL, 0x000fe200078e0010ULL, 0x0000000855007c0cULL, 0x000fc4000bf66070ULL,
0x00000000181c7faeULL, 0x0007e2000e101c4cULL, 0x0000020003127825ULL, 0x102fe200078e0004ULL,
0x000000085a007c0cULL, 0x000fe4000bf86070ULL, 0x0000081c01007387ULL, 0x0003e20000100800ULL,
0x0000000961267c11ULL, 0x000fe2000f8e20ffULL, 0x000000116c037c36ULL, 0x000fe20008000000ULL,
0x0000000960327c11ULL, 0x000fe2000f8e20ffULL, 0x00000011561d7c36ULL, 0x004fe20008000000ULL,
0x000000001a7d7faeULL, 0x0005e2000e901c4cULL, 0x000002001f167825ULL, 0x000fe200078e0004ULL,
0x0000000859007c0cULL, 0x000fc4000bfa6070ULL, 0x0000142a01007387ULL, 0x000fe20000100800ULL,
0x000002001d147825ULL, 0x100fe200078e0004ULL, 0x000000095f317c11ULL, 0x000fe4000f8e20ffULL,
0x0000102901007387ULL, 0x0009e20000100800ULL, 0x0000020021187825ULL, 0x008fe200078e0004ULL,
0x000000095e307c11ULL, 0x000fe4000f8e20ffULL, 0x00001c2801007387ULL, 0x000fe20000100800ULL,
0x000000102d1c7825ULL, 0x002fe200078e0012ULL, 0x000000095d2f7c11ULL, 0x000fc4000f8e20ffULL,
0x00002c2701007387ULL, 0x0003e20000100800ULL, 0x000000102d1e7825ULL, 0x000fe200078e0014ULL,
0x000000095c7b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000001c2a7faeULL, 0x000fe2000c901c4cULL,
0x00000200231a7825ULL, 0x004fe200078e0004ULL, 0x000000086c007c0cULL, 0x000fe4000bf26070ULL,
0x000000001e297faeULL, 0x0009e2000d101c4cULL, 0x000000102d207825ULL, 0x000fe200078e0016ULL,
0x000000086b007c0cULL, 0x000fc4000bf46070ULL, 0x0000282601007387ULL, 0x0005e20000100800ULL,
0x000000102d227825ULL, 0x000fc600078e0018ULL, 0x0000000020287faeULL, 0x0007e2000d901c4cULL,
0x000000102d247825ULL, 0x000fe200078e001aULL, 0x000000086a007c0cULL, 0x040fe4000bf66070ULL,
0x0000000022277faeULL, 0x0003e2000e101c4cULL, 0x000000116a297c36ULL, 0x010fe20008000000ULL,
0x0000000865007c0cULL, 0x040fe2000bf86070ULL, 0x00000011652b7c36ULL, 0x000fe20008000000ULL,
0x0000000024267faeULL, 0x000be2000e901c4cULL, 0x000000116e517c36ULL, 0x040fe20008000000ULL,
0x000000086e007c0cULL, 0x000fe2000bfa6070ULL, 0x00000200031c7825ULL, 0x100fe200078e0004ULL,
0x0000243201007387ULL, 0x0009e60000100800ULL, 0x0000020029207825ULL, 0x108fe200078e0004ULL,
0x0000203101007387ULL, 0x0009e60000100800ULL, 0x000000116b277c36ULL, 0x002fe20008000000ULL,
0x0000183001007387ULL, 0x0009e20000100800ULL, 0x000002002b227825ULL, 0x000fc600078e0004ULL,
0x00000c2f01007387ULL, 0x0009e20000100800ULL, 0x00000200271e7825ULL, 0x000fc800078e0004ULL,
0x0000020051507825ULL, 0x000fc800078e0004ULL, 0x000000102d247825ULL, 0x020fc800078e001cULL,
0x000000102d267825ULL, 0x044fe200078e001eULL, 0x0000000024327faeULL, 0x0009e6000c901c4cULL,
0x000000102d287825ULL, 0x040fe200078e0020ULL, 0x0000000026317faeULL, 0x0009e6000d101c4cULL,
0x000000102d2a7825ULL, 0x040fe200078e0022ULL, 0x0000000028307faeULL, 0x0009e6000d901c4cULL,
0x000000102d2c7825ULL, 0x000fe200078e0050ULL, 0x000000002a2f7faeULL, 0x0009e8000e101c4cULL,
0x000000002c7b7faeULL, 0x0009e2000e901c4cULL, 0x0000000800907947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x004fe2000001162eULL, 0x0000000b0e067291ULL, 0x000fe2000f8e703fULL,
0x000000072e5b7812ULL, 0x000fe400078ec0ffULL, 0x0000000400547810ULL, 0x000fe20007ffe0ffULL,
0x0000000c00527836ULL, 0x040fe20000000000ULL, 0x0000001400587810ULL, 0x000fe20007ffe0ffULL,
0x0000001c00567836ULL, 0x000fe20000000000ULL, 0x0000002e54687212ULL, 0x0c0fe200078e3cffULL,
0x0000000854037824ULL, 0x002fe200078e00ffULL, 0x0000002e52677212ULL, 0x0c0fe200078e3cffULL,
0x0000000852047824ULL, 0x000fe200078e00ffULL, 0x0000002000557810ULL, 0x000fe20007ffe0ffULL,
0x0000000856057824ULL, 0x000fe200078e00ffULL, 0xfffffff803687812ULL, 0x000fe200078ee268ULL,
0x0000000858037824ULL, 0x040fe200078e00ffULL, 0xfffffff804677812ULL, 0x000fe200078ee267ULL,
0x0000000855047824ULL, 0x040fe200078e00ffULL, 0x0000002e58707212ULL, 0x080fe200078e3cffULL,
0x0000001800577836ULL, 0x000fe20000000000ULL, 0x0000002e56647212ULL, 0x080fe200078e3cffULL,
0x0000000800537836ULL, 0x040fe20000000000ULL, 0x0000002e55637212ULL, 0x080fe200078e3cffULL,
0x00000024005a7836ULL, 0x040fe20000000000ULL, 0xfffffff803707812ULL, 0x000fe200078ee270ULL,
0x0000000857037824ULL, 0x000fe200078e00ffULL, 0xfffffff805647812ULL, 0x000fe200078ee264ULL,
0x0000000853027824ULL, 0x000fe200078e00ffULL, 0xfffffff804637812ULL, 0x000fe200078ee263ULL,
0x0000002c006c7836ULL, 0x040fe20000000000ULL, 0x00008a00ff047b82ULL, 0x000e620000000a00ULL,
0x0000002e57667212ULL, 0x080fe200078e3cffULL, 0x00000030006b7836ULL, 0x040fe20000000000ULL,
0x0000002e536d7212ULL, 0x080fe200078e3cffULL, 0x0000003800657836ULL, 0x000fe20000000000ULL,
0xfffffff803667812ULL, 0x000fe200078ee266ULL, 0x000000085a037824ULL, 0x000fe200078e00ffULL,
0xfffffff8026d7812ULL, 0x000fe200078ee26dULL, 0x0000001000027836ULL, 0x000fe20000000000ULL,
0x0000002e5a627212ULL, 0x080fe200078e3cffULL, 0x000000086b087824ULL, 0x000fe200078e00ffULL,
0x00000034006a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000802067824ULL, 0x000fe200078e00ffULL,
0xfffffff803627812ULL, 0x000fe200078ee262ULL, 0x000000086c037824ULL, 0x000fe200078e00ffULL,
0x0000002e026f7212ULL, 0x080fe200078e3cffULL, 0x000000086a097824ULL, 0x000fe200078e00ffULL,
0x0000002800597810ULL, 0x000fe20007ffe0ffULL, 0x0000001100077c36ULL, 0x000fe20008000000ULL,
0x0000002e6c607212ULL, 0x080fe200078e3cffULL, 0x00000008650a7824ULL, 0x000fe200078e00ffULL,
0x0000002e6a5e7212ULL, 0x080fe200078e3cffULL, 0x00000011530b7c36ULL, 0x000fe20008000000ULL,
0xfffffff8066f7812ULL, 0x000fe200078ee26fULL, 0x0000000859067824ULL, 0x040fe200078e00ffULL,
0xfffffff803607812ULL, 0x000fe200078ee260ULL, 0x00000011520d7c36ULL, 0x000fe20008000000ULL,
0x0000002e00037212ULL, 0x080fe200078e3cffULL, 0x0000400006097890ULL, 0x000fe2000fffe03fULL,
0x0000002e59617212ULL, 0x080fe200078e3cffULL, 0x000002000d0c7825ULL, 0x002fe200078e0004ULL,
0x0000002e6b5f7212ULL, 0x000fc400078e3cffULL, 0xfffffff8095e7812ULL, 0x000fe200078ee25eULL,
0x0000001154097c36ULL, 0x000fe20008000000ULL, 0x0000002e655d7212ULL, 0x000fe200078e3cffULL,
0x0000003c006e7836ULL, 0x000fe20000000000ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x00000011020f7c36ULL, 0x000fe20008000000ULL, 0xfffffff806617812ULL, 0x000fe200078ee261ULL,
0x0000020007067825ULL, 0x100fe200078e0004ULL, 0xfffffff8085f7812ULL, 0x000fe400078ee25fULL,
0x000000085b2d7812ULL, 0x000fe200078efcffULL, 0x0000020009087825ULL, 0x000fe200078e0004ULL,
0xfffffff80a5d7812ULL, 0x000fc400078ee25dULL, 0x0ffffff803697812ULL, 0x000fe200078ef82eULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x00000009687c7c11ULL, 0x000fe4000f8e20ffULL,
0x00000009697a7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d127825ULL, 0x000fe200078e0006ULL,
0x000000096d207c11ULL, 0x000fe4000f8e20ffULL, 0x0000002e6e5c7212ULL, 0x000fe200078e3cffULL,
0x0000001158117c36ULL, 0x000fe20008000000ULL, 0x000000036e037819ULL, 0x000fe200000006ffULL,
0x000000102d147825ULL, 0x000fe200078e0008ULL, 0x00000009671f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000127a7faeULL, 0x0003e2000b901c4cULL,
0xfffffff8035c7812ULL, 0x000fe200078ee25cULL, 0x000000102d167825ULL, 0x000fe200078e000aULL,
0x000000096f1e7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000147c7faeULL, 0x000fe2000b901c4cULL,
0x00000009707d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d187825ULL, 0x000fe200078e000cULL,
0x00000009662a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002001007387ULL, 0x000fe20000100800ULL,
0x0000000964297c11ULL, 0x000fe2000f8e20ffULL, 0x000002000f0e7825ULL, 0x100fe200078e0004ULL,
0x0000000963287c11ULL, 0x000fe2000f8e20ffULL, 0x0000000016207faeULL, 0x000fe2000b901c4cULL,
0x0000001157137c10ULL, 0x002fe2000fffe0ffULL, 0x0000020011107825ULL, 0x000fe200078e0004ULL,
0x0000000962277c11ULL, 0x000fe2000f8e20ffULL, 0x0000041f01007387ULL, 0x0003e20000100800ULL,
0x0000000961267c11ULL, 0x000fe2000f8e20ffULL, 0x0000001156037c36ULL, 0x000fe20008000000ULL,
0x0000000960327c11ULL, 0x000fe2000f8e20ffULL, 0x00000000181f7faeULL, 0x0003e2000b901c4cULL,
0x000000102d1a7825ULL, 0x000fe200078e000eULL, 0x000000095f317c11ULL, 0x000fc4000f8e20ffULL,
0x0000081e01007387ULL, 0x0005e20000100800ULL, 0x000000115a217c36ULL, 0x000fe20008000000ULL,
0x000000095e307c11ULL, 0x000fe2000f8e20ffULL, 0x000000102d1c7825ULL, 0x000fe200078e0010ULL,
0x000000001a1e7faeULL, 0x000fe2000b901c4cULL, 0x000000095d2f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000020013127825ULL, 0x100fe200078e0004ULL, 0x000000001c7d7faeULL, 0x0007e2000b901c4cULL,
0x000000095c7b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000011551f7c36ULL, 0x002fe20008000000ULL,
0x0000142a01007387ULL, 0x000fe20000100800ULL, 0x0000020003147825ULL, 0x000fc600078e0004ULL,
0x0000102901007387ULL, 0x0003e20000100800ULL, 0x000002001f167825ULL, 0x000fc600078e0004ULL,
0x00001c2801007387ULL, 0x000fe20000100800ULL, 0x0000020021187825ULL, 0x000fc600078e0004ULL,
0x00002c2701007387ULL, 0x0009e20000100800ULL, 0x0000001159237c36ULL, 0x000fe40008000000ULL,
0x000000102d1c7825ULL, 0x048fe200078e0012ULL, 0x0000282601007387ULL, 0x0007e60000100800ULL,
0x000000102d1e7825ULL, 0x004fe200078e0014ULL, 0x000000001c2a7faeULL, 0x000fe6000b901c4cULL,
0x00000200231a7825ULL, 0x000fe200078e0004ULL, 0x000000001e297faeULL, 0x0003e6000b901c4cULL,
0x000000102d207825ULL, 0x040fe200078e0016ULL, 0x0000243201007387ULL, 0x0005e60000100800ULL,
0x000000102d227825ULL, 0x000fe200078e0018ULL, 0x0000000020287faeULL, 0x000fe6000b901c4cULL,
0x000000116c037c36ULL, 0x000fe20008000000ULL, 0x0000000022277faeULL, 0x0009e2000b901c4cULL,
0x000000116a297c36ULL, 0x002fc40008000000ULL, 0x00000011652b7c36ULL, 0x000fe20008000000ULL,
0x0000203101007387ULL, 0x0003e20000100800ULL, 0x000000102d247825ULL, 0x000fc600078e001aULL,
0x0000183001007387ULL, 0x0003e20000100800ULL, 0x000000116e517c36ULL, 0x000fe40008000000ULL,
0x00000200031c7825ULL, 0x100fe200078e0004ULL, 0x000000116b277c10ULL, 0x010fe2000fffe0ffULL,
0x0000000024267faeULL, 0x0009e4000b901c4cULL, 0x0000020029207825ULL, 0x100fe400078e0004ULL,
0x00000c2f01007387ULL, 0x0003e40000100800ULL, 0x00000200271e7825ULL, 0x000fc800078e0004ULL,
0x000002002b227825ULL, 0x000fc800078e0004ULL, 0x0000020051507825ULL, 0x000fc800078e0004ULL,
0x000000102d247825ULL, 0x010fc800078e001cULL, 0x000000102d267825ULL, 0x048fe200078e001eULL,
0x0000000024327faeULL, 0x0003e6000b901c4cULL, 0x000000102d287825ULL, 0x040fe200078e0020ULL,
0x0000000026317faeULL, 0x0003e6000b901c4cULL, 0x000000102d2a7825ULL, 0x040fe200078e0022ULL,
0x0000000028307faeULL, 0x0003e6000b901c4cULL, 0x000000102d2c7825ULL, 0x000fe200078e0050ULL,
0x000000002a2f7faeULL, 0x0003e8000b901c4cULL, 0x000000002c7b7faeULL, 0x0043e4000b901c4cULL,
0x00000004ff277819ULL, 0x012fe2000001162eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000085b037812ULL, 0x000fe200078ef82eULL, 0x0000200006067890ULL, 0x000fe2000fffe03fULL,
0x0000000100797812ULL, 0x000fe200078ec0ffULL, 0x0000000827247824ULL, 0x040fe400078e00ffULL,
0x0000000227287836ULL, 0x000fc60000000000ULL, 0xfffffff824257812ULL, 0x000fe400078ee25bULL,
0x0000000727247812ULL, 0x000fe400078e7803ULL, 0x0000000725767812ULL, 0x040fe200078ec0ffULL,
0x0000000825757824ULL, 0x000fe200078e00ffULL, 0x0000001025747810ULL, 0x000fe20007ffe0ffULL,
0x0000002003247824ULL, 0x000fe200078e0224ULL, 0x0000000176267812ULL, 0x000fe200078e7800ULL,
0x0000002025777836ULL, 0x000fe20000000000ULL, 0x0000000774737812ULL, 0x040fe200078ec0ffULL,
0x0000000874747824ULL, 0x000fe200078e00ffULL, 0x0000007526267212ULL, 0x000fc400078efcffULL,
0x0000000173277812ULL, 0x000fe200078e7800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000b24247c11ULL, 0x000fe2000f8e20ffULL, 0x0000302601007387ULL, 0x0003e20000100800ULL,
0x0000000626297c11ULL, 0x000fe4000f8e20ffULL, 0x0000003025257810ULL, 0x000fe20007ffe0ffULL,
0x000000002440783bULL, 0x0005e20000000200ULL, 0x0000000777727812ULL, 0x040fe200078ec0ffULL,
0x0000000877777824ULL, 0x000fe200078e00ffULL, 0x0000000725717812ULL, 0x040fe200078ec0ffULL,
0x0000702901007387ULL, 0x000fe20000100800ULL, 0x0000000825787824ULL, 0x000fe200078e00ffULL,
0x0000007427267212ULL, 0x002fc400078efcffULL, 0x0000000171257812ULL, 0x000fe200078e7800ULL,
0x000000002934783bULL, 0x000e620000000200ULL, 0x0000000626247c11ULL, 0x004fe4000f8e20ffULL,
0x0000000728287812ULL, 0x000fe200078e7803ULL, 0x0000342601007387ULL, 0x0005e20000100800ULL,
0x0000000273277812ULL, 0x000fe400078e1e79ULL, 0x00000078252d7212ULL, 0x000fe200078efcffULL,
0x000000002444783bULL, 0x000fe20000000200ULL, 0x0000002003287824ULL, 0x000fc400078e0228ULL,
0x000000062d257c11ULL, 0x000fe2000f8e20ffULL, 0x0000782401007387ULL, 0x0007e20000100800ULL,
0x0000000276267812ULL, 0x004fe400078e1e79ULL, 0x0000000b28287c11ULL, 0x000fe2000f8e20ffULL,
0x00000000254c783bULL, 0x000ea20000000200ULL, 0x00000075262a7212ULL, 0x000fe400078efcffULL,
0x0000000172247812ULL, 0x008fc600078e7800ULL, 0x00004c2a01007387ULL, 0x000fe20000100800ULL,
0x000000062a2c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000007724297212ULL, 0x000fe400078efcffULL,
0x0000007427247212ULL, 0x000fe200078efcffULL, 0x000000002c30783bULL, 0x000fe20000000200ULL,
0x0000000629267c11ULL, 0x000fc6000f8e20ffULL, 0x0000382901007387ULL, 0x000fe80000100800ULL,
0x0000442d01007387ULL, 0x000fe80000100800ULL, 0x0000942c01007387ULL, 0x0003e80000100800ULL,
0x0000502401007387ULL, 0x0007e80000100800ULL, 0x000000002828783bULL, 0x000f220000000200ULL,
0x00000034402c723cULL, 0x002fe600000418ffULL, 0x0000802601007387ULL, 0x000fe20000100800ULL,
0x0000000624247c11ULL, 0x008fc6000f8e20ffULL, 0x00008c2501007387ULL, 0x000fe20000100800ULL,
0x0000004c403c723cULL, 0x004fe600000418ffULL, 0x000000002448783bULL, 0x000e660000000200ULL,
0x000000364034723cULL, 0x000fe200000418ffULL, 0x000000002638783bULL, 0x000ea80000000200ULL,
0x0000982401007387ULL, 0x0007e40000100800ULL, 0x000000444024723cULL, 0x008fec00000418ffULL,
0x000000464044723cULL, 0x000fec00000418ffULL, 0x00000030282c723cULL, 0x010fec000004182cULL,
0x000000322830723cULL, 0x000fec0000041834ULL, 0x000000482824723cULL, 0x002fec0000041824ULL,
0x0000004a2848723cULL, 0x000fec0000041844ULL, 0x000000384034723cULL, 0x004fe200000418ffULL,
0x0000000272447812ULL, 0x000fc400078e1e79ULL, 0x0000000271457812ULL, 0x000fe400078e1e79ULL,
0x00000077444c7212ULL, 0x000fe200078efcffULL, 0x0000003a4038723cULL, 0x000fe200000418ffULL,
0x00000078454d7212ULL, 0x000fe400078efcffULL, 0x000000064c467c11ULL, 0x000fe2000f8e20ffULL,
0x00003c4c01007387ULL, 0x0003e40000100800ULL, 0x0000004e4040723cULL, 0x000fe400000418ffULL,
0x0000484d01007387ULL, 0x000fe80000100800ULL, 0x0000844601007387ULL, 0x000fe20000100800ULL,
0x000000064d4c7c11ULL, 0x002fc6000f8e20ffULL, 0x000000004644783bULL, 0x000e680000000200ULL,
0x0000904c01007387ULL, 0x000fe80000100800ULL, 0x000000004c4c783bULL, 0x000ea20000000200ULL,
0x000000442834723cULL, 0x002fe20000041834ULL, 0x0000000000457919ULL, 0x000e6a0000000000ULL,
0x000000462838723cULL, 0x000fec0000041838ULL, 0x0000004c283c723cULL, 0x004fec000004183cULL,
0x0000004e2840723cULL, 0x000fe20000041840ULL, 0x00000004724d7812ULL, 0x000fc400078e1e79ULL,
0x00000004714c7812ULL, 0x000fe400078e1e79ULL, 0x000000774d4d7212ULL, 0x000fe400078efcffULL,
0x0000000476287812ULL, 0x000fe400078e1e79ULL, 0x0000000676767812ULL, 0x000fe400078e1e79ULL,
0x00000075284f7212ULL, 0x080fe400078efcffULL, 0x0000007576767212ULL, 0x000fc400078efcffULL,
0x00000004ff457819ULL, 0x002fe40000011645ULL, 0x000000064f2a7c11ULL, 0x000fe4000f8e20ffULL,
0x000000064d757c11ULL, 0x000fe2000f8e20ffULL, 0x0000000445297836ULL, 0x000fe20000000000ULL,
0x000000784c4c7212ULL, 0x000fe200078efcffULL, 0x0000742a01007387ULL, 0x000fe20000100800ULL,
0x0000000672727812ULL, 0x000fe400078e1e79ULL, 0x0000000729297812ULL, 0x000fc400078e7803ULL,
0x0000007772727212ULL, 0x000fe400078efcffULL, 0x0000000671717812ULL, 0x000fe200078e1e79ULL,
0x0000002003297824ULL, 0x000fc600078e0229ULL, 0x0000007871717212ULL, 0x000fe400078efcffULL,
0x0000000b29297c11ULL, 0x000fca000f8e20ffULL, 0x000000002944783bULL, 0x000fe80000000200ULL,
0x000000002a28783bULL, 0x000e640000000200ULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x0000000473287812ULL, 0x000fc400078e1e79ULL,
0x0000000673737812ULL, 0x000fe400078e1e79ULL, 0x00000074284e7212ULL, 0x080fe400078efcffULL,
0x0000007473737212ULL, 0x000fe400078efcffULL, 0x000000064e297c11ULL, 0x000fe4000f8e20ffULL,
0x000000064c747c11ULL, 0x000fc6000f8e20ffULL, 0x00006c2901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e680000000200ULL, 0x0000607501007387ULL, 0x000fe80000100800ULL,
0x0000687401007387ULL, 0x000fe20000100800ULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000007528783bULL, 0x0002a40000000200ULL,
0x0000000000757919ULL, 0x002e660000000000ULL, 0x000000284434723cULL, 0x004fe20000041834ULL,
0x00000004ff757819ULL, 0x002fca0000011675ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x000000007428783bULL, 0x0002a40000000200ULL, 0x0000000676747c11ULL, 0x002fca000f8e20ffULL,
0x0000647401007387ULL, 0x000fe20000100800ULL, 0x00000028443c723cULL, 0x004fec000004183cULL,
0x0000002a4440723cULL, 0x000fe20000041840ULL, 0x0000000675287836ULL, 0x000fca0000000000ULL,
0x0000000728287812ULL, 0x000fc800078e7803ULL, 0x0000002803287211ULL, 0x000fc800078e28ffULL,
0x0000000b28287c11ULL, 0x000fca000f8e20ffULL, 0x000000002844783bULL, 0x000fe80000000200ULL,
0x000000007428783bULL, 0x0002a40000000200ULL, 0x0000000673747c11ULL, 0x002fca000f8e20ffULL,
0x00005c7401007387ULL, 0x000fe20000100800ULL, 0x00000028442c723cULL, 0x004fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000007428783bULL, 0x0002a40000000200ULL,
0x0000000672747c11ULL, 0x002fca000f8e20ffULL, 0x0000587401007387ULL, 0x000fe20000100800ULL,
0x000000284424723cULL, 0x004fec0000041824ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x000000007428783bULL, 0x0002a40000000200ULL, 0x0000000671747c11ULL, 0x002fca000f8e20ffULL,
0x0000547401007387ULL, 0x000fe20000100800ULL, 0x000000284434723cULL, 0x004fec0000041834ULL,
0x0000002a4438723cULL, 0x000fe20000041838ULL, 0x000000007428783bULL, 0x000e6a0000000200ULL,
0x00000028443c723cULL, 0x002fec000004183cULL, 0x0000002a4440723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000400188947ULL, 0x000fde0003800000ULL,
0x8000000714087290ULL, 0x000fe2000fffe03fULL, 0x000000105b2a7812ULL, 0x000fe400078efcffULL,
0x0000000669697c11ULL, 0x000fe4000f8e20ffULL, 0x0000000668687c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x000fe200078e0006ULL, 0x0000000800007c0cULL, 0x000fe4000bf26070ULL,
0x000000066d6d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000667677c11ULL, 0x000fc4000f8e20ffULL,
0x000000066f6f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000670707c11ULL, 0x000fe4000f8e20ffULL,
0x0000000666667c11ULL, 0x000fe4000f8e20ffULL, 0x0000000664647c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028697faeULL, 0x0003e2000c901c4cULL,
0x0000000854007c0cULL, 0x000fe4000bf26070ULL, 0x0000000663637c11ULL, 0x000fc4000f8e20ffULL,
0x0000000662627c11ULL, 0x000fe4000f8e20ffULL, 0x0000000661617c11ULL, 0x000fe4000f8e20ffULL,
0x0000000660607c11ULL, 0x000fe4000f8e20ffULL, 0x000000065f5f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x002fe200078e0008ULL, 0x000000065e5e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000065d5d7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000028687faeULL, 0x0003e2000c901c4cULL,
0x0000000853007c0cULL, 0x000fe4000bf26070ULL, 0x000000065c5c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x002fd400078e000aULL, 0x00000000286d7faeULL, 0x0003e2000c901c4cULL,
0x0000000852007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e000cULL,
0x0000000028677faeULL, 0x0003e2000c901c4cULL, 0x0000000802007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e000eULL, 0x00000000286f7faeULL, 0x0003e2000c901c4cULL,
0x0000000858007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0010ULL,
0x0000000028707faeULL, 0x0003e2000c901c4cULL, 0x0000000857007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0012ULL, 0x0000000028667faeULL, 0x0003e2000c901c4cULL,
0x0000000856007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0014ULL,
0x0000000028647faeULL, 0x0003e2000c901c4cULL, 0x0000000855007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0016ULL, 0x0000000028637faeULL, 0x0003e2000c901c4cULL,
0x000000085a007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0018ULL,
0x0000000028627faeULL, 0x0003e2000c901c4cULL, 0x0000000859007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e001aULL, 0x0000000028617faeULL, 0x0003e2000c901c4cULL,
0x000000086c007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e001cULL,
0x0000000028607faeULL, 0x0003e2000c901c4cULL, 0x000000086b007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e001eULL, 0x00000000285f7faeULL, 0x0003e2000c901c4cULL,
0x000000086a007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0020ULL,
0x00000000285e7faeULL, 0x0003e2000c901c4cULL, 0x0000000865007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fc800078e0022ULL, 0x000000102a2a7825ULL, 0x000fd000078e0050ULL,
0x00000000285d7faeULL, 0x0003e2000c901c4cULL, 0x000000086e007c0cULL, 0x000fda000bf26070ULL,
0x000000002a5c7faeULL, 0x0003e2000c901c4cULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x000000105b2a7812ULL, 0x000fe400078efcffULL, 0x0000000669697c11ULL, 0x000fe4000f8e20ffULL,
0x0000000668687c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x000fe200078e0006ULL,
0x000000066d6d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000667677c11ULL, 0x000fe4000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028697faeULL, 0x0003e2000b901c4cULL,
0x000000066f6f7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000670707c11ULL, 0x000fe4000f8e20ffULL,
0x0000000666667c11ULL, 0x000fe4000f8e20ffULL, 0x0000000664647c11ULL, 0x000fe4000f8e20ffULL,
0x0000000663637c11ULL, 0x000fe4000f8e20ffULL, 0x0000000662627c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x002fe200078e0008ULL, 0x0000000661617c11ULL, 0x000fc4000f8e20ffULL,
0x0000000660607c11ULL, 0x000fe4000f8e20ffULL, 0x0000000028687faeULL, 0x0003e2000b901c4cULL,
0x000000065f5f7c11ULL, 0x000fe4000f8e20ffULL, 0x000000065e5e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000065d5d7c11ULL, 0x000fe4000f8e20ffULL, 0x000000065c5c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x002fca00078e000aULL, 0x00000000286d7faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e000cULL, 0x0000000028677faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e000eULL, 0x00000000286f7faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e0010ULL, 0x0000000028707faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e0012ULL, 0x0000000028667faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e0014ULL, 0x0000000028647faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e0016ULL, 0x0000000028637faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e0018ULL, 0x0000000028627faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e001aULL, 0x0000000028617faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e001cULL, 0x0000000028607faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e001eULL, 0x00000000285f7faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fca00078e0020ULL, 0x00000000285e7faeULL, 0x0003e4000b901c4cULL,
0x000000102a287825ULL, 0x002fc800078e0022ULL, 0x000000102a2a7825ULL, 0x000fe200078e0050ULL,
0x00000000285d7faeULL, 0x0003e8000b901c4cULL, 0x000000002a5c7faeULL, 0x0003e4000b901c4cULL,
0x0000300001297983ULL, 0x002ea80000300800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000875287836ULL, 0x000fc60000000000ULL, 0x00004c0001797983ULL, 0x000ee40000300800ULL,
0x0000000728287812ULL, 0x000fe400078e7803ULL, 0x0000500001787983ULL, 0x000f260000300800ULL,
0x0000002003287824ULL, 0x000fe200078e0228ULL, 0x00003c0001777983ULL, 0x000f680000300800ULL,
0x0000000b28287c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002844783bULL, 0x000fe20000000200ULL, 0x0000000929297c11ULL, 0x004fca000f8e20ffULL,
0x00009c2901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e680000000200ULL,
0x0000480001747983ULL, 0x000ea20000300800ULL, 0x00000028442c723cULL, 0x002fe6000004182cULL,
0x0000340001297983ULL, 0x000ea60000300800ULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x0000000929297c11ULL, 0x004fca000f8e20ffULL, 0x0000882901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e640000000200ULL, 0x000000284424723cULL, 0x002fe40000041824ULL,
0x0000380001297983ULL, 0x000ea80000300800ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x0000000929297c11ULL, 0x004fca000f8e20ffULL, 0x00007c2901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e640000000200ULL, 0x000000284434723cULL, 0x002fe40000041834ULL,
0x0000440001297983ULL, 0x000ea80000300800ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x0000000979797c11ULL, 0x008fc4000f8e20ffULL, 0x0000000978787c11ULL, 0x010fe4000f8e20ffULL,
0x0000000977777c11ULL, 0x020fe4000f8e20ffULL, 0x0000000929297c11ULL, 0x004fca000f8e20ffULL,
0x0000442901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x00000028443c723cULL, 0x002fee000004183cULL, 0x0000000a75287836ULL, 0x000fca0000000000ULL,
0x0000000728287812ULL, 0x000fca00078e7803ULL, 0x0000002003287824ULL, 0x000fe200078e0228ULL,
0x0000002a4440723cULL, 0x000fe80000041840ULL, 0x0000000b28287c11ULL, 0x000fca000f8e20ffULL,
0x000000002844783bULL, 0x000fe80000000200ULL, 0x000000007928783bULL, 0x000e640000000200ULL,
0x00000028442c723cULL, 0x002fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x000000007828783bULL, 0x000e680000000200ULL, 0x0000387901007387ULL, 0x0005e20000100800ULL,
0x000000284424723cULL, 0x002fec0000041824ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x000000007728783bULL, 0x000e620000000200ULL, 0x0000000974797c11ULL, 0x004fc8000f8e20ffULL,
0x000000284434723cULL, 0x002fec0000041834ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x000000007928783bULL, 0x000e680000000200ULL, 0x0000347801007387ULL, 0x0005e40000100800ULL,
0x000000094f787c11ULL, 0x004fe2000f8e20ffULL, 0x00000028443c723cULL, 0x002fee000004183cULL,
0x0000000c75287836ULL, 0x000fca0000000000ULL, 0x0000000728287812ULL, 0x000fc800078e7803ULL,
0x0000002803287211ULL, 0x000fc800078e28ffULL, 0x0000000b28287c11ULL, 0x000fe2000f8e20ffULL,
0x0000002a4440723cULL, 0x000fe80000041840ULL, 0x000000002844783bULL, 0x000fe80000000200ULL,
0x000000007828783bULL, 0x000e680000000200ULL, 0x0000307701007387ULL, 0x0005e40000100800ULL,
0x000000094e777c11ULL, 0x004fe2000f8e20ffULL, 0x00000028442c723cULL, 0x002fec000004182cULL,
0x0000002a4430723cULL, 0x000fe20000041830ULL, 0x000000007728783bULL, 0x000e620000000200ULL,
0x000000094d757c11ULL, 0x000fc4000f8e20ffULL, 0x000000094c747c11ULL, 0x000fe4000f8e20ffULL,
0x000000284424723cULL, 0x002fec0000041824ULL, 0x0000002a4448723cULL, 0x000fe20000041848ULL,
0x000000007528783bULL, 0x000e620000000200ULL, 0x00000000004f7919ULL, 0x000ea80000000000ULL,
0x000000284434723cULL, 0x002fec0000041834ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x000000007428783bULL, 0x000e620000000200ULL, 0x00000004ff4f7819ULL, 0x004fc4000001164fULL,
0x00000009734e7c11ULL, 0x000fe4000f8e20ffULL, 0x00000009724d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000180001737983ULL, 0x0005620000100800ULL, 0x00000009714c7c11ULL, 0x000fc6000f8e20ffULL,
0x0000200001727983ULL, 0x0005680000100800ULL, 0x0000240001717983ULL, 0x0005620000100800ULL,
0x00000028443c723cULL, 0x002fee000004183cULL, 0x0000000e4f287836ULL, 0x000fe20000000000ULL,
0x00000009764f7c11ULL, 0x000fc4000f8e20ffULL, 0x00000c0001767983ULL, 0x0005640000100800ULL,
0x0000000728287812ULL, 0x000fe200078e7803ULL, 0x0000002a4440723cULL, 0x000fe80000041840ULL,
0x0000002003287824ULL, 0x000fca00078e0228ULL, 0x0000000b28447c11ULL, 0x000fe4000f8e20ffULL,
0x000000004f28783bULL, 0x000fe80000000200ULL, 0x000000004444783bULL, 0x000e640000000200ULL,
0x00000028442c723cULL, 0x002fec000004182cULL, 0x0000002a4430723cULL, 0x000fe20000041830ULL,
0x000000004e28783bULL, 0x000e6a0000000200ULL, 0x000000284424723cULL, 0x002fec0000041824ULL,
0x0000002a4448723cULL, 0x000fe20000041848ULL, 0x000000004d28783bULL, 0x000e6a0000000200ULL,
0x000000284434723cULL, 0x002fec0000041834ULL, 0x0000002a4438723cULL, 0x000fe20000041838ULL,
0x000000004c28783bULL, 0x000e6a0000000200ULL, 0x00000028443c723cULL, 0x002fec000004183cULL,
0x0000002a4440723cULL, 0x000fe20000041840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000f88947ULL, 0x004fde0003800000ULL, 0x00000000012a7983ULL, 0x000ea80000300800ULL,
0x00000400012b7983ULL, 0x000ee20000300800ULL, 0x8000000714067290ULL, 0x000fe2000fffe03fULL,
0x000000185b287812ULL, 0x000fe400078efcffULL, 0x0000080001457983ULL, 0x000f260000300800ULL,
0x0000000600007c0cULL, 0x000fe2000bf06070ULL, 0x0000001028067825ULL, 0x000fe200078e0006ULL,
0x0000000652007c0cULL, 0x000fe2000bf26070ULL, 0x0000140001467983ULL, 0x000f240000300800ULL,
0x0000001028087825ULL, 0x000fc400078e0008ULL, 0x0000100001477983ULL, 0x000f280000300800ULL,
0x00001c0001297983ULL, 0x000f220000300800ULL, 0x00000010280a7825ULL, 0x000fc600078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000067a7faeULL, 0x000fe2000c101c4cULL,
0x0000000654007c0cULL, 0x000fe2000bf06070ULL, 0x00000010280c7825ULL, 0x000fd800078e000cULL,
0x00000000087c7faeULL, 0x000fe2000c101c4cULL, 0x0000000653007c0cULL, 0x000fda000bf06070ULL,
0x000000000a2a7faeULL, 0x004fe8000c101c4cULL, 0x000000000c2b7faeULL, 0x008fe8000c901c4cULL,
0x00002c00012a7983ULL, 0x000ea80000300800ULL, 0x00002800012b7983ULL, 0x000ee20000300800ULL,
0x0000000602007c0cULL, 0x000fe2000bf06070ULL, 0x00000010280e7825ULL, 0x000fe200078e000eULL,
0x0000000658007c0cULL, 0x000fc4000bf26070ULL, 0x0000000657007c0cULL, 0x000fe2000bf46070ULL,
0x0000001028107825ULL, 0x000fe200078e0010ULL, 0x0000000656007c0cULL, 0x000fe4000bf66070ULL,
0x0000000655007c0cULL, 0x000fe2000bf86070ULL, 0x0000001028127825ULL, 0x000fe200078e0012ULL,
0x0000000665007c0cULL, 0x000fe4000bfa6070ULL, 0x000000066e007c0cULL, 0x000fe2000bfc6070ULL,
0x0000001028147825ULL, 0x000fe200078e0014ULL, 0x000000000e457faeULL, 0x010fe2000c101c4cULL,
0x000000065a007c0cULL, 0x000fc4000bf06070ULL, 0x0000001028167825ULL, 0x040fe200078e0016ULL,
0x00000000107d7faeULL, 0x000fe2000c901c4cULL, 0x0000000659007c0cULL, 0x000fe4000bf26070ULL,
0x0000001028187825ULL, 0x000fe200078e0018ULL, 0x0000000012467faeULL, 0x000fe2000d101c4cULL,
0x000000066c007c0cULL, 0x000fe4000bf46070ULL, 0x00000010281a7825ULL, 0x000fe200078e001aULL,
0x0000000014477faeULL, 0x000fe2000d901c4cULL, 0x000000066b007c0cULL, 0x000fc4000bf66070ULL,
0x00000010281c7825ULL, 0x000fe200078e001cULL, 0x0000000016297faeULL, 0x0009e2000e101c4cULL,
0x000000066a007c0cULL, 0x000fe4000bf86070ULL, 0x00000010281e7825ULL, 0x000fc800078e001eULL,
0x0000001028207825ULL, 0x000fc800078e0020ULL, 0x0000001028227825ULL, 0x000fc800078e0022ULL,
0x0000001028287825ULL, 0x010fe200078e0050ULL, 0x00000000182a7faeULL, 0x0043e8000c101c4cULL,
0x000000001a2b7faeULL, 0x0083e8000c901c4cULL, 0x000000001c717faeULL, 0x0203e8000d101c4cULL,
0x000000001e727faeULL, 0x0003e8000d901c4cULL, 0x0000000020737faeULL, 0x0003e8000e101c4cULL,
0x0000000022767faeULL, 0x0003e8000e901c4cULL, 0x00000000287b7faeULL, 0x0003e2000f101c4cULL,
0x0000000000b07947ULL, 0x000fea0003800000ULL, 0x000000185b287812ULL, 0x000fe200078efcffULL,
0x0000040001297983ULL, 0x000ea80000300800ULL, 0x0000080001477983ULL, 0x000ee20000300800ULL,
0x0000001028067825ULL, 0x000fc600078e0006ULL, 0x0000140001467983ULL, 0x000f280000300800ULL,
0x0000100001457983ULL, 0x000ea80000300800ULL, 0x00001c0001447983ULL, 0x000ea80000300800ULL,
0x00002c00012b7983ULL, 0x000ea80000300800ULL, 0x00002800012a7983ULL, 0x000ea80000300800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000067a7faeULL, 0x000fe8000b901c4cULL,
0x0000000001077983ULL, 0x000ea20000300800ULL, 0x0000001028087825ULL, 0x000fc800078e0008ULL,
0x00000010280a7825ULL, 0x040fe200078e000aULL, 0x00000000087c7faeULL, 0x000fe6000b901c4cULL,
0x00000010280c7825ULL, 0x000fc800078e000cULL, 0x00000010280e7825ULL, 0x000fc800078e000eULL,
0x0000001028107825ULL, 0x000fc800078e0010ULL, 0x0000001028127825ULL, 0x000fc800078e0012ULL,
0x0000001028147825ULL, 0x000fc800078e0014ULL, 0x0000001028167825ULL, 0x000fc800078e0016ULL,
0x0000001028187825ULL, 0x000fc800078e0018ULL, 0x00000010281a7825ULL, 0x000fc800078e001aULL,
0x00000010281c7825ULL, 0x000fc800078e001cULL, 0x00000010281e7825ULL, 0x000fc800078e001eULL,
0x0000001028207825ULL, 0x000fc800078e0020ULL, 0x0000001028227825ULL, 0x040fe200078e0022ULL,
0x000000000a077faeULL, 0x004fe8000b901c4cULL, 0x000000000c297faeULL, 0x0005e8000b901c4cULL,
0x000000000e477faeULL, 0x0083e8000b901c4cULL, 0x00000000107d7faeULL, 0x0003e8000b901c4cULL,
0x0000000012467faeULL, 0x0103e2000b901c4cULL, 0x0000001028287825ULL, 0x004fc600078e0050ULL,
0x0000000014457faeULL, 0x0003e8000b901c4cULL, 0x0000000016447faeULL, 0x0003e8000b901c4cULL,
0x00000000182b7faeULL, 0x0003e8000b901c4cULL, 0x000000001a2a7faeULL, 0x0003e8000b901c4cULL,
0x000000001c717faeULL, 0x0203e8000b901c4cULL, 0x000000001e727faeULL, 0x0003e8000b901c4cULL,
0x0000000020737faeULL, 0x0003e8000b901c4cULL, 0x0000000022767faeULL, 0x0003e8000b901c4cULL,
0x00000000287b7faeULL, 0x0003e4000b901c4cULL, 0x0000700001087983ULL, 0x002ea80000300800ULL,
0x0000780001077983ULL, 0x000ee80000300800ULL, 0x0000800001167983ULL, 0x000f280000300800ULL,
0x00008c0001157983ULL, 0x000f680000300800ULL, 0x0000940001147983ULL, 0x000f280000300800ULL,
0x0000980001287983ULL, 0x000f220000300800ULL, 0x0000000000067919ULL, 0x000e660000000000ULL,
0x00000000000079afULL, 0x000e280000000000ULL, 0x0000840001237983ULL, 0x000f280000300800ULL,
0x0000900001227983ULL, 0x000f280000300800ULL, 0x0000740001217983ULL, 0x000f280000300800ULL,
0x00006c0001207983ULL, 0x000f280000300800ULL, 0x0000600001477983ULL, 0x000f220000300800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000004ff467819ULL, 0x002fe20000011606ULL,
0x0000680001457983ULL, 0x000f280000300800ULL, 0x0000001046067836ULL, 0x000fe20000000000ULL,
0x00006400012b7983ULL, 0x000f280000300800ULL, 0x0000000706067812ULL, 0x000fe200078e7803ULL,
0x00005c00012a7983ULL, 0x000f280000300800ULL, 0x0000002003067824ULL, 0x000fe200078e0206ULL,
0x0000580001297983ULL, 0x000f280000300800ULL, 0x0000000b06067c11ULL, 0x000fca000f8e20ffULL,
0x00000000060c783bULL, 0x000fe80000000200ULL, 0x000000000810783bULL, 0x004fe80000000200ULL,
0x000000000708783bULL, 0x008e680000000200ULL, 0x00000000151c783bULL, 0x020ea80000000200ULL,
0x000000001418783bULL, 0x010fe20000000200ULL, 0x000000080c24723cULL, 0x002fec0000041824ULL,
0x0000000a0c48723cULL, 0x000fe20000041848ULL, 0x000000002808783bULL, 0x0003e80000000200ULL,
0x0000540001287983ULL, 0x002ee80000300800ULL, 0x0000400001447983ULL, 0x000f220000100800ULL,
0x000000100c2c723cULL, 0x000fee000004182cULL, 0x0000001246107836ULL, 0x000fca0000000000ULL,
0x0000000710107812ULL, 0x000fe200078e7803ULL, 0x000000120c30723cULL, 0x000fe60000041830ULL,
0x0000001003077211ULL, 0x000fe400078e28ffULL, 0x000000001610783bULL, 0x000e640000000200ULL,
0x0000000b07077c11ULL, 0x000fca000f8e20ffULL, 0x000000000714783bULL, 0x000f620000000200ULL,
0x0000001c0c3c723cULL, 0x004fe2000004183cULL, 0x0000001446067836ULL, 0x000fca0000000000ULL,
0x0000001e0c40723cULL, 0x000fe20000041840ULL, 0x0000000706067812ULL, 0x000fe200078e7803ULL,
0x00000000211c783bULL, 0x000fe80000000200ULL, 0x0000002003067824ULL, 0x000fe200078e0206ULL,
0x000000100c34723cULL, 0x002fec0000041834ULL, 0x000000120c38723cULL, 0x000fe20000041838ULL,
0x00000000220c783bULL, 0x000e680000000200ULL, 0x000000002310783bULL, 0x000ea20000000200ULL,
0x0000000b06067c11ULL, 0x000fe2000f8e20ffULL, 0x00000018142c723cULL, 0x020fe4000004182cULL,
0x000000002020783bULL, 0x000fe80000000200ULL, 0x0000001a1430723cULL, 0x000fe20000041830ULL,
0x000000000618783bULL, 0x000f6a0000000200ULL, 0x000000081424723cULL, 0x000fec0000041824ULL,
0x0000000a1448723cULL, 0x000fe20000041848ULL, 0x000000004708783bULL, 0x000f6a0000000200ULL,
0x0000000c143c723cULL, 0x002fec000004183cULL, 0x0000000e1440723cULL, 0x000fe20000041840ULL,
0x00000000450c783bULL, 0x000e6a0000000200ULL, 0x000000101434723cULL, 0x004fee0000041834ULL,
0x0000001646107836ULL, 0x000fca0000000000ULL, 0x0000000710107812ULL, 0x000fe200078e7803ULL,
0x000000121438723cULL, 0x000fe20000041838ULL, 0x000000002a14783bULL, 0x000fe60000000200ULL,
0x0000002003107824ULL, 0x000fca00078e0210ULL, 0x0000000b10107c11ULL, 0x000fe2000f8e20ffULL,
0x0000001c182c723cULL, 0x020fea000004182cULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x0000001e1830723cULL, 0x000fe60000041830ULL, 0x000000002b1c783bULL, 0x000f660000000200ULL,
0x000000201824723cULL, 0x000fec0000041824ULL, 0x000000221848723cULL, 0x000fe20000041848ULL,
0x000000002920783bULL, 0x000f6a0000000200ULL, 0x000000081834723cULL, 0x000fec0000041834ULL,
0x0000000a1838723cULL, 0x000fec0000041838ULL, 0x0000000c183c723cULL, 0x002fec000004183cULL,
0x0000000e1840723cULL, 0x000fec0000041840ULL, 0x000000141024723cULL, 0x004fec0000041824ULL,
0x0000001c102c723cULL, 0x020fec000004182cULL, 0x0000001e1030723cULL, 0x000fec0000041830ULL,
0x000000161048723cULL, 0x000fec0000041848ULL, 0x000000201034723cULL, 0x000fec0000041834ULL,
0x000000221038723cULL, 0x000fe20000041838ULL, 0x000000002828783bULL, 0x008e620000000200ULL,
0x00000000440872caULL, 0x010fc400000e0000ULL, 0x0000000000447919ULL, 0x000eb60000000000ULL,
0x000000080f087290ULL, 0x000fc8000fffe03fULL, 0x0000000108067890ULL, 0x000fc8000fffe03fULL,
0x000000050600728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000001008097291ULL, 0x000fc8000f8e403fULL, 0x0000000a040a72a4ULL, 0x000fe2000f8e0209ULL,
0x00000028103c723cULL, 0x002fec000004183cULL, 0x0000002a1040723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000400a48947ULL, 0x004fde0003800000ULL,
0x0000000a54097c36ULL, 0x000fe20008000000ULL, 0x0000000444287819ULL, 0x000fe200000006ffULL,
0x0000000a520d7c36ULL, 0x000fe20008000000ULL, 0x000000091400728cULL, 0x000fe2000bf01070ULL,
0x0000020009087825ULL, 0x100fe200078e0004ULL, 0x0000007028287812ULL, 0x000fe400078ec0ffULL,
0x0000000914067287ULL, 0x000fe2000c000000ULL, 0x0000000a00077c36ULL, 0x000fe20008000000ULL,
0x0000000828087210ULL, 0x000fe20007f3e0ffULL, 0x000002000d0c7825ULL, 0x000fe200078e0004ULL,
0x0000000609067290ULL, 0x000fe2000fffe13fULL, 0x0000000a561f7c10ULL, 0x000fc4000fffe0ffULL,
0x0000000a530b7c36ULL, 0x000fe20008000000ULL, 0x00000009ff097210ULL, 0x000fe20000ffe4ffULL,
0x0000020007067825ULL, 0x100fe200078e0004ULL, 0x0000000c280c7210ULL, 0x000fe40007f3e0ffULL,
0x0000000653007c0cULL, 0x000fe2000bf66070ULL, 0x000002000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000000628067210ULL, 0x000fe40007f1e0ffULL, 0x0000000602007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000000600007c0cULL, 0x000fe2000bf26070ULL,
0x0000000a020f7c36ULL, 0x000fe20008000000ULL, 0x0000000a280a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000654007c0cULL, 0x000fe2000bf06070ULL,
0x0000000a58237c36ULL, 0x000fe20008000000ULL, 0x0000000a6a137c10ULL, 0x000fe2000fffe0ffULL,
0x0000000a57217c36ULL, 0x000fc40008000000ULL, 0x000002000f0e7825ULL, 0x000fc800078e0004ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000652007c0cULL, 0x000fe2000bf46070ULL,
0x0000020023227825ULL, 0x100fe200078e0004ULL, 0x0000000e280e7210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006697faeULL, 0x0003e4000c901c4cULL,
0x0000020021207825ULL, 0x000fe200078e0004ULL, 0x0000002228227210ULL, 0x000fe20007fde0ffULL,
0x0000000008687faeULL, 0x0005e2000c101c4cULL, 0x0000000657007c0cULL, 0x000fe2000bf06070ULL,
0x0000000a551d7c36ULL, 0x000fc40008000000ULL, 0x000002001f1e7825ULL, 0x100fe200078e0004ULL,
0x000000000a6d7faeULL, 0x0007e2000d901c4cULL, 0x0000002028067210ULL, 0x002fe40007f3e0ffULL,
0x000002001d1c7825ULL, 0x000fe200078e0004ULL, 0x000000000c677faeULL, 0x0003e2000d101c4cULL,
0x0000000655007c0cULL, 0x000fe4000bf46070ULL, 0x000000ffff0f7224ULL, 0x000fe200028e060fULL,
0x0000000658007c0cULL, 0x000fe2000bfa6070ULL, 0x0000000a5a1b7c36ULL, 0x000fc40008000000ULL,
0x000000ffff237224ULL, 0x000fe200030e0623ULL, 0x0000001e28087210ULL, 0x004fe20007fde0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0621ULL, 0x0000000656007c0cULL, 0x000fe2000bf26070ULL,
0x000002001b1a7825ULL, 0x000fe200078e0004ULL, 0x0000001c280a7210ULL, 0x008fe20007f7e0ffULL,
0x000000000e6f7faeULL, 0x0005e4000e101c4cULL, 0x0000000a59197c36ULL, 0x000fe20008000000ULL,
0x0000001dff0b7210ULL, 0x000fe20001ffe4ffULL, 0x0000000a6c177c36ULL, 0x000fe20008000000ULL,
0x000000065a007c0cULL, 0x000fe2000bf66070ULL, 0x0000000a6b157c36ULL, 0x000fe20008000000ULL,
0x0000000022707faeULL, 0x0007e2000e901c4cULL, 0x000000ffff097224ULL, 0x000fe200030e061fULL,
0x0000001a280c7210ULL, 0x002fe20007fde0ffULL, 0x0000020019187825ULL, 0x000fe200078e0004ULL,
0x0000000006667faeULL, 0x0007e2000c101c4cULL, 0x0000000659007c0cULL, 0x000fc4000bfa6070ULL,
0x0000000a65117c36ULL, 0x000fe20008000000ULL, 0x00000018280e7210ULL, 0x004fe20007f9e0ffULL,
0x0000020017167825ULL, 0x100fe200078e0004ULL, 0x0000000008647faeULL, 0x0007e2000c901c4cULL,
0x000000066b007c0cULL, 0x000fe4000bf26070ULL, 0x0000020015147825ULL, 0x100fe200078e0004ULL,
0x000000000a637faeULL, 0x0007e6000d101c4cULL, 0x0000020011107825ULL, 0x000fe200078e0004ULL,
0x0000001428147210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e061bULL,
0x0000001628167210ULL, 0x000fe20007fde0ffULL, 0x0000020013127825ULL, 0x000fe200078e0004ULL,
0x0000001028107210ULL, 0x000fe40007f5e0ffULL, 0x000000000c627faeULL, 0x0007e2000d901c4cULL,
0x0000000a6e297c36ULL, 0x000fe20008000000ULL, 0x0000000665007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff0f7224ULL, 0x000fe200020e0619ULL, 0x000000066c007c0cULL, 0x000fe2000bf86070ULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000001228127210ULL, 0x000fe20007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x000000066a007c0cULL, 0x000fe2000bf06070ULL,
0x0000020029047825ULL, 0x000fe200078e0004ULL, 0x00000011ff117210ULL, 0x000fe200017fe4ffULL,
0x000000000e617faeULL, 0x0007e2000e901c4cULL, 0x000000066e007c0cULL, 0x000fe2000bf46070ULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x0000000428287210ULL, 0x000fc60007fde0ffULL,
0x0000000016607faeULL, 0x0007e4000e101c4cULL, 0x000000ffff297224ULL, 0x000fe400030e0605ULL,
0x00000000145f7faeULL, 0x0007e8000c901c4cULL, 0x00000000125e7faeULL, 0x0007e8000c101c4cULL,
0x00000000105d7faeULL, 0x0007e8000d901c4cULL, 0x00000000285c7faeULL, 0x0007e2000d101c4cULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x0000000a02157c36ULL, 0x000fe20008000000ULL,
0x0000000a58177c10ULL, 0x000fe2000fffe0ffULL, 0x0000001044027824ULL, 0x000fe200078e00ffULL,
0x0000000a6c137c10ULL, 0x000fe2000fffe0ffULL, 0x0000000a001d7c36ULL, 0x000fe20008000000ULL,
0x0000000a6e297c10ULL, 0x000fe2000fffe0ffULL, 0x0000000a541f7c36ULL, 0x000fe20008000000ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x0000000a53217c36ULL, 0x000fe40008000000ULL,
0x0000000a52237c36ULL, 0x000fc40008000000ULL, 0x000002001d1c7825ULL, 0x000fc800078e0004ULL,
0x000002001f1e7825ULL, 0x000fe200078e0004ULL, 0x0000001c021c7210ULL, 0x000fc60007f1e0ffULL,
0x0000020021207825ULL, 0x000fe200078e0004ULL, 0x0000001e021e7210ULL, 0x000fc60007f3e0ffULL,
0x0000000a57197c36ULL, 0x000fe20008000000ULL, 0x0000002002207210ULL, 0x000fe20007f5e0ffULL,
0x0000020023227825ULL, 0x000fc800078e0004ULL, 0x0000000a561b7c36ULL, 0x000fe20008000000ULL,
0x0000002202227210ULL, 0x000fe20007f7e0ffULL, 0x0000020015147825ULL, 0x000fc800078e0004ULL,
0x0000000a550d7c36ULL, 0x000fe40008000000ULL, 0x0000020017167825ULL, 0x000fc800078e0004ULL,
0x0000020019187825ULL, 0x000fc800078e0004ULL, 0x0000000a5a0f7c36ULL, 0x000fe40008000000ULL,
0x0000000a59117c36ULL, 0x000fe40008000000ULL, 0x000002001b1a7825ULL, 0x000fc800078e0004ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000001402147210ULL, 0x000fe20007f1e0ffULL,
0x000002000d0c7825ULL, 0x000fc600078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c697faeULL, 0x0003e2000b901c4cULL, 0x000000ffff1f7224ULL, 0x000fe200008e061fULL,
0x0000001602167210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200010e0621ULL,
0x0000001802187210ULL, 0x000fe20007f5e0ffULL, 0x000002000f0e7825ULL, 0x100fe200078e0004ULL,
0x00000017ff177210ULL, 0x000fe20000ffe4ffULL, 0x000000001e687faeULL, 0x0003e4000b901c4cULL,
0x0000000a6b077c36ULL, 0x000fe20008000000ULL, 0x0000000e020e7210ULL, 0x000fe20007f3e0ffULL,
0x0000020011107825ULL, 0x000fe200078e0004ULL, 0x00000000206d7faeULL, 0x0003e6000b901c4cULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x0000001a021a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000a6a097c36ULL, 0x000fc40008000000ULL, 0x0000000a650b7c36ULL, 0x000fe20008000000ULL,
0x0000000022677faeULL, 0x0003e2000b901c4cULL, 0x0000020013127825ULL, 0x000fc800078e0004ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000000c020c7210ULL, 0x000fe20007f1e0ffULL,
0x0000020007067825ULL, 0x000fc600078e0004ULL, 0x00000000146f7faeULL, 0x0003e2000b901c4cULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x0000001002107210ULL, 0x000fe20007f5e0ffULL,
0x0000020009087825ULL, 0x100fe200078e0004ULL, 0x0000000016707faeULL, 0x0003e6000b901c4cULL,
0x000002000b0a7825ULL, 0x000fe200078e0004ULL, 0x0000000018667faeULL, 0x0003e6000b901c4cULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x0000001202127210ULL, 0x000fe20007f7e0ffULL,
0x0000020029047825ULL, 0x000fc600078e0004ULL, 0x00000013ff137210ULL, 0x000fe20001ffe4ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000000602067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x0000000802087210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x0000000a020a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000402047210ULL, 0x000fe20007f7e0ffULL,
0x000000001a647faeULL, 0x0003e2000b901c4cULL, 0x000000ffff097224ULL, 0x000fc400008e0609ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x000000000c637faeULL, 0x0003e2000b901c4cULL,
0x000000ffff057224ULL, 0x000fc600018e0605ULL, 0x000000000e627faeULL, 0x0003e8000b901c4cULL,
0x0000000010617faeULL, 0x0003e8000b901c4cULL, 0x0000000012607faeULL, 0x0003e8000b901c4cULL,
0x00000000065f7faeULL, 0x0003e8000b901c4cULL, 0x00000000085e7faeULL, 0x0003e8000b901c4cULL,
0x000000000a5d7faeULL, 0x0003e8000b901c4cULL, 0x00000000045c7faeULL, 0x0003e4000b901c4cULL,
0x00009c0001047983ULL, 0x002ea80000300800ULL, 0x00008800010c7983ULL, 0x008ee80000300800ULL,
0x00007c0001107983ULL, 0x000f280000300800ULL, 0x0000440001157983ULL, 0x000f680000300800ULL,
0x0000380001197983ULL, 0x000f680000300800ULL, 0x0000340001217983ULL, 0x000f680000300800ULL,
0x0000300001207983ULL, 0x000f620000300800ULL, 0x0000001846027836ULL, 0x000fc40000000000ULL,
0x0000001a46147836ULL, 0x000fe20000000000ULL, 0x0000a00001457983ULL, 0x000f640000100800ULL,
0x0000000702027812ULL, 0x000fe400078e7803ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000714187812ULL, 0x000fe400078e7803ULL, 0x0000000203027211ULL, 0x000fc600078e28ffULL,
0x0000002003187824ULL, 0x000fe200078e0218ULL, 0x0000000b02027c11ULL, 0x000fc8000f8e20ffULL,
0x0000000b18187c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000208783bULL, 0x0003e80000000200ULL, 0x000000004f28783bULL, 0x000fe20000000200ULL,
0x0000001c46027836ULL, 0x002fca0000000000ULL, 0x0000000702027812ULL, 0x000fca00078e7803ULL,
0x0000002003027824ULL, 0x000fca00078e0202ULL, 0x0000000b02027c11ULL, 0x000fe2000f8e20ffULL,
0x0000000b0e067291ULL, 0x000fe2000f8e383fULL, 0x000000000404783bULL, 0x004e680000000200ULL,
0x000000000c0c783bULL, 0x008fe80000000200ULL, 0x000000001010783bULL, 0x010ea80000000200ULL,
0x000000001514783bULL, 0x020ee80000000200ULL, 0x00000000191c783bULL, 0x000fe80000000200ULL,
0x000000001818783bULL, 0x000f220000000200ULL, 0x00000004082c723cULL, 0x002fec000004182cULL,
0x000000060830723cULL, 0x000fe20000041830ULL, 0x000000002104783bULL, 0x000e6a0000000200ULL,
0x000000100834723cULL, 0x004fec0000041834ULL, 0x000000120838723cULL, 0x000fe20000041838ULL,
0x000000007910783bULL, 0x000eaa0000000200ULL, 0x0000000c0824723cULL, 0x000fec0000041824ULL,
0x0000000e0848723cULL, 0x000fe20000041848ULL, 0x00000000200c783bULL, 0x000aaa0000000200ULL,
0x00000014083c723cULL, 0x008fec000004183cULL, 0x000000160840723cULL, 0x000fe20000041840ULL,
0x000000007808783bULL, 0x000fe80000000200ULL, 0x000000000214783bULL, 0x000ee20000000200ULL,
0x0000001c182c723cULL, 0x010fe2000004182cULL, 0x0000001e46207836ULL, 0x020fca0000000000ULL,
0x0000001e1830723cULL, 0x000fe20000041830ULL, 0x00000000771c783bULL, 0x000f220000000200ULL,
0x0000000720207812ULL, 0x000fc800078e7803ULL, 0x0000002003037211ULL, 0x000fe200078e28ffULL,
0x000000041824723cULL, 0x002fe20000041824ULL, 0x000000007420783bULL, 0x000e6a0000000200ULL,
0x000000061848723cULL, 0x000fe20000041848ULL, 0x000000007504783bULL, 0x000f6a0000000200ULL,
0x000000121840723cULL, 0x004fe20000041840ULL, 0x0000000b03037c11ULL, 0x000fca000f8e20ffULL,
0x0000000c1834723cULL, 0x000fec0000041834ULL, 0x0000000e1838723cULL, 0x000fe20000041838ULL,
0x00000000030c783bULL, 0x000eaa0000000200ULL, 0x00000010183c723cULL, 0x000fe2000004183cULL,
0x000000004e10783bULL, 0x000ea80000000200ULL, 0x000000004d18783bULL, 0x000ea20000000200ULL,
0x00000008142c723cULL, 0x008fec000004182cULL, 0x0000000a1430723cULL, 0x000fec0000041830ULL,
0x0000001c1408723cULL, 0x010fe20000041824ULL, 0x000000004c24783bULL, 0x000ee20000000200ULL,
0x0000ffff45027812ULL, 0x000fc800078ec0ffULL, 0x000000221440723cULL, 0x002fec0000041840ULL,
0x0000001e1448723cULL, 0x000fe20000041848ULL, 0x0000888002237816ULL, 0x000fca00000000ffULL,
0x000000041434723cULL, 0x020fe20000041834ULL, 0x8000000023237824ULL, 0x000fc800078e00ffULL,
0x02461023ff0075a7ULL, 0x000e620008000152ULL, 0x000000061438723cULL, 0x000fec0000041838ULL,
0x000000201404723cULL, 0x000fec000004183cULL, 0x000000280c2c723cULL, 0x004fec000004182cULL,
0x000000100c1c723cULL, 0x000fec0000041808ULL, 0x000000120c14723cULL, 0x000fec0000041848ULL,
0x0000002a0c28723cULL, 0x000fec0000041830ULL, 0x000000180c10723cULL, 0x000fec0000041834ULL,
0x0000001a0c08723cULL, 0x000fec0000041838ULL, 0x000000240c04723cULL, 0x008fec0000041804ULL,
0x000000260c0c723cULL, 0x000fe20000041840ULL, 0x0000000444027824ULL, 0x000fc400078e00ffULL,
0x3d8000002c037820ULL, 0x000fe20000410000ULL, 0x3d8000002d187820ULL, 0x000fe20000410000ULL,
0x3d8000002e1a7820ULL, 0x000fe20000410000ULL, 0x3d8000002f197820ULL, 0x000fe20000410000ULL,
0x3d80000028287820ULL, 0x000fe20000410000ULL, 0x3d80000029297820ULL, 0x000fe20000410000ULL,
0x3d8000002a2a7820ULL, 0x000fe20000410000ULL, 0x3d8000002b2b7820ULL, 0x000fe20000410000ULL,
0x3d8000001c1c7820ULL, 0x000fe20000410000ULL, 0x3d8000001d1d7820ULL, 0x000fe20000410000ULL,
0x3d800000081b7820ULL, 0x000fe20000410000ULL, 0x3d80000009207820ULL, 0x000fe20000410000ULL,
0x3d8000001e1e7820ULL, 0x000fe20000410000ULL, 0x3d8000001f1f7820ULL, 0x000fe20000410000ULL,
0x3d80000014147820ULL, 0x000fe20000410000ULL, 0x3d80000015157820ULL, 0x000fe20000410000ULL,
0x3d80000016167820ULL, 0x000fe20000410000ULL, 0x3d80000017177820ULL, 0x000fe20000410000ULL,
0x3d80000010107820ULL, 0x000fe20000410000ULL, 0x3d80000011117820ULL, 0x000fe20000410000ULL,
0x3d80000012127820ULL, 0x000fe20000410000ULL, 0x3d80000013137820ULL, 0x000fe20000410000ULL,
0x3d8000000a0a7820ULL, 0x000fe20000410000ULL, 0x3d8000000b0b7820ULL, 0x000fe20000410000ULL,
0x3d80000004217820ULL, 0x000fe20000410000ULL, 0x3d80000005227820ULL, 0x000fe20000410000ULL,
0x3d80000006087820ULL, 0x000fe20000410000ULL, 0x3d80000007097820ULL, 0x000fe20000410000ULL,
0xfffffff002027812ULL, 0x000fe200078ec0ffULL, 0x3d8000000c0c7820ULL, 0x000fe20000410000ULL,
0x3d8000000d0d7820ULL, 0x000fe20000410000ULL, 0x3d8000000e0e7820ULL, 0x000fe20000410000ULL,
0x3d8000000f0f7820ULL, 0x000fe20000410000ULL, 0x0000001400148947ULL, 0x002fec0003800000ULL,
0x0000400001237983ULL, 0x000ea20000300800ULL, 0xffffffff05097890ULL, 0x000fc6000fffe03fULL,
0x0244000602047984ULL, 0x0002620008000c00ULL, 0x0000000000357919ULL, 0x000e640000000000ULL,
0x0000000923007c0cULL, 0x004fda000bf05270ULL, 0x0000000400080947ULL, 0x002fea0003800000ULL,
0x0000000235237824ULL, 0x000fe200078e00ffULL, 0x8000000714077290ULL, 0x000fc8000fffe03fULL,
0x0000000623237812ULL, 0x000fc800078ec0ffULL, 0x0000000123247812ULL, 0x040fe400078efcffULL,
0x0000000823257812ULL, 0x040fe400078efcffULL, 0x0000000724007c0cULL, 0x000fe4000bf26070ULL,
0x0000001023247812ULL, 0x000fe400078efcffULL, 0x0000000725007c0cULL, 0x000fe4000bf06070ULL,
0x0000000724007c0cULL, 0x000fc4000bfc6070ULL, 0x0000001123257812ULL, 0x040fe400078efcffULL,
0x0000001823247812ULL, 0x040fe400078efcffULL, 0x0000000723007c0cULL, 0x000fe4000bf46070ULL,
0x0000000725007c0cULL, 0x000fe4000bfa6070ULL, 0x0000000724007c0cULL, 0x000fe4000bf66070ULL,
0x0000000923267812ULL, 0x000fc400078efcffULL, 0x0000001923257812ULL, 0x040fe400078efcffULL,
0x0000002023247812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff03037808ULL, 0x000fe40005000000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0xff7fffff18187808ULL, 0x000fc40004800000ULL, 0x0000000726007c0cULL, 0x000fe4000bf86070ULL,
0x0000000725007c0cULL, 0x000fe4000bf46070ULL, 0x0000000724007c0cULL, 0x000fe4000bf26070ULL,
0x0000002123257812ULL, 0x040fe400078efcffULL, 0x0000002823247812ULL, 0x000fe400078efcffULL,
0xff7fffff2a2a7808ULL, 0x000fc40004000000ULL, 0xff7fffff28287808ULL, 0x000fe40004000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40006000000ULL, 0xff7fffff29297808ULL, 0x000fe40006000000ULL,
0x0000000725007c0cULL, 0x000fe4000bf06070ULL, 0x0000000724007c0cULL, 0x000fe4000bf86070ULL,
0x0000002923257812ULL, 0x000fc400078efcffULL, 0x0000003023247812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fe40007000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40007000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006800000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL,
0x0000000725007c0cULL, 0x000fc4000bfc6070ULL, 0x0000000724007c0cULL, 0x000fe4000bfa6070ULL,
0x0000003123257812ULL, 0x040fe400078efcffULL, 0x0000003823247812ULL, 0x040fe400078efcffULL,
0x0000003923237812ULL, 0x000fe400078efcffULL, 0xff7fffff16167808ULL, 0x000fe40005800000ULL,
0xff7fffff14147808ULL, 0x000fc40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0xff7fffff10107808ULL, 0x000fe40004800000ULL, 0x0000000725007c0cULL, 0x000fe4000bf66070ULL,
0x0000000724007c0cULL, 0x000fc4000bf46070ULL, 0x0000000723007c0cULL, 0x000fe4000bf26070ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff11117808ULL, 0x000fe40004000000ULL,
0xff7fffff0a0a7808ULL, 0x000fe40006000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40006000000ULL,
0xff7fffff0b0b7808ULL, 0x000fc40007000000ULL, 0xff7fffff20207808ULL, 0x000fe40007000000ULL,
0xff7fffff08087808ULL, 0x000fe40006800000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0xff7fffff09097808ULL, 0x000fe40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005800000ULL,
0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40005000000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40004800000ULL, 0xff7fffff0d0d7808ULL, 0x000fce0004800000ULL,
0x0000a00001257983ULL, 0x000ea20000300800ULL, 0x0000000304237209ULL, 0x000fe20007810000ULL,
0xffffffff00077882ULL, 0x000fe20000000000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000001823237209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000002823047209ULL, 0x000fe40007810000ULL, 0x0000002a05247209ULL, 0x000fc40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000002b24237209ULL, 0x000fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x0000001e23247209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000001f24237209ULL, 0x000fc40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x0000001623247209ULL, 0x000fe40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x0000001724237209ULL, 0x000fe40007810000ULL,
0x0000001005047209ULL, 0x000fe40007810000ULL, 0x0000001223247209ULL, 0x000fc40007810000ULL,
0x0000001104047209ULL, 0x000fe40007810000ULL, 0x0000001324057209ULL, 0x000fe40007810000ULL,
0x0000001b04237209ULL, 0x000fe40007810000ULL, 0x0000000a05047209ULL, 0x000fe40007810000ULL,
0x0000002023247209ULL, 0x000fe40007810000ULL, 0x0000000b04057209ULL, 0x000fc40007810000ULL,
0x0000002124237209ULL, 0x000fe40007810000ULL, 0x0000000805047209ULL, 0x000fe40007810000ULL,
0x0000002223237209ULL, 0x000fe40007810000ULL, 0x0000000904057209ULL, 0x000fe40007810000ULL,
0x0000000c23247209ULL, 0x000fe40007810000ULL, 0x0000000e05267209ULL, 0x000fc40007810000ULL,
0x0000000d24247209ULL, 0x000fe40007810000ULL, 0x0000000f26267209ULL, 0x000fe40007810000ULL,
0x000000ff25ff7812ULL, 0x004fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fca0000000000ULL,
0x0000a00401007387ULL, 0x0003e20000100600ULL, 0x0000000e077c7947ULL, 0x000fea000b800000ULL,
0x0c401f0024057f89ULL, 0x000ea800000e0000ULL, 0x0c401f0026237f89ULL, 0x000ee800000e0000ULL,
0x0c401f00062d7f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007047f89ULL, 0x002e6200000e0000ULL,
0x0000000524257209ULL, 0x004fc40007810000ULL, 0x0000002326277209ULL, 0x008fc60007810000ULL,
0x0c201f00252c7f89ULL, 0x000ea200000e0000ULL, 0x0000002d062d7209ULL, 0x010fc60007810000ULL,
0x0c201f00272e7f89ULL, 0x000ee200000e0000ULL, 0x0000000407237209ULL, 0x002fc60007810000ULL,
0x0c201f002d307f89ULL, 0x000e6800000e0000ULL, 0x0c201f0023247f89ULL, 0x00092200000e0000ULL,
0x0000002c25047209ULL, 0x004fe40007810000ULL, 0x0000002e27057209ULL, 0x008fe40007810000ULL,
0x000000302d067209ULL, 0x002fce0007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b052f7820ULL, 0x000fe20000410000ULL, 0x3f80000000077882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1b1b7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe2000001082fULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x0000001000277308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0d077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b16317823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe2000001082fULL, 0x0000001400257308ULL, 0x000ff00000000800ULL,
0x0000001b002d7308ULL, 0x000ff00000000800ULL, 0x0000001a000d7308ULL, 0x000ff00000000800ULL,
0x0000001900107308ULL, 0x000e700000000800ULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x0000000d1019723eULL, 0x002fce00000010ffULL, 0x0000001800187308ULL, 0x000e700000000800ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x000000031818723eULL, 0x002fce00000010ffULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x3fb8aa3b17037823ULL, 0x000fce000001082fULL,
0x0000002a001b7308ULL, 0x000fe20000000800ULL, 0x00000028291a723eULL, 0x002fce00000010ffULL,
0x0000002b00147308ULL, 0x000e700000000800ULL, 0x0000000c002e7308ULL, 0x0005e20000000800ULL,
0x0000001b141b723eULL, 0x002fce00000010ffULL, 0x0000001500267308ULL, 0x0003e20000000800ULL,
0x00000007ff0c7e24ULL, 0x004fca000f8e00ffULL, 0x3f8000000c0c783eULL, 0x000fe400000010ffULL,
0x00000011002c7308ULL, 0x000fe40000000800ULL, 0x0000000c000d7202ULL, 0x000fcc0000000f00ULL,
0x0000001e00117308ULL, 0x000fe20000000800ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000c1814723cULL, 0x002fe400000418ffULL, 0x0000001c001c7308ULL, 0x000fea0000000800ULL,
0x3fb8aa3b130d7823ULL, 0x000fc6000001082fULL, 0x0000001d001d7308ULL, 0x000e700000000800ULL,
0x0000001f00307308ULL, 0x0004e20000000800ULL, 0x0000001c1d10723eULL, 0x002fce00000010ffULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b121f7823ULL, 0x104fe2000001082fULL,
0x000000252612723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b0b1c7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b091d7823ULL, 0x000fe2000001082fULL, 0x000000ffff267224ULL, 0x000fe200078e000cULL,
0x000000113011723eULL, 0x008fe400000010ffULL, 0x00000003001e7308ULL, 0x000e700000000800ULL,
0x0000000d00287308ULL, 0x0005e20000000800ULL, 0x000000311e13723eULL, 0x002fce00000010ffULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x000000ffff0d7224ULL, 0x004fce00078e000cULL,
0x0000000c1014723cULL, 0x000fe20000041814ULL, 0x0000001f001f7308ULL, 0x000e6c0000000800ULL,
0x3fb8aa3b080d7823ULL, 0x000fe2000001082fULL, 0x000000272c08723eULL, 0x000fe200000010ffULL,
0x0000000a00037308ULL, 0x0005e20000000800ULL, 0x000000ffff277224ULL, 0x000fe200078e000cULL,
0x0000001f2809723eULL, 0x002fcc00000010ffULL, 0x0000001c001c7308ULL, 0x000e620000000800ULL,
0x0000002d200a723eULL, 0x004fce00000010ffULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x000000031c0b723eULL, 0x002fce00000010ffULL, 0x0000001d001e7308ULL, 0x000e620000000800ULL,
0xfffffffc35037812ULL, 0x000fe200078ec0ffULL, 0x000000260828723cULL, 0x000fec0000041814ULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x0000000d1e15723eULL, 0x002fce00000010ffULL,
0x0000002200227308ULL, 0x000e620000000800ULL, 0x000000ffff0d7224ULL, 0x000fce00078e000cULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x000000212214723eULL, 0x002fce00000010ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000002e0716723eULL, 0x004fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000002423077209ULL, 0x010fe40007810000ULL,
0x0000000e0f17723eULL, 0x002fce00000010ffULL, 0x0000000c1428723cULL, 0x000fee0000041828ULL,
0x0000000fff0c7424ULL, 0x000fca00078e00ffULL, 0x000000030c037219ULL, 0x000fd600000006ffULL,
0x001c1fff280c7589ULL, 0x00026200000e0000ULL, 0x00000000001c7806ULL, 0x000fe200038e0100ULL,
0x00000000030e73a1ULL, 0x000eb000000e8000ULL, 0x00000000030773c4ULL, 0x000ee20000004000ULL,
0x0000000000097886ULL, 0x000fc400038e0100ULL, 0x0000000903ff7c12ULL, 0x004fda000f80400eULL,
0x0000000a077c8947ULL, 0x00afea000b800000ULL, 0x001c1fff2a0d7589ULL, 0x0002a800000e0000ULL,
0x001c1fff0e0e7589ULL, 0x000ee800000e0000ULL, 0x001c1fff000f7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff5b7812ULL, 0x000fe200078ee25bULL, 0x0000000b0e077291ULL, 0x000fe2000f8e583fULL,
0x00000003001d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff207224ULL, 0x000fe200078e0018ULL,
0x0000000335ff7812ULL, 0x000fe2000780c0ffULL, 0x000000085b1c7836ULL, 0x000fe20000000000ULL,
0x000000041d1f7812ULL, 0x000fe200078efcffULL, 0x000000085b007824ULL, 0x002fe200078e00ffULL,
0x000000071d037812ULL, 0x000fe200078e785bULL, 0x00000007ff1e7e24ULL, 0x000fe2000f8e00ffULL,
0x000000071f5b7812ULL, 0x000fe200078e785bULL, 0x000000ffff217224ULL, 0x000fe200078e001aULL,
0x000000071d1d7812ULL, 0x000fe200078e781cULL, 0x000120001e1e7836ULL, 0x000fe20000000000ULL,
0x000000071f1f7812ULL, 0x000fe200078e781cULL, 0x000000081c1c7824ULL, 0x000fe200078e00ffULL,
0x0000000003037212ULL, 0x080fe200078efcffULL, 0x000000ffff237224ULL, 0x000fe200078e0012ULL,
0x000000005b5b7212ULL, 0x000fe200078efcffULL, 0x000000ffff247224ULL, 0x000fe200078e0008ULL,
0x0000001c1d1d7212ULL, 0x080fe200078efcffULL, 0x000000ffff257224ULL, 0x000fe200078e000aULL,
0x0000001c1f1f7212ULL, 0x000fe200078efcffULL, 0x000000105b5b7824ULL, 0x000fe200078e021eULL,
0x0000001e03037211ULL, 0x000fe200078e20ffULL, 0x000000ffff267224ULL, 0x000fe200078e0014ULL,
0x0000001000227202ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe200078e0016ULL,
0x0000001900187202ULL, 0x000fe20000000f00ULL, 0x000000ffff197224ULL, 0x000fe200078e001bULL,
0x00000015000a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff087224ULL, 0x000fe200078e0009ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000002003007844ULL, 0x0003e20000000200ULL,
0x000000101d1d7824ULL, 0x000fc400078e021eULL, 0x000000ffff1a7224ULL, 0x000fe200078e0011ULL,
0x000000245b007844ULL, 0x0003e20000000200ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0013ULL,
0x000000ffff097224ULL, 0x000fe400078e000bULL, 0x000000101f1f7824ULL, 0x000fe200078e021eULL,
0x000000181d007844ULL, 0x0003e20000000200ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0017ULL,
0x00000001ff007424ULL, 0x000fc600078e00ffULL, 0x000000081f007844ULL, 0x0003e20000000200ULL,
0x000000050800728cULL, 0x000fc6000bf06070ULL, 0x0240000402008988ULL, 0x0003e80008000c06ULL,
0x0242000c02008988ULL, 0x01c3e20008000c06ULL, 0x02460800ffff79a7ULL, 0x0005e20008500012ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x00000008ff007e24ULL, 0x004fca000f8e00ffULL,
0x0000400001007387ULL, 0x0003ee0000100800ULL, 0xffffff9c00b88947ULL, 0x002fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000aff0c7e24ULL, 0x000fe4000f8e00ffULL,
0x0000000aff0d7e24ULL, 0x000fce000f8e00ffULL, 0x0246080dff0075a7ULL, 0x0002620008020146ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0246080dff0095a7ULL, 0x000e640008020046ULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff0000447947ULL, 0x000fea000383ffffULL, 0x00000004000c7c02ULL, 0x000fe20008000f00ULL,
0x00000004ff0d7e24ULL, 0x000fce000f8e00ffULL, 0x0246180dff0075a7ULL, 0x0002620008020146ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0246180dff0095a7ULL, 0x000e640008020046ULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff1800ac7947ULL, 0x000fea000383ffffULL, 0x00000009ff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x00000009000d7c02ULL, 0x000fce0008000f00ULL, 0x0246280dff0075a7ULL, 0x0002620008000146ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0246280dff0085a7ULL, 0x000e640008000046ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff3000387947ULL, 0x000fea000383ffffULL, 0x00000004ff027e24ULL, 0x000fe4000f8e00ffULL,
0x00000004ff037e24ULL, 0x000fce000f8e00ffULL, 0x02463803ff0075a7ULL, 0x0002620008000146ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x02463803ff0085a7ULL, 0x000e640008000046ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff4400c87947ULL, 0x000fea000383ffffULL, 0x024600ffff0075a7ULL, 0x000ea2000800014bULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x024600ffff0085a7ULL, 0x000e64000800004bULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff9c000c7947ULL, 0x00afea000383ffffULL, 0x000000ffff047224ULL, 0x100fe400078e0023ULL,
0x000000ffff057224ULL, 0x000fce00078e0023ULL, 0x02461005ff0075a7ULL, 0x0002620008000152ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x02461005ff0085a7ULL, 0x000e640008000052ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffe800cc7947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x0000002400327202ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe400078e00ffULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fce00078e00ffULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0009240000000034ULL,
0x000000000000791bULL, 0x010fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff327224ULL, 0x004fe200078e0026ULL, 0x0000000200337802ULL, 0x000fe20000000f00ULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff2f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x008fce00078e0031ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003332317389ULL, 0x0002640000000034ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000524257209ULL, 0x000fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe400078e0006ULL,
0x000000ffff237224ULL, 0x000fce00078e0031ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003332317389ULL, 0x0002640000000034ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002326277209ULL, 0x000fe40007810000ULL, 0x0000000700327202ULL, 0x000fe20000000f00ULL,
0x000000ffff2d7224ULL, 0x000fce00078e0031ULL, 0x000000002f087348ULL, 0x000fea0003c00000ULL,
0x0c00003332317389ULL, 0x0002640000000034ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002d062d7209ULL, 0x000fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe400078e0025ULL,
0x00000001ff337424ULL, 0x000fe400078e00ffULL, 0x000000ffff047224ULL, 0x002fce00078e0031ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000407237209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe400078e0027ULL, 0x000000ffff2c7224ULL, 0x000fce00078e0031ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002c25047209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe200078e002dULL, 0x00000031002e7202ULL, 0x000fce0000000f00ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002e27057209ULL, 0x000fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe400078e0023ULL, 0x000000ffff307224ULL, 0x000fce00078e0031ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0c00003332317389ULL, 0x0002640000000034ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000302d067209ULL, 0x000fe20007810000ULL,
0x000000ffff247224ULL, 0x000fe200078e0031ULL, 0xffffffec00dc7947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ff000f7202ULL, 0x000fe20000000f00ULL,
0x00001c1fff1c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e0003ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2a0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e000fULL,
0x00001c1f001c7802ULL, 0x002fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fe400078e000eULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e0003ULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2a0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e000fULL,
0x00000003002f7202ULL, 0x002fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff1c7424ULL, 0x000fce00078e00ffULL,
0x000000002f087348ULL, 0x000fea0003c00000ULL, 0x0000000f2a0f7389ULL, 0x0006e4000000001cULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff4001c7947ULL, 0x006fea000383ffffULL, 0x0180000035027836ULL, 0x000fe20000000000ULL,
0x0000016000007945ULL, 0x000fe80003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000003500028308ULL, 0x0002a20000001000ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x008000000300780cULL, 0x040fe40003f22070ULL,
0x000000ff0300720cULL, 0x000fe40003f05070ULL, 0xffffffffff027807ULL, 0x004fe40004800000ULL,
0x00000001ff037807ULL, 0x000fc60000000000ULL, 0x000000ffff027224ULL, 0x000fca00078e0a02ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000000000248947ULL, 0x000fea0003800000ULL,
0x007fffff35027812ULL, 0x000fc800078ec0ffULL, 0x000000ff0200720cULL, 0x000fc80003f02070ULL,
0xffffffffff027807ULL, 0x000fc80004000000ULL, 0x000000ff02027210ULL, 0x000fc80007ffe1ffULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000035037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000003500027308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffec002447950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000024680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL, 0x0000000e00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000630ULL, 0x0000000000000048ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000678ULL, 0x0000000000000468ULL, 0x0000000d00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ae0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b00ULL, 0x0000000000000000ULL, 0x0000000d00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b00ULL, 0x0000000000000030ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b30ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000b78ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000b80ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000c00ULL, 0x0000000000013f80ULL, 0x0000000e00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014b80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014b90ULL, 0x0000000000000400ULL, 0x0000000d00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014b90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000014b90ULL, 0x0000000000000260ULL, 0x0000000d00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000015270ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015270ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000b78ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013f80ULL,
0x0000000000013f80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014b80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL, 0x0000000000000414ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000014b90ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_16_m_16_sm_90_cubin_len = 86976;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
