/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_16_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017210ULL, 0x0000000000016d90ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000015b20ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000015c90ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000015cd0ULL, 0x0000000000000130ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000015e00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00015b2000000000ULL, 0x0000040400000000ULL, 0x810c000000780400ULL, 0x0056440400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080a80828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a892ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00015b2000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a80828808081ULL, 0x8016288080aa0828ULL, 0x0000000310288082ULL, 0x80aa920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x00015c9000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080a80828808081ULL,
0x8e08288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808e920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x00015cd000000000ULL,
0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x0008120400000076ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000dULL,
0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00014da000183104ULL, 0x00014fa000014ee0ULL, 0x000150c0000150b0ULL,
0x01282904000150d0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500000305000003ULL, 0x0500000305000003ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000b001282804ULL, 0x000013f0000000f0ULL,
0x000020f000002050ULL, 0x0000219000002160ULL, 0x000026f0000026b0ULL, 0x0000352000002910ULL,
0x000037a000003530ULL, 0x000043e000004340ULL, 0x0000447000004440ULL, 0x000047a000004790ULL,
0x00005460000049a0ULL, 0x0000574000005470ULL, 0x00006380000062e0ULL, 0x00006410000063e0ULL,
0x0000674000006730ULL, 0x0000740000006940ULL, 0x000076e000007410ULL, 0x0000832000008280ULL,
0x000083b000008380ULL, 0x000086e0000086d0ULL, 0x000093d000008910ULL, 0x000098b0000093e0ULL,
0x0000a1b0000098c0ULL, 0x0000c0a00000bfa0ULL, 0x0000c6800000c650ULL, 0x000149500000cec0ULL,
0x0001499000014980ULL, 0x000149c0000149a0ULL, 0x00014a00000149e0ULL, 0x000150a000014a10ULL,
0x0001511000015100ULL, 0x0001574000015120ULL, 0x000157f0000157a0ULL, 0x0001589000015840ULL,
0x00015930000158e0ULL, 0x000159f000015980ULL, 0x00015ab000015a60ULL, 0x0170390400015b00ULL,
0x000000ff00000160ULL, 0x003f010000014600ULL, 0x00000009000001a0ULL, 0x003f013000014608ULL,
0x00000009000001c0ULL, 0x003f013000014610ULL, 0x000000ff00000530ULL, 0x003f010700014600ULL,
0x0000000000000680ULL, 0x003f010200000004ULL, 0x0000000000000730ULL, 0x003f010100000000ULL,
0x000000ff00001ec0ULL, 0x003f01060001460cULL, 0x000000ff00001f90ULL, 0x003f01060001460cULL,
0x000000ff00003770ULL, 0x003f010100014610ULL, 0x000000ff00004210ULL, 0x003f01060001461cULL,
0x000000ff000042c0ULL, 0x003f01060001461cULL, 0x000000ff00005710ULL, 0x003f010100014620ULL,
0x000000ff000061b0ULL, 0x003f01060001462cULL, 0x000000ff00006260ULL, 0x003f01060001462cULL,
0x000000ff000076b0ULL, 0x003f010100014630ULL, 0x000000ff00008150ULL, 0x003f01060001463cULL,
0x000000ff00008200ULL, 0x003f01060001463cULL, 0x000000ff00009680ULL, 0x003f010100014640ULL,
0x000000ff0000de50ULL, 0x003f010600014604ULL, 0x000000ff0000dee0ULL, 0x003f010600014604ULL,
0x0000005b00013e10ULL, 0x003f010600014614ULL, 0x0000005b00014230ULL, 0x003f010600014614ULL,
0x0000005b000156a0ULL, 0x003f010100014608ULL, 0x00101c0400033803ULL, 0x0000df300000d300ULL,
0x000157000000dfb0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001c4ULL,
0x0000001100000002ULL, 0x0000000000000144ULL, 0x0000001100000002ULL, 0x00000000000000ccULL,
0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL, 0x000000000000019aULL,
0x0000001100000002ULL, 0x000000000000011dULL, 0x0000001100000002ULL, 0x00000000000000a8ULL,
0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000005f7919ULL, 0x000ea80000002100ULL,
0x0000000000147919ULL, 0x000ee80000002700ULL, 0x00000000005e7919ULL, 0x000f220000002600ULL,
0x0000000108007824ULL, 0x002fc800078e0203ULL, 0x0000008000097824ULL, 0x104fe200078e025fULL,
0x00000005ff5f7819ULL, 0x000fe2000001165fULL, 0x00001fff08007589ULL, 0x000e6200000e0000ULL,
0x00006000140a7625ULL, 0x008fe400078e000bULL, 0x000000ff0900720cULL, 0x040fe40003f05270ULL,
0x000000030900780cULL, 0x040fe20003f24070ULL, 0x00001fff5f5f7589ULL, 0x000ea200000e0000ULL,
0x0000007f0900780cULL, 0x000fd20003f44070ULL, 0x3fffff80ff028424ULL, 0x000fe200078e00ffULL,
0x7fffff8000038802ULL, 0x000fe20000000f00ULL, 0x3fffffe0ff049424ULL, 0x000fe200078e00ffULL,
0x7fffff8000079802ULL, 0x000fe20000000f00ULL, 0x7fffffe0ff059424ULL, 0x000fe400078e00ffULL,
0x01460002ff008388ULL, 0x0007e20000000a00ULL, 0xff317217ff0ca424ULL, 0x000fe200078e00ffULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff069424ULL, 0x000fe200078e00ffULL,
0x0146080409009388ULL, 0x0007e8000000ca00ULL, 0x0144000c0900a388ULL, 0x0007e80000004800ULL,
0x0146100609009388ULL, 0x0007e8000000ca00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003b000000947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x014e620000000000ULL,
0x00005800ff027624ULL, 0x008fc400078e00ffULL, 0x000000045f047824ULL, 0x000fe400078e00ffULL,
0x000000105e037824ULL, 0x000fe200078e00ffULL, 0x0000000402027819ULL, 0x000fe200000006ffULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x000000040f057211ULL, 0x002fc600078fd8ffULL,
0x0000001402047224ULL, 0x000fe200078e0203ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x00000003050d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000705027812ULL, 0x000fe400078ec0ffULL,
0x0000000707037812ULL, 0x000fe400078ec0ffULL, 0x000000070d0c7812ULL, 0x000fe400078ec0ffULL,
0x0000001f02027812ULL, 0x000fc400078e780fULL, 0x0000001f03067812ULL, 0x100fe200078e780fULL,
0x000000100f037824ULL, 0x000fe200078e00ffULL, 0x0000000205097810ULL, 0x040fe40007ffe0ffULL,
0x0000001f0c127812ULL, 0x000fe200078e780fULL, 0x00000020050c7824ULL, 0x000fe200078e0202ULL,
0x0000000709087812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x040fe200078e0205ULL,
0x000001f003117812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x000fe200078e0207ULL,
0x00000006070e7211ULL, 0x000fe200078e28ffULL, 0x00005c0002027625ULL, 0x000fe200078e0013ULL,
0x0000001f08087812ULL, 0x000fc400078e780fULL, 0x000000120d127211ULL, 0x000fe200078e28ffULL,
0x0000000104067824ULL, 0x000fe200078e0209ULL, 0x0000001102027210ULL, 0x000fe20007f1e0ffULL,
0x00000001040f7824ULL, 0x000fe400078e020dULL, 0x00005c0005047625ULL, 0x000fc800078e0013ULL,
0x00005c0006067625ULL, 0x000fe200078e0013ULL, 0x0000001104047210ULL, 0x000fc60007f3e0ffULL,
0x0000002009107824ULL, 0x000fe400078e0208ULL, 0x00005c000f087625ULL, 0x000fc800078e0013ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001106067210ULL, 0x080fe20007f1e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e00ffULL, 0x0000001108087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100e0f7824ULL, 0x000fe200078e00ffULL,
0x00000009ff097210ULL, 0x000fe200017fe4ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000b901c46ULL,
0x0000001010117824ULL, 0x000fc400078e00ffULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x00000000040f7faeULL, 0x0003e8000b901c46ULL, 0x0000000006117faeULL, 0x0003e8000b901c46ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060a607981ULL, 0x014ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000f220000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000004ff617e24ULL, 0x010fe2000f8e00ffULL,
0x000000ff605d7810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff5d7819ULL, 0x000fce000001165dULL,
0x0000cd0000008947ULL, 0x000fea0003800000ULL, 0x000146105f007811ULL, 0x000fe400078e20ffULL,
0x0000000300037802ULL, 0x00afe20000000f00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040300ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000161027810ULL, 0x040fe20007ffe0ffULL, 0x0000000214067824ULL, 0x000fe200078e00ffULL,
0x000058005e037a10ULL, 0x002fe20007ffe0ffULL, 0x0000010061057824ULL, 0x000fe200078e00ffULL,
0x0000005d0200720cULL, 0x000fe20003f06070ULL, 0x0000000000ff7f8cULL, 0x0003e4000c80043fULL,
0x0000580006067a24ULL, 0x000fc800078e0203ULL, 0x0000620006107a24ULL, 0x000fcc00078e0205ULL,
0x000005c000008947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x0000000560027217ULL, 0x000fe20007800000ULL, 0x00000200ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000c0005f137811ULL, 0x040fe200078e68ffULL, 0x000000085f077824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fca00078e0a05ULL, 0x0000002002047817ULL, 0x000fe40003800000ULL,
0x00000003ff057819ULL, 0x102fe40000011600ULL, 0x0ffffff800097812ULL, 0x000fe400078ec0ffULL,
0x0000000510027210ULL, 0x000fe40007ffe0ffULL, 0x0000000005087212ULL, 0x040fe400078e3cffULL,
0x000000040500720cULL, 0x000fe20003f06070ULL, 0x00005e0002027625ULL, 0x000fe200078e001bULL,
0xfffffff807077812ULL, 0x000fc400078ee200ULL, 0x0000000709087812ULL, 0x000fe400078ef808ULL,
0x00000004050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x00000008050d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c050f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001008097824ULL, 0x000fe200078e0213ULL, 0x0000001005117810ULL, 0x000fe20007ffe0ffULL,
0x000000080d147824ULL, 0x000fe200078e00ffULL, 0x0000001405157810ULL, 0x040fe20007ffe0ffULL,
0x0000000110087824ULL, 0x040fe200078e020fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000c101c46ULL, 0x0000001805177810ULL, 0x040fe20007ffe0ffULL,
0x00000001100a7824ULL, 0x040fe200078e0211ULL, 0x0000001c05197810ULL, 0x000fe20007ffe0ffULL,
0x00000008151a7824ULL, 0x000fe200078e00ffULL, 0x000000000f057212ULL, 0x040fe200078e3cffULL,
0x00000001100c7824ULL, 0x040fe200078e0215ULL, 0x000000030f167819ULL, 0x000fe200000006ffULL,
0x00000008191e7824ULL, 0x000fe200078e00ffULL, 0x000000040b00720cULL, 0x080fe20003f06070ULL,
0x00000001100e7824ULL, 0x000fe200078e0217ULL, 0x000000040d00720cULL, 0x000fe20003f26070ULL,
0x000000080b097824ULL, 0x042fe200078e00ffULL, 0x000000000b027212ULL, 0x000fc400078e3cffULL,
0x000000000d037212ULL, 0x000fe400078e3cffULL, 0xfffffff809127812ULL, 0x000fe200078ee202ULL,
0x0000000110027824ULL, 0x000fe200078e020bULL, 0x000000040f00720cULL, 0x080fe20003f46070ULL,
0x00005e000e0e7625ULL, 0x000fe200078e001bULL, 0x000000041100720cULL, 0x080fe40003f66070ULL,
0x000000041500720cULL, 0x080fe40003f86070ULL, 0x000000041700720cULL, 0x080fe20003fa6070ULL,
0x00000010070e7825ULL, 0x000fe200078e000eULL, 0x000000041900720cULL, 0x000fc40003fc6070ULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x0000000110047824ULL, 0x000fe200078e020dULL,
0xfffffff816167812ULL, 0x000fe200078ee205ULL, 0x0000000110107824ULL, 0x000fe200078e0219ULL,
0x0000000011037212ULL, 0x0c0fe200078e3cffULL, 0x00005e000c0c7625ULL, 0x080fe200078e001bULL,
0x0000000311187819ULL, 0x000fe400000006ffULL, 0x0000000015057212ULL, 0x080fe200078e3cffULL,
0x00005e0010107625ULL, 0x000fe200078e001bULL, 0x0000000017097212ULL, 0x000fc400078e3cffULL,
0x00000003171c7819ULL, 0x000fe200000006ffULL, 0x00000010070c7825ULL, 0x000fe200078e000cULL,
0x00000000190b7212ULL, 0x000fe400078e3cffULL, 0xfffffff818187812ULL, 0x000fe200078ee203ULL,
0x00005e0002027625ULL, 0x080fe200078e001bULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee205ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x00005e0004047625ULL, 0x000fe200078e001bULL,
0xfffffff81e1e7812ULL, 0x000fc400078ee20bULL, 0x0000001318197211ULL, 0x000fe200078e20ffULL,
0x00005e0008087625ULL, 0x000fc800078e001bULL, 0x00005e000a0a7625ULL, 0x000fc800078e001bULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001007047825ULL, 0x000fc800078e0004ULL,
0x0000001007087825ULL, 0x000fc800078e0008ULL, 0x00000010070a7825ULL, 0x000fc800078e000aULL,
0x0000001007107825ULL, 0x000fc800078e0010ULL, 0x0000001012077824ULL, 0x100fe400078e0213ULL,
0x0000001014157824ULL, 0x100fe400078e0213ULL, 0x0000001016177824ULL, 0x100fe200078e0213ULL,
0x0000000002077faeULL, 0x0003e2000c101c46ULL, 0x000000101a1b7824ULL, 0x100fe400078e0213ULL,
0x000000101c1d7824ULL, 0x100fe200078e0213ULL, 0x0000000004157faeULL, 0x0003e2000c901c46ULL,
0x000000101e137824ULL, 0x000fc600078e0213ULL, 0x0000000008177faeULL, 0x0003e8000d101c46ULL,
0x000000000a197faeULL, 0x0003e8000d901c46ULL, 0x000000000c1b7faeULL, 0x0003e8000e101c46ULL,
0x000000000e1d7faeULL, 0x0003e8000e901c46ULL, 0x0000000010137faeULL, 0x0003e2000f101c46ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x000000085f0f7824ULL, 0x040fe200078e00ffULL, 0x0000c0005f147811ULL, 0x000fe200078e68ffULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x00000003ff037819ULL, 0x002fc40000011600ULL,
0x0ffffff800057812ULL, 0x000fe400078ec0ffULL, 0x0000000c030d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000403097810ULL, 0x000fe40007ffe0ffULL, 0x000000000d077212ULL, 0x0c0fe200078e3cffULL,
0x000000080d087824ULL, 0x000fe200078e00ffULL, 0x0000000003027212ULL, 0x000fe200078e3cffULL,
0x0000000809177824ULL, 0x000fe200078e00ffULL, 0x00000008030b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001100a7824ULL, 0x000fe200078e020dULL, 0xfffffff8081b7812ULL, 0x000fc400078ee207ULL,
0x0000000705057812ULL, 0x000fe200078ef802ULL, 0x0000000110087824ULL, 0x000fe200078e020bULL,
0xfffffff80f077812ULL, 0x000fe200078ee200ULL, 0x000000101b1b7824ULL, 0x000fe200078e0214ULL,
0x0000000009027212ULL, 0x080fe400078e3cffULL, 0x000000000b047212ULL, 0x040fe400078e3cffULL,
0x000000030b197819ULL, 0x000fe400000006ffULL, 0x00000010030f7810ULL, 0x000fc40007ffe0ffULL,
0x0000001403117810ULL, 0x040fe40007ffe0ffULL, 0x0000001803157810ULL, 0x000fe20007ffe0ffULL,
0x000000080f187824ULL, 0x000fe200078e00ffULL, 0x0000001c031d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001100c7824ULL, 0x040fe200078e020fULL, 0xfffffff817177812ULL, 0x000fe200078ee202ULL,
0x0000000110027824ULL, 0x040fe200078e0203ULL, 0xfffffff819197812ULL, 0x000fe200078ee204ULL,
0x00000008111a7824ULL, 0x000fe200078e00ffULL, 0x0000000910047210ULL, 0x040fe20007ffe0ffULL,
0x0000000110127824ULL, 0x040fe200078e0215ULL, 0x000000000f097212ULL, 0x080fe200078e3cffULL,
0x0000000110167824ULL, 0x040fe200078e021dULL, 0x00000011100e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000815107824ULL, 0x000fe200078e00ffULL, 0x00000000110b7212ULL, 0x080fe200078e3cffULL,
0x00005e0002027625ULL, 0x000fe200078e0013ULL, 0x00000000150d7212ULL, 0x000fc400078e3cffULL,
0x000000001d0f7212ULL, 0x000fe200078e3cffULL, 0x0000001005157824ULL, 0x000fe200078e0214ULL,
0x000000031d1c7819ULL, 0x000fe200000006ffULL, 0x00005e0004047625ULL, 0x080fe200078e0013ULL,
0xfffffff8181d7812ULL, 0x000fe400078ee209ULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee20bULL,
0x00005e0008087625ULL, 0x080fe200078e0013ULL, 0xfffffff810217812ULL, 0x000fe400078ee20dULL,
0xfffffff81c237812ULL, 0x000fe200078ee20fULL, 0x00005e000a0a7625ULL, 0x000fe200078e0013ULL,
0x000000141d1d7211ULL, 0x000fc600078e20ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e0013ULL,
0x00005e000e0e7625ULL, 0x000fc800078e0013ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x00005e0012107625ULL, 0x080fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e6000b901c46ULL, 0x00005e0016127625ULL, 0x000fc800078e0013ULL,
0x0000001007047825ULL, 0x000fc800078e0004ULL, 0x0000001017177824ULL, 0x000fe400078e0214ULL,
0x0000001007087825ULL, 0x000fc600078e0008ULL, 0x0000000004177faeULL, 0x0003e2000b901c46ULL,
0x0000001019197824ULL, 0x000fe400078e0214ULL, 0x00000010070a7825ULL, 0x000fc600078e000aULL,
0x0000000008197faeULL, 0x0003e2000b901c46ULL, 0x00000010070c7825ULL, 0x000fc600078e000cULL,
0x000000000a1b7faeULL, 0x0003e2000b901c46ULL, 0x00000010070e7825ULL, 0x000fc600078e000eULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0214ULL,
0x0000001007107825ULL, 0x000fc600078e0010ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x000fe400078e0214ULL, 0x0000001007127825ULL, 0x000fc600078e0012ULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000001023237824ULL, 0x000fca00078e0214ULL,
0x0000000012237faeULL, 0x0003e4000b901c46ULL, 0x0000005d6100720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff027424ULL, 0x002fe200078e00ffULL,
0x000000ff00037202ULL, 0x000fe20000000f00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000837000000947ULL, 0x000fea0003800000ULL,
0xff317217ff027424ULL, 0x000fe200078e00ffULL, 0x00007610ff047816ULL, 0x000fe20000000004ULL,
0x000000ffff0f7224ULL, 0x000fc400078e00ffULL, 0x0000010061077824ULL, 0x000fca00078e00ffULL,
0x000000600700720cULL, 0x000fda0003f06070ULL, 0x000082b000000947ULL, 0x000fea0003800000ULL,
0x0000000161087810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000005d0800720cULL, 0x000fe40003f06070ULL, 0x00000020616b7811ULL, 0x000fca00078e40ffULL,
0x0000620006167a24ULL, 0x000fcc00078e026bULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x0000006b60087217ULL, 0x000fe40007800000ULL, 0x00000003ff157819ULL, 0x000fe40000011600ULL,
0x00000007000a7812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a6bULL,
0x0000000415117810ULL, 0x040fe20007ffe0ffULL, 0x0000000115097824ULL, 0x000fe200078e0216ULL,
0x0000020000177802ULL, 0x000fe20000000f00ULL, 0x000000085f197824ULL, 0x000fe200078e020aULL,
0x0000002008107817ULL, 0x000fe20003800000ULL, 0x0000000811147824ULL, 0x000fe200078e00ffULL,
0x0000000c151d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001110a7824ULL, 0x040fe200078e0216ULL,
0x0000000011077212ULL, 0x000fe200078e3cffULL, 0x00005e0009087625ULL, 0x000fe200078e0017ULL,
0x00000007150b7812ULL, 0x000fc400078e4800ULL, 0x00000008151b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d217824ULL, 0x000fe200078e00ffULL, 0x000000101500720cULL, 0x080fe20003f26070ULL,
0x0000001019087825ULL, 0x000fe200078e0008ULL, 0x000000101100720cULL, 0x000fe40003f46070ULL,
0xfffffff814147812ULL, 0x000fe400078ee207ULL, 0x0ffffff80b127812ULL, 0x000fe200078ef800ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0017ULL, 0x0000d0005f077811ULL, 0x000fc400078e68ffULL,
0x000000001b187212ULL, 0x0c0fe400078e3cffULL, 0x000000031b1f7819ULL, 0x000fe200000006ffULL,
0x0000001012117824ULL, 0x100fe200078e0207ULL, 0x000000001d1a7212ULL, 0x000fe200078e3cffULL,
0x0000001014137824ULL, 0x000fe200078e0207ULL, 0xfffffff81f187812ULL, 0x000fe200078ee218ULL,
0x00000010190a7825ULL, 0x000fe200078e000aULL, 0xfffffff8211a7812ULL, 0x000fe200078ee21aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e2000c901c46ULL,
0x00000010151f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001415217810ULL, 0x040fe20007ffe0ffULL,
0x000000000a137faeULL, 0x0005e2000d101c46ULL, 0x0000001815237810ULL, 0x000fe20007ffe0ffULL,
0x000000081f1c7824ULL, 0x000fe200078e00ffULL, 0x0000001c15157810ULL, 0x000fe20007ffe0ffULL,
0x00000008211e7824ULL, 0x000fe200078e00ffULL, 0x000000101b00720cULL, 0x080fe20003f26070ULL,
0x0000000823207824ULL, 0x000fe200078e00ffULL, 0x000000101d00720cULL, 0x080fe20003f46070ULL,
0x0000000815227824ULL, 0x000fe200078e00ffULL, 0x000000101f00720cULL, 0x080fe20003f66070ULL,
0x000000011b087824ULL, 0x102fe200078e0216ULL, 0x000000102100720cULL, 0x0c0fe20003f86070ULL,
0x0000000121127824ULL, 0x000fe200078e0216ULL, 0x000000102300720cULL, 0x000fc40003fa6070ULL,
0x000000101500720cULL, 0x000fe20003fc6070ULL, 0x000000011f107824ULL, 0x100fe200078e0216ULL,
0x000000161d0a7210ULL, 0x004fe40007ffe0ffULL, 0x000000001f097212ULL, 0x080fe400078e3cffULL,
0x00000000210b7212ULL, 0x000fe400078e3cffULL, 0x0000001623147210ULL, 0x000fe20007ffe0ffULL,
0x0000000115167824ULL, 0x000fe200078e0216ULL, 0x0000000023117212ULL, 0x000fc400078e3cffULL,
0x0000000015137212ULL, 0x000fe200078e3cffULL, 0x00005e0014147625ULL, 0x080fe200078e0017ULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee209ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL,
0x00005e0008087625ULL, 0x080fe200078e0017ULL, 0xfffffff820207812ULL, 0x000fe400078ee211ULL,
0xfffffff822227812ULL, 0x000fe200078ee213ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0017ULL,
0x000000071a1b7211ULL, 0x000fc600078e20ffULL, 0x00005e0010107625ULL, 0x000fc800078e0017ULL,
0x00005e0012127625ULL, 0x000fc800078e0017ULL, 0x00005e0016167625ULL, 0x000fc800078e0017ULL,
0x0000001019087825ULL, 0x000fc800078e0008ULL, 0x00000010190a7825ULL, 0x000fc800078e000aULL,
0x0000001019107825ULL, 0x000fc800078e0010ULL, 0x0000001019127825ULL, 0x000fc800078e0012ULL,
0x0000001019147825ULL, 0x000fc800078e0014ULL, 0x0000001019167825ULL, 0x000fc800078e0016ULL,
0x0000001018197824ULL, 0x100fe400078e0207ULL, 0x000000101c1d7824ULL, 0x100fe400078e0207ULL,
0x000000101e1f7824ULL, 0x100fe200078e0207ULL, 0x0000000008197faeULL, 0x0003e2000c901c46ULL,
0x0000001020217824ULL, 0x100fe400078e0207ULL, 0x0000001022077824ULL, 0x000fe200078e0207ULL,
0x000000000a1b7faeULL, 0x0003e8000d101c46ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x00000000121f7faeULL, 0x0003e8000e101c46ULL, 0x0000000014217faeULL, 0x0003e8000e901c46ULL,
0x0000000016077faeULL, 0x0003e2000f101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fe20000011600ULL, 0x00000200ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000d0005f1c7811ULL, 0x000fc400078e68ffULL, 0x00000004070b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000807117810ULL, 0x040fe40007ffe0ffULL, 0x0000000c07137810ULL, 0x000fe40007ffe0ffULL,
0x000000000b087212ULL, 0x080fe200078e3cffULL, 0x0000000811107824ULL, 0x000fe200078e00ffULL,
0x000000030b1f7819ULL, 0x000fe200000006ffULL, 0x0000000813237824ULL, 0x000fe200078e00ffULL,
0x0000000011097212ULL, 0x000fe200078e3cffULL, 0x0000000113127824ULL, 0x000fe200078e0216ULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee208ULL, 0x0000000700087812ULL, 0x000fe400078ec0ffULL,
0x00000000130a7212ULL, 0x000fe200078e3cffULL, 0x000000101f1f7824ULL, 0x000fe200078e021cULL,
0x0000001407177810ULL, 0x000fe20007ffe0ffULL, 0x000000085f1d7824ULL, 0x000fe200078e0208ULL,
0x0000001007157810ULL, 0x040fe40007ffe0ffULL, 0x0000001807197810ULL, 0x000fe20007ffe0ffULL,
0x0000000817227824ULL, 0x000fe200078e00ffULL, 0x0000001c07257810ULL, 0x000fe20007ffe0ffULL,
0x0000000115147824ULL, 0x100fe200078e0216ULL, 0xfffffff810217812ULL, 0x000fe200078ee209ULL,
0x0000000111107824ULL, 0x000fe200078e0216ULL, 0xfffffff823237812ULL, 0x000fe200078ee20aULL,
0x000000010b0a7824ULL, 0x000fe200078e0216ULL, 0x0000000707097812ULL, 0x000fe200078e4800ULL,
0x0000000117187824ULL, 0x100fe200078e0216ULL, 0x0000001607087210ULL, 0x000fe20007ffe0ffULL,
0x00000001191a7824ULL, 0x100fe200078e0216ULL, 0x00000000150b7212ULL, 0x080fe200078e3cffULL,
0x00000001251e7824ULL, 0x000fe200078e0216ULL, 0x0000000315207819ULL, 0x000fe200000006ffULL,
0x0000000825247824ULL, 0x000fe200078e00ffULL, 0x0000000017117212ULL, 0x080fe200078e3cffULL,
0x0000001021217824ULL, 0x000fe200078e021cULL, 0x0000000019137212ULL, 0x000fc400078e3cffULL,
0x0000000319167819ULL, 0x000fe400000006ffULL, 0x0ffffff809077812ULL, 0x000fe200078ef800ULL,
0x00005e0008087625ULL, 0x080fe200078e001bULL, 0x0000000025157212ULL, 0x000fe400078e3cffULL,
0xfffffff820257812ULL, 0x000fe200078ee20bULL, 0x00005e000a0a7625ULL, 0x080fe200078e001bULL,
0xfffffff822277812ULL, 0x000fe400078ee211ULL, 0xfffffff816457812ULL, 0x000fe200078ee213ULL,
0x00005e0010107625ULL, 0x000fe200078e001bULL, 0xfffffff824477812ULL, 0x000fc400078ee215ULL,
0x0000001c23237211ULL, 0x000fe200078e20ffULL, 0x00005e0012127625ULL, 0x000fc800078e001bULL,
0x00005e0014147625ULL, 0x000fc800078e001bULL, 0x00005e0018167625ULL, 0x000fc800078e001bULL,
0x0000001007077824ULL, 0x000fe400078e021cULL, 0x000000101d087825ULL, 0x000fc800078e0008ULL,
0x00005e001a187625ULL, 0x080fe200078e001bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008077faeULL, 0x0003e6000b901c46ULL, 0x00005e001e1a7625ULL, 0x000fc800078e001bULL,
0x000000101d0a7825ULL, 0x000fc800078e000aULL, 0x000000101d107825ULL, 0x040fe200078e0010ULL,
0x000000000a1f7faeULL, 0x0003e6000b901c46ULL, 0x000000101d127825ULL, 0x040fe200078e0012ULL,
0x0000000010217faeULL, 0x0003e6000b901c46ULL, 0x000000101d147825ULL, 0x000fe200078e0014ULL,
0x0000000012237faeULL, 0x0003e6000b901c46ULL, 0x0000001025257824ULL, 0x000fc400078e021cULL,
0x000000101d167825ULL, 0x000fc600078e0016ULL, 0x0000000014257faeULL, 0x0003e2000b901c46ULL,
0x0000001027277824ULL, 0x000fe400078e021cULL, 0x000000101d187825ULL, 0x000fc600078e0018ULL,
0x0000000016277faeULL, 0x0003e2000b901c46ULL, 0x0000001045457824ULL, 0x000fe400078e021cULL,
0x000000101d1a7825ULL, 0x000fc600078e001aULL, 0x0000000018457faeULL, 0x0003e2000b901c46ULL,
0x0000001047477824ULL, 0x000fca00078e021cULL, 0x000000001a477faeULL, 0x0003e4000b901c46ULL,
0x01460c00ff087984ULL, 0x002e620000000800ULL, 0x0000ffff04077812ULL, 0x000fc600078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000888007697816ULL, 0x000fc800000000ffULL,
0x0000001f69077819ULL, 0x000fc800000006ffULL, 0x8000000008ff7812ULL, 0x002fe20007824807ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff077424ULL, 0x000fe400078e00ffULL, 0x8000000069097824ULL, 0x000fe400078e00ffULL,
0x0000000700087305ULL, 0x0002a4000021f000ULL, 0x3fa0000007077823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe40003800000ULL, 0x01460c00ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fc40007824809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000010006c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x000000706c6c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fca00078ec0ffULL, 0x000000016c6c7824ULL, 0x000fca00078e0207ULL,
0x014000006c077984ULL, 0x000e680000000800ULL, 0x014200006c5c7984ULL, 0x0004e20000000800ULL,
0x000000020700720bULL, 0x002fda0003f3d000ULL, 0x0000000000087806ULL, 0x000fc800008e0100ULL,
0x0000ffff080b7812ULL, 0x000fe4000782c0ffULL, 0x0000000100087802ULL, 0x000fd60000000f00ULL,
0x0000035000009947ULL, 0x000fea0003800000ULL, 0x000000020700720bULL, 0x00cfe40003f34000ULL,
0x0000000702117209ULL, 0x000fe40007810000ULL, 0x00000002ff097819ULL, 0x000fc60000011600ULL,
0x8000001102087221ULL, 0x000fe20000010000ULL, 0x00000008090a7810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b08087820ULL, 0x000fe40000410000ULL, 0x0000000000027806ULL, 0x000fe400008e0100ULL,
0x000000ff5f00720cULL, 0x000fe40003f25270ULL, 0x0000ffff02027812ULL, 0x000fe200078e3cffULL,
0x0000000800087308ULL, 0x000e660000000800ULL, 0x000000020bff7212ULL, 0x000fe2000784c0ffULL,
0x000000ffff027224ULL, 0x000fcc00078e0011ULL, 0x014400116c009388ULL, 0x000fe80000000800ULL,
0x00001f0a080a7589ULL, 0x002e6400000e0000ULL, 0x8000001107072221ULL, 0x000fe20000010000ULL,
0x0000000803037220ULL, 0x000fe20000410000ULL, 0x00001f0908097589ULL, 0x0004e400000e0000ULL,
0x3fb8aa3b07072820ULL, 0x000fc80000410000ULL, 0x0000000700052308ULL, 0x000f220000000800ULL,
0x00000001ff087807ULL, 0x004fe20001000000ULL, 0x0000000a0f0f7220ULL, 0x082fe20000410000ULL,
0x0000000a0e0e7220ULL, 0x080fe20000410000ULL, 0x0000000a2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000a2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000a3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000a3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000a43437220ULL, 0x080fe20000410000ULL,
0x0000000a42427220ULL, 0x080fe20000410000ULL, 0x0000000a3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000a3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000a37377220ULL, 0x080fe20000410000ULL,
0x0000000a36367220ULL, 0x080fe20000410000ULL, 0x0000000a33337220ULL, 0x080fe20000410000ULL,
0x0000000a32327220ULL, 0x080fe20000410000ULL, 0x0000000a2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000a2e2e7220ULL, 0x000fe20000410000ULL, 0x000000090d0d7220ULL, 0x088fe20000410000ULL,
0x000000090c0c7220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x080fe20000410000ULL,
0x0000000928287220ULL, 0x080fe20000410000ULL, 0x000000093d3d7220ULL, 0x080fe20000410000ULL,
0x000000093c3c7220ULL, 0x080fe20000410000ULL, 0x0000000941417220ULL, 0x080fe20000410000ULL,
0x0000000940407220ULL, 0x080fe20000410000ULL, 0x0000000939397220ULL, 0x080fe20000410000ULL,
0x0000000938387220ULL, 0x080fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000934347220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x080fe20000410000ULL,
0x0000000930307220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x000fe20000410000ULL, 0x000000055c5c2220ULL, 0x010fe20000410000ULL,
0x0000000700527812ULL, 0x00cfe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000005ff07723eULL, 0x000fe200000010ffULL, 0x000000035c037221ULL, 0x000fe20000010000ULL,
0x00000004ff097819ULL, 0x100fe40000011600ULL, 0x0000000852567812ULL, 0x000fe400078ef800ULL,
0x0000541007127816ULL, 0x000fe40000000007ULL, 0x00000007090b7812ULL, 0x000fe400078e7856ULL,
0x0000000800077812ULL, 0x000fc400078ec0ffULL, 0x0000000409137810ULL, 0x000fe20007ffe0ffULL,
0x00000008566a7824ULL, 0x000fe200078e020bULL, 0x0000000707107812ULL, 0x000fe400078ec852ULL,
0x0000000609157810ULL, 0x040fe40007ffe0ffULL, 0x0000000209117810ULL, 0x000fe40007ffe0ffULL,
0x00000052070a7212ULL, 0x000fe400078efcffULL, 0x0000000910557212ULL, 0x000fc400078e3cffULL,
0x0000001310537212ULL, 0x040fe400078e3cffULL, 0x0000001510157212ULL, 0x000fe200078e3cffULL,
0x000000080a5a7824ULL, 0x000fe200078e0255ULL, 0x0000001110137212ULL, 0x000fe400078e3cffULL,
0x0000a0006a207811ULL, 0x000fe200078e20ffULL, 0x000000080a577824ULL, 0x040fe200078e0215ULL,
0x0000c0005f507811ULL, 0x000fe200078e68ffULL, 0x000000080a597824ULL, 0x040fe200078e0213ULL,
0x000000530a587211ULL, 0x000fc400078e18ffULL, 0x000000002020783bULL, 0x000fe20000000200ULL,
0x000000105a687824ULL, 0x100fe200078e0250ULL, 0x0000005057657211ULL, 0x000fe200078e20ffULL,
0x0000001058667824ULL, 0x000fe200078e0250ULL, 0x00000002ff6d7819ULL, 0x000fe20000011600ULL,
0x0000001059677824ULL, 0x000fe200078e0250ULL, 0x00000000684c783bULL, 0x000fe20000004200ULL,
0x0000000711117812ULL, 0x000fe400078e7856ULL, 0x000000086d077810ULL, 0x000fe20007ffe0ffULL,
0x000000006644783bULL, 0x000fe20000004200ULL, 0x0000991008097816ULL, 0x000fe200000000ffULL,
0x0000000856647824ULL, 0x000fe200078e0211ULL, 0x000000800a107811ULL, 0x000fe200078e18ffULL,
0x000000006748783bULL, 0x000fe20000004200ULL, 0x000000ff0900720cULL, 0x000fc40003f25270ULL,
0x0000a00064087811ULL, 0x000fe200078e20ffULL, 0x000000006524783bULL, 0x000fe20000004200ULL,
0x0000000155557824ULL, 0x100fe200078e0210ULL, 0x0000001015517210ULL, 0x000fe20007ffe0ffULL,
0x0000000153537824ULL, 0x100fe200078e0210ULL, 0x00001f6d126d7589ULL, 0x000e6200000e0000ULL,
0x0000000113547824ULL, 0x000fe200078e0210ULL, 0x000000206b6f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001055637824ULL, 0x100fe200078e0250ULL, 0x00001f07126e7589ULL, 0x000ea200000e0000ULL,
0x00000010535e7824ULL, 0x000fc400078e0250ULL, 0x0000001054627824ULL, 0x100fe200078e0250ULL,
0x000000000808783bULL, 0x000ee20000000200ULL, 0x00000010515b7824ULL, 0x000fc600078e0250ULL,
0x00000000631c783bULL, 0x000f280000004200ULL, 0x000000005e14783bULL, 0x000f680000004200ULL,
0x000000006218783bULL, 0x000f280000004200ULL, 0x000000005b10783bULL, 0x000f220000004200ULL,
0x0000006d20209231ULL, 0x002fc400003400ffULL, 0x0000006d22229231ULL, 0x000fe400003400ffULL,
0x0000006e21219231ULL, 0x084fe400003400ffULL, 0x0000006e23239231ULL, 0x000fce00003400ffULL,
0x0000004c202c723cULL, 0x040ff0000004182cULL, 0x0000004e2030723cULL, 0x000fe20000041830ULL,
0x0000006d08089231ULL, 0x088fe400003400ffULL, 0x0000006d0a0a9231ULL, 0x000fc400003400ffULL,
0x0000006e09099231ULL, 0x000fc600003400ffULL, 0x000000442040723cULL, 0x000fe20000041840ULL,
0x0000006e0b0b9231ULL, 0x000fce00003400ffULL, 0x000000482034723cULL, 0x040ff00000041834ULL,
0x0000004a2038723cULL, 0x040ff00000041838ULL, 0x00000046203c723cULL, 0x040ff0000004183cULL,
0x000000242028723cULL, 0x040ff00000041828ULL, 0x00000026200c723cULL, 0x000ff0000004180cULL,
0x0000001c082c723cULL, 0x050ff0000004182cULL, 0x0000001e0830723cULL, 0x040ff00000041830ULL,
0x000000140840723cULL, 0x060ff00000041840ULL, 0x000000180834723cULL, 0x040ff00000041834ULL,
0x0000001a0838723cULL, 0x040ff00000041838ULL, 0x000000160814723cULL, 0x040ff0000004183cULL,
0x000000100828723cULL, 0x040ff00000041828ULL, 0x00000012081c723cULL, 0x000fee000004180cULL,
0x00006200060e7a24ULL, 0x000fe200078e026fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x00000003ff117819ULL, 0x000fe20000011600ULL,
0x00000200ff127424ULL, 0x000fe200078e00ffULL, 0x000000525f1b7211ULL, 0x000fe400078e18ffULL,
0x00000004110d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001110b7824ULL, 0x040fe200078e020eULL,
0x0000000811257810ULL, 0x000fe40007ffe0ffULL, 0x000000000d087212ULL, 0x0c0fe400078e3cffULL,
0x000000030d237819ULL, 0x000fe200000006ffULL, 0x00000008250a7824ULL, 0x040fe200078e00ffULL,
0x0000000025097212ULL, 0x000fc400078e3cffULL, 0xfffffff823237812ULL, 0x000fe400078ee208ULL,
0x0000006f60087217ULL, 0x000fe40007800000ULL, 0x0000000c113d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001023237824ULL, 0x000fe200078e0250ULL, 0xfffffff80a277812ULL, 0x000fe200078ee209ULL,
0x0000000108087824ULL, 0x000fe200078e0a6fULL, 0x0000000711097812ULL, 0x000fe200078e4800ULL,
0x000000083d0c7824ULL, 0x000fe200078e00ffULL, 0x00000010113f7810ULL, 0x000fe20007ffe0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0012ULL, 0x00000020080f7817ULL, 0x000fc40003800000ULL,
0x000000003d137212ULL, 0x000fe200078e3cffULL, 0x000000083f107824ULL, 0x000fe200078e00ffULL,
0x0000000f0d00720cULL, 0x0c0fe20003f66070ULL, 0x000000010d0d7824ULL, 0x000fe200078e020eULL,
0x0ffffff809217812ULL, 0x000fe200078ef800ULL, 0x0000000125097824ULL, 0x000fe200078e020eULL,
0x0000000f1100720cULL, 0x080fe20003f46070ULL, 0x000000101b0a7825ULL, 0x000fe200078e000aULL,
0xfffffff80c137812ULL, 0x000fe400078ee213ULL, 0x0000000f2500720cULL, 0x000fe20003f86070ULL,
0x00005e000d0c7625ULL, 0x000fe200078e0012ULL, 0x000000003f197212ULL, 0x000fc400078e3cffULL,
0x0000001411457810ULL, 0x000fe20007ffe0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0012ULL,
0xfffffff810197812ULL, 0x000fe400078ee219ULL, 0x0000001811477810ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e0250ULL, 0x0000000045107212ULL, 0x080fe200078e3cffULL,
0x000000101b0c7825ULL, 0x000fe200078e000cULL, 0x0000000345257819ULL, 0x000fe400000006ffULL,
0x0000001c11497810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x000fe200078e0250ULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x000000101b087825ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a217faeULL, 0x0003e2000d101c46ULL,
0x0000000047107212ULL, 0x000fc400078e3cffULL, 0x0000000847117824ULL, 0x000fe200078e00ffULL,
0x000000000c237faeULL, 0x0005e2000d901c46ULL, 0x0000000f3d00720cULL, 0x080fe20003f46070ULL,
0x0000001013137824ULL, 0x100fe200078e0250ULL, 0x0000000f3f00720cULL, 0x080fe20003f66070ULL,
0x0000000008277faeULL, 0x0007e2000e101c46ULL, 0x0000000f4500720cULL, 0x080fe20003f86070ULL,
0x0000001019197824ULL, 0x000fe200078e0250ULL, 0x0000000f4700720cULL, 0x0c0fe20003fa6070ULL,
0x00000001470b7824ULL, 0x102fe200078e020eULL, 0x0000000f4900720cULL, 0x000fe20003fc6070ULL,
0x000000013f0f7824ULL, 0x000fe200078e020eULL, 0xfffffff811217812ULL, 0x000fe200078ee210ULL,
0x0000000145117824ULL, 0x000fe200078e020eULL, 0x0000000e3d0d7210ULL, 0x004fe20007ffe0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0012ULL, 0x0000000049187212ULL, 0x000fc400078e3cffULL,
0x0000000349237819ULL, 0x040fe200000006ffULL, 0x0000000149097824ULL, 0x008fe400078e020eULL,
0x00005e000d0c7625ULL, 0x000fe200078e0012ULL, 0xfffffff823237812ULL, 0x000fc600078ee218ULL,
0x00005e000f0e7625ULL, 0x000fe200078e0012ULL, 0x0000005023237211ULL, 0x000fc600078e20ffULL,
0x00005e0011107625ULL, 0x000fc800078e0012ULL, 0x00005e0009087625ULL, 0x000fc800078e0012ULL,
0x000000101b0c7825ULL, 0x000fc800078e000cULL, 0x000000101b0e7825ULL, 0x040fe200078e000eULL,
0x000000000c137faeULL, 0x0003e6000d101c46ULL, 0x000000101b107825ULL, 0x000fe200078e0010ULL,
0x000000000e197faeULL, 0x0003e6000d901c46ULL, 0x0000001025257824ULL, 0x000fe400078e0250ULL,
0x000000101b0a7825ULL, 0x000fc600078e000aULL, 0x0000000010257faeULL, 0x0003e2000e101c46ULL,
0x0000001021217824ULL, 0x000fe400078e0250ULL, 0x000000101b087825ULL, 0x000fc600078e0008ULL,
0x000000000a217faeULL, 0x0003e8000e901c46ULL, 0x0000000008237faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe20000011600ULL,
0x000000085f237824ULL, 0x000fe200078e0252ULL, 0x00000200000b7802ULL, 0x000fe40000000f00ULL,
0x00000004090f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000809117810ULL, 0x000fc40007ffe0ffULL,
0x0000000c09137810ULL, 0x000fe20007ffe0ffULL, 0x000000080f087824ULL, 0x040fe200078e00ffULL,
0x000000000f277212ULL, 0x080fe200078e3cffULL, 0x00000008110a7824ULL, 0x000fe200078e00ffULL,
0x00000007090d7812ULL, 0x000fe200078e4800ULL, 0x00000008130c7824ULL, 0x000fe200078e00ffULL,
0x0000001c093f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111107824ULL, 0x140fe200078e020eULL,
0x0000000011257212ULL, 0x080fe200078e3cffULL, 0x0000000113127824ULL, 0x040fe200078e020eULL,
0x0000000013217212ULL, 0x000fe200078e3cffULL, 0x000000083f3c7824ULL, 0x000fe200078e00ffULL,
0x0000001009197810ULL, 0x040fe20007ffe0ffULL, 0x00005e0012127625ULL, 0x000fe200078e000bULL,
0x00000014091b7810ULL, 0x000fc40007ffe0ffULL, 0x00000018093d7810ULL, 0x040fe40007ffe0ffULL,
0xfffffff808277812ULL, 0x000fe200078ee227ULL, 0x0000000109087824ULL, 0x000fe200078e020eULL,
0x0ffffff80d0d7812ULL, 0x000fe200078ef800ULL, 0x000000011b207824ULL, 0x100fe200078e020eULL,
0xfffffff80a257812ULL, 0x000fe200078ee225ULL, 0x000000013d227824ULL, 0x100fe200078e020eULL,
0xfffffff80c217812ULL, 0x000fe200078ee221ULL, 0x000000010f0c7824ULL, 0x000fe200078e020eULL,
0x0000000e19187210ULL, 0x000fe20007ffe0ffULL, 0x000000081b267824ULL, 0x000fe200078e00ffULL,
0x00000000190a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x000000003f117212ULL, 0x040fe200078e3cffULL, 0x00005e0008087625ULL, 0x000fe200078e000bULL,
0x0000000e3f247210ULL, 0x000fc40007ffe0ffULL, 0x000000003d0e7212ULL, 0x0c0fe200078e3cffULL,
0x000000083d477824ULL, 0x000fe200078e00ffULL, 0x000000001b0f7212ULL, 0x000fe200078e3cffULL,
0x000000100d3d7824ULL, 0x000fe200078e0250ULL, 0xfffffff83c497812ULL, 0x000fe200078ee211ULL,
0x00005e000c0c7625ULL, 0x080fe200078e000bULL, 0xfffffff8193f7812ULL, 0x000fe400078ee20aULL,
0xfffffff826457812ULL, 0x000fe200078ee20fULL, 0x00005e0010107625ULL, 0x000fe200078e000bULL,
0xfffffff847477812ULL, 0x000fc400078ee20eULL, 0x0000005025257211ULL, 0x080fe200078e20ffULL,
0x00005e0018187625ULL, 0x000fe200078e000bULL, 0x0000005049497211ULL, 0x000fc600078e20ffULL,
0x00000010231a7825ULL, 0x000fc800078e0008ULL, 0x00005e00200e7625ULL, 0x080fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a3d7faeULL, 0x0003e6000b901c46ULL,
0x00005e0022087625ULL, 0x000fc800078e000bULL, 0x00005e00240a7625ULL, 0x000fc800078e000bULL,
0x0000001027277824ULL, 0x000fe400078e0250ULL, 0x00000010230c7825ULL, 0x000fc800078e000cULL,
0x0000001023107825ULL, 0x040fe200078e0010ULL, 0x000000000c277faeULL, 0x0003e6000b901c46ULL,
0x0000001023127825ULL, 0x000fe200078e0012ULL, 0x0000000010257faeULL, 0x0003e6000b901c46ULL,
0x0000001021217824ULL, 0x000fe400078e0250ULL, 0x0000001023187825ULL, 0x000fc600078e0018ULL,
0x0000000012217faeULL, 0x0003e2000b901c46ULL, 0x000000103f3f7824ULL, 0x000fe400078e0250ULL,
0x00000010230e7825ULL, 0x000fc600078e000eULL, 0x00000000183f7faeULL, 0x0003e2000b901c46ULL,
0x0000001045457824ULL, 0x000fe400078e0250ULL, 0x0000001023087825ULL, 0x000fc600078e0008ULL,
0x000000000e457faeULL, 0x0003e2000b901c46ULL, 0x0000001047477824ULL, 0x000fe400078e0250ULL,
0x00000010230a7825ULL, 0x000fc600078e000aULL, 0x0000000008477faeULL, 0x0003e8000b901c46ULL,
0x000000000a497faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000400097811ULL, 0x002fe400078fe0ffULL, 0x00001000506d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000709097812ULL, 0x000fe400078e7856ULL, 0x0000006d58587211ULL, 0x000fe200078e20ffULL,
0x000000105a5a7824ULL, 0x000fe200078e026dULL, 0x00000005ff08723eULL, 0x000fe200000010ffULL,
0x00000008565c7824ULL, 0x000fe200078e0209ULL, 0x0000000600097811ULL, 0x000fe200078fe0ffULL,
0x0000001059597824ULL, 0x100fe200078e026dULL, 0x00000002ff717819ULL, 0x000fe20000011600ULL,
0x0000001057577824ULL, 0x100fe200078e026dULL, 0x0000a0005c207811ULL, 0x000fe200078e20ffULL,
0x0000001053537824ULL, 0x100fe200078e026dULL, 0x0000000709097812ULL, 0x000fe200078e7856ULL,
0x0000001055557824ULL, 0x100fe200078e026dULL, 0x0000541008707816ULL, 0x000fe20000000008ULL,
0x0000001054547824ULL, 0x000fe200078e026dULL, 0x0000006d51517211ULL, 0x000fe200078e20ffULL,
0x0000000856567824ULL, 0x000fe200078e0209ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002020783bULL, 0x000fe20000000200ULL, 0x0000a000560c7811ULL, 0x000fc600078e20ffULL,
0x000000005844783bULL, 0x000fe80000004200ULL, 0x000000005a4c783bULL, 0x000fe80000004200ULL,
0x000000005948783bULL, 0x000fe80000004200ULL, 0x000000005724783bULL, 0x000fe80000004200ULL,
0x00001f7170717589ULL, 0x000e6800000e0000ULL, 0x00001f07706e7589ULL, 0x000ea800000e0000ULL,
0x000000000c0c783bULL, 0x000ee80000000200ULL, 0x00000000533c783bULL, 0x000f280000004200ULL,
0x000000005518783bULL, 0x000f680000004200ULL, 0x000000005410783bULL, 0x000f280000004200ULL,
0x000000005108783bULL, 0x000f220000004200ULL, 0x0000007120209231ULL, 0x002fc400003400ffULL,
0x0000007122229231ULL, 0x000fe400003400ffULL, 0x0000006e21219231ULL, 0x084fe400003400ffULL,
0x0000006e23239231ULL, 0x000fce00003400ffULL, 0x000000442040723cULL, 0x040ff00000041840ULL,
0x0000004c202c723cULL, 0x000fe2000004182cULL, 0x000000710c0c9231ULL, 0x088fe400003400ffULL,
0x000000710e0e9231ULL, 0x000fc400003400ffULL, 0x0000006e0d0d9231ULL, 0x000fc600003400ffULL,
0x0000004e2030723cULL, 0x000fe20000041830ULL, 0x0000006e0f0f9231ULL, 0x000fce00003400ffULL,
0x000000482034723cULL, 0x040ff00000041834ULL, 0x0000004a2038723cULL, 0x040ff00000041838ULL,
0x000000462014723cULL, 0x040ff00000041814ULL, 0x000000242028723cULL, 0x040ff00000041828ULL,
0x00000026201c723cULL, 0x000ff0000004181cULL, 0x0000003c0c40723cULL, 0x050ff00000041840ULL,
0x000000180c2c723cULL, 0x060ff0000004182cULL, 0x0000001a0c30723cULL, 0x040ff00000041830ULL,
0x000000100c34723cULL, 0x040ff00000041834ULL, 0x000000120c38723cULL, 0x040ff00000041838ULL,
0x0000003e0c3c723cULL, 0x040ff00000041814ULL, 0x000000080c28723cULL, 0x040ff00000041828ULL,
0x0000000a0c0c723cULL, 0x000fe2000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000606f00720cULL, 0x000fe20003f26070ULL, 0x01461000ffff7f8cULL, 0x000fd8000c80043fULL,
0x00005f0000001947ULL, 0x000fea0003800000ULL, 0x000000406b097810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000620006107a24ULL, 0x000fe200078e0209ULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x00000003ff177819ULL, 0x000fe20000011600ULL,
0x00000200ff1a7424ULL, 0x000fe200078e00ffULL, 0x0000000960087217ULL, 0x000fe20007800000ULL,
0x000000085f197824ULL, 0x000fe200078e0252ULL, 0x0000000417137810ULL, 0x040fe40007ffe0ffULL,
0x00000008171b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a09ULL,
0x00000000130a7212ULL, 0x040fe200078e3cffULL, 0x00000008130b7824ULL, 0x000fe200078e00ffULL,
0x0000001017097210ULL, 0x000fe20007ffe0ffULL, 0x000000081b1f7824ULL, 0x000fe200078e00ffULL,
0x0000002008117817ULL, 0x000fc40003800000ULL, 0xfffffff80b147812ULL, 0x000fe200078ee20aULL,
0x00005e0009087625ULL, 0x080fe200078e001aULL, 0x00000007170b7812ULL, 0x140fe400078e4800ULL,
0x0000000c171d7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff80b127812ULL, 0x000fe200078ef800ULL,
0x00000001130b7824ULL, 0x000fe200078e0210ULL, 0x000000111700720cULL, 0x080fe20003f26070ULL,
0x000000081d217824ULL, 0x000fe200078e00ffULL, 0x000000111300720cULL, 0x000fe20003f46070ULL,
0x00005e000b0a7625ULL, 0x000fe200078e001aULL, 0x000000001b167212ULL, 0x000fc400078e3cffULL,
0x000000001d187212ULL, 0x000fe200078e3cffULL, 0x0000001012137824ULL, 0x000fe200078e026dULL,
0x0000006d14157211ULL, 0x000fe200078e20ffULL, 0x0000001019087825ULL, 0x000fe200078e0008ULL,
0xfffffff81f1c7812ULL, 0x000fe400078ee216ULL, 0xfffffff821187812ULL, 0x000fe200078ee218ULL,
0x00000010190a7825ULL, 0x000fe200078e000aULL, 0x00000010171f7810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c901c46ULL,
0x0000001417217810ULL, 0x000fc40007ffe0ffULL, 0x0000001817237810ULL, 0x040fe20007ffe0ffULL,
0x000000000a157faeULL, 0x0005e2000d101c46ULL, 0x0000001c17257810ULL, 0x000fe20007ffe0ffULL,
0x000000011f177824ULL, 0x100fe200078e0210ULL, 0x000000111b00720cULL, 0x080fe40003f26070ULL,
0x000000111d00720cULL, 0x080fe20003f46070ULL, 0x00005e0017167625ULL, 0x000fe200078e001aULL,
0x000000111f00720cULL, 0x080fe40003f66070ULL, 0x000000112100720cULL, 0x080fe20003f86070ULL,
0x000000011d137824ULL, 0x102fe200078e0210ULL, 0x000000112300720cULL, 0x0c0fe20003fa6070ULL,
0x0000000123097824ULL, 0x100fe200078e0210ULL, 0x000000112500720cULL, 0x000fe20003fc6070ULL,
0x000000011b117824ULL, 0x100fe200078e0210ULL, 0x0000001021157210ULL, 0x004fe20007ffe0ffULL,
0x00000001250b7824ULL, 0x000fe200078e0210ULL, 0x000000001f087212ULL, 0x0c0fe200078e3cffULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x00000000210a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0x0000000023107212ULL, 0x0c0fe200078e3cffULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x0000000025127212ULL, 0x000fe200078e3cffULL,
0x00005e0015147625ULL, 0x000fe200078e001aULL, 0x0000000325257819ULL, 0x000fc400000006ffULL,
0xfffffff81f1e7812ULL, 0x000fe200078ee208ULL, 0x00005e0009087625ULL, 0x080fe200078e001aULL,
0xfffffff821207812ULL, 0x000fe400078ee20aULL, 0xfffffff823227812ULL, 0x000fe200078ee210ULL,
0x00005e0011107625ULL, 0x080fe200078e001aULL, 0xfffffff825247812ULL, 0x000fe400078ee212ULL,
0x0000006d22217211ULL, 0x000fe200078e20ffULL, 0x00005e0013127625ULL, 0x000fc800078e001aULL,
0x00005e000b0a7625ULL, 0x000fc800078e001aULL, 0x000000101c1b7824ULL, 0x000fe400078e026dULL,
0x0000001019107825ULL, 0x000fc800078e0010ULL, 0x0000001019127825ULL, 0x040fe200078e0012ULL,
0x00000000101b7faeULL, 0x0003e6000c901c46ULL, 0x0000001019167825ULL, 0x000fc800078e0016ULL,
0x0000001019147825ULL, 0x000fc800078e0014ULL, 0x0000001019087825ULL, 0x000fc800078e0008ULL,
0x00000010190a7825ULL, 0x000fc800078e000aULL, 0x0000001018197824ULL, 0x100fe400078e026dULL,
0x000000101e1d7824ULL, 0x100fe400078e026dULL, 0x00000010201f7824ULL, 0x100fe200078e026dULL,
0x0000000012197faeULL, 0x0003e2000d101c46ULL, 0x0000001024237824ULL, 0x000fc600078e026dULL,
0x00000000161d7faeULL, 0x0003e8000d901c46ULL, 0x00000000141f7faeULL, 0x0003e8000e101c46ULL,
0x0000000008217faeULL, 0x0003e8000e901c46ULL, 0x000000000a237faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe40000011600ULL,
0x000000525f1d7211ULL, 0x000fc400078e18ffULL, 0x0000000409137810ULL, 0x040fe20007ffe0ffULL,
0x0000000109087824ULL, 0x140fe200078e0210ULL, 0x0000000c09177810ULL, 0x040fe40007ffe0ffULL,
0x0000000809157810ULL, 0x000fe20007ffe0ffULL, 0x00000008130b7824ULL, 0x040fe200078e00ffULL,
0x0000000013207212ULL, 0x080fe200078e3cffULL, 0x0000000817197824ULL, 0x040fe200078e00ffULL,
0x00000000171c7212ULL, 0x080fe200078e3cffULL, 0x0000000815117824ULL, 0x040fe200078e00ffULL,
0x00000000151e7212ULL, 0x000fe200078e3cffULL, 0x0000000113127824ULL, 0x000fe200078e0210ULL,
0xfffffff80b207812ULL, 0x000fe200078ee220ULL, 0x00000200ff0b7424ULL, 0x000fe200078e00ffULL,
0xfffffff8191c7812ULL, 0x000fe200078ee21cULL, 0x0000000115147824ULL, 0x000fe200078e0210ULL,
0xfffffff8111e7812ULL, 0x000fc400078ee21eULL, 0x0000001009197810ULL, 0x040fe40007ffe0ffULL,
0x00000014091b7810ULL, 0x040fe20007ffe0ffULL, 0x000000101e237824ULL, 0x000fe200078e026dULL,
0x00000018091f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119187824ULL, 0x000fe200078e0210ULL,
0x0000001c09217810ULL, 0x000fe20007ffe0ffULL, 0x0000000819227824ULL, 0x000fe200078e00ffULL,
0x0000000709117812ULL, 0x000fe200078e4800ULL, 0x00005e0008087625ULL, 0x000fe200078e000bULL,
0x0000001017167210ULL, 0x000fc40007ffe0ffULL, 0x0ffffff8110a7812ULL, 0x000fe200078ef800ULL,
0x000000011b247824ULL, 0x100fe200078e0210ULL, 0x000000101f447210ULL, 0x000fe20007ffe0ffULL,
0x0000000121487824ULL, 0x000fe200078e0210ULL, 0x0000000019117212ULL, 0x080fe200078e3cffULL,
0x000000081f177824ULL, 0x040fe200078e00ffULL, 0x000000001f107212ULL, 0x080fe200078e3cffULL,
0x000000081b267824ULL, 0x040fe200078e00ffULL, 0x000000001b137212ULL, 0x080fe200078e3cffULL,
0x00000008214a7824ULL, 0x040fe200078e00ffULL, 0x0000000021157212ULL, 0x000fe200078e3cffULL,
0x000000101d1a7825ULL, 0x000fe200078e0008ULL, 0xfffffff822227812ULL, 0x000fc400078ee211ULL,
0xfffffff817467812ULL, 0x000fe200078ee210ULL, 0x00005e0012087625ULL, 0x080fe200078e000bULL,
0xfffffff826267812ULL, 0x000fe400078ee213ULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee215ULL,
0x00005e0014107625ULL, 0x000fe200078e000bULL, 0x0000006d20217211ULL, 0x080fe400078e20ffULL,
0x0000006d46257211ULL, 0x000fe200078e20ffULL, 0x000000100a1f7824ULL, 0x000fe400078e026dULL,
0x00005e0016167625ULL, 0x000fc600078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a1f7faeULL, 0x0003e2000b901c46ULL, 0x00005e0018187625ULL, 0x000fc800078e000bULL,
0x00005e0024147625ULL, 0x000fc800078e000bULL, 0x00005e0044127625ULL, 0x000fc800078e000bULL,
0x00005e00480a7625ULL, 0x000fc800078e000bULL, 0x000000101d087825ULL, 0x000fc800078e0008ULL,
0x000000101d107825ULL, 0x040fe200078e0010ULL, 0x0000000008217faeULL, 0x0005e6000b901c46ULL,
0x000000101d167825ULL, 0x040fe200078e0016ULL, 0x0000000010237faeULL, 0x0005e6000b901c46ULL,
0x000000101d187825ULL, 0x000fc800078e0018ULL, 0x000000101d147825ULL, 0x000fc800078e0014ULL,
0x000000101d127825ULL, 0x000fc800078e0012ULL, 0x000000101d0a7825ULL, 0x000fc800078e000aULL,
0x000000101c1b7824ULL, 0x102fe400078e026dULL, 0x00000010221d7824ULL, 0x100fe400078e026dULL,
0x00000010261f7824ULL, 0x100fe200078e026dULL, 0x00000000161b7faeULL, 0x0005e2000b901c46ULL,
0x000000104a277824ULL, 0x000fc600078e026dULL, 0x00000000181d7faeULL, 0x0005e8000b901c46ULL,
0x00000000141f7faeULL, 0x0005e8000b901c46ULL, 0x0000000012257faeULL, 0x0005e8000b901c46ULL,
0x000000000a277faeULL, 0x0005e4000b901c46ULL, 0x01461c00ff087984ULL, 0x006e620000000800ULL,
0x8000000069097824ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x8000000008ff7812ULL, 0x002fe40007824809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fe400078e00ffULL,
0x80000000690a7824ULL, 0x000fe400078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x01461c00ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc4000782480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x014080006c097984ULL, 0x000e620000000800ULL, 0x0000a8006a207811ULL, 0x000fc600078e20ffULL,
0x014280006c6e7984ULL, 0x0004e20000000800ULL, 0x000000020900720bULL, 0x002fda0003f3d000ULL,
0x0000000000087806ULL, 0x000fc800008e0100ULL, 0x0000ffff08107812ULL, 0x000fe4000782c0ffULL,
0x0000000100087802ULL, 0x000fd60000000f00ULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x000000020900720bULL, 0x00cfe40003f34000ULL, 0x00000009020b7209ULL, 0x000fe40007810000ULL,
0x00000002ff137819ULL, 0x000fc60000011600ULL, 0x8000000b02087221ULL, 0x040fe20000010000ULL,
0x0000000902027209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b080a7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400008e0100ULL, 0x000000015f00780cULL, 0x000fe40003f25270ULL,
0x0000000a000a7308ULL, 0x000e620000000800ULL, 0x0000ffff08117812ULL, 0x000fc800078e3cffULL,
0x0000001110ff7212ULL, 0x000fcc000784c0ffULL, 0x0144800b6c009388ULL, 0x000fe80000000800ULL,
0x00001f130a087589ULL, 0x002e6200000e0000ULL, 0x0000000a03037220ULL, 0x000fe40000410000ULL,
0x8000000b09112221ULL, 0x000fe20000010000ULL, 0x00001f070a107589ULL, 0x000ea600000e0000ULL,
0x3fb8aa3b11112820ULL, 0x000fc80000410000ULL, 0x0000001100052308ULL, 0x000ee20000000800ULL,
0x000000082c2c7220ULL, 0x082fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000838387220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x000000083c3c7220ULL, 0x080fe20000410000ULL, 0x000000083d3d7220ULL, 0x080fe20000410000ULL,
0x0000000828287220ULL, 0x080fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x000000080d0d7220ULL, 0x000fe20000410000ULL,
0x00000001ff087807ULL, 0x000fe20001000000ULL, 0x000000102e2e7220ULL, 0x084fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000103a3a7220ULL, 0x080fe20000410000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x0000001042427220ULL, 0x080fe20000410000ULL,
0x0000001043437220ULL, 0x080fe20000410000ULL, 0x000000103e3e7220ULL, 0x080fe20000410000ULL,
0x000000103f3f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000100e0e7220ULL, 0x080fe20000410000ULL,
0x000000100f0f7220ULL, 0x000fe20000410000ULL, 0x0000006e056e2220ULL, 0x008fe20000410000ULL,
0x000080400000791aULL, 0x00cfc80000000000ULL, 0x000000002020783bULL, 0x000fe20000000200ULL,
0x00000005ff09723eULL, 0x000fe200000010ffULL, 0x000000036e037221ULL, 0x000fe20000010000ULL,
0x00000002ff6f7819ULL, 0x000fe20000011600ULL, 0x00000000684c783bULL, 0x000fe20000004200ULL,
0x0000541009727816ULL, 0x000fe40000000009ULL, 0x0000a80064097811ULL, 0x000fe200078e20ffULL,
0x000000006644783bULL, 0x000fe20000004200ULL, 0x0000991008107816ULL, 0x000fc600000000ffULL,
0x000000006748783bULL, 0x000fe20000004200ULL, 0x000000ff1000720cULL, 0x000fc60003f25270ULL,
0x000000006524783bULL, 0x000fe80000004200ULL, 0x00001f6f726f7589ULL, 0x000e6800000e0000ULL,
0x00001f0772707589ULL, 0x000ea800000e0000ULL, 0x000000000908783bULL, 0x000ee80000000200ULL,
0x00000000631c783bULL, 0x000f280000004200ULL, 0x000000005e14783bULL, 0x000f680000004200ULL,
0x000000006218783bULL, 0x000f280000004200ULL, 0x000000005b10783bULL, 0x000f220000004200ULL,
0x0000006f20209231ULL, 0x002fc400003400ffULL, 0x0000006f22229231ULL, 0x000fe400003400ffULL,
0x0000007021219231ULL, 0x084fe400003400ffULL, 0x0000007023239231ULL, 0x000fce00003400ffULL,
0x0000004c202c723cULL, 0x040ff0000004182cULL, 0x0000004e2030723cULL, 0x000fe20000041830ULL,
0x0000006f08089231ULL, 0x088fe400003400ffULL, 0x0000006f0a0a9231ULL, 0x000fe200003400ffULL,
0x000000606b6f7810ULL, 0x000fe20007ffe0ffULL, 0x0000007009099231ULL, 0x000fc600003400ffULL,
0x000000442040723cULL, 0x000fe20000041840ULL, 0x000000700b0b9231ULL, 0x000fce00003400ffULL,
0x000000482034723cULL, 0x040ff00000041834ULL, 0x0000004a2038723cULL, 0x040ff00000041838ULL,
0x00000046203c723cULL, 0x040ff0000004183cULL, 0x000000242028723cULL, 0x040ff00000041828ULL,
0x00000026200c723cULL, 0x000ff0000004180cULL, 0x0000001c082c723cULL, 0x050ff0000004182cULL,
0x0000001e0830723cULL, 0x040ff00000041830ULL, 0x000000140840723cULL, 0x060ff00000041840ULL,
0x000000180834723cULL, 0x040ff00000041834ULL, 0x0000001a0838723cULL, 0x040ff00000041838ULL,
0x000000160814723cULL, 0x040ff0000004183cULL, 0x000000100828723cULL, 0x040ff00000041828ULL,
0x00000012081c723cULL, 0x000fee000004180cULL, 0x00006200060e7a24ULL, 0x000fe200078e026fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000058000008947ULL, 0x000fea0003800000ULL,
0x00000003ff117819ULL, 0x000fe20000011600ULL, 0x00000200ff127424ULL, 0x000fe400078e00ffULL,
0x000000085f1b7824ULL, 0x000fe200078e0252ULL, 0x00000004110d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001110b7824ULL, 0x040fe200078e020eULL, 0x0000000811257810ULL, 0x000fe40007ffe0ffULL,
0x000000000d087212ULL, 0x0c0fe200078e3cffULL, 0x000000080d237824ULL, 0x000fe200078e00ffULL,
0x0000000025097212ULL, 0x040fe200078e3cffULL, 0x00000008250a7824ULL, 0x000fe200078e00ffULL,
0x0000000c113d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe400078ee208ULL,
0x0000006f60087217ULL, 0x000fe20007800000ULL, 0x000000083d0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a277812ULL, 0x000fe200078ee209ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0012ULL,
0x000000086f087210ULL, 0x000fe40007ffe1ffULL, 0x0000000711097812ULL, 0x000fe200078e4800ULL,
0x0000001023237824ULL, 0x000fe200078e0250ULL, 0x00000020080f7817ULL, 0x000fe20003800000ULL,
0x000000101b0a7825ULL, 0x000fe200078e000aULL, 0x00000010113f7810ULL, 0x000fc40007ffe0ffULL,
0x000000003d137212ULL, 0x000fe200078e3cffULL, 0x0000001027277824ULL, 0x000fe200078e0250ULL,
0x0ffffff809217812ULL, 0x000fe200078ef800ULL, 0x000000083f107824ULL, 0x000fe200078e00ffULL,
0x0000000f0d00720cULL, 0x0c0fe20003f66070ULL, 0x000000010d0d7824ULL, 0x000fe200078e020eULL,
0x0000000e25097210ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0250ULL,
0x0000001411457810ULL, 0x040fe40007ffe0ffULL, 0x0000000f1100720cULL, 0x000fe20003f46070ULL,
0x00005e0009087625ULL, 0x000fe200078e0012ULL, 0x000000003f197212ULL, 0x000fc400078e3cffULL,
0xfffffff80c137812ULL, 0x000fe200078ee213ULL, 0x00005e000d0c7625ULL, 0x000fe200078e0012ULL,
0x0000000f2500720cULL, 0x080fe40003f86070ULL, 0xfffffff810197812ULL, 0x000fe200078ee219ULL,
0x0000000845257824ULL, 0x040fe200078e00ffULL, 0x0000000045107212ULL, 0x080fe200078e3cffULL,
0x000000101b0c7825ULL, 0x000fe200078e000cULL, 0x0000001811477810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a217faeULL, 0x0003e2000d101c46ULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x000000101b087825ULL, 0x000fe200078e0008ULL,
0x0000001c11497810ULL, 0x000fe20007ffe0ffULL, 0x000000000c237faeULL, 0x0005e2000d901c46ULL,
0x0000000047107212ULL, 0x000fe200078e3cffULL, 0x0000001013137824ULL, 0x100fe200078e0250ULL,
0x0000000347117819ULL, 0x000fe200000006ffULL, 0x0000000008277faeULL, 0x0007e2000e101c46ULL,
0x0000000f3d00720cULL, 0x080fe20003f46070ULL, 0x0000001019197824ULL, 0x000fe200078e0250ULL,
0x0000000f3f00720cULL, 0x080fe20003f66070ULL, 0x00000001470b7824ULL, 0x002fe200078e020eULL,
0xfffffff811217812ULL, 0x000fe200078ee210ULL, 0x000000013f117824ULL, 0x100fe200078e020eULL,
0x0000000f4500720cULL, 0x080fe20003f86070ULL, 0x000000013d0d7824ULL, 0x104fe200078e020eULL,
0x0000000f4700720cULL, 0x080fe20003fa6070ULL, 0x0000000849237824ULL, 0x040fe200078e00ffULL,
0x0000000f4900720cULL, 0x000fe20003fc6070ULL, 0x00000001450f7824ULL, 0x000fe200078e020eULL,
0x0000000e49097210ULL, 0x008fe20007ffe0ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0012ULL,
0x0000000049187212ULL, 0x000fc400078e3cffULL, 0x0000005021217211ULL, 0x000fe200078e20ffULL,
0x00005e0011107625ULL, 0x000fe200078e0012ULL, 0xfffffff823237812ULL, 0x000fc600078ee218ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0012ULL, 0x00005e000b0a7625ULL, 0x000fc800078e0012ULL,
0x00005e0009087625ULL, 0x000fc800078e0012ULL, 0x000000101b0c7825ULL, 0x000fc800078e000cULL,
0x000000101b107825ULL, 0x040fe200078e0010ULL, 0x000000000c137faeULL, 0x0003e6000d101c46ULL,
0x000000101b0e7825ULL, 0x000fe200078e000eULL, 0x0000000010197faeULL, 0x0003e6000d901c46ULL,
0x0000001025257824ULL, 0x000fe400078e0250ULL, 0x000000101b0a7825ULL, 0x000fc600078e000aULL,
0x000000000e257faeULL, 0x0003e2000e101c46ULL, 0x000000101b087825ULL, 0x000fc600078e0008ULL,
0x000000000a217faeULL, 0x0003e2000e901c46ULL, 0x0000001023237824ULL, 0x000fca00078e0250ULL,
0x0000000008237faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe20000011600ULL, 0x00000200ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000525f237211ULL, 0x000fe400078e18ffULL, 0x00000004090f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000809117810ULL, 0x040fe40007ffe0ffULL, 0x0000000c09137810ULL, 0x000fe20007ffe0ffULL,
0x000000080f087824ULL, 0x040fe200078e00ffULL, 0x000000000f277212ULL, 0x080fe200078e3cffULL,
0x00000008110a7824ULL, 0x040fe200078e00ffULL, 0x0000000011257212ULL, 0x080fe200078e3cffULL,
0x00000008130c7824ULL, 0x040fe200078e00ffULL, 0x0000000013217212ULL, 0x000fe200078e3cffULL,
0x0000000111107824ULL, 0x000fe200078e020eULL, 0x0000001009197810ULL, 0x000fc40007ffe0ffULL,
0x00000014091b7810ULL, 0x040fe40007ffe0ffULL, 0x00000018093f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119187824ULL, 0x100fe200078e020eULL, 0x0000001c09457810ULL, 0x000fe20007ffe0ffULL,
0x000000081b267824ULL, 0x000fe200078e00ffULL, 0xfffffff808277812ULL, 0x000fe200078ee227ULL,
0x0000000109087824ULL, 0x100fe200078e020eULL, 0xfffffff80a257812ULL, 0x000fe200078ee225ULL,
0x000000010f0a7824ULL, 0x100fe200078e020eULL, 0xfffffff80c217812ULL, 0x000fe200078ee221ULL,
0x000000011b0c7824ULL, 0x100fe200078e020eULL, 0x0000000e13127210ULL, 0x080fe20007ffe0ffULL,
0x0000000145227824ULL, 0x000fe200078e020eULL, 0x0000000e3f207210ULL, 0x040fe20007ffe0ffULL,
0x000000083f477824ULL, 0x000fe200078e00ffULL, 0x00000007090b7812ULL, 0x000fe200078e4800ULL,
0x00000008453c7824ULL, 0x000fe200078e00ffULL, 0x000000001b0f7212ULL, 0x080fe200078e3cffULL,
0x00005e0008087625ULL, 0x000fe200078e000dULL, 0x000000003f0e7212ULL, 0x000fc400078e3cffULL,
0x0000000045117212ULL, 0x080fe200078e3cffULL, 0x0000000819247824ULL, 0x000fe200078e00ffULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef800ULL, 0x00005e0012127625ULL, 0x080fe200078e000dULL,
0xfffffff826457812ULL, 0x000fe400078ee20fULL, 0xfffffff847477812ULL, 0x000fe200078ee20eULL,
0x00005e000a0e7625ULL, 0x080fe200078e000dULL, 0x00000000193d7212ULL, 0x000fe400078e3cffULL,
0xfffffff83c497812ULL, 0x000fe200078ee211ULL, 0x00005e0010107625ULL, 0x000fe200078e000dULL,
0xfffffff8243d7812ULL, 0x000fc400078ee23dULL, 0x0000005027277211ULL, 0x080fe200078e20ffULL,
0x00000010231a7825ULL, 0x000fe200078e0008ULL, 0x0000005047477211ULL, 0x000fc600078e20ffULL,
0x00005e0018187625ULL, 0x000fc800078e000dULL, 0x000000100b3f7824ULL, 0x000fe400078e0250ULL,
0x00005e000c087625ULL, 0x000fc600078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a3f7faeULL, 0x0003e2000b901c46ULL, 0x00005e00200a7625ULL, 0x000fc800078e000dULL,
0x00005e00220c7625ULL, 0x000fc800078e000dULL, 0x00000010230e7825ULL, 0x000fc800078e000eULL,
0x0000001025257824ULL, 0x000fe200078e0250ULL, 0x000000000e277faeULL, 0x0003e2000b901c46ULL,
0x0000001023107825ULL, 0x000fc800078e0010ULL, 0x0000001023127825ULL, 0x000fe200078e0012ULL,
0x0000000010257faeULL, 0x0003e6000b901c46ULL, 0x0000001021217824ULL, 0x000fe400078e0250ULL,
0x0000001023187825ULL, 0x000fc600078e0018ULL, 0x0000000012217faeULL, 0x0003e2000b901c46ULL,
0x000000103d3d7824ULL, 0x000fe400078e0250ULL, 0x0000001023087825ULL, 0x000fc600078e0008ULL,
0x00000000183d7faeULL, 0x0003e2000b901c46ULL, 0x0000001045457824ULL, 0x000fe400078e0250ULL,
0x00000010230a7825ULL, 0x000fc600078e000aULL, 0x0000000008457faeULL, 0x0003e2000b901c46ULL,
0x00000010230c7825ULL, 0x000fc600078e000cULL, 0x000000000a477faeULL, 0x0003e2000b901c46ULL,
0x0000001049497824ULL, 0x000fca00078e0250ULL, 0x000000000c497faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000a8005c207811ULL, 0x000fe400078e20ffULL,
0x00000005ff08723eULL, 0x002fe400000010ffULL, 0x00000002ff717819ULL, 0x000fe40000011600ULL,
0x0000541008707816ULL, 0x000fe40000000008ULL, 0x0000a800560c7811ULL, 0x000fc600078e20ffULL,
0x00001f7170717589ULL, 0x000fe800000e0000ULL, 0x00001f07706e7589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002020783bULL, 0x000e680000000200ULL,
0x000000005844783bULL, 0x000ea80000004200ULL, 0x000000005a4c783bULL, 0x000fe80000004200ULL,
0x000000005948783bULL, 0x000fe80000004200ULL, 0x000000005724783bULL, 0x000fe80000004200ULL,
0x000000000c0c783bULL, 0x000ee80000000200ULL, 0x00000000533c783bULL, 0x000f280000004200ULL,
0x000000005518783bULL, 0x000f680000004200ULL, 0x000000005410783bULL, 0x000f280000004200ULL,
0x000000005108783bULL, 0x000f220000004200ULL, 0x0000007120209231ULL, 0x002fc400003400ffULL,
0x0000007122229231ULL, 0x000fe400003400ffULL, 0x0000006e21219231ULL, 0x080fe400003400ffULL,
0x0000006e23239231ULL, 0x000fce00003400ffULL, 0x000000442040723cULL, 0x004fe20000041840ULL,
0x000000710c0c9231ULL, 0x008fce00003400ffULL, 0x0000004c202c723cULL, 0x000fe2000004182cULL,
0x000000710e0e9231ULL, 0x000fe400003400ffULL, 0x0000006e0d0d9231ULL, 0x080fe400003400ffULL,
0x0000006e0f0f9231ULL, 0x000fc600003400ffULL, 0x0000004e2030723cULL, 0x040ff00000041830ULL,
0x000000482034723cULL, 0x040ff00000041834ULL, 0x0000004a2038723cULL, 0x040ff00000041838ULL,
0x000000462014723cULL, 0x040ff00000041814ULL, 0x000000242028723cULL, 0x040ff00000041828ULL,
0x00000026201c723cULL, 0x000ff0000004181cULL, 0x0000003c0c40723cULL, 0x050ff00000041840ULL,
0x000000180c2c723cULL, 0x060ff0000004182cULL, 0x0000001a0c30723cULL, 0x040ff00000041830ULL,
0x000000100c34723cULL, 0x040ff00000041834ULL, 0x000000120c38723cULL, 0x040ff00000041838ULL,
0x0000003e0c3c723cULL, 0x040ff00000041814ULL, 0x000000080c28723cULL, 0x040ff00000041828ULL,
0x0000000a0c0c723cULL, 0x000fe2000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000606f00720cULL, 0x000fe20003f26070ULL, 0x01462000ffff7f8cULL, 0x000fd8000c80043fULL,
0x00003f6000001947ULL, 0x000fea0003800000ULL, 0x000000806b097810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000620006107a24ULL, 0x000fe200078e0209ULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x000fe20000011600ULL,
0x000000085f197824ULL, 0x000fe200078e0252ULL, 0x0000000960087217ULL, 0x000fe40007800000ULL,
0x0000000413157810ULL, 0x000fe40007ffe0ffULL, 0x00000200001a7802ULL, 0x000fe20000000f00ULL,
0x0000000108087824ULL, 0x000fe200078e0a09ULL, 0x00000000150a7212ULL, 0x040fe200078e3cffULL,
0x00000008150b7824ULL, 0x000fe200078e00ffULL, 0x0000000713097812ULL, 0x000fc400078e4800ULL,
0x0000002008117817ULL, 0x000fe40003800000ULL, 0xfffffff80b147812ULL, 0x000fe200078ee20aULL,
0x00000001130b7824ULL, 0x000fe200078e0210ULL, 0x0ffffff809127812ULL, 0x000fe200078ef800ULL,
0x0000000115097824ULL, 0x000fe200078e0210ULL, 0x00000008131b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e000b0a7625ULL, 0x080fe200078e001aULL, 0x0000000c131d7810ULL, 0x040fe40007ffe0ffULL,
0x000000111300720cULL, 0x080fe20003f26070ULL, 0x00005e0009087625ULL, 0x000fe200078e001aULL,
0x000000111500720cULL, 0x000fc40003f46070ULL, 0x000000001b167212ULL, 0x0c0fe200078e3cffULL,
0x000000081b1f7824ULL, 0x000fe200078e00ffULL, 0x000000001d187212ULL, 0x040fe200078e3cffULL,
0x000000081d217824ULL, 0x000fe200078e00ffULL, 0x0000006d12157211ULL, 0x000fe200078e20ffULL,
0x00000010190a7825ULL, 0x000fe200078e000aULL, 0xfffffff81f1c7812ULL, 0x000fe400078ee216ULL,
0xfffffff821187812ULL, 0x000fe200078ee218ULL, 0x0000001014177824ULL, 0x000fe200078e026dULL,
0x00000010131f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001019087825ULL, 0x000fe200078e0008ULL,
0x0000001413217810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e2000c901c46ULL, 0x0000001813237810ULL, 0x000fc40007ffe0ffULL,
0x0000001c13257810ULL, 0x000fe20007ffe0ffULL, 0x0000000008177faeULL, 0x0005e2000d101c46ULL,
0x000000111b00720cULL, 0x080fe20003f26070ULL, 0x0000000121137824ULL, 0x100fe200078e0210ULL,
0x000000111d00720cULL, 0x080fe40003f46070ULL, 0x000000111f00720cULL, 0x080fe40003f66070ULL,
0x000000112100720cULL, 0x080fe20003f86070ULL, 0x000000011d157824ULL, 0x102fe200078e0210ULL,
0x000000112300720cULL, 0x080fe20003fa6070ULL, 0x00000001250b7824ULL, 0x140fe200078e0210ULL,
0x000000112500720cULL, 0x000fe20003fc6070ULL, 0x000000011b117824ULL, 0x100fe200078e0210ULL,
0x00000000210a7212ULL, 0x080fe200078e3cffULL, 0x000000011f177824ULL, 0x104fe200078e0210ULL,
0x0000000025127212ULL, 0x080fe200078e3cffULL, 0x0000000123097824ULL, 0x000fe200078e0210ULL,
0x000000001f087212ULL, 0x080fe200078e3cffULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x0000000023107212ULL, 0x000fe200078e3cffULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x000000031f1f7819ULL, 0x000fe200000006ffULL, 0x00005e0015147625ULL, 0x000fe200078e001aULL,
0x0000000323237819ULL, 0x000fc400000006ffULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee208ULL,
0x00005e0017167625ULL, 0x080fe200078e001aULL, 0xfffffff821207812ULL, 0x000fe400078ee20aULL,
0xfffffff823227812ULL, 0x000fe200078ee210ULL, 0x00005e0011107625ULL, 0x080fe200078e001aULL,
0xfffffff825247812ULL, 0x000fe400078ee212ULL, 0x0000006d201f7211ULL, 0x000fe200078e20ffULL,
0x00005e0013127625ULL, 0x000fc800078e001aULL, 0x00005e0009087625ULL, 0x000fc800078e001aULL,
0x00005e000b0a7625ULL, 0x000fc800078e001aULL, 0x000000101c1b7824ULL, 0x000fe400078e026dULL,
0x0000001019107825ULL, 0x000fc800078e0010ULL, 0x0000001019147825ULL, 0x040fe200078e0014ULL,
0x00000000101b7faeULL, 0x0003e6000c901c46ULL, 0x0000001019167825ULL, 0x000fc800078e0016ULL,
0x0000001019127825ULL, 0x000fc800078e0012ULL, 0x0000001019087825ULL, 0x000fc800078e0008ULL,
0x00000010190a7825ULL, 0x000fc800078e000aULL, 0x0000001018197824ULL, 0x100fe400078e026dULL,
0x000000101e1d7824ULL, 0x100fe400078e026dULL, 0x0000001022217824ULL, 0x100fe200078e026dULL,
0x0000000014197faeULL, 0x0003e2000d101c46ULL, 0x0000001024237824ULL, 0x000fc600078e026dULL,
0x00000000161d7faeULL, 0x0003e8000d901c46ULL, 0x00000000121f7faeULL, 0x0003e8000e101c46ULL,
0x0000000008217faeULL, 0x0003e8000e901c46ULL, 0x000000000a237faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe20000011600ULL,
0x000000085f1d7824ULL, 0x000fc600078e0252ULL, 0x0000000409137810ULL, 0x040fe20007ffe0ffULL,
0x0000000109087824ULL, 0x140fe200078e0210ULL, 0x0000000809157810ULL, 0x040fe40007ffe0ffULL,
0x0000000c09177810ULL, 0x000fe20007ffe0ffULL, 0x00000008130b7824ULL, 0x040fe200078e00ffULL,
0x0000000013207212ULL, 0x080fe200078e3cffULL, 0x0000000815117824ULL, 0x000fe200078e00ffULL,
0x00000000171c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000117167824ULL, 0x140fe200078e0210ULL,
0x0000000317197819ULL, 0x000fe200000006ffULL, 0x0000000113127824ULL, 0x000fe200078e0210ULL,
0x00000000151e7212ULL, 0x000fc400078e3cffULL, 0xfffffff80b207812ULL, 0x000fe200078ee220ULL,
0x00000200ff0b7424ULL, 0x000fe200078e00ffULL, 0xfffffff8191c7812ULL, 0x000fe400078ee21cULL,
0xfffffff8111e7812ULL, 0x000fe400078ee21eULL, 0x0000001009197810ULL, 0x040fe40007ffe0ffULL,
0x00000014091b7810ULL, 0x040fe20007ffe0ffULL, 0x000000101e237824ULL, 0x000fe200078e026dULL,
0x00000018091f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119187824ULL, 0x000fe200078e0210ULL,
0x0000001c09217810ULL, 0x000fe20007ffe0ffULL, 0x0000000819227824ULL, 0x000fe200078e00ffULL,
0x0000000709117812ULL, 0x000fe200078e4800ULL, 0x00005e0008087625ULL, 0x000fe200078e000bULL,
0x0000001015147210ULL, 0x000fc40007ffe0ffULL, 0x0ffffff8110a7812ULL, 0x000fe200078ef800ULL,
0x000000011b247824ULL, 0x100fe200078e0210ULL, 0x0000000019117212ULL, 0x080fe200078e3cffULL,
0x000000011f447824ULL, 0x100fe200078e0210ULL, 0x000000001b137212ULL, 0x080fe200078e3cffULL,
0x0000000121487824ULL, 0x000fe200078e0210ULL, 0x000000001f107212ULL, 0x0c0fe200078e3cffULL,
0x000000081f177824ULL, 0x000fe200078e00ffULL, 0x000000031b267819ULL, 0x000fe200000006ffULL,
0x00000008214a7824ULL, 0x040fe200078e00ffULL, 0x0000000021157212ULL, 0x000fe200078e3cffULL,
0x000000101d1a7825ULL, 0x000fe200078e0008ULL, 0xfffffff822227812ULL, 0x000fc400078ee211ULL,
0xfffffff817467812ULL, 0x000fe200078ee210ULL, 0x00005e0012087625ULL, 0x080fe200078e000bULL,
0xfffffff826267812ULL, 0x000fe400078ee213ULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee215ULL,
0x00005e0014107625ULL, 0x000fe200078e000bULL, 0x0000006d0a1f7211ULL, 0x000fc600078e20ffULL,
0x00005e0016167625ULL, 0x080fe400078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a1f7faeULL, 0x0003e4000b901c46ULL, 0x00005e0018187625ULL, 0x000fc800078e000bULL,
0x00005e0024147625ULL, 0x000fc800078e000bULL, 0x00005e0044127625ULL, 0x000fe200078e000bULL,
0x0000006d261f7211ULL, 0x002fc600078e20ffULL, 0x00005e00480a7625ULL, 0x000fc800078e000bULL,
0x0000001020217824ULL, 0x000fe400078e026dULL, 0x000000101d087825ULL, 0x000fc800078e0008ULL,
0x000000101d107825ULL, 0x040fe200078e0010ULL, 0x0000000008217faeULL, 0x0003e6000b901c46ULL,
0x000000101d167825ULL, 0x040fe200078e0016ULL, 0x0000000010237faeULL, 0x0003e6000b901c46ULL,
0x000000101d187825ULL, 0x000fc800078e0018ULL, 0x000000101d147825ULL, 0x000fc800078e0014ULL,
0x000000101d127825ULL, 0x000fc800078e0012ULL, 0x000000101d0a7825ULL, 0x000fc800078e000aULL,
0x000000101c1b7824ULL, 0x100fe400078e026dULL, 0x00000010221d7824ULL, 0x100fe400078e026dULL,
0x0000001046257824ULL, 0x100fe200078e026dULL, 0x00000000161b7faeULL, 0x0003e2000b901c46ULL,
0x000000104a277824ULL, 0x000fc600078e026dULL, 0x00000000181d7faeULL, 0x0003e8000b901c46ULL,
0x00000000141f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012257faeULL, 0x0003e8000b901c46ULL,
0x000000000a277faeULL, 0x0003e4000b901c46ULL, 0x01462c00ff087984ULL, 0x002e620000000800ULL,
0x8000000069097824ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x8000000008ff7812ULL, 0x002fe40007824809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fe200078e00ffULL,
0x0000001f690a7819ULL, 0x000fc600000006ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x01462c00ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc4000782480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x014100006c097984ULL, 0x000e620000000800ULL, 0x0000b0006a207811ULL, 0x000fc600078e20ffULL,
0x014300006c6e7984ULL, 0x0004e20000000800ULL, 0x000000020900720bULL, 0x002fda0003f3d000ULL,
0x0000000000087806ULL, 0x000fc800008e0100ULL, 0x0000ffff08107812ULL, 0x000fe2000782c0ffULL,
0x00000001ff087424ULL, 0x000fd800078e00ffULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x000000020900720bULL, 0x00cfe40003f34000ULL, 0x00000009020b7209ULL, 0x000fe40007810000ULL,
0x00000002ff137819ULL, 0x000fc60000011600ULL, 0x8000000b02087221ULL, 0x040fe20000010000ULL,
0x0000000902027209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b080a7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400008e0100ULL, 0x000000025f00780cULL, 0x000fe40003f25270ULL,
0x0000000a000a7308ULL, 0x000e620000000800ULL, 0x0000ffff08117812ULL, 0x000fc800078e3cffULL,
0x0000001110ff7212ULL, 0x000fcc000784c0ffULL, 0x0145000b6c009388ULL, 0x000fe80000000800ULL,
0x00001f130a087589ULL, 0x002e6200000e0000ULL, 0x0000000a03037220ULL, 0x000fe40000410000ULL,
0x8000000b09112221ULL, 0x000fe20000010000ULL, 0x00001f070a107589ULL, 0x000ea600000e0000ULL,
0x3fb8aa3b11112820ULL, 0x000fc80000410000ULL, 0x0000001100052308ULL, 0x000ee20000000800ULL,
0x000000082c2c7220ULL, 0x082fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000838387220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x000000083c3c7220ULL, 0x080fe20000410000ULL, 0x000000083d3d7220ULL, 0x080fe20000410000ULL,
0x0000000828287220ULL, 0x080fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x000000080d0d7220ULL, 0x000fe20000410000ULL,
0x00000001ff087807ULL, 0x000fe20001000000ULL, 0x000000102e2e7220ULL, 0x084fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000103a3a7220ULL, 0x080fe20000410000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x0000001042427220ULL, 0x080fe20000410000ULL,
0x0000001043437220ULL, 0x080fe20000410000ULL, 0x000000103e3e7220ULL, 0x080fe20000410000ULL,
0x000000103f3f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000100e0e7220ULL, 0x080fe20000410000ULL,
0x000000100f0f7220ULL, 0x000fe20000410000ULL, 0x0000006e056e2220ULL, 0x008fe20000410000ULL,
0x000080400000791aULL, 0x00cfc80000000000ULL, 0x000000002020783bULL, 0x000fe20000000200ULL,
0x00000005ff09723eULL, 0x000fe200000010ffULL, 0x000000036e037221ULL, 0x000fe20000010000ULL,
0x00000002ff6f7819ULL, 0x000fe20000011600ULL, 0x00000000684c783bULL, 0x000fe20000004200ULL,
0x0000541009727816ULL, 0x000fe40000000009ULL, 0x0000b00064097811ULL, 0x000fe200078e20ffULL,
0x000000006644783bULL, 0x000fe20000004200ULL, 0x0000991008107816ULL, 0x000fc600000000ffULL,
0x000000006748783bULL, 0x000fe20000004200ULL, 0x000000ff1000720cULL, 0x000fc60003f25270ULL,
0x000000006524783bULL, 0x000fe80000004200ULL, 0x00001f6f726f7589ULL, 0x000e6800000e0000ULL,
0x00001f0772707589ULL, 0x000ea800000e0000ULL, 0x000000000908783bULL, 0x000ee80000000200ULL,
0x00000000631c783bULL, 0x000f280000004200ULL, 0x000000005e14783bULL, 0x000f680000004200ULL,
0x000000006218783bULL, 0x000f280000004200ULL, 0x000000005b10783bULL, 0x000f220000004200ULL,
0x0000006f20209231ULL, 0x002fc400003400ffULL, 0x0000006f22229231ULL, 0x000fe400003400ffULL,
0x0000007021219231ULL, 0x084fe400003400ffULL, 0x0000007023239231ULL, 0x000fce00003400ffULL,
0x0000004c202c723cULL, 0x040ff0000004182cULL, 0x0000004e2030723cULL, 0x000fe20000041830ULL,
0x0000006f08089231ULL, 0x088fe400003400ffULL, 0x0000006f0a0a9231ULL, 0x000fe200003400ffULL,
0x000000a06b6f7810ULL, 0x000fe20007ffe0ffULL, 0x0000007009099231ULL, 0x000fc600003400ffULL,
0x000000442040723cULL, 0x000fe20000041840ULL, 0x000000700b0b9231ULL, 0x000fce00003400ffULL,
0x000000482034723cULL, 0x040ff00000041834ULL, 0x0000004a2038723cULL, 0x040ff00000041838ULL,
0x00000046203c723cULL, 0x040ff0000004183cULL, 0x000000242028723cULL, 0x040ff00000041828ULL,
0x00000026200c723cULL, 0x000ff0000004180cULL, 0x0000001c082c723cULL, 0x050ff0000004182cULL,
0x0000001e0830723cULL, 0x040ff00000041830ULL, 0x000000140840723cULL, 0x060ff00000041840ULL,
0x000000180834723cULL, 0x040ff00000041834ULL, 0x0000001a0838723cULL, 0x040ff00000041838ULL,
0x000000160814723cULL, 0x040ff0000004183cULL, 0x000000100828723cULL, 0x040ff00000041828ULL,
0x00000012081c723cULL, 0x000fee000004180cULL, 0x00006200060e7a24ULL, 0x000fe200078e026fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000058000008947ULL, 0x000fea0003800000ULL,
0x00000003ff117819ULL, 0x000fe20000011600ULL, 0x00000200ff127424ULL, 0x000fe400078e00ffULL,
0x000000085f1b7824ULL, 0x000fe200078e0252ULL, 0x00000004110d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001110b7824ULL, 0x040fe200078e020eULL, 0x0000000811257810ULL, 0x000fe40007ffe0ffULL,
0x000000000d087212ULL, 0x0c0fe200078e3cffULL, 0x000000080d237824ULL, 0x000fe200078e00ffULL,
0x0000000025097212ULL, 0x040fe200078e3cffULL, 0x00000008250a7824ULL, 0x000fe200078e00ffULL,
0x0000000c113d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe400078ee208ULL,
0x0000006f60087217ULL, 0x000fe20007800000ULL, 0x000000083d0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a277812ULL, 0x000fe200078ee209ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0012ULL,
0x0000000711097812ULL, 0x040fe400078e4800ULL, 0x00000010113f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a6fULL, 0x000000003d137212ULL, 0x000fe200078e3cffULL,
0x000000101b0a7825ULL, 0x000fe200078e000aULL, 0x0ffffff809217812ULL, 0x000fc400078ef800ULL,
0x00000020080f7817ULL, 0x000fe20003800000ULL, 0x0000000125097824ULL, 0x000fe200078e020eULL,
0x0000001411457810ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x100fe200078e0250ULL,
0x0000000f0d00720cULL, 0x080fe20003f66070ULL, 0x00005e0009087625ULL, 0x000fe200078e0012ULL,
0x0000000e0d0d7210ULL, 0x000fe40007ffe0ffULL, 0x0000000f1100720cULL, 0x000fe20003f46070ULL,
0x0000001023237824ULL, 0x000fe200078e0250ULL, 0x000000003f197212ULL, 0x000fe200078e3cffULL,
0x000000101b087825ULL, 0x000fe200078e0008ULL, 0x000000033f107819ULL, 0x000fc400000006ffULL,
0xfffffff80c137812ULL, 0x000fe200078ee213ULL, 0x00005e000d0c7625ULL, 0x000fe200078e0012ULL,
0x0000000f2500720cULL, 0x080fe40003f86070ULL, 0xfffffff810197812ULL, 0x000fe200078ee219ULL,
0x0000000845257824ULL, 0x000fe200078e00ffULL, 0x0000001811477810ULL, 0x000fe20007ffe0ffULL,
0x000000101b0c7825ULL, 0x000fe200078e000cULL, 0x0000000045107212ULL, 0x000fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a217faeULL, 0x0003e2000d101c46ULL,
0x0000001c11497810ULL, 0x000fe20007ffe0ffULL, 0x0000000847117824ULL, 0x000fe200078e00ffULL,
0x0000005027277211ULL, 0x000fe200078e20ffULL, 0x000000000c237faeULL, 0x0005e2000d901c46ULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x0000001013137824ULL, 0x100fe200078e0250ULL,
0x0000000047107212ULL, 0x000fe200078e3cffULL, 0x0000000008277faeULL, 0x0007e2000e101c46ULL,
0x0000000f3d00720cULL, 0x080fe20003f46070ULL, 0x0000001019197824ULL, 0x000fe200078e0250ULL,
0x0000000f3f00720cULL, 0x000fc40003f66070ULL, 0xfffffff811217812ULL, 0x002fe200078ee210ULL,
0x000000013f117824ULL, 0x100fe200078e020eULL, 0x0000000f4500720cULL, 0x080fe20003f86070ULL,
0x000000013d0d7824ULL, 0x104fe200078e020eULL, 0x0000000f4700720cULL, 0x080fe20003fa6070ULL,
0x0000000849237824ULL, 0x040fe200078e00ffULL, 0x0000000f4900720cULL, 0x000fe20003fc6070ULL,
0x00000001450f7824ULL, 0x100fe200078e020eULL, 0x0000000e470b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000149097824ULL, 0x048fe200078e020eULL, 0x0000000049187212ULL, 0x000fe200078e3cffULL,
0x00005e000d0c7625ULL, 0x000fe200078e0012ULL, 0x0000005025257211ULL, 0x000fc400078e20ffULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x00005e0011107625ULL, 0x000fc800078e0012ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0012ULL, 0x00005e000b0a7625ULL, 0x000fc800078e0012ULL,
0x00005e0009087625ULL, 0x000fc800078e0012ULL, 0x000000101b0c7825ULL, 0x000fc800078e000cULL,
0x000000101b107825ULL, 0x040fe200078e0010ULL, 0x000000000c137faeULL, 0x0003e6000d101c46ULL,
0x000000101b0e7825ULL, 0x040fe200078e000eULL, 0x0000000010197faeULL, 0x0003e6000d901c46ULL,
0x000000101b0a7825ULL, 0x000fe200078e000aULL, 0x000000000e257faeULL, 0x0003e6000e101c46ULL,
0x0000001021217824ULL, 0x000fc400078e0250ULL, 0x000000101b087825ULL, 0x000fc600078e0008ULL,
0x000000000a217faeULL, 0x0003e2000e901c46ULL, 0x0000001023237824ULL, 0x000fca00078e0250ULL,
0x0000000008237faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe20000011600ULL, 0x00000200ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000085f237824ULL, 0x000fe200078e0252ULL, 0x00000004090f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000809117810ULL, 0x040fe40007ffe0ffULL, 0x0000000c09137810ULL, 0x000fe20007ffe0ffULL,
0x000000080f087824ULL, 0x040fe200078e00ffULL, 0x000000000f277212ULL, 0x080fe200078e3cffULL,
0x00000008110a7824ULL, 0x040fe200078e00ffULL, 0x0000000011257212ULL, 0x080fe200078e3cffULL,
0x0000000113127824ULL, 0x040fe200078e020eULL, 0x0000000013217212ULL, 0x000fc400078e3cffULL,
0x00000003130c7819ULL, 0x000fe200000006ffULL, 0x00005e0012127625ULL, 0x080fe200078e000dULL,
0x0000001009197810ULL, 0x040fe40007ffe0ffULL, 0x00000014091b7810ULL, 0x040fe40007ffe0ffULL,
0x00000018093f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119187824ULL, 0x100fe200078e020eULL,
0x0000001c09457810ULL, 0x000fe20007ffe0ffULL, 0x0000000819247824ULL, 0x000fe200078e00ffULL,
0xfffffff808277812ULL, 0x000fe200078ee227ULL, 0x0000000109087824ULL, 0x100fe200078e020eULL,
0xfffffff80a257812ULL, 0x000fe200078ee225ULL, 0x000000010f0a7824ULL, 0x100fe200078e020eULL,
0xfffffff80c217812ULL, 0x000fe200078ee221ULL, 0x000000011b0c7824ULL, 0x100fe200078e020eULL,
0x0000000e11107210ULL, 0x000fe20007ffe0ffULL, 0x000000013f207824ULL, 0x100fe200078e020eULL,
0x000000001b0f7212ULL, 0x080fe200078e3cffULL, 0x0000000145227824ULL, 0x000fe200078e020eULL,
0x000000031b267819ULL, 0x000fe200000006ffULL, 0x000000083f477824ULL, 0x040fe200078e00ffULL,
0x000000003f0e7212ULL, 0x080fe200078e3cffULL, 0x00000008453c7824ULL, 0x000fe200078e00ffULL,
0x00000007090b7812ULL, 0x000fe200078e4800ULL, 0x00005e0008087625ULL, 0x000fe200078e000dULL,
0x0000000045117212ULL, 0x000fc400078e3cffULL, 0xfffffff826457812ULL, 0x000fe200078ee20fULL,
0x0000001027277824ULL, 0x000fe200078e0250ULL, 0xfffffff847477812ULL, 0x000fe200078ee20eULL,
0x00005e000a0e7625ULL, 0x080fe200078e000dULL, 0x0ffffff80b0b7812ULL, 0x000fe400078ef800ULL,
0x00000000193d7212ULL, 0x000fe200078e3cffULL, 0x00000010231a7825ULL, 0x000fe200078e0008ULL,
0xfffffff83c497812ULL, 0x000fe400078ee211ULL, 0x000000500b3f7211ULL, 0x000fe200078e20ffULL,
0x00005e0010107625ULL, 0x000fe200078e000dULL, 0xfffffff8243d7812ULL, 0x000fc400078ee23dULL,
0x0000005045457211ULL, 0x000fe200078e20ffULL, 0x00005e0018187625ULL, 0x080fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a3f7faeULL, 0x0003e6000b901c46ULL,
0x00005e000c087625ULL, 0x000fc800078e000dULL, 0x00005e00200a7625ULL, 0x000fc800078e000dULL,
0x00005e00220c7625ULL, 0x000fc800078e000dULL, 0x00000010230e7825ULL, 0x000fc800078e000eULL,
0x0000001025257824ULL, 0x000fe200078e0250ULL, 0x000000000e277faeULL, 0x0003e2000b901c46ULL,
0x0000001023107825ULL, 0x000fc800078e0010ULL, 0x0000001023127825ULL, 0x000fe200078e0012ULL,
0x0000000010257faeULL, 0x0003e6000b901c46ULL, 0x0000001021217824ULL, 0x000fe400078e0250ULL,
0x0000001023187825ULL, 0x000fc600078e0018ULL, 0x0000000012217faeULL, 0x0003e2000b901c46ULL,
0x000000103d3d7824ULL, 0x000fe400078e0250ULL, 0x0000001023087825ULL, 0x000fc600078e0008ULL,
0x00000000183d7faeULL, 0x0003e2000b901c46ULL, 0x00000010230a7825ULL, 0x000fc600078e000aULL,
0x0000000008457faeULL, 0x0003e2000b901c46ULL, 0x0000001047477824ULL, 0x000fe400078e0250ULL,
0x00000010230c7825ULL, 0x000fc600078e000cULL, 0x000000000a477faeULL, 0x0003e2000b901c46ULL,
0x0000001049497824ULL, 0x000fca00078e0250ULL, 0x000000000c497faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000b0005c207811ULL, 0x000fe400078e20ffULL,
0x00000005ff08723eULL, 0x002fe400000010ffULL, 0x00000002ff717819ULL, 0x000fe40000011600ULL,
0x0000541008707816ULL, 0x000fe40000000008ULL, 0x0000b000560c7811ULL, 0x000fc600078e20ffULL,
0x00001f7170717589ULL, 0x000fe800000e0000ULL, 0x00001f07706e7589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002020783bULL, 0x000e680000000200ULL,
0x000000005844783bULL, 0x000ea80000004200ULL, 0x000000005a4c783bULL, 0x000fe80000004200ULL,
0x000000005948783bULL, 0x000fe80000004200ULL, 0x000000005724783bULL, 0x000fe80000004200ULL,
0x000000000c0c783bULL, 0x000ee80000000200ULL, 0x00000000533c783bULL, 0x000f280000004200ULL,
0x000000005518783bULL, 0x000f680000004200ULL, 0x000000005410783bULL, 0x000f280000004200ULL,
0x000000005108783bULL, 0x000f220000004200ULL, 0x0000007120209231ULL, 0x002fc400003400ffULL,
0x0000007122229231ULL, 0x000fe400003400ffULL, 0x0000006e21219231ULL, 0x080fe400003400ffULL,
0x0000006e23239231ULL, 0x000fce00003400ffULL, 0x000000442040723cULL, 0x004fe20000041840ULL,
0x000000710c0c9231ULL, 0x008fce00003400ffULL, 0x0000004c202c723cULL, 0x000fe2000004182cULL,
0x000000710e0e9231ULL, 0x000fe400003400ffULL, 0x0000006e0d0d9231ULL, 0x080fe400003400ffULL,
0x0000006e0f0f9231ULL, 0x000fc600003400ffULL, 0x0000004e2030723cULL, 0x040ff00000041830ULL,
0x000000482034723cULL, 0x040ff00000041834ULL, 0x0000004a2038723cULL, 0x040ff00000041838ULL,
0x000000462014723cULL, 0x040ff00000041814ULL, 0x000000242028723cULL, 0x040ff00000041828ULL,
0x00000026201c723cULL, 0x000ff0000004181cULL, 0x0000003c0c40723cULL, 0x050ff00000041840ULL,
0x000000180c2c723cULL, 0x060ff0000004182cULL, 0x0000001a0c30723cULL, 0x040ff00000041830ULL,
0x000000100c34723cULL, 0x040ff00000041834ULL, 0x000000120c38723cULL, 0x040ff00000041838ULL,
0x0000003e0c3c723cULL, 0x040ff00000041814ULL, 0x000000080c28723cULL, 0x040ff00000041828ULL,
0x0000000a0c0c723cULL, 0x000fe2000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000606f00720cULL, 0x000fe20003f26070ULL, 0x01463000ffff7f8cULL, 0x000fd8000c80043fULL,
0x00001fc000001947ULL, 0x000fea0003800000ULL, 0x000000c06b6b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00006200060a7a24ULL, 0x000fe200078e026bULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x0000006b60087217ULL, 0x000fe20007800000ULL,
0x000000085f1b7824ULL, 0x000fe200078e0252ULL, 0x00000003ff117819ULL, 0x100fe40000011600ULL,
0x00000200000b7802ULL, 0x000fe20000000f00ULL, 0x0000000108087824ULL, 0x000fe200078e0a6bULL,
0x0000000711097812ULL, 0x040fe200078e4800ULL, 0x0000000111127824ULL, 0x040fe200078e020aULL,
0x0000000411157810ULL, 0x000fe40007ffe0ffULL, 0x0000002008107817ULL, 0x000fc40003800000ULL,
0x0000000811177810ULL, 0x000fe20007ffe0ffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0x0000000c11197810ULL, 0x040fe40007ffe0ffULL, 0x000000101100720cULL, 0x000fe20003f06070ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x0ffffff809147812ULL, 0x000fe200078ef800ULL,
0x00005e0012087625ULL, 0x000fe200078e000bULL, 0x00000000151a7212ULL, 0x080fe400078e3cffULL,
0x00000000171e7212ULL, 0x080fe200078e3cffULL, 0x0000000819217824ULL, 0x040fe200078e00ffULL,
0x00000000191c7212ULL, 0x000fe200078e3cffULL, 0x000000101b087825ULL, 0x000fe200078e0008ULL,
0x0000006d14137211ULL, 0x000fc400078e20ffULL, 0xfffffff81d1a7812ULL, 0x000fe200078ee21aULL,
0x0000000117127824ULL, 0x000fe200078e020aULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee21eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008137faeULL, 0x0003e2000c101c46ULL,
0xfffffff8211c7812ULL, 0x000fe200078ee21cULL, 0x0000000119167824ULL, 0x100fe200078e020aULL,
0x00000010111d7810ULL, 0x040fe40007ffe0ffULL, 0x00000014111f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001811217810ULL, 0x000fe20007ffe0ffULL, 0x000000011d187824ULL, 0x100fe200078e020aULL,
0x0000001c11237810ULL, 0x000fe20007ffe0ffULL, 0x000000081f227824ULL, 0x000fe200078e00ffULL,
0x000000101500720cULL, 0x080fe20003f06070ULL, 0x000000011f147824ULL, 0x100fe200078e020aULL,
0x000000101700720cULL, 0x080fe20003f26070ULL, 0x0000000823267824ULL, 0x000fe200078e00ffULL,
0x000000101900720cULL, 0x080fe20003f46070ULL, 0x0000000121087824ULL, 0x002fe200078e020aULL,
0x000000101d00720cULL, 0x080fe20003f66070ULL, 0x00005e0016167625ULL, 0x000fe200078e000bULL,
0x000000101f00720cULL, 0x000fc40003f86070ULL, 0x000000102100720cULL, 0x080fe20003fa6070ULL,
0x00005e0018187625ULL, 0x000fe200078e000bULL, 0x000000102300720cULL, 0x000fe40003fc6070ULL,
0x000000001d097212ULL, 0x080fe200078e3cffULL, 0x0000000115107824ULL, 0x100fe200078e020aULL,
0x000000031d207819ULL, 0x000fe200000006ffULL, 0x00000001230a7824ULL, 0x000fe200078e020aULL,
0x000000001f117212ULL, 0x080fe200078e3cffULL, 0x000000101b167825ULL, 0x000fe200078e0016ULL,
0x0000000021137212ULL, 0x000fc400078e3cffULL, 0x0000000321247819ULL, 0x000fe200000006ffULL,
0x000000101b187825ULL, 0x000fe200078e0018ULL, 0x0000000023157212ULL, 0x000fe400078e3cffULL,
0xfffffff820207812ULL, 0x000fe200078ee209ULL, 0x00005e0008087625ULL, 0x080fe200078e000bULL,
0xfffffff822227812ULL, 0x000fe400078ee211ULL, 0xfffffff824247812ULL, 0x000fe200078ee213ULL,
0x00005e0010107625ULL, 0x000fe200078e000bULL, 0xfffffff826267812ULL, 0x000fc400078ee215ULL,
0x0000006d20217211ULL, 0x000fe200078e20ffULL, 0x00005e0012127625ULL, 0x000fc800078e000bULL,
0x00005e0014147625ULL, 0x000fc800078e000bULL, 0x00005e000a0a7625ULL, 0x000fc800078e000bULL,
0x000000101b107825ULL, 0x000fc800078e0010ULL, 0x000000101b127825ULL, 0x000fc800078e0012ULL,
0x000000101b147825ULL, 0x000fc800078e0014ULL, 0x000000101b087825ULL, 0x000fc800078e0008ULL,
0x000000101b0a7825ULL, 0x000fc800078e000aULL, 0x000000101a1b7824ULL, 0x100fe400078e026dULL,
0x000000101e1d7824ULL, 0x100fe400078e026dULL, 0x000000101c1f7824ULL, 0x100fe200078e026dULL,
0x00000000101b7faeULL, 0x0003e2000c101c46ULL, 0x0000001022237824ULL, 0x100fe400078e026dULL,
0x0000001024257824ULL, 0x100fe200078e026dULL, 0x00000000121d7faeULL, 0x0003e2000c901c46ULL,
0x00000010266d7824ULL, 0x000fc600078e026dULL, 0x00000000161f7faeULL, 0x0003e8000d101c46ULL,
0x0000000018217faeULL, 0x0003e8000d901c46ULL, 0x0000000014237faeULL, 0x0003e8000e101c46ULL,
0x0000000008257faeULL, 0x0003e8000e901c46ULL, 0x000000000a6d7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe20000011600ULL,
0x000000085f1d7824ULL, 0x000fc600078e0252ULL, 0x0000000c09177810ULL, 0x040fe20007ffe0ffULL,
0x0000000109087824ULL, 0x140fe200078e020aULL, 0x0000000409137810ULL, 0x040fe40007ffe0ffULL,
0x0000000809157810ULL, 0x000fe20007ffe0ffULL, 0x0000000817197824ULL, 0x040fe200078e00ffULL,
0x00000000171e7212ULL, 0x080fe200078e3cffULL, 0x00000008130b7824ULL, 0x000fe200078e00ffULL,
0x0000000015207212ULL, 0x080fe200078e3cffULL, 0x0000000117167824ULL, 0x100fe200078e020aULL,
0x0000000315117819ULL, 0x040fe200000006ffULL, 0x0000000115147824ULL, 0x000fe200078e020aULL,
0x00000000131c7212ULL, 0x000fc400078e3cffULL, 0xfffffff8191e7812ULL, 0x000fe400078ee21eULL,
0xfffffff811207812ULL, 0x000fe400078ee220ULL, 0x0000001009197810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80b1c7812ULL, 0x000fe200078ee21cULL, 0x00000200ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000709117812ULL, 0x000fe200078e4800ULL, 0x0000000819227824ULL, 0x000fe200078e00ffULL,
0x00000014091b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119187824ULL, 0x000fe200078e020aULL,
0x00000018091f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c09217810ULL, 0x000fe20007ffe0ffULL,
0x000000081b267824ULL, 0x000fe200078e00ffULL, 0x0ffffff811107812ULL, 0x000fe200078ef800ULL,
0x00005e0008087625ULL, 0x000fe200078e000bULL, 0x0000000a13127210ULL, 0x000fe40007ffe0ffULL,
0x0000000019117212ULL, 0x000fe200078e3cffULL, 0x000000011f447824ULL, 0x100fe200078e020aULL,
0x0000000a1b247210ULL, 0x000fe20007ffe0ffULL, 0x0000000121487824ULL, 0x000fe200078e020aULL,
0x000000001b137212ULL, 0x080fe200078e3cffULL, 0x000000081f177824ULL, 0x040fe200078e00ffULL,
0x000000001f0a7212ULL, 0x080fe200078e3cffULL, 0x00000010101f7824ULL, 0x000fe200078e026dULL,
0x0000000021157212ULL, 0x000fe200078e3cffULL, 0x000000101d1a7825ULL, 0x000fe200078e0008ULL,
0x00000003214a7819ULL, 0x000fc400000006ffULL, 0xfffffff822227812ULL, 0x000fe200078ee211ULL,
0x00005e0012107625ULL, 0x080fe200078e000bULL, 0xfffffff826267812ULL, 0x000fe200078ee213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1f7faeULL, 0x0003e2000b901c46ULL,
0xfffffff817467812ULL, 0x000fe200078ee20aULL, 0x00005e0014127625ULL, 0x000fe200078e000bULL,
0xfffffff84a4a7812ULL, 0x000fe400078ee215ULL, 0x0000006d22217211ULL, 0x000fe200078e20ffULL,
0x00005e0016167625ULL, 0x000fc800078e000bULL, 0x00005e0018187625ULL, 0x000fc800078e000bULL,
0x00005e0024147625ULL, 0x000fc800078e000bULL, 0x00005e0044087625ULL, 0x000fc800078e000bULL,
0x00005e00480a7625ULL, 0x000fc800078e000bULL, 0x000000101d107825ULL, 0x000fc800078e0010ULL,
0x000000101d127825ULL, 0x000fc800078e0012ULL, 0x000000101d167825ULL, 0x000fc800078e0016ULL,
0x000000101d187825ULL, 0x000fc800078e0018ULL, 0x000000101d147825ULL, 0x000fc800078e0014ULL,
0x000000101d087825ULL, 0x000fc800078e0008ULL, 0x000000101d0a7825ULL, 0x000fc800078e000aULL,
0x000000101c1b7824ULL, 0x102fe400078e026dULL, 0x00000010201d7824ULL, 0x100fe400078e026dULL,
0x000000101e1f7824ULL, 0x100fe200078e026dULL, 0x00000000101b7faeULL, 0x0003e2000b901c46ULL,
0x0000001026237824ULL, 0x100fe400078e026dULL, 0x0000001046257824ULL, 0x100fe200078e026dULL,
0x00000000121d7faeULL, 0x0003e2000b901c46ULL, 0x000000104a6d7824ULL, 0x000fc600078e026dULL,
0x00000000161f7faeULL, 0x0003e8000b901c46ULL, 0x0000000018217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000008257faeULL, 0x0003e8000b901c46ULL,
0x000000000a6d7faeULL, 0x0003e4000b901c46ULL, 0x01463c00ff087984ULL, 0x002e620000000800ULL,
0x8000000069097824ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x8000000008ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x0000001f690a7819ULL, 0x000fe200000006ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x01463c00ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x014180006c097984ULL, 0x000e620000000800ULL, 0x0000b8006a207811ULL, 0x000fc600078e20ffULL,
0x014380006c6a7984ULL, 0x0004e20000000800ULL, 0x000000020900720bULL, 0x002fda0003f1d000ULL,
0x0000000000087806ULL, 0x000fc800000e0100ULL, 0x0000ffff08107812ULL, 0x000fe2000780c0ffULL,
0x00000001ff087424ULL, 0x000fd800078e00ffULL, 0x0000034000008947ULL, 0x000fea0003800000ULL,
0x000000020900720bULL, 0x00cfe40003f14000ULL, 0x00000009020b7209ULL, 0x000fe40007810000ULL,
0x00000002ff137819ULL, 0x000fc60000011600ULL, 0x8000000b02087221ULL, 0x040fe20000010000ULL,
0x0000000902027209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b080a7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400000e0100ULL, 0x000000035f00780cULL, 0x000fe40003f05270ULL,
0x0000000a000a7308ULL, 0x000e620000000800ULL, 0x0000ffff08117812ULL, 0x000fc800078e3cffULL,
0x0000001110ff7212ULL, 0x000fcc000782c0ffULL, 0x0145800b6c008388ULL, 0x000fe80000000800ULL,
0x00001f130a087589ULL, 0x002e6200000e0000ULL, 0x0000000a03037220ULL, 0x000fe40000410000ULL,
0x8000000b09111221ULL, 0x000fe20000010000ULL, 0x00001f070a107589ULL, 0x000ea600000e0000ULL,
0x3fb8aa3b11111820ULL, 0x000fc80000410000ULL, 0x0000001100051308ULL, 0x000ee20000000800ULL,
0x000000082c2c7220ULL, 0x082fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000838387220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x000000083c3c7220ULL, 0x080fe20000410000ULL, 0x000000083d3d7220ULL, 0x080fe20000410000ULL,
0x0000000828287220ULL, 0x080fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000080c0c7220ULL, 0x080fe20000410000ULL, 0x000000080d0d7220ULL, 0x000fe20000410000ULL,
0x00000001ff087807ULL, 0x000fe20000800000ULL, 0x000000102e2e7220ULL, 0x084fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000103a3a7220ULL, 0x080fe20000410000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x0000001042427220ULL, 0x080fe20000410000ULL,
0x0000001043437220ULL, 0x080fe20000410000ULL, 0x000000103e3e7220ULL, 0x080fe20000410000ULL,
0x000000103f3f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000100e0e7220ULL, 0x080fe20000410000ULL,
0x000000100f0f7220ULL, 0x000fe20000410000ULL, 0x0000006a056a1220ULL, 0x008fe20000410000ULL,
0x000080400000791aULL, 0x00cfc80000000000ULL, 0x000000002020783bULL, 0x000fe20000000200ULL,
0x00000005ff09723eULL, 0x000fe200000010ffULL, 0x000000036a037221ULL, 0x000fe20000010000ULL,
0x00000002ff697819ULL, 0x000fe20000011600ULL, 0x00000000684c783bULL, 0x0003e20000004200ULL,
0x0000991008107816ULL, 0x000fc600000000ffULL, 0x000000006644783bULL, 0x000fe20000004200ULL,
0x000000ff1000720cULL, 0x000fc60003f05270ULL, 0x000000006748783bULL, 0x000fe20000004200ULL,
0x0000541009687816ULL, 0x002fe40000000009ULL, 0x0000b80064097811ULL, 0x000fe200078e20ffULL,
0x000000006524783bULL, 0x000fe80000004200ULL, 0x00001f6968697589ULL, 0x000e6800000e0000ULL,
0x00001f0768647589ULL, 0x000ea800000e0000ULL, 0x000000000908783bULL, 0x000ee80000000200ULL,
0x00000000631c783bULL, 0x000f280000004200ULL, 0x000000005e14783bULL, 0x000f680000004200ULL,
0x000000006218783bULL, 0x000f280000004200ULL, 0x000000005b10783bULL, 0x000f220000004200ULL,
0x0000006920208231ULL, 0x002fc400003400ffULL, 0x0000006922228231ULL, 0x000fe400003400ffULL,
0x0000006421218231ULL, 0x084fe400003400ffULL, 0x0000006423238231ULL, 0x000fce00003400ffULL,
0x0000004c202c723cULL, 0x040ff0000004182cULL, 0x0000004e2030723cULL, 0x000fe20000041830ULL,
0x0000006908088231ULL, 0x088fe400003400ffULL, 0x000000690a0a8231ULL, 0x000fc400003400ffULL,
0x0000006409098231ULL, 0x000fc600003400ffULL, 0x000000442040723cULL, 0x000fe20000041840ULL,
0x000000640b0b8231ULL, 0x000fce00003400ffULL, 0x000000482034723cULL, 0x040ff00000041834ULL,
0x0000004a2038723cULL, 0x040ff00000041838ULL, 0x00000046203c723cULL, 0x040ff0000004183cULL,
0x000000242028723cULL, 0x040ff00000041828ULL, 0x00000026200c723cULL, 0x000ff0000004180cULL,
0x0000001c082c723cULL, 0x050ff0000004182cULL, 0x0000001e0830723cULL, 0x040ff00000041830ULL,
0x000000140840723cULL, 0x060ff00000041840ULL, 0x000000180834723cULL, 0x040ff00000041834ULL,
0x0000001a0838723cULL, 0x040ff00000041838ULL, 0x000000160814723cULL, 0x040ff0000004183cULL,
0x000000100828723cULL, 0x040ff00000041828ULL, 0x00000012081c723cULL, 0x000fee000004180cULL,
0x0000030061087a10ULL, 0x000fc80007ffe0ffULL, 0x00000001080a7810ULL, 0x040fe20007ffe0ffULL,
0x00000100080b7824ULL, 0x000fc600078e00ffULL, 0x0000005d0a00720cULL, 0x000fe20003f26070ULL,
0x0000620006087a24ULL, 0x000fe200078e020bULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000058000009947ULL, 0x000fea0003800000ULL, 0x00000003ff0f7819ULL, 0x000fe20000011600ULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x0000000b60097217ULL, 0x000fe20007800000ULL,
0x000000085f527824ULL, 0x000fe200078e0252ULL, 0x000000040f0d7810ULL, 0x000fe40007ffe0ffULL,
0x000000090b097210ULL, 0x000fe40007ffe1ffULL, 0x000000000d0a7212ULL, 0x040fe200078e3cffULL,
0x000000080d197824ULL, 0x000fe200078e00ffULL, 0x0000002009097817ULL, 0x000fe20003800000ULL,
0x000000010d0c7824ULL, 0x000fe200078e0208ULL, 0x000000070f0b7812ULL, 0x000fc400078e4800ULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x000000010f0a7824ULL, 0x040fe200078e0208ULL,
0x000000090f00720cULL, 0x000fe40003f26070ULL, 0x0ffffff80b117812ULL, 0x000fe200078ef800ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0013ULL, 0x000000090d00720cULL, 0x000fe40003f46070ULL,
0x0000000c0f237810ULL, 0x040fe20007ffe0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0013ULL,
0x000000080f1b7810ULL, 0x000fc40007ffe0ffULL, 0x000000100f277810ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e0250ULL, 0x000000140f3d7810ULL, 0x040fe20007ffe0ffULL,
0x00000010520a7825ULL, 0x040fe200078e000aULL, 0x000000180f3f7810ULL, 0x000fe40007ffe0ffULL,
0x000000001b0e7212ULL, 0x080fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0250ULL,
0x000000031b217819ULL, 0x000fe200000006ffULL, 0x00000010520c7825ULL, 0x000fe200078e000cULL,
0x0000000023107212ULL, 0x000fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a117faeULL, 0x0003e2000c901c46ULL, 0x0000001c0f0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20eULL,
0x000000000c197faeULL, 0x0005e2000d101c46ULL, 0x000000091b00720cULL, 0x080fe20003f26070ULL,
0x000000013d0e7824ULL, 0x000fe200078e0208ULL, 0xfffffff825257812ULL, 0x000fe200078ee210ULL,
0x000000010f127824ULL, 0x100fe200078e0208ULL, 0x000000092300720cULL, 0x080fe20003f46070ULL,
0x0000000827187824ULL, 0x040fe200078e00ffULL, 0x000000092700720cULL, 0x080fe20003f66070ULL,
0x000000083d1a7824ULL, 0x040fe200078e00ffULL, 0x000000093d00720cULL, 0x080fe20003f86070ULL,
0x000000080f207824ULL, 0x000fe200078e00ffULL, 0x000000093f00720cULL, 0x080fe20003fa6070ULL,
0x00000001270c7824ULL, 0x104fe200078e0208ULL, 0x000000090f00720cULL, 0x000fe20003fc6070ULL,
0x000000011b097824ULL, 0x000fe200078e0208ULL, 0x00000008230a7210ULL, 0x082fe20007ffe0ffULL,
0x000000083f237824ULL, 0x040fe200078e00ffULL, 0x000000083f107210ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e0250ULL, 0x000000003f087212ULL, 0x000fc400078e3cffULL,
0x00000000270b7212ULL, 0x080fe400078e3cffULL, 0x000000003d0d7212ULL, 0x080fe400078e3cffULL,
0x000000000f117212ULL, 0x000fe200078e3cffULL, 0x00005e000e0e7625ULL, 0x080fe200078e0013ULL,
0xfffffff823237812ULL, 0x000fe400078ee208ULL, 0xfffffff818197812ULL, 0x000fe200078ee20bULL,
0x00005e0009087625ULL, 0x000fe200078e0013ULL, 0xfffffff81a1b7812ULL, 0x000fc400078ee20dULL,
0xfffffff820277812ULL, 0x000fe200078ee211ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0013ULL,
0x0000005025257211ULL, 0x000fc600078e20ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e0013ULL,
0x00005e0010107625ULL, 0x000fc800078e0013ULL, 0x00005e0012127625ULL, 0x000fc800078e0013ULL,
0x0000001052087825ULL, 0x000fc800078e0008ULL, 0x00000010520a7825ULL, 0x040fe200078e000aULL,
0x0000000008217faeULL, 0x0003e6000c901c46ULL, 0x00000010520c7825ULL, 0x040fe200078e000cULL,
0x000000000a257faeULL, 0x0003e6000d101c46ULL, 0x0000001019197824ULL, 0x000fe400078e0250ULL,
0x00000010520e7825ULL, 0x000fc600078e000eULL, 0x000000000c197faeULL, 0x0003e2000d901c46ULL,
0x000000101b1b7824ULL, 0x000fe400078e0250ULL, 0x0000001052107825ULL, 0x000fc600078e0010ULL,
0x000000000e1b7faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fe400078e0250ULL,
0x0000001052127825ULL, 0x000fc600078e0012ULL, 0x0000000010237faeULL, 0x0003e2000e901c46ULL,
0x0000001027277824ULL, 0x000fca00078e0250ULL, 0x0000000012277faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe20000011600ULL,
0x00000200ff257424ULL, 0x000fe400078e00ffULL, 0x000000085f277824ULL, 0x000fe200078e0252ULL,
0x0000000c091b7810ULL, 0x040fe40007ffe0ffULL, 0x00000008090f7810ULL, 0x040fe40007ffe0ffULL,
0x00000004090d7810ULL, 0x000fe20007ffe0ffULL, 0x000000081b0e7824ULL, 0x040fe200078e00ffULL,
0x000000001b197212ULL, 0x080fe200078e3cffULL, 0x000000080f0c7824ULL, 0x000fe200078e00ffULL,
0x000000000d117212ULL, 0x000fe200078e3cffULL, 0x000000011b107824ULL, 0x000fe200078e0208ULL,
0x000000030d0a7819ULL, 0x000fc400000006ffULL, 0x000000000f137212ULL, 0x000fe400078e3cffULL,
0x0000001009217810ULL, 0x040fe40007ffe0ffULL, 0x0000001409237810ULL, 0x040fe40007ffe0ffULL,
0x00000018093d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001211a7824ULL, 0x100fe200078e0208ULL,
0x0000001c093f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000123207824ULL, 0x100fe200078e0208ULL,
0xfffffff80e197812ULL, 0x000fe200078ee219ULL, 0x000000013d227824ULL, 0x000fe200078e0208ULL,
0x00000007090b7812ULL, 0x000fe200078e4800ULL, 0x000000013f247824ULL, 0x100fe200078e0208ULL,
0x00000008090e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000823267824ULL, 0x000fe200078e00ffULL,
0xfffffff80a117812ULL, 0x000fe200078ee211ULL, 0x000000010d0a7824ULL, 0x100fe200078e0208ULL,
0xfffffff80c137812ULL, 0x000fe200078ee213ULL, 0x000000010f0c7824ULL, 0x000fe200078e0208ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef800ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0025ULL,
0x0000000021097212ULL, 0x000fc400078e3cffULL, 0x0000000321187819ULL, 0x000fe200000006ffULL,
0x000000083f497824ULL, 0x000fe200078e00ffULL, 0x000000003d087212ULL, 0x080fe200078e3cffULL,
0x00000010270e7825ULL, 0x000fe200078e000eULL, 0x000000033d477819ULL, 0x000fe400000006ffULL,
0x00000000230d7212ULL, 0x080fe200078e3cffULL, 0x000000100b3d7824ULL, 0x000fe200078e0250ULL,
0x000000003f127212ULL, 0x000fe200078e3cffULL, 0x00005e001a1a7625ULL, 0x000fe200078e0025ULL,
0xfffffff8183f7812ULL, 0x000fc400078ee209ULL, 0xfffffff847477812ULL, 0x000fe200078ee208ULL,
0x00005e000a087625ULL, 0x080fe200078e0025ULL, 0xfffffff826457812ULL, 0x000fe200078ee20dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e3d7faeULL, 0x0003e2000b901c46ULL,
0xfffffff849497812ULL, 0x000fe200078ee212ULL, 0x00005e000c0a7625ULL, 0x000fe200078e0025ULL,
0x0000005019197211ULL, 0x000fc600078e20ffULL, 0x00005e00100c7625ULL, 0x000fc800078e0025ULL,
0x00005e0020207625ULL, 0x000fc800078e0025ULL, 0x00005e0022227625ULL, 0x000fc800078e0025ULL,
0x00005e0024247625ULL, 0x000fc800078e0025ULL, 0x0000001027087825ULL, 0x000fc800078e0008ULL,
0x0000001011117824ULL, 0x000fe400078e0250ULL, 0x00000010270a7825ULL, 0x000fc600078e000aULL,
0x0000000008117faeULL, 0x0005e2000b901c46ULL, 0x0000001013137824ULL, 0x000fe400078e0250ULL,
0x00000010270c7825ULL, 0x000fc600078e000cULL, 0x000000000a137faeULL, 0x0005e2000b901c46ULL,
0x00000010270e7825ULL, 0x002fc600078e001aULL, 0x000000000c197faeULL, 0x0005e2000b901c46ULL,
0x000000103f3f7824ULL, 0x000fe400078e0250ULL, 0x0000001027207825ULL, 0x000fc600078e0020ULL,
0x000000000e3f7faeULL, 0x0005e2000b901c46ULL, 0x0000001045457824ULL, 0x000fe400078e0250ULL,
0x0000001027227825ULL, 0x000fc600078e0022ULL, 0x0000000020457faeULL, 0x0005e2000b901c46ULL,
0x0000001047477824ULL, 0x000fe400078e0250ULL, 0x0000001027247825ULL, 0x000fc600078e0024ULL,
0x0000000022477faeULL, 0x0005e2000b901c46ULL, 0x0000001049497824ULL, 0x000fca00078e0250ULL,
0x0000000024497faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000b8005c207811ULL, 0x004fe400078e20ffULL, 0x00000005ff08723eULL, 0x002fe400000010ffULL,
0x00000002ff5b7819ULL, 0x000fe40000011600ULL, 0x0000541008527816ULL, 0x000fe40000000008ULL,
0x0000b800560c7811ULL, 0x000fc600078e20ffULL, 0x00001f5b525b7589ULL, 0x000fe800000e0000ULL,
0x00001f0752507589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002020783bULL, 0x000e680000000200ULL, 0x000000005844783bULL, 0x000ea80000004200ULL,
0x000000005a4c783bULL, 0x000fe80000004200ULL, 0x000000005948783bULL, 0x000fe80000004200ULL,
0x000000005724783bULL, 0x000fe80000004200ULL, 0x000000000c0c783bULL, 0x000ee80000000200ULL,
0x00000000533c783bULL, 0x000f280000004200ULL, 0x000000005518783bULL, 0x000f680000004200ULL,
0x000000005410783bULL, 0x000f280000004200ULL, 0x000000005108783bULL, 0x000f220000004200ULL,
0x0000005b20208231ULL, 0x002fc400003400ffULL, 0x0000005b22228231ULL, 0x000fe400003400ffULL,
0x0000005021218231ULL, 0x080fe400003400ffULL, 0x0000005023238231ULL, 0x000fce00003400ffULL,
0x000000442040723cULL, 0x004fe20000041840ULL, 0x0000005b0c0c8231ULL, 0x008fce00003400ffULL,
0x0000004c202c723cULL, 0x000fe2000004182cULL, 0x0000005b0e0e8231ULL, 0x000fe400003400ffULL,
0x000000500d0d8231ULL, 0x080fe400003400ffULL, 0x000000500f0f8231ULL, 0x000fc600003400ffULL,
0x0000004e2030723cULL, 0x040ff00000041830ULL, 0x000000482034723cULL, 0x040ff00000041834ULL,
0x0000004a2038723cULL, 0x040ff00000041838ULL, 0x000000462014723cULL, 0x040ff00000041814ULL,
0x000000242028723cULL, 0x040ff00000041828ULL, 0x00000026201c723cULL, 0x000ff0000004181cULL,
0x0000003c0c40723cULL, 0x050ff00000041840ULL, 0x000000180c2c723cULL, 0x060ff0000004182cULL,
0x0000001a0c30723cULL, 0x040ff00000041830ULL, 0x000000100c34723cULL, 0x040ff00000041834ULL,
0x000000120c38723cULL, 0x040ff00000041838ULL, 0x0000003e0c3c723cULL, 0x040ff00000041814ULL,
0x000000080c28723cULL, 0x040ff00000041828ULL, 0x0000000a0c0c723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01464000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030061617a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff04ff7812ULL, 0x000fc4000780c0ffULL, 0x0000005d6100720cULL, 0x000fe40003f26070ULL,
0x00000001ff047807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff7cc000007947ULL, 0x000fea000383ffffULL, 0x0000000000087919ULL, 0x000e620000002500ULL,
0x0000000f00157202ULL, 0x000fe20000000f00ULL, 0x000000ffff167224ULL, 0x000fe400078e000eULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00000028000d7202ULL, 0x000fe20000000f00ULL,
0x000000ffff0f7224ULL, 0x000fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe200078e0029ULL,
0x0000005d0800720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000003007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff277224ULL, 0x000fe200078e0003ULL,
0x0000980000287802ULL, 0x000fe40000000f00ULL, 0x0000c32000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300007308ULL, 0x000e640000001000ULL, 0xbf80000000047423ULL, 0x002fc80000000003ULL,
0x800000ff04057221ULL, 0x000fc80000010100ULL, 0x0000000500007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea80000000000ULL,
0x0000000000047919ULL, 0x000ee20000000000ULL, 0x0000000805057811ULL, 0x004fe400078ff0ffULL,
0x00000002ff077819ULL, 0x008fc80000011604ULL, 0x00001f0500057589ULL, 0x000ea800000e0000ULL,
0x00001f0700047589ULL, 0x000ee200000e0000ULL, 0x0000002e052e7220ULL, 0x044fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x048fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003804387220ULL, 0x040fe20000410000ULL,
0x0000003904397220ULL, 0x040fe20000410000ULL, 0x0000004004407220ULL, 0x040fe20000410000ULL,
0x0000004104417220ULL, 0x040fe20000410000ULL, 0x0000003c043c7220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000000c040c7220ULL, 0x040fe20000410000ULL, 0x0000000f040f7220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x000fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x000fe20000410000ULL, 0x00000000001e7919ULL, 0x000ea20000000000ULL,
0x000000303106723eULL, 0x000fc400000010ffULL, 0x0000000d0c0c723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000f0e0d723eULL, 0x000fe400000010ffULL,
0x000000161515723eULL, 0x000fe400000010ffULL, 0x00000032330f723eULL, 0x000fe400000010ffULL,
0x0000002c2d05723eULL, 0x000fe400000010ffULL, 0x0000002a2b14723eULL, 0x000fc400000010ffULL,
0x000000343507723eULL, 0x000fe400000010ffULL, 0x000000383909723eULL, 0x000fe400000010ffULL,
0x00000040410a723eULL, 0x000fe400000010ffULL, 0x0000002e2f0e723eULL, 0x000fe400000010ffULL,
0x0000003c3d0b723eULL, 0x000fe400000010ffULL, 0x00000002ff237819ULL, 0x004fc4000001161eULL,
0x000000081e317811ULL, 0x000fe400078ff0ffULL, 0x00000023ff257212ULL, 0x000fe200078e33ffULL,
0x0000000823167824ULL, 0x000fe200078e00ffULL, 0x00000031ff337212ULL, 0x000fe200078e33ffULL,
0x0000000831187824ULL, 0x000fe200078e00ffULL, 0x0000000323047819ULL, 0x040fe400000006ffULL,
0x0000000723007812ULL, 0x000fe400078ec0ffULL, 0xfffffff816257812ULL, 0x000fc400078ee225ULL,
0xfffffff818337812ULL, 0x000fe400078ee233ULL, 0xfffffff804177812ULL, 0x000fe400078ee223ULL,
0x0000000100047812ULL, 0x040fe400078e3cffULL, 0x0000000200167812ULL, 0x040fe400078e3cffULL,
0x0000000300187812ULL, 0x040fe200078e3cffULL, 0x0000000823197824ULL, 0x040fe200078e0204ULL,
0x00000004001a7812ULL, 0x040fe200078e3cffULL, 0x00000008231b7824ULL, 0x040fe200078e0216ULL,
0x00000005001c7812ULL, 0x040fe200078e3cffULL, 0x00000008231d7824ULL, 0x040fe200078e0218ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x00000008231f7824ULL, 0x040fe200078e021aULL,
0x0000001c23217211ULL, 0x000fe200078e18ffULL, 0x000000041e167824ULL, 0x000fe200078e00ffULL,
0x0000000731187812ULL, 0x000fe200078ec0ffULL, 0x0000000823237824ULL, 0x000fe200078e0200ULL,
0x000000363710723eULL, 0x000fe200000010ffULL, 0x000008005f007824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00000008311a7824ULL, 0x000fe200078e00ffULL,
0x00000002181c7812ULL, 0x000fc400078e3cffULL, 0x0000a00000047810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81a277812ULL, 0x002fe200078ee231ULL, 0x00000008312b7824ULL, 0x000fe200078e021cULL,
0x0000000417177211ULL, 0x080fe200078e20ffULL, 0x0000001019197824ULL, 0x100fe200078e0204ULL,
0x00000001181a7812ULL, 0x040fe200078e3cffULL, 0x000000101b1b7824ULL, 0x100fe200078e0204ULL,
0x00000003181e7812ULL, 0x040fe200078e3cffULL, 0x000000101d1d7824ULL, 0x100fe200078e0204ULL,
0x0000000418207812ULL, 0x040fe200078e3cffULL, 0x000000101f1f7824ULL, 0x000fe200078e0204ULL,
0x0000000518227812ULL, 0x040fe200078e3cffULL, 0x0000000831297824ULL, 0x000fe200078e021aULL,
0x0000000618247812ULL, 0x000fe200078e3cffULL, 0x0000000117187824ULL, 0x000fe200078e0216ULL,
0x0000000421217211ULL, 0x000fe200078e20ffULL, 0x0000000116197824ULL, 0x040fe200078e0219ULL,
0x0000002031177211ULL, 0x000fe200078e18ffULL, 0x0000001023237824ULL, 0x000fe200078e0204ULL,
0x0000000518007388ULL, 0x0003e20000000800ULL, 0x00000008312d7824ULL, 0x000fe200078e021eULL,
0x000000042b2b7211ULL, 0x000fe200078e20ffULL, 0x0000001025257824ULL, 0x100fe200078e0204ULL,
0x00000021161c7210ULL, 0x040fe20007ffe0ffULL, 0x00000001161a7824ULL, 0x040fe200078e021dULL,
0x0000000619007388ULL, 0x0005e20000000800ULL, 0x0000001027277824ULL, 0x000fe200078e0204ULL,
0x0000003a3b11723eULL, 0x000fe200000010ffULL, 0x00000001161f7824ULL, 0x040fe200078e021fULL,
0x0000000433337211ULL, 0x000fe200078e20ffULL, 0x0000000116187824ULL, 0x042fe200078e021bULL,
0x000000424312723eULL, 0x000fe200000010ffULL, 0x00000001ff057424ULL, 0x000fe200078e00ffULL,
0x0000003e3f13723eULL, 0x000fe200000010ffULL, 0x00000008312f7824ULL, 0x000fe200078e0222ULL,
0x0000000718007388ULL, 0x0005e20000000800ULL, 0x0000001029297824ULL, 0x000fe200078e0204ULL,
0x0000030005007a0cULL, 0x000fe20003f05270ULL, 0x0000000831317824ULL, 0x000fe200078e0224ULL,
0x000000091a007388ULL, 0x0005e20000000800ULL, 0x0000000116237824ULL, 0x040fe200078e0223ULL,
0x0000003316267210ULL, 0x040fe20007ffe0ffULL, 0x00000001161e7824ULL, 0x000fe200078e0225ULL,
0x0000000a1f007388ULL, 0x0005e20000000800ULL, 0x000000102d2d7824ULL, 0x000fc400078e0204ULL,
0x0000001017177824ULL, 0x100fe200078e0204ULL, 0x0000000b1c007388ULL, 0x0005e20000000800ULL,
0x0000000116277824ULL, 0x040fe400078e0227ULL, 0x000000102f2f7824ULL, 0x100fe200078e0204ULL,
0x0000000c23007388ULL, 0x0005e20000000800ULL, 0x0000000116207824ULL, 0x040fe200078e0229ULL,
0x0000001716177210ULL, 0x040fe20007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e0204ULL,
0x0000000d1e007388ULL, 0x0005e20000000800ULL, 0x00000001162b7824ULL, 0x000fc400078e022bULL,
0x0000000116227824ULL, 0x040fe200078e022dULL, 0x0000000e27007388ULL, 0x0005e20000000800ULL,
0x0000000116247824ULL, 0x040fe400078e022fULL, 0x0000000116317824ULL, 0x000fe200078e0231ULL,
0x0000000f20007388ULL, 0x0005e80000000800ULL, 0x000000102b007388ULL, 0x0005e80000000800ULL,
0x0000001122007388ULL, 0x0005e80000000800ULL, 0x0000001217007388ULL, 0x0005e80000000800ULL,
0x0000001324007388ULL, 0x0005e80000000800ULL, 0x0000001431007388ULL, 0x0005e80000000800ULL,
0x0000001526007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002d0000008947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x004e620000000000ULL,
0x00005800ff077624ULL, 0x000fe200078e00ffULL, 0x000000ff5f00720cULL, 0x000fe20003f25270ULL,
0x00002000ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000097919ULL, 0x000ea20000002700ULL,
0x0000030007077a24ULL, 0x000fc600078e02ffULL, 0x00000000000a7919ULL, 0x000ea20000002600ULL,
0x0000640007077a24ULL, 0x000fe200078e02ffULL, 0x00000000061c7211ULL, 0x042fe400078e20ffULL,
0x0000002006237810ULL, 0x040fe40007ffe0ffULL, 0x0000004006257810ULL, 0x040fe20007ffe0ffULL,
0x00a000001c147984ULL, 0x0002e20000000c00ULL, 0x0000006006277810ULL, 0x040fe20007ffe0ffULL,
0x0000580009097a24ULL, 0x004fe400078e020aULL, 0x00a200001c107984ULL, 0x0002a20000000c00ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000030009057a24ULL, 0x000fc400078e02ffULL,
0x00a400001c0c7984ULL, 0x0003220000000c00ULL, 0x000000ff5f00720cULL, 0x000fe20000705670ULL,
0x00000001051d7824ULL, 0x000fe400078e0208ULL, 0x00a600001c187984ULL, 0x0002620000000c00ULL,
0x00001fff07087811ULL, 0x000fc800078e40ffULL, 0x0000001d080a7211ULL, 0x000fca00078f98ffULL,
0x00006a000a0a7625ULL, 0x000fcc00078e000bULL, 0x000008005f0a7825ULL, 0x000fcc00078e000aULL,
0x0000001023227825ULL, 0x000fc800078e000aULL, 0x0000001025247825ULL, 0x000fc800078e000aULL,
0x0000001027267825ULL, 0x000fc800078e000aULL, 0x0000001006207825ULL, 0x000fe200078e000aULL,
0x01ffffff070a7812ULL, 0x000fe200078ec0ffULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x01cea20000000000ULL, 0x00000080ff1f7424ULL, 0x000fe400078e00ffULL,
0x000000011d1e7824ULL, 0x040fe400078e020aULL, 0x00006a001d1c7625ULL, 0x002fc800078e001fULL,
0x00006a001e1e7625ULL, 0x000fe200078e001fULL, 0x00000004070b7819ULL, 0x004fe400000006ffULL,
0x00000001ff077819ULL, 0x000fe40000011607ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fc800078ec0ffULL, 0x0000001c071c7210ULL, 0x140fe40007b5e00bULL,
0x0000001e071e7210ULL, 0x000fe40007d9e00bULL, 0x0000001dff1d7210ULL, 0x000fe400017e64ffULL,
0x0000001fff1f7210ULL, 0x000fc600027ea4ffULL, 0x000000021c007986ULL, 0x0003e8000c101906ULL,
0x000000031e007986ULL, 0x0003e4000c101906ULL, 0x0000001420007986ULL, 0x01c5e2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000001022007986ULL, 0x0005e8000c101d06ULL,
0x0000000c24007986ULL, 0x0005e8000c101d06ULL, 0x0000001826007986ULL, 0x0025e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000000947ULL, 0x000fea0003800000ULL,
0x00000001ff077424ULL, 0x000fe400078e00ffULL, 0x00000004ff027424ULL, 0x000fc600078e00ffULL,
0x0000030007077a10ULL, 0x000fe20007ffe1ffULL, 0x0000680009027625ULL, 0x000fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000007020279a8ULL, 0x000ee400099ee1c6ULL, 0x000000070200720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff097807ULL, 0x000fca0000000000ULL,
0x00000009ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff027984ULL, 0x000ee40000000000ULL,
0x000000ff0200720cULL, 0x008fda0003f05270ULL, 0x0000287000008947ULL, 0x000fea0003800000ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011606ULL, 0x00000080ff117424ULL, 0x004fe200078e00ffULL,
0x00000001050c7810ULL, 0x000fe40007ffe0ffULL, 0x0000007002137812ULL, 0x000fe400078ec0ffULL,
0x0000000c03127812ULL, 0x000fe200078ec0ffULL, 0x00006a0005027625ULL, 0x000fc800078e0011ULL,
0x00006a000c0c7625ULL, 0x000fe200078e0011ULL, 0x00000002120e7210ULL, 0x000fc8000791e013ULL,
0x0000000c120c7210ULL, 0x000fe40007b5e013ULL, 0x00000003ff0f7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060e027981ULL, 0x000568000c1e1900ULL,
0x000000060c037981ULL, 0x000562000c1e1900ULL, 0x0000030000107a02ULL, 0x000fc80000000f00ULL,
0x000000021000780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002050c7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c120c7210ULL, 0x000fc8000791e013ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c077981ULL, 0x000562000c1e1900ULL, 0x000000041000780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003050c7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c120c7210ULL, 0x000fc8000791e013ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c097981ULL, 0x002362000c1e1900ULL,
0x000000041000780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004050c7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c120c7210ULL, 0x000fc8000791e013ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c0b7981ULL, 0x000362000c1e1900ULL, 0x000000061000780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005050c7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c120c7210ULL, 0x000fc8000791e013ULL,
0x0000000dff0d7210ULL, 0x000fcc00007e24ffULL, 0x000000060c0d7981ULL, 0x000362000c1e1900ULL,
0x000000061000780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081000780cULL, 0x002fe40003f06070ULL, 0x00000006050e7810ULL, 0x000fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0011ULL, 0x0000000e120e7210ULL, 0x000fe40007a3e013ULL,
0x0000000705100810ULL, 0x000fe40007ffe0ffULL, 0x0000000fff0f7210ULL, 0x000fc60000fe44ffULL,
0x00006a0010100625ULL, 0x000fca00078e0011ULL, 0x0000001012100210ULL, 0x000fe40007c7e013ULL,
0x000000060e137981ULL, 0x000364000c1e1900ULL, 0x00000011ff110210ULL, 0x000fcc0001fe84ffULL,
0x0000000610110981ULL, 0x000366000c1e1900ULL, 0x0000030000047ab9ULL, 0x006fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff147224ULL, 0x000fe400078e00ffULL, 0x000000ffff107224ULL, 0x000fe400078e0005ULL,
0x000000ffff157224ULL, 0x020fe400078e0002ULL, 0x000000ffff167224ULL, 0x000fc600078e00ffULL,
0x0000030014007a0cULL, 0x000fe40003f26070ULL, 0x0000000116167810ULL, 0x000fc80007ffe0ffULL,
0x0000000416007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008140c7810ULL, 0x040fe40007ffe0ffULL, 0x00000001140e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000001502027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000008100e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010060c7824ULL, 0x000fe200078e00ffULL,
0x00000080000f7802ULL, 0x000fe40000000f00ULL, 0x00000001ff127819ULL, 0x000fe40000011606ULL,
0x000000700c157812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fe200078e000fULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000e120e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e157981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009140c7810ULL, 0x040fe40007ffe0ffULL,
0x00000002140e7810ULL, 0x002fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000000302027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000009100e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011606ULL,
0x0000001006037824ULL, 0x000fe400078e00ffULL, 0x00006a000e0e7625ULL, 0x000fe200078e000fULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000007003037812ULL, 0x000fc800078ec0ffULL,
0x0000000e0c0e7210ULL, 0x000fc80007b3e003ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e037981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a140c7810ULL, 0x040fe40007ffe0ffULL, 0x00000003140e7810ULL, 0x002fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000000702027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a100e7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000406077819ULL, 0x000fe400000006ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011606ULL,
0x00006a000e0e7625ULL, 0x000fe200078e000fULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000e0c0e7210ULL, 0x000fc80007b3e007ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e077981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b140c7810ULL, 0x040fe40007ffe0ffULL,
0x00000004140e7810ULL, 0x002fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000000902027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b100e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011606ULL,
0x0000001006097824ULL, 0x000fe400078e00ffULL, 0x00006a000e0e7625ULL, 0x000fe200078e000fULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x0000000e0c0e7210ULL, 0x000fc80007b3e009ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e097981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c140c7810ULL, 0x040fe40007ffe0ffULL, 0x00000005140e7810ULL, 0x002fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000000b02027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c100e7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011606ULL, 0x00000010060b7824ULL, 0x000fe400078e00ffULL,
0x00006a000e0e7625ULL, 0x000fe200078e000fULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000000e0c0e7210ULL, 0x000fc80007b3e00bULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e0b7981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d140c7810ULL, 0x040fe40007ffe0ffULL,
0x00000006140e7810ULL, 0x002fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000000d02027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d100c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010060e7824ULL, 0x000fe200078e00ffULL, 0x00000080000d7802ULL, 0x000fe40000000f00ULL,
0x00000001ff127819ULL, 0x000fe40000011606ULL, 0x000000700e0f7812ULL, 0x000fe200078ec0ffULL,
0x00006a000c0c7625ULL, 0x000fe200078e000dULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e00fULL, 0x0000000dff0d7210ULL, 0x000fcc0000fe64ffULL,
0x000000060c0d7981ULL, 0x000366000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000007140e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000001302027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e100e7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011606ULL, 0x00000010060c7824ULL, 0x000fe400078e00ffULL,
0x00006a000e0e7625ULL, 0x000fe200078e000fULL, 0x0000000c12127812ULL, 0x000fe400078ec0ffULL,
0x000000700c137812ULL, 0x000fc800078ec0ffULL, 0x0000000e120e7210ULL, 0x000fc80007b3e013ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e137981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f140c7810ULL, 0x000fe40007ffe0ffULL,
0x0000001102027209ULL, 0x000fe40007810000ULL, 0x000003000c007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f100e7810ULL, 0x002fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000004060c7819ULL, 0x000fe400000006ffULL,
0x00000001ff127819ULL, 0x000fe20000011606ULL, 0x00006a000e0e7625ULL, 0x000fe200078e000fULL,
0x000000700c117812ULL, 0x000fe400078ec0ffULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000e120e7210ULL, 0x000fc80007a3e011ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe44ffULL,
0x000000060e117981ULL, 0x000368000c1e1900ULL, 0x0000000814147810ULL, 0x000fe40007ffe0ffULL,
0x0000000810107810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x000ea40000000000ULL, 0x0000001006037824ULL, 0x024fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011606ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c070c7812ULL, 0x002fca00078ec0ffULL, 0x0000000103037824ULL, 0x000fca00078e020cULL,
0x0000000203007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000070600780cULL, 0x040fe20003f04070ULL, 0x0000001006027824ULL, 0x002fe200078e00ffULL,
0x0000000508297211ULL, 0x000fe200078f98ffULL, 0x00002000ff087424ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011606ULL, 0x0000000105287824ULL, 0x000fe200078e020aULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x00006a0029087625ULL, 0x000fe200078e0008ULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x00000000001a7805ULL, 0x004fe2000001ff00ULL,
0x00000020060b7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x00000040060f7810ULL, 0x040fe20007ffe0ffULL, 0x000008005f087825ULL, 0x040fe200078e0008ULL,
0x0000006006117810ULL, 0x000fe20007ffe0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000008000148802ULL, 0x000fe20000000f00ULL, 0x00000080ff0d8424ULL, 0x000fe200078e00ffULL,
0x0000000302027210ULL, 0x000fe20007ffe0ffULL, 0x000010005f037824ULL, 0x000fe200078e00ffULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00006a00280c8625ULL, 0x000fe200078e000dULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000002027984ULL, 0x000e620000000800ULL, 0x000000100b0a7825ULL, 0x000fe200078e0008ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x000000100f0e7825ULL, 0x000fc800078e0008ULL, 0x0000001011107825ULL, 0x000fc800078e0008ULL,
0x000000105f198824ULL, 0x000fe400078e0206ULL, 0x00006a0005148625ULL, 0x000fc600078e0014ULL,
0x0000458019198811ULL, 0x000fe200078e20ffULL, 0x0000001006177824ULL, 0x040fe400078e0203ULL,
0x0000001006087825ULL, 0x000fc800078e0008ULL, 0x000000105f1d8824ULL, 0x000fe200078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008177faeULL, 0x0005e2000b901c46ULL,
0x0000001006128825ULL, 0x040fe400078e000cULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000041801d1d8811ULL, 0x000fe200078e20ffULL, 0x0000001006148825ULL, 0x000fe200078e0014ULL,
0x003800000a177faeULL, 0x0007e8000b901c46ULL, 0x005800000e177faeULL, 0x0009e2000b901c46ULL,
0x0000000000087805ULL, 0x004fc6000001ff00ULL, 0x0078000010177faeULL, 0x0005e8000b901c46ULL,
0x0000000012198faeULL, 0x000be2000b901c46ULL, 0x00000000000a7805ULL, 0x008fc6000001ff00ULL,
0x00000000141d8faeULL, 0x0007e2000b901c46ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x020fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x008fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000d7000009947ULL, 0x000fea0003800000ULL,
0x00000001052a7810ULL, 0x002fe20007ffe0ffULL, 0x00000001ff057424ULL, 0x000fe200078e00ffULL,
0x0000000128287810ULL, 0x000fe40007ffe0ffULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x000000ff00077202ULL, 0x000fe40000000f00ULL, 0x0000030005007a0cULL, 0x000fda0003f06070ULL,
0x0000025000000947ULL, 0x000fea0003800000ULL, 0x00002000ff2c7424ULL, 0x000fe200078e00ffULL,
0x000000070600780cULL, 0x040fe20003f04070ULL, 0x00000800052b7824ULL, 0x000fe200078e00ffULL,
0x0000002006317810ULL, 0x040fe20007ffe0ffULL, 0x00006a00292c7625ULL, 0x000fe200078e002cULL,
0x0000000105327812ULL, 0x000fe400078ec0ffULL, 0x000008002b307812ULL, 0x000fe400078ec0ffULL,
0x0000004006337810ULL, 0x040fe20007ffe0ffULL, 0x000008005f2e7825ULL, 0x000fe200078e002cULL,
0x0000006006357810ULL, 0x000fc60007ffe0ffULL, 0x00000080ff398424ULL, 0x000fe200078e00ffULL,
0x000000325f3d8211ULL, 0x040fe200078e08ffULL, 0x000000025f378824ULL, 0x000fe400078e0232ULL,
0x00000001032b7824ULL, 0x000fe400078e0230ULL, 0x00000010312c7825ULL, 0x000fc800078e002eULL,
0x00000080ff3b8424ULL, 0x000fe400078e00ffULL, 0x0000001033307825ULL, 0x000fc800078e002eULL,
0x0000001035327825ULL, 0x000fc800078e002eULL, 0x00006a0028348625ULL, 0x000fc800078e0039ULL,
0x0000000837398824ULL, 0x000fe400078e0206ULL, 0x00006a002a368625ULL, 0x000fe200078e003bULL,
0x000000063d3b8211ULL, 0x000fe400078e18ffULL, 0x0000458039398811ULL, 0x000fe200078e20ffULL,
0x00000010062b7824ULL, 0x040fe200078e022bULL, 0x000041803b3b8811ULL, 0x000fe200078e20ffULL,
0x00000010062e7825ULL, 0x000fc800078e002eULL, 0x0000001006348825ULL, 0x040fe200078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002e2b7faeULL, 0x0003e6000b901c46ULL,
0x0000001006368825ULL, 0x000fe200078e0036ULL, 0x003800002c2b7faeULL, 0x0003e8000b901c46ULL,
0x00580000302b7faeULL, 0x0003e8000b901c46ULL, 0x00780000322b7faeULL, 0x0003e8000b901c46ULL,
0x0000000034398faeULL, 0x0003e8000b901c46ULL, 0x00000000363b8faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff052b7810ULL, 0x002fe20007ffe0ffULL,
0x00000010062d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff2e7819ULL, 0x000fc40000011606ULL,
0x00000002ff337819ULL, 0x000fe20000011606ULL, 0x000000802b2c7824ULL, 0x000fe200078e00ffULL,
0x000000702d2d7812ULL, 0x000fe200078ec0ffULL, 0x000008002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c2e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000833357824ULL, 0x040fe200078e00ffULL,
0x000000802c2c7812ULL, 0x000fe400078ec0ffULL, 0x00000007333a7812ULL, 0x040fe400078ec0ffULL,
0x0000000333317819ULL, 0x000fe200000006ffULL, 0x000001005f2c7824ULL, 0x000fe200078e022cULL,
0x0000000833377810ULL, 0x000fc40007ffe0ffULL, 0x0000030005007a0cULL, 0x000fe40003f06070ULL,
0x0000002c2e2e7210ULL, 0x000fe20007ffe02dULL, 0x00000008332d7824ULL, 0x000fe200078e00ffULL,
0x00000033ff2c7212ULL, 0x000fe200078e33ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002e2f7984ULL, 0x000e620000000800ULL, 0xfffffff835467812ULL, 0x000fe200078ee22cULL,
0x0000000406357824ULL, 0x000fe200078e00ffULL, 0xfffffff8312c7812ULL, 0x100fe200078ee23aULL,
0x004580002e4a7984ULL, 0x0004e20000000800ULL, 0x000000012d307812ULL, 0x100fe200078ef63aULL,
0x0000000837317824ULL, 0x000fe200078e00ffULL, 0x000000022d327812ULL, 0x100fe200078ef63aULL,
0x00000008373c7824ULL, 0x000fe200078e00ffULL, 0x000000032d347812ULL, 0x140fe400078ef63aULL,
0x000000042d367812ULL, 0x000fc400078ef63aULL, 0x000008002b2e7812ULL, 0x004fe400078ec0ffULL,
0x000000052d387812ULL, 0x140fe400078ef63aULL, 0x00000037ff487212ULL, 0x000fe400078e33ffULL,
0x000000062d3a7812ULL, 0x000fe400078ef63aULL, 0x00000180032b7810ULL, 0x000fe40007ffe02eULL,
0xfffffff831487812ULL, 0x000fc400078ee248ULL, 0x0000000c35357812ULL, 0x000fe200078ec0ffULL,
0x000000102c2c7824ULL, 0x100fe200078e022bULL, 0x00000003373e7819ULL, 0x000fe200000006ffULL,
0x0000001030307824ULL, 0x100fe200078e022bULL, 0x0000000105057810ULL, 0x000fe20007ffe0ffULL,
0x00000001352c7824ULL, 0x040fe200078e022cULL, 0x0000000128287810ULL, 0x000fe20007ffe0ffULL,
0x0000001032327824ULL, 0x100fe200078e022bULL, 0x0000003035307210ULL, 0x000fe20007ffe0ffULL,
0x0000001034347824ULL, 0x000fe200078e022bULL, 0x0000000129297810ULL, 0x000fe20007ffe0ffULL,
0x0000000135327824ULL, 0x040fe200078e0232ULL, 0x000000012a2a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000135347824ULL, 0x000fe200078e0234ULL, 0x0000000030307984ULL, 0x000fe20000000800ULL,
0x0000002f022f7221ULL, 0x002fe20000010100ULL, 0x0000001036367824ULL, 0x000fc400078e022bULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2f2d7820ULL, 0x000fe20000410000ULL,
0x00000007372f7812ULL, 0x000fe200078ec0ffULL, 0x0000001038387824ULL, 0x000fe200078e022bULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x0000002d00317308ULL, 0x0002e20000000800ULL,
0xfffffff83e2e7812ULL, 0x100fe200078ee22fULL, 0x0000000135367824ULL, 0x040fe200078e0236ULL,
0x000000013c3e7812ULL, 0x140fe200078ef62fULL, 0x0000000135387824ULL, 0x040fe200078e0238ULL,
0x000000023c407812ULL, 0x000fe200078ef62fULL, 0x000000102e2e7824ULL, 0x000fe200078e022bULL,
0x000000033c427812ULL, 0x000fe200078ef62fULL, 0x0000000036367984ULL, 0x000fe20000000800ULL,
0x00000010462d7824ULL, 0x002fe200078e022bULL, 0x000000043c447812ULL, 0x140fe200078ef62fULL,
0x00000001352e7824ULL, 0x040fe200078e022eULL, 0x000000053c467812ULL, 0x140fe200078ef62fULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x000000063c3c7812ULL, 0x000fe200078ef62fULL,
0x0000001040407824ULL, 0x100fe200078e022bULL, 0x0000002d352d7210ULL, 0x000fe20007ffe0ffULL,
0x000000002c2f7984ULL, 0x000e620000000800ULL, 0x0000004a314a7220ULL, 0x008fe20000410000ULL,
0x0000000135407824ULL, 0x040fe200078e0240ULL, 0x0000002b3e3e7211ULL, 0x080fe200078e20ffULL,
0x000000002d317984ULL, 0x000fe20000000800ULL, 0x000000103a3a7824ULL, 0x100fe200078e022bULL,
0x0000002b46467211ULL, 0x000fe200078e20ffULL, 0x0000001042427824ULL, 0x100fe200078e022bULL,
0x00001f334a2d7589ULL, 0x000ea200000e0000ULL, 0x0000001044447824ULL, 0x100fe200078e022bULL,
0x0000003a353a7210ULL, 0x040fe20007ffe0ffULL, 0x000000103c3c7824ULL, 0x100fe200078e022bULL,
0x000000002e2e7984ULL, 0x000ee20000000800ULL, 0x0000001048487824ULL, 0x000fe200078e022bULL,
0x0000004435447210ULL, 0x040fe20007ffe0ffULL, 0x0000000135427824ULL, 0x040fe200078e0242ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x000000274a277221ULL, 0x000fe20000010000ULL,
0x00000001353e7824ULL, 0x000fc400078e023eULL, 0x000000003a3a7984ULL, 0x000fe20000000800ULL,
0x00000001353c7824ULL, 0x040fe400078e023cULL, 0x0000000135467824ULL, 0x040fe200078e0246ULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x0000000135487824ULL, 0x000fc600078e0248ULL,
0x00001f374a4a7589ULL, 0x000f2800000e0000ULL, 0x0000000044447984ULL, 0x000f680000000800ULL,
0x000000003e3e7984ULL, 0x000ee20000000800ULL, 0x00005410ff2c7816ULL, 0x002fc6000000002fULL,
0x000000003c3c7984ULL, 0x000e620000000800ULL, 0x00007610ff2b7816ULL, 0x000fe2000000002fULL,
0x0000002d2c177223ULL, 0x004fe20000010017ULL, 0x00007610ff2c7816ULL, 0x000fc60000000031ULL,
0x0000002d2b1a7223ULL, 0x080fe2000001001aULL, 0x00005410ff2b7816ULL, 0x000fe20000000031ULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x0000002d2c0d7223ULL, 0x080fe2000001000dULL,
0x00007610ff2c7816ULL, 0x000fe40000000030ULL, 0x0000002d2b187223ULL, 0x080fe20000010018ULL,
0x00005410ff2b7816ULL, 0x000fe20000000030ULL, 0x0000000048487984ULL, 0x000ea20000000800ULL,
0x0000002d2c197223ULL, 0x000fe20000010019ULL, 0x00005410ff2c7816ULL, 0x000fc40000000032ULL,
0x0000002d2b127223ULL, 0x080fe20000010012ULL, 0x00007610ff2b7816ULL, 0x000fe40000000032ULL,
0x0000002d2c0f7223ULL, 0x080fe2000001000fULL, 0x00007610ff2c7816ULL, 0x000fe40000000034ULL,
0x0000002d2b267223ULL, 0x080fe20000010026ULL, 0x00005410ff2b7816ULL, 0x000fe40000000034ULL,
0x0000002d2c257223ULL, 0x000fe20000010025ULL, 0x00007610ff2c7816ULL, 0x000fc40000000038ULL,
0x0000002d2b147223ULL, 0x080fe20000010014ULL, 0x00005410ff2b7816ULL, 0x000fe40000000036ULL,
0x0000002d2c237223ULL, 0x080fe20000010023ULL, 0x00007610ff2c7816ULL, 0x008fe4000000002eULL,
0x0000002d2b087223ULL, 0x000fe20000010008ULL, 0x00007610ff2b7816ULL, 0x000fe40000000036ULL,
0x0000004a2c217223ULL, 0x010fe20000010021ULL, 0x00005410ff2c7816ULL, 0x000fc40000000040ULL,
0x0000002d2b247223ULL, 0x080fe20000010024ULL, 0x00005410ff2b7816ULL, 0x000fe40000000038ULL,
0x0000004a2c157223ULL, 0x080fe20000010015ULL, 0x00007610ff2c7816ULL, 0x000fe40000000040ULL,
0x0000002d2b107223ULL, 0x000fe20000010010ULL, 0x00005410ff2b7816ULL, 0x000fe4000000003aULL,
0x0000004a2c1f7223ULL, 0x000fe2000001001fULL, 0x00005410ff2c7816ULL, 0x000fc40000000042ULL,
0x0000002d2b0c7223ULL, 0x080fe2000001000cULL, 0x00007610ff2b7816ULL, 0x000fe4000000003aULL,
0x0000004a2c137223ULL, 0x080fe20000010013ULL, 0x00005410ff2c7816ULL, 0x020fe40000000044ULL,
0x0000002d2b227223ULL, 0x000fe20000010022ULL, 0x00005410ff2b7816ULL, 0x000fe4000000002eULL,
0x0000004a2c117223ULL, 0x000fe20000010011ULL, 0x00007610ff2c7816ULL, 0x000fc40000000044ULL,
0x0000004a2b0a7223ULL, 0x080fe2000001000aULL, 0x00005410ff2b7816ULL, 0x000fe4000000003eULL,
0x0000004a2c1d7223ULL, 0x080fe2000001001dULL, 0x00005410ff2c7816ULL, 0x002fe4000000003cULL,
0x0000004a2b167223ULL, 0x080fe20000010016ULL, 0x00007610ff2b7816ULL, 0x000fe4000000003eULL,
0x0000004a2c0b7223ULL, 0x000fe2000001000bULL, 0x00007610ff2c7816ULL, 0x000fc4000000003cULL,
0x0000004a2b207223ULL, 0x080fe20000010020ULL, 0x00007610ff2b7816ULL, 0x000fe40000000042ULL,
0x0000004a2c1b7223ULL, 0x080fe2000001001bULL, 0x00005410ff2c7816ULL, 0x004fe40000000048ULL,
0x0000004a2b1e7223ULL, 0x080fe2000001001eULL, 0x00005410ff2b7816ULL, 0x000fe40000000046ULL,
0x0000004a2c097223ULL, 0x000fe20000010009ULL, 0x00007610ff2c7816ULL, 0x000fc40000000048ULL,
0x0000004a2b0e7223ULL, 0x080fe2000001000eULL, 0x00007610ff2b7816ULL, 0x000fe40000000046ULL,
0x0000004a2c077223ULL, 0x000fc60000010007ULL, 0x0000004a2b1c7223ULL, 0x000fe2000001001cULL,
0xfffff2e000008947ULL, 0x000fea000383ffffULL, 0x0180000027027810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000002027812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000c59000287802ULL, 0x000fe40000000f00ULL,
0x0000959000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0005ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002700027308ULL, 0x000e640000001000ULL,
0xbf80000002037423ULL, 0x002fc80000000027ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000302027223ULL, 0x000fe40000000002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000287919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff297819ULL, 0x004fe40000011628ULL, 0x00000008282b7811ULL, 0x040fe400078ff0ffULL,
0x00000003292d7819ULL, 0x000fe200000006ffULL, 0x00001f2902037589ULL, 0x000ea200000e0000ULL,
0x0000000228287819ULL, 0x000fe200000006ffULL, 0x000000082b317824ULL, 0x000fc400078e00ffULL,
0x00001f2b02067589ULL, 0x000ee200000e0000ULL, 0x0000000c28287812ULL, 0x000fe200078ec0ffULL,
0x0000001703177220ULL, 0x044fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000000f030f7220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000002503257220ULL, 0x040fe20000410000ULL,
0x0000000803087220ULL, 0x040fe20000410000ULL, 0x0000002403057220ULL, 0x040fe20000410000ULL,
0x0000001003107220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000000c030c7220ULL, 0x040fe20000410000ULL, 0x0000002203277220ULL, 0x042fe20000410000ULL,
0x0000001803187220ULL, 0x040fe20000410000ULL, 0x0000000d03037220ULL, 0x000fe20000410000ULL,
0x0000001606167220ULL, 0x048fe20000410000ULL, 0x00000020060d7220ULL, 0x040fe20000410000ULL,
0x0000001d06207220ULL, 0x040fe20000410000ULL, 0x0000001c061d7220ULL, 0x040fe20000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x000000160d0d723eULL, 0x000fe200000010ffULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x0000001b061c7220ULL, 0x040fe20000410000ULL, 0x0000000829167824ULL, 0x000fe200078e00ffULL,
0x000000080505723eULL, 0x000fe200000010ffULL, 0x0000000a060a7220ULL, 0x040fe20000410000ULL,
0x0000000729087812ULL, 0x000fe200078ec0ffULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001f06027220ULL, 0x040fe20000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000000e060e7220ULL, 0x040fe20000410000ULL,
0x0000000906097220ULL, 0x040fe20000410000ULL, 0x0000000706067220ULL, 0x000fe20000410000ULL,
0x000000171a17723eULL, 0x000fc400000010ffULL, 0x000000180303723eULL, 0x000fe400000010ffULL,
0x000000131e13723eULL, 0x000fe400000010ffULL, 0x0000000b1c0b723eULL, 0x000fe400000010ffULL,
0xfffffff816077812ULL, 0x000fe400078ee229ULL, 0x0000000108167812ULL, 0x040fe400078e3cffULL,
0x0000000208187812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x000fe200078e0204ULL,
0x00000003081a7812ULL, 0x000fc400078e3cffULL, 0x00000004081c7812ULL, 0x040fe400078e3cffULL,
0x00000005081e7812ULL, 0x040fe400078e3cffULL, 0x0000000608087812ULL, 0x000fe200078e3cffULL,
0x00000008291b7824ULL, 0x000fe200078e021cULL, 0x00000029ff227212ULL, 0x000fe400078e33ffULL,
0x000000112011723eULL, 0x000fe400000010ffULL, 0x000000072b207812ULL, 0x000fc400078ec0ffULL,
0x000000121912723eULL, 0x000fe200000010ffULL, 0x0000000829197824ULL, 0x000fe200078e021aULL,
0x000000150202723eULL, 0x000fe400000010ffULL, 0x0000000e1d0e723eULL, 0x000fe200000010ffULL,
0x00000008291d7824ULL, 0x040fe200078e021eULL, 0x000000090606723eULL, 0x000fe200000010ffULL,
0x0000000829097824ULL, 0x040fe200078e0216ULL, 0x0000001829157211ULL, 0x040fe200078e18ffULL,
0x0000000829297824ULL, 0x000fe200078e0208ULL, 0xfffffff82d1f7812ULL, 0x000fe200078ee222ULL,
0x000000082b227824ULL, 0x000fe200078e00ffULL, 0x0000000120087812ULL, 0x040fe200078e3cffULL,
0x0000001009097824ULL, 0x100fe200078e0204ULL, 0x0000000220167812ULL, 0x040fe200078e3cffULL,
0x0000001015157824ULL, 0x100fe200078e0204ULL, 0x0000000320187812ULL, 0x040fe200078e3cffULL,
0x0000001019197824ULL, 0x100fe200078e0204ULL, 0x00000004201a7812ULL, 0x040fe200078e3cffULL,
0x000000101f1f7824ULL, 0x100fe200078e0204ULL, 0x00000005201c7812ULL, 0x040fe200078e3cffULL,
0x000000101d1d7824ULL, 0x000fe200078e0204ULL, 0x0000000620207812ULL, 0x000fe200078e3cffULL,
0x000000082b2d7824ULL, 0x000fe200078e021aULL, 0x0000002bff247212ULL, 0x000fe200078e33ffULL,
0x0000001029297824ULL, 0x000fe200078e0204ULL, 0x000000142514723eULL, 0x000fe200000010ffULL,
0x000000082b257824ULL, 0x000fe200078e0216ULL, 0x000000102310723eULL, 0x000fe200000010ffULL,
0x000000082b237824ULL, 0x000fe200078e0208ULL, 0x0000000c270c723eULL, 0x000fe200000010ffULL,
0x000000082b277824ULL, 0x000fe200078e0218ULL, 0x0000000a210a723eULL, 0x000fe200000010ffULL,
0x0000000107087824ULL, 0x000fe200078e0228ULL, 0xfffffff822217812ULL, 0x000fe200078ee22bULL,
0x0000001023237824ULL, 0x000fe200078e0204ULL, 0x0000001c2b2f7211ULL, 0x040fe200078e18ffULL,
0x000000082b2b7824ULL, 0x000fe200078e0220ULL, 0xfffffff831317812ULL, 0x000fe200078ee224ULL,
0x0000001021217824ULL, 0x100fe200078e0204ULL, 0x000000041b1b7211ULL, 0x080fe200078e20ffULL,
0x0000001025257824ULL, 0x100fe200078e0204ULL, 0x0000000431317211ULL, 0x080fe200078e20ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0204ULL, 0x0000000427277211ULL, 0x000fe200078e20ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0204ULL, 0x0000000f260f723eULL, 0x000fe200000010ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0204ULL, 0x0000001b28167210ULL, 0x040fe20007ffe0ffULL,
0x0000000128097824ULL, 0x040fe200078e0209ULL, 0x0000001708007388ULL, 0x0003e20000000800ULL,
0x0000000128047824ULL, 0x040fe200078e0215ULL, 0x0000002128217210ULL, 0x040fe20007ffe0ffULL,
0x0000000128197824ULL, 0x040fe200078e0219ULL, 0x0000001209007388ULL, 0x0005e20000000800ULL,
0x00000001281d7824ULL, 0x000fc400078e021dULL, 0x0000000128297824ULL, 0x040fe200078e0229ULL,
0x0000000f04007388ULL, 0x0005e20000000800ULL, 0x0000000128187824ULL, 0x040fe200078e021fULL,
0x0000002728087210ULL, 0x042fe20007ffe0ffULL, 0x00000001281a7824ULL, 0x040fe200078e0223ULL,
0x0000001419007388ULL, 0x0005e20000000800ULL, 0x0000000128257824ULL, 0x040fe400078e0225ULL,
0x00000001281c7824ULL, 0x040fe200078e022dULL, 0x0000000516007388ULL, 0x0005e20000000800ULL,
0x0000000128317824ULL, 0x000fc400078e0231ULL, 0x00000001282f7824ULL, 0x040fe200078e022fULL,
0x000000101d007388ULL, 0x0005e20000000800ULL, 0x0000000128287824ULL, 0x000fc600078e022bULL,
0x0000000c29007388ULL, 0x0005e80000000800ULL, 0x0000000318007388ULL, 0x0005e80000000800ULL,
0x0000000a21007388ULL, 0x0005e80000000800ULL, 0x0000000d1a007388ULL, 0x0005e80000000800ULL,
0x0000000225007388ULL, 0x0005e80000000800ULL, 0x0000001308007388ULL, 0x0005e80000000800ULL,
0x000000111c007388ULL, 0x0005e80000000800ULL, 0x0000000e2f007388ULL, 0x0005e80000000800ULL,
0x0000000b28007388ULL, 0x0005e80000000800ULL, 0x0000000631007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000187919ULL, 0x004ea20000000000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x000000035f5f7819ULL, 0x000fe200000006ffULL, 0x0000000000167919ULL, 0x000f220000002600ULL,
0x0000000405057899ULL, 0x000fc4000800063fULL, 0x1ffffff85f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000020181a7810ULL, 0x044fe20007ffe0ffULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x00000040181f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001016027824ULL, 0x050fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe20000011618ULL, 0x0000001016177824ULL, 0x000fe200078e00ffULL,
0x00000060181e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010161c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff037819ULL, 0x000fc4000001161aULL, 0x00000003ff147819ULL, 0x000fe4000001161fULL,
0xfffffff002027812ULL, 0x000fe400078ee205ULL, 0x00000003ff157819ULL, 0x000fe4000001161eULL,
0x0000000705057812ULL, 0x000fe400078e4818ULL, 0x0000000703047812ULL, 0x000fe400078e481aULL,
0x0000000714067812ULL, 0x000fc400078e481fULL, 0x0000000715087812ULL, 0x000fe400078e481eULL,
0x0ffffff8050b7812ULL, 0x000fe400078ef818ULL, 0x0ffffff804057812ULL, 0x000fe400078ef81aULL,
0x0ffffff806077812ULL, 0x000fe400078ef81fULL, 0x0ffffff808097812ULL, 0x002fe200078ef81eULL,
0x0000001005087824ULL, 0x100fe200078e0200ULL, 0x000000000b047211ULL, 0x000fe200078e20ffULL,
0x00000010070c7824ULL, 0x000fe200078e0200ULL, 0xfffffff017147812ULL, 0x000fe200078ee214ULL,
0x0000001009107824ULL, 0x000fe200078e0200ULL, 0xfffffff01c157812ULL, 0x000fe200078ee215ULL,
0x00a0000008087984ULL, 0x000fe20000000c00ULL, 0x0000001016007824ULL, 0x000fe200078e00ffULL,
0x0000000414177c10ULL, 0x000fc4000ff3e0ffULL, 0x00a0000004047984ULL, 0x000e620000000c00ULL,
0x000000075f1d7812ULL, 0x040fe400078ef81aULL, 0xfffffff000007812ULL, 0x000fe200078ee203ULL,
0x00a000000c0c7984ULL, 0x000ea20000000c00ULL, 0x0000000402037c10ULL, 0x000fe4000ff1e0ffULL,
0x000000ffff1a7210ULL, 0x000fe20000ffe4ffULL, 0x00a0000010107984ULL, 0x000ee20000000c00ULL,
0x000000075f1b7812ULL, 0x000fe200078ef818ULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x000fc400078048ffULL, 0x000000075f1f7812ULL, 0x000fe400078ef81fULL,
0x00005b0003037a11ULL, 0x000fe400000f4c16ULL, 0x00000004001c7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000415007c10ULL, 0x000fe2000ff5e0ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x00005a0017167a11ULL, 0x000fe400078248ffULL, 0x000000075f5f7812ULL, 0x000fe200078ef81eULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005a001c147a11ULL, 0x000fe200078048ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005a0000187a11ULL, 0x000fc400078448ffULL,
0x00005b001c157a11ULL, 0x000fe400000f4c15ULL, 0x00005b0017177a11ULL, 0x000fe400008f4c1aULL,
0x00005b0000197a11ULL, 0x000fe200010f4c19ULL, 0x000000101d147825ULL, 0x000fc800078e0014ULL,
0x000000101f167825ULL, 0x000fe200078e0016ULL, 0x0000000402007986ULL, 0x002fe6000c101d06ULL,
0x000000105f187825ULL, 0x000fe200078e0018ULL, 0x0000000814007986ULL, 0x000fe8000c101d06ULL,
0x0000000c16007986ULL, 0x004fe8000c101d06ULL, 0x0000001018007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000161007810ULL, 0x000fe20007ffe0ffULL,
0x0000000214037824ULL, 0x00afc400078e00ffULL, 0x000000405f5c7824ULL, 0x000fe200078e00ffULL,
0x0000005d0000720cULL, 0x000fe20003f06070ULL, 0x00005800035e7a24ULL, 0x000fe400078e025eULL,
0x0000010061077824ULL, 0x000fc800078e025cULL, 0x000062005e167a24ULL, 0x000fcc00078e0207ULL,
0x000005c000008947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0x00000200001f7802ULL, 0x000fe40000000f00ULL, 0x0000000760007217ULL, 0x000fe40007800000ULL,
0x000020005f127811ULL, 0x000fc600078e68ffULL, 0x0000000100007824ULL, 0x000fe200078e0a07ULL,
0x00000002ff1b7819ULL, 0x102fe2000001160dULL, 0x000000100d1d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff107819ULL, 0x000fe4000001160dULL, 0x000000081b0f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000116027824ULL, 0x040fe200078e021bULL, 0x000000181b237810ULL, 0x000fe40007ffe0ffULL,
0x000000301d1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000116047824ULL, 0x000fe200078e020fULL,
0x000000101b217810ULL, 0x040fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e001fULL,
0x000000201b157810ULL, 0x000fc40007ffe0ffULL, 0x0000002316087210ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001fULL, 0x0000001d020a7210ULL, 0x080fe40007f1e0ffULL,
0x0000000310107812ULL, 0x000fe200078e480dULL, 0x0000000116067824ULL, 0x000fe200078e0221ULL,
0x0000001d04047210ULL, 0x000fe20007f3e0ffULL, 0x0000000116027824ULL, 0x000fe200078e0215ULL,
0x000000281b177810ULL, 0x000fe20007ffe0ffULL, 0x00005e0008087625ULL, 0x000fe200078e001fULL,
0x0ffffffc100d7812ULL, 0x000fc400078ef80dULL, 0x000000301b197810ULL, 0x000fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e001fULL, 0x000000002100720cULL, 0x080fe40003fa6070ULL,
0x000000001500720cULL, 0x080fe20003f66070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0603ULL,
0x0000001d06067210ULL, 0x000fe20007f1e0ffULL, 0x00005e0002027625ULL, 0x000fe200078e001fULL,
0x000000002300720cULL, 0x080fe40003f86070ULL, 0x00000007ff077210ULL, 0x000fe200007fe4ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x0000001d08087210ULL, 0x080fe20007f3e0ffULL,
0x000000100d117824ULL, 0x000fe200078e0212ULL, 0x0000001d020c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000116027824ULL, 0x000fe200078e0217ULL, 0x000000001b00720cULL, 0x080fe20003f06070ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000000f00720cULL, 0x0c0fe20003f26070ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x000000381b1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0603ULL, 0x000000001700720cULL, 0x000fe20003f46070ULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0xfffffffc0f0f7812ULL, 0x000fc800078ee210ULL,
0x0000001d020e7210ULL, 0x000fe20007fde0ffULL, 0x0000000116027824ULL, 0x000fe200078e0219ULL,
0x000000120f137211ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a117faeULL, 0x0003e2000c101c46ULL, 0x000000001b00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0f7224ULL, 0x000fe400030e0603ULL, 0x00005e0002027625ULL, 0x000fe200078e001fULL,
0x0000000004137faeULL, 0x0005e2000c901c46ULL, 0x000000001900720cULL, 0x000fc60003f26070ULL,
0x0000001d02027210ULL, 0x000fe20007fde0ffULL, 0x00000004210b7824ULL, 0x002fe400078e00ffULL,
0x0000000423117824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0x0000000215137819ULL, 0x004fe200000006ffULL, 0x0000000116047824ULL, 0x000fe200078e021bULL,
0xfffffffc0b0b7812ULL, 0x100fe200078ee210ULL, 0x0000000417157824ULL, 0x000fe200078e00ffULL,
0xfffffffc11117812ULL, 0x100fe200078ee210ULL, 0x0000000419177824ULL, 0x000fe200078e00ffULL,
0x000000021b197819ULL, 0x000fe200000006ffULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0xfffffffc13137812ULL, 0x000fc400078ee210ULL, 0xfffffffc15157812ULL, 0x000fe200078ee210ULL,
0x000000100b0b7824ULL, 0x000fe200078e0212ULL, 0xfffffffc17177812ULL, 0x000fe200078ee210ULL,
0x0000001011117824ULL, 0x000fe200078e0212ULL, 0xfffffffc19197812ULL, 0x000fe200078ee210ULL,
0x0000001013137824ULL, 0x100fe200078e0212ULL, 0x0000001d04047210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x100fe200078e0212ULL, 0x0000001215157211ULL, 0x000fe200078e20ffULL,
0x0000001019197824ULL, 0x000fe200078e0212ULL, 0x00000000060b7faeULL, 0x0003e2000e901c46ULL,
0x000000ffff057224ULL, 0x000fc600030e0605ULL, 0x0000000008117faeULL, 0x0003e8000e101c46ULL,
0x000000000c137faeULL, 0x0003e8000d901c46ULL, 0x000000000e157faeULL, 0x0003e8000d101c46ULL,
0x0000000002177faeULL, 0x0003e8000c901c46ULL, 0x0000000004197faeULL, 0x0003e2000c101c46ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0x00000200ff217424ULL, 0x000fe200078e00ffULL, 0x000020005f1f7811ULL, 0x000fc400078e68ffULL,
0x000000040d047819ULL, 0x042fe400000006ffULL, 0x000000100d037811ULL, 0x040fe400078ff0ffULL,
0x000000160d027211ULL, 0x000fe400078ff0ffULL, 0x00000003ff007819ULL, 0x000fe2000001160dULL,
0x0000000403117824ULL, 0x000fe200078e00ffULL, 0x000000080d0b7811ULL, 0x040fe400078ff0ffULL,
0x0000003004237812ULL, 0x000fe200078ec0ffULL, 0x0000000116047824ULL, 0x000fe200078e0203ULL,
0x000000200d077811ULL, 0x040fe200078ff0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0021ULL,
0x000000180d057811ULL, 0x000fc400078ff0ffULL, 0x0000000300187812ULL, 0x000fe200078e480dULL,
0x0000000116007824ULL, 0x040fe200078e020bULL, 0x000000280d087811ULL, 0x000fe200078ff0ffULL,
0x000000040b0f7824ULL, 0x000fe200078e00ffULL, 0x000000300d097811ULL, 0x000fe200078ff0ffULL,
0x00000001160b7824ULL, 0x000fe200078e0207ULL, 0x00000023020c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x000000380d0a7811ULL, 0x000fe200078ff0ffULL,
0x0000000116127824ULL, 0x040fe200078e0208ULL, 0x0000000516067210ULL, 0x000fe20007ffe0ffULL,
0x0000000405057824ULL, 0x000fe200078e00ffULL, 0x0ffffffc18107812ULL, 0x000fe200078ef80dULL,
0x0000000116147824ULL, 0x000fe200078e0209ULL, 0x00000003ff0d7210ULL, 0x000fe200007fe4ffULL,
0x00005e0000027625ULL, 0x000fe200078e0021ULL, 0x0000000208137819ULL, 0x000fc400000006ffULL,
0xfffffffc070e7812ULL, 0x100fe200078ee218ULL, 0x0000000409157824ULL, 0x000fe200078e00ffULL,
0xfffffffc0f087812ULL, 0x000fe200078ee218ULL, 0x0000000116167824ULL, 0x000fe200078e020aULL,
0xfffffffc130f7812ULL, 0x100fe200078ee218ULL, 0x000000040a177824ULL, 0x000fe200078e00ffULL,
0xfffffffc050a7812ULL, 0x100fe200078ee218ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x0000001f0e197211ULL, 0x000fe400078e20ffULL, 0xfffffffc11097812ULL, 0x000fe200078ee218ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x00000023020e7210ULL, 0x000fc40007f1e0ffULL,
0xfffffffc15117812ULL, 0x100fe200078ee218ULL, 0x0000001010257824ULL, 0x100fe200078e021fULL,
0x0000002304107210ULL, 0x080fe20007f3e0ffULL, 0x000000100f1b7824ULL, 0x000fe200078e021fULL,
0xfffffffc17187812ULL, 0x000fe200078ee218ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0603ULL,
0x0000002306067210ULL, 0x000fe20007f1e0ffULL, 0x00000010111d7824ULL, 0x100fe200078e021fULL,
0x00000005ff117210ULL, 0x000fe20000ffe4ffULL, 0x00005e000b027625ULL, 0x000fe200078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c257faeULL, 0x0003e6000b901c46ULL,
0x0000001008137824ULL, 0x000fc400078e021fULL, 0x0000001009157824ULL, 0x100fe400078e021fULL,
0x00005e0012047625ULL, 0x080fe200078e0021ULL, 0x000000000e137faeULL, 0x0003e6000b901c46ULL,
0x00005e0014087625ULL, 0x000fe200078e0021ULL, 0x0000002304047210ULL, 0x080fe20007f3e0ffULL,
0x0000000010157faeULL, 0x0003e4000b901c46ULL, 0x000000100a177824ULL, 0x000fe200078e021fULL,
0x0000002308087210ULL, 0x000fe20007f5e0ffULL, 0x00005e00160a7625ULL, 0x000fc800078e0021ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000002302027210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x000000230a0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000000006177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000000bff0b7210ULL, 0x000fe20001ffe4ffULL,
0x00000010181f7824ULL, 0x000fc600078e021fULL, 0x0000000002197faeULL, 0x0003e8000b901c46ULL,
0x00000000041b7faeULL, 0x0003e8000b901c46ULL, 0x00000000081d7faeULL, 0x0003e8000b901c46ULL,
0x000000000a1f7faeULL, 0x0003e4000b901c46ULL, 0x01460400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x01460400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000005d6100720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000c7919ULL, 0x002e620000000000ULL, 0x000000105f5b7824ULL, 0x000fe200078e00ffULL,
0xffffffff5d5a7810ULL, 0x000fe40007ffe0ffULL, 0x00007610ff597816ULL, 0x000fe40000000059ULL,
0x00000100610b7824ULL, 0x008fe200078e025cULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000000b6000720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000161007810ULL, 0x000fe20007ffe0ffULL, 0x000009e000007945ULL, 0x000fe20003800000ULL,
0x000062005e697a24ULL, 0x000fe400078e020bULL, 0x0000005d0000720cULL, 0x000fe20003f06070ULL,
0x00000200ff0a7424ULL, 0x000fd800078e00ffULL, 0x0000052000008947ULL, 0x000fea0003800000ULL,
0x00000002ff087819ULL, 0x102fe4000001160cULL, 0x00000003ff037819ULL, 0x000fe4000001160cULL,
0x0000000808027810ULL, 0x040fe20007ffe0ffULL, 0x0000000108057824ULL, 0x100fe200078e0269ULL,
0x0000000c03097212ULL, 0x000fe400078e3cffULL, 0x8000000b60007210ULL, 0x000fe20007ffe0ffULL,
0x0000000102077824ULL, 0x000fe200078e0269ULL, 0x000000030c6b7812ULL, 0x000fe200078ec0ffULL,
0x00000004020e7824ULL, 0x000fe200078e00ffULL, 0x0000000309097812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x000fe200078e000aULL, 0x000000000800720cULL, 0x000fc40003f26070ULL,
0x000000000200720cULL, 0x000fe20003f46070ULL, 0x00005e0007067625ULL, 0x000fe200078e000aULL,
0x000000046b0d7812ULL, 0x000fe400078efcffULL, 0x000030005f027811ULL, 0x000fe400078e68ffULL,
0x0ffffffc096d7812ULL, 0x000fe200078ef80cULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0xfffffffc0e117812ULL, 0x000fe400078ee209ULL, 0x0000001008167810ULL, 0x040fe20007ffe0ffULL,
0x000000106d0f7824ULL, 0x000fe200078e0202ULL, 0x0000000211117211ULL, 0x000fe200078e20ffULL,
0x000000100d067825ULL, 0x000fe200078e0006ULL, 0x0000001808177810ULL, 0x000fc40007ffe0ffULL,
0x0000002008187810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e2000c901c46ULL, 0x0000002808197810ULL, 0x040fe40007ffe0ffULL,
0x00000030081a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000006117faeULL, 0x0005e2000d101c46ULL,
0x0000003808087810ULL, 0x000fe40007ffe0ffULL, 0x000000691a137210ULL, 0x000fe40007ffe0ffULL,
0x000000001600720cULL, 0x080fe20003f26070ULL, 0x0000000108157824ULL, 0x100fe200078e0269ULL,
0x000000001700720cULL, 0x080fe20003f46070ULL, 0x0000000116057824ULL, 0x102fe200078e0269ULL,
0x000000001800720cULL, 0x0c0fe20003f66070ULL, 0x00000001180f7824ULL, 0x100fe200078e0269ULL,
0x000000001900720cULL, 0x080fe20003f86070ULL, 0x0000000117077824ULL, 0x104fe200078e0269ULL,
0x000000001a00720cULL, 0x080fe20003fa6070ULL, 0x0000000119117824ULL, 0x000fe200078e0269ULL,
0x000000000800720cULL, 0x000fe20003fc6070ULL, 0x00005e0005047625ULL, 0x000fe200078e000aULL,
0x00000002191c7819ULL, 0x000fc600000006ffULL, 0x00005e0007067625ULL, 0x000fe200078e000aULL,
0xfffffffc1c1b7812ULL, 0x000fc600078ee209ULL, 0x00005e000f0e7625ULL, 0x000fc800078e000aULL,
0x00005e0011107625ULL, 0x000fc800078e000aULL, 0x00005e0013127625ULL, 0x000fc800078e000aULL,
0x00005e0015147625ULL, 0x000fc800078e000aULL, 0x0000000416167824ULL, 0x000fe400078e00ffULL,
0x0000000417007824ULL, 0x000fe400078e00ffULL, 0x0000000418187824ULL, 0x000fe400078e00ffULL,
0x000000100d047825ULL, 0x040fe200078e0004ULL, 0xfffffffc00177812ULL, 0x100fe400078ee209ULL,
0xfffffffc18197812ULL, 0x000fe200078ee209ULL, 0x000000100d067825ULL, 0x000fc600078e0006ULL,
0x0000000219197211ULL, 0x000fe200078e20ffULL, 0x000000100d0e7825ULL, 0x000fc800078e000eULL,
0x000000100d107825ULL, 0x000fc800078e0010ULL, 0x000000100d127825ULL, 0x000fc800078e0012ULL,
0x000000100d147825ULL, 0x000fe200078e0014ULL, 0xfffffffc160d7812ULL, 0x000fc600078ee209ULL,
0x000000041a1a7824ULL, 0x000fe400078e00ffULL, 0x0000000408087824ULL, 0x000fe400078e00ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0202ULL, 0xfffffffc1a1d7812ULL, 0x100fe200078ee209ULL,
0x0000001017177824ULL, 0x100fe200078e0202ULL, 0xfffffffc081f7812ULL, 0x000fe200078ee209ULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x00000000040d7faeULL, 0x0003e2000c901c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e0202ULL, 0x000000101f1f7824ULL, 0x000fe200078e0202ULL,
0x0000000006177faeULL, 0x0003e8000d101c46ULL, 0x000000000e197faeULL, 0x0003e8000d901c46ULL,
0x00000000101b7faeULL, 0x0003e8000e101c46ULL, 0x00000000121d7faeULL, 0x0003e8000e901c46ULL,
0x00000000141f7faeULL, 0x0003e2000f101c46ULL, 0x0000047000007947ULL, 0x000fea0003800000ULL,
0x000000100c1a7811ULL, 0x042fe400078ff0ffULL, 0x000000030c6b7812ULL, 0x000fc400078ec0ffULL,
0x000000691a097210ULL, 0x0c0fe20007ffe0ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0x000000080c027811ULL, 0x040fe400078ff0ffULL, 0x000000180c1c7811ULL, 0x040fe200078ff0ffULL,
0x00005e0009087625ULL, 0x000fe200078e000aULL, 0x000000200c1e7811ULL, 0x040fe400078ff0ffULL,
0x000000280c207811ULL, 0x000fe200078ff0ffULL, 0x0000000102077824ULL, 0x100fe200078e0269ULL,
0x000000300c227811ULL, 0x000fe200078ff0ffULL, 0x000000011c117824ULL, 0x100fe200078e0269ULL,
0x000000380c247811ULL, 0x000fe200078ff0ffULL, 0x000000011e137824ULL, 0x100fe200078e0269ULL,
0x000000046b0d7812ULL, 0x000fe200078efcffULL, 0x0000000120157824ULL, 0x100fe200078e0269ULL,
0x00000003ff037819ULL, 0x000fe2000001160cULL, 0x0000000122177824ULL, 0x000fe200078e0269ULL,
0x000000690c057211ULL, 0x080fe200078ff0ffULL, 0x000000100d0e7825ULL, 0x000fe200078e0008ULL,
0x0000006924197210ULL, 0x000fc40007ffe0ffULL, 0x0000000c03097212ULL, 0x000fe200078e3cffULL,
0x00005e0005047625ULL, 0x080fe200078e000aULL, 0x000030005f007811ULL, 0x000fe400078e68ffULL,
0x0000000309097812ULL, 0x000fe200078ec0ffULL, 0x00005e0007067625ULL, 0x080fe200078e000aULL,
0x0000000220207819ULL, 0x000fe400000006ffULL, 0x0ffffffc096d7812ULL, 0x000fe200078ef80cULL,
0x00005e0011107625ULL, 0x000fe200078e000aULL, 0xfffffffc1a1b7812ULL, 0x000fc400078ee209ULL,
0xfffffffc20217812ULL, 0x000fe200078ee209ULL, 0x00005e0013127625ULL, 0x000fc800078e000aULL,
0x00005e0015147625ULL, 0x000fc800078e000aULL, 0x00005e0017167625ULL, 0x000fc800078e000aULL,
0x00005e0019187625ULL, 0x000fc800078e000aULL, 0x0000000402027824ULL, 0x000fe400078e00ffULL,
0x000000041c1c7824ULL, 0x000fe400078e00ffULL, 0x000000041e1e7824ULL, 0x000fe400078e00ffULL,
0x000000100d047825ULL, 0x040fe200078e0004ULL, 0xfffffffc1c1d7812ULL, 0x100fe400078ee209ULL,
0xfffffffc1e1f7812ULL, 0x000fe200078ee209ULL, 0x000000100d067825ULL, 0x000fe200078e0006ULL,
0x000000001d1d7211ULL, 0x000fc600078e20ffULL, 0x000000100d107825ULL, 0x000fc800078e0010ULL,
0x000000100d127825ULL, 0x000fc800078e0012ULL, 0x000000100d147825ULL, 0x000fc800078e0014ULL,
0x000000100d167825ULL, 0x000fc800078e0016ULL, 0x000000100d187825ULL, 0x000fe200078e0018ULL,
0xfffffffc020d7812ULL, 0x000fc600078ee209ULL, 0x0000000422227824ULL, 0x000fe400078e00ffULL,
0x0000000424247824ULL, 0x000fe400078e00ffULL, 0x000000106d277824ULL, 0x100fe200078e0200ULL,
0xfffffffc22237812ULL, 0x100fe200078ee209ULL, 0x000000100d0d7824ULL, 0x100fe200078e0200ULL,
0xfffffffc24257812ULL, 0x000fe200078ee209ULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004277faeULL, 0x0003e2000b901c46ULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x0000000025257211ULL, 0x000fe200078e20ffULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x00000000060d7faeULL, 0x0003e2000b901c46ULL,
0x0000001023237824ULL, 0x000fc600078e0200ULL, 0x000000000e1b7faeULL, 0x0003e8000b901c46ULL,
0x00000000101d7faeULL, 0x0003e8000b901c46ULL, 0x00000000121f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014217faeULL, 0x0003e8000b901c46ULL, 0x0000000016237faeULL, 0x0003e8000b901c46ULL,
0x0000000018257faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000070c057812ULL, 0x002fc400078ec0ffULL,
0x00000004ff087819ULL, 0x100fe4000001160cULL, 0x0000000805077812ULL, 0x000fc800078ef80cULL,
0x0000000708007812ULL, 0x000fca00078e7807ULL, 0x0000002007007824ULL, 0x000fc800078e0200ULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000000808027824ULL, 0x040fe200078e00ffULL,
0x00000000002c783bULL, 0x0003e20000000200ULL, 0x000020005f6c7824ULL, 0x000fe200078e00ffULL,
0x0000000208187810ULL, 0x000fe20007ffe0ffULL, 0x00000d5000007945ULL, 0x000fe20003800000ULL,
0xfffffff802027812ULL, 0x000fe400078ee205ULL, 0x000020006c587810ULL, 0x000fe40007ffe0ffULL,
0x0000001002057810ULL, 0x040fe40007ffe0ffULL, 0x00000020020d7810ULL, 0x000fc40007ffe0ffULL,
0x00000030020f7810ULL, 0x040fe20007ffe0ffULL, 0x00000004050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fe20000011602ULL, 0x000000040d127824ULL, 0x000fe200078e00ffULL,
0x0000000202067819ULL, 0x000fe200000006ffULL, 0x000000040f167824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe40000011605ULL, 0x00000001ff057819ULL, 0x000fe4000001160dULL,
0x00000001ff0d7819ULL, 0x000fc4000001160fULL, 0x0000000304047812ULL, 0x000fe400078ec0ffULL,
0x0000000305107812ULL, 0x000fe400078ec0ffULL, 0x0000000302027812ULL, 0x000fe400078ec0ffULL,
0x000000030d147812ULL, 0x000fe400078ec0ffULL, 0x0000000104477812ULL, 0x100fe400078e7803ULL,
0x0000000110457812ULL, 0x000fc400078e7803ULL, 0x00000001020d7812ULL, 0x100fe400078e7803ULL,
0x0000000114057812ULL, 0x000fe400078e7803ULL, 0x0000000647477212ULL, 0x000fe400078efcffULL,
0x0000001245457212ULL, 0x000fe400078efcffULL, 0x0000000e0d0d7212ULL, 0x000fe200078efcffULL,
0x00000010476a7824ULL, 0x100fe200078e0258ULL, 0x0000001605057212ULL, 0x000fe200078efcffULL,
0x0000001045677824ULL, 0x000fe200078e0258ULL, 0x000000580d687211ULL, 0x000fc400078e20ffULL,
0x000000006a38783bULL, 0x000ea20000000200ULL, 0x0000001005667824ULL, 0x000fe200078e0258ULL,
0x0000000103037812ULL, 0x000fe400078ec0ffULL, 0x000000006834783bULL, 0x000ee20000000200ULL,
0x0000000718187812ULL, 0x000fe400078e7807ULL, 0x00000002020f7812ULL, 0x100fe200078e1e03ULL,
0x000000006730783bULL, 0x000f220000000200ULL, 0x0000000210717812ULL, 0x100fe200078e1e03ULL,
0x0000002007007824ULL, 0x002fe200078e0218ULL, 0x0000000204737812ULL, 0x100fe200078e1e03ULL,
0x000000006640783bULL, 0x000e620000000200ULL, 0x00000002146f7812ULL, 0x000fe200078e1e03ULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x0000000e0f037212ULL, 0x000fc400078efcffULL,
0x0000001271717212ULL, 0x000fe400078efcffULL, 0x0000000673737212ULL, 0x000fe200078efcffULL,
0x0000001003647824ULL, 0x100fe200078e0258ULL, 0x000000166f6f7212ULL, 0x000fe200078efcffULL,
0x0000001071637824ULL, 0x100fe200078e0258ULL, 0x0000005873657211ULL, 0x000fe200078e20ffULL,
0x000000000018783bULL, 0x000fe40000000200ULL, 0x000000106f627824ULL, 0x000fe400078e0258ULL,
0x00000000653c783bULL, 0x000f680000000200ULL, 0x000000006428783bULL, 0x000e680000000200ULL,
0x000000006320783bULL, 0x000e680000000200ULL, 0x000000006210783bULL, 0x000e620000000200ULL,
0x000000382c24723cULL, 0x044ff000000418ffULL, 0x000000342c4c723cULL, 0x048ff000000418ffULL,
0x000000302c14723cULL, 0x050ff000000418ffULL, 0x0000003a2c38723cULL, 0x040ff000000418ffULL,
0x000000362c34723cULL, 0x040ff000000418ffULL, 0x000000322c30723cULL, 0x040ff000000418ffULL,
0x000000402c1c723cULL, 0x042ff000000418ffULL, 0x000000422c2c723cULL, 0x000ff000000418ffULL,
0x0000003c1824723cULL, 0x060ff00000041824ULL, 0x00000028184c723cULL, 0x040ff0000004184cULL,
0x000000201814723cULL, 0x040ff00000041814ULL, 0x0000003e183c723cULL, 0x040ff00000041838ULL,
0x0000002a1828723cULL, 0x040ff00000041834ULL, 0x000000221820723cULL, 0x040ff00000041830ULL,
0x00000010181c723cULL, 0x040ff0000004181cULL, 0x000000121818723cULL, 0x000fe2000004182cULL,
0x000004c000008947ULL, 0x000fee0003800000ULL, 0x00000002ff027819ULL, 0x000fe2000001160cULL,
0x0000000160007824ULL, 0x000fe200078e0a0bULL, 0x000000086b357812ULL, 0x000fe200078efcffULL,
0x000000106d0f7824ULL, 0x000fe200078e0258ULL, 0x0000000802047810ULL, 0x000fc40007ffe0ffULL,
0x0000006902117210ULL, 0x000fe40007ffe0ffULL, 0x000000000400720cULL, 0x0c0fe20003f46070ULL,
0x0000000104137824ULL, 0x000fe200078e0269ULL, 0x000000000200720cULL, 0x000fe20003f26070ULL,
0x0000000404047824ULL, 0x000fe200078e00ffULL, 0x0000001802067810ULL, 0x040fe20007ffe0ffULL,
0x00005e0011107625ULL, 0x080fe200078e000aULL, 0x00000020020e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc042d7812ULL, 0x000fe200078ee209ULL, 0x00005e0013127625ULL, 0x000fe200078e000aULL,
0x0000001002047810ULL, 0x000fc40007ffe0ffULL, 0x0000002802347810ULL, 0x040fe20007ffe0ffULL,
0x0000001035107825ULL, 0x000fe200078e0010ULL, 0x0000003002367810ULL, 0x040fe40007ffe0ffULL,
0x0000003802027810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0258ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e2000c901c46ULL,
0x0000001035127825ULL, 0x000fe200078e0012ULL, 0x000000000400720cULL, 0x080fe40003f26070ULL,
0x00000069362f7210ULL, 0x000fe20007ffe0ffULL, 0x000000010e337824ULL, 0x100fe200078e0269ULL,
0x00000000122d7faeULL, 0x0005e2000d101c46ULL, 0x0000000134317824ULL, 0x000fe200078e0269ULL,
0x000000000600720cULL, 0x000fe20003f46070ULL, 0x00005e0033327625ULL, 0x000fe200078e000aULL,
0x000000000e00720cULL, 0x000fc40003f66070ULL, 0x000000003600720cULL, 0x080fe20003fa6070ULL,
0x0000000106117824ULL, 0x102fe200078e0269ULL, 0x000000003400720cULL, 0x000fe20003f86070ULL,
0x00005e0031307625ULL, 0x000fe200078e000aULL, 0x000000000200720cULL, 0x000fe40003fc6070ULL,
0x0000006904137210ULL, 0x044fe20007ffe0ffULL, 0x0000000404047824ULL, 0x000fe200078e00ffULL,
0x0000000234347819ULL, 0x000fe200000006ffULL, 0x00000001022d7824ULL, 0x000fe400078e0269ULL,
0x00005e0013127625ULL, 0x000fe200078e000aULL, 0xfffffffc04377812ULL, 0x000fc400078ee209ULL,
0xfffffffc343b7812ULL, 0x000fe200078ee209ULL, 0x00005e0011107625ULL, 0x000fc800078e000aULL,
0x00005e002f2e7625ULL, 0x000fc800078e000aULL, 0x00005e002d2c7625ULL, 0x000fc800078e000aULL,
0x0000000406067824ULL, 0x000fe400078e00ffULL, 0x000000040e0e7824ULL, 0x000fe400078e00ffULL,
0x0000000436367824ULL, 0x000fe400078e00ffULL, 0x0000001037377824ULL, 0x000fe200078e0258ULL,
0xfffffffc0e397812ULL, 0x000fe200078ee209ULL, 0x0000001035127825ULL, 0x000fe200078e0012ULL,
0xfffffffc36417812ULL, 0x000fc600078ee209ULL, 0x0000001035107825ULL, 0x040fe200078e0010ULL,
0x0000000012377faeULL, 0x0003e6000c901c46ULL, 0x0000001035327825ULL, 0x000fc800078e0032ULL,
0x0000001035307825ULL, 0x000fc800078e0030ULL, 0x00000010352e7825ULL, 0x000fe200078e002eULL,
0x000000583b377211ULL, 0x002fc600078e20ffULL, 0x00000010352c7825ULL, 0x000fe200078e002cULL,
0xfffffffc06357812ULL, 0x000fc600078ee209ULL, 0x0000000402027824ULL, 0x000fe400078e00ffULL,
0x0000001035137824ULL, 0x100fe400078e0258ULL, 0x0000001039357824ULL, 0x100fe200078e0258ULL,
0xfffffffc02437812ULL, 0x000fe200078ee209ULL, 0x0000001041397824ULL, 0x100fe200078e0258ULL,
0x0000000010137faeULL, 0x0003e6000d101c46ULL, 0x00000010433b7824ULL, 0x000fe200078e0258ULL,
0x0000000032357faeULL, 0x0003e8000d901c46ULL, 0x0000000030377faeULL, 0x0003e8000e101c46ULL,
0x000000002e397faeULL, 0x0003e8000e901c46ULL, 0x000000002c3b7faeULL, 0x0003e2000f101c46ULL,
0x0000041000007947ULL, 0x000fea0003800000ULL, 0x000000690c117211ULL, 0x000fe200078ff0ffULL,
0x000000106d0f7824ULL, 0x000fe200078e0258ULL, 0x000000086b3b7812ULL, 0x000fc400078efcffULL,
0x000000080c007811ULL, 0x040fe200078ff0ffULL, 0x00005e0011107625ULL, 0x080fe200078e000aULL,
0x000000100c027811ULL, 0x040fe400078ff0ffULL, 0x000000180c047811ULL, 0x000fe200078ff0ffULL,
0x0000000100137824ULL, 0x000fe200078e0269ULL, 0x000000200c067811ULL, 0x040fe200078ff0ffULL,
0x000000103b107825ULL, 0x000fe200078e0010ULL, 0x000000280c0e7811ULL, 0x040fe400078ff0ffULL,
0x000000300c367811ULL, 0x000fe200078ff0ffULL, 0x00000001022d7824ULL, 0x100fe200078e0269ULL,
0x000000380c387811ULL, 0x000fe200078ff0ffULL, 0x0000000402027824ULL, 0x000fe200078e00ffULL,
0x000000690e317210ULL, 0x000fe20007ffe0ffULL, 0x0000000104337824ULL, 0x100fe200078e0269ULL,
0x0000000200007819ULL, 0x000fe200000006ffULL, 0x0000000106357824ULL, 0x100fe200078e0269ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e2000b901c46ULL,
0x00000001362f7824ULL, 0x000fe200078e0269ULL, 0xfffffffc00377812ULL, 0x000fe200078ee209ULL,
0x0000000138417824ULL, 0x000fe200078e0269ULL, 0xfffffffc02397812ULL, 0x000fe200078ee209ULL,
0x00005e002d2c7625ULL, 0x000fe200078e000aULL, 0x0000000204047819ULL, 0x000fc600000006ffULL,
0x00005e0033327625ULL, 0x000fc800078e000aULL, 0x00005e0013107625ULL, 0x002fc800078e000aULL,
0x00005e0035347625ULL, 0x000fc800078e000aULL, 0x00005e0031307625ULL, 0x000fc800078e000aULL,
0x00005e002f2e7625ULL, 0x000fc800078e000aULL, 0x00005e0041127625ULL, 0x000fc800078e000aULL,
0x0000000406067824ULL, 0x000fe400078e00ffULL, 0x000000040e0e7824ULL, 0x000fe400078e00ffULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0xfffffffc06417812ULL, 0x100fe200078ee209ULL,
0x0000001037377824ULL, 0x000fe200078e0258ULL, 0xfffffffc0e437812ULL, 0x000fe200078ee209ULL,
0x000000103b107825ULL, 0x000fe200078e0010ULL, 0xfffffffc36497812ULL, 0x000fc600078ee209ULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x0000000010377faeULL, 0x0003e2000b901c46ULL,
0x0000001039397824ULL, 0x000fe400078e0258ULL, 0x000000103b2c7825ULL, 0x000fe200078e002cULL,
0xfffffffc384b7812ULL, 0x000fc600078ee209ULL, 0x000000103b327825ULL, 0x040fe200078e0032ULL,
0x000000002c397faeULL, 0x0005e6000b901c46ULL, 0x000000103b347825ULL, 0x000fc800078e0034ULL,
0x000000103b307825ULL, 0x000fc800078e0030ULL, 0x000000103b2e7825ULL, 0x000fc800078e002eULL,
0x000000103b127825ULL, 0x000fe200078e0012ULL, 0xfffffffc043b7812ULL, 0x000fc600078ee209ULL,
0x00000010412d7824ULL, 0x104fe200078e0258ULL, 0x000000583b117211ULL, 0x002fe200078e20ffULL,
0x0000001043377824ULL, 0x100fe400078e0258ULL, 0x0000001049397824ULL, 0x100fe400078e0258ULL,
0x000000104b3b7824ULL, 0x000fe200078e0258ULL, 0x0000000032117faeULL, 0x0003e8000b901c46ULL,
0x00000000342d7faeULL, 0x0003e8000b901c46ULL, 0x0000000030377faeULL, 0x0003e8000b901c46ULL,
0x000000002e397faeULL, 0x0003e8000b901c46ULL, 0x00000000123b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000408007810ULL, 0x000fe20007ffe0ffULL, 0x00000ba000007945ULL, 0x000fe20003800000ULL,
0x000030006c6c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000700007812ULL, 0x100fe400078e7807ULL,
0x0000006c05057211ULL, 0x000fe200078e20ffULL, 0x00000010470e7824ULL, 0x100fe200078e026cULL,
0x0000000007007211ULL, 0x000fe200078e28ffULL, 0x000000100d0d7824ULL, 0x100fe200078e026cULL,
0x0000000608027810ULL, 0x000fe20007ffe0ffULL, 0x0000001045067824ULL, 0x100fe400078e026cULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x000fe200078e7807ULL,
0x0000001073047824ULL, 0x000fc400078e026cULL, 0x0000001003037824ULL, 0x000fe400078e026cULL,
0x0000002007027824ULL, 0x000fe200078e0202ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000e54783bULL, 0x000fe20000000200ULL, 0x00000010022c7824ULL, 0x002fe200078e00ffULL,
0x0000006c71027211ULL, 0x000fe400078e20ffULL, 0x000000000040783bULL, 0x0002a80000000200ULL,
0x000000000d50783bULL, 0x000ee80000000200ULL, 0x000000000648783bULL, 0x000f220000000200ULL,
0x000000106f007824ULL, 0x002fc600078e026cULL, 0x000000000544783bULL, 0x000e680000000200ULL,
0x000000000438783bULL, 0x000fe80000000200ULL, 0x000000002c2c783bULL, 0x000f680000000200ULL,
0x000000000334783bULL, 0x000e680000000200ULL, 0x000000000230783bULL, 0x000e680000000200ULL,
0x000000000010783bULL, 0x000e620000000200ULL, 0x000000544024723cULL, 0x044ff00000041824ULL,
0x00000050404c723cULL, 0x048ff0000004184cULL, 0x000000484014723cULL, 0x050ff00000041814ULL,
0x00000056403c723cULL, 0x040ff0000004183cULL, 0x000000524028723cULL, 0x040ff00000041828ULL,
0x0000004a4020723cULL, 0x040ff00000041820ULL, 0x00000044401c723cULL, 0x042ff0000004181cULL,
0x000000464018723cULL, 0x000ff00000041818ULL, 0x000000382c24723cULL, 0x060ff00000041824ULL,
0x000000342c4c723cULL, 0x040ff0000004184cULL, 0x000000302c14723cULL, 0x040ff00000041814ULL,
0x0000003a2c38723cULL, 0x040ff0000004183cULL, 0x000000362c34723cULL, 0x040ff00000041828ULL,
0x000000322c30723cULL, 0x040ff00000041820ULL, 0x000000102c1c723cULL, 0x040ff0000004181cULL,
0x000000122c2c723cULL, 0x000fe20000041818ULL, 0x000004c000008947ULL, 0x000fee0003800000ULL,
0x00000002ff1a7819ULL, 0x000fe2000001160cULL, 0x0000000160187824ULL, 0x000fe200078e0a0bULL,
0x0000000c6b297812ULL, 0x000fe200078efcffULL, 0x000000106d6d7824ULL, 0x000fe200078e026cULL,
0x000000081a107810ULL, 0x040fe20007ffe0ffULL, 0x000000011a137824ULL, 0x040fe200078e0269ULL,
0x000000181a00720cULL, 0x000fc40003f26070ULL, 0x0000000210207819ULL, 0x040fe200000006ffULL,
0x0000000110117824ULL, 0x040fe200078e0269ULL, 0x000000181000720cULL, 0x000fe20003f46070ULL,
0x00005e0013127625ULL, 0x080fe200078e000aULL, 0xfffffffc20197812ULL, 0x000fe400078ee209ULL,
0x000000101a1b7810ULL, 0x040fe20007ffe0ffULL, 0x00005e0011107625ULL, 0x000fe200078e000aULL,
0x000000181a287810ULL, 0x040fe40007ffe0ffULL, 0x000000201a2a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001029127825ULL, 0x000fe200078e0012ULL, 0x000000281a3c7810ULL, 0x000fc40007ffe0ffULL,
0x000000301a3d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001019197824ULL, 0x000fe200078e026cULL,
0x000000381a3e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001029107825ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000126d7faeULL, 0x0003e2000c901c46ULL,
0x000000181b00720cULL, 0x080fe40003f26070ULL, 0x000000012a237824ULL, 0x100fe200078e0269ULL,
0x0000000010197faeULL, 0x0005e2000d101c46ULL, 0x000000013c217824ULL, 0x000fe200078e0269ULL,
0x000000182800720cULL, 0x000fe20003f46070ULL, 0x00005e0023227625ULL, 0x000fe200078e000aULL,
0x000000182a00720cULL, 0x000fc40003f66070ULL, 0x000000183c00720cULL, 0x000fe20003f86070ULL,
0x00005e0021207625ULL, 0x000fe200078e000aULL, 0x000000183d00720cULL, 0x080fe40003fa6070ULL,
0x000000183e00720cULL, 0x000fe20003fc6070ULL, 0x000000011b137824ULL, 0x142fe200078e0269ULL,
0x0000006928117210ULL, 0x004fe20007ffe0ffULL, 0x000000041b107824ULL, 0x000fe400078e00ffULL,
0x000000013d1b7824ULL, 0x100fe400078e0269ULL, 0x000000013e197824ULL, 0x000fe200078e0269ULL,
0xfffffffc102b7812ULL, 0x000fe200078ee209ULL, 0x00005e0013127625ULL, 0x000fe200078e000aULL,
0x000000023e3e7819ULL, 0x000fc400000006ffULL, 0x0000006c2b2b7211ULL, 0x000fe200078e20ffULL,
0x00005e0011107625ULL, 0x000fe200078e000aULL, 0xfffffffc3e437812ULL, 0x000fc600078ee209ULL,
0x00005e001b1a7625ULL, 0x000fc800078e000aULL, 0x00005e0019187625ULL, 0x000fc800078e000aULL,
0x0000000428287824ULL, 0x000fe400078e00ffULL, 0x000000042a2a7824ULL, 0x000fe400078e00ffULL,
0x000000043c3c7824ULL, 0x000fe400078e00ffULL, 0x000000043d407824ULL, 0x000fe200078e00ffULL,
0xfffffffc2a3d7812ULL, 0x000fe200078ee209ULL, 0x0000001029127825ULL, 0x040fe200078e0012ULL,
0xfffffffc3c3f7812ULL, 0x100fe400078ee209ULL, 0xfffffffc40417812ULL, 0x000fe200078ee209ULL,
0x0000001029107825ULL, 0x040fe200078e0010ULL, 0x00000000122b7faeULL, 0x0003e6000c901c46ULL,
0x0000001029227825ULL, 0x000fc800078e0022ULL, 0x0000001029207825ULL, 0x000fc800078e0020ULL,
0x00000010291a7825ULL, 0x000fc800078e001aULL, 0x0000001029187825ULL, 0x000fe200078e0018ULL,
0xfffffffc28297812ULL, 0x000fc600078ee209ULL, 0x000000103f2b7824ULL, 0x102fe200078e026cULL,
0x0000006c433f7211ULL, 0x000fe200078e20ffULL, 0x0000001029137824ULL, 0x100fe400078e026cULL,
0x000000103d297824ULL, 0x100fe400078e026cULL, 0x00000010413d7824ULL, 0x000fe200078e026cULL,
0x0000000010137faeULL, 0x0003e8000d101c46ULL, 0x0000000022297faeULL, 0x0003e8000d901c46ULL,
0x00000000202b7faeULL, 0x0003e8000e101c46ULL, 0x000000001a3d7faeULL, 0x0003e8000e901c46ULL,
0x00000000183f7faeULL, 0x0003e2000f101c46ULL, 0x0000041000007947ULL, 0x000fea0003800000ULL,
0x000000690c117211ULL, 0x000fe200078ff0ffULL, 0x000000106d6d7824ULL, 0x000fe200078e026cULL,
0x0000000c6b3f7812ULL, 0x000fc400078efcffULL, 0x000000080c127811ULL, 0x040fe200078ff0ffULL,
0x00005e0011107625ULL, 0x080fe200078e000aULL, 0x000000100c187811ULL, 0x040fe400078ff0ffULL,
0x000000180c2a7811ULL, 0x000fe200078ff0ffULL, 0x0000000112137824ULL, 0x000fe200078e0269ULL,
0x000000200c3c7811ULL, 0x040fe200078ff0ffULL, 0x000000103f107825ULL, 0x000fe200078e0010ULL,
0x000000280c3e7811ULL, 0x040fe400078ff0ffULL, 0x000000300c407811ULL, 0x000fe200078ff0ffULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x000000380c427811ULL, 0x000fe200078ff0ffULL,
0x0000000118197824ULL, 0x140fe200078e0269ULL, 0x0000000218187819ULL, 0x000fe200000006ffULL,
0x000000012a237824ULL, 0x100fe200078e0269ULL, 0x0000006942417210ULL, 0x000fe20007ffe0ffULL,
0x000000013c297824ULL, 0x100fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000106d7faeULL, 0x0003e2000b901c46ULL, 0x000000013e217824ULL, 0x000fe200078e0269ULL,
0xfffffffc122b7812ULL, 0x000fe200078ee209ULL, 0x00000001401b7824ULL, 0x000fe200078e0269ULL,
0xfffffffc183d7812ULL, 0x000fe200078ee209ULL, 0x00005e0019187625ULL, 0x000fe200078e000aULL,
0x000000023e3e7819ULL, 0x000fc600000006ffULL, 0x00005e0023227625ULL, 0x000fe200078e000aULL,
0xfffffffc3e437812ULL, 0x000fc600078ee209ULL, 0x00005e0013107625ULL, 0x002fc800078e000aULL,
0x00005e0029287625ULL, 0x000fc800078e000aULL, 0x00005e0021207625ULL, 0x000fc800078e000aULL,
0x00005e001b1a7625ULL, 0x000fc800078e000aULL, 0x00005e0041127625ULL, 0x000fc800078e000aULL,
0x000000042a2a7824ULL, 0x000fe400078e00ffULL, 0x000000043c3c7824ULL, 0x000fe400078e00ffULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x000000102b2b7824ULL, 0x000fe200078e026cULL,
0xfffffffc3c417812ULL, 0x000fe200078ee209ULL, 0x000000103f107825ULL, 0x000fe200078e0010ULL,
0xfffffffc40457812ULL, 0x000fc600078ee209ULL, 0x000000103f187825ULL, 0x040fe200078e0018ULL,
0x00000000102b7faeULL, 0x0003e6000b901c46ULL, 0x000000103f227825ULL, 0x000fc800078e0022ULL,
0x000000103f287825ULL, 0x000fc800078e0028ULL, 0x000000103f207825ULL, 0x000fe200078e0020ULL,
0x0000006c432b7211ULL, 0x002fc600078e20ffULL, 0x000000103f1a7825ULL, 0x000fc800078e001aULL,
0x000000103f127825ULL, 0x000fe200078e0012ULL, 0xfffffffc2a3f7812ULL, 0x000fc600078ee209ULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x000000103d3d7824ULL, 0x100fe400078e026cULL,
0x000000103f117824ULL, 0x100fe200078e026cULL, 0xfffffffc42477812ULL, 0x000fe400078ee209ULL,
0x00000000183d7faeULL, 0x0003e6000b901c46ULL, 0x00000010473f7824ULL, 0x100fe200078e026cULL,
0x0000000022117faeULL, 0x0005e2000b901c46ULL, 0x0000001041197824ULL, 0x002fc400078e026cULL,
0x00000010453d7824ULL, 0x000fc600078e026cULL, 0x0000000028197faeULL, 0x0005e8000b901c46ULL,
0x00000000202b7faeULL, 0x0005e8000b901c46ULL, 0x000000001a3d7faeULL, 0x0005e8000b901c46ULL,
0x00000000123f7faeULL, 0x0005e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000808107810ULL, 0x002fe20007ffe0ffULL,
0x00000af000007945ULL, 0x000fe60003800000ULL, 0x0000000710107812ULL, 0x000fca00078e7807ULL,
0x0000002007107824ULL, 0x000fc800078e0210ULL, 0x00000010103c7824ULL, 0x000fe200078e00ffULL,
0x0000000a08107810ULL, 0x000fc80007ffe0ffULL, 0x0000000710107812ULL, 0x000fc800078e7807ULL,
0x0000001007107211ULL, 0x000fe200078e28ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006a54783bULL, 0x000fe20000000200ULL, 0x0000001010207824ULL, 0x004fc600078e00ffULL,
0x000000003c3c783bULL, 0x000e680000000200ULL, 0x000000006848783bULL, 0x000ea80000000200ULL,
0x000000006744783bULL, 0x000ee80000000200ULL, 0x000000006640783bULL, 0x000f280000000200ULL,
0x000000006550783bULL, 0x000fe80000000200ULL, 0x000000002020783bULL, 0x000f680000000200ULL,
0x000000006410783bULL, 0x000f280000000200ULL, 0x000000006318783bULL, 0x000f280000000200ULL,
0x000000006228783bULL, 0x000f220000000200ULL, 0x000000543c24723cULL, 0x042ff00000041824ULL,
0x000000483c4c723cULL, 0x044ff0000004184cULL, 0x000000443c14723cULL, 0x048ff00000041814ULL,
0x000000563c38723cULL, 0x040ff00000041838ULL, 0x0000004a3c34723cULL, 0x040ff00000041834ULL,
0x000000463c30723cULL, 0x040ff00000041830ULL, 0x000000403c1c723cULL, 0x050ff0000004181cULL,
0x000000423c2c723cULL, 0x000ff0000004182cULL, 0x000000502024723cULL, 0x060ff00000041824ULL,
0x00000010204c723cULL, 0x040ff0000004184cULL, 0x000000182014723cULL, 0x040ff00000041814ULL,
0x000000522050723cULL, 0x040ff00000041838ULL, 0x000000122010723cULL, 0x040ff00000041834ULL,
0x0000001a2018723cULL, 0x040ff00000041830ULL, 0x00000028201c723cULL, 0x040ff0000004181cULL,
0x0000002a2020723cULL, 0x000fe2000004182cULL, 0x000004b000008947ULL, 0x000fee0003800000ULL,
0x00000002ff2d7819ULL, 0x000fe2000001160cULL, 0x00000001602c7824ULL, 0x000fe200078e0a0bULL,
0x000000106b357812ULL, 0x000fc400078efcffULL, 0x000000082d287810ULL, 0x040fe20007ffe0ffULL,
0x000000012d297824ULL, 0x140fe200078e0269ULL, 0x0000002c2d00720cULL, 0x080fe40003f26070ULL,
0x0000002c2800720cULL, 0x040fe20003f46070ULL, 0x00000001282b7824ULL, 0x040fe200078e0269ULL,
0x00000002282e7819ULL, 0x000fe200000006ffULL, 0x00005e0029287625ULL, 0x080fe200078e000aULL,
0x000000182d347810ULL, 0x000fe40007ffe0ffULL, 0xfffffffc2e2f7812ULL, 0x000fe200078ee209ULL,
0x00005e002b2a7625ULL, 0x000fe200078e000aULL, 0x000000102d2e7810ULL, 0x000fc40007ffe0ffULL,
0x000000202d367810ULL, 0x000fe20007ffe0ffULL, 0x0000001035287825ULL, 0x000fe200078e0028ULL,
0x000000282d387810ULL, 0x040fe40007ffe0ffULL, 0x000000302d397810ULL, 0x000fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0258ULL, 0x000000382d3a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010352a7825ULL, 0x000fe200078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000280f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2e00720cULL, 0x0c0fe40003f26070ULL,
0x000000012e2d7824ULL, 0x140fe200078e0269ULL, 0x000000002a2f7faeULL, 0x0005e2000d101c46ULL,
0x000000042e2e7824ULL, 0x000fe200078e00ffULL, 0x0000006936337210ULL, 0x000fe20007ffe0ffULL,
0x0000000138317824ULL, 0x000fe200078e0269ULL, 0x0000002c3400720cULL, 0x080fe20003f46070ULL,
0x00000004393c7824ULL, 0x000fe200078e00ffULL, 0x0000002c3600720cULL, 0x000fe20003f66070ULL,
0x00005e0033327625ULL, 0x000fe200078e000aULL, 0x0000002c3800720cULL, 0x000fc40003f86070ULL,
0x0000002c3900720cULL, 0x0c0fe20003fa6070ULL, 0x0000000139297824ULL, 0x102fe200078e0269ULL,
0x0000002c3a00720cULL, 0x000fe20003fc6070ULL, 0x00000001342f7824ULL, 0x004fe200078e0269ULL,
0xfffffffc2e377812ULL, 0x000fe200078ee209ULL, 0x000000013a2b7824ULL, 0x000fe200078e0269ULL,
0x0000000234347819ULL, 0x000fe200000006ffULL, 0x00005e002d2c7625ULL, 0x000fe200078e000aULL,
0xfffffffc3c3d7812ULL, 0x000fc600078ee209ULL, 0x00005e002f2e7625ULL, 0x000fc800078e000aULL,
0x00005e0031307625ULL, 0x000fc800078e000aULL, 0x00005e0029287625ULL, 0x000fc800078e000aULL,
0x00005e002b2a7625ULL, 0x000fc800078e000aULL, 0x0000000436367824ULL, 0x000fe400078e00ffULL,
0x0000000438387824ULL, 0x000fe400078e00ffULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc36397812ULL, 0x000fe200078ee209ULL, 0x00000010352c7825ULL, 0x040fe200078e002cULL,
0xfffffffc383b7812ULL, 0x100fe400078ee209ULL, 0xfffffffc3a3f7812ULL, 0x000fe200078ee209ULL,
0x00000010352e7825ULL, 0x000fc800078e002eULL, 0x0000001035327825ULL, 0x000fc800078e0032ULL,
0x0000001035307825ULL, 0x000fc800078e0030ULL, 0x0000001035287825ULL, 0x000fc800078e0028ULL,
0x00000010352a7825ULL, 0x000fe200078e002aULL, 0xfffffffc34357812ULL, 0x000fc600078ee209ULL,
0x0000001037377824ULL, 0x100fe200078e0258ULL, 0x0000005835357211ULL, 0x000fe200078e20ffULL,
0x0000001039397824ULL, 0x100fe400078e0258ULL, 0x000000103b3b7824ULL, 0x100fe200078e0258ULL,
0x000000002c377faeULL, 0x0003e2000c901c46ULL, 0x000000103d3d7824ULL, 0x100fe400078e0258ULL,
0x000000103f3f7824ULL, 0x000fe200078e0258ULL, 0x000000002e357faeULL, 0x0003e8000d101c46ULL,
0x0000000032397faeULL, 0x0003e8000d901c46ULL, 0x00000000303b7faeULL, 0x0003e8000e101c46ULL,
0x00000000283d7faeULL, 0x0003e8000e901c46ULL, 0x000000002a3f7faeULL, 0x0003e2000f101c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x000000690c297211ULL, 0x000fe400078ff0ffULL,
0x000000106b377812ULL, 0x000fc400078efcffULL, 0x000000100c2c7811ULL, 0x040fe200078ff0ffULL,
0x00005e0029287625ULL, 0x080fe200078e000aULL, 0x000000080c2a7811ULL, 0x040fe400078ff0ffULL,
0x000000180c367811ULL, 0x000fe200078ff0ffULL, 0x000000012c2d7824ULL, 0x000fe200078e0269ULL,
0x000000200c387811ULL, 0x040fe200078ff0ffULL, 0x0000001037287825ULL, 0x000fe200078e0028ULL,
0x000000280c3a7811ULL, 0x040fe400078ff0ffULL, 0x000000300c3c7811ULL, 0x000fe200078ff0ffULL,
0x000000042c2c7824ULL, 0x000fe200078e00ffULL, 0x000000380c3e7811ULL, 0x000fe200078ff0ffULL,
0x0000000136357824ULL, 0x100fe200078e0269ULL, 0x000000692a2b7210ULL, 0x0c0fe20007ffe0ffULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0x0000006938337210ULL, 0x000fe20007ffe0ffULL,
0x000000013a317824ULL, 0x100fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000280f7faeULL, 0x0003e2000b901c46ULL, 0x000000013c2f7824ULL, 0x000fe200078e0269ULL,
0xfffffffc2a397812ULL, 0x000fe200078ee209ULL, 0x000000013e3d7824ULL, 0x000fe200078e0269ULL,
0xfffffffc2c3b7812ULL, 0x000fe200078ee209ULL, 0x00005e002d2c7625ULL, 0x000fe200078e000aULL,
0x000000023e3e7819ULL, 0x000fc400000006ffULL, 0x000000583b3b7211ULL, 0x000fe200078e20ffULL,
0x00005e0035347625ULL, 0x000fc800078e000aULL, 0x00005e002b287625ULL, 0x002fc800078e000aULL,
0x00005e0033327625ULL, 0x000fc800078e000aULL, 0x00005e0031307625ULL, 0x000fc800078e000aULL,
0x00005e002f2e7625ULL, 0x000fc800078e000aULL, 0x00005e003d2a7625ULL, 0x000fc800078e000aULL,
0x0000000436367824ULL, 0x000fe400078e00ffULL, 0x0000000438387824ULL, 0x000fe400078e00ffULL,
0x000000043a3a7824ULL, 0x000fe400078e00ffULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc383d7812ULL, 0x100fe200078ee209ULL, 0x0000001039397824ULL, 0x000fe200078e0258ULL,
0xfffffffc3a3f7812ULL, 0x000fe200078ee209ULL, 0x0000001037287825ULL, 0x000fe200078e0028ULL,
0xfffffffc3c417812ULL, 0x000fc600078ee209ULL, 0x00000010372c7825ULL, 0x040fe200078e002cULL,
0x0000000028397faeULL, 0x0003e6000b901c46ULL, 0x0000001037347825ULL, 0x040fe200078e0034ULL,
0x000000002c3b7faeULL, 0x0005e6000b901c46ULL, 0x0000001037327825ULL, 0x000fc800078e0032ULL,
0x0000001037307825ULL, 0x000fe200078e0030ULL, 0xfffffffc3e297812ULL, 0x002fc600078ee209ULL,
0x00000010372e7825ULL, 0x000fe200078e002eULL, 0x0000005829297211ULL, 0x000fc600078e20ffULL,
0x00000010372a7825ULL, 0x000fe200078e002aULL, 0xfffffffc36377812ULL, 0x000fc600078ee209ULL,
0x000000103d3d7824ULL, 0x100fe400078e0258ULL, 0x0000001037377824ULL, 0x100fe400078e0258ULL,
0x000000103f3f7824ULL, 0x100fe400078e0258ULL, 0x0000001041417824ULL, 0x000fe200078e0258ULL,
0x0000000034377faeULL, 0x0005e8000b901c46ULL, 0x00000000323d7faeULL, 0x0005e8000b901c46ULL,
0x00000000303f7faeULL, 0x0005e8000b901c46ULL, 0x000000002e417faeULL, 0x0005e8000b901c46ULL,
0x000000002a297faeULL, 0x0005e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000c08287810ULL, 0x002fe20007ffe0ffULL,
0x00000af000007945ULL, 0x000fe60003800000ULL, 0x0000000728287812ULL, 0x000fca00078e7807ULL,
0x0000002007287824ULL, 0x000fc800078e0228ULL, 0x00000010283c7824ULL, 0x000fe200078e00ffULL,
0x0000000e08287810ULL, 0x000fc80007ffe0ffULL, 0x0000000728287812ULL, 0x000fe200078e7807ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000e54783bULL, 0x000fe20000000200ULL,
0x0000002007287824ULL, 0x000fc600078e0228ULL, 0x000000003c3c783bULL, 0x004e620000000200ULL,
0x0000001028287824ULL, 0x000fc600078e00ffULL, 0x000000000d48783bULL, 0x000ea80000000200ULL,
0x000000000644783bULL, 0x000ee80000000200ULL, 0x000000000540783bULL, 0x000f280000000200ULL,
0x000000000438783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000000334783bULL, 0x000ee80000000200ULL, 0x000000000230783bULL, 0x000ee80000000200ULL,
0x00000000002c783bULL, 0x000ee20000000200ULL, 0x000000543c24723cULL, 0x042ff00000041824ULL,
0x000000563c50723cULL, 0x040ff00000041850ULL, 0x000000483c4c723cULL, 0x044ff0000004184cULL,
0x0000004a3c10723cULL, 0x040ff00000041810ULL, 0x000000443c14723cULL, 0x048ff00000041814ULL,
0x000000463c18723cULL, 0x040ff00000041818ULL, 0x000000403c1c723cULL, 0x050ff0000004181cULL,
0x000000423c20723cULL, 0x000ff00000041820ULL, 0x000000382824723cULL, 0x060ff00000041824ULL,
0x0000003a2850723cULL, 0x040ff00000041850ULL, 0x00000034284c723cULL, 0x040ff0000004184cULL,
0x000000362810723cULL, 0x040ff00000041810ULL, 0x000000302814723cULL, 0x040ff00000041814ULL,
0x000000322818723cULL, 0x040ff00000041818ULL, 0x0000002c281c723cULL, 0x040ff0000004181cULL,
0x0000002e2828723cULL, 0x000fe20000041820ULL, 0x000004b000008947ULL, 0x000fee0003800000ULL,
0x00000002ff2d7819ULL, 0x000fe4000001160cULL, 0x8000000b602c7210ULL, 0x000fc40007ffe0ffULL,
0x000000082d207810ULL, 0x040fe20007ffe0ffULL, 0x000000012d217824ULL, 0x140fe200078e0269ULL,
0x0000002c2d00720cULL, 0x080fe40003f26070ULL, 0x0000002c2000720cULL, 0x040fe20003f46070ULL,
0x0000000120237824ULL, 0x040fe200078e0269ULL, 0x000000146b357812ULL, 0x000fe200078efcffULL,
0x00000004202e7824ULL, 0x000fe200078e00ffULL, 0x000000182d347810ULL, 0x000fe20007ffe0ffULL,
0x00005e0021207625ULL, 0x000fe200078e000aULL, 0x000000202d367810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc2e2f7812ULL, 0x000fe200078ee209ULL, 0x00005e0023227625ULL, 0x000fe200078e000aULL,
0x000000102d2e7810ULL, 0x040fe40007ffe0ffULL, 0x000000282d387810ULL, 0x000fe20007ffe0ffULL,
0x0000001035207825ULL, 0x000fe200078e0020ULL, 0x000000302d397810ULL, 0x040fe40007ffe0ffULL,
0x000000382d3a7810ULL, 0x000fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e026cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000206d7faeULL, 0x0003e2000c901c46ULL,
0x0000001035227825ULL, 0x000fe200078e0022ULL, 0x0000002c2e00720cULL, 0x000fc40003f26070ULL,
0x000000692e2d7210ULL, 0x0c0fe20007ffe0ffULL, 0x000000042e2e7824ULL, 0x000fe200078e00ffULL,
0x00000000222f7faeULL, 0x0005e2000d101c46ULL, 0x0000000136337824ULL, 0x100fe200078e0269ULL,
0x0000002c3400720cULL, 0x080fe20003f46070ULL, 0x0000000138317824ULL, 0x000fe200078e0269ULL,
0x0000002c3600720cULL, 0x000fe20003f66070ULL, 0x00005e0033327625ULL, 0x000fe200078e000aULL,
0x0000006939217210ULL, 0x002fe40007ffe0ffULL, 0x0000002c3800720cULL, 0x000fe20003f86070ULL,
0x00005e0031307625ULL, 0x000fe200078e000aULL, 0x0000002c3900720cULL, 0x000fc40003fa6070ULL,
0x0000002c3a00720cULL, 0x000fe20003fc6070ULL, 0x00000001342f7824ULL, 0x004fe200078e0269ULL,
0xfffffffc2e377812ULL, 0x000fe200078ee209ULL, 0x000000013a237824ULL, 0x000fe200078e0269ULL,
0x0000000238387819ULL, 0x000fe200000006ffULL, 0x00005e002d2c7625ULL, 0x000fc600078e000aULL,
0xfffffffc383b7812ULL, 0x000fe200078ee209ULL, 0x00005e002f2e7625ULL, 0x000fc600078e000aULL,
0x0000006c3b3b7211ULL, 0x000fe200078e20ffULL, 0x00005e0021207625ULL, 0x000fc800078e000aULL,
0x00005e0023227625ULL, 0x000fc800078e000aULL, 0x0000000434347824ULL, 0x000fe400078e00ffULL,
0x0000000436367824ULL, 0x000fe400078e00ffULL, 0x00000004393c7824ULL, 0x000fe400078e00ffULL,
0x00000010352c7825ULL, 0x040fe200078e002cULL, 0xfffffffc36397812ULL, 0x100fe400078ee209ULL,
0xfffffffc3c3d7812ULL, 0x000fe200078ee209ULL, 0x00000010352e7825ULL, 0x000fc800078e002eULL,
0x0000001035327825ULL, 0x000fc800078e0032ULL, 0x0000001035307825ULL, 0x000fc800078e0030ULL,
0x0000001035207825ULL, 0x000fc800078e0020ULL, 0x0000001035227825ULL, 0x000fe200078e0022ULL,
0xfffffffc34357812ULL, 0x000fc600078ee209ULL, 0x000000043a3a7824ULL, 0x000fe400078e00ffULL,
0x0000001037377824ULL, 0x100fe400078e026cULL, 0x0000001035357824ULL, 0x100fe200078e026cULL,
0xfffffffc3a3f7812ULL, 0x000fe200078ee209ULL, 0x0000001039397824ULL, 0x100fe200078e026cULL,
0x000000002c377faeULL, 0x0003e2000c901c46ULL, 0x000000103d3d7824ULL, 0x100fe400078e026cULL,
0x000000103f3f7824ULL, 0x000fe200078e026cULL, 0x000000002e357faeULL, 0x0003e8000d101c46ULL,
0x0000000032397faeULL, 0x0003e8000d901c46ULL, 0x00000000303b7faeULL, 0x0003e8000e101c46ULL,
0x00000000203d7faeULL, 0x0003e8000e901c46ULL, 0x00000000223f7faeULL, 0x0003e2000f101c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x000000690c217211ULL, 0x000fe400078ff0ffULL,
0x000000146b377812ULL, 0x000fc400078efcffULL, 0x000000080c227811ULL, 0x040fe200078ff0ffULL,
0x00005e0021207625ULL, 0x080fe200078e000aULL, 0x000000100c2c7811ULL, 0x040fe400078ff0ffULL,
0x000000180c367811ULL, 0x000fe200078ff0ffULL, 0x0000000122237824ULL, 0x000fe200078e0269ULL,
0x000000200c387811ULL, 0x040fe200078ff0ffULL, 0x0000001037207825ULL, 0x000fe200078e0020ULL,
0x000000280c3a7811ULL, 0x040fe400078ff0ffULL, 0x000000300c3c7811ULL, 0x000fe200078ff0ffULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x000000380c3e7811ULL, 0x000fe200078ff0ffULL,
0x0000000136357824ULL, 0x100fe200078e0269ULL, 0x000000692c2d7210ULL, 0x0c0fe20007ffe0ffULL,
0x000000042c2c7824ULL, 0x000fe200078e00ffULL, 0x000000693c2f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000138337824ULL, 0x100fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000206d7faeULL, 0x0003e2000b901c46ULL, 0x000000013a317824ULL, 0x000fe200078e0269ULL,
0xfffffffc22397812ULL, 0x000fe200078ee209ULL, 0x000000013e3d7824ULL, 0x000fe200078e0269ULL,
0xfffffffc2c3b7812ULL, 0x000fe200078ee209ULL, 0x00005e002d2c7625ULL, 0x000fe200078e000aULL,
0x0000000238387819ULL, 0x000fc600000006ffULL, 0x00005e0035347625ULL, 0x000fc800078e000aULL,
0x00005e0023207625ULL, 0x002fc800078e000aULL, 0x00005e0033327625ULL, 0x000fc800078e000aULL,
0x00005e0031307625ULL, 0x000fc800078e000aULL, 0x00005e002f2e7625ULL, 0x000fc800078e000aULL,
0x00005e003d227625ULL, 0x000fe200078e000aULL, 0xfffffffc383d7812ULL, 0x000fc600078ee209ULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0x0000006c3d3d7211ULL, 0x000fe200078e20ffULL,
0x000000043a3a7824ULL, 0x000fe400078e00ffULL, 0x0000001039397824ULL, 0x000fe400078e026cULL,
0x0000001037207825ULL, 0x000fe200078e0020ULL, 0xfffffffc3a3f7812ULL, 0x000fc600078ee209ULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0x0000000020397faeULL, 0x0003e2000b901c46ULL,
0x00000010372c7825ULL, 0x000fc600078e002cULL, 0xfffffffc3c417812ULL, 0x000fe200078ee209ULL,
0x0000001037347825ULL, 0x000fc800078e0034ULL, 0x0000001037327825ULL, 0x000fc800078e0032ULL,
0x0000001037307825ULL, 0x000fc800078e0030ULL, 0x00000010372e7825ULL, 0x000fc800078e002eULL,
0x0000001037227825ULL, 0x000fe200078e0022ULL, 0xfffffffc36377812ULL, 0x000fc600078ee209ULL,
0x000000043e3e7824ULL, 0x000fe400078e00ffULL, 0x000000103b3b7824ULL, 0x100fe400078e026cULL,
0x0000001037377824ULL, 0x100fe200078e026cULL, 0xfffffffc3e217812ULL, 0x002fe200078ee209ULL,
0x000000103f3f7824ULL, 0x100fe200078e026cULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001041417824ULL, 0x100fe400078e026cULL, 0x0000001021217824ULL, 0x000fe200078e026cULL,
0x0000000034377faeULL, 0x0003e8000b901c46ULL, 0x00000000323d7faeULL, 0x0003e8000b901c46ULL,
0x00000000303f7faeULL, 0x0003e8000b901c46ULL, 0x000000002e417faeULL, 0x0003e8000b901c46ULL,
0x0000000022217faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001008207810ULL, 0x042fe20007ffe0ffULL,
0x00000af000007945ULL, 0x000fe20003800000ULL, 0x00000012082c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000720207812ULL, 0x100fe400078e7807ULL, 0x000000072c2c7812ULL, 0x000fc600078e7807ULL,
0x0000002007207824ULL, 0x040fe400078e0220ULL, 0x00000020072c7824ULL, 0x000fc600078e022cULL,
0x0000000420407819ULL, 0x000fe200000006ffULL, 0x000000102c2c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006a20783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000e680000000200ULL, 0x000000006854783bULL, 0x000ea80000000200ULL,
0x000000006748783bULL, 0x000ee80000000200ULL, 0x000000006644783bULL, 0x000f280000000200ULL,
0x00000000653c783bULL, 0x000fe80000000200ULL, 0x000000002c2c783bULL, 0x000f680000000200ULL,
0x000000006438783bULL, 0x000ee80000000200ULL, 0x000000006334783bULL, 0x000ee80000000200ULL,
0x000000006230783bULL, 0x000ee20000000200ULL, 0x000000204024723cULL, 0x042ff00000041824ULL,
0x000000224050723cULL, 0x040ff00000041850ULL, 0x00000054404c723cULL, 0x044ff0000004184cULL,
0x000000564010723cULL, 0x040ff00000041810ULL, 0x000000484014723cULL, 0x048ff00000041814ULL,
0x0000004a4018723cULL, 0x040ff00000041818ULL, 0x00000044401c723cULL, 0x050ff0000004181cULL,
0x000000464028723cULL, 0x000ff00000041828ULL, 0x0000003c2c24723cULL, 0x060ff00000041824ULL,
0x0000003e2c50723cULL, 0x040ff00000041850ULL, 0x000000382c4c723cULL, 0x040ff0000004184cULL,
0x0000003a2c10723cULL, 0x040ff00000041810ULL, 0x000000342c14723cULL, 0x040ff00000041814ULL,
0x000000362c18723cULL, 0x040ff00000041818ULL, 0x000000302c1c723cULL, 0x040ff0000004181cULL,
0x000000322c28723cULL, 0x000fe20000041828ULL, 0x000004b000008947ULL, 0x000fee0003800000ULL,
0x00000002ff2d7819ULL, 0x000fe2000001160cULL, 0x00000001602c7824ULL, 0x000fe200078e0a0bULL,
0x000000186b357812ULL, 0x000fc400078efcffULL, 0x000000082d207810ULL, 0x040fe20007ffe0ffULL,
0x000000012d217824ULL, 0x040fe200078e0269ULL, 0x0000002c2d00720cULL, 0x080fe40003f26070ULL,
0x0000006920237210ULL, 0x040fe20007ffe0ffULL, 0x00000004202e7824ULL, 0x040fe200078e00ffULL,
0x0000002c2000720cULL, 0x000fe20003f46070ULL, 0x00005e0021207625ULL, 0x080fe200078e000aULL,
0x000000182d347810ULL, 0x000fe40007ffe0ffULL, 0xfffffffc2e2f7812ULL, 0x000fe200078ee209ULL,
0x00005e0023227625ULL, 0x000fe200078e000aULL, 0x000000102d2e7810ULL, 0x000fc40007ffe0ffULL,
0x000000202d367810ULL, 0x000fe20007ffe0ffULL, 0x0000001035207825ULL, 0x000fe200078e0020ULL,
0x000000282d387810ULL, 0x040fe40007ffe0ffULL, 0x000000302d397810ULL, 0x000fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0258ULL, 0x000000382d3a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001035227825ULL, 0x000fe200078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000200f7faeULL, 0x0003e2000c901c46ULL, 0x0000002c2e00720cULL, 0x0c0fe40003f26070ULL,
0x000000012e2d7824ULL, 0x140fe200078e0269ULL, 0x00000000222f7faeULL, 0x0005e2000d101c46ULL,
0x000000042e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002c3400720cULL, 0x080fe20003f46070ULL,
0x0000000136337824ULL, 0x140fe200078e0269ULL, 0x0000002c3600720cULL, 0x080fe20003f66070ULL,
0x0000000138317824ULL, 0x040fe200078e0269ULL, 0x0000002c3800720cULL, 0x000fe20003f86070ULL,
0x00005e0033327625ULL, 0x000fe200078e000aULL, 0x0000002c3900720cULL, 0x000fc40003fa6070ULL,
0x0000002c3a00720cULL, 0x000fe20003fc6070ULL, 0x0000000139217824ULL, 0x102fe200078e0269ULL,
0x00000069342f7210ULL, 0x004fe20007ffe0ffULL, 0x000000013a237824ULL, 0x000fe200078e0269ULL,
0xfffffffc2e377812ULL, 0x100fe200078ee209ULL, 0x00005e002d2c7625ULL, 0x000fe200078e000aULL,
0x000000023a3a7819ULL, 0x000fe400000006ffULL, 0x0000005837377211ULL, 0x000fe200078e20ffULL,
0x00005e002f2e7625ULL, 0x000fe200078e000aULL, 0xfffffffc3a3f7812ULL, 0x000fc600078ee209ULL,
0x00005e0031307625ULL, 0x000fe200078e000aULL, 0x000000583f3f7211ULL, 0x000fc600078e20ffULL,
0x00005e0021207625ULL, 0x000fc800078e000aULL, 0x00005e0023227625ULL, 0x000fc800078e000aULL,
0x0000000434347824ULL, 0x000fe400078e00ffULL, 0x0000000436367824ULL, 0x000fe400078e00ffULL,
0x0000000438387824ULL, 0x000fe400078e00ffULL, 0x00000004393c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc36397812ULL, 0x000fe200078ee209ULL, 0x00000010352c7825ULL, 0x040fe200078e002cULL,
0xfffffffc383b7812ULL, 0x100fe400078ee209ULL, 0xfffffffc3c3d7812ULL, 0x000fe200078ee209ULL,
0x00000010352e7825ULL, 0x040fe200078e002eULL, 0x000000002c377faeULL, 0x0003e6000c901c46ULL,
0x0000001035327825ULL, 0x000fc800078e0032ULL, 0x0000001035307825ULL, 0x000fc800078e0030ULL,
0x0000001035207825ULL, 0x000fc800078e0020ULL, 0x0000001035227825ULL, 0x000fe200078e0022ULL,
0xfffffffc34357812ULL, 0x000fc600078ee209ULL, 0x0000001039397824ULL, 0x100fe400078e0258ULL,
0x0000001035357824ULL, 0x100fe400078e0258ULL, 0x000000103b3b7824ULL, 0x100fe400078e0258ULL,
0x000000103d3d7824ULL, 0x000fe200078e0258ULL, 0x000000002e357faeULL, 0x0003e8000d101c46ULL,
0x0000000032397faeULL, 0x0003e8000d901c46ULL, 0x00000000303b7faeULL, 0x0003e8000e101c46ULL,
0x00000000203d7faeULL, 0x0003e8000e901c46ULL, 0x00000000223f7faeULL, 0x0003e2000f101c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x000000690c217211ULL, 0x000fe400078ff0ffULL,
0x000000186b377812ULL, 0x000fc400078efcffULL, 0x000000080c227811ULL, 0x040fe200078ff0ffULL,
0x00005e0021207625ULL, 0x000fe200078e000aULL, 0x000000100c2c7811ULL, 0x040fe400078ff0ffULL,
0x000000180c367811ULL, 0x000fe200078ff0ffULL, 0x0000000122237824ULL, 0x000fe200078e0269ULL,
0x000000200c387811ULL, 0x040fe200078ff0ffULL, 0x0000001037207825ULL, 0x000fe200078e0020ULL,
0x000000280c3a7811ULL, 0x040fe400078ff0ffULL, 0x000000300c3c7811ULL, 0x000fe200078ff0ffULL,
0x000000012c2d7824ULL, 0x100fe200078e0269ULL, 0x000000380c3e7811ULL, 0x000fe200078ff0ffULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x0000006936357210ULL, 0x000fe20007ffe0ffULL,
0x000000042c2c7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000200f7faeULL, 0x0003e2000b901c46ULL, 0x0000000138337824ULL, 0x000fe200078e0269ULL,
0xfffffffc22397812ULL, 0x000fe200078ee209ULL, 0x000000013a317824ULL, 0x000fe200078e0269ULL,
0xfffffffc2c3b7812ULL, 0x000fe200078ee209ULL, 0x000000013c2f7824ULL, 0x100fe200078e0269ULL,
0x0000005839397211ULL, 0x000fe200078e20ffULL, 0x000000013e3d7824ULL, 0x000fe200078e0269ULL,
0x000000023c3c7819ULL, 0x000fe200000006ffULL, 0x00005e002d2c7625ULL, 0x000fc600078e000aULL,
0xfffffffc3c417812ULL, 0x000fe200078ee209ULL, 0x00005e0023207625ULL, 0x002fc600078e000aULL,
0x0000005841417211ULL, 0x000fe200078e20ffULL, 0x00005e0035347625ULL, 0x000fc800078e000aULL,
0x00005e0033327625ULL, 0x000fc800078e000aULL, 0x00005e0031307625ULL, 0x000fc800078e000aULL,
0x00005e002f2e7625ULL, 0x000fc800078e000aULL, 0x00005e003d227625ULL, 0x000fc800078e000aULL,
0x0000000436367824ULL, 0x000fe400078e00ffULL, 0x0000000438387824ULL, 0x000fe400078e00ffULL,
0x000000043a3a7824ULL, 0x000fe400078e00ffULL, 0x0000001037207825ULL, 0x040fe200078e0020ULL,
0xfffffffc383d7812ULL, 0x100fe400078ee209ULL, 0xfffffffc3a3f7812ULL, 0x000fe200078ee209ULL,
0x00000010372c7825ULL, 0x040fe200078e002cULL, 0x0000000020397faeULL, 0x0003e6000b901c46ULL,
0x0000001037347825ULL, 0x000fc800078e0034ULL, 0x0000001037327825ULL, 0x000fc800078e0032ULL,
0x0000001037307825ULL, 0x000fc800078e0030ULL, 0x00000010372e7825ULL, 0x000fc800078e002eULL,
0x0000001037227825ULL, 0x000fe200078e0022ULL, 0xfffffffc36377812ULL, 0x000fc600078ee209ULL,
0x000000043e3e7824ULL, 0x000fe400078e00ffULL, 0x000000103b3b7824ULL, 0x100fe400078e0258ULL,
0x0000001037377824ULL, 0x100fe200078e0258ULL, 0xfffffffc3e217812ULL, 0x002fe200078ee209ULL,
0x000000103d3d7824ULL, 0x100fe200078e0258ULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x000000103f3f7824ULL, 0x100fe400078e0258ULL, 0x0000001021217824ULL, 0x000fe200078e0258ULL,
0x0000000034377faeULL, 0x0003e8000b901c46ULL, 0x00000000323d7faeULL, 0x0003e8000b901c46ULL,
0x00000000303f7faeULL, 0x0003e8000b901c46ULL, 0x000000002e417faeULL, 0x0003e8000b901c46ULL,
0x0000000022217faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001408207810ULL, 0x042fe20007ffe0ffULL,
0x00000af000007945ULL, 0x000fe20003800000ULL, 0x00000016082c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000720207812ULL, 0x100fe400078e7807ULL, 0x000000072c2c7812ULL, 0x000fc600078e7807ULL,
0x0000002007207824ULL, 0x040fe400078e0220ULL, 0x00000020072c7824ULL, 0x000fe400078e022cULL,
0x0000001020407824ULL, 0x000fc600078e00ffULL, 0x000000042c2c7819ULL, 0x000fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000e20783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000e680000000200ULL, 0x000000000d54783bULL, 0x000ea80000000200ULL,
0x000000000648783bULL, 0x000ee80000000200ULL, 0x000000000544783bULL, 0x000f280000000200ULL,
0x00000000043c783bULL, 0x000fe80000000200ULL, 0x000000002c2c783bULL, 0x000f680000000200ULL,
0x000000000338783bULL, 0x000ee80000000200ULL, 0x000000000234783bULL, 0x000ee80000000200ULL,
0x000000000030783bULL, 0x000ee20000000200ULL, 0x000000204024723cULL, 0x042ff00000041824ULL,
0x000000224050723cULL, 0x040ff00000041850ULL, 0x00000054404c723cULL, 0x044ff0000004184cULL,
0x000000564010723cULL, 0x040ff00000041810ULL, 0x000000484014723cULL, 0x048ff00000041814ULL,
0x0000004a4018723cULL, 0x040ff00000041818ULL, 0x00000044401c723cULL, 0x050ff0000004181cULL,
0x000000464028723cULL, 0x000ff00000041828ULL, 0x0000003c2c24723cULL, 0x060ff00000041824ULL,
0x0000003e2c50723cULL, 0x040ff00000041850ULL, 0x000000382c4c723cULL, 0x040ff0000004184cULL,
0x0000003a2c10723cULL, 0x040ff00000041810ULL, 0x000000342c14723cULL, 0x040ff00000041814ULL,
0x000000362c18723cULL, 0x040ff00000041818ULL, 0x000000302c1c723cULL, 0x040ff0000004181cULL,
0x000000322c28723cULL, 0x000fe20000041828ULL, 0x000004b000008947ULL, 0x000fee0003800000ULL,
0x00000002ff237819ULL, 0x000fe2000001160cULL, 0x0000000160227824ULL, 0x000fe200078e0a0bULL,
0x0000001c6b6b7812ULL, 0x000fc400078efcffULL, 0x00000018232e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000123217824ULL, 0x140fe200078e0269ULL, 0x000000222300720cULL, 0x040fe40003f06070ULL,
0x00000008232c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0021207625ULL, 0x000fe200078e000aULL,
0x00000010232d7810ULL, 0x040fe40007ffe0ffULL, 0x0000002023307810ULL, 0x040fe20007ffe0ffULL,
0x000000012e337824ULL, 0x000fe200078e0269ULL, 0x0000002823317810ULL, 0x000fe20007ffe0ffULL,
0x000000106b207825ULL, 0x000fe200078e0020ULL, 0x0000003023327810ULL, 0x000fc40007ffe0ffULL,
0x0000003823347810ULL, 0x000fe20007ffe0ffULL, 0x000000012c237824ULL, 0x100fe200078e0269ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000206d7faeULL, 0x0003e2000c101c46ULL,
0x000000222e00720cULL, 0x0c0fe20003f46070ULL, 0x000000042e2e7824ULL, 0x000fe200078e00ffULL,
0x000000222c00720cULL, 0x0c0fe20003f06070ULL, 0x000000042c2c7824ULL, 0x000fe200078e00ffULL,
0x000000222d00720cULL, 0x080fe20003f26070ULL, 0x0000000130357824ULL, 0x140fe200078e0269ULL,
0x000000223000720cULL, 0x080fe20003f66070ULL, 0x00000001313f7824ULL, 0x140fe200078e0269ULL,
0x000000223100720cULL, 0x080fe20003f86070ULL, 0x0000000132437824ULL, 0x040fe200078e0269ULL,
0x000000223200720cULL, 0x080fe20003fa6070ULL, 0x000000042d207824ULL, 0x002fe200078e00ffULL,
0x000000223400720cULL, 0x000fe20003fc6070ULL, 0x0000000431227824ULL, 0x000fe200078e00ffULL,
0x000000692d2f7210ULL, 0x080fe20007ffe0ffULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0x0000006934697210ULL, 0x040fe20007ffe0ffULL, 0x0000000434347824ULL, 0x000fe200078e00ffULL,
0xfffffffc2e317812ULL, 0x000fe200078ee209ULL, 0x00005e002f2e7625ULL, 0x000fe200078e000aULL,
0x0000000230307819ULL, 0x000fc400000006ffULL, 0xfffffffc202d7812ULL, 0x100fe200078ee209ULL,
0x00000010313b7824ULL, 0x000fe200078e026cULL, 0xfffffffc22417812ULL, 0x100fe200078ee209ULL,
0x00005e0023227625ULL, 0x080fe200078e000aULL, 0xfffffffc2c217812ULL, 0x100fe400078ee209ULL,
0xfffffffc32457812ULL, 0x100fe200078ee209ULL, 0x00005e0033327625ULL, 0x080fe200078e000aULL,
0xfffffffc34477812ULL, 0x100fe400078ee209ULL, 0xfffffffc303d7812ULL, 0x000fe200078ee209ULL,
0x00005e0035347625ULL, 0x000fc600078e000aULL, 0x0000006c3d3d7211ULL, 0x000fe200078e20ffULL,
0x000000102d397824ULL, 0x000fe400078e026cULL, 0x00005e003f307625ULL, 0x000fc800078e000aULL,
0x0000001021377824ULL, 0x000fe400078e026cULL, 0x00005e00432c7625ULL, 0x000fc800078e000aULL,
0x00005e0069207625ULL, 0x000fc800078e000aULL, 0x000000106b227825ULL, 0x000fc800078e0022ULL,
0x000000106b2e7825ULL, 0x040fe200078e002eULL, 0x0000000022377faeULL, 0x0003e6000c101c46ULL,
0x000000106b327825ULL, 0x040fe200078e0032ULL, 0x000000002e397faeULL, 0x0003e6000c901c46ULL,
0x000000106b347825ULL, 0x000fe200078e0034ULL, 0x00000000323b7faeULL, 0x0003e6000d101c46ULL,
0x0000001041417824ULL, 0x000fe200078e026cULL, 0x00000000343d7faeULL, 0x0003e2000d901c46ULL,
0x000000106b307825ULL, 0x000fc800078e0030ULL, 0x0000001045457824ULL, 0x000fe200078e026cULL,
0x0000000030417faeULL, 0x0003e2000e101c46ULL, 0x000000106b2c7825ULL, 0x000fc800078e002cULL,
0x0000001047477824ULL, 0x000fe200078e026cULL, 0x000000002c457faeULL, 0x0003e2000e901c46ULL,
0x000000106b207825ULL, 0x000fca00078e0020ULL, 0x0000000020477faeULL, 0x0003e2000f101c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x000000690c217211ULL, 0x040fe400078ff0ffULL,
0x0000001c6b6b7812ULL, 0x000fe400078efcffULL, 0x000000100c2c7811ULL, 0x040fe200078ff0ffULL,
0x00005e0021207625ULL, 0x000fe200078e000aULL, 0x000000180c2e7811ULL, 0x040fe400078ff0ffULL,
0x000000080c227811ULL, 0x000fe200078ff0ffULL, 0x000000012c2f7824ULL, 0x000fe200078e0269ULL,
0x000000280c327811ULL, 0x040fe200078ff0ffULL, 0x000000106b207825ULL, 0x000fe200078e0020ULL,
0x000000300c347811ULL, 0x000fc400078ff0ffULL, 0x000000200c307811ULL, 0x000fe200078ff0ffULL,
0x000000012e337824ULL, 0x100fe200078e0269ULL, 0x000000380c367811ULL, 0x000fe200078ff0ffULL,
0x0000000122237824ULL, 0x140fe200078e0269ULL, 0x0000000222227819ULL, 0x000fe200000006ffULL,
0x000000042c2c7824ULL, 0x000fe200078e00ffULL, 0x0000006930357210ULL, 0x000fe20007ffe0ffULL,
0x000000042e2e7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000206d7faeULL, 0x0003e2000b901c46ULL, 0x00000001323f7824ULL, 0x000fe200078e0269ULL,
0xfffffffc2c2d7812ULL, 0x100fe200078ee209ULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0xfffffffc2e317812ULL, 0x000fe200078ee209ULL, 0x0000000134437824ULL, 0x040fe200078e0269ULL,
0x0000000234347819ULL, 0x000fe200000006ffULL, 0x0000000430307824ULL, 0x000fe200078e00ffULL,
0xfffffffc32417812ULL, 0x000fe200078ee209ULL, 0x0000000136697824ULL, 0x000fe200078e0269ULL,
0xfffffffc34457812ULL, 0x100fe200078ee209ULL, 0x00005e002f2e7625ULL, 0x000fe200078e000aULL,
0xfffffffc22217812ULL, 0x002fc400078ee209ULL, 0xfffffffc303d7812ULL, 0x000fe200078ee209ULL,
0x00005e0023227625ULL, 0x000fe200078e000aULL, 0x0000006c313b7211ULL, 0x000fc600078e20ffULL,
0x0000000436367824ULL, 0x000fe400078e00ffULL, 0x00005e0033327625ULL, 0x000fc600078e000aULL,
0xfffffffc36477812ULL, 0x000fe200078ee209ULL, 0x00005e0035347625ULL, 0x000fc800078e000aULL,
0x000000102d397824ULL, 0x000fe400078e026cULL, 0x00005e003f307625ULL, 0x000fc800078e000aULL,
0x0000001021377824ULL, 0x000fe400078e026cULL, 0x00005e00432c7625ULL, 0x000fc800078e000aULL,
0x00005e0069207625ULL, 0x000fc800078e000aULL, 0x000000106b227825ULL, 0x000fc800078e0022ULL,
0x000000106b2e7825ULL, 0x040fe200078e002eULL, 0x0000000022377faeULL, 0x0003e6000b901c46ULL,
0x000000106b327825ULL, 0x000fe200078e0032ULL, 0x000000002e397faeULL, 0x0003e6000b901c46ULL,
0x000000103d3d7824ULL, 0x000fe200078e026cULL, 0x00000000323b7faeULL, 0x0003e2000b901c46ULL,
0x000000106b347825ULL, 0x000fc800078e0034ULL, 0x0000001041417824ULL, 0x000fe200078e026cULL,
0x00000000343d7faeULL, 0x0003e2000b901c46ULL, 0x000000106b307825ULL, 0x000fc800078e0030ULL,
0x0000001045457824ULL, 0x000fe200078e026cULL, 0x0000000030417faeULL, 0x0003e2000b901c46ULL,
0x000000106b2c7825ULL, 0x000fc800078e002cULL, 0x0000001047477824ULL, 0x000fe200078e026cULL,
0x000000002c457faeULL, 0x0003e2000b901c46ULL, 0x000000106b207825ULL, 0x000fca00078e0020ULL,
0x0000000020477faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001808207810ULL, 0x042fe20007ffe0ffULL,
0x00000c7000007945ULL, 0x000fe20003800000ULL, 0x0000001a082c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000720207812ULL, 0x100fe400078e7807ULL, 0x000000072c2c7812ULL, 0x000fe400078e7807ULL,
0x0000002007207211ULL, 0x000fc600078e28ffULL, 0x00000020072c7824ULL, 0x000fe400078e022cULL,
0x0000001020407824ULL, 0x000fe400078e00ffULL, 0x000000102c2c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006a20783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000e680000000200ULL, 0x000000006854783bULL, 0x000ea80000000200ULL,
0x000000006748783bULL, 0x000ee80000000200ULL, 0x000000006644783bULL, 0x000f280000000200ULL,
0x00000000653c783bULL, 0x000fe80000000200ULL, 0x000000002c2c783bULL, 0x000f680000000200ULL,
0x000000006438783bULL, 0x000ee80000000200ULL, 0x000000006334783bULL, 0x000ee80000000200ULL,
0x000000006230783bULL, 0x000ee20000000200ULL, 0x000000204024723cULL, 0x042ff00000041824ULL,
0x000000224050723cULL, 0x040ff00000041850ULL, 0x00000054404c723cULL, 0x044fee000004184cULL,
0x0000030061547a10ULL, 0x000fe20007ffe0ffULL, 0x000000564010723cULL, 0x000fe60000041810ULL,
0x0000000154207810ULL, 0x040fe20007ffe0ffULL, 0x0000010054237824ULL, 0x000fc600078e025cULL,
0x0000005d2000720cULL, 0x000fe20003f06070ULL, 0x000000484014723cULL, 0x048ff00000041814ULL,
0x0000004a4018723cULL, 0x040ff00000041818ULL, 0x00000044401c723cULL, 0x050ff0000004181cULL,
0x000000464028723cULL, 0x000ff00000041828ULL, 0x0000003c2c24723cULL, 0x060ff00000041824ULL,
0x0000003e2c50723cULL, 0x040ff00000041850ULL, 0x000000382c4c723cULL, 0x040ff0000004184cULL,
0x0000003a2c10723cULL, 0x040ff00000041810ULL, 0x000000342c14723cULL, 0x040fee0000041814ULL,
0x000062005e357a24ULL, 0x000fe200078e0223ULL, 0x000000362c18723cULL, 0x040ff00000041818ULL,
0x000000302c1c723cULL, 0x040ff0000004181cULL, 0x000000322c28723cULL, 0x000fe20000041828ULL,
0x0000055000008947ULL, 0x000fee0003800000ULL, 0x00000002ff377819ULL, 0x000fe4000001160cULL,
0x000000040c347819ULL, 0x000fc400000006ffULL, 0x0000000837327810ULL, 0x040fe20007ffe0ffULL,
0x0000000137217824ULL, 0x100fe200078e0235ULL, 0x0000002360227217ULL, 0x000fe40007800000ULL,
0x0000003034347812ULL, 0x000fe200078ec0ffULL, 0x00005e0021207625ULL, 0x000fe200078e000aULL,
0x00000018373a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001037387810ULL, 0x040fe20007ffe0ffULL,
0x00000001322d7824ULL, 0x000fe200078e0235ULL, 0x00000020373b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000122367824ULL, 0x000fe200078e0a23ULL, 0x0000003420227210ULL, 0x000fe20007f1e0ffULL,
0x00005e002d2c7625ULL, 0x000fe200078e000aULL, 0x00000028373c7810ULL, 0x000fc40007ffe0ffULL,
0x00000021ff237210ULL, 0x000fe200007fe4ffULL, 0x000000013a337824ULL, 0x100fe200078e0235ULL,
0x000000342c307210ULL, 0x000fe20007f1e0ffULL, 0x00000001382f7824ULL, 0x000fe200078e0235ULL,
0x000000363200720cULL, 0x0c0fe20003f26070ULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0x00000030373d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff317224ULL, 0x000fe200000e062dULL,
0x000000363700720cULL, 0x000fe20003f06070ULL, 0x00005e00332c7625ULL, 0x000fe200078e000aULL,
0xfffffffc32337812ULL, 0x000fc400078ee209ULL, 0x0000003837377810ULL, 0x000fe20007ffe0ffULL,
0x00005e002f207625ULL, 0x000fe200078e000aULL, 0x000000363800720cULL, 0x080fe40003fa6070ULL,
0x000000363a00720cULL, 0x000fe20003f86070ULL, 0x000000013b2f7824ULL, 0x100fe200078e0235ULL,
0x0000003420207210ULL, 0x000fe20007f5e0ffULL, 0x0000001033397824ULL, 0x000fe400078e0258ULL,
0x000000013c337824ULL, 0x000fe200078e0235ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000220f7faeULL, 0x0003e2000c101c46ULL, 0x00005e002f2e7625ULL, 0x000fe200078e000aULL,
0x00000021ff217210ULL, 0x000fc400017fe4ffULL, 0x000000342c2c7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0033327625ULL, 0x000fe200078e000aULL, 0x000000342e2e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000030397faeULL, 0x0005e2000c901c46ULL, 0x000000363d00720cULL, 0x000fe20003f26070ULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x0000003432327210ULL, 0x000fe20007fde0ffULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x000000363700720cULL, 0x080fe20003f06070ULL,
0x000000013d237824ULL, 0x002fe200078e0235ULL, 0x00000033ff337210ULL, 0x000fe200037fe4ffULL,
0x000000ffff2d7224ULL, 0x000fe200010e062dULL, 0x000000363c00720cULL, 0x040fe20003f46070ULL,
0x00005e0023227625ULL, 0x000fe200078e000aULL, 0x000000023c3c7819ULL, 0x000fc400000006ffULL,
0xfffffffc380f7812ULL, 0x000fe200078ee209ULL, 0x000000043b307824ULL, 0x004fe200078e00ffULL,
0x0000003422227210ULL, 0x000fe20007fde0ffULL, 0x0000000137317824ULL, 0x000fe200078e0235ULL,
0xfffffffc3a357812ULL, 0x000fe200078ee209ULL, 0x000000ffff2f7224ULL, 0x000fe200018e062fULL,
0x000000363b00720cULL, 0x000fe20003f66070ULL, 0x00000004373e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc30377812ULL, 0x100fe200078ee209ULL, 0x000000043d367824ULL, 0x000fe200078e00ffULL,
0xfffffffc3c397812ULL, 0x100fe200078ee209ULL, 0x00005e0031307625ULL, 0x000fe200078e000aULL,
0xfffffffc3e3d7812ULL, 0x000fc400078ee209ULL, 0xfffffffc363b7812ULL, 0x000fe200078ee209ULL,
0x000000ffff237224ULL, 0x000fe200030e0623ULL, 0x000000580f0f7211ULL, 0x000fe200078e20ffULL,
0x0000001035097824ULL, 0x100fe200078e0258ULL, 0x0000003430347210ULL, 0x000fe20007fde0ffULL,
0x0000001037377824ULL, 0x100fe200078e0258ULL, 0x000000583d3d7211ULL, 0x000fe200078e20ffULL,
0x0000001039397824ULL, 0x100fe200078e0258ULL, 0x00000000200f7faeULL, 0x0003e2000e901c46ULL,
0x000000103b3b7824ULL, 0x000fe400078e0258ULL, 0x000000ffff357224ULL, 0x000fe200030e0631ULL,
0x000000002c097faeULL, 0x0003e8000e101c46ULL, 0x000000002e377faeULL, 0x0003e8000d901c46ULL,
0x0000000032397faeULL, 0x0003e8000d101c46ULL, 0x00000000223b7faeULL, 0x0003e8000c901c46ULL,
0x00000000343d7faeULL, 0x0003e2000c101c46ULL, 0x0000049000007947ULL, 0x000fea0003800000ULL,
0x000000080c207811ULL, 0x040fe200078ff0ffULL, 0x000000100c317824ULL, 0x040fe200078e00ffULL,
0x000000350c217211ULL, 0x000fc400078ff0ffULL, 0x000000100c227811ULL, 0x000fe200078ff0ffULL,
0x0000000120237824ULL, 0x100fe200078e0235ULL, 0x000000180c2c7811ULL, 0x000fe200078ff0ffULL,
0x0000000420367824ULL, 0x000fe200078e00ffULL, 0x00000035222f7210ULL, 0x040fe20007ffe0ffULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x000000200c2e7811ULL, 0x040fe200078ff0ffULL,
0x00005e0021207625ULL, 0x080fe200078e000aULL, 0x0000003031317812ULL, 0x000fe400078ec0ffULL,
0x000000280c307811ULL, 0x000fe200078ff0ffULL, 0x000000012c2d7824ULL, 0x000fe200078e0235ULL,
0x000000300c327811ULL, 0x000fe200078ff0ffULL, 0x000000042c2c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc223d7812ULL, 0x000fe200078ee209ULL, 0x000000012e337824ULL, 0x000fe200078e0235ULL,
0x0000003120207210ULL, 0x000fe20007f1e0ffULL, 0x00005e0023227625ULL, 0x000fe200078e000aULL,
0x000000380c347811ULL, 0x000fc400078ff0ffULL, 0x000000022e2e7819ULL, 0x000fe200000006ffULL,
0x0000000130377824ULL, 0x100fe200078e0235ULL, 0x00000035343b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000132397824ULL, 0x000fe200078e0235ULL, 0xfffffffc2c3f7812ULL, 0x000fe200078ee209ULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0xfffffffc2e417812ULL, 0x100fe200078ee209ULL,
0x0000000430307824ULL, 0x000fe200078e00ffULL, 0x0000003122227210ULL, 0x080fe20007f1e0ffULL,
0x0000000432327824ULL, 0x000fe200078e00ffULL, 0xfffffffc36357812ULL, 0x100fe200078ee209ULL,
0x0000000434347824ULL, 0x000fe200078e00ffULL, 0xfffffffc30437812ULL, 0x100fe200078ee209ULL,
0x00005e002f2e7625ULL, 0x080fe200078e000aULL, 0xfffffffc32457812ULL, 0x100fe200078ee209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000200f7faeULL, 0x0003e2000b901c46ULL,
0xfffffffc34477812ULL, 0x000fe200078ee209ULL, 0x00005e002d2c7625ULL, 0x000fe200078e000aULL,
0x000000312e2e7210ULL, 0x000fc40007f3e0ffULL, 0x000000583d3d7211ULL, 0x080fe200078e20ffULL,
0x000000ffff237224ULL, 0x000fe200000e0623ULL, 0x000000312c2c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001035097824ULL, 0x000fe200078e0258ULL, 0x0000005845457211ULL, 0x000fe200078e20ffULL,
0x00005e0033327625ULL, 0x080fe200078e000aULL, 0x0000002dff2d7210ULL, 0x000fe400007fe4ffULL,
0x0000000022097faeULL, 0x0003e2000b901c46ULL, 0x00005e0037347625ULL, 0x000fe200078e000aULL,
0x0000003132307210ULL, 0x000fc60007f1e0ffULL, 0x00005e0039367625ULL, 0x000fc800078e000aULL,
0x00005e003b387625ULL, 0x000fc800078e000aULL, 0x000000ffff2f7224ULL, 0x000fe200008e062fULL,
0x0000003134327210ULL, 0x080fe20007f3e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0258ULL,
0x0000003136347210ULL, 0x080fe20007f5e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0258ULL,
0x0000003138367210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e0633ULL,
0x000000002e3d7faeULL, 0x0003e2000b901c46ULL, 0x0000001043437824ULL, 0x100fe400078e0258ULL,
0x000000ffff337224ULL, 0x000fe200008e0635ULL, 0x000000002c3f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff357224ULL, 0x000fe200010e0637ULL, 0x00000039ff377210ULL, 0x000fe20001ffe4ffULL,
0x0000001047477824ULL, 0x000fe200078e0258ULL, 0x0000000030417faeULL, 0x0003e8000b901c46ULL,
0x0000000032437faeULL, 0x0003e8000b901c46ULL, 0x0000000034457faeULL, 0x0003e8000b901c46ULL,
0x0000000036477faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001c080a7810ULL, 0x000fc40007ffe0ffULL,
0x0000001e08087810ULL, 0x000fe40007ffe0ffULL, 0x000000070a0a7812ULL, 0x100fe400078e7807ULL,
0x0000000708087812ULL, 0x000fc600078e7807ULL, 0x00000020070a7824ULL, 0x040fe400078e020aULL,
0x0000002007087824ULL, 0x000fe400078e0208ULL, 0x000000100a0a7824ULL, 0x000fc600078e00ffULL,
0x0000000408087819ULL, 0x000fe200000006ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000e20783bULL, 0x002fe80000000200ULL, 0x000000000a2c783bULL, 0x000e680000000200ULL,
0x000000000d30783bULL, 0x000ea80000000200ULL, 0x000000000634783bULL, 0x000ee80000000200ULL,
0x000000000538783bULL, 0x000fe80000000200ULL, 0x000000000440783bULL, 0x000fe80000000200ULL,
0x00000000083c783bULL, 0x000fe80000000200ULL, 0x000000000344783bULL, 0x000fe80000000200ULL,
0x000000000048783bULL, 0x000fe80000000200ULL, 0x014614005b067984ULL, 0x000f220000000800ULL,
0x000000202c24723cULL, 0x042ff00000041824ULL, 0x000000222c50723cULL, 0x040fe20000041850ULL,
0x000000000220783bULL, 0x00036e0000000200ULL, 0x000000322c10723cULL, 0x004fe20000041810ULL,
0x0000ffff59027812ULL, 0x002fc800078ec0ffULL, 0x0000888002077816ULL, 0x000fc600000000ffULL,
0x000000342c14723cULL, 0x008fe40000041814ULL, 0x8000000007057824ULL, 0x000fcc00078e00ffULL,
0x000000362c18723cULL, 0x000fe20000041818ULL, 0x8000000006ff7812ULL, 0x010fce0007804805ULL,
0x000000382c1c723cULL, 0x040ff0000004181cULL, 0x000000302c4c723cULL, 0x040ff0000004184cULL,
0x0000003a2c28723cULL, 0x000ff00000041828ULL, 0x000000403c24723cULL, 0x040ff00000041824ULL,
0x000000463c10723cULL, 0x040ff00000041810ULL, 0x000000203c14723cULL, 0x060ff00000041814ULL,
0x000000223c18723cULL, 0x000fe20000041818ULL, 0x3d80000024037820ULL, 0x000fe20000410000ULL,
0x3d80000025087820ULL, 0x000fe20000410000ULL, 0x3d80000026207820ULL, 0x000fe20000410000ULL,
0x3d80000027217820ULL, 0x000fc80000410000ULL, 0x000000483c1c723cULL, 0x000fe2000004181cULL,
0x3d800000100f7820ULL, 0x000fe20000410000ULL, 0x3d80000011107820ULL, 0x000fe20000410000ULL,
0x3d80000012007820ULL, 0x000fe20000410000ULL, 0x3d80000013237820ULL, 0x000fc80000410000ULL,
0x000000423c50723cULL, 0x000fe20000041850ULL, 0x3d80000016247820ULL, 0x000fe20000410000ULL,
0x3d80000014117820ULL, 0x000fe20000410000ULL, 0x3d80000015127820ULL, 0x000fe20000410000ULL,
0x3d80000017177820ULL, 0x000fc80000410000ULL, 0x000000443c4c723cULL, 0x000fe2000004184cULL,
0x3d80000019167820ULL, 0x000fe20000410000ULL, 0x3d8000001a027820ULL, 0x000fe20000410000ULL,
0x3d80000018137820ULL, 0x000fe20000410000ULL, 0x3d8000001b1b7820ULL, 0x000fc80000410000ULL,
0x0000004a3c28723cULL, 0x000fe20000041828ULL, 0x3d8000001c197820ULL, 0x000fe20000410000ULL,
0x3d8000001d1a7820ULL, 0x000fe20000410000ULL, 0x3d8000001e157820ULL, 0x000fe20000410000ULL,
0x3d8000001f047820ULL, 0x000fc80000410000ULL, 0x3d80000050097820ULL, 0x000fe20000410000ULL,
0x3d800000510a7820ULL, 0x000fe20000410000ULL, 0x3d80000052227820ULL, 0x000fe20000410000ULL,
0x3d80000053257820ULL, 0x000fca0000410000ULL, 0x3d8000004c0d7820ULL, 0x000fe20000410000ULL,
0x3d8000004d0e7820ULL, 0x000fe20000410000ULL, 0x3d8000004e267820ULL, 0x000fe20000410000ULL,
0x3d8000004f277820ULL, 0x000fca0000410000ULL, 0x3d800000281c7820ULL, 0x000fe20000410000ULL,
0x3d800000291d7820ULL, 0x000fe20000410000ULL, 0x3d8000002a187820ULL, 0x000fe20000410000ULL,
0x3d8000002b147820ULL, 0x000fe20000410000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0017ULL,
0x00000002001f7202ULL, 0x000fe20000000f00ULL, 0x000000ffff287224ULL, 0x000fe400078e0000ULL,
0x000000ffff177224ULL, 0x000fe200078e0004ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000007077824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x014614005b027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000020c007819ULL, 0x000fe200000006ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x0000005a6100720cULL, 0x000fe40003f05270ULL, 0xfffffff000027812ULL, 0x000fca00078ec0ffULL,
0x000000805f027824ULL, 0x000fca00078e0202ULL, 0x0144000002047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000020c297824ULL, 0x000fe400078e00ffULL,
0x00000001602c7824ULL, 0x000fc600078e0a0bULL, 0x0000000629297812ULL, 0x000fc800078ec0ffULL,
0x00000001290b7812ULL, 0x040fe400078efcffULL, 0x00000008292a7812ULL, 0x000fe400078efcffULL,
0x0000002c0b00720cULL, 0x080fe40003f26070ULL, 0x00000010290b7812ULL, 0x000fe400078efcffULL,
0x0000002c2a00720cULL, 0x080fe40003f06070ULL, 0x0000002c0b00720cULL, 0x000fc40003fc6070ULL,
0x00000011292a7812ULL, 0x040fe400078efcffULL, 0x00000018290b7812ULL, 0x040fe400078efcffULL,
0x0000002c2900720cULL, 0x080fe40003f46070ULL, 0x0000002c2a00720cULL, 0x080fe40003fa6070ULL,
0x0000002c0b00720cULL, 0x000fe40003f66070ULL, 0x00000009292b7812ULL, 0x000fc400078efcffULL,
0x00000019292a7812ULL, 0x040fe400078efcffULL, 0x00000020290b7812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff03037808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff08087808ULL, 0x000fc40004800000ULL,
0x0000002c2b00720cULL, 0x080fe40003f86070ULL, 0x0000002c2a00720cULL, 0x080fe40003f46070ULL,
0x0000002c0b00720cULL, 0x000fe40003f26070ULL, 0x00000021292a7812ULL, 0x040fe400078efcffULL,
0x00000028290b7812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fc40004000000ULL,
0xff7fffff09097808ULL, 0x000fe40004000000ULL, 0xff7fffff25257808ULL, 0x000fe40006000000ULL,
0xff7fffff0a0a7808ULL, 0x000fe40006000000ULL, 0x0000002c2a00720cULL, 0x080fe40003f06070ULL,
0x0000002c0b00720cULL, 0x000fe40003f86070ULL, 0x00000029292a7812ULL, 0x000fc400078efcffULL,
0x00000030290b7812ULL, 0x000fe400078efcffULL, 0xff7fffff26267808ULL, 0x000fe40007000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40007000000ULL, 0xff7fffff27277808ULL, 0x000fe40006800000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40006800000ULL, 0x0000002c2a00720cULL, 0x000fc40003fc6070ULL,
0x0000002c0b00720cULL, 0x000fe40003fa6070ULL, 0x00000031292a7812ULL, 0x040fe400078efcffULL,
0x00000038290b7812ULL, 0x040fe400078efcffULL, 0x0000003929297812ULL, 0x000fe400078efcffULL,
0xff7fffff28287808ULL, 0x000fe40005800000ULL, 0xff7fffff0f0f7808ULL, 0x000fc40005800000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff10107808ULL, 0x000fe40005000000ULL,
0xff7fffff24247808ULL, 0x000fe40004800000ULL, 0xff7fffff11117808ULL, 0x000fe40004800000ULL,
0x0000002c2a00720cULL, 0x080fe40003f66070ULL, 0x0000002c0b00720cULL, 0x000fc40003f46070ULL,
0x0000002c2900720cULL, 0x000fe40003f26070ULL, 0xff7fffff1e1e7808ULL, 0x000fe40004000000ULL,
0xff7fffff12127808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff13137808ULL, 0x000fe40006000000ULL, 0xff7fffff1b1b7808ULL, 0x000fc40007000000ULL,
0xff7fffff16167808ULL, 0x000fe40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40006800000ULL,
0xff7fffff19197808ULL, 0x000fe40006800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40005800000ULL, 0xff7fffff18187808ULL, 0x000fc40005000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff14147808ULL, 0x000fe40004800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000003040b7209ULL, 0x004fe20007810000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x00000020052a7209ULL, 0x000fe40007810000ULL, 0x000000080b047209ULL, 0x000fe40007810000ULL,
0x000000212a057209ULL, 0x000fc40007810000ULL, 0x00000009040b7209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fe40007810000ULL, 0x0000000a0b2a7209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fe40007810000ULL, 0x0000000d2a0b7209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fc40007810000ULL, 0x0000000e0b2a7209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x0000000f2a0b7209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x000000100b2a7209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fc40007810000ULL, 0x000000112a0b7209ULL, 0x000fe40007810000ULL,
0x0000002405057209ULL, 0x000fe40007810000ULL, 0x000000120b047209ULL, 0x000fe40007810000ULL,
0x0000001e052a7209ULL, 0x000fe40007810000ULL, 0x0000001304057209ULL, 0x000fe40007810000ULL,
0x0000001f2a2a7209ULL, 0x000fc40007810000ULL, 0x0000001605047209ULL, 0x000fe40007810000ULL,
0x0000001b2a2a7209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x000000152a2a7209ULL, 0x000fe40007810000ULL, 0x0000001a05057209ULL, 0x000fe40007810000ULL,
0x000000172a0b7209ULL, 0x000fc40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x000000180b0b7209ULL, 0x000fe40007810000ULL, 0x0000001f00307802ULL, 0x000fe40000000f00ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x000000140b2d7209ULL, 0x000fe20007810000ULL,
0x00000dc27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x00000004052f7209ULL, 0x008fe20007810000ULL, 0x00000df27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x004ea800000e0000ULL,
0x0c401f00072a7f89ULL, 0x000f2200000e0000ULL, 0x000000042d0b7209ULL, 0x008fc60007810000ULL,
0x0c201f002f047f89ULL, 0x000ee200000e0000ULL, 0x00000005062b7209ULL, 0x004fc60007810000ULL,
0x0c201f000b2c7f89ULL, 0x002e6200000e0000ULL, 0x0000002a07297209ULL, 0x010fc60007810000ULL,
0x0c201f002b2e7f89ULL, 0x000ea800000e0000ULL, 0x0c201f00292a7f89ULL, 0x00092200000e0000ULL,
0x000000042f047209ULL, 0x008fe40007810000ULL, 0x0000002c0b057209ULL, 0x002fe40007810000ULL,
0x0000002e2b067209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b05337820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b25257823ULL, 0x000fe20000010833ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010833ULL, 0x0000000a000a7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b28287823ULL, 0x000fe20000010833ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010833ULL, 0x00000010002e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1b1b7823ULL, 0x000fe20000010833ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1d077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b18187823ULL, 0x000fe20000010833ULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x000000090a0a723eULL, 0x004fce00000010ffULL, 0x0000000800087308ULL, 0x000eb00000000800ULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x000000030808723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b23037823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b14337823ULL, 0x000fe20000010833ULL, 0x0000000fff147424ULL, 0x000fc800078e00ffULL,
0x00000022000b7308ULL, 0x000ff00000000800ULL, 0x0000002500107308ULL, 0x000ea20000000800ULL,
0x000000202109723eULL, 0x008fce00000010ffULL, 0x0000000e002c7308ULL, 0x0023f00000000800ULL,
0x0000000f002b7308ULL, 0x0007e20000000800ULL, 0x00000004000e7c02ULL, 0x002fe20008000f00ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000b100b723eULL, 0x004fe200000010ffULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3f8000000e0e783eULL, 0x000fc600000010ffULL,
0x00000011002d7308ULL, 0x000fe40000000800ULL, 0x000000ffff0f7224ULL, 0x008fcc00078e000eULL,
0x00000013002f7308ULL, 0x000fe20000000800ULL, 0x0000000e0820723cULL, 0x000fee00000418ffULL,
0x0000001c00317308ULL, 0x000ff00000000800ULL, 0x0000002600117308ULL, 0x000ff00000000800ULL,
0x0000000d000d7308ULL, 0x000e700000000800ULL, 0x00000027001c7308ULL, 0x000eb00000000800ULL,
0x0000002800137308ULL, 0x000fe20000000800ULL, 0x0000000d2c10723eULL, 0x002fce00000010ffULL,
0x0000000300267308ULL, 0x0002e20000000800ULL, 0x000000111c11723eULL, 0x004fce00000010ffULL,
0x0000001200307308ULL, 0x0005620000000800ULL, 0xfffffffc0c037812ULL, 0x002fc800078ec0ffULL,
0x0000000314037219ULL, 0x000fe400000006ffULL, 0x000000132613723eULL, 0x008fe200000010ffULL,
0x00000024001d7308ULL, 0x000fe20000000800ULL, 0x0000002b2e12723eULL, 0x004fe200000010ffULL,
0x00000000030473c4ULL, 0x000e620000004000ULL, 0x0000002d301c723eULL, 0x020fca00000010ffULL,
0x0000000e1020723cULL, 0x000fe20000041820ULL, 0x0000001600167308ULL, 0x000eb00000000800ULL,
0x0000001e00287308ULL, 0x0004f00000000800ULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x0000002f161e723eULL, 0x004fce00000010ffULL, 0x0000001b00247308ULL, 0x000ea20000000800ULL,
0x0000001d281d723eULL, 0x008fce00000010ffULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x0000001f241f723eULL, 0x004fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x00000000032473a1ULL, 0x000ee200000e8000ULL, 0x0000000e1c20723cULL, 0x000fec0000041820ULL,
0x0000000700327308ULL, 0x000b300000000800ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x000000191a14723eULL, 0x004fc400000010ffULL, 0x000000292a077209ULL, 0x030fca0007810000ULL,
0x0000001700267308ULL, 0x000ea20000000800ULL, 0x000000313216723eULL, 0x000fe400000010ffULL,
0x0000000503ff7c12ULL, 0x008fca000f804024ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000003300337308ULL, 0x000ee20000000800ULL, 0x000000152615723eULL, 0x004fe400000010ffULL,
0x000000183317723eULL, 0x008fce00000010ffULL, 0x0000000e1420723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000091204008947ULL, 0x002fde000b800000ULL,
0x001c1fff20187589ULL, 0x0002a400000e0000ULL, 0x00000000030e73a1ULL, 0x000ee200000e8000ULL,
0x00000000030473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000503ff7c12ULL, 0x008fda000f80400eULL, 0x0000092204008947ULL, 0x010fea000b800000ULL,
0x001c1fff22197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff037819ULL, 0x00afe4000001160cULL,
0x0000000c00317812ULL, 0x000fc400078ec0ffULL, 0x00000007030d7812ULL, 0x040fe200078ec0ffULL,
0x0000000803207824ULL, 0x040fe200078e00ffULL, 0x00000003030e7819ULL, 0x040fe200000006ffULL,
0x00000008032e7824ULL, 0x040fe200078e00ffULL, 0x00000003ff0f7212ULL, 0x000fe400078e33ffULL,
0x0000000803037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x100fe400078ee20dULL,
0x0000000120227812ULL, 0x140fe200078ef60dULL, 0x00000008033e7824ULL, 0x000fe200078e00ffULL,
0x0000000220247812ULL, 0x000fc400078ef60dULL, 0x0000000320267812ULL, 0x140fe400078ef60dULL,
0x0000000420287812ULL, 0x140fe400078ef60dULL, 0x00000005202a7812ULL, 0x140fe400078ef60dULL,
0x00000006202c7812ULL, 0x000fe200078ef60dULL, 0x0000000803207824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee20fULL, 0x00000003ff0f7212ULL, 0x000fc400078e33ffULL,
0x00000007030d7812ULL, 0x040fe400078ec0ffULL, 0x0000000303307819ULL, 0x000fe400000006ffULL,
0x0000a0005f037811ULL, 0x000fe400078e58ffULL, 0xfffffff830307812ULL, 0x000fe400078ee20dULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20fULL, 0x000000100e007824ULL, 0x000fe200078e0203ULL,
0x0000000220347812ULL, 0x000fe200078ef60dULL, 0x00000010220e7824ULL, 0x000fe200078e0203ULL,
0x0000000320367812ULL, 0x000fe200078ef60dULL, 0x0000001028227824ULL, 0x000fe200078e0203ULL,
0x0000000420387812ULL, 0x000fe200078ef60dULL, 0x000000102e287824ULL, 0x000fe200078e0203ULL,
0x00000006203c7812ULL, 0x000fe200078ef60dULL, 0x00000010342b7824ULL, 0x000fe200078e0203ULL,
0x0000000120327812ULL, 0x000fe200078ef60dULL, 0x00000010382d7824ULL, 0x000fe200078e0203ULL,
0x00000005203a7812ULL, 0x000fe200078ef60dULL, 0x0000001026207824ULL, 0x100fe200078e0203ULL,
0x00000003240f7211ULL, 0x080fe200078e20ffULL, 0x00000001310d7824ULL, 0x040fe200078e0200ULL,
0x000000032c267211ULL, 0x080fe200078e20ffULL, 0x000000102a247824ULL, 0x100fe200078e0203ULL,
0x00000003322a7211ULL, 0x080fe200078e20ffULL, 0x0000001030007824ULL, 0x100fe200078e0203ULL,
0x000000033a2e7211ULL, 0x000fe200078e20ffULL, 0x00000010362c7824ULL, 0x100fe200078e0203ULL,
0x0000000f310f7210ULL, 0x040fe20007ffe0ffULL, 0x000000103c2f7824ULL, 0x100fe200078e0203ULL,
0x000000080d007388ULL, 0x0003e20000000800ULL, 0x000000103e307824ULL, 0x000fe200078e0203ULL,
0x0000002631277210ULL, 0x040fe20007ffe0ffULL, 0x0000000131037824ULL, 0x040fe200078e020eULL,
0x000000030cff7812ULL, 0x000fe2000780c0ffULL, 0x0000000131217824ULL, 0x040fe200078e0220ULL,
0x0000002b310e7210ULL, 0x040fe20007ffe0ffULL, 0x0000000131237824ULL, 0x040fe200078e0222ULL,
0x0000000a03007388ULL, 0x0007e20000000800ULL, 0x0000000131257824ULL, 0x040fe200078e0224ULL,
0x0000002f31207210ULL, 0x040fe20007ffe0ffULL, 0x0000000131297824ULL, 0x040fe200078e0228ULL,
0x000000100f007388ULL, 0x0007e20000000800ULL, 0x0000000131007824ULL, 0x000fc400078e0200ULL,
0x00000001312a7824ULL, 0x040fe200078e022aULL, 0x0000001221007388ULL, 0x0007e20000000800ULL,
0x00000001312c7824ULL, 0x040fe400078e022cULL, 0x0000000131087824ULL, 0x042fe200078e022dULL,
0x0000001c23007388ULL, 0x0007e20000000800ULL, 0x00000001312e7824ULL, 0x040fe400078e022eULL,
0x0000000131307824ULL, 0x000fe200078e0230ULL, 0x0000001e25007388ULL, 0x0007e80000000800ULL,
0x0000001427007388ULL, 0x0007e80000000800ULL, 0x0000001629007388ULL, 0x0007e80000000800ULL,
0x0000000900007388ULL, 0x0007e80000000800ULL, 0x0000000b2a007388ULL, 0x0007e80000000800ULL,
0x000000110e007388ULL, 0x0007e80000000800ULL, 0x000000132c007388ULL, 0x0007e80000000800ULL,
0x0000001d08007388ULL, 0x0007e80000000800ULL, 0x0000001f2e007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001730007388ULL, 0x0007e80000000800ULL,
0x0140000402008388ULL, 0x0007e80000000c00ULL, 0x0142001802008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000005d5400720cULL, 0x000fe20003f26070ULL,
0x014608005bff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff59ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff617224ULL, 0x000fc600078e0054ULL, 0x00000001ff597807ULL, 0x000fce0000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffff888000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0005ULL,
0x00015750002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2c7424ULL, 0x000fe400078e00ffULL,
0x0000054000007944ULL, 0x002fea0003c00000ULL, 0x0000000b00047202ULL, 0x004fe20000000f00ULL,
0xfffff1f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0b7224ULL, 0x000fe200078e002dULL,
0x000157b0002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2c7424ULL, 0x002fe400078e00ffULL,
0x000004e000007944ULL, 0x004fea0003c00000ULL, 0x0000000b2d2e7209ULL, 0x004fe20007810000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0006ULL, 0x00000002002c7802ULL, 0x002fe40000000f00ULL,
0x00015800002a7802ULL, 0x000fe40000000f00ULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000000b06067209ULL, 0x004fe20007810000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0007ULL,
0x00015850002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2c7424ULL, 0x002fc400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000000b07297209ULL, 0x004fe20007810000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e002fULL, 0x00000001002c7802ULL, 0x002fc40000000f00ULL,
0x000158a0002a7802ULL, 0x000fe40000000f00ULL, 0x000003f000007944ULL, 0x000fea0003c00000ULL,
0x0000000b2f047209ULL, 0x004fe20007810000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e002eULL,
0x000158f0002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2c7424ULL, 0x002fe400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x0000000b2e057209ULL, 0x004fe20007810000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0006ULL, 0x00000001002c7802ULL, 0x002fe40000000f00ULL,
0x00015940002a7802ULL, 0x000fe40000000f00ULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0x0000000b06067209ULL, 0x004fe20007810000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0029ULL,
0x00015990002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2c7424ULL, 0x002fc400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x004fe200078e000bULL,
0xfffff0a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0d7224ULL, 0x000fe200078e0020ULL,
0x000000ff00207202ULL, 0x000fe20000000f00ULL, 0x00001c1fff217424ULL, 0x000fe200078e00ffULL,
0x00015a00000e7802ULL, 0x000fc40000000f00ULL, 0x000002d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e001bULL, 0xfffff69000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0d7224ULL, 0x002fe200078e0022ULL, 0x000000ff00207202ULL, 0x000fe20000000f00ULL,
0x00001c1fff217424ULL, 0x000fe200078e00ffULL, 0x00015a70000e7802ULL, 0x000fc40000000f00ULL,
0x0000026000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff207224ULL, 0x002fe200078e00ffULL,
0x0000001b00197202ULL, 0x004fe20000000f00ULL, 0x00001c1fff217424ULL, 0x000fe200078e00ffULL,
0x00015ac0000e7802ULL, 0x000fc40000000f00ULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff207224ULL, 0x002fe200078e00ffULL, 0x00015b10000e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff217424ULL, 0x000fc400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e001bULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xfffff61000007947ULL, 0x000fea000383ffffULL,
0x0180000027057810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000005067812ULL, 0x000fc800078ec0ffULL, 0x018000000600780cULL, 0x000fda0003f05070ULL,
0x0000002700058308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0600720cULL, 0x040fe40003f25070ULL, 0x008000000600780cULL, 0x000fe40003f02070ULL,
0x00000001ff067807ULL, 0x000fe40000800000ULL, 0x00000001ff057807ULL, 0x004fc80004000000ULL,
0x0000000506ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff27ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff057807ULL, 0x000fc80000000000ULL,
0x0000000506ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000027067812ULL, 0x000fd600078ec0ffULL,
0x0080000006050812ULL, 0x000fe200078efcffULL, 0x000000ffff058224ULL, 0x000fe200078e0006ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002700057308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000297802ULL, 0x000fc80000000f00ULL,
0xfffea37028007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2b7424ULL, 0x000fe200078e00ffULL,
0x0000003100007348ULL, 0x000fe80003800000ULL, 0x0c00002c0b0b7389ULL, 0x0002a200000e0030ULL,
0xfffea3302a007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000300007348ULL, 0x000fe80003800000ULL, 0x000000200d1b7389ULL, 0x0002a200000e0021ULL,
0xfffea2f00e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000014680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000004bcULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ca4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cc8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000cd8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000cf8ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d68ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d70ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000d80ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000015e00ULL, 0x7600001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016d80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000016d90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016d90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017210ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000d68ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016018ULL, 0x0000000000016018ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016d80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017210ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_256_beam_1_kvt_bf16_nqpkv_16_m_16_sm_86_cubin_len = 94960;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
